﻿USE sofia;
DROP TABLE IF EXISTS sofia.mirNT_vpl;
CREATE TABLE mirNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mirNT_vpl WRITE;
INSERT INTO mirNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yaa jaduhṉ myiṉ̃ cujaay nebiaty jaꞌa Jesús yhap tieedyhajxy jecy xiøhajty. Abraham xiøhajty jaꞌa jawyiinhájtäbä. David xiøhajty jaꞌa cujecy jaac míiṉäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Jaꞌa Abraham yhuung, Isaac jeꞌe xiøhajty. Jaꞌa Isaac yhuung, Jacob jeꞌe xiøhajty. Jaꞌa Jacob yhuung tuꞌug, Judá jeꞌe xiøhajty. May jaꞌa Judá jaꞌa piuhyaꞌay hänajty miøødä. ");
INSERT INTO mirNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jaꞌa Judá yhuunghajxy, Fares hajxy xiøhajty møødä Zara. Jaꞌa Fares tiajhajxy, Tamar jeꞌe xiøhajty. Jaꞌa Fares yhuung, Esrom jeꞌe xiøhajty. Jaꞌa Esrom yhuung, Aram jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Jaꞌa Aram yhuung, Aminadab jeꞌe xiøhajty. Jaꞌa Aminadab yhuung, Naasón jeꞌe xiøhajty. Jaꞌa Naasón yhuung, Salmón jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Jaꞌa Salmón yhuung, Booz jeꞌe xiøhajty. Jaꞌa Booz tiaj, Rahab jeꞌe xiøhajty. Jaꞌa Booz yhuung, Obed jeꞌe xiøhajty. Jaꞌa Obed tiaj, Rut jeꞌe xiøhajty. Jaꞌa Obed yhuung, Isaí jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jaꞌa Isaí yhuung, David jeꞌe xiøhajty. Mänitä David tiägøøyy gobiernähajpä. Mänitä Urías yajyaghoꞌcä mänaa jaꞌa tsip jiadyiijän. Coo jaꞌa Urías yhoꞌcy, mänitä David jaꞌa Urías tioꞌoxiøjc wyiingpøjcä. Mänitä David yaghuungpaaty. Salomón jaꞌa yhuung hajxy yajxøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jaꞌa Salomón yhuung, Roboam jeꞌe xiøhajty. Jaꞌa Roboam yhuung, Abías jeꞌe xiøhajty. Jaꞌa Abías yhuung, Asa jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jaꞌa Asa yhuung, Josafat jeꞌe xiøhajty. Jaꞌa Josafat yhuung, Joram jeꞌe xiøhajty. Jaꞌa Joram yhuung, Uzías jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jaꞌa Uzías yhuung, Jotam jeꞌe xiøhajty. Jaꞌa Jotam yhuung, Acaz jeꞌe xiøhajty. Jaꞌa Acaz yhuung, Ezequías jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Jaꞌa Ezequías yhuung, Manasés jeꞌe xiøhajty. Jaꞌa Manasés yhuung, Amón jeꞌe xiøhajty. Jaꞌa Amón yhuung, Josías jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jaꞌa Josías yhuung tuꞌug, Jeconías jeꞌe xiøhajty. Jim̱ä Jeconías jaꞌa piuhyaꞌay hänajty miøødä. Mänitä judíoshajxy hadsip yajnøcxä jäguem̱ Babilonia‑naaxooty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jim̱ hajxy chänaadiaacpøjcy Babilonia. Jim̱ä Jeconías jaꞌa yhuung yajxøhajty Salatiel. Jaꞌa Salatiel yhuung, Zorobabel jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jaꞌa Zorobabel yhuung, Abiud jeꞌe xiøhajty. Jaꞌa Abiud yhuung, Eliaquim jeꞌe xiøhajty. Jaꞌa Eliaquim yhuung, Azor jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Jaꞌa Azor yhuung, Sadoc jeꞌe xiøhajty. Jaꞌa Sadoc yhuung, Aquim jeꞌe xiøhajty. Jaꞌa Aquim yhuung, Eliud jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Jaꞌa Eliud yhuung, Eleazar jeꞌe xiøhajty. Jaꞌa Eleazar yhuung, Matán jeꞌe xiøhajty. Jaꞌa Matán yhuung, Jacob jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jaꞌa Jacob yhuung, José jeꞌe xiøhajty. Coo jaꞌa María yhuung hänajty tøø myiṉ̃ tøø quiaꞌay, jaꞌa Jesúshajpä, mänitä José jaꞌa María wyiingpøjcy. Jaꞌa Jesús, Cristo jeꞌe xiøhajty; paady yaa quiejxä hädaa yaabä naax̱wiin maa højtscøxpän. ");
INSERT INTO mirNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nämajmacts jaꞌa Jesús jaꞌa yhap jaꞌa tieedy hänajty miøødä, møødä Abraham møødä David. Y jaac nämajmacts jaꞌa yhap jaꞌa tieedy hänajty miøødä, møødä Salomón møødä Jeconías. Mänitä judíoshajxy yajnøcxä Babilonia‑naaxooty. Y jaac nämajmacts jaꞌa Jesús jaꞌa yhap jaꞌa tieedy hänajty miøødä, møødä Salatiel møødä José. Mänitä Cristo myiiṉ̃guiahy. ");
INSERT INTO mirNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yaa jaduhṉ myiṉ̃ cujaay nebiä Jesucristo myiiṉ̃guiahyyän. Jaꞌa Jesucristo tiaj, María hänajty jeꞌe xiøhaty. Tøø hänajty tiødiägøꞌøy coo jaꞌa Maríahajxy hänajty piøgaꞌañ møødä José. Pero cajnä hajxy hänajty piøcyñä, mänitä María quiähxøꞌcy coo hänajty yhuungmøødä. Jaꞌa Dioshespírituhaam hänajty tøø yhuungpaady. ");
INSERT INTO mirNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jaduhṉ jaꞌa judíoshajxy hänajty quiuhdujthaty, coo jaꞌa toꞌoxiøjc yhuungpáadät jabiøcy, mänit jaduhṉ yhøxmájtsänät. Pero miøød jaꞌa José hojioot hänajty; cabä María hänajty ñäxøꞌøwøꞌøwaꞌañ. Mänitä José wyiinmahñdyhajty coo jaꞌa María yhøxmádsät hameeꞌch, nebiä María jaduhṉ quiaꞌa yajtsähdiúnät. ");
INSERT INTO mirNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yhuuc wiinmahñdyhajpy jaꞌa José hänajty, mänit miaahoꞌcy. Mänitä Diosmoonsä wyiinhijxy cumaꞌayhaam. Tsajpootyp hänajty chooñ. Mänitä José ñämaayyä: ―José, David miic̈h hijty mhaphajpy mdeedyhajpy. Caꞌa mdajy caꞌa mmay. Hoy jaduhṉ coo jaꞌa María mwiingpǿgät. Dioshespírituhaam jaduhṉ tøø yhuungpaady. ");
INSERT INTO mirNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yaꞌayhänaꞌc jaduhṉ yhuunghadaam̱by, jaꞌa Jesúshajpä. Coo jaꞌa quiuꞌug jaꞌa piojpä quiädieey yajnähwaꞌadsaaṉä, paady jaduhṉ xiøhataꞌañ Jesús. ");
INSERT INTO mirNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Coo jaꞌa José miaꞌabiädøꞌcy, mänit quiudiuuṉ̃ neby hänajty tøø ñämaꞌayíijäm jaꞌa Diosmóonsäm. Mänitä María wyiingpøjcy. Pero cab hajxy ñimiøødmaaw̱ä høxtä coonä jaꞌa María jaꞌa Jesús yajmiṉ̃ñä. Jaꞌa coobhuung, jeꞌeds jaduhṉ miiṉgahw̱. Jesús jaduhṉ xiøhajty. Coo jaꞌa Jesús jaduhṉ myiiṉ̃guiahy, tøjiajt jaꞌa Diosmädiaꞌagy jaduhṉ nebiä Diosmädiaꞌagy‑yajwaꞌxpähajxy jecy quiujahyyän: Huungpaadaam̱b jaꞌa cäxyiihänaꞌc tuꞌug. Yaꞌayhänaꞌc yhuunghadaam̱by. Jueꞌe xiøhataꞌañ, Emanuel. Jeꞌeduhṉ ñänøøm̱by coo jaꞌa Dios hajxy xmiøødhájtäm. ");
INSERT INTO mirNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jaꞌa Jesús, jim̱ jaduhṉ myiiṉ̃guiahy maa jaꞌa cajpt jaduhṉ xiøhatiän Belén, jim̱ Judeanaaxooty. Jaꞌa Herodes, jeꞌe hänajty tuum̱b gobiernä. Jim̱ jeꞌe hänajty chänaꞌay maa jaꞌa møjcajptän Jerusalén. Mänitä jäyaꞌayhajxy jim̱ näjeꞌe miejch maa jaꞌa Heródesän. Jäguem̱ hajxy hänajty tøø chooñ maa jaꞌa xøø piädsøm̱iän. Madsaꞌahøxtaabiä hajxy hänajty wiädity. ");
INSERT INTO mirNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mänit hajxy yajtøøyy: ―Maa jaꞌa judíos guiobiernähajxy, jaꞌa tøø myiṉ̃ tøø quiáꞌayäbä. Jäguem̱ højts jaꞌa miadsaꞌa tøø nnäheebøøyyä, jim̱ maa jaꞌa xøø piädsøm̱iän. Paady højts yaa tøø nmiṉ̃ tøø nmech neby højts jaduhṉ nwiingudsähgǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Coo jaꞌa gobiernä Herodes jaduhṉ miädoyhajty møødä Jerusalénpä‑jäyaꞌayhajxy nägøx̱iä, mänit hajxy tiägøøyy tajpä maabiä. ");
INSERT INTO mirNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mänitä Herodes miøjyaax̱y jaꞌa teedywiindsøṉhajxy møødä ley‑yajnahixøøbiähajxy. Mänitä Herodes yajtøøyy: ―Maa jaꞌa Cristo myinaꞌañ quiaꞌawaꞌañ, jaꞌa Dios quiexaam̱biä. ");
INSERT INTO mirNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mänit hajxy yhadsooyy: ―Beléncajptóotiäc jaduhṉ myinaꞌañ quiaꞌawaꞌañ yaa Judeanaaxooty. Jaꞌa Diosmädiaꞌagy‑yajwaꞌxpä jecy cujahy nebiä Dios miänaaṉ̃än: ");
INSERT INTO mirNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Jaꞌa cajpt jaduhṉ xøhajpä Belén, jim̱ Judeanaaxooty, jim̱ä wiindsǿṉ tuꞌug myinaꞌañ quiaꞌawaꞌañ; jeꞌec̈h jaꞌa nguꞌug xyhaneꞌemáaṉäp, jaꞌa judíoshajxy; paadiä Beléncajpt jaduhṉ yajmäbaadaꞌañii nebiä møjcajptän. ");
INSERT INTO mirNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mänitä Herodes miøjyaax̱y hameeꞌch jaꞌa madsaꞌahøxtaabiähajxy. Mänitä Herodes yajtøøyy: ―Mäduhnajtä jaꞌa madsaꞌa quiähxøꞌtsohṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Coo jaꞌa Herodes tøyhajt miooyyä, mänitä miänáaṉgumbä: ―Nøcx jaꞌa pigänaꞌc hajxy jim̱ yajtøw̱ Belén. Nax̱y hajxy hoy mdehm̱ yajtǿwät. Coo mbáadät, mänítøch hajxy miṉ xyhawaaṉä, nébiøch jim̱ nøcxy nwiingudsähgøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Mänitä madsaꞌahøxtaabiähajxy tiuꞌubøjcy. Jim̱ hajxy ñøcxy Belén nebiä Herodes hänajty tøø miänaꞌañän. Mänitä madsaꞌa hajxy jadähooc yhíjxcumbä, jaꞌa hajxy hänajty tøø yhuug hijxpä jäguem̱ maa jaꞌa xøø piädsøm̱iän. Mänit hajxy jiaanc̈h tehm̱ xiooṉdaacy. Mänitä madsaꞌa hajxy piaduꞌubøjcy. Mänitä madsaꞌa jim̱ tøyyä tiänaaxiøjpy maa jaꞌa pigänaꞌc‑huung hänajty yhitiän naax̱yp. Tøyyä jaꞌa madsaꞌa hänajty quiuhjajnax̱y maa hänajty quioꞌnaꞌayän. ");
INSERT INTO mirNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mänitä madsaꞌahøxtaabiähajxy tiøjtägøøyy. Jim̱ä regalo hajxy hänajty miøødä caajäjooty. Mänitä pigänaꞌc‑huung hajxy yhijxy møødä tiaj María. Mänitä pigänaꞌc hajxy wyiinjijcädaacy; wyiingudsähgøøyy hajxy jaduhṉ. Mänitä quiaajä hajxy yaghawaach. Mänitä oro hajxy yajpädsøøm̱y møødä poom møødä mirraperfume. Paꞌagxuuꞌp jeꞌe; tsow̱ ñøcxy. Mänitä pigänaꞌc hajxy jaduhṉ ñäꞌä mooyy. ");
INSERT INTO mirNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mänit hajxy wyiimbijnä. Mänit hajxy ñøcxy maa jaꞌa quiajpthajxiän. Wiingtuum hajxy ñøcxøøñä; cab hajxy jim̱ ñaxøøñä maa jaꞌa Heródesän. Hix̱, tøø hajxy hänajty yhawáaṉäxä cumaꞌayhaam coo hajxy jim̱ quiaꞌa naxǿøñät. ");
INSERT INTO mirNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Coo jaꞌa madsaꞌahøxtaabiähajxy hänajty tøø wyiimbijnä, mänitä José jaꞌa Diosmoonsä tuꞌug wyiinhijxy cumaꞌayhaam, jaꞌa tsajpootypä. Mänitä José ñämaayyä: ―José, pädøꞌøg. Nøcx hajxy jim̱ Egiptonaaxooty møødä mhuung møødä mdoꞌoxy. Jim̱ hajxy mmähmǿꞌøwät høxtä coonä nhawáaṉämät coo hajxy mwiimbídät. Paady hajxy mbäyǿꞌøgät neby yøꞌø mhuung xquiaꞌa yaghóꞌcät. Jaꞌa Herodes, xyhøxtaꞌawáaṉäp yøꞌø mhuung jaduhṉ; xyajyaghoꞌogáaṉäp jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mänitä José piädøꞌcy. Mänitä Joséhajxy jim̱ jiaanc̈h nøcxy Egipto møødä yhuung møødä tioꞌoxy. Mänitcoods hajxy tiehm̱ tiuꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jim̱ hajxy hänajty miähmøꞌøwaꞌañ Egipto. Høxtä jaꞌa Herodes hóꞌogäp, mänit hajxy hänajty wyiimbijtägatsaꞌañ. Jequiän jaꞌa Diosmädiaꞌagy‑yajwaꞌxpä hänajty tuꞌug tøø quiujaay nebiä Dios miänaaṉ̃än: “Nhøxyaax̱pädsøm̱áam̱biøch jaꞌa nhuung jiiby Egiptonaaxooty.” Y coo jaꞌa Joséhajxy jim̱ jiaanc̈h nøcxy Egipto, tøjiajt jaꞌa Diosmädiaꞌagy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Coo jaꞌa Herodes ñajuøøyy coo hänajty tøø wyiinhøøñii jaꞌa madsaꞌahøxtaabiädøjc, mänitä Herodes jiootmaꞌty. Mänitä Herodes jaꞌa pigänaꞌc yajyaghoꞌcä nägøx̱iä, pønjaty jaꞌa mejtsjumøjtpä hänajty caꞌa yaghabejpnä, jaꞌa hajxy hänajty tsänaabiä Belén møødä Belén mäwiingóṉ. Hix̱, tøø hänajty mejtsjumøjt yhijnä coo jaꞌa madsaꞌa quiähxøꞌtsohṉ̃, jaꞌa madsaꞌahøxtaabiädøjc‑hajxy hänajty tøø yhíx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Jaduhṉ jaꞌa Diosmädiaꞌagy tiøjiájcumbä nebiä Jeremías hänajty jecy tøø quiujaayän: Jim̱ maa xiøhatiän Ramá, jim̱ä Raquel jaꞌa yhuung ñäjøøyy ñaxuuꞌch. Coo jaꞌa yhuung yaghóꞌcäxä, paady quiaꞌa jootcapxmøcpøgaaṉä. Jaꞌa Jeremías, jeꞌe jaꞌa Diosmädiaꞌagy jecy yajwaꞌx. ");
INSERT INTO mirNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Coo jaꞌa Herodes yhoꞌnä, jim̱nä jaꞌa Joséhajxy hänajty Egiptonaaxooty. Mänitä José jaꞌa Diosmoonsä tuꞌug wyiinhíjxcumbä cumaꞌayhaam, jaꞌa tsajpootypä. Mänitä José ñämaayyä: ");
INSERT INTO mirNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Pädøꞌøg, wiimbit hajxy møødä mhuung møødä mdoꞌoxy. Nøcx hajxy Israelnaaxooty. Tøø jäyaꞌayhajxy yhoꞌnä, jaꞌa mhuung hajxy hijty xyaghoꞌogáaṉäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mänitä Joséhajxy piädøꞌcy møødä yhuung møødä tioꞌoxy. Mänit hajxy jim̱ jiaanc̈h nøcxy Israelnaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mänitä José miädoyhajty coo Arquelao hänajty guiobiernähajnä jim̱ Judeanaaxooty maa jaꞌa tieedy Herodes hänajty tøø guiobiernähatiän. Mänitä José chähgøøyy. Cab hänajty jim̱ ñøcxaaṉnä Judeanaaxooty. Wiingtuum hajxy ñøcxy Galileanaaxooty, nebiä José hänajty tøø yhawáaṉäxän cumaꞌayhaam. ");
INSERT INTO mirNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Coo hajxy jim̱ miejch Galileanaaxooty, mänit hajxy jim̱ chänaadiaacpøjcy maa jaꞌa cajpt xiøhatiän Nazaret. Coo hajxy jim̱ chänaadiaacpøjcy, tøjiajt jaꞌa Diosmädiaꞌagy jaduhṉ maa jaduhṉ myiṉ̃än cujaay coo jaꞌa Jesús hänajty ñämaꞌawaꞌañii coo jim̱ chooñ Nazaret. Jaꞌa Diosmädiaꞌagy‑yajwaꞌxpähajxy jaduhṉ jecy cujahy. ");
INSERT INTO mirNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Cujecy jaꞌa Juan jaꞌa mäyajnäbejpä jim̱ miejch Judeanaaxooty pactuum. Jaꞌa Diosmädiaꞌagy hänajty yajwaꞌxyp. ");
INSERT INTO mirNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mänitä Juan tiägøøyy mädiaacpä. Mänit miänaaṉ̃: ―Najtshixøꞌøw jaꞌa mhaxøøgcuhdujt hajxy; habaadáaṉnäp jaduhṉ coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jaꞌa Isaías, jaꞌa Diosmädiaꞌagy jecy yajwáꞌxäbä, jeꞌe hänajty jaduhṉ jecy tøø quiujaay: Jim̱ä jäyaꞌay tuꞌug yaax̱wädity pactuum: “Najtshixøꞌøw jaꞌa mhaxøøgcuhdujt hajxy, nebiä mwiindsǿṉ hajxy hoy mjøbhíxät; hoy hajxy jaduhṉ mwiingudsähgǿꞌøwät.” Jaꞌa Juan jaduhṉ nänøøm̱ä. ");
INSERT INTO mirNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jaꞌa Juan, camellopøjt hänajty wyithajpy; wajhac hänajty wiøønhajpy. Chuꞌchp muꞌu hänajty jeꞌe; yhuucypy cunaax̱møjtsiinnøø hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Majiäyaꞌay jaꞌa Juan hänajty ñämec̈hii. Jerusalén hajxy hänajty näjeꞌe chooñ. Näjeꞌe hajxy hänajty chohm̱bä Judeanaaxooty møødä Jordánmøjnøøbaha. Yhamädoow̱hidáaṉäp jaꞌa Juan miädiaꞌagy hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mänitä piojpä quiädieey hajxy ñägapxy. Mänitä hajxy jim̱ yajnäbejtä jaꞌa Juángäm maa jaꞌa Jordánmøjnøøjän. ");
INSERT INTO mirNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mänitä Juan yhijxy coo hänajty ñämec̈hii jaꞌa fariseoshajxy nämay møødä saduceoshajxy. Ja wiꞌi ñäbetaam̱b hajxy hänajty jeꞌebä. Jaꞌa fariseoshajxy, hoy hajxy hänajty jiaanc̈h tehm̱ quiudiuṉ̃ jaꞌa Moisés miädiaꞌagy. Jaꞌa saduceoshajxy, wiingä cuhdujt hajxy hänajty miøødä; cab hajxy hänajty miänaꞌañ coo hajxy jiujypiøjtägatsaꞌañ. Mänitä Juan miänaaṉ̃: ―Hay, møjcuꞌu, caj mijts hoguiuhdujt mnäꞌägädä møødä. Paady hajxy mja wiꞌi ñäbetaam̱bä nebiä Dios hajxy jaduhṉ xquiaꞌa yajcumädów̱ät, túhm̱äts. ");
INSERT INTO mirNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hoy hajxy mwädítät neby hajxy jaduhṉ myajcähxǿꞌøgät coo jaꞌa mhaxøøgcuhdujt hajxy hänajty tøø mjaanc̈h najtshixøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Cab hajxy jaduhṉ mmänáꞌanät: “Abrahámhøch hijty nhaphajpy ndeedyhajpy, páadyhøch jaꞌa Dios jaduhṉ xquiaꞌa yajcumädow̱aꞌañ.” Mänitä Dios jaduhṉ xyajnähwáꞌadsät coo jaꞌa mhaxøøgcuhdujt hajxy mnajtshixǿꞌøwät, caꞌa jieꞌeguiøxpä coo jaꞌa Abraham hajxy hijty mhaphaty mdeedyhaty. ");
INSERT INTO mirNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pøṉ hoy caꞌa wädijp, jaduhṉ mäwíinäts jeꞌe nebiä quepychaajän, jaꞌa caꞌa tøømhajpä. Piuxaam̱by hajxy jeꞌe; mänit hajxy ñoꞌogaꞌañ. Paady hajxy hoy mwädítät nebiä Dios hajxy jaduhṉ xquiaꞌa yajcumädów̱ät. ");
INSERT INTO mirNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tøyhajt mijts nyajnäbety nøøhaam neby hajxy jaduhṉ myajcähxǿꞌøgät coo jaꞌa mhaxøøgcuhdujt hajxy tøø mnajtshixøꞌøy. Pero xii jäyaꞌay tuꞌug jiaac miṉ̃ høx̱haam; jeꞌeds mäbǿjnäbä jaꞌa Dioshespíritu hajxy xmioꞌowaam̱b. Xyajnähwaꞌads xyajcuhwaꞌadsaam̱b hajxy jaduhṉ. Maas møcä cuhdujt jeꞌe miøødä quejeec̈h høøc̈h. Cábøch cuhdujt nnäꞌägä møødä ni weeṉ̃tiä maa jaayaꞌaguiøxpän. ");
INSERT INTO mirNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jaꞌa jäyaꞌayhajxy, coo jaꞌa trigo hajxy hänajty tøø tiex̱y, tøgooty hajxy nøcxy piädaꞌagy. Pero jaꞌa trigohac, naax̱wiin jeꞌe quiaꞌay. Jaduhṉ mäwíinäts jäyaꞌayhajxy quiaꞌawaꞌañ haxøøgtuum, jaꞌa yhaxøøgcuhdujt hajxy caꞌa najtshixøꞌøwaam̱bä. Cøjxtaꞌaxiøø hajxy jiiby chaac̈hpøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mänitä Jesús miejch maa jaꞌa Juan hänajty miäyajnäbetiän jim̱ maa jaꞌa Jordánmøjnøøjän. Galilea jaꞌa Jesús hänajty tøø chooñ. Näbetaam̱b hänajty jeꞌebä. ");
INSERT INTO mirNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mänitä Juan jaꞌa Jesús ñämaayy: ―Cab jaduhṉ yhahixøꞌøy cooc̈h miic̈h nyajnäbétät; maas hoy hijty jaduhṉ cooc̈h miic̈h cu xyajnäbejty. ");
INSERT INTO mirNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mänitä Jesús miänaaṉ̃: ―Høøc̈h yajnäbéjtäc neby jaduhṉ ngudiúuṉämät nebiaty jaꞌa Dios xyhanéhm̱äm. Mänitä Juan jaduhṉ miänaaṉ̃: ―Ween nyajnäbétät. ");
INSERT INTO mirNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mänitä Jesús ñäbejty. Mänit jeꞌe tiøꞌødspädsøøm̱y. Mänitä tsajt yhawaach. Mänitä Jesús jaꞌa Dioshespíritu yhijxy coo hänajty miänacy nebiä palomän, coo hoy yhäñaaguiädaꞌagy jaꞌa Jesús quiuhduum. ");
INSERT INTO mirNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mänitä Dios jim̱ quiapxy tsajpootyp: ―Høøc̈h nHuung yøꞌø. Njaanc̈h tehm̱ chójpiøch jaduhṉ. Jaanc̈h tehm̱ jiootcújc‑høch nnijiäwøꞌøyii jaꞌa nHuungcǿxpøch. ");
INSERT INTO mirNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mänitä Dioshespíritu jaꞌa Jesús wioonøcxy pactuum. Jim̱ä Jesús hänajty jia wiꞌi ñämaꞌawaꞌañii jaꞌa møjcuꞌugóngäm coo haxøøg jiatcǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Juxychäguiꞌxxøø jaꞌa Jesús hänajty jim̱ tøø yhity jaguiay. Ni xøøm ni coods hänajty tøø quiaꞌa cay. Mänit yähoꞌpøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mänitä Jesús ñämejtsä jaꞌa møjcuꞌugóngäm. Ja wiꞌi yagjatcøꞌøwáaṉäp jaꞌa Jesús hänajty haxøøg. Mänitä møjcuꞌugong miänaaṉ̃: ―Pø miic̈h jaꞌa Dios tøyhajt xyHuunghajp, nämaꞌaw yøꞌø tsaa coo ween chajcaagyquiojy. ");
INSERT INTO mirNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mänitä Jesús yhadsooyy: ―Jaduhṉ jaꞌa Diosmädiaꞌagy miänaꞌañ: “Caꞌa quiaaguiähajtiä jaꞌa jäyaꞌayhajxy miädsänaaby hädaa yaabä naax̱wiin; møødä Diosmädiaꞌagy hajxy miädsänaꞌay.” ");
INSERT INTO mirNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mänitä møjcuꞌugong jaꞌa Jesús wioonøcxy jim̱ Jerusalén. Jaꞌa Dioscajpt jeꞌe jim̱. Mänitä Jesús miøødwiimbejtä jaꞌa møjtsajtøjcuhduum. ");
INSERT INTO mirNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mänit ñämaayyä: ―Pø miic̈h jaꞌa Dios tøyhajt xyHuunghajp, cuhdøpxnax̱ jii. Caj miic̈h nej mjádät. Jaduhṉ jaꞌa Diosmädiaꞌagy miänaꞌañ: Jaꞌa Dios jaꞌa mioonsä haneꞌemaam̱b, jaꞌa hajxy jim̱ tsajpootypä coo miic̈h xcwieendähádät. Xchehṉhidaam̱b miic̈h hajxy nej miic̈h tsaajooty jaduhṉ mgaꞌa cuhnébät. ");
INSERT INTO mirNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mänitä Jesús yhadsooyy: ―Pero nøm̱ jaꞌa Diosmädiaꞌagy miänaam̱bä: “Cabä Dios jaꞌa mWiindsǿṉ mjøjcapxǿꞌøwät.” ");
INSERT INTO mirNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mänitä møjcuꞌugong jaꞌa Jesús wioonǿcxcumbä maa jaꞌa tuṉän, jaꞌa jaanc̈h tehm̱ quiøxpä. Mänitä Jesús yajnähixøøyyä jaꞌa naax̱ jaꞌa cajpt cøx̱iä hädaa yaabä naax̱wiin, coo jaꞌa jäyaꞌayhajxy miøjjä jiaanc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mänitä Jesús ñämaayyä: ―Høøc̈h njeꞌe yøꞌøduhṉ cøx̱iä mäduhṉ̃tiä jii quiähxøꞌøgy. Cooc̈h miic̈h jijnaꞌa xwyiingudsähgǿꞌøwät, mänítäts yøꞌø ngøx̱y móꞌowät. ");
INSERT INTO mirNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mänitä Jesús yhadsooyy: ―Jäwaꞌads miic̈h jim̱, møjcuꞌu. Jaduhṉ jaꞌa Diosmädiaꞌagy miänaꞌañ: “Dios hajxy mwiingudsähgǿꞌøwäp, jaꞌa hajxy mWiindsøṉhajpiä. Cab jaduhṉ wiingpä mwiingudsähgǿꞌøwät.” ");
INSERT INTO mirNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mänitä møjcuꞌugong wyiimbijnä; nidiuhm̱ jaꞌa Jesús miähmøøyy. Mänitä Jesús ñägädaacä jaꞌa Dios mióonsäm jaꞌa tsajpootypä. Mänit jeꞌe piuhbejtä. ");
INSERT INTO mirNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Coo jaꞌa Jesús miädoyhajty coo jaꞌa Juan hänajty tøø chumyii, mänit jim̱ ñøcxy Galileanaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mänitä Jesús jim̱ ñaxøøyy maa jaꞌa Nazaretcajptän, pero cab jim̱ miähmøøyy. Mänit jim̱ chänaadiaacpøjcy maa jaꞌa cajpt jaduhṉ xiøhatiän Capernaum. Jím̱äts jeꞌe Galileamejypiaꞌa maa jaꞌa Zabulón yhap yhoc‑hajxy chänaꞌayän. Jim̱ä Neftalí jaꞌa yhap yhoc‑hajxy chänaabiä. ");
INSERT INTO mirNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Coo Jaꞌa Jesús jim̱ chänaadiaacpøjcy Capernaum, tøjiajt jaꞌa Diosmädiaꞌagy jaduhṉ nebiä Isaías hänajty jecy tøø quiujaayän, jaꞌa Diosmädiaꞌagy jecy yajwáꞌxäbä: ");
INSERT INTO mirNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Jaꞌa naax̱ maa jaꞌa Zabulón yhap yhoc‑hajxy chänaꞌayän, maa jaꞌa Neftalí yhap yhoc‑hajxy chänaabiän, jim̱ä tuꞌu ñaxøꞌøy mejypiaꞌa, jim̱ Galilea, jim̱ maa jaꞌa caꞌa judíoshajxy chänaꞌayän. ");
INSERT INTO mirNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jaꞌa jäyaꞌayhajxy hijty haxøøgwädijpä, tøø jaꞌa piojpä quiädieey hajxy yajnähwáatsäxä. Jaꞌa jäyaꞌayhajxy hijty hagoodstuum caꞌawaam̱bä, nøcxaam̱b hajxy jeꞌe jim̱ tsajpootyp, coo jaꞌa piojpä quiädieey hajxy tøø yajnähwáatsäxäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mänitä Jesús tiägøøyy yajwiingapxøøbiä jaꞌa Diosmädiaꞌagy. Mänit miänaaṉ̃: ―Najtshixøꞌøw jaꞌa mhaxøøgcuhdujt hajxy. Habaadáaṉnäp jaduhṉ coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jim̱ä Jesús hänajty miejypiaꞌayoꞌoy maa jaꞌa Galileamejjiän. Mänitä jäyaꞌay metsc yhijxy, jaꞌa Simón, jaꞌa xøhajpä Pedro, møødä piuhyaꞌay Andrés. Hacxmats hajxy hänajty tiuuṉghajpy. Jim̱ä yhacxjohm̱d hajxy hänajty miejypiädaꞌagaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mänitä Simónhajxy ñämaayyä jaꞌa Jesúsäm: ―Jam̱ hajxy wädíjtäm. Jueꞌe mijts mduuṉghajpy, hacxmats; wiingtuuṉg mijts nmoꞌowaam̱by. Nyajnähixøꞌøwaam̱by mijts nebiä jäyaꞌay hajxy myajwiingapxǿꞌøwät jaꞌa Diosmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tuuṉä jeꞌeduhṉ ñäꞌä mänaaṉ̃, mänitiä jaꞌa yhacxjohm̱d hajxy ñajtswidsøøyy; mänit jaꞌa Jesús hajxy piaduꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mänitä Jesús jiaag hädaacy mejypiaꞌa. Mänitä Zebedeo yhijxy møødä yhuunghajxy, jaꞌa Jacobo møødä Juan. Jiiby hajxy hänajty yhäñaꞌay barcojooty. Yhacxjohm̱d hajxy hänajty yhaxodsøøby. Mänitä Jesús jaꞌa Jacobo miøjyaax̱y møødä Juan. ");
INSERT INTO mirNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tuuṉä hajxy jaduhṉ ñäꞌä mädooyy, mänitiä hajxy piädsøøm̱y barcojooty; mänit jaꞌa Jesús hajxy piaduꞌubøjcy; yajmähmøøyy jaꞌa tieedy hajxy jiiby barcojooty. ");
INSERT INTO mirNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Mänitä Jesús tiägøøyy wädijpä cajpt‑cajpt jim̱ Galilea. Mädiaꞌagy‑yajwaꞌxpä jaduhṉ wiädijty coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. Homiädyii cajptä hänajty ñøcxy, jiiby hänajty yajnähixøꞌøy maa jaꞌa judíos chajtøjc‑hajxiän. May jaꞌa jäyaꞌay yajmøcpøjcy. Homiädyii paꞌamä jaduhṉ yajnajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mänitä mädiaꞌagy jaduhṉ wiädijty jaꞌa Jesúscøxpä jim̱ maa jaduhṉ xiøhatiän Siria. Mänitä paꞌamjäyaꞌayhajxy yajmejtsä maa jaꞌa Jesúsän, pønjaty jaꞌa møjcuꞌu møød, møød pønjaty jaꞌa pojpaꞌam møød. Mänitä Jesús jaꞌa paꞌamjäyaꞌay quiøx̱y yajmøcpøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mänitä Jesús piaduꞌubøjcä jaꞌa majiäyaꞌay. Jim̱ Galilea hajxy hänajty näjeꞌe chooñ. Näjeꞌe hajxy hänajty chooñ maa jaꞌa majc‑hagajptän, näjeꞌe Jerusalén, møødä Judea møødä Jordánmøjnøøꞌawiimb. ");
INSERT INTO mirNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Coo jaꞌa Jesús jaꞌa majiäyaꞌay yhijxy, mänit ñøcxy tuṉguhduum. Mänit yhøxtaacy naax̱wiin. Mänit ñämejtsä jaꞌa jiamiøødhajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mänit tiägøøyy yajnähixøøbiä. Mänit miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Jootcujc hajxy jaduhṉ yhidaꞌañ pønjaty jaduhṉ yajpejxp. Paady hajxy jootcujc yhidaꞌañ, coo hajxy jim̱ ñøcxaꞌañ maa jaꞌa Diosän. ");
INSERT INTO mirNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Jootcujc hajxy jaduhṉ yhidaꞌañ pønjaty jootmayhajp. Paady hajxy jootcujc yhidaꞌañ, coo jaꞌa Dios hajxy quiapxmøcpøgaꞌañíijäm. ");
INSERT INTO mirNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Jootcujc hajxy jaduhṉ yhidaꞌañ pønjaty meeꞌxxieemy hidaam̱b. Paady hajxy jootcujc yhidaꞌañ, coo jaꞌa Dios hajxy mioꞌowaꞌañíijäm nebiaty jaꞌa Dios tøø yajwiinwaaṉøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Jootcujc hajxy jaduhṉ yhidaꞌañ pønjaty jaꞌa jioot tsojp coo hajxy hoy quiudiúnät. Puhbedáaṉäp hajxy jaduhṉ Diósäm. ");
INSERT INTO mirNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Jootcujc hajxy jaduhṉ yhidaꞌañ pønjaty hojioot møød. Paady hajxy jootcujc yhidaꞌañ, coo jaꞌa Dios hajxy ñäxuudsaꞌañíijäm. ");
INSERT INTO mirNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Jootcujc hajxy jaduhṉ yhidaꞌañ pønjaty haxøøgwiinmahñdy caꞌa møød. Paady hajxy jootcujc yhidaꞌañ, coo jaꞌa Dios hajxy yhixaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Jootcujc hajxy jaduhṉ yhidaꞌañ pønjaty capxcuhgädaacp maa jaꞌa tsip piädøꞌøguiän. Paady hajxy jootcujc yhidaꞌañ, coo jaꞌa Dios hajxy yhuunghadaꞌañíijäm. ");
INSERT INTO mirNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Tsaac̈hpøjp jaꞌa jäyaꞌayhajxy näjeꞌe coo hoguiuhdujt hajxy miøødä; pero jootcujc hajxy jaduhṉ yhidaꞌañ. Paady hajxy jootcujc yhidaꞌañ, coo hajxy jim̱ ñøcxaꞌañ maa jaꞌa Diosän. ");
INSERT INTO mirNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Jootcujc hajxy mhidaꞌañ, hoy jaꞌa jäyaꞌayhajxy hänajty xjia nämaꞌay haxøøg, hoy jaꞌa jäyaꞌayhajxy hänajty xjia tunaꞌañ haxøøg, hoy jaꞌa jäyaꞌayhajxy hänajty xjia nähøønøꞌøwaꞌañ hoñejpiä jaꞌa høøc̈hcøxpä. ");
INSERT INTO mirNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","’Jaanä jaduhṉ hajxy jecy tøø chaac̈hpøjpä, jaꞌa Diosmädiaꞌagy hajxy jecy yajwáꞌxäbä. Pero xooṉdaꞌag hajxy, jootcugøꞌøw hajxy; jim̱ä hoybä weenbä hajxy mjaanc̈h tehm̱ piaadaꞌañ jim̱ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Jaꞌa caan, coo jaꞌa tiaamdspä tiägóyyät, cab jaduhṉ mänaa tiaamdsǿøñät. Tøø jaduhṉ miaꞌady. Mänitä jäyaꞌayhajxy yhøxwøjy, mänit hajxy yajteeñ. Jaduhṉ mäwíinäts mijts nebiä caanän hädaa yaabä naax̱wiin; coo jaꞌa Diosmädiaꞌagy hajxy mnajtshixǿꞌøwät, mmáꞌadäp hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","16","’Jaꞌa cajpt, jaꞌa tuṉguhduum hijpä, caj mänaa yhijxtägoyyii. Y coo jaꞌa cera hajxy ñoꞌogy, cab hajxy jaduhṉ ñähjujpety cachpaꞌc. Caj pues. Jiiby hajxy jaduhṉ piädaꞌagy cøxp maa jaꞌa ceratoyøhñdiän, nebiä jäyaꞌayhajxy nägøx̱iä quiudøøꞌxǿøjät jiiby tøgooty. Jaduhṉ mäwíinäts mijts, hoy hajxy mwädítät nebiä jäyaꞌay hajxy jaduhṉ xyhíxät coo hajxy hänajty hoy mwädity. Mänitä jäyaꞌayhajxy wyiingudsähgǿꞌøwät jaꞌa nDeedyhájtäm jim̱ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Páadyhøch yaa tøø nmiṉ̃ tøø nmech hädaa yaabä naax̱wiin nébiøch mijts jaduhṉ nyajnähixǿꞌøwät nebiä Diosmädiaꞌagy hajxy hamuumduꞌjoot mgudiúnät, jaꞌa Moisés jecy quiujáhyyäbä, jaꞌa Diosmoonsähajxy yajwáꞌxäbä, jaꞌa hajxy hädaa yaabä naax̱wiimbä. Cábøc̈hä Diosmädiaꞌagy nyajcuhdägoyyaꞌañ. Cab hajxy jaduhṉ mmänáꞌanät cooc̈h nyajcuhdägoyyaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tøyhájthøch mijts nnämaꞌay, mäduhṉ̃tiä jaꞌa tsajtwiing miähmøꞌøwaꞌañ, mäduhṉ̃tiä hädaa yaabä naax̱wiin miähmøꞌøwaꞌañ, cabä Diosmädiaꞌagy quiuhdägoyyaꞌañ, ni weeṉ̃tiä, ni tuꞌlíiꞌxytiädä, høxtä coonä hänajty tøø quiøx̱y habejnä. ");
INSERT INTO mirNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pønjaty jaꞌa Diosmädiaꞌagy jaduhṉ cudiuum̱b, pønjaty jaꞌa wiinghänaꞌc jaduhṉ yajnähixøøby coo hajxy quiudiúum̱bät, jeꞌeds hajxy møj jaanc̈h pädaꞌagáaṉäp coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. Pero pønjaty jaꞌa Diosmädiaꞌagy ni weeṉ̃tiä caꞌa cudiuum̱b, pønjaty jaꞌa wiinghänaꞌc yajnähixøøby coo hajxy quiaꞌa cudiúnät, cab hajxy jeꞌe møj jaanc̈h piädaꞌagaꞌañii coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Míjtshøch jaduhṉ nnämaaby, cabä ley‑yajnähixøøbiädøjc‑hajxy hoy wiädity ni jaꞌa fariseodøjc‑hajxy. Coo mijts maas hoy mwädítät, mänit hajxy jim̱ mnǿcxät cøxp maa jaꞌa Diosän. Pø cab hajxy hoy mwäditaꞌañ, cab hajxy jim̱ mnǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Tøø hajxy mmädoyhaty nebiä mhap mdeedyhajxy hijty jecy miänaꞌañän: “Caꞌa hajxy mjäyaꞌay‑yaghoꞌogy coo jaꞌa cuduuṉg hajxy xyajcumädów̱ät.” ");
INSERT INTO mirNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero høøc̈h mijts nnämaaby, pøṉ jaꞌa miäjøøn miädøjc mäjootmaꞌp, jeꞌeds cumädow̱aam̱b maa jaꞌa cuduuṉgän. Pøṉ jaꞌa miäjøøn miädøjc nähwaam̱bejp, jeꞌeds cumädow̱aam̱b maa jaꞌa gobiernän. Pøṉ jaꞌa miäjøøn miädøjc nämaaby coo jeꞌe quiuhmañøꞌøy, jeꞌeds jiiby caꞌawaam̱b haxøøgtuum, maa jaꞌa jøøn mänaa quiaꞌa piꞌic̈hän. ");
INSERT INTO mirNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Entonces, coo hajxy hänajty tii mänaa myoxaꞌañ jiiby tsajtøgooty maa jaꞌa altarän, y coo hajxy mänit mjahmiédsät coo jaꞌa mmäjøøn mmädøjc hajxy hänajty tøø xmiädsibøꞌøy hotyiiguiøxpä, ");
INSERT INTO mirNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jim̱ hajxy mnajtsconǿꞌøwät altarwiinduum, tijaty hajxy hänajty myoxaam̱by. Mänit hajxy jim̱ mnǿcxät maa jaꞌa mmäjøønän maa jaꞌa mmädøjcän, neby hajxy jaduhṉ myajtødiägǿꞌøwät. Mänit hajxy mwiimbídät. Mänit hajxy mnøcxtägátsät maa jaꞌa altarän. Mänit hajxy myójxnät. ");
INSERT INTO mirNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Coo pøṉ hänajty mänaa xñäxøꞌøwøꞌøwaꞌañ maa jaꞌa cuduuṉgän, jayøjp myajtødiägǿꞌøwät tuꞌhaamnøcxpä. Coo jim̱ mgaꞌa yajtødiägǿꞌøwät tuꞌhaamnøcxpä, mänit hajxy xyajmédsät cuduuṉgwiinduum. Mänitä cuduuṉg xyajcøꞌødägǿꞌøwät jaꞌa policíahajxy. Mänit hajxy xchúmät. ");
INSERT INTO mirNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Jiiby jaduhṉ mmähmǿꞌøwät pujxtøgooty. Cab jaduhṉ mdsoj pädsǿm̱ät. Mänit jaduhṉ mbädsǿm̱ät coo hänajty pedyii tøø mniyhøxjuubiädsøm̱yii. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Tøø hajxy mmädoyhaty coo jäyaꞌayhajxy hijty jegyhajty miänaꞌañ coo hajxy mgaꞌa tuꞌudägóyyät. ");
INSERT INTO mirNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero høøc̈h mijts jaduhṉ nnämaaby, coo pøṉ wiingtoꞌoxiøjc mänaa yhadsocy, näꞌägädä tuꞌudägooby jeꞌeduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","’Coo tii hoyhadsojnä mhíxät, cab jim̱ mmøjhéeꞌpnät ni mgaꞌa nähdónät. Jaduhṉ mnibiädaꞌagǿøjät nebiä wiindspän nebiä cøꞌøducpän. Pø caj, jiiby hajxy mgaꞌawaꞌañ haxøøgtuum. ");
INSERT INTO mirNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Jaduhṉä jäyaꞌayhajxy hijty jegyhajty miänaam̱bä: “Coo pøṉ jaꞌa tioꞌoxiøjc mänaa yhøxmádsät, mänitä hagujpøjnocy quiǿøꞌtsnät.” ");
INSERT INTO mirNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero høøc̈h mijts jaduhṉ nnämaaby, coo pøṉ tioꞌoxiøjc mänaa yhøxmádsät, y cabä tioꞌoxiøjc hänajty nej tøø jiatcøꞌøy, coo jaꞌa toꞌoxiøjc wiingyaꞌadiøjc jiøjpøgǿꞌøwät, pues tuꞌudägóyyäp jaꞌa toꞌoxiøjc jaduhṉ. Jaꞌa yaꞌadiøjc, jaꞌa hänajty jawyiin tøøbä yhøxmáchäbä, jeꞌedsä pojpä møød. Y jaꞌa yaꞌadiøjc tøø jiaac jøjpøgǿꞌøyäbä, jaanä tuꞌudägooby jeꞌebä. ");
INSERT INTO mirNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Jaduhṉä jecyjiäyaꞌayhajxy hijty ñämaꞌayii: “Pø tøø jaꞌa Dios hajxy mnämaꞌay hamuumduꞌjoot coo hajxy hotyiijä mgudiunaꞌañ, tsipcøxp hajxy jaduhṉ mgudiúnät.” ");
INSERT INTO mirNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","36","Pero høøc̈h mijts nnämaaby coo hajxy tii mgaꞌa yajwiinwaaṉǿꞌøwät näꞌä nägoobä. Coo hajxy hänajty tii myajwiinwaaṉøꞌøwaꞌañ, cabä tsajpootypä hajxy mgapxpáadät, ni jaꞌa naax̱wiimbä, ni jaꞌa Jerusalén, ni jaꞌa mgopc‑hajxy. Hix̱, paadiä tsajpootypä hajxy mgaꞌa capxpáadät jeꞌeguiøxpä coo jaꞌa Dios jim̱ yhäñaꞌay. Møød hädaa yaabä naax̱wiin hajxy mgaꞌa capxpáatpät jeꞌeguiøxpä coo jaꞌa Dios yajtänaabiety. Møødä Jerusalén hajxy mgaꞌa capxpáatpät jeꞌeguiøxpä coo jeꞌe Dyioscajptä. Møødä mhamdsoo copc hajxy mgaꞌa capxpáatpät jeꞌeguiøxpä coo jaꞌa mguhwaay hajxy hoy mgaꞌa yajpóꞌowät, ni hajxy hoy mgaꞌa yagjiṉ̃ǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jaduhyyä hajxy mmänáꞌanät pø tøyhajt, pø caj. Coo hajxy waam̱b mjaac mänáꞌanät, jaꞌa møjcuꞌugong hajxy jaduhṉ xyajmänaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Tøø hajxy hijty mmädoyhaty nebiä jäyaꞌayhajxy hijty jegyhajty miänaꞌañ: “Coo pøṉ cøx̱ypänejpiä xñäꞌä túnät, myaghawiimbídäp jaduhṉ.” ");
INSERT INTO mirNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero høøc̈h mijts nnämaaby: cab jaduhṉ myaghawiimbídät; coo pøṉ xyhalaꞌpǿꞌøgät tuꞌnax̱, mjaac yégäp jaduhṉ jaꞌa tuꞌnax̱pä, ween xjiaac halaꞌpøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Coo pøṉ mänaa xñäxøꞌøwǿꞌøwät, coo jaꞌa mgamiixy hänajty xpiøgaaṉä, myégäp jaduhṉ møødä mnähgäjéṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Coo pøṉ hänajty tii xyajtsøm̱nøcxaꞌañ tuꞌkilómetro hadsip, mejtskilómetro mnäꞌägä tsøm̱nǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Coo pøṉ hänajty tii xmiäyujwaꞌanaꞌañ, mmóꞌowäp jaduhṉ. Tsipcøxp jaduhṉ hotyiijä mmóꞌowät. ");
INSERT INTO mirNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Tøø hajxy hijty mmädoyhajpä nebiä jäyaꞌayhajxy hijty jegyhajty miänaam̱bä: “Hoy jaꞌa mmäguꞌughajpä mdsoc mbaꞌhäyówät; pero jaꞌa mmädsip, mmähaṉhádäp jeꞌe.” ");
INSERT INTO mirNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero høøc̈h mijts nnämaaby: caꞌa mmähaṉhaty pønjaty jaduhṉ xmiädsiphajp. Hoy hajxy mnänǿmät pønjaty haxøøg xñänøøm̱b. Mnäxúudsäp hajxy pønjaty xmiähaṉhajp. Mänuuꞌxtaꞌag jaꞌa Dios hajxy coo ween mioꞌoy jaꞌa hoyhajt jaꞌa weenhajt pønjaty xwyiinwohm̱b xyhawohm̱b, pønjaty xyhäyoow̱hijxp. ");
INSERT INTO mirNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jaduhṉä Dios hajxy hoy xyhuunghádät, jaꞌa jim̱ hijpä tsajpootyp. Jaayáꞌayäts jaduhṉ yajxøøhaam̱b maa jaꞌa jäyaꞌay hoybän chaads jim̱ maa jaꞌa jäyaꞌay caꞌawiindøybän. Jaayáꞌayäts jaduhṉ yajtuub maa jaꞌa jäyaꞌay hoybän chaads jim̱ maa jaꞌa jäyaꞌay caꞌawiindøybän. ");
INSERT INTO mirNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cab hajxy tii mbáadät näꞌä tägøꞌøbä coo jaꞌa mmäguꞌughajpähajtiä mmøødnijiootpaadǿøjät. Høxtä jaꞌa yajnähjuudiuutpädøjc‑hajxy nic̈hojc nibiaꞌhäyóow̱äp. Pero coo jaꞌa mmädsip hajxy mméeꞌxät, mänitä Dios hajxy xyhuunghádät. ");
INSERT INTO mirNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Cab jaduhṉ ñejpiä coo jaꞌa mmäguꞌughajpä hajxy mmøødnijiootpaadyii. Hopiøṉä ñijiootpaadyii, hoy jaꞌa Diosmädiaꞌagy hajxy quiaꞌa ja mäbøcy. Pero coo jaꞌa mmädsip hajxy mméeꞌxät, hoy hajxy mgudiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jaꞌa nDeedyhájtäm, jaꞌa jim̱ tsajpootypä, jaanc̈h tehm̱ ñäꞌägä hoy jeꞌeduhṉ yhity. Hoy hajxy jaduhṉ mbahíjxpät. ");
INSERT INTO mirNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Näjeꞌe jaꞌa jäyaꞌayhajxy jia wiꞌi yajcumayaꞌañ, paady hajxy jaduhṉ ñibiädaꞌagyii nebiä hojiäyaꞌayän. Pero cab jaduhṉ yhoyyä coo hajxy jaduhṉ yajcumáyät. Cab hajxy jaduhṉ mbahix̱ mbadúnät. Coo hajxy jaduhṉ mbahix̱ mbadúnät, cabä Dios hajxy xyhuunghádät, jaꞌa jim̱ tsajpootypä. ");
INSERT INTO mirNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jii jäyaꞌayhajxy näjeꞌebä, coo jaꞌa häyoobäyaꞌay jaꞌa xädøꞌøñ hajxy hänajty tøø mioꞌoy, mänit hajxy tiägøꞌøy mädiaacpä jiiby tsajtøgooty møød jim̱ tuꞌhaam. Paady hajxy jaduhṉ miädiaꞌagy, yajcumayaam̱b hajxy jaduhṉ maa jaꞌa cuꞌugän. Pero cabä Dios hajxy jaduhṉ quiumayíijäm, jeꞌeguiøxpä coo hajxy hänajty jim̱ tøø yajcumay maa jaꞌa cuꞌugän. ");
INSERT INTO mirNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero mijts, coo jaꞌa häyoobäyaꞌay xädøꞌøñ hajxy hänajty tøø mmoꞌoy, cab hajxy waam̱b mmänáꞌanät. Ni pøṉ hajxy mgaꞌa hawáaṉät, ni jaꞌa mmäguꞌughajpähajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hameeꞌch jaꞌa xädøꞌøñ hajxy jaduhṉ myégät. Dios hajxy jaduhṉ xyhíxäp; mänit hajxy jaduhṉ xyhuunghádät. ");
INSERT INTO mirNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","6","’Jii jäyaꞌayhajxy näjeꞌebä, tänaꞌa jaꞌa Dios hajxy nax̱y piaꞌyaꞌaxy jiiby tsajtøgooty møød jim̱ maa jaꞌa tuꞌuxeṉ̃än. Pero cabä Dios hajxy tuꞌjoot piaꞌyaꞌaxy. Näꞌä yajcumayaam̱b hajxy jaduhṉ maa jaꞌa cuꞌugän. Pero cabä Dios hajxy jaduhṉ quiumayaꞌañíijäm. Tøyhajt jaduhṉ. Pero mijts, hameeꞌch jaꞌa Dios hajxy mbaꞌyáꞌaxät. Xyhíxäp xmiädów̱äp hajxy jeꞌeduhṉ; mänit hajxy xyhuunghádät. ");
INSERT INTO mirNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","’Jaꞌa jäyaꞌay jaꞌa Diosmädiaꞌagy hajxy caꞌa mäbøjpä, cab hajxy ñajuøꞌøy waam̱baty jaꞌa Dios hajxy jia paꞌyaꞌaxy. Ja capxp hajxy jaduhṉ ja naañ ja tsojc. Paady hajxy jaduhṉ jia capxy cooc tyijy jaꞌa Dios hajxy jaduhṉ miädow̱aꞌañíijäm. Pero mijts, cab hajxy jaduhṉ mbahix̱ mbadúnät. Hix̱, jäguem̱iä jaꞌa Dios ñajuøꞌøy tijaty hajxy hänajty myajmaajiajpy. ");
INSERT INTO mirNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jaduhṉä Dios hajxy mbaꞌyáꞌaxät: Teedy, jim̱ miic̈h mdsänaꞌay tsajpootyp; ween miic̈h jaꞌa cuꞌughajxy xwyiingudsähgøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ween jaꞌa mmäjaa miṉ yaa myajcähxøꞌøgy hädaa yaabä naax̱wiin. Ween jaꞌa jäyaꞌay jaꞌa mmädiaꞌagy hajxy yaa xquiudiuuṉä hädaa yaabä naax̱wiin, neby jim̱ xquiudiuuṉän tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Højts jaꞌa caayyøøc huucøøc móoyyäc jabom̱‑jabom̱. ");
INSERT INTO mirNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Højts jaꞌa nbojpä ngädieey méeꞌxäc neby højts tøø nmämeeꞌxiän jaꞌa højts tøø xñägädieeyǿꞌøyäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Caꞌa højts xyajcädieey; pero pädáacäc højts hodiuum neby højts jaduhṉ ngaꞌa cädiéeyät. Miic̈h hanehm̱b; miic̈h jaꞌa mäjaa mmøød; miic̈h møj jaanc̈h homiänaajä. Amén. ");
INSERT INTO mirNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Coo mijts jaduhṉ mmäméeꞌxät jaꞌa hajxy tøø xñägädieeyǿꞌøyäbä, mänitä Dios hajxy jaduhṉ xmiéeꞌxpät, jaꞌa nDeedyhájtäm jaꞌa jim̱ tsänaabiä tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero coo wiinghänaꞌc hajxy jaduhṉ mgaꞌa mäméeꞌxät, cabä Dios jaꞌa mbojpä mgädieey hajxy jaduhṉ xmiéeꞌxät. ");
INSERT INTO mirNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Jii jäyaꞌayhajxy näjeꞌe, coo hajxy hänajty yhayuuhadaꞌañ, jaduhṉ hajxy ñibiädaꞌagyii nebiä jootmayhajpän. Paady hajxy jaduhṉ ñibiädaꞌagyii, jaduhṉ hajxy quiähxøꞌøgaꞌañ jäyaꞌawyiinduum coo hajxy hänajty yhayuuhaty. Tøyhájthøch mijts nnämaꞌay, cab hajxy jaduhṉ tii piaadaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero mijts, cab hajxy jaduhṉ mnibiädaꞌagǿøjät nebiä jootmayhajpän. Coo hajxy hänajty mhayuuhadaꞌañ, yajxóṉ hajxy mniyhonǿøjät mniwyiimbujǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Jaduhṉ hajxy mgaꞌa yajcähxǿꞌøgät maa jaꞌa cuꞌugän pø mhayuuhajp hajxy hänajty. Hameeꞌch jaꞌa Dios hajxy jaduhṉ xyhíxät, jaꞌa caꞌa cähxøꞌpä. Jaayaꞌay hajxy jaduhṉ xmioꞌowaam̱b jaꞌa hoyhajt jaꞌa weenhajt. ");
INSERT INTO mirNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Cabä mjoot hajxy yaa mbädáꞌagät tijaty yaabä naax̱wiin. Haagä maꞌadaam̱b jaduhṉ cøx̱iä mäduhṉ̃tiä hädaa yaabä naax̱wiin. Y jaanc̈h tehm̱ wiädijp jaꞌa meeꞌtspähajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pero jaduhṉ hajxy mwiinmahñdyhádät neby hajxy hoy mwädítät. Jaduhṉ hajxy jootcujc mhídät jim̱ tsajpootyp; caj pøṉ jim̱ xyagjootmayhádät. ");
INSERT INTO mirNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pøṉ jaduhṉ ja wiꞌi miäyøøhadaam̱b hädaa yaabä naax̱wiin, jim̱ä jioot hajxy jaduhṉ piädaꞌagy maa jaꞌa xädøꞌøñän. Pero pøṉ hoy wäditaam̱b, jim̱ä jioot jaduhṉ piädaꞌagy maa jaꞌa Diosän. ");
INSERT INTO mirNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Pø mmøødä howyiinmahñdy hajxy, mänit hajxy hoy mwädítät nebiä Dios choquiän. ");
INSERT INTO mirNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero pø cabä mwiinmahñdyhajxy yhoyyä, cab hajxy hoy mwädítät nebiä Dios jia tsoquiän. ");
INSERT INTO mirNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Cabä wiindsǿṉ hoy metsc mmøødtúnät. Mxøøghadaam̱by tuꞌug; jatuꞌugpä jaduhṉ mdsogaam̱by. Hoy jaꞌa miädiaꞌagy jaduhṉ mgudiunaaṉä. Jaanä jaduhṉduhm̱bä, coo jaꞌa mjoot mbädáꞌagät maa jaꞌa xädøꞌøñän, cabä Dios jaduhṉ hoy mwiingudsähgǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Jadúhṉäts mijts nnämaꞌay, caꞌa hajxy mwiꞌi tiajy mwiꞌi miay tijaty hajxy mnäjugyhádäp, tii hajxy mwithádäp. Maas tsoobaatp jaꞌa jugyhajt jaduhṉ quejee jaꞌa cay, y maas tsoobaatp jaꞌa niꞌx jaduhṉ quejee jaꞌa wit. ");
INSERT INTO mirNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Høxtahm̱dsä muuxyhajxy, cab hajxy ñiꞌiby tiuṉ̃, cab hajxy tii piädaꞌagy tsehx̱jooty. Pero jaꞌa nDeedyhájtäm jaꞌa jim̱ tsajpootypä, jeꞌeds jaduhṉ yagjøøꞌxp yajpøjp. Y mmaas tsoobaatp mijts quejee jaꞌa muuxyhajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ni pøṉ jaduhṉ hamdsoo quiaꞌa yajnijiugyhadǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Cabä wit hajxy mnädaj mnämáyät. Høxtahm̱dsä pøjy hujts, cab tii tiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero maas yajxóṉ jeꞌe quejee jaꞌa rey Salomón hijty; jaanc̈h tehm̱ yajxóṉ jaꞌa Salomón hijty jegyhajty ñibiädaꞌagyii. ");
INSERT INTO mirNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jaꞌa pøjy hujts, yajxóṉ jaꞌa Dios jaduhṉ tøø quiunuuꞌxy. Y häyaa jaboom hajxy jaduhṉ ñoꞌogaꞌañ. Y mijts, xmiaas cunuuꞌxaam̱b mijts jaꞌa Dios, hoy hajxy mgaꞌa ja mäbøcy. ");
INSERT INTO mirNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Caꞌads hajxy mdajy mmay; caꞌa hajxy mwiꞌi miänaꞌañ: “Tii ngáayyämb, tii nhúucämb, tii mwithájtämb.” ");
INSERT INTO mirNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yøꞌøduhm̱bä hajxy yhøxtaaby jaꞌa Dios hajxy caꞌa wiingudsähgøøbiä. Pero jaꞌa nDeedyhájtäm jim̱ tsajpootypä, ñajuøøby jeꞌeduhṉ coo mijts myajmaajiaty. ");
INSERT INTO mirNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mhøxtáꞌawäp hajxy jayøjp neby hajxy hoy mwädítät, neby hajxy jaduhṉ jim̱ mnǿcxät maa jaꞌa Diosän. Jaduhṉä Dios chocy. Mänit hajxy jaduhṉ cøx̱iä xmióꞌowät. ");
INSERT INTO mirNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Caꞌa hajxy mwiꞌi tiajy mwiꞌi miay jaꞌa jaboomgøxpä; ween hamdsoo yhuuc habaady. Mädøyyä jaꞌa tsaac̈hpä hajxy xpiaadaꞌañ jaꞌa jädaꞌagøxpä. ");
INSERT INTO mirNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Cabä wiinghänaꞌc hajxy mnähójät, coo jaꞌa Dios hajxy jaduhṉ xñäꞌä yajcumädów̱ät. ");
INSERT INTO mirNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Jaduhṉ hajxy xyajcumädów̱ät nej mijts wiinghänaꞌc hänajty tøø mnähojjiän. ");
INSERT INTO mirNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","Coo jaꞌa mmäguꞌughajpä weeṉ̃tiä quiädiéeyät, y coo miic̈h hänajty maas hanax̱iä tøø mgädieey, cab jaduhṉ yhawiinmatsä coo jaꞌa mmäguꞌughajpä waam̱b mnämáꞌawät. ");
INSERT INTO mirNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mänitä mmäguꞌughajpä jaduhṉ hawiinmats mwiingapx mjøjcapxǿꞌøwät, coo miic̈h hänajty tøø myajniñähwaꞌac̈hii. ");
INSERT INTO mirNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Cabä jäyaꞌay hajxy hadsip mnämáꞌawät coo jaꞌa Diosmädiaꞌagy hajxy miäbǿgät. Pø cab hajxy jaduhṉ miädow̱aꞌañ, caꞌa hajxy hadsijpc mduṉ̃, coo hajxy jaduhṉ ñäꞌä jootmáꞌadät. ");
INSERT INTO mirNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","’Coo jaꞌa Dios hajxy tii mmäyujwáꞌanät, mänit hajxy jaduhṉ xmióꞌowät; coo hajxy mmänuuꞌxtáꞌagät, mänit hajxy jaduhṉ xpiuhbédät. ");
INSERT INTO mirNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Coo jaꞌa mhuung jaꞌa tsajcaagy xmiäyujwaꞌañ, jeꞌeds jaduhṉ mmooby, túhm̱äts. Cabä tsaa mmoꞌoy. ");
INSERT INTO mirNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Y coo hacx jaduhṉ xmiäyujwaꞌañ, jeꞌeds jaduhṉ mmooby, túhm̱äts. Cabä tsahṉ̃dy mmoꞌoy. ");
INSERT INTO mirNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hoorä, jeꞌedsä mhuung hajxy mmooby jaꞌa hoybä, hoy mijts mja haxøøgjäyaꞌayä. Pero jaꞌa nDeedyhájtäm jim̱ tsajpootypä, hojiäyaꞌay jeꞌe. Xmioꞌowaam̱b jaꞌa hoyhajt hajxy jaduhṉ coo hajxy mmäyujwáꞌanät. ");
INSERT INTO mirNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Jadúhṉäts mijts jaꞌa jäyaꞌayhajxy mnäxúuꞌtspät nej mijts myajnäxuudsaꞌañän. Jaduhṉä Moisés jecy miänaaṉ̃ coo hajxy ngudiúuṉämät. Jaduhṉ hajxy jecy miänaam̱bä, jaꞌa Diosmädiaꞌagy hajxy jecy yajwáꞌxäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","’Hamäjaa jim̱ mnǿcxät Dioswiinduum. Jaduhṉ mäwíinäts jim̱ nebiä xuꞌudstuꞌujän; cab hajxy jaduhṉ nämay piaady. Pero coo jiiby mhädáꞌagät haxøøgtuum, cab jaduhṉ yhamäjaajä. Jaduhṉ mäwíinäts jeꞌe nebiä møjtuꞌujän; nämay hajxy jiiby yhädaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Mnigwieendähadǿøjäp hajxy maa jaꞌa jäyaꞌayhajxy tyijy Diosquex̱ypän. Näꞌä høhṉdaacp hajxy jaduhṉ. Jaduhṉ hajxy ñibiädaꞌagyii nebiä mäbøjpän, pero cab hajxy tiehm̱ miäbøcy; jaanc̈h tehm̱ quiaꞌawiindøy hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Haxøøg hajxy jiatcøꞌøy; jaduhṉ hajxy mhøxcábät coo haxøøgwiinmahñdy hajxy miøødä. Jaduhṉ mäwíinäts hajxy jeꞌe nebiä hujts nebiä haptiän. Jaꞌa wädsats, cab jaduhṉ tiøømhaty nebiä tsaatypän. Jaꞌa hapty, cab jaduhṉ tiøømhaty nebiä piidsän. ");
INSERT INTO mirNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Mädyii quepychaa hoy, hoy tiøømhaty; mädyii caꞌa hoy, cab hoy tiøømhaty. ");
INSERT INTO mirNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mädyii quepychaa jaduhṉ hoy caꞌa tøømhajp, piujxyp hajxy jaduhṉ; mänit hajxy ñoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jaꞌa jäyaꞌayhajxy haxøøg jatcøøbiä, jaduhṉ mäwíinäts hajxy jeꞌe nebiä quepychaa hoy caꞌa tøømhajpän. Jaduhṉ hajxy mhøxcábät coo haxøøgwiinmahñdy hajxy miøødä. ");
INSERT INTO mirNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Nämáyhøch jaꞌa jäyaꞌayhajxy xjia nämaꞌay: “Wiindsǿṉ.” Pero cab hajxy nägøx̱iä jim̱ tiägøꞌøwaꞌañ Dioswiinduum jim̱ tsajpootyp. Pønjátyhøch jaꞌa nDeedy jaꞌa miädiaꞌagy xquiudiúuṉäp, jeꞌeds jim̱ tägøꞌøwaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Coo jaꞌa naax̱wiimbä hänajty wyiimbidaꞌañ, mänítøch hajxy nämay xjia nämaꞌawaꞌañ: “Wiindsǿṉ, tøø højts jaꞌa Diosmädiaꞌagy nyajwaꞌxy jaꞌa miic̈h mmäjaagøxpä; tøø højts jaꞌa møjcuꞌu ngøx̱y yajpäyøꞌøgy jaꞌa miic̈h mmäjaagøxpä; tøø højts jaꞌa hoy‑yagjuøøñäjatypä may nyajcähxøꞌøgy jaꞌa miic̈h mmäjaagøxpä.” ");
INSERT INTO mirNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mänítøch hajxy nnämaꞌawaꞌañ: “Cábøch mijts mänaa tøø nhix̱yhaty. Juaꞌads hajxy jim̱; haxøøg jaꞌa mwiinmahñdyhajxy jaduhṉ.” ");
INSERT INTO mirNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Pǿṉhøch nmädiaꞌagy xmiädóow̱äp, coo jaduhṉ quiudiúnät nébiøch nhaneꞌemiän, jaduhṉ mäwíinäts jeꞌe nebiä jäyaꞌay jaꞌa tiøjc tøø quiojjiän tsaawiing. ");
INSERT INTO mirNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mänit com̱ tiuuyy. Mänitä møjnøø quiom̱gädaacy. Mänitä tøjc møc miøjpojpejty. Pero cabä tøjc ñäꞌä jijty, jeꞌeguiøxpä coo tsaawiing quiojjiä. ");
INSERT INTO mirNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero pǿṉhøch nmädiaꞌagy tøø xquiaꞌa cudiuuṉä nébiøch nhaneꞌemiän, jaduhṉ mäwíinäts jeꞌe nebiä jäyaꞌay caꞌa jajpän. Jiibiä tiøjc quiojy tsabiuꞌujooty. ");
INSERT INTO mirNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mänit com̱ tiuuyy. Mänitä møjnøø quiom̱gädaacy. Mänitä tøjc miøjpojpejty møc. Mänit piuum̱y. ");
INSERT INTO mirNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mänitä Jesús miädiaacpädøøyy. Mänitä jäyaꞌayhajxy yagjuøøyy nebiaty jaꞌa Jesús hänajty tøø yajnähixøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jaduhṉ hänajty yajnähixøꞌøy nebiä møjcuhdujtmøødpän. Jaꞌa cuꞌug wyiindsøṉhajxy, cab hajxy hänajty jiaty jaty. ");
INSERT INTO mirNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tuṉguhduum jaꞌa Jesús hänajty tøø yajnähixøꞌøy. Mänit miänajnä. Mänit majiäyaꞌay piaduꞌubøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mänit paꞌamjäyaꞌay Jesús ñämejch. Haxøøgpaꞌam hänajty miøød. Mänitä Jesús wyiinjijcädaacä, wyiingudsähgøøyyä. Mänit ñämaayyä: ―Wiindsǿṉ, pø chojpy jaꞌa mjoot jaduhṉ, hóyhøch jaduhṉ xyajnähwaꞌads xyajcuhwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Mänitä Jesús jaꞌa mähdiøjc ñähdooṉ̃. Mänit ñämaayy: ―Chójpiøch jaꞌa njoot jaduhṉ; tøø jaduhṉ mnähwaꞌac̈h mguhwaꞌac̈h. Mänitiä jaꞌa mähdiøjc jiaanc̈h nähwaach jiaanc̈h cuhwaach. ");
INSERT INTO mirNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mänitä Jesús miänaaṉ̃: ―Huuc mädow̱, caꞌa pøṉ mnäꞌägädä hawaaṉä. Nøcx jim̱ Jerusalén maa jaꞌa teediän. Jim̱ myajcähxǿꞌøgät coo tøø mnähwaꞌac̈h coo tøø mguhwaꞌac̈h. Jim̱ä xädøꞌøñ mguyoxǿꞌøwät nebiä Moisés jecy yhanehm̱iän. Jaduhṉä hijxtahṉd myajcähxǿꞌøgät coo tøø mnähwaꞌac̈h coo tøø mguhwaꞌac̈h. ");
INSERT INTO mirNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mänitä Jesús miejch maa jaꞌa cajpt hänajty xiøhatiän Capernaum. Coo quiajptägøøyy, mänit jaꞌa Jesús jaꞌa soldadowiindsǿṉ ñämejch. ");
INSERT INTO mirNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Mänit Jesús ñämaayyä: ―Jím̱høch jaꞌa nmoonsä tuꞌug quioꞌnaꞌay tøgooty. Tøø jaꞌa tiecy miucy. Hanax̱iä jaduhṉ chaac̈hpøcy tehṉgajnä. ");
INSERT INTO mirNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mänitä Jesús miänaaṉ̃: ―Nøcxy nhuuc yaghoyøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mänitä soldadowiindsǿṉ yhadsooyy: ―Pero Wiindsǿṉ, cab jaduhṉ yhahixøꞌøy coo miic̈h jiiby mdägǿꞌøwät maac̈h ndøgootiän, jeꞌeguiøxpä coo miic̈h mmøjjä mjaanc̈hä. Nägooyyä miic̈h jaduhṉ mmänáꞌanät cooc̈h nmoonsä yhoyǿꞌøwät, pues hoyǿꞌøwäp. ");
INSERT INTO mirNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Hanéꞌemyhøch nhity; jím̱høch nwiindsøṉbä, y jím̱høch nsoldado. Cooc̈hä nsoldado tuꞌug nnämáꞌawät coo homiaajä ñǿcxät, nǿcxäp jaduhṉ; y cooc̈h nnämáꞌawät coo myínät, mínäp jaduhṉ. Y cooc̈hä nmoonsä waam̱b nnämáꞌawät, quiudiúnäp jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mänitä Jesús jiaanc̈h tehm̱ yagjuøøyy. Mänit ñämaayy jaꞌa hajxy hänajty pawädijpä: ―Cábøc̈hä nmägunaax̱hajxy jaduhṉ miäbøcy neby yøꞌø craa miäbøquiän, y jäguem̱ yøꞌø chooñ. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Coo jaꞌa Dios jaꞌa miäjaa hänajty yajcähxøꞌøgaꞌañ, mänit hajxy hänajty nämay miedsaꞌañ, jaꞌa hajxy hänajty mäbøjpä. Wiinduhm̱yhagajpt hajxy hänajty choonaꞌañ. Mänit hajxy hänajty miøødhidaꞌañíijäm jaꞌa Abraham møødä Isaac møødä Jacob. ");
INSERT INTO mirNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero jaꞌa judíoshajxy caꞌa mäbøjpä, cab hajxy hänajty jim̱ quioodaꞌañ Dioswiinduum. Jiiby hajxy jaduhṉ quiuhjuijpnaxaꞌañii møjcuꞌuhaam maa yhagoodsän. Jiiby hajxy jaduhṉ chaac̈hpøgaꞌañ tehṉgajnä. ");
INSERT INTO mirNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mänitä Jesús jaꞌa soldadowiindsǿṉ ñämaayy: ―Nøcx maa jaꞌa mdøjcän. Tøø jaduhṉ mmäbøcy, tøø jaꞌa mmoonsä jaduhṉ yhoyøꞌøy. Mänitä jaꞌa mioonsä jiaanc̈h hoyøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Mänitä Jesús ñøcxy maa jaꞌa Pedro tiøjcän. Jiibiä Pedro miøꞌødhoc hänajty quioꞌnaꞌay tomiøød. ");
INSERT INTO mirNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mänitä Jesús jaꞌa tajjäyaꞌay jaꞌa quiøꞌø ñahdooṉä. Mänitä tioy tiøjch. Mänitä tajjäyaꞌay piädøꞌcy. Mänit tiägøøyy mayhajtuum̱bä jaꞌa Jesúscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Coo quioodsøøyy, mänitä paꞌamjäyaꞌayhajxy may yajmejtsä maa jaꞌa Jesúsän. Tøø hajxy hänajty näjeꞌe miac̈hii jaꞌa møjcúꞌujäm. Mänitä Jesús quiapxy. Manityä hajxy yhøxmajtsä jaꞌa møjcúꞌujäm. Jaduhṉä paꞌamjäyaꞌayhajxy quiøx̱y yajmøcpøjcä; jaꞌa Jesús jaduhṉ yajmøcpøjc. ");
INSERT INTO mirNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tøjiajt jaꞌa Diosmädiaꞌagy jaduhṉ maa jaduhṉ myiṉ̃än cujaay, mänaa jaꞌa Isaías jecy miänaꞌañän: “Jaayaꞌay jaꞌa nbaꞌamhájtäm tøø xyajnähwáatsäm tøø xyajcuhwáatsäm.” Jaꞌa Isaías, jeꞌeds jaꞌa Diosmädiaꞌagy jaduhṉ jecy yajwaꞌx. ");
INSERT INTO mirNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Coo jaꞌa Jesús yhijxy coo hänajty cujc tøø piädaꞌagyii jaꞌa majiäyaꞌay, mänit miänaaṉ̃ coo hajxy ñáxät mejyhawiimb møødä jiamiøødhajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cajnä hajxy hänajty tiuꞌubøcyñä, mänitä Jesús jäyaꞌay tuꞌug ñämejtsä. Yajnähixøøby hänajty jeꞌebä maa jaꞌa tsajtøjcän. Mänitä Jesús ñämaayyä: ―Wiindsǿṉ, miṉ nhuuc jamiøødhaty. Homiaajä mnǿcxät, quipxy nbawädítät. ");
INSERT INTO mirNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mänitä Jesús yhadsooyy: ―Jaꞌa xøøgaa, jim̱ä jiut jeꞌe; jaꞌa muuxy, jim̱ä pieꞌeñ jeꞌe; pero høøc̈h, jaꞌa Diosquex̱ypä, cábøch ndøjc maac̈h nbooꞌx nhäñáꞌawät. ");
INSERT INTO mirNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mänitä Jesús jaꞌa jiamiøød tuꞌug miänaaṉ̃: ―Wiindsǿṉ, mänítøch miic̈h nbaduꞌubøgaꞌañ cooc̈hä ndeedy hänajty tøø yhoꞌnä, cooc̈h hänajty tøø nyajnaax̱tägøøñä. ");
INSERT INTO mirNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mänitä Jesús yhadsooyy: ―Ween jaꞌa mjujy jaꞌa mmäguꞌughajxy yajnaax̱tägøꞌøy. Cábøch jaꞌa nmädiaꞌagy hajxy xpianøcxaaṉä. Pero miic̈h, ween quipxy nwädíjtäm. ");
INSERT INTO mirNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mänitä Jesúshajxy tiägøøyy barcojooty møødä jiamiøødhajxy. Tiuꞌubøjnä hajxy barcojooty. ");
INSERT INTO mirNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mänitä poj møc piädøꞌcy, høxtä cugujjøøyy jaꞌa nøø jiiby barcojooty. Pero tøø jaꞌa Jesús hänajty miaahoꞌnä. ");
INSERT INTO mirNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mänit hoy yuxyíijäm jaꞌa miäguꞌughajpä tuꞌug. Mänit ñämaayyä: ―Wiindsǿṉ, højts yajnähwáatsäc. Cham̱ højts nnøøhoꞌogøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mänitä Jesús yhadsooyy: ―Tii hajxy coo mwiꞌi chähgøꞌøy. Cábøch mijts jaꞌa nmädiaꞌagy hajxy jaduhṉ xñäꞌä mäbøjcä, paady hajxy mdsähgøꞌøy. Mänit piädøꞌcy. Mänitä poj jiøjcunämaꞌawøøyy møødä mejy coo quiaꞌa míiṉnät. Mänit jaduhṉ yuungøøyy. Caj ñäꞌägädä pojnä. ");
INSERT INTO mirNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mänitä miäguꞌughajpähajxy yagjuøøyy. Mänit hajxy ñiñämaayyä: ―Nebiädaꞌa jaduhṉ coo miädiaꞌagy miäbǿjcäxä høxtä jaꞌa poj møødä mejy. ");
INSERT INTO mirNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mänitä Jesúshajxy jim̱ miejch mejyhawiimb maa jaꞌa naax̱ hänajty xiøhatiän Gadara. Jim̱ä cabäsantä hänajty tuꞌug. Mänitä Jesús jäyaꞌay nämetsc ñämejtsä. Jim̱ hajxy hänajty tøø chooñ maa jaꞌa cabäsantän. Tøø hajxy hänajty miac̈hii jaꞌa møjcúꞌujäm. Jaanc̈h tehm̱ quiaꞌawiindøy hajxy hänajty ñibiädaꞌagyii. Ni pøṉ hajxy hänajty quiaꞌa yajnaxaꞌañ maa jaꞌa tuꞌujän. ");
INSERT INTO mirNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mänitä Jesús tiägøøyy wiinguyaaxǿøyyäbä: ―Jesús, tii højts xwiaꞌanaꞌañ, miic̈h Dioshuung. Cajnä yhabaady coo højts xyajcumädów̱ät. Jaꞌa møjcuꞌuhajxy jaduhṉ mänaaṉ, caꞌa jiäyaꞌayä. ");
INSERT INTO mirNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jim̱ mayhädsøm̱ hänajty wiädity tuṉwiinmänac jäguem̱juøøby. ");
INSERT INTO mirNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mänitä Jesús miänuuꞌxtaacä jaꞌa møjcuꞌuhajxy: ―Pø xyajpädsøm̱aam̱b højts yaa maa hädaa jäyaꞌayän nämetscä, naꞌañ højts jiiby nhuuc tägøꞌøy maa yøꞌø hädsøm̱ jioodootyhajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mänitä Jesús miänaaṉ̃: ―Nøcx hajxy jiiby tägøꞌøw. Mänitä møjcuꞌuhajxy ñähwaach jaꞌa jäyaꞌay nämetspä. Mänitä hädsøm̱ hajxy ñämejch. Cøjx jaꞌa hädsøm̱hajxy wyiinmänacpäyøꞌøgy. Cøjx hajxy quiuhcahnax̱y naaxøjpcøxp. Mejjiooty hajxy hoy quiugaꞌawøꞌøy. Cøjx hajxy jiiby yhoꞌogy mejjiooty. ");
INSERT INTO mirNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mänitä hädsøm̱güeendähajpähajxy chähgøꞌøbäyøꞌcy. Coo hajxy jim̱ miejch maa jaꞌa cajptän, mänit hajxy miädiaacy nebiaty hajxy hänajty tøø yhix̱y, coo jaꞌa møjcuꞌuhajxy hänajty tøø ñähwaꞌac̈h jaꞌa jäyaꞌay nämetspä. ");
INSERT INTO mirNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Cøjx jaꞌa cuꞌughajxy ñøcxy päyøꞌøguiä maa jaꞌa Jesúsän. Coo jaꞌa Jesús hajxy piaaty, mänit hajxy miänuuꞌxtaacy coo jaꞌa Jesús jim̱ chóonät maa jaꞌa ñaax̱hajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mänitä Jesúshajxy tiägǿøguiumbä barcojooty, ñajxtägajch hajxy jadähooc mejyhawiimb maa jaꞌa quiajpthajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mänitä tecymiucypiä tuꞌug quiøømiejtsä tsaajiooty maa jaꞌa Jesúsän. Jaꞌa mähdiøjc jaꞌa miäguꞌughajpähajxy jaduhṉ cøømiejtsä. Coo jaꞌa Jesús yhijxy coo hajxy hänajty miäbøcy, mänitä Jesús jaꞌa mähdiøjc ñämaayy: ―Huung, jootcugøꞌøw; tøø jaꞌa mbojpä mgädieey xñähwaꞌac̈h. ");
INSERT INTO mirNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jim̱ä ley‑yajnähixøøbiädøjc hänajty näjeꞌe tiänaꞌay jaꞌa Jesús ñähmøjc. Coo hajxy jaduhṉ miädooyy nebiä Jesús miänaaṉ̃än, mänit hajxy näjeꞌe quiopcooty tiägøøyy mädiaacpä: “Capxtägooby hädaa craa jaduhṉ maa jaꞌa Dioscøxpän.” ");
INSERT INTO mirNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ñajuøøby jaꞌa Jesús hänajty neby hajxy hänajty miädiaꞌaguiän quiopcooty. Mänit miänaaṉ̃: ―Tii haxøøgwiinmahñdy hajxy coo mmøødhaty mgopcooty. ");
INSERT INTO mirNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mädyii mädiaꞌagy maas tsip, cooc̈h hädaa mähdiøjc nnämáꞌawät: “Tøø jaꞌa mbojpä mgädieey xñähwaꞌac̈h”, tøgä maas tsip jaduhṉ cooc̈h nnämáꞌawät: “Tänaayyøꞌøg, yoꞌoyøꞌøg.” ");
INSERT INTO mirNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nyajcähxøꞌøgáam̱biøch cooc̈hä cuhdujt jaduhṉ nmøødä hädaa yaabä naax̱wiin cooc̈hä pojpä cädieey nyajnähwáꞌadsät, høøc̈h jaꞌa Diosquex̱ypä. Mänitä Jesús jaꞌa tecymiucypiä ñämaayy: ―Tänaayyøꞌøg, widsøꞌøg yøꞌø mdsaay, nøcxnä maa jaꞌa mdøjcän. ");
INSERT INTO mirNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mänitä tecymiucypiä tiänaayyøꞌcy. Mänit ñøcxnä maa jaꞌa tiøjcän. ");
INSERT INTO mirNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Coo jaꞌa cuꞌughajxy jaduhṉ yhijxy coo jaꞌa tecymiucypiä tøø yhoyøꞌøy, mänit hajxy chähgøøbiøjcy. Mänitä Dios hajxy wyiingudsähgøøyy, jeꞌeguiøxpä coo jaꞌa Jesús jaꞌa mäjaa hänajty tøø mioꞌoyii, jaꞌa Diosquex̱ypä. Cab hajxy hänajty ñajuøꞌøy pø Dioshuung hänajty jeꞌe, jaꞌa Jesús. ");
INSERT INTO mirNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mänitä Jesús jim̱ chohṉ̃. Mänitä jäyaꞌay tuꞌug yhijxy, jaꞌa xøhajpä Mateo. Jim̱ä Mateo hänajty yhäñaꞌay maa hänajty yajnähjuudiuꞌudiän. Mänitä Mateo ñämaayyä: ―Jam̱ quipxy wädíjtäm. Mänitä Mateo tiänaayyøꞌcy. Mänit jaꞌa Jesús piaduꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jim̱ä Jesús hänajty quiay tøgooty møødä miäguꞌughajpähajxy. Mänitä yajnähjuudiuutpähajxy may miejch mägaabiä, møødä jäyaꞌayhajxy caꞌa panøcxpä jaꞌa judíos quiuhdujt. Mänitä Jesús hajxy tiägøøyy møødcaabiä. ");
INSERT INTO mirNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jim̱ä fariseoshajxy hänajtypä, jaꞌa hajxy hänajty hoy jaanc̈h tehm̱ pianøcxpä jaꞌa Moisés miädiaꞌagy. Mänitä fariseoshajxy miänaaṉ̃: ―Tii yøꞌø mwiindsǿṉ coo miøødcay jaꞌa yajnähjuudiuutpähajxy møødä cubojpä cugädieeyhajxy ―nøm̱ä Jesús miäguꞌughajpähajxy ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Miädoow̱ jaꞌa Jesús jaduhṉ. Mänit miänaaṉ̃: ―Pøṉ jaduhṉ møc, caj yajtsooyøꞌøy; pøṉ jaduhṉ paꞌammøød, jeꞌeds jaduhṉ yajtsooyøøby. Jaduhṉ mäwíinøch høøc̈h nebiä mädsooyøøbiän. Páadyhøch yaa tøø nmiṉ̃ tøø nmech, nébiøch jaꞌa cubojpä cugädieeybähajxy nnämáꞌawät coo jaꞌa yhaxøøgwiinmahñdy hajxy ween ñajtshixøꞌøy. Jaꞌa hojiäyaꞌayhajxy, cábøch hajxy jeꞌe waam̱b nnämaꞌawaꞌañ. Nøcx hajxy habøc tii jaꞌa Diosmädiaꞌagy jaduhṉ ñänøøm̱by: “Chójpiøch jaꞌa njoot jaduhṉ coo hojioot hajxy mmøødhádät; cábøch jaduhṉ nmänaaṉnä coo animal hajxy myóxät maa jaꞌa høøc̈hcøxpän.” ");
INSERT INTO mirNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mänitä Jesús ñämejtsä jaꞌa Juan mäyajnäbejpä miäguꞌughajpähajxy. Mänitä Jesús miäyajtøøw̱ä: ―Tii miic̈h mmäguꞌughajpähajxy jaguiay quiaꞌa näꞌägädä hidaꞌañ. Nax̱y højts jaguiay tuꞌxøøjaty nhity tähoocjaty; jaduhṉ højts jaꞌa Dios nwiingudsähgøꞌøy. Jaanä jaduhṉä fariseoshajxy yhijpä jaguiay. ");
INSERT INTO mirNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mänitä Jesús yhadsooyy: ―Coo jaꞌa jäyaꞌayhajxy mänaa piøcy yhuꞌugy, cabä woyba wichpä hajxy jiøꞌøy xiuuc̈h. Xooṉdaacp hajxy jaduhṉ, jeꞌeguiøxpä coo jaꞌa jamiøꞌød jyiijä. Jaduhṉ mäwíinøch høøc̈h nebiä jamiøꞌødän. Páadyhøch nmäguꞌughajpähajxy jaguiay quiaꞌa hity. Habaadaam̱b jaduhṉ cooc̈h yaa ndsoonaaṉnä; mänit hajxy mäbøcypiä jaguiay yhidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Cab jaduhṉ pøṉ tucwit yhagøyøꞌøy jem̱ywyithaam. Múgäp jaꞌa jem̱ywyit jaduhṉ y maas hanax̱iä jaꞌa tucwit jaduhṉ quiǿødsät. ");
INSERT INTO mirNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jaanä jaduhṉduhm̱bä, cabä pøṉ jem̱yvyino quiudemøꞌøy tucwajhacxujiooty. Cǿødsäp jaꞌa wajhacxuy jaduhṉ y høxyógäp jaꞌa vino jaduhṉ. Haagä tägóyyäp jaꞌa wajhacxuy jaduhṉ møødä vino. Pero jiibiä jem̱yvyino hajxy quiudemøꞌøy maa jaꞌa wajhacxuy jem̱ybiän. Jaduhṉ ni mädyii quiaꞌa tägóyyät. ");
INSERT INTO mirNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Cajnä jaꞌa Jesús hänajty miädiaacpädøꞌøy, mänitä tsajtøjcwiindsǿṉ tuꞌug miejch. Mänitä Jesús wyiingoꞌnaaguiädaacä. Mänit ñämaayyä: ―Naam̱hóꞌogyhøc̈hä nhuung jaꞌa toꞌoxypä. Coo miic̈h nøcxy mnähdoṉ̃, mänit jiujypiøjtägátsät. ");
INSERT INTO mirNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mänitä Jesús piädøꞌcy. Mänit jaayaꞌay miøødtuꞌubøjcy møødä Jesús miäguꞌughajpähajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Jim̱ä tajjäyaꞌay hänajty tuꞌug høx̱haam pianøcxy. Paꞌammøød hänajty jeꞌe. Majmetscjumøjt jaꞌa ñøꞌty hänajty tøø wyiꞌi xieeꞌxy, weenjaty weenjaty. Jaduhṉä tajjäyaꞌay hänajty miädiaꞌagy quiopcooty: “Nägóoyyøch jaꞌa wyitpaꞌa nnähdóoṉät, mänítøch nmøcpǿgät.” Coo jaꞌa Jesús jaꞌa tajjäyaꞌay jiäguyohdiägǿøyyä, mänitä wyitpaꞌa ñähdóoṉäxä. ");
INSERT INTO mirNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mänitä Jesús yheeꞌpwiimbijty, Mänit jaꞌa tajjäyaꞌay yhijxy. Mänit miänaaṉ̃: ―Huung, jootcugøꞌøw; tøø jaduhṉ mmøcpøcy, jeꞌeguiøxpä coo tøø mmäbøcy. Mänitiä jaꞌa tajjäyaꞌay miøcpøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mänitä Jesúshajxy jim̱ miejch maa jaꞌa tsajtøjcwiindsǿṉ tiøjcän. Jiibiä xuux̱pädøjc‑hajxy hänajty yhoꞌogyjiäyaꞌawyiinxuꞌuxy. Jiibiä jäyaꞌayhajxy hänajty wyiꞌi yhaamhaty. ");
INSERT INTO mirNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Mänitä Jesús miänaaṉ̃: ―Pädsøm̱ hajxy jiiby. Cab yøꞌø tøø yhoꞌogy, näꞌä maab yøꞌøduhṉ. Mänitä Jesús ñäxiicä. ");
INSERT INTO mirNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cøjx hajxy jaduhṉ piädsøm̱y. Mänitä Jesús tiøjtägøøyy. Mänitä toꞌoxyhänaꞌc quiøꞌømajch. Mänitä toꞌoxyhänaꞌc yhäñaayyøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mänitä mädiaꞌagy wiädijty wiinduhm̱yhagajpt coo jaꞌa toꞌoxyhänaꞌc tøø yagjujypiøgyii. ");
INSERT INTO mirNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Coo jaꞌa Jesúshajxy jim̱ chohṉ̃, mänitä wiindshajxy nämetsc piaduꞌubøjcy yáax̱äp: ―Højts näxúuꞌtsäc. David miic̈h hijty mhaphajpy mdeedyhajpy. ");
INSERT INTO mirNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Coo jaꞌa Jesús tiøjtägøøyy, mänitä wiindshajxy miäwiingooṉ̃. Mänitä Jesús miänaaṉ̃: ―Nej, mmäbøjpy hajxy jaduhṉä cooc̈hä mäjaa nmøødä coo hajxy nyaghijxǿꞌøgädä. Mänit hajxy miänaaṉ̃: ―Wiindsǿṉ, nmäbøjpy højts. ");
INSERT INTO mirNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mänitä Jesús jaꞌa wiinds wyiinhajxy ñähdooṉä. Mänitä Jesús miänaaṉ̃: ―Ween hajxy mhijxøꞌøgy coo hajxy tøø mmäbøcy. ");
INSERT INTO mirNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mänit hajxy yhijxøꞌcy. Mänitä Jesús miänaaṉ̃: ―Caꞌa pøṉ hajxy mnäꞌägädä hawaaṉä. ");
INSERT INTO mirNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Coo jaꞌa wiindshajxy jim̱ chohṉ̃, mänit hajxy tiägøøyy mädiaꞌagy‑yajwädijpä coo hajxy tøø yaghijxøꞌøgyii jaꞌa Jesúsäm. ");
INSERT INTO mirNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mänitä huum tuꞌug yajmejtsä maa jaꞌa Jesúsän. Tøø hänajty miac̈hii jaꞌa møjcúꞌujäm. ");
INSERT INTO mirNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mänitä Jesús jaꞌa møjcuꞌu jiiby yajpäyøꞌcy. Mänitiä jaꞌa huum quiapxøꞌcy. Yagjuøøyy jaꞌa jäyaꞌayhajxy jaduhṉ. Mänit hajxy miänaaṉ̃: ―Ni mänaa jaduhṉ pøṉ tii quiaꞌa yagjadyii nebiä hädaajän yaa Israelnaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mänitä fariseoshajxy miänaaṉ̃: ―Paady yøꞌøyaꞌay jaꞌa møjcuꞌu yajpäyøꞌøgy, coo jaꞌa møjcuꞌugong miäjaa miøødhajtä. ");
INSERT INTO mirNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Cøjx jaꞌa Jesús wiädity wiinduhm̱yhagajpt. Homiaajä hänajty wiädity, jiiby hänajty yajnähixøꞌøy tsajtøgooty coo jaꞌa Dios jaꞌa miäjaa mobädajp yajcähxøꞌøgaꞌañ. Yajnajxyp hänajty homiädyii paꞌamä. ");
INSERT INTO mirNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ñäxuuꞌchp jaꞌa Jesús jaꞌa majiäyaꞌay hänajty. Jaduhṉ mäwíinäts hajxy hänajty nebiä meegän, jaꞌa cajpä wyiindsǿṉ. Nebiä tägowiädijpän hajxy hänajty jeꞌe. Nebiä jootmayhajpän hajxy hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mänitä Jesús ñämaayy jaꞌa miäguꞌughajpähajxy: ―Yøꞌø majiäyaꞌayhajxy, hoy jaduhṉ cooc̈hä nmädiaꞌagy hajxy xmiäbǿjcät. Pero cab højts nnämáyyäm, højts jaꞌa mädiaꞌagy nyajwáꞌxämbä. ");
INSERT INTO mirNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mänuuꞌxtaꞌag jaꞌa Dios hajxy coo ween jaꞌa mäguꞌughajpä hajxy xjiaac móoyyämät, neby højts jaꞌa mädiaꞌagy hajxy xmiøødyajwáꞌxämät. ");
INSERT INTO mirNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Mänitä Jesús jaꞌa miäguꞌughajpä miøjyaax̱y jaꞌa nämajmetspä. Mänitä cuhdujt miooyy coo jaꞌa møjcuꞌu hajxy yajpäyǿꞌøgät, coo homiädyii paꞌamä hajxy yajnáxät. ");
INSERT INTO mirNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jaduhṉä nämajmetspähajxy hänajty xiøhaty: Simón Pedro møødä piuhyaꞌay Andrés; jaꞌa Zebedeo yhuunghajxy, Jacobo møødä Juan; ");
INSERT INTO mirNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe; Bartolomé; Tomás; Mateo jaꞌa yajnähjuudiuutpä; Jacobo, jaꞌa Alfeo yhuung; Lebeo Tadeo; ");
INSERT INTO mirNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón jaꞌa cananista; Judas Iscariote, jaꞌa Jesús hänajty yajyaghoꞌogáaṉäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mänitä Jesús jaꞌa nämajmetspähajxy quiejxy mädiaꞌagy‑yajwaꞌxpä. Mänit ñämaayy: ―Caꞌa hajxy jim̱ mnøcxy maa jaꞌa caꞌa judíoshajxy chänaꞌayän, y caꞌa hajxy jim̱ mnøcxy Samarianaaxooty. Yaayyä hajxy jaduhṉ mwädítät, yaa Israelnaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jaꞌa jäyaꞌayhajxy yaabä, jaduhṉ mäwíinäts hajxy jeꞌe nebiä meeg tägowiädijpän. ");
INSERT INTO mirNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mnägápxäp hajxy jaduhṉ coo jaꞌa Dios jaꞌa miäjaa mobädajpä yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Myajnáxäp hajxy homiädyii paꞌamä møødä haxøøgpaꞌam. Myagjujypiǿgäp jaꞌa hoꞌogyjiäyaꞌay hajxy. Myajpäyǿꞌøgäp jaꞌa møjcuꞌu hajxy. Nnäꞌä móobiøch mijts hädaa cuhdujt; cábøch mijts nyagjuyaꞌañ; jaduhṉ mijtspä, cab hajxy myagjúubiät. ");
INSERT INTO mirNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Cabä xädøꞌøñ hajxy mgónät ni weeṉ̃tiä. ");
INSERT INTO mirNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Cabä morral hajxy mwídsät. Tuꞌuquiä camiixy hajxy mwídsät. Cabä cøꞌøg hajxy mejtstehṉg mmänǿcxät. Cabä cuhdajt hajxy mgábät. Jim̱ hajxy mmägayaꞌañ mmähuꞌugaꞌañ maa hajxy hänajty mhamejtstaꞌagaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Coo hajxy maa mgajptägǿꞌøwät, jim̱ä jäyaꞌay hajxy mhøxtáꞌawät jaꞌa hojiootmøødpä; jim̱ hajxy mhamejtstáꞌagät. Jiiby hajxy mhídät høxtä coonä hajxy hänajty mduꞌubøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Coo hajxy mdøjtägǿꞌøwät, mänit hajxy myajpóoꞌxät. ");
INSERT INTO mirNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Coo hajxy jaduhṉ xyajtøjtägǿꞌøwät hamuumduꞌjoot, mänit hajxy jaduhṉ quiunuuꞌxǿøjät jaꞌa Diósäm; pø caj, cab hajxy jaduhṉ quiunuuꞌxǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Coo hajxy jaduhṉ xquiaꞌa näꞌägä jøjpøgǿꞌøwät, coo jaꞌa mmädiaꞌagyhajxy xquiaꞌa näꞌägä mädóow̱ät, mänit hajxy jim̱ mdsóonät. Mänitä mdecy hajxy mwiinwop mwiinxídät, nebiä hijxtahṉd jaduhṉ miähmǿꞌøwät coo mijts jaduhṉ tøø xquiaꞌa yajtøjtägøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tøyhájtäts mijts nnämaꞌay, coo yhabáadät coo jaꞌa jäyaꞌayhajxy quiumädow̱aꞌañ, maas hanax̱iä yøꞌø cajpt jaduhṉ quiumädow̱aꞌañ quejee jaꞌa Sodomacajpt møødä Gomorracajpt. ");
INSERT INTO mirNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Maac̈h mijts nwiinguex̱iän, haxøøgwiinmahñdy jaꞌa jäyaꞌayhajxy jim̱ miøød. Paady hajxy nähix̱ hahixøꞌø mnibiädaꞌagǿøjät. Meeꞌxxieemy hajxy jaduhṉ mwädítät. ");
INSERT INTO mirNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mniyajcopcøꞌøwǿøjäp mijts. Xyajcøꞌødägǿꞌøwäp mijts maa jaꞌa tuuṉgmøødpän. Mänítäts hajxy xwyiinwop xjiøjwóbät maa jaꞌa chajtøgootyhajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Høxtä jim̱ hajxy xyajmedsaꞌañ maa jaꞌa gobiernä wyiinduumhajxiän, møød jim̱ maa jaꞌa caꞌa judíos wyiinduumhajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero coo hajxy jaduhṉ xyajmédsät maa jaꞌa wyiinduumhajxiän, cab hajxy mdaj mmáyät waam̱baty hajxy hänajty mmädiaꞌagaꞌañ. Coo jaduhṉ yhabáadät, mänitä Dios jaduhṉ xyhawáaṉät waam̱baty hajxy jaduhṉ mmänáꞌanät. ");
INSERT INTO mirNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Cab hajxy hamdsoo mmädiaꞌagaꞌañ. Dioshespírituhaam hajxy jaduhṉ mmädiaꞌagaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Haxøøg jaduhṉ jiadaꞌañii. Hamdsoo hajxy ñiñähanuuꞌxøꞌøwaꞌañii jaꞌa tuꞌqueꞌexpä‑jäyaꞌay. Jaduhṉ jaꞌa tieedyhajxy jiatcøꞌøwaam̱bä møødä yhuunghajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jaꞌa høøc̈hcøxpä mijts jaꞌa jäyaꞌayhajxy nägøx̱iä xmiähaṉhadaꞌañ. Pøṉ jaduhṉ meeꞌxtujp cøjxtaꞌaxiøø, jeꞌeds jaduhṉ mähmøꞌøwaam̱b hodiuum. ");
INSERT INTO mirNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Coo mijts hajxy xchaac̈htiúnät mäduꞌughagajpt, mänit hajxy mbäyǿꞌøgät, mänit hajxy mnǿcxät wiingtuum. Tøyhájtäts mijts nnämaꞌay, cooc̈h hänajty ngädaꞌagaꞌañ, høøc̈h jaꞌa Diosquex̱ypä, cahnä cajpt hajxy hänajty mwiinwädityñä maa jaꞌa judíoshajxy chänaꞌayän. ");
INSERT INTO mirNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Cabä pøṉ jaduhṉ jiaty nebiä wyiindsǿṉ jiatiän. ");
INSERT INTO mirNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Coo hajxy jaduhṉ mjádät nebiä mwiindsøṉhajxy jiatiän, jootcujc hajxy jaduhṉ mhídät. Cooc̈hä jäyaꞌayhajxy jaduhṉ tøø xñämaꞌay: “Møjcuꞌu”, jaduhṉ mijts hajxy xñämaꞌawaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Cabä cuꞌug hajxy mdsähgǿꞌøwät. Nebiaty hajxy jaduhṉ jiatcøꞌøy hameeꞌch, cähxøꞌøgaam̱b jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Waam̱bátyhøch mijts hameeꞌchhaam nnajtscapxǿøyyäm, majiäyaꞌayhagujc hajxy myajcapxǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Cab hajxy mdsähgǿꞌøwät pøṉ jaꞌa mnaax̱niꞌx hajxy xyaghóꞌcäp; cabä mháañämä hajxy jaduhṉ xyaghóꞌcät. Jaꞌa Dios hajxy mdsähgǿꞌøwäp; jeꞌedsä cuhdujt jaduhṉ møød coo hajxy jiiby xquiéxät haxøøgtuum. Jiiby jaꞌa mnaax̱niꞌxhajxy quiuhdägóyyät møødä mháañämähajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Jaꞌa muuxyhuunghajxy, coo hajxy quiaꞌay, yhijxyp jaꞌa nDeedyhájtämhajxy jaduhṉ, hoy hajxy quiaꞌa ja tsow̱ä. ");
INSERT INTO mirNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jaanä jaduhṉ mijts xyhijxpä, høxtä xñajuǿøyyäp mijts naag mijts mguhwaay. ");
INSERT INTO mirNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Cabä jäyaꞌay hajxy mdsähgǿꞌøwät; hix̱, mmaas tsoobaatp mijts quejee jaꞌa muuxyhajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Pønjátyhøch jaꞌa nmädiaꞌagy xmiøødyajtuꞌugøøby maa jaꞌa cuꞌugwiinduumän, mänítøch jaꞌa miädiaꞌagyhajxy nmøødyajtuꞌugøꞌøwaam̱bä maac̈hä nDeedy wyiinduumän jim̱ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero pønjátyhøch jaduhṉ tuꞌugmädiaꞌagy tøø xquiaꞌa møødhity maa jaꞌa cuꞌugwiinduumän, ni høøc̈h jaduhṉ tuꞌugmädiaꞌagy ngaꞌa møødhidaam̱bä maac̈hä nDeedy wyiinduumän jim̱ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Cooc̈h yaa tøø ngädaꞌagy, paadiä jäyaꞌayhajxy jaduhṉ ñimiädsibøꞌøwaꞌañii jaꞌa høøc̈h nmädiaꞌagyquiøxpä. Cab hajxy jootcujc yhidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Tuꞌtøjc hajxy jaduhṉ ñimiädsibøꞌøwaꞌañii, møødä tiaj møødä tieedy, møødä ñøøx møødä miajc, møødä jiaxieꞌeb møødä xiocy. ");
INSERT INTO mirNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Pøṉä tiaj pøṉä tieedy maas tsojp quejeec̈h høøc̈h jaduhṉ xchocy, cábøch jaꞌa nmädiaꞌagy hoy xpianǿcxät. Y pøṉä ñøøx pøṉä miajc maas tsojp quejeec̈h høøc̈h jaduhṉ xchocy, ni jeꞌec̈h jaꞌa nmädiaꞌagy hoy xquiaꞌa panǿcxäbät. ");
INSERT INTO mirNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pøṉä jioot tsojp cooc̈h høøc̈h xpianǿcxät, pero cabä jioot jaduhṉ chocy coo chaac̈hpǿgät nébiøch jaduhṉ ndsaac̈hpøgaꞌañän, cábøch nmädiaꞌagy jaduhṉ hoy xpianǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pøṉä jiugyhajt jaduhṉ ja wiꞌi yaghoyøꞌøwaam̱b, tägóyyäp jaꞌa jiugyhajt jaduhṉ. Pero pøṉä jiugyhajt najtshixøꞌøwaam̱b jaꞌa høøc̈hcøxpä, jeꞌeds hodiuum nøcxaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Pøṉ mijts jaduhṉ xchojp, jaduhṉ mäwíinøch høøc̈h xchojpä. Y pǿṉhøch høøc̈h jaduhṉ xchojp, jaduhṉ mäwíinädsä Dios jaduhṉ chojpä, jaꞌac̈h tøø xquiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jaꞌa Diosquex̱yhajxy, hodiuum hajxy ñøcxaꞌañ. Jaanä jim̱ hajxy ñøcxaam̱bä pøṉ jaduhṉ tsojp jaꞌa Diosquex̱y. Paady hajxy chogyii coo hajxy jaduhṉ Dyiosquex̱iä. Jaanä jim̱ hajxy ñøcxaam̱bä hodiuum pøṉ jaduhṉ tsojp jaꞌa hojiäyaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Coo hädaa häyoobäyaꞌay tøchñøø ñäꞌä moꞌowǿøjät jeꞌeguiøxpä cooc̈h jaduhṉ xpianøcxy, mänit jaayaꞌay piädaꞌagǿøjät hodiuum, jaꞌa nøø tøø yéquiäbä. Tehm̱ tiøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Coo jaꞌa Jesús jaꞌa jiamiøødhajxy yajwiingapxøøbiädøøyy, mänit jim̱ chohṉ̃. Mänit tiägøøyy yajnähixøøbiä maa jaꞌa cajpt mäwiingoṉän. ");
INSERT INTO mirNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jaꞌa Juan, tsum̱yhäñaaby hänajty jeꞌe. Coo miädoyhajty coo jaꞌa Cristo hänajty wiädity yajnähixøøbiä, mänitä miäguꞌughajpä metsc quiejxy maa jaꞌa Jesúsän. ");
INSERT INTO mirNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mänitä Jesús hajxy miäyajtøøyy: ―Nej, miic̈h jaꞌa Crístojä, jaꞌa Dios jaduhṉ quiexaam̱biä, tøgä wiinghänaꞌc jeꞌejä. ");
INSERT INTO mirNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mänitä Jesús yhadsooyy: ―Nøcx jaꞌa Juan hajxy hawaaṉä neby hajxy xii mhix̱ mmädoyy. ");
INSERT INTO mirNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nøcx hajxy yajmøødmädiaꞌag coo jaꞌa wiindshajxy tøø yhijxøꞌøgy, coo jaꞌa tecymiaꞌadpähajxy tøø yoꞌoyøꞌøgy, coo jaꞌa haxøøgpaꞌammøødpähajxy tøø ñähwaꞌac̈h, coo jaꞌa cuhnatpähajxy tøø miädoow̱øꞌøgy, coo jaꞌa hoꞌogyjiäyaꞌayhajxy tøø jiujypiøcy, coo jaꞌa häyoobäyaꞌayhajxy tøø yajmøødmädiaꞌagyii jaꞌa Diosmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jootcujc hajxy jaduhṉ yhity jaꞌac̈h nmädiaꞌagy hajxy hamuumduꞌjoot tøø xmiäbǿjcäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Coo jaꞌa Juan miäguꞌughajpähajxy wyiimbijty, mänitä Jesús jaꞌa cuꞌug tiägøøyy møødmädiaacpä jaꞌa Juancøxpä. ―Coo hajxy tøø mhoy pactuum, jaꞌa Juan miädiaꞌagy hajxy hänajty mmädow̱áaṉäp, túhm̱äts. Cabä tsajcapy pojyuꞌxpä hajxy hoy mhix̱y. Caj pues, paady hajxy jim̱ tøø mhoy coo jaꞌa Juan jaꞌa miädiaꞌagy hajxy hänajty mmädow̱aaṉä. ");
INSERT INTO mirNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","9","Diosquex̱y jeꞌe, paadiä miädiaꞌagy hajxy hoy tøø mmädoow̱ä, hoy jaꞌa howyit hänajty quiaꞌa ja møødä nebiä mäyøøjäyaꞌayhajxy miøødän. Tøyhajt jaduhṉ coo jaꞌa Juan jaꞌa Diosmädiaꞌagy yajwiingapxøꞌøy. Pero jaꞌa Diosmädiaꞌagy hajxy näꞌä jaac yajnähixøøbiä, jeꞌedsä cuhdujt hajxy maas may tøø mioꞌoyii jaꞌa Diósäm. ");
INSERT INTO mirNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jaꞌa Diosmädiaꞌagy jecy mädiáacäbä, Juan jeꞌe. Nøm̱ä Dios jecy miänaaṉ̃ coo jaꞌa quiuguex̱y hänajty jayøjp quiexaꞌañ maa jaꞌa cuꞌugän, ween yajwiinxiic yajwiingapxøꞌøy coo jaꞌa yhaxøøgcuhdujt hajxy ñajtshixǿꞌøwät. Høx̱háamhøch hänajty ngädaꞌagaꞌañ. Jayøjp jaꞌa Juan jiaanc̈h quejxä; høx̱háamhøch njaanc̈h cädaacy. ");
INSERT INTO mirNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ni pøṉ jaduhṉ jädaꞌahaty quiaꞌa mäbaady hädaa yaabä naax̱wiin nebiä Juan mäyajnäbejpä jaꞌa cuhdujt miøødän. Tøyhajt jaduhṉ. Pero cooc̈h hänajty tøø nhoꞌnä, cooc̈h hänajty tøø nnøcxtägach maac̈h nhuuc tsohm̱bän, pønjaty jaꞌa Diosmädiaꞌagy mäbøgaam̱b jaꞌa høøc̈hcøxpä, maas mayyä cuhdujt hajxy hänajty miøødhadaꞌañ quejee jaꞌa Juan miøødä, hoy jaꞌa møjcuhdujt hajxy hänajty quiaꞌa ja møødä. ");
INSERT INTO mirNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Coo jaꞌa Juan tiägøøyy mäyajnäbejpä, høxtä jeꞌenä jädaꞌanäbaadyñä, nägøꞌø nädecypiä jaꞌa jäyaꞌayhajxy jia wiꞌi tiägøꞌøwaꞌañ maa jaꞌa Dios wyiinduumän. ");
INSERT INTO mirNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","14","Jaꞌa Diosquex̱yhajxy jecypiä, jaduhṉ hajxy jecy miänaaṉ̃ coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. Jaduhṉä Moisés miädiaꞌagy miänaam̱bä. Pero jayǿjpäc jaꞌa Elías hijty myinaꞌañ. Y coo jaꞌa Juan tøø miech, Elías jeꞌe, pø mwiinjuøꞌøwaam̱by hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pøṉ mädohnd møød, ween miädoy. ");
INSERT INTO mirNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Pänébiøch jäyaꞌayhajxy nyajmäbáadät jaꞌa jädaꞌahatypä. Cab hajxy tii yhojiäwøꞌøwaꞌañ. Jaduhṉ mäwíinäts hajxy jeꞌe nebiä pigänaꞌc wiinhecpän. Coo hajxy nax̱y miech häyøꞌpä tøjpaꞌc, mänitä miäbigänaꞌc hajxy ñämaꞌay: ");
INSERT INTO mirNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tøø højts nja xuꞌuxy, pero cab hajxy tøø mhech. Tøø højts hojiøøñä nja høy, pero cab hajxy tøø mjøꞌøy.” ");
INSERT INTO mirNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Coo jaꞌa Juan miejch, cab hänajty quiayaꞌañ yhuꞌugaꞌañ. Mänit mijts mnänøøm̱y coo jeꞌe quiuꞌumañøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mänítøch nbamejtspä, høøc̈h jaꞌa Diosquex̱ypä. Mänítøch ndägøøyy caabiä huucpä. Jadúhṉhøch mijts xñänøøm̱bä cooc̈h nwiꞌi quiayaꞌañ cooc̈h nwiꞌi yhuꞌugaꞌañ, cooc̈hä cubojpä cugädieeybä nmäguꞌughaty møødä yajnähjuudiuutpädøjc. Pero yajcähxøꞌøgaam̱by jaꞌa Dios jaduhṉ jaꞌa wyiinmahñdyhaam cooc̈h jaꞌa tøyhajt jaduhṉ nmøødä. ");
INSERT INTO mirNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mänitä Jesús tiägøøyy hamänajpä. Jaꞌa cajptjäyaꞌayhajxy jaduhṉ hojjä, jaꞌa hajxy hänajty tsänaabiä maa jaꞌa Jesús jaꞌa hoy‑yagjuøøñäjatypä hänajty tøø jia yajcähxøꞌøguiän. Paady jaduhṉ yhamänajty, coo yhaxøøgwiinmahñdy hajxy hänajty tøø quiaꞌa najtshixøꞌøy. Mänitä Jesús miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Haxøøg mijts mjadaꞌañ mhabetaꞌañ, mijts yaa tsänaabiä Corazín møødä Betsaida. Jaꞌa jecyjiäyaꞌayhajxy hijty jim̱ tsänaabiä Tiro møødä Sidón, coo hajxy häxøpy tøø yhix̱y jaꞌa hoy‑yagjuøøñäjatypä nej mijts tøø mja hix̱iän, tøø jaꞌa yhaxøøgwiinmahñdy hajxy häxøpy ñajtshixøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tøyhajt jaduhṉ, coo jaꞌa Dios yaghabáadät, maas haxøøgtuum mijts jaduhṉ xpiädaꞌagaꞌañ quejee jaꞌa jäyaꞌayhajxy jim̱ jecy tsänáayyäbä Tiro møødä Sidón. ");
INSERT INTO mirNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y mijts jim̱ tsänaabiä Capernaum, mja wiꞌi yajcumayaam̱b hajxy jaduhṉ. Pero cabä Dios hajxy jaduhṉ xquiumayaꞌañ. Jaꞌa jecyjiäyaꞌayhajxy hijty jim̱ tsänaabiä Sodoma, coo jaꞌa hoy‑yagjuøøñäjatypä hajxy häxøpy tøø yhix̱y nej mijts tøø mja hix̱iän, cab hajxy häxøpy tøø quiuhdägoy. ");
INSERT INTO mirNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tøyhajt jaduhṉ, coo jaꞌa Dios yaghabáadät, maas haxøøgtuum mijts xpiädaꞌagaꞌañ quejee jaꞌa jäyaꞌayhajxy jim̱ jecy tsänáayyäbä Sodoma. ");
INSERT INTO mirNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mänitxøø jaꞌa Jesús miänaaṉ̃: ―Teedy, miic̈h nbaꞌyaax̱yp. Miic̈h jim̱ häñaaby tsajpootyp; miic̈h yaa Dioshajp maa hädaa yaabä naax̱wiinän. Dioscujúꞌuyäp coo jaꞌa tøyhajt tøø myajnähixøꞌøy jaꞌa hajxy tii caꞌa jajpä. Caj tøø myajnähixøꞌøy jaꞌa hajxy tyijy jajpä. ");
INSERT INTO mirNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tøyhajt jaduhṉ, Teedy, jeꞌeguiøxpä coo miic̈h mjoot jaduhṉ chocy. ");
INSERT INTO mirNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mänitä Jesús miänáaṉgumbä: ―Tøøc̈hä nDeedy jaꞌa tøyhajt xquiøx̱y yajcøꞌødägøꞌøy. Cábøch pøṉ xyhix̱yhaty, høøc̈h jaꞌa Dioshuung. Tøyhajt jaduhṉ. Jagóoyyøc̈h nDeedy xyhix̱iä. Y cábøch jaꞌa nDeedy pøṉ xyhix̱yhajtä. Jagóoyyøc̈h jaduhṉ nhix̱iä, høøc̈h jaꞌa Dioshuung. Nyajnähdíjäbøch pønjátyhøch nDeedy hix̱yhádäp. ");
INSERT INTO mirNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","Mijts, pøṉ jaduhṉ caꞌa meeꞌxtugaam̱b neby hajxy hijty mguhdujthatiän, høøc̈h nguhdujt habǿjcäc. Hojióothøch nmøød; cábøch nyajcumayaꞌañ. Mänítäts jaꞌa hoybä weenbä hajxy mbáadät. Cábøch jaꞌa jemc̈hpä mapxypä jaduhṉ nbädaꞌagaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mänitxøø jaꞌa Jesúshajxy hänajty wiädity trigoniꞌibyquiujc pooꞌxxiøøjooty. Yähóꞌcäp jaꞌa Jesús jiamiøødhajxy hänajty. Mänit hajxy tiägøøyy trigotøjpä. ");
INSERT INTO mirNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Coo jaꞌa fariseoshajxy jaduhṉ yhijxy, mänitä Jesús hajxy ñämaayy: ―Huug hix̱, xiidsä mmäguꞌughajpä trigo hajxy wyiꞌi tiøjy. Cabä cuhdujt jaduhṉ myiṉ̃ coo hajxy tii ndúuṉämät jaꞌa pooꞌxxiøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mänitä Jesús miänaaṉ̃: ―Nej, cahnä jaꞌa Diosmädiaꞌagy hajxy mgapxiä. Jim̱ jaduhṉ myiṉ̃ cujaay coo jaꞌa Davidhajxy yähoꞌpøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mänit hajxy tiägøøyy Diostøgooty. Mänitä Diostsajcaagy hajxy quiaayy, jaꞌa teedyhajxy hänajty tøø quiuyoxǿꞌøyäbä. Cabä cuhdujt hänajty pøṉ miøødä coo hajxy quiáyät ni jaꞌa Davidhajxy. Jagooyyä teedy jaꞌa cuhdujt hajxy hänajty miøødä coo hajxy quiáyät. ");
INSERT INTO mirNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jaduhṉ cujaay myiim̱bä maa jaꞌa Moisés miädiaꞌaguiän coo jaꞌa teedyhajxy tsajtøgootypä quiaꞌa näꞌägädä pooꞌxy jaꞌa pooꞌxxiøøjooty; y cab jaduhṉ ñejpiä. ");
INSERT INTO mirNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Y høøc̈h, maas mǿc‑høch jaꞌa cuhdujt jaduhṉ nmøødä quejee jaꞌa tsajtøjc. ");
INSERT INTO mirNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Caj mijts mwiinjuøꞌøy waam̱b jaꞌa Diosmädiaꞌagy jaduhṉ miänaꞌañ: “Mänáam̱bøch jaduhṉ coo hojioot hajxy mmøødhádät; cábøch jaduhṉ nmänaꞌañ coo animal hajxy myóxät jaꞌa høøc̈hcøxpä.” Coo hajxy jaduhṉ mwiinjuǿꞌøwät, cabä jäyaꞌay hajxy näꞌä nägoodä mwiingapxpédät. ");
INSERT INTO mirNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Høøc̈h jaꞌa Diosquex̱ypä, nmǿødhøch cuhdujt jaduhṉ høxtä maa jaꞌa pooꞌxxiøøbaadiän. ");
INSERT INTO mirNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mänitä Jesús jim̱ chohṉ̃. Mänit tiägøøyy tsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jiibiä mähdiøjc hänajty tuꞌug; cøꞌødøꞌøds hänajty tuꞌnax̱. Jiibiä fariseoshajxy hänajty näjeꞌe tiänaabiä. Mänitä Jesús miäyajtøøw̱ä: ―Nej, hoy jaduhṉ coo jaꞌa paꞌamjäyaꞌay myajmøcpǿgät jaꞌa pooꞌxxiøøjootiä. Paadiä fariseoshajxy jaduhṉ miänaaṉ̃, yhøxtaaby jaꞌa wiinmahñdy hajxy hänajty nebiä Jesús hajxy yajtsumǿøjät. Coo jaꞌa Jesús jaꞌa paꞌamjäyaꞌay yajmøcpǿgät jaꞌa pooꞌxxiøøjooty, mänitä Jesús hajxy hänajty yajtsumaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mänitä Jesús yhadsooyy: ―Hoy pues. Coo pøṉ mieeg quiugaꞌawøꞌøy nøøjutjooty jaꞌa pooꞌxxiøøjooty, mänit hajxy nøcxy yajpädsøm̱y, túhm̱äts. ");
INSERT INTO mirNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Y maas tsoobaatp jaꞌa jäyaꞌay quejee jaꞌa meeg. Hoy jaduhṉ coo jäyaꞌay mnäxúudsät jaꞌa pooꞌxxiøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mänitä Jesús jaꞌa mähdiøjc ñämaayy: ―Xajtøw̱ yøꞌø mgøꞌø. Mänit xiajtøøyy. Mänit miäbaaty nebiä tuꞌugpän. ");
INSERT INTO mirNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mänitä fariseoshajxy tiøjpädsøøm̱y. Mänit hajxy quiojyquiapxyhajty nebiä Jesús hajxy yaghóꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Coo jaꞌa Jesús jaduhṉ miädoyhajty, mänit jim̱ chohṉ̃. Mänitä jäyaꞌay may piaduꞌubøjcy. Mänitä Jesús jaꞌa paꞌamjäyaꞌay yajmøcpøjcy nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mänit jaduhṉ miänaaṉ̃ coo hajxy quiaꞌa nägápxät pøṉ jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jaduhṉdsä tiøjiajty nebiä Isaías jecy miänaaṉ̃än, jaꞌa Diosquex̱ypä. Dios jaduhṉ mänaam̱b: ");
INSERT INTO mirNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Høøc̈hä nmoonsä hädaa, jaꞌac̈h tøø nwiimbíyyäbä. Ndsójpiøch jaduhṉ. Jootcújc‑høch nnijiäwøꞌøyii yøꞌøgøxpä. Nbädaꞌagáam̱biøch jaꞌa nhEspíritu maa yøꞌøjän. Høøc̈h nguhdujt jaduhṉ xyajwiingapxøꞌøwáaṉäp maa jaꞌa jäyaꞌayhajxy nägøx̱iän. ");
INSERT INTO mirNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Caj chiptunaꞌañ; caj yaꞌaxaꞌañ caj jiogaꞌañ. Hahuum jaduhṉ wiäditaꞌañ cajptooty. ");
INSERT INTO mirNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","21","Jiootcapxmøcpøgaam̱by pøṉ hobiä nejpiä mäbøjp. Mäbøgáaṉäxäp jaꞌa miädiaꞌagy jaꞌa jäyaꞌayhajxy nägøx̱iä. Mänit jaduhṉ tiägøꞌøwaꞌañ hoyhanehm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mänitä mähdiøjc tuꞌug yajmejtsä maa Jesúsän. Wiindsä mähdiøjc hänajty, møød hänajty yhuumä, møød jaꞌa møjcuꞌubaꞌam hänajty miøødä. Mänitä Jesús jaduhṉ yajnähwaach, yaghijxøꞌcy, yajcapxøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mänitä jäyaꞌayhajxy nägøx̱iä yagjuøøyy. Mänit hajxy ñiñämaayyä: ―Nej, David yhap yhocädaꞌa yøꞌøduhṉä. ");
INSERT INTO mirNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Coo jaꞌa fariseoshajxy jaduhṉ miädooyy, mänit hajxy miänaaṉ̃: ―Coo yøꞌø craa jaꞌa møjcuꞌuwiinmahñdy jaduhṉ miøødä, paadiä møjcuꞌubaꞌam jaduhṉ yajnähwaꞌac̈h. ");
INSERT INTO mirNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ñajuøøbiä Jesús hänajty nebiä fariseoshajxy hänajty wyiinmahñdyhaty. Mänit miänaaṉ̃: ―Coo jaꞌa tuꞌhagajptpä jäyaꞌayhajxy ñimiädsibøꞌøwǿøjät, cuhdägóyyäp jaꞌa quiajpthajxy jaduhṉ. Y coo jaꞌa tuꞌugtøgootypä jäyaꞌayhajxy ñimiädsibøꞌøwǿøjät, cab hajxy hoy yhíjnät tuꞌugtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jaanä jaduhṉduhm̱bä, coo jaꞌa møjcuꞌuhajxy ñimiädsibøꞌøwǿøjät, tägóyyäp jaꞌa wyiinmahñdyhajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hoorä, mijts jaduhṉ mänaam̱b cooc̈h jaꞌa møjcuꞌubaꞌam nyajnähwaꞌac̈h jaꞌa møjcuꞌuwiinmahñdyhaam. Coo häxøpy jiaduhṉä, maa mijts jaꞌa mjamiøød jaꞌa wiinmahñdy hajxy piaady coo jaꞌa møjcuꞌubaꞌam hajxy yajnähwaꞌac̈h. Hamdsoo hajxy myajcähxøꞌøgy coo jaꞌa tøyhajt hajxy mgaꞌa møødä. ");
INSERT INTO mirNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero høøc̈h, Dioshespírituháamhøch jaꞌa møjcuꞌubaꞌam nyajnähwaꞌac̈h. Cähxøꞌp jaduhṉ coo tøø yhabaatnä coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Coo jaꞌa møjcuꞌu xquiaꞌa yajmäjädáꞌagät, cabä miäjaa jaduhṉ mbǿjcät. ");
INSERT INTO mirNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Pǿṉhøch jaduhṉ xquiaꞌa møødpädøꞌp, høøc̈h nmädsip jeꞌe. Y pǿṉhøch jaduhṉ xquiaꞌa møødtuum̱b, xmiähaṉhájpøch jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","’Jeꞌeguiǿxpøch mijts jaduhṉ nnämaꞌay, coo pøṉ jaduhṉ tiuꞌudägóyyät, hoy jaduhṉ ñähwáꞌadsät, hóyhøch jaduhṉ xjia nänøm̱y, høøc̈h jaꞌa Diosquex̱ypä. Pero coo pøṉ jaduhṉ ñänǿmät jaꞌa Dioshespíritu, cab jaduhṉ mänaa ñähwaꞌadsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Mhøxcábäp hajxy jaduhṉ pøṉ jaꞌa howyiinmahñdy møød; jeꞌeds hoy wädijp. Pøṉ jaꞌa howyiinmahñdy caꞌa møød, cab hoy wiädity. ");
INSERT INTO mirNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jaduhṉ mäwíinäts mijts hajxy mjatcøꞌøy nebiä tsahṉ̃diän. Paadiä hoybä hajxy mgaꞌa mädiaꞌagaꞌañ, coo jaꞌa haxøøgwiinmahñdy hajxy mmøødä. Haagä mgopcooty jaꞌa mmädiaꞌagyhajxy jaduhṉ chohṉdaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jaayaꞌay hojiäyaꞌaybä, hoy jaduhṉ quiapxy miädiaꞌagy jeꞌeguiøxpä coo jaꞌa howyiinmahñdy miøødä quiopcooty. Pero jaayaꞌay caꞌa hoybä, haxøøg jaduhṉ quiapxy miädiaꞌagy jeꞌeguiøxpä coo jaꞌa haxøøgwiinmahñdy miøødä quiopcooty. ");
INSERT INTO mirNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Chaac̈h mijts nnämaꞌay, coo jaduhṉ yhabáadät coo jaꞌa Dios hänajty yajnähdijaꞌañ, mänitä Dios hajxy xmiäyajtøwaꞌañ waam̱baty hajxy hänajty tøø mgapxtägoy, hoy hajxy jaduhṉ tøø mja näꞌä wiingapxnax̱y. ");
INSERT INTO mirNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pø haxøøg hajxy hänajty tøø mmädiaꞌagy, mänit Dios hajxy xpiädaꞌagaꞌañ haxøøgtuum. Pø hoy hajxy hänajty tøø mmädiaꞌagy, mänitä Dios hajxy xpiädaꞌagaꞌañ hodiuum. ");
INSERT INTO mirNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mänitä Jesús ñämaayyä jaꞌa fariseoshajxy näjeꞌe møødä ley‑yajnähixøøbiähajxy: ―Wiindsǿṉ, højts jaꞌa hijxtahṉd huuc yaghíjxäc jaꞌa hoy‑yagjuǿøñäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mänitä Jesús yhadsooyy: ―Jaꞌa jäyaꞌayhajxy jädaꞌahatypä, haxøøg hajxy jiatcøꞌøy; cabä Dios hajxy chocy. Jaꞌa hijxtahṉd hajxy mja wiꞌi yhixaam̱by. Jagooyyä hajxy jaduhṉ mhixaꞌañ nebiä hijxtahṉd jecy quiähxøꞌquiän jaꞌa Jonáscøxpä, jaꞌa Dios jecy quiéjxäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jaꞌa ballenajoodooty jaꞌa Jonás yhijty tägøøgxøø tägøøgtsuhm̱. Jadúhṉäts høøc̈h nhidaam̱bä naax̱jutjooty tägøøgxøø tägøøgtsuhm̱, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Coo jaꞌa Jonás jaduhṉ piädsøøm̱y ballenajoodooty, mänitä Diosmädiaꞌagy hoy yajwaꞌxy maa jaꞌa cajpt hänajty xiøhatiän Nínive. Coo hajxy jim̱ miädooyy, mänit hajxy miäbøjcy. Mänitä yhaxøøgwiinmahñdy hajxy ñajtshixøøyy. Y cabä Jonás møjtuuṉg hijty jaduhṉ jiaty møødä. Maas møjtúuṉghøch nmøødä høøc̈h. Pero cábøch nmädiaꞌagy hajxy xmiädow̱aaṉä, jaꞌa jäyaꞌayhajxy jädaꞌahatypä. Coo jaduhṉ yhabáadät coo hajxy hänajty yajnähdijaꞌañii, mänit hajxy ñämaꞌawaꞌañii coo hajxy jaduhṉ piädaꞌagǿøjät haxøøgtuum. Jaꞌa jecyjiäyaꞌayhajxy jaduhṉ mänaꞌanaam̱b, jaꞌa hajxy hijty jegyhajty tsänaabiä Nínive. ");
INSERT INTO mirNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jaduhṉdsä toꞌoxiøjc miänaꞌanaam̱bä, jaꞌa jecy gobiernähájtäbä jäguem̱naax̱ jaꞌa jøømbojmänajpä. Mänitä Salomón hoy miämädoow̱hity, jeꞌeguiøxpä coo jaꞌa Salomón hänajty jiaanc̈h tehm̱ quiuhwijjiä. Y cabä Salomón jaꞌa møjtuuṉg hijty jiaty møødä. Maas møjtúuṉghøch nmøødä høøc̈h. Pero cábøch nmädiaꞌagy hajxy xmiädow̱aaṉä, jaꞌa jäyaꞌayhajxy jädaꞌahatypä. ");
INSERT INTO mirNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","’Jaꞌa jäyaꞌayhajxy jädaꞌahatypä, haxøøgwiinmahñdy hajxy miøød. Y cooc̈h nmädiaꞌagy hajxy xquiaꞌa mäbǿjcät, maas haxøøg hajxy jaduhṉ jiádät. Jaduhṉ mäwíinäts hajxy jiádät nebiä jäyaꞌay møjcuꞌumøødpän. Coo jaꞌa møjcuꞌu jiiby piädsǿm̱ät maa jaayaꞌay quiopcän, mänitä pooꞌxtaact nøcxy jäguem̱duum yhøxtaꞌay maa jaꞌa tøꞌødsnähgapän. Coo jaꞌa pooꞌxtaact jim̱ quiaꞌa páadät, mänit miänaꞌanaꞌañ: “Mejor nnäꞌägä nøcxtägáchhøch maac̈h nhuuc tsohm̱bän.” Coo jaduhṉ wyiimbídät, mänitä jäyaꞌay quiopc jaduhṉ piáatät nebiä yajwaꞌadstøjcän, jaꞌa yajxóṉ tøø pieꞌedyíijäbä. Mänitä jiamiøød nøcxy juxtujc jiaac woy, jaꞌa maas haxøøgpä. Mänit hajxy nägøx̱iä tiägøꞌøy maa jaayaꞌay quiopcootiän. Y maas haxøøg jaayaꞌay jaduhṉ jiadaꞌañ quejee hijty yhity. ");
INSERT INTO mirNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jim̱nä jaꞌa Jesús jaꞌa cuꞌug hänajty miøødmädiaꞌagyñä, mänitä tiajhajxy miejch møødä piuhyaꞌayhajxy. Jim̱ hajxy miähmøøyy tøbaꞌam. Jaꞌa Jesús hajxy hänajty miøødmädiaꞌagaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mänitä Jesús hoy ñämaꞌayii: ―Xiidsä mdaj xmiøødmädiaꞌagaꞌañ tøbaꞌam møødä mbuhyaꞌayhajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mänitä Jesús yhadsooyy: ―Pǿṉhøch ndajhajpy; pǿṉhøch nbuhyaꞌayhajpy. ");
INSERT INTO mirNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mänitä jiamiøød ñädsiiwøøyy. Mänit miänaaṉ̃: ―Høøc̈h ndaj yøꞌø; høøc̈h nbuhyaꞌay yøꞌø. ");
INSERT INTO mirNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pǿṉhøch jaꞌa nDeedy miädiaꞌagy xquiudiúuṉäp jaꞌa tsajpootypä, jaduhṉ mäwíinäts hajxy jeꞌe nébiøch nbuhyaꞌayän, nébiøch nbuhdoꞌoxiän, nébiøch ndajjän. ");
INSERT INTO mirNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mänitxøø jaꞌa Jesús jim̱ chohṉ̃ tøgooty. Mänit jim̱ miejch mejypiaꞌa. Hoy jim̱ yhäñaaguiädaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mänitä jäyaꞌay may miejch maa jaꞌa Jesús hänajtiän. Mänitä Jesús tiägøøyy barcojooty. Hoy jiiby yhøxtaꞌagy. Cøjxä jäyaꞌayhajxy jim̱ miähmøꞌøy puꞌuwiing. ");
INSERT INTO mirNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mänitä Jesús tiägøøyy yajnähixøøbiä madiuꞌu. Mäbaadyhaam jaduhṉ yajnähixøøyy. Mänit miänaaṉ̃: ―Mänitä jäyaꞌay tuꞌug tiuꞌubøjcy niippä. ");
INSERT INTO mirNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","8","Coo jaꞌa tøømd tiägøøyy wøjpä, näjeꞌe jaꞌa tøømd quiahy tuꞌhaam, näjeꞌe quiahy tsaanähgøxp, näjeꞌe quiahy haptiooty, näjeꞌe quiahy maa jaꞌa hoñaax̱än. Jaꞌa jim̱ cáhw̱äbä tuꞌhaam, yajpädøꞌc jaꞌa muuxyhajxy jeꞌe. Jaꞌa jim̱ cáhw̱äbä tsaanähgøxp, paquiä jaduhṉ jia mujxy, jeꞌeguiøxpä coo jaꞌa naax̱ quiaꞌa jaty cøøcä. Coo quiøx̱xøøjøøyy, mänitä tiøøch, coo jaꞌa tyicts hänajty quiaꞌa møødä. Jaꞌa cáhw̱äbä haptiooty, ja mujx jaduhṉ. Ja yeeꞌc jaduhṉ, pero cabä ñäꞌä tøømbejty. Hix̱, jaꞌa hapty jeꞌe xaam̱. Y jaꞌa cáhw̱äbä maa jaꞌa hoñaax̱än, may jaduhṉ tiøømhajty, näjeꞌe mägoꞌxhaam, näjeꞌe tägøøghiiꞌxhaam, näjeꞌe hiiꞌxmajc‑haam. ");
INSERT INTO mirNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pøṉ jaduhṉ wiinjuøøby, weenc̈h hädaa nmädiaꞌagy xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mänitä Jesús ñämejtsä jaꞌa jiamiøødhajxy. Mänit miäyajtøøw̱ä: ―Tii jaꞌa cuꞌug coo myajnähixøꞌøy yajmäbaadyhaam. ");
INSERT INTO mirNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mänitä Jesús yhadsooyy: ―Tøø mijts jaꞌa Dios xyajwiinjuøꞌøy nebiaty yhaneꞌemy. Cab hijty yajwiinjuøꞌøy. Y yøꞌø cuꞌughajxy, cab hajxy hoy wyiinjuøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pøṉ madiuꞌu jaduhṉ møød, maas may jaduhṉ mioꞌowaꞌañii. Pero pøṉ weeṉ̃tiä møød, pøgáaṉäxäp jeꞌe mäduhṉ̃tiä jim̱ miøødä. ");
INSERT INTO mirNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Páadyhøch jaduhṉ nmädiaꞌagy yajmäbaadyhaam. Jia wiꞌi yheeꞌpy hajxy, cab hajxy tii yhix̱y. Jia wiꞌi miämädoow̱hijpy hajxy, cab hajxy wyiinjuøꞌøy, neby hajxy tii quiaꞌa mädoybän. ");
INSERT INTO mirNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","’Tøjiajp jaduhṉ yøꞌøyaꞌaguiøxphajxy nebiä Isaías jecy miänaaṉ̃än, jaꞌa hijty jegyhajty wädijpä Diosquex̱y: Mmädow̱aam̱by hajxy jaduhṉ, cab hajxy mwiinjuøꞌøwaꞌañ; Mheebaam̱by hajxy, cab hajxy mhixaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tøø hädaa jäyaꞌayhajxy quiuhxex̱y; nebiä cuhnatpän, nebiä wiimbiꞌidspän hajxy jaduhṉ ñibiädaꞌagyii neby hajxy jaduhṉ quiaꞌa wiinjuǿꞌøwät, nébiøch nmädiaꞌagy hajxy xquiaꞌa mäbǿjcät. Cooc̈h nmädiaꞌagy hajxy xmiäbǿjcät, mänítøch hajxy jaduhṉ nyajnähwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Jootcujc jaduhṉ mhity jeꞌeguiøxpä coo hajxy jaduhṉ mhix̱y, coo hajxy jaduhṉ mmädoy. ");
INSERT INTO mirNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tøyhájthøch mijts nnämaꞌay, may jaꞌa Diosquex̱ypähajxy, may jaꞌa hojiäyaꞌaybähajxy jia hixaaṉ̃ nej mijts cham̱ mhix̱iän. Jia mädow̱aaṉ hajxy nej mijts cham̱ mmädoyyän. ");
INSERT INTO mirNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Huuc mädow̱ hajxy waam̱b jaꞌa niippä cwieento miädiaꞌagytiägøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Näjeꞌe jaꞌa jäyaꞌayhajxy, coo jaꞌa Diosmädiaꞌagy hajxy miädoy nebiä Dios yhaneꞌemiän, cab hajxy wyiinjuøꞌøy. Mänitä Diosmädiaꞌagy hajxy piǿjcäxä jaꞌa møjcuꞌugong. Jaduhṉ mäwíinäts hajxy jeꞌe nebiä tøømd quiahyyän tuꞌhaam. ");
INSERT INTO mirNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Näjeꞌe jaꞌa Diosmädiaꞌagy hajxy hamuumduꞌjoot yhuuc ja mäbøcy. Pero coo hajxy chaac̈htiuñii jaꞌa Diosmädiaꞌagyquiøxpä, mänit hajxy piädsøøm̱nä. Jaduhṉ mäwíinäts hajxy jeꞌe nebiä tøømd quiahyyän tsaanähgøxp. Paquiä jaduhṉ tiøꞌøc̈h jeꞌeguiøxpä coo jaꞌa tyicts quiaꞌa hity. ");
INSERT INTO mirNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Näjeꞌe jaꞌa Diosmädiaꞌagy hajxy yhuuc ja mädoy. Pero jiaanc̈h tehm̱ jiahmiejchp hajxy jaduhṉ hädaa yaabä naax̱wiimbä. Jiaanc̈h tehm̱ yhadsojpy jaꞌa xädøꞌøñ hajxy, paadiä Diosmädiaꞌagy hajxy hoy quiaꞌa panøcxaꞌañ. Jaduhṉ mäwíinäts hajxy jeꞌe nebiä tøømd quiahyyän haptiooty. ");
INSERT INTO mirNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Näjeꞌe jaꞌa Diosmädiaꞌagy hajxy hoy wyiinjuøꞌøy. Hoy hajxy jaduhṉ pianøcxy hamuumduꞌjoot. Jaduhṉ mäwíinäts hajxy jeꞌe nebiä tøømd quiahyyän hoñaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mänitä Jesús tiägǿøguiumbä mädiaacpä yajmäbaadyhaam: ―Coo jaꞌa Dios yhaneꞌemy, jadúhṉhøch nyajmäbaadaꞌañ nebiä tuꞌjäyaꞌay hodiøømd tøø wiǿjjiäbän maa jaꞌa ñaax̱än. ");
INSERT INTO mirNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mänitcoods hajxy quiøx̱y maahoꞌcy. Mänitä miädsip jaꞌa cizañatøømd hoy wiøjy maa jaꞌa trigotøømd hänajty tøø wiøjjiän. ");
INSERT INTO mirNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tuꞌcuhdujt jaꞌa trigo miujxy møødä cizaña. Coo jaꞌa trigo xiäbaajøøyy, mänitä cizaña quiähxøꞌpä. ");
INSERT INTO mirNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mänitä jäyaꞌay hoy ñämaꞌayíijäm jaꞌa mioonsähajxy: “Wiindsǿṉ, hodiøømd miich mwøj, túhm̱äts. Pämaadä yøꞌø cizañahujts tøø chooñ.” ");
INSERT INTO mirNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mänitä wyiindsǿṉ miänaaṉ̃: “Nmädsiphøc̈hädaꞌa jaduhṉ tøø jiatcøꞌøy.” Mänitä mioonsä miänaaṉ̃: “Nej, nǿcxäp højts yøꞌø cizañahujts nwix̱iä.” ");
INSERT INTO mirNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mänitä wyiindsǿṉ miänaaṉ̃: “Caj, cab hajxy mwíxät coo jaꞌa trigo jaduhṉ ñäꞌä mäbädøꞌøgǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ween yhity; ween tuꞌcuhdujt yeegy. Coo jaꞌa trigopux̱ jaduhṉ yhabáadät, mänítøch nmoonsä nguexaꞌañ, weenä cizañahujts hajxy jayøjp quiøx̱y yajpädøꞌøgy. Ween hajxy quiøx̱y haxoch. Mänít hajxy jaduhṉ ñóꞌogät. Mänitä trigo hajxy ñähmádsät. Mänit hajxy piädáꞌagät tsehx̱jooty.” ");
INSERT INTO mirNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mänitä Jesús tiägǿøguiumbä mädiaacpä yajmäbaadyhaam: ―Coo jaꞌa Dios yhaneꞌemy, jadúhṉhøch nyajmäbaadaꞌañ nebiä mostazapajcän. Jim̱ tuꞌjäyaꞌay tøø ñiꞌiby maa jaꞌa ñaax̱än. ");
INSERT INTO mirNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tøyhajt jaduhṉ coo jaꞌa mostazapajc jiaanc̈h tehm̱ chayyä. Pero coo yeegy, cruty jaduhṉ jiaty nebiä quepychaajän. Mädøyyä jaꞌa muuxyhajxy nøcxy jim̱ miaꞌay yhaajiooty. ");
INSERT INTO mirNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Mänitä Jesús miänáaṉgumbä yajmäbaadyhaam: ―Coo jaꞌa Dios yhaneꞌemy, jadúhṉhøch nyajmäbaadaꞌañ nebiä toꞌoxiøjc jaꞌa tsajcaagychooy yajmädijǿꞌøyäbän harinajooty tägøøgquipxøhñdy. Mänit jaduhṉ cøx̱iä yajmäyäbicøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jaduhṉä Jesús jaꞌa cuꞌug yajnähixøøyy haagä yajmäbaadyhaam. ");
INSERT INTO mirNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jaduhṉds tiøjiajty nebiä Diosquex̱ypä jecy quiujahyyän: Mäbaadyháamhøch nmädiaꞌagaꞌañ. Nyajcähxøꞌøgáam̱biøch mädyiijaty hänajty yuꞌuc̈htiuum hijp mänaa hädaa yaabä naax̱wiin yhawijy tiøøꞌxtaꞌaguiän; cahnä quiähxøꞌøgyñä. ");
INSERT INTO mirNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mänitä Jesús jaꞌa cuꞌughajxy quiejxwiimbijty. Mänit tiøjtägøøyy. Mänit jaꞌa jiamiøødhajxy miejch. Mänitä Jesús hajxy ñämaayy: ―Højts capxwíjjäc jaꞌa cizañahujtscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mänitä Jesús miänaaṉ̃: ―Høøc̈h jaꞌa Diosquex̱ypä, jaduhṉ mäwíinhøch høøc̈h nebiä jaayaꞌay hodiøømd tøø wiǿjjiäbän. ");
INSERT INTO mirNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Y hädaa yaabä naax̱wiin, jaduhṉ mäwíinäts hädaa nebiä naax̱än maa jaꞌa hodiøømd wiøjjiän. Jaayaꞌayhajxy hanéhm̱äbä jaꞌa Diósäm, jaduhṉ mäwíinäts hajxy jeꞌe nebiä hodiøømdän. Jaayaꞌayhajxy hanéhm̱äbä jaꞌa møjcuꞌugong, jaduhṉ mäwíinäts hajxy jeꞌebä nebiä cizañahujtsän. ");
INSERT INTO mirNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Y jaꞌa møjcuꞌugong, jaduhṉ mäwíinäts jeꞌe nebiä jaayaꞌay jaꞌa cizañahujts tøø wiǿjjiäbän. Coo jaꞌa naax̱wiimbä wyiimbidaꞌañ, jaduhṉ mäwíinäts jeꞌe nebiä trigo hajxy yajpädøꞌquiän møødä cizañahujts. Y jaꞌa Dios jaꞌa mioonsähajxy tsajpootypä, jaduhṉ mäwíinäts hajxy jeꞌe nebiä jaayaꞌay jaꞌa trigo hajxy yajpädøꞌquiän. ");
INSERT INTO mirNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Coo jaꞌa naax̱wiimbä jaduhṉ wyiimbidaꞌañ, jaduhṉ mäwíinäts jeꞌe nebiä cizañahujts hajxy ñoꞌquiän. ");
INSERT INTO mirNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mänítøch nmoonsä nhaneꞌemaꞌañ coo hajxy ween nøcxy yajpädsøm̱y pønjaty jaꞌa haxøøgwiinmahñdy møød, møødä pønjaty jaduhṉ ja wiꞌi yhadugaam̱b jaꞌa Diosmädiaꞌagy. Jim̱ hajxy yajpädsøm̱aꞌañii maac̈h hänajty nhaneꞌemaꞌañän, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mänit hajxy hänajty quiujuipøꞌøwaꞌañii jøønjooty. Jiiby hajxy jiøꞌøwaꞌañ xiuudsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jaꞌa hajxy jaduhṉ howiädijpä, jaanc̈h tehm̱ miøj jaanc̈h tehm̱ jiaanc̈h hajxy yhidaꞌañ maa jaꞌa Tieedyhajxy yhaneꞌemaꞌañän. Pø jii mmädohndhajxy, mmädów̱äp hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ, jaduhṉ mäwíinäts jeꞌe nebiä jäyaꞌay maxiädøꞌøñ tiajǿꞌøyäbän naax̱paꞌc. Coo pøṉ piáadät, mänitä tiajøødiägatsaꞌañ. Xooṉdaꞌagaam̱b jaduhṉ. Mänit nøcxy tioogy tijaty jim̱ miøød. Mänitä naax̱ nøcxy jiuy maa jaꞌa maxiädøꞌøñ tøø piaadiän. ");
INSERT INTO mirNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ, jaduhṉ mäwíinäts jeꞌe nebiä perlatsaahajuubiän, jaꞌa jaanc̈h tehm̱ yajxoṉbä. Jaꞌa perlatsaa, pic jeꞌe møød pioobä. ");
INSERT INTO mirNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Coo jaduhṉ tuꞌug piáadät jaanc̈h tehm̱ chow̱bä, mänit nøcxy tioogy tijaty jim̱ miøød. Mänitä perlatsaa nøcxy jiuy. ");
INSERT INTO mirNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ, jaduhṉ mäwíinäts jeꞌe nebiä hacxjohm̱d hajxy piädáꞌaguiäbän mejjiooty coo hacx hajxy hänajty jioomaꞌañ madiuꞌu. ");
INSERT INTO mirNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Coo jaꞌa hacxjohm̱d jaduhṉ yhúdsät, mänit hajxy yhøxwohm̱bädsøm̱y. Mänitä hacx hajxy wyiimbiy jaꞌa hojiatypä. Mänit hajxy piädaꞌagy cachjooty. Mänitä caꞌa hojiatypä hajxy ñøøgaꞌadsøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jaduhṉ mäwíinäts jiadaꞌañ coo jaꞌa naax̱wiimbä wyiimbidaꞌañ. Mänitä Dios jaꞌa mioonsähajxy wyiimbiwaꞌañ jaꞌa hojiäyaꞌaybä. ");
INSERT INTO mirNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Pøṉ caꞌa hojiäyaꞌay, jeꞌe hajxy cujuipøꞌøwáaṉäp jøønjooty. Jiiby hajxy jiøꞌøwaꞌañ xiuudsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mänitä Jesús miänaaṉ̃: ―Nej, mwiinjuøøby hajxy jaduhṉä. Mänit hajxy yhadsooyy: ―Wiindsǿṉ, nwiinjuøøby højts jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mänitä Jesús miänáaṉgumbä: ―Coo jaꞌa ley‑yajnähixøøbiähajxy tiägǿꞌøwät habøjpä nebiä Dios yhaneꞌemiän, mejtstuꞌu jaꞌa mädiaꞌagy jaduhṉ jiadaꞌañ møødä jecypiä møødä jem̱ybiä. Jaduhṉ mäwíinäts jeꞌe nebiä cudøjc madiuꞌu miøødhátiäbän, møødä jem̱ybiä møødä jecypiä. ");
INSERT INTO mirNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Coo jaꞌa Jesús jaduhṉ miädiaacpädøøyy, mänit jim̱ chohṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mänit miejch maa jaꞌa yhamdsoo cajptän. Mänit tiägøøyy yajnähixøøbiä tsajtøgooty. Mänitä jäyaꞌayhajxy jiaanc̈h tehm̱ yagjuøøyy. Mänit hajxy miänaaṉ̃: ―Maa yøꞌø wiinmahñdiädaꞌa tøø yhabøcy. Nebiä hoy‑yagjuøøñäjatypä jaduhṉ yajcähxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","José yhuung yøꞌø, yøꞌø tsejtspä pujxpä. María jaꞌa tiaj xiøhaty. Jueꞌe piuhyaꞌayhajxy xiøhaty, Jacobo, José, Simón, møødä Judas. ");
INSERT INTO mirNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yaa hajxy chänaꞌay maa højts ngajptän møødä piuhdoꞌoxyhajxy. Pämaadä yøꞌø wiinmahñdy yøꞌøduhm̱bä tøø yajtsooñ. ");
INSERT INTO mirNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mänitä Jesús miädiaꞌagy quiaꞌa mäbǿjcäxa. Mänitä Jesús miänaaṉ̃: ―Homiaajä jaꞌa Diosquex̱y wiädity, cumáayyäp jaduhṉ. Pero cab jim̱ quiumayii maa yhamdsoo naax̱ maa yhamdsoo tøjcän. ");
INSERT INTO mirNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Cabä Jesús jaꞌa hoy‑yagjuøøñäjatypä jim̱ jiaty yajcähxøꞌcy, jeꞌeguiøxpä coo jaꞌa miädiaꞌagy hänajty quiaꞌa mäbǿjcäxä. ");
INSERT INTO mirNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mänitä Herodes miädoyhajty coo jaꞌa Jesús hänajty jim̱ wiädity. Jaꞌa Herodes, jim̱ hänajty jeꞌe guiobernadorhaty Galileanaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Mänitä Herodes jaꞌa mioonsä ñämaayy: ―Juan mäyajnäbejpädaꞌa jeꞌe. Tøødaꞌa jiujypiøcy. Paadiä møcmäjaa jiaanc̈h tehm̱ miøødä. ");
INSERT INTO mirNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Tøø jaꞌa Herodes jaꞌa Juan hänajty yajtsumyii. Tøø jaꞌa Juan hänajty quiøꞌøxoc̈hii cadenahaam. Paadiä Juan jaduhṉ chuum̱ä coo jaꞌa Herodes hänajty tøø ñämaꞌay coo jaduhṉ quiaꞌa hoyyä coo jaꞌa Herodes jaꞌa piuhyaꞌay tioꞌoxiøjc miøødtsänáayyät. Jueꞌe jaꞌa Herodes piuhyaꞌay hänajty xiøhaty, Felipe. Jueꞌe jaꞌa Felipe tioꞌoxiøjc hänajty xiøhaty, Herodías. ");
INSERT INTO mirNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jaduhṉä Herodes hänajty tiajy miay coo jaꞌa Juan hänajty yaghoꞌogaꞌañ. Pero jaanc̈h tehm̱ chähgøøby jaꞌa Herodes hänajty. Jaꞌa cuꞌug hänajty chähgøøby jeꞌeguiøxpä coo jaꞌa cuꞌughajxy hänajty miänaꞌañ coogä Juan jaꞌa Diosmädiaꞌagy hänajty yajwaꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mänitä Herodes jiumøjt jaduhṉ piejtä. Jim̱ä Herodes hänajty yhäñaꞌay møødä pawoy pawichpähajxy. Mänit hajxy tiägøøyy wiinhéjtsäbä. Jaꞌa Herodías yhuung jaduhṉ tägøøyy hejtspä. Mänitä Herodes xiooṉdaacy nägøꞌø nädecypiä. ");
INSERT INTO mirNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mänitä Herodes jaꞌa quix̱y yajwiinwaaṉøøyy: ―Hotyiijä miic̈h xmiäyujwáꞌanät, nmóꞌowäbøch miic̈h jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mänitä quix̱y jaꞌa tiaj hoy yhawaaṉä. Mänitä tiaj jaduhṉ miänaaṉ̃ coo jaꞌa Juan mäyajnäbejpä quiopc jaduhṉ miäyujwáꞌanät. Mänitä quix̱y jaꞌa Herodes hoy ñämaꞌay: ―Høøc̈hä Juan mäyajnäbejpä quiopc móoyyäc texyjooty. ");
INSERT INTO mirNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Mänitä Herodes jiootmadiägøøyy nägøꞌø nädecypiä. Pero tøø hänajty miänaꞌañ jäyaꞌawyiinduum coog hänajty yegaꞌañ hotyijatiä. Mänit yhanehm̱y coo jaꞌa Juan quiopc yhøxpújxäxät jiiby pujxtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mänitä Juan quiopc yajnǿcxäxä texyjooty maa jaꞌa Herodeshajxiän. Mänitä quix̱y miooyyä. Mänitä quix̱y jaꞌa tiaj hoy mioꞌoy. ");
INSERT INTO mirNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mänitä Juan ñäxäwaꞌay yoꞌtuc hoy quiǿøyyäxä; jaꞌa Juan miäguꞌughajpähajxy jaduhṉ hoy quiøꞌøy. Mänitä Juan hajxy hoy yajnaax̱tägøꞌøy. Mänitä Jesús hajxy hoy yhawaaṉä cooc jaꞌa Juan hänajty tøø yaghoꞌogyii. ");
INSERT INTO mirNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Coo jaꞌa Jesús jaduhṉ miädoyhajty cooc jaꞌa Juan tøø yaghoꞌogyii, mänit jim̱ chohṉ̃ barcojooty nidiuhm̱. Mänit ñøcxy hanidiuhm̱duum. Mänitä cuꞌughajxy miädoyhajty cooc jaꞌa Jesús hänajty jim̱ tøø chooñ. Mänitä Jesús hajxy piaduꞌubøjcy cajptooty. Tecy‑yoꞌoy hajxy pianøcxy. Jayøjp hajxy jim̱ miejch maa jaꞌa Jesús hänajty ñøcxiän. Mänitä Jesús piamejch høx̱haam. ");
INSERT INTO mirNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Coo jaꞌa Jesús piädsøøm̱y barcojooty, mänitä majiäyaꞌay yhijxy. Mänit ñäxuuꞌch. Mänitä paꞌamjäyaꞌay yajmøcpøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mänittsuu jaꞌa Jesús miäguꞌughajpähajxy piamejch. Mänitä Jesús hajxy ñämaayy: ―Tøø chuujøꞌøy y cabä tøjc yaa. Quejxwiimbit yøꞌø jäyaꞌayhajxy; weenä caagy hajxy nøcxy jiuy cajptooty. ");
INSERT INTO mirNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mänitä Jesús miänaaṉ̃: ―Caj, ween hajxy yhity. Mijts jaduhṉ ween myajcáyät. ");
INSERT INTO mirNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mänit hajxy yhadsooyy: ―Cab højts tii nmøødä. Jagooyyä højts jaꞌa tsajcaagy mägoox̱yä nmøødä chaadsä hacx metscä. ");
INSERT INTO mirNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mänitä Jesús miänaaṉ̃: ―Mämiṉxä yøꞌø. ");
INSERT INTO mirNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mänitä Jesús jaꞌa majiäyaꞌay ñämaayy coo hajxy ween yhøxtaꞌagy møøwyiing. Mänitä tsajcaagy quiøøc̈hooyy møødä hacx. Mänit yuugheeꞌpy cøxp. Mänit miänaaṉ̃: ―Dioscujúꞌuyäp. Mänitä Jesús jaꞌa tsajcaagy yhaguidøøyy. Mänitä miäguꞌughajpähajxy miooyy. Mänit hajxy hoy yajwaꞌxy majiäyaꞌayhagujc. ");
INSERT INTO mirNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nägøx̱iä hajxy jaduhṉ quiaayy cuꞌuxiä. Mänitä Jesús miäguꞌughajpä tsajcaagyhaguijc hajxy yajpädøꞌcy majmejtscach. ");
INSERT INTO mirNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nämägoox̱mil hajxy quiaayy haagä yaꞌadiøjc. Hawiingä toꞌoxiøjc‑hajxy møødä pigänaꞌc‑hajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mänitä Jesús jaꞌa miäguꞌughajpä ñämaayy coo hajxy ween tiägøꞌøy barcojooty, coo hajxy ween ñøønajxøꞌøgy. Mänitä Jesús jaꞌa majiäyaꞌayhajxy quiejxwiimbijty. ");
INSERT INTO mirNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mänitä Jesús ñøcxy nidiuhm̱ tuṉnähgøxp Diospaꞌyaax̱pä. Coo quioodsøøyy, jim̱nä Jesús hänajty nidiuhm̱ tuṉnähgøxp. ");
INSERT INTO mirNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jaꞌa Jesús jaꞌa miäguꞌughajpähajxy, mejyquiujc hajxy hänajty tøø miech barcojooty. Møc hajxy hänajty jiøjcubojøꞌøy; paadiä nøø hänajty miøjjädseem̱bejty barcomøjc. ");
INSERT INTO mirNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Coodsnä Jesús tiuꞌubøjcy tecy‑yoꞌoy. Mejywyiing jaduhṉ yohy. Mänit miejch maa jaꞌa miäguꞌughajpähajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Coo jaꞌa Jesús hajxy yhijxy coo hänajty yoꞌoy mejywyiing, mänit hajxy chähgøøbiøjcy. Mänit hajxy chähgøꞌøyaax̱y: ―Haañämädaꞌa yøꞌø. ");
INSERT INTO mirNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mänitä Jesús miänaaṉ̃: ―Caꞌa hajxy mdsähgøꞌøy. Høøc̈h jaꞌa Jesús. ");
INSERT INTO mirNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mänitä Pedro miänaaṉ̃: ―Wiindsǿṉ, pø miic̈h jaꞌa Jesús, høøc̈h huuc hanéhm̱äc cooc̈h jim̱ mnǿcxät yoꞌoy maa miic̈hän. ");
INSERT INTO mirNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Mänitä Jesús yhadsooyy: ―Miṉxä. Mänitä Pedro piädsøøm̱y barcojooty. Mänit tiägøøyy yohbiä mejywyiing. Jim̱ hänajty ñøcxaꞌañ maa jaꞌa Jesúsän. ");
INSERT INTO mirNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Coo jiäwøøyy coo møc piojy, mänit chähgøøbiøjcy. Mänit tiägøøyy quiim̱bä. Mänit yaax̱y: ―Wiindsǿṉ, høøc̈h yajpädsǿøm̱äc. ");
INSERT INTO mirNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mänitiä jaꞌa Jesús jaꞌa Pedro quiøꞌø miajtsä. Mänit miänaaṉ̃: ―Caj miic̈h mhuuc mäbøjpä. Tiic̈h nmädiaꞌagy coo xquiaꞌa mäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Coo jaꞌa Jesús tiägøøyy barcojooty møødä Pedro, mänitä poj yuungøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mänitä Jesús hajxy wyiinjijcädaacy. Mänitä Jesús hajxy ñämaayy: ―Tøyhajt miic̈h mDioshuungä. ");
INSERT INTO mirNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mänit hajxy miejch mejyhawiimb maa hänajty xiøhatiän Genesaret. ");
INSERT INTO mirNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Coo jaꞌa Jesús yhøxcajpä jaꞌa jäyaꞌayhajxy jim̱bä, mänitä mädiaꞌagy tiägøøyy wädijpä coo jaꞌa Jesús jim̱ tøø miech Genesaret. Mänitä paꞌamjäyaꞌayhajxy may yajmejtsä maa jaꞌa Jesúsän. ");
INSERT INTO mirNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mänitä Jesús hajxy miänuuꞌxtaacy coo jaꞌa wyitpaꞌa hajxy ween ñähdooṉä. Coo hajxy jaduhṉ ñähdooṉ̃, mänit hajxy miøcpøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mänitä Jesús ñämejtsä jaꞌa fariseoshajxy näjeꞌe møødä ley‑yajnähixøøbiähajxy näjeꞌe. Jerusalén hajxy hänajty chooñ. Mänitä Jesús hajxy miäyajtøøyy: ");
INSERT INTO mirNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Yøꞌø mmäguꞌughajpähajxy, tii jaꞌa cuhdujt hajxy coo quiaꞌa cudiuṉ̃ nebiä jecyjiäyaꞌayhajxy xyajmämähmǿøyyäm. Jaꞌa jecyjiäyaꞌayhajxy, cøꞌøbujp hajxy hijty coo hajxy hänajty quiayaꞌañ. Jaduhṉ hajxy hijty quiuhdujthaty. Pero yøꞌø mmäguꞌughajpähajxy, cab hajxy jaduhṉ quiuhdujthaty. ");
INSERT INTO mirNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mänitä Jesús yhadsooyy: ―Pero mijts, cabä Dios miädiaꞌagy hajxy myajtuuṉä. Jaꞌa mhamdsoo cuhdujt hajxy myajtuum̱by. ");
INSERT INTO mirNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jaꞌa Dios jaduhṉ mänaaṉ coo jaꞌa ndaj ndeedy hajxy nwiingudsähgǿøyyämät. Jaduhṉ miänaam̱bä, coo pøṉ jaꞌa tiaj jaꞌa tieedy haxøøg ñänǿmät, tsipcøxp jaduhṉ yhoꞌogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Pero wiing mijts mmänaam̱bä. Mijts jaduhṉ mänaam̱b coo jaduhṉ yhoyyä coo jaꞌa mdaj jaꞌa mdeedy jaduhṉ mnämáꞌawät: “Cábøc̈hä xädøꞌøñ nmøødä cooc̈h mijts nbuhbédät. Tøøc̈hä Dios ngøx̱y moꞌoy mäduhṉ̃tiä mijts hijty nmoꞌowaꞌañ.” Coo hajxy jaduhṉ mmänaꞌañ, cabä Diosmädiaꞌagy hajxy hänajty myajtuṉ̃. Jaꞌa mhamdsoo cuhdujt hajxy hänajty myajtuum̱by. ");
INSERT INTO mirNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jaduhṉ mäwíinäts mijts mnibiädaꞌagyii nebiä hoyhänaꞌcän. Pero cab hajxy mhoyhänaꞌcä. Mijtscøxpä jaꞌa Isaías Diosquex̱ypä jecy miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Näꞌä mänaam̱b hajxy jaduhṉ cooc tyijy hajxy xwyiingudsähgøꞌøy hamuumduꞌjoot. ");
INSERT INTO mirNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xiøøbä hajxy jaduhṉ ñäꞌä mänaꞌañ; cábøch nmädiaꞌagy hajxy xñäꞌä panøcxä. Yhamdsoo wiinmahñdy hajxy yajwiinhixøøby, nøm̱ä Dios miänaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mänitä Jesús jäyaꞌay may miøjyaax̱y. Mänit miänaaṉ̃: ―Huuc mädow̱ hajxy, huuc wiinjuøꞌøw hajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mädyiijaty tägøøby mhaawjooty, cab jaduhṉ xyajtägóyyät. Jeꞌeduhṉ xyajtägóyyäp mädyiijaty pädsøøm̱b mhaawjooty. ");
INSERT INTO mirNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mänitä Jesús ñämaayyä jaꞌa miäguꞌughajpähajxy: ―Cabä fariseoshajxy yhojiäwøꞌøy coo jaduhṉ tøø mmänaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mänitä Jesús yhadsooyy: ―Mädyiijátyhøch nDeedy tsajpootypä tøø quiaꞌa pädaꞌagy, cab jaduhṉ yhoyøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Weends yøꞌø fariseoshajxy yhity. Jaduhṉds hajxy wiädity nebiä haagä wiindspän coo hajxy ñibiawoyii. Nämetsc hajxy nøcxy wioccaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mänitä Pedro jaꞌa Jesús ñämaayy: ―Cab højts nduꞌjootwiinjuøꞌøy. Højts capxwíjjäc. ");
INSERT INTO mirNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mänitä Jesús miänaaṉ̃: ―Nej, ni mijts tii mgaꞌa wiinjuøꞌøyñä. ");
INSERT INTO mirNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Jaduhṉds jeꞌe, mädyiijaty tägøøby mhaawjooty, jiiby jaduhṉ yhädaꞌagy mjoodooty. Mänitä jaduhṉ piädsøøm̱dägach. ");
INSERT INTO mirNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero mädyiijaty jaduhṉ pädsøøm̱b mhaawjooty, jiiby jaduhṉ chohṉdaꞌagy mgopcooty. Jeꞌeduhṉ xyajtägóyyäp. ");
INSERT INTO mirNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Haagä jiibiä haxøøgwiinmahñdy chohṉdaꞌagy mgopcooty hoñäꞌä mädyiibä. Jeꞌeduhṉ xøhajp jaꞌa haxøøgwiinmahñdy, jaꞌa jäyaꞌay‑yaghoꞌogyiibä, møødä meec̈hiibä, møød coo wiingjäyaꞌay tioꞌoxiøjc mmøødtsänáayyät, møød coo mhøhṉdáꞌagät, møød coo hänaꞌc haxøøg mnänǿmät. ");
INSERT INTO mirNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Jeꞌeds jaduhṉ xyajtägóyyäp. Pero coo mgáyät jaguiøꞌøbujy, cab jaduhṉ ñejpiä; cab jaduhṉ xyajtägóyyät. ");
INSERT INTO mirNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mänitä Jesús jim̱ chohṉnä. Mänit ñøcxnä Canaán maa jaꞌa cajpt hänajty xiøhatiän Tiro møødä Sidón. ");
INSERT INTO mirNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mänitä Jesús tajjäyaꞌay tuꞌug ñämejtsä. Jim̱ hänajty chänaꞌay Canaán. Mänitä Jesús ñämaayyä: ―Wiindsǿṉ, miic̈h jaꞌa David hijty mhaphajpy mdeedyhajpy. Høøc̈h näxúuꞌtsäc. Tøøc̈h ndoꞌoxyhuung miac̈hii jaꞌa møjcuꞌu. Hanax̱iä jaduhṉ chaac̈htiuñii ―nøm̱ jeꞌe yaax̱y. ");
INSERT INTO mirNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Cabä Jesús yhadsooyy. Mänitä ñämaayyä jaꞌa miäguꞌughajpähajxy: ―Huuc quejxwiimbit yøꞌø tajjäyaꞌay. Tsaac̈hyáax̱äp jaduhṉ xpiawädíjtäm. ");
INSERT INTO mirNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mänitä Jesús yhadsooyy: ―Yáayyøc̈hä Dios tøø xquiex̱y maa hädaa judíoshajxiän. Cábøch wiingtuum tøø xquiex̱y. ");
INSERT INTO mirNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mänitä tajjäyaꞌay jaꞌa Jesús wyiinjijcädaacy. Mänit ñämaayy: ―Wiindsǿṉ, tuṉä mayhajt. Høøc̈h puhbéjtäc. ");
INSERT INTO mirNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mänitä Jesús yhadsooyy: ―Cab jaduhṉ yhoyyä cooc̈hä huc tsajcaagy nmóꞌowät mädyii jaꞌa pigänaꞌc‑hajxy quiayaam̱by. Jaꞌa judíos Jesús yajmäbaat nebiä pigänaꞌcän. Jaꞌa caꞌa judíoshajxy, jeꞌeduhṉ yajmäbaat nebiä hucän. ");
INSERT INTO mirNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mänitä tajjäyaꞌay miänaaṉ̃: ―Tøyhajt jaduhṉ. Pero quiaaby jaꞌa huc jaꞌa tsajcaagyhawaagy coo jim̱ quiaꞌay maa jaꞌa wyiindsǿṉ jaꞌa mieexän. ");
INSERT INTO mirNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mänitä Jesús miänaaṉ̃: ―Tøyhájthøch miic̈h nmädiaꞌagy xmiäbøjcä. Weenä mhuung miøcpøcy. Mänitiä jaꞌa yhuung jiaanc̈h møcpøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mänitä Jesús jim̱ chohṉnä. Mänit ñøcxnä maa jaꞌa mejypiaꞌajän, jaꞌa xøhajpä Galilea. Mänit hoy piety tuṉnähgøxp. Mänit yhøxtaacy. ");
INSERT INTO mirNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mänitä jäyaꞌay may miejch maa jaꞌa Jesúsän, møødä paꞌamjäyaꞌay, møødä cøꞌømucypiä tecymiucypiä, møødä wiindspä, møødä huumbä. Mänitä Jesús yajmäbaadøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mänitä jäyaꞌayhajxy yagjuøøyy coo hajxy jaduhṉ yhijxy coo jaꞌa huumbähajxy tøø quiapxøꞌøgy, coo jaꞌa cøꞌømucypiähajxy tøø yhoyøꞌøy, coo jaꞌa tecymiucypiähajxy tøø yoꞌoyøꞌøgy, coo jaꞌa wiindspähajxy tøø yhijxøꞌøgy. Mänit hajxy miänaaṉ̃ coogä Dios miøjjä jiaanc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Mänitä Jesús miøjyaax̱y jaꞌa miäguꞌughajpä. Mänit miänaaṉ̃: ―Nnäxúuꞌchpøch yøꞌøyaꞌayhajxy. Tägøøgxǿøjøch hajxy tøø xpiawädity, y cabä caayyøøc hajxy miøødä. Cábøch hajxy nguejxwiimbidaꞌañ jaguiay maa tiøjcän coo hajxy maa tiuꞌugädáw̱ät. ");
INSERT INTO mirNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mänitä Jesús jaꞌa miäguꞌughajpähajxy miänaaṉ̃: ―Pero maadsä cay hajxy jaduhṉ nnäꞌä páatämät maa yøꞌøyaꞌaguiøxphajxiän. Pactuumädaꞌa yaa. ");
INSERT INTO mirNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mänitä Jesús miäyajtøøyy jaꞌa miäguꞌughajpähajxy: ―Naag tsajcaagy hajxy jii mmøødä. Mänit hajxy yhadsooyy: ―Juxtujc, chaadsä hacxhuung mejtstägøøg. ");
INSERT INTO mirNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mänitä Jesús miänaaṉ̃ coo jaꞌa jäyaꞌayhajxy yhøxtáꞌagät naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mänitä tsajcaagy quiooṉdsooyy møødä hacxhuung. Mänitä Dios ñämaayy: ―Dioscujúꞌuyäp. Mänitä Jesús jaꞌa miäguꞌughajpä jaꞌa tsajcaagy hajxy yajnäguidøøyy møødä hacxhuung. Mänit hajxy yajwaꞌxtägajch maa jaꞌa jäyaꞌayhajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mänit hajxy quiaayy cuꞌuxiä nägøx̱iä. Mänitä Jesús miäguꞌughajpä jaꞌa tsajcaagyhaguijc hajxy yajpädøꞌcy juxtujcach. ");
INSERT INTO mirNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nämädaax̱mil jaꞌa yaꞌadiøjc‑hajxy quiaayy. Pagaayy jaꞌa toꞌoxiøjc‑hajxypä møødä pigänaꞌc‑hajxy. Pero cab jaduhṉ yajnajuøꞌøy nänaagä hajxy hänajty jeꞌebä. ");
INSERT INTO mirNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mänitä Jesús jaꞌa jäyaꞌayhajxy quiejxwiimbijty. Mänit tiägøøyy barcojooty. Mänit ñøcxy Magadánnaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mänitä Jesús ñämejtsä jaꞌa fariseoshajxy näjeꞌe møødä saduceoshajxy. Mänitä Jesús ñämaayyä coo hijxtahṉd ween yajcähxøꞌøgy jim̱ tsajpootyp. Paady hajxy jaduhṉ miänaaṉ̃ coo jaꞌa Jesús hajxy hänajty jia wiꞌi jiøjcapxøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mänitä Jesús yhadsooyy: ―Coo hänajty chuujøꞌøy, mänit hajxy nax̱y mmänaꞌañ: “Waꞌads jaꞌa tsajt; waꞌads jaboom yhidaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y coo hänajty jiobøꞌøy, mänit hajxy nax̱y mmänaꞌañ: “Tøø wyiimbøcy; tuꞌuwaam̱b.” Mnajuøøby hajxy jaduhṉ nebiä tsajt yhidaꞌañ, pero cabä hijxtahṉd hajxy mwiinjuøꞌøy jaꞌac̈h chaa nyajcäjxøꞌpiä. Jaꞌa jäyaꞌayhajxy jädaꞌahatypä, haxøøg hajxy jiäyaꞌayhajnä; cabä Dios hajxy chocy. ");
INSERT INTO mirNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hijxtahṉd hajxy jaduhṉ yujwaam̱by, pero cab hajxy mioꞌowaꞌañii. Jagooyyä hajxy jaduhṉ yaghixaꞌañii nebiä Jonás jecy jiajty yhabejtiän. Mänitä Jesús jim̱ jiäwaach. Mänit jim̱ tiuꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mänitä Jesúshajxy miejyñajxy. Pero jiahdiägooyy jaꞌa quiaayyøøc hajxy, jaꞌa Jesús miäguꞌughajpähajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mänitä Jesús miänaaṉ̃: ―Huuc mädow̱ hajxy. Cabä fariseos chajcaagychooyhajxy yhoyyä, ni jaꞌa saduceos chajcaagychooyhajxy quiaꞌa hoyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mänitä miäguꞌughajpähajxy tiägøøyy mädiaacpä: ―Paady jaduhṉ miänaꞌañ, coo jaꞌa caayyøøc hajxy ngaꞌa jahmiéjtsäm. ");
INSERT INTO mirNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ñajuøøby jaꞌa Jesús hänajty nebiaty hajxy hänajty miädiaꞌagy. Mänit miänaaṉ̃: ―Tii hajxy jaduhṉ coo mwiꞌi miädiaꞌagy coo jaꞌa caayyøøc hajxy mgaꞌa møødä. Cábøc̈hä nmädiaꞌagy hajxy jaduhṉ xñäꞌägädä mäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Cáhnøch nmädiaꞌagy hajxy xwyiinjuøøyyä. Cab hajxy jaduhṉ mjahmiejtsnä nébiøch jaꞌa mägoox̱pä tsajcaagy nyajnäwaꞌxøøyyän jaꞌa nämägoox̱milpä jäyaꞌay, y coo hajxy maguiach myajpädøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ni jaduhṉ hajxy mgaꞌa jahmiejtsnä nébiøch jaꞌa juxtujpä tsajcaagy nyajnäwaꞌxøøyyän jaꞌa nämädaax̱milpä jäyaꞌay, y coo hajxy maguiach myajpädǿꞌcumbä. ");
INSERT INTO mirNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Cooc̈h jaduhṉ nmänaaṉ̃ coo jaꞌa fariseos chajcaagychooyhajxy quiaꞌa hoyyä, coo jaꞌa saduceos chajcaagychooyhajxy quiaꞌa hoyyä, cábøch tsajcaagychooy hänajty ndehm̱ ñänøøm̱y. Pero caj mijts mwiinjuøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mänit hajxy wyiinjuøøñä tii Jesús hänajty miädiaacypy. Caꞌa chajcaagychooyä hänajty tiehm̱ miädiaacypy, jaꞌa hajxy yajtsajcaagyquiojpiä. Jaduhṉ hänajty miädiaꞌagy cooc jaꞌa fariseos miädiaꞌagyhajxy quiaꞌa hoyyä, cooc jaꞌa saduceos miädiaꞌagyhajxy quiaꞌa hoyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mänitä Jesúshajxy jim̱ miejch maa jaꞌa cajpt hänajty xiøhatiän Cesarea de Filipo. Mänitä Jesús miäyajtøøyy jaꞌa miäguꞌughajpähajxy: ―Waam̱bátyhøch jaꞌa cuꞌughajxy xñänøm̱y pǿṉhøch høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mänit hajxy yhadsooyy: ―Näjeꞌe jaꞌa cuꞌughajxy miänaꞌañ cooc miic̈h mJuan mäyajnäbejpä; näjeꞌe hajxy miänaam̱bä cooc miic̈h mhElíasä; näjeꞌe hajxy miänaam̱bä cooc miich mJeremíasä, jaꞌa Diosmädiaꞌagy jecy yajwáꞌxäbä; näjeꞌe hajxy miänaam̱bä cooc miic̈h mDiosquex̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mänitä Jesús miänaaṉ̃: ―Míjtsäts, wáam̱bøch mijts xñänøøm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Mänitä Simón Pedro miänaaṉ̃: ―Miic̈h jeꞌe jaꞌa Cristo. Miic̈h jaꞌa Dios tøø xquiex̱y, jaꞌa jim̱ tsajpootypä. MDioshuung miic̈h. ");
INSERT INTO mirNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Mänitä Jesús yhadsooyy: ―Miic̈h Simón, Jonás miic̈h xyhuunghajp. Caj miic̈h pøṉ tøø xyhawaaṉä cooc̈h nDioshuungä. Jaꞌa nDéedyhøch tøø xyhawaaṉä, jaꞌa jim̱ tsajpootypä. Paady miic̈h hoyhajt weenhajt mbaadaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Miic̈h jaduhṉ nnämaaby coo miic̈h mxøhataꞌañ Pedro; jeꞌeduꞌuṉ ñänøøm̱by “tsaa.” Miic̈hcǿxpøch jaꞌa jäyaꞌay jaꞌa nmädiaꞌagy hajxy may xmiäbøgaaṉä. Hoy hajxy cu jia hoꞌog, cab hajxy jaduhṉ quiuhdägoyyaꞌañ. Cøjxtaꞌaxiøø hajxy jim̱ yhidaꞌañ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nmoꞌowáam̱biøch miic̈h cuhdujt cooc̈h miic̈h nmädiaꞌagy xyajwáꞌxät nébiøch jaꞌa jäyaꞌay jaꞌa nmädiaꞌagy hajxy jaduhṉ xmiäbǿjcät. Dios jaduhṉ xñajtscapxøꞌøwáaṉäp nebiaty jaꞌa jäyaꞌayhajxy mhanéꞌemät coo hajxy jaduhṉ ween quiudiuṉ̃, coo jaꞌa yhaxøøgwiinmahñdy hajxy ñajtshixǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mänitä Jesús jaꞌa miäguꞌughajpä yhanehm̱y coo hajxy ween quiaꞌa mädiaꞌagy coo jeꞌe Cristo. ");
INSERT INTO mirNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mänitxøø jaꞌa Jesús tiägøøyy hawáaṉäbä jaꞌa miäguꞌughajpähajxy cooc hänajty jim̱ ñøcxaꞌañ Jerusalén, cooc hänajty jim̱ yajtsaac̈hpøgaꞌañíijäm jaꞌa martuumädøjc møødä teedywiindsøṉhajxy møødä ley‑yajnähixøøbiädøjc. Mänit miänaam̱bä cooc hänajty yaghoꞌogaꞌañii, pero cumáax̱cäc hänajty jiujypiøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mänitä Pedro jaꞌa Jesús yajwooduuty. Mänitä Jesús wyiingugapxøøyyä: ―Wiindsǿṉ, cab jaduhṉ yhoyyä miäbaadä coo jaduhṉ mjádät mhabétät. ");
INSERT INTO mirNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mänitä Jesús wiaꞌwiimbijty. Mänitä Pedro yhojjä: ―Juaꞌads jim̱, møjcuꞌu. Náx̱yhøch miic̈h xjiøjcapxøꞌøy. Jaduhṉ miic̈h mwiinmahñdy nebiä jäyaꞌayhajxy wyiinmahñdyhatiän. Caj miic̈h mwiinmahñdy tiuhṉä nebiä Dios wyiinmahñdiän. ");
INSERT INTO mirNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mänitä Jesús ñämaayy jaꞌa miäguꞌughajpä: ―Pǿṉhøch nmädiaꞌagy jaduhṉ xpiaduꞌubøgáaṉäp, weenä yhamdsoo cuhdujt ñajtshixøꞌøy; ween jaduhṉ chaac̈hpǿjpät nébiøch ndsaac̈hpøgaꞌañän; weenc̈h nmädiaꞌagy xjiøjtägøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pøṉ yhamdsoo wiinmahñdy ja wiꞌi yaghidaam̱b, cuhdägoyyaam̱b jeꞌe. Pero coo pøṉ jaduhṉ yhóꞌogät jaꞌa høøc̈hcøxpä, näꞌägä hodiuum jeꞌe nøcxy miähmøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Coo pøṉ jaduhṉ quiuhdägóyyät, hoy jaduhṉ yaa tøø jia mäyøøhaty hädaa yaabä naax̱wiin, caj tii piaadaꞌañ. Cabä jiugyhajt jaduhṉ piaadaaṉnä, homiäduhṉ̃tiä xädøꞌøñ cu jia yec. ");
INSERT INTO mirNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","28","Cädaactägatsáam̱bøch yaa, høøc̈h jaꞌa Diosquex̱ypä. Jaꞌa Diosmóonsøch nmøødcädaꞌagaam̱by, jaꞌa hajxy jim̱ tsajpootypä. Mǿødhøch nDeedy quiuhdujt jaduhṉ ngädaactägatsaꞌañ. Mänítøch jaꞌa jugyhajt hänajty njaac moꞌowaꞌañ pønjaty hänajty hoy tøø wiädity. Pero pønjaty hänajty hoy tøø quiaꞌa wädity, jeꞌeds hajxy hänajty yajcumädow̱áaṉäp. Mänítøch ndägøꞌøwaꞌañ hanehm̱bä. Tøyhajt mijts nnämaꞌay, cooc̈h hänajty ngädaactägatsaꞌañ, mänítøch hajxy näjéꞌeyyäm xyhixaꞌañ, jaꞌa hajxy yaa tänaabiä. Cajnä hajxy hänajty yhoꞌogyñä. ");
INSERT INTO mirNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Cudädujxøø jaꞌa Jesús jaꞌa Pedro wioonøcxy tuṉnähgøxp møødä Jacobo møødä Jacobo yhuch Juan. Nämädaax̱c hajxy jaduhṉ ñøcxy møødä Jesús. ");
INSERT INTO mirNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mänitä Jesús wiing jiajty maa jaꞌa Pedro wyiinduumhajxiän. Jaduhṉdsä wyiin jiøjp cøjx jiaty nebiä haam̱bän. Mänitä wyit hobioob jiajty. ");
INSERT INTO mirNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mänitä Moiséshajxy ñäguehx̱tøøꞌxy møødä Elías. Mänitä Jesús hajxy tiägøøyy møødmädiaacpä. Coo hajxy yhijxä, ");
INSERT INTO mirNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","mänitä Pedro jaꞌa Jesús ñämaayy: ―Wiindsǿṉ, hoyøøyy jaduhṉ coo højts yaa tøø nbéjtäm. Pø chojpiä mjoot jaduhṉ, ween højts tøjquemyhuung tägøøg nhuuc hädiuṉ̃ jaꞌa mijtscøxpä cøjtuꞌug; tuꞌug miic̈h mjeꞌe, tuꞌug jaꞌa Moisés jieꞌe, tuꞌug jaꞌa Elías jieꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mädiaaccujc jaꞌa Pedrohajxy ñähgädaacpejtä jaꞌa nämaꞌa. Hajajp jaꞌa nämaꞌa hänajty. Mänit hajxy miädooyy quiapxy nämaꞌajooty: ―Høøc̈h nHuung hädaa; njaanc̈h tehm̱ chójpiøch. Xyagjootcugǿøbiøch. Huuc mädoow̱ä jaꞌa miädiaꞌagy hajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Coo jaꞌa Pedrohajxy jaduhṉ miädooyy, mänit hajxy miägutscädaacy naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mänit hajxy ñähdooṉä jaꞌa Jesús. Mänit hajxy ñämaayyä: ―Pädøꞌøg hajxy; caꞌa hajxy mdsähgøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mänit hajxy piädøꞌcy. Mänit hajxy yhijxwädijty. Cab hajxy pøṉ yhijxy; jagooyyä jaꞌa Jesús hajxy nidiuhm̱ yhijxy. ");
INSERT INTO mirNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mänit hajxy miänajcy tuṉnähgøxp. Mänitä Jesús jaꞌa Pedro ñämaayy: ―Cab hajxy pøṉ mhawáaṉät nebiaty hajxy jim̱ tøø mhix̱y tuṉnähgøxp, høxtä cóonøch hänajty tøø njujypiøjtägach, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mänitä Jesús hajxy miäyajtøøyy: ―Yøꞌø ley‑yajnähixøøbiädøjc, tii hajxy coo miänaꞌañ cooc jaꞌa Elías miejtsøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mänitä Jesús yhadsooyy: ―Tøyhajt jaduhṉ coo jaꞌa Elías hijty miejtsøꞌøgaꞌañ. Mänit hijty cøx̱iä wiinä yaghoyøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero mijts jaduhṉ nnämaaby coo jaꞌa Elías tøø jia hoy; pero caj yhøxcajpä. Jaduhṉ tiuuṉä nebiä jäyaꞌay jioothajxy chojquiän. Jaduhṉc̈h hajxy xchaac̈htiunaam̱bä, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mänitä Pedrohajxy wyiinjuøøñä coo jaꞌa Jesús jaꞌa Juan mäyajnäbejpä hänajty miädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mänitä Jesúshajxy miejch maa jaꞌa jäyaꞌayhajxy miayyän. Mänitä tuꞌjäyaꞌay jaꞌa Jesús wyiinjijcädaacy. Mänitä Jesús ñämaayyä: ");
INSERT INTO mirNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Wiindsǿṉ, høøc̈h nhuung näxúuꞌtsäc. Mayhooc jaduhṉ tøø quiäday pojmøød. Hanax̱iä jaduhṉ chaac̈hpøcy. Nax̱y jiøøngädaw̱øꞌøy; nax̱y ñøøgädaw̱øꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yaac̈h tøø nja yajmech maa miic̈h mmäguꞌughajpädøjcän, pero cab hajxy hijty yajnähwaꞌadsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mänitä Jesús miänaaṉ̃: ―Caj mijts mnäꞌägä mäbøcy. Cábøch nmeeꞌxtugaaṉnä cooc̈h mijts njaac møødhídät. Mämíṉ jaꞌa pigänaꞌc yaa. ");
INSERT INTO mirNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mänitä Jesús jaꞌa møjcuꞌu yhojy. Mänitiä jaꞌa pigänaꞌc ñähwaach. ");
INSERT INTO mirNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mänitä Jesús hawiing ñämaayyä jaꞌa miäguꞌughajpädøjc. ―Tii højts jaꞌa møjcuꞌu hijty coo ngaꞌa yajpädsøm̱aꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mänitä Jesús yhadsooyy: ―Caj mijts hijty mnäꞌägädä mäbøcy. Tøyhajt mijts nnämaꞌay, coo hajxy jaduhṉ mmäbǿgät howieeṉ̃tiä, mänit hajxy hotyiijä mjádät. Høxtáhm̱äts yøꞌø tuṉ, coo yøꞌø tuṉ hajxy mnämáꞌawät: “Juaꞌads jim̱, nøcx wiingtuum”; mänítäts yøꞌø tuṉ jiaanc̈h jäwáꞌadsät. Hotyiijä hajxy jaduhṉ mjádät coo hajxy tøyhajt mmäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mänitä møjcuꞌu hajxy myajpädsǿm̱ät coo jaꞌa Dios hajxy mbaꞌyáꞌaxät, coo hajxy mhamajtsc‑hádät. ");
INSERT INTO mirNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jim̱ä Jesús hajxy hänajty wiädity Galileanaaxooty. Mänitä Jesús miänaaṉ̃: ―Xyajcøꞌødägøꞌøwáam̱bøch jaꞌa cuꞌughajxy, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mänítøch hajxy xyaghoꞌogaꞌañ. Pero cudägøøgxøøc̈h njujypiøjtägatsaꞌañ. Mänitä miäguꞌughajpädøjc‑hajxy jiootmadiägøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mänitä Jesúshajxy miejch Capernaum. Mänitä Pedro miäyajtøøw̱ä jaꞌa yajnähjuudiuutpädøjc: ―Nej, cabä mwiindsøṉhajxy ñähjuudiuꞌudy maa jaꞌa tsajtǿjcänä. ");
INSERT INTO mirNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Mänitä Pedro yhadsooyy: ―Ñähjuudiuutyp pues. Mänitä Pedro tiøjtägøøyy maa jaꞌa Jesús hänajty yhäñaꞌayän. Mänitä Jesús jaꞌa Pedro ñämaayy: ―Simón, nej miic̈h mmänaꞌañ, jaꞌa gobiernähajxy, pøṉ hajxy yajnähjuudiuutyp, yhamdsoo cuꞌug, tøgä wiingjäyaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mänitä Pedro yhadsooyy: ―Wiingjäyaꞌay hajxy yajnähjuudiuutyp. Mänitä Jesús miänaaṉ̃: ―Entonces, cabä yhamdsoo cuꞌug hajxy yajnähjuudiuꞌudy. ");
INSERT INTO mirNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero cábøch pøṉ nyagjootmaꞌadaꞌañ. Nøcx mejypiaꞌa. Jiibiä xuhñdy mnøøwobǿꞌøwät. Coo hacx mxúyät, mänit myajpädsǿm̱ät. Jiibiä xädøꞌøñ mbaadaꞌañ hacxhaawjooty. Mädøyhadaam̱b jaduhṉ coo nämetsc nyajniñähjuudiúutämät. Mänítäts nøcxy mnähjuudiuꞌudy. ");
INSERT INTO mirNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mänitä Jesús miäguꞌughajpädøjc‑hajxy miejch maa jaꞌa Jesús wyiinduumän. Mänitä Jesús miäyajtøøw̱ä: ―Pønjaty jaꞌa møjtuuṉg møød maa jaꞌa Dios yhaneꞌemiän. ");
INSERT INTO mirNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Mänitä Jesús jaꞌa pigänaꞌc tuꞌug miøjyaax̱y. Mänitä pigänaꞌc cujc piädaacä. ");
INSERT INTO mirNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","4","Mänitä Jesús miänaaṉ̃: ―Jaꞌa pigänaꞌc‑hajxy, cabä møjtuuṉg hajxy ñiyhøxtáayyäxä. Pøṉ jaꞌa møjtuuṉg yaa niyhøxtáayyäxäp hädaa yaabä naax̱wiin, cab jim̱ tiägøꞌøwaꞌañ maa jaꞌa Dios wyiinduumän. Pero pøṉ jaꞌa møjtuuṉg jaduhṉ caꞌa høxtaaby, nebiä hädaa pigänaꞌc jaduhṉ quiaꞌa høxtaꞌayän, jeꞌeds jaꞌa møjtuuṉg jaduhṉ jim̱ paadaam̱b maa jaꞌa Dios yhaneꞌemiän. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pøṉ jaduhṉ mäguꞌugpǿgäp hädaa pigänaꞌc jaduhm̱bä maa jaꞌa høøc̈hcøxpän, jaduhṉ mäwíinhøch høøc̈h xmiäguꞌughaty. ");
INSERT INTO mirNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Hädaa pigänáꞌc‑høch nmädiaꞌagy hajxy xmiäbǿjcäbä, coo hajxy pønjaty jiøjcapxøꞌøwǿøjät, maas hoy hit jaduhṉ coo jaꞌa mäjøjcapxøøbiä paan yajyoꞌxodsøꞌøwǿøjät y coo miejjiäwipøꞌøwǿøjät hagom̱duum. ");
INSERT INTO mirNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Hanax̱iä hajxy yaa chaac̈hpøcy jaꞌa hajxy hädaa yaabä naax̱wiin tsänaabiä. Paady hajxy chaac̈hpøcy coo jaꞌa jøjcapxøøbiä hajxy piaady. Pero Dios jaduhṉ yajcumädow̱aam̱b jaꞌa mäjøjcapxøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","9","’Coo tii hoyhadsojnä mhíxät, cab jim̱ mmøjhéeꞌpnät ni mgaꞌa nähdónät. Jaduhṉ mnibiädaꞌagǿøjät nebiä wiindspän, nebiä cøꞌøducpän. Pø caj, jim̱ haxøøgtuum mgaꞌawaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Caꞌa yøꞌø pigänaꞌc hajxy mxøøghaty. Cueendähájtäp hajxy jaduhṉ. Jaꞌa Diosmoonsähajxy jaꞌa Dioswiinduumbä, jeꞌedsä pigänaꞌc hajxy cueendähajp. ");
INSERT INTO mirNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Høøc̈h møjhajp. Yaac̈h tøø ngädaꞌagy hädaa yaabä naax̱wiin nébiøch jaꞌa jäyaꞌayhajxy nyajnähwáꞌadsät coo hajxy hijty quiuhdägoyyaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Tsøc mädiáacäm. Jii tuꞌjäyaꞌay meeg mägoꞌx miøødä. Coo tuꞌug tiägóyyät, mänit nøcxy yhøxtaꞌay. Jim̱ä meeghajxy miähmøꞌøy tuṉhøjx, jaꞌa hajxy tøø quiaꞌa tägóyyäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y coo piáadät, mänit xiooṉdaꞌagaꞌañ nägøꞌø nädecypiä. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jaduhṉ mäwíinäts jeꞌe neby højts nDeedyhájtäm jaꞌa jim̱ tsajpootypä; cabä jioot chocy coo ni mädyii pigänaꞌc quiaꞌa cuhdägóyyät. ");
INSERT INTO mirNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Coo jaꞌa mmäjøøn coo jaꞌa mmädøjc jaduhṉ xmiägädiéeyät, mänit hameeꞌch mmägapx mhanéꞌemät. Coo jaduhṉ xmiäbǿjcät, mänit jaduhṉ yhoyǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero coo jaduhṉ xquiaꞌa mäbǿjcät, mänitä jäyaꞌay mmøjyáꞌaxät mejtstägøøg neby hajxy jaduhṉ tiestigohádät waam̱baty hajxy hänajty mmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Y coo ni jaduhṉ quiaꞌa mäbǿgät, mänítäts jaꞌa hermanodøjc mhawáaṉät. Y coo ni jaduhṉ quiaꞌa mäbǿgät, mänit hajxy mbuhwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Tøyhajt mijts nnämaꞌay coo jaꞌa Diosmädiaꞌagy hajxy yaa myajwáꞌxät hädaa yaabä naax̱wiin nebiä jäyaꞌayhajxy jaduhṉ hoy yhídät. Dios hajxy jaduhṉ xyhanéꞌemäp nebiaty hajxy mmädiáꞌagät. ");
INSERT INTO mirNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Jaduhṉ mijts nnämaabiä, coo hajxy nämetsc mnǿcxät tuꞌugmädiaꞌagy hädaa yaabä naax̱wiin, y cooc̈h nDeedy hajxy homiädyiibä xmiäyujwáaṉät jaꞌa jim̱ tsajpootypä, mänit jaduhṉ xmióꞌowät. ");
INSERT INTO mirNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Coo hajxy nämetsc nädägøøg tiuꞌugmúgät maa jaꞌa høøc̈hcøxpän, jím̱høch jaduhṉ nhidaam̱bä cujc. ");
INSERT INTO mirNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mänitä Pedro jaꞌa Jesús ñämaayy: ―Wiindsǿṉ, cooc̈h nmäjøøn cooc̈h nmädøjc jaduhṉ xmiägädiéeyät, naaghóoc‑høch jaduhṉ nmäméeꞌxät. Nej, mädøyyä jaduhṉ cooc̈h juxtujc‑hooc nmäméeꞌxädä. ");
INSERT INTO mirNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mänitä Jesús yhadsooyy: ―Cab jaduhṉ miädøyyä. Cunaaghooc hänajty xmiägädieey, mänit mmäméeꞌxät. ");
INSERT INTO mirNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Neby hajxy hoy mwiinjuǿꞌøwät nebiä Dios yhaneꞌemiän. Tsøc yajmäbáatäm nebiä rey tuꞌugän. Mänitä rey wyiinmahñdyhajty coo jaꞌa mioonsähajxy ñuuꞌxycápxät. ");
INSERT INTO mirNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Naam̱nä hänajty ñuuꞌxycapxtsooñ coo jaꞌa mioonsä tuꞌug miejch. Mamyillón hänajty miänuuꞌxyhadyii. ");
INSERT INTO mirNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero cabä mioonsä xädøꞌøñ hänajty miøødä neby jaduhṉ yajnähwáꞌadsät. Mänitä rey miänaaṉ̃ coo ween tioogǿøjät møødä yhuung møødä tioꞌoxy, møødä chøm̱y møødä tiajy, cøx̱iä nebiä ñuuꞌxy jaduhṉ ñähwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mänitä rey wyiinjijcädaacä jaꞌa mióonsäm. Mänit miänuuꞌxtaacä: “Wiindsǿṉ, meeꞌx. Cøxáam̱bøch nyegaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mänitä wyiindsǿṉ hojioot ñäꞌä møødhajty. Mänit miänaaṉ̃ coo tøø ñähwaꞌac̈h, coo ween yhawaꞌadspädsøm̱y. ");
INSERT INTO mirNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Coo jaꞌa moonsä jim̱ chohṉ̃, mänitiä miämoonsä tuꞌug piaaty. Mejtsmil tägøøgmil hänajty miänuuꞌxyhadyii. Mänitä miämoonsä yoꞌmämadsøøyy. Mänit miänaaṉ̃: “Høøc̈h móoyyäc mädúhṉ̃tiøch miic̈h xmiänuuꞌxyhaty.” ");
INSERT INTO mirNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mänit wyiinjijcädaacä. Mänit miänuuꞌxtaacä: “Meeꞌx, cøxáam̱bøch nyegaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero cabä craa hojioot ñäꞌä møødhajty. Mänitä mähdiøjc yajtsuum̱ä. Jiiby jaduhṉ yhidaꞌañ pujxtøgooty høxtä coonä quiøx̱y yégät. ");
INSERT INTO mirNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Coo jaꞌa moonsädøjc‑hajxy yhijxy, jaꞌa hajxy hänajty jaac jim̱bä, mänit hajxy jiootmabiøjcy. Mänitä wyiindsǿṉ hajxy hoy yhawaaṉä nebiaty hänajty tøø jiaty tøø yhabety. ");
INSERT INTO mirNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mänitä rey jaꞌa mioonsä miøjyaax̱y, jaꞌa hänajty tøø ñähwáꞌac̈häbä. Mänit miänaaṉ̃: “Haxøøghänaꞌc miic̈h. Tøøc̈h miic̈h cøx̱iä nyajnähwaꞌac̈h mädúhṉ̃tiøch miic̈h hijty xmiänuuꞌxyhaty. Páadyhøch miic̈h tøø nyajnähwaꞌac̈h, cooc̈h miic̈h tøø xmiänuuꞌxtaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jaduhṉ miic̈h mmämoonsä cu mnäxuuꞌch nébiøch miic̈h tøø nnäxuuc̈hän.” ");
INSERT INTO mirNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hoyhoy jaꞌa rey jaduhṉ yhawaꞌandaacy. Mänit miänaaṉ̃ coo jaꞌa mioonsä quiumädów̱ät høxtä coonä hänajty tøø yajnähwaꞌac̈h mäduhṉ̃tiä hänajty miänuuꞌxyhadyii. ");
INSERT INTO mirNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jaduhṉc̈h nDeedy mijts xyajcumädow̱aam̱bä, jaꞌa jim̱ tsajpootypä, coo jaꞌa mmäjøøn coo jaꞌa mmädøjc hajxy mgaꞌa mäméeꞌxät hamuumduꞌjoot. Mänitä Jesús jaduhṉ miädiaacmaayy. ");
INSERT INTO mirNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mänitä Jesús jim̱ chohṉ̃ Galilea. Mänit jim̱ ñøcxy Judeanaaxooty. Jím̱äts jeꞌe Jordánmøjnøøhawiimb maa jaꞌa xøø piädsøm̱iän. ");
INSERT INTO mirNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mänitä jäyaꞌayhajxy may piaduꞌubøjcy. Mänit hajxy yajmøcpøjcä jaꞌa Jesúsäm. ");
INSERT INTO mirNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mänitä Jesús ñämejtsä jaꞌa fariseoshajxy näjeꞌebä. Mänitä Jesús hajxy miäyajtøøyy: ―Nej, hoy jaduhṉ coo jäyaꞌay jaꞌa tioꞌoxiøjc näꞌä nägoobä yhøxmádsädä. Paady hajxy jaduhṉ miänaaṉ̃, jia jøjcapxøꞌøwaaṉ jaꞌa Jesús hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mänitä Jesús yhadsooyy: ―Nej, cajnä jaꞌa Diosmädiaꞌagy hajxy mgapxyñä. Jiiby jaduhṉ myiṉ̃ coo jaꞌa Dios jäyaꞌay jecy quiunuuꞌxy yaꞌadioꞌoxy. ");
INSERT INTO mirNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Paadiä yaꞌadiøjc jaꞌa tiaj jaꞌa tieedy hajxy ñähgueecnä, coo jaꞌa toꞌoxiøjc hajxy wyiingpøjnä. Nämetsc hajxy jaduhṉ ñimiøødtsänaꞌawáaṉänä. ");
INSERT INTO mirNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jaduhṉ hajxy yhidaaṉnä nebiä tuꞌqueꞌexpän. Cab jaduhṉ yhoyyä coo hajxy myajniyhøxmadsǿøjät pønjaty jaꞌa Dios jaduhṉ tøø quiunuuꞌxy coo hajxy ñimiøødtsänaꞌawǿøjät ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mänitä Jesús hajxy miäyajtǿøgumbä: ―Tii jaꞌa Moisés jaduhṉ coo miänaaṉ̃ coo jaꞌa toꞌoxiøjc yhøxmadsǿøjät cuhdujthaam. ");
INSERT INTO mirNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mänitä Jesús miänaaṉ̃: ―Coo jaꞌa mgopc‑hajxy jaduhṉ wyiꞌi xiex̱ä, paadiä Moisés hajxy jaduhṉ xquiuhdujtmooyy coo jaꞌa mdoꞌoxiøjc hajxy mhøxmádsät. Pero cabä Dios jaduhṉ quiunuuꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Cab jaduhṉ yhoyyä coo wiingtoꞌoxiøjc mwiingpøjtägátsät, pø näꞌä nägoobä jaꞌa mdoꞌoxiøjc hänajty tøø mhøxmach. Ni jaduhṉ quiaꞌa hoyyä coo høxmachtioꞌoxiøjc mwiingpǿgät. ");
INSERT INTO mirNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mänitä Jesús ñämaayyä jaꞌa miäguꞌughajpähajxy: ―Maas hoyyädaꞌa jaduhṉ coo mgaꞌa näꞌägädä pǿgät. ");
INSERT INTO mirNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mänitä Jesús miänaaṉ̃: ―Cab hajxy nägøx̱iä wyiinjuøꞌøwaꞌañ hädaaduhm̱bä. Jayooyyä hajxy jaduhṉ wyiinjuøꞌøwaꞌañ pønjaty jaꞌa Dios jaduhṉ tøø yajwiinjuøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Näjeꞌe jaꞌa yaꞌadiøjc‑hajxy maꞌad myiṉ̃guiaꞌay; paady hajxy quiaꞌa ñibiøgyii. Näjeꞌe hajxy yajtsucy. Coo jaꞌa Dios hajxy wyiingudsähgøꞌøwaꞌañ, paady hajxy näjeꞌe quiaꞌa nibiøgyii. Pøṉ jaduhṉ meeꞌxtugaam̱b, ween mieeꞌxtucy. ");
INSERT INTO mirNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mänitä pigänaꞌc‑hajxy näjeꞌe wioomejtsä maa jaꞌa Jesús wyiinduumän nebiä Jesús jaꞌa hoyhajt jaduhṉ mióꞌowät. Pero cabä Jesús jaꞌa miäguꞌughajpähajxy jaduhṉ yhojiäwøøyy. Mänit hajxy yhojjä, jaꞌa pigänaꞌc hajxy hänajty tøø wiooméchäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mänitä Jesús miänaaṉ̃: ―Caj, wéenhøch jaꞌa pigänaꞌc‑hajxy xñämech. Caꞌa hajxy mhojy. Coo jaꞌa Diosmädiaꞌagy hajxy jaduhṉ mmäbǿgät nebiä pigänaꞌc‑hajxy miäbøquiän, mänitä Dios hajxy jaduhṉ xyhuunghádät. ");
INSERT INTO mirNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Coo jaꞌa Jesús jaꞌa pigänaꞌc‑hajxy hänajty tøø mioꞌoy jaꞌa hoyhajt, mänit jim̱ chohṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mänitä Jesús jäyaꞌay tuꞌug ñämejtsä. Mänit miäyajtøøw̱ä: ―Wiindsǿṉ, tii hóybøch ndúnäp nébiøch njugyhádat cøjxtaꞌaxiøø nebiä Dios jiugyhatian. ");
INSERT INTO mirNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mänitä Jesús yhadsooyy: ―Tiic̈h jaꞌa hoybä coo xmiäyajtøy. Caj pøṉ jaduhṉ yhoyyä; jagooyyä Dios jaduhṉ yhoyyä. Pø chojpy jaꞌa mjoot jaduhṉ coo mjugyhádat cøjxtaꞌaxiøø nebiä Dios jiugyhatian, mgudiúnäp jaꞌa Diosmädiaꞌagy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mänitä craa miänaaṉ̃: ―Mädyiibä. Mänitä Jesús yhadsooyy: ―Caj mjäyaꞌay‑yaghóꞌogät; caj mméedsät; caj pøṉ mnähøønǿꞌøwät; ");
INSERT INTO mirNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mwiingudsähgǿꞌøwäp jaꞌa mdaj jaꞌa mdeedy; mmøødnijiootpaadǿøjäp jaꞌa mmäjøøn jaꞌa mmädøjc hamuumduꞌjoot. ");
INSERT INTO mirNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mänitä craa miänaaṉ̃: ―Tøøc̈h jaduhṉ ngøx̱y cudiuṉ̃. Múutsnøch hänajty cooc̈h jaduhṉ ngudiuuṉdsohṉ̃. Tijátyhøch jaduhṉ ngaꞌa cudiuum̱yñä. ");
INSERT INTO mirNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Mänitä Jesús miänaaṉ̃: ―Pø mjaanc̈h cudiunaam̱by hoy yajxóṉ, nøcx yøꞌø mjeꞌe cøx̱y toog. Mänitä häyoobädøjc mnäꞌä móꞌowät cøx̱iä. Jaduhṉ jim̱ mdägǿꞌøwät tsajpootyp. Mänítøch jaduhṉ xpiaduꞌubǿgät. ");
INSERT INTO mirNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Coo jaꞌa craa jaduhṉ miädooyy, mänit jaduhṉ jiootmadiägøøyy. Hix̱, mäyøø jaꞌa craa hänajty. Mänit wyiimbijnä. ");
INSERT INTO mirNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mänitä Jesús ñämaayy jaꞌa miäguꞌughajpähajxy: ―Näꞌägä tøyhajt mijts nnämaꞌay, tsip jaduhṉ coo mäyøøhänaꞌc jim̱ ñǿcxät tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tøyhajt jaduhṉ, cab jaduhṉ jiaty tsipä coo jaꞌa camello ñáxät xuhñdyjutjooty. Maas tsip coo mäyøøhänaꞌc jim̱ ñǿcxät tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Coo hajxy jaduhṉ miädooyy, mänit hajxy yagjuøøyy. Mänit hajxy ñimiäyajtøøw̱ä: ―Pøṉds jaduhṉ nähwáꞌadsäp. ");
INSERT INTO mirNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mänit hajxy wyiinheeꞌppejtä jaꞌa Jesúsäm. Mänitä Jesús miänaaṉ̃: ―Cabä jäyaꞌayhajxy jaduhṉ ñäꞌä jájpät; pero hotyiijä jaꞌa Dios jaduhṉ jiaty. ");
INSERT INTO mirNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mänitä Pedro miänaaṉ̃: ―Wiindsǿṉ, tøø højts cøx̱iä nnähgueꞌegy nhøxyoꞌoy. Tøø højts miic̈h nbaduꞌubøjnä. Tii højts jaduhṉ nbaadaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mänitä Jesús yhadsooyy: ―Näꞌägä tøyhajt mijts nnämaꞌay, coo jaꞌa xøøwiimbä naax̱wiimbä cøx̱iä jieem̱dägátsät, mänítøch jim̱ nøcxy nhøxtaꞌagaꞌañ maa jaꞌa Dios wyiinduumän, høøc̈h jaꞌa Diosquex̱ypä. Jím̱høch nhaneꞌemaꞌañ. Y mijts, jim̱ hajxy jaduhṉ nøcxy mhøxtaꞌagaam̱bä pønjátyhøch yaa tøø xpiawädity. Cøduꞌug häñaabiejt hajxy jim̱ mbaadaꞌañ, majmetspä. Jim̱ mijts jaꞌa judíoshajxy mhaneꞌemaꞌañ, jaꞌa majmetsc‑hagajptpä. ");
INSERT INTO mirNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pønjaty jaꞌa tiøjc jaduhṉ tøø ñähgueꞌegy jaꞌa høøc̈hcøxpä, o jaꞌa piuhyaꞌay jaꞌa piuhdoꞌoxy, o jaꞌa tiaj jaꞌa tieedy, o jaꞌa yhuung jaꞌa tioꞌoxy, o jaꞌa ñaax̱, majiäduhṉ̃tiä piaattägatsaꞌañ, y cøjxtaꞌaxiøø jiugyhadaꞌañ nebiä Dios jiugyhatian. ");
INSERT INTO mirNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jaꞌa hajxy møjtuuṉgmøødpä jädaꞌahaty, nämay jaꞌa tiuuṉg hajxy yajtägoyyaꞌañ; y jaꞌa møjtuuṉg hajxy jädaꞌahaty caꞌa møødpä, nämay hajxy miøjtuuṉgpaadaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Maa jaꞌa Dios yhaneꞌemiän, tsøc yajmäbáatäm nebiä cudsaatypcam̱än tuꞌug. Jopy jaduhṉ tiuꞌubøjcy moonsähøxtaabiä, pøṉ jaduhṉ miøødtúnäp jaꞌa chaatypcamjooty. ");
INSERT INTO mirNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Coo piaaty, mänit hajxy quiojyquiapxtiuuṉ̃ coo jaꞌa xiøøhajxy jiuyáaṉäxä mägoox̱miljaty. Mänit hajxy quiejxä tuum̱bä maa jaꞌa tsaatypcam̱än. ");
INSERT INTO mirNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Møjpetyxiøø jaꞌa cudsaatypcam̱ tiuꞌubǿjcumbä moonsähøxtaabiä. Mänitä jäyaꞌay jim̱ yhijxy maa halaplaazän. Nämetsc nädägøøghajxy hänajty jim̱ tiänaꞌay. Cabä tuuṉg hajxy hänajty miøødä. ");
INSERT INTO mirNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mänit hajxy ñämaayyä: “Jam̱ hajxy cudúṉ maac̈h ndsaatypcam̱än. Näꞌä mädøyyäjuǿøbyhøch jaduhṉ njuyaꞌañ.” Mänit hajxy ñøcxy cuduum̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mänitä cudsaatypcam̱ yhóoguiumbä moonsähøxtaabiä cujyxiøøhoꞌogy. Mänit yhóoguiumbä mänacyxiøø. ");
INSERT INTO mirNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Møjmänacyxiøø tiuꞌubǿjcumbä. Jim̱ä jäyaꞌay yhijxy halaplaaz. Cabä tuuṉg hajxy hänajty miøødä. Mänit hajxy ñämaayyä: “Tii mijts coo myaajä. Tii hajxy yaa coo mwiꞌi xiunax̱y.” ");
INSERT INTO mirNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mänit hajxy miänaaṉ̃: “Cab højts pøṉ waam̱b tøø xñämaꞌay.” Mänit hajxy ñämaayyä: “Jam̱ hajxy cudúṉ maac̈h nnaaxootiän. Näꞌä mädøyyäjuǿøbyhøch jaduhṉ njuyaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Coo chuujøøyy, mänitä cudsaatypcam̱ jaꞌa moonsäwiindsǿṉ møjhajpä ñämaayy: “Mmøjyáꞌaxäp yøꞌø moonsähajxy. Mänit hajxy mmäjúyät. Pønjaty høx̱haam tøø jiaac tägøꞌøy cuduum̱bä, jeꞌeds hajxy jawyiin mmäjuuc̈hóonäp. Y pønjaty jawyiin tägøøyy cuduum̱bä, jeꞌeds hajxy høx̱haam mmäjúyäp.” ");
INSERT INTO mirNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mänit hajxy yajmäjuuyy. Jawyiin hajxy yajmäjuuyy jaꞌa hajxy hänajty tøø tiägǿꞌøyäbä mänacyxiøø. Pedyii hajxy jaduhṉ miooyyä mägoox̱miljaty. ");
INSERT INTO mirNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jaꞌa hajxy hänajty tøø tiägǿꞌøyäbä jayøjp, jaduhṉ hajxy hänajty tiajy miay coo hajxy maas majiaty mioꞌowaꞌañii. Pero jaduhṉ hajxy mióoyyäbä mägoox̱miljaty. ");
INSERT INTO mirNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Coo hajxy jaduhṉ yajmäjuuyy tuꞌcuhdujtä, paadiä cudsaatypcam̱ hajxy miäjootmaꞌty. ");
INSERT INTO mirNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mänit hajxy miänaaṉ̃: “Yøꞌø hänaꞌc‑hajxy høx̱haam tøø jiaac tehm̱ tiägǿꞌøyäbä, tuꞌhóräyyä hajxy jaduhṉ ñäꞌä tuuṉ̃. Pero jaduhṉ miic̈h tøø mmäjuy neby højts tøø xmiäjúyyän. Cab jaduhṉ yhoyyä. Tøø højts tuꞌxøø nmeeꞌxtucy. Jaanc̈h tehm̱ yhaṉ jaduhṉ. Hamäjaa højts jaduhṉ tøø nmänax̱y.” ");
INSERT INTO mirNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mänitä cudsaatypcam̱ yhadsooyy: “Mäguꞌughajpä, cábøch miich tøø nyajniwyiindoyii. Jaduhṉ ngojyquiapxtiúuṉäm cooc̈h miic̈h mägoox̱mil nmoꞌowaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chaadsä mmäjuhñdy. Nøcxnä. Chójpiøch njoot jaduhṉ cooc̈h yøꞌø craa nmóꞌowät nébiøch miic̈h tøø nmoꞌoyän, yøꞌø craa høx̱haam tøø jiaac tägǿꞌøyäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nej, cábøch jaꞌa cuhdujt jaduhṉ nmøødä cooc̈h nxädøꞌøñ jaduhṉ nyajwáꞌxät nébiøch njoot choquiän. Tøgä paady jaduhṉ mjootmaꞌadiä, cooc̈h hojioot nmøødä.” ");
INSERT INTO mirNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pønjaty høx̱haam tägøøby, copc‑hadaam̱b jeꞌe. Pønjaty jawyiin tägøøby, høx̱haamøꞌøwaam̱b jeꞌebä. Nämay hajxy jaduhṉ tøø jia møjyaꞌaxyii, pero näweeṉ̃tiä hajxy tøø wyiimbiyii. ");
INSERT INTO mirNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mänitä Jesúshajxy jim̱ chohṉ̃, ñøcxy hajxy Jerusalén. Nämay jaꞌa cuꞌughajxy hänajty ñøcxy. Tuꞌhaamnøcxpä jaꞌa Jesúshajxy yohwiaꞌxy møødä miäguꞌughajpädøjc‑hajxy nämajmetspä. Mänitä Jesús miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Yam̱ hajxy nnǿcxäm Jerusalén. Høøc̈h jaꞌa Diosquex̱ypä, jím̱høch hänaꞌc xyajcøꞌødägøꞌøwaꞌañ maa jaꞌa teedywiindsøṉhajxiän, maa jaꞌa ley‑yajnähixøøbiädøjc‑hajxiän. Jím̱høch hajxy xyajyaghoꞌogaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mänítøch hajxy xyajcøꞌødägøꞌøwaꞌañ maa jaꞌa jäyaꞌayhajxiän, jaꞌa jäguem̱naax̱tsohm̱bä. Mänítøch hajxy xwyiinwoonaꞌañ. Mänítøch hajxy xwiobhoꞌogaꞌañ. Mänítøch hajxy xmiøjpahbedaꞌañ cruzcøxp. Pero cudägøøgxøøc̈h jaduhṉ njujypiøgaꞌañ cooc̈h hänajty tøø nhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jaduhṉä Jesús miäguꞌughajpähajxy hänajty xiøhaty metscä, Jacobo møødä Juan. Zebedeo jaꞌa tieedyhajxy hänajty xiøhaty. Coo jaꞌa Jesúshajxy hänajty ñøcxy Jerusalén, jim̱ä Jacobo tiajhajxy hänajty piawädijpä. Mänit miejch maa jaꞌa Jesús wyiinduumän. Mänitä Jesús wyiinjijcädaacä, miäyujwaaṉä jaꞌa mayhajt. ");
INSERT INTO mirNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mänitä Jesús miänaaṉ̃: ―Tii mayhájthøch jaduhṉ ndúnäp. Mänitä tajjäyaꞌay yhadsooyy: ―Coo miic̈h hänajty tøø mgoody maa mhaneꞌemaꞌañän, mänit mhanéꞌemät cooc̈h nhuunghajxy yaghøxtaꞌagǿøjät hahooyhaampiä møødä hanajtyhaampiä maa miic̈h mwiinduumän. ");
INSERT INTO mirNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mänitä Jesús jaꞌa nämajmetspä ñämaayy: ―Cab hajxy jaduhṉ mnajuøꞌøy tii hajxy jaduhṉ myujwaam̱by. Nej, hoy hajxy jaduhṉ mjadaꞌañ mhabetaꞌañä nébiøch jaduhṉ njadaꞌañ nhabetaꞌañän. Mänit hajxy yhadsooyy: ―Hoy pues. ");
INSERT INTO mirNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mänitä Jesús miänaaṉ̃: ―Näꞌägä tøyhajt jaduhṉ coo mijts jaduhṉ mjadaam̱bä mhabetaam̱bä nébiøch njadaꞌañ nhabetaꞌaṉ̃än. Pero cábøch cuhdujt jaduhṉ nmøødä coo hajxy jim̱ mhøxtáꞌagät maac̈h nwiinduumän, hahooyhaampiä møødä hanajtyhaampiä. Pønjátyhøch jaꞌa nDeedy jaduhṉ tøø yajnähdijy, jeꞌeds jaduhṉ jim̱ høxtaꞌagaam̱b maac̈h nwiinduumän. ");
INSERT INTO mirNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Coo jaꞌa Jesús miäguꞌughajpädøjc‑hajxy jiaac mädooyy jaꞌa jaac nämajcpä, mänitä Jacobo hajxy miäjootmaꞌty møødä Juan. ");
INSERT INTO mirNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mänitä Jesús jiämiøød quiøx̱y møjyaax̱y. Mänit miänaaṉ̃: ―Mnajuøøby hajxy coo jaꞌa gobiernähajxy yhaneꞌemy maa hajxy tiuṉ̃än. Jaꞌa hajxy møjtuuṉgmøødpä, jeꞌeds hajxy maas hanehm̱b. ");
INSERT INTO mirNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero mijts, cab hajxy jaduhṉ mhaneꞌemaꞌañ. Pøṉ jaꞌa møjtuuṉg jaduhṉ tsojp maa mijtsän, tsipcøxp jaꞌa miäguꞌughajpä piuhbédät. ");
INSERT INTO mirNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Y jaanä jaduhṉduhm̱bä, pøṉ jaduhṉ yajcumayaam̱b maa mijtsän, tsipcøxp jaꞌa miäguꞌughajpä yajtunǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Høøc̈h jaꞌa Diosquex̱ypä, puhbéjpøch jaduhṉ tøø ngädaꞌagy. Cábøch jaduhṉ nyajpuhbedaꞌañ. Páadyhøch yaa tøø ngädaꞌagy nébiøch jaꞌa jäyaꞌay jaduhṉ may nnähhoꞌtúꞌudät. ");
INSERT INTO mirNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tøø hajxy hänajty quioody maa jaꞌa cajpt hänajty xiøhatiän Jericó. Coo hajxy quiajptpädsøøm̱y, mänitä jäyaꞌayhajxy may piaduꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jim̱ä wiindspähajxy hänajty quiuhx̱naꞌay tuꞌubaꞌa nämetscä. Coo jaꞌa Jesús hajxy miädooyy ñajxy, mänit hajxy yaax̱y: ―Wiindsǿṉ, miic̈h jaꞌa David jecy mhaphajt mdeedyhajt. Højts näxúuꞌtsäc. ");
INSERT INTO mirNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mänit hajxy yhojjä jaꞌa cúꞌugäm, ween hajxy jaduhṉ yhamoṉ̃. Pero cab hajxy miäbøjcy. Mänit hajxy tehṉgajnä yáax̱y: ―Wiindsǿṉ, miic̈h jaꞌa David jecy mhaphajt mdeedyhajt. Højts näxúuꞌtsäc. ");
INSERT INTO mirNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mänitä Jesús tiänaaxiøjpy. Mänitä wiindspähajxy miøjyaax̱y: ―Tii mayhajt hajxy jaduhṉ mdsojpy. ");
INSERT INTO mirNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mänit hajxy yhadsooyy: ―Højts yaghijxǿꞌcäc. ");
INSERT INTO mirNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mänit hajxy ñäxuuꞌtsä. Mänit hajxy wyiingudsiiwøøyyä. Mänit hajxy jiaanc̈h hijxøꞌcy. Mänitä Jesús hajxy piaduꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mäwiingoom̱b jaꞌa Jesúshajxy hänajty jim̱ Jerusalén. Mänit hajxy miejch maa jaꞌa cajpt hänajty xiøhatiän Betfagé, jim̱ mädøyyä maa jaꞌa Olivostuṉän. ");
INSERT INTO mirNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Mänitä Jesús jaꞌa miäguꞌughajpä nämetsc ñämaayy: ―Nøcx hajxy maa yøꞌø cajpt xim̱haampiän. Jim̱ä burrataj hajxy mbaadaꞌañ cuxoch møødä yhuung. Mmäguejǿꞌøwäp hajxy jaduhṉ. Mänit hajxy yaa mwitsmínät. ");
INSERT INTO mirNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Coo hajxy pøṉ waam̱b xñämáꞌawät, jaduhṉ hajxy mnämáꞌawät coo jaꞌa wiindsǿṉ jaduhṉ yajmaajiaty, coo hajxy mänit mmoodiägatsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jaduhṉds tiøjiajty nebiä Diosmädiaꞌagy‑yajwaꞌxpä jecy quiujahyyän: ");
INSERT INTO mirNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jaduhṉdsä cuꞌug hajxy mhawáaṉät jaꞌa hajxy jim̱ tsänaabiä Jerusalén: “Huuc heeb hajxy, xiidsä mgobiernä hajxy jaduhṉ xñägoody burrohuungnähgøxp møødä burrataj. Cab jaduhṉ yajcumayaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","7","Mänitä burrataj hajxy hoy wyich møødä burrohuung, neby hajxy hänajty tøø ñämaꞌayiijän. Mänitä Jesús miäguꞌughajpä wyithajxy yagjäbeꞌenøøyy jaꞌa burrohuung. Mänitä Jesús yajpejty. ");
INSERT INTO mirNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jim̱ä cuꞌughajxy hänajty may tøø yhamugøꞌøy. Mänitä wyit hajxy yeꞌpy tuꞌhaam maa jaꞌa Jesús hänajty ñaxøꞌøwaꞌañän. Jaꞌa jäyaꞌayhajxy näjeꞌebä, mänitä hujtshaaꞌx hajxy hoy ñäbux̱y. Mänitä hujtshaaꞌx hajxy hoy ñajtswidsøꞌøy tuꞌhaam. ");
INSERT INTO mirNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mänit hajxy nägøx̱iä tiägøøyy hayaax̱pä: ―¡Viva jaꞌa rey David yhap yhoc! Tsøg hajxy wiingudsähgǿøyyäm, jaꞌa Dios tøø quiéx̱iabä. Weenä Dios jim̱ wyiingudsähgøꞌøyii tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mänitä Jesúshajxy quiooꞌty Jerusalén. Coo hajxy tiägøøyy cajptooty, mänitä cuꞌughajxy tiägøøyy haamhajpä. Mänit hajxy nämay ñimiäyajtøøw̱ä: ―Pøṉ jäyaꞌay yøꞌøduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mänit hajxy yhadsooyy: ―Jesús yøꞌø. Nazaret chooñ Galileanaaxooty. Jaꞌa Diosmädiaꞌagy jaduhṉ yajwaꞌxyp. ");
INSERT INTO mirNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mänitä Jesús tiägøøyy Diostsajtøgooty. Jiibiä jäyaꞌayhajxy hänajty may jiuydioogy. Mänit hajxy yhøxquejxpädsøøm̱ä. Mänitä xädøꞌøñguiuwijtspädøjc jaꞌa mieexä hajxy yajtsitǿꞌcäxä møødä palomatooꞌpädøjc jaꞌa yhäñaabiejthajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mänitä Jesús miänaaṉ̃: ―Jaduhṉ myiṉ̃ cujaay maa jaꞌa Diosmädiaꞌaguiän: “Jueꞌec̈h ndøjc hajxy xwiáaṉät cooc̈h hajxy jaduhṉ jiiby xpiaꞌyáꞌaxät.” Dios jaduhṉ mänaaṉ; pero mijts jaduhṉ mwaꞌañ meedsøhñdy podøhñdy. ");
INSERT INTO mirNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mänitä Jesús ñämejtsä jaꞌa wiindspä møødä tecymiaꞌadpä. Jiiby hajxy hänajty ñäꞌägä hity tsajtøgooty. Mänit hajxy yajmøcpøjcä yajmäbaadøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jiibiä pigänaꞌc‑hajxy hänajty wyiꞌi yaꞌaxy tsajtøgooty: “¡Viva jaꞌa rey David yhap yhoc!” Jaꞌa teedywiindsøṉhajxy møødä ley‑yajnähixøøbiädøjc‑hajxy, coo hajxy yhijxy nebiä Jesús jaꞌa hoy‑yagjuøøñäjatypä hänajty yajcähxøꞌøguiän, coo hajxy miädooyy coo pigänaꞌc‑hajxy hänajty wyiꞌi yaꞌaxy, mänit hajxy yhawaꞌandaacy. ");
INSERT INTO mirNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mänitä Jesús ñämaayyä: ―Nej, mmädooby jaduhṉ waam̱baty hajxy yaꞌaxiä. Mänitä Jesús yhadsooyy: ―Jex̱ioꞌch, nmädóobiøch jaduhṉ. Pero mijts, nej, cajnä hajxy jaduhṉ mmädoyhatyñä nebiä Diosmädiaꞌagy myiṉ̃än cooc jaꞌa Dios jaduhṉ tøø miänaꞌañ coo jaꞌa pigänaꞌc‑hajxy ween yhøy maa jaꞌa Dioscøxpän. ");
INSERT INTO mirNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mänitä Jesúshajxy jim̱ chohṉ̃. Mänit hajxy ñøcxy maa jaꞌa cajpt hänajty xiøhatiän Betania. Jim̱ hajxy jaduhṉ chuunajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Coo jiobøøyy, mänitä Jesúshajxy wyiimbijty. Yähóꞌcäp hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tuꞌhaamnøcxpä piids hajxy jaduhṉ piaaty. Pero cabä tii tøøm hänajty miøødä. Haagä haay hänajty jeꞌe. Mänitä Jesús jaꞌa piids ñämaayy: ―Ni mänaa miic̈h mgaꞌa tøømbejtägatsaaṉnä. Mänitiä jaꞌa piids jaduhṉ jiaanc̈h tøøc̈h. ");
INSERT INTO mirNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Coo jaꞌa Jesús miäguꞌughajpähajxy jaduhṉ yhijxy, mänit hajxy jiaanc̈h tehm̱ yagjuøøyy. Mänitä Jesús miäyajtøøw̱ä: ―Neby yøꞌø piids jaduhṉ paquiä jiaanc̈h tøøch. ");
INSERT INTO mirNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mänitä Jesús yhadsooyy: ―Näꞌägä tøyhájthøch mijts nnämaꞌay, coo hajxy hamuumduꞌjoot mjaanc̈h mäbǿgät, hotyiijä hajxy jaduhṉ mjádät, nébiøch yøꞌø piids jaduhṉ tøø nyajtøꞌøc̈hän. Coo yøꞌø tuṉ hajxy jaduhṉ mnämáꞌawät: “Juaꞌads jim̱, nøcx mejjiooty tägøꞌøw”, mänit jaduhṉ jiaanc̈h tägǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pø mjaanc̈h mäbøjp hajxy jaduhṉ, coo jaꞌa Dios hajxy tijaty mmäyujwáꞌanät, mänit hajxy jaduhṉ xmióꞌowät. ");
INSERT INTO mirNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mänitä Jesús tiägøøyy tsajtøgooty. Mänit tiägøøyy yajnähixøøbiä. Mänitä teedywiindsøṉhajxy miejch møødä martuumädøjc. Mänitä Jesús miäyajtøøw̱ä: ―Pøṉ miic̈h cuhdujt tøø xmioꞌoy coo miic̈h yaa mhanéꞌemät. ");
INSERT INTO mirNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mänitä Jesús yhadsooyy: ―Cooc̈h mijts jaꞌa tøyhajt xmióꞌowät nébiøch mijts cham̱ nmäyajtøwaꞌañän, mänítøch mijts jaꞌa tøyhajt nmoodiägátsät pǿṉhøch jaꞌa cuhdujt tøø xmioꞌoy cooc̈h yaa nhanéꞌemät. ");
INSERT INTO mirNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Pøṉä Juan jaduhṉ quejx mäyajnäbejpä, Dios tøgä jäyaꞌayä. Cab hajxy ñäꞌä hadsooyy. Mänit hajxy tiägøøyy yajcapxiøøbiä: ―Coo hajxy nhadsóow̱ämät coo jaꞌa Dios quiejxy, mänit hajxy xmiäyajtøwáaṉäm tii jaꞌa Juan miädiaꞌagy hajxy coo tøø ngaꞌa mäbǿjcäm. ");
INSERT INTO mirNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ni jaduhṉ quiaꞌa hoyyä coo hajxy nhadsóow̱ämät coo jäyaꞌay jaduhṉ quiejxy; cabä cuꞌughajxy jaduhṉ yhojiäwǿꞌøwät. Jaduhṉ hajxy miänaꞌañ cooc jaꞌa Juan Dyiosquex̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mänitä Jesús ñämaayyä: ―Cab højts nnajuøꞌøy. Mänitä Jesús miänaaṉ̃: ―Cábøch nnägapxaam̱bä pǿṉhøch jaꞌa cuhdujt tøø xmioꞌoy cooc̈h yaa nhanéꞌemät. ");
INSERT INTO mirNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mänitä Jesús miänaaṉ̃: ―Chaads mijts cuento tuꞌug nyajmøødmädiaꞌagaꞌañ. Jii jäyaꞌay hijty tuꞌug; metscä yhuung hänajty. Mänitä yhuung ñämaayy tuꞌug: “Huung, nøcx jim̱ huuc tuṉ maac̈h ndsaatypcam̱än.” ");
INSERT INTO mirNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mänitä yhuung yhadsooyy: “Cábøch nnøcxaꞌañ.” Pero mänit wyiinmahñdyhajty jadähooc coo jaduhṉ ñøcxáaṉgumbä. ");
INSERT INTO mirNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mänitä yhuung tuꞌug ñämáaguiumbä coo ñǿcxät tuum̱bä. Mänit yhadsooyy coo ñøcxaꞌañ. Pero cab jaduhṉ ñäꞌä nøcxy. ");
INSERT INTO mirNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mädyii craa jaduhṉ cudiuuṉ nebiä tieedy hänajty tøø miänaꞌañ. Mänit hajxy yhadsooyy: ―Jaꞌa jawyiinhajpä. Mänitä Jesús miänaaṉ̃: ―Näꞌägä tøyhájthøch mijts nnämaꞌay, jawyiin jaꞌa yajnähjuudiuutpädøjc‑hajxy tiägøꞌøwaꞌañ Dioswiinduum møødä cuhhiṉdoꞌoxiøjc‑hajxy. Pero mijts, høx̱haam mijts mdägøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jaꞌa Juan mäyajnäbejpä, hoy mijts xjia yajnähixøøyy neby hajxy hoy mwädítät, cab hajxy mmäbøjcy. Jaꞌa yajnähjuudiuutpädøjc‑hajxy møødä cuhhiṉdoꞌoxiøjc‑hajxy, jeꞌeds hajxy jaduhṉ mäbøjc. Hoy mijts mja hijxy coo hajxy miäbøjcy, caj mijts mwiinmahñdyhajty jadähooc coo hajxy mmäbǿjpät. ");
INSERT INTO mirNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Chaads mijts cuento tuꞌug nyajmøødmädiaꞌagáaṉgumbä. Jii jäyaꞌay hijty tuꞌug naax̱møød. Mänitä tsaatypcam̱ quiojy. Mänit curaa piädaacy. Mänitä tsaatyñøøxeeꞌxøhñdy ñädajøøyy tsaajooty. Mänitä häñaꞌawøhñdy cøxp quiojy. ’Mänitä wiingjäyaꞌay jaꞌa tsaatypcam̱ hajxy yaghajoodiujcä. Mänita cudsaatypcam̱ jim̱ chohṉ̃, ñøcxy jäguem̱. ");
INSERT INTO mirNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Coo jaꞌa tsaatyptuc yhabaaty, mänitä cudsaatypcam̱ miejtstägajch. Mänitä mioonsä quiejxy coo jaꞌa tsaatyp hajxy yajmédsät mäduhṉ̃tiä hajxy hänajty mioꞌowaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mänitä mioonsähajxy miájtsäxä; jaꞌa naax̱hajoodiujpähajxy jaduhṉ mämajts. Wojpä mähdiøjc tuꞌug; yaghoꞌcä tuꞌugpä; caꞌtsä tuꞌugpä. ");
INSERT INTO mirNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mänitä cudsaatypcam̱ jaꞌa mioonsä quiejxy maas may. Jaanä jaduhṉ hajxy yhayoow̱híjxäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Mänitä yhamdsoo huung jaduhṉ quiejxy coo tyijy jaduhṉ wyiingudsähgǿøyyäxät. ");
INSERT INTO mirNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero coo yhuung jaduhṉ yhíjxäxä, mänitä naax̱hajoodiujpähajxy ñiñämaayyä: “Coo yøꞌø craa jaꞌa tieedy yhóꞌogät, mänit yøꞌø craa jaꞌa tsaatypcam̱ miämähmøꞌøwaꞌañ. Tsøg hajxy yaghóꞌcäm. Mänit højts jaꞌa tsaatypcam̱ jaduhṉ nmämähmǿøyyämät.” ");
INSERT INTO mirNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mänit hajxy jiaanc̈h majch. Mänit hajxy yhøxjuijpädsøøm̱y. Mänit hajxy yaghoꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Hoorä, coo jaꞌa cudsaatypcam̱ jaduhṉ miédsät, nebiä naax̱hajoodiujpähajxy tiunaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mänit hajxy yhadsooyy: ―Yaghoꞌtägatsáaṉäp hajxy jaduhṉ jeꞌeguiøxpä coo hajxy quiaꞌawiindøyyä. Mänitä wiingjäyaꞌay jaꞌa naax̱ yaghajoodiugaꞌañ, pøṉä tsaatyp jaduhṉ yegaam̱b coo jaꞌa tsaatyptuc yhabáadät. ");
INSERT INTO mirNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Mänitä Jesús miänaaṉ̃: ―Nej, cajnä jaꞌa Diosmädiaꞌagy hajxy mgapxyñä maa jaduhṉ myiṉ̃än cujaayä: Jaꞌa tsaa mädyii jaꞌa tøjcojpähajxy quiaꞌa näꞌägä cumaayy, jeꞌe näꞌägä tuuṉdsohṉ. Dios jaduhṉ pädaac, paady højts njaanc̈h tehm̱ yagjuøꞌøy. (Jesús jaduhṉ hamdsoo niyajmäbaatä nebiä tsaajän jeꞌeguiøxpä coo hänajty quiaꞌa tsocy quiaꞌa meeꞌxyíijäm jaꞌa cuꞌug. Pero moꞌowáaṉäp jaꞌa Jesús jaꞌa møjtuuṉg jaꞌa hodiuuṉg hänajty.) ");
INSERT INTO mirNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Paady, xpiøgáaṉäp jaꞌa mguhdujt hajxy coo hajxy jim̱ mdägǿꞌøwät Dioswiinduum. Wiingjäyáꞌayäts jaduhṉ tägøꞌøwaam̱b pønjaty jaduhṉ howiädijp. ");
INSERT INTO mirNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pøṉ jaduhṉ cáꞌawäp yøꞌø tsaanähgøxp, tägóyyäp jaduhṉ. Y coo pøṉ jaduhṉ ñähgahbedǿøjät yøꞌø tsáajäm, jaanä tägóyyäp jeꞌebä. ");
INSERT INTO mirNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Coo jaꞌa teedywiindsøṉhajxy jaduhṉ miädooyy møødä fariseodøjc‑hajxy, mänit hajxy ñajuøøyy coo hajxy hänajty tøø miädiaꞌagyii jaꞌa Jesúsäm. ");
INSERT INTO mirNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mänitä teedywiindsǿṉ jaꞌa Jesús hajxy jia madsaaṉ̃; cab hajxy ñäꞌä majch jeꞌeguiøxpä coo jaꞌa cuꞌug hajxy hänajty chähgøꞌøy; hix̱, jaduhṉä cuꞌughajxy hänajty miänaꞌañ cooc jaꞌa Jesús jaꞌa Diosmädiaꞌagy hänajty yajwaꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Mänitä Jesús tiägǿøguiumbä mädiaacpä. Mänit miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Maa jaꞌa Dios yhaneꞌemiän, jaduhṉ mäwíinäts jeꞌe nebiä rey tuꞌugän. Yajpøgaam̱by jaꞌa yhuung hänajty jeꞌe. Yagjadáaṉäp jaꞌa cay jaꞌa huꞌug hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mänitä mioonsähajxy quiejxy woobä wijtspä; pero cabä jäyaꞌayhajxy hänajty ñøcxaꞌañ mägaabiä. ");
INSERT INTO mirNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mänitä rey jaꞌa mioonsä quiéjxcumbä. Mänit miänaaṉ̃: “Nøcx hajxy nämaꞌaw coo jaꞌa cay jaꞌa huꞌugy tøø quiøønä, cooc̈hä waj tøø nyajyaghoꞌogyii jaꞌa niꞌxpä. Tøø jaꞌa cayiibä yhabaady; weends hajxy miṉ quiay.” ");
INSERT INTO mirNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero cabä jäyaꞌayhajxy ñäꞌägädä mäbøjcy. Tuꞌjäyaꞌay ñøcxy maa jaꞌa quiam̱än; tuꞌjäyaꞌay ñøcxy tooꞌpä. ");
INSERT INTO mirNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mänitä rey mioonsähajxy miájtsäxä jaꞌa jäyaꞌayhajxy hänajty jaac jim̱bä. Mänit hajxy yaghäyoow̱hijxy; yaghoꞌcä hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mänitä rey yhawaꞌandaacy. Mänitä soldadohajxy quiejxä mäyaghoꞌpä. Jaꞌa hajxy hänajty tøø mioonsäyaghóꞌoguiäbä, jeꞌe hajxy nøcxy yaghoꞌogyii; møødä quiajpthajxy nøcxy ñóꞌcäxä. ");
INSERT INTO mirNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mänitä rey jaꞌa mioonsähajxy ñämaayy: “Tøø jaduhṉ yhabaady cooc̈hä nhuung jaduhṉ piøgaꞌañ. Pero jaꞌa jäyaꞌayhajxy tøø nja woy tøø nja wíchäbøch, cab hajxy hawiinmats myínät. ");
INSERT INTO mirNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nøcx hajxy wow̱ wits pønjaty hajxy mbaatyp jim̱ tuꞌhaam.” ");
INSERT INTO mirNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mänitä mioonsähajxy hoy wioy wyich nägøx̱iä, pønjaty hajxy jaduhṉ piaatyp, møødä hojiäyaꞌay møødä haxøøgjäyaꞌay. Mänítädsä tøjc jaduhṉ yhujch. ");
INSERT INTO mirNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Mänitä rey tiøjtägøøyy woybä wichpä hijxpä. Mänitä craa tuꞌug yhijxä, cabä wyit hänajty yhoyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mänit ñämaayyä: “Mäguꞌughajpä, cab yøꞌø mwit yaa hawiinmäts mmädägǿꞌøwät maa jaꞌa pøc jaduhṉ jiadyiijän.” Pero cabä craa ñäꞌä hadsoowiimbijty. ");
INSERT INTO mirNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mänitä rey jaꞌa mioonsä ñämaayy, jaꞌa hajxy hänajty tex̱ycøøbiä: “Cøꞌøxots tecyxiots yøꞌø craa. Mänit hajxy mhøxjuijpädsǿm̱ät maa wyiingoodsän. Jim̱ jaduhṉ jiøꞌøwaꞌañ xiuudsaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nämay hajxy jia møjyaꞌaxaꞌañii, pero näweeṉ̃tiä hajxy jaduhṉ wyiimbiwaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mänitä fariseoshajxy jim̱ chohṉ̃. Mänit hajxy quiojyquiapxytiuuṉ̃ coo jaꞌa Jesús hajxy jiøjcapxøꞌøwaꞌañ neby hajxy jaduhṉ yajnähdsǿmät. ");
INSERT INTO mirNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mänitä miäguꞌughajpähajxy quiejxy møødä Herodes miäguꞌughajpähajxy. Mänitä Jesús hajxy ñämaayy: ―Wiindsǿṉ, nnajuøøby højts coo miic̈h jaꞌa tøyhajt myecy, coo jaꞌa Diostuꞌu myajnähixøꞌøy. Caj miic̈h mmøjpädaꞌagy nebiaty jaꞌa cuꞌughajxy miädiaꞌagy; caj miic̈h mmøjpädaꞌagy pøṉ tyijy møjcuhdujtmøød. ");
INSERT INTO mirNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Højts capxwíjjäc. Nej, hahixøøby jaduhṉ coo jaꞌa gobiernä xädøꞌøñ mmóꞌowädä, jaꞌa jim̱ tsänaabiä Roma. ");
INSERT INTO mirNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ñajuøøbiä Jesús hänajty coo hänajty jia jøjcapxøꞌøwaꞌañii. Mänit miänaaṉ̃: ―Haxøøg mijts mwiinmahñdyhajxy, hoy hajxy mja nibiädaꞌagyii nebiä hojiäyaꞌayän. Tiic̈h hajxy coo xjia jøjcapxøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tsøgä xädøꞌøñ tuꞌug huuc híjxäm. Mänitä Jesús waꞌxxiädøꞌøñ miooyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mänit miänaaṉ̃: ―Pøṉ yhahädiuuṉnax̱y hädaaduhṉ; pøṉ xiøø hädaaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mänit hajxy yhadsooyy: ―Jaꞌa gobiernä. Mänitä Jesús miänaaṉ̃: ―Mmóꞌowäbä gobiernä hajxy mädyii jeꞌe jieꞌe; y mmóꞌowäbä Dios hajxy mädyii jeꞌe jieꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Coo hajxy jaduhṉ miädooyy, mänit hajxy yagjuøøyy. Mänit hajxy wyiimbijnä. ");
INSERT INTO mirNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mänitxøø jaꞌa saduceodøjc‑hajxy näjeꞌe miejch maa jaꞌa Jesúsän. Jaduhṉ hajxy hänajty miänaꞌañ cooc tyijy hajxy ngaꞌa jujypiøjtägatsáaṉäm. Mänitä Jesús hajxy ñämaayy: ");
INSERT INTO mirNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Wiindsǿṉ, jaꞌa Moisés jecy mänaaṉ, coo jaꞌa pøcy‑yaꞌadiøjc yhóꞌogät, jaꞌa cajpä yhuung, mänítädsä piuhyaꞌay jaꞌa yaamgtoꞌoxy wyiingpǿgät, nebiä yaamgtoꞌoxy jaduhṉ yhuungpáadät jaꞌa yaꞌadiøjcøxpä, jaꞌa tøø yhóꞌoguiäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","26","Bueno, näjuxtujc hajxy hijty tuꞌqueꞌex, haagä yaꞌadiøjc. Jaꞌa coobhuung, jayøjp jaduhṉ piøjcy; mänit yhoꞌcy. Cabä yhuung hänajty. Mänítädsä jiädsøm̱y jaꞌa yaamgtoꞌoxy wyiingpøjcy. Mänítäts jeꞌe yhóꞌcumbä. Mänítädsä miädägøøgpä jaduhṉ jiájcumbä. Jaduhṉ hajxy nägøx̱iä jiajty møødä miäjuxtujcpä. ");
INSERT INTO mirNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mänitä toꞌoxiøjc yhoꞌpä høx̱haam. ");
INSERT INTO mirNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bueno, coo hajxy jaduhṉ jiujypiǿgät, mädyii tehm̱ tiøybä hänajty toꞌoxiøjc‑hadaam̱b, jaꞌa näjuxtujcpä puhyaꞌayhajxy, jaꞌa hajxy hänajty tøø jia pǿquiäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mänitä Jesús yhadsooyy: ―Caj mijts jaꞌa tøyhajt mnäꞌägädä møødä. Cabä Diosmädiaꞌagy hajxy mhix̱iä ni jaꞌa Diosmäjaa. ");
INSERT INTO mirNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Coo jaꞌa jäyaꞌayhajxy jiujypiøgaꞌañ, cab hajxy hänajty piøgaꞌañ, ni cabä yhuung hajxy hänajty yajpøgaꞌañ. Jaduhṉ hajxy yhidaꞌañ nebiä Diosmoonsähajxiän, jaꞌa hajxy jim̱ tsajpootypä. ");
INSERT INTO mirNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Hamdsoo jaꞌa Dios hajxy jaduhṉ tøø xñämaꞌay cujaayhaam coo jaꞌa jäyaꞌayhajxy jiujypiøgaꞌañ: ");
INSERT INTO mirNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Xwyiingudsähgǿøbiøch jaꞌa Abraham møødä Isaac møødä Jacob.” Hoorä, wiingudsähgǿøyäp jaꞌa Dios jaꞌa jujcyjiäyaꞌayhájxiäm. Cab jaduhṉ wyiingudsähgøꞌøyii jaꞌa hoꞌogyjiäyaꞌayhájxiäm. ");
INSERT INTO mirNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Coo jaꞌa cuꞌughajxy jaduhṉ miädooyy nebiä Jesús hänajty yajnähixøꞌøy, mänit hajxy yagjuøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Coo jaꞌa fariseoshajxy jaduhṉ miädoyhajty coo jaꞌa Jesús quiaꞌa yajmäjädaacy jaꞌa saduceos, mänitä fariseoshajxy yhamugøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jim̱ä fariseo hänajty tuꞌug; ley‑yajnähixøøby hänajty jeꞌe. Jaꞌa Jesús hänajty jøjcapxøꞌøwáaṉäp. Mänitä Jesús miäyajtøøw̱ä: ");
INSERT INTO mirNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Wiindsǿṉ, mädyii cuhdujt maas møj maa jaꞌa ley myiṉ̃än. ");
INSERT INTO mirNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Mänitä Jesús yhadsooyy: ―“Wiingudsähgøꞌøw jaꞌa nDioshájtäm hamuumduꞌjoot; mäbøjcä jaꞌa miädiaꞌagy; mjahmiédsäp cøjxtaꞌaxiøø.” ");
INSERT INTO mirNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hädaa cuhdujt, jawyiin jaduhṉ myiṉ̃ maa jaꞌa leyän y maas møj jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jaanä jaduhṉ jaꞌa miämetspä miänaam̱bä: “Møødnijiootpaadøø jaꞌa mmäjøøn jaꞌa mmädøjc hamuumduꞌjoot.” ");
INSERT INTO mirNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hädaa cuhdujt metspä, jaꞌa ley yhøjx tiecy jaduhṉ møødä cøx̱iä mäduhṉ̃tiä jaꞌa Diosmädiaꞌagy‑yajwaꞌxpähajxy tøø miädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jim̱nä jaꞌa fariseoshajxy hänajty tiänaꞌayñä. ");
INSERT INTO mirNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Mänitä Jesús miäyajtøøyy: ―Waam̱b mijts mmänaꞌañ jaꞌa Cristocøxpä. Pøṉ jeꞌe yhaphajpy tieedyhajpy. Mänit hajxy yhadsooyy: ―David yhap yhoc jeꞌeduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mänitä Jesús miänaaṉ̃: ―Pero jaꞌa Dioshespíritucøxpä jaꞌa David jaꞌa Cristo ñämaayy: “Wiindsǿṉ.” Jaduhṉä David miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tøøc̈hä Dios jaꞌa nWiindsǿṉ xñämaayyä: “Häñaꞌaw yaa hahooyhaam̱by høxtä coonä jaꞌa mmädsip jaduhṉ quiaꞌa mäjädáꞌagät”, nøm̱ä Dios miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bueno, pø tøø jaꞌa David jaꞌa Cristo ñämaꞌay: “Wiindsǿn”, nébiäts jaduhṉ yhaphat yhoc‑hádät. ");
INSERT INTO mirNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Caj pøṉ waam̱b ñäꞌägädä hadsooyy. Y cabä Jesús waam̱b miäyajtǿøw̱änä høxtä coonä hänajty yhoꞌogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mänitä Jesús jaꞌa cuꞌug ñämaayy møødä jiamiøødhajxy: ");
INSERT INTO mirNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Jaꞌa ley‑yajnähixøøbiädøjc møødä fariseoshajxy, cuhdujtmoꞌoy hajxy jaduhṉ coo jaꞌa Moisés miädiaꞌagy hajxy yajnähixøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mgudiúnäp hajxy jaduhṉ waam̱baty hajxy xñämaꞌay. Pero cab hajxy mbahíxät nebiaty hajxy jiatcøꞌøy. Cabä yhamdsoo mädiaꞌagy hajxy quiudiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hanax̱iä hajxy tsipjaty yajnähixøꞌøy; y mänaam̱b hajxy jaduhṉ coo jaꞌa cuꞌug tsipcøxp quiudiúnät. Pero cab hajxy hamdsoo quiudiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jaanc̈h tehm̱ yajcumayaam̱b hajxy maa jaꞌa cuꞌugwiinduumän. Paadiä nocyquiujaaybä hajxy yajxóṉ yajniwyiinnähgopxodsøꞌøyii; paady hajxy yajniguiøꞌøxodsøꞌøyii. Paadiä wit hajxy piägøꞌøy jaꞌa høxyoṉ̃bä. ");
INSERT INTO mirNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Coo hajxy maa miägay, häñaꞌawaam̱b hajxy hänajty maa jaꞌa meexäteecän. Y coo hajxy ñøcxy tsajtøgooty, häñaꞌawaam̱b hajxy hänajty maa jaꞌa häñaabiejt yajxoṉbän. ");
INSERT INTO mirNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Coo hajxy maa wiädity cajptooty, yajwiingudsähgøꞌøwaam̱b hajxy hänajty maa jaꞌa cuꞌugän. Yajnämaꞌawaam̱b hajxy hänajty: “Wiindsǿṉ.” ");
INSERT INTO mirNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero mijts, cab hajxy mmänáꞌanät coo jaꞌa cuꞌug hajxy xñämáꞌawät: “Wiindsǿṉ.” Tuꞌugä mWiindsøṉhajxy jaduhṉ; jaꞌa Cristo jeꞌe. Jaduhṉ hajxy mnijiäwøꞌøwǿøjät nebiä tuꞌqueꞌexpän. ");
INSERT INTO mirNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Cab hajxy pøṉ mnämáꞌawät: “Teedy”, hädaa yaabä naax̱wiimbä. Tuꞌugä mDeedyhajxy jim̱ cøxp. ");
INSERT INTO mirNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Cab hajxy mmänáꞌanät coo pøṉ xñämáꞌawät coo hajxy xquiopc‑hádät. Tuꞌjayaꞌay hajxy jaduhṉ xyhanéꞌemät; jaꞌa Cristo jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pøṉ jaduhṉ puhbejp jaꞌa jiamiøødhajxy, jeꞌedsä møjtuuṉg jaduhṉ paadaam̱b maa mijtsän. ");
INSERT INTO mirNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hix̱, pøṉ jaduhṉ yajcumayaam̱b, cabä møjtuuṉg jaduhṉ piaadaꞌañ. Pero pøṉ jaduhṉ caꞌa yajcumayaam̱b, jeꞌedsä møjtuuṉg jaduhṉ paadaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mänitä ley‑yajnähixøøbiädøjc‑hajxy ñämaayyä møødä fariseoshajxy: ―Jaduhṉ mijts mnibiädaꞌagyii nebiä hoyhänaꞌcän; pero cab hajxy mhoyhänaꞌcä. Haxøøg hajxy mjadaꞌañ mhabetaꞌañ. Cab hajxy jim̱ mdägøꞌøwaꞌañ maa jaꞌa Dioswiinduumän, y cab hajxy jaduhṉ mmänaꞌañ coo wiinghänaꞌc jim̱ tiägǿꞌøwät, hoy hajxy hänajty hamdsoo jia mänaꞌañ coo hajxy jim̱ tiägøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Xiøøbä jaꞌa Dios hajxy jejcy tøø mnäꞌä paꞌyaꞌaxy. Mänitä yaamgtoꞌoxy jaꞌa tiøjc hajxy mbøjcä. Paady hajxy hoyhoy mdsaac̈hpøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Wiinduhm̱yhagajpt jamiøød hajxy nax̱y mhøxtaꞌay pøṉ jaduhṉ xmiøødtúnäp maa jaꞌa mguhdujthajxiän. Y coo hajxy hänajty tøø mbaady, mänitä haxøøgcuhdujt hajxy myajnähixøꞌøy. Maas haxøøg hajxy jaduhṉ jiatcøꞌøwaꞌañ quejee mijts. ");
INSERT INTO mirNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Cab hajxy hoy mnäꞌägä yajnähixøꞌøy. Jaduhṉ hajxy mmänaꞌañ; coo hajxy hänajty tii myajwiinwaaṉøꞌøwaꞌañ, coo jaꞌa tsajtøjc mgapxpáadät, cab tyijy jaduhṉ ñejpiä coo hajxy mgaꞌa cudiúnät neby hajxy hänajty tøø myajwiinwaaṉøꞌøyän. Pero jaduhṉ hajxy mmänaam̱bä, coo jaꞌa oro hajxy mgapxpáadät, jaꞌa jiiby tsajtøgootypä, tsipcøxp hajxy tyijy mgudiúnät. ");
INSERT INTO mirNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mguhmäñøøby hajxy jaduhṉ; cab hajxy tii mwiinjuøꞌøy. Haa caꞌa, maas tsoobaatp jaꞌa tsajtøjc quejee jaꞌa oro. Hix̱, Dios jaꞌa tsajtøjc jaduhṉ cunuuꞌx. Jaꞌa oro, ñäꞌä yajmägunuuꞌxøøyy jeꞌeduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jaanä jaduhṉ hajxy mmänaam̱bä, coo mgapxpáadät jaꞌa cuyoxøhñdy, cábäc tyijy jaduhṉ ñejpiä coo mgaꞌa cudiúnät. Pero jaduhṉ hajxy mmänaam̱bä, coo hajxy mgapxpáadät tijaty tøø mguyoxøꞌøy, tsipcǿxpäc tyijy jaduhṉ mgudiúnät. ");
INSERT INTO mirNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nej, cab hajxy mnajuøꞌøyä coo jaꞌa cuyoxøhñdy miaas tsoobaady quejee tijaty hajxy mguyoxøøby. ");
INSERT INTO mirNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pøṉ jaduhṉ capxpaatp jaꞌa cuyoxøhñdy, jaanä jaduhṉ quiapxpaatpä tijatycøxpä jaꞌa jäyaꞌayhajxy jiiby tøø quiuyoxøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pøṉ jaduhṉ capxpaatp jaꞌa tsajtøjcøxpa, jaanä Dios quiapxpaatpä, jaꞌa jiiby tsänaabiä tsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pøṉ jaduhṉ capxpaatp jaꞌa tsajpootyp, jaanä Dios yhäñaabiejt quiapxpaatpä, møødä Dios jaꞌa jim̱ häñaabiä. ");
INSERT INTO mirNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Mijts myajcopcøøby mädyii caꞌa tsoobaatp coo hajxy hänajty tii mguyoxøꞌøwaꞌañ maa jaꞌa tsajtøjcän. Pero cabä Diosmädiaꞌagy hajxy myajcopcøꞌøy coo jaduhṉ miänaꞌañ coo mhojiäyaꞌayhádät, coo hojioot mmøødhádät, coo jaꞌa Diosmädiaꞌagy mmäbǿgät. Maas hoy jaduhṉ coo hajxy mgudiúnät caꞌxy pedyii. ");
INSERT INTO mirNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jaduhṉ mäwíinäts hajxy myajwiinhixøꞌøy nebiä wiindspän; cab hajxy myajcopcøꞌøy mädyii tsoobaatp. ");
INSERT INTO mirNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","28","’Jaduhṉ mijts mja wiꞌi quiähxøꞌøgaꞌañ nebiä hoyhänaꞌcän maa jaꞌa cuꞌugwiinduumän. Pero haxøøgwiinmahñdy hajxy mmøød. Tsipcøxp jaꞌa mhaxøøgwiinmahñdy hajxy mnajtshixǿꞌøwät, jaduhṉ hajxy tøyhajt hoy mhídät. ");
INSERT INTO mirNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Nax̱y hajxy yajxóṉ mguhmuuc̈h maa jaꞌa Diosquex̱ypähajxy jecy ñaax̱tägøøyyän. Hojiäyaꞌayhajxy hijty. ");
INSERT INTO mirNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mänit hajxy mmänaꞌañ: “Coo højts häxøpy jecy tøø njugyhájtäm, cabä nhap ndeedy hajxy häxøpy tøø nbuhbéjtäm coo jaꞌa Diosquex̱ypä hajxy yaghoꞌcy.” ");
INSERT INTO mirNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Cab jaduhṉ tiøyyä. Tøø jaꞌa mhap mdeedy hajxy häxøpy mbajatcøøbiä; ");
INSERT INTO mirNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","y jaduhṉ hajxy mjaanc̈h pajatcøꞌøwaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Jaduhṉ mäwíinäts hajxy mgaꞌawiindøyyä nebiä tsahṉ̃diän. Hoyhoy hajxy jaduhṉ jiiby mdsaac̈hpøgaꞌañ møjcuꞌuhaam. ");
INSERT INTO mirNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nguexáam̱biøch jaꞌa Diosquex̱ypä maa mijtsän, møødä cuhwijypiä, møødä yajnähixøøbiä. Näjeꞌe hajxy myaghoꞌogaꞌañ; näjeꞌe hajxy mmøjpahbedaꞌañ cruzcøxp; näjeꞌe hajxy mwobhoꞌogaꞌañ tsajtøgooty. Näjeꞌe hajxy mbäboꞌowaꞌañ cajpt‑cajpt. ");
INSERT INTO mirNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mijts jaduhṉ mmøødhadaam̱by jaꞌa pojpä coo jaꞌa hojiäyaꞌayhajxy nägøx̱iä yaghoꞌcä møødä Abel møødä Zacarías, jaꞌa Berequías yhuung. Tsajtøgooty jaꞌa Zacarías yaghoꞌcä; jaꞌa mhap jaꞌa mdeedyhajxy jaduhṉ jecy jatcøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tehm̱ tiøyhajt jaduhṉ, mijts jaꞌa pojpä mmøødhadaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Mijts Jerusalénpäjäyaꞌay, tøø jaꞌa Diosquex̱ypä hajxy mguhgaꞌac̈h. Jaduhṉ mäwíinhøch mijts mayhooc tøø nja näwaꞌañ nebiä tseey jaꞌa yhuung ñähmuhx̱tägoyyän; pero caj mijts myajnäwaꞌanaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mobädájpøch mijts nnähgueꞌegaꞌañ, ");
INSERT INTO mirNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","y cábøch jaduhṉ xyhixaaṉnä høxtä cóonøch hänajty ngädaactägatsaꞌañ. Mänit hajxy mmänaꞌanaꞌañ: “Tsøc yøꞌøyaꞌay wiingudsähgǿøyyäm, yøꞌøyaꞌay Diosquex̱ypä.” ");
INSERT INTO mirNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Mänitä Jesúshajxy piädsøøm̱y tsajtøgooty. Mänitä Jesús ñämaayyä jaꞌa miäguꞌughajpähajxy: ―Huug hix̱ yøꞌø møj tsajtøjc. ");
INSERT INTO mirNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mänitä Jesús yhadsooyy: ―Tehm̱ tiøyhájthøch mijts nnämaꞌay, yøꞌø møj tsajtøjcä, cøxaam̱b jaduhṉ piumaꞌañ; cøxaam̱b jaduhṉ quiuhdägoyyaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mänit hajxy ñøcxy maa jaꞌa Olivostuṉän. Mänitä Jesús yhøxtaacy naax̱wiin. Mänitä Jesús hameeꞌch ñämaayyä jaꞌa miäguꞌughajpähajxy: ―Højts hawáaṉäc mänaa yøꞌø tsajtøjc jaduhṉ piumaꞌañ. Mädyii hijxtahṉd jaduhṉ cähxøꞌøgaam̱b coo hänajty mgädaactägatsaꞌañ, coo jaꞌa naax̱wiimbä hänajty wyiimbidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mänitä Jesús miänaaṉ̃: ―Caꞌa hajxy myajwiinhøøñ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Minaam̱b hajxy nämay. Jaduhṉ hajxy ñibiädaꞌagaꞌañii nébiøch høøc̈hän. Jaduhṉ hajxy miänaꞌanaꞌañ: “Høøc̈h jeꞌe Cristo.” Nämayyä jäyaꞌay yajwiinhøønaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mänit hajxy mmädoyhadaꞌañ coo jaꞌa tsip jaduhṉ tøø piädøꞌøgy. Pero cab hajxy mdsähgǿꞌøwät. Tsipcøxpä häyohn jaduhṉ jiadaꞌañii. Pero cajnä hänajty yhabaady coo jaꞌa naax̱wiimbä hänajty wyiimbidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cajpthaam hajxy jaduhṉ ñimiädsibøꞌøwaꞌañii. Naxaam̱bä yuubaꞌam wiinduhm̱yhagajpt møødä hujx. ");
INSERT INTO mirNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero näꞌä tsohṉdaacnä jaꞌa tsøꞌty hänajty jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Mänit mijts myaghäyoow̱hixaꞌañ myajyaghoꞌogaꞌañ. Mänit mijts myajmähaṉhadaꞌañ maa jaꞌa høøc̈hcøxpän wiinduhm̱yhagajpt. ");
INSERT INTO mirNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mänitä Dios hajxy ñajtshixøꞌøwaꞌañ nämay. Mänit hajxy ñimiähaṉhadaꞌañii hamiṉ̃ haxøpy møødä hajxy tijaty yajniñähdsømaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wäditaam̱bä høhṉdaacpähajxy hänajty may. Mänaꞌanaam̱b hajxy hänajty cooc tyijy hajxy wiädity jaꞌa Dioscøxpä. Nämayyä cuꞌughajxy yajwiinhøønaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cab hajxy ñimiäguꞌughadáaṉänä jeꞌeguiøxpä coo jaꞌa haxøøgpä hänajty jiaanc̈h tehm̱ wiädity. ");
INSERT INTO mirNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero pønjaty jaduhṉ caꞌa jøjwaꞌadsaam̱b, jeꞌeds jaꞌa hoybä paadaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wiinduhm̱yhagajpt jaꞌa mädiaꞌagy wiäditaꞌañ mädyii jaduhṉ mänaam̱b coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. Cøxaam̱bä cuꞌughajxy miädoyhadaꞌañ; mänítäts jaꞌa naax̱wiimbä wyiimbidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’(Pøṉ hädaa nocy capxp, ween jaduhṉ wyiinjuøꞌøy.) Jaꞌa Daniel, Dios jaduhṉ jecy quejx. Jeꞌeduhṉ cujahy coo jaꞌa haxøøgpä miedsaꞌañ maa jaꞌa Diostøjcän, y coo mänit jaduhṉ yajmaꞌadaꞌañ. Coo jaꞌa haxøøgpä hajxy mhíxät, ");
INSERT INTO mirNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","mänit hajxy päyøꞌøguiä mnǿcxät maa jaꞌa tuṉän, mijts yaa tsänaabiä Judeanaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Y jaꞌa hajxy hijpä tøjwiing, jaduhyyä hajxy piäyøꞌtǿwät, cab hajxy jaduhṉ tii yajpädsǿm̱ät tøgooty. ");
INSERT INTO mirNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Y jaꞌa hajxy jim̱ hijpä camjooty, jaduhyyä hajxy piäyøꞌtǿøbät, cab hajxy jaduhṉ nøcxy tii wyich maa jaꞌa tiøjcän. ");
INSERT INTO mirNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pobre jaꞌa toꞌoxiøjc‑hajxy hänajty maaxhuungmøødpä, møød hajxy hänajty huungyajtsiꞌtspä. ");
INSERT INTO mirNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mmänuuꞌxtáꞌagäp jaꞌa Dios hajxy coo hajxy ween mgaꞌa päyøꞌøgy coo hänajty tiøøchcä, ni jaꞌa pooꞌxxiøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porque jaanc̈h tehm̱ miøc jaꞌa tsaac̈hpä ñaxaꞌañ. Ni mänaa jaduhṉ tøø quiaꞌa jadyii nebiä jaduhṉ jiadaꞌañiijän. Y caj mänaa jiajtägatsaꞌañii jadähoocän. ");
INSERT INTO mirNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pero Dios jaduhṉ tøø yajnähdijy coo jaꞌa tsaac̈hpä jejcy quiaꞌa jadǿøjät, jeꞌeguiøxpä coo chocy jaꞌa tøøbä wyiimbíyyäbä. Coo häxøpy jaduhṉ tøø quiaꞌa yajnähdijy, caj pøṉ häxøpy choꞌogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Coo mijts pøṉ xñämáꞌawät: “Huug hix̱, chaadsä Cristo”, o “Huug hix̱, xiids jeꞌe”, cab hajxy mmäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Hix̱, minaam̱bä wiinhøhm̱bähajxy; jaduhṉ mäwiin hajxy ñibiädaꞌagaꞌañii nebiä Criston; jaduhṉ mäwíinäts hajxy ñibiädaꞌagaꞌañii nebiä Diosquex̱ypän. Yajcähxøꞌøgaam̱by hajxy jaꞌa hoy‑yagjuøøñäjatypä nebiä cuꞌug hajxy jaduhṉ wyiinhǿønät; høxtä ja wiinhøønáaṉäp hajxy jeꞌebä, jaꞌa Dios tøø wyiimbíyyäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Chaads mijts nnämaꞌay jäguem̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Coo pøṉ xñämáꞌawät: “Huug hix̱, jim̱ wiädity pactuum”, cab hajxy jim̱ mnǿcxät; o coo hajxy xñämáꞌawät: “Huug hix̱, jiiby jeꞌe yuꞌuc̈htiuum”, cab hajxy mmäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Cooc̈h hänajty nwiimbidaꞌañ, høøc̈h jaꞌa Diosquex̱ypä, jaduhṉ mäwiin quiähxøꞌøgaꞌañ nebiä wädsucän. Wiinduhm̱yhagájpthøch jaꞌa jäyaꞌayhajxy xyhixaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tsipcøxp jaduhṉ jiadaꞌañii nébiøch chaa nmänaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Coo jaꞌa tsaac̈hpä hänajty tøø ñajxnä, mänitiä hänajty wyiingoodsøꞌøwaꞌañ; cabä poꞌo hänajty yhanaꞌañ. Chaadsä madsaꞌa may quiaꞌawaꞌañ; chaadsä tsajt chäyuyyaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mänítøch jaꞌa nhijxtahṉd jim̱ quiähxøꞌøgaꞌañ tsajpootyp cooc̈h hänajty nwiimbidaꞌañ, høøc̈h jaꞌa Diosquex̱ypä. Mänitä jäyaꞌayhajxy wiinduhm̱yhagajpt jiøꞌøwaꞌañ xiuudsaꞌañ. Mänítøch hajxy xyhixaꞌañ cooc̈h hänajty ngädaꞌagaꞌañ jocjooty. Diosmäjaaháamhøch jaduhṉ ngädaꞌagaꞌañ hajájjäp. ");
INSERT INTO mirNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mänítøch jaꞌa nmoonsä tsajpootypä nhaneꞌemaꞌañ coo ween hajxy møc xiuꞌuxy xuux̱thaam. Mänítøch jaꞌa nwiimbiybähajxy xyajtuꞌugmugaaṉä wiinduhm̱yhagajptpä. ");
INSERT INTO mirNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Tsøg jaꞌa tsøꞌty jaduhṉ yajmäbáatäm nebiä piidsquepiän. Coo yhaabiädsøm̱y, mänit hajxy mnajuøꞌøy coo pioodtägøøñä. ");
INSERT INTO mirNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jaduhṉ mäwíinäts jeꞌe, coo jaꞌa tsøꞌty hajxy jaduhṉ mhíxät, mänit hajxy mnajuǿꞌøwät cooc̈h hänajty mobädajpä nwiimbidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tøyhájtäts mijts nnämaꞌay, cooc̈h hänajty nwiimbidaꞌañ, cajnä jäyaꞌayhajxy hänajty quiøx̱y hoꞌogy, jaꞌa hajxy jädaꞌahaty jugyhajpä. ");
INSERT INTO mirNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jaꞌa tsajtwiing jaduhṉ tägoyyaam̱b møødä naax̱wiimbä. Tøjiadaam̱b jaduhṉ nébiøch cham̱ nmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Pero ni pøṉ jaduhṉ quiaꞌa najuøꞌøy mänaaxøø jiadaꞌañii ni mäduhnajtä. Ni jaꞌa Diosmoonsä tsajpootypä hajxy quiaꞌa najuøꞌøy. Ni høøc̈h ngaꞌa najuøꞌøy, høøc̈h jaꞌa Dioshuung. Jagooyyä Dios jaduhṉ ñajuøꞌøy, jaꞌa nDeedyhájtäm. ");
INSERT INTO mirNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Cooc̈h jaduhṉ nwiimbidaꞌañ, høøc̈h jaꞌa Diosquex̱ypä, jaduhṉ mäwíinäts hänajty jiadaꞌañii nebiä Noé jecy jiajtiän. ");
INSERT INTO mirNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Cajnä Dios jaꞌa nøøgom̱dägoy hänajty quiex̱yñä. Jim̱ä jäyaꞌayhajxy hänajty quiay yhuꞌugy, piøcy yhuꞌugy, høxtä coo jaꞌa Noé hänajty tøø tiägøꞌøy barcojooty. ");
INSERT INTO mirNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ni mänit hajxy hänajty quiaꞌa najuøꞌøyñä høxtä coonä jaꞌa nøøgom̱dägoy miejch. Mänit hajxy cøjx chøm̱duꞌubøgyii. Jaduhṉ mäwíinäts jiadáaṉäbä cooc̈h hänajty nwiimbidaꞌañ, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mänitxøø jaꞌa yaꞌadiøjc‑hajxy hänajty nämetsc yhidaꞌañ camjooty. Tuꞌug hänajty yajnøcxaꞌañii; tuꞌug hänajty yajmähmøꞌøwaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Metscä toꞌoxiøjc‑hajxy hänajty jiøch. Tuꞌug hänajty yajnøcxaꞌañii; tuꞌug hänajty yajmähmøꞌøwaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Nähix̱ hahixøꞌø hajxy mhídät; cab hajxy mnajuøꞌøy mänaa jaꞌa mWiindsøṉhajxy quiädaꞌagaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jaduhṉ mäwíinäts jaꞌa cudøjc‑hajxy, coo hajxy jaduhṉ ñajuǿꞌøwät mäduhnajtä jaꞌa meeꞌtspä miedsaꞌañ coods, jujcy hajxy jaduhṉ yhídät, y cabä meeꞌtspä hajxy jaduhṉ yajtøjtägǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jaduhṉ mäwíinäts mijtspä, nähix̱ hahixøꞌø hajxy mhídät. Cábøch mijts xñäꞌägä najuǿꞌøwät mänáajøch jaduhṉ ngädaꞌagaꞌañ, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Jaꞌa moonsäwiindsǿṉ, jeꞌedsä miämoonsä yajcaaby maa jaꞌa wyiindsǿṉ tiøjcän. Hoy jaduhṉ coo jaꞌa wyiindsǿṉ miädiaꞌagy miäbǿjcät, coo cuhwijy tiúnät. ");
INSERT INTO mirNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Coo jaꞌa wyiindsǿṉ miédsät, jootcujc jaꞌa moonsä ñijiäwøꞌøwaꞌañii mädyii jaduhṉ cudiuum̱b. ");
INSERT INTO mirNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tøyhájtäts mijts nnämaꞌay, jaduhṉä moonsä piädaꞌagaꞌañii nebiä wyiindsøṉän jim̱ maa jaꞌa wyiindsǿṉ tiøjcän, mäduhṉ̃tiä jaꞌa wyiindsǿṉ hänajty miøødä. ");
INSERT INTO mirNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero jaꞌa moonsä caꞌa hoybä, jeꞌeds jaduhṉ mänaꞌanaam̱b cooc tyijy jaꞌa wyiindsǿṉ quiaꞌa tsoj medsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mänitä miämoonsä tiägøꞌøwaꞌañ häyoow̱hijxpä. Mänitä muꞌugyjiäyaꞌay miøødtägøꞌøwaꞌañ caabiä huucpä. ");
INSERT INTO mirNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Cabä wyiindsǿṉ jaduhṉ yhuuc jahmiedsaaṉnä coo wyiimbidaꞌañ. Coo jaꞌa wyiindsǿṉ jaduhṉ jiaanc̈h médsät, ");
INSERT INTO mirNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","mänítäts jaꞌa craa hoyhoy quiumädow̱aꞌañ møødä miägaꞌawiindøybä. Mänit hajxy jiøꞌøwaꞌañ xiuudsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Coo jaꞌa Dios jaꞌa miäjaa jaduhṉ yajcähxøꞌøgaꞌañ, jaduhṉ mäwíinäts jeꞌe nebiä pøc huꞌug tøø jiadyiijän. Jim̱ä cäxyiidøjc jaꞌa jamiøꞌød hajxy hänajty yhahix̱y. Nämajc hajxy hänajty. Candilcóṉ hajxy hänajty yhahix̱y. ");
INSERT INTO mirNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Nämägoox̱c‑hajxy, cab hajxy hänajty nähix̱ hahixøꞌø tøø tiuꞌubøcy. Cabä guiaastä hajxy hänajty näꞌä tägøꞌøbä tøø jiuy. Pero jaꞌa jiamiøødhajxy jaꞌa jaac nämägoox̱pä, nähix̱ hahixøꞌø hajxy hänajty tøø tiuꞌubøcy mäbøjpä. Näꞌä tägøꞌøbä jaꞌa guiaastä hajxy hänajty tøø jiuy. ");
INSERT INTO mirNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Coo jaꞌa jamiøꞌød jaduhṉ quiaꞌa tsoj mejch, mänitä cäxyiidøjc‑hajxy cøjx miaahoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Coo quiuptsuhm̱däjøøyy, mänitä jäyaꞌay tuꞌug yaax̱y: “Xiidsä jamiøꞌød miech; nøcx hajxy jøjcubaadøꞌøw.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mänitä cäxyiidøjc‑hajxy cøjx piädøꞌøgy. Mänitä quiandilhajxy quiuhdøøꞌxøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mänit hajxy miänaaṉ̃, jaꞌa hajxy hänajty nähix̱ hahixøꞌø tøø quiaꞌa tuꞌubǿquiäbä: “Højtsä gaastä weeṉ̃tiä móoyyäc; piꞌidsaam̱b højtsä ngandil jaduhṉ.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mänit hajxy yhadsooyy, jaꞌa hajxy hänajty nähix̱ hahixøꞌø tøø tiuꞌubǿquiäbä: “Caj, ni jaduhṉ quiaꞌa mädøyhadaꞌañ maa jaꞌa højtscøxpän. Nøcx hajxy jaduhṉ ñijiúuyyäxä maa tioogyiijän.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mänit hajxy ñøcxy juubiä. Mänitä jamiøꞌød jaduhṉ miejch. Jaꞌa cäxyiidøjc‑hajxy gaastämøødpä, mänitä jamiøꞌød hajxy miøødtägøøyy tøgooty. Mänitä tøjc hajxy yhagøøñä. ");
INSERT INTO mirNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mänitä cäxyiidøjc‑hajxy jia mejtsnä, jaꞌa gaastä hajxy hoy tøø jiúyyäbä. Mänitä hajxy jia cugapxøøyy: “Wiindsǿṉ, huuc yaghawaꞌads hädaa tøjc.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mänit hajxy ñämaayyä: “Cábøch mijts jaduhṉ nhix̱iä. Tøyhajt jaduhṉ.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Coo jaꞌa Jesús jaduhṉ miädiaacpädøøyy, mänit miänaaṉ̃: ―Jaduhṉ hajxy mnibiädaꞌagǿøjät nähix̱ hahixøꞌø. Caj mijts mnajuøꞌøy mänáajøch nwiimbidaꞌañ, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Coo jaꞌa Dios jaꞌa miäjaa jaduhṉ yajcähxøꞌøgaꞌañ, jaduhṉ mäwíinäts jeꞌe nebiä jäyaꞌay tuꞌugpän. Nøcxaam̱b hänajty jeꞌe wiingnaaxooty. Mänitä mioonsähajxy miøjyaax̱y. Mänitä xiädøꞌøñ yajmämähmøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Tuꞌug jaduhṉ yajmämähmøøyyä mägoox̱millón. Paady may miooyyä coo hänajty jiaty xädøꞌøñyajmayøꞌøw. Tuꞌug jaduhṉ yajmämähmøøyyä mejtsmillón. Tuꞌug jaduhṉ yajmämähmøøyyä tuꞌmillón. Mänitä wiindsǿṉ tiuꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jaayaꞌay jaꞌa mägoox̱millón wiingpǿjcäbä, yajtägøøyy jaduhṉ niyhajájtäbä. Yajmayøøyy jaꞌa xädøꞌøñ jaduhṉ; mägoox̱millón jaduhṉ jiaac paaty. ");
INSERT INTO mirNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jaanä jaduhṉduhm̱bä, jaayaꞌay jaꞌa mejtsmillón wiingpǿjcäbä, mejtsmillón jaduhṉ jiaac paaty. ");
INSERT INTO mirNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero jaayaꞌay jaꞌa tuꞌmillón wiingpǿjcäbä, hoy jaꞌa jut jaduhṉ tiajy. Mänitä wyiindsǿṉ xiädøꞌøñ hoy yúꞌtsänä jutjooty. ");
INSERT INTO mirNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Cujecy jaꞌa wyiindsøṉhajxy miejtstägajch. Mänit hajxy tiägøøyy cueentäyajpädsøøm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jayøjp jaayaꞌay miejch jaꞌa mägoox̱millón hänajty tøø wyiingpǿquiäbä. Mänitä wyiindsǿṉ miooyy cøx̱iä møødä mägoox̱millón tøø jiaac páadiäbä. Mänit miänaaṉ̃: “Wiindsǿṉ, mägoox̱millónhøch jaduhṉ xmiooyy; chaads jeꞌe møødä mägoox̱millónhøch tøø njaac yajmayǿꞌøyäbä.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mänitä wyiindsǿṉ miänaaṉ̃: “Hoy miic̈h jaduhṉ tøø mgudiuṉ̃. Wéeṉ̃tiøch miic̈h nyajmämähmøøyy. Maas máyhøch miic̈h jaꞌa xädøꞌøñ jaduhṉ njaac moꞌowaꞌañ neby jaduhṉ mjaac yajmayǿꞌøwät. Tøjtägøꞌøw tøgooty, ween nxooṉdáacäm.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mänitä craa jiaac mejch jaꞌa mejtsmillón hänajty tøø wyiingpǿquiäbä. Mänit miänaaṉ̃: “Wiindsǿṉ, mejtsmillónhøch jaduhṉ xmiooyy; chaads jeꞌe møødä mejtsmillónhøch tøø njaac yajmayǿꞌøyäbä.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mänitä wyiindsǿṉ miänáaṉgumbä: “Hoy miic̈h jaduhṉ tøø mgudiuṉ̃. Wéeṉ̃tiøch miic̈h jaduhṉ nyajmämähmøøyy. Maas máyhøch miic̈h jaꞌa xädøꞌøñ jaduhṉ njaac moꞌowaꞌañ neby jaduhṉ mjaac yajmayǿꞌøwät. Tøjtägøꞌøw tøgooty, ween nxooṉdáacäm.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mänitä craa jiaac tehm̱ miejch jaꞌa tuꞌmillón hänajty tøø wyiingpǿquiäbä. Mänit miänaaṉ̃: “Wiindsǿṉ, nnajuǿøbiøch coo miic̈h hojioot mgaꞌa møødä. Miic̈h jaꞌa xädøꞌøñ jaduhṉ mbaadaam̱by maa tøø mgaꞌa tuṉ̃än. ");
INSERT INTO mirNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Páadyhøch hijty ndsähgøꞌøy. Páadyhøch jaꞌa xädøꞌøñ hoy nyuꞌuc̈h naaxjutjooty. Huug hix̱, chaads jeꞌe.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mänitä wyiindsǿṉ yhadsooyy: “Caj miic̈h hoy mgudiuṉ̃. Mjaanc̈h tehm̱ ñuux miic̈h. Mnajuøøby miic̈h jaduhṉ cooc̈h hojioot ngaꞌa møødä, cooc̈hä xädøꞌøñ nbaadaꞌañ maac̈h tøø ngaꞌa tuṉ̃än. ");
INSERT INTO mirNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Páadyhøch nxädøꞌøñ jaduhṉ cu xpiädaacä bancojooty. Jiiby cu miayøøyy. Mänítøch nxädøꞌøñ cu xmiooyy møødä xädøꞌøñhuung.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mänitä hajxy ñämaayyä, jaꞌa hajxy jim̱ tänaabiä: “Pøjcä yøꞌø craa xädøꞌøñ hajxy tuꞌmillón; moꞌow yøꞌø craa hajxy jaꞌa majcmillónmøødpä. ");
INSERT INTO mirNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pøṉ may näꞌägä møød, maas may jaduhṉ mioꞌowaꞌañii. Hanax̱iä jaduhṉ miøødhadaꞌañ. Pero pøṉ jaduhṉ weeṉ̃tiä møød, pøgáaṉäxäp jeꞌe mäduhṉ̃tiä miøødä. ");
INSERT INTO mirNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yøꞌø craa jaanc̈h tehm̱ ñuuxpä, høxwijtspädsøm̱ hajxy hagoodstuum. Jiiby jaduhṉ jiøꞌøwaꞌañ xiuudsaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Cooc̈h jaduhṉ ngädáꞌagät hanehm̱bä, høøc̈h jaꞌa Diosquex̱ypä, jím̱høch jaduhṉ nhäñaꞌawaꞌañ maa jaꞌa hoyhäñaabiejtän jaꞌa yajxoṉbä. Quípxyhøch nmoonsä tsajpootypähajxy xmiøødcädaꞌagaꞌañ nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mänítøch jaꞌa jäyaꞌayhajxy xwyiingumedsøꞌøwaꞌañ jaꞌa wiinduhm̱yhagajptpä. Mänítøch hajxy jaduhṉ nyajwaꞌxaꞌañ nebiä meegän nebiä chiibän. ");
INSERT INTO mirNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nbädaꞌagáam̱biøch näjeꞌe maac̈h nhahooguiøꞌøjän, näjeꞌe maac̈h nhanajtycøꞌøjän. ");
INSERT INTO mirNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jaꞌa hajxy hijpä hahooguiøꞌø, mänítøch hajxy nnämaꞌawaꞌañ: “Miṉ hajxy yam̱; tøøc̈h mijts nDeedy xwyiimbiy coo hajxy mhanéꞌemät. Jequiän hajxy jaduhṉ xwyiimbiiyy, cajnä jaꞌa naax̱wiin hänajty yhädiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mänáajøch hijty nyähoꞌogyiijän, mänítøch hajxy xyajcaayy. Mänáajøch hijty ndødsøꞌøyiijän, mänítøch hajxy xyajnøøhuucy. Mänáajøch hijty nwäditiän nebiä jäguem̱bäyaꞌayän, mänítøch hajxy xyaghamejtstaacy. ");
INSERT INTO mirNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mänáajøch wit hijty ngaꞌa møødän, mänítøch hajxy xñähxojxy. Mänáajøch hijty mbaꞌamgoꞌnaꞌayän, ndsum̱yhäñaꞌayän, mänítøch hajxy hoy xquiuhix̱y.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jaꞌa hajxy hijpä hahooguiøꞌø, mänit hajxy yhadsowaꞌañ: “Wiindsǿṉ, mänaa højts miic̈h tøø nyajcay; mänaa højts miic̈h tøø nyajnøøhuꞌugy; ");
INSERT INTO mirNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","mänaa højts miic̈h tøø nyaghamejtstaꞌagy; mänaa højts miic̈h tøø nnähxox̱y; ");
INSERT INTO mirNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","mänaa højts miic̈h hoy tøø nguhix̱y.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mänítøch nhadsowaꞌañ: “Tøyhajt mijts nnämaꞌay, cooc̈h mijts jaꞌa njamiøødhajxy tøø xñäxuuꞌtsä, hoy hajxy quiaꞌa ja møjtøjcä, jaduhṉ mäwíinhøch tøø xñäxuuꞌtspä.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Mänítøch hajxy nnämaꞌawaꞌañ jaꞌa hajxy hanajtycøꞌøbä: “Juaꞌads hajxy jim̱, mijts haxøøgtuum hijpä. Hädaꞌag hajxy jiiby maa jaꞌa jøøn mänaa quiaꞌa piꞌic̈hän. Paadiä jøøn tøø piädaꞌagyii, jiibiä møjcuꞌuhajxy chaac̈hpøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mänáajøch hijty nyähoꞌogyiijän, cábøch hajxy xyajcaayy; mänáajøch hijty ndødsøꞌøyiijän, cábøch hajxy xyajnøøhuucy; ");
INSERT INTO mirNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mänáajøch hijty nwäditiän nebiä jäguem̱bäyaꞌayän, cábøch hajxy xyaghamejtstaacy; mänáajøch wit hijty ngaꞌa møødän, cábøch wit hajxy xmiooyy; mänáajøch hijty nbaꞌamgoꞌnaꞌayän, ndsum̱yhäñaꞌayän, cábøch hajxy hoy xquiuhix̱y.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mänit hajxy miänaꞌanaꞌañ: “Wiindsǿṉ, mänaa højts miic̈h ngaꞌa puhbejty; mänaa højts miic̈h nhijxy coo hänajty myähoꞌogyii, coo hänajty mdødsøꞌøyii, coo hänajty mwädity nebiä jäguem̱bäyaꞌayän, coo wit hänajty mgaꞌa møødä, coo hänajty mbaꞌamgoꞌnaꞌay, coo hänajty mdsum̱yhäñaꞌay.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mänítøch nhadsowaꞌañ: “Tøyhajt mijts nnämaꞌay, cooc̈h mijts jaꞌa njamiøødhajxy tøø xquiaꞌa näxuuꞌtsä, hoy hajxy quiaꞌa ja møjtøjcä, jaduhṉ mäwíinhøch tøø xquiaꞌa näxuuꞌtspä.” ");
INSERT INTO mirNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yøꞌøds hajxy jiiby hädaꞌagaam̱b maa hajxy chaac̈hpøgaꞌañän cøjxtaꞌaxiøø. Pero pønjátyhøch tøø nwiimbiy, jeꞌeds hajxy cøjxtaꞌaxiøø jugyhadaam̱b nebiä Dios jiugyhatian. ");
INSERT INTO mirNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Coo jaꞌa Jesús jaduhṉ miädiaacpädøøyy, mänit ñämaayy jaꞌa jiamiøødhajxy: ");
INSERT INTO mirNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Mnajuøøby hajxy jaduhṉ coo jaꞌa pascuaxøø cumaax̱c yhadsuujøꞌøwaꞌañ. Mänítøch hajxy xyajcøꞌødägøꞌøwaꞌañ, høøc̈h jaꞌa Diosquex̱ypä. Mänítøch hajxy xmiøjpahbedaꞌañ cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mänitä teedywiindsøṉhajxy yhamugøøyy møødä ley‑yajnähixøøbiähajxy møødä jäyaꞌayhajxy martuumähajpä maa jaꞌa judíoshajxiän. Jim̱ hajxy yhamugøøyy maa jaꞌa Caifás tiøjcän, jaꞌa hänajty møjcuhdujtmøødpä maa jaꞌa teedyhajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mänit hajxy quiojyquiapxyhajty nebiä Jesús hajxy miádsät, neby hajxy jaduhṉ yaghóꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mänit hajxy ñiñämaayyä: ―Cab jaduhṉ yhoyyä coo hajxy nmájtsämät jaꞌa xøøjooty coo jaꞌa cuꞌughajxy ñäꞌä haamhadät. ");
INSERT INTO mirNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jim̱ä Jesús hänajty maa jaꞌa cajpt jaduhṉ xiøhatiän Betania, maa jaꞌa Simón tiøgootiän, jaꞌa hänajty tøø ñähwaꞌac̈híijäbä jaꞌa haxøøgpaꞌam. ");
INSERT INTO mirNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jim̱ä Jesús hänajty quiay, mänitä toꞌoxiøjc tuꞌug miejch, perfumecóṉ, jaꞌa jaanc̈h tehm̱ chow̱bä. Mänitä Jesús jaꞌa perfume yajcuhdaꞌxøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Coo jaꞌa Jesús jiamiøødhajxy jaduhṉ yhijxy, cab hajxy jaduhṉ yhojiäwøøyy. Mänit hajxy miänaaṉ̃: ―Tii yøꞌø perfume jaduhṉ coo yaghäyooyy. ");
INSERT INTO mirNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Coo jaduhṉ cu tiooꞌcy, mänitä häyoobäyaꞌay jaduhṉ cu ñäꞌägä puhbejty. ");
INSERT INTO mirNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Coo jaꞌa Jesús jaduhṉ miädooyy, mänit miänaaṉ̃: ―Caꞌa yøꞌø toꞌoxiøjc hajxy mhadsipy. Caꞌa yhaxøøgpä jaduhṉ tøø tiuṉ̃ maa jaꞌa høøc̈hcøxpän. ");
INSERT INTO mirNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jaꞌa häyoobädøjc, homiänaajä mijts jaduhṉ xmiøødhidaꞌañ; pero høøc̈h, cábøch mijts jejcy nmøødhidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Páadyhøch yøꞌø toꞌoxiøjc perfume xyajcuhdaꞌxøøyy, cooc̈h mobädajpä nhoꞌogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tøyhájtäts mijts nnämaꞌay, homiaajä hädaa hoguiapxy hädaa homiädiaꞌagy hajxy yaghawaꞌxǿꞌøwät maa hädaa yaabä naax̱wiinän, mänit hajxy jaduhṉ miädiaꞌagaꞌañ nébiøch yøꞌø toꞌoxiøjc perfume tøø xyajcuhdaꞌxøꞌøy. Jaduhṉds yøꞌø toꞌoxiøjc jiahmiedsaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Jaꞌa Jesús jiamiøødhajxy jaꞌa nämajmetspä, tuꞌug hänajty xiøhaty Judas Iscariote. Mänitä Judas jaꞌa teedywiindsøṉhajxy hoy ñämaꞌay: ―Mädúhṉ̃tiøch hajxy xmiäjúyät cooc̈h jaꞌa Jesús hajxy nyajcøꞌødägǿꞌøwät. Mänitä Judas miooyyä hiiꞌxmajc plataxädøꞌøñ. ");
INSERT INTO mirNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mänit wyiinmahñdyhajty nebiä Jesús yajcøꞌødägǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jaꞌa tehm̱ xiøøhadsuujøꞌø hajxy hänajty quiuhdujthaty coo jaꞌa tsajcaagy hajxy hänajty quiay jaꞌa caꞌa tsoomiøødpä. Mänitä Jesús jaꞌa jiamiøød ñämejtsä. Mänit miäyajtøøw̱ä: ―Maa hajxy ndsuugáayyämät jaꞌa pascuaxøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mänitä Jesús yhadsooyy: ―Nøcx hajxy cajptooty maac̈h nmäguꞌughajpä tiøjcän. Mänit hajxy mnämáꞌawät: “Nøm̱ højts nWiindsǿṉ miänaꞌañ cooc tøø yhabáatäxä, y cooc højts yaa ndsuugayaꞌañ jaꞌa pascuaxøøjooty maa miic̈h mdøgootiän.” ");
INSERT INTO mirNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mänit hajxy jiaanc̈h cudiuuṉ̃ neby hajxy ñämaayyän. Mänitä jøøꞌxy hajxy yhädiuuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Coo quioodsøøyy, jim̱ä Jesúshajxy hänajty quiay møødä nämajmetspä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mänitä Jesús miänaaṉ̃ caaguiujc: ―Tøyhájtäts mijts nnämaꞌay cooc̈h mijts mjamiøød tuꞌjäyaꞌay xyajcøꞌødägøꞌøwaꞌañ maac̈h nmädsipän. ");
INSERT INTO mirNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mänit hajxy jiootmadiägøøyy. Mänit hajxy tiägøøyy yajtøøbä: ―Wiindsǿṉ, nej, høøc̈h jeꞌejä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mänitä Jesús yhadsooyy: ―Jaꞌac̈h tuꞌugtex̱y xmiøødcaamiujpä, jéꞌec̈häts jaduhṉ xyajcøꞌødägøꞌøwaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jadúhṉhøch njadaꞌañ nhabetaꞌañ, høøc̈h jaꞌa Diosquex̱ypä, nebiä Diosmädiaꞌagy jaduhṉ miänaꞌañän. Pero jaanc̈h tehm̱ chaac̈hpøgaam̱b jaayaꞌay häyoobä jaꞌac̈h tøø xyhawaaṉǿꞌøyäbä. Mejor häxøpy tøø quiaꞌa miṉ̃ tøø quiaꞌa caꞌay. ");
INSERT INTO mirNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mänitä Judas miänaaṉ̃, jaꞌa hänajty tøø yhawaaṉǿꞌøyäbä: ―Wiindsǿṉ, nej, høøc̈h jeꞌejä. Mänitä Jesús yhadsooyy: ―Miic̈h jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jim̱nä hajxy hänajty quiayñä, mänitä Jesús tsajcaagy quionøꞌcy. Mänitä Dioscujúꞌuyäp yejcy. Mänitä tsajcaagy qyijwaꞌxy. Mänitä jiamiøød miooyy. Mänit miänaaṉ̃: ―Cay hajxy; jaduhṉ mäwiin hädaa tsajcaagy nébiøc̈hä nniꞌx nébiøc̈hä ngopcän. ");
INSERT INTO mirNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mänitä Jesús taza quionøꞌcy. Mänitä Dioscujúꞌuyäp yéjcumbä. Mänitä jiamiøød jaꞌa taza miooyy. Mänitä Jesús miänaaṉ̃: ―Huꞌug hädaa vino hajxy nägøx̱iä. Mänitä vino hajxy yhuucmujcy tuꞌugtaza. ");
INSERT INTO mirNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mänitä Jesús miänáaṉgumbä: ―Jaduhṉ mäwiin hädaa vino nébiøc̈hä nnøꞌtiän. Hijxtahṉd jaduhṉ cooc̈hä jem̱yguiuhdujt nyajwiimbädsøm̱aꞌañ cooc̈hä jäyaꞌayhajxy may nnähhoꞌtuꞌudaꞌañ, cooc̈h jaduhṉ nyajnähwaꞌadsaaṉä jaꞌa piojpä quiädieey. ");
INSERT INTO mirNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pero nnämáabiøch mijts cooc̈h hädaa vino ngaꞌa huuctägatsaꞌañ høxtä cóonøch hänajty tøø nhoꞌogy. Mänítøch mijts jaduhṉ nmøødhuucmujtägatsaꞌañ jim̱ maac̈hä nDeedy jaduhṉ yhaneꞌemiän. ");
INSERT INTO mirNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mänitä Dioshøy hajxy yhøøyy. Mänit hajxy ñøcxy maa jaꞌa Olivostuṉän. ");
INSERT INTO mirNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mänitä Jesús miänaaṉ̃: ―Hädaa coods, cábøch mijts jaꞌa nmädiaꞌagy hajxy hoy xmiäbøgáaṉänä. Mänítøch hajxy jaduhṉ xñähgueꞌegaꞌañ. Jaduhṉä Diosmädiaꞌagy miänaꞌañ: “Nyaghoꞌogáam̱biøch jaꞌa meegcueendähajpä. Mänitä meeghajxy xii yaa ñøcxøꞌøwaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero cooc̈h hänajty tøø njujypiøcy, mänítøch nnøcxøꞌøgaꞌañ jim̱ Galilea; mänit mijts høx̱haam mnøcxaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mänitä Pedro miänaaṉ̃: ―Hoy miic̈h hajxy nägøx̱iä xjia nähguéꞌegät, cábøch miic̈h nnähguéꞌegät. ");
INSERT INTO mirNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mänitä Jesús miänaaṉ̃: ―Tøyhájthøch miic̈h nnämaꞌay, coo jaꞌa tseey hänajty quiaꞌa yaꞌaxyñä hädaa coods, tøø miic̈h hänajty tägøøghooc mnijiøgapxyii cóogøch tyijy jaduhṉ xquiaꞌa hix̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mänitä Pedro miänaaṉ̃: ―Hǿyhøch miic̈h näguipxy nja møødhóꞌogät, cábøch jaduhṉ nnijiøgapxǿøjät. Jaduhṉ hajxy nägøx̱iä piamänaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mänitä Jesúshajxy miejch maa hänajty xiøhatiän Getsemaní. Mänitä Jesús miänaaṉ̃: ―Yaa hajxy høxtaꞌag naax̱wiin; nǿcxyhøch jim̱haamby nhuuc Diospaꞌyaꞌaxy. ");
INSERT INTO mirNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mänitä Jesús jaꞌa Pedro wioonøcxy hawiing møødä Zebedeo yhuunghajxy nämetscä. Mänitä Jesús tiägøøyy jootmayhajpä hoyhoy. ");
INSERT INTO mirNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mänit miänaaṉ̃: ―Jaanc̈h tehm̱ jiootmayhájpøch jaduhṉ. Jadúhṉhøch nnijiäwøꞌøyii nebiä hoꞌogaam̱bän. Yaa hajxy mmähmǿꞌøwät. Tsøg hajxy jujcy híjtäm. ");
INSERT INTO mirNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mänitä Jesús weeṉ̃tiä jiaac nøcxy. Mänit miägutscädaacy. Mänit Dyiospaꞌyaax̱y: ―Teedy, miic̈h meeꞌx, caꞌa yhndijy jaduhṉ cu ndsaac̈hpøjcy. Pero caꞌa yhøøc̈hä nguhdujt jaduhṉ nyajtunaam̱by; miic̈hä mguhdujt nyajtunáaṉäm. ");
INSERT INTO mirNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mänitä Jesús wyiimbijty maa jaꞌa nädägøøgpä hänajty tøø ñähgueꞌeguiän. Jim̱ hajxy hänajty miaꞌay coo jaꞌa Jesús jim̱ miejch. Mänitä Pedro ñämaayyä: ―Nej, ni tuꞌhorä hajxy jujcy mgaꞌa hidaꞌañä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jujcy hajxy mhídät. MDiospaꞌyáꞌaxäp hajxy jaduhṉ nebiä møjcuꞌu hajxy jaduhṉ xquiaꞌa jøjcapxǿꞌøwät. Jia tsojpiä mjoothajxy jaduhṉ coo hajxy jujcy mhídät, pero jaꞌa mniꞌx jaꞌa mgopc‑hajxy jaduhṉ caꞌa meeꞌxtugaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jaꞌa miämetsc‑hoocpä Jesús ñøcxy Diospaꞌyaax̱pä: ―Teedy, miic̈h meeꞌx, cábøch ndijy jaduhṉ cu ndsaac̈hpøjcy. Pero ween miic̈hä mguhdujt nyajtúuṉäm. ");
INSERT INTO mirNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mänit wyiimbíjcumbä maa jaꞌa Pedrohajxiän. Tøø hajxy hänajty miaahóꞌcumbä. Jaanc̈h tehm̱ miaꞌawaam̱b hajxy hänajty hanax̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mänitä Jesús ñähguéeccumbä. Mänit ñǿcxcumbä miädägøøghoocpä Diospaꞌyaax̱pä. Mänit jaduhyyä miänáaṉgumbä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mänit miéjtscumbä maa jaꞌa Pedrohajxiän. Mänit miänaaṉ̃: ―Maꞌawxä hajxy, pooꞌxxä hajxy. Tøøds jeꞌe yhabaady cooc̈h hajxy xyajcøꞌødägøꞌøwaꞌañ maa jaꞌa cubojpä cugädieejiäyaꞌayän, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pädøꞌøg hajxy, jam̱ds hajxy. Xiids jeꞌe myiṉ̃ jaꞌa høøc̈h jaduhṉ xyegaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mädiaacnä jaꞌa Jesús hänajty coo jaꞌa Judas miejch, jaꞌa Jesús hänajty tøø miøødwädítiäbä jaꞌa miämajmetspä. Jaanc̈h tehm̱ miay jaꞌa jäyaꞌay hänajty miøødä, pujxtmøødpä, pax̱ycappä. Jaꞌa teedywiindsøṉhajxy jaduhṉ quejx møødä martuumädøjc. ");
INSERT INTO mirNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jaꞌa Judas jaꞌa Jesús hänajty yegaam̱b. Tøø jaꞌa Judas jaꞌa jäyaꞌay hänajty ñämaꞌay: ―Jaꞌa høøc̈h hänajty ndsuꞌxaam̱biä, jeꞌeds hajxy mmádsäp. ");
INSERT INTO mirNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mänitä Judas jaꞌa Jesús ñämejch. Mänitä yajpooꞌxy. Mänit chuꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mänitä Jesús miänaaṉ̃: ―Mäguꞌughajpä, tiic̈h xwiaꞌanaꞌañ. Mänitä Jesús hajxy miajch. ");
INSERT INTO mirNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mänitä Jesús jiamiøød jaꞌa piujxt jiuuꞌty. Mänitä teedywiindsǿṉ mioonsä tuꞌug tiaatspujxtúutäxä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mänitä Jesús miänaaṉ̃: ―Cuyuugøꞌøw yøꞌø mbujxt. Pønjaty jaduhṉ pädøꞌp pujxthaam, jaanä pujxthaam yhoꞌogaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nej, caj miic̈h mnajuøꞌøyä, cooc̈hä nDeedy jaduhṉ nnämáꞌawät cooc̈h ween xpiuhbety, mänítøch jaꞌa mioonsä tsajpootypä milhaam xyajnäguéxät. ");
INSERT INTO mirNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero cooc̈h jaduhṉ nnämáꞌawät, cabä Diosmädiaꞌagy jaduhṉ tiøjiádät maa jaduhṉ myiṉ̃än cujaay cooc̈h jaduhṉ tsipcøxp njadaꞌañ nhabetaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mänitä Jesús jaꞌa majiäyaꞌay ñämaayy: ―Pujxtmøød pax̱ycap hajxy tøø mbädøꞌøgy. Jadúhṉhøch hajxy tøø xmiach nebiä meeꞌtspän. Jabom̱‑jabóm̱høch mijts hijty nyajnähixøꞌøy tsajtøgooty, y cábøch hajxy mänaa tøø xmiach. ");
INSERT INTO mirNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero páadyhøch jaduhṉ njaty nhabety, jaduhṉä Diosmädiaꞌagy jaduhṉ tiøjiádät, nebiä Diosquex̱ypähajxy jecy quiujahyyän. Mänitä Jesús jiamiøødhajxy quiøx̱y päyøꞌcy. Nidiuhm̱ä Jesús jaduhṉ ñähgueecä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mänitä Jesús yajmejtsä maa jaꞌa Caifás tiøjcän, jaꞌa møjcuhdujtmøødpä maa jaꞌa teedyhajxiän. Jim̱ä ley‑yajnähixøøbiähajxy hänajty tøø yhamugøꞌøy møødä martuumädøjc‑hajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jaꞌa Pedro, jäguem̱juøøby hänajty pianøcxy. Mänit jiiby tiägøøyy maa jaꞌa Caifás tiøjwiingän. Mänitiä yhøxtaacy maa jaꞌa policíahajxiän. Yhixaam̱by hänajty jeꞌe nebiä Jesús hänajty tiunaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jaꞌa Jesús, tøø hänajty yajtøjtägøꞌøyii maa jaꞌa teedywiindsøṉhajxy hänajty tøø yhamugøꞌøyän møødä ley‑yajnähixøøbiähajxy møødä møjtøjc‑hajxy. Jiiby hajxy hänajty wyiinmahñdyhaty nebiä Jesús hajxy jaduhṉ ñähøønǿꞌøwät, hoy jaduhṉ quiaꞌa ja tøyyä, nebiä Jesús hajxy jaduhṉ yajyaghoꞌogǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero cabä tøyhajt hajxy piaaty, hoy jäyaꞌay may jia wiꞌi ñähøønøøyy. Mänitä høhṉdaacpä metsc piädsøøm̱y. ");
INSERT INTO mirNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Mänit hajxy miänaaṉ̃: ―Nøm̱ yøꞌø craa miänaaṉ̃ coogä Diostøjc jaduhṉ yajmaꞌadaꞌañ; mänítäc cumaax̱c wiingpä yajpädøꞌøgáaṉgumbä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mänitä teedywiindsǿṉ tiänaayyøꞌcy. Mänitä Jesús ñämaayyä: ―Nej, caj mhadsowaꞌañä. Tii hajxy jaduhṉ coo xñäxøꞌøwøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero cabä Jesús waam̱b ñäꞌä mänaaṉ̃. Mänitä teedywiindsǿṉ miänáaṉgumbä: ―Jaꞌa Dioscøxpä miic̈h jaꞌa tøyhajt myégät; højts hawáaṉäc pø tøyhajt jaduhṉ coo miic̈h jaꞌa Dios tøø xquiex̱y, coo jaꞌa Dios xyHuunghaty. ");
INSERT INTO mirNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mänitä Jesús miänaaṉ̃: ―Tøyhajt jaduhṉ nej miic̈h mmänaꞌañän. Jadúhṉhøch mijts nnämaabiä, høøc̈h jaꞌa Diosquex̱ypä, cooc̈h hajxy xyhixaꞌañ häñaꞌa maa jaꞌa Dios yhahooyhaampiän, jaꞌa mäjaamøødpä; y cooc̈h jaduhṉ nmänajtägatsaꞌañ jocjooty. ");
INSERT INTO mirNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mänitä teedywiindsǿṉ jaꞌa wyit quiøøꞌch. Paady quiøøꞌch coo hänajty yhawaꞌandaꞌagy. Mänit miänaaṉ̃: ―Tøø hädaa craa quiapxtägoy jaꞌa Dioscøxpä. Tii testigo hajxy njaac wáaṉämät. Hamdsoo hajxy tøø mmädoy nej tøø quiapxtägoyyän. ");
INSERT INTO mirNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Neby hajxy mmänaꞌañ. Mänit hajxy yhadsooyy: ―Tøø jaduhṉ quiapxtägoy jaꞌa Dioscøxpä; ween yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mänitä Jesús wyiingudsujøøyyä. Mänit wiojpä. Mänit wyiingugoxøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Mänit ñämaayyä: ―Pø tøyhajt jaduhṉ coo Dios tøø xquiex̱y, najuøꞌøw pøṉ tøø xquiox̱y. ");
INSERT INTO mirNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jim̱nä jaꞌa Pedro hänajty yhäñaꞌay tøjwiing. Mänitä Pedro ñämejtsä toꞌoxymoonsä tuꞌug. Mänit ñämaayyä: ―Miic̈h jaꞌa Jesús hijty mmøødwädijpy, túhm̱äts, jaꞌa Galileatsohm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mänitä Pedro ñijiøgapxä maa jaꞌa jäyaꞌayhajxiän: ―Pätiidä jaduhṉ mnäꞌä mädiaacypy. ");
INSERT INTO mirNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tøjpädsøm̱áaṉnäp jaꞌa Pedro hänajty, mänit yhíjxägumbä jaꞌa toꞌoxymoonsä tuꞌug. Mänitä moonsä ñämaayy jaꞌa hajxy hänajty jim̱bä: ―Yøꞌø mix̱y jaꞌa Jesús hijty møødwädijp jaꞌa Nazarettsohm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jadähooc jaꞌa Pedro ñijiøgapxä: ―Tøyhajt, cábøch jaꞌa craa nhix̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mänitjuøøby jaꞌa Pedro ñämáayyägumbä, jaꞌa hajxy hänajty jim̱bä: ―Tøyhajt jaduhṉ coo miic̈h jaꞌa Jesús hijty mmøødwädity; jaduhṉ miic̈h mmädiaacpä nebiä Galileatsohm̱bän. ");
INSERT INTO mirNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mänitä Pedro miänaaṉ̃: ―Pø cábøch tøyhajt nmädiaꞌagy, wéenhøch jaꞌa Dios jaduhṉ xyajcumädoy. Cábøch jaꞌa craa nhix̱iä. Tuuṉä jaꞌa Pedro jaduhṉ ñäꞌä mänaaṉ̃, mänitiä tseey yaax̱y. ");
INSERT INTO mirNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mänitä Pedro quiøx̱y jahmiejch nebiaty jaꞌa Jesús hänajty tøø miänaꞌañän: “Cajnä jaꞌa tseey hänajty yaꞌaxy, tøø miic̈h hänajty tägøøghooc mnijiøgapxyii cóogøch tyijy xquiaꞌa hix̱iä.” Mänitä Pedro jim̱ chohṉ̃. Mänit tiägøøyy jøøbiä hoyhoy. ");
INSERT INTO mirNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Coo jiobøøyy, mänitä teedywiindsøṉhajxy quiojyquiapxytiuuṉ̃ møødä martuumädøjc‑hajxy nebiä Jesús hajxy yaghóꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mänitä Jesús hajxy cøꞌøxoch hoy yajcøꞌødägøꞌøy maa jaꞌa Poncio Pilatän, jaꞌa hänajty tuum̱bä gobernador. ");
INSERT INTO mirNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jaꞌa Judas jaꞌa Jesús hänajty tøø yhawaaṉøꞌøy. Coo jaꞌa Judas yhijxy coo jaꞌa Jesús hänajty yaghoꞌogaꞌañii, cabä jioot jaduhṉ ñäꞌä møc‑hajty. Mänitä hiiꞌxmajcpä plataxädøꞌøñ hoy yajwiimbity maa jaꞌa teedywiindsøṉhajxiän, maa jaꞌa martuumädøjc‑hajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mänit miänaaṉ̃: ―Tøøc̈h jaduhṉ ngädieey cooc̈hä craa hoꞌcøøc tøø nhawaaṉøꞌøy, jaꞌa cajpä pojpä cädieemiøødpä. Mänit hajxy yhadsooyy: ―Caꞌa yhøjts ngüeendä yøꞌøduhṉ. Miic̈h mgüeendä yøꞌøduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mänitä Judas jaꞌa xädøꞌøñ ñajtsxäbapøøyy jiiby tsajtøgooty. Mänit hoy ñiyoꞌtǿøyyänä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mänitä teedywiindsǿṉ jaꞌa xädøꞌøñ hajxy pyiwøꞌcy. Mänit hajxy miänaaṉ̃: ―Cab hädaa xädøꞌøñ hajxy hawiinmats nbädáacämät maa jaꞌa xädøꞌøñ hajxy quiuyoxøꞌøyän, jeꞌeguiøxpä coo jäyaꞌay jaduhṉ tøø tioogyii hoꞌcøøc. ");
INSERT INTO mirNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mänit hajxy quiojyquiapxytiuuṉ̃ coo jaꞌa naax̱ hajxy hänajty jiuyaꞌañ, jaꞌa xøhajpä Tuꞌtspojtstaact, jaꞌa xädøꞌøñhaam jaꞌa Judas hänajty hoy tøø ñajtsxäbapǿꞌøyäbä. Jeꞌe hajxy hänajty wiaꞌanaꞌañ cabäsantä maa jaꞌa jäguem̱bäjäyaꞌayhajxy ñaax̱tägǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Coo jaꞌa naax̱ hajxy jaduhṉ jiuuyy jaꞌa xädøꞌøñhaam jaꞌa Judas hänajty hoy tøø ñajtsxäbapǿꞌøyäbä, paady jaduhṉ xiøhaty Nøꞌñaax̱ høxtä jädaꞌanäbaadyñä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jaduhṉdsä tiøjiajty nebiä Jeremías jecy miänaaṉ̃än, jaꞌa Diosquex̱ypä: “Mänitä plataxädøꞌøñ hajxy miooyyä hiiꞌxmajc (nebiä judíoshajxy tøø ñägapxiän). ");
INSERT INTO mirNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mänitä tuꞌtspojtstaact hajxy hoy jiuy nébiøch jaꞌa Dios tøø xyhaneꞌemiän.” ");
INSERT INTO mirNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mänitä Jesús yajmejtsä maa jaꞌa gobernadorän. Mänit miäyajtøøw̱ä: ―Nej, miic̈h jaꞌa judíoshajxy xguiobiernähajpä. Mänitä Jesús yhadsooyy: ―Tøyhajt jaduhṉ nej miic̈h mmänaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mänitä Jesús ñähwaam̱bejtä jaꞌa teedywiindsøṉhajxy møødä martuumädøjc‑hajxy. Pero cabä Jesús waam̱b ñäꞌägä mänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mänitä Pilato miänaaṉ̃: ―Nej, caj miic̈h jaduhṉ mmädoyyä nebiaty hajxy jaduhṉ xñänǿm̱iänä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero cabä Jesús ñäꞌä hadsooyy; paadiä gobernador jiaanc̈h tehm̱ yagjuøøyy. Cab hänajty ñajuøꞌøy nebiaty jaduhṉ wyiinmahñdyhádät. ");
INSERT INTO mirNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jaduhṉdsä gobernador hänajty quiuhdujthaty coo jaꞌa tsum̱yjiäyaꞌay hänajty tuꞌug yhøxmach xøøjooty pøṉ jaꞌa cuꞌug jaduhṉ ñänǿmäp coo yhøxmadsǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jiibiä craa hänajty tuꞌug chum̱yc̈hänaꞌay jaꞌa xøhajpä Barrabás. Tøø jaꞌa Barrabás xiøø hänajty wyiꞌi wiaꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Coo jaꞌa cuꞌughajxy hänajty tøø quiøx̱y hamugøꞌøy, mänitä Pilato yajtøøyy: ―Pøṉ mijts jaduhṉ mnänøøm̱by cooc̈h nhøxmádsät, Barrabás tøgä jaꞌa Jesús jaꞌa Cristohajpä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ñajuøøbiä Pilato hänajty coo jaꞌa Jesús jaduhṉ yajcøꞌødägøøyyä jeꞌeguiøxpä coo jaꞌa quiuhdujt hänajty quiaꞌa yajmädsójcäxä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jim̱nä jaꞌa Pilato hänajty yhäñaꞌayñä maa hänajty tiuṉ̃än, mänitä Pilato quiapxyñäguejxä jaꞌa tioꞌoxiǿjcäm: “Cab jaduhṉ cu mdsaac̈htiuuṉ̃; hoyhänaꞌc yøꞌøduhṉ. Tøøc̈h haamyquioods haxøøg ngumaꞌay yøꞌøgøxpä.” ");
INSERT INTO mirNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mänitä teedywiindsǿṉ jaꞌa cuꞌug hajxy jiøjcapxøøyy coo ween hajxy miänaꞌañ coo jaꞌa Barrabás yhøxmadsǿøjät, y coo jaꞌa Jesús yaghoꞌogǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mänitä gobernador jaꞌa cuꞌug miäyajtǿøgumbä: ―Mädyii hänaꞌc mijts mnänøøm̱by cooc̈h nhøxmádsät. Mänit hajxy yhadsooyy: ―Barrabás. ");
INSERT INTO mirNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mänitä Pilato yajtøøyy: ―Jaꞌa Jesúsäts, jaꞌa xøhajpä jaꞌa Cristo, nébiøch jeꞌe ndúnät. Mänit hajxy nägøx̱iä yhadsooyy: ―Møjpahbet cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mänitä Pilato miänaaṉ̃: ―Tii haxøøgpä jaduhṉ tøø tiuṉ̃ coo jaduhṉ yaghoꞌogǿøjät. Mänit hajxy jaduhṉ yáax̱cumbä: ―Møjpahbet cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Coo jaꞌa Pilato jaduhṉ yhijxy coo jaꞌa cuꞌughajxy hänajty quiaꞌa mädow̱aꞌañ, coo hajxy maas hanax̱iä yhaamhadaꞌañ, mänitä nøø yujwaaṉ̃. Mänit quiøꞌøbujy cuꞌugwiinduum. Mänit miänaaṉ̃: ―Caꞌa yhøøc̈h jaduhṉ mänaam̱b coo yøꞌø hoyhänaꞌc jaduhṉ yaghoꞌogǿøjät; mijts jaduhṉ mänaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mänitä cuꞌughajxy nägøx̱iä miänaaṉ̃: ―Tøyhajt jaduhṉ. Højts jaduhṉ mänaam̱b møød højts nnøøx møød højts nmajc. ");
INSERT INTO mirNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mänitä Pilato jaꞌa Barrabás yhøxmajch. Mänitä Jesús yajwojpä. Mänit yajcøꞌødägøøyy coo nøcxy miøjpahbedyii. ");
INSERT INTO mirNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mänitä Jesús yajnøcxä jaꞌa gobernador soldadohajxy. Mänitä Jesús jiuhbigøøyyä jaꞌa soldadohajxy nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mänitä wyit yajtsíjjäxä. Mänitä tsaptswit yajpägøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mänitä haptycoronä piädaacä maa jaꞌa quiuhduumän. Mänitä pax̱y yajcøꞌøgabøøyyä yhahooyhaampiäcøꞌø. Mänit wyiinjijcädaacä. Mänit wyiingapxpejtä: ―¡Viva jaꞌa judíos jaꞌa guiobiernähajxy, viva! ");
INSERT INTO mirNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mänitä Jesús wyiingutsujøøyyä. Mänitä pax̱y piǿjcäxä. Mänit wiojpä quiuhduum. ");
INSERT INTO mirNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Coo yhuuc wiingapxpéjtäbä, mänit tsaptswit yajtsíjjägumbä. Mänit yhamdsoo wit yajpägǿøyyägumbä. Mänit yajnǿcxänä maa hänajty miøjpahbedaꞌañiijän. ");
INSERT INTO mirNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tuꞌhaamnøcxpä jäyaꞌay hajxy tuꞌug jiøjcubaadøøyy jaꞌa Cirenetsohm̱bä. Simón hänajty xiøhaty. Mänitä Simón jaꞌa cruz hadsip yajcajptsoow̱ä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mänit hajxy miejch maa jaduhṉ xiøhatiän Gólgota. Jeꞌeduhṉ ñänøøm̱by: “Maa jaꞌa hoꞌogyjiäyaꞌaguiopc ñähgädaꞌaguiän.” ");
INSERT INTO mirNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mänitä Jesús tsaatyñøø jia yaghuucä jaꞌa jaanc̈h tehm̱ tiahm̱bä. Coo jaduhṉ yhuucmajch, cab jaduhṉ chojcy. ");
INSERT INTO mirNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mänitä Jesús miøjpahbéjtänä cruzcøxp. Mänitä soldadohajxy yhäyøꞌcy dadoshaam nebiä Jesús jaꞌa wyit hajxy yajwáꞌxät. Jaduhṉdsä tiøjiajty nebiä Diosquex̱ypä jecy miänaaṉ̃än: “Dadoshaam hajxy yhäyøꞌcy nébiøch nwit hajxy jaduhṉ xyajwáꞌxät.” ");
INSERT INTO mirNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mänitä soldadohajxy jim̱ yhøxtaacy nebiä Jesús hajxy jaduhṉ wyiinhäñáꞌawät. ");
INSERT INTO mirNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mänit hajxy jim̱ yuugjahy cruzcuhduum tiiguiøxp jaꞌa Jesús coo tøø miøjpahbedyii: “Jesús hädaa, jaꞌa judíos guiobiernohajxy.” ");
INSERT INTO mirNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jim̱ä meeꞌtspä metsc miøjpahbéjtäbä. Cujc jaꞌa Jesús miähmøøyy, tuꞌug hanajtyhaamby, tuꞌug hahooyhaamby. ");
INSERT INTO mirNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jaꞌa jäyaꞌayhajxy hänajty najxpä, wyiꞌi wyiingapxpejpy hajxy hänajty møød hajxy hänajty wyiꞌi quiuhjägøṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Jaduhṉ hajxy hänajty ñiñämaꞌayii: ―Jaꞌa, miic̈h jaduhṉ mänaaṉ coo mahñdy jaꞌa tsajtøjc myagjidaꞌañ, y cumaax̱c mahñdy mhädiunaꞌañ wiingpä. Niyajmänacǿøjäts hamdsoo pø tøyhajt jaduhṉ coo miic̈h Dios xyHuunghaty. ");
INSERT INTO mirNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jaduhṉ jaꞌa teedywiindsøṉhajxy piamänaam̱bä møødä ley‑yajnähixøøbiähajxy, møødä fariseoshajxy, møødä martuumädøjc‑hajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Tøø jaduhṉ yhuuc wiꞌi miäyajnähwaꞌac̈h, y caj hamdsoo ñiyajnähwaꞌadsaꞌañii. Pø tøyhajt jaduhṉ coo jaduhṉ guiobiernähaty maa jaꞌa judíoshajxiän, ween jaduhṉ hamdsoo ñiyajmänaqyii cruzcøxp neby højts jaduhṉ nmäbǿjcämät. ");
INSERT INTO mirNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jaduhṉ tøø xnämáayyäm coo yHuunghadyii jaꞌa Diósäm y coo jaꞌa Dios jaduhṉ cwieendähadaꞌañ. Pø tøyhajt jaduhṉ coo jaꞌa Dios jaduhṉ jiaanc̈h tsocy, ween jaduhṉ yajnähwaꞌac̈h. ");
INSERT INTO mirNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jaduhṉdsä meeꞌtspähajxy piamänaam̱bä, jaꞌa hajxy jim̱ møjpahbetypä cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mänitcujyxiøø jaꞌa naax̱wiimbä wyiingoodsøøyy. Tägøøghorä jaduhṉ yhijty wiingoods. ");
INSERT INTO mirNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mänitmänacyxiøø jaꞌa Jesús møc yaax̱y: “Elí, Elí, lama sabactani”, jeꞌeduhṉ ñänøøm̱by: Dios meeꞌx, Dios meeꞌx, tiic̈h jaduhṉ coo tøø xñajtshixøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jaꞌa hajxy hänajty jim̱ wiꞌi tiänaabiä, coo hajxy jaduhṉ miädooyy, mänit hajxy näjeꞌe miänaaṉ̃: ―Elías yøꞌø craa jaduhṉ jia wiꞌi miøjyaax̱yp. ");
INSERT INTO mirNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mänit tuꞌjäyaꞌay xoꞌod hoy quioṉ̃ päyøꞌøguiä. Mänit quiumadsøøyy jaꞌa tsaatyñøøxuṉjooty. Cøjx jeꞌe chomøꞌøy. Mänit pax̱y yagjøjwøønøøyy jaꞌa xoꞌod. Mänitä Jesús yaghaguubøøyyä neby jaduhṉ miúugät. ");
INSERT INTO mirNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mänitä hänaꞌc‑hajxy wiingpä miänaaṉ̃: ―Huug hahijxnä, ween yhuuc cähxøꞌøgy pø minaam̱bä Elías yajnähwaꞌadsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mänitä Jesús jadähooc møc yáax̱cumbä. Mänit yhoꞌnä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mänitä tsajtøjc‑hadøødiuc quiøøꞌtswaꞌxy cujjiä. Cøxp jaduhṉ quiøøꞌtsohṉ̃. Mänitä hujx ñajxy. Mänitä tsaa jaduhṉ wiaꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mänitä hoꞌogyjiäyaꞌajiut may yhawaach. Mänitä hoꞌogyjiäyaꞌayhajxy may jiujypiøjcy, jaꞌa Diosmädiaꞌagy hajxy hänajty tøø miäbǿquiäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Coo jaꞌa Jesús hänajty tøø jiujypiøcy, mänitä hoꞌogyjiäyaꞌayhajxy yhawaꞌadspädsǿøm̱y, jaꞌa hajxy hänajty tøø jiujypiǿquiäbä. Mänit hajxy quiajptägøøyy Jerusalén. Jim̱ hajxy jaduhṉ yhijxä nämay. ");
INSERT INTO mirNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jim̱ä soldadowiindsǿṉ jaꞌa Jesús hänajty cwieendähaty møødä soldadohajxy. Coo jaꞌa tsøꞌty hajxy jaduhṉ yhijxy, mänit hajxy jiaanc̈h tehm̱ chähgøøyy. Mänit hajxy miänaaṉ̃: ―Tøyhájtäm hijty coo hädaa craa hijty Dyioshuungä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jim̱ä tajjäyaꞌay jaꞌa Jesús hajxy hänajty wyiꞌi ñäheebøꞌøy jäguem̱duum. Jim̱ä Jesús hajxy hänajty tøø piadsooñ Galilea. Tøø hajxy hänajty piuhbety. ");
INSERT INTO mirNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jim̱ä María hänajtypä jaꞌa Magdalatsohm̱bä, møødä María jaꞌa Jacobo tiajhajxy, møødä Zebedeo tioꞌoxiøjc. ");
INSERT INTO mirNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Coo quioodsøøyy, mänitä mäyøøjäyaꞌay tuꞌug miejch, jaꞌa xøhajpä José. Jim̱ hänajty chooñ Arimatea. Pianǿcxäbä jaꞌa Jesús miädiaꞌagy hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mänitä José jaꞌa Pilato cuhdujt hoy miäyujwaꞌañ coo jaꞌa hoꞌogyjiäyaꞌay yajmänácät cruzcøxp. Mänitä José jaꞌa cuhdujt miooyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mänit jaduhṉ yajmänajcy. Mänitä poobwit yajnähbijty. ");
INSERT INTO mirNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Mänit jaduhṉ jiiby piädaacy tsaajutjooty jaꞌa naam̱dajypä. Paadiä José jaꞌa tsaajut hänajty tøø yajtajyii, jiiby hänajty piädaꞌagaꞌañii coo hänajty tøø yhoꞌogy. Mänitä tsaajut yhahämoom̱tägooyy tsaahaam maa jaꞌa Jesús hänajty tøø ñaax̱tägøꞌøyän. Mänitä José wyiimbijty. ");
INSERT INTO mirNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jim̱ä María Magdalatsohm̱bähajxy miähmøøyy møødä María tuꞌugpä. Jim̱ hajxy hänajty yhäñaꞌay maa jaꞌa Jesús hänajty tøø ñaax̱tägøꞌøyän. ");
INSERT INTO mirNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Viernes jaꞌa Jesús jaduhṉ yhoꞌcy. Cujaboom jaꞌa teedywiindsøṉhajxy miejch maa jaꞌa Pilatän møødä fariseoshajxy. ");
INSERT INTO mirNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Mänitä Pilato ñämaayyä: ―Miic̈h møjteedy, jaꞌa craa häxøøy hóꞌcäbä, tøø hijty miänaꞌañ cooc tyijy cumaax̱c hijty jiujypiøgaꞌañ. Pero näꞌä høhṉdaac jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Entonces, quex̱ jaꞌa soldado jim̱ maa tøø ñaax̱tägøꞌøyän, jaduhṉ hajxy jaduhṉ jim̱ yhadänáꞌawät jaduꞌtsuhm̱. Jaduhṉdsä Jesús miäguꞌughajpä jaꞌa ñaax̱niꞌx hajxy nøcxy quiaꞌa yajpädsøøm̱ä. Jaduhṉdsä cuꞌug hajxy quiaꞌa nämáꞌawät cooc tyijy tøø jiujypiøcy. Maas hanax̱iä hajxy jaduhṉ cu yhøhṉdaacy quejee jaꞌa Jesús hijty yhøhṉdaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mänitä Pilato miänaaṉ̃: ―Xiidsä soldadohajxy. Ween hajxy jim̱ nøcxy yhadänaꞌay neby jaduhṉ quiaꞌa pädsǿm̱ät. ");
INSERT INTO mirNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mänit soldadohajxy jim̱ quiejxä hadänaabiä. Mänitä tsaa hajxy xiøøjøøyy jaꞌa jim̱ hämoom̱naabiä maa jaꞌa tsaajuthaawän. Mänit hajxy jim̱ miähmøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cujaboom näxøø jopyñä, mänitä María Magdalatsohm̱bä jim̱ miejch maa jaꞌa Jesús hänajty tøø ñaax̱tägøꞌøyän møødä María tuꞌugpä. ");
INSERT INTO mirNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mänitiä hujx møc ñajxy. Jim̱ä Dios jaꞌa mioonsä hänajty tuꞌug tiänaꞌay. Tsajpootyp hänajty tøø chooñ. Mänitä tsaa jiøhämoom̱y jaꞌa hijty hijpä juthaguum. Mänitä yhøxtaacy tsaanähgøxp. ");
INSERT INTO mirNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jaanc̈h tehm̱ yhaam̱b hänajty jeꞌe. Jaanc̈h tehm̱ pioob jaꞌa wyit hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Coo jaꞌa soldado jaꞌa Diosmoonsä hajxy yhijxy, mänit hajxy tiägøøyy tsäyuubiä. Jaanc̈h tehm̱ chähgøøby hajxy hänajty. Mänit hajxy quiädaayy. Jaduhṉ hajxy miähmøøyy nebiä hoꞌogypiän. ");
INSERT INTO mirNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mänitä Maríahajxy ñämaayyä jaꞌa Diosmóonsäm: ―Caꞌa hajxy mdsähgøꞌøy. Nnajuǿøbiøch jaduhṉ coo jaꞌa Jesús hajxy mhøxtaꞌay, jaꞌa hijty tøø miøjpahbedyíijäbä. ");
INSERT INTO mirNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Cabä jii; tøø jiujypiøcy neby hijty tøø miänaꞌañän. Miṉ hajxy huug hix̱ maa tøø ñaax̱tägøꞌøyän. ");
INSERT INTO mirNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Coo hajxy jaduhṉ mhíxät, mänitä miäguꞌughajpä hajxy nøcxy paquiä mhawaaṉä coo jaduhṉ tøø jiujypiøcy, coo jaduhṉ ñøcxøꞌøgaꞌañ Galilea. Jim̱ hajxy jaduhṉ mbaadaꞌañ. Jadúhṉhøch mijts nhawáaṉäm. ");
INSERT INTO mirNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mänitä Maríahajxy hoy yhix̱y paquiä maa jaꞌa Jesús hänajty tøø ñaax̱tägøꞌøyän. Jíibädä hajxy chähgøꞌøy, jíibädä hajxy xiooṉdaꞌagy. Mänitä miäguꞌughajpä hajxy hoy yhawaaṉä päyøꞌøguiä. ");
INSERT INTO mirNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tuꞌhaamnøcxpä jaꞌa Jesús ñäguehx̱tøøꞌxy. Mänitä Maríahajxy yajpooꞌxä. Mänitä Jesús hajxy wyiingumedsøøyy. Mänit hajxy tiecymiämäneṉøøyy. Jaduhṉ hajxy wyiingudsähgøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mänit hajxy ñämaayyä: ―Caꞌa hajxy mdsähgøꞌøy. Nǿcxhøch jaꞌa nmäguꞌughajpä hajxy hawáaṉäc coo hajxy jim̱ ñǿcxät Galilea, cooc̈h hajxy jim̱ xpiaadaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Coo jaꞌa Maríahajxy hänajty tøø wyiimbity maa jaꞌa Jesús hänajty tøø jiujypiøquiän, mänitä soldadohajxy näjeꞌe ñøcxy cajptooty, jaꞌa hajxy hänajty tøø yhadänáꞌayäbä. Mänitä teedywiindsǿṉ hajxy hoy yhawaaṉä nebiaty hajxy hänajty tøø yhix̱y. ");
INSERT INTO mirNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mänitä teedywiindsøṉhajxy hoy miøødmädiaꞌagy jaꞌa martuumädøjc‑hajxy neby hajxy jaduhṉ quiojyquiapxytiúnät. Mänitä soldado xädøꞌøñ hajxy may miooyyä. ");
INSERT INTO mirNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Mänitä soldadohajxy ñämaayyä: ―Jaduhṉ hajxy mmänáꞌanät coo hajxy coods mmaahoꞌcy, y coo jaꞌa Jesús jaꞌa miäguꞌughajpähajxy hoy yajpädsøm̱yii. ");
INSERT INTO mirNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Y coodsä gobernador jaduhṉ miädoyhádät, højts jaduhṉ nyajmäbǿgäp. Jaduhṉ hajxy xquiaꞌa capxpáadät. ");
INSERT INTO mirNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mänitä soldado jaꞌa xädøꞌøñ hajxy wyiingpøjcy. Mänit hajxy hoy jiatcøꞌøy neby hajxy hänajty tøø ñämaꞌayiijän. Jaduhṉdsä judíoshajxy miädiaꞌagyñä høxtä jädaꞌanäbaadyñä. ");
INSERT INTO mirNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mänitä Jesús miäguꞌughajpähajxy jim̱ ñøcxy Galilea, jaꞌa nämajtuꞌugpä. Mänit hajxy jim̱ miejch maa jaꞌa tuṉän maa jaꞌa Jesús hänajty tøø ñägapxiän. ");
INSERT INTO mirNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Coo jaꞌa Jesús hajxy yhijxy, mänit hajxy wyiingudsähgøøyy, hoy hajxy hänajty näjeꞌe quiaꞌa ja mäbøcy hamuumduꞌjoot. ");
INSERT INTO mirNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mänit hajxy wyiingumedsøøyyä. Mänit hajxy ñämaayyä: ―Tøøc̈hä Dios cuhdujt cøx̱iä xmioꞌoy jim̱ tsajpootyp, møød hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nøcx hajxy wiinduhm̱yhagajpt. Yajwiingapxøꞌøw hajxy nébiøch nmädiaꞌagy hajxy xmiäbǿjcät. Jaduhṉ hajxy myajnäbétät jaꞌa Diosteedycøxpä, møødä høøc̈hcøxpä, møødä Dioshespíritucøxpä. Høøc̈h jaꞌa Dios xyHuunghajp. ");
INSERT INTO mirNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jaduhṉ hajxy myajnähixǿꞌøwät coo hajxy jaduhṉ miäbǿgät nebiátyhøch mijts tøø nhaneꞌemiän. Mjahmiédsäp hajxy jaduhṉ cooc̈h mijts nmøødhidaꞌañ cøjxtaꞌaxiøø høxtä coonä naax̱wiimbä wyiimbídät.");
INSERT INTO mirNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jaduhṉä Diosmädiaꞌagy chohṉdaꞌagy jaꞌa Jesucristocøxpä, neby jiajty, neby yhabejty. Dioshuungä Jesucristo jeꞌeduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jaduhṉ jim̱ cujaay myiṉ̃ nocyjiooty, jaꞌa Isaías jecy quiujáhyyäbä. Jaꞌa Isaías, jeꞌe jaꞌa Diosmädiaꞌagy jecy yajwaꞌx. Jaduhṉä Dios jaꞌa yHuung jecy ñämaayy: Huuc mädow̱, chám̱høc̈hä nguguex̱y nguejxøꞌøgaꞌañ maa miic̈h mnøcxøꞌøwaꞌañän. Jeꞌe jaꞌa mädiaꞌagy nøcxy yajwaꞌxaꞌañ coo miic̈h jim̱ nøcxy mwäditaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mänitä Dios jiaac mänaaṉ̃: “Pactúumhøc̈hä nguguex̱y nøcxy wiäditaꞌañ. Coo jaꞌa cuꞌughajxy jaduhṉ miädoyhadaꞌañ coo jaꞌa wiingapx jøjcapxøøbiä jim̱ tøø quiädaꞌagy pactuum, mänit hajxy nøcxy wyiingapx jiøjcapxøꞌøwaꞌañii coo jaꞌa haxøøgwiinmahñdy hajxy ñajtshixøꞌød, coo jaꞌa Jesús jaꞌa miädiaꞌagy hajxy miäbǿjcät, jaꞌa hajxy mWiindsøṉhadaam̱biä.” Jaꞌa Juan jaduhṉ nänøøm̱ä, jaꞌa hänajty mäyajnäbetaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Mänitä Juan jeꞌe jiaanc̈h tägøøyy mäyajnäbejpä jim̱ jäguem̱duum, maa jaꞌa møjnøø hänajty xiøhatiän Jordán. Mänitä jäyaꞌayhajxy may miejch maa jaꞌa Juan hänajtiän. Jim̱ hajxy hänajty chooñ maa jaꞌa naax̱ hänajty xiøhatiän Judea, møød jim̱ maa jaꞌa cajpt hänajty xiøhatiän Jerusalén. Mänitä Juan jaꞌa cuꞌug tiägøøyy yajwiingapxøøbiä coo hajxy ñäbétät, weenä jiootä wyiinmahñdy hajxy yajtägach. Jaduhṉä Dios jaꞌa piojpä quiädieey hajxy yajnähwáatsät. Mänitä cuꞌugä piojpä quiädieey hajxy ñägapxy. Jaduhṉ hajxy hänajty miänaꞌañ cooc jaꞌa yhaxøøgwiinmahñdy hajxy hänajty ñajtshixøꞌøwaꞌañ. Mänit hajxy ñäbejnä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jaꞌa Juan, camellopøjt hänajty wyithajpy. Wajhac hänajty wiøønhajpy. Muꞌu hänajty chuꞌuc̈hhajpy. Møjtsiinnøø hänajty yhuꞌugyhajpy. ");
INSERT INTO mirNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mänitä Juan jaꞌa cuꞌug yajwiingapxøøyy: “Jím̱høc̈hä njamiøød tuꞌug jiaac medsaꞌañ yajwiingapxøøbiä. Maas mäjaamøød jeꞌe miedsaꞌañ quejeec̈h høøc̈h. Cábøch cuhdujt jaduhṉ njaty møødä nebiä cuhdujt jeꞌe miøødän, jaꞌa jaac medsaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Coo mijts nyajnäbejty, nøøhaam mijts nyajnäbejty. Pero jaꞌa jaac minaam̱bä, Dioshespírituhaam hajxy jadähooc xyajnäbejtägatsaꞌañ.” Jaduhṉä Juan miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Cujequiä Jesús jim̱ miejch maa jaꞌa Juan hänajty miäyajnäbetiän, jim̱ maa jaꞌa møjnøø hänajty xiøhatiän Jordán. Jim̱ä Jesús hänajty tøø chooñ maa jaꞌa cajpt xiøhatiän Nazaret, jim̱ maa jaꞌa naax̱ hänajty xiøhatiän Galilea. Mänitä Juan jaꞌa Jesús yajnäbejty. ");
INSERT INTO mirNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tuuṉä Jesús ñäꞌä tøꞌødspädsøøm̱y, mänit yhijxy coo jaꞌa tsajt yhawaach. Mänitä Jesús jaꞌa Dioshespíritu yhijxy coo hänajty ñägädaꞌagyii nebiä paloman. ");
INSERT INTO mirNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mänitä Dios jim̱ quiuhgapxnajxy tsajpootyp. “Høøc̈h miic̈h tuꞌuquiä nHuunghajpy. Miic̈h njaanc̈h tehm̱ chojpy. Miic̈h njaanc̈h tehm̱ quiumaaby.” Jaduhṉä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mänitä Jesús miødhajtä pactuum jaꞌa Dioshespíritu. ");
INSERT INTO mirNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mänitä Jesús jim̱ piuhwaatsä. Nidiuhm̱ jim̱ miähmøøyy. Jagooyyä animalhajxy hänajty jim̱ wiädity. Mänitä Jesús ñämejtsä jaꞌa møjcuꞌugong. Mänitä Jesús jia tägøøyyä jøjcapxǿøyyäbä. Juxychäguiꞌxxøø jaꞌa Jesús jim̱ yhijty jäguem̱duum. Mänitä Jesús ñämejtsä jaꞌa Diosmoonsähajxy jaꞌa jim̱ tsajpootypä. Mänitä Jesús piuhbejtä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jaꞌa Juan, cujecy jeꞌe chuum̱ä. Coo jeꞌe jaduhṉ chuum̱ä, mänitä Jesús jim̱ ñøcxtägajch Galilea. Mänitä Jesús jaꞌa cuꞌug tiägøøyy yajwiingapxøøbiä jaꞌa Diosmädiaꞌagy cooc hänajty yhabaatnä coo jaꞌa Dios jaꞌa miøcmäjaa hänajty yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Habáatnäp jaduhṉ coo jaꞌa Dios jaꞌa miøcmäjaa yajcähxøꞌøgaꞌañ. Paadiä Dios jaꞌa miädiaꞌagy hajxy mmäbǿjcät. Weenä mjootä mwiinmahñdy hajxy myajtägach. Weenä mhaxøøgwiinmahñdy hajxy mnajtshixøꞌøy.” Jaduhṉä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Cujequiä Jesús tiägøøyy wädijpä maa jaꞌa mejy hänajty xiøhatiän Galilea. Jim̱ hänajty wiädity mejypiaꞌa, mänitä jäyaꞌay metsc yhijxy, jaꞌa Simón møødä piuhyaꞌay Andrés. Hacxmats jaꞌa Simónghajxy hänajty tiuuṉghajpy. Jiibiä yhacxjohm̱d hajxy hänajty piädaꞌagy mejjiooty. ");
INSERT INTO mirNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mänitä Simónghajxy ñämaayyä: ―Jam̱ hajxy wädíjtäm. Jeꞌe mijts hijty mduuṉghajpy, hacxmats. Wiingtuuṉg høøc̈h mijts nmoꞌowaam̱by. Nyajnähixøꞌøwáam̱biøch mijts nebiä cuꞌugä Diosmädiaꞌagy hajxy myajwiingapxǿꞌøwät ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tuuṉä jaduhṉ ñäꞌä mänaaṉ̃, mänitä Simón jaꞌa yhacxjohm̱d hajxy hoy ñajtswidsøꞌøy mejypiaꞌa. Mänitä Jesús hajxy piaduꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Weeṉ̃tiä jaꞌa Jesúshajxy hänajty tøø miejypiaꞌayoꞌoy, mänitä Jesús jaꞌa Zebedeo yhijxy møødä yhuunghajxy, jaꞌa Santiago møødä Juan. Barcohuungooty jaꞌa Zebedeohajxy hänajty yhäñaꞌay. Jiibiä yhacxjohm̱d hajxy hänajty yhaxodsøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mänitä Jesús jaꞌa Santiago miøjyaax̱y møødä Juan. Mänitä Santiago jaꞌa Jesús hajxy piaduꞌubøjpä. Ñähgueec jaꞌa tieedy hajxy jiiby barcohuungooty møødä mioonsähajxy. ");
INSERT INTO mirNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mänitä Jesúshajxy jim̱ miejch maa jaꞌa cajpt hänajty xiøhatiän Capernaum. Coo jaꞌa pooꞌxxiøø yhabaaty, mänit hajxy jiiby tiägøøyy tsajtøgooty. Mänitä Jesús jaꞌa cuꞌug tiägøøyy yajwiingapxøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mänitä cuꞌughajxy yagjuøøyy coogä Jesús hänajty hoy yajnähixøꞌøy nebiä møjcuhdujtmøødpän. Maas hóyyäc hänajty yajnähixøꞌøy quejee jaꞌa hänaꞌc‑hajxy, jaꞌa Diosmädiaꞌagy hajxy hänajty nax̱y yajnähixøøbiä tsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jiibiä mähdiøjc hänajty tuꞌug tsajtøgooty, tøø hänajty yajtägøꞌøyii jaꞌa møjcuꞌu. Mänitä møjcuꞌu tiägøøyy yaax̱pä møc: ");
INSERT INTO mirNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Miic̈h Jesús, Nazaret miic̈h mdsooñ. Tii højts coo xmiädsibøꞌøy. Højts jaduhṉ xjia wiꞌi yajcuhdägoyyaam̱b, túhm̱äts. Nnajuǿøbiøch pøṉ miic̈h. Miic̈hä Dios xyHuunghajp ―nøm̱ä mähdiøjcä møjcuꞌu yajmänaaṉä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mänitä Jesús jaꞌa møjcuꞌu yhojy: ―Hamóṉ, juaꞌads jim̱ maa yøꞌø mähdiøjcän ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mänitä møjcuꞌu jaꞌa mähdiøjc jeꞌe yajpojpaaty. Yáax̱äbä mähdiøjc ñähwaatsä. Jaꞌa møjcuꞌu jaduhṉ yajyaax̱. ");
INSERT INTO mirNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Coo jaꞌa Jesús jaꞌa mähdiøjc jaduhṉ yajnähwaach, jiaanc̈h tehm̱ yagjuøøyy jaꞌa cuꞌughajxy jaduhṉ nägøx̱iä. Mänit hajxy tiägøøyy niñämáayyäbä: ―Maa yøꞌø craa cuhdujt jaduhṉ tøø ñäꞌä mahñ piøcy coo yøꞌø mähdiøjcä møjcuꞌu jaduhṉ yajnähwaatsä. Nej, hawiinjem̱yguiuhdujtädaꞌa miǿødäjä ―nøm̱ä Jesús ñänøøm̱ä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Paquiä mädiaꞌagy jim̱ wiaꞌxy Galileanaaxooty wiinduhm̱yhagajpt coo jaꞌa Jesús jaꞌa miøcmäjaa hänajty tøø yajcähxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Coo jaꞌa Jesúshajxy jiiby chajtøjpädsøøm̱y møødä jiamiøødtøjc, mänit hajxy jim̱ ñøcxy maa jaꞌa Simónghajxy hänajty chänaꞌayän møødä Andrés. Quipxiä Santiagohajxy hänajty choonä møødä Juan. ");
INSERT INTO mirNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jaꞌa Simón jaꞌa miøꞌødhoc, paꞌamgoꞌnaaby hänajty jeꞌe. Tobiaꞌam hänajty miøød. Coo jaꞌa Jesús jim̱ miejch maa jaꞌa Simón tiøjcän, mänitä Jesús yhawáaṉäxä coo jaꞌa paꞌamjäyaꞌay hänajty jiiby tøgooty. ");
INSERT INTO mirNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Coo jaꞌa Jesús tiøjtägøøyy, mänitä paꞌamjäyaꞌay wyidsøꞌcy. Mänitiä jaꞌa tioy tiøjch. Mänitä Jesús yajcaayyä yaghuucä jaꞌa Simón jaꞌa miøꞌødhoc. ");
INSERT INTO mirNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mänittsuu, coo jaꞌa xøø hänajty tøø quiuhnax̱y, mänitä Jesús paꞌamjäyaꞌay may yajnämejtsä, jim̱ maa jaꞌa Simón tiøjcän, møødä møjcuꞌumøødpähajxy. ");
INSERT INTO mirNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jim̱ä cuꞌughajxy hänajty may tiänaꞌay tøghaawjooty. ");
INSERT INTO mirNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mänitä Jesús jäyaꞌay may yajpaꞌamnajxy. Madiuꞌujä paꞌam hajxy hänajty miøødä. Møødä møjcuꞌumøødpähajxy, yajnähwaatsä hajxy jeꞌebä. Mänitä Jesús jaꞌa møjcuꞌu yhanehm̱y coo hajxy quiaꞌa cápxät, jeꞌeguiøxpä coo jaꞌa Jesús hänajty ñajuøꞌøyii pøṉ jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Cujaboom, jeꞌenä hänajty wyiingoodsä, mänitä Jesús piädøꞌcy. Mänit tiøjpädsøøm̱y. Mänit jim̱ ñøcxy jäguem̱duum. Mänitä Tieedy hoy piaꞌyaꞌaxy. ");
INSERT INTO mirNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Coo jiobøøyy, mänitä Simónghajxy yhijxy coo Jesús hänajty tøø tiuꞌubøcy. Mänit hajxy tiuꞌubøjcy høxtaabiä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Coo jaꞌa Jesús piaatä, mänit ñämaayyä: ―Jim̱ miic̈hä cuꞌug xjia wiꞌi yajtøy maac̈hä ndøjcän. ");
INSERT INTO mirNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mänitä Jesús yhadsooyy: ―Jam̱ hajxy wiingtuum wädíjtäm maa jaꞌa cajpt wiingoṉbän. Jadúhṉhøc̈hä cuꞌugä Diosmädiaꞌagy jim̱ nyajwiingapxǿøbiät. Jadúhṉhøch nwiinguex̱iä cooc̈hä Diosmädiaꞌagy wiinduhm̱yhagajpt nmäwädítät. ");
INSERT INTO mirNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mänitä Jesús tiägøøyy wädijpä tsajtøjc‑tsajtøjc wiinduhm̱yhagajpt jim̱ Galileanaaxooty. Jaꞌa Diosmädiaꞌagy hänajty yajwiingapxøøby, møødä paꞌamjäyaꞌay hänajty yajnähwaatspä, jaꞌa hajxy møjcuꞌumøødpä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mänitä Jesús paꞌamjäyaꞌay ñämejtsä tuꞌug, jaꞌa leprapaꞌammøødpä. Mänitä Jesús wyiinjijcädaacä, miänuuꞌxtaacä: ―Pø chojpy miic̈hä mjoot jaduhṉ, høøc̈h hädaa nbaꞌam yajnähwáatsäc ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mänitä mähdiøjc ñäxuuꞌtsä. Mänit ñähdooṉä. Mänit ñämaayyä: ―Tii coo quiaꞌa cabä. Tøø jaduhṉ mnähwaꞌac̈h. ");
INSERT INTO mirNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tuuṉä jaꞌa Jesús jaduhṉ ñäꞌä mänaaṉ̃, mänitiä mähdiøjcä piaꞌam ñähwaatsä. ");
INSERT INTO mirNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Mänit miägapx yhanehm̱ä: ―Huuc mädow̱, cab jaduhṉ pøṉ mhawáaṉät coo tøø mbaꞌamnähwaꞌac̈h. Tuꞌudaꞌaquiä jim̱ mnǿcxät maa jaꞌa teediän, ween jaduhṉ xyhix̱y coo tøø mjaanc̈h paꞌamnähwaꞌac̈h. Mänit mguyoxǿꞌøwät nebiä Moisés jecy yhanehm̱iän, jaduhṉä cuꞌughajxy ñajuǿꞌøwät coo tøyhajtä mbaꞌam tøø jiaanc̈h nax̱y ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero cabä craa ñäꞌä mädiaꞌagymiäbøjcy, jaꞌa piaꞌam hänajty tøø yajnähwaꞌac̈híijäbä. Coo tiuꞌubøjcy, mänit tiägøøyy mädiaacpä nebiaty hänajty tøø jiaty. Wiinduhm̱yhagajptä mädiaꞌagy jaduhṉ wiaꞌxy. Coo jaꞌa paꞌamjäyaꞌayhajxy jaduhṉ miädoyhajty coo jaꞌa Jesús hänajty miäyajpaꞌamnax̱y, mänitä Jesús hajxy tiägøøyy høxtaabiä coo jaꞌa piaꞌamhajxy yajnájxäxät. Paadiä Jesús hänajty quiaꞌa cajptägøꞌøwaaṉnä coo jaꞌa paꞌamjäyaꞌayhajxy hänajty jia wiꞌi ñämech. Paadiä Jesús miähmøøñä jäguem̱duum maa jäyaꞌay quiaꞌa hitiän. Mänitä Jesús jaꞌa paꞌamjäyaꞌay may ñämejtsä. Wiinduhm̱yhagajptjaty hajxy hänajty chooñ. ");
INSERT INTO mirNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Cujequiä Jesús jadähooc quiajptägøøyy Capernaum. Mänitä mädiaꞌagy wiaꞌxy coo hänajty jim̱ tøø miéjtscumbä. ");
INSERT INTO mirNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mänitä jäyaꞌayhajxy may miejch maa jaꞌa Jesús hänajty miejtstaꞌaguiän. Paquiä jaꞌa tøjc jaduhṉ yhujch. Høxtä tøguubiaady hajxy miejch. Mänitä Jesús jaꞌa cuꞌugä Diosmädiaꞌagy tiägøøyy yajwiingapxøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mänitä paꞌamjäyaꞌay tuꞌug quiøømiejtsä cøꞌømucy tecymiucy. Nämädaax̱cä jäyaꞌayhajxy hänajty quiøꞌøy tsaajiooty. ");
INSERT INTO mirNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cabä paꞌamjäyaꞌay hänajty hoy yajmedsaꞌañii maa jaꞌa Jesúsän, coo jaꞌa jäyaꞌayhajxy hänajty jiaanc̈h tehm̱ miayyä. Mänitä mähdiøjc miäbejtä cuhjodiøjnähgøxp. Mänitä tøjc hajxy weeṉ̃tiä yajcuhwaach, jim̱ mädøyyä maa jaꞌa Jesús hänajty piaꞌtänaꞌayän, mäduhṉ̃tiä paꞌamjäyaꞌay hoy ñänax̱y. Mänit jaduhṉ quiuhdøøñajxä tsaajiooty. Jiiby hoy quiädaꞌagy maa jaꞌa Jesús wyiinduumän. ");
INSERT INTO mirNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Paadiä paꞌamjäyaꞌay yajmejtsä maa jaꞌa Jesúsän, ñajuøøby hajxy hänajty coo jaꞌa piaꞌam hänajty yajnaxáaṉäxä. Coo jaꞌa Jesús jaduhṉ yhijxy coo jaꞌa miädiaꞌagy hänajty miäbøgáaṉäxä coo hänajty miäyajtsoꞌogaꞌañ, mänitä paꞌamjäyaꞌay ñämaayyä: ―Mäguꞌughajpä, tøø jaꞌa mboj tøø jaꞌa mgädieey xñähwaꞌac̈h ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jiibiä hänaꞌc‑hajxy hänajty näjeꞌe piahäñaꞌay, jaꞌa Diosmädiaꞌagy hajxy nax̱y yajnähixøøbiä tsajtøgooty. Jiiby hajxy hänajty miämädoonaabiä. Mänit hajxy näjeꞌe miänaaṉ̃ quiopcooty: ");
INSERT INTO mirNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Tii yøꞌø craa jaduhṉ coo miänaꞌañ cooc tyijy yøꞌø paꞌamjäyaꞌay piojpä quiädieey tøø yajnähwáatsäxä. Cap pøṉ cuhdujt miøødä coo jäyaꞌayä piojpä quiädieey yajnähwáatsät; jagooyyä Dios tuꞌuquiä miøødä.” ");
INSERT INTO mirNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ñajuøøyy jaꞌa Jesús jaduhṉ waam̱baty hajxy hänajty miädiaꞌagy quiopcooty. Mänit hajxy ñämaayyä: ―Tii hajxy jaduhṉ coo mwiꞌi miädiaꞌagy mgopcooty. ");
INSERT INTO mirNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","11","Høøc̈h, Diosquéx̱yhøch høøc̈h, páadyhøch cuhdujt nmøødä cooc̈hä jäyaꞌayä piojpä quiädieeyhajxy yaa nyajnähwáatsät hädaa yaabä naax̱wiin. Hädaa mähdiøjc, nyajpaꞌamnaxáam̱biøch hädaa. Jadúhṉhøch nyajcähxøꞌøgaꞌañ cooc̈h njaanc̈h Diosquex̱iä. Jaduhṉä tøyhajt hajxy mmøødhájpät cooc̈h cuhdujt njaanc̈h møødä cooc̈hä jäyaꞌayä piojpä quiädieeyhajxy nyajnähwáatsät ―nøm̱ä Jesús miänaaṉ̃. Mänitä paꞌamjäyaꞌay ñämaayyä: ―Tänaayyøꞌøg. Widsøꞌøg yøꞌø mdsaay. Nøcxnä maa jaꞌa mdøjcän. ");
INSERT INTO mirNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tuuṉä jaꞌa Jesús jaduhṉ ñäꞌä mänaaṉ̃, mänitä paꞌamjäyaꞌay jiaanc̈h møcpøjcy. Mänit tiänaayyøꞌcy. Mänitä chaay wyidsøꞌcy. Mänit tiuꞌubøjnä. Coo jaꞌa cuꞌughajxy jaduhṉ yhijxy, mänit hajxy nägøx̱iä jiaanc̈h tehm̱ yagjuøøyy. Mänit hajxy miänaaṉ̃: ―Ni mänaa højts jaduhṉ ngaꞌa híjxäm. Mänitä Dios hajxy wyiingudsähgøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mänitä Jesús ñøcxtägajch maa jaꞌa mejjiän. Mänitä jäyaꞌay jim̱ may ñäméjtsägumbä. Mänitä Diosmädiaꞌagy hajxy yajwiingapxøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jim̱ä Jesús hänajty miejypiaꞌayoꞌoy, mänitä Leví yhijxy, jaꞌa Alfeo yhuung. Jim̱ hänajty yhäñaꞌay meexäpaꞌa maa hajxy hänajty yajnähjuudiuꞌudiän. Mänitä Leví ñämaayyä: ―Jam̱ wädíjtäm ―nøm̱ä Jesús miänaaṉ̃. Mänitä Leví tiänaayyøꞌcy. Mänit piaduꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mänitä Jesúshajxy wioow̱ä mägaabiä maa jaꞌa Leví jaꞌa tiøjcän, møødä jiamiøødtøjc. Nämayyä jäyaꞌayhajxy jim̱ piamejch, jaꞌa Jesús hajxy hänajty pawädijpä. Jiibiä yajnähjuudiuutpädøjcä Jesús hajxy hänajty may miøødcaamiucy miøødhuucmucy, møødä cuboj cugädieediøjc. ");
INSERT INTO mirNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jiibiä fariseoshajxy hänajty näjeꞌe miäheeꞌpnaꞌay, møødä hänaꞌc‑hajxy, jaꞌa Diosmädiaꞌagy hajxy hänajty nax̱y yajnähixøøbiä tsajtøgooty. Coo jaꞌa Jesús hajxy jaduhṉ yhijxy coo jaꞌa yajnähjuudiuutpädøjc‑hajxy hänajty miøødcaamiugyii møødä cuboj cugädieejiäyaꞌayhajxy, mänitä Jesús jaꞌa jiamiøødhajxy ñämaayyä: ―Yøꞌø mwiindsǿṉ, tii yøꞌø yajnähjuudiuutpädøjc coo miøødcaamiucy, møød yøꞌø cuboj cugädieejiäyaꞌay ―nøm̱ä fariseoshajxy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Miädoow̱ jaꞌa Jesús jaduhṉ coo hajxy jaduhṉ miänaaṉ̃. Mänit hajxy ñämaayyä: ―Pøṉ jaduhṉ møc, cab hajxy yajtsooyøꞌøy. Pøṉ jaduhṉ paꞌammøød, jeꞌeds hajxy jaduhṉ yajtsooyøøby. Páadyhøch yaa tøø ngädaꞌagy hädaa yaabä naax̱wiin cooc̈hä cuboj cugädieebiähajxy nnämáꞌawät coo jaꞌa yhaxøøgwiinmahñdy hajxy ween ñajtshixøꞌøy. Pǿṉäc tyijy pojpä cädieey caꞌa møød, cábøch hajxy jeꞌe waam̱b nnämaꞌawaꞌañ ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Cujecy, jim̱ä Juan jaꞌa jiamiøødhajxy hänajty jaguiay yhity, møødä fariseoshajxy näjeꞌe. Mänitä jäyaꞌayä Jesús hajxy hoy näjeꞌe miäyajtøy: ―Yøꞌø Juan jaꞌa jiamiøødhajxy, jaguiay hajxy yøꞌø yhity, møød yøꞌø fariseoshajxy. Pero miic̈hä mjamiøødhajxy, cab hajxy jaduhṉ yhijpä. Tisän ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mänitä Jesús yhadsooyy: ―Coo jaꞌa pøc jaꞌa huꞌug nax̱y jiadyii, cabä jäyaꞌayhajxy yhity jaguiay, jaꞌa hajxy woybä wichpä, coo jaꞌa jamiøꞌød hajxy hänajty wyiingay wyiinhuꞌugy. Cab hajxy hänajty jiootmayhaty. ");
INSERT INTO mirNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero habaadáaṉnäp jaduhṉ cooc̈h yaa ndsoonaaṉnä. Mänítøch mäbǿjnäbä jaꞌa njamiøødhajxy yhidaꞌañ jaguiay. Jootmayhadaam̱b hajxy hänajtiän. ");
INSERT INTO mirNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ni pøṉä tucwit quiaꞌa hagøyøꞌøy jem̱ywyithaam. Jaꞌa jem̱ywyit, múgäp jeꞌe. Jaꞌa tucwit, cǿødsäp jeꞌebä. Maas hanax̱iä jiaac pagǿødsät. ");
INSERT INTO mirNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jaanä jaduhṉduhm̱bä, ni pøṉä jem̱yvyino quiaꞌa cudemøꞌøy tucwajhacxujiooty. Jaac xúnäp jaꞌa jem̱yvyino jaduhṉ. Mägøødsøꞌøb jaꞌa tucwajhacxuy jaduhṉ. Cǿxäp jaꞌa jem̱yvyino yhøxyocy. Näꞌägä tägóyyäp jaduhṉ nämetsc. Tägóyyäp jaꞌa tucwajhacxuy. Jaanä tägóyyäbä jem̱yvyínäbä. Páadiädsä jem̱yvyino hajxy quiudemøꞌøy jem̱ywiajhacxujiooty ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pooꞌxxiøøjooty hänajty jeꞌe, jim̱ä Jesúshajxy hänajty wiädity trigocamjooty, møødä jiamiøødtøjc. Mänitä jiamiøødhajxy yohguiujc tiägøøyy trigowiingädsujtspä. Jeꞌe hajxy hänajty jiøøꞌxaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jim̱ä Fariseoshajxy hänajty näjeꞌe piawädijpä. Mänitä Jesús ñämaayyä: ―Tii yøꞌø mjamiøødhajxy coo trigowiingädsuch pooꞌxxiøøjooty. Nej, cab hajxiädaꞌa ñajuøꞌøyä coo jaꞌa cuhdujt jaduhṉ myiṉ̃ä coo hajxy jaduhṉ mgaꞌa túnät pooꞌxxiøøjootiä ―nøm̱ä fariseoshajxy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Mänitä Jesús miänaaṉ̃: ―Nej, cahnä Diosmädiaꞌagy hajxy mgapxiä coo jaꞌa Davidhajxy jecy yähoꞌpøjcä møødä jiamiøødtøjc. ");
INSERT INTO mirNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Jaꞌa Abiatar hänajty tuum̱b teedywiindsǿṉ. Mänitä David jiiby tiägøøyy Diostøgooty. Mänitä tsajcaagy quiaayy, jaꞌa teedyhajxy hänajty tøø quiuyoxǿꞌøyäbä Dioswiinduum. Mänitä David jaꞌa jiamiøødtøjc piuhmooyy. Hoorä, cabä cuhdujt hänajty myiṉ̃ coo jaꞌa David jaꞌa tsajcaagy hajxy jaduhṉ quiáyät. Jagooyyä teedy cuhdujt hajxy hänajty miøødä coo hajxy quiáyät. ");
INSERT INTO mirNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mänitä Jesús miänáaṉgumbä: ―Paadiä Dios jaꞌa pooꞌxxiøø quiunuuꞌxy, weenä jäyaꞌayhajxy mänit piooꞌxy. Mijts jaduhṉ ja mänaam̱b, paadiä Dios jaꞌa jäyaꞌay piädaꞌagy cooc tyijy jaꞌa pooꞌxxiøø hajxy wyiingudsähgǿꞌøwät. Cab jaduhṉ ñäꞌä tøyyä. ");
INSERT INTO mirNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Cooc̈h jaduhṉ nDiosquex̱iä, páadyhøch cuhdujt nmøødä cooc̈h nmähanéꞌemät høxtä pooꞌxxiøøjootypaady ―nøm̱ä fariseoshajxy ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mänitä Jesús jadähooc tiøjtägøøyy tsajtøgooty. Jim̱ä jäyaꞌay hänajty tuꞌug cøꞌømaꞌad. ");
INSERT INTO mirNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jim̱ä fariseos jaꞌa Jesús hajxy hänajty miäheeꞌpnaꞌay pø jaanc̈h mäyajpaꞌamnaxaam̱b hänajty jeꞌe pooꞌxxiøøjooty. Wiinmahñdy hajxy hänajty yhøxtaaby nebiä Jesús hajxy yajtsumǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mänitä cøꞌømaꞌadpä ñämaayyä: ―Tänaayyøꞌøg. Miṉ yam̱ cujc tänaꞌaw ―nøm̱ä Jesús miänaaṉ̃. Mänitä mähdiøjc jaduhṉ quiudiuuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mänitä fariseoshajxy ñämaayyä: ―Nebiä cuhdujt myiṉ̃ coo hajxy ndúuṉämät pooꞌxxiøøjooty, hoy tøgä haxøøgä. Nej, jaduhṉä cuhdujt myiṉ̃ coo jäyaꞌay hajxy nyajtsóocämät pooꞌxxiøøjootiä, tøgä jaduhṉ myiṉ̃ coo jäyaꞌay hajxy nyaghóꞌcämädä ―nøm̱ä Jesús miänáaṉgumbä. Pero cabä fariseoshajxy waam̱b ñäꞌägä hadsooyy. ");
INSERT INTO mirNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mänit hajxy wyiinheeꞌppejtä, mäduhṉ̃tiä Jesús hajxy hänajty jiuhdänaawiädity. Jootmayhajpä Jesús hänajty coo jaꞌa fariseos jaꞌa cøꞌømaꞌadpä hajxy hänajty quiaꞌa näxuuc̈h. Cabä Jesús hänajty jiootcujcä. Mänitä mähdiøjc ñämaayyä: ―Xajtøw̱ yøꞌø mgøꞌø. Mänitä quiøꞌø jiaanc̈h xajtøøyy. Tuuṉä jaduhṉ ñäꞌä xajtøøyy, mänitiä quiøꞌø yhoyøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mänitä fariseoshajxy wyiimbijty. Mänit hajxy ñøcxy maa jaꞌa Herodes jiamiøødhajxiän. Jaꞌa Herodes, gobiernä hänajty tiuum̱by. Mänitä fariseoshajxy nägøx̱iä quiojyquiapxyhajty nebiä Jesús hajxy yajyaghoꞌogǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Coo jaꞌa Jesús hajxy jiiby chohṉ̃ tsajtøgooty møødä jiamiøødtøjc, mänit hajxy jim̱ ñøcxtägajch maa jaꞌa mejypiaꞌajän. Jim̱ä jäyaꞌayhajxy hänajty may piawädity. Galilea hajxy hänajty chooñ. ");
INSERT INTO mirNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tøø jaꞌa mädiaꞌagy hänajty wiaꞌxy wiinduhm̱yhagajpt coo jaꞌa Jesús madiuꞌu hoy‑yagjuøøñäjatypä hänajty yajcähxøꞌøgy. Coo jaꞌa jäyaꞌay jaꞌa mädiaꞌagy hajxy jaduhṉ miädooyy wiinduhm̱yhagajpt, mänitä Jesús jäyaꞌay may ñämejtsä. Wiinduhm̱yhagajpt hajxy hänajty chooñ, møød jim̱ Judeanaaxooty, møød jim̱ Jerusalén, møød jim̱ Idumea, møød jim̱ Jordánmøjnøøhawiimb, møød jim̱ Tiro, møød jim̱ Sidón. ");
INSERT INTO mirNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Coo jaꞌa paꞌamjäyaꞌayhajxy hänajty may tøø yajmøcpøgyii, paadiä Jesús hänajty jia wiꞌi ñähdonaꞌañii jaꞌa jäyaꞌayhajxy jaac paꞌammøødpä, ween hajxy jaduhṉ ñähwaatspä. Høxtä niyhanøꞌtsmújcäp hajxy hänajty. Mänitä Jesús jaꞌa jiamiøødtøjc ñämaayy coo barcohuung hajxy jim̱ nähix̱ hahixøꞌø miähäñáꞌawät, jaduhṉä Jesús jiiby paquiä piédät coo hänajty pianøꞌødsaꞌañii jaꞌa cuꞌug. ");
INSERT INTO mirNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jim̱ä jäyaꞌayhajxy hänajty wiädijpä jaꞌa møjcuꞌumøødpä. Homiaajä Jesús hajxy hänajty yhix̱y, mänitä Jesús hajxy hänajty wyiinjijcädaꞌagy, mänitä Jesús hajxy hänajty ñämaꞌay: ―Dios miic̈h xyHuunghajp ―jaduhṉä møjcuꞌumøødpähajxy hänajty wyiꞌi yaꞌaxy. ");
INSERT INTO mirNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mänit hajxy yhanehm̱ä coo jaꞌa Jesús hajxy quiaꞌa nägápxät majiäyaꞌayhagujc. Jaꞌa Jesús jaduhṉ hanehm̱. ");
INSERT INTO mirNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mänitä Jesús jim̱ ñøcxy tuṉguhduum. Mänitä Jesús jaꞌa jiamiøød miøjyaax̱y, pøṉ hänajty hoy quipxy miøødwäditaam̱by. Coo hajxy jim̱ quiooꞌty maa Jesús hänajtiän, ");
INSERT INTO mirNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","mänit hajxy nämajmetsc wyiinguejxä coo jaꞌa Jesús hajxy quipxy miøødwädítät, møød coo jaꞌa Diosmädiaꞌagy hajxy nøcxy yajwaꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Mänitä cuhdujt hajxy miooyyä coo jäyaꞌay hajxy yajnähwáꞌadsät, jaꞌa hajxy møjcuꞌumøødpä. ");
INSERT INTO mirNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jaduhṉä Jesús jaꞌa jiamiøødhajxy hänajty xiøhaty, jaꞌa hajxy nämajmetspä. Tuꞌug hänajty xiøhaty Simón. Jeꞌe jaꞌa Jesús yajxøbejt Pedro. ");
INSERT INTO mirNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jim̱ä Zebedeo yhuunghajxy hänajtypä, jaꞌa Santiago møødä Juan. Jueꞌe hajxy yajxødägøøyyä Boanerges. Jaduhṉ hänajty miädiaꞌagytiägøꞌøy coo hajxy hänajty paquiä jiaanc̈h tehm̱ yhawaꞌandaꞌagy nebiä häneejän. ");
INSERT INTO mirNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Jaꞌa hajxy hänajty jaac jim̱bä, jaduhṉ hajxy hänajty xiøhaty Andrés, møødä Felipe, møødä Bartolomé, møødä Mateo, møødä Tomás, møød Santiago, jaꞌa Alfeo yhuung, møødä Tadeo, møødä Simón, jaꞌa hänajty xøhajpä jaꞌa celote. ");
INSERT INTO mirNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jaꞌa miämajmetspä hänajty xøhajp Judas Iscariote. Jeꞌe jaꞌa Jesús cujecy tooꞌc; jaꞌa Jesús miädsiphajxy cøꞌødägøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mänitä Jesúshajxy ñøcxy maa tiøjcän møødä jiamiøødhajxy. Mänitä jäyaꞌayhajxy may miéjtscumbä maa jaꞌa Jesúshajxy hänajtiän. Paadiä Jesúshajxy hänajty quiaꞌa näbaadǿøyyäxä mänaa hajxy jaduhṉ quiáyät møødä jiamiøød, coo jaꞌa paꞌamjäyaꞌayhajxy hänajty wyiꞌi yhadsipy coo jaꞌa piaꞌamhajxy yajnájxäxät. ");
INSERT INTO mirNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Coo jaꞌa Jesús jaꞌa jiujy miäguꞌughajxy jaduhṉ miädoyhajty coo jaꞌa Jesús hänajty jiaanc̈h tehm̱ yhadsibyii, mänitä Jesús hajxy ñämejch. Mänitä Jesús hajxy jia yajnøcxaaṉ̃ hadsip. Jaduhṉ hajxy hänajty miänaꞌañ cooc tyijy jaꞌa Jesús hänajty tøø quiuhhiṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mänitä hänaꞌc‑hajxy näjeꞌe quiädaacy, jaꞌa Diosmädiaꞌagy hajxy hänajty nax̱y yajnähixøøbiä tsajtøgooty. Jerusalén hajxy hänajty tøø chohṉdaꞌagy. Mänit hajxy miänaaṉ̃: ―Yøꞌø Jesús, puhbéjtäp yøꞌø jaꞌa møjcuꞌugong, paadiä mäjaa miøødä coo jäyaꞌay yajnähwaꞌac̈h, jaꞌa hajxy møjcuꞌumøødpä. Haa caꞌa, jaꞌa møjcuꞌugong jaꞌa møjcuꞌu hajxy wyiindsøṉhajpiä ―nøm̱ä Jesús wyiingapxpejtä. ");
INSERT INTO mirNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","26","Mänitä yajnähixøøbiädøjc‑hajxy miøjyaax̱ä. Mänitä Jesús tiägøøyy yajnähixøøbiä cuento yajmäbaadyhaam. ―Coo jäyaꞌayhajxy ñimiädsibøꞌøwǿøjät quipxyjiaty tuꞌcajpt, cab hajxy hoy ñimiøødtunáaṉänä. Jaanä jaduhṉduhm̱bä, coo jäyaꞌayhajxy ñimiädsibøꞌøwǿøjät quipxyjiaty tuꞌqueꞌex, cab hajxy hoy tøgooty ñimiøødhidáaṉänä. Jaanä jaduhṉduhm̱bä, coo jaꞌa møjcuꞌuhajxy ñimiädsibøꞌøwǿøjät quipxyjiaty møjcuꞌu, cab hajxy jaduhṉ hoy wiäditaaṉnä. Cǿxäp hajxy jaduhṉ quiuhdägoyy. Jaduhṉä tøyhajt hajxy mmøødhádät cooc̈hä møjcuꞌugong xquiaꞌa puhbety. ");
INSERT INTO mirNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Jaanä jaduhṉduhm̱bä, ni pøṉä møcjäyaꞌay hoy mgaꞌa mäméedsät tijaty jiiby miøød tiøgooty. Mänit mäbøcypiä coo jawyiin mgøꞌøxots mdecyxiódsät, mänítäts hoy mmäméedsät. ");
INSERT INTO mirNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Tøyhajt jaduhṉ coo jaꞌa Dios jäyaꞌay miämeeꞌxaꞌañ nebiatiä pojpä cädieey hajxy miøødä, waam̱batiä Dios hajxy tøø miägapxtägoy. ");
INSERT INTO mirNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero pøṉä Dioshespíritu tøø miägapxtägoy, jeꞌe mäbøcypiä, cab hajxy mänaa miämeeꞌxáaṉänä. Homiänaaxøø jaꞌa piojpä quiädieey hajxy miäwäditaꞌañ ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Paadiä Jesús jaduhṉ miänaaṉ̃, coo hänajty tøø ñänømyii cooc tyijy jaꞌa møjcuꞌugong hänajty miøødwädity. ");
INSERT INTO mirNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Jim̱ä Jesús hänajty miädiaꞌagyñä, mänitä tiajhajxy miejch møødä piuhyaꞌayhajxy. Coo jäyaꞌayhajxy hänajty jiaanc̈h tehm̱ miayyä tøgooty, paadiä tiajhajxy tøguum miähmøøyy. Mänitä capxy hajxy quiejxy tøgooty coo jaꞌa Jesús ween yhuuc pädsøm̱y. Jiibiä Jesús jäyaꞌay hänajty may jiuhhäñaawiädityii tøgooty. Mänit hajxy miänaaṉ̃: ―Xim̱ä mdaj xwyiꞌi yajtøy møødä mbuhyaꞌayhajxy møødä mbuhdoꞌoxyhajxy. ");
INSERT INTO mirNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mänitä Jesús yhadsooyy: ―Pǿṉhøch ndajhajpy; pǿṉhøch nbuhyaꞌayhajpy. ");
INSERT INTO mirNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Mänitä Jesús jäyaꞌay wyiinheeꞌppejty mäduhṉ̃tiä hänajty jiuhhäñaawiädityii. Mänit miänaaṉ̃: ―Pønjátyhøch nDeedy miädiaꞌagy cudiúuṉäp, jeꞌec̈h ndajhajpy, jeꞌec̈h nbuhyaꞌayhajpy ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mänitä Jesús jadähooc yhädáaccumbä mejypiaꞌa Diosmädiaꞌagy‑yajwiingapxøøbiä. Mänitä jäyaꞌayhajxy may miejch maa jeꞌe hänajtiän. Coo hawaꞌadspä hänajty jim̱ quiaꞌa hity puꞌuwiing, paadiä Jesús barcohuungooty tiägøøyy mejywyiing. Mänit jiiby yhäñaaguiädaacy. Jim̱ä jäyaꞌayhajxy miähmøøyy puꞌuwiing hamädoow̱hijpä waam̱batiä Jesús hänajty miädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mänitä Jesús tiägøøyy yajnähixøøbiä cuento‑yajmäbaadyhaam. ");
INSERT INTO mirNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Huuc mädow̱ hajxy, mänitä jäyaꞌay tuꞌug tiuꞌubøjcy trigowøjpä. ");
INSERT INTO mirNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Näjeꞌe trigotøømd quiahy tuꞌhaam. Mänitä muuxyhajxy hoy pyiwøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wiingtuumä trigotøømd hoy quiáhgumbä tsaajoot maa naax̱ hänajty quiaꞌa møødän. Paquiä trigotøømd miujxy coo naax̱ hänajty quiaꞌa cøøcä. ");
INSERT INTO mirNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero nägooyyä xøø piädsøøm̱y, cøjxä trigohuung tiøꞌøc̈h coo tyicts hänajty cøøc tøø quiaꞌa hädaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wiingtuum hoy quiáhgumbä maa hapty hänajty jiaanc̈h tehm̱ miayyän. Coo hapty jaduhṉ yeeꞌcy, cøjx jaduhṉ ñähdänaꞌayii. Ni tiøøm jaꞌa trigo quiaꞌa pejty. ");
INSERT INTO mirNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wiingtuum hoy quiáhgumbä maa jaꞌa naax̱ hänajty jiaanc̈h tehm̱ tiooꞌquiän. Jaanc̈h tehm̱ yhoyøøyy jaꞌa trigo jim̱. Näjeꞌe hiiꞌxmajcpajc miøødä tuꞌwipä; näjeꞌe tägøøghiiꞌxpajc miøødä; näjeꞌe mägoꞌxpajc miøødä tuꞌwipä. ");
INSERT INTO mirNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mänitä Jesús jiaac mänaaṉ̃: ―Pøṉ hädaaduhṉ wiinjuøøby, wéenhøch nmädiaꞌagy xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Coo majiäyaꞌayhajxy wyiimbijty, jim̱ä Jesús jaꞌa jiamiøød miøødmähmøøyy, jaꞌa hajxy hänajty nämajmetspä, møødä wiingjäyaꞌay jaꞌa näwéeṉ̃tiäbä. Mänitä Jesús ñämaayyä coo quiapxtǿwät waam̱baty hänajty tøø miädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mänitä Jesús yhadsooyy: ―Jaduhṉä Dios jioot chocy coo mijts mwiinjuǿꞌøwät nebiä miäjaa yajcähxøꞌøgaꞌañ. Hijty, cap pøṉ hijty wyiinjuøꞌøy. Yøꞌø wiinghänaꞌc‑hajxy, ni yøꞌøhajxy quiaꞌa wiinjuøꞌøy. Páadyhøch yøꞌø hänaꞌc‑hajxy nyajnähixøꞌøy cuento‑yajmäbaadyhaam. ");
INSERT INTO mirNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hoy hajxy jia mädoy, cab hajxy wyiinjuøꞌøy; jaduhṉä Dios hajxy quiaꞌa jøjpøgǿꞌøwät; jaduhṉä piojpä quiädieey hajxy quiaꞌa yajnähwáatsäxät. ");
INSERT INTO mirNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mänitä Jesús jiaac mänaaṉ̃: ―Mijts, pø cab hajxy jaduhṉ hoy mwiinjuøꞌøwaꞌañ waam̱bátyhøch naam̱nä tøø ngapxy cuento‑yajmäbaadyhaamä, ni jaduhṉ hajxy hoy mgaꞌa wiinjuøꞌøwaꞌañ waam̱bátyhøch njaac yajmøødmädiaꞌagaꞌañ cuento‑yajmäbaadyhaam. ");
INSERT INTO mirNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jaꞌa jäyaꞌay trigowøjpä, jaduhṉ mäwíinäts miäbaady nebiä Diosmädiaꞌagy‑yajwaꞌxpän. ");
INSERT INTO mirNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jaꞌa trigotøømd cáhw̱äbä tuꞌhaam, jaduhṉ mäwiin miäbaady nebiä jäyaꞌay jaꞌa Diosmädiaꞌagy hajxy näjeꞌe jia mädoyyän. Pero nägooyyä jaꞌa møjcuꞌu ñämech, mänitiä hajxy yagjahdiägóoyyäxä waam̱baty hajxy tøø yajwiingapxøꞌøyii. ");
INSERT INTO mirNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jaꞌa tøømd cáhw̱äbä tsaajoot, jaduhṉ mäwiin miäbaady nebiä jäyaꞌay jaꞌa Diosmädiaꞌagy hajxy näjeꞌe paquiä miäbøquiän, Jaanc̈h tehm̱ xiooṉdaacp hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero cab hajxy jejcy miäbøcy. Nägooyyä hajxy jaduhṉ chaac̈htiuñii jaꞌa Diosmädiaꞌagyquiøxpä, mänit hajxy ñajtshixøøñä. ");
INSERT INTO mirNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jaꞌa tøømd cáhw̱äbä maa hapty jiaanc̈h tehm̱ miayyän, jaduhṉ mäwiin miäbaady nebiä jäyaꞌay jaꞌa Diosmädiaꞌagy hajxy näjeꞌe jia mäbøquiän. ");
INSERT INTO mirNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero jiaanc̈h tehm̱ jiahmiejchp hajxy jaduhṉ jaꞌa hädaa yaabä naax̱wiimbä. Jeꞌe hajxy jaduhṉ wyiꞌi ñädajpy wyiꞌi ñämaaby neby hajxy hoy chänáꞌawät, neby hajxy hoy yhäyówät, møød maa mäyøøhadyiibän. Yajtägoobiä Diosmädiaꞌagy hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jaꞌa tøømd cáhw̱äbä maa naax̱ jiaanc̈h tehm̱ tiooꞌquiän, jaduhṉ mäwiin miäbaady nebiä jäyaꞌay jaꞌa Diosmädiaꞌagy hajxy näjeꞌe hamuumduꞌjoot miäbøquiän. Hoy hajxy jiaanc̈h tehm̱ quiudiuṉ̃. Jaduhṉ hajxy miäbaady nebiä trigo hiiꞌxmajcpajc miøødän tuꞌwipä, møød nebiä tägøøghiiꞌxpajc miøødän, møød nebiä mägoꞌxpajc miøødän tuꞌwipä. ");
INSERT INTO mirNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mänitä Jesús jiaac mänaaṉ̃: ―Coo jäyaꞌay jøøn hajxy quiudøøꞌxøꞌøy, cøxp hajxy yujcoṉ̃. Cab hajxy jiiby quiuhjupy cubetapaꞌc. Ni jiiby hajxy quiaꞌa pädaꞌagy maabejtpaꞌc. ");
INSERT INTO mirNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jaanä jaduhṉduhm̱bä, tijaty jaduhṉ hijp yuꞌuc̈h, tsipcøxp jaduhṉ quiøx̱y cähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pøṉ jaduhṉ wiinjuøøby, wéenhøch nmädiaꞌagy xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mänitä Jesús jiaac mänaaṉ̃: ―Huuc wiinjuøꞌøw hajxy nébiøch cham̱ nyajmøødmädiaꞌagaꞌañ; pøṉ hädaa mädiaꞌagy hoy wiinjuøøby, maas hoy jaduhṉ jiaac yajwiinjuøꞌøwaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pǿṉhøch nmädiaꞌagy tøø xmiäbøjcä, jeꞌec̈h njaac yajnähixøꞌøwaam̱by. Pero pǿṉhøch nmädiaꞌagy tøø xquiaꞌa mäbøjcä, cábøch jeꞌe tii nyajnähixøꞌøwaaṉnä. Høxtä jiahdiägoyyaam̱by jeꞌe mädyii tyijy tøø jia wiinjuøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mänitä Jesús jiaac mänaaṉ̃: ―Coo jaꞌa Dios jaꞌa miøcmäjaa yajcähxøꞌøgaꞌañ, jaduhṉ mäwiin miäbaady nebiä jäyaꞌay ñiꞌibiän. ");
INSERT INTO mirNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Coo ñiippädøꞌøy, mänit nøcxy miaanä coo tøø quioodsøꞌøy. Cujaboom, coo jiobøꞌøy, mänit piädǿꞌcumbä. Pero cab jaduhṉ ñajuøꞌøy nebiä tøømd miux̱y. Hix̱, hamdsoo jaꞌa tøømd miux̱y yeegy. ");
INSERT INTO mirNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jaꞌa tøømd, jiibiä miäjaa piaady naaxooty. Coo miux̱y, mänit yeegy. Coo yeegy, mänit piøjy. Coo piøjy, mänit tiøømbety. Coo tiøømbety, mänit miäjay. ");
INSERT INTO mirNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Coo miäjay, mänit hajxy chucy. Tøø jaduhṉ yhabaatnä coo hajxy yajpädǿꞌøgät. ");
INSERT INTO mirNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mänitä Jesús jiaac mänaaṉ̃: ―Nebiaduhṉ njaac yajmäbáatämät coo jaꞌa Dios jaꞌa miøcmäjaa jaduhṉ yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Coo jaꞌa Dios jaꞌa miøcmäjaa yajcähxøꞌøgaꞌañ, jaduhṉ mäwiin miäbaady nebiä mostazapajcän. Jaanc̈h tehm̱ chay jaꞌabiꞌ mostazapajc jaduhṉ. Ni mädyii hujts piajc jaduhṉ quiaꞌa tsayyä nebiä habiꞌ mostazapajc chayyän. Pero coo mníꞌibät, jaanc̈h tehm̱ piaquiä jaduhṉ yeegy cøxp. Mäjatyjaty yhaaꞌx yeegy. Høxtä hoyyä muuxyhajxy jim̱ pieꞌeñ yhaaꞌxjooty. ");
INSERT INTO mirNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Haagä hädaaduhm̱bä cuento‑yajmäbaadyhaamä Jesús jaꞌa cuꞌug hänajty yajwiingapxøꞌøy, mäduhṉ̃tiä hajxy hänajty hoy wyiinjuøꞌøwaꞌañ. Pero coo jaꞌa cuꞌug hänajty tøø wyiimbijnä, mänitä Jesús jaꞌa jiamiøød hawiing caꞌxy quiapxtøønä, jaꞌa hajxy hänajty nämajmetspä. ");
INSERT INTO mirNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Coo chuujøøyy, mänitä Jesús jaꞌa jiamiøød ñämaayy: ―Tsøc hajxy jáam̱äm barcojooty; jam̱ hajxy jim̱haamby mejyhawiimb. ");
INSERT INTO mirNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jiibiä Jesúshajxy hänajty yhäñaꞌay barcojooty møødä jiamiøødhajxy. Mänit hajxy tiuꞌubøjcy. Jiibiä jäyaꞌayhajxy näjeꞌe piaduꞌubøjpä wiingbarcojooty. Pero jaꞌa majiäyaꞌay, jim̱ hajxy miähmøøyy mejypiaꞌa. ");
INSERT INTO mirNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mänit møc tiägøøyy pojpä. Mänitä mejy tiägøøyy jaꞌtspä. Mänitä barco ñähjaꞌtspejtä. Mänitä nøø com̱ tiägøøyy barcojooty. Høxtä hujts jaꞌa barco jaduhṉ. Quinaam̱bä barco hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero jaꞌa Jesús, maab hänajty jeꞌe jiiby barcohøjxhaam. Cuhnøꞌøxøꞌøy hänajty jiiby miaꞌay. Jaanc̈h tehm̱ chähgøøbiä Jesús jaꞌa jiamiøødhajxy hänajty. Mänitä Jesús hajxy hoy yux̱y. Mänitä Jesús ñämaayyä: ―Wiindsǿṉ, nej, caj mdajy mmayyä coo hajxy nguhdägoyyáaṉämä. ");
INSERT INTO mirNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Coo jaꞌa Jesús miaꞌabiädøꞌcy, mänitä poj yhojy møødä mejy coo yuungǿꞌøwät. Mänitä poj jiaanc̈h mooṉ̃; møødä mejy, yuungøøyy jeꞌebä. ");
INSERT INTO mirNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mänitä Jesús jaꞌa jiamiøød ñämaayy: ―Tii hajxy hijty coo mwiꞌi chähgøꞌøy. Nej, cab hajxy mmäbøquiä cooc̈h møcmäjaa nmøødä. ");
INSERT INTO mirNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jaanc̈h tehm̱ chähgøøby hajxy hänajty. Mänit hajxy hameeꞌch ñiñämaayyä: ―Pøṉädaꞌa yøꞌø; høxtä poj møødä mejy, cudiúuṉäxäbä miädiaꞌagy yøꞌø. ");
INSERT INTO mirNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mänitä Jesúshajxy jim̱ miejch mejyhawiimb, maa jaꞌa naax̱ hänajty xiøhatiän Gerasa. ");
INSERT INTO mirNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Coo hajxy miänajcy barcojooty, jim̱ä jäyaꞌay hänajty tuꞌug tiänaꞌay jäguem̱juøøby. Møjcuꞌu hänajty tøø yajtägøꞌøyii. ");
INSERT INTO mirNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jutjooty hänajty chänaꞌay maa jaꞌa hoꞌogyjiäyaꞌay hajxy hänajty ñaax̱tägøꞌøyän. Jaanc̈h tehm̱ miøcä craa hänajty. Ni cadenahaamä jäyaꞌayhajxy hänajty hoy quiaꞌa cøꞌøxots quiaꞌa tecyxiodsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mayhooc hajxy hänajty tøø jia cøꞌøxoch tøø jia tecyxioch cadenahaam. Pero wyiꞌi yaghapodøøbiä cadena hänajty. Ni pøṉ hänajty quiaꞌa mäjädaꞌagaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Xøømdsuhm̱ hänajty jim̱ yaꞌaxy jiocy cabäsantäjooty møød tunjooty. Nax̱y hänajty tsaahaam hamdsoo ñic̈hugyii. ");
INSERT INTO mirNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Coo jaꞌa Jesús jaduhṉ yhijxä jäguem̱, mänit päyøꞌøguiä ñänøcxä. Mänit hoy wyiinjijcädaꞌagyii. ");
INSERT INTO mirNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Mänitä Jesús jaꞌa møjcuꞌu ñämaayy: ―Juaꞌads miic̈h jiiby maa yøꞌø craajän. Mänitä møjcuꞌu møc yaax̱y: ―Miic̈h Jesús, miic̈hä Dios xyHuunghajp, jaꞌa jim̱ tsajpootypä. Nej mnijiäwøꞌøyii møød høøc̈hcøxpä. Tuṉä mayhajt, caꞌac̈h xchaac̈htiuṉ̃. Dios, cøxp jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mänitä Jesús jaꞌa møjcuꞌu miäyajtøøyy: ―Tii mxøhaty. Mänitä møjcuꞌu yhadsooyy: ―Legiónghøch nxøhaty. Páadyhøch jaduhṉ nxøhaty coo højts jaduhṉ njaanc̈h tehm̱ ñämayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mänitä Jesús miänuuꞌxtaacä coo jaꞌa møjcuꞌuhajxy quiaꞌa høxquexǿøjät jäguem̱. ");
INSERT INTO mirNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","13","Jim̱ wiingóṉ maa jaꞌa Jesúshajxy hänajtiän, jim̱ mejypiaꞌa, jim̱ä hädsøm̱hajxy hänajty may yuumydiajy tuṉmøjc. Nämejtsmil hajxy hänajty wiädity. Mänitä Jesús jadähooc miänuuꞌxtaacä coo jaꞌa møjcuꞌuhajxy ween jim̱ quiexyii maa jaꞌa mayhädsøm̱än, weenä hädsøm̱hajxy nøcxy yajtägøꞌøyii. Mänitä møjcuꞌuhajxy jiaanc̈h quejxä maa jaꞌa hädsøm̱än. Mänitä craa ñähwaach, jaꞌa hänajty tøø miøjcuꞌuyajtägøꞌøyíijäbä. Mänitä hädsøm̱hajxy cøjx yajtägøꞌøyii. Mänit hajxy päyøꞌøguiä yhädaacy mejjiooty. Cøjx hajxy jiiby ñøøjiꞌxøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jaꞌa hänaꞌc‑hajxy hänajty jim̱ hädsøm̱güeendähajpä, cøjx hajxy piäyøꞌøgy. Hoyyä mädiaꞌagy hajxy jim̱ yajwaꞌxy cajptooty møød cajptpaꞌa neby hänajty tøø jiadyii tøø tiuñii. Coo jaꞌa cuꞌughajxy jaduhṉ miädooyy, mänit hajxy hoy yhix̱y. ");
INSERT INTO mirNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Coo hajxy jim̱ miejch maa jaꞌa Jesús hänajtiän, mänitä craa hajxy yhijxy, jaꞌa hijty paꞌammøødpä, coo hänajty tøø ñähwáatsänä jaꞌa møjcuꞌu. Jim̱ jeꞌe hänajty witmøød yhäñaañä. Coo hijty piaꞌammøødä, nähwaꞌads høxwaꞌads hijty wiädity. Tøø hänajty wyiinmahñmejtsnä. Jaanc̈h tehm̱ yagjuøøyy jaꞌa cuꞌughajxy jaduhṉ coo jaꞌa craa hajxy yhijxy coo jaꞌa piaꞌam hänajty tøø ñähwáatsänä. Høxtä tsähgøøyy hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mänit hajxy cøjx yajmøødmädiaꞌagyii neby hänajty tøø jiadyii tøø tiuñii. Jaꞌa jäyaꞌayhajxy jaduhṉ híjxäbä coo jaꞌa hädsøm̱ jaꞌa møjcuꞌu hajxy yajtägøøyyä, jeꞌedshajxy jaduhṉ mädiaac. ");
INSERT INTO mirNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mänitä cuꞌug jaꞌa Jesús hajxy miänuuꞌxtaacy coo jim̱ chóonät maa jaꞌa quiajpthajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Coo jaꞌa Jesús hänajty wyiimbidaaṉnä barcojooty, mänit jaduhṉ ñämaayyä coo ween piaduꞌubøgyii. Jaꞌa craa jaduhṉ mänaaṉ, jaꞌa piaꞌam hänajty tøø yajnájxäxäbä. ");
INSERT INTO mirNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mänitä Jesús jaꞌa craa ñämaayy: ―Caj, caꞌac̈h xpianøcxy. Nøcx jim̱ maa jaꞌa mdøjcän, maa jaꞌa mjujy maa jaꞌa mmäguꞌugän. Nøcxä mädiaꞌagy yajwaꞌx coo miic̈hä Dios tøø xñäxuuc̈h, coo miic̈hä Dios jaꞌa møjcuꞌu tøø xyajnähwaꞌac̈h. ");
INSERT INTO mirNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mänitä craa jiaanc̈h nøcxy maa jaꞌa tiøjcän. Mänitä mädiaꞌagy jim̱ tiägøøyy yajwaꞌxpä maa naax̱ hänajty xiøhatiän Decápolis. Jaduhṉ jeꞌe miädiaꞌagytiägøꞌøy majc‑cajpt. Jaduhṉä miädiaꞌagy hänajty yajwaꞌxy coo jaꞌa Jesús jaꞌa mähdiøjc møjcuꞌumøødpä hänajty tøø yajnähwaꞌac̈h. Coo jaꞌa cuꞌughajxy jaduhṉ miädooyy, mänit hajxy jiaanc̈h tehm̱ yagjuøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mänitä Jesúshajxy wyiimbijnä barcojooty møødä jiamiøødhajxy. Coo hajxy jim̱ miéjtscumbä mejyhawiimb maa hajxy hänajty tøø chohṉdaꞌaguiän, mänit hajxy jim̱ biarcomänajcy mejypiaꞌa. Mänitä Jesús jäyaꞌay may ñämejtsä. ");
INSERT INTO mirNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mänitä Jesús jäyaꞌay tuꞌug wyiinjijcädaacä. Jairo hänajty xiøhaty. Jeꞌe hänajty jim̱ tuum̱b wiindsǿṉ maa jaꞌa tsajtøjcän. ");
INSERT INTO mirNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mänitä Jesús miänuuꞌxtaacä: ―Wiindsǿṉ, møjtáꞌagyhøch nhuung. Toꞌoxiänaꞌc jeꞌe. Majmetscjumøjt miøødä. Jám̱høch nhuung cøꞌønähgájpäc, ween jaduhṉ miøcpøcy ―nøm̱ä Jairo miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mänitä Jairo jaꞌa Jesús miødhajty. Jim̱ä jäyaꞌay jaꞌa Jesús hajxy hänajty may pianøꞌøc̈h piabooñ. ");
INSERT INTO mirNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jim̱ä tajjäyaꞌay hänajty tuꞌug paꞌammøød majiäyaꞌayhagujc. Majmetscjumøjtä ñøꞌty hänajty tøø xieeꞌxy jabom̱‑jabom̱. ");
INSERT INTO mirNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tøø jaꞌa mähdiøjc hänajty jejcy jia yajtsooyøꞌøy maa jaꞌa doctorhajxiän. Pero cábädsä piaꞌam hänajty ñäꞌägä yajnájxäxä. Tøø jaꞌa xiädøꞌøñ hänajty quiøjxnä tii jaduhṉ ñäꞌä jaac yajniñämäjuyøꞌøwǿøjäp. Coo hänajty jaduhṉ ñäꞌägä yajtsooyøꞌøy tehṉgajnä, maas hanax̱iä piaꞌam hänajty jaduhṉ jiaac tehm̱ miøjtaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Coo jaꞌa mähdiøjc jaduhṉ miädoyhajty coo jaꞌa Jesús hänajty wiädity mäbaꞌamyajnajxpä, mänit jaduhṉ wyiinmaayy quiopcooty: “Cooc̈h yøꞌø wyit häyaa nnäꞌä nähdóoṉät, náxäbøch nbaꞌamädaꞌa häyaajä.” Mänitä Jesús jiøguyohdiägøøyyä. Mänitä wyit jiaanc̈h nähdóoṉäxä. ");
INSERT INTO mirNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mänitiä tajjäyaꞌay ñøꞌty jiaanc̈h hadujcy. Mänit ñijiäwøøyyä coo jaꞌa piaꞌam hänajty tøø ñax̱y. ");
INSERT INTO mirNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mänitä Jesús ñijiäwøøyyä coo tuꞌjäyaꞌay hänajty tøø miøcpøcy jaꞌa miäjaahaam. Mänitä Jesús jaꞌa jäyaꞌay cøjx wyiinheeꞌppety. Mänit miänaaṉ̃: ―Pǿṉhøch nwit tøø xñähdooṉä. ");
INSERT INTO mirNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mänitä jiamiøødhajxy yhadsooyy: ―Tii jaduhṉ coo myajtøy pø tøø miic̈h jäyaꞌay mwit xñähdooṉä. Haa caꞌa, majiäyaꞌay hajxy jaduhṉ xwyiꞌi pianǿꞌtsämä ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero jim̱ä Jesús hänajty yhøxtaꞌayñä pøṉä wyit hänajty tøø ñähdóoṉäxä. ");
INSERT INTO mirNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jaꞌa tajjäyaꞌayä, jaanc̈h tehm̱ chähgøøby hänajty jeꞌe. Paady hänajty chähgøꞌøy coo hänajty ñajuøꞌøy neby hänajty tøø miøcpøcy. Mänitä Jesús hoy wyiinjijcädaꞌagyii tsäyúuyyäp. Mänitä tajjäyaꞌay ñägapxy neby hänajty tøø miøcpøcy. ");
INSERT INTO mirNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mänitä Jesús miänaaṉ̃: ―Huung, paady miic̈h mbaꞌam tøø ñax̱y coo tøø mmäbøcy cooc̈h mäjaa nmøødä cooc̈hä jäyaꞌay tøy njaanc̈h yajpaꞌamnax̱y. Nøcxnä jootcujc. ");
INSERT INTO mirNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jim̱ä Jesús hänajty miädiaꞌagyñä, mänitä jäyaꞌayhajxy näjeꞌe miejch. Jim̱ hajxy hänajty tøø chohṉdaꞌagy maa jaꞌa Jairo tiøjcän. Mänitä Jairo ñämaayyä: ―Tøø jaꞌa mhuung yhoꞌnä. Caꞌa Jesús mhadsijpnä. Tii jaduhṉ jim̱ ñäꞌä jaac túnäp. Tøø jaꞌa mhuung yhoꞌnä. ");
INSERT INTO mirNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Coo jaꞌa Jesús jaduhṉ yhamädoonajxy, mänitä Jairo ñämaayyä: ―Caꞌa mgaꞌa mäbøcy. Caꞌa mjootmayhaty ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mänitä Jesús miänaaṉ̃ coo pøṉ jim̱ quiaꞌa panǿcxät maa jaꞌa Jairo tiøjcän. Jagóoyyägä Pedrohajxy jim̱ ñǿcxät møødä Santiago møødä Juan, jaꞌa Santiago piuhyaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Coo hajxy jim̱ miejch maa jaꞌa Jairo tiøjcän, jaanc̈h tehm̱ jiøøby jaanc̈h tehm̱ yaax̱pä jäyaꞌayhajxy hänajty jim̱. ");
INSERT INTO mirNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mänitä Jesúshajxy tiøjtägøøyy. Mänitä Jesús miänaaṉ̃: ―Cajxä yøꞌø toꞌoxiänaꞌc ñäꞌä hóꞌoguiäbä. Tii hajxy coo mwiꞌi jiøꞌøy coo mwiꞌi yaꞌaxy. Näꞌä maab yøꞌøduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Coo jaꞌa Jesús jaduhṉ miänaaṉ̃, mänit ñäxiicä. Mänitä Jesús jaꞌa jäyaꞌay cøjx yhøxquejxpädsøm̱y tøghaguuy. Mänitä Jesús jaꞌa toꞌoxiänaꞌc hajxy ñänøcxy maa toꞌoxiänaꞌc hänajty quioꞌnaꞌayän, møødä Jesús jaꞌa jiamiøødhajxy, møødä toꞌoxiänaꞌcä tiaj tieedyhajxy. ");
INSERT INTO mirNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mänitä Jesús jaꞌa toꞌoxiänaꞌc wyidsøꞌcy. Mänit ñämaayy: ―Quixyhuung, pädøꞌøg. ");
INSERT INTO mirNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tuuṉä jaꞌa Jesús jaduhṉ ñäꞌä mänaaṉ̃, mänitiä toꞌoxiänaꞌc jiaanc̈h pädøꞌcy. Mänit yoꞌoyøꞌcy. Jiaanc̈h tehm̱ yagjuøøyy jaꞌa Jairohajxy jaduhṉ møødä Jesús jaꞌa jiamiøødhajxy. ");
INSERT INTO mirNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mänitä Jairohajxy yhanehm̱ä coo hajxy jaduhṉ quiaꞌa mädiáꞌagät coogä yhuung hänajty tøø jiujypiøcy. Mänit hajxy ñämáayyäbä coo yhuung hajxy yajcáyät. Jaꞌa Jesús jaduhṉ mänaaṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Coo jaꞌa Jesúshajxy jim̱ chóhṉgumbä møødä jiamiøødhajxy, mänit hajxy jim̱ ñøcxy maa jaꞌa cajpt hänajty xiøhatiän Nazaret. Jim̱ä Jesús hänajty ñäꞌägädä tsooñ. ");
INSERT INTO mirNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Coo jaꞌa pooꞌxxiøø yhabaaty, mänitä Jesús jim̱ ñøcxy maa jaꞌa tsajtøjcän. Mänit tiägøøyy yajnähixøøbiä. Coo jaꞌa cuꞌughajxy jaduhṉ miädooyy, mänit hajxy jiaanc̈h tehm̱ yagjuøøyy. Mänit hajxy tiägøøyy niñämáayyäbä: ―Maa yøꞌø craa mädiaꞌagy jaduhm̱bä tøø ñäꞌä maañ yhabøcy coo jaduhṉ jiaanc̈h tehm̱ jiaty jiaanc̈h tehm̱ ñajuøꞌøy, coo jaduhṉ hoy‑yagjuøøñäjaty yajcähxøꞌøgy. Haa caꞌa, højts nmägunaax̱hájtäm yøꞌøjä. ");
INSERT INTO mirNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Jeꞌe yøꞌø, jaꞌa hijty tsejtspä pujxpä. Jaꞌa María yhuung yøꞌø. Hajchhájtäp yøꞌø, jaꞌa Santiago, møødä José, møødä Judas, møødä Simón. Yaa jaꞌa piuhdoꞌoxyhajxy chänaꞌay maa højts ngajptän. Coo jaꞌa Jesús hänajty jim̱ chooñ Nazaret, paady hänajty jim̱ quiaꞌa mämøjøꞌøy quiaꞌa mämayøꞌøyii. ");
INSERT INTO mirNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Coo jaꞌa Jesús jaduhṉ miädooyy, mänit miänaaṉ̃: ―Homiaajä jaꞌa Dioswiinguex̱ypähajxy wyiingudsähgøꞌøyii. Jagooyyä hajxy jim̱ quiaꞌa wiingudsähgøꞌøyii maa yhamdsoo cajpthajxiän, maa yhamdsoo tøjc‑hajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Coo jaꞌa Jesús hänajty jim̱ quiaꞌa mämøjøꞌøy quiaꞌa mämayøꞌøyii, paady hänajty jim̱ madiuꞌu hoy quiaꞌa yajcähxøꞌøgaꞌañ. Nämets nädägøøquiä paꞌamjäyaꞌayhajxy jim̱ ñäꞌä maañ yajpaꞌamnajxä cøꞌønähgapyhaam. ");
INSERT INTO mirNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jiaanc̈h tehm̱ yagjuøøbiä Jesús hänajty jaduhṉ coo jaꞌa miädiaꞌagy jim̱ quiaꞌa jøjpøgǿøyyäxä. Mänitä Jesús jaꞌa mädiaꞌagy jim̱ tiägøøyy yajwaꞌxpä mäduhṉjatiä cajpthuung wiingoṉbä. ");
INSERT INTO mirNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mänitä Jesús jaꞌa jiamiøød wyiinguejxy, jaꞌa hajxy hänajty nämajmetspä, coo hajxy wiädítät cajpt‑cajpt, coo jaꞌa paꞌamjäyaꞌay hajxy yajnähwáꞌadsät, jaꞌa hajxy hänajty møjcuꞌumøødpä. Nämetscjaty hajxy hänajty wiäditaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mänitä Jesús jaꞌa jiamiøød jiaac nämaayy coo hajxy tii quiaꞌa mänǿcxät, ni tsajcaagy, ni morral, ni xädøꞌøñ. Jagooyyä yom̱ybiax̱y hajxy quiábät tuꞌuquiä. ");
INSERT INTO mirNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tuꞌtehṉ̃quiä cøꞌøg hajxy miänǿcxät møød tuꞌxojxyä wit. ");
INSERT INTO mirNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mänitä Jesús jiaac mänaaṉ̃: ―Coo hajxy jim̱ mmédsät homiädyii cajptä, jim̱ä tøjc hajxy tuꞌug myujwáꞌanät maa hajxy hänajty mmejtstaꞌagaꞌañän. Jim̱iä hajxy jaduhṉ mhídät. Cabä tøjc hajxy myajtägátsät. ");
INSERT INTO mirNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Majaty mijtsä cuꞌugä mmädiaꞌagy hänajty xquiaꞌa jøjpøgøꞌøwaaṉä, mänitä mdecy hajxy mwiinxit mwiinwóbät, weenä naaxoc jaduhṉ quiøx̱y caꞌay. Jaduhṉä hijxtahṉd miähmǿꞌøwät coo jaꞌa cuꞌugä Diosmädiaꞌagy hajxy hänajty tøø quiaꞌa jøjhadsowøꞌøy. Mänit hajxy jim̱ mdsóonät. ");
INSERT INTO mirNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mänitä Jesús jaꞌa jiamiøødhajxy tiuꞌubøjnä mädiaꞌagy‑yajwaꞌxpä. Jaduhṉä cuꞌug hajxy hänajty yajwiingapxøꞌøy coo jaꞌa Diosmädiaꞌagy hajxy piaduꞌubǿjnät, møød coo jaꞌa yhaxøøgwiinmahñdy hajxy ñajtshixǿøñät. ");
INSERT INTO mirNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mayyä jäyaꞌayhajxy hänajty yajnähwaꞌac̈hii, jaꞌa hajxy hänajty møjcuꞌumøødpä. Mayyä paꞌamjäyaꞌayhajxy hänajty yajmøcpøgyii coo hoṉ hajxy hänajty yajnähjaaxyii. ");
INSERT INTO mirNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jim̱ä Herodes hänajty guiobiernähaty maa jaꞌa naax̱ hänajty xiøhatiän Galilea. Mänitä Herodes miädoyhajty coo jaꞌa Jesús jaꞌa hoy‑yagjuøøñäjatypä hänajty yajcähxøꞌøgy. Mänitä Herodes miänaaṉ̃ cooc tyijy jaꞌa Juan mäyajnäbejpä tøø jiujypiøjtägach. Jaꞌa Juan, jeꞌe jaꞌa Herodes yhajodhajt cooc tyijy hänajty jeꞌe Jiesúsä; páadiägä hoy‑yagjuøøñäjatypä yajcähxøꞌøgy jaꞌa wyiinmahñdycøxpä, cooc tyijy hänajty tøø jiujypiøjtägach. ");
INSERT INTO mirNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wiingatiä jäyaꞌayhajxy hänajty miänaam̱bä. Näjeꞌe hajxy hänajty miänaꞌañ cooc tyijy Jesús hänajty jeꞌe yhElíasä. Näjeꞌe hajxy hänajty miänaam̱bä cooc tyijy jaꞌa Jesús hänajty wiädity nebiä jecyjiäyaꞌayhajxy hänajty tøø Dyiosmädiaꞌagy‑yajwaꞌxiän jegyhajty. ");
INSERT INTO mirNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero jaꞌa Herodes, tehṉgajnä jeꞌe hänajty miänaꞌañ cooc tyijy jeꞌe Jwiangä, jaꞌa hänajty tøø yajyoꞌpuxyíijäbä. Jeꞌeg tyijy jaduhṉ tøø jiujypiøjtägach. ");
INSERT INTO mirNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Hix̱, haxøøgä Herodes hänajty jiäyaꞌayhaty; jaꞌa yhamdsoo puhyaꞌay tioꞌoxiøjc hänajty miøødtsänáayyäp. Felipe jaꞌa Herodes piuhyaꞌay hänajty xiøhaty. Herodías jaꞌa Felipe tioꞌoxiøjc hänajty xiøhajpä, jaꞌa Herodes hänajty miøødtsänaabiä. Mänitä Juan jaꞌa Herodes yhojy: “Cab jaduhṉ yhoyyä coo jaꞌa mhamdsoo puhyaꞌay tioꞌoxiøjc jaduhṉ mmøødtsänáayyät.” Coo jaꞌa Herodes jaduhṉ yhojjä, paadiä Juan yajmajtsä. Mänitä Juan chuum̱ä. ");
INSERT INTO mirNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Cabä Herodías hänajty yhojwiøꞌøy coo jaꞌa Herodes jaduhṉ yhojjä, paadiä Herodías jaꞌa Juan hänajty jia wiꞌi yajyaghoꞌogaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Pero cabä Herodes hänajty jaduhṉ miänaꞌañ coo jaꞌa Juan yaghoꞌogǿøjät. Hix̱, wyiingudsähgøøbiä Herodes jaꞌa Juan hänajty. Ñajuøøbiä Herodes hänajty coo jaꞌa Juan hänajty jiaanc̈h tehm̱ yhoyhänaꞌcä. Jaanc̈h tehm̱ yhomiädoonä jaꞌa Herodes jaꞌa Juan miädiaꞌagy hänajty miädoow̱ä. Pero cabä Herodes hänajty ñajuøꞌøy neby jiatcǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Cabä Herodías wiinmahñdy hänajty ñäꞌägädä paady nebiä Juan yajyaghoꞌogǿøjät. Mänit yhabaaty coo jaꞌa Herodes xiøø hänajty jiadaꞌañii. Mänitä Herodes jaꞌa jiamiøødtøjc miøødcaayy miøødhuucy, møødä mioonsähajxy, møødä generalhajxy, møødä mäyøødøjc‑hajxy, jaꞌa hajxy hänajty jim̱ tsänaabiä Galilea. ");
INSERT INTO mirNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Jim̱ hajxy hänajty quiay yhuꞌugy, mänitä Herodías yhuung jiiby tiøjtägøøyy. Mänitä quix̱y tiägøøyy hejtspä pujpä. Jaanc̈h tehm̱ yajxóṉ yhejch piujty. Jaanc̈h tehm̱ xiooṉdaac jaꞌa Herodeshajxy jaduhṉ møødä wioybä wyichpä. Mänitä Herodes jaꞌa quix̱y ñämaayy: ―Tehm̱ tiøy nnämáꞌawät, høøc̈h yajmäyujwáaṉäc tii mdsogaam̱by, nmóꞌowäbøch miic̈h jeꞌe, hotyiijä, høxtä nmóꞌowäbøch miic̈h naax̱ cupc maac̈h yaa ngobiernähatiän. Paadiä Herodes jaduhṉ miänaaṉ̃, jaanc̈h tehm̱ xiooṉdaacp hänajty jaduhṉ coo jaꞌa quix̱y hänajty yajxóṉ yhech. ");
INSERT INTO mirNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mänitä quix̱y piädsøøm̱y. Mänitä tiaj hoy miäyajtøy tiig jaduhṉ yujwáꞌanäp. Mänitä Herodías wiinmahñdy piaaty nebiä Juan mäyajnäbejpä yajyaghoꞌogǿøjät. Mänitä yhuung ñämaayy coo jaꞌa Juan jaꞌa quiopc yujwáaṉäxät. ");
INSERT INTO mirNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mänitiä quix̱y jaꞌa Herodes hoy ñämaꞌay: ―Høøc̈hä Juan quiopc móoyyäc texyjooty. ");
INSERT INTO mirNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Coo jaꞌa Herodes jaduhṉ ñämaayyä, mänit jiaanc̈h tehm̱ jiootmadiägøøyy. Mänit jaduhṉ ñähadsooyy. Hix̱, tøø hänajty jaduhṉ miänaꞌañ cooc hänajty hoy ñäꞌä tiijä yegaꞌañ. Hix̱, tøø jaꞌa wioybä wyichpä hänajty jaduhṉ yajmädoy. ");
INSERT INTO mirNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mänitä Herodes jaꞌa mioonsä jiiby quiejxy pujxtøgooty coo jaꞌa Juan nøcxy yoꞌpuxyii. ");
INSERT INTO mirNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mänit hoy jiaanc̈h yoꞌpuxyii. Mänitä quix̱y jaꞌa Juan quiopc hoy yajcøꞌødägøꞌøyii texyjooty. Mänitä tiaj hoy mioodiägach. ");
INSERT INTO mirNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Coo jaꞌa Juan jiamiøødhajxy jaduhṉ miädoyhajty coo jaꞌa Juan hänajty tøø yaghoꞌogyii, mänitä Juan ñiꞌx hajxy hoy yajpädøꞌcä. Mänit hajxy hoy yajnaax̱tägøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mänitä Jesús ñämejtstägajtsä jaꞌa jiamiøød, jaꞌa hajxy nämajmetspä. Cøjxä Jesús yhawáaṉäxä, nebiaty hajxy hänajty tøø miäbaꞌamyajnax̱y, møød waam̱baty hajxy hänajty tøø yajnähixøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jaanc̈h tehm̱ miayyä Jesús jäyaꞌay hajxy hänajty ñämec̈hii. Wiimbijp hadøjpä majiäyaꞌayhajxy hänajty. Coo jaꞌa jäyaꞌayhajxy may wyiꞌi miech, paadiä Jesúshajxy hänajty quiaꞌa näbaadǿøyyäxä mäduhnajtä hajxy quiay yhúꞌugät. Mänitä Jesús miänaaṉ̃: ―Jam̱ hajxy paquiä póoꞌxäm wiingtuum maa majiäyaꞌay hajxy xquiaꞌa paadáaṉäm. ");
INSERT INTO mirNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mänitä Jesúshajxy tiägøøyy barcojooty. Tsohṉ hajxy jim̱än. Mänit hajxy jim̱ ñøcxy maa jaꞌa majiäyaꞌayhajxy hänajty quiaꞌa jadyhitiän. ");
INSERT INTO mirNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Coo jaꞌa Jesúshajxy jaduhṉ yhijxtuꞌubøjcä, mänitä majiäyaꞌayhajxy wyiꞌi piaduꞌubøjpä. Ñajuøøby hajxy hänajty jaduhṉ maa jaꞌa Jesúshajxy hänajty ñøcxaꞌañ. Päyøꞌøguiä hajxy jaduhṉ ñäꞌägä nøcxy. Jawyiin hajxy jim̱ ñäꞌägä mejch maa jaꞌa Jesúshajxy hänajty ñøcxiän. Wiinduhm̱yguiajpt hajxy hänajty chooñ. ");
INSERT INTO mirNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Coo jaꞌa Jesús jiiby piädsøøm̱y barcojooty, mänitä jäyaꞌay yaghixøøyy may. Mänit näxuuꞌtscapxy miøødhajty. Jaduhṉ yhijxy nej coo meeg wyiindsǿṉ caꞌa hijpän, coo jaꞌa Diosmädiaꞌagy hajxy hänajty quiaꞌa yajnähixøꞌøyii. Mänitä Jesús madiuꞌu tiägøøyy yajnähixøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tøø hänajty chuujøøñä. Mänitä Jesús jaꞌa jiamiøød ñämejtsä. Mänitä Jesús ñämaayyä: ―Jueꞌe jaduhṉ yaa, pactuum. Cabä cajpt yaa maa jaꞌa cuꞌug quiaayyøøc hajxy häyaa jiúyät. Tøø jaduhṉ hoyhoy jiaanc̈h tehm̱ chuujøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nämaꞌaw yøꞌø cuꞌug, ween hajxy nøcxy quiayhøxtaꞌay maa jaꞌa cajpt yaa wiingoṉbän ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mänitä Jesús yhadsooyy: ―Tsøg hajxy näꞌägä yajcáayyäm højtshájtäm. Mänit hajxy yhadsóogumbä: ―Haa tii hajxy jaduhṉ nhuuc näꞌä yajcáayyämbäp. Cajx näꞌä caayyøøcpä näꞌä huucøøcpä. Nej, jaduhṉ miic̈h mmänaꞌañä coo højts tsajcaagy nøcxy njuy mejtsmägoꞌx denario ―nøm̱ä Jesús jiamiøød ñämáayyägumbä. ");
INSERT INTO mirNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mänitä Jesús miänáaṉgumbä: ―Huuc mäyajtøw̱ yøꞌø cuꞌug pøṉ caayyøøc møød. Pønjaty jaduhṉ møød, ween hajxy yajmucy. Coo hajxy hänajty tøø yajmujnä, mänitä Jesús ñämaayyä: ―Jagooyyä højts tsajcaagy mägoox̱yä tøø nbaady møødä hacx metsyä. ");
INSERT INTO mirNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Mänitä Jesús miänaaṉ̃ coo jaꞌa cuꞌughajxy yhøxtáꞌagät necchooty tuꞌhagøøbiäjaty, nämägoꞌxhaam møød näjuxychäguiꞌxmajc‑haam. Mänit hajxy jaduhṉ jiaanc̈h yhøxtaacy. ");
INSERT INTO mirNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mänitä Jesús jaꞌa tsajcaagy mägoox̱pä quiooṉdsooyy møødä hacx metspä. Coo chajheeꞌpy, mänitä Dioscujúꞌuyäp yejcy jaꞌa tsajcaagy quiøxpä møødä hacx quiøxpä. Mänitä tsajcaagy tiägøøyy haguidøøbiä. Mänitä jiamiøød tiägøøyy moobiä jaꞌa tsajcaagy møødä hacx, ween hajxy jaduhṉ yajwaꞌxy maa jaꞌa cuꞌugän. Tehṉgajnä Jesús jaꞌa tsajcaagy hänajty yajwaꞌañguiojy møødä hacx. Jiaac tehm̱ yajmayøøby hänajty jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Cuꞌuxiä jäyaꞌayhajxy jaduhṉ jiaanc̈h tehm̱ quiaayy. ");
INSERT INTO mirNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","Hoyyä jäyaꞌayhajxy hänajty jaduhṉ jia mayyä, majmetscachä tsajcaagy quiunajxy møødä hacx. Jaꞌa Jesús jaduhṉ yajwaꞌañguioj. Nämägoox̱mil jaꞌa yaꞌadiøjc‑hajxy jaduhṉ quiaayy yhuucy. ");
INSERT INTO mirNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mänitiä Jesús jaꞌa jiamiøød ñämaayy coo hajxy tiägǿꞌøwät jiiby barcojooty, wéenäc hajxy jim̱ ñøcxǿꞌøgät mejyhawiimb maa jaꞌa cajpt jaduhṉ xiøhatiän Betsaida. Coogä Jesús jaꞌa majiäyaꞌay jaduhṉ ñähguéecnät, mänítäc hajxy jim̱ ñibiaadǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Coo jaꞌa Jesús jaꞌa majiäyaꞌay ñähgueecy, mänit jim̱ ñøcxy tuṉgøxp Diospaꞌyaax̱pä. ");
INSERT INTO mirNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","48","Coo quioodsøøyy, jim̱ä Jesús hänajty tøø miähmøꞌøy mejypiaꞌa nidiuhm̱. Jaꞌa barco, jagooyyä hänajty mejyquiujc tøø ñäꞌä mahñ miech. Jaanc̈h tehm̱ miøcä barco hänajty jiøjcubojøꞌøyii. Tøø jaꞌa Jesús jiamiøødhajxy hänajty jiaanc̈h tehm̱ yhanuuꞌxøøñä coo jaꞌa barco hajxy hänajty jia wiꞌi quiaaby. Coo jaꞌa Jesús jaduhṉ yhijxy coo hajxy hänajty tøø yhanuuꞌxøøñä, mänit yoꞌoyhaam tiuꞌubøjcy nøøwiing. Mobädajpä hänajty jiobøꞌøwaaṉnä, tøø jaꞌa Jesús jaꞌa jiamiøød hänajty ñajtspaadøøñä. Wyiinnaxáaṉnäbä Jesús jaꞌa jiamiøød hänajty jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Coo jaꞌa Jesús yhijxä coo hänajty yoꞌoy nøøwiing, mänitä jiamiøødhajxy miänaaṉ̃ cooc tyijy hänajty jeꞌe yháañämä. Mänit hajxy møc chaac̈hyaax̱y. ");
INSERT INTO mirNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nägøx̱iä hajxy hänajty chähgøꞌøy coo jaꞌa Jesús hajxy jaduhṉ yhijxy coo hänajty yoꞌoy nøøwiing. Cab hajxy choj høxcajpy. Mänitä Jesús miänaaṉ̃: ―Møcä mjoot hajxy pädaꞌag; høøc̈h hädaa; caꞌac̈h hajxy xchähgøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Coo jaꞌa Jesús tiägøøyy barcojooty, mänitä poj miooṉ̃. Jiaanc̈h tehm̱ yagjuøøyy jaꞌa Jesús jiamiøødhajxy jaduhṉ coo poj miooṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Hoy hajxy hänajty tøø jia hix̱y coo jaꞌa Jesús jaꞌa tsajcaagy yajwaꞌañguiojy møødä hacx, cab hajxy hänajty ñajuøꞌøy coo jaꞌa Jesús møcmäjaa miøødä jaꞌa Dioscøxpä. Jaanc̈h tehm̱ quiuhxex̱ hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Coo jaꞌa Jesúshajxy jim̱ miejch mejyhawiimb maa jaꞌa naax̱ hänajty xiøhatiän Genesaret, mänitä barco hajxy jim̱ quiuxojch mejypiaꞌa. ");
INSERT INTO mirNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tuuṉä hajxy jaduhṉ ñäꞌä barcopädsøøm̱y, mänitiä Jesús yhøxcajpä jaꞌa cuꞌug. ");
INSERT INTO mirNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Paquiä mädiaꞌagy jim̱ wiaꞌxy coo jaꞌa Jesús hänajty jim̱ tøø miech. Mänit tiägøøyy wädijpä cajpt‑cajpt. Mänitä paꞌamjäyaꞌayhajxy tiägøøyy cøømiéjtsäbä tsaajiooty maa jaꞌa Jesús hänajty wiäditiän. Jim̱ä paꞌamjäyaꞌayhajxy hänajty tøø ñajtscøyøꞌøyii møjtuꞌubaꞌa maa jaꞌa Jesús hänajty ñaxøꞌøwaꞌañän. Mänitä Jesús hajxy miänuuꞌxtaacy coo jaꞌa paꞌamjäyaꞌayhajxy yajpaꞌamnaxǿøjät. Pønjatiä Jesús wyitpaꞌa hänajty näꞌä nähdóoṉäxäp, tehm̱ ñajxpä piaꞌamhajxy hänajty mänitiä. ");
INSERT INTO mirNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mänitä fariseos jaꞌa Jesús hajxy ñämejch, møødä hänaꞌc jaꞌa Diosmädiaꞌagy hajxy yajnähixøøbiä. Jim̱ hajxy hänajty chooñ Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mänitä fariseoshajxy yhijxy coo jaꞌa Jesús jiamiøød jaꞌa cuhdujt hajxy hänajty näjeꞌe quiaꞌa yajtuṉ̃, coo hajxy quiaꞌa cøꞌøbujy coo hajxy hänajty tiägøꞌøwaꞌañ caabiä huucpä. Jaꞌa fariseoshajxy, jaanc̈h tehm̱ yhoyyä judíocuhdujt hajxy hänajty quiudiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Hix̱, jaduhṉä judíoshajxy hänajty nägøx̱iä quiuhdujthatyñä nebiä yhapä tieedyhajxy hänajty jegyhajty tøø yajnähixøꞌøyii. Naaghooc hajxy hänajty quiayaꞌañ, tsipcøxpä quiøꞌø hajxy hänajty hoyhoy ñäꞌägä pujy waꞌads. ");
INSERT INTO mirNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Møød coo hajxy hänajty tøø yhoy halaplaaztøjpaꞌc, cab hajxy hänajty quiayaꞌañ jaguiøꞌøbujy. Madiuꞌu cuhdujt hajxy hänajty miøødä coo hajxy cøx̱iä wiinä ñähbujy ñähjeꞌec̈h, møødä cayøhñdy huꞌugøhñdy, møødä tuꞌts, møødä pujxtuꞌts. ");
INSERT INTO mirNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mänitä fariseos jaꞌa Jesús hajxy miäyajtøøyy: ―Tii yøꞌø mjamiøødhajxy jaguiøꞌøbujy coo quiay. Cabä jecyquiuhdujt hajxy yajtuṉ̃ neby jäyaꞌayhajxy hijty jegyhajty quiuhdujthatiän. ");
INSERT INTO mirNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mänitä Jesús yhadsooyy: ―Jueꞌe mijts, mjaanc̈h tehm̱ miähaneꞌemaam̱b mijts, pero cab hajxy mnäꞌä cudiuṉ̃ waam̱baty hajxy hamdsoo mja haneꞌemy. Mijtscøxpä jaꞌa Isaías jecy quiujahy, mänitä Dios miänaaṉ̃: Hädaa jäyaꞌayhajxy, ja mänaam̱b hajxy jaduhṉ cóogøch tyijy hajxy xwyiingudsähgøꞌøy, pero cábøch hajxy hamuumduꞌjoot xñäꞌä tsocy. ");
INSERT INTO mirNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xiǿøbøch hajxy xjia wiꞌi piaꞌhäyoy. Jaduhṉ hajxy jia mänaꞌañ cóogøch tyijy nmädiaꞌagy hajxy xjia yajnähixøøyyä, pero yhamdsoo mädiaꞌagy hajxy ñäꞌä wiꞌi miädiaacypy, nøm̱ä Isaías jecy quiujahy. ");
INSERT INTO mirNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mijts, tøø jaꞌa Diosmädiaꞌagy hajxy mnajtshixøøñä. Jaꞌa mhamdsoo cuhdujt hajxy jaduhṉ myaghíjnäp ―nøm̱ä Jesús jaꞌa fariseos ñämaayy. ");
INSERT INTO mirNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","10","Mänitä Jesús ñämáaguiumbä: ―Paadiä Diosmädiaꞌagy hajxy tøø mnajtshixøꞌøy, jaduhṉä mhamdsoo cuhdujt hajxy hoy myaghidaꞌañ. Jaduhṉä Moisés jecy miänaaṉ̃ coo jaꞌa mdaj coo jaꞌa mdeedy hajxy mwiingudsähgǿꞌøwät. Pero pǿṉägä tiaj jaꞌa tieedy haxøøg nänøøm̱b, yajcuyaghoꞌogøꞌøwáaṉäbäc jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Pero wiing mijts mja mänaꞌañ cooc tyijy jaduhṉ yhawiinmatsä cooc pøṉä tiajjä tieedy haxøøg ñämáꞌawät: “Cábøch mijts nbuhbedaaṉnä. Hix̱, tøøc̈hä Dios nnämaꞌay cooc̈h jeꞌe cøx̱iä nmoꞌowaꞌañ jaꞌac̈h mijts hijty nmoꞌowaam̱biä.” ");
INSERT INTO mirNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Coo hajxy jaduhṉ mmänaꞌañ, myajcähxøꞌpy hajxy jaduhṉ coo jaꞌa Diosmädiaꞌagy hajxy mgaꞌa yajtuuṉnä, møød coo jaꞌa mhamdsoo cuhdujt hajxy myajnähixøøñä. Madiuꞌu hajxy jaduhṉ myajcähxøꞌøgy coo jaꞌa Diosmädiaꞌagy hajxy tøø mnajtshixøøñä, møød coo jaꞌa mhamdsoo cuhdujt hajxy myajtuuṉnä ―nøm̱ä fariseoshajxy ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mänitä Jesús jaꞌa cuꞌug yajwiingapxǿøguiumbä: ―Høøc̈h nmädiaꞌagy hajxy hamädoow̱híjtäc. ");
INSERT INTO mirNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tijaty hajxy mgaaby mhuucypy, cab hajxy xyajcädieey. Pero jaꞌa haxøøgwiinmahñdy, jeꞌeds hajxy mäbøcy xyajcädiéeyäp. ");
INSERT INTO mirNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Pøṉ jaduhṉ wiinjuøøby, wéenhøch nmädiaꞌagy xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Coo jaꞌa Jesús jaꞌa quiapxy miädiaꞌagy jaduhṉ yajmaayy, mänitä cuꞌughajxy quiøx̱y wiimbijnä. Mänitä Jesúshajxy tiøjtägøøñä møødä jiamiøødtøjc, jaꞌa hajxy hänajty jaꞌa nämajmetspä. Mänitä Jesús miäyajtøøw̱ä neby hänajty jaduhṉ miädiaꞌagytiägøꞌøy jaꞌa hänajty jaduhṉ jim̱ tøø miädiáꞌaguiäbä majiäyaꞌayhagujc. Jaꞌa Jesús jiamiøødhajxy jaduhṉ yajtøøw̱ yajtøøꞌx. ");
INSERT INTO mirNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mänitä Jesús yhadsooyy: ―Nej, ni mijtshajxy jaduhṉ tøø mgaꞌa wiinjuøꞌøyä waam̱bátyhøch tøø nja mädiaꞌaguiä. Jaduhṉds jeꞌe, tijaty hajxy mgaaby mhuucypy, cab hajxy xyajcädieey. ");
INSERT INTO mirNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Hix̱, jaꞌa jøøꞌxy jaꞌa pøcy, jiiby jaduhṉ yhädaꞌagøꞌøy maa jaꞌa mjøøꞌxytiøjc‑hajxiän. Jadähooc nøcxy piädsøm̱y. Cab jaduhṉ jiiby tiehm̱ tiägøꞌøy maa jaꞌa mjuøhñdyhajxiän ―nøm̱ä Jesús miänaaṉ̃. Jaduhṉ hädaaduhṉ miädiaꞌagytiägøꞌøy coo ni mädyii jøøꞌxy pøcy quiaꞌa hamajtscä. ");
INSERT INTO mirNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mänitä Jesús miänáaṉgumbä: ―Pero jaꞌa haxøøgwiinmahñdy, jeꞌeds hajxy mäbǿjnäbä xyajcädiéeyäp. ");
INSERT INTO mirNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Coo jaꞌa jäyaꞌay haxøøgwiinmahñdy hajxy jiaanc̈h tehm̱ miøødä, paady hajxy haxøøgjaty jiaanc̈h tehm̱ jiatcøꞌøy; paady hajxy miämeec̈h, paady hajxy ñiyaghoꞌogyii, paadiä jäyaꞌadioꞌoxiøjc hajxy miøødtsänaꞌay, paadiä jäyaꞌajieꞌe hajxy yhadsocy, paady hajxy miäwiinhøøñ, paady hajxy ñiñähojyii, paady hajxy jiaanc̈h tehm̱ yajcumayaꞌañ, paady hajxy quiaꞌa näꞌägädä wiinmahñmech. Coo hajxy nax̱y miuꞌugyii, paadiä hadsojwiinmahñdy hajxy miøødä. ");
INSERT INTO mirNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jaduhṉds jeꞌe, jaanc̈h tehm̱ miadiuꞌu jaꞌa haxøøgwiinmahñdy jii. Jeꞌeds hajxy jaduhṉ mäbøcy xyajcädiehby. Mänitä Jesús miädiaacpädøøñä. ");
INSERT INTO mirNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Coo jaꞌa Jesús jim̱ chohṉ̃, mänit jim̱ ñøcxy maa jaꞌa naax̱ jaduhṉ xiøhatiän Tiro møød Sidón. Mänitä tøjc tuꞌug piaaty maa hänajty miejtstaꞌagaꞌañän. Hameeꞌch jim̱ jia hidaaṉ̃. Pero miädoow̱ jaꞌa cuꞌughajxy jaduhṉ coo jaꞌa Jesús hänajty jim̱ tøø miech. ");
INSERT INTO mirNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Jim̱ä tajjäyaꞌay hänajty tuꞌug chänaꞌay. Hagriego hänajty miädiaꞌagy. Caꞌa hänajty jeꞌe jiudíosä. Jim̱ä yhuung hänajty tuꞌug, toꞌoxiänaꞌc. Tøø jaꞌa toꞌoxiänaꞌc hänajty piaꞌambety. Møjcuꞌu hänajty tøø yajtägøꞌøyii. Coo jaꞌa quix̱iä tiaj jaduhṉ miädoyhajty coo jaꞌa Jesús hänajty jim̱ tøø miech, mänitä Jesús hoy wyiinjijcädaꞌagyii. Mänitä Jesús miänuuꞌxtaacä coo jaꞌa toꞌoxiänaꞌc nøcxy yajpaꞌamnájxäxä. ");
INSERT INTO mirNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mänitä Jesús miänaaṉ̃: ―Cab jaduhṉ yhahixøꞌøy cooc̈hä huc‑huung tsajcaagy nmóꞌowät, jaꞌa pigänaꞌc‑hajxy hijty quiayaam̱biä. Coo jaꞌa Jesús jaduhṉ miänaaṉ̃, jaꞌa judíoshajxy jaduhṉ yajmäbaatä nebiä pigänaꞌcän. Jaꞌa caꞌa judíoshajxy jaduhṉ yajmäbaatä nebiä hucän. ");
INSERT INTO mirNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mänitä tajjäyaꞌay yhadsooyy: ―Wiindsǿṉ, tøyhajt jaduhṉ. Pero jiibiä huc‑huunghajxy piaꞌpiy piaꞌcoṉ̃ meexäpaꞌc tijaty jaꞌa pigänaꞌc‑hajxy yajwiingaꞌawøøby. ");
INSERT INTO mirNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mänitä Jesús miänaaṉ̃: ―Coo jaduhṉ tøø mmänaꞌañ, cähxøꞌp jaduhṉ cooc̈h nmädiaꞌagy xmiäbøjcä. Tøø jaꞌa mhuungä møjcuꞌu ñähwáatsänä. Nøcxnä jootcujc maa jaꞌa mdøjcän. ");
INSERT INTO mirNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mänitä tajjäyaꞌay wyiimbijty. Coo jim̱ miejch maa jaꞌa tiøjcän, tøø jaꞌa yhuungä møjcuꞌu hänajty jiaanc̈h nähwáatsänä. Jim̱ä yhuung hänajty quioꞌnaꞌay maabejtcøxp hoy weenän. ");
INSERT INTO mirNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mänitä Jesús jim̱ wyiimbijtägajch maa jaꞌa naax̱ xiøhatiän Tiro. Mänit jim̱ ñaxøøyy maa jaꞌa cajpt hänajty xiøhatiän Sidón. Mänit jim̱ ñøcxøøyy maa jaꞌa naax̱ hänajty xiøhatiän Decápolis. Mänit jim̱ miedsøøyy maa jaꞌa mejy hänajty xiøhatiän Galilea. ");
INSERT INTO mirNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mänitä mähdiøjc tuꞌug yajmejtsä maa jaꞌa Jesús jaꞌa wyiinduumän. Cabä mähdiøjcä mädiaꞌagy hänajty hoy yhabädsøm̱y, møød hänajty quiuhnatä. Mänitä Jesús miänuuꞌxtaacä coo jaꞌa quiøꞌø yajnähgábät maa jaꞌa mähdiøjc cuhnatpän. Jaꞌa mähdiøjcä jiamiøødhajxy jaduhṉ mänaaṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mänitä Jesús jaꞌa mähdiøjc jäguem̱juøøby miødhajty nidiuhm̱. Mänitä Jesús jaꞌa mähdiøjcä tiaatsc piadsihw̱ä. Mänitä Jesús jaꞌa quiøꞌøwahx̱c chujyñähboꞌty. Mänitä mähdiøjc tiaatsc chujyhaboꞌodǿøyyäxä. ");
INSERT INTO mirNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mänitä Jesús chajheeꞌpy. Mänit miänaaṉ̃: “Efata.” Jaduhṉ hädaa miädiaꞌagytiägøꞌøy: “Hawaꞌads.” ");
INSERT INTO mirNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tuuṉä jaꞌa Jesús jaduhṉ ñäꞌä mänaaṉ̃, mänitiä mähdiøjc quiapxøꞌcy miädoow̱øꞌcy. Jaanc̈h tehm̱ yhoy jaduhṉ miädiaacnä. ");
INSERT INTO mirNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mänitä Jesús miänaaṉ̃ coo hajxy quiaꞌa mädiáꞌagät coo jaꞌa mähdiøjc jaduhṉ tøø yhoyøꞌøy. Pero cab hajxy jaduhṉ jioodhajty. Mänitiä hajxy jaduhṉ hoy yhamädiaagøꞌøy. Hoyyä Jesús mayhooc jia hanehm̱y coo hajxy quiaꞌa hamädiaagǿꞌøwät, maas hanax̱iä jaꞌa mähdiøjc hajxy yhamädiaagøøyy. Cabä Jesús miädiaꞌagy jaduhṉ ñäꞌä yajtúuṉäxä. ");
INSERT INTO mirNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jiaanc̈h tehm̱ yagjuøøbiä cuꞌughajxy hänajty jaduhṉ. Mänit hajxy tiägøøyy mänaam̱bä: “Jaanc̈h tehm̱ miøjmayhajt jaduhṉ tiuum̱by coo jaꞌa cuhnatpä yajmädoow̱øꞌøgy, møød coo jaꞌa huumbä yajcapxøꞌøgy.” ");
INSERT INTO mirNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Cujaboom cumaax̱c, mänitä jäyaꞌayhajxy nämay yhamugǿøguiumbä maa jaꞌa Jesús hänajtiän. Ja yähóꞌcäp hajxy hänajty, cabä caayyøøc hajxy hänajty ñäꞌägädä møødä. Mänitä Jesús jaꞌa jiamiøødtøjc yaax̱mujcy, jaꞌa hajxy hänajty nämajmetspä. Mänitä Jesús miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Nnäxúuꞌchpøch hädaa jäyaꞌayhajxy. Tägøøgxǿøjøch hajxy tøø xpiawädijnä. Tøø jaꞌa quiay tøø jaꞌa yhuꞌugyhajxy quiøjxnä. Tii hajxy jaduhṉ ñäꞌä jaac cáyäp. ");
INSERT INTO mirNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cooc̈h hajxy jaguiay nguejxwiimbídät, wehṉdä hajxy jim̱ tiuꞌuyuugädáw̱ät. Hix̱, näjeꞌe hajxy jäguem̱ tøø chohṉdaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mänitä Jesús yhadsoow̱ä jaꞌa jiamiøødtøjc: ―Tii hädaa jäyaꞌay hajxy häyaa nnäꞌä yajcáayyämb. Cabä cajpt yaa. Maa tsajcaagy hajxy häyaa nnäꞌä páatämät ―nøm̱ä Jesús jiamiøødhajxy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mänitä Jesús jaꞌa jiamiøødtøjc miäyajtøøyy: ―Naag tsajcaagy hajxy jii mmøødä. ―Juxtujc ―nøm̱ hajxy yhadsooyy. ");
INSERT INTO mirNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mänitä Jesús miänaaṉ̃ coo jaꞌa majiäyaꞌayhajxy yhøxtáꞌagät naax̱wiin. Mänitä Jesús jaꞌa tsajcaagy quiooṉdsooyy. Mänitä Dioscujúꞌuyäp yejcy. Mänitä tsajcaagy tiägøøyy haguidøøbiä. Mänitä jiamiøødtøjc miooyy. Mänitä majiäyaꞌayhajxy miooyyä. Coo jaꞌa Jesús jaꞌa tsajcaagy hänajty yhaguidøꞌøy, yajwaꞌañguiojpy hänajty tehṉgajnä. ");
INSERT INTO mirNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jim̱ä hacxhuung hajxy hänajty miǿødäbä mejtstägøøg. Mänitä Jesús quiunuuꞌxy. Mänit miänaaṉ̃ coo jaꞌa majiäyaꞌayhajxy mioꞌowǿøjät. Jaduhṉ jeꞌe may yajwaꞌañguiojpä. ");
INSERT INTO mirNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mänitä jäyaꞌayhajxy tiägøøyy caabiä. Høxtä cuux̱ä hajxy hoyhoy. Høxtä jiaac piwøꞌc hajxy juxtujcach, jaꞌa hänajty tøø quiunáx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nämädaax̱mil jäyaꞌayhajxy jaduhṉ quiaayy yhuucy. Mänitä Jesús miänaaṉ̃ coo hajxy wyiimbíjnät. ");
INSERT INTO mirNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mänitä Jesúshajxy jadähooc biarcopéjcumbä møødä jiamiøødtøjc. Mänit hajxy jim̱ ñøcxy maa jaꞌa cajpt hänajty xiøhatiän Dalmanuta. ");
INSERT INTO mirNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mänitä Jesús jaꞌa fariseos näjeꞌe ñämejtsä. Mänitä fariseos jaꞌa Jesús jaꞌa Diosmädiaꞌagy hajxy miøødyajtsibøøyy. Mänitä Jesús jia nämaayyä: ―Huuc yajcähxøꞌøgä hijxtahṉd hoy‑yagjuǿøñäbä jaꞌa tsajpootypä. Jaduhṉ højtsä tøyhajt nmøødhádät coo miic̈hä Diosmäjaa mjaanc̈h møødä ―nøm̱ä fariseoshajxy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mänitä Jesús jiootmaxiejy. Jootmadiägøøyy jaduhṉ. Mänit miänaaṉ̃: ―Tii jaꞌa Diosmäjaa hajxy coo mwiꞌi yhixaꞌañ. Tøyhajt mijts nnämáꞌawät coo hajxy mgaꞌa hixaꞌañ ―nøm̱ä fariseoshajxy ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mänitä Jesúshajxy wyiimbijnä møødä jiamiøødtøjc. Mänit hajxy tiägøøyy barcojooty. Mänit hajxy tiuꞌubøjcy. Mejyhawiimb hajxy hänajty ñøcxaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","15","Mänitä Jesús jaꞌa jiamiøødtøjc ñämaayy: ―Mnigwieendähadǿøjäp hajxy. Caꞌa jaꞌa Herodes chajcaagychooy hajxy mmäwädijtä, ni jaꞌa fariseos jieꞌehajxy. Mänitä Jesús jiamiøødhajxy yhijxy coo jaꞌa tsajcaagy hajxy hänajty tøø quiaꞌa jaac juy. Jagooyyä tsajcaagy hajxy hänajty tuꞌuquiä miøødä barcojooty. ");
INSERT INTO mirNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mänit hajxy tiägøøyy niñämáayyäbä: ―Paady hajxy jaduhṉ xñämáayyäm, coo tsajcaagy hajxy tøø njahdiägóoyyäm. ");
INSERT INTO mirNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Coo jaꞌa Jesús jaduhṉ yhamädoonajxy waam̱batiä jiamiøødhajxy hänajty ñiñämaꞌayii, mänit hajxy ñämaayyä: ―Nej, jaduhṉ hajxy mwiinjuøꞌøyä cooc̈hä tsajcaagy tøø nmädiaꞌaguiä, jaꞌa hajxy tøø mjahdiägóyyäbä. Cab hajxy tøø mnäꞌägädä wiinjuøꞌøy tijátyhøch tøø nmädiaꞌagy. Mjaanc̈h tehm̱ quiuhxex̱ mijts jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Xiidsä mwiin hajxy mja møødä, cab hajxy tii mhijxmähmøꞌøy. Xiidsä mmädohnd hajxy mja møødä, cab hajxy tii mmädoomähmøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mänáajøc̈hä nämägoox̱milpä jäyaꞌay nyajcayyän jaꞌa mägoox̱tsajcaagy, naac cachä caadiuc hajxy mbiwøꞌcy. Mänit hajxy yhadsooyy: ―Majmetsc. ");
INSERT INTO mirNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mänitä Jesús miänáaṉgumbä: ―Jaanä mänáajøc̈hä nämädaax̱milpä jäyaꞌay nyajcayyän jaꞌa juxtujtsajcaagy, naag cach hajxy mbiwøꞌpä. Mänit hajxy yhadsóogumbä: ―Juxtujc. ");
INSERT INTO mirNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mänit hajxy ñämáayyägumbä: ―Caj mijts tøø mnäꞌägä wiinjuøꞌøy tijátyhøch tøø nmädiaꞌagy ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mänitä Jesúshajxy jim̱ miejtstägajch maa jaꞌa cajpt hänajty xiøhatiän Betsaida. Mänitä wiinds tuꞌug wyitsmejtsä maa jaꞌa Jesúsän. Mänitä Jesús miänuuꞌxtaacä coo jaꞌa wiinds ween ñähdoñii, ween jaduhṉ yhijxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mänitä Jesús jaꞌa wiinds wyijtstsooyy. Mänitä wiinds cajptpaꞌa quipxy miødhajtä. Mänitä wiinds wyiingutsujøøyyä. Mänit wyiingum̱oꞌxøøyyä. Mänit miäyajtøøw̱ä pø tøø hänajty yhijxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mänit tiägøøyy hijxøꞌpä weenjaty. Mänit miänaaṉ̃: ―Tøøc̈h weenjaty nhijxøꞌøgy. Cábøc̈hä jäyaꞌay hoy nhøxcabaꞌañ. Nnajuǿøbiøch jaduhṉ coo jiäyaꞌayä, pero jadúhṉhøch nhix̱y nebiä quepychaajän. ");
INSERT INTO mirNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mänitä Jesús jaꞌa wiinds jadähooc wyiingumoꞌxǿøguiumbä. Mänitä wiinds hoy tiägøøñä hijxpä. Hotyiijä hänajty jäguem̱jaty yhijxnä. ");
INSERT INTO mirNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mänitä Jesús miänaaṉ̃: ―Tuꞌudaꞌaquiä mnǿcxät maa jaꞌa mdøjcän. Caꞌa cajptooty mguyoꞌoy mgubøgøꞌøy ―nøm̱ä craa ñämaayyä, jaꞌa hänajty tøø yhijxǿꞌøguiäbä. ");
INSERT INTO mirNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mänitä Jesúshajxy jim̱ tiuꞌubøjcy møødä jiamiøødtøjc. Jim̱ hajxy hänajty ñøcxaꞌañ maa jaꞌa naax̱ hänajty xiøhatiän Cesarea de Filipo. Cajpt‑cajpt hajxy hänajty wiäditaꞌañ. Tuꞌhaamnøcxpä, jim̱ä Jesús jaꞌa jiamiøødtøjc miäyajtøøyy: ―Høøc̈h, pǿṉhøc̈hä cuꞌugädaꞌa xtyijp. ");
INSERT INTO mirNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mänitä Jesús yhadsoow̱ä: ―Näjeꞌe hajxy miänaꞌañ cooc tyijy miic̈h mJuan mäyajnäbejpä. Näjeꞌe hajxy miänaam̱bä cooc tyijy miic̈h mhElíasä. Näjeꞌe hajxy jiaac mänaam̱bä cooc tyijy miic̈h mDiosquex̱iä, cooc tyijy miic̈hä Diosmädiaꞌagy jecy myajwaꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mänitä Jesús yajtǿøgumbä: ―Míjtsäts, pǿṉhøch mijtshajxy jaduhṉ xtyijp. Mänitä Pedro yhadsooyy: ―Jueꞌe miic̈h, Cristo. Dios miic̈h tøø xwyiinguex̱y. ");
INSERT INTO mirNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mänitä Jesús jaꞌa jiamiøødtøjc ñämaayy coo jaꞌa Jesús hajxy quiaꞌa mädiáꞌagät pøṉ hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mänitä Jesús jaꞌa jiamiøødtøjc tiägøøyy yajwiingapxøøbiä: ―Høøc̈h, Diosquéx̱yhøch høøc̈h. Madiúꞌujøc̈hä tsaac̈hpä nøcxy nhabaadaꞌañ. Xmiähaṉhadáam̱bøc̈hä jäyaꞌayhajxy, jaꞌa hajxy jiiby wiindsøṉhajpä maa jaꞌa tsajtøjcän, møødä teedywiindsøṉhajxy, møødä hänaꞌc‑hajxy jiiby Diosmädiaꞌagy‑yajnähixøøbiä maa jaꞌa tsajtøjcän. Mäníthøch hajxy jaduhṉ xjia yajyaghoꞌogaꞌañii. Pero cooc̈h hajxy hänajty tøø xyajyaghoꞌogyii, cudägøøgxøøyyä, mäníthøch njujypiøjtägatsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Howyiinjuøøñä jaꞌa Jesús jaduhṉ miädiaacy. Mänitä Pedro jaꞌa Jesús hawiingtuum wioonøcxy. Mänitä Pedro miänaaṉ̃: ―Wiindsǿṉ, caꞌads jaduhṉ mwiꞌi miänaꞌañ. Caj miic̈h nej mjadaꞌañ mhabetaꞌañ ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mänitä Jesús wiaꞌwiimbijty. Mänitä jiamiøødtøjc wyiinheeꞌppejty. Mänitä Pedro yhojjä: ―Møjcuꞌu, juaꞌads yaa maac̈h nwiinduumän. Jaduhṉ miic̈h mwiinmahñdyhaty nebiä jäyaꞌayhajxy wyiinmahñdyhajpän. Caj miic̈h jaduhṉ mwiinmahñdyhaty nebiä Dios wyiinmahñdyhatiän ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mänitä Jesús jaꞌa cuꞌug miøjyaax̱y møødä jiamiøødtøjc. Mänitä Jesús miänaaṉ̃: ―Pøṉ jioot tsojp cooc̈h xjiamiøødhádät, weenä yhamdsoo cuhdujt hajxy ñajtshixøꞌøy, weenä jioot hajxy piädaꞌagy coo hajxy chaac̈hpǿjpät nébiøch ndsaac̈hpøgaꞌañän. Wéenhøc̈hä nmädiaꞌagy hajxy tehṉgajnä xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pøṉä jioot ja pädaacp coo hajxy hoy jiugyhádät, cab hajxy cøjxtaꞌaxiøø jiugyhadaꞌañ nebiä Dios jiugyhatiän. Pero pøṉä jioot pädaacp coo hajxy yhóꞌogät jaꞌa høøc̈hcøxpä møødä Diosmädiaꞌagyquiøxpä, jeꞌedshajxy homiänaajä jugyhadaam̱b nebiä Dios jiugyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Coo hajxy hodiuum mgaꞌa mähmǿꞌøwät coo hajxy hänajty tøø mhoꞌogy, cab hajxy jaduhṉ mniyaghoyøꞌøwǿøjät, hoy hajxy hänajty yaa tøø mja mäyøøhaty hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ni tii yaa quiaꞌa näꞌägädä tsoobaady hädaa yaabä naax̱wiin nebiä mjugyhajthajxy choobaadaꞌañän, coo hajxy homiänaajä mjugyhádät nebiä Dios jiugyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pǿṉhøch xmiädsähdiuum̱b mǿødhøc̈hä nmädiaꞌagyquiøxpä maa hädaa jäyaꞌay wyiinduumhajxiän, hädaa pojmøødpä cädieemiøødpähajxy, hädaahajxy caꞌa Diosmädiaꞌagymiäbøjpä, cooc̈h yaa ngädaactägátsät hädaa yaabä naax̱wiin, mänítøch hajxy jadähooc nmädsähdiuuṉdägatsaꞌañ, pønjátyhøch hänajty yaa tøø xmiädsähdiuṉ̃. Diosquéx̱yhøch høøc̈h. Diosmøcmäjaamǿødhøch hänajty yaa ngädaꞌagaꞌañ, näguipxy møødä Diosmoonsähajxy, jaꞌa hajxy jim̱ hijpä Dioswiinduum ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mänitä Jesús miänáaṉgumbä: ―Chaads mijts tøyhajt ndehm̱ ñämáꞌawät, mijts xii tänaabiä, näjeꞌe hajxy hänajty mgaꞌa hoꞌogyñä coo hänajty quiähxøꞌøgaꞌañ coo jaꞌa Dios hänajty yhaneꞌemaꞌañ jaꞌa miøcmäjaahaam. ");
INSERT INTO mirNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cudädujxøø, mänitä Jesús jaꞌa Pedro wioonøcxy maa jaꞌa tuṉ jaanc̈h tehm̱ quiøxpän, näguipxy møødä Santiago møødä Juan. Nämädaax̱yä hajxy hänajty jim̱. Mänitä Jesús wyiin jiøjp wiing jiajty maa jaꞌa Pedro wyiinduumhajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Høxtä haam̱b høxtä tsämaam̱bä Jesús hänajty møødä wyit møødä tiucxy. Jaanc̈h tehm̱ pioobä wyit hänajty nägøꞌø nädecypiä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mänitä Elíashajxy jim̱ ñäguehx̱tøøꞌxy møødä Moisés. Jim̱ä Jesús hajxy hänajty wyiꞌi miøødmädiaꞌagy. Nägoojä Pedrohajxy hänajty ñäꞌä hijxcädaꞌagy ñäꞌä heeꞌpcädaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Jaanc̈h tehm̱ chähgøøbiä Pedrohajxy hänajty. Cab hajxy hänajty ñajuøꞌøy waam̱b hajxy jaduhṉ ñäꞌä mänáꞌanät. Mänitä Pedro näꞌä nägoobä miänaaṉ̃: ―Wiindsǿṉ, hoyøøyy jaduhṉ coo hajxy yaa tøø nbéjtäm. Nhuuc hädiuṉ̃ højts tøjquem̱yhuung tägøøg maa mijtshajxy häyaa cøduꞌug myaghäñaꞌawǿꞌøwät, møød miic̈h, møødä Moisés, møødä Elías ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tuuṉä jaꞌa Pedro jaduhṉ ñäꞌä mänaaṉ̃, mänit hajxy ñämaꞌanähbejty. Mänitä Dios jiiby quiapxy nämaꞌajooty: “Høøc̈h nHuung hädaa. Njaanc̈h tehm̱ chójpiøch hädaa. Mäbøjcä miädiaꞌagy hajxy.” ");
INSERT INTO mirNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Coo jaꞌa nämaꞌa chajpejty, tøø jaꞌa Moiséshajxy hänajty yhadägoyyøꞌøy møødä Elías. Coo jaꞌa Pedrohajxy jia hijxwädijty, cabä Moisés hajxy yhijxnä ni jaꞌa Elías; jagooyyä jaꞌa Jesús hajxy jiaag hijxy nidiuhm̱. ");
INSERT INTO mirNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jim̱ä Jesúshajxy hänajty wyiinmänacy tuṉnähgøxp møødä jiamiøød nädägøøgpä, mänitä Jesús miänaaṉ̃: ―Caꞌa hajxy pøṉ mnäꞌägädä hawaaṉä tijaty hajxy yaa tøø mhix̱y tøø mmädoy høxtä cóonøch hänajty tøø njujypiøjtägach cooc̈h hänajty tøø nhoꞌogy. Diosquéx̱yhøch høøc̈h ―nøm̱ä Pedrohajxy ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Coo jaꞌa Pedrohajxy jaduhṉ ñämaayyä, paadiä mädiaꞌagy hajxy jaduhṉ miäbøjcy. Jioodhajt hajxy jaduhṉ nebiaty hajxy hänajty tøø yhix̱y tøø miädoy. Hamiṉ̃ haxøpy hajxy hänajty jia ñimiäyajtøyii waam̱bä Jesús hänajty jaduhṉ jia mänaꞌanaꞌañ coo jaduhṉ miänaaṉ̃ cooc hänajty jiujypiøjtägatsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mänitä Jesús hajxy miäyajtøøyy: ―Jaꞌa hänaꞌc hajxy jiiby yajnähixøøbiä maa jaꞌa tsajtøjcän, jaduhṉ hajxy miänaꞌañ coogä Elías tsipcøxp jawyiin quiädáꞌagät. Mänítägä Cristo høx̱haam jiaac tehm̱ quiädaꞌagaꞌañ. Tii hajxy jaduhṉ coo miänaꞌañ. Nej, tøyhajt jaduhṉä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Mänitä Jesús yhadsooyy: ―Jaduhṉä Diosmädiaꞌagy jiaanc̈h mänaꞌañ coogä Elías jawyiin quiädaꞌagaꞌañ. Tøyhajt jaduhṉ. Mänítägä cøx̱iä wiinä yagjemaꞌañ yajtägatsaꞌañ. Tøø jaꞌa Elías jia cädaꞌagy. Pero tøø jaduhṉ jiaanc̈h tehm̱ chaac̈htiuñii nebiatiä jäyaꞌay jioothajxy chocy. Tøjiajt jaduhṉ nebiä Diosquex̱yhajxy jecy quiujahyyän. Nej, mnajuøøby hajxy jaduhṉä waam̱bátyhøc̈hä Diosmädiaꞌagy xmiädiaacpä, høøc̈h jaꞌa Diosquex̱ypä, cooc̈hä jäyaꞌayhajxy xchaac̈htiunaam̱bä, møød cooc̈h hajxy xquiaꞌa jaac hixaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Coo jaꞌa Jesúshajxy jiiby quiädaacy maa jaꞌa jiamiøødhajxy hänajty tøø miähmøꞌøyän, jaꞌa hajxy hänajty jiiby nädaax̱tujpä, mänitä Jesús yhijxy coo jaꞌa jiamiøødhajxy hänajty piquiä tøø piädaꞌagyii jaꞌa majiäyaꞌay. Jim̱ä hänaꞌc hajxy hänajty miøødniyhojyii, jaꞌa hänaꞌc‑hajxy jim̱ yajnähixøøbiä maa jaꞌa tsajtøjcän. ");
INSERT INTO mirNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nägoo jaꞌa cuꞌugä Jesús hajxy jiøjcuhixøøyy, mänit hajxy jiaanc̈h tehm̱ xiooṉdaacy. Mänitä Jesús jiøjcubäyøꞌøgøøyyä. Mänit yajpooꞌxä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mänitä Jesús miänaaṉ̃: ―Tii hajxy mwiꞌi yajniguiuhojǿøyyäp. ");
INSERT INTO mirNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mänit tuꞌjäyaꞌay yhadsooyy: ―Wiindsǿṉ, chaac̈hä nhuung tøø nja møødmech. Møjcuꞌu jaduhṉ miøød. Jaꞌa møjcuꞌu wiꞌi yaghuhm̱b. ");
INSERT INTO mirNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nax̱y jaduhṉ yajcädayyii. Mänit tiägøꞌøy hahooꞌpä. Mänitä tiøøts tiägøꞌøy yajcädajpä. Mänit møc‑häwøønä jiaty. Tøøc̈hä mjamiøødtøjc nja mänuuꞌxtaꞌagy cooc̈h nhuung hajxy cu xyajpaꞌamnähwaatsä. Pero cab hajxy tøø miäjädaꞌagy ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Mänitä Jesús jaꞌa jiamiøødtøjc ñämaayy: ―¡Jaꞌa! Cábøch mijtsä nmädiaꞌagy xñäꞌä mäbøjcä cooc̈h nDiosquex̱iä. Tøøc̈h mijts jejcy nja møødwädity, y cahnä hajxy tii mnäꞌägädä habøcyñä. Jaanc̈h tehm̱ yhanax̱iä mijts jaduhṉ mguhxex̱ä. Nébiøch mijts nnäꞌä túnät. Hoorä, witsmiṉxä jaꞌa paꞌamjäyaꞌay yaa ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mänitä Jesús miädiaꞌagy quiudiúuṉäxä. Coo jaꞌa Jesús yhijxä jaꞌa møjcuꞌu, mänitä mähdiøjcä piaꞌam tiehm̱ ñämejtsä. Mänitä mähdiøjc quiädaayy naax̱wiin. Mänit piayajch piadøøꞌpy. Mänit tiägøøyy hahooꞌpä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mänitä craa tieedy miäyajtǿøw̱äxä: ―Mänaa hädaa mhuung tøø piaꞌambety. Jaꞌa Jesús jaduhṉ yajtøøw̱. ―Muutsnä hänajyñä ―nøm̱ä craa tieedy yhadsooyy. ");
INSERT INTO mirNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mänitä tieedy miänáaṉgumbä: ―Náx̱yhøch hädaa nhuung jiøøngädaw̱ jiøømbøgøꞌøy coo piaꞌam jaduhṉ nax̱y ñähbaadyii. Nax̱y ñøøgädaw̱ ñøøbøgøøbiä. Ja weenjaty jaduhṉ quiaa yaghoꞌogyii. Tuṉä mayhajt. Pø jii miic̈h møcmäjaa mmøødä, højts näxúuꞌtsäc, højts puhbéjtäc ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Mänitä Jesús miänaaṉ̃: ―Nej, jadúhṉhøch miic̈h xmiøyajtøyyä pø nmǿødhøch møcmäjaajä. Pøṉ jaduhṉ mäbøjp, hotyiijä jaduhṉ yhoyøꞌøwáaṉäxä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mänitä paꞌamjäyaꞌay tieedy yaax̱y: ―Nmäbǿjpiøch. Høøc̈h puhbéjtäc, jadúhṉhøch maas hoy njaac mäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jim̱ä jäyaꞌayhajxy hänajty may wyiꞌi miamiucy. Coo jaꞌa Jesús jaꞌa majiäyaꞌay jaduhṉ yhijxy, mänitä Jesús jaꞌa møjcuꞌu ñämaayy: ―Høøc̈h miic̈h nhanehm̱by coo hädaa craa mhøxmájtsnät. Cab jaduhṉ mänaa mnämejtstägájtsnät. Nax̱y miic̈h hädaa mähdiøjc myaghuumy myajnaty ―nøm̱ä møjcuꞌu yhojjä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mänitä mähdiøjc møc yajtsaac̈hyaax̱ä. Mänit jiäwijpøꞌcy xiäyaayyøꞌcy. Mänit ñähwaatsä quiuhwaatsä. Nebiä hoꞌogypiän jiajty. Coo jaduhṉ yhijxä, mänitä jäyaꞌayhajxy may miänaaṉ̃ cooc tyijy hänajty tøø yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mänitä Jesús jaꞌa craa wyidsøꞌcy. Mänitä craa hoy tiänaayyøꞌnø. ");
INSERT INTO mirNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mänitä Jesúshajxy tiøjtägøøyy møødä jiamiøødtøjc. Mänitä Jesús hameeꞌch miäyajtøøw̱ä jaꞌa jiamiøød: ―Tii højts jaduhṉ coo tøø ngaꞌa mäjädaacpä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mänitä Jesús yhadsooyy: ―Coo Dios hajxy mjaanc̈h tehm̱ miänuuꞌxtáꞌagät, mänit yøꞌøduhm̱bä paꞌam hajxy hoy myajnáxät. Pero pø caj, cab hajxy myajnáxät. ");
INSERT INTO mirNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Coo jaꞌa Jesúshajxy jim̱ chohṉ̃, mänit hajxy ñøcxy Galilea. Cabä Jesús hänajty yajnajuøꞌøwaꞌañii maa hänajty nøcxy wiäditaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mänitä Jesús jaꞌa jiamiøødtøjc tiägøøyy yajwiingapxøøbiä: ―Høøc̈h jaꞌa Diosquex̱ypä, nøcxáam̱bøch nniñähdugaꞌañii cooc̈hä jäyaꞌayhajxy xyaghóꞌogät. Y cooc̈h hänajty tøø nhoꞌogy, cumáax̱c‑høch hänajty njujypiøjtägatsaꞌañ ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Cabä Jesús jaꞌa jiamiøødhajxy ñäꞌägädä wiinjuøøyy waam̱batiä Jesús hänajty tøø miädiaꞌagy. Cab hajxy hänajty jia näꞌä wiꞌi miäyajtøwaam̱bä. Hix̱, tsähgøøby hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mänit hajxy jim̱ miejch Capernaum maa hajxy hänajty chänaꞌayän. Coo hajxy hänajty tøø tiøjtägøꞌøy, mänitä Jesús jaꞌa jiamiøødtøjc miäyajtøøyy: ―Tii hajxy hijty mwiꞌi yajcapxiøøby jim̱ tuꞌhaam‑miim̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero cab hajxy waam̱b ñäꞌägädä hadsooyy. Hix̱, jueꞌe hajxy hänajty tøø yajtsibøꞌøy tuꞌhaam‑miim̱bä, pøṉä cuhdujt hänajty maas møc møød. Tsähdiuum̱b hajxy hänajty, paady hajxy quiaꞌa näꞌägädä hadsooyy. ");
INSERT INTO mirNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mänitä Jesús yhäñaaguiädaacy, Mänitä jiamiøødtøjc ñämaayy, jaꞌa hajxy hänajty nämajmetspä: ―Yam̱ hajxy weeṉ̃tiä huuc møjwaꞌag. Pøṉ jaduhṉ pøc‑juøøby coo møjcuhdujt miøødhádät, cabä cuhdujt jaduhṉ ñäꞌägädä møødhadaꞌañ. Moonsä jaduhṉ ñäꞌägä tunaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mänitä Jesús pigänaꞌc‑huung tuꞌug miøjyaax̱y. Mänit piädaacy cujc maa jaꞌa jiamiøødhajxy hänajtiän. Mänit chehṉøꞌcy. Mänitä jiamiøødtøjc ñämaayy: ");
INSERT INTO mirNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Pøṉ hädaa pigänaꞌc hädaaduhm̱bä tsojp jaꞌa høøc̈hcøxpä, jaduhṉ mäwíinhøch xchojpä. Jaanä jadúhṉhøc̈hä nDeedy hajxy xchójcäbä ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Mänitä Juan jaꞌa Jesús ñämaayy: ―Wiindsǿṉ, tøø højts jäyaꞌay tuꞌug nbaady. Jim̱ä paꞌamjäyaꞌay hänajty yajpaꞌamnax̱y, jaꞌa hajxy møjcuꞌumøødpä. Miic̈hä mxøø hänajty xquiapxpáatäp. Mänit højts nnämaayy coo quiaꞌa yajpaꞌamnájxnät. Paady højts jaduhṉ nnämaayy, coo højts näguipxy xquiaꞌa møødwädíjtäm. ");
INSERT INTO mirNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mänitä Jesús miänaaṉ̃: ―Cábäts hajxy waam̱b cu mnämaayy. Pǿṉhøc̈hä nxøø xquiapxpáatäp coo jaꞌa hoy‑yagjuǿøñäbä hänajty yajcähxøꞌøgy, cábøch jaduhṉ xchoj mägapxtägoyyaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pøṉ højts jaduhṉ xquiaꞌa mädsiphájtäm, jeꞌeds hajxy jaduhṉ xmiäguꞌughájtäm. ");
INSERT INTO mirNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Coo mijts pøṉ xyajnøøhúꞌugät jeꞌeguiøxpä cooc̈h mijts xpiawädity, høøc̈h jaꞌa Cristo, jim̱ä hoyhajtä weenhajt piaadaꞌañ Dioswiinduum. ");
INSERT INTO mirNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Pønjátyhøc̈hä nmädiaꞌagy xmiäbǿjcäp, hoy hajxy quiaꞌa jagä høxpøquiä, coo hajxy jiøjcapxøꞌøwǿøjät, jaꞌa hänaꞌc‑hajxy jaduhṉ mäjøjcapxøøbiä, mejor paandsaa hajxy häxøpy tøø yajyoꞌxodsøꞌøyii, jaduhṉds hajxy häxøpy tøø miejjiäwipøꞌøyii. ");
INSERT INTO mirNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Pø jim̱ä mgøꞌø hänajty xyajcädieey, maas hoy jaduhṉ coo mnäꞌägädä høxpúxät, jaduhṉ tehṉgajnä xquiaꞌa yajcädiéhñät. Jadúhṉäts homiänaajä mjugyhádät nebiä Dios jiugyhatiän, hoyyä mgøꞌø hänajty metsc mgaꞌa jagä møødä. Hix̱, coo tehṉgajnä mjaac cädiéeyät, jiiby mhädáꞌagät haxøøgtuum maa jaꞌa jøøn mänaa quiaꞌa näꞌägädä piꞌic̈hän, hoyyä mgøꞌø hänajty jia caꞌxiä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Jaanä jaduhṉduhm̱bä, pø jim̱ä mdecy hänajty xyajcädieey, maas hoy jaduhṉ coo mnäꞌägädä høxpúxät, jaduhṉ tehṉgajnä xquiaꞌa yajcädiéhñät. Jadúhṉäts homiänaajä mjugyhádät nebiä Dios jiugyhatiän, hoyyä mdecy hänajty metsc mgaꞌa jagä møødä. Hix̱, coo tehṉgajnä mjaac cädiéeyät, jiiby mhädáꞌagät haxøøgtuum, hoyyä mdecy hänajty jia caꞌxiä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jaanä jaduhṉduhm̱bä, pø jim̱ä mwiin hänajty xyajcädieey, maas hoy jaduhṉ coo mnäꞌägädä yajpädsǿm̱ät, jaduhṉ tehṉgajnä xquiaꞌa yajcädiéhñät. Jadúhṉäts homiänaajä mjugyhádät nebiä Dios jiugyhatiän, hoyyä mwiin hänajty metsc mgaꞌa jagä møødä. Hix̱, coo tehṉgajnä mjaac cädiéeyät, jiiby mhädáꞌagät haxøøgtuum, hoyyä mwiin hänajty jia caꞌxiä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jiiby haxøøgtuum, cabä tøønghajxy jiiby mänaa ñäꞌägä hoꞌogy, møød cabä jøøn jiiby mänaa ñäꞌägä piꞌtspä. ");
INSERT INTO mirNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Pøṉ jiiby hijp haxøøgtuum, cab hajxy jaduhṉ jiiby mänaa quiøx̱y toyaꞌañ. Jaduhṉ mäwíinäts jeꞌe nebiä tsuꞌuc̈h caanøꞌøybän, cabä jøøn jaduhṉ jiiby mänaa pyiꞌic̈h. ");
INSERT INTO mirNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jaꞌa caan, tuuṉgpaatp jeꞌe. Pero coo jaꞌa tiaamdspä quiǿxät, cab jaduhṉ mänaa tiuuṉgpáatnät. Jaduhṉ mäwíinäts mijtspä, hoy yajxóṉ hajxy mnimiøødhidǿøjät. Cab hajxy jaduhṉ mänaa myajniguiudsip myajniguiumaꞌadøꞌøwǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mänitä Jesús jim̱ chóhṉgumbä Capernaum. Mänit ñøcxy Judea‑naaxooty, jaꞌa xøøbädsøm̱yhaampiä, jim̱ Jordán‑møjnøøhawiimb. Mänitä jäyaꞌay may ñäméjtsägumbä. Mänitä Jesús tiägǿøguiumbä yajnähixøøbiä, neby hänajty nax̱y yajnähixøꞌøyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mänitä fariseodøjc‑hajxy näjeꞌe miejch. Mänitä Jesús hajxy miäyajtøøyy: ―Nej, miim̱bä cuhdujt jaduhṉä coo jäyaꞌayhajxy ñiyhøxmadsǿøjädä. Paadiä Jesús jaduhṉ miäyajtøøw̱ä, hijxmadsáaṉäp hänajty jaduhṉ waam̱b hänajty yhadsowaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mänitä Jesús yajtøødägajch: ―Nej, jaduhṉä Moisés jecy quiujahyyä coo hajxy mniyhøxmadsǿøjädä. ");
INSERT INTO mirNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mänitä fariseoshajxy yhadsooyy: ―Jaduhṉä Moisés jecy quiujahy coogä cuhdujt jaduhṉ myiṉ̃ coo jäyaꞌayhajxy ñiyhøxmadsǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mänitä Jesús miänáaṉgumbä: ―Coo mijts mjaanc̈h tehm̱ quiuhxex̱ä, paadiä Moisés jaꞌa cuhdujt jaduhṉ jecy yejcy coo mdoꞌoxiøjc hajxy mhøxmádsät. ");
INSERT INTO mirNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mänaa jaꞌa naax̱wiimbä jecy yhawijy tiøøꞌxtaꞌaguiän, mänitä Dios jäyaꞌay metsc quiunuuꞌxy yaꞌadioꞌoxy. ");
INSERT INTO mirNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Coo jaꞌa Dios jaꞌa jäyaꞌay jaduhṉ jecy quiunuuꞌxy yaꞌadioꞌoxy, paadiä yaꞌadiøjc jaduhṉ tioꞌoxiøjwiingpǿgät. Jaduhṉ hajxy jaduhṉ yhíjnät nebiä tuꞌqueꞌexpän. Hawiingøøby hajxy jaduhṉ. Cab hajxy wioow̱híjtänä jaꞌa tiaj jaꞌa tiéediäm. ");
INSERT INTO mirNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pønjatiä Dios jaduhṉ tøø quiunuuꞌxy coo hajxy ñimiøødtsänaꞌawøød nämetsc, cab hajxy jaduhṉ ñiyhøxmadsǿøjät ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mänitä Jesúshajxy tiøjtägøøyy møødä jiamiøødtøjc. Mänitä Jesús jadähooc miäyajtøøw̱ä jaꞌa jiamiøød waam̱batiä Jesús jaꞌa fariseodøjc hänajty tøø miøødmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mänitä Jesús yhadsooyy: ―Pøṉä tioꞌoxiøjc høxmajtsp, y mänitä wiingtoꞌoxiøjc wyiingpøcy, miägädiehbiä tioꞌoxiøjc jaduhṉ. Haxøøg jaduhṉ jiatcøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jaanä jaduhṉduhm̱bä, coo jaꞌa toꞌoxiøjc ñihyhap yhøxmádsät, y coo wiingyaꞌadiøjc wyiingpǿgät, jaduhṉä ñihyhap miägädiehbiä. Jaanä haxøøg jeꞌeduhṉ jiatcøøbiä ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mänitä Jesús pigänaꞌc mejtstägøøg yajnämejtsä, coo hajxy ween quiunuuꞌxyii. Coo jaꞌa Jesús jiamiøød hajxy jaduhṉ yhijxy cooc tyijy jaꞌa Jesús hänajty yhadsibaꞌañii, mänitä pigänaꞌcä tiajhajxy yhadújcäxä coo jaꞌa Jesús hajxy jaduhṉ quiaꞌa nänǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Coo jaꞌa Jesús jaduhṉ yhijxy coo jaꞌa pigänaꞌc‑hajxy hänajty wyiꞌi yhadugyii, mänitä Jesús jaꞌa jiamiøød yhojy: ―Caꞌa yøꞌø pigänaꞌc hajxy mwiꞌi yhaducy. Wéenhøch hajxy jaduhṉ xñämiṉ̃. Coo mijtsä Diosmädiaꞌagy jaduhṉ mmäbǿgät neby hädaa pigänaꞌc‑hajxy miäbøquiän, mänit mijtsä Dios jaduhṉ xyhuunghádät. ");
INSERT INTO mirNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Hix̱, jaꞌa pigänaꞌc‑hajxy, cab hajxy tii quiaꞌa näꞌä mäbøcy. Tsipcøxp hajxy jaduhṉ ñäꞌägä mäbøcy. Jaduhṉds jeꞌe, coo mijts mmäbǿgät nebiä pigänaꞌc‑hajxy miäbøquiän, mänit hajxy jaduhṉ mjugyhádät cøjxtaꞌaxiøø nebiä Dios jiugyhatiän. Tøyhajt jaduhṉ ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mänitä Jesús jaꞌa pigänaꞌc tiägøøyy cunuuꞌxpä tuꞌugjaty‑tuꞌugjaty. Cøꞌønähgájpäp hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mänitä Jesús jim̱ chohṉ̃. Jim̱ hänajty tiuꞌuyoꞌoyñä, mänitä Jesús jäyaꞌay tuꞌug päyøꞌøguiä ñajtspaadøøyyä. Mänit wyiinjijcädaacä. Mänit ñämaayyä: ―Wiindsǿṉ, mjaanc̈h tehm̱ yhoyhänaꞌc miic̈h. Nébiøch ngudiúnät cooc̈h cøjxtaꞌaxiøø njugyhádät nebiä Dios jiugyhatiän ―nøm̱ä Jesús miäyajtøøw̱ä. ");
INSERT INTO mirNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Mänitä Jesús yhadsooyy: ―Tiic̈h miic̈h jaduhṉ coo xñämaꞌay cooc̈h nhoyhänaꞌcä. Ni pøṉ jaduhṉ quiaꞌa hoyhänaꞌcä. Jagooyyä Dios tuꞌuquiä yhoyhänaꞌcä. ");
INSERT INTO mirNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mnajuøøby miic̈h jaduhṉ nebiatiä Moisés cuhdujt jecy yejcy, túhm̱äts. “Cab hajxy mniyaghoꞌogǿøjät. Cabä wiingtoꞌoxiøjc hajxy mmøødtsänáꞌawät. Cab hajxy mméedsät. Cab hajxy mhøhṉdáꞌagät. Cab hajxy mmäméedsät høhṉdaꞌagymiädiaꞌagyhaam. Mwiingudsähgǿꞌøwäbä mdajjä mdeedy hajxy” ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mänitä Jesús ñämáayyägumbä: ―Pero Wiindsǿṉ, homiänáajøch jaduhṉ ngudiuṉ̃. Múutsnøc̈hä hoguiuhdujt nmädsohṉdaacy ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mänitä Jesús jaꞌa craa wyiinheeꞌppejty. Jiaanc̈h tehm̱ chójcäbä craa hänajty jeꞌe. Mänitä Jesús miänaaṉ̃: ―Tuꞌtuꞌuyyä mgaꞌa cøx̱y cudiuṉ̃. Nøcx cøx̱y toog tijaty jim̱ mmøød, jaduhṉds mmóꞌowät pønjaty hajxy häyoob. Coo jaduhṉ mgudiúnät, mänit jim̱ mnǿcxät Dioswiinduum. Jim̱ miic̈hä hoybä weenbä mbáadät tsajpootyp. Hoorä, høøc̈h paduꞌubǿjcäc. ");
INSERT INTO mirNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Coo jaꞌa craa jaduhṉ ñämaayyä, mänit jiootmadiägøøyy. Mänit wyiimbijnä tájjäp máayyäp. Hix̱, jaanc̈h tehm̱ miäyøø hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jim̱ä Jesús jaꞌa jiamiøødhajxy hänajty piadänaꞌay. Mänitä Jesús wyiinheeꞌppejty. Mänit miänaaṉ̃: ―Jaanc̈h tehm̱ chip jaduhṉ coo yøꞌø mäyøødøjc‑hajxy jim̱ ñǿcxät Dioswiinduum. Tehm̱ tiøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Coo jaꞌa Jesús jaduhṉ miänaaṉ̃, jiaanc̈h tehm̱ yagjuøøyy jaꞌa jiamiøødhajxy jaduhṉ. Mänitä Jesús miänáaṉgumbä: ―Mäguꞌughajpädøjc, pønjatiä xiädøꞌøñ hajxy hajoodhajp, jaanc̈h tehm̱ chip jaduhṉ coo hajxy jim̱ ñǿcxät Dioswiinduum. ");
INSERT INTO mirNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Maas paquiä camello tuꞌug jiiby ñaxǿꞌøwät xuhñdyjutooty quejee jaꞌa mäyøøhänaꞌc‑hajxy jim̱ tiägǿꞌøwät Dioswiinduum. ");
INSERT INTO mirNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Coo jaꞌa Jesús jaduhṉ miänáaṉgumbä, mänitä jiamiøødhajxy maas hanax̱iä yagjuǿøguiumbä. Mänitä Jesús miäyajtøøw̱ä: ―Pøṉxädaꞌaduhṉ jaanc̈h tøy nähwaꞌadsaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mänitä Jesús wyiinheeꞌppéjcumbä. Mänit miänaaṉ̃: ―Jaꞌa jäyaꞌayhajxy, cab hajxy hamdsoojoot hoy yajniñähwaꞌadsǿøjät. Pero Dios, jeꞌeds mäyajnähwaatsp. Hotyiijä Dios jaduhṉ jiaty. ");
INSERT INTO mirNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mänitä Pedro jaꞌa Jesús ñämaayy: ―Huuc mädow̱, coo højts miic̈h nbaduꞌubøjcy, cøjx højts nnähgueꞌegy tijaty højts hijty nmøød. ");
INSERT INTO mirNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Mänitä Jesús yhadsooyy: ―Pønjaty cøx̱iä tøø ñähgueꞌegy jaꞌa høøc̈hcøxpä møødä Diosmädiaꞌagyquiøxpä, maas may hajxy jaduhṉ jiaac paadaꞌañ hädaa yaabä naax̱wiin tijaty hajxy hänajty tøø ñähgueꞌegy tøø yhøxyoꞌoy, tiøjc, piuhyaꞌay, piuhdoꞌoxy, tiaj tieedy, yhuung, ñaax̱. Møød jim̱ hajxy ñøcxaꞌañ tsajpootyp. Jim̱ hajxy jaduhṉ homiänaajä yhidaꞌañ, hoy hajxy hänajty yaa tøø jia tsaac̈hpøcy jaꞌa høøc̈hcøxpä hädaa yaabä naax̱wiin. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pønjatiä møjtuuṉg jädaꞌahaty caꞌa møød, nämay hajxy miøjtägøꞌøwaꞌañ. Pero pønjatiä møjtuuṉg jädaꞌahaty ja møød, nämayyä tiuuṉghajxy piøgáaṉäxä ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mänitä Jesúshajxy jim̱ tiuꞌubøjcy møødä jiamiøødtøjc. Jerusalén hajxy hänajty ñøcxaꞌañ. Jawyiinä Jesús hänajty yoꞌoy. Mayyä jäyaꞌayhajxy hänajty pianøcxy møødä Jesús jiamiøødhajxy, jaꞌa hajxy hänajty nämajmetspä. Jaanc̈h tehm̱ yagjuøøby hajxy hänajty. Høxtä tsähgøøby hajxy hänajty. Mänitä Jesús jaꞌa jiamiøød hawiing wioonøcxy. Mänitä Jesús tiägøøyy mädiaacpä nebiaty hänajty jiadaꞌañ yhabetaꞌañ: ");
INSERT INTO mirNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Huuc mädow̱ hajxy, yam̱ hajxy nnǿcxäm Jerusalén. Coo hajxy jim̱ ngoodáaṉäm, mänítøc̈hä teedywiindsøṉhajxy xyajcøꞌødägøꞌøwaꞌañ, møødä hänaꞌcä Diosmädiaꞌagy hajxy jim̱ yajnähixøøbiä tsajtøgooty, høøc̈h jaꞌa Diosquex̱ypä. Mänítøch hajxy jaduhṉ xyajnähdijaꞌañ cooc̈h hajxy xyaghoꞌogaꞌañ. Mänítøch hajxy xyajcøꞌødägøꞌøwaꞌañ jaꞌa hänaꞌc‑hajxy jim̱ tsohm̱bä Roma. ");
INSERT INTO mirNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Madiúꞌujøch hajxy xchaac̈htiunaꞌañ. Xñäxiꞌigáam̱bøch hajxy. Xwyiinwoonáam̱bøch hajxy. Xwyiingutsujøꞌøwáam̱bøch hajxy. Xwiobhoꞌogáam̱bøch hajxy. Mänítøch hajxy xjia yaghoꞌogaꞌañ. Pero cudägøøgxǿøyyøch njujypiøjtägatsaꞌañ, ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mänitä Jesús wyiinguwaꞌagøøyyä jaꞌa Santiago møødä Juan. Jaꞌa Zebedeo yhuunghajxy hänajty jeꞌe. Mänit hajxy miänaaṉ̃: ―Wiindsǿṉ, huuc tuṉä mayhajt jaꞌa højtscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mänitä Jesús yhadsooyy: ―Tii mayhájthøch ndúnäp. ");
INSERT INTO mirNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mänitä Santiagohajxy miänáaṉgumbä: ―Coo miic̈h hänajty tøø mmøjtägøꞌøy, coo hänajty tøø mdägøꞌøy hanehm̱bä, mänit højts cuhdujt xmióꞌowät coo højts jim̱ nhäñáꞌawät miic̈hä mnähmøjc, hahooyhaampiä møød hanajtyhaampiä. ");
INSERT INTO mirNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mänitä Jesús yhadsóogumbä: ―Mijts, cab hajxy mnajuøꞌøy tii hajxy jaduhṉ mnänøøm̱by. Nej, mmeeꞌxtúgäp hajxy jaduhm̱bä nébiøch ndsaac̈hpøgáꞌañänä. ");
INSERT INTO mirNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mänitä Santiagohajxy yhadsooyy: ―Nmeeꞌxtúgäp højts jaduhṉ. Mänitä Jesús miänáaṉgumbä: ―Jaduhṉ mijts mjaanc̈h tsaac̈hpøgaam̱bä nébiøch ndsaac̈hpøgaꞌañän. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero cábøc̈hä cuhdujt jaduhṉ nmøødä coo mijtsä cuhdujt nmóꞌowät coo hajxy jim̱ mhäñáꞌawät høøc̈hä nnähmøjc mänáajøch hänajty tøø ndägøꞌøyän hanehm̱bä. Dios jaꞌa cuhdujt møød pøṉ yajnähdijaam̱by coo hajxy jim̱ yhäñáꞌawät. Jeꞌedshajxy jaduhṉ jim̱ häñaꞌawaam̱b ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Coo Jaha Jesús jiamiøødhajxy jaduhṉ miädooyy, jaꞌa hajxy hänajty jaac nämajcpä, mänitä Santiagohajxy miäjootmaꞌtä møødä Juan. ");
INSERT INTO mirNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mänitä Jesús miøjyaax̱y jaꞌa hajxy hänajty jaac nämajcpä. Mänitä Jesús miänaaṉ̃: ―Jaꞌa gobiernähajxy, møødä hänaꞌc‑hajxy yaa møjtuuṉgmøødpä hädaa yaabä naax̱wiin, jaꞌa hänáꞌcätshajxy jaduhṉ yaa hanehm̱b. Mnajuøøby hajxy jaduhṉ, túhm̱äts. ");
INSERT INTO mirNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Pero mijts, cab hajxy mbøc‑juǿꞌøwät coo møjtuuṉg hajxy mmøødhádät. Pøṉä jioot tsojp coo wyiingudsähgøꞌøwǿøjät, weenä jioot piädaꞌagy coo jiamiøød piuhbédät. ");
INSERT INTO mirNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Høøc̈hpaady, høøc̈h jaꞌa Diosquex̱ypä, mäbuhbéjpøch jaduhṉ yaa tøø ngädaꞌagy. Høxtä nnähhoꞌtuꞌudáam̱biøc̈hä jäyaꞌayhajxy nägøx̱iä. Cábøch jaduhṉ nmänaꞌañ cooc̈hä jäyaꞌayhajxy xpiuhbédät. ");
INSERT INTO mirNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mänitä Jesúshajxy quiooꞌty maa jaꞌa cajpt hänajty xiøhatiän Jericó. Coo hajxy jim̱ chóhṉgumbä, mayyä jäyaꞌay hajxy piaduꞌubøjcä. Jim̱ä wiinds hänajty tuꞌug yhäñaꞌay tuꞌhaam. Bartimeo hänajty xiøhaty. Timeo jaꞌa tieedy hänajty xiøhaty. Xädøꞌøñyujwaam̱bä Bartimeo hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Coo jaꞌa Bartimeo jaduhṉ miädooyy coo hänajty jeꞌe Jiesúsä, jaꞌa hänajty tsohm̱bä Nazaret, mänitä Bartimeo møc yaax̱y: ―Jesús, David miic̈h jecy mhaphajt mdeedyhajt. Høøc̈h näxúuꞌtsäc. ");
INSERT INTO mirNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mänitä Bartimeo yhojmujcä nämay coo cu yhamooṉ̃. Pero cab jaduhṉ ñäꞌä hamooṉ̃. Tehṉgajnä maas møc tiägøøyy yaax̱pä: ―Jesús, miic̈hä David jecy mhaphajt mdeedyhajt. Høøc̈h näxúuꞌtsäc. ");
INSERT INTO mirNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mänitä Jesús tiänaaxiøjpy. Mänit miänaaṉ̃ coo jaꞌa Bartimeo miøjyaꞌaxǿøjät. Mänitä Bartimeo tuꞌjäyaꞌay ñämaayyä: ―Xooṉdaꞌag, tänaayyøꞌøg. Xim̱ä Jesús xmiøjyaꞌaxy. ");
INSERT INTO mirNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mänitä Bartimeo paquiä tiänaayyøꞌcy. Mänitä yoṉ̃wit yajniñähnajptuutä. Mänitä Jesús päyøꞌøguiä hoy wyiingumedsøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mänitä Jesús jaꞌa Bartimeo miäyajtøøyy: ―Tii mayhajt jaduhṉ myajtunáaṉäp. Mänitä Bartimeo yhadsooyy: ―Wiindsǿṉ, høøc̈h yaghijxǿꞌcäc. ");
INSERT INTO mirNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mänitä Jesús miänaaṉ̃: ―Jaꞌa hoy, tisän coo quiaꞌa cabä. Cooc̈hä nmädiaꞌagy tøø xmiäbøjcä, paady tøø mhijxøꞌnø. Tuuṉä Jesús jaduhṉ ñäꞌä mänaaṉ̃, mänitiä Bartimeo jiaanc̈h hijxøꞌcy. Mänitä Jesús piaduꞌubøjnä. ");
INSERT INTO mirNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jim̱ä Jesúshajxy hänajty quioodaaṉnä maa jaꞌa cajpt hänajty xiøhatiän Betfagé møød Betania, jim̱ mädøyyä maa jaꞌa tuṉ hänajty xiøhatiän Olivos. Jim̱ hänajty miäwiingóṉ Jerusalén. Mänitä Jesús jaꞌa jiamiøød metsc ");
INSERT INTO mirNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ñämaayy: ―Nøcx hajxy jim̱haamby maa yøꞌø cajpthuungän. Coo hajxy jim̱ mmedsaꞌañ, jim̱ä burro hajxy tuꞌug mbaadaꞌañ cuxoch. Cahnä pøṉ yajpejmachñä. Mmäguejǿꞌøwäp hajxy. Jaduhṉds hajxy yaa mwitsmínät. ");
INSERT INTO mirNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Y pø jim̱ä jäyaꞌay hajxy xmiäyajtøy tii hajxy jaduhṉ coo mmäguejøꞌøy, mänit hajxy mnämáꞌawät: “Jaꞌa nwiindsǿṉ højts cham̱ yajmaajiajp. Paquiä højts nnäꞌä yajtunaꞌañ. Mänit højts miṉ nnajtswidsøꞌøy.” Jaduhṉ hajxy mmänáꞌanät ―nøm̱ä Jesús ñajtscapxøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Mänitä burro hajxy hoy jiaanc̈h paady cuxoch jim̱ møjtuꞌhaam, jim̱ tøjnähmøjc mädøyyä. Jim̱ä jäyaꞌayhajxy hänajty näjeꞌe tiänaꞌay. Coo jaꞌa Jesús jiamiøødhajxy tiägøøyy burromäguejøøbiä, mänit hajxy ñämaayyä: ―Tii yøꞌø burro hajxy jaduhṉ coo mmäguejøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mänit hajxy jaduhṉ yhadsooyy waam̱baty hajxy hänajty tøø yhaneꞌemyii coo hajxy jaduhṉ yhadsówät. ");
INSERT INTO mirNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mänitä Jesús jaꞌa burro yajnäméjtsäxä. Mänitä jiamiøødä wyit hajxy jim̱ piädaacy burronähgøxp. Mänitä Jesús jim̱ piejty. ");
INSERT INTO mirNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jaanc̈h tehm̱ miayyä jäyaꞌayhajxy hänajty pianøcxy. Mänitä wyit hajxy näjeꞌe chijy. Jaduhṉds hajxy tuꞌhaam ñajtsyeꞌebøøyy maa jaꞌa Jesús hänajty burronähgøxp ñaxøꞌøwaꞌañän. Näjeꞌe hujtshaay hajxy hänajty piujxpä. Jim̱ hajxy hänajty piädaacpä tuꞌhaam. ");
INSERT INTO mirNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Cuꞌughagujcä Jesús hänajty ñøcxy. Mänitä cuꞌughajxy nägøx̱iä tiägøøyy yaax̱pä jojpä: ―¡Viva Jesús, viva! ¡Gloria a Dios! Diosquex̱y hädaa Jesús jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Gloria a Dios tsajpootypä! Jaduhṉ hädaa Jesús yhaneꞌemaam̱bä nebiä David jecy yhanehm̱iän, jaꞌa hajxy jecy nhaphajt ndeedyhájtäm. ");
INSERT INTO mirNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mänitä Jesúshajxy jim̱ quiooꞌnä Jerusalén, møødä jiamiøød jaꞌa nämajmetspähajxy. Mänit hajxy jim̱ ñøcxøøyy maa jaꞌa tsajtøjcän. Coo hajxy jiiby chajtøjtägøøyy, mänit hajxy yhijxwädijty tijaty hänajty jiiby. Mänit hajxy wyiimbíjcumbä. Mänit hajxy jiiby yhädáaccumbä Betania. Hix̱, tøø hänajty chuujøꞌøy, y jiiby hajxy hänajty miejtstaꞌagaꞌañ Betania. ");
INSERT INTO mirNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cujaboom, mänitä Jesúshajxy jim̱ tiuꞌubǿjcumbä. Mänitä Jesús yähoꞌpøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mänitä piids tuꞌug ñäheebøøyy coo hänajty jim̱ tiänaꞌay picxum̱nä. Coo wiingóṉ ñämejch, mänit yhijxy coo tiøøm hänajty quiaꞌa näꞌägädä hity. Haagä haay hänajty jeꞌe. Cahnä yhiiꞌts hänajty yhabaadyñä mänaabä hänajty nax̱y tiøømbetiän. ");
INSERT INTO mirNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mänitä Jesús piids ñämaayy: ―Ni mänaa miic̈h mgaꞌa tøømbejtägatsaaṉnä. Coo jaꞌa Jesús jaduhṉ miänaaṉ̃, miädoow̱ jaꞌa jiamiøødhajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Coo jaꞌa Jesúshajxy jim̱ miejtstägajch Jerusalén, mänitä Jesús jiiby chajtøjtägǿøguiumbä. Mänitä Jesús jaꞌa tooꞌpädøjc juubiädøjc tiägøøyy høxpäboobiädsøøm̱bä jiiby tsajtøgooty. Mänitä meexä tiägøøyy høxjuijpä maa xädøꞌøñ hajxy hänajty quiuwichän, møødä häñaabiejt maa hajxy hänajty yhäñaꞌayän coo hajxy hänajty pialomatoogy. ");
INSERT INTO mirNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mänitä Jesús tiägøøyy hadujpä coo jaꞌa jäyaꞌayä tioogy hajxy jiiby quiaꞌa mädägǿøñät tsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mänitä Jesús tiägøøyy yajwiingapxøøbiä: ―Jaduhṉ jim̱ myiṉ̃ cujaay maa jaꞌa Diosmädiaꞌaguiän: “Paꞌyaax̱táacthøc̈hä ndøjc hajxy nägøx̱iä xwiáaṉät, jaꞌa jäyaꞌayhajxy wiinduhm̱yhagajptpä.” Jaduhṉä Dios jecy miänaaṉ̃. Pero mijts, wiing mijtsä tsajtøjc mwaꞌañ. Jaduhṉ hajxy mwaꞌañ nebiä meeꞌtstaactän ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Coo jaꞌa teedywiindsøṉhajxy jaduhṉ miädooyy, møødä hänaꞌcä Diosmädiaꞌagy hajxy hänajty jiiby yajnähixøøbiä tsajtøgooty, mänit hajxy tiägøøyy cojyquiapxytiuum̱bä nebiä Jesús hajxy yaghóꞌogät. Hix̱, chähgøøbiä Jesús hajxy hänajty jeꞌeguiøxpä coo jaꞌa Jesús jaꞌa miädiaꞌagy hänajty jiaanc̈h tehm̱ yhamädoow̱híjtäxä jaꞌa cuꞌug. ");
INSERT INTO mirNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pero coo quioodsøøñä, mänitä Jesúshajxy jiiby yhädáaccumbä Betania. ");
INSERT INTO mirNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cujaboomä Jesúshajxy ñøcxtägajch Jerusalén. Coo hajxy jim̱ ñaxǿøguiumbä maa jaꞌa Jesús jaꞌa piids hänajty tøø ñäbogøꞌøyän, mänitä piids hajxy yhijxy coo hänajty tøø quiøx̱y tøꞌøc̈h. ");
INSERT INTO mirNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Coo jaꞌa Pedro jaduhṉ jiahmiejtstaacy, mänitä Jesús ñämaayyä: ―Wiindsǿṉ, huug hix̱ yøꞌø piids. Häxøøy miic̈h yøꞌø mnäbogøøyy coo ni mänaa quiaꞌa tøømhájnät. Tøø yøꞌø quiøx̱y tøøtsnä ―nøm̱ä Pedro miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mänitä Jesús yhadsooyy: ―Mäbøjcä jaꞌa Dios miädiaꞌagy coo jiaanc̈h tehm̱ tiømiädiaꞌaguiä. ");
INSERT INTO mirNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Coo hajxy hamuumduꞌjoot mmäbǿgät, høxtä yøꞌø tuṉ jaꞌa mmädiaꞌagyhajxy xquiudiúuṉäp coo hajxy mnämáꞌawät coo ween nøcxy miejyquiaꞌawøꞌøy. Mänitä mmädiaꞌagyhajxy jaduhṉ xquiudiúuṉät coo jaꞌa Dios jaꞌa miädiaꞌagy hajxy hamuumduꞌjoot mmäbǿjcät coo tiømiädiaꞌaguiä. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Coo mijtsä Dios tijaty mmäyujwáꞌanät, xmióꞌowäp hajxy jaduhṉ, coo jaꞌa miädiaꞌagy hajxy hamuumduꞌjoot mmäbǿjcät coo tiømiädiaꞌaguiä. ");
INSERT INTO mirNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Coo mijtsä Dios hänajty mbaꞌyaꞌaxaꞌañ, tsipcøxpä hänaꞌc hajxy jayøjp mmäméeꞌxät, jaꞌa mijts hänajty tøø xñägädieeyǿꞌøyäbä, jaduhṉä Dios hajxy jaduhṉ xmiäméeꞌxpät tijaty hajxy hänajty mgädieeyhajpy. ");
INSERT INTO mirNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero pø cab hajxy mmämeeꞌxaꞌañ, ni mijtsä mDeedy tsajpootypä xquiaꞌa mämeeꞌxtägatsaꞌañ ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Coo jaꞌa Jesúshajxy jim̱ quiooꞌtägajch Jerusalén, mänitä Jesús jadähooc tiägøøyy tsajtøgooty. Jiibiä Jesús hänajty wiädity, mänit ñämejtsä jaꞌa teedywiindsǿṉ, møødä hänaꞌc‑hajxy jiiby yajnähixøøbiä tsajtøgooty, møødä majjäyaꞌadiøjc. ");
INSERT INTO mirNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mänitä Jesús hajxy miäyajtøøyy: ―Pøṉ miic̈h cuhdujt tøø xmioꞌoy coo miic̈h häxøøy yaa tsajtøgooty tøø mdsiptuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Mänitä Jesús yhadsooyy: ―Nhadsóow̱äbøch häyaa jaduhṉ cooc̈h mijts häyaa jayøjp xyhadsóow̱ät. Pøṉä Juan mäyajnäbejpä quejx, Diosä tøgä jäyaꞌayä. Hadsóow̱ägøch hajxy. Cooc̈h hajxy häyaa xyhadsóow̱ät, mänítøch mijts häyaa nhadsoodägájtspät ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Cabä teedywiindsøṉhajxy hänajty ñajuøꞌøy waam̱bä Jesús hajxy yhadsówät. Mänit hajxy tiägøøyy niñämáayyäbä: “Coo hajxy häyaa nmänáaṉämät coo jaꞌa Dios jaꞌa Juan quiejxy, jaduhṉ jadähooc xyhadsowáaṉäm: Aa, pø tøyhajt jaduhṉ coo jaꞌa Dios jaꞌa Juan jiaanc̈h quejxy, tii jaꞌa Juan miädiaꞌagy hajxy coo tøø mgaꞌa mäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Y coo hajxy häyaa nmänáaṉämät coo jaꞌa Dios jaꞌa Juan quiaꞌa quejxy, mänitä cuꞌug hajxy häyaa xmiädsibǿøyyämät.” Hix̱, jaduhṉä cuꞌughajxy hänajty miänaꞌañ coogä Juan hänajty Dyiosquex̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mänitä Jesús hajxy ñämaayy coo hajxy hänajty quiaꞌa najuøꞌøy. Mänitä Jesús yhadsooyy: ―Pues, ni høøc̈h jaduhṉ ngaꞌa nägapxaam̱bä pǿṉhøchä cuhdujt tøø xmioꞌoy. ");
INSERT INTO mirNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mänitä Jesús tiägøøyy yajnähixøøbiä cuentäyajmäbaadyhaam: ―Mänitä jäyaꞌay tsaatypcam̱ tuꞌug piädaacy. Mänit jiuhguraajøøyy. Mänitä tsaatyñøøxeeꞌxøhñdy ñädajøøyy. Mänitä nähbettøjc tuꞌug yhädiuuṉ̃ coo hajxy jim̱ yhäñáꞌawät coo jaꞌa tsaatypcam̱ hajxy hänajty cwieendähadaꞌañ. Mänitä wiingjäyaꞌay jaꞌa tsaatypcam̱ hajxy yajcøꞌødägǿøyyäxä coo hajxy cøguipxyjiaty cwieendähádät. Mänitä cudsaatyp jäguem̱naax̱ ñøcxy. ");
INSERT INTO mirNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Coo jaꞌa tsaatyptuc yhabaaty, mänitä cudsaatyp jaꞌa mioonsä quiejxy coo hajxy cøgujjiä ween yajwaꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Coo jaꞌa craa jim̱ miejch, mänit hoyhoy quioxhoꞌcä. Mänit piäboowyiimbijtä cøꞌøwaꞌads. ");
INSERT INTO mirNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mänitä cudsaatyp jaꞌa mioonsä mäwiingpä jia quéjxcumbä. Maas hanax̱iä craa jeꞌe wiobhóꞌcäbä. Høxtä yajtsäbíjtäxä jaꞌa quiopc jaduhṉ. Hoyhoy jaduhṉ chaac̈htiuuṉä. ");
INSERT INTO mirNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mänitä cudsaatyp jaꞌa mioonsä mäwiingpä jia quéjxcumbä. Mänit hajxy jeꞌe yaghoꞌcy. Maas mayyä mioonsä jia jaac tehm̱ quiejxy. Näjeꞌe hajxy wiobhoꞌcä; näjeꞌe hajxy yaghoꞌcä. ");
INSERT INTO mirNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Jim̱ä cudsaatyp jaꞌa yhuung hänajty tuꞌug. Jiaanc̈h tehm̱ chojpiä yhuung hänajty. Mänit ñämaayy: “Nhuuc quéx̱yhøch miic̈h jim̱. Wehṉdä miic̈h hajxy häyaa xñäꞌä wiingudsähgǿꞌøwät.” ");
INSERT INTO mirNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Coo jaꞌa cudsaatyp yhuung jim̱ miejch, mänit hajxy tiägøøyy niñämáayyäbä, jaꞌa tsaatypcam̱ hajxy hänajty tøø miämähmǿꞌøyäbä: “Coo hädaa craa tieedy häyaa ñäꞌä hóꞌogät, hädaa craa jaduhṉ cøx̱iä mämähmøꞌøwaam̱b mäduhṉ̃tiä hädaa tsaatypcam̱. Tsøc hädaa craa hajxy jaduhṉ näꞌägä yaghóꞌcäm, jaduhṉ højts hädaa tsaatypcam̱ njeꞌehájtämät.” ");
INSERT INTO mirNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mänitä cudsaatyp yhuung miájtsäxä. Mänit yaghoꞌcä. Mänit hajxy hoy yhøxchøm̱y jäguem̱juøøby. ");
INSERT INTO mirNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Haa, nebiä cudsaatypädaꞌa hänajty jiatcøꞌøwaꞌañ. Nøcxaam̱bädaꞌa hajxy yaghoꞌtägatsaꞌañii, jaꞌa hajxy hänajty tøø miäyaghóꞌoguiäbä. Mänitä wiinghänaꞌcä tsaatypcam̱ hajxy hänajty yajcøꞌødägøꞌøwaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Jaduhṉ jim̱ myiṉ̃ cujaay maa jaꞌa Diosmädiaꞌaguiän: Jaꞌa tsaa mädyii jaꞌa tøjmuuꞌtspädøjc‑hajxy quiaꞌa näꞌägä cumaayy, jeꞌe näꞌägä tuuṉdsohṉ maa jaꞌa tøjteecän. ");
INSERT INTO mirNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jaꞌa Dios jaduhṉ mänaaṉ coo jaꞌa tsaa jaduhṉ jim̱ tiuuṉdsóonät. Paady hajxy jaduhṉ jaanc̈h tehm̱ yajxóṉ nhíjxäm ―nøm̱ä Jesús miädiaacy. ");
INSERT INTO mirNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jaꞌa teedywiindsøṉhajxy, ñajuøøby hajxy hänajty jaduhṉ coo hajxy hänajty tøø yajmäbaadyii nebiä cahwiindøyhänaꞌcän, jaꞌa hajxy hänajty tsaatypcueendähajpä. Coo hajxy jaduhṉ ñajuøøyy, paadiä Jesús hajxy hänajty jia wiꞌi miadsaꞌañ. Pero cab hajxy jaduhṉ ñäꞌä majch, jeꞌeguiøxpä coo jaꞌa cuꞌug hajxy hänajty chähgøꞌøy. Mänitä Jesús hajxy ñähgueecnä. Mänit hajxy wyiimbijnä. ");
INSERT INTO mirNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mänitä fariseoshajxy näjeꞌe wyiinguejxä, møødä Herodes quiuꞌughajxy näjeꞌebä, coo jaꞌa Jesús hajxy yajcapxtägóyyät, jaduhṉ hajxy hoy ñäxøꞌøwǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mänitä Jesús ñämejtsä. Mänit ñämaayyä: ―Nnajuøøby højts coo miic̈h tøy mjaanc̈h tehm̱ miädiaꞌagy. Caj miic̈h jaduhṉ mnäꞌägä møjpädaꞌagy waam̱batiä cuꞌug xjia nämaꞌay. Tuꞌcuhdujt miic̈hä jäyaꞌay mhix̱y, pønjaty hajxy mäyøø, pønjaty hajxy häyoob. Tøyhajt højts miic̈h xyajnähixøꞌøy coo højts hoy njäyaꞌayhádät nebiä Dios choquiän. Hoorä, coo højtsä gobiernä Rómabä hänajty xyajnähjuudiuꞌudaꞌañ, nej, hahixøøby jaduhṉ coo højts nnähjuudiúꞌudädä ―nøm̱ä Jesús miäyajtøøw̱ä. ");
INSERT INTO mirNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mänitä Jesús yhadsooyy: ―Tiic̈h hajxy jaduhṉ coo xjia wiꞌi yajcapxtägoyyaꞌañ. Høøc̈hä xädøꞌøñ tuꞌug huuc yaghíjxäc. Paadiä Jesús jaduhṉ miänaaṉ̃, ñajuøøby hänajty jaduhṉ coo hänajty jia wiꞌi yajcapxtägoyyaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mänitä Jesús xädøꞌøñ jiaanc̈h yaghijxä. Mänit miänaaṉ̃: ―Pøṉ wyiin jiøjp yøꞌøduhṉ. Pøṉ xiøø yøꞌøduhṉ jim̱ miim̱b. Mänit hajxy yhadsooyy: ―Jaꞌa gobiernä wyiin jiøjp yøꞌø, jaꞌa jim̱ tuum̱bä Roma. Jaayaꞌay xiøø yøꞌøbä. ");
INSERT INTO mirNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mänitä Jesús miänáaṉgumbä: ―Tøyhajt jaduhṉ. Moꞌowxä jaꞌa gobiernä hajxy pø jeꞌe jieꞌe yøꞌø. Pero mädyii jaꞌa Dios jieꞌe, moꞌow hajxy jeꞌebä. Coo jaꞌa Jesús jaduhṉ yhadsooyy, jaanc̈h tehm̱ yagjuøøyy jaꞌa fariseoshajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mänitä Jesús jaꞌa saduceos näjeꞌe ñämejtsä. Cabä saduceoshajxy hänajty miäbøcy coogä hoꞌogyjiäyaꞌayhajxy hänajty jiujypiøjtägatsaꞌañ. Jaduhṉä saduceoshajxy hänajty miänaꞌañ cooc tyijy jaꞌa hoꞌogyjiäyaꞌayhajxy quiaꞌa jujypiøjtägatsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Mänitä saduceos jaꞌa Jesús hajxy ñämaayy: ―Wiindsǿṉ, jaduhṉä Moisés jecy quiujahy neby højts nguhdujthájtämät, højts judíojäyaꞌayhájtäm. Hoorä, coogä yaꞌadiøjc tuꞌug yhóꞌogät, coog hänajty piøquiä, pø cáhnäg hajxy hänajty yhuungpaadyñä, pø jím̱ägä piuhyaꞌay, wéenägä piuhyaꞌay jaꞌa yaamgtoꞌoxy wyiingpøcy, jadúhṉäc hajxy jaduhṉ yhuungpáadät. Jadúhṉäc quiähxǿꞌøgät coog hänajty jeꞌe yhuungä, jaꞌa hänajty tøø yhóꞌoguiäbä. ");
INSERT INTO mirNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hoorä, jii jäyaꞌayhajxy hänajty näjuxtujyaꞌay, haagä tuꞌqueꞌex. Mänitä tehm̱ quioobhuung tioꞌoxiøjwiingpøjcy. Cab jejcy miøødtsänaayy, mänitä craa yhoꞌcy. Cabä huung hajxy ñäꞌä paaty. ");
INSERT INTO mirNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mänitä jiødsøm̱y jaꞌa yaamgtoꞌoxy wyiingpøjcy. Ni jeꞌehajxy quiaꞌa huungpaatpä. Mänitä craa yhoꞌpä. Jaduhṉä jiødsøm̱y jeꞌebä jia wiingpǿjcumbä. Jaanä jaduhyyä jeꞌe jiajpä nebiä yhajchhajxy jiajtiän. ");
INSERT INTO mirNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jaduhṉ hajxy näjuxtujc jia møødtsänaayy, ni pøṉ jeꞌe quiaꞌa yaghuungpaaty. Nägøx̱iä hajxy jaduhṉ yhoꞌcy. Høxtä jaꞌa toꞌoxiøjc, jaac tehm̱ yhoꞌc jeꞌebä. ");
INSERT INTO mirNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bueno, coo jaꞌa hoꞌogyjiäyaꞌayhajxy hänajty nägøx̱iä jiujypiøjtägatsaꞌañ, pøndaꞌa jeꞌe tehm̱ tiøybä møødtsänaꞌawaam̱b, jaꞌa hajxy hänajty näjuxtujcpä. Hix̱, näjuxtujc hajxy hänajty tøø jia møødtsänaꞌay. Paady højtsä tøyhajt ndsocy ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mänitä Jesús yhadsooyy: ―Caj mijtsä tøyhajt hajxy mnäꞌägä møødä, jeꞌeguiøxpä coo jaꞌa Diosmädiaꞌagy hajxy mgaꞌa näꞌägädä wiinjuøꞌøy. Møød cab hajxy mnajuøøbiä nebiatiä Dios jaꞌa miøcmäjaa yajcähxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Coo jaꞌa hoꞌogyjiäyaꞌayhajxy hänajty jiujypiøjtägatsaꞌañ, cab hajxy mänit piøgaꞌañ, cab hajxy mänit yhuꞌugaꞌañ. Jaduhṉ hajxy yhidaꞌañ nebiä Diosmoonsähajxy jim̱ yhitiän tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tii mijts coo mgaꞌa mäbøgaꞌañ coo jaꞌa hoꞌogyjiäyaꞌayhajxy jiujypiøjtägatsaꞌañ. Jaduhṉä Moisés jecy quiujahy coogä Dios tähooc miøødnibiaatä jim̱ pactuum maagä hujts haptymøødpä hänajty tioyyän. Mänítägä Dios jaꞌa Moisés ñämaayy: “Høøc̈hä Abraham xDyioshajp, møødä Isaac, møødä Jacob.” ");
INSERT INTO mirNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Coo jaꞌa Dios jaduhṉ jecy miänaaṉ̃, jaduhṉä tøyhajt hajxy nmøødhájtäm coo jaꞌa Abrahamhajxy hänajty tøø jiujypiøjtägach, møødä Isaac, møødä Jacob. Hix̱, jujcyjiäyaꞌay jaꞌa Dios jaduhṉ Dioshájtäp, caꞌa yhoꞌoguiäyaꞌayä. Coo mijts jaduhṉ mmänaꞌañ cooc tyijy jaꞌa hoꞌogyjiäyaꞌayhajxy quiaꞌa jujypiøjtägatsaꞌañ, caj mijtsä tøyhajt hajxy mnäꞌägä møødä ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jim̱ä jäyaꞌay hänajty tuꞌug yhamädoow̱hity. Tsajtøgooty hänajty tiuṉ̃. Coo miädooyy coo jaꞌa Jesús hänajty hoy tøø yhadsoy, mänitä Jesús hoy wyiinguwaꞌagøꞌøyii. Mänit ñämaayyä: ―Madiuꞌu jaꞌa Moisés hajxy jecy xyhanéhm̱äm. Mädyii jaduhṉ maas tuuṉgpaatp ―nøm̱ä Jesús miäyajtøøw̱ä. ");
INSERT INTO mirNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mänitä Jesús yhadsooyy: ―Jaduhṉ jeꞌe miänaꞌañ: “Pønjatiä Israel jecy haphajt teedyhajt, hamädoow̱hit hajxy. Jaꞌa Dios hajxy nWindsøṉhájtäm. Tuꞌuquiä Dios jaduhṉ Dyioshaty. ");
INSERT INTO mirNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Hamuumduꞌjootä Dios hajxy mjaanc̈h tehm̱ wyiingudsähgǿꞌøwät nägøꞌø nädecypiä. Mäbøjcä miädiaꞌagy hajxy homiänaajä. Jahmiets hajxy jaduhṉ cøjxtaꞌaxiøø.” ");
INSERT INTO mirNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jaduhṉä miämetspä miänaam̱bä: “Mdsógäbä jäyaꞌay hajxy nägøx̱iä nej mijts hamdsooyyä mnic̈hogyiijän. Ni mädyii mädiaꞌagy jaduhṉ quiaꞌa mäbaady neby hädaa mädiaꞌagy metspä tiuuṉgpaadiän” ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mänitä craa miänáaṉgumbä, jaꞌa hänajty tuum̱bä tsajtøgooty: ―Wiindsǿṉ, jaanc̈h tehm̱ yhoy miic̈h mhadsooyy. Tøyhajt jaduhṉ nej miic̈h mmänaꞌañän coo Dios tiuꞌuquiä. Cabä wiingDios jyiijä. Xjiaanc̈h tehm̱ tiuuṉgpáatäm hajxy jaduhṉ ");
INSERT INTO mirNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","coo jaꞌa Dios hajxy hamuumduꞌjoot nwiingudsähgǿøyyämät, møød coo jäyaꞌay hajxy nägøx̱iä ndsójcämät neby hajxy hamdsooyyä nnic̈hójcäm. Pero cab hajxy xjiaty tuuṉgpáatäm coo animal hajxy jiiby nøcxy nnäꞌä hayójxäm tsajtøgooty noꞌcøøc ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Coo jaꞌa Jesús jaduhṉ miädooyy coo jaꞌa craa hänajty najuøøyyhaamby tøø quiapxy, jaꞌa hänajty tuum̱bä tsajtøgooty, mänitä craa ñämaayyä: ―Jaac mäbøc jaꞌa Diosmädiaꞌagy hamuumduꞌjoot, jaduhṉds miic̈h jim̱ mnǿcxät Dioswiinduum ―nøm̱ä Jesús miänaaṉ̃. Mänitä hänaꞌc‑hajxy yhamooṉnä, jaꞌa Jesús hajxy hänajty jia wiꞌi yaghoꞌogaam̱bä. Cabä Jesús hajxy waam̱b miäyajtøønä jeꞌeguiøxpä coo jaꞌa Jesús hajxy hänajty chähgøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jiibiä Jesús hänajty yajnähixøꞌøy tsajtøgooty. Mänit miänaaṉ̃: ―Yøꞌø hänaꞌc‑hajxy jii yajnähixøøbiä tsajtøgooty, tii hajxy jaduhṉ coo miänaꞌañ coogä David jaꞌa Cristo yhaphaty yhoc‑haty. ");
INSERT INTO mirNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Haa caꞌa, jaduhṉ jim myiṉ̃ cujaayä maa jaꞌa Diosmädiaꞌaguiän coo jaꞌa David hamdsooyyä jecy miänaaṉ̃: Mänítøc̈hä Dios jaꞌa nWiindsǿṉ xñämaayyä: “Yaa miṉ häñaꞌaw maac̈hä nhahooyhaampiän, høxtä cóonøc̈hä mmädsip ngaꞌa yajmäjädáacämät.” Jaꞌa Dioshespírituhaamä David jaduhṉ jecy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Jaduhṉä David jecy miänaaṉ̃ coogä Cristo hänajty wyiindsøṉhaty. Hoorä, pø tøyhajt jaduhṉ coo jaꞌa David jaꞌa Cristo jaduhṉ jecy wyiindsøṉhajty, tii yøꞌø jäyaꞌayhajxy coo miänaꞌañ coogä David jaꞌa Cristo ñäꞌä haphaty ñäꞌä hoc‑haty ―nøm̱ä Jesús miänaaṉ̃. Jaanc̈h tehm̱ yhomiädoonä jaꞌa jäyaꞌayhajxy hänajty miädoy nebiä Jesús hänajty yajnähixøꞌøyän. Nämayyä jäyaꞌayhajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mänitä Jesús jiaac mänaaṉ̃: ―Yøꞌø hänaꞌc‑hajxy jii yajnähixøøbiä tsajtøgooty, cab yøꞌø miädiaꞌagy hajxy mmäbǿjcät. Yoṉ̃witmøød hajxy nax̱y wiädity cajptooty jeꞌeguiøxpä coo hajxy wyiꞌi yajcumayaꞌañ. Wiꞌi yajwiingudsähgøꞌøwaam̱b hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jiiby hajxy jia wiꞌi yhäñaꞌawaꞌañ maa jaꞌa häñaabiejt yajxonjatypän, hädaa yaabä tsajtøgootypä, møød jim̱ maa jaꞌa cay huꞌugy nax̱y jiadyiijän. ");
INSERT INTO mirNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pero cabä quiuhdujthajxy ñäꞌägädä hoyyä. Hix̱, pǿjcäxäbä yaamgtoꞌoxiä tiøjc‑hajxy. Hoy hajxy jaduhṉ jia jatcøꞌøy, jejcyjiatiä Dios hajxy jia wiꞌi piaꞌyaꞌaxy. Pero jaanc̈h tehm̱ yhoyhoy hajxy jaduhṉ yajcumädow̱aꞌañii ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mänitä Jesús jim̱ mädøyyä hoy yhøxtaꞌagy maa jaꞌa jäyaꞌay xädøꞌøñ hajxy hänajty nax̱y quiuyoxøꞌøyän. Jaꞌa mäyøøjäyaꞌayhajxy, majiatiä xädøꞌøñ hajxy hänajty piädaꞌagy. Jim̱ä Jesús hänajty miäheeꞌpnaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mänitä yaamgtoꞌoxy tuꞌug miejch. Jaanc̈h tehm̱ yhäyoob hänajty jeꞌe. Mejtsmägoꞌxä häyoobä jeꞌe quiugonøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Mänitä Jesús jaꞌa jiamiøødtøjc ñämaayy: ―Huug hix̱ yøꞌø yaamgtoꞌoxy hajxy. Cøx̱iä yøꞌøduhṉ tøø yecy mäduhṉ̃tiä hijty miøødä, jaꞌa hijty ñägayaam̱biä. Pero yøꞌø mäyøøhänaꞌc‑hajxy, weeṉ̃tiä hajxy jaduhṉ ñäꞌä puhyejcy. ");
INSERT INTO mirNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Coo jaꞌa Jesúshajxy jiiby chajtøjpädsøøm̱y, mänitä jiamiøød tuꞌug miänaaṉ̃: ―Wiindsǿṉ, huug hix̱ yøꞌø tsajtøjc, jaanc̈h tehm̱ yajxóṉ yøꞌøduhṉ miuuc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mänitä Jesús yhadsooyy: ―Hoy huuc tehm̱ yheeb. Hoy yøꞌø tøjc jaduhṉ jia cruundä, cøxaam̱b yøꞌøduhṉ jyidaꞌañ. Hax̱it hatajøꞌøy yøꞌø muuc̈h jiadaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mänitä Jesúshajxy jim̱ ñøcxy maa jaꞌa tuṉ hänajty xiøhatiän Olivos, jim̱ Jerusalén‑woc‑hawiimb. Coo hajxy jim̱ miejch, mänitä Jesús hanidiuhm̱duum hoy yhøxtaꞌagy. Mänitä Pedro jaꞌa Jesús hajxy ñänøcxy, møødä Santiago, møødä Juan, møødä Andrés. Mänitä Jesús hajxy miäyajtøøyy: ");
INSERT INTO mirNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Mänaads yøꞌø tsajtøjc jaduhṉ jyidaꞌañ. Mädyii hijxtáhṉdäts jaduhṉ cähxøꞌøgaam̱b coo hänajty jaduhṉ yhabaadaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mänitä Jesús yhadsooyy: ―Mniyajcopcøꞌøwǿøjäp hajxy. Cab hajxy myajwiinhǿønät. ");
INSERT INTO mirNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mayyä jäyaꞌayhajxy miṉ miäwiinhøønaꞌañ. Jaduhṉ hajxy hänajty miänaꞌanaꞌañ: “Høøc̈h jeꞌe Cristo.” Mayyä jäyaꞌayhajxy hänajty jiaanc̈h tehm̱ miäbøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Coo hajxy mmädoyhádät coo tsip pleetä hänajty xii yaa tøø piädøꞌøgy, cab hajxy jaduhṉ mmänáꞌanät cooc tyijy jaꞌa naax̱wiimbä hänajty wyiimbidaꞌañ. Homiänaajä tsip pleetä jiadyii. ");
INSERT INTO mirNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nimiädsibøꞌøwáaṉäp hajxy hänajty wiinghagajptjaty. Wiinduhm̱yhagajpt hujx hänajty ñaxaꞌañ. Jadáaṉäbä yuuxøø hänajty wiinduhm̱yhagajpt. Coo jaduhṉ jiadaꞌañíi, hijxtahṉd jaduhṉ cähxøꞌtsoonaam̱b coo tsøꞌty häyohn hoc̈hähgøøñäjaty hänajty jiadaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Mniyajcopcøꞌøwǿøjäp hajxy mänit. Mäjahñdiuum hajxy hänajty mhidaꞌañ. Xmiadsaam̱bä mmädsip hajxy hänajty. Mänit hajxy jim̱ xyajnøcxaꞌañ hagujc. Møød jim̱ maa jaꞌa judíos chajtøjc‑hajxiän, xwiobhoꞌogaam̱b hajxy hänajty jim̱. Xyajnøcxaam̱b hajxy hänajty jim̱ maa jaꞌa gobiernä wyiinduumhajxiän, jeꞌeguiøxpä cooc̈h mijts xpiawädity. Jím̱høch hajxy jaduhṉ xmiädiáꞌagät gobiernäwiinduum. ");
INSERT INTO mirNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Hix̱, cahnä naax̱wiimbä hänajty wyiimbityñä, cøxaam̱bä jäyaꞌay jaꞌa Diosmädiaꞌagy hajxy miädow̱aꞌañ wiinduhm̱yhagajpt. ");
INSERT INTO mirNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Y coo hajxy jim̱ xyajnǿcxät hagujc, cab hajxy mänit mnädaj mnämáyät waam̱baty hajxy mhadsówät. Hix̱, jaꞌa Dios jaꞌa mädiaꞌagy hajxy hänajty xmioꞌowaam̱b. Cab hajxy hänajty hamdsoo mmädiaꞌagaꞌañ; jaꞌa Dioshespíritu hajxy hänajty xyajmädiaꞌagaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Hamiṉ̃ haxøpiä jäyaꞌayhajxy hänajty tuꞌqueꞌex ñiñähdugaꞌañii coo hajxy yaghoꞌogǿøjät. Jaanä jaduhṉä yhuung hajxy hänajty ñähdugaam̱bä. Jaꞌa muutsc‑hänaꞌc‑hajxy, jaanä jaduhṉä tieedy hajxy hänajty tiunaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nägøx̱iä mijtsä jäyaꞌay xmiähaṉhadaꞌañ jeꞌeguiøxpä cooc̈h mijts xpiawädity. Pero pøṉ hänajty tøø mieeꞌxtucy, hoy hänajty tøø jia hoꞌogy, nähwaꞌadsaam̱b hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Habaadaam̱b jaduhṉ coo jaꞌa haxøøgpä caꞌa hoybä miedsaꞌañ maa jaꞌa Diostøjcän ―pøṉ hädaa nocy capxp, ween jaduhṉ wyiinjuøꞌøy―. Mänitä Diostøjc jaduhṉ yajmaꞌadaꞌañii. Coo jaꞌa haxøøgpä hajxy jaduhṉ mhíxät, mänit hajxy päyøꞌøguiä mnǿcxät tunjoot, pønjaty yaa tsänaaby Judeanaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pønjaty hänajty häñaaby tøjnähgøxp, ween ñäꞌägä päyøꞌøgy, cap nøcxy tii jiiby yajpädsøm̱y tøgooty. ");
INSERT INTO mirNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Pønjaty hänajty camjooty, cab jaduhṉ jim̱ ñǿcxät maa jaꞌa tiøjcän. Cap nøcxy jiiby tii yajpädsøm̱y, ni wyit ni tii. ");
INSERT INTO mirNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jaanc̈h tehm̱ chaac̈hpøgaam̱bä toꞌoxiøjc‑hajxy hänajty, jaꞌa hajxy hänajty coꞌnaꞌawaam̱bä, møød jaꞌa hajxy hänajty huungyajtsiꞌtspä. ");
INSERT INTO mirNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mmänuuꞌxtáꞌagäbä Dios hajxy coo tsøꞌty häyohn ween quiaꞌa jadyii coo hänajty jiaanc̈h tehm̱ tiøøchcä. ");
INSERT INTO mirNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Jaanc̈h tehm̱ yhoyhoyyä jäyaꞌayhajxy hänajty chaac̈hpøgaꞌañ. Ni mädyii tsaac̈hpä jaduhṉ quiaꞌa mäbaadaꞌañ neby hänajty jiadaꞌañiijän, ni jaꞌa jecy nájxäbä, ni jaꞌa jaac minaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tøø jaꞌa Dios jaduhṉ miänaꞌañ coo jaꞌa jäyaꞌayhajxy hänajty jejcy quiaꞌa tsaac̈hpøgaꞌañ, jeꞌeguiøxpä coo chocy pønjaty jaduhṉ tøø wyiimbiy. Coo jaꞌa Dios häxøpy jaduhṉ tøø quiaꞌa mänaꞌañ, jejquiä jäyaꞌayhajxy häxøpy chaac̈hpøgaꞌañ. Ni pøṉ häxøpy quiaꞌa nähwaꞌadsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Coo mijts pøṉ xñämáꞌawät coog tyijy jaꞌa Cristo hänajty jii wiädity, cab hajxy mmäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Hix̱, mayyä jäyaꞌayhajxy hänajty wiäditaꞌañ mäwiinhøhm̱bä, cooc tyijy hajxy hänajty jeꞌe Cristo, møød cooc tyijy hajxy hänajty Dyiosquex̱iä. Piayajcähxøꞌøgaam̱biä hijxtahṉd hajxy hänajty hoy‑yagjuǿøñäbä. Jaduhṉä jäyaꞌayhajxy hänajty jia wiꞌi wyiinhøønaꞌañii, møød jaꞌa hajxy hänajty Dioswiimbíyyäbä. ");
INSERT INTO mirNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mniyajcopcøꞌøwǿøjäp hajxy. Jäguem̱iä hajxy cham̱ nnämaꞌay coo hajxy mniyajcopcøꞌøwǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Mänitxøøbä, coo jaꞌa tsaac̈hpä hänajty tøø ñajxnä, mänitä xøø wyiingoodøꞌøwahñ møødä poꞌo. ");
INSERT INTO mirNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mänitä mamiadsaꞌa hänajty quiaꞌawaꞌañ. Tsäyuyyaam̱b hänajty jaduhṉ, tijaty jim̱ cuhdujtmøød tsajtcøxp. ");
INSERT INTO mirNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mänítøch hänajty ngädaꞌagaꞌañ jocjooty, høøc̈h jaꞌa Diosquex̱ypä. Møcmäjaamǿødhøch hänajty ngädaꞌagaꞌañ. Yajxóṉhøch hänajty mänit ngädaꞌagaꞌañ. Mänítøc̈hä jäyaꞌayhajxy hänajty may xpiaꞌheeꞌptägøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mänítøc̈hä nmoonsä tsajpootypähajxy hänajty nguexaꞌañ coo hajxy jaduhṉ quiøx̱y yajtuꞌugmúgät pønjátyhøch hänajty tøø nwiimbiy. Wiinduhm̱yhagajpt hajxy hänajty wioomugaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Høxtahm̱dsä higueraquepy, coo jaduhṉ wiámät, hijxtahṉd jaduhṉ coo hänajty tøø pioodtägøøñä. ");
INSERT INTO mirNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jaanä jaduhṉduhm̱bä, coo jaꞌa tsøꞌty hajxy jaduhṉ mhíxät nébiøch naam̱nä tøø nmädiaꞌagy, hijxtahṉd hänajty jaduhṉ cooc̈h hänajty mobädajpä ngädaactägatsaꞌañ hädaa yaabä naax̱wiin, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cøxaam̱b jaduhṉ jiadaꞌañii nébiøch naam̱nä tøø nmädiaꞌagy, cahnä jäyaꞌayhajxy hänajty quiøx̱y hoꞌogyñä, jaꞌa hajxy jädaꞌahaty jugyhajpä. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cuhdägoyyaam̱bä tsajt møødä naax̱wiimbä. Pero tsipcøxp jaduhṉ tiøjiadaꞌañ nébiøch cham̱ nmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ni pøṉ jaduhṉ quiaꞌa najuøꞌøy mänaa jaduhṉ jiadaꞌañii. Jagooyyä Dios nidiuhm̱ ñajuøꞌøy, jaꞌa hajxy nDeedyhájtäm. Ni jaꞌa Diosmoonsähajxy jaduhṉ quiaꞌa najuøꞌøy, jaꞌa hajxy jim̱ tsajpootypä. Ni høøc̈h ngaꞌa najuøꞌøy, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Paady, nähix̱ hahixøꞌø hajxy mhídät homiänaajä, jeꞌeguiøxpä coo hajxy mgaꞌa najuøꞌøy mänaa jaduhṉ jiadaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jii jäyaꞌay hänajty tuꞌug, coo hänajty ñøcxaꞌañ jäguem̱naax̱, mänitä mioonsä ñämaayy coo jaꞌa tiøjc cwieendähájtäxät. Nägøx̱iä hajxy jaduhṉ yhaagä näꞌä tuuṉgmooyyä. Jaduhṉä tuꞌjäyaꞌay ñämáayyäbä coo jim̱ tiúnät maa jaꞌa tøghaawän, weenä tøjc yaghawaꞌac̈h jopy; tsuu jadähooc yhagǿøguiumbät. ");
INSERT INTO mirNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Jaꞌa cudøjcä mioonsähajxy, cab hajxy hänajty ñajuøꞌøy mänaa jaꞌa wyiindsøṉhajxy hänajty miejtstägatsaꞌañ, pø coodsǿøñäp hänajty jaduhṉ, o pø tsuhm̱dä hänajty, o pø tuꞌtseey‑yaaxøꞌøgy hänajty, o pø jobǿøñäp hänajty. Nähix̱ hahixøꞌø jaꞌa wyiindsǿṉ hajxy jaduhṉ yhahíxät. Pø caj, coo hajxy jaduhṉ jaguiapxiä ñähmejtspedǿøjät, wehṉdä hajxy hänajty miaꞌay. Jaduhṉ mäwíinäts mijtspä, cab hajxy jaduhṉ mnajuøꞌøy mänáajøch yaa ngädaactägatsaꞌañ hädaa yaabä naax̱wiin. Paady hajxy nähix̱ hahixøꞌø homiänaajä mnäꞌägä hídät. ");
INSERT INTO mirNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jadúhṉhøc̈hä jäyaꞌayhajxy nägøx̱iä nnämaabiä coo hajxy nähix̱ hahixøꞌø ñäꞌägä hídät homiänaajä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mejtsxøø jaꞌa pascuaxøø hänajty quiaꞌa habaady mänaa jaꞌa judíos tsajcaagy hajxy hänajty quiayyän, jaꞌa cajpä tsoomiøødpä. Jaꞌa teedywiindsøṉhajxy, møødä hänaꞌc‑hajxy, jaꞌa hajxy hänajty jiiby yajnähixøøbiä tsajtøgooty, cojyquiapxytiuum̱b hajxy hänajty jaduhṉ nebiä Jesús hajxy yajtsumǿøjät høhṉdaꞌagymiädiaꞌagyhaam, jaduhṉ hajxy jaduhṉ hoy yajyaghoꞌogǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mänit hajxy näjeꞌe ñiñämaayyä: ―Cab hajxy tsøc nej jatcǿøyyäm coo jaꞌa cuꞌug hajxy jaduhṉ xñäꞌä nähbädǿꞌcämät. ");
INSERT INTO mirNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tøø jaꞌa Jesús hänajty yhädaꞌagy Betania. Jim̱ hänajty miädsuugay maa jaꞌa Simón tiøjcän, jaꞌa hijty leprapaꞌammøødpä. Mänitä toꞌoxiøjc tuꞌug miejch. Jim̱ä nardoperfume hänajty quiøꞌøgoṉhaty alabastro‑vidriojooty. Jaanc̈h tehm̱ chow̱ä nardoperfume hänajty ñøcxy. Mänitä toꞌoxiøjcä perfume‑vidrio piuhy. Mänitä Jesús jaꞌa perfume yajcuhtemøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mänitä jäyaꞌayhajxy näjeꞌe jiootmaꞌty, jaꞌa hajxy hänajty jim̱ pahäñaabiä. Mänit hajxy ñiñämaayyä: ―Cap yøꞌø perfume jaduhṉ cu yaghäyooyy. ");
INSERT INTO mirNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Coo jaduhṉ cu ñäꞌägä tooꞌcy, tsoobaadaam̱b yøꞌø hijty, tägøøgmägoꞌx‑xøøguduṉ̃. Jim̱ä häyoobädøjcä chow̱ hajxy jaduhṉ cu miooyyä coo jaduhṉ cu ñäꞌägä tooꞌcy. Jaduhṉä toꞌoxiøjc yhojjä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mänitä Jesús miänaaṉ̃: ―Weends yhity. Caꞌa hajxy mwiꞌi yhojy. Nébiøch yøꞌø jaduhṉ tøø xtiuṉ̃än, cab jaduhṉ ñejpiä; hoy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Homiänaajä mijtsä häyoobäjäyaꞌay mhix̱y. Homiänaajä hajxy jaduhṉ mbuhbédät. Pero høøc̈h, cábøch mijts jejcy xyhixaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Xwyiingudsähgǿøbiøch yøꞌøyaꞌay jaduhṉ, páadyhøc̈hä perfume jaduhṉ xyajcuhtemøøyy. Jaduhṉ miäbaady nej cooc̈h häxøpy tøø nhoꞌoguiän. Jadúhṉhøch yøꞌø hijty xyajnähdemaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Majatiä Diosmädiaꞌagy wiäditaꞌañ wiinduhm̱yhagajpt jaꞌa høøc̈hcøxpä, jaduhṉä jäyaꞌayhajxy miädiaꞌagaꞌañ nébiøch yøꞌøyaꞌay naam̱nä tøø xtiuṉ̃. Jaduhṉ yøꞌø homiänaajä jiahmiedsáaṉänä. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jim̱ä Jesús jaꞌa jiamiøød hänajty tuꞌug xiøhaty Judas Iscariote, jaꞌa hajxy hänajty nämajmetspä. Mänitä Judas jaꞌa teedywiindsǿṉ hoy miøødcojyquiapxytiuṉ̃ coo jaꞌa Judas jaꞌa Jesús hänajty tioogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Coo jaꞌa teedywiindsøṉhajxy jaduhṉ miädooyy, mänit hajxy jaduhṉ jiaanc̈h tehm̱ xiooṉdaacpøjcy. Mänitä Judas yajwiinwaaṉøøyyä coo xädøꞌøñ hänajty mioꞌowaꞌañii. Mänitä Judas tiägøøyy wiinmaabiä nebiä Jesús paquiä yajcøꞌødägǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mänitä pascuaxøø yhabaatnä. Jaduhṉä judíoshajxy hänajty quiuhdujthaty coo tsajcaagy hajxy nax̱y quiay, jaꞌa cajpä tsoomiǿødäbä. Jaduhṉ hajxy hänajty quiuhdujthajpä coo meeghuung hajxy nax̱y yox̱y jaꞌa pascuaxøøjooty. Mänitä Jesús jaꞌa jiamiøød miäyajtøøw̱ä: ―Maadaꞌa yhoyyä coo pascuaxøø hajxy häyaa nwiindsuugáayyämät. ");
INSERT INTO mirNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mänitä Jesús jaꞌa jiamiøød nämetsc ñämaayy: ―Nøcx hajxy jim̱ Jerusalén. Jim̱ä jäyaꞌay hajxy tuꞌug mbaadaꞌañ nøøgóṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jeꞌeds hajxy mbaduꞌubǿgäp. Mänit hajxy mbadøjtägǿꞌøwät. Mänitä cudøjc hajxy mnämáꞌawät: “Jaꞌa nWiindsǿṉ højts jaduhṉ tøø xwyiinguex̱y coo højts nyajtǿwät maa højtsä pascuaxøø häyaa tsuu nwiindsuugáyät.” ");
INSERT INTO mirNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mänit mijtsä cudøjc cuarto nøcxy xyajnähixøꞌøwaꞌañ nähbettøjcøxp. Jaanc̈h tehm̱ quiäruundä jaꞌa cuarto jaduhṉ møød yajxoṉä. Jim̱ä cay huꞌugy hajxy mnähix̱ mhahixǿꞌøwät coo hajxy jim̱ ndsuugayáaṉäm ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mänit hajxy nämetsc jiaanc̈h nøcxy jim̱ cajptooty. Jiaanc̈h paat hajxy jaduhṉ neby hajxy hänajty tøø ñämaꞌayiijän. Mänitä tsuugay hajxy tiägøøyy nähix̱ hahixøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Coo quioodsøøñä, mänitä Jesúshajxy jim̱ ñøcxy maa jaꞌa pascuaxøø hajxy hänajty wyiindsuugayaꞌañän, møødä jiamøødhajxy jaꞌa jaac nämajcpä. Mänit hajxy tiägøøyy caabiä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mänitä Jesús miänaaṉ̃: ―Túꞌughøch mijts mjamiøød xñäxøꞌøwøꞌøwaꞌañ. Quipxy hajxy jeꞌe cham̱ xmiøødcaamiújcäm. Tøyhajt jaduhṉ ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mänit hajxy nägøx̱iä jiootmadiägøøyy. Mänit hajxy tiägøøyy niñämáayyäbä: ―Nej, høøc̈h jeꞌedaꞌa tyijy xñänøøm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mänitä Jesús yhadsooyy: ―Mijts mjamiøød jaduhṉ tuꞌug jatcøꞌøwaam̱b, näguipxiä tsajcaagy hajxy jaduhṉ jiiby xmiøødpaguhmáꞌtsäm texyjooty. ");
INSERT INTO mirNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Høøc̈h, jaꞌa Diosquex̱ypä, jadúhṉhøch njadaꞌañ nhabetaꞌañ nepy jim̱ myiṉ̃än cujaay maa jaꞌa Diosmädiaꞌaguiän. Tøjiadaam̱bä Diosmädiaꞌagy jaduhṉ. Pero jaꞌa cráajøch jaduhṉ xñähdugaam̱bä, jaanc̈h tehm̱ yhoyhoy jaduhṉ chaac̈hpøgaꞌañ. Maas hoy häxøpy coo quiaꞌa näꞌägä naax̱wiimbädsøøm̱y ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Caabyñä jaꞌa Jesúshajxy hänajty, mänitä Jesús jaꞌa tsajcaagy quionøꞌcy. Mänitä Dios ñämaayy: “Dioscujúꞌuyäp.” Mänitä jiamiøødä tsajcaagy nägøx̱iä yajnäguidøøyy. Mänit miänaaṉ̃: ―Cay hädaa hajxy; høøc̈h nniꞌx ngopc hädaa ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mänitä Jesús jaꞌa vaso quionøꞌcy, jaꞌa hänajty vinomøødpä. Mänitä Dios ñämáaguiumbä: “Dioscujúꞌuyäp.” Mänitä Jesús jaꞌa vino yhuuctsohṉ̃. Mänitä jiamiøød miooyy. Nägøx̱iä hajxy jaduhṉ yhuucy. ");
INSERT INTO mirNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mänitä Jesús miänáaṉgumbä: ―Høøc̈h nnøꞌty hädaa. Hijxtahṉd hädaa jaduhṉ cooc̈hä nnøꞌty nyajxeeꞌxaꞌañ cooc̈hä jäyaꞌayhajxy hänajty nnähhoꞌtuꞌudaꞌañ. Jadúhṉhøc̈hä cuhdujt nyajtødiägøꞌøwaꞌañ, jaꞌa Dios jaꞌa Abraham jecy miøødyajcuhdújcäbä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tøyhájthøch jaduhṉ nnämáꞌawät, cábøc̈hä vino nhuuctägatsaꞌañ høxtä cóonøch hänajty jim̱ tøø nnøcxtägach maac̈hä nDeediä wyiinduumän. Mänítøc̈hä vino jem̱ybiä nhuucmadsaꞌañ ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mänitä Jesús jaꞌa Dioshøy hajxy yhøøyy, møødä jiamiøødtøjc. Mänit hajxy jim̱ chohṉ̃. Mänit hajxy jim̱ ñøcxy maa jaꞌa tuṉ hänajty xiøhatiän Olivos. ");
INSERT INTO mirNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mänitä Jesús jaꞌa jiamiøødtøjc ñämaayy: ―Nägǿx̱iøc̈h mijts xñähgueꞌegaꞌañ, jeꞌeguiøxpä cooc̈h nmädiaꞌagy hajxy xquiaꞌa mäbøgaaṉä. Jaduhṉ jim̱ myiṉ̃ cujaay maa jaꞌa Diosmädiaꞌaguiän: “Nyaghoꞌogáam̱biøc̈hä meegcueendähajpä. Cøxaam̱bä meeghajxy piäyøꞌøgaꞌañ. Xii yaa hajxy ñøcxøꞌøwaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Cooc̈h hänajty tøø nhoꞌogy, mänítøch jadähooc njujypiøjtägatsaꞌañ. Mänítøch jim̱ nnøcxaꞌañ Galilea. Mänítøch mijts jim̱ nøcxy xpiaadaꞌañ ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mänitä Pedro jaꞌa Jesús ñämaayy: ―Høøc̈h mäbøcypiä, cábøch miic̈h mänaa nbuhwaꞌadsaꞌañ, hoy miic̈h hajxy nägøx̱iä xjia puhwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mänitä Jesús yhadsooyy: ―Tøyhájthøch miic̈h nnämáꞌawät, häyaa coods miic̈h tägøøghooc mniguiugapxaꞌañii cooc̈h tyijy xquiaꞌa hix̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero Pedro, tehṉgajnä jeꞌe jiaac miänaaṉ̃: ―Cábøch mänaa nniguiugapxaꞌañii cooc̈h tyijy miic̈h ngaꞌa hix̱iä, hóyhøch miic̈h quipxy nja møødhóꞌogät ―nøm̱ä Pedro miänaaṉ̃. Jaduhṉ hajxy nägøx̱iä piahadsoobä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mänitä Jesúshajxy jim̱ ñøcxy maa hänajty xiøhatiän Getsemaní. Mänitä Jesús jaꞌa jiamiøødtøjc ñämaayy: ―Jiids hajxy huuc häñaꞌaw, nøcxy nhuuc Diospaꞌyaꞌaxy. ");
INSERT INTO mirNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mänitä Jesús jaꞌa Pedro hawiing miøødnøcxy, møødä Santiago, møødä Juan. Mänitä Jesús hoyhoy jiaanc̈h tehm̱ jiootmabiøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mänitä Pedrohajxy ñämaayyä: ―Hoyhóyhøch jaduhṉ njaanc̈h tehm̱ jiootmayhaty. Høxtä hoꞌogáam̱bøch nnijiäwøꞌøyii. Huuc mähmøꞌøw hajxy yaa. Cab hajxy mmaahóꞌogät. Jujcy hajxy mhídät ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Mänitä Jesús weeṉ̃tiä jiaac nøcxy. Mänit jaduhṉ miägutscädaacy. Mänitä Dios tiägøøyy mänuuꞌxtaacpä: “Teedy, meeꞌx, coo miic̈h jaduhṉ cu mgaꞌa mänaaṉ̃, cábøch häxøpy ndsaac̈hpøgaꞌañ nébiøch cham̱ nmänaxaꞌañän. Pero cábøc̈hä nguhdujt yhídät nébiøc̈hä njoot jia tsoquiän. Miic̈hä mguhdujt jaduhṉ näꞌägädä hidaam̱b.” ");
INSERT INTO mirNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mänitä Jesús jim̱ ñøcxtägajch maa jaꞌa Pedrohajxy hänajty tøø miähmøꞌøyän. Coo jim̱ miejch, mänit jaduhṉ yhijxy coo hajxy hänajty tøø quiøx̱y maahoꞌogy. Mänitä Pedro ñämaayyä: ―Simón, nej, mmaabä. Niduꞌhora miic̈h tøø mgaꞌa meeꞌxtucy. ");
INSERT INTO mirNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jujcy hajxy hit. Tehṉgajnä jaꞌa Dios hajxy mbaꞌyáꞌaxät. Jaduhṉä møjcuꞌugong hajxy xquiaꞌa jøjcapxǿꞌøwät. Jia tsojpiä mjoothajxy jaduhṉ coo hajxy jujcy mhídät, pero cabä mniꞌx jaꞌa mgopc‑hajxy jaduhṉ mieeꞌxtugaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mänitä Jesús jaꞌa Dios hoy piaꞌyáax̱cumbä. Jaduhṉ jadähooc ñämänaanǿøguiumbä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mänit jadähooc miéjtscumbä maa jaꞌa Pedrohajxy hänajty tøø miähmøꞌøyän. Tøø hajxy hänajty miaahóꞌcumbä. Hix̱, tøø hajxy hänajty jiaanc̈h tehm̱ yhanuuꞌxøꞌøy. Coo hajxy jaduhṉ yujxä, cab hajxy hänajty ñäꞌägä najuøꞌøy waam̱b hajxy yhadsówät. ");
INSERT INTO mirNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Coo jaꞌa Jesús jaduhṉ miejch jaꞌa miädägøøghoocpä, mänit miänaaṉnä: ―Nej, jeꞌenä hajxy mwiꞌi miaꞌayñä. Ween tiuhṉä. Tøø yhabaatnä cooc̈hä cahwiindøyhänaꞌc‑hajxy xquiøꞌødägøꞌøwaaṉnä, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pädǿꞌnäts hajxy. Jam̱ hajxy. Xim̱ä craa myiṉ̃ jaꞌac̈h jaduhṉ xyajcøꞌødägøꞌøwaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jim̱ä Jesús hänajty miädiaꞌagyñä, mänitä Judashajxy miejch, møødä majiäyaꞌay, haagä espada‑cap. Näjeꞌe hajxy hänajty wiojptcappä. Jaꞌa teedywiindsøṉhajxy jaduhṉ mäguejx, møødä hänaꞌc‑hajxy jiiby yajnähixøøbiä tsajtøgooty, møødä majjäyaꞌadiøjc‑hajxy. ");
INSERT INTO mirNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tøø jaꞌa Judashajxy hänajty quiojyquiapxytiuṉ̃: “Jaꞌac̈h hänajty ndsuꞌxaam̱biä, jeꞌe hänajty jeꞌe. Mänit hajxy mmádsät. Mänit hajxy nøcxy mdsum̱y”, nøm̱ä Judas hänajty tøø miänaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mänitä Judas jaꞌa Jesús ñämejch. Mänit ñämaayy: ―¡Wiindsǿṉ! Mänitä Judas jaꞌa Jesús jiaanc̈h tsuꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mänitä Jesús miajtsä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jaꞌa Jesús jaꞌa jiamiøød tuꞌug, jim̱ä espada hänajty miøjnädaw̱haty. Coo jaduhṉ yhijxy coo jaꞌa Jesús hänajty tøø miac̈hii, mänitä yhespada jiuuꞌpädsøøm̱y. Mänitä teedywiindsøṉä mioonsä tuꞌug tiaatspujxtuutä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mänitä Jesús jaꞌa majiäyaꞌay ñämaayy: ―Tiic̈h hajxy jaduhṉ coo tøø xñämiṉ̃ espada‑cap wojptcap. Tiic̈h hajxy xyhix̱y, méeꞌtspäjä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tiic̈h hajxy jim̱ coo xquiaꞌa majtspä tsajtøgooty. Nébyhøch hajxy jaduhṉ høxtä yaa tøø xñämiṉ̃. Nej, caꞌa, jabom̱‑jabóm̱høch hijty jim̱ nøcxy nyajnähixøꞌøyä. Pero páadyhøch cham̱ njaty nhabety, jaduhṉä Diosmädiaꞌagy tiøjiádät jaꞌa høøc̈hcøxpä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nidiuhm̱ä Jesús hänajty jiaac mädiaꞌagy. Tøø jaꞌa jiamiøødhajxy hänajty quiøx̱y päyøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jim̱ä høxcujc‑hänaꞌc jaꞌa Jesús hänajty tuꞌug piawädijpä, poobwit‑nähcäjeeṉä. Mänit jaduhṉ jia madsaaṉä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Mänitä poobwit yajniñähnajptuutä. Nähwaꞌads høxwaꞌads jeꞌe piäyøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mänitä Jesús yajnøcxä maa jaꞌa teedywiindsǿṉ wyiinduumän, jaꞌa jaac tehm̱ miøjpä. Mänitä teedywiindsøṉhajxy jiaac tehm̱ miejch, møødä majjäyaꞌadiøjc‑hajxy, møødä hänaꞌc‑hajxy jiiby yajnähixøøbiä maa jaꞌa tsajtøjcän. ");
INSERT INTO mirNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jim̱ä Pedro hänajty jäguem̱juøøby piadänaꞌay maa jaꞌa teedywiindsǿṉ tiøjwiingøn. Mänit jim̱ piahøxtaacy maa jaꞌa hadänaabiähajxy hänajty jiøømbaꞌaxam̱iän. ");
INSERT INTO mirNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jim̱ä teedywiindsøṉhajxy hänajty jia wiꞌi wyiinmahñdyhaty nebiä Jesús hajxy yajyaghoꞌogǿøjät. Pero cab hajxy hänajty ñäꞌägä wiinmahmybiaady. ");
INSERT INTO mirNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hix̱, hoyyä Jesús hajxy hänajty nämay jia nähøønøꞌøy, wiingaty hajxy hänajty miädiaꞌagy; cab hajxy hänajty tiuꞌugmädiaꞌaguiä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Mänitä wiinghänaꞌc‑hajxy tiänaayyøꞌcy; nøm̱ hajxy jeꞌe miänaam̱bä: ―Tøø højts jaduhṉ nmädoy coo jaduhṉ miänaaṉ̃: “Hädaa tsajtøjc, jäyaꞌayhajxy hädaa hädiuuṉ. Pero høøc̈h, nyajnajtsjidǿꞌøwäbøch hädaa. Cudägøøgxǿøyyøc̈hä wiingpä nhädiuuṉdägátsät. Caꞌa jiäyaꞌayhajxy jeꞌe hädiúnäp” ―jaduhṉ hajxy jeꞌe yhøhṉdaacpä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ni jeꞌe hajxy hänajty quiaꞌa tuꞌugmädiáꞌaguiäbä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mänitä teedywiindsǿṉ tiänaayyøꞌcy majiäyaꞌayhagujc, jaꞌa tehm̱ miøjpä. Mänitä Jesús ñämaayyä: ―Nej, cab jaduhṉ mnäꞌä hadsowaꞌañä waam̱baty hajxy miänaꞌañä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero cabä Jesús waam̱b ñäꞌägä hadsooyy. Mänit ñämáayyägumbä: ―Nej, tøyhajt jaduhṉä coo miic̈hä Dios tøø xquiex̱iä, Nej, miic̈hä Dios xyHuunghajpä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mänitä Jesús yhadsooyy: ―Tøyhajt jaduhṉ. Høøc̈h jeꞌe. Xyhixáam̱bøch mijts jaduhṉ cooc̈h jim̱ nhäñaꞌawaꞌañ Dioswiinduum, maa jaꞌa yhahooyhaampiän. Mänítøch hajxy jadähooc xyhixáaṉgumbä cooc̈h hänajty yaa ngädaactägatsaꞌañ hädaa yaabä naax̱wiin. Jocjóotyhøch hänajty nmänacaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mänitä teedywiindsǿṉ jaꞌa wyit quiøøꞌch. Paady jaduhṉ jiatcøøyy coo hänajty jiaanc̈h tehm̱ jiootmaꞌady. Mänit miänaaṉ̃: ―Tii testigo hajxy jaduhṉ nnäꞌä jaac wáaṉämät. ");
INSERT INTO mirNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tøø hajxy jaduhṉ mhamdsoo mädoy coo jaꞌa Dios tøø miägapxtägoy. Waam̱b hajxy jaduhṉ mmänaꞌañ, neby hajxy ndúuṉämät. Haagä jaduhṉ hajxy miänaaṉ̃ cooc tyijy jaꞌa Jesús tøø quiädieey, møød cooc ween yaghoꞌogyii. ");
INSERT INTO mirNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mänitä Jesús tiägøøyyä wiingutsujǿøyyäbä. Mänit wyiingux̱odsøøyyä. Mänit wyiingutexøøyyä. Mänit ñämaayyä: ―Najuøꞌøw pøṉ xquiojx. Mänitä hadänaabiädøjc jaꞌa Jesús hajxy wyiinguḻaꞌabøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Y jaꞌa Pedro, jiiby hänajty jeꞌe hanaax̱yp jiøømbaꞌaxam̱y maa jaꞌa tøjwiingän. Mänitä teedywiindsøṉä qyix̱ymoonsä tuꞌug miejch maa jaꞌa Pedro hänajtiän. Coo jaꞌa Pedro jaduhṉ yhijxä, mänit wyiinheeꞌppejtä. Mänit ñämaayyä: ―Nax̱y miic̈h yøꞌø Jesús mmøødwädity, túhm̱äts. Haagä Nazaret hajxy mdsooñ nämetsc, túhm̱äts. ");
INSERT INTO mirNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mänitä Pedro ñijiøgapxä: ―Ni ngaꞌa híx̱iøch yøꞌø. Ni ngaꞌa najuǿꞌøyhøch jaduhṉ tiic̈h jaduhṉ xjia wiꞌi yajmøødmädiaacp ―nøm̱ä Pedro yhøhṉdaacy. Mänitä Pedro quiuraabädsøøm̱y. Mänitiä tseey tuꞌug jiaanc̈h yaaxøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mänitä quix̱ymoonsä jaꞌa Pedro yhíjxcumbä. Mänitä jäyaꞌayhajxy ñämaayyä, jaꞌa hajxy hänajty jim̱ jaac padänaabiä: ―Xii Jesús jiamiøød tuꞌug. Jeꞌe yøꞌø ―nøm̱ä quix̱ymoonsä miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mänitä Pedro jadähooc ñiguiugápxägumbä. Cab jaduhṉ ñäꞌä jegøøyy, mänitä Pedro ñämáayyägumbä: ―Mbawädijpy miic̈hä Jesúspä, túhm̱äts. Nyoꞌmädooby højts jaduhṉ coo miic̈h jim̱ mdsooñ Galilea. ");
INSERT INTO mirNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mänitä Pedro jadähooc miänáaṉgumbä: ―Tøyhajt, cábøch jaduhṉ nnäꞌägä hix̱iä pøṉ hajxy jaduhṉ mja mädiaacypy. Tähooccapx̱iä jaꞌa Pedro jaduhṉ miänaaṉ̃ cooc tyijy jaꞌa Jesús hänajty quiaꞌa näꞌägädä hix̱iä. ");
INSERT INTO mirNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mänitiä tseey miämetsc‑hoocpä yáax̱cumbä. Mänitä Pedro jiahmiejtstaacy coo jaꞌa Jesús hänajty tøø miänaꞌañ: “Cahnä tseey hänajty miämetsc‑hoocpä yaꞌaxy, tøø miic̈h hänajty tägøøghooc mniguiugapxyii cooc̈h miic̈h hänajty xquiaꞌa hix̱iä.” Mänitä Pedro jiøøguiooꞌty coo jaꞌa tseey miämetsc‑hoocpä jiaanc̈h yaax̱y. ");
INSERT INTO mirNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Coo jiobøøyy, mänitä teedywiindsøṉhajxy nägøx̱iä yhamugǿøguiumbä, møødä majjäyaꞌadiøjc‑hajxy, møødä hänaꞌc‑hajxy jiiby yajnähixøøbiä tsajtøgooty. Mänit hajxy quiojyquiapxytiuuṉ̃ nebiä Jesús hajxy hänajty tiunaꞌañ. Mänitä Jesús hajxy quiøꞌøxojch. Mänitä Pilato hajxy hoy yajcøꞌødägøꞌøy maa jeꞌe hänajty guiobiernähatiän. ");
INSERT INTO mirNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mänitä Pilato jaꞌa Jesús miäyajtøøyy: ―Nej, tøyhajt jaduhṉä coo miic̈hä judíoshajxy xguiobiernähatiä. Mänitä Jesús yhadsooyy: ―Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Madiuꞌu jaꞌa teedywiindsǿṉ jaꞌa Jesús hajxy hänajty jia wiꞌi ñäxøꞌøwøꞌøy. Pero cabä Jesús hänajty waam̱b ñäꞌägä hadsooyy. ");
INSERT INTO mirNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mänitä Pilato miänáaṉgumbä: ―Nej, caj mhadsowaꞌañä. Madiuꞌu miic̈h hajxy xjia wiꞌi ñäxøꞌøwøꞌøy ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero cabä Jesús waam̱b ñäꞌägädä hadsooyy. Jiaanc̈h tehm̱ yagjuøøyy jaꞌa Pilato jaduhṉ coo jaꞌa Jesús jaduhṉ quiaꞌa näꞌägädä hadsooyy. ");
INSERT INTO mirNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jaduhṉä Pilato hänajty jomøjt‑jomøjt quiuhdujthaty coo xøø hänajty jiadyii, mänitä tsum̱yjiäyaꞌay nax̱y tuꞌug yajpädsøm̱y, jaꞌa judíoshajxy hänajty yajnähdijpiä. ");
INSERT INTO mirNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jiibiä jäyaꞌayhajxy hänajty näjeꞌe chum̱yc̈hänaꞌay. Tsip hajxy hänajty tøø yagjadyii. Tøø hajxy hänajty miäjäyaꞌay‑yaghoꞌogy. Tuꞌugä tsum̱yjiäyaꞌay hänajty xiøhaty Barrabás. ");
INSERT INTO mirNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Coo jaꞌa cuꞌughajxy jim̱ miejch maa jaꞌa Pilato wyiinduumän, mänitä Pilato hajxy jaduhṉ ñämaayy coo jaꞌa tsum̱yjiäyaꞌay tuꞌug yhøxmádsät. ");
INSERT INTO mirNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mänitä Pilato yhadsooyy: ―Nej, jaduhṉ hajxy mmänaꞌañä cooc̈hä Jesús nhøxmádsädä, jaꞌa tyijy hajxy mgobiernähajpiä. ");
INSERT INTO mirNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paadiä Pilato jaduhṉ miänaaṉ̃, ñajuøøby hänajty jeꞌeduhṉ tiiguiøxpä jaꞌa Jesús coo yajcøꞌødägøøyyä jaꞌa teedywiindsǿṉ. Paadiä Jesús jaduhṉ yajcøꞌødägøøyyä jeꞌeguiøxpä coo jaꞌa miädiaꞌagy hänajty quiaꞌa yajmädsójcäxä. ");
INSERT INTO mirNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mänitä teedywiindsǿṉ jaꞌa cuꞌug hajxy jiøjcapxøøyy coo jaꞌa cuꞌughajxy jaduhṉ miänáꞌanät coo jaꞌa Jesús ween quiaꞌa høxmac̈hii, weenä Barrabás ñäꞌägä høxmac̈hii. Coo jaꞌa cuꞌughajxy jaduhṉ jiaanc̈h mänaaṉ̃, ");
INSERT INTO mirNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","mänitä Pilato jaꞌa cuꞌug jadähooc miäyajtøøyy: ―Y yøꞌø Jesúsäts, jaꞌa tyijy hajxy mgobiernähajpiä, neby hajxy yøꞌø myajnähdijy nébiøch yøꞌø ndúnät. ");
INSERT INTO mirNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mänitä cuꞌughajxy møc yaax̱y: ―Møjpahbet hajxy cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mänitä Pilato miänáaṉgumbä: ―¡Pero tisän! Tii tøø quiädieey. Mänit hajxy maas møc yáax̱cumbä: ―Møjpahbet hajxy cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mänitä Pilato jiaanc̈h mänaaṉ̃ coo jaꞌa Barrabás hajxy ween nøcxy yajpädsøm̱y pujxtøgooty. Hix̱, cabä Pilato jaꞌa cuꞌug hänajty yagjootmaꞌadaꞌañ. Mänitä Pilato miänaaṉ̃ coo jaꞌa Jesús wiobhoꞌogǿøjät. Mänit miänáaṉgumbä coo jaꞌa Jesús hajxy nøcxy cruzcøxp miøjpahbety. ");
INSERT INTO mirNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mänitä soldado jaꞌa Jesús hajxy yajnøcxy maa jaꞌa hagujcän. Mänitä soldado jaꞌa jiamiøød hajxy quiøx̱y møjyaax̱y. ");
INSERT INTO mirNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mänitä Jesús hucywyit yajnähtämoogøøyyä. Mänitä haptycorona yajcuhjenøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mänitä Jesús tiägøøyyä wiinyáax̱äbä: ―¡Viva jaꞌa Jesús, jaꞌa judíoshajxy jaduhṉ guiobiernähajpiä! ¡Viva! Jaduhṉä Jesús hänajty wyiinwooñii. ");
INSERT INTO mirNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mänit hoyhoy wiojpä quiuhduum pax̱yhaam. Møød wyiingutsujøøyyä. Mänit wyiinjijcädaacä. Jaduhṉä soldadohajxy hänajty jiatcøꞌøy nebiä wyiingudsähgøøbiän. ");
INSERT INTO mirNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pero wyiinwohm̱biä Jesús hajxy hänajty jaduhṉ. Mänitä hucywyit hajxy yajtsijy. Mänitä yhamdsoo wit yajpøgǿøyyäxä. Mänit hajxy yajnøcxy maa hajxy hänajty miøjpahbedaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mänitä jäyaꞌay hajxy tuꞌug jiøjcubaadøøyy. Camjooty hänajty tøø yhoy. Simón hänajty xiøhaty. Jim̱ hänajty chooñ Cirene. Jueꞌe yhuunghajxy hänajty xiøhaty Alejandro møødä Rufo. Jim̱ä Jesús cruz hänajty chøm̱ä. Mänitä Simón hadsip ñämaayyä coo jaꞌa Jesús ween piuhdsømøꞌøy. Mänitä Simón jaꞌa cruz jiaanc̈h tsømøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mänitä Jesús yajmejtsä maa jaꞌa nähgaphuung hänajty xiøhatiän Gólgota. Jaduhṉä nähgaphuung hänajty quiähxøꞌøgy nebiä hoꞌogyjiäyaꞌaguiopcän, paady hajxy jaduhṉ yajxøbejty Gólgota. ");
INSERT INTO mirNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mänitä Jesús vino jia mooyyä. Mirra jaꞌa vino hajxy hänajty tøø yajmädemøꞌøy. Pero cabä Jesús jaduhṉ ñäꞌägä huucy. ");
INSERT INTO mirNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Mänitä Jesús miøjpahbejtä cruzcøxp. Møjpetyxiøø hänajty jaduhṉ. Tøø jaꞌa Jesús jaꞌa wyit hänajty jadähooc yajtsíjjäxä. Mänitä soldado jaꞌa Jesús jaꞌa wyit hajxy tiägøøyy yajniguiuhäyǿꞌcäbä. ");
INSERT INTO mirNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mänit hajxy jim̱ yuugjahy cruzcopcuhduum tiiguiøxpä jaꞌa Jesús jaduhṉ coo miøjpahbejtä: “Hädaa jaꞌa judíoshajxy guiobiernähajpy”, nøm̱ hajxy jim̱ quiujahy. ");
INSERT INTO mirNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mänitä meeꞌtspähajxy nämetsc miøjpahbéjtäbä. Tuꞌjäyaꞌay miøjpahbejtä maa jaꞌa Jesús yhahooyhaampiän. Jatuꞌug miøjpahbéjtäbä maa jaꞌa Jesús yhanajtyhaampiän. Cujcä Jesús jaduhṉ hoy piädaꞌagyii. ");
INSERT INTO mirNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Coo jaꞌa Jesús jaꞌa meeꞌtspä jaduhṉ näguipxy miøødhoꞌcy, jaduhṉä Diosmädiaꞌagy tiøjiajty maa jaduhṉ myiṉ̃än cujaay: “Haxøøghänaꞌc jaduhṉ pianänøøm̱ä.” ");
INSERT INTO mirNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jaꞌa jäyaꞌayhajxy hänajty jaduhṉ jim̱ naxøøbiä, høxtä yagjuøøby hajxy hänajty coo jaꞌa Jesús hajxy jim̱ yhijxy cruzcøxp. Møød hajxy hänajty wyiinwooñ: ―Jaꞌa, miic̈h mahñdy jaꞌa tsajtøjc mwiꞌi yagjidaam̱by, y cudägøøgxøøyyä mahñdy miic̈h jeꞌe mhädiuuṉdägátsät. ");
INSERT INTO mirNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pø tøy miic̈h møcmäjaa mjaanc̈h møødä, tiids miic̈h jim̱ coo mgaꞌa mänacy cruzcøxp. Jadúhṉäts mbäyǿꞌøgät ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jaanä jaduhṉä teedywiindsøṉhajxy hänajty miäwiingapxpejpä, møødä hänaꞌc‑hajxy hänajty jim̱ yajnähixøøbiä maa jaꞌa tsajtøjcän. Jaduhṉ hajxy hänajty ñiñämaꞌayii: ―Tøø yøꞌø wiinghänaꞌc may yajnähwaꞌac̈h, pero caj yøꞌø hamdsoo hoy yajniñähwaꞌadsaꞌañii. Jaduhṉ hijty ñibiädaꞌagyii nebiä Dioshuungän. Jaduhṉ hijty niñänømyii cooc tyijy jaꞌa judíoshajxy guiobiernähaty. ");
INSERT INTO mirNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mänit hajxy häyaa njaanc̈h mäbǿjcämät, nägooyyä jim̱ miänácät cruzcøxp. Jaanä jaduhṉä meeꞌtspähajxy hänajty miäwiingapxpejpä, jaꞌa Jesús hajxy hänajty näguipxy tøø miøødmøjpahbedyíijäbä. ");
INSERT INTO mirNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nägooyyä quiujyxiøøjøøyy, mänit jaduhṉ cøjx wyiingoodsøꞌøy. Tägøøghora jaduhṉ yhijty wiingoods. ");
INSERT INTO mirNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Coo jaꞌa xøø jaduhṉ wyiinjajtúutcumbä, mänitä Jesús møc yaax̱y: “Eloi, Eloi, lema sabactani.” Jaduhṉ miädiaꞌagytiägøꞌøy: “Diosteedy, Diosteedy, tiic̈h coo tøø xñähgueꞌegy.” ");
INSERT INTO mirNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jim̱ä jäyaꞌayhajxy hänajty näjeꞌe miäheeꞌpnaꞌay. Coo hajxy jaduhṉ miädooyy, mänit hajxy miänaaṉ̃: ―Mädow̱, Elíasädaꞌa møjyáax̱äp. ");
INSERT INTO mirNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mänit tuꞌjäyaꞌay esponja hoy quioṉ̃ päyøꞌøguiä. Mänit jiiby piamaꞌtsnajxy xuṉvinojooty. Mänitä esponja yujxojch pax̱yjøbhaam. Mänitä Jesús yaghagaabøøyyä coo jaduhṉ wyiinmúugät. Mänit jaayaꞌay miänaaṉ̃: ―Tsøc huuc híjxäm pø minaam̱bä Elías, pø yajmänacáaṉäbä Jesús cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mänitä Jesús møc yáax̱cumbä. Mänit yhoꞌnä. ");
INSERT INTO mirNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tuuṉä jaꞌa Jesús jaduhṉ ñäꞌä hoꞌcy, mänitä tsajtøjc‑hadøødiujt cujjiä quiøøꞌtswaꞌxy. Quiuhduum chohṉdaacy, høxtä yhøx̱haam jaduhṉ yhagøødsøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jim̱ä capitán jaꞌa Jesús hänajty tuꞌug wyiindänaꞌay. Coo yhijxy coo jaꞌa Jesús hänajty tøø yhoꞌogy, mänit miänaaṉ̃: ―Tøyhajt yøꞌøduhṉ hijty Dyioshuungä. ");
INSERT INTO mirNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jim̱ä tajjäyaꞌayhajxy hänajty näjeꞌe miäheeꞌpnaꞌay jäguem̱juøøby. Jim̱ä María hänajtypä, jaꞌa hänajty jim̱ tsohm̱bä Magdala, møødä Salomé. Jaꞌa María, jaꞌa Santiago møødä José tiaj, jim̱ hänajty jeꞌebä. Jaꞌa muutspä Santiago jaduhṉ ñänøøm̱by. ");
INSERT INTO mirNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hädaa tajjäyaꞌayhajxy, quipxiä Jesús hajxy hänajty tøø piawädity jim̱ Galilea. Tøø hajxy hänajty piuhbety mänaa hänajty jim̱ tøø yhitiän. Y coo jaꞌa Jesús jaduhṉ piejnä Jerusalén, quipxy hajxy piabejty, näguipxy møødä wiingjäyaꞌayhajxy nämay. ");
INSERT INTO mirNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Jaꞌa viernes hänajty tsuujøøby. Jaꞌa pooꞌxxiøø hänajty tsohṉdaꞌagaam̱b, jaꞌa pascuaxøø. Ñähix̱ yhahixøøbiä judíoshajxy hänajty jaꞌa pascuaxøøgøxpä. Jim̱ä jäyaꞌay hänajty tuꞌug chooñ Arimatea. José hänajty xiøhaty. Jim̱ hänajty miøjtuuṉgmøødä tsajtøgooty. Jaanc̈h tehm̱ yhojiäyaꞌayä José hänajty. Jiøbhijxyp hänajty jaduhṉ coo jaꞌa Dios jaꞌa møcmäjaa hänajty yajcähxøꞌøgaꞌañ. Mänitä José jaꞌa Pilato jaꞌa Jesús ñaax̱niꞌx hoy miäyujwaaṉä. Hix̱, cabä José jaꞌa Pilato hänajty chähgøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Cahnä Pilato hänajty miädoyhatyñä coo jaꞌa Jesús hänajty tøø yhoꞌnä. Yagjuøøyy jeꞌeduhṉ coo jaꞌa Jesús paquiä yhoꞌcy. Mänitä Pilato jaꞌa capitán miøjyaax̱y. Mänit miäyajtøøyy mäduhnajtä jaꞌa Jesús yhoꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Coo jaꞌa Pilato jaduhṉ yhawáaṉäxä coo jaꞌa Jesús hänajty tøø jiaanc̈h hoꞌogy, mänit miänaaṉ̃ coo jaꞌa José jaꞌa hoꞌogyjiäyaꞌay ween yajmänacy cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mänitä José sábana hoy jiuy. Mänitä Jesús hoy yajmänacy cruzcøxp. Mänit ñähbijty ñähmojch sábanahaam. Mänit hoy yajnaax̱tägøꞌøy tsaajutjooty. Mänitä tsaajut jaꞌa tsaa hajxy yaghadäguejtägooyy. ");
INSERT INTO mirNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jim̱ä Maríahajxy hänajty miäheeꞌpnaꞌay, møødä Magdala‑tsohm̱bä, møødä José tiaj. ");
INSERT INTO mirNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Coo jaꞌa pooꞌxxiøø hänajty tøø ñajxnä, mänitä María perfume hajxy hoy jiuy, møødä Magdala‑tsohm̱bä, møødä Santiago tiaj, møødä Salomé. Jaꞌa Jesús jaꞌa perfume hajxy hänajty yajnähjaaxaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Cujaboom jopy jaꞌa Maríahajxy jim̱ ñøcxy maa jaꞌa Jesús hänajty tøø ñaax̱tägøꞌøyän. Näxøø hänajty jeꞌe. Tøø jaꞌa xøø hänajty piädsøøm̱nä. ");
INSERT INTO mirNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tuꞌhaamnøcxpä hajxy tiägøøyy niñämáayyäbä: ―Pøṉä tsaa häyaa hadäguejtúꞌudäp. ");
INSERT INTO mirNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tehm̱ miejtsp hajxy hänajty jim̱, mänitä tsaajut hajxy yhijxy coo hänajty yhawaꞌadsän. Tøø hänaꞌcä tsaa hänajty yagjuaꞌac̈h, hoyyä tsaa hänajty jia cruuṉdä. ");
INSERT INTO mirNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Coo hajxy jiiby chaajuttägøøyy, mänitä muutsc‑hänaꞌc hajxy tuꞌug yhijxy. Jiiby hänajty yhäñaꞌay hahooyhaamby. Yom̱ybioobwit hänajty miøød. Coo jaꞌa Maríahajxy jaduhṉ yhijxy, mänit hajxy chähgøøyy. ");
INSERT INTO mirNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mänit hajxy ñämaayyä: ―Caꞌa hajxy mdsähgøꞌøy. Jaꞌa Jesús hajxy mhøxtaaby, jaꞌa jim̱ tsohm̱bä Nazaret, jaꞌa tøø miøjpahbedyíijäbä cruzcøxp. Tøø jiujypiøjtägach. Tøø yaa chohṉnä. Huuc tehm̱ yhix̱ hajxy, cab jeꞌe yaajän maa jeꞌe piädaacän. ");
INSERT INTO mirNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nøcx jaꞌa jiamiøød hajxy hawaaṉä. Møødä Pedro, mhawáaṉäp jeꞌebä. Jaduhṉ hajxy mhawáaṉät cooc jim̱ ñøcxaꞌañ Galilea. Jím̱äc hajxy nøcxy piaady, neby hajxy hijty tøø yajmøødmädiaꞌagyiijän ―nøm̱ä muutsc‑hänaꞌc miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Päyøꞌøguiä Maríahajxy jiutpädsøøm̱y. Tsähgǿøyyäp tsäyúuyyäp hajxy piädsøøm̱y. Cab hajxy jaduhṉ pøṉ ñäꞌägädä hawaaṉä. Hix̱, jaanc̈h tehm̱ chähgøøby hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Näxøø jopy jaꞌa Jesús jiujypiøjtägajch. Mänitä María jayøjp yhijxtsohṉnä, jaꞌa hänajty jim̱ tsohm̱bä Magdala, jaꞌa møjcuꞌu juxtujc‑hooc yajnähwáatsäbä. Jaꞌa Jesús jaduhṉ mäyajnähwaats. ");
INSERT INTO mirNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mänitä María jaꞌa Jesús jiamiøød hoy jia hawaaṉä. Wiꞌi jiøøby wiꞌi xiuuꞌtsp jaꞌa Jesús jiamiøødhajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hoy hajxy jia nämaayyä coogä Jesús hänajty tøø jiujypiøcy, møød coogä María hänajty tøø yhix̱y hajujcy, cab hajxy ñäꞌägä mäbøjcy. ");
INSERT INTO mirNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cujecy, jim̱ä Jesús jaꞌa jiamiøødhajxy hänajty nämetsc ñøcxy camjooty. Mänitä Jesús ñäguehx̱tøøꞌxy maa wyiinduumhajxiän. ");
INSERT INTO mirNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mänitä jiamiøød hajxy hoy jia hawáaṉäbä. Ni jeꞌe jaꞌa miädiaꞌagyhajxy jaduhṉ quiaꞌa mäbǿjcäxä. ");
INSERT INTO mirNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Cujequiä Jesús jiamiøødhajxy hänajty quiay, jaꞌa hajxy hänajty nämajtuꞌugpä. Mänitä Jesús jim̱ ñäguehx̱tǿøꞌxcumbä maa hajxy hänajty quiayyän. Mänit hajxy jaduhṉ ñämaayyä: ―Tii mijtsä miädiaꞌagy hajxy coo tøø mgaꞌa mäbøjcä, jaꞌa mijts tøø xjia hawáaṉäbä cóogøch hajxy tøø xyhix̱y hajujcy, cóogøch tøø njujypiøjtägach. ");
INSERT INTO mirNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nøcx hädaa mädiaꞌagy hajxy yajwaꞌx wiinduhm̱yhagajpt. Jaduhṉä jäyaꞌay hajxy nägøx̱iä myajwiingapxǿꞌøwät neby hajxy ñähwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pønjaty jaduhṉ mäbøjp, pønjaty jaduhṉ näbejp, jeꞌedshajxy jaduhṉ nähwaꞌadsaam̱b. Pero pønjaty jaduhṉ caꞌa mäbøjp, haxøøgtuum hajxy jeꞌe miähmøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Pønjaty jaduhṉ mäbøjp, hijxtahṉd hajxy yajcähxøꞌøgaam̱by hoy‑yagjuǿøñäbä. Jaꞌa høøc̈hcøxpä, jaduhṉä paꞌamjäyaꞌay hajxy yajnähwáꞌadsät, jaꞌa hajxy møjcuꞌumøødpä. Wiinghayuuc hajxy miädiaꞌagáaṉnäp. ");
INSERT INTO mirNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hoyyä tsahṉ̃dy hajxy tiehm̱ wyidsǿꞌøgät, cab hajxy nej tiunǿøjät. Hoyyä veneno hajxy tiehm̱ yhúꞌugät, ni jaduhṉ hajxy nej quiaꞌa jádät. Y coo jaꞌa paꞌamjäyaꞌay hajxy quiøꞌønähgábät, náxäbä piaꞌamhajxy. ");
INSERT INTO mirNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Coo jaꞌa Jesús jaꞌa jiamiøødtøjc miøødmädiaacpädøøyy, jaꞌa hajxy nWiindsønhájtämbä, mänit ñøcxnä tsajpootyp. Mänit hoy yhøxtaꞌagy maa jaꞌa Tieediä yhahooyhaampiän. ");
INSERT INTO mirNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mänitä jiamiøødhajxy jiaanc̈h tuꞌubøjcy. Mänitä mädiaꞌagy hajxy hoy yajwaꞌxy wiinduhm̱yhagajpt. Piuhbejpiä Jesús jaꞌa jiamiøødtøjc hänajty. Majaty hajxy hänajty wiädity, yajcähxøꞌpiä hijxtahṉd hajxy hänajty hoy‑yagjuøøñäjaty. Jaduhṉ hänajty yajnajuøꞌøy coo hajxy hänajty tiømiädiaꞌagy. Amén.");
INSERT INTO mirNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Mäguꞌughajpä Teófilo, miic̈hcǿxpøch hädaa nocy nhädiuṉ̃ nej miic̈h jaꞌa tøyhajt jaduhṉ mmøødhádät jaꞌa Jesucristocøxpä, nej jiajty nej yhabejty, nej ñibianøcxyii. Pedyíijøch jaduhṉ tøø nhabøcy. Jaduhṉ miic̈h tøø mmädoyhajpä. Nämay jäyaꞌay jaꞌa nocy capxy hajxy tøø yajpädøꞌøgy jaꞌa Jesucristocøxpä. Jaꞌa Diosmädiaꞌagy‑yajwaꞌxpähajxy, jeꞌeds hajxy jaduhṉ tøø xyajmädoyhájtäm. Yhamdsoo wiinhaam hajxy tiehm̱ yhijxy. ");
INSERT INTO mirNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Coo jaꞌa Herodes hänajty jim̱ guiobiernähaty Judeanaaxooty, jim̱ä jäyaꞌay hänajty tuꞌug xiøhaty Zacarías. Teedy jaꞌa Zacarías hänajty tiuum̱by maa jaꞌa judíos jaꞌa quiuhdujthajxy hänajty myiṉ̃än. Jaꞌa Abías jaꞌa quiuhdujt hänajty yajtúuṉäxäp neby hänajty jecy tøø yhaneꞌemiän. Jaꞌa Zacarías jaꞌa tioꞌoxiøjc, Elisabet hänajty xiøhaty. Jaꞌa Aarón yhap yhoc jaꞌa Elisabet jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pedyii jaꞌa Zacaríashajxy hänajty quiudiuṉ̃ jaꞌa Diosmädiaꞌagy. Hoy hajxy hänajty yajtuṉ̃ nebiä Dios choquiän. ");
INSERT INTO mirNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero cabä yhuunghajxy hänajty nituꞌugtä. Cahnä Elisabet hänajty ñäꞌägädä huungpaadyñä. Tøøds hajxy hänajty miäjaanä. ");
INSERT INTO mirNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tuꞌugxøøbä, jiibiä Zacarías hänajty tiuṉ̃ møjtsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mänitä piaatä coo jaꞌa poom jiiby jiógät maa jaꞌa poomjojtaactän, jim̱ Dioswiinduum. Jaduhṉä teedyhajxy hänajty quiuhdujthaty. ");
INSERT INTO mirNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mänit yhabaaty coo jaꞌa Zacarías jaꞌa poom hänajty jiiby jiogaꞌañ. Mänitä cuꞌughajxy yhamugøøyy møjtsajtøghaguuy. Mänit hajxy tiägøøyy Diospaꞌyaax̱pä. ");
INSERT INTO mirNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jim̱ä Zacarías hänajty pioomjocy, mänitä Dios mioonsä tuꞌug ñäguehx̱tøøꞌxy hahooyhaamby maa jaꞌa poom hänajty jioquiän. Jim̱ hänajty tøø chooñ Dioswiinduum. ");
INSERT INTO mirNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Coo jaꞌa Zacarías jaduhṉ yhijxy, mänit chähgøøyy. Cabä wiinmahñdy piaaty nej jiatcǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mänit ñämaayyä: ―Zacarías, caꞌa mdsähgøꞌøy. Tøø jaꞌa Dios miädoy nej tøø mmägapxiän coo huung xmióꞌowät. Huungpaadaam̱b jaꞌa mdoꞌoxiøjc jaduhṉ. Juan jaꞌa mhuung myajxøhátät. ");
INSERT INTO mirNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mxooṉdaꞌagaam̱b miic̈h jaduhṉ jaꞌa mhuungcøxpä. Nämay jaꞌa jäyaꞌayhajxy jaduhṉ xiooṉdaꞌagaam̱bä coo mhuung myínät miédsät. ");
INSERT INTO mirNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Cumay jaꞌa mhuung piädsøm̱aꞌañ jaꞌa Dioscøxpä. Miøødhadaam̱biä Dioshespíritu; jaduhṉ miämíṉ miägaꞌawaꞌañ. Cabä jocnøø yhuꞌugaꞌañ ni jaꞌa vino. ");
INSERT INTO mirNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","17","Jaduhṉdsä cuhdujt miøødhadaꞌañ nebiä Elías jecy miøødhajtiän. Jaꞌa Diosmädiaꞌagy jaduhṉ yajwaꞌxaam̱by. Mänitä judíos jaꞌa Dios hajxy jiahmiejtstaactägatsaꞌañ jadähooc. Jaduhṉä Juan yajwiingapxøꞌøwaꞌañ coo jaꞌa yhuung hajxy quiaꞌa møødnimiädsiphájtänät, y coods hajxy miäbǿjnät jaꞌa hoguiapxy jaꞌa homiädiaꞌagy pøṉ yhamdsoo cuhdujt ja wiꞌi yajtunaam̱b. Coo hajxy jaduhṉ quiudiúnät, mänitä Dios jaduhṉ quiuhbøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mänitä Zacarías miänaaṉ̃: ―Nébiøch jaꞌa tøyhajt jaduhṉ nmøødhádät cooc̈h nhuung myinaꞌañ. Tøø højts nmäjaanä mǿødhøch ndoꞌoxiøjc. ");
INSERT INTO mirNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mänitä Dios mioonsä yhadsooyy: ―Gabriélhøch nxøhaty. Jím̱høch ndsooñ Dioswiinduum. Jeꞌec̈h tøø xquiex̱y cooc̈h miic̈h miṉ nhawaaṉä coo jaꞌa mhuung jaduhṉ myinaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Cooc̈h miic̈h jaꞌa nmädiaꞌagy tøø xquiaꞌa mäbøjcä, huum miic̈h mmähmøꞌøwaꞌañ. Høxtä coonä jaꞌa mhuung myínät, mänit mgapxøꞌøgaꞌañ. Tøjiadaam̱b jaduhṉ nébiøch cham̱ nmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jim̱ä cuꞌug jaꞌa Zacarías hajxy hänajty jia wiꞌi yhahix̱y møjtsajtøghaguuy. Yagjuøøby hajxy hänajty coo jaꞌa Zacarías jiiby wyiꞌi jiecy tsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Coo jaꞌa Zacarías tiøjpädsøøm̱nä, tøø hänajty jiaanc̈h huumy. Mänitä cuꞌughajxy ñajuøøyy coo jaꞌa Zacarías jaꞌa tsøꞌty hänajty tøø yhix̱y. Hix̱, cøꞌøhaam yajnähixøøñä. ");
INSERT INTO mirNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hoorä, coo jaꞌa Zacarías yaghabejty mäduhṉ̃tiä hänajty tiunaꞌañ tsajtøgooty, mänit ñøcxnä maa jaꞌa quiajptän. ");
INSERT INTO mirNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mänitä tioꞌoxiøjc jiaanc̈h mähmøøyy maaxhuungmøød. Jiiby ñäꞌägä mähmøøyy tøgooty mägoox̱poꞌo. Caj ñäꞌägä tøjpädsøøm̱nä. Jaduhṉ hänajty wyiꞌi miädiaactaꞌagy quiopcooty: ");
INSERT INTO mirNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Páadyhøch jaꞌa Dios jaduhṉ tøø xñäxuuc̈h nébiøch jaꞌa cuꞌughajxy jaduhṉ xquiaꞌa péjxnät.” ");
INSERT INTO mirNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tädujpoꞌo jaꞌa Elisabet hänajty tøø yhity maaxhuungmøød, mänitä Dios jaꞌa Gabriel quiéjxcumbä. Jim̱ä Gabriel quiejxä maa jaꞌa cajpt xiøhatiän Nazaret jim̱ Galileanaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Jaꞌa María jaduhṉ yajnäguejxä. Cäxyiihajpnä hänajty jeꞌenä. Tøø hänajty tiødiägøꞌøy coo jaꞌa José hänajty piøgaꞌañ. Jueꞌe jaꞌa José, David yhap yhoc jeꞌe, jaꞌa hijty jegyhajty gobiernätuum̱bä. ");
INSERT INTO mirNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mänitä Gabriel tiøjtägøøyy maa jaꞌa María hänajtiän. Mänitä María ñämaayyä: ―Dióshøch tøø xquiex̱y cooc̈h miic̈h jaduhṉ nmägápxät. Miic̈hcøxpä jaꞌa Dios jaꞌa mayhajt tiunaꞌañ. Xmiøødhijp miic̈h jaꞌa Dios. Maas hoy miic̈h jaꞌa Dios xyhix̱y quejee jaꞌa mmädoꞌoxiøjc‑hajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Cabä María hänajty ñajuøꞌøy tii jaduhṉ coo tøø ñämaꞌayii jaꞌa Dioscøxpä. Tsähgøøyy jaduhṉ siémpräm. ");
INSERT INTO mirNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mänitä ñämáayyägumbä: ―María, caꞌa mdsähgøꞌøy. Møj jaꞌa Dios jaꞌa mayhajt tiunaꞌañ jaꞌa miic̈hcøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mhuungpaadaam̱b miic̈h jaduhṉ. Jesús jaꞌa mhuung myajxøhataꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Møj jaanc̈h jaduhṉ yhidaꞌañ. Høxcabáaṉäp jaduhṉ coo Dyioshuungä. Dios jaduhṉ pädaꞌagaam̱b gobiernä nebiä David jecy tiuuṉ̃än, jaꞌa Jesús yhap tieedy. ");
INSERT INTO mirNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Paady jaduhṉ piädaꞌagaꞌañii gobiernä nebiä judíoshajxy yhanéꞌemät cøjxtaꞌaxiøø. Nimänaa jaduhṉ quiaꞌa hanehm̱bädøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mänitä María yajtøøyy: ―Nébiøch jaduhṉ nnäꞌä huungpáadät; cáhnøch yaꞌadiøjc nhix̱yhatyñä. ");
INSERT INTO mirNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mänitä Gabriel yhadsooyy: ―Minaam̱bä Dioshespíritu xyhuungmoꞌowaꞌañ. Dioshuung jaduhṉ minaam̱b caꞌawaam̱b. Cabä pojpä cädieey mänaa tiunaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Y miic̈h mhocmaam, jaꞌa Elisabet, jaduhṉ jeꞌe miaaxhuungpaadaam̱bä, hoy jaduhṉ jia majjä jia petiä. Tädujpoꞌohájnäp jeꞌe. Cábäc tyijy hijty miaaxhuungpaadaꞌañ; jaduhṉä cuꞌughajxy hijty miänaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pero cabä Dios tii tsip ñäꞌägä juøꞌøy. Hotyiijä jaduhṉ tiunaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mänitä María miänaaṉ̃: ―Wéenhøch jaꞌa Dios jaduhṉ xñäꞌägä moonsähaty. Wéenhøch jaduhṉ njaty nébiøch tøø xñämaꞌayän. Mänitä Gabriel wyiimbijnä. ");
INSERT INTO mirNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Mänitiä jaꞌa María ñøcxy maa jaꞌa Elisabethajxiän. Judeanaaxooty hajxy hänajty chänaꞌay tunjooty. Mänitä María tiøjtägøøyy. ");
INSERT INTO mirNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mänitä Elisabet yajpooꞌxä. Mänitä maaxhuung jiiby yuꞌxy Elisabet jioodooty. Mänitä Elisabet jaꞌa Dioshespíritu ñämejtsä. ");
INSERT INTO mirNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Mänitä Elisabet møc yaax̱y: ―Maas hoy miic̈h jaꞌa Dios xyhix̱y quejee jaꞌa mmädoꞌoxiøjc‑hajxy. Jaduhṉ miic̈h mhuung xyhixáaṉabä. ");
INSERT INTO mirNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Jaꞌa miic̈h mhuung, nwiindsøṉhadáam̱biøch jeꞌe. Nyagjuǿøbiøch jaduhṉ cooc̈h miic̈h xwyiingudsähgøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Túuṉøch miic̈h xñäꞌä yajpooꞌxy, mänítiøch nhuung yaaby jiaanc̈h tehm̱ yuꞌxy njoodóotyhøch. Jootcujc jaduhṉ ñijiäwøꞌøyii, paady yuꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tøjiadaam̱b jaduhṉ nej miic̈h jaꞌa Dios tøø xñämaꞌayän. Coo jaduhṉ mmäbøcy, jootcujc mhidaꞌañ ―nøm̱ä Elisabet jaꞌa María ñämaayy. ");
INSERT INTO mirNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mänitä María miänaaṉ̃: Tøyhajtä Dios miøjjä jiaanc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Jootcujc‑høch nnijiäwøꞌøyii cooc̈h jeꞌe xyhix̱y. ");
INSERT INTO mirNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Xjiahmiéjtspøch jaduhṉ, hóyhøch nja häyoy. Jootcujc‑høch jaꞌa jäyaꞌayhajxy xñäꞌägä nänømaaṉnä, ");
INSERT INTO mirNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","jeꞌeguiøxpä cooc̈h jaꞌa Dios tøø xyhuungmoꞌoy. Møj jaanc̈h jaꞌa Dios. ");
INSERT INTO mirNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pønjaty jaꞌa Dios jaduhṉ wiingudsähgøøby, Dios jaduhṉ näxuudsaam̱b cøjxtaꞌaxiøø. ");
INSERT INTO mirNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tøø jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgy; tøø hajxy quiaꞌa mäjädaꞌagy, jaꞌa hajxy hijty yajcumayaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tøø jaꞌa gobiernä quiuhdujthajxy piǿjcäxä, tøø jaꞌa häyoobäjäyaꞌayhajxy miøjtägøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tøø jaꞌa häyoobäjäyaꞌayhajxy cøx̱iä wiinä mioꞌoyii; cabä mäyøøjäyaꞌayhajxy tii tøø piaady. ");
INSERT INTO mirNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Piuhbejt jaꞌa Dios jaꞌa judíoshajxy. Cøjxtaꞌaxiøø ñäxuuc̈h piaꞌhäyoy, ");
INSERT INTO mirNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nebiä Abrahamhajxy jecy ñämaayyän, jaꞌa nhaphájtäm jaꞌa ndeedyhájtäm. ");
INSERT INTO mirNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tägøøgpoꞌo jaꞌa María jim̱ jiaac hijty maa jaꞌa Elisabetän. Mänit yhädaacnä maa jaꞌa quiajptän. ");
INSERT INTO mirNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mänitä Elisabet miaaxhuungpaatnä; yaꞌayhänaꞌc jaduhṉ miiṉgahw̱. ");
INSERT INTO mirNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mänitä Elisabet hoy quiuhixyíijäm jaꞌa jiujy jaꞌa miäguꞌughajxy møødä miädøjc‑hajxy. Mänit hajxy nägøx̱iä xiooṉdaacy coo Dios jaꞌa mayhajt jaduhṉ tøø tiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Cuductujxøø jaꞌa pigänaꞌc hajxy hoy yajcircuncidarhadyii nebiä judíoshajxy hänajty quiuhdujthatiän. Mänit hajxy jia yajxøhataaṉ̃ Zacarías nebiä tieedy hänajty xiøhatiän. ");
INSERT INTO mirNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mänitä tiaj miänaaṉ̃: ―Cábøch jaduhṉ nyajxøhataꞌañ. Juánhøch jaduhṉ nyajxøhataꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mänitä Elisabet ñämaayyä: ―Tii jaduhṉ coo myajxøhataꞌañ. Caj pøṉ jaduhṉ xiøhaty maa miic̈h mjujy maa miic̈h mmäguꞌugän. ");
INSERT INTO mirNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mänitä Zacarías miäyajtøøw̱ä cøꞌøhaam nebiä yhuung xiøhátät. ");
INSERT INTO mirNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mänitä puꞌuyhuung ñädsiiwøøyy coo mioꞌowǿøjät. Mänit yuugjahy puꞌuguiøxp: “Juan xiøhataꞌañ.” Mänit hajxy nägøx̱iä yagjuøøyy. ");
INSERT INTO mirNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mänitä Zacarías quiapxøꞌnä. Mänitä Dios Dioscujúꞌuyäp miooyy. ");
INSERT INTO mirNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jaanc̈h tehm̱ yagjuøøyy jaꞌa cuꞌughajxy jaduhṉ. Mänitä mädiaꞌagy tiägøøyy wädijpä jim̱ Judeanaaxooty jim̱ tunjooty nebiaty jaꞌa Zacarías tøø jiaty. ");
INSERT INTO mirNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Coo jaꞌa jäyaꞌayhajxy nägøx̱iä miädoyhajty, mänit hajxy tiägøøyy najuøødiaacpä. Mänit hajxy miänaaṉ̃: ―Pätiidä yøꞌø pigänaꞌc tiunaam̱by coo hänajty tøø yeegy. Tøyhajtä Dios hänajty piuhbedaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mänitä Zacarías ñämejtsä jaꞌa Dioshespíritu. Mänitä Zacarías jiømädiaacnajxy neby hänajty tøø miøødmädiaꞌagyiijän jaꞌa Diósäm: ");
INSERT INTO mirNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Møj jaanc̈h jaꞌa Dios; paady jaduhṉ tøø quiädaꞌagy coo højts xyajnähwaꞌads xyajcuhwaꞌadsáaṉäm, højts judíoshájtäm. ");
INSERT INTO mirNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tøø højts jaꞌa yajnähwaatspä yajcuhwaatspä xyajnäguéjxäm; jeꞌedsä møjcuhdujt jaduhṉ møød; jaꞌa David yhap yhoc jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","73","Jaduhṉä Dios jecy miänaaṉ̃ coo højts xyajnähwaꞌads xyajcuhwaꞌadsáaṉäm højts nmädsiphájtäm. Jaanä jaduhṉ miänaam̱bä coo xñäxuuds xpiaꞌhäyowáaṉäm. Yajtøjiadaam̱by jaduhṉ nebiä Abrahamhajxy jecy miøødyajcuhdujquiän, jaꞌa nhap jaꞌa ndeedyhajtämhajxy. Jaꞌa Diosquex̱yhajxy jaduhṉ jømädiaacnajx. ");
INSERT INTO mirNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Coo jaꞌa Dios hajxy jaduhṉ xñäwáaṉäm maa jaꞌa nmädsiphajtämhajxiän, paady hajxy ngaꞌa tsähgǿøyyänä. Hoyyä Dios hajxy nbanǿcxämät. ");
INSERT INTO mirNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Hawaꞌadstuum hajxy xyaghidáaṉäm cøjxtaꞌaxiøø. ");
INSERT INTO mirNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Huung, miic̈h nnämaaby coo Diosmädiaꞌagy‑yajwaꞌxpä mwäditaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Myajwiingapxøꞌøwaam̱by jaꞌa Dios quiuꞌughajxy neby hajxy jaduhṉ ñähwaꞌads quiuhwáꞌadsät. Coo jaꞌa Dios jaꞌa piojpä quiädieey hajxy yajmøødmädiáꞌagät, mänit hajxy yajnähwaꞌads yajcuhwaꞌadsǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Xñäxúuꞌtsäm jaꞌa Dios hajxy jaduhṉ, paadiä yajnähwaatspä yajcuhwaatspä quiejxy. ");
INSERT INTO mirNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Xpiädáacäm hajxy hawaꞌadstuum, xmióoyyäm jaꞌa hoyhajt jaꞌa weenhajt hajxy, nøm̱ä Zacarías miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hoorä, yeeꞌc møjjøøyy jaꞌa Juan jaduhṉ. Wiinmahñdymejts jaduhṉ. Ñajuøøyy jaduhṉ mädyii hoy mädyii mäbaad. Miøødhajt jaꞌa Dioshespíritu jaduhṉ. Coo miøjjøøyy, mänit tiägøøyy wädijpä hanidiuhm̱duum. Jim̱ yhijty høxtä coonä tiägøøyy Diosmädiaꞌagy‑yajwaꞌxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Coo jaꞌa xøø jomøjt yhabaaty, mänitä gobiernä Augusto yhanehm̱y coo jaꞌa jäyaꞌayhajxy ween nøcxy nägøx̱iä ñiguiujaayii maa jaꞌa yhamdsoo cajpthajxiän, jaꞌa hajxy wiinduhm̱yhagajptpä. ");
INSERT INTO mirNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jaꞌa Augusto jaduhṉ hanehm̱dsohṉ; cahnä pøṉ hänajty jaduhṉ yhaneꞌemyñä. Jaꞌa Cirenio, jeꞌe hänajty jim̱ tuum̱b gobernador Sirianaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mänitä jäyaꞌayhajxy nägøx̱iä jiaanc̈h cudiuuṉ̃ nebiä Augusto hänajty tøø yhaneꞌemiän. ");
INSERT INTO mirNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Jueꞌe jaꞌa José hänajty, jaꞌa David yhap yhoc hänajty jeꞌe. Belén jaꞌa cajpt hänajty xiøhaty maa jaꞌa David hänajty tøø myiṉ̃ tøø quiaꞌayän, jim̱ Judeanaaxooty. Coo jaꞌa David hänajty jim̱ tøø myiṉ̃ tøø quiaꞌay, paadiä Joséhajxy hänajty jim̱ nøcxy ñiguiujaayaꞌañii møødä María. Tøø hänajty tiødiägøøñä coo hajxy hänajty piøgaaṉnä. Maaxhuungmøød jaꞌa María hänajty. Galileanaaxooty hajxy hänajty tøø chohṉdaꞌagy maa jaꞌa cajpt xiøhatiän Nazaret. ");
INSERT INTO mirNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Coo hajxy jim̱ miejch Belén, mänitä María miaaxhuungpaaty. ");
INSERT INTO mirNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jaꞌa quioobhuung jaduhṉ miiṉgahw̱. Mänitä María ñähbijty ñähmojch. Mänit quiugoꞌogøøyy wajjøøꞌxøhñdyjooty. Hix̱, cabä mejtstaact hajxy hänajty maa tøø ñäꞌägädä paady jim̱ cajptooty. Paady hajxy jim̱ ñäꞌä nøcxøøyy tøjpaꞌc maa hänaꞌc jaꞌa waj hajxy hänajty yajtänaꞌayän. ");
INSERT INTO mirNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jim̱ hänaꞌc‑hajxy hänajty näjeꞌe mieegcueendähaty cajptpaꞌa. Coods hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mänitä Dios jaꞌa cujajpä cudøøꞌxpä yajcähxøꞌcy maa hajxy hänajty mieegcueendähatiän. Mänitä Diosmoonsä tuꞌug ñäguehx̱tøøꞌxy maa wyiinduumhajxiän; jim̱ hänajty tøø chooñ tsajpootyp. Mänit hajxy chähgøøyy. ");
INSERT INTO mirNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","11","Mänit hajxy ñämaayyä: ―Caꞌa hajxy mdsähgøꞌøy. Naam̱nä jaꞌa Cristo tøø myiṉ̃ tøø quiaꞌay jim̱ Belén. Mijts jaduhṉ xyajnähwaꞌads xyajcuhwaꞌadsaam̱b. MWiindsøṉhadaam̱by hajxy jaduhṉ. Páadyhøch nhawáaṉäm nebiä jäyaꞌayhajxy nägøx̱iä xiooṉdáꞌagät. ");
INSERT INTO mirNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Coo jaꞌa pigänaꞌc hajxy jaduhṉ mbáadät nähbity nähmoch wajjøøꞌxøhñdyjooty, jaduhṉ hajxy mnajuǿꞌøwät coo hänajty jieꞌejä. ");
INSERT INTO mirNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mänitä Diosmoonsähajxy nämay jiaac näguehx̱tøøꞌxy; haagä jim̱ hajxy hänajty tøø chooñ tsajpootyp. Mänit hajxy miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Møj jaanc̈h jaꞌa Dios; tsajpootyp jaduhṉ yhity. Jootcujc jaꞌa jäyaꞌayhajxy yaa yhidaꞌañ hädaa yaabä naax̱wiin pønjaty jaꞌa Dios quiumaaby. ");
INSERT INTO mirNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mänitä Diosmoonsä hajxy wyiimbijnä, ñøcxnä hajxy tsajpootyp. Mänitä meegcueendähajpähajxy ñiñämaayyä: ―Jam̱ hajxy híjxäm Belén nebiä Diosmoonsä hajxy tøø xyhawáaṉäm. ");
INSERT INTO mirNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Päyøꞌøguiä hajxy tiuꞌubøjcy. Mänitä Jesucristo hajxy hoy jiaanc̈h paady møødä María møødä José. Jiibiä Jesucristo hänajty quioꞌnaꞌay nähbity nähmoch wajjøøꞌxøhñdyjooty. ");
INSERT INTO mirNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mänitä mädiaꞌagy hajxy hoy yajwaꞌxy nebiaty hajxy hänajty tøø yhix̱y tøø miädoy jaꞌa Jesucristocøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jaꞌa jäyaꞌayhajxy jaac mädoyhájtäbä, yagjuøøyy hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero cabä María jaduhṉ yagjuøøyy. Tøø hänajty miøødmädiaꞌagyii coo jaduhṉ jiadaꞌañ yhabetaꞌañ. Jiiby quiopcooty miädiaactaacy. Caj pøṉ yajmøødmädiaacy. ");
INSERT INTO mirNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Haa jaꞌa meegcueendähajpähajxy, mänit hajxy wyiimbijnä, ñøcxnä hajxy. Mänitä Dios jaꞌa Dioscujúꞌuyäp hajxy miooyy coo hajxy tøø yhix̱y tøø miädoy nebiaty hajxy hänajty tøø miøødmädiaꞌagyii. ");
INSERT INTO mirNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cuductujxøø jaꞌa Jesús hajxy yajcircuncidarhajtä. Mänit hajxy yajxøbejty Jesús nebiä María hänajty tøø ñämaꞌayii coo hänajty quiaꞌa huungmoꞌoyiinä. Jaꞌa Diosmoonsä tsajpootypä hänajty hoy tøø ñämaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Coo jaꞌa xøø hänajty tøø yhabejnä, mänit hajxy hoy chiꞌiy nebiä ley myiṉ̃än, jaꞌa Moisés jecy quiujáhyyäbä. Mänitä Jesús hajxy jiiby chehṉhädaacy Jerusalén jim̱ møjtsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jaduhṉ jiiby myiṉ̃ maa jaꞌa Diosmädiaꞌaguiän: “Jaꞌa coobhuung yaꞌayhänaꞌcpähajxy, Diostuuṉg hajxy tiunaam̱by.” ");
INSERT INTO mirNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mänitä paloma hajxy metsc yojxy nebiä jiiby myiṉ̃än cujaay maa jaꞌa Diosmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jim̱ä jäyaꞌay hänajty tuꞌug chänaꞌay Jerusalén; Simeón hänajty xiøhaty. Hojiäyaꞌay hänajty jeꞌe. Hoyyä Dios hänajty wyiingudsähgøꞌøy. Miøød jaꞌa Dioshespíritu hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tøø hänajty miøødmädiaꞌagyíijäm jaꞌa Dioshespíritu coo hänajty quiaꞌa tsoj hoꞌogaꞌañ høxtä coonä jaꞌa Cristo hänajty tøø yhamdsoo hix̱y, jaꞌa Dios hänajty quiexaam̱biä. ");
INSERT INTO mirNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mänitä Simeón ñämaayyä jaꞌa Dioshespíritu coo jim̱ ñǿcxät tsajtøgooty. Mänitä Jesús hoy jiiby piaady møødä tiajhajxy. Cahnä hajxy hänajty wyiimbityñä. ");
INSERT INTO mirNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","29","Mänitä Simeón jaꞌa Jesús chehṉdsooyy. Mänitä Simeón miänaaṉ̃: Diosteedy, Dioscujúꞌuyäp, jootcújc‑høch nhóꞌogät, jeꞌeguiøxpä coo tøø myajtøjiaty nébiøch hijty tøø xmiøødmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Hamdsóojøch tøø nhix̱y jaꞌa yajnähwaatspä, jaꞌa yajcuhwaatspä, ");
INSERT INTO mirNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","jaꞌa miic̈h tøø mguéx̱iäbä hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jaꞌa hajxy caꞌa judíospä, yajwiingapxøꞌøwáaṉäp jaꞌa hoguiapxy jaꞌa homiädiaꞌagy hajxy. Jaꞌa judíoshajxy, cumayáaṉäp hajxy jeꞌe; møj jaanc̈h hajxy piädaꞌagaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mänitä Jesús tiajhajxy yagjuøøyy coo yhuunghajxy hänajty jaduhṉ tøø ñänǿøm̱äxä. ");
INSERT INTO mirNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Mänit hajxy ñämaayyä: ―Weenä Dios jaꞌa hoyhajt jaꞌa weenhajt xmioꞌoy. Mänitä María nidiuhm̱ ñämaayyä: ―Näjeꞌe jaꞌa judíoshajxy yhidaꞌañ tuꞌugmädiaꞌagy møød miic̈h mhuung. Piaadaam̱by jaꞌa hoyhajt jaꞌa weenhajt hajxy jeꞌe. Pero nämay hajxy jaduhṉ quiaꞌa møødhidaꞌañ tuꞌugmädiaꞌagy. Ñähwaam̱bedaam̱by hajxy jeꞌe. Tuꞌudägoyyaam̱b hajxy jaduhṉ. Cähxøꞌøgaam̱bä wyiinmahñdyhajxy jaduhṉ neby hajxy tiajy miay. ");
INSERT INTO mirNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Jiibiä yaamgtoꞌoxy hänajty tuꞌug tsajtøgooty; Ana hänajty xiøhaty. Fanuel jaꞌa tieedy hänajty tøø xiøhaty. Aser jaꞌa yhap jaꞌa tieedy jegyhajty xiøhaty. Juxtujcjomøjt jaꞌa ñihyhap hänajty tøø miøødtsänaꞌay. Mänitä ñihyhap yhoꞌnä. Mänítäts hänajty tøø jiaac jugyhaty mädaax̱c‑hiiꞌxcumädaax̱cjomøjt nidiuhm̱. Tøø hänajty miäjaanä. Jaꞌa Diosmädiaꞌagy hänajty yajwaꞌxyp. Jiiby hänajty ñäꞌägä tuṉ̃ tsajtøgooty. Xøømdsuhm̱ jaꞌa Dios hänajty wyiingudsähgøꞌøy. Hayuu hänajty yhity tähoocjaty nebiä Diosmädiaꞌagy jaduhṉ maas hoy wyiinjuǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Coo jaꞌa Ana jaduhṉ miädooyy nebiä Simeón jaꞌa Jesús ñänøøm̱iän, mänitä Dios miooyy Dioscujúꞌuyäp. Mänitä mädiaꞌagy tiägøøyy yajwaꞌxpä jim̱ Jerusalén coo jaꞌa Cristo tøø quiädaꞌagy. Nägøx̱iä jäyaꞌayhajxy miädoyhajty, jaꞌa Cristo hajxy hänajty yhahijxypä. ");
INSERT INTO mirNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Coo jaꞌa Maríahajxy hänajty tøø quiudiuṉ̃ nebiä Diosley myiṉ̃än, mänit hajxy wyiimbijnä, yhädaacnä hajxy Nazaret jiiby Galileanaaxooty, maa hajxy hänajty tøø chooñän. ");
INSERT INTO mirNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yeeꞌc møjjøøyy jaꞌa Jesús jaduhṉ. Wiinmahñdymejts jaduhṉ. Dios jaduhṉ mooyy jaꞌa hoyhajt jaꞌa weenhajt. ");
INSERT INTO mirNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wiingujomøjt jaꞌa judíos jaꞌa xøø hajxy hänajty yagjadyii jim̱ Jerusalén mänaabä jaꞌa meeghuung hajxy hänajty yox̱iän. ");
INSERT INTO mirNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Coo jaꞌa Jesús majmetscjomøjt yaghabejty, mänitä Maríahajxy ñøcxy xøøhajpä Jerusalén møødä Jesús, nebiä cuhdujt hajxy hänajty miøødän. ");
INSERT INTO mirNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Coo jaꞌa xøø hänajty tøø miaañä, mänit hajxy wyiimbijnä. Pero jaꞌa Jesús, jim̱ jeꞌe miähmøøyy Jerusalén nidiuhm̱. Cabä tiajhajxy hänajty ñajuøꞌøy pø tøø miähmøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jaduhṉ hajxy hänajty miänaꞌañ cooc tyijy hajxy hänajty jim̱ piamänaqyii møødä miäguꞌughajpähajxy. Tuꞌxøø jaꞌa Maríahajxy hänajty tøø tiuꞌuyoꞌoy, mänitä Jesús hajxy yhixpaaty coo hänajty jim̱ quiaꞌa pamänacy høx̱haam. Mänit hajxy jia høxtaayy maa jaꞌa jiujy jaꞌa miäguꞌughajxiän. ");
INSERT INTO mirNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Coo hajxy quiaꞌa paaty, mänit hajxy wyiimbíjcumbä. Mänit hajxy ñøcxtägajch Jerusalén jadähooc. ");
INSERT INTO mirNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jim̱ä Jesús hajxy jiaanc̈h paaty tsajtøgooty. Miädägøøgxøøbä hänajty jim̱ tøø yhity. Jiiby hänajty yhäñaꞌay maa jaꞌa ley‑yajnähixøøbiädøjc‑hajxiän, jaꞌa hajxy jiiby tsajtøgootypä. Jiibiä capxy mädiaꞌagy hänajty miämädoonaꞌay. Cøx̱iä wiinä hänajty yajtøy. ");
INSERT INTO mirNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jaduhṉ hänajty yhadsoy nebiä jajpän, nebiä tøøbä quiapxtáꞌaguiäbän. Yagjuøøby hajxy hänajty, jaꞌa hajxy hänajty jiiby häñaabiä tsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Coo jaꞌa Jesús jaduhṉ piaatä jaꞌa tiajhajxy, mänit hajxy yagjuøøyy. Mänitä tiaj miänaaṉ̃: ―Huung, tii højts jaduhṉ coo tøø xyhäyoow̱hix̱y coo tøø mmähmøꞌøy. Jiiby højts miic̈h nja wiꞌi yhøxtaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mänitä Jesús yhadsooyy: ―Tiic̈h mijts coo xyhøxtaꞌay. Nej, cab hajxy mnajuøꞌøyä cooc̈h tsipcøxp ndunaꞌañ maac̈h nDeedy tiǿjcänä. Haa caꞌa, Dióshøch jaduhṉ nDeedyhajpiä. ");
INSERT INTO mirNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero cabä tiajhajxy wyiinjuøøyy tii jaduhṉ coo tøø miänaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mänitä Jesús jiaanc̈h paduꞌubøjnä, piahädaacy jiiby Nazaret. Hix̱, jiaac mäbǿjcäp jaꞌa tiaj miädiaꞌagyhajxy hänajty. Y jaꞌa María, jiiby hänajty yajnøcxy yagjuøꞌøy quiopcooty nebiä yhuung hänajty tøø xyiꞌigy tøø miädiaꞌagy jiiby tsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeeꞌc‑habejt jaꞌa Jesús jaduhṉ; jaac wiinmahñdymejts jaduhṉ. Quiumaayy jaꞌa Dios jaduhṉ møødä tsaan møødä cuꞌug. ");
INSERT INTO mirNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Coo jaꞌa Juan hänajty tøø miøjjøøñä, jaꞌa Zacarías yhuung, mänit miägapxä jaꞌa Diósäm. Mänit tiägøøyy wädijpä hanidiuhm̱duum. Majmocxjomøjt jaꞌa Tiberio hänajty tøø guiobiernähaty. Jaꞌa Poncio Pilato hänajty tuum̱b gobernador Judeanaaxooty. Jaꞌa Herodes hänajty tuum̱b gobernador Galileanaaxooty. Jaꞌa piuhyaꞌay Felipe hänajty tuum̱b gobernador Itureanaaxooty møødä Traconitenaaxooty. Jaꞌa Lisanias hänajty tuum̱b gobernador Abilinianaaxooty. Jaꞌa Anás hänajty tuum̱b teedywiindsǿṉ møødä Caifás. ");
INSERT INTO mirNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mänitä Juan ñøcxøøyy maa jaꞌa Jordánmøjnøø mäwiingoṉän. Jaduhṉä tsaanguꞌug hänajty yajwiingapxøꞌøy coo hajxy ñäbétät, coo jaꞌa yhaxøøgwiinmahñdy hajxy ñajtshixǿꞌøwät, nebiä piojpä quiädieey hajxy jaduhṉ ñähwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","5","Tøjiajt jaduhṉ nebiä Isaías jaꞌa Diosquex̱ypä jecy jiahyyän: Jim̱ä jäyaꞌay tuꞌug yaax̱wädity hanidiuhm̱duum: “Najtshixøꞌøw jaꞌa mhaxøøgwiinmahñdy hajxy. Jaduhṉ jaꞌa mWiindsǿṉ hajxy hoy mhahíxät; jaduhṉ hajxy hoy mwiingudsähgǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nägøx̱iä jäyaꞌayhajxy jaduhṉ ñajuøꞌøwaꞌañ neby hajxy yajnähwaꞌadsǿøjät jaꞌa Diósäm.” ");
INSERT INTO mirNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Coo jaꞌa tsaanguꞌughajxy hänajty yajnäbetaꞌañíijäm jaꞌa Juángäm, jaduhṉ hajxy hänajty ñämaꞌayii: ―Haay møjcuꞌu, caj mijts hoguiuhdujt mnäꞌägä møødä. Paady hajxy jaduhṉ mhuuc näbetaam̱bä nebiä Dios hajxy jaduhṉ xquiaꞌa yajcumädów̱ät, túhm̱äts. ");
INSERT INTO mirNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hoy hajxy mwädítät neby jaduhṉ quiähxǿꞌøgät coo jaꞌa mhaxøøgwiinmahñdy hajxy hänajty tøø mnajtshixøøñä. Y cab hajxy jaduhṉ mmänáꞌanät: “Abrahámhøch nhaphajt ndeedyhajt, páadyhøch jaꞌa Dios xquiaꞌa yajcumädow̱aꞌañ.” Mänitä Dios hajxy xyajnähwáꞌadsät coo jaꞌa mhaxøøgwiinmahñdy hajxy mnajtshixǿꞌøwät; caꞌa jieꞌeguiøxpä coo Abraham hajxy mhaphajty mdeedyhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hoy hajxy mwädítät nebiä Dios hajxy jaduhṉ xquiaꞌa pädáꞌagät haxøøgtuum. Pøṉ hoy caꞌa wädijp, jaduhṉ mäwíinäts jeꞌe nebiä quepychaa caꞌa tøømhajpän. Piuxaam̱by hajxy jeꞌe; mänit hajxy ñoꞌogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mänitä tsaanguꞌughajxy miänaaṉ̃: ―Neby højts ndúnät coo højts hoy nwädítät. ");
INSERT INTO mirNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mänitä Juan yhadsooyy: ―Pøṉ camiixy metsc møød, ween tuꞌug ñäꞌä moꞌoy pøṉ quiamiixy caꞌa hijp. Jaanä jaduhṉduhm̱bä, pøṉ jøøꞌxypøcy møød, ween mioꞌoy pøṉ mähdiøjc caꞌa møød ―nøm̱ä Juan miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Näjeꞌe jaꞌa yajnähjuudiuutpähajxy miejtspä näbejpä. Mänitä Juan hajxy ñämaayy: ―Wiindsǿṉ, hǿjtsäts, neby højts jaduhṉ ndúnät. ");
INSERT INTO mirNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mänitä Juan yhadsooyy: ―Cab hajxy näꞌä tägøꞌøbä myagjuuñáxät. ");
INSERT INTO mirNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jaanä jaduhṉä policíahajxy näjeꞌe yajtøøbä. Mänitä Juan yhadsooyy: ―Cabä xädøꞌøñ pøṉ mbǿjcät näꞌä nagoobä. Y caj pøṉ mnähwaam̱bédät näꞌä nagoobä. Mjootcädáꞌagäp jaꞌa mmäjuhñdy hajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jaꞌa tsaanguꞌughajxy, jaduhṉ hajxy hänajty wyiꞌi yajtøy wyiꞌi yajtøꞌxy pø Cristo jeꞌe jaꞌa Juan. Paady hajxy hänajty wyiꞌi yajtøy, coo jaꞌa Cristo hajxy hänajty yhahix̱y. ");
INSERT INTO mirNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mänitä Juan yhadsooyy: ―Nøøháamhøch mijts chaa nyajnäbety. Pero xiic̈hä jäyaꞌay tuꞌug xjiaac pamiṉ̃. Jeꞌeds mijts mäbøcy xmioꞌowaam̱b jaꞌa Dioshespíritu. Xyajnähwaꞌads xyajcuhwaꞌadsaam̱b hajxy jaduhṉ. Maas møc cuhdujt jaayaꞌay miøødä quejeec̈h høøc̈h. Cábøc̈hä cuhdujt nnäꞌägä møødä ni weeṉ̃tiä maa jaayaꞌaguiøxpän. ");
INSERT INTO mirNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pøṉ jaꞌa haxøøgwiinmahñdy jaduhṉ caꞌa najtshixøꞌøwaam̱b, haxøøgtuum piädaꞌagaꞌañii. Cøjxtaꞌaxiøø jiiby chaac̈hpøgaꞌañ. Pero pøṉä homiädiaꞌagy pawädijp, cøjxtaꞌaxiøø hajxy jim̱ yhidaꞌañ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Madiuꞌu jaꞌa Juan jaꞌa cuꞌug hänajty yajwiinxiic yajwiingapxøꞌøy jaꞌa Diosmädiaꞌagy. Møc hänajty jiaanc̈h tehm̱ miädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mänitä Juan jaꞌa Herodes hoy yhojy, jaꞌa hänajty tuum̱bä gobernador. Paadiä Herodes yhojjä coo yhamdsoo puhyaꞌay jaꞌa tioꞌoxiøjc hänajty miøødtsänaayyä. Felipe jaꞌa piuhyaꞌay hänajty xiøhaty. Jiinä hänajty jiugyhatyñä. Herodías jaꞌa Felipe tioꞌoxiøjc hänajty xiøhaty. Madiuꞌu jaꞌa Herodes hänajty jiatcøꞌøy haxøøg. ");
INSERT INTO mirNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Coo jaꞌa Herodes jaduhṉ yhojjä, mänitä Herodes jaꞌa Juan yajtsuum̱ä. Hix̱, haxøøgwiinmahñdy jaꞌa Herodes hänajty miøød. ");
INSERT INTO mirNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Coo jaꞌa Juan hänajty quiaꞌa tsumyiinä, jim̱ä cuꞌug hänajty yajnäbety. Mänitä Jesús miejch näbejpä. Juan hänajty jeꞌe yajnäbetaam̱b. Jim̱ä Jesús hänajty Dyiospaꞌyaꞌaxy, mänitä tsajpootyp yhawaach. ");
INSERT INTO mirNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Mänitä Dioshespíritu jaꞌa Jesús ñägädaacy nebiä paloman. Mänit hoy yhäñaaxiøpy jaꞌa Jesús jaꞌa quiuhduum. Mänitä Dios jim̱ quiapxy tsajpootyp: ―NHuunghájpiøch miic̈h. Njaanc̈h tehm̱ chójpiøch miic̈h. Jootcujc‑høch jaduhṉ nnijiäwøꞌøyii maa miic̈hcøxpän. ");
INSERT INTO mirNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Hiiꞌxmajcjomøjt jaꞌa Jesús hänajty miøødä mänaabä tiägøꞌøyän yajnähixøøbiä. Jaꞌa cuꞌug jaduhṉ mänaaṉ cooc tyijy jaꞌa Jesús jaꞌa José hänajty tieedyhaty. Jaꞌa José yhap tieedyhajxy, jaduhṉä xiøøhajxy ñibianøcxä: Elí jaꞌa José tieedy xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Jaꞌa Elí tieedy, Matat jeꞌe xiøhajty. Jaꞌa Matat tieedy, Leví jeꞌe xiøhajty. Jaꞌa Leví tieedy, Melqui jeꞌe xiøhajty. Jaꞌa Melqui tieedy, Jana jeꞌe xiøhajty. Jaꞌa Jana tieedy, José jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jaꞌa José tieedy, Matatías jeꞌe xiøhajty. Jaꞌa Matatías tieedy, Amós jeꞌe xiøhajty. Jaꞌa Amós tieedy, Nahúm jeꞌe xiøhajty. Jaꞌa Nahúm tieedy, Esli jeꞌe xiøhajty. Jaꞌa Esli tieedy, Nagai jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Jaꞌa Nagai tieedy, Maat jeꞌe xiøhajty. Jaꞌa Maat tieedy, Matatías jeꞌe xiøhajty. Jaꞌa Matatías tieedy, Semei jeꞌe xiøhajty. Jaꞌa Semei tieedy, Josec jeꞌe xiøhajty. Jaꞌa Josec tieedy, Judá jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jaꞌa Judá tieedy, Joanán jeꞌe xiøhajty. Jaꞌa Joanán tieedy, Resa jeꞌe xiøhajty. Jaꞌa Resa tieedy, Zorobabel jeꞌe xiøhajty. Jaꞌa Zorobabel tieedy, Salatiel jeꞌe xiøhajty. Jaꞌa Salatiel tieedy, Neri jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Jaꞌa Neri tieedy, Melqui jeꞌe xiøhajty. Jaꞌa Melqui tieedy, Adi jeꞌe xiøhajty. Jaꞌa Adi tieedy, Cosam jeꞌe xiøhajty. Jaꞌa Cosam tieedy, Elmodam jeꞌe xiøhajty. Jaꞌa Elmodam tieedy, Er jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jaꞌa Er tieedy, Josué jeꞌe xiøhajty. Jaꞌa Josué tieedy, Eliezer jeꞌe xiøhajty. Jaꞌa Eliezer tieedy, Jorim jeꞌe xiøhajty. Jaꞌa Jorim tieedy, Matat jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Jaꞌa Matat tieedy, Leví jeꞌe xiøhajty. Jaꞌa Leví tieedy, Simeón jeꞌe xiøhajty. Jaꞌa Simeón tieedy, Judá jeꞌe xiøhajty. Jaꞌa Judá tieedy, José jeꞌe xiøhajty. Jaꞌa José tieedy, Jonam jeꞌe xiøhajty. Jaꞌa Jonam tieedy, Eliaquim jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Jaꞌa Eliaquim tieedy, Melea jeꞌe xiøhajty. Jaꞌa Melea tieedy, Mena jeꞌe xiøhajty. Jaꞌa Mena tieedy, Matata jeꞌe xiøhajty. Jaꞌa Matata tieedy, Natán jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jaꞌa Natán tieedy, David jeꞌe xiøhajty. Jaꞌa David tieedy, Isaí jeꞌe xiøhajty. Jaꞌa Isaí tieedy, Obed jeꞌe xiøhajty. Jaꞌa Obed tieedy, Booz jeꞌe xiøhajty. Jaꞌa Booz tieedy, Sala jeꞌe xiøhajty. Jaꞌa Sala tieedy, Naasón jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Jaꞌa Naasón tieedy, Aminadab jeꞌe xiøhajty. Jaꞌa Aminadab tieedy, Admin jeꞌe xiøhajty. Jaꞌa Admin tieedy, Esrom jeꞌe xiøhajty. Jaꞌa Esrom tieedy, Fares jeꞌe xiøhajty. Jaꞌa Fares tieedy, Judá jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jaꞌa Judá tieedy, Jacob jeꞌe xiøhajty. Jaꞌa Jacob tieedy, Isaac jeꞌe xiøhajty. Jaꞌa Isaac tieedy, Abraham jeꞌe xiøhajty. Jaꞌa Abraꞌam tieedy, Taré jeꞌe xiøhajty. Jaꞌa Taré tieedy, Nacor jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Jaꞌa Nacor tieedy, Serug jeꞌe xiøhajty. Jaꞌa Serug tieedy, Ragau jeꞌe xiøhajty. Jaꞌa Ragau tieedy, Peleg jeꞌe xiøhajty. Jaꞌa Peleg tieedy, Heber jeꞌe xiøhajty. Jaꞌa Heber tieedy, Sala jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Jaꞌa Sala tieedy, Cainán jeꞌe xiøhajty. Jaꞌa Cainán tieedy, Arfaxad jeꞌe xiøhajty. Jaꞌa Arfaxad tieedy, Sem jeꞌe xiøhajty. Jaꞌa Sem tieedy, Noé jeꞌe xiøhajty. Jaꞌa Noé tieedy, Lamec jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Jaꞌa Lamec tieedy, Matusalén jeꞌe xiøhajty. Jaꞌa Matusalén tieedy, Enoc jeꞌe xiøhajty. Jaꞌa Enoc tieedy, Jared jeꞌe xiøhajty. Jaꞌa Jared tieedy, Mahalaleel jeꞌe xiøhajty. Jaꞌa Mahalaleel tieedy, Cainán jeꞌe xiøhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Jaꞌa Cainán tieedy, Enós jeꞌe xiøhajty. Jaꞌa Enós tieedy, Set jeꞌe xiøhajty. Jaꞌa Set tieedy, Adán jeꞌe xiøhajty. Jaꞌa Adán, Dios jaduhṉ cunuuꞌx pädaac. ");
INSERT INTO mirNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jim̱ä Jesús hänajty maa jaꞌa Jordánmøjnøøjän. Miøødä Jesús jaꞌa Dioshespíritu hänajty. Mänitä Jesús wioonøcxä hanidiuhm̱duum jaꞌa Dioshespíritu. ");
INSERT INTO mirNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","3","Jim̱ jaduhṉ yhijty juxychäguiꞌxxøø. Hayuu hänajty ñäꞌägä hity. Jim̱ä Jesús hänajty jia jøjcapxøꞌøwaꞌañii jaꞌa møjcuꞌugóngäm coog tyijy cu tiuꞌudägooyy. Mänitä Jesús yuu piaatä. Mänitä Jesús ñämaayyä jaꞌa møjcuꞌugóngäm: ―Pø tøy miic̈h jaꞌa Dios xyHuunghaty, yajwaꞌañguioj yøꞌø tsaa nebiä tsajcaaguiän ―ja jøjcapxøꞌøwaaṉä jaꞌa Jesús jaduhṉ, paady jaduhṉ ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mänitä Jesús yhadsooyy: ―Jaduhṉä Diosmädiaꞌagy miänaꞌañ: “Caꞌa quiaaguiä jaꞌa jäyaꞌayhajxy miäjugyhádät hädaa yaabä naax̱wiin; møødä Diosmädiaꞌagy hajxy miäjugyhádät.” ");
INSERT INTO mirNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mänitä møjcuꞌugong jaꞌa Jesús wioonøcxy maa jaꞌa tuṉ jaanc̈h tehm̱ quiøxpän. Mänitä Jesús tuꞌhabaquiä yajnäheebøøyyä jaꞌa naax̱ jaꞌa cajpt cøx̱iä hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Mänitä Jesús ñämaayyä: ―Høøc̈h njeꞌe yøꞌøduhṉ cøx̱iä mäduhṉ̃tiä jii quiähxøꞌøgy. Yajxóṉ yøꞌø cajpt jaduhṉ. Møj jaanc̈h jaꞌa jäyaꞌayhajxy, jaꞌa hajxy xiiby tsänaabiä. Høøc̈h jaduhṉ cøx̱iä tøø xquiøx̱y cøꞌødägøꞌøy. Nmǿødhøch jaꞌa cuhdujt jaduhṉ cooc̈h hopiøṉä nyajcøꞌødägǿꞌøwät. Y cooc̈h miic̈h jaduhṉ xwyiingudsähgǿꞌøwät, mänítøch miic̈h ngøx̱y móꞌowät. ");
INSERT INTO mirNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mänitä Jesús yhadsooyy: ―Jaduhṉä Diosmädiaꞌagy miänaꞌañ: “Mwiingudsähgǿꞌøwäp jaꞌa Dios; jeꞌeduhṉ mWiindsøṉhádäp. Cab jaduhṉ wiingpä mwiindsøṉhádät.” ");
INSERT INTO mirNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mänitä møjcuꞌugong jaꞌa Jesús wioonøcxy jim̱ Jerusalén‑cajptooty. Mänit miøødwiimbejty møjtsajtøjcuhduum. Mänitä møjcuꞌugong miänaaṉ̃: ―Pø tøy miic̈h jaꞌa Dios xyHuunghaty, cuhdøpxnax̱ jiiby naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Caj miic̈h nej mjádät. Jaduhṉ jiiby myiṉ̃ maa jaꞌa Diosmädiaꞌaguiän: Dios haneꞌemaam̱b jaꞌa mioonsähajxy tsajpootypä coo miic̈h xcwieendähádät. ");
INSERT INTO mirNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Xchehṉhidaam̱b miic̈h hajxy jaduhṉ nej miic̈h tsaajooty jaduhṉ mgaꞌa cuhnébät. ");
INSERT INTO mirNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mänitä Jesús yhadsooyy: ―Jaduhṉä Diosmädiaꞌagy miänaam̱bä: “Cabä Dios mjøjcapxǿꞌøwät, jaꞌa mWiindsøṉhajpiä.” ");
INSERT INTO mirNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Coo jaꞌa møjcuꞌugong miädiaꞌagy hänajty quiaꞌa jøjtägøꞌøwáaṉäxä, mänit ñähgueecnä. ");
INSERT INTO mirNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mänitä Jesús yhädaactägajch Galileanaaxooty. Diosmäjaa hänajty miøød. Mänitä mädiaꞌagy wiädijty jaꞌa Jesúscøxpä wiinduhm̱yhagajpt. ");
INSERT INTO mirNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Cajpt‑cajpt jaꞌa Jesús hänajty wiädity yajnähixøøbiä tsajtøgooty. Mänitä Jesús quiumaayyä jaꞌa jäyaꞌayhajxy nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Mänitä Jesús miejch Nazaret maa hänajty tøø miuutsc‑hatiän. Coo jaꞌa pooꞌxxiøø yhabaaty, mänit tiägøøyy tsajtøgooty. Jaduhṉ hänajty ñäꞌägä cuhdujthaty jaꞌa pooꞌxxiøøjooty. Mänit ñämaayyä coo jaꞌa Diosmädiaꞌagy quiápxät. Coo tiänaayyøꞌcy majiäyaꞌawyiinduum, ");
INSERT INTO mirNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","mänitä libro miooyyä, jaꞌa Isaías hänajty jegyhajty tøø jiáayäbä, jaꞌa Diosquex̱ypä. Mänitä libro quiejtøøyy. Mänit tiägøøyy capxpä: ");
INSERT INTO mirNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Jaꞌa Dioshespíritøch nmøød. Jeꞌec̈h tøø xpiädaꞌagy cooc̈hä häyoobäyaꞌayhajxy nhawáaṉät coo hajxy yaghoyøꞌøwaꞌañii. Jadúhṉhøch tøø xwyiinguex̱y cooc̈hä jäyaꞌayhajxy nhawáaṉät nebiä piojpä quiädieey hajxy ñähwaꞌads quiuhwáꞌadsät, nebiä Diosmädiaꞌagy hajxy pedyii quiudiúnät. ");
INSERT INTO mirNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tøø jaduhṉ yhabaady coo jaꞌa Dios jaꞌa mayhajt jaduhṉ tiunaꞌañ møj may. ");
INSERT INTO mirNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mänitä Jesús jaꞌa libro yhabädijnä. Mänitä tsajtøjyohbiä jaduhṉ miooyyä. Mänitä Jesús yhäñaaguiädaacy. Wyiꞌi wyiinheeꞌppejpy jaꞌa cuꞌug jaꞌa Jesús hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mänitä Jesús miänaaṉ̃: ―Tøø jaꞌa Diosmädiaꞌagy tiøjiaty nébiøch tøø ngapxiän. ");
INSERT INTO mirNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mänitä cuꞌughajxy yagjuøøyy coo jaꞌa Jesús hänajty hoy tøø quiapxy. Hoy jaꞌa Jesús hajxy hänajty ñänøm̱y: ―Maa yøꞌø capxy yøꞌø mädiaꞌaguiädaꞌa tøø yhuug habøjpä. Haa caꞌa, jaꞌa José yhuung yøꞌøduhṉ, cabä ―nøm̱ hajxy hänajty miänaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mänitä Jesús miänaaṉ̃: ―Jadúhṉhøch mijtsädaꞌa xñämaꞌawaꞌañ: “Huuc yajcähxøꞌøg jaꞌa hijxtahṉd yaa maa jaꞌa mhamdsoo cajptän nej miic̈h jim̱ tøø mhuuc yajcähxøꞌpän jim̱ Capernaum.” ");
INSERT INTO mirNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mänitä Jesús jiaac mänaaṉ̃: ―Pero høøc̈h jaduhṉ mänaam̱b, jaꞌa Diosquex̱ypähajxy, cabä miädiaꞌagyhajxy miäbøgáaṉäxä maa yhamdsoo cajpthajxiän. Tehm̱ tiøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Coo jaꞌa Elías hänajty jegyhajty wiädity Diosmädiaꞌagy‑yajwaꞌxpä yaa Israelpä‑naaxooty, tägøøgjomøjtä cupc caj ñäꞌägädä tuuyy. Chaadsä yuuxøø jiaanc̈h tehm̱ jiajtä. Mänitä Dios jaꞌa Elías quiejxy maa jaꞌa cajpt hänajty xiøhatiän Sarepta, jim̱ Sidón mäwiingóṉ. Jim̱ä Elías jaꞌa yaamgtoꞌoxy hoy tuꞌug piuhbety. Pero jaꞌa yaamgtoꞌoxyhajxy yaabä, cab hajxy yajnäguejxä, hoy hajxy hänajty jia nämayyä. ");
INSERT INTO mirNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jaanä jaduhṉduhm̱bä, jii haxøøgpaꞌammøødpähajxy hänajty nämay yaa Israelpä‑naaxooty mänaa jaꞌa Eliseo hänajty yaa wiäditiän Diosmädiaꞌagy‑yajwaꞌxpä. Pero cabä piaꞌamhajxy jaduhṉ yajnajx yajmáayyäxä. Jagooyyä Naamán piaꞌam nidiuhm̱ ñajxy miaayy, y jäguem̱ hänajty chänaꞌay jim̱ Sirianaaxooty, caꞌa yaajä. ");
INSERT INTO mirNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Coo jaꞌa jäyaꞌayhajxy jaduhṉ miädooyy nebiä Jesús miänaaṉ̃än, jaꞌa hajxy hänajty jiiby tsajtøgootypä, cøjx hajxy jiootmaꞌady. ");
INSERT INTO mirNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mänitä Jesús hajxy ñädänaayyøꞌcy. Mänitä Jesús hajxy jim̱ yajnøcxy tuṉguhduum jim̱ cajptpaꞌa. Jim̱ä Jesús hajxy hänajty quiuhjuijpnaxaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero cabä Jesús hajxy nej ñäꞌä tuuṉ̃. Jaduhyyä jeꞌe yajyohñajxy majiäyaꞌayhagujc. Mänit jim̱ wyiimbijnä. ");
INSERT INTO mirNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mänitä Jesús ñøcxy Capernaum, jim̱ Galileanaaxooty. Coo jaꞌa pooꞌxxiøø yhabaaty, mänitä Jesús jaꞌa cuꞌug tiägøøyy yajnähixøøbiä tsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jaduhṉä Jesús hänajty yajnähixøꞌøy nebiä capxtaꞌagypiän, paadiä cuꞌughajxy hänajty yagjuøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jiibiä jäyaꞌay hänajty tuꞌug jaꞌa møjcuꞌubaꞌammøødpä. Mänit møc yaax̱y: ");
INSERT INTO mirNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Ween højts nhity. Tii jaduhṉ mhøxtaaby maa højtsän. Nej, xyajcuhdägoyyaam̱b højtsä. Nhíx̱yhøch miic̈h. Jesús mxøhaty. Nazaret mdsooñ. Nnajuǿøbiøch jaduhṉ coo miic̈hä Dios xyHuunghaty. ");
INSERT INTO mirNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mänitä Jesús jaꞌa møjcuꞌu yhojy: ―Hamóṉ, juaꞌads jim̱ maa yøꞌø craajän. Mänitä mähdiøjc quiädaayy naax̱wiin maa jaꞌa jäyaꞌay wyiinduumhajxiän. Mänitä møjcuꞌu piädsøøm̱y. Cabä mähdiøjc nej jiajnä. ");
INSERT INTO mirNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mänitä jäyaꞌayhajxy nägøx̱iä chähgøøyy. Mänit hajxy ñiñämaayyä: ―Høxtahm̱ds jaduhṉ quiapxy miädiaꞌagy. Cuhdujtmøødädaꞌa yøꞌøduhṉ maa jaꞌa møjcuꞌuhajxiän. Jaanc̈h pädsøøm̱b hajxy jaduhṉ coo hajxy ñämaꞌayii coo hajxy piädsǿm̱ät. ");
INSERT INTO mirNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mänitä mädiaꞌagy tiägøøyy wädijpä jaꞌa Jesúscøxpä jim̱ wiinduhm̱yhagajpt. ");
INSERT INTO mirNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mänitä Jesús piädsøøm̱y tsajtøgooty. Mänit ñøcxy maa jaꞌa Simón tiøjc‑hajxiän. Jiibiä Simón miøꞌødhoc hänajty piaꞌamgoꞌnaꞌay tomiøød. Mänitä Jesús hajxy miänuuꞌxtaacy coo jaꞌa toy ween yajtǿjtsäxä. ");
INSERT INTO mirNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mänitä Jesús jaꞌa paꞌamjäyaꞌay wyiinguwoodsøøyy. Mänit miänaaṉ̃ coo jaꞌa toy ween ñähwaꞌac̈hii. Mänitiä jaꞌa toy jiaanc̈h tøjtsnä. Mänitä paꞌamjäyaꞌay piädøꞌcy. Mänit tiägøøyy mayhajt‑tuum̱bä maa jaꞌa Jesúshajxiän. ");
INSERT INTO mirNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Coo chuujøøyy, mänitä paꞌamjäyaꞌayhajxy may wioomejtsä maa jaꞌa Jesúsän. Madiuꞌu jaꞌa paꞌam hajxy hänajty miøødä. Mänitä Jesús nägøx̱iä quiøꞌønähgajpy tuꞌugjaty‑tuꞌugjaty. Jaduhṉä piaꞌamhajxy ñähwaats quiuhwaatsä. ");
INSERT INTO mirNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nämay hajxy hänajty miøjcuꞌubaꞌammøødä. Coo jaꞌa møjcuꞌuhajxy piädsøøm̱y, mänit hajxy yhayaax̱y: ―Dios miic̈h xyHuunghajp. Mänitä Jesús jaꞌa møjcuꞌu yhojy. Cab hajxy ñäꞌägä yajcapxä. Hix̱, ñajuøøby hajxy hänajty coo jaꞌa Jesús jieꞌejä jaꞌa Cristo, jaꞌa Dios tøø quiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Coo jiobøøyy, mänitä Jesús ñøcxy cajptpaꞌa hanidiuhm̱duum. Jim̱ä cuꞌug jaꞌa Jesús hajxy hänajty yhøxtaꞌay. Coo hajxy piaaty, mänit hajxy jia yajmähmøꞌøwaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mänitä Jesús miänaaṉ̃: ―Páadyhøch jaꞌa Dios yaa tøø xquiex̱y hädaa yaabä naax̱wiin cooc̈h wiinduhm̱yhagajpt nwädítät, cooc̈h nyajwiingapxǿꞌøwät coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaaṉnä. Paady, cábøch yaa nmähmøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jaduhṉä Jesús hänajty wiädity yajnähixøøbiä jim̱ Galileanaaxooty. Wiinduhm̱yc̈hajtøjc hänajty wiädity. ");
INSERT INTO mirNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mänitä Jesús hänajty jim̱ tiänaꞌay Genesaretmejypiaꞌa. Mänitä jäyaꞌayhajxy may miejch Diosmädiaꞌagymiädoobä. Nøꞌøc̈hpän jaꞌa jäyaꞌayhajxy hänajty tiänaꞌay maa jaꞌa Jesúsän. Cabä hawaꞌadspä hänajty maa. ");
INSERT INTO mirNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mänitä Jesús barco yhijxy metsc jim̱ mejypiaꞌa. Yajwaꞌadsä barco hänajty. Jim̱ä cubarcohajxy hänajty quiuhjuijptsaabiujy mäwiingóṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mänitä Jesús jaꞌa barco tuꞌug yajpejty jaꞌa Simón jieꞌe. Mänitä Jesús jaꞌa Simón ñämaayy coo barco weenä yajmäwiingónät wiinduum. Jim̱ä Simón jaꞌa Zebedeo yhuunghajxy hänajty miøødä nämetscä. Jacobo hänajty tuꞌug xiøhaty. Tuꞌug hänajty xiøhajpä Juan. Mänitä Jesús yhäñaaguiädaacy barcojooty. Mänitä cuꞌughajxy tiägøøyyä yajwiingapxǿøyyäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Coo jaꞌa Jesús jaduhṉ quiapxpädøøyy, mänitä Simón ñämaayyä: ―Yajmøjyoꞌoy jaꞌa mbarco ja ween com̱duum. Jiibiä mguhjuijptsaay hajxy mbädáꞌagät. ");
INSERT INTO mirNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mänitä Simón yhadsooyy: ―Wiindsǿṉ, tuꞌtsuhm̱ højts tøø nja cuhjuipy. Cab højts tii tøø nnäꞌägädä mach. Pero cooc̈h miic̈h jaduhṉ tøø xñämaꞌay, nǿcxyhøch nhuuc jaac juipy. ");
INSERT INTO mirNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Coo hajxy jaduhṉ jiaanc̈h cudiuuṉ̃, mänitä hacx hajxy may miajch, høxtä tsøøm̱gøøꞌtsä jaꞌa cuhjuijptsaay jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mänitä miäguꞌughajpä hajxy miøjyeem̱y, jaꞌa hajxy hänajty wiingbarcojootypä, coo hajxy miṉ piuhbedyii. Mänitä barco hajxy metsc yaghujch. Ja weenjaty hajxy quiaꞌa mäguiiṉä. ");
INSERT INTO mirNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Mänit hajxy yagjuøøyy coo hacx hajxy may miajch. Mänit hajxy ñajuøøyy coo jaꞌa Jesús jaꞌa hijxtahṉd jaduhṉ yajcähxøꞌcy hoy‑yagjuøøñä. Mänitä Simón Pedro jaꞌa Jesús wyiinjijcädaacy. Mänit miänaaṉ̃: ―Wiindsǿṉ, cábøch miic̈h hawiinmats xmiøødhídät. Cábøch hoguiuhdujt nmøødä. Mänitä Jesús jaꞌa Simón ñämaayy: ―Caꞌa mdsähgøꞌøy. Wiingtuuṉg mbanøcxáaṉnäp. Myajwiingapxøꞌøwaam̱biä cuꞌug jaꞌa Diosmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mänitä barco hajxy yajmøjyohbiejty mejypiaꞌa. Mänitä Jesús hajxy piaduꞌubøjcy. Ñähgueecy hajxy jaduhṉ cøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mänitä Jesús wiingcajpt miejch. Jim̱ä jäyaꞌay hänajty tuꞌug haxøøgpuꞌudsmøød. Coo jaꞌa Jesús yhijxä, mänit wyiinjijcädaacä. Mänit ñämaayyä: ―Wiindsǿṉ, miic̈h nnämaaby, høøc̈h nbuꞌuds yajtsóocäc. ");
INSERT INTO mirNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mänitä Jesús jaꞌa mähdiøjc ñähdooṉ̃. Mänitä Jesús miänaaṉ̃: ―Tøø jaduhṉ mdsoꞌogy. Tuuṉä jaꞌa Jesús jaduhṉ ñäꞌä mänaaṉ̃, mänitiä jaꞌa mähdiøjc choocy. ");
INSERT INTO mirNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mänitä Jesús miänaaṉ̃: ―Caj pøṉ mhawáaṉät coo tøø mdsoꞌogy. Nøcx tuꞌudaꞌaquiä maa jaꞌa teediän. Jim̱ä xädøꞌøñ mguyoxǿꞌøwät nebiä Moisés jecy yhanehm̱iän. Paadiä xädøꞌøñ mguyoxǿꞌøwät, jaduhṉä hijxtahṉd myajcähxǿꞌøgät coo tøø mdsoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mänitä mädiaꞌagy hajxy yajwädijty jäguem̱baady cooc jaꞌa Jesús jaꞌa hijxtahṉd tøø yajcähxøꞌøgy. Mänitä jäyaꞌayhajxy maas may jiaac hamugøøyy maa jaꞌa Jesúsän. Jaꞌa Jesús miädiaꞌagy hajxy hänajty yhamädoow̱hidáaṉäp. Møødä piaꞌamhajxy hänajty yajnaxáaṉäxä. ");
INSERT INTO mirNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Coo jaꞌa jäyaꞌayhajxy hänajty wyiꞌi yhamugøꞌøy maa jaꞌa Jesúsän, paadiä Jesús hanidiuhm̱duum ñøcxy Diospaꞌyaax̱pä. ");
INSERT INTO mirNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wiinghoocä Jesús jaꞌa cuꞌug hänajty yajwiingapxøꞌøy. Jaanc̈h tehm̱ yhujts jaꞌa tøjc hänajty. Jiibiä fariseoshajxy hänajty yhäñaꞌay møødä ley‑yajnähixøøbiähajxy. Wiinduhm̱yhagajpt hajxy hänajty chooñ Galileanaaxooty møødä Judeanaaxooty møødä Jerusalén. Miøødä Jesús jaꞌa Diosmäjaa hänajty nebiä paꞌam jaduhṉ yajnáxät. ");
INSERT INTO mirNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mänitä cøꞌømucypiä tecymiucypiä tuꞌug quiøømiejtsä tsaajiooty. Jiiby hajxy jia yajtøjtägøꞌøwaaṉ̃ maa jaꞌa Jesús hänajty miädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero jaanc̈h tehm̱ yhujts jaꞌa tägøꞌøwøødiaact hänajty. Mänit hajxy ñiñämaayyä coo hajxy jim̱ yaghawaꞌadsaꞌañ tøjnähgøxp. Mänit paꞌamjäyaꞌay hajxy quiuhdøøñajxy tøjcuhduum maa jaꞌa Jesús hänajty piaꞌtänaꞌayän. ");
INSERT INTO mirNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Coo jaꞌa Jesús ñajuøøyy coo jaꞌa miädiaꞌagy hänajty miäbøgáaṉäxä, mänitä cøꞌømucypiä tecymiucypiä ñämaayyä: ―Mäguꞌughajpä, miic̈h nnämaaby coo jaꞌa mbojpä mgädieey tøø xñähwaꞌac̈h tøø xquiuhwaꞌac̈h. ");
INSERT INTO mirNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mänitä fariseoshajxy quiopcooty tiägøøyy mädiaactaacpä møødä ley‑yajnähixøøbiä: “Tii yøꞌø craa jaduhṉ coo miänaꞌañ. Capxtägooby yøꞌøduhṉ. Jagooyyä Dios jaꞌa cuhdujt jaduhṉ miøødä coo jaꞌa pojpä cädieey miéeꞌxät.” ");
INSERT INTO mirNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mänitä Jesús ñajuøøyy nebiaty hajxy hänajty miädiaactaꞌagy quiopcooty. Mänit miänaaṉ̃: ―Tii hajxy jaduhṉ coo mmädiaactaꞌagy mgopcooty. ");
INSERT INTO mirNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nej, maas páquiøch yøꞌø mähdiøjc nnämáꞌawädä: “Tøøc̈h miic̈h mbojpä mgädieey nmämeeꞌxy”, tøgä maas páquiøch jaduhṉ nnämáꞌawädä “Tänaayyøꞌøg, yoꞌoyøꞌøg.” ");
INSERT INTO mirNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mhuug híxäp hajxy nébiøch hädaa mähdiøjc nyajmøcpøgaꞌañ. Jaduhṉ hajxy mnajuǿꞌøwät cooc̈hä cuhdujt jaduhṉ nmøødä hädaa yaabä naax̱wiin cooc̈hä pojpä cädieey jaduhṉ nméeꞌxät, høøc̈h jaꞌa Diosquex̱ypä. Mänitä mähdiøjc ñämaayyä: ―Tänaayyøꞌøg; widsøꞌøg yøꞌø mdsaay; nøcxnä maa jaꞌa mdøjcän. ");
INSERT INTO mirNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mänitiä jaꞌa mähdiøjc jaduhṉ tiänaayyøꞌcy maa jaꞌa wyiinduumhajxiän. Mänitä tsaay wyidsøꞌcy maa hänajty tøø quioꞌnaꞌayän. Mänit ñøcxnä maa jaꞌa tiøjcän. Mänitä Dios Dioscujúꞌuyäp miooyy. ");
INSERT INTO mirNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mänit hajxy nägøx̱iä jiaanc̈h tehm̱ yagjuøøyy. Jaanc̈h tehm̱ chähgøøyy hajxy jaduhṉ. Mänitä Dios Dioscujúꞌuyäp hajxy miooyy. Mänit hajxy miänaaṉ̃: ―Tøødsä hoy‑yagjuǿøñäbä hajxy nhíjxäm jädaꞌa. ");
INSERT INTO mirNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mänitä Jesús wyiimbijnä. Mänitä jäyaꞌay tuꞌug yhijxy, jaꞌa Levíhajpä. Jim̱ä Leví hänajty yhäñaꞌay maa hajxy hänajty yajnähjuudiuꞌudiän. Jeꞌe jaꞌa Leví hänajty tiuuṉghajpy. Mänitä Jesús jaꞌa Leví ñämaayy: ―Høøc̈h pamíiṉäc. ");
INSERT INTO mirNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mänitä Leví tiänaayyøꞌcy, pianøcxy jaꞌa Jesús. Cøjx jaduhṉ ñähgueꞌegy mäduhṉ̃tiä hänajty miøødä. ");
INSERT INTO mirNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mänitä Leví jaꞌa xøø yagjajtä maa jaꞌa tiøjcän jaꞌa Jesúscøxpä. Jiibiä yajnähjuudiuutpähajxy hänajty nämay miägaabiä møødä wiinghänaꞌc‑hajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jiibiä fariseoshajxy hänajty miägaabiä møødä ley‑yajnähixøøbiähajxy. Mänitä Jesús jiamiøødhajxy ñämaayyä jaꞌa fariseoshajxy: ―Tii yøꞌø yajnähjuudiuutpä hajxy coo mmøødcay coo mmøødhuꞌugy. Haa caꞌa, jueꞌe yøꞌø hajxy, pojpäyaꞌay cädieejiäyaꞌayhajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mänitä Jesús yhadsooyy: ―Pøṉ møc, cab hajxy yajtsooyøꞌøy. Pøṉ paꞌammøød, jeꞌeds hajxy yajtsooyøøby. ");
INSERT INTO mirNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jaduhṉ mäwíinäts høøc̈h jaꞌa pojpäyaꞌay cädieejiäyaꞌay nyajnähwaꞌac̈h nyajcuhwaꞌac̈h. Pero mijts jaduhṉ mänaam̱b cooc tyijy pojpä cädieey hajxy mgaꞌa møødä. Páadyhøch mijts waam̱b ngaꞌa nämaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mänitä Jesús hajxy ñämaayy: ―Jaꞌa Juan jiamiøødhajxy, nax̱y hajxy yhity hayuu; nax̱iä Dios hajxy piaꞌyaꞌaxy. Jaduhṉä fariseos jiamiøødhajxy nax̱y quiudiuum̱bä. Pero miic̈h mjamiøødhajxy, näꞌä caaby näꞌä huucp hajxy jeꞌe. Cab hajxy yhity hayuu. Cab jaduhṉ yhoyyä. ");
INSERT INTO mirNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mänitä Jesús miänaaṉ̃: ―Coo jaꞌa pøc huꞌug maa jiadyii, cabä woybä wichpähajxy hayuu wyiimbity. Jaduhṉ mäwíinäts høøc̈h nebiä jamiøꞌødän jaꞌa pøgaam̱bä. Páadyhøch njamiøødhajxy hayuu quiaꞌa hity. ");
INSERT INTO mirNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Habaadáaṉnäp jaduhṉ cooc̈h yaa ndsoonaaṉnä. Mänítøch njamiøødhajxy yhidaꞌañ hayuu mäbøcypiä. ");
INSERT INTO mirNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mänitä Jesús jadähooc wyiingapxǿøguiumbä: ―Cabä tucwit pøṉ yhagøyøꞌøy jem̱ywyithaam. Cǿødsäp jaꞌa jem̱ywyit jaduhṉ; cab jaduhṉ ñibiaadaꞌañii møødä tucwit. ");
INSERT INTO mirNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jaanä jaduhṉduhm̱bä, cabä jem̱yvyino pøṉ quiudemøꞌøy jaꞌa tucwajhacxujiooty. Cǿødsäp jaꞌa tucwajhacxuy jaduhṉ; høxyógäp jaꞌa vino jaduhṉ. Haagä tägóyyäp jaꞌa tucwajhacxuy jaduhṉ møødä vino. ");
INSERT INTO mirNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pero jiibiä jem̱yvyino hajxy quiudemøꞌøy jaꞌa jem̱ywiajhacxujiooty. Cab jaduhṉ tii miaꞌady, ni jaꞌa jem̱yvyino, ni jaꞌa jem̱ywiajhacxuy. ");
INSERT INTO mirNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Cabä jem̱yvyino pøṉ hoyhuucnä jiäwøꞌøy coo jaꞌa vino hänajty tøø yhuꞌugy jaꞌa tehm̱ jiecypiä. “Maas hoyhuucnä jaꞌa jecyvyino” ―nøm̱ä jäyaꞌayhajxy miänaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mänitxøø jaꞌa Jesúshajxy hänajty wiädity trigoniꞌibyquiujc. Pooꞌxxiøøjooty hänajty jeꞌe. Mänitä jiamiøød jaꞌa trigo hajxy tiøjy. Mänit hajxy ñähxajtstuuty. Mänit hajxy jiøøꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mänitä fariseoshajxy näjeꞌe miänaaṉ̃: ―Cabä cuhdujt jaduhṉ myiṉ̃ coo hajxy jaduhṉ mdúnät jaꞌa pooꞌxxiøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mänitä Jesús miänaaṉ̃: ―Nej, cahnä jaꞌa Diosmädiaꞌagy hajxy mgapxiä nebiä David tiuuṉ̃ coo hänajty yähoꞌogyii møødä jiamiøødhajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mänit hajxy jiiby tiägøøyy tsajtøgooty. Mänitä tsajcaagy hajxy quiaayy jaꞌa teedyhajxy hänajty tøø quiuyoxǿꞌøyäbä. Cabä David jaꞌa cuhdujt hajxy hänajty miøødä coo hajxy jaduhṉ quiáyät. Jagooyyä teedy jaꞌa cuhdujt hajxy hänajty miøødä coo hajxy quiáyät. ");
INSERT INTO mirNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Høøc̈h jaꞌa Diosquex̱ypä, jadúhṉhøch høøc̈hpä, nmǿødhøch jaꞌa cuhdujt jaduhm̱bä høxtä maa jaꞌa pooꞌxxiøøbaadiän ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jatuꞌugpä pooꞌxxiøøjootypä jaꞌa Jesús tiägøøyy tsajtøgooty. Mänit tiägøøyy yajwiingapxøøbiä. Jiibiä mähdiøjc hänajty tuꞌug haduꞌugcøꞌødøꞌøds jaꞌa yhahooyhaampiä. ");
INSERT INTO mirNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jiibiä fariseoshajxy hänajty tiänaꞌay møødä ley‑yajnähixøøbiähajxy. Jiibiä Jesús hajxy hänajty wyiꞌi yheeby. Yhijxmajchp jaꞌa Jesús hajxy hänajty pø yajnaxaam̱biä paꞌam jaꞌa pooꞌxxiøøjooty. Yhøxtaabiä fariseos jaꞌa wiinmahñdy hajxy hänajty nebiä Jesús hajxy yajtsumǿøjät coo jaꞌa paꞌamjäyaꞌay hänajty yajmøcpøgyii jaꞌa pooꞌxxiøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jaꞌa Jesús, ñajuøøby hänajty jeꞌe nebiä fariseoshajxy hänajty tiajy miay. Mänitä Jesús jaꞌa mähdiøjc ñämaayy jaꞌa haduꞌugcøꞌødøꞌødspä: ―Tänaayyøꞌøg, miṉ huuc tänaꞌaw cujc. Mänit jiaanc̈h tänaayyøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mänitä Jesús ñämaayy jaꞌa fariseoshajxy: ―Mijts nmäyajtøøby, nej, yejpiä Dios jaꞌa cuhdujt jaduhṉ coo hajxy hoy ndúuṉämät jaꞌa pooꞌxxiøøjootiä, tøgä yejpiä cuhdujt coo hajxy haxøøg ndúuṉämät jaꞌa pooꞌxxiøøjootiä. Jaanä jaduhṉduhm̱bä, nej, yejpiä Dios jaꞌa cuhdujt coo jaꞌa jäyaꞌay hajxy nyajnähwáatsämät jaꞌa pooꞌxxiøøjootiä, tøgä yejpiä cuhdujt coo jäyaꞌay hajxy nyajcuhdägóoyyämät jaꞌa pooꞌxxiøøjootiä. ");
INSERT INTO mirNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mänitä Jesús jaꞌa jäyaꞌay wyiinheeꞌppejty nägøx̱iä. Mänitä Jesús jaꞌa mähdiøjc ñämaayy: ―Xajtøw̱ yøꞌø mgøꞌø. Mänitä quiøꞌø jiaanc̈h xajtøøyy. Mänitä quiøꞌø hoy jiajnä. ");
INSERT INTO mirNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mänitä fariseoshajxy jiootmaꞌty hoyhoy. Mänit hajxy quiojyquiapxyhajty nebiä Jesús hajxy tiunaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Cujaboomgumaax̱c jaꞌa Jesús ñøcxy tuṉguhduum. Tuꞌtsuhm̱ä Tieedy piaꞌyaax̱y. ");
INSERT INTO mirNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Coo jiobøøyy, mänitä jiamiøødhajxy miøjyaax̱y. Mänitä nämajmetspähajxy wyiimbiiw̱ä coo jaꞌa Diosmädiaꞌagy hajxy yajwáꞌxät. ");
INSERT INTO mirNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jaduhṉdsä nämajmetspähajxy hänajty xiøhaty: Simón, jaꞌa Jesús hänajty tøø yajxøbétiäbä Pedro, møødä piuhyaꞌay Andrés, møødä Jacobo, møødä Juan, møødä Felipe, møødä Bartolomé, ");
INSERT INTO mirNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","møødä Mateo, møødä Tomás, møødä Jacobo, jaꞌa Alfeo yhuung, møødä Simón jaꞌa celote, ");
INSERT INTO mirNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","møødä Judas, jaꞌa Jacobo yhuung, møødä Judas Iscariote; jeꞌe jaꞌa Jesús hänajty yajcøꞌødägøꞌøwaam̱b hoꞌcøøc maa jaꞌa fariseoshajxiän. ");
INSERT INTO mirNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mänitä Jesúshajxy miänajnä tuṉguhduum. Mänit hajxy hoy ñaaxoguiädaacnä. Jim̱ä Jesús jiamiøødhajxy hänajty nämay. Jim̱ä jäyaꞌayhajxy hänajty may tøø miech. Jaꞌa Jesús miädiaꞌagy hajxy hänajty yhamädoow̱hidáaṉäp. Yajnaxáaṉäxäp jaꞌa piaꞌamhajxy hänajty. Jäguem̱baady hajxy hänajty tøø chooñ Judeanaaxooty, møødä Jerusalén, møødä mejypiaꞌa jim̱ Tiro møød jim̱ Sidón. ");
INSERT INTO mirNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jaꞌa jäyaꞌayhajxy hänajty møjcuꞌubaꞌammøødpä, yajnájxäxä jaꞌa piaꞌamhajxy jeꞌebä. ");
INSERT INTO mirNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nägøx̱iä jaꞌa Jesús hajxy hänajty ñähdonaꞌañ. Mänitä piaꞌamhajxy yajnájxäxä jaꞌa Jesús miäjaahaam. ");
INSERT INTO mirNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mänitä Jesús wyiinheeꞌppejty jaꞌa jiamiøødhajxy. Mänit miänaaṉ̃: ―Jootcujc mijts mhity, mijts häyoobädøjc. Paady hajxy jootcujc mhity coo hajxy jim̱ mnøcxaꞌañ maa jaꞌa Diosän. ");
INSERT INTO mirNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Jootcujc mijts mhity, mijts yajmaajiajpä. Paady hajxy jootcujc mhity coo jaꞌa Dios hajxy cøx̱iä wiinä xmioꞌowaꞌañ. ’Jootcujc mijts mhity, mijts jøøbiä xuuꞌtspä. Paady hajxy jootcujc mhity coo hajxy mxiꞌig mxooṉdaꞌagaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Jootcujc mijts mhity, hoy mijts jäyaꞌay xjia mähaṉhaty jaꞌa høøc̈hcøxpä, hoy mijts jäyaꞌay xquiaꞌa ja tsocy xquiaꞌa ja meeꞌxy, hoy mijts xjia nänøm̱y, hoy mijts xjia pex̱y. ");
INSERT INTO mirNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mxiꞌig mxooṉdáꞌagäp hajxy jaduhṉ. Mbaadaam̱biä hoyhajt jaꞌa weenhajt hajxy jim̱ tsajpootyp. Jaduhṉ hajxy jiajpä yhabejpä, jaꞌa Diosmädiaꞌagy hajxy jecy tøø yajwáꞌxiäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Pero mijts mäyøøjäyaꞌayhajxy, jaꞌa tsaac̈hpä hajxy mbaadaam̱by. Cab hajxy mxooṉdaꞌagaaṉnä neby hajxy hijty mxooṉdaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Hoy mijts tii hamaay mgaꞌa ja juøꞌøy, myajmaajiadaam̱by hajxy jaduhṉ. ’Hoy mijts mja xiꞌigy mja xooṉdaꞌagy, pero mnäꞌägädä jøꞌøw mnäꞌägädä xuudsaam̱b hajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Tsipcøxpä tsaac̈hpä hajxy mbaadaꞌañ, hoyyä cuꞌug hajxy xjia cumay. Jaduhṉä jäyaꞌayhajxy hijty yajcumay jaꞌa hajxy hijty jegyhajty näꞌä wädijpä høhṉdaacpä. Näꞌä mänaam̱b hajxy hijty jaduhṉ cooc tyijy jaꞌa Diosmädiaꞌagy hajxy yajwaꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Huuc mädow̱ hajxy, mdsógäp hajxy pøṉ jaduhṉ xmiädsiphajp hädaa yaabä naax̱wiin; mméeꞌxäp hajxy pøṉ jaduhṉ xmiähaṉhajp. ");
INSERT INTO mirNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mmänuuꞌxtáꞌagäp jaꞌa Dios hajxy coo jaꞌa Dios ween mioꞌoy jaꞌa hoyhajt jaꞌa weenhajt pønjaty mijts jaduhṉ xyhäyoow̱hijxp, pønjaty mijts jaduhṉ haxøøg xñänøøm̱b. ");
INSERT INTO mirNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Coo pøṉ xyhatejxǿꞌøgät tuꞌnax̱, mmøjcóogumbäp jaduꞌnax̱; ween jaduhṉ jaduꞌnax̱ xjiaac tehm̱ yhatejxøꞌøgy. Coo pøṉ mjocxwit xpiǿjcät, mänitä mgamiixy mjaac tehm̱ mióꞌowät. ");
INSERT INTO mirNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Coo pøṉ tii jaduhṉ xmiäyujwáꞌanät, mmóꞌowäp jaduhṉ. Y coo pøṉ tii xpiǿjcät, cab jeꞌe mmäyujwaaṉdägájtsnät. ");
INSERT INTO mirNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jaduhṉds mijts wiinghänaꞌc mnäxúudsät nej mijts hänajty myajnäxuudsaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Coo jaꞌa mmäguꞌughajpähajtiä hajxy mmøødnijiootpaadǿøjät, cab hajxy tii mbáadät; jaduhṉdsä pojpäyaꞌay cädieejiäyaꞌayhajxy ñic̈hójcäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Coo hajxy jagooyyä mmøødniñäxuudsǿøjät pønjaty jaduhṉ xñäxuuꞌtsp, cab hajxy tii mbáadät; jaduhṉdsä pojpäyaꞌay cädieejiäyaꞌayhajxy ñiñäxúuꞌtsäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Coo jagooyyä xädøꞌøñ hajxy myaghanúuꞌxät pøṉ jaduhṉ mnajuøøby xmioodiägatsaam̱b pedyii, cab hajxy tii mbáadät; jaduhṉdsä pojpäyaꞌay cädieejiäyaꞌay xädøꞌøñ hajxy yajnimiähanúuꞌxäbä. Ñajuøøby hajxy jaduhṉ coo hajxy pedyii mioodiägatsaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mdsógäp hajxy pøṉ jaduhṉ xmiädsiphajp. Mnäxúudsäp hajxy jaduhṉ. Coo pøṉ xädøꞌøñ xmiäyujwáꞌanät, mnäꞌä móꞌowäp jaduhṉ. Mänitä hoyhajt jaꞌa weenhajt hajxy mbáadät may. Mänitä Dios hajxy xyhuunghádät jim̱ tsajpootyp. Hix̱, Dios, ñäxuuꞌchp jaꞌa jäyaꞌayhajxy høxtä jaꞌa jäyaꞌayhajxy jaꞌa Dioscujúꞌuyäp hajxy quiaꞌa yejpiä, møød jaꞌa hojioot hajxy caꞌa møødpä. ");
INSERT INTO mirNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mmøødhádäp jaꞌa hojioot hajxy jaduhṉ nebiä nDeedy hojioot miøødhájtäm. ");
INSERT INTO mirNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Cabä wiinghänaꞌc hajxy mnähójät coo jaꞌa Dios hajxy xyajcumädów̱ät. Pero mmäméeꞌxäp hajxy jaduhṉ; mänitä Dios hajxy jaduhṉ xmiäméeꞌxpät. ");
INSERT INTO mirNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mäduhṉ̃tiä wiinghänaꞌc hajxy mmoꞌoy, näꞌä tägøꞌøbä hajxy mbaattägatsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jadúhṉhøch mijts nyajmäbáadät nebiä wiindspän. Coo jaꞌa wiindspähajxy ñiwyitswädityii, tsipcøxp hajxy jiutcaꞌay. Paady mijts jaduhṉ mgaꞌa wädítät nebiä wiindspän. ");
INSERT INTO mirNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Cabä capxtaacpänaꞌc‑hajxy jiaty jaty nebiä wyiindsøṉhajxy jiatiän. Coo hajxy nägøꞌø nädecypiä quiapxtáꞌagät, mänit hajxy jaduhṉ ñajtspaadǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","’Coo jaꞌa mmäguꞌughajpä weeṉ̃tiä quiädiéeyät, y coo miic̈h hänajty maas hanax̱iä tøø mgädieey, cabä mmäguꞌughajpä hawiinmats waam̱b mnäꞌägädä nämáꞌawät. Coo miic̈h hänajty tøø mnähwaꞌac̈h, mänitä mmäguꞌughajpä hawiinmats mwiingapx mjøjcapxǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Mädyii quepychaa paꞌag näꞌägädä tøømbejp, ni mänaa jaꞌa tiøøm quiaꞌa xuṉä. Jaanä jaduhṉduhm̱bä, mädyii quepychaa xuṉ näꞌägädä tøømbejp, ni mänaa jaꞌa tiøøm quiaꞌa paꞌagøꞌøy. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mnajuøøby hajxy jaduhṉ mädyii quepychaa hoy tøømhajp. Jaꞌa hapty, cab jaduhṉ tiøømhaty nebiä piidsän. Y jaꞌa wädsats, cab jaduhṉ tiøømhaty nebiä tsaatypän. ");
INSERT INTO mirNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jaduhṉ mäwíinädsä hojiäyaꞌay jaꞌa howyiinmahñdy miøødä. Hoy jaduhṉ wiädity. Pero jaꞌa caꞌawiindøjiäyaꞌayhajxy, cabä howyiinmahñdy hajxy miøødä. Haxøøgwiinmahñdy hajxy miäwädijpy. Haxøøg hajxy jaduhṉ ñäꞌägädä capxy ñäꞌägädä mädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Wiindsǿṉhøch mijts xwyiꞌi ñämaꞌay; pero cab hajxy jaduhṉ mgudiunaꞌañ nébiøch mijts nja haneꞌemiän. ");
INSERT INTO mirNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pǿṉhøch nmädiaꞌagy xmiädóow̱äp, pǿṉhøch nmädiaꞌagy xmiäbǿjcäp, jaduhṉ mäwíinäts jeꞌe ");
INSERT INTO mirNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","nebiä jäyaꞌay tiøjcojjiän. Cøøc jaduhṉ tiajøøyy. Tsaawiing jaduhṉ miuuꞌtsøꞌcy. Coo jaꞌa nøøgom̱dägoy quiädaacy, coo jaꞌa tøjc jaduhṉ ñøønähgoom̱bejty, cab jaduhṉ piädøꞌcy, jeꞌeguiøxpä coo hänajty cøøc miuuꞌtsøꞌøguiä. ");
INSERT INTO mirNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero pǿṉhøch nmädiaꞌagy jaduhṉ xquiaꞌa mäbǿjcäp, jaduhṉ mäwíinäts jeꞌe nebiä jäyaꞌay tiøjc cøøc quiaꞌa muuꞌtsøꞌquiän. Coo jaꞌa tøjc ñøønähgoom̱bejty, pädøꞌc jaduhṉ; cøjx jaduhṉ quiäday. ");
INSERT INTO mirNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Coo jaꞌa Jesús miädiaacpädøøyy, mänit quiajptägøøyy Capernaum. ");
INSERT INTO mirNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Jim̱ä soldadowiindsǿṉ hänajty tuꞌug. Roma hänajty chooñ. Tøø jaꞌa mioonsä hänajty tuꞌug piaꞌambety. Jaduhṉ hänajty jiäwøꞌøy nebiä yhamdsoo puhyaꞌayän. Näꞌägädä hoꞌogáaṉnäp hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Coo jaꞌa soldadowiindsǿṉ miädoyhajty coo jaꞌa Jesús jaꞌa paꞌamjäyaꞌay hänajty yajmøcpøcy, mänitä majtøjc näjeꞌe quiejxy maa jaꞌa Jesúsän. Judíos hajxy jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mänitä Jesús hajxy hoy miänuuꞌxtaꞌagy coo jaꞌa paꞌamjäyaꞌay ween nøcxy yajmøcpøcy. Mänitä Jesús ñämaayyä: ―Jaꞌa soldadowiindsǿṉ, hojiäyaꞌay jeꞌe. Hahixøøby jaduhṉ coo mbuhbédät. ");
INSERT INTO mirNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Xchójcäm hajxy jaduhṉ. Tøø højts ndsajtøjc xyajcójjäm. ");
INSERT INTO mirNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Mänitä Jesús jaꞌa majtøjc miøødtuꞌubøjcy. Ja ween hajxy hänajty quiaꞌa coody maa jaꞌa soldadowiindsǿṉ tiøjcän, mänitä soldadowiindsǿṉ jaꞌa Jesús capxy yajnäguejxy: ―Wiindsǿṉ, jaduhyyä mmänáꞌanät cooc̈h nmoonsä miøcpǿgät. Cábøch cuhdujt nmøødä nej miic̈h cuhdujt mmøødän; paady jaduhṉ caj yhawiinmatsä coo mdägǿꞌøwät maac̈h ndøgootiän. Páadyhøch miic̈h hamdsoo tøø ngaꞌa mägapxy. ");
INSERT INTO mirNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Hix̱, hanéꞌemyhøch nhity; y cooc̈h nsoldado howiaam̱bä nhanéꞌemät mǿødhøch nmoonsä, xquiudiúuṉäbøch nmädiaꞌagy hajxy ―nøm̱ä soldadowiindsǿṉ jaꞌa Jesús quiapxyñäguejxy. ");
INSERT INTO mirNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jaanc̈h tehm̱ yagjuøøyy jaꞌa Jesús jaduhṉ coo jaduhṉ ñämaayyä. Mänitä cuꞌug wyiinheeꞌppejty. Mänit miänaaṉ̃: ―Cábøch nmägunaax̱hajxy jaduhṉ miäbøcy nej yøꞌø craa miäbøquiän, y jäguem̱ chooñ. ");
INSERT INTO mirNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jaꞌa majtøjc hänajty tøø quiexyíijäbä maa jaꞌa Jesúsän, mänit hajxy wyiimbijnä. Coo hajxy miejtstägajch maa jaꞌa soldadowiindsǿṉ tiøjcän, tøø jaꞌa soldadowiindsǿṉ mioonsä hänajty miøcpøjnä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mänitä Jesúshajxy ñøcxy maa jaꞌa cajpt hänajty xiøhatiän Naín møødä miäguꞌughajpähajxy. Nämayyä jäyaꞌayhajxy hänajty pianøcxy. ");
INSERT INTO mirNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jim̱ hajxy hänajty miäwiingoṉ̃ cajptpaꞌa, mänitä hoꞌogyjiäyaꞌay hajxy hoy jiøjcubaadøꞌøy. Cabäsantä hänajty nøcxy ñaax̱tägøꞌøy. Tuꞌughuung hänajty jeꞌe. Yaamgtoꞌoxy jaꞌa tiaj jeꞌebä. Majiäyaꞌay hänajty panøcxp. ");
INSERT INTO mirNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Coo jaꞌa Jesús jaꞌa yaamgtoꞌoxy yhijxy, mänit ñäxuuꞌch. Mänit ñämaayy: ―Caꞌa mjøꞌøy caꞌa mxuuc̈h. ");
INSERT INTO mirNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mänitä Jesús miänaaṉ̃ coo hajxy yhuuc yaghahíxät. Mänitä cøøbiädøjc‑hajxy tiänaaxiøjpy. Mänitä Jesús jaꞌa hoꞌogyjiäyaꞌaguiajä hoy ñähdoñ. Mänitä hoꞌogyjiäyaꞌay ñämaayy: ―Jex̱y, pädøꞌøg. ");
INSERT INTO mirNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mänitä craa yhäñaayyøꞌcy. Mänit quiapxøꞌcy. Mänitä tiaj miødhajnä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mänitä jäyaꞌayhajxy nägøx̱iä jiaanc̈h tehm̱ yagjuøøyy. Mänitä Dios hajxy ñämaayy: ―Dioscujúꞌuyäp. Mänit hajxy ñiñämaayyä: ―Diosquex̱y yøꞌø craa. Møj jaanc̈h yøꞌøduhṉ. Paadiä Dios tøø quiex̱y, piuhbedaam̱by jaꞌa quiuꞌug jaduhṉ, jaꞌa hajxy hädaa yaabä naax̱wiimbä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mänitä mädiaꞌagy tiägøøyy wädijpä jim̱ Judeanaaxooty coo jaꞌa Jesús jaꞌa hoꞌogyjiäyaꞌay tøø yagjujypiøcy. Wiinduhm̱yhagajpt jaꞌa mädiaꞌagy jaduhṉ wiädijty. ");
INSERT INTO mirNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jaꞌa Juan, tøø jeꞌe hänajty chumyii. Coo jaꞌa miäguꞌughajpähajxy miädoyhajty nebiatiä Jesús hänajty tiuṉ̃, mänitä Juan hoy yhawáaṉäxä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","20","Mänitä Juan jaꞌa miäguꞌughajpä metsc miøjyaax̱y. Mänit hajxy quiejxä maa jaꞌa Jesúsän. Coo hajxy jim̱ miejch, mänitä Jesús hajxy ñämaayy: ―Juan mäyajnäbejpä højts tøø xquiex̱y coo højts miic̈h nmäyajtǿwät pøṉ miic̈h. Nej, miic̈h jaꞌa Dios hijty jaduhṉ xquiexaam̱bä, tøgä wiinghänaꞌc jeꞌejä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jim̱ä Jesús jaꞌa paꞌamjäyaꞌay hänajty yajmøcpøcy. Madiuꞌu jaꞌa paꞌam hajxy hänajty miøødä møødä møjcuꞌu. Møødä wiindspähajxy hänajty nämay yaghijxøꞌøgyii. ");
INSERT INTO mirNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mänitä Jesús yhadsooyy: ―Nøcxä Juan hajxy hawaaṉä nebiaty hajxy yaa mhix̱y mmädoy. Hijxøꞌp ja wiindspähajxy, yoꞌoyøꞌp jaꞌa tecymiaꞌadpähajxy, nähwaatsp jaꞌa haxøøgpaꞌammøødpähajxy, mädoow̱øꞌp jaꞌa cuhnatpähajxy, jujypiøjp jaꞌa hoꞌogyjiäyaꞌayhajxy, yajwiingapxǿøyyäp jaꞌa häyoobäyaꞌay jaꞌa Diosmädiaꞌagy hajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pønjátyhøch nmädiaꞌagy xmiäbǿjcäp tehṉgajnä, jootcujc hajxy jaduhṉ ñijiäwøꞌøyii ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Coo jaꞌa Juan miäguꞌughajpähajxy wyiimbijnä, mänitä Jesús miänaaṉ̃: ―Coo hajxy tøø mhoy pactuum, Juan miädiaꞌagy hajxy hänajty mmädow̱áaṉäp, túhm̱äts. Cabä tsajcapy pojyuꞌxpä hajxy hoy mhix̱y. Caj pues, paady hajxy jim̱ tøø mhoy coo jaꞌa Juan jaꞌa miädiaꞌagy hajxy hänajty mmädow̱aaṉä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Diosquex̱y jeꞌe, paady hajxy hoy tøø mmädoow̱ä, hoyyä howyit jeꞌe quiaꞌa ja møødä nebiä mäyøøjäyaꞌayhajxy miøødän. ");
INSERT INTO mirNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tøyhajt jaduhṉ coo jaꞌa Juan jaꞌa Diosmädiaꞌagy yajwaꞌxy. Maas may jaꞌa Dios jaꞌa Juan cuhdujt tøø mioꞌoy quejee jaꞌa jäyaꞌay jaꞌa Diosmädiaꞌagy hajxy jecy yajwáꞌxäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jaꞌa jäyaꞌay jaꞌa Diosmädiaꞌagy jecy nägápxäbä, Juan jeꞌe. Jaduhṉä Dios jecy miänaaṉ̃ coo jaꞌa quiuguex̱y hänajty jayøjp quiexaꞌañ coo jaꞌa cuꞌug ween yajwiinxiic yajwiingapxøꞌøy coo jaꞌa yhaxøøgcuhdujt hajxy ñajtshixǿꞌøwät. Høx̱háamhøch hijty ngädaꞌagaꞌañ. Jayøjpä Juan quiejxä; høx̱háamhøch njaanc̈h cädaacy. ");
INSERT INTO mirNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ni pøṉ jaduhṉ jädaꞌahaty quiaꞌa mäbaady hädaa yaabä naax̱wiin nebiä Juan mäyajnäbejpä jaꞌa cuhdujt miøødän. Tøyhajt jaduhṉ. Pero cooc̈h hänajty tøø nhoꞌnä, cooc̈h hänajty tøø nnøcxtägach maac̈h nhuuc tsohm̱bän, pønjaty jaꞌa Diosmädiaꞌagy hänajty mäbøgaam̱b jaꞌa høøc̈hcøxpä, maas may jaꞌa cuhdujt hajxy hänajty miøødhadaꞌañ quejee jaꞌa Juan jädaꞌahaty miøødän, hoyyä møjcuhdujt hajxy hänajty quiaꞌa ja møødä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Coo jaꞌa cuꞌughajxy jaduhṉ miädooyy møødä yajnähjuudiuutpädøjc‑hajxy, mänitä Dios hajxy quiapxpaaty coo yhoyyä, jeꞌeguiøxpä coo hajxy hänajty tøø yajnäbetyii jaꞌa Juángäm. ");
INSERT INTO mirNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero jaꞌa fariseoshajxy møødä ley‑yajnähixøøbiähajxy, cab hajxy hänajty tøø yajnäbetyii jaꞌa Juángäm. Paadiä Dios hajxy quiaꞌa jøjpøgøøyy. Cabä jioot hajxy hänajty chocy coo hajxy yajnähwaꞌadsǿøjät jaꞌa Diósäm. ");
INSERT INTO mirNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mänitä Jesús miänaaṉ̃: ―Nhuuc yajmäbáadyhøch jaꞌa jäyaꞌayhajxy jädaꞌahatypä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cab hajxy tii yhojiäwøꞌøwaꞌañ. Jaduhṉ mäwíinäts hajxy jeꞌe nebiä pigänaꞌc‑hajxy wiinhecpän. Coo hajxy nax̱y miech häyøꞌpä tøjpaꞌc, mänitä miäbigänaꞌc hajxy ñämaꞌay: “Tøø højts nja xuꞌuxy, pero cab hajxy tøø mhech. Tøø højts hojiøøñä nja høy, pero cab hajxy tøø mjøꞌøy.” ");
INSERT INTO mirNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Hoorä, coo jaꞌa Juan mäyajnäbejpä miejch, cabä tsajcaagy hänajty quiayaꞌañ, ni jaꞌa vino hänajty quiaꞌa huꞌugaꞌañ. Y mijts jaduhṉ mänaam̱b coo quiuhmäñøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Y cooc̈h nbamejtspä, høøc̈h jaꞌa Diosquex̱ypä, mänítøch ndägøøyy caabiä huucpä. Jaduhṉc̈h mijts xñänøøm̱bä cooc̈h nwiꞌi quiayaꞌañ, cooc̈h nwiꞌi yhuꞌugaꞌañ, cooc̈hä pojpäyaꞌay cädieejiäyaꞌay nmäguꞌughaty møødä yajnähjuudiuutpädøjc. ");
INSERT INTO mirNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pønjaty jaꞌa Dios jaanc̈h jahmiejtsp, yajcähxøꞌpy hajxy jaduhṉ coo jaꞌa Dioswiinmahñdy hajxy miøødä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mänitä fariseo jaꞌa Jesús tuꞌug hoy wioy caabiä. Simón hänajty xiøhaty. Mänit hajxy yhäñaaguiädaacy caabiä maa jaꞌa Simón tiøjcän. ");
INSERT INTO mirNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mänitä toꞌoxiøjc tuꞌug miejch cuhhiṉbä. Haxøøgcuhdujt hänajty miøød. Tøø hänajty miädoyhaty coo jaꞌa Jesús jiiby tøø miech maa jaꞌa Simón tiøjcän. Perfume quioṉmejts alabastrofrascooty. ");
INSERT INTO mirNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mänit tiägøøyy jøøbiä. Mänitä Jesús tiecypiujy wyiinnøøhaam. Mänit tiecymieex̱y quiuhwaayhaam. Mänit tiecychuꞌxy. Mänit tiecyñähjahx̱y perfumehaam. ");
INSERT INTO mirNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mänitä Simón tiägøøyy tajpä maabiä: “Coo jaꞌa Jesús häxøpy quiunajuøhñdiä, tøø häxøpy ñajuøꞌøy coo yøꞌø toꞌoxiøjc quiuhhiṉä.” ");
INSERT INTO mirNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mänitä Jesús jaꞌa Simón ñämaayy: ―Simón, tsøg mädiáacäm. Mänitä Simón yhadsooyy: ―Wiindsǿṉ, tsøc. ");
INSERT INTO mirNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Mänitä Jesús miänaaṉ̃: ―Jim̱ä jäyaꞌay hijty tuꞌug miänuuꞌxyhadyii jäyaꞌay metscä. Tuꞌjäyaꞌay hänajty miänuuꞌxyhaty mägoox̱mägoꞌx denarios. Jatuꞌug, juxychäguiꞌxmajc. ");
INSERT INTO mirNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Cab hajxy hänajty tii miøødä nebiä ñuuꞌxy hajxy yajnähwáꞌadsät. Mänit hajxy ñämaayyä: “Weends yhity.” Hoorä, pøṉädaꞌa maas mädsógäp. ");
INSERT INTO mirNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mänitä Simón yhadsooyy: ―Jueꞌedaꞌa, jaꞌa craa jaꞌa ñuuꞌxy maas may hijty miøødpä. Mänitä Jesús miänaaṉ̃: ―Jeꞌe pues. ");
INSERT INTO mirNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mänitä Jesús jaꞌa toꞌoxiøjc miøjheeꞌpy. Mänitä Simón ñämaayy: ―Cooc̈h yaa ndägøøyy maa miic̈h mdøgootiän, cábøch miic̈h nøø tøø xmioꞌoy cooc̈h ndecypiújät. Jaduhṉ hajxy nax̱y nguhdujthájtäm. Pero yøꞌø toꞌoxiøjc, wyiinnøøháamhøch ndecy tøø xpiujjä, quiuhwaayháamhøch ndecy tøø xmieex̱ä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Cábøch miic̈h tøø xchuꞌxy, pero yøꞌø toꞌoxiøjc, tehṉgájnøch ndecy xwyiꞌi chuꞌxä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Cábøch miic̈h jaꞌa nguhwaay tøø xyhooṉä. Jaduhṉ hajxy nax̱y nguhdujthájtäm. Pero yøꞌø toꞌoxiøjc, perfumeháamhøch ndecy tøø xyhooṉä. ");
INSERT INTO mirNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Xjiaanc̈h tehm̱ chójpøch yøꞌøduhṉ; paadiä piojpä quiädieey yajnähwáatsäxä, hoy hijty may jia møødä. Pero pøṉä pojpä cädieey hijty caꞌa jaty møød, cábøch jaduhṉ xjiaty wiingudsähgøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mänitä Jesús jaꞌa toꞌoxiøjc ñämaayy: ―Tøøc̈h miic̈h jaꞌa mbojpä mgädieey nyajnähwáatsäm. ");
INSERT INTO mirNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jaꞌa hajxy hänajty jiiby pahäñaabiä, mänit hajxy tiägøøyy niñämáayyäbä: ―Maa jaꞌa cuhdujtädaꞌa tøø yhuuc paatpä coo jaꞌa pojpä cädieey yajnähwaꞌac̈h. ");
INSERT INTO mirNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mänitä Jesús jaꞌa toꞌoxiøjc ñämáaguiumbä: ―Cooc̈h nmädiaꞌagy tøø xmiäbøjcä, páadyhøch jaꞌa mbojpä mgädieey tøø nyajnähwaꞌac̈h. Nøcxnä jootcujc. ");
INSERT INTO mirNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mänitä Jesúshajxy tiägøøyy wädijpä wiinduhm̱yhagajpt møødä jiamiøødhajxy jaꞌa nämajmetspä. Diosmädiaꞌagy‑yajwaꞌxpä hajxy hänajty wiädity. Jaduhṉä Jesús hänajty miänaꞌañ cooc jaꞌa Dios jaꞌa miäjaa hänajty yajcähxøꞌøgaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Quipxiä toꞌoxiøjc‑hajxy hänajty nämay piawädijpä, jaꞌa Jesús hänajty tøø yajpaꞌamnáx̱iäbä, møød jaꞌa møjcuꞌu hajxy hänajty tøø yajnähwaꞌac̈híijäbä. Paadiä Jesús hajxy hänajty piawädity, mioobiä Jesús hajxy hänajty tijaty jeꞌe hänajty miäjugyhajpy. María jaꞌa toꞌoxiøjc hänajty tuꞌug xiøhaty jaꞌa Magdalatsohm̱bä. Juxtujc jaꞌa møjcuꞌu hänajty tøø yajnähwaꞌac̈hii. ");
INSERT INTO mirNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jatuꞌug hänajty xiøhaty Juana, jaꞌa Cuza tioꞌoxiøjc. Jaꞌa Cuza hänajty copc‑hajp maa jaꞌa Herodes hänajty yhaneꞌemiän. Møødä Susana hänajty piawädijpä. ");
INSERT INTO mirNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mänitä Jesús jäyaꞌay may ñänøcxä. Mayhagajpt hajxy hänajty chooñ. Coo hajxy hänajty may tøø yhamugøꞌøy, mänitä Jesús tiägøøyy yajwiingapxøøbiä yajmäbaadyhaam: ");
INSERT INTO mirNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Mänitä jäyaꞌay tuꞌug tiuꞌubøjcy niippä. Coo jaꞌa tøømd tiägøøyy wøjpä, näjeꞌe jaꞌa tøømd quiahy tuꞌhaam. Mänitä muuxyhajxy hoy yajpädøꞌøgy. Mäduhṉ̃tiä jaꞌa muuxyhajxy quiaꞌa yajpädøꞌcy, jeꞌedsä jäyaꞌay jiaac yajtehṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Näjeꞌe jaꞌa tøømd quiahy tsaanähgøxp. Ja mujx jeꞌeduhṉ, pero tøøts. Hix̱, weeṉ̃tiä jaꞌa naax̱ jim̱ tsaanähgøxp. ");
INSERT INTO mirNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Näjeꞌe jaꞌa tøømd quiahy haptiooty. Ja mujx jeꞌeduhṉ. Ja yeeꞌc, pero caj ñäꞌä tøømbejty. Hix̱, jaꞌa hapty jeꞌe xaam̱. ");
INSERT INTO mirNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Näjeꞌe jaꞌa tøømd quiahy maa jaꞌa hoñaax̱än. May jeꞌe tiøømhajty høxtä mägoꞌxhaam. Mänitä Jesús møc miänaaṉ̃: ―Pøṉ hädaa wiinjuøøby, wéenhøch hädaa nmädiaꞌagy xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mänitä Jesús miäyajtøøw̱ä neby jaduhṉ miädiaꞌagytiägøꞌøy. Jaꞌa miäguꞌughajpähajxy jaduhṉ yajtøøw̱. ");
INSERT INTO mirNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mänitä Jesús yhadsooyy: ―Chojpiä Dios jioot jaduhṉ coo mijts mwiinjuǿꞌøwät nebiä miäjaa yajcähxøꞌøgaꞌañ. Pero jaꞌa hänaꞌc‑hajxy jaac yaabä, cabä Diosmädiaꞌagy hajxy tiuꞌjoottsocy. Hoyyä mädiaꞌagy hajxy jia mädoy, pero cab hajxy wyiinjuøꞌøy tii jaduhṉ jia mädiaacypy. ");
INSERT INTO mirNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Jaduhṉds miädiaꞌagytiägøꞌøy nébiøch hajxy tøø nyajwiingapxøꞌøyän. Jaduhṉdsä tøømd miäbaady nebiä Diosmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jaꞌa tøømd cáhw̱äbä tuꞌhaam, jaduhṉ miäbaady nebiä jäyaꞌay jaꞌa Diosmädiaꞌagy hajxy jia mädoyyän. Coo jaꞌa møjcuꞌu miech, mänit hajxy wyiinhøøñii neby hajxy jaduhṉ quiaꞌa mäbǿgät, nebiä piojpä quiädieeyhajxy jaduhṉ quiaꞌa nähwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Y jaꞌa tøømd cáhw̱äbä tsaanähgøxp, jaduhṉds jeꞌe miäbaatpä neby hajxy jia mädoyyän. Tuꞌhabaquiä hajxy jaduhṉ xiooṉdaꞌagy. Pero cab hajxy hamuumduꞌjoot pianøcxy. Coo hajxy cøx̱ypänejpiä tiuñii, mänit hajxy ñajtshixøøñä. ");
INSERT INTO mirNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Y jaꞌa tøømd cáhw̱äbä haptiooty, jaduhṉds jeꞌe miäbaatpä neby hajxy jia mädoyyän. Pero cabä yhamdsoo cuhdujt hajxy ñajtshixøꞌøwaꞌañ møødä miäyøøhajt. Cabä Diosmädiaꞌagy hajxy hoy quiudiunaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Y jaꞌa tøømd cáhw̱äbä hoñaaxooty, jaduhṉ miäbaady nebiä Diosmädiaꞌagy hajxy hamuumduꞌjoot mäbøjpän. Jaanc̈h tehm̱ yhoy hajxy jaduhṉ quiudiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Coo jäyaꞌay jøøn hajxy quiuhnoꞌogøꞌøy, cøxp hajxy yujcoṉ̃ neby hajxy quiudøøꞌxǿøjät, jaꞌa hajxy tøjtägøøbiä. Cabä pøṉ jøøn quiuhjupy, ni maabejtpaꞌc hajxy quiaꞌa pädaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jaduhṉ mäwíinäts mijts jaꞌa nmädiáꞌagyhøch hajxy xwyiinjuøꞌøwaaṉä, jaꞌa tsipjátypøch jaduhṉ tøø nyajwiingapxǿꞌøyäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Huuc wiinjuøꞌøw hajxy hoy. Pǿṉhøch nmädiaꞌagy tøø xmiäbøjcä, njaac yajnähixøꞌøwáam̱biøch jeꞌe. Pǿṉhøch nmädiaꞌagy tøø xquiaꞌa mäbøjcä, cábøch tii nyajnähixøꞌøwaaṉnä. Høxtä jiahdiägoyyaam̱by hajxy jeꞌe mädyii tyijy jaꞌa tøø wyiinjuøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mänitä Jesús ñämejtsä jaꞌa tiaj møødä piuhyaꞌayhajxy. Cab hajxy hoy tiehm̱ wyiingumedsøøyy, jeꞌeguiøxpä coo jaꞌa jäyaꞌayhajxy hänajty ñämayyä jiiby tøgooty maa jaꞌa Jesús hänajtiän. ");
INSERT INTO mirNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mänitä Jesús ñämaayyä: ―Xim̱ä mdajhajxy tøghaguuy møødä mbuhyaꞌayhajxy. Miic̈h hajxy xjia wiꞌi miøødmädiaꞌagaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mänitä Jesús miänaaṉ̃: ―Pøṉä Diosmädiaꞌagy jaduhṉ mäbøjp, pøṉ jaduhṉ cudiuum̱b, jeꞌec̈h ndajhajpy, jeꞌec̈h nbuhyaꞌayhajpy. ");
INSERT INTO mirNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Miäwiinghoocpä jaꞌa Jesúshajxy tiägøøyy barcojooty møødä miäguꞌughajpähajxy. Mänitä Jesús miänaaṉ̃: ―Jam̱ hajxy jim̱ mejyhawiimb. Mänit hajxy jiaanc̈h tuꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nøcxnä hajxy hänajty jaduhṉ, mänitä Jesús miaahoꞌcy. Mänitä poj møc piädøꞌcy. Mänitä nøø quiubojøøyy barcojooty. Hújtsnäp jaꞌa barco hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mänitä Jesús hajxy hoy yux̱y. Mänit hajxy ñämaayy: ―Wiindsǿṉ, Wiindsǿṉ, pädøꞌøg, quinaam̱bä barco cham̱. Mänitä Jesús piädøꞌcy. Mänitä poj yhojy møødä nøø. Mänitä poj yuungøøyy. Moṉ̃diucy jaduhṉ jiajnä. ");
INSERT INTO mirNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mänitä Jesús jaꞌa miäguꞌughajpähajxy ñämaayy: ―Tii hajxy coo mwiꞌi chähgøꞌøy. Nej, cab hajxy mnajuøꞌøyä cooc̈h mijts homiänaajä ngüeendähadaꞌañ. Jaanc̈h tehm̱ yagjuøøyy hajxy jaduhṉ. Mänit hajxy hamiṉ̃ haxøpy ñiñämaayyä: ―Pøṉädaꞌa yøꞌøduhṉ coo jaꞌa miädiaꞌagy miäbǿjcäxä jaꞌa poj møødä nøø. ");
INSERT INTO mirNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mänit hajxy miejyhawiimpädsøøm̱nä jim̱ maa jaꞌa naax̱ hänajty xiøhatiän Gadara, jim̱ jaduhṉ mejyhawiimpä maa jaꞌa Galileanaaxootiän. ");
INSERT INTO mirNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Coo jaꞌa Jesús biarcopädsøøm̱y, mänitä jäyaꞌay tuꞌug miejch Jesús wyiinduum, jaꞌa jim̱ cajptooty tsänaabiä. Tøø hänajty jiegøꞌøy mänaa jaꞌa mähdiøjc møjcuꞌu hänajty tøø ñämec̈hiijän. Cabä wit hänajty miøødhajnä, ni quiaꞌa häñaꞌay hänajty tøgooty. Jim̱ hänajty yhity maa jaꞌa cabäsantän. ");
INSERT INTO mirNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Coo jaꞌa Jesús yhijxy, mänit wyiinjijcädaacy. Mänitä møjcuꞌuhajxy yaax̱y: ―Jesús, tii højts xwiaꞌanaꞌañ. Dios miic̈h xyHuunghajp jaꞌa tsajpootypä. Tuṉä mayhajt, caꞌa højts jiiby xquiex̱y maa jiaanc̈h tehm̱ chaac̈hpän. ");
INSERT INTO mirNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Paadiä mähdiøjc jaduhṉ yaax̱y, jeꞌeguiøxpä coo jaꞌa Jesús jaꞌa møjcuꞌu hänajty tøø yhaneꞌemy coo ñähwaꞌadsǿøjät. Mayhooc jaꞌa mähdiøjc hänajty tøø ñämec̈hii jaꞌa møjcúꞌujäm. Paadiä jäyaꞌayhajxy hänajty jia wiꞌi yaghidaꞌañ cøꞌøxoch tecyxioch cadenahaam neby jaduhṉ hoy yhídät. Pero nimiäpodǿøyyäp hänajty jeꞌe, y yajnǿcxäp hänajty pactuum jaꞌa møjcúꞌujäm. ");
INSERT INTO mirNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mänitä Jesús jaꞌa mähdiøjc miäyajtøøyy: ―Tii mxøhaty. Mänit yhadsooyy: ―Legiónhøch nxøhaty. Paady jaduhṉ miänaaṉ̃ coo jaꞌa møjcuꞌu hänajty may miøødä. ");
INSERT INTO mirNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mänitä møjcuꞌu jaꞌa Jesús hajxy miänuuꞌxtaacy coo hajxy jiiby quiaꞌa quexǿøjät møjcuꞌuhaam maa jiaanc̈h tehm̱ chaac̈hpän. ");
INSERT INTO mirNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jim̱ä mayhädsøm̱ hänajty yuumy tuṉmøjc. Mänitä møjcuꞌu jaꞌa Jesús hajxy miänuuꞌxtáaccumbä coo hajxy jim̱ quiexǿøjät maa jaꞌa mayhädsøm̱ hänajtiän. Mänitä Jesús cuhdujt miooyy. ");
INSERT INTO mirNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mänitä mähdiøjc jaꞌa møjcuꞌu ñähwáatsänä. Mänitä hädsøm̱hajxy hoy ñämec̈hii. Mänit hajxy wyiinmänacpäyøꞌcy. Mänit hajxy quiuhgahnajxy naaxøjpcøxp mejjiooty. Jiiby hajxy cøjx ñøøhoꞌogøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Coo jaꞌa hädsøm̱güeendähajpähajxy jaduhṉ yhijxy, mänit hajxy piäyøꞌcy. Mänitä cuꞌug hajxy hoy yhawaaṉä cajptooty møødä cajptpaꞌa. ");
INSERT INTO mirNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","36","Mänitä cuꞌughajxy hänajty nøcxy yhixaꞌañ neby hänajty tøø jiadyiijän. Mänit hajxy miejch maa jaꞌa Jesús hänajtiän. Jiibiä mähdiøjc jaꞌa Jesús hänajty wyiinhäñaꞌay, jaꞌa møjcuꞌu hänajty tøø ñähwaꞌac̈híijäbä. Tøø wit hänajty piägøøñä. Tøø hänajty wyiinmahñdymejtsnä. Coo jaꞌa cuꞌughajxy jaduhṉ yhijxy, mänit hajxy chähgøøbiøjcy. Paady hajxy chähgøøyy, haxøøgjäyaꞌay tyijy jaꞌa Jesús. Mänitä cuꞌughajxy yhawáaṉäxä nebiä mähdiøjc jaꞌa møjcuꞌu hänajty tøø ñähwaꞌac̈hiijän. Jaꞌa hajxy hänajty tøø yhíx̱iäbä, jeꞌe hajxy jaduhṉ nägapx. ");
INSERT INTO mirNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","39","Mänitä Jesús hajxy tiägøøyy mänuuꞌxtaacpä coo jim̱ chóonät Gadara. Hix̱, jaanc̈h tehm̱ chähgøøby hajxy hänajty. Jim̱ tyijy jaꞌa Jesús cøx̱ypänejpiä jiaac jatcøꞌøwaꞌañ. Jaꞌa mähdiøjc hänajty tøø ñähwáꞌac̈häbä, mänitä Jesús miänuuꞌxtaacy coo cu miødhajty. Mänitä Jesús yhadsooyy coo miähmǿꞌøwät maa quiajptän: ―Nøcx maa jaꞌa mdøjcän; mädiaꞌag nebiaty jaꞌa Dios tøø xpiuhbety. Mänitä craa jiaanc̈h nøcxy, miädiaacy jiiby cajptooty nebiaty hänajty tøø piuhbedyíijäm jaꞌa Jesús. Mänitä Jesús biarcotägøøñä, wyiimbijnä. ");
INSERT INTO mirNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Coo jaꞌa Jesús jim̱ miejtstägajch mejyhawiimb, jim̱ä cuꞌughajxy hänajty yhahix̱y. Mänit hajxy xiooṉdaacy. ");
INSERT INTO mirNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mänitä jäyaꞌay tuꞌug miejch jaꞌa xøhajpä Jairo. Tsajtøjwiindsǿṉ hänajty tiuum̱by. Mänitä Jesús wyiinjijcädaacy. Mänit miänuuꞌxtaacy coo ñǿcxät maa jaꞌa tiøjcän. ");
INSERT INTO mirNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jim̱ä Jairo yhuung hänajty yhoꞌogaaṉnä. Tiuꞌughuung hänajty jeꞌe. Majmetscjomøjt jaꞌa toꞌoxyhänaꞌc hänajty miøødä. Mänitä Jesús tiuꞌubøjcy. Mayyä jäyaꞌayhajxy piaduꞌubøjcy, høxtä yhanøꞌtsmujpy jaꞌa Jesús hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Mänitä Jesús jaꞌa tajjäyaꞌay tuꞌug jiøguyohdiägøøyyä. Paꞌammøød hänajty jeꞌe. Majmetscjomøjt jaꞌa paꞌam hänajty tøø miähäyoy. Ñøꞌty hänajty wiꞌi xieeꞌxp, pero weenjaty weenjaty. Ni pøṉ hänajty quiaꞌa najuøꞌøy nebiä choomiáyät. Mänitä Jesús wyitpaꞌa ñähdóoṉäxä. Mänitiä jaꞌa tajjäyaꞌay ñøꞌty yhadujnä. ");
INSERT INTO mirNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mänitä Jesús miänaaṉ̃: ―Pǿṉhøch xñähdooṉ. Ni pøṉ quiaꞌa mänaaṉ̃ coo hajxy ñähdooṉ̃. Mänitä Pedrohajxy miänaaṉ̃: ―Wiindsǿṉ, xjiaanc̈h tehm̱ yhanøꞌtsmujp miic̈h jaꞌa cuꞌug. Tii nyajnajuǿøyyäm pøṉ tøø xñähdoṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mänitä Jesús miänáaṉgumbä: ―Nnajuǿøbiøch coo pøṉ tøø miäbaadøꞌøy høøc̈h nmäjaahaam. Páadyhøch jaduhṉ tøø nnäꞌä najuøꞌøy cooc̈h hajxy tøø xñähdoṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mänitä tajjäyaꞌay jaduhṉ ñajuøøyy coo jaꞌa Jesús hänajty ñajuøꞌøy coo jeꞌe hänajty tøø miänähdoṉ̃. Mänitä Jesús wyiingumedsøøyy tsäyúuyyäp. Mänitä Jesús wyiinjijcädaacy. Mänit ñägapxy cuꞌughagujc cooc jaꞌa Jesús wyit hänajty tøø ñähdooṉä, y cooc mänitiä piaꞌamnajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mänitä Jesús jaꞌa tajjäyaꞌay ñämaayy: ―Huung, paady miic̈h tøø mbaꞌamnax̱y coo tøø mmäbøcy. Nøcxnä jootcujc. ");
INSERT INTO mirNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jim̱ä Jesús hänajty miädiaꞌagyñä, mänitä jäyaꞌay tuꞌug miejch. Jim̱ hänajty tøø chohṉdaꞌagy maa jaꞌa Jairo tiøjcän. Mänitä Jairo ñämaayyä: ―Tøø jaꞌa mhuung yhoꞌogy. Cabä wiindsǿṉ mhadsíjpnät. ");
INSERT INTO mirNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Miädoow̱ jaꞌa Jesús jaduhṉ. Mänitä Jairo ñämaayy: ―Caꞌa mjootmayhaty. Mäbøc. Jujypiǿgäp jaꞌa mhuung häyaa. ");
INSERT INTO mirNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mänit hajxy jim̱ miejtsnä maa jaꞌa Jairo tiøjcän. Coo jaꞌa Jesús tiøjtägøøyy, caj pøṉ miøødtøjtägøøyy, jagooyyä Pedro møødä Juan møødä quix̱y tiaj tieedy. ");
INSERT INTO mirNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tøghaguuy jaꞌa cuꞌughajxy miähmøøyy jøøbiä xuuꞌtspä. Mänitä Jesús miänaaṉ̃: ―Caꞌa hajxy mwiꞌi jiøꞌøy mwiꞌi xiuuc̈h. Caj tøø yhoꞌogy, näꞌä maab jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mänitä Jesús ñäxiicä. Ñajuøøby hajxy hänajty coo jaꞌa quix̱y hänajty tøø yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mänitä Jesús jaꞌa quix̱y quiøꞌø miajtsä. Mänitä Jesús møc miänaaṉ̃: ―Huung, pädøꞌøg. ");
INSERT INTO mirNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mänitä quix̱y jiujypiøjcy. Mänit piädøꞌcy. Mänitä Jesús miänaaṉ̃ coo hajxy yajcáyät. ");
INSERT INTO mirNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jaanc̈h tehm̱ yagjuøøyy jaꞌa tiaj jaꞌa tieedy jaduhṉ. Mänitä Jesús miänaaṉ̃ coo hajxy pøṉ quiaꞌa yajmøødmädiáꞌagät neby hänajty tøø jiatiän. ");
INSERT INTO mirNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Mänitä Jesús jaꞌa jiamiøød miøjyaax̱y jaꞌa hajxy nämajmetspä. Mänitä cuhdujt hajxy miooyyä coo jaꞌa møjcuꞌubaꞌammøødpä hajxy nägøx̱iä yajnähwáꞌadsät. Møødä mäjaa hajxy mióoyyäbä coo jaꞌa paꞌamjäyaꞌay hajxy yajmøcpǿgät. ");
INSERT INTO mirNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mänit hajxy wyiinguejxä coo jaꞌa Diosmädiaꞌagy hajxy yajwáꞌxät, coo jaꞌa paꞌamjäyaꞌay hajxy yajmøcpǿgät. Jaduhṉ hajxy miädiáꞌagät coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mänit hajxy ñämaayyä: ―Cab hajxy tii mmänǿcxät, ni cuhdajt, ni pijty, ni tsajcaagy, ni xädøꞌøñ. Tuꞌxojxc‑hajtiä jaꞌa mwit hajxy mmänǿcxät, caꞌa mietscä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Homiädyii tøjcä hajxy mmejtstáꞌagät, jim̱ hajxy mmähmǿꞌøwät høxtä coonä hajxy jim̱ jadähooc mwiimbídät. ");
INSERT INTO mirNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Y coo hajxy maa xquiaꞌa yajtøjtägøꞌøwáꞌanät, mänit hajxy jim̱ mdsóonät maa jaꞌa cajptän. Mänitä mdecy hajxy mwiinwóbät nebiä hijxtahṉd jaduhṉ miähmǿꞌøwät coo mijts tøø xquiaꞌa yajtøjtägøꞌøy ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mänit hajxy tiuꞌubøjcy. Wiinduhm̱yhagajpt hajxy hänajty wiädity Diosmädiaꞌagy‑yajwaꞌxpä, paꞌamjäyaꞌay‑yajmøcpøjpä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jaꞌa Herodes hänajty jim̱ tuum̱b gobernador. Mänit miädoyhajty nebiatiä Jesús jaꞌa hijxtahṉd hänajty yajcähxøꞌøguiän. Cab hänajty ñajuøꞌøy nebiä wyiinmahñdyhádät. Hix̱, näjeꞌe hajxy hänajty miänaꞌañ cooc tyijy jaꞌa Juan hänajty tøø jiujypiøcy. Hix̱, tøø jaꞌa Juan hänajty yaghoꞌogyii. ");
INSERT INTO mirNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Näjeꞌe hajxy hänajty miänaam̱bä cooc tyijy jeꞌe Elías, jaꞌa Diosmädiaꞌagy jecy yajwáꞌxäbä. Näjeꞌe hajxy hänajty jiaac mänaam̱bä cooc tyijy jaꞌa jecyjiäyaꞌay tøø jiujypiøcy, jaꞌa Diosmädiaꞌagy jecy yajwáꞌxäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mänitä Herodes miänaaṉ̃: ―Høøc̈hä Juan nyajyoꞌpujxä. Pøṉädaꞌa jaduhṉ wädijp. Madiúꞌujøch jaduhṉ nmädoy yajcähxøꞌøgy. Jiaanc̈h tehm̱ yhixaam̱biä Herodes jaꞌa Jesús hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Coo jaꞌa Jesús jiamiøødhajxy wyiimbijtägajch, mänitä Jesús hajxy yajmøødmädiaacy nebiaty hajxy hänajty tøø wiädity. Mänit hajxy miøødnøcxä pactuum, jim̱ mäwiingóṉ maa jaꞌa cajpt hänajty xiøhatiän Betsaida. ");
INSERT INTO mirNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Coo jaꞌa cuꞌughajxy jaduhṉ miädoyhajty, mänitä Jesús hajxy jim̱ piamejch. Mänit hajxy ñämaayyä coo hajxy jim̱ miähmǿꞌøwät. Mänitä Diosmädiaꞌagy hajxy yajmøødmädiaacä cooc jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. Møødä paꞌamjäyaꞌayhajxy may yajmøcpøjcä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tsuujǿøñäp hänajty, mänitä Jesús wyiingumedsøøyyä jaꞌa jiamiøødhajxy jaꞌa nämajmetspä. Mänitä Jesús ñämaayyä: ―Nämaꞌaw yøꞌø jäyaꞌayhajxy coo hajxy nøcxy piooꞌxnä, coo hajxy nøcxy quiayhøxtaꞌay wiingtuum maa jaꞌa cajpt miäwiingoṉän. Yaa maa hajxy nhíjtäm, cabä tii yaa. ");
INSERT INTO mirNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mänitä Jesús miänaaṉ̃: ―Huuc yajcay mijts. Mänit hajxy yhadsooyy: ―Cab højts tii nmøødä; jagooyyä højts tsajcaagy mägoox̱c nmøødä møødä hacx metscä. Tøgä nǿcxäp højts njuuyyä jaꞌa hajxy quiayaam̱biä, hoy hajxy jia nämayyä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nämägoox̱mil jaꞌa yaꞌadiøjc‑hajxy hänajty nägøx̱iä. Mänitä Jesús ñämaayy jaꞌa jiamiøødhajxy: ―Nämaꞌaw hajxy ween hajxy yhäñaaguiädaꞌagy naax̱wiin näjuxychäguiꞌxmajcjaty. ");
INSERT INTO mirNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mänit hajxy ñämaayy coo hajxy jaduhṉ yhäñaaguiädáꞌagät. Mänit hajxy yhäñaaguiädaacy nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mänitä Jesús jaꞌa mägoox̱pä tsajcaagy quiooṉdsooyy møødä metspä hacx. Mänit chajheeꞌpy. Mänitä Dios piaꞌyaax̱y, miänaaṉ̃: ―Dioscujúꞌuyäp coo højts hädaa tøø xmioꞌoy. Mänit jaduhṉ yhaguidøøyy. Mänitä jiamiøød miooyy coo hajxy jaduhṉ yajwáꞌxät maa jaꞌa cuꞌugän. ");
INSERT INTO mirNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mänit hajxy nägøx̱iä quiaayy cuꞌuxiä. Majmejtscach jaꞌa caadiuc quiunajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wiingxøø hänajty jeꞌebä, jim̱ä Jesús jaꞌa Tieedy hänajty piaꞌyaꞌaxy hanidiuhm̱duum. Jim̱ä jiamiøødhajxy hänajty miøødä. Mänitä Jesús yajtøøyy: ―Nébyhøch jaꞌa cuꞌughajxy xñänøm̱y pǿṉhøch høøc̈h. ");
INSERT INTO mirNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mänit hajxy yhadsooyy: ―Näjeꞌe hajxy miänaꞌañ cooc tyijy miic̈h mJuangä jaꞌa hijty mäyajnäbejpä. Näjeꞌe hajxy miänaam̱bä cooc tyijy miic̈h mhElíasä. Näjeꞌe hajxy jiaac mänaam̱bä cooc tyijy jaꞌa jecyjiäyaꞌay tøø jiujypiøcy, jaꞌa Diosmädiaꞌagy jecy yajwáꞌxäbä, y cooc tyijy miic̈h mjeꞌejä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mänitä Jesús yajtǿøgumbä: ―Míjtsäts, nej mijts mmänaam̱bä pøṉ xtyijy høøc̈h. Mänitä Pedro yhadsooyy: ―Diosquex̱y miic̈h. ");
INSERT INTO mirNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mänitä Jesús møc miänaaṉ̃ coo hajxy quiaꞌa nägápxät pøṉ hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mänitä Jesús miänáaṉgumbä: ―Høøc̈h jaꞌa Diosquex̱ypä, hoyhóyhøch njaanc̈h tehm̱ chaac̈hpøgaꞌañ. Cábøch jaꞌa tsajtøjwiindsøṉhajxy xñäꞌägädä wiingudsähgøꞌøwaꞌañ, ni jaꞌa teedywiindsøṉhajxy, ni jaꞌa jäyaꞌayhajxy jim̱ cuhdujtmøødpä tsajtøgooty. Xyaghoꞌogáam̱bøch hajxy, pero cudägøøgxǿøjøch njujypiøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mänit jiaac mänáaṉgumbä: ―Pønjátyhøch nmädiaꞌagy xpiaduꞌubøgáaṉäp, ween yhamdsoo cuhdujt hajxy ñajtshixøꞌøy, ween hajxy chaac̈hpøjpä jabom̱‑jabom̱ nébiøch ndsaac̈hpøgaꞌañän. Jadúhṉhøch nmädiaꞌagy hajxy hoy xpianǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pøṉ jiugyhajt ja wiꞌi yaghoyøꞌøwaam̱b, näꞌägä cuhdägoyyaam̱b jeꞌe. Pero pøṉ jiugyhajt jaduhṉ yajtägoyyaam̱b jaꞌa høøc̈hcøxpä, näꞌägä hodiuum jeꞌe miähmøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Coo hajxy hodiuum mgaꞌa mmähmǿꞌøwät, cab hajxy jaduhṉ mniyaghoyøꞌøwǿøjät, hoy hajxy mja mäyøøjä hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pǿṉhøch xmiädsähdiuum̱b mǿødhøch nmädiaꞌagyquiøxpä, mänítøch jaduhṉ nmädsähdiunaam̱bä cooc̈h hänajty ngädaactägatsaꞌañ. Hajajaam̱b hänajty yaa neby jim̱ yhajajjiän tsajpootyp maac̈h nDeedy yhitiän, maa jaꞌa mioonsähajxy yhitiän. ");
INSERT INTO mirNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tøyhájthøch jaduhṉ nmänaꞌañ, jaꞌa hajxy yaa tänaabiä, näjeꞌe hajxy jaduhṉ quiaꞌa tsoj hoꞌogaꞌañ høxtä coonä jaꞌa Dios jaꞌa miäjaa hänajty yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Cuductujxøø jaꞌa Jesús jaꞌa Pedro miøødwiimbejty tuṉguhduum Diospaꞌyaax̱pä, møødä Juan møødä Jacobo. ");
INSERT INTO mirNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jim̱ä Jesús jaꞌa Tieedy hänajty piaꞌyaꞌaxy, mänitä wyiin jiøjp høxtä haam̱b høxtä tsämaam̱b quiähxøꞌcy. Jaanc̈h tehm̱ pioob jaꞌa wyit jaduhṉ jiajnä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Mänitä Moiséshajxy ñäguehx̱tøøꞌxy maa jiajy maa chämam̱iän møødä Elías. Mänitä Jesús hajxy miøødtägøøyy mädiaacpä. Jeꞌe hajxy hänajty miädiaacypy coo jaꞌa Jesús hänajty jim̱ nøcxy yhoꞌogaꞌañ Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Hoyyä Pedrohajxy hänajty jia wiꞌi miaꞌawaꞌañ, cab hajxy ñäꞌägädä maahoꞌcy. Mänit hajxy yhijxy coo jaꞌa Jesúshajxy hänajty jiajy chämam̱y møødä Moisés møødä Elías. ");
INSERT INTO mirNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Coo jaꞌa Moiséshajxy hänajty wyiimbidaaṉnä, coo jaꞌa Jesús hajxy hänajty piuhwaꞌadsaaṉnä, mänitä Pedro jaꞌa Jesús ñämaayy: ―Wiindsǿṉ, hoyøøyy jaduhṉ coo hajxy yaa tøø nbéjtäm. Ween højts tøjquem̱y tägøøg cu nhädiuuṉ̃, tuꞌug miic̈h mjeꞌe, tuꞌug Moisés jieꞌe, tuꞌug Elías jieꞌe. Näꞌä nagoobä jaꞌa Pedro jaduhṉ miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mänitä nämaꞌa tehm̱ miapxy quiädaacy maa hajxy hänajtiän. Nädägooyy hajxy jaduhṉ. Mänitä Pedrohajxy chähgøøbiøjcy. ");
INSERT INTO mirNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mänit hajxy miädooyy jaꞌa Dios quiapxy nämaꞌajooty: ―Høøc̈h nHuung hädaa. Høøc̈h tøø nwiinguex̱y. Mhamädoow̱híjtäp jaꞌa miädiaꞌagy hajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mänitä Jesús hajxy yhijxy coo hänajty nidiuhm̱ tiänaañä. Hamoṉ̃ hajxy jaduhṉ miähmøøñä. Cab hajxy pøṉ yajmøødmädiaacy nebiaty hajxy hänajty tøø yhix̱y. ");
INSERT INTO mirNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Cujaboom hajxy jim̱ wyiimbijnä tuṉguhduum. Mänitä Jesús jäyaꞌay may jiøjcubaadøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Mänit tuꞌjäyaꞌay møc quiapxy maa jaꞌa cuꞌugän: ―Wiindsǿṉ, túꞌuquiøch nhuung. Náx̱yhøch nhuung møjcuꞌu xjiaanc̈h tehm̱ ñämejtsä. Møc jaduhṉ yaꞌaxy, møc chäyuy. Høxtä hahooꞌp jaduhṉ. Hanax̱iä jaduhṉ chaac̈htiuñii, y cab jaduhṉ ñäꞌägädä nähwaꞌac̈h. Wiindsǿṉ, tuṉä mayhajt, yajnähwáatsägøch nhuung. ");
INSERT INTO mirNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tøøc̈h jaꞌa mjamiøød nja wiꞌi miänuuꞌxtaꞌagy cooc̈h nhuung hajxy xyajnähwáatsät, pero cab hajxy jaduhṉ ñäꞌä jajty. ");
INSERT INTO mirNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mänitä Jesús jaꞌa jiamiøød ñämaayy: ―Nej, cájtäm mijts mänaa mmäbøgaꞌañä. Pämädúhṉ̃tiøch mijts jaduhṉ njaac mämeeꞌxtugaꞌañ. Mänitä cuhuung ñämaayy: ―Woomiṉxä mhuung. ");
INSERT INTO mirNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Cahnä craa hänajty miechñä maa jaꞌa Jesúsän, mänit yajcädaaw̱ä jaꞌa møjcúꞌujäm. Mänit yajtsäyuuyyä. Mänitä Jesús jaꞌa møjcuꞌu yhøxquejxy. Mänitä craa ñähwaach. Mänitä tieedy yajcøꞌødägøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mänitä cuꞌughajxy nägøx̱iä yagjuøøyy coo jaꞌa Dios miøjjä jiaanc̈hä, nebiä Jesús jaꞌa hijxtahṉd hänajty yajcähxøꞌøguiän. Mänitä Jesús ñämaayy jaꞌa jiamiøødhajxy: ");
INSERT INTO mirNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Hoy hajxy wiinjuøꞌøw; caꞌa hajxy mjahdiägoy; høøc̈h jaꞌa Diosquex̱ypä, nmädsíphøch hajxy jim̱ xyajcøꞌødägøꞌøwaam̱b maa jaꞌa cuꞌughajxiän nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero cabä jiamiøødhajxy ñäꞌägädä wiinjuøøyy neby hajxy hänajty tøø miøødmädiaꞌagyiijän. Hix̱, Jesús jaduhṉ caꞌa yajwiinjuøøyy. Cab hajxy jaduhṉ yajtøøyy. Tsähgøøby hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mänit hajxy tiägøøyy yajtsiptaacpä pøṉ cuhdujt maas møj moꞌowáaṉäp. ");
INSERT INTO mirNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ñajuøøbiä Jesús hänajty nebiaty hajxy hänajty tiajy miay. Mänitä pigänaꞌc hoy tuꞌug wioy, piädaacy miøjc‑haamby. ");
INSERT INTO mirNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mänit miänaaṉ̃: ―Pøṉ hädaa pigänaꞌc jaduhṉ tsógäp jaꞌa høøc̈hcøxpä, jaduhṉ mäwíinäts høøc̈h xchojpä. Y pǿṉhøch jaduhṉ xchojp, jeꞌec̈h nDeedy jaduhṉ xjiahmiéjtsäp jaꞌac̈h jaduhṉ tøø xquiéx̱iäbä. Pøṉ jaꞌa møjcuhdujt caꞌa tsogaam̱b maa mijtsän, jeꞌeds jaꞌa møjcuhdujt jaduhṉ näꞌägädä moꞌowáaṉäp. ");
INSERT INTO mirNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mänitä Juan miänaaṉ̃: ―Wiindsǿṉ, tøø højts tuꞌjäyaꞌay nhix̱y. Miic̈hcøxpä jaꞌa møjcuꞌu hijty yhøxquex̱y. Mänit højts jaduhṉ nnämaayy coo quiaꞌa høxquéjxnät, jeꞌeguiøxpä coo højts xquiaꞌa møødwädíjtäm. ");
INSERT INTO mirNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mänitä Jesús miänaaṉ̃: ―Cab hajxy jaduhṉ cu mnämaayy. Pøṉ højts jaduhṉ xquiaꞌa mädsiphájtäm, jeꞌe højts jaduhṉ xmiäguꞌughájtäm. ");
INSERT INTO mirNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tøø hänajty miäwiingooṉnä coo jaꞌa Jesús hänajty ñøcxaaṉnä tsajpootyp, mänitä jioot yajmøødmädiaacy coo jim̱ ñǿcxnät Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mänitä jiamiøød mejtstägøøg quiejxøꞌcy. Mänitä mejtstaact hajxy hoy jia høxtaꞌay maa jaꞌa cajpthuung tuꞌugän jim̱ Samarianaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero cab hajxy jaduhṉ ñäꞌä tøjmooyyä, jeꞌeguiøxpä coo hajxy hänajty jim̱ jiaac nøcxaꞌañ Jerusalén. Hix̱, cabä Samariabä‑jäyaꞌayhajxy hänajty miøødnijiootpaadyii jaꞌa jäyaꞌayhajxy hänajty tsänaabiä Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Coo jaꞌa Jacobo jaduhṉ miädooyy møødä Juan, mänitä Jesús hajxy ñämaayy: ―Wiindsǿṉ, tähooc jaꞌa Elías jøøn jim̱ miøjyaax̱y tsajpootyp nebiä haxøøgjäyaꞌayhajxy jaduhṉ tióyät. Nej, mmänáꞌanäp miic̈h jaduhṉ coo højts jøøn jim̱ nmøjyáax̱pät tsajpootyp neby hajxy jaduhṉ tióobiät jaꞌa højts jaduhṉ xquiaꞌa tøjmoꞌowaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mänitä Jesús wyiinheeꞌppejty; mänit yhojy: ―Mijts, cab hajxy mnajuøꞌøy coo haxøøgwiinmahñdy hajxy mmøødä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Páadyhøch yaa tøø ngädaꞌagy hädaa yaabä naax̱wiin nébiøch jaꞌa jäyaꞌayhajxy jaduhṉ nyajnähwaꞌads nyajcuhwáꞌadsät. Cábøch hajxy jaduhṉ nyajcuhdägoyyaꞌañ. Mänit hajxy jim̱ tiuꞌubøjnä, ñøcxy hajxy wiingcajpt. ");
INSERT INTO mirNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jim̱ hajxy hänajty tiuꞌuyoꞌoyñä, mänitä jäyaꞌay hajxy tuꞌug piaaty jim̱ tuꞌhaam. Mänitä Jesús ñämaayyä: ―Wiindsǿṉ, nja wiꞌi pianøcxáam̱biøch miic̈h majaty miic̈h mnøcxaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mänitä Jesús miänaaṉ̃: ―Jaꞌa xøøgaa, jim̱ä jiut jeꞌe; jaꞌa muuxy, jim̱ä pieꞌeñ jeꞌe; pero høøc̈h jaꞌa Diosquex̱ypä, cábøch ndøjc jaduhṉ maac̈h nbooꞌx nhäñáꞌawät. ");
INSERT INTO mirNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mänitä Jesús wiinghänaꞌc ñämáaguiumbä: ―Høøc̈h paduꞌubǿjcäc. Mänitä Jesús ñämaayyä: ―Mänítøch miic̈h nbaduꞌubǿgät cooc̈h ndeedy hänajty tøø yhoꞌnä, cooc̈h hänajty tøø nyajnaax̱tägøøñä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mänitä Jesús miänaaṉ̃: ―Jaꞌa jäyaꞌayhajxy caꞌa mäbøjpä, jeꞌe miic̈h jaꞌa mdeedy hajxy xyajnaax̱tägøꞌøwáaṉäp. Pero miic̈h, nøcx jaꞌa Diosmädiaꞌagy yajwaꞌx coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mänitä Jesús ñämaayyä wiingjäyáꞌayägumbä: ―Wiindsǿṉ, nja wiꞌi pianøcxáam̱biøch miic̈h, pero nǿcxyhøch jaꞌa njujy nmäguꞌug nhuuc hawaaṉä jayøjp cooc̈h miic̈h jaduhṉ nbaduꞌubøgaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mänitä Jesús yhadsooyy: ―Pǿṉhøch jaduhṉ xjia wiꞌi piawäditaam̱b, cooc̈h nmädiaꞌagy hamuumduꞌjoot xquiaꞌa mäbǿjcät, cábøch jaduhṉ hoy xpianǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mänitä Jesús jäyaꞌay jiaac wiimbiiyy nädägøøghiiꞌxcumajc. Mänit hajxy metscaty metscaty quiejxøꞌcä majaty jaꞌa Jesús hänajty ñøcxaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mänit hajxy ñämaayyä: ―Nämayyä jäyaꞌayhajxy jia mäbøgaꞌañ; jeꞌeds caꞌa hijp pøṉ jaꞌa Diosmädiaꞌagy yajwáꞌxäp. Mänuuꞌxtaꞌag jaꞌa Dios hajxy coo jaꞌa Diosmädiaꞌagy‑yajwaꞌxpä jiaac quéxät. ");
INSERT INTO mirNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nøcx hajxy. Mnigwieendähadǿøjäp hajxy. Caꞌawiindøyhänaꞌc‑hagujc hajxy mwäditaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Cabä xuumy hajxy mmänǿcxät, ni xädøꞌøñ. Tuꞌtehṉgä cøꞌøg hajxy mmänǿcxät. Cab hajxy pøṉ mwiindänaaxiǿbät tuꞌhaam. ");
INSERT INTO mirNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Coo hajxy muum maa mhamejtstáꞌagät, myajpóoꞌxäp jaꞌa cudøjc hajxy. “Weenä Dios hajxy xmioꞌoy jaꞌa hoyhajt jaꞌa weenhajt.” Jaduhṉ hajxy mnämáꞌawät. ");
INSERT INTO mirNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pø hojiäyaꞌay jaꞌa cudøjc‑hajxy jaduhṉ, mänitä Dios jiaanc̈h móꞌowät jaꞌa hoyhajty jaꞌa weenhajt; pø caj, cab hajxy jaduhṉ mioꞌowǿøjät. Y cab hajxy jim̱ mnäꞌägä mähmǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cab hajxy tøjc‑tøjc mwädítät. Jim̱ hajxy mnäꞌägädä hídät maa hajxy hänajty tøø mmejtstaꞌaguiän. Jim̱ hajxy mmähuꞌug mmägáyät. Jeꞌe hajxy jaduhṉ mhúꞌugäp mgáyäp tijaty hajxy jaduhṉ xmiooby. Hawiinmats jaduhṉ coo hajxy jaduhṉ xmióꞌowät, jeꞌeguiøxpä coo hajxy mwiinguex̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Homiädyii cajptä hajxy jaduhṉ xtiøjmóꞌowät, mgáyäp hajxy jaduhṉ tijaty hajxy xmiooby. ");
INSERT INTO mirNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Myajmøcpǿgäp jaꞌa paꞌamjäyaꞌay hajxy maa jaꞌa cajptän. Jaduhṉ hajxy mnämáꞌawät: “Tøø miäwiingooṉnä coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ jaꞌa mijtscøxpä.” ");
INSERT INTO mirNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero homiädyii cajptä hajxy jaduhṉ xquiaꞌa tøjmóꞌowät, callejooty hajxy nøcxy myaꞌaxy: ");
INSERT INTO mirNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Hädaa cajpt yaabä, cabä quiuhdujthajxy yhoyyä. Paady højts ndecy nwiinwobaꞌañ. Jaduhṉä hijxtahṉd miähmǿꞌøwät coo jaꞌa mguhdujthajxy quiaꞌa hoyyä. Mjahmiédsäp hajxy jaduhṉ coo miäwiingooṉnä coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ jaꞌa mijtscøxpä.” ");
INSERT INTO mirNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tøyhájthøch jaduhṉ nmänaꞌañ, coo jaꞌa naax̱wiimbä hänajty wyiimbidaꞌañ, maas hanax̱iä jaꞌa cajpt jaduhm̱bä chaac̈hpøgaꞌañ quejee jaꞌa Sodomacajpt jecy chaac̈hpøjquiän. ");
INSERT INTO mirNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","14","’Mjaanc̈h tehm̱ chaac̈hpøgaam̱b hajxy pønjaty jim̱ tsänaaby Corazíncajptooty møødä Betsaidacajptooty. Maas hanax̱iä hajxy mdsaac̈hpøgaꞌañ quejee jaꞌa jäyaꞌayhajxy jecy chaac̈hpøjquiän, jaꞌa hajxy jecy tsänáayyäbä Tirocajptooty møødä Sidóncajptooty. Coo jeꞌe hajxy cu yhijxy jaꞌa hijxtahṉd nej mijts mja hix̱iän, cu ñajtshixøøyy jaꞌa yhaxøøgcuhdujt hajxy; cu jiøøyy cu xiuuꞌch hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y mijts jim̱ tsänaabiä Capernaum, haagä jiiby mijts mhädaꞌagaꞌañ møjcuꞌuhaam. Cab hajxy jim̱ mnøcxaꞌañ tsajpootyp neby hajxy mdijjiän. ");
INSERT INTO mirNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mänitä Jesús ñämaayy jaꞌa jiamiøødhajxy jaꞌa nädägøøghiiꞌxcumajcpä: ―Pønjaty mijts mmädiaꞌagy xyhamädoowhíjtäp, jaanä jadúhṉhøch nmädiaꞌagy hajxy xyhamädoow̱híjtäbä. Pero pønjaty mijts mmädiaꞌagy xquiaꞌa hamädoow̱híjtäp, ni høøc̈h nmädiaꞌagy hajxy xquiaꞌa hamädoow̱híjtäbä; ni jaꞌa nDéedyhøch miädiaꞌagy xquiaꞌa hamädoow̱híjtäbä, jaꞌac̈h tøø xquiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mänitä nädägøøghiiꞌxcumajcpähajxy tiuꞌubøjcy Diosmädiaꞌagy‑yajwaꞌxpä. Cujecy hajxy wyiimbijtägajch. Jaanc̈h tehm̱ jiootcujc hajxy hänajty. Mänit hajxy miänaaṉ̃: ―Wiindsǿṉ, høxtä jaꞌa møjcuꞌu højts nmädiaꞌagy hajxy tøø xmiäbøjcä jaꞌa miic̈hcøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mänitä Jesús miänaaṉ̃: ―Tøyhajt jaduhṉ. Nhíjxhøch jaꞌa Satanás coo jim̱ quiahy tsajpootyp. Nebiä wädsucän jaduhṉ jiatcøøyy. ");
INSERT INTO mirNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Huuc mädow̱ hajxy, tøøc̈h mijts jaꞌa mäjaa nmoꞌoy coo mijts tsahṉ̃dy myajtéenät møødä caaꞌpty, y coo jaꞌa møjcuꞌu hajxy mgaꞌa yajmäjädáꞌagät; y cab hajxy nej mjadaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Paady hajxy mxooṉdáꞌagät coo jaꞌa mxøøhajxy jim̱ yhity cujaay tsajpootyp. Cab jaduhṉ ñejpiä pø tøø jaꞌa møjcuꞌu jaꞌa mmädiaꞌagyhajxy xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mänitä Jesús jiaanc̈h tehm̱ yajxooṉdaacpøjcä jaꞌa Dioshespíritu. Mänitä Jesús miänaaṉ̃: ―Teedy, míic̈häts jim̱ Wiindsøṉhajp tsajpootyp møød hädaa yaabä naax̱wiin. Chojpy miic̈h mjoot jaduhṉ coo jaꞌa hajxy caꞌa høxpøcypiä wyiinjuǿꞌøwät tijaty jaꞌa hajxy høxpøcypiä tøø mgaꞌa yajwiinjuøꞌøy. Páadyhøch miic̈h hoy nnänøm̱y. ");
INSERT INTO mirNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mänitä Jesús ñämaayy jaꞌa jiamiøødhajxy: ―Tøøc̈h nDeedy jaꞌa cuhdujt xquiøx̱y moꞌoy. Cábøch pøṉ xñajuøꞌøy pǿṉhøch høøc̈h, jagóoyyøch nDeedy jaduhṉ xñajuøꞌøy. Y jagóoyyøch nDeedy nnajuøøbiä. Ñajuøøby hajxy jeꞌebä pønjátyhøch tøø nyajnähdijy coo hajxy ñajuǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mänitä Jesús jaꞌa jiamiøød wyiinheeꞌppejty jaꞌa hajxy nämajmetspä. Mänit hajxy hawiing ñämaayyä: ―Jootcujc hajxy jaduhṉ mhídät jeꞌeguiøxpä cooc̈h mijts jaꞌa hijxtahṉd may tøø nyajnähixøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tøyhájthøch jaduhṉ nmänaꞌañ. Jaꞌa Diosmädiaꞌagy‑yajwaꞌxpähajxy møødä gobiernähajxy, nämay hajxy jia hixaaṉ̃ tijaty mijts mhijxyp. Nämay hajxy jia mädow̱aaṉ̃ tijaty mijts mmädooby. ");
INSERT INTO mirNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mänitä ley‑yajnähixøøbiä tuꞌug tiänaayyøꞌcy. Mänitä Jesús hoy miäyajtøy: ―Wiindsǿṉ, tiic̈h ngudiúnäp nébiøch cøjxtaꞌaxiøø njugyhádät nebiä Dios jiugyhatiän. Paadiä Jesús jaduhṉ ñämaayyä, näꞌä mädiaꞌagyhixáaṉäp hänajty jeꞌe waam̱b hänajty yhadsowaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mänitä Jesús yhadsooyy: ―Neby jaduhṉ jim̱ myiṉ̃ cujaay maa jaꞌa leyän. Neby jaduhṉ mwiinjuøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mänitä ley‑yajnähixøøbiä yhadsooyy: ―Jaduhṉ jim̱ myiṉ̃ maa jaꞌa leyän coo jaꞌa Dios mwiingudsähgǿꞌøwät hamuumduꞌjoot. Jaanä jaduhṉ jim̱ myiim̱bä coo hopiøṉä mdsógät mbaꞌhäyówät nebiä mniꞌx nebiä mgopc mdsoquiän. ");
INSERT INTO mirNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mänitä Jesús miänaaṉ̃: ―Hoy jaduhṉ tøø mhadsoy; coo jaduhṉ mgudiúnät, mänit jim̱ mnǿcxät tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero yajcumayaam̱bä ley‑yajnähixøøbiä hänajty. Mänit miänáaṉgumbä: ―Pøṉ jaduhṉ mnänøøm̱by cooc̈h hopiøṉä ndsógät nbaꞌhäyówät. ");
INSERT INTO mirNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mänitä Jesús yhadsóogumbä: ―Nhuuc yajmøødmädiáꞌagyhøch mädiaꞌagy tuꞌug, nej miic̈h jaduhṉ hoy mwiinjuǿꞌøwät. Jiibiä jäyaꞌay hänajty tuꞌug yhädaꞌagy Jericó. Jerusalén hänajty tøø chohṉdaꞌagy. Tuꞌhaamhädaacpä jaꞌa meeꞌtspä piaaty. Cøjx jaduhṉ miéeꞌtsäxä møødä wyit. Mänit hoyhoy wiobhoꞌcä. Nebiä hoꞌogypiän hajxy jaduhṉ ñähgueecy. ");
INSERT INTO mirNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mänit teedywiindsǿṉ tuꞌug ñajxy. Coo jaꞌa mähdiøjc jaduhṉ yhijxy, cab jaduhṉ tiänaaxiøjpy. Jiuhyohy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jaduhṉdsä tsajtøjcueendähajpä tuꞌug ñajxpä; jaduhṉ jeꞌe jiuhyohbiä. ");
INSERT INTO mirNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mänitä Samariabäyaꞌay tuꞌug ñajxpä. Coo jaduhṉ yhijxy, mänitä hojioot miøødhajty. ");
INSERT INTO mirNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mänitä mähdiøjc chooyøøyy aceitehaam møødä vinohaam. Mänit yhamäguijty withaam maa hänajty tøø jiotiän. Mänitä yhamdsoo jäyujcøxp yujtsehṉ̃. Mänitä mähdiøjc hoy ñajtsømøꞌøyii maa jaꞌa mejtstaactän. Mänit jim̱ yhijxä. ");
INSERT INTO mirNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cujaboomä Samariabäyaꞌay jaꞌa cudøjc plataxädøꞌøñ metsc miooyy. Mänit ñämaayy: “Tuṉä mayhajt, huuc cueendähat yøꞌø mähdiøjc. Mäduhṉ̃tiä xädøꞌøñ mjaac yajtuṉ̃, mänítøch jaduhṉ nmoodiägátsät cooc̈h nwiimbijtägátsät.” ");
INSERT INTO mirNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mänitä Jesús jaꞌa ley‑yajnähixøøbiä miäyajtøøyy: ―Pøṉ maas hoyhänaꞌc tøø piädsøm̱y yøꞌø nädägøøgpähajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mänitä ley‑yajnähixøøbiä yhadsooyy: ―Jaꞌa hänaꞌc hojioot møødhájtäbä. Mänitä Jesús miänaaṉ̃: ―Nøcx, y jaduhṉ miic̈h hojioot mmøødhájpät. ");
INSERT INTO mirNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mänitä Jesúshajxy tiuꞌubǿjcumbä. Mänit hajxy miejch wiingcajptooty. Mänitä Jesús yajtøjtägøøyyä jaꞌa toꞌoxiøjc tuꞌug jaꞌa xøhajpä Marta. ");
INSERT INTO mirNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jim̱ä Marta piuhdoꞌoxy hänajty tuꞌug jaꞌa xøhajpä María. Mänitä María jaꞌa Jesús wyiinhøxtaacy. Yhamädoow̱hidaam̱by hänajty jeꞌe waam̱baty jaꞌa Jesús hänajty miädiaꞌagaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero wyiꞌi jioodhadǿøtsäp jaꞌa Marta tiuuṉg hänajty. Mänitä Jesús ñämaayy: ―Wiindsǿṉ, nej miic̈h jaduhṉ mnijiäwøꞌøyii cooc̈h nbuhdoꞌoxy jaꞌa tuuṉg tøø xyajmänähgueegøꞌøy. Huuc nämaꞌaw weenc̈h xpiuhbety. ");
INSERT INTO mirNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mänitä Jesús yhadsooyy: ―Marta, Marta, madiuꞌu miic̈h mwiꞌi tiajy mwiꞌi miay. ");
INSERT INTO mirNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tuꞌtuꞌuyyä jaduhṉ yhawiinmatsä. Hoyyä mbuhdoꞌoxy jaduhṉ quiudiuṉ̃. Cabä María jaꞌa cuhdujt jaduhṉ pøṉ piøgáaṉäxä cooc̈h nmädiaꞌagy jaduhṉ xyhamädoow̱híjtät. ");
INSERT INTO mirNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wiingtuumä Jesús jaꞌa Dios hänajty piaꞌyaꞌaxy. Coo piaꞌyaax̱pädøøyy, mänitä jiamiøød tuꞌug miänaaṉ̃: ―Wiindsǿṉ, højts Diospaꞌyaꞌax yajnähixǿøyyäc nebiä Juan jaꞌa jiamiøød yajnähixøøyyän. ");
INSERT INTO mirNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mänitä Jesús miänaaṉ̃: ―Coo jaꞌa Dios hajxy hänajty mbaꞌyaꞌaxaꞌañ, jaduhṉ hajxy mmänáꞌanät: Dios, miic̈h højts nDeedyhajpy. Jim̱ mhity tsajpootyp. Weenä jäyaꞌayhajxy nägøx̱iä xwyiingudsähgøꞌøy. Weenä mmäjaa myajcähxøꞌøgy. Weenä mmädiaꞌagy hajxy yaa xmiäbøjcä hädaa yaabä naax̱wiin neby hajxy jim̱ xmiäbøjcän tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Móoyyäc højts jaꞌa cay jädaꞌaxøø neby højts cuꞌuxiä ngáyät. ");
INSERT INTO mirNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Højts jaꞌa pojpä cädieey mäméeꞌxäc neby højts jaduhṉ nmämeeꞌxiän pønjaty højts xñägädieeyøøby. Cabä møjcuꞌugong cuhdujt mmóꞌowät coo højts xjiøjcapxǿꞌøwät, coo højts jaꞌa haxøøgpä xyajnähdíjät. ");
INSERT INTO mirNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mänitä Jesús miänáaṉgumbä: ―Tsøg hajxy jaduhṉ mänáaṉäm coo mijts mmäguꞌughajpä mmøødä tuꞌug. Coo miic̈h cuptsuhm̱dä nøcxy mnämaꞌay: “Mäguꞌughajpä, høøc̈hä tsajcaagy tägøøg yajyujwáaṉäc. ");
INSERT INTO mirNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Jaꞌa nmäguꞌughájpøch tuꞌug tøø miech. Jäguem̱ chooñ. Cábøch tii nmøødä tiic̈h jaduhṉ nnäꞌä móꞌowäp.” ");
INSERT INTO mirNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wehṉdä mmäguꞌughajpä jiiby tøgooty xyhadsówät: “Caꞌa xyhadsipy. Hagøꞌøy jaꞌa tøjcän. Tøø højts ngøx̱y maahoꞌnä mǿødhøch nhuunghajxy. Cábøch nbädøꞌøgaaṉnä cooc̈h miic̈h jaduhṉ tijaty nmóꞌowät.” ");
INSERT INTO mirNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tøyhájthøch jaduhṉ nmänaꞌañ, hoy jaduhṉ xjia mäguꞌughaty, cab jaduhṉ xñäꞌä näbädøꞌøgáam̱bät coo miic̈h tijaty xmióꞌowät. Pero coo miic̈h tehṉgajnä mwiꞌi ñéꞌemät, mänit jaduhṉ piädǿꞌøgät, mänit jaduhṉ xmióꞌowät tijaty miic̈h hänajty myajmaajiajpy. ");
INSERT INTO mirNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tøyhájthøch jaduhṉ nmänaꞌañ, coo mijts jaꞌa Dios tijaty mmäyujwáꞌanät tehṉgajnä, tsipcøxp jaduhṉ xñäꞌägädä móꞌowät. ");
INSERT INTO mirNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Coo pøṉä Dios tijaty miäyujwáꞌanät tehṉgajnä, tsipcøxp jaduhṉ ñäꞌägädä moꞌowaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Pø jim̱ mhuunghajxy, coo tsajcaagy xmiäyujwáꞌanät, cabä tsaa mmoꞌowaꞌañ; coo hacx xmiäyujwáꞌanät, cabä tsahṉ̃dy mmoꞌowaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O coo tseediuꞌudy xmiäyujwáꞌanät, cabä caaꞌpty mmoꞌowaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hojiatypä jaꞌa mhuung hajxy jaduhṉ mmooby, hoy hajxy mja caꞌawiindøyyä. Mänax̱iä jaꞌa mDeedyhajxy jim̱ tsajpootypä xmióꞌowät jaꞌa yhEspíritu coo mijts jaduhṉ mmäyujwáꞌanät. ");
INSERT INTO mirNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wiinghoocä Jesús jaꞌa møjcuꞌu hänajty yhøxquex̱y. Tøø jäyaꞌay hänajty tuꞌug yaghuumyii. Coo jaꞌa mähdiøjc ñähwaatsnä, mänit quiapxøꞌnä. Yagjuøøyy jaꞌa jäyaꞌayhajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero näjeꞌe hajxy jaduhṉ miänaaṉ̃: ―Yøꞌø craa, jaꞌa møjcuꞌugongä miäjaa jaduhṉ miøødhájtäp, paadiä møjcuꞌu yhøxquex̱y. Jaꞌa møjcuꞌugong, jaꞌa møjcuꞌu wyiindsøṉhajxy jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Näjeꞌe hänaꞌc jaꞌa Jesús hajxy hänajty ñämaꞌay coo hijxtahṉd ween yajcähxøꞌøgy, jaꞌa jim̱ tsajpootypä. Wyiinmahñdyhixaam̱biä Jesús hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero ñajuøøbiä Jesús hänajty nebiaty hajxy hänajty wyiꞌi tiajy wyiꞌi miay. Mänit miänaaṉ̃: ―Homiädyii cajptä, coo jaꞌa cuꞌughajxy ñiyhawiingpädaꞌagǿøjät, coo hajxy tuꞌtøjc ñimiädsibøꞌøwǿøjät, cuhdägóyyäp jaꞌa chänaꞌahajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jaanä jaduhṉduhm̱bä, coo Satanáshajxy ñimiädsibøꞌøwǿøjät, cuhdägóyyäp hajxy jeꞌebä. Mijts jaduhṉ mänaam̱b cooc̈h tyijy jaꞌa møjcuꞌuhajxy nhøxquex̱y jaꞌa møjcuꞌugongä miäjaagøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pero coo häxøpy jaduhṉ tiøyyä, maa mijts mjamiøød jaꞌa mäjaa hajxy yhuuc paatpä coo jaꞌa møjcuꞌu hajxy yhøxquex̱y. Cähxøꞌp jaduhṉ coo mijts jaꞌa tøyhajt hajxy mgaꞌa møødä. ");
INSERT INTO mirNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero høøc̈h, jaꞌa Diosmäjaagǿxpøch jaꞌa møjcuꞌuhajxy nhøxquex̱y. Y cähxøꞌp jaduhṉ coo miäwiingooṉnä coo Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ jaꞌa mijtscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Tsøg jaduhṉ mänáaṉäm, coo jaꞌa jäyaꞌay jaanc̈h møcpä cwieendähádät jaꞌa yhamdsoo tøjc, coo pujxt coo wojpt hänajty miøødä, cabä meeꞌtspä jaduhṉ tiägǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero coo jäyaꞌay maas caꞌawiindøybä miédsät, cabä cudøjc jaduhṉ miäjädáꞌagät. Pǿjcäxäp jaꞌa piujxt jaꞌa wiojpt jaduhṉ jaꞌa tyijy yajmäjädaꞌagaam̱biä. Møød jaduhṉ piǿjcäxäbät tijaty jiiby miøød tøgooty. Y høøc̈h, jaduhṉ mäwíinäts høøc̈h jaꞌa møjcuꞌugong ngaꞌa yajmäjädaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Pǿṉhøch jaduhṉ xquiaꞌa møødpädøꞌp, høøc̈h nmädsip jeꞌeduhṉ. Y pǿṉhøch jaduhṉ xquiaꞌa møødtuum̱b, jeꞌe jaduhṉ yajmaꞌp pønjátyhøch nmädiaꞌagy xjia wiꞌi miäbøgáaṉäp. ");
INSERT INTO mirNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Mänitä Jesús miänáaṉgumbä: ―Tsøg jadähooc mädiáaccumbä. Coo jaꞌa møjcuꞌu piädsǿm̱ät maa jäyaꞌay tuꞌugän, mänit tiägøꞌøy pooꞌxtaacthøxtaabiä pactuum. Y coo jaduhṉ quiaꞌa páadät, mänit miänaꞌañ cooc jim̱ wyiimbidaꞌañ maa tøø yhuuc pädsøøm̱bän. ");
INSERT INTO mirNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Coo jim̱ miejtstägátsät maa jaꞌa jäyaꞌayän, tøø jaꞌa jäyaꞌay hänajty wyiinmahñdymech nebiä tøjc waꞌadspän. ");
INSERT INTO mirNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mänitä møjcuꞌu jaꞌa jiamiøød nøcxy wioy juxtujc jaꞌa maas haxøøgpä. Mänit hajxy nägøx̱iä tiägøꞌøy maa jaꞌa jäyaꞌayän tsänaabiä. Y maas haxøøg jaꞌa jäyaꞌay ñäꞌägä jaty quejee hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jim̱ä Jesús hänajty miädiaꞌagyñä, mänitä toꞌoxiøjc tuꞌug yaax̱y cuꞌughagujc: ―Jootcujc miic̈h mdaj mdsiꞌtsc jaduhṉ yhity jeꞌeguiøxpä coo miic̈h tøø xyajtsoꞌogy tøø xyajyeegy. ");
INSERT INTO mirNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mänitä Jesús miänaaṉ̃: ―Jeꞌeds maas jootcujc hijp, pønjatiä Diosmädiaꞌagy cudiuum̱b. ");
INSERT INTO mirNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Tehṉgajnä jaꞌa Jesús jaꞌa cuꞌug hänajty jiaanc̈h tehm̱ ñämugøꞌøyii may. Mänitä Jesús miänaaṉ̃: ―Cabä jäyaꞌay howyiinmahñdy hajxy miøødä, jaꞌa hajxy jädaꞌahatypä. Jaꞌa hijxtahṉd hajxy jia wiꞌi yhixaam̱by, jaꞌa hoy‑yagjuǿøñäbä. Pero cab hajxy jaduhṉ yaghixaꞌañii. Jagooyyä hajxy jaduhṉ yhixaꞌañ cooc̈h høøc̈h jaduhṉ njadaꞌañ nebiä Jonás jecy jiajtiän mänaa jim̱ quiexyiijän Nínivecajptooty. Dios jaduhṉ quejx. ");
INSERT INTO mirNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Coo jaduhṉ yhabáadät coo jaꞌa jäyaꞌayhajxy hänajty yajnähdijaꞌañii, mänitä toꞌoxiøjc piädøꞌøgaꞌañ, jaꞌa jecy hanéhm̱äbä jim̱ jäguem̱naax̱ jaꞌa jøømbojmänajpä. Jeꞌe jaduhṉ mänaꞌanaam̱b coo jaꞌa jäyaꞌayhajxy jädaꞌahatypä piädaꞌagǿøjät haxøøgtuum. Jeꞌeds jaꞌa Salomón hoy tøø miämädoonaꞌay, jeꞌeguiøxpä coo jaꞌa Salomón hänajty jiaanc̈h tehm̱ quiuhwijjiä. Y cabä Salomón cuhdujt hänajty jiaty møødä nébiøch høøc̈h jaduhṉ nmøødän. ");
INSERT INTO mirNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Y jaꞌa jäyaꞌayhajxy jecy tsänáayyäbä Nínivecajptooty, jaduhṉ hajxy miänaꞌanaam̱bä coo jaꞌa jäyaꞌayhajxy jädaꞌahatypä piädaꞌagǿøjät haxøøgtuum. Coo jaꞌa Jonás jaꞌa Diosmädiaꞌagy hoy yajwaꞌxy jim̱ Nínivecajptooty, mänitä jäyaꞌay jaꞌa yhaxøøgwiinmahñdy hajxy ñajtshixøøyy. Y cabä Jonás cuhdujt hänajty jiaty møødä nébiøch høøc̈h nmøødän. ");
INSERT INTO mirNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Coo jaꞌa jäyaꞌay jøøn hajxy quiuhnoꞌogøꞌøy, cøxp hajxy jaduhṉ piädaꞌagy, nebiä jäyaꞌayhajxy jaduhṉ quiudøøꞌxǿøjät jaꞌa hajxy tøjtägøøbiä. Cabä jøøn hajxy yuꞌuc̈h, ni cab hajxy quiuhjupy cajónghaam. ");
INSERT INTO mirNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","36","Cooc̈h mijts jaꞌa nmädiaꞌagy hamuumduꞌjoot xmiäbǿjcät, hoy hajxy jaduhṉ mwädítät homiänaajä. Pero cooc̈h nmädiaꞌagy hajxy xquiaꞌa mäbǿjcät, hagoodstuum hajxy jaduhṉ mhídät. Homiänáajøch nmädiaꞌagy hajxy xmiäbǿjcät neby hajxy hagoodstuum mgaꞌa cáꞌawät. ");
INSERT INTO mirNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Coo jaꞌa Jesús miädiaacpädøøyy, mänitä Jesús wioonøcxä mägaabiä jaꞌa fariséwäm. Coo jim̱ miejch maa jaꞌa fariseo tiøjcän, mänit yhäñaaguiädaacy meexäwiinduum. ");
INSERT INTO mirNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jaguiøꞌøbujy jaꞌa Jesús yhäñaaguiädaacy. Caj quiøꞌøbujy nebiä judíoshajxy hänajty quiuhdujthatiän. Coo hajxy hänajty tiägøꞌøwaꞌañ caabiä, mänit hajxy hänajty quiøꞌøbujy. Coo jaꞌa Jesús quiaꞌa cøꞌøbujy, yagjuøøyy jaꞌa fariseo jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mänitä Jesús miänaaṉ̃: ―Mijts fariseodøjc, jaduhṉ hajxy mja wiꞌi quiähxøꞌøgaꞌañ nebiä hoyhänaꞌcän jim̱ cuꞌughagujc. Pero cabä mjoot cabä mjuøhñdyhajxy yhoyyä, jeꞌeguiøxpä coo hajxy mwiꞌi mieec̈h mwiꞌi pioty. ");
INSERT INTO mirNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Caj mijts mwiinmahñdy yhoyyä. Tøø jaꞌa Dios jaꞌa mniꞌx jaꞌa mgopc‑hajxy xquiunuuꞌxä. Tøø jaꞌa mjoothajxy xjia cunúuꞌxäbä coo jaꞌa mjuøhñdyhajxy hoy cu mhijty. ");
INSERT INTO mirNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Coo jaꞌa häyoobäyaꞌay hajxy mbuhbédät hamuumduꞌjoot, mänit hajxy jaduhṉ mnähwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Mijts fariseodøjc, haxøøg hajxy mjadaꞌañ mhabetaꞌañ. Xiøøbä hajxy mja näꞌä wiꞌi quiuyoxøꞌøy yøꞌøbiꞌc jøøꞌxychooy jiiby tsajtøgooty. Pero cabä Diosmädiaꞌagy hajxy mgudiunaꞌañ maa jaduhṉ myiṉ̃än coo hajxy hoy mwädítät, coo jaꞌa Dios hajxy mwiingudsähgǿꞌøwät. Pedyii jaꞌa Diosmädiaꞌagy hajxy mgudiúnät. ");
INSERT INTO mirNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Mijts fariseodøjc, haxøøg hajxy mjadaꞌañ mhabetaꞌañ. Mjaanc̈h tehm̱ yajcumayaam̱b hajxy jaduhṉ. Jiiby hajxy mja wiꞌi yhäñaꞌawaꞌañ maa jaꞌa häñaabiejt hojiatypän jiiby tsajtøgooty. Y chojpy jaꞌa mjoothajxy jaduhṉ coo jaꞌa cuꞌug hajxy xiꞌig xoṉ xwyiingudsähgǿꞌøwät jiiby halaplaaz. ");
INSERT INTO mirNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Mijts fariseodøjc, mijts ley‑yajnähixøøbiädøjc, mhøhṉdaacp hajxy jaduhṉ. Cab hajxy myajcähxøꞌøgy coo jaꞌa mguhdujthajxy quiaꞌa hoyyä. Y pønjaty jaꞌa mmädiaꞌagyhajxy xpianǿcxäp, tuꞌudägooby hajxy jeꞌebä, jeꞌeguiøxpä coo hajxy quiaꞌa najuøꞌøy coo mijts mguhdujt jaduhṉ yhaxøøgä. ");
INSERT INTO mirNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mänitä Jesús ñämaayyä jaꞌa ley‑yajnähixøøbiä tuꞌug: ―Wiindsǿṉ, coo jaduhṉ mmänaꞌañ, haxøøg højts jaduhṉ xñänøøm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mänitä Jesús miänaaṉ̃: ―Mijts ley‑yajnähixøøbiädøjc, jaanä haxøøg mijts mjadaam̱bä mhabetaam̱bä. Hanax̱iä mijts jaꞌa tsipjatypä myajnähixøꞌøy. Ni pøṉ jaduhṉ quiaꞌa jadaꞌañ nej mijts myajnähixøꞌøyän. Y cab hajxy hamdsoo mgudiunaꞌañ neby hajxy myajnähixøꞌøyän ni weeṉ̃tiä. ");
INSERT INTO mirNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","’Haxøøg hajxy mjadaꞌañ mhabetaꞌañ. Haxøøg mijts mguhdujt nebiä mhap jaꞌa mdeedyhajxy hijty chänaꞌay yhäyoyyän jegyhajty. Jeꞌeds hajxy jaduhṉ yaghoꞌc jaꞌa Diosmädiaꞌagy hajxy jecy yajwáꞌxäbä. Y mijts jaꞌa tiøjc‑huunghajxy myajcójjäp maa hajxy jecy ñaax̱tägøøyyän. Myajcähxøꞌpy hajxy jaduhṉ coo jaꞌa mhap jaꞌa mdeedy hajxy tuꞌugwiinmahñdy mmøødhity. ");
INSERT INTO mirNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ñajuøøbiä Dios jaduhṉ. Jeꞌe jaduhṉ mänaaṉ: “Nguexáam̱biøch nguguex̱yhajxy maa yøꞌø hänaꞌc‑hajxiän. Näjéꞌejøch nguguex̱yhajxy xyaghoꞌogaaṉä. Näjeꞌe hajxy ñäꞌä tsaac̈htiunaꞌañii.” ");
INSERT INTO mirNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jaꞌa jäyaꞌayhajxy jädaꞌahatypä, pojpätuum cädieediuum hajxy jaduhṉ miähmøꞌøwaꞌañ jaꞌa Dios quiuguex̱ycøxpähajxy, jaꞌa hajxy tøøbä yaghoꞌogyíijäbä nägøx̱iä. Mänit hajxy tiägøøyyä yaghóꞌcäbä mänaa hädaa yaabä naax̱wiin yhawijy tiøøꞌxtaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Møødä Abel yaghóꞌcäbä møødä Zacarías. Tsajtøghaguuy jaꞌa Zacarías yaghoꞌcä jim̱ mädøyyä maa jaꞌa altarän. Tøyhajt jaduhṉ coo jaꞌa jäyaꞌayhajxy jädaꞌahatypä miähmøꞌøwaꞌañ pojpätuum cädieediuum. ");
INSERT INTO mirNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Mijts ley‑yajnähixøøbiädøjc, haxøøg hajxy mjadaꞌañ mhabetaꞌañ. Cabä cuꞌug jaꞌa tøyhajt hajxy mnäꞌä moꞌowaꞌañ. Cabä tøyhajt hajxy hamdsoo mnäꞌä tsocy. Mijts jaꞌa cuꞌug mwiꞌi quiapxhiim̱by nebiä tøyhajt hajxy jaduhṉ quiaꞌa páadät. ");
INSERT INTO mirNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mänitä Jesús jiaanc̈h tehm̱ miäjootmaꞌtä jaꞌa fariseodøjc møødä ley‑yajnähixøøbiädøjc. Mänit hajxy tiägøøyy mäyajtøøbä madiuꞌu. ");
INSERT INTO mirNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jia wiinmahñdyhixaaṉ jaꞌa Jesús hajxy jaduhṉ neby hajxy jaduhṉ cu yajnähdsøøm̱y. ");
INSERT INTO mirNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mänitä jäyaꞌayhajxy yhamugøøyy milhaam høxtä niñøꞌtsmujcä hajxy jaduhṉ. Mänitä Jesús jaꞌa jiamiøød hawiing ñämaayy: ―Cabä fariseos miädiaꞌagy hajxy mmäbǿjcät. Nämay hänaꞌc jaduhṉ tiuꞌudägoy coo jaꞌa fariseos miädiaꞌagy hajxy miäbøjcä. Hix̱, høhṉdaacp jaꞌa fariseoshajxy jaduhṉ. Yajnajuøꞌøwaam̱b jaduhṉ tsipcøxp coo hajxy jaduhṉ yhøhṉdaꞌagy. Hoy hajxy hoy jia capxy jia mädiaꞌagy, cab hajxy hamdsoo hoy quiudiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hix̱, cab jaduhṉ tii ñäꞌägädä mähmøꞌøwaꞌañ jañägapxy. Haagä cähxøꞌøgaam̱b jaduhṉ cøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jaanä jaduhṉduhm̱bä jaꞌa mijtscøxpä, waam̱baty hajxy tøø mmänaꞌañ hameeꞌch, yajmädow̱aam̱b jaduhṉ cuꞌughagujc. ");
INSERT INTO mirNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Mäguꞌughajpädøjc, cab hajxy mdsähgǿꞌøwät pøṉ jaꞌa mniꞌx jaꞌa mgopc xyaghóꞌcäp. Cab jaduhṉ nej xjiaac túnät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero jaꞌa Dios hajxy jaduhṉ mdsähgǿꞌøwäp. Jeꞌedsä cuhdujt møød coo jaꞌa mjugyhajthajxy xyajcuhdägóoyyät, y coo hajxy xpiädáꞌagät haxøøgtuum. ");
INSERT INTO mirNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Høxtahm̱dsä muuxyhuunghajxy, hoy hajxy yaa tii quiaꞌa ja waꞌañ, jiahmiejchpä Dios jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mänax̱iä mijts jaꞌa Dios xquiaꞌa jahmiédsät. Paady hajxy jaduhṉ mgaꞌa tsähgǿꞌøwät. Xjiaanc̈h tehm̱ chojp mijts jaꞌa Dios høxtä xmiooby hajxy tijaty hajxy myajmaajiajpy. ");
INSERT INTO mirNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Tøyhájthøch jaduhṉ nmänaꞌañ, høøc̈h jaꞌa Diosquex̱ypä, pǿṉhøch xquiapxpaatp cuꞌughagujc, jeꞌec̈h jaduhṉ ngapxpaattägatsaam̱by jim̱ tsajpootyp jaꞌa Diosmoonsäwiinduum. ");
INSERT INTO mirNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero pǿṉhøch jaduhṉ xquiaꞌa capxpaatp cuꞌughagujc, ni jeꞌec̈h jaduhṉ ngaꞌa capxpaadaam̱bä jaꞌa Diosmoonsäwiinduum. ");
INSERT INTO mirNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Pǿṉhøch haxøøg xñänøøm̱b, meeꞌxáaṉäp jeꞌe. Pero coo jaꞌa Dioshespíritu hajxy haxøøg ñänǿmät, cab hajxy jaduhṉ miéeꞌxänät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Coo mijts hänaꞌc mädsibøꞌøbä xyajnǿcxät tsajtøgooty o jim̱ maa jaꞌa hagujtøjcän, cab hajxy mdaj mmáyät waam̱b hajxy mmädiáꞌagät, ");
INSERT INTO mirNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","jeꞌeguiøxpä coo jaꞌa Dioshespíritu hajxy xñajtscapxǿøyyät waam̱baty hajxy jaduhṉ mhadsówät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mänitä Jesús ñämaayyä tuꞌjäyaꞌay maa jaꞌa cuꞌugän: ―Wiindsǿṉ, nämáayyägøch nbuhyaꞌay cooc̈hä nnädeedyñaax̱ xpiuhmóꞌowät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mänitä Jesús miänaaṉ̃: ―Pǿṉhøch tøø xquiuhdujtmoꞌoy cooc̈h mijts nhanéꞌemät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mänitä Jesús miänáaṉgombä: ―Mnigwieendähadǿøjäp hajxy coo hajxy tii mgaꞌa hadsógät. Cab hajxy nøcxy mdajy mmay coo hajxy cøx̱iä mgaꞌa møødä. ");
INSERT INTO mirNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mänit miänáaṉgombä: ―Tsøg hajxy mänáaṉäm, jii jäyaꞌay hijty tuꞌug jaanc̈h tehm̱ miäyøø. Mänitä ñøø miooc may yajpädøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mänit tiägøøyy tajpä maabiä: “Nébiøch nnøø nmooc ndúnät. Maac̈h jaduhṉ nnäꞌä pädáꞌagät.” ");
INSERT INTO mirNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mänit miänáaṉgombä: “Tøøc̈h nnajuøꞌøy maac̈h nbädáꞌagät. Nyajmáꞌadäbøch yøꞌø ndsehx̱. Maas crúundøch ngójät. Jíibyhøch nnøø nmooc ngøx̱y pädáꞌagät, mädúhṉ̃tiøch nmøødä. ");
INSERT INTO mirNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Cábøch jaduhṉ tii ndájnät nmáañät. Jootcujc‑høch jaduhṉ ndsänáañät nhäyóonät majiomøjt. Pooꞌxáam̱bøch, cayáam̱bøch huꞌugáam̱bøch, xooṉdaꞌagáam̱bøch.” ");
INSERT INTO mirNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mänitä Dios jaꞌa craa ñämaayy: “Miic̈h, cab jaduhṉ mnäꞌägä mäbøcy. Jädaꞌa coods mhoꞌogaꞌañ. Yøꞌøduhṉ tøø mwiꞌi piädáꞌaguiäbä, pøṉ jaduhṉ mämähmøꞌøwaam̱b.” ");
INSERT INTO mirNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jaduhṉdsä mäyøøjäyaꞌayhajxy jiaty yhabety pønjaty maxiädøꞌøñ jaduhṉ tehṉgajnä yajmujp yhamdsoogøxpähajxy. Pero maa jaꞌa Dioswiinduumän, häyoob hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mänitä Jesús jaꞌa jiamiøød ñämaayy: ―Caꞌa hajxy mdajy mmay tii hajxy mnäjugyhadaam̱by, tii hajxy mgayaam̱by, tii hajxy mwithadaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Cab hajxy nøcxy mdajy mmay coo hajxy cøx̱iä wiinä mgaꞌa møødä. ");
INSERT INTO mirNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Høxtahm̱ds yøꞌø muuxyhajxy, cab hajxy tiuṉ̃ xiajy. Cab hajxy tii ñiꞌiby; cab hajxy tii yajpädøꞌøgy; cabä tsehx̱ hajxy miøødä. Jaꞌa Dios jaduhṉ yagjøøꞌxp. Y mijts, mmaas tsoobaatp hajxy quejee jaꞌa muuxyhajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hoy hajxy mäduhṉ̃tiä mja taj mja máyät, cab hajxy hamdsoo mniyajyeegǿøjät ni weeṉ̃tiä. ");
INSERT INTO mirNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pø cab hajxy hoy hamdsoo mniyajyeegaꞌañii, cab hajxy tii mdaj mmáyät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Høxtahm̱ds yøꞌø pøjy, yeeꞌp yøꞌø. Pero cab tiuṉ̃ xiajy; cab pyiidyhädiuṉ̃. Tøyhajt jaduhṉ, ni jaꞌa rey Salomón jecy quiaꞌa näꞌägä mäbaaty nej yøꞌø pøjjiän, hoy howyit hänajty jia møødä. ");
INSERT INTO mirNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hoyyä Dios yøꞌø pøjy yajxóṉ jia cunuuꞌxy, cab jiecy. Mänax̱iä mijts jaꞌa Dios xquiaꞌa witmóꞌowät, hoy mijts jaduhṉ mgaꞌa ja mäbøcy. ");
INSERT INTO mirNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Caꞌa hajxy mwiꞌi tiajy mwiꞌi miay tii hajxy mgayaam̱by mhuꞌugaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Jaꞌa hajxy jaduhṉ caꞌa mäbøjpä, jeꞌeds hajxy wyiꞌi tiajpy wyiꞌi miaaby. Pero mijts, ñajuøøbiä mDeedyhajxy tijaty hajxy myajmaajiajpy. ");
INSERT INTO mirNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Taj may hajxy nebiä Diosmädiaꞌagy hajxy hoy mgudiúnät, mänitä Dios cøx̱iä xmióꞌowät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Mäguꞌughajpädøjc, caꞌa hajxy mdsähgøꞌøy, hoy hajxy jaduhṉ mja näꞌä weeṉ̃tiä. Chojpiä mDeedy jioot jaduhṉ coo mijts xyhuunghádät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mdóogäp hajxy mäduhṉ̃tiä hajxy mmøødä; mänitä häyoobäyaꞌay hajxy mnäꞌä móꞌowät cøx̱iä. Jaduhṉ mijts hoyhajt weenhajt jim̱ mbáadät tsajpootyp. Cab jaduhṉ pøṉ jim̱ tii xpiǿjcät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Coo jaꞌa Diosmädiaꞌagy hajxy hamuumduꞌjoot mgudiúnät, mbáadäp jaꞌa hoyhajt jaꞌa weenhajt hajxy jaduhṉ. Coo jaꞌa yaabä naax̱wiimbä hajxy mbøcjuǿꞌøwät, cab hajxy tii mbáadät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Mänitä Jesús tiägøøyy mädiaacpä nebiä jiamiøødhajxy nähix̱ hahixøꞌø yhídät coo hänajty quiädaactägatsaꞌañ jadähooc. Mänit miänaaṉ̃: ―Nähix̱ hahixøꞌø hajxy mhídät nebiä homioonsähajxiän coo jaꞌa wyiindsøṉhajxy wyiimbídät mägaabiä mähuucpä maa jaꞌa pøc huꞌug jiadyiijän. Jøønmøød hajxy jaduhṉ yhahix̱y. Coo jaꞌa wyiindsøṉhajxy miech maa jaꞌa tiøjcän, mänit hajxy yajtøjtägøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Pø jujyñä jaꞌa mioonsähajxy hänajty, hoy ja tsuhm̱dä, hoy ja moṉ̃ñä, cumayaam̱bä wyiindsǿṉ jaduhṉ. Tøyhajt jaduhṉ. Høxtä yajcayǿøjäp hajxy jaꞌa yhamdsoo wiindsǿṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Y jaanä jaduhṉduhm̱bä, coo jaꞌa cudøjc jaduhṉ ñajuǿꞌøwät mäduhnajtä jaꞌa meeꞌtspä miédsät, cab jaduhṉ ñäꞌägä maahóꞌogät nebiä meeꞌtspä jaduhṉ quiaꞌa tøjtägǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jaduhṉ mijts nähix̱ hahixøꞌø mhíjpät. Cab hajxy mnäꞌägä najuǿꞌøwät mänáajøch ngädaactägatsaꞌañ, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mänitä Pedro yajtøøyy: ―Wiindsǿṉ, pøṉ miic̈h hädaa myajmøødmädiaacypy, højtsyähajtiä tøgä nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mänitä Jesús yhadsooyy: ―Pøṉ jaduhṉ cudiuum̱b nebiatiä wyiindsǿṉ yhaneꞌemiän, jeꞌeds jaduhṉ hoy copc‑hajp maa jaꞌa wyiindsǿṉ tiøjcän. Coo jaꞌa wyiindsǿṉ maa ñøcxy, jeꞌeduhṉ mähmøøby coo jaduhṉ yajcáyät pøṉ jiiby hijp tøgooty. ");
INSERT INTO mirNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pø cudiuum̱bä copc‑hajpä hänajty hoy, coo jaꞌa wyiindsǿṉ wyiimbijtägátsät, cumayáaṉäp jaduhṉ jaꞌa wyiindsǿṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mänitä wyiindsǿṉ yajnähdijaꞌañii coo jaduhṉ quiopc‑hádät mäduhṉ̃tiä jaꞌa wyiindsǿṉ miøødä cøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero coo jaꞌa copc‑hajpä miänáꞌanät coo jaꞌa wyiindsǿṉ quiaꞌa tsoj medsaꞌañ, coo jaꞌa miämoonsä yhäyoow̱híxät, coo tiägǿꞌøwät huucpä caabiä, coo miuꞌugǿøjät, ");
INSERT INTO mirNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mänitä wyiindsǿṉ miejtstägatsaꞌañ jaguiapxy, mänit jaduhṉ jiaanc̈h tehm̱ chaac̈htiunaꞌañii neby hajxy chaac̈htiuñiijän jaꞌa hajxy caꞌa mäbøjpä. ");
INSERT INTO mirNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Mädyii moonsä jaduhṉ caꞌa mädiaꞌagymiäbøjp, hoy jia najuøꞌøy nebiaty jaꞌa wyiindsǿṉ yhaneꞌemyii, jaanc̈h tehm̱ chaac̈htiunáaṉäp jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero mädyii moonsä caꞌa mädiaꞌagymiäbøjp jeꞌeguiøxpä coo quiaꞌa najuøꞌøy, cab jaduhṉ jiaty tsaac̈htiunaꞌañii. Pøṉ madiuuṉg jaduhṉ yajcøꞌødägǿøyyäp, tsipcøxp jaduhṉ quiudiúnät nebiaty yhaneꞌemyii. ");
INSERT INTO mirNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Páadyhøch yaa tøø ngädaꞌagy hädaa yaabä naax̱wiin nebiä tsip jaduhṉ piädǿꞌøgät. Weenä jäyaꞌayhajxy ñimiädsibøꞌøyii. ");
INSERT INTO mirNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mobadájpøch nhoꞌogaꞌañ. Jiaanc̈h tehm̱ chójpiøch njoot coo paquiä yhabáadät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","52","Páadyhøch yaa tøø ngädaꞌagy hädaa yaabä naax̱wiin nebiä jäyaꞌayhajxy ñimiädsibøꞌøwǿøjät. Cabä jäyaꞌayhajxy jootcujc ñäꞌägä hidaaṉnä. Nimiädsibøꞌøwáaṉäp hajxy tuꞌugtøgooty. Nädägøøgpänaꞌc‑hajxy yajmugaꞌañ jaꞌa nämetspäyaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Miøødnimiädsibøꞌøwáaṉäp jaꞌa tiaj jaꞌa tieedyhajxy. Miøꞌødhoc jiaxieꞌebhajxy ñimiädsibøꞌøwaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mänitä Jesús jaꞌa cuꞌug ñämaayy: ―Coo jaꞌa joc piädøꞌøgy maa jaꞌa xøø quiuhnax̱iän, hijxtahṉd jeꞌe coo tiuꞌuwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y coo jiøømbojy, hijxtahṉd jaduhṉ coo haṉ yhidaꞌañ. Y mnajuøøby hajxy jaduhm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tøyhajt jaduhṉ, mnajuøøby hajxy jaduhṉ nebiä xøø ñaxaꞌañ, pero cab hajxy mnajuøꞌøy tijaty jadáaṉnäp habetáaṉnäp. Hix̱, hamdsoo jaꞌa mjoothajxy quiaꞌa tsocy coo hajxy jaduhṉ mnajuǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Tii hoguiuhdujt hajxy hamdsoo coo mgaꞌa jadaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Coo pøṉ hänajty tøø xñäxøꞌøwøꞌøy, coo hänajty xyajnøcxy hagujc, tuꞌhaamnøcxpä myajtødiägǿꞌøwät. Pø caj, xchúmäp hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Y cab jaduhṉ mdsoj pädsǿm̱ät høxtä coonä mnuuꞌxy myajnähwáꞌadsät pedyii. Jaduhṉ mäwíinäts Dios hajxy xyajcumädów̱ät. ");
INSERT INTO mirNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mänitiä jaꞌa Jesús yhawáaṉäxä coo jaꞌa Pilato jaꞌa Galileabäyaꞌay hänajty näjeꞌe tøø yajyaghoꞌogyii tsajtøghaguuy. Animalyojxpä Galileabäyaꞌayhajxy hänajty. Jaduhṉ hajxy hänajty quiuhdujthaty. ");
INSERT INTO mirNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mänitä Jesús miänaaṉ̃: ―Nej, mmänaam̱b hajxy jaduhṉä, paady yøꞌø hänaꞌc‑hajxy yaghoꞌcä jeꞌeguiøxpä coo maas may jaꞌa pojpä cädieey hajxy hänajty tøø tiuṉ̃ quejee jaꞌa miägunaax̱hajxiä. ");
INSERT INTO mirNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Høøc̈h jaduhṉ mänaam̱b, caj. Y coo mijts jaꞌa mhaxøøgcuhdujt hajxy mgaꞌa najtshixǿꞌøwät, jaduhṉ hajxy mjájpät nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Y yøꞌø hänaꞌc‑hajxy nämajmocxtägøøgpä tøø yhóꞌoguiäbä jim̱ Siloé mänaa jaꞌa møj torre tøø ñähgahbetiän, nej, mmänaam̱b mijts jaduhṉä coo maas may pojpä cädieey hajxy hänajty tøø tiuṉ̃ quejee jaꞌa jiamiøødhajxy jim̱ tsänaabiä Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Høøc̈h jaduhṉ mänaam̱b, caj. Y coo mijts jaꞌa mhaxøøgcuhdujt hajxy mgaꞌa najtshixǿꞌøwät, jaduhṉ hajxy mjájpät nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mänitä Jesús miänáaṉgombä: ―Tsøc mädiáacäm, jii jäyaꞌay piids hijty tuꞌcopc miøødä maa jaꞌa ñaax̱än. Mänit hoy jia hixøꞌøy pø tøø tiøømbety. Cahnä hänajty tiøømbetyñä. ");
INSERT INTO mirNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mänitä mioonsä ñämaayy: “Huug hix̱ yøꞌø piids, tøø ndijy häxøpy tiøømbejnä cudägøøgjomøjt, y cahnä ñäꞌägädä tøømbetyñä. Púx̱äts, xiøøbä jim̱ ñäꞌä naax̱nähdänaꞌay.” ");
INSERT INTO mirNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mänitä mioonsä miänaaṉ̃: “Wiindsǿṉ, ween jiaac tänaꞌay tuꞌjomøjt. Nhuuc näꞌä juhdajtúꞌudyhøch. Nhuuc tsooyǿꞌøyhøch abonohaam. ");
INSERT INTO mirNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wehṉdä jaduhṉ ñäꞌä tøømbédät. Pø caj, mänítøch nbúxät.” ");
INSERT INTO mirNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wiinghoocä Jesús hänajty jiiby yajwiingapxøꞌøy tsajtøgooty. Pooꞌxxiøøjooty hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jiibiä tajjäyaꞌay hänajty tuꞌug. Majmocxtägøøgjomøjt jaꞌa paꞌam hänajty tøø miähäyoy. Jøney jaꞌa mähdiøjc hänajty tøø yagjadyii jaꞌa møjcúꞌujäm; ni cab hänajty hoy ñäꞌägä tøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Coo jaꞌa Jesús jaꞌa tajjäyaꞌay yhijxy, mänit miøjyaax̱y. Mänit miänaaṉ̃: ―Piꞌmaam, tøø jaꞌa mbaꞌam jaduhṉ xñähwaꞌac̈h. ");
INSERT INTO mirNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mänitä Jesús jaꞌa paꞌamjäyaꞌay ñähdooṉ̃. Mänitiä jaꞌa mähdiøjc tiøøyy. Mänit miänaaṉ̃ coo jaꞌa Dios miøjjä jiaanc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mänitä tsajtøjwiindsǿṉ jiootmaꞌty jeꞌeguiøxpä coo jaꞌa Jesús jaꞌa paꞌam yajnajxy jaꞌa pooꞌxxiøøjooty. Mänitä cuꞌug ñämaayy: ―Tädujxøø jaꞌa Dios tøø quiunuuꞌxy coo hajxy ndúuṉämät. Mänitä mbaꞌam hajxy miṉ myajniñähwaꞌac̈hii. Pero cab hajxy myajniñähwaꞌadsǿøjät jaꞌa pooꞌxxiøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mänitä Jesús miänaaṉ̃: ―Mhøhṉdaacp mijts jaduhṉ. Nej, caj mijts mweey mburro hajxy myajnøøhuꞌugy jaꞌa pooꞌxxiøøjootiä. Hoy hajxy hoy mja capxy mja haneꞌemy, cab hajxy hamdsoo hoy mgudiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Y hädaa tajjäyaꞌay, Abraham yhap yhoc hädaaduhṉ. Majmocxtägøøgjomøjt hijty tøø yaghidyii paꞌammøød jaꞌa møjcúꞌujäm. Nej, cábøch jaꞌa cuhdujt hijty nmøødä cooc̈h pooꞌxxiøøjooty tøø nyajnähwaꞌac̈hä. ");
INSERT INTO mirNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mänitä Jesús miädsiphajxy chähdiuuṉ̃. Pero jaꞌa cuꞌug, jaanc̈h tehm̱ xiooṉdaac hajxy jaduhṉ jeꞌeguiøxpä coo jaꞌa Jesús jaꞌa hoy‑yagjuøøñäjatypä hänajty tøø yajcähxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mänitä Jesús miänaaṉ̃: ―Coo jaꞌa Dios jaꞌa miäjaa hänajty yajcähxøꞌøgaꞌañ, jadúhṉhøch nyajmäbaadaꞌañ ");
INSERT INTO mirNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","nebiä habiꞌc mostazapajcän. Coo jäyaꞌay jaduhṉ ñíꞌibät maa jaꞌa ñaax̱än, cøxp jaduhṉ yéegät. Høxtä peꞌeñhädiúnäp jaꞌa muuxyhajxy yhaaꞌxcøxp. ");
INSERT INTO mirNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mänitä Jesús miänáaṉgombä: ―Coo jaꞌa Dios jaꞌa miäjaa hänajty yajcähxøꞌøgaꞌañ, jadúhṉhøch nyajmäbaadaꞌañ ");
INSERT INTO mirNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","nebiä toꞌoxiøjc tsajcaagychooy hajxy yajtuṉ̃än coo tsajcaagy hajxy yhädiuṉ̃. Tägøøgquipxøhñdy jaꞌa harina hajxy yajmäbädaagøꞌøy jaꞌa tsajcaagychooy. Mänit jaduhṉ hoy piädøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mänitä Jesús tiuꞌubøjcy. Jerusalén hänajty ñøcxaꞌañ. Tuꞌhaamnøcxpä jaꞌa Jesús hänajty yajnähixøꞌøy maa jaꞌa cajpthuungän. ");
INSERT INTO mirNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mänitä Jesús miäyajtøøw̱ä: ―Nej, näweeṉ̃tiä hajxy ñähwaꞌadsaꞌañ jaꞌa piojpä cädieeyhajxiä. Mänitä Jesús yhadsooyy: ");
INSERT INTO mirNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Tsipcøxpä Diosmädiaꞌagy hajxy hoy mgudiúnät nebiä cuhdujt hajxy hoy mmøødhádät neby hajxy jim̱ mdägǿꞌøwät tsajpootyp. Nämay hajxy jia wiꞌi tiägøꞌøwaꞌañ, pero cab hajxy hänajty yajtägøꞌøwaꞌañii coo cuhdujt hajxy hänajty quiaꞌa møødä. ");
INSERT INTO mirNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Coo jaꞌa Dios jaꞌa tøjc hänajty tøø yhagøøñä, mänitä tøghagøꞌøw hajxy hänajty jia wiꞌi quiojxnogaꞌañ, pønjaty tøbaꞌam hänajty tøø miähmøꞌøy. Mänit hajxy hänajty jia wiꞌi miänaꞌanaꞌañ: “Dios, yaghawaꞌads yøꞌø tøjc.” Mänitä Dios yhadsowaꞌañ: “Cábøch mijts nhix̱iä.” ");
INSERT INTO mirNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mänit hajxy hänajty miänaꞌanáaṉgombä: “Pero tøøds miic̈h nmøødcay nmøødhuꞌugy; tøøds miic̈h mmädiaꞌagy xyajnähixøꞌøy mänaa jim̱ mhitiän maa højts ngajptän.” ");
INSERT INTO mirNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mänitä Dios hänajty yhadsowáaṉgombä: “Tøø hajxy nnämaꞌay coo hajxy ngaꞌa hix̱iä. Wiimbit hajxy. Caj mijts mguhdujt ñäꞌägä hoyyä.” ");
INSERT INTO mirNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mänitä Abraham hajxy hänajty jim̱ mhixaꞌañ tsajpootyp jim̱ Dioswiinduum møødä Isaac møødä Jacob møødä Diosquex̱yhajxy nägøx̱iä. Mänit hajxy mjøꞌøwaꞌañ mxuudsaꞌañ coo jaꞌa Dios hajxy tøø xquiaꞌa yajtägøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nøcxaam̱bä jäyaꞌayhajxy miägayaꞌañ Dioswiinduum jaꞌa hajxy wiinduhm̱yhagajpt‑tsohm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jaayaꞌayhajxy jädaꞌahaty péjxäbä, näjeꞌe møjtuuṉg hajxy piaadaꞌañ. Y jaayaꞌayhajxy jädaꞌahaty møjtuuṉgmøødpä, näjeꞌe tiuuṉghajxy piøgáaṉäxä. ");
INSERT INTO mirNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mänitxøøbä jaꞌa fariseoshajxy näjeꞌe miejch maa jaꞌa Jesúsän. Mänitä Jesús hajxy ñämaayy: ―Mdsóonäp yaa coo jaꞌa Herodes xjia wiꞌi yajyaghoꞌogaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mänitä Jesús yhadsooyy: ―Caꞌawiindøyyä Herodes jaduhṉ. Nøcx hajxy nämaꞌaw cooc̈h mejtsxøø tägøøgxøø njaac tunaꞌañ. Njaac høxquexáam̱biøch jaꞌa møjcuꞌuhajxy. Njaac yajmøcpøgáam̱biøch jaꞌa paꞌamjäyaꞌayhajxy. Mänítøch nduum̱bädøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Jex̱ioo, mejtsxøø tägøøgxǿøjøch njaac tuꞌuyoꞌoyaꞌañ. Mänítøch jim̱ nmedsaꞌañ Jerusalén. Cab jaduhṉ yhawiinmatsä coo jaꞌa Diosquex̱y wiingtuum yhóꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Mänitä Jesús miänáaṉgombä: ―Jaꞌa hänaꞌc‑hajxy jim̱ tsänaabiä Jerusalén, tøø jaꞌa Diosquex̱y hajxy may quiuhgaꞌac̈h. Tøøc̈h mayhooc nja wiꞌi ñämaꞌay coo jaꞌa yhaxøøgcuhdujt hajxy ñajtshixǿꞌøwät; pero cab hajxy ñäꞌä najtshixøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Cooc̈h jim̱ ngóodät Jerusalén, páquiøch jim̱ nhidaꞌañ. Mänítøch mijts jim̱ nnähgueꞌegáaṉgombä. Cábøch hajxy xyhixaaṉnä høxtä cóonøch hänajty ngädaactägatsaꞌañ. Mänit hajxy hänajty mmänaꞌanaꞌañ: “Jaanc̈h tehm̱ miøj jaanc̈h tehm̱ jiaanc̈h jaꞌa Dios tøø quiéx̱iäbä.” ");
INSERT INTO mirNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wiinghoocä Jesús ñøcxy mägaabiä maa jaꞌa fariseowiindsøṉä tiøjcän. Pooꞌxxiøøjooty hänajty jeꞌe. Jiibiä Jesús hänajty miähijxnaꞌayíijäm tøgooty jaꞌa fariseoshajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jiibiä mähdiøjc hänajty tuꞌug quiꞌixypaꞌammøød. Jesúswiinduum hänajty tiänaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mänitä Jesús miäyajtøøyy jaꞌa ley‑yajnähixøøbiähajxy møødä fariseoshajxy: ―Nej, jii cuhdujt jaduhṉ coo jaꞌa paꞌamjäyaꞌay myajmøcpǿgät pooꞌxxiøøjootiä. ");
INSERT INTO mirNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero cab hajxy waam̱b ñäꞌä hadsooyy. Mänitä Jesús jaꞌa paꞌamjäyaꞌay ñähdooṉ̃, yajmøcpøjcy. Mänit ñämaayy coo wyiimbídät. ");
INSERT INTO mirNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mänitä fariseoshajxy ñämáayyägombä: ―Coo mijts mburro mweey quiugaꞌawǿꞌøwät nøøjutjooty, nej, cab hajxy mänitiä myajpädsǿm̱ädä, hoy hänajty jia pooꞌxxiøøjootiä. ");
INSERT INTO mirNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Cab hajxy waam̱b ñäꞌägä hadsooyy. ");
INSERT INTO mirNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mänitä Jesús yhijxy coo jaꞌa woybä wichpä hoyhäñaabiejt hajxy jia wiꞌi yhøxtaꞌay. Mänit miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Coo jaꞌa pøc jaꞌa huꞌug hänajty mänaa jiadyii, coo mijts myajwówät, cabä hoyhäñaabiejt hajxy myaghäñaꞌawǿꞌøwät. Hix̱, coo hänaꞌc maas cuhdujtmøødpä jiaac médsät, ");
INSERT INTO mirNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","mänitä cudøjc xñämáꞌawät: “Pädøꞌøg, moꞌow yøꞌø häñaabiejt yøꞌø hänaꞌc tøø jiaac méchäbä.” Xyajtsähdiúnäp jaduhṉ. Mänit nøcxy mhäñaꞌay maa jaꞌa häñaabiejt caꞌa hojiatypän. ");
INSERT INTO mirNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pero jayøjp mhøxtáꞌawät jaꞌa häñaabiejt caꞌa hojiatypä. Mänitä cudøjc xñämáꞌawät: “Mäguꞌughajpä, yaa nax̱ maa hädaa häñaabiejt hojiatypän.” Xquiumáyäp jaꞌa jäyaꞌayhajxy jaꞌa hajxy jim̱ häñaabiä. ");
INSERT INTO mirNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pøṉ ja wiꞌi yajcumayaam̱b, yajpexaam̱b jeꞌeduhṉ. Pøṉ caꞌa yajcumayaam̱b, jeꞌeds jaduhṉ møjtägøꞌøwaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mänitä Jesús jaꞌa fariseowiindsǿṉ ñämaayy, jaꞌa hänajty tøø miäwóyyäbä: ―Coo jaꞌa tsuunax̱ hänajty mänaa myagjadaꞌañii, cabä mmäguꞌughajpähajxy mwówät, ni jaꞌa mbuhyaꞌayhajxy, ni jaꞌa mjujy jaꞌa mmäguꞌughajxy, ni jaꞌa mmäjøøn jaꞌa mmädøjc‑hajxy jaꞌa mäyøøbä. Xwioodägátsäp hajxy jeꞌe jaꞌa miic̈h hänajty tøø mwóyyäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero jeꞌeds mwówäp jaꞌa häyoobä, jaꞌa caꞌa hoybä, jaꞌa tecymiaꞌadpä, jaꞌa wiindspä. ");
INSERT INTO mirNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Hoy miic̈h jaduhṉ xquiaꞌa ja woodägátsät, jootcujc mhídät jadähooc jeꞌeguiøxpä coo jaꞌa hoyhajt jaꞌa weenhajt mbaadaꞌañ mänaa jaꞌa jäyaꞌayhajxy hänajty jiujypiøjtägatsaꞌañän, jaꞌa Diosmädiaꞌagy hajxy hänajty tøø quiudiúṉ̃äbä. ");
INSERT INTO mirNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jim̱ä jäyaꞌay hänajty tuꞌug yhäñaꞌay meexäwiinduum. Mänitä Jesús ñämaayy: ―Jootcujc jeꞌe, pøṉ mägayaam̱b Dioswiinduum. ");
INSERT INTO mirNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mänitä Jesús miänaaṉ̃: ―Tsøc mädiáacäm. Jaduhṉä jäyaꞌay tsuunax̱ tuꞌug yagjajtä. Mänitä jäyaꞌay may yajwoow̱ä. ");
INSERT INTO mirNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Coo hänajty tøø yhabaady, mänitä mioonsä ñämaayy: “Nøcx jaꞌa woybä wichpähajxy nämaꞌaw coo hajxy yhadǿꞌødsät, coo jaꞌa cay tøø yhabaatnä.” ");
INSERT INTO mirNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero mänit hajxy nägøx̱iä yhadsooyy cooc hajxy quiaꞌa näbaadøꞌøwáaṉäxä. Tuꞌjäyaꞌay miänaaṉ̃: “Tøøc̈hä naax̱ njuy; nøcxáam̱bøch cham̱ nhixaꞌañ. Huuc meeꞌx, cábøch xñäbaadøꞌøwaaṉä.” ");
INSERT INTO mirNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mänit wiingpä miänáaṉgombä: “Tøøc̈hä waj njuy mägoox̱mancuerno. Jeꞌec̈h nøcxy nyajtuuṉghabøgaꞌañ. Huuc meeꞌx, cábøch xñäbaadøꞌøwaaṉä.” ");
INSERT INTO mirNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mänitä wiingpä jiaac mänáaṉgombä: “Naam̱bǿcyhøch høøc̈h; páadyhøch ngaꞌa nøcxaꞌañ mägaabiä.” ");
INSERT INTO mirNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Coo jaꞌa moonsä wyiimbijtägajch, mänit jeꞌe cøjx ñägapxy waam̱baty hajxy yhadsooyy. Mänitä wyiindsǿṉ jiaanc̈h tehm̱ jiootmaꞌty. Mänitä mioonsä ñämáaguiombä: “Nøcx jim̱ päyøꞌøguiä maa jaꞌa møjtuꞌujän. Pønjaty jim̱ mbaatyp, jaꞌa häyoobä, jaꞌa caꞌa hoybä, jaꞌa tecymiaꞌadpä, jaꞌa wiindspä, jeꞌe jaduhṉ mwoomínäp.” ");
INSERT INTO mirNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Coo jaꞌa moonsä jadähooc wyiimbijtägajch, mänit miänaaṉ̃: “Wiindsǿṉ, Tøøc̈h ngudiuṉ̃ nébiøch miic̈h tøø xyhaneꞌemiän. Pero xiinä hawaꞌadspä.” ");
INSERT INTO mirNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mänitä wyiindsǿṉ yhadsooyy: “Nøcx jim̱ maa jaꞌa xuꞌudstuꞌujän, maa jaꞌa paduꞌujän; pønjaty jim̱ najxp, mnämáꞌawäp hadsip coo hajxy myínät, nébiøch ndøjc jaduhṉ yhúdsät. ");
INSERT INTO mirNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pero pønjátyhøch tøø nja yajwoyii, cab hajxy miṉ quiayaꞌañ maac̈h ndsuunax̱ nyagjadyiijän.” ");
INSERT INTO mirNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nämayyä jäyaꞌay jaꞌa Jesús hänajty pianøcxy. Mänitä Jesús wiaꞌwiimbijty. Mänit miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","27","―Pønjátyhøch xpianøcxaam̱b, wéenhøch xmiaas tsocy quejee jaꞌa tiaj jaꞌa tieedyhajxy chocy, møødä yhuch jaꞌa piuhyaꞌay; quejee jaꞌa yhuungä tioꞌoxy chocy. Pø caj, cábøch hoy xpianǿcxät. Pøṉ jaꞌa jiugyhajt caꞌa nähdujp, cábøch jaduhṉ hoy xpianǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Coo pøṉä tøjc hänajty quiojaꞌañ, jayøjpä xiädøꞌøñ miäc̈hoy pø pedáaṉäp jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pø caj, mänit jaduhṉ ñäxiꞌigǿøjät coo hänajty quiaꞌa mayaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Jaduhṉ hajxy miänáꞌanät: “Xiøøbä yøꞌø craa ñäꞌä yajtsohṉdaacy; maa jaduhṉ ñäꞌä yajmaayy.” ");
INSERT INTO mirNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Coo jaꞌa reyhajxy hänajty ñimiädsibøꞌøwaꞌañii, jayøjp hajxy yhahixøꞌøy pø mäjädaꞌagaam̱b coo nämajcmil soldado jia møødä, coo jaꞌa miädsip jaꞌa soldado nähiiꞌxmil miøødä. ");
INSERT INTO mirNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pø caj, jäguem̱iä jaꞌa quiuguex̱y quiéxät weenä miädsip jaduhṉ mieeꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jaanä jaduhṉ mijtspä, coo hajxy cøx̱iä wiinä mgaꞌa najtshixǿꞌøwät jaꞌa høøc̈hcøxpä, cábøch hajxy hoy xpianǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Tuuṉgpaatpä caan hit. Pero coo jiǿꞌøwät, cab jaduhṉ mänaa yhoyǿøñät. ");
INSERT INTO mirNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Cab jaduhṉ tiuuṉgpaadaaṉnä. Näꞌä tägooby jaduhṉ. Pø mwiinjuøøby hajxy, wéenhøch hädaa nmädiaꞌagy xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mänitä Jesús ñämejtsä jaꞌa yajnähjuudiuutpähajxy nämay møødä cubojpä cugädieeybähajxy. Miädow̱aam̱biä miädiaꞌagy hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mänitä fariseos jaꞌa Jesús hajxy tiägøøyy mädiaacpä møødä ley‑yajnähixøøbiähajxy: ―Cab jaduhṉ yhoyyä coo yøꞌø craa jaꞌa cubojpä jaꞌa cugädieeybä miäguꞌughádät, coo miøødcáyät. ");
INSERT INTO mirNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mänitä Jesús tiägøøyy mädiaacpä: ");
INSERT INTO mirNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Tsøc mänáaṉäm, pøṉ meeg hänajty møød mägoꞌx, coo tuꞌug tiägóyyät, nej, cabädaꞌa nägøꞌø nädecypiä mhøxtáꞌawädä. ");
INSERT INTO mirNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y coo mbáadät, mänit mxooṉdáꞌagät. Mänitä meeg mdsehṉǿꞌøgät. Mänit mdsehṉnǿcxät maa jaꞌa mdøjcän. ");
INSERT INTO mirNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Coo jim̱ mmédsät, mänit mmäjøøn mmädøjc mwoomúgät møødä mmäguꞌughajpähajxy. Mänit mmänáꞌanät: “Tsøg hajxy xooṉdáacäm; tøøc̈hä meeg nbaady jaꞌa hijty tøø tiägóyyäbä.” ");
INSERT INTO mirNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tøyhajt, jaanä jaduhṉ hajxy jim̱ xiooṉdaꞌagaam̱bä tsajpootyp coo jaꞌa cubojpä cugädieeybä yhaxøøgcuhdujt hajxy ñajtshixǿꞌøwät. Jaꞌa jaac nämädaax̱c‑hiiꞌx‑cumajmocxmädaax̱c jäyaꞌayhajxy, jaꞌa hijty tøø quiaꞌa tuꞌudägóyyäbä, cab hajxy jiaty näxooṉdaꞌagaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Tsøg jaac mänáaṉäm, mädyii toꞌoxiøjc xädøꞌøñ majc møød, coo tuꞌug tiägóyyät, mänitä jøøn quiudøøꞌxøꞌøy. Mänit tiägøꞌøy tøjpeetpä hodiaꞌagyhaamby, cham̱ jaduhṉ yhøxtaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Coo jaꞌa xädøꞌøñ piaady, mänitä miäjøøn miädøjc wioomucy møødä miäguꞌughajpähajxy. Mänit miänaꞌañ: “Tsøg hajxy xooṉdáacäm; tøøc̈hä xädøꞌøñ nbaady jaꞌa hijty tøø tiägóyyäbä.” ");
INSERT INTO mirNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tøyhajt jaduhṉ, jaanä jaduhṉ jaꞌa Diosmoonsähajxy jim̱ xiooṉdaꞌagaam̱bä tsajpootyp coo jaꞌa cubojpä cugädieeybä yhaxøøgcuhdujt hajxy ñajtshixǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mänitä Jesús jadähooc miänáaṉgombä: ―Tsøc mädiáacäm, jaduhṉä jäyaꞌay hänajty tuꞌug, metsc yhuung. ");
INSERT INTO mirNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mänitä muutspä ñämaayy jaꞌa tieedy: “Teedy, høøc̈hä xädøꞌøñ móoyyäc mädúhṉ̃tiøch hijty tøø xyajnähdijy.” Mänitä yhuunghajxy miooyy jaꞌa xädøꞌøñ. ");
INSERT INTO mirNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Cujaboom cumaax̱cä craa muutspä tiuꞌubøjnä. Cøjxä xiädøꞌøñ miäduꞌubøcy. Mänit ñøcxy jäguem̱naax̱. Mänitä xiädøꞌøñ cøjx ñähaduṉ ñähanämaꞌawøꞌøy. Haxøøg hänajty wiädity. ");
INSERT INTO mirNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Coo jaꞌa xiädøꞌøñ hänajty tøø quiøjxnä, mänitä yuu miejch maa jaꞌa craa hänajtiän. Mänitä yuu hoyhoy piáatänä. ");
INSERT INTO mirNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mänitä tuuṉg hoy piaady mähädsøm̱yagjøøꞌx. ");
INSERT INTO mirNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jia wiꞌi jiøøꞌxaam̱by hänajty jaꞌa hädsøm̱ hänajty jiøøꞌxypä, pero cab hänajty tii ñäꞌägä moꞌoyii. ");
INSERT INTO mirNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mänit wyiinmahñdymejch: “Jim̱ maac̈h ndeedy tiøjcän, jaanc̈h tehm̱ quiuꞌuxiä jaꞌa moonsähajxy jim̱ quiay yhuꞌugy. Y høøc̈h, cooc̈h yaa nmähmǿꞌøwät, yuuhóꞌogäbøch häyaa. ");
INSERT INTO mirNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nnäꞌägä nǿcxyhøch jim̱ maac̈h ndeedy tiøjcän. Jadúhṉhøch nnämaꞌawaꞌañ: Teedy, tøøc̈h ngädieey jaꞌa Dioscøxpä møødä miic̈hcøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cábøch miic̈h hawiinmats xyhuunghájnät. Hóyhøch miic̈h xñäꞌä wáꞌanät moonsä.” ");
INSERT INTO mirNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mänitä craa wyiimbijty, ñøcxtägajch maa jaꞌa tieedy tiøjcän. ’Møjnä hänajty quiaꞌa mech, mänitä tieedy jiøjcuheebøøyyä. Mänitä tieedy jioot xiuuꞌtspøjcy jadähooc. Mänit päyøꞌøguiä hoy jiøjcubaadøꞌøy. Mänit ñähmäneeṉ̃ quiuhmäneeṉ̃. Mänit chuꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mänitä yhuung miänaaṉ̃: “Teedy, tøøc̈h ngädieey jaꞌa Dioscøxpä møødä miic̈hcøxpä. Cábøch miic̈h hawiinmats xyhuunghájnät.” ");
INSERT INTO mirNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mänitä tieedy jaꞌa moonsä tuꞌug ñämaayy: “Tsógäm, nøcx jaꞌa howyit yajpädsøm̱. Yajniguiubøgøø. Pädaacä cøꞌøjädsøhñdy tuꞌug møødä xäguiøꞌøg. ");
INSERT INTO mirNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nøcxä wajhuung hajxy yaghoꞌog jaꞌa niꞌxpä. Tsøgä xøø hajxy yagjájtäm. Tsøg hajxy caayy tsøg hajxy húucäm. ");
INSERT INTO mirNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Jadúhṉhøch hädaa nhuung hijty nebiä hoꞌogypiän nebiä tägoybän. Pero tøøc̈h jadähooc xyhajuøꞌøyii. Y chaac̈h tøø xñämech.” Mänitä xøødsuu hajxy yagjajtä. ");
INSERT INTO mirNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Jaꞌa craa møjpä, jim̱ hänajty jeꞌe camjooty. Mänit wyiimbijty. Coo hänajty miedsaaṉnä maa tøjcän, mänit miädooyy coo hajxy wyiꞌi xiuꞌuxy, coo hajxy wyiꞌi yhech wyiꞌi piuty. ");
INSERT INTO mirNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mänitä moonsä tuꞌug miøjyaax̱y. Mänit miäyajtøøyy: “Tii jaduhṉ jájtäp.” ");
INSERT INTO mirNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mänit ñämaayyä: “Tøø jaꞌa mhuch miech hoy ween. Paadiä mdeedy jaꞌa wajhuung niꞌxpä tøø yajyaghoꞌogyii.” ");
INSERT INTO mirNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mänitä craa møjpä jiootmaꞌty. Cab hänajty tiøjtägøꞌøwaꞌañ. Mänitä tieedy tiøjpädsøøm̱y. Mänit hoy miänuuꞌxtaꞌagyii coo tiägǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mänitä craa jaꞌa tieedy ñämaayy: “Tøøc̈h miic̈h majiomøjt nja møødtuṉ̃. Homiänáajøch miic̈h mmädiaꞌagy tøø nmäbǿjcäm. Pero cábøch miic̈h mänaa tii tøø xñäꞌägä moꞌoy, nébiøc̈hä xøø jaduhṉ nyagjadǿøjät mǿødhøch nmäguꞌughajpädøjc‑hajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero xiidsä mhuung tøø miech. Tøø miic̈h mxädøꞌøñ xñäꞌä yaghäyøꞌcä maa jaꞌa cuhhiṉdoꞌoxiøjcän. Y yøꞌø craagøxpä miic̈hä wajhuung niꞌxpä tøø myajyaghoꞌogyii.” ");
INSERT INTO mirNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mänitä tieedy miänaaṉ̃: “Huung, homiänáajøch miic̈h tøø xmiøødhity. Y haagä miic̈h mjeꞌe jaduhṉ mädúhṉ̃tiøch jii nmøødä. ");
INSERT INTO mirNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero hawiinmats jaduhṉ coo jaꞌa xøø nyagjájtämät, coo nxooṉdáacämät, jeꞌeguiøxpä coo yøꞌø mhuch tøø miech. Jaduhṉ hijty nebiä hoꞌogypiän nebiä tägoybän. Pero tøøds jadähooc xyhajuǿøyyäm.” ");
INSERT INTO mirNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mänitä Jesús jaꞌa jiamiøød ñämaayy: ―Jaduhṉdsä mäyøøjäyaꞌay hänajty tuꞌug. Mänit hoy yhawáaṉäxä coo jaꞌa xiädøꞌøñ hänajty yajtúuṉäxä jaꞌa mioonsä. ");
INSERT INTO mirNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mänitä mioonsä miøjyaax̱y: “Nej, tøyhajt jaduhṉ cooc̈h miic̈h jaꞌa nxädøꞌøñ xwyiꞌi yajtúuṉäjä. Hoorä, høøc̈h móoyyäc mädúhṉ̃tiøch miic̈h hijty tøø nyajcøꞌødägøꞌøy. Cábøch miic̈h nmoonsähadaaṉnä.” ");
INSERT INTO mirNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mänitä craa tiägøøyy tajpä maabiä: “Nébiøch jaduhṉ nnäꞌä jatcǿꞌøwät. Xpiøgáaṉäbøch jaꞌa nduuṉg jaduhṉ. Cábøch møcmäjaa nmøødä cooc̈h nyuꞌuw cooc̈h nbúxät. Tsähdiúnäbøch jaduhṉ cooc̈h ndägǿꞌøwät xädøꞌøñyujwaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tøøc̈h nnajuøꞌøy nébiøch njatcǿꞌøwät, nébiøc̈hä jäyaꞌayhajxy xtiøjmóꞌowät, cooc̈h nduuṉg hänajty tøø xpiøjcä.” ");
INSERT INTO mirNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mänit tuꞌugjaty tuꞌugjaty miøjyaax̱y pønjaty jaꞌa wyiindsǿṉ hänajty mänuuꞌxyhajp. Mänitä tuꞌjäyaꞌay jayøbajt miäyajtøøyy: “Mädúhṉ̃tiøch yøꞌø nwiindsǿṉ xmiänuuꞌxiä.” ");
INSERT INTO mirNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mänit yhadsooyy: “Mägoꞌxlatä acéitøch nmänuuꞌxiä.” Mänitä craa miänaaṉ̃: “Hädaa nocy jaduhṉ mänaam̱b coo miic̈h mägoꞌxlatä mmänuuꞌxyhaty. Chaadsä nocy wiingpä. Huug hädiuuṉdägats coo juxychäguiꞌxmajc‑latä mmänuuꞌxyhaty.” ");
INSERT INTO mirNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mänitä tuꞌug miäyajtǿøgombä: “Míic̈häts, mäduhṉ̃tiä mnuuꞌxy.” Mänit yhadsooyy: “Mägoꞌxquipxǿhñdyhøc̈hä trigo nmänuuꞌxyhaty.” Mänitä craa miänaaṉ̃: “Chaadsä nocy wiingpä. Huug hädiuuṉdägats coo mädaax̱c‑hiiꞌx mmänuuꞌxyhaty.” ");
INSERT INTO mirNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Manitä mäyøøjäyaꞌay jaꞌa mioonsä quiumaayy coo quiuhwijjiä. Maas cuhwijy jaꞌa Diosmädiaꞌagy hajxy caꞌa mäbøjpä maa jaꞌa tiuuṉghajxiän quejee yøꞌø Diosmädiaꞌagy hajxy mäbøjpä. ");
INSERT INTO mirNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Tsipcøxpä xädøꞌøñ quiøxaꞌañ hädaa yaabä naax̱wiin. Myajtúnäp hajxy jaduhṉ nebiä jäyaꞌay hajxy jaduhṉ xmiäguꞌughádät. Coo hänajty tøø mhoꞌnä, mänitä Dios jim̱ xwyiingpǿgät tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Pøṉä xädøꞌøñ hoy yajtuum̱b, hoy jia weeṉ̃tiä, coo jaꞌa xädøꞌøñ hänajty miayyä, mänit hoy yajtúuṉgombät. Pero pøṉä xädøꞌøñ hoy caꞌa yajtuum̱b coo hänajty weeṉ̃tiä, ni jaduhṉ hoy quiaꞌa yajtúnät coo hänajty miayyä. ");
INSERT INTO mirNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jaduhṉds jeꞌe, coo mijts jaꞌa xädøꞌøñ hoy mgaꞌa yajtúnät hädaa yaabä naax̱wiin, caj mijts jaꞌa Dios xyajcøꞌødägǿꞌøwät mädyii jaanc̈h tsoobaadaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Y coo wiingjäyaꞌay xiädøꞌøñ hajxy hoy mgaꞌa yajtúuṉät, cabä hoyhajt jaꞌa weenhajt hajxy jim̱ mbáadät tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Coo jaꞌa moonsä jaꞌa wyiindsǿṉ metsc miädúnät, jaꞌa tuꞌjäyáꞌayäbä, jeꞌe miädiaꞌagy hoy quiudiúuṉäp; jaꞌa tuꞌjäyáꞌayäbä, cabä miädiaꞌagy miäbǿjcät. Jaanä jaduhṉduhm̱bä, coo jaꞌa xädøꞌøñ hajxy mwiꞌi chógät, cabä Dios hajxy hoy mmädúnät. ");
INSERT INTO mirNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jim̱ä fariseoshajxy hänajty näjeꞌe miämädoonaꞌay. Jiaanc̈h tehm̱ piøcjuøøbiä fariseos jaꞌa xädøꞌøñ hajxy hänajty. Mänitä Jesús hajxy ñäxiicy. ");
INSERT INTO mirNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mänitä Jesús miänaaṉ̃: ―Mijts, mjaanc̈h tehm̱ yajcumayaam̱b hajxy jaduhṉ maa jaꞌa cuꞌughagujcän. Pero xñajuǿøyyäp jaꞌa Dios jaꞌa mwiinmahñdyhajxy. Mädyiijaty jaꞌa jäyaꞌayhajxy quiumaaby, jeꞌedsä Dios jaduhṉ piejxyp. ");
INSERT INTO mirNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Jaꞌa Moisés miädiaꞌagy hijty cudiúuṉäxäp møødä Diosquex̱y miädiaꞌagyhajxy. Pero coo jaꞌa Juan jaꞌa Diosmädiaꞌagy tiägøøyy yajwaꞌxpä, nägøx̱iä jäyaꞌayhajxy jia wiꞌi tiägøꞌøwaꞌañ maa jaꞌa Diosmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Pero cabä Moisés miädiaꞌagy tiägoyyaꞌañ. Maas paquiä jaꞌa tsajpootyp tiägóyyät møødä naax̱wiin quejee jaꞌa Moisés miädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Pøṉä tioꞌoxiøjc høxmajtsp, tuꞌudägooby jaduhṉ coo wiingtoꞌoxiøjc wyiingpǿjnät. Jaanä jaduhṉ tiuꞌudägoobiä pøṉä toꞌoxiøjc wiingpøjp jaꞌa tøø yhøxmac̈híijäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Jaduhṉdsä mäyøøjäyaꞌay hänajty tuꞌug. Jaanc̈h tehm̱ yajxóṉ jaꞌa wyit hänajty miøødhaty. Jabom̱‑jabom̱ jaꞌa xøø hänajty yagjadyii jaanc̈h tehm̱ yajxóṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jim̱ä mähdiøjc hänajty tuꞌug xiøhaty Lázaro. Jaanc̈h tehm̱ ñähbuꞌuds jaanc̈h tehm̱ quiuhbuꞌudsä Lázaro hänajty. Jim̱ nax̱y yhäñaꞌay naax̱wiin maa jaꞌa mäyøøhänaꞌc tiøghaawän. ");
INSERT INTO mirNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Jeꞌe jaꞌa Lázaro hänajty jia wiꞌi quiayaam̱by tijaty jiiby cahb naax̱wiin maa jaꞌa mäyøøjäyaꞌay mieexän. Høxtä nähwéhyyäxäbä Lázaro piuꞌuds hänajty jaꞌa húcäm. ");
INSERT INTO mirNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mänitä Lázaro yhoꞌnä. Mänitä yháañämä yajnǿcxäxä tsajpootyp maa jaꞌa Abraham wyiinduumän. Jaꞌa Diosmoonsä yajnøcx. Mänitä mäyøøjäyaꞌay yhoꞌpä. Mänit yajnaax̱tägøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mänitä yháañämä yhädaacy møjcuꞌuhaam. Mänit tiägøøyyä tsaac̈htiúuṉäbä. Mänit chajheeꞌpy. Jim̱ä Abraham ñäheebøøyy møødä Lázaro. ");
INSERT INTO mirNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mänit yaax̱y: “Abraham, høøc̈h näxúuꞌtsäc. Høøc̈hä Lázaro yajnäguéjxäc. Weenä quiøꞌøjøjp yajxoogy wéenhøch ndoots miṉ xyajtøjtsä. Jaanc̈h tehm̱ chaac̈hpǿjpøch yaa jøønjooty.” ");
INSERT INTO mirNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mänitä Abraham yhadsooyy: “Huung, jahmiets jaduhṉ nej tøø mdsänaꞌay nej tøø mhäyoyyän yajxóṉ. Pero Lázaro, jaanc̈h tehm̱ yhäyoob jeꞌe hijty. Pero coo yaa tøø quiooꞌnä, jootcujc yhijnä. Míic̈häts jiiby tsaac̈hpǿjnäp. ");
INSERT INTO mirNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Y chaads jeꞌebä, cabä najxtaact maa, coo jaꞌa Lázaro jiiby yhädáꞌagät, ni coo miic̈h yaa mbédät.” ");
INSERT INTO mirNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mänitä mäyøøjäyaꞌay miänaaṉ̃: “Abraham, tuṉä mayhajt, huuc quex̱ jaꞌa Lázaro jim̱ maac̈h ndeediän. ");
INSERT INTO mirNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mägóox̱c‑høch nbuhyaꞌay jim̱. Weenä Lázaro nøcxy ñämaꞌay coo jaꞌa yhaxøøgcuhdujt hajxy ñajtshixǿꞌøwät, neby hajxy yaa miṉ quiaꞌa tsaac̈hpǿjpät.” ");
INSERT INTO mirNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mänitä Abraham miänaaṉ̃: “Jim̱ hajxy jeꞌe miøødä jaꞌa Moisés miädiaꞌagy møødä Diosquex̱y miädiaꞌagyhajxy. Jeꞌe hajxy quiudiúnäp.” ");
INSERT INTO mirNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mänitä mäyøøjäyaꞌay miänáaṉgombä: “Abraham, tøyhajt jaduhṉ, pero coo jaꞌa hoꞌogyjiäyaꞌay jim̱ miédsät maac̈h ndeedyhajxiän, mänit mäbøcypiä yhaxøøgcuhdujt hajxy ñajtshixǿꞌøwät.” ");
INSERT INTO mirNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mänitä Abraham yhadsóogombä: “Pø cab hajxy quiudiunaꞌañ nebiä Moisés jia hanehm̱iän, nebiä Diosquex̱yhajxy jia hanehm̱iän, nej, jeꞌe hajxy nøcxy ñäꞌä mäbøquiä coo jaꞌa hoꞌogypiä jia médsädä.” ");
INSERT INTO mirNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Mänitä Jesús jaꞌa jiamiøød ñämaayy: ―Tsipcøxpä jäyaꞌay hajxy xjia wiꞌi yajtuꞌudägoyyaꞌañ. Pero pøṉ jaduhṉ jatcøøby, haxøøg jiadaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","3","Nägüeentä hajxy mwädítät. Coo pøṉ yøꞌø pigänaꞌc yajtuꞌudägóyyät, haxøøg jaduhṉ jiádät. Mejor ñäꞌägä mejjwyipøꞌøwǿøjät molinopaanyoꞌxodsøꞌøy. ’Coo jaꞌa mbuhyaꞌay xñägädieeyǿꞌøwät, mhójäp jaduhṉ. Y coo xñämáꞌawät coo mméeꞌxät, mméeꞌxäp jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Coo juxtujc‑hooc xñägädieeyǿꞌøwät tuꞌxøøbä, y coo juxtujc‑hooc xñämáꞌawät coo quiaꞌa jatcøꞌøwaaṉnä jaduhṉ, mméeꞌxäp jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mänitä Jesús ñämaayyä jaꞌa jiamiøødhajxy: ―Højtsä mäjaa jaac móoyyäc neby højts maas hoy nmäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mänitä Jesús yhadsooyy: ―Coo mijts häxøpy mmäbøcy hoy jia tuꞌliiꞌxiä, coo yøꞌø quepychaa hajxy mnämáꞌawät coo nøcxy ñimiejjwyipøꞌøyii, xquiudiúuṉäbä mmädiaꞌagyhajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Tsøg jaduhṉ mänáaṉäm, coo jaꞌa mmoonsä tuꞌug wyiimbídät camjooty, nej, jaduhṉ mnämáꞌawädä: “Miṉ cay.” ");
INSERT INTO mirNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Caj pues, cab jaduhṉ mnämáꞌawät. Jaduhṉ mnämáꞌawät: “Høøc̈h njøøꞌxy hädiúuṉäc, høøc̈h puhbéjtäc maac̈h cham̱ ngayaꞌañ nhuꞌugaꞌañän. Mänit miic̈h häyaa høx̱haam mgáyät mhúꞌugät.” ");
INSERT INTO mirNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ni mgaꞌa Diosmóꞌowät coo jaꞌa mmädiaꞌagy hänajty tøø xquiudiuuṉä. ");
INSERT INTO mirNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jaanä jaduhṉ mijtspä, coo hajxy hänajty tøø mgudiuṉ̃ nebiatiä Dios hänajty tøø xyhaneꞌemiän, jaduhṉä Dios hajxy mnämáꞌawät: “Cab højts hawiinmats xmióꞌowät Dioscujúꞌuyäp. Jaduhyyä højts tøø ngudiuṉ̃ neby højts miic̈h tøø xyhaneꞌemiän” ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tuꞌuyóhñäbä Jesúshajxy hänajty. Jerusalén hajxy hänajty ñøcxy. Mänit hajxy jim̱ miejch maa jaꞌa Samarianaax̱ miøødnibiaadyiijän jaꞌa Galileanaax̱. ");
INSERT INTO mirNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mänit hajxy miejch maa jaꞌa cajpthuung tuꞌugän. Mänitä Jesús jiøjcubaadøøyyä jaꞌa hänaꞌc nämajcpä jaꞌa haxøøgpuꞌudsmøødpä. Pero cabä Jesús wiingóṉ tiehm̱ ñämejtsä. ");
INSERT INTO mirNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Mänit hajxy yaax̱y: ―Jesús, Wiindsǿṉ, højts näxúuꞌtsäc. ");
INSERT INTO mirNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Coo jaꞌa Jesús jaduhṉ yhijxy, mänit miänaaṉ̃: ―Nøcx hajxy niyajcähxøꞌøgøø maa jaꞌa teedyhajxiän. Coo hajxy wyiimbijty, mänit hajxy cøjx ñähwaꞌac̈h jaꞌa piuꞌuds. ");
INSERT INTO mirNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Coo hajxy yhijxy coo hajxy hänajty tøø ñähwaꞌac̈h, mänit tuꞌjäyaꞌay wyiimbíjcumbä. Mänit møc yaax̱y coo jaꞌa Dios miøjjä jiaanc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mänitä Jesús hoy wyiinjijcädaꞌagy. Høxtä mägujtscädaac naax̱wiin. Mänitä Jesús Dyiosmooyy. Samaria jaꞌa craa hänajty chooñ. ");
INSERT INTO mirNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mänitä Jesús miänaaṉ̃: ―Nämajc ndijy hajxy tøø ñähwaꞌac̈h. Maa jaꞌa jiamiøødhajxy jaꞌa nädaax̱tujcpä. ");
INSERT INTO mirNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Jagooyyä hädaa craa nidiuhm̱ tøø wyiimbity Diospaꞌyaax̱pä, y Samaria chooñ. ");
INSERT INTO mirNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mänitä Jesús jaꞌa craa ñämaayy: ―Tänaayyøꞌøg, nøcxnä. Coo tøø mmäbøcy, paadiä mbuꞌuds tøø choꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mänitä fariseos jaꞌa Jesús hajxy miäyajtøøyy mänaa hänajty yhabaadaꞌañ coo jaꞌa Dios jaꞌa miäjaa hänajty yajcähxøꞌøgaꞌañ. Mänitä Jesús yhadsooyy: ―Cab jaduhṉ yaghixaꞌañ mänaa jaduhṉ yhabaadaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Cab hajxy jaduhṉ miänaꞌanaꞌañ: “Xiids jeꞌe”, o “Chaads jeꞌe.” Tøø yhabaatnä coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mänitä Jesús jaꞌa jiamiøød ñämaayy: ―Habaadaam̱b jaduhṉ cooc̈h mijts xjia wiꞌi yhijxtägatsaꞌañ, høøc̈h jaꞌa Diosquex̱ypä; pero cábøch hajxy xyhixaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mänitä cuꞌughajxy miänaꞌanaꞌañ cóogøch tyijy tøø ngädaꞌagy; pero cab hajxy mmäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jadúhṉhøch ngädaꞌagaꞌañ nebiä wädsucän coo xim̱ yam̱ tiägøꞌøy hajajpä. ");
INSERT INTO mirNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero jaanc̈h tehm̱ chaac̈hpøgáam̱bøch jayøjp. Cábøch jäyaꞌayhajxy xmieeꞌxaꞌañ jaꞌa hajxy jädaꞌahatypä. ");
INSERT INTO mirNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Cooc̈h hänajty ngädaactägatsaꞌañ, jaduhṉä jäyaꞌayhajxy hänajty jiatcøꞌøwaꞌañ nebiä jecyjiäyaꞌayhajxy hänajty jiatcøꞌøyän mänaa jaꞌa Noé hänajty jyiijän. ");
INSERT INTO mirNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wiꞌi quiaaby wiꞌi yhuucp hajxy hänajty, wiꞌi piøjp wiꞌi yhuucp hajxy hänajty. Mänitä Noé tiägøøyy barcojooty. Mänitä Dios jaꞌa nøøgom̱dägoy quiejxy. Cøjx hajxy jaduhṉ yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jaduhṉ hajxy hänajty jiatcøøbiä mänaa jaꞌa Lot hänajty jyiijän. Wiꞌi quiaaby wiꞌi yhuucp hajxy hänajty, wiꞌi jiuuby wiꞌi tiooꞌp hajxy hänajty, wiꞌi ñiip hajxy hänajty, wiꞌi tiøjcojp hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Coo jaꞌa Lot jim̱ chohṉ̃ maa jaꞌa Sodomacajptootiän, mänitä jøøn tiägøøyy cahbä møødä azufre. Cøjxä jäyaꞌayhajxy yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jaduhṉä jäyaꞌayhajxy hänajty jiatcøꞌøwáaṉgombä cooc̈h hänajty ngädaactägatsaꞌañ, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Mänitxøø, pøṉ hänajty hijp tøjwiing, caj tiøjtägǿꞌøwät coo cøx̱iä wiinä yajpädsǿm̱ät; jaduhyyä piäyǿꞌøgät. Y pøṉ hänajty hijp camjooty, caj wyiimbídät maa jaꞌa tiøjcän; jaduhyyä tiuꞌubøjtǿwät. ");
INSERT INTO mirNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Høxtahm̱dsä Lot tioꞌoxiøjc jiajty. ");
INSERT INTO mirNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pøṉä jiugyhajt hädaa yaabä naax̱wiin ja wiꞌi yaghoyøꞌøwaam̱b, haxøøgtuum piädaꞌagaꞌañii. Pero pøṉä jiugyhajt nähdugaam̱b, hodiuum jeꞌe ñäꞌägä nøcxaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Tøyhajt jaduhṉ, mänitcoods, nämetsc hajxy hänajty miaꞌawaꞌañ tuꞌugmaabejt. Tuꞌug yajnøcxaꞌañii, tuꞌug yajmähmøꞌøwaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jaduhṉä toꞌoxiøjc‑hajxy hänajty jiøjtspä nämetsc. Tuꞌug yajnøcxaꞌañii, tuꞌug yajmähmøꞌøwaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jaduhṉä yaꞌadiøjc‑hajxy hänajty nämetsc tiuum̱bä camjooty. Tuꞌug yajnøcxaꞌañii, tuꞌug yajmähmøꞌøwaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mänitä Jesús miäyajtøøw̱ä: ―Wiindsǿṉ, maa jaduhṉ jiadaꞌañii. Mänitä Jesús yhadsooyy: ―Tsipcøxp jaduhṉ jiadaꞌañii nébiøch cham̱ nmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mänitä Jesús tiägøøyy yajwiingapxøøbiä coo hajxy tehṉgajnä Dyiospaꞌyáꞌaxät, coo hajxy mänaa quiaꞌa jootmayhádät, hoyyä Dios quiaꞌa ja tsoj hadsówät. ");
INSERT INTO mirNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mänit miänaaṉ̃: ―Tsøg hajxy mädiáacäm. Jaduhṉä jäyaꞌay hijty tuꞌug quiuduuṉghaty. Cabä Dios hänajty wyiingudsähgøꞌøy ni jaꞌa miägajptjäyaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Jim̱ä yaamgtoꞌoxy hänajty tuꞌug maa jaꞌa cajptän. Jaꞌa miädsip hänajty jia wiꞌi ñäxøꞌøwøꞌøwaam̱by. Paady hänajty jabom̱‑jabom̱ ñøcxy maa jaꞌa cuduuṉgän neby jaduhṉ piuhbedǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Cabä yaamgtoꞌoxy miädiaꞌagy hänajty ñäꞌägä cudiunáaṉäxä. Mänitä cuduuṉg tiägøøyy tajpä maabiä: “Cábøch pøṉ nwiingudsähgøꞌøy ni jaꞌa Dios ni jaꞌa jäyaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pero cooc̈h yøꞌø yaamgtoꞌoxy xwyiꞌi yhadsipy, ngudiunáaṉäbøc̈hä miädiaꞌagy jaduhṉ, nébiøch miṉ xquiaꞌa wiꞌi yhadsíjpnät. Pø caj, jootmáꞌadäbøch häyaa.” ");
INSERT INTO mirNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","―Nøm̱ä cuduuṉg miänaaṉ̃, jaꞌa Dios caꞌa wiingudsähgøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Jaduhṉä Dios jaꞌa yhuung piuhbedaam̱bä, jaꞌa hajxy xøømdsuhm̱ paꞌyaax̱pä. ");
INSERT INTO mirNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Paquiä yhadsowaꞌañ. Pero høøc̈h jaꞌa Diosquex̱ypä, cooc̈h yaa ngädaactägátsät hädaa yaabä naax̱wiin, nej, jeꞌenä jaꞌa jäyaꞌay jaꞌa Diosmädiaꞌagy hajxy hänajty miäbǿcyñäjä. ");
INSERT INTO mirNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jim̱ä jäyaꞌayhajxy hänajty näjeꞌe, wiꞌi yajcumayaam̱b hajxy hänajty. Wyiꞌi piejxyp wyiꞌi tiehm̱by jaꞌa miäguꞌughajpä hajxy hänajty. Mänitä Jesús miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Tsøg hajxy mädiáacäm. Jaduhṉä jäyaꞌay metsc ñøcxy tsajtøgooty Diospaꞌyaax̱pä. Tuꞌug hänajty tiuṉ̃ fariseo, tuꞌug hänajty tiuṉ̃ yajnähjuudiuutpä. ");
INSERT INTO mirNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Jaꞌa fariseo, tänaꞌa hänajty Dyiospaꞌyaꞌaxy: “Haay Dios, Dioscujúꞌuyäp cooc̈h nguhdujt quiaꞌa haxøøgä. Cábøch nmeec̈h cábøch nboty, cábøc̈hä toꞌoxiøjc nmøødä wiingpä. Cábøch jaduhṉ njatcøꞌøy nej yøꞌø yajnähjuudiuutpän. ");
INSERT INTO mirNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Hayúujøch nax̱y nhity metsc‑hooc tuꞌugpä semana. Nyéjpiøc̈hä diezmo homiänaajä.” ");
INSERT INTO mirNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jäguem̱juøøbiä yajnähjuudiuutpä hänajty tiänaꞌay. Cab hänajty ñäꞌägä tsajheeby. Jaanc̈h tehm̱ jiootmayhajp hänajty jeꞌe. Jaduhṉ hänajty miänaꞌañ: “Haay Dios, høøc̈h näxúuꞌtsäc. Nnajuǿøbiøch cooc̈h ngubojpä cooc̈h ngugädieeyä.” ");
INSERT INTO mirNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tøyhajt jaduhṉ, coo jaꞌa yajnähjuudiuutpä wyiimbijnä, tøø jaꞌa piojpä quiädieey hänajty yajnähwaꞌac̈híijäm jaꞌa Diósäm. Pero jaꞌa fariseo, cab jaduhṉ yajnähwaatsä. Pøṉ ja wiꞌi yajcumayaam̱b, cabä Dios quiumay. Pero pøṉ caꞌa yajcumayaam̱b, jeꞌedsä Dios jaduhṉ quiumaaby. ");
INSERT INTO mirNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mänitä pigänaꞌc‑huunghajxy näjeꞌe wioomejtsä maa jaꞌa Jesúsän, nebiä Jesús jaduhṉ quiunúuꞌxät. Coo jaꞌa jiamiøødhajxy jaduhṉ yhijxy, mänit hajxy tiägøøyy hojpä jaꞌa pigänaꞌc‑hajxy tøø wioomec̈híijäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Mänitä Jesús ñämaayy jaꞌa jiamiøødhajxy: ―Weenc̈h yøꞌø pigänaꞌc‑hajxy xñämiṉ̃. Caꞌa hajxy mhaducy. Yøꞌø pigänaꞌc‑hajxy, chojpiä jioothajxy coo jaꞌa Diosmädiaꞌagy hajxy miäbǿgät. Cab hajxy yajcumayaꞌañ. Pøṉä jioot jaduhṉ tsojp coo jaꞌa Diosmädiaꞌagy miäbǿgät, pøṉ caꞌa yajcumayaam̱b, jeꞌeds jim̱ nøcxaam̱b maa jaꞌa Dioswiinduumän. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mänitä Jesús miäyajtøøw̱ä jaꞌa copc‑hajpä tuꞌug: ―Wiindsǿṉ, mhoyhänaꞌc miic̈h. Tiic̈h ngudiúnäp nébiøch cøjxtaꞌaxiøø njugyhádät nebiä Dios jiugyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mänitä Jesús yhadsooyy: ―Tiic̈h coo xñämaꞌay cooc̈h nhoyhänaꞌcä. Jagooyyä Dios tuꞌug yhoyyä. ");
INSERT INTO mirNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mjajpy jaduhṉ nebiä Dios tøø xyhanéhm̱äm, tuhm̱ds: “Cabä toꞌoxiøjc wiingpä mmøødhádät; caꞌa mjäyaꞌay‑yaghoꞌogy; caꞌa mmeec̈h; caꞌa mhøhṉdaꞌagy; mwiingudsähgǿꞌøwäp jaꞌa mdaj jaꞌa mdeedy.” ");
INSERT INTO mirNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mänitä copc‑hajpä miänaaṉ̃: ―Ngudiúum̱biøch jaduhṉ. Chúucnøch jaduhṉ nmädsohṉdaacy jaꞌa wiinmahñdy hoybä. ");
INSERT INTO mirNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mänitä Jesús miänaaṉ̃: ―Jaduꞌtuꞌuyyä mgaꞌa yajpedyii. Cøx̱ toog mäduhṉ̃tiä mmøødä; mänitä häyoobäyaꞌay mnäꞌä móꞌowät. Coo jaduhṉ mgudiúnät, mänit jim̱ mdägǿꞌøwät tsajpootyp. Hoorä, høøc̈h paduꞌubǿjcäc. ");
INSERT INTO mirNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mänitä craa jiootmabiøjcy, jeꞌeguiøxpä coo hänajty jiaanc̈h tehm̱ miäyøøjä. ");
INSERT INTO mirNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Coo jaꞌa Jesús yhijxy coo jaꞌa craa hänajty tøø jiootmabiøcy, mänit miänaaṉ̃: ―Jaanc̈h tehm̱ chip jaduhṉ coo jaꞌa mäyøøjäyaꞌayhajxy jim̱ tiägǿꞌøwät Dioswiinduum. ");
INSERT INTO mirNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Maas paquiä jaꞌa camello ñaxǿꞌøwät jaꞌa xuhñdyjutjooty quejee jaꞌa mäyøøjäyaꞌayhajxy jim̱ tiägǿꞌøwät Dioswiinduum. ");
INSERT INTO mirNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mänitä jäyaꞌayhajxy miänaaṉ̃, jaꞌa hajxy hänajty jim̱ mämädoonaabiä: ―Pøṉädaꞌa jim̱ näꞌä tägǿꞌøwäp Dioswiinduum. ");
INSERT INTO mirNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mänitä Jesús miänáaṉgombä: ―Mädyii jaꞌa jäyaꞌayhajxy quiaꞌa jadaam̱by, Dios mäbøcypiä jadaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mänitä Pedro miänaaṉ̃: ―Tøøds højts ngøx̱y najtshixøꞌøy mäduhṉ̃tiä højts hijty nmøødä, neby højts miic̈h hoy nbanǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Mänitä Jesús yhadsooyy: ―Tøyhajt jaduhṉ, pøṉä tiøjc najtshixøꞌøwaam̱b, o jaꞌa tiaj jaꞌa tieedy, o jaꞌa piuhyaꞌay, o jaꞌa yhuung jaꞌa tioꞌoxy, jaꞌa Diosmädiaꞌagyquiøxpä, ");
INSERT INTO mirNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","piaadaam̱by jaꞌa maas hoybä jaꞌa maas weenbä hädaa yaabä naax̱wiin. Y coo hänajty tøø yhoꞌnä, mänit hänajty cøjxtaꞌaxiøø jiugyhadaꞌañ nebiä Dios jiugyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Mänitä Jesús jaꞌa jiamiøød hawiing wioonøcxy jaꞌa nämajmetspä. Mänit miänaaṉ̃: ―Yam̱ hajxy nnǿcxäm Jerusalén. Jím̱høch njadaꞌañ nhabetaꞌañ nébiøc̈hä Diosquex̱yhajxy jecy xmiädiaaquiän, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Xquiøꞌødägøꞌøwáam̱bøch jaꞌa teedywiindsøṉhajxy jaꞌa jäguem̱bäyaꞌayhajxy. Xñäxiꞌigáam̱bøch hajxy. Xwyiinwoonáam̱bøch hajxy. Xwyiingutsujøꞌøwáam̱bøch hajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Xwiobhoꞌogáam̱bøch hajxy. Mänítøch hajxy xyaghoꞌogaaṉnä. Y cudägøøgxǿøjøch njujypiøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Cabä Jesús jaꞌa jiamiøødhajxy hänajty ñäꞌägä wiinjuøꞌøy nebiä Jesús hänajty miädiaꞌagy. Tsip hänajty miädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Coo jaꞌa Jesúshajxy hänajty tøø miäwiingooṉnä maa jaꞌa cajpt hänajty xiøhatiän Jericó, jim̱ä wiindspä hänajty tuꞌug yhäñaꞌay tuꞌhaam. Xädøꞌøñ hänajty yujwaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Coo miädooyy coo jäyaꞌay hänajty may wyiꞌi ñax̱y, mänit yajtøøyy tii jájtäp. ");
INSERT INTO mirNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mänitä yhawáaṉäxä coo jaꞌa Jesús hänajty ñax̱y, jaꞌa Nazaret‑tsohm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mänitä wiindspä yaax̱y: ―Jesús, miic̈hä David xyhaphajp xyhoc‑hajp. Høøc̈h hii näxúuꞌtsäc. ");
INSERT INTO mirNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jaꞌa hajxy hänajty jawyiin najxpä, mänit hajxy yhojy coo yhamónät. Pero maas møc jaduhṉ jiaac yaax̱y: ―Miic̈hä David xyhaphajp xyhoc‑hajp. Høøc̈h hii näxúuꞌtsäc. ");
INSERT INTO mirNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mänitä Jesús tiänaaxiøjpy. Mänit miänaaṉ̃: ―Yajmets yøꞌø wiindspä yaa. Coo jaꞌa mähdiøjc yajmejtsä maa jaꞌa Jesúsän, mänitä Jesús jaꞌa wiindspä miäyajtøøyy: ");
INSERT INTO mirNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―Nébiøch miic̈h nbuhbédät. Mänitä mähdiøjc yhadsooyy: ―Wiindsǿṉ, høøc̈h hii yaghijxǿꞌcäc. ");
INSERT INTO mirNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mänitä Jesús miänaaṉ̃: ―Tøø jaduhṉ mhijxøꞌøgy coo tøø mmäbøcy. ");
INSERT INTO mirNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mänitiä jaꞌa wiindspä jiaanc̈h hijxøꞌcy. Mänitä Jesús piaduꞌubøjcy. Mänit tiägøøyy mänaam̱bä coo jaꞌa Dios miøjjä jiaanc̈hä. Jaꞌa jäyaꞌayhajxy jaduhṉ híjxäbä, jaduhṉ hajxy miänaam̱bä nägøx̱iä coo jaꞌa Dios miøjjä jiaanc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mänitä Jesús quiajptägøøyy Jericó. Mänit ñajxy cajptooty. ");
INSERT INTO mirNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jim̱ä mäyøøjäyaꞌay hänajty tuꞌug jaꞌa xøhajpä Zaqueo. Wiindsǿṉ hänajty tiuum̱by maa jaꞌa yajnähjuudiuutpähajxiän. ");
INSERT INTO mirNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jaꞌa Zaqueo, jia wiꞌi yhixaam̱biä Jesús hänajty, pero cab hänajty hoy yhixaꞌañ jeꞌeguiøxpä coo hänajty jiaanc̈h tehm̱ ñaax̱ypä, møødä jäyaꞌayhajxy hänajty jiaanc̈h tehm̱ miayyä. ");
INSERT INTO mirNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mänit päyøꞌøguiä ñøcxy maa jaꞌa Jesús hänajty ñaxøꞌøwaꞌañän. Mänit piejty quepyquiøxp, nebiä Jesús jaduhṉ hoy yhíxät. ");
INSERT INTO mirNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Coo jaꞌa Jesús jim̱ ñajxy, mänit yuugheeꞌpy maa jaꞌa Zaqueo hänajty yhäñaꞌayän. Mänitä Jesús miänaaṉ̃: ―Zaqueo, tsógämäts, mänácäts, mejtstaꞌagáam̱bøch jim̱ maa miic̈h mdøjcän. ");
INSERT INTO mirNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mänitiä jaꞌa Zaqueo miänajcy. Mänitä Jesús hoy yajtøjtägøꞌøy jootcujc. ");
INSERT INTO mirNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Coo jaꞌa cuꞌug jaduhṉ yhijxy, mänit hajxy tiägøøyy mänaam̱bä cooc jaduhṉ quiaꞌa hoyyä coo jaꞌa Jesús jim̱ miejtstáꞌagät maa jaꞌa cubojpäyaꞌay cugädieejiäyaꞌay tiøjcän. ");
INSERT INTO mirNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mänitä Zaqueo tiänaayyøꞌcy. Mänitä Jesús ñämaayy: ―Wiindsǿṉ, huuc mädow̱, mädúhṉ̃tiøch nmøødä, cúpc‑høc̈hä häyoobäyaꞌay nnäꞌä moꞌowaꞌañ. Pønjátyhøch tøø nmämeec̈h høhṉdaꞌagymiädiaꞌagyhaam, mädaax̱cjadúhṉ̃tiøch nyajwiimbidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mänitä Jesús miänaaṉ̃: ―Jädáꞌajøc̈hä piojpä quiädieeyhajxy nyajnähwaꞌadsaaṉä hädaa tøgootypä, jeꞌeguiøxpä coo yhAbraham yhap yhocä hädaa craabä, hoy jia näꞌä yajnähjuudiuꞌudy. ");
INSERT INTO mirNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Páadyhøch yaa tøø ngädaꞌagy hädaa yaabä naax̱wiin, høøc̈h jaꞌa Diosquex̱ypä, nébiøc̈hä jäyaꞌay piojpä quiädieeyhajxy jaduhṉ nyajnähwáꞌadsät. Jadúhṉhøch njoot chocy. ");
INSERT INTO mirNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mäwiingóoṉnäbä Jesúshajxy hänajty Jerusalén. Miädóow̱äbä cuꞌugä Jesús miädiaꞌagy hänajty. Jaduhṉ hajxy hänajty miänaꞌañ cooc hänajty tøø yhabaatnä coo jaꞌa Dios jaꞌa miäjaa hänajty yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Paadiä Jesús tiägøøyy mädiaacpä: ―Jaduhṉä mäyøøhänaꞌc hänajty tuꞌug. Nøcxaam̱b hänajty jäguem̱naax̱ coo hänajty mioꞌowaꞌañii møjtuuṉg maa jaꞌa yhamdsoo cajptän. Mänit hänajty wyiimbidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Coo hänajty tiuꞌubøgaꞌañ, mänitä mioonsä jaꞌa majcpä miøjyaax̱y. Mänitä maxiädøꞌøñ hajxy nägøx̱iä yajcøꞌødägøøyyä. Mänitä mäyøøjäyaꞌay miänaaṉ̃: “Mädúhṉ̃tiøch jäguem̱ nhidaꞌañ, myajmayǿꞌøwäp hädaa xädøꞌøñ hajxy.” Mänitä craa tiuꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jaanc̈h tehm̱ xiøøghájtäbä craa jim̱ maa jaꞌa yhamdsoo cajptän. Mänitä cuꞌugä capxy quiejxy coo hajxy hänajty quiaꞌa tsocy coo jaꞌa craa jim̱ quiopc‑hádät maa jaꞌa quiajpthajxiän. ");
INSERT INTO mirNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Coo jaꞌa craa hänajty tøø tiuuṉgwiingpøjnä, mänit wyiimbijnä maa jaꞌa quiajptän. Mänitä mioonsä miøjyaax̱y jaꞌa xädøꞌøñ hajxy hänajty tøø yajcøꞌødägøꞌøyíijäbä. Yajtøwaam̱biä craa hänajty mäduhṉjaty hajxy hänajty tøø yajmayøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mänit tuꞌug miejch. Mänit miänaaṉ̃: “Wiindsǿṉ, majcjaduhṉ̃tiä jaꞌa mxädøꞌøñ tøø miayøꞌøy.” ");
INSERT INTO mirNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mänitä craa yhadsooyy: “Jaanc̈h tehm̱ yhoy miic̈h tøø mgudiuṉ̃. Wéeṉ̃tiøch miic̈h hijty tøø nyajcøꞌødägøꞌøy. Coo hoy tøø mgudiuṉ̃, páadyhøch miic̈h nyajnähdijy coo mgopc‑hádät maa yøꞌø majcpä cajptän.” ");
INSERT INTO mirNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mänitä wiingpä miejtspä. Mänit miänaaṉ̃: “Wiindsǿṉ, mägoox̱cjaduhṉ̃tiä jaꞌa mxädøꞌøñ tøø miayøꞌøy.” ");
INSERT INTO mirNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mänitä craa yhadsóogombä: “Jim̱ miic̈h mgopc‑hadaꞌañ maa jaꞌa mägoox̱pä cajptän.” ");
INSERT INTO mirNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mänitä wiingpä jiaac mejtspä. Mänit miänaaṉ̃: “Wiindsǿṉ, chaadsä mxädøꞌøñ. Paayyäjóotyhøch hijty nyaghity. ");
INSERT INTO mirNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Míic̈hhøch hijty ndsähgøøby jeꞌeguiøxpä coo miic̈h mjootmøjjä, coo miic̈h myajpädøꞌøgy maa hijty tøø mgaꞌa pädaꞌaguiän.” ");
INSERT INTO mirNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mänitä mäyøøhänaꞌc miänaaṉ̃: “Caj miic̈h hoy tøø mgudiuṉ̃. Hamdsoo miic̈h mmänaꞌañ cooc̈h njootmøjjä, cooc̈h nyajpädøꞌøgy maac̈h hijty tøø ngaꞌa pädaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Jím̱høch nxädøꞌøñ häxøpy tøø xpiädaacä maa jaꞌa bancon, neby jaduhṉ cu miayøøyy, mädúhṉ̃tiøch hoy jäguem̱ tøø nwädity.” ");
INSERT INTO mirNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mänitä craa jaꞌa jäyaꞌay ñämaayy jaꞌa hajxy hänajty jiiby tänaabiä: “Pøjcä yøꞌø craa yøꞌø xädøꞌøñ. Moꞌow yøꞌø craa jaꞌa xädøꞌøñ majcjaduhṉ̃tiä tøø yajmayǿꞌøyäbä.” ");
INSERT INTO mirNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mänit hajxy yhadsooyy: “Wiindsǿṉ, tisän, xim̱ä xädøꞌøñ may miǿødäbä.” ");
INSERT INTO mirNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mänitä mäyøøhänaꞌc yhadsooyy: “Høøc̈h jaduhṉ mänaam̱b; pøṉ may møød, maas may mioꞌowaꞌañii. Pero pøṉ weeṉ̃tiä møød, pøgáaṉäxäp cøx̱iä mäduhṉ̃tiä miøødä. ");
INSERT INTO mirNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Y jaꞌa nmädsiphøchhajxy, jaꞌa høøc̈h hajxy xxiøøghajpä, yajmíṉ hajxy yaa; yaghoꞌog hajxy yaa maac̈h nwiinduumän” ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mänitä Jesúshajxy tiuꞌubǿjcombä. Jerusalén hajxy hänajty ñøcxy. ");
INSERT INTO mirNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mäwiingoom̱b hajxy hänajty maa jaꞌa cajpt hänajty metsc xiøhatiän Betfagé møødä Betania, mäwiingóṉ maa jaꞌa tuṉ hänajty xiøhatiän Olivos. Mänitä Jesús jaꞌa jiamiøød metsc ");
INSERT INTO mirNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ñämaayy: ―Nøcxøꞌøg hajxy jim̱ maa yøꞌø cajptän. Jim̱ cajptpaꞌa jaꞌa burrohuung hajxy tuꞌug mbaadaꞌañ cuxoch. Cahnä pøṉ ñäꞌägä yaghäñaabietyñä. Mmäguejǿꞌøwäp hajxy; mänit hajxy yaa mmämínät. ");
INSERT INTO mirNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Coo pøṉ xmiäyajtǿwät tii jaꞌa burro hajxy coo mmäguejøꞌøy, mänit hajxy mhadsówät cooc̈h høøc̈h jaduhṉ nmänaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mänitä burro hajxy hoy jiaanc̈h paady nebiä Jesús hänajty tøø miänaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jim̱ä burro hajxy hänajty miäguejøꞌøy, mänit hajxy ñämaayyä jaꞌa cuburrohajxy: ―Tii yøꞌø burro hajxy coo mmäguejøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mänit hajxy yhadsooyy: ―Højts nwiindsǿṉ jaduhṉ mänaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mänitä burro hajxy yajnøcxy maa jaꞌa Jesúsän. Mänitä wyit hajxy piädaacy burronähgøxp. Mänitä Jesús hajxy yajpejty burronähgøxp. ");
INSERT INTO mirNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mänitä cuꞌugä wyit hajxy tiägøøyy najtswidsøøbiä tuꞌhaam maa jaꞌa Jesús hänajty ñaxøꞌøwaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivostuṉmøjcä tuꞌu hänajty ñaxøꞌøy. Coo hajxy miejtsnä maa jaꞌa wiinmänacän, mänitä Jesús jiamiøødhajxy tiägøøyy yaax̱pä jojpä jeꞌeguiøxpä coo hajxy hänajty xiooṉdaꞌagy. Nämayyä Jesús jiamiøødhajxy hänajty. Jaduhṉ hajxy hänajty yaꞌaxy coo jaꞌa Dios miøjjä jiaanc̈hä, coo hajxy hänajty tøø yhix̱y jaꞌa hoy‑yagjuøøñäjatypä jaꞌa Jesús hänajty tøø yajcähxǿꞌøguiäbä: ");
INSERT INTO mirNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","―Møj jaanc̈h hädaa gobiernä; Diosquex̱y hädaaduhṉ. Møj jaanc̈hä Dios jim̱ tsajpootypä; ween hajxy jim̱ xiooṉdaꞌagy ―nøm̱ hajxy hänajty yaꞌaxy. ");
INSERT INTO mirNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jim̱ä fariseoshajxy hänajty näjeꞌe piadänaꞌay. Mänitä Jesús hajxy ñämaayy: ―Wiindsǿṉ, mhójäp yøꞌø mjamiøødhajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mänitä Jesús yhadsooyy: ―Hóyhøch yøꞌø hänaꞌc cu nja hoj, cab hänaꞌc häyaa ñäꞌä hamóom̱bät; maas møc hajxy ñäꞌägä yáꞌaxät. ");
INSERT INTO mirNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Coo jaꞌa Jesús hänajty jim̱ miedsaaṉnä Jerusalén, coo jaduhṉ ñäheebøøyy, mänit tiägøøyy jøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mänit miänaaṉ̃: ―Yøꞌø Jerusalénpäyaꞌayhajxy, cooc̈h hajxy cu xchojcy, jootcujc hajxy häxøpy yhity. Tøø yhabaady coo jaꞌa cuꞌughajxy cu jiootcugøøyy. Pero cab hajxy wyiinjuøꞌøwaꞌañ. Cábøch hajxy xchogaꞌañ xmieeꞌxaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Haxøøg hajxy jiadaꞌañ yhabetaꞌañ. Medsaam̱bä miädsiphajxy. Mänit hajxy jiuhguraajøꞌøwaꞌañii piquiä. ");
INSERT INTO mirNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Cab hajxy yajmäjädaꞌagaꞌañii. Yaghoꞌogáaṉäp hajxy jaduhṉ. Mänitä quiajpthajxy quiuhdägoyyaꞌañ. Paady hajxy jaduhṉ jiadaꞌañ yhabetaꞌañ cooc̈h hajxy jaduhṉ xquiaꞌa tsogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Coo jaꞌa Jesús miejch cajptooty, mänit tiägøøyy tsajtøgooty. Mänit tiägøøyy høxquejxpädsøøm̱bä pønjaty jiiby juuby tooꞌp. ");
INSERT INTO mirNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Mänit miänaaṉ̃: ―Jim̱ jaduhṉ myiṉ̃ cujaay maa jaꞌa Diosmädiaꞌaguiän: “Jueꞌec̈h ndøjc hajxy xwiáaṉät cooc̈h hajxy jiiby xpiaꞌyáꞌaxät.” Jaꞌa Dios jaduhṉ mänaaṉ. Pero mijts, jaduhṉ hajxy mwaꞌañ meedsøhñdy. ");
INSERT INTO mirNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Najxpäxøø jaꞌa Jesús hänajty jiiby yajnähixøꞌøy tsajtøgooty. Pero jaꞌa teedywiindsøṉhajxy møødä ley‑yajnähixøøbiähajxy, quiojyquiapxytiuum̱by hajxy hänajty nebiä Jesús hajxy yaghóꞌogät, møødä cuꞌugwiindsøṉhajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero cab hajxy hänajty ñajuøꞌøy neby hajxy jiatcǿꞌøwät jeꞌeguiøxpä coo jaꞌa cuꞌug jaꞌa Jesús miädiaꞌagy hajxy hänajty jiaanc̈h tehm̱ miämädoonaayyä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jiibiä Jesús jaꞌa cuꞌug jaꞌa Diosmädiaꞌagy hänajty yajnähixøꞌøy tsajtøgooty, mänitä Jesús ñämejtsä jaꞌa teedywiindsøṉhajxy møødä ley‑yajnähixøøbiähajxy møødä copc‑hajpähajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mänit hajxy miänaaṉ̃: ―Pøṉä cuhdujt tøø xmioꞌoy coo jaꞌa cuꞌug tøø mhøxquejxpädsøm̱y tsajtøgooty, y coo tøø mdägøꞌøy yajnähixøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mänitä Jesús miänaaṉ̃: ―Chaads mijts nmäyajtøwaam̱bä. Mhadsówäp hajxy jaduhṉ: ");
INSERT INTO mirNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Coo jaꞌa Juan hijty wiädity mäyajnäbejpä, pøṉ jaduhṉ quejx, Dios tøgä jäyaꞌayä. Cab hajxy ñäꞌä hadsooyy. ");
INSERT INTO mirNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mänit hajxy tiägøøyy yajcapxiøøbiä: ―Neby hajxy nnäꞌä hadsóow̱ämät; coo hajxy nmänáaṉämät coo jaꞌa Dios quiejxy, mänit yhadsowaꞌañ: “Tii hajxy coo mgaꞌa mäbøjcä.” ");
INSERT INTO mirNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y coo hajxy nmänáaṉämät coo jäyaꞌay quiejxy, mänitä cuꞌug hajxy xquiuhgáꞌtsämät. Hix̱, haagä mänaam̱b hajxy jaduhṉ coo jaꞌa Juan tøø quiexyíijäm jaꞌa Dios. ");
INSERT INTO mirNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mänit hajxy yhadsooyy coo hajxy quiaꞌa najuøꞌøy pøṉä Juan quejx mäyajnäbejpä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mänitä Jesús miänaaṉ̃: ―Ni høøc̈h ngaꞌa nägapxaꞌañ pǿṉhøch jaꞌa cuhdujt tøø xmioꞌoy. ");
INSERT INTO mirNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mänitä Jesús jaꞌa cuꞌug tiägøøyy møødmädiaacpä: ―Jaduhṉä jäyaꞌay tsaatypcam̱ piädaacy maa jaꞌa ñaax̱än. Mänit yhadooꞌtujcy. Mänit tiuꞌubøjcy. Jäguem̱ ñøcxy. Jegaam̱b hänajty jim̱. ");
INSERT INTO mirNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Coo jaꞌa tsaatyptuc yhabaaty, mänitä mioonsä tuꞌug quiejxy coo jaꞌa tsaatypcam̱ piuhmoꞌowǿøjät. Mänitä mioonsä quioxhóꞌcäxä. Caj tii yajmäwiimbijtä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mänitä mioonsä tuꞌug quiéjxcumbä. Jaduhṉä mähdiøjc quioxhóꞌcägombä. Haxøøgjaty jaduhṉ ñämaayyä. Ni jeꞌe tii quiaꞌa mooyyä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mänitä wiingpä jiaac quéjxcombä. Nähdsäbit cuhdsäbit jaꞌa mähdiøjc piädáacänä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mänitä cudsaatypcam̱ miänaaṉnä: “Nébiøch nnäꞌä jatcǿꞌøwät. Tøøc̈h cham̱ nnajuøꞌøy. Hädaa nhúunghøch, njaanc̈h tehm̱ chójpiøch njaanc̈h tehm̱ piaꞌhäyóobiøch hädaa. Nhuuc quéx̱yhøch hädaa. Coo yhøxcabǿøjät, wehṉdä wyiingudsähgøꞌøwǿøjät.” Mänitä yhuung quiejxy. ");
INSERT INTO mirNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Coo yhøxcajpä, mänit hajxy tiägøøyy ñiñämáayyäbä, jaꞌa tsaatypcam̱ hajxy hänajty hajoodiujpä: “Jaꞌa cudsaatypcam̱ yhuung yøꞌø. Coo yøꞌø tieedy jaduhṉ yhóꞌogät, yøꞌø mähmøꞌøwaam̱b cudsaatypcam̱. Tsøg hajxy yaghóꞌcäm neby hajxy jaduhṉ nmämähmǿøyyämät.” ");
INSERT INTO mirNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mänitä cudsaatypcam̱ yhuung yhøxwijtspädsǿøm̱äxä. Mänit hajxy yaghoꞌcy. Mänitä Jesús yajtøøyy: ―Nebiä cudsaatypcam̱ jiatcøꞌøwaꞌañ coo yhuung yaghóꞌcäxä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nøcxaam̱b yaghoꞌtägatsaꞌañ jaꞌa yhuung tøø yaghóꞌcäxäbä. Mänitä wiinghänaꞌc jaꞌa tsaatypcam̱ yaghajoodiugaꞌañ. Coo jaꞌa cuꞌughajxy jaduhṉ miädooyy, mänit hajxy miänaaṉ̃: ―Ni jaꞌa Dios jaduhṉ quiaꞌa mänáꞌanät. ");
INSERT INTO mirNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mänitä Jesús jaꞌa cuꞌug wyiinheeꞌppejty. Mänit miänaaṉ̃: ―Nej mijts jaꞌa Diosmädiaꞌagy myajmädiaꞌagytiägøꞌøy coo miänaꞌañ: Jaꞌa tsaa mädyii jaꞌa tøjcojpä hajxy quiaꞌa näꞌägä cumaayy, jeꞌe näꞌägä tuuṉdsohṉ. (Jesús hamdsoo niñänøøm̱ä nebiä tsaajän jeꞌeguiøxpä coo hänajty quiaꞌa tsocy quiaꞌa meeꞌxyíijäm jaꞌa cuꞌug. Pero moꞌowáaṉäbä Jesús hänajty møjtuuṉg.) ");
INSERT INTO mirNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mänitä Jesús miänáaṉgumbä: ―Pøṉ jaduhṉ cáꞌawäp yøꞌø tsaanähgøxp, tägóyyäp jaduhṉ. Y coo pøṉ ñähgahbedǿøjät yøꞌø tsaa, tägóyyäp jeꞌebä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mänitiä jaꞌa Jesús jia madsaaṉä jaꞌa teedywiindsøṉhajxy møødä ley‑yajnähixøøbiähajxy. Ñajuøøby hajxy hänajty coo hajxy hänajty tøø miädiaꞌagyii. Pero cabä Jesús ñäꞌä majtsä jeꞌeguiøxpä coo jaꞌa cuꞌug hänajty chähgøꞌøyíijäm jaꞌa teedywiindsøṉhajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mänitä hänaꞌc hajxy yajnähdijy coo hajxy ñibiädaꞌagǿøjät nebiä hoyhänaꞌcän. Nǿcxäp hajxy miädoy nebiaty jaꞌa Jesús hänajty miädiaꞌagaꞌañ. Coo jaꞌa Jesús quiapxtägóyyät, mänit hajxy ñäxøꞌøwøꞌøwaꞌañ maa jaꞌa gobernadorän. ");
INSERT INTO mirNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mänitä Jesús hajxy miäyajtøøyy: ―Wiindsǿṉ, nnajuøøby højts coo miic̈hä tøyhajt myajnähixøꞌøy jaꞌa Diosmädiaꞌagy. Hopiøṉä miic̈h mmøødmädiaꞌagy; y caj miic̈h pøṉ mmøjpädaꞌagy, hoy pøṉ møjtuuṉg jia møødä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Højtsä tøyhajt móoyyäc. Coo højtsä gobiernä hänajty xyagjuy xyajmoꞌonaꞌañ, nej, hoyyädaꞌa jaduhṉ coo højts njúyädä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero ñajuøøbiä Jesús hänajty coo hänajty jia yajcapxtägoyyaꞌañii. Mänit miänaaṉ̃: ―Tiic̈h hajxy coo xjia wiꞌi jiøjcapxøꞌøwaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Høøc̈hä xädøꞌøñ tuꞌug yaghíjxäc. Pøṉ yhajahñax̱y yøꞌøduhṉ, pøṉ xiøø yøꞌøduhṉ. Mänit hajxy yhadsooyy: ―Jaꞌa gobiernä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mänitä Jesús miänáaṉgombä: ―Pues, mmóꞌowäp jaꞌa gobiernä hajxy tijaty yøꞌø jieꞌehajpy. Y mmóꞌowäbä Dios hajxy tijaty yøꞌø jieꞌehajpy. ");
INSERT INTO mirNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Cabä Jesús hajxy hänajty hoy yajcapxtägoyyaꞌañ cuꞌughagujc. Yagjuøøyy hajxy jaduhṉ coo hoy yhadsooyy. Y cab hajxy waam̱b miänaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mänitä Jesús ñämejtsä jaꞌa saduceoshajxy näjeꞌe, jaꞌa hajxy jaduhṉ mänaam̱bä cooc tyijy ni pøṉ quiaꞌa jujypiøgaꞌañ. Mänitä Jesús hajxy ñämaayy: ");
INSERT INTO mirNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Wiindsǿṉ, jaduhṉdsä Moisés jecy quiujahy, cooc jaꞌa yaꞌadiøjc hänajty tuꞌug tøø yhoꞌogy, y cooc jaꞌa yaamgtoꞌoxy jaꞌa huung quiaꞌa møødä, mänítägä quiapy wyiingpǿgät, nébiägä yhuung jaduhṉ miähmǿꞌøwät jaꞌa piuhyaꞌaguiøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jaduhṉä hänaꞌc‑hajxy hänajty, näjuxtujc tuꞌqueꞌex. Jaꞌa craa møjpä, mänit jia pøjcy. Mänit yhoꞌcy. Nituꞌugtä yhuung quiaꞌa mähmøøyy. ");
INSERT INTO mirNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mänitä jiødsøm̱y jaꞌa yaamgtoꞌoxy jia wiingpǿjcombä. Mänit jeꞌe yhóꞌcombä. Nituꞌugtä yhuung quiaꞌa mähmøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mänitä yaamgtoꞌoxy jaꞌa quiapy jia wiingpǿjcombä jatuꞌug. Jaanä jaduhṉ yhóꞌcombä. Nägøx̱iä jaꞌa yaamgtoꞌoxy jaꞌa quiapy jia møødtsänaayy jaꞌa näjuxtujpä; cøjx hajxy yhoꞌogy, y ni pøṉ yhuung quiaꞌa mähmøøyy. ");
INSERT INTO mirNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mänitä yaamgtoꞌoxy jiaag hoꞌpä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hoorä, coo hajxy hänajty tøø jiujypiøjnä, pøṉä toꞌoxiøjc tøyhajt møødtsänaꞌawaam̱b jaꞌa näjuxtujpä, jim̱ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mänitä Jesús yhadsooyy: ―Hädaa yaabä naax̱wiin, pøjp huucp jaꞌa jäyaꞌayhajxy yaa. ");
INSERT INTO mirNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero pønjaty jujypiøgaam̱b, pønjaty nøcxaam̱b tsajpootyp, cab hajxy jim̱ piøgaaṉnä yhuꞌugaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Cab hajxy mänaa yhoꞌtägatsaaṉnä. Coo hajxy hänajty tøø jiujypiøjnä, jaduhṉ hajxy miähmøꞌøwaaṉnä nebiä Dioshuungän, nebiä Diosmoonsän. ");
INSERT INTO mirNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hamdsoo jaꞌa Moisés hajxy xyajnähixǿøyyäm coo jaꞌa hoꞌogyjiäyaꞌayhajxy jiujypiøgaꞌañ, jiiby maa jaduhṉ myiṉ̃än coo jaꞌa hujtshuung hänajty tioy tuꞌug. Jaduhṉ jiiby myiim̱bä coo jaꞌa Dios wyiingudsähgøꞌøyíijäm jaꞌa Abraham møødä Isaac møødä Jacob. ");
INSERT INTO mirNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Cabä Dios wyiingudsähgøꞌøyíijäm jaꞌa hoꞌogypiähajxy. Jaꞌa jujcyjiäyaꞌayhajxy, jeꞌeds hajxy jaduhṉ wiingudsähgøøby jaꞌa Dios. ");
INSERT INTO mirNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mänitä ley‑yajnähixøøbiähajxy näjeꞌe miänaaṉ̃: ―Wiindsǿṉ, yajxóṉ miic̈h jaduhṉ mmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Cabä Jesús hajxy waam̱b ñämaañä jeꞌeguiøxpä coo hajxy hänajty chähgøøñä. ");
INSERT INTO mirNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mänitä Jesús miänaaṉ̃: ―Tii hajxy coo mmänaꞌañ cooc jaꞌa David yhuunghaty jaꞌa Diosquex̱y. ");
INSERT INTO mirNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Hamdsoo jaꞌa David miänaaṉ̃ maa jaꞌa Salmos quiujahyyän: Mänítøc̈hä Dios jaꞌa nwiindsǿṉ xñämaayyä: “Yaads miṉ häñaꞌaw nhahooguiøꞌøháampiøch, ");
INSERT INTO mirNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","høxtä cóonøc̈hä mmädsip tøø ngaꞌa yajmäjädáacäm.” ");
INSERT INTO mirNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Coo jaꞌa David jaꞌa Diosquex̱y hamdsoo ñämaayy “wiindsǿṉ”, nébiäts jaduhṉ ñäꞌä huunghádät. ");
INSERT INTO mirNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jim̱ä cuꞌughajxy hänajty nägøx̱iä miämädoonaꞌay, mänitä Jesús ñämaayy jaꞌa jiamiøødhajxy: ");
INSERT INTO mirNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Caꞌa yøꞌø ley‑yajnähixøøbiä miädiaꞌagy hajxy mmäbøjcä. Yoṉ̃witmøød hajxy wyiꞌi wiädity jeꞌeguiøxpä coo hajxy wyiꞌi yajcumayaꞌañ. Jaduhṉä jioothajxy jia tsocy coo hajxy jim̱ wyiingudsähgøꞌøwǿøjät halaplaaz. Jiiby hajxy yhäñaꞌawaꞌañ maa jaꞌa häñaabiejt yajxoṉjatypän jiiby tsajtøgooty, chaads jim̱ maa jaꞌa xøø jiadyiijän. ");
INSERT INTO mirNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Y piǿjcäbä yaamgtoꞌoxy jaꞌa tiøjc hajxy. Wiꞌi yajcumayaam̱b hajxy, paady hajxy wyiꞌi Dyiospaꞌyaꞌaxy jejcyjiaty. Hanax̱iä hajxy chaac̈htiunaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tsajtøgootiä Jesús hänajty, mänitä mäyøøjäyaꞌay yhijxy coo xädøꞌøñ hajxy hänajty quiuyoxøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mänitä yaamgtoꞌoxy tuꞌug yhijxpä jaꞌa jaanc̈h tehm̱ yhäyoobä. Jagooyyä xädøꞌøñhuung hänajty miøødä metsc. Jeꞌeduhṉ cøjx yecy. ");
INSERT INTO mirNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mänitä Jesús miänaaṉ̃: ―Tøyhajt jaduhṉ, maas may hädaa yaamgtoꞌoxy häyoobä jaꞌa xädøꞌøñ tøø quiuyoxøꞌøy quejee yøꞌø mäyøøjäyaꞌayhajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yøꞌø mäyøøjäyaꞌayhajxy, jeꞌe hajxy quiuyoxøøyy mäduhṉ̃tiä hajxy tøø yajcunax̱y. Pero hädaa yaamgtoꞌoxy, jeꞌe cøjx quiuyoxøꞌøy mäduhṉ̃tiä hijty ñägayaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jiibiä jäyaꞌayhajxy hänajty näjeꞌe tsajtøgooty. Jaduhṉ hajxy hänajty miädiaꞌagy coo jaꞌa tsaa jiaanc̈h tehm̱ yajxoṉjatiä, coo hajxy tøgooty yajxóṉ jiaanc̈h tehm̱ yhix̱y nebiatiä jäyaꞌayhajxy hänajty tøø piädaꞌaguiän. Mänitä Jesús miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Habaadaam̱b jaduhṉ coo hädaa tsajtøjc jyidaꞌañ cøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mänitä Jesús ñämaayyä: ―Wiindsǿṉ, mänaa jaduhṉ jiadaꞌañii. Tii hijxtahṉd jaduhṉ naxaam̱b coo hänajty tøø yhabaatnä. ");
INSERT INTO mirNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mänitä Jesús yhadsooyy: ―Mniyajcopcøꞌøwǿøjäp hajxy, cab hajxy myajwiinhǿønät. Nämay hajxy wiäditaꞌañ. Jaduhṉ hajxy miänaꞌanaꞌañ: “Høøc̈hä Dios tøø xquiex̱y”, y “Tøø yhabaatnä.” Pero cab hajxy mmäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Coo hajxy jaduhṉ mmädoyhádät coo tsip piädøꞌøgaꞌañ, cab hajxy mdsähgǿꞌøwät. Jayøjpä tsip jiadaꞌañii, cahnä hänajty yhabaadyñä. ");
INSERT INTO mirNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mänitä Jesús jiaac mänaaṉ̃: ―Nimiädsibøꞌøwáaṉäbä wiingcajptjaty. ");
INSERT INTO mirNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Møc hujx jiäditaꞌañ. Jadáaṉäbä yuuxøø møødä paꞌam wiinduhm̱yhagajpt. Y jim̱ä hoc̈hähgøøñäjatypä quiähxøꞌøgaꞌañ tsajtwiing. ");
INSERT INTO mirNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero cahnä hänajty yhabaadyñä, xmiadsaam̱b mijts jaꞌa jäyaꞌayhajxy. Xyajnøcxaam̱b hajxy maa jaꞌa tsajtøjcän. Jiiby hajxy xñäxøꞌøwøꞌøwaꞌañ. Xchumaam̱b hajxy jaduhṉ. Xyajnøcxaam̱b hajxy maa jaꞌa gobiernäwiinduumhajxiän. Jaꞌa høøc̈hcøxpä hajxy xchaac̈htiunaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Coo hajxy jaduhṉ mjádät mhabétät, mänítøch hajxy xmiädiáꞌagät. ");
INSERT INTO mirNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Wiinjuøꞌøw hajxy jaduhṉ. Cab hajxy jäguem̱iä mwiinmahñdyhádät waam̱baty hajxy mhadsówät. ");
INSERT INTO mirNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Høøc̈h mijts nbuhbedaam̱by. Nmoꞌowáam̱biøch mijts jaꞌa wiinmahñdy nebiä mmädsip hajxy mgaꞌa yajmäjädáꞌagät. ");
INSERT INTO mirNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Høxtä xñähdugaam̱bä mdeedy hajxy møødä mbuhyaꞌayhajxy møødä mjujy mmäguꞌughajxy møødä mmäguꞌughajpähajxy. Näjéꞌeyyäm mijts hänaꞌc xyaghoꞌogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nägøx̱iä hajxy xxiøøghadaꞌañ maa jaꞌa høøc̈hcøxpän. ");
INSERT INTO mirNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Hoy hajxy cøx̱ypänejpiä cu mja jat cu mja habet, tsipcøxp hajxy hodiuum mnøcxaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Coo hajxy hamuumduꞌjoot mmeeꞌxtúgät, mdägǿꞌøwäp hajxy jim̱ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Coo hajxy mhíxät coo jaꞌa Jerusaléncajpt hänajty tøø jiuhbigøꞌøyíijäm jaꞌa miädsip, mänit hajxy mnajuǿꞌøwät coo hänajty tøø yhabaatnä coo Jerusalén quiuhdägoyyaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pønjaty hänajty yaa hijp Judeanaaxooty, tsipcøxp hajxy piäyǿꞌøgät, nǿcxäp hajxy jim̱ maa jaꞌa tuṉän. Pønjaty hänajty yaa hijp Jerusaléncajptooty, tsipcøxp hajxy yaa chóonät. Pønjaty hänajty hijp camjooty, cab hajxy ñøcxtägátsät quiajptootyhajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jaanc̈h tehm̱ chaac̈hpøgaam̱bä jäyaꞌayhajxy nägøꞌø nädecypiä. Jadáaṉäp jaduhṉ nebiaty jiiby myiṉ̃än cujaay maa jaꞌa Diosmädiaꞌaguiän coo jiadaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jaanc̈h tehm̱ chaac̈hpøgaam̱bä toꞌoxiøjc‑hajxy hänajty, jaꞌa hajxy hänajty mox̱tsaꞌamhajpä, jaꞌa hajxy hänajty maaxhuungmøødpä. Hoyhoyyä jäyaꞌayhajxy yaa chaac̈hpøgaꞌañ hädaa yaabä naax̱wiin. Jaanc̈h tehm̱ yajcumädow̱áaṉäp hajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Näjeꞌe hajxy yhoꞌogaꞌañ coo jaꞌa tsip jiadaꞌañii. Näjeꞌe hajxy miadsaꞌañii. Mänit hajxy yajnøcxaꞌañii wiinduhm̱yhagajpt. Minaam̱bä jäguem̱jäyaꞌay jaꞌa Jerusaléncajpt hajxy yajmaꞌadaꞌañ, høxtä coonä yhabétät coo jaꞌa cuhdujt hajxy piǿjcäxät coo hajxy jaduhṉ quiaꞌa jatcǿøñät. ");
INSERT INTO mirNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Cähxøꞌøgaam̱bä hijxtahṉd maa jaꞌa xøøjän, maa jaꞌa poꞌojän, maa jaꞌa madsaꞌajän. Pädøꞌøgaam̱bä mejy; jäditaam̱b jaduhṉ. Paadiä cuꞌughajxy chähgøꞌøwaꞌañ wiinduhm̱yhagajpt. ");
INSERT INTO mirNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wiinmahñtiägoyyaam̱bä jäyaꞌayhajxy coo hoc̈hähgøøñä yaa jiadaꞌañii hädaa yaabä naax̱wiin. Tsäyuyyaam̱bä xøø chaadsä poꞌo chaadsä madsaꞌa. ");
INSERT INTO mirNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mänítøch ngädaactägatsaꞌañ joc‑hagujc, høøc̈h jaꞌa Diosquex̱ypä. Hajájjäbøch ngädaꞌagaꞌañ mäjaamøød. Xyhixáam̱bøc̈hä jäyaꞌayhajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Coo jaduhṉ jiadǿøjät, mänit hajxy mjootcugǿꞌøwät. Mänit hajxy mbädsøm̱aꞌañ hawaꞌadstuum. ");
INSERT INTO mirNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mänitä Jesús miänáaṉgombä: ―Høxtahm̱dsä quepychaa, ");
INSERT INTO mirNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","coo hajxy mhix̱y coo wiam̱y, mnajuøøby hajxy coo pioodtägøøñä. ");
INSERT INTO mirNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jaduhṉ mäwíinäts jeꞌe coo jaꞌa hijxtahṉd hajxy mhijxtsóonät, mnajuǿꞌøwäp hajxy jaduhṉ coo yhabaatnä coo Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Coo jaduhṉ yhabáadät nébiøch cham̱ nmädiaꞌaguiän, cahnä jäyaꞌayhajxy hänajty quiøx̱y hoꞌogyñä jaꞌa hajxy jädaꞌahatypä. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tägoyyaam̱bä tsajtwiing møødä naax̱wiin, pero tøjiadaam̱b nébiøch cham̱ nmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","’Mniyajcopcøꞌøwǿøjäp hajxy. Cab hajxy mnajuøꞌøy mänáajøch ngädaactägatsaꞌañ. Paady hajxy hoy mhídät. Cab hajxy mhuꞌug cab hajxy mjǿøꞌxät. Cab hajxy tii mhadsógät hädaa yaabä naax̱wiin. Pønjaty jaduhṉ caꞌa cudiuum̱b, haxøøg hajxy jiadaꞌañ yhabetaꞌañ, høxtä hoy hajxy maa cu jia tsänaꞌaw. ");
INSERT INTO mirNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nähix̱ hahixøꞌø hajxy mhídät. Homiänaajä hajxy mDiospaꞌyáꞌaxät neby hajxy haxøøg mgaꞌa jat mgaꞌa habétät, nébiøch hajxy hoy xwyiingudsähgǿꞌøwät, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Xøømbaadiä Jesús hänajty yajnähixøꞌøy tsajtøgooty. Coodspaady hänajty wiädity maa jaꞌa tuṉ xiøhatiän Olivos. ");
INSERT INTO mirNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jopyñä jaꞌa jäyaꞌayhajxy hänajty quiøx̱y hamugøꞌøy tsajtøgooty coo jaꞌa Jesús miädiaꞌagy hajxy hänajty wyiꞌi yhamädoow̱hidaaṉä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tøø jaꞌa pascuaxøø hänajty miäwiingooṉnä mänaa jaꞌa tsajcaagy hajxy hänajty quiayyän jaꞌa cajpä tsooy miǿødäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jia wiꞌi xyiictaacypy jia wyiꞌi miädiaactaacypy jaꞌa teedywiindsøṉhajxy hänajty møødä ley‑yajnähixøøbiähajxy nebiä Jesús hajxy yaghóꞌogät. Pero chähgøøbiä cuꞌug hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mänitä Judas Iscariote jaꞌa Satanás jioottägøøyy quioptägøøyyä. Jesús jiamiøød hänajty jeꞌe tuꞌug maa jaꞌa nämajmetspän. ");
INSERT INTO mirNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mänitä Judas jaꞌa teedywiindsǿṉ hoy miøødmädiaꞌagy møødä møjhajpä hajxy maa jaꞌa tsajtøjcän. Jeꞌe yajmøødmädiaac nebiä Jesús yajcøꞌødägǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mänitä teedywiindsøṉhajxy xiooṉdaacy. Mänitä Judas hajxy ñämaayy coo xädøꞌøñ hajxy mioꞌowaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mänitä Judas ñähadsooyy. Mänit tiägøøyy wiinmahñdyhajpä nebiä Jesús yajcøꞌødägøꞌøwaꞌañ, mänaa jaꞌa cuꞌughajxy hänajty quiaꞌa jaty mayyän. ");
INSERT INTO mirNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mänitä pascuaxøø yhabaatnä mänaa jaꞌa tsajcaagy hajxy quiayyän, jaꞌa cajpä tsooy miǿødäbä. Yojxypä meeghuung hajxy hänajty jaꞌa pascuaxøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mänitä Jesús ñämaayy jaꞌa Pedro møødä Juan: ―Nøcx jaꞌa tsuugay hajxy yaghoyøꞌøw. Tøø yhabaady coo hajxy ndsuugayáaṉäm jaꞌa pascuaxøøgøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mänitä Jesús hajxy miäyajtøøyy: ―Maa højts nyaghoyǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mänitä Jesús yhadsooyy: ―Coo hajxy mgajptägǿꞌøwät, mbaadaam̱biä jäyaꞌay hajxy tuꞌug majtcóṉ. Mbanǿcxäp hajxy maa tiøjtägøꞌøwaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mänitä cudøjc hajxy mnämáꞌawät: “Højts nWiindsǿṉ tøø xquiex̱y coo højts miic̈h nmäyajtǿwät maa hawaꞌadspä jii maa højts ndsuugáyät jaꞌa pascuaxøøgøxpä.” ");
INSERT INTO mirNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mänitä hawaꞌadspä hajxy xmioꞌowaꞌañ cruundä jim̱ cøxp. Tøø hajxy hänajty hoy yajxóṉ yaghoyøꞌøy. Jim̱ä tsuugay hajxy myaghoyǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mänit hajxy hoy piaady nebiatiä Jesús hänajty tøø miänaꞌañän. Mänitä tsuugay hajxy yaghoyøøyy jaꞌa pascuaxøøgøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Coo yhabaatnä, mänitä Jesúshajxy yhäñaaguiädaacy meexäwiinduum møødä jiamiøødhajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mänitä Jesús miänaaṉ̃: ―Cooc̈h nhoꞌogaaṉnä, jootcújc‑høch nnijiäwøꞌøyii cooc̈h mijts nmøødtsuugayaꞌañ jaꞌa pascuaxøøgøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cábøch mijts nmøødtsuugaadiägatsaꞌañ høxtä coonä yhabáadät mänaa jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañän. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mänitä Jesús jaꞌa vaso tuꞌug quionøꞌcy vinomøød. Mänitä Dioscujúꞌuyäp yejcy. Mänit miänaaṉ̃: ―Huucmuc hajxy hädaa nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Cábøc̈hä vino nhuuctägatsaꞌañ høxtä coonä yhabáadät coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mänitä Jesús tsajcaagy quionøꞌcy. Mänitä Dioscujúꞌuyäp yéjcombä. Mänitä tsajcaagy qyijwaꞌxy. Mänitä jiamiøød miooyy. Mänit miänaaṉ̃: ―Høøc̈h nniꞌx ngopc hädaa. Jaꞌa mijtscǿxpøch nniñähdugaꞌañii cooc̈h mijts nnähhoꞌtuꞌudaꞌañ. Naaghóoc‑høch mijts xjiahmiejtstaꞌagy, jaduhṉä tsajcaagy hajxy mgáyät. Coo hajxy quiaabiädøøyy, mänitä Jesús jaꞌa vaso quionøꞌcy, jaꞌa hänajty vinomøødpä. Mänit miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","―Hädaa vino, hijxtahṉd jaduhṉ miähmøꞌøwaꞌañ nébiøch nnøꞌty nyaghäyowaꞌañän cooc̈h mijts nnähhoꞌtuꞌudaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Pero jaꞌa craa xyegáam̱bøc̈hä, yaac̈h jaduhṉ xmiøødhäñaꞌay maa hädaa meexän. ");
INSERT INTO mirNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tsipcǿxpøch nhoꞌogaꞌañ nébiøc̈hä Dios tøø xyajnähdijjiän, høøc̈h jaꞌa Diosquex̱ypä. Pero jaꞌa craa xyegaam̱bä, maas haxøøg jiadaꞌañ yhabetaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mänitä Jesús jiamiøødhajxy tiägøøyy nimiäyajtǿøw̱äbä hamiṉ̃ haxøpy pøṉä Jesús yegaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mänit hajxy tiägøøyy yajcapxiøøbiä pøṉ møjtuuṉg moꞌowáaṉäp. ");
INSERT INTO mirNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mänitä Jesús miänaaṉ̃: ―Hädaa hajxy yaa gobiernähajpä hädaa yaabä naax̱wiin, näꞌä hanehm̱b hajxy. Tsipcøxpä cuꞌughajxy quiudiuṉ̃ neby hajxy yhaneꞌemyiijän. ");
INSERT INTO mirNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero mijts, cab hajxy mnibiädaꞌagǿøjät nebiä gobiernän. Pøṉ møjtuuṉg møød maa mijtsän, ween ñibiädaꞌagyii nebiä tuuṉg møj caꞌa møødpän. Pøṉ hanehm̱b maa mijtsän, ween ñibiädaꞌagyii nebiä moonsän. ");
INSERT INTO mirNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Pøṉ møjtuuṉg møød, jaꞌa craa caabiä, tøgä craa mäyajcaabiä. Jaꞌa craa caabiä, jeꞌeds møjtuuṉg møød. Pero høøc̈h mijts nyajcaaby, hóyhøch møjtuuṉg nja møødä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Tøøc̈h mijts xmiøødyoꞌoy xmiøødnax̱y tsip xex̱. ");
INSERT INTO mirNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Páadyhøch mijts møjtuuṉg nmoꞌowaꞌañ, nébiøch nDeedy tøø xmioꞌoyän, ");
INSERT INTO mirNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","neby hajxy jim̱ mgay mhúꞌugät maac̈h nmeexäwiinduumän maac̈h ngobiernähadaꞌañän, nebiä hoyhäñaabiejt hajxy myaghäñaꞌawǿꞌøwät mänaa jaꞌa judíos hajxy mhaneꞌemaꞌañän, jaꞌa nämajmetsc‑hagajptpä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mänitä Jesús jaꞌa Pedro ñämaayy: ―Simón, Simón, mniyajcopcøꞌøwǿøjäp. Tøøc̈hä Satanás cuhdujt xjia mäyujwaꞌañ coo mijts xyajtuꞌudägóyyät. ");
INSERT INTO mirNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero tøøc̈hä Dios nmänuuꞌxtaꞌagy jaꞌa miic̈hcøxpä nébiøch miic̈h nmädiaꞌagy homiänaajä xmiäbǿjcät. Coo miic̈h hänajty tøø mwiinmahñdymejtsnä, mjoodcapxmøcpǿgäp jaꞌa mjamiøødtøjc neby hajxy jaduhṉ quiaꞌa tuꞌudägóyyät. ");
INSERT INTO mirNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mänitä Pedro jaꞌa Jesús ñämaayy: ―Homiáajøch miic̈h nbanǿcxät, hoy jia pujxtøgootiä. Høxtä näguipxy jaduhṉ nmøødhóꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mänitä Jesús miänaaṉ̃: ―Pedro, cham̱ nnämaꞌay, cahnä tseey hänajty yaꞌaxyñä, tøø miic̈h hänajty tägøøghooc mnijiøgapxyii cooc̈h tyijy xquiaꞌa hix̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mänitä Jesús miäyajtøøyy jaꞌa jiamiøødhajxy: ―Cooc̈h mijts nguejxy Diosmädiaꞌagy‑yajwaꞌxpä, mänítøch mijts nnämaayy coo hajxy tii mgaꞌa wähátät, ni xuumy, ni xädøꞌøñhidøhñdy, ni cøꞌøg. Y tii hajxy myajmaajiajt. Mänit hajxy yhadsooyy: ―Ni tii. ");
INSERT INTO mirNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mänitä Jesús miänaaṉ̃: ―Pero chaac̈h nmänaaṉnä coo xuumy hajxy mwähátät møødä xädøꞌøñhidøhñdy. Pøṉ espada caꞌa møød, weenä wyit tioogy nebiä espada jiúyät. ");
INSERT INTO mirNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tsipcøxp tiøjiadaꞌañ neby jim̱ myiṉ̃än cujaay maa jaꞌa Diosmädiaꞌaguiän jaꞌa høøc̈hcøxpä: “Caꞌawiindøyhänaꞌc jaduhṉ tyijjä.” Cøx̱iä jaduhṉ tiøjiadaꞌañ neby jim̱ myiṉ̃än cujaay jaꞌa høøc̈hcøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mänit hajxy miänaaṉ̃: ―Chaa højts espada metsc nmøødä. Mänitä Jesús yhadsooyy: ―Mädøyyä jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Mänitä Jesús tiuꞌubøjcy. Mänit ñøcxy maa jaꞌa Olivostuṉän neby hänajty ñäꞌägä cuhdujthatiän. Quipxiä jiamiøødhajxy pianøcxy. ");
INSERT INTO mirNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Coo hajxy jim̱ miejch, mänitä Jesús miänaaṉ̃: ―Tsøgä Dios hajxy paꞌyáax̱äm; jaduhṉ hajxy mgaꞌa tuꞌudägóyyät. ");
INSERT INTO mirNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mänitä Jesús ñøcxy jäguem̱juøøby nidiuhm̱ Diospaꞌyaax̱pä. Mänit jyijcädaacy. ");
INSERT INTO mirNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Mänit miänaaṉ̃: ―Teedy, coo miic̈h jaduhṉ mmänáꞌanät, cábøch hädaa tsaac̈hpä peenä nmänáxät. Pero caꞌa yhøøc̈h nguhdujtä nyaghidaam̱by; miic̈h mguhdujt hidaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mänitä Diosmoonsä tuꞌug ñäguehx̱tøøꞌxy. Tsajpootyp hänajty chooñ. Jaꞌa Jesús jaꞌa mäjaa hoy mioꞌoy. ");
INSERT INTO mirNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jaanc̈h tehm̱ chaac̈hpøjpä Jesús hänajty. Mänitä Dios miänuuꞌxtaacy nägøꞌø nädecypiä. Mänit xiäbitnøø tiägøøyy taꞌxpä naax̱wiin nebiä nøꞌtiän. ");
INSERT INTO mirNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Coo jaꞌa Jesús Dyiospaꞌyaax̱pädøøyy, mänit tiänaayyøꞌcy. Mänitä jiamiøødhajxy hoy yhixøꞌøy. Haagä maab hajxy hänajty jeꞌeguiøxpä coo hajxy hänajty jiaanc̈h tehm̱ jiootmayhaty. ");
INSERT INTO mirNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Mänitä Jesús miänaaṉ̃: ―Tii hajxy coo mwiꞌi miaꞌay. Pädøꞌøg hajxy. MDiospaꞌyáꞌaxäp hajxy; jaduhṉ hajxy mgaꞌa tuꞌudägóyyät. ");
INSERT INTO mirNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jim̱nä jaꞌa Jesús hänajty miädiaꞌagyñä, mänitä cuꞌug miejch. Jaꞌa Judas hänajty copc‑hajp maa jaꞌa cuꞌughajxiän. Jeꞌe jaꞌa Jesús hänajty tøø jiamiøødhaty maa jaꞌa nämajmetspähajxiän. ");
INSERT INTO mirNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mänitä Jesús hoy chuꞌxy. Mänitä Jesús miänaaṉ̃: ―Judas, nej, tsuꞌxyháamhøch miic̈h xyegaꞌañä, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mänitä Jesús jiamiøødhajxy miänaaṉ̃: ―Wiindsǿṉ, nej, pädǿꞌøgäp højts espadahaamä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mänitä Jesús jiamiøød tuꞌug tiaatspujxtuuty jaꞌa teedywiindsǿṉ mioonsä. Jaꞌa hahooybä taatsc ñäbujx. ");
INSERT INTO mirNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mänitä Jesús miänaaṉ̃: ―Ween hajxy yhity. Ween tiuhṉä. Mänitä Jesús jaꞌa craa tiaatsc piädaacä. Tsooc jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mänitä Jesús ñämaayy jaꞌa teedywiindsøṉhajxy, møødä tsajtøjwiindsøṉhajxy, møødä møjtøjc‑hajxy, jaꞌa Jesús hajxy hänajty yajpädøꞌøgaam̱bä: ―Nej, méeꞌtspøch hajxy jaduhṉ xtyijjiä coo espada coo wojpt hajxy mmäbädøꞌøguiä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Cooc̈h mijts hijty nmøødhity tsajtøgooty najxpäxøø, cábøch mijts hijty nej xtiuṉ̃. Pero tøø yhabaatnä cooc̈h mijts xmiádsät jaꞌa haxøøgpä miäjaagøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mänitä Jesús hajxy miajch. Mänit hajxy yajnøcxy maa jaꞌa teedywiindsǿṉ tiøjcän. Jäguem̱juøøbiä Pedro hänajty piayoꞌoy. ");
INSERT INTO mirNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mänitä soldado jøøn hajxy tiägøøyy yajmøjjøøbiä jim̱ tøbaꞌamhagujc. Mänit hajxy yhøxtaacy piquiä jøømbaꞌaxaam̱bä. Mänitä Pedro piahøxtaacpä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mänitä toꞌoxymoonsä jaꞌa Pedro yhijxy coo jiiby piahäñaabiä. Mänit miänaaṉ̃: ―Yøꞌø mix̱y, jaꞌa Jesús jiamiøød yøꞌø. ");
INSERT INTO mirNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mänitä Pedro ñijiøgapxä: ―Piꞌmuuxy, cábøc̈hä Jesús nhix̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mänitä Pedro yhøxcájpägombä wiinghänaꞌc. Mänit ñämaayyä: ―Miic̈h mjamiøød jeꞌe, tuhm̱ds. Mänitä Pedro yhadsooyy: ―Joom, caj tiøyyä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tøø hänajty tuꞌhorä yhity, mänitä Pedro ñänøøm̱ä: ―Tøyhajt jaduhṉ coo jaꞌa Jesús jiamiøød yøꞌø. Galilea yøꞌø craa chohm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mänitä Pedro miänaaṉ̃: ―Joom, pätiidä miic̈h jaduhṉ mnäꞌä mädiaacypy. Tuuṉä Pedro jaduhṉ ñäꞌä mänaaṉ̃, mänitiä jaꞌa tseey jiaanc̈h yaax̱y. ");
INSERT INTO mirNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mänitä Jesús jaꞌa Pedro miøjheeꞌpy. Mänitä Pedro cøjx jiahmiech waam̱baty hänajty tøø ñämaꞌayíijäm jaꞌa Jesús: “Cahnä tseey hänajty yaꞌaxyñä, tøø miic̈h hänajty tägøøghooc mnijiøgapxyii cóogøch tyijy xquiaꞌa hix̱iä.” ");
INSERT INTO mirNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mänitä Pedro wyiimbijnä. Mänit hoyhoy jiøøyy. ");
INSERT INTO mirNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mänitä Jesús tiägøøyyä näxíicäbä näyáax̱äbä jaꞌa hänaꞌc‑hajxy hänajty hadänaabiä. Mänit tiägøøyyä wobhóꞌcäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mänit hajxy wyiinguxodsøøyy. Mänit hajxy wyiinguwobøøyy. Mänitä Jesús ñämaayyä: ―Najuøꞌøw pøṉ tøø xwiopy. ");
INSERT INTO mirNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jaanc̈h tehm̱ yhaxøøgjatiä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Coo jiobøøyy, mänitä judíoshajxy yhamugøøyy, møødä møjtøjc‑hajxy, møødä teedywiindsøṉhajxy, møødä ley‑yajnähixøøbiähajxy. Mänitä Jesús hajxy yajnøcxy maa junta hajxy hänajty yagjadyiijän. Mänit hajxy miäyajtøøyy: ");
INSERT INTO mirNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Højtsä tøyhajt móoyyäc, nej, miic̈h Dios tøø xquiex̱iä. Mänitä Jesús yhadsooyy: ―Hóyhøch jaduhṉ cu nja mänaꞌan, cábøch mijts häyaa xñäꞌä mäbǿjcäbät. ");
INSERT INTO mirNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y cooc̈h mijts waam̱baty nmäyajtǿwät, cábøch hajxy xyhadsówät, ni cábøch hajxy xyhøxmádsät. ");
INSERT INTO mirNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tøø yhabaatnä cooc̈h jim̱ nnøcxaaṉnä maa jaꞌa Diosän, jaꞌa møjcuhdujtmøødpä. Jím̱høch nøcxy nhäñaꞌawaꞌañ maa jaꞌa yhahooyhaampiän, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mänit hajxy wyiꞌi miäyajtøøyy: ―Nej, miic̈hä Dios xyHuunghajpä. Mänitä Jesús yhadsooyy: ―Tøyhajt jaduhṉ nej mijts mmänaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mänit hajxy miänaaṉ̃: ―Tii testigo hajxy nnäꞌä jaac wáaṉämät. Hamdsoo hajxy tøø nmädóow̱äm coo hamdsoo tøø ñimiädiaꞌagyii. ");
INSERT INTO mirNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mänit hajxy nägøx̱iä tiänaayyøꞌcy. Mänitä Jesús hajxy yajnøcxy maa jaꞌa Pilato wyiinduumän. ");
INSERT INTO mirNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mänit hajxy tiägøøyy nähwaam̱bejpä: ―Jim̱ hädaa craa jaꞌa cuꞌug hijty wyiꞌi quiapxhiṉ̃. Nøm̱ hijty miänaꞌañ coo højtsä gobiernä xädøꞌøñ ngaꞌa móꞌowät jaꞌa jim̱ tsänaabiä Roma. Jaduhṉ hijty miänaam̱bä cooc tyijy jaꞌa Dios tøø quiexyii gobiernähajpä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mänitä Pilato jaꞌa Jesús miäyajtøøyy: ―Nej, jaduhṉ miic̈h mnibiädaꞌagyii nebiä gobiernän maa hädaa judíoscájptänä. Mänitä Jesús yhadsooyy: ―Tøyhajt jaduhṉ nej miic̈h mmänaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mänitä Pilato ñämaayy jaꞌa teedywiindsøṉhajxy møødä cuꞌug: ―Cábøch hädaa craa nhix̱y coo tii pojpä quiaꞌa møødä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mänit hajxy tehṉgajnä wyiꞌi yaꞌaxy: ―Høhṉdaꞌagymiädiaꞌagyhaam yøꞌø craa yajnähixøꞌøy jaꞌa Judeabä‑jäyaꞌayhajxy. Jim̱ yajtsohṉdaacy Galilea. Yaa tøø miech. Jaduhṉ yaa jiatcøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Coo jaꞌa Pilato jaduhṉ miädooyy, mänit yajtøøyy pø jim̱ä Jesús jiaanc̈h tsooñ Galilea. ");
INSERT INTO mirNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Coo jaꞌa Pilato yhawáaṉäxä cooc jaꞌa Jesús jim̱ chooñ, mänitä Pilato jaꞌa Jesús quiejxy maa jaꞌa Herodes wyiinduumän. Hix̱, gobernador jaꞌa Herodes hänajty jim̱ tiuum̱by Galilea. Tøø hänajty quioody Jerusalén xøøhajpä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Coo jaꞌa Herodes jaꞌa Jesús yhijxy, mänit jiootcugøøyy jeꞌeguiøxpä coo hänajty jia wiꞌi yhixaꞌañ. Tøø hänajty miädoyhaty coo jaꞌa Jesús jaꞌa hoy‑yagjuøøñäjatypä hänajty tøø yajcähxøꞌøgy. Jaduhṉä Herodes hänajty jia wiꞌi yhixaꞌañ coo jaꞌa Jesús jaꞌa hoy‑yagjuǿøñäbä yajcähxǿꞌøgät. ");
INSERT INTO mirNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mänitä Herodes jaꞌa Jesús madiuꞌu jia wiꞌi miäyajtøøyy, pero cabä Jesús ñäꞌägä hadsooyy. ");
INSERT INTO mirNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tehṉgajnä jaꞌa Jesús hänajty ñähwaam̱bedyíijäm jaꞌa teedywiindsøṉhajxy møødä ley‑yajnähixøøbiähajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mänitä Herodes jaꞌa Jesús hajxy tiägøøyy näxiicpä näyaax̱pä møødä soldadohajxy. Mänitä wit hajxy yajpägøøyy yajxoṉbä nebiä rey wyitän. Mänitä Herodes jaꞌa Jesús quiejxwiimbijty maa jaꞌa Pilatän. ");
INSERT INTO mirNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mänitxøø jaꞌa Pilato jaꞌa Herodes miøødnimiäguꞌughajpøjcä. Nimiädsiphájtäp hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mänitä Pilato yaax̱mujcy jaꞌa teedywiindsøṉhajxy møødä copc‑hajpähajxy møødä cuꞌughajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Mänit miänaaṉ̃: ―Míjtshøch hädaa craa tøø xyajnämech. Mmänaam̱b mijts jaduhṉ coo jaꞌa cuꞌug hijty quiapxhiṉ̃. Tøøc̈h nja yajmäyach maa mijts mwiinduumhajxiän, y tøø hajxy mhix̱y mmädoy coo jaꞌa pojpä quiaꞌa møødä nej mijts tøø mja nähwaam̱betiän. ");
INSERT INTO mirNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ni jaꞌa Herodes quiaꞌa mänaꞌañ coo jaꞌa pojpä miøødä, paady tøø quiejxwiimbity. Tøø hajxy mhix̱y coo jaꞌa pojpä quiaꞌa møødä. Paady, cábøch nyajyaghoꞌogaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jayǿjphøch nyajcumädow̱aꞌañ, mänítøch nhøxmadsaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Jaduhṉ hajxy hänajty quiuhdujthaty coo jaꞌa tsum̱yjiäyaꞌay hajxy hänajty tuꞌug yhøxmach jaꞌa pascuaxøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mänit hajxy nägøx̱iä yaax̱y: ―Caꞌa yøꞌø craa mhøxmach. Jueꞌe mhøxmádsäp jaꞌa craa Barrabáshajpä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Paadiä Barrabás hänajty tøø chumyii coo jaꞌa tsip hänajty tøø yajpädøꞌøgy cajptooty, møød coo hänajty tøø miäjäyaꞌay‑yaghoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jia wiꞌi yhøxmadsaam̱by jaꞌa Pilato jaꞌa Jesús hänajty. Jaduhṉä cuꞌug jia nämáaguiombä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mänitä cuꞌughajxy maas møc jiaac yaax̱y: ―Møjpahbet hajxy cruzcøxp, møjpahbet hajxy cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Miädägøøghoocpä jaꞌa Pilato jia mänáaṉgombä: ―Pero nébiämäts jaduhṉ tøø jiatcøꞌøy. Cabä pojpä tii miøødä. Nébiøch nyajyaghoꞌogǿøjät. Nyajcumädow̱áam̱biøch. Mänítøch nhøxmadsaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero tehṉgajnä hajxy jiaanc̈h tehm̱ yaꞌaxy coo jaꞌa Jesús miøjpahbedǿøjät cruzcøxp. Jaduhṉdsä teedywiindsøṉhajxy yaax̱pä. Mäjädaac hajxy jaduhṉ neby hajxy hänajty miänaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mänitä Pilato miänaaṉnä coo jaꞌa Jesús miøjpahbedǿøjät cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mänit Barrabás yhøxmajch, jaꞌa cuꞌughajxy hänajty tøø yajnähdíjjiäbä, jaꞌa hänajty tøø chumyíijäbä jeꞌeguiøxpä coo tsip hänajty tøø yajpädøꞌøgy, møød coo hänajty tøø miäjäyaꞌay‑yaghoꞌogy. Mänitä Pilato yhanehm̱y coo jaꞌa Jesús miøjpahbedǿøjät cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jim̱ä soldado jaꞌa Jesús hajxy hänajty yajnøcxy maa hajxy hänajty miøjpahbedaꞌañän. Mänitä jäyaꞌay hajxy tuꞌug miajch, jaꞌa xøhajpä Simón, jaꞌa Cirenetsohm̱bä. Camjootiä Simón hänajty tøø yhoy. Mänitä cruz hadsip yajtsøm̱duꞌubøjcä. Høxhaamä cruz miäyohy. ");
INSERT INTO mirNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jaanc̈h tehm̱ ñämay hajxy hänajty pianøcxy møødä toꞌoxiøjc‑hajxy. Jǿøyyäp yáax̱äbä toꞌoxiøjc‑hajxy hänajty ñøcxy. Jootmayhajp hajxy hänajty jaꞌa Jesúscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mänitä Jesús jaꞌa toꞌoxiøjc‑hajxy miøjheeꞌppejty jaꞌa hajxy tsohm̱bä Jerusalén. Mänit hajxy ñämaayyä: ―Caꞌac̈h hajxy xñäjøꞌøy. Mijts hamdsoo mniñäjøꞌøwǿøjäp møødä mhuunghajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Habaadaam̱b jaduhṉ coo jaꞌa jäyaꞌayhajxy miänaꞌanaꞌañ: “Jootcujcä toꞌoxiøjc‑hajxy yhity jaꞌa yhuung caꞌa hijpä.” ");
INSERT INTO mirNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mänitä jäyaꞌay jaꞌa tuṉ hajxy ñämaꞌawaꞌañ: “Højts nähgahbéjtäc, højts yúꞌtsäc.” ");
INSERT INTO mirNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Xchaac̈htiunáam̱bøch jaꞌa jäyaꞌayhajxy, hóyhøc̈hä pojpä cädieey ngaꞌa ja møødä. Maas hanax̱iä mijts mjadaꞌañ mhabetaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Metscä meeꞌtspädøjc jaꞌa Jesús hänajty quipxy nøcxy miøødmøjpahbedaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Coo hajxy jim̱ miejch maa hänajty xiøhatiän “Maa jaꞌa Hoꞌogyjiäyaꞌaguiopc Ñähgädáꞌaguiän”, mänitä Jesús miøjpahbejtä cruzcøxp møødä meeꞌtspädøjc, tuꞌug hanajtyhaamby, tuꞌug hahooyhaamby. ");
INSERT INTO mirNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jim̱nä jaꞌa Jesús hänajty miøjpahbedyiinä, mänit miänaaṉ̃: ―Teedy, meeꞌx yøꞌø hänaꞌc‑hajxy; cab hajxy ñajuøꞌøy tii hajxy jaduhṉ coo jiatcøꞌøy. Mänitä soldado jaꞌa Jesús wyit hajxy tiägøøyy yajniguiuhäyǿꞌcäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jim̱ä cuꞌughajxy hänajty miäheeꞌpnaꞌay møødä tuuṉgmøødpähajxy. Jim̱ä Jesús hajxy hänajty wyiꞌi ñäxiꞌigy: ―Yajnähwaachp yøꞌø craa hijty wiinghänaꞌc. Ween hamdsoo yajniñähwaꞌac̈hii pø tøy jaduhṉ Dyioshuungä, pø tøy jaduhṉ Dyiosquex̱iä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jaanä jaduhṉä soldadohajxy wyiꞌi ñäxiicpä. Mänitä Jesús vinagre yaghuucä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Mänit ñämaayyä: ―Pø tøy miic̈hä judíoshajxy xquiobiernähaty, hamdsoods yajniñähwaꞌadsøø. ");
INSERT INTO mirNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mänitä soldado puꞌuyhuung hajxy jim̱ yujpahy cruzcuhduum. Tägøøgtuꞌu hayuuc hänajty miøødä cujaay: “Hädaadsä judíoshajxy guiobiernähajpy.” Griegohaam hänajty quiujaayä, møødä latínhaam, møødä hebreohaam. ");
INSERT INTO mirNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mänitä meeꞌtspä tuꞌug miänaaṉ̃, jaꞌa hänajty tøø miøjpahbéjtäbä cruzcøxp: ―Pø tøyyä Dios tøø xquiex̱y, hamdsoods yajniñähwaꞌadsøø, y yajnähwáatsägäts højtspä ―nøm̱ä Jesús ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Mänitä craa yhojjä jiamiøød: ―Nej, cájtämä Dios mwiingudsähgøꞌøyä. Paady højts ngumadow̱áaṉäm coo tøø ngädiéhyyäm. Pero hädaa craa, caj nej tøø jiatcøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mänitä Jesús ñämaayyä: ―Jesús, høøc̈h xjiahmiédsäp coo miic̈h hänajty mdägøꞌøwaꞌañ gobiernähajpä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mänitä Jesús yhadsooyy: ―Tøyhajt jaduhṉ nnämaꞌay, jädáꞌajøch miic̈h jim̱ xmiødhadaꞌañ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Cujyxiøø hänajty jeꞌe, mänit wyiingoodsøøyy wiinduhm̱yhagajpt. Tägøøghorä yhijty wiingoods. ");
INSERT INTO mirNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Cabä xøø hänajty maa ñäꞌä haṉ̃. Mänitä tsajtøjc‑hadøødiuc quiøøꞌtswaꞌxy cujjiä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mänitä Jesús yaax̱y: ―Teedy, høøc̈h miic̈h njoot njuøhñdy nyajcøꞌødägøꞌøwaam̱by. Jagoo jaduhṉ jiaac mänaaṉnä, mänitiä yhoꞌnä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mänitä soldadowiindsǿṉ yhijxy nebiä Jesús jiajtiän. Mänit jia mänaaṉ̃ coo jaꞌa Dios miøjjä jiaanc̈hä, coo jaꞌa Jesús jaꞌa pojpä hijty quiaꞌa møødä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Coo jaꞌa cuꞌughajxy yhijxy nebiä Jesús jiajtiän, mänit hajxy wyiimbijnä jootmayhájtäp. ");
INSERT INTO mirNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jim̱ä Jesús miäguꞌughajpähajxy hänajty tiänaꞌay jäguem̱juøøby møødä toꞌoxiøjc‑hajxy, jaꞌa hajxy hänajty jim̱ tøø piadsóoñäbä Galilea. Yhijx hajxy jeꞌebä nebiä Jesús jiajtiän. ");
INSERT INTO mirNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jim̱ä hojiäyaꞌay hänajty tuꞌug jaꞌa xøhajpä José. Arimatea hänajty chooñ jim̱ Judeanaaxooty. Møjtuuṉg hänajty miøød maa jaꞌa judíoscajptän. ");
INSERT INTO mirNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Pero cab jaduhṉ piamänaaṉ̃ coo jaꞌa Jesús cu yaghoꞌcä. Jiøbhijxyp hänajty jeꞌe coo jaꞌa Dios jaꞌa miäjaa yajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mänitä José jaꞌa Pilato jaꞌa cuhdujt hoy miäyujwaꞌañ coo jaꞌa hoꞌogyjiäyaꞌay yajmänácät cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Coo jaꞌa cuhdujt jaduhṉ miooyyä, mänit yajmänajcy. Mänitä poobwit yajnähbijty. Mänit hoy yajnaax̱tägøꞌøy maa jaꞌa tsaajutän jaꞌa naam̱hädiúṉ̃äbä. ");
INSERT INTO mirNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mänacyxiøø hänajty jeꞌe mänaa jaꞌa Jesús ñaax̱tägøꞌøyän. Viernes hänajty jeꞌe. Hadsuujǿøñäp hänajty; jaꞌa pooꞌxxiøø hänajty habáatnäp. ");
INSERT INTO mirNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jaꞌa toꞌoxiøjc‑hajxy, jaꞌa Jesús hajxy hänajty tøø piadsóoñäbä Galilea, mänitä Jesús hajxy hoy yhix̱y maa hänajty tøø ñaax̱tägøꞌøyän. ");
INSERT INTO mirNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Coo hajxy wyiimbijty, mänitä paꞌagxuuꞌpähóṉ hajxy hoy jiuy. Mänit hajxy piooꞌxnä jaꞌa pooꞌxxiøøjooty neby hajxy hänajty quiuhdujthatiän. ");
INSERT INTO mirNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Näxøøjopiä toꞌoxiøjc‑hajxy ñøcxtägajch maa jaꞌa Jesús hänajty tøø ñaax̱tägøꞌøyän møødä jiamiøødhajxy wiingpä. Paꞌagxuuꞌpähoṉgóṉ hajxy ñøcxy jaꞌa hajxy hänajty tøø jiúyyäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Coo hajxy jim̱ miejch, mänit hajxy yhijxy coo jaꞌa tsaajut hänajty tøø yhawaꞌac̈h. ");
INSERT INTO mirNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mänit hajxy jiiby tiägøøyy. Cab hajxy jiiby pøṉ piaaty. ");
INSERT INTO mirNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mänit hajxy chähgøøyy. Cab hajxy hänajty ñajuøꞌøy neby hajxy jiatcǿꞌøwät. Mänit hajxy yhijxy coo jaꞌa jäyaꞌay hajxy hänajty metsc miøødtänaꞌay. Yajxoṉjatiä wyithajxy hänajty. Høxtä haam̱bä wyithajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mänitä toꞌoxiøjc‑hajxy ñaax̱cooyy jeꞌeguiøxpä coo hajxy hänajty chähgøꞌøy. Mänit hajxy ñämaayyä: ―Tii jaꞌa Jesús hajxy yaa coo mhøxtaꞌay maa jaꞌa hoꞌogyjiäyaꞌayhagujcän. ");
INSERT INTO mirNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Cab jeꞌe yaajän. Tøø jiujypiøjnä. Nej, cab hajxy mjahmiechä neby hajxy jiiby tøø xyajmøødmädiaꞌaguiän Galilea. ");
INSERT INTO mirNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nøm̱ä Jesús jaꞌa Diosquex̱ypä hajxy xyhawaaṉä cooc hijty quiøꞌødägøꞌøwaꞌañii jaꞌa cubojpäyaꞌay jaꞌa cugädieejiäyaꞌay, cooc hijty miøjpahbedaꞌañii cruzcøxp, cooc cudägøøgxøø hijty jiujypiøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mänit hajxy jiaanc̈h jahmiejtsnä neby hajxy hänajty tøø ñämaꞌayiijän Jesúsäm. ");
INSERT INTO mirNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mänit hajxy wyiimbijnä. Mänitä jiamiøød hajxy hoy yhawaaṉä jaꞌa nämajtuꞌugpä møødä nämaybä. ");
INSERT INTO mirNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jaꞌa toꞌoxiøjc jaꞌa mädiaꞌagy hajxy mäméjtsäbä, jueꞌe hajxy hänajty näjeꞌe xiøhaty María Magdalatsohm̱bä, møødä Juana, møødä María jaꞌa Jacobo tiaj. ");
INSERT INTO mirNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero cabä toꞌoxiøjc jaꞌa miädiaꞌagyhajxy miäbǿjcäxä jaꞌa Jesús jiamiøødhajxy. Nebiä cuhhiim̱bä‑mädiaꞌaguiän hajxy jaduhṉ miädooyy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero jaꞌa Pedro, miäbøjc jeꞌe. Päyøꞌøguiä ñøcxy maa jaꞌa Jesús hänajty tøø ñaax̱tägøꞌøyän. Coo jiiby quiuwoodsøøyy, mänitä poobwit yhijxy coo wiingtuum yhijnä. Mänit wyiimbijnä. Yagjuøøyy jaduhṉ neby hänajty tøø jiadyiijän. ");
INSERT INTO mirNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mänitxøøbä jaꞌa Jesús jiamiøødhajxy hänajty metsc ñøcxy maa jaꞌa cajpt hänajty xiøhatiän Emaús. Majtuꞌugkilómetro hänajty jiäguem̱ä maa jaꞌa Jerusaléncajptän. ");
INSERT INTO mirNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mädiáacäp hajxy hänajty tiuꞌuyoꞌoy tijaty tøø jiadyii. ");
INSERT INTO mirNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mänit hajxy wyiingumedsøøyyä jaꞌa Jesús. Mänit hajxy miøødtuꞌubøjcy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hoy hajxy jia hijxy, cab hajxy yhøxcajpy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mänitä Jesús miänaaṉ̃: ―Tii hajxy mmädiaacypy. Tii hajxy coo mdajy coo mmay. ");
INSERT INTO mirNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tuꞌjäyaꞌay hänajty xiøhaty Cleofas. Mänit yhadsooyy: ―Hopiøṉä ñajuøꞌøy tii jim̱ tøø jiadyii Jerusalén jädaꞌa xøøbä. Nej, miic̈h nidiuhm̱ mgaꞌa najuøøby tii jim̱ tøø jiadyiijä, hoy miic̈h jim̱ tøø mja hijpä. ");
INSERT INTO mirNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","20","Mänitä Jesús yhadsooyy: ―Tii jaduhṉ tøø jiadyii. Mänit hajxy yhadsooyy: ―Jaꞌa Jesús tøø yaghoꞌogyii cruzcøxp. Jaꞌa teedywiindsøṉhajxy yejc møød højts ngopc‑hajpä. Diosquex̱y hijty wiädity. Hoy‑yagjuøøñäjatypä hijty yajcähxøꞌpy. Hoy hijty miädiaꞌagy jaꞌa Dioscøxpä cuꞌughagujc. ");
INSERT INTO mirNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jaduhṉ højts njoot hijty chocy coo jaꞌa Jesús jaꞌa gobiernä Rómaba jaꞌa quiuhdujt cu piøjcä nebiä gobiernä yaa quiaꞌa hanéhm̱nät maa højts ngajptän, højts judíosjäyaꞌayhajxy. Maaxtøjcy mädägøøy jaduhṉ yaghoꞌcä. ");
INSERT INTO mirNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Haamiän jaꞌa toꞌoxiøjc‑hajxy näjeꞌe yhooyy maa jaꞌa Jesús hänajty tøø ñaax̱tägøꞌøyän. ");
INSERT INTO mirNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pero cábäc hajxy piaaty. Mänítägä Diosmoonsä hajxy metsc yhijxy jaꞌa tsajpootypä‑tsohm̱bä. Mänítäc hajxy yhawáaṉäxä cooc jaꞌa Jesús hänajty tøø jiujypiøjnä. Hoy‑yagjuøøñä højts hajxy xyajmøødmädiaacy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mänit højts njamiøødhajxy hoy yhijxpä. Jadúhṉäc hajxy piaatpä nebiä toꞌoxiøjc‑hajxy hänajty tøø ñägapxiän. Ni jéꞌegädsä Jesús hajxy quiaꞌa hijxy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mänitä Jesús miänaaṉ̃: ―Nej, cab hajxy mnäꞌägä wiinjuøꞌøyä, cab hajxy mnäꞌägä mäbøquiä nebiä Diosquex̱yhajxy jecy miänaaṉ̃än. ");
INSERT INTO mirNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tsipcøxpä Diosquex̱y chaac̈hpøgaꞌañ coo hänajty jim̱ ñøcxaaṉnä tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mänit tiägøøyy yajwiingapxøøbiä jaꞌa Diosmädiaꞌagy majaty miädiaꞌagyiijän. Jim̱ quiapxtsohṉ̃ maa jaꞌa Moisés hänajty tøø quiujaayän. Cøjx quiapxy mäduhṉ̃tiä jaꞌa Diosquex̱yhajxy quiujahyyän. ");
INSERT INTO mirNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Coo hajxy jim̱ miejch Emaús, mänitä Jesús miänaaṉ̃ cooc jiaac yoꞌoyaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mänit hajxy ñämaayyhoꞌcy: ―Huuc mähmøꞌøw yaa maa højtsän. Tøø chuujøøñä. Coodsǿøñäp jaduhṉ. Mänitä Jesús jiaanc̈h mähmøøyy. Mänit hajxy tiøjtägøøyy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mänit hajxy yhäñaaguiädaacy meexäwiinduum. Mänitä Jesús tsajcaagy quionøꞌcy. Mänitä Dioscujúꞌuyäp yejcy. Mänitä tsajcaagy qyijwaꞌxy. Mänitä jiamiøød miooyy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mänítnäts hajxy yhøxcajpnä. Mänitä Jesús yhadägoyyøøñä. ");
INSERT INTO mirNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mänit tuꞌjäyaꞌay miänaaṉ̃: ―Wíinghøch hijty nnijiäwøꞌøyii tuꞌhaambejpä coo jaꞌa Diosmädiaꞌagy xyajmøødmädiáacäm. ");
INSERT INTO mirNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mänitiä hajxy wyiimbijnä, ñøcxtägajch Jerusalén. Mänitä jiamiøød hajxy hoy piaady maa hajxy hänajty tøø yhamugøꞌøyän, jaꞌa nämajtuꞌugpä møød hajxy nämaybä. ");
INSERT INTO mirNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mänit hajxy nämetspä ñämaayyä: ―Tøyhajt jaduhṉ coo jaꞌa nWiindsøṉhájtäm tøø jiujypiøcy. Jaꞌa Simón jaduhṉ tøø yhix̱y. ");
INSERT INTO mirNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mänit hajxy jeꞌe ñägapxpä cooc jaꞌa Jesús hajxy tøø piaady tuꞌhaam. Mänítäc hajxy yhøxcajpnä coogä Jesús jaꞌa tsajcaagy qyijwaꞌxy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jiiby hajxy hänajty miädiaꞌagyñä, mänitä Jesús ñäguehx̱tøøꞌxy maa hajxy hänajty yhäñaꞌayän. Mänit yajpooꞌxy jaꞌa jiamiøødhajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mänit hajxy jiaanc̈h tehm̱ chähgøøyy. Háañämä tyijy hajxy nämejtsä. ");
INSERT INTO mirNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mänitä Jesús miänaaṉ̃: ―Tii hajxy coo mwiꞌi chähgøꞌøy. Tiic̈h hajxy coo xquiaꞌa høxcapy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Høxtáhm̱dsøch hädaa ngøꞌø, høxtáhm̱dsøch hädaa ndecy. Høøc̈h jeꞌe Jesús. Høøc̈h hajxy nähdóoṉäc. Cabä háañämä niꞌx copc miøødä nébiøch høøc̈h nmøødän. ");
INSERT INTO mirNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mänitä Jesús jaꞌa quiøꞌødiecy yaghijxy jaꞌa jiamiøødhajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero cab hajxy hamuumduꞌjoot ñäꞌägä mäbøjcy. Xooṉdaacp hajxy hänajty møød hajxy hänajty yagjuøꞌøy. Mänitä Jesús miänaaṉ̃: ―Tii hajxy jii mmøød cooc̈h ngáyät. ");
INSERT INTO mirNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mänitä hacxtsaꞌay hajxy miooyy møødä møjtsiinjøødy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mänitä Jesús quiooṉdsooyy. Mänit quiaayy maa jaꞌa wyiinduumhajxiän. ");
INSERT INTO mirNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mänit miänaaṉ̃: ―Nébiøch tøø njatiän, tøøds hajxy hijty nhawáaṉäm mänaa hajxy quipxy tøø nhíjtäm. Tøjiajt jaduhṉ jaꞌa høøc̈hcøxpä neby jiiby myiṉ̃än cujaay maa jaꞌa Moisés miädiaꞌaguiän, chaads jiiby maa jaꞌa Sálmosän, chaads jiiby maa jaꞌa librän jaꞌa Diosquex̱yhajxy jecy jiáhyyäbä. ");
INSERT INTO mirNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mänitä Diosmädiaꞌagy quiapxtøøyy: ");
INSERT INTO mirNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","―Jaduhṉ myiṉ̃ cujaay maa jaꞌa Diosmädiaꞌaguiän cooc jaꞌa Diosquex̱y tsipcøxp yhoꞌogaꞌañ, y cooc cudägøøgxøø jiujypiøjtägatsaꞌañ, ");
INSERT INTO mirNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","y cooc miädiaꞌagaꞌañii wiinduhm̱yhagajpt. Yaa Jerusalén miädiaactsoonaꞌañii. Jaduhṉä cuꞌughajxy yajwiingapxøꞌøwaꞌañii coo jaꞌa yhaxøøgcuhdujt hajxy ñajtshixǿꞌøwät. Mänit hajxy yajnähwaꞌadsaꞌañii jaꞌa piojpä quiädieey hajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hamdsoo hajxy tøø mhix̱y tøø mmädoy nébiøch cham̱ nmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nyajnäguexáam̱biøch mijts jaꞌa Dioshespíritu jaꞌa nDéedyhøch tøø xyajwiinwaaṉǿꞌøyäbä cooc̈h mijts nmóꞌowät. Jim̱ choonaꞌañ tsajpootyp. Yaa hajxy mmähmǿꞌøwät Jerusalén høxtä coonä jaꞌa Dioshespíritu hajxy hänajty tøø xñägädaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mänitä Jesús miøødcajptpädsøøm̱y jaꞌa jiamiøødhajxy. Mänit hajxy miejch maa jaꞌa cajpt xiøhatiän Betania. Mänitä Jesús jaꞌa quiøꞌø chajxajy. Mänitä Dioscujúꞌuyäp yejcy jaꞌa jiamiøødcøxpähajxy. ");
INSERT INTO mirNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mänit hajxy ñähguéecänä. Mänitä Jesús jim̱ ñøcxy tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mänitä Jesús hajxy wyiingudsähgøøyy. Mänit hajxy wyiimbijnä jaanc̈h tehm̱ jiootcujc. Mänit hajxy ñøcxy Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jabom̱‑jabom̱ hajxy hänajty ñøcxy tsajtøgooty. Nøcxy hajxy hänajty quiapxy miädiaꞌagy coo jaꞌa Dios miøjjä jiaanc̈hä. Amén.");
INSERT INTO mirNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jaꞌa Dioshuung, jeꞌe hajxy xyajnähixǿøyyäm nebiä Dios jiäyaꞌayhatiän. Jíiyyäm hänajty jeꞌe mänaa hädaa yaabä naax̱wiin yhawijy tiøøꞌxtaꞌaguiän. Jíiyyäm hänajty jeꞌe møødä Dios; Diósäts jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jim̱ hänajty jeꞌe møødä Dios mänaa hädaa yaabä naax̱wiin yhawijy tiøøꞌxtaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jaayaꞌay jaduhṉ hädiuuṉ cøx̱iä. Nidiuhm̱ yhädiuuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jaꞌa Dioshuung, yejpy jaꞌa jugyhajt jeꞌe. Jaduhṉ mäwiin jeꞌe nebiä cujajpä nebiä cudøøꞌxpän. Xyajpädsǿøm̱äm hajxy hagoodstuum. ");
INSERT INTO mirNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Coo jøøn yhajajy hagoodstuum, hoy jaduhṉ nhíjxäm. Jaꞌa Dioshuung, jaduhṉ mäwíinäts jeꞌe nebiä jøønän coo xyaghíjxäm neby hajxy hoy nwädíjtämät. ");
INSERT INTO mirNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mänitä Dios jäyaꞌay tuꞌug quiejxy, jaꞌa xøhajpä Juan. ");
INSERT INTO mirNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Paadiä Juan quiejxä, jaduhṉä Dioshuung ñägápxät, jaduhṉä jäyaꞌayhajxy nägøx̱iä miäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jaꞌa Juan, caꞌa jeꞌe Dyioshuungä. Näꞌä nägapxpä jaduhṉ quiejxä. ");
INSERT INTO mirNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tøø jaꞌa Dioshuung hänajty yaa miejtsnä hädaa yaabä naax̱wiin. Jeꞌe jaꞌa tøyhajt hajxy xmióoyyäm nägøx̱iä maa hajxy yaa ndsänáayyäm hädaa yaabä naax̱wiin. Cøx̱iä xyajnähixǿøyyäm. ");
INSERT INTO mirNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Coo yaa miejch hädaa yaabä naax̱wiin, cabä miädiaꞌagy miäbǿjcäxä, hoy hänajty cøx̱iä tøø jia hädiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jim̱ jeꞌe jia medsøøyy maa jaꞌa yhamdsoo cajptän, pero cab jim̱ chojcä. ");
INSERT INTO mirNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero näjeꞌejaty hajxy chojcy. Pøṉ jaduhṉ tsojc, pøṉ jaꞌa miädiaꞌagy mäbøjcä, jeꞌedsä cuhdujt hajxy mooyyä coo hajxy yhídät nebiä Dioshuungän. ");
INSERT INTO mirNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Cab hajxy xyhuunghájtäm nebiä yaabä teedy hajxy xyhuunghájtäm. Pero coo hajxy nmäbǿjcämät jaꞌa Dios jaꞌa miädiaꞌagy, mänit hajxy jaduhṉ xyhuunghájtämät. ");
INSERT INTO mirNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jaꞌa Dioshuung, jäyaꞌayhajt jeꞌe neby højts chaa njäyaꞌayhájtäm. Hädaa yaabä naax̱wiin jeꞌe chänaayy maa højtshájtäm. Tøø højts nhix̱y coo jeꞌe miøjjä jiaanc̈hä. Paady miøjjä jiaanc̈hä coo jeꞌe Dyioshuungä. Tiuum̱by jeꞌe jaꞌa mayhajt homiänaajä. Tømiädiaacp jeꞌe homiänaajä. ");
INSERT INTO mirNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jaayáꞌayädsä Juan jaduhṉ ñägapx: ―Yøꞌøyáꞌayhøch hijty nnägapxyp, yøꞌø høx̱haam tøø jiaac méchäbä. Høøc̈h hijty jayøjp tøø nmech. Yøꞌødsä møjcuhdujt näꞌägädä møød. Høøc̈h, cábøc̈hä cuhdujt jaduhṉ nmøødä neby yøꞌøyaꞌay miøødän. Jím̱iäm yøꞌøyaꞌay hänajty cooc̈h yaa nmiiṉ̃ ngahy. ");
INSERT INTO mirNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jaayáꞌayäts jaꞌa mayhajt tuum̱b jaꞌa højtscøxphájtäm homiänaajä. ");
INSERT INTO mirNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dios jaꞌa Moisés jaꞌa cuhdujt jaduhṉ mooyy. Højts jaꞌa Moisés jaꞌa cuhdujt xmioodiägájtsäm. Pero xchójcäm jaꞌa Dios hajxy møød xmióoyyäm jaꞌa tøyhajt. Paadiä Jesucristo yaa quiejxä. ");
INSERT INTO mirNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni pøṉ jaꞌa Dios quiaꞌa hix̱yñä. Jaꞌa yHuung, jeꞌe hajxy xyhawáaṉäm nebiä Dios jiäyaꞌayhatiän. Jiaanc̈h tehm̱ chojpy jaꞌa Dios jaꞌa Jesucristo. Tuꞌughuunghajp jaꞌa Jesucristo. ");
INSERT INTO mirNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mänitä teedyhajxy näjeꞌe jim̱ quiejxä møødä levitashajxy maa Juangän. Jaꞌa levitashajxy, tsajtøjcueendähajpä hajxy hänajty tiuuṉghajpy. Jim̱ hajxy chohṉdaacy maa jaꞌa cajpt jaduhṉ xiøhatiän Jerusalén. Jaꞌa judíos wyiindsøṉhajxy jaduhṉ mäguejx. Paadiä teedyhajxy jaduhṉ quiejxä coo jaꞌa Juan hajxy ween nøcxy tiøyhajtmädoy pøṉ jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Coo jaꞌa Juan jaduhṉ miäyajtøøw̱a, yejc jeꞌe jaꞌa tøyhajt. Caj yhøhṉdaacy: ―Caꞌa yhøøc̈hä jeꞌe jaꞌa Cristo, jaꞌa hajxy nhahíjxämbä, jaꞌa Dios tøø wyiinguéx̱iäbä coo hajxy xyhanéhm̱ämät. ");
INSERT INTO mirNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mänitä jadähooc miäyajtǿøw̱ägumbä: ―Pøṉ miic̈h. Nej, miic̈h Elíashajpä jaꞌa mináam̱bäjä. Mänitä Juan yhadsooyy: ―Caj. Mänitä miäyajtǿøw̱ägumbä: ―Nej, tøgä miic̈h jaꞌa Diosmädiaꞌagy jecy tøø mhuuc mäwädijpä. Mänitä Juan yhadsóogumbä: ―Cábämäts. ");
INSERT INTO mirNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mänitä miäyajtǿøw̱ägumbä: ―Pøṉ miic̈h. Højts jaꞌa tøyhajt móoyyäc neby højts jaꞌa nwiindsǿṉ häyaa nhawaaṉdägájtsät pøṉ miic̈h. ");
INSERT INTO mirNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mänitä Juan yhadsooyy: ―Høøc̈h, nyajcapxǿøbiøch jaꞌa Diosmädiaꞌagy møc pactuum. Panøcx jaꞌa Diostuꞌu hajxy nebiä Isaías jecy miänaaṉ̃än coo hajxy mbanǿcxät. Diosmädiaꞌagy jaꞌa Isaías jecy yajwaꞌx. ");
INSERT INTO mirNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jaꞌa hajxy hänajty tøø quiexyíijäbä maa jaꞌa Juangän, näjeꞌe hajxy hänajty pianøcxä jaꞌa fariseos jaꞌa miädiaꞌagy hajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Mänitä Juan miäyajtøøw̱a: ―Tii miic̈h coo mnäꞌä mäyajnäbejpä pø cáꞌadäm miic̈h mGrístäjä, pø cáꞌadäm miic̈h jaꞌa jäyaꞌay jaꞌa Diosmädiaꞌagy jecy tøø yajwáꞌxiäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mänitä Juan yhadsooyy: ―Høøc̈h, nøøháamhøch nmäyajnäbety. Pero xim̱a jäyaꞌay tuꞌug majiäyaꞌayhagujc. Cahnä hajxy mhix̱yhatyñä. ");
INSERT INTO mirNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jayǿjphøch nmejch. Mänit yøꞌøyaꞌay høx̱haam jiaac mejch. Møjcuhdujt yøꞌøyaꞌay miøød quejeec̈h nmøødä. ");
INSERT INTO mirNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jim̱ä Juan hänajty miäyajnäbety maa jaꞌa cajpt hänajty xiøhatiän Betábara, jaꞌa Jordángpä møjnøøhaawiimbä jaduhṉ maa jaꞌa xøø piädsøm̱iän. ");
INSERT INTO mirNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Cujaboom jaꞌa Juan jaꞌa Jesús yhijxy. Jim̱ä Jesús hänajty miänacy maa jaꞌa Juan hänajty tiänaꞌayän. Mänitä Juan miänaaṉ̃: ―Huug hix̱ hajxy, xii jäyaꞌay tuꞌug miänacy. Yøꞌø jaduhṉ xøhajp jaꞌa Meeghuung jaꞌa Dios tøø quiéx̱iäbä. Yøꞌøds hajxy jeꞌe xñähhoꞌtuꞌudáaṉäm. Yøꞌøds hajxy jeꞌe xyajnähwaꞌads xyajcuhwaꞌadsáaṉäm jaꞌa nbojpä ngädieeyhájtäm. ");
INSERT INTO mirNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yøꞌøc̈h hijty nnänøøm̱by jaꞌa høx̱haam tøø jiaac méchäbä. Høøc̈h hijty jayøjp tøø nmech. Yøꞌøds jeꞌe jaꞌa møjcuhdujt møød quejeec̈h nmøødä. Jím̱iäm yøꞌøyaꞌay hänajty mänaac̈h nmiṉ̃ ngaꞌayän. ");
INSERT INTO mirNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Cábøch hijty nnajuøꞌøy pøṉ jaduhṉ tunaam̱b nébiøch tøø nmädiaꞌaguiän. Pero páadyhøch tøø nmech mäyajnäbejpä nøøhaam neby hajxy jaduhṉ mnajuǿꞌøwät pøṉ jeꞌe, mijts judíos. ");
INSERT INTO mirNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mänitä Juan miänáaṉgumbä: ―Tøøc̈hä Dioshespíritu nhix̱y coo jim̱ tøø chooñ tsajpootyp. Mänítøch nhijxy coo hänajty miänacy nebiä palomän. Mänitä ñaax̱cädaacy. Mänitä jim̱ yhøxtaacy yøꞌøyaꞌay quiuhduum. ");
INSERT INTO mirNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Cáhnøch hänajty nnajuøꞌøy pøṉ jeꞌe. Pero jaayáꞌayhøch tøø xquiéxiäbä mäyajnäbejpä nøøhaam, jeꞌec̈h jaduhṉ xñämaayy: “Mhixaam̱biä Dioshespíritu maa jeꞌe miänacøꞌøwaꞌañän. Jim̱ jaduhṉ miähmøꞌøwaꞌañ maa tuꞌjäyaꞌay quiuhduumän. Jaayáꞌayäts jaꞌa Dioshespíritu jaduhṉ yegáaṉnäp.” ");
INSERT INTO mirNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tøøc̈h njaanc̈h hix̱y. Tøøc̈h nnägapxy coo yøꞌøyaꞌay jiaanc̈h Dioshuungä. Nyéjpiøch jaꞌa tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Cujaboom jaꞌa Juan hänajty jim̱ tiänáaguiumbä møødä jiamiøød metscä. ");
INSERT INTO mirNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jim̱ä Jesús hänajty wiädijpä. Coo jaꞌa Juan jaꞌa Jesús miøjheeꞌpy, mänitä Juan miänaaṉ̃: ―Yøꞌøds jaduhṉ xøhajp jaꞌa Meeghuung jaꞌa Dios tøø quiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Coo jaꞌa Juan jaꞌa jiamiøødhajxy jaduhṉ miädooyy, mänitä Jesús hajxy piaduꞌubøjcy nämetscä. ");
INSERT INTO mirNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Coo Jesús jiäwøøyy coo hänajty pianøcxyii, mänitä wiaꞌwiimbijty. Mänitä yhijxy coo hänajty nämetscä pianøcxyii. Mänitä miänaaṉ̃: ―Tii hajxy mhøxtaaby. Mänit hajxy yhadsooyy: ―Wiindsǿṉ, maa miic̈h tøø mmejtstaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Mänitä Jesús yhadsooyy: ―Jam̱ huug híjxäm. Mänit hajxy hoy jiaanc̈h hix̱y maa Jesús hänajty tøø miejtstaꞌaguiän. Tøø hänajty miänacyxiøøjøøñä. Jim̱ hajxy miähmøøñä maa Jesúsän. ");
INSERT INTO mirNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tuꞌugä Juan jaꞌa jiamiøød hänajty xiøhaty Andrés, jaꞌa Simón Pedro piuhyaꞌay. Jeꞌeds jaꞌa Jesús hänajty tøø piaduꞌubøcy møødä jiamiøød tuꞌug. ");
INSERT INTO mirNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mänitiä Andrés jaꞌa piuhyaꞌay hoy piaady, jaꞌa xøhajpä Simón. Mänitä Simón ñämaayy: ―Tøø højts jaꞌa Mesías nbaady ―jeꞌe jaduhṉ ñänøøm̱by jaꞌa Cristo, jaꞌa Dios tøø wyiinguéx̱iäbä coo hajxy yaa xyhanéhm̱ämät. ");
INSERT INTO mirNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Mänitä Andrés jaꞌa Simón jim̱ wioonøcxy maa jaꞌa Jesús hänajtiän. Coo jaꞌa Jesús jaꞌa Simón yhijxy, mänit miänaaṉ̃: ―Miic̈h, Simón miic̈h mxøhaty. Jonás miic̈h mdeedyhajpy. Pero Pedro mxøhataaṉnä ―jeꞌe jaduhṉ ñänøøm̱by tsaa. ");
INSERT INTO mirNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Cujaboom jaꞌa Jesús hänajty ñøcxaꞌañ Galilea. Mänitä Felipe hoy piaady. Mänitä Felipe ñämaayy: ―Jám̱høch quipxy møødwädíjtäc. Høøc̈hä nmädiaꞌagy habǿjcäc. ");
INSERT INTO mirNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Jim̱ä Felipe hänajty chooñ maa jaꞌa cajpt hänajty xiøhatiän Betsaida. Jim̱ jaꞌa Andrés hänajty chohm̱bä møødä Pedro. ");
INSERT INTO mirNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Mänitä Felipe jaꞌa Natanael hoy piaady. Mänitä Natanael ñämaayy: ―Tøø højts jaayaꞌay nbaady jaꞌa Moisés tøø ñägápxiäbä maa jaꞌa nocy piädøꞌquiän, jaꞌa Diosmädiaꞌagymiäwädijpähajxy tøø ñägápxiäbä. Jesús jaduhṉ xiøhaty. José yhuung jeꞌeduhṉ. Jim̱ jaduhṉ chooñ Nazaret. ");
INSERT INTO mirNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mänitä Natanael miänaaṉ̃: ―Nazaretä. Cabä ndijy hoybädaꞌa jim̱ Nazaret. Mänitä Felipe yhadsooyy: ―Jam̱ huug híjxäm. ");
INSERT INTO mirNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jim̱ä Natanael jaꞌa Jesús hänajty ñämech. Coo Jesús jaꞌa Natanael yhijxy, mänitä Jesús miänaaṉ̃: ―Yøꞌø judío xii miim̱bä, hamuumduꞌjoot jaꞌa Diosmädiaꞌagy quiudiuṉ̃. Ni mänaa quiaꞌa høhṉdaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mänitä Natanael jaꞌa Jesús miäyajtøøyy: ―Maac̈h miic̈h tøø xyhix̱y cooc̈h miic̈h jaduhṉ tøø xyhøxcapy. Mänitä Jesús yhadsooyy: ―Jiiby miic̈h hänajty mdänaꞌay piidspaꞌc. Cahnä Felipe hänajty xmiägapxy. ");
INSERT INTO mirNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mänitä Natanael miänaaṉ̃: ―Wiindsǿṉ, Dios miic̈h xyhuunghajp. Mhanehm̱by miic̈h jaꞌa judíoshajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mänitä Jesús miänaaṉ̃: ―Páadyhøch jaꞌa nmädiaꞌagy xmiäbøjcä cooc̈h jaduhṉ nmänaaṉ̃ cooc̈h miic̈h jiiby tøø nhix̱y piidspaꞌc. Pero mhixaam̱by cooc̈h maas hoy‑yagjuøøñäjatypä nyajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mänitä Jesús miänáaṉgumbä: ―Chaads mijts nnämáꞌawät, mhixaam̱by hajxy coo jaꞌa tsajpootyp yhawaꞌadsaꞌañ. Mhixaam̱by jaꞌa Diosmoonsä hajxy jaꞌa tsajpootypä coo hajxy chajpedaꞌañ coo hajxy ñaax̱cädaꞌagaꞌañ maac̈hä nwiinduumän, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Cumaax̱c jaꞌa pøc huꞌug hänajty jiadaꞌañii maa jaꞌa cajpt hänajty xiøhatiän Caná de Galilea. Jim̱ä Jesús jaꞌa tiaj wioow̱ä ");
INSERT INTO mirNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","møødä Jesús møødä jiamiøødhajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mänitä vino quiøjxy. Mänitä Jesús ñämaayyä jaꞌa tiaj coog jaꞌa vino tøø quiøx̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mänitä Jesús yhadsooyy: ―Maam, caꞌa mhaaw mbädaꞌagy. Caꞌa myiic̈hä mgüeendä. Høøc̈h nnajuøøby. Cahnä yhabaadyñä cooc̈h nmayhajtúnät. ");
INSERT INTO mirNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mänitä Jesús jaꞌa tiaj miänaaṉ̃, ñämaayyä jaꞌa moonsähajxy: ―Nax̱y hajxy mdehm̱ miäbǿgät coo Jesús hajxy xmiägapx xyhanéꞌemät. ");
INSERT INTO mirNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jim̱ä hamøj tsaanøøgow̱ hänajty quiärum̱naꞌay tädujcä. Tägøꞌøwaam̱b jiiby tuꞌnøøgow̱ mädaax̱c‑hiiꞌxlitro o mägoꞌxlitro. Jueꞌe jaꞌa judíos hajxy hänajty wiaꞌañ, cøꞌøbujnøøhidøhñdy. Jaduhṉ hajxy hänajty quiuhdujthaty. ");
INSERT INTO mirNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Mänitä Jesús miänaaṉ̃, ñämaayyä jaꞌa moonsähajxy: ―Cudemøꞌøw nøø hajxy nøøgow̱ooty. Cøx̱y yaghuts hajxy. Mänit hajxy jiaanc̈h yaghujch. ");
INSERT INTO mirNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mänit Jesús miänáaṉgumbä: ―Jeeꞌppädsøm̱ nøø hajxy weeṉ̃tiä. Nøcx jaꞌa mwiindsǿṉ hajxy moꞌow. Mänit hajxy jaduhṉ quiudiuuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tøø jaꞌa nøø hänajty wiaꞌañguiojy vino. Jesús jaduhṉ yajwaꞌañguioj. Mänitä moonsäwiindsǿṉ jaꞌa vino quiøøc̈hooyy. Mänit yhuucmajch. Cab hänajty ñajuøꞌøy maa jaꞌa vino tøø chooñ. Pero ñajuøøby jaꞌa moonsähajxy hänajty; hix̱, jeꞌe jaꞌa nøø hajxy hänajty tøø jieeꞌppädsøm̱y. Mänitä moonsäwiindsǿṉ jaꞌa jamiøꞌød miøjyaax̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Mänit ñämaayyä: ―Jayøjp jaꞌa hovyino hajxy nax̱y ñäꞌägädä tem̱y. Coo jaꞌa woybä wichpähajxy hänajty com̱ tøø yhuꞌugy, mänit hajxy hänajty jiaac temaꞌañ jaꞌa vino caꞌa jaty hoybä. Pero miic̈h, cahnä hovyino mdem̱yñä. ");
INSERT INTO mirNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Coo Jesús jaꞌa vino yajwaꞌañguiojy jim̱ Caná de Galilea, hijxtahṉd jaduhṉ yajcähxøꞌtsohṉ coo miøjjä coo jiaanc̈hä. Coo Jesús jaꞌa jiamiøødhajxy jaduhṉ yhijxy coo Jesús jaꞌa vino yajwaꞌañguiojy, paadiä Jesús miädiaꞌagy miäbǿjcäxä. ");
INSERT INTO mirNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mänitä Jesúshajxy jiiby yhädaacy maa jaꞌa cajpt jaduhṉ xiøhatiän Capernaum, møødä tiaj, møødä piuhyaꞌayhajxy, møødä jiamiøødhajxy. Coo hajxy jiiby quiädaacy, mejtsxøø tägøøgxøø hajxy jiiby yhijty. ");
INSERT INTO mirNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jadáaṉäp jaꞌa pascuaxøø hänajty jim̱ maa jaꞌa cajpt jaduhṉ xiøhatiän Jerusalén. Jaꞌa judíoshajxy hänajty jim̱ yagjadáaṉäp. Mänit Jesús jim̱ ñøcxy Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Coo jim̱ quiooꞌty, mänit jiiby tiøjtägøøyy maa jaꞌa tsajtøjc hamøjpän maa jaꞌa judíos jaꞌa Dios hajxy hänajty wyiingudsähgøꞌøyän. Jiiby jaꞌa wajtooꞌpähajxy hänajty møødä meegtooꞌpä møødä palomatooꞌpä. Jaanä jiipiä xädøꞌøñguiuwijtspähajxy hänajty yhäñaabiä. ");
INSERT INTO mirNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Coo Jesús jaduhṉ yhijxy, mänitä xaac̈h wyidsøꞌcy. Mänitä juꞌxt yhädiuuṉ̃. Mänitä jäyaꞌayhajxy cøjx yhøxpäboꞌoyii jiiby tsajtøgooty møødä waj møødä meeg cøx̱iä. Mänitä Jesús yajtsitøꞌcy jaꞌa xädøꞌøñguiuwijtspä mieexähajxy. Cøjx jaꞌa xiädøꞌøñhajxy yhøxxity. ");
INSERT INTO mirNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Mänitä palomatooꞌpähajxy ñämaayyä: ―¡Yajpädsøm̱ yøꞌø mbaloma hajxy! ¡Cábøch nDeedy jaꞌa tiøjc hajxy xwiáaṉät halaplaaz! ");
INSERT INTO mirNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mänitä jiamiøødhajxy jiahmiejtstaacy coo jaduhṉ yhity cujaay: “Mjaanc̈h tehm̱ cwieendhadáaṉäbøch hädaa miic̈h mdøjc nägøꞌø nädecypiä, hóyhøch hajxy cu xjia yajcuyaghoꞌogøꞌøw.” ");
INSERT INTO mirNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mänitä judíoshajxy miänaaṉ̃, ñämaayyä Jesús: ―Tii hijxtahṉd højts xyajcähxøꞌøgáaṉäp hoy‑yagjuøøñäjatypä pø mmøød miic̈h cuhdujt jaduhṉ coo yøꞌøyaꞌayhajxy tøø mgøx̱y høxpäboꞌoy. ");
INSERT INTO mirNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mänitä Jesús yhadsooyy: ―Coo hädaa tsajtøjc hajxy myagjídät, pues cudägøøgxǿøyyøch nyaghoyøødiägátsät. ");
INSERT INTO mirNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mänitä judíoshajxy miänaaṉ̃: ―Cujuxychäguiꞌxtädujcjumøjt hädaa tsajtøjc jecy miaayy y tägøøgxøøyyä miic̈h myaghoyøødiägatsaꞌañ. Cab højts jaduhṉ nmäbøcy. ");
INSERT INTO mirNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero jueꞌe Jesús hänajty ñänøøm̱by “jaꞌa tsajtøjc”, jaꞌa yhamdsoo niꞌx jaꞌa yhamdsoo copc. ");
INSERT INTO mirNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Coo Jesús hänajty cujecy tøø jiaanc̈h jujypiøcy, mänitä jiamiøødhajxy jiahmiejtstaacy nebiaty hänajty tøø miänaꞌañän. Mänitä Diosmädiaꞌagy hajxy miäbøjnä møødä Jesús jaꞌa miädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mänaa jaꞌa Jesús jim̱ yhitiän Jerusalén jaꞌa pascuaxøøjooty, mänitä cuꞌugä Jesús hajxy yhijxy coo jaꞌa Jesús jaꞌa hoy‑yagjuøøñäjatypä hänajty yajcähxøꞌøgy. Mänitä Jesús jaꞌa miädiaꞌagy miäbǿjcäxä nämøj nämay. ");
INSERT INTO mirNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero cabä Jesús hänajty yajwiinhøøñ, jeꞌeguiøxpä coo hänajty ñajuøꞌøy hamdsoohaamby coo jaꞌa cuꞌughajxy hänajty hamuumduꞌjoot quiaꞌa mäbøcy. ");
INSERT INTO mirNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hix̱, hamdsoohaambiä Jesús hänajty ñajuøꞌøy coo hajxy haxøøg nwiinmahñdyhájtäm nägøx̱iä. Cabä Jesús hänajty pøṉ miäyajtøy neby hajxy nwiinmahñdyhájtäm. ");
INSERT INTO mirNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Coo maxiøø hänajty tøø yhijnä, mänitä copc‑hajpä jim̱ tuꞌug miejch maa Jesúsän. Nämay hajxy hänajty quiopc‑haty maa judíoshajxiän. Nicodemo jaꞌa copc‑hajpä hänajty xiøhaty. Pianǿcxäp jaꞌa fariseos miädiaꞌagyhajxy hänajty. Tøø hänajty quioodsøꞌøy coo jim̱ miejch maa Jesúsän. Mänit Jesús ñämaayyä: ―Wiindsǿṉ, nnajuøøby højts coo miic̈hä Dios tøø xquiex̱y yajnähixøøbiä. Coo miic̈hä Dios häxøpy xquiaꞌa puhbety, caj miic̈h hoy‑yagjuøøñäjatypä häxøpy myajcähxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mänit Jesús miänaaṉ̃: ―Chaads miic̈h tehm̱ tiøyhajt nnämáꞌawät, coo mgaꞌa miiṉdägats mgaꞌa cahdägátsät, cabä Dios xyhanéꞌemät. ");
INSERT INTO mirNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Mänit Nicodemo yajtøøyy: ―Pero neby jaduhṉ mmiiṉdägats mgahdägátsät coo hänajty tøø mmäjaanä. Neby jiiby mdägøødiägátsät jaꞌa mdaj jioodooty coo jiiby jadähooc mmaaxhuunghádät. ");
INSERT INTO mirNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mänit Jesús yhadsooyy: ―Pues caj. Chaads miic̈h tehm̱ tiøyhajt nnämáꞌawät, coo mgaꞌa miiṉdägats mgaꞌa cahdägátsät nøøhaam møødä Dios yhEspírituhaam, cabä Dios xyhanéꞌemät. ");
INSERT INTO mirNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Coo tøø mmiṉ̃ tøø mgaꞌay nebiä maaxhuungän, Dios jeꞌe xmiooyy jaꞌa mniꞌx jaꞌa mgopc møødä mjuøhñdy. Y jaduhṉ mäwíinäts jeꞌe, coo Dioshespíritu mbaduꞌubǿgät, nebiä miiṉdägach cahdägachpän mmähmǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Caꞌa myagjuøꞌøy cooc̈h jaduhṉ nnämaꞌay coo tsipcøxp mmiiṉdägats mgahdägátsät. ");
INSERT INTO mirNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Coo poj jaduhṉ xiämem̱y, cab hajxy nnajuǿøyyäm maa myinøꞌøy maa ñøcxøꞌøy. Homiaajä poj xiämem̱y. Mmädów̱äp jaduhṉ pero caj mhíxät. Jaduhṉ mäwíinäts jaꞌa Dios yhEspíritu coo xjioottägøꞌøw coo xquioptägǿꞌøwät. Coo jaduhṉ mmäbǿgät hamuumduꞌjoot, jaduhṉ mjádät nebiä miiṉdägach cahdägachpän ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mänitä Nicodemo yajtǿøgumbä: ―Neby jeꞌeduhṉ mnänøm̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Mänit Jesús yhadsooyy: ―Yajnähixøøbiä miic̈h mduuṉghajpy maa jaꞌa judíoshajxiän pero cáhnøch nmädiaꞌagy xwyiinjuǿøyyäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Chaads miic̈h tehm̱ tiøyhajt nnämáꞌawät. Nmädiaacypy højts mädyiijaty højts nnajuøøby y nnägapxyp højts mädyiijaty højts tøø nhix̱y. Pero mijts, cab højts mijts nmädiaꞌagy xñäꞌägädä mäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tøø hajxy nja yajmøødmädiaꞌagy tijaty yaa ja hijp hädaa yaabä naax̱wiin, pero cab hajxy mmäbøcy. Hoora, cooc̈h jaꞌa tsajpootypä hajxy nyajmøødmädiáꞌagät, ni jeꞌe hajxy mgaꞌa wiinjuǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ni pøṉ jim̱ quiaꞌa hoyñä tsajpootyp. Jagóoyyøch jim̱ nidiuhm̱ ndsooñ, høøc̈h jaꞌa Diosquex̱ypä. Páadyhøch jaꞌa tøyhajt nmøødä neby jim̱. ");
INSERT INTO mirNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jaꞌa Moisés, jim̱ä tsahṉ̃dyhahädiuuṉnax̱y yujpahy quepyquiøxp jim̱ pactuum. Jaanä jadúhṉhøch jäyaꞌay xyujpaꞌawaam̱bä, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Pønjátyhøch nmädiaꞌagy xmiäbǿjcäp, cabä yháañämähajxy mänaa quiuhdägoyyaꞌañ. Cøjxtaꞌaxiøø hajxy jiugyhadaꞌañ nebiä Dios jiugyhatiän ―nøm̱ä Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Xjiaanc̈h tehm̱ chojc xjiaanc̈h tehm̱ piaꞌhäyóow̱äm jaꞌa Dios hajxy nägøx̱iä, mäduhṉ̃tiä hajxy yaa nhíjtäm hädaa yaabä naax̱wiin; paadiä tiuꞌughuung ñähdujcy. Coo jaꞌa mädiaꞌagy hajxy hamuumduꞌjoot nmäbǿjcämät jaꞌa Dioshuungcøxpä, cabä nháañämähajxy mänaa quiuhdägóoyyämät. Jaduhṉ hajxy cøjxtaꞌaxiøø njugyhájtämät nebiä Dios jiugyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Paadiä Dios jaꞌa yHuung yaa tøø quiex̱y hädaa yaabä naax̱wiin coo hajxy jaduhṉ ween xñähhoꞌtúutäm. Cab hajxy jaduhṉ xyajcumädow̱áaṉäm. ");
INSERT INTO mirNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pønjatiä Dios yHuung jaꞌa miädiaꞌagy mäbǿjcäxäp, cab hajxy jeꞌe yajcumädow̱aꞌañii. Pønjaty caꞌa mäbøjp, tøø Dios miänaꞌañ cooc hajxy yajcumädow̱aꞌañii, coogä Dios jaꞌa yHuung jaꞌa miädiaꞌagy quiaꞌa mäbǿjcäxä. ");
INSERT INTO mirNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Coo Dios yHuung yaa yhooyy hädaa yaabä naax̱wiin, hagoodstuum jäyaꞌayhajxy hänajty yhity. Paady hajxy hänajty yhity hagoodstuum coo haxøøgwiinmahñdy hajxy hänajty tiuṉ̃. Cabä Dios yHuung miädiaꞌagy hänajty miäbǿjcäxä. Jaduhṉ mäwíinäts jeꞌe nebiä jøønän. Paady jaduhṉ nebiä jøønän, jaduhṉ jäyaꞌayhajxy piädsǿm̱ät hagoodstuum. Pønjaty hagoodstuum mähmøꞌøwaam̱b, jeꞌeds Dios ñänøøm̱by coo hajxy yajcumädow̱aꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pønjaty haxøøgwiinmahñdy tuum̱b, cab hajxy chocy maa jiajjiän. Cähxøꞌøgaam̱b yhaxøøgwiinmahñdyhajxy jeꞌe, paady hajxy quiaꞌa pädsøm̱aꞌañ jajtuum. ");
INSERT INTO mirNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pønjaty panøcxaam̱b jaꞌa tømiädiaꞌagy, jeꞌeds jaduhṉ pädsøm̱aam̱b jajtuum. Paady hajxy jaduhṉ piädsøm̱aꞌañ, jaduhṉ quiähxøꞌøgaꞌañ coo Dios hajxy tøyhajt jiaanc̈h puhbedyii. ");
INSERT INTO mirNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mänitä Jesúshajxy jim̱ ñøcxy Judeanaaxooty møødä jiamiøødhajxy. Coo hajxy jim̱ miejch, mänit hajxy tiägøøyy mäyajnäbejpä. Maxiøø hajxy jim̱ yhijty mäyajnäbejpä. ");
INSERT INTO mirNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jaanä jim̱ä Juanghajxy hänajty miäyajnäbejpä maa jaꞌa cajpt hänajty xiøhatiän Enón. Salim cajpt mäwiingóṉ jaduhṉ. Com̱ä nøø hänajty jim̱. Mejtsp jäyaꞌayhajxy hänajty jim̱ näbejpä. ");
INSERT INTO mirNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Cahnä Juan hänajty chumyii. ");
INSERT INTO mirNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mänitä Juan jaꞌa jiamiøødhajxy tiägøøyy mädiaacpä møødä judíoshajxy nämejtsc nädägøøg. Jeꞌe hajxy hänajty miädiaacypy neby hajxy ñäbétät. ");
INSERT INTO mirNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mänit Juan hoy ñämaꞌayii: ―Wiindsǿṉ, xiiby yøꞌøyaꞌay miäyajnäbety, jaꞌa miic̈h hijty jim̱ xmiøødhijpä jaꞌa Jordángpä møjnøøhawiimb, jaꞌa miic̈h tøø mnägápxiäbä coo Dios tøø quiex̱y. May jäyaꞌay tøø ñämech maa miäyajnäbetiän. ");
INSERT INTO mirNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mänit Juan miänaaṉ̃: ―Coo jaꞌa Dios jaduhṉ tøø miänaꞌañ, paadiä Jesús miädiaꞌagy pianǿcxäxä nämay. ");
INSERT INTO mirNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tøø hajxy mmädoy cooc̈h ngaꞌa Cristo. Jawyíinhøch Dios xquiejxy. Páadyhøch jawyiin xquiejxy cooc̈h mädiaꞌagy nyajwáꞌxät yøꞌø Jesúscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Coo jaꞌa pøc huꞌug maa jiadyii, jaꞌa jamiøꞌød, jeꞌeds jaꞌa jaxieꞌeb møød. Jaꞌa jamiøꞌød jaꞌa miäguꞌughajpä jii hijpä, xooṉdaacp jeꞌeduhṉ coo jamiøꞌød quiapxy. Jaanä xooṉdáacpøch høøc̈hpä jeꞌeguiøxpä coo Jesús miädiaꞌagy pianǿcxäxä nämay. ");
INSERT INTO mirNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tehṉgahnä hajxy miayøꞌøwaꞌañ, jaꞌa Jesús miädiaꞌagy hajxy panǿcxäbä. Pero pønjátyhøchä nmädiaꞌagy xpianǿcxäp, haweenøꞌøwaam̱b hajxy jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Xyhanéhm̱äm hajxy jeꞌe nägøx̱iä, jaayaꞌay jim̱ tsohm̱bä tsajpootyp. Yaayyä hajxy ndsänáayyäm hädaa yaabä naax̱wiin, y hädaa yaabä naax̱wiimbä mädiaꞌagy hajxy nmädiáacäm. Pero jaayaꞌay jim̱ tsohm̱bä tsajpootyp, ");
INSERT INTO mirNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","jeꞌeduhṉ miädiaacypy nebiaty jim̱ tøø yhix̱y tøø miädoyyän tsajpootyp. Pero cabä miädiaꞌagy miäbǿjcäxä nämay. ");
INSERT INTO mirNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pønjatiä Jesús miädiaꞌagy mäbøjcäp, jeꞌeds tøyhajt yejp coo Dios tiømiädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jaayaꞌay Dios tøø quiéx̱iäbä, Diosmädiaꞌagy jeꞌeduhṉ miädiaacypy. Hamuumduꞌjoot Dios jaꞌa Jesús jaꞌa Dioshespíritu miooyy nebiä Jesús jaduhṉ miädiaactägátsät. ");
INSERT INTO mirNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Chojpy jaꞌa Dios jaꞌa yHuung; paadiä cøx̱iä wiinä tøø yajcøꞌødägøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pøṉä Dios yHuung jaꞌa miädiaꞌagy mäbǿjcäp, jeꞌeds cøjxtaꞌaxiøø jugyhadaam̱b nebiä Dios jiugyhatiän. Jaꞌa hajxy caꞌa mäbøjpä, cab hajxy jaduhṉ jiugyhadaꞌañ nebiä Dios jiugyhatiän; yajcumädow̱áaṉäp hajxy jeꞌe jaꞌa Diósäm. ");
INSERT INTO mirNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Coo Jesús miädoyhajty coogä fariseoshajxy hänajty tøø miädoyhaty coogä Jesús jaꞌa jiamiøødhajxy hänajty maas may yajmäbøcy y yajnäbety quejee Juan, mänit Jesúshajxy wyiimbijty Judea. Galilea hajxy ñøcxtägajch. ");
INSERT INTO mirNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jim̱ hajxy ñaxøøyy Samarianaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mänit hajxy jim̱ miejch maa jaꞌa cajpt hänajty xiøhatiän Sicar jim̱ Samarianaaxooty, mäwiingóṉ maa José ñädeedyñaax̱än. Jaꞌa tieedy jaduhṉ jecy xøhajt Jacob. ");
INSERT INTO mirNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Jim̱ä nøøjut mädyii José yajmämähmøøyyä coo Jacob yhoꞌcy. Coo Jesúshajxy jim̱ miejch maa nøøjutän, tøø Jesús hänajty yhanuuꞌxøꞌøy. Mänit Jesús yhøxtaacy nøøjutpaꞌa. Tøø hänajty quiujyxiøøjøꞌøy. Mänitä jiamiøødhajxy ñøcxy cajptooty juuguiaabiä. Mänitä toꞌoxiøjc tuꞌug quiädaacy nøøgoom̱bä; Samaria hänajty chooñ. Mänit Jesús toꞌoxiøjc ñämaayy: ―Høøc̈hä nøø móoyyäc. ");
INSERT INTO mirNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mänit Jesús ñämaayyä: ―Tiic̈h miic̈h nøø coo xmiäyujwaꞌañ. Jueꞌe miic̈h mdsooñ Judea. Høøc̈h, yaac̈h ndsooñ Samaria. (Ix̱, cabä Judéabä jäyaꞌayhajxy hänajty miøødnijiootpaadyii jaꞌa Samáriabä jäyaꞌayhajxy.) ");
INSERT INTO mirNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mänit Jesús yhadsooyy: ―Coo häxøpy mnajuøꞌøy tii mayhajt Dios tiunaam̱by maa miic̈hcøxpän y pøṉc̈h høøc̈h cooc̈h jaꞌa nøø tøø nja yujwaꞌañ, mänítøch cu xmiäyujwaaṉ̃ jaꞌa nøø jaꞌa ni mänaa caꞌa tøøtspä. ");
INSERT INTO mirNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mänitä toꞌoxiøjc yhadsooyy: ―Tsäguhm̱, cøøc hädaa nøøjut. Caj miic̈h tii mmøødä coo jaꞌa nøø myajwohm̱bädsǿm̱ät. Maa tyijy miic̈h jaꞌa nøø mbáadät, jaꞌa ni mänaa caꞌa tøøtspä. ");
INSERT INTO mirNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nejy, maas mǿctäm miic̈h cuhdujt mmøødä quejee Jacob cuhdujt jegyhajty miøødä, jaꞌa hajxy hijty nhaphajt ndeedyhájtäm. Jeꞌe hädaa nøøjut xyajmämähmǿøyyäm. Yaa jecy ñøøhuucy møødä yhuunghajxy møødä yhanimalhajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mänit Jesús yhadsooyy: ―Coo hädaa nøø hajxy yhuꞌugy, najxp tiødsøꞌøhajxy jaduhṉ. Mänit hajxy tiødsøꞌøbáatägumbä cujaboom cumaax̱c. ");
INSERT INTO mirNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Høøc̈h, nyéjpiøch jaꞌa nøø, jaꞌa ni mänaa caꞌa tøøtspä. Coo hajxy yhúꞌugät, ni mänaa jaꞌa tødsøꞌø hajxy quiaꞌa paattägájtsänät. Cøjxtaꞌaxiøø hajxy jaduhṉ jiugyhadaꞌañ nebiä Dios jiugyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Cahnä toꞌoxiøjc jaꞌa mädiaꞌagy hänajty wyiinjuøꞌøyñä nebiä Jesús jaꞌa nøø ñägapxiän. Jueꞌe Jesús jaduhṉ ñänøøm̱ jaꞌa mayhajt jaꞌa Dios jaduhṉ tiunaam̱by maa højtscøxpän. Mänit toꞌoxiøjc miänaaṉ̃: ―Høøc̈hä nøø móoyyäc nébiøch tødsøꞌø xquiaꞌa páatnät. Jadúhṉhøch yaa miṉ ngaꞌa nøøwóhṉnät. ");
INSERT INTO mirNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Mänit Jesús miänaaṉ̃: ―Nøcx jaꞌa mnihyhap møjyaꞌax; mänit yaa mwoomínät. ");
INSERT INTO mirNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mänit toꞌoxiøjc yhadsooyy: ―Cábøch nnihyhap. Mänit Jesús miänaaṉ̃: ―Tehm̱ tiøyhajt miic̈h jaduhṉ mmänaꞌañ coo nihyhap mgaꞌa møødä. ");
INSERT INTO mirNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mägoox̱cä mnihyhap tøø mmøødtsänaꞌay, y yøꞌø yaꞌadiøjc xim̱ mmøødpä, tøyhajt, caꞌa myiic̈hä mhamdsoo nihyhap yøꞌø. ");
INSERT INTO mirNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mänit toꞌoxiøjc miänaaṉ̃: ―Tsäguhm̱, nyoꞌmädóobiøch jaduhṉ coo miic̈h jaꞌa Dioshespíritu mmøødä. ");
INSERT INTO mirNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Jim̱ højts nhap ndeedy jaꞌa Dios hajxy hijty jecy wyiingudsähgøꞌøy maa yøꞌø tuṉän. Pero mijts mänaam̱b coo hajxy jim̱ nwiingudsähgǿøyyämät jim̱ Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mänit Jesús yhadsooyy: ―Muuxy, mäbǿjcägøch nmädiaꞌagy. Habaadáaṉnäp jeꞌejän coo mijts jaꞌa Diosteedy homiaajä mwiingudsähgøꞌøwaaṉnä. Caꞌa ñäꞌä jiiyyä hajtiä mwiingudsähgøꞌøwaꞌañ maa yøꞌø tuṉän ni jim̱ Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hoy Dios hajxy mja wiingudsähgøꞌøy, cab hajxy mhix̱iä. Højts, nhix̱y højts jaꞌa Dios. Jaduhṉ jaꞌa Diosmädiaꞌagy miänaꞌañ coo jaꞌa judíos jäyaꞌay tuꞌug yajnähwaꞌads yajcuhwaꞌadsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pøṉ jaꞌa Dios tehm̱ tiøyhajt wiingudsähgǿøñäp, jeꞌeds hamuumduꞌjoot wiingudsähgøøby. Jadúhṉäts jaꞌa Dios chocy coo wyiingudsähgøꞌøwøød hamuumduꞌjoot. ");
INSERT INTO mirNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Jaduhṉä Dios nebiä poj nebiä täxaꞌajän. Tsipcøxp hit jaꞌa Dios hajxy nwiingudsähgǿøyyämät. ");
INSERT INTO mirNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mänit toꞌoxiøjc miänaaṉ̃: ―Jaꞌa Cristo, jaꞌa Dios quiexaam̱biä, jeꞌe højts nhahíjxäm. Coo jeꞌe quiädaꞌagaꞌañ, mänit højts jeꞌe cøx̱iä xyhawaaṉáaṉäm. ");
INSERT INTO mirNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mänit Jesús miänaaṉ̃: ―Hǿøc̈häts jeꞌe jaꞌa Cristo. ");
INSERT INTO mirNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mänit Jesús jiamiøødhajxy miejch. Coo hajxy yhijxy coo Jesús jaꞌa toꞌoxiøjc hänajty miøødmädiaꞌagy, yagjuøøyy hajxy jaduhṉ. Pero cab hajxy yajtøøyy tiiguiøxpä Jesús jaꞌa toꞌoxiøjc hänajty coo miøødmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mänitä toꞌoxiøjc jiiby chohṉ̃ maa hajxy hänajty miädiaꞌaguiän. Jiibiä miajt ñähgueecy, ñøcxy jeꞌe cajptooty, hoy jaꞌa cuꞌughajxy ñämaꞌayii: ");
INSERT INTO mirNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Jam̱ jäyaꞌay hajxy tuꞌug huug híjxäm. Tøøc̈h jeꞌe xñajuøꞌøy nebiátyhøch haxøøgpä tøø nduṉ̃. Jadúhṉhøch jeꞌe tøø xyhawaaṉä. Jeꞌe ndijjiädaꞌa jeꞌe jaꞌa Cristo. ");
INSERT INTO mirNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mänitä cuꞌughajxy tiuꞌubøjcy cajptooty, ñänøcxy jaꞌa Jesús hajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Jim̱ä Jesús hänajty ñämaꞌayii jaꞌa jiamiøødhajxy: ―Wiindsǿṉ, cay. ");
INSERT INTO mirNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mänit Jesús yhadsooyy: ―Xiic̈h jøøꞌxypøcy nmøødä. Cab hajxy mnajuøꞌøy tii jeꞌeduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mänitä jiamiøødhajxy ñiñämaayyä: ―Nejy, tøø jiøøꞌxypøquiädaꞌa yajméjtsäxä. ");
INSERT INTO mirNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mänit Jesús miänaaṉ̃: ―Cooc̈h jaduhṉ nmänaaṉ̃ cooc̈h jøøꞌxypøcy nmøødä, jeꞌec̈h hänajty jaduhṉ nnänøøm̱by cooc̈h njootcujcä, cooc̈h ngudiúnät nébiøch Dios tøø xyhaneꞌemiän, cooc̈h tiuuṉg nyajmáayyät; jeꞌec̈h jaduhṉ tøø xquiex̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Huug hix̱ yøꞌøyaꞌay hajxy xii mänajpä. Xmiäbøgáaṉäbøch nmädiaꞌagy hajxy yøꞌø. Jaduhṉ mäwíinäts høøc̈hä nmädiaꞌagy nebiä tøømd paquiä miayøꞌøyän. Tehm̱ quiähxøꞌp jaduhṉ. Cab hajxy jaduhṉ mdehm̱ miänáꞌanät nebiä niippädøjc‑hajxy miänaꞌañän cooc mädaax̱poꞌo yhabety, mänítäc hajxy jeꞌe yajpädøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pǿṉhøch jäyaꞌay jaꞌa nmädiaꞌagy xyajmäbøgáaṉäp, xooṉdaꞌagaam̱b hajxy jeꞌe coo hajxy jeꞌe may miäbøgaꞌañ. Quipxy hajxy miøødxooṉdaꞌagaꞌañ jaꞌa Diosmädiaꞌagy hajxy jayøbajt yaghawaꞌxøøc̈hóhṉäbä. Jaꞌa hajxy yajmäbøgáaṉäbä, jeꞌedshajxy cøjxtaꞌaxiøø jugyhadaam̱b nebiä Dios jiugyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tøyhajt jeꞌeduhṉ nebiä jäyaꞌayhajxy miänaꞌañän: “Wiingpä jeꞌe niip, y wiingpä jeꞌe yajpädøꞌp.” ");
INSERT INTO mirNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tøøc̈h mijts nwiinguex̱y coo mijts jäyaꞌay jaꞌa Diosmädiaꞌagy hajxy myajmäbǿgät, jaꞌa hajxy hijty tøø miädoyhátiäbä. Wiingpä hajxy jayøbajt yajmädoyhajt; mijts høx̱haam myajmäbøgaam̱by ―nøm̱ Jesús miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jaꞌa Sicarpä jäyaꞌayhajxy, nämay hajxy jeꞌeduhṉ miäbøjcä jaꞌa Jesús miädiaꞌagy. Paady hajxy jeꞌeduhṉ miäbøjcy coo jaꞌa toꞌoxiøjc hänajty jaduhṉ tøø ñägapxy cooc yhaxøøgwiinmahñdy cøjx ñajuǿøyyäxä, møød cooc cøjx yhawaaṉdǿøw̱äxä. Jim̱ä Sicarpä jäyaꞌayhajxy hänajty xiøønax̱y Samarianaaxooty. ");
INSERT INTO mirNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mänit Jesús hoy miänuuꞌxtaꞌagyii coo jim̱ miähmǿꞌøwät maa quiajpthajxiän. Mänit jiaanc̈h mähmøøyy. Mejtsxøø jeꞌeduhṉ jim̱ yhijty. ");
INSERT INTO mirNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Coo Jesús jiaac yajmøødmädiaacy jaꞌa jäyaꞌayhajxy, nämay jaꞌa miädiaꞌagy jiaac mäbǿjcäxä. ");
INSERT INTO mirNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mänitä toꞌoxiøjc hajxy ñämaayy: ―Høxtahm̱ds miic̈h jim̱ hoy mnägapxiän cajptooty, cab højts tuꞌjoot nmäbøjcy. Pero coo højts jiiby ngädaacy, mänit højts jeꞌe xtiehm̱ yhamdsoo møødmädiaacy. Mänit højts nmäbøjcy. Mänit højts nnajuøøyy coo yøꞌøyáꞌadiäm Cristohaty. Yøꞌøds hajxy xyajnähwaꞌads xyajcuhwaꞌadsáaṉäm nägøx̱iä mäduhṉ̃tiä hajxy yaa ndsänáayyäm hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nägooyyä mejtsxøø yhabejty, mänit Jesúshajxy tiuꞌubøjnä, ñøcxnä hajxy jim̱ Galilea. ");
INSERT INTO mirNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Hamdsoo Jesús jeꞌeduhṉ miänaaṉ̃ cooc hajxy quiaꞌa wiingudsähgøꞌøyii maa yhamdsoo cajptän, jaꞌa Diosmädiaꞌagy hajxy yaghawaꞌxøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero coo Jesús jim̱ miejch Galilea maa yhamdsoo cajptän, mänit yajpooꞌxä haxiꞌig haxóṉ. Paadiä Jesús yajpooꞌxä, coo jäyaꞌayhajxy hänajty tøø yhix̱y hoy‑yagjuøøñäjatypä, nebiaty Jesús jim̱ tøø tiuṉ̃ tøø yajcähxøꞌøgy Jerusalén jaꞌa pascuaxøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mänit Jesús jim̱ jadähooc miéjtscumbä Caná de Galilea maa jaꞌa nøø hänajty tøø yajwaꞌañguiojjiän vino. Jim̱ä gobiernä mioonsä hänajty tuꞌug tøø miech. Tuꞌugä yhuung hänajty tøø piaꞌambety jim̱ Capernaum. ");
INSERT INTO mirNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Coo jaꞌa gobiernä mioonsä miädoyhajty coo Jesús hänajty tøø miech jim̱ Galilea, mänit Jesús hoy miänuuꞌxtaꞌagyii coo yhuung nøcxy yajmøcpǿjcäxä. Møjtaꞌagy yhuung hänajty. ");
INSERT INTO mirNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Mänitä gobiernä mioonsä ñämaayyä: ―Mijts, cahnä hajxy mmäbøcyñä, hoy hajxy tøø mja mädoyhaty cooc̈h hoy‑yagjuøøñäjatypä tøø nduṉ̃. Mänit hajxy mmäbøgaꞌañ coo hajxy mhuuc tehm̱ yhixaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mänitä gobiernä mioonsä miänaaṉ̃: ―Tsógäm, jam̱ hadøꞌøc̈hä; chám̱høch nhuung yhoꞌogaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mänit Jesús miänaaṉ̃: ―Wiimbit jootcujc. Cabä mhuung yhoꞌogaꞌañ. Mänit Jesús miädiaꞌagy jiaanc̈h mäbǿjcäxä. Mänit gobiernä mioonsä jiaanc̈h wiimbijty. ");
INSERT INTO mirNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tuꞌhaamhädaacpä jaꞌa mioonsähajxy jiøjcubaadøøyyä. Mänit yhawáaṉäxä cooc yhuung hänajty tøø jiaanc̈h møcpøcy. ");
INSERT INTO mirNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mänit yajtøøyy mädunajtä hänajty tøø miøcpøcy. Mänit ñämaayyä: ―Häxøøy jaꞌa tioy tiøjch cujyxiøøhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mänit jaꞌa gobiernä mioonsä jiaanc̈h jahmiejch coo Jesús hänajty häxøøyhajty cujyxiøøhoꞌogy tøø miänaꞌañ cooc yhuung miøcpøgaꞌañ. Mänit Jesús jaꞌa miädiaꞌagy cøjx miäbǿjcäxä mäduhṉ̃tiä hajxy tiuꞌugtøjcä. ");
INSERT INTO mirNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Miämetsc‑hoocpä Jesús jeꞌeduhṉ yajcähxøꞌcy jaꞌa hoy‑yagjuøøñäjatypä jim̱ Galilea. Mänit jeꞌeduhṉ yajcähxøꞌcy coo hänajty tøø yhoy Judea. ");
INSERT INTO mirNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mänit Jesús ñǿcxcumbä jim̱ Jerusalén xøøhajpä. Jaꞌa judíos xiøøhajxy hänajty jadáaṉäp. ");
INSERT INTO mirNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jim̱ä tsiidaact jaduhṉ tuꞌug xiøhaty Betzata, jaꞌa hebreohayuuc‑haamby. Jim̱ä tsiidaact mädøyyä maa jaꞌa meegtooꞌtaactän. Mägoox̱c‑hit jaꞌa tøjwiing wäditiä jim̱ maa jaꞌa tsiidaactän. ");
INSERT INTO mirNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mayyä paꞌamjäyaꞌay hänajty jim̱ quioꞌnaꞌay møødä wiindspä møødä tecymiaꞌadpä møødä tecymiucypiä. Jim̱ hajxy hänajty yhahix̱y coo jaꞌa nøø jaduhṉ jiädseṉyóꞌoyät. ");
INSERT INTO mirNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Wiingumänaa jaꞌa Dios mioonsä tsajpootypä hänajty tuꞌug quiädaꞌagy nøøyagjädseṉyohbiä maa jaꞌa tsiidaactän. Pero cab hänajty quiähxøꞌøgy. Nägooyyä jaꞌa nøø hajxy hänajty jaduhṉ yhix̱y tiägøꞌøy jädseṉyohbiä, mänitä paꞌamjäyaꞌayhajxy tiägøꞌøy nøøjooty. Jaꞌa hänajty jayøbajt tehm̱ tiägøøc̈hohm̱bä, jeꞌeds hänajty jaduhṉ møcpøjp nidiuhm̱. Hoy tyii paꞌamä hänajty jia møødä, yajnajxyp jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jim̱ jäyaꞌay hänajty tuꞌug piaꞌamgoꞌnaꞌay. Miähiiꞌxmajmocxtägøøgjumøjtpä hänajty jim̱ tøø yhity. ");
INSERT INTO mirNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Coo Jesús jaꞌa paꞌamjäyaꞌay jaduhṉ yhijxy, mänit Jesús yajtøøyy: ―Nejy, mmøcpøgaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mänitä paꞌamjäyaꞌay yhadsooyy: ―Cábøch nbøṉ pǿṉhøch xpiädáꞌagäp nøøjooty coo jaꞌa nøø tiägøꞌøy jädseṉyohbiä. Cooc̈h hänajty jiiby nja tägøꞌøwaꞌañ, tøø wiingpä hänajty tiägøøñä. ");
INSERT INTO mirNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mänit Jesús miänaaṉ̃: ―Pädøꞌøg, yajpädøꞌøg mdoꞌogy, yohñä. ");
INSERT INTO mirNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mänitiä paꞌamjäyaꞌay jaduhṉ jiaanc̈h møcpøjcy. Mänitä miaabejt jiaanc̈h yajpadøꞌcy yoꞌoyøꞌcy. Pooꞌxxiøøjooty hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mänitä judíoshajxy miänaaṉ̃, ñämaayyä jaꞌa craa jaꞌa hänajty tøø yajmøcpøgyíijäbä: ―Pooꞌxxiøø jädaꞌa. Cabä cuhdujt jaduhṉ myiṉ̃ coo yøꞌø mdoꞌogy jädaꞌa mgapwädítät. ");
INSERT INTO mirNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mänit jäyaꞌay yhadsooyy jaꞌa hänajty tøø miøcpǿquiäbä: ―Jaayáꞌayhøch tøø xyajmøcpǿquiäbä, jeꞌec̈h jaduhṉ xñämaayy cooc̈h ndoꞌogy nyajpädǿꞌøgät. ");
INSERT INTO mirNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mänit miäyajtøøw̱a: ―Pøṉ jaduhṉ tøø xñämaꞌay coo mdoꞌogy myajpädǿꞌøgät, coo myoꞌoyǿꞌøgät. ");
INSERT INTO mirNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Cabä mähdiøjc ñäꞌä hadsooyy. Hix̱, jaanc̈h tehm̱ ñämay jäyaꞌayhajxy hänajty jim̱. Tøø Jesús hänajty yhijxtägóoyyänä. Paadiä mähdiøjc hänajty quiaꞌa najuøꞌøy waam̱b yhadsówät. ");
INSERT INTO mirNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mänit cueeṉ̃tiä, mänit Jesús yhíjxcumbä maa jaꞌa tsajtøjc hamøjpän. Mänit Jesús miänaaṉ̃: ―Huuc mädow̱, chaa miic̈h nnämáꞌawät, tøø miic̈h mmøcpøcy. Caꞌa tii pojpä cädieey mduṉ̃ coo maas haxøøg mjádät. ");
INSERT INTO mirNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mänitä mähdiøjc hoy ñägapxy maa jaꞌa judíoshajxiän cóodäm Jesús jeꞌe, jaꞌa hänajty tøø miäyajmøcpǿquiäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Coo Jesús jaꞌa hoy‑yagjuøøñäjatypä yajcähxøꞌcy jaꞌa pooꞌxxiøøjooty, paadiä judíos Jesús hajxy miädsiphajty; paady hajxy wyiinmaayy nebiä Jesús hajxy yaghóꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mänit Jesús miänaaṉ̃, ñämaayyä jaꞌa judíoshajxy: ―Cábøch nDeedy mänaa tiuum̱bädøꞌøy. Jädaꞌanäbaadyñä tiuṉ̃. Páadyhøch jaduhṉ nbaduum̱bä, hoy jaduhṉ jia pooꞌxxiøøjootiä. ");
INSERT INTO mirNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Paady hajxy jia wiinmaayy nebiä Jesús hajxy yaghóꞌogät, coo Jesús jaꞌa hoy‑yagjuøøñäjatypä yajcähxøꞌcy jaꞌa pooꞌxxiøøjooty, møød coo jaduhṉ miänaaṉ̃ cooc Dios Tieedyhaty, møød coo yajnimiäbaatä nebiä Diosän. ");
INSERT INTO mirNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mänit Jesús miänaaṉ̃, ñämaayyä jaꞌa judíoshajxy: ―Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, cábøch nhamdsoo tuuṉg nduṉ̃; jadúhṉhøch nduṉ̃ nébiøch nDeedy jim̱ tiuṉ̃än. Nebiátyhøch nDeedy tiuṉ̃, jadúhṉhøch nduum̱bä. ");
INSERT INTO mirNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Xchójpøch nDeedy. Xyajnähixǿøbiøch nebiaty jeꞌe tiuṉ̃. Maas hoy‑yagjuøøñátyhøch nDeedy xyajnähixøꞌøwaꞌañ neby hajxy myagjuǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yagjujypiǿjpiøch nDeedy jaꞌa hoꞌogyjiäyaꞌay. Jaanä jadúhṉhøch nyagjujypiøgaam̱bä, pønjátyhøch nyajnähdíjäp. ");
INSERT INTO mirNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","NDéedyhøch, cab jeꞌe pøṉ yajcumädow̱aꞌañ. Høøc̈h jeꞌe tøø xquiuhdujtmoꞌoy cooc̈h jäyaꞌay nyajcumädów̱ät, jaꞌa hajxy caꞌa mädiaꞌagymiäbøjpä. ");
INSERT INTO mirNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Páadyhøch jaduhṉ tøø xquiuhdujtmoꞌoy cooc̈hä jäyaꞌayhajxy ween xwyiingudsähgøꞌøy nébiøch nDeedy wyiingudsähgøꞌøyiijän. Pønjátyhøch hajxy xquiaꞌa wiingudsähgøøby, ni nDéedyhøch hajxy xquiaꞌa wiingudsähgǿøyyäbä, jaꞌac̈h tøø xquiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, pønjaty højts nmädiaꞌagy hajxy xmiäbøgáaṉäp mǿødhøch nDeedy, tøø jaꞌa haxøøgpä hajxy quiøx̱y najtshixøøñä. Jeꞌeds hajxy cøjxtaꞌaxiøø jugyhadaam̱b nebiä Dios jiugyhatiän. Cab hajxy jeꞌe mänaa quiumädow̱aꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Jaꞌa hajxy caꞌa mäbøjpä, tøø yhabaady cooc̈hä nmädiaꞌagy hajxy xmiäbøgaaṉä. Cooc̈hä nmädiaꞌagy hajxy jaduhṉ xmiäbǿjcät, jaduhṉ hajxy jiugyhadaꞌañ cøjxtaꞌaxiøø nebiä Dios jiugyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Miǿødhøch nDeedy cuhdujt coo jäyaꞌayhajxy ñämáꞌawät coo hajxy jaduhṉ jiugyhádat tsajpootyp cøjxtaꞌaxiøø. Jeꞌec̈h cuhdujt tøø xmioꞌoy cooc̈hä jäyaꞌayhajxy jaduhṉ nnämáꞌawät coo hajxy jim̱ yhídät cøjxtaꞌaxiøø. ");
INSERT INTO mirNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Cooc̈h jeꞌeduhṉ tøø xwyiinguex̱y, páadyhøch jaduhṉ tøø xquiuhdujtmoꞌoy cooc̈h nyajnähdíjät nebiaty jäyaꞌayhajxy jiádät. ");
INSERT INTO mirNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Caꞌa hajxy myagjuøꞌøy. Habaadaam̱b jeꞌe cooc̈hä hoꞌogyjiäyaꞌayhajxy nyaax̱pädsøm̱aꞌañ. Mänítøch nmädiaꞌagy hajxy xmiädow̱aaṉä. ");
INSERT INTO mirNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mänit hajxy nägøx̱iä quiøx̱y jutpädsøm̱aꞌañ mäduhṉ̃tiä hajxy hänajty tøø yhoꞌogy. Jaꞌac̈h nmädiaꞌagy hajxy hänajty tøø xmiäbǿjcäbä, jeꞌeds hajxy nøcxaam̱b tsajpootyp. Jaꞌac̈h nmädiaꞌagy hajxy hänajty tøø xquiaꞌa mäbǿjcäbä, jeꞌeds hajxy caꞌawaam̱b haxøøgtuum. ");
INSERT INTO mirNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Nyajtødiägǿøbiøch nébiøch nDeedy xñämaꞌayän. Caꞌa yhøøc̈hä nhamdsoo wiinmahñdy nyaghijpy. Ngudiúum̱biøch jaduhṉ nébiøch nDeedy xmiägapxy xyhaneꞌemiän. Cooc̈h jaduhṉ ngudiuṉ̃, páadyhøch jaꞌa tøyhajt nyecy cooc̈h nyajtødiägøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Cooc̈h häxøpy hamdsoo nniñägapxyii, mänit hajxy cu mmänaaṉ̃ cooc̈hä tøyhajt ngaꞌa mädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Jiic̈hä wiingpä xñägapxy; nnajuǿøbiøch coo jaꞌa tøyhajt jeꞌeduhṉ yecy. Dióshøch jeꞌe xñägapxp. ");
INSERT INTO mirNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tøøc̈h mijts hoy xyajtøy maa Juangän pø Dióshøch tøø xjiaanc̈h quex̱y. Mänitä Juan jaꞌa tøyhajt hajxy xmiooyy. ");
INSERT INTO mirNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero høøc̈h, caꞌa jiäyáꞌayhøch tøø xyhawaaṉä cooc̈h Dios tøø xquiex̱y. Nyagjahmiéjchpøch mijts nebiä Juan hajxy tøø xyhawaaṉän cooc̈h Dios tøø xquiex̱y, neby hajxy jaduhṉ mnähwaꞌads mguhwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yajwaꞌxyp jaꞌa Juan jaꞌa Diosmädiaꞌagy hijty. Xyajnähixøøby hajxy hijty neby hajxy mnähwaꞌads mguhwáꞌadsät. Hoy jaꞌa miädiaꞌagy hajxy hijty mmädóow̱ä. Pero cabä miädiaꞌagy hajxy hijty mmäbøgaaṉä. ");
INSERT INTO mirNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ndúum̱biøch nébiøch nDeedy tøø xyhaneꞌemiän. Cooc̈h jaduhṉ nduṉ̃, cähxøꞌp jaduhṉ cooc̈h nDeedy tøyhajt tøø xquiex̱y. Cooc̈h hajxy jaduhṉ xyhix̱y nébiøch nduṉ̃än, páquiøch nmädiaꞌagy hajxy xmiäbǿjcät, hoy jaꞌa Juan jaꞌa miädiaꞌagy hajxy tøø mgaꞌa ja mäbøjcä jaꞌa høøc̈hcøxpä cooc̈h xñägapxy. ");
INSERT INTO mirNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Jaꞌa nDéedyhøch, jaꞌac̈h tøø xquiéx̱iäbä, høøc̈hcøxpä jiiby tøø xyajcujaayii maa Diosmädiaꞌaguiän. Pero cab hajxy mnajuøꞌøy cooc̈h nDeedy jaꞌa miädiaꞌagy jaduhṉ nmädiaacä. Cab hajxy mnajuøꞌøy cooc̈h jaduhṉ nduṉ̃ nébiøch nDeedy tiuṉ̃än. ");
INSERT INTO mirNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pero cábøch mijts nDeedy jaꞌa miädiaꞌagy tøø xmiäbøjcä, jaꞌac̈h tøø xquiéx̱iäbä. Coo hajxy häxøpy tøø mmäbøcy, cu xmiäbǿjcøch mijts jaꞌa nmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Myajmädiaac‑hoꞌpy jaꞌa Diosmädiaꞌagy hajxy, jaꞌa jecy mähmǿøyyäbä cujaay. Paady hajxy jaduhṉ myajmädiaac‑hoꞌogy coo tyijy hajxy jaduhṉ mjugyhádat nebiä Dios jiugyhatiän. Chaads mijts hajxy nnämáꞌawät, cooc̈h nmädiaꞌagy hajxy xyajtúuṉät, mänit hajxy jaduhṉ mjugyhádat. Pero hóyhøch Diosmädiaꞌagy xjia nägapxy, ");
INSERT INTO mirNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","cábøch mijts jaꞌa nmädiaꞌagy xmiäbøgaaṉä. Cooc̈h mijts nmädiaꞌagy hamuumduꞌjoot xmiäbǿjcät, mänit hajxy mäbøcy mjugyhádat nebiä Dios jiugyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Cábøch nmøjpädaꞌagy, hóyhøch jäyaꞌayhajxy xquiaꞌa ja wiingudsähgøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nnajuǿøbiøch coo mijts Dios mgaꞌa tsocy. ");
INSERT INTO mirNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","NDéedyhøch tøø xjia hamdsoo quex̱y. Pero cábøch mijts nmädiaꞌagy xmiäbøgaaṉä. Coo wiingpä miédsät, jeꞌeds mijts jaꞌa miädiaꞌagy paquiä mmäbøgáaṉäp. ");
INSERT INTO mirNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Cábøch mijts nmädiaꞌagy hoy xmiäbøgaaṉä. Jia tsojpy jaꞌa mjoothajxy jaduhṉ coo jäyaꞌay hajxy xwyiingudsähgǿꞌøwät. Pero cabä mjoothajxy chocy coo Dios hajxy xchógät. ");
INSERT INTO mirNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Caꞌa yhøøc̈hä mijts jim̱ nnäxøꞌøwøꞌøwaam̱by maa Dios wyiinduumän. Jaꞌa Moisésäts mijts jaduhṉ xñäxøꞌøwøꞌøwaam̱b. Mmänaam̱b hajxy jaduhṉ coo tyijy Diosmädiaꞌagy hajxy mmäbøcy, jaꞌa Moisés jecy quiujáhyyäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Coo mijts cu mjaanc̈h mäbøjcy, cu xmiäbǿjcøch nmädiaꞌagy hajxypä. Høøc̈hcøxpä Moisés jaduhṉ jecy quiujahy. ");
INSERT INTO mirNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero pø cab hajxy mmäbøgaꞌañ nebiä Moisés jecy quiujahyyän, ni høøc̈hä nmädiaꞌagy hajxy xquiaꞌa mäbøgáaṉäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Cumejtspoꞌo cudägøøgpoꞌo Jesús jim̱ ñøcxy mejyhawiimb. Mejtstuꞌu jaꞌa mejy xiøhaty Galilea møød Tiberias. ");
INSERT INTO mirNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nämay Jesús hänajty pianøcxyii jäyaꞌayhajxy. Paady hänajty pianøcxyii coo hoy‑yagjuøøñäjatypä hänajty tøø yajcähxøꞌøgy, møød coo paꞌamjäyaꞌay hänajty tøø yajmøcpøcy. ");
INSERT INTO mirNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mänit Jesúshajxy jim̱ wyiimbejty maa jaꞌa tuṉguhduumän møødä jiamiøødhajxy. Mänit hajxy jim̱ yhøxtaacy tuṉguhduum. ");
INSERT INTO mirNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mäwiingoom̱b jaꞌa pascuaxøø hänajty, jaꞌa judíoshajxy yagjájtäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mänit Jesús wyiinheeꞌppejty coo jäyaꞌay hänajty may pianøcxyii. Mänit Jesús jaꞌa Felipe ñämaayy: ―Maa jaꞌa caayyøøc hajxy nbáatämät coo yøꞌøyaꞌay hajxy nyajcáayyämät nämay. ");
INSERT INTO mirNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Paadiä Jesús jaduhṉ miänaaṉ̃, yhuuc näꞌä mädiaꞌagyhixaam̱by hänajty waam̱bä Felipe hänajty yhadsowaꞌañ. Tøø Jesús hänajty hamdsoo wyiinmay nebiä jäyaꞌayhajxy hänajty yajcayaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Mänitä Felipe yhadsooyy: ―Ni mejtsmägoꞌx denariojuy jaꞌa tsajcaagy quiaꞌa mädøyhádät, hoy hajxy tuꞌliiꞌxyjaty cu nja móoyyäm. ");
INSERT INTO mirNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrés jaꞌa Jesús jaꞌa jiamiøød hänajty tuꞌug xiøhaty, jaꞌa Simón Pedro piuhyaꞌay. Mänitä Andrés jaꞌa Jesús ñämaayy: ");
INSERT INTO mirNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Chaadsä pigänaꞌc jaꞌa cebadatsajcaagy miøødä mägoox̱cä, møødä hacx metscä. Pero cab jaduhṉ miädøyhádät. Hix̱, majiäyaꞌay yøꞌøduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mänit Jesús miänaaṉ̃: ―Nämaꞌaw hajxy ween hajxy yhøxtaꞌagy. Møj jim̱ miøøjiootä. Jim̱ hajxy yhøxtaacy jaꞌa mägoox̱milpä yaꞌadiøjc‑hajxy møødä toꞌoxiøjc‑hajxy hawiing. ");
INSERT INTO mirNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mänit Jesús jaꞌa tsajcaagy quiooṉdsooyy. Mänit Jesús Dios jaduhṉ ñämaayy: “Dioscujúꞌuyäp.” Mänit Jesús jaꞌa jiamiøød jaꞌa tsajcaagy miooyy. Mänitä jiamiøød jaꞌa tsajcaagy hajxy tiägøøyy yajwaꞌxpä maa jäyaꞌayhajxy hänajty yhäñaꞌayän. Møødä hacx hajxy yajmäwaꞌxøøbiä. Jaduhṉ̃tiä jäyaꞌayhajxy miooyyä mäduhṉ̃tiä hajxy hänajty quiayaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Coo hajxy quiaabiädøøyy, mänit Jesús jaꞌa jiamiøød ñämaayy: ―Yajpädøꞌøg tsajcaagyquiaadiuc hajxy møødä hacxtsuꞌtstuc, neby hajxy jaduhṉ ngaꞌa nähguéecämät. ");
INSERT INTO mirNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mänit jaꞌa tsajcaagyquiaadiuc hajxy cøjx yajpädøꞌøgy møødä hacxtsuꞌtstuc. Majmetscach hajxy yaghujch jaꞌa tsajcaagyquiaadiuc. ");
INSERT INTO mirNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Coo jäyaꞌayhajxy yhijxy nebiä Jesús jaꞌa tsajcaagy hänajty tøø yajwaꞌañguiojjiän, mänit hajxy tiägøøyy mänaam̱bä: ―Pues tehm̱ tiøyhajt, yøꞌøds jeꞌe, jaꞌa hajxy hijty nhahíjxämbä coo hajxy hijty xñämedsáaṉäm nebiä Diosmädiaꞌagy miänaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Coo Jesús ñajuøøy coo hänajty nøcxy piädaꞌagaꞌañii gobiernä mädsibøꞌøbä, mänit jim̱ chohṉnä. Mänit jim̱ ñøcxnä nidiuhm̱ tuṉjoot. ");
INSERT INTO mirNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Coo chuujøøyy, mänitä Jesús jiamiøødhajxy yhädaacy mejypiaꞌa. ");
INSERT INTO mirNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mänit hajxy tiägøøyy barcojooty. Mänit hajxy tiuꞌubøjcy. Jim̱ Capernaum hajxy hänajty ñøcxaꞌañ mejyhawiimb. Wiingoods hänajty. Cahnä Jesús jaꞌa jiamiøød hänajty piaadyñä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mänitä poj piädøꞌcy møc. Mänitä mejy chajcujy cøxp. ");
INSERT INTO mirNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mägoox̱kilómetro tädujkilómetro hajxy hänajty tøø ñøcxy, mänitä Jesús hajxy yhijxy coo jaꞌa barco hänajty tøø ñajtspaadøꞌøy. Yohby Jesús hänajty mejywyiing. Mänitä jiamiøødhajxy chähgøøbiøjcy. ");
INSERT INTO mirNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mänit hajxy ñämaayyä: ―Caꞌa hajxy mdsähgøꞌøy; Jesúshøch høøc̈h. ");
INSERT INTO mirNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mänit hajxy jiootcugøøyy. Mänitä Jesús yajtägøøyyä barcojooty. Mänitiä hajxy jim̱ miejtsnä mejypiaꞌa maa hajxy hänajty ñøcxiän. ");
INSERT INTO mirNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Cujaboom, jim̱nä majiäyaꞌayhajxy hänajty mejyhawiimbnä, maa hajxy hänajty tøø yajcayiijän. Ñajuøøby hajxy hänajty coo Jesús hänajty tøø quiaꞌa møødtuꞌubøgyii jaꞌa jiamiøødhajxy quipxy. Hijxä jaꞌa Jesús jiamiøødhajxy coo hajxy tiuꞌubøjcy barcojooty jaꞌa majiäyaꞌayhajxy. Jagoo barco hänajty tuꞌug; jeꞌe hajxy hänajty tøø yajtuꞌubøcy. ");
INSERT INTO mirNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mänitä barco hajxy yajmejch wiingpä, jaꞌa Tiberiastsohm̱bä. Jim̱ hajxy miedsøøyy maa jäyaꞌayhajxy hänajty tøø chajcaagyquiayyän, mänaa Jesús jaꞌa Dioscujúꞌuyäp yequiän. ");
INSERT INTO mirNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Coo jaꞌa majiäyaꞌayhajxy yhijxy coo Jesúshajxy quiaꞌa jiijän, mänit hajxy tiägøøyy barcojooty. Mänit hajxy tiuꞌubøjcy Jesúshøxtaabiä. Jim̱ hajxy ñøcxy mejyhawiimb jim̱ Capernaum. ");
INSERT INTO mirNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Coo hajxy jim̱ miejch mejyhawiimb, mänitä Jesús hajxy jim̱ piaaty. Mänit Jesús hajxy ñämaayy: ―Wiindsǿṉ, mänaa mmejch. ");
INSERT INTO mirNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mänit Jesús miänaaṉ̃: ―Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, páadyhøch mijts hijty xyhøxtaꞌay cooc̈h mijts jeꞌe cuꞌuxiä nyajcaayy. Cábøch mijts jeꞌe xmiäyajtøwaꞌañ tiiguiǿxpøch jaꞌa hoy‑yagjuǿøñäbä coo nyajcähxøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Paady hajxy mduṉ̃, jaduhṉä cay huꞌugy hajxy mbaady. Pero chaads mijts nnämáꞌawät jadunajtä coo hajxy mhøxtáꞌawät neby hajxy mjugyhádat nebiä Dios jiugyhatiän. Høøc̈h mijts cuhdujt nmoꞌowaam̱by coo hajxy jaduhṉ mjugyhádat. Páadyhøch mijts jaduhṉ nmoꞌowaꞌañ, cooc̈hä Dios tøø xquiuhdujtmoꞌoy, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mänit Jesús miäyajtøøw̱a: ―Neby højts ngudiúnät nebiä Dios choquiän. ");
INSERT INTO mirNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Mänit Jesús yhadsooyy: ―Chojpy jaꞌa Dios cooc̈h mijts jaꞌa nmädiaꞌagy xmiäbǿjcät, jaꞌac̈h tøø xquiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mänitä Jesús miäyajtǿøw̱ägumbä: ―Tii hijxtahṉd hoy‑yagjuǿøñäbä myajcähxøꞌøgaam̱by neby højts miic̈h jaꞌa mmädiaꞌagy jaduhṉ nmäbǿjcät coo miic̈h jaꞌa Dios tøø xquiex̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jaꞌa hajxy hijty nhaphájtäm ndeedyhájtäm jaꞌa jecypiä, jim̱ä maná hajxy quiaayy maa hänajty pøṉ quiaꞌa tsänaꞌayän. Moisés jaꞌa maná yajwaꞌañguioj. Jaꞌa maná, nebiä tsajcaaguiän jeꞌe. Jiiby jaduhṉ myiṉ̃ cujaay maa jaꞌa Diosmädiaꞌaguiän: “Yajcaayyä jäyaꞌayhajxy jaꞌa tsajcaagyhajpä jaꞌa tsajpootyptsohm̱bä. Dios jaduhṉ quejx.” ");
INSERT INTO mirNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mänitä Jesús yhadsooyy: ―Chaads mijts tehm̱ tiøyhajt nnämáꞌawät: Caha Mioisésä mijts jaꞌa tsajcaagy xyajnäguejx jaꞌa tsajpootyptsohm̱bä. Dios, jeꞌeds hajxy jeꞌe xyajnäguejx. Jeꞌeds hajxy jeꞌe xquiuhdujtmoꞌowaam̱b coo hajxy jim̱ mdägǿꞌøwät tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jaꞌa Dios tøø quiéx̱iäbä, jim̱ tsajpootyp jeꞌe tøø chooñ. Paady jeꞌe yaa tøø quiädaꞌagy nejy mijts xquiuhdujtmóꞌowät coo hajxy mjugyhádat nebiä Dios jiugyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mänitä Jesús ñämaayyä: ―Højts yøꞌø tsajcaagy móoyyäc cøjxtaꞌaxiøøbä, jaꞌa tsajpootyptsohm̱bä. Paady hajxy jaduhṉ miänaaṉ̃ coo hajxy quiaꞌa wiinjuøøyy coo Jesús jaduhṉ ñiñänøøm̱a hamdsoo coo jeꞌe tøø quiexyii jaꞌa Dios. ");
INSERT INTO mirNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mänitä Jesús miänaaṉ̃: ―Høøc̈h jeꞌe, jaꞌa Dios tøø quiéx̱iäbä. Cuhdujtyéjpøch coo hajxy jim̱ tiägǿꞌøwät tsajpootyp pønjátyhøch jaꞌa nmädiaꞌagy xmiäbǿjcäp. Cøjxtaꞌaxiøø hajxy jim̱ yhídät. ");
INSERT INTO mirNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero mijts, cábøch jaꞌa nmädiaꞌagy hajxy tøø xmiäbøjcä, hoy hajxy tøø mja hix̱y cooc̈hä hoy‑yagjuǿøñäbä tøø nja yajcähxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pønjátyhøch jaꞌa nDeedy jaduhṉ xyajcøꞌøwaaṉøøby, jeꞌec̈hä nmädiaꞌagy xmiäbøgáaṉäp. Nguhbøgáam̱biøch hajxy jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Páadyhøch tøø ndsooñ tsajpootyp cooc̈h ngudiúnät nébiøch nDeedy xyhaneꞌemiän, jaꞌac̈h tøø xquiéx̱iäbä. Cábøch jaꞌa nhamdsoo wiinmahñdy nyaghidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Cábøc̈hä nDeedy miänaꞌañ coo hajxy haxøøgtuum quiáꞌawät, jaꞌac̈h hajxy tøø xyajcøꞌøwaaṉǿꞌøyäbä, coo jaꞌa xøø jumøjt jaduhṉ yhabéjnät. Pero jaduhṉ miänaꞌañ cooc̈h hajxy nyajnǿcxät tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jadúhṉhøch jaꞌa nDeedy miänaꞌañ coo hajxy cøjxtaꞌaxiøø jiugyhádat neby jaayaꞌay jiugyhatiän, pønjaty jaduhṉ najuøøby cooc̈hä Dios xyHuunghaty, pønjátyhøch jaꞌa nmädiaꞌagy xmiäbǿjcäp. Jeꞌec̈h hajxy jim̱ nyajnøcxaam̱by tsajpootyp coo jaꞌa xøø jumøjt yhabéjnät. ");
INSERT INTO mirNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Coo Jesús miädiaacpädøøyy, mänit tiägøøyyä wiingapxpéjtäbä jaꞌa judíoshajxy. Paadiä wyiingapxpejtä coo hänajty tøø miänaꞌañ coo jim̱ chooñ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jaduhṉ hajxy ñiñämaayyä: ―Jesús yøꞌøyaꞌay xiøhaty; José yhuung yøꞌø. Nhix̱yhájtäm jaꞌa tiaj tieedy yøꞌø. Høhṉdaacp yøꞌøduhṉ cooc tyijy jim̱ tøø chooñ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mänitä Jesús jaꞌa judíos yhojy: ―Caꞌa hajxy mgapxtägooñä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Pǿṉhøch jaꞌa nDeedy yajnähdijpy, jeꞌec̈hä nmädiaꞌagy xmiäbøgáaṉäp. Jeꞌec̈h nyajnøcxaam̱by tsajpootyp coo jaꞌa xøø jumøjt yhabéjnät. ");
INSERT INTO mirNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jiiby jaduhṉ myiṉ̃ cujaay maa jaꞌa Diosmädiaꞌaguiän coo Dios jäyaꞌay nägøx̱iä yajnähixøꞌøwaꞌañ. Pønjátyhøch jaꞌa nDeedy jaꞌa miädiaꞌagy tøø xwyiinjuøøyyä tøø xyhabøjcä, jéꞌedshøch jaꞌa nmädiaꞌagy tøø xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Cábøch nDeedy mänaa yhixyii jäyáꞌayäm; høøc̈h nidiuhm̱ tøø nhix̱y. Jím̱høch ndsooñ Dioswiinduum. ");
INSERT INTO mirNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, pǿṉhøch nmädiaꞌagy xmiäbǿjcäp, jeꞌeds jugyhadaam̱b cøjxtaꞌaxiøø nebiä Dios jiugyhatiän. ");
INSERT INTO mirNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Høøc̈h hajxy jaduhṉ jim̱ nyajtägøꞌøwaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jaꞌa nhaphájtäm ndeedyhájtämhajxy, hoꞌc hajxy jeꞌe, hoy jaꞌa maná hajxy jia caayy pactuum. Jaꞌa maná, mäjaayejc jaduhṉ. Pero paquiä jaꞌa miäjaahajxy quiøjxy. ");
INSERT INTO mirNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Høøc̈h, páadyhøch tøø ndsooñ jim̱ tsajpooty nébiøch jäyaꞌayhajxy jim̱ nyajtägǿꞌøwät. Jim̱ hajxy yhidaꞌañ cøjxtaꞌaxiøø pønjátyhøch nmädiaꞌagy xmiäbǿjcäp. Nnähdugáam̱biøch jaꞌa nniꞌx jaꞌa ngopc. Nnähhoꞌtuꞌudáam̱biøch jäyaꞌayhajxy nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mänitä judíoshajxy yajcapxiøøyy jaꞌa Jesús jaꞌa miädiaꞌagy: ―Nejy, xmioꞌowáaṉäm yøꞌøyaꞌay ñiꞌx quiopcädaꞌa coo ndsúꞌtsämädä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mänitä Jesús ñämaayy jaꞌa judíoshajxy: ―Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, høøc̈h jaꞌa Diosquex̱ypä, cooc̈h mijts jaꞌa nniꞌx jaꞌa ngopc xquiaꞌa tsúꞌtsät, cooc̈h mijts jaꞌa nnøꞌty jaꞌa njoot xquiaꞌa húucät, cab hajxy jim̱ mdägǿꞌøwät maa Dioswiinduumän. ");
INSERT INTO mirNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pønjátyhøch jaꞌa nniꞌx jaꞌa ngopc xchúꞌtsäp, pønjátyhøch jaꞌa nnøꞌty jaꞌa njoot xyhúucäp, jeꞌeds jeꞌe hidaam̱b cøjxtaꞌaxiøø jim̱ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tsuꞌtsǿøc‑høch jaꞌa nniꞌx jaꞌa ngopc; huucǿøc‑høch jaꞌa nnøꞌty jaꞌa njoot. ");
INSERT INTO mirNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Pønjátyhøch jaꞌa nniꞌx jaꞌa ngopc xchúꞌtsäp, pønjátyhøch jaꞌa nnøꞌty jaꞌa njoot xyhúucäp, jeꞌec̈h jaduhṉ nnänøøm̱by jaꞌa nmädiáꞌagyhøch hajxy xmiäbǿjcäp. Jeꞌec̈h hajxy nguhdujtmoꞌowaam̱by coo hajxy yhídät cøjxtaꞌaxiøø jim̱ tsajpootyp. Tuꞌugmädiáꞌagyhøch hajxy nmøødhidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","58","Jaꞌa nDéedyhøch, jaꞌac̈h tøø xquiéx̱iäbä, jeꞌec̈h jaduhṉ tøø xquiuhdujtmoꞌoy cooc̈h jäyaꞌayhajxy jim̱ nyajnǿcxät tsajpootyp, pønjátyhøch jaꞌa nmädiaꞌagy xmiäbǿjcäp. Jim̱ hajxy yhidaꞌañ cøjxtaꞌaxiøø. Jaꞌa nhaphájtäm jaꞌa ndeedyhájtäm, hoꞌc hajxy jeꞌe jequiän, hoy jaꞌa maná hajxy jia caayy. Pero pønjátyhøch jaꞌa nmädiaꞌagy xmiäbǿjcäp, cab hajxy quiaꞌawaꞌañ haxøøgtuum mänaa. ");
INSERT INTO mirNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jaduhṉ Jesús jim̱ miädiaacy Capernaum coo hänajty yajnähixøꞌøy tsajtøgooty maa jaꞌa judíos jaꞌa Dios hajxy hänajty wyiingudsähgøꞌøyän. ");
INSERT INTO mirNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Coo Jesús jaꞌa jiamiøødhajxy jaduhṉ jim̱ miädooyy, mänit hajxy näjeꞌe miänaaṉ̃: ―Cab hajxy jaduhṉ nguhbǿjcämät; tsip xex̱ yøꞌø mädiaꞌagy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ñajuøøyy Jesús jaduhṉ nebiaty hajxy hänajty miädiaꞌaguiän. Mänit hajxy ñämaayyä: ―Nejy, cábøc̈hä nmädiaꞌagy hajxy xjiøjpøgøꞌøwáaṉäjä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Cooc̈h mijts xyhíxät cooc̈h hänajty jim̱ nnøcxy tsajpootyp, mänítøch mijts jaꞌa nmädiaꞌagy xmiäbøgaaṉä cooc̈h jim̱ ndsooñ tsajpootyp, høøc̈h jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jaꞌa mjuøhñdyhajxy, jeꞌeds hajxy yaa xyagjugyhajp. Jaꞌa mniꞌx jaꞌa mgopc‑hajxy, cab hajxy jeꞌe yaa xyagjugyhaty. Cooc̈h mijts jaꞌa nmädiaꞌagy xmiäbǿjcät, mänit hajxy mdägǿꞌøwät jim̱ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero cahnä hajxy nägøx̱iä mmäbøcyñä. Paadiä Jesús jaduhṉ miänaaṉ̃, ñajuøøby hänajty jaduhṉ pønjaty hänajty jeꞌe caꞌa mädiaꞌagymiäbøgaam̱b. Ñajuøøby hänajty jeꞌebä pøṉ hänajty yegáaṉäp hoꞌcǿøc. Jäguem̱iä Jesús jaduhṉ ñajuøøyy mänaa jaꞌa miäguꞌughajpähajxy tiägøꞌøyän yajnähixøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mänit Jesús miänáaṉgumbä: ―Páadyhøch mijts jaduhṉ nnämaayy: “Pǿṉhøch jaꞌa nDeedy yajnähdijpy, jeꞌec̈hä nmädiaꞌagy xmiäbøgáaṉäp.” ");
INSERT INTO mirNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Coo Jesús jaduhṉ miädiaacpädøøyy, mänitä jiamiøødhajxy nämay wyiimbijnä. Cabä Jesús hajxy hänajty miøødwäditaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mänitä Jesús jaꞌa jiamiøød miäyajtøøyy jaꞌa nämajmetspähajxy: ―Nejy, xpiuhwaꞌadsáam̱bøch mijtspä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mänitä Simón Pedro yhadsooyy: ―Wiindsǿṉ, caj. Tii højts miic̈h coo nnäꞌä puhwáꞌadsät. Miic̈h højts jeꞌe xyajnähixøøby neby højts jim̱ ndägǿꞌøwät tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nmäbǿjcäp højts miic̈hä mmädiaꞌagy. Nnajuøøby højts coo jim̱ tøø mdsooñ maa Diosän, coo mGristähaty, jaꞌa højts hijty nhahijxypä, jaꞌa Dios hijty quiexaam̱biä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mänitä Jesús yhadsooyy: ―Páadyhøch mijts tøø nwiimbiy nébiøch hajxy jaduhṉ xmiøødwädítät, mijts jaꞌa nämajmetspä. Pero xii hajxy tuꞌjäyaꞌay mmøødä, jaꞌa møjcuꞌuwiinmahñdymøødpä. ");
INSERT INTO mirNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jaꞌa Judas jaduhṉ nänøøm̱a, jaꞌa Simón Iscariote yhuung. Jaꞌa Judas, jeꞌedsä Jesús hänajty yegaam̱b hoꞌcøøc, hoy jaꞌa Judas jaꞌa Jesús hänajty jia møødwädity møødä nämajtuꞌugpähajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mänitä Jesús tiägøøyy cajpthayohbiä jim̱ Galilea. Cab hänajty jim̱ wiäditaaṉnä jim̱ Judea, jeꞌeguiøxpä coo jaꞌa judíoshajxy hänajty yhøxtaꞌay nebiä Jesús hajxy yaghóꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jadáaṉäp jaꞌa judíos xiøøhajxy hänajty coo jaꞌa ramada hajxy yhädiuṉ̃. Jim̱ hänajty jiadaꞌañii Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mänitä Jesús ñämaayyä yhuchhajxy: ―Caꞌa yaa mmähmøꞌøy. Nøcx jim̱ Judea. Ween jaꞌa mmäguꞌughajpähajxy jim̱bä yhuug hijxpä nejy miic̈h jaꞌa hoy‑yagjuøøñäjatypä myajcähxøꞌøguiän. ");
INSERT INTO mirNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Myajcähxøꞌpy miic̈h hijty maa jäyaꞌay quiaꞌa mayyän. Pero pø chojpy jaꞌa mjoot jaduhṉ coo jaꞌa mmädiaꞌagy wiädítät jaꞌa miic̈hcøxpä, mänit hijxwiinduum myajcähxǿꞌøgät majiäyaꞌayhagujc. ");
INSERT INTO mirNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Cabä Jesús jaꞌa miädiaꞌagy hänajty miäbǿjcäxä ni jaꞌa yhamdsoo huchhajxy. Paady hajxy jaduhṉ miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mänitä Jesús miänaaṉ̃: ―Cahnä yhabaadyñä cooc̈h jäyaꞌayhajxy nhawáaṉät pǿṉhøch høøc̈h. Pero mijts, homiänaajä hajxy jim̱ mnǿcxät Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Caj mijts cuꞌug xmiähaṉhaty. Pero høøc̈h, xmiähaṉhájpøch cuꞌug. Páadyhøch hajxy xmiähaṉhaty cooc̈h nnägapxy coo hajxy yhaxøøgwädity. ");
INSERT INTO mirNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nøcx mijts xøøhat. Cábøch nnøcxaꞌañ høøc̈h. Cahnä yhabaadyñä cooc̈h jäyaꞌayhajxy nhawáaṉät pǿṉhøch høøc̈h. ");
INSERT INTO mirNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mänit Jesús miädiaacpädøøñä. Mänit jim̱ jiaanc̈h mähmøøñä jim̱ Galilea. ");
INSERT INTO mirNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mänit Jesús yhuchhajxy jim̱ ñøcxy xøøhajpä Jerusalén. Mänit Jesús jim̱ pianøcxy hameeꞌch. ");
INSERT INTO mirNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jim̱ä judíos jaꞌa Jesús hajxy hänajty yhøxtaꞌay maa jaꞌa xøø hänajty jiadyiijän. Jaduhṉ hajxy hänajty miänaꞌañ: ―Maadaꞌa tyijy jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mädiáacäp jaꞌa Jesús hänajty jaꞌa majiäyaꞌayhajxy. Näjeꞌe hajxy hänajty miänaꞌañ cooc yhojiäyaꞌayä. Näjeꞌe hajxy hänajty miänaam̱bä cooc tyijy yhaxøøgjäyaꞌayä, cooc tyijy hänajty wiädity cuꞌugwiinhøhm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero hameeꞌch hajxy hänajty miädiaꞌagy. Hix̱, chähgøøby hajxy hänajty jaꞌa judíos wyiindsøṉhajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mägujnä xøø hänajty jiadyii, mänit Jesús tiägøøyy tsajtøgooty yajnähixøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mänitä judíoshajxy yagjuøøyy, miänaaṉ̃ hajxy: ―Tii yøꞌøyaꞌayädaꞌa coo jiaanc̈h tehm̱ jiaty madiuꞌu y caj yhøxpøquiä. ");
INSERT INTO mirNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mänit Jesús yhadsooyy: ―Caꞌa yhøøc̈hä nhamdsoo mädiaꞌagy hädaa; nDéedyhøch miädiaꞌagy hädaa jaduhṉ, jaꞌac̈h tøø xquiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pøṉ jaduhṉ cudiunaam̱b nebiä Dios miänaꞌañän, jeꞌe najuøꞌøwaam̱b coo quiaꞌa yhøøc̈hä nhamdsoo mädiaꞌagy hädaa, coo Diosmädiaꞌagy hädaa. ");
INSERT INTO mirNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pøṉ jioot jaduhṉ tsojp coo yajcumáyät, jeꞌedsä yhamdsoo mädiaꞌagy mädiaacp. Pero chójpiøch njoot coo Dios wyiingudsähgøꞌøwǿøjät, jaꞌac̈h tøø xquiéx̱iäbä. Nmǿødhøch jaꞌa tøyhajt; cábøch nhøhṉdaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Tøyhajt coo Moisés jaꞌa ñocy jecy yejcy, túhm̱äts. Jiiby jaduhṉ miänaꞌañ ñocyjiooty coo hajxy hoy mjäyaꞌayhádät. Pero cab hajxy mgudiuṉ̃. Mmänaam̱b hajxy jaduhṉ cooc̈h hajxy xyaghoꞌogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mänitä cuꞌug yhadsooyy: ―Nej, mguhmäñøøbiä coo jaduhṉ mmänaꞌañ coo højts miic̈h nyaghoꞌogaꞌañ. Pǿṉdsän miic̈h xyaghoꞌogaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Mänitä Jesús miänáaṉgumbä: ―Tähóoc‑høch jaꞌa hoybä tøø nduṉ̃ jaꞌa pooꞌxxiøøjooty; mänit hajxy myagjuøøyy nägøx̱iä. Mmänaam̱b hajxy jaduhṉ coo hajxy tii ngaꞌa túuṉämät jaꞌa pooꞌxxiøøjooty; paady hajxy myagjuøøyy. ");
INSERT INTO mirNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés jaꞌa cuhdujt jecy yejc coo hajxy mnicircuncidarhadǿøjät. (Caꞌa Mioisésä yajtsohṉdaac; yhaphajpä tieedyhajpähajxy jecy yajtsohṉdaac.) Paadiä mhuung hajxy mcircuncidarhaty hoy jia pooꞌxxiøøjootiä. ");
INSERT INTO mirNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mgudiuum̱by hajxy jaduhṉ nebiä Moisés jaꞌa cuhdujt jecy yejquiän; pero mjootmaꞌp hajxy cooc̈hä jäyaꞌay tøø nyajmøcpøcy jaꞌa pooꞌxxiøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Cabä jäyaꞌay hajxy paquiä mwiinmahñdyhíxät nebiä wyiinmahñdy jeꞌe. Coo jejcy mmøødhídät, mänítäts jaꞌa wyiinmahñdy jeꞌe mhíjxät. Cooc̈hä paꞌamjäyaꞌay tøø nyajmøcpøcy jaꞌa pooꞌxxiøøjooty, paady hajxy jaduhṉ mmänaꞌañ cóogøch tyijy jaꞌa haxøøgwiinmahñdy nmøødä. Mmänaam̱b hajxy jaduhṉ coo tii ngaꞌa túuṉämät jaꞌa pooꞌxxiøøjooty. Pero Dios mänaam̱b coo yhahixøꞌøy coo hajxy ndúuṉämät. ");
INSERT INTO mirNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mänitä Jerusaléngpä jäyaꞌayhajxy näjeꞌe tiägøøyy mänaam̱bä: ―Yøꞌøds hajxy yhøxtaaby coo hajxy yaghoꞌogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Xiidsä quiapxy majiäyaꞌayhagujc, y caj waam̱b ñämaꞌayii. Nej, mänaam̱b højts nwiindsøṉhajtämhajxiädaꞌa coo yøꞌø Miesíasä, jaꞌa hajxy nhahíjxämbä. ");
INSERT INTO mirNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nnajuǿøyyäm hajxy maa yøꞌøyaꞌay chooñ. Pero jaꞌa Mesías, jaꞌa gobiernähadaam̱bä, cab hänajty yajnajuøꞌøwaꞌañ maa hänajty chooñ. ");
INSERT INTO mirNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jiibiä Jesús hänajty yajnähixøꞌøy tsajtøgooty. Coo jaduhṉ miädooyy waam̱baty hajxy hänajty miänaꞌañ, mänitä møc miänaaṉ̃: ―Xyhix̱yhájpøch hajxy. Mnajuøøby hajxy maac̈h ndsooñ. Pero caꞌa yhøøc̈hä hamdsoo tøø nwiinmay cooc̈h yaa ngädáꞌagät. Jaꞌa nDéedyhøch tøø xquiex̱y. Pero cab hajxy mnajuøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nhíx̱yhøch jeꞌe. Jím̱høch ndsooñ. Jeꞌec̈h jaduhṉ tøø xquiex̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Coo Jesús jaduhṉ miänaaṉ̃, mänitä jia madsaaṉä. Pero caj ñäꞌä yajmajch. Cajnä hänajty yhabaadyñä coo Jesús yaghoꞌogǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hoy jaꞌa Jesús hänajty jia madsaꞌañii, nämay jaꞌa Jesús jaꞌa miädiaꞌagy hänajty miäbǿjcäxä. Mänit hajxy miänaaṉ̃: ―Coo jaꞌa Mesías jaduhṉ miédsät, jaꞌa hajxy nhahíjxämbä, nej, maas hoy‑yagjuøøñäjaty jaꞌa Mesíasädaꞌa yajcähxøꞌøgaꞌañ quejee nej yøꞌøyaꞌay jaduhṉ yajcähxøꞌøguiän. ");
INSERT INTO mirNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mänitä fariseoshajxy jaduhṉ miädoyhajty waam̱baty Jesús hänajty miädiaꞌagyii. Mänitä policíahajxy quiejxä coo Jesús hajxy miádsät. Jaꞌa fariseoshajxy jaduhṉ mäguejx møødä teedywiindsøṉhajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mänitä Jesús miänaaṉ̃: ―Cábøch mijts jejcy nmøødhidaaṉnä. Nøcxáaṉnäbøch maac̈hä ndsohṉ̃än. ");
INSERT INTO mirNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Xjia høxtaꞌawáam̱bøch hajxy, pero cábøch hajxy xpiaadaꞌañ. Cab hajxy jim̱ hoy mnǿcxät maac̈h nhidaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mänitä judíoshajxy ñiñämaayyä: ―Maa yøꞌøyaꞌayädaꞌa ñøcxaꞌañ coo hajxy jaduhṉ ngaꞌa páatämät. Nej, nøcxaam̱bädaꞌa jim̱ maa jaꞌa judíoshajxy waꞌxyjaty chänaꞌayän maa jaꞌa hajxy caꞌa Israelpähajpän, coo Diosmädiaꞌagy yajnähixǿꞌøwät jaꞌa hajxy caꞌa judíoshajpä. ");
INSERT INTO mirNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tiidaꞌa tyijy coo miänaꞌañ cooc hajxy nja høxtaꞌawáaṉäm, pero cábäc hajxy nbaadáaṉäm, y cooc hajxy hoy ngaꞌa nǿcxämät maa yhidaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Coo jaꞌa xøø hänajty miayaaṉnä, jaꞌa møjxøøjooty, mänitä Jesús tiänaayyøꞌcy. Mänitä møc miänaaṉ̃: ―Pøṉ tødsǿøyyäp, ween yaa myiṉ̃ maac̈h høøc̈hän, ween miṉ yhuꞌugy mädyíibøch nmoꞌowaam̱by. Jaduhṉ Jesús yajnimiäbaatä nebiä møjnøøgopcän. Mänitä miänáaṉgumbä: ");
INSERT INTO mirNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","―Pønjátyhøch jaꞌa nmädiaꞌagy xmiäbǿjcäp, jeꞌec̈hä nmädiaꞌagy xyajwaꞌxtägájtsäp, nebiä Diosmädiaꞌagy miänaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jaduhṉ Jesús miänaaṉ̃, pønjaty jaꞌa miädiaꞌagy mäbøgáaṉäp, mänitä Dioshespíritu mioꞌowaꞌañii. Cahnä Dioshespíritu hänajty quiädaꞌagyñä. Cahnä Jesús hänajty yaghoꞌogyii; cahnä hänajty yhoodiägachñä maa jaꞌa Tieediän. ");
INSERT INTO mirNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Coo jaꞌa cuꞌughajxy jaduhṉ miädooyy nebiä Jesús hänajty tøø miädiaꞌaguiän, mänit hajxy näjeꞌe miänaaṉ̃: ―Tehm̱ tiøyhajt jaꞌa Dios jaꞌa quiugapxy yøꞌø, jaꞌa Dios hijty quiexaam̱biä. ");
INSERT INTO mirNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Näjeꞌe hajxy miänaam̱bä: ―Jaꞌa Mesías yøꞌø, jaꞌa gobiernähadaam̱bä. Pero näjeꞌehajxy miänaam̱bä: ―Pero cabä Mesías jim̱ choonaꞌañ Galilea. ");
INSERT INTO mirNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Jaduhṉ Diosmädiaꞌagy miänaꞌañ cooc jaꞌa Mesías jaꞌa David yhaphadaꞌañ tieedyhadaꞌañ, y cooc jim̱ choonaꞌañ Belén maa jaꞌa David jecy chänaayyän. ");
INSERT INTO mirNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Coo hajxy hänajty jaduhṉ miädiaꞌagy, cab hajxy hänajty tuꞌugmädiaꞌagy ñibiaadyii jaꞌa Jesúscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Näjeꞌe jaꞌa Jesús hajxy hänajty jia madsaꞌañ, pero caj pøṉ ñäꞌä majch. ");
INSERT INTO mirNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mänitä policíahajxy wyiimbijty maa jaꞌa teedywiindsøṉhajxiän, maa jaꞌa fariseoshajxiän. Mänitä policíahajxy ñämaayyä: ―Tii hajxy coo mgaꞌa yajmejch. ");
INSERT INTO mirNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mänit hajxy yhadsooyy: ―Cab jaduhṉ pøṉ mänaa miädiaꞌagy nej yøꞌøyaꞌay miädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mänitä fariseoshajxy miänaaṉ̃: ―Cab jaduhṉ yhoyyä coo mijts jaduhṉ tøø myajwiinhøhm̱bä. ");
INSERT INTO mirNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Caj yøꞌøyaꞌay jaꞌa miädiaꞌagy miäbǿjcäxä jaꞌa wiindsøṉhajxy møødä fariseoshajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero yøꞌø cuꞌughajxy, cabä jecyquiuhdujt hajxy jiaty. Ween hajxy chaac̈hpøcy. ");
INSERT INTO mirNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jim̱ä Nicodemo hänajty, jaꞌa Jesús hänajty tøø ñähóyyäbä. Fariseohajp hänajty jeꞌebä. Mänitä Nicodemo miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Cab højts nguhdujthájtäm jaduhṉ myíiṉäm coo jäyaꞌay nyajcumädóow̱ämät coo hänajty tøø ngaꞌa mädiaꞌagymiädóow̱äm jayøjp. ");
INSERT INTO mirNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mänitä Nicodemo wyiinwohṉä ñämaayyä: ―Jaduhṉ miic̈h mbamädiaacpä nebiä Galileabä jäyaꞌayhajxy miädiaꞌaguiän. Huuc tehm̱ yajmädiaꞌag jaꞌa Diosmädiaꞌagy. Cab jaduhṉ jiiby maa myiṉ̃ coo jaꞌa Dios jaꞌa quiugapxy jim̱ choonaꞌañ Galilea. ");
INSERT INTO mirNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mänit hajxy ñøcxnä maa jaꞌa tiøjc‑hajxiän. ");
INSERT INTO mirNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mänitä Jesús jim̱ ñøcxy maa jaꞌa tuṉ jaduhṉ xiøhatiän Olivos. ");
INSERT INTO mirNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Cujaboom jopyjiajjøꞌøgyñä, mänitä Jesús ñøcxy maa jaꞌa tsajtøjcän. Mänitä Jesús jaꞌa cuꞌug ñämejtsä. Mänitä Jesús yhäñaaguiädaacy, tiägøøyy yajnähixøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mänitä toꞌoxiøjc tuꞌug yajmejtsä maa Jesúsän. Jaꞌa cuhdujtyajnähixøøbiähajxy mäyajmejts møødä fariseoshajxy. Paadiä toꞌoxiøjc hänajty tøø miac̈hii coo hänajty tøø tiuꞌumaꞌady tøø tiuꞌudägoy. Mänitä toꞌoxiøjc jim̱ yajnøcxä maa jaꞌa cuꞌughagujcän. ");
INSERT INTO mirNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mänitä cuꞌug jaꞌa Jesús hajxy ñämaayy: ―Wiindsǿṉ, paady hädaa toꞌoxiøjc tøø miac̈hii coo tøø piaadyii wiingyaꞌadiøjmøød. ");
INSERT INTO mirNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Jiiby maa jaꞌa Diosmädiaꞌaguiän, jiibiä Moisés hajxy xyhanéhm̱äm coo jaꞌa toꞌoxiøjc jaduhm̱bä hajxy nguhgáꞌtsämät. Míic̈häts, waam̱b miic̈h mmänaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Paady hajxy jaduhṉ yajtøøyy, coo hajxy hänajty miädow̱aꞌañ pø tuꞌugmädiaꞌagy jaꞌa Jesús hänajty møødä Diosmädiaꞌagy. Yhøxtaaby hajxy hänajty nebiä Jesús hajxy ñähwaam̱bédät coo häxøpy quiaꞌa tuꞌugmädiaꞌaguiä. Pero cabä Jesús waam̱b yhadsooyy. Mänitä Jesús ñaax̱cooyy. Mänitä tiägøøyy jahbiä cøꞌøhaam naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mänitä Jesús jaduhṉ miäyajtǿøw̱ägumbä. Mänit yhäñaaguiugøøyy. Mänit miänaaṉ̃: ―Pøṉä pojpä cädieey caꞌa møød, ween quiaꞌtstsooñ. ");
INSERT INTO mirNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mänitä Jesús ñaax̱cóogumbä. Mänit tiägǿøguiumbä jahbiä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Coo hajxy jaduhṉ miädooyy nebiä Jesús hänajty tøø miänaꞌañän, mänit hajxy jeꞌe tiuꞌubøjnä hanidiuhm̱jaty. Jaꞌa møjpä, jeꞌe jawyiin tehm̱ tiuꞌubøjtsohṉ. Niñajuøøyyä hajxy hamdsoo coo jaꞌa pojpä cädieey hajxy hänajty miøødä, paady hajxy tiuꞌubøjcy. Mänämetscä Jesús jaꞌa toꞌoxiøjc miøødmähmøøyy. Jim̱ä toꞌoxiøjc hänajty tiänaꞌay Jesús jaꞌa wyiinduum. ");
INSERT INTO mirNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mänitä Jesús yhäñaaguiugøøyy. Mänitä Jesús jaꞌa toꞌoxiøjc ñämaayy: ―Maa jaayaꞌayhajxy, jaꞌa hajxy hijty xquiuhgaꞌadsaam̱bä. Nej, caj pøṉ tøø xñäꞌä cuhgaꞌac̈hä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mänitä toꞌoxiøjc yhadsooyy: ―Wiindsǿṉ, caj. Mänitä Jesús miänaaṉ̃: ―Ni høøc̈h jaduhṉ ngaꞌa mänaam̱bä coo miic̈h myajcuhgáꞌadsät. Nøcx; cab jaduhṉ haxøøg mjatcǿøñät. ");
INSERT INTO mirNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mänitä Jesús miänáaṉgumbä: ―Jaduhṉ mäwíinhøch nyajnimiäbaadyii nebiä jøønän cooc̈hä jäyaꞌayhajxy nyajnähixøꞌøy jaꞌa tuꞌu hoybä. Pønjaty jaꞌa nmädiaꞌagy xpianøcxáaṉäp, cab jaduhṉ wiäditaꞌañ hagoodstuum. Cøjxtaꞌaxiøø jim̱ yhidaꞌañ tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mänitä fariseos jaꞌa Jesús hajxy ñämaayy: ―Hamdsoo miic̈h mniñänømyii. Pero caj miic̈h mnäꞌä tømiädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mänitä Jesús yhadsooyy: ―Tømiädiáacpøch, hóyhøch hamdsoo nja niñänømyii. Nnajuǿøbiøch maac̈h ndsooñ maac̈h nnøcxy. Pero mijts, cab hajxy mnajuøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Näꞌä nägóobøch mijts xñäꞌä nähwaam̱bety. Pero høøc̈hä, cábøch jäyaꞌay näꞌä nägoobä nnähwaam̱bety. ");
INSERT INTO mirNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tøyhájthøch nnäꞌägädä mädiaꞌagy. Caꞌa yhøøc̈hä nhamdsoo mädiaꞌagy hädaa; jaꞌa nDéedyhøc̈hä miädiaꞌagy hädaa, jaꞌac̈h tøø xquiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Miim̱b jaduhṉ cujaay maa jaꞌa Diosmädiaꞌaguiän, coo jäyaꞌayhajxy tiuꞌugmädiaꞌaguiä nämetscä, pues tøyhajt hajxy jaduhṉ yejpy. ");
INSERT INTO mirNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pues højts, tuꞌugmädiaꞌagy højts mǿødhøch nDeedy cooc̈h jeꞌe tøø xquiex̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mänitä fariseoshajxy miänaaṉ̃: ―Maa mDeedy. Mänitä Jesús yhadsooyy: ―Cábøch mijts xñajuøꞌøy; ni jaꞌa nDéedyhøch hajxy xquiaꞌa najuøøyyä. Cooc̈h mijts häxøpy xñajuøꞌøy, xñajuǿøyyäbøch jaꞌa nDeedy hajxy häxøpy. ");
INSERT INTO mirNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yajnähixøøguiujc jaꞌa Jesús jaduhṉ miänaaṉ̃ jiiby tsajtøgooty, jiiby mädøyyä maa jaꞌa cajän maa jaꞌa xädøꞌøñ hajxy hänajty yajnähgädaꞌaguiän. Pero cabä Jesús hänajty pøṉ miadsaꞌañii, hoy hänajty jia mädiaꞌagy cuꞌughagujc. Cahnä hänajty yhabaady coo jeꞌe miadsǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mänitä Jesús miänáaṉgumbä: ―Nøcxáaṉnäbøch høøc̈h. Xjia høxtaꞌawáam̱bøch mijts, pero cábøch hajxy xpiaadaꞌañ. Cab hajxy hoy mnǿcxät maac̈h nnøcxaꞌañän. Coo hajxy mhoꞌogaꞌañ, jiiby hajxy mgaꞌawaꞌañ haxøøgtuum. ");
INSERT INTO mirNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mänitä judíoshajxy ñiñämaayyä: ―Nej, hamdsoodaꞌa ñiyaghoꞌogaꞌañii, coo hajxy jaduhṉ ngaꞌa nǿcxämät maa ñøcxäꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mänitä Jesús miänaaṉ̃: ―Yaa mijts mdsooñ, hädaa yaabä naax̱wiin. Pero høøc̈h, tsajpóotypøch ndsooñ, caꞌa yaajä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tøøc̈h mijts jaduhṉ nnämaꞌay, coo hajxy hänajty tøø mhoꞌogy, cahnä mbojpä mgädieey hajxy hänajty xñähwaꞌac̈hñä. Cabä mbojpä mgädieey hajxy xñähwaꞌadsaꞌañ cooc̈hä nmädiaꞌagy hajxy xquiaꞌa mäbǿjcät pǿṉhøch høøc̈h. ");
INSERT INTO mirNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mänitä Jesús hajxy miäyajtøøyy: ―Pǿṉäsän miic̈h. Mänitä Jesús yhadsooyy: ―Tøøc̈h mijts nja hawáaṉäm pǿṉhøch høøc̈h. ");
INSERT INTO mirNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Madiúꞌujøch nnägápxät coo hajxy haxøøg mjäyaꞌayhaty. Cábøch mijts jaꞌa nmädiaꞌagy xmiäbøjcä. Nhawáaṉäm mijts jaduhṉ nebiátyhøch jaayaꞌay tøø xñajtscapxøøyyän, jaꞌac̈h tøø xquiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero cab hajxy wyiinjuøøyy coo Jesús jaꞌa Tieedy jaduhṉ ñägapxy. ");
INSERT INTO mirNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mänitä Jesús miänaaṉ̃: ―Cooc̈h mijts hänajty tøø xmiøjpahbety, mänit hajxy mnajuøꞌøwaꞌañ pǿṉhøch høøc̈h, y cooc̈hä nhamdsoo cuhdujt ngaꞌa yajtuṉ̃. Pero jaduhṉ nhawáaṉäm nebiátyhøch jaꞌa nDeedy tøø xyajnähixøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Xmiøødwädíjpøch jeꞌe, jaꞌac̈h tøø xquiéx̱iäbä. Cábøch nidiuhm̱ tøø xñähgueꞌegy jeꞌeguiøxpä cooc̈h homiänaajä ngudiuṉ̃ nébiøch tøø xyhaneꞌemiän. ");
INSERT INTO mirNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Coo jaꞌa Jesús jaduhṉ miädiaacy, mänitä miädiaꞌagy miäbǿjcäxä nämay. ");
INSERT INTO mirNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mänitä Jesús ñämaayy jaꞌa judíoshajxy, jaꞌa Jesús jaꞌa miädiaꞌagy hajxy hänajty tøø miäbǿjcäbä: ―Cooc̈h mijts jaꞌa nmädiaꞌagy xquiudiúuṉät homiänaajä, mänítøch mijts hamuumduꞌjoot xmiøødwädítät. ");
INSERT INTO mirNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jaduhṉdsä tøyhajt hajxy mmøødhádät cooc̈h jaꞌa Dios tøø xquiex̱y. Jaduhṉdsä mhaxøøgwiinmahñdy hajxy mnajtshixǿꞌøwät, nebiä møjcuꞌugong hajxy jaduhṉ xquiaꞌa hanéꞌemät. ");
INSERT INTO mirNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mänitä judíoshajxy yhadsooyy: ―Abraham højts hijty nhaphajpy ndeedyhajpy. Cab højts pøṉ xyhaneꞌemy. Tii jaduhṉ coo mmänaꞌañ coo højts jaꞌa møjcuꞌugong xquiaꞌa hanéꞌemät. ");
INSERT INTO mirNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Mänitä Jesús yhadsooyy: ―Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, pønjaty jaꞌa pojpä cädieey jaduhṉ møød, møjcuꞌugong jaduhṉ hanehm̱b. ");
INSERT INTO mirNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jaꞌa moonsähajxy, cab hajxy jim̱ yhity cøjxtaꞌaxiøø maa hajxy quiuduṉ̃än. Pero jaꞌa cumoonsä yhuungä, jeꞌeds jim̱ näꞌägä hijp maa jaꞌa tiøjcän. ");
INSERT INTO mirNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Høøc̈h, nbuhbédäbøch mijts jaduhṉ nebiä mhaxøøgwiinmahñdy hajxy mnajtshixǿꞌøwät, nebiä møjcuꞌugong hajxy jaduhṉ xquiaꞌa hanéꞌemät. ");
INSERT INTO mirNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nnajuǿøbiøch jaduhṉ coo Abraham hajxy hijty mhaphaty mdeedyhaty. Pero xyaghoꞌogáam̱bøch mijts, jeꞌeguiøxpä coo hajxy tuꞌjoot mgaꞌa tunaꞌañ nébiøch mijts nja nämaꞌayän. ");
INSERT INTO mirNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nmädiáacypiøch nébiøch jaꞌa nDeedy tøø xyajmøødmädiaꞌaguiän. Pero mijts, jaduhṉ mijts mjäyaꞌayhaty nebiä mdeedy yaa jiäyaꞌayhatiän hädaa yaabä naax̱wiin, nebiä cuꞌug yhaneꞌemiän. ");
INSERT INTO mirNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mänit hajxy yhadsooyy: ―Abraham højts hijty nhaphajpy ndeedyhajpy. Mänitä Jesús miänaaṉ̃: ―Pø tøyhajt jaꞌa Abraham hajxy hijty mhaphaty mdeedyhaty, jaduhṉ hajxy mjäyaꞌayhájpät nebiä Abraham jecy jiäyaꞌayhajtiän. ");
INSERT INTO mirNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero xyaghoꞌogáam̱bøch mijts, hóyhøch mijts jaꞌa tøyhajt tøø nja yajmøødmädiaꞌagy, mädyíibøch jaꞌa Dios tøø xyajmøødmädiaꞌagy. Cábøc̈hä Abraham häxøpy xyaghoꞌogaꞌañ. Caj mijts mjäyaꞌayhaty nebiä Abraham jecy jiäyaꞌayhajtiän. ");
INSERT INTO mirNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jaduhṉ mijts mjäyaꞌayhaty nebiä mdeedyhajxy jiäyaꞌayhatiän. Mänitä Jesús ñämaayyä: ―Tøyhajt højts jaꞌa Abraham hijty nhaphaty ndeedyhaty. Jaduhṉ højts njäyaꞌayhaty nebiä Abraham jecy jiäyaꞌayhajtiän. Tuꞌug højts nDeedy; Dios jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Mänitä Jesús miänaaṉ̃: ―Coo Dios hajxy häxøpy tøyhajt mDeedyhaty, xchójpøch mijts häxøpy yaabä. Jím̱høch tøø ndsooñ maa Diosän; pero yaac̈h nhijnä hädaa yaabä naax̱wiin. Caꞌa yhamdsoo jóothøch yaa tøø ngädaꞌagy. Dióshøch xquiejx. ");
INSERT INTO mirNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Xiǿøbøch yaa nja mädiaꞌagy; cábøch mijts jaꞌa nmädiaꞌagy xñäꞌä cudiunaaṉä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jaꞌa møjcuꞌugong hajxy mdeedyhajpy. Jaduhṉ hajxy mjäyaꞌayhaty nebiä mdeedy jiäyaꞌayhatiän. Mänit jeꞌe tiägøøyy jäyaꞌay‑yaghoꞌpä mänaabä naax̱wiin yhawijy tiøøꞌxtaꞌaguiän. Cabä tiømiädiaꞌagy. Cabä hädaa yaabä naax̱wiin hoy jiäyaꞌayhaty. Høhṉdaacp jeꞌe; jaduhṉ ñäꞌägä cuhdujthaty. Jaduhṉ jäyaꞌayhajxy yaa yajnähixøꞌøyii jaꞌa møjcuꞌuwiinmahñdy. ");
INSERT INTO mirNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero høøc̈h, cooc̈h mijts jaꞌa tøyhajt nyajmøødmädiaꞌagy, cábøch nmädiaꞌagy hajxy xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hopiøṉä ñajuøꞌøy cooc̈hä pojpä cädieey ngaꞌa møødä. Jaduhṉ hajxy mnajuǿꞌøwät cooc̈hä tøyhajt nmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jaꞌa Dios jaꞌa yhuungä, miädóow̱äp jeꞌe jaꞌa Dios jaꞌa miädiaꞌagy. Pero mijtsä, caj mijts Dios xyhuunghaty; paadiä Dios miädiaꞌagy hajxy mgaꞌa mädow̱aaṉä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mänitä Jesús ñämaayyä jaꞌa judíoshajxy: ―Nej, cab jaduhṉ tiøyyä coo jim̱ mdsooñ Samaria, coo møjcuꞌugong tøø xyajtägøꞌøyä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mänitä Jesús yhadsooyy: ―Cábøc̈hä møjcuꞌugong tøø xyajtägøꞌøy. Nwiinguhdsähgǿøbiøch jaꞌa nDeedy. Pero cábøch mijts xwyiingudsähgøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Cábøch hamdsoo nmänaꞌañ cooc̈h hajxy xwyiingudsähgǿꞌøwät. Jaꞌa nDéedyhøch jaduhṉ mänaam̱b. Yajcumädow̱aam̱by jeꞌe pǿṉhøch haxøøg xñänøøm̱b. ");
INSERT INTO mirNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, cooc̈hä nmädiaꞌagy pøṉ xmiäbǿjcät, ni mänaa quiaꞌa hóꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mänitä judíoshajxy yhadsooyy: ―Hoora sí, tøø højts nnajuøꞌøy coo møjcuꞌugong tøø xyajtägøꞌøy. Tøø jaꞌa Abraham yhoꞌogy møødä Dios jaꞌa quiugapxyhajxy. Pero miic̈h mänaam̱b coo mmädiaꞌagy pøṉ xmiäbǿjcät, ni mänaa quiaꞌa hóꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nej, maas møc miic̈hä cuhdujt mmøødä quejee jaꞌa Abraham jecy miøødhajty, jaꞌa hajxy hijty nhaphájtäm ndeedyhájtämbä. Tøø jeꞌe yhoꞌogy. Jaduhṉ jaꞌa Dios jaꞌa quiugapxyhajxy tøø yhoꞌpä. Pøṉ tyijy miic̈h coo jaduhṉ mniñänømyii. ");
INSERT INTO mirNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mänitä Jesús yhadsooyy: ―Cab jaduhṉ yhahixøꞌøy cooc̈h hamdsoo nniguiumayǿøjät. Pero Dióshøch xquiumaaby, jaꞌa tyijy mijts mDioshajpy. ");
INSERT INTO mirNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Cáhnøch nDeedy hajxy xñajuøøyyä. Pero høøc̈h, nhíx̱yhøch høøc̈h. Cooc̈h nmänáꞌanät cooc̈h ngaꞌa hix̱iä, høhṉdáꞌagäbøch jaduhṉ nej mijts mhøhṉdaꞌaguiän. Pero nhíx̱yhøch høøc̈h. Nmäbǿjcäbøch jaꞌa miädiaꞌagy jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Jaꞌa Abraham, jaꞌa hajxy jecy nhaphájtäm jaꞌa ndeedyhájtämbä, xooṉdaacp jeꞌe hijty cooc̈h hänajty xyhixaꞌañ mänáajøch hänajty nhidaꞌañän hädaa yaabä naax̱wiin. Tøøc̈h jeꞌe xjiaanc̈h hix̱y. Mänit jiaanc̈h xooṉdaacy. ");
INSERT INTO mirNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mänitä Jesús ñämaayyä jaꞌa judíoshajxy: ―Jeꞌenä jaduhṉ mdsaanä. Nej, tøø jaꞌa Abraham mhix̱iä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mänitä Jesús yhadsooyy: ―Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, jíiyyämøch hänajty; cahnä Abraham hänajty jiinä. ");
INSERT INTO mirNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mänitä tsaa hajxy quionøꞌcy; Jesús hajxy hänajty quiuhgaꞌadsaam̱by. Pero tøø jaꞌa Jesús hänajty ñiguiuꞌuc̈hii. Mänit piädsøøm̱nä tsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jim̱ä Jesús hänajty ñax̱y. Mänitä wiindspä tuꞌug yhijxy. Jaduhṉä mähdiøjc ñäꞌägä maaxhuunghajty wiinmaꞌad. ");
INSERT INTO mirNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mänitä Jesús ñämaayyä jaꞌa jiamiøødhajxy: ―Wiindsǿṉ, tii yøꞌøyaꞌay wyiinädaꞌa coo miaꞌadä. Pøṉä pojpä cädieeyädaꞌa tøø tiuṉ̃, yøꞌøyaꞌayä, tøgä tiaj tieediä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mänitä Jesús yhadsooyy: ―Ni pøṉ. Paady yøꞌøyaꞌay wyiin miaꞌadä nebiä Dios jaꞌa miäjaa jaduhṉ quiähxǿꞌøgät maa yøꞌøyaꞌaguiøxpän. ");
INSERT INTO mirNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tsøc Diostuuṉg hajxy túuṉäm, jaꞌac̈h tøø xquiéx̱iäbä, mäduhṉ̃tiä jugyhajt hajxy nmøødhájtäm. Coo hajxy nhóꞌcänät, cab hajxy jaduhṉ mänaa ndúuṉänät. ");
INSERT INTO mirNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cooc̈h yaa nhity hädaa yaabä naax̱wiin, nyajcähxǿꞌpiøch jäyaꞌay piojpä quiädieeyhajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mänitä Jesús ñajtsujøøyy naax̱wiin. Mänitä chujy yajmoꞌondscojy. Mänitä pyiinøꞌcy. Mänitä wiindspä yajwiingupiinøøyy jaꞌa chujy, jaꞌa hänajty tøø mioꞌondscójjiäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Mänitä Jesús jaꞌa wiindspä ñämaayy: ―Nøcx niwyiimbujøø maa jaꞌa tsiidaact jaduhṉ xiøhatiän Siloé ―jeꞌe jaduhṉ ñänøøm̱by, Quex̱y. Mänitä wiindspä hoy jiaanc̈h niwyiimbujyii. Coo wyiimbijnä, tøø hänajty wyiindøøꞌxøꞌnä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mänitä mähdiøjc yhijxä jaꞌa miädøjc‑hajxy møødä hajxy hijty yhijxypä coo hänajty xiädøꞌøñyujwaꞌañ. Mänitä hajxy miänaaṉ̃: ―Nej, caj jieꞌe yøꞌøjä, jaꞌa hijty nax̱y xädøꞌøñyujwaam̱bä häñaꞌa. ");
INSERT INTO mirNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Näjeꞌe hajxy hänajty miänaꞌañ: ―Jaanc̈h jeꞌe yøꞌø. Näjeꞌe hajxy hänajty miänaꞌañ: ―Caꞌa jieꞌejä; pero tehm̱ jiaduhṉ quiähxøꞌøgy. Pero jaꞌa mähdiøjc, hamdsoo hänajty ñiñänømyii: ―Høøc̈h jeꞌe hijty wiinds. ");
INSERT INTO mirNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mänitä miäyajtøøw̱a: ―Nejy mwiindøøꞌxøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mänit yhadsooyy: ―Jaayaꞌay jaꞌa Jesúshajpä, jaayaꞌay jaꞌa chujy yajmoꞌondscoj. Mänítøch xyajwiingubiinøøyy. Mänítøch xñämaayy cooc̈h nøcxy nniwyiimbujyii maa jaꞌa tsiidaact jaduhṉ xiøhatiän Siloé. Mänítøch hoy njaanc̈h niwyiimbujyii. Mänítøch nwiindøøꞌxøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mänitä miäyajtǿøw̱ägumbä: ―Maa jaayaꞌayädaꞌa. Mänit yhadsooyy: ―Pämáadädä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mänitä mähdiøjc yajnøcxä maa jaꞌa fariseos wyiinduumhajxiän, jaꞌa hänajty tøø wyiindøøꞌxǿꞌøguiäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Pooꞌxxiøøjooty jaꞌa Jesús jaꞌa chujy yajmoꞌondscojy, yajwiindøøꞌxøꞌcy jaꞌa wiindspä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mänitä mähdiøjc miäyajtǿøw̱ägumbä jaꞌa fariseoshajxy: ―Nejy mwiindøøꞌxøꞌcy. Mänit yhadsooyy: ―Chujy jaayaꞌay yajmoꞌondscoj; jeꞌec̈h jeꞌe xyajwiingubiinøøyy. Mänítøch hoy nniwyiimbujyii. Mänítøch nwiindøøꞌxøꞌnä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mänitä fariseoshajxy näjeꞌe miänaaṉ̃: ―Caꞌa yøꞌøyaꞌay Dyiosquex̱iä. Tuum̱b yøꞌøduhṉ pooꞌxxiøøjooty. Cabä cuhdujt miøødä coo jaduhṉ tiúnät pooꞌxxiøøjooty. Pero näjeꞌe hajxy hänajty miänaꞌañ: ―Pero nebiä cuboj cugädieejiäyaꞌay jaꞌa hoy‑yagjuøøñäjatypä jaduhṉ ñäꞌä yajcähxǿꞌøgät. Cab hajxy hänajty tuꞌugmädiaꞌagy ñibiaadyii. ");
INSERT INTO mirNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mänitä mähdiøjc ñämaayyä, jaꞌa hänajty tøø wyiindøøꞌxǿꞌøguiäbä: ―Míic̈häts, waam̱b miic̈h mmänaꞌañ. Nejy yøꞌøyaꞌay mnänøm̱y, jaꞌa tøø xyaghijxǿꞌøguiäbä. Mänit yhadsooyy: ―Dios jeꞌe tøø quiex̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Cabä judíoshajxy hänajty miäbøgaꞌañ coo jaayaꞌay hijty wyiindsä, coo jaayaꞌay hijty tøø wyiindøøꞌxøꞌøgy. Paady hajxy miøjyaax̱y jaayaꞌay tiaj tieedy. ");
INSERT INTO mirNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mänit hajxy miäyajtøøw̱a: ―Nej, mijts jaꞌa mhuung yøꞌø, jaꞌa hajxy mnänøøm̱biä coo hijty wiinds tøø miaaxhuunghatiä. Nebiädaꞌa tøø yhijxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mänitä tiaj tieedyhajxy yhadsooyy: ―Højts nhuung jaanc̈h yøꞌø. Wiinds jiaanc̈h maaxhuunghajty. ");
INSERT INTO mirNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero cab højts nnajuøꞌøy nejy tøø yhijxøꞌøgy o pøṉ jaduhṉ tøø yaghijxøꞌøgy. Yøꞌø hajxy mäyajtøw̱. Møj yøꞌøjän. Ween hamdsoo ñägapxy. ");
INSERT INTO mirNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Paady hajxy jaduhṉ miänaaṉ̃, coo jaꞌa teedywiindsǿṉ hajxy hänajty chähgøꞌøy. Tøø jaꞌa teedywiindsøṉhajxy hänajty quiojyquiapxyhaty coo hajxy hänajty yajpädsøm̱aꞌañ tsajtøgooty pøṉ jaduhṉ mänaꞌanaam̱b cooc Jesús Miesíashaty. Nägooyyä hajxy hänajty yajtøjpädsøm̱aꞌañ, cab hajxy hänajty yajtøjtägøꞌøwaaṉnä tsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Paady jaayaꞌay tiaj tieedyhajxy miänaaṉ̃: “Yøꞌø hajxy mäyajtøw̱. Møj yøꞌøjän.” ");
INSERT INTO mirNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mänitä mähdiøjc miøjyáax̱ägumbä, jaꞌa hänajty tøø yhijxǿꞌøguiäbä. Mänitä ñämaayyä: ―Højts tøyhajt móoyyäc. Nnajuøøby højts coo Jesús quiuboj quiugädieeyä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mänit yhadsooyy: ―Cábøch nnajuøꞌøy pø cuboj pø cugädieey jeꞌe. Pero nnajuǿøbiøch cooc̈h tøø nhijxøꞌøgy, hóyhøch hijty nja wiindsä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mänit ñämaayyä: ―Nej xyaghijxøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mänit yhadsooyy: ―Tøøds mijts nja hawáaṉäm. Pero cab hajxy mmäbøjcy. Tii hajxy coo mmädow̱áaṉgombä. Nej, mbanøcxáaṉäp jaꞌa miädiaꞌagy hajxypä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mänit yhojjä ñämaayyä: ―Miic̈h jaduhṉ mbanǿcxäp jaꞌa miädiaꞌagy. Højtsä, Moisés jaꞌa miädiaꞌagy nbanǿcxäp. ");
INSERT INTO mirNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nnajuøøby højts coo Dios jaꞌa Moisés miøødmädiaacy jequiän. Pero jaayaꞌayä, cab højts nnajuøꞌøy maa chooñ. ");
INSERT INTO mirNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mänitä mähdiøjc yhadsooyy: ―Hoy‑yagjuøøñä jaduhṉ. Cab hajxy mnajuøꞌøy maa jaayaꞌay chooñ, hóyhøch tøø xjia yaghijxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Hoy piøṉä jaduhṉ ñajuøꞌøy coo Dios jaduhṉ quiaꞌa mädoow̱a jaꞌa miädiaꞌagy jaꞌa cuboj jaꞌa cugädieey. Pero pøṉ jaꞌa Dios jaduhṉ wiingudsähgøøby, pøṉ jaduhṉ cudiuum̱b nebiä Dios yhaneꞌemiän, jeꞌe jaꞌa miädiaꞌagy jaduhṉ mädóow̱äxäp jaꞌa Diósäm. ");
INSERT INTO mirNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Høxtahm̱ds jaꞌa naax̱wiin yhawijy tiøøꞌxtaꞌaguiän, ni mänaa jaduhṉ quiaꞌa yajmädoyhaty coo jäyaꞌay yaghijxøꞌøgyii, jaꞌa wiinds tøø miaaxhuunghátiäbä, høxtä jädaꞌanäbaady. ");
INSERT INTO mirNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Coo jaayaꞌay häxøpy quiaꞌa Diosquex̱iä, cab jaayaꞌay cu yajcähxøꞌcy hoy‑yagjuǿøñäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mänitä mähdiøjc yhojjä: ―Nej, xyajnähixøꞌøwaam̱b højts miic̈hä. Pojpätuum cädieediuum miic̈h tøø mmaaxhuunghaty. Mänitä mähdiøjc jeꞌe yajpädsøøm̱a tsajtøgooty. ");
INSERT INTO mirNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mänitä Jesús miädoyhajty coo jaꞌa mähdiøjc hänajty tøø yajpädsøm̱yii tsajtøgooty. Mänitä Jesús jaꞌa mähdiøjc yhøxtaayy. Mänit jiaanc̈h paaty. Mänitä Jesús miänaaṉ̃: ―Nej, mmäbǿjcäp jaꞌa miädiaꞌagy, jaꞌa Dios tøø quiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mänitä mähdiøjc yhadsooyy: ―Wiindsǿṉ, pøṉ jaduhṉ mnänøøm̱by. Høøc̈h hawáaṉäc nébiøch jaꞌa miädiaꞌagy nmäbǿjcät. ");
INSERT INTO mirNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mänitä Jesús miänaaṉ̃: ―Tøø jeꞌe mhix̱y. Høøc̈h jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mänitä mähdiøjc miänaaṉ̃: ―Wiindsǿṉ, mäbǿjpøch. Mänitä Jesús wyiinjijcädaacä, wyiingudsähgøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mänitä Jesús miänaaṉ̃: ―Páadyhøch yaa tøø ngädaꞌagy hädaa yaabä naax̱wiin neby hajxy jaduhṉ yhijxǿꞌøgät, jaꞌa hajxy hijpä nebiä wiindspän; møød neby hajxy jaduhṉ wyiindsǿꞌøwät, jaꞌa hajxy hijpä nebiä hijxpän. ");
INSERT INTO mirNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jim̱ä fariseoshajxy hänajty näjeꞌe tiänaꞌay maa Jesús hänajty mädøyyän. Coo hajxy jaduhṉ miädooyy nebiä Jesús miänaaṉ̃än, mänitä Jesús hajxy ñämaayy: ―Nej, mmänaam̱b miic̈h jaduhṉä coo højts jaduhṉ nhijpä nebiä wiindspän. ");
INSERT INTO mirNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Mänitä Jesús yhadsooyy: ―Coo hajxy häxøpy mhity nebiä wiindspän, cabä pojpä cädieey hajxy häxøpy mhix̱yhaty. Pero coo hajxy jaduhṉ mmänaꞌañ coo hajxy mhity nebiä hijxpän, paadiä mbojpä jaꞌa mgädieey hajxy xquiaꞌa nähwaꞌac̈hñä. ");
INSERT INTO mirNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Mänitä Jesús miänáaṉgombä: ―Chaads mijts tehm̱ tiøyhajt nnämáꞌawät: cabä meeꞌtspähajxy jiiby tiägøꞌøwøꞌøy maa jaꞌa meegcuraahaawän. Wiingtuum hajxy jeꞌe tiägøꞌøwøꞌøy maa jaꞌa curaahaaw quiaꞌa hitiän. ");
INSERT INTO mirNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero jaꞌa cumeeg, jeꞌeds jiiby tägøꞌøwøøby maa jaꞌa curaahaawän. ");
INSERT INTO mirNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yajtägøøby jaꞌa curaagüeendähajpä jaꞌa cumeeg jiiby curaajooty. Coo hänajty mieegmøjyaꞌaxaꞌañ, mänitä mieeg quiøx̱y xøøguyaꞌaxy. Yoꞌmädooby jaꞌa meeg jaꞌa wyiindsǿṉ hajxy. Mänitä cumeeg yhøxwoobädsøm̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Coo jaꞌa meeghajxy hänajty tøø piädsøm̱y, mänitä wyiindsǿṉ hajxy cøjx piaduꞌubøcy. Paady hajxy jaduhṉ piaduꞌubøcy coo jaꞌa wyiindsǿṉ hajxy yoꞌmädoy. ");
INSERT INTO mirNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Cabä wiingjäyaꞌay hajxy pianøcxaꞌañ. Coo wiingjäyaꞌay hajxy yoꞌmädoy, cøjx hajxy chähgøꞌøbäyøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jaꞌa Jesús, yajmäbaadyhaam hänajty miädiaꞌagy; pero cabä miädiaꞌagy hänajty wyiinjuǿøyyäxä. ");
INSERT INTO mirNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mänitä Jesús miänáaṉgumbä: ―Chaads mijts tehm̱ tøyhajt nnämáꞌawät: Øøc̈h, jaduhṉ mäwíinhøch nebiä curaahaawän maa jaꞌa meeghajxy tiägøꞌøwøꞌøyän. ");
INSERT INTO mirNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Cáhnøch hänajty nmech, tøø jäyaꞌayhajxy hänajty may miech høhṉdaacpä. Jaduhṉ hajxy ñibiädaꞌagyii nebiä Diosquex̱ypän. Jaduhṉ mäwíinäts hajxy miäbaady nebiä meegmeeꞌtspän. Pero cabä miädiaꞌagyhajxy miäbǿjcäxä. Jaayaꞌayädshajxy jaduhṉ caꞌa mäbøjc, pønjátyhøch nmädiaꞌagy xmiäbǿjcäp. Jaduhṉ mäwíinäts hajxy jeꞌe miäbaatpä nebiä meeg mädiaꞌagymiäbøjpän. ");
INSERT INTO mirNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jaꞌa meeghajxy, jii hajxy jeꞌe tiägøꞌøwøꞌøy maa jaꞌa curaahaawän. Høøc̈h, jaduhṉ mäwíinhøch nebiä curaahaawän. Pǿṉhøch jaꞌa nmädiaꞌagy xmiäbǿjcäp, jeꞌec̈h ngüeendähadaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Jaꞌa hajxy jäyaꞌawyiinhøhm̱bä, Diosmädiáꞌaguiäc tyijy hajxy jeꞌe yajwaꞌxyp. Yhamdsoo copcooty jaꞌa mädiaꞌagy hajxy hänajty yajpädsøm̱y. Pero høøc̈h, páadyhøch tøø ngädaꞌagy hädaa yaabä naax̱wiin nebiä jäyaꞌayhajxy jaduhṉ jim̱ ñǿcxät tsajpootyp, neby hajxy jaduhṉ jim̱ yhídät cøjxtaꞌaxiøø. ");
INSERT INTO mirNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jaꞌa cumeeg, cwieendähajpy jaꞌa mieeg jeꞌe. Jaduhṉ mäwíinhøch jeꞌe, ngüeendähadáam̱biøch jaꞌac̈h nmädiaꞌagy hajxy xmiäbǿjcäbä. Jaayaꞌay jaꞌa meeg jaanc̈h tehm̱ chojpä, høxtä ñähhoꞌtúꞌudäp jaꞌa mieeg. ");
INSERT INTO mirNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Jaꞌa moonsähajxy, cabä meeg hajxy tuꞌjoot cwieendähaty. Paady hajxy jeꞌe tuꞌjoot quiaꞌa cueendähaty, coo hajxy jeꞌe quiaꞌa yhamdsoo jeꞌejä. Mäjuy hajxy jeꞌe jia cuduṉ̃. Coo jaꞌa pahuc miech meegtsuꞌtspä, mänitä moonsähajxy piäyøꞌøgy. Mänitä meeg mähdiøjc‑hajxy ñäꞌägä mac̈hii. Mänit hajxy chähgøꞌøbäyøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Pero høøc̈h, jaduhṉ mäwíinhøch nebiä jäyaꞌay meeg hajxy jaanc̈h tehm̱ chojpän. Xyhix̱yhájpøch jaꞌa nDeedy, y nhix̱yhájpiøch jeꞌebä. Jaanä jaduhṉds jeꞌe, jaanä nhix̱yhájpiøch pønjátyhøch nmädiaꞌagy hajxy xmiäbǿjcäp. Nnähhoꞌtuꞌudáam̱biøch hajxy jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Jaanä xmiäbøgáaṉäbøch jaꞌa nmädiaꞌagy hajxy, jaꞌa jäyaꞌayhajxy tsänaabiä wiinghagajpt. Tuꞌugmädiaꞌagy hajxy yhidaꞌañ møød hädaa jäyaꞌayhajxy yaabä. Tuꞌcuhdújthøch jaꞌa nmädiaꞌagy hajxy xmiäbøgaaṉä nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Páadyhøch jaꞌa nDeedy xchocy cooc̈h jaduhṉ nmänaꞌañ cooc̈h hänaꞌc ween xyaghoꞌogy nébiøch jaduhṉ njujypiǿgät jadähooc. ");
INSERT INTO mirNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Høøc̈h, hamdsooc̈h nmänaꞌañ cooc̈hä jäyaꞌay xyaghóꞌogät. Cooc̈h häxøpy ngaꞌa mänaam̱bä, cábøc̈hä jäyaꞌay häxøpy xyaghoꞌogaꞌañ. Nmǿødhøch cuhdujt cooc̈h nhóꞌogät; y nmǿødhøch cuhdujt cooc̈h njujypiǿgät jadähooc. Páadyhøch jaꞌa nDeedy tøø xwyiinguex̱y cooc̈h nhóꞌogät, cooc̈h njujypiǿgät. ");
INSERT INTO mirNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Coo Jesús jaduhṉ miädiaacy, paadiä judíoshajxy tuꞌugmädiaꞌagy quiaꞌa nibiaatä. ");
INSERT INTO mirNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mänit hajxy nämay miänaaṉ̃: ―Møjcuꞌudaꞌa miøød. Cuhmäñøøbiädaꞌa jaduhṉ. Tii yøꞌø miädiaꞌagy hajxy coo mmädow̱aaṉä. ");
INSERT INTO mirNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mänit hajxy näjeꞌe miänaaṉ̃: ―Cabä møjcuꞌumøødpä jaduhṉ miädiáꞌagät. Cabä møjcuꞌu jaꞌa wiindspä jaduhṉ yaghijxǿꞌøgät. ");
INSERT INTO mirNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jájtäbä xøø hänajty jim̱ Jerusalén, jaꞌa xøhajpä jaꞌa Dedicación. Tøøchpojjooty hänajty. ");
INSERT INTO mirNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jiibiä Jesús hänajty wiädity tsajtøgooty, jiiby maa jaꞌa tøjwiingän, jaꞌa xøhajpä Salomón. ");
INSERT INTO mirNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mänitä judíoshajxy jim̱ yhamugøøyy maa Jesús hänajty wiäditiän. Mänitä Jesús ñämaayyä: ―Mänaa højts xyhawaaṉaaṉä pø tøyhajt mMesíashaty. ");
INSERT INTO mirNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mänitä Jesús yhadsooyy: ―Tøøds mijts nja hawáaṉäm, pero cab hajxy mmäbøjcy. Cooc̈h jaduhṉ ngudiuṉ̃ nébiøch jaꞌa nDeedy tøø xyhaneꞌemiän, cähxǿꞌpøch jaduhṉ cooc̈h nGristohaty. ");
INSERT INTO mirNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero, cooc̈h mijts jaꞌa nmädiaꞌagy hajxy xquiaꞌa panøcxä, páadyhøch jaꞌa nmädiaꞌagy hajxy xquiaꞌa mäbøgaaṉä. ");
INSERT INTO mirNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nhix̱yhájpiøch pǿṉhøch jaꞌa nmädiaꞌagy xmiäbǿjcäp; jeꞌec̈h jaꞌa nmädiaꞌagy xpianǿcxäp. ");
INSERT INTO mirNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nyajnøcxáam̱biøch hajxy jim̱ tsajpootyp. Jim̱ hajxy yhidaꞌañ cøjxtaꞌaxiøø. Cábøch hajxy jeꞌe pøṉ xpiǿjcät. ");
INSERT INTO mirNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Miǿødhøch jaꞌa nDeedy jaꞌa mäjaa. Cabä pøṉ jaꞌa mäjaa jaduhṉ miøødä nébiøch jaꞌa nDeedy miøødän. Jaꞌa nDéedyhøch jaduhṉ tøø miänaꞌañ cooc̈h jaayaꞌay jaꞌa nmädiaꞌagy hajxy xmiäbǿjcät. Cábøch jaꞌa nDeedy jaayaꞌayhajxy mänaa piøgáaṉaxä. ");
INSERT INTO mirNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Høøc̈h mǿødhøch jaꞌa nDeedy, tuꞌugmädiaꞌagy højts nhity. ");
INSERT INTO mirNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mänitä judíoshajxy tiägǿøguiombä tsaagonøꞌpä. Jesús hajxy hänajty quiaꞌadsaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mänitä Jesús jaꞌa judíos ñämaayy: ―Madiúꞌujøch jaꞌa hoybä tøø ngudiuṉ̃ nébiøch jaꞌa nDeedy tøø xyhaneꞌemiän. Tiiguiǿxpøch mijts coo xquiaꞌadsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mänit hajxy yhadsooyy: ―Paady højts miic̈h ngaꞌadsaꞌañ coo Dios haxøøg mnänøm̱y, coo mnibiädaꞌagyii nebiä Diosän; caꞌa jieꞌeguiøxpä coo hodiuuṉg jaduhṉ tøø mduṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mänitä Jesús yhadsooyy: ―Jiiby jaduhṉ myiṉ̃ maa mijts mguhdujtän coo Dios jaduhṉ miänaaṉ̃: “Mdioshajp hajxy.” ");
INSERT INTO mirNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tøyhajt jaꞌa Diosmädiaꞌagy jaduhṉ ñäꞌägädä mädiaꞌagy. Jaduhṉ miänaꞌañ cooc hajxy jaduhṉ dyioshaty, jaꞌa jäyaꞌayhajxy tøø wyiingpǿquiäbä jaꞌa Diosmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Hoora, Dióshøch tøø xquiunuuꞌxy tøø xpiädaꞌagy. Yaac̈h tøø xquiex̱y hädaa yaabä naax̱wiin. Cábøch Dios tøø nwiingapxpety cooc̈h nmänaaṉ̃ cooc̈hä Dios xyHuunghaty. Tøyhájthøch jaduhṉ xyHuunghaty. ");
INSERT INTO mirNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Cooc̈h häxøpy ngaꞌa tuṉ̃ nébiøch jaꞌa nDeedy tiuṉ̃än, cábøc̈hä nmädiaꞌagy hajxy häxøpy xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero jaanc̈h túum̱bøch jaduhṉ. Mmäbǿgäp hajxy jaduhṉ cooc̈hä Dios tøø xquiex̱y, hóyhøc̈hä nmädiaꞌagy hajxy xquiaꞌa ja mäbøjcä. Jaduhṉds hajxy mnajuǿøñät coo højts tuꞌugjäyaꞌay nhity mǿødhøc̈hä nDeedy. ");
INSERT INTO mirNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mänitä Jesús jia madsáaṉägumbä. Pero cabä ñäꞌä yajmajch. ");
INSERT INTO mirNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mänitä miøjnøønájxcumbä jaꞌa Jordángpä møjnøøbä maa jaꞌa Juan miäyajnäbejtsohṉ̃än. ");
INSERT INTO mirNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mänitä Jesús hajxy ñämejch nämay. Mänit hajxy miänaaṉ̃: ―Cabä Juan jaꞌa hoy‑yagjuøøñäbäjaty ñäꞌä yajcähxøꞌcy. Pero tøyhajt jaduhṉ cøx̱iä nebiä Juan yøꞌøyaꞌay tøø ñägapxiän. ");
INSERT INTO mirNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mänitä Jesús jaꞌa miädiaꞌagy hajxy jim̱ miäbøjcä nämay. ");
INSERT INTO mirNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tuꞌug jäyaꞌay hänajty xiøhaty Lázaro. Tøø hänajty piaꞌambety. Jim̱ hänajty chänaꞌay Betania møødä piuhdoꞌoxyhajxy, jaꞌa María møødä Marta. ");
INSERT INTO mirNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Cahnä hänajty yhabaady mänaa María jaꞌa Jesús jaꞌa perfume hänajty yajtecytiaꞌxøꞌøwaꞌañ, mänaa María jaꞌa Jesús hänajty tiecymieꞌexaꞌañ jaꞌa quiuhwaayhaam. ");
INSERT INTO mirNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Coo Lázaro hänajty tøø piaꞌambety, mänitä piuhdoꞌoxy jaꞌa capxy hajxy quiejxy maa Jesúsän coogä Lázaro tøø piaꞌambety. Jesús jaꞌa miäguꞌughajpä hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Coo Jesús jaꞌa mädiaꞌagy jaduhṉ miädooyy, mänit miänaaṉ̃: ―Cabä mähdiøjc tiehm̱ yhoꞌogaꞌañ. Paady tøø piaꞌambety neby jaduhṉ quiähxǿꞌøgät coo Dios miøjjä jiaanc̈hä, neby jaduhṉ quiähxǿꞌøgät cooc̈h nmøjjä njaanc̈hä. Dióshøch xyHuunghajp. ");
INSERT INTO mirNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Hoy jaꞌa Jesús hänajty jia jaanc̈h tehm̱ miøødnijiootpaadyii jaꞌa Lázarohajxy, ");
INSERT INTO mirNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","mejtsxøø jim̱ jiaag hijty maa hänajty ñäꞌägä hitiän. ");
INSERT INTO mirNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mänitä Jesús jaꞌa jiamiøød ñämaayy: ―Jam̱ds hajxy jadähooc Judea. ");
INSERT INTO mirNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mänitä Jesús hajxy ñämaayy: ―Wiindsǿṉ, cahnä jiegøꞌøy mänaa jaꞌa judíoshajxy xjia cuhgaꞌadsaꞌañän. Tii jim̱ coo mnøcxtägatsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Mänitä Jesús yhadsooyy: ―Jaꞌa Diostuuṉg hajxy tuum̱bä, coo jaꞌa tiuuṉghajxy jeꞌe quiaꞌa mayñä, cahnä hajxy jeꞌe yhoꞌogaꞌañ. Jaduhṉ mäwíinäts hajxy jeꞌe nebiä xøømbä tiuꞌuyoꞌoyän. Cab hajxy jeꞌe quiuhnepy. Hoy hajxy jeꞌe yhix̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mänitä miänáaṉgombä: ―Tøø højts nmäguꞌughajpä Lázaro miaahóꞌcäm. Nøcxáam̱bøch cham̱ nyuxaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mänitä jiamiøødhajxy miänaaṉ̃: ―Pero, wiindsǿṉ, pø näꞌä maahoꞌc jaduhṉ, møcpøjtägatsaam̱bädaꞌa jaduhṉ, cabä. ");
INSERT INTO mirNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Coo Jesús jaduhṉ miänaaṉ̃ cooc Lázaro miaahoꞌcy, jaduhṉ hänajty miänaꞌanaaṉ̃ cooc tøø yhoꞌogy. Pero cabä jiamiøødhajxy jaduhṉ wyiinjuøøyy coo Lázaro tøø yhoꞌogy. Jaduhṉ hajxy wyiinjuøøyy coo tøø miaahoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mänitä Jesús howyiinjuøøñä tiehm̱ ñägapxnä: ―Tøø jaꞌa Lázaro yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Xooṉdáacpøch jaduhṉ cooc̈h hänajty ngaꞌa jim̱ä. Coo hajxy jaduhṉ mhixaꞌañ nébiøch ndunaꞌañän, mänítøch mijts jaꞌa nmädiaꞌagy xmiaas mäbøgaaṉä. Páadyhøch jaduhṉ nxooṉdaꞌagy. Jam̱ds hajxy jim̱ maa Lázarän. ");
INSERT INTO mirNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tuꞌugä Jesús jaꞌa jiamiøød hänajty xiøhaty Tomás, jaꞌa hajxy hänajty ñänøøm̱biä hametsc‑huung. Mänitä Tomás ñämaayy jaꞌa jiamiøødhajxy: ―Jam̱xä Jesús hajxy møødhóꞌcäm. ");
INSERT INTO mirNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Coo hajxy jim̱ miejch Betania, mänitä Jesús yhawáaṉäxä coo jaꞌa Lázaro hänajty jiiby tøø yhity mädaax̱xøø jutjooty maa cabäsaantän. ");
INSERT INTO mirNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mäwiingóṉ Betania hänajty jim̱ Jerusalén. Jaduhṉdaꞌa jiäguem̱a, mejtskilómetro ja cupcädaꞌa. ");
INSERT INTO mirNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nämay jaꞌa judíoshajxy hänajty tøø ñämech jaꞌa Marta møødä María. Capxmøcpøgáaṉäp hajxy hänajty coo jaꞌa piuhyaꞌayhajxy hänajty tøø yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Coo jaꞌa Marta jaduhṉ miädoyhajty coo Jesús hänajty miäwiingoṉ̃, mänit hoy jiøjcubaadøꞌøy. Pero María, jiiby miähmøøyy maa jaꞌa tiøgootyhajxiän. ");
INSERT INTO mirNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mänitä Marta jaꞌa Jesús ñämaayy: ―Wiindsǿṉ, coo häxøpy myaajä, cábøc̈hä nbuhyaꞌay häxøpy tøø yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nnajuǿøbiøch jaduhṉ, hoytyiijä Dios mmäyujwáꞌanät, xmióꞌowäp jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mänitä Jesús jaꞌa Marta ñämaayy: ―Jujypiøgaam̱bä mbuhyaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mänitä Marta miänaaṉ̃: ―Nnajuǿøbiøch coo jiujypiøgaꞌañ coo jaꞌa naax̱wiimbä hänajty wyiimbidaꞌañ, coo hajxy nägøx̱iä njujypiøgáaṉäm. ");
INSERT INTO mirNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Mänitä Jesús miänaaṉ̃: ―Nyagjujypiøgáam̱biøch hajxy jeꞌe pønjátyhøch jaꞌa nmädiaꞌagy xmiäbǿjcäp. Nyajnøcxáam̱biøch hajxy jeꞌe jim̱ tsajpootyp, hoy hajxy hänajty jia jujcyñä, hoy hajxy hänajty tøø jia hoꞌogy. Nejy, mmäbøjpy jaduhṉä. ");
INSERT INTO mirNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mänitä Marta miänaaṉ̃: ―Wiindsǿṉ, nmäbǿjpiøch coo miic̈h jaꞌa Dios xyHuunghaty, coo mMesíashaty, coo miic̈h jaꞌa Dios tøø xquiex̱y hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mänitä Marta jaꞌa piuhdoꞌoxy hameeꞌch hoy ñämaꞌay: ―Tøø jaꞌa nWiindsøṉhájtäm miéjtsäm. Miic̈h xyajtøøb. ");
INSERT INTO mirNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Coo jaꞌa María miädooyy, mänitiä tiänaayyøꞌcy. Mänitä María jaꞌa Jesús ñänøcxy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jim̱ä Jesús hänajty tøø miähmøꞌøy maa jaꞌa Marta hänajty hoy tøø miøødmädiaꞌaguiän. Cahnä Jesús hänajty quiajptägøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jaꞌa judíoshajxy hänajty jiiby maa jaꞌa María tiøgootyhajxiän, coo hajxy yhijxy coo María tiänaayyøꞌcy, coo tiøjpädsøøm̱y, mänitä María hajxy piadøjpädsøøm̱y. Jim̱ tyijy María hänajty ñøcxy cabäsaantä jøøbiä xuuꞌtspä. ");
INSERT INTO mirNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Coo jaꞌa María jim̱ miejch maa jaꞌa Jesús hänajty tøø miähmøꞌøyän, mänitä Jesús yhijxy. Mänitä María jaꞌa Jesús wyiinjijcädaacy. Mänitä María miänaaṉ̃: ―Wiindsǿṉ, coo miic̈h häxøpy myaajä, cábøc̈hä nbuhyaꞌay häxøpy tøø yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Coo Jesús jaduhṉ yhijxy coo María hänajty jiøꞌøy møødä judíoshajxy, jaꞌa hänajty tøø piamec̈híijäbä, mänitä Jesús jiootmabiøjcy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mänit miänaaṉ̃: ―Maa hajxy tøø myajnaax̱tägøꞌøy. Mänitä Jesús ñämaayyä: ―Wiindsǿṉ, jam̱ nyajnähixøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mänitä Jesús jiøøyy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mänitä judíoshajxy miänaaṉ̃: ―Høxtahm̱ds jiøꞌøy coo Lázaro hijty jiaanc̈h tehm̱ miøødnijiootpaadyii. ");
INSERT INTO mirNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mänit hajxy näjeꞌe miänaaṉ̃: ―Tisän yøꞌøyaꞌay jaꞌa Lázaro coo quiaꞌa yajmøcpøjcy. Tøø yøꞌøyaꞌay jaꞌa wiindspä yaghijxøꞌøgy, túhm̱äts. ");
INSERT INTO mirNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mänitä Jesús jiootmabiǿjcombä. Mänit jim̱ ñøcxy maa jaꞌa naax̱jutän maa jaꞌa Lázaro hänajty tøø ñaax̱tägøꞌøyän. Jim̱ä tsaa jaꞌa jut hänajty yhadäguec‑haty. ");
INSERT INTO mirNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Mänitä Jesús ñämaayy jaꞌa hajxy hänajty jim̱ tänaabiä juthaguum: ―Hadäguejtuꞌud yøꞌø jut hajxy. Jim̱ä cuhäyohnd hänajty tiänaabiä, jaꞌa Martahajpä. Mänitä Marta jaꞌa Jesús ñämaayy: ―Wiindsǿn, pero mädaax̱xøø jiiby tøø yhity jutjooty. Haxøøgxuuꞌpädaꞌa yøꞌøjän. ");
INSERT INTO mirNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mänitä Jesús jaꞌa Marta ñämaayy: ―Tøøc̈h miic̈h nhawáaṉäm, coo mmäbǿgät, mänit mhíxät coo Dios miøjjä jiaanc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mänitä jut hajxy jiaanc̈h yhadäguejtuuty. Mänitä Jesús chajheeꞌpy. Mänit miänaaṉ̃: ―Teedy, Dioscujúꞌuyäp cooc̈h miic̈h jaꞌa nmädiaꞌagy tøø xmiädoow̱a. ");
INSERT INTO mirNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nnajuǿøbiøch jaduhṉ cooc̈h miic̈h jaꞌa nmädiaꞌagy hoymiänaajä xmiädoow̱a. Páadyhøch miic̈h tøø nnämaꞌay “Dioscujúꞌuyäp” neby hajxy miäbǿgät cooc̈h miic̈h tøø xquiex̱y, yøꞌøyaꞌayhajxy xii tänaabiä. ");
INSERT INTO mirNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mänitä Jesús møc yaax̱y: ―¡Lázaro, pädsǿm̱äts! ");
INSERT INTO mirNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mänitä Lázaro jiaanc̈h pädsøøm̱y, jaꞌa hänajty tøø yhóꞌoguiäbä. Nähbity nähmoch piädsøøm̱y. Mänitä Jesús ñämaayy jaꞌa hajxy hänajty jim̱ tänaabiä: ―Nähbijtuꞌud yøꞌø hajxy. Ween ñøcxy maa jaꞌa tiøjcän. Mänitä Lázaro hajxy jiaanc̈h nähbijtuuty. Mänit ñøcxy maa jaꞌa tiøjcän. ");
INSERT INTO mirNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mänitä Jesús jaꞌa miädiaꞌagy miäbǿjcäxä nämay jaꞌa judíoshajxy, jaꞌa María hajxy hänajty tøø miøødhítiäbä maa jaꞌa tiøjc‑hajxiän, jaꞌa hajxy hänajty tøø yhíx̱iäbä coo jaꞌa Jesús jaꞌa hoꞌogyjiäyaꞌay yagjujypiøjcy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero cab judíos hajxy näjeꞌe miäbøjcy. Paady jaꞌa fariseos hajxy hoy yhawaaṉä nebiä Jesús hänajty tøø tiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mänitä teedywiindsøṉhajxy yhamugøøyy møødä fariseoshajxy møødä tuuṉgmøødpähajxy. Mänit hajxy ñiñämaayyä: ―Neby hajxy nwiinmahñdyhájtämät. Madiuꞌu jaayaꞌay jaꞌa hoy‑yagjuøøñäbäjaty tøø yajcähxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Coo hajxy ngaꞌa májtsämät, mänitä miädiaꞌagy miäbøgáaṉäxä nägøx̱iä. Minaam̱bä romano jäyaꞌayhajxy jaꞌa møjcuhdujtmøødpä. Mänitä ndsajtøjc hajxy xyajmaꞌadáaṉäm. Mänitä nguhdujt hajxy xpiøgáaṉäm. ");
INSERT INTO mirNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Caifás jaꞌa teedywiindsǿṉ hänajty xiøhaty jaꞌa møjcuhdujtmøødpä. Mänit miänaaṉ̃: ―Cab hajxy tii mjaty mnajuøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Cab hajxy mwiinjuøꞌøy coo maas hoy hit jaduhṉ coo jaꞌa cuꞌug tuꞌjäyaꞌay xñähhoꞌtúutämät. Cab hajxy jaduhṉ nägøx̱iä nguhdägóoyyämät. ");
INSERT INTO mirNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caꞌa Quiaifás jaꞌa yhamdsoo wiinmahñdy jaduhṉ. Pero coo hänajty tiuṉ̃ teedywiindsǿṉ møjcuhdujtmøødpä, paadiä Dios jaꞌa Caifás jaduhṉ yajnägapxy coo jaꞌa Jesús jaꞌa judíos hänajty ñähhoꞌtuꞌudaꞌañ, ");
INSERT INTO mirNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","møød hajxy nägøx̱iä, jaꞌa Dios hänajty tøø wyiimbíyyäbä, jaꞌa wiinghagajptjatypä. ");
INSERT INTO mirNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mänitä møjcuhdujtmøødpähajxy quiojyquiapxyhajty coo Jesús hajxy hänajty yaghoꞌogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Paadiä Jesús hänajty jim̱ quiaꞌa wäditaaṉnä mayjiäyaꞌayhagujc maa jaꞌa Israelpähajxiän. Mänitä Jesúshajxy jim̱ chohṉ̃ jim̱ Judea, ñøcxy hajxy jim̱ maa jaꞌa cajpt jaduhṉ xiøhatiän Efraín. Jim̱ä Jesúshajxy miähmøøyy møødä jiamiøødhajxy. Mäwiingóṉ jaꞌa cajpt hänajty tøꞌødsnähgäp. ");
INSERT INTO mirNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Habaadáaṉnäp jaꞌa pascuaxøø hänajty, jaꞌa judíoshajxy yagjájtäbä. Nämay hajxy jim̱ ñøcxy xøøhajpä jim̱ Jerusalén, jaꞌa hajxy jim̱ tsohm̱bä maa jaꞌa cajpthuungän. Cahnä xøø hänajty jim̱ chohṉdaꞌagy coo hajxy jim̱ quiooꞌty. Jayøjp hajxy hänajty yhuuc tsiꞌiwaꞌañ. Jadúhṉäc tyijy hajxy hänajty ñähwaꞌadsaꞌañ jaꞌa piojpä quiädieey. ");
INSERT INTO mirNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jiibiä Israelpäjäyaꞌay jaꞌa Jesús hajxy hänajty yajcopcøꞌøy tsajtøgooty. Jiiby hajxy hänajty ñimiäyajtøyii: ―Nej, cabä Jesúsädaꞌa miedsaꞌañ xøøhájpäjä. ");
INSERT INTO mirNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tøø jaꞌa teedywiindsøṉhajxy hänajty yhaneꞌemy møødä fariseoshajxy, coo Jesús pøṉ yhíxät, mänit hajxy ñägápxät, nebiä Jesús hajxy jaduhṉ miádsät. ");
INSERT INTO mirNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ja tädujxøø jaꞌa pascuaxøø hänajty quiaꞌa habaady. Mänitä Jesús jim̱ ñøcxy Betania, maa Lázaro hänajty chänaꞌayän, jaꞌa Jesús hänajty tøø yagjujypiǿquiäbä coo hänajty tøø yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nämayyä jäyaꞌayhajxy jiiby yhamugøøyy tsuugaabiä jaꞌa Jesúscøxpä. Jaꞌa Marta hänajty tex̱yhabøgøøby. Jiibiä Lázaro jaꞌa Jesús hänajty miøødtsuugay tøgooty. ");
INSERT INTO mirNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mänitä María jaꞌa perfume quioṉmejch cuplitro. Haagä nardopøjy jaꞌa perfume hänajty jaꞌa tsow̱jatypä. Mänitä María jaꞌa Jesús yajtecytiaꞌxøøyy jaꞌa perfume. Mänitä María jaꞌa Jesús tiecymieex̱y quiuhwaayhaam. Mänitä perfume tiägøøyy puꞌxøꞌpä tøgooty. ");
INSERT INTO mirNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jiibiä Judas hänajty, jaꞌa Simón Iscariote yhuung. Jesús jaꞌa jiamiøød hänajty jeꞌebä. Jeꞌedsä Jesús hänajty yegaam̱b coo hänajty yajcøꞌødägøꞌøwaꞌañii maa jaꞌa soldadohajxiän. Mänitä Judas miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Maas hoy hijty coo yøꞌø perfume cu ndóoꞌcäm nebiä häyoobädøjc jaꞌa xädøꞌøñ cu nnäꞌä móoyyäm. ");
INSERT INTO mirNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero cabä Judas jaꞌa häyoobädøjc hänajty ñäꞌägädä näxuuc̈h. Jeꞌe jaꞌa xädøꞌøñ hänajty yajcoṉwädíjtäp. Pero hamdsoo hänajty wyiꞌi yajpädsøm̱y. Paady jaduhṉ miänaaṉ̃ coo jaꞌa perfume hajxy cu tiooꞌcy nebiä xädøꞌøñ jaduhṉ miéedsät. ");
INSERT INTO mirNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mänitä Jesús jaꞌa Judas ñämaayy: ―Ween yøꞌø toꞌoxiøjc yhity. Caꞌa waam̱b mnämaꞌay. Ween yøꞌø perfume yaghity høxtä cóonøch nhóꞌogät. Mänítøch yøꞌø perfume xyajnähjáaxät. ");
INSERT INTO mirNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Hoymiänaajä mijts jaꞌa häyoobädøjc xmiøødhidaꞌañ. Pero høøc̈h, cábøch mijts hajxy jejcy nmøødhidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nämayyä Israelpä jäyaꞌayhajxy miädoyhajty coogä Jesús hänajty jim̱ tøø miech Betania. Mänitä Jesús hajxy hoy yhix̱y møødä Lázaro, jaꞌa Jesús hänajty tøø yagjujypiǿquiäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Coo Jesús jaꞌa Lázaro hänajty tøø yagjujypiøcy, paadiä Israelpä jäyaꞌay jaꞌa Jesús hajxy hänajty tøø piaduꞌubøcy nämay. Y paadiä Jesús jaꞌa miädiaꞌagy hajxy hänajty tøø miäbǿjcäxä nämay. Coo jaꞌa teedywiindsǿṉ jaꞌa miädiaꞌagyhajxy hänajty quiaꞌa jaty panǿcxäxä, paady hajxy quiojyquiapxytiuuṉ̃ coo jaꞌa Lázaro hajxy ween yaghoꞌogy nebiä Jesús hajxy hänajty yaghoꞌogaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nämayyä jäyaꞌayhajxy hänajty jim̱ tøø miech Jerusalén pascuaxøøhajpä. Cujaboom hajxy miädoyhajty coo jaꞌa Jesús hänajty miedsaꞌañ cajptooty. ");
INSERT INTO mirNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mänitä xiꞌiwhaay hajxy hoy piux̱y. Mänitä Jesús hajxy hoy jiøjcubaadøꞌøy xiꞌiwhaaguiap. Yáax̱äp jaꞌa Jesús hajxy hänajty ñänøcxy: ―¡Viva Jesús! Tsøc yøꞌøyaꞌay hajxy wiingudsähgǿøyyäm, yøꞌø Dios tøø quiéx̱iäbä. Paadiä Dios tøø quiex̱y coo hajxy ngobiernähájtämät, højts jaꞌa Israelpäjäyaꞌayhájtäm. ");
INSERT INTO mirNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mänitä Jesús jaꞌa burrohuung tuꞌug piaaty. Mänit yajpejty. Jaduhṉ jiiby myiṉ̃ cujaay maa jaꞌa Diosmädiaꞌaguiän: ");
INSERT INTO mirNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Caꞌa hajxy mdsähgøꞌøy, mijts jim̱ tsänaabiä Jerusalén. Huug hix̱ hajxy, xiidsä mgobiernähajxy piety burrohuungnähgøxp. ");
INSERT INTO mirNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Cabä Jesús jaꞌa jiamiøødhajxy hänajty ñajuøꞌøy pøṉ jaduhṉ ñänøøm̱by coo miedsaꞌañ burrohuungnähgøxp, jaꞌa Dios quiexaam̱biä. Pero cujecy, coo Jesús hänajty tøø jiujypiøjnä, coo hänajty tøø ñøcxnä tsajpootyp, mänitä jiamiøødhajxy jiahmiejtstaacnä coo jaduhṉ jiaanc̈h miṉ̃ cujaay jaꞌa Jesúscøxpä y coo Jesús hajxy hänajty tøø piuhbety. ");
INSERT INTO mirNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mädiaacp hajxy hänajty neby hajxy hänajty jim̱ tøø yhix̱y mänaa Jesús jaꞌa Lázaro jiiby yhøxyaax̱pädsøm̱iän tsaajutjooty. Jaꞌa hajxy hänajty tøø quiaꞌa yhíx̱iäbä, jeꞌeds hajxy hänajty miøødmädiaacypy. ");
INSERT INTO mirNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Coo jaduhṉ yajmädoyhajty nebiä Jesús jaꞌa Lázaro hänajty tøø yagjujypiøquiän, paadiä Jesús hajxy hänajty nøcxy jiøjcubaadøꞌøy mayjiäyaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mänitä fariseoshajxy ñiñämaayyä: ―Nejy yøꞌøyaꞌay ndúuṉämät coo jaduhṉ piawädityii nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tøø jaꞌa caꞌa Israelpähajpähajxy hänajty näjeꞌe quiooꞌpä xøøhajpä. Dioswiingudsähgøøbiä hajxy hänajty tøø quioody. ");
INSERT INTO mirNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mänitä Felipe hajxy hoy ñämech. Betsaida Felipe hänajty chooñ jim̱ Galileanaaxooty. Mänitä Felipe ñämaayyä: ―Tsäguhm̱, maa jaꞌa Jesús. Jeꞌeds højts nja møødmädiaꞌagaaṉ. ");
INSERT INTO mirNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mänitä Felipe jaꞌa Andrés hoy yhawaaṉä coogä Jesús hajxy hänajty hoy tøø jia møødmädiaꞌagaꞌañ. Mänitä Felipe jaꞌa Jesús hajxy hoy yhawaaṉdägajtsä møødä Andrés. ");
INSERT INTO mirNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mänitä Jesús miänaaṉ̃: ―Tøø yhabaady cooc̈h nhóꞌogät. Páadyhøch Dios tøø xquiex̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, coo jäyaꞌay jaꞌa trigo hajxy ñiꞌiby, mänitä tøømd tyictspädsøm̱y yhaabiädsøm̱y. Coo jaduhṉ tyictspädsǿm̱ät yhaabiädsǿm̱ät, mänit hoy tiägøøñä yeeꞌpä. Mayøꞌøb jaꞌa trigo jaduhṉ. Pero coo quiaꞌa tictspädsǿm̱ät quiaꞌa haabiädsǿm̱ät, jaduhyyä piúꞌudsät. Cabä miúxät. Cabä trigo miayøꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Pønjátyhøc̈hä nmädiaꞌagy xquiaꞌa mäbøgáaṉäp, cab hajxy jim̱ ñǿcxät tsajpootyp. Páadyhøc̈hä nmädiaꞌagy hajxy xquiaꞌa mäbøgaaṉä coo hajxy chähgøꞌøy coo hajxy yaghoꞌogaꞌañii. Pønjátyhøc̈hä nmädiaꞌagy xmiäbǿjcäp, jeꞌeds hajxy jim̱ nøcxaam̱b tsajpootyp, hoy hajxy jia yaghoꞌogyii jaꞌa høøc̈hcøxpä. ");
INSERT INTO mirNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pø xWyiindsøṉhadáam̱bøch hajxy jeꞌe, wéenhøc̈hä nmädiaꞌagy hajxy xpianøcxä. Nwow̱hídäbøch hajxy jeꞌe. NDéedyhøch pädaꞌagaam̱b coo hajxy wyiingudsähgøꞌøwøød wiingjäyaꞌaybä. ");
INSERT INTO mirNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Jootmayhájpøch cham̱. Cab jaduhṉ yhahixøꞌøy cooc̈hä nDeedy nnämáꞌawät ween xyajtsoꞌogy cooc̈h hänajty yaa nhoꞌogaꞌañ hädaa yaabä naax̱wiin. Páadyhøch yaa tøø ngädaꞌagy cooc̈h yaa nhǿꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Teedy, yajcähxøꞌøg jaꞌa mmäjaa. Mänitä Dios jim̱ yhadsooyy tsajpootyp: ―Tøøc̈h tähooc nyajcähxøꞌøgy. Nyajcähxøꞌøgáam̱biøch jadähooc. ");
INSERT INTO mirNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jaꞌa hajxy hänajty jim̱ tänaabiä nämay maa jaꞌa Jesús jaꞌa wyiinduumän, jia mädoow̱ hajxy, pero cab hajxy wyiinjuøøyy. Näjeꞌe hajxy miänaaṉ̃ cooc tyijy hänee yaax̱y. Näjeꞌe hajxy miänaaṉ̃ cooc tyijy jaꞌa Dios jaꞌa mioonsä jim̱ tsajpootyp tuꞌug quiapxy. ");
INSERT INTO mirNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mänitä Jesús miänaaṉ̃: ―Caꞌa yhøøc̈hcøxpä jaꞌa Dios jaduhṉ miänaaṉ̃. Paady jaduhṉ miänaaṉ̃ nej mijts mnajuǿꞌøwät cooc̈h jaduhṉ xmiägapxy. ");
INSERT INTO mirNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cooc̈h nhóꞌogät, cábøch jaꞌa møjcuꞌugong nyajmäjädaꞌagaꞌañ, jaayaꞌay hanehm̱bä hädaa yaabä naax̱wiin. Dios jaduhṉ mänaam̱b coo hajxy ween yajcumädoy, jaꞌa høøc̈hä nmädiaꞌagy hajxy xquiaꞌa mäbǿjcäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Høøc̈h, cooc̈h nyajmøjpahbédät cruzcøxp, mäníthøc̈hä nmädiaꞌagy hajxy xmiäbøgaaṉä, jaꞌa hajxy tsänaabiä wiinduhm̱yhagajpt. ");
INSERT INTO mirNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Paadiä Jesús jaduhṉ miänaaṉ̃, neby hajxy ñajuǿꞌøwät neby hänajty yaghoꞌogaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mänitä Jesús ñämaayyä: ―Jiiby jaduhṉ myiṉ̃ maa højts nguhdujtän coo jaayaꞌay hänajty yhaneꞌemaꞌañ mayjiomøjt, jaꞌa Dios quiexaam̱biä, jaꞌa højts nhahijxypä. Pero miic̈h jaduhṉ mänaam̱b coo tsipcøxp jaꞌa Diosquex̱ypä yajmøjpahbedaꞌañ cruzcøxp. Pøṉ miic̈h jaduhṉ mnänøøm̱by jaꞌa Diosquex̱ypä. ");
INSERT INTO mirNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","36","Mänitä Jesús miänaaṉ̃: ―Cábøch mijts hajxy jejcy nmøødhidaꞌañ. Jaduhṉ mäwíinhøch mijts ngudøøꞌxy nebiä jøønän. Mäbǿjcägøch jaꞌa nmädiaꞌagy hajxy, mädúhṉ̃tiøch hädaa yaabä naax̱wiin nhídät, nébyhøch mijts jaduhṉ hoy xpianǿcxät, neby hajxy mgaꞌa hídät hagoodstuum. Pøṉ hajxy jaduhṉ hijp hagoodstuum, tägodiuum hajxy ñäꞌägädä hity. Høøc̈h, nøcxáaṉnäbøch. Cábøch jaꞌa nmädiaꞌagy hajxy xmiädow̱áaṉänä. Coo jaꞌa Jesús jaduhṉ miädiaacpädøøyy, mänitä tiuꞌubøjnä. Mänit ñiguiuꞌtsä. ");
INSERT INTO mirNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Cabä Jesús jaꞌa miädiaꞌagy hänajty miäbøgáaṉäxä, hoy hänajty madiuꞌu hoy‑yagjuøøñäjaty tøø jia yajcähxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Paady hajxy hänajty quiaꞌa mäbøgaꞌañ nebiä profeta Isaías jaꞌa miädiaꞌagy jaduhṉ tiøjiádät, nebiä jecy quiujahyyän: Dios, cab højts jaꞌa nmädiaꞌagy pøṉ tøø xmiäbøjcä. Tøø jaꞌa mmäjaa mja yajcähxøꞌøgy, pero cab hajxy tøø xmiøjpädaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Cabä Jesús jaꞌa miädiaꞌagy miäbøgáaṉäxä nebiä Isaías wiingtuum quiujahyyän: ");
INSERT INTO mirNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Tøø jaꞌa Dios miänaꞌañ: Tøøc̈hä quiopc‑hajxy nyajxejxä nébyhøc̈hä nmädiaꞌagy hajxy xquiaꞌa wiinjuǿøyyät, nebiä yhaxøøgwiinmahñdy hajxy quiaꞌa najtshixǿꞌøwät. Cábøch jaꞌa piojpä quiädieey hajxy nyajnähwáatsät. ");
INSERT INTO mirNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jaduhṉä Isaías jecy quiujahy nebiä Isaías jaꞌa Jesús hänajty tøø yhix̱iän tsajpootyp. Cahnä Jesús hänajty yaa quiädaꞌagy hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Siémpräm jaꞌa Israelpä jäyaꞌay jaꞌa Jesús jaꞌa miädiaꞌagy hajxy miäbøjcä, møødä copc‑hajpähajxy nämay. Pero hameeꞌch hajxy miäbøjcy. Cabä Jesús hajxy hänajty quiapxpaady mayjiäyaꞌayhagujc. Tsähgøøby hajxy hänajty coo hajxy yajpädsøm̱øød maa jaꞌa chajtøjc‑hajxiän jaꞌa fariseoshajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jaꞌa judíoshajxy, cab hajxy chocy coo hajxy quiumayøød jaꞌa Dios. Jeꞌe hajxy chojpy coo hajxy ween wyiingudsähgøꞌøyii jaꞌa cuꞌug. ");
INSERT INTO mirNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mänitä Jesús møc miänaaṉ̃: ―Pǿṉhøch jaꞌa nmädiaꞌagy xmiäbǿjcäp, jaanä xmiäbǿjcäbøc̈hä nDeedy jaꞌa miädiaꞌagy hajxypä, jaꞌac̈h yaa tøø xquiéx̱iäbä hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Pǿṉhøch jaduhṉ xyhijxp, jaanä xyhíjxäbøc̈hä nDeedy hajxypä. ");
INSERT INTO mirNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Páadyhøch yaa tøø ngädaꞌagy hädaa yaabä naax̱wiin, neby hajxy quiaꞌa mähmǿꞌøwät hagoodstuum pønjátyhøch nmädiaꞌagy hajxy xmiäbǿjcäp. Jaduhṉ mäwíinhøch ngudøøꞌxy nebiä jøønän neby hajxy hoy yhíxät. ");
INSERT INTO mirNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Caꞌa yhøøc̈hä hajxy nyajcumädow̱aam̱by, jaꞌa nmädiáꞌagyhøch hajxy xquiaꞌa mäbǿjcäbä, hoy hajxy jaduhṉ tøø jia mädoyhaty. Páadyhøch yaa tøø ngädaꞌagy hädaa yaabä naax̱wiin, nébyhøch jaꞌa jäyaꞌayhajxy jaduhṉ nnähhoꞌtúꞌudät. Caꞌa yhøøc̈hä hajxy jeꞌe nyajcumädow̱aam̱by. ");
INSERT INTO mirNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pǿṉhøc̈hä nmädiaꞌagy hajxy xquiaꞌa mäbǿjcäp, mänit hajxy quiumädow̱aꞌañ coo jaꞌa naax̱wiimbä hänajty wyiimbidaꞌañ. Paady hajxy quiumädow̱aꞌañ, cooc̈hä nmädiaꞌagy hajxy hänajty tøø xquiaꞌa mäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Caꞌa yhøøc̈hä nhamdsoo mädiaꞌagy jaduhṉ tøø nyaghity. Jaꞌa nDéedyhøch, jaꞌac̈h tøø xquiéx̱iäbä, jeꞌec̈h jaduhṉ tøø xyhaneꞌemy nebiátyhøch nmädiáꞌagät. ");
INSERT INTO mirNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Høøc̈hä, nmǿødhøch jaꞌa tøyhajt jaduhṉ coo hajxy jim̱ yhidaꞌañ tsajpootyp cøjxtaꞌaxiøø, pønjátyhøch jaꞌa nDeedy jaꞌa miädiaꞌagy mäbǿjcäp. Nmädiáacypiøch nébyhøc̈hä nDeedy tøø xyhaneꞌemiän. ");
INSERT INTO mirNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mänitä pascuaxøø hänajty tiehm̱ yhadsuujøꞌøy. Tøø jaꞌa Jesús hänajty ñajuøꞌøy coo hänajty tøø yhabaady coo hänajty yaa choonaaṉnä hädaa yaabä naax̱wiin, coo hänajty jim̱ ñøcxaaṉnä maa jaꞌa Tieediän. Chojpy jaꞌa Jesús jaꞌa jiamiøød hänajty hamuumduꞌjoot hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Coo jaꞌa Jesúshajxy hänajty chuugayaꞌañ, tøø Judas hänajty wyiinmahñdyhaty, jaꞌa Simón Iscariote yhuung, coo Jesús hänajty yajcøꞌøwaaṉøꞌøwaꞌañii maa jaꞌa soldadohajxiän. Jaꞌa møjcuꞌugong jaꞌa Judas jaduhṉ yajwiinmahñdiägooyy. ");
INSERT INTO mirNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ñajuøøbiä Jesús hänajty nebiaty jaꞌa cuhdujt hänajty tøø mioꞌoyii jaꞌa Tieedy. Ñajuøøby hänajty coo hänajty jim̱ tøø chooñ maa jaꞌa Tieediän, coo hänajty jim̱ ñøcxáaṉgombä jadähooc. ");
INSERT INTO mirNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Coo hajxy hänajty tøø chuugaabiädøøñä, mänitä Jesús tiänaayyøꞌcy. Mänitä wyit chijy. Mänitä cuhbeꞌen tuꞌug yajnimiox̱mäguitøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mänitä nøø quiudemøøyy palanganajooty. Mänitä Jesús tiägøøyy tecypiujpä jaꞌa jiamiøød. Coo tiecypiujpädøøyy, mänit tiecymiéex̱combä. ");
INSERT INTO mirNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Coo jaꞌa Jesús jaꞌa Simón Pedro hänajty tiecypiujaꞌañ, mänitä Simón Pedro miänaaṉ̃: ―Nej, xtiecypiujáam̱bøch hǿøc̈hpäjä. ");
INSERT INTO mirNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mänitä Jesús yhadsooyy: ―Miic̈h, caj miic̈h mnajuøꞌøy tiiguiǿxpøch miic̈h coo ndecypiujy. Mänit jaduhṉ mnajuøꞌøwaꞌañ cooc̈h jaduhṉ njádät nhabétät. ");
INSERT INTO mirNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Mänitä Pedro miänaaṉ̃: ―Cab jaduhṉ yhahixøꞌøy cooc̈h miic̈h jaduhṉ xtiecypiújät. Mänitä Jesús yhadsooyy: ―Pø cájtäm miic̈h myajtecypiujaꞌañ, cájtämøch miic̈h hoy xjiamiøødhadaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mänitä Simón Pedro miänaaṉ̃: ―Bueno, Wiindsǿṉ, cǿx̱iøch jaduhṉ xpiújät mǿødhøc̈hä ndecy, mǿødhøc̈hä ngøꞌø, mǿødhøc̈hä ngopc. ");
INSERT INTO mirNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Mänitä Jesús yhadsooyy: ―Pøṉ tøø chiꞌiy, waꞌads jaꞌa ñiꞌx jaꞌa quiopc jeꞌe. Jagoo jaꞌa tiecy piújät. Mijts, mwaꞌads mijts hajxy, pero cab hajxy nägøx̱iä mwaꞌadsä. ");
INSERT INTO mirNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ñajuøøbiä Jesús hänajty pøṉ hänajty yajcøꞌøwaaṉøꞌøwáaṉäp. Paady jaduhṉ miänaaṉ̃ coo tuꞌjäyaꞌay hänajty quiaꞌa waꞌadsä. ");
INSERT INTO mirNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Coo jaꞌa Jesús cøjx tiecypiujpädøꞌøy jaꞌa jiamiøødhajxy, mänitä Jesús wyitpägøøñä. Mänit yhøxtaacnä. Mänit miänaaṉ̃: ―Chójpiøc̈hä njoot jaduhṉ coo hajxy mnajuǿꞌøwät tiiguiǿxpøch mijts coo tøø ndecypiujy. ");
INSERT INTO mirNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hoy jaduhṉ cooc̈h mijts jaduhṉ xñämaꞌay: “Wiindsǿṉ.” Tøyhájthøch mijts hajxy jaduhṉ xWyiindsøṉhaty. ");
INSERT INTO mirNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tøøc̈h mijts hajxy ndecypiujy, hóyhøch Wiindsǿṉ nja tuṉ̃. Jaanä jaduhṉ mijtspä, mnidiecypiujøøb hajxy hamiṉ̃ haxøpy. ");
INSERT INTO mirNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mbahíxäp hajxy jaduhṉ nebiátyhøch mijts tøø nduṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, cabä moonsä cuhdujt møc miøødä quejee jaꞌa wyiindsǿṉ. Jaanä jaduhṉ jeꞌebä jaꞌa tøø quiexyíijäbä, cabä cuhdujt jeꞌe møc miǿødäbä quejee jaꞌa tøø miäguéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Cooc̈hä nmädiaꞌagy hajxy xwyiinjuǿøyyät, coo hajxy jaduhṉ mgudiúnät, jootcujc hajxy jaduhṉ mhídät. ");
INSERT INTO mirNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Cábøch mijts nägøx̱iä nnägapxy. Nnajuǿøbiøch pønjátyhøch tøø nwiimbiy. Pero tøjiajpä Diosmädiaꞌagy maa jaduhṉ miänaꞌañän: “Jaꞌa craac̈h tuꞌugmucy xmiøødcaabiä, tøøc̈h jeꞌe xmiädsibøꞌøy.” ");
INSERT INTO mirNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jäguém̱iøch mijts chaa nhawáaṉäm cooc̈h haxøøg njadaꞌañ nhabetaꞌañ. Cooc̈h jaduhṉ njaanc̈h jádät njaanc̈h habétät, mänit hajxy mhuuc mäbǿgät cooc̈hä Dios tøyhajt tøø xjiaanc̈h quex̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, pøṉ hajxy mäguꞌugpøgaam̱b jaꞌac̈h nguexaam̱biä, møød høøc̈h jaduhṉ xmiäguꞌugpøgaam̱bä. Jaanä jaduhṉds jeꞌebä, pǿṉhøch jeꞌe xmiäguꞌugpøgaam̱b, møødä Dios jaduhṉ miäguꞌugpøgaam̱bä, jaꞌac̈h tøø xquiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Coo jaꞌa Jesús miädiaacpädøøñä, mänit jiootmadiägøøñä. Mänit miänaaṉ̃: ―Chaads mijts tehm̱ tiøyhajt nnämáꞌawät cooc̈h mijts jaꞌa mjamiøød tuꞌug xyegaꞌañ hoꞌcøøc. ");
INSERT INTO mirNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mänitä jiamiøødhajxy ñiwyiinheeꞌppejtä. Cab hajxy hänajty ñajuøꞌøy pøṉ jaꞌa Jesús hänajty jaduhṉ ñänøøm̱by. ");
INSERT INTO mirNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jim̱ä Jesús jaꞌa jiamiøød hänajty yhäñaꞌay tiehm̱ ñähmøjc. Jaanc̈h tehm̱ yhoy jaꞌa Jesús hänajty miøødnijiootpaadyii. ");
INSERT INTO mirNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mänitä Simón Pedro jaꞌa craa miäwøꞌxy. Mänit hameeꞌch ñämaayy: ―Huuc mäyajtøw̱ pøṉ jaduhṉ ñänøøm̱by. ");
INSERT INTO mirNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mänitä craa jaꞌa Jesús tiaatsmägowøøyy. Mänit miäyajtøøyy: ―Pøṉ jaduhṉ mnänøøm̱by. ");
INSERT INTO mirNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Mänitä Jesús yhadsooyy: ―Nbamaꞌtsnaxáam̱biøch hädaa tsajcaagyhaguijt. Mänítøch jaꞌa craa nmoꞌowaꞌañ, jaꞌac̈h xyegaam̱bä hoꞌcøøc. Mänitä Jesús jaꞌa tsajcaagyhaguijt jiaanc̈h pamaꞌtsnajxy. Mänitä Judas yajcøꞌøgonøøyy, jaꞌa Simón Iscariote yhuung. ");
INSERT INTO mirNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tuuṉä Judas jaꞌa tsajcaagy ñäꞌä cooṉdsooyy, mänitiä miøjcuꞌujoottägøøyyä. Mänitä Jesús jaꞌa Judas ñämaayy: ―Tsógäm. Nøcx jatcøꞌøw nejy mjatcøꞌøwaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jaꞌa hajxy hänajty jim̱ caabiä, cab hajxy hänajty ñajuøꞌøy tiiguiøxpä Jesús jaduhṉ coo miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Näjeꞌe hajxy hänajty wyiinmahñdyhaty coo tyijy jaꞌa Jesús jaꞌa Judas hänajty quiex̱y juubiä mädyiijaty tyijy hänajty yajtunaam̱by xøøjooty. Näjeꞌe hajxy hänajty wyiinmahñdyhajpä coo tyijy Jesús jaꞌa Judas jaꞌa häyoobäyaꞌay hänajty yajmoꞌowaꞌañ xädøꞌøñ. Paady hajxy hänajty wyiinmahñdyhaty, coo jaꞌa Judas jaꞌa xädøꞌøñ hänajty yajwijtswädityii. ");
INSERT INTO mirNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tuuṉä Judas jaꞌa tsajcaagy ñäꞌä cooṉdsooyy, mänitiä tiøjpädsøøm̱y. Tøø hänajty quioodsøøñä. ");
INSERT INTO mirNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Coo jaꞌa Judas tiøjpädsøøm̱y, mänitä Jesús miänaaṉ̃: ―Tøø yhabaady cooc̈h ngähxøꞌøgaꞌañ cooc̈h nmøjjä njaanc̈hä. Høøc̈hcøxpä Dios jaduhṉ quiähxøꞌøgaꞌañ coo miøjjä jiaanc̈hä. Dióshøch tøø xwyiinguex̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nyajcähxøꞌøgáam̱biøch jaꞌa Dios coo miøjjä jiaanc̈hä. Mobädájpøch jaꞌa Dios xyajcähxøꞌøgaam̱bä cooc̈h nmøjjä njaanc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mäguꞌughajpädøjc, cábøch mijts jejcy nmøødhidaꞌañ. Xjia høxtaꞌawáam̱bøch mijts, pero cábøch hajxy xpiaadaꞌañ. Chaads mijts hajxy nnämáꞌawät nébyhøc̈hä Israelpä jäyaꞌayhajxy tøø nnämaꞌayän: Cab hajxy jim̱ hoy mnǿcxät maac̈h nhidaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Chaads mijts hajxy jaꞌa hawiinjem̱yguiuhdujt nmóꞌowät coo hajxy hamiṉ̃ haxøpy mnic̈hogøød nébyhøch mijts ndsoquiän. ");
INSERT INTO mirNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Coo hajxy mnic̈hogøød mnibiaꞌhäyowøød, cähxǿꞌøgäp jaduhṉ cooc̈h mijts jaꞌa nmädiaꞌagy xjiaanc̈h panøcxä. Xyhíxäp jaꞌa jäyaꞌayhajxy jii nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mänitä Simón Pedro jaꞌa Jesús miäyajtøøyy: ―Wiindsǿṉ, maa mnøcxaꞌañ. Mänitä Jesús yhadsooyy: ―Cábøch miic̈h jadunajtä hoy xpianǿcxät maac̈h nnøcxaꞌañän. Miic̈h, høx̱haam miic̈h mnǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Mänitä Pedro jaꞌa Jesús miäyajtǿøgumbä: ―Tiic̈h miic̈hädaꞌa jadunajtä hoy coo ngaꞌa panǿcxät. Nnähhoꞌtúꞌudäbøch miic̈h häyaa. ");
INSERT INTO mirNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mänitä Jesús yhadsooyy: ―Jaanc̈hä; cabä ndijy miic̈hädaꞌa xñähhoꞌtúꞌudät. Chaads miic̈h jadunajtä nnämáꞌawät, cahnä tseey hänajty yaꞌaxyñä, tøø miic̈h hänajty tägøøghooc mnijiøgapxyii cooc̈h tyijy miic̈h hänajty xquiaꞌa hix̱iä. ");
INSERT INTO mirNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Mänitä Jesús miänaaṉ̃: ―Caꞌa hajxy mwiꞌi tiajy mwiꞌi miay. Mäbøjcä jaꞌa Dios jaꞌa miädiaꞌagy hajxy, y mäbǿjcägøch jaꞌa nmädiaꞌagy hajxypä. ");
INSERT INTO mirNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Jim̱ tsajpootyp maac̈hä nDeediän, mayyä tsänaꞌawøhñdy jim̱. Coo häxøpy quiaꞌa tøyyä, cab hajxy cu nhawáaṉäm. Nøcxáam̱bøch jaꞌa tsänaꞌawøhñdy nbädaꞌagaꞌañ nähix̱ hahixøꞌø maa mijts mhídät. ");
INSERT INTO mirNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Cooc̈h jim̱ nnøcxaꞌañ, cädaactägatsáam̱bøch jadähóocägumbä. Mänítøch mijts jim̱ ngøx̱y woonøcxaꞌañ maac̈h nhidaꞌañän. Näguipxy hajxy jim̱ nhidáaṉäm. ");
INSERT INTO mirNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mnajuøøby hajxy maac̈h nnøcxaꞌañ. Jaduhṉ hajxy mnajuøøbiä neby hajxy jim̱ mnǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mänitä Tomás jaꞌa Jesús ñämaayy: ―Wiindsǿṉ, pero cab højts nnajuøꞌøy maa miic̈h mnøcxaꞌañ. Neby højts jaduhṉ jim̱ nnäꞌä nǿcxät. ");
INSERT INTO mirNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Mänitä Jesús yhadsooyy: ―Jaduhṉ mäwíinhøch høøc̈h nebiä tuꞌujän. Høøc̈hcøxpä hajxy jim̱ mgoodaꞌañ pønjátyhøch jaꞌa nmädiaꞌagy xmiäbǿjcäp. Høøc̈hcøxpä hajxy jim̱ mhidaꞌañ cøjxtaꞌaxiøø. Paady hajxy jim̱ mhidaꞌañ cooc̈hä tøyhajt nyajcähxøꞌøgy jaꞌa Dioscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Pønjátyhøch jeꞌe xyhix̱yhajp, jaanä xyhix̱yhájtäbøch jaꞌa nDeedy jeꞌebä. Tøø hajxy mhix̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pero cab hajxy wyiinjuøøyy waam̱bä Jesús jaduhṉ jia mänaaṉ̃. Mänitä Felipe jaꞌa Jesús ñämaayy: ―Wiindsǿṉ, ween højts jaꞌa mDeedy xyhuuc yaghíxät. Mänit højts jootcujc nmähmǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Mänitä Jesús yhadsooyy: ―Felipe, tii jaduhṉ coo mmänaꞌañ. Tøøc̈h miic̈h jejcy xpiawädity. Xyhix̱yhájpøch miic̈h jaduhṉ. Pøṉc̈h xyhijxp, jaanä xyhíjxäbøch jaꞌa nDeedy jeꞌebä. Tiic̈h miic̈h jaduhṉ coo xñämaꞌay cooc̈h mijts jaꞌa nDeedy nyaghíxät. ");
INSERT INTO mirNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nej, cab jaduhṉ mmäbøquiä cooc̈hä nDeedy tuꞌugmädiaꞌagy nmøødhity. Jaꞌa nDéedyhøch miädiaꞌagy, jeꞌec̈h jaduhṉ nmädiáacäp; caꞌa yhøøc̈hä nhamdsoo mädiaꞌagy nmädiaacypy. Jaꞌa nDéedyhøch jaꞌa mäjaa jaduhṉ xmiooby; jeꞌec̈h jaꞌa tiuuṉg jaduhṉ ndúuṉäp. ");
INSERT INTO mirNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mäbǿjcägøch jaꞌa nmädiaꞌagy hajxy cooc̈hä nDeedy jaduhṉ tuꞌugmädiaꞌagy nmøødhity. Hoy hajxy mwiinjuøꞌøy mgaꞌa ja wiinjuøꞌøy, mmäbǿgäp hit hajxy jaduhṉ. Páadyhøch hit hajxy jaꞌa nmädiaꞌagy xmiäbǿjcät, cooc̈h hoy‑yagjuøøñäjatypä nyajcähxøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Chaads mijts tehm̱ tiøyhajt nnämáaguiombä, pǿṉhøch jaꞌa nmädiaꞌagy xmiäbǿjcäp, jaanä yajcähxøꞌøgaam̱by jeꞌebä jaꞌa hoy‑yagjuøøñäjaty. Maas hoy‑yagjuøøñäjatypä jeꞌe yajcähxøꞌøgaꞌañ quejeec̈h nyajcähxøꞌøgy. Paady jaduhṉ yajcähxøꞌøgaꞌañ cooc̈h jim̱ nnøcxaꞌañ maac̈hä nDeediän. ");
INSERT INTO mirNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","14","Coo hajxy mmäbǿgät cooc̈h jaꞌa cuhdujt tøyhajt nmøødä, coo hajxy hänajty tii myujwaꞌanaꞌañ, ngudiúnäbøch jaduhṉ neby jaduhṉ quiähxǿꞌøgät cooc̈hä nDeedy jeꞌeduhṉ miøjjä jiaanc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Pø xchójpøch mijts, mänítøch mijts jaꞌa nmädiaꞌagy xquiudiúuṉät nebiátyhøch mijts tøø nmägapxy tøø nhaneꞌemiän. ");
INSERT INTO mirNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nnämáabiøch jaꞌa nDeedy coo mijts jaꞌa jootcapxmøcpøjpä wiingpä xyajnäguéxät, jaꞌa tømiädiaacpä. Jaꞌa Dioshespíritu jeꞌe. Cøjxtaꞌaxiøø hajxy jaduhṉ xmiøødhidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Pønjaty jaꞌa Diosmädiaꞌagy caꞌa mäbøjp, cabä Dioshespíritu hajxy chogaꞌañ. Cab hajxy mänaa yhix̱yhadaꞌañ. Pero mijts, mobädajpä hajxy jeꞌe mhix̱yhadaꞌañ. Xmiøødhidáaṉnäp hajxy jeꞌe. Jiiby hajxy mmøødhadaꞌañ mjoodootyhajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Cábøch mijts jeꞌe nnähgueꞌegaꞌañ nidiuhm̱ nämetsc. Cädaactägatsáam̱bøch yaa jadähooc maa mijtsän. ");
INSERT INTO mirNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mejtsxøø tägøøgxøøc̈h jaꞌa jäyaꞌayhajxy xjiaag hixaꞌañ. Cábøch hajxy hänajty yaa xyhixaaṉnä cooc̈h yaa ndsoonaaṉnä. Cooc̈h cøjxtaꞌaxiøø nhidaꞌañ, paady mijts cøjxtaꞌaxiøø mhidaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mobädajpä hajxy jaduhṉ mnajuøꞌøwaꞌañ cooc̈hä nDeedy tuꞌugmädiaꞌagy nmøødhity. Jaanä tuꞌugmädiaꞌagy hajxy jaduhṉ nhidáaṉämbä. ");
INSERT INTO mirNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Pønjátyhøch jaꞌa nmädiaꞌagy xquiudiúuṉäp nébiøch tøø nmägapxy tøø nhaneꞌemiän, xchójpøch jeꞌe. Jaanä ndsojpy højts jeꞌebä mǿødhøch jaꞌa nDeedy. Nyaghixáam̱biøch jaꞌa nwiinmahñdy hajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jii Jesús jaꞌa jiamiøød hänajty tuꞌug xiøhaty Judas. Pero caꞌa jeꞌe yhIscariote. Mänitä Judas jaꞌa Jesús miäyajtøøyy: ―Wiindsǿṉ, tii højts jaꞌa mwiinmahñdy coo xyaghixaꞌañ, pero cabä cuꞌughajxy myaghixaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mänitä Jesús yhadsooyy: ―Pǿṉhøch xchojp, xquiudiúuṉäbøch jaꞌa nmädiaꞌagy jeꞌe. Y chójpiøc̈hä nDeedy jeꞌebä. Tuꞌugmädiaꞌagy højts nmøødhidaꞌañ mǿødhøch jaꞌa nDeedy. ");
INSERT INTO mirNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pǿṉhøch jaduhṉ xquiaꞌa tsojp, cábøc̈hä nmädiaꞌagy xyajtuuṉä. Caꞌa yhøøc̈hä nhamdsoo mädiaꞌagy hädaa, hädaa hajxy nyajmøødmädiaacypiä. Jaꞌa nDéedyhøch miädiaꞌagy hädaa, jaꞌac̈h tøø xquiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Mijts, nyajmøødmädiáacypiøch mijts jaduhṉ mäduhṉ̃tiä hajxy yaa nmøødhitiän. ");
INSERT INTO mirNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nägóoyyøch nnøcxaaṉnä nduꞌubøgaaṉnä, mänítøch jaꞌa nDeedy yhEspíritu quiexaꞌañ maa mijtsän. Jeꞌec̈h jaduhṉ nguwitshadaam̱by. Mijts jaduhṉ xjiootcapxmøcpøgaam̱b. Cøxaam̱b hajxy xyajnähixøꞌøwaꞌañ. Cøxaam̱b hajxy xyagjahmiejtstaꞌagaꞌañ nebiátyhøch mijts yaa tøø nyajmøødxiꞌigy tøø nyajmøødmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Jootcújc‑høch mijts nyajmähmøꞌøwaꞌañ. Cab mijtsä cuꞌug xyagjootcugǿꞌøwät nébiøch mijts jootcujc tøø nyaghitiän. Caꞌa hajxy tii mnädajy mnämay. Caꞌa hajxy mdsähgøꞌøy mdsähdiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tøøc̈h mijts nhawáaṉäm cooc̈h nnøcxaꞌañ nduꞌubøgaꞌañ. Pero cädaactägatsáam̱bøch jadähooc. Pø xchójpøch mijts tøyhajt, mxooṉdáꞌagäp hajxy coo nhawáaṉäm cooc̈h jim̱ nnøcxaꞌañ maac̈hä nDeediän. Miaas møødä mäjaa jeꞌe quejeec̈h nmøødä. ");
INSERT INTO mirNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tøøc̈h mijts jäguem̱iä nhawáaṉäm nébiøch yaa njadaꞌañ hädaa yaabä naax̱wiin y cooc̈h jim̱ nnøcxaaṉnä maac̈hä nDeediän. Cooc̈h jaduhṉ njádät, cooc̈h jim̱ nnǿcxät, mänit hajxy mhuuc tehm̱ miäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Tuꞌhabáquiøch mijts nhuuc jaac møødmädiaꞌagyñä. Medsaam̱bä møjcuꞌugong, jaꞌa yaa cuꞌughanehm̱bä; pero cabä cuhdujt miøødä maac̈h høøc̈hcøxpän. ");
INSERT INTO mirNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ngudiunáaṉnäbøch nébiøch jaꞌa nDeedy tøø xmiägapxy tøø xyhaneꞌemiän. Páadyhøch jaduhṉ ngudiunaꞌañ neby jaduhṉ quiähxǿꞌøgät cooc̈hä nDeedy tøyhajt njaanc̈h tsocy. Tänaayyøꞌøg hajxy. Jam̱ hajxiän. ");
INSERT INTO mirNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Høøc̈h, jaduhṉ mäwíinhøch høøc̈h nebiä tsaatyptequiän jaꞌa tøyhajtpä. Jaꞌa nDéedyhøch, jaduhṉ jeꞌe nebiä cudsaatypcam̱än. ");
INSERT INTO mirNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jaꞌa nDéedyhøch, xyhøxpújxäbøch jaꞌa nhaads mädyii caꞌa tøømbejp; pero mädyiids jaduhṉ tøømbejp, jeꞌeds jaduhṉ weenjaty yhøxpujxyp, nebiä maas majiaty tiøømbédät. ");
INSERT INTO mirNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Coo hajxy jaduhṉ tøø mmäbøcy nebiátyhøch mijts jeꞌe tøø nyajnähixøꞌøyän, jadúhṉhøch jaꞌa nDeedy mijts tøø xyajnähwaꞌac̈h jaꞌa mhaxøøgwiinmahñdyhajxy. Jaduhṉ mäwíinäts jeꞌe nebiä tsaatyp hajxy jiøjpux̱iän. ");
INSERT INTO mirNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tehṉgájnøch jaꞌa nmädiaꞌagy hajxy xpianǿcxät; tehṉgájnøch mijts nbuhbedaꞌañ. Jaꞌa tsaatyphaads, cab jeꞌe tiøømbedaꞌañ coo jaꞌa yhøjxä tiecy hänajty quiaꞌa hity. Jaduhṉ mäwíinäts mijtspä, pø cábøch jaꞌa nmädiaꞌagy hajxy tehṉgajnä xpianøcxaaṉä, cab hajxy hoy mwädítät. ");
INSERT INTO mirNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Høøc̈h, jaduhṉ mäwíinhøch høøc̈h nebiä tsaatyptequiän. Høøc̈h mijts jaduhṉ nhaadshajpy. Cooc̈hä nmädiaꞌagy hajxy tehṉgajnä xpianǿcxät, mänit hajxy hoy mwädítät. Nbuhbédäbøch mijts jaduhṉ. Cooc̈h mijts ngaꞌa puhbédät, cab hajxy tii hoy mdunaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pǿṉhøc̈hä nmädiaꞌagy xquiaꞌa panǿcxäp, jaduhṉ mäwíinäts jeꞌe nebiä tsaatyphaads hajxy yhøxpux̱iän. Coo jaduhṉ tiøꞌøc̈h, mänit hajxy yajpädøꞌøgy; mänit hajxy ñoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Cooc̈hä nmädiaꞌagy hajxy tehṉgajnä xpianǿcxät, coo hajxy mgaꞌa jahdiägóyyät nebiátyhøch mijts tøø nyajnähixøꞌøy, ngudiúnäbøch jaduhṉ mädyiibäjaty mijts xmiäyujwaꞌanaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Coo hajxy hoy mwädítät, cähxǿꞌøgäp jaduhṉ cooc̈hä nmädiaꞌagy hajxy tøyhajt xpianøcxä. Jaanä cähxøꞌøgaam̱b jaduhm̱bä cooc̈hä nDeedy jeꞌe miøjjä jiaanc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","10","Nébiøc̈hä nDeedy xchoquiän, jadúhṉhøch mijts ndsojpä. Cooc̈hä nmädiaꞌagy hajxy xyajtúuṉät, ngumáyäbøch mijts jaduhṉ; hoy miänáajøch mijts ndsógät. Jadúhṉhøc̈hä nDeedy xchocy cooc̈hä miädiaꞌagy nyajtúuṉäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Páadyhøch mijts jaduhṉ nyajmøødxiꞌigy nyajmøødmädiaꞌagy coo hajxy tehṉgajnä mxooṉdáꞌagät nébiøch nxooṉdaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Míjtshøch jaduhṉ nmägapxyp nhanehm̱by coo hajxy hamiṉ̃ haxøpy mnic̈hogøød mnibiaꞌhäyowøød nébiøch mijts ndsoquiän. ");
INSERT INTO mirNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Pøṉ jaduhṉ jaanc̈h tehm̱ chójcäp, coo hänajty yaghoꞌogaꞌañii, nähhoꞌtuꞌudøøb jeꞌe jaꞌa miäguꞌughajpä. ");
INSERT INTO mirNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Coo hajxy mgudiúnät nebiátyhøch mijts tøø nmägapxy tøø nhaneꞌemy, xmiäguꞌughájpøch mijts hänajty jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Cábøch mijts nnämaꞌawaaṉnä “moonsä.” Jaꞌa moonsä, cabä ñajuøꞌøy tii jaꞌa wyiindsǿṉ tiuum̱by. Pero mijts, tøø mijts ngøx̱y hawáaṉäm nebiátyhøch jaꞌa nDeedy jeꞌe tøø xyhawaaṉä. Páadyhøch mijts nnämaꞌawaaṉnä “mäguꞌughajpä.” ");
INSERT INTO mirNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Caꞌa yhøøc̈h mijts jeꞌe tøø xwyiimbiy; høøc̈h mijts jeꞌe tøø nwiimbiy. Tøøc̈h mijts jaduhṉ nwiinguex̱y coo hajxy hoy mwädítät, coo Diosmädiaꞌagy hajxy myajwáꞌxät, neby hajxy jaduhṉ mmayǿꞌøwät. Weenä Diosmädiaꞌagy hajxy tehṉgajnä pianøcxpä; ween hajxy hoy wiädijpä. Jadúhṉhøch mijts nDeedy xmióꞌowät tijaty mijts hänajty mdsogaam̱by, cooc̈hä nmädiaꞌagy hajxy hänajty xmiäbøjcä. ");
INSERT INTO mirNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Chám̱høch mijts jadähooc nmägapxy nhaneꞌemy coo hajxy mnic̈hogøød mnibiaꞌhäyowøød hamiṉ̃ haxøpy. ");
INSERT INTO mirNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Mijts, xmiähaṉhadaam̱b jaꞌa tsaan jaꞌa cuꞌug hajxy. Moorä høøc̈h hajxy tøø xmiähaṉhajpä. ");
INSERT INTO mirNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Xmiähaṉhadaam̱b mijts jeꞌe, jaꞌa hajxy haxøøgwädijpä. Paady mijts xmiähaṉhadaꞌañ coo mijts jaꞌa haxøøgpä tøø mgøx̱y najtshixøøñä. Tøø mijts jaꞌa mbojpä mgädieey nyajnähwáatsäm. Coo mijts häxøpy tøø mgaꞌa najtshixøꞌøy jaꞌa haxøøgpä, cu xmiäguꞌughajty jäyaꞌay hajxy may. ");
INSERT INTO mirNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Huuc jahmiets hajxy nejy mijts tøø nnämaꞌayän, cabä moonsähajxy quiuhdujtmøød quejee wyiindsøṉhajxy. Cooc̈hä jäyaꞌayhajxy näjeꞌe xmiädsiphaty, paady mijts hajxy xmiädsiphadaam̱bä. Y cooc̈hä nmädiaꞌagy hajxy näjeꞌe xmiäbøjcä, paady mijts jaꞌa mmädiaꞌagy hajxy xmiäbøgáaṉäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Høøc̈hcøxpä mijts jaꞌa cuꞌug xmiädsiphadaꞌañ, jeꞌeguiøxpä cooc̈hä nDeedy hajxy xquiaꞌa hix̱yhajtä, jaꞌac̈h tøø xquiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tøøc̈h jäyaꞌay jaꞌa nmädiaꞌagy hajxy hoy nyajmädoyhaty. Cooc̈hä nmädiaꞌagy hajxy tøø xquiaꞌa mäbøjcä, paady hajxy quiumädow̱aꞌañ. Cooc̈hä nmädiaꞌagy hajxy häxøpy tøø xquiaꞌa mädoyhajtä, cab hajxy häxøpy quiumädow̱aꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pǿṉhøch xmiähaṉhajp, jadúhṉhøc̈hä nDeedy xmiähaṉhájtäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tøøc̈hä hoy‑yagjuøøñäjatypä nyajcähxøꞌøgy. Caj pøṉ jaduhṉ yajcähxøꞌøgy hädaa yaabä naax̱wiimbä. Hoy jäyaꞌayhajxy tøø jia hix̱y tøø jia mädoy, xmiähaṉhajp højts mǿødhøc̈hä nDeedy. Paady hajxy jeꞌe quiumädow̱aꞌañ. Cooc̈hä hoy‑yagjuøøñäjatypä häxøpy tøø ngaꞌa yajcähxøꞌøgy, cab hajxy häxøpy quiumädow̱aꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Cooc̈hä jäyaꞌayhajxy xmiähaṉhaty, tøjiajp jaduhṉ nebiä Diosmädiaꞌagy myiṉ̃än, neby hajxy jecy quiujahyyän: “Pues, näꞌä nägóobøch hajxy xmiähaṉhaty.” ");
INSERT INTO mirNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Nguexáam̱biøch jaꞌa Dioshespíritu, jaꞌa mijts xjiootcapxmøcpøgaam̱bä, jaꞌa tømiädiaacpä. Jim̱ jaduhṉ choonaꞌañ maac̈hä nDeediän. Coo quiädaꞌagaꞌañ, mänítøch jeꞌe xñägapxaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jadúhṉhøch mijts xñägapxaam̱bä, nebiátyhøch mijts yaa tøø nmøødwädity. Høxtáhm̱dsøc̈hä jäyaꞌayhajxy nyajnähixøøc̈hooñän, quípxyhøch mijts nmøødtägøøyy wädijpä høxtä jädaꞌanäbaadyñä. ");
INSERT INTO mirNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Páadyhøch mijts cham̱ nyajmøødxiꞌigy nyajmøødmadiaꞌagy, cooc̈h mijts jaꞌa nmädiaꞌagy ni mänaa xquiaꞌa najtshixǿøyyät, hoy mijts jäyaꞌay mäduhṉ̃tiä xjia mädsiphaty xjia mähaṉhaty. ");
INSERT INTO mirNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Xyajpädsøm̱aam̱b mijts jeꞌe tsajtøgooty. Høxtä habaadaam̱b jaduhṉ coo mijts xyaghoꞌogaꞌañ jeꞌeguiøxpä cooc tyijy jaꞌa Diosmädiaꞌagy hajxy quiudiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Paady mijts jeꞌe xmiädsiphadaꞌañ coo højts jeꞌe xquiaꞌa hix̱iä mǿødhøc̈hä nDeedy. ");
INSERT INTO mirNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Coo hajxy jaduhṉ mjádät mhabétät, mänit hajxy jaduhṉ mjahmiédsät coo hajxy nhawáaṉäm. Paady cham̱ nhawáaṉäm. ’Cooc̈h mijts hijty quipxy nmøødwädity, paady hajxy hijty ngaꞌa hawáaṉäm. ");
INSERT INTO mirNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nøcxáaṉnäbøch jim̱ maac̈hä nDeediän, jaꞌac̈h tøø xquiéx̱iäbä. Jím̱høch nhidaaṉnä. Pero cábøch mijts xmiäyajtøy maac̈h nnøcxaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mjootmayhajp mijts jaduhṉ cooc̈h mijts jaduhṉ tøø nyajmøødmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, hoyøꞌøwaam̱b jaduhṉ mijtscøxpä cooc̈h nnøcxaꞌañ. Nguexáam̱biøch pøṉ mijts xjiootcapxmøcpøgaam̱b. Cooc̈h ngaꞌa nǿcxät, cab jaduhṉ quiädáꞌagät maa mijtsän. ");
INSERT INTO mirNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","9","Tsipcøxp jaduhṉ ñäꞌägä cädaꞌagaꞌañ. Mänitä jäyaꞌayhajxy yajwiinjuøꞌøwaꞌañii coo pojpä cädieey hajxy tøyhajt jiaanc̈h møødä. Paady hajxy miøødä, cooc̈hä nmädiaꞌagy hajxy tøø xquiaꞌa mäbøjcä. Paady hajxy yajcumädow̱aꞌañii jaꞌa Diósäm. ");
INSERT INTO mirNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Jaduhṉ hajxy yajwiinjuøꞌøwáaṉäbä cooc̈h jaꞌa pojpä cädieey ngaꞌa møødä. Nøcxáam̱bøch jim̱ maac̈hä nDeediän; cábøch mijts yaa xyhixaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Jaduhṉ hajxy yajwiinjuøꞌøwáaṉäbä coo hajxy yajcumädow̱aꞌañii jaꞌa Diósäm, pønjaty jaꞌa møjcuꞌugong jaꞌa miädiaꞌagy panǿcxäp, jaꞌa yaa hanehm̱bä hädaa yaabä naax̱wiin. Tøø jaꞌa Dios miänaꞌañ coo jaꞌa møjcuꞌugong quiumädow̱aꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Madiuꞌu mijts nja hawaaṉáaṉäm, pero cab hajxy mwiinjuǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Coo jaꞌa Dioshespíritu hänajty quiädaꞌagaꞌañ, mänit mijts jaꞌa tøyhajt xquiøx̱y yajwiinjuøꞌøwaꞌañ. Caꞌa yhamdsoo mädiaꞌagy jeꞌe miädiaꞌagaam̱by. Piamädiaꞌagaam̱by jaduhṉ nebiaty jeꞌe tøø miädoy. Jeꞌe mijts xyajmädoyhadaam̱b tijaty jadaaṉ tunáaṉäp. ");
INSERT INTO mirNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Xñägapxáam̱bøch jeꞌe cooc̈h nmøjjä njaanc̈hä. Mijts xyajmädoyhadaam̱b nebiátyhøch jeꞌe tøø nnämaꞌayän. ");
INSERT INTO mirNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Coo højts nhity tuꞌugmädiaꞌagy mǿødhøc̈hä nDeedy, páadyhøch mijts cham̱ nnämaꞌay coo mijts jaꞌa Dioshespíritu xyajmädoyhadaꞌañ nebiátyhøch jeꞌe tøø nnämaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Mobädájpøch jim̱ nnøcxaaṉnä maac̈hä nDeediän. Pero cábøch njegaꞌañ; mänítøch mijts hänajty xyhijxtägatsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mänitä Jesús jaꞌa jiamiøødhajxy näjeꞌe ñiñämaayyä: ―Pätiidä yøꞌøyaꞌay jaduhṉ coo ñäꞌä mänaꞌañ cooc mobädajpä ñøcxaaṉnä; cábäc jaduhṉ jiegaꞌañ. Mänítäc nhixáaṉägombä. Pätiidä coo ñäꞌä mänaꞌañ cooc ñøcxaꞌañ maa jaꞌa Tieediän. ");
INSERT INTO mirNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Pätiidä coo ñäꞌä mänaꞌañ “mobädajpä.” Päwaam̱btä jaduhṉ jia mänaꞌanaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ñajuøøbiä Jesús hänajty coo hänajty miäyajtøwaꞌañii. Mänit miänaaṉ̃: ―Xmiäyajtøwáam̱bøch mijts tijátyhøch jaduhṉ tøø nja mädiaꞌagy, túhṉämäts. ");
INSERT INTO mirNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, mjøꞌøwaam̱b mxuudsaam̱b mijts jaꞌa høøc̈hcøxpä. Pero yøꞌø cuꞌughajxy, jaanc̈h tehm̱ xiooṉdaꞌagaam̱b hajxy. Pero cab hajxy jejcy mjootmayhadaꞌañ. Paquiä hajxy mjootcugøꞌøwáaṉgombä. ");
INSERT INTO mirNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Coo jaꞌa toꞌoxiøjc jaꞌa xiøøbioꞌohajxy piedyii, mänitä jioothajxy piädøꞌøgøꞌøgy. Nägooyyä jaꞌa yhuunghajxy jeꞌe miejtsnä, hagädaacp jaꞌa jioothajxy jeꞌe. Cab hajxy jeꞌe jiahmiejtsnä coo jaꞌa jioothajxy hänajty tøø piädøꞌøgy. Xooṉdáacnäp hajxy coo yhuunghajxy hoy ween tøø myiṉ̃ tøø quiaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jaduhṉ mäwíinäts hajxy mjootmayhaty nebiä toꞌoxiøjc jaꞌa jioothajxy piädøꞌøguiän. Pero nägooyyä højts nniyhíjxägumbä, mänit mijts mxooṉdaꞌagaꞌañ. Caj mijts pøṉ xyagjootmayhadaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Cábøch mijts hänajty tii xmiäyujwaꞌanaaṉnä. Chaads mijts tehm̱ tiøyhajt nnämáꞌawät, cooc̈h mijts nDeedy hänajty tijaty xmiäyujwaꞌanaaṉä, xmioꞌowaam̱b mijts jeꞌe jaꞌa høøc̈hcøxpä. ");
INSERT INTO mirNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Cahnä hajxy tii mhuuc yujwaꞌañ jaꞌa høøc̈hcøxpä. Coo hajxy tijaty myujwáꞌanät, xñäꞌägä moꞌowaam̱b hajxy jeꞌe. Jaduhṉ hajxy hoy jootcujc mhídät. ");
INSERT INTO mirNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Yajmäbaadyháamhøch mijts tøø nmøødmädiaꞌagy. Habáatnäp jaduhṉ cooc̈h ngaꞌa mädiaꞌagaaṉnä yajmäbaadyhaam. Howyiinjuǿøñøch jaꞌa nDeedy nmädiaꞌagaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Mänítøch mijts jaꞌa nDeedy hoy tyiijä xmiäyujwaꞌanaaṉä jaꞌa høøc̈hcøxpä. Mänit hajxy xmioꞌowaꞌañ. NDéedyhøch mijts xyhamdsoo mäyujwaꞌanáaṉäp jeꞌeguiøxpä cooc̈h mijts nDeedy xjiaanc̈h tehm̱ chocy. Paady mijts xchocy cooc̈h mijts xchojpä, cooc̈h mijts jaꞌa nmädiaꞌagy hajxy tøø xmiäbøjcä cooc̈h jim̱ tøø ndsooñ maac̈hä nDeediän. Hamdsoo hajxy mmäyujwaꞌanaꞌañ; cábøch waam̱b nmänaꞌanaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Høøc̈h, jím̱høch tøø ndsooñ maac̈hä nDeediän. Yaac̈h tøø ngädaꞌagy hädaa yaabä naax̱wiin. Pero tsoonáam̱bøch yaa jadähóocägumbä. Nøcxtägatsáam̱bøch jím̱ägumbä maac̈hä nDeediän. ");
INSERT INTO mirNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mänitä Jesús jaꞌa jiamiøødhajxy miänaaṉ̃, ñämaayyä Jesús: ―Hoora sí, howyiinjuøøñä miic̈h mmädiaacnä. ");
INSERT INTO mirNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tøø højts nnajuøꞌøy. Cab højts miic̈h tii nmäyajtøwaaṉnä. Nmäbǿjnäp højts jaduhṉ cóodäm miic̈h jim̱ mjaanc̈h tsooñ maa Diosän. ");
INSERT INTO mirNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Mänitä Jesús yhadsooyy: ―Mjaanc̈h mäbøjpiädaꞌa tyijy hajxiä. ");
INSERT INTO mirNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Habáatnäp jaduhṉ coo mijts jaꞌa cuꞌug xquiøx̱y päboowiaꞌxaꞌañ. Mänit hajxy jim̱ mnøcxaaṉnä maa mdøjc‑hajxiän. Nidiúhm̱høch hajxy yaa xñähgueꞌegaaṉnä. Pero cábøch nidiuhm̱ tøyhajt nhidaꞌañ. Jaꞌa nDéedyhøch jaduhṉ xmiøødhidaam̱b. ");
INSERT INTO mirNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Páadyhøch mijts jaduhṉ cham̱ nyajwiinxiic nyajwiingapxøꞌøy coo mijts ween jootcujc mhíjnät cooc̈hä nmädiaꞌagy hajxy xmiäbøjcät. Mbaadaam̱biä tsaac̈hpa peenä hajxy hädaa yaabä naax̱wiin. Pero caꞌa hajxy tii mdajy mmay; cábøc̈hä møjcuꞌugong nyajmäjädaꞌagaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nägooyyä Jesús miädiaacpädøøyy, mänit yuugheeꞌpy tsajpootyp. Mänit miänaaṉ̃: ―Teedy, tøø yhabaatnä. Huuc yajcähxøꞌøg cooc̈h nmøjjä cooc̈h njaanc̈hä. Jadúhṉhøch nyajcähxøꞌøgaam̱bä coo miic̈h mmøjjä coo miic̈h mjaanc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tøøc̈h miic̈h cuhdujt jaduhṉ xmioꞌoy cooc̈hä jäyaꞌayhajxy nägøx̱iä nguhdujtmóꞌowät coo hajxy jim̱ jaduhṉ ween yhity maa miic̈hän cøjxtaꞌaxiøø, pønjátyhøch miic̈h tøø xyajcøꞌøwaaṉøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jaduhṉ hajxy jim̱ cøjxtaꞌaxiøø yhidaꞌañ maa miic̈hän, coo højts jaꞌa nmädiaꞌagy jaduhṉ xmiäbǿjcämät coo miic̈h nidiuhm̱ mDioshaty, coo miic̈h mdømiädiaꞌagy, cooc̈h miic̈h yaa tøø xquiex̱y hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Høøc̈h, ngudiúum̱biøch hädaa yaabä naax̱wiin nébiøch miic̈h tøø xyhaneꞌemiän. Nyajcähxǿꞌpiøch jaduhṉ coo miic̈h jaꞌa mäjaa tøyhajt mmøødä. ");
INSERT INTO mirNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Teedy, høøc̈hä nmäjaa yajcähxǿꞌcäc jim̱ maa miic̈hä mwiinduumän nébiøc̈hä mäjaa hijty jim̱ nmøødän mänaabä hädaa yaabä naax̱wiin yhawijy tiøøꞌxtaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Pønjaty miic̈h yaa tøø mwiimbiy hädaa yaabä naax̱wiin, jeꞌec̈h hajxy jayøjp nyajmädoyhajt coo miic̈h nidiuhm̱ mDioshaty, coo miic̈h mdømiädiaꞌagy. Miic̈hä mgøꞌøjooty hajxy jeꞌe hijty. Pero jadähóoc‑høch miic̈h jeꞌe tøø xyajcøꞌøwaaṉǿøguiumbä. Tøø jaꞌa mmädiaꞌagy hajxy jeꞌe xmiäbøjcä xquiudiuuṉä. ");
INSERT INTO mirNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ñajuǿøñäp hajxy cooc̈h miic̈h jaduhṉ tøø xmioꞌoy mädúhṉ̃tiøch nmøødä. ");
INSERT INTO mirNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tøøc̈h hajxy ngøx̱y yajnähixøꞌøy nebiátyhøch miic̈h tøø xyajnähixøøbiän. Ñajuǿøñäp hajxy cooc̈h jim̱ tøyhajt ndsooñ maa miic̈hän. Tøøc̈hä nmädiaꞌagy hajxy jaduhṉ xmiäbøjcä cooc̈h miic̈h tøø xquiex̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Teedy, tuṉä mayhajt. Cueendähat hädaa jäyaꞌayhajxy, hädáajøch miic̈h tøø xyajcøꞌøwaaṉǿꞌøyäbä. Caꞌa jieꞌemǿødøch jaduhṉ nnänøm̱y jaꞌa mmädiaꞌagy hajxy tøø xquiaꞌa mäbǿjcäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Højts hädaa jäyaꞌay njeꞌehajmújcäm; páadyhøch miic̈h nnämaꞌay coo mgüeendähádät. Hädaa jäyaꞌaguiøxpä jaduhṉ quiähxøꞌøgaꞌañ coo højts nmøjhájtäm coo højts njaanc̈hhájtäm. ");
INSERT INTO mirNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Cábøch yaa nhidaaṉnä hädaa yaabä naax̱wiin. Nøcxáaṉnäbøch jim̱ maa miic̈hän. Pero yaac̈hä njamiøødhajxy miähmøꞌøwaꞌañ. Cueendähat hajxy neby hajxy jaduhṉ yhídät tuꞌugmädiaꞌagy neby højts nhíjtäm tuꞌugmädiaꞌagy. Miic̈hä mmäjaagøxpä mgüeendähádät. Míic̈hhøch hajxy tøø xyajcøꞌøwaaṉøꞌøy. Jaanc̈h tehm̱ wiaꞌads miic̈hä mjoot miic̈hä mwiinmahñdy. ");
INSERT INTO mirNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Høxtä jädaꞌanäbáadyñøch hajxy ngüeendähaty miic̈hä mmäjaagøxpä. Caj miic̈hä mmädiaꞌagy hajxy nägøx̱iä tøø xñajtshixøøyyä. Jagooyyä tuꞌjäyaꞌay jaꞌa mmädiaꞌagy tøø xñajtshixøøyyä, jaꞌa hijty näꞌägä tuꞌudägoyyaam̱bä. Paady jaduhṉ tiuꞌudägooyy nebiä mmädiaꞌagy jaduhṉ tiøjiádät nebiä cujaaybä miähmøøyyän. ");
INSERT INTO mirNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Høøc̈h, nøcxáaṉnäbøch jim̱ maa miic̈hän. Páadyhøch miic̈h jaduhṉ cham̱ nyajmøødmädiaꞌagy hädaa jäyaꞌay wyiinduumhajxy neby hajxy jaduhṉ xiooṉdáacpät nébiøch nxooṉdaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tøøc̈h miic̈hä mmädiaꞌagy hädaa jäyaꞌayhajxy nyajmøødmädiaꞌagy. Paady hajxy yaa miähaṉhadyii hädaa yaabä naax̱wiin, coo hajxy haxøøgtuum quiaꞌa wädijnä. Høøc̈h hajxy xpiahijxp cooc̈h haxøøgtuum ngaꞌa wädity. ");
INSERT INTO mirNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Chaads miic̈h nnämáꞌawät coo miic̈h hädaa jäyaꞌayhajxy mgüeendähádät maa jaꞌa møjcuꞌugongän. Cábøch jaduhṉ nmänaꞌañ coo hajxy yaa chóonät hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Hoy hajxy jaduhṉ wiädity nébiøch nwäditiän. ");
INSERT INTO mirNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Cunuuꞌx hädaa jäyaꞌayhajxy jaꞌa miic̈hä mhomiädiaꞌagyhaam nebiä mmädiaꞌagy hajxy tehṉgajnä xpianǿcxät xquiudiúuṉät. Mäduhṉ̃tiä miic̈hä mmädiaꞌaguiä, tøyhajt jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Høøc̈h, hädaa yaabä naax̱wíinhøch miic̈h tøø xquiex̱y nébiøch miic̈h jaꞌa jäyaꞌay jaꞌa mmädiaꞌagy hajxy nyajmädoyhádät. Jadúhṉhøch yøꞌøyaꞌayhajxy nwiinguexaam̱bä nebiä mmädiaꞌagy hajxy xyaghawaꞌxǿøyyät. ");
INSERT INTO mirNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nnähhoꞌtuꞌudáam̱biøch hädaa jäyaꞌayhajxy nejy miic̈hä mmädiaꞌagy hajxy tehṉgajnä xpianǿcxät xquiudiúuṉät. ");
INSERT INTO mirNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","21","’Jadúhṉhøch nmänaam̱bä coo jäyaꞌayhajxy ween yhity tuꞌugmädiaꞌagy nägøx̱iä mädúhṉ̃tiøch jaꞌa nmädiaꞌagy hajxy xmiäbøgaaṉä majatyhagájpthøc̈hä njamiøød jaꞌa nmädiaꞌagy hajxy xyajwaꞌxaaṉä. Ween hajxy xmiøødhíjtäm tuꞌugmädiaꞌagy neby højts nhíjtäm tuꞌugmädiaꞌagy. Jaduhṉdsä jäyaꞌayhajxy miäbøgaꞌañ cooc̈h miic̈h tøyhajt tøø xjiaanc̈h quex̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tøøc̈h hajxy nguhdujtmoꞌoy coo hajxy yhídät tuꞌugmädiaꞌagy, nébiøch miic̈h tøø xquiuhdujtmoꞌoyän coo nhíjtämät tuꞌugmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Tuꞌugmädiáꞌagyhøch hajxy xmiøødhity nébiøch miic̈h nmøødhitiän tuꞌugmädiaꞌagy. Nägøx̱iä hajxy jaduhṉ yhídät tuꞌugmädiaꞌagy, jaꞌa nmädiáꞌagyhøch hajxy tøø xmiäbǿjcäbä. Jaduhṉdsä jäyaꞌayhajxy ñajuøꞌøwaꞌañ nägøx̱iä cooc̈h miic̈h tøø xquiex̱y, coo miic̈h hajxy jaduhṉ mdsocy nébiøch miic̈h xchoquiän. ");
INSERT INTO mirNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Teedy, mänáam̱bøch jaduhṉ cooc̈h hajxy jim̱ ween xmiøødhity maac̈h nhidaꞌañän, jaꞌac̈h miic̈h tøø xyajcøꞌøwaaṉǿꞌøyäbä. Jadúhṉhøch nmänaam̱bä coo jaꞌa mäjaa hajxy ween yhix̱y, jaꞌac̈h miic̈h tøø xmióꞌoyäbä. Xjiaanc̈h tehm̱ chójpøch miic̈h hänajty mänaabä hädaa yaabä naax̱wiin yhawijy tiøøꞌxtaꞌaguiän. Høxtä jädaꞌanäbáadyñøch miic̈h xchocyñä. ");
INSERT INTO mirNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Teedy, tøyhajt miic̈h mnäꞌägädä mädiaꞌagy. Jaꞌa cuꞌughajxy, cab hajxy wyiinjuøꞌøy coo miic̈h mdømiädiaꞌagy. Pero høøc̈h, nhíx̱yhøch miic̈h. Hädaa njamiǿødhøc̈h hajxy chaa tänaabiä, ñajuøøby hajxy jeꞌe cooc̈h miic̈h tøø xquiex̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tøøc̈h hajxy jeꞌe nyajmøødmädiaꞌagy coo miic̈h nidiuhm̱ mDioshaty, coo miic̈h mdømiädiaꞌagy. Tehṉgájnøch jaduhṉ nyajmøødmädiaꞌagaꞌañ neby hajxy jaduhṉ ñic̈hogøød ñibiaꞌhäyowøød nébiøch miic̈h xchoquiän. Wéenhøch hajxy tuꞌugmädiaꞌagy xmiøødhity. Mänitä Jesús miädiaacpädøøyy. ");
INSERT INTO mirNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Coo Jesús miädiaacpädøøyy, mänitä Jesúshajxy chohṉ̃ cajptooty møødä jiamiøødhajxy. Mänitä woc hajxy yajnajxy, jaꞌa hänajty xøhajpä Cedrón. Mänit hajxy tiägøøyy olivocamjooty. ");
INSERT INTO mirNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jaꞌa Judas, yhix̱y hänajty jeꞌe jiiby olivocamjooty. Mayhooc jaꞌa Jesúshajxy hänajty jiiby tøø yhamugøꞌøy. Jaꞌa Judas jaꞌa Jesús hänajty yegaam̱b. Jaꞌa Jesús jaꞌa miädsiphajxy hänajty yajcøꞌødägøꞌøwáaṉäp. ");
INSERT INTO mirNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mänitä Judas jaꞌa soldadohajxy hoy wioy. Møødä policíahajxy hoy wioy maa jaꞌa teedywiindsøṉhajxiän, maa jaꞌa fariseoshajxiän. Mänitä Jesús jiiby ñägädaacä olivocamjooty, jaꞌa Judashajxy møødä soldado møødä policía. Tøø hänajty quioodsøøñä. Møødä jiøøn møødä quiuhm̱d hajxy quiädaacy. ");
INSERT INTO mirNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jaꞌa Jesús, ñajuøøby hänajty jeꞌe nebiaty hänajty jeꞌe tiunaꞌañii. Mänitä Jesús hoy jiøjcuyoꞌoyøꞌøy jaꞌa Judashajxy. Mänit miäyajtøøyy: ―Pøṉ hajxy mhøxtaaby. ");
INSERT INTO mirNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mänit hajxy yhadsooyy: ―Jesús Nazaretpä højts nhøxtaaby. Mänitä Jesús miänaaṉ̃: ―Høøc̈h jaduhṉ xøhajp. ");
INSERT INTO mirNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Coo jaꞌa soldadohajxy jaduhṉ miädooyy, mänit hajxy jaduhyyä yhøxtägøꞌøwaꞌcy. Jaduhyyä hajxy cøjx quiäday. ");
INSERT INTO mirNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mänit Jesús miäyajtǿøgumbä: ―Pøṉ hajxy mhøxtaaby. Mänitä Judashajxy yhadsóogumbä: ―Jaꞌa Jesús Nazaretpä højts nhøxtaaby. ");
INSERT INTO mirNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Mänit Jesús miänaaṉ̃: ―Tøøds mijts nja hawáaṉäm. Hǿøc̈hämäts jeꞌe. Pø hǿøc̈htiäm mijts xyhøxtaaby, wéenhøc̈hä njamiøødhajxy wyiimbity. ");
INSERT INTO mirNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Paadiä Jesús jaduhṉ miänaaṉ̃ neby jaduhṉ tiøjiádät nebiä Tieedy hänajty tøø ñämaꞌayän: “Pǿṉhøch miic̈h tøø xyajcøꞌøwaaṉøꞌøy, cábøch pøṉ xpiøgaaṉä. Cab hajxy nej jiadaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mänitä Simón Pedro jaꞌa espada jiädujpädsøøm̱y. Mänitä teedywiindsǿṉ jaꞌa mioonsä tiaatsc ñäꞌä pújxäxä, jaꞌa hahoodiaatsc. Malco hänajty xiøhaty. ");
INSERT INTO mirNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mänitä Jesús jaꞌa Pedro yhojy: ―Cuyuugøꞌøw yøꞌø mhespada. Tsipcǿxpøch nhoꞌogaꞌañ nébiøc̈hä nDeedy tøø xñämaꞌayän. ");
INSERT INTO mirNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mänitä Jesús miajtsä quiøꞌøxojtsä. Jaꞌa soldadohajxy jaduhṉ jatcøøyy møødä wyiindsøṉhajxy møødä policíahajxy, jaꞌa judíoshajxy hänajty tøø quiéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Mänitä Jesús yajnøcxä maa jaꞌa Anás jaꞌa tiøjcän. Jaꞌa Anás jaꞌa Caifás hänajty miøꞌødhajpy. Teedywiindsǿṉ jaꞌa Caifás hänajty tiuum̱by. ");
INSERT INTO mirNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jaꞌa Caifás, jeꞌe jaꞌa judíoshajxy hänajty tøø ñämaꞌay cooc yhahixøꞌøy jaduhṉ coo tuꞌjäyaꞌay jaꞌa cuꞌug ñähhoꞌtúꞌudät. ");
INSERT INTO mirNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Høx̱haam jaꞌa Simón Pedro jaꞌa Jesús hajxy hänajty pianøcxy nämetscä. Jaꞌa Jesús jaꞌa jiamiøødhajxy nämetscä. Jaꞌa Simón Pedro miäguꞌughajpä, yhix̱y jaꞌa teedywiindsǿṉ hänajty jeꞌe. Mänit Jesús piadägøøyyä jaꞌa Simón Pedro miäguꞌughajpä maa jaꞌa teedywiindsǿṉ tiøghawaꞌadsän. ");
INSERT INTO mirNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Jaꞌa Pedro, jim̱ jeꞌe miähmøøyy tøghawaꞌadshaguum. Mänitä Pedro miäguꞌughajpä piädsøøm̱y. Mänitä toꞌoxymoonsä miägapxy jaꞌa tøjcueendähajpä. Mänitä Pedro quiuwowǿøyyäbä tøghawaꞌads jaꞌa yhamdsoo mäguꞌughajpä. ");
INSERT INTO mirNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mänitä toꞌoxymoonsä jaꞌa Pedro miäyajtøøyy: ―Miic̈h yøꞌøyaꞌay mmøødwädijpy, túhṉämäts. Mänitä Pedro yhadsooyy: ―Caꞌa yhøøc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jim̱ä policíahajxy hänajty jiøømbaꞌaxam̱y møødä moonsähajxy. Tøøchc hänajty. Paady hajxy hänajty tøø jiøønyajmøjjøꞌøy. Jim̱ä Pedro hänajty jiøømbaꞌaxaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mänitä Jesús miäyajtøøw̱a jaꞌa jiamiøødcøxpä møødä miädiaꞌagyquiøxpä. Jaꞌa teedywiindsǿṉ jaduhṉ yajtøøw̱. ");
INSERT INTO mirNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Mänitä Jesús yhadsooyy: ―Jím̱høch hijty tøø nmädiaꞌagy majiäyaꞌayhagujc. Jím̱høch hijty nmäyajnähixøꞌøy Diostøgooty møød tsajtøgooty maa jaꞌa judíoshajxy nax̱y yhamugøꞌøyän. Cábøch jim̱ mänaa pactuum tøø nmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tiic̈h miic̈h coo xmiäyajtøy. Yøꞌøyaꞌayhajxy mmäyajtǿwäp yøꞌø nmädiáꞌagyhøch hajxy tøø xmiädóow̱äbä. Yøꞌøhajxy jeꞌe najuøøby nebiátyhøch jim̱ tøø nmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tuuṉä Jesús jaduhṉ ñäꞌä hadsooyy, mänit yhalaꞌabøꞌcä. Policía jaduhṉ tuꞌug jatcøøyy. Mänitä policía Jesús ñämaayy: ―Cab jaduhṉ yhoyyä coo jaꞌa teedywiindsǿṉ jaduhṉ mhadsówät. ");
INSERT INTO mirNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Mänitä Jesús miänaaṉ̃: ―Pø tøøc̈h ngapxtägoy, yec jaꞌa tøyhajt yaa. Pø caj, cab jaduhṉ yhoyyä cooc̈h miic̈h näꞌä nägoobä xñäꞌä halaꞌabǿꞌøgät. ");
INSERT INTO mirNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mänitä Anás jaꞌa Jesús quiejxy cøꞌøxoch maa jaꞌa Caifás jaꞌa wyiinduumän. Caifás hänajty teedywiindsǿṉ tuum̱b. ");
INSERT INTO mirNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jaꞌa Simón Pedro, jim̱ hänajty jiøømbaꞌaxam̱y. Mänit miäyajtøøw̱a: ―Miic̈h yøꞌøyaꞌay mmøødwädijpy, túhṉämäts. Mänitä Pedro ñiguiugapxä: ―Caꞌa yhøøc̈hä. ");
INSERT INTO mirNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mänitä Pedro miäyajtǿøw̱ägumbä: ―Tøøc̈h miic̈h jiiby nhix̱y olivocamjooty møød yøꞌøyaꞌay, túhṉämäts. Jaꞌa teedywiindsǿṉ jaꞌa mioonsä jaduhṉ mäyajtøøw̱, jaayaꞌayä jiujy miäguꞌug jaꞌa tiaatsc hänajty tøø ñäꞌä pújxäxä jaꞌa Pedro. ");
INSERT INTO mirNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mänitä Pedro ñiguiugápxägumbä. Tuuṉä jaduhṉ ñäꞌä mänaaṉ̃, mänitä tseey yaax̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mänitä Jesús yajnøcxä maa jaꞌa gobernador tiøjcän. Pilato hänajty tuum̱b gobernador. Jobøꞌøwaam̱b hänajty. Coo hajxy jim̱ quiooꞌty, cabä teedywiindsøṉhajxy ñäꞌä tøjtägøøyy. Cabä Israelpä quiuhdujthajxy hänajty jaduhṉ myiṉ̃ coo hajxy jiiby tiøjtägǿꞌøwät maa jaꞌa tiøjc‑hajxiän, jaꞌa hajxy caꞌa Israelpähajpä, jaꞌa pascuaxøøjooty. Coo hajxy jiiby tiøjtägǿꞌøwät, cädiéeyäp hajxy jaduhṉ. Coo hajxy jaduhṉ quiädiéeyät, cab hajxy miägáyät jaꞌa pascuaxøøjooty. Paady hajxy jiiby quiaꞌa tägøøyy Pilato tiøgooty. ");
INSERT INTO mirNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Coo Pilato miädooyy coo hajxy hänajty tøø quioody, mänit hajxy ñädøjpädsøøm̱a. Mänitä Pilato miänaaṉ̃: ―Tii mijts yøꞌøyaꞌay myajcuxøꞌøwøꞌøwaam̱by. ");
INSERT INTO mirNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Mänit hajxy yhadsooyy: ―Coo hädaa jäyaꞌay häxøpy tøø quiaꞌa cädieey, cab højts miic̈h häxøpy tøø nyajnägoody. ");
INSERT INTO mirNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mänitä Pilato miänáaṉgumbä: ―Yajwiimbit yøꞌøyaꞌay hajxy. Nøcx mijts mädiaꞌagymiädow̱ nej mijts jaꞌa mguhdujt myiṉ̃än pø tøø quiädieey. Mänitä judíoshajxy yhadsooyy: ―Ja mänáꞌanäp højts jaduhṉ coo yaghoꞌogøød; pero højts, cab højts jaꞌa cuhdujt jaduhṉ nmøødä coo højts jäyaꞌay nyaghóꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Paady hajxy jaduhṉ yhadsooyy, ween jaꞌa Pilato jaduhṉ ñägapxy pø tøø Jesús tøyhajt jiaanc̈h cädieey. Tøjiajt jaduhṉ nebiä Jesús hänajty tøø miänaꞌañän coo hänajty yegaꞌañii maa jaꞌa caꞌa Israelpähajxiän, coo hänajty yaghoꞌogaꞌañii cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mänitä Pilato tiøjtägøøyy. Mänitä Jesús quiuyaaxøøyyä tøgooty. Mänit miäyajtøøw̱a: ―Nej, miic̈hä judíoshajxy xguiobiernähajpä. ");
INSERT INTO mirNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Mänitä Jesús yhadsooyy: ―Pøṉ jaduhṉ xñämaayy. Tøgä miic̈hä mhamdsoo copcooty mnäꞌä yajcojjiä. ");
INSERT INTO mirNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Mänitä Pilato jadähooc yhadsóogumbä: ―Tiic̈h nyajnajuǿꞌøb. Caꞌa yhøøc̈hä Israelpäjäyaꞌay. Miic̈hä mhamdsoo mägunáax̱høch miic̈h tøø xyajnägoody møødä teedywiindsøṉhajxy. Tii jaduhṉ tøø mgädieey. ");
INSERT INTO mirNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mänitä Jesús yhadsooyy: ―Høøc̈h, cábøch yaa nduṉ̃ gobiernä hädaa yaabä naax̱wiin. Cooc̈h häxøpy nduṉ̃, tøøc̈hä nmoonsähajxy häxøpy xñäwaꞌañ. Cábøc̈hä judíoshajxy häxøpy tøø xñäꞌä mach. Cábøch yaa nduṉ̃ gobiernä. ");
INSERT INTO mirNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mänitä Pilato miänaaṉ̃: ―Mduum̱bädaꞌa gobiernä. Mänitä Jesús miänaaṉ̃: ―Jex̱ioo, túum̱bøch jaduhṉ. Høøc̈h, nmädiáacypiøch jaꞌa tøyhajt hädaa yaabä naax̱wiin. Páadyhøch yaa tøø nmiṉ̃ tøø ngaꞌay. Pønjaty jaꞌa tømiadiaꞌagy mäbøjp, jeꞌec̈hä nmädiaꞌagy xmiäbǿjcäp. ");
INSERT INTO mirNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mänitä Pilato miänaaṉ̃: ―Pätiidä miic̈h jaduhṉ mnänøøm̱by jaꞌa tøyhajt. Mänitä Pilato tiøjpädsǿøm̱gumbä. Mänitä judíoshajxy ñämaayyä: ―Høøc̈h, cábøch yøꞌøyaꞌay tøø nhamdsoo hix̱y tøø nhamdsoo paady pø tøø quiädieey. ");
INSERT INTO mirNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Jii mijtsä mguhdujt jaduhṉ cooc̈h mijts jaꞌa jäyaꞌay tuꞌug nhøxmájtsämät jaꞌa pascuaxøøjooty. Nej, mmänaam̱b hajxy jaduhṉä coo jaꞌa mgobiernähajxy nhøxmájtsämät. ");
INSERT INTO mirNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mänit hajxy møc yhadsooyy: ―¡Caꞌa yøꞌøyaꞌay mhøxmach! ¡Høxmats jaꞌa craa Barrabáshajpä! Paadiä Barrabás hänajty chum̱yc̈hänaꞌay coo hänajty tøø mieec̈h tøø pioty. Mänitä Pilato tiøjtägøøñä. ");
INSERT INTO mirNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mänitä Pilato jaꞌa Jesús yajwojpä. ");
INSERT INTO mirNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mänitä soldado jaꞌa wädsatscorona hajxy yhädiuuṉ̃. Mänitä Jesús jaꞌa quiuhduum piädáacäxä. Mänitä Jesús jaꞌa hucywyit yajnähgäjeṉøøyyä nebiä gobiernähajxy hänajty wyithatiän. Paadiä Jesús jaduhṉ tiuuṉä, neby hajxy hänajty ñäꞌä wiꞌi ñäxiꞌigaꞌañ ñäꞌä wiꞌi ñäyaꞌaxaꞌañ. Paady hajxy hänajty ñäꞌä wiꞌi ñäxiꞌigaꞌañ coo jaꞌa Pilato hänajty tøø miänaꞌañ coogä Jesús hänajty guiobiernähaty. ");
INSERT INTO mirNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Mänitä Jesús miäwiingooṉä. Mänit ñäxiicä: ―¡A poco miic̈h tuum̱b gobiérnäjä! Mänitä Jesús tiägøøyyä coxhóꞌcäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mänitä Pilato tiøjpädsǿøm̱gumbä. Mänitä judíoshajxy ñämaayyä: ―Nyajtøjpädsøm̱áam̱biøch yøꞌøyaꞌay nebiä tøyhajt hajxy jaduhṉ mmøødhádät cooc̈h tøø nhix̱y tøø nbaady coo tøø quiaꞌa cädieey. ");
INSERT INTO mirNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mänitä Jesús piadøjpädsøøm̱y hucywyitmøød, coronamøød. Mänitä Pilato ñämaayy jaꞌa Israelpäjäyaꞌayhajxy: ―Xiids yøꞌøyaꞌay tøø tiøjpädsøm̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Coo Jesús jaduhṉ yhijxä jaꞌa teedywiindsøṉhajxy møødä policíahajxy, mänit hajxy ñäyaaxøøyy: ―¡Møjpahbétäts hajxy cruzcøxp! ¡Møjpahbétäts hajxy! Mänitä Pilato miänaaṉ̃: ―Hamdsoo hajxy mmøjpahbédät. Høøc̈h, cábøch jaduhṉ nmänaꞌañ coo tøø quiädieey. ");
INSERT INTO mirNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mänitä Israelpäyaꞌayhajxy yhadsooyy: ―Jaduhṉ højts nguhdujt myiṉ̃ coo yøꞌøyaꞌay ween yaghoꞌogyii jeꞌeguiøxpä coo tøø miänaꞌañ coogä Dios Tieedyhaty. ");
INSERT INTO mirNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Coo Pilato jaduhṉ miädooyy, mänitä chähgøøbiøjcy. ");
INSERT INTO mirNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mänitä Pilato jaꞌa Jesús miøødtøjtägøøñä. Mänitä miäyajtøøyy: ―Maa miic̈h mjaanc̈h tsooñ. Pero cabä Jesús waam̱b miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mänitä Pilato miänáaṉgumbä: ―Nej, cábøch xñäꞌägä hadsowaꞌañä. Nej, caj miic̈h mnajuøꞌøyä cooc̈hä cuhdujt nmøødä cooc̈h miic̈h nhøxmádsät, ó cooc̈h miic̈h nyajmøjpahbedøød. ");
INSERT INTO mirNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mänit Jesús yhadsooyy: ―Coo Dios miic̈h cuhdujt häxøpy tøø xquiaꞌa moꞌoy, caj miic̈h jaꞌa cuhdujt häxøpy mmøødä maac̈h høøc̈hcøxpän. Paady miic̈h jaꞌa pojpä caj mjaty møødä quejee jaꞌa teedywiindsǿṉ, jaꞌa høøc̈h yaa tøø xyajméchäbä maa miic̈hä mwiinduumän. ");
INSERT INTO mirNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mänit Pilato jia wiinmahñdyhajty nebiä Jesús yhøxmádsät. Pero mänitä Israelpäyaꞌayhajxy ñäyaaxǿøguiumbä: ―¡Pø mmäguꞌughajpy miic̈h jaꞌa gobiernä César, caj miic̈h yøꞌø craa mhøxmádsät! Pøṉ jaduhṉ wiꞌi ñibiädáacäp nebiä gobiernän, jeꞌedsä gobiernä César møøtnimiädsiphájtäp. ");
INSERT INTO mirNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Coo Pilato jaduhṉ miädooyy, mänitä Jesús miøødtøjpädsǿøm̱ägumbä. Mänitä Pilato yhøxtaacy häñaabiejtcøxp maa hajxy hänajty xiøhdaacthatiän. Jueꞌe hänajty jim̱ xiøhaty Gabata, hebreohayuuc‑haamby. Jeꞌeduhṉ ñänøøm̱by “maa jaꞌa tsaa quiøøñaꞌayän.” ");
INSERT INTO mirNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tøø hänajty quiujyxiøøjøꞌøy. Hadsuujøꞌøwaam̱bä pascuaxøø hänajty. Mänitä Pilato ñämaayy jaꞌa Israelpäyaꞌayhajxy: ―¡Xiidsä mgobiernähajxy! ");
INSERT INTO mirNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mänit hajxy ñäyaaxǿøguiumbä: ―¡Ween yhoꞌogy! ¡Ween yhoꞌogy! ¡Nøcx hajxy møjpahbet! Mänit Pilato miänaaṉ̃: ―Nej, mmänáꞌanäp mijts jaduhṉä coo mijts jaꞌa mgobiernä nmøjpahbéjtämät. Mänit teedywiindsøṉhajxy yhadsooyy: ―César højts ngobiernähajpy. Caꞌa wyiinghänaꞌcä. ");
INSERT INTO mirNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mänitä Pilato Jesús yajcøꞌødägøøyy maa jaꞌa Israelpähajxiän, coo Jesús miøjpahbedøød. ");
INSERT INTO mirNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mänitä Jesús jim̱ yajnøcxä maa jaduhṉ xiøhatiän “Maa jaꞌa Hoꞌogyjiäyaꞌaguiopcän.” Gólgota jim̱ xiøhaty hebreohayuuc‑haamby. Yhamdsoo cruz jeꞌe yajquejyquiaphajtä. ");
INSERT INTO mirNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jim̱ä Jesús hoy miøjpahbedyii. Metscä jäyaꞌay jim̱ miøjpahbéjtäbä Jesús jaꞌa ñähmøjc. Cujc jaꞌa Jesús quiubaꞌawøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Mänitä Pilato yagjahyyä puꞌuyhuungcøxp: “Jesús Nazaretpä, jaꞌa Israelpäjäyaꞌay jaꞌa guiobiernähajxy.” Mänitä puꞌuyhuung yajyujpahw̱a cruzcuhduum. ");
INSERT INTO mirNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tägøøghayuuc‑haamby jaduhṉ yagjahyyä, møødä hebreo, møødä griego, møødä latín. Cajptmäwiingóṉ Jesús miøjpahbejtä. Paadiä judíoshajxy nämay yajmädiaacy nebiä Pilato hänajty tøø yajyuugjaayiiyän cruzcøxp. Mänitä teedywiindsǿṉ jaꞌa Pilato hajxy ñämaayy: ");
INSERT INTO mirNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","―Cab hijty jaduhṉ yhahixøꞌøy coo jaduhṉ cu mjahy: “Jaꞌa Israelpäjäyaꞌay jaꞌa guiobiernähajxy.” Jaduhṉ cu mjahy: “Näꞌä nibiädáacäp jaduhṉ nebiä Israelpäjäyaꞌay jaꞌa guiobiernähajxiän.” ");
INSERT INTO mirNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mänitä Pilato yhadsooyy: ―Tøøc̈h jaduhṉ njaay; cábøch nyajtägatsaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Coo Jesús hänajty tøø miøjpahbedyii, mänitä soldado jaꞌa Jesús jaꞌa wyit hajxy yajpädøꞌcä. Nämädaax̱c jaꞌa soldadohajxy hänajty. Mänitä wit hajxy yajwaꞌxy cøduꞌug. Jii Jesús jaꞌa yoṉ̃wit hänajty tuꞌug. Tuꞌugwit hänajty tøø quiojy; cab hänajty maa xiuyyä. ");
INSERT INTO mirNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mänitä soldadohajxy ñiñämaayyä: ―Cab jaduhṉ yhoyyä coo hädaa wit hajxy nhagøødsǿøyyämät. Tsøg hajxy häyǿꞌcäm. Pøṉ hädaa wit jaduhṉ cuhäyǿꞌøgäp, jeꞌe jaduhṉ jeꞌehádäp. Mänitä soldadohajxy jaduhṉ jiaanc̈h häyøꞌcy. Jaduhṉdsä Diosmädiaꞌagy tiøjiajty maa jaduhṉ cujaay myiṉ̃än: “Xyajwáꞌxøch jaꞌa nwit hajxy; xquiuhäyǿꞌcøch jaꞌa nwit hajxy jaduhṉ.” ");
INSERT INTO mirNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jim̱ä Jesús jaꞌa tiaj hänajty tiänaꞌay maa hänajty mädøyyä tøø miøjpahbedyiijän, chaadsä tiaj jaꞌa piuhdoꞌoxy, chaadsä María jaꞌa Cleofas jaꞌa tioꞌoxiøjc, chaadsä María Magdalena. Jim̱ä Jesús jaꞌa miäguꞌughajpä hänajty tuꞌug tiänaꞌay maa jaꞌa Jesús tiaj mädøyyän, jaꞌa Jesús hänajty jiaanc̈h tehm̱ chojpiä. ");
INSERT INTO mirNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Coo hajxy yhijxä jaꞌa Jesús, mänitä Jesús jaꞌa tiaj ñämaayy: ―Maam, hädaads mhuunghádäp. ");
INSERT INTO mirNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mänitä Jesús jaꞌa miäguꞌughajpä ñämaayy: ―Hädaads mdajhádäp, jaꞌa høøc̈hä ndaj. Mänit jiaanc̈h tajnäbøjcy. ");
INSERT INTO mirNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mänitä Jesús miänaaṉ̃: ―Tødsǿøyyäbøch. Tøjiajt jaꞌa Diosmädiaꞌagy jaduhṉ. Ñajuøøbiä Jesús hänajty coo hänajty tøø yhabejnä. ");
INSERT INTO mirNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jim̱ä tex̱y hänajty tuꞌug quiøøñaꞌay vinoxuṉmøød. Mänitä xoꞌod hajxy quiugonøøyy vinojooty. Cøjx jeꞌe chomøꞌøy. Mänitä pax̱y hajxy yagjøjwøønøøyy jaꞌa xoꞌod. Mänitä Jesús jaꞌa xoꞌod hajxy yaghayuugøøyy. ");
INSERT INTO mirNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Coo Jesús jaꞌa vino miuuꞌcy, mänitä miänaaṉ̃: ―Tøøds jaduhṉ miaañä. Mänitä quiopc yagjänaaṉnä. Mänit yhoꞌnä. ");
INSERT INTO mirNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mänaa jaꞌa Jesús yhoꞌoguiän, jaꞌa pascuaxøø hänajty tehm̱ yhadsuujøøby. Cujaboom jaꞌa møjpascuaxøø hänajty jiadaꞌañii, pooꞌxxiøøjooty. Jaduhṉdsä judíoshajxy hänajty quiuhdujthaty, cabä hoꞌogyjiäyaꞌay hajxy hänajty jim̱ yajmähmøꞌøy cruzcøxp jaꞌa pooꞌxxiøøjooty. Mänitä Israelpä jaꞌa Pilato hajxy hoy ñämaꞌay coo soldado quiéxät weenä Jesús jaꞌa tiecyhajxy nøcxy tiǿjjäxä neby hajxy paquiä yhóꞌogät. Nägooyyä hajxy jaduhṉ yhóꞌogät, mänit hajxy yajmänacøød cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","33","Mänitä Pilato jaꞌa soldado jiaanc̈h quejxy. Coo jaꞌa soldadohajxy jim̱ miejch, mänit hajxy yhijxy coo jaꞌa Jesús hänajty tøø yhoꞌogy. Cabä tiecy hajxy jeꞌe ñäꞌä tøjjä. Mänitä ñähmøjcpähajxy tiecytiøjjä nämetscä. Cahnä hajxy hänajty yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mänitä Jesús quiaac̈hmägumøøyyä cuhm̱dhaam. Soldado jaduhṉ tuꞌug jatcøøyy. Mänitä nøꞌty piädsøøm̱y chaadsä nøø. ");
INSERT INTO mirNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Høøc̈h, tøyhájthøch jaduhṉ tøø nhix̱y. Páadyhøch mijts jaduhṉ nyajmädoyhaty neby hajxy jaduhṉ mmäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Jecy hajxy jaduhṉ quiujahy Diosmädiaꞌagyjiooty jaꞌa Jesúscøxpä: “Cabä piajc tiøjáaṉäxä.” Jaduhṉ hajxy quiujahbiä jaꞌa Jesúscøxpä: “Wyiinheeꞌppedaam̱by hajxy, jaꞌa hajxy hänajty tøø quiúm̱iäbä.” Coo jaꞌa Jesús jaꞌa tiecy jaduhṉ quiaꞌa jaanc̈h tǿjjäxä, coo jaduhṉ jiaanc̈h cuum̱a, tøjiajt jaꞌa Diosmädiaꞌagy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tuꞌugä jäyaꞌay hänajty jim̱ chooñ Arimatea. José hänajty xiøhaty. Hameeꞌch jaꞌa Jesús hänajty miøødnimiäguꞌughadyii. Chähgøøbiä José jaꞌa judíos hänajty. Paadiä Jesús hänajty hijxwiinduum quiaꞌa møødwädityii. Mänitä José jaꞌa cuhdujt hoy yajpädsøm̱y maa jaꞌa Pilatän coo jaꞌa Jesús yajmänacaꞌañ cruzcøxp. Mänitä Pilato jaꞌa cuhdujt jiaanc̈h yejcy. Mänitä José jaꞌa Jesús yajmänajcy cruzcøxp. ");
INSERT INTO mirNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Mänitä Nicodemo jaꞌa perfume miämejch hiiꞌxmajc kilo. Mäyäbicøꞌøy miämejch møødä mirra møødä áloes. Tøø hänajty jiegøꞌøy coo jaꞌa Nicodemo hänajty tøø yhuug hoobiä coods maa jaꞌa Jesúsän. ");
INSERT INTO mirNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mänitä José jaꞌa Jesús hajxy ñähbijty møødä Nicodemo. Jiibiä perfume hajxy yajmänähbidøøyy. Jaduhṉdsä judíoshajxy hänajty quiuhdujthaty. Perfumemänähbidøꞌøy jaꞌa hoꞌogyjiäyaꞌay hajxy hänajty yajnaax̱tägøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jim̱ä olivocam̱ hänajty tuꞌug mäwiingóṉ maa jaꞌa Jesús hänajty tøø miøjpahbedyiijän. Jiibiä tsaajut hänajty tuꞌug olivocamjooty wiinmøjtuum. Naam̱baꞌay jaꞌa tsaajut hänajty. Cahnä hoꞌogyjiäyaꞌay hänajty jiiby piädaactsooñiinä. ");
INSERT INTO mirNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jaꞌa judíoshajxy, tsuu jaꞌa piooꞌxxiøø hajxy hänajty yajtsohṉdaꞌagy. Cab hajxy hänajty quiuhdujthaty coo hajxy tii tiúnät jaꞌa pooꞌxxiøøjooty. Ja ween jaꞌa pooꞌxxiøø hänajty quiaꞌa habaady, paadiä Joséhajxy quiaꞌa näbaadøøyyä coo hajxy hoy jäguem̱ cu yajnaax̱tägøøyy. Paady hajxy jim̱iä ñäꞌä pädaacy tsaajutjooty jaꞌa olivocamjootypä. ");
INSERT INTO mirNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Cumaax̱c, näxøø hänajty jeꞌe. Mänitä María Magdalenahajxy jim̱ ñøcxy maa jaꞌa tsaajutän, maa jaꞌa Jesús hänajty tøø ñaax̱tägøꞌøyän. Cahnä hänajty hoy jiajjøꞌøgyñä. Coodsjuøøbyñä hänajty. Mänit hajxy yhijxy coo jaꞌa tsaa jim̱ tøø jiøwaꞌac̈h juthaguuy. ");
INSERT INTO mirNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Coo jaꞌa María yhijxy coo jaꞌa tsaa quiaꞌa jim̱än juthaguuy, mänit wyiimbijty päyøꞌøguiä. Mänitä Simón Pedrohajxy piaatä chaadsä Jesús jaꞌa miäguꞌughajpä, jaꞌa Jesús hänajty jiaanc̈h tehm̱ chojpiä. Mänitä María miänaaṉ̃: ―Tøø jaꞌa nWiindsøṉhájtäm hajxy xyajpädsǿøm̱äm tsaajutjooty. Cab højts nnajuøꞌøy pämaadä hajxy tøø piädaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Coo jaꞌa Pedrohajxy jaduhṉ miädooyy, mänit hajxy jim̱ ñøcxy päyøꞌøguiä maa jaꞌa tsaajutän. Mänitä María jadähooc pianǿcxcumbä. ");
INSERT INTO mirNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mänitä Pedro yhøxpäyøꞌcä. Jayøjp jaꞌa Pedro jiamiøød jim̱ miejch maa jaꞌa tsaajutän. ");
INSERT INTO mirNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mänit jiiby quiuwoodsøøyy tsaajutjooty. Mänitä wit yhijxy coo jiiby yhohx̱naꞌay jutjooty. Pero cab jiiby tiehm̱ tiägøøyy. Näꞌä cuhixøøyy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mänitä Simón Pedro høx̱haam jiaac mejch. Tuꞌudaꞌaquiä jiiby tiägøøyy tsaajutjooty. Jaduhṉä wit yhijxpä coo jiiby yhohx̱naꞌay. ");
INSERT INTO mirNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Mänitä paayyä yhijxy, jaꞌa Jesús hajxy hänajty tøø yajcuhmäguítiäbä. Hawiing hänajty jim̱ ñeꞌnaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mänitä Pedro jiamiøød piadägøøbiä, jaꞌa hänajty jayøjp tøø miéchäbä. Mänitä paayyä yhijxpä coo hawiing ñeꞌnaꞌay. Paady jaduhṉ miäbøjcy coo jaꞌa Jesús hänajty tøø jiujypiøcy. ");
INSERT INTO mirNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Cahnä Diosmädiaꞌagy hajxy hänajty hoy wyiinjuøꞌøyñä jaꞌa jecypiä maa jaduhṉ myiṉ̃än coo jaꞌa Jesús hänajty jiujypiøgaꞌañ coo hänajty tøø yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mänitä Pedrohajxy wyiimbijnä, ñøcxnä hajxy maa jaꞌa tiøjc‑hajxiän. ");
INSERT INTO mirNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tøø jaꞌa María hänajty piaméjtscumbä høx̱haam maa jaꞌa tsaajutän. Coo jaꞌa Pedrohajxy wyiimbijnä, mähmøøyy jaꞌa María jim̱ nidiuhm̱. Wiꞌi jiøøby hänajty. Mänit jiiby quiuwoodsǿøguiumbä tsaajutjooty. ");
INSERT INTO mirNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Mänitä Diosmoonsä metsc yhijxy, jaꞌa tsajpootyptsohm̱bä. Haagä nähboobwit hajxy hänajty. Jiiby hajxy hänajty yhäñaꞌay maa jaꞌa Jesús hänajty tøø wyijtsnaꞌayän. Tuꞌjäyaꞌay hänajty yhäñaꞌay maa jaꞌa Jesús jaꞌa quiopc hänajty tøø quiooṉnaꞌayän. Y tuꞌjäyaꞌay hänajty yhäñaꞌay maa jaꞌa Jesús jaꞌa tiecy hänajty tøø quiajpnaꞌayän. ");
INSERT INTO mirNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mänitä María miäyajtøøw̱a: ―Muuxy, tii coo mwiꞌi jiøꞌøy. Mänitä María yhadsooyy: ―Tøøc̈hä nWiindsǿṉ hajxy xyajpädsøøm̱ä. Pämaadä hajxy tøø piädaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","15","Tuuṉä María jaduhṉ ñäꞌä hadsooyy, mänitä wiaꞌwiimbijty. Mänitä Jesús yhijxy. Jim̱ hänajty tiänaꞌay; pero cab jaduhṉ yhøxcajpy. Olivocam̱güeendähajpä jeꞌe yhajoodhajt. Mänitä Jesús miänaaṉ̃: ―Muuxy, tii coo mwiꞌi jiøꞌøy. Pøṉ mhøxtaaby. Mänitä María yhadsooyy: ―Tsäguhm̱, pø miic̈h tøø myajpädsøm̱y, høøc̈h hawáaṉäc maa tøø mbädaꞌagy nébiøch häyaa nøcxy nyajpädøꞌøgy. ");
INSERT INTO mirNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mänitä Jesús yhadsooyy: ―¡María! Tuuṉä María jaduhṉ ñäꞌä nämaayyä, mänitä wyiinheeꞌppejty. Mänitä yhøxcajpy coo jeꞌe Jiesúsä. Mänitä jaduhṉ miänaaṉ̃ hebreohayuuc‑haamby: ―¡Raboni! ―jeꞌe jaduhṉ ñänøøm̱by “Wiindsǿṉ.” ");
INSERT INTO mirNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Mänitä María jaꞌa Jesús jia mats jia mäneṉaaṉ̃. Mänitä Jesús miänaaṉ̃: ―Caꞌac̈h xmiach. Cáhnøch jim̱ nhoyñä maac̈hä nDeediän. Nǿcxhøc̈hä njamiøødhajxy hawáaṉäc cooc̈h jim̱ nnøcxaꞌañ maac̈hä nDeediän, maac̈hä nDiosän. Jaanä jeꞌe mijts mDeedyhajpä mDioshajpä. ");
INSERT INTO mirNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mänitä María jaꞌa Jesús jaꞌa jiamiøødhajxy hoy jiaanc̈h nämaꞌay: ―Tøøc̈h jeꞌe nhix̱y, jaꞌa hajxy nWiindsøṉhájtämbä. Mänit hajxy cøjx yhawáaṉäxä nebiaty jaꞌa María hänajty tøø ñämaꞌayii. ");
INSERT INTO mirNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Coo quioodsøøñä, mänitä Jesús jaꞌa jiamiøødhajxy ñiyhagǿøyyänä. Hix̱, chähgøøby jaꞌa judíos hajxy jeꞌe hänajty; paady hajxy ñiyhagøøyyä. Mänitä Jesús jiiby ñäguehx̱tøøꞌxy hagujc hawaꞌads. Mänitä Jesús miänaaṉ̃: ―Mäguieppe hajxy. Caꞌa hajxy tii mdajy mmay. ");
INSERT INTO mirNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mänitä Jesús yajcähxøꞌcy jaꞌa quiøꞌøjoot møødä quiaac̈hhac maa hänajty tøø jiotiän. Coo hajxy yhijxy, mänit hajxy ñajuøøyy coo jeꞌe Jiesúsä. Mänit hajxy xiooṉdaacy. ");
INSERT INTO mirNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Mänitä Jesús miänaaṉ̃: ―Caꞌa hajxy tii mdajy mmay. Nébiøc̈hä nDeedy tøø xwyiinguex̱iän, jaanä jadúhṉhøch mijts nwiinguexaam̱bä. ");
INSERT INTO mirNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mänitä Jesús ñäbäxujy jaꞌa jiamiøødhajxy. Mänitä miänaaṉ̃: ―Wiingpøc jaꞌa Dioshespíritu hajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Høøc̈h mijts jaꞌa mäjaa nmoꞌowaam̱by. Pønjaty mijts mhawáaṉäp coo Dios jaꞌa piojpä quiädieeyhajxy tøø yajnähwaꞌac̈h, pues tøyhajt jaduhṉ coo Dios tøø yajnähwaꞌac̈h. Pønjaty mijts mhawáaṉäp coo Dios tøø quiaꞌa yajnähwaꞌac̈h, pues tøyhajt jaduhṉ coo Dios tøø quiaꞌa yajnähwaꞌac̈h. ");
INSERT INTO mirNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Majmetscjäyaꞌay jaꞌa Jesús hänajty tøø miøødwädity. Tuꞌug hänajty xiøhaty Tomás, jaꞌa hajxy hänajty ñänøøm̱biä “Hametsc‑huung.” Mänaa jaꞌa Jesús ñäguehx̱tøøꞌxtsooñän jayøbajt, cabä Tomás hänajty jim̱. ");
INSERT INTO mirNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mänitä Tomás ñämaayyä jaꞌa jiamiøødhajxy: ―Tøø højts nhix̱y, jaꞌa hajxy nWiindsøṉhájtämbä. Mänitä Tomás miänaaṉ̃: ―Mänítøch nmäbǿgät cooc̈h ndehm̱ yhíxät pø jaanc̈h jot jaꞌa quiøꞌø, cooc̈hä ngøꞌø jiiby nhuuc tehm̱ piädáꞌagät maa jaꞌa quiaac̈hmøjc jiutän. Pø cabä, cábøch jaduhṉ nnäꞌägä mäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Cuductujxøø, jiibiä Jesús jaꞌa jiamiøødhajxy hänajty tøgóotiägumbä. Jiibiä Tomás hänajtypä. Tøø jaꞌa tøjc hajxy hänajty yhagǿøguiumbä. Mänitä Jesús jiiby ñäguehx̱tǿøꞌxcumbä hagujc hawaꞌads. Mänitä miänaaṉ̃: ―Mäguieppe hajxy. Caꞌa hajxy tii mdajy mmay. ");
INSERT INTO mirNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mänitä Tomás ñämaayy: ―Tehm̱ quiudsiiwøꞌøw yøꞌø mgøꞌø yaaby ngøꞌøjóotyhøch maa jaꞌa clavohaawän. Híjxägøch hädaa ngøꞌø. Pädaꞌag yøꞌø mgøꞌø yaaby ngaac̈hmǿjc‑høch. Miic̈h, caj miic̈h hijty mmäbøcy. Chaac̈h miic̈h nnämáꞌawät coo mmäbǿgät. ");
INSERT INTO mirNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mänitä Tomás yhadsooyy: ―Míic̈hhøch nWiindsøṉhajpy, nDioshajpy. ");
INSERT INTO mirNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mänitä Jesús miänaaṉ̃: ―Cooc̈h miic̈h tøø xyhix̱y, paady jaduhṉ mmäbøcy. Jootcujc hajxy jeꞌe, jaꞌa hajxy tøø miäbǿquiäbä, hóyhøch hajxy jeꞌe tøø xquiaꞌa ja hix̱y. ");
INSERT INTO mirNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Madiuꞌu jaꞌa Jesús jaꞌa hoy‑yagjuøøñäjätypä yajcähxøꞌcy jaꞌa jiamiøødä wyiinduumhajxy. Cab yam̱ cøx̱iä quiujaayä hädaa librocøxp. Cujwaꞌxy jeꞌe yam̱ quiujaayä. ");
INSERT INTO mirNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Paady yam̱ quiujaayä neby hajxy jaduhṉ mmäbǿgät coo Jesús jaꞌa Dios Tieedyhaty, coo Jesús jeꞌe Miesíashaty, coo jaꞌa Dios jaduhṉ tøø quiex̱y. Coo jaꞌa Jesús jaꞌa miädiaꞌagy hajxy mmäbǿjcät, mhídäp hajxy jim̱ tsajpootyp cøjxtaꞌaxiøø. ");
INSERT INTO mirNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jadähooc jaꞌa Jesús yhíjxägumbä jaꞌa jiamiøødhajxy jim̱ mejypiaꞌa jaꞌa xøhajpä Tiberias. ");
INSERT INTO mirNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jim̱ä Simón Pedrohajxy hänajty møødä Tomás, jaꞌa hajxy hänajty ñänøøm̱biä “Hametsc‑huung”, møødä Natanael jaꞌa Caná de Galilea tsohm̱bä, møødä Zebedeo yhuunghajxy, møød hajxy jaac nämetspä. Haagä Jesús jaꞌa jiamiøødhajxy jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mänitä Simón Pedro miänaaṉ̃: ―Nøcxy nhuuc jaac hacxmach. Mänitä jiamiøødhajxy miänaaṉ̃: ―Ween hajxy nnǿcxäm. Mänit hajxy jiaanc̈h nøcxy mejypiaꞌa. Mänit hajxy biarcotägøøyy. Mänit hajxy hoy jia hacxmadsaꞌañ. Tuꞌtsuhm̱ hajxy jaduhṉ jia wädijty. Pero cab hajxy tii ñäꞌägä paaty. ");
INSERT INTO mirNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Coo jiobøøyy, jim̱ä Jesús hänajty tiänaꞌay puꞌuwiing. Pero cabä Jesús yhøxcajpä jaꞌa jiamiøødhajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mänitä Jesús miänaaṉ̃: ―Mäguꞌughajpädøjc, nej, cab hajxy tii tøø mnäꞌägä paadiä. Mänit hajxy yhadsooyy: ―Joom mäguꞌughajpä, cab højts tii tøø nnäꞌägä paady. ");
INSERT INTO mirNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Mänitä Jesús miänaaṉ̃: ―Pädaꞌag yøꞌø mdsaay hajxy jim̱haamby jaꞌa barcohahooyhaampiä paꞌahaam. Mänit hajxy jaduhṉ mbáadät. Mänitä chaay hajxy jim̱ jiaanc̈h pädaacy. May jaꞌa hacx hajxy jiaanc̈h tehm̱ yaghadujcy. Cab hajxy hänajty miayaꞌañii coo jaꞌa tsaay hajxy hänajty jia wijtspädsøm̱aꞌañ nøøjooty. ");
INSERT INTO mirNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mänitä Pedro ñämaayyä jaꞌa Jesús jaꞌa jiamiøød, jaꞌa Jesús hänajty jiaanc̈h tehm̱ chojpiä: ―¡Jaꞌa nWiindsøṉhájtämhajxy yøꞌø! Tuuṉä Pedro jaduhṉ ñäꞌä mädooyy coo jeꞌe Jiesúsä, mänitä wyitpägøøyy. Høxyøꞌøhuungmøød hajxy hänajty yhacxmach. Mänitä quiuhtøpxnajxy nøøjooty. Nøcxaam̱b hänajty puꞌuwiing maa jaꞌa Jesúsän. ");
INSERT INTO mirNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jaꞌa jiamiøødhajxy, jiiby hajxy miähmøøyy barcojooty. Mejypiaꞌa mäwiingóṉ hajxy hänajty yhacxjoomy. Jaduhṉädaꞌa jaꞌa mejypiaꞌa hajxy hänajty tøø ñähgueꞌegy mägoꞌxmetro. Hujts jaꞌa tsaay jaꞌa hacx hänajty miøødä. Mänitä tsaay hajxy pawich yajnøcxy mejypiaꞌa barcojooty. ");
INSERT INTO mirNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Mänit hajxy biarcopädsøøm̱y. Mänitä juhṉ̃dy hajxy yhijxy coo jim̱ wyiꞌi tioy puꞌuwiing. Jim̱ä Jesús hänajty yhacxtsaꞌay. Jim̱ä tsajcaagy hänajty yajcooṉnaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Mänitä Jesús miänaaṉ̃: ―Mämíṉ jaꞌa hacx hajxy mejtstägøøg, jaꞌa hajxy tøø mmáchäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mänitä Pedro tiägǿøguiumbä barcojooty. Mänitä tsaay pawich yajmejch mejypiaꞌa. Mägoꞌx cu juxychäguiꞌxmajtägøøg jaꞌa hacx hänajty jiiby tsaajiooty, haagä majatypä. Hujts jaꞌa tsaay hänajty, pero cabä hacx yajcøøꞌch. ");
INSERT INTO mirNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Mänitä Jesús miänaaṉ̃: ―Miṉds hajxy cay. Cab hajxy miäyajtøøyy pøṉ jeꞌe. Tøø hajxy hänajty yhøxcapy coo jeꞌe Jiesúsä. ");
INSERT INTO mirNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mänitä Jesús jaꞌa jiamiøød jaꞌa tsajcaagy hajxy miooyy møødä hacxtsaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Miädägøøghoocpä jaꞌa Jesús hajxy hänajty tøø yhix̱y mänaa hänajty tøø jiujypiøquiän. ");
INSERT INTO mirNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Coo hajxy quiaabiädøøyy, mänitä Jesús jaꞌa Simón Pedro ñämaayy: ―Simón, Juan miic̈h mdeedyhajpy. Pøṉhøc̈hädaꞌa xmiaas tsojp, yøꞌø njamiøødhájtäm o miic̈h. Mänitä Pedro yhadsooyy: ―Mnajuøøby miic̈h cooc̈h miic̈h njuøꞌøy nebiä hajch nebiä puhyaꞌayän. Mänitä Jesús miänaaṉ̃: ―Yaghójcägøc̈hä nmeeghuunghajxy. Caꞌa mieeghuungä jaꞌa Jesús jaduhṉ tiehm̱ ñänøøm̱. Jeꞌeduhṉ ñänøøm̱ coo jaꞌa Simón Pedro jaꞌa jäyaꞌayhajxy yajnähixǿꞌøwät, jaꞌa Jesús jaꞌa miädiaꞌagy hajxy panǿcxäbä. ");
INSERT INTO mirNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mänitä Jesús miänáaṉgumbä: ―Simón, nej, xchójpøch miic̈hä. Mänitä Pedro yhadsooyy: ―Mnajuøøby miic̈h cooc̈h miic̈h njuøꞌøy nebiä hajch nebiä puhyaꞌayän. Mänitä Jesús miänaaṉ̃: ―Cueendähájtägøc̈hä nmeeghajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jaꞌa miädägøøghoocpä jaꞌa Simón Pedro ñämáayyägumbä: ―Simón, nej, jaduhṉc̈h xjwiøꞌøyä nebiä hajch nebiä puhyaꞌayän. Mänitä Pedro jiootmadiägøøyy coo miäyajtøøw̱a jaꞌa miädägøøghoocpä. Mänitä Pedro yhadsooyy: ―Cøx̱iä miic̈h mnajuøꞌøy. Mnajuøøby jaduhṉ cooc̈h miic̈h njuøꞌøy nebiä hajch nebiä puhyaꞌayän. Mänitä Jesús miänáaṉgumbä: ―Pues, yaghójcägøch jaꞌa nmeeghajxy. ");
INSERT INTO mirNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tehm̱ tiøyhájthøch miic̈h chaa nnämáꞌawät, coo hijty mdsucywiajyhatyñä, hamdsoo jaꞌa mwit hijty mbägøꞌøy. Mwädijp hijty maa jaꞌa mjoot hijty choquiän. Pero coo hänajty tøø mmäjaanä, mänit mgøꞌø mxajtøwaꞌañ. Mänitä wiinghänaꞌc jaꞌa mwit xyajpägøꞌøwaꞌañ. Mänit xyajnøcxaꞌañ maa jaꞌa mjoot hänajty quiaꞌa tsoquiän. ");
INSERT INTO mirNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Paadiä Jesús jaduhṉ miänaaṉ̃ nebiä Pedro jaduhṉ ñajuǿꞌøwät neby hänajty yaghoꞌogaꞌañii, nebiä Dios jaꞌa miäjaa jaduhṉ yajcähxǿꞌøgät jaꞌa Pedrocøxpä. Mänitä Jesús jaꞌa Pedro ñämaayy: ―Jam̱ hajxy wädíjtäm. ");
INSERT INTO mirNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Mänitä Pedro quioowiimbijty. Mänítøch xyhijxy cooc̈hä Jesús hänajty nbanøcxpä. Høøc̈h, Juánghøch høøc̈h. Høøc̈hä Jesús hijty xjiaanc̈h tehm̱ chojp. Høøc̈h jeꞌe häñaayy jaꞌa Jesús jaꞌa ñähmøjc mänaa højts ndsuugayyän. Høøc̈h jaduhṉ nyajtøøw̱: “Wiindsǿṉ, pøṉ miic̈h jaduhṉ xyegaam̱b.” ");
INSERT INTO mirNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Cooc̈hä Pedro xyhijxy, mänitä Jesús miäyajtøøyy: ―Wiindsǿṉ, yøꞌøyáꞌayäts, nej yøꞌøyaꞌay jiadaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Mänitä Jesús yhadsooyy: ―Caꞌa myiic̈hä mgüeentä yøꞌø pø chójpiøc̈hä njoot jaduhṉ coo yøꞌøyaꞌay hänajty jiinä cooc̈hä ngädaactägátsät. Pero miic̈h, panǿcxägøch jaꞌa nmädiaꞌagy. ");
INSERT INTO mirNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mänitä mädiaꞌagy jii wiädijty maa jaꞌa jäyaꞌayhajxiän jaꞌa Diosmädiaꞌagy hajxy panøcxpä cóogøch tyijy ngaꞌa hoꞌogaꞌañ. Pero cabä Jesús jaduhṉ miänaaṉ̃ cóogøch ngaꞌa hoꞌogaꞌañ. Nøm̱ jaduhṉ miänaaṉ̃: “Caꞌa myiic̈hä mgüeentä yøꞌø pø chójpiøch jaꞌa njoot jaduhṉ coo yøꞌøyaꞌay hänajty jiinä cooc̈h ngädaactägátsät.” ");
INSERT INTO mirNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Høøc̈h, Juánghøch høøc̈h. Tehm̱ tiøyhájthøch jaduhṉ tøø nhix̱y nébiøch chaa ngujaayän. Ñajuǿøbiøc̈hä njamiøødhajxy cooc̈hä tøyhajt nmøødä. ");
INSERT INTO mirNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Madiuꞌu jaꞌa Jesús jaduhṉ jiaanc̈h tuuṉ̃. Cábøch yam̱ cøx̱iä tøø ngujaay. Cooc̈h häxøpy cøx̱iä tøø ngujaay, cabä ndijy hädaa naax̱wiimbä miädøyhádät. Amén.");
INSERT INTO mirNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mäguꞌughajpä Teófilo, mänáajøch miic̈h jayøbajt nnäjaayøꞌøyän, mänítøch ngøx̱y cujahy nebiatiä Jesús yaa wiädijty hädaa yaabä naax̱wiin, møød nebiaty yajnähixøøyy, ");
INSERT INTO mirNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","4","mänaa jaduhṉ tiägøꞌøyän wädijpä høxtä coonä hänajty ñøcxtägatsaꞌañ tsajpootyp. Cahnä Jesús hänajty yhoꞌogyñä, tǿøyyämä jiamiøød hänajty wyiinguex̱y coo miädiaꞌagy yajwáꞌxäxät wiinduhm̱yhagajpt. Coo Jesús yhoꞌcy, mänit jiujypiøjtägajch. Coo Jesús jaduhṉ yhijxä jaꞌa jiamiøødhajxy, jaduhṉä tøyhajt hajxy miøødhajty coo Jesús hänajty tøø jiaanc̈h jujypiøjtägach. Coo Jesús jaduhṉ jiujypiøjtägajch, mänitä jiamiøød jiaac møødwädijty juxychäguiꞌxxøø. Jaduhṉä Jesús hänajty yajnähixøꞌøy coo Dios hajxy xyhanéhm̱äm jaꞌa miøcmäjaahaam. Coo juxychäguiꞌxxøø yhabejty, mänitä Jesús jaꞌa jiamiøød miøødhamugøøyy maa tuṉ hänajty xiøhatiän Olivostúṉ. Mänitä Jesús tiägøøyy hanehm̱bä jaꞌa Dioshespíritu miäjaahaam. Mänit miänaaṉ̃: ―Coo hajxy jim̱ mnøcxtägátsät Jerusalén, cab hajxy jim̱ mdsohṉdägátsät. Jim̱ hajxy jaduhṉ mjøbhíxøt cooc̈h mijtsä nDeedy jaꞌa yhEspíritu xyajnäguéxät nej mijts tøø nnämaꞌayän. Tøøc̈h mijtsä nDeedy xyhuuc yajwiinwaaṉøøbiä coo hajxy jaduhṉ xyajnäguexaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jaꞌa Juan, nøøhaam hijty miäyajnäbety. Tøyhajt jaduhṉ. Pero jaboom juxtøpc mijtsä Dios jaꞌa yhEspíritu xjiaanc̈h yajnäguexaꞌañ. Jaꞌa yhEspírituhaam hajxy jaduhṉ xyajnäbetaꞌañ ―nøm̱ä Jesús jaꞌa jiamiøød ñämaayy, jaꞌa hajxy hänajty tøø yhamugǿꞌøyäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mänitä Jesús miäyajtøøw̱ä: ―Wiindsǿṉ, nej, jaduhṉ miic̈h tøø mwiinmahñdyhatiä coo højtsä nmädsip mgaꞌa yajmäjädáacnädä, højts judíos, møød coo højtsä nhamdsoo mägunaax̱ ngobiernähájnät. ");
INSERT INTO mirNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mänitä Jesús yhadsooyy: ―Jaꞌa nDéedyhøc̈hä tøyhajt møød mänaa jaduhṉ yajtøjiadaꞌañ nej mijts myajtøyyän. Jeꞌe cuhdujt nidiuhm̱ møød coo jaduhṉ yajtøjiádät. Pero mijts, caj yhahixøꞌøy coo mijtsä tøyhajt mmøødhádät. ");
INSERT INTO mirNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Coo mijtsä Dioshespíritu xñägädáꞌagät, mänitä mäjaa hajxy xmioꞌowaꞌañ. Mänítøch hajxy jim̱ xmiädiáꞌagät Jerusalén cooc̈h tøø njujypiøjtägach, hóyhøch hänajty tøø nja hoꞌogy. Møød jim̱ hajxy xmiädiáacpät Judea‑naaxooty, møød jim̱ Samaria‑naaxooty, møød jim̱ wiinduhm̱yhagajpt høxtä mäduhṉ̃tiä cajpt quiugøxøꞌøyän. ");
INSERT INTO mirNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mänitä Jesús miädiaacpädøøyy. Jim̱ä Jesús hänajty wyiinheeꞌppedyii jaꞌa jiamiøødhajxy, mänitä Jesús näꞌä nägoobä chajpejty. Mänit hoy tiägøꞌøy jocjooty. Mänitä Jesús yhijxtägooyyä jaꞌa jiamiøødhajxy. ");
INSERT INTO mirNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jim̱ hajxy hänajty chajheebyñä, mänitä jäyaꞌayhajxy metsc ñäguehx̱tøøꞌxy jim̱ maa Jesús jaꞌa jiamiøødä wyiinduumhajxiän. Nähboobwit hajxy hänajty nämetsc. ");
INSERT INTO mirNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Mänitä Jesús jaꞌa jiamiøødhajxy ñämaayyä: ―Mäguꞌughajpädøjc, jim̱ hajxy mdsooñ Galilea maa Jesús chooñän. Mijtsä mmägunaax̱ yøꞌø. Quipxy hajxy hijty mmøødwädity. Caꞌa hajxy mwiꞌi yuugheeby. Caꞌa hajxy mwiꞌi tiajy mwiꞌi miay. Tøø Jesús jaduhṉ ñøcxnä tsajpootyp. Pero coo yhabáadät, mänit jaduhṉ wyiimbijtägatsaꞌañ neby hajxy tøø mhijxnøcxiän. ");
INSERT INTO mirNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mänitä Jesús jaꞌa jiamiøødhajxy jim̱ chohṉ̃ maa tuṉ hänajty xiøhatiän Olivos. Mänit hajxy ñøcxy Jerusalén. Tuꞌkilómetro hänajty jiäguem̱ä. ");
INSERT INTO mirNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jueꞌe Jesús jaꞌa jiamiøødhajxy hänajty xiøhaty: Pedro, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Simón jaꞌa Celote, møødä Judas. Nämetsc hajxy hänajty xiøhaty Santiago. Judas jaꞌa piuhyaꞌay jeꞌe jaꞌa tuꞌjäyaꞌaybä. Alfeo jaꞌa Judas jaꞌa tieedyhajxy hänajty xiøhaty. ");
INSERT INTO mirNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nax̱y hajxy hänajty yhamugøꞌøy Diospaꞌyaax̱pä nägøx̱iä, näguipxy møødä Jesús jaꞌa tiaj María, møødä Jesús jaꞌa piuhyaꞌayhajxy, møødä toꞌoxiøjc‑hajxy, jaꞌa Jesús hänajty quipxy tøø piawädityíijäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Cujaboom cumaax̱c, mänitä mäbøjpädøjc‑hajxy yhamugøøyy. Nämägoꞌx‑cu‑iiꞌx hajxy hänajty. Mänitä Pedro tiänaayyøꞌcy. Mänit miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","20","―Mäguꞌughajpädøjc, jéquiänä David quiujahy salmosjooty jaꞌa Judascøxpä, nebiatiä Dioshespíritu ñajtscapxøøyyä: Pactsacä tiøjc jiadaꞌañ; caj pøṉ jim̱ chänaꞌawaaṉnä. Jaꞌa Judas jaꞌa tiøjc jaduhṉ nänǿøm̱äxä. Jaduhṉ jim̱ miänaam̱bä coogä Judas wiingjäyaꞌay hänajty ñähduuṉduꞌudaꞌañii. Jaanc̈h tøjiajt jaduhṉ jaꞌa Judascøxpä nebiatiä David jecy quiujahyyän. Näguipxy højtsä Judas hijty xmiøødwädíjtäm. Näguipxy højts hijty xmiøødtuuṉmújcäm. Mänitä Judas wyiinmahñdyhajty coo Jesús ñähdúgät. Mänitä Judas jaꞌa jäyaꞌay wioomejch maa Jesús hänajtiän, jaꞌa Jesús hajxy hänajty madsaam̱bä. Coo Judas jaduhṉ haxøøg jiatcøøyy, mänit miäjuuyyä. Mänitä naax̱ hoy jiuy. Mänit hoy quiuhgahnax̱y cuhmänac. Coo miox̱tsäbijty, mänitä tyiinc̈h yhøx̱hänøøm̱bädsøøm̱y. Coo jäyaꞌayhajxy jaduhṉ miädoyhajty, jaꞌa hajxy hänajty jim̱ tsänaabiä Jerusalén, coo jaꞌa Judas hänajty tøø yhoꞌogy, mänitä naax̱ hajxy yajxøbejty Acéldama, jaꞌa Judas hänajty tøø jiúyyäbä; jaduhṉ miädiaꞌagytiägøꞌøy yhamdsoo hayuuc‑haambyhajxy, Nøꞌñaax̱. ");
INSERT INTO mirNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Jii højtsä nmäguꞌughajpähájtäm, näguipxy hajxy tøø xmiøødwädíjtäm mänaa Jesús hijty jiijän, mänaa Juan jaꞌa Jesús yajnäbetiän, høxtä coo Jesús chajpejty cøxp. Hahixøøby jaduhṉ coo hajxy tuꞌjäyaꞌay nwiinguéjxämät, jaꞌa Judas nähduuṉduꞌudaam̱bä. Näguipxiä mädiaꞌagy hajxy xmiøødyajwáꞌxämät coo Jesús tøø jiujypiøcy ―nøm̱ä Pedro miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mänitä jäyaꞌay metsc ñänøøm̱ä. Tuꞌug hänajty xiøhaty Matías. Jatuꞌugpä, tägøøgtuꞌu hänajty xiøhaty: José, Barsabás, Justo. ");
INSERT INTO mirNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mänitä Pedrohajxy tiägøøyy Diospaꞌyaax̱pä: ―Teedy, miic̈h mnajuøøby neby højts nägøx̱iä nwiinmahñdyhatiän. Højts hawáaṉäc mädyii miic̈h tøø mwiimbiy hädaahajxy nämetspä, ");
INSERT INTO mirNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mädyiibä Judas jaduhṉ nähduuṉdúꞌudäp. Coo Judas jaduhṉ quiädiehy, paadiä tiuuṉg yajtägooyy. Paady jiiby yhädaacy haxøøgtuum ―jaduhṉä Dios hajxy piaꞌyaax̱y. ");
INSERT INTO mirNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mänit hajxy yhäyøꞌcy suertehaam mädyii hänajty tuuṉgtägøꞌøwaam̱b. Mänitä Matías piaatä. Mänitä Matías hajxy quiumaayy, jaꞌa hajxy hänajty nämajtuꞌugpä. ");
INSERT INTO mirNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Coo Pentecostés‑xøø yhabaaty, mänitä mäbøjpädøjc‑hajxy nägøx̱iä yhamugøøyy. ");
INSERT INTO mirNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jiiby hajxy hänajty tøgooty yhäñaꞌay. Mänit hajxy miädooyy nebiä poj yhamuuyän coo møc piojy. Cøxp jaduhṉ chohṉdaacy. Møc jiiby yhawaaṉdsøøyy tøgooty. ");
INSERT INTO mirNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mänit hajxy nägøx̱iä ñägädaacä hanidiuhm̱jaty jaꞌa Dioshespíritäm. Jaduhṉ hänajty quiähxøꞌøgy nebiä tootsän, nebiä jøønhaayän. ");
INSERT INTO mirNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mänit hajxy nägøx̱iä yhadägøøyyä jioottägøøyyä jaꞌa Dioshespíritäm. Mänit hajxy tiägøøyy mädiaacpä wiinghayuucjaty. Jaꞌa Dioshespíritu hänajty jaduhṉ yajmädiaacp. ");
INSERT INTO mirNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tøø judíoshajxy hänajty nämay miech Jerusalén xøøhajpä. Wiinduhm̱yhagajpt hajxy hänajty chooñ. Paady hajxy miejch Jerusalén xøøjooty, quiudiunaam̱biä quiuhdujt hajxy hänajty jaduhṉ neby hajxy hänajty quiuhdujthatiän. ");
INSERT INTO mirNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","7","Coo judíoshajxy miädooyy coo poj hänajty møc yhamuuy jiiby tøgooty maa mäbøjpädøjc‑hajxy hänajty tøø yhamugøꞌøyän, mänitä judíoshajxy jiiby tiøjtägøøyy. Coo judíoshajxy jaduhṉ miädooyy coo mäbøjpädøjc‑hajxy hänajty quiapxy miädiaꞌagy wiinghayuucjaty, mänitä judíoshajxy wyiinjuøøyy yhamdsoo hayuuc‑haamby neby hajxy hänajty miädiaꞌaguiän majaty hajxy hänajty chooñ wiinduhm̱yhagajpt. Coo hajxy jaduhṉ miädooyy, mänit hajxy jiaanc̈h tehm̱ yagjuøøyy nägøꞌø nädecypiä. Mänit hajxy ñiñämaayyä: ―Yøꞌø jäyaꞌayhajxy xiiby capxpä mädiaacpä, haagä Galilea yøꞌø hajxy chooñ. ");
INSERT INTO mirNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tii hajxiädaꞌa coo tøø nmädóow̱äm nebiaty hajxy cøjwiinghayuuc tøø nmämíṉ tøø nmägaꞌawǿøyyäm. ");
INSERT INTO mirNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Hix̱, wiinduhm̱yhagajpt hajxy ndsóhṉäm, Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO mirNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Panfilia, Egipto, møød jim̱ Libia, Cirene mäwiingóṉ. Høxtä Roma hajxy näjeꞌe ndsóhṉäm, ");
INSERT INTO mirNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","møød Creta, møød Arabia. Näjeꞌe hajxy judíos nmämíṉ nmägaꞌawǿøyyäm. Näjeꞌe jaꞌa judíos quiuhdujt wyiinmahñdy hajxy tøø njøjpøgǿøyyäm neby hajxy quiuhdujthatiän. Coo yøꞌø Galileabä‑jäyaꞌayhajxy jaduhṉ tøø quiapxy tøø miädiaꞌagy wiinghayuucjaty nebiatiä Dios jaꞌa hoy‑yagjuǿøñäbä tøø yajcähxøꞌøgy, jaduhṉ hajxy tøø nwiinjuǿøyyäm jaꞌa nhamdsoo hayuuc‑haamby cøjwiinduum ―nøm̱ä judíoshajxy ñiñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Coo judíoshajxy jaduhṉ wyiinjuøøyy jaꞌa yhamdsoo hayuuc‑haamby, paady hajxy jiaanc̈h tehm̱ yagjuøøyy nägøꞌø nädecypiä. Mänit hajxy ñimiäyajtøøw̱ä: ―Tii yøꞌø jäyaꞌayhajxy coo quiapxy coo miädiaꞌagy wiinghayuucjaty, yøꞌø hajxy tsohm̱bä Galilea. ");
INSERT INTO mirNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mänit hajxy näjeꞌe yhadsooyy xiꞌigy hanähaty: ―Múucäp hajxiädaꞌa. ");
INSERT INTO mirNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","15","Mänitä Pedrohajxy tiänaayyøꞌcy møødä jiamiøødhajxy jaꞌa nämajtuꞌugpä, jaꞌa hajxy hänajty jaduhṉ Dioswiinguex̱ypä. Mänitä Pedro møc tiägøøyy mädiaacpä: ―Mäguꞌughajpädøjc, nägøx̱iä hajxy njudíoshájtäm mäduhṉ̃tiä hajxy yaa nyajpáatäm, mäduhṉ̃tiä hajxy jäguem̱ mdsooñ, møød mijts yaa tsohm̱bä Jerusalén. Näjeꞌe mijts mmänaꞌañ cooc tyijy højts nmuꞌugyii. Pero cab jaduhṉ tiøyyä. Cab jaduhṉ pøṉ yhuꞌugy jopyñä. ");
INSERT INTO mirNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Coo hajxy tøø mhix̱y tøø mmädoy coo højts tøø ngapxy tøø nmädiaꞌagy wiinghayuucjaty, jaanc̈h tøjiajt jaduhṉ nebiä Joel jecy quiujahyyän jaꞌa Dioscøxpä. Diosquex̱iä Joel hänajty. Jaduhṉä Joel jecy quiujahy: ");
INSERT INTO mirNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Jaduhṉä Dios miänaaṉ̃: Coo hänajty yhabaadaaṉnä coo naax̱wiimbä hänajty wyiimbidaaṉnä, mäníthøc̈hä nhEspíritu nguexaꞌañ maa jäyaꞌayhajxy nägøx̱iän, mäduhṉ̃tiä hajxy yaa yhity hädaa yaabä naax̱wiin. Y mijtsä mnøøx mmajc‑hajxy, mäníthøc̈hä nmädiaꞌagy hajxy xyajwaꞌxaaṉä. Jaꞌa høxcujc‑hänaꞌc‑hajxy, hoy‑yagjuøøñäjátyhøch hänajty nyajwiinhixaꞌañ. Jaanä jaduhṉä majjäyaꞌadiøjc‑hajxypä, nyajcumaꞌawáam̱biøch hajxy hänajty hoy‑yagjuøøñäjaty. ");
INSERT INTO mirNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Coo hänajty yhabaadaꞌañ, mäníthøc̈hä nhEspíritu nyajnäguexaam̱bä jaꞌa nmoonsähajxy, jaꞌa yaꞌaybä, jaꞌa toꞌoxypä. Mäníthøc̈hä nmädiaꞌagy hajxy xyajwaꞌxáaṉäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nyajcähxøꞌøgáam̱biøc̈hä hijxtahṉd hoy‑yagjuøøñäjatypä jim̱ tsajtcøxp møød hädaa yaabä naax̱wiin. Hochähgøøñäjátyhøch jaduhṉ nyajcähxøꞌøgaꞌañ nebiä nøꞌtiän, nebiä jøønän, nebiä jøønjocän. ");
INSERT INTO mirNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wiingoodsøꞌøwaam̱bä xøø hänajty. Jaꞌa poꞌo, tsapts hänajty yhanaꞌañ nebiä nøꞌtiän. Ja ween hänajty quiaꞌa habaadyñä cooc̈hä naax̱wiimbä nyajwiimbidaaṉnä, cooc̈hä nHuuṉg Jesucristo yaa quiädaactägatsaꞌañ hädaa yaabä naax̱wiin. Mänitä jäyaꞌayhajxy nägøx̱iä yajtøyhajtyegaꞌañii. Jadúhṉhøc̈hä nmøcmäjaa hänajty nyajcähxøꞌøgaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pønjatiä Jesucristo hänajty capxpaadaam̱b, jeꞌe hänajty hodiuum mähmøꞌøwaam̱b, nøm̱ä Dios miänaaṉ̃. Jim̱ jaduhṉ myiṉ̃ maa Joel jecy quiujahyyän. ");
INSERT INTO mirNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Mijts israelitas, huuc hamädoow̱hit hajxy hoy. Mnajuøøby hajxy jaduhṉ coo Dios jaꞌa Jesús jaꞌa Nazarettsohm̱bä wyiinguejxy coo jii tiúnät maa mijtsän. Madiuꞌu jaꞌa Jesús hijxtahṉd yajcähxøꞌcy hoy‑yagjuøøñäjatypä maa mijtsä mwiinduumhajxiän. ");
INSERT INTO mirNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tøø Dios hänajty yajnähdijy coo mijtsä Jesús mmádsät. Mänitä cahwiindøyhänaꞌc hajxy hoy myajcøꞌødägøꞌøy. Mänitä Jesús hoy miøjpahbedyii cruzcøxp. Mänit yhoꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero mänitä Dios jaꞌa Jesús yagjujypiøjtägajch. Jaduhṉä Dios hänajty tøø miänaꞌañ coogä Jesús tsipcøxp jiujypiǿgät. ");
INSERT INTO mirNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Hix̱, jaduhṉä David jecy miädiaacy jaꞌa Jesúscøxpä: Nnajuǿøbiøch jaduhṉ cooc̈h homiänaajä xpiuhbety. Homiänáajøch jaduhṉ xcwieendähaty, jadúhṉhøch pøṉ xquiaꞌa hadsähgǿꞌøwøt. ");
INSERT INTO mirNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Páadyhøch jootcujc njaanc̈h tehm̱ ñijiäwøꞌøyii. Páadyhøc̈hä Dios jootcujc nbaꞌyaꞌaxy. Cábøc̈hä nhoꞌog ndsähgøꞌøy jeꞌeguiøxpä cooc̈hä njuøhñdy nbädaꞌagy maa Diosän. ");
INSERT INTO mirNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Xyagjujypiøgáam̱bøch miic̈h jaduhṉ. Cábøch miic̈h jiiby jutjooty xyajmähmøꞌøwaꞌañ cooc̈h jiiby nbúꞌudsät, jeꞌeguiøxpä cooc̈h miic̈h xyHuunghaty. ");
INSERT INTO mirNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Xyagjugyhadáam̱bøch miic̈h cøjxtaꞌaxiøø nej miic̈h homiänaajä mjugyhatiän. Cooc̈h miic̈h jaduhṉ xmiøødhidaꞌañ tehṉgajnä, páadyhøch jootcujc nnijiäwøꞌøwaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Mänitä Pedro miänáaṉgumbä: ―Mäguꞌughajpädøjc, nmøødhájtämä tøyhajt hajxy jaduhṉ coo David jaduhṉ jecy quiaꞌa nimiädiaacä hamdsoo. Hix̱, coo David jecy yhoꞌcy, mänit hoy ñaax̱tägøꞌøy. Jiiby jaduhṉ yhityñä jutjooty høxtä jädaꞌanäbaadyñä. ");
INSERT INTO mirNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Coo David jaduhṉ jecy miädiaacy, ñajuøøby hänajty jaduhṉ coo yhapä yhoc hänajty tuꞌug wyiinguexáaṉäxä jaꞌa Diósäm, møød coo hänajty yhaneꞌemaam̱bä nebiä David jecy yhanehm̱iän. Tǿøyyämä Dios hänajty miänaꞌañ coo hänajty yajtøjiadaꞌañ coo David jaꞌa yhapä yhoc hänajty tuꞌug wiindsǿṉ tiunaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jaduhṉä David tøyhajt jecy miøødhajty coo Dios jaꞌa wyiinguex̱ypä yagjujypiøgaꞌañ coo hänajty tøø yhoꞌogy, møød coo hänajty quiaꞌa mähmøꞌøwaꞌañ jutjooty, møød coo ñiꞌxä quiopc hänajty jiiby quiaꞌa puꞌudaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jaꞌa Jesúscøxpä David jecy miädiaacy coo Jesús hänajty jiujypiøjtägatsaꞌañ. Tøø højts nhamdsoo hix̱y coo jiaanc̈h jujypiøjcy. ");
INSERT INTO mirNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mänitä Jesús jim̱ miøjyaax̱ä maa Tieediä wyiinduumän. Mänit ñämaayyä coo jim̱ yhøxtáꞌagät maa Tieediä yhahooyhaampiän. Mänitä Jesús jaa Tieediä yhEspíritu miooyyä nebiä Tieedy hänajty tøø yajwiinwaaṉøꞌøyiijän. Mänitä Jesús jaꞌa Tieediä yhEspíritu yaghawaꞌxøøyyä. Jeꞌe hajxy jaduhṉ tøø mhix̱y tøø mmädoy. ");
INSERT INTO mirNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Jaꞌa Jesúsäts jim̱ møjyaax̱ä tsajpootyp, caꞌa Diavitä. Hix̱, jaduhṉä David jecy miänaam̱bä: Jaꞌa høøc̈hä nWiindsǿṉ, jeꞌe jaduhṉ nämaayyä jaꞌa Tiéediäm: “Miṉ yaa häñaꞌaw maac̈h nhahooyhaampiän. ");
INSERT INTO mirNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Nmoꞌowáam̱biøch miic̈h cuhdujt jaduhṉ coo mmädsip mgaꞌa yajmäjädáꞌagät.” Jaduhṉä Dios jaꞌa yHuung ñämaayy. ");
INSERT INTO mirNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Mänitä Pedro miänáaṉgumbä: ―Jaduhṉds jeꞌe, jaꞌa Jesús, jaꞌa mijts mmøjpahbéjtäbä cruzcøxp, jeꞌe jaꞌa Dios jaduhṉ wyiinguejx coo hajxy nWiindsøṉhájtämät, coo hajxy xyajnähwáatsämät. Tøyhajt jaduhṉ. Hahixøøby jaduhṉ coo hajxy nägøx̱iä mmäbǿgät jaꞌa Jesúscøxpä, mijts israelitas. Caꞌa hajxy mgaꞌa mäbøcy ―nøm̱ä Pedro miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jaꞌa jäyaꞌayhajxy hänajty jiiby hamädoow̱hijpä, coo hajxy jaduhṉ miädooyy, mänit hajxy tiägøøyy tajpä maabiä hoyhoy. Mänitä Pedrohajxy ñämaayyä møødä jiamiøødtøjc: ―Mäguꞌughajpädøjc, neby jaduhṉ yhahixøꞌøy højts ngudiúnät. ");
INSERT INTO mirNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mänitä Pedro yhadsooyy: ―Najtshixøꞌøw jaꞌa mhaxøøgcuhdujt hajxy. Jøjpøgøøyyä jaꞌa Dios jaꞌa quiuhdujt hajxy. Näbet hajxy jaꞌa Jesucristocøxpä. Jaduhṉä Dios jaꞌa mbojpä mgädieeybä hajxy xyajnähwáatsät. Jaduhṉä yhEspíritu hajxy xmióobiät. ");
INSERT INTO mirNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pønjatiä Dios jaꞌa nWiindsøṉhájtämbä miøjyaax̱yp, jéꞌegädsä piojpä quiädieeybä yajnähwáatsäxäp, jéꞌegädsä Dios yhEspíritu mioꞌowaam̱by, møød mijts, møødä mhap møødä mhoc‑hajxy, møød pønjaty jäguem̱ tsänaaby. Jaduhṉ hajxy xyajwiinwaaṉǿøyyäm ―nøm̱ä Pedro miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Madiuꞌujä Pedro jiaac mädiaacy. Mänit jiaac tehm̱ miänaaṉ̃: ―Yøꞌø cahwiindøjiäyaꞌayhajxy, caꞌa hajxy tehṉgajnä mbahix̱y neby hajxy quiuhdujthatiän, coo hajxy jaduhṉ mnäꞌä padägóyyät ―nøm̱ä Pedro miägapxy yhanehm̱y. ");
INSERT INTO mirNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mänitä Pedro miädiaꞌagy miäbǿjcäxä nädägøøgmil‑jäyaꞌay. Mänit hajxy hoy nägøx̱iä ñäbety. ");
INSERT INTO mirNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Hamuumduꞌjoot hajxy hänajty miäbøcy nägøx̱iä neby hajxy hänajty yajnähixøꞌøyiijän jaꞌa apóstoldǿjcäm. Nax̱y hajxy hänajty yhamugøꞌøy tsajcaagyquiaamiujpä, møød hajxy hänajty Dyiospaꞌyaꞌaxy. Tuꞌugjoot tuꞌugwiinmahñdy hajxy hänajty yhity. Hamiṉ̃ haxøpy hajxy hänajty ñibiuhbedyii. ");
INSERT INTO mirNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Madiuꞌujä apóstoldøjcø hijxtahṉd hajxy hänajty yajcähxøꞌøgy hoy‑yagjuøøñäjaty. Jiaanc̈h tehm̱ yagjuøøbiä mäbøjpädøjc‑hajxy hänajty neby hajxy hänajty yhix̱iän. ");
INSERT INTO mirNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tuꞌugmädiaꞌagy hajxy hänajty yhity mäduhṉ̃tiä hajxy hänajty miäbøcy. Yajtuuṉmujpy hajxy hänajty tijaty hajxy hänajty miøød. ");
INSERT INTO mirNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mänit hajxy nägøx̱iä tiägøøyy tooꞌpä tijaty hajxy hänajty miøød. Pønjatiä xädøꞌøñ hänajty yajmaajiajp, mänitä xädøꞌøñ hajxy hänajty mioꞌoyii mäduhṉjaty hajxy hänajty yajmaajiaty. ");
INSERT INTO mirNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jabom̱‑jabom̱ hajxy hänajty yhamugøꞌøy maa møjtsajtøjcän Diospaꞌyaax̱pä. Jootcujc hajxy hänajty quiaamiucy yhuucmucy maa yhamdsoo tøjc‑hajxiän. Hojioot hajxy hänajty miøød. ");
INSERT INTO mirNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Wyiingudsähgøøbiä Dios hajxy hänajty. Møødä cuꞌug hajxy hänajty wyiingudsähgøøbiä. Jabom̱‑jabom̱ä mäbøjpädøjc‑hajxy hänajty yajmayøꞌøyii jaꞌa Diósäm. Jaduhṉ hajxy hänajty yajnähwaꞌac̈hii. ");
INSERT INTO mirNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tuꞌugxøøbä Pedrohajxy hänajty ñøcxy tsajtøgooty møødä Juan. Mänacyxiøø hänajty jeꞌe. Jaduhṉ hajxy hänajty quiuhdujthaty jabom̱‑jabom̱ coo hajxy mänacyxiøø Dyiospaꞌyaꞌaxy. ");
INSERT INTO mirNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jim̱ä paꞌamjäyaꞌay hänajty tuꞌug yhäñaꞌay maa tsajtøghaawän. Tecymiaꞌadä mähdiøjc hänajty tøø myiṉ̃ tøø quiaꞌay. Jabom̱‑jabom̱ hänajty jim̱ yajmec̈hii maa tsajtøjcän xädøꞌøñyujwaam̱bä. Jim̱ hänajty jabom̱‑jabom̱ ñajtshäñaꞌawøꞌøyii maa tsajtøghaawän, jaꞌa hänajty xøhajpä jaꞌa yajxoṉbä. Pønjaty hänajty jiiby tägøøby, mänitä xädøꞌøñ hajxy hänajty miäyujwaꞌañii jaꞌa paꞌamjäyaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Coo Pedrohajxy hänajty jiiby tiøjtägøꞌøwaꞌañ tsajtøgooty, mänit hajxy yhijxä jaꞌa paꞌamjäyaꞌay. Mänitä xädøꞌøñ hajxy miäyujwaaṉä. ");
INSERT INTO mirNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Mänitä Pedro jaꞌa mähdiøjc ñaax̱cuheebøøyy maa hänajty yhäñaꞌayän. Mänitä Pedro miänaaṉ̃: ―Højts wiinheeꞌppéjtäc. ");
INSERT INTO mirNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mänitä Pedrohajxy jiaanc̈h wiinheeꞌppejtä. Jaduhṉä mähdiøjcä yhaa jioot hänajty yagjaty coo xädøꞌøñ hänajty mioꞌowaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mänitä Pedro miänáaṉgumbä: ―Cab højtsä xädøꞌøñ nnäꞌä møødä tii højts miic̈h nnäꞌä móꞌowäp. Pero ndunaam̱by højtsä mayhajt maa miic̈hcøxpän. Jaduhṉ højts miic̈h nnämaꞌay coo mbädǿꞌøgät, coo myoꞌoyǿꞌøgät. Jaꞌa Jesucristocøxpä højts miic̈h jaduhṉ nnämaꞌay, jaꞌa hijty jim̱ tsohm̱bä Nazaret. ");
INSERT INTO mirNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Mänitä Pedro jaꞌa mähdiøjcä yhahooguiøꞌø miajtsä. Mänitiä jaꞌa mähdiøjcä tiecy miøgøøyy møødä tiecy‑yoꞌt. Coo Pedro wyidsøꞌcy, mänitä paꞌamjäyaꞌay tiøpxøꞌcy. Mänit yoꞌoyøꞌcy. Mänitä Pedrohajxy jiiby miøødtøjtägøøyyä tsajtøgooty. Tǿpxäp júhyyäp jaꞌa craa tiøjtägøøyy, jaꞌa hänajty tøø miøcpǿquiäbä. Mänit tiägøøyy Dioscapxpaatpä. ");
INSERT INTO mirNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Jiibiä jäyaꞌayhajxy hänajty nämay tsajtøgooty. Mänit hajxy yhijxy coo craa hänajty yoꞌoy, møød coo Dios hänajty quiapxpaady. ");
INSERT INTO mirNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mänitä craa yhøxcajpä coo hänajty jeꞌe jieꞌejä, jaꞌa hänajty jim̱ tøø xiädøꞌøñyujwáꞌañäbä maa tsajtøghaawän, jaꞌa hajxy hänajty tyijpiä jaꞌa jaanc̈h tehm̱ yajxoṉbä. Mänitä jäyaꞌayhajxy jiaanc̈h tehm̱ yagjuøøyy nägøꞌø nädecypiä coo craa hänajty tøø miøcpøcy. ");
INSERT INTO mirNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Jim̱ä Pedrohajxy hänajty tiänaꞌay maa hajxy hänajty tyijjiän Pórtico de Salomón, møødä Juan, møødä craa jaꞌa hänajty tøø miøcpǿquiäba. Cabä Pedrohajxy hänajty piuhwaꞌadsaꞌañii. Mänitä jäyaꞌayhajxy jim̱ ñøcxøøyy yagjuǿøyyäp maa Pedrohajxy hänajty tiänaꞌayän. ");
INSERT INTO mirNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Coo Pedro jaduhṉ yhijxy coo jäyaꞌayhajxy hänajty yagjuøꞌøy, mänitä jäyaꞌay ñämaayy: ―Mäguꞌughajpädøjc, israelitadøjc, tii hajxy jaduhṉ coo mwiꞌi yagjuøꞌøy. Tii højts jaduhṉ coo xwyiꞌi yheeby. Coo hädaa craa tøø miäbøcy jaꞌa Jesúscøxpä, paady jaduhṉ tøø yoꞌoyøꞌøgy, caꞌa jieꞌeguiøxpä coo højts mäjaa nmøødä, ni quiaꞌa jeꞌeguiøxpä coo højtsä Dios hoy nwiingudsähgøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","15","Jueꞌe hajxy jecy nhaphájtäm ndeedyhájtäm, jaꞌa Abrahamhajpä, møødä Isaac‑hajpä, møødä Jacobhajpä. Wyiingudsähgøøbiä Abraham jaꞌa Dios hajxy hänajty jegyhajty. Pero coo Dios jaꞌa yHuung Jesús yaa quiejxy hädaa yaabä naax̱wiin, cab hajxy mwiingudsähgøøyy. Mänit hajxy hoy mmach. Mänitä tuuṉgmøødpä hajxy hoy myajcøꞌødägøꞌøy. Mänitä Pilato jaꞌa Jesús jia yaghøxmadsaaṉä. Pero mijts, caj mijts jaduhṉ mmänaaṉ̃ coo Jesús yhøxmadsǿøjät, hoyyä Jesús tii pojpä tii cädieey hänajty quiaꞌa jagä møødä. Mänit mijtsä haxøøghänaꞌc mnäꞌägä nähdujcy coo yhøxmadsǿøjät, jaꞌa hänajty tøø jiäyaꞌay‑yaghóꞌoguiäbä. Mänit hajxy mmänaaṉ̃ coo Jesús yaghoꞌogǿøjät. Coo Jesús jaduhṉ yhoꞌcy, xyajnähwáatsäm hajxy jaduhṉ; jaanä jaduhṉ hajxy xyagjugyhadáaṉäm cøjxtaꞌaxiøø neby jeꞌe jiugyhatiän. Mänitä Dios jaꞌa Jesús yagjujypiøjtägajch. Jaduhṉä Dios jaꞌa Jesús yajmøjtägøøyy. Coo Jesús hänajty tøø jiujypiøcy, mänit højts nhijxy, paady højts tøyhajt jaduhṉ nmøødä. ");
INSERT INTO mirNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Hoorä, hädaa craa, mnajuøøby hajxy hijty coo hijty tiecymiaꞌadä. Mhíjxnäp hajxy jaduhṉ coo tøø choocnä. Paady tøø choꞌogy coo tøø miäbøcy jaꞌa Jesúscøxpä, coo Jesús møcmäjaa miøødä, møødä møccuhdujt. ");
INSERT INTO mirNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Mäguꞌughajpädøjc, huuc mädow̱ hajxy. Nnajuǿøbiøch jaduhṉ coo mijts hänajty mgaꞌa najuøꞌøy coo Jesús Dyioswiinguex̱iä, paady hajxy myajyaghoꞌcä. Ni jaꞌa mwiindsøṉhajxy hänajty quiaꞌa najuøꞌøy coo jeꞌe Dyiosquex̱iä. ");
INSERT INTO mirNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Jéquiänä Dios jaꞌa profetadøjc ñajtscapxøøyy coo Mesías hänajty tsipcøxp yhoꞌogaꞌañ, jaꞌa Dios hänajty tøø wyiinguéx̱iäbä. Jaduhṉä profetadøjc‑hajxy jiaanc̈h cujahy. Y coo Jesús jaduhṉ jiaanc̈h hoꞌcy, jaduhṉä Dios yajtøjiajty neby hänajty jecy tøø miänaꞌañän. ");
INSERT INTO mirNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Paadiä mhaxøøgcuhdujt hajxy mnajtshixǿꞌøwät. Jøjtägøøyyä jaꞌa Dios jaꞌa miädiaꞌagy hajxy. Jaduhṉä Dios jaꞌa mbojpä mgädieeybä hajxy xyajnähwáatsät. Y jaduhṉä hoybä weenbä hajxy xmióꞌowät. ");
INSERT INTO mirNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Coo yhabáadät, mänitä Dios jaꞌa Jesús yaa quiejxtägatsaꞌañ hädaa yaabä naax̱wiin, jaꞌa tøø wyiinguéx̱iäbä coo mijts xyajnähwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Cahnä yhabaady coo Jesús jim̱ chohṉdägátsät tsajpootyp, coo yaa miänajtägátsät hädaa yaabä naax̱wiin. Jim̱ jaduhṉ yhidaꞌaññä høxtä coonä yhabáadät coo Dios yaghoyøødiägátsät tijaty yaa hijp hädaa yaabä naax̱wiin. Jaduhṉä Dios jaꞌa profetadøjc jecy ñämaayy coo hajxy quiujáayät, jaꞌa Dios hänajty tøø wyiinguéx̱iäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Hix̱, jéquiänä Moisés jaduhṉ ñämaayy jaꞌa nhaphájtäm jaꞌa ndeedyhájtäm: “Tøøc̈hä Dios xwyiinguex̱y cooc̈hä profeta ndúnät. Coo yhabáadät, mänitä Dios tuꞌjäyaꞌay wyiinguexaꞌañ, jaꞌa højts nmägunáax̱äm. Jaduhṉ jeꞌe tiunaam̱bä profeta nébiøch nduṉ̃än. Nebiaty mijts xyhaneꞌemaꞌañ, mgudiúuṉäbä miädiaꞌagy hajxy. ");
INSERT INTO mirNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pønjaty hänajty caꞌa mäbøgaam̱b, yajcuhdägoyyáaṉäp hajxy hänajty jaꞌa cúꞌugäm”, nøm̱ä Moisés jecy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Jaduhṉä profetadøjc‑hajxy jecy miädiaacy nägøx̱iä nebiaty jädaꞌahaty jiadyii tiuñii, møødä Samuel, møød hajxy jaac túuṉäbä profeta. ");
INSERT INTO mirNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jaꞌa hajxy jecy túuṉäbä profeta, mänitä Dios hajxy ñajtscapxøøyyä coo mijtsä Dios xñämaayy coogä Dios jaꞌa Mesías hänajty wyiinguexaꞌañ mijtscøxpä. Jaanä jaduhṉduhm̱bä, jéquiänä Dios yajcuhdujcy møød højtsä nhaphájtäm møød højtsä ndeedyhájtäm coo Mesías hänajty wyiinguexaꞌañ mijtscøxpä. Hix̱, jaduhṉä Dios jaꞌa Abraham jecy ñämaayy: “Jaꞌa miic̈hä mhapä mhoccøxpä tuꞌug, jadúhṉhøc̈hä jäyaꞌay nägøx̱iä ngunuuꞌxaꞌañ wiinduhm̱yhagajpt”, nøm̱ä Dios jecy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Y coo Dios jaꞌa yHuung yagjujypiøjtägajch mänaa hänajty tøø yhoꞌoguiän, mijts jayøjp xyajnäguejx. Paady mijts jaduhṉ xyajnäguejxy coo mijts jaduhṉ xquiunúuꞌxät, coo weenä mhaxøøgcuhdujt hajxy jaduhṉ nägøx̱iä mnajtshixǿꞌøwät, ―nøm̱ä Pedro miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Jim̱ä Pedro jaꞌa cuꞌug hänajty miøødmädiaꞌagyñä tsajtøgooty, mänitä teedyhajxy miädoyhajty møødä saduceodøjc coogä Pedro jaꞌa cuꞌug hajxy hänajty yajnähixøꞌøy coogä Jesús hänajty tøø jiujypiøjtägach mänaa hänajty tøø yhoꞌoguiän. Coogä Jesús jaduhṉ jiujypiøjcy, jadúhṉägä Pedro tøyhajt hajxy hänajty miøødä coogä hoꞌogyjiäyaꞌayhajxy hänajty jiujypiøgaam̱bä. Coo teedyhajxy jaduhṉ miädoyhajty coogä Pedrohajxy hänajty jaduhṉ yajnähixøꞌøy, mänitä teedyhajxy jiaanc̈h tehm̱ jiootmaꞌty møødä saduceodøjc‑hajxy, møødä tsajtøjcueendähajpä wyiindsøṉhajxy. Mänitä Pedrohajxy ñämejtsä møødä Juan. ");
INSERT INTO mirNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mänitä Pedrohajxy hoy chumyii. Tøø hänajty chuujøꞌøy. Mänit hajxy jiiby yhijty pujxtøgooty tuꞌtsuhm̱. ");
INSERT INTO mirNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mänitä jäyaꞌayhajxy nämay miäbøjcy jaꞌa Jesúscøxpä, jaꞌa hajxy hänajty tøø miädóyyäbä nebiä Pedrohajxy yajnähixøøyyän tsajtøgooty. Nämägoox̱mil jaꞌa mäbøjpädøjc‑hajxy jaduhṉ jiajty, haagä yaꞌadiøjc. ");
INSERT INTO mirNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Cujaboom, mänitä judíos wyiindsøṉhajxy jim̱ yhamugøøyy Jerusalén, møødä majjäyaꞌadiøjc‑hajxy, møødä cuhdujtyajnähixøøbiädøjc‑hajxy, ");
INSERT INTO mirNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","møødä Anás, jaꞌa hänajty tuum̱bä teedywiindsǿṉ, møødä Caifás, møødä Juan, møødä Alejandro, møødä teedywiindsǿṉ jiujy miäguꞌughajxy. ");
INSERT INTO mirNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mänitä Pedrohajxy yajnøcxä møødä Juan jim̱ maa judíos wyiindsøṉhajxy hänajty tøø yhamugøꞌøyän. Mänitä Pedrohajxy piädaacä cujc. Mänit hajxy miäyajtøøw̱ä: ―Coo mijts hädaa craa tecymiaꞌadpä tøø myajtsoꞌogy, pøṉä quiuhdujthaam, pøṉä miäjaahaam hajxy jaduhṉ myajtsoocy. ");
INSERT INTO mirNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Haa jaꞌa Pedro, miøødä Dioshespíritu hänajty jeꞌe. Mänitä Pedro miänaaṉ̃: ―Mijts cuꞌugwiindsøṉdøjc, mijts majjäyaꞌadiøjc, ");
INSERT INTO mirNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mijts højts jaduhṉ xmiäyajtøøb neby højts hädaa mähdiøjc tøø nyajtsoꞌogy, hädaa hijty tecymiaꞌadpä. ");
INSERT INTO mirNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Huuc tuṉä mayhajt hajxy, huuc hamädoow̱hit hajxy weeṉ̃tiä neby højts cham̱ nmädiaꞌagaꞌañän maa mijtsä mwiinduumhajxiän. Jaduhṉä tøyhajt hajxy nägøx̱iä mmøødhádät møødä israelitadøjc‑hajxy nägøx̱iä neby hädaa mähdiøjc miøcpøjcy, hädaa hijty tecymiaꞌadpä, hädaa yaa tänaabiä mijtsä mwiinduum. Jaꞌa Jesucristo jaduhṉ yajmøcpøjc, caꞌa yhøjtsä. Nazaret jaꞌa Jesucristo hijty chooñ. Mänit mijts myajmøjpahbejtä cruzcøxp. Mänitä Dios yagjujypiøjtägajch. ");
INSERT INTO mirNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jaduhṉ jim̱ myiṉ̃ cujaay maa Diosmädiaꞌaguiän: “Jaa tsaa mädyiibä tøjcojpädøjc‑hajxy quiaꞌa cumaayy, jeꞌeds jaduhṉ jayøjp pädaactsohṉä jim̱ tøjteec.” Haa jaa Jesucristo, jaduhṉ jeꞌe miäbaady nebiä tsaajän, jaꞌa jayøjp jim̱ pädaactsóhṉäbä teectuum. Pero mijts, cab hajxy mgumaayy, paady hajxy myajyaghoꞌcä. ");
INSERT INTO mirNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jaayaꞌay hajxy jaduhṉ xyajnähwaats xyajcuhwáatsäm. Jaꞌa Dios jaduhṉ mänaaṉ coo Jesús hajxy jaduhṉ xyajnähwaats xyajcuhwáatsämät ―nøm̱ä Pedro miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Coo Pedrohajxy hänajty quiapxy hamøj jootmøj, paadiä møjtøjc‑hajxy hänajty yagjuøꞌøy. Hix̱, ñajuøøbiä møjtøjc‑hajxy hänajty coo Pedrohajxy hänajty quiaꞌa høxpøquiä. Mänitä møjtøjc‑hajxy ñajuøøyy coo Pedro jaꞌa Jesús hänajty tøø piawädity, paady hajxy hänajty quiapxy hamøj jootmøj. ");
INSERT INTO mirNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Cabä Pedrohajxy hänajty hoy quiapxhadugaꞌañii, jeꞌeguiøxpä coo hajxy hänajty piuhdänaꞌawøꞌøyii jaꞌa craa jaꞌa hänajty tøø chóꞌoguiäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mänitä Pedrohajxy jiiby yhøxquejxpädsøøm̱ä. Mänitä teedyhajxy tiägøøyy yajcapxiøøbiä: ");
INSERT INTO mirNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","―Neby hajxiädaꞌa nnäꞌä jatcǿøyyämät maa yøꞌø hänaꞌcøxpän. Mäduhṉ̃tiä cuꞌughajxy yaa chänaꞌay Jerusalén, quiøx̱y hix̱y quiøx̱y mädoy hajxy jaduhṉ coo yøꞌø hänaꞌc yøꞌø tecymiaꞌadpä hajxy tøø yajtsoꞌogy. Neby hajxy jaduhṉ nnäꞌä mänáaṉämät coo jaduhṉ quiaꞌa tøyyä neby yøꞌø hänaꞌc yøꞌø tecymiaꞌadpä hajxy tøø yajtsoꞌoguiän. Pero cab jaduhṉ yhahixøꞌøy coo yøꞌø capxy coo yøꞌø mädiaꞌagy jaduhṉ tehṉgahnä yhawaꞌxǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Hahixøøby jaduhṉ coo hajxy nhadsähgǿøyyämät, jaduhṉä dijuuntä Jesús hajxy tehṉgahnä quiaꞌa ja wiꞌi quiapxpáadät ―nøm̱ä teedyhajxy ñiñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mänitä Pedrohajxy yajmøjyaax̱ä møødä Juan. Mänit hajxy yhanehm̱ä coo Jesús hajxy quiaꞌa capxpáatnät, coo cuꞌug hajxy quiaꞌa yajnähixǿøñät jaꞌa Jesúscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mänitä Pedrohajxy yhadsooyy: ―Huuc wiinmahñdyhat hajxy waam̱bä Diosädaꞌa miänaꞌañ, pø hahixøøby jaduhṉ coo højts mijtsä mmädiaꞌagy ngudiúuṉämät, cahnä højtsä Dios jaꞌa miädiaꞌagy hänajty ngudiuuṉä. ");
INSERT INTO mirNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Caj pues, cab jaduhṉ yhahixøꞌøy coo højts mijtsä mmädiaꞌagy ngudiúuṉämät, cahnä højtsä Dios jaꞌa miädiaꞌagy hänajty ngudiuuṉä. Hoorä, jaduhṉ højtsä Dios tøø xyhaneꞌemy coo højtsä miädiaꞌagy tehṉgahnä ngapxwáꞌxät coo højtsä Jesús tøø nhijxjujypiøcy, coo højts tøø nmädoy nebiatiä Jesús tøø yajnähixøꞌøyän. Paady højts jaduhṉ ngaꞌa hamonaꞌañ ―nøm̱ä Pedrohajxy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Mänitä Pedrohajxy jadähooc yhadsähgøøyyä. Mänit hajxy yhøxmajtsä. Paady hajxy jaduhṉ yhøxmajtsä coo teedywiindsøṉhajxy hänajty quiaꞌa najuøꞌøy nebiä Pedrohajxy ñäꞌä tsaac̈htiunǿøjät. Hix̱, chähgøøbiä teedywiindsøṉä cuꞌug hajxy hänajty jeꞌeguiøxpä coo cuꞌugä Dios hajxy hänajty tehṉgahnä wyiꞌi quiapxpaady coo mähdiøjc tøø choꞌogy, jaꞌa hänajty tøø myiṉ̃ tøø quiáꞌayäbä tecymiaꞌad. Jiaanc̈h tehm̱ yagjuøøbiä cuꞌughajxy hänajty jaduhṉ, jeꞌeguiøxpä coo mähdiøjc juxychäguiꞌx nax̱y jomøjt hänajty miøødä, jaꞌa tøø chóꞌoguiäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Coo Pedrohajxy yhøxmájtsänä møødä Juan, mänit hajxy jim̱ ñøcxy maa jiamiøødhajxiän. Mänit hajxy quiøx̱y mädiaacy waam̱batiä teedywiindsøṉhajxy hänajty tøø miänaꞌañ, møødä majtøjc‑hajxy. ");
INSERT INTO mirNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Coo jiamiøødhajxy jaduhṉ miädooyy, mänit hajxy nägøx̱iä tiägøøyy Diospaꞌyaax̱pä: ―Diosteedy, miic̈h højts nWiindsøṉhajpy. Miic̈hä tsajt jaduhṉ mhädiuuṉ møød hädaa yaabä naax̱wiin, møødä mejy, møød tijaty jim̱ hijp tsajtcøxp, møød hädaa yaabä naax̱wiin, møød jiiby mejjiooty. ");
INSERT INTO mirNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Jaduhṉ miic̈hä David jecy mnajtscapxøøyyä jaꞌa mhEspírituhaam: Näꞌä nägoobä jäyaꞌayhajxy yhawaꞌandaꞌagy, jaꞌa Dios hajxy caꞌa wiingudsähgøøbiä. Xiøøbä hajxy ñäꞌä wiinmahñdyhaty, cab hajxy tii yhoyǿøyyäxä. Mänitä gobiernähajxy yhamugøøyy, jaꞌa hajxy yaa hanehm̱bä hädaa yaabä naax̱wiin. Mänitä Dios hajxy jia näbädøꞌcy. Jaanä Mesías jaduhṉ ja näbädǿꞌcäbä, jaꞌa Dios hänajty wyiinguexaam̱biä, nøm̱ä David jecy miänaaṉ̃, jaꞌa miic̈h jecy mmoonsähájtäbä, jaꞌa højts jecy nhaphajt ndeedyhájtäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Coo Jesús jaduhṉ miajtsä, mänitä Herodeshajxy yaa yhamugøøyy juntahajpä yaa Jerusalén, møødä Poncio Pilato, møødä israelitahajxy, møødä jäyaꞌayhajxy caꞌa israelítabä. Jaduhṉ jiaanc̈h tøjiajty nebiä David jecy jiaanc̈h mänaaṉ̃än. Mänitä Herodes jaꞌa Jesús hajxy ñähwaam̱bejty, hoyyä Jesús hänajty tii cädieey quiaꞌa jagä møødä. Miic̈hä mHuung jeꞌe. Miic̈h jeꞌe mwiinguejx coo Mesías tiúnät. ");
INSERT INTO mirNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tǿøyyäm miic̈h hänajty jaduhṉ mmänaꞌañ coo Jesús hänajty jaduhṉ tsipcøxp jiadaꞌañ yhabetaꞌañ, paady miic̈h jaduhṉ waam̱b mgaꞌa mänaaṉ̃ coo Jesús jaduhṉ jiaanc̈h jajty jiaanc̈h habejty. ");
INSERT INTO mirNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Hoorä, Diosteedy, mnajuøøby miic̈h jaduhṉ coo højtsä teedywiindsøṉdøjc tøø xjia hadsähgøꞌøy. Højts miic̈h jaduhṉ xmioonsähajp. Højtsä mäjaa jaac móoyyäc, jaduhṉ højts miic̈hä mmädiaꞌagy jaduhṉ hoy njaac yaghawaꞌxǿøyyät hamøj jootmøj. ");
INSERT INTO mirNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Højts jaac puhbéjtäc, jaduhṉ højtsä paꞌamjäyaꞌay nyajmøcpǿgät jaꞌa miic̈hä mHuungä miäjaagøxpä, jaꞌa Jesúshajpä, weenä cuꞌughajxy jaduhṉ jiaanc̈h tehm̱ yagjuøꞌøy nej mijtsä møcmäjaa hajxy mjaanc̈h tehm̱ miøødä ―nøm̱ä Pedro jaꞌa Dios hajxy piaꞌyaax̱y. ");
INSERT INTO mirNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Coo Pedrohajxy jaduhṉ Dyiospaꞌyaax̱pädøøyy, mänit jim̱ chäyuuyy maa hajxy hänajty tøø yhamugøꞌøyøn. Mänitä Dioshespíritu hajxy nägøx̱iä yhadägøøyyä jioottägøøyyä. Mänitä Diosmädiaꞌagy hajxy tiägøøyy yajwaꞌxpä hamøj jootmøj. ");
INSERT INTO mirNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tuꞌugjoot tuꞌugwiinmahñdiä mäbøjpädøjc‑hajxy hänajty nägøx̱iä. Mäduhṉjaty hajxy hänajty miøødä cøx̱iä wiinä, tuꞌugmucy hajxy hänajty yajtuuṉmucy. Cab hänajty pøṉ miänaꞌañ coo hänajty nidiuhm̱ jieꞌehaty. ");
INSERT INTO mirNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Haa jaꞌa apóstoldøjc‑hajxy, Diosmäjaamøød hajxy hänajty quiapxy miädiaꞌagy coogä Jesús hänajty tøø jiujypiøcy, jaꞌa hajxy nWiindsøṉhájtämbä. Jaanc̈h tehm̱ piuhbéjtäp hajxy hänajty nägøx̱iä jaꞌa Diósäm. ");
INSERT INTO mirNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Cab hänajty pøṉ tii yajmaajiaty. Hix̱, pønjatiä naax̱ hänajty møød, møødä tøjc, tiooꞌpy hajxy hänajty. Pønjaty hänajty tøø ñaax̱toogy tøø tiøjtoogy, ");
INSERT INTO mirNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mänitä xädøꞌøñ hajxy hänajty yecy maa apóstoldøjc‑hajxiän. Mänitä mäbøjpädøjcä xädøꞌøñ hajxy hänajty yajniñäwaꞌxøꞌøyii pønjaty hänajty yajmaajiajp. ");
INSERT INTO mirNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jim̱ä mäbøjpä hänajty tuꞌug xiøhaty José. Chiprenaaxooty hänajty chooñ. Jaꞌa Leví jaꞌa José hänajty jegyhajty tøø yhaphaty tøø tieedyhaty. Bernabé jaꞌa José yajxøbejtä jaꞌa apóstoldǿjcäm. (Jueꞌe Bernabé miädiaꞌagytiägøꞌøy hahebreohaam, “mäjootcapxmøcpøjp.”) ");
INSERT INTO mirNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jim̱ä José naax̱cam̱ hänajty miøødä. Mänit tiooꞌcy. Mänitä xädøꞌøñ hoy yecy maa apóstoldøjc‑hajxiän. ");
INSERT INTO mirNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Jim̱ä jäyaꞌay hänajty tuꞌug xiøhaty Ananías. Safira jaꞌa tioꞌoxiøjc hänajty xiøhaty. Mänitä ñaax̱ hajxy jeꞌe piadooꞌpä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tøø hajxy hänajty quiojyquiapxytiuṉ̃ møødä tioꞌoxiøjc coogä xädøꞌøñ hajxy hänajty cujjiä yegaꞌañ maa apóstoldøjc‑hajxiän. Cújjiäc hajxy hänajty miämähmøꞌøwaꞌañ. Coo Ananías jaꞌa Pedro jaꞌa xädøꞌøñ yajnämejch, mänitä Ananías miänaaṉ̃ cooc tyijy jaꞌa xädøꞌøñ hänajty tøø quiøx̱y yecy mäduhṉ̃tiä hänajty tøø tioogy. ");
INSERT INTO mirNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","4","Mänitä Pedro miänaaṉ̃: ―Ananías, coo miic̈hä mnaax̱ tøø mdoogy, cujjiä xädøꞌøñ tøø mmämähmøꞌøy mäduhṉ̃tiä tøø xquiujuuyyä. Cooc̈h miic̈hä xädøꞌøñ cujjiä tøø xmioꞌoy, jaduhṉ miic̈h tøø mmänaꞌañ cooc̈h tyijy cøx̱iä tøø xmioꞌoy. Coo naax̱ hänajty mgaꞌa toogyñä, mjeꞌehajpyñä hänajtyñä. Coo tøø mdooꞌnä, miic̈h mjeꞌe hijty jeꞌe jaꞌa naax̱tsow̱. Coo jaduhṉ tøø mhøhṉdaꞌagy, mgädiehy jaduhṉ. Jaꞌa Dios miic̈h mja wiinhøønaaṉ, caꞌa yhøjtsä. Jaꞌa møjcuꞌugong miic̈h jaduhṉ xyajcapxtägooyy, paadiä Dioshespíritu jaduhṉ mja wiinhøønaaṉ̃ ―nøm̱ä Ananías ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Coo Ananías jaduhṉ miädooyy, mänitiä hoꞌogy quiädaayy. Pønjaty jaduhṉ mädoyhajt coo Ananías jaduhṉ yhoꞌcy, mänit hajxy chähgøøbiøjcy. ");
INSERT INTO mirNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mänitä høxcujc‑hänaꞌc‑hajxy näjeꞌe miejch. Mänitä hoꞌogyjiäyaꞌay hajxy ñähbijty. Mänit hajxy hoy yajnaax̱tägøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Cudägøøghorä, mänitä Ananías tioꞌoxiøjc piamejtspä, jaꞌa hänajty xøhajpä Safira. Cahnä Safira hänajty miädoyhatyñä coo ñihyhap hänajty tøø yhoꞌogy. Mänitä Safira tiøjtägøøyy maa Pedro hänajtiän. ");
INSERT INTO mirNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Mänitä Pedro jaꞌa Safira miäyajtøøyy: ―Nej, jaduhṉä mnaax̱ hajxy mjaanc̈h yejquiä, neby hajxy tøø mnägapxiän. ―Jaduhṉ ―nøm̱ä Safira yhadsooyy. ");
INSERT INTO mirNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Mänitä Pedro miänáaṉgumbä: ―Tii hajxy coo mja cojyquiapxytiuuṉ̃ coo hajxy hänajty mhøhṉdaꞌagaꞌañ. Nej, cab hajxy mnajuøꞌøyä coo Dioshespíritu hotyiijä yajcopcøꞌøy. Cab hajxy jaduhṉ hoy mwiinhǿønät. Coo mnihyhap yhøhṉdaacy, paady tøø yhoꞌogy. Xii hänaꞌc‑hajxy jeꞌe tiøjtägøꞌøy, jaꞌa hajxy hoy tøø miäyajnaax̱tägǿꞌøyäbä. Nøcxaam̱b miic̈h yøꞌø hänaꞌc xyajnaax̱tägøꞌøwaam̱bä ―nøm̱ä Safira ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tuuṉä Safira jaduhṉ ñäꞌä mädooyy, mänitiä Pedro tiecyquiädaw̱øøyyä hoꞌogy. Coo høxcujc‑hänaꞌc‑hajxy tiøjtägøøyy, mänitä Safira hajxy yhijxy coo hänajty tøø yhoꞌogy. Mänit hajxy yhøxcøøbiädsøøm̱y. Mänit hajxy hoy yajnaax̱tägøꞌøy maa ñihyhapä ñähmøjcän. ");
INSERT INTO mirNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Pønjaty jaduhṉ mädoyhajt nebiä Ananíashajxy hänajty tøø jiaty tøø yhabetiän, mänit hajxy nägøx̱iä chähgøøbiøjcy, møødä mäbøjpädøjc‑hajxy nägøx̱iä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mänitä apóstoldøjc‑hajxy jim̱ tiägøøyy mäbaꞌamyajnajxpä cajptooty. Jaanc̈h tehm̱ yhoy‑yagjuøøñä hajxy hänajty tiuṉ̃. Jaduhṉ hajxy hänajty yajcähxøꞌøgy coo Dios mäjaa jiaanc̈h tehm̱ miøødä. Jim̱ä mäbøjpädøjc‑hajxy hänajty yhamugøꞌøyhaty tsajtøgooty maa hänajty xiøhatiän jaꞌa Pórtico de Salomón. ");
INSERT INTO mirNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","14","Tehṉgahnä mäbøjpädøjc‑hajxy hänajty miayøꞌøy näyaꞌay‑nädoꞌoxy, jaꞌa hajxy hänajty mäbøjpä jaꞌa Jesucristocøxpä. Haa jaꞌa jäyaꞌayhajxy hänajty caꞌa mäbøjpä, cab hajxy hänajty jim̱ ñäꞌägädä nøcxy maa mäbøjpädøjc‑hajxy hänajty nax̱y yhamugøꞌøyän, hoyyä mäbøjpädøjc‑hajxy hänajty jiaanc̈h tehm̱ quiumayii jaꞌa cúꞌugäm. Paady hajxy hänajty jim̱ quiaꞌa nøcxaꞌañ, jaꞌa hajxy hänajty caꞌa mäbøjpä, coo hajxy hänajty chähgøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Coo apóstoldøjcä paꞌamjäyaꞌay hajxy hänajty may yajmøcpøcy, paadiä paꞌamjäyaꞌayhajxy hänajty jim̱ quiøøñøcxyii tuꞌhaam maa Pedro hänajty ñaxøꞌøwaꞌañän. Jadúhṉägä paꞌamjäyaꞌayhajxy jaduhṉ näjeꞌe miøcpǿgät coogä Pedro yhahapc hajxy ñäꞌä páatät maa hajxy hänajty quioꞌnaꞌayän cøjxcøxp, møød toꞌogyquiøxp. ");
INSERT INTO mirNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mayyä paꞌamjäyaꞌayhajxy hänajty jim̱ yajmec̈hii Jerusalén, møød jaꞌa hajxy haxøøgpä caꞌa hoybä møødpä, jaꞌa hajxy hänajty tsohm̱bä Jerusaléncajptpaꞌa mäwiingóṉ. Nägøx̱iä hajxy hänajty yajmøcpøgyii. ");
INSERT INTO mirNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Coo teedywiindsøṉhajxy jaduhṉ miädoyhajty coo paꞌamjäyaꞌayhajxy hänajty may tøø wyiꞌi miøcpøcy, mänit hajxy nägøꞌø nädecypiä jiootmaꞌty, møødä saduceodøjc‑hajxy. Hix̱, cabä apóstoldøjc‑hajxy hänajty yajmädsogyii coo hajxy hänajty tehṉgahnä wyiꞌi yajnähixøꞌøy jaꞌa Jesúscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mänitä apóstoldøjc‑hajxy hoy chumyii. ");
INSERT INTO mirNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mänitcoodsä Diosmoonsä jaꞌa pujxtøghaaw hoy yaghawaꞌac̈h. Mänitä apóstoldøjc‑hajxy yhøxwoobädsøøm̱ä jaꞌa Diosmóonsäm. ");
INSERT INTO mirNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Mänit hajxy ñämaayyä: ―Coo jiobǿꞌøwät, mänit hajxy jim̱ mnǿcxät maa tsajtøjcän. Jim̱ä cuꞌug hajxy myajnähixǿꞌøwät neby hajxy ñähwáꞌadsät, neby hajxy jaduhṉ jiugyhádät cøjxtaꞌaxiøø nebiä Dios jiugyhatiän ―nøm̱ä Diosmoonsä miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Coo jiobøøyy, mänitä apóstoldøjc‑hajxy jim̱ jiaanc̈h nøcxy tsajtøgooty neby hajxy hänajty tøø ñämaꞌayiijän jaꞌa Diosmóonsäm. Mänitä cuꞌug hajxy tiägøøyy yajnähixøøbiä. Mänitä teedywiindsøṉhajxy miänaaṉ̃ coo hajxy nägøx̱iä yhamugǿꞌøwät juntahajpä, møødä majtøjc‑hajxy israelítabä. Mänit hajxy miänaaṉ̃ coo tsum̱yhänaꞌc‑hajxy jim̱ yajmedsǿøjät maa junta hajxy hänajty yagjadyiijän. ");
INSERT INTO mirNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Coo policíashajxy jim̱ miejch maa pujxtøjcän, cab pøṉ hänajty jiibiän. Mänitä policíashajxy wyiimbijty. ");
INSERT INTO mirNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Mänit hajxy miänaaṉ̃: ―Coo højts jim̱ nmejch maa pujxtøjcän, jeꞌenä hänajty hoy yhaawguiic̈hä. Jim̱ä soldadohajxy hänajty yhadänaꞌayñä maa pujxtøghaawän. Pero coo højts jiiby nja tøjtägøøyy, cab pøṉ hänajty jiibiän ―nøm̱ä policíashajxy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Coo teedywiindsøṉhajxy jaduhṉ miädooyy, møødä tsajtøjcueendähajpä wyiindsøṉhajxy, møødä møjteedywiindsǿṉ, mänit hajxy jiaanc̈h tehm̱ yagjuøøyy. Cab hajxy hänajty ñajuøꞌøy tii hänajty jájtäp túuṉäp. ");
INSERT INTO mirNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mänitä jäyaꞌay tuꞌug miejch maa teedywiindsøṉhajxy hänajty jiuntahatiän. Mänitä craa miänaaṉ̃: ―Xim̱ä cuꞌug wyiꞌi yajnähixǿøyyägumbä tsajtøgooty ―nøm̱ä teedywiindsøṉhajxy ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mänitä apóstoldøjc‑hajxy hoy wioyii. Jaꞌa tsajtøjcueendähajpähajxy hoy miäwoy møødä policíashajxy. Hahoy haweenä apóstoldøjc‑hajxy jaduhṉ jim̱ yajmejtsä maa junta hänajty jiadyiijän. Hix̱, tsähgøøbiø policíashajxy hänajty coo hajxy ñäꞌä pagaꞌads ñäꞌä pawobǿøjät jaꞌa cúꞌugäm. ");
INSERT INTO mirNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Coo apóstoldøjc‑hajxy jim̱ wioomejtsä maa junta hänajty jiadyiijän, mänit hajxy jim̱ yajnøcxä maa møjteedywiindsøṉä wyiinduumän. Mänitä apóstoldøjc‑hajxy ñämaayyä: ");
INSERT INTO mirNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Tøø højts mijts nja nämaꞌay coo hajxy mgaꞌa näꞌägädä yajnähixǿøñät jaꞌa dijuuntä Jesúscøxpä. Pero cab højts mijtsä nmädiaꞌagy tøø xquiudiuuṉä. Tøø cuꞌug hajxy jaduhṉ mgøx̱y yajnähixøꞌøy, mäduhṉ̃tiä hajxy yaa chänaꞌay Jerusalén. Y højts mijts jaduhṉ xjia wiꞌi yajnähdsømaam̱b cooc tyijy højtsä dijunto Jesús nyajyaghoꞌcä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mänitä Pedrohajxy yhadsooyy møødä jiamiøødhajxy: ―Cab yhahixøꞌøy coo højtsä jäyaꞌay miädiaꞌagy ngudiúuṉät, cahnä højtsä Dios miädiaꞌagy hänajty ngudiuuṉä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Coo mijtsä Jesús myajyujmänooṉä cruzcøxp, mänitä Dios jaꞌa Jesús yagjujypiøjtägajch, jaꞌa højtsä nhapä ndeedyhájtäm jecy wyiingudsähgǿøyyäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mänitä Dios jaꞌa Jesús cuhdujt miooyy coo Jesús jim̱ miähanéꞌemät tsajpootyp maa Dios yhahooyhaampiän. Coo judíos jaꞌa yhaxøøgcuhdujt hajxy ñajtshixǿꞌøwät, jaduhṉä piojpä quiädieeybä hajxy jaduhṉ yajnähwaats yajcuhwáatsäxät Jesúsäm. ");
INSERT INTO mirNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Højtsä tøyhajt nyejpy coo Jesús jiujypiøjtägajch coo hänajty tøø yhoꞌogy. Jaanä jaduhṉä Dioshespíritu tøyhajt yejpä coo Jesús jiujypiøjcy. Pønjatiä Dios jaꞌa miädiaꞌagy jaduhṉ cudiúuṉäp, jeꞌe jaꞌa Dios jaꞌa yhEspíritu miooby ―jaduhṉä Pedrohajxy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Coo teedywiindsøṉhajxy jaduhṉ miädooyy, mänit hajxy jiaanc̈h tehm̱ jiootmaꞌty. Mänit hajxy jaduhṉ jia mänaaṉ̃ coo Pedrohajxy yaghoꞌogǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Jim̱ä fariseo hänajty tuꞌug teedywiindsøṉhagujc. Jueꞌe hänajty xiøhaty Gamaliel. Ley‑yajnähixøøbiä hänajty tiuuṉghajpy. Jaanc̈h tehm̱ wyiingudsähgǿøyyäp hänajty jeꞌe jaꞌa cúꞌugäm. Mänit tiänaayyøꞌcy. Mänit yhanehm̱y coo apóstoldøjc‑hajxy nøcxy yajpädsøm̱yii tuꞌhabaquiä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mänitä Gamaliel jaꞌa jiamiøødtøjc ñämaayy: ―Mäguꞌughajpädøjc, huuc wiinmahñdyhat hajxy hodiägaamby neby yøꞌø hänaꞌc hajxy mdunaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Huuc jahmiets hajxy nebiä Teudas jecy jiajtiän. Mänit jootmøj ñibiädaacä. Mänit ñiñänøøm̱ä cooc tyijy miøjjäyaꞌay jiaanc̈hjäyaꞌayä. Mänit piaduꞌubøjcä nämädaax̱mägoꞌx jäyaꞌay. Mänitä Teudashajxy tiägøøyy tsiptuum̱bä. Mänitä Teudas yaghoꞌcä. Jaꞌa soldadohajxy jaduhṉ mäyaghoꞌc. Mänitä Teudas jiamiøødhajxy xii yaa ñøcxøøyy. Mänitä tsip jaduhṉ yhamaadiujnä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mänitä tsip wiingpä jadähooc chohṉdáaccumbä mänaa censo hajxy hänajty yajpädøꞌøguiän. Jaꞌa craa Judas jaꞌa tsip jaduhṉ yajtsohṉdaac, jaꞌa hänajty jim̱ tsohm̱bä Galilea. Mänitä cuꞌug may piaduꞌubǿjcäbä. Mänitä Judas yaghóꞌcäbä jaꞌa soldadohajxy. Jaduhṉä Judas jiamiøødhajxy xii yaa ñøcxøøbiä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Paady, høxmats yøꞌø hänaꞌc hajxy. Cab jaduhṉ yhahixøꞌøy coo hajxy nej mdúnät. Hix̱, pø yhamdsoo wiinmahñdy hajxy jaduhṉ yajtuum̱by, cab jaduhṉ yhoyǿꞌøwät; tuꞌumáꞌadäp jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero pø yøꞌø hänaꞌcä Dios wyiinmahñdy hajxy yajtúuṉäp, cab hajxy jaduhṉ hoy mgapxhadúgät. Hix̱, jaduhṉ quiähxǿꞌøgät nejpiä Dios hajxy hänajty mmädsiphajpiän ―jaduhṉä teedywiindsøṉhajxy ñämaayyä. Jiaanc̈h mäbøjc hajxy jaduhṉ nebiä Gamaliel miänaaṉ̃än. ");
INSERT INTO mirNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mänitä apóstoldøjc‑hajxy jadähooc quiuyaaxøøyyä tøgooty. Mänit hajxy wiobhoꞌcä. Mänit hajxy yhanehm̱ä coo Jesús hajxy quiaꞌa capxpáatnät. Mänit hajxy ñajtsmadsøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Xooṉdáacäp hajxy tiøjpädsøøm̱y maa junta hänajty jiadyiijän. Paady hajxy hänajty xiooṉdaꞌagy, hix̱, hahixøøby hänajty jaduhṉ coo hajxy hoc̈hähdiuuṉnä chaac̈hpǿgät jaꞌa Jesúscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mänit hajxy tiägǿøguiumbä yajnähixøøbiä jaꞌa Jesúscøxpä, tsajtøgooty møød tøgootypaady. Tehṉgahnä hajxy hänajty yajnähixøꞌøy jøjwidsøꞌø. ");
INSERT INTO mirNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tehṉgahnä mäbøjpädøjc‑hajxy hänajty jiaanc̈h tehm̱ miayøꞌøy. Jaduhṉ hajxy hänajty quiuhdujthaty coo yaamgtoꞌoxy cay huꞌugy hajxy jabom̱‑jabom̱ mioꞌowǿøjät. Cujwaꞌxiä mäbøjpädøjc‑hajxy hänajty quiapxy hagriego. Cujwaꞌxiä hajxy hänajty quiapxy hahebreo. Jaꞌa hajxy hänajty capxpä hagriego, mänit hajxy tiägøøyy mänaam̱bä coo yaamgtoꞌoxy cay huꞌugy hajxy hänajty pedyii quiaꞌa móoyyänä, jaꞌa hajxy hänajty capxpä hagriego. Høxtä yajtsip yajmaꞌadøøby hajxy hänajty jaꞌa yaamgtoꞌoxycøxpä. ");
INSERT INTO mirNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mänitä apóstoldøjc jaꞌa nämajmetspähajxy miänaaṉ̃ coo mäbøjpädøjc hajxy nägøx̱iä yhamugǿꞌøwät. Mänitä apóstoldøjc‑hajxy miänaaṉ̃: ―Mäguꞌughajpädøjc, cab jaduhṉ yhahixøꞌøy coo højtsä cay huꞌugy njaac yajwáꞌxät tehṉgahnä. Hix̱, cab højtsä Diosmädiaꞌagy jaduhṉ hoy ngapxwaꞌxaaṉnä. ");
INSERT INTO mirNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Paadiä, hahixøøby jaduhṉ coo hajxy mniwyiimbiwǿøjät näjuxtujc coo cay huꞌugy hajxy yajwáꞌxät. Jueꞌe hajxy mwiimbíwäp mädyii hoyhänaꞌc, mädyii Dioshespíritumøød, mädyii jajp najuøøby. ");
INSERT INTO mirNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Y højts jaꞌa nämajmetspä, tehṉgahnä højtsä Dios nbaꞌyaꞌaxaꞌañ. Tehṉgahnä højtsä miädiaꞌagy nyajnähixøꞌøwaaṉä ―nøm̱ä apóstoldøjc‑hajxy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mänitä mäbøjpädøjc‑hajxy nägøx̱iä cojyquiapxy miähmøøyy pønjaty hajxy hänajty wyiimbiwaam̱by. Jueꞌe hajxy jaduhṉ wiimbiiw̱ä, jaꞌa Esteban, møødä Felipe, møødä Prócoro, møødä Nicanor, møødä Timón, møødä Parmenas, møødä Nicolás. Haa jaꞌa Esteban, hoyyä Diosmädiaꞌagy hänajty jiaanc̈h tehm̱ miäbøcy. Miøødä Dioshespíritu hänajty jeꞌe. Haa jaꞌa Nicolás, Antioquía hänajty chooñ. Coo hänajty tøø miøjjøꞌøy, mänit jaduhṉ tiägøøyy maa judíos quiuhdujthajxiän. ");
INSERT INTO mirNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mänitä näjuxtujpähajxy jim̱ wioonøcxä apóstolwiinduumhajxy. Coo näjuxtujpähajxy jim̱ miejch, mänit hajxy quiøꞌønähgajpä jaꞌa apóstoldøjc. Mänitä apóstoldøjcä Dios hajxy piaꞌyaax̱y coo näjuxtujpä cuhdujt hajxy mioꞌowǿøjät coo hajxy jaduhṉ tiúnät nebiä apóstoldøjc‑hajxy hänajty tiuṉ̃än. ");
INSERT INTO mirNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tehṉgahnä Diosmädiaꞌagy hänajty yhawaꞌxøꞌøy. Mayøøbyñä jaꞌa mäbøjpädøjc‑hajxy hänajty tehṉgahnä jim̱ Jerusalén. Mayyä teedywiindsøṉhajxy hänajty miäbøjpä. ");
INSERT INTO mirNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Haa jaꞌa Esteban, miøødä Diosmäjaa hänajty jeꞌe. Dioswiinguex̱y hänajty jaduhṉ. Mänit tiägøøyy paꞌamyajnajxpä maa cuꞌugän. Hoy‑yagjuøøñä hänajty jaduhṉ wyiꞌi tiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mänitä judíos jaꞌa Esteban hajxy näjeꞌe tiägøøyy yajcapxiøøbiä nebiatiä Esteban hänajty yajnähixøꞌøy. Tøø hajxy hänajty yhity nebiä cudoogøꞌøybän. Pero tøø hajxy hänajty yhøxmájtsänä. Jim̱ä yhamdsoo tsajtøjc hajxy hänajty miøødä. Jäguem̱baady hajxy hänajty chooñ wiinghagajptjaty, møød jim̱ Cirene, møød jim̱ Cilicia‑naaxooty, møød jim̱ Asia‑naaxooty. ");
INSERT INTO mirNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero cab hajxy hänajty miäjädaꞌagaꞌañ jeꞌeguiøxpä coo Esteban hänajty jiaanc̈h tehm̱ jiaty mädiaꞌag. Hix̱, miøødä Esteban jaꞌa Dioswiinmahñdy hänajty nebiaty hänajty mioꞌoyii jaꞌa Dioshespíritäm. ");
INSERT INTO mirNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mänitä judíoshajxy quiojyquiapxytiuuṉ̃ coo wiinghänaꞌc hajxy miäjúyät coo weenä Esteban ñähwaam̱bedyii cooc tyijy jaꞌa Moisés hänajty haxøøg tøø ñänømyii møødä Dios. ");
INSERT INTO mirNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Coo Esteban jaduhṉ ñähwaam̱bejtä, mänitä cuꞌughajxy hoyhoy jiootmaꞌty, møødä majtøjc‑hajxy, møødä ley‑yajnähixøøbiädøjc‑hajxy. Mänitä Esteban yajmujcä. Mänit miajtsä. Mänit yajnøcxä maa teedywiindsøṉwiinduumhajxiän, maa junta hajxy hänajty yagjadyiijän. ");
INSERT INTO mirNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mänitä wiinghänaꞌc‑hajxy yajmejtsä maa junta hänajty jiadyiijän. Mänitä Esteban tiägøøyyä nähwaam̱béjtäbä: ―Tehṉgahnä yøꞌø craa hädaa tsajtøjc haxøøg ñänøm̱y maa Dios hajxy nwiingudsähgǿøyyämän. Jaduhṉä ley haxøøg ñänøøm̱bä, jaꞌa Moisés jecy quiujáhyyäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jaduhṉ højts nmädooyy coo jäyaꞌayhajxy miänaam̱bä cooc tyijy jaꞌa Jesús Nazaretpä hädaa tsajtøjc yajmaꞌadaꞌañ, cooc tyijy jaꞌa cuhdujt yajtägatsaꞌañ, jaꞌa Moisés hajxy jecy xyajmänähgueegǿøyyämbä ―nøm̱ä Esteban ñähwaam̱bejtä. ");
INSERT INTO mirNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Mänitä tuuṉgmøødpä Esteban hajxy wyiinheeꞌppejty, mäduhṉ̃tiä hajxy hänajty jim̱ yhäñaꞌay maa junta hänajty jiadyiijän. Haam̱b tsämaam̱bä Esteban wyiin jiøjp hänajty quiähxøꞌøgy nebiä Diosmoonsä wyiin jiøjphajxy quiähxøꞌøguiän, jaꞌa hajxy jim̱ hijpä tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mänitä teedywiindsøṉä Esteban miäyajtøøyy: ―Nej, jaanc̈h tøyhajt jaduhṉä nej miic̈h yøꞌø hänaꞌc xñänøm̱iän. ");
INSERT INTO mirNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Mänitä Esteban yhadsooyy: ―Majtøjc, puhyaꞌadiøjc, høøc̈hä nmädiaꞌagy hajxy huuc hamädoow̱híjtäc. Jaꞌa Abraham hajxy jecy nhaphajt ndeedyhájtäm. Jim̱ hänajty chänaꞌayñä Mesopotamia‑naaxooty maa Caldeabä‑jäyaꞌayhajxy hänajty chänaꞌayän. Cahnä Abraham hänajty jim̱ jiøbajnax̱yñä maa naax̱ hänajty xiøhatiän Harán. Mänitä Dios tsajpootypä jim̱ ñäguehx̱tøøꞌxy maa Abraham wyiinduumän. ");
INSERT INTO mirNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mänitä Dios jaꞌa Abraham ñämaayy: “Mdsóonäp yaa maa mnaax̱ maa mgajptän. Mnähguéꞌegäbä mjujy mmäguꞌug. Jim̱ mnǿcxät maac̈h miic̈h nwoonøcxaꞌañän. Mänítøch miic̈h jim̱ nyajnähixǿꞌøwät maa mdsänaadiaacpǿgät”, nøm̱ä Abraham jecy nämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mänitä Abraham jim̱ jiaanc̈h tsohṉnä Mesopotamia. Mänit jim̱ ñøcxy tsänaadiaacpøjpä Harán‑naaxooty. Pero cab jim̱ jejcy yhijty Harán‑naaxooty. Coo Abraham tieedy yhoꞌcy, mänit jim̱ chóhṉgumbä. Mänitä Dios jaꞌa Abraham yaa wioomejch hädaa yaabä naax̱ hädaa yaabä cajpt maa hajxy jädaꞌahaty nhíjtäm. ");
INSERT INTO mirNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero cabä Dios jaꞌa Abraham cuhdujt ñäꞌägä mooyy ni weeṉ̃tiä coo yaa chänaadiaacpǿgät. Jaduhṉä Abraham cuhdujt ñäꞌä mooyyä coo yaa ñäꞌä hahídät. Mänitä Dios jaꞌa Abraham yajwiinwaaṉøøyy coogä cuhdujt hänajty mioꞌowaꞌañ coo yhap yhoc‑hajxy yaa chänáañät coo Abraham hänajty tøø yhoꞌogy, hoyyä Abraham yhuung hänajty quiaꞌa jagä jiijä mänaa jaduhṉ yajwiinwaaṉøøyyän. ");
INSERT INTO mirNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jaduhṉä Dios jiaac mänaaṉ̃ coogä Abraham yhap yhoc‑hajxy hänajty wiingnaaxooty nøcxy yhadsänaꞌawaꞌañ, møød coog hajxy hänajty yhidaꞌañ nebiä cudoogøꞌøybän mädaax̱mägoꞌxjumøjt, møød coog hajxy tsaac̈htiuṉ̃ yhidaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mänitä Dios miänáaṉgumbä: “Coo miic̈hä mhapä mhoc‑hajxy hänajty tøø yagjaamduṉ̃ tøø yajtsaac̈htiuṉ̃, mäníthøc̈hä jäyaꞌay nyajcumädow̱aꞌañ, jaꞌa miic̈hä mhapä mhoc hänajty tøø xjiaamduuṉ tøø xchaac̈htiúuṉäbä. Mänitä mhapä mhoc‑hajxy jim̱ choonaꞌañ. Mänit hajxy yaa myinaꞌañ. Yaac̈h hajxy jaduhṉ xwyiingudsähgøꞌøwaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Coo Dios jaꞌa Abraham jaduhṉ yajmøødmädiaacy, yajcuhdujc hajxy jaduhṉ neby hajxy jaduhṉ miädiaaquiän. Mänitä Dios jaꞌa Abraham yhanehm̱y coo Abrahamhajxy yajcircuncidarhádät, møødä yhuunghajxy, møødä yhapä yhoc‑hajxy. Jaduhṉä hijxtahṉd miähmøøyy coo Dios jaꞌa Abraham jaduhṉ miøødyajcuhdujcy. Paadiä, coo Abraham yhuung Isaac jiaanc̈h miiṉ̃ jiaanc̈h cahy, cuductujxøø jaꞌa Abraham jaꞌa yhuung jiaanc̈h circuncidarhajty. Y coo Isaac hänajty tøø miøjjøꞌøy, jaduhṉä yhuung Jacob tiuum̱bä. Y jaꞌa Jacob, jaanä jaduhṉä ñøøx miajc yajpanøcxpä, jaꞌa nämajmetspä, jaꞌa højts jecy nhaphajt ndeedyhájtämbä. ");
INSERT INTO mirNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Jueꞌe Jacob yhuung hänajty tuꞌug xiøhaty José. Coo José hänajty jiaanc̈h tehm̱ chogyii jaꞌa tiéediäm, paadiä José yhajchhajxy jiootmaꞌty. Mänitä José jim̱ quiudoogøøyyä Egipto‑naaxooty. José yhajchhajxy jaduhṉ jatcøøyy. Pero tehṉgahnä Dios jaꞌa José hänajty cwieendähaty. ");
INSERT INTO mirNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Coo José hänajty hoyhoy tøø chaac̈htiuñii, mänit yajnähwaatsä jaꞌa Diósäm. Mänitä José wiinmahñdy miooyyä. Mänitä Dios miänaaṉ̃ coo José quiumayǿøjät jaꞌa Faraóngäm, jaꞌa hänajty jim̱ tuum̱bä gobiernä Egipto‑naaxooty. Mänitä Faraón jaꞌa José wyiinguejxy coo José jim̱ yhanéꞌemät mäduhṉ̃tiä Egipto‑naax̱, møød jim̱baady maa Faraón tiøjcän. ");
INSERT INTO mirNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Mänitä yuuxøø hoyhoy jiajtä jim̱ Egipto møød jim̱ Canaán‑naaxooty. Mänit højtsä nhapä ndeedyhajxy jiaanc̈h tehm̱ chaac̈hpøjcy jaꞌa yuugøxpä, coo cay huꞌugy hänajty jim̱ quiaꞌa hijnä. ");
INSERT INTO mirNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero coo Jacob jaduhṉ miädoyhajty coo trigo hänajty jim̱ yajpaady Egipto, mänitä ñøøx miajc jim̱ quiejxy trigojuubiä. Coo Jacob yhuunghajxy yhooc̈hohṉ̃ jayøbajt, cabä José choj høxcajpä jaꞌa yhájchäm. ");
INSERT INTO mirNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Coo hajxy miämetsc‑hoocpä yhoodiägajch, mänitä José ñiñägapxä. Mänit yhøxcájpänä. Mänitä Faraón ñajuøøñä coo José yhajchhajxy hänajty jeꞌe. ");
INSERT INTO mirNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mänitä José quiapxyñäguejxy coo tieedyhajxy jiiby ween miänacy Egipto, møødä jiujy miäguꞌughajxy nägøx̱iä. Jueꞌe hajxy hänajty nägøx̱iä, nädägøøghiiꞌxcumajmocx. ");
INSERT INTO mirNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mänitä Jacobhajxy jiiby jiaanc̈h hädaacnä Egipto møødä yhuunghajxy. Jiiby hajxy nägøx̱iä yhoꞌtaacy, jaꞌa hajxy jecy nhaphajt ndeedyhájtämbä. ");
INSERT INTO mirNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Cujequiä Jacob piajc‑hajxy yagjødsohṉnájxäxä møødä José piajc. Jim̱ä piajc‑hajxy yajnǿcxäxä maa cajpt hänajty xiøhatiän Siquem. Jim̱ hajxy hoy ñaax̱tägøødiägach maa Abraham jaꞌa naax̱ hänajty tøø jiuyyän. Jaꞌa Hamor yhuungä naax̱ hajxy tooꞌc. ");
INSERT INTO mirNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Coo hänajty yhabaadaaṉnä coo Dios hänajty yajtøjiadaꞌañ nebiä Abraham hänajty tøø yajwiinwaaṉøꞌøyiijän, tøø højtsä nhaphájtämä ndeedyhájtämhajxy hänajty miayøøñä jim̱ Egipto. ");
INSERT INTO mirNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mänitä wiinggobiernä jim̱ tiägøøyy tuum̱bä Egipto‑naaxooty. Cabä gobiernä miøjpädaacy nebiä José hänajty tøø tiuṉ̃än. ");
INSERT INTO mirNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mänit højtsä nhaphájtämä ndeedyhájtämhajxy wyiinhøhṉä. Jaꞌa gobiernä jaduhṉ mäwiinhøhṉ. Mänit hajxy jiaamduuṉä chaac̈htiuuṉä. Mänit hajxy yhanehm̱ä hadsip coo yhuung hajxy yhøxtséenät yhøxcónät, jaꞌa naam̱miṉ̃ jaꞌa naam̱mechpä, coo hajxy jaduhṉ ween yhoꞌogy. ");
INSERT INTO mirNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mänitä Moisés myiiṉ̃guiahy. Yajxóṉ jiaanc̈h tehm̱ miaaxhuunghajty. Cabä Moisés yhøxtsehṉä nebiä gobiernä hänajty tøø jia haneꞌemiän. Yuꞌuc̈hä Moisés yaghijtä tägøøgpoꞌo tøgooty. ");
INSERT INTO mirNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Coo Moisés hänajty hoy yuꞌuc̈h quiaꞌa hidaaṉnä, mänitä gobiernä tioꞌoxyhuungä Moisés yohbiaaty. Mänit yajtsoocy nebiä hamdsoo huungän. ");
INSERT INTO mirNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Coo Moisés miøjjøøyy, mänitä cuhdujt cøx̱iä yajwiinhixøøyyä nebiä egipcioshajxy hänajty quiuhdujthatiän. Jaanc̈h tehm̱ jiajp jaduhṉ piädsøøm̱y. Jaanc̈h tehm̱ yajxóṉ hänajty quiapxy miädiaꞌagy nebiä jajp nebiä najuøøbiän. Jaanc̈h tehm̱ yhoy hänajty miähaneꞌemy. ");
INSERT INTO mirNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Coo Moisés jiumøjt juxychäguiꞌx yhabejty, mänit wyiinmaadiaacy coo jaꞌa miägunaax̱ nøcxy quiuhixaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jim̱ä Moisés jaꞌa miägunaax̱ hänajty tuꞌug chaac̈htiuñii jaꞌa egipcio‑jäyáꞌayäm. Coo Moisés jaduhṉ yhijxy, mänitä miägunaax̱ ñäwaaṉ̃. Mänitä egipcio‑jäyaꞌay yaghoꞌcy, jaꞌa hänajty mädsaac̈htiuum̱bä. ");
INSERT INTO mirNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Paadiä Moisés jaduhṉ jiatcøøyy, jaduhṉ hänajty tiajy miay coo miägunaax̱hajxy hänajty tøø miäbøcy coo Moisés hänajty tøø wyiinguexyii jaꞌa Diósäm coo miägunaax̱ jaduhṉ yajnähwáꞌadsät. Pero cab hajxy jaduhṉ ñäꞌä mäbøjcy. ");
INSERT INTO mirNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Cujaboom, jim̱ä israelitahajxy hänajty nämetsc ñiguioxyii. Coo Moisés jaduhṉ yhijxy, mänit jia mänaaṉ̃ coo hajxy ñiyhøxmadsǿøjät. Mänit miänaaṉ̃: “Mäguꞌughajpädøjc, jueꞌe mijts jaduhṉ, mduꞌugcunaax̱ mijts jaduhṉ. Cab jaduhṉ yhahixøꞌøy coo hajxy jaduhṉ mniguioxǿøjät.” ");
INSERT INTO mirNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mänitä Moisés yhøxjahm̱ä tuꞌjäyaꞌay, jaꞌa hänajty mäjädaꞌagaam̱bä. Mänitä Moisés ñämaayyä: “Pøṉ miic̈h tøø xpiädaꞌagy coo højts miic̈h xyhanéꞌemät. ");
INSERT INTO mirNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nej, jaduhṉ miic̈h mdaj mmaabiä cooc̈h miic̈h xyaghoꞌogaam̱bä nej miic̈hä egipcio‑jäyaꞌay häxøøyy myaghoꞌquiän.” ");
INSERT INTO mirNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Coo Moisés jaduhṉ miädooyy, mänit piäyøꞌcy. Mänit jim̱ ñøcxy jäguem̱ maa naax̱ hänajty xiøhatiän Madián. Mänit jim̱ tiägøøyy hadsänaabiä. Mänitä jäyaꞌay wyiingpøjcy. Mänitä huung hajxy metsc piaaty. ");
INSERT INTO mirNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Coo Moisés hänajty jim̱ tøø yhijnä Madián juxychäguiꞌxjumøjt, mänit jim̱ tiägøøyy wädijpä pactuum, jim̱ mädøyyä maa jaꞌa tuṉ hänajty xiøhatiän Sinaí. Mänitä Moisés yhijxy coo jaꞌa wädsats hänajty tioy. Mänitä Diosmoonsä tuꞌug ñäguehx̱tøøꞌxy jøønhaajiooty. Tsajpootyp hänajty tøø chooñ. ");
INSERT INTO mirNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Coo jaꞌa Moisés jaduhṉ yhijxy, mänit jaduhṉ jiaanc̈h tehm̱ yagjuøøyy. Mänitä Dios jaꞌa Moisés ñämaayy: ");
INSERT INTO mirNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Høøc̈h Dioshajp. Høøc̈hä Abrahamhajxy jecy xwyiingudsähgøøyy, møødä Isaac, møødä Jacob, jaꞌa miic̈h jecy mhaphajt mdeedyhájtäbä.” Mänitä Moisés tiägøøyy tsäyuubiä. Jaanc̈h tehm̱ chähgøøby hänajty jaduhṉ. Cab hänajty jim̱ ñäꞌägä møjheebaꞌañ maa hänajty miägapxyiijän. ");
INSERT INTO mirNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mänitä Moisés ñämáayyägumbä: “Jeṉ yøꞌø mgøꞌøg. Høøc̈h nwiinduum miic̈h yaa mdänaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Tøøc̈h nhix̱y cooc̈hä nguꞌughajxy jim̱ jiaanc̈h tehm̱ chaac̈hpøcy Egipto‑naaxooty. Tøøc̈h nmädoy coo hajxy wyiꞌi jiøꞌøy wyiꞌi xiuuc̈h. Páadyhøch yaa tøø ngädaꞌagy hädaa yaabä naax̱wiin, jaꞌa ngúꞌughøch nyajnähwaꞌads nyajcuhwaꞌadsaam̱by. Miic̈h jim̱ nguexaam̱by Egipto yajnähwaatspä”, nøm̱ä Dios miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mänitä Esteban jiaac mädiaacy: ―Tøø jaꞌa Moisés jaꞌa miädiaꞌagy hänajty quiaꞌa mäbǿjcäxä. Jaꞌa yhamdsoo miägunaax̱hajxy hänajty tøø quiaꞌa mäbøcy. Mänit hajxy miänaaṉ̃: “Pøṉ miic̈h tøø xwyiinguex̱y coo mmøjhádät, coo mmähanéꞌemät.” Hoyyä Moisés hänajty jaduhṉ tøø jia nämaꞌayii, mänitä Dios jaꞌa Moisés wyiinguejxy wiindsøṉhajpä maa jaꞌa quiuꞌugän, coo hajxy jaduhṉ ñähwaꞌads quiuhwáꞌadsät. Jaꞌa Diosmoonsä jaꞌa Moisés jaduhṉ najtscapxøøyyä, jaꞌa hänajty tøø ñäguehx̱tǿøꞌxiäbä maa jaꞌa wädsats hänajty tioyyän. ");
INSERT INTO mirNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mänitä Moisés jaꞌa hoy‑yagjuøøñäjatypä may yajcähxøꞌcy jim̱ Egipto‑naaxooty. Mänitä miägunaax̱ jim̱ hoy wioobädsøm̱y. Majatiä Moiséshajxy hänajty wiädity, yajcähxøꞌpiä Moisés jaꞌa hoy‑yagjuøøñäjatypä hänajty, møød jim̱ maa jaꞌa Tsaptsmejjiän, møød jim̱ pactuum. Juxychäguiꞌxjumøjt hajxy jim̱ wiädijty pactuum. ");
INSERT INTO mirNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mänitä Moisés jaꞌa miägunaax̱ ñämaayy: “Nébiøc̈hä Dios tøø xwyiinguex̱iän coo mijts nyajnähwáꞌadsät, jaanä jaduhṉä Dios wiinghänaꞌc wyiinguexaam̱bä, jaꞌa jaac miim̱bä jaꞌa jaac cahbä. Mijtsä mmägunaax̱ jaduhṉ pädsøm̱aam̱b. Nax̱iä miädiaꞌagy hajxy mdehm̱ quiudiúuṉät waam̱baty hänajty miänaꞌanaꞌañ”, nøm̱ä Moisés jecy miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Hanäguipxiä Moisés jaꞌa miägunaax̱ jim̱ miøødwädijty pactuum, jaꞌa højts nhaphajt ndeedyhájtäm. Coo hajxy jim̱ miejch maa jaꞌa tuṉ hänajty xiøhatiän Sinaí, mänitä Diosmoonsä jaꞌa Moisés jim̱ tuꞌug miägapxy, jaꞌa hänajty jim̱ tsohm̱bä tsajpootyp. Mänitä Moisés jaꞌa Diosmädiaꞌagy ñajtscapxøøyyä. Paady jaduhṉ ñajtscapxøøyyä, coo højts jaduhṉ xyajmänähgueegǿøyyämät. Jaꞌa Diosmädiaꞌagy, cab jaduhṉ mänaaxøø quiuhdägoyyaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero cabä Moisés jaꞌa miädiaꞌagy hänajty yajtunáaṉäxä. Jaꞌa højts nhaphajt ndeedyhájtämhajxy hänajty caꞌa cudiunaam̱b. Jaduhṉä jioot hajxy hänajty tøø piädaꞌagy coo hajxy hänajty wyiimbidaꞌañ, coo hajxy hänajty jim̱ ñøcxtägatsaꞌañ Egipto. ");
INSERT INTO mirNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jim̱ä Moisés jaꞌa piuhyaꞌay hänajty tuꞌug xiøhaty Aarón. Coo jaꞌa Moisés hänajty tøø ñøcxy tuṉmøjc, mänitä cuꞌugä Aarón hajxy ñämaayy: “Huuc tuṉä mayhajt, højtsä saandä mejtstägøøg hädiúuṉäc, jaduhṉ højts nwiingudsähgǿꞌøwät. Jeꞌe højts jaduhṉ xwyiinwówäp. Jaꞌa Moisés, jaꞌa højts tøø xwioobädsǿøm̱ämbä jim̱ Egipto‑naaxooty, cab jaduhṉ yajnajuøꞌøy neby jaduhṉ tøø jiaty tøø yhabety”, nøm̱ä Aarón ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mänitä saandä hajxy yhädiuuṉ̃ wajhuunghahädiuuṉnax̱y. Mänitä saandä hajxy tiägøøyy wiingudsähgøøbiä. Mänitä animal hajxy tiägøøyy yojxpä jaꞌa saandäcøxpä. Mänitä saandä hajxy wyiinxooṉdaacy, jaꞌa hajxy hänajty hamdsoo tøø yhädiúṉ̃äbä. ");
INSERT INTO mirNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Mänitä Dios jaꞌa tsaanguꞌug piuhwaatsnä. Mänit ñähgueecnä, jeꞌeguiøxpä coo jaꞌa xøø hajxy hänajty tøø tiägøꞌøy wiingudsähgøøbiä møødä poꞌo møødä madsaꞌa. Hix̱, jaduhṉ jim̱ myiṉ̃ cujaay maa jaꞌa profeta jecy quiujahyyän: Mijts Israelpäjäyaꞌay, mänaa hajxy jecy mwäditiän pactuum juxychäguiꞌxjumøjt, caꞌa yhøøc̈hcøxpä jaꞌa animal hajxy mwiꞌi yojxy, caꞌa yhøøc̈hä mijts xwyiingudsähgøøyy. ");
INSERT INTO mirNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Caj pues, caꞌa yhøøc̈hä. Jeꞌe hajxy mwiingudsähgøøyy jaꞌa saandä hänajty xøhajpä Moloc. Jeꞌe chajtøjc‑hahädiuuṉnax̱y hajxy mmädajnajxä, møødä saandä Renfán jaꞌa miadsaꞌahahädiuuṉnax̱y. Hamdsoohaambiä saandä hajxy mhädiuuṉ̃ neby hajxy jaduhṉ mwiingudsähgǿꞌøwät. Coo hajxy jaduhṉ mjatcøꞌøy, paady mijts nhøxquejxpädsøm̱aꞌañ maa jaꞌa mhamdsoo naax̱hajxiän. Jäguem̱ mijts nguexaꞌañ Babilonia‑nänax̱y. Jaduhṉ jim̱ myiṉ̃ cujaay maa jaꞌa Diosmädiaꞌaguiän. ");
INSERT INTO mirNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Hoorä, mänaa højts nhaphajt ndeedyhájtämhajxy jecy wiäditiän pactuum, carpa‑tøbiaꞌcä Dios hajxy hänajty wyiingudsähgøꞌøy. Tsajtøjcä carpa‑tøy hajxy hänajty wiaꞌañ. Hoy ñäꞌä majatiä carpa hajxy hänajty ñäꞌä tøy. Jaduhṉä carpa‑tøy hajxy yhädiuuṉ̃ nebiä Dios jaꞌa Moisés jaꞌa hijxtahṉd jecy yaghijxiän coo jaduhṉ piahädiúnät. ");
INSERT INTO mirNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Jaꞌa nhaphajt jaꞌa ndeedyhájtämhajxy, jaꞌa hajxy jaac púhw̱äbä jaac híꞌcäbä, tehṉgahnä cuhdujt hajxy hänajty jiaac panøcxy coo jaꞌa Dios hajxy hänajty wyiingudsähgøꞌøy carpa‑tøbiaꞌc. Jaduhṉ hajxy hänajty jiaac paduṉ̃ñä mänaa jaꞌa Josué hajxy jim̱ wioonøcxyiijän wiinghagajpt maa jaꞌa wiingjäyaꞌayhajxy hänajty chänaꞌayän. Coo jaꞌa nhaphajt jaꞌa ndeedyhájtämä naax̱ hajxy ñädägøøyy tsiptuum̱bä, jaꞌa Dioscøxpä hajxy miäjädaacy. Jaꞌa miädsiphajxy, cøjxä ñaax̱ hajxy yhøxpäyøꞌøgy. Y coo jaꞌa David cujecy tiägøøyy gobiernähajpä, jeꞌenä jaꞌa nhaphajt jaꞌa ndeedyhájtämä cuhdujt hajxy hänajty jiaac paduṉ̃ coo jaꞌa Dios hajxy hänajty wyiingudsähgøꞌøy carpa‑tøbiaꞌc, jaꞌa hajxy hänajty tøø jiaac tehm̱ piúꞌuyäbä, jaꞌa hajxy hänajty tøø jiaac tehm̱ yhíꞌiguiäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Jaꞌa David, jaanc̈h tehm̱ quiumaabiädsøøm̱ jaayaꞌay maa jaꞌa Diosän. Mänitä David jaꞌa Dios cuhdujt miäyujwaaṉ̃ coo jaꞌa tsajtøjc yhädiúnät maa jaꞌa Jacob yhap yhoc jaꞌa Dios hajxy jaduhṉ piaꞌyáꞌaxät. ");
INSERT INTO mirNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Caꞌa Diavitä jaꞌa tsajtøjc hädiuuṉ jaꞌa Dioscøxpä. Jaꞌa David jaꞌa yhuung Salomón, jeꞌedsä tsajtøjc jaanc̈h hädiuuṉ. ");
INSERT INTO mirNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero jaꞌa Dios tsajpootypä, cab jaduhṉ tiehm̱ yhity tsajtøgooty, jaꞌa jäyaꞌayhajxy yhädiuum̱biä. Jaduhṉä profeta tuꞌug jecy quiujahy coogä Dios miänaaṉ̃: ");
INSERT INTO mirNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Høøc̈h Dioshajp. Yaac̈h nhäñaꞌay tsajpootyp. Yaac̈h nmähaneꞌemy. Jiiby naax̱wiin, jíibyhøc̈hä ndecy nyaghity. Cábøc̈hä tøjc nyajmaajiaty maac̈h nbóoꞌxät. Cab jaduhṉ yhahixøꞌøy coo mijtsä tøjc xquiójjät. Tiic̈hä tøjc jaduhṉ nnäꞌä wáꞌanät. ");
INSERT INTO mirNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Haa caꞌa, høøc̈h cøx̱iä tøø nhuuc hädiuum̱bä mäduhṉ̃tiä yaa tsajpootypä møød jiiby naax̱wiin, nøm̱ä Dios miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Mänitä Esteban jiaac miänaaṉ̃: ―Jaꞌa mijtsä mhapä mdeedyhajxy jaꞌa jecypiä haampiä, jaanc̈h tehm̱ quiuhxex̱ hajxy hijty, nebiä Diosmädiaꞌagy hajxy caꞌa mäbøjpän. Jaanä jaduhṉ mijtspä, caj mijtsä Diosmädiaꞌagy mmäbøgaam̱bä. Høxtä Dioshespíritupaady hajxy jaduhṉ homiänaajä mmädsiphaty. ");
INSERT INTO mirNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Jaꞌa mijtsä mhapä mdeedyhajxy jaꞌa jecypiä haampiä, quiøx̱y jaamduuṉ quiøx̱y tsaac̈htiuuṉ jaꞌa profetadøjc hajxy jecy, jaꞌa Dios hänajty tøø wyiinguéx̱iäbä coo jaꞌa mädiaꞌagy hajxy yajwáꞌxät coogä Dios jaꞌa yHuung hänajty yaa quiexaꞌañ hädaa yaabä naax̱wiin, jaꞌa pojpä cädieey caꞌa møødpä. Høxtä yaghoꞌcä jaꞌa profetadøjc‑hajxy jaduhṉ. Y coo jaꞌa Dios yHuung yaa jiaanc̈h cädaacy, mänit mijts mgøꞌøyejcy coo yaghoꞌogǿøjät. ");
INSERT INTO mirNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Coo jaꞌa Dios jaꞌa Moisés cuhdujt jecy miooyy, jaꞌa Diosmoonsä jaꞌa Moisés najtscapxøøyyä, jaꞌa jim̱ tsohm̱bä tsajpootyp, mänit mijtsä mhapä mdeedy jaꞌa cuhdujt hajxy jaduhṉ mioodiägajtsä. Hoyyä Diosmoonsä jaꞌa cuhdujt hajxy jia yejcy, cab hajxy jaduhṉ mgudiuṉ̃ ―nøm̱ä Esteban miädiaacpädøøyy. ");
INSERT INTO mirNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Coo jaꞌa teedywiindsøṉhajxy jaduhṉ miädooyy nebiä Esteban hänajty miädiaꞌaguiän, mänitä Esteban hajxy jaduhṉ jiaanc̈h tehm̱ miäjootmaꞌty. Høxtä tøøtscädajp hajxy hänajty. ");
INSERT INTO mirNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero cabä Esteban jaduhṉ ñäꞌä møjpädaacy. Hix̱, miøødhajpiä Esteban jaꞌa Dioshespíritu hänajty. Mänitä Esteban yuugheeꞌpy tsajpootyp. Mänit jaduhṉ yhijxy coo jim̱ jiaanc̈h tehm̱ yajxoṉä maa jaꞌa Dios yhäñaꞌayän. Mänitä Jesús jaduhṉ yhíjxäbä coo jim̱ yhäñaabiä maa jaꞌa Dios ñähmøjcän yhahooyhaamby. ");
INSERT INTO mirNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Mänitä Esteban miänaaṉ̃: ―Huug hix̱ hajxy. Jadúhṉhøc̈hä tsajt nhix̱y nebiä hawaꞌadspän. Xim̱ä Jesucristo yhäñaꞌay Diosnähmøjc maa yhahooyhaampiän. ");
INSERT INTO mirNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mäduhṉ̃tiä jäyaꞌayhajxy hänajty yhamädoow̱hity, mänit hajxy ñidiaatsmoꞌxä; haa caꞌa, cab hajxy hänajty tehṉgahnä miädow̱aaṉnä nebiatiä Esteban hänajty miädiaꞌagy. Mänit hajxy tiägøøyy yaax̱pä jojpä møcjaty. Mänitä Esteban yajmujcä. ");
INSERT INTO mirNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Mänit yajnøcxä cajptpaꞌa hadsip. Jaꞌa hänaꞌcä Esteban hajxy hänajty tøø ñähwaam̱bétiäbä, mänitä jiocxwit hajxy nägøx̱iä yhøxchijy. Jim̱ä høxcujc‑hänaꞌc hänajty tuꞌug piadänaꞌay, jaꞌa hänajty xøhajpä Saulo. Mänitä Saulo ñämaayyä coo jaꞌa jiocxwithajxy cwieendähájtäxät. Mänitä Esteban tiägøøyyä caꞌadshóꞌcäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Jim̱ä Esteban hänajty quiaꞌadshoꞌogyii, mänit tiägøøyy Diospaꞌyaax̱pä. Mänit miänaaṉ̃: ―Wiindsǿṉ Jesús, tuṉä mayhajt, høøc̈h njuøhñdy jim̱ wiingpǿjcäc tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mänitä Esteban jyijcädaacy. Mänit møc yaax̱y: ―Dios, caꞌa jaduhṉ mmøjpädaꞌagy nébiøch yøꞌø hänaꞌc xchaac̈htiuṉ̃än, hoy jia møjpoj jia møjcädieeyä. Coo jaꞌa Esteban jaduhṉ jiaac tehm̱ quiapxy, mänit yhoꞌnä. ");
INSERT INTO mirNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Y jaꞌa Saulo, quiumaayy jeꞌeduhṉ coo jaꞌa Esteban yaghoꞌcä. Jaꞌa mänitxøøbä jaꞌa mäbøjpädøjc‑hajxy tiägøøyyä jaamduuṉ tsaac̈htiúuṉäbä jim̱ Jerusalén. Mänit hajxy xii yaa ñøcxøøyy. Näjeꞌe hajxy miähmøøyy Judea‑naaxooty wiinduhm̱yhagajpt. Näjeꞌe hajxy ñøcxøøbiä Samaria‑naaxooty. Jagooyyä jaꞌa apóstolädøjc‑hajxy jim̱ jiaac mähmøøyy Jerusalén. ");
INSERT INTO mirNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mänitä dijuuntä Esteban hoy yajnaax̱tägøꞌøyii. Näjeꞌe jäyaꞌayhajxy hoy miäyajnaax̱tägøꞌøy, pønjatiä hojioot hänajty møød. Hoyhoyyä Esteban ñäjøøyy ñäxuuꞌtsä. ");
INSERT INTO mirNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Y jaꞌa Saulo, tehṉgahnä jaꞌa mäbøjpädøjc hänajty jiaamduṉ̃ chaac̈htiuṉ̃ wiinduhm̱yhagajpt. Høxtä jäyaꞌadiøgootypaadiä Saulo hänajty tiägøꞌøy. Pønjaty hänajty yajpaatp tiøgooty, mänit hajxy hänajty yhøxwich yhøxwooñii, jaꞌa yaꞌadiøjc jaꞌa toꞌoxiøjc. ");
INSERT INTO mirNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Y jaꞌa mäbøjpädøjc‑hajxy, jaꞌa hajxy hänajty tøø chóoñäbä Jerusalén, jeꞌenä jaꞌa Diosmädiaꞌagy hajxy hänajty tehṉgahnä yajwaꞌxy jaꞌa Jesúscøxpä, majaty hajxy hänajty wiädity. ");
INSERT INTO mirNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Høxtáhm̱dsä craa Felipehajpä, coo jim̱ chohṉ̃ Jerusalén, mänit jim̱ ñøcxy Samaria‑cajptooty. Coo jim̱ miejch, mänit jaduhṉ tiägøøyy mädiaacpä jaꞌa Jesúscøxpä, coo hänajty jeꞌe Dyiosquex̱iä. ");
INSERT INTO mirNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mayyä jäyaꞌayhajxy hänajty yhamugøꞌøy mädiaꞌagyhamädoow̱hijpä waam̱batiä Felipe hänajty miänaꞌañ. Madiuꞌu jaꞌa Felipe hoy‑yagjuøøñäjatypä hänajty yajcähxøꞌøgy, paadiä miädiaꞌagy hänajty jiaanc̈h tehm̱ yhamädoow̱híjtäxä. ");
INSERT INTO mirNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pønjatiä haxøøgpä caꞌa hoybä hänajty møød, mänit hajxy nämay piaꞌamnajxy. Yáax̱äp jójcäbä haxøøgpä caꞌa hoybähajxy hänajty piädsøm̱y. Jaduhṉä cøꞌømucypiä tecymiucypiähajxy hänajty miøcpøjpä møødä tecymiaꞌadpähajxy. ");
INSERT INTO mirNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Paadiä cuꞌughajxy hänajty jiaanc̈h tehm̱ xiooṉdaꞌagy jim̱ Samaria. ");
INSERT INTO mirNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Jim̱ä jäyaꞌay hänajty tuꞌug xiøhaty Simón. Tøø jaꞌa magia‑wiinmahñdy hänajty jejcy tiuṉ̃ jim̱ Samaria. Tøø jaꞌa Simón jaꞌa jäyaꞌay hänajty jim̱ may jiaanc̈h tehm̱ wyiinhøøñ. Jaduhṉä Simón hänajty ñiñänømyii cooc tyijy jiaanc̈h tehm̱ miøj jiaanc̈h tehm̱ jiaanc̈hä, jeꞌeguiøxpä cooc tyijy jaꞌa magia hänajty jiaanc̈h tehm̱ jiaty. Madiuꞌu jaꞌa Simón jaꞌa hoy‑yagjuøøñäjatypä hänajty jiaanc̈h tehm̱ yajcähxøꞌøgy, paadiä miädiaꞌagy hänajty jiaanc̈h tehm̱ miäbǿjcäxä nägøx̱iä høxtä jaꞌa møjtøjcpaady: ―Yøꞌø Simón, jueꞌedaꞌa yøꞌø, Dioswiinguex̱iädaꞌa yøꞌø, paadiä møcmäjaa jaduhṉ jiaanc̈h tehm̱ miøødä. Jaduhṉä Simón hänajty ñänømyii jaꞌa cúꞌugäm. ");
INSERT INTO mirNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Jaduhṉä Felipe hänajty yajnähixøꞌøy coogä Dios yhaneꞌemy jaꞌa miøcmäjaahaam, møød coogä Jesús Dyioswiinguex̱iä. Mänitä jäyaꞌayhajxy may miäbøjcy näyaꞌay nädoꞌoxy. Mänit hajxy nägøx̱iä hoy ñäbety. ");
INSERT INTO mirNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Y jaꞌa Simón, miäbøjc jeꞌeduhm̱bä. Mänit hoy pianäbejpä. Mänitä Simón jaꞌa Felipe tiägøøyy møødwädijpä. Yagjuøøbiä Simón hänajty nebiä Felipe jaꞌa hoy‑yagjuǿøñäbä hänajty yajcähxøꞌøguiän. ");
INSERT INTO mirNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Y jaꞌa apóstoldøjc‑hajxy, jaꞌa hajxy hänajty tøø miähmǿꞌøyäbä Jerusalén. Mänit hajxy miädoyhajty coogä cuꞌug jaꞌa Diosmädiaꞌagy hajxy hänajty tøø jiøjpøgøꞌøy jim̱ Samaria. Mänitä Pedrohajxy jim̱ quiejxä møødä Juan. ");
INSERT INTO mirNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Coo hajxy jim̱ miejch Samaria, mänit hajxy tiägøøyy Diospaꞌyaax̱pä jaꞌa mäbøjpädøjcøxpähajxy, weenä Dioshespíritu hajxy nägøx̱iä yhadägøꞌøy jioottägøꞌøyii. ");
INSERT INTO mirNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Hix̱, cahnä Dioshespíritu hänajty pøṉ yhadägøꞌøy jioottägøꞌøyii. Tøø hajxy hänajty jia näbety jaꞌa Jesúscøxpä. Cahnä hajxy hänajty miädoyhatyñä jaꞌa Dioshespíritucøxpä. ");
INSERT INTO mirNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Coo jaꞌa Pedrohajxy Dyiospaꞌyaax̱pädøøyy møødä Juan, mänitä mäbøjpädøjc‑hajxy quiøꞌønähxajjä. Mänit hajxy yhadägøøyy jioottägøøyyä jaꞌa Dioshespíritäm. ");
INSERT INTO mirNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Y jaꞌa Simón, coo jaduhṉ yhijxy, mänitä Pedro xädøꞌøñ hajxy jia yajmähawaaṉøøyyä. ");
INSERT INTO mirNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Mänitä Simón miänaaṉ̃: ―Høøc̈h yøꞌø mäjaa jaduhm̱bä yaghabǿjcäc. Hix̱, cooc̈h pøṉ jaduhṉ ngøꞌønähxájät, tehm̱ jiaduhṉ jeꞌe yhadägøøyy jioottägǿøyyäbät jaꞌa Dioshespíritäm. ");
INSERT INTO mirNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mänitä Pedro yhadsooyy: ―Coo miic̈h jaduhṉ mwiꞌi tiajy mwiꞌi miay coo højts miic̈h jaꞌa Diosmäjaa nyaghabǿgät juyhaam, paady miic̈hä Dios xyajcuhdägoyyaꞌañ møødä mxädøꞌøñ. Hix̱, ñäꞌä yejpiä Dios jaa miäjaa jaduhṉ, caj pøṉ yajmädoogy. ");
INSERT INTO mirNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Caj miic̈h cuhdujt mnäꞌägädä møødä coo højts miic̈h jaꞌa Diostuuṉg xmiøødtúnät, jeꞌeguiøxpä coo miic̈hä mwiinmahñdy quiaꞌa näꞌägädä hoyyä jaꞌa Dioscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Najtshixøꞌøw jaꞌa mhaxøøgwiinmahñdy jaduhṉ. Jím̱bädä Dios xñäꞌä mäméeꞌxät coo mmänuuꞌxtáꞌagät. ");
INSERT INTO mirNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tøøc̈h miic̈h nhøxcapy coo miic̈hä mhaa mjoot jiaanc̈h tehm̱ yhaxøøgä, møød coo miic̈h haxøøg mjaanc̈h tehm̱ tiajy mjaanc̈h tehm̱ miay mjoodooty mgopcooty. ");
INSERT INTO mirNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mänitä Simón yhadsooyy: ―Huuc tuṉä mayhajt hajxy, huuc Diospaꞌyaꞌax hajxy jaꞌa høøc̈hcøxpä, jadúhṉhøc̈hä Dios xquiaꞌa yajcumädów̱ät nébiøch hajxy tøø xyajmøødmädiaꞌaguiän ―nøm̱ä Simón miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jim̱ä Pedrohajxy hänajty jiaac capxy jiaac mädiaꞌagy jaꞌa Jesúscøxpä møødä Juan, nebiaty hajxy hänajty tøø yhamdsoo yajnähixøꞌøyii jaꞌa Jesúsäm. Mänit hajxy wyiimbijnä, mänit hajxy jim̱ ñøcxtägajch Jerusalén näguipxy møødä Felipe. Tuꞌhaamnøcxpä, nøødänáayyäp tuꞌudänáayyäp hajxy hänajty ñøcxy. Majatiä cajpthuung jim̱ Samaria‑naaxooty, jaduhṉä Diosmädiaꞌagy hajxy hänajty yajwaꞌxy nebiä cuꞌugä piojpä quiädieeybä ñähwaꞌads quiuhwáꞌadsät. ");
INSERT INTO mirNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Coo hajxy jim̱ quiooꞌty Jerusalén, mänitä Felipe jaꞌa Diosmóonsäm tuꞌug ñämaayyä, jaꞌa jim̱ tsohm̱bä tsajpootyp: ―Nøcxøꞌøw jim̱ jøømboj mänajpä. Jaꞌa møjtuꞌu mbanǿcxäp, jaꞌa jim̱ nøcxpä maa jaꞌa cajpt jaduhṉ xiøhatiän Gaza. Jaꞌa møjtuꞌu jaduhm̱bä, pactuum jaduhṉ ñøcxøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Mänitä Felipe jiaanc̈h tuꞌubøjcy. Jaꞌa tuꞌhaamnøcxpä, mänitä Felipe jaꞌa jäyaꞌay tuꞌug piaaty, jaꞌa hänajty tsohm̱bä Etiopía. Tøø jaayaꞌay hänajty yhoy Jerusalén Dioswiingudsähgøøbiä. Quiajptooty hänajty ñøcxnä. Eunuco jeꞌe. Møjtuuṉg hänajty jim̱ miøød maa jaꞌa ñaax̱ maa jaꞌa quiajptän. Xädøꞌøñgwieendähajpä hänajty jim̱ tiuum̱by. Jaꞌa reina mioonsä hänajty jeꞌeduhṉ, jaꞌa hänajty jim̱ mähanehm̱bä Etiopía. Carretajooty jaayaꞌay hänajty ñøcxy nocyhéeꞌpäp. Jueꞌe hänajty quiapxyp, jaꞌa nocy jaꞌa Isaías jecy quiujáhyyäbä, jaꞌa jecy túuṉäbä profeta. ");
INSERT INTO mirNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mänitä Felipe ñämaayyä jaꞌa Dioshespíritäm coo jim̱ miøjwáꞌagät carretawiinduum. ");
INSERT INTO mirNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Coo jaꞌa Felipe jim̱ jiaanc̈h møjwaꞌcy carretawiinduum, mänitä Felipe miädooyy coo jaꞌa Etiopíabä jäyaꞌay jaꞌa nocy hänajty quiapxy, jaꞌa Isaías jecy quiujáhyyäbä. Mänitä Felipe jaayaꞌay miäyajtøøyy: ―Nej, mwiinjuøøby miic̈h jaduhṉä nebiaty mgapxiän. ");
INSERT INTO mirNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mänitä jaayaꞌay yhadsooyy: ―Cábøch nwiinjuøꞌøy. Cábøch pøṉ nmøødä pǿṉhøch jaduhṉ xquiapxtǿøw̱äp. Mänitä Felipe ñämaayyä coo jim̱ piédät carretajooty, coo jim̱ yhøxtáꞌagät maa jaꞌa Etiopíabä jäyaꞌay ñähmøjcän. ");
INSERT INTO mirNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jaduhṉä jaayaꞌay hänajty quiapxy: Hadsipä mähdiøjc yajnøcxä maa jaꞌa yaghoꞌtaactän, jaduhṉ nebiä meeg yajnøcxyiijän maa jaꞌa yaghoꞌtaactän. Cabä mähdiøjc waam̱b ñäꞌägädä capxy; jaduhṉ hamoṉ̃ yhijty nebiä meeg hamoṉ̃ yhitiän coo ñähmeꞌxyii. ");
INSERT INTO mirNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Hoc̈hähdiuuṉnä jaꞌa mähdiøjc yaghoꞌcä. Cab jaduhṉ pøṉ ñähgapxtuuty. Cabä ñøøxä miajc miøødhajty; hix̱, tøø jaꞌa jiugyhajt hänajty yaa quiøjxnä hädaa yaabä naax̱wiin. ");
INSERT INTO mirNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mänitä Felipe ñämaayyä: ―Tuṉä mayhajt, høøc̈h huuc hawáaṉäc, coo jaꞌa Isaías jaduhṉ jecy quiujahy, pøṉ jaduhṉ miädiaac, wiingjäyaꞌay tøgä jeꞌeguiøxpä ―nøm̱ä Etiopíabä jäyaꞌay yajtøøyy. ");
INSERT INTO mirNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mänitä Felipe tiägøøyy capxtøøbä waam̱baty hänajty jaduhṉ miädiaꞌagytiägøꞌøy. Mänit miädiaacy jaꞌa Jesúscøxpä, coo hajxy hoy xñähhoꞌtúutäm. ");
INSERT INTO mirNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Weeṉ̃tiä hajxy jaduhṉ jiaac yohy carretajooty, mänitä nøø hajxy piaaty. Mänitä Etiopíabä jäyaꞌay miänaaṉ̃: ―Xii nøø. Nej, cab jaduhṉ yhahixøꞌøyä cooc̈h nnäbétädä. ");
INSERT INTO mirNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Mänitä Felipe yhadsooyy: ―Hahixøøby jaduhṉ pø tøyhajt jaduhṉ mmäbøcy hamuumduꞌjoot. Mänitä Felipe yhadsoow̱ä: ―Nmäbǿjpiøch jaduhṉ coo jaꞌa Jesucristo Dyioshuungä. ");
INSERT INTO mirNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mänitä Etiopíabä jäyaꞌay jaꞌa carreta yajyajtänaaxiøjpä. Mänitä Felipehajxy nämetsc quiarretamänajcy, møødä Etiopíabä jäyaꞌay. Mänit hajxy nämetsc ñøødägøøyy. Mänitä Etiopíabä jäyaꞌay ñäbejty. ");
INSERT INTO mirNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Coo hajxy ñøøbädsǿøm̱gumbä, mänitä Felipe wiingtuum yajnøcxä jaꞌa Dioshespíritäm. Cabä Felipe yhijxtägájtsänä jaꞌa Etiopíabä jäyáꞌayäm. Xooṉdáacäp jaꞌa Etiopíabä jäyaꞌay ñøcxnä. ");
INSERT INTO mirNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Y jaꞌa Felipe, mänit jim̱ miejch maa jaꞌa cajpt hänajty xiøhatiän Azoto. Mänit tiägøøyy wädijpä cajpt‑cajpt. Yajwaꞌxypä Felipe jaꞌa Diosmädiaꞌagy hänajty nebiä cuꞌugä piojpä quiädieeybä ñähwaꞌads quiuhwáꞌadsät. Mänit jim̱ miejch Cesarea. ");
INSERT INTO mirNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Y jaꞌa Saulo, tehṉgahnä jaꞌa mäbøjpädøjc hänajty yhadsähgøꞌøy yhajuøꞌøy coo hajxy hänajty yaghoꞌogaꞌañii, pønjaty hänajty mäbøjp jaꞌa Jesúscøxpä. Coo jaꞌa Saulo hänajty jaduhṉ tehṉgahnä jia wiꞌi miähadsähgøꞌøwaꞌañ, paady jim̱ ñøcxy maa jaꞌa teedywiindsøṉän. ");
INSERT INTO mirNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Mänitä Saulo cuhdujt miooyyä nocyhaam coo jim̱ ñǿcxät Damasco, coo jaꞌa mäbøjpädøjc‑hajxy jim̱ yhøxtaꞌawǿøjät wiinduhm̱c̈hajtøjc, majatiä judíoshajxy hänajty yhamugøꞌøyän. Jaduhṉä Saulo hänajty tiajy miay coo jaꞌa mäbøjpädøjc‑hajxy hänajty jim̱ nøcxy chumaꞌañii Jerusalén, yaꞌadiøjcä tioꞌoxiøjcä. ");
INSERT INTO mirNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mänitä Saulohajxy tiuꞌubøjcy møødä jiamiøød nämetsc nädägøøg. Ja ween hajxy hänajty jim̱ quiaꞌa mech Damasco, mänitä Saulo jøøn møc quiuhjajcädaacä wäditiä. Tsajpootypä jøøn chohṉdaacy. ");
INSERT INTO mirNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mänitä Saulo quiädaayy. Mänit miädooyy coo jäyaꞌay hänajty tuꞌug quiapxy: ―Saulo, Saulo, tiic̈h miic̈h jaduhṉ coo xwyiꞌi miädsibøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mänitä Saulo yajtøøyy: ―Wiindsǿṉ, pøṉ miic̈h jaduhṉ. Mänit yhadsoow̱ä: ―Jesúshøch høøc̈h. Høøc̈h miic̈h jaduhṉ xwyiꞌi miädsibøøby. Cooc̈h miic̈h jaduhṉ xwyiꞌi miädsibøꞌøy, hamdsoo miic̈h jaduhṉ mnic̈haac̈htiuñii. ");
INSERT INTO mirNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tsähgøøyy tsäyúuyyäbä Saulo yajtǿøgumbä: ―Wiindsǿṉ, neby yhahixøꞌøy njatcǿꞌøwädøch. Mänit yhadsóow̱ägumbä: ―Pädøꞌøg, nøcx cajptooty. Jim̱ hänaꞌc xyhawáaṉät nej mjatcǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Y jaꞌa Saulo jiamiøødhajxy, coo hajxy jaduhṉ miädooyy nebiatiä Saulo hänajty tøø miägapxyiijän, jaanc̈h tehm̱ chähgøøyy hajxy jaduhṉ. Hix̱, cab hajxy pøṉ yhijxy. Høxtä hahuum høxtä hawiinds hajxy miähmøøyy. ");
INSERT INTO mirNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Mänitä Saulo jiaanc̈h tänaayyøꞌcy. Coo jaduhṉ jia wiindøøꞌxy, cab jaduhṉ tii yhijxy. Hix̱, tøø hänajty wyiinxooc̈h. Coo hajxy jaduhṉ tiuꞌubøjtägajch, wichhaamä Saulo jim̱ yajmejtsä Damasco. ");
INSERT INTO mirNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tägøøgxøø jaꞌa Saulo jim̱ yhijty wiinxoods Damasco. Ni quiaꞌa cay ni quiaꞌa huꞌugy hänajty tii. ");
INSERT INTO mirNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jim̱ä jäyaꞌay hänajty tuꞌug chänaꞌay Damasco, jaꞌa hänajty xøhajpä Ananías. Tøø jaꞌa Diosmädiaꞌagy hänajty miäbøcy. Mänitä Ananías jaꞌa Jesús wyiinhijxy hagumaꞌayhaam. Mänitä Ananías miägapxä: ―Ananías. Mänit yhadsooyy: ―Wiindsǿṉ, chaac̈h høøc̈h, tisän. ");
INSERT INTO mirNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mänitä Jesús miänaaṉ̃: ―Pädøꞌøg. Nøcx jim̱ maa jaꞌa møjtuꞌu jaduhṉ xiøhatiän Tødiuꞌu. Jim̱ä jäyaꞌay tuꞌug chänaꞌay, jaꞌa xøhajpä Judas. Jim̱ä craa tuꞌug yhahity, jaꞌa xøhajpä Saulo. Jim̱ jeꞌe chooñ maa jaꞌa cajpt xiøhatiän Tarso. Diospaꞌyaax̱p jim̱ jadunajtä maa jaꞌa Judas tiøjcän. Coo jim̱ mmédsät, mänitä Saulo myajtǿwät. ");
INSERT INTO mirNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Tøø miic̈hä Saulo xwyiinhix̱y hagumaꞌayhaam coo miic̈h hoy mnähdoṉ̃, jaduhṉ yhijxtägátsät. ");
INSERT INTO mirNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Coo jaꞌa Ananías jaduhṉ miädooyy, mänit miänaaṉ̃: ―Wiindsǿṉ, tøøc̈h jaduhṉ mayhooc nmädoyhaty nebiä craa Saulo nax̱y jiatcøꞌøy jim̱ Jerusalén. Náx̱iägä mäbøjpädøjc‑hajxy jim̱ jiaamduṉ̃ chaac̈htiuñii, jaꞌa miic̈hä mmädiaꞌagy hajxy xmiäbǿjcäbä. ");
INSERT INTO mirNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jadúhṉhøch tøø nmädoyhajpä coogä cuhdujt jim̱ miooyyä coo jaꞌa mäbøjpädøjc‑hajxy yaabä yajnøcxǿøjät jim̱ Jerusalén, coo hajxy jim̱ chúum̱äbät, pønjaty miic̈h jaduhṉ yaa xquiapxpaatp. Jaꞌa teedywiindsøṉä cuhdujt hajxy jaduhṉ yejc. Hoorä, tøø jaꞌa Saulo yaa miejtsnä Damasco ―nøm̱ä Ananías miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mänitä Jesús jaꞌa Ananías ñämáaguiumbä: ―Tsógäm, nøcx cudiúṉ nébiøch miic̈h tøø nhaneꞌemiän. Tøøc̈hä Saulo nyajnähdijy coo miädiáꞌagät jaꞌa høøc̈hcøxpä jim̱ maa jaꞌa israelitahajxiän, møød jim̱ maa jaꞌa caꞌa israelitahajxypän, møød jim̱ maa jaꞌa guiobiernähajxiän. ");
INSERT INTO mirNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Høøc̈hä Saulo nyajnähdijaam̱by mäduhṉ̃tiä jaduhṉ yhahixøꞌøy chaac̈hpǿgät jaꞌa høøc̈hcøxpä. ");
INSERT INTO mirNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mänitä Ananías jiaanc̈h nøcxy maa jaꞌa Saulo hänajty tøø miejtstaꞌaguiän. Coo jaꞌa Ananías tiøjtägøøyy, mänitä Saulo quiøꞌønähgajpä. Mänit ñämaayyä: ―Mäguꞌughajpä Saulo, jaꞌa Jesús miic̈h jaduhṉ jim̱ mhijx tuꞌhaammiim̱bä. Jaayáꞌayhøch jaduhṉ yaa tøø xquiex̱y nej miic̈h jaduhṉ mhijxøꞌtägátsät hoy. Y jaduhṉ miic̈hä Dioshespíritu xyhadägøꞌøw xjioottägǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tuuṉä jaꞌa Ananías jaduhṉ ñäꞌä mänaaṉ̃, mänitiä Saulo wyiingahduutä nebiä tsaamghacän. Mänitä yhijxøꞌtägajch. Mänit tiänaayyøꞌcy. Mänit hoy ñäbety. ");
INSERT INTO mirNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mänit quiaayy yhuucy. Møcpøjc jeꞌe jaduhṉ. Mänit jim̱ jiaac mähmøøyy mejtsxøø tägøøgxøø Damasco maa jaꞌa mäbøjpädøjc‑hajxiän. ");
INSERT INTO mirNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mänitä Saulo tiägøøyy mädiaꞌagy‑yajwaꞌxpä wiinduhm̱c̈hajtøjc jim̱ Damasco maa jaꞌa judíos chajtøjc‑hajxiän. Jaduhṉ hänajty miädiaꞌagy coogä Jesús Dyioshuungä. ");
INSERT INTO mirNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Pønjaty jaꞌa Saulo miädiaꞌagy hänajty hamädoow̱híjtäp, jiaanc̈h tehm̱ yagjuøøby hajxy hänajty jaduhṉ nebiä Saulo hänajty miädiaꞌaguiän jaꞌa Jesúscøxpä. Mänit hajxy tiägøøyy niñämáayyäbä: ―Yøꞌø craa Saulo, jueꞌe yøꞌø, yøꞌø jaꞌa mäbøjpädøjc jim̱ wiꞌi miädsibøøby Jerusalén, pønjatiä Jesús capxpaatp. Paady yøꞌø yaa tøø piejpä Damasco coo jaꞌa mäbøjpädøjc‑hajxy yaa miájtsäbät, møød coo hajxy jim̱ yajnøcxøød Jerusalén hadsip, jaduhṉ hajxy jim̱ nøcxy quiøꞌøyegyii maa jaꞌa teedywiindsøṉhajxiän ―nøm̱ä Saulo ñänøøm̱ä. ");
INSERT INTO mirNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Y jaꞌa Saulo, tehṉgahnä hänajty hamøj jootmøj jiaty coo jaꞌa tsaanä cuꞌug hänajty yajwiinxiic yajwiingapxøꞌøy coogä Jesús Dyioswiinguex̱iä. Jaanc̈h tehm̱ homiäbøjnä hänajty miädiaꞌagy. Y jaꞌa judíoshajxy, jaꞌa hajxy hänajty jim̱ tsänaabiä Damasco, cabä Saulo hajxy hänajty hoy quiapxhadugaꞌañ, jeꞌeguiøxpä coo Saulo hänajty miädiaꞌagy hamøj jootmøj. ");
INSERT INTO mirNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Cujecy, mänitä judíoshajxy jim̱ yhamugøøyy. Mänit hajxy quiojyquiapxytiuuṉ̃ coogä Saulo hajxy hänajty yaghoꞌogaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Xøømdsuhm̱ä Saulo hänajty miäxojnaꞌayii mäduhṉjatiä tägøꞌøwøødiaactän maa jaꞌa Damasco‑cajpt jiuhmuuꞌtswäditiän. Mänitä Saulo jaduhṉ miädoyhajty cooc hänajty yaghoꞌogaꞌañii. ");
INSERT INTO mirNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mänitä mäbøjpädøjcä Saulo hajxy coods piädaacy møjcachjooty. Mänit hajxy quiuhdøøñajxy maa jaꞌa cajpt hänajty piquiä yhamuudsøꞌøguiän. Jaduhṉdsä Saulo piäyøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Coo Saulo jim̱ chohṉ̃ Damasco, mänit jim̱ ñøcxtägajch Jerusalén. Coo jim̱ quiooꞌty, mänit jim̱ ñøcxøøyy maa jaꞌa mäbøjpädøjc‑hajxiän. Pero jeꞌenä jaꞌa Saulo hajxy hänajty nägøx̱iä jiaanc̈h tehm̱ chähgøꞌøy. Hix̱, cab hajxy hänajty ñajuøꞌøy pø mäbøjp hänajty jeꞌebä. ");
INSERT INTO mirNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Jim̱ä mäbøjpä hänajty tuꞌug xiøhaty Bernabé. Jeꞌe mäbøcypiä, cab hänajty chähgøꞌøy. Mänitä Bernabé jaꞌa Saulo wioonøcxy maa jaꞌa apóstoldøjc‑hajxiän. Mänitä Bernabé jaꞌa apóstoldøjc yajmøødmädiaacy coogä Saulo jaꞌa Jesús hänajty tøø wyiinhix̱y tuꞌhaamnøcxpä jim̱ Damasco‑mäwiingóṉ, møød coogä Jesús jaꞌa Saulo jim̱ miägapxy, møød coogä Saulo tiägøøyy mädiaacpä hamøj jootmøj jim̱ Damasco jaꞌa Jesúscøxpä. Jaduhṉä Bernabé jaꞌa apóstoldøjc yajmøødmädiaacy jaꞌa Saulocøxpä. ");
INSERT INTO mirNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mähmøøyy jaꞌa Saulo jim̱ Jerusalén. Mänitä Saulo jaꞌa apóstoldøjc tiägøøyy møødwädijpä. Mänitä mädiaꞌagy tiägøøyy yajwaꞌxpä jaꞌa Jesúscøxpä hamøj jootmøj. ");
INSERT INTO mirNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jim̱ä judíoshajxy hänajty näjeꞌe, hagriego hajxy hänajty yhayuuc‑hajpy. Mänitä Saulo tiägøøyy møødyajcapxiøøbiä jaꞌa Jesúscøxpä. Pero cabä judíoshajxy jaduhṉ yhojiäwøøyy. Mänit hajxy wyiinmaayy coo jaꞌa Saulo hajxy yaghóꞌogät. ");
INSERT INTO mirNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Coo jaꞌa mäbøjpädøjc‑hajxy jaduhṉ miädoyhajty coogä Saulo hänajty yaghoꞌogaꞌañii, mänitä Saulo hajxy miøødnøcxy jim̱ Cesarea. Coo hajxy jim̱ miejch, mänitä Saulo hajxy quiejxtägajch Tarso. ");
INSERT INTO mirNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mänitä tsip jaduhṉ yhamaadiujnä jaꞌa mäbøjpädøjcøxpähajxy, mäduhṉjaty hajxy hänajty xii yaa chänaꞌay, møød jim̱ Judea, jim̱ Galilea, jim̱ Samaria. Tehṉgahnä møcmäjaa hajxy hänajty mioꞌoyii jøjwidsøꞌø jaꞌa Dioshespíritäm, paady hajxy hänajty jabom̱‑jabom̱ miayøꞌøy. ");
INSERT INTO mirNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Y jaꞌa Pedro, wiinduhm̱c̈hajtøjc hänajty wiädity mäduhṉjatiä mäbøjpädøjc‑hajxy hänajty chänaꞌay. Mänit jim̱ ñøcxøøbiä maa jaꞌa cajpt hänajty xiøhatiän Lida. Jim̱ä mäbøjpädøjc‑hajxy hänajty chänaabiä. ");
INSERT INTO mirNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Jim̱ä jäyaꞌay hänajty tuꞌug piaꞌamgoꞌnaꞌay, jaꞌa hänajty xøhajpä Eneas. Tuctujcjumøjt hänajty tøø piøgyii. Jueꞌe hänajty jeꞌe, cøꞌømucy tecymiucy. Coo jaꞌa Pedro jim̱ miejch Lida, mänit jim̱ ñøcxy maa Eneas tiøjcän. ");
INSERT INTO mirNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Mänitä Pedro miänaaṉ̃: ―Eneas, jaꞌa Jesucristo miic̈h xyajmøcpøgaam̱b. Pädøꞌøg. Pädit yøꞌø mgøjxt. Tuuṉä jaꞌa Eneas jaduhṉ ñäꞌä nämaayyä, mänitiä jiaanc̈h pädøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mäduhṉ̃tiä jäyaꞌayhajxy hänajty chänaꞌay jim̱ Lida møød jim̱ maa jaꞌa joy hänajty xiøhatiän Sarón, coo hajxy jaduhṉ miädoyhajty coogä Eneas hänajty tøø piaꞌamnax̱y, mänitä Eneas hajxy nägøx̱iä hoy yhix̱y coo tøø jiaanc̈h møcpøcy. Mänitä Diosmädiaꞌagy hajxy tiägøøyy mäbøjpä jaꞌa Jesúscøxpä. Mänitä yhamdsoo cuhdujt hajxy ñajtshixøøñä. ");
INSERT INTO mirNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jim̱ä tajjäyaꞌay hänajty tuꞌug chänaꞌay maa jaꞌa cajpt hänajty xiøhatiän Jope. Tabita jaꞌa tajjäyaꞌay hänajty xiøhaty arameo‑ayuuc‑haamby. Hagriegohaamby, jueꞌe hajxy hänajty tyijy Dorcas. Jaduhṉ miädiaꞌagytiägøꞌøy “Gacela.” Hoorä, jaꞌa Dorcas, miäbøjpiä Diosmädiaꞌagy hänajty jeꞌe, paadiä häyoobädøjc hänajty nax̱y piuhbety, pønjaty hänajty tii yajmaajiajp. Jaanc̈h tehm̱ yhoyyä Dorcas hänajty jiäyaꞌayhaty. ");
INSERT INTO mirNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mänitä Dorcas piaꞌambejty. Mänit yhoꞌcy. Mänitä hoꞌogyjiäyaꞌay hajxy yajtsiiyy. Mänit hajxy hoy piädaꞌagy cøxp nähbettøgooty. ");
INSERT INTO mirNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jim̱ Jope, wiingóṉ hänajty jim̱ Lida maa jaꞌa Pedro hänajty yhitiän. Hoorä, jaꞌa mäbøjpädøjc‑hajxy hänajty jim̱ tsänaabiä Jope, coo hajxy jaduhṉ miädoyhajty coogä Pedro hänajty jim̱ wiädityñä Lida, mänitä cugapxy hajxy metsc quiejxy coo Pedro paquiä yhuuc nǿcxät jim̱ Jope maa jaꞌa Dorcas hänajty tøø yhoꞌoguiän. ");
INSERT INTO mirNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mänitä Pedro jiaanc̈h panøcxy. Coo hajxy jim̱ miejch Jope, mänitä Pedro wioonøcxä nähbettøgooty maa jaꞌa hoꞌogyjiäyaꞌay hänajty wyijtsnaꞌayän. Piquiä jaꞌa yaamgtoꞌoxy jaꞌa hoꞌogyjiäyaꞌay hajxy hänajty tøø piädaꞌagy. Wiꞌi jiøøby wiꞌi xiuuꞌtsp hajxy hänajty. Mänitä Pedro jaꞌa wit tucxy yaghijxä mädyiijatiä Dorcas hänajty tøø yhädiuṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mänitä Pedro jaꞌa jäyaꞌay nägøx̱iä yhøxquejxpädsøøm̱y. Mänitä Pedro jyijcädaacy. Mänit Dyiospaꞌyaax̱y. Mänitä hoꞌogyjiäyaꞌay wyiinheeꞌppejty. Mänit miänaaṉ̃: ―Tabita, pädøꞌøg. Mänitä Dorcas wyiindøøꞌxøꞌcy. Coo jaꞌa Dorcas jaꞌa Pedro yhijxy, mänitä Dorcas yhäñaayyøꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Mänitä Pedro jaꞌa Dorcas wyidsøꞌcy. Mänitä Pedro jaꞌa mäbøjpädøjc quiuyaaxøøyy tøgooty møødä yaamgtoꞌoxy. Coo hajxy tiøjtägøøyy, mänit hajxy yhijxy coo jaꞌa Dorcas hänajty tøø jiujypiøjnä. ");
INSERT INTO mirNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mänitä mädiaꞌagy paquiä wiaꞌxy jim̱ Jope cooc jaduhṉ tøø jiujypiøcy. Mänitä jäyaꞌayhajxy may jiaanc̈h mäbøjcy jaꞌa Jesúscøxpä. ");
INSERT INTO mirNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Mänitä Pedro jim̱ jiaac mähmøøyy Jope maxiøø. Jim̱ hänajty miejtstaꞌagy maa jaꞌa Simón tiøjcän, jaꞌa wajhacyajtøøtspä. ");
INSERT INTO mirNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Jim̱ä jäyaꞌay hänajty tuꞌug chänaꞌay Cesarea, jaꞌa hänajty xøhajpä Cornelio. Soldado‑wiindsǿṉ hänajty tiuum̱by. Italia jaꞌa soldadohajxy hänajty chooñ. Nämayyä soldadohajxy hänajty jim̱ yhity Cesarea. ");
INSERT INTO mirNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Hoyyä Cornelio jaꞌa Dios hajxy hänajty wyiingudsähgøꞌøy møødä yhuung møødä tioꞌoxy. Hojiootä Cornelio hänajty jiaanc̈h tehm̱ miøød. Nax̱iä judíoshajxy hänajty piuhbedyii xädøꞌøñhaam, jaꞌa hajxy hänajty häyoobä. Jabom̱‑jabom̱ä Cornelio hänajty Dyiospaꞌyaꞌaxy. ");
INSERT INTO mirNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mänacyxiøø hänajty jaduhṉ, jim̱ä Cornelio hänajty tiuṉ̃ xiajy tøgooty, mänitä Diosmoonsä tuꞌug ñäguehx̱tøøꞌxy maa Cornelio hänajtiän. Tsajpootyp jaꞌa Diosmoonsä hänajty tøø chohṉdaꞌagy. Mänitä Diosmoonsä jaꞌa Cornelio ñämaayy: ―Cornelio. ");
INSERT INTO mirNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Coo jaꞌa Cornelio jaꞌa Diosmoonsä jaduhṉ yhijxy, chähgøøyy jaduhṉ. Jejcy‑juøøby miäheeꞌpnaayy. Mänit miäyajtøøyy: ―Wiindsǿṉ, tii mdsojpy. Mänitä Diosmoonsä yhadsooyy: ―Xquiumaaby miic̈hä Dios jaduhṉ coo miic̈h tehṉgahnä mbaꞌyaꞌaxy, møød coo miic̈hä häyoobäjäyaꞌay nax̱y mbuhbety. ");
INSERT INTO mirNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","6","Jim̱ Jope, jim̱ä jäyaꞌay tuꞌug chänaꞌay mejypiaꞌa, jaꞌa xøhajpä Simón. Jueꞌe Simón tiuuṉghajpy, wajhacyajtøøtsp. Jim̱ä craa tuꞌug yhahäñaꞌay maa jaꞌa Simón tiøjcän. Mejtstuꞌu jaꞌa craa xiøø, Simón møød Pedro. Jim̱ä cugapxy mejtstägøøg mguéxät Jope, weenä Pedro jaduhṉ nøcxy ñämaꞌayii cooc miic̈h yaa miṉ xquiuhix̱y. Jaayaꞌay jaduhṉ xyhawáaṉäp tii miic̈hä Dios xyajmädsojp coo mgudiúnät ―nøm̱ä Diosmoonsä miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Coo jaꞌa Diosmoonsä wyiimbijnä, mänitä Cornelio jaꞌa mioonsä metsc quiuyaaxøøyy møødä soldado tuꞌug. Dioswiingudsähgøøbiä soldado hänajty. Miøødnijiootpáatäbä Cornelio jaꞌa soldado hänajty. ");
INSERT INTO mirNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Mänitä Cornelio quiøx̱y yajmøødmädiaacy waam̱baty hänajty tøø ñämaꞌayii jaꞌa Diosmóonsäm. Mänitä Cornelio jaꞌa mioonsä jim̱ quiejxy Jope nädägøøg møødä soldado. ");
INSERT INTO mirNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Cujaboom cujyxiøø, jim̱ hajxy hänajty tiuꞌuyoꞌoyñä. Ja ween hajxy hänajty jim̱ quiaꞌa mech Jope. Y jaꞌa Pedro, mänit jim̱ wyiimbejty tøjnähgøxp Diospaꞌyaax̱pä. ");
INSERT INTO mirNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Jaanc̈h tehm̱ yähóꞌcäbä Pedro hänajty. Jaguiay hänajty jeꞌeduhṉ. Jim̱ä quiay hänajty yaghoyǿøyyäxä. Mänit jaduhṉ wyiinhijxy ");
INSERT INTO mirNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","coo jaꞌa tsajt hänajty tøø yhawaꞌac̈h. Mänit jaduhṉ yhijxy coo tii jaduhṉ quiuhdøøñaxyii nebiä poobwit crutypän. Mädaax̱c‑hitä poobwit hänajty xiojtsøꞌøguiä. Jaduhṉ hänajty miänooṉnaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Madiuꞌu animalhajxy hänajty jim̱ quiähxøꞌøgy poobwittøguiøxp, møødä hamädaax̱tecypiähajxy, møødä tsahṉ̃dy, møødä muuxy. ");
INSERT INTO mirNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mänitä Dios jaꞌa Pedro ñämaayy: ―Pedro, pädøꞌøg. Yaghoꞌog yøꞌø animal maybä. Mänit mdsúꞌudsät. ");
INSERT INTO mirNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mänitä Pedro yhadsooyy: ―Wiindsǿṉ, caj; cábøch yøꞌø animal jaduhm̱bä mänaa ndsuꞌuc̈h. Hix̱, cab højts nguhdujt jaduhṉ myiṉ̃ coo højts animal hoñäꞌä mädyiibä ndsúꞌudsät. ");
INSERT INTO mirNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mänitä Pedro ñämáayyägumbä: ―Tijátyhøch nyajnähdijpy coo hajxy mdsúꞌudsät, cab jaduhṉ yhahixøꞌøy coo hajxy mwiingápxät ―nøm̱ä Dios miänaaṉ̃. ");
INSERT INTO mirNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tägøøghoocä Pedro jaduhṉ miägapxä, mänit yhijxy coo jaꞌa poobwit chajpéjcumbä tsajpootyp. ");
INSERT INTO mirNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Wyiꞌi tiajpy wyiꞌi miaabiä Pedro hänajty tiiguiøxpä hänajty jaduhṉ coo tøø wyiinhix̱y. Y jaꞌa Cornelio quiugapxyhajxy, tøø jaꞌa Simón jaꞌa tiøjc hajxy hänajty piáatänä. ");
INSERT INTO mirNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mänit hajxy møc quiugapxøøyy pø jiibiä Simón Pedro jiaanc̈h hity. ");
INSERT INTO mirNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Y jaꞌa Pedro, jeꞌenä hänajty wyiꞌi tiajy wyiꞌi miay tiiguiøxpä hänajty jaduhṉ coo tøø wyiinhix̱y. Mänitä Dioshespíritu jaꞌa Pedro ñämaayy: ―Mädow̱, xiiby miic̈h hänaꞌc nädägøøg xyhøxtaꞌay. ");
INSERT INTO mirNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mänac, nøcx yøꞌø hänaꞌc yajtøjtägøꞌøw. Hoy jaduhṉ coo mbanǿcxät coo hajxy hänajty wyiimbidaꞌañ. Hix̱, høøc̈h yøꞌø hänaꞌc jaduhṉ tøø nguex̱y coo miic̈h jaduhṉ xwioonǿcxät maa jaꞌa quiajpthajxiän. ");
INSERT INTO mirNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Mänitä Pedro jiaanc̈h mänajcy. Mänitä Pedro jaꞌa hänaꞌc nädägøøgpä ñämaayy: ―Høøc̈h Pedrohajp. Høøc̈h mijts xyhøxtaaby. Tiic̈h mijts xwiaꞌanaꞌañ. ");
INSERT INTO mirNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mänit hajxy yhadsooyy: ―Jaꞌa Cornelio højts tøø xquiex̱y, jaꞌa soldado‑wiindsǿṉ. Jaanc̈h tehm̱ yhojiäyaꞌay jeꞌe. Dioswiingudsähgøøby jeꞌe. Jiaanc̈h tehm̱ chojpiä judíos jaꞌa Cornelio hajxy. Jiaanc̈h tehm̱ quiumaaby hajxy jaduhṉ ―nøm̱ä Pedro ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mänitä Pedro jaꞌa hänaꞌc nädägøøgpä ñämaayy coo hajxy tiøjtägǿꞌøwät, møød coo hajxy jim̱ miejtstáꞌagät. Cujaboom hajxy wyiimbijnä näguipxy møødä Pedro. Näjeꞌe jaꞌa mäbøjpädøjc‑hajxy pianøcxpä, jaꞌa hajxy hänajty jim̱ tsänaabiä Jope. ");
INSERT INTO mirNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Cumaax̱c hajxy jim̱ miejch Cesarea. Jim̱ä Cornelio hänajty yhahix̱y, møødä jiujy møødä miäguꞌug, møødä miäguꞌughajpähajxy. ");
INSERT INTO mirNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Coo jaꞌa Pedro jim̱ miejch maa jaꞌa Cornelio tiøjcän, mänitä Cornelio jaꞌa Pedro yajpooꞌxy. Mänitä Cornelio jaꞌa Pedro wyiinjijcädaacy. Wyiingudsähgøꞌøwaam̱biä Cornelio jaꞌa Pedro hänajty jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mänitä Pedro jaꞌa Cornelio ñämaayy: ―Tänaayyøꞌøg, caꞌac̈h nDiosä. Näꞌä pajäyaꞌayhájpøch høøc̈h nej miic̈hän. Cab jaduhṉ yhahixøꞌøy cooc̈h miic̈h xwyiingudsähgǿꞌøwät. ");
INSERT INTO mirNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mänitä Cornelio jiaanc̈h tänaayyøꞌcy. Mänit hajxy paquiä miädiaacy. Mänit hajxy tiøjtägøøyy maa jaꞌa Cornelio miäguꞌughajpähajxy hänajty nämay tøø yhamugøꞌøyän. ");
INSERT INTO mirNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mänitä Pedro miänaaṉ̃: ―Højts judíos‑jäyaꞌay, jaduhṉ højts nguhdujt myiṉ̃ coo højts jiiby ngaꞌa tøjtägǿꞌøwät maa jäyaꞌay tiøjc‑hajxiän, jaꞌa hajxy caꞌa judíospä, nébiøch chaa tøø ndøjtägøꞌøyän. Cooc̈hä Dios jaduhṉ xyajwiinhijxy, jadúhṉhøch tøø xyajwiinjuøꞌøy coo jaduhṉ quiaꞌa hahixøꞌøy cooc̈h pøṉ nbéxät. ");
INSERT INTO mirNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Paady, cooc̈hä Cornelio tøø xyajmøjyaꞌaxyii, páadyhøch jaduhṉ tøø ngaꞌa mänaꞌañ cooc̈h hänajty ngaꞌa minaꞌañ. Huuc tuṉä mayhajt, høøc̈h huuc hawáaṉäc tiic̈h jaduhṉ coo tøø xyajmøjyaꞌaxyii. ");
INSERT INTO mirNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Mänitä Cornelio yhadsooyy: ―Maaxtøjcy mädägøøyy, yáabiøch hänajty nDiospaꞌyaꞌaxy tøgooty. Mänacyxiøø hänajty jeꞌe. Mänitä jäyaꞌay tuꞌug ñäguehx̱tøøꞌxy høøc̈h nwiinduum. Jaanc̈h tehm̱ yhaam̱bä wyit hänajty. ");
INSERT INTO mirNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Mänítøch xñämaayy: “Cornelio, tøø miic̈hä Dios xmiädoy coo jaduhṉ jabom̱‑jabom̱ mbaꞌyaꞌaxy. Xquiumaaby miic̈hä Dios jaduhṉ coo miic̈hä häyoobädøjc mnäxuuc̈h. ");
INSERT INTO mirNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Capxyñäguex̱ jaꞌa Simón Pedro jim̱ Jope coo ween yaa myiṉ̃. Jim̱ jaduhṉ yhahäñaꞌay maa jaꞌa craa Simónhajpä tiøjcän, jaꞌa wajhacyajtøøtspä. Mejypiaꞌa mädøyyä chänaꞌay. Coo jaꞌa Simón Pedro yaa miédsät, mänit miic̈h jaduhṉ xmiøødmädiaꞌagaꞌañ.” ");
INSERT INTO mirNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mänítøch hänaꞌc jim̱ njaanc̈h quejxy coo miic̈h nøcxy xwioy. Hoy jaduhṉ coo tøø mmiṉ̃. Paady højts yaa tøø nhamugøꞌøy coo højts miic̈h mgapxy mmädiaꞌagy nhamädoow̱hidáaṉäm nebiaty miic̈hä Dios tøø xñajtscapxøøyyän coo højts jaduhṉ xyajmøødmädiaactägátsät. Xyhijxp højtsä Dios jaduhṉ coo højts hamuumduꞌjoot nmäbøgaꞌañ ―nøm̱ä Pedro ñämaayyä. ");
INSERT INTO mirNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mänitä Pedro tiägøøyy mädiaacpä: ―Tøøc̈h nwiinjuøøñä coo højtsä Dios tuꞌcuhdujt xchójcäm. Cabä Dios pøṉ hix̱y heeby piädaꞌagy. Tøyhajt jaduhṉ. ");
INSERT INTO mirNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pønjatiä Dios jaduhṉ wiingudsähgøøby hamuumduꞌjoot, pønjaty hojioot møød, jeꞌedsä Dios quiumaaby, homiädyii cajptä hajxy jia tsooñ. ");
INSERT INTO mirNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","37","Mänaa jaꞌa Juan tiägøꞌøyän mäyajnäbejpä, mänitä mädiaꞌagy jim̱ tiägøøyy yajwaꞌxpä Galilea‑naaxooty cooc jaꞌa Dios jaꞌa Jesucristo hänajty quiexaꞌañ maa jaꞌa israelita‑jäyaꞌayhajxiän, majaty hajxy hänajty chänaꞌay, jaduhṉä piojpä quiädieeybä hajxy ñähwaꞌads quiuhwáꞌadsät. Jaayaꞌay hajxy nägøx̱iä nWiindsøṉhájtäm. ");
INSERT INTO mirNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nazaret jaꞌa Jesús hänajty chooñ. Mänitä Dios jaꞌa Jesús jaꞌa yhEspíritu miooyy møødä mäjaa. Jaduhṉä Jesús wyiinguejxä coo wiädítät mayhajtuum̱bä. Pønjaty hänajty pǿjcäp, yajpaꞌamnájxäp hajxy hänajty. Pønjatiä haxøøgpä caꞌa hoybä hänajty møød, yajnähwáatsäp hajxy hänajty. Puhbéjtäbä Jesús hänajty jaꞌa Diósäm. ");
INSERT INTO mirNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Højts, hamdsoo højts nhijxy tijatiä Jesús jim̱ tiuuṉ Judea‑naaxooty møød jim̱ Jerusalén. Paady højtsä tøyhajt nmøødä coo tiøyyä. Mänitä Jesús miøjpahbejtä cruzcøxp. Jaduhṉ yhoꞌcy. ");
INSERT INTO mirNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Pero cumaax̱cä Dios jaꞌa Jesús yagjujypiøjcy. Mänit højtsä Dios jaꞌa Jesús xyaghijxy coo hänajty tøø jiaanc̈h jujypiøcy. Cabä jäyaꞌayhajxy nägøx̱iä yhijxy. Jagooyyä højts nhijxy. Paady højtsä Dios xyaghijxy coo højts hänajty jaduhṉ tøø xyajnähdijy. Mänit højtsä Jesús nmøødcaayy nmøødhuucy. ");
INSERT INTO mirNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Mänit