﻿USE sofia;
DROP TABLE IF EXISTS sofia.mioNT_vpl;
CREATE TABLE mioNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mioNT_vpl WRITE;
INSERT INTO mioNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tutu ya ndiso sivi ñivi cuu tata cha vachi chinu ra Jesucristo tiempu chahnu. Ñivi ra chi ra David, ta ñivi ra chi ra Abraham. ");
INSERT INTO mioNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham cuu sutu ra Isaac, ta Isaac can cuu sutu ra Jacob. Jacob can cuu sutu ra Judá chi yani ra. ");
INSERT INTO mioNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá can cuu sutu ra Fare chi ra Zara, ta Tamar cuu sihi ra ta ra. Fare can cuu sutu ra Esrom, ta Esrom can cuu sutu ra Aram. ");
INSERT INTO mioNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram can cuu sutu ra Aminadab, ta Aminadab can cuu sutu ra Naasón. Naasón can cuu sutu ra Salmón, ");
INSERT INTO mioNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ta Salmón can cuu sutu ra Booz, ta Rahab cuu sihi ra. Booz can cuu sutu ra Obed, ta Rut cuu sihi ra. Obed can cuu sutu ra Isaí, ");
INSERT INTO mioNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ta Isaí can cuu sutu ra David ra ndaca ñahan chi ñivi Israel. David can cuu ra cuu sutu ra Salomón, ta sihi ra cuu ña ni cuu ñasihi ra Uría. ");
INSERT INTO mioNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón can cuu sutu ra Roboam, ta Roboam can cuu sutu ra Abía. Abía can cuu sutu ra Asa, ");
INSERT INTO mioNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ta Asa can cuu sutu ra Josafat. Josafat can cuu sutu ra Joram, ta Joram can cuu sutu ra Uzía. ");
INSERT INTO mioNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzía can cuu sutu ra Jotam, ta Jotam can cuu sutu ra Acaz. Acaz can cuu sutu ra Ezequía, ");
INSERT INTO mioNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ta Ezequía can cuu sutu ra Manasee. Manasee can cuu sutu ra Amón, ta Amón can cuu sutu ra Josía. ");
INSERT INTO mioNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josía can cuu sutu ra Jeconía chi yani ra quivi cha ni tiin ra iyo ñuhun Babilonia chi ñivi Israel, ta tava ndaa ra ta ra chi ñi nu ñuhun ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tacan ni queta ñivi Israel ñuhun Babilonia can, ta ni chacoo sehe ra Jeconía can, ta Salatiel cha cunani ra. Salatiel can cuu sutu ra Zorobabel, ");
INSERT INTO mioNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ta Zorobabel can cuu sutu ra Abiud. Abiud can cuu sutu ra Eliaquim, ta Eliaquim can cuu sutu ra Azor. ");
INSERT INTO mioNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor can cuu sutu ra Sadoc, ta Sadoc can cuu sutu ra Aquim. Aquim can cuu sutu ra Eliud, ");
INSERT INTO mioNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ta Eliud can cuu sutu ra Eleazar. Eleazar can cuu sutu ra Matán, ta Matán can cuu sutu ra Jacob. ");
INSERT INTO mioNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob can cuu sutu ra José ra cuu ii ña María sihi ra Jesucristo. ");
INSERT INTO mioNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Cha queta uchi cumi ñivi cuu ñivi ra Jesuu nda quivi ni chacoo ra Abraham nda quivi cha ni chacoo ra David tiempu chahnu, ta cha queta ndico inga uchi cumi ñivi ra nda quivi ni chacoo ra David nda quivi cuahan ñivi Israel iti ñuhun Babilonia suvi ni tiempu chahnu, ta nda quivi can ta nda quivi cha ni cacu ra Jesuu cha queta ndico tucu inga uchi cumi ñivi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Chehe cuu tuhun yoso cuhva ni cacu ra Jesucristo. Cha iyo vaha tuhun cha cua tandaha ña María sihi ra chi ra José. Ña ta coo ña chi ra, ta nihin ña cuhva ti cha cua coo sehe ña savaha ra Tati Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Rai vaha cuu ra José ra cua cuu ii ña. Chacan cuu cha saxini ra ti cua saña xehe ra chi ña, vati ña cuni ra cha cua coo tu ca nuun chi ña iti nuun ndihi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ni vii nanducu xini ra ñaan cha cuu cha cua savaha ra, ta ndehe ra chi iin tatun ra chahnu Ndioo tichi ñumahna, ta quechaha cati ra tatun Ndioo can chi ra ti: ―Yoho José, ñivi ra David chihin cun. Ña cua saxini cun, soco cua naquihin cun chi ña María ñasihi cun, vati tuvi maan sehe ña tichi ña savaha ra Tati Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Cua cacu sehe ña, ta Jesuu cua sacunani ndo chi ra, vati cua sacacu ra chi ñivi cuu ñivi ra, ta cua naan cuati savaha ñi ―cati ra tatun Ndioo can. ");
INSERT INTO mioNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ndihi chacan ni chacoo, vati tacan ni quee tuhun cuhva ni cati tuhun ra chahnu Ndioo chi ra ni cahan cuenda ra Ndioo nu ni quichi quivi, vati cha cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Cua tuvi sehe iin ña yoco, ta cua queta quivi cua cacu ra. Emanuel cua cunani ra, cati ra cahan cuenda ra Ndioo can. Cuni cati tuhun Emanuel can ti iyo ra Ndioo chihin yo. ");
INSERT INTO mioNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tacan cuu, ta hora can ndoyo ra José, ta savaha ra cuhva cati tuhun tatun ra chahnu Ndioo. Quihin ra chi ñasihi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","soco ña ni chacoo ra chi ña nda cua nda quivi ni cacu sehe ña. Tacan cuu, ta chacunani ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Quivi cha ni ndaca ñahan ra Herode cacu ra Jesuu ñuun Belén cha iyo cuenda ñuhun Judea. Suvi ni quivi can queta ra sacuaha chi ri tiñu. Inga ñuhun chiyo nu cana nicandi quichi ra, ta queta ra ñuun Jerusalén, ");
INSERT INTO mioNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ta quechaha nducu tuhun ra ti: ―¿Ndaa cuu nu ni cacu ra cuu ra cua cundaca ñahan chi ñivi judío? Nducu tuhun ndi, vati cha ni ndehe ndi cha ndaa ri cuu tiñu ra chiyo cana nicandi, ta vachi ndi, vati cuni sacahnu tahan ndi chi ra ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tuhun can chini ra Herode can, ta quechaha saxini xaan ra, ta yuhvi tahan ndihi ñivi iyo ñuun Jerusalén can. ");
INSERT INTO mioNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tacan cuu, ta sacuiti ra chi ndihi ra sutu chahnu chi ndihi ra sacuaha ley chahnu cha sacahnu ñivi can, ta quechaha nducu tuhun ra chi ra ta ra ndaa cuu nu cua cacu ra Cristo. ");
INSERT INTO mioNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tacan cuu, ta cati ndico ra ta ra ti: ―Iti ñuun Belén cha iyo cuenda ñuhun Judea cua cacu ra, vati tacan ni taa ra ni cahan cuenda ra Ndioo nu ni quichi quivi. Cha cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ndioho ñivi ñuun Belén cha iyo cuenda ñuhun Judea, cahnu xaan cua coo ñuun ndo, vati iin rai cahnu xaan cua quee ñuun ndo, ta cua cundaca ñahan ra chi ñivi ra Ndioo ñivi Israel, cati ra ―cati ra sutu chahnu ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tacan cuu, ta cana xehe ra Herode chi ra sacuaha tiñu can, ta nducu tuhun ra chi ra ta ra ndaa quivi ni quechaha ndehe ra ta ra tiñu can iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tacan cuu, ta cati ra ti: ―Cuahan ndo iti ñuun Belén, ta cua nanducu vaha ndo chi ve luhu can. Tacan cua nanihin ndo chi ve, ta sa cua quichi cati ndo chihin yu, vati tacan cua cuhun tahin, ta sa cua sacahnu tahin chi ve ―cati ra. Tacan tava tiñu ra chi ra ta ra iti ñuun Belén. ");
INSERT INTO mioNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chini ra ta ra cha ni cahan ra Herode can, ta cuahan ra. Ni ndehe ndico tucu ra chi ri tiñu ndehe xihna ra chiyo nu ni quichi ra, ta iti nuun ra ta ra cuahan ri nda cua nda ni queta ri xini vehe nu caa ve luhu can. ");
INSERT INTO mioNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ndehe ra ta ra nu chacuiñi ri, ta sii xaan quechaha cuni ra. ");
INSERT INTO mioNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tacan cuu, ta quihvi ra ta ra tichi vehe can, ta ndehe ra ta ra chi maan ve luhu can chi ña María sihi ve. Tacan cuu, ta chahnu chiti ra, ta sacahnu ra ta ra chi ve. Nuna ra ta ra cha naan ra, ta samani ra ta ra chi ve. Samani ra xuhun cuaan. Samani ra cutu. Samani ra suchan xico vixin chahan. Samani ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tacan cuu, ta cati ra Ndioo chi ra ta ra chi ñumahna ti ña cua yaha ndico ra ta ra nuun ra Herode. Chacan cuu cha quihin ra ta ra inga iti, ta cuahan ndico ra iti ñuun ra. ");
INSERT INTO mioNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cha cuahan ra sacuaha chi ri tiñu, ta cahan tucu ra tatun ra chahnu Ndioo chi ra José chi ñumahna, ta cati ra chi ra ti: ―Cua cuinda cun, ta cua quihun chi ve luhu sehun chi sihi ve, ta cua cunu ndo cuhun ndo iti ñuhun Egipto. Cua ndoo ndo tican nda cua nda quivi cua cati ndique chihun, vati cua nanducu ra Herode chi ve, vati cua cahni run chi ve ―cati ra tatun Ndioo can. ");
INSERT INTO mioNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tacan cuu, ta quihin ra José chi ve chi sihi ve cha cuaa can, ta cuahan ñi iti ñuhun Egipto. ");
INSERT INTO mioNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ican ndoo ñi nda quivi ni chihi ra Herode can. Chacan cuu cha queta tuhun ra chahnu Ndioo cuhva ni cati ra cahan cuenda ra Ndioo nu ni quichi quivi, vati cha cati ra ti iti ñuhun Egipto cana ra chi sehe ra, cati ra Ndioo ―cati racan. ");
INSERT INTO mioNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tacan cuu, ta nihin ra Herode cuhva ti sandahyu ñahan ra sacuaha chi ri tiñu chi ra, ta xaan xaan ra cuu. Tacan cuu, ta cati tuhun ra ti cua cuvi ndihi ra cuati ndihli iyo ñuun Belén chi ndihi ranchu iyo yatin ñuun can. Chahni ra chi ndihi ra ña ta queta uvi cuiya ra, vati cuhva can saxini ra Herode cha ni cacu ra nanducu ra sacuaha chi ri tiñu can. ");
INSERT INTO mioNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tacan queta tuhun cha ni cati ra Jeremía nu ni quichi quivi, vati cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Chini ñivi ti ndahyu ñivi ñuun Ramá. Cuihya xaan cuni anima ñi, ta ndahyu chaa ñi. Cuvaa ñivi cuu ñivi ña Raquel cuenda sehe ñi, ta ña cuni ñi cha cua cava taxin anima ñi, vati cha ni chihi ve, cati ra Jeremía can. ");
INSERT INTO mioNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tacan cuu, ta queta quivi chihi tahan ra Herode can, ta queta ndico tucu tatun ra chahnu Ndioo nu iyo ra José iti ñuhun Egipto can, ta quechaha cahan tucu ra chi ra José tichi ñumahna, ");
INSERT INTO mioNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ta cati ra chi ra ti: ―Cua cuinda cun, ta cua quihun chi ve luhu sehun chi sihi ve, ta cua cuhun ndico ndo iti ñuhun Israel, vati cha ni chihi ra nducu cahni chi ve ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chacan cuu cha ni chacuinda ra José, ta quihin ra chi ve chi sihi ve, ta quee ñi cuahan ñi iti ñuhun Israel. ");
INSERT INTO mioNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tacan cuu, ta chini soho ra ti ra Arquelao cuu ra ndiso tiñu ra Herode sutu ra, ta ndaca ñahan ra iti ñuhun Judea can. Chacan cuu cha yuhvi ra José cuhun ndico ra tican. Cahan ndico tucu ra Ndioo chi ra tichi ñumahna, ta cuahan ra José chi ñi iti ñuhun Galilea. ");
INSERT INTO mioNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Cuahan ra tican, ta ni chacoo ra iin ñuun nani Nazaret. Chacan cuu cha queta tuhun cahan ra ni cahan cuenda ra Ndioo, vati cati ra ti ra ñuun Nazaret cua cuu ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Suvi ni tichi quivi can queta ra Juaan ra sacuanduta tichi cuhu iti ñuhun Judea can, ta cati tuhun ra tuhun vaha. ");
INSERT INTO mioNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Cati ra Juaan can chi ñivi can ti: ―Cua saña ihni ndo cuati ndacu ndo, vati yatin xaan cua cundaca ñahan ra iyo iti siqui andivi chi yo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Chehe cuu tuhun cati tuhun ra Isaía ra ni cahan cuenda ra Ndioo nu quichi quivi, vati cati ra cuenda ra Juaan can ti: Cua cana chaa iin rai tichi cuhu, ta cua cati ra ti cua tiso vaha ñi iti nu cua yaha ra chahnu. Tacan ni cua tiso vaha ñi tiñu, cua cati ra, cati ra Isaía can. ");
INSERT INTO mioNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Chacundichin ra Juaan can sahma ixi ri camellu, ta chacunuhni iin cinta ñiin tichi ra. Chachi ra tica, ta chihi ra nduxi ñuñu cuhu, vati tacan ni chacoo ra ni cahan cuenda ra Ndioo tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tacan cuu, ta cuahan ñivi ñuun Jerusalén nuun iyo ra. Cuahan ndihi ñivi ñuhun Judea chi ndihi ñivi iyo yatin yuta Jordán. ");
INSERT INTO mioNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nahma ñi cuati savaha ñi, ta sacuanduta ra Juaan can chi ñi yuta Jordán can. ");
INSERT INTO mioNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ndehe ra Juaan ti cha tuvi ra fariseo chi ra saduceo quichi, vati cua cuanduta tahan ra ta ra, ta quechaha cati ra chi ra ta ra ti: ―¡Vata xaan ndo! Yoni cati chi ndo ti cua cundee cacu ndo nu cua tachi tuni ra Ndioo chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tu cha ndicha ndo, na cua savaha ndo cuhva ndacu ñivi saña ihni ndicha cuati ndacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ña cua saxini ndo chi anima ndo ti cha iyo vaha ndo, vati ñivi ndo chi ra Abraham. Yuhu cati chi ndo ti tu cua cuni ra Ndioo cua cuu savaha ra iin cuhva cahnu xaan. Cua cuu sama ra yuu ya, ta cuu chi ñivi ra Abraham. ");
INSERT INTO mioNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Cha iyo vaha tuhun cha cua tahnda ndihi yutun ña vaha chiti. Cua tahnda chi, ta cua cayu chi tichi ñuhun, vati cuhva cua tachi tuni ra Ndioo chi ñivi ña vaha cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Sacuanduta yu chihin ndo chi nduta, vati cha ni saña ihni ndo cuati savaha ndo, soco iti chate vachi inga ra, ta iyo xaan ca tu ndee ini chi ra. Ñahni yavi ndai cha cua cui musu ra, ta cua cuise ndichan ra. Maan ra cua cuhva cha cua quichi ra Tati Ndioo, ta suvi ra cuu ra cua tachi tuni. ");
INSERT INTO mioNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Cha iyo vaha ra cha cua sandundoo ra nu cua satati ra chiti trigu can. Cua canihin vaha ra chiti can tichi yaca ra, ta cua cahmi ra cha ña vaha can chi ñuhun ña ndahva. Tacan cati ra Juaan can, vati cua quee vaha ñivi saña ihni cuati, ta cua cutuni ñivi ni vii ndacu cuati. ");
INSERT INTO mioNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tacan cuu, ta quee ra Jesuu iti ñuhun Galilea, ta cuahan ra iti yuta Jordán nuun iyo ra Juaan can. Tican cuahan ra, vati cua sacuanduta ra Juaan chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ña cuni ra Juaan can sacuanduta ra chi ra, ta cati ra chi ra ti: ―Nini ca cha cua sacuanduta cun chi yuhu, ta cha vachi cun iti nuin ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ta cati ra Jesuu chi ra ti: ―Ña cua casi cun, vati cha vaha cuu cha cua savaha yo cuhva cati ra iyo iti siqui andivi ―cati ra. Tacan cuu, ta chaha ra Juaan. ");
INSERT INTO mioNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cha ni chanduta ra Jesuu, ta sa ni quee ra tichi nduta, ta nuna iti siqui andivi, ta ndehe ra Jesuu cha vachi nuun ra Tati Ndioo cuhva iin ri ndivi, ta quichi ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tacan cuu, ta nducahan ra Ndioo iti siqui andivi, ta cati ra ti: ―Sehi chi rahya. Cuni xain chi ra, ta sii xaan cuni yu ndehi chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tacan cuu, ta ndaca ra Tati Ndioo chi ra Jesuu tichi cuhu can, vati tacan cua ndehe run cuihna a ña cua savaha ra Jesuu iin ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chacoo ndita ra Jesuu uvi xico quivi. Tacan cuu, ta chisoco ra, ");
INSERT INTO mioNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ta tuhva run cuihna nu iyo ra, ta quechaha cati run chi ra ti: ―Tu ndicha ti sehe Ndioo cuu cun, cua cati cun chi yuu ya ti cua cuu chi paan, ta cua cachi cun ―cati run. ");
INSERT INTO mioNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ta cati ndico ra Jesuu ti: ―Cha cati tutu Ndioo ti iyo ndito ñivi, vati chachi ñi, soco ñavi cuenda chacan ni iyo ndito ñivi. Iyo ndito ñi, vati maan ra Ndioo cati, cati chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tacan cuu, ta quihin run cuihna chi ra, ta cuahan ra chi run ñuun Jerusalén, ta tiso run chi ra nda xini ve ñuhun cahnu can, ");
INSERT INTO mioNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ta quechaha cati run chi ra ti: ―Tu ndicha ti sehe Ndioo cuu cun, cua capa cun, vati cati tutu Ndioo ti: Cati tuhun ra Ndioo ti cua cumi ra tatun Ndioo chi sehe ra, ta cua tindee tatun ra chihin ra, coto cua yani chaha ra chata yuu, cati chi ―cati run. ");
INSERT INTO mioNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ta cati ndico ra Jesuu chi run ti: ―Inga ndico cha cati tutu Ndioo ti ña cua nducu ndo cuhva cha cua savaha ra chahnu Ndioo iin cha ndavaha ni, cati chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tacan cuu, ta chandaca ndico tucu run cuihna chi ra nu iyo iin yucu sucun xaan, ta sanahan run ndihi ñuun iyo nu ñuhun ñuñivi chi ra, ta taqui xaan chi, ");
INSERT INTO mioNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ta quechaha cati run chi ra ti: ―Ndihi ñuun can cua cuhve chihun, tu cua cahnu chiti cun, ta cua sacahnu cun chihin yu ―cati run. ");
INSERT INTO mioNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tacan cuu, ta cati ra Jesuu chi run ti: ―Cuahan, yoho Satanaa, vati cha cati tutu Ndioo ti cua sacahnu ndo chi ra chahnu Ndioo. Iin tuhun ni maan ra cua sacahnu ndo, cati chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tacan cuu, ta cuahan run cuihna, ta tuhva ra tatun Ndioo nu iyo ra Jesuu, ta tindee ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Queta tuhun nuun ra Jesuu ti cha ni tiin tiñu chi ra Juaan, ta quee ra Jesuu cuahan ra iti ñuhun Galilea. ");
INSERT INTO mioNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tacan cuu, ta quee ra ñuun Nazaret, ta cuahan ra iti ñuun Capernaum, vati cua ndoo ra tican. Yatin yu tañuhun nu iyo ñuhun Zabulón chi ñuhun Neftalí tican ni chacoo ra. ");
INSERT INTO mioNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chacan cuu cha ni quee tuhun cuhva ni cati ra Isaía ra ni cahan cuenda ra Ndioo nu ni quichi quivi, vati cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Iti ñuhun Zabulón, iti ñuhun Neftalí nu iyo tañuhun inga chiyo yuta Jordán, iti ñuhun Galilea nu iyo ñivi cuu inga tucu ñivi, ");
INSERT INTO mioNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","tican ni chacoo ñi nu naan, soco vitin cha ndehe ñi iin cha ndichin vaha. Cha queta iin cha ndichin nu iyo ñi chi ndavaha ni. Tacan ni cati ra Isaía can cuenda ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nda ni quivi can quechaha cati tuhun ra Jesuu tuhun vaha, ta cati ra ti: ―Cua saña ihni ndo cuati ndacu ndo, vati yatin xaan cua queta quivi cua cundaca ñahan ra iyo iti siqui andivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iin quivi chica cuu ra Jesuu yu tañuhun Galilea can, ta ndehe ra uvi rai, ta mani yani ra ta ra. Iin ra nani Simón Pedro, ta inga ra yani ra nani Ndree. Cani ra ta ra taraya ra tichi nduta can, vati ra chahni tiaca cuu ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tacan cuu, ta quechaha cati ra Jesuu chi ra ta ra ti: ―Na coho. Cua coo ndo chihin yu, ta cua savahi cha cua nanducu ndo chi ñivi cuhva ni nanducu ndo chi ri tiaca ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tacan cuu, ta ni nacoo ra ta ra taraya ra, ta cuahan ra, ta ndicu ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Quee ra Jesuu cuahan ra, ta quechaha ndehe ndico tucu ra inga uvi rai, ta mani yani ra ta ra. Ra Jacobo sehe ra Zebedeo cuu ra chi ra Juaan yani ra. Ni iyo ra ta ra chi Zebedeo sutu ra tichi tundoo, ta tiso vaha ra ta ra taraya ra, ta cana ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tacan cuu, ta ni nacoo ra ta ra sutu ra tichi tundoo can, ta cuahan ra ta ra. Ndicu ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nini cahnu ñuhun Galilea can cuahan ra Jesuu, ta sacuaha ra chi ñivi tichi ve ñuhun ñi. Cati tuhun ra tuhun vaha yoso cuhva cua cundaca ñahan ra iyo iti siqui andivi, ta sanduvaha tahan ra chi ñivi cuhvi―masi cuhvi ñi ndihi nuun cuehe. ");
INSERT INTO mioNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tacan cuu, ta queta tuhun ra nini cahnu ñuhun Siria, ta quichi ndaca ñivi chi ndihi ñivi cuhvi nu iyo ra. Ndaca ñi chi ñivi iyo tati cuihna anima. Ndaca ñi chi ñivi chahni rai. Ndaca ñi chi ñivi ña cuu caca. Ndaca ñi, ta sanduvaha ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tuvi xaan ñivi ndicu chi ra. Ndicu ñivi iyo ñuhun Galilea chi ra. Ndicu ñivi iyo ñuhun Decápoli. Ndicu ñivi iyo ñuun Jerusalén. Ndicu ñivi ñuhun Judea. Ndicu ñivi quichi inga chiyo yuta Jordán. Ndicu ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ndehe ra Jesuu ti tuvi ñivi nducuiti, ta quee ra cuahan ra siqui yucu. Ni chacunda nuun ra, ta tuhva ñivi sacuaha chi ra nu ndaa ra. ");
INSERT INTO mioNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tacan cuu, ta quechaha sacuaha ra chi ñi. Cati ra Jesuu chi ñivi can ti: ");
INSERT INTO mioNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Cua cusii ini ñivi cuni xaan chi ra Ndioo, vati cua coo ñi nu cua cundaca ñahan ra iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Cua cusii ini ñivi ndahvi cuni anima cuenda cuati ñi, vati cua coo tu ndee ini chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Cua cusii ini ñivi masu ini, vati cua coo vaha ñi chi ra Ndioo quivi cua nduchaa ñuhun ñuñivi ya. ");
INSERT INTO mioNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Cua cusii ini ñivi cuni ndicha cha cua coso vaha anima cuhva cuni ra Ndioo, vati cua coo cha vaha chi anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Cua cusii ini ñivi iyo tu ndahvi ini, vati cua cundahvi ini ra Ndioo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Cua cusii ini ñivi cuni ndicha chi ra Ndioo, vati cua ndehe ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Cua cusii ini ñivi sandumani chi tahan ñi, vati ñivi Ndioo cua cuu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Cua cusii ini ñivi ndehe tu ndoho, vati ndacu ñi cuhva cuni ra Ndioo, vati cua coo ñi nu cua cundaca ñahan ra iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Cua cusii ini ndo, tu cua cahan ñivi ndavaha ni chi ndo, ta cua cani ñi chi ndo, ta cua sandahyu ñahan ñi, vati cua cati ñi ti ndavaha ni ndacu ndo, vati chica ndo chi main. ");
INSERT INTO mioNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cua cusii ini ndo, vati cua cunda xaan yahvi ndo iti siqui andivi. Ta ni cuhva chaha ñivi tu ndoho chi ra cahan cuenda ra Ndioo nu ni quichi quivi tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ni vii cahan ra Jesuu chi ñivi can: ’Cua cuu ndo sava ni ta cua ñiin vaha. Tu ña vaha ñiin, ta cua naan cha uhva chi, ña cua cuu ca nduvaha ndico chi. Ñahni ca yavi ndaa chi. Cua savita yo chi chi, ta cua ndoyo ñuhun chi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Cua cuu ndo sava ni ta cua iin ñuhun ndichin. Ña xehe iyo iin ñuun caa iin siqui yucu. ");
INSERT INTO mioNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tu cua taa yo ñuhun, ña cua tihi yo chi chi tichi iin máquila, soco cua tiso yo chi chi nu candileru, ta ndichin cua ndehe ndihi ñivi iyo tichi vehe. ");
INSERT INTO mioNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tacan na cua coo vaha ndo chi ndihi ñivi, vati tacan cua ndehe ñi ti cha vaha ndacu ndo, ta cua sacahnu tahan ñi chi sutu ndo iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ni vii cahan ra Jesuu chi ñivi can: ’Ña cua saxini ndo ti cha vachi yu, vati cua sanain ley cha ni tiso ra Moisee chi tuhun cati tuhun ra ni cahan cuenda ra Ndioo tiempu chahnu. Ñavi cuhva can quichi yu. Quichi yu, vati cua saquete ndihi chacan. ");
INSERT INTO mioNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cati ndicha yu ti ña cua naan ñuhun ñuñivi chi andivi nda cua nda cua queta ndihi chacan. Chacan cuu cha chito yo ti ña cua naan ni iin tuhun luhu cha iyo nu tutu Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chacan cuu cha tu iyo ñivi ña cua sacuinu ñi ndihi tuhun ley can cha cati tuhun ra Ndioo, tu cua cati ñi ti ña nini chacan, luhu xaan ca ñi cua cuu nu cua cundaca ñahan ra iyo iti siqui andivi. Tu iyo ñivi cua sacuinu ndihi chacan, ta cua cati ñi chi ñivi tahan ñi ti na cua sacuinu tahan ñi chi chi, cahnu xaan ñi cua cuu nu cua cundaca ñahan ra iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Cati yu chihin ndo ti ñavi cha vaha vaha ndacu ra sacuaha ley chahnu, ta ñavi cha vaha vaha ndacu tahan ra fariseo. Tu ña cua coo ndo chi cha vaha ca, ña cua coo ndo nu cua cundaca ñahan ra iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ni vii cahan ra Jesuu chi ñivi can: ’Cha chini ndo ti tiempu chahnu queta tuhun ti ña cua cahni ndo ñivi tahan ndo, vati tu cua cahni ndo tahan ndo, iyo cha cua cutuni ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yuhu cati chi ndo ti tu cua cuxaan ini ndo chi ñivi tahan ndo, iyo cha cua cutuni ndo. Tu cua cati ndo chi tahan ndo ti quiti cuhu cuu ñi, cua yaha ndo nu ra cumi tiñu, ta cua cutuni ndo. Tu cua cati ndo ti tondo xini ñivi, cua cuhun ndo andaya nu cayu ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Tu cua cundaca ndo cha cua samani ndo chi ra Ndioo, ta cua queta ndo nu cua samani ndo chi chi, ta chacuhun ini ndo ti cha savaha ndo iin ndavaha ni chi tahan ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","cua nacoo nuun ndo cha cua samani ndo chi ra Ndioo tican nu altar can, ta cua quee ndo. Cuahan xihna ndo, ta na cua ndumani ndico ndo chi tahan ndo, ta sa cua cuu cuhun ndico ndo samani ndo cha ndaca ndo chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Quii xaan na cua ndumani ndico ndo chi ñivi cuni cuati chi ndo cha ña ta queta ndo nu ra cumi tiñu, coto cua cuhva cuenda ñi chi ndo chi ra cale, ta cua cuhva cuenda ra chi ndo chi ra tatun, ta cua tihi ra chi ndo ve caa. ");
INSERT INTO mioNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cati ndicha yu chihin ndo ti ña cua cundee quee ndo nda cua nda quivi cua tiahvi ndo ndihi multa can. ");
INSERT INTO mioNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ni vii cahan ra Jesuu chi ñivi can: ’Cha chini ndo ti tiempu chahnu queta tuhun ti ña cua coo ndo ndavaha ni chi tahan ndo inga chiyo, ");
INSERT INTO mioNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","soco yuhu cati chi ndo ti tu cua ndehe ndo chi iin ñahan, vati cuni ndo coo ndo ndavaha ni chi ña, cha ndoo chi chi anima ndo cuhva cha ni savaha ndicha ndo ndavaha ni chi ña cuu chacan. ");
INSERT INTO mioNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Tu cua savaha ndo cuati cha cuenda titi nuun ndo, cua sanini ndo chi ndo, ta ña cua savaha ca ndo cuati can chi titi nuun ndo, vati vaha xaan ca cua cumi ndo titi nuun ndo, ta ña cua quehni cava niniin iquin cuñu ndo nu cua cutuni ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tu cua savaha ndo cuati cha cuenda ndaha cuaha ndo, cua sanini ndo chi ndo, ta ña cua savaha ndo cuati can chi ndaha ndo, vati vaha xaan ca cha cua sacuenda ndo ñaan cha cuu cha cúa savaha ndo chi ndaha ndo, ta ña cua ndoyo ñuhun niniin iquin cuñu ndo nu cua cutuni ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ni vii cahan ra Jesuu chi ñivi can: ’Cha chini ndo ti tiempu chahnu queta tuhun ti tu cua saña ndo chi ñasihi ndo, na cua nducu ndo cha cua ndoyo tutu cha ni saña ndo chi ña, ");
INSERT INTO mioNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","soco yuhu cati chi ndo ti tu cua saña ndo ñasihi ndo, ta ñahni ndavaha ni cha ni chacoo ña chi ra rai inga chiyo, cua savaha ndo cha ni chacoo ña ndavaha ni chi ra rai inga chiyo cha cuenda ra Ndioo. Tu cua tandaha ndo chi iin ñahan cha ni saña inga rai, cua coo ndo ndavaha ni chi ña inga chiyo cha cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ni vii cahan ra Jesuu chi ñivi can: ’Cha chini tahan ndo ti tiempu chahnu queta tuhun ti ña cua sandahyu ñahan ndo, soco cuenda ra chahnu cua savaha ndicha ndo cuhva cha ni cati ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yuhu cati chi ndo ti ña cua xita ndo iin tuhun ra Ndioo. Ña cua xita ndo tuhun iti siqui andivi, vati nu ndaa ra Ndioo cuu tican. ");
INSERT INTO mioNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ña cua xita ndo tuhun ñuhun ñuñivi, vati nu ndaa chaha ra Ndioo cuu ñuhun ñuñivi ya. Ña cua xita ndo tuhun ñuun Jerusalén, vati ñuun ra Ndioo cahnu cuu ñuun can. ");
INSERT INTO mioNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ta ni cuhva ña cua xita ndo tuhun xini ndo, vati iin tuhun ra Ndioo chaha cha nducuichin xini ndo a ndutuun xini ndo. Ña cua xita ndo tu yuhu ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tu cua cati ndo ti cua savaha ndo iin tiñu, cua savaha ndicha ndo cuhva cati ndo. Tu cua cati ndo ti ña cua savaha ndo iin tiñu, ña cua savaha ndicha ndo chi chi, ta chacan ni cua savaha ndo. Tu cua xita ca ndo tuhun, cua savaha ndo chacan, vati ñivi ndavaha ni cuu ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ni vii cahan ra Jesuu chi ñivi can: ’Cha chini ndo ti tiempu chahnu queta tuhun ti tu cua tuhun iin ñivi titi nuun ñivi tahan ñi, cua tuhun tahan ra cumi tiñu titi nuun maan ñi cha cua cutuni ñi. Ta ni cuhva tu cua tahvi ñivi nuhun ñivi tahan ñi, cua tahvi tahan nuhun ñi cha cua cutuni ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tacan cha ni cati ñivi, soco yuhu cati chi ndo ti ña cua savaha ndo ndavaha ni chi ñivi savaha ndavaha ni chi maan ndo. Tu cua cani ñivi iin chiyo nuun ndo, ña cua cani ndico ndo chi ñi, soco na cua cuhva ndo cha cua cani ñi inga chiyo nuun ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tu cua cuni ñivi cuati chihin ndo, ta cua quenda ñi sahma ndo, ña cua cani tahan ndo chi ñi, soco na cua cuhva tahan ndo inga sahma ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tu cua sanini ñivi cha cua cuhun ndo iin kilómetro chi ñi, ña cua cuxaan ini ndo chi ñi, soco na cua cuhun ndo uvi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tu cua queta ñivi caya nu iyo ndo, na cua tindee ndo chi ñi, ta na cua cuhva nuun ndo chi ñivi tahan ndo, tu cua cuni ñi tava nuun ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ni vii cahan ra Jesuu chi ñivi can: ’Cha chini ndo ti tiempu chahnu queta tuhun ti cua cuni mani ndo chi ñivi tahan ndo, ta cua cuxaan ini ndo chi ñivi cuxaan ini chi ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","soco yuhu cati chi ndo ti cua cuni mani ndo chi ñivi cuxaan ini chi ndo, ta cua cahan ndahvi ndo chi ra Ndioo cuenda ñivi chaha tu ndoho chi ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","vati tacan cua savaha ndo cuhva cuni sutu ndo cha iyo iti siqui andivi. Tacan cua savaha ndo, vati chaha ra Ndioo cha vaha chi ndihi ñivi. Chaha ra cha ndehe ri nicandi nu iyo ñivi ndacu cha ndavaha ni cuhva ndehe ri nu iyo ñivi ndacu cha vaha. Ta ni cuhva chaha ra cha cuun savi nu iyo ñivi ndacu cha vaha, ta cuun tahan savi nu iyo ñivi ndacu cha ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tu cua cuni mani ndo mani chi ñivi cuni mani chi ndo, ñahni cha cua sacanaan ndo cuenda ra Ndioo, vati tacan ni ndacu tahan ra satiahvi cuenda ra cumi tiñu chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tu ini chi ñivi tahan ndo sacahnu ndo, savaha ndo cuhva savaha ndihi ca ñivi, ta ña vaha cha tacan ni, vati tacan savaha tahan ñivi cuu inga tucu ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Na cua savaha ndo cha vaha ndicha cuhva ndacu sutu ndo cha iyo iti siqui andivi, vati ndacu ra cha vaha. ");
INSERT INTO mioNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ni vii cahan ra Jesuu chi ñivi can: ’Na cua nducu ndo cuhva cha cua savaha ndo cha vaha, soco ña cua nducu ndo cuhva cha cua ndehe ñivi cuhva ni savaha ndo. Tu cua cuni ndo cha cua ndehe ñivi yoso cuhva cua savaha ndo, ña cua cunda yahvi ndo iti nuun ra sutu ndo iyo iti siqui andivi, vati cha nihin ndo yahvi ndo chi ñivi ñuñivi cha savaha ndo tacan. ");
INSERT INTO mioNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tu cua cuhva ndo xuhun chi ñivi ndahvi caya, ña cua sacoto ndo chi ñivi. Ña cua savaha ndo cuhva savaha ñivi samani xuhun chi ñivi tichi ve ñuhun, ta ña cua savaha ndo cuhva savaha ñivi samani xuhun chi ñivi iti cahnu. Tacan savaha ñi, vati cuni ñi cha cua cati ñivi ti cahnu xaan ñivi cuu ñi. Cati ndicha yu chihin ndo ti cha nihin ñi yahvi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tu cua samani ndo xuhun ndo, ña cua sacoto ndo ni chi iin tahan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chacan cuu cha cua cuhva xehe ndo, ta cua cuhva ra sutu ndo yahvi ndo, vati ndehe ra cha savaha xehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ni vii cahan ra Jesuu chi ñivi can: ’Hora cua cahan ndo chi ra Ndioo ña cua savaha ndo cuhva savaha ñivi uvi yaa. Cuni xaan ñi cuindi ñi ve ñuhun, ta cuni xaan ñi cuinda ñi iti cahnu, ta cahan ñi chi ra Ndioo, vati cuni ñi cha cua ndehe ñivi cha ndacu ñi. Cati ndicha yu chihin ndo ti cha nihin ñi yahvi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Hora cua cahan ndo chi ra Ndioo cua quihvi ndo tichi vehe ndo, ta cua casi ndo yu vehe, ta sa cua cahan ndo chi ra cuu sutu ndo nu indi xehe ndo. Cua ndehe maan ra cha savaha xehe ndo, ta cua cuhva ra yahvi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Hora cua cahan ndo chi ra Ndioo ña cua nducuaha tuhun cahan ndo, tu ña cua coto ndo ñaan tuhun cuu cha cahan ndo cuhva ndacu ñivi cuu inga tucu ñivi. Tacan ni savaha ñican, vati saxini ñi ti cua tasoho ra Ndioo chi ñi, vati cuaha xaan tuhun cahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ña cua savaha ndo cuhva ndacu ñican, vati cha chito ra Ndioo sutu ndo ñaan cha cuu cha chini ñuhun ndo, ta ña ta ndaca ndo chi chi chihin ra. ");
INSERT INTO mioNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chacan cuu cha tehen ni cua cahan ndo chi ra: Sutu ndi iyo iti siqui andivi, na cua sacahnu ndihi ñivi chihun. ");
INSERT INTO mioNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na cua queta quivi cua cundaca ñahan cun ihya nu ñuhun ñuñivi ya. Na cua coo chi cuhva cuni maun ihya nu ñuhun ñuñivi ya cuhva iyo chi iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Na cua cuhva cun cha cua cachi ndi vitin tichi quivi ya. ");
INSERT INTO mioNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na cua sanaun cuati ndacu ndi cuhva cha ni sanaan ndi cuati savaha ñivi chihin ndi. ");
INSERT INTO mioNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na ña cua cuhva cun cha cua savaha ndi cha ndavaha ni, soco na cua sacacu cun chihin ndi nu cua ndoyo ñuhun ndi, vati maun cuu ra ndaca ñahan, ta iyo tu ndee ini chihun, ta cahnu xaan Ndioo cuu cun. Na cua cuu chi tacan ni. ");
INSERT INTO mioNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Tacan cati yu, vati cua sanaan tahan sutu ndo iyo iti siqui andivi cuati savaha ndo, tu cua sanaan maan ndo cuati ndacu ñivi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tu ña cua sanaan ndo chacan, ña cua sanaan ra sutu ndo cuati savaha maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ni vii cahan ra Jesuu chi ñivi can: ’Quivi cua coo ndita ndo ña cua cucuihya xaan cuni anima ndo cuhva savaha ñivi uvi yaa. Savaha ñi cha ndahvi ndehe nuun ñi, vati tacan cua coto ndihi ñivi ti cha iyo ndita ñi. Cati ndicha yu chihin ndo ti cha nihin ñican yahvi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Quivi cua coo ndita ndo cua savaha ndo cuhva ndacu ndo ndihi ni quivi. Cua tihi ndo aceite xini ndo, ta cua nacata ndo nuun ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","vati tacan ña cua coto ñivi cha iyo ndita ndo, soco cua coto sutu ndo cha ndacu xehe ndo, ta cua cunda yahvi ndo chi maan ra, vati ndehe ra cha ndacu ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ni vii cahan ra Jesuu chi ñican: ’Na ña cua nducu ndo cha cua coo cha vaha cha cua tivaha ndo nu ñuhun ñuñivi ya, vati chachi ri tindacu chi chi, ta cuxin chi. Tahvi ñasuhu nu indi chi, ta quihin run chi chi. ");
INSERT INTO mioNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Na cua tivaha ndo cha vaha iti siqui andivi, vati tican ña chachi ri tindacu chi chi, ta ni ña cuxin chi. Ña quihvi run ñasuhu, ta suhu run chi chi. ");
INSERT INTO mioNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tacan cati yu, vati nu iyo chachi ndo―cuenda ican saxini ndo chi anima ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ni vii cahan ra Jesuu chi ñivi can: ’Titi nuun yo cuu sava ni ta cua iin ñuhun ndichin. Tu vaha iyo titi nuun yo, ndichin vaha cua ndehe yo, ta iyo cha chini tuni chi yo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tu ña vaha titi nuun yo, ña ndichin vaha ndehe yo, ta ñahni cha chini tuni iyo chi yo. Tu ñahni cha chini tuni chi ndo cha cuenda ra Ndioo, cha ndoyo ñuhun cuii ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ni vii cahan ra Jesuu chi ñivi can: ’Ña cuu satiñu ndo chi uvi ra cuu chitoho ndo. Tu cua nducu ndo cuhva, cua cuni mani ndo chi iin ra, ta cua cuxaan ini ndo chi inga ra. Chacan cuu cha cati yu ti ña cua cuu satiñu ndo chi ra Ndioo, tu cua nanducu xaan ndo cha cua cuu chi maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ni vii cahan ra Jesuu chi ñivi can: ’Chacan cuu cha cati yu chihin ndo ti ña cua tichaha ndo yoso cuhva cua coo ndo. Ña cua saxini ndo ñaan cha cuu cha cua cachi ndo ta ñaan cha cuu cha cua coho ndo. Ña cua saxini ndo ñaan cha cuu cha cua cunami ndo cha cua cundichin ndo. Cha chaha ra Ndioo cha iyo ndito yo, ta chaha ra cha iyo vaha iquin cuñu yo. Chacan cuu cha chito yo ti cua cuhva ra cha cua cachi yo cha cua cunami yo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cua saha ndo cuenda yoso cuhva iyo ri saa. Ña tuhva ri tachi tata. Ña tuhva ri cahnu itu. Ña tuhva ri canihin vaha chiti chi. Ña tuhva ri, soco chaha ra sutu ndo iyo iti siqui andivi cha cua cuni ñuhun ri, ta cahnu ca maan ndo chi rican. ");
INSERT INTO mioNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yoni ndo cua cuu sandusucun ndo suvi ni chi maan ndo―masi saxini xaan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Ña cua saxini xaan ndo yoso cuhva cua cunami ndo. Cua ndehe ndo yoso cuhva iyo ita cha iyo tichi cuhu. Ña satiñu chi, ta ni ña tavi chi yuhva. ");
INSERT INTO mioNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Yuhu cati chi ndo ti vasi taqui suhva ni chacundichin ra Salomón, soco ña taqui ra cuhva taqui ndicha maan ita can. ");
INSERT INTO mioNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Vaha xaan ca cua cuhva ra Ndioo cha cua cundichin ndo cha cua cunami ndo, vati tacan cumi ra chi ita can, ta vitin iyo chi, ta yutaan cha ndoyo ñuhun chi. Ñahni cha chinu ini ndo chi ra cha vaha. ");
INSERT INTO mioNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ña cua saxini ndo ñaan cua cachi ndo ñaan cua coho ndo ñaan cua cundichin ndo ñaan cua cunami ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ndihi chacan cuni ndihi ca ñivi. Chito ra sutu ndo iyo iti siqui andivi ti cha chini ñuhun tahan ndo ndihi chacan. ");
INSERT INTO mioNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Na cua nducu xihna ndo cha cua savaha ndo cuhva cuni ra Ndioo nu cua cundaca ñahan ra, ta na cua nducu xihna ndo cha cua coso vaha anima ndo cuhva cuni ra. Tacan, ta sa cua nihin tahan ndo ndihi chacan. ");
INSERT INTO mioNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Chacan cuu cha ña cua saxini ndo cuenda yutaan, vati yutaan iyo inga cha cua saxini ndico tucu ndo. Iyo ñaan cha cua saxini ndo iin iin quivi. Tu tacan ni cua savaha ndo, ña cua yaha cuhva cha cua saxini ndo iin quivi inga quivi. ");
INSERT INTO mioNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ni vii cahan ra Jesuu chi ñivi can: ’Ña cua cati ndo ti ña vaha ñivi tahan ndo, vati tacan ni ña cua cati ra Ndioo ti ña vaha maan ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","vati cuhva cua cati ndo cuenda ñivi―cuhva can cua cati ra Ndioo cuenda maan ndo. Cua savaha ra chihin ndo cuhva cua savaha maan ndo chi ñivi tahan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Saxini ndo ti ndavaha ni ndacu ñivi tahan ndo, ta ña saha ndo cuenda ti cahnu xaan ca ndavaha ni ndacu maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Cati ndo chi tahan ndo ti ña vaha ndacu ñi. Tacan ni savaha ndo, ta cahnu xaan ca ndavaha ni ndacu maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ñivi uvi yaa cuu ndo. Cua coso vaha xihna maan ndo, ta sa cua cuu tindee tahan ndo chi ñivi tahan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ña cua cuhva ndo cha vaha chi run ina xaan, coto cua cuico coo ri ina can, ta cua tiin ri chihin ndo, ta ni ña cua cuhva ndo cha ndaa yahvi chi run quini, coto cua cuañu ri chi chi, ta cua ndoyo ñuhun chi. Tacan ni ña cua cati tuhun ndo tuhun Ndioo chi ñivi ña cua tasoho, coto ña cua quihin cuenda ñi chi chi. ");
INSERT INTO mioNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ni vii cahan ra Jesuu chi ñivi can: ’Na cua ndaca ndo cha chini ñuhun ndo chi ra Ndioo, ta cua cuhva ra chi chi chi maan ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","vati cua cuhva ra Ndioo chi ndihi ñivi chica chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Tu cua ndaca sehe ndo paan, yoni cua cuhva iin yuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tu cua ndaca ra tiaca, ña cua cuhva ndo iin coo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Chito maan ndo yoso cua samani ndo cha vaha chi sehe ndo, ta ñivi ñuñivi cuu ndo. Chacan cuu cha chito vaha xaan ca ra sutu ndo iyo iti siqui andivi yoso cua samani ra cha vaha chi ñivi ndaca chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Chacan cuu cha na cua savaha maan ndo cha vaha chi ñivi cuhva cuni ndo cha cua savaha ñi chihin ndo, vati chacan cuu tuhun iyo tutu Ndioo cuhva cha ni cati ra tiso ley chahnu cuhva cha ni cati ra ni cahan cuenda ra Ndioo tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ni vii cahan ra Jesuu chi ñivi can: ’Na cua yaha ndo nu tuu, ta cua quihvi ndo nu cua cundaca ñahan ra Ndioo, vati quihin xaan nu cua yaha ñivi, ta cua queta ñi nu cua ndoyo ñuhun ñi, ta tuvi xaan ñivi yaha ican. ");
INSERT INTO mioNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Chi tu ndoho cua yaha ñivi nu tuu, ta cua coo ndito ñi chi ra Ndioo. Ña tuvi ñi cuu ñi cundee quihvi iti can. ");
INSERT INTO mioNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ni vii cahan ra Jesuu chi ñivi can: ’Cua saha ndo cuenda yoso cuhva iyo ñivi sandahyu ñahan cuenda ra Ndioo. Queta ñi nu iyo ndo, ta vii xaan cahan ñi, soco xaan xaan ñi cuu. ");
INSERT INTO mioNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Cua nacoto ndo chihin ñi, vati cua ndehe ndo yoso cuhva ndacu ñi. Ña nihin yo ticuayu nu yutun iñu acuxa, ta ni ña nihin yo ticava nu yutun tiyata. ");
INSERT INTO mioNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tu iyo iin yutun vaha, vaha xaan chiti cana nuun chi, soco tu ña vaha iyo iin yutun, ña vaha chiti cana nuun chi. ");
INSERT INTO mioNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ña cuu cana chiti ña vaha nuun yutun vaha. Ta ni cuhva ña cuu cana chiti vaha nuun yutun ña vaha. ");
INSERT INTO mioNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tu ña cua cana chiti vaha nuun yutun, cua tahnda chi, ta cua cayu chi nu ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chacan cuu cha cua coto ndo yoo ñivi cuu ñi, tu cha cua ndehe ndo yoso cuhva ndacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ni vii cahan ra Jesuu chi ñivi can: ’Ñavi ndihi ñivi cati ti cha sacahnu ndicha ñi chihin yu cuu ñi cua cundee quihvi nu cua cundaca ñahan ra iyo iti siqui andivi, soco ñivi ndacu cuhva cuni ra suti cha iyo iti siqui andivi―ñican cuu ñi cua cundee quihvi. ");
INSERT INTO mioNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cua queta quivi can, ta sa cua cati ñivi chihin yu ti: “Yoho ra chahnu, cha cuenda sivi cun cahan ndi cuenda ra Ndioo. Cha cuenda sivi cun tava ndaa ndi chi run tati cuihna. Cha cuenda sivi cun savaha ndi cuhva cahnu xaan,” cua cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tacan, ta sa cua cati main chi ñi ti: “Ña nacote chihin ndo. Cua quee ndaa ndo iti nuin, vati mani cha ndavaha ni savaha ndo,” cua cati yu. ");
INSERT INTO mioNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ni vii cahan ra Jesuu chi ñivi can: ’Tu cua tasoho ndo tuhun cati tuhin chi ndo ihya, ta cua savaha ndo chi chi, cua cuu ndo sava ni ta cua iin rai saxini vaha. Quihin ra yuu cha cuu chaha vehe ra, ta chaqui ndaa ra vehe ra nuun yuu can. ");
INSERT INTO mioNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nihin xaan cuun savi, ta nihin xaan yaha yuta, ta nihin caa tati, ta yani chi chata vehe can, soco ña nduva chi, vati yuu cuu chaha chi. ");
INSERT INTO mioNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tu cua cuni ndo tuhun cati yu ihya, ta ña cua savaha ndo chi chi, cua cuu ndo sava ni ta cua iin rai tondo xini. Chaqui ndaa ra vehe ra nu ñuhun ni. ");
INSERT INTO mioNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Cuun savi, ta yaha yuta, ta caa tati, ta yani chi chata vehe can, ta nduva chi, ta ndoyo ñuhun cuii chi. ");
INSERT INTO mioNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tacan ni sandihi ra Jesuu tuhun cati tuhun ra chi ñivi can, ta iyo xaan cuni ndihi ñivi can chini ñi tuhun cha sacuaha ra chi ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","vati sacuaha ra chi ñi cuhva ni chito ra ñaan tuhun sacuaha ra, ta ñavi tacan sacuaha ra chito ley chahnu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tacan cuu, ta nuun ra Jesuu siqui yucu can, ta ndicu ñivi can chi ra. Tuvi xaan ñivi cuu ñi ndicu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tacan cuu, ta queta iin ra cuehe tahyu. Tuhva ra nuun iyo ra Jesuu, ta chahnu chiti ra iti nuun ra, ta quechaha cati ra chi ra ti: ―Yoho ra chahnu, tu cuni cun, cua cuu sanduvahun chihin yu ―cati ra ndahvi can. ");
INSERT INTO mioNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tacan cuu, ta sacaa ra Jesuu ndaha ra, ta sayani ndaha ra chi ra, ta cati ra ti: ―Cuni yu. Na nduvahun ―cati ra. Ta hora can naan cuehe can chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ta cati tucu ra Jesuu chi ra ti: ―Ña cua cahun ni chi iin ñivi, soco cuahan. Cua sanahun chihun chi ra sutu, ta cua cundaca cun cha cua samani cun chi ra Ndioo cuhva ni cati tuhun ra Moisee tiempu chahnu. Chacan cuu cha cua coto ñivi ti cha ni nduvahun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tacan cuu, ta cuahan ra Jesuu iti ñuun Capernaum. Cua quihvi ra tichi ñuun can, ta tuhva iin ra cuu sandaru cuenda ñuun Roma, ta quechaha cahan ndahvi ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Cati ra ti: ―Ra chahnu, caa sehi tichi vehi, vati nduñiin ra. Nihin xaan iyo tu ndoho chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ta cati ra Jesuu chi ra ti: ―Cua cu ndehi chi ra, vati cua sanduvahi chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ta cati ndico ra sandaru can ti: ―Ñahni yavi ndai cha cua yahun tichi vehi, ra chahnu. Na cua cahun tuhun ni, ta cua nduvaha sehi. ");
INSERT INTO mioNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Chite ti cua cuu savahun chacan, vati iyo ra ndaca ñahan chihin yu, ta ndaca ñahan tahin chi inga ra. Chi racan cati yu ti cua cuhun ra, ta cuahan ra. Chi inga ra cati yu ti cua quichi ra, ta vachi ra. Chi musu yu cati yu yoso cua savaha ra, ta savaha ra chi chi ―cati ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chini ra Jesuu tuhun can, ta quechaha nduiyo cuni ra, ta cati ra chi ñivi ndicu chi ra ti: ―Cati ndicha yu chihin ndo ti ña tuhva main ndehi ni chi iin ñivi ñuhun Israel chinu ini cuhva chinu ini rahya. ");
INSERT INTO mioNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Cati yu ti nini cahnu nu ñuhun ñuñivi cua quichi tuvi ñivi, ta cua coo tahan ñi chi ra Abraham chi ra Isaac chi ra Jacob nu cua cundaca ñahan ra Ndioo, ");
INSERT INTO mioNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ta iyo ñivi judío cua tava ndaa ra nu naan nu cua ndehe ñi tu ndoho, ta cua ndahyu chaa ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tacan cuu, ta cati ra Jesuu chi ra sandaru can ti: ―Cuahan. Na cua cuu chi cuhva chinu ini cun ―cati ra. Ta ni nduvaha sehe ra hora can. ");
INSERT INTO mioNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tacan cuu, ta cuahan ra Jesuu iti vehe ra Pedro. Quihvi ra, ta ndehe ra ti cha ni caa chiso ra Pedro, vati iyo cahni chi ña. ");
INSERT INTO mioNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Taa ra ndaha ra chi ña, ta ndico cahni chi ña. Tacan cuu, ta ndoyo ña, ta chaha ña cha cachi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cha cua cuaa quivi can, ta cha quichi ndaca ñi chi tuvi xaan ñivi ñuhun tati cuihna anima tican nu iyo ra Jesuu, ta sa cahan ni ra tuhun, ta tava ndaa ra chi run tati cuihna can anima ñi, ta sanduvaha tahan ra chi ndihi ñivi cuhvi. ");
INSERT INTO mioNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chacan cuu cha ni queta tuhun cha ni cati ra Isaía ra cahan cuenda ra Ndioo tiempu chahnu, vati cati ra ti sanaan ra tu ndoho tahan yo, ta sanduvaha ra ndihi cuehe cuhvi yo, cati ra cuenda ra Jesuu tiempu can. ");
INSERT INTO mioNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ndehe ra Jesuu cha cuahan ndutuvi ñivi nu iyo ra, ta cati ra chi ñivi sacuaha chi ra ti na cua cuhun ñi inga chiyo nduta can. ");
INSERT INTO mioNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tacan cuu, ta tuhva iin ra sacuaha ley chahnu can nu iyo ra, ta quechaha cati ra chi ra Jesuu ti: ―Yoho maestru, na cua cuhun tahin chihun ndaa iti cua cuhun cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ta cati ndico ra Jesuu chi ra ti: ―Iyo nu quixi ri ñucuii, ta iyo taca ri saa, soco yuhu ra cuu sehe ñivi―ña ta ñahni nu cua cave cusi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ta cati inga ñivi sacuaha chi ra ti: ―Ra chahnu, cuhva cha cua cuhun xihne, ta cua cuchi yu chi suti ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ta cati ndico ra Jesuu chi ñi ti: ―Na cua cuhun cun chi main icaa ni, ta cuhva cun cha cua cuchi ñivi ña chinu ini chi ndii can ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tacan cuu, ta quihvi ra Jesuu tichi iin tundoo, ta quihvi tahan ñivi sacuaha chi ra, ta cuahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tacan cuu, ta quechaha iyo tati xaan nu tañuhun can. Chacan cuu cha cahnu xaan tahnu nduta nu tundoo can, ta quihvi chi tichi tundoo, ta ni quixi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tacan cuu, ta tuhva ñi nu caa ra, ta quechaha sandoyo ñi chi ra, ta cati ñi ti: ―Ra chahnu, sacacu chi ndi, coto cua ndoyo ñuhun ndi ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ta cati ndico ra chi ñi ti: ―¿Ñacu yuhvi xaan ndo? Ña chinu ini ndo chi ra Ndioo ―cati ra. Tacan cuu, ta chacuinda ra, ta cati ra ti cua cutaxin tati can chi nduta can. Tacan cuu, ta taxin taxin cuu. ");
INSERT INTO mioNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Iyo xaan iyo xaan quechaha cuni ñivi can, ta quechaha cati ñi ti: ―Cahnu xaan rai cuu ra, vati tasoho tati chi nduta tañuhun cha cahan ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tacan cuu, ta queta ra Jesuu inga chiyo tañuhun can nu iyo ñuhun Gadara, ta nitahan uvi rai chi ra. Cha iyo tati cuihna anima ra ta ra, ta sa quichi ra ta ra iti camasandu. Xaan xaan ra cuu. Chacan cuu cha yoni cuu yaha iti can. ");
INSERT INTO mioNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tacan cuu, ta quechaha cana chaa ra ta ra, ta cati ra ta ra ti: ―¿Ñaan cha cuu cha cuni cun chi ndi, ta yoho ra cuu sehe Ndioo? Cha vachi cun ihya, vati cua cuhva cun tu ndoho chi ndi, ta ña ta queta quivi cua tachi tuni ra Ndioo chi ndi ―cati ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Cani vihi cha iyo suhva ri quini. Chica cuu ri. Chachi ri. ");
INSERT INTO mioNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tacan, ta cahan ndahvi run tati cuihna can chi ra Jesuu, ta cati run ti: ―Tu cua tava ndaun chi ndi, cuhva cun cha cua quihvi ndi tichi maan run quini can ―cati run. ");
INSERT INTO mioNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ta cati ndico ra Jesuu chi run ti: ―Cuahan ndo ―cati ra. Tacan cuu, ta quee run cuahan run, ta quihvi run tichi maan ri quini can, ta jihna quechaha ca chinu ndihi ri tichi xahva can, ta quehni ri tichi nduta tañuhun can, ta chihi ri. ");
INSERT INTO mioNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tacan cuu, ta chinu ra sacuenda chi ri quini can. Cuahan ra iti ñuun, ta chaha ra cuenda ndihi cha ni chacoo. Chaha ra cuenda cha ni tahan ra ni chacoo tati cuihna anima. ");
INSERT INTO mioNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tacan cuu, ta quee ndihi ñivi ñuun can nu vachi ra Jesuu. Ndehe ñi chi ra, ta quechaha cahan ndahvi xaan ñi chi ra ti na ña cua quihvi ra ñuun ñi, soco cua cuhun ra inga chiyo. ");
INSERT INTO mioNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tacan cuu, ta quihvi ndico ra Jesuu tichi tundoo, ta cuahan ndico ra inga chiyo tañuhun can, ta queta ra ñuun Capernaum cha cuu ñuun ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tacan cuu, ta quichi ndaca ñivi chihin iin ra nduñiin chaha nu iyo ra. Yuvi nu caa ra ndahvi can chiso ñi nu iyo ra Jesuu. Ndehe ra Jesuu ti chinu ini ñi chi ra, ta quechaha cati ra chi ra nduñiin can ti: ―Na cua cusii ini cun, yoho yani xaa. Cha ni naan cuati iyo chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tacan cuu, ta quechaha saxini ra sacuaha ley chahnu ta ra chi anima ra ti savaha rahya ndavaha ni cha cuenda ra Ndioo, saxini ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tacan, ta chito ra Jesuu yoso cuhva saxini ra ta ra. Chacan cuu cha cati ra chi ra ta ra ti: ―Ña vaha cha saxini ndo ndavaha ni chi anima ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ña ii xaan cha cua cati yo ti cha ni naan cuati cha iyo chihin ra. Ii ca cua cati yo ti cua cuinda ra, ta cua caca ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Cua sanahin chi ndo. Chacan cuu cha cua coto ndo ti iyo tu ndee ini chi ra cuu sehe ñivi, ta cuu sanaan ra cuati iyo chi ñivi ñuñivi ―cati ra Jesuu chi ra ta ra. Tacan cuu, ta cati ra Jesuu chi ra nduñiin can ti: ―Cuinda, ta canihin cun yuvi cun, ta cuahan iti vehun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tacan cuu, ta ni chacuinda ra, ta cuahan ra iti vehe ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ndehe ndihi ñivi can cha ni savaha ra Jesuu, ta quechaha cuyuhvi ñi. Sacahnu ñi chi ra Ndioo, vati chaha ra tu ndee ini can chi iin ñivi ñuñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tacan cuu, ta yaha ra Jesuu tican, ta ndehe ra iin rai, ta ndaa ra nu satiahvi ra chi ñivi. Mateo nani ra, ta quechaha cati ra Jesuu chi ra Mateo can ti: ―Na coho. Tacan cuu, ta ni chacuinda ra Mateo can, ta cuahan ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tacan cuu, ta queta ra Jesuu vehe ra Mateo. Nducuiti tuvi ra satiahvi chi ra ña sacahnu ley chahnu cha ni tiso ra Moisee. Ndaa ra Jesuu yu mesa chi ñivi sacuaha chi ra, ta ndaa tahan ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ndehe ra fariseo ta ra ti chachi ra Jesuu chi racan ta ra icaa ni, ta quechaha nducu tuhun ra ta ra chi ñi sacuaha chi ra ti: ―¿Ñacu chachi ra cuu maestru ndo chi ra satiahvi chi ra ña sacahnu ley Moisee icaa ni? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ta chini ra Jesuu cha cahan ra ta ra, ta cati ndico ra ti: ―Ña chini ñuhun ñivi ña cuhvi chi ra sanduvaha chi ñi, soco ñivi cuhvi cuu ñi chini ñuhun chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na cua cutuhva ndo ñaan cha cuu tuhun ya, vati cati tutu Ndioo ti cuni ra Ndioo cha cua cundahvi ini ndo chi ñivi tahan ndo. Ña cuni ra cha cua samani ni ndo cha chahmi ndo chihin ra. Tacan cati yu, vati ñavi cha cuenda ñivi iyo vaha quichi yu. Quichi yu cha cuenda ñivi iyo cuati ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tacan cuu, ta quichi ra sacuaha chi ra Juaan, ta quechaha nducu tuhun ra ta ra chi ra Jesuu ti: ―¿Ñacu chacoo ndita maan ndi chi ra fariseo, ta ña tuhva ñivi sacuaha chihun coo ndita ñi? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Ña cuu coo tu cuihya ini chi amigu ra cua tandaha quivi iyo ra chi ñi icaa ni, soco cua queta quivi cua cuhun ra, ta quivi can sa cua coo ndita ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Yoni cua nataa sahma chaa chi sahma chahnu, tu ña ta nandii sahma chaa can, vati cua nacaa ndico chi nu nataa chi, ta vihi ca cua ndoo chi cha lahnda ca chi. ");
INSERT INTO mioNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ta ni cuhva yoni cua tihi nduta chiti uva chaa tichi iti ñiin chahnu. Tu tacan cua savaha ñivi, cua ndata maan iti can, ta cua cati nduta can, ta cua ndoyo ñuhun iti ñiin can. Tichi iti ñiin chaa cua tihi ñi nduta chiti uva chaa, ta nduvi chi cua ndoo vaha. Tacan cati ra Jesuu, vati cua coto ñivi ti tuhun chaa yoso cuhva cua sacahnu ñi chi ra Ndioo cati tuhun ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ni vii cahan ra Jesuu chi ñivi can, ta quihvi iin ra ndiso tiñu. Tuhva ra nu ndaa ra Jesuu, ta chahnu chiti ra iti nuun ra Jesuu, ta quechaha cati ra chi ra ti: ―Cha ni chihi ña luhu sehi, soco cuahan, ta taun ndahun xini ña, ta cua coo ndito ndico ña ―cati ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tacan cuu, ta chacuinda ra Jesuu, ta quee ra cua ndicu ra chi ra, ta cuahan tahan ñi sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tacan cuu, ta cuahan tahan iin ñahan. Cha queta uchi uvi cuiya cha iyo xaan niñi ña chi ña. Tuhva ña iti chata ra, ta sayani ndaha ña yu sahma ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tacan ni savaha ña, vati saxini ña chi anima ña ti tu cua sayani ndaha ña―masi sahma ra, cua nduvaha ña, saxini ña. ");
INSERT INTO mioNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tacan cuu, ta chico coo ra Jesuu, ta ni ndehe ra chi ña, ta quechaha cati ra chi ña ti: ―Yoho sihi, na cua cusii ini cun. Cha ni nduvahun, vati chinu ini cun chihin yu ―cati ra. Ta suvi ni hora can ni nduvaha ña ñahan can. ");
INSERT INTO mioNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tacan cuu, ta queta ra Jesuu vehe ra ndiso tiñu can, ta quihvi ra. Ndehe ra chi ra tivi yaa ndii, ta ndehe ra ti cuvaa ndihi ñivi can, ");
INSERT INTO mioNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ta quechaha cati ra ti: ―Cua quee ndo, vati ña chihi ña luhu ya. Quixi ni ña ―cati ra chi ñi. Tacan, ta chacu nahan ñi cha cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tava ndaa ra chi ndihi ñican, ta quihvi ra nu caa ña luhu can, ta tiin ra ndaha ña, ta ndoyo ña. ");
INSERT INTO mioNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Queta tuhun can niniin ñuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Cha cua quee ra Jesuu tican, ta quechaha ndicu uvi ra cuaa chi ra. Cana chaa ra ta ra, ta cati ra ta ra chi ra Jesuu ti: ―Na cua cundahvi ini cun chihin ndi, yoho ra cuu ñivi ra David ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Quihvi ra Jesuu tichi vehe, ta tuhva ra cuaa can iti nuun ra Jesuu, ta quechaha nducu tuhun ra chi ra ta ra ti: ―¿Atu chinu ini ndo ti cha cuu savahi cuhva cuni ndo? ―cati ra. Ta cati ndico ra ta ra chi ra ti: ―Chinu ini ndi, ra chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tacan cuu, ta taa ra Jesuu ndaha ra nuun ra ta ra, ta cati ra chi ra ta ra ti: ―Na cua cuu chi cuhva ni chinu ini ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tacan cuu, ta ndundichin vaha ndehe ra ta ra, ta cati tuhun xaan ra Jesuu chi ra ta ra ti: ―Ña cua cahan ndo ni chi iin ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tacan cuu, ta quee ra ta ra cuahan ra, soco cati tuhun xaan ra ta ra nini cahnu ñuhun can yoso cuhva ni savaha ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tacan cuu, ta quee ñi ta ñi cuahan ñi, ta quichi ndaca ñivi chi iin ra ñihin nu iyo ra Jesuu, ta iyo tati cuihna anima ra ndahvi can. ");
INSERT INTO mioNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tava ndaa ra Jesuu chi maan run tati cuihna can, ta nducahan ra ndahvi can. Iyo cuni ndihi ñivi can, ta quechaha cati ñi ti: ―Ña ta ñahni ñivi Israel ndehe cuhva savaha rahya nu ni quichi quivi ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ta ra fariseo ta ra cati ti: ―Cha cuenda run ndaca ñahan chi run tati cuihna tava ndaa ra chi run ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tacan cuu, ta chica cuu ra Jesuu. Cuahan ra ndihi ñuun can, ta sacuaha ra chi ñivi tichi ve ñuhun ñi, ta cati tuhun ra tuhun vaha yoso cuhva cua cundaca ñahan ra Ndioo, ta sanduvaha ra chi ñivi cuhvi chi ndihi nuun cuehe can. ");
INSERT INTO mioNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ndehe ra chi ñivi iyo ican, ta cundahvi xaan ini ra chi ñi, vati iyo xaan ñi chi tu ndoho, ta ña chito ñi ñaan cha cua savaha ñi. Cha cuu ñi sava ni ta cua ri mbee, ta yoni ra sacuenda chi ri. ");
INSERT INTO mioNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tacan, ta quechaha cati ra chi ñivi sacuaha chi ra ti: ―Cuaha xaan tiñu iyo, soco ña queta ñivi cua satiñu. ");
INSERT INTO mioNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Cua cahan ndahvi ndo chi ra chahnu ti na cua tava tiñu ra chi ñivi cua satiñu, ta cua cundee queta tiñu ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Cana ra Jesuu chi uchi uvi ra cuu tatun ra, ta chaha ra ndatu cha cua tava ndaa ra ta ra chi run tati cuihna, ta cua sanduvaha ra ta ra chi ñivi cuhvi chi ndihi nuun cuehe. ");
INSERT INTO mioNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ta ra cuu tatun ra Jesuu cuu rahya ta ra. Xihna cuu ra Simón Pedro chi ra Ndree yani ra, ta ra Jacobo sehe Zebedeo chi Juaan yani ra, ");
INSERT INTO mioNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ta ra Felipe chi ra Bartolomé, ta ra Tuma chi ra Mateo ra satiahvi, ta ra Jacobo sehe Alfeo chi ra Tadeo, ");
INSERT INTO mioNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ta ra Simón ra cuni cuati chi ñivi ñuun Roma chi ra Juda Iscariote ra ni xico tuhun chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tava tiñu Jesuu chi tatun ra, ta cati tuhun ra chi ra ta ra ti: ―Ña cua cuhun ndo nu iyo ñivi cuu inga tucu ñivi, ta ni ña cua cuhun ndo nu iyo ñivi Samaria. ");
INSERT INTO mioNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cuahan ndo iti nu iyo ñivi Israel, vati cuu ñi sava ni ta cua ri mbee ndoyo ñuhun, vati ña chito ñi ndaa iti cuahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cuahan ndo, ta cati tuhun ndo ti yatin xaan cua cundaca ñahan ra iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cua sanduvaha ndo chi ñivi cuhvi, ta cua sanandoto ndico ndo chi ñivi ndii. Cua sanduvaha ndo chi ñivi cuhvi cuehe tahyu, ta cua tava ndaa ndo chi run tati cuihna. Cha nihin ndo ndatu, ta ñahni cha tiahvi ndo. Cua tindee ndo chi ñivi, ta ña cua tiahvi ñi chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ña cua cuiso ndo xuhun, ");
INSERT INTO mioNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ta ni ña cua cuiso ndo yunu. Ña cua cundichin toto ndo uvi coton, ta ni ña cua cuiso ndo uvi pare ndichan ni uvi garote. Iyo cha cua cuhva ñivi cha cua cachi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ta ndihi ñuun nu cua quihvi ndo cua nducu ndo ndaa ñivi cuu ñivi vaha ndicha. Chi ñican cua ndoo ndo nda cua nda cua queta quivi cua quee iti tucu ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cua quihvi ndo vehe, ta cua sacahnu ndo chi ñivi vehe can, ti na cua coo vii ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tu ña cua quihin cuenda ñivi can chihin ndo, ña cua coo vii ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tu ña cua quihin cuenda ñivi chi ndo, ta ni ña cua tasoho ñi tuhun cahan ndo, cua quee ndo vehe can, cua quee ndo ñuun can, ta cua naquisi ndo yaca ñuhun iñi chaha ndo, vati tacan cua coto ñi ti cua cutuni ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cati ndicha yu chihin ndo ti xaan xaan cua cutuni ñivi Sodoma chi ñivi Gomorra quivi cua tachi tuni ra Ndioo chi ñivi, soco xaan ca cua cutuni ñivi ña cua quihin cuenda chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ni vii cahan ra Jesuu chi ra tatun ra: ’Tava tiñu yu chihin ndo, ta cuu ndo sava ta cua ri mbee nu iyo ri ñucuii, vati cua cuni sandoyo ñuhun ñivi chi ndo. Na cua coo cha chini tuni chi ndo. Na cua coo masu ini ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Na cua saha ndo cuenda yoso cuhva iyo ñivi, vati cua tiin ñi chihin ndo, ta cua cundaca ñi chihin ndo nu ra cumi tiñu, ta cua cani ñi chihin ndo chi garote ve ñuhun ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Cua cundaca ñi chihin ndo nu ra cumi tiñu cahnu, vati chica ndo chihin yu. Chacan cuu cha cua cuhva ndo cuenda yoso cuhva iyo ra Ndioo iti nuun ra ndaca ñahan chi ñivi judío, ta cua cuhva tahan ndo cuenda iti nuun ra ndaca ñahan chi ñivi cuu inga tucu ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hora cua tiin ñi chihin ndo ña cua tichaha ni ndo. Ña cua saxini ndo yoso cuhva cua cati ndico ndo, vati cua cuhva ra Ndioo cha chini tuni chi ndo hora can, ta cua coto ndo ñaan cha cuu cha cua cati ndico ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ñavi maan ndo cua cahan, soco ra cuu Tati Ndioo sutu ndo cuu ra cua cuhva cha chini tuni chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Cua tiin iin rai chi yani ra, ta cua cundaca ra chi ra nu ra cumi tiñu, vati cua cuvi yani ra. Ta ni cuhva cua savaha inga rai chi sehe ra, ta inga ñivi cua savaha tacan chi sutu ñi chi sihi ñi, ta cua cuvi ñi cua savaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Cua cuxaan ini ndihi ñivi chi ndo, vati iyo ndo cuenda yu. Tu cua cundee ini ndo tu ndoho nda cua nda quivi cua yaha chi, cua cacu ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tu cua cuhva ñivi tu ndoho chi ndo iin ñuun, cua cunu ndo, ta cua queta ndo inga ñuun. Cati ndicha yu chihin ndo ti ña cua cuyatin yaha ndo ndihi ñuun Israel, ta cua quichi ra cuu sehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Cahnu ca cuu ra maestru, ta ñavi ca sa ñivi sacuaha chi ra. Ta ni cuhva cahnu ca cuu ra chitoho, ta ñavi ca sa musu ra. ");
INSERT INTO mioNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Vaha tu cua coo ñivi sacuaha cuhva iyo maestru ñi. Ta ni cuhva vaha tu cua coo ra musu cuhva iyo chitoho ra. Cha cati ñivi ti run cuihna run Beelzebú cuu yuhu. Chacan cuu cha xaan ca cua cahan ñi chi maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ni vii cahan ra Jesuu chi tatun ra: ’Ña cua cuyuhvi ndo chi ñivi, vati ndihi cha cua savaha xehe ñivi cua coto ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Cua cati tuhun ndo ndihi cha cua cati yu chihin ndo cha mani maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ña cua cuyuhvi ndo chi ñivi cuni cahni chi ndo, soco ña cuu sandoyo ñuhun ñi chi ndo chi ra Ndioo. Cua cuyuhvi ndo chi ra Ndioo, vati maan ra cuu ra cuu tava ndaa chi ndo, ta cua ndoyo ñuhun ndo nu cua cutuni ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Xico ñivi uvi ri saa cuati cha iin pesu, ta ña cua cuvi ri tu ña chaha ra Ndioo sutu ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ta chito tahan ra yoso tahan ixi xini ndo iyo. ");
INSERT INTO mioNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chacan cuu cha ña cua cuyuhvi ndo. Iyo ca yavi ndaa maan ndo, ta ñavi ca sa ri saa can―masi cuaha ri cuu ri. ");
INSERT INTO mioNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ni vii cahan ra Jesuu chi tatun ra: ’Ndihi ñivi cua cati chi ñivi tahan ñi ti chi yuhu iyo ñi―suvi ni cha cuenda maan ñi cua cati yu chi ra suti cha iyo iti siqui andivi ti chi main iyo tahan ñican. ");
INSERT INTO mioNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tu cua cati ñivi chi tahan ñi ti ña nacoto ñi chihin yu, ta ni cuhvi cua cati tahin nu suti ti ña nacote chihin ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ni vii cahan ra Jesuu chi ra tatun ra: ’Ña cua saxini ndo ti vachi yu, vati cua coo vii ñivi chi tahan ñi nu ñuhun ñuñivi ya. Ñavi tacan vachi yu. Vachi yu, vati cua cani tahan ñivi chi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Cua ndusaca cuni ñivi cuenda yu, vati cua cani tahan iin rai chi sutu ra. Cua cani tahan iin ñahan chi sihi ña, ta cua cani tahan iin ña chanu chi chiso ña, ");
INSERT INTO mioNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ta ñivi iyo vehe ñi cua cani tahan suvi ni chi maan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Tu cua cuni ca ñivi chi sutu ñi chi sihi ñi, ta ñavi ca sa yuhu, ñahni yavi ndaa cha iyo ñi chihin yu. Tu cua cuni ca ñi chi sehe ñi, ta ñavi ca sa yuhu, ñahni yavi ndaa cha iyo ñi chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tu ña iyo ini ñivi cha cua ndehe ñi tu ndoho cuenda yu―masi cua cuvi ñi cuenda yu, tu ña cua coo inuun ñi chihin yu, ñahni yavi ndaa cha iyo ñi chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tu cua nducu ñivi cuhva cha cua cacu ñi nu cua ndehe ñi tu ndoho cuenda yu, cua ndoyo ñuhun ndicha ñi cuenda yu, soco tu cua cuvi ñi cuenda yu, cua coo ndito ndico ñi chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ni vii cahan ra Jesuu chi tatun ra: ’Tu cua quihin cuenda ñivi chihin ndo, cua quihin cuenda ñi chi yuhu, ta tu cua quihin cuenda ñi chi yuhu, cua quihin cuenda tahan ñi chi ra tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tu cua quihin cuenda ñivi chi iin ra cahan cuenda ra Ndioo, vati cahan ra cuenda ra Ndioo, cua cunda yahvi ñi chi ra Ndioo can cuhva iyo yahvi ra cahan cuenda ra Ndioo. Tu cua quihin cuenda ñivi chi iin ñivi vaha ndicha, vati ñivi vaha ndicha cuu ñi, cua cunda tahan yahvi ñi chi ra Ndioo cuhva cha ndaa yahvi chi ñivi vaha can chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tu cua tindee ñivi chi iin ndo―masi ra luhu cuii cuu ndo, ta cua cuhva ñi nduta coho ndo, vati iyo ndo chihin yu, cati ndicha yu chi ndo ti cua cunda yahvi ndicha ñi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tacan, ta ndihi cati tuhun ra Jesuu chi ra cuu tatun ra, ta sa quee ra tican, ta cuahan ra, vati cua cati tuhun ra ndihi ñuun iyo ican, ta cua sacuaha ra chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tacan cuu, ta chini ra Juaan tuhun yoso cuhva cha ni savaha ra Jesuu―masi indi ra Juaan can ve caa, soco tava tiñu ra tatun ra nu iyo ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ta nducu tuhun ra ta ra chi ra ti: ―¿Atu maun cuu ra iyo cha cua quichi cuenda ra Ndioo a cua cuatu nuun ca ndi chi inga ra? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cuahan ndo, ta cati ndico ndo ñaan cha cuu cha ni chini soho ndo ñaan cha cuu cha ni ndehe ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Cua cati ndo chi ra Juaan ti ndichin vaha ndehe ñivi cuaa, ta chica cuu ñivi cojo. Nduvaha ñivi cuhvi cuehe tahyu, ta chini ñivi soho. Nandoto ndico ñivi ndii, ta chini soho ñivi ndahvi tuhun vaha, cua cati ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Cua cusii ini ñivi, tu ña cua saxini ñi ndavaha ni cuenda yu, ta cua ndoyo ñuhun ñi ―cati ra chi ra tatun ra Juaan. ");
INSERT INTO mioNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tacan cuu, ta cuahan ra tatun ra Juaan can, ta quechaha cati ra Jesuu chi ndihi ñivi can cuenda ra Juaan ti: ―Chahan ndo tichi cuhu, soco ñavi vati cuni ndo ndehe ndo nu tuñu maan tuyoo can, soco cuni ndo ndehe ndo chi iin rai ndicha. ");
INSERT INTO mioNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Chahan ndo tican, soco ñavi vati cuni ndo ndehe ndo chi iin ra ndichin sahma yaxin sahma vaha, vati iyo ñivi ndichin tacan tichi ñuun nu iyo vehe ra rey, soco cuni ndo ndehe ndo chi iin rai ndichin cuhva ni chacundichin ra cahan cuenda ra Ndioo tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chahan ndo tican, vati cuni ndehe ndo chi iin ra cahan cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cati yu chihin ndo ti ni ndehe ndo chi iin ra cahan ndicha cuenda ra Ndioo. Cati tutu Ndioo cuenda ra Juaan can ti cua tava tiñu ra Ndioo iin tatun ra, ta cua cuhun ra iti nuun inga ra, ta cua tiso vaha ra tatun can tiñu iti nu cua yaha racan, cati chi. ");
INSERT INTO mioNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cati ndicha yu chihin ndo ti cahnu xaan rai cuu ra Juaan ra sacuanduta can, soco ñivi cuu ñivi cua coo nu cua cundaca ñahan ra Ndioo―masi ñivi ndahvi ndicha cuu ñi, soco cahnu ca cua cuu ñivi can, ta ñavi ca sa ra Juaan can. ");
INSERT INTO mioNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Nda ni quivi quechaha cati tuhun ra Juaan ta nda cua nda vitin nducu xaan ñivi cuhva cha cua coo ñi nu cua cundaca ñahan ra iyo iti siqui andivi, ta nihin xaan nducu ñi cuhva. ");
INSERT INTO mioNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Cha cati ra ni cahan cuenda ra Ndioo tichi tutu ni taa ra tiempu chahnu, ta cha cati ra Moisee tichi tutu ley ni taa ra ti cua quichi iin rai, ta ra Juaan cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tu cua cuni ndo cuinu ini ndo tuhun can, cua coto ndo ti maan ra Juaan can cuu cuhva ra Elía ra ni cua quichi cuhva ni taa ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na cua taa vaha ndo soho ndo tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Ñivi iyo vitin tichi quivi ya cuu sava ni ta cua ñi cuati siqui nuyahvi, ta ña nduinuun ñi ta ñi nu siqui ñi. Cana chaa ñi chi tahan ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ta cati ñi chi tahan ñi ti tivi ñi yaa, ta ña chita chaha tahan ñi. Chita ñi yaa ndii, ta ña cuvaa tahan ñi, cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tacan cati yu, vati quichi ra Juaan, ta chacoo ica xaan ra, vati ña tuhva ra cachi. Ña tuhva ra coho, ta cati maan ñivi ti cha iyo iin tati cuihna chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tacan cuu, ta quichi tahan yu ra cuu sehe ñivi, ta iyo yu cuhva iyo maan ñivi can, soco cati ñi ti yaha cuhva cha chachi yu, ta yaha cuhva cha chihi yu. Amigu yu chi ñivi ndacu ndavaha ni chi ra satiahvi, cati ñi. Yuhu cati ti tu cua savaha ñivi cha nditi vaha cuhva cuni ra Ndioo, cua savaha ñi iin cha vaha ndicha, cuhva savaha maan ra Juaan cuhva savaha yu ra cuu sehe ñivi ―cati ra Jesuu chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tacan cuu, ta quechaha ra Jesuu nduxaan ra chi ñivi ndihi ñuun nu ni savaha ra cha cahnu ndicha, vati ña saña ihni ñi cuati ndacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Cati ra chi ñi ti: ―Ndioho ñivi ñuun Corazín, ndioho ñivi ñuun Betsaida, cua ndehe ndo tu ndoho, vati tu cha ndehe tahan ñivi ñuun Tiro chi ñivi ñuun Sidón cuhva cahnu cuhva cha ni ndehe maan ndo, yatin xaan cua coo cuihya anima ñi, ta sa cua saña ihni ñi cuati savaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Chacan cuu cha cati yu chihin ndo ti xaan cua ndehe ñivi ñuun can tu ndoho quivi cua cutuni ñivi iti nuun ra Ndioo, soco xaan ca cua coo tu ndoho chi maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ta ndioho ñivi ñuun Capernaum, ña cua coo cha vaha chi ndo iti siqui andivi, soco cua coo ndo iti andaya. Tu cha ni ndehe ñivi ñuun Sodoma cuhva cahnu ndicha cuhva ni ndehe maan ndo, ni vii iyo ñuun can nda cua nda vitin, vati cua saña ihni ñi cuati ni savaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chacan cuu cha cati yu chihin ndo ti xaan cua tachi tuni ra Ndioo chi ñivi ñuun can quivi cua cutuni ñivi, soco xaan ca cua cutuni ñivi ñuun ya ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Suvi ni hora can cati ra Jesuu chi sutu ra ti: ―Tata, yoho ndaca ñahan iti siqui andivi ta nu ñuhun ñuñivi ya. Sacahnu yu chihun, vati ña chaha maun cha chini tuni chi ñivi nditi vaha xini, ta cutuni ini ñi cha ndacu i, soco cha chahun cha cua cutuni ini ñivi ndahvi. ");
INSERT INTO mioNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tata, cuhva cha cuni maun cuu chacan ―cati ra Jesuu chi sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tacan, ta sa cati ra chi ñivi can ti: ―Chaha ra suti ndihi cha ndacu i. Yoni ñivi chito yoso cuhva iyo ra cuu sehe Ndioo. Iin tuhun ni ra Ndioo chito, ta yoni ñivi chito yoso cuhva iyo ra cuu sutu ra. Iin tuhun ni ra cuu sehe ra chito, ta iyo ñivi cuni sacoto ra cuu sehe ra. Ñican ni chito tahan yoso cuhva iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nahan ndo, ndihi ndo cha chitatun, ndihi ndo ndiso cha vee, ta yuhu cua cuhve cha cua coo vii anima ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na cua cuiso ndo cuhva cati yu. Na cua savaha ndo cuhva cati yu, vati ña rai cuni yu, ta ña xaan cuni yu ndehi chihin ndo. Tacan, ta cua coo vii anima ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","vati ña vee cha cua tise chi ndo, ta vii ni cua savaha ndo cha cati yu ―cati ra Jesuu chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Suvi ni quivi can cuahan ra Jesuu, ta iin quivi sábadu quivi ndaa tatun ñivi judío cuu chi, ta yaha ra chiqui. Cuahan tahan tatun ra, ta chisoco ra ta ra, ta quechaha yucu ra ta ra chiti trigu can, ta chachi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ndehe ra fariseo ta ra, ta quechaha cati ra ta ra chi ra Jesuu ti: ―¡Jihna! cha ndacu tatun cun, ta ña chaha ley chahnu cha ndacu ra tacan quivi sábadu ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Vasi ña ta sacuaha ndo tutu Ndioo. Vasi ña chito ndo ñaan cha ni savaha ra David quivi chisoco ra chi ra chica chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Quihvi ra David can vehe Ndioo, ta chachi ra paan cuecu iti nuun ra Ndioo, ta ñahni ndatu cha cua cachi ra chacan, ta ñahni ndatu chi ra chica chi ra, soco chachi tahan ra. Iin tuhun ni ra cuu sutu ta ra―chi racan iyo ndatu. ");
INSERT INTO mioNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Vasi ña ta sacuaha ndo tutu ley chahnu. Suvi ni quivi sábadu iyo ra sutu ta ra ve ñuhun. Savaha ra cha cuu tiñu ra, ta ñahni ndatu iyo cha savaha ra tacan, soco ña tiso ndo cuati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Cati yu chihin ndo ti cahnu cuu ve ñuhun, soco cahnu xaan ca cuu cha ndacu ra Ndioo vitin. ");
INSERT INTO mioNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ña chito ndo ñaan cha cuu tuhun Ndioo nu cati ra ti cuni ra cha cua coo tu ndahvi ini chi ñivi. Ña cuni ra cha cua samani ñi chihin ra, cati ra. Tu chito ndo chacan, ña cua cati ndo ti ña vaha savaha ñivi ñahni cuati iyo. ");
INSERT INTO mioNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tacan cati yu, vati yuhu ra cuu sehe ñivi cuu ra cati ñaan cha cuu cha cua savaha ñivi quivi sábadu ―cati ra Jesuu chi ra fariseo ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tacan cuu, ta quee ra Jesuu tican. Cuahan ra, ta quihvi ra ve ñuhun ñivi judío can. ");
INSERT INTO mioNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ican iyo iin ra nduxii ndaha, ta quechaha nducu tuhun ra fariseo ta ra chi ra Jesuu ti: ―¿Atu chaha ley chahnu cha sanduvaha ñivi quivi sábadu? ―cati ra ta ra, vati cuni ra ta ra tiso ra cuati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Tu iyo iin ri mbee chihin ndo, ta cua quehni ri tichi xahva―masi quivi sábadu cuu chi, soco ndihi ndo cua tiin ndo chi ri, ta cua tava ndo chi ri nu quehni ri. ");
INSERT INTO mioNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Iyo yavi ndaa ri mbee, soco iyo ca yavi ndaa ñivi. Chacan cuu cha chaha ley cha cua savaha yo cha vaha quivi sábadu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tacan cuu, ta cati ra chi ra ndahvi can ti: ―Sacaun ndahun. Tacan, ta sacaa ra ndaha ra. Nduvaha chi, ta vaha ndoo chi cuhva iyo tahan chi. ");
INSERT INTO mioNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Quee ra fariseo ta ra cuahan ra, ta nducu ra ta ra cuhva, vati cuni ra ta ra cahni ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chito ra Jesuu yoso cuhva saxini ra fariseo ta ra, ta quee ra cuahan ra. Tacan cuu, ta ndicu ñivi chi ra. Tuvi ñivi ndicu chi ra, ta sanduvaha ra chi ndihi ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ta cati tuhun xaan ra chi ñi ti na ña cua cati ñi yoo rai cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tacan, ta ni queta tuhun cha ni taa ra Isaía ra ni cahan cuenda ra Ndioo tiempu chahnu, vati cati ra Ndioo cuenda ra Jesuu ti: ");
INSERT INTO mioNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Rahya cuu musu yu. Suvi ra cuu ra cha ni nacachi yu. Cuni mani yu chihin ra, ta cusii ini yu cha ndacu ra. Cati yu ti cua coo ra Tati Ndioo chi ra, ta cua cati ra chi ñivi cuu inga tucu ñivi yoso cuhva cua coso vaha anima ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ña cua cahan yuhu ra chi ñivi, ta ni ña cua cuvaa ra. Ña cua cana chaa ra iti. ");
INSERT INTO mioNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ña cua tava ndaa ra chi ñivi ndahvi, soco cua tindee ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tacan cua savaha ra nda cua nda quivi cua cundee coso vaha anima ñivi cuu inga tucu ñivi, cati ra Ndioo, ni taa ra Isaía can cuenda ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tacan cuu, ta quichi ndaca ñivi chi iin ra cha iyo tati cuihna anima nu ra Jesuu. Cuaa ra ndahvi can, ta ñihin ra. Tacan cuu, ta sanduvaha ra Jesuu chi ra. Chacan cuu cha nducahan ra ñihin can, ta ndundichin vaha ndehe ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iyo xaan quechaha cuni ndihi ñivi can, ta cati ñi ti: ―Vasi ra ni tava tiñu ra Ndioo cuu rahya ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Chini ra fariseo ta ra tuhun can, ta cati ndico ra ta ra ti: ―Tava ndaa ra chi run tati cuihna, soco tindee run Beelzebú chi ra, ta rucan cuu run ndaca ñahan chi ndihi run tati cuihna ―cati ra fariseo can. ");
INSERT INTO mioNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Chito ra Jesuu cuhva ni saxini ra fariseo can, ta quechaha cati ra chi ra ta ra ti: ―Tu cua cani tahan ñivi iin ñuun chi tahan ñi, cua ndoyo ñuhun ñuun can. Tu cua cani tahan ñivi iyo iin vehe chi tahan ñi, cua ndoyo ñuhun tahan ñican. ");
INSERT INTO mioNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tu cua tava ndaa ñivi run Satanaa suvi ni chi maan run, ña inuun iyo ñivi run suvi ni chi maan run. Chacan cuu cha ña cua ndunahan run chi tahan run. ");
INSERT INTO mioNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Cati ndo ti tava ndai chi run tati cuihna can, vati chaha run Beelzebú tu ndee ini chihin yu. Tu chacan cuu chi, ¿yoso nihin ñivi maan ndo tu ndee ini, ta tava ndaa maan ñi chi run? Chacan cuu cha sanahan suvi ni ñivi ndo ti cha ña vaha cuhva ni saxini maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ñavi cuhva can cuu chi, vati chaha ra Tati Ndioo tu ndee ini chihin yu, ta tava ndai chi run tati cuihna. Chacan cuu cha ni queta quivi cha ndaca ñahan ra Ndioo nu iyo ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ña cua cuu quihvi ñivi tichi vehe iin ra iyo xaan tu ndee ini, ta cua quihin ñi ndatiñu ra, tu ña cua cuhni xihna ñi chihin ra. Tacan, ta sa cua suhu ñi ndihi cuii ndatiñu ra. Tacan ni cha savahi chi run Satanaa. ");
INSERT INTO mioNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Tu ña cua coo ndo chihin yu, cua cuni cani tahan ndo chihin yu. Tu ña cua tindee ndo chihin yu, cua tava ndaa ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Chacan cuu cha cati yu chihin ndo ti ndihi ca cuati ndacu ñivi ñuñivi cua cuu cucahnu ini ra Ndioo, soco tu cua cati ñivi cuhva cati ndo ti ña ndicha ra Tati Ndioo, ña cua cucahnu ini ra Ndioo chacan. ");
INSERT INTO mioNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tu cua cati ñivi ti ña vaha ra cuu sehe ñivi, cua cuu cucahnu ini ra Ndioo, soco tu cua cati ñivi cuhva cati ndo ti ña vaha ra Tati Ndioo, ña cua cucahnu ini ra Ndioo chacan vitin tichi quivi ya, ta ni ña cua cucahnu ini ra nda cua nda quivi iti nuun ca. ");
INSERT INTO mioNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ni vii cahan ra Jesuu chi ra fariseo can: ’Cua cati yu iin cuhva. Tu iyo iin yutun vaha, cua quee vaha chiti chi. Tu ña vaha iyo yutun can, ña cua quee vaha chiti chi. Chito yo ñaan cuhva iyo yutun, vati ndehe yo yoso cuhva iyo chiti chi. ");
INSERT INTO mioNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ñivi ndavaha ni cuu ndo. Ña cuu cahan ndo cha vaha, vati iyo xaan ndo chi cha ndavaha ni, vati cahan ñivi cuhva saxini ñi chi anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mani cha vaha cahan ñivi saxini cha vaha chi anima ñi, ta mani ndavaha ni cahan ñivi saxini cha ndavaha ni chi anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Cati yu chihin ndo ti tu cua cahan ñivi tuhun ndavaha ni, cua cuhva ñi cuenda ñacu cahan ñi tacan quivi cua cutuni ñivi, ");
INSERT INTO mioNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","vati cua quee vaha ndo cuhva ni cahan ndo a cua cutuni ndo cuhva ni cahan ndo ―cati ra Jesuu chi ra fariseo ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tacan cuu, ta ra fariseo chi ra sacuaha ley chahnu quechaha ndatuhun ra chi ra Jesuu, ta cati ra ta ra chi ra ti: ―Yoho maestru, cuni ndehe ndi iin cuhva cahnu xaan cha cua savahun ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Ñivi ndacu ndavaha ni, ñivi ña chinu ini chi ra Ndioo―ñican cuu ñi cuni ndehe iin cuhva cha cua savaha ra Ndioo, soco ña cua savaha ra inga cuhva. Iin tuhun ni cuhva ni savaha ra Ndioo cuhva cha ni tahan ra Jonaa ra ni cahan cuenda ra Ndioo tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Cuhva cha ni chacoo ra tichi ri tiaca cahnu can uni quivi―cuhva can cua coo ra cuu sehe ñivi, vati uni quivi cua coo ra tañu ñivi ndii. ");
INSERT INTO mioNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Cua cati ra rai ni chacoo ñuun Nínive ti iyo cuati chi ñivi iyo vitin, ta cua tachi tuni ra chi ñi quivi cua cutuni ñivi. Tacan cua savaha ra, vati ni tasoho ra cha cati tuhun ra Jonaa, ta saña ihni ra ta ra cuati savaha ra. Vasi cahnu xaan rai cuu ra Jonaa can, soco cahnu ca cuu ra iyo vitin. ");
INSERT INTO mioNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ta ni cuhva cua cati ña ni chandaca ñahan ñuhun iyo iti xuu ti iyo cuati chi ñivi iyo vitin, ta cua tachi tuni ña chi ñi. Tacan cua savaha ña, vati cani xaan chahan ña, vati cuni ña tasoho ña tuhun nditi cha cahan ra Salomón tiempu chahnu. Ndicha ti cahnu xaan rai cuu ra Salomón can, soco cahnu ca cuu ra iyo vitin. ");
INSERT INTO mioNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ni vii cahan ra Jesuu chi ra fariseo chi ra sacuaha ley chahnu: ’Ta run tati cuihna can―tu cua quee ndaa run tichi anima ñivi, cua cuhun run. Cua caca cuu run tichi cuhu nu ñahni nduta, ta cua nanducu run cha cua coo vaha run, soco ña cua nanihin run. ");
INSERT INTO mioNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tacan cuu, ta cua quechaha saxini run chi anima run ti cua cuhun ndico run nu ni quee run, cua saxini run. Cua cuhun ndico run, ta cua ndehe run ti cha iyo vaha cha cua quihvi ndico run tichi anima ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chacan cuu cha cua quee run cuhun run, ta cua quihin run inga ucha tati cuihna. Xaan ca rucan ta run, ta cua quihvi run ta run tichi anima ñi, ta ndahvi ca cha cua ndoo ndico ñican, ta ñavi ca cha xihna nu ni quichi quivi. Tacan ndahvi ca cua ndoo tahan ñivi iyo vitin, vati ndavaha ni ndacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ni vii cahan ra Jesuu chi ndihi ñivi can, ta sa ni queta sihi ra chi yani ra nu iyo ra, ta ni chacuinda ñi iti chata, ta cuni ñi cahan ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tacan cuu, ta quechaha cati iin ñivi chi ra ti: ―Inda sihun chi yani cun nuquehe, ta cuni ñi cahan ñi chihun ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ta nducu tuhun ndico ra chi ñican ti: ―¿Yoo cuu sihi yu? ¿Yoo cuu yani yu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tacan cuu, ta sanahan ndaha ra nu ndaa ñivi sacuaha chi ra, ta quechaha cati ra ti: ―Ihya iyo sihi yu chi yani yu. ");
INSERT INTO mioNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tacan cati yu, vati tu cua savaha ñivi cuhva cuni ra suti iyo iti siqui andivi, ñican cuu sava ni ta cua yani yu chi cuhva yu chi sihi yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Quivi can quee ra Jesuu tichi vehe nu chacoo ra, ta cuahan ra. Yu tañuhun queta ra, ta ni chacunda ra. ");
INSERT INTO mioNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tuvi xaan ñivi cuu ñi nducuiti nu ndaa ra. Chacan cuu cha quihvi ra tichi tundoo, ta chacunda ndico ra, ta chacuinda ndihi ñivi can yu tañuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Cuaha xaan cahan ra Jesuu chi ñi. Chi cuhva cahan ra, ta quechaha cati ra ti: ―Cha iyo iin rai, ta quee ra cuahan ra, vati cua cata cuati ra chiti. ");
INSERT INTO mioNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Chata cuati ra chiti can, ta quehni suhva chi nu iti, ta quichi ri saa, ta chachi ri chi chi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Inga suhva chi quehni nu iyo xaan yuu, ta ñahni ñuhun cha vaha. Yatin xaan cana chi, vati ña cocon vaha iyo ñuhun can, ");
INSERT INTO mioNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ta cana nicandi, ta quechaha xii chi, ta neti chi, vati ñahni yoho chi cha vaha. ");
INSERT INTO mioNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ta inga suhva chi quehni nu iyo iñu, ta cana tahan maan iñu can, ta chasi iñu can nuun chi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Inga suhva chiti can quehni nu ñuhun vaha, ta cuaha xaan chiti chi chacoo ndico. Iyo chi chaha iin ciendu chiti chi. Iyo inga chi chaha uni xico chiti chi, ta iyo inga chi chaha oco uchi chiti chi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na cua taa vaha ndo soho ndo ―cati ra Jesuu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tacan cuu, ta tuhva ñi sacuaha chi ra Jesuu nu iyo ra, ta quechaha nducu tuhun ñi chi ra ti: ―¿Ñacu chi cuhva ni cahun chi ñivi? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ta cati ndico ra ti: ―Chaha ra Ndioo cha cua cutuni ini ndo tuhun yoso cuhva cua cundaca ñahan ra iyo iti siqui andivi, soco ña chaha ra cha cua cutuni ini ñican. ");
INSERT INTO mioNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tu cutuni ini ñivi vitin―masi suhva, cua cuhva ra Ndioo cha cua cutuni ca ini ñi, ta cua cutuni vaha ini ñi nu cuahan quivi. Tu ña nituni ini ñi yoso cuhva iyo ra Ndioo, cua naan cha chini tuni cha iyo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chacan cuu cha cahin chi ñi chi cuhva, vati ña cuni ñi coto ñi, ta ni ña cuni ñi cutuni ini ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Maan ñi saqueta tuhun cha ni cahan ra Isaía cuenda ra Ndioo tiempu chahnu, vati cati ra cuenda ñican ti: Cua cuni soho ndo tuhun, soco ña cua cutuni ini ndo chi chi, ");
INSERT INTO mioNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","vati ndava xaan iyo ini ñivi ya, ta ña taa vaha ñi soho ñi. Xaan cuni ñi chini ñi tuhun can, coto cua cutuni ini ñi, ta cua saña ñi cuhva ndacu ñi, ta cua nduvaha anima ñi, cati ra Isaía can. ");
INSERT INTO mioNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Cusii ini ndo, vati cha ni ndehe ndo, ta cha ni chini soho ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cati ndicha yu chihin ndo ti nu ni quichi quivi tuvi xaan ra ni cahan cuenda ra Ndioo, ta tuvi xaan ñivi savaha cuhva cati ra Ndioo―tuvi ñican cuni xaan ñi ndehe ñi cuhva ndehe maan ndo, soco ña ni ndehe ñi. Cuni xaan ñi cuni soho ñi cuhva chini soho ndo, soco ña ni chini soho ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ni vii cahan ra Jesuu chi ñivi sacuaha chi ra: ’Cha ni chini soho ndo tuhun yoso cuhva iyo ra chata cuati chiti. ");
INSERT INTO mioNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tu cua cuni soho ñivi tuhun yoso cuhva cua cundaca ñahan ra iyo iti siqui, ta ña cua cutuni ini ñi tuhun can, cua quichi run cuihna, ta cua sanaan run cha chini soho ñivi can. Ñican cuu sava ta cua chiti can cha quehni nu iti. ");
INSERT INTO mioNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Iyo inga ñivi chini soho tuhun can, ta quii xaan cusii ini ñi chini ñi chi chi. Ñican cuu sava ta cua chiti quehni nu iyo yuu can, ");
INSERT INTO mioNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ta ñahni yoho chi cha vaha. Suhva quivi ni ndunahan ñi, ta quechaha ndehe ñi tu ndoho. Quechaha cuni cani tahan ñivi chi ñi, vati chinu ini ñi tuhun can, ta quii xaan ndoyo ñuhun ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Iyo tahan inga ñivi tasoho tuhun can, soco saxini ñi yoso cuhva iyo ñivi ñuñivi, ta cuni ñi cha cua coo tahan xuhun ñi. Tacan, ta ña cuni ca ñi cuni soho ñi tuhun can, ta ñahni cha cuu sava ta cua chiti can cua coo chi ñi. Ñican cuu sava ta cua chiti ni quehni nu iyo iñu can. ");
INSERT INTO mioNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ta ñivi tasoho tuhun can, ta cutuni ini ñi chi chi, ta savaha ñi cha vaha―ñican cuu sava ta cua chiti ni quehni ñuhun vaha, ta cana chiti chi. Iyo chi chaha ciendu chiti chi, ta iyo chi chaha uni xico chiti chi, ta iyo chi chaha oco uchi chiti chi ―cati ra Jesuu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Cahan ndico ra Jesuu inga cuhva chi ñi, ta quechaha cati ra ti: ―Nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ni ta cua iin rai, ta tachi ra chiti vaha chiqui ra. ");
INSERT INTO mioNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tacan cuu, ta hora ni quixi ñivi quichi iin ra cuxaan ini chi ra, ta tachi tahan run chiti cuhu ña vaha nu tachi ra chiti trigu can, ta cuahan ndico run. ");
INSERT INTO mioNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Cana itu can, ta quee chiti chi, ta sa cana tahan maan cuhu ña vaha can. ");
INSERT INTO mioNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tacan cuu, ta cuahan ra musu can, ta quechaha nducu tuhun ra ta ra chi chitoho ra ti: “Ra chahnu, ¿atu ña tachi cun chiti vaha chiqui cun? ¿Ñacu cana xaan cuhu ña vaha?” cati ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ta cati ndico ra chi ra ta ra ti: “Cuxaan ini ñivi chihin yu, ta savaha ñi chacan,” cati ra. Nducu tuhun ndico musu ra chi ra ti: “¿Atu cuni cun cha cua cuhun ndi, ta cua tuhun ndi cuhu can?” ");
INSERT INTO mioNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ta cati ndico ra chi ra ta ra ti: “Ña cua savaha ndo chacan, coto cua tuhun tahan ndo cha vaha chi cha ña vaha. ");
INSERT INTO mioNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Saña ndo. Na cua cuahnu nduvi chi icaa ni nda cua nda quivi cua canihin yo chi chi. Quivi can cua cati yu chi ra cua canihin chi chi ti cahnda xihna ra cuhu can, ta cuhni ra chi chi, ta cahmi ra chi chi. Tacan, ta sa cua canihin vaha ra chiti can, ta cua tivaha ra chi chi tichi yaca yu,” cua cati yu, cati ra ―cati ra Jesuu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Inga cuhva cahan ndico ra Jesuu chi ñivi can. Cati ra ti: ―Nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ni ta cua iin chiti motasa. Quihin iin rai chiti can, ta tachi ra chi chi chiqui ra. ");
INSERT INTO mioNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Cuati xaan chiti can, soco chahnu chi, ta cahnu xaan yutun cuu chi. Chacan cuu cha quichi ri saa, ta savaha ri taca ri soco chi. Tacan cati ra Jesuu, vati cua ndutuvi ñivi quihvi cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Inga ndico cuhva cahan ra Jesuu chi ñican. Cati ra ti: ―Nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ta cua iin nduta cha sanandaa yuti paan cha quihin iin ñahan. Tihi ña chi chi tichi uni cuhva yuti paan, ta chinu xico chi niniin yuti paan can. Tacan cati ra Jesuu, vati cua coto ñivi yoso cuhva cua cundaca ñahan ra Ndioo nini cahnu nu ñuhun ñuñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ndihi cuhva can cahan ra Jesuu chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chacan cuu cha ni queta tuhun cuhva ni cati ra cahan cuenda ra Ndioo tiempu chahnu, vati cati ra cuenda ra Jesuu ti: Chi cuhva ni cua cahan ra. Cua cuhva ra cuenda ndihi tuhun cha indi xehe nda ni xihna cuii quivi ni tiso ra Ndioo ñuhun ñuñivi ya, cati ra ni cahan cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tacan cuu, ta quee ra Jesuu nu iyo ñivi can, ta cuahan ra. Queta ra vehe, ta queta tahan ra sacuaha chi ra nu iyo ra, ta quechaha cati ra ta ra ti: ―Na cua cuhva cun cuenda chi ndi ñaan tuhun cuu tuhun cha iyo cuhu ña vaha chi chiti trigu can icaa ni ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Ra cuu sehe ñivi cuu ra tachi chiti vaha, ");
INSERT INTO mioNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ta chiqui ra cuu sava ta cua ñuhun ñuñivi ya. Ñivi iyo cuenda ra cua cundaca ñahan cuu chiti vaha can, ta ñivi iyo cuenda run savaha ndavaha ni cuu chiti cuhu ña vaha can, ");
INSERT INTO mioNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ta run cuihna cuu run cuxaan ini, ta tachi run chiti cuhu can. Quivi cua canihin vaha ra ta ra chiti can cuu quivi cua cundihi quivi ya, ta ra tatun Ndioo cuu ra cua canihin vaha chiti. ");
INSERT INTO mioNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Cuhva satahan ra ta ra cuhu can, ta chahmi ra ta ra chi chi―cuhva can cua coo chi nu cua cundihi quivi ya, vati cua cutuni ñivi ndacu ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Cua tava tiñu ra cuu sehe ñivi chi ra tatun Ndioo, ta cua sacuiti ra ta ra chi ndihi ñivi ndacu ndavaha ni nu iyo ñivi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ta cua tihi ra ta ra chi ñi nu cayu ñuhun. Ican cua coo tu cuihya ini chi ñi, ta cua ndahyu chaa ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Quivi can cua coo ñivi ni chacoso vaha anima nu cua cundaca ñahan sutu ñi, ta taqui xaan cua cuu ñi cuhva taqui tuun ri nicandi. Na cua taa vaha ndo soho ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ni vii cahan ra Jesuu chi ra sacuaha chi ra ti: ’Nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ni ta cua xuhun cha indi xehe chiqui. Nanihin iin rai chi chi, ta tixehe ndico tucu ra chi chi. Cusii ini ra, ta cuahan ra, ta xico ra ndihi cha iyo chi ra, ta sata ra ñuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ni vii cahan ra Jesuu chi ra sacuaha chi ra ti: ’Nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ta cua iin ra nanducu perla vaha ndicha, vati cua sata ra chi chi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nanihin ra iin cha yahvi xaan. Tacan cuu, ta cuahan ra, ta xico ra ndihi cuii cha iyo chi ra, ta sata ra perla can. ");
INSERT INTO mioNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ni vii cahan ra Jesuu chi ra sacuaha chi ra ti: ’Nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ta cua iin taraya. Cani ra ta ra taraya can nu tañuhun, ta tacan tiin ra ndihi nuun ri tiaca can. ");
INSERT INTO mioNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chitu maan taraya can, ta xita ra chi chi nda cua nda nu ñuhun, ta ndaa ra nacachi ra chi ri vaha, soco savita ra chi ri ña vaha. ");
INSERT INTO mioNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ta ni cuhva cua savaha ra Ndioo nu cua cundihi quivi ya. Cua quee ra tatun Ndioo, ta cua sachiyo ra ta ra chi ñivi ndavaha ni nu iyo ñivi cha iyo vaha. ");
INSERT INTO mioNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Chi ñivi ndavaha ni can cua tihi ra ta ra nu cayu ñuhun. Tican cua coo tu cuihya ini chi ñi, ta cua ndahyu chaa ñi, vati cua ndehe ñi tu ndoho. ");
INSERT INTO mioNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ni vii cahan ra Jesuu chi ra sacuaha chi ra, ta nducu tuhun ra chi ra ta ra ti: ―¿Atu cutuni ini ndo ndihi cuhva can? Ta cati ndico ra ta ra ti: ―Cutuni ini ndi. ");
INSERT INTO mioNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ta cati ra ti: ―Chacan cuu cha ndihi ñivi sacuaha yoso cuhva iyo nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ta cua iin rai xu vehe, ta tava ra cha chaa, ta tava ra cha chahnu nu indi cha vaha cha iyo chi ra. Tacan cati ra Jesuu, vati cua cutuni ini ñivi sacuaha chi ra tuhun ña ta coto ñivi nu ni quichi quivi, ta cua cutuni tahan ini ñi tuhun cha ni chito ñivi tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Cha ndihi cahan ra Jesuu cuhva can, ta quee ra cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Queta ra ñuun ra, ta quechaha sacuaha ra chi ñivi can tichi ve ñuhun ñi. Chacan cuu cha iyo cuni ñi, ta quechaha nducu tuhun ñi chi tahan ñi ti: ―¿Yoo chaha cha chini tuni cha cahan rahya? ¿Yoo chaha tu ndee ini cha ni savaha ra cuhva cahnu xaan can? ");
INSERT INTO mioNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Sehe ra sata vitu ñuun yo chi ra. Sihi ra cuu ña María ya, ta yani ra cuu ra Jacobo chi ra José chi ra Simón chi ra Juda. ");
INSERT INTO mioNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Iyo ndihi cuhva ra chi yo ―cati ñi ta ñi chi tahan ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ta ña chaa ini ñi chi ra Jesuu. Ta cati ndico ra chi ñi ti: ―Sacahnu ndihi ñivi chi iin ra cahan cuenda ra Ndioo. Iin tuhun ni ñuun ra ta iin tuhun ni vehe ra ña sacahnu ñivi chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ña ni savaha ra Jesuu cha cahnu xaan tican, vati ña chinu ini ñivi can chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tichi quivi can ndaca ñahan ra Herode sehe ra Herode chahnu, ta ndaca ñahan ra chi ñivi iyo ñuhun Galilea. Chini soho ra tuhun cha ni savaha ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ta quechaha cati ra Herode can chi ñivi tindee chi ra ti: ―Racan cuu ra Juaan ra sacuanduta, ta cha ni natacu ndico ra nu iyo ñivi ndii. Chacan cuu cha savaha ra ndihi cha cahnu can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nu quichi quivi cha tiin ra Herode can chi ra Juaan, ta chuhni ra chi ra, ta tihi ra chi ra ve caa, vati tacan cuni ña Herodía ña cha ni cuu ñasihi ra Felipe yani ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tacan ni savaha ra, vati cha cati ra Juaan chi ra Herode can ti ña vaha cha quihin ra chi ña ñahan can, ta cuu ña ñasihi ra, cati ra Juaan can chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tacan cuu, ta cuni ra Herode cahni ra chi ra quivi can, soco yuhvi ra chi ndihi ñivi can, vati cati ñi ti iin ra cahan cuenda ra Ndioo cuu ra Juaan can. ");
INSERT INTO mioNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tacan cuu, ta sacahnu ra Herode vico, vati cha queta cuiya ra, ta chita chaha se sihi ña Herodía nu nducuiti ñivi can, ta sii xaan cuni ra Herode. ");
INSERT INTO mioNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chacan cuu cha ndurai xaan ra, ta cati ra ti cua cuhva ra ñaan cha cua ndaca maan ña. ");
INSERT INTO mioNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tacan cuu, ta ndaca ña cuhva cha cati sihi ña. Chacan cuu cha cati ñi chi ra ti: ―Vitin vitin cua cuhva cun xini ra Juaan ra sacuanduta tichi iin chicoho ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tacan cuu, ta quechaha ndundahvi cuni anima ra Herode can, soco cati cahnu xini ca ra ti cua cu cahni ra ta ra chi ra Juaan can, vati cha ni cahan rai ra nu iyo cuiti ndihi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tava tiñu ra chi ra ta ra, ta chahnda ra ta ra sucun ra Juaan can nu ndaa ra ve caa. ");
INSERT INTO mioNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tacan cuu, ta quichi ndaca ra ta ra xini ra Juaan tichi chicoho, ta chaha ra ta ra xini ra chi ña tivaa can, ta chaha ña chi chi chi sihi ña. ");
INSERT INTO mioNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tacan cuu, ta quihin ra tatun ra Juaan can iquin cuñu ra, ta cuchi ra ta ra chi ra. Tacan, ta cuahan ra ta ra, ta chaha ra cuenda chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Chini ra Jesuu tuhun cha ni chihi ra Juaan can, ta quee siin ra tican. Cuahan ra chi tundoo, ta cua queta ra nu ñahni ñivi. Nihin tuhun ndihi ñivi can nu cuahan ra, ta ndicu ñi chi ra. Ndihi ñuun can quee ñi, ta cuahan ñi. Chi chaha ñi cuahan ñi nu ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tacan cuu, ta cua quee ra tichi tundoo can nu ni queta ra, ta ndehe ra ti cha nducuiti tuvi ñivi. Quechaha satuñu chi chi ra, ta sanduvaha ra chi ñivi cuhvi can. ");
INSERT INTO mioNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cha cua ini, ta tuhva ra sacuaha chi ra Jesuu nu iyo ra, ta quechaha cati ra ta ra chi ra ti: ―Ñahni ñivi iyo yatin, ta cha cua cuaa. Na cua saña tahun chi ñivi ya, vati tacan cua cuhun ñi tichi ñuun, ta cua cu sata ñi cha cua cachi ñi ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Ña nini cha cua cuhun ñi. Cuhva maan ndo cha cua cachi ñi ―cati ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ta cati ra ta ra ti: ―Ñahni cha naan ndi tihya. Uhun tahan paan cuati chi uvi tahan tiaca cuu cha iyo ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ta cati ra Jesuu ti: ―Na cua quichi ndaca ndo chi chi nandehe ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tacan cuu, ta cati tuhun ra Jesuu ti cua cunda ñivi can nu ñuhun nu iyo ita cuii can, ta quihin ra uhun paan can chi nduvi tiaca can, ta ndehe ndaa ra iti siqui andivi, ta chaha ra iin tiahvi ndioo chi ra Ndioo, ta natahvi cuati ra paan can, ta chaha ra chi chi chi ra tatun ra, ta chaha maan ra ta ra chi chi chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Chachi ndihi ñi chi chi, ta ndaha ini ñi. Tacan cuu, ta canihin ra ta ra chehe paan cha ni ndoo. Queta uchi uvi tica chitu chehle canihin ndico ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Vasi queta uhun mil rai ni chachi paan can, ta siin cuu ñi ñahan chi ve cuati. ");
INSERT INTO mioNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tacan cuu, ta cati ra Jesuu ti cua quihvi ra tatun ra tichi tundoo, ta cua cuhun ra ta ra inga chiyo nduta can. Iti nuun ra cua cuhun ra ta ra, vati cua saña tahan xihna ra chi ñivi can, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tacan, ta saña tahan ra chi ñivi can, ta quee siin ra. Cuahan ra siqui yucu, vati cua cahan ra chi ra Ndioo. Cha cuaa cuu chi, ta ndoo iin tuhun maan ra ican. ");
INSERT INTO mioNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Cani vihi cha cuahan tundoo hora can, ta nihin suhva tahnu nduta nuun chi. Chitatun xaan ra ta ra cha sacunu ra chi tundoo can, vati ña chaha tati can cha cua yaha tundoo can iti nuun. ");
INSERT INTO mioNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ni nahan vihi, ta ña ta cundichin, ta tuhva ra Jesuu nu cuahan ra ta ra. Chica ra nu nduta, ta cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ndehe ra tatun Jesuu ti cha chica ra nu nduta can, ta quechaha cuyuhvi xaan ra ta ra, ta quechaha cati ra ta ra ti: ―Xiñahñu ndii vachi. Tacan ni cana chaa ra ta ra, vati yuhvi xaan cuni ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tacan cuu, ta quii xaan quechaha cati ra Jesuu chi ra ta ra ti: ―Na cua cundee ini ndo. Main cuu ra vachi. Ña cua cuyuhvi ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Cati ndico ra Pedro chi ra ti: ―Ra chahnu, tu yoho cuun, cua cati cun ti cua cuhin nu vachi cun nu nduta ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ta cati ra Jesuu chi ra ti: ―Nahan. Ta quee ra Pedro tichi tundoo can, ta nuun ra nu nduta. Cuahan ra nu nduta, ta tuhva ra nu vachi ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","soco ndehe ra cha nihin xaan caa tati, ta quechaha cuyuhvi ra. Tacan cuu, ta quechaha nanuun ra tichi nduta can, ta cana chaa ra. Cati ra ti: ―Na cua sacacu chihin yu, ra chahnu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tacan cuu, ta quii xaan tiin ra Jesuu chi ra Pedro can, ta cati ra chi ra ti: ―Ña chinu vaha ini cun. ¿Ñacu ña saxini vahun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Quihvi ra ta ra tichi tundoo can, ta chacava taxin ndico tati can, ");
INSERT INTO mioNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ta ndihi ra ta ra chahnu chiti ra iti nuun ra Jesuu, ta cati ra ta ra ti: ―Ndicha ndicha sehe Ndioo cuu cun ―cati ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tacan cuu, ta yaha ra ta ra inga chiyo nduta can, ta queta ra ta ra yu ñuhun nu cuu chi ñuhun Genesaret. ");
INSERT INTO mioNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nacoto ra iyo ican ta ra chi ra Jesuu, ta tachi ra ta ra tuhun niniin ñuhun can, ta quichi ndaca ñivi can chi ndihi ñivi cuhvi can nu iyo ra, ");
INSERT INTO mioNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ta cahan ndahvi ñi chi ra ti na cua sayani ndaha ñi―masi yu sahma ra, cati ñi. Tacan, ta nduvaha ndihi ñivi sayani ndaha sahma ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Quivi can quichi ra fariseo chi ra sacuaha ley chahnu. Iti ñuun Jerusalén quichi ra ta ra, ta yaha ra ta ra nuun ra Jesuu, ta quechaha nducu tuhun ra ta ra chi ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Ñacu ña sacuinu ñivi sacuaha chihun tuhun cha ni tiso ñivi yo tiempu chahnu? Ña sacuinu ñi, vati ña tuhva ñi nacata ñi ndaha ñi, ta cha cua cachi ñi ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ta cati ndico ra Jesuu chi ra ta ra ti: ―¿Ñacu sacuinu ndo tuhun cha ni tiso ñivi yo tiempu chahnu, ta ña sacuinu ndo tuhun cha cati tuhun ra Ndioo? ");
INSERT INTO mioNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Cha cati ra Ndioo ti cua sacahnu ndo chi sutu ndo chi sihi ndo, ta cati tahan ra ti tu cua cahan ndo ndavaha ni chi sutu ndo chi sihi ndo, na cua cuvi cuii ndo, cati ra Ndioo, ");
INSERT INTO mioNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","soco cati maan ndo ti cha cua cuu cati ndo chi sutu ndo chi sihi ndo ti ña cua tindee ndo chi ñi, vati chi ra Ndioo cha samani ndo ndihi cha cua tindee ndo chi ñivi ndo. Tacan cha sachiyo ndo cuhva cati tuhun ra Ndioo, vati sacuinu ndo cuhva cati ñivi tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ñivi uvi yaa cuu ndo. Ndicha cuhva ni cati ra Isaía cuenda ndo. Cahan ra cuenda ra Ndioo nu ni quichi quivi, vati cati ra Ndioo ti: ");
INSERT INTO mioNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Cati ñivi ya chi yuhu ñi ti sacahnu ñi chihin yu, soco ña ndicha cuhva cahan ñi. Ña sacahnu ñi chi anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ñahni yavi ndaa cha sacahnu ñi chihin yu, vati cati tuhun ñi cuhva saxini ñivi, cati ra Ndioo ni taa ra Isaía ―cati ra Jesuu chi ra fariseo can. ");
INSERT INTO mioNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tacan cuu, ta cana ra Jesuu chi ndihi ñivi can, ta quechaha cati ra chi ñi ti: ―Cua tasoho ndo, ta na cua cutuni ini ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ñavi cha cua quihvi tichi yuhu ñivi, ta cua cachi ñi cuu cha cua sacaquini anima ñi, soco cha cua quee tichi yuhu ñivi, cha cua saxini ñivi―chacan cuu cha cua sacaquini anima ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tacan cuu, ta tuhva ra sacuaha chi ra Jesuu nu iyo ra, ta nducu tuhun ra ta ra chi ra ti: ―¿Atu chito cun ti ña chaa ini ra fariseo can, ta chini ra tuhun can? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cua naan ihni ndihi tuhun, tu cha ña tiso ra suti iyo iti siqui andivi chi chi. ");
INSERT INTO mioNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Saña ndo chi ra. Cuaa ra, ta cuni ra cundaca ra chi ñivi cuaa. Tu cua cundaca iin ra cuaa chi tahan ra, nduvi tahan ra cua quehni cava tichi xahva. Tacan cati ra, vati cua ndoyo ñuhun cuii ñi cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ta cati ra Pedro chi ra ti: ―Cati maun ñaan tuhun cuu tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ta cati ndico ra Jesuu ti: ―¿Atu ña nituni tahan ini ndo? ");
INSERT INTO mioNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Chito ndo ti ndihi cha quihvi tichi yuhu ñivi chachi ñi, ta nuun chi tichi chiti yuva ñi, ta chati ñi chi chi, ");
INSERT INTO mioNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","soco cha cua quee tichi yuhu ñivi cuu cha saxini ñi chi anima ñi. Chacan cuu cha sacaquini chi ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","vati chi anima ñi saxini ñivi ndavaha ni ya. Chahni ñi tahan ñi. Cuni coo ñi ndavaha ni chi tahan ñi inga chiyo. Suhu ñi. Sandahyu ñahan ñi. Cahan ñi ndavaha ni chi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ndihi chacan cuu cha sacaquini anima ñivi, soco ña cua nducaquini anima ñivi, tu cua cachi ñi, ta ña ndoo ndaha ñi ―cati ra Jesuu chi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tican quee ra Jesuu, ta cuahan ra, ta queta ra ñuhun nu iyo ñuun Tiro chi ñuun Sidón. ");
INSERT INTO mioNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Iyo iin ñahan ñuhun can. Ñahan cananea cuu ña, ta quee ña, vati cua tuhva ña nu iyo ra Jesuu, ta quechaha cana chaa ña. Cati ña chi ra ti: ―Yoho ra chahnu, yoho ra cuu ñivi David, na cua cundahvi ini cun chihin yu. Iyo tati cuihna anima ña luhu sehi, ta iyo xaan ndacu run chi ña ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ta ñahni cha cati ndico ra chi ña. Tacan, ta tuhva ra sacuaha chi ra, ta cati ra ta ra chi ra ti: ―Na cua tasohun cha cahan ña, ta cua cuhun ña, vati ndicu ña chi yo, ta cana chaa xaan ña ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ta cati ra Jesuu chi ra ta ra ti: ―Tava tiñu suti chihin yu, vati cua tindei chi ñivi judío ni, vati iyo ñi cuhva iyo ri mbee cuanaan. Ña cati ra ti cua tindei chi ñivi cuu inga tucu ñivi ―cati ra chi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tacan, ta tuhva ña nu cahan ra, ta chahnu chiti ña iti nuun ra, ta cati ña chi ra ti: ―Na cua tindeun chihin yu ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ta cati ndico ra iin cuhva chi ña ti: ―Ña vaha cha cua quihin ndi cha cua cachi sehe ndi, ta cua savita ndi chi chi nu iyo ri ina ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ta cati ndico ña chi ra ti: ―Ndicha, ra chahnu, soco chachi tahan ri ina chehe xita quehni nu chachi chitoho ri ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tacan, ta cati ra Jesuu chi ña ti: ―Chinu vaha xaan ini cun, sihi. Na cua cuu chi cuhva cuni cun ―cati ra. Ta suvi ni hora can nduvaha sehe ña. ");
INSERT INTO mioNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tican quee ra Jesuu, ta cuahan ra. Queta ra tañuhun Galilea, ta ndaa ra iin siqui yucu, ta ni chacunda ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tacan, ta tuhva xaan ñivi nu iyo ra. Tuvi ñivi cuu ñi queta, ta ndaca ñi chi ñivi cojo chi ñivi nduñiin chi ñivi cuii nuun chi ñivi ñihin chi ñivi cuhvi chi ndihi nuun cuehe. Quichi ndaca ñivi chi ñican, ta nacoo ñi chi ñi iti nuun ra Jesuu, ta sanduvaha ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Chacan cuu cha iyo xaan cuni ndihi ñivi can, vati ndehe ñi ti cahan ñivi ñihin, ta nduvaha ñivi nduñiin, ta chica cuu ñivi cojo, ta ndichin vaha ndehe ñivi cuaa. Tacan, ta sacahnu tahan ñi chi ra Ndioo, ta suvi ra cuu ra sacahnu ñivi Israel. ");
INSERT INTO mioNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tacan cuu, ta cana ra Jesuu chi ra sacuaha chi ra, ta quechaha cati ra chi ra ta ra ti: ―Ndahvi cuni yu ndehi chi ñivi ya, vati cha queta uni quivi cha iyo ñi chihin yo, ta ñahni cha chachi ñi. Ña cuni yu saña tahin chi ñi vitin, ta chisoco ñi, coto ña cua cundee ñi iti ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ta cati ra sacuaha chi ra ti: ―Ñahni paan ihya tichi cuhu ya, ta cua sacachi yo chi ndihi ñivi ya ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ta nducu tuhun ra Jesuu chi ra ta ra ti: ―¿Yoso tahan paan iyo? Ta cati ndico ra ta ra chi ra Jesuu ti: ―Ucha tahan paan iyo chi uvi uni tahan tiaca ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ta cati ra Jesuu ti cua cunda ndihi ñivi nu ñuhun, ");
INSERT INTO mioNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ta quihin ra ndihi ucha tahan paan can chi ri tiaca can, ta chaha ra iin tiahvi ndioo chi ra Ndioo, ta natahvi ra chi chi, ta chaha ra chi chi chi ra sacuaha chi ra, ta chaha ra ta ra chi chi chi ndihi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tacan cuu, ta chachi ndihi ñi, ta ndaha ini ñi. Queta ucha ndoho chitu chehe paan can canihin ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ta chachi cumi mil rai, ta siin cuu ñi ñahan chi ve cuati chachi tahan. ");
INSERT INTO mioNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tacan cuu, ta saña tahan ra Jesuu chi ñi ta ñi, ta quihvi ra tichi tundoo, ta cuahan ra iti ñuhun nu iyo ñuun Magdala. ");
INSERT INTO mioNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tacan cuu, ta tuhva ra fariseo chi ra saduceo nu iyo ra Jesuu. Cuni ndehe ra ta ra a ña vaha cua savaha ra. Chacan cuu cha cati ra ta ra ti na cua sanahan ra iin cuhva cahnu iti siqui andivi chi ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ta cati ndico ra Jesuu chi ra ta ra ti: ―Hora cua cuiso nicandi cati ndo ti ña cua cuun savi vitin, vati cuaha cuaha iyo andivi, cati ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ta cha nahan cati ndo ti vitin cua cuun savi, vati cuaha cuaha iyo andivi, ta tava xaan ra savi vico, cati ndo. Ndehe ndo iti siqui andivi, ta nihin ndo cuhva yoso cuhva iyo ra savi, ta ndehe tahan ndo yoso cuhva iyo ndo quivi ya, soco ña cuu nihin ndo cuhva ñaan quivi cuu chi vitin. ");
INSERT INTO mioNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ñivi ndavaha ni cuu ndo. Ña cuni sacahnu ndicha ndo chi ra Ndioo, soco cuni ndehe ndo iin cuhva. Ñahni ca cuhva cua coo. Iin tuhun ni cuhva sava ta cua ni tahan ra Jonaa cua coo. Tacan cati ra Jesuu, vati uni quivi ni cua ndoo ra tichi ñuhun, ta sa cua natacu ndico ra. Tacan cuu, ta quee ra cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cuahan ndico ra sacuaha chi ra Jesuu inga chiyo tañuhun can, ta naan ini ra ta ra cunaan ra paan. ");
INSERT INTO mioNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tacan, ta quechaha cati ra Jesuu chi ra ta ra ti: ―Cua saha vaha ndo cuenda yoso cuhva iyo levadura ra fariseo chi ra saduceo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Saxini ra ta ra chi anima ra ñaan tuhun cuu chacan, ta ndatuhun ra chi tahan ra, ta cati ra ti: ―Ñahni paan iyo chi yo ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Chito ra Jesuu cha ndatuhun ra ta ra, ta quechaha cati ra chi ra ta ra ti: ―¿Ñacu cha ndatuhun ndo chi tahan ndo ti ñahni paan ndiso ndo? Ña ta cuinu vaha ini ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Vasi ña ta cutuni ini ndo. Vasi ña ñuhun ca ini ndo ti uhun paan cuu chi, ta chachi uhun mil ra rai. ¿Yoso tahan tica chi canihin ndo? ");
INSERT INTO mioNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Vasi ña ñuhun ca ini ndo ti ucha paan cuu chi, ta chachi cumi tahan mil ra rai can. ¿Yoso tahan ndoho chi canihin ndo? ");
INSERT INTO mioNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ñacu ña nihin ndo cuhva, vati ña cahin cuenda paan can? Cua saha ndo cuenda yoso cuhva iyo levadura ra fariseo chi ra saduceo ―cati ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tacan, ta nihin ra ta ra cuhva, vati ña cahan ra Jesuu cuenda levadura quihvi paan, soco cahan ra cuenda tuhun cha cati tuhun ra fariseo chi tuhun cati tuhun ra saduceo. ");
INSERT INTO mioNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tacan cuu, ta cuahan ra Jesuu chi ra sacuaha chi ra iti ñuhun nu iyo ñuun Cesarea cha iyo cuenda ra Felipe. Queta ra ta ra, ta quechaha nducu tuhun ra Jesuu chi ra ta ra ti: ―¿Yoso cati ñivi cuenda yuhu ra cuu sehe ñivi? ¿Yoo rai cui cuni ñi? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ta cati ndico ra ta ra ti: ―Iyo ñi cati ti Juaan ra sacuanduta cuun, ta iyo inga ñi cati ti ra Elía cuun, ta inga ndico tucu ñi cati ti ra Jeremía a inga ra cahan cuenda ra Ndioo cuu cun ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ta nducu tuhun ra chi ra ta ra ti: ―Ta ndioho, ¿yoo rai cui cati maan ndo? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ta cati ndico ra Simón Pedro ti: ―Ra Cristo ra cuu sehe Ndioo ndito cuu yoho ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ta cati ra Jesuu chi ra Pedro ti: ―Cua cusii ini cun, yoho Simón sehe Jonaa. Cua cusii ini cun, vati ñavi ñivi ñuñivi chaha cha chini tuni chihun. Ra suti iyo iti siqui andivi―racan cuu ra chaha cha chini tuni chihun. ");
INSERT INTO mioNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yuhu cati chihun ti Pedro nani cun. Chacan cuu cha yoho cuu sava ni ta cua iin yuu chaha vehe, vati maun cua tindee chi ñivi chinu ini chihin yu, ta ña cua cundee run ndacu ndavaha ni sandoyo ñuhun run chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Cua cuhve ndatu chihun cuenda cha cua cundaca ñahan ra cha iyo iti siqui andivi. Chacan cuu cha tu ña cua cuhva cun ndatu chi ñivi ñuñivi, ña cua coo ndatu chi ñi iti siqui andivi, ta tu cua cuhva cun ndatu chi ñi nu ñuhun ñuñivi ya, ta ni cuhva cua coo ndatu chi ñi iti siqui andivi ―cati ra Jesuu chi ra Pedro can. ");
INSERT INTO mioNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tacan cuu, ta cati cachin ra Jesuu chi ra sacuaha chi ra ti ña cua cuhva ra ta ra cuenda chi ni iin ñivi ti ra Cristo cuu ra, ta tava tiñu ra Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nda ni quivi can quechaha sanahan ra Jesucristo chi ra sacuaha chi ra ti nini xaan iyo cha cua cuhun ra iti ñuun Jerusalén, ta cua ndehe xaan ra tu ndoho cua savaha ra chanihin chi ra sutu chahnu chi ra sacuaha ley chahnu. Cua cahni ra ta ra chi ra, ta tichi uni quivi cua natacu ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Quee siin ra Pedro chi ra Jesuu, ta quechaha nduxaan ra Pedro chi ra, ta cati ra chi ra ti: ―Na cua cundahvi ini ra Ndioo chihun, ra chahnu, ta ña cua tahun tacan ―cati ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tacan, ta ndico coo ra Jesuu, ta quechaha cati ra chi ra Pedro ti: ―Casi yuhun, yoho Pedro, vati cahun cuhva cahan run Satanaa. Cuni cun cha cua savahi ndavaha ni, vati saxini cun cuhva saxini ñivi ñuñivi. Ña saxini cun cuhva saxini ra Ndioo ―cati ra Jesuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tacan cuu, ta cati ra Jesuu chi ra sacuaha chi ra ti: ―Tu cua cuni ndo coo ndo chihin yu, na ña cua saxini ca ndo cuenda suvi ni maan ndo, soco na cua ndehe ndo tu ndoho cuhva ndehe ñivi tu ndoho nu cruu, ta na cua cuhun ndo chihin yu icaa ni. ");
INSERT INTO mioNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tacan cati yu, vati tu cua cuni ndo coo vaha ndo cuenda ñuhun ñuñivi ya, cua ndoyo ñuhun ndo cuenda ra Ndioo, soco tu cua cuvi ndo cuenda yuhu, cua coo ndito ndo cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ñahni yavi ndaa yo cha cua coo vaha yo cuenda ñuhun ñuñivi, ta cua ndoyo ñuhun yo cuenda ra Ndioo. Ñahni cha cua savaha yo, ta cua coo vaha yo chi ra Ndioo, ");
INSERT INTO mioNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","vati ra cuu sehe ñivi cuu ra ni cua quichi chi ra tatun Ndioo icaa ni. Cahnu xaan cuhva cua quichi ra cuhva cahnu xaan iyo sutu ra. Quivi can cua cuhva ra chi ñivi cuhva cha ni savaha ñi quivi cha iyo ndito ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cati ndicha yu chihin ndo ti iyo uvi uni ndo inda ihya, ta ña cua cuvi ndo nda cua nda quivi cua ndehe ndo ti vachi ra cuu sehe ñivi, vati cua cundaca ñahan ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tacan cuu, ta yaha iñu quivi, ta quihin ra Jesuu chi ra Pedro chi ra Jacobo chi ra Juaan yani ra Jacobo can. Quee siin ra ta ra, ta chandaca ra Jesuu chi ra ta ra siqui iin yucu sucun sucun. ");
INSERT INTO mioNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tacan cuu, ta ndehe ra ta ra ti sama ra Ndioo cuhva cha iyo ra Jesuu. Ndundichin nuun ra cuhva ndichin ndehe ri nicandi, ta cuichin cuichin tuun sahma ra cuhva tuun ñuhun ndichin. ");
INSERT INTO mioNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tacan, ta sa ndehe tahan ra ta ra chi ra Moisee chi ra Elía, ta ndatuhun tahan ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tacan cuu, ta quechaha cati ra Pedro chi ra Jesuu ti: ―Ra chahnu, vaha xaan cha iyo tahan ndi ihya. Tu cua cuni cun, cua savahi uni tiahva ihya―iin chi maun, ta inga chi ra Moisee, ta inga chi ra Elía. ");
INSERT INTO mioNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ni vii cahan ra Pedro tuhun can, ta jihna cha chasi iin vico ndichin xaan nuun ra ta ra, ta nducahan ra Ndioo tichi vico can, ta cati ra ti: ―Sehi chi rahya. Cuni xain chi ra, ta cusii ini yu chihin ra. Na cua tasoho ndo cha cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nu chini ra ta ra tuhun cha cahan ndusu can, ta nduva ra ta ra nu ñuhun, vati yuhvi xaan yuhvi xaan cuni ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tacan cuu, ta tuhva ra Jesuu nuun caa ra ta ra, ta taa ra ndaha ra chi ra ta ra, ta cati ra ti: ―Cuinda ndo, ta ña cuyuhvi ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tacan, ta ndehe ndaa ra ta ra, soco yoni ca ñivi ndehe ra ta ra. Iin tuhun ni ra Jesuu ndehe ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tacan cuu, ta nuun ra ta ra nda siqui yucu can, ta cati tuhun xaan ra Jesuu chi ra ta ra ti: ―Vitin ña cua cahan ndo ni chi iin ñivi ñaan cha cuu cha ni ndehe ndo. Nda cua nda quivi cua natacu ndico ra cuu sehe ñivi nu iyo ñivi ndii, ta sa cua cuu cahan ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ta quechaha nducu tuhun ra ta ra chi ra ti: ―¿Ñacu cati ra sacuaha ley chahnu ti nini xaan cha cua quichi xihna ra Elía? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ta cati ndico ra Jesuu ti: ―Ndicha cuhva cati ra ti nini cha cua quichi ra Elía, ta cua tiso vaha ra ndihi tiñu, ");
INSERT INTO mioNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","soco yuhu cati chi ndo ti cha ni quichi ra Elía, ta ña ni nacoto ra ta ra chi ra. Savaha ra ta ra chi ra cuhva cuni ra ta ra. Ta ni cuhva cua savaha ra ta ra chi ra cuu sehe ñivi, ta cua ndehe ra tu ndoho ―cati ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tacan, ta sa nihin racan ta ra cuhva ti cuenda ra Juaan ra sacuanduta cahan ra Jesuu tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tacan cuu, ta queta ra Jesuu chi ra ta ra nu iyo cuiti ñivi can, ta tuhva iin rai iti nuun ra Jesuu, ta chahnu chiti ra nuun ra, ");
INSERT INTO mioNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ta quechaha cati ra chi ra Jesuu ti: ―Ra chahnu, na cua cundahvi ini cun chi ra luhu sehi, vati chahni rai chi chi ra, ta iyo xaan ra chi tu ndoho, vati nunuun ni nduva ra nu cayu ñuhun, ta quehni ra tichi nduta. ");
INSERT INTO mioNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Cha quichi ndaque chi ra iti nuun ra sacuaha chihun, soco ña ni cuu sanduvaha ra ta ra chi ra ―cati ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ta cati ndico ra Jesuu chi ra ti: ―Ndihi ndioho―ñivi ndacu ndavaha ni cuu ndo. Ña cuni ndo cuinu ini ndo. ¿Yoso quivi cua coi chihin ndo? ¿Yoso quivi cua sandee ini yu chihin yu? Na ndaca ndo chi ra ihya. ");
INSERT INTO mioNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tacan, ta nduxaan ra Jesuu chi run tati cuihna can, ta quee run tichi anima ra luhu can, ta nduvaha ra suvi ni hora can. ");
INSERT INTO mioNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tacan cuu, ta quee siin ra sacuaha chi ra Jesuu, ta nducu tuhun ra ta ra chi ra ti: ―¿Ñacu ña cuu tava ndaa ndi chi run tati cuihna can? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ta cati ndico ra chi ra ta ra ti: ―Ña ni cuu tava ndaa ndo chi run, vati ña ta cuinu vaha ini ndo. Cati ndicha yu chihin ndo ti tu cua cuinu ini ndo chi ra Ndioo―masi suhva, cua cuu savaha ndo ndihi cha cuni ndo. Cua cuu cati ndo chi yucu cahnu ya ti cua cuachiyo chi tihya, ta cua cuhun chi tican. ");
INSERT INTO mioNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ña cua cuu tava ndaa ndo chi tati cuihna can, tu ña cua cahan xihna ndo chi ra Ndioo, ta cua coo ndita ndo cuenda ra ―cati ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tacan cuu, ta nducuiti tucu ra Jesuu chi ra sacuaha chi ra iti ñuhun Galilea, ta quechaha cati ra Jesuu chi ra ta ra ti: ―Cua xico tuhun ñivi chi ra cuu sehe ñivi, ta cua tiin ñi chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ta cua cahni ñi chi ra, ta tichi uni quivi cua natacu ndico ra ―cati ra, ta cuihya xaan cuni anima ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tacan cuu, ta cuahan ra Jesuu chi ra sacuaha chi ra iti ñuun Capernaum, ta cha satahan ra satiahvi xuhun ve ñuhun chi ra ta ra, ta tuhva ra nu iyo ra Pedro, ta quechaha nducu tuhun ra chi ra ti: ―¿Atu ña tiahvi tahan ra sacuaha chi ndo xuhun ve ñuhun? ―cati ra chi ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ta cati ndico ra Pedro chi ra ti: ―Tiahvi tahan ra ―cati ra. Tacan cuu, ta quihvi tahan ra Pedro tichi vehe can, ta cahan xihna ra Jesuu chi ra. Nducu tuhun ra chi ra ti: ―¿Yoso saxini maun, yoho Simón? ¿Yochi satiahvi ra ndaca ñahan chi ñivi ñuñivi? ¿Atu quihin ra xuhun ñi cuu ñivi maan ra a xuhun inga ñivi quihin ra? ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ta cati ndico ra Pedro ti: ―Xuhun inga ñivi ni quihin ra. Ta cati ra Jesuu chi ra ti: ―Tu chacan cuu chi, ñahni cha cua tiahvi ñivi ra ndaca ñahan can. ");
INSERT INTO mioNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ndicha, soco cua cuhun xihna cun yu tañuhun, ta cua cani cun caa chicu yuhu ri tiaca. Tacan, ta cua nihun chi ri, ta cua quihun chi ri cua tiin xihna cun, ta cua ndica cun yuhu ri, ta cua nihun iin xuhun. Cua quihun xuhun can, ta cua cuhva cun chi chi chi ra satiahvi xuhun cuenda ve ñuhun, ta cua queta chi cuenda yuhu ta cuenda yoho. Tacan cua savahun, coto cua saxini ra ta ra cha ña cua tiahvi yo ―cati ra Jesuu chi ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Suvi ni hora can yaha ndihi ra sacuaha chi ra Jesuu iti nuun ra, ta quechaha nducu tuhun ra ta ra chi ra ti: ―¿Ndaa ñivi cua cuu ñivi cahnu ca quivi cua cundaca ñahan ra iyo iti siqui andivi? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ta cana ra Jesuu chi iin ve luhu, ta sacuinda ra chi ve mahñu nu iyo ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ta quechaha cati ra chi ra ta ra ti: ―Cati ndicha yu chihin ndo ti tu ña cua sama ndo cuhva saxini ndo, tu ña cua cuu ndo cuhva iyo ve cuati, ña cua cuu coo ndo nu cua cundaca ñahan ra iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chacan cuu cha tu ña cua coo masu ini ndo cuhva iyo masu ini ve luhu ya, ña cua cuu ndo rai cahnu nu cua cundaca ñahan ra iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tu cua quihin cuenda ñivi chi ñivi iyo cuhva iyo ve luhu ya cuenda yuhu, iyo tahan ñi chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Tu cua satiyuhu ñivi ndavaha ni chi iin ñivi chinu ini chihin yu―masi ñivi luhu cuu ñi, tu tacan cua satiyuhu ñivi ndavaha ni can, vaha ca cha cua cunuhni iin yoso sucun ñi, ta cua quehni cava ñi tichi tañuhun, ta cua cuvi ñi, ta ñavi ca cha iyo ñi savaha ñi ndavaha ni can. ");
INSERT INTO mioNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Cua coo tu cuihya ini chi ñivi ñuñivi, vati cua savaha ñi cuati. Iyo cha cua savaha ñivi cuati, vati tacan iyo ñi, soco cua coo tu cuihya ini chi ñi satiyuhu chi inga ñivi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Tu cua savaha ndo cuati chi ndaha ndo, tu cua savaha ndo cuati chi chaha ndo, na cua sanini ndo chihin ndo, ta ña cua savaha ca ndo cuati can. Vaha ca cha cua coo ndito ndo chi ra Ndioo, vati sandee ini ndo chi ndaha ndo chi chaha ndo. Ña vaha tu cua savaha ndo cuati chi ndaha ndo, tu cua savaha ndo cuati chi chaha ndo, ta cua cutuni ndo, ta cua cayu ndo nu ñuhun ña ndahva. ");
INSERT INTO mioNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tu cua savaha ndo cuati chi titi nuun ndo, na cua sanini ndo chihin ndo, ta ña cua savaha ndo cuati can. Vaha ca cha cua coo ndito ndo chi ra Ndioo, vati sandee ini ndo chi titi nuun ndo. Ña vaha tu cua savaha ndo cuati chi titi nuun ndo, ta cua quehni cava ndo nu cua cutuni ndo nu cayu ñuhun xaan. Tacan cati ra Jesuu, vati nini xaan cha cua saha ñi cuenda chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Cua saha ndo cuenda, coto ña cua chaa ini ndo chi iin ñivi yu cha cuu sava ta cua ve luhu ya, ");
INSERT INTO mioNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","vati quichi ra cuu sehe ñivi, vati cua sacacu ra chi ñivi ndoyo ñuhun. Cati yu chihin ndo ti ndihi ni hora iyo ra tatun Ndioo cumi chi ñi iti nuun ra suti cha iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Cua cati ndo yoso saxini ndo. Iyo iin rai, ta iyo iin ciendu mbee ra, ta cuanaan iin ri. Cua nacoo ra chi ndihi ca ri tichi cuhu, ta cua nanducu ra chi ri cuanaan. ");
INSERT INTO mioNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tu cua nanihin ra chi ri, cati ndicha yu chihin ndo ti cua cusii ini ra, vati ni nanihin ra chi ri. Ña cua saxini ra cuenda ndihi ca cumi xico chahun cumi ri, vati ñahni cha ni tahan rican. ");
INSERT INTO mioNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ta ni cuhva ña cuni ra sutu ndo cha iyo iti siqui andivi cha cua ndoyo ñuhun ni iin ñivi ra cha cuu sava ta cua ve luhu ya. ");
INSERT INTO mioNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Tu cua savaha iin ñivi tahan ndo cuati, cuahan ndo vehe ñi. Cua quee siin ndo iin chiyo, ta cua cati cachin ndo chi ñi ñaan cha cuu cuati ni savaha ñi. Tu cua taa ñi soho ñi cha cahan ndo, cua ndumani ndico ñi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tu ña cua tasoho ñi, na cua cundaca ndo inga uvi uni tahan ndo vehe ñi, vati tacan cua cuu ñi testigu, ta cua cuu cuhva tahan ñi cuenda ñaan cha cuu cha savaha ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tu ña cua tasoho ñi chi ñi ta ñi, cua cuhva ndo cuenda chi ndihi ñivi Ndioo nu nducuiti ñi. Tu ña cua tasoho ñi chi ñivi Ndioo tahan ñi, na cua cuu ñi sava ta cua run ña chinu ini chi ra Ndioo chi run satiahvi, vati ña cua ndoo ca ñi cuenda maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Cati ndicha yu chihin ndo ti ndihi cha cua cati ndo ihya nu ñuhun ñuñivi ya―cua ndoo chi cuhva can iti siqui andivi. Tu cua cuhva ndo, tu ña cua cuhva ndo, cuhva can cua ndoo chi iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Cati ndicha yu chihin ndo ti tu cua nduinuun uvi ndo ihya nu ñuhun ñuñivi ya, ta cua ndaca ndo chacan chi ra suti cha iyo iti siqui andivi, cua cuhva ra chi chi chihin ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","vati nu iyo cuiti uvi uni ñivi cuenda yu―ican iyo tahin chi ñi ―cati ra Jesuu chi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tacan, ta tuhva ra Pedro nuun iyo ra Jesuu, ta quechaha nducu tuhun ra chi ra ti: ―Ra chahnu, ¿yoso tahan chaha cua cucahnu ini yu cuati savaha ñivi tahin chihin yu? ¿Atu cua cucahnu ini yu nda cua nda ucha chaha? ―cati ra Pedro can. ");
INSERT INTO mioNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ta cati ndico ra Jesuu chi ra ti: ―Ña cati yu nda cua nda 7 chaha. Cati yu nda cua nda 77 chaha ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ni vii cahan ra Jesuu chi ra Pedro: ’Nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ni ta cua iin rai cuu cumi tiñu. Cuni ra tiso vaha ra cuenda chi musu ra. ");
INSERT INTO mioNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tacan cuu, ta quichi iin ra musu ra, ta ndiseca ra uchi mil chi ra ndaca ñahan chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ña cuu tiahvi ra musu can, ta cati chitoho ra ti cua xico ra ta ra chi racan chi ñasihi ra chi sehe ra chi ndihi cuii ndatiñu ra, vati ña cuu tiahvi ra cha ndiseca ra chi chitoho ra. Tacan, ta cua nihin ra suhva xuhun ra. ");
INSERT INTO mioNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chacan cuu cha chahnu chiti ra musu can iti nuun chitoho ra, ta cahan ndahvi ra chi ra, ta cati ra ti: “Na cua cundee ini cun chi main, ta cua tiahvi ndico yu ndihi cha ndiseque chihun,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tacan cuu, ta cundahvi ini chitoho ra chi ra, ta saña ra chi ra, ta sanaan ra ndihi cha ndiseca ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Quee ra musu can, ta cuahan ra, ta nitahan ra inga tahan ra. Suvi ni musu cuu ra, ta ndiseca tahan ra iin ciendu chi run ndiseca uchi mil. Tiin rucan sucun ra ndahvi can, ta natiin nihin run chi ra, ta cati run chi ra ti: “Vitin cua tiahvi ndico cun cha ndiseca cun chihin yu,” cati run. ");
INSERT INTO mioNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tacan, ta chahnu chiti tahan ra iti nuun run, ta cahan ndahvi ra chi run. Cati ra ti: “Na cua cundee ini cun chihin yu, ta cua tiahvi ndique cha ndiseque chihun,” cati ra chi run, ");
INSERT INTO mioNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","soco ña vaha cuni run cha tacan, ta tiin run chi ra, ta tihi run chi ra ve caa, vati tican cua ndoo ra nda cua nda quivi cua tiahvi ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tacan, ta quechaha ndundahvi xaan cuni ndihi ca ra musu ta ra, ta cuahan ra ta ra iti nuun ra chitoho ra ta ra, ta chaha ra ta ra cuenda ndihi cha ni savaha run cuu tahan ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tacan cuu, ta cana ndico ra chitoho can chi run, ta quechaha cati ra chi run ti: “Musu ndavaha ni cuun. Cha sanain ndihi cha ni ndiseca cun chihin yu, vati cahan ndahvi cun chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Chacan cuu cha nini xaan cha cua cundahvi ini cun chi musu tahun cuhva cha ni cundahvi ini yu chihun,” cati chitoho run chi run. ");
INSERT INTO mioNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Xaan xaan cuni ra chitoho can, ta chandaca ra chi run ve caa, vati ve caa iyo chi run nda cua nda quivi cua tiahvi ndico run ndihi cha ni ndiseca run chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ta ni cuhva cua savaha ra suti iyo iti siqui andivi chihin ndo, tu ña cua cucahnu ini maan ndo chi ñivi tahan ndo chi ndihi cuii anima ndo ―cati ra Jesuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tacan, ta ndihi cahan ra Jesuu tuhun can, ta quee ra ñuhun Galilea can, ta cuahan ra iti ñuhun Judea. Inga chiyo yuta Jordán cuahan ra, ");
INSERT INTO mioNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ta tuvi ñivi ndicu chi ra. Tican sanduvaha ra chi ñi ta ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tacan cuu, ta yaha ra fariseo ta ra iti nuun ra, vati cuni ndehe ra ta ra a ña cua cahan ra Jesuu iin tuhun ña vaha, ta nducu tuhun ra ta ra chi ra ti: ―¿Atu chaha ley chahnu cha cua saña iin rai chi ñasihi ra yoso cuu ni? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Vasi ña ta sacuaha ndo tutu Ndioo, vati cati chi ti savaha ra Ndioo cha ni chacoo iin rai chi iin ñahan nda ni xihna cuii, ");
INSERT INTO mioNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ta cati ndico tucu chi ti chacan cuu cha nacoo iin rai chi sutu ra chi sihi ra, ta natahan ra chi ña cuu ñasihi ra, ta inuun cua coo ñi, vati cuu ñi uvi tahan, cati chi. ");
INSERT INTO mioNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chacan cuu cha cuu ñi sava ta cua iin ñivi. Chacan cuu cha na ña cua quenda tahan ñivi chi ñi cuu uvi tahan, vati ra Ndioo cuu ra cha ni satahan chi ñi ―cati ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ta nducu tuhun ra ta ra chi ra Jesuu ti: ―Tu tacan cuu chi, ¿ñacu cati tuhun ra Moisee ti cua ndoyo iin tutu cha cua saña iin rai chi ñasihi ra, ta sa cua cuu saña ra chi ña? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Chaha ra Moisee cha cua saña ndo ñasihi ndo, vati ndava xaan ini ndo, soco ñavi tacan ni chacoo chi nda ni xihna. ");
INSERT INTO mioNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Cati yu chihin ndo ti tu cua saña ndo ñasihi ndo, ta ña ni chacoo ña ndavaha ni chi ra rai inga chiyo, ta tu cua quihin ndo inga ñahan, cua cuu chi cuhva ni cua coo ndo ndavaha ni chi ñahan inga chiyo cuenda ra Ndioo ―cati ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ta cati ra sacuaha chi ra ti: ―Tu tacan iyo iin rai chi ñasihi ra, vaha ca cha ña cua quihin ra chi ña ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ta cati ndico ra chi ra ta ra ti: ―Ña ndihi rai cua ndoo vaha cha tacan. Iyo suhva ra cua cuu ndoo vaha cuhva ni tiso ra Ndioo, ");
INSERT INTO mioNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","vati iyo ra rai ña cua tandaha ra, vati nda ni quivi cacu ra ña vaha caa ra. Iyo inga ra ña cua tandaha ra, vati cha nducapu ra cha cuenda tiñu satiñu ra, ta iyo tahan inga ra ña cua tandaha ra, vati ña cuni ra, vati cua satiñu ra tiñu cuenda nu cua cundaca ñahan ra iyo iti siqui andivi. Tu cua cuu ndoo ndo vaha cha tacan, na cua ndoo ndo vaha ―cati ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tacan cuu, ta quichi ndaca ñivi chi ve cuati, vati cua tiso ra Jesuu ndaha ra chi ve, ta cua cahan ra chi ra Ndioo cuenda ve, soco nduxaan ra sacuaha chi ra chi ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ta quechaha cati ra Jesuu ti: ―Cuhva ndo cha cua yaha ve cuati iti nuin. Ña cua casi ndo nuun ñi, vati ñivi cua coo nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ta cua ve cuati can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tacan cuu, ta taa ra ndaha ra chi ve, ta quee ra cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tacan cuu, ta tuhva iin ra nu iyo ra Jesuu, ta quechaha nducu tuhun ra chi ra ti: ―Yoho maestru, ¿ñaan cha vaha cua savahi, ta cua coo ndito yu chi ra Ndioo ndihi ni quivi ndihi ni tiempu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ta cati ndico ra Jesuu chi ra ti: ―Ña vaha cha nducu tuhun cun chihin yu yoso cuhva iyo cha vaha. Iin tuhun ni ra cuu ra ndacu cha vaha. Tu cua cuni cun coo ndito cun chi ra Ndioo, cua sacuinu cun cuhva cati tuhun ra nu quichi quivi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ta nducu tuhun ndico ra chi ra Jesuu ti: ―¿Ñaan tuhun cuu chacan? ―cati ra. Ta cati ra Jesuu ti: ―Tuhun ya cuu chi. Ña cua cahni ndo tahan ndo. Ña cua coo ndo ndavaha ni chi tahan ndo inga chiyo. Ña cua suhu ndo. Ña cua sandahyu ñahan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Cua sacahnu ndo chi sutu ndo chi sihi ndo. Cua cuni ndo chi ñivi tahan ndo cuhva cuni ndo suvi ni chi maan ndo ―cati ra Jesuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ta cati ndico ra tivaa can chi ra ti: ―Ndihi chacan cha sacuinu yu. ¿Ñaan ca cha cumani chihin yu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ta cati ndico ra Jesuu chi ra ti: ―Tu cua cuni cun quee vahun, cuahan, ta xico cun ndatiñu cun, ta tindeun chi ñivi ndahvi, ta cua coo cha vaha chihun iti siqui andivi. Tacan, ta nahan. Na cua coun chihin yu icaa ni ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nu ni chini ra tivaa can tuhun can, ta quee ra cuahan ra. Ndahvi cuni ra, vati iyo xaan ndatiñu ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tacan cuu, ta quechaha cati ra Jesuu chi ra sacuaha chi ra ti: ―Cati ndicha yu chihin ndo ti ii xaan cha cua coo ñivi ricu nu cua cundaca ñahan ra iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Cati ndico tucu yu chihin ndo ti ña cuu yaha ri camellu yavi xuu quiticu, soco ii ca cha cua yaha ñivi ricu nu cua cundaca ñahan ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chini ra sacuaha chi ra Jesuu tuhun can, ta sa quechaha nduiyo xaan cuni ra, ta nducu tuhun ra ta ra ti: ―Tu chacan cuu chi, yoni cua cacu ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ndehe ra Jesuu nuun ra ta ra, ta quechaha cati ra chi ra ta ra ti: ―Ña cuu cuenda ñivi ñuñivi, soco cuenda ra Ndioo cuu cacu ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tacan cuu, ta cati ndico ra Pedro ti: ―Cha ni nacoo maan ndi ndihi cha ni chacoo chi ndi, ta cha chica ndi chihun icaa ni. ¿Ñaan cha cuu cha cua coo chi maan ndi? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cati ndicha yu chihin ndo ti quivi cua nduchaa ñuhun ñuñivi ya, quivi cua tachi tuni ra cuu sehe ñivi chi ñivi ñuñivi―quivi can cua coo ndatu chi ndo, ta cua tachi tuni tahan ndo chi ndihi ñivi Israel, vati cha iyo ndo chihin yu icaa ni. ");
INSERT INTO mioNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta ndihi ca ñivi―tu cua nacoo ñi vehe ñi chi tahan ñi chi sutu ñi chi sihi ñi chi sehe ñi chi ndatiñu ñi cha cuenda yuhu, cuaha ca cua cunda yahvi ñi, ta cua coo ndito ñi chi ra Ndioo ndihi ni quivi ndihi ni tiempu. ");
INSERT INTO mioNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tuvi ñivi iyo iti nuun cua ndoo ihni iti chata, ta ñivi iyo iti chata cua yaha iti nuun. ");
INSERT INTO mioNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ni ta cua iin rai cha iyo xaan yoho chiti uva. Nahan xaan quee ra cuahan ra, ta nanducu ra chi ra cua satiñu nu iyo yoho chiti chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nduinuun ra chi ra ta ra, vati cua satiñu ra ta ra, ta cua cuhva ra cha sacanaan ra ta ra cha iin quivi. Tacan, ta tava tiñu ra chi ra ta ra nu iyo tiñu ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tacan cuu, ta quee tucu ra chitoho can caa iin cha nahan, ta ndehe ra ti iyo inga ra inda nuyahvi, ta ñahni tiñu iyo chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ta quechaha cati ra chi ra ta ra ti: “Na cua cuhun tahan ndo satiñu ndo nu iyo chiti yoho can, ta cua tiahvi yu ñaan cha cuu cha vaha,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ta cuahan ra ta ra. Tacan cuu, ta ta ni cuhva savaha ndico tucu ra cha hora cuiti chi cha caa uni. ");
INSERT INTO mioNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Caa uhun cha cua ini xaan quee ndico tucu ra chitoho chiti yoho can, ta ndehe ra ti ni inda inga ra ta ra, ta quechaha cati ra chi ra ta ra ti: “¿Ñacu inda ndo nduvi nduvi, ta ña satiñu ndo?” ");
INSERT INTO mioNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ta cati ndico ra ta ra chi ra ti: “Inda ndi, vati yoni tava tiñu chi ndi,” ta cati ra chi ra ta ra ti: “Cuahan ndo nu iyo chiqui yu, vati cua satiñu tahan ndo,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tacan cuu, ta cua cuiso nicandi, ta cati ra chitoho can chi ra musu cuu xini ti: “Cua cana cun chi ra satiñu ya, ta cua tiahvi cun chi ra ta ra. Cua quechaha tiahvi cun chi ra queta nu ndihi, ta cua tiahvi cun chi ra ta ra nda cua nda cua sandihun tiahvi cun chi ra queta cha nahan,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tacan, ta quichi ra ni quechaha satiñu hora cua cuiso nicandi, ta nihin iin iin ra yahvi ra cuhva yahvi ra satiñu nduvi nduvi. ");
INSERT INTO mioNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chacan cuu cha quichi tahan ra ni quechaha satiñu cha nahan, ta saxini ra ta ra ti cuaha ca cua nihin ra ta ra, soco nihin tahan iin iin ra ta ra cuhva can. ");
INSERT INTO mioNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Quihin ra ta ra yahvi ra, soco quechaha ña vaha cuni ra ta ra, ta cahan ra ta ra siqui ra chitoho can, ");
INSERT INTO mioNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ta cati ra ta ra ti: “Ra quichi chuhva ta ra―satiñu ra ta ra iin hora ni, ta cuhva tiahvi cun chi ra tiahvi tahun chi ndi, ta maan ndi―satiñu ndi nduvi nduvi, ta ihni xaan cuu,” cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ta cati ndico ra chitoho can chi iin ra ti: “Yani, ñahni ndavaha ni ndacu i chihun, vati maun cati ti cua satiñu tahun cuhva can. ");
INSERT INTO mioNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Quihin xuhun cun, ta cuahan. Cha iyo ini yu tiahvi yu chi racan cuhva tiahvi yu chi maun. ");
INSERT INTO mioNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Cuu savahi cuhva cuni yu chi xuhin. Cha ndusoo ndo, vati cha vaha savahi.” ");
INSERT INTO mioNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Chacan cuu cha cua nduinuun ndihi ñivi. Cua nduinuun ñivi queta iti chata chi ñivi queta iti nuun, ta cua nduinuun tahan ñivi queta iti nuun chi ñivi queta iti chata ―cati ra Jesuu chi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tacan cuu, ta cha cuahan ra Jesuu iti ñuun Jerusalén, ta quee siin ra chi ra sacuaha chi ra iti can, ta quechaha cati ra chi ra ta ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Vitin cuahan yo iti ñuun Jerusalén, ta cua tiin tiñu chi ra cuu sehe ñivi. Cua tiin ra sutu chahnu chi ra sacuaha ley chahnu chi ra, ta cua cati ra ta ra ti cua cuvi ra cuu sehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Cua sayaha ra ta ra chi ra nuun ra quichi inga ñuhun, vati cua sacateni racan ta ra chi ra, ta cua cani ra ta ra chi ra, ta cua taa ra ta ra chi ra nu cruu. Tacan cua cahni ra ta ra chi ra, ta tichi uni quivi cua natacu ndico ra ―cati ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tacan cuu, ta tuhva sihi ra Jacobo chi ra Juaan nuun ra Jesuu. Tuhva ña chi sehe ña, ta chahnu chiti ña iti nuun ra, ta cati ña ti iyo iin cha cua ndaca ña chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ta nducu tuhun ra chi ña ti: ―¿Ñaan cha cuu cha cuni cun? ―cati ra. Ta cati ndico ña chi ra ti: ―Na cua cati cun ti cua cunda tahan nduvi sehi chihun nu cua cundaca ñahan cun. Na cua cunda iin ra chiyo ndaha cuaha cun ta inga ra chiyo ndaha satin cun ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ta cati ra Jesuu chi ñi ti: ―Ña chito ndo ñaan cha cuu cha ndaca ndo. ¿Atu cua cuu coho ndo copa cua coho yu? ―cati ra chi ñi, soco cuenda tu ndoho cua ndehe ra cahan ra tuhun can. Ta cati ndico ñi ti: ―Cuu. ");
INSERT INTO mioNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ta cati ra chi ñi ti: ―Cua coho ndo copa cua coho yu, soco ñahni ndatu iyo chihin yu cha cua cuhve cha cua cunda ndo iin chiyo xiin yu inga chiyo xiin yu. Maan ra suti cua cati yoo cua nihin chacan ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tacan, ta sa ni chini soho inga uchi ra sacuaha chi ra Jesuu, ta xaan xaan quechaha cuni ra ndehe ra ta ra chi racan ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Cana ra Jesuu chi ndihi ra ta ra, ta cati ra chi ra ta ra ti: ―Chito ndo yoso cuhva ndaca ñahan ñivi ñuñivi chi tahan ñi, vati ndurai xaan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ñavi tacan cua savaha maan ndo. Tu ndaa ndo cuni cuu ndo iin ñivi cahnu, na cua tindee ndo chi tahan ndo sava ta cua iin musu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tu cua cuni ndo yaha ndo iti nuun, ta cua tahan chi cuu ndo xini, na cua tindee ndo chi tahan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Cuhva can quichi ra cuu sehe ñivi. Ña nducu ra cha cua tindee ñivi chi maan ra, soco tindee ra chi ñivi, ta cua cuvi ra cuenda cuati ñivi ñuñivi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tacan cuu, ta cha cua quee ra Jesuu ta ra ñuun Jericó, ta tuvi ñivi ndicu chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ta ndaa uvi tahan ra cuii nuun yu iti can. Chini ra ta ra tuhun cha yaha ra Jesuu, ta sa quechaha cana chaa ra ta ra. Cati ra ta ra chi ra Jesuu ti: ―Yoho ra chahnu, na cua cundahvi ini cun chihin ndi, yoho ra cuu ñivi David ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nduxaan ñivi can chi ra ta ra, vati na cutaxin ra ta ra, soco nihin ca cana chaa ra ta ra, ta cati ndico ra ti: ―Yoho ra chahnu, na cua cundahvi ini cun chihin ndi, yoho ra cuu ñivi David ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tacan, ta ni chacuiñi ra Jesuu, ta cana chaa ra chi ra ta ra, ta nducu tuhun ra ti: ―¿Ñaan cha cuu cha cuni ndo cha cua savahi chi ndo? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ta cati ndico ra ta ra ti: ―Ra chahnu, na cua ndundichin vaha ndehe ndi ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ta quechaha ndundahvi cuni anima ra Jesuu, ta taa ra ndaha ra nuun ra ta ra, ta suvi ni hora can ndundichin vaha ndehe ra ta ra, ta ndicu ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yatin cua queta ra Jesuu ta ra ñuun Jerusalén. Chacan cuu cha queta xihna ra ta ra ñuun Betfagé, ta yatin yucu Olivo caa ñuun can. Tacan, ta tava tiñu ra Jesuu chi uvi ra sacuaha chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ta cati ra chi ra ta ra ti: ―Cuahan ndo tichi ñuun tican iti nuun ndo. Sa cua quihvi ndo ñuun can, ta cha cua ndehe ndo cha nuhni iin buru, ta iyo sehe ri chi ri. Cua ndachi ndo chi ri, ta cua quichi ndaca ndo chi ri. ");
INSERT INTO mioNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tu cua cahan ñivi chi ndo, cua cati ndo ti chini ñuhun ra chahnu chi ri, ta ña cua nducuee, ta cua tachi ndico ra chi ri ―cati ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tacan ni savaha ra, ta cha quichi quee tuhun cha ni cati ra ni cahan cuenda ra Ndioo tiempu chahnu, vati cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Cua cati ndo chi ñivi ñuun Jerusalén ti cha vachi ra ndaca ñahan chi ñi. Vii ni vachi ra, ta yoso ra iin buru. Yoso ra chi ri chiso carga, cua cati ndo, cati ra cahan cuenda ra Ndioo can. ");
INSERT INTO mioNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tacan cuu, ta cuahan uvi ra sacuaha chi ra, ta savaha ra ta ra cuhva ni cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Quichi ndaca ra ta ra chi ri buru can chi sehe ri, ta tiso ra ta ra sahma ra ta ra chata ri, ta yoso ra Jesuu chi ri. ");
INSERT INTO mioNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tacan cuu, ta tuvi ñivi nducuiti, ta chaqui ñi sahma ñi iti nu cua yaha ra, ta inga ñi chahnda ndaha numa, ta chaqui tahan ñi chi chi iti nu cua yaha ra, vati tacan ni sacahnu ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Cuahan ñi iti nuun ra, ta ndicu ñi iti chata ra, ta cana chaa ñi ta ñi. Cati ñi ti: ―¡Cahnu xaan rai cuu ra cuu ñivi David! ¡Na cua coo vaha ra vachi cuenda ra chahnu! ¡Na cua sacahnu tahan ndihi tatun Ndioo iyo iti siqui andivi chi ra! ―cati ñi ta ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tacan, ta quihvi ra ñuun Jerusalén can, ta jihna cha ña chito ca ndihi ñivi ñuun can yoso savaha ñi cha nduiyo ñi chi ra, ta quechaha nducu tuhun ñi chi tahan ñi ti: ―¿Yoo rai cuu rahya? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ta cati ndico ñivi can ti: ―Ra Jesuu cuu ra, ta vachi ra iti ñuun Nazaret cha iyo cuenda ñuhun Galilea. Ra cahan cuenda ra Ndioo cuu ra ―cati ñi ta ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tacan cuu, ta quihvi ra Jesuu tichi cora soco ndavi ve ñuhun cahnu can, ta tava ndaa ra ndihi ñi sata chi ndihi ñi xico tican. Sanduva ra mesa ñivi sama xuhun, ta sanduva tahan ra tayu ñivi xico chi ri ndivi, ");
INSERT INTO mioNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ta cati ra chi ñi ta ñi ti: ―Cha cati tutu Ndioo ti vehe ra Ndioo cuu iin vehe nu cua cahan ñivi chi ra, cati chi, soco cha ni savaha maan ndo cha cuu chi iin vehe nu nducuiti run ñasuhu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tacan cuu, ta tuhva ñivi cuaa, tuhva ñivi coho nu iyo ra Jesuu tichi cora soco ndavi ve ñuhun can, ta sanduvaha ra chi ñi ta ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ndehe ra sutu chahnu can chi ra sacuaha ley chahnu ti cha cahnu xaan ni savaha ra Jesuu, ta cha cana chaa tahan ñi cuati cha iyo ve ñuhun, ta cati ñi cuati can ti na cua sacahnu ñi chi ra cuu ñivi ra David, cati ra ta ra. Tacan, ta quechaha nduxaan ra sutu can chi ra sacuaha ley can, ");
INSERT INTO mioNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ta nducu tuhun ra ta ra chi ra Jesuu ti: ―¿Atu chini cun tuhun cha cahan ra ta ra? ―cati ra ta ra. Ta cati ndico ra Jesuu chi ra ta ra ti: ―Chini yu tuhun can, soco vasi ña ta sacuaha ndo nu cati tutu Ndioo cuenda yu ti: Cua sacahnu ñi cuati chihin ra, ta cua sacahnu tahan ve ni chaxi chihin ra, cati chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tacan, ta nacoo ra chi ra ta ra, ta quee ra ñuun can, ta cuahan ra iti ñuun Betania, ta quixi ra tican. ");
INSERT INTO mioNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tuvi inga quivi, ta ni nahan vihi, ta cuahan ndico ra Jesuu iti ñuun Jerusalén, ta chisoco ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ndehe ra iin yutun tusihva tiñi iti nu yaha ra, ta tuhva ra nu iyo chi, soco ñahni chiti chi iñi. Ndaha ni chi iyo. Tacan, ta quechaha cati ra chi maan yutun can ti: ―Ña cua coo ca chiti cun ndihi ni quivi ―cati ra chi run. Ta quii xaan neti maan yutun can. ");
INSERT INTO mioNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chacan ndehe ra sacuaha chi ra Jesuu, ta iyo xaan cuni ra ta ra, ta quechaha nducu tuhun ra ta ra chi ra ti: ―¿Yoso neti yutun can cha quii quii ni? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cati ndicha yu chihin ndo ti tu cua cuinu ndicha ini ndo chi ra Ndioo, tu ña cua saxini ndo, cua cuu savaha tahan ndo cuhva tahan yutun can, ta cua cuu savaha ndo cha ii ca. Cua cuu cati ndo chi yucu ya ti cua cuachiyo chi, ta cua cuhun chi tichi tañuhun, ta tacan ni cua cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ndihi cha cua cahan ndahvi ndo chi ra Ndioo, cua nihin ndo, tu cua cuinu ini ndo cha cua cuu savaha ra chi chi ―cati ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tacan cuu, ta cuahan tucu ra Jesuu ve ñuhun. Sa quihvi ra tichi cora soco ndavi can, ta tuhva ra sutu chahnu chi ra chanihin nu sacuaha ra chi ñivi can, ta quechaha nducu tuhun ra ta ra chi ra ti: ―Cua cati cun ndaa cuu nu ni nihun ndatu cha ni savahun ndihi cuhva can. ¿Yoo chaha ndatu can chihun? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cua nducu tuhin iin tuhun chihin ndo. Tu cua cati ndico ndo chihin yu, cua cati ndico tahan yu chihin ndo yoso iyo ndatu chihin yu cha savahi chacan. ");
INSERT INTO mioNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Yoo chaha ndatu chi ra Juaan cha sacuanduta ra chi ñivi? ¿Atu chaha ra iyo iti siqui andivi ndatu chi ra a chaha ñivi ñuñivi ndatu chi ra? ―cati ra Jesuu chi ra ta ra. Tacan cuu, ta quechaha nanducu xini ra chi tahan ra. Cati ra chi tahan ra ti: ―Tu cua cati yo ti ra iyo iti siqui andivi chaha ndatu chi ra Juaan, cua nducu tuhun ra chi yo ñacu ña chinu ini yo cha cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tu cua cati yo ti chaha ñivi ñuñivi ndatu chi ra, cua cuyuhvi yo chi ndihi ñivi ya, vati cati ñi ti ra cahan cuenda Ndioo cuu ra Juaan can ―cati ra chi tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chacan cuu cha cati ndico ra ta ra chi ra Jesuu ti: ―Ña chito ndi. Ta cati ndico maan ra chi ra ta ra ti: ―Ta ni cuhva ña cua cati yu yoso ni nihin yu ndatu cha savahi chacan ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ni vii cahan ra Jesuu chi ra sutu chahnu chi ra chanihin: ’Cua cati ndo yoso cuhva saxini ndo. Iyo iin rai, ta iyo uvi tahan sehe ra. Tuhva racan nu iyo ra chanihin, ta quechaha cati ra ti: “Sehu, cuahan vitin, ta satiñu cun nu iyo itu yo,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ta cati ndico ra chi sutu ra ti: “Cua cuhin, tata,” soco ña ni cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tacan cuu, ta cuahan ra chahnu can nu iyo inga sehe ra, ta ini tuhun cahan ra chi ra, soco cati ndico ra ti: “Ña cuhin,” soco inga hora saxini ndico tucu ra, ta cuahan ra, vati cua satiñu ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ndaa ra cuu ra ni savaha cuhva cuni sutu ra? ―cati ra Jesuu chi ra ta ra. Ta cati ndico ra ta ra ti: ―Ra luhu ca cuu ra ―cati ra ta ra. Ta cati ra Jesuu chi ra ta ra ti: ―Cati ndicha yu chihin ndo ti cua yaha ra satiahvi chi ñahan ndacu ndavaha ni iti nuun ndo, ta sa cua cundee quihvi ñi nu cua cundaca ñahan ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tacan cati yu, vati quichi ra Juaan nu iyo ndo, ta cati tuhun ra yoso cuhva cua coso vaha anima ñivi chi ra Ndioo, ta ña chinu ini ndo cuhva cahan ra, soco ñahan ndacu ndavaha ni chi ra satiahvi―ñican chinu ini cha cahan ra. Ndehe ndo cha chinu ini ñi cha cahan ra, soco ña saña ihni ndo cuati ndacu ndo, ta cuinu tahan ini ndo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ni vii cahan ra Jesuu chi racan ta ra: ’Cua tasoho ndo inga cuhva. Iyo iin rai. Chitoho cuu ra, ta tachi ra yava yoho chiti uva. Chasi ra cora, ta nañu ra nu yavi cua quee nduta chiti uva can, ta chaqui ndaa ra nu cua coo ra cua cumi chi chi. ’Tacan cuu, ta nducu ra yoo ra cua cumi nuun chi chi, ta chaha nuun ra chi chi chi ra, ta quee iti ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tacan cuu, ta queta quivi cha iyo vaha chiti can, ta tava tiñu ra chitoho can chi musu ra, vati cua cuhun ra ta ra nu iyo ra quihin nuun ñuhun can, vati cua quihin ra musu chiti chi cha iyo chi maan ra cuu chitoho ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tacan, ta quihin run ni ndoo cumi ñuhun can chi musu chitoho can, ta cani run chi iin ra. Chahni run chi inga musu ra, ta cani run yuu chi inga ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tava tiñu ndico tucu ra chitoho can chi inga musu ra. Tuvi musu ra tava tiñu ra, soco ta ni cuhva savaha run satiñu nu ñuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Queta quivi tava tiñu tahan ra chitoho can chi sehe ra nu iyo run, vati cati maan chitoho can ti: “Cua sacahnu run chi sehi,” ");
INSERT INTO mioNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","soco ndehe run ti cha vachi sehe ra, ta quechaha cati run chi tahan run ti: “Sehe chitoho ñuhun ya vachi. Cua cahni yo chi rahya, ta cua ndoo cha iyo chi ra chihin yo,” cati run ta run. ");
INSERT INTO mioNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chacan cuu cha tiin run chi ra, ta tava ndaa run chi ra chata cora can, ta chahni run chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Hora cua queta ra cuu chitoho can ¿ñaan cha cuu cha cua savaha ra chi run satiñu nu ñuhun can? ―cati ra Jesuu chi ra sutu chahnu can chi ra chanihin can. ");
INSERT INTO mioNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ta cati ndico ra ta ra ti: ―Cua cahni ra chi run savaha ndavaha ni can, ta cua nducu ra inga ra cua satiñu nu ñuhun can, ta cua cuhva racan chiti cha cua coo chi ra chitoho can quivi cua cuti chi ―cati ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ta cati ra Jesuu chi ra ta ra ti: ―¿Atu ña sacuaha ndo cha cati tutu Ndioo? Cati chi ti: Iyo iin yuu, ta cati ra sandaa vehe ti ña vaha chi, soco yuu can cha cuu yuu cahnu tutu vehe. Chacan ni savaha ra chahnu, ta vaha xaan cuni ñivi ndehe ñi chi chi, cati tutu Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chacan cuu cha cati yu chihin ndo ti ña cua cuu ca quihvi maan ndo nu cua cundaca ñahan ra Ndioo, soco cua cuu quihvi ñivi ndacu cha vaha ndicha cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tu ña cua cuu quihin cuenda ñivi chi ra cuu sava ta cua yuu can, cua ndoyo ñuhun ñi. Tu ña cua cuu quihin cuenda ñi chi ra, cua cutuni ndicha ñi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chini soho ra sutu chahnu can chi ra fariseo can cuhva can, ta chito ra ta ra ti cahan ra Jesuu tuhun can cuenda ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Cuni ra ta ra tiin ra chi ra, soco yuhvi ra ta ra chi ñivi can, vati iin ra cahan cuenda ra Ndioo cuu ra Jesuu cuni ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Cahan ndico tucu ra Jesuu chi ra inga chaha. Suvi ni chi cuhva cahan ra chi ra ta ra, ta cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ni ta cua iin rai cumi tiñu. Savaha ra iin vico cha cua tandaha sehe rai ra, ");
INSERT INTO mioNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ta tava tiñu ra chi musu ra, vati cua cana ra chi ñivi ni cana ñahan ra cumi tiñu can, vati cha queta hora cua nducahnu vico can, soco ña cuni ñi cuhun ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tava tiñu tucu ra chi inga musu ra, ta cati ra chi ra ta ra ti: “Cua cati ndo chi ñivi cha ni cana ñahin ti cha iyo vaha cha cua cachi ñi. Cha chihi ri sundiquin ta ri, ta cha tiso vahi ndihi chi. Na cua sacahnu tahan ndo vico, cua cati ndo,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tacan cuu, soco ña quihin ñi cuenda, ta cuahan ñi nu iyo tiñu maan ñi. Iin ra cuahan chiqui ra, ta inga ra cuahan nu iyo tiñu ra, ");
INSERT INTO mioNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ta ndihi ca ñi tiin ñi musu ra cumi tiñu can, ta cahan cateni ñi chi ra, ta chahni ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tacan cuu, ta nduxaan ra cumi tiñu can, ta tachi ra sandaru, ta chahni ra sandaru ta ra chi ñivi chahni can, ta chahmi ra ta ra ñuun ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tacan, ta quechaha cati ndico ra cumi tiñu can chi musu ra ti: “Cha iyo vaha cha cua cachi ñi, soco ña cuni quichi ñivi cha ni cana ñahin. ");
INSERT INTO mioNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Chacan cuu cha cua cuhun ndo vitin, ta iti yu ñuun cua cuhun ndo, ta cua cana ndo chi ndihi ñivi cuatahan tahan ndo. Na cua quichi ñi vico ya,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tacan, ta quee ra musu can cuahan ra. Cuahan ra ndihi iti, ta quichi ndaca ra ta ra chi ndihi ñivi nanihin ra ta ra. Chandaca ra chi ñivi vaha, ta chandaca tahan ra chi ñivi ndavaha ni. Tacan cuu, ta ña cutahan ca ñivi nu sacahnu ñi vico can. ");
INSERT INTO mioNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Tacan cuu, ta quihvi tahan ra cumi tiñu can, ta ndehe ra chi ndihi ñivi nducuiti. Ndehe ra ti cha iyo tahan iin rai, ta ña ndichin ra sahma cha iyo cuenda vico can, ");
INSERT INTO mioNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ta quechaha cati ra chi ra ti: “Yoho yani, ¿yoso cuhva quihvi cun, ta ñacu ñahni sahma vico ndichin cun?” cati ra, ta taxin taxin ndaa racan. ");
INSERT INTO mioNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tacan cuu, ta cati ra cumi tiñu can chi ra cuu musu ra ti: “Cua cuhni ndo ndaha ra. Cua cuhni ndo chaha ra, ta cua tava ndaa ndo chi ra nu naan. Tican cua ndehe ñivi tu ndoho, ta cua ndahyu chaa ñi,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tuvi ñivi cana ñahan ra Ndioo, soco suhva ñi nacachi ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tacan cuu, ta quee ra fariseo ta ra cuahan ra, ta nducu ra ta ra cuhva, vati cuni ra ta ra cha cua cahan ra Jesuu iin cha ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tava tiñu ra ta ra chi ra inda naan chi ra. Tava tiñu tahan ra chi ra inda naan chi ra Herode, ta cati ra ta ra chi ra Jesuu ti: ―Yoho maestru, chito ndi ti rai ndicha cuun, ta sanahan ndicha cun iti Ndioo, ta quihin cuenda cun chi ndihi ñivi, vati ña sahun cuenda yoo ñi cuu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chacan cuu cha cua cati cun chi ndi yoso cuhva saxini cun. ¿Atu vaha cha tiahvi ndi xuhun ñuhun chi ra César ra ndaca ñahan chi yo cuenda ñuun Roma a ña vaha? ―cati ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Chito ra Jesuu ti ña vaha saxini ra ta ra, ta sa quechaha cati ra chi ra ta ra ti: ―Rai uvi yaa cuu ndo. ¿Ñacu cuni ndehe ndo a ña vaha cua cati ndique tuhun can? ");
INSERT INTO mioNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sanahan ndo chihin yu ñaan xuhun tiahvi ndo chacan ―cati ra. Tacan cuu, ta quichi ndaca ra ta ra iin xuhun denario chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ta quechaha nducu tuhun ra Jesuu chi ra ta ra ti: ―¿Yochi xini ndiso chi ihya? ¿Yochi sivi ndiso tahan chi ihya? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ta cati ndico ra ta ra ti: ―Chi ra ndaca ñahan chi yo cuu chi ―cati ra ta ra chi ra. Tacan cuu, ta cati ra Jesuu chi ra ta ra ti: ―Chacan cuu cha chi racan cua cuhva ndo cha cuu chi ra, ta chi ra Ndioo cua cuhva ndo cha cuu chi maan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nu chini ra ta ra tuhun can, ta iyo xaan cuni ra, ta quee ra ta ra cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Suvi ni quivi can tuhva tahan ra saduceo ta ra nuun ra Jesuu. Racan cuu ra cati ti ñahni cha cua natacu ndico ñivi ndii, ta quechaha nducu tuhun ra ta ra chi ra Jesuu ti: ");
INSERT INTO mioNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Yoho maestru, cha cati ra Moisee tiempu chahnu ti tu cua cuvi iin rai, ta ñahni sehe ra chacoo, cua quihin yani ra chi ñasihi ra, ta cua coo ra chi ña, ta tacan cua coo sehe ña cha cuenda ra ndii yani ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ni chacoo ucha tahan ra nuun iyo ndi. Mani yani ra ta ra, ta ra cuu ra chanihin―tandaha ra, ta chihi ra. Nacoo ra ñasihi ra chi ra yani ra, vati ñahni sehe ra chacoo, ");
INSERT INTO mioNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ta ra cuu ra uvi can quihin chi ña, soco ta ni cuhva ñahni sehe ra chacoo, ta ni chihi tahan ra. Tacan ni savaha ra nda cua nda ni ndihi ra ta ra ni chihi. ");
INSERT INTO mioNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tacan, ta chihi tahan maan ña ñahan can. ");
INSERT INTO mioNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ta vitin cua cati cun. ¿Yochi ñasihi cua cuu ña quivi cua natacu ndico ñivi ndii, vati chacoo ña chi ndihi ucha ra? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ta cati ndico ra Jesuu chi ra saduceo can ti: ―Ña nihin ndo cuhva, vati ña chito ndo yoso cuhva cati tutu Ndioo, ta ni ña chito ndo ti iyo tu ndee ini chi ra Ndioo, ta cuu savaha ra cuhva cuni ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Quivi cua natacu ndico ñivi ndii ña cua nducu ra rai cha cua coo ñasihi ra, ta ni ña cua cuni ñi ñahan tandaha ñi, soco cua cuu ñi cuhva cha iyo tatun Ndioo cha iyo iti siqui andivi, ");
INSERT INTO mioNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ta cuenda cha cua natacu ndico ñivi ndii―vasi ña ta sacuaha ndo cuhva cati ra Ndioo chi ndo. Cati ra ti ");
INSERT INTO mioNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","maan ra Ndioo cuu ra, ta sacahnu ra Abraham chihin ra. Sacahnu ra Isaac chihin ra, ta sacahnu tahan ra Jacob chihin ra, cati ra. Chacan cuu cha chito yo cha natacu ndico ñivi ndii, vati iyo ndito ndico ra ta ra, ta sacahnu ra chi ra Ndioo. Ña cuu sacahnu ñivi ndii chi ra ―cati ra Jesuu chi ra saduceo ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chini ñivi tuhun can, ta iyo xaan cuni ñi cha chini ñi tuhun sacuaha ra Jesuu, vati sacanaan ra chi ra saduceo can. ");
INSERT INTO mioNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tacan cuu, ta chito ra fariseo ta ra ti ña nihin ra saduceo ta ra cuhva cua cati ndico ra ta ra chi ra Jesuu, ta nducuiti ra fariseo can nu iyo ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ta quechaha nducu tuhun iin ra sacuaha ley chahnu can, vati cuni ndehe ra ta ra a ña cua cahan ra Jesuu iin tuhun ña vaha. Chacan cuu cha nducu tuhun ra chi ra Jesuu ti: ");
INSERT INTO mioNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Yoho maestru, ¿ñaan cha cuu tuhun cahnu ca cuenda ley chahnu cha ni cati tuhun ra Moisee? ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ta cati ndico ra Jesuu ti: ―Cua cuni ndo chi ra chahnu Ndioo chi ndihi cuii cha iyo chi ndo. Cua coo ndo chi ra chi ndihi cuii anima ndo, ta cua coo ndo chi ra chi ndihi cuii cha chini tuni cha iyo chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Chacan cuu cha cahnu ca, ta chacan cuu cha xihna ca. ");
INSERT INTO mioNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ta ni cuhva iyo cha cuu cha uvi, vati cua cuni ndo chi ndihi ñivi cuhva cuni ndo suvi ni chi maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nduvi tahan tuhun ya cuu cha cati ndihi tutu Ndioo ―cati ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ni vii iyo cuiti ra fariseo ta ra, ta nducu tuhun tahan ra Jesuu iin tuhun chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Cati ra ti: ―¿Yoso saxini ndo cuenda ra cuu Cristo ra tava tiñu ra Ndioo? ¿Ñaan tata cuu ra? ―cati ra chi ra ta ra. Ta cati ndico ra ta ra ti: ―Tata ra David cua cuu ra Cristo quivi cua quichi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ta nducu tuhun tucu ra chi ra ta ra ti: ―Tu chacan cuu chi, ¿yoso chaha ra Tati Ndioo tu ndee ini chi ra David, ta cati ra ti chitoho ra cuu ra cuu Cristo can?, vati cati ra David can ti: ");
INSERT INTO mioNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Cati ra chahnu Ndioo chi ra cuu chitoho ra David ti cua cuhva ra ndatu chi ra, vati cua cunda ra chiyo ndaha cuaha ra Ndioo, ta cua cuhva ra tu ndee ini chihin ra, ta cua sacanaan ra chi ndihi ñivi cuxaan ini chihin ra, cati ra Ndioo cuenda ra cuu Cristo, cati ra David tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ni cati ra David can ti chitoho ra cuu ra Cristo. ¿Yoso cuu ra Cristo tata ra David iti nuun, tu iyo ra tiempu chahnu? ―cati ndico tucu ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ta ña ni cuu cahan ndico ni iin ra chi ra, ta ni ña cuni ca ra ta ra nducu ra cuhva cha cua nducu tuhun ra inga tuhun chi ra Jesuu nda ni quivi can nda cua nda iti nuun. ");
INSERT INTO mioNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tacan cuu, ta quechaha cahan ra Jesuu chi ñivi can chi ra sacuaha chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ta cati ra ti: ―Chito maan ra fariseo chi ra sacuaha ley chahnu ñaan cha cuu tuhun ni cati tuhun ra Moisee. ");
INSERT INTO mioNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chacan cuu cha na cua sacuinu ndo ndihi cha cahan ra, soco ña cua savaha ndo cuhva ndacu maan ra, vati cati tuhun vaha ra, soco ña ndacu ra cuhva can. ");
INSERT INTO mioNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tiso ra ta ra cha vee chi ndo, soco ña cuni ra ta ra tindee ra―masi suhva. ");
INSERT INTO mioNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Savaha ra ta ra ndihi cha savaha ra, vati cuni ra ta ra cha cua ndehe ñivi yoso cuhva ndacu ra. Chacan cuu cha nahnu xaan letra tuhun Ndioo ndiso ra xini ra, nahnu xaan letra tuhun Ndioo ndiso ra ndaha ra, ta nani xaan yuhva iyo yu sahma ra savaha ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Cuni xaan ra ta ra cunda ra tayu vaha ca nu nducuiti ñivi, ta cha sacahnu tahan ñi vico. Cuni xaan ra ta ra cunda tahan ra tayu vaha ca ve ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Cuni xaan ra ta ra cha cua sacahnu ñivi chi ra nuyahvi, ta cuni tahan ra ta ra cha cua cati ñivi ti maestru vaha cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Ña cua nducu ndo cha cua cati ñivi ti maestru cuu ndo, vati iin tuhun ni ra cuu maestru, ta ini ñivi cuu ndihi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ña cua nducu ndo cha cua cati ñivi ti sutu cuu ndo ihya nu ñuhun ñuñivi ya, vati iin tuhun ni ra cuu sutu yo, ta iyo ra iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ña cua nducu ndo cha cua cati ñivi ti chitoho cuu ndo, vati iin tuhun ni ra Cristo ndaca ñahan chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tu cua cuni ndo cuu ndo ñivi cahnu ndicha, cua tindee ndo chi ndihi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tu cua nducu ñivi cha cua cuu ñi ñivi cahnu, cua savaha ra Ndioo cha cua ndoo ndahvi ñi, ta tu cua cuu ndo ñivi ndahvi, cua savaha ra Ndioo cha cua cuu ndo ñivi cahnu. ");
INSERT INTO mioNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Ndioho ra fariseo, ndioho ra sacuaha ley, ra uvi yaa cuu ndo. Tu ndoho cua ndehe ndo, vati ña chaha ndo cha cua coo ñivi nu cua cundaca ñahan ra iyo iti siqui andivi. Ña cuni maan ndo coo ndo nu cua cundaca ñahan ra, ta ni ña chaha ndo cha cua coo ñivi cuni coo nu cua cundaca ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Ndioho ra fariseo, ndioho ra sacuaha ley, ra uvi yaa cuu ndo. Tu ndoho cua ndehe ndo, vati suhu ndo ndatiñu ñi ñahan ndahvi, ta nahan xaan cahan ndo chi ra Ndioo, vati cuni ndo cha cua ndehe ñivi cha ndacu ndo. Chacan cuu cha cahnu ca tu ndoho cua coo chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Ndioho ra fariseo, ndioho ra sacuaha ley, ra uvi yaa cuu ndo. Tu ndoho cua ndehe ndo, vati cani xaan chahan ndo cha nanducu ndo cha cua quihvi iin ñivi cuenda maan ndo. Sa quihvi ñi cuenda ndo, ta savaha ndo cha cahnu ca tu ndoho cua ndehe ñi nu cua cutuni ñi, ta ñavi ca sa maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Ndioho, sava ni ta cua ra cuaa cuu ndo, ta ndaca ndo chi ñivi. Tu ndoho cua ndehe ndo, vati cati ndo ti ñahni tuhun tu cua cahan rai ñivi, ta cua xita ñi tuhun ve ñuhun, soco tu cua cahan rai ñi, ta cua xita ñi tuhun xuhun cuaan iyo tichi ve ñuhun, nini xaan cha cua savaha ñi cuhva cati ñi, vati ii ca chacan, cati ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sava ni ta cua rai cuaa cuu ndo, vati ña chito ndo ti cha cahnu ca cuu ve ñuhun can, vati cuenda chacan nduii xuhun cuaan cha iyo tichi chi. ");
INSERT INTO mioNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Cati tahan ndo ti ña nini cha cua cahan rai ñivi, ta cua xita ñi tuhun mesa nu samani ñivi chi ra Ndioo, soco tu cua xita ñi tuhun cha tiso ñi nu mesa can, ta samani ñi chi ra Ndioo, nini xaan ca cha cua savaha ñi cuhva cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sava ni ta cua ra cuaa cuu ndo, vati ña chito ndo ti cha cahnu ca cuu mesa can, vati cuenda chacan nduii cha samani ñivi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Chacan cuu cha tu cua cahan rai ñivi, ta xita ñi tuhun mesa can, cua xita ñi tuhun mesa can chi ndihi cha yoso nuun chi. ");
INSERT INTO mioNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tu cua xita ñivi tuhun ve ñuhun can, cua xita ñi tuhun maan ve ñuhun can chi maan ra Ndioo ra iyo tichi chi. ");
INSERT INTO mioNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tu cua xita ñivi tuhun iti siqui andivi, cua xita ñi tuhun nu iyo ra Ndioo, ta cua xita ñi suvi ni tuhun maan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Ndioho ra fariseo, ndioho ra sacuaha ley, ra uvi yaa cuu ndo. Tu ndoho cua ndehe ndo, vati iin cuhva luhu ndihi yucu cha tachi ndo samani ndo chi ra Ndioo, ta ña saxini ndo cuenda cha nini ca. Ña saxini ndo yoso cua savaha ndo cha vaha ndicha. Ña nducu ndo cuhva cha cua cundahvi ini ndo chi ñivi tahan ndo. Ña chinu ini ndo chi ra Ndioo. Nini cha cua samani ndo iin cuhva cha cuu ndatiñu ndo chi ra Ndioo, soco nini ca cha cua savaha ndo cha vaha ya. ");
INSERT INTO mioNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ra cuaa cuu ndo, ta cuni cundaca ndo chi ñivi. Sacuinu ndo cha ñahni yavi ndaa, ta ña sacuinu ndo cha iyo ca yavi ndaa. ");
INSERT INTO mioNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Ndioho ra fariseo, ndioho ra sacuaha ley, rai uvi yaa cuu ndo. Tu ndoho cua ndehe ndo, vati nacata ndo chata yachin ndo. Nacata ndo chata coho ndo, soco ña ndoo tichi chi, vati suhu ndo, ta ña cumi ndo chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ndioho ra fariseo, ra cuaa cuu ndo. Xihna ca cua nacata ndo tichi yachin ndo, vati tacan cua ndundoo tahan chata chi. ");
INSERT INTO mioNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Ndioho ra fariseo, ndioho ra sacuaha ley, ra uvi yaa cuu ndo. Tu ndoho cua ndehe ndo, vati cuu ndo sava ni ta cua iin ñaña cuichin can. Taqui xaan ndehe chata chi, soco tichi chi ñuhun iquin ndii, ta quini xaan caa. ");
INSERT INTO mioNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Cuhva can iyo maan ndo. Ndehe ñivi cuhva ndacu ndo, ta saxini ñi ti rai cuiti vaha cuu ndo, soco mani ndavaha ni saxini ndo chi anima ndo. Rai uvi yaa cuu ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Ndioho ra fariseo, ndioho ra sacuaha ley, ra uvi yaa cuu ndo. Tu ndoho cua ndehe ndo, vati chaqui ndaa ndo ñaña ra ni cahan cuenda ra Ndioo tiempu chahnu, ta sandutaqui ndo chi chi, ");
INSERT INTO mioNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ta cati ndo ti tu cha iyo ndo quivi iyo ñivi ndo tiempu chahnu, ña cua savaha ndo cuhva ni savaha ñi. Ña cua cahni ndo chi ra ni cahan cuenda ra Ndioo, cati ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chacan cuu cha suvi ni maan ndo cuu testigu ti ña vaha iyo ndo. Suvi ni maan ndo cuu ñivi ra ni chahni chi ra ni cahan cuenda ra Ndioo tiempu chahnu, ");
INSERT INTO mioNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ta maan ndo―cua saqueta ndo cha ña ni savaha ñivi ndo tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Ñivi ndavaha ni cuu ndo. Sava ta cua ri coo cuu ndo, vati mani ndavaha ni ndacu ndo. Ña cua cacu ndo nu cua cutuni ñivi nu cayu ñuhun iti andaya. ");
INSERT INTO mioNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chacan cuu cha tava tiñu yu chi ra cahan cuenda ra Ndioo chi ra nditi xini cuenda ra Ndioo chi ra sacuaha tuhun Ndioo. Nu iyo ndo tava tiñu yu chi ra ta ra, ta iyo ra cua taa ndo nu cruu, ta iyo ra cua cahni ndo. Iyo ra cua cani ndo tichi ve ñuhun ndo, ta cua cundicu ndo chi ra ta ñuun ta ñuun. ");
INSERT INTO mioNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chacan cuu cha cua cutuni maan ndo cuenda ndihi ra chahni ñivi nda ni cha chihi ra Abel ra iyo cuiti vaha nda ni cha chihi ra Zacaría sehe ra Berequía. Tiempu chahnu cha ni chahni ñivi ndo chi racan mahñu nu iyo mesa nu samani ñivi chi ra Ndioo ta yu ve ñuhun. Cuenda ndihi racan cua cutuni ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cati ndicha yu chihin ndo ti cuenda ndihi cuati can cua cutuni ñivi judío cha iyo vitin. ");
INSERT INTO mioNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ni vii cahan ra Jesuu: ’Ndioho ñivi ñuun Jerusalén, chahni ndo chi ra ni cahan cuenda ra Ndioo, ta chi yuu cani ndo chi ra tava tiñu ra Ndioo. Cuaha chaha ni cuni yu sacuende chi ndo cuhva sacuenda ri tiñuun chi sehe ri, ta tixehe ri sehe ri tichi ndichin ri. Cuni yu sacuenda yu chihin ndo, soco ña cuni maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Cha saña ndaha ra Ndioo chihin ndo ñuun ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","vati cati yu chihin ndo ti ña cua ndehe ca ndo chihin yu nda cua nda quivi cua cati ñivi ti vaha xaan rai cuu ra quichi cuenda ra chahnu, cua cati ñi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tacan cuu, ta quee ra Jesuu tichi cora soco ndavi ve ñuhun, ta cuahan ra, ta tuhva ra sacuaha chi ra nu cuahan ra, ta quechaha sanahan ra ta ra chi ra ti taqui xaan iyo ndihi vehe iyo tichi cora soco ndavi can, ");
INSERT INTO mioNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ta quechaha cati ra chi ra ta ra ti: ―Ndehe ndo ndihi vehe can. Cati ndicha yu chihin ndo ti ña cua ndoo iin yuu siqui tahan chi, vati ndihi cuii chi cua tani ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tacan cuu, ta ni chacunda ra Jesuu yucu Olivo can. Iyo ra chi ra sacuaha chi ra ni, ta quechaha nducu tuhun ra ta ra chi ra ti: ―Na cua cati cun chihin ndi ndaa quivi cua coo chacan. ¿Ñaan cuhva cua coo, ta cua quichi ndico tucu cun? ¿Ndaa quivi cua cundihi quivi ya? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cua saha ndo cuenda, coto cua sandahyu ñahan ñivi chi ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","vati tuvi ñivi cua quichi, ta cua cati ñi ti quichi ñi cuenda yu. Cua cati ñi ti maan ñi cuu ra Cristo, ta tava tiñu ra Ndioo chihin ñi, cua cati ñi, ta tuvi ñivi cua ndoyo ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Cua cati ñivi ti cha iyo cuati, ta cua cati tahan ñi ti ni cua coo cuati. Ña cua cuyuhvi ndo, vati tacan ni cua coo chi, soco ña ta cundihi quivi ya. ");
INSERT INTO mioNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cua cani tahan ñivi iin ñuun chi ñivi inga ñuun. Cua cani tahan ñivi iin ñuhun chi ñivi inga ñuhun. Cua coo tama, ta cua taan nini cahnu nu ñuhun ñuñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tacan ni cua quechaha coo tu ndoho. ");
INSERT INTO mioNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Tacan cuu, ta cua tiin ñivi chi ndo, ta cua cundaca ñi chi ndo nuun ra cumi tiñu, ta cua ndehe ndo tu ndoho, ta cua cahni ñi chihin ndo. Cua cuxaan ini ndihi ñivi chihin ndo, vati iyo ndo cuenda yu. ");
INSERT INTO mioNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tacan cuu, ta cua ndoyo ñuhun tuvi ñivi, ta cua xico tuhun ñivi chi ndo, ta cua cuxaan ini ñi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tuvi xaan ra cua sandahyu ñahan chi ñivi, vati cua cati ra ti cuenda ra Ndioo cati tuhun ra, ta tuvi ñivi cua ndoyo ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ña cua cuni ca ñivi chi tahan ñi cuhva xihna ca, vati cua sanihin ñivi savaha ñi cha ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tu cua cundee ini ñivi nda cua nda cua cundihi quivi ya, cua cundee cacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Cua coto ndihi ñivi, vati nini cahnu ñuhun ñuñivi ya cua queta tuhun vaha ya tuhun yoso cuhva cua cundaca ñahan ra Ndioo, ta sa cua cundihi quivi ya. ");
INSERT INTO mioNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Chacan cuu cha cua queta quivi cua ndehe ndo ti cha indi run sacaquini tichi ve ñuhun ii, ta sandoyo ñuhun run cuhva ni cati ra Daniel ra ni cahan cuenda ra Ndioo tiempu chahnu. Na cua cutuni ini ndihi ndo sacuaha tuhun ya. ");
INSERT INTO mioNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Suvi ni quivi can na cua cunu ñivi iyo ñuhun Judea iti yucu. ");
INSERT INTO mioNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tu iyo ñi xini vehe, ña cua quihvi ca ñi tichi vehe ñi, vati cua tava ñi ndatiñu ñi, soco quii xaan cua cunu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tu inda ñi chiqui ñi, ña cua ndico coo ñi quihin ñi sahma ñi, soco quii quii ni cua cunu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tu ndoho cua ndehe ñivi ñahan ñuhun sehe quivi can. Tu ndoho cua ndehe tahan ñivi ñahan chaxi sehe quivi can. ");
INSERT INTO mioNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Na cua cahan ndahvi ndo chi ra Ndioo ti ña cua coo cha cua cunu ndo tiempu vichin, ta ni ña cua coo chi iin quivi sábadu quivi ndaa tatun ñivi cuenda ley, ");
INSERT INTO mioNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","vati quivi can cua coo iin tu ndoho cahnu. Ña ta ndehe ñivi tu ndoho cuhva can nda ni xihna cuii quivi ni tuvi ñuhun ñuñivi ya nda cua nda vitin, ta ni ña cua coo tu ndoho cuhva can iti nuun ca. ");
INSERT INTO mioNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tu ña cua sandihi ra Ndioo quivi can, yoni cua cundee cacu, soco cua sandihi ra Ndioo quivi can cuenda ñivi cha ni nacachi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Tu cua cati ñivi chi ndo quivi can ti jihna ihya inda ra Cristo a cua cati ñi ti ican inda ra Cristo, ña cua cuinu ini ndo cha cahan ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","vati cua coo ra cua sandahyu ñahan. Cua cati ra ta ra ti ra Cristo cuu ra, ta cua cati inga ra ta ra ti ra cahan cuenda ra Ndioo cuu ra. Cuhva cahnu xaan cua savaha tahan ra ta ra, vati tacan cua nducu ra ta ra cuhva cha cua sandahyu ñahan ra chi ñivi Ndioo, tu cua cuu. ");
INSERT INTO mioNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cha chahi cuenda chihin ndo vitin. ");
INSERT INTO mioNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tu cua cati ñivi chi ndo ti iyo ra tichi cuhu, ña cua cuhun ndo. Tu cua cati ñi ti indi xehe ra tichi vehe, ña cua cuinu ini ndo cha cahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ña cua cuinu ini ndo, vati cuhva quehni tachan, ta ndundichin niniin iti siqui andivi―cuhva can cua quichi ra cuu sehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Quivi cua cutuni ñivi cua quichi racan, cuhva nducuiti ri tachii nu ndoyo ñuhun ri quiti cuhu. ");
INSERT INTO mioNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Cua yaha tu ndoho quivi can, ta sa cua ndahva ri nicandi. Ña cua ndundichin ca ri yoo can, ta cua quehni ri tiñu iti siqui andivi. Tacan cua ndoyo ñuhun ndihi cuii cha iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tacan cuu, ta cua coo seña ti cua quichi ra cuu sehe ñivi iti siqui andivi cua ndehe ñivi, ta sa cua coo tu cuihya ini chi ñivi ndihi ñuun iyo nu ñuhun ñuñivi, ta cua ndehe ñi ti vachi ra cuu sehe ñivi tichi vico iti siqui andivi. Tacan cua ndehe ñi ti iyo xaan tu ndee ini chi ra, ta taqui xaan ra cuu. ");
INSERT INTO mioNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Cua tivi ra tatun Ndioo cutu ra, ta sa cua tava tiñu ra cuu sehe ñivi can tatun Ndioo ta ra, ta cua sacuiti ra ta ra chi ñivi ni nacachi ra Ndioo nini cahnu ñuhun ñuñivi ya. ");
INSERT INTO mioNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Na cua cutuni ini ndo, vati chito ndo yoso cuhva iyo yutun tusihva tiñi. Chito ndo ti tucu tiempu cha vachi quivi cua nduyuta yutun can, ta cua cana ndaha chi. ");
INSERT INTO mioNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ta ni cuhva quivi cua ndehe ndo ndihi cha cati yu chihin ndo vitin―quivi can cua coto ndo ti cha yatin cua quichi ra cuu sehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cati ndicha yu chi ndo ti ña cua cuvi ndihi ñivi cha iyo vitin nda cua nda cua coo ndihi cha cati yu. ");
INSERT INTO mioNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cua queta quivi cua naan ñuhun ñuñivi ya chi andivi ya, soco ña cua naan tuhun cha cahin. ");
INSERT INTO mioNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Yoni chito ndaa quivi cua cuu chacan. Yoni chito ñaan hora cua cuu chi. Ña chito ra tatun Ndioo iyo iti siqui andivi, ta ni ña chito sehe ra Ndioo chacan. Iin tuhun ni ra Ndioo chito. ");
INSERT INTO mioNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Cuhva cha cuu chi quivi ni chacoo ra Noé―cuhva can cua cuu chi quivi cua quichi ra cuu sehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Quivi can ña ta coo tu ndoho chi nduta can. Chachi ñi, ta chihi ñi. Nducu ra rai cha cua coo ñasihi ra, ta cuni ñi ñahan tandaha ñi chi ra rai. Tacan ni chacoo ñi nda ni quivi quihvi ra Noé can tichi tundoo can. ");
INSERT INTO mioNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ña chito ñi cha ni queta hora can nda ni quichi nduta can, ta canihin run chi ndihi ñi. Ta ni cuhva ña cua coto ñi cha queta hora cha cua quichi ra cuu sehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Quivi can cua coo uvi ra satiñu chiqui. Cua canihin ra tatun Ndioo chi iin ra, ta cua ndoo ihni inga ra. ");
INSERT INTO mioNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cua coo uvi ñi ñahan ndico ñi, ta cua canihin ra tatun Ndioo chi iin ña, ta cua ndoo ihni inga ña. ");
INSERT INTO mioNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Chacan cuu cha na cua saha ndo cuenda, vati ña chito ndo ndaa quivi cua quichi ra cuu chitoho ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Chito ndo ti tu chito ra xuu vehe ndaa hora cua quichi run ñasuhu, cua cumi vaha ra vehe ra, ta ña cua cuhva ra cha cua quihvi ñasuhu can tichi vehe ra. ");
INSERT INTO mioNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chacan cuu cha na cua cumi vaha ndo chihin ndo, ta cua coo vaha ndo, vati hora cua quichi ra cuu sehe ñivi―ña cua saxini ndo chacan. ");
INSERT INTO mioNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Chito ndo yoso cuhva iyo ra cuu musu vaha ndicha. Iyo cha chini tuni chi ra, ta chaha chitoho ra ndatu cha cua cundaca ñahan ra chi inga musu chitoho ra, ta chaha ra cha cua cachi inga musu can na cua queta hora can. ");
INSERT INTO mioNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Cua cusii ini racan, tu tacan cua savaha ra hora cua quichi ndico chitoho ra. ");
INSERT INTO mioNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cati ndicha yu ti cua cuhva chitoho ra ndatu cha cua cumi racan ndihi ndatiñu ra, ");
INSERT INTO mioNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","soco tu ña vaha cua savaha ra musu can, ta cua saxini ra chi anima ra ti ni cua nducuee ra chitoho ra, ");
INSERT INTO mioNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ta tacan, ta quechaha cani ra chi musu tahan ra, ta quechaha chihi ra chi ra chini. ");
INSERT INTO mioNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Suvi ni hora ña saxini rucan cua quichi chitoho run, ");
INSERT INTO mioNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ta xaan xaan cua tachi tuni ra chihin run, ta cua coo run chi run uvi yaa icaa ni. Ican cua coo xaan tu cuihya ini, ta ndahvi xaan cua cuni anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Quivi can nu cua cundaca ñahan ra iyo iti siqui andivi cuu sava ni ta cua uchi tahan ñi ñahan tivaa. Quihin ñi nu indi ñuhun ñi, ta quee ñi cuahan ñi, vati cua satahan ñi chi ra cua tandaha. ");
INSERT INTO mioNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Uhun tahan ñican ña vaha saxini ñi, ta inga uhun ñi saxini vaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ta ñi ña saxini vaha―quihin ñi cha indi ñuhun ñi, soco ñahni ca nduta can ndiso tahan ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","soco inga ñi―ñi saxini vaha ndiso tahan ñi suhva ca nduta cha cua cuindi lampara ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ni nducuee ra cua tandaha can, ta ña cundee ca ñi ñumahna, ta quixi ndihi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nda sava ñuun, ta quechaha cana chaa ñivi. Cati ñi ti: “Cha vachi ra cua tandaha. Cuahan ndo, vati cua satahan ndo chi ra,” cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tacan cuu, ta ndoyo ndihi ñi ñahan can, ta tiso vaha ñi ñuhun ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ta quechaha cati ñi ña saxini vaha chi tahan ñi ti: “Cuhva ndo suhva nduta chi ndi, vati cha ndahva ñuhun ndi,” cati ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ta cati ndico ñi saxini vaha chi ñi ti: “Ña cuu, coto ña cua queta chi chi maan ndi. Cuahan ndo nu quiyahvi nduta can, ta sata tahan ndo,” cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tacan cuahan ñi, vati cua sata ñi, soco suvi ni hora can quichi ra cua tandaha, ta ñivi cha iyo vaha―cuahan ñi chi ra nu cua nducahnu vico, ta chachi ñi. Tacan cuu, ta ni chacundasi yu vehe. ");
INSERT INTO mioNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Inga hora, ta sa quichi tahan ndihi ca ñi ñahan can, ta quechaha cati ñi ti: “Yoho ra chahnu, nuna yu vehe na cua quihvi tahan ndi,” cati ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ta cati ndico ra ti: “Cha ndicha ndicha ña nacote chi ndo,” cati ra chi ñican. ");
INSERT INTO mioNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Na cua saxini vaha ndo ndihi ni hora, vati ña chito ndo ñaan quivi cua quichi ra cuu sehe ñivi. Ña chito ndo ndaa hora cua quichi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Cua queta quivi cua cuu chi sava ni ta cua iin rai, ta cua quee iti ra. Chacan cuu cha cana ra chi musu ra, ta natahvi ra xuhun ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Chaha ra uhun mil chi iin ra, ta chaha ra uvi mil chi inga ra, ta chi inga ra chaha ra iin tuhun ni mil. Ta iin ta iin ra natahvi ra cuhva iyo tu ndee ini chi ra ta ra. Tacan cuu, ta quee ra cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tacan, ta sa cuahan ra cha nihin uhun mil, ta satiñu ra chi chi, ta sacanaan ra inga uhun mil siqui chi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ta ni cuhva satiñu ra cha nihin uvi mil, ta nihin ndico tucu ra inga uvi mil siqui chi, ");
INSERT INTO mioNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","soco ra cha nihin iin tuhun mil―quee ra cuahan ra, ta nañu ra tichi ñuhun, ta tixehe ra xuhun chitoho ra. ");
INSERT INTO mioNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Yaha xaan quivi, ta quichi ndico chitoho ra ta ra, ta tiso vaha ra tiñu can chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Iti nuun chitoho ra tuhva ra cha nihin uhun mil, ta quichi ndaca ra inga uhun mil, ta quechaha cati ra chi chitoho ra ti: “Ra chahnu, ihya vachi nain uhun mil cha chahun chihin yu. Juhun. Ihya iyo inga uhun mil cha ni sacanain siqui chi,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ta cati ndico chitoho ra chi ra ti: “Vaha xaan cha savahun. Musu vaha ndicha cuun. Cha satiñu vaha cun―masi tiñu luhu cuu chi. Tiñu cahnu ndicha ndicha cua cuhve chihun. Na cua cusii ini tahun chihin yu icaa ni,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tacan cuu, ta quichi tahan ra nihin uvi mil, ta quechaha cati ra ti: “Ra chahnu, cha chahun uvi mil chihin yu. Juhun. Ihya iyo inga uvi mil cha sacanain siqui chi,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ta cati ndico chitoho ra chi ra ti: “Vaha xaan cha savahun. Musu vaha ndicha cuun. Vaha xaan cha satiñu cun―masi tiñu luhu cuu chi. Cahnu ca tiñu cua cuhve chihun. Vitin na cua cusii ini tahun chihin yu icaa ni,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tacan, ta sa quichi tahan ra cha nihin iin mil, ta quechaha cati ra chi chitoho ra ti: “Ra chahnu, chite ti rai xaan xaan cuun, ta quihin maun cha iyo chi inga ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chacan cuu cha yuhvi yu, ta quei cuahin, ta ni tixehi xuhun cun tichi ñuhun. Juhun, xuhun cun,” cati racan, ");
INSERT INTO mioNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ta cati ndico chitoho ra chi ra ti: “Ña vaha musu cuun. Sucha xaun. Chito cun ti quihin yu cha iyo chi inga ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Chacan cuu cha iyo cha nacoo cun xuhin chi ra satiñu chi xuhun. Tacan, ta quichi ndique, ta nihin ndique xuhin, ta nihin tahin suhva siqui chi.” ");
INSERT INTO mioNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Cua quihin ndo xuhun ra, ta cua cuhva ndo chi chi chi ra iyo uchi mil can, ");
INSERT INTO mioNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","vati cuaha ca cua nihin ñivi satiñu vaha, ta cuaha suhva cua coo chi ñi, soco tu ña cua satiñu vaha ñivi, cua quenda ñivi cha iyo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Cua tava ndaa ndo chi ra musu ya nu naan, vati ñahni yavi ndaa ra. Ican nu naan cua coo xaan tu cuihya ini chi ñivi, ta ndahvi xaan cua coo anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Quivi cua quichi ra cuu sehe ñivi, ta taqui xaan ra cua cuu. Cua quichi ndihi ra tatun Ndioo chi ra. Quivi can cua cunda ra tayu ra, vati cua ndehe ra a vaha savaha ñivi a ña vaha savaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Cua nducuiti ñivi ndihi ñuun iyo nu ñuhun ñuñivi ya, ta cua natahvi ra chi ñi cuhva natahvi ñivi chi sana ñi, ta ndoo ri mbee can iin chiyo, ta ndoo ri chivu can inga chiyo. ");
INSERT INTO mioNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Cua sayaha ra cuu sehe ñivi can chi ñivi vaha ndicha chiyo ndaha cuaha ra, ta cua sayaha ra chi ñivi ndavaha ni chiyo ndaha satin ra. ");
INSERT INTO mioNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tacan cuu, ta cua cati racan ti: “Nahan ndo. Maan ndo cuu ñivi cahan vaha cuenda ra suti. Cua coo vaha ndo nu ndaca ñahan ra, vati cha tiso vaha ra nu cua coo ndo nda ni tuvi ñuhun ñuñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tacan cati yu, vati chisoco yu, ta chaha ndo cha cachi yu. Neti yu nduta, ta chaha ndo cha cohi. Toho cui chica cui, ta quihin cuenda ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Sahma lahnda chacunami yu, ta chaha ndo sahma vaha cua cunami yu. Cuhvi yu, ta tindee ndo chihin yu. Chacuindi yu ve caa, ta tuhva ndo nuun chacunde,” cua cati yu. ");
INSERT INTO mioNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tacan cuu, ta cua cati ndico ñi cha iyo vaha anima ti: “Ra chahnu, ña ndehe ndi ti cha chisoco cun, ta chaha ndi cha cachi cun. Ña ndehe ndi ti cha neti cun, ta chaha ndi cha cohun. ");
INSERT INTO mioNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ña ndehe ndi ti toho cuun, ta quihin cuenda ndi chihun. Ña ndehe ndi cha sahma lahnda chica cuu cun, ta chaha ndi sahma vaha cunami cun. ");
INSERT INTO mioNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ña ndehe ndi ti cha cuhvi cun, ta ni ña ndehe ndi chacuindi cun ve caa, ta tuhva ndi nuun cun,” cua cati ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ta cua cati ndico ra ndaca ñahan can chi ñi ti: “Cati ndiche chi ndo ti cuhva cha ni savaha ndo chi ñivi ndahvi yu―masi ndahvi xaan ñi―cuhva can savaha tahan ndo chihin yu,” cua cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Tacan cuu, ta cua cati ra chi ñi iyo chiyo ndaha satin ra ti: “Cuahan ndo, vati cua cutuni ndo vitin. Cua quee ndo iti nuin, ta cua quihvi ndo nu cayu ñuhun ña ndahva. Cha iyo vaha chi chi run cuihna chi tatun run. ");
INSERT INTO mioNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tacan cati yu, vati chisoco yu, ta ña chaha ndo cha cachi yu. Neti yu nduta, ta ña chaha ndo cha cohi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Toho cui chica cui, ta ña quihin cuenda ndo chihin yu. Sahma lahnda chacunami yu, ta ña chaha ndo sahma chacunami yu. Cuhvi yu, ta chacuindi yu ve caa, ta ña ni tindee ndo chihin yu,” cua cati yu. ");
INSERT INTO mioNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tacan, ta cua cati ndico tahan ñi ti: “Ra chahnu, ña tuhva ndi ndehe ndi ti chisoco cun, ta neti cun nduta, ta toho cuun chica cuu cun, ta chacunami cun sahma lahnda, ta cuhvi cun, ta chacuindi cun ve caa, ta ña tindee tahan ndi chihun,” cua cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tacan cuu, ta cua cati ndico ra chi ñi ti: “Cati ndicha yu chihin ndo ti ña tindee ndo chihin yu, vati ña tindee tahan ndo chi ñivi ndahvi yu,” cua cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tacan, ta cua quee ñi cuhun ñi nu cua cutuni ñi, ta ñivi cha iyo vaha anima cua coo ndito ñi chi ra Ndioo ndihi ni quivi ndihi ni tiempu ―cati ra Jesuu chi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tacan cuu, ta cha ndihi cati tuhun ra Jesuu ndihi tuhun can chi ra sacuaha chi ra, ta quechaha cati ra chi ra ta ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Chito ndo ti tichi uvi quivi cua coo vico cuenda cha ni quee ñivi yo ñuhun Egipto tiempu chahnu. Cua coo vico can, ta cua xico tuhun ñivi chi ra cuu sehe ñivi, ta cua cahni ñi chi ra, vati cua taa ñi chi ra nu cruu ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tacan cuu, ta nducuiti ra sutu chahnu chi ra chanihin vehe ra sutu chahnu nani Caifás, ");
INSERT INTO mioNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ta nanducu xini ra ta ra, vati cua sandahyu ñahan ra ta ra chi ra Jesuu, ta cua tiin ra ta ra chi ra, ta cua cahni ra ta ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","soco cati ra ta ra ti: ―Ña cua tiin yo chi ra tichi maan vico can, coto cua cuvaa ñivi ―cati ra chi tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Cha queta ra Jesuu ñuun Betania can, ta iyo ra vehe ra Simón ra ni cuhvi cuehe tahyu nu quichi quivi. ");
INSERT INTO mioNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tacan cuu, ta tuhva iin ñahan nuun ndaa ra, ta naan ña iin cha indi nduta xico vixin chahan. Yahvi xaan nduta can, ta choso ña chi chi xini ra Jesuu nu ndaa ra yu mesa. ");
INSERT INTO mioNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ndehe ra sacuaha chi ra Jesuu cha ni savaha ña ñahan can, ta nduxaan ra ta ra. Quechaha cati ra ta ra chi ña ti: ―Ña vaha cha sandoyo ñuhun cun nduta can, vati cuu xico yo chi chi, ");
INSERT INTO mioNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","vati yahvi xaan chi. Tacan cua nihin yo suhva xuhun cua samani yo chi ñivi ndahvi ―cati ra chi ña. ");
INSERT INTO mioNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Chito ra Jesuu cha cahan ra ta ra, ta quechaha cati ra chi ra ta ra ti: ―Ña vaha cha cahan yuhu ndo chi ñacan, vati taqui xaan cha ni savaha ña chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ndihi ni tiempu cua coo ñivi ndahvi chi ndo, soco suhva ca quivi ni cua coi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cha choso ña nduta xico vixin chahan can cuñu yu, vati tacan tiso vaha ña cha cua cuchi yu. ");
INSERT INTO mioNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cati ndicha yu chihin ndo ti ndihi nu cua cati tuhun ñivi tuhun vaha ya nini cahnu nu ñuhun ñuñivi ya cua cuhva ñi cuenda cha ni savaha ña. Tacan ni cua cuñuhun ini ñi chi ña ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tacan cuu, ta quee iin ra sacuaha chi ra Jesuu, ta cuahan ra. Ra nani Juda Iscariote cuu ra, ta cuahan ra nuun ra sutu chahnu ta ra, ");
INSERT INTO mioNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ta nducu tuhun ra chi ra ta ra ti: ―¿Yoso xuhun cua cuhva ndo chihin yu, ta cua xico tuhin chi ra Jesuu? ―cati ra. Tacan cuu, ta tiahvi ra ta ra oco uchi tahan xuhun cuichin chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ta nda hora can nducu ra Juda can cuhva cha cua xico tuhun ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Quivi quechaha sacahnu ñivi vico paan ña ndaa can, ta quichi ra sacuaha chi ra Jesuu, ta quechaha nducu tuhun ra ta ra chi ra ti: ―¿Ndaa cuu nu cuni cun cha cua tiso vaha ndi cha cua sacahnu yo vico ya? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ta cati ndico ra ti: ―Cuahan ndo iti ñuun Jerusalén nuun iyo ra cuu amigu yu, ta cati ndo chi ra ti cha cati ra maestru ti cha yatin cua queta hora ra. Cua sacahnu ra vico ya chi ra sacuaha chihin ra vehun, cua cati ndo ―cati ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tacan cuu, ta savaha racan ta ra cuhva cha ni cati tuhun ra Jesuu chi ra, ta tiso vaha ra ta ra nu cua sacahnu ra ta ra vico can, vati cua cachi ra ta ra chi ri mbee. ");
INSERT INTO mioNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cha cuaa quivi can nducuiti ra ta ra, ta yu mesa ndaa ra Jesuu chi ndihi uchi uvi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ni vii chachi ra ta ra, ta quechaha cati ra Jesuu chi ra ta ra ti: ―Cati ndicha yu chihin ndo ti cua xico tuhun iin ndo chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ndahvi xaan quechaha cuni ndihi ra ta ra, ta ta iin ta iin ra quechaha cati chi ra ti: ―Ñavi yuhu cui, ra chahnu ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ta cati ndico ra chi ra ta ra ti: ―Cha ni tihi tahan ra ndaha ra chihin yu tichi coho ya icaa ni. Racan cuu ra cua xico tuhun chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Cua cuvi ra cuu sehe ñivi cuhva cati tutu Ndioo, soco tu ndoho cua tahan ra cua xico tuhun chi ra. Vaha xaan ca cha ña cacu cuii ni racan ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ra Juda cuu ra cua xico tuhun chi ra, ta suvi ra cati chi ra ti: ―Ñavi yuhu cui, maestru ―cati ra. Ta cati ndico ra Jesuu chi ra ti: ―Cati maun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ni vii chachi ra ta ra, ta quihin ra Jesuu paan can, ta ni chaha ra iin tiahvi ndioo chi ra Ndioo, ta ni natahvi ra chi chi, ta ni chaha ra chi chi chi ra sacuaha chi ra, ta cati ra ti: ―Cua quihin ndo chi chi, vati cua cachi ndo chi chi. Paan ya cuu cuñu yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tacan cuu, ta quihin tahan ra copa can, ta chaha tucu ra iin tiahvi ndioo chi ra Ndioo, ta chaha ra chi chi chi ra ta ra, ta cati ra ti: ―Ndihi ndo cua coho ndo nduta ya, ");
INSERT INTO mioNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","vati chehe cuu niñi yu, vati cha iyo vaha tuhun chi ra Ndioo cha cua cati yu niñi yu cuenda ndihi ñivi. Chacan cuu cha cua naan cuati savaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Chahi cuenda chi ndo ti ña cua coho que nduta chiti uva ya nda cua nda quivi cua coi chi ndo icaa ni nu cua cundaca ñahan suti ―cati ra chi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Chita ra Jesuu iin yaa chi ra sacuaha chi ra, ta quee ra ta ra cuahan ra iti yucu Olivo. ");
INSERT INTO mioNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tacan cuu, ta quechaha cati ra Jesuu chi ra ta ra ti: ―Vitin cha cuaa ya cua ndoyo ñuhun ndihi ndo cuenda yu, vati cha cati tutu Ndioo ti cua cuvi ra cuu sava ni ta cua iin ra cumi chi ri mbee, ta cua cuita cuati ri, cati chi. ");
INSERT INTO mioNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tacan, ta cua natacu ndico yu, ta sa cua cuhin iti nuun ndo iti ñuhun Galilea ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ta cati ndico ra Pedro chi ra ti: ―Vasi cua ndoyo ñuhun ndihi ca ra ta ra cha cuenda cun, soco yuhu―ña cua ndoyo ñuhin cuenda cun ―cati ra Pedro can. ");
INSERT INTO mioNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ta cati ra Jesuu chi ra ti: ―Cati ndicha yu chihun ti vitin cha cuaa ya cha ña ta ndahyu ri chitoho cua cati cun ti ña nacoto cun chihin yu uni hora ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ta cati ndico tucu ra Pedro chi ra ti: ―Tu nini xaan cha cua cuvi tahin chihun, soco ña cua cati yu ti ña nacote chihun ―cati racan. Ta ni cuhva cati ndihi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tacan cuu, ta cuahan ra Jesuu chi ra sacuaha chi ra nu Getsemaní, ta cati ra chi ra ta ra ti: ―Ihya cua cunda nuun ndo, vati cua cuhin tican, ta cua cahan xihne chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tacan, ta quihin ra chi ra Pedro chi nduvi ra cuu sehe ra Zebedeo, ta quechaha iyo xaan tu cuihya ini chi ra, ta saxini xaan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tacan cuu, ta quechaha cati ra chi ra ta ra ti: ―Cuihya xaan cuni anime. Chacan cuu cha cuni cuvi yu. Cuatu nuun ndo ihya, ta ña cua cusu ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Cuahan ra suhva ca iti nuun, ta taa ra nuun ra nda nu ñuhun, ta quechaha cahan ndahvi ra chi ra Ndioo, ta cati ra ti: ―Tata, tu cha cua cuu, na ña cua yahi tu ndoho ya, soco ña cua savahun cuhva cuni yu. Cua savahun cuhva cuni maun ―cati ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tacan cuu, ta cuahan ndico ra Jesuu nu iyo ra sacuaha chi ra, ta ndehe ra ti cha quixi ra ta ra, ta quechaha cati ra chi ra Pedro ti: ―Ña ni cuu coo ndito ndo ni iin hora ni chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Na cua coo ndito ndo, ta cua cahan ndo chi ra Ndioo. Chacan cuu cha ña cua savaha ndo cha ndavaha ni. Cuni ndo coo ndito ndo chi anima ndo, soco ña cundee ini ndo ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Inga chaha cuahan ndico tucu ra Jesuu, ta cahan ndahvi ndico tucu ra chi ra Ndioo, ta cati ra ti: ―Tata, tu ña cua cuu yaha chehe, tu cha nini xaan cua tahin tu ndoho ya, na cua cuu chi cuhva cha cuni maun ―cati ra chi sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tacan, ta cuahan ndico tucu ra nu iyo ra sacuaha chi ra, ta ndehe ra ti cha quixi tucu ra, vati ña cundee nuun ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nacoo ndico tucu ra chi ra ta ra inga chaha. Uni chaha cuu chacan, ta cahan ndahvi ndico tucu ra chi ra Ndioo, ta ini tuhun can cahan ndico tucu ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tacan cuu, ta cuahan ndico ra nu iyo ra sacuaha chi ra, ta cati ra chi ra ta ra ti: ―Cusu nuun ndo suhva ca hora, ta na cua quee tatun ndo. Vitin cha queta hora, ta cua tiin ñivi ndavaha ni chi ra cuu sehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ndoyo ndo, ta na coho. Cha vachi ra cua xico tuhun chihin yu ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ni vii cahan ra Jesuu chi ra sacuaha chi ra, ta quichi tuhva ra Juda nu iyo ra. Suvi ra sacuaha chi ra Jesuu cuu ra Juda can, ta quichi tahan ñivi chi ra. Tuvi suhva ñivi quichi chi ra, ta naan ñi cha cuu ta iin machete. Naan ñi garote. Naan ñi, ta quichi tahan ra sutu chahnu chi ra chanihin. ");
INSERT INTO mioNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Cha ni cati ra xico tuhun can chi ra ta ra ñaan cuhva cua savaha ra, ta cua coto ra ta ra yochi cua tiin ra ta ra, vati cati ra chi ra ta ra ti: ―Cua taa yuhi chi ra. Chi racan cua tiin ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tacan cuu, ta quii xaan ni tuhva ra nu inda ra Jesuu, ta quechaha cati ra chi ra ti: ―Na cumi chun, maestru ―cati ra. Ta taa yuhu ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ta cati ndico ra Jesuu chi ra ti: ―Na cumi chun, xaa. ¿Ñaan tiñu vachi cun? ―cati ra. Tacan cuu, ta tuhva ra ta ra nu inda ra Jesuu, ta tiin ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tacan cuu, ta tava iin ra cha iyo chi ra Jesuu cha cuu ta iin machete ra, ta cani ra chi ra cuu musu ra sutu chahnu can, ta salaxin ra soho ra ndahvi can. ");
INSERT INTO mioNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tacan cuu, ta cati ra Jesuu chi ra ti: ―Tihi ndico cun machete cun tichi vena cun, vati cua cuvi ndihi ñivi cuni cani tahan chi machete ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tu cua cuni yu, cua cuu cahin chi suti, ta quii quii ni cua tava tiñu ra chi ndihi ra tatun Ndioo nu iye, ");
INSERT INTO mioNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","soco tu tacan cua savaha ra, ña cua cuu queta cuhva cati tutu Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Suvi ni hora can cati ra Jesuu chi ndihi ñivi can ti: ―Vachi ndo, ta naan ndo machete. Naan ndo garote. Naan ndo, ta cua tiin ndo chihin yu cuhva tiin ndo chi rai cuni cahni suhu. Ndihi quivi ni chacunde ve ñuhun, ta sacuahi chi ndo, ta ña tiin ndo chihin yu, ");
INSERT INTO mioNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","soco tacan ni cua tahin, vati tacan cua cuinu tuhun cuhva cha ni taa ra ni cahan cuenda ra Ndioo tiempu chahnu ―cati ra Jesuu. Tacan cuu, ta nacoo ihni ndihi ra sacuaha chi ra Jesuu chi ra, ta ca chinu ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tacan tiin ñivi can chi ra Jesuu, ta chandaca ñi chi ra nu iyo ra Caifás ra sutu chahnu can. Ican cha nducuiti tahan ra sacuaha ley chahnu chi ra chanihin ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ndicu ra Pedro chi ra Jesuu, soco cani vihi ndicu ra chi ra nda ni queta ra yu tihyo ra sutu chahnu can. Quihvi ra, ta ni chacunda tahan ra chi ra cuu musu can, vati cua ndehe ra yoso cua quee tiñu can. ");
INSERT INTO mioNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nducu ra sutu chahnu can chi ndihi ra cumi tiñu can yoo ñivi cua cuu testigu, ta cua sandahyu ñahan ñi cuenda ra Jesuu, vati tacan ni cua cuu nihin ra ta ra cuhva cha cua cuvi ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","soco ña nihin ra ta ra cuhva. Tuvi ñivi cuu ñi quichi, vati cua sandahyu ñahan ñi, soco ña ni nihin ñi cuhva. Tacan, ta quichi tahan uvi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ta quechaha cati ra ta ra ti: ―Cha cati ra Jesuu ti cua cuu cani ra ve ñuhun Ndioo ya, ta tichi uni quivi cua sandaa ndico ra chi chi, cati ra ―cati racan ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tacan, ta chacuinda ra cuu sutu chahnu can, ta quechaha nducu tuhun ra chi ra Jesuu ti: ―¿Atu ña cua cati ndico cun cha tiso rahya ta ra cuati cun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ta taxin taxin ndoo ra Jesuu, ta cati ndico ra sutu chahnu can chi ra ti: ―Cati tuhin chihun cuenda ra Ndioo ndito, vati cua cati ndico cun chi ndi, tu ra Cristo ra cuu sehe Ndioo cuu cun ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ta cati ra Jesuu chi ra ti: ―Yuhu cui, soco cati yu chihin ndo ti nda vitin ta nda cua nda iti nuun cua ndehe ndo ti ndaa ra cuu sehe ñivi iti chiyo ndaha cuaha ra iyo ndihi cuii tu ndee ini, ta cua queta quivi cua quichi ra tichi vico iti siqui andivi ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tacan cuu, ta tiin ra sutu chahnu can sahma suvi ni maan ra, ta chahnda ra chi chi, vati yaha cuhva cha nduxaan ra tuhun cahan ra Jesuu, ta cati ra ti: ―Cha ni cahan ra iin ndavaha ni cuenda ra Ndioo. Ña chini ñuhun ca yo testigu, vati cha chini soho maan ndo ndavaha ni cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Yoso cua cati ndo? ―cati ra chi tahan ra. Ta cati ndico ra ta ra ti: ―Iyo cuati ra cha cua cuvi ra ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tacan cuu, ta tivi sivi ra ta ra nuun ra Jesuu, ta cani ra ta ra chi ra. Chi yutun cani ra ta ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ta quechaha cati ra ta ra chi ra ti: ―Yoho Cristo, cua cati ndico cun chihin ndi. ¿Yoo cani chihun? ―cahan cateni ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ndaa ra Pedro nu tihyo can chata vehe, ta tuhva iin ña musu nu ndaa ra, ta quechaha cati ña ti: ―Cha chica tahun chi ra Jesuu ra quichi iti ñuhun Galilea ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ta cati ndico ra iti nuun ndihi ñivi can ti: ―Ña chite ñaan cha cahun ―cati ra chi ña cha sandahyu ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Cha cua quee ra Pedro yu tihyo can, ta ndehe inga ña musu chi ra, ta quechaha cati ña chi ñi iyo ican ti: ―Cha chica tahan rahya chi ra Jesuu ra ñuun Nazaret ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ndurai xaan ra Pedro can, ta inga chaha cati ndico ra ti: ―Ña nacote chi racan ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Inga suhva ca hora, ta tuhva ñi inda tican nu iyo ra Pedro, ta quechaha cati ñi chi ra ti: ―Ndicha ndicha ti chica tahun chi ra Jesuu, vati cahun cuhva cahan ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tacan cuu, ta quechaha cahan rai ndico tucu ra cuenda ra Ndioo, ta cati ra ti: ―Ña nacote chi racan ―cati ra. Ta quii xaan quechaha ndahyu ri chitoho, ");
INSERT INTO mioNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ta chacuhun ini ra tuhun ni cahan ra Jesuu, vati cati ra ti uni hora cua cati ra ti ña nacoto ra chihin ra, ta sa cua ndahyu ri chitoho. Tacan, ta quee ra tican, ta quechaha ndahvi xaan cuni ra, vati cuihya xaan cuni anima ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tacan cuu, ta tuvi inga quivi. Ni vii nahan, ta nducuiti tucu ra sutu chahnu chi ra chanihin, ta tiso ra ta ra tuhun ti cua cuvi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tacan cuu, ta chuhni ra ta ra chi ra Jesuu, ta ni chandaca ra ta ra chi ra, ta chaha cuenda ra ta ra chi ra Pilato ra cumi tiñu cha iyo cuenda ñuun Roma. ");
INSERT INTO mioNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tacan cuu, ta ndehe ra Juda ra xico tuhun chi ra Jesuu ti cha cua cutuni ra Jesuu, ta quechaha saxini ndico tucu ra, ta cundaca ndico ra ndihi oco uchi xuhun cuichin can chi ra sutu chahnu chi ra chanihin, ");
INSERT INTO mioNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ta quechaha cati ra chi ra ta ra ti: ―Cuati xaan cha ni savahi, vati ni xico tuhin chi ra, ta ñahni cuati savaha ra ―cati ra. Ta cati ndico ra ta ra chi ra ti: ―Ñahni cha saxini ndi cuenda chacan. Ndehe maun ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tacan, ta cani ra xuhun tichi ve ñuhun can, ta quee ra cuahan ra, ta chata caa ra suvi ni chi maan ra, ta chihi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Quihin ra sutu chahnu ta ra xuhun can, ta quechaha cati ra ta ra ti: ―Ña vaha cha cua quihin yo xuhun ya, ta cua tihi yo chi chi nu iyo xuhun ve ñuhun, vati cha ni satiñu chi, ti cua cuvi iin ñivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tacan, ta nanducu xini ra ta ra, ta chi xuhun can sata ra ta ra iin ñuhun nu quee ndahyu savaha ñivi quisi. Ican cuchi toho quichi inga ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chacan cuu cha cati ñivi nda cua nda vitin ti ñuhun can cuu ñuhun sata ñivi chi niñi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tacan cuu, ta queta tuhun cha cahan ra Jeremía ra ni cahan cuenda ra Ndioo tiempu chahnu, vati cati ra ti ni quihin ra ta ra oco uchi xuhun cuichin, vati chacan cuu yahvi ni tiso ra cuu ñivi Israel, tu cua xico tuhun ñivi chi iin rai, ");
INSERT INTO mioNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ta chaha ra ta ra xuhun can, ta sata ra ta ra ñuhun nu quee ndahyu chinu quisi cuhva ni cati tuhun ra chahnu chihin ra, cati ra nu quichi quivi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ni chacuinda ra Jesuu iti nuun ra Pilato ra cuu cumi tiñu cuenda ñuun Roma, ta quechaha nducu tuhun ra cumi tiñu can chi ra ti: ―¿Atu maun cuu ra ndaca ñahan chi ñivi judío? ―cati ra Pilato can. Ta cati ndico ra Jesuu chi ra ti: ―Cha cati maun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tiso ra sutu chahnu chi ra chanihin cuati ra Jesuu, soco ñahni cha cati ndico ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tacan cuu, ta cati ra Pilato chi ra Jesuu ti: ―¿Atu ña chini cun ndihi cuati cun tiso ra ta ra nuin? ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ta taxin ni ndoo ra Jesuu. Ña cahan ra ni iin tuhun. Chacan cuu cha iyo xaan quechaha cuni ra cumi tiñu can. ");
INSERT INTO mioNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cha iyo costumbre chi ra cumi tiñu can ti quivi cha iyo vico can saña ra chi iin ra indi ve caa. Cua saña ra chi ra cuni ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Suvi ni quivi can indi tahan iin ra nani Barabaa, ta chito ndihi ñivi ti cahnu xaan cuati ni savaha ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tacan cuu, ta ni nducuiti ñi ta ñi, ta quechaha cati ra Pilato chi ñi ti: ―Cua cati ndo yoo rai cua cuni ndo cha cua sañe. ¿Atu cuni ndo cha cua sañe chi ra Barabaa a cuni ndo cha cua sañe chi ra Jesuu ra cuu Cristo? ");
INSERT INTO mioNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tacan cati ra, vati chito ra ti chaha cuenda ra ta ra chi ra Jesuu, vati ndusoo cuni ra sutu chahnu ta ra ndehe ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ni vii ndaa ra Pilato nu tachi tuni ra, ta queta tuhun tachi ñasihi ra chi ra. Cati ña ti ña cua tiin ra tiñu cha cahan ñivi cuenda ra cuiti vaha can, vati cha ni cahan ñumahna chihin ña, ta cuaha xaan tu ndoho tahan ña cuenda racan hora can, cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Cati ra sutu chahnu chi ra chanihin chihin ndihi ñivi can ti na cua ndaca ñi chi ra Barabaa, soco na cua cuvi ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ta nducu tuhun ndico tucu ra cumi tiñu can chi ñivi ti: ―Iyo uvi ra ihya. ¿Ndaa ra cuni ndo cha cua sañe? ―cati ra. Ta cati ndico ñi chi ra ti: ―Cua saña cun chi ra Barabaa ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ta nducu tuhun ra Pilato chi ñi ti: ―¿Ñaan cua savahi chi ra Jesuu ra cuu Cristo? ―cati ra. Ta cati ndico ndihi ñi ti: ―Na cua cuvi ra nu cruu ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ta nducu tuhun tucu ra chi ñi ti: ―¿Ñaan cha cuu ndavaha ni cha ni savaha ra? ―cati ra. Ta cuaha xaan ca quechaha ndahyu chaa ñi, ta cati ñi ti: ―Na cua cuvi ra nu cruu ―cati ndico tucu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tacan cuu, ta ndehe ra Pilato can ti ña cua cundee ra, soco cuvaa ca ñi. Chacan cuu cha quihin ra nduta, ta iti nuun ndihi ñivi can nacata ra ndaha ra, ta cati ra ti: ―Ña cua cati yu ti cua cuvi rahya. Cua ndehe maan ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ta cati ndico ndihi ñivi can ti: ―Vaha cha cua cuvi ra, ta cua ndoo chacan siqui maan ndi chi sehe ndi chi ñivi ndi nu cuahan quivi ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tacan cuu, ta saña ra Pilato chi ra Barabaa, soco cani ra chi ra Jesuu chi yoho, ta chaha cuenda ra chi ra, vati cua cuvi ra nu cruu. ");
INSERT INTO mioNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tacan cuu, ta chandaca ra sandaru ra cumi tiñu can chi ra Jesuu tichi vehe ra cumi tiñu can, ta nducuiti ndihi ra tahan ra sandaru can nu iyo ra Jesuu, ta ini cuenda iyo ndihi ra sandaru ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tava ra ta ra sahma ra Jesuu, ta sacundichin ra ta ra iin sahma cuaha. ");
INSERT INTO mioNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Savaha ra ta ra iin tivi iñu, ta tihi ra ta ra chi chi xini ra, ta chaha ra ta ra bastu chi ra na cua cunaan ra chi ndaha cuaha ra. Chahnu chiti ra ta ra iti nuun ra Jesuu, ta sacateni ra ta ra chi ra. Cati ra ta ra chi ra ti: ―Na cumi chi maun, yoho ra ndaca ñahan chi ñivi judío ya ―cati ra sandaru ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tacan cuu, ta tivi sivi ra ta ra chi ra, ta quihin ndico ra ta ra bastu can, ta cani ra ta ra xini ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Cha ndihi sacateni ra ta ra chi ra, ta tava ndico ra ta ra sahma cuaha can, ta sacundichin ndico ra ta ra sahma maan ra chi ra, ta tava ra ta ra chi ra tichi vehe can, ta chandaca ra ta ra chi ra, vati cua cuvi ra nu cruu. ");
INSERT INTO mioNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Quee ra sandaru ta ra. Cuahan ra, ta tahan ra ta ra iin rai ñuun Cirene. Simón nani ra, ta sanini ra ta ra, vati cua cuiso racan cruu ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tacan, ta queta ra ta ra nuun cuu chi Gólgota. Tuhun can cati chi ti nu cuecu iquin xini ndii cuu chi, ");
INSERT INTO mioNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ta chaha ra ta ra nduta chiti uva cua coho ra. Cha sacanuun chi chi iin cha iya xaan. Taa yuhu ni ra chi chi, soco ña cuni ra coho ra chi chi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ni taa ra ta ra chi ra nu cruu, ta siqui ra ta ra chi yuu cuati, vati cua ndehe ra ta ra yoo cua sacanaan. Tacan ni natahvi ra ta ra sahma ra Jesuu. Chacan cuu cha queta tuhun cahan ra ni cahan cuenda ra Ndioo tiempu chahnu, vati cati ra ti natahvi ra ta ra sahma ra, ta siqui ra ta ra chi yuu, vati cua ndehe ra ta ra ndaa ra cua sacanaan sahma ra, cati ra, ");
INSERT INTO mioNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ta ni chacunda ra sandaru ta ra tican, ta cumi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Taa ra ta ra iin vitu siqui xini ra, ta ni taa ra tuhun ya ti: “Rahya cuu Jesuu ra ndaca ñahan chi ñivi judío,” cati chi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tacan cuu, ta taa tahan ra ta ra chi uvi ra ñasuhu nu cruu ican nu ndaa ra Jesuu. Iin ra ñasuhu can ndoo chiyo ndaha cuaha ra, ta inga ra ndoo chiyo ndaha satin ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yaha ñivi tican, ta cahan ñi ndavaha ni chi ra Jesuu. Sacateni ñi chi ra, ta sico xini ñi, ");
INSERT INTO mioNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ta cati ñi ti: ―Yoho cua cani cun ve ñuhun, ta cua sandaa ndico cun chi chi tichi uni quivi. Na sacacu cun suvi ni chi maun, tu sehe Ndioo cuun. Na nuun maun nu cruu can ―cati ñivi yaha iti can. ");
INSERT INTO mioNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ta ni cuhva sacateni tahan ra sutu chahnu chi ra sacuaha ley chahnu chi ra chanihin, ta cati ra ta ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Cati ra ti sacacu ra chi ñivi, soco ña cuu sacacu ra suvi ni chi maan ra. Tu ndaca ñahan ra chi ñivi Israel, na cua nuun ra nu cruu can, ta cua cuinu ini ndi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Chinu ini ra chi ra Ndioo. Na cua sacacu ra Ndioo chi ra vitin, tu cua cuni ra, vati cha cati ra ti sehe Ndioo cuu ra ―cati racan ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ta ni cuhva sacateni tahan ra ñasuhu can cha ndaa tahan ra ta ra nu cruu can. ");
INSERT INTO mioNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ni ndunaan nini cahnu ñuhun can. Ta hora cuiti ta nda caa uni ni ndunaan, ");
INSERT INTO mioNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ta caa uni can nihin xaan quechaha cana chaa ra Jesuu. Quechaha cati ra ti: ―Elí, Elí, ¿lama sabactani? ―cati ra. Tuhun can cati chi ti: “Yoho tata Ndioo, yoho tata Ndioo, ¿ñacu ni nacoo ihni cun chihin yu?” ");
INSERT INTO mioNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chini soho uvi uni ñivi inda ican, ta quechaha cati ñi ti: ―Cana ra chi ra Elía ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ta quii xaan chinu iin ra, ta quihin ra iin yahma, ta satiin ra chi chi chi nduta iya can, ta taa ra chi chi nu tuyoo, ta sayaha ra chi chi na coho ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ta cati ndihi ca ñi ti: ―Saña. Na cua ndehe yo a cua quichi sacacu ra Elía chi ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Inga chaha cana chaa ndico tucu ra Jesuu, ta ni chihi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tacan, ta ni ndata sahma ndita caa tichi ve ñuhun cahnu can. Nda siqui chi ta nda xuu chi ndata maan chi, ta ni taan, ta ndata tahan cava, ");
INSERT INTO mioNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ta nuna ñaña, ta nandoto ndico tuvi ñivi ni chihi. Ñivi iyo cuenda ra Ndioo cuu ñi nandoto ndico, ");
INSERT INTO mioNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ta quee ñi nu caa ñi tichi ñaña, ta yaha cha natacu ndico ra Jesuu, ta sa quihvi tahan ñi ñuun Jerusalén ñuun ii can, ta tuvi ñivi ni ndehe chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Iyo ra sandaru cumi chi ra Jesuu, ta iyo tahan ra ndaca ñahan chi ra ta ra, ta ndehe ra ta ra nu taan, ta ndehe ra ta ra ndihi cha ni chacoo, ta yuhvi xaan ra ta ra cuu, ta quechaha cati ra ta ra ti: ―Ndicha ti sehe Ndioo cuu rahya ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ican iyo tahan tuvi ñi ñahan, ta chica vihi inda ñi ndehe ñi. Ñican cuu ñi quichi chi ra Jesuu iti ñuhun Galilea, ta tindee ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Iyo tahan ña María Magdalena chi ña María sihi ra Jacobo chi ra José, ta iyo tahan sihi ra cuu sehe ra Zebedeo. ");
INSERT INTO mioNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cha cua ini suvi ni quivi can, ta quichi iin ra ricu ican, ta José nani ra. Quichi ra iti ñuun Arimatea, ta sacuaha tahan ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Cuahan ra iti nuun ra Pilato, ta chica ra iquin cuñu ra Jesuu. Tacan cuu, ta cati tuhun ra Pilato ti cua cuhva cuenda ra ta ra chi chi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Quihin ra José can iquin cuñu ra, ta tisucu nuun ra iquin cuñu ra chi iin sahma yaxin vaha, ");
INSERT INTO mioNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ta ni cuchi ra chi ra tichi yavi yuu chaa nu ni nañu ra ta ra, ta sico tuvi ra iin yuu cahnu yuhu chi, ta cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ican iyo tahan ña María Magdalena can chi inga ña María. Iti yuhu yavi yuu can ndaa ñi ta ñi. ");
INSERT INTO mioNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Cha yaha quivi cha ni tiso vaha ñi cha cua sacahnu ñi vico can, ta tuvi inga quivi. Quivi can nducuiti ra sutu chahnu chi ra fariseo nuun ra Pilato, ");
INSERT INTO mioNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ta quechaha cati ra ta ra chi ra cuenda ra Jesuu ti: ―Ra chahnu, ni ñuhun ini ndi ti ni vii ndito ra vata can, ta cati ra ti cua yaha uni quivi, ta cua natacu ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chacan cuu cha na cua cati tuhun cun ti cua cumi ra sandaru nu ni cuchi ra nda cua nda cua queta uni quivi, coto cua suhu ra sacuaha chi ra iquin cuñu ra, ta cua cati ra ta ra chi ñivi ti cha ni natacu ndico ra tañu ñivi ndii, ta cahnu ca cha cua sandahyu ñahan ra ta ra, ta ñavi ca cha sandahyu ñahan maan ra nu quichi quivi ―cati ra judío can ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ta cati ndico ra Pilato chi ra ta ra ti: ―Cua quihin ndo chi ra sandaru can ta ra. Cuahan ndo, ta cua cu cumi ndo chi chi yoso cuu chi ndo ―cati ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Cuahan ra ta ra, ta chasi nihin ra ta ra yavi yuu can chi yuma quixi, ta nacoo ra chi ra sandaru ta ra na cua cumi ra ta ra ican. ");
INSERT INTO mioNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cha ni yaha quivi sábadu, ta cha cua tuvi inga quivi cha cuu chi domingu, ta cuahan ña María Magdalena chi inga ña María, vati cua ndehe ñi nu ni cuchi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nihin xaan ni taan, ta vachi nuun iin ra tatun ra chahnu Ndioo iti siqui andivi. Tuhva ra nu caa yuu can, ta sachiyo ra chi chi, ta ni chacunda ra siqui chi. ");
INSERT INTO mioNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sava ni ta cua iin tachan ndehe ra tatun Ndioo can, ta cuichin cuichin sahma ra cuhva cuichin xaan hielo. ");
INSERT INTO mioNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nihin xaan naquisi chi chi ra sandaru cumi ican, vati yuhvi ra, ta nduva ihni ra. Caa ra cuhva caa ndii, ");
INSERT INTO mioNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ta cati ndico ra tatun Ndioo can chi ñi ñahan can ti: ―Ña cua cuyuhvi ndo, vati chite ti nanducu ndo chi ra Jesuu ra ni chihi nu cruu. ");
INSERT INTO mioNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ña iyo ca ra ihya, vati cha ni natacu ndico ra cuhva ni cati ra. Nahan ndo, vati cua ndehe ndo nu ni chacava ra. ");
INSERT INTO mioNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Cuahan yatin ndo, ta cati ndo chi ra ni sacuaha chi ra, vati ni natacu ndico ra tañu ñivi ndii, ta cuahan ra iti nuun ndo iti ñuhun Galilea. Tican cua ndehe ndo chi ra. Chini ndo, vati cha cati yu chihin ndo ―cati ra tatun Ndioo can. ");
INSERT INTO mioNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tacan, ta quee ñi nu ni cuchi ra, ta cuahan ñi. Quii xaan cuahan ñi. Yuhvi ñi, ta sii cuni ñi, ta chinu ñi cuahan ñi, vati cua cuhva ñi cuenda chi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tacan cuu, ta satahan ra Jesuu chi ñi, ta nducahan ra chi ñi. Tuhva ñi nu inda ra, ta chahnu chiti ñi chaha ra, ta sacahnu ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tacan cuu, ta cati ra chi ñi ti: ―Ña cua cuyuhvi ndo. Cuahan ndo, ta cuhva ndo cuenda chi ñi sacuaha chihin yu, vati cua cuhun ñi iti ñuhun Galilea, ta tican cua ndehe ñi chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ni vii cuahan ñi ñahan can, ta queta uvi uni ra sandaru ñuun, ta chaha ra ta ra cuenda chi ra sutu chahnu ta ra ñaan ndihi cuhva ni tahan ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tacan, ta nducuiti ra sutu chahnu can chi ra chanihin, ta nanducu xini xaan ra ta ra ñaan cha cua savaha ra. Cha suhva xuhun quihin ra ta ra, ta ni chaha ra ta ra chi chi chi ra sandaru can ta ra, ");
INSERT INTO mioNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ta cati ra ta ra chi ra sandaru ti: ―Cua cati ndo ti cha cuaa xaan, ta ni quixi ndo suhva, ta quichi ra sacuaha chi ra, ta suhu ra ta ra iquin cuñu ra, cua cati ndo, ");
INSERT INTO mioNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ta tu cua queta tuhun ya nuun ra cumi tiñu can, cua sandumani ndi chi ra, ta cua casi maan ndi. Ña cua tichaha ni ndo ―cati ra sutu chahnu ta ra chi ra sandaru can. ");
INSERT INTO mioNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tacan cuu, ta quihin ra sandaru xuhun can, ta savaha ra ta ra cuhva cha ni cati ra sutu chahnu ta ra. Chacan cuu cha cati ñivi judío tuhun can chi tahan ñi nda cua nda vitin. ");
INSERT INTO mioNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tacan cuu, ta cuahan ndihi uchi iin ra sacuaha chi ra Jesuu iti ñuhun Galilea. Cuahan ra ta ra iti yucu nu ni cati ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ta ican ndehe ra ta ra chi ra, ta sacahnu ra ta ra chi ra, soco ña chinu ini uvi uni ra. ");
INSERT INTO mioNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ni tuhva ra Jesuu nu inda ra ta ra, ta quechaha cati ra chi ra ta ra ti: ―Iyo ndihi cuii tu ndee ini cha iyo iti siqui andivi ta nu ñuhun ñuñivi ya chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chacan cuu cha na cua cuhun ndo, ta na cua sacuaha ndo chi ñivi ndihi ñuun nu ñuhun ñuñivi ya. Cua sacuanduta ndo chi ñi cuenda ra cuu suti ta cuenda ra cuu sehe ra ta cuenda ra cuu Tati Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Cua cati tuhun ndo chihin ñi ti cua sacuinu ñi ndihi cha cati tuhin chi ndo. Tacan ni cua sacuaha ndo chihin ñi. Cua coi chi ndo ndihi ni quivi nda cua nda cua cundihi quivi ya. Na cua cuu chi tacan ni ―cati ra Jesuu chi ra sacuaha chi ra.");
INSERT INTO mioNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tuhun ya cuu tuhun vaha yoso cuhva quechaha coo ra Jesucristo nu ñuhun ñuñivi ya, ta sehe Ndioo cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Rai ni cahan cuenda ra Ndioo tiempu chahnu cuu ra Isaía, ta ni taa ra tuhun ya cuhva ni cati ra Ndioo cuenda ra cua tava tiñu ra, vati cati ra nu quichi quivi ti: Chini cun. Cha ni tava tiñu yu iin tatun yu iti nuun cun. Cua tiso vaha ra tiñu iti nu cua yaha cun. ");
INSERT INTO mioNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Cua cana chaa maan ra tichi cuhu, ta cua cati ra ti cua tahvi ñivi iti nu cua yaha ra chahnu. Cua tiso vaha ñi tiñu nu cua quichi ra, cua cati ra, cati ra Isaía can tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chacan cuu cha ni sacuanduta ra Juaan can chi ñivi tichi cuhu, ta cati tuhun ra ti na cua saña ihni ñivi cuati ndacu ñi, ta na cua cuanduta ñi. Chacan cuu cha cua naan cuati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Quee ndihi ñivi iyo nini cahnu ñuhun Judea, ta quee tahan ndihi ñivi iyo ñuun Jerusalén, ta cuahan ñi ta ñi nu iyo ra Juaan, ta ni sacuanduta ra chi ñi tichi yuta Jordán can, vati ni chaha ñi cuenda chi ra Ndioo ti ña vaha cha ni savaha ñi cuati. ");
INSERT INTO mioNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ta ndichin ra Juaan can sahma ixi ri camellu, ta nuhni iin cinta ñiin tichi ra. Chachi ra tica, ta chihi ra nduxi ñuñu cuhu, vati cuhva can ni chacoo ra cahan cuenda ra Ndioo tiempu chahnu, ");
INSERT INTO mioNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ta cati tuhun ra Juaan can ti: ―Vachi iin rai cahnu xaan iti chate, ta ni ña ni cuu chacunda tohi, ta ndachi yu tiendu ndicha ra, vati ñahni yavi ndai. ");
INSERT INTO mioNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yuhu ndicha ni sacuandute chi ndo chi nduta, soco racan cua cuhva cha cua coo ra Tati Ndioo chi ndo, ta cuhva cha sacuanduta ra chi ndo cuu chacan ―cati ra Juaan can. ");
INSERT INTO mioNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Suvi ni quivi can quichi ra Jesuu iti ñuun Nazaret cha iyo cuenda ñuhun Galilea, ta sacuanduta ra Juaan chi ra tichi yuta Jordán can. ");
INSERT INTO mioNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sa ni quee ndico ra Jesuu yu nduta can, ta ndehe ra cha ni nuna iti siqui andivi, ta vachi nuun maan ra Tati Ndioo nu inda ra. Ni vii cuhva cha nuun iin ri ndivi nuun ra Tati Ndioo, ");
INSERT INTO mioNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ta ni nducahan ra Ndioo iti siqui andivi, ta cati ra ti: ―Yoho, sehi chihun. Cuni xain chihun, ta cusii ini yu chihun ―cati ndusu can. ");
INSERT INTO mioNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Suvi ni hora can sanini maan ra Tati Ndioo ti na cua cuhun ra Jesuu tichi cuhu. ");
INSERT INTO mioNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Uvi xico quivi ni chacoo ra tichi cuhu can, ta nducu maan run Satanaa cuhva cha cua savaha ra Jesuu iin cha ndavaha ni. Tacan, ta ni chacoo ra Jesuu nu iyo ri quiti cuhu can, ta tindee ra tatun Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tacan cuu, ta tiin tiñu chi ra Juaan, ta taa ra chi ra ve caa. Tacan, ta cuahan ra Jesuu iti ñuhun Galilea. Cati tuhun ra tuhun vaha yoso cuhva iyo ra Ndioo, ");
INSERT INTO mioNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ta cati ra ti: ―Vitin cha ni queta quivi, ta yatin xaan cua cundaca ñahan ra Ndioo. Cua saña ihni ndo cuati ndacu ndo, ta na cua cuinu ini ndo tuhun vaha ya ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yaha ra Jesuu yuhu tañuhun Galilea can, ta quechaha ndehe ra chi ra Simón chi Ndree yani ra. Cani ra ta ra taraya ra nu nduta tañuhun can, vati rai chahni tiaca cuu ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ta quechaha cati Jesuu chi ra ta ra ti: ―Nahan ndo. Na cua coo ndo chihin yu, ta cua savahi cha cua nanducu ndo chi ñivi cuhva cha nanducu ndo chi ri tiaca ―cati ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Quii xaan ni saña ihni ra ta ra taraya ra, ta cuahan ra. Ndicu ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tacan cuu, ta yaha ra Jesuu suhva ca iti nuun, ta ndehe ra chi ra Jacobo chi Juaan yani ra. Sehe Zebedeo chi ra ta ra. Ni vii indi ra ta ra tichi tundoo, ta nataa ra ta ra taraya ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tacan, ta sa ni cana ra Jesuu chi ra ta ra, ta nacoo ra ta ra chi ra Zebedeo sutu ra chi musu ra tichi tundoo can, ta quee ra cuahan ra. Ndicu tahan ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tacan cuu, ta cuahan ra ta ra iti ñuun Capernaum. Quivi sábadu quivi ndaa tatun ñivi cuu chi, ta quihvi ra Jesuu tichi ve ñuhun, ta quechaha sacuaha ra chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iyo xaan cuni ñivi can chini ñi tuhun cha sacuaha ra, vati sacuaha ra chi ñi cuhva sacuaha iin rai iyo tu ndee ini, ta ñavi cuhva sacuaha ra chito ley chahnu can. ");
INSERT INTO mioNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Iyo iin rai tichi ve ñuhun can, ta ñuhun tati cuihna anima ra, ta quechaha cana chaa ra, ");
INSERT INTO mioNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ta cati run tati cuihna can ti: ―Chite ñaan cha cuu cha cuni cun chihin ndi, yoho Jesuu ra ñuun Nazaret. Cha vachi cun, vati cua cahni cun chihin ndi. Chite yoo rai cuun. Maun cuu ra ii cha ni tava tiñu ra Ndioo ―cati run. ");
INSERT INTO mioNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ta xaan xaan quechaha cahan ra Jesuu chi run tati cuihna can, ta cati ra chi run ti: ―Casi yuhun, ta queun tichi anima ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tacan cuu, ta chahni rai run tati cuihna can chi ra ndahvi can, ta nihin xaan cana chaa run, ta quee run tichi anima ra, ");
INSERT INTO mioNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ta iyo xaan quechaha cuni ndihi ñivi can. Chacan cuu cha nducu tuhun ñi chi tahan ñi ti: ―¿Ñaan cha cuu chehe? ¿Atu tuhun chaa cuu chi, vati iyo ndatu chi ra? Cha tava ra chi run tati cuihna can, ta ni tasoho run chi ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tacan, ta quii xaan chini soho ndihi ñivi nini cahnu ñuhun Galilea can tuhun yoso cha ni savaha ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Quee ra ta ra ve ñuhun can, ta cuahan ra. Queta ra ta ra vehe ra Simón chi ra Ndree, ta cuahan tahan ra Jacobo chi ra Juaan. ");
INSERT INTO mioNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Caa ña cha vaha chiso ra Simón, vati cuhvi ña cahni, ta sa ni nducahan ñi chi ra Jesuu ti cha cuhvi ña. ");
INSERT INTO mioNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tuhva ra nu caa ña, ta tiin ra ndaha ña, ta sandoyo ra chi ña. Suvi ni hora can ndico cahni chi ña, ta quechaha tiso ña mesa iti nuun ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Cha cua ini xaan quivi can, ta cua cuiso ri nicandi, ta chandaca ñivi chi ndihi ñivi cuhvi chi ndihi ñivi iyo tati cuihna anima nu iyo ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tacan, ta nducuiti ndihi ñivi ñuun can yu vehe, ");
INSERT INTO mioNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ta iyo cuiti tuvi xaan ñivi cuhvi chi ndihi nuun cuehe can, ta sanduvaha ra Jesuu chi ñi, ta tava xaan ra cuaha tati cuihna ñuhun anima ñi, soco ña ni chaha ra cha cahan run tati cuihna can, vati nacoto run chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ni vii nahan xaan, ta ndoyo ra Jesuu. Ña ta cundichin, ta ndoyo ra, ta quee ra cuahan ra tichi cuhu, ta ican cahan ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tacan, ta quechaha nanducu xaan ra Simón chi ñi iyo chi ra ndaa iti cuahan ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nanihin ñi chi ra, ta quechaha cati ñi chi ra ti: ―Nanducu ndihi ñivi chihun ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ta cati ndico ra chi ñi ti: ―Na coho. Cua cuhun yo ndihi ñuun iyo ihya. Chacan cuu cha cua cati tuhun tahin chi ñican, vati chacan cuu tiñu vachi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tacan cuu, ta cuahan ra Jesuu, ta cati tuhun ra tichi ve ñuhun ñi nini cahnu ñuhun Galilea can, ta tava ra tati cuihna ñuhun anima ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tacan cuu, ta tuhva iin rai cuhvi cuehe tahyu nu iyo ra Jesuu, ta cahan ndahvi ra chi ra, ta chahnu chiti ra iti nuun ra. Cati ra chi ra Jesuu ti: ―Tu cua cuni cun sanduvahun chihin yu, cua cuu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Uhvi xaan cuni ra Jesuu ndehe ra chi ra, ta ni sacaa ra ndaha ra, ta taa ra ndaha ra chi ra ndahvi can, ta quechaha cati ra chi ra ti: ―Cuni yu. Na nduvahun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Suvi ni hora can ni naan ihni cuehe can chi ra, ta nduvaha ra, ");
INSERT INTO mioNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ta xaan ni cahan ra Jesuu chi ra, vati cua saña tahan ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Quechaha cati ra Jesuu chi ra ti: ―Chini cun. Ña cua cahun chi ni iin ñivi, soco cuahan, ta sanahun chihun chi ra sutu, ta samani cun cha ni cati tuhun ra Moisee tiempu chahnu, vati ni nduvahun. Tacan ni cua cuhvon cuenda chi ñivi, ta cua ndehe ñi cha ni tahun ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Quee ra cuahan ra, ta quechaha cati tuhun xaan ra chi ñivi, ta chaha ra cuenda ñaan cha cuu cha ni tahan ra. Chacan cuu cha ña cuu ca quihvi ndichin ra Jesuu tichi ni iin ñuun can, soco ndoo nuun maan ra tichi cuhu, ta cuahan ñivi iyo nini cahnu ñuhun can nu iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Cha yaha suhva quivi, ta quihvi tucu ra Jesuu tichi ñuun Capernaum, ta chini ñivi tuhun ti cha iyo ndico ra vehe. ");
INSERT INTO mioNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ni nducuiti tuvi ñivi tican. Chacan cuu cha ña cuu ca queta ñivi yu vehe can, ta cati tuhun ra Jesuu tuhun vaha chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tacan, ta quichi tahan cumi tahan ra. Ndiso ra ta ra chi iin ra nduñiin nu iyo ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ta ña cuu yaha ra ta ra nu iyo ra Jesuu, vati tuvi xaan ñivi iyo. Ndaa ra ta ra nda xini vehe, ta nuna ra ta ra xini vehe can nu indi ra Jesuu. Chahnda ra ta ra nahan xini vehe can, ta ni sanuun ra ta ra yuvi nu caa ra nduñiin can. ");
INSERT INTO mioNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ndehe ra Jesuu ti cha ni chinu ini ra ndiso chi ra ndahvi can, ta quechaha cati ra chi ra ti: ―Cha ni naan cuati iyo chihun, xaa ―cati ra chi ra ndahvi can. ");
INSERT INTO mioNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ndaa uvi uni tahan ra sacuaha ley chahnu tican, ta quechaha saxini xaan ra ta ra chi anima ra. ");
INSERT INTO mioNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Saxini ra ta ra ti ña vaha cha cahan ra tacan. Ndavaha ni cuu chi cha cahan ra cuenda ra Ndioo, vati yoni ñivi ñuñivi cuu sanaan cuati savaha ñivi. Iin tuhun ni ra Ndioo cuu ra cua cuu sanaan cuati ñivi, saxini ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Quii xaan ni chito ra Jesuu yoso cuhva ni saxini ra ta ra chi anima ra, ta quechaha cati ra chi ra ta ra ti: ―Ña vaha cha saxini ndo chi anima ndo tacan. ");
INSERT INTO mioNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ña ii xaan cha cua cati yu chihin ra ti cha naan ndihi cuati cha iyo chihin ra. Ii ca cha cua cati yu ti na cua ndoyo ra, ta cua quihin ra yuvi ra, ta cua cuhun ra. ");
INSERT INTO mioNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Chacan cuu cha cati yu vati cuni yu cha cua coto ndo ti cha iyo ndatu chi ra cuu sehe ñivi ihya nu ñuhun ñuñivi ya, ta cuu sanaan ra cuati savaha ñivi ―cati ra chi ra sacuaha ley can. Ta cati ndico tucu ra chi ra nduñiin can ti: ");
INSERT INTO mioNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Chi yoho cahin. Ndoyo, ta quihin cun yuvi cun, ta cuahan iti vehun ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tacan, ta ni ndoyo ra, ta quihin ra yuvi ra, ta quee ra cuahan ra, ta ndehe ndihi ñivi can. Chacan cuu cha iyo xaan cuni ndihi ñi, ta quechaha sacahnu ñi chi ra Ndioo, vati cati ñi chi tahan ñi ti: ―Ña tuhva yo ndehe yo cha ni savaha rahya nu ni quichi quivi ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tacan cuu, ta quee ndico tucu ra Jesuu, ta cuahan ra. Iti yuhu tañuhun cuahan tucu ra, ta cuahan ndihi ñivi nu iyo ra, ta sacuaha ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Cha cua yaha ra tican, ta ndehe ra nu ndaa ra Leví ra cuu sehe ra Alfeo, ta satiahvi maan ra Leví can xuhun cuenda tiñu chi ñivi, ta quechaha cati ra Jesuu chi ra ti: ―Na coho ―cati ra. Ta ni chacuinda ra Leví can, ta ndicu ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tacan cuu, ta ndecu ra ta ra mesa tichi vehe ra Leví can, ta tuvi ra satiahvi, tuvi ra ndacu ndavaha ni ndecu tahan chi ra Jesuu chi ñivi sacuaha chi ra, vati tuvi ñivi cuu ñi cuahan chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ndehe ra sacuaha ley chahnu can chi ra fariseo ti icaa ni cha chachi tahan ra Jesuu chi ra satiahvi chi ra ndacu ndavaha ni, ta quechaha cati ra ta ra chi ñivi sacuaha chi ra Jesuu ti: ―Ña vaha cha chachi ra Jesuu chi ra satiahvi chi ra ndacu ndavaha ni icaa ni ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ta chini ra Jesuu cha cahan ra ta ra, ta quechaha cati ra chi ra ta ra ti: ―Ña chini ñuhun ñivi iyo vaha chi ra sanduvaha chi ñi, soco ñivi cuhvi cuu ñi chini ñuhun chi ra. Ña cane chi ñivi iyo vaha, soco vachi yu, ta cane chi ñivi ndacu cuati ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Quivi can chacoo ndita ñivi sacuaha chi ra Juaan, ta chacoo ndita tahan ñi sacuaha chi ra fariseo, ta cuahan ñi ta ñi, ta quechaha nducu tuhun ñi ta ñi chi ra Jesuu ti: ―Tuhva ñivi sacuaha chi ra Juaan coo ndita ñi, ta tuhva tahan ñivi sacuaha chi ra fariseo coo ndita ñi, ta ¿ñacu ña tuhva ñivi sacuaha chi maun coo ndita ñi? ―cati ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ta cati ndico ra Jesuu iin cuhva chi ñi ti: ―Cua tandaha iin rai, ta ña cua coo ndita amigu ra quivi cha ni iyo ra chi ñi icaa ni. Quivi cha ni iyo ra chi amigu ra ña cua cuu coo ndita amigu ra, ");
INSERT INTO mioNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","soco cua queta quivi cha cua nacoo ra chi ñi, ta quivi can sa cua coo ndita ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Yoni ñivi cua nataa iin sahma chaa nuun sahma chahnu, coto cua nacaa ndico chi nu nataa sahma chaa chi sahma chahnu can, ta vihi ca cua ndoo chi cha lahnda ca chi. ");
INSERT INTO mioNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yoni ñivi cua tihi nduta chiti uva chaa tichi iin iti ñiin chahnu, coto cua ndata chi cua savaha nduta chiti uva chaa can, ta cua cati nduta can, ta cua ndoyo ñuhun iti ñiin can, soco cua tihi ñi nduta chiti uva chaa tichi iti ñiin chaa. Tacan cati ra Jesuu, vati ña cua cuu natahan tuhun chaa chi tuhun chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tacan cuu, ta iin quivi sábadu quivi cha ndaa tatun ñivi judío, ta yaha ra Jesuu chi ra sacuaha chi ra nu caa itu trigu, ta quechaha yucu racan ta ra xini chi, ");
INSERT INTO mioNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ta quechaha cati ra fariseo chi ra Jesuu ti: ―Ña vaha cha ndacu ra ta ra tacan, vati quivi sábadu cuu chi. Ña chaha ley cuhva can ―cati ra fariseo can. ");
INSERT INTO mioNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Vasi ña ta sacuaha ndo cha ni savaha ra David quivi chini ñuhun ra, ta chisoco ra chi ndihi ra chica chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Quihvi ra tichi vehe Ndioo quivi cha cuu ra Abiatar sutu chahnu, ta chachi ra David can paan cuecu iti nuun ra Ndioo, ta chaha ra cha chachi tahan ra iyo chi ra, soco ña chaha ley cuhva can. Iin tuhun ni ra sutu cuu ra cua cuu cachi paan cuecu iti nuun ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tacan, ta quechaha cati ra Jesuu chi ñivi can ti: ―Savaha ra Ndioo quivi sábadu cha na cua cunda tatun ñivi, soco ña cuni ra cha cua coo ica ñi quivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chacan cuu cha ra cuu sehe ñivi cuu ra cua cati ñaan tiñu cua savaha ñivi quivi sábadu can. Tacan cati ra Jesuu, vati ña vaha ndoo ra fariseo cha yucu ra ta ra chiti trigu can. ");
INSERT INTO mioNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tacan cuu, ta cuahan tucu ra Jesuu ve ñuhun, ta ican iyo iin rai, ta xii ndaha ra, ");
INSERT INTO mioNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ta saha ra fariseo ta ra cuenda a cua sanduvaha ra Jesuu chi ra ndaha xii can quivi sábadu quivi ndaa tatun ñivi, vati cuni ra ta ra tiso ra cuati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tacan, ta quechaha cati ra Jesuu chi ra ndaha xii can ti: ―Cuinda sava mahñu ihya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ta quechaha nducu tuhun ra Jesuu chi ñivi can ti: ―¿Yoso cuhva cati ley cha cuenda quivi sábadu? ¿Atu cua savaha ñivi iin cha vaha a cua cuu savaha ñi iin cha ndavaha ni? ¿Atu cua cuu sanduvaha ñivi chi tahan ñi a cua cuu cuhva ñi cha cua cuvi ñi? ―cati ra chi ñi. Ta taxin taxin ni ndoo maan ñivi can, ");
INSERT INTO mioNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ta xaan xaan ndehe ra Jesuu nuun ñi, soco cuihya xaan cuni anima ra, vati ndava xaan ini ñi, ta ña cuni ñi cuinu ini ñi chi ra, ta cati ra chi ra ndaha xii can ti: ―Sacaa ndahun ―cati ra. Ta ni sacaa ra ndaha ra, ta nduvaha chi, ");
INSERT INTO mioNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ta quii xaan ni quee ra fariseo ta ra, ta nducu ra ta ra cha chini tuni chi ra inda naan chi ra Herode yoso cuhva cua cahni ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Tacan cuu, ta cuahan ndico ra Jesuu chi ra sacuaha chi ra yuhu tañuhun can, ta cuahan tuvi xaan ñivi iyo ñuhun Galilea nu cuahan ra, ta cuahan tahan ñivi quichi iti ñuhun Judea. Ndicu ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Cuahan tahan ñivi quichi iti ñuun Jerusalén, ta cuahan tahan ñivi quichi iti ñuhun Idumea. Cuahan tahan ñivi quichi inga chiyo yuta Jordán chi ñivi quichi iti ñuun Tiro iti ñuun Sidón. Cuahan ndihi ñivi can nu iyo ra Jesuu, vati chini ñi ndihi tuhun cha ni savaha ra, ");
INSERT INTO mioNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ta quechaha cahan ra Jesuu chi ra sacuaha chi ra, vati cuni ra na cua tiso vaha ra ta ra iin tundoo cha cua quihvi ra, coto cua cucuhun tahan ñivi chi ra, vati tuvi xaan ñivi iyo, ");
INSERT INTO mioNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","vati tuvi ñivi cha ni sanduvaha ra Jesuu. Chacan cuu cha ni chacuhun tahan ñivi ndehe tu ndoho nu iyo ra, vati cuni ñi sayani ndaha ñi chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ta sa ndehe tahan run tati cuihna chi ra, ta nduva ni run iti nuun ra, ta cana chaa run, ta cati run ti: ―Yoho cuu sehe Ndioo ―cati run. ");
INSERT INTO mioNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Cuaha xaan nduxaan ra Jesuu chi run, vati ña cuni ra cha cua cuhva run tuhun yoo rai cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tacan cuu, ta ndaa ra Jesuu yucu, ta cana ra ndaa ñi cuni ra, ta nducuiti ñi iti nuun ra, ");
INSERT INTO mioNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ta ni nacachi ra uchi uvi ra cua cuu tatun ra, vati cua coo ra ta ra chi ra. Cua tava tiñu ra chi ra ta ra na cua cati tuhun ra, ");
INSERT INTO mioNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ta na cua coo ndatu chi ra ta ra cha cua sanduvaha ra ta ra chi ñivi cuhvi, ta cua tava ra ta ra tati cuihna iyo anima ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ni nacachi ra Jesuu uchi uvi ra ta ra. Quihin ra chi ra Simón, ta sama ra sivi ra cha cunani tahan ra Pedro, ");
INSERT INTO mioNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ta quihin tahan ra chi ra Jacobo chi ra Juaan yani ra. Sehe Zebedeo chi ra ta ra, ta chaha ra Jesuu sivi Boanerge chi ra ta ra. Rai xaan xaan cuu ra cuu sivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Quihin tahan ra Jesuu chi ra Ndree chi ra Felipe chi ra Bartolomé, ta quihin tahan ra chi ra Mateo chi ra Tuma chi ra Jacobo sehe Alfeo chi ra Tadeo chi ra Simón ra cuni cuinda cuati chi ñivi ñuun Roma, ");
INSERT INTO mioNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ta quihin tahan ra chi ra Juda Iscariote, ta ra cua xico tuhun chi ra cuu ra. Tacan cuu, ta cuahan ra Jesuu iti vehe, ");
INSERT INTO mioNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ta nducuiti ndico tucu ñivi. Tuvi ñivi cuu ñi nducuiti tucu. Chacan cuu cha ña cuu cachi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ni chini ñivi ra Jesuu tuhun cha ña chachi ra, ta cuahan ñi nu iyo ra, vati cuni ñi cuiso ñi chi ra, vati cati ñi ti ña chito ca ra cha ndacu ra. ");
INSERT INTO mioNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iyo tahan ra sacuaha ley chahnu. Ra quichi iti ñuun Jerusalén cuu ra, ta cati ra ti: ―Iyo run tati cuihna chi ra, ta Beelzebú nani run. Cuu tava ra tati cuihna can, vati iyo run ndaca ñahan chi run tati cuihna chi maan ra ―cati racan ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tacan, ta cana ra Jesuu chi ñivi can, ta quechaha cahan ra iin cuhva chi ñi, vati cati ñi ti iyo run tati cuihna chi ra. Cati ra chi ñi ti: ―Ña cuu tava ndaa ñivi run Satanaa suvi ni chi maan run. ");
INSERT INTO mioNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tu cua cuni cuinda ñivi iin ñuun cuati chi tahan ñi ñuun can, ña cua ndunahan ñivi ñuun can. ");
INSERT INTO mioNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tu cua cuni ñivi iyo iin vehe cuati chi ñivi ñi, cua ndoyo ñuhun ñivi vehe can. ");
INSERT INTO mioNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tu cua cani tahan ñivi run Satanaa suvi ni chi maan run, ta ña inuun iyo anima run suvi ni chi maan run, ña cua ndunahan run, vati cua ndoyo ñuhun run. ");
INSERT INTO mioNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Tu iyo iin ra nihin, ña cua cuu quihvi ni iin ñivi tichi vehe racan, ta ni ña cua cuu suhu ñi ndatiñu ra, tu ña cua cuhni xihna ñi chi ra. Cua cuhni xihna cuii ñi chi ra, ta sa cua cuu suhu ñi ndatiñu ra. Tacan ni cha sacanain chi run Satanaa. ");
INSERT INTO mioNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Cati ndicha yu chihin ndo ti cua sanaan ra Ndioo ndihi cuati cua savaha ñivi. Cua sanaan ra ndihi ndavaha ni cua cahan ñivi cuenda maan ra, ");
INSERT INTO mioNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","soco tu cua cahan ñi ndavaha ni cuenda ra Tati Ndioo, ña cua naan chacan ndihi ni quivi ndihi ni tiempu, soco cua cutuni ñi, vati cuati cahnu xaan cuu chacan, ta cua ndoo chi ndihi ni quivi ndihi ni tiempu. ");
INSERT INTO mioNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ndihi tuhun can ni cati ra Jesuu, vati cati ñi ti iyo run tati cuihna chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tacan cuu, ta ni queta tahan sihi ra Jesuu chi yani ra nu iyo ra, ta chacuinda ñi iti nuquehe ni, ta tachi ñi tuhun cha cana ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tuvi xaan ñivi ndecu nini cuta nuun ra, ta quechaha cati ñi chi ra ti: ―Inda sihun chi yani cun iti nuquehe, ta nducu tuhun ñi chihun ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ta cati ndico ra chi ñi ti: ―¿Yoo ñivi cuu sihi yu chi yani yu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tacan, ta ndehe ra nini cuta nu ndecu ñivi nuun ra, ta cati ra ti: ―Ndehe ndo. Ihya iyo sihi yu chi yani yu. ");
INSERT INTO mioNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ñivi ndacu cuhva cuni ra Ndioo―ñican cuu yani yu chi cuhva yu chi sihi yu ―cati ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tacan cuu, ta inga chaha quechaha sacuaha ndico tucu ra Jesuu yu tañuhun can, ta tuvi xaan ñivi nducuiti tucu nu iyo ra. Chacan cuu cha ni quihvi tucu ra tichi tundoo, ta ni chacunda ra tichi tundoo can cha iyo yu nduta can, ta ndoo ndihi ñivi can nu ñuhun yu tañuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Cuaha xaan cuhva quechaha sacuaha ra Jesuu chi ñi, ta cati tuhun ra chi ñi ti: ");
INSERT INTO mioNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Cua tasoho ndo tuhun ya. Cha cuahan iin rai, vati cua cata cuati ra chiti. ");
INSERT INTO mioNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ni chata cuati ra chi chi, ta quehni suhva chi nu iti, ta quichi ri saa, ta chachi ri chi chi. ");
INSERT INTO mioNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Inga suhva chiti can quehni nu iyo xaan yuu, ta ñahni vaha ñuhun nu inda chi, ta quii xaan cana chi, soco ña cocon iyo ñuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Cana ri nicandi, ta quechaha xii chi, ta neti cuii chi, vati ñahni yoho chi cha vaha. ");
INSERT INTO mioNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Inga suhva chiti can quehni nu iyo iñu, ta ni chahnu tahan iñu, ta chasi iñu can nuun chi, ta ñahni chiti chi chacoo. ");
INSERT INTO mioNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Inga suhva chi quehni nu ñuhun vaha, ta cana chi, ta cocon chi, ta chacoo chiti chi. Iin chiti can chaha inga oco uchi chiti chi, ta inga chiti can chaha uni xico chiti chi, ta inga chiti can chaha iin ciendu chiti chi. Tacan cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ta cati ra chi ñi ti: ―Na cua taa ndihi ndo soho ndo tuhun ya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tacan cuu, ta inga hora iyo siin suhva ñivi iyo chi ra Jesuu, ta chica tuhun ñi chi ra ñaan tuhun cuu cuhva can. Chica tuhun tahan ndihi uchi uvi ra sacuaha chi ra, vati ña chito tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tacan, ta quechaha cati ndico ra Jesuu chi ñi ti: ―Maan ndo cua cutuni ini ndo yoso cuhva cua cundaca ñahan ra Ndioo, soco ña cua coto inga ñivi ña iyo chi ra Ndioo. Mani chi cuhva cahin chi ñican. Nu ni quichi quivi cuni coto ñivi ñaan cha cuu tuhun ya, soco ña ni chaha ra Ndioo nda cua nda vitin. ");
INSERT INTO mioNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chacan cuu cha cua ndehe ñi ñaan cha cua coo, soco ña cua coto ñi ñaan cha cuu cha cua ndehe ñi. Cua cuni soho ñi tuhun, soco ña cua cutuni ini ñi ñaan tuhun cuu chi, coto cua ndico coo anima ñi, ta cua naan cuati ñi ―cati ndico ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ta cati ndico ra Jesuu chi ñi ti: ―Tu ña nituni ini ndo cuhva can, ña cua cutuni ini ndo ndihi ca cuhva cua cahin. ");
INSERT INTO mioNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Rai chata cuati chiti can cuu sava ni ta cua iin ra cati tuhun tuhun vaha chi ñivi, ");
INSERT INTO mioNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ta iyo ñivi cuu sava ta cua chiti quehni nu iti. Chini ñi tuhun can, soco quii xaan quichi run Satanaa, ta sanaan run tuhun ni chini soho ñi, ");
INSERT INTO mioNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ta iyo inga ñivi cuu sava ta cua chiti quehni nu iyo xaan yuu. Chini soho ñi tuhun can, ta chinu ini ñi chi chi, ta sii xaan cuni ñi, ");
INSERT INTO mioNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","soco cuu ñi sava ta cua chiti can, vati ñahni nu cua cuhun yoho chi. Chacan cuu cha ndoo vaha ñi suhva ni quivi, soco yatin xaan cua ndoyo ñuhun ñi, tu cua ndehe ñi tu ndoho, tu cua cuni cani ñivi chi ñi, vati chinu ini ñi tuhun can, ");
INSERT INTO mioNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ta inga tucu ñivi cuu sava ta cua chiti cha quehni nu iyo iñu. Ñican cuu ñivi chini soho tuhun vaha can, ");
INSERT INTO mioNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","soco saxini xaan ñi cha cua tahan ñi ihya nu ñuhun ñuñivi ya, ta cuni xaan ñi cha cua coo xuhun ñi, vati chinu ini ñi cha sandahyu ñahan ñivi chi ñi, ta iyo xaan cha sasaca xini ñi, ta ndihi cha cutañu ñi chasi nuun tuhun can, ta ñahni chiti chi cua coo, ");
INSERT INTO mioNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ta inga ndico tucu ñivi cuu sava ta cua chiti cha quehni nu ñuhun vaha. Chini soho ñi tuhun can, ta savaha ñi cuhva cati chi. Cua coo xaan chiti chi. Iin chiti can chaha oco uchi chiti chi, ta inga tucu chiti chaha uni xico chiti chi, ta inga ndico tucu chiti can chaha iin ciendu chiti chi ―cati ra Jesuu, vati tacan ni iyo ñivi cha chini ñi tuhun chiti can cha cati tuhun ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Cati ra Jesuu chi ñivi can ti: ―Ña tuhva ñivi taa ñi ñuhun ndichin, ta chaqui ndaa ñi chi chi tichi tica, ta ni ña tihi ñi chi chi xuu chito ñi. Chaqui ndaa ñi chi chi nu candileru, vati tacan ndichin vaha ndehe ndihi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tacan cati yu, vati cua coto ndihi ñivi ndihi cha savaha xehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Na cua taa vaha ndo soho ndo ndaa ndo iyo soho ―cati ra, vati tacan ni cua coto ñivi yoso cuhva cua cundaca ñahan ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Cati tahan ra chi ñi ti: ―Na cua savaha ndo cuhva cha ni tasoho ndo. Cuhva cua savaha ndo chi ñivi cua savaha tahan ra Ndioo chi ndo, ta cua nandaa ca cha cua savaha ra chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tu cua satiñu vaha yo cuenda ra, vii ca cua coo ca chi yo. Tu ña cua satiñu vaha yo cuenda ra, cua naan cha iyo chi yo ―cati ra, vati nini xaan cua satiñu vaha ñivi tiñu Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ta cati tuhun tahan ra Jesuu chi ñi ti: ―Nu cua cundaca ñahan ra Ndioo cuu sava ta cua iin rai tachi chiti tichi ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cha cuaa quixi ra, ta ndoyo ndico ra chinucahni, soco ña chito ra yoso cuhva cana chiti can, ta ni ña chito ra yoso cuhva chahnu chi, ");
INSERT INTO mioNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ta maan maan ñuhun can chaha cha cua coo chiti chi. Xihna cuii cana chi, ta sa quee yoco chi, ta nuun yoco chi quichi chiti chi. ");
INSERT INTO mioNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tacan, ta quechaha quihvi cuaan chi, ta quii ni cua tahnda chi, vati cha queta quivi cua sucu ra chi chi ―cati ra Jesuu, vati tacan ni quechaha chinu ini ñivi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Cati ndico tucu ra Jesuu chi ñi ti: ―Iyo iin cuhva cua cati tuhin chi ndo yoso cuhva iyo nu cua cundaca ñahan ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nu cua cundaca ñahan ra cuu sava ta cua iin chiti motasa, ta ndihli xaan chi. Ñahni inga chiti tachi yo tichi ñuhun cha ndihli ca. ");
INSERT INTO mioNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tachi yo chiti can, ta cana chi, ta chahnu chi, ta ñahni inga cuhu cahnu sava ta cua cuhu can, ta nahnu xaan soco chi cuu. Chacan cuu cha savaha ri saa taca ri nuun chi, vati vati xaan chi ―cati ra, vati tacan ni cha cuahan ndutuvi ñivi chinu ini chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Cuaha xaan cuhva can cati tuhun ra Jesuu chi ñi. Tacan sacuaha ra tuhun vaha can chi ñi cuhva cua cuu cuni soho ñi tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mani chi cuhva cahan ra chi ñi, soco chi ra sacuaha chi ra chaha vaha ra cuenda hora quee siin ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Cha cua ini xaan suvi ni quivi can, ta quechaha cati ra Jesuu chi ra sacuaha chi ra ti: ―Na coho inga chiyo tañuhun ya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tacan cuu, ta quee ra ta ra nu iyo cuiti ñivi can. Quihvi tahan ra sacuaha chi ra tichi tundoo can, ta cuahan ra ta ra. Tacan, ta cuahan tahan inga uvi uni ca tundoo. ");
INSERT INTO mioNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tacan cuu, ta nihin xaan suhva caa tati can, ta ndava nduta tichi tundoo can. Chacan cuu cha cuni cutu chi chi nduta. ");
INSERT INTO mioNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tacan, ta ni vii quixi ra Jesuu iti suhma tundoo can, ta quixi ra siqui iin sahma xini nanihin ra. Sandoyo ra ta ra chi ra, ta quechaha cati ra ta ra chi ra ti: ―¿Atu ña saxini cun cha cua cuvi ndi, ta maestru? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Chacuhun ini ra Jesuu, ta quechaha cati ra ti na cutaxin tati can, ta cati ra chi maan nduta can ti: ―Taxin taxin cua coun ―cati ra. Tacan cuu, ta ni chacuita tati can, ta taxin taxin chacava ndico nduta can, ");
INSERT INTO mioNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ta quechaha nducu tuhun ra Jesuu chi ra ta ra ti: ―¿Ñacu cuyuhvi xaan ndo? ¿Ñacu ña chinu ini ndo? Ña vaha cha iyo ndo tacan ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ni vii yuhvi xaan ra ta ra, ta quechaha nducu tuhun ra ta ra chi tahan ra ti: ―¿Yoo rai cuu rahya, vati sacuinu tati chi nduta tañuhun ya cha ni cahan ra? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tacan cuu, ta queta ra ta ra inga chiyo tañuhun can nu cuu chi ñuhun Gadara. ");
INSERT INTO mioNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Quee ra Jesuu tichi tundoo can, ta yatin ni satahan iin rai ñuhun tati cuihna anima chi ra. Iti camasandu quee ra ndahvi can. ");
INSERT INTO mioNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Iyo cuii racan nu iyo ñaña ndii, ta ña cuu ca cuhni ñivi chi ra ni chi cadena caa. ");
INSERT INTO mioNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Cuaha chaha cha chuhni ñi chi ra chi manea chi cadena, soco ni chahnda cuati ra ndihi cadena can, ta ni sachehe ra manea can, ta ni ña cuu ca sandumasu ni iin rai chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ndihi quivi ta ndihi cha cuaa chica cuu ra yucu can, ta chica cuu ra camasandu can, ta cana chaa ra, ta sanicuehe ra chi ra chi yuu can. ");
INSERT INTO mioNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Chica vachi ra Jesuu, ta ndehe ra chi ra, ta quechaha chinu ra. Chinu ra nu vachi ra Jesuu, ta chacuiñi chiti ra iti nuun ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tacan, ta nihin xaan cana chaa ra ndahvi can, ta quechaha cati ra chi ra ti: ―¿Ñaan cha cuu cha cuni cun chihin yu, ta Jesuu? Maun cuu sehe Ndioo ra cuu ra cahnu xaan. Cahan rai yu chihun cuenda ra Ndioo ti na ña cua sasacon xini yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ta cati ndico ra Jesuu chi ra ti: ―Yoho tati cuihna, cua queun tichi anima rahya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nducu tuhun ra Jesuu chi run ti: ―¿Ñaan nani cun? ―cati ra chi run. Ta ni quechaha cati ndico run chi ra ti: ―Legioon nani yu, vati cuaha xaan ndi iyo ―cati run. ");
INSERT INTO mioNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tacan, ta cuaha xaan cahan ndahvi xaan run chi ra Jesuu ti na ña cua tava ndaa ra chi run tichi cuhu can. ");
INSERT INTO mioNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Yucu can iyo cuaha xaan ri quini. Chica cuu ri tixiti ri. Nanducu ri cha cua cachi ri, ");
INSERT INTO mioNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ta quechaha cahan ndahvi ndihi run tati cuihna can chi ra Jesuu, ta cati run chi ra ti: ―Tachi cun chi ndi nu ñuhun quini can, ta cua quihvi ndi tichi ri ―cati run ta run. ");
INSERT INTO mioNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tacan, ta chaha ra Jesuu cha cua cuhun run, ta quee run tati cuihna can, ta quihvi run tichi maan quini can, ta quechaha ca chinu ndihi ri quini, ta quicoyo ri nu chani nuun chi yu tañuhun can. Ni chihi ndihi ri tichi nduta tañuhun can, ta uvi mil ri cuu ri ni chihi. ");
INSERT INTO mioNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tacan cuu, ta chinu ndihi ra sacuenda chi ri quini can, ta chaha ra ta ra cuenda chi ndihi ñivi can. Chaha ra ta ra cuenda chi ñivi iyo tichi ñuun, ta chaha tahan ra ta ra cuenda chi ñivi iyo chiqui. Chacan cuu cha quee ñi cuahan ñi, vati cua ndehe tahan ñi ñaan cha cuu cha ni cuu. ");
INSERT INTO mioNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Queta ñi nu iyo ra Jesuu, ta ndehe ñi ti iyo ra cha ndehe tu ndoho can, ta ndaa ra. Nami ra sahma, ta cha iyo vaha xini ra, ta suvi ni maan ra cuu ra cha cuñuhun cuaha xaan run tati cuihna can, ta quechaha cuyuhvi xaan ñi, ");
INSERT INTO mioNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ta suvi ni ra ni ndehe cha ni tahan ri quini can chaha cuenda chi ñi ñaan cha cuu cha ni tahan ra cha ñuhun tati cuihna anima. Chaha tahan ra ta ra cuenda ñaan cha cuu cha ni tahan ri quini can, ");
INSERT INTO mioNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ta quechaha cahan ndahvi ñican chi ra Jesuu ti na cua quee ra ñuhun nu iyo maan ñi, ta na cua cuhun ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tacan cuu, ta quihvi ndico ra Jesuu tichi tundoo can, ta quechaha cahan ndahvi xaan ra cha cuñuhun tati cuihna anima chi ra, vati cuni ra cuhun tahan ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","soco ña ni chaha ra Jesuu. Quechaha cati ra chi ra ti: ―Cuahan iti vehun nu iyo ñivi cun, ta cuhvon cuenda chi ñi ñaan cha cuu cha ni savaha chitoho cun chihun. Cua cuhvon cuenda chi ñi yoso cuhva ni cundahvi ini ra chihun ―cati ra Jesuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tacan, ta cuahan ra, ta quechaha cati tuhun ra chi ñivi ñuhun Decápoli can ñaan cha cuu cha ni savaha ra Jesuu chi ra, ta iyo xaan quechaha cuni ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tacan cuu, ta quihvi ndico tucu ra Jesuu tichi tundoo can, ta yaha tucu ra inga chiyo tañuhun can, ta nducuiti ndico tucu tuvi ñivi nu ni queta ra yu tañuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Queta tahan iin ra ndiso tiñu cuenda ve ñuhun, ta Jairo nani ra. Ndehe ra chi ra Jesuu, ta ni chacuiñi chiti ra iti nuun ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Quechaha cahan ndahvi xaan ra chi ra Jesuu, ta cati ra chi ra ti: ―Cha cuni cuvi ña luhu sehi. Na coho, ta tison ndahun chi ña, ta cua nduvaha ña, ta ña cua cuvi ña ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tacan cuu, ta cuahan ra Jesuu chi ra, ta ndicu tuvi xaan ñivi chi ra. Nihin xaan indi ra tañu ñivi can, ");
INSERT INTO mioNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ta queta iin ñahan. Uchi uvi cuiya cha iyo xaan niñi ña chi ña. ");
INSERT INTO mioNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Cha cuaha xaan tu ndoho ndehe ña, vati cuaha xaan ra ñatatan ndehe chi ña, ta sanaan ña ndihi cha iyo chi ña, ta ña ni nduvaha ña, soco xaan ca cuahan sanihin chi chi ña. ");
INSERT INTO mioNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chini ña cha cahan ñivi cuenda ra Jesuu, ta quichi ña iti chata ra sava mahñu ñivi can, ta sayani ndaha ña sahma ra, ");
INSERT INTO mioNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","vati cati ña ti tu cua sayani ndaha ña―masi sahma ra, cua nduvaha ña, cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tacan cuu, ta quii xaan ni chacuita niñi ña chi ña, ta ni chito ña ti cha ni nduvaha ña tu ndoho tahan ña, ");
INSERT INTO mioNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ta quii xaan ni tuvi ini ra Jesuu cha quee tu ndee ini chi ra. Chacan cuu cha ndico coo ra mahñu ñivi can, ta quechaha nducu tuhun ra ti: ―¿Yoo cuu cha ni sayani ndaha sahme? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ta quechaha cati ra sacuaha chi ra ti: ―Ndehun vati tuvi xaan ñivi chacuhun chihun, ta nducu tuhun cun yoo ni sayani ndaha chihun ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Quechaha nanducu nuun maan ra Jesuu nini cuta nu inda ñivi can, vati cuni ra ndehe ra yoo ñi ni sayani ndaha sahma ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tacan, ta quechaha cuyuhvi xaan maan ña ñahan can, ta quisi chi chi ña, vati chito ña ñaan cha cuu cha ni tahan ña, ta tuhva ña nu inda ra, ta ni chacuiñi chiti ña iti nuun ra, ta cahan ndicha ña ndihi cha ni tahan ña. ");
INSERT INTO mioNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Cati ndico ra Jesuu chi ña ti: ―Cha ni nduvahun, vati chinu ini cun. Cuahan vitin, ta na cua coo vii anima cun, vati cha naan tu ndoho tahun, sihi ―cati ra chi ña. ");
INSERT INTO mioNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ni vii cahan ra Jesuu chi ñacan, ta queta uvi ñivi vachi iti vehe ra Jairo can, ta cati ñi chi ra ti: ―Cha ni chihi sehun. Ña cua satañu con chi ra maestru ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Chini ra Jesuu tuhun cha cahan ñi, ta quechaha cati ra chi ra ndiso tiñu can ti: ―Ña cua cuyuhvi cun. Ini cha cua cuinu ini cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tacan, ta ña chaha ra Jesuu cha cua cuhun tahan ndihi ca ñivi can chi ra. Mani ra Pedro chi ra Jacobo chi ra Juaan yani ra Jacobo can chi ra Jairo chaha ra, ta cuahan tahan ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tacan cuu, ta queta ra ta ra vehe ra Jairo can, ta ndehe ra Jesuu ti cuvaa xaan ñivi can. Ndahyu chaa ñi, ta chacu xaan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Quihvi ra tichi vehe ra Jairo can, ta quechaha nducu tuhun ra chi ñi ti: ―¿Ñacu cuvaa xaan ndo? ¿Ñacu chacu xaan ndo? Ña chihi ña luhu ya. Quixi ni maan ña ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ta quechaha chacu cata ñi cha cahan ra Jesuu, ta tava ndaa ra chi ndihi ñican iti nuquehe. Quihin ra chi sutu ña chi sihi ña chi ra quichi chi maan ra, ta tuhva ra nu caa ña luhu can. ");
INSERT INTO mioNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tiin ra Jesuu ndaha ña, ta quechaha cati ra chi ña ti: ―Talita cumi ―cati ra. Tuhun hebreo can cati ti cahin chi yoho, xihi. Ndoyo, cati chi. ");
INSERT INTO mioNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tacan cuu, ta ni ndoyo ña, ta quechaha chica cuu ña. Cha iyo tahan ña iin uchi uvi cuiya ña. Suvi ni hora can iyo xaan iyo xaan quechaha cuni ñivi can, ");
INSERT INTO mioNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ta quechaha cati tuhun xaan ra Jesuu chi ñi, vati ña cuni ra cha cua coto ni iin ñivi cha ni savaha ra. Tacan, ta cati ra ti na cua cuhva ñi cha cua cachi ña. ");
INSERT INTO mioNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tacan cuu, ta ni quee ra Jesuu ican, ta cuahan ra iti ñuun ra, ta ndicu tahan ñivi sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Quivi sábadu quivi ndaa tatun ñivi cuu chi, ta quechaha sacuaha tucu ra chi ñivi iyo ve ñuhun can. Tuvi ñivi chini tuhun cha cahan ra, ta iyo xaan cuni ñi. Quechaha nducu tuhun ñi chi tahan ñi ti: ―¿Ndaa iti cutuhva ra tuhun ya? ¿Yoo rai chaha cha chini tuni chi ra? ¿Yoso cuu savaha ra cuhva cahnu xaan can? ");
INSERT INTO mioNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Saxini ndiuhu ti rahya cuu sehe ña María. Yani ra chi ra Jacobo chi ra José chi ra Juda chi ra Simón. Ihya iyo tahan cuhva ra chi maan yo, ta sata tahan ra vitu ―cati ñi ta ñi. Ndutahñu cuni ñi ndehe ñi chi ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ta cati ra Jesuu chi ñi ti: ―Sacahnu ndihi ca ñivi chi ra cahan cuenda ra Ndioo, soco nda ñuun ra nda vehe ra chi ñivi ra―ña sacahnu ñi chi ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ña ni cuu savaha ra Jesuu ni iin cuhva tican, vati ñuun nu ni quichi cuahnu ra cuu chi. Tiso ni ra ndaha ra chi iin uvi ñivi cuhvi, ta sanduvaha ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iyo xaan cuni ra, vati ña cuni ñi cuinu ini ñi. Chahan ra ndihi ñuun iyo ican, ta sacuaha ra chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tacan cuu, ta cana ra Jesuu chi ndihi uchi uvi ra sacuaha chi ra, ta quechaha tava tiñu ra chi ra ta ra. Uvi uvi ra ta ra tava tiñu ra, ta chaha ra tu ndee ini chi ra ta ra ti na cua tava ra tati cuihna anima ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Cati tuhun ra chi ra ta ra ti ñahni cha cua cuiso ra ta ra nu cua cuhun ra. Ña cua cuiso ra yunu. Ña cua cuiso ra cha cua cachi ra. Ña cua cuiso ra xuhun tichi iti ra. Ña cua cuiso ra. Iin tuhun ni yutun cua cunaan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Cua cunda chaha ra, soco ña cua cundichin toto ra uvi sahma, ");
INSERT INTO mioNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ta cati ra Jesuu chi ra ta ra ti: ―Cua coo nuun ndo ndaa vehe cua quihvi ndo. Tican cua coo nuun ndo nda cua nda quivi cua quee iti tucu ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tu ña cua quihin cuenda ñivi chi ndo, tu ña cua tasoho ñi tuhun cua cahan ndo, cua quee ndo tican, ta cua naquisi ihni ndo yuhma iñi chaha ndo nu cua ndehe ñi. Chacan cuu cha cua coto ndihi ñivi ti ña vaha cha ndacu ñican. Cati ndicha yu chihin ndo ti nihin xaan cua coo tu ndoho chi ñivi ñuun Sodoma chi ñivi ñuun Gomorra quivi cua cutuni ñivi ñuñivi, soco nihin xaan ca cua coo tu ndoho chi ñivi ña cua quihin cuenda chi maan ndo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tacan cuu, ta quee ra ta ra, ta cuahan ra. Cati tuhun ra ta ra ti na cua nacoo ihni ñivi cuati ndacu ñi, ");
INSERT INTO mioNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ta tava ihni ra ta ra cuaha xaan tati cuihna indi anima ñivi. Choso tahan ra ta ra aceite chi ñivi cuhvi, ta sanduvaha ra ta ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tacan cuu, ta chito tahan ra Herode ra ndaca ñahan ñuhun can, vati cha cahan ndihi ñivi yoso cuhva ni savaha ra Jesuu. Iyo ñivi cati ti: ―Juaan ra sacuanduta cuu ra savaha ndihi chacan, ta vitin cha natacu ndico ra tañu ñivi ndii. Chacan cuu cha iyo xaan tu ndee ini chi ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ta inga ñivi cati ti: ―Elía cuu ra ―cati ñi. Ta inga tucu ñivi cati ti: ―Iin ra cahan cuenda ra Ndioo cuu ra, vati iyo ra cuhva ni chacoo ra ni cahan tuhun Ndioo tiempu chahnu ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tacan, ta chini ra Herode tuhun can, ta quechaha cati ra ti: ―Cha ni quende xini ra Juaan, soco cha ni nandoto ndico ra ―cati ra Herode can. ");
INSERT INTO mioNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tacan cati ra Herode, vati suvi ni maan ra tachi tiñu ti na cua cu tiin tiñu chi ra Juaan, ta tihi ra chi ra ve caa, vati cha quihin cuenda ra Herode chi ña Herodía ñasihi ra Felipe yani ra, ta tandaha ndico tucu ra Herode chi ña, ta ñasihi ra cuu ña quivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ni tihi ra Herode chi ra Juaan can ve caa, vati cha cati ra Juaan chi ra ti ña chaha ley cha cua quihin ra ñasihi yani ra, cati ra Juaan can. ");
INSERT INTO mioNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tacan, ta quihin xaan ña Herodía tisihi ndehe ña chi ra Juaan, ta cahni ña chi ra cuni ña, soco ña cuu chi maan ña, ");
INSERT INTO mioNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","vati cuyuhvi ra Herode chi ra Juaan can, vati chito ra ti rai cuiti vaha cuu ra Juaan, ta ñahni cuati ndacu ra. Chacan cuu cha cumi vaha ra Herode chi ra, ta sii xaan cuni ra chini ra tuhun cahan ra Juaan, soco ña nihin ra Herode cuhva yoso cua saxini ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tacan cuu, ta queta iin quivi, ta ni nihin ña Herodía cuhva, vati cua sacahnu ra Herode iin vico, vati cha queta cuiya ra. Chacan cuu cha cua tiso vaha ra, vati cua sacachi ra chi ra cumi tiñu chi ra ndaca ñahan chi ra sandaru ta ra chi ndihi ra sutu ñuun iyo ñuhun Galilea can. ");
INSERT INTO mioNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tacan cuu, ta quihvi ña tivaa sehe ña Herodía can nu ndaa ra ta ra, ta chita chaha ña yaa, ta sii xaan quechaha cuni ra Herode chi ndihi ra ndecu chi ra yu mesa can, ta quechaha cati ra Herode can chi ña tivaa can ti: ―Cua cati maun ndaa cha cuu cha cuni maun, ta cua cuhve chi chi chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Cahan rai ra chi ña, ta cati ra ti cua cuhva ra ñaan cha cuu cha chica ña chihin ra. Cua cuhva ra nda sava ñuhun ndaca ñahan ra chihin ña, tu cua cuni ña. ");
INSERT INTO mioNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tacan, ta quee ña cuahan ña, ta quechaha nducu tuhun ña chi sihi ña ti: ―¿Ñaan cha cuu cha cua ndaque chi ra? ―cati ña. Ta cati ndico sihi ña chi ña ti: ―Na cua cuhva ra xini ra Juaan ra sacuanduta ―cati ña chi ña. ");
INSERT INTO mioNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tacan, ta quii xaan ni quihvi ndico ña tivaa can nu ndaa ra Herode can, ta cati ndico ña ti: ―Yuhu cuni yu cha cua cuhvon xini ra Juaan ra sacuanduta tichi chicoho cha vitin vitin ―cati ña chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tacan cuu, ta ndahvi xaan quechaha cuni ra Herode can, vati cha ni cahan rai ra chi ña, ta ña cuni ra cati ra chi ña ti ña cua cuu, vati iyo tahan ra ndecu yu mesa chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tacan cuu, ta sa ni tava tiñu ra chi iin ra chahni ñivi ti na cua cu quihin ra xini ra Juaan. ");
INSERT INTO mioNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Cuahan racan, ta queta ra, ta chahnda ra sucun ra Juaan nu ndaa ra ve caa can, ta quichi ndaca ra xini ra tichi chicoho can, ta chandaca ra chi chi chi ña tivaa can, ta chaha ña tivaa can chi chi chi sihi ña. ");
INSERT INTO mioNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tacan cuu, ta chito ra sacuaha chi ra Juaan can, ta chaquihin ra iquin cuñu ra, ta cuchi ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ni nducuiti ndico tucu ra tatun ra Jesuu iti nuun ra nu ni chahan ra ta ra, ta chaha ra ta ra cuenda ndihi cha ni savaha ra ta ra. Chaha tahan ra ta ra cuenda ndihi cha ni sacuaha ra ta ra chi ñivi, ");
INSERT INTO mioNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ta quechaha cati ra Jesuu chi ra ta ra ti: ―Coho, vati cua quee siin yo tichi cuhu, ta cua cunda tatun nuun yo suhva quivi. Tacan cati ra Jesuu, vati tuvi ñivi quichi, ta tuvi ñi cuahan ndico, ta ña cuyatin ra ta ra cachi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tacan, ta quihvi ndico tucu ra ta ra tichi tundoo, ta quee ra cuahan ra. Quee siin ra ta ra tichi cuhu, ");
INSERT INTO mioNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","soco tuvi ñivi ndehe ti cha cuahan ra ta ra, ta chito ñi ndaa iti cuahan ra ta ra. Quee ñi ndihi ñuun can, ta chinu ñi cuahan ñi ican, ta queta xihna maan ñivi can. Tacan ni nducuiti tucu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tacan cuu, ta queta ra Jesuu tican, ta quee ra tichi tundoo can, ta ndehe ra ti cha iyo cuiti tucu tuvi ñivi, ta uhvi xaan cuni anima ra cha ndehe ra chi ñivi can, vati iyo ñi sava ta cua iyo ri mbee, ta yoni sacuenda chi ri. Tacan, ta quechaha sacuaha tucu ra chi ñi. Cuaha xaan sacuaha ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cha cua ini xaan, ta tuhva ra sacuaha chi ra Jesuu nu iyo ra, ta quechaha cati ra ta ra ti: ―Mani cuhu cuu chi ihya, ta cha cua ini xaan vitin. ");
INSERT INTO mioNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Na cua saña tahun chi ñi. Chacan cuu cha cua cuu cuhun ñi ndihi ñuun iyo yatin ihya, ta cua cuu sata ñi ñaan cha cua cachi ñi, vati ña ndiso ñi cha cua cachi ñi ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cuhva maan ndo cha cua cachi ñi ―cati ra. Ta quechaha nducu tuhun ra ta ra chi ra ti: ―¿Atu cua cu sata ndi uvi ciendu xuhun denario paan, ta cua cuhva ndi cha cua cachi ñi? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ta nducu tuhun ndico maan ra chi ra ta ra ti: ―¿Yoso tahan paan iyo chi ndo? Cua cu ndehe ndo ―cati ra. Cha chito ra ta ra, ta cati ndico ra ta ra ti: ―Uhun tahan paan cuu chi, ta uvi tahan tiaca ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tacan, ta cati tuhun ra Jesuu ti na cua cunda ñi nu ñuhun nu iyo ita cuii can. Iin iin cuenda ñi cua cunda ñi, ");
INSERT INTO mioNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ta tacan ni chacunda ñi. Ni chacunda iin cuenda ñi ciendu ciendu ñi, ta ni chacunda tahan inga cuenda ñi uvi xico uchi uvi xico uchi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tacan cuu, ta quihin ra Jesuu ndihi uhun tahan paan can chi nduvi tahan tiaca can, ta ndehe ndaa ra iti siqui andivi, ta chaha ra iin tiahvi ndioo chi ra Ndioo, ta chahnda cuati ra paan can, ta chaha ra chi chi chi ra sacuaha chi ra, vati na cua cuhva ra chi chi chi ñivi can, ta natahvi tahan ra nduvi tahan tiaca can chi ndihi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Chachi ndihi ñivi can, ta ni ndaha ini ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tacan, ta canihin ra ta ra uchi uvi tica chitu chehle can, ta uhun paan chi uvi tiaca cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Queta uhun mil rai cuu ra ni chachi paan can. ");
INSERT INTO mioNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tacan cuu, ta cati tuhun ra Jesuu chi ra sacuaha chi ra ti na cua quihvi ra ta ra tichi tundoo, ta cua cuhun ra ta ra iti nuun. Nda inga chiyo tañuhun can cua cuhun ra ta ra nuun iyo ñuun Betsaida can, vati cua saña tahan xihna ra Jesuu chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tacan cuu, ta saña tahan ra Jesuu chi ñi, ta quee ra cuahan ra iin siqui yucu, vati cuni ra cahan ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cha cuaa cuu chi, ta cuahan tundoo mahñu nduta tañuhun can, ta ndoo maan iin tuhun ra Jesuu nu ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tacan, ta ndehe ra Jesuu ti chitatun xaan ra ta ra cha sacunu ra chi maan tundoo, vati nihin xaan vachi tati iti nuun tundoo. Cha yatin caa uni cha vachi tuvi cuu chi, ta tuhva ra Jesuu nu cuahan ra ta ra. Chica ra nu nduta can, ta cuni ra cua yaha ra iti nuun ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","soco ndehe ra ta ra ti cha chica ra nu nduta can, ta saxini ra ta ra ti xiñahñu ndii cuu ra, ta quechaha cana chaa ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ndihi ra cuu ra ndehe chi ra, ta yuhvi xaan ra ta ra. Tacan, ta nducahan ra Jesuu chi ra ta ra. Cati ra chi ra ta ra ti: ―Cua cundee ini ndo. Yuhu cui. Ña cua cuyuhvi ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tacan cuu, ta quihvi tahan ra Jesuu tichi tundoo nu indi ra ta ra, ta ni chacuita tati can, ta quechaha saxini xaan ra ta ra. Iyo xaan quechaha cuni ra, ");
INSERT INTO mioNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","vati ña nituni ini ra ta ra cuenda paan can, ta ni ña cuni ra ta ra cuinu ini ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tacan cuu, ta queta ra ta ra inga chiyo yu tañuhun can nu cuu chi ñuun Genesaret, ta chuhni ndaa ra tundoo can yu nduta can. ");
INSERT INTO mioNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nu ni quee ra ta ra iti tichi tundoo, ta quii xaan nacoto ñivi chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Chacan cuu cha chinu ñi nini cahnu ñuhun can, ta quechaha chandaca ñi chi ñivi cuhvi caa nu yuvi, vati chini ñi tuhun ndaa iti iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yaha ra Jesuu ndihi ñuun iyo tican, soco ndihi nu yaha ra chaqui ñi chi ñivi cuhvi iti nuyahvi, ta cahan ndahvi ñi chi ra ti na cua sayani ndaha ñi cuhvi can―masi nu tuvi sahma ra. Tacan cuu, ta nduvaha ndihi ñivi sayani ndaha sahma ra. ");
INSERT INTO mioNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Iti ñuun Jerusalén ni quichi ra fariseo chi uvi uni ra sacuaha ley chahnu, ta nducuiti tahan ra ta ra nu iyo ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ndehe ra ta ra ti cha chachi ñivi sacuaha chi ra Jesuu, ta ña ndoo ndaha ñi cuenda costumbre. Tacan cati ra ta ra ti cha ndacu ñi cuati, ");
INSERT INTO mioNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","vati ña tuhva ra fariseo chi ndihi ñivi judío can cachi ñi, tu ña cua nacata vaha xihna ñi ndaha ñi cuhva iyo costumbre savaha ñivi ñi nu ni quichi quivi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Chahan ñi nuyahvi, ta nacata xihna ñi ndaha ñi cuhva iyo costumbre, ta sa cua cuu cachi ñi. Cuaha xaan ca costumbre iyo chi ñi. Nacata ñi yachin. Nacata ñi casitu. Nacata ñi quisi. Nacata ñi yuvi. Nacata ñi, ");
INSERT INTO mioNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ta nducu tuhun maan ra fariseo chi maan ra sacuaha ley can chi ra Jesuu ti: ―¿Ñacu ña sacahnu ñivi sacuaha chihun costumbre cuhva ni sacahnu ñivi yo nu ni quichi quivi? Chachi ñivi sacuaha chihun, ta ña ndoo ndaha ñi cuenda costumbre ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ta cati ndico ra Jesuu chi ra ti: ―Chaha vaha ra Isaía cuenda yoso cuhva iyo ndo, vati rai uvi yaa cuu ndo. Cha cati tutu Ndioo ti: Cati ñivi can ti cha sacahnu ñi chihin ra Ndioo, soco ña sacahnu ñi chihin ra chi anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ñahni yavi ndaa cha sacahnu ñi chihin ra, vati sacuaha ñi tuhun cha saxini ñivi ñuñivi, ta cati ñi ti tuhun Ndioo cuu chi, cati ra Isaía can tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Cha nacoo ndo cha ni cati tuhun ra Ndioo, ta sacuinu ndo costumbre cuhva cati ñivi, vati nacata ndo casitu. Nacata ndo yachin, ta cuaha xaan ca chacan ndacu ndo ―cati ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tacan, ta cati ra Jesuu chi ra ta ra ti: ―Tava ndaa ndicha ndo cha cati tuhun ra Ndioo, vati cuni ndo sacuinu ndo costumbre maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tiempu chahnu cati ra Moisee ti cua sacahnu ñivi chi sutu ñi chi sihi ñi, cati ra, ta suvi ni maan ra cati ndico tucu ti na cua cuvi ndicha ñivi tu cua cahan ñi ndavaha ni chi sutu ñi chi sihi ñi, cati ra, ");
INSERT INTO mioNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ta maan ndo cati ti cua cuu cati iin ñivi chi sutu ñi chi sihi ñi ti ña cua cuu tindee ñi chi ñi, vati ndihi cuii cha iyo chi ñi cuu Corbaan, vati cha samani ñi chi ra Ndioo cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tu tacan cua cati ñi, ña cua cuhva ca ndo cha tindee ñi chi sutu ñi chi sihi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chacan cuu cha sanaan ndo tuhun Ndioo, vati cuni ndo sacahnu ndo costumbre ndo, ta cuaha xaan cuhva can ndacu ndo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tacan cuu, ta cana tucu ra Jesuu chi ñivi can, ta quechaha cati ra chi ñi ti: ―Ndihi ndo na cua taa vaha ndo soho ndo, ta na cua cutuni vaha ini ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ñahni cha cua cachi ñivi cuu cha cua sacaquini chi anima ñi, soco cha cua saxini ñi cuu cha cua sacaquini anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Na cua taa vaha ndo soho ndo ―cati ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tacan cuu, ta quee ra Jesuu nu iyo cuiti ñivi can, ta quihvi ra tichi vehe, ta quechaha nducu tuhun ra sacuaha chi ra ñaan cha cuu cuhva can cha ni cati ra, ");
INSERT INTO mioNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ta cati ndico ra chi ra ta ra ti: ―Ña cutuni tahan ini ndo. Ña chito ndo ti ñahni cha chachi ñivi cuu cha cua sacaquini chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ña cua sacaquini chi chi anima ñi, vati ña quihvi chi tichi anima ñi, soco quihvi chi tichi chiti yuva ñi, ta chati ndico ñi chi chi ―cati ra. Chacan cuu cha cati ra Jesuu ti ña ica cuenda costumbre ni iin cha chachi ñivi, ");
INSERT INTO mioNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ta cati tucu ra chi ñi ti: ―Cha saxini ñivi chi anima ñi cuu cha sacaquini chi ñi, ");
INSERT INTO mioNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","vati saxini ñivi ndavaha ni chi anima ñi. Chehe cuu cha saxini ñivi. Saxini ñi ndavaha ni chi anima ñi. Cuni ñi coo ñi ndavaha ni chi tahan ñi inga chiyo. Cuni ñi cahni ñi chi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Cuni ñi suhu ñi ndatiñu tahan ñi. Cuni xaan ñi cha iyo chi tahan ñi. Mani cha ndavaha ni cuni ñi savaha ñi. Cuni ñi sandahyu ñahan ñi chi tahan ñi. Yaha xaan cuhva cha ndacu ñi. Tahñu xaan cuni ñi ndehe ñi chi tahan ñi. Mani ndavaha ni cahan ñi chi ra Ndioo. Rai xaan cuni ñi. Ña vaha cuni xini ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ndihi cha ndavaha ni can saxini ñivi chi anima ñi, ta sa nducaquini anima ñi ―cati ra Jesuu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tacan cuu, ta quee ra Jesuu tican, ta cuahan ra. Iti ñuun Tiro iti ñuun Sidón cuahan ra, ta quihvi ra tichi vehe ican, ta ña cuni ra cha cua coto ñivi cha iyo ra, soco ña cuu cuindi xehe ra. ");
INSERT INTO mioNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Quii xaan chito iin ñahan cha iyo ra, ta quichi ña nu indi ra, vati ñuhun tati cuihna anima sehe ña, ta ni chacuiñi chiti ña iti nuun ra. ");
INSERT INTO mioNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Inga tucu ñivi cuu ña, vati iti ñuhun sirofenisa ni cacu ña. Chica ñacan iin tu manini chi ra Jesuu, vati na cua tava ra tati cuihna ñuhun anima sehe ña, ");
INSERT INTO mioNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ta quechaha cati ra Jesuu iin cuhva chi ña ti: ―Cuhva cun cha cua ndaha xihna ini ñi cuati, vati ña vaha cha cua quihin ndi paan iyo chi ñi, ta cua cuhva ndi chi chi chi ri ina cuati ―cati ra cuenda ñivi judío can ta cuenda ñivi cuu inga tucu ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ta cati ndico ña chi ra ti: ―Ndicha, tata, soco cua cachi ri ina cuati ndihi chehe yuhu ñi cuati quicoyo iti xuu mesa ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ta cati ndico ra chi ña ti: ―Cuahan vitin, vati vaha xaan tuhun cha cahun. Cha quee run tati cuihna can anima sehun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tacan cuu, ta quee ña cuahan ndico ña iti vehe ña, ta ndehe ña ti caa taxin sehe ña nu yuvi, ta cha ni quee run tati cuihna anima ña. ");
INSERT INTO mioNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Quee ndico tucu ra Jesuu ñuun Tiro can, ta yaha ra ñuun Sidón, ta queta ndico ra tañuhun Galilea sava mahñu ñuhun Decápoli can. ");
INSERT INTO mioNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tacan cuu, ta quichi ndaca ñivi can chi iin ra soho nu queta ra Jesuu, ta ñihin tahan ra ndahvi can. Queta ñi, ta chica xaan ñi iin tu manini chi ra Jesuu ti na cua tiso ra ndaha ra chi ra ndahvi can. ");
INSERT INTO mioNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tacan, ta quihin ra Jesuu chi ra, ta quee siin ra ta ra tañu ñivi can, ta tihi ra Jesuu nundaha ra tichi yavi soho ra ndahvi can, ta tivi sivi ra nundaha ra, ta taa tahan ra nundaha ra yaa ra ndahvi can. ");
INSERT INTO mioNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tacan, ta ndehe ndaa ra Jesuu iti siqui andivi, ta xita ra tati ra, ta quechaha cati ra chi ra soho can ti: ―¡Efata! ―cati ra, vati na cua nuna, cati ra chi tuhun cahan maan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tacan cuu, ta sa ni nuna yavi soho ra ndahvi can, ta nduvita yaa ra, ta quechaha cahan ra. Cachin xaan cahan ra, ");
INSERT INTO mioNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ta cati tuhun ra Jesuu chi ñi ti ña cua cahan ñi chi ni iin ñivi. Tacan cati tuhun xaan ra chi ñi, soco nihin xaan ca cati tuhun ñi tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Iyo xaan quechaha cuni ñivi can, ta cati ñi ti: ―Vaha xaan ndacu ra, vati chini ñivi soho, ta nducahan ñivi ñihin savaha ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Suvi ni quivi can nducuiti ndico tucu tuvi ñivi, ta ñahni cha cua cachi tucu ñi. Tacan, ta cana ra Jesuu chi ra sacuaha chi ra, ta quechaha cati ra chi ra ta ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Uhvi xaan cuni yu ndehi chi ndihi ñivi ya, vati cha queta uni quivi cha iyo ñi chihin yu, ta ñahni cha cua cachi ñi vitin. ");
INSERT INTO mioNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tu cua tachi ndico yu chihin ñi iti vehe ñi, ta ña ta cachi ñi, cua nduva ihni ñi iti chi soco, vati iyo ñi cani xaan quichi ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ta nducu tuhun ndico ra sacuaha chi ra ti: ―¿Ndaa iti cua nihin yo cha cua cachi ñi ihya tichi cuhu ya? ―cati ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tacan, ta quechaha nducu tuhun ra Jesuu chi ra ta ra ti: ―¿Yoso tahan paan iyo chi ndo? ―cati ra. Ta cati ndico ra ta ra ti: ―Ucha tahan chi iyo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tacan cuu, ta cati ra Jesuu chi ñi ti na cua cunda ñi nu ñuhun, ta quihin ra ndihi ucha paan can, ta chaha ra iin tiahvi ndioo chi ra Ndioo, ta sacuati ra chi chi, ta chaha ra chi chi chi ra sacuaha chi ra ti na cua sacha ra ta ra chi chi chi ñi, ta chaha ra ta ra chi chi chi ndihi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iyo tahan uvi uni tahan tiaca cuati chi ñi, ta chaha ndico tucu ra Jesuu tiahvi ndioo, ta cati ra ti na cua cuhva tahan ra chi ri chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Chachi ñi, ta ndaha ini ñi, ta queta ucha tica chehle can canihin ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Vasi queta cumi mil ñivi chachi ican. Tacan, ta saña tahan ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tacan cuu, ta quihvi ndico ra Jesuu chi ra sacuaha chi ra tichi tundoo, ta cuahan ra ta ra iti ñuhun Dalmanuta. ");
INSERT INTO mioNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tacan cuu, ta nducuiti tahan ra fariseo ta ra nu iyo ra Jesuu, ta quechaha cahan yuhu ra ta ra chi ra, vati cuni ndehe ra ta ra iin cuhva iti siqui andivi cha cua savaha ra Jesuu. Tacan cuni ra ta ra, vati cuni ndehe ra ta ra a ña cua savaha ra Jesuu iin cha ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tacan cuu, ta quichi cha uhvi ini ra Jesuu, ta quechaha nducu tuhun ra chi ra ta ra ti: ―¿Ñacu cuni ndehe ñivi iyo vitin iin cuhva? Cati ndicha yu ti ñahni cuhva cua ndehe ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tacan cuu, ta quee ra Jesuu nu iyo cuiti ñivi can, ta quihvi tucu ra tichi tundoo, ta cuahan ra inga chiyo tañuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tacan cuu, ta naan ini ra sacuaha chi ra Jesuu quihin ra paan. Iin tuhun ni paan ndiso ra ta ra nu cuahan ra ta ra tichi tundoo can, ");
INSERT INTO mioNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ta quechaha cati tuhun xaan ra Jesuu chi ra ta ra, ta cati ra ti: ―Cua saha vaha ndo cuenda yoso cuhva iyo levadura ra fariseo ta yoso cuhva iyo levadura ra Herode ―cati ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tacan, ta ndatuhun tahan xaan ra ta ra chi tahan ra, vati cati ra ta ra ti: ―Ñahni paan iyo ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Chito maan ra Jesuu cha ndatuhun ra ta ra, ta quechaha cati ra chi ra ta ra ti: ―Saxini xaan ndo ti ñahni paan iyo chi ndo. Ña ta cutuni ini ndo, ta ni ña ta coto ndo. Ña ta nihin ndo cuhva. ");
INSERT INTO mioNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Iyo titi nuun ndo, soco ña ndehe ndo. Iyo soho ndo, soco ña chini ndo. Vasi ña ñuhun ini ndo yoso cuhva ");
INSERT INTO mioNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ni sachehi uhun tahan paan can, ta chahi cha chachi uhun mil ñivi. ¿Yoso tahan tica chitu chehle can canihin ndo? ―cati ra chi ra ta ra. Ta cati ndico ra ta ra ti: ―Uchi uvi tahan tica canihin ndi ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ta cati ndico tucu ra Jesuu ti: ―Ta sachehi ucha tahan paan can, ta chahi cha chachi cumi mil ñivi. ¿Yoso tica chitu chehle can sataca ndico ndo? ―cati tucu ra. Ta cati ndico ra ta ra ti: ―Ucha tica canihin ndi ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ta cati ndico tucu ra Jesuu chi ra ta ra ti: ―Vasi ña ta cutuni ini ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tacan cuu, ta cuahan ra Jesuu iti ñuun Betsaida. Queta ra, ta chandaca ñivi can chi iin rai cuaa nu iyo ra. Quechaha cahan ndahvi ñi chi ra ti na cua tiso ra ndaha ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tacan, ta tiin ra Jesuu ndaha ra cuaa can, ta chandaca ra chi ra yu ñuun can. Ican ni tivi sivi ra Jesuu titi nuun ra, ta tiso ra ndaha ra chi ra ndahvi can, ta quechaha nducu tuhun ra chi ra ti: ―¿Atu ndichin vaha ndehun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ndehe ndaa ra ndahvi can, ta quechaha cati ra ti: ―Ndehi chi ñivi, soco cuhva caa yutun caa ñi, ta chica cuu ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tacan, ta tiso ndico tucu ra Jesuu ndaha ra titi nuun ra cuaa can, ta nihin xaan ndehe ra ndahvi can, ta nduvaha nuun ra. Ndichin vaha ndehe ra ndihi cha iyo. ");
INSERT INTO mioNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tacan, ta tachi ra Jesuu chi ra iti vehe ra, ta cati ra chi ra ti: ―Ña cua quihvi cun tichi ñuun cun, ta ni ña cua cati cun ñaan cha ni tahun chi ñivi ñuun cun ―cati ra Jesuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tacan cuu, ta cuahan ra Jesuu chi ra sacuaha chi ra. Iti ñuhun Cesarea cha iyo cuenda ra Felipe cuahan ra ta ra, ta yaha ra ta ra ñuun ta ñuun. Ni vii cuahan ra ta ra iti, ta quechaha nducu tuhun ra Jesuu chi ra sacuaha chi ra ti: ―¿Yoo rai cui cati ñivi? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ta cati ndico ra ta ra chi ra ti: ―Iyo ñivi cati ti ra Juaan ra sacuanduta cuun, ta cati inga ñivi ti Elía cuun, ta inga ndico tucu ñi cati ti iin ra cahan cuenda ra Ndioo cuu cun ―cati ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ta quechaha nducu tuhun ra chi ra ta ra ti: ―Ta maan ndo, ¿yoo rai cui cati ndo? ―cati ra. Ta cati ndico ra Pedro chi ra ti: ―Yoho ra Cristo cuu cun. Maun cuu ra ni tava tiñu ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tacan, ta cati tuhun xaan ra Jesuu chi ra ta ra ti ña cua cati ra ta ra yoo rai cuu ra ni chi iin ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tacan cuu, ta quechaha cati ra Jesuu chi ra ta ra, vati iyo cha cua ndehe ra cuu sehe ñivi cuaha xaan tu ndoho, ta ra cuu ra chanihin chi ra sutu chahnu chi ra sacuaha ley chahnu cua tava ndaa chi ra, ta cua cuvi ra, ta cua natacu ndico ra tichi uni quivi. ");
INSERT INTO mioNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cachin xaan cha cati ra Jesuu tuhun can. Tacan, ta quee siin ra Pedro chi ra Jesuu, ta quechaha cati ra Pedro can chi ra ti ña vaha cha cahan ra tacan, ");
INSERT INTO mioNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","soco ndico coo ra Jesuu, ta ndehe ra nuun ra sacuaha chi ra, ta quechaha nduxaan tahan ra chi ra Pedro. Cati ra chi ra ti: ―Cha cua queun, yoho Pedro. Maun cuu sava ta cua run Satanaa, vati ña saxini cun cuhva saxini ra Ndioo. Saxini cun cuhva saxini ñivi ñuñivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tacan cuu, ta cana ra Jesuu chi ndihi ñivi can chi ra sacuaha chi ra, ta quechaha cati ra chi ñi ti: ―Tu cua cuni ñivi coo ñi chihin yu icaa ni, na ña cua saxini ca ñi suvi ni cuenda maan ñi, ta na cua coo tahan tu ndoho chi ñi cuhva cua coo ñi chi tu ndoho nu cruu, ta na cua coo ñi chi main icaa ni. ");
INSERT INTO mioNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tu cua cuni ñivi coo vaha anima ñi cha tacan, cua ndoyo ñuhun ñi, soco tu cua cahnda ini ñi, ta tu cua cuvi ñi cuenda yu a cua cuvi ñi cuenda tuhun cahin, cua coo ndito ñi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ñahni yavi ndaa yo, tu cua sacanaan yo ndihi cuii cha iyo nu ñuhun ñuñivi ya, ta cua cuvi xiti yo. ");
INSERT INTO mioNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ñahni cha iyo cha cua cuhva yo, ta cua coo ndito ndico yo. ");
INSERT INTO mioNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Iyo ñivi ñuñivi vitin, ta ña cuni ñi sacahnu ñi chi ra Ndioo. Mani ndavaha ni cuni ñi savaha ñi. Tu cua coo tu ca nuun chi ñi cuenda yu ta cuenda tuhun cahin, cua coo tahan tu ca nuun chi ra cuu sehe ñivi cuenda ñican quivi cua quichi ra chi ra tatun Ndioo quivi cua ndehe ñivi ti cha cahnu xaan rai cuu sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ni vii cahan ra Jesuu chi ñi, ta cati ra ti: ―Cati ndicha yu chihin ndo ti iyo ñivi inda ihya, ta ña cua cuvi ñi nda cua nda quivi cua ndehe ñi ti iyo xaan tu ndee ini chi ra Ndioo nu ndaca ñahan ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yaha iñu quivi, ta quihin ra Jesuu chi ra Pedro chi ra Jacobo chi ra Juaan, ta quee siin ra ta ra. Chandaca ra Jesuu chi ra ta ra siqui iin yucu sucun xaan. ");
INSERT INTO mioNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tacan cuu, ta sama ra Ndioo cuhva caa ra Jesuu iti nuun ra ta ra. Cuhva caa tachan caa sahma ra, vati cuichin xaan chi cuu. Ña ta ñahni iin ñahan nacata cuichin sahma cuhva cha nducuichin sahma ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ndehe ra ta ra ti cha iyo tahan ra Elía chi ra Moisee chi ra Jesuu, ta ndatuhun tahan ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tacan cuu, ta cati ra Pedro chi ra Jesuu ti: ―Vaha xaan cha iyo tahan ndi ihya, maestru. Na cua savaha ndi uni tiahva―iin chi maun ta inga chi ra Moisee ta inga chi ra Elía ―cati ra Pedro can. ");
INSERT INTO mioNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ta ña chito ra cha cahan ra, vati yuhvi xaan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yaha iin vico, ta chasi chi nuun ra ta ra, ta nducahan ra Ndioo tichi vico can, ta cati ra ti: ―Rahya cuu sehi. Cuni xain chi ra. Na cua taa vaha ndo soho ndo cha cahan ra ―cati maan ndusu can. ");
INSERT INTO mioNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Quii xaan nanducu nuun ra ta ra, soco ña ndehe ca ra ta ra chi ra Moisee chi ra Elía can. Iin tuhun ni maan ra Jesuu ndoo chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tacan cuu, ta nuun ra ta ra yucu can, ta cati tuhun xaan ra Jesuu chi ra ta ra ti ña cua cuhva ra ta ra cuenda cha ni ndehe ra chi ni iin ñivi nda cua nda quivi cua natacu ndico ra cuu sehe ñivi tañu ñivi ndii. ");
INSERT INTO mioNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chacan cuu cha ñahni cha cahan ra ta ra, soco nducu tuhun xaan ra ta ra chi tahan ra ti ñaan cha cuu cha cua natacu ndico ñivi ndii, ");
INSERT INTO mioNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ta quechaha nducu tuhun ra ta ra chi ra Jesuu ti: ―¿Ñacu cati ra sacuaha ley chahnu can ti iyo cha cua quichi xihna ra Elía? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ta cati ndico ra chi ra ta ra ti: ―Ndicha ti xihna ca cha cua quichi ra Elía, ta cua tiso vaha ra ndihi tiñu. Cati tutu Ndioo cuenda ra cuu sehe ñivi ti ña cua chaa ini ñivi chi ra, ta cua ndehe ra cuaha xaan tu ndoho, cati chi. ");
INSERT INTO mioNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yuhu cati chi ndo ti cha ni quichi ra Elía, ta savaha ñi ndihi cuhva cuni ñi chi ra cuhva cati tutu Ndioo cuenda ra ―cati ra, vati cuenda ra Juaan ra sacuanduta cahan ra tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tacan cuu, ta queta ra Jesuu nuun inda ndihi ra sacuaha chi ra, ta ndehe ra ti cha indi ra ta ra sava mahñu ñivi can, ta tuvi ñi cuu ñi, ta cahan yuhu xaan ra sacuaha ley chahnu can chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Quii xaan ndehe ndihi ñivi can chi ra Jesuu, ta iyo xaan quechaha cuni ñi, ta chinu ñi. Cuahan ñi nu vachi ra, ta quechaha sacahnu ñi chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ta quechaha nducu tuhun ra chi ra sacuaha chi ra ti: ―¿Ñaan cha cuu cha cahan xaan ndo chi ra ta ra? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ta cati ndico iin rai indi mahñu ñivi can ti: ―Maestru, vachi ndaque sehi chihun, vati ñuhun tati cuihna anima ra, ta ña chaha run cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Iyo hora tiin run chi ra, ta sanduva ihni run chi ra, ta quee iñu yuhu ra, ta chachi ndihi nuhun ra, ta ndunihin ra. Cha chahi cuenda chi ra sacuaha chihun ti na cua tava ra ta ra chi run, soco ña cuu chi racan ―cati ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ta cati ndico ra Jesuu chi ñivi can ti: ―Ndioho ñivi ña chinu ini cuu ndo. ¿Yoso ca quivi cua coi chi ndo? ¿Yoso ca quivi cua cundee ini yu cha cahan soho ndo? Na ndaca ndo chi ra ihya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tacan, ta chandaca ra chi ra nuun ra Jesuu, ta ndehe run tati cuihna can chi ra, ta quii xaan sandunihin run chi ra luhu can, ta nduva ra nu ñuhun can, ta quechaha chico tuvi ra nu ñuhun, ta quee tucu iñu yuhu ra, ");
INSERT INTO mioNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ta nducu tuhun ra Jesuu chi sutu ra luhu can ti: ―¿Yoso tiempu cha iyo cha savaha run chi ra tacan? ―cati ra. Ta cati ndico ra ti: ―Ni luhu ra, ta quechaha iyo run. ");
INSERT INTO mioNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Cuaha hora sanduva run chi ra nu cayu ñuhun, ta sanduva tahan run chi ra tichi nduta, vati cuni run cahni run chi ra. Tu cua cuu chi maun, na cua cundahvi ini cun chihin ndi. Na cua tindeun chi ndi ―cati sutu ra luhu can. ");
INSERT INTO mioNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ta cati ndico ra Jesuu chi ra ti: ―Tu cua cuu chi maun, vati cua cuu savaha ra chinu ini ndihi cha cuni ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Quii xaan ni cana chaa sutu ra luhu can ti: ―Chinu ini yu, soco na cua tindeun chihin yu, vati ña ta cuinu vaha ini yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tacan, ta ndehe ra Jesuu ti cha ni natahan xaan ñivi nu inda ra, ta quechaha nduxaan ra chi run tati cuihna can. Cati ra chi run ti: ―Yoho tati cuihna, cha cati yu chi yoho, vati chasi cun yuhu ra luhu ya. Chasi cun soho ra. Cua saña cun chi ra, ta ña cua quihvi con anima ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tacan cuu, ta quechaha cana chaa run, ta sandunihin run chi ra luhu can, ta quee run. Tacan, ta caa ra luhu can cuhva cha caa iin ndii. Chacan cuu cha cati ñivi can ti cha ni chihi cuii ra, ");
INSERT INTO mioNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","soco tiin ra Jesuu ndaha ra, ta sandoyo ra chi ra, ta chacuinda ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tacan cuu, ta quihvi ra Jesuu tichi vehe, ta quechaha nducu tuhun xehe ra sacuaha chi ra ti: ―¿Ñacu ña cuu tava ndi chi run? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ta cati ndico ra chi ra ta ra ti: ―Ña cuu tava yo chi rucan, tu ña cua cahan xihna yo chi ra Ndioo, tu ña cua coo ndita yo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tican quee ra Jesuu chi ra, ta cuahan ra ta ra. Chica cuu ra ta ra ñuhun Galilea, soco ña cuni ra Jesuu cha cua coto ñivi, ");
INSERT INTO mioNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","vati sacuaha ra chi ra sacuaha chi ra, ta cati ra chi ra ta ra ti: ―Cua xico tuhun ñivi chi ra cuu sehe ñivi, ta cua tiin ñivi chi ra, ta cua cahni ñi chi ra. Cua cuvi ra, soco tichi uni quivi cua natacu ndico ra ―cati ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ña nituni ini ra ta ra cha cahan ra Jesuu, ta yuhvi ra ta ra nducu tuhun ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tacan cuu, ta queta ra Jesuu ñuun Capernaum. Quihvi ra tichi vehe, ta quechaha nducu tuhun ra chi ra sacuaha chi ra ti: ―¿Ñaan cha cuu cha ndatuhun xaan ndo iti vachi yo? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ta taxin taxin ndaa ra ta ra, vati iti vachi ra ta ra ndatuhun ra ta ra ndaa ra cuu ra cahnu ca. ");
INSERT INTO mioNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ni chacunda ra Jesuu, ta cana ra chi ndihi uchi uvi ra sacuaha chi ra, ta quechaha cati ra chi ra ta ra ti: ―Tu cua cuni ñivi cuu ñi xini, iyo cha cua coo masu anima ñi, ta cua tindee ñi chi ndihi ca ñivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Quihin ra iin ve luhu, ta chaqui ndaa ra chi ve sava mahñu ra ta ra, ta chacunumi ndaa ra chi ve, ta quechaha cati ra chi ra ta ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Tu cua quihin cuenda ñivi chi iin ve luhu cuhva ve luhu ya cuenda yu, cua quihin cuenda tahan ñi chihin yu. Tu cua quihin cuenda ñi chihin yu, cua quihin cuenda tahan ñi chi ra ni tava tiñu chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tacan cuu, ta quechaha cati ra Juaan chi ra Jesuu ti: ―Maestru, ndehe ndi ti cahan iin rai sivi cun, ta tava ra tati cuihna anima ñivi, soco ña chica ra chihin yo. Ña chaha ndi cha tava ca ra tati cuihna can, vati ña chica ra chihin yo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Ña vaha cha ña chaha ca ndo. Tu cua savaha ñivi iin cha cahnu cuenda yu, ña cua cuu cuico coo ñi, ta quii xaan cahan ñi iin ndavaha ni cuenda yu. ");
INSERT INTO mioNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tu ña cua cani tahan ñivi chihin yo, cua cuinda naan ñi chihin yo. ");
INSERT INTO mioNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tu cua cuhva ñivi nduta coho ndo cuenda yu, vati maan ndo cuu ñivi yu, cati ndicha yu ti cua cunda yahvi ñi chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Tu cua satiyuhu ñivi ndavaha ni chi ñivi chinu ini chihin yu―masi iyo ñi chinu ini chihin yu cuhva iyo ve luhu ya, tu tacan ni cua satiyuhu ñivi ndavaha ni can, vaha ca cha cua cunuhni iin yoso sucun ñi, ta cua quehni ñi tichi nduta tañuhun, ta cua cuvi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tu cua cuni ndo savaha ndo cuati chi ndaha ndo, na cua sanini ndo chi ndaha ndo, ta ña cua savaha ca ndo cuati can. Vaha ca cha cua sanini ndo chi ndo, ta cua coo ndito ndo chi ra Ndioo ndihi ni quivi, coto ña cua cumi ndo chi ndo, ta cua cuhun ndo iti andaya nu cayu ñuhun ña ndahva. ");
INSERT INTO mioNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tican ña chihi ri tindacu, ta ni ña ndahva ñuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tu cua savaha ndo cuati chi chaha ndo, na cua sanini ndo chi chaha ndo, ta ña cua savaha ca ndo cuati can. Vaha ca cha cua sanini ndo chi ndo, ta cua coo ndito ndo chi ra Ndioo, coto ña cua cumi ndo chi ndo, ta cua cuhun ndo iti andaya nu cayu ñuhun ña ndahva. ");
INSERT INTO mioNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tican ña chihi ri tindacu, ta ni ña ndahva ñuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tu cua savaha ndo cuati chi titi nuun ndo, na cua sanini ndo chi titi nuun ndo, ta ña cua savaha ca ndo cuati can. Vaha ca cha cua sanini ndo chihin ndo, ta cua coo ndo nu cua cundaca ñahan Ndioo, coto cua tachi tuni ra Ndioo chihin ndo cha cuenda titi nuun ndo, ta cua cuhun ndo iti andaya ");
INSERT INTO mioNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nuun ña chihi ri tindacu, ta ni ña ndahva ñuhun can. ");
INSERT INTO mioNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Cua yaha ndihi ñivi nu iyo tu ndoho, vati tacan ni cua quee vaha ñi cuenda ra Ndioo. Chacan cuu cha iyo ñivi sava ni ta cua iyo ñiin. ");
INSERT INTO mioNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Vaha xaan chi, soco tu cha naan cha uhva chi, ñahni cha cuu savaha yo, ta cua coo ndico xico chi. Chacan cuu cha na cua coo vaha ndo chihin tahan ndo, ta na cua coo vii ndo chi tahan ndo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tican quee ra Jesuu, ta cuahan ra iti ñuhun Judea, ta yaha ra inga chiyo yuta Jordán. Nducuiti ndico tucu ñivi nuun iyo ra. Tuvi ñivi cuu ñi nducuiti, ta quechaha sacuaha tucu ra chi ñi cuhva iyo costumbre ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tacan cuu, ta queta tahan ra fariseo ta ra, ta quechaha nducu tuhun ra ta ra chi ra Jesuu a chaha ley chahnu cha cua saña iin rai chi ñasihi ra. Chacan nducu tuhun ra fariseo can, vati cuni ra tiso ra cuati ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ta nducu tuhun ndico ra Jesuu chi ra ta ra ti: ―¿Ñaan cha cuu cha ni cati tuhun ra Moisee chi ndo? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ta cati ndico ra ta ra ti: ―Ni chaha ra Moisee cha cua sandoyo ra rai iin tutu cha cua saña ra chi ñasihi ra. Chacan ni cua savaha ra, ta cua saña ra chi ña ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cha ni taa ra Moisee tuhun can chihin ndo tiempu chahnu can, vati ndava xaan ini ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nda ni quivi xihna cuii quivi ni tuvi ñuhun ñuñivi ya savaha ra Ndioo cha iyo ra rai, ta cha iyo tahan ña ñahan. ");
INSERT INTO mioNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chacan cuu cha nacoo ra rai chi sutu ra chi sihi ra, ta quihin ra chi ñasihi ra, ");
INSERT INTO mioNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ta cuu ñi uvi tahan, soco ñavi ca uvi ñivi cuu ñi, vati iin tuhun ni ñivi cuu ra chi ñasihi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cha satahan tahan ra Ndioo chi ñi. Chacan cuu cha ña cua cuu ca quenda tahan ñivi chi ñi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tacan cuu, ta tichi vehe nducu tuhun xehe tucu ra sacuaha chi ra Jesuu ñaan tuhun cuu tuhun can, ");
INSERT INTO mioNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ta cati ndico ra Jesuu chi ra ta ra ti: ―Tu cua nacoo iin rai chi ñasihi ra, ta cua quihin ra inga ñahan, cua savaha ra iin ndavaha ni chi ña, vati cuu chi sava ni ta cua ndacu maan ra ndavaha ni chi ñi ñahan inga chiyo. ");
INSERT INTO mioNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tu cua nacoo iin ñahan chi ra cuu ii ña, ta cua quihin ña inga rai, ta ni cuhva cua cuu chi cuhva ndacu maan ña ndavaha ni chi ra rai inga chiyo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tacan cuu, ta ndiso tahan ñivi chi ve cuati cuahan ñi nu iyo ra Jesuu, vati cuni ñi cha cua tiso ra ndaha ra chi ve, soco quechaha cati ra sacuaha chi ra Jesuu ti ña vaha cha savaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ndehe ra Jesuu cha ni savaha ra ta ra, ta quechaha nduxaan tahan ra chi ra ta ra, ta cati ra chi ra ta ra ti: ―Cuhva ndo cha cua quichi ve cuati ihya iti nuin. Ña cua casi ndo nu vachi ve, vati cuhva iyo ve cuati ya cua coo ñivi cua quihvi nu cua cundaca ñahan ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cati ndicha yu chihin ndo ti tu ña cua cuinu ini ndo ti cua coo ndo chi ra Ndioo nu cua cundaca ñahan ra cuhva chinu ini ve cuati, ña cua cuu coo ndo chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tacan, ta ni quihin ra chi ve cuati can, ta tiso ra ndaha ra chi ve, ta cahan vii ra chi ve. ");
INSERT INTO mioNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cha quee iti tucu ra Jesuu, ta chinu iin rai nu cuahan ra. Cha satahan ra chi ra, ta chacuiñi chiti ra nuun ra, ta quechaha nducu tuhun ra chi ra ti: ―Yoho maestru, vaha xaan rai cuu cun. ¿Ñaan cha cuu cha cua savahi, ta cua coo ndito yu chi ra Ndioo ndihi ni quivi ndihi ni tiempu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ta nducu tuhun ndico ra Jesuu chi ra ti: ―¿Ñacu cati cun ti rai vaha cui? Ñahni ni iin ñivi vaha iyo. Iin tuhun ni ra Ndioo cuu rai vaha ndicha. ");
INSERT INTO mioNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Chito maun yoso cuhva cati ley chahnu. Cati chi ti ña cua savaha yo ndavaha ni chi tahan yo inga chiyo. Ña cua cahni yo chi ñivi tahan yo. Ña cua suhu yo cha iyo chi tahan yo. Ña cua sandahyu ñahan yo chi tahan yo. Ña cua quihin yo ndatiñu tahan yo. Cua sacahnu yo chi sutu yo chi sihi yo, cati chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ta cati ndico ra chi ra ti: ―Nda quivi cha cui ra luhu, sacuinu yu ndihi cha cahun, maestru ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ndehe ra Jesuu nuun ra, ta cundahvi ini ra chi ra, ta cati ra chi ra ti: ―Ni vii iyo inga cha cumani chihun. Cuahan, ta xico cun ndihi cha iyo chihun, ta cuhvon xuhun can chi ñivi ndahvi, ta cua coo yahvi cun iti siqui andivi. Tacan, ta nahan. Na cua caca cuu cun chihin yu icaa ni ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tacan cuu, ta quechaha ndundahvi cuni ra cha cahan ra Jesuu, ta quee ra cuahan ra, vati iyo xaan ndatiñu ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tacan cuu, ta nanducu nuun ra Jesuu, ta quechaha cati ra chi ra sacuaha chi ra ti: ―Ii xaan cha cua quihvi ñivi iyo xaan ndatiñu nu cua cundaca ñahan ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iyo xaan quechaha cuni ra sacuaha chi ra cha chini ra tuhun cha cahan ra, ta cati ndico tucu ra Jesuu chi ra ta ra ti: ―Yani xaa, ii xaan cha cua quihvi ñivi nu cua cundaca ñahan ra Ndioo, tu cua saxini ñi cuenda xuhun ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ña cuu yaha ri camellu yavi xuu quiticu, soco ii xaan ca cha cua quihvi ñivi ricu nu cua cundaca ñahan ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iyo xaan iyo xaan quechaha cuni ra ta ra, ta quechaha cati ra chi tahan ra ti: ―Yoni ñivi cua cundee quee vaha, tu tacan ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ta ndehe ra Jesuu chi ra ta ra, ta cati ndico ra chi ra ta ra ti: ―Ña cua cuu chi ñivi, soco cua cuu chi ra Ndioo, vati cua cuu savaha ra ndihi cuii cha cuni ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ta quechaha cati ra Pedro chi ra ti: ―Cha ni nacoo ndi ndihi cha iyo chi ndi, ta chica ndi chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ta cati ndico ra Jesuu ti: ―Cati ndicha yu chihin ndo ti tu cua nacoo ñivi vehe ñi chi tahan ñi chi sutu ñi chi sihi ñi chi ñasihi ñi chi sehe ñi chi ñuhun ñi, vati cuni ñi chihin yu chi tuhun cahin, ");
INSERT INTO mioNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cua nihin ndico tucu ñi ndihi chacan vitin tichi quivi ya. Cua coo ndico vehe ñi chi tahan ñi chi sihi ñi chi sehe ñi chi ñuhun ñi, soco cua ndehe tahan ñi tu ndoho tichi quivi ya, ta nu cuahan quivi cua coo ndito ñi chi ra Ndioo ndihi ni quivi ndihi ni tiempu. ");
INSERT INTO mioNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tuvi ñivi iyo iti nuun cua ndoo ihni iti chata, ta ñivi iyo iti chata cua yaha iti nuun ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cuahan ra ta ra iti ñuun Jerusalén. Ni vii chica ra ta ra iti, ta iti nuun cuahan ra Jesuu. Iyo xaan cuni ra sacuaha chi ra, soco ñivi vachi iti chata yuhvi ñi suhva. Tacan cuu, ta quihin tucu ra Jesuu chi ndihi uchi uvi ra sacuaha chi ra, ta quee siin ra chi ra ta ra, ta quechaha cati tucu ra chi ra ta ra ñaan cha cuu cha cua tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Cati ra Jesuu ti: ―Cuahan yo iti ñuun Jerusalén, ta cua xico tuhun ñivi chi ra cuu sehe ñivi, ta cua tiin ra sutu chahnu chi ra sacuaha ley chahnu chi ra, ta cua tachi tuni ra ta ra chi ra. Cua cati ra ta ra ti cua cuvi ra. Tacan cuu, ta cua cuhva cuenda ra ta ra chi ra chi ñivi quichi inga ñuhun, ");
INSERT INTO mioNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ta cua sacateni ñi chi ra, ta cua tivi sivi ñi chi ra, ta cua cani ñi chi ra chi yoho, ta cua cahni ñi chi ra, soco tichi uni quivi cua natacu ndico ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tacan cuu, ta tuhva ra Jacobo chi ra Juaan iti nuun ra Jesuu. Suvi ni sehe Zebedeo chi ra ta ra, ta quechaha cati ra chi ra Jesuu ti: ―Maestru, cuni ndi cha cua savahun ñaan cha cuu cha cua ndaca ndi chihun ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ta cati ndico ra chi ra ta ra ti: ―¿Ñaan cha cuu cha cuni ndo cua savahi chi ndo? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ta cati ra ta ra chi ra ti: ―Quivi cua nihun ndatu na cua cuhva tahun ndatu chi ndi, ta cua cunda iin ndi iti chiyo ndaha cuaha cun, ta cua cunda inga ndi iti chiyo ndaha satin cun ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Ña chito ndo ñaan cha cuu cha chica ndo. ¿Atu cua cuu coho ndo copa cha cua coho yu? ¿Atu cua cuu cuanduta ndo cuhva cua cuandute? Tacan nducu tuhun ra chi ra ta ra, vati cahan ra cuenda tu ndoho cha cua tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ta cati ndico ra ta ra chi ra Jesuu ti: ―Cua cuu ―cati ra ta ra. Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cua coho ndicha ndo copa cua coho yu, ta cua cuanduta tahan ndo cuhva cua cuandute, ");
INSERT INTO mioNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","soco ña cuu cuhve cha cua cunda ndo iti chiyo ndaha cuahi ni iti chiyo ndaha satin. Maan ra Ndioo cuu ra cua cati yoo ra cua nihin ndatu can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tacan cuu, ta chito tahan ndihi inga uchi ra sacuaha chi ra Jesuu, ta quechaha nduxaan ra ta ra chi ra Jacobo chi ra Juaan can. ");
INSERT INTO mioNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tacan cuu, ta cana ra Jesuu chi ra ta ra, ta quechaha cati ra chi ra ta ra ti: ―Chito ndo yoso cuhva iyo rai ndaca ñahan chi ñivi ñuñivi. Ndurai xaan ra cha ndaca ñahan ra chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ñavi tacan ni cua savaha maan ndo. Tu cua cuni ndo cuu ndo ñivi cahnu, na cua cuu ndo sava ta cua iin musu chi tahan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tu cua cuni ndo cuu ndo xini, cua tindee ndo chi ndihi ñivi tahan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tacan cati yu, vati ña nducu ra cuu sehe ñivi cha cua tindee ñivi chihin ra, soco quichi ra, vati cuni ra tindee maan ra chi ñivi. Chacan cuu cha cua cuvi ra cuenda cuati ndihi ñivi, ta cua sanaan ra cha cumani ñi ―cati ra Jesuu chi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tacan cuu, ta queta ra Jesuu ñuun Jericó. Cha cua quee ra iin ñuun can, ta cuahan tahan ra sacuaha chi ra chi tuvi ñivi, ta ndaa ra Bartimeo sehe Timeo xiin iti can. Ra cuaa cuu ra, ta caya ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Chini ra ti ra Jesuu ñuun Nazaret cuu ra yaha iti can, ta quechaha cana chaa ra, ta cati ra ti: ―Yoho Jesuu, yoho ra cuu ñivi David, na cua cundahvi ini cun chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ta quechaha nduxaan ñivi can chi ra ti na cua cutaxin ra, soco nihin ca cana chaa ra, ta cati ndico tucu ra ti: ―Yoho ra cuu ñivi David, na cua cundahvi ini cun chihin yu ―cati ndico tucu ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tacan, ta ni chacuiñi ra Jesuu, ta quechaha cati ra ti: ―Cua cana ndo chi ra ―cati ra. Ta cana ñi chi ra cuaa can, ta cati ñi chi ra ti: ―Cua cundee ini cun. Cuinda cun, vati cana ra chihun ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nacoo ra sahma cha isucu ra, ta ndava lahndi ra, ta cuahan ra nu inda ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tacan, ta nducu tuhun ra Jesuu chi ra ti: ―¿Ñaan cha cuni cun cha cua savahi chihun? ―cati ra. Ta cati ndico ra cuaa can chi ra ti: ―Na cua ndundichin ndehi, maestru ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ta cati ra Jesuu chi ra ti: ―Cuahan. Cha ni nduvahun, vati chinu ini cun chihin yu ―cati ra. Ta quii xaan ni ndundichin vaha ndehe ra, ta chandicu ra chi ra Jesuu iti nu cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yatin ñuun Jerusalén cha cua queta ra ta ra, vati cha cua queta ra ta ra ñuun Betfagé chi ñuun Betania nu iyo yucu Olivo can, ta cha cua tachi ra Jesuu chi uvi ra sacuaha chi ra iti nuun. ");
INSERT INTO mioNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Cati ra chi ra ta ra ti: ―Cuahan ndo tichi ñuun caa iti nuun yo, ta sa cua quihvi ndo ñuun can, ta cua ndehe ndo cha nuhni iin ri buru, ta yoni ñivi chacoso chi ri. Cua ndachi ndo chi ri, ta cua quichi ndaca ndo chi ri ihya. ");
INSERT INTO mioNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tu cua nducu tuhun ñivi chi ndo ñaan ndacu ndo, cua cati ndo ti chini ñuhun ra chahnu chi ri. Nuni, ta cua tachi ndico ra chi ri, cua cati ndo ―cati ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tacan cuu, ta quee ra ta ra cuahan ra, ta nihin ra ta ra chi ri buru can. Nuhni ri yu vehe iti cahnu can, ta ndachi ra ta ra chi ri. ");
INSERT INTO mioNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Inda uvi ñivi ican, ta quechaha nducu tuhun ñi chi ra ta ra ti: ―¿Ñacu ndachi ndo chi ri buru can? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ta cahan ndico ra ta ra chi ñi cuhva ni cati ra Jesuu, ta chaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tacan, ta ni chandaca ra chi ri buru can nu iyo ra Jesuu. Tiso ra ta ra sahma ra chata ri, ta yoso ra Jesuu chi ri. ");
INSERT INTO mioNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tuvi xaan ñivi nducuiti, ta iyo ñi chaqui sahma cha cuisucu ñi nuun iti, ta iyo inga ñi chaqui tahan ndaha yutun chahnda ñi nu yaha ñi, vati tacan ni sacahnu ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tacan, ta iyo ñi cuahan iti nuun, ta iyo ñi cuahan iti chata, ta cana chaa ñi. Cati ñi ti: ―¡Cahnu xaan cuu ra Ndioo! ¡Cahnu xaan rai cuu ra vachi cuenda ra chahnu! ");
INSERT INTO mioNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Cahnu xaan rai cuu ra vachi, ta cua cundaca ñahan ra cuhva ni chacundaca ñahan ra David ra cuu ñivi yo tiempu chahnu! ¡Na cua sacahnu yo chi ra iyo iti siqui andivi! ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tacan cuu, ta ni quihvi ra Jesuu tichi ñuun Jerusalén. Tichi cora soco ndavi ve ñuhun cahnu quihvi ra, ta ndehe ra ndihi cha iyo ican. Cha cua cuaa cuu chi, ta quee ndico ra chi ndihi uchi uvi ra sacuaha chi ra. Cuahan ndico ra ta ra iti ñuun Betania. ");
INSERT INTO mioNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tuvi inga quivi, ta quee ndico ra ta ra ñuun Betania can, ta chisoco ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Chica vihi ni ndehe ra iin yutun tusihva tiñi vixin, ta cha iyo nda numa chi, ta cuahan ra nu inda maan chi, vati cuni ndehe ra a cha iyo chiti chi. Queta ra nu inda maan chi, soco mani numa chi iyo, vati ña ta queta quivi cha cua quee chiti chi, ");
INSERT INTO mioNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ta quechaha cati ra Jesuu chi maan yutun can ti: ―Ña cua cachi ca ñivi chiti cun nda vitin nda cua nda iti nuun ―cati ra. Ta chini ra sacuaha chi ra tuhun cha cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tacan cuu, ta queta ndico ra ta ra ñuun Jerusalén. Quihvi tucu ra ta ra cora soco ndavi ve ñuhun can, ta quechaha tava ihni ra Jesuu chi ñivi xico chi ñivi sata tichi cora can, ta sanduva ra mesa ñivi sama xuhun, ta sanduva tahan ra tayu ñivi xico chi ri ndivi can, ");
INSERT INTO mioNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ta ña chaha ra cha cua cuiso ñivi cuati suhva tichi cora can. ");
INSERT INTO mioNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Quechaha sacuaha ra Jesuu chi ñivi can, ta cati ra chi ñi ti: ―Cha cati tutu Ndioo ti cua cati ndihi ñivi iyo nu ñuhun ñuñivi ya ti vehe ra Ndioo cuu iin vehe nu cua cahan ñivi chi ra, cati chi, soco cha ni savaha maan ndo cha cuu chi iin vehe nu nducuiti run ñasuhu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chini ra sutu chahnu chi ra sacuaha ley chahnu tuhun cha cahan ra, ta quechaha nducu ra ta ra cuhva cua cahni ra ta ra chi ra Jesuu, soco yuhvi xaan ra ta ra chi ra, vati iyo xaan cuni ndihi ñivi chini tuhun cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cha cua cuaa tucu, ta quee ndico tucu ra Jesuu ñuun can. ");
INSERT INTO mioNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tuvi inga quivi, ta nahan xaan cuahan ndico tucu ra ta ra iti ñuun Jerusalén, ta ndehe ra ta ra ti cha ni neti yutun tusihva tiñi can nda cua nda yoho chi. ");
INSERT INTO mioNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ni ñuhun ini ra Pedro cha cahan ra Jesuu, ta quechaha cati ra chi ra Jesuu ti: ―¡Jihna! maestru. Cuxaun chi yutun tusihva tiñi ya, ta cha ni neti chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cua cuinu ini ndo chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cati ndicha yu chihin ndo ti tu cua cati ñivi chi yucu ya ti cua cuachiyo chi, ta cua cuhun chi tichi nduta tañuhun, ta ña cua saxini ñi chi anima ñi cha ña cua cuu, soco cua cuinu ini ñi ti cua coo chi cuhva cati ñi, tacan ni cua coo ndicha chi. ");
INSERT INTO mioNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chacan cuu cha cati yu chihin ndo ti na cua cuinu ini ndo cha cua quihin cuenda ndo ndihi cha cua ndaca ndo chi ra Ndioo, ta cua cuhva ra chi chi chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tu cua saxini ndo ndavaha ni chi ñivi, cua sandihi ndo chacan hora cua cuinda ndo, ta cua cahan ndo chi ra Ndioo. Chacan cuu cha cua sanaan tahan sutu ndo iyo iti siqui andivi cuati iyo chi maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tu ña cua sanaan ndo ndavaha ni savaha ñivi chi ndo, ña cua sanaan ra sutu ndo iyo iti siqui ndavaha ni savaha maan ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tacan cuu, ta queta ndico tucu ra Jesuu ta ra ñuun Jerusalén, ta chica cuu ra ta ra tichi cora soco ndavi ve ñuhun cahnu can, ta tuhva ra sutu chahnu chi ra sacuaha ley chahnu chi ra chanihin nu inda ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ta quechaha nducu tuhun ra ta ra chi ra ti: ―Cua cati cun ndaa iti cuu nu ni nihun ndatu cha ni savahun ndihi cuhva can. ¿Yoo chaha ndatu can chihun? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cua nducu tuhin iin tuhun chi maan ndo, ta cua cati ndico ndo. Tacan, ta sa cua cuhva tahin cuenda chi ndo ndaa iti cuu nu ni nihin yu ndatu cha savahi chacan. ");
INSERT INTO mioNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Atu ni sacuanduta ra Juaan chi ñivi cuenda ra iyo iti siqui a ni sacuanduta ra chi ñi cuenda ñivi ñuñivi? Vitin cua cati ndico ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tacan, ta quechaha ndatuhun tahan ra ta ra chi tahan ra, ta cati ra ti: ―Tu cua cahan yo ti cuenda ra iyo iti siqui, cua cati ra ñacu ña chinu ini yo chihin ra. ");
INSERT INTO mioNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tu cua cahan yo ti cuenda ñivi ñuñivi, cua nduxaan ñivi ya chihin yo ―cati ra ta ra. Yuhvi xaan ra ta ra chi ñivi can, vati cati ndihi ñi ti ra ni cahan cuenda ra Ndioo cuu ndicha ra Juaan, ");
INSERT INTO mioNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ta cati ndico ra ta ra chi ra Jesuu ti: ―Ña chito ndi ―cati ra ta ra. Ta cati ndico ra Jesuu chi ra ta ra ti: ―Ta ni cuhva ña cua cati yu chihin ndo yoo rai ni chaha ndatu cha savahi chacan ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tacan cuu, ta quechaha cahan ra Jesuu iin cuhva chi ra ta ra, ta cati ra ti: ―Cha iyo iin rai, ta chaqui ra yava yoho chiti uva. Chasi ra iin cora, ta nañu ra yavi nu cua quee nduta chiti uva can, ta savaha ra iin tiahva. Tacan cuu, ta chaha nuun ra chiqui can chi inga rai, ta quee iti ra. Cuahan ra inga ñuun, ");
INSERT INTO mioNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ta queta quivi tachi ra iin musu ra nu iyo ra quihin nuun chiqui can, vati cua cuhva ra ta ra chiti uva can chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tacan cuu, ta tiin ra ta ra chi ra musu can, ta cani ra ta ra chi ra, ta tachi ndico ra ta ra chi ra, ta ñahni cha ni chaha ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tachi ndico tucu ra chitoho can inga musu ra nu iyo ra quihin nuun chiqui can, ta cani ra ta ra chi ra musu can chi yuu, ta sanicuehe ra ta ra xini ra, vati ña sacahnu ra ta ra chi ra, ta tachi ndico ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tacan cuu, ta tachi ndico tucu ra chitoho can inga musu ra, ta chahni ra ta ra chi racan. Cuaha ca musu tachi ra cuu chitoho can, soco cani ra ta ra chi ra, ta chahni ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ni ndoo inga tuhun ca ra nuun ra chitoho can. Sehe taqui xaan ra chi ra, ta tava tiñu tahan ra chi sehe ra nu iyo ra quihin nuun chiqui can, vati cati ra ti cua sacahnu ra ta ra chi sehe ra, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tacan, ta quechaha cati ra quihin nuun chiqui can chi tahan ra ti racan cuu sehe ra. Vitin cua cahni ra chi ra, ta cua ndoo ndatiñu ra chi maan ra, cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tacan cuu, ta ni tiin ra ta ra chi ra, ta chahni ra ta ra chi ra, ta savita ra ta ra iquin cuñu ra chata cora can ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tacan, ta cati ndico ra Jesuu chi ra ta ra ti: ―¿Ñaan cha cuu cha cua savaha ra chitoho chiqui can? Cua cuhun ra, ta cua cahni ra chi ra quihin nuun chiqui ra, ta cua cuhva nuun ndico tucu ra chiqui ra chi inga tucu rai. ");
INSERT INTO mioNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Vasi ña ta sacuaha ndo tutu Ndioo nu cati chi ti: Iyo iin yuu, ta cati ra sandaa vehe ti ña vaha chi, soco yuu can cha cuu yuu cahnu tutu vehe. ");
INSERT INTO mioNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chacan ni savaha ra chahnu, ta vaha xaan cuni ñivi ndehe ñi chi chi, cati tutu Ndioo can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tacan cuu, ta nducu ra ta ra cuhva cha cua tiin ra ta ra chi ra Jesuu, vati chito ra ta ra ti chaha ra Jesuu cuenda yoso cuhva iyo ra ta ra, soco yuhvi ra ta ra chi ñivi. Tacan, ta quee ra ta ra, ta cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tacan cuu, ta tava tiñu ra ta ra chi ra fariseo chi ra inda naan chi ra Herode nu iyo ra Jesuu, vati cuni ndehe ra ta ra a ña cua cahan ra Jesuu iin cha ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Queta ra ta ra nu iyo ra Jesuu, ta cati ra chi ra ti: ―Yoho maestru, chito ndi ti cha ndicha cuun, ta quihin cuenda cun chi ndihi ñivi, vati ña ndehun ndaa ñi cuu ñi a ricu ñi a ndahvi ñi. Ndicha ndicha sanahan cun iti ra Ndioo. ¿Atu vaha cha cua cuhva ndi xuhun ñuhun chi ra César ra cumi tiñu iyo ñuun Roma a ña vaha? ¿Atu cua cuu cuhva ndi a ña cua cuu? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Chito ra Jesuu ti vata ra ta ra, ta quechaha cati ndico ra chi ra ta ra ti: ―¿Ñacu cuni ndo cha cua savahi iin cha ndavaha ni? Cuhva ndo iin xuhun chihin yu na ndehi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chaha ra ta ra iin xuhun, ta quechaha nducu tuhun ra chi ra ta ra ti: ―¿Yochi xini ndiso chi? ¿Yochi sivi ndiso chi? ―cati ra. Ta cati ndico ra ta ra chi ra ti: ―Xini ra César cuu chi chi sivi ra ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ta cati ra Jesuu chi ra ta ra ti: ―Cua cuhva ndo cha cuu chi ra César chi ra, ta chi ra Ndioo cua cuhva ndo cha cuu chi maan ra ―cati ra. Tacan, ta quechaha nduiyo xaan cuni ñivi cha cahan ra, vati vaha xaan cahan ndico ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tacan cuu, ta queta tahan ra saduceo ta ra iti nuun ra Jesuu. Ra saduceo can cuu ra cati ti ña cua natacu ndico ñivi ndii, ta quechaha cati ra ta ra chi ra Jesuu ti: ");
INSERT INTO mioNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestru, tiempu chahnu ni taa ra Moisee cuenda yo ti tu cua cuvi iin rai, ta ni vii iyo ñasihi ra, ta ñahni sehe ra ni chacoo, na cua tandaha yani ra chi ña, ta tacan cua coo sehe ña cuenda yani ra, cati ra Moisee chi yo. ");
INSERT INTO mioNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ni chacoo ucha tahan rai. Yani ra chi ra, ta tandaha ra chanihin can chi ñasihi ra, ta ñahni sehe ra chacoo, ta queta quivi ni chihi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tacan, ta quihin tahan yani ra chi ña, ta ñahni sehe ra chacoo, ta chihi tahan ra. Tacan ni savaha tahan inga ra yani ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tacan, ta quihin ndihi ucha tahan ra chi ña, soco ñahni sehe ra chacoo chi ña, ta queta quivi ni chihi tahan maan ña ñahan can. ");
INSERT INTO mioNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Yochi ñasihi cua cuu ña quivi cua natacu ndico ñivi ndii, vati ndihi ucha tahan ra ta ra chacucumi chi ña? ―cati ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ta quechaha cati ndico ra Jesuu chi ra ta ra ti: ―Chacan cuu cha ndoyo ñuhun ndo, vati ña chito ndo cuhva cati tutu Ndioo, ta ni ña chito ndo ti cha iyo xaan tu ndee ini chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cua queta quivi cha cua natacu ndico ñivi ndii, ta ña cua tandaha ca ra rai chi ñasihi ra, ta ni ña cua tandaha ca ñi ñahan chi ii ñi, soco cua coo ndihi ñivi cuhva iyo tatun Ndioo iti siqui andivi, ");
INSERT INTO mioNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ta cuenda ñivi ndii―cua sanatacu ndico ra Ndioo chi ñi. Vasi ña ta sacuaha ndo tutu Moisee nu ni chaha ra cuenda yoso cuhva ni cayu cuhu can. Ican ni cati ra Ndioo chi ra ti maan ra cuu ra Ndioo. Sacahnu ra Abraham chihin ra, ta sacahnu tahan ra Isaac chi ra Jacobo chihin ra, cati ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ña cuu sacahnu ñivi ndii chi ra Ndioo, soco sacahnu ra ta ra chi ra, vati ni vii iyo ndito ndico ra ta ra. Cuaha xaan cha ndoyo ñuhun ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tacan cuu, ta queta tahan iin ra sacuaha ley chahnu can nu inda ra Jesuu, ta chini ra cha nducu tuhun xaan ra ta ra chi ra Jesuu, ta chito ra ti vaha xaan cati ndico ra Jesuu chi ra ta ra, ta quechaha nducu tuhun ra chi ra Jesuu ti: ―¿Ndaa ley cuu cha cuu cha cahnu ca cati tuhun ra Ndioo? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ta cati ndico ra Jesuu ti: ―Tuhun cha cahnu ca cuu chehe: “Ndioho ñivi Israel, chini ndo. Iin tuhun ni ra cuu ra chahnu Ndioo, ta ndaca ñahan ra chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cua cuni ndo chi ra chahnu Ndioo chi ndihi cuii anima ndo chi ndihi cuii cha chini tuni chi ndo chi ndihi cuii cha vaha chi ndo.” Chacan cuu cha xihna cuii, ");
INSERT INTO mioNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ta cha cuu uvi can cha cati tuhun ra Ndioo cuu chehe: “Cua cuni ndo chi ndihi ñivi tahan ndo cuhva cuni ndo suvi ni chi maan ndo.” Ñahni inga tuhun cahnu ca cha cati tuhun ra Ndioo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ta cati ndico ra sacuaha ley can chi ra ti: ―Vaha xaan cahun, maestru. Cati ndicha cun, vati iin tuhun ni Ndioo iyo, ta ñahni inga ra cahnu ca. ");
INSERT INTO mioNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Vaha xaan cuhva cha cati cun ti cha cua cuni yo chi ra chi ndihi cuii anima yo chi ndihi cuii cha chini tuni chi yo chi ndihi cuii cha vaha chi yo. Vaha cha cati cun ti cha cua cuni mani yo chi ndihi ñivi tahan yo cuhva cuni yo suvi ni chi maan yo. Vaha xaan ca chacan, ta ñavi ca cha chahmi yo chi ri quiti cuhu cha samani yo chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ndehe ra Jesuu ti vaha xaan cati ndico racan, ta cati ra chi ra ti: ―Ña cumani xaun, ta cua coo tahun nu cua cundaca ñahan ra Ndioo ―cati ra. Tacan, ta yuhvi xaan ra ta ra nducu ra cuhva cha cua nducu tuhun ca ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ni vii sacuaha ra Jesuu chi ñivi tichi cora soco ndavi ve ñuhun cahnu can, ta quechaha nducu tuhun ra chi ñi ti: ―¿Ñacu cati ra sacuaha ley chahnu ti ra Cristo cuu tata ra David nu cuahan quivi? ");
INSERT INTO mioNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Suvi ra David chaha cuenda, vati chaha ra Tati Ndioo tu ndee ini chi ra, ta cati ra David can ti: Cati ra chahnu Ndioo chi ra cuu chitoho ra David ti cua cuhva ra ndatu chi ra, vati cua cunda ra iti chiyo ndaha cuaha ra Ndioo, ta cua cuhva ra tu ndee ini chihin ra, ta cua sacanaan ra chi ndihi ñivi cuxaan ini chihin ra, cati ra Ndioo, cati ra David tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Suvi ra David cati ti chitoho ra cuu ra Cristo. Chacan cuu cha ñacu cuu ra Cristo tata ra David nu cuahan quivi iti nuun ―cati ra Jesuu. Ta sii xaan cuni ndihi ñivi can chini ñi tuhun cha cahan ra Jesuu, vati cachin xaan cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sacuaha xaan ra Jesuu chi ñivi can, ta cati ra chi ñi ti: ―Cua saha vaha xaan ndo cuenda yoso cuhva cati tuhun ra sacuaha ley chahnu chi ndo, vati cuni xaan ra caca cuu ra, ta ndichin ra sahma taqui taqui, ta cuni tahan ra na cua sacahnu ndihi ñivi chi ra nuyahvi. ");
INSERT INTO mioNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Cuni ra cua tahan ra tayu vaha tichi ve ñuhun, ta cuni xaan ra cua tahan tahan ra tayu vaha nu chachi ñivi, ta sacahnu ñi vico. ");
INSERT INTO mioNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Cuaha xaan cua cutuni ra sacuaha ley can, vati suhu ra ndatiñu ñi ñahan ndahvi, ta nahan xaan cahan ra chi ra Ndioo, vati na ndehe ñivi can chi ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tacan cuu, ta ni ndaa ra Jesuu yatin nu tihi ñivi xuhun cha samani ñi chi ra Ndioo, ta ndehe ra yoso cuhva tihi ñi xuhun ican. Cuaha xuhun tihi ñi ricu, ");
INSERT INTO mioNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ta sa quichi iin ña ndahvi. Ndahvi xaan ndicha iyo ña, ta tihi ña uvi xuhun cuati cha cuu uchi centavu. ");
INSERT INTO mioNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tacan cuu, ta cana ra Jesuu chi ra sacuaha chi ra, ta quechaha cati ra chi ra ta ra ti: ―Cati ndicha yu chihin ndo ti cha tihi ña ndahvi can cuaha ca xuhun cuenda ra Ndioo, ta ñavi ca sa ndihi ca ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tihi ñivi xuhun ñi, vati iyo xuhun chi ñi, soco ndahvi xaan ñacan, ta tihi ña ndihi cha iyo chi ña. Chaha ña ndihi ndihi xuhun ña, ta ñahni ca cha ni ndoo chi ña ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tacan cuu, ta quee ndico tucu ra Jesuu cora soco ndavi ve ñuhun cahnu can, ta quechaha cati iin ra sacuaha chi ra ti: ―Ndehe, maestru. Nahnu xaan yuu ndaa vehe can. Taqui xaan chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ta cati ndico ra Jesuu chi ra ti: ―Ndehun ti nahnu xaan vehe can, soco ña cua ndoo iin yuu siqui tahan chi, vati ndihi chi cua tani ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tacan cuu, ta cuahan ra Jesuu, ta ndaa ra siqui yucu Olivo can. Inga chiyo xahva iti nuun ve ñuhun can iyo yucu can, ta ican ni chacunda ra Jesuu, ta iyo tahan ra Pedro chi ra Jacobo chi ra Juaan chi ra Ndree, ta nducu tuhun xehe ra ta ra chi ra Jesuu ti: ");
INSERT INTO mioNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Na cua cuhvon cuenda chi ndi. ¿Ndaa quivi cua coo cha cati cun cuenda ve ñuhun ya? ¿Yoso cuhva cua coto ndi ti cha queta quivi cua coo ndihi cha cati cun cuenda ve ñuhun ya? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cua saha ndo cuenda, coto cua sandahyu ñahan ñivi chi ndo nu cuahan iti nuun. ");
INSERT INTO mioNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tuvi ñivi cua quichi, ta cua cahan ñi sivi yu, ta cua cati ñi ti maan ñi cuu ra Cristo, ta cua sandahyu ñahan ñi chi tuvi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Cua queta quivi cua cati ñivi chi ndo ti yatin cua coo cuati, ta cha iyo cuati, soco ña cua cuyuhvi ndo. Tacan ni cua coo chi quivi can, soco ña ta cundihi quivi ya. ");
INSERT INTO mioNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cua cani tahan iin ñivi chi inga ñivi, ta cua cani tahan ñivi iyo iin ñuun chi ñivi iyo inga ñuun. Cua taan xaan nini cahnu nu ñuhun ñuñivi, ta cua coo tama, ta cua cuvaa xaan ñivi. Tacan ni cua quechaha coo tu ndoho chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Cua tiso vaha ndo cuenda chi ndo, vati cua tiin ñivi chi ndo, ta cua cunaan ñi chihin ndo iti nuun ra chanihin cuenda ve ñuhun, ta cua cani ñi chihin ndo tichi ve ñuhun, ta cua yaha ndo nuun ra cumi tiñu, vati chinu ini ndo chihin yu. Chacan cuu cha cua coto tahan ra yoso cuhva iyo ndo cuenda yu. ");
INSERT INTO mioNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Iyo cha cua cati tuhun xihna ñivi tuhun vaha yoso cuhva iyo ra Ndioo chi ndihi ñivi ñuñivi, ta sa cua cundihi quivi ya. ");
INSERT INTO mioNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tu cua tiin ñivi chi ndo, ta cua cunaan ñi chihin ndo iti nuun ra cumi tiñu, ña cua saxini ndo ñaan cha cuu cha cua cahan ndo, soco cua cahan ndo ñaan cha cuu cha cua tiso ra Ndioo xini ndo hora can, vati ñavi ndioho cua cahan, soco ra Tati Ndioo cuu ra cua cahan. ");
INSERT INTO mioNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Cua xico tuhun ra rai chi yani ra, ta cua cuhva cuenda ra chi ra na cua cuvi ra. Cua xico tuhun tahan ñivi chi sehe ñi, ta cua cuhva cuenda tahan ñi chi ñi na cua cuvi ñi. Cua cani tahan ñivi chi sutu ñi chi sihi ñi, ta cua cahni ñivi chi sehe ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Cua cuxaan ini ndihi ñivi chi ndo, vati chi main cuu ndo. Tu cua cundee ñivi nda cua nda cua cundihi quivi ya, cua sacacu ra Ndioo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Tiempu chahnu cha ni cati ra Daniel ra ni cahan cuenda ra Ndioo ti cua quihvi run cua sacaquini ve ñuhun nu ii xaan, ta cua sandoyo ñuhun run ndihi cha iyo. Na cua cutuni ini ñivi sacuaha tuhun ya. Quivi cua ndehe ñivi chacan na cua cunu ndihi ñivi iyo ñuhun Judea iti yucu. ");
INSERT INTO mioNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tu inda ñivi xini vehe ñi, ña cua nuun ñi tichi vehe. Ña cua quihvi ñi tichi vehe quihin ñi ndatiñu ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tu inda ra rai iti chiqui, ña cua ndico coo ra quihin ra coton ra. ");
INSERT INTO mioNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tu ndoho cua ndehe ñi ñahan ñuhun sehe quivi can, ta tu ndoho cua ndehe tahan ñi ñahan sacaxi sehe tiempu can. ");
INSERT INTO mioNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Na cua cahan ndo chi ra Ndioo ti na ña cua coo chacan tiempu vichin. ");
INSERT INTO mioNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Quivi can cua coo tu ndoho cahnu xaan, ta ña ta coo tu ndoho tacan nda ni quivi satuvi ra Ndioo ñuhun ñuñivi ya nda cua nda quivi vitin, ta ni ña cua coo ca tu ndoho cuhva can nu cuahan quivi. ");
INSERT INTO mioNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tu ña cua sandihi ra chahnu quivi can, yoni ñivi cua cacu, soco cua sandihi ra quivi can cuenda ñivi ni nacachi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ña cua cuinu ini ndo, tu cua cati ñivi chi ndo ti jihna ihya inda ra Cristo, tu cua cati ñi ti jihna ndacan inda ra Cristo. ");
INSERT INTO mioNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Cua coo tahan ra cua cati ti ra Cristo cuu ra, soco ña ndicha ra. Cua coo tahan ra cua cati ti ra cahan cuenda ra Ndioo cuu ra, soco ña ndicha tahan ra. Cua savaha tahan ra ta ra cuhva cahnu xaan, vati cua cuni ra sandahyu ñahan ra ta ra chi ñivi ni nacachi ra Ndioo, tu cua cuu. ");
INSERT INTO mioNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Cua cumi ndo chihin ndo, vati cha cati yu ndihi tuhun ya chihin ndo, ta ña ta coo chi ―cati ra Jesuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Quivi can cua yaha xihna tu ndoho can, ta sa cua ndahva ri nicandi, ta ña cua ndundichin ca ri yoo. ");
INSERT INTO mioNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Cua quehni ri tiñu iti siqui andivi, ta cua ndoyo ñuhun ndihi cha iyo iti siqui can. ");
INSERT INTO mioNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tacan cuu, ta cua ndehe ndihi ñivi ti vachi ra cuu sehe ñivi tichi vico iti siqui andivi, ta iyo xaan tu ndee ini chi ra, ta taqui ndicha ra cua cuu. ");
INSERT INTO mioNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tacan, ta sa cua tava tiñu ra chi ra tatun Ndioo, ta cua sacuiti ra ta ra chi ndihi ñivi ni nacachi ra Ndioo nu iyo ñi nini cahnu nu ñuhun ñuñivi ya. Nda iti xuu ta nda iti xini cua nducuiti ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Na cua cutuni ini ndo, vati chito ndo yoso cuhva iyo yutun tusihva tiñi. Cua nduyuta ndaha chi, ta cua nduchaa soco numa ndaha chi, ta cua quichi numa chi. Quivi can chito ndo ti cha ni queta quivi cua coo chiti chi. ");
INSERT INTO mioNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ta ni cuhva cua coto ndo ti cha yatin xaan vachi hora can quivi cua ndehe ndo cha iyo chi cuhva cati yu. ");
INSERT INTO mioNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cati ndicha yu chihin ndo ti ña cua cuvi ñivi iyo vitin nda cua nda quivi cua queta ndihi cha cati yu chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tacan cati yu, vati cua queta quivi cua naan andivi ya chi ñuhun ñuñivi ya, soco ña cua naan tuhun cha cahin. ");
INSERT INTO mioNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Yoni ñivi chito ndaa quivi cua queta hora can. Ña chito ra tatun Ndioo iyo iti siqui andivi, ta ni ña chito sehe ra Ndioo. Ini maan ra Ndioo chito. ");
INSERT INTO mioNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Cua cumi ndo chihin ndo, ta cua saha ndo cuenda. Cua cahan ndo chi ra Ndioo, vati ña chito ndo ndaa quivi cua coo chacan. ");
INSERT INTO mioNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tuhun can cuu sava ta cua iin rai, ta quee iti ra. Inga ñuun nu cani cuahan ra, ta nacoo ra vehe ra, soco chaha ra ndatu chi musu ra. Chaha ra tiñu chi iin iin ra ta ra, ta cati tuhun ra ti na cua coo ndito ra cuu ra cumi yu vehe. ");
INSERT INTO mioNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chacan cuu cha cati yu ti na cua coo ndito maan ndo, vati ña chito ndo ñaan hora cuu cha cua quichi ra cuu sava ta cua chitoho vehe. Ña chito ndo a cua quichi ra cha cha ini. Ña chito ndo a cua quichi ra sava ñuun. Ña chito ndo a cua quichi ra hora cua ndahyu ri chitoho. Ña chito ndo a cua quichi ra hora cha vachi cundichin. Ña chito ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Na cua cuatu vaha ndo, coto quii xaan cua quichi ra, ta cua ndehe ra ti quixi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tuhun cati tuhin chi ndo cati tuhin chi ndihi ñivi. Cati yu ti na cua coo ndito ndo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yaha uvi quivi, ta nducahnu vico paan ña ndaa nu ni chihi ri mbee. Tacan, ta nducu ra sutu chahnu chi ra sacuaha ley chahnu cuhva yoso cuhva cua tiin xehe ra ta ra chi ra Jesuu, ta cua cahni ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Cati ra ta ra chi tahan ra ti: ―Ña cua tiin yo chi ra tichi vico ya, coto cua cuvaa ñivi ya ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iyo ra Jesuu ñuun Betania can. Vehe ra Simón ra cuhvi cuehe tahyu iyo ra, ta ndecu ra yu mesa. Tacan cuu, ta queta iin ña ñahan. Naan ña iin nu indi nduta vixin chahan. Mani nduta vaha cuu chi, ta yahvi xaan ni chacunda chi. Chahnu ña nu indi chi, ta choso ña nduta can xini ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","soco quechaha nduxaan uvi ñi. Quechaha cati ñi chi tahan ñi ti: ―Ña vaha cha sandoyo ñuhun ña nduta can, ");
INSERT INTO mioNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","vati cua queta uvi ciendu xuhun denario, tu cua xico ndico ña chi chi, ta cua cuhva ndico ña xuhun can chi ñivi ndahvi ―cati ñi ta ñi. Cahan yuhu xaan ñivi can chi ña. ");
INSERT INTO mioNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ta cati ra Jesuu chi ñi ti: ―Saña ndo chi ña. Ña vaha cha sasaca ndo xini ña. Taqui xaan cha savaha ña chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ndihi ni quivi cua coo ñivi ndahvi can chihin ndo, ta cua cuu savaha ndo cha vaha chi ñi ndaa quivi cua cuni maan ndo, soco main―ña ndihi ni quivi cua coi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cha savaha ña yoso cuu chi ña, vati cha choso ña nduta vixin chahan can cuñu yu iti nuun, vati cha cua cuchi yu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cati ndicha yu chihin ndo ti ndihi nu cua queta tuhun vaha nini cahnu nu ñuhun ñuñivi ya cua cuhva tahan ñivi cuenda yoso cuhva ni savaha maan ña. Tacan ni cua cuñuhun ini ñivi chi ña ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tacan cuu, ta quee ra Juda Iscariote, ta cuahan ra. Iin ra uchi uvi ra sacuaha chi ra Jesuu cuu tahan ra. Cuahan ra nuun ra sutu chahnu, vati cuni ra xico tuhun ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chini ra sutu chahnu ta ra tuhun can, ta sii xaan cuni ra ta ra, ta cati ra ti cua tiahvi ra chi ra. Tacan, ta nanducu ra Juda cuhva yoso cuhva cua cuu xico tuhun ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Quivi quechaha vico paan ña ndaa can cuu chi, ta quivi can chahni tahan ñi chi ri mbee, vati samani ñi chi ri chi ra Ndioo cuenda vico can. Tacan cuu, ta nducu tuhun ra sacuaha chi ra Jesuu ti: ―¿Yoso cuni cun cha cua tiso vaha ndi, ta cua sacahnu yo vico ya? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tacan, ta tava tiñu ra Jesuu chi uvi ra sacuaha chi ra. Cati ra chi ra ta ra ti: ―Cuahan ndo tichi ñuun, ta cua satahan ndo chi iin rai ndiso quii nduta. Cua cundicu ndo chi ra, ");
INSERT INTO mioNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ta cua cati ndo chi ra xuu vehe nu cua quihvi ra ti nducu tuhun ra maestru ti ndaa iyo vehe nu cua sacahnu ra vico chi ra sacuaha chihin ra, cua cati ndo, ");
INSERT INTO mioNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ta cua sanahan ra iin vehe toto, ta cha iyo vaha chi. Ican cua tiso vaha ndo nu cua cachi yo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tacan cuu, ta quee ra ta ra cuahan ra. Quihvi ra ta ra tichi ñuun, ta ni tahan ra cuhva cati ra Jesuu chi ra, ta tiso vaha ra nu cua sacahnu ra ta ra vico can. ");
INSERT INTO mioNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tacan cuu, ta cha ini quivi can cuahan ra Jesuu chi ndihi uchi uvi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ndecu ra ta ra yu mesa can, ta chachi ra ta ra, ta quechaha cati ra Jesuu chi ra ta ra ti: ―Cati ndicha yu chihin ndo ti iin ndo cua xico tuhun chihin yu, ta vitin chachi ra chi main icaa ni ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Quechaha ndundahvi cuni ra ta ra, ta quechaha cati ta iin ta iin ra chi ra ti: ―Ñavi yuhu cui ―cati ra ta ra. Ta ni cuhva cati inga ra chi ra ti: ―Ñavi yuhu cui ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ta cati ndico ra chi ra ta ra ti: ―Iin ndo cuu ndo, vati iin ra uchi uvi ra sacuaha chihin yu cuu ra, ta tihi tahan ra ndaha ra chihin yu tichi coho icaa ni, ");
INSERT INTO mioNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","vati cua tahan ndicha ra cuu sehe ñivi cuhva ni cati tutu Ndioo cuenda ra, soco tu ndoho cua ndehe ra xico tuhun chi ra cuu sehe ñivi can. Vaha xaan ca tu ña cacu cuii ni racan ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ni vii chachi ra ta ra, ta quihin ra Jesuu iin paan, ta chaha ra iin tiahvi ndioo chi ra Ndioo, ta chahnda cuati ra chi chi, ta chaha ra chi chi chi ra ta ra, ta quechaha cati ra ti: ―Cua quihin ndo paan ya. Chehe cuu sava ni ta cua iquin cuñu yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tacan cuu, ta quihin tahan ra Jesuu iin copa can, ta chaha ndico tucu ra iin tiahvi ndioo, ta chaha ra chi chi chi ra ta ra, ta chihi ndihi ra chi chi, ");
INSERT INTO mioNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ta cati ra chi ra ta ra ti: ―Chehe cuu sava ni ta cua niñi yu, vati cha iyo vaha tuhun chi ra Ndioo cha cua cati yu niñi yu cuenda ndihi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cati ndicha yu chihin ndo ti ña cua coho que nduta chiti uva ya nda cua nda quivi cua coo ndique chi ndo icaa ni nu cua cundaca ñahan ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tacan cuu, ta chita ra ta ra iin yaa, ta quee ra ta ra cuahan ra. Iti yucu Olivo cuahan ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ta quechaha cati ra Jesuu chi ra ta ra ti: ―Vitin cha cuaa ya cua ndoyo ñuhun ndihi ndo, vati cha cati tutu Ndioo ti cua cuvi ra sacuenda chi ri mbee, ta cua cuita cuati ndihi maan ri mbee can, cati ra Ndioo, ");
INSERT INTO mioNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","soco cua natacu ndique, ta cua cuhin iti nuun ndo iti ñuhun Galilea ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ta cati ndico ra Pedro chi ra ti: ―Vasi cua ndoyo ñuhun ndihi ca ra ta ra, soco yuhu ña cua ndoyo ñuhin ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ta cati ra Jesuu chi ra ti: ―Cati ndicha yu ti uni hora cua cati maun ti ña nacoto cun chihin yu vitin cha cuaa ya, ta sa cua ndahyu ri chitoho uvi yuhu ri ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tacan cuu, ta nihin xaan ca cati ra Pedro ti: ―Tu cua cahni tahan ñi chihin yu, ña cua cati yu ti ña nacote chihun ―cati ra. Ta ta ni cuhva cati ndihi ca ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ta cuahan ra ta ra nu cuu chi Getsemaní, ta cati ra Jesuu chi ra sacuaha chi ra ti: ―Ihya cua cunda nuun ndo, vati cua cahan xihne chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tacan, ta quihin ra chi ra Pedro chi ra Jacobo chi ra Juaan, ta cuahan ra. Tacan, ta quechaha ndundahvi cuni ra Jesuu, ta cuihya cuni anima ra, ");
INSERT INTO mioNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ta quechaha cati ra chi ra ta ra ti: ―Cuihya xaan cuni anime. Chacan cuu cha cuni cuvi yu. Cuatu nuun ndo ihya, ta ña cua cusu ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tacan cuu, ta cuahan ra Jesuu suhva ca iti nuun, ta chahnu chiti ra nu ñuhun, ta quechaha cahan ra chi ra Ndioo, vati cuni ra cha cua saña ndaha ra tiñu can, tu cua cuu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Cati ra ti: ―Tata, cua cuu savahun ndihi cha cuni cun. Tacan na cua sanaun tiñu ya, soco ña cua savahun cuhva cuni yu. Cua savahun cuhva cuni maun ―cati ra Jesuu chi sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tacan cuu, ta cuahan ndico ra, ta ndehe ra ti cha quixi ra ta ra, ta cati ra chi ra Pedro ti: ―Quixi cun, Moon. Ña ni cuu coo ndito cun ni iin hora ni chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Na cua coo ndito ndo, ta cua cahan ndo chi ra Ndioo. Chacan cuu cha ña cua savaha ndo cha ndavaha ni. Cuni ndo coo ndito ndo chi anima ndo, soco ña cundee ini ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tacan, ta quee ndico tucu ra Jesuu. Cuahan ra inga chaha, ta ini tuhun can cahan ndico tucu ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Inga chaha queta ndico ra Jesuu nu iyo ra ta ra, ta ndehe ra ti cha quixi ndico tucu ra ta ra, vati chitatun xaan ra ta ra, ta ña cundee nuun ra ta ra. Tacan, ta ña chito ra ta ra ñaan cha cuu cha cua cati ndico ra ta ra chi ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ta inga chaha queta ndico tucu ra Jesuu cha cuu uni chaha, ta cati ra chi ra ta ra ti: ―Cusu nuun ndo suhva ca hora, ta na cua quee tatun ndo. Cha iyo vaha vitin. Cha queta hora. Vitin cha cua tiin ra ndavaha ni chi ra cuu sehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ndoyo ndo, ta na coho. Cha vachi ra cua xico tuhun chihin yu ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ni vii cahan ra Jesuu, ta queta ra Juda. Iin ra sacuaha chi ra Jesuu cuu ra. Tuvi xaan ñivi vachi tahan chi maan ra Juda can, ta naan ñi cha cuu ta iin machete. Naan ñi garote. Naan ñi. Ra sutu chahnu chi ra sacuaha ley chahnu chi ra chanihin cuu ra ni tava tiñu chi ñican. ");
INSERT INTO mioNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ni chaha ra Juda can iin cuhva chi ra ta ra, vati cati ra chi ñi ti: ―Cua taa yuhi chi ra. Chi racan cua tiin ndo, ta cua cuhni vaha ndo chi ra, ta cua cundaca ndo chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tacan cuu, ta quii xaan queta ra Juda, ta tuhva ra nu inda ra Jesuu, ta quechaha cati ra chi ra ti: ―Maestru ―cati ra. Tacan, ta ni taa yuhu ra Juda chi ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ta ca tiin ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iyo iin rai inda tican, ta xita ra machete ra, ta cani ra chi ra cuu musu ra sutu chahnu, ta laxin cuii ni chahnda ra soho ra musu can. ");
INSERT INTO mioNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tacan, ta quechaha cati ra Jesuu chi ñivi can ti: ―Vachi ndo, ta naan ndo machete. Naan ndo garote. Naan ndo, ta cua tiin ndo chihin yu cuhva tiin ndo chi rai cuni cahni suhu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ndihi ni quivi chacoi chi ndo ve ñuhun, ta sacuahi chi ndo, ta ña ni tiin ndo chihin yu, soco tehen ni ndacu ndo vitin cuhva cati tutu Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tacan cuu, ta ndihi ra sacuaha chi ra nacoo ihni chi ra, ta ca chinu ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tacan cuu, ta iyo tahan iin rai tivaa, ta ndicu ra chi ra Jesuu. Isucu ra iin sunduhu ni. Ñahni cha nami ra, ta tiin ñivi can chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tacan, ta saña ihni ra sunduhu can, ta quechaha chinu ra cuhva cuiti ndaha ni ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tacan cuu, ta chandaca cuenda ñivi can chi ra Jesuu nu iyo ra sutu chahnu, ta ni nducuiti tahan ndihi ca ra sutu chahnu chi ra chanihin chi ra sacuaha ley chahnu can. ");
INSERT INTO mioNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Chica vihi ni ndicu tahan ra Pedro chi ra Jesuu. Ndicu ra chi ra nda cua nda ni queta ra nu tihyo ra sutu chahnu can, ta chacunda tahan ra Pedro chi musu ra, ta tuni tahan ra ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tacan, ta iin testigu cua tiso cuati ra Jesuu nanducu ndihi ra sutu chahnu chi ndihi ra cumi tiñu judío can, vati cuni ra ta ra cahni ra chi ra Jesuu, soco ña ni nanihin ra ta ra chi iin ñivi cua cuu testigu can. ");
INSERT INTO mioNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tuvi xaan ñivi cuni sandahyu ñahan, ta cua tiso ñi cuati ra, soco ña nduinuun tuhun cahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tacan cuu, ta ni chacuinda inga ra ta ra, ta quechaha sandahyu ñahan ra ta ra yoso cuhva ni savaha ra Jesuu, ta cati racan ta ra ti: ");
INSERT INTO mioNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Chini ndi ti cha cahan ra Jesuu ya vati cua cani maan ra ve ñuhun inda ihya, ta ni sandaa ñivi chi chi chi ndaha ñi, soco tichi uni quivi cua caqui ndaa ndico ra inga cha chaa, ta ña cua sandaa ra chi chi chi ndaha ra, cati ra ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ta ni cuhva ña nduinuun cha cahan ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tacan cuu, ta ni chacuinda maan ra sutu chahnu sava mahñu ra cumi tiñu can ta ra, ta quechaha nducu tuhun ra chi ra Jesuu ti: ―¿Atu ña cua cati ndico cun, vati cha ni tiso rahya ta ra cuati cun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ta taxin taxin inda ra Jesuu. Ña cahan cuii ni ra, ta nducu tuhun ndico tucu ra sutu chahnu can chi ra ti: ―¿Atu yoho cuu ra Cristo? ¿Atu sehe ra ii ndicha cuun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ta cati ndico maan ra Jesuu ti: ―Yuhu cui, ta cua ndehe ndo ti ndaa ra cuu sehe ñivi chiyo ndaha cuaha ra iyo xaan tu ndee ini. Cua ndehe tahan ndo ti cua quichi ndico ra cuu sehe ñivi can tichi vico iti siqui andivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tacan cuu, ta ni ndata ra sutu chahnu sahma ndichin suvi ni maan ra, vati xaan xaan cuni ra, ta quechaha cati ndico tucu ra ti: ―Ña chini ñuhun ca yo testigu. ");
INSERT INTO mioNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Cha ni chini ndo ndavaha ni cha cahan ra chi ra Ndioo. ¿Yoso cua cati ndo vitin? ―cati ra sutu chahnu can. Tacan cuu, ta quechaha cati ndihi ra ta ra ti na cua cuvi ra Jesuu, vati cha iyo cuati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tacan cuu, ta quechaha tivi sivi ihni uvi uni ra ta ra chi ra Jesuu, ta chasi ra ta ra iin sahma nuun ra, ta quechaha cani ra ta ra chi ra chi ndaha ra, ta cati ra ta ra chi ra ti: ―Vitin cua cuhvon cuenda yoo rai cani chihun ―cati ra ta ra. Tacan cuu, ta quihin ra musu can chi ra Jesuu, ta quechaha cani ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ni vii iyo ra Pedro iti ninu nu tihyo ra sutu chahnu, ta queta iin ñahan cuu musu ra sutu chahnu can. ");
INSERT INTO mioNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ndehe ña ti ndaa tahan ra Pedro. Tuni ra ñuhun, ta ndehe ña nuun ra, ta quechaha cati ña chi ra ti: ―Cha chica tahun chi ra Jesuu ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tacan cuu, ta quechaha sandahyu ñahan ra Pedro, ta cati ra chi ña ti: ―Ña chite ñaan cha cuu cha cahun ―cati ra. Tacan cuu, ta cha cua quee ra Pedro iti yu vehe, ta ndahyu ri chitoho iin yuhu ri. ");
INSERT INTO mioNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tacan, ta ndehe ndico tucu ñacan chi ra Pedro, ta cati ña chi ñivi tecu ican ti: ―Iin ra chica chi ra Jesuu cuu rahya ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tacan, ta cati ndico ra Pedro ti ña ndicha ña, ta yaha inga hora luhu, ta quechaha cati ndico tucu ñivi inda ican chi ra ti: ―Ndicha ti cha chica tahun chi ra, vati quichi maun iti ñuhun Galilea. Cuhva cahan ñican cahan tahan maun ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tacan cuu, ta quechaha cahan ra Pedro can ndavaha ni chi ñi, ta cahan rai xaan ra, ta cati ndico tucu ra ti: ―Ña nacote yoo rai cuu ra cahan ndo tuhun can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tacan cuu, ta quii xaan ni ndahyu ndico tucu ri chitoho can cha cuu uvi yuhu ri, ta chacuhun ini ra Pedro vati ni cati Jesuu chi ra ti uni chaha cua cati ra ti ña nacoto ra chihin ra, ta cua ndahyu ri chitoho uvi yuhu ri, cati ra Jesuu chi ra nu quichi quivi can. Tacan cuu, ta quechaha chacu xaan ra Pedro can. ");
INSERT INTO mioNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ni nahan xaan cha tuvi inga quivi, ta nducuiti ra sutu chahnu chi ra chanihin chi ra sacuaha ley chahnu chi ndihi ra cumi tiñu ñivi judío can, ta nihin ra ta ra cuhva cha cua savaha ra ta ra. Ni chuhni ra ta ra chi ra Jesuu, ta chandaca cuenda ra ta ra chi ra iti nuun ra Pilato, ta chaha cuenda ra ta ra chi ra chi ra Pilato can, ");
INSERT INTO mioNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ta quechaha nducu tuhun ra Pilato chi ra Jesuu ti: ―¿Atu maun cuu ra ndaca ñahan chi ñivi judío? ―cati ra. Ta cati ndico ra Jesuu chi ra ti: ―Cha cati maun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tacan, ta tiso xaan ra sutu chahnu cuati ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","soco nducu tuhun ndico tucu ra Pilato chi ra Jesuu ti: ―¿Atu ñahni cha cua cati ndico cun? Chini cun, vati cuaha xaan cuati cun tiso ra ta ra ―cati ra Pilato can. ");
INSERT INTO mioNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tacan cuu, ta ña cahan cuii ni ra Jesuu. Chacan cuu cha iyo xaan quechaha cuni ra Pilato can. ");
INSERT INTO mioNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vico can cua saña ra Pilato chi iin ra indi ve caa cuhva iyo costumbre ra, ta cua cati ñivi can ndaa ra cuu ra cua saña ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Indi iin ra nani Barabaa ve caa can, vati iyo ra chi tahan ra ve caa can, vati cha chahni ra chi ñivi quivi cha ni cani tahan ra ta ra chi ra cumi tiñu can. ");
INSERT INTO mioNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nducuiti ñivi can. Tuvi ñivi cuu ñi, ta quechaha cati ñi ti na cua savaha ra Pilato cuhva iyo costumbre ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tacan cuu, ta quechaha nducu tuhun ra Pilato chi ñivi can ti: ―¿Atu cuni ndo cha cua sañe chi ra ndaca ñahan chi ndo? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tacan cati ra Pilato, vati chito ra ti cha quichi ndaca ra sutu chahnu chi ra Jesuu chi ra, vati tahñu cuni ra ta ra ndehe ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tacan, ta sandusaca ra sutu chahnu chi ñivi can. Tacan cati ñi ti na cua saña ra chi ra Barabaa can. ");
INSERT INTO mioNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Inga chaha nducu tuhun ndico tucu ra Pilato chi ñivi can ti: ―¿Ñaan cha cuu cha cua savahi chi ra Jesuu, ta maan ndo cati ti ra ndaca ñahan chi ndo cuu ra? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tacan cuu, ta quechaha cana chaa xaan ñi, ta cati ñi ti: ―Cua cahni cun chi ra nu cruu ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ta nducu tuhun ra Pilato chi ñi ti: ―¿Ñaan cha cuu ndavaha ni cha ni savaha ra Jesuu ya? ―cati ra. Tacan, ta nihin ca quechaha cana chaa ñi, ta cati ndico tucu ñi ti: ―Cua cahni cun chi ra nu cruu ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tacan cuu, ta saña ra Pilato chi ra Barabaa can, vati cuni ra cha cua cusii ini ñivi can. Tacan, ta cati ra ti cua quihin cuenda ra sandaru ta ra chi ra Jesuu, ta cua cani ra ta ra chi ra, ta cua taa ra ta ra chi ra nu cruu. ");
INSERT INTO mioNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tacan cuu, ta chandaca ra sandaru ta ra chi ra Jesuu tichi ve tiñu can nu iyo tihyo nu nuna, ta cana ra ta ra ndihi tahan ra na nducuiti ra ta ra tican. Vehe can cuu vehe tiñu ra cumi tiñu cahnu. ");
INSERT INTO mioNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tacan, ta sacundichin ra sandaru ta ra sahma yuhva tixinda cha cuu sahma rey chi ra Jesuu, ta cuicu ra ta ra iin corona iñu, ta tiso ra ta ra chi chi xini ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tacan, ta quechaha sacahnu ra ta ra chi ra Jesuu, ta cati ra ta ra ti: ―Na cumi chi maun, yoho ra ndaca ñahan chi ñivi judío ―cati ra ta ra cha sacateni ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Cani ra ta ra xini ra chi tuyoo, ta tivi sivi ra ta ra chi ra, ta chacuiñi chiti ra ta ra iti nuun ra, ta sacahnu vata ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cha ndihi sacateni ra ta ra chi ra, ta tava ndico ra ta ra sahma tixinda can, ta sacundichin ndico ra sandaru can ta ra sahma maan ra. Tacan cuu, ta tava ra ta ra chi ra tichi ve tiñu can, ta chandaca ra ta ra chi ra iti, vati cua taa ra ta ra chi ra nu cruu. ");
INSERT INTO mioNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Iti chiqui vachi iin ra nani Simón. Ra ñuun Cirene cuu ra, ta sanini ra sandaru ta ra chi ra, vati cua cuiso ra cruu nu cua cuita caa ra Jesuu. Ra Simón can cuu sutu ra Lejandru chi ra Rufo. ");
INSERT INTO mioNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tacan cuu, ta chandaca ra ta ra chi ra Jesuu iti nu cuu chi Gólgota. Nu cuecu iquin xini ndii cati tuhun Gólgota can. ");
INSERT INTO mioNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tacan, ta chaha ra ta ra nduta chiti uva na cua coho ra Jesuu. Cha sacanuun chi chi iin cha iya, soco ña tiin ra Jesuu chi chi. ");
INSERT INTO mioNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tacan, ta ni taa ra ta ra chi ra Jesuu nu cruu can, ta siqui ra sandaru ta ra chi yuu cuati, vati cuni ra ndehe ra ndaa ra cuu ra cua sacanaan sahma ra Jesuu. Tacan ni natahvi ra ta ra sahma ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Caa iin cha nahan cuu chi, ta taa ra ta ra chi ra nu cruu. ");
INSERT INTO mioNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Taa ra ta ra tuhun cha cuu cuati ra nu vitu, ta cati chi ti: “Rahya cuu ra ndaca ñahan chi ñivi judío.” ");
INSERT INTO mioNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tacan cuu, ta taa tahan ra sandaru ta ra chi uvi ra ñasuhu nu cruu. Icaa ni taa ra ta ra chi ra ta ra nu ndita caa ra Jesuu. Iin ra chata caa ra nu cruu chiyo ndaha cuaha ra Jesuu, ta inga ra chata caa ra nu cruu chiyo ndaha satin ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chacan cuu cha ni queta tuhun cuhva cati tutu Ndioo, vati cati chi ti saxini ñivi ti rai iyo cuati cuu tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yaha ñivi nuun ndita caa ra Jesuu, ta cahan ñi ndavaha ni chi ra. Sico xini ñi, vati ña vaha cuni ñi, ta cati ñi chi ra ti: ―Joi. Maun cuu ra cua cani ve ñuhun, ta cua sandaa ndico cun inga chi tichi uni quivi. ");
INSERT INTO mioNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na cua sacacu maun chihun, ta nuun cun nu cruu can ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ta ni cuhva cahan cateni ra sutu chahnu chi ra sacuaha ley chahnu, vati cati ra ta ra chi tahan ra ti: ―Cati ra ti sacacu ra chi ñivi, soco ña cuu sacacu ra suvi ni chi maan ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Na cua nuun ra nu cruu can vitin, vati ra Cristo cuu ra. Ra ndaca ñahan chi ñivi judío cuu ra. Na cua nuun ra. Chacan cuu cha cua ndehe ndi, ta cua cuinu ini ndi chihin ra ―cati ra ta ra cuenda ra Jesuu. Tacan cuu, ta sacateni tahan ra ñasuhu can cha ndaa tahan ra ta ra nu cruu can. ");
INSERT INTO mioNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Caa uchi uvi cha hora cuu chi, ta quechaha ndunaan nini cahnu ñuhun can, ta naan xaan chacoo chi nda cua nda queta caa uni. ");
INSERT INTO mioNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Suvi ni hora can nihin xaan quechaha cana chaa ra Jesuu, ta cati ra ti: ―Eloi, Eloi, ¿lama sabactani? ―cati ra. Tuhun cahan maan ñi cahan ra, ta cati ra ti: “Yoho tata, ¿ñacu cha saña ihni cun chihin yu, ta tata?” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ni inda uvi uni ñivi tican, ta chini ñi cha cahan ra Jesuu, ta cati ñi ti: ―¡Jihna! Cha cana ra chi ra Elía ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tacan cuu, ta chinu iin rai, ta sacutu ra iin yahma can chi nduta iya can, ta taa ra chi chi iin nu tuyoo, ta sayaha ra chi chi, vati na cua coho ra Jesuu chi chi, ta cati inga ra ti: ―Saña chi ra. Na cua ndehe yo a cua quichi ra Elía, ta cua sanuun ra chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tacan cuu, ta cana chaa ndico tucu ra Jesuu, ta chihi cuii ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tacan, ta ndata sava sahma ndasi yu ve ñuhun iti tichi. Uvi cuhva ndata sava chi nda xini ta nda chaha. ");
INSERT INTO mioNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Iti nuun ra Jesuu inda iin ra ndaca ñahan chi ra sandaru. Ndehe racan ti cha ni chihi cuii ra Jesuu, ta quechaha cati ra ti: ―Ndicha ti sehe Ndioo cuu rahya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Iyo tahan ñi ñahan tican, ta cani vihi inda ñi ndehe ñi chi ra Jesuu. Iyo ña María Magdalena chi ña María sihi ra Jacobo luhu chi ra José, ta iyo tahan ña Salomé. ");
INSERT INTO mioNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Quivi ni chacoo ra Jesuu ñuhun Galilea chahan ñican ta ñi chi ra, ta tindee ñi chi ra, ta iyo tahan tuvi ñi ñahan can cha quichi chi ra iti ñuun Jerusalén can inda tahan ñi ican. ");
INSERT INTO mioNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Cha cua ini cuu chi quivi tiso vaha ñivi can, vati cha cua quihvi quivi sábadu quivi ndaa tatun ñivi, ");
INSERT INTO mioNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ta ni queta iin rai. José nani ra, ta quichi ra iti ñuun Arimatea. Iin ra cumi tiñu judío can cuu ra, ta cahnu xaan rai cuu ra cuni ñivi can. Ndatu vaha tahan ra quivi cua quechaha cundaca ñahan ra Ndioo. Ña yuhvi racan, ta cuahan ra nu ndaa ra Pilato can, ta chica ra iquin cuñu ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tacan cuu, ta iyo xaan cuni ra Pilato, vati cha ni chihi cuii ra Jesuu. Cana ra chi ra ndaca ñahan chi ra sandaru can, ta nducu tuhun ra chi ra ti: ―¿Atu cha ni chihi cuii ra Jesuu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tacan cuu, ta chaha ra sandaru can cuenda ti cha ni chihi ra, ta chaha ra Pilato cha cua cu quihin ra José iquin cuñu ra ndii can. ");
INSERT INTO mioNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sata maan ra José can iin sanduhu yaxin yaxin, ta sanuun ra chi ra Jesuu nu cruu can, ta tisucu nuun ra sahma can chi iquin cuñu ra, ta tihi ra chi ra tichi iin yavi yuu nu ni tiso vaha ñivi, ta sico tuvi ra iin yuu cha cundasi yuhu yavi can, ");
INSERT INTO mioNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ta ni ndehe ña María Magdalena chi ña María sihi ra José nu ni tihi ra iquin cuñu ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tacan cuu, ta cha yaha quivi sábadu can, ta sata ña María Magdalena chi ña Salomé chi ña María sihi Jacobo iin cha chahan xico vixin, vati cua cuhun ñi, ta cua cuhu ñi iquin cuñu ra Jesuu chi chi. ");
INSERT INTO mioNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ni vii nahan xaan quivi domingu quivi quihvi vita, ta cuahan ñi ta ñi nu ni cuchi ra Jesuu, ta cana nicandi. ");
INSERT INTO mioNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tacan, ta nducu tuhun ñi chi tahan ñi ti: ―¿Yoo cua sico tuvi yuu ndasi yuhu yavi can? ―cati ñi ta ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tacan cuu, ta ni cani nuun ñi, ta ndehe ñi ti cha ni chico tuvi maan yuu can, ta cahnu xaan chi. ");
INSERT INTO mioNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Quihvi ñi tichi yavi can, ta ndehe ñi ti cha ndaa iin ra tivaa chiyo ndaha cuaha ñi. Ndichin ra iin sahma cuichin cuichin, ta iyo xaan quechaha cuni ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tacan, ta quechaha cati ra chi ñi ti: ―Ña cua cuiyo ndo. Nducu ndo chi ra Jesuu ra ñuun Nazaret, ta ni chihi ra nu cruu, soco cha ni natacu ndico ra. Yoni ca ra iyo ihya. Na ndehe ndo nu ni chacava ra. ");
INSERT INTO mioNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vitin cuahan ndo, ta cua sacoto ndo chi ra Pedro chi ndihi ca ra sacuaha chi ra. Cua cati ndo ti cha cuahan ra iti ñuhun Galilea. Iti nuun ndo cha cuahan ra, ta ican cua ndehe ndo chi ra cuhva ni cati ra chihin ndo ―cati ra tivaa can. ");
INSERT INTO mioNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tacan cuu, ta quee ndico ñi tichi yavi yuu can. Chinu ñi cuahan ñi, vati iyo xaan cuni ñi, ta nihin xaan quechaha naquisi chi chi ñi. Ñahni cha cahan ñi ni chi iin ñivi, vati yuhvi xaan ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ni vii nahan quivi domingu can quivi quihvi vita, ta natacu ndico ra Jesuu. Ndehe xihna ña María Magdalena chi ra. Ñahya cuu ña cha ni tava ra ucha tati cuihna anima nu quichi quivi. ");
INSERT INTO mioNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Cuahan maan ña, ta chaha ña cuenda chi amigu ra Jesuu, vati chacu xaan ñi, ta cuihya xaan cuni anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Chaha ña cuenda ti cha ni natacu ndico ra Jesuu, ta cha ndehe ña chi ra, soco ña chinu ini ñi cha cahan ña. ");
INSERT INTO mioNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tacan cuu, ta inga hora chica cuu uvi amigu ra Jesuu. Cuahan ra ta ra iti chiqui, ta ndehe ra ta ra chi ra, soco tucu cuhva caa ra ndehe ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Cuahan ndico ra ta ra, ta chaha ra ta ra cuenda chi ndihi ca ñi, soco ña ni chinu ini ñi cha cahan ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yaha inga suhva ca hora, ta ni chacuindecu ndihi uchi iin ra ta ra yu mesa, ta sa ndehe tahan ra ta ra chi ra Jesuu. Ni nduxaan ra Jesuu chi ra ta ra, vati ña chinu ini ra ta ra, ta ña cuni ra ta ra cuinu ini ra, vati ña chinu ini ra ta ra cha cahan ñi ndehe ti cha ni natacu ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tacan cuu, ta quechaha cati ra Jesuu chi ra ta ra ti: ―Cua cuhun ndo nini cahnu nu ñuhun ñuñivi ya, ta cua cati tuhun ndo tuhun vaha chi ndihi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tu cua cuinu ini ñivi chihin yu, ta cua cuanduta ñi, cua nduvaha anima ñi, soco tu ña cua cuinu ini ñi chihin yu, cua cutuni ñi, vati ña cua naan cuati ñi. ");
INSERT INTO mioNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ndihi cuhva ya cua savaha ñivi chinu ini chihin yu. Cua tava ñi tati cuihna cuenda yu. Cua cahan ñi inga sahan cha ña tuhva ñi cahan. ");
INSERT INTO mioNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cua tiin ñi chi ri coo. Tu cua coho ñi iin cha xaan cha cua cahni chi ñi, ñahni cha cua tahan ñi. Cua tiso ñi ndaha ñi chi ñivi cuhvi, ta cua nduvaha ñivi can ―cati ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nu ni ndihi cahan ra chahnu Jesuu chi ra tatun ra, ta ndaa ra iti siqui andivi, ta ni chacunda ra iti chiyo ndaha cuaha ra Ndioo, vati tacan chaha ra Ndioo ndatu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tacan cuu, ta quee ra ta ra cuahan ra, ta cati tuhun ra ta ra ndihi ñuun can. Tindee ra chahnu chi ra ta ra, ta ndehe ñivi ti vaha xaan tuhun cahan ra ta ra, vati cuhva cahnu xaan savaha tahan ra ta ra nu cati tuhun ra ta ra. Tacan ni cha cuu chi.");
INSERT INTO mioNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yoho ra chahnu Teófilo, tuvi ñivi cuu ñi cha ni nducu cuhva taa ñi tuhun ñaan cha cuu cha ni chacoo nu iyo yo nu quichi quivi ya. ");
INSERT INTO mioNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Cha ni taa ñi cuhva cati ñivi ni ndehe xihna cuii, ta cha taa ñi cuhva cati ra ni cati tuhun tuhun Ndioo nda ni xihna. Tacan ni quihin cuenda ndi cha ni taa ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Chacan cuu cha saxini tahin ti cua tai tutu chihun. Cuhva cha ni chacoo chi tai chihun, vati nda ni xihna cuii cha ni nducu xain cuhva yoso cuhva ni chacoo tuhun, ta vii vii ni cha ni nduqui cuhva. ");
INSERT INTO mioNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Chacan cuu cha cua coto cun ti cha ndicha ndicha cuu tuhun cati tuhun ndi chihun. ");
INSERT INTO mioNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nu quichi quivi cha ni chacoo ra Herode. Rey ndaca ñahan ñuhun Judea cuu ra, ta suvi ni quivi can ni chacoo iin ra sutu nani Zacaría. Cuenda ra Abía chahnu satiñu ra ve ñuhun. Elisabet nani ñasihi ra, ta ñivi ra Aarón chahnu cuu ña. ");
INSERT INTO mioNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Vaha xaan ndacu nduvi tahan ñi cuenda ra Ndioo, vati sacuinu vaha ñi ndihi cha ni cati tuhun ra Ndioo, ta ñahni cha cumani ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tacan ni chacoo ñi, soco ñahni sehe ñi iyo chi ñi, vati ña cuu coo sehe ña Elisabet can, ta quivi can cha chahnu xaan ñi. Nduvi tahan ñi chahnu suhva. ");
INSERT INTO mioNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tacan cuu, ta quivi can quihvi ra sutu ta ra iyo cuenda ra Abía iti nuun ra Ndioo, vati quivi satiñu ra ve ñuhun cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Cuhva iyo costumbre ra ta ra nihin ra Zacaría tiñu, ta quihvi ra ve ñuhun, vati iyo cha cua samani ra chi ra Ndioo, ta cua cahmi ra cutu. ");
INSERT INTO mioNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Hora can nducuiti ñivi iti chata. Tuvi ñivi cuu ñi nducuiti, ta cahan ñi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tacan cuu, ta ndehe ra Zacaría ti indi iin ra tatun Ndioo. Chiyo ndaha cuaha nu cayu cutu can indi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ndehe ra Zacaría chi ra, ta quechaha saxini xaan ra, ta yuhvi xaan yuhvi xaan cuni ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tacan cuu, ta quechaha cati ra tatun Ndioo can chi ra ti: ―Yoho Zacaría, ña cua cuyuhvi cun. Cha ni chini soho ra Ndioo cuhva ni cati cun chi ra. Cua coo iin sehun chi ñasihun, ta Juaan cua cunani ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Cuaha xaan cua cusii ini ndo chi ra cua savaha ra, ta tuvi xaan ñivi cua cusii ini ñi nu cua cacu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Cua cuu ra iin rai cahnu iti nuun ra chahnu Ndioo. Ña cua coho ra nduta chiti uva, ta ni ña cua coho ra ni iin nduta xaan. Nda ni quivi cua cacu ra, ta cha iyo ra Tati Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Cua cati tuhun ra chi ñivi Israel, ta cua saña ihni ñi cuati ndacu ñi. Tuvi ñi cua saña ihni ñi cuati ñi, ta cua sacahnu ñi chi ra chahnu Ndioo cua savaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Cua yaha ra iti nuun ra chahnu, ta cuhva ni chacoo Elía cua coo ra, vati cua coo tu ndee ini chi ra. Cua savaha ra cha cua cuni mani ra rai chi sehe ra, ta cua savaha ra cha cua saña ñivi ndavaha ni ndacu ñi, ta cua savaha ñi cha vaha. Tacan ni cua savaha ra, ta cua saxini vaha ñi cuenda ra chahnu ―cati ra tatun Ndioo chi ra Zacaría. ");
INSERT INTO mioNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tacan cuu, ta cati ndico ra Zacaría chi ra ti: ―¿Yoso cuhva cua cote ti cha ndicha cati cun? Cha chahnu xain, ta cha chahnu tahan ñasihi yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ta cati ndico ra tatun Ndioo can ti: ―Yuhu cuu ra Gabriel. Iti nuun ra Ndioo iye, ta tava tiñu ra chihin yu, vati cua cati tuhun yu tuhun vaha ya chihun. ");
INSERT INTO mioNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Cua nduñihun. Ña cua cuu cahan con nda cua nda quivi cua cacu sehun, vati ña chinu ini cun tuhun cati tuhin chihun, soco nu cuahan quivi cua coo chi cuhva cati yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tacan cuu, ta ni vii ndatu ñivi cha cua quee ra Zacaría, ta iyo xaan cuni ñi, vati nahan xaan nducuee ra tichi ve ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tacan cuu, ta quee ra, soco ña cuu cahan ra chi ñi. Chacan cuu cha chito ñi ti nducahan ra Ndioo chi ra tichi ve ñuhun. Ndicha cuii xini ni ra sico ra chi ñi, soco ña cuu cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Quivi can nuna nuun ra cha satiñu ra ve ñuhun, ta cuahan ndico ra iti vehe ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tacan cuu, ta quetuvi ña Elisabet cha ñuhun sehe ña, ta ña quee ca ña tichi vehe. Queta uhun yoo ña quee ña, ta quechaha saxini ña chi anima ña ti ");
INSERT INTO mioNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","cha ni chaha ra chahnu cha tahan ña tacan quivi can. Tacan ni savaha ra, vati ña cua cucahan ca nuun ña iti nuun ñivi, saxini ña. ");
INSERT INTO mioNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Cha yaha iin iñu yoo, ta tava tiñu tucu ra Ndioo chi ra Gabriel tatun ra. Iti ñuhun Galilea tachi ra chi ra, ta cuahan ra iti ñuun nani Nazaret, ");
INSERT INTO mioNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ta cuahan ra nuun iyo ña nani María. Ñahan yoco cuu ña, ta cha iyo vaha tuhun ti cua tandaha ña. Chi iin ra nani José cua tandaha ña, ta ñivi ra David chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tacan cuu, ta quihvi ra tatun Ndioo can nu iyo ña María, ta quechaha cati ra chi ña ti: ―¡Na cumi chi maun! Cahnu xaan tu manini cha ni savaha ra Ndioo chihun. Iyo ra chahnu chihun, ta taqui xaan cha ni savaha ra chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tacan cuu, ta cuaha xaan quechaha saxini xaan ña ti cha cati ra tacan, ta nanducu xini ña ñaan tuhun cuu chacan. ");
INSERT INTO mioNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tacan cuu, ta cati ra tatun Ndioo can chi ña ti: ―Yoho María, ña cuyuhvi cun, vati cua savaha ra Ndioo tu manini chihun. ");
INSERT INTO mioNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cua tuvi iin sehe cun tichi cun, ta cua cacu ra, ta Jesuu cua cunani ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Cahnu xaan rai cua cuu ra, ta cua cati ñivi ti sehe ra Ndioo cahnu cuu ra. Cua cuhva ra chahnu Ndioo cha cua cuu ra iin rai ndaca ñahan cuhva cha ni cuu ra David ñivi ra iti chata tiempu chahnu, ");
INSERT INTO mioNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ta cua cundaca ñahan ra chi ñivi Israel ndihi ni quivi ndihi ni tiempu, ta ña cua cundihi cha cua cundaca ñahan ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tacan cuu, ta quechaha nducu tuhun ña María chi ra tatun Ndioo can ti: ―¿Yoso cua cuu chacan, vati ña ta coi chi ra rai? ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ta cati ndico ra tatun Ndioo can ti: ―Cua quichi ra Tati Ndioo chihun, ta cua cuhva ra Ndioo cahnu tu ndee ini chihun. Chacan cuu cha cua cati ñivi ti ii xaan ra, ta sehe Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ta ña Elizabet tahun―cha chahnu xaan ña, soco cha tuvi sehe ña tichi ña. Nu quichi quivi cati ñivi ti ñahni sehe ña cua coo, soco vitin cha queta iñu yoo cha ñuhun sehe ña. ");
INSERT INTO mioNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tacan tahan ña, vati cuu savaha ra Ndioo ñaan cha cuni ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ta cati ndico ña María ti: ―Musu ra chahnu cui. Na cua coo chi chihin yu cuhva cati cun ―cati ña. Tacan cuu, ta quee ra tatun Ndioo can cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Suvi ni quivi can cuahan ña María iti ñuhun Judea, ta numi xaan cuahan ña. Yucu xaan nu cuahan ña, ");
INSERT INTO mioNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ta queta ña ñuun nu iyo vehe ra Zacaría, ta quihvi ña tichi vehe, ta sacahnu ña chi ña Elisabet. ");
INSERT INTO mioNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nu ni chini ña Elisabet cha cahan ña María, ta ni tuñu ve tichi ña, ta cha iyo ra Tati Ndioo chi ña. ");
INSERT INTO mioNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tacan cuu, ta nihin xaan quechaha cana chaa ña, ta cati ña chi ña María ti: ―Iyo xaan tu manini chihun, ta cua coo xaan tu manini chi sehun. ");
INSERT INTO mioNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ñahni yavi ndai, ta chi main quichi cun, ta sihi ra chahnu cua cuu cun. ");
INSERT INTO mioNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nu chini yu cha cahun chihin yu, ta tuñu ve tichi yu, vati sii xaan cuni ve. ");
INSERT INTO mioNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na cua cusii ini cun, vati chinu ini cun ti cua tahun cuhva ni cati ra chahnu chihun ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tacan cuu, ta quechaha cati ña María ti: Sacahnu yu chi ra chahnu. ");
INSERT INTO mioNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Cusii ini yu chi ra Ndioo, ta maan ra cuu ra sanduvaha anime. ");
INSERT INTO mioNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Cusii ini yu chi ra, vati cha chito ra ti ñivi ndahvi cuu yu, ta musu ra chihin yu. Vitin ta nda cua nda iti nuun cua cati ndihi ñivi ti iyo tu manini chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tacan cua cati ñi, vati ra iyo tu ndee ini―racan cuu ra savaha cha cahnu xaan chihin yu, ta ii xaan iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ndihi ni quivi ndihi ni tiempu cundahvi ini ra chi ñivi sacahnu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iyo xaan tu ndee ini chi ra, ta cha sandoyo ñuhun ra chi ñivi ndurai, vati rai xaan cuni ñi chi anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Cha tava ndaa ra chi ñivi ndaca ñahan, ta sacahnu ra chi ñivi ndahvi. ");
INSERT INTO mioNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Cha savaha ra cha vaha chi ñivi cumani, ta tava ndaa ra chi ñivi iyo vaha. ");
INSERT INTO mioNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Cha tindee ra chi ñivi Israel musu ra. Cha ñuhun ini ra chi ñi, ta cundahvi ini ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tacan ni savaha ra cuhva cha ni cati ra chi ñivi yo iti chata. Tacan ni cati ra ti ndihi ni quivi ndihi ni tiempu cua cundahvi ini ra chi ra Abraham chi ndihi ñivi cuu ñivi ra iti nuun ―cati ña María. ");
INSERT INTO mioNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tacan cuu, ta ndoo nuun ña María chi ña Elisabet. Uni yoo ndoo nuun ña chi ña, ta sa cuanuhun ndico ña vehe ña. ");
INSERT INTO mioNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nu ni queta quivi cha cua cacu sehe ña Elisabet, ta ni cacu iin ra luhu sehe ña. ");
INSERT INTO mioNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tacan cuu, ta chito ñivi ña ti cuaha xaan cundahvi ini ra chahnu chi ña. Chito tahan ñivi iyo ñuun ña, ta ndihi ñi ta ñi cusii ini ñi chi ña. ");
INSERT INTO mioNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tacan cuu, ta yaha una quivi, ta quichi ñi vehe ña, vati cua tahnda ñiin xini xuu ve luhu can cuhva iyo costumbre ñi, ta cati ñi ti cua cunani tahan ve Zacaría cuhva nani sutu ve. ");
INSERT INTO mioNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tacan cati ñi, soco cati sihi ve ti: ―Ñavi. Juaan cua cunani ve ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ta cati ndico ñi chi ña ti: ―Yoni ñivi ndo nani tacan ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tacan cuu, ta quechaha savaha ñi seña chi sutu ve, ta nducu tuhun ñi chi ra yoso cuni maan ra cha cua cunani ve. ");
INSERT INTO mioNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tacan cuu, ta chica ra iin vitu nu cua taa ra, ta quechaha taa ra ti Juaan nani ve. Tacan ni taa ra nu vitu can, ta iyo xaan cuni ndihi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tacan cuu, ta suvi ni hora can nducahan ndico ra Zacaría, ta sacahnu ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yuhvi cuni ndihi ñivi iyo tican, ta cahan ndihi ñivi chi tahan ñi iyo yucu can ñuhun Judea can, ta saxini ñi ñaan cha cuu chacan. ");
INSERT INTO mioNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chini ndihi ñivi tuhun can, ta saxini ñi chi anima ñi, ta nducu tuhun ñi iin ñi inga ñi ti: ―¿Ñaan rai cua cuu racan? Tacan ni nducu tuhun ñi, vati cua tindee ra chahnu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tacan cuu, ta iyo tahan ra Tati Ndioo chi ra Zacaría sutu ve, ta quechaha cahan ra yoso cuhva cua cuahnu ve iti nuun, ta cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Cahnu xaan rai cuu ra chahnu Ndioo, vati cha tindee ra chi ñivi Israel ñivi maan ra, ta cua sacacu ra chi yo. ");
INSERT INTO mioNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Cua sacacu ra chi yo, vati iyo tu ndee ini chi ra, ta ñivi ra David musu ra cua sacacu chi yo. ");
INSERT INTO mioNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tacan ni cati ra, vati nu quichi quivi cati ra ni cahan cuenda ra Ndioo ti ");
INSERT INTO mioNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","cua cacu yo nu cuxaan ini ñivi chi yo. Cua cacu yo ndihi nu cani tahan ñivi chi yo. ");
INSERT INTO mioNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Cati ra ti cua cundahvi ini ra Ndioo chi ñivi yo tiempu chahnu, ta ña cua naan ini ra tuhun tiso ra nu quichi quivi. ");
INSERT INTO mioNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Cua cucuhun ini ra tuhun can, vati cahan ra iin cha rai chi ra Abraham ra cuu ñivi yo tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Cati ra ti cua sacacu ra chi yo nu iyo yo chi ñivi cuxaan ini chi yo, vati cua satiñu yo cuenda maan ra, ta ña cua cuyuhvi yo. ");
INSERT INTO mioNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Chi maan ra cua coo vaha yo. Cua coo ii yo ndihi ni quivi cha iyo yo nu ñuhun ñuñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ta yoho sehu, cua cati ñivi ti maun cuu ra cahan cuenda ra Ndioo cahnu, vati cua yaha xihna maun. Cua tiso vahun tiñu nu cua yaha ra chahnu, ta sa cua quichi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Chacan cuu cha cua sacoto cun chi ñivi ti cua sacacu ra chi ñi nu ndacu ñi ndavaha ni, ta cua naan cuati ndacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tacan ni cua savaha ra Ndioo chi yo, vati cuni mani ra chihin yo, ta cundahvi ini ra chihin yo. Cua queta quivi cua quichi sacacu ra chihin yo. ");
INSERT INTO mioNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Cua ndehe ñivi iyo chi tu ndoho chi ra, ta sa cua saquehni ra cha vii chi anima ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tacan cuu, ta ni chahnu ra Juaan can, ta chaha ra Ndioo tu ndee ini chi ra. Mani tichi cuhu ni chacoo ra nda cua nda quivi quechaha cati tuhun ra chi ñivi judío can. ");
INSERT INTO mioNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tacan cuu, ta quivi can cati tuhun ra cumi tiñu cahnu nani Augusto ti cua yaha ndihi ñivi nu ra cumi tiñu, ta cua cuhva ñi sivi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Cha ni yaha xihna cuii ñi nu ra cumi tiñu cuu chacan, ta ndaca ñahan ra Cirenio ñuhun Siria. ");
INSERT INTO mioNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ndihi ñivi cuahan ñi ñuun ñi ti cua cuhva ñi sivi ñi chi ra cumi tiñu can. ");
INSERT INTO mioNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Chacan cuu cha quee ra José ñuun Nazaret cha iyo cuenda ñuhun Galilea, ta cuahan ra iti ñuhun Judea nu iyo ñuun Belén, vati cua cuhva ra sivi ra. Tican cuahan ra, vati nu ni cacu ra David tiempu chahnu cuu ñuun can, ta tata ra David cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tican cuahan ra chi ña María, vati cha iyo vaha tuhun cha cua tandaha ña chi ra, ta ñuhun sehe ña. Tican cuahan ñi, vati cua cuhva ñi sivi ñi chi ra cumi tiñu ñuun Belén can. ");
INSERT INTO mioNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Cha ni iyo ñi tican, ta queta quivi ni cacu sehe ña. ");
INSERT INTO mioNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Chacan cuu cha cacu ra luhu sehe xihna cuii ña. Tacan cuu, ta tisucu ña sahma chi ve, ta chaqui ña chi ve tichi canoa nu chachi sana ñivi, vati ñahni ca vehe nuna nu cua coo ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yatin ñuun can ni chacoo ra sacuenda chi ri mbee sana ra. Tichi cuhu iyo ra, ta cumi ra chi ri mbee can cha cuaa can. ");
INSERT INTO mioNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tacan cuu, ta cha iyo iin ra tatun Ndioo nu iyo ra. Ndichin xaan cuu nuun iyo ra, vati quichi ra cuenda ra Ndioo. Chacan cuu cha yuhvi xaan yuhvi xaan cuni ra cumi chi ri mbee can. ");
INSERT INTO mioNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tacan cuu, ta quechaha cati ra tatun Ndioo can chi ra ta ra ti: ―Ña cuyuhvi ndo, vati taqui xaan tuhun vaha cua cati tuhin chi ndo, ta cua cusii ini ndo. Cua cusii ini ndihi ñivi, ");
INSERT INTO mioNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","vati vitin quivi ya cha ni cacu iin rai cua sacacu chi ndo. Ñuun David cacu ra, ta ra chahnu Cristo cuu ra, vati tava tiñu ra Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Cua cuhve iin seña chi ndo, vati nu cua nanihin ndo chi ve cua ndehe ndo ti isucu ve sahma, ta caa ve tichi canoa nu chachi sana ñivi. Chacan cuu cha cua coto ndo ti cati yu cha ndicha chi ndo ―cati ra tatun Ndioo can chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tacan cuu, ta quii xaan quichi ca ra tatun Ndioo chi ra. Tuvi xaan ra cuu ra quichi, ta sacahnu xaan ra ta ra chi ra Ndioo, ta cati ra ta ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Cahnu xaan cuu ra Ndioo iyo iti siqui andivi! Na cua coo mani ndihi ñivi iyo nu ñuhun ñuñivi ya, ta na cua cuni ñi chi tahan ñi ―cati ra tatun Ndioo can. ");
INSERT INTO mioNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tacan cuu, ta cuahan ndico ra tatun Ndioo can iti siqui andivi, ta ra cumi chi ri mbee can quechaha cati ra chi tahan ra ti: ―Na coho iti ñuun Belén, ta na cua ndehe yo ñaan cha cuu chacan cha cati tuhun ra chahnu chi yo ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tacan cuu, ta numi xaan ra cuahan ra cumi chi ri mbee ta ra iti ñuun. Cuahan ra, ta nanihin ra chi ña María chi ra José, ta caa ve tichi canoa can. ");
INSERT INTO mioNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ni ndehe ra ta ra chi ve, ta quechaha chaha ra cuenda yoso cuhva ni cati ra tatun Ndioo cuenda vecan. ");
INSERT INTO mioNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ta ndihi ñivi ni chini tuhun cati ra cumi chi ri mbee can―iyo xaan cuni ñi, ");
INSERT INTO mioNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","soco ña María ña cahan ña cuenda chacan, soco saxini ña ñaan tuhun cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tacan cuu, ta cuahan ndico ra cumi chi ri mbee can, ta sacahnu xaan ra chi ra Ndioo. Sacahnu ra chi ra, vati cuaha xaan cha ni chini soho ra, ta cuaha xaan cha ni ndehe ra cha ni cahan ra tatun Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tacan cuu, ta yaha una quivi, ta tahnda ñiin xini xuu ra, cuhva iyo costumbre maan ñi ta ñi, ta cati ñi ti Jesuu nani ra cuhva ni cati tatun Ndioo, ta ni cumani coo sehe ña María. ");
INSERT INTO mioNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tacan cuu, ta queta quivi cha cua coo vaha ndico ñi cuhva cati ley Moisee, ta cuahan ñi iti ñuun Jerusalén. Cuahan ñi, vati cua cundaca ñi chi ve luhu can, vati cua cuhva cuenda ñi chi ve chi ra chahnu Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tacan ni savaha ñi, vati cati ley ra chahnu ti chi ndihi ra cuati cuu sehe xihna cuii ñi cua cuhva cuenda ñi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Chacan cuu cha cuahan ñi, vati cua samani ñi cuhva cati ley Ndioo. Uvi ri lucu a uvi ri ndivi cua samani ñi, cati chi. ");
INSERT INTO mioNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tacan cuu, ta iyo iin ra ñuun Jerusalén can. Simeón nani ra, ta rai vaha ndicha cuu ra. Sacahnu vaha ra chi ra Ndioo, ta cuni ra ndehe ra nu cua cacu ñivi judío chi tu ndoho, ta iyo tahan ra Tati Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Cha cati ra Tati Ndioo chi ra ti ña cua cuvi ra nda cua nda cua ndehe xihna ra chi ra Cristo, vati cua tava tiñu ra chahnu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ni chandaca ra Tati Ndioo chi ra, ta quihvi ra tichi ve ñuhun. Tacan cuu, ta quichi naan sutu ra sihi ra chi ra Jesuu, vati cua savaha ñi chi ra cuhva cati ley can. ");
INSERT INTO mioNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tacan cuu, ta chacuisucu ndaha ra Simeón can chi ra Jesuu, ta cahan vaha xaan ra chi ra Ndioo, ta cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Yoho ra chahnu, na cua cuhva cun cha cua cuvi yu vitin, vati cha ni savahun cuhva cati cun chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Cha ni ndehi chi ra cua sacacu chi ndi vitin. ");
INSERT INTO mioNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Cha tachi maun chi ra nu iyo ndihi ñivi, ");
INSERT INTO mioNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ta cua cati tuhun ra chi ñivi cuu inga tucu ñivi, ta cahnu xaan ñivi cua cuu ñivi judío ñivi maun cua savaha ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tacan cuu, ta iyo xaan cuni sutu ra sihi ra cha chini ñi tuhun cahan ra Simeón cuenda ra luhu sehe ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tacan cuu, ta sacu‑ii ra Simeón chi ñi, ta quechaha cati ra chi ña María sihi ve ti: ―Cua cuiso ra iin tiñu cahnu xaan, ta cuaha ñivi Israel cua ndoyo ñuhun cuenda ra, soco cuaha ñi cua cacu cua savaha ra. Sava ta cua iin seña ni tiso ra Ndioo cuu ra, soco iyo ñivi cua cuni cani tahan ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chacan cuu cha cua coto ra Ndioo yoso cuhva saxini ñivi chi anima ñi. Ta yoho María, cuaha xaan cua nducuihya cuni cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tacan cuu, ta iyo tahan iin ñahan tican. Ana nani ña, ta cahan ña cuenda ra Ndioo. Sehe ra Fanuel ñivi Aser chi ña, ta ñahan chahnu chahnu cuu ña. Cha tandaha tahan ña, ta ni chacoo ña chi ii ña ucha cuiya, ta chihi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ñahan ndahvi cha cuu ña, ta cha queta ña cumi xico cumi cuiya ña. Ña quee ña tichi ve ñuhun, soco nduvi ta niñu cahan ña chi ra Ndioo, ta iyo ndita ña iti nuun ra. Tacan ni sacahnu ña chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tuhva ñacan nu iyo ñi chi ra Simeón hora can, ta quechaha chaha ña iin tiahvi ndioo chi ra Ndioo, ta cahan ña cuenda ra Jesuu, ta chaha ña cuenda chi ndihi ñivi cuni cha cua cacu ñi ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Savaha ñi ndihi cuhva cati ley ra chahnu, ta cuanuhun ndico ñi ñuun Nazaret cha iyo cuenda ñuhun Galilea. ");
INSERT INTO mioNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tacan cuu, ta ni chahnu ra Jesuu. Chacoo tu ndee ini chi ra, ta nditi xaan xini ra cuu, ta savaha xaan ra Ndioo tu manini chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cuiya ta cuiya chahan sutu ra chi sihi ra ñuun Jerusalén, vati sacahnu ñi vico cuenda cha ni cacu ñivi ñi ñuhun Egipto tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nu ni queta ra Jesuu uchi uvi cuiya ra, ta cuahan tucu ñi vico can cuhva iyo costumbre ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tacan cuu, ta queta quivi ni ndihi vico, ta cuanuhun ndico ñi iti ñuun, soco ña chito ñi cha ni ndoo ra Jesuu ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Saxini ñi ti icaa ni cuahan ra chi amigu ñi, vati tuvi ñi cuahan icaa ni. Tacan ni chica ñi iin nduvi, ta quechaha nanducu ñi chi ra chi ñivi ñi chi amigu ñi, vati tuvi ñi chahan vico, ");
INSERT INTO mioNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ta ña nanihin ñi chi ra. Chacan cuu cha cuahan ndico ñi iti ñuun Jerusalén, vati cua nanducu ñi chi ra tican. ");
INSERT INTO mioNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tacan cuu, ta cha yaha uni quivi cha nanducu ñi chi ra, ta sa nanihin ñi chi ra. Ve ñuhun iyo ra, ta nanihin ñi chi ra. Nu ndaa ra maestru ndaa ra, ta tasoho ra cha cahan ra maestru ta ra, ta nducu tuhun ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iyo xaan cuni ndihi ñivi chini cha cahan ra, vati vaha xaan cutuni ini ra, ta vaha xaan cati ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ndehe ñivi ra chi ra, ta iyo xaan cuni ñi. Tacan cuu, ta quechaha cati sihi ra chi ra ti: ―Sehu, ¿ñacu ndacu cun tehen chi ndi? Yuhu chi sutu cun―cha saxini xaan ndi, ta nanducu ndi chihun ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ta cati ndico ra ti: ―Ña chite cha ña chito ndo ndaa iti cua nanihin ndo chihin yu. Saxini yu ti chito ndo ti tiñu suti ndacu i ―cati ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tacan ni cati ra, soco ña nituni ini ñi tuhun ni cahan ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tacan cuu, ta cuanuhun ndico ra chi ñi, ta queta ndico ñi ñuun Nazaret. Tasoho ra cha cahan ñi, ta ndihi chacan saxini sihi ra chi anima ña. ");
INSERT INTO mioNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tacan cuu, ta chahnu ca ra Jesuu, ta cutuni ca ini ra, ta iyo xaan tu manini chi ra chi ra Ndioo chi ndihi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Cha queta chahun cuiya cha ni quihvi ra Tiberio, ta cuu ra cumi tiñu cahnu. Quivi can Poncio Pilato cuu ra ndaca ñahan chi ñivi iyo ñuhun Judea, ta ndaca ñahan ra Herode chi ñivi iyo ñuhun Galilea, ta ndaca ñahan ra Felipe yani ra chi ñivi iyo ñuhun Iturea chi ñivi iyo ñuhun Traconite, ta ndaca ñahan ra Lisania chi ñivi iyo ñuhun Abilinia. ");
INSERT INTO mioNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anaa chi ra Caifás cuu ra cuu sutu chahnu quivi can, ta cahan ra Ndioo chi ra Juaan sehe ra Zacaría. Tichi cuhu iyo ra, ta cahan ra Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tacan cuu, ta chahan ra Juaan ndihi nu iyo ñivi yatin yuta Jordán, ta cati tuhun ra chi ñivi can. Cati tuhun ra ti na cua saña ihni ñi cuati ndacu ñi, ta cua cuanduta ñi. Chacan cuu cha cua cucahnu ini ra Ndioo cuati ndacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tacan ni savaha ra Juaan cuhva iyo tuhun tutu ni taa ra Isaía ra ni cahan cuenda ra Ndioo iti chata, vati cati ra Isaía ti: Cua cana chaa iin rai tichi cuhu, ta cua cati ra chi ñivi ti: “Na cua tiso vaha ndo tiñu, vati cua quichi ra chahnu. ");
INSERT INTO mioNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Na cua saxini vaha ndo, ta na cua tiso vaha ndo anima ndo, ta cua coo vaha ndo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Cua coto ndihi ñivi ñuñivi ti cua sacacu ra Ndioo chi ñivi nu iyo ñi chi tu ndoho,” cua cati ra, cati ra Isaía. ");
INSERT INTO mioNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Quichi ñivi nu iyo ra Juaan, vati cuni ñi cha cua sacuanduta ra chi ñi. Tacan cuu, ta cati ra chi ñi ti: ―Ndihi ndioho, ña vaha ñivi cuu ndo, vati iyo ndo sava ta cua iyo ri coo, vati ña vaha ndacu ndo. Cha saxini ndo ti cua cuanduta ndo, coto ña cua cacu ndo nu cua tachi tuni ra Ndioo chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Na cua saña ihni ndo cuati ndacu ndo, ta na cua savaha ndo cha vaha ndicha. Ña cua saxini ndo ti ñivi ndo chi ra Abraham chahnu. Yuhu cati ti ñahni yavi ndaa chacan, vati ndacu ndo cuati. Tu cua cuni ra Ndioo, cua cuu savaha ra iin cha cahnu, ta cua cati ra chi yuu ya ti cua cuu chi ñivi ra Abraham, ta ñivi ndicha ra Abraham cua cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Vitin cha cua tava ndaa ra Ndioo chi ñivi ña ndacu cha vaha. Tu ña cua savaha ñi cha vaha, cua tava ndaa ra chi ñi. Cua tachi tuni ra chi ñi, ta cua yaha ñi nu cayu ñuhun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tacan cuu, ta quechaha nducu tuhun ñivi can chi ra ti: ―¿Ñaan cha cuu cha cua savaha ndi? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ta cati ndico ra ti: ―Na cua tindee ndo chi ñivi ndahvi. Tu cha iyo vaha sahma chi ndo, na cua tindee ndo chi ñivi cumani sahma. Tu cha iyo vaha cha cua cachi ndo, na cua tindee ndo chi ñivi cumani cha cachi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Quichi tahan ra satiahvi chi ñivi, vati cua cuanduta tahan ra ta ra, ta nducu tuhun ra chi ra Juaan ti: ―Maestru, ¿ñaan cha cuu cha cua savaha ndi? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ta cati ndico ra chi ra ta ra ti: ―Ña cua yaha cuhva satiahvi ndo chi ñivi, vati cha cati ra cumi tiñu yoso cuhva cua satiahvi ndo chi ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tacan cuu, ta nducu tuhun tahan ra sandaru chi ra ti: ―¿Ñaan cha cuu cha cua savaha maan ndi? ―cati ra. Ta cati ndico ra Juaan chi ra ti: ―Ña cua cati ndo chi ñivi ti cua cani ndo chi ñi, tu ña cua cuhva ñi xuhun chi ndo, ta ni ña cua cati ndo ti cua xico tuhun ndo chi ñi, tu ña cua cuhva ñi xuhun chi ndo. Ña cua suhu ndo, soco cua ndoo ndo vaha cuhva cha tiahvi ra ndaca ñahan chihin ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tacan cuu, ta quechaha saxini xaan ndihi ñivi can cuenda ra Juaan. Saxini ñi chi anima ñi ti vasi ra Cristo cuu ra, ");
INSERT INTO mioNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","soco cati ndico ra chi ndihi ñi ti: ―Yuhu sacuandute chi ndo chi nduta. Iti nuun ca cua quichi inga rai, ta iyo ca tu ndee ini chi maan ra. Ña cuu ndachi yu tiendu ndichan ra, vati ñahni cha vaha iyo chihin yu. Maan ra cua cuhva cha cua coo ra Tati Ndioo chi ndo, ta suvi ni maan ra cua tachi tuni. ");
INSERT INTO mioNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Cua ndehe ra yoo ñivi cuni cha vaha ndicha, ta cua canihin vaha ra chi ñivi can, soco cua tava ndaa ra chi ñivi ña cuni cha vaha. Cua cayu ñican, ta ña cua ndahva ñuhun can ―cati ra Juaan can. ");
INSERT INTO mioNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Cuaha xaan chaha ra Juaan cuenda chi ñivi, ta cati tuhun ra tuhun vaha chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nu quichi quivi cha cati ra chi ra Herode rey can ti ña vaha cha quihin ra chi ña Herodía ñasihi yani ra, ta ni ña vaha ndihi ca ndavaha ni ni savaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chacan cuu cha ña vaha cuni ra Herode, ta ni tihi ra chi ra Juaan ve caa. ");
INSERT INTO mioNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cha ni chanduta ndihi ñivi can, ta ni chanduta tahan ra Jesuu. Nu ni chanduta ra, ta cahan ra chi ra Ndioo, ta suvi ni hora can nuna iti siqui andivi, ");
INSERT INTO mioNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ta quichi nuun ra Tati Ndioo chi ra. Cuhva caa ri ndivi caa ra Tati Ndioo, ta nuun ra. Tacan cuu, ta quechaha cahan ra Ndioo iti siqui andivi, ta cati ra chi ra Jesuu ti: ―Yoho, sehi chihun. Cuni xain chihun, ta cusii ini yu chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Cha queta ra Jesuu oco uchi cuiya ra, ta quechaha cati tuhun ra chi ñivi. Sehe ra José chi ra cuhva ni saxini ñivi, ta sutu ra José cuu ra Elí. ");
INSERT INTO mioNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Sutu ra Elí can cuu ra Matat, ta sutu ra Matat can cuu ra Leví, ta sutu ra Leví can cuu ra Melqui, ta sutu ra Melqui can cuu ra Jana, ta sutu ra Jana can cuu ra José, ");
INSERT INTO mioNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ta sutu ra José can cuu ra Matatía, ta sutu ra Matatía can cuu ra Amón, ta sutu ra Amón can cuu ra Nahum, ta sutu ra Nahum can cuu ra Esli, ta sutu ra Esli can cuu ra Nagai, ");
INSERT INTO mioNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ta sutu ra Nagai can cuu ra Maat, ta sutu ra Maat can cuu ra Matatía, ta sutu ra Matatía can cuu ra Semei, ta sutu ra Semei can cuu ra José, ta sutu ra José can cuu ra Judá, ");
INSERT INTO mioNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ta sutu ra Judá can cuu ra Joana, ta sutu ra Joana can cuu ra Resa, ta sutu ra Resa can cuu ra Zorobabel, ta sutu ra Zorobabel can cuu ra Salatiel, ta sutu ra Salatiel can cuu ra Neri, ");
INSERT INTO mioNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ta sutu ra Neri can cuu ra Melqui, ta sutu ra Melqui can cuu ra Adi, ta sutu ra Adi can cuu ra Cosam, ta sutu ra Cosam can cuu ra Elmodam, ta sutu ra Elmodam can cuu ra Er, ");
INSERT INTO mioNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ta sutu ra Er can cuu ra Josué, ta sutu ra Josué can cuu ra Eliezer, ta sutu ra Eliezer can cuu ra Jorim, ta sutu ra Jorim can cuu ra Matat, ");
INSERT INTO mioNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ta sutu ra Matat can cuu ra Leví, ta sutu ra Leví can cuu ra Simeón, ta sutu ra Simeón can cuu ra Judá, ta sutu ra Judá can cuu ra José, ta sutu ra José can cuu ra Jonán, ta sutu ra Jonán can cuu ra Eliaquim, ");
INSERT INTO mioNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ta sutu ra Eliaquim can cuu ra Melea, ta sutu ra Melea can cuu ra Mainán, ta sutu ra Mainán can cuu ra Matata, ta sutu ra Matata can cuu ra Natán, ");
INSERT INTO mioNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ta sutu ra Natán can cuu ra David, ta sutu ra David can cuu ra Isaí, ta sutu ra Isaí can cuu ra Obed, ta sutu ra Obed can cuu ra Booz, ta sutu ra Booz can cuu ra Salmón, ta sutu ra Salmón can cuu ra Naasón, ");
INSERT INTO mioNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ta sutu ra Naasón can cuu ra Aminadab, ta sutu ra Aminadab can cuu ra Aram, ta sutu ra Aram can cuu ra Esrom, ta sutu ra Esrom can cuu ra Fare, ta sutu ra Fare can cuu ra Judá, ");
INSERT INTO mioNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ta sutu ra Judá can cuu ra Jacob, ta sutu ra Jacob cuu ra Isaac, ta sutu ra Isaac cuu ra Abraham, ta sutu ra Abraham cuu ra Taré, ta sutu ra Taré cuu ra Nacor, ");
INSERT INTO mioNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ta sutu ra Nacor can cuu ra Serug, ta sutu ra Serug can cuu ra Ragau, ta sutu ra Ragau can cuu ra Peleg, ta sutu ra Peleg can cuu ra Heber, ta sutu ra Heber can cuu ra Sala, ");
INSERT INTO mioNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ta sutu ra Sala can cuu ra Cainán, ta sutu ra Cainán can cuu ra Arfaxad, ta sutu ra Arfaxad can cuu ra Sem, ta sutu ra Sem cuu ra Noé, ta sutu ra Noé cuu ra Lamec, ");
INSERT INTO mioNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ta sutu ra Lamec cuu ra Matusalén, ta sutu ra Matusalén cuu ra Enoc, ta sutu ra Enoc cuu ra Jared, ta sutu ra Jared can cuu ra Mahalaleel, ta sutu ra Mahalaleel can cuu ra Cainán, ");
INSERT INTO mioNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ta sutu ra Cainán can cuu ra Enón, ta sutu ra Enón cuu ra Set, ta sutu ra Set cuu ra Adán, ta sutu ra Adán cuu ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iyo ra Tati Ndioo chi ra Jesuu, ta quichi ndico ra iti yuta Jordán. Tacan cuu, ta ni chandaca ra Tati Ndioo chi ra tichi cuhu. ");
INSERT INTO mioNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Uvi xico quivi ni chacoo ra Jesuu tican, vati cua ndehe run cuihna a ña vaha cua savaha ra Jesuu, ta ñahni cha chachi ra quivi can. Chacan cuu cha cha ni chisoco xaan ra, ta queta quivi can. ");
INSERT INTO mioNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tacan cuu, ta quechaha cati run cuihna chi ra ti: ―Tu ndicha ti sehe Ndioo cuu cun, cua cati cun chi yuu ya ti cua cuu chi paan ―cati run. ");
INSERT INTO mioNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ta cati ndico ra Jesuu chi run ti: ―Cha cati tutu Ndioo ti ñavi chi cha cua cachi ñi cua coo ndito ñivi, soco ra Ndioo cuu ra cua cuhva tu ndee ini chi ñi, cati chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tacan cuu, ta ni chandaca run cuihna chi ra iin nu sucun xaan, ta ndihi ñuun nu ndaca ñahan ñivi nu ñuhun ñuñivi sanahan run chi ra. Iin cha quii quii ni sanahan run chacan chi ra, ");
INSERT INTO mioNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ta quechaha cati ndico run chi ra ti: ―Ndihi cha ni ndehun ndihi cha taqui can cua cuhve chihun, vati chi main cuu chi, ta ndaa ñi cuni yu cua cuhve chi chi. ");
INSERT INTO mioNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tu cua cahnu chiti cun iti nuin, ta cua sacahnu cun chihin yu, ndihi chi cua cuu chihun ―cati run. ");
INSERT INTO mioNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tacan cuu, ta cati ndico ra Jesuu chi run ti: ―Yoho Satanaa, cua cuachiyo cun, vati cha cati tutu Ndioo ti cua sacahnu ñivi chi ra chahnu Ndioo, ta iin tuhun ni maan ra cuu ra cua sacahnu ñi, cati chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tacan cuu, ta ni chandaca run chi ra iti ñuun Jerusalén, ta chaqui ndaa run chi ra sucua xini ve ñuhun, ta cati run chi ra ti: ―Tu ndicha ti sehe Ndioo cuu cun, na cua capa cun iti nu ñuhun, ");
INSERT INTO mioNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","vati cha cati tutu Ndioo ti: Cua tava tiñu ra Ndioo chi tatun ra, vati cua cu cumi ra chihun. ");
INSERT INTO mioNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Cua canihin ra tatun Ndioo chihun, coto cua yani chahun chata yuu, cati chi ―cati run. ");
INSERT INTO mioNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ta cati ndico ra Jesuu chi run ti: ―Cha cati tahan tutu Ndioo ti ña cua ndehun a ña vaha cua savaha ra chahnu Ndioo, cati chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tacan cuu, ta cha ndihi ndehe run cuihna a ña vaha cua savaha ra, ta quee ndaa run nu iyo ra nda cua nda quivi cua nanducu ndico run yoso cuhva cua savaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iyo ra Tati Ndioo chi ra Jesuu, ta ni cuahan ndico ra iti ñuhun Galilea, ta nini cahnu ñuhun can queta tuhun yoso cuhva iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sacuaha ra chi ñivi ve ñuhun nu nducuiti ñi, ta sacahnu xaan ndihi ñivi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tacan cuu, ta queta ra Jesuu ñuun Nazaret nu ni chahnu ra, ta quivi sábadu quivi ndaa tatun ñivi can quihvi ra ve ñuhun cuhva iyo costumbre maan ra. Tacan cuu, ta ni chacuinda ra, vati cua sacuaha ra tutu Ndioo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chaha ñi tutu ni taa ra Isaía ra ni cahan cuenda ra Ndioo iti chata. Nuna ra chi chi, ta nanihin ra nu cati chi tehen: ");
INSERT INTO mioNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Iyo ra Tati Ndioo chihin yu, vati chaha ra tiñu chihin yu, vati cua cati tuhin tuhun vaha chi ñivi ndahvi. Tachi ra chihin yu, vati cua cati tuhin ti cua cacu ñivi nu iyo ñi chi tu ndoho. Cua ndehe ndico ñivi cuaa. Cua coo ndico tu ndee ini chi ñivi ña cundee ca, ");
INSERT INTO mioNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ta chahi cuenda ti cha ni queta quivi vaha cuhva cati ra chahnu nu ni quichi quivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tacan cuu, ta chasi ndico ra Jesuu tutu can. Ni chaha ndico ra chi chi chi ra naan chi chi, ta ni chacunda ndico ra. Nihin xaan ndehe ndihi ñivi iyo ve ñuhun can chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tacan cuu, ta quechaha cati ra chi ñi ti: ―Vitin quivi ya cha ni queta tuhun ya nu ni chini soho ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tacan cuu, ta cati ñi ti vaha xaan rai cuu ra, soco iyo xaan cuni ñi, vati taqui xaan tuhun cati tuhun ra chi ñi, ta quechaha nducu tuhun ñi chi tahan ñi ti: ―¿Atu ñavi sehe ra José chi ra? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ta cati ndico ra Jesuu chi ñi ti: ―Vasi cuhva ya cua cati ndo chihin yu. Cua cati ndo chihin yu ti: “Yoho doctor, na cua sanduvahun suvi ni chi maun.” Cua cati tahan ndo ti cha chini soho ndo ti cuaha xaan cha ni savahi ñuun Capernaum, ta na cua savaha tahin chacan ihya ñuin, cua cati ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ni vii cahan ra, ta cati ra chi ñi ti: ―Cati ndicha yu chihin ndo ti cuenda ra cahan cuenda ra Ndioo―ña tuhva ñivi iyo ñuun ra sacahnu ñi chi ra―masi sacahnu ndihi ca ñivi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yuhu cati chi ndo ti quivi ni iyo ra Elía iyo tuvi xaan ña ndahvi ñuhun Israel. Suvi ni quivi can ni queta uni cuiya yoso sava, ta ña cuun savi. Chacan cuu cha cahnu xaan tama ni chacoo nini cahnu ñuhun ya. ");
INSERT INTO mioNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Chacoo iin ña ndahvi ñuun Sarepta cha iyo cuenda ñuun Sidón. Chi iin tuhun ni ñacan tachi ra Ndioo chi ra Elía, ta ñahni ca ña ndahvi can nu ni tachi ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ta ni cuhva quivi ni iyo ra Eliseo ra ni cahan cuenda ra Ndioo iti chata iyo tuvi xaan ñivi cuhvi cuehe tahyu, soco iin tuhun ni ra Naamán ñuhun Siria cuu ra sanduvaha ra Eliseo, ta ñahni inga ñivi cuhvi cuehe can sanduvaha ra. Tacan cati ra Jesuu, vati ña sacahnu ñivi cuu ñivi ra Elía chi ra. Ta ni cuhva ña sacahnu ñivi ra Eliseo chi ra. Chacan cuu cha chahan ra ta ra nu iyo inga ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chini ñivi iyo ve ñuhun can tuhun cahan ra Jesuu, ta xaan xaan quechaha cuni ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Chacan cuu cha ni chacuinda ñi, ta tava ndaa ñi chi ra iti yuhu ñuun. Nda xini yucu nu iyo ñuun ñi ni chandaca ñi chi ra, vati cua saquehni ñi chi ra tichi xahva, ");
INSERT INTO mioNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","soco yaha ra tañu ñi, ta quee ra cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tacan cuu, ta cuahan ra Jesuu iti ñuun Capernaum. Iin ñuun cha iyo cuenda ñuhun Galilea cuu ñuun can, ta suvi ni quivi sábadu quivi ndaa tatun ñi cuu chi, ta sacuaha ra chi ñi ve ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Iyo xaan cuni ñi, vati cuhva iyo ndatu chi ra sacuaha ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tichi ve ñuhun can iyo tahan iin rai, ta iyo tati cuihna chi ra. Nihin xaan quechaha cana chaa run, ta cati run ti: ");
INSERT INTO mioNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Yoho Jesuu ñuun Nazaret, chite ñaan cha cuu cha cuni cun chi ndi. Quichi cun, vati cua cahni cun chi ndi. Chite yoo rai cuu cun. Yoho cuu ra ii cha ni tava tiñu ra Ndioo ―cati run. ");
INSERT INTO mioNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tacan cuu, ta nduxaan ra chi tati cuihna can, ta cati ra chi run ti: ―¡Taxin ni coun! Cua quee cun tichi anima rahya ―cati ra. Tacan cuu, ta sanduva run chi ra ndahvi can iti nuun ñi, ta quee run tichi anima ra, soco ñahni cha ni sanicuehe run chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iyo xaan cuni ndihi ñivi can, ta quechaha cati ñi chi tahan ñi ti: ―Cahnu xaan tuhun cahan ra, vati iyo xaan ndatu chi ra. Iyo xaan tu ndee ini chi ra, vati cahan ra chi run tati cuihna, ta quee run ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tacan cuu, ta nini cahnu tican chinu tuhun yoso cuhva ni savaha ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tacan cuu, ta quee ra Jesuu ve ñuhun can, ta cuahan ra iti vehe ra Simón. Iyo tu ndoho chi chiso ra Simón, vati iyo xaan cahni chi ña. Chacan cuu cha quechaha cahan ñivi chi ra Jesuu, vati na cua tindee ra chi ña. ");
INSERT INTO mioNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tuhva ra nu caa ña, ta sanduvaha ra chi ña, ta ndico cahni chi ña. Tacan cuu, ta ni chacuinda ña, ta chaha ña cha cua cachi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Cha cua cuiso nicandi quivi can, ta ni chandaca ñivi chi ñivi cuhvi nu iyo ra Jesuu. Cuaha nuun cuehe cuhvi ñivi can, soco tiso ra ndaha ra chi ta iin ta iin ñi, ta sanduvaha ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tava tahan ra cuaha tati cuihna anima ñivi. Cana chaa run, ta quee run, ta cati run ti: ―Yoho―sehe Ndioo cuu cun ―cati run. Tacan cuu, ta nduxaan ra chi run. Ña chaha ra cha cahan run, vati chito run ti cha tava tiñu ra Ndioo chi ra, ta ra Cristo cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tuvi inga quivi, ta quee ra Jesuu cuahan ra. Tichi cuhu cuahan ra, vati cua cahan ra chi ra Ndioo. Tacan cuu, ta nanducu ñivi chi ra. Nanihin ñi chi ra, ta ña cuni ñi saña ñi chi ra, vati ña cuni ñi cha cuhun ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tacan cuu, ta quechaha cati ra chi ñi ti: ―Iyo cha cua cuhun tahin inga ñuun, ta cua cati tuhun tahin yoso cuhva cua coo ñivi chi ra Ndioo nu cua cundaca ñahan ra. Iyo cha cua cati tuhin tuhun can, vati cuenda chacan quichi yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chacan cuu cha cuahan ra ndihi ve ñuhun nu sacahnu ñivi judío can, ta cati tuhun ra tuhun Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Iin quivi iyo ra Jesuu yu tañuhun Genesaret, ta tuvi xaan ñivi nducuiti. Ndunihin xaan ñi nu iyo ra, vati cuni ñi tasoho ñi tuhun Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tacan cuu, ta ndehe ra Jesuu ti yatin caa uvi tundoo. Cha quee ra ta ra tichi chi, ta nacata ra taraya ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Quihvi ra Jesuu iin chi. Chi ra Simón cuu chi, ta cati ra Jesuu chi ra ti na cua sacunu ra chi chi suhva ca nu cunu nduta. Tacan cuu, ta ni chacunda ra tichi tundoo can, ta quechaha sacuaha ra chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nu ni ndihi sacuaha ra chi ñi, ta quechaha cati ra chi ra Simón ti: ―Vitin na coho nu cunu xaan nduta. Cua tihi ndo taraya ndo, vati cua tiin ndo chi ri tiaca ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ta cati ndico ra Simón Pedro ti: ―Ra chahnu, niñu niñu satiñu ndi, ta ñahni ri tiin ndi, soco cua tihi yu taraya, vati maun cati ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tacan cuu, ta tihi ra ta ra taraya, ta cuaha xaan ri tiaca chasi ra. Nda cua cuni tahnda taraya can, vati cuaha xaan ri ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chacan cuu cha savaha ra seña chi tahan ra iyo inga tundoo, vati cua quichi tindee ra chi ra. Tacan cuu, ta quichi ra, ta nduvi tundoo can sacutu ra ta ra nda cua cuni nanuun tundoo tichi nduta. ");
INSERT INTO mioNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ndehe ra Simón Pedro can ti cha suhva tiaca cuu ri tiin ra, ta chahnu chiti ra iti nuun ra Jesuu, ta quechaha cati ra ti: ―Cuahan, ra chahnu, vati iyo xaan cuati chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tacan ni cati ra, vati yuhvi xaan ra cuu, ta cuyuhvi tahan ndihi ra iyo chi ra, vati cuaha suhva tiaca tiin ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Cuyuhvi tahan ra Jacobo chi ra Juaan. Sehe Zebedeo chi ra ta ra, ta satiñu tahan ra ta ra chi ra Simón. Tacan cuu, ta cati ndico ra Jesuu chi ra Simón ti: ―Ña cuyuhvi cun. Nda vitin ta nda cua nda iti nuun cua nanducu cun chi ñivi cuhva ni nanducu cun chi ri tiaca, ta cua cati tuhun cun tuhun Ndioo chi ñi, ta cua cuinu ini ñi chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tacan cuu, ta satuhva ra ta ra tundoo can yu nduta. Saña ra ta ra ndihi cha iyo chi ra, ta cuahan ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iin ñuun nu yaha ra Jesuu, ta tahan ra iin ra cuhvi, ta cuehe tahyu cuhvi xaan ra. Nu ni ndehe ra chi ra Jesuu, ta chahnu chiti ra iti nuun ra, ta quechaha cahan ndahvi xaan ra chi ra, ta cati ra ti: ―Ra chahnu, tu cua cuni cun sanduvahun chihin yu, cua cuu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tacan cuu, ta sacaa ra Jesuu ndaha ra, ta tiso ra ndaha ra chi ra ndahvi can, ta quechaha cati ra chi ra ti: ―Cuni yu. Na nduvahun ―cati ra. Ta suvi ni hora can nduvaha ra cuhvi cuehe tahyu can. ");
INSERT INTO mioNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tacan cuu, ta cati tuhun ra Jesuu chi ra ti: ―Ña cua cuhva cun cuenda chi ni iin ñivi. Nuun ra sutu ni cua cuhun cun, ta cua sanahun chi ra ti ni nduvahun. Cuenda cha ni nduvahun cua cuiso cun cuhva cati ra Moisee iti chata. Chacan cuu cha cua coto ñivi ti ni nduvahun ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Cuaha xaan ca chinu tuhun yoso cuhva ni sanduvaha ra Jesuu chi ñivi. Chacan cuu cha nducuiti xaan ñivi. Tuvi ñivi nducuiti, vati cuni ñi tasoho ñi tuhun cahan ra, ta cuni ñi cha cua sanduvaha ca ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Chacan cuu cha cuahan ra tichi cuhu nu ñahni ñivi, ta cahan ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iin quivi sacuaha ra Jesuu chi ñivi, ta iyo tahan ra fariseo ta ra chi ra sacuaha ley chahnu cuenda ñivi judío can. Iti ñuhun Galilea ni quichi racan ta ra. Quichi tahan ra iti ñuhun Judea, ta quichi tahan ra iti ñuun Jerusalén. Cuaha ñuun ni quichi ra ta ra, ta iyo tu ndee ini cha chaha ra chahnu Ndioo chi ra Jesuu, vati cua sanduvaha ra chi ñivi cuhvi. ");
INSERT INTO mioNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tacan cuu, ta quichi ñivi, ta ndiso ñi chi iin ra. Caa ra nu yuvi ra, ta nduñiin ra. Nducu ñican cuhva cha cua yaha ñi chi ra, ta cua caqui ñi chi ra iti nuun ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ña nihin ñi nu cua yaha ñi, vati tuvi xaan ñivi iyo. Chacan cuu cha ndaa ñi nda xini vehe, ta sachiyo ñi tiyo xini vehe can. Tacan cuu, ta sanuun ñi chi ra. Iti nuun ra Jesuu nda mahñu nu iyo ñivi can sanuun ñi chi ra, ta caa ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ndehe ra Jesuu ti chinu ini ñi ndiso chi ra, ta quechaha cati ra chi ra nduñiin can ti: ―Xaa, cha ni naan cuati iyo chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tacan cuu, ta quechaha saxini ra fariseo can chi ra sacuaha ley chahnu. Saxini ra ta ra chi anima ra ti ña vaha rai cuu rahya. Cahan ra ndavaha ni cuenda ra Ndioo, vati iin tuhun ni ra Ndioo cuu ra cuu sanaan cuati iyo chi ñivi. Tacan ni saxini ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tacan cuu, ta chito ra Jesuu yoso cuhva saxini ra ta ra chi anima ra, ta quechaha cati ra chi ra ta ra ti: ―Ña vaha cuhva saxini ndo chi anima ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ña ii xaan cha cati yo ti cha ni naan cuati cha iyo chi ñivi. Ii ca cha cua cati yo ti cua cuinda ñi, ta cua cuhun ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Chacan cua savahi, vati tacan ni cua coto ndo ti iyo ndatu chi ra cuu sehe ñivi, ta cua cuu sanaan ra cuati iyo chi ñivi iyo nu ñuhun ñuñivi ya ―cati ra. Tacan cuu, ta cati ndico ra chi ra ndahvi can ti: ―Chi yoho cahan yu. Cuinda, ta canihun yuvi cun, ta cuahan iti vehun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tacan cuu, ta ni chacuinda ra iti nuun ñivi can. Canihin ra yuvi nu caa ra, ta cuahan ra iti vehe ra, ta cati ra ti cahnu xaan cuu ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Iyo xaan cuni ndihi ñivi can, soco sacahnu ñi chi ra Ndioo. Yuhvi xaan ñi, ta cati ñi ti: ―Vitin cha ni ndehe yo iin cha cahnu xaan ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tacan cuu, ta quee ra Jesuu cuahan ra, ta ndehe ra chi iin rai nu ndaa ra satiahvi ra chi ñivi. Leví nani ra, ta chi racan quechaha cati ra Jesuu ti: ―Na coho ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tacan cuu, ta ni chacuinda ra Leví can, ta nacoo ra ndihi ndatiñu ra, ta cuahan ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tacan cuu, ta cahnu xaan vico ni savaha ra Leví vehe ra. Cuenda ra Jesuu sacahnu ra vico can, ta tuvi xaan ñivi quichi. Quichi xaan ra satiahvi ta ra, ta iyo ra chi ra Jesuu chi ra Leví yu mesa. ");
INSERT INTO mioNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tacan cuu, ta quechaha cahan ra fariseo chi ra sacuaha ley chahnu, ta nducu tuhun ra ta ra chi ra sacuaha chi ra Jesuu ti: ―¿Ñacu chachi ra Jesuu chi ñivi ndacu cuati icaa ni? ¿Ñacu chachi ra chi rai satiahvi icaa ni? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tacan cuu, ta cati ndico ra Jesuu chi ra ta ra ti: ―Ñivi ña cuhvi―ña chini ñuhun ñi chi ra sanduvaha, soco ñivi cuhvi cuu ñi chini ñuhun chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Chacan cuu cha ña cati tuhin chi ñivi iyo vaha. Cati tuhin chi ñivi iyo cuati ti na cua nacoo ihni ñi cuati ndacu ñi, vati chacan tiñu vachi yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tacan cuu, ta cati ra fariseo ta ra chi ra Jesuu ti: ―Ta ra sacuaha chi ra Juaan―chacoo ndita xaan ra, ta cuaha xaan cahan ndahvi ra chi ra Ndioo. Ta ni cuhva ndacu ra sacuaha chi ra fariseo, soco ra sacuaha chi maun―mani cha cachi ra cuni ra. Mani cha coho ra cuni ra ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Ña cua coo ndita amigu ra tandaha quivi ni iyo ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","soco cua queta quivi cua cuhun ra tandaha can, ta sa cua coo ndita amigu ra ―cati ra Jesuu cuenda maan ra chi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ni vii cahan ra Jesuu cuhva ya, ta cati ra chi ra fariseo can ti: ―Ña tuhva yo cahnda yo sahma chaa, ta nataa yo chi chi chi sahma chahnu. Tu tacan ni cua savaha yo, cua tahnda tahan cha chaa, ta ña cua nduinuun chi chi cha chahnu can. ");
INSERT INTO mioNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ta ni cuhva ña tuhva yo tihi yo nduta chiti uva chaa tichi iin iti ñiin chahnu. Tu tacan ni cua savaha yo, cua ndata iti ñiin can cua savaha nduta chaa can. Chacan cuu cha cua cati nduta can, ta cua ndoyo ñuhun tahan iti can. ");
INSERT INTO mioNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tichi iti ñiin chaa tihi yo nduta chiti uva chaa. ");
INSERT INTO mioNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tu cua coho yo nduta chahnu, ña cua cuni ca yo cha chaa, vati cua cati yo ti vaha xaan iyo cha chahnu. Cuhva can cati ra Jesuu, vati chaha ra cuenda ti cua tiso ra iin tuhun chaa yoso cuhva cua coo ñivi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Iin quivi sábadu quivi ndaa tatun ñivi yaha ra Jesuu chi ra sacuaha chi ra nu iyo itu, ta yucu ra sacuaha chi ra uvi tahan chi. Saquee ra chi chi, ta chachi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tacan cuu, ta quechaha nducu tuhun ra fariseo chi ra ti: ―¿Ñacu ndacu ndo chacan, vati ña chaha ley cha cua savaha yo chacan quivi vitin? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ta cati ndico ra Jesuu chi ra ti: ―Vasi ña ta sacuaha ndo cuhva ni savaha ra David iti chata quivi ni yaha soco chi ra chi ra chica chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Quihvi ra vehe Ndioo, ta quihin ra paan cuecu iti nuun ra Ndioo, ta chachi ra chi chi, ta chaha ra cha cachi tahan ra quichi chi ra. Ñavi cuhva cati ley cuu chacan, vati iin tuhun ni ra cuu sutu cuu ra cuu cachi chacan, soco chachi ra David ta ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ni vii cati ra Jesuu chi ra ti: ―Yuhu ra cuu sehe ñivi cuu ra cati ñaan cha cuu cha cua savaha ñivi quivi sábadu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Inga quivi sábadu ni quihvi tucu ra Jesuu ve ñuhun, ta sacuaha ra chi ñivi. Iyo tahan iin rai tican, ta nduxii ndaha cuaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Iyo tahan ra sacuaha ley chahnu chi ra fariseo, ta ndehe xaan ra ta ra a cua sanduvaha ra Jesuu chi ñivi, ta quivi sábadu cuu chi, vati cuni ra ta ra tiso ra cuati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Chito ra Jesuu cuhva saxini ra ta ra, soco cati ra chi ra nduxii ndaha ti: ―Nahan. Na cuinda nda mahñu na ndehe ―cati ra. Tacan cuu, ta ni chacuinda ra ndacan, ");
INSERT INTO mioNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ta cati ra Jesuu chi ra fariseo ta ra ti: ―Cua nducu tuhin iin tuhun chi ndo. ¿Atu chaha ley cha cua savaha yo iin cha vaha a iin cha ndavaha ni quivi sábadu? ¿Atu chaha ley cha cua sacacu yo chi ñivi nu iyo ñi chi tu ndoho a chaha chi cha cua cahni yo chi ñi quivi ya? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tacan cuu, ta ndehe ra Jesuu nuun ndihi ra ta ra, ta cati ra chi ra ndahvi can ti: ―Sacaun ndahun ―cati ra. Tacan cuu, ta ni sacaa ra ndaha ra, ta ni nduvaha ndaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Xaan xaan quechaha cuni ra fariseo ta ra, ta cahan ra iin ra inga ra chi tahan ra, vati cuni ra coto ra ñaan cha cuu cha cua savaha ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Iin quivi can cuahan ra Jesuu iti yucu, vati cuni ra cahan ra chi ra Ndioo, ta niñu niñu ni cahan ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tuvi inga quivi, ta cana ra chi ra sacuaha chi ra. Nacachi ra uchi uvi ra, ta cati ra ti tatun ra cua cuu ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nacachi ra chi ra Simón, ta cati ra ti Pedro cua cunani ra. Nacachi tahan ra chi ra Ndree yani ra Simón, ta nacachi ra chi ra Jacobo chi ra Juaan chi ra Felipe chi ra Bartolomé ");
INSERT INTO mioNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","chi ra Mateo chi ra Tuma chi ra Jacobo sehe Alfeo chi ra Simón ra cuni cuati chi ñivi ñuun Roma ");
INSERT INTO mioNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","chi ra Juda yani ra Jacobo chi ra Juda Iscariote ra cua xico tuhun chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tacan cuu, ta nuun ndico ra Jesuu chi ra ta ra siqui yucu can, ta queta ra iin nduhva, ta tuvi xaan ñivi nducuiti. Tuvi ñi cuu ñi, vati quichi ñivi sacuaha chi ra. Quichi ñivi nini cahnu ñuhun Judea. Quichi ñi ñuun Jerusalén. Quichi ñi iti yu tañuhun nu iyo ñuun Tiro chi ñuun Sidón. Quichi ñi, vati cuni ñi tasoho ñi tuhun cahan ra Jesuu, ta cuni ñi nduvaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nduvaha tahan ñivi iyo chi tu ndoho cha ñuhun tati cuihna anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ndihi ñivi can cuni ñi sayani ndaha ñi chi ra, vati iyo tu ndee ini chi ra, ta sanduvaha ra chi ndihi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tacan cuu, ta ndehe ra Jesuu chi ñivi sacuaha chi ra, ta quechaha cati ra chi ñi ti: ―Ndioho ñivi ndahvi, na cua cusii ini ndo, vati cua coo ndo chi ra Ndioo nu cua cundaca ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ndioho ñivi ñahni cha iyo vitin, na cua cusii ini ndo, vati cua coo vaha ndo nu cuahan quivi. ’Ndioho ñivi iyo tu cuihya ini vitin, na cua cusii ini ndo, vati cua cusii ndicha ini ndo nu cuahan quivi. ");
INSERT INTO mioNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Na cua cusii ini ndo, tu cua cuxaan ini ñivi chihin ndo. Tu cua tava ndaa ñivi chi ndo, tu cua cahan ñi ndavaha ni chi ndo, tu cua cati ñi ti ña vaha ñivi cuu ndo, vati iyo ndo chi ra cuu sehe ñivi, na cua cusii ini ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tu tacan ni cua tahan ndo, na cua cusii ini ndo quivi can, vati vaha xaan cua cunda yahvi ndo iti siqui andivi. Ta ni cuhva cha ni savaha ñivi ñi ndavaha ni chi ra ni cahan cuenda ra Ndioo tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Ndioho ñivi ricu, cua coo tu cuihya ini chi ndo, vati iyo vaha ndo vitin. ");
INSERT INTO mioNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Ndioho ñivi iyo vaha, cua coo tu cuihya ini chi ndo, vati cua cumani chi chi ndo. ’Ndioho ñivi cusii ini vitin, cua coo tu cuihya ini chi ndo, vati cua cucuihya ndicha cuni anima ndo nu cuahan quivi. ");
INSERT INTO mioNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Cua coo tu cuihya ini chi ndo, tu cua cahan vaha ndihi ñivi chi ndo, vati ta ni cuhva cahan vaha ñivi ndo chi ra sandahyu ñahan tiempu chahnu, vati cati ra ti cahan ra cuenda ra Ndioo, ta ña ndicha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ni vii cahan ra Jesuu chi ñivi can: ’Yuhu cati chi ndo ti na cua cuni mani ndo chi ñivi cuxaan ini chi ndo. Na cua savaha ndo cha vaha chi ñivi savaha ndavaha ni chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Cua cahan ndo cha vaha chi ñivi cahan ndavaha ni chihin ndo, ta cua cahan ndahvi ndo chi ra Ndioo cuenda ñivi savaha ndavaha ni chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tu cua cani ñivi iin chiyo nuun ndo, cua cuni mani ndo chi ñi, ta tu cua quihin ñivi sahma ndo, cua cuni mani ndo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Cua tindee ndo chi ndihi ñivi chica caya nu iyo ndo. Ña cua cati ndo ti cua cuhva ndico ñivi ñaan cha suhu ñi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Cua savaha ndo cha vaha chi ñivi cuhva cuni ndo cha cua savaha ndico ñi chi maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tu cua cuni mani ndo mani chi ñivi cuni mani chi maan ndo, ñavi tu manini cua cuu chacan, vati tacan ni cuni mani tahan ñivi ndavaha ni chi ñivi cuni mani chi maan ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tu cua savaha ndo cha vaha mani chi ñivi ndacu cha vaha chi maan ndo, ñavi tu manini cua cuu chacan, vati ta ni cuhva ndacu ñivi ndacu ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tu cua cuhva nuun ndo xuhun chi ñivi, ta saxini ndo ti cua cuhva ndico ñi chi maan ndo, ñavi tu manini cua cuu chacan, vati ta ni cuhva chaha nuun ñivi ndacu ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Na cua cuni mani ndo chi ñivi savaha ndavaha ni chihin ndo. Na cua savaha ndo cha vaha, ta na cua cuhva nuun ndo xuhun―masi ñahni cha cua nihin ndico ndo. Tacan, ta sa cua savaha vaha xaan ra Ndioo chi ndo iti siqui andivi. Sehe maan ra cua cuu ndo, vati iyo xaan tu manini chi ra―masi ñahni tu manini iyo chi ñivi, masi mani chi maan ñi cuni ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Na cua coo tu manini chi maan ndo cuhva iyo tu manini chi ra cuu sutu yo. ");
INSERT INTO mioNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ni vii cahan ra Jesuu chi ñivi can: ’Ña cua cati ndo ti ña vaha ñivi cuu ñivi tahan ndo. Tacan, ta sa cua cati tahan ra Ndioo ti ña vaha maan ndo. Ña cua tachi tuni ndo chi ñivi. Tacan, ta sa ña cua cutuni maan ndo. Cua cucahnu ini ndo chi ñivi tahan ndo, ta sa cua cucahnu tahan ini ra Ndioo chi maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Na cua tindee ndo chi ñivi tahan ndo, ta sa cua tindee tahan ra Ndioo chi maan ndo. Vaha xaan cua tindee ra chi ndo, vati cuhva cua savaha ndo chi tahan ndo cua savaha tahan ra chi maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ta cuhva ya cahan ra Jesuu chi ñi: ―Ña cua cuu cundaca iin ra cuaa chi suvi ni tahan maan ra. Tu cua nducu ra cuhva, nduvi tahan ra cuaa can cua quehni tichi xahva. ");
INSERT INTO mioNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ta ra sacuaha chi ra cuu maestru―ña chito ra cuhva chito ra cuu maestru ra, soco cua cutuhva ra, ta sa cua coto tahan ra cuhva cha chito ra maestru. ");
INSERT INTO mioNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Ndehe ndo ti ndacu ra cuu yani ndo ndavaha ni, soco ña saxini ndo cha ni ndacu tahan maan ndo ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ña vaha tu cua cati ndo chi ra yani ndo ti cua cuhva ra cha cua cati tuhun ndo chihin ra, vati ña vaha cha ndacu ndo ndavaha ni, ta ña chito ndo ti cahnu ca ndavaha ni ndacu maan ndo. Ra uvi yaa cuu ndo. Xihna ca cua saña ndo cha ndacu maan ndo ndavaha ni, ta sa cua cuu tindee ndo chi ra cuu yani ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ni vii cahan ra Jesuu chi ñivi can: ’Ndihi yutun vaha―quee chiti vaha nuun chi. Tu ña vaha yutun, ña cua quee chiti vaha nuun chi. ");
INSERT INTO mioNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chacan cuu cha ndehe yo chiti yutun, ta chito yo ñaan yutun cuu chi, vati ña quee ticava nu yutun iñu, ta ni ña quee ticuayu nu tiyata. ");
INSERT INTO mioNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Chacan cuu cha ndacu ñivi vaha cha vaha, vati cha vaha saxini ñi chi anima ñi. Ta ni cuhva ndavaha ni ndacu ñivi ndavaha ni, vati cha ndavaha ni saxini ñi chi anima ñi. Tacan ni iyo ñi ta ñi, vati cuhva saxini ñi chi anima ñi cahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ni vii cahan ra Jesuu chi ñivi can: ’Tu ña cua savaha ndo cuhva cati yu, ña vaha cha cua cati ndo ti chitoho ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Quichi xaan ndo iti nuin. Tu cua tasoho ndo tuhun cahin, tu cua sacuinu ndo cuhva cati yu, cua coo vaha ndo, ");
INSERT INTO mioNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","vati cua cuu ndo sava ni ta cua iin rai sandaa vehe. Cunu vaha nañu ra nu cua cacu chaha chi, ta tiso ra chaha chi nu yuu. Cuun savi, ta nihin xaan yani nduta chaha vehe nu chinu nduta, soco ñahni cha tahan chi, vati vaha xaan indi chaha chi. ");
INSERT INTO mioNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tu cua cuni soho ndo tuhun cahan yu, ta ña cua sacuinu ndo chi chi, cua cuu ndo sava ni ta cua iin rai sandaa vehe, ta ña nañu ra nu chaqui ndaa ra chi chi. Cuun savi, ta yani nduta chaha chi. Yatin xaan nduva chi, ta cuaha xaan ndoyo ñuhun chi. Tacan cati ra Jesuu, vati cuhva cua coo ñivi cuenda maan ra cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cha ndihi cati tuhun ra Jesuu ndihi tuhun can chi ñivi can, ta sa cuahan ra iti ñuun Capernaum. ");
INSERT INTO mioNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Iyo iin ra sandaru cahnu cuenda ñuun Roma, ta iyo iin musu ra. Cuhvi xaan ra cuu musu ra, ta cuni cuvi ra. Cuni xaan ra sandaru can chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Cha chini ra yoso cuhva ni savaha ra Jesuu, ta tachi ra chi ra cuu mandoni cuenda ñivi judío iti nuun ra Jesuu. Tachi ra chi ra, vati cua cahan ndahvi ra chi ra Jesuu a ña cua cuhun ra, ta cua sanduvaha ra chi musu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Chacan cuu cha cuahan ra judío can nuun iyo ra Jesuu, ta cahan ndahvi xaan ra chi ra. Cati ra chi ra Jesuu ti: ―Iyo cha cua tindeun chi iin ra sandaru cahnu, vati vaha xaan rai cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Cuni xaan ra chi yo chi ndihi ñivi yo, ta maan ra savaha iin ve ñuhun chi ndi nu sacahnu ndi chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tacan cuu, ta cuahan ra Jesuu chi ra. Cha cua queta ra vehe ra sandaru can, ta tachi ra sandaru can amigu ra nu vachi ra Jesuu, ta cati ra chi ra cuenda ra sandaru can ti: ―Ña cuhun ni cun, ra chahnu. Ña cua quihvi cun tichi vehi, vati ñahni yavi ndai. ");
INSERT INTO mioNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chacan cuu cha ña quichi yu cahin chihun. Ihya ni cua cahun, ta cua nduvaha musu yu. ");
INSERT INTO mioNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tacan cati yu, vati chite yoso cuhva iyo tiñu, vati iyo iin ra ndaca ñahan chihin yu, ta ndaca ñahan tahin chi inga ra, ta cati yu chi ra ti cua cuhun ra, ta cuahan ra. Cati yu chi inga ra ti cua quichi ra, ta quichi ra. Chi ra musu yu cati yu yoso cua savaha ra, ta cua savaha ra chi chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chini ra Jesuu tuhun cahan ra, ta iyo xaan quechaha cuni ra, ta ndico coo ra nu vachi ñivi ndicu chi ra, ta quechaha cati ra chi ñi ti: ―Cati yu chi ndo ti yoni ñivi judío chinu ini chi ra Ndioo cuhva chinu ini racan ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tacan cuu, ta cuahan ndico amigu ra sandaru vehe ra, ta ndehe ñi ti cha ni nduvaha musu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tuvi inga quivi, ta cuahan ra Jesuu iti ñuun Naín. Cuahan tahan ra sacuaha chi ra, ta tuvi ñivi cuahan tahan, ");
INSERT INTO mioNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ta cha cua queta ra Jesuu yu ñuun can, ta yaha iin ndii. Ña ndahvi cuu sihi ra ni chihi can, ta ñahni ca sehe ña iyo, vati iin tuhun racan cuu sehe ña. Tuvi ñivi cuahan chi sihi ra ndii can. ");
INSERT INTO mioNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tacan cuu, ta ndehe ra Jesuu chi ña, ta quechaha ndundahvi cuni anima ra ndehe ra chi ña, ta quechaha cati ra chi ña ti: ―Ña cuacun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tacan cuu, ta tuhva ra nu cuahan ndii can, ta tiin ra chatun can, ta ni chacuinda ra ndiso chi chi. Tacan cuu, ta quechaha cati ra Jesuu ti: ―Yoho xaa, cati yu chihun ti cua ndoyo cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tacan cuu, ta ni chacunda ra ndii can, ta quechaha cahan ra. Tacan cuu, ta chaha cuenda ra Jesuu chi ra chi sihi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yuhvi xaan cuni ndihi ñivi can, ta quechaha sacahnu ñi chi ra Ndioo, ta cati ñi ti: ―¡Cahnu xaan rai cuu rahya! Cahan ndicha ra chi yo cuenda ra Ndioo ―cati ñi. Ta cati ndico tucu ñi ti: ―Quichi ra Ndioo, vati cua tindee ra chi ñivi ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ta nini cahnu ñuhun Judea can nini cahnu ñuhun iyo yatin chinu tuhun yoso cuhva ni savaha ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tacan cuu, ta chaha ra tatun ra Juaan cuenda chi ra yoso cuhva cha ni savaha ra Jesuu. Chacan cuu cha cana ra Juaan can chi uvi ra tatun ra, ");
INSERT INTO mioNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ta tava tiñu ra chi ra, vati cua nducu tuhun ra chi ra chahnu atu suvi ni maan ra cuu ra cua quichi cuenda ra Ndioo a ni cua cuatu ra ta ra chi inga ra, cati ra Juaan. ");
INSERT INTO mioNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tacan cuu, ta cuahan ra nu iyo ra Jesuu, ta quechaha cati ra chi ra ti: ―Juaan ra sacuanduta tava tiñu chi ndi, ta nducu tuhun ra atu maun cuu ra cua quichi a ni cua cuatu ndi chi inga ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tacan cuu, ta suvi ni hora can sanduvaha ra Jesuu chi ñivi. Tuvi ñivi ni sanduvaha ra, ta cuaha nuun cuehe cuhvi ñi ndehe ñi tu ndoho. Tava ra tati cuihna anima ñivi, ta tuvi ñivi cuaa―ndundichin vaha ndehe ndico ñi savaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tacan cuu, ta cati ndico ra Jesuu chi tatun ra Juaan can ti: ―Vitin cuahan ndo, ta cuhva ndo cuenda chi ra Juaan ndihi cha ni ndehe ndo ndihi cha ni chini soho ndo. Cua cati ndo ti ndundichin vaha ndehe ñivi cuii nuun. Chica cuu ñivi cojo. Nduvaha ñivi cuhvi cuehe tahyu. Chini ñivi soho. Nandoto ndico ñivi cha ni chihi. Tuhun vaha chini soho ñivi ndahvi. ");
INSERT INTO mioNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Cua cusii ini ñivi, tu ña cua saxini ñi ndavaha ni cuenda cha ndacu yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tacan cuu, ta cuahan ndico tatun ra Juaan, ta quechaha cati ra Jesuu chi ñivi can cuenda ra Juaan ti: ―Chahan ndo tichi cuhu, soco ñavi vati cuni ndehe ndo chi iin rai cha cuu sava ni ta cua iin tuyoo cha yani tati. ");
INSERT INTO mioNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Chahan ndo, soco ñavi vati cuni ndehe ndo iin rai ndichin sahma taqui vaha. Chito ndo ti ñivi ndichin cha taqui ndicha, ñivi cha iyo vaha ndicha―ñican iyo ñi vehe cahnu nu iyo ra rey, ta ña iyo ñi tichi cuhu. ");
INSERT INTO mioNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yuhu cati ti chahan ndo, vati cuni ndo ndehe ndo chi iin rai cahan cuenda ra Ndioo, soco cahnu xaan ca rai cuu ra Juaan. ");
INSERT INTO mioNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Cuenda maan ra cati tutu Ndioo ti: Tachi yu chi iin ra tatun yu iti nuun cun, vati maan ra cuu ra cua tiso vaha tiñu iti nu cua yahun, cati ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yuhu cati ti ñahni ca ñivi ñuñivi iyo cha cahnu ca. Ra Juaan cuu ra cahnu xaan ca, soco cahnu ca cua cuu ñivi cua coo chi ra Ndioo nu cua cundaca ñahan ra―masi ñivi ndahvi cuu ñi vitin ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Chini ñivi ndihi tuhun can, ta sa quechaha cati ñi ti rai vaha ndicha cuu ra Ndioo, vati cha ni chanduta ñi cuenda ra Juaan. Tacan ni cati tahan ra satiahvi chi ñivi, vati cha ni chanduta tahan ra cuenda ra Juaan, ");
INSERT INTO mioNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","soco ña sacuinu ra fariseo chi ra chito ley chahnu cuhva cuni ra Ndioo chi ra ta ra, vati ña chaha ra ta ra cha sacuanduta ra Juaan chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tacan cuu, ta cati ra Jesuu ti chito ra yoso cuhva iyo ñivi iyo quivi can. ");
INSERT INTO mioNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iyo ñi cuhva iyo ñi cuati siqui nuyahvi, vati cana ñi iin tahan ñi inga tahan ñi, ta cati ñi ti cha tivi ñi yaa chi ñi, soco ña chita chaha ñi. Chita ñi yaa ndii chi ñi, soco ña chacu ñi, cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tacan cati yu chi ndo, vati quichi ra Juaan ra sacuanduta. Ña tuhva ra cachi ra xita, ta ni ña tuhva ra coho ra nduta chiti uva, ta cati ndo ti iyo tati cuihna chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tacan cuu, ta quichi tahan yu ra cuu sehe ñivi. Chachi yu, ta chihi yu, ta cati ndo ti yaha xaan cuhva chachi yu. Yaha xaan cuhva chihi yu, ta amigu xain chi ñivi ndacu cuati, ta amigu xain chi ra satiahvi, cati ndo, ");
INSERT INTO mioNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","soco ndihi ñivi ra Ndioo cutuni ini ñi, vati iyo cha chini tuni chi maan ra, cati ra Jesuu, vati ña ndoo ñi vaha ni chi ra Juaan ni chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Iin quivi cati iin ra fariseo chi ra Jesuu ti na cua cu cachi ra chi ra vehe ra. Chacan cuu cha cuahan ra Jesuu vehe ra, ta chachi ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Iyo tahan iin ñahan ñuun can. Cuaha xaan cuati cha savaha ñacan, ta chito ña ti chachi ra Jesuu vehe ra fariseo can. Chacan cuu cha quichi naan ña iin nu indi nduta vixin chahan. ");
INSERT INTO mioNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tacan cuu, ta ni chacuinda ña iti chata ra Jesuu nu caa ra, ta ndahyu ña. Tacan cuu, ta yani nduta nuun ña chaha ra Jesuu, ta chi ixi xini ña quechaha nacuhva ña chaha ra. Taa yuhu ña chaha ra, ta choso ña nduta vixin chahan can chaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ndehe ra fariseo can cha ni savaha ña chi ra Jesuu, ta quechaha saxini ra chi anima ra ti tu ndicha ti rai cahan cuenda ra Ndioo cuu rahya, cua coto ra yoo ñahan cuu ña tiin chi ra. Cua coto ra ñaan cha cuu cha ni savaha ña, vati ni savaha xaan ña cuati, saxini ra xu vehe can. ");
INSERT INTO mioNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tacan cuu, ta quechaha cati ra Jesuu chi ra ti: ―Iyo iin cha cua cati yu chihun, Simón ―cati ra. Ta cati ndico ra fariseo can chi ra ti: ―¿Ñaan cha cuu chi, ta maestru? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ta quechaha cati ra Jesuu iin cuhva chi ra ti: ―Cha iyo uvi rai. Ndiseca ra ta ra chi inga ra chahnu. Iin ra ndiseca uhun ciendu xuhun denario chi ra, ta inga ra ndiseca uvi xico uchi ni. ");
INSERT INTO mioNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tacan cuu, ta ña cundee tiahvi ndico ra ta ra. Chacan cuu cha sanaan ra chahnu can cuenda cha ndiseca ra ta ra. Vitin cua cati cun ndaa ra cua cuni mani ca chi ra chahnu can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ta cati ndico ra Simón ti: ―Yuhu cati ti ra ndiseca cha suhva vihi ca cuu ra cua cuni mani ca chi ra ―cati ra. Ta cati ra Jesuu chi ra ti: ―Vaha xaan cati cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tacan cuu, ta ndehe ra Jesuu chi ña ñahan can, ta cati ra chi ra Simón ti: ―¿Atu ña ni ndehun cha ni savaha ñahya chihin yu? Quichi yu vehun, ta ña chahun nduta cua ndoo chahi, ta ñahya―nacata ña chahi chi nduta nuun ña, ta nacuhva ña chahi chi ixi xini ña. ");
INSERT INTO mioNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ña ni taa yuhu cun chihin yu, soco ña chacuita cha taa yuhu maan ña chahi nda cua nda hora ni quichi yu. ");
INSERT INTO mioNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ñahni aceite choso cun xini yu, soco nduta vixin chahan choso ña chahi. ");
INSERT INTO mioNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chacan cuu cha cati yu chihun ti cha ni naan cuati iyo chi ña, ta cuaha suhva cuati ni savaha ña. Chite ti ni naan cuati ña, vati cuni mani xaan ña chihin yu. Ta ñivi saxini ti ña savaha xaan ñi cuati―ña cuni mani xaan ñi, vati saxini ñi ti ña cuaha cuati ñi naan ―cati ra chi ra Simón. ");
INSERT INTO mioNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tacan cuu, ta cati ra Jesuu chi maan ña ñahan can ti: ―Cha ni naan cuati ni savahun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tacan cuu, ta quechaha cahan ñivi chachi chi ra icaa ni, ta nducu tuhun ñi chi tahan ñi ti: ―¿Yoo rai cuu rahya, vati sanaan ra cuati ñivi? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ta cati ndico ra Jesuu chi ña ti: ―Cha ni nduvaha anima cun, vati chinu ini cun chihin yu. Na cua cuhun vii cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tacan cuu, ta queta quivi quee iti ra Jesuu. Chahan ra ñuun ta ñuun, ta cati tuhun ra tuhun vaha yoso cuhva cua coo ñivi chi ra Ndioo nu cua cundaca ñahan ra. Chahan tahan ndihi uchi uvi tatun ra, ");
INSERT INTO mioNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ta iyo uvi uni ñi ñahan chahan tahan chi ra Jesuu, vati cha ni sanduvaha ra chi ñi, ta cha tava ra tati cuihna anima ñi. Iin ña nani María Magdalena, ta ucha tati cuihna cha ni tava ra anima ña. ");
INSERT INTO mioNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Inga ña cuu ña Juana ñasihi ra Chuza ra cuu ra ndiso tiñu cuenda ra Herode, ta inga ña nani Susana. Tuvi ñi cuu ñi ni chahan chi ra, ta tindee ñi chi ra chi xuhun ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tacan cuu, ta tuvi ñivi nducuiti nu iyo ra Jesuu. Ndihi ñuun can quichi ñi, ta cahan ra chi ñi. Chi cuhva cahan ra, ta cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Iyo iin rai, ta quee ra cuahan ra, vati cua tachi ra chiti cuhva iyo costumbre ra. Chata cuati ra chiti can, ta iyo chi quehni chi nu yaha iti. Chañu ñivi nuun quehni chi, ta quichi ri saa, ta chachi ri chi chi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Iyo inga chiti can―quehni chi ticu yuu. Cana chi, soco neti ndico chi, vati ña queta nduta nuun chi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Inga chiti can―quehni chi sava mahñu nu iyo iñu. Icaa ni cana chi chi iñu can, ta chasi iñu nuun chi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Inga chiti can―quehni chi nu ñuhun vaha. Cana chi. Chahnu chi, ta cuaha xaan chiti chi chacoo. Tuhun can ni cati ra Jesuu, ta nihin xaan cati ra chi ñi ti: ―Na cua taa vaha ndo soho ndo tuhun ya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tacan cuu, ta nducu tuhun ra sacuaha chi ra ñaan cha cuu cuhva can, ");
INSERT INTO mioNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ta cati ra chi ra ti: ―Chaha ra Ndioo cha cua coto maan ndo tuhun yoso cuhva ndaca ñahan ra Ndioo chi ñivi ra, ta ña chito ñivi ñuñivi tuhun can nu ni quichi quivi. Maan ndo cua coto chacan, soco chi ndihi ca ñivi cahan yu chi cuhva ni. Chacan cuu cha cua cuni soho ñi tuhun can, soco ña cua cutuni ini ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Tuhun ya cuni cati cuhva can, vati tuhun Ndioo cuu chiti can, ");
INSERT INTO mioNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ta chiti quehni nu yaha iti cuu sava ni ta cua ñivi chini tuhun Ndioo, ta quichi run cuihna. Sanaan run tuhun can chi ñi, vati ña cuni run cha cua cuinu ini ñi chi ra Ndioo, ta cua nduvaha anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Chiti quehni ticu yuu can cuu sava ni ta cua ñivi cusii ini cha chini ñi tuhun can. Chinu ini ñi chi chi, soco iyo ñi cuhva iyo itu can, vati ñahni yoho chi iyo. Suhva quivi ni chinu ini ñi, soco queta quivi ña cundee ca ñi cha ndavaha ni, ta saña ndico ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Chiti quehni sava mahñu iñu can cuu sava ni ta cua ñivi chini tuhun Ndioo, ta ña cundee ñi, vati saxini xaan ñi. Cuni ñi cusii ini ñi nu ñuhun ñuñivi, ta cuni ñi cha cua coo tahan xuhun ñi. Chacan iyo ñi, ta ña chahnu ñi cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Chiti quehni nu ñuhun vaha cuu sava ni ta cua ñivi chini vaha tuhun Ndioo. Cuni ñi chi chi chi ndihi cuii anima ñi, ta cundee ini ñi. Tacan chahnu vaha ñi cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Ña tuhva yo taa yo ñuhun, ta casi yo chi chi tichi cajoon. Ña tuhva yo caqui ndaa yo ñuhun xuu chito, soco taa yo ñuhun, ta chaqui ndaa yo chi chi nu candileru, vati tacan ndichin vaha cua ndehe ndihi ñivi quihvi tichi vehe. ");
INSERT INTO mioNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Vitin ña chito ñivi ñaan tuhun cuu tuhun can, soco nu cuahan quivi cua cutuni ini ñi, ta sa cua coto vaha ñi ñaan cha cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Cua taa vaha ndo soho ndo, vati cua coo ca cha chini tuni chi ra cutuni ini tuhun cahin, ta chi ra ña cutuni ini tuhun cahin―ña cua cutuni ini ra ni suhva ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tacan cuu, ta queta sihi ra Jesuu chi yani ra nu iyo ra, soco ña cuu yaha ñi nu iyo ra, vati tuvi xaan ñivi iyo, ");
INSERT INTO mioNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ta cati ñivi can chi ra ti: ―Cha iyo sihi cun chi yani cun nuquehe, ta cuni ñi chihun ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ta cati ndico ra Jesuu chi ñi ti: ―Cua cati yu yoo cuu sihi yu yoo cuu yani yu. Ñivi tasoho tuhun Ndioo, ta sacuinu ñi chi chi―ñican cuu sihi yu chi yani yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Iin quivi quihvi ra Jesuu chi ra sacuaha chi ra tichi tundoo, ta quechaha cati ra chi ra ta ra ti: ―Na coho inga chiyo nduta ya ―cati ra. Tacan cuu, ta quechaha sacunu ra ta ra tundoo can. ");
INSERT INTO mioNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nu quechaha sacunu ra ta ra chi chi, ta quechaha quixi ra Jesuu. Tacan cuu, ta nihin xaan quechaha iyo iin tiati nu nduta can. Chacan cuu cha quechaha chitu nduta tichi tundoo can, ta ica xaan suhva iyo ra ta ra, coto cua ndoyo ñuhun ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chacan cuu cha sandoyo ra ta ra chi ra Jesuu, ta cati ra ta ra ti: ―¡Maestru, cua ndoyo ñuhun yo! ―cati ra. Tacan cuu, ta ndoyo ra Jesuu, ta nduxaan ra chi tati can chi nduta can, ta cutaxin ndico chi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tacan cuu, ta quechaha cati ra chi ra ta ra ti: ―Ñahni cha chinu ini ndo chi ra Ndioo ―cati ra. Iyo xaan cuni ra ta ra, ta yuhvi ra. Nducu tuhun ra ta ra chi tahan ra ti: ―¿Yoo rai cuu rahya? Cha cati tuhun ra chi tati chi nduta, ta tasoho chi chi ra ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tacan cuu, ta queta ra ta ra ñuhun Gadara. Iti nuun ñuhun Galilea iyo chi, vati inga chiyo nduta can iyo ñuhun can. ");
INSERT INTO mioNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Quee ra Jesuu tichi tundoo can, ta tahan ra chi iin rai. Quichi ra iti ñuun can, ta iyo tati cuihna anima ra. Nahan xaan cha iyo run chi ra, ta chica cuiti ndaha ra. Ña ndoo ca ra tichi vehe, soco iyo ra camasandu. ");
INSERT INTO mioNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nu ni ndehe racan chi ra Jesuu, ta quechaha cana chaa ra, ta nduva ihni ra iti nuun ra Jesuu, ta nihin xaan quechaha cati ra ti: ―¿Ñaan cha cuu cha cuni cun chihin yu, ta Jesuu? Yoho―sehe Ndioo cuu cun. Cahan ndahvi yu chihun ti ña cuhva cun tu ndoho chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tacan cati ra, vati cha ni cati ra Jesuu ti cua quee run tati cuihna can anima ra. Cuaha xaan cha ni savaha run chi ra cuaha chaha. Cha cucumi ñivi chi ra, ta cha ni cunuhni ra chi cadena caa, soco chahnda ra chi chi, ta sacuhun run tati cuihna can chi ra tichi cuhu. ");
INSERT INTO mioNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nducu tuhun ra Jesuu chi ra ti: ―¿Ñaan nani cun? ―cati ra. Ta cati ndico ra ti: ―Legioon nani yu. Tacan cati ra, vati cuaha xaan run tati cuihna can cha quihvi anima ra, ");
INSERT INTO mioNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ta quechaha cahan ndahvi run chi ra Jesuu ti ña cua tava ndaa ra chi run, ta cua cuhun run nu iyo ñivi cha ni chihi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tican iyo cuaha ri quini, ta tixitin ri chachi ri iyo ri yucu can. Chacan cuu cha cahan ndahvi run tati cuihna chi ra Jesuu ti cua tava ndaa ra chi run, ta cua quihvi run tichi rican. Tacan cuu, ta chaha ra Jesuu ndatu chi run. ");
INSERT INTO mioNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Quee run anima ra ndahvi can, ta quihvi run tichi ri quini can, ta quechaha chinu ihni ri quini can. Nuun ri xahva can, ta quehni ri tichi nduta can, ta chihi ri. ");
INSERT INTO mioNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ndehe ra cumi chi ri ñaan cha ni tahan ri, ta chinu ra. Ndihi nu yaha ra chaha ra cuenda chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Chacan cuu cha cuahan ñivi tican, vati cuni ndehe ñi ñaan cha cuu cha ni chacoo, ta queta ñi nu iyo ra Jesuu. Tacan cuu, ta ndehe ñi ti ndaa ra ndahvi can. Cha quee run tati cuihna anima ra, ta nami ra. Vaha xaan cuni xini ra, ta ndaa ra nu inda ra Jesuu. Quechaha cuyuhvi xaan ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ñivi ndehe cha ni tahan ra―chaha ñi cuenda yoso cuhva ni nduvaha ra ndahvi can. ");
INSERT INTO mioNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tacan cuu, ta quechaha cahan ndahvi ndihi ñivi quichi nini cahnu ñuhun Gadara can chi ra Jesuu. Cati ñi ti na cua cuhun ra Jesuu inga chiyo, vati cha chaha xaan ra tu ndoho chi ñi, ta yuhvi xaan cuni ñi. Tacan cuu, ta quihvi ndico ra tichi tundoo, ta cha cua cuhun ra, ");
INSERT INTO mioNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ta quechaha chica ndahvi ra ndahvi can chi ra, vati cuni ra cuhun tahan ra chi ra, soco cati ra Jesuu chi ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Cuahan iti vehun, ta cati tuhun cun ndihi cha ni savaha ra Ndioo chihun ―cati ra, ta saña tahan ra chi ra, ta cuahan ra. Tacan cuu, ta cuahan ra nduvaha can. Nini ñuun chahan ra, ta cati tuhun ra ndihi cha ni savaha ra Jesuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tacan cuu, ta queta ndico ra Jesuu inga chiyo nduta can, ta vaha xaan quihin cuenda ñivi chi ra, vati ndihi ñi ndatu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tacan cuu, ta quichi iin ra nani Jairo, ta ra cuu xini iin ve ñuhun cuu ra. Chahnu chiti ra iti nuun ra Jesuu, ta quechaha cahan ndahvi ra chi ra ti na cua cuhun ra Jesuu vehe ra, ");
INSERT INTO mioNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","vati iin tuhun ni ña luhu sehe ra iyo. Uchi uvi cuiya ña, ta cuni cuvi ña. Tacan cuu, ta cuahan ra Jesuu chi ra. Ni vii cuahan ra, ta nihin xaan indi ra tañu ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nu ni yaha ra indi tahan iin ñahan. Cha queta uchi uvi cuiya iyo xaan niñi ña chi ña, ta yoni cuu sanduvaha chi ña. ");
INSERT INTO mioNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tuhva ña iti chata ra, ta sayani ndaha ña yuhu sahma ra. Suvi ni hora can ni chacuita cha iyo niñi ña chi ña. ");
INSERT INTO mioNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tacan cuu, ta quechaha nducu tuhun ra Jesuu ti: ―¿Yoo sayani ndaha chihin yu? ―cati ra. Ndihi ñivi cati ti ñahni, ta cati ra Pedro chi ra ti: ―Maestru, tuvi xaan ñivi iyo, ta nihin xaan indi cun tañu ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ta cati ndico ra Jesuu ti: ―Iyo yoo sayani ndaha chihin yu, vati chite ti cha quee suhva tu ndee ini chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tacan cuu, ta ndehe ña ñahan can ti cha chito ra, ta tuhva ña nu inda ra. Naquisi xaan chi chi ña, ta tuhva ña. Chahnu chiti ña iti nuun ra, ta iti nuun ndihi ñivi can chaha ña cuenda ñacu sayani ndaha ña chi ra, ta chaha ña cuenda ti suvi ni hora can ni nduvaha ña. ");
INSERT INTO mioNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tacan cuu, ta cati ra Jesuu chi ña ti: ―Cha ni nduvahun, vati chinu ini cun, sihi. Na cua cuhun vii cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ni vii cahan ra Jesuu chi ña, ta quichi ñivi iti vehe ra cuu xini ve ñuhun can. Queta ñi, ta quechaha cati ñi chi ra Jairo can ti: ―Cha ni chihi cuii sehun. Ña satañu con chi ra maestru ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Chini ra Jesuu tuhun cahan ñi, ta cati ra chi ra Jairo ti: ―Ña tichaha ni cun. Mani cha cua cuinu ini cun, ta cua nduvaha sehun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tacan cuu, ta queta ra vehe ra Jairo. Quihvi ra, ta quihvi tahan ra Pedro chi ra Juaan chi ra Jacobo chi sutu ña luhu can chi sihi ña. Ñican ni quihvi, soco ña ni chaha ra Jesuu cha cua quihvi ndihi ca ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Cuihya xaan cuni ndihi ñivi can, ta chacu xaan ñi, soco quechaha cati ra Jesuu chi ñi ti: ―Ña cuacu ndo, vati ña ni chihi ña. Quixi ni maan ña ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tacan cuu, ta quechaha chacu nahan ñi chi ra; vati chito ñi ti cha ni chihi cuii ña. ");
INSERT INTO mioNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tacan cuu, ta quihvi ra Jesuu tichi vehe. Tiin ra ndaha ña, ta nihin quechaha cahan ra, ta cati ra chi ña ti: ―Cuinda, lia ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tacan cuu, ta nihin ndico ña tati ña, ta quii xaan ni chacuinda ña, ta cati ra Jesuu ti cua cuhva ñi cha cachi ña. ");
INSERT INTO mioNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iyo xaan cuni sutu ña chi sihi ña, ta cati ra Jesuu ti na ña cua cuhva ñi cuenda ñaan cha ni tahan ña. ");
INSERT INTO mioNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iin quivi cana ra Jesuu chi ndihi uchi uvi ra sacuaha chi ra, ta chaha ra tu ndee ini chi ra ta ra. Chaha ra ndatu chi ra, vati cua tava ra ta ra ndihi run tati cuihna cha ñuhun anima ñivi, ta cua sanduvaha ra ta ra chi ñivi cuhvi. ");
INSERT INTO mioNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tacan cuu, ta tava tiñu ra Jesuu chi ra ta ra, vati cua cati tuhun ra ta ra yoso cuhva cua coo ñivi chi ra Ndioo nu cua cundaca ñahan ra, ta cua sanduvaha ra ta ra chi ñivi cuhvi, ");
INSERT INTO mioNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ta quechaha cati ra chi ra ta ra ti: ―Ñahni cha cua cuiso ndo nu cua cuhun ndo. Ña cuiso ndo garote. Ña cuiso ndo yunu. Ña cuiso ndo cha cua cachi ndo. Ña cuiso ndo xuhun. Ña cuiso ndo. Iin tuhun ni cha ndichin ndo cua cuiso ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ndaa vehe cua quihvi ndo ―suvi ni tican cua coo nuun ndo nda cua nda cua cuhun ndo inga ñuun. ");
INSERT INTO mioNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tu ña cua quihin cuenda ñivi chi ndo, cua quee ndo ñuun can, ta cua naquisi ndo ñuhun iñi chaha ndo. Chacan cuu cha cua coto ñi ti cahan ndo iin cha ndicha ndicha ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tacan cuu, ta quee ra ta ra. Cuahan ra. Ñuun ta ñuun cuahan ra, ta cati tuhun ra tuhun Ndioo, ta ndihi ñuun can sanduvaha ra chi ñivi cuhvi. ");
INSERT INTO mioNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tacan cuu, ta chini ra Herode rey can ndihi tuhun cha ni savaha ra Jesuu. Saxini xaan ra, vati iyo ñivi cati ñi ti cha ni natacu ndico ra Juaan tañu ñivi ndii. ");
INSERT INTO mioNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Inga ñivi cati ti ra Elía chahnu cuu ra ni quichi, ta inga ñi cati ti iin ra ni cahan cuenda ra Ndioo tiempu chahnu cuu ra ni quichi. ");
INSERT INTO mioNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Chacan cuu cha cati ra Herode ti: ―Ni chahnda yu sucun ra Juaan, ta chihi ra. Ña chite yoo rai cahan ñi tuhun can ―cati ra. Chacan cuu cha nducu ra cuhva cha cua ndehe ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tacan cuu, ta queta quivi quichi ndico ra tatun Jesuu, ta chaha ra ta ra cuenda chi ra ndihi cha ni savaha ra ta ra nu ni chahan ra. Tacan cuu, ta quihin ra Jesuu chi ra ta ra, ta quee siin ra ta ra. Cuahan ra iti ñuun Betsaida, ");
INSERT INTO mioNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","soco chito ñivi ndaa iti cuahan ra, ta chandicu ñi chi ra. Tacan cuu, ta quihin cuenda ra Jesuu chi ñi, ta cahan ra chi ñi yoso cuhva cua coo ñivi chi ra Ndioo nu cua cundaca ñahan ra, ta sanduvaha ra chi ñivi cuhvi. ");
INSERT INTO mioNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tacan cuu, ta cha cua ini xaan. Chacan cuu cha quichi cahan ra tatun ra chi ra Jesuu, ta cati ra ta ra ti: ―Na cua saña tahan yo chi ñivi ya, ta na cua cuhun ñi ranchu iyo yatin. Na cua cuhun ñi iti ñuun, ta cua nanducu ñi nu cua cusu ñi. Cua nanducu ñi cha cua cachi ñi. Tacan sa cua nanihin ñi, vati ñahni cha iyo ihya ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cuhva maan ndo cha cua cachi ñi ―cati ra. Ta cati ndico ra ta ra ti: ―Ñahni cha iyo chi ndi. Uhun tahan paan chi uvi tiaca ni iyo. Tu ña cua cuhun ndi cu sata ndi cha cua cachi ndihi ñihya, ña cua queta chacan. ");
INSERT INTO mioNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tacan cati ra ta ra, vati uhun tahan mil rai cuu ra iyo, soco cati ndico ra Jesuu chi ra ta ra ti: ―Cati ndo chi ra ti na cua cunda nuun ra. Uvi xico uchi uvi xico uchi ra ta ra cua cunda iin iin nu cua cunda ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tacan ni savaha ra sacuaha chi ra Jesuu, ta ni chacunda ndihi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tacan cuu, ta quihin ra Jesuu paan can chi tiaca can. Uhun paan cuu chi chi uvi tahan tiaca. Quihin ra chi chi, ta ndehe ndaa ra iti siqui andivi, ta chaha ra iin tiahvi ndioo chi ra Ndioo. Chahnda cuati ra chi chi, ta chaha ra chi chi chi ra sacuaha chi ra, vati cua cuhva ra ta ra chi chi chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tacan cuu, ta chachi ñi ta ñi, ta ndihi ñi ndaha ini. Tacan cuu, ta canihin ra ta ra cha ni ndoo, ta queta uchi uvi tica chehle cuati canihin ndico ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Iin quivi quee siin ra Jesuu, vati cua cahan ra chi ra Ndioo, ta iyo tahan ra sacuaha chi ra. Cha ndihi cahan ra Jesuu chi ra Ndioo, ta quechaha nducu tuhun ra chi ra sacuaha chi ra ti: ―¿Yoo rai cui cati ñivi? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ta cati ndico ra ta ra ti: ―Iyo ñivi cati ti ra Juaan ra sacunduta cuun. Iyo inga ñivi―cati ñi ti Elía cuun, ta iyo inga ñi cati ti cha ni nandoto ndico iin ra ni cahan cuenda ra Ndioo tiempu chahnu, ta racan cuun ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tacan cuu, ta nducu tuhun ra Jesuu chi ra ta ra ti: ―Ta maan ndo, ¿yoo rai cui cati ndo? ―cati ra. Ta cati ndico ra Pedro ti: ―Yoho―ra Cristo cuun, vati ni tava tiñu ra Ndioo chihun ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tacan cuu, ta cati tuhun xaan ra Jesuu chi ra sacuaha chi ra ti ña cua cati ra tuhun can chi ni iin ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tacan, ta quechaha cati ra ti: ―Yuhu ra cuu sehe ñivi―iyo cha cua ndehe xain tu ndoho. Ndihi ra chanihin chi ra sutu chahnu chi ra sacuaha ley chahnu―ndihi racan cua tava ndaa ra chihin yu. Cua cahni ra ta ra chihin yu, soco cua yaha uni quivi, ta cua natacu ndico yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Inga hora, ta cati ndico tucu ra Jesuu chi ndihi ñivi can ti: ―Tu iyo ndo cuni ndo coo ndo chihin yu, na ña cua saxini ndo cuenda maan ndo. Na cua ndehe ndo tu ndoho cuenda yu ndihi ni quivi cuhva ndehe ñivi tu ndoho nu cruu. ");
INSERT INTO mioNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tu cua cuni ndo coo vaha ndo cuenda maan ndo, cua ndoyo ñuhun ndo, soco tu cua cuvi ndo cuenda yuhu, ña cua ndoyo ñuhun ndo cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ñahni yavi ndaa ndo cha cua sacanaan ndo ndihi cha iyo nu ñuhun ñuñivi ya, tu cua ndoyo ñuhun cuii ndo cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tu cua cucahan nuun ndo cuenda yu, tu cua cucahan nuun ndo tuhun cati tuhin, cua cucahan tahan nuin chi maan ndo quivi cua quichi ndico yu ra cuu sehe ñivi. Taqui xaan cua cuu nu cua quichi yu, vati cua quichi yu cuenda ra suti chi ra cuu tatun Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cati ndicha yu chihin ndo ti iyo ndo inda ihya―ña cua cuvi ndo nda cua nda cua ndehe ndo yoso cuhva cua cundaca ñahan ra Ndioo ―cati ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yaha una quivi nu ni cahan ra Jesuu tuhun can, ta quihin ra chi ra Pedro chi ra Juaan chi ra Jacobo, ta cuahan ra ta ra iin siqui yucu, vati cua cahan ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nu ni cahan ra Jesuu chi ra Ndioo, ta tucu cuhva sananduvi ra Ndioo chi ra. Tucu cuhva caa nuun ra Jesuu hora can, ta nda cua tachan sahma ra cuu, ta cuichin xaan chi, ");
INSERT INTO mioNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ta ni chacoo uvi rai chi ra. Ra Moisee chi ra Elía cuu ra, ta ndatuhun ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Taqui xaan nu chacuinda ra Moisee chi ra Elía can, ta ndatuhun ra ta ra chi ra Jesuu yoso cuhva cua cuvi ra iti ñuun Jerusalén nu cuahan quivi. ");
INSERT INTO mioNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Vee xaan cuni ra Pedro chi tahan ra, vati cuni xaan chi cusu ra ta ra, soco cundee ra ta ra, ta ndehe ra ta ra ti ndichin xaan ra Jesuu cuu. Ndehe ra ta ra ti ndatuhun uvi rai chi ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ta sa cuahan ndico ra Moisee chi ra Elía nu iyo ra Jesuu, ta quechaha cati ra Pedro chi ra Jesuu ti: ―Vaha xaan cha quichi tahan ndi ihya, maestru. Na cua savaha ndi uni tiahva. Iin chi cua cuu chi maun, ta inga chi cua cuu chi ra Moisee, ta cua cuu inga chi chi ra Elía ―cati ra, soco cahan soho ra, vati ña chito ra ñaan cha cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ni vii cahan ra Pedro can, ta quichi iin vico. Chasi chi nuun ra ta ra, ta yuhvi cuni ra ta ra cha chasi vico can nuun ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tacan cuu, ta quechaha cahan ra Ndioo tichi vico can, ta cati ra ti: ―Sehi chi rahya, ta cuni xain chi ra. Cua tasoho ndo cha cua cahan ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Cha ndihi cahan ra Ndioo tuhun can, ta ndehe ra ta ra ti iin tuhun ni ra Jesuu ni ndoo. Tacan cuu, ta taxin ni chacoo ra ta ra. Quivi can ña chaha ra ta ra cuenda chi ni iin ñivi ñaan cha cuu cha ni ndehe ra tican. ");
INSERT INTO mioNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tuvi inga quivi, ta nuun ndico ra ta ra siqui yucu can. Nuun ra, ta tuvi ñivi ni nihin tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tacan cuu, ta cana chaa iin rai nda mahñu ñivi can, ta cati ra chi ra Jesuu ti: ―Yoho maestru, na cua savahun tu manini cua ndehun sehi, vati iin tuhun ni ra iyo, ");
INSERT INTO mioNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ta ñuhun tati cuihna anima ra. Quii xaan cana chaa ra savaha run, ta chahni rai run chi ra, ta quee iñu yuhu ra. Sanicuehe run chi ra, ta cuaha tu ndoho chaha run chi ra, ta ña ta quee run. ");
INSERT INTO mioNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Cha cahin chi ra sacuaha chihun ti na cua tava ra chi run, soco ña cuu chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ta cati ndico ra Jesuu chi racan ti: ―Ndioho, ña chinu ini ndo chi ra Ndioo. Mani ndavaha ni ndacu ndo. Ña cundee ca ini yu chi ndo. Ña nahan cua coi chi ndo. Na ndaca sehe cun ihya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tacan cuu, ta ni vii cua tuhva ra luhu can, ta sanduva run tati cuihna chi ra, ta chahni rai run chi ra. Tacan, ta quechaha nduxaan ra Jesuu chi run tati cuihna can, ta sanduvaha ra chi ra luhu, ta chaha cuenda ndico ra chi ra chi sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iyo xaan cuni ndihi ñivi can, vati cahnu xaan cuu ra Ndioo. Ni vii nduiyo ndihi ñivi can, vati cuaha xaan cha ni savaha ra Jesuu, ta quechaha cati ra chi ra sacuaha chi ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Cua taa vaha ndo soho ndo tuhun ya. Yatin xaan cua xico tuhun ñivi chihin ra cuu sehe ñivi, ta cua tiin ñi chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ña nituni ini ra ta ra tuhun can, vati ña chaha ra Ndioo. Chacan cuu cha ña nituni ini ra, ta yuhvi ra ta ra nducu tuhun ra chi ra Jesuu ñaan cha cuu tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tacan cuu, ta quechaha cahan yuhu ra sacuaha chi ra Jesuu. Cahan yuhu ra chi tahan ra, vati saxini xaan ra ndaa ra cua cuu iin rai cahnu ca. ");
INSERT INTO mioNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tacan, ta sa chito ra Jesuu yoso cuhva saxini ra ta ra chi anima ra. Chacan cuu cha quihin cuenda ra chi iin ve luhu, ta ni chacuinda ve iin chiyo xiin ra savaha ra, ");
INSERT INTO mioNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ta quechaha cati ra chi ra ta ra ti: ―Tu cua quihin cuenda ndo chi ñivi cuu sava ni ta cua vehya cuenda yu, cua quihin cuenda ndo chihin yu. Tu cua quihin cuenda ndo chi yuhu, cua quihin cuenda tahan ndo chi ra Ndioo, ta maan ra tava tiñu chihin yu. Ta chi maan ndo cati yu ti ra cuu rai cahnu ca cua tindee chi ndihi ñivi tahan ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tacan cuu, ta quechaha cati ra Juaan chi ra ti: ―Ni ndehe ndi chi iin rai, ta cahan ra sivi cun, ta tava ra tati cuihna anima ñivi, soco ña chaha ndi cha cua savaha ca ra chacan, vati ña chica ra chihun sava ta cuhva cha chica maan ndi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ta cati ndico ra Jesuu chi ra ti: ―Ña cua casi con nuun ñivi ndacu tacan, vati tu ña cua cani tahan ñivi chi yo, cua coo ñi cuenda yo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tacan cuu, ta chito ra Jesuu ti ña cuaha ca quivi, ta cua ndaa ra iti siqui andivi. Chacan cuu cha cati ra chi anima ra ti nini xaan cua cuhun ra iti ñuun Jerusalén, ");
INSERT INTO mioNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ta tachi ra tatun ra iti nuun. Cuahan ra tatun can iti ñuhun Samaria, ta quihvi ra iin ñuun, vati cua nducu ra ndaa cua cachi ra Jesuu ndaa cua cusu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tacan ni savaha ra tatun can, soco ña ni quihin cuenda ñivi can chi ra Jesuu, vati cha cuahan ra iti ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ndehe ra Jacobo chi ra Juaan yoso cuhva cati ñivi can, ta quechaha cati ra ta ra chi ra Jesuu ti: ―Ra chahnu, ¿atu cuni cun cha cua cahan ndi chi ra Ndioo ti na cua saquehni ra ñuhun cha cua cayu ñihya, ta cua ndoyo ñuhun ñi cuhva ni savaha ra Elía iti chata? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tacan cuu, ta ndico coo ra Jesuu nuun ra ta ra, ta nduxaan ra chi ra, ta cati ra ti: ―Ña chito ndo ñaan tiñu chica ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yuhu ra cuu sehe ñivi―quichi yu, vati cuni yu sanduvahi anima ñivi. Ña cuni yu cha cua ndoyo ñuhun ñi ―cati ra. Tacan cuu, ta cuahan ra ta ra inga ñuun. ");
INSERT INTO mioNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ni vii cuahan ra ta ra iti, ta quechaha cati iin rai chi ra Jesuu ti: ―Yoho ra chahnu, cuni cuhin chihun ndaa iti cua cuhun cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ta cati ndico ra Jesuu chi ra ti: ―Iyo nu quixi ri ñucuii, ta iyo taca ri saa, soco ñahni nu cua cava cusu yu, ta ra cuu sehe ñivi cui ―cati ra chi racan. ");
INSERT INTO mioNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Chi inga ra cati ra Jesuu ti: ―Na coho ―cati ra, soco cati ndico racan chi ra ti: ―Ra chahnu, cuhva cha cua cuhun xihne, ta cua cuchi yu chi suti ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ta cati ndico ra Jesuu chi ra ti: ―Na cua cuchi ñivi tahan ndo chi ra, soco yoho―cuahan, ta cati tuhun cun yoso cuhva cua coo ñivi chi ra Ndioo nu cua cundaca ñahan ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tacan cuu, ta cati inga ra chi ra Jesuu ti: ―Cua cuhin chihun, ra chahnu, soco cuhva cun cha cua saña tahan xihne chi ñivi yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ta cati ndico ra Jesuu chi ra ti: ―Tu cua quechaha satiñu ndo tiñu ra Ndioo, soco tu ña cua satiñu ndo chi ndihi cuii anima ndo, ña cua cuu coo ndo nu cua cundaca ñahan ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tacan cuu, ta chaha ra Jesuu tiñu chi inga uni xico uchi ra ta ra, ta tava tiñu ra chi ra ta ra. Uvi uvi ra tava tiñu ra, ta cuahan ra ta ra iti nuun. Ndihi ñuun nu cua yaha ra Jesuu cuahan ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ni vii iyo ra ta ra chi ra Jesuu, ta cati ra chi ra ta ra ti: ―Cuaha xaan tiñu iyo, soco ñahni ñivi cua satiñu. Na cua cahan ndahvi ndo chi ra chahnu Ndioo ti cua tava tiñu ra chi ñivi cua satiñu tiñu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Vitin cuahan ndo. Tava tiñu yu chihin ndo, ta cuahan ndo nu cua coo ndo chi tu ndoho. Cuhva iyo ri chivu cuati cua coo ndo, vati chaha ri ina tu ndoho chi ri. Cuhva can cua coo ndo chi tu ndoho. ");
INSERT INTO mioNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ña cua cuiso ndo xuhun. Ña cua cuiso ndo yunu. Ña cua cunda chaha ndo. Ña cua nducuee ndo ndatuhun ndo chi ñivi tahan ndo iti. ");
INSERT INTO mioNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ndaa vehe cua coo nuun ndo cua cati xihna ndo chi ñivi can ti na cua coo vii ñi vehe ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tu ndicha ti iyo vii ñivi can, cua coo vii ñi cuhva cua cati ndo, soco ña cua coo vii ñi, tu ñavi tacan iyo ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Vehe can nu iyo vii ñivi cua ndoo nuun ndo, ta cua cachi tahan ndo chi ñican, vati iyo yahvi ndihi ñivi satiñu. Ña cua nducu ndo nu cua coo ndo vehe ta vehe. ");
INSERT INTO mioNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tu cua quihin cuenda ñivi chi ndo ñuun nu cua quihvi ndo, cua cachi ndo ñaan cha cuu cha cua cuhva ñi chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Cua sanduvaha ndo chi ñivi cuhvi, ta cua cati tuhun ndo chi ñivi can ti yatin xaan cua cundaca ñahan ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tu ña cua quihin cuenda ñivi chi ndo ñuun nu cua quihvi ndo, cua yaha ndo iti cahnu ñuun can, ta cua cati ndo chi ñi ti ");
INSERT INTO mioNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","nacuhva ndo yuhma ñuhun ñuun ñi chaha ndo. Chacan cuu cha cua coto vaha ñi ti ña vaha cha ndacu ñi, soco na cua coto ñi yoso cuhva cua coo ñivi chi ra Ndioo nu cua cundaca ñahan ra, cua cati ndo chi ñican. ");
INSERT INTO mioNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yuhu cati ti quivi cua tachi tuni ra Ndioo chi ñivi xaan xaan cua cutuni ñivi ni chacoo ñuun Sodoma iti chata, soco xaan ca cua cutuni ñivi ña cua quihin cuenda chi ndo vitin ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ni vii cahan ra Jesuu chi ñi cuenda ñivi ña tasoho: ’Ndioho ñivi ñuun Corazín, ndioho ñivi ñuun Betsaida, cahnu xaan tu ndoho cua coo chi ndo, vati cahnu xaan cuhva cuu cha ni savahi iti nuun ndo. Tu cua savahi cuhva can iti nuun ñivi iyo ñuun Tiro, tu cua savahi cuhva ni savahi iti nuun ndo iti nuun ñivi ñuun Sidón, ta cahnu xaan cuati cuu cha ni savaha ñi, ndicha ndicha cua saña ihni ñi ndihi cuati can. ");
INSERT INTO mioNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Cahnu xaan tu ndoho cua coo chi ñivi ñuun can nu cua tachi tuni ra Ndioo chi ñivi, soco cahnu xaan ca tu ndoho cua coo chi maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ta ndioho ñivi ñuun Capernaum, ña cua coo ndo iti siqui andivi. Cua coo ndo nu iyo ñivi ndoyo ñuhun, vati cua tachi tuni ra Ndioo chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Tu cua tasoho ñivi chi maan ndo, cua tasoho tahan ñi chihin yu. Tu cua tava ndaa ñi chi ndo, cua tava ndaa tahan ñi chi yuhu. Tu cua tava ndaa ñi chihin yu, cua tava ndaa tahan ñi chi ra Ndioo, vati maan ra cuu ra tava tiñu chihin yu. Tacan ni cati ra Jesuu chi ra ta ra, ta cuahan ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Quichi ndico ndihi uni xico uchi ra ta ra nu ni chahan ra, ta sii xaan cuni ra ta ra. Cati ra ta ra chi ra Jesuu ti: ―Ra chahnu, cha ni cahan ndi chi run tati cuihna cuenda sivi cun, ta ni tasoho run cha ni cahan ndi ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ta cati ra Jesuu chi ra ta ra ti: ―Ndicha ti ni ndehi ti cha ni quehni run Satanaa iti siqui andivi cuhva quehni iin tachan, vati cha cuahan ndoyo ñuhun run. ");
INSERT INTO mioNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Cha chahi tu ndee ini chi ndo, vati cua cuu cuañu ndo chata ri coo, cua cuu cuañu ndo chata ri tisuhma, ta ña cua cundee run Satanaa cuxaan ini run chi ndo. Ñahni cha cua cuu sandoyo ñuhun run chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ña cua cusii ini ndo cha tasoho run tati cuihna cha cahan ndo chi run, soco cua cusii ini ndo, vati cha iyo sivi ndo nu tutu ra Ndioo iti siqui andivi, vati cua coo ndo chi ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Suvi ni hora can sii xaan quechaha cuni ra Jesuu savaha ra Tati Ndioo. Tacan cuu, ta quechaha cati ra Jesuu ti: ―Yoho tata, maun cuu ra ndaca ñahan iti siqui andivi, ta maun cuu ra ndaca ñahan nu ñuhun ñuñivi ya. Sacahnu yu chihun, vati ña chahun cuenda chi ñivi nditi chi ñivi cutuni ini yoso cuhva cua coo ñivi chihun nu cua cundaca ñahan cun, soco chi ñivi ndahvi ya cha sacoto cun chacan. Chacan ni savahun, vati cuhva cuni cun cuu chi, tata. ");
INSERT INTO mioNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Cha ni chaha suti ndihi tu ndee ini chihin yu. Yoni ñivi chito yoso cuhva iyo ra cuu sehe Ndioo. Iin tuhun ni ra Ndioo chito chacan, ta yoni ñivi chito yoso cuhva iyo ra Ndioo. Iin tuhun ni ra cuu sehe ra chito, ta ndaa ñivi cuni ra sacoto ra―ñican cua coto tahan ñi yoso cuhva iyo ra Ndioo sutu yu ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tacan cuu, ta ndehe ra Jesuu chi ra sacuaha chi ra, ta cahan siin ra chi ra ta ra, ta cati ra ti: ―Cua cusii ini ndo cuenda cha ni ndehe ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Chahi cuenda chi ndo ti tuvi xaan ra ni cahan cuenda ra Ndioo nu quichi quivi, tuvi xaan ra ni chacundaca ñahan cuenda ra Ndioo iti chata―cuni ra ndehe ra cha ni ndehe maan ndo, soco ña ni cundee ndehe ra. Cuni xaan ra ta ra cuni ra tuhun chini maan ndo, soco ña cundee ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tacan cuu, ta queta iin ra sacuaha ley chahnu, vati cuni coto ra a ña cua cahan ra Jesuu iin cha ndavaha ni. Chacan cuu cha quechaha nducu tuhun ra chi ra Jesuu ti: ―Maestru, ¿ñaan cha cuu cha cua savahi, ta cua coo ndito yu chi ra Ndioo ndihi ni quivi ndihi ni tiempu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ta cati ndico ra Jesuu chi ra ti: ―¿Ñaan cha cuu cha cati ley chahnu? ¿Ñaan cha cuu cha cati chi cuni maun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tacan cuu, ta cati ndico ra sacuaha ley can ti: ―Cati chi ti cua cuni yo chi ra chahnu Ndioo chi ndihi cuii anima yo chi ndihi cuii cha chini tuni chi yo, ta cua cuni yo chi ndihi ñivi tahan yo cuhva cuni yo suvi ni chi maan yo, cati chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tacan cuu, ta cati ra Jesuu chi ra ti: ―Vaha xaan cuhva cahun. Tu cua savahun cuhva ni cati cun, cua coo ndito cun chi ra Ndioo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ta ra sacuaha ley can―cuni ra cha cua saxini ra Jesuu ti nducu tuhun vaha ra chi ra. Chacan cuu cha nducu tuhun ndico ra chi ra Jesuu ti: ―¿Yoo cuu ñivi tahan yu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tacan cuu, ta cati ndico ra Jesuu chi ra ti: ―Iyo iin rai judío, ta quee ra ñuun Jerusalén, ta cuahan ra iti ñuun Jericó. Tacan cuu, ta tiin run ñasuhu chi ra. Quenda run sahma ra, ta cani run chi ra, ta cuahan run. Nacoo run chi ra, ta cuni cuvi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Suvi ni hora can yaha iin ra sutu iti can. Ndehe ra nu caa ra ndahvi can, ta yaha ra inga chiyo iti can. ");
INSERT INTO mioNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ta ni cuhva quichi iin ra satiñu ve ñuhun. Ndehe ra nu caa ra ndahvi can, ta yaha ra inga chiyo iti can. ");
INSERT INTO mioNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tacan cuu, ta quichi tahan iin ra ñuhun Samaria, ta xaan cuni ra ndehe ra chi ñivi judío cuhva iyo costumbre ñivi ra. Queta ra nu caa ra ndahvi can, ta ndehe ra chi ra, ta uhvi xaan cuni ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chacan cuu cha tuhva ra nu caa ra, ta savaha ra rimeri chi aceite chi vinu. Choso ra chi chi, ta chuhni ra nu nicuehe ra. Tacan cuu, ta tindee ra chi ra ndahvi can. Tiso ra chi ra siqui sana ra, ta ni chandaca ra chi ra nu cua coo nuun ra, ta tindee ra chi ra suhva ca. ");
INSERT INTO mioNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tuvi inga quivi, ta chaha ra uvi xuhun denario chi ra iyo vehe can, ta cati ra chi ra ti na cua tindee ra chi ra. Tu cua sanaan ca ra xuhun ra cha cumi ra chi ra, cua tiahvi ndico ra nda quivi cua yaha ndico ra, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Vitin cua cati maun. ¿Ndaa ra cuu ra cuu ñivi tahan ra ni ndoyo ñuhun savaha ñasuhu? ―cati ra Jesuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ta cati ndico ra sacuaha ley can ti: ―Ra ni cundahvi ini chi ra―racan cuu ra cuu ñivi tahan ra ―cati ra. Ta cati ra Jesuu ti: ―Cuahan vitin, ta na cua savaha maun cuhva ni savaha racan ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tacan cuu, ta cuahan ra Jesuu chi ra sacuaha chi ra iti, ta queta ra ta ra iin ñuun. Tacan cuu, ta quihin cuenda iin ña nani Marta chi ra Jesuu vehe ña. ");
INSERT INTO mioNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Iyo tahan iin cuhvi ña nani María, ta mani cha cunda nuun ña nu iyo ra chahnu Jesuu cuni ña, ta tasoho ña tuhun cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Saxini xaan ña Marta can yoso cua savaha ña, ta cua sacachi ña chi ra. Chacan cuu cha tuhva ña nu ndaa ra, ta quechaha cati ña chi ra ti: ―Ra chahnu, ¿ñacu ña tichaha ni cun cha ni nacoo ihni ña cuhvi yu chihin yu, ta mani yu cua tiso vaha cha cua cachi ndo? Cua cati cun chi ña ti na cua tindee tahan ña chihin yu ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ta cati ndico ra chi ña ti: ―Cuaha xaan saxini cun, Marta. Cuaha xaan chica xini cun. ");
INSERT INTO mioNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Iyo iin cha cumani cun. Ndacu ña María iin cha vaha xaan, vati tasoho ña cha cahan yu, ta ña cua naan chi chi ña ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Iin quivi iyo ra Jesuu iin nu cahan ra chi ra Ndioo. Nu ni ndihi cahan ra chi ra Ndioo, ta quechaha cati iin ra sacuaha chi ra ti: ―Ra chahnu, sanahun chi ndi yoso cuhva cua cahan ndi chi ra Ndioo cuhva ni sanahan ra Juaan chi ra chica chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Nu cua cahan ndo chi ra Ndioo, ta cua cati ndo tehen: Sutu ndi iyo iti siqui andivi, na cua sacahnu ndihi ñivi chihun. Na cua queta quivi cua cundaca ñahan cun ihya nu ñuhun ñuñivi ya. Na cua savaha cun cuhva cuni cun ihya cuhva ndacu cun iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Na cua cuhva cun cha cua cachi ndi vitin quivi ya. ");
INSERT INTO mioNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Na cua cucahnu ini cun cuati ndacu ndi, vati cucahnu ini ndi ndihi cha ndacu ñivi chi ndi. Na ña cua cundaca cun chi ndi nu cua savaha ndi ndavaha ni. Tacan ni cua cahan ndo chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Iyo amigu ndo chi ndo. Tu cua cuhun ndo vehe ra sava ñuun, ta cua cati ndo chi ra ti: “Amigu, na cuhva nuun cun uni paan chihin yu, ");
INSERT INTO mioNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","vati cha ni queta iin amigu yu vehi. Cani xaan quichi ra, ta ñahni cha cua cuhva ndi cachi ra,” cua cati ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tu tacan cua savaha ndo, ta cua cati ndico ra tichi vehe ra ti: “Ña cahun chihin yu vitin. Cha ndasi yu vehi, ta cha caa ndi chi sehe cuati ndi. Ña cuu ndoye, ta cuhve chi chi chihun vitin,” cua cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Cati yu chi ndo ti vasi ña cua cuhva ra ti cha amigu, soco tu ña cua saña ndo cha cahan ndahvi ndo chi ra, cua ndoyo ra, ta cua cuhva ra ndihi cha chini ñuhun ndo, vati ña cua cundee ca ini ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Chacan cuu cha cati yu chi ndo ti na cua ndaca ndo cha chini ñuhun ndo chi ra Ndioo, ta cua cuhva ra chi chi chi ndo, ");
INSERT INTO mioNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","vati chaha ra cha chica ndihi ñivi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Yoni ndo cua cuhva ndo iin ri coo chi sehe ndo, tu cua ndaca ve tiaca. ");
INSERT INTO mioNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tu cua ndaca ve ndivi tiñuun, ña cua cuhva ndo iin tisuhma chi ve. ");
INSERT INTO mioNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ñivi ñuñivi cuu maan ndo, ta chito ndo yoso cuhva cua cuhva ndo cha vaha chi sehe ndo. Vaha xaan ca chito ra sutu ndo iti siqui andivi yoso cuhva cua samani ra chi ndo. Cua cuhva ra cha cua quichi ra Tati Ndioo chi ndihi ñivi cua ndaca chi ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iin quivi ni tava ra Jesuu tati cuihna ñuhun anima iin rai, ta ñihin ra rai can savaha run. Ni quee run anima ra, ta quechaha cahan ra, ta iyo xaan cuni ndihi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Iyo ñivi cati ti: ―Iyo run Beelzebú run cuu xini chi run tati cuihna chi ra Jesuu. Chacan cuu cha cuu tava ra chi run ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Inga ñi―cuni ñi cha cua savaha ra iin cha cahnu cuenda ra Ndioo iti siqui andivi, vati cuni ñi coto ñi a vaha ra Jesuu a ña vaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Chito ra yoso saxini ñi ta ñi, ta quechaha cati ra chi ñi ti: ―Tu cua cani tahan ñivi iyo iin ñuun chi tahan ñi, cua ndoyo ñuhun ñivi ñuun can. Tu cua cani tahan ñivi iyo iin vehe chi tahan ñi, cua ndoyo ñuhun ñivi vehe can. ");
INSERT INTO mioNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tu cua cani tahan ñivi run Satanaa suvi ni chi maan run, cua ndoyo ñuhun tahan nu ndaca ñahan run. Tacan cati yu, vati cati maan ndo ti iyo run Beelzebú chihin yu, ta tave chi run tati cuihna. ");
INSERT INTO mioNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Cati ndo ti cuu tave chi run tati cuihna can, vati iyo run Beelzebú chihin yu. Vasi saxini ndo ti tacan ni tava ñivi maan ndo chi run. Chacan cuu cha cua cati suvi ni ñivi maan ndo ti ña vaha saxini ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tava main chi run tati cuihna can, vati chaha ra Ndioo tu ndee ini chihin yu. Chacan cuu cha cua coto ndo ti ndaca ñahan ra Ndioo ihya nu ñuhun ñuñivi ya. ");
INSERT INTO mioNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Iyo iin rai. Nihin xaan ra, ta ndiso ra cha xaan. Tu cua cumi vaha ra vehe ra, ñahni cha cua tahan chachi ra, ");
INSERT INTO mioNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","soco tu cua quichi inga ra, ta nihin ca racan, ta cua cani tahan ra chi ra iyo vehe ra, cua sandoyo ñuhun ra chi ra, vati maan ra nihin ca ra. Cua quihin ra ndihi cha xaan cha iyo chi racan, ta chinu ini ra ti cha cua cundee ra chi chacan. Cua natahvi ra ndihi ndatiñu racan. Tacan cati ra Jesuu cuenda run Satanaa, vati cha ni sacanaan ra chi run. ");
INSERT INTO mioNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Tu ña cua coo ndo chihin yu, cua cani tahan ndo chihin yu. Tu ña cua cahan ndo chi ñivi cuenda yu, cua sandoyo ñuhun ndo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ni vii cahan ra Jesuu iin cuhva cuenda run Satanaa: ’Tu cua quee ndaa run tati cuihna anima ñivi, cua cuhun run tichi cuhu nu ñahni nduta. Cua nanducu run nu cua coo taxin run, soco ña cua nanihin run. Tacan, ta cua saxini run ti cua cuhun ndico run nu ni quee run. ");
INSERT INTO mioNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Chacan cuu cha cua cuhun ndico run, ta cua ndehe run ti vaha xaan iyo ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chacan cuu cha cua cuhun run, ta cua quichi ndaca run inga ucha run tati cuihna, ta xaan ca rucan. Cua quihvi run ta run anima ñican, ta nihin xaan ca cua coo tu ndoho chi ñi. Tacan cati ra Jesuu, vati tacan ni cua cuhva run Satanaa tu ndoho chi ñivi, tu ña cua coo ñi chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ni vii cahan ra Jesuu tuhun can, ta quechaha cahan iin ñahan nda mahñu ñivi can, ta cati ña ti: ―¡Na cua cusii ini ña ñahan cuu sihi cun! ―cati ña, vati vaha xaan cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ta cati ndico ra Jesuu ti: ―¡Na cua cusii ca ini ñivi tasoho tuhun Ndioo, ta sacuinu ñi cuhva cati chi! ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tacan cuu, ta tuvi ca ñivi ni nducuiti, ta quechaha cati ra Jesuu chi ñi ti: ―Ña vaha ñivi cuu ndo. Ña cuni ndo cuinu ini ndo chihin yu, tu ña cua savahi iin cuhva cahnu cuenda ra Ndioo. Ñahni ca cha cua savahi chi ndo. Cuhva ni savaha ra Jonaa nu ni quichi quivi―cuhva can ni iyo chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Cuhva cati tuhun ra Jonaa chi ñivi ñuun Nínive―tacan ni cati tuhun tucu yuhu ra cuu sehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Iti nuun ra Ndioo cua queta iin ñahan ni chacundaca ñahan chi ñivi iyo iti xuu nu ni quichi quivi. Nu cua tachi tuni ra Ndioo chi ñivi cua queta ña chi maan ndo, ta cua cati tuhun tahan ña ti ña vaha ndacu ndo, vati cani xaan quichi ña, ta tasoho ña tuhun cahan ra Salomón, vati cuaha xaan cha chini tuni chacoo chi ra, soco vitin iyo iin rai cahnu ca, ta iyo ca cha chini tuni chi ra, ta ña saña ihni ndo cuati ndacu ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ta ni cuhva cua queta tahan ra rai ni chacoo ñuun Nínive chi ndo nu cua tachi tuni ra Ndioo chi ñivi, ta cua cati tuhun tahan ra ti ña vaha ndacu ndo, vati saña ihni ra cuati ni savaha ra nu ni cati tuhun ra Jonaa tuhun Ndioo iti chata, ta vitin iyo iin rai cahnu ca, ta cati tuhun ra chi ndo, soco ña saña ihni ndo cuati ndacu ndo. Tacan cati ra Jesuu suvi ni cuenda maan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ni vii cahan ra Jesuu chi ñivi can: ’Yoni cua taa ñuhun, ta cua tixehe ñi chi chi. Yoni cua taa ñuhun, ta cua tihi ñi chi chi tichi máquila. Tu cua taa yo ñuhun, cua tiso yo chi chi nu candileru. Chacan cuu cha ndichin vaha cua ndehe ñivi quihvi tichi vehe yo. ");
INSERT INTO mioNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Titi nuun yo cuu sava ni ta cua iin ñuhun iyo chi yo. Tu vaha iyo titi nuun yo, ndichin vaha cua ndehe yo. Tu ña vaha cuni titi nuun yo, ña ndichin cua ndehe yo. ");
INSERT INTO mioNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chacan cuu cha na cua saha ndo cuenda, coto ña ndichin vaha cua ndehe ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tu ndichin vaha cua ndehe ndo, ta ñahni cha cua ndoyo ñuhun nuun ndo, vaha cua ndehe ndo cuhva ndehe vaha ndo nu cayu ñuhun. Tacan ni cati ra Jesuu, vati tu cua cutuni vaha ini ñi yoso cuhva iyo ra Ndioo, cua coo vaha ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cha ndihi cahan ra Jesuu, ta cati iin ra fariseo ti na cu cachi ra chi ra vehe ra. Chacan cuu cha cuahan ra Jesuu. Quihvi ra, ta ni chacunda ra yu mesa. ");
INSERT INTO mioNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ndehe ra fariseo can ti ña tuhva ra Jesuu nacata xihna ra ndaha ra, ta sa cua cachi ra cuhva ndacu xaan ra fariseo. Chacan cuu cha iyo xaan cuni ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tacan cuu, ta quechaha cati ra chahnu chi ra ti: ―Ndihi ndioho fariseo, nacata ndo coho ndo. Nacata ndo yachin ndo. Chata ni chi nacata ndo, soco anima ndo ña vaha, vati mani cha ndavaha ni cuni ndo. Mani cha cuni ndo chi ndo ndacu ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tondo xaan xini ndo. Ini ra Ndioo cuu ra savaha chi ñuhun ñuñivi ya, ta savaha tahan ra chi maan yo chi anima yo. ");
INSERT INTO mioNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Na cua tindee ndo chi ñivi tahan ndo cuhva cha iyo chi ndo, ta ndoo ndoo cua coo anima ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Ndioho ra fariseo, cua coo tu ndoho chi ndo, vati ndihi yucu ni samani ndo chi ra Ndioo. Samani ndo menta. Samani ndo minu. Ndihi chacan ni samani ndo chi ra, soco ña tuhva ndo savaha tahan ndo cha vaha ndicha chi ñivi tahan ndo. Ña tuhva ndo cuni mani tahan ndo chi ñivi tahan ndo. Iyo cha cua savaha ndo nduvi cuhva can, ta ña cua nacoo ndo ni iin chi ni inga chi. ");
INSERT INTO mioNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Ndioho ra fariseo, cua coo tu ndoho chi ndo, vati cuni ndo cunda ndo tayu vaha xaan ca cha iyo ve ñuhun. Cuni ndo cha cua sacahnu xaan ñivi chi ndo nu yaha ndo iti. ");
INSERT INTO mioNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Ndioho ra fariseo, ndioho ra sacuaha ley, ra uvi yaa cuu ndo, vati cahnu xaan ndavaha ni ndacu ndo, soco ña chito ñivi, vati sandahyu ñahan ndo chi ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tacan cuu, ta quechaha cati iin ra sacuaha ley chahnu chi ra Jesuu ti: ―Maestru, cahan tahun ndavaha ni chi maan ndi cha cahun tuhun can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ta cati ndico ra Jesuu chi ra ti: ―Ndioho ra sacuaha ley chahnu, cua coo tahan tu ndoho chi maan ndo, vati vee xaan tuhun chaha ndo chi ñivi. Yaha cuhva cha chaha ndo tuhun chi ñi, ta ña tindee ndo chi ñi ni suhva. ");
INSERT INTO mioNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Cua coo tu ndoho chi ndo, vati taqui xaan ni chaqui ndaa ndo bóveda nu ni cuchi ra ni cahan cuenda ra Ndioo, ta ñivi maan ndo cuu ñivi ni chahni chi ra iti chata tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chacan cuu cha testigu cuu ndo, ta chaha ndo cuenda ti iyo inuun ndo chi ñivi ndo iyo tiempu chahnu, vati ñican―chahni ñi chi ra ta ra, ta maan ndo savaha ñaña nu ni cuchi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Iyo cha chini tuni chi ra Ndioo. Chacan cuu cha cati ra nu ni quichi quivi ti cua tava tiñu ra chi ra cahan cuenda ra chi ra cuu tatun ra, soco cua cani ñivi chi ra, ta cua cahni ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chacan cuu cha cua coo cuati chi ndo chi ñivi iyo vitin, vati chahni ñivi ndo chi ra ni cahan cuenda ra Ndioo nda ni xihna cuii ");
INSERT INTO mioNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nu ni chihi ra Abel nda cua nda ni chihi tahan ra Zacaría. Chahni ñi chi racan nda mahñu nu ni samani ñi sana ñi chi ra Ndioo nda yu ve ñuhun. Cati ndicha yu chihin ndo ti cua tiso ra Ndioo cuati ndo chi ñivi iyo vitin. ");
INSERT INTO mioNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Ndioho ra sacuaha ley chahnu, cua coo tu ndoho chi ndo, vati ña chaha ndo cha cua cutuni ini ñivi. Ña cuni ndo quihvi ndo cuenda ra Ndioo, ta ni ña chaha ndo cha cua quihvi inga ñivi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nu ni quee ra Jesuu tican, ta xaan xaan quechaha cuni ra fariseo chi ra sacuaha ley chahnu. Cuaha xaan nducu tuhun xaan ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tasoho xaan ra ta ra tuhun cahan ndico ra, vati nanducu xaan ra cuhva cha cua tiso ra ta ra cuati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tacan cuu, ta nducuiti ndico tucu ñivi. Tuvi xaan tuvi xaan ñivi nducuiti. Chacan cuu cha chañu xaan ñi chata chaha tahan ñi. Quechaha cahan xihna ra Jesuu chi ra sacuaha chi ra, ta cati ra ti: ―Na cua saha ndo cuenda yoso cuhva iyo ra fariseo, vati rai uvi yaa cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Cua queta quivi cua coto ndihi ñivi ndihi cha cahan xehe yo, ta cua coto tahan ñi ndihi cha ndacu xehe yo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chacan cuu cha cua coto ndihi ñivi ñaan cha cuu cha cua cahan xehe ndo. Masi indi xehe ndo tichi vehe ndo, ta ndasi vaha yu vehe, soco cua coto ndihi ñivi cha ni cahan ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ni vii cahan ra Jesuu chi ñivi can: ’Amigu, cati yu chihin ndo ti ña cua cuyuhvi ndo chi ñivi cua cahni chi ndo, tu tacan ni cua cuu savaha ñi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Cua cati yu chihin ndo yochi cua cuyuhvi ndo. Cua cuyuhvi ndo chi ra Ndioo, vati cua cuu cahni xihna ra chi ndo, ta sa cua sandoyo ñuhun ra chi ndo nu cua tachi tuni ra chi ndo. Cati ndicha yu chi ndo ti chi racan cua cuyuhvi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Chito ndo ti quiyahvi ri saa cuati can uhun ri ta uvi xuhun cuati. Ñahni yavi ndaa ri, soco ña cua naan ini ra Ndioo chi ri. ");
INSERT INTO mioNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Chacan cuu cha chito ra Ndioo yoso tahan ixi xini ndo iyo. Ña cuyuhvi ndo, vati iyo ca yavi ndaa maan ndo, ta ñavi ca sa ndihi ri saa can. ");
INSERT INTO mioNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ni vii cahan ra Jesuu chi ñivi can: ’Cati yu chi ndo ti tu cua cuhva ndo cuenda ti nacoto ndo chihin yu, ta ta ni cuhva yuhu ra cuu sehe ñivi cua cuhva tahin cuenda chi ra Ndioo ti nacote chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tu cua cati ndo ti ña nacoto ndo chihin yu, cua cati tahin chi ra Ndioo ti ña nacote chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Tu cua cahan ndo ti ña vaha cuu ra cuu sehe ñivi, vasi cua cucahnu ini ra Ndioo chacan, soco tu cua cahan ndo ndavaha ni cuenda ra Tati Ndioo, ña cua cuu cucahnu ini ra chacan. ");
INSERT INTO mioNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Tu cua cundaca ñivi chi ndo iti nuun ra chanihin ve ñuhun nu sacahnu ñivi judío, tu cua cundaca ñi chi ndo nu ra cumi tiñu, ña cua tichaha ni ndo ñaan cha cuu cha cua cahan ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ña cua tichaha ni ndo, vati suvi ni hora can cua sacoto ra Tati Ndioo chi ndo ñaan cha cuu cha cua cati ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tacan cuu, ta nducahan iin ra iyo nda mahñu ñivi can, ta cati ra chi ra Jesuu ti: ―Maestru, cua cati cun chi ra yani yu ti cua natahvi ra ndatiñu ndii sutu ndi chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ta cati ndico ra Jesuu chi ra ti: ―Hombre, yoni chaha tiñu chihin yu ti cua cati tuhin yoso cuhva cua ndoo tiñu can chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tacan cuu, ta cati ra Jesuu chi ñivi can ti: ―Cua saha vaha ndo cuenda, coto cua yaha cuhva cua cuni ndo cha iyo chi tahan ndo. Vasi iyo xaan ndatiñu chi ndo. Vasi iyo xaan xuhun chi ndo, soco ñavi cuenda chacan iyo vaha ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tacan cuu, ta cati ra Jesuu cuhva ya chi ñi: ―Iyo iin ra ricu. Vaha xaan ni chacoo itu ra, ");
INSERT INTO mioNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ta quechaha saxini ra chi anima ra ñaan cha cuu cha cua savaha ra. Ña chito ra ñaan cua savaha ra, vati ña cha tahan ca nu tivaha ra chi chi. ");
INSERT INTO mioNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tacan ni saxini ra ricu can, ta quechaha cati ra chi anima ra ti: “Cua cani yu yaca yu, ta cua savahi inga cha cahnu ca, ta cua tihi yu ndihi chi tichi can.” ");
INSERT INTO mioNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Saxini ra ti: “Cuaha xaan nuni yu iyo. Cuaha xaan ndatiñu yu iyo. Cuaha cuiya cua ndunahan chi. Vitin cua quee tatun yu. Cua cachi yu, ta cua coho yu, ta cua cusii ini yu,” cati ra chi anima ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tacan cuu, ta cati ra Ndioo chi ra ti: “Tondo xaan xini cun. Yuhu cati ti vitin ya cha cuaa ya cua cuvi cun, ta ndihi cha ni tiso vahun―ña cua ndoo chi chihun,” cati ra Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tacan ni cua coo ñivi tiso vaha xaan suvi ni cuenda maan ñi, ta ña iyo vaha ñi cuenda ra Ndioo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Inga hora, ta cati ra Jesuu chi ra sacuaha chi ra ti: ―Chacan cuu cha cati yu chi ndo ti ña cua saxini ndo suvi ni cuenda maan ndo. Ña cua saxini ndo ñaan cha cuu cha cua cachi ndo. Ña cua saxini ndo ñaan cha cuu cha cua cunami ndo ta ñaan cha cuu cha cua cundichin ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Cha savaha ra Ndioo chi yo, ta chaha ra cha iyo ndito yo. Cahnu xaan cha ni savaha ra chi yo. Chacan cuu cha chito yo ti cua cuhva ra cha cua cachi yo, ta cua cuhva ra cha cua cunami yo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ndehe ndo yoso cuhva iyo ri ticaca. Ña tuhva ri tachi, ta ni ña tuhva ri saquee. Ñahni nu tivaha ri nuni, ta chaha ra Ndioo cha chachi ri. Ta ri saa can―ñahni yavi ndaa ri. Iyo xaan ca yavi ndaa maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ña cua saxini ndo, vati ña cuu ndusucun ca ndo suhva ca, masi saxini ndo suhva. ");
INSERT INTO mioNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ña cua saxini ndo cuhva iyo ndo, vati chito ndo ti ñahni yavi ndaa chacan, vati ña cuu sandusucun ca ndo chi ndo. Chacan cuu cha chito ndo ti ñahni yavi ndaa cha cua saxini ndo cuenda chacan. ");
INSERT INTO mioNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Cua ndehe ndo yoso cuhva iyo ita ndiquin. Ña tuhva chi tavi, ta ni ña tuhva chi cunu isa. Cati yu chi ndo ti taqui xaan iyo chi. Ta ra Salomón―taqui xaan ni chacunami ra. Taqui xaan ni chacundichin ra quivi ni chacoo ra nu ñuhun ñuñivi ya, soco ña taqui ra cuhva taqui ita can. ");
INSERT INTO mioNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tacan ni savaha ra Ndioo chi ita iyo tichi cuhu. Vitin ni iyo chi, ta yutaan ndoyo ñuhun chi. Chacan cuu cha chito ndo ti vaha xaan cua savaha ra chi maan ndo. Na cua cuinu vaha ini ndo chi ra, vati ña ta cuu vaha. ");
INSERT INTO mioNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ña cua nanducu xaan ndo cha cua cachi ndo cha cua coho ndo. Ña cua tichaha ni ndo, ");
INSERT INTO mioNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","vati ndihi ñivi ñuñivi nanducu xaan chacan. Chito sutu ndo ti chini ñuhun ndo chi chi. ");
INSERT INTO mioNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Na cua nducu xihna ndo cuhva cha cua coo ndo chi ra Ndioo nu cua cundaca ñahan ra, ta sa cua cuhva ra ndihi cha chini ñuhun ndo vitin. ");
INSERT INTO mioNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ni vii cahan ra Jesuu: ’Ña cuyuhvi ndo, vati cha ni cati ra sutu ndo ti cua coo ndo chi ra nu cua cundaca ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Cua xico ndo ndatiñu ndo, ta cua tindee ndo chi ñivi ndahvi. Tacan ni cua savaha ndo cha cua cunda yahvi ndo chi ra Ndioo iti siqui andivi, ta ña cua yaha cuhva cha cua coo ndatiñu chi ndo nu ñuhun ñuñivi ya, vati nduchahnu chi, ta ndoyo ñuhun chi, ta quihin ñasuhu chi chi. ");
INSERT INTO mioNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nu iyo ndatiñu ndo cuni ndo coo ndo. Tu cua saxini ndo cuenda ndatiñu ndo, cua cuni coo ndo chi chi, soco tu cua saxini ndo cuenda ra Ndioo, cua cuni coo ndo chi maan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ni vii cahan ra Jesuu inga cuhva: ’Na cua cuatu vaha ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Na cua coo ndo cuhva iyo ra musu, ta ndatu vaha ra chi chitoho ra ndaa hora cua quichi ndico ra cha cuahan ra vico tandaha. Ndatu vaha ra musu can, vati quii quii ni cua nuna ra yu vehe hora cua quichi ndico ra chitoho ra, ta cua cani ra yu vehe. ");
INSERT INTO mioNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Cua cusii ini ra musu can, vati cua quichi ndico chitoho ra, ta cua ndehe ra ti ndatu vaha musu ra chi ra. Cati yu chihin ndo ti cua tiso vaha ra chitoho can, ta cua cati ra chi ra musu ra ti cua cunda ra yu mesa, ta cua sacachi ra chi musu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tu cua nducuee ra chitoho can, ta cua quichi ra sava ñuun a cua quichi ra cha cua cundichin, ta cua ndehe ra ti ndatu vaha musu ra chi ra, cua cusii ini ra musu can. ");
INSERT INTO mioNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chito ndo ti tu cua coto ñivi ñaan hora cua quichi ñasuhu, cua cuatu ñi chi run, ta ña cua cuhva ñi quihvi run tichi vehe ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na cua cuatu vaha ndo chi ra cuu sehe ñivi, vati cua quichi ndico ra, ta ña cua coto ndo ñaan hora cua quichi ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tacan cuu, ta quechaha nducu tuhun ra Pedro chi ra Jesuu ti: ―Ra chahnu, ¿atu chi maan ndi cahun cuhva can a chi ndihi ñivi cahun chi chi? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ta cati ndico ra chahnu ti: ―Cati yu chihin ndo ti cua cuhva ra chitoho tiñu chi ra musu vaha, vati saxini vaha ra musu can. Chacan cuu cha cua satiñu vaha ra musu chi ñivi ra chitoho ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Cua cusii ini ra musu can, tu cua satiñu vaha ra hora quichi ndehe chitoho ra nu satiñu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Cati ndicha yu chihin ndo ti cua cati ra chitoho ra ti cua sacuenda ra musu can chi ndihi ndatiñu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tu cua saxini ra musu can chi anima ra ti cua nducuee ra cuu chitoho ra, vati ña cua quichi nahan ra. Tacan, ta sa quechaha cani ra chi musu tahan ra, ta chachi ra, ta chihi ra, ta chini ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tu tacan cua savaha ra musu cuu xini can, cua quichi ndico ra chitoho ra. Hora ña saxini ra musu can cua quichi ndico ra, ta iyo xaan cua tachi tuni ra chi ra. Cua tava ndaa ra chi ra, ta cua ndoo ra musu can nu iyo ñivi ña sacuinu vaha tiñu. ");
INSERT INTO mioNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Xaan xaan cua cutuni ra musu can, vati chito ra yoso cuhva cuni chitoho ra, ta ña tiso vaha ra, ta ni ña savaha ra cuhva cuni chitoho ra. ");
INSERT INTO mioNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ta ra ña chito yoso cuhva cuni chitoho ra―tu ña vaha cua savaha ra, ña cua cutuni xaan ra. Tu cuaha tiñu cua cuhva ra Ndioo cuiso ndo, cua saxini ra ti vaha xaan cua satiñu ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ni vii cahan ra Jesuu: ’Quichi yu, vati cua savahi ti cua coo tu ndoho chi ñivi ñuñivi, ta cha iyo tu ndoho chi ñivi cuhva cuni yu. ");
INSERT INTO mioNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Iyo cha cua coo tu ndoho chihin yu, ta cuaha xaan saxini yu nda cua nda quivi cua ndehi tu ndoho can. ");
INSERT INTO mioNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Saxini ndo ti quichi yu, vati cua sandumani yu chi ñivi ñuñivi, soco ñavi chacan tiñu quichi yu. Cati yu chihin ndo ti quichi yu, vati cua sandusaque chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ña cua nduinuun ñivi cuenda yu nda cua nda vitin ta nda cua nda iti nuun. Iyo uhun ñivi iin vehe, ta cua cahan yuhu uni ñi chi inga uvi ñi, ta cua cahan yuhu tahan uvi ñi chi inga uni ñi. Ña cua nduinuun ñi cuenda yu. ");
INSERT INTO mioNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Cua cahan yuhu ra rai chi sehe ra, ta cua cahan yuhu ndico tucu ra cuati chi sutu ra. Cua cahan yuhu ñi ñahan chi sehe ñi, ta cua cahan yuhu ndico tucu ñi cuati chi sihi ñi. Cua cahan yuhu ñi chahnu chi chanu ñi, ta cua cahan yuhu ndico tucu ñi tivaa chi chiso ñi, vati ña cua nduinuun ñi cuenda yu. ");
INSERT INTO mioNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tacan cuu, ta ni vii cahan ra Jesuu chi ñivi can: ―Ta cha ndehe ndo ti vachi vico iti chiyo chiso nicandi, ta cati ndo ti cua cuun savi, ta ndicha ti cua cuun savi. ");
INSERT INTO mioNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ta cha ndehe ndo cha vachi tati iti xuu, ta cati ndo ti ihni xaan cua cuu, ta ndicha ihni xaan cua cuu. ");
INSERT INTO mioNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ña vaha ñivi cuu ndo, vati chito xaan ndo yoso cuhva iyo ndo nu ñuhun ñuñivi, soco ña chito ndo ñaan quivi chica ndo vitin. ");
INSERT INTO mioNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ni vii cahan ra Jesuu: ’Iyo cha cua nducu suvi ni maan ndo cuhva ñaan cha cuu cha vaha ndicha. ");
INSERT INTO mioNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tu cua tiso ñivi cuati ndo, tu cua cundaca ñi chi ndo nuun ra cumi tiñu, cua nducu ndo cuhva cha cua coso vaha tiñu nu cuahan ndo, coto cua queta ndo nu ra cale, ta cua sayaha ra chi ndo chi ra mayoo, ta cua tihi ra chi ndo ve caa. ");
INSERT INTO mioNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cati yu ti ña cua quee ndo tican nda cua nda cua tiahvi ndo ndihi multa can ―cati ra Jesuu, vati tacan ni cua coto ñivi ti na cua nducu ñi cuhva cha cua coso vaha tiñu chi ra Ndioo, ta ni vii cumani cha cua tachi tuni ra chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Suvi ni hora can ni iyo cuiti tahan iin uvi uni ñivi, ta chaha ñi cuenda chi ra Jesuu yoso cuhva chahni ra Pilato chi tahan ñi quichi iti ñuhun Galilea. Chahni ra chi ñi nu ni samani ñi sana ñi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tacan cuu, ta cati ra Jesuu chi ñi ti: ―Ña cua saxini ndo ti savaha xaan ca ñivi can cuati, vati ni tahan ñi tu ndoho can, ta ña cuaha xaan ni cuati ndacu ndihi ca ñivi tahan ñi iyo ñuhun can. ");
INSERT INTO mioNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Cati yu ti ñavi chacan cuu cha ni tahan ñi tu ndoho can, soco tu ña cua saña ihni ndo cuati ndacu ndo, cua ndoyo ñuhun tahan ndo cuhva ni ndoyo ñuhun ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ni ñuhun ini ndo ti nduva torre iyo nuun Siloé siqui ñivi, ta chihi chahun uni tahan ñi. Ña cua saxini ndo ti iyo ca cuati chi ñican, vati ni tahan ñi tu ndoho can, ta ñahni cuati iyo chi ndihi ca ñivi iyo ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Cati yu ti ñavi chacan cuu cha ni tahan ñi tu ndoho can, soco tu ña cua saña ihni ndo cuati ndacu ndo, cua ndoyo ñuhun tahan ndo cuhva ni ndoyo ñuhun ñivi can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tacan cuu, ta cahan ra Jesuu cuhva ya, ta cati ra chi ñi ti: ―Iyo iin rai, ta tachi ra iin tusihva tiñi vixin nu iyo yama ra. Tacan cuu, ta cuahan ra ti cua ndehe ra a ñahni chiti chi, soco ñahni chi nihin ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chacan cuu cha cati ra chi ra cuu musu ra ti: “Cha queta uni cuiya cha quichi ndehi a ñahni chiti yutun ya, ta ñahni chi nihin yu. Cahnda cun chi chi, vati ñahni yavi ndaa chi nu inda chi,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tacan cuu, ta cati ndico ra musu can ti: “Saña nuun cun chi chi tichi cuiya ya, ra chahnu. Cua nañu xihne chaha chi, ta cua tihi yu ihvi xuu ri sundiquin. ");
INSERT INTO mioNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tu cua coo chiti chi cha tacan inga cuiya, vaha cua ndoo chi, soco tu ñahni chi cua coo, cua tahnda chi,” cati ra musu can ―cati ra Jesuu, vati tacan ni cua coto ñivi ti nini xaan cua saña ihni ñi cuati ndacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Iin quivi sábadu sacuaha ra Jesuu chi ñivi. Iin ve ñuhun sacuaha ra chi ñi, ");
INSERT INTO mioNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ta iyo tahan iin ñahan tican. Chahun uni cuiya cha cuhvi ña, vati cha ndutihi chata ña savaha iin run tati cuihna chi ña, ta ña cuu cuinda cuiti vaha ña. ");
INSERT INTO mioNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ndehe ra Jesuu chi ña, ta cana ra chi ña, ta quechaha cati ra chi ña ti: ―Yoho sihi, cha cua nduvahun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tacan, ta tiso ra ndaha ra chata ña, ta suvi ni hora can ni chacuinda cuiti ña, ta quechaha cati ña ti cahnu xaan rai cuu ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tacan cuu, ta quechaha nduxaan ra cuu xini ve ñuhun can. Nduxaan ra, vati quivi sábadu can ni sanduvaha ra Jesuu chi ñacan. Chacan cuu cha quechaha cati ra cuu xini can chi ñivi can ti: ―Iyo iñu quivi cha cua satiñu yo. Tu cua cuni ndo nduvaha ndo cuehe cuhvi ndo, cua quichi ndo cha cuu iñu quivi can, soco ña cua quichi nduvaha ndo quivi sábadu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tacan cuu, ta cati ra chahnu chi ra ti: ―Ñivi uvi yaa cuu ndo. Chite ti quivi sábadu cuu chi, soco ndihi ndo―ndachi ndo sundiquin ndo. Ndachi ndo buru ndo. Ndachi ndo chi ri nu chachi ri, ta chandaca ndo chi ri nu cua coho ri nduta quivi sábadu. ");
INSERT INTO mioNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Vasi ña vaha cha nduvaha ñahya quivi sábadu ya cuni ndo. Ñivi ra Abraham chi ña, soco cha queta chahun uni cuiya iyo cuhva cha ni chuhni run Satanaa chi ña, ta ña cuu ndachi yo chi ña quivi sábadu, cati ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Cha ndihi cahan ra Jesuu tuhun can, ta quechaha nducahan nuun ndihi ñi nduxaan chi ra. Tacan cuu, ta cusii ini xaan ndihi ñivi can, vati cuaha xaan cha vaha ndicha ni savaha ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Tacan cuu, ta cati ra Jesuu ti: ―Nu cua cundaca ñahan ra Ndioo cuu sava ni ta cua iin chiti motasa. Quihin iin rai chi chi, ta tachi ra chi chi tichi yama ra. Cana chi, ta chahnu chi. Cahnu xaan yutun cha cuu chi, ta quichi coo ri saa soco chi. Tacan cati ra Jesuu, vati tuvi xaan ñivi ra Ndioo cua coo nu cuahan quivi. ");
INSERT INTO mioNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Cati ndico tucu ra Jesuu inga cuhva ti: ―Nu cua cundaca ñahan ra Ndioo cuu sava ni ta cua ndixi panela. Quihin iin ñahan chi chi, ta tixehe ña chi chi tichi uni cuhva yuti paan, ta chinu xico chi niniin chi. Tacan cati ra Jesuu, vati cua queta tuhun Ndioo nini cahnu nu ñuhun ñuñivi, ta cua cuinu ini ñivi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Cuaha ñuun nu ni yaha ra Jesuu cha cuahan ra iti ñuun Jerusalén, ta sacuaha ra chi ñivi ñuun nu ni yaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iin chaha nducu tuhun iin ñivi chi ra ti: ―Ra chahnu, ¿atu suhva ni ñivi cuu ñi cua sacacu ra Ndioo? ―cati ñi. Ta cati ndico ra Jesuu ti: ");
INSERT INTO mioNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Na cua sandee ini ndo chi ndo, ta cua cuu quihvi ndo nu cuu chi sava ni ta cua iin yu vehe. Tuu xaan chi, vati tuvi ñivi cua nducu ñi cuhva cha cua quihvi ñi, soco ña cua cundee quihvi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tacan cuu, ta cua cuinda ra cuu chitoho vehe can, ta cua casi ra yu vehe. Hora can cua queta ñivi yu vehe can. Iti chata tican cua cuinda ñi, ta cua cani ñi yu vehe, ta cua cati ñi ti: “Ra chahnu, nuna yu vehe, vati cua quihvi tahan ndi,” cua cati ñi, soco cua cati ndico ra ti: “Ña nacote chi ndo. Ña chite ndaa iti quichi ndo,” cua cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tacan cuu, ta sa cua cati ñi ti: “Cha chachi tahan ndi chihun, ta sacuahun chi ndi ñuun ndi,” cua cati ñi, ");
INSERT INTO mioNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","soco cua cati ndico ra chitoho can ti: “Ña chite ndaa iti quichi ndo. Cuahan ndo, vati mani ndavaha ni ndacu ndo,” cua cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tacan cuu, ta cua ndahyu xaan ñi. Cuihya xaan cua cuni anima ñi, vati cua ndehe ñi ti iyo ra Abraham chi ra Isaac chi ra Jacob chi ndihi ra ni cahan cuenda ra Ndioo tiempu chahnu. Ndihi racan ta ra cua coo chi ra Ndioo nu cua cundaca ñahan ra, soco ñican―cua quee ndaa ñi iin chiyo. ");
INSERT INTO mioNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nini cahnu nu ñuhun ñuñivi cua quichi ñivi, ta cua coo vaha ñi chi ra Ndioo nu cua cundaca ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chacan cuu cha iyo ñivi nducuee ñi chinu ini ñi chi ra Ndioo, soco cua cundee quihvi ñi nu cua cundaca ñahan ra, ta iyo inga ñivi sacahnu ñi chi ra Ndioo, soco cua ndoo ihni ñi, vati ña sacahnu ndicha ñi chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Suvi ni hora can quichi uvi ra fariseo nu iyo ra Jesuu, ta quechaha cati ra ta ra chi ra ti: ―Cuahan inga chiyo, vati cuni ra Herode cahni ra chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ta cati ndico ra Jesuu chi ra ti: ―Cuahan ndico ndo, ta cati ndo chi ra maña can ti vitin yutaan cua tave chi run tati cuihna anima ñivi, ta cua sanduvahi chi ñivi, soco nda inga ca quivi, ta cua ndihi tiñu ndacu i. ");
INSERT INTO mioNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Iyo cha cua cuhin iti vitin chi yutaan chi isa, vati ña cuu cuvi iin ra cahan cuenda ra Ndioo, tu ña cua queta ra tichi ñuun ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Ndihi ndioho ñivi iyo ñuun Jerusalén, chahni ndo chi ra ni cahan cuenda ra Ndioo nu ni quichi quivi. Chi yuu cani ndo chi ra ni tava tiñu ra Ndioo iti nuun ndo. Cuni xain sacacu i chi ndo nu cua ndehe ndo tu ndoho sava ni ta cua sacacu ri tiñuun chi sehe ri cha tixehe ri chi ri tichi ndichin ri. Cuni yu sacacu i chihin ndo, soco ña cuni maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Cha nacoo ihni ra Ndioo chihin ndo ñuun ndo. Cati yu ti ña cua ndehe ca ndo chihin yu nda cua nda quivi cua saña ihni ndo cuati ndacu ndo, ta cua cati ndo ti cahnu xaan rai cuu ra quichi cuenda ra chahnu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Iin quivi sábadu cuahan ra Jesuu vehe iin ra fariseo cuu xini, vati cua cachi ra chi ra, ta ndehe xaan ra tahan ra fariseo can yoso cua savaha ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tacan cuu, ta queta iin rai nuun ra Jesuu, ta cuhvi ra cuehe cuiñu xaan. ");
INSERT INTO mioNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Quechaha nducu tuhun ra Jesuu chi ra sacuaha ley chahnu chi ra fariseo can ti: ―¿Yoso cati ley chahnu? ¿Atu cuu sanduvaha yo quivi sábadu a ña cuu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ta taxin taxin ndaa ra ta ra. Tacan cuu, ta tiso ra Jesuu ndaha ra chi ra ndahvi can. Sanduvaha ra chi ra, ta chaha ra ti na cuhun ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tacan cuu, ta nducu tuhun ra chi ra fariseo ta ra ti: ―¿Atu ña cua tava ndo buru ndo a sundiquin ndo tichi soco, tu cua quehni ri quivi sábadu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ta ña cuu cati ndico ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ndehe ra Jesuu yoso cuhva queta ñivi can vico can, ta nanducu ñi tayu vaha. Chacan cuu cha quechaha cahan ra iin cuhva chi ñi. Cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Tu cua satuhun ñivi chi ndo iin vico tandaha, ña cua nanducu ndo tayu vaha, coto cua quichi tahan inga ñivi cahnu ca. ");
INSERT INTO mioNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tacan, ta sa cua tuhva ra cana chi ndo nu ndaa ndo, ta cua cati ra chihin ndo ti: “Cua cuhva cun tayu ya chi rahya,” cua cati ra. Tu tacan ni cua tahan ndo, cua coo xaan tu ca nuun chi ndo, ta cua nanducu ndo inga tayu ndahvi nu cua cunda ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Chacan cuu cha cati yu ti cua cuhun ndo nu cua satuhun ñivi chi ndo, soco ña cua nanducu ndo tayu vaha nu cua cunda ndo. Chacan cuu cha cua tuhva ra cana chihin ndo, ta cua cati ra ti: “Amigu, cua cunda cun tayu vaha ya,” cua cati ra. Tu tacan ni cua cuu chi, cua ndehe ndihi ñivi iyo tahan ti sacahnu xaan ra chihun. ");
INSERT INTO mioNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tacan cati yu, vati tu cua nducu ndo cha cua cati ñivi ti cahnu xaan ñivi cuu ndo, cua coo tu ca nuun chi ndo, soco tu cua cahnda ini ndo chacan, cua sacahnu ndicha ra Ndioo chihin ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tacan cuu, ta quechaha cati ra Jesuu chi ra cana ñahan chi ra ti: ―Tu cua sacahnu cun iin vico, ña cua satuhun cun amigu cun. Ña cua satuhun cun yani cun. Ña cua satuhun cun ñivi cun. Ña cua satuhun cun ñivi ricu, coto cua queta quivi cua sacachi tahan ñi chihun, ta cua nihin ndico cun cha cua sanaun chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tu cua sacahnu ndico tucu cun vico, cua satuhun cun chi ñivi ndahvi. Cua satuhun cun chi ñivi cojo. Cua satuhun cun chi ñivi cuaa. Chi ñican cua satuhun cun, ");
INSERT INTO mioNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ta cua cusii ini cun, vati ña cua cuu sacachi ndico ñi chihun. Tacan ni cua savahun, vati cua tiahvi ndico ra Ndioo chihun quivi cua natacu ndico ñivi iyo vaha cuenda ra Ndioo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tuhun can ni chini iin ra ndaa yu mesa can, ta quechaha cati ra chi ra Jesuu ti: ―Cua cusii ini ñivi cua sacahnu vico nu cua cundaca ñahan ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ta cati ndico ra Jesuu cuhva ya ti: ―Iyo iin rai, ta cahnu xaan vico savaha ra. Tuvi xaan ñivi cana ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hora cua quechaha sacahnu ra vico can tachi ra chi musu ra, vati cua cati ra chi ñivi can ti: “Coho vitin, vati cha iyo vaha,” cua cati ra musu can. ");
INSERT INTO mioNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tacan cuu, ta cuahan ra, ta ndihi ñican quechaha cati ñi ti ña cua cuu. Iin ñi cati ñi chi ra ti: “Cha sate iin ñuhun, ta iyo cha cua cu ndehi chi chi. Na cua savahun tu manini cati cun chi ra ti na cua cucahnu ini ra chihin yu,” cati ñi chi ra musu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tacan cuu, ta cati inga ñi ti: “Cha sate uhun pare toro satiñu, ta cua cu ndehi ñaan cuhva iyo ri. Na cua savahun tu manini cati cun chi ra ti na cua cucahnu ini ra chihin yu,” cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Cati ndico tucu inga ra ti: “Cha ni tandahi. Chacan cuu cha ña cua cuu cuhin,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tacan cuu, ta cuahan ndico ra musu can, ta chaha ra cuenda chi ra cuu chitoho ra. Tacan, ta quechaha xaan cuni ra chitoho can, ta cati ra chi musu ra ti: “Cua cuhun yatin cun ndihi iti ñuun ya, ta cua cati cun chi ndihi ñivi ndahvi chi ñivi cojo chi ñivi cuaa ti na cua quichi ñi ta ñi ihya,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Cati ndico ra musu can ti: “Cha ni savaha ndi cuhva cati cun, ra chahnu, ta ni vii iyo cha cua cachi ñivi,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ta cati ndico ra chitoho can ti: “Cua cuhun ndico cun, ta cua ndehun ndihi ticu iti, ta cua sanini cun chi ñivi, vati cua quichi ñi. Chacan cuu cha tuvi ñi cua quichi, ");
INSERT INTO mioNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","soco ñivi cati ti ña quichi ñi―ñican ña cua cachi ca ñi chihin yu,” cati ra chitoho can. Tacan cati ra Jesuu, vati chaha ra cuenda yoso cuhva cua coo ñivi chi ra Ndioo nu cua cundaca ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Quivi can chica tuvi ñivi chi ra Jesuu. Tacan cuu, ta ndico coo ra, ta quechaha cati ra chi ñi ti: ");
INSERT INTO mioNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Tu cua quichi ndo chihin yu, ta ña cua cahnda ini ndo chi sutu ndo chi sihi ndo chi sehe ndo chi tahan ndo, tu ña cua cahnda ini ndo chi maan ndo, ña cua cuu cuu ndo tatun yu. ");
INSERT INTO mioNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tu ña cua cuni ndo coo ndo chi tu ndoho cuhva cua coo tu ndoho chihin ñivi nu cruu, tu ña cua caca ndo iti chica yu, ña cua cuu cuu ndo tatun yu. ");
INSERT INTO mioNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Cua cati yu iin cuhva chi ndo. Tu cua cuni ndo savaha ndo iin vehe, cua cunda nuun ndo, ta cua tava xihna ndo cuenda, coto ña cua queta xuhun ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tacan ni cua savaha ndo, coto cua queta ndicha cuii chaha ni chi, ta ña cua cuu saqueta ndo niniin chi. Tu tacan ni cua savaha ndo, cua ndehe ndihi ñivi, ta cua quechaha sacateni ñi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Cua cati ñi ti cha quechaha sacuinda rahya vehe, soco ña cundee ra sandihi ra chi chi. ");
INSERT INTO mioNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ta ni cuhva savaha ra cumi tiñu. Tu cua cuhun ra, ta cua cani tahan ra chi inga ra cumi tiñu, cua cunda nuun ra, ta cua saxini xihna ra a cua cuu sacanaan ra, vati uchi mil ni sandaru iyo chi ra, ta iyo oco mil sandaru chi inga ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tu ña cua cuu, cua tava tiñu ra chi ra ndiso tiñu nu vachi ra ta ra. Ni vii cani vachi ra, ta cua satahan ra chi ra, ta cua cahan ndahvi ra chi ra a ña cua cuu ndumani ndico ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Chacan cuu cha cati yu ti tu ña cua nacoo ihni ndo ndihi cha iyo chi ndo, ña cua cuu cuu ndo tatun yu. ");
INSERT INTO mioNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ni vii cahan ra Jesuu: ’Vaha xaan iyo ñiin, soco tu ña uhva ca chi, ña cua cuu nduvaha ndico chi. ");
INSERT INTO mioNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ñahni ca yavi ndaa chi cha tacan, ta ni ña cuu ca cuatiñu yo chi chi. Cua savita yo chi chi. Na cua taa vaha ndo soho ndo. Tacan cati ra Jesuu, vati tu ñahni yavi ndaa yo, cua tava ndaa ra Ndioo chi yo. ");
INSERT INTO mioNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Iin quivi quichi ndihi ñivi ndacu xaan cuati nuun iyo ra Jesuu, ta quichi tahan ra satiahvi, vati cuni ñi tasoho ñi tuhun cahan ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tacan cuu, ta cuaha xaan quechaha cahan ra fariseo chi ra sacuaha ley chahnu, ta cati ra ta ra cuenda ra Jesuu ti: ―Quihin cuenda xaan rahya chi ñivi ndacu cuati, ta icaa ni chachi ra chi ñi ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tacan cuu, ta quechaha cati ra Jesuu cuhva ya chi ra ta ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Tu iyo iin ciendu ri mbee chi ndo, ta cuanaan iin tuhun ri, ndihi ndo―cua nacoo ndo chi ndihi ca ri nu cuahan ndo tichi cuhu, ta cua nanducu ndo chi ri cuanaan nda cua nda cua nanihin ndo chi ri. ");
INSERT INTO mioNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tacan cuu, ta cua cunda chata ndo chi ri, ta cua cusii ini ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Cua queta ndico ndo vehe ndo, ta cua cati ndo chi ndihi ñivi ndo chi ndihi amigu ndo ti: “Na cua cusii ini yo, vati cuanaan iin ri mbee sana yu, soco nanihin ndique chi ri,” cua cati ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Cati yu chi ndo ti ta ni cuhva cua cusii ini ra Ndioo iti siqui andivi, tu cua saña ihni iin tuhun ñivi cuati ndacu ñi. Ñahni cha saxini ra cuenda ndihi ca ñivi cha iyo vaha chi ra, vati ña tichaha ca ñi saña ihni ñi cuati ndacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ni vii cahan ra Jesuu: ’Tacan tahan iyo ñi ñahan. Tu cha iyo uchi xuhun cuati chi ñi, ta cuanaan iin chi, cua taa ñi ñuhun, ta cua natihvi ñi niniin tichi vehe ñi. Ndoo ndoo cua nanducu ñi chi chi nda cua nda cua nanihin ñi chi chi. ");
INSERT INTO mioNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Cua nanihin ñi chi chi, ta cua cati ñi chi ndihi amiga ñi ti: “Cua cusii ini yo, vati nanihin ndico yu xuhun yu cha cuanaan,” cua cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Cati yu ti ta ni cuhva cua cusii ini ra tatun Ndioo, tu cua saña ihni iin tuhun ni ñivi cuati ndacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Inga cuhva cati ra Jesuu chi ñi ti: ―Iyo iin rai, ta uvi sehe ra iyo, ");
INSERT INTO mioNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ta quechaha cati ra luhu chi sutu ra ti: “Tata, natahvi ndatiñu cun cha cua cuhva cun chihin yu,” cati ra. Tacan cuu, ta natahvi ra sutu ra ndatiñu ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Suhva ca quivi, ta tiso vaha ra luhu can ndatiñu ra, ta quee iti ra. Cani xaan cuahan ra, ta tican sanaan ra ndihi cha iyo chi ra, vati mani cha coo ra chi ndavaha ni cuni ra. ");
INSERT INTO mioNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sanaan ra ndihi xuhun ra, ta cahnu xaan tama ni chacoo ñuun can, ta quechaha chini ñuhun ra. ");
INSERT INTO mioNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tacan cuu, ta cuahan ra nuun iin ra ñuun can, ta quechaha satiñu tatun ra chi ra. Chacan cuu cha tachi ra ñuun can chi ra nu iyo quini ra, vati cua sacachi ra chi ri. ");
INSERT INTO mioNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tacan cuu, ta cuni xaan ra cachi ra cha chachi ri quini can, soco yoni chaha chi chi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Queta iin quivi quechaha saxini vaha ra, ta cati ra chi anima ra ti: “Iyo tahan ra musu chi suti, ta ndihi ra chachi vaha, ta yuhu―ihya iye, ta chihi yu chi soco. ");
INSERT INTO mioNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cua cuhin nuun ra suti, ta cua cati yu chi ra ti cahnu xaan cuati cha ni savahi chihin ra chi ra Ndioo iyo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ñahni ca yavi ndai cha cua cui sehe ra. Na cua cuhva ra cha cua cui sava ni ta cuhva iin musu ra, cua cati yu chi suti,” saxini ra. ");
INSERT INTO mioNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tacan cuu, ta quee ra cuahan ra. Iti nuun sutu ra cuahan ra. ’Ni vii cani vachi ra, ta ndehe sutu ra chi ra, ta ndahvi xaan cuni anima ra ndehe ra chi sehe ra. Chacan cuu cha chinu ra cua satahan ra chi ra. Chacunumi ndaa ra chi ra, ta chihi ra yuhu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tacan cuu, ta quechaha cati ra luhu can chi sutu ra ti: “Tata, cahnu xaan cuati ni savahi chi maun chi ra Ndioo iyo iti siqui andivi. Ñahni yavi ndai cha cua cuu que sehun,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ta quechaha cati sutu ra chi ra musu ti: “Quii quii ni cua quichi ndaca ndo iin sahma vaha chi ra, ta cua sacundichin ndo chi ra. Cua tihi ndo xehe nundaha ra, ta cua cuhva ndo ndichan cunda chaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Cua cu quihin ndo sundiquin xahan, ta cua cahni ndo chi ri, vati cua cachi ndi, ta cua cusii ini ndi, vati cha quichi ndico sehi. ");
INSERT INTO mioNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Cha ndoyo ñuhun ra, soco vitin cha iyo ndico ra,” cati ra. Tacan cuu, ta sii xaan quechaha cuni ra ta ra, ta savaha ra vico. ");
INSERT INTO mioNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Tacan cuu, ta quichi ra chanihin ca. Iti chiqui quichi ra. Ña cani ca, ta queta ra vehe, ta chini ra ti iyo yaa, ta chita chaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chacan cuu cha cana ra chi iin ra musu can, ta nducu tuhun ra ñaan cha cuu chi, ");
INSERT INTO mioNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ta cati ndico ra musu ti: “Cha quichi ndico ra yani cun, ta chahni sutu cun chi ri sundiquin xahan, vati cha iyo ndico ra, ta ñahni cha ni tahan ra nu ni chahan ra,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tacan cuu, ta xaan xaan quechaha cuni ra chanihin can, ta ña cuni ra quihvi ra tichi vehe. Chacan cuu cha quee ra cuu sutu ra ta ra, ta cahan ndahvi ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","soco cati ndico ra chi sutu ra ti: “Cuaha xaan cuiya cha satiñu tatun yu chihun, ta ndihi ni quivi tasoho vahi cha cati tuhun cun chihin yu, ta ña ni chahun cha cahni yu ni iin chivu, ta cua cusii ini yu chi amigu yu. ");
INSERT INTO mioNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Vitin cha quichi ndico ra yani luhu yu. Cha ni chacoo xaan ra ndavaha ni chi ñi ñahan inga chiyo, ta cha ni sanaan ra ndatiñu cun chi ñi. Cuenda maan ra chahni cun chi ri sundiquin xahan,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ta cati ndico sutu ra chi ra ti: “Sehu, iyo cun chihin yu ndihi ni quivi, ta ndihi ndatiñu yu cuu chi maun. ");
INSERT INTO mioNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Vitin iyo cha sacahnu yo vico, ta cusii ini yo, vati cha ndoyo ñuhun ra yani cun, soco vitin cha iyo ndico ra chi yo,” cati sutu ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Cati ndico tucu ra Jesuu inga cuhva chi ra sacuaha chi ra ti: ―Iyo iin ra ricu, ta iyo musu ra. Cati ñivi chi ra ricu can ti sanaan ra musu can ndatiñu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Chacan cuu cha cana ra chi musu ra, ta quechaha cati ra chi ra ti: “Cha cati ñivi chihin yu ti ña vaha ndacu cun. Cua cati maun yoso cuhva cha ni savahun, vati ña cua cuu ca satiñu cun chihin yu,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Quechaha saxini ra musu can chi anima ra ti: “¿Ñaan cha cuu cha cua savahi? Cua quenda ra chitohi tiñu chihin yu. Ña cua cundei satiñu i, ta cahan nuin cha cua cu caye vehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Vitin chite ñaan cha cuu cha cua savahi, ta ni cua quihin cuenda ñivi chihin yu quivi cua quenda ra tiñu chihin yu,” saxini ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Chacan cuu cha cana ra musu can chi iin iin ñivi ndiseca chi chitoho ra, ta nducu tuhun ra chi ñi ti: “¿Yoso ndiseca cun chi ra chitohi?” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ta cati ndico ñi ti: “Iin ciendu litru aceite,” cati ñi. Cati ra musu can ti: “Vitin cua quihun tutu cun, ta numi xaan cua taa ndico tucu cun inga tutu cha ndiseca cun uvi xico uchi litru chi.” Tacan ni cati ra, vati sandahyu ñahan ra cha sanuun ra cha ndiseca ñi chi chitoho ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tacan cuu, ta nducu tuhun ra chi inga ñi ti: “¿Yoso ndiseca cun?” cati ra, ta cati ndico ñi ti: “Iin ciendu máquila nuni,” cati ñi, ta cati ra musu can ti: “Vitin cua quihun tutu cun, ta cua taa ndico tucu cun inga tutu cha ndiseca cun cumi xico máquila chi,” cati ra cha sandahyu ñahan ndico tucu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tacan cuu, ta cati ra cuu chitoho ra musu ña vaha can ti vaha xaan cha savaha ra cha cua quee vaha ra chi ñivi can. Tacan ni cati ra Jesuu, vati nditi xaan ca iyo ñivi ñuñivi cuenda chacan, ta ña nducu ñivi Ndioo cha savaha ñi chacan. ");
INSERT INTO mioNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ni vii cahan ra Jesuu: ’Yuhu cati chi ndo ti na cua satiñu ndo chi xuhun ndo, ta cua nducu ndo cha cua coo amigu ndo chi ndo. Chacan cuu cha quivi cua naan xuhun ndo nu ñuhun ñuñivi, soco cha iyo yoo cua quihin cuenda chi ndo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Chito yo ti tu ña cuaha ndatiñu iyo chi yo, soco satiñu vaha yo, cua satiñu vaha tahan yo―masi cuaha ndatiñu yo cua coo. Tu ña cuaha ndatiñu yo iyo, ta ña satiñu vaha yo, chito yo ti ña cua satiñu vaha tahan yo―masi cuaha ndatiñu yo cua coo. ");
INSERT INTO mioNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Chacan cuu cha cati yu ti tu ña cua savaha ndo cha vaha chi ndatiñu ndo nu ñuhun ñuñivi ya, yoni cua cuinu ini ti cua savaha ndo cha vaha iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tu ña cua savaha ndo cha vaha, ta chi inga ñivi cuu chi, ña cua nihin ndo cha cua cuu chi maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ña cuu satiñu ra musu chi uvi ra cuu chitoho ra, vati cua cuni mani ra chi iin ra, ta xaan xaan cua cuni ra chi inga ra. Chacan cuu cha ña cua cuu satiñu ndo chi ra Ndioo, ta cua cuni tahan ndo cha iyo nu ñuhun ñuñivi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chini ra fariseo can ndihi tuhun can, ta quechaha cahan cateni ra ta ra chi ra Jesuu, vati xuhun cuni xaan ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tacan cuu, ta cati ra Jesuu chi ra ta ra ti: ―Iti nuun ñivi cati ndo ti ñivi vaha cuu ndo, soco chito ra Ndioo yoso cuhva saxini ndo chi anima ndo. Tacan ni cati yu, vati xaan xaan cuni ra Ndioo ndehe ra cha cuu cha vaha xaan cuenda ñivi ñuñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ni vii cahan ra Jesuu: ’Tutu chahnu cuenda ley chi tutu chahnu cuenda ra ni cahan cuenda ra Ndioo sacahnu yo nda cua nda ni quichi ra Juaan, ta nda quivi ni quichi ra cati tuhun ndi tuhun vaha yoso cuhva cua coo ndo chi ra Ndioo nu cua cundaca ñahan ra, soco chi tu ndoho cua coo ndo nu cua cundaca ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ña ni ndoyo ñuhun ñuhun ñuñivi, ta ni ña ni ndoyo ñuhun iti siqui andivi. Ta ni cuhva ña cua cuu ndoyo ñuhun ni iin tuhun cha iyo cuenda ley chahnu. ");
INSERT INTO mioNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ni vii cahan ra Jesuu: ’Tu cua saña ndaha ndo chi ñasihi ndo cuenda ley, ta cua coo ndico tucu ndo chi inga ñahan, cua savaha ndo cuati chi ña cuenda ra Ndioo, vati cuu chi sava ni ta cua coo ndo ndavaha ni chi ñi ñahan inga chiyo. Tu cua tandaha ndo chi iin ñahan ni chacoo chi inga rai, ta ni cuhva cua savaha ndo cuati cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ni vii cahan ra Jesuu iin cuhva: ’Iyo iin ra ricu, ta taqui xaan sahma tixinda ndichin ra, ta cuaha xaan chachi ra ndihi ni quivi. ");
INSERT INTO mioNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Iyo tahan iin ra ndahvi nani Lázaro, ta cahvi xaan niniin ra. Caa ra yu vehe ra ricu can, ");
INSERT INTO mioNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ta cuni xaan ra cachi ra ñaan cha cuu cha quehni xuu mesa ra. Quichi tahan ri ina nu caa ra, ta yuvi ri nu cahvi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tacan cuu, ta queta quivi chihi ra ndahvi can, ta quichi quihin ra tatun Ndioo chi ra, ta chanaan ra chi ra nu iyo ra Abraham. Tacan cuu, ta chihi tahan ra ricu can, ta cuchi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nu iyo ñivi ndii can iyo ra, ta iyo xaan ra chi tu ndoho. Ndehe ndaa ra nu iyo ra Lázaro, ta ndehe ra chi ra Abraham, ta icaa ni iyo ra Lázaro chi racan. Cani xaan iyo ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tacan cuu, ta cana ra ricu can chi ra Abraham, ta quechaha cati ra ti: “Tata Abraham, na cua cundahvi ini cun, ta tachi cun chi ra Lázaro, vati cua tihi ra nundaha ra tichi nduta, ta cua quichi ra, ta cua cuhva ra cha cua nduvichin yai, vati iyo xain chi tu ndoho nu cayu ñuhun ya,” cati ra ricu can, ");
INSERT INTO mioNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ta cati ndico ra Abraham chi ra ti: “Sehu, ña cua naan ini cun ti vaha xaan ni chacoun nu ñuhun ñuñivi, ta ndahvi xaan ni chacoo ra Lázaro. Vitin cusii ini ra ihya, ta iyo maun chi tu ndoho. ");
INSERT INTO mioNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Iyo tahan iin xahva cunu xaan mahñu nu iyo yo. Chacan cuu cha ña cuu yaha ndi nda ndacan―masi cuni ndi. Ta ni cuhva ña cuu yaha maan ndo nda ndehe,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Cati ndico ra ricu can ti: “Tata, na cua savahun tu manini, ta cua tachi cun chi ra vehe suti, ");
INSERT INTO mioNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","vati uhun tahan ra yani yu iyo. Tacan, ta cha ña cua quichi tahan ra ihya nu iyo ndi chi tu ndoho,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ta cati ra Abraham ti: “Iyo tutu Ndioo chi ra cuhva ni cati tuhun ra Moisee cuhva ni cati ra ni cahan cuenda ra Ndioo. Na cua sacuaha ra chacan,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Cati ra ricu can ti: “Tata Abraham, ña vaha cha tacan, soco tu cua cuhun ndico iin ñivi ndii nu iyo ra, cua saña ihni ra cuati ndacu ra,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ta cati ndico ra Abraham chi ra ti: “Tu ña cua sacuinu ra cuhva cati ra Moisee cuhva cati ra ni cahan cuenda ra Ndioo, ña cua cuinu ini ra―masi cua cuhun iin ñivi ndii,” cati ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tacan cuu, ta cati ra Jesuu chi ra sacuaha chi ra ti: ―Ndihi ni quivi cua queta cha cua cuni ndo savaha ndo cuati, soco cua coo tu ndoho chi ñivi sanahan chi ndo yoso cuhva cua savaha ndo cuati can. ");
INSERT INTO mioNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vaha xaan ca tu ni chacunuhni iin yoso sucun ñi, ta quehni ñi tichi nduta tañuhun, ta chihi ñi nu quichi quivi. Tacan, ta ña cua cuu sanahan ñi yoso cuhva cua savaha ndo cuati. ");
INSERT INTO mioNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Na cua saha vaha ndo cuenda chi ndo. ’Tu cua savaha iin ñivi tahan ndo cuati chi ndo, cua cati cachin ndo chi ñi ti ña vaha cha savaha ñi. Tu cua cahan ndahvi ndico ñi chihin ndo, ta cua saña ihni ñi cuati can, cua cucahnu ini maan ndo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tu cua queta ucha chaha cua savaha ñi cuati chi ndo tichi iin nduvi, ta suvi ni ucha chaha cua cati ndico ñi chihin ndo ti cha saña ihni ñi chacan, na cua cucahnu ini ndo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Cati ndico tucu ra tatun Jesuu chi ra ti: ―Na cua tindeun chi ndi, ta cua cuinu ca ini ndi chi ra Ndioo ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ta cati ndico ra Jesuu iin cuhva chi ra ta ra ti: ―Tu cua cuinu ini ndo―masi suhva ni, cua cuu savaha ndo ndihi cuii cha cua cuni ndo. Cua cuu cati ndo chi yutun ya ti cua cuachiyo chi, ta cua coo ndico chi tichi tañuhun, ta cua savaha chi cuhva cua cati ndo chi chi. ");
INSERT INTO mioNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Cahan ndico tucu ra Jesuu: ’Quichi nuhun ra musu ndo iti nu satiñu ra chiqui iti nu sacuenda ra chi ri mbee, soco ña tuhva ndo cati ndo chi ra ti: “Nahan ti cua cachi cun.” ");
INSERT INTO mioNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Cua cati ndo chi ra ti: “Cua tiso vaha xihna cun cha cua cachi ndi, ta cua sayahun chi chi nu mesa, vati cua cachi xihna ndi. Tacan, ta sa cua cuu cachi tahun,” cua cati ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ña cua cuhva ndo tiahvi ndioo chi ra musu ndo, vati savaha ra cuhva cati tuhun ndo cha cua satiñu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Cuhva iyo ra musu can cua coo maan ndo. Cua savaha xihna ndo ndihi cha cati tuhun ra Ndioo chi ndo, ta sa cua cati ndo ti: “Ña cua sacahnu cun chi ndi, vati cha savaha ndi cuhva ni chahun tiñu chi ndi,” cua cati ndo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ni cuahan ra Jesuu iti ñuun Jerusalén, ta queta ra yu ñuhun Samaria nu nihin tahan ñuhun can chi ñuhun Galilea. ");
INSERT INTO mioNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tacan cuu, ta queta ra iin ñuun. Quihvi ra, ta ni natahan ra chi uchi rai, ta cuhvi ra ta ra cuehe tahyu xaan. Ni vii cani ni chacuinda ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ta cana chaa ra ta ra chi ra, ta cati ra ta ra ti: ―Yoho tata Jesuu, na cua savahun tu manini chi ndi, ta cua cundahvi ini cun chihin ndi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tacan cuu, ta ndehe ra Jesuu chi ra ta ra, ta quechaha cati ra chi ra ta ra ti: ―Cuahan ndo, ta cua sanahan ndo chi ra sutu yoso cuhva iyo ndo ―cati ra. Tacan cuu, ta quee ra ta ra cuahan ra, ta ni nduvaha ra iti cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iin ra ndehe ra ti ni nduvaha ra. Chacan cuu cha cuahan ndico ra nu iyo ra Jesuu. Nihin xaan cana chaa ra, ta sacahnu xaan ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Queta ra nu inda ra Jesuu, ta chahnu chiti ra iti nuun ra, ta chaha ra iin tiahvi ndioo chi ra, ta iin ra ñuhun Samaria cuu racan. ");
INSERT INTO mioNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tacan cuu, ta quechaha cati ra Jesuu chi ñivi can ti: ―¿Atu ñavi uchi ra cuu ra ni nduvaha? ¿Ndaa iyo inga iin tahan ra? ");
INSERT INTO mioNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ñacu ña vachi tahan ndihi ca racan ta ra, ta sacahnu tahan ra chi ra Ndioo? Iin tuhun ni rahya quichi ndico, ta ñavi ra judío cuu ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tacan cuu, ta cati ra Jesuu chi ra ti: ―Cuinda, ta cuahan. Ni nduvahun, vati chinu ini cun chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tacan cuu, ta nducu tuhun ra fariseo chi ra Jesuu ndaa quivi cua quechaha cundaca ñahan ra Ndioo, ta cati ndico ra Jesuu chi ra ti: ―Ña cua ndehe ndo ndaa quivi cua quechaha cundaca ñahan ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ña cua cuu cati ndo ti ihya ndaca ñahan ra, ta ni ña cua cuu cati ndo ti ican ndaca ñahan ra. Ña cua cuu cati ndo chacan, vati cha ndaca ñahan ra Ndioo chi ñivi ra nu iyo ndo vitin ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tacan cuu, ta cati ra chi ra sacuaha chi ra ti: ―Cua queta quivi cua cuni ndo cha cua quichi ndico ra cuu sehe ñivi, soco ña cua quichi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Cua cati ñivi ti ihya vachi ra, ta cua cati ñi ican vachi ra, soco ña cua cundicu ndo chi ñi. Ña cua tasoho ndo cha cahan ñi, ");
INSERT INTO mioNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","vati quivi cua quichi ndico ra cuu sehe ñivi cua quichi ra cuhva quehni tachan, vati nda iin chiyo iti siqui andivi nda inga chiyo ndundichin nu quehni tachan can. ");
INSERT INTO mioNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Iyo cha cua coo xihne chi tu ndoho. Cuaha xaan tu ndoho cua coo chihin yu, ta cua tava ndaa ñivi iyo vitin chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Quivi cua quichi ndico ra cuu sehe ñivi cua savaha ñivi cuhva ni savaha ñi quivi cha ni chacoo ra Noé iti chata. ");
INSERT INTO mioNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mani cha cua cusii ini ñi cuni ñi. Chacan cuu cha chachi ñi, ta chihi ñi, ta tandaha ñi. Tacan ni savaha ñi nda cua nda quivi ni quihvi ra Noé tichi tundoo, ta cuun savi, ta chihi ndihi ñican. ");
INSERT INTO mioNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ta ni cuhva ni savaha ñivi quivi cha ni chacoo ra Lot iti chata. Mani cha cua cusii ini ñi cuni ñi. Chacan cuu cha chachi ñi. Chihi ñi. Sata ñi. Xico ñi. Tachi ñi tata. Sandaa ñi vehe. ");
INSERT INTO mioNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tacan ni savaha ñi, soco queta quivi quee ra Lot ñuun Sodoma can, ta cuahan ra. Tacan ni cuu, ta iti siqui andivi saquehni ra Ndioo ñuhun cayu ñi, ta ndoyo ñuhun ndihi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Cuhva can cua coo chi quivi cua quichi ndico ra cuu sehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Tu cua cuinda ndo xini vehe ndo quivi can, ña cua nuun ndo tichi vehe, vati cua quihin ndo ndatiñu ndo. Tu cua satiñu ndo nu iyo itu ndo, ta ni cuhva ña cua cuhun ndico ndo vehe ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ña cua naan ini ndo cha ni tahan ñasihi ra Lot, vati chico coo ña ndehe ña. ");
INSERT INTO mioNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tu cua nducu ndo cuhva cha cua cacu ndo, cua ndoyo ñuhun ndo. Tu cua cuvi ndo cha cuenda ra Ndioo, cua coo ndito ndo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Cati yu chihin ndo ti suvi ni quivi can caa uvi ñivi nu quixi ñi, ta cua canihin ra Ndioo chi iin ñi, ta inga ñi cua ndoo ihni. ");
INSERT INTO mioNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Uvi ñi ñahan ndico ñi chaha icaa ni, ta cua canihin ra Ndioo chi iin ña, ta cua ndoo ihni inga ña. ");
INSERT INTO mioNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Satiñu uvi rai nu iyo itu ra, ta cua canihin ra Ndioo chi iin ra, ta cua ndoo ihni inga ra. Tacan ni cati ra, vati cuhva can cua canihin ra Ndioo chi ñivi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tacan cuu, ta quechaha nducu tuhun ra ta ra chi ra ti: ―¿Ndaa cua coo chacan, ta ra chahnu? ―cati ra ta ra. Ta cati ndico ra Jesuu ti: ―Nu chihi ri quiti cuhu nducuiti ri tachii. Tacan cati ra, vati tu cua ndoyo ñuhun ñivi cuenda ra Ndioo, cua cutuni ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Cati ra Jesuu iin cuhva chi ra ta ra, vati iyo cha cua cahan ra ta ra chi ra Ndioo ndihi ni hora, ta sa cua cundee ini ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Cati ra Jesuu ti: ―Iin ñuun iyo iin rai. Juee cuu ra, ta ña yuhvi ra chi ra Ndioo, ta ni ña sacahnu ra chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Iyo tahan iin ña ndahvi ñuun can, ta chahan xaan ña nu ra juee can, ta cati ña chi ra ti: “Na cua tachi tuni cun chi iin ñivi cuxaan ini chihin yu,” cati ña, ");
INSERT INTO mioNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ta xihna ca ña cuni ra tiso vaha ra tiñu can, soco queta quivi quechaha cati ra chi anima ra ti: “Ña yuhvi yu chi ra Ndioo, ta ni ña sacahnu yu chi ñivi, ");
INSERT INTO mioNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","soco cua tiso vahi tiñu ña, vati satañu xaan ña xini yu. Cua tiso vahi tiñu can, coto cua quichi xaan ca ña, ta cua cahan xaan ña chihin yu,” saxini ra ―cati ra Jesuu, vati iin cuhva cuu chi cuhva cha cua cahan ñivi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ni vii cahan ra chahnu chi ra ta ra ti: ―Na cua taa vaha ndo soho ndo tuhun cahan ra juee can, ta rai ndavaha ni cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Chacan cuu cha chito ndo ti cua tiso vaha ra Ndioo tiñu ñivi ra, tu cua cahan ndahvi ñi chi ra nduvi ta niñu, ta cua cundee ini ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yuhu cati ti ña cua nducuee ra, ta cua tiso vaha ra tiñu. Na cua cuinu ca ini ndo chi ra Ndioo, vati tacan sa cua cuinu ini ñivi chi ra cuu sehe Ndioo quivi cua quichi ndico ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tacan cuu, ta cahan ndico tucu ra Jesuu inga cuhva. Iyo ra saxini ti vaha xaan iyo ra, ta ña chaa ini ra chi inga ñivi. Chi racan cati ra Jesuu cuhva ya ti: ");
INSERT INTO mioNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Iyo uvi rai, ta cuahan ra ta ra ve ñuhun, vati cua cahan ra chi ra Ndioo. Iin ra cuu iin ra fariseo, ta ra satiahvi cuenda ra cumi tiñu cuu inga ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ni chacuinda ra fariseo can, ta quechaha cahan ra chi ra Ndioo. Ndurai ra, ta cati ra ti: “Ra chahnu Ndioo, chahi tiahvi ndioo chihun ti ña iye cuhva iyo ndihi ca ñivi. Ña tuhve suhu. Ña tuhve savaha ndavaha ni. Ña tuhve coo ndavaha ni chi ñi ñahan inga chiyo, ta ni ña tuhve savaha ndavaha ni cuhva ndacu rahya. ");
INSERT INTO mioNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Uvi chaha chacoo ndita yu tichi iin vita, ta samani yu iin cuhva cha cuu iin diezmo chihun,” cati ra fariseo can, ");
INSERT INTO mioNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","soco ra satiahvi can―cani vihi ni chacuinda ra. Ña cuni ra ndehe ndaa ra iti siqui andivi, soco cani ra pechu ra, vati ndahvi xaan cuni anima ra, ta quechaha cati ra chi ra Ndioo ti: “Tata Ndioo, na cua cundahvi ini cun chihin yu, vati cuaha xaan cuati ndacu i,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Cati yu chi ndo ti cha chacoso vaha tiñu chi ra Ndioo cuenda racan, ta cuahan ra iti vehe ra. Ta inga ra fariseo can―ña ni chacoso vaha tiñu cuenda ra, vati tu cua saxini ñivi ti cahnu xaan ñivi cuu ñi, cua coo tu ca nuun chi ñi, soco tu cua saxini ñi ti ñivi ndahvi cuu ñi, cua savaha ra Ndioo ti ñivi cahnu ndicha cua cuu ñi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Quivi can quichi ndaca ñivi chi ve cuati nu iyo ra Jesuu, vati cua tiso ra ndaha ra chi ve. Ndehe ra sacuaha chi ra yoso savaha ñi, ta cati ra ta ra ti ña vaha. ");
INSERT INTO mioNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Chacan cuu cha cana ra Jesuu chi ra ta ra, ta cati ra ti: ―Cua cuhva ndo cha cua quichi ve cuati nu iye. Ña cua casi ndo nu vachi ve, vati ñivi cuu sava ni ta cua ve cuati ya―ñican cuu ñi cua coo chi ra Ndioo nu cua cundaca ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cati ndicha yu chihin ndo ti tu ña cua cuinu ini ndo chi ra Ndioo cuhva chinu ini ve cuati, ña cua coo ndo chi ra nu cua cundaca ñahan ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Queta iin ra cuu xini cuenda ñivi judío can, ta quechaha cati ra chi ra Jesuu ti: ―Maestru, vaha xaan rai cuu cun. ¿Ñaan cha cuu cha cua savahi, ta cua coo ndito yu chi ra Ndioo ndihi ni quivi ndihi ni tiempu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ta cati ndico ra Jesuu chi ra ti: ―Ña vaha cha cati cun ti rai vaha cui. Iin tuhun ni ra Ndioo cuu ra cuu ra vaha. Ñahni ni iin ñivi ñuñivi cuu ñivi vaha. ");
INSERT INTO mioNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Chito cun tuhun cha ni cati tuhun ra Ndioo iti chata, vati cati ra ti ña cua coo yo ndavaha ni chi ñivi tahan yo inga chiyo. Ña cua cahni yo chi tahan yo. Ña cua suhu yo. Ña cua sandahyu ñahan yo cuenda ñivi tahan yo. Cua sacahnu yo chi sutu yo chi sihi yo, cati ra Ndioo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Cati ndico racan ti: ―Cha sacuinu yu ndihi chacan nda ni chacui ra luhu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nu ni chini ra Jesuu cha cahan ra tacan, ta cati ra ti: ―Ni vii iyo iin cha cumani cun. Cua xico cun ndihi cha iyo chihun, ta cua sacha cun xuhun can chi ñivi ndahvi, ta cua cunda yahvi cun chi ra Ndioo iti siqui andivi. Tacan cua savahun, ta cua quichi coo cun chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chini ra tuhun can, ta ndahvi xaan quechaha cuni anima ra, vati iyo xaan xuhun ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ndehe ra Jesuu ti ndahvi cuni ra, ta cati ra ti: ―Ii xaan, ta cua sacuinu ñivi ricu cuhva cuni ra Ndioo nu cua cundaca ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ña cuu yaha ri camellu yavi xuu quiticu, ta ii ca cua coo ñivi ricu chi ra Ndioo nu cua cundaca ñahan ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chini ñivi can tuhun cahan ra, ta quechaha nducu tuhun ñi ti: ―¿Yoo cua cundee cacu, tu tacan? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tacan cuu, ta cati ndico ra Jesuu ti: ―Ña cuu chi ñivi, soco cuu chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tacan cuu, ta quechaha cati ra Pedro chi ra ti: ―Cha ni nacoo ihni ndi ndihi cha iyo chi ndi, ta chica ndi chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Cati ndico ra Jesuu chi ra ta ra ti: ―Cati ndicha yu chihin ndo ti tu cua nacoo ihni ndo vehe ndo, tu cua nacoo ihni ndo ñasihi ndo chi yani ndo chi sutu ndo chi sihi ndo chi sehe ndo, ta cua cati tuhun ndo yoso cuhva cua coo ñivi chi ra Ndioo nu cua cundaca ñahan ra, ");
INSERT INTO mioNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","cua coo ca yahvi ndo tichi quivi ya, ta cua coo tahan yahvi ndo chi ra Ndioo iti nuun, vati cua coo ndito ndo chi ra Ndioo ndihi ni quivi ndihi ni tiempu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Quee siin ra Jesuu chi ndihi uchi uvi tatun ra, ta quechaha cati ra chi ra ta ra ti: ―Vitin cuahan yo iti ñuun Jerusalén, ta cua tahan ra cuu sehe ñivi ndihi cha ni taa ra ni cahan cuenda ra Ndioo cuenda ra tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chi ñivi quichi inga ñuhun cua cuhva cuenda ñivi judío ñivi yo chihin ra, ta cua sacateni ñican chi ra. Cua savaha ñi ndavaha ni chi ra, ta cua tivi sivi ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Cua cani ñi chi ra chi yoho, ta cua cahni ñi chi ra, soco cua yaha uni quivi, ta sa cua nandoto ndico ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ña nituni ini ra tatun ra tuhun can. Ña chito ra ta ra tuhun ni cahan ra, vati ña chaha ra Ndioo cha cua cutuni ini ra ta ra chi chi. ");
INSERT INTO mioNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yatin ñuun Jericó quichi ra Jesuu, ta ndaa iin ra cuaa xiin iti. Caya ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chini ra ndahvi can cha tuvi ñivi yaha, ta nducu tuhun ra ñaan cha cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Chacan cuu cha chaha ñivi can cuenda ti cha vachi ra Jesuu ñuun Nazaret. ");
INSERT INTO mioNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tacan cuu, ta quechaha cana chaa ra ndahvi can, ta cati ra ti: ―Yoho Jesuu, na cua cundahvi ini cun chihin yu, yoho cuu ñivi ra David ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tacan cuu, ta nduxaan ñivi vachi iti nuun chi ra, ta cati ñi ti na cunda taxin ra, soco nihin ca cana chaa ra, ta cati ndico tucu ra ti: ―Yoho Jesuu, na cua cundahvi ini cun chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tacan cuu, ta ni chacuinda ra Jesuu, ta cati ra chi ñivi ti na quichi ndaca ñi chi ra. Chacan cuu cha tuhva ra ndahvi can nu inda ra Jesuu, ta quechaha nducu tuhun ra Jesuu chi ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Ñaan cha cuu cha cua savahi cuni cun? ―cati ra. Ta cati ndico ra cuaa can ti: ―Ra chahnu, cha cua ndundichin vaha ndehi cuni yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ta cati ra Jesuu chi ra ti: ―Na cua ndundichin vaha ndehun. Cha ni nduvaha nuun cun, vati chinu ini cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Suvi ni hora can ni ndundichin vaha ndehe ra, ta cuandicu ra chi ra nu cuahan ra, ta sacahnu xaan ra chi ra Ndioo. Ndehe ndihi ñivi can cha ni nduvaha nuun ra, ta sacahnu tahan ñi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tacan cuu, ta queta ra Jesuu ñuun Jericó, ta cha cua yaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Iyo iin ra nani Zaqueo ñuun can. Xini cuu ra chi ndihi ra satiahvi chi ñivi can cuenda ra cumi tiñu, ta ricu xaan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Cuni ra ndehe ra chi ra Jesuu, soco ña cuu, vati tuvi xaan ñivi iyo, ta iin rai ndiqui luhu cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chacan cuu cha chinu ra cuahan ra iti nuun, ta ndaa ra iin nu yutun, vati tacan sa cua cuu ndehe ra chi ra, vati cua yaha ra tican. ");
INSERT INTO mioNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Cha cua queta ra Jesuu nu ndaa ra Zaqueo nu yutun can, ta ndehe ndaa ra Jesuu, ta quechaha cati ra chi ra ti: ―Yoho Zaqueo, cua nuun cun, ta cua sanumi cun, vati vitin cua ndoo nuin vehun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tacan cuu, ta nuun ra Zaqueo nu yutun can, ta sanumi ra cuahan ra. Sii xaan cuni ra, ta quihin cuenda ra chi ra Jesuu vehe ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ndehe ndihi ñivi nu cuahan ra Jesuu, ta ña vaha cuni ñi, ta cati ñi ti: ―Cha quihvi ra vehe iin ra ndacu cuati, ta ndoo nuun ra chi ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ni chacuinda ra Zaqueo can, ta quechaha cati ra chi ra chahnu ti: ―Ra chahnu, sava cha iyo chihin yu cua cuhve chi ñivi ndahvi. Cha ni sandahyu ñahan yu chi ñivi, ta ni quihin yu xuhun ñi. Cumi cuhva cuu siqui xuhun ñi cua tiahvi ndique chi ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ta cati ra Jesuu chi ra ti: ―Vitin quivi ya cha ni nduvaha anima ñivi iyo vehe ya, ta ñivi ra Abraham chahnu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Chacan cuu cha quichi ra cuu sehe ñivi, vati nanducu ra chi ñivi ndoyo ñuhun, ta sanduvaha ra anima ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Chini ñivi can tuhun ni cahan ra Jesuu. Tacan cuu, ta cahan ndico tucu ra inga cuhva chi ñi, vati yatin xaan quichi ñi iti ñuun Jerusalén, ta saxini ñi ti yatin xaan cua quechaha cundaca ñahan ra Ndioo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Chacan cuu cha quechaha cati ra Jesuu chi ñi ti: ―Iyo iin rai, ta cahnu xaan ñivi cuu ñivi ra. Cuni cuhun ra iin ñuun cani, vati cua cuu ra tiñu ñuun can, ta sa cua quichi ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Chacan cuu cha cana xihna ra chi uchi ra cuu musu ra, ta chaha ra iin iin xuhun chi ta iin ta iin ra, ta cuaha suhva xuhun cuu chi. Tacan cuu, ta cati ra chi ra ta ra ti: “Cua satiñu ndo chi xuhun ya nda cua nda quivi cua quichi ndique,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tacan cuu, ta cuahan ra ñuun can, soco quechaha cuxaan ini ñivi ñuun can chi ra cha vaha can. Tachi ñi tuhun chi ra cumi tiñu cahnu, ta cahan ñi siqui ra. Cati ñi ti: “Ña cuni ndi cha cua cundaca ñahan rahya chi ndi,” cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tacan cuu, ta cuahan ndico ra cha vaha can, ta cha cuu ra tiñu. Cati ra ti cua quichi ra musu cumi xuhun can, vati cuni ra coto ra yoso xuhun sacanaan ra ta ra nu satiñu ra chi xuhun can. ");
INSERT INTO mioNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Chacan cuu cha quichi iin ra, ta quechaha cati ra ti: “Ra chahnu, ni chaha nuun cun iin xuhun can chihin yu, ta sacanain inga uchi chi siqui chi,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Cati ndico ra cha vaha can ti: “Vaha xaan ni savahun. Vaha xaan musu cuu cun. Vitin cua cuhve ndatu chihun, ta cua cundaca ñahun chi ñivi iyo uchi ñuun, vati cha satiñu vaha cun―masi ña cahnu tiñu cuu chi,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tacan cuu, ta quichi inga ra musu ra. Cati ra chi ra chitoho ra ti: “Ra chahnu, cha chahun iin xuhun can chihin yu, ta inga uhun chi siqui chi cha sacanain,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ta cati ndico ra cha vaha can ti: “Cua cundaca ñahun chi ñivi iyo uhun ñuun,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tacan cuu, ta quichi inga ra. Cati ra chi ra chitoho ra ti: “Juhun, xuhun cun, ra chahnu. Cua quihun xuhun cun, vati cha tixehi chi chi tichi pañitu. ");
INSERT INTO mioNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Chacan ni savahi, vati yuhvi xain ndehi chihun. Chite ti rai xaan xaan cuu cun. Chacan cuu cha cumi vahi xuhun cun, coto cuanaan chi, ta cua satiahvi cun chihin yu,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ta cati ndico ra cha vaha can ti: “Ña vaha musu cuun. Cua sayahi chihun nu ra cumi tiñu, vati suvi ni maun chaha cuenda ti ña vaha ni savahun. Chito cun ti rai xaan cui, ta quihin yu xuhun―masi ñahni nu satiñu i. ");
INSERT INTO mioNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Ñacu ña chaha nuun cun xuhin chi ra nu satiñu ra chi xuhun? Tacan, ta sa cua cuhin, ta cua nihin ndico yu xuhin, ta cua coo siqui chi,” cati ra chi ra musu can, ");
INSERT INTO mioNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ta cati ra chi ñivi iyo chihin ra ti: “Cua quihin ndo xuhun can cha cumi nuun ra, ta cua cuhva ndo chi chi chi ra cumi uchi xuhun can,” cati ra, ");
INSERT INTO mioNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ta cati ndico ñi ti: “Ra chahnu, cha iyo uchi chi chihin ra,” cati ñi, ");
INSERT INTO mioNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ta cati ndico ra ti: “Cati yu chihin ndo ti cua coo ca chi ñivi satiñu vaha, ta cua naan cha iyo chi ñivi ña satiñu vaha. ");
INSERT INTO mioNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ta ñivi cuxaan ini chihin yu, ta ña cuni ñi cha cua cundaca ñahin chi ñi―chi ñican cua quichi ndaca ndo ihya, ta cua cahni ndo chi ñi iti nuin.” Tuhun can cahan ra Jesuu cuenda maan ra, vati cuxaan ini ra fariseo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ni vii cahan ra Jesuu tuhun can, ta cuahan ra iti nuun, vati ni cuahan ra iti ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Cha cua queta ra yucu Olivo can, vati ña cani ca iyo ñuun Betfagé chi ñuun Betania. Tacan cuu, ta tachi ra chi uvi ra sacuaha chi ra, ");
INSERT INTO mioNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ta cati ra chi ra ta ra ti: ―Cuahan ndo tican ñuun can. Sa cua quihvi ndo, ta cua ndehe ndo ti nuhni iin buru, ta ña ta coso ñivi chi ri. Cua ndachi ndo chi ri, ta cua quichi ndaca ndo chi ri ihya. ");
INSERT INTO mioNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tu cua nducu tuhun ñivi chi ndo ñacu ndachi ndo chi ri, cua cati ndo ti chini ñuhun ra chahnu chi ri ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tacan cuu, ta quee ra ta ra cuahan ra, ta ni nihin ra chi ri cuhva cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nu ni ndachi ra chi ri buru can, ta quechaha nducu tuhun ra chitoho ri chi ra ti: ―¿Ñacu ndachi ndo chi ri buru ya? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ta cati ndico ra ta ra ti: ―Ndachi ndi chi ri, vati chini ñuhun ra chahnu chi ri ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tacan cuu, ta ni chandaca ra chi ri nu iyo ra Jesuu. Tiso ra ta ra sahma ra chata ri, ta sa ni tiso ra chi ra Jesuu siqui ri. ");
INSERT INTO mioNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tacan ni cuahan ra, ta chaqui ra ta ra sahma ra nu iti nu yaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Cha cua queta ra nu cha ni nuun chi yucu Olivo can, ta ndihi ñivi chica chi ra quechaha cusii ini ñi. Nihin xaan cana chaa ñi, ta sacahnu xaan ñi chi ra Ndioo, vati cuaha xaan cuhva cha ni savaha ra Ndioo ndehe ñi, ");
INSERT INTO mioNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ta cati ñi ti: ―¡Cahnu xaan rai cuu ra quichi cuenda ra chahnu Ndioo, ta cua cundaca ñahan ra chi yo! ¡Na cua coo vii ra iyo iti siqui andivi! ¡Cahnu xaan rai cuu ra iyo iti siqui! ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tacan cuu, ta quechaha cahan uvi uni ra fariseo cha iyo tahan chi ñivi can. Cati ra ta ra chi ra Jesuu ti: ―Maestru, cati cun chi amigu cun ti na cutaxin ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Cati yu ti tu cua cutaxin ñihya, cua cana chaa maan yuu ya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tacan cuu, ta yatin ñuun Jerusalén queta ra Jesuu. Sa ndehe ra ñuun, ta quechaha chacu ra cuenda ñivi can, ");
INSERT INTO mioNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ta cati ra ti: ―Cha cua cutuni ini ndo vitin yoso cuhva cua coo mani ndo chi ra Ndioo cuni yu, soco nda vitin ta nda cua nda iti nuun ña cua cuu ca cutuni ini ndo chacan. ");
INSERT INTO mioNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Cua queta quivi cua quichi ñivi cuxaan ini chi ndo ñuun ndo. Cua ticora ñi ñuun ndo, ta cua samondo ñi ñuhun yuhu ñuun, ta ndihi chiyo yu ñuun ndo cua cani tahan ñi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Cua cani ñi ñuun ndo, ta cua ndoyo ñuhun ndihi ndo. Ni iin ca yuu vehe ndo―ña cua ndoo siqui tahan chi tichi ñuun ndo cua savaha ñi, vati ña chito ndo ti ni quichi ra Ndioo ñuun ndo ―cati ra Jesuu cuenda ñivi ñuun Jerusalén can. ");
INSERT INTO mioNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tacan cuu, ta queta ra Jesuu ñuun Jerusalén. Quihvi ra tichi soco ndavi ve ñuhun, ta quechaha tava ndaa ra chi ñivi xico cuati suhva chi ñivi sata chi chi, ");
INSERT INTO mioNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ta cati ra chi ñi ti: ―Cha cati tutu Ndioo ti vehe ra Ndioo cuu iin vehe nu cua cahan ñivi chihin ra, cati chi, soco cha ni savaha maan ndo cha cuu chi iin vehe nu nducuiti run ñasuhu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ndihi ni quivi chahan ra Jesuu ve ñuhun can, ta sacuaha ra chi ñivi can, ta ra sutu chahnu chi ra sacuaha ley chahnu chi ndihi ra chanihin―nanducu ra cuhva cha cua cahni ra ta ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","soco ña chito ra ta ra cha cua savaha ra, vati tasoho xaan ndihi ñivi can cha cahan ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Iin quivi iyo ra Jesuu ve ñuhun, ta sacuaha ra chi ñivi can. Cati tuhun ra tuhun Ndioo chi ñi, ta quichi ra sutu chahnu chi ra sacuaha ley chahnu chi ra chanihin, ");
INSERT INTO mioNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ta quechaha cati ra ta ra chi ra ti: ―Cua cati cun chi ndi ndaa cuu nu ni nihun ndatu cha ni savahun ndihi cuhva can. ¿Yoo chaha ndatu can chihun? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Iyo iin tuhun cua nducu tuhun xihne chihin ndo. Cua cati ndico ndo chihin yu a ni sacuanduta ra Juaan chi ñivi cuenda ra Ndioo iyo iti siqui andivi a sacuanduta ra chi ñi cuenda ñivi ñuñivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tacan cuu, ta quechaha ndatuhun ra ta ra chi tahan ra, ta cati ra ta ra ti: ―Tu cua cati yo ti cuenda ra Ndioo ni sacuanduta ra, cua nducu tuhun ra ñacu ña chinu ini yo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tu cua cati yo ti cuenda ñivi ñuñivi, cua cani ndihi ñivi ya yuu chi yo, vati saxini ñi ti cahan ra cuenda ra Ndioo ―cati ra chi tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chacan cuu cha cati ndico ra ta ra ti ña chito ra yoo chaha ndatu chi ra Juaan can. ");
INSERT INTO mioNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tacan cuu, ta cati ndico ra Jesuu chi ra ta ra ti: ―Ta ni cuhva ña cua cati yu chihin ndo yoo chaha ndatu chihin yu cha ni savahi cuhva can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tacan cuu, ta quechaha cati ra Jesuu cuhva ya chi ñivi can ti: ―Iyo iin rai, ta ni tachi ra yava nu iyo chiqui ra. Chaha ra tiñu chi ra cua satiñu tatun, ta quee iti ra. Nahan xaan ndoo ra nu cuahan ra, ");
INSERT INTO mioNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ta queta quivi tachi ndico ra musu ra nu iyo ra satiñu tatun chi itu can, vati cua cuhva racan suhva chiti can chi ra musu can, soco cani ra ta ra chi ra. Ñahni cha ni chaha ra chi ra, ta tachi ndico ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tacan cuu, ta tachi ra cha vaha can inga musu ra. Ta ni cuhva cani ra ta ra chi ra musu can. Savaha ra ta ra ndavaha ni chi ra, ta tachi ndico ra chi ra, ta ñahni chiti chaha ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tacan cuu, ta inga ndico tucu musu ra tachi ndico ra cha vaha can, soco sanicuehe ra satiñu tatun can chi ra, ta tava ndaa ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Tacan cuu, ta cati ra cha vaha can ti: “Chite ñaan cha cuu cha cua savahi. Cua tachi yu chi ra cuu sehi. Vasi cua sacahnu ra satiñu tatun can chihin ra,” cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tacan cuu, ta ndehe ra satiñu can ti vachi ra cuu sehe ra, ta quechaha ndatuhun ra chi tahan ra. Cati ra ti: “Sehe ra cuu rahya. Na cua cahni yo chi ra, vati tacan ni cua ndoo ndihi ndatiñu ra chi yo,” cati ra chi tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tacan cuu, ta chahni ra ta ra chi ra, ta tava ndaa ra iquin cuñu ra iti chata cora nu satiñu ra. ’Cua cati yu ñaan cha cuu cha cua savaha ra chitoho can. ");
INSERT INTO mioNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cua cuhun ndico ra, ta cua cahni ra chi ra satiñu tatun can, ta cua cuhva ra tiñu can chi inga ra ―cati ra. Sa chini ra fariseo can tuhun ya, ta quechaha cati ra ta ra ti: ―Ña vaha cha tacan ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ta ndehe ra Jesuu chi ra ta ra, ta cati ra ti: ―Cha cati tutu Ndioo cuenda yu ti: Iyo iin yuu, ta cati ra sandaa vehe ti ña vaha chi, soco yuu can cha cuu yuu cahnu tutu vehe. Chacan ni savaha ra chahnu, cati tutu Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tu cua nduva ñivi chata yuu can, cua ndoyo ñuhun ñi. Ta ni cuhva tu cua quehni chi siqui ñivi, cua ndoyo ñuhun ñi. Tacan ni cati ra Jesuu, vati tu ña cua cuinu ini ñivi chi ra, cua ndoyo ñuhun ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Suvi ni hora can cuni ra sacuaha ley chi ra sutu chahnu tiin ra chi ra Jesuu, soco yuhvi ra ta ra chi ñivi can. Cuni ra tiin ra chi ra, vati chito ra ti cuenda ra cahan ra Jesuu tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Cuni ndehe ra ta ra yoso cuhva cua savaha ra. Chacan cuu cha tachi ra ta ra chi ra cua ndehe chi ra Jesuu nu iyo ra. Cuhva ndacu rai vaha savaha ra ta ra, vati cuni ra cuni soho ra cha cua cahan ra Jesuu, soco cuni ra cha cua cahan ra iin cha ndavaha ni, vati tacan, ta sa cua cuhva cuenda ra chi ra chi ra cumi tiñu. ");
INSERT INTO mioNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chacan cuu cha cati ra ta ra chi ra ti: ―Maestru, chito ndi ti vaha xaan cahun. Vaha xaan sacuahun chi ñivi, ta quihin cuenda cun chi ndihi cuii ñivi. Chito ndi ti iin cha ndicha ndicha cati tuhun cun yoso cuhva iyo ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Atu vaha cha cua cuhva ndi xuhun yoo chi ra César ra cumi tiñu ñuun Roma a ña vaha? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tacan cuu, ta nihin ra Jesuu cuhva ti ña vaha ndacu ra ta ra. Chacan cuu cha cati ra chi ra ta ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Cua cuhva ndo iin xuhun chihin yu. ¿Yochi xini ndiso chi? ¿Yochi sivi ndiso chi? ―cati ra. Ta cati ndico ra ta ra ti: ―Xini ra cumi tiñu cahnu ñuun Roma ndiso chi chi sivi ra ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tacan cuu, ta cati ndico ra Jesuu chi ra ta ra ti: ―Na cua cuhva ndo cha cuu chi ra cumi tiñu can chi ra, ta chi ra Ndioo cua cuhva ndo cha cuu chi maan ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Chacan cuu cha ña ni cuu sandoyo ñuhun ra ta ra chi ra Jesuu cuhva cati ndico ra nu iyo ñivi can. Iyo xaan cuni ra ta ra cha cahan ndico ra Jesuu, ta ndoo taxin ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Inga chaha, ta quichi ra saduceo nu iyo ra Jesuu. Suvi ra saduceo can cuu ra cati ti ñahni cha cua natacu ndico ñivi ndii. Quichi racan, ta quechaha cati ra chi ra Jesuu ti: ");
INSERT INTO mioNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestru, nu ni taa ra Moisee tutu cuenda yo iti chata, ta cati ra ti tu cua cuvi iin rai, ta ña ta coo sehe ra chi ñasihi ra, cua quihin yani ra chi ña, ta cua coo ra chi ña, vati tacan sa cua coo sehe ra cha ni chihi, cati ra Moisee. ");
INSERT INTO mioNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Vitin cha iyo ucha ra yani ra ta ra. Tandaha ra chanihin chi ñasihi ra, ta chihi ra. Ñahni sehe ñi ni chacoo, ta chihi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tacan, ta quihin inga ra yani ra chi ña, ta tandaha ra chi ña. Ni chihi tahan ra, ta ñahni sehe ñi ni chacoo. ");
INSERT INTO mioNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tacan ni savaha tahan inga ra, ta chihi tahan ra, ta ñahni sehe ra chacoo. Ta ni cuhva tandaha ndihi ra yani ra ta ra chi ña. Chihi ra ta ra, soco ñahni sehe ra ta ra ni chacoo. ");
INSERT INTO mioNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tacan cuu, ta queta quivi chihi tahan maan ña ñahan can. ");
INSERT INTO mioNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Yochi ñasihi cua cuu ña quivi cua natacu ndico ñivi ndii? Ña chito maan ndi, vati ucha rai cuu ra ni tandaha chi ña ―cati ra saduceo can. ");
INSERT INTO mioNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tacan cuu, ta cati ndico ra Jesuu chi ra ta ra ti: ―Vitin tichi quivi ya tandaha ra rai chi ñi ñahan, ");
INSERT INTO mioNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","soco ñahni cha cua saxini ñivi cuenda chacan quivi cua natacu ndico ñivi ndii, ta cua coo ñivi chi ra Ndioo. Tacan ni cua coo ñivi cha iyo vaha cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Quivi can ña cua cuu ca cuvi ñi, vati cua cuu ñi cuhva iyo ra tatun Ndioo. Sehe Ndioo cua cuu ñi, vati cua natacu ndico ñi tañu ñivi ndii. ");
INSERT INTO mioNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Sanahan tahan ra Moisee chi yo ti natacu ndico ñivi ndii. Nu ni taa ra yoso cuhva cha ni cayu iin cuhu can cati ra ti ra chahnu Ndioo cuu ra ni sacahnu ra Abraham chi ra Isaac chi ra Jacob. Ndihi nduni tahan ra sacahnu chi ra Ndioo, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ña cuu sacahnu ñivi ndii chi ra Ndioo, soco ñivi ni iyo ndito sacahnu chi ra, vati ndihi ñivi cua coo ndito ndico ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tacan cuu, ta cati ndico ra sacuaha ley ti: ―Vaha xaan cahun, maestru. Tacan ni cati ra, ");
INSERT INTO mioNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","vati yuhvi ra ta ra nducu tuhun ca ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tacan cuu, ta cati ra Jesuu chi ra ta ra ti: ―Cati ñivi ti tata ra David cua cuu ra Cristo iti nuun, ");
INSERT INTO mioNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","soco cha ni cati suvi ni ra David cuenda ra Cristo nu tutu Salmo ti: Cati ra chahnu Ndioo chi ra cuu chitoho ra David ti cua cuhva ra ndatu chi ra, vati cua cunda ra chiyo ndaha cuaha ra Ndioo, ta cua cuhva ra tu ndee ini chihin ra, ");
INSERT INTO mioNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ta cua sacanaan ra chi ndihi ñivi cuxaan ini chihin ra, cati ra David iti chata. ");
INSERT INTO mioNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Cati ra David ti chitoho ra chi ra Cristo. Ña cati ra ti ra Cristo can cuu tata ra cha cua quichi iti nuun. Iyo cha cua cati tahan ñivi ti chitoho ra David chi ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nu ni chini ndihi ñivi can, ta quechaha cati ra Jesuu chi ra sacuaha chi ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Na cua saha vaha ndo cuenda yoso cuhva ni ndacu ra sacuaha ley chahnu. Cuni xaan ra caca cuu ra, ta ndichin ra sahma vaha. Cuni xaan ra cha cua sacahnu ñivi chi ra nu chica ra iti nuyahvi. Cuni xaan ra cunda ra tayu vaha ve ñuhun. Ta ni cuhva cuni ra cunda ra tayu vaha nu chachi ñivi, ta sacahnu ñi vico. ");
INSERT INTO mioNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Suhu xaan ra ndatiñu ñi ñahan ndahvi, ta nahan xaan cahan ra chi ra Ndioo, soco vata ra cuhva cahan ra. Cuaha xaan ca cua cutuni ra sacuaha ley can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tacan cuu, ta ndehe ra Jesuu ti tihi ñivi ricu xuhun ñi nu samani ñi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ndehe tahan ra ti tihi tahan iin ña ndahvi uvi xuhun cuati, ");
INSERT INTO mioNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ta quechaha cati ra chi ra ta ra ti: ―Cati yu iin cha ndicha chi ndo, vati tihi ndihi ñican xuhun ñi, soco cuaha xaan ca tihi ña ndahvi can cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tacan cati yu, vati maan ñi samani ñi, ta cuaha xaan ca xuhun ñi iyo, soco maan ña―ñahni cha iyo chi ña, ta chaha ña ndihi cuii xuhun ña ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ni vii cati ra sacuaha chi ra Jesuu ti taqui xaan iyo yuu ve ñuhun, ta taqui xaan savaha ñivi nu samani ñi chi ra Ndioo. Ni vii cahan racan, ta quechaha cati ra Jesuu chi ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ndehe ndo yuu can. Ndehe ndo ve ñuhun can, soco cua queta quivi cua ndoyo ñuhun chi. Cua tani ndihi yuu chi, vati ña cua ndoo ni iin yuu siqui tahan chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tacan cuu, ta quechaha nducu tuhun ra ta ra chi ra ti: ―¿Ndaa quivi cua coo chacan, ta maestru? ¿Ñaan cuhva cua coo, ta sa cua coto ndi ti cha queta quivi cati cun tuhun ya? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ta cati ndico ra Jesuu ti: ―Cua saha ndo cuenda, coto cua sandahyu ñahan ñivi chi ndo. Tuvi ñivi cua quichi, ta cua cahan ñi sivi yu, ta cua cati ñi ti ra Cristo cuu ñi, ta cua cati ñi ti cha ni queta quivi cha cua cundihi quivi ya, cua cati ñi. Ña cua cundicu ndo chi ñican. ");
INSERT INTO mioNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Cua cuni soho ndo cha cua cati ñivi ti cua coo cuati. Cua cani tahan ñivi, cua cati ñi, soco ña cua cuyuhvi ndo. Iyo cha cua coo xihna chacan. Ni cua nducuee ca, ta sa cua cundihi quivi ya. ");
INSERT INTO mioNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","’Cua cani tahan ñivi iyo iin ñuhun chi ñivi iyo inga ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nihin xaan cua taan, ta iyo nu cua coo tama. Iyo nu cua coo cuehe. Yuhvi xaan cua coo ñivi, vati iyo xaan cua coo cuhva iti siqui. ");
INSERT INTO mioNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ni cua cumani ndihi chacan, ta cua tiin xihna ñivi chi ndo, ta cua cani tahan ñi chi ndo. Cua cuhva cuenda ñivi chi ndo chi ra iyo ve ñuhun nu sacahnu ñivi judío. Cua taa ñi chi ndo ve caa. Cua cundaca ñi chi ndo iti nuun ndihi ra cuu cumi tiñu, vati chica ndo cuenda yu. ");
INSERT INTO mioNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chacan cuu cha cua cuhva ndo cuenda yoso cuhva iyo ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ña cua saxini xihna ndo ñaan tuhun cua cati ndico ndo. Ña cua saxini ndo chi anima ndo, ");
INSERT INTO mioNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","vati yuhu cua cuhve cha chini tuni chi ndo. Yuhu cua cuhve ñaan cha cuu cha cua cati ndico ndo, ta ña cua cuu cati ñivi cuni cuati chi ndo ti ña ndicha. Ña cua cuu cahan ca ñi siqui ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Cua cuhva cuenda ñivi ndo chi ndo chi ra cumi tiñu. Cua cuhva cuenda sutu ndo, sihi ndo, yani ndo, cuhva ndo, amigu ndo chi ndo chi ra, ta iyo ndo―cua cahni ñi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Cua cuxaan ini ndihi ñivi chi ndo, vati iyo ndo chihin yu, ");
INSERT INTO mioNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","soco ña cua cuu sandoyo ñuhun ñi anima ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tu cua cundee ini ndo, cua coo ndito ndo chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Cua ndehe ndo ti cua ticora ra sandaru ñuun Jerusalén, ta cua coto ndo ti yatin xaan cua ndoyo ñuhun ñuun can. ");
INSERT INTO mioNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Quivi can na cua cunu ndo―ndaa ndo iyo ñuhun Judea. Na cua cunu ndo iti yucu. Cua quee ndo―ndaa ndo iyo ñuun Jerusalén, ta cua cunu ndo, ta ñivi iyo tichi cuhu―cua quihvi ñi tichi ñuun can. ");
INSERT INTO mioNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tacan ni cua savaha ndo, vati quivi can cua tachi tuni ra Ndioo chi ñivi ñuun Jerusalén can. Tacan ni cua tahan ñuun can cuhva ni taa ra ta ra nu tutu Ndioo nu ni quichi quivi. ");
INSERT INTO mioNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Quivi can cua coo tu ndoho chi ñi ñahan ñuhun sehe. Cua coo tu ndoho chi ñi ñahan iyo ve ni chaxi, vati cahnu xaan tu ndoho cua ndehe ñivi judío iyo ñuhun can, ta xaan xaan cua nduxaan ra Ndioo chi ñi quivi can. ");
INSERT INTO mioNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Cua cuvi ñi chi machete. Cua tiin ra sandaru can chi ñi, ta cua tava ndaa ra chi ñi. Nda cua nda ndihi ñuhun iyo nu ñuhun ñuñivi cua sacuhun ra chi ñi. Cua sandoyo ñuhun cuii ra ñuun Jerusalén can, ta rai cuu inga tucu ñivi iyo inga ñuhun cuu ra sandaru can. Tacan ni cua coo ra nda cua nda cua queta quivi cua quee ndico ra cuhva ni cati ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ni vii cahan ra Jesuu chi ra: ’Cahnu xaan cuhva cua coo iti siqui andivi, vati cua sama ri nicandi, cua sama ri yoo, cua sama ri tiñu cuhva iyo ri. Nu ñuhun ñuñivi ya cua coo xaan tu ndoho chi ndihi ñivi. Cua saxini xaan ñi, vati nihin xaan cua tahnu nu nduta, ta iyo xaan cua sacatin chi. ");
INSERT INTO mioNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Cua cuni ñivi cuvi ñi, vati yuhvi xaan ñi. Cua saxini xaan ñi ñaan cha cuu cha cua coo nu ñuhun ñuñivi ya, vati cua tuñu ri nicandi chi ri yoo chi ndihi ri tiñu. ");
INSERT INTO mioNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tacan, ta cua ndehe ñivi ti vachi ra cuu sehe ñivi tichi vico iti siqui andivi, ta cua coo ndihi cuii tu ndee ini chi ra, ta taqui ndicha ra cua cuu. ");
INSERT INTO mioNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Quivi cua quechaha coo ndihi chacan na cua saxini vaha ndo, vati yatin xaan cua queta quivi cua cacu ndo chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Cati ndico ra Jesuu cuhva ya chi ra ta ra ti: ―Cua saxini ndo yoso cuhva iyo yutun tusihva tiñi chi ndihi ca yutun. ");
INSERT INTO mioNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ndehe ndo ti cana ndaha chi, ta chito ndo ti cha yatin xaan cua coo cha ihni. ");
INSERT INTO mioNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ta ni cuhva cua ndehe ndo ti cua coo chi cuhva cati yu, ta cua coto ndo ti yatin xaan cua coo ñivi chi ra Ndioo nu cua cundaca ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Cati ndicha yu chihin ndo ti ña cua cuvi ñivi iyo vitin, ta sa cua quechaha cundaca ñahan ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cua queta quivi cua naan ñuhun ñuñivi ya chi andivi ya, soco ña cua naan tuhun cha cahin. ");
INSERT INTO mioNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Cua saha vaha ndo cuenda chi ndo, coto cua saxini xaan ndo, ta cua coho ndo, ta cua cuni xini ndo, ta cua saxini xaan ndo yoso cuhva iyo ndo nu ñuhun ñuñivi ya. Cua saha vaha ndo cuenda chi ndo, coto quii xaan cua quichi quivi cua quichi ndico ra cuu sehe ñivi, ");
INSERT INTO mioNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ta ña iyo vaha ndo, vati cuenda ndihi ñivi iyo nini cahnu nu ñuhun ñuñivi ya cua quichi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Cua saxini vaha ndo ndihi ni quivi. Cua cahan ndo chi ra Ndioo ti cua coo tu ndee ini chi ndo, ta cua cacu ndo nu cua coo ndihi tu ndoho can, ta cua queta vaha ndo iti nuun ra cuu sehe ñivi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Chinucahni sacuaha ra Jesuu chi ñivi ve ñuhun, ta cha cuaa quee ra cuahan ra iti yucu Olivo. ");
INSERT INTO mioNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nahan xaan cuahan ndihi ñivi nu iyo ra ve ñuhun, vati cuni ñi tasoho ñi tuhun cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yatin xaan cua coo vico paan ña ndaa. Suvi ni vico can cuu vico pascua, cati ñivi, vati quivi can ni cacu ñivi ñi ñuhun Egipto tiempu chahnu cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tacan cuu, ta nanducu ra sutu chahnu chi ra sacuaha ley chahnu cuhva cha cua cahni ra ta ra chi ra Jesuu, soco yuhvi xaan ra ta ra chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tacan cuu, ta quichi coo run Satanaa chi ra Juda Iscariote can, ta iin ra tatun Jesuu cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Chacan cuu cha quee ra cuahan ra, ta quechaha cahan ra chi ra sutu chahnu chi ra cuu xini chi ra sandaru ve ñuhun. Ndatuhun ra ta ra yoso cuhva cua xico tuhun ra Juda can chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Chacan cuu cha quechaha cusii ini ra ta ra, ta cati ra ta ra ti cua cuhva ra xuhun chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ndoo ra Juda can vaha, ta quechaha nducu ra cuhva cha cua cuhva cuenda ra chi ra Jesuu chi ra ta ra, ta cuni ra cuhva cuenda ra chi ra nu ña cua ndehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tacan cuu, ta queta quivi cha sacahnu ñivi vico paan ña ndaa can, ta chahni ñi ta ñi iin ri mbee cuenda cha ni cacu ñivi ñi tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tacan cuu, ta tachi ra Jesuu chi ra Pedro chi ra Juaan nu cua sacahnu ra vico can, ta cati ra chi ra ta ra ti: ―Cuahan ndo, vati cua tiso vaha ndo nu cua cachi yo, ta cua sacahnu yo vico ya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ta nducu tuhun ra ta ra chi ra ti: ―¿Ndaa cuu nu cuni cun cha cua tiso vaha ndi? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ta cati ndico ra Jesuu ti: ―Cua quihvi ndo ñuun, ta sa cua natahan ndo chi iin rai ndiso quii nduta. Cua cu ndicu ndo chi ra, ta vehe nu cua quihvi ra cua tiso vaha ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Cua cati ndo chi ra xu vehe can ti cha nducu tuhun ra maestru ndaa iyo nu cua sacahnu ra vico ya chi ra sacuaha chihin ra, cua cati ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tacan, ta sa cua sanahan ra iin vehe cahnu iyo nda siqui nu iyo mesa nu iyo tayu. Tican cua tiso vaha ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tacan cuu, ta quee ra Pedro chi ra Juaan, ta cuahan ra ta ra. Ni tahan ra ta ra cuhva cati ra Jesuu, ta ni tiso vaha ra ta ra nu cua sacahnu ra vico can. ");
INSERT INTO mioNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tacan cuu, ta queta hora cha cua cachi ra ta ra, ta tuhva ra Jesuu chi ndihi ra tatun ra yu mesa, ");
INSERT INTO mioNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ta quechaha cati ra chi ra ta ra ti: ―Cuni xain sacahnu yu vico ya chihin ndo, ta cua cachi yo icaa ni, ta sa cua cu ndehi tu ndoho, ta cua cuvi yu. ");
INSERT INTO mioNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chahi cuenda chi ndo ti ña cua sacahnu que vico ya nda cua nda quivi cua coo yo icaa ni nu cua cundaca ñahan ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tacan cuu, ta quihin ra iin copa, ta chaha ra iin tiahvi ndioo chi ra Ndioo, ta cati ra ti: ―Quihin ndo copa ya, ta cua coho ndihi ndo chi chi. ");
INSERT INTO mioNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chahi cuenda chi ndo ti ña cua coho que nduxi chiti uva ya nda vitin ta nda cua nda quivi cua cundaca ñahan ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tacan cuu, ta quihin ra iin paan. Chaha ndico tucu ra inga tiahvi ndioo chi ra Ndioo, ta natahvi ra paan can, ta chaha ra chi chi chi ra ta ra, ta cati ra ti: ―Paan ya cuu cuñu yu, vati cua cuvi yu cuenda ndo. Tehen ni cua savaha ndo, ta ña cua naan ini ndo chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Cha ndihi chachi ra ta ra, ta tacan ni savaha tahan ra chi copa can, ta cati ra ti: ―Copa ya cua coho ndo, vati cha iyo vaha iin tuhun chaa chi ra Ndioo, vati cua cati yu niñi yu, ta cua cuvi yu cuenda ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Iyo ra cua xico tuhun chihin yu, ta icaa ni chachi ra chihin yu mesa ya. ");
INSERT INTO mioNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Cua tahan ra cuu sehe ñivi cuhva ni cati ra Ndioo, soco cua coo tu ndoho chi ra cua xico tuhun chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tacan cuu, ta quechaha nducu tuhun ra ta ra chi tahan ra ndaa ra cuu ra cua xico tuhun chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Inga hora, ta quechaha cahan yuhu ra tatun ra chi tahan ra ndaa ra cuu rai cahnu ca. ");
INSERT INTO mioNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tacan cuu, ta quechaha cati ra Jesuu chi ra ta ra ti: ―Ndurai xaan ra cumi tiñu cha ndaca ñahan ra chi ñivi nu ñuhun ñuñivi ya, ta cati ñivi ti vaha xaan tindee ra chi ñi, ");
INSERT INTO mioNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","soco ñavi tacan cua coo maan ndo. Ndaa ndo cuu rai cahnu ca―cua tindee ndo chi ra luhu ca. Ndaa ndo cuu xini―cua tindee ndo chi ra cuu musu. ");
INSERT INTO mioNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Rai cha cuu cha cahnu ca―racan cuu ra ndaa yu mesa, ta ra luhu ca cuu ra sayaha xita. Tacan ni iyo ñivi ñuñivi, soco iye chi ndo, ta cui sava ni ta cua iin ra sayaha xita, vati tindei chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Cha inda naan ndo chihin yu, ta ndehi tu ndoho nu quichi quivi ya. ");
INSERT INTO mioNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Cua cuhve tiñu chi ndo cuhva cha ni chaha ra suti tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Chacan cuu cha cua coo ndo chihin yu icaa ni nu cua cundaca ñahin, ta cua cuiso tahan ndo tiñu, vati cua cundaca ñahan tahan ndo chi ñivi Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tacan cuu, ta quechaha cati ra Jesuu chi ra Pedro ti: ―Moon, cha nducu tuhun run Satanaa chi ndo, vati cuni ndehe run a ña cua savaha ndo cuati. ");
INSERT INTO mioNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Cha cahin chi ra Ndioo cuenda maun, vati ña cua saña cun cha chinu ini cun chi ra. Cua saña ihni ndico cun ndavaha ni cua savahun, ta sa cua cuhva cun tu ndee ini chi ra yani cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ta cati ra Pedro chi ra ti: ―Ra chahnu, cha iyo ini yu cha cua cuhin chihun ve caa, ta cua cuvi tahin chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ta cati ndico ra Jesuu chi ra ti: ―Pedro, cati yu chihun ti ña cua ndahyu nahan ri chitoho vitin nda cua nda cua cati cun uni hora ti ña nacoto cun chihin yu, ta sa cua ndahyu ri ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tacan cuu, ta quechaha nducu tuhun ra Jesuu chi ra ta ra ti: ―Nu ni quichi quivi ni tava tiñu yu chihin ndo, ta ña chahi cha cua cuiso ndo xuhun. Ña chahi cha cua cuiso ndo yunu. Ña chahi cha cua cunda chaha ndo. Ña chahi. ¿Atu iyo cha ni cumani chi ndo quivi can? ―cati ra. Ta cati ndico ra ta ra ti: ―Ñahni cha ni cumani chi ndi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ta cati ndico tucu ra Jesuu chi ra ta ra ti: ―Vitin cua cuiso ndo xuhun. Cua cuiso ndo yunu. Tu ñahni machete ndo iyo, na cua xico ndo sahma ndo, ta cua sata ndo iin chi. ");
INSERT INTO mioNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Cati yu chi ndo ti cua coi cuhva ni cati tutu Ndioo cuenda yu, vati cati chi ti icaa ni cua coo ra chi ra savaha ndavaha ni, cati chi, vati tacan ni cua tahin cuhva cha iyo tuhun cuenda yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ta cati ndico ra ta ra ti: ―Ra chahnu, ¡jihna! Ihya cha iyo uvi machete ―cati ra. Ta cati ndico ra Jesuu ti: ―Cha iyo vaha cha tacan ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tacan cuu, ta quee ra Jesuu cuahan ra. Cuhva iyo costumbre ra cuahan ra iti yucu Olivo, ta cuahan tahan ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tacan cuu, ta queta ra nu cuahan ra, ta quechaha cati ra chi ra ta ra ti: ―Cua cahan ndo chi ra Ndioo, vati ña cua quehni cava ndo nu cua savaha ndo ndavaha ni ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tacan cuu, ta quee siin ra iin chiyo. Ña cani cuahan ra, ta chahnu chiti ra, ta quechaha cahan ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Cati ra ti: ―Tata, tu cua cuni cun, cua sanaun tu ndoho cua tahin vitin, soco cua savahun cuhva cuni maun. Ña cua savahun cuhva cuni yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tacan cuu, ta quichi iin ra tatun Ndioo iti siqui andivi, ta chaha ra tu ndee ini chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iyo ra Jesuu chi tu ndoho. Chacan cuu cha nihin xaan ca cahan ra chi ra Ndioo. Quee xaan tiin ra, ta quehni chi nu ñuhun. Cuhva too niñi too chi, vati tiin xaan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tacan cuu, ta ni chacuinda ra nu ni cahan ra chi ra Ndioo, ta cuahan ndico ra nu iyo ra sacuaha chi ra. Ndehe ra ti quixi ra ta ra, vati cuihya xaan cuni anima ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ta quechaha cati ra chi ra ta ra ti: ―Ña cua cusu ndo. Ndoyo ndo, ta cahan ndo chi ra Ndioo. Chacan cuu cha ña cua quehni cava ndo nu cua savaha ndo ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ni vii cahan ra Jesuu, ta quichi ñivi. Tuvi ñivi cuu ñi, ta quichi ndaca ra Juda ra cuu tatun Jesuu chi ñi, ta tuhva ra nu inda ra Jesuu, ta taa yuhu ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tacan cuu, ta quechaha cati ra Jesuu chi ra ti: ―Juda, taa yuhu cun chihin yu ra cuu sehe ñivi, ta xico tuhun cun chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ndehe ra inda naan chi ra Jesuu ñaan cha cuu cha cua savaha ñivi can, ta quechaha nducu tuhun ra ta ra chi ra ti: ―¿Atu cua cani ndi chi ñi chi machete ndi, ta ra chahnu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tacan cuu, ta cani iin ra chi ra cuu musu ra sutu chahnu, ta laxin cuii chahnda ra soho chiyo cuaha ra, ");
INSERT INTO mioNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ta cati ra Jesuu ti: ―Saña ndo. Cha iyo vaha ―cati ra. Tacan cuu, ta tiso ra Jesuu ndaha ra soho ra musu can, ta sanduvaha ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ta quechaha cahan ra Jesuu chi ndihi ñi quichi nu iyo ra. Cahan ra chi ra sutu chahnu chi ra sandaru ve ñuhun chi ra chanihin ta ra. Cati ra chi ra ta ra ti: ―Vachi ndo, ta naan ndo machete. Naan ndo garote. Naan ndo, ta cua tiin ndo chihin yu cuhva tiin ndo chi rai cuni cahni suhu. ");
INSERT INTO mioNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ndihi ni quivi iye chi ndo ve ñuhun, ta ña tiin ndo chihin yu, soco cuu vitin. Iyo tu ndee ini chi ndo, vati naan xaan vitin ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tacan cuu, ta tiin ra ta ra chi ra Jesuu, ta quee ra cuahan ra. Chandaca ra ta ra chi ra vehe ra sutu chahnu, ta cuahan tahan ra Pedro ndicu chica ni ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tacan cuu, ta satahan tahan ra ta ra ñuhun nda mahñu tihyo ra sutu chahnu can, ta ndaa tahan ra ta ra. Tacan cuu, ta tuhva ra Pedro, ta ni chacunda tahan ra nu iyo ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ndaa ra Pedro nu cayu ñuhun can, ta ndehe iin ña musu chi ra. Nihin xaan ndehe ña chi ra, ta quechaha cati ña ti: ―Chica tahan rahya chi ra ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ta cati ndico ra Pedro ti: ―Ña nacote chi ra, sihi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ña nahan, ta ndehe iin rai chi ra, ta cati ra chi ra ti: ―Cha chica tahun chi ra ta ra ―cati ra. Ta cati ndico ra Pedro ti: ―Ña ndicha, xaa ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Cha yaha inga hora, ta cati ndico tucu inga ra chi ra ti: ―Ndicha ndicha chica rahya chi ra, vati rai ñuhun Galilea cuu tahan ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ta cati ndico ra Pedro ti: ―Ña chite ñaan cha cahun, xaa. Ni vii cahan ra Pedro tuhun can, ta quechaha ni ndahyu ri chitoho. ");
INSERT INTO mioNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tacan cuu, ta ndico coo ra chahnu Jesuu, ta ndehe ra chi ra Pedro, ta ni chacuhun ini ra Pedro can tuhun ni cahan ra chahnu chi ra, vati cha cati ra chi ra ti uni hora cua cati ra ti ña nacoto ra chihin ra, ta sa cua ndahyu ri chitoho quivi can, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tacan, ta quee ra Pedro cuahan ra. Chacu xaan ra, ta cuihya xaan cuni anima ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iyo ra sacuenda chi ra Jesuu, ta sacateni ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Chasi ra ta ra nuun ra, ta cani ra chi ra. Tacan cuu, ta cati ra ta ra chi ra ti: ―Cua cati cun vitin. ¿Yoo cani chihun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tacan cuu, ta cuaha xaan ca ndavaha ni cahan ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cha vachi cundichin, ta nducuiti ra chanihin. Nducuiti ndihi ra sutu chahnu chi ra sacuaha ley chahnu, ta quichi ndaca ra ta ra chi ra Jesuu nu nducuiti ra ta ra, ta cati ra ta ra chi ra ti: ");
INSERT INTO mioNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Cua cati cun, tu ndicha ti tava tiñu ra Ndioo chihun, ta ra Cristo cuun ―cati ra ta ra. Ta cati ndico ra Jesuu ti: ―Tu cua cati yu chihin ndo, ña cua cuinu ini ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tu cua nducu tuhun yu iin tuhun chi ndo, ña cua cahan ndico ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nda vitin ta nda cua nda iti nuun cua coo ra cuu sehe ñivi chi ra Ndioo, ta cua cuhva ra Ndioo ndatu chi ra, vati iyo tu ndee ini chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tacan cuu, ta quechaha cati ra ta ra chi ra ti: ―Tu tacan, yoho cuu sehe Ndioo ―cati ra ta ra. Ta cati ndico ra Jesuu ti: ―Suvi yu cui cuhva cati ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tacan, ta cati ra ta ra chi tahan ra ti: ―Ña cua cuni ñuhun ca yo testigu, vati cha chini soho yo cuhva ni cati ra ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tacan cuu, ta ni chacuinda ndihi ra ta ra, ta chandaca ra ta ra chi ra Jesuu nuun ra Pilato. ");
INSERT INTO mioNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tacan, ta quechaha tiso ra ta ra cuati ra Jesuu, ta cati ra ta ra ti: ―Ni ndehe ndi ti sandahyu ñahan rahya chi ñivi ñuun ndi. Ña chaha ra cha cua cuhva ndi xuhun yoo chi ra cumi tiñu ñuun Roma, ta cati ra ti maan ra cuu ra Cristo, ta cua cundaca ñahan ra chi ndi ―cati ra ta ra chi ra Pilato. ");
INSERT INTO mioNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tacan cuu, ta quechaha nducu tuhun ra Pilato chi ra Jesuu ti: ―¿Atu maun cuu ra ndaca ñahan chi ñivi judío? ―cati ra. Ta cati ndico ra Jesuu ti: ―Cha cati maun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tacan cuu, ta cati ra Pilato chi ra sutu chahnu chi ñivi can ti: ―Ñahni cuati savaha rahya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tacan cuu, ta nihin xaan ca cati ra ta ra ti: ―Cha sandusaca ra chi ñivi. Nini cahnu ñuhun Judea cha sacuaha ra chi ñivi, ta sandusaca ra chi ñi nda ñuhun Galilea ta nda cua nda ihya ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chini ra Pilato tuhun Galilea can, ta quechaha nducu tuhun ra atu rai ñuhun Galilea cuu ra, cati ra, ");
INSERT INTO mioNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ta cati ndico ra ta ra ti suvi ra cuu ra. Chacan cuu cha tachi ra Pilato chi ra Jesuu nuun ra Herode, vati iyo ra ñuun Jerusalén quivi can, ta tiñu maan ra cuu chi, vati ndaca ñahan ra ñuhun Galilea can. ");
INSERT INTO mioNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tacan cuu, ta yaha ra Jesuu iti nuun ra Herode can, ta sii xaan cuni ra Herode, vati nahan xaan cuni ra ndehe ra chi ra Jesuu, vati chini xaan ra tuhun yoso cuhva ni savaha ra Jesuu. Saxini ra ti vasi cua savaha ra Jesuu iin cuhva. ");
INSERT INTO mioNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Chacan cuu cha cuaha hora nducu tuhun xaan ra Herode chi ra, soco ñahni cha cahan ndico ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Inda tahan ra sutu chahnu chi ra sacuaha ley chahnu. Tiso xaan ra ta ra cuati ra Jesuu, ta nihin xaan cahan ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tacan cuu, ta cuaha xaan ndavaha ni savaha ra Herode chi ra Jesuu. Ta ni cuhva savaha ra sandaru iyo chi ra Herode ndavaha ni chi ra. Sacateni xaan ra ta ra chi ra, ta sacundichin ra ta ra sahma taqui vaha chi ra, ta tachi ndico ra Herode chi ra nuun ra Pilato. ");
INSERT INTO mioNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tacan cuu, ta quechaha cuu ra Herode amigu chi ra Pilato quivi can, vati nu ni quichi quivi can xaan ini tahan ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tacan cuu, ta cana ra Pilato chi ra sutu chahnu chi ra chanihin chi ndihi ñivi, ");
INSERT INTO mioNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ta quechaha cati ra chi ñi ti: ―Cha quichi ndaca ndo chi rahya iti nuin, ta cati ndo ti cha sandusaca ra chi ñivi. Cha nducu tuhun xain chi ra iti nuun ndo, ta ñahni cuati ra nanihin yu cuhva cati maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ta ni cuhva ñahni cuati ra nanihin ra Herode, vati ni tachi ndico ra chi ra chi ndi. Ñahni cha ni savaha ra, ta cua cuvi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chacan cuu cha cua cani yu chi ra, ta cua sañe chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Cuhva iyo costumbre ra iyo cha cua saña ra cumi tiñu can iin ra indi ve caa tichi vico can. ");
INSERT INTO mioNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sandihi cati ra Pilato tuhun ti cua saña ndico ra chi ra Jesuu, ta ndihi ñican quechaha cuvaa ñi. Cati ñi ti: ―¡Cua quee ndaa ra Jesuu! ¡Chi ra Barabaa cua saña cun! ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ta ra Barabaa can―cha sandusaca ra chi ñivi ñuun can, ta cani tahan ra chi ra cumi tiñu can, ta chahni ra chi ñivi. Chacan cuu cha ndaa ra ve caa. ");
INSERT INTO mioNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Cahan ndico tucu ra Pilato chi ñi inga chaha, vati cuni ra saña ndico ra chi ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","soco nihin xaan cuvaa ndico ñi, ta cati ñi ti: ―¡Cua cahni cun chi ra nu cruu! ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Inga ndico tucu chaha cha cuu uni chaha cati ndico tucu ra Pilato chi ñi ti: ―¿Ñaan cha cuu ndavaha ni cha ni savaha rahya? Ñahni cuati ni savaha ra, ta cua cuvi ra. Chacan cuu cha cua cani yu chi ra, ta sa cua sañe chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tacan cuu, ta nihin xaan cuvaa ndico ñi, ta cati ñi ti cua cahni ra chi ra nu cruu, ta cundee ñi cuhva cha cahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tacan cuu, ta saxini ra Pilato ti cua savaha ra cuhva cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chacan cuu cha saña ra chi ra ni chacuindi ve caa―ra ni sandusaca, ta ni chahni ra chi ñivi, vati chi maan ra Barabaa can cuni ñivi, soco chi ra Jesuu savaha ra cuhva cuni ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tacan cuu, ta chandaca ra ta ra chi ra Jesuu nu cua cahni ra chi ra. Hora can quichi iin ra nani Simón, ta ra ñuun Cirene cuu ra. Iti chiqui quichi ra, ta tiin ra ta ra chi ra, vati cua cuiso ra cruu savaha ra ta ra, ta iti chata ra Jesuu chica ra Simón can. ");
INSERT INTO mioNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tuvi xaan ñivi cuahan ndicu chi ra Jesuu. Cani ñi ñahan can pechu ñi, ta ndahyu chaa ñi, vati ndahvi xaan cuni anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tacan cuu, ta ndehe ra Jesuu chi ñi, ta cati ra ti: ―Ndioho ñahan ñuun ya, ña cua ndahyu ndo cuenda yu. Cua ndahyu ndo cuenda maan ndo cuenda sehe ndo, ");
INSERT INTO mioNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","vati cua queta quivi cua ndehe ndo tu ndoho chi sehe ndo, ta cua cati ndo ti sii cuni ñi ñahan cha ñahni sehe, cua cati ndo, ");
INSERT INTO mioNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ta quivi can cua cuni ndihi ndo ti cua quehni yucu can siqui ndo, ta cua cuvi ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tacan ni cati yu, vati ndehe ndo cha tahan yuhu, ta ñahni cuati yu iyo. Chacan cuu cha cahnu xaan ca tu ndoho cua coo chi maan ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Chandaca tahan ra ta ra chi inga uvi ra, vati cua cahni tahan ra ta ra chi ra, vati cahnu xaan cuati cha ni savaha ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tacan cuu, ta queta ra ta ra nu nani chi nu cuecu iquin xini ndii, ta tican taa ra ta ra chi ra Jesuu nu cruu. Ta ni cuhva taa tahan ra ta ra chi uvi ra ni savaha ndavaha ni can. Iin ra taa ra ta ra chiyo ndaha cuaha ra Jesuu, ta inga ra taa ra ta ra chiyo ndaha satin ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tacan cuu, ta quechaha cati ra Jesuu chi ra Ndioo ti: ―Tata, na cua cucahnu ini cun chi ra ta ra, vati ña chito ra ñaan cha cuu cha ndacu ra ―cati ra. Tacan, ta quechaha siqui ra sandaru ta ra chi yuu cuati, vati cua ndehe ra yoo ra cua sacanaan, ta cua quihin ra sahma ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ta ñivi can―inda ñi. Ndehe ñi, soco cahan cateni ra chanihin ta ra. Cati ra ta ra cuenda ra Jesuu ti: ―Cha ni sacacu ra chi ñivi. Na cua sacacu tahan ra chi maan ra, tu ndicha ti ni tava tiñu ra Ndioo chi ra, ta ra Cristo cuu ra ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sacateni tahan ra sandaru chi ra Jesuu, vati tuhva ra nu ndaa ra nu cruu, ta chaha ra vinu ndahvi chi ra, ");
INSERT INTO mioNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ta cati ra chi ra ti: ―Tu ndicha ti cua cundaca ñahun chi ñivi judío can, na cua sacacu cun chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ndaa iin tutu xini cruu can, ta ndiso chi tuhun ya ti: “Rahya cuu ra ndaca ñahan chi ñivi judío,” cati chi. Uni tuhun ndiso chi, vati iin chi cuu tuhun griego, ta iin chi cuu tuhun latín, ta iin chi cuu tuhun hebreo. ");
INSERT INTO mioNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nduni tahan ra ndaa ra nu cruu, ta quechaha cahan iin ra ndavaha ni chi ra Jesuu. Cati ra ti: ―Tu ndicha ti ra Cristo cuun, na cua sacacu cun chihun, ta na cua sacacu tahun chi ndi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tacan cuu, ta nduxaan inga ra chi racan, ta cati ra chi ra ti: ―Ña yuhvi cun chi ra Ndioo, ta ini tu ndoho tahun tahan rahya. ");
INSERT INTO mioNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Vaha cha tahan yo tu ndoho ya, vati cha ni savaha yo ndavaha ni, soco ñahni ndavaha ni savaha maan ra ―cati ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tacan cuu, ta cati ra chi ra Jesuu ti: ―Yoho Jesuu, na cua cucuhun ini cun chihin yu hora cua nihun tiñu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ta cati ndico ra Jesuu ti: ―Cati yu iin cha ndicha chihun ti vitin quivi ya cua coun chihin yu iti siqui andivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Cha hora cuu chi, ta naan xaan cuu nini cahnu ñuhun can nda cua nda caa uni cha cua ini, ");
INSERT INTO mioNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","vati ndunaan nuun ri nicandi, ta ndata sava sahma ndita caa ve ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tacan cuu, ta nihin xaan cana chaa ra Jesuu, ta cati ra ti: ―Tata, chaha cuenda yu anima yu chihun. Tuhun can ni cahan ra Jesuu, ta ni chihi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ndehe ra cuu xini chi ra sandaru can ñaan cha cuu cha ni chacoo, ta quechaha sacahnu ra chi ra Ndioo, ta cati ra ti: ―Ndicha ti ñahni cuati savaha rahya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ndehe ndihi ñivi nducuiti tican ñaan cha ni tahan ra, ta quee ñi cuahan ñi. Cani ñi pechu ñi, vati cuihya xaan cuni anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Cha chica vihi ni chacuinda ndihi amigu ra Jesuu. Suvi ni tican ni chacuinda tahan ñi ñahan ni quichi chi ra iti ñuhun Galilea, ta ndehe tahan ñi cha ni tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Iyo iin rai nani José, ta ñuun Arimatea cha iyo cuenda ñuhun Judea cuu ñuun ra. Mandoni cuu ra, ta rai vaha ndicha cuu ra. Ña nduinuun ra chi ndihi ca ra chanihin ta ra cuhva ni savaha ra ta ra chi ra Jesuu. Suvi ra José can cuni ra coo ra chi ra Ndioo nu cua cundaca ñahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chahan racan nuun ra Pilato, ta ni chica ra iquin cuñu ra Jesuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tacan cuu, ta ni sanuun ra iquin cuñu ra nuun cruu can, ta ni tituvi ra sahma yaxin vaha chi ra. Tacan cuu, ta tihi ra iquin cuñu ra tichi yavi yuu, ta ña ta cuchi ñivi nu ni cuchi ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tican tihi ra chi ra, vati cha yatin cua cuu chi quivi sábadu, ta iyo cha cua cunda tatun ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Chahan tahan ñi ñahan quichi chi ra Jesuu iti ñuhun Galilea. Ndicu ñi chi ra José, ta ndehe ñi nu ni cuchi ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tacan cuu, ta cuahan ndico ñi tichi ñuun, vati cua tiso vaha ñi cha vixin chahan cha cua cu cuhu ñi iquin cuñu ra. Tacan cuu, ta ni chacunda tatun ñi quivi sábadu can cuhva cati ley chahnu. ");
INSERT INTO mioNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tuvi inga quivi cha cuu domingu. Ni nahan vihi, ta quee ñi ñahan can cuahan ñi. Nu ni cuchi ra Jesuu cuahan ñi, ta ndiso ñi cha vixin chahan cha ni tiso vaha ñi, ta cuahan tahan inga ñi ñahan. ");
INSERT INTO mioNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Queta ñi tican, ta ndehe ñi ti cha sico tuvi ñivi yuu ndasi yuhu yavi yuu can. ");
INSERT INTO mioNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Quihvi ñi iti tichi, soco ña ni nihin ñi iquin cuñu ra chahnu Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ña nihin ñi cuhva ñaan cha cuu chi, ta ndehe ñi ti indi uvi rai iin chiyo xiin ñi, ta nda cua tachan sahma ndichin ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yuhvi xaan ñi ta ñi, ta ndehe ñi nu ñuhun, ta quechaha cati ra rai can chi ñi ti: ―Ña vaha cha nanducu ndo chi ra Jesuu nu ni cuchi ndii, ta rai ndito cuu ra. Ña iyo ca ra ihya, vati cha ni natacu ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Cua cucuhun ini ndo yoso cuhva ni cati ra chihin ndo, ta ni vii iyo ra iti ñuhun Galilea. ");
INSERT INTO mioNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Quivi can cati ra ti cua xico tuhun ñivi chi ra cuu sehe ñivi, ta cua tiin ñivi ndavaha ni chi ra. Tacan, ta sa cua cuvi ra nu cruu, ta cua yaha uni quivi, ta cua natacu ndico ra, cati ra Jesuu ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tacan cuu, ta ni chacuhun ini ñi tuhun ni cahan ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Quee ñi tichi yuu can, ta cuahan ñi nu iyo cuiti ndihi uchi iin ra tatun Jesuu chi ndihi ca ñivi can, ta chaha ñi cuenda ndihi cha ni tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ta ña María Magdalena chi ña Juana chi ña María sihi ra Jacobo chi inga ñi ñahan can cuu ñi chaha cuenda chi ra tatun ra ñaan cha ni tahan ñi, ");
INSERT INTO mioNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","soco saxini ra ta ra ti ña chito ñi ñaan cha cahan ñi, ta ña chinu ini ra ta ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tacan cuu, ta chacuinda ra Pedro. Quee ra chinu ra, ta cuahan ra nu iyo yuu nu ni cuchi ra Jesuu. Ndehe ra iti tichi, ta ndehe ra ti caa siin sahma cha ni chacuituvi ra. Tacan cuu, ta cuahan ra iti vehe ra, ta iyo xaan cuni ra. Ña nihin ra cuhva ñaan cha cuu cha ni chacoo. ");
INSERT INTO mioNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tacan cuu, ta ini quivi can quee iti uvi ra, ta cuahan ra iti ñuun nani Emauu. Vasi queta uvi hora, ta cua queta ra tican cha ni quee ra ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tacan, ta ndihi tuhun cha ni tahan ra Jesuu quivi can ndatuhun ra ta ra nu cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nu ni ndatuhun ra chi tahan ra, ta suvi ra Jesuu tuhva nu cuahan ra ta ra, ta icaa ni cuahan ra chi ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","soco ña chaha ra Ndioo cha ndundichin vaha ndehe ra ta ra. Chacan cuu cha ña nacoto ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tacan cuu, ta quechaha nducu tuhun ra Jesuu chi ra ta ra ti: ―¿Ñaan tuhun cuu cha ndatuhun ndo iti nu cuahan ndo? ¿Ñacu ña sii cuni ndo? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tacan cuu, ta cati ndico iin ra nani Cleofa ti: ―¿Atu iyo maun ñuun Jerusalén, ta ña chito cun ñaan cha cuu cha ni chacoo tichi quivi ya, vati chito ndihi ñivi? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ta cati ndico ra Jesuu ti: ―¿Ñaan cha cuu cha ni chacoo? ―cati ra. Ta cati ra ta ra chi ra ti: ―Ña chito cun ñaan cha ni tahan ra nani Jesuu ra ñuun Nazaret. Ni cahan ra cuenda ra Ndioo, ta cahnu xaan cuhva ni savaha ra. Taqui xaan tuhun cahan ra chi ñivi iti nuun ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Cha ni tiin ra sutu chahnu chi ra chanihin ta ra chi ra, ta ni chaha cuenda ra ta ra chi ra chi ra cumi tiñu, ta ni cati ra ti cua cuvi ra, ta ni chahni ra chi ra cha ni taa ra chi ra nu cruu. ");
INSERT INTO mioNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Cha saxini ndi ti maan ra cuu ra cua quichi, ta cua sacacu ra chi ndi chi ndihi ñivi judío nu iyo ndi chi tu ndoho, ta vitin cha queta uni quivi cha ni yaha chacan. ");
INSERT INTO mioNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ta iyo xaan cuni ndi cha cahan uvi ñi ñahan tahan ndi, vati ni nahan vihi ni chahan ñi nu ni cuchi ra, ");
INSERT INTO mioNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ta ña nihin ñi iquin cuñu ra. Quichi ndico ñi, ta cati ñi ti ndehe ñi chi uvi ra tatun Ndioo, ta cati ra ti ni iyo ndito ndico ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tacan ni cuu, ta chahan tahan uvi ra tahan ndi nu ni cuchi ra, ta ndehe tahan ra cuhva ni cati ñi ñahan can, soco ña ni ndehe ra chi ra Jesuu ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tacan cuu, ta cati ra Jesuu chi ra ta ra ti: ―Ñahni cha chini tuni iyo chi ndo. Tondo xaan xini ndo. Cuee xaan, ta chinu ini ndo ndihi cha ni cati ra ni cahan cuenda ra Ndioo nu ni quichi quivi. ");
INSERT INTO mioNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Iyo cha cua ndehe xihna ra Cristo tu ndoho can, ta sa cua quihvi ra nu iyo ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tacan cuu, ta quechaha sanducachin ra Jesuu ndihi tuhun iyo nu tutu Ndioo cuenda ra. Chaha ra cuenda chi ra ta ra, ta quechaha cati tuhun ra yoso cuhva cha ni taa ra Moisee nda cua nda ni queta ra nu iyo tuhun cha ni taa ndihi ra ni cahan cuenda ra Ndioo nu ni quichi quivi ya. ");
INSERT INTO mioNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tacan cuu, ta cha cua queta ra ta ra nu cuahan ra, ta savaha ra Jesuu ta iin cha cua yaha ra iti nuun ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","soco sanini ra ta ra chi ra ti cua ndoo nuun ra chi ra ta ra, ta cati ra ta ra chi ra ti: ―Cua ndoo nuun cun chi ndi, vati cha ni chiso nicandi, ta cua cuaa vitin ―cati ra ta ra. Tacan cuu, ta quihvi ra Jesuu chi ra ta ra, vati cua ndoo nuun ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Cha iyo ra ta ra yu mesa, ta quihin ra Jesuu iin paan, ta chaha ra iin tiahvi ndioo chi ra Ndioo, ta natahvi ra chi chi, ta chaha ra chi chi chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tacan cuu, ta quechaha ndundichin vaha ndehe ra ta ra. Nu ni nacoto vaha ra cha ra Jesuu cuu ra, ta naan ihni ni ra nu iyo ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Quechaha cati ra chi tahan ra ti: ―Vaha xaan cuni anima yo, ta cahan ra nu quichi yo nu ni sanducachin ra tutu Ndioo chi yo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tacan cuu, ta ni chacuinda ndico ra ta ra suvi ni hora can, ta cuahan ndico ra ta ra iti ñuun Jerusalén, ta nihin ra ta ra chi ra tatun ra Jesuu nu iyo cuiti ra chi ñivi tahan ra, ");
INSERT INTO mioNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ta quechaha cati ra ta ra chi ñi ti: ―Cha ndicha ti natacu ndico ra chahnu, ta ndehe ra Simón chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tacan cuu, ta chaha ra ta ra cuenda ñaan cha cuu cha ni tahan ra ta ra iti. Chaha ra ta ra cuenda yoso cuhva ni quechaha nacoto ra chi ra Jesuu nu ni tahvi ra paan. ");
INSERT INTO mioNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ni vii chaha ra ta ra cuenda chi ñivi tahan ra, ta cha quihvi ra Jesuu nda mahñu nu iyo cuiti ñi, ta quechaha cati ra Jesuu chi ñi ti: ―Na cua coo vii ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tacan cuu, ta yuhvi xaan yuhvi xaan cuni ñi cha ndehe ñi chi ra Jesuu. Saxini ñi ti xiñahñu ndii cuu ra, ");
INSERT INTO mioNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ta quechaha cati ndico ra Jesuu chi ñi ti: ―Ña vaha cha saxini xaan ndo. Ña vaha cha yuhvi cuni ndo chi anima ndo. ");
INSERT INTO mioNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cua ndehe ndo ndahi. Cua ndehe ndo chahi, vati yuhu cui. Cua tiin ndo chihin yu, ta cua ndehe ndo, vati ñahni iquin run xiñahñu ndii. Ñahni cuñu run, ta ndehe ndo ti iyo cuñu yu. Iyo iquin yu. ");
INSERT INTO mioNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tacan cati ra Jesuu, ta sanahan ra ndaha ra. Sanahan ra chaha ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ni vii cumani, ta cua cuinu vaha ini ñi, vati sii xaan cuni ñi. Iyo xaan cuni ñi, ta cati ndico tucu ra chi ñi ti: ―¿Atu ñahni cha cua cachi yu ihya? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tacan cuu, ta chaha ñi iin pedazu tiaca tihyo chi nduxi ñuñu. ");
INSERT INTO mioNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Quihin ra chi chi, ta nuun ni ndehe ñi chachi ra chi chi. ");
INSERT INTO mioNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tacan cuu, ta cati ra chi ñi ti: ―Ndihi cha ni tahin ni cati tuhin chihin ndo, ta ña ta cuvi yu. Chahi cuenda chi ndo ti iyo cha cua queta ndihi tuhun iyo nu tutu Ndioo cuenda yu yoso cuhva ni taa ra Moisee ley chahnu ta yoso cuhva ni taa ra ni cahan cuenda ra Ndioo nu ni quichi quivi ta yoso cuhva ni taa ra ta ra nu tutu Salmo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tacan cuu, ta chaha ra Jesuu cha chini tuni chi ñi. Chacan cuu cha quechaha cutuni ini ñi tutu Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Cati ra chi ñi ti: ―Cati tutu Ndioo ti cua ndehi tu ndoho, ta cua cuvi yu, soco cua yaha uni quivi, ta cua natacu ndique tañu ñivi ndii. ");
INSERT INTO mioNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Cua cati tuhun ñivi chi ndihi ñivi ñuñivi cuenda yu, vati yuhu ra Cristo cui. Cua quechaha cati tuhun ñi chi ñivi iyo ñuun Jerusalén, ta cua cati ñi ti na cua saña ihni ñi cuati ndacu ñi, ta sa cua cucahnu ini ra Ndioo cuati can chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Cha ni ndehe maan ndo ndihi cha ni tahin, ta sa cua cuhva ndo cuenda chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Cua tachi yu chi ra Tati Ndioo chi ndo cuhva ni cati suti nu ni quichi quivi. Cua cuatu ndo chi ra ihya ñuun ya nda cua nda cua quichi ra iti siqui andivi, ta cua coo tu ndee ini chi ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tacan cuu, ta ni chandaca ra Jesuu chi ñi. Nda ñuun Betania cuahan ñi. Tacan cuu, ta sandaa ra ndaha ra, ta cahan vii ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ni vii cahan vii ra chi ñi, ta cuahan ra, ta iti siqui andivi ndaa ra. ");
INSERT INTO mioNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tacan cuu, ta cuahan ndico ñi iti ñuun Jerusalén. Sii xaan cuni ñi, ");
INSERT INTO mioNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ta ndihi ni quivi iyo ñi ve ñuhun, ta sacahnu ñi chi ra Ndioo. Na cua cuu chi tacan ni.");
INSERT INTO mioNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nda ni xihna cuii ña ta quetuvi ñuhun ñuñivi, ta ni vii iyo ra cahan tuhun yoso cuhva iyo ra Ndioo. Iyo ra chi ra Ndioo quivi can, ta Ndioo cuu tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Iyo ra chi ra Ndioo nda ni xihna cuii, ");
INSERT INTO mioNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ta ni savaha ra ndihi cuii cha iyo. ");
INSERT INTO mioNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Maan ra ni savaha cha iyo ndito ndihi cuii cha iyo. Chacan cuu cha iyo cha chini tuni chi ñivi ñuñivi cuenda ra Ndioo, vati racan cuu sava ni ta cua iin ñuhun ndichin. ");
INSERT INTO mioNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Queta tuhun cuenda maan ra nu iyo ñivi ndacu ndavaha ni, soco ña nituni ini ñi yoso cuhva iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ni chacoo iin rai nani Juaan. Tava tiñu ra Ndioo chi ra, ");
INSERT INTO mioNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ta quichi ra Juaan can, vati cua cati tuhun ra. Cua cati tuhun ra yoso cuhva iyo ra cuu sava ta cua ñuhun ndichin can. Cati tuhun ra Juaan, vati cua cuinu ini ñivi chi ra cuu ra Cristo, vati cati tuhun ra tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ñavi ra Juaan cuu ra cuu sava ta cua ñuhun ndichin can, soco maan ra cati tuhun ra yoso cuhva iyo racan. ");
INSERT INTO mioNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ni quichi ra cuu rai ndicha can. Ni quichi ra cuu ra cua cuhva cha chini tuni chi ndihi ñivi, ta nu ñuhun ñuñivi ya ni quichi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Maan ra ni savaha ñuhun ñuñivi ya, ta ni chacoo ra nu ñuhun ñuñivi, soco ña nacoto ñivi ñuñivi yoo rai cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yaha ra nu iyo ñivi ra, soco ña quihin cuenda ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ñivi quihin cuenda chi ra cuu ñivi chinu ini chi ra. Chi ñican chaha ra tu ndee ini, ta ñivi Ndioo cuu ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ñivi Ndioo cuu ñi, vati tacan ni cuni ra Ndioo. Ñavi cuhva cuni ñivi ñuñivi cuu chi, soco cuhva cuni ra Ndioo cuu chi, vati ñavi cuhva cuni ñivi cha cua coo sehe ñi cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ihya nu ñuhun ñuñivi ya cha ni cacu tahan ra cuu ra cahan tuhun Ndioo. Ni chacoo tahan ra chi maan ndi, ta cha ndehe ndi cha cahnu xaan rai cuu ra cuhva iyo ra Ndioo sutu ra. Cahnu xaan rai cuu ra, vati iin tuhun ni sehe sutu ra cuu ra, ta iyo xaan tu manini chi ra. Ndicha ndicha iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Cha chaha ra Juaan cuenda yoso cuhva iyo ra, vati cati ra ti: ―Cuenda rahya chahi cuenda nu quichi quivi, vati cati yu ti iti nuin vachi iin rai, soco cahnu xaan ca rai cuu maan ra, vati xihna cuii ca cha ni iyo ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iyo xaan tu manini chi ra. Chacan cuu cha savaha xaan ra tu manini chi maan yo. ");
INSERT INTO mioNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisee cuu ra ni sayaha ley Ndioo cha xihna cuii, soco ra Jesucristo cuu ra savaha tu manini chi yo. Maan ra cuu ra ndicha ndicha. ");
INSERT INTO mioNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ña ta ndehe ñivi chi ra Ndioo. Iin tuhun sehe ra cuu ra iyo chi ra icaa ni, ta racan cuu ra chaha cuenda yoso cuhva iyo sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ni tava tiñu ra judío ra iyo ñuun Jerusalén chi ra sutu chi ra levita nu iyo ra Juaan, vati cua nducu tuhun ra ta ra chi ra yoo rai cuu ra. Chehe cuu tuhun ni cati tuhun ra Juaan. ");
INSERT INTO mioNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ña sandahyu ñahan ra chi ra ta ra, soco cati tuhun cachin ra chi ra, vati cati ra ti: ―Ñavi ra cua sacacu chi ndo cuu yuhu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ta nducu tuhun ndico tucu ra chi ra ti: ―¿Yoo rai cuun? ¿Atu ra Elía ra ni cahan tuhun cuenda ra Ndioo cuun? ―cati ra ta ra. Ta cati ndico ra Juaan ti: ―Ñavi racan cuu yuhu ―cati ra. Nducu tuhun ndico tucu ra ta ra ti: ―Cha cua quichi iin rai cua cahan cuenda ra Ndioo. ¿Atu yoho cuu ra? Ta cati ndico ra Juaan ti: ―Ñavi. ");
INSERT INTO mioNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nducu tuhun ndico tucu ra ta ra chi ra ti: ―¿Yoo rai cuun? Cua cati ndicon, vati iyo cha cua cati ndico ndi chi ra ni tava tiñu chihin ndi. Vitin cua cati cun yoo rai cuun ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ta cati ndico tucu ra Juaan chi ra ti: ―Yuhu cana chaa tichi cuhu, ta cati yu ti cua tiso vaha ñivi iti nu cua yaha ra chahnu cuhva ni cati ra Isaía ra ni cahan cuenda ra Ndioo iti chata tiempu chahnu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ta ra quee iti nuun ra fariseo can ");
INSERT INTO mioNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","nducu tuhun ra chi ra Juaan ti: ―¿Ñacu sacuanduta cun chi ñivi, vati ñavi ra Cristo cuun, ta ni ñavi ra Elía cuun, ta ni ñavi ra cahan cuenda ra Ndioo cuun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ta cati ndico ra Juaan chi ra ta ra ti: ―Sacuandute chi nduta, soco cha iyo iin rai iti nuun ndo―ña nacoto ndo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Vachi ra iti nuin, soco cahnu ca rai cuu ra. Ñahni yavi ndai iti nuun ra. Chacan cuu cha ña cuu cunda tohi, ta ndachi yu tiendu ndichan ra ―cati ra Juaan. ");
INSERT INTO mioNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Chacan cuu tuhun ni cati ra Juaan iti ñuun Betábara inga chiyo yuta Jordán nu sacuanduta ra chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tuvi inga quivi, ta ndehe ra Juaan ti cha vachi ra Jesuu nu iyo ra, ta quechaha cati ra Juaan ti: ―¡Jihna! Cha vachi ra cuu sava ta cua mbee Ndioo. Cua sanaan ra cuati ndacu ñivi ñuñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Cha cati yu cuenda racan ti iti nuin vachi iin rai, ta cahnu xaan ca rai cuu ra, vati nda ni xihna ca cha iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ña nacote chi ra, soco yuhu quichi, ta sacuandute chi ndo chi nduta. Chacan cuu cha cua coto ñivi Israel yoo rai cuu racan ―cati ra Juaan. ");
INSERT INTO mioNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Cati tuhun tahan ra Juaan ti: ―Cha ni ndehi ti cha quichi nuun ra Tati Ndioo iti siqui andivi cuhva quichi nuun iin ri paloma, ta ndoo ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ña nacote chi racan, soco iyo iin ra ni tava tiñu chi yu, ta cati ra ti cua sacuanduta yu chi nduta. Racan cuu ra cati chihin yu ti cua ndehi ti cua quichi nuun ra Tati Ndioo, ta cua ndoo ra chi iin rai. Racan cuu ra cua tachi chi ra Tati Ndioo chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yuhu cha ni ndehi ti racan cuu ra cuu sehe Ndioo. Chacan ni chahi cuenda chi ndo ―cati ra Juaan. ");
INSERT INTO mioNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tuvi inga quivi, ta iyo ndico ra Juaan. Iyo ra chi uvi ra chica chi ra, ");
INSERT INTO mioNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ta ndehe ra Juaan nu yaha ra Jesuu, ta quechaha cati ra ti: ―Racan cuu ra cuu sava ta cua mbee Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chini soho ra chica chi ra cha ni cati ra, ta quechaha ndicu ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ndico coo ra Jesuu, ta ndehe ra cha ndicu ra ta ra chi ra, ta quechaha nducu tuhun ra chi ra ti: ―¿Ñaan cha cuu cha nanducu ndo? Ta cati ndico ra chi ra Jesuu ti: ―Maestru, ¿ndaa iti iyo vehe nu iyo cun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ta cati ra Jesuu ti: ―Nahan ndo, ta cua ndehe ndo ―cati ra. Chacan cuu cha cuahan ra ta ra chi ra, ta ndehe ra nu iyo ra, ta ndoo nuun ra chi ra quivi can, vati cha cua ini xaan. ");
INSERT INTO mioNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Iin ra cuu ra Ndree yani ra Simón Pedro, ta cha chini ra tuhun ni cahan ra Juaan, ta ndicu ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nanducu xihna ra Ndree can chi ra Simón yani ra, ta quechaha cati ra chi ra ti: ―Cha ni ndehe ndi chi ra cuu Cristo ―cati ra. Tacan cati ñi, vati cua sacacu ra cuu Cristo can chi ñi nu iyo ñi chi tu ndoho. ");
INSERT INTO mioNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tacan cuu, ta ni chandaca ra chi ra nu iyo ra Jesuu, ta ndehe ra Jesuu chi ra Pedro, ta quechaha cati ra chi ra ti: ―Simón, sehe Jonaa cuun, soco Cefa cua cunani cun ―cati ra. Tuhun Cefa can cuu Pedro chi tuhun cahan maan ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tuvi inga quivi, ta cuni cuhun ra Jesuu iti ñuhun Galilea, ta ndehe ra chi ra Felipe, ta quechaha cati ra Jesuu chi ra ti: ―Na coho ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ra ñuun Betsaida cuu ra Felipe can, ta ini ñuun can cuu ñuun ra Ndree chi ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Cuahan ra Felipe, ta nanducu ra chi ra Natanael, ta quechaha cati ra chi ra ti: ―Chito cun yoso ni cati ra Moisee yoso ni cati ra ni cahan cuenda ra Ndioo iti chata ti cua coo iin rai cahnu iti nuun. Cha ni ndehe ndi chi ra, ta Jesuu sehe José cuu ra. Ra ñuun Nazaret cuu ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ta cati ndico ra Natanael chi ra ti: ―Ña ta ñahni cha vaha cha iyo iti ñuun Nazaret ―cati ra. Ta cati ndico ra Felipe ti: ―Nahan, ta cua ndehun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tacan cuu, ta ndehe ra Jesuu cha vachi ra Natanael nu iyo ra, ta quechaha cati ra cuenda ra Natanael can ti: ―Ihya iyo iin ra ndicha ñuhun Israel, ta ña tuhva ra sandahyu ñahan ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ta quechaha cati ra Natanael can chi ra Jesuu ti: ―¿Yoso cuhva nacoto cun chihin yu? Ta cati ndico ra Jesuu chi ra ti: ―Ña ta cana ra Felipe chihun. Ni vii iyo cun nu vati yutun tusihva ican, ta ndehi chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ta cati ra Natanael ti: ―Maestru, maun cuu ra cuu sehe Ndioo. Maun cuu ra ndaca ñahan chi ñivi Israel ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ta cati ndico ra Jesuu chi ra ti: ―Chinu ini cun chihin yu, vati cati yu ti cha ndehi chihun nu vati can. Cahnu xaan ca cha cua ndehun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ni vii cati ra Jesuu chi ra: ―Ndicha ndicha cati yu ti cua ndehun nu cua nuna iti siqui andivi, ta cua nuun ra tatun Ndioo nu iyo yu, vati ra cuu sehe ñivi cui, ta cua ndaa ndico ra tatun Ndioo can ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yaha uni quivi, ta ni chacoo iin vico tandaha iti ñuun Caná cha iyo cuenda ñuhun Galilea. Tican cuahan sihi ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ta cuahan tahan ra Jesuu chi ra sacuaha chi ra, vati cha cana ñahan tahan ñivi can chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tacan, ta queta hora cha ni ndihi nduta chiti uva chihi ñi, ta quechaha cati sihi ra Jesuu chi ra ti: ―Ñahni ca nduta chiti uva iyo. ");
INSERT INTO mioNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ta cati ndico ra Jesuu chi ña ti: ―Ña cua tichahun, yaa. Ña ta queta hora cha cua coto ñivi yoo rai cui ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tacan cuu, ta cati sihi ra chi ra tiso mesa ti: ―Cua savaha ndo ndihi cha cua cati ra ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ican cha iyo iñu quii nahnu. Yuu cuu chi, ta vasi queta ciendu litru nduta cha tahan iin iin chi, tu cha chitu chi. Iyo chi cuenda costumbre ñivi judío can, vati ndoo ndaha ñi. Ndoo coho ñi. Chacan tiñu iyo chi, ");
INSERT INTO mioNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ta quechaha cati ra Jesuu chi ra tiso mesa can ti: ―Cua sacutu ndo quii can chi nduta ―cati ra. Tacan cuu, ta cha ni sacutu ra chi chi nda cua nda yuhu chi vaha vaha, ");
INSERT INTO mioNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ta cati ndico ra Jesuu ti: ―Vitin cua tava ndo chi chi, ta cua cundaca ndo chi chi chi ra cuu xini ―cati ra. Tacan cuu, ");
INSERT INTO mioNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ta taa yaa ra cuu xini can nduta chiti uva can, ta ña chito ra ndaa iti quichi chi, soco chito vaha ra tiso mesa can, vati cha naquihin maan ra nduta can. Tacan cuu, ta cana ra cuu xini chi ra ni tandaha can. ");
INSERT INTO mioNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ta quechaha cati ra chi ra ti: ―Tuhva ñivi chaha ñi nduta vixin vaha xihna cuii, ta quechaha chini ñivi. Tacan cuu, ta sa cua cuhva ñi cha ndahvi, soco maun cha ni cumi cun nduta vixin vaha nda cua nda vitin. Vaha xaan cha ni savahun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chacan cuu cuhva ni savaha ra Jesuu cha xihna cuii, ta iti ñuun Caná cha iyo cuenda ñuhun Galilea savaha ra chi chi. Savaha ra Jesuu cuhva can, vati cua coto ñivi ti iyo tu ndee ini chi ra. Tacan cuu, ta ra sacuaha chi ra―chinu ini ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tacan cuu, ta cuahan ra iti ñuun Capernaum, ta cuahan tahan sihi ra chi yani ra chi ra sacuaha chi ra. Ndihi ñi cuahan chi ra, ta ndoo nuun ñi suhva quivi. ");
INSERT INTO mioNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Cha yatin cua coo vico cuenda cha ni cacu ñivi judío ñuhun Egipto tiempu chahnu, ta cuahan ra Jesuu iti ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tican tichi soco ndavi ve ñuhun ndehe ra cha xico ñivi sundiquin. Xico ñi mbee. Xico ñi paloma. Xico ñi, ta iyo tahan ra sama xuhun ñivi tichi tican. ");
INSERT INTO mioNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chacan ni ndehe ra Jesuu, ta quechaha nduxaan ra. Chacan cuu cha quihin ra iin ñiin cua cani ra chi ñivi can, ta sacunu ra chi ñi ndacu chacan. Tacan ni tava ndaa ra chi ñi iti chata cora can. Tava ra chi ri mbee. Tava ra chi ri sundiquin, ta sanduva ihni ra mesa ra sama xuhun, ta quicoyo xuhun ra, ");
INSERT INTO mioNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ta cati ra Jesuu chi ra xico paloma can ti: ―Cua tava ndaa ndo chi ri tihya, vati ñavi nuyahvi cuu vehe suti ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tacan cuu, ta ni chacuhun ini ra sacuaha chi ra ti iyo nu cati tutu Ndioo cuenda ra Jesuu ti cua ndoyo ñuhun ra, vati cuni ra cha cua coo ii vehe sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tacan cuu, ta quechaha nducu tuhun ñivi judío can chi ra ti: ―¿Ñaan cuhva cua savahun, ta cua coto ndi ti cha iyo ndatu tava ndaun chi ñican? ");
INSERT INTO mioNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ta cati ndico ra Jesuu chi ñi ti: ―Tu cua sandoyo ñuhun ndo ve ñuhun ya, tichi uni quivi cua sandaa ndique chi chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ta cati ndico ñivi judío can ti: ―Uvi xico iñu cuiya satiñu ñivi, ta sandaa ñi ve ñuhun ya, ta maun―cua sandaun chi chi tichi uni quivi ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Maan ra Jesuu cahan tuhun ve ñuhun, soco iin cuhva cahan ra, vati cahan ra cuenda iquin cuñu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Queta quivi cha ni natacu ndico ra Jesuu tañu ñivi ndii, ta ni chacuhun ini ra sacuaha chi ra ñaan cha ni cuu cha cati ra. Chacan cuu cha chinu ini ra cha cahan tutu Ndioo, ta chinu tahan ini ra tuhun cha ni cahan ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ni vii iyo ra Jesuu ñuun Jerusalén can, ta sacahnu ndico tucu ñi vico cuenda cha ni cacu ñivi ñi judío can ñuhun Egipto tiempu chahnu, ta tuvi ñivi quechaha chinu ini chi ra, vati ni ndehe ñi ndihi cuhva cha ni savaha ra, ");
INSERT INTO mioNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","soco ña cati ra ndihi tuhun chito ra chi ñi, vati chito ra yoso cuhva iyo ndihi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ña chini ñuhun ra cha cua cuhva ñivi cuenda chi ra yoso cuhva iyo ñivi, vati maan ra chito yoso cuhva saxini ñi chi anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iyo iin ra nani Nicodemo. Fariseo cuu ra, ta ndiso tahan ra tiñu cuenda ñivi judío. ");
INSERT INTO mioNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cha cuaa cuu chi, ta cuahan ra nu iyo ra Jesuu, ta quechaha cati ra Nicodemo chi ra ti: ―Maestru, chito ndi ti cha ni tachi ra Ndioo chihun, vati cua sacuahun chi ndi. Ña cuu savaha ñivi cuhva cha ni savahun, tu ña tindee ra Ndioo chi ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Cati ndico ra Jesuu chi ra ti: ―Cha ndicha ndicha cati yu ti tu ña cua cacu ñivi cuenda ra Ndioo, ña cua cuu yaha ñi nu cua cundaca ñahan ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ta nducu tuhun ra Nicodemo chi ra ti: ―¿Yoso cua cuu cacu ndico ñivi, tu cha chahnu ñi? Ña cua cuu quihvi ndico tucu ñivi tichi sihi ñi inga chaha, ta cua cacu ndico tucu ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ta cati ndico ra Jesuu ti: ―Cha ndicha ndicha cati yu ti tu ña cua nduchaa anima ñivi, tu ña cua cuanduta ñi, ña cua cuu yaha ñi nu cua cundaca ñahan ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ñivi ñuñivi cuu ñivi cha iyo cuenda ñuhun ñuñivi ni, ta ñivi ra Ndioo cuu ñivi cha iyo cuenda ra Tati Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ña cua nduiyo cun, vati cati yu ti iyo cha cua cacu ndico ndo cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Iyo nu yaha tati, ta chini yo cha cu yaha chi, soco ña chito yo ndaa iti vachi chi, ta ni ña chito yo ndaa iti cuahan chi. Ta ni cuhva iyo ra Tati Ndioo chi ñivi cha iyo cuenda ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ta nducu tuhun ndico tucu ra Nicodemo chi ra ti: ―¿Yoso cua cuu nduchaa anima ñivi? ");
INSERT INTO mioNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ta cati ndico ra Jesuu chi ra: ―Maun cuu maestru. Sacuaha cun chi ñivi Israel, ta ña chito cun yoso cuhva cua nduchaa anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yuhu cati chihun ti chito ndi ñaan tuhun cati ndi. Cati tuhun ndi ñaan cha cuu cha ni ndehe ndi, soco ña tasoho ndo tuhun cha cati tuhun ndi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Cha chahi cuenda chi ndo yoso cuhva iyo ñivi ñuñivi, ta ña chinu ini ndo. Chacan cuu cha ña cua cuu cuinu ini ndo, tu cua cati yu yoso cuhva iyo ra Ndioo iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ña chito ndo yoso cuhva iyo ra Ndioo, vati yoni chahan iti siqui andivi. Iin tuhun ni ra quichi ihya nu ñuhun ñuñivi ya chito. Ra cuu sehe ñivi cuu ra, ta cha ni chacoo ra iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Iyo cha cua cata caa ñivi chi ra nu cruu cuhva ni chata caa ra Moisee chi ri coo quivi cha ni chica cuu ñi tichi cuhu. ");
INSERT INTO mioNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Chacan cuu cha cua cuinu ini ñivi chi ra cuu sehe ñivi, ta cua coo ndito ñi chi ra Ndioo ndihi ni quivi ndihi ni tiempu. ");
INSERT INTO mioNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ni vii cahan ra Jesuu: ’Cundahvi xaan ini ra Ndioo chi ñivi ñuñivi. Chacan cuu cha ni tava tiñu ra chi sehe ra, ta iin tuhun ni sehe ra iyo. Chacan cuu cha ña cua ndoyo ñuhun ñivi chinu ini chi ra, soco cua coo ndito ñi chi ra Ndioo ndihi ni quivi ndihi ni tiempu. ");
INSERT INTO mioNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ni tava tiñu ra Ndioo chi sehe ra, vati cuni ra cha cua sacacu sehe ra chi ñivi ñuñivi. Ña cuni ra Ndioo cha cua tachi tuni sehe ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Ña cua cutuni ñivi chinu ini chi ra. Tu ña cua cuinu ini ñivi chi ra, cha iyo tuhun cha cua cutuni ñi. Cua cutuni ñi, vati ña cua cuinu ini ñi ti cha iyo tu ndee ini chi ra cuu sehe Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Cua cutuni ñi, vati quichi ra, ta chaha ra cha chini tuni chi ñivi. Quichi ra ihya nu ñuhun ñuñivi, soco cuni ñivi savaha ñi ndavaha ni. Ña cuni ñi savaha ñi cha vaha, vati mani ndavaha ni ndacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ndihi ñivi ndacu ndavaha ni―ña ndacu ñi cha vaha, ta ni ña cuni ñi cuinu ini ñi chi ra cuu sehe Ndioo, coto cua coto ñivi cha ndacu ñi ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ñivi ndacu cha ndicha―cuni ñi chi ra cuu sehe Ndioo. Chacan cuu cha cua coto ñivi ti ndacu ñi cha vaha, vati iyo ra Ndioo chi ñi. Tacan ni cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tacan cuu, ta cuahan ra Jesuu iti ñuhun Judea, ta cuahan tahan ra sacuaha chi ra. Ndoo nuun ra ta ra tican, ta sacuanduta ra chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ni vii sacuanduta tahan ra Juaan chi ñivi iti ñuun Enón, vati iyo xaan nduta tican, ta yatin ñuun can iyo ñuun Salim. Quichi ñivi tican, ta cha ni chanduta ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tacan ni savaha ra Juaan, vati ña ta tiin tiñu chi ra, ta quihvi ra ve caa. ");
INSERT INTO mioNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Uvi uni ra sacuaha chi ra Juaan―quechaha ndatuhun ra chi iin ra judío, ta ndatuhun ra yoso cuhva cu‑ii ñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tacan cuu, ta cuahan ra nu iyo ra Juaan, ta quechaha cati ra chi ra Juaan can ti: ―Maestru, nacoto cun chi ra quichi nu ni chacoo yo inga chiyo yuta Jordán, ta cati tuhun cun yoo rai cuu ra. Vitin sacuanduta tahan ra chi ñivi, ta ndihi ñivi cuahan nu iyo ra ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ta cati ndico ra Juaan ti: ―Tu ña cua tindee ra Ndioo, ña cua cuu savaha ñivi ñaan cha cuu cha cua savaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Maan ndo chito vaha ndo ti cati yu ti ñavi ra Cristo cui, soco tava tiñu ra Ndioo chihin yu, ta quichi yu iti chata ra. ");
INSERT INTO mioNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cua cati yu iin cuhva chihin ndo. Tu cua tandaha iin rai chi ñasihi ra, cua sacahnu tahan amigu ra vico. Cua nducuiti ra, ta cua cuni soho ra cha cua cahan ra tandaha, ta cua cusii ini ra, vati cua cuni soho ra cha cua cahan ra tandaha can. Chacan cuu cha cusii ini yu vitin. ");
INSERT INTO mioNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Racan cha cahan ndo tuhun can―cahnu xaan ca cua cuu ra, ta yuhu ña cahnu cua cui ―cati ra Juaan. ");
INSERT INTO mioNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ta ra ni quichi iti siqui andivi―ndaca ñahan ra chi ndihi ñivi. Ñivi iyo nu ñuhun ñuñivi―saxini ñi yoso cuhva iyo ñuhun ñuñivi, ta ndaca ñahan maan ra quichi iti siqui chi ndihi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Cati tuhun ra cha ni ndehe ra, ta cati tuhun ra cha ni chini soho ra, soco yoni tasoho cha cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tu cua tasoho ñivi cha cati ra, cua sacoto ra ti cha ndicha cuu ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ni tava tiñu ra chi iin rai, ta racan cuu ra cahan tuhun cahan ra Ndioo. Ña uhvi cuni ra Ndioo, ta tachi ra chi ra Tati Ndioo nu iyo sehe ra. ");
INSERT INTO mioNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Cuni xaan ra Ndioo chi sehe ra, ta chaha ra ndihi tu ndee ini chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tu cua cuinu ini ñivi chi ra cuu sehe Ndioo, cua coo ndito ñi chi ra ndihi ni quivi ndihi ni tiempu. Tu ña cua tasoho ñi cha cati ra, ña cua coo ndito ñi chi ra, soco xaan xaan cua tachi tuni ra Ndioo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Cha chini soho ra fariseo ti chica ca ñivi chi ra Jesuu, ta cuaha suhva ñivi sacuanduta ra, soco ra Juaan ña cuaha vaha ñivi iyo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ñavi ra Jesuu cuu ra sacuanduta chi ñi, soco ra sacuaha chi ra cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nuun ra Jesuu queta tuhun cha ni chini soho tahan ra fariseo, ta quee ra ñuhun Judea can, ta cuahan ndico tucu ra iti ñuhun Galilea. ");
INSERT INTO mioNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Chacan cuu cha yaha ra iti ñuhun Samaria. ");
INSERT INTO mioNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tacan cuu, ta queta ra ñuun Sicar cha iyo cuenda ñuhun Samaria can. Yatin ñuhun cha ni samani ra Jacob chi ra José sehe ra tiempu chahnu cuu ñuun can. ");
INSERT INTO mioNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tican iyo iin soco, ta soco ra Jacob nani chi. Chitatun ra Jesuu, vati cani iti cha chica ra. Chacan cuu cha ni chacunda tatun ra yuhu soco can, ta hora cuiti cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tacan cuu, ta vachi iin ñahan ñuhun Samaria can, vati cua canihin ña nduta, ta quechaha cati ra Jesuu chi ña ti: ―Cuhva suhva nduta cohi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Cha ni cuahan ra sacuaha chi ra tichi ñuun, vati cua sata ra cha cua cachi ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ta quechaha cati ña Samaria can chi ra ti: ―Rai judío cuun, ta ¿ñacu chica cun nduta chi yuhu, ta yuhu ñahan Samaria cui? Tacan cati ña, vati ña tuhva ñivi judío cahan ñi chi ñivi iyo ñuhun Samaria. ");
INSERT INTO mioNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ta cati ndico ra Jesuu chi ña ti: ―Ña chito cun ti iyo cha samani ra Ndioo chi ñivi ñuñivi, ta ni ña nacoto cun chi ra cati chihun ti cua cuhva cun nduta coho ra. Tu cua ndaca cun tu manini chi ra, cua cuhva ra nduta chihun, ta cua coo ndito cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ta cati ña chi ra: ―Ñahni ñaan cha naun, ta cunu xaan soco ya. ¿Ndaa cua nihun nduta cahun tuhun can? ");
INSERT INTO mioNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Chaha ra Jacob ra cuu ñivi ndi soco ya chi ndi. Chihi maan ra nduta ya, ta chihi tahan ñivi ra chi sana ra chi chi, ta cahnu xaan rai cuu ra. ¿Atu cahnu ca rai cuu maun? ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ta cati ndico ra Jesuu chi ña ti: ―Tu cua coho ñivi nduta ya, cua neti ndico tucu ñi, ");
INSERT INTO mioNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","soco tu cua coho ñivi nduta cua cuhve, ña cua neti ca ñi ndihi ni quivi. Cua cuhve chi chi chi ñi, ta cua cuu chi sava ni ta cua iin soco chi ñi nu cahndi nduta, ta cua coo ndito ñi chi ra Ndioo ndihi ni quivi ndihi ni tiempu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ta cati ña ñahan can chi ra ti: ―Cuhva nduta can chihin yu, ra chahnu. Chacan cuu cha ña cua neti que nduta, ta ni ña cua quichi que ihya, ta ni ña cua canihin que nduta ya ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ta cati ra chi ña: ―Cuahan, ta cua cana cun chi ra cuu ii cun, ta cua quichi ndico ndo ihya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ta cati ndico ña chi ra ti: ―Ñahni ii yu iyo ―cati ña. Ta cati ra Jesuu chi ña ti: ―Vaha xaan cati cun ti ñahni ii cun, ");
INSERT INTO mioNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","vati uhun tahan rai cha cucumi chihun, ta ñavi ra ii cun cuu ra iyo chihun vitin. Ndicha cun cuhva cati cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ta cati ndico ña chi ra: ―Yuhu cati ti rai cahan cuenda ra Ndioo cuun. ");
INSERT INTO mioNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tiempu chahnu cha sacahnu ñivi ndi chi ra Ndioo ihya yucu ya, ta maan ndo cati ndo ti iyo cha cua sacahnu yo chi ra Ndioo ñuun Jerusalén ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ta cati ndico ra Jesuu chi ña ti: ―Na cua cuinu ini cun cha cua cati yu, vati cua queta quivi, ta ña cua sacahnu ca ñivi chi ra Ndioo sutu yo ihya yucu ya, ta ni ña cua sacahnu ca ñi chi ra iti ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ña chito ndo ñaan cha sacahnu ndo, soco chito maan ndi yoo ra sacahnu ndi, vati iin ra judío cuu ra cua sacacu chi ndo nu iyo ndo chi tu ndoho. ");
INSERT INTO mioNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yu cati ti cua queta quivi, ta cua sacahnu ñivi chi ra Ndioo sutu yo chi ndihi cuii anima ñi, ta cua sacahnu ndicha ñi chi ra, tu cha ndicha ñi. Nanducu ra chi ñivi cua sacahnu chi ra, ta vitin cha ni queta hora cha cua sacahnu ndicha ñivi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tati cuu ra Ndioo. Chacan cuu cha iyo cha cua sacahnu ndicha yo chi ra chi anima yo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ta cati ndico tucu ña ñahan can chi ra ti: ―Chite ti cua quichi ra cua sacacu chi yo, ta Cristo cua cunani ra. Cua quichi ra, ta cua cuhva vaha ra cuenda chi yo ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ta cati ndico ra Jesuu chi ña ti: ―Yuhu cui ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tacan cuu, ta queta ndico ra sacuaha chi ra, ta iyo xaan cuni ra ta ra, vati ndatuhun ra chi iin ñahan, vati ña tuhva ra cuu maestru cahan chi ñi ñahan, soco taxin ni ndoo ra ta ra. Saxini ra ta ra ti ñaan cuu ra chi ña, ta saxini ra ñacu cahan ra chi ña, soco yoni cahan. ");
INSERT INTO mioNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nacoo ñacan quii ña, ta cuahan ña iti ñuun, ta queta ña, ta quechaha cati ña chi ñivi can ti: ");
INSERT INTO mioNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Coho ti cua ndehe ndo chi iin rai. Cha cati ra chihin yu ndihi cha ni tahin. Vasi ra Cristo cuu ra ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tacan cuu, ta quee ñi cuahan ñi nu iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ña ta queta ñi, ta quechaha cati ra sacuaha chi ra ti: ―Na cachi, maestru ―cati ra, vati ni nihin ra cha cua cachi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ta cati ra Jesuu chi ra ti: ―Ña chito ndo, soco iyo cha cachi yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tacan cuu, ta quechaha nducu tuhun ra ta ra chi tahan ra ti: ―¿Atu quichi ndaca ñivi cha cua cachi ra? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ta cati ndico ra Jesuu chi ra ti: ―Yu cati tacan, vati cua savahi cuhva cuni ra ni tachi chihin yu, ta cua satiñu i tiñu ra. Chacan cuu sava ni ta cua cha chachi yo, vati tacan ni nihin yu tu ndee ini yu. ");
INSERT INTO mioNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Cha cati ndo ti ni cumani cumi yoo, ta cua saquee ñivi niñi. Yu cati ti na cua ndehe ndo nu itu ti cha cuahan cuaan chi, ta cha iyo vaha cha cua saquee ñi chi chi. ");
INSERT INTO mioNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Cha iyo ñivi satiñu ñi, ta nihin ñi yahvi ñi. Chacan cuu cha cua coo vaha ñi chi ra Ndioo nu cuahan quivi, ta cua coo vaha ñi chi ra ndihi ni quivi ndihi ni tiempu. Iyo ra tachi chiti, ta iyo inga ra saquee niñi, soco iin cahnu ni cusii ini ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chacan cuu cha ndicha cuhva cati tutu Ndioo, vati iyo nu cati chi ti iin ñivi tachi chiti, ta inga ñi saquee niñi, cati chi. ");
INSERT INTO mioNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tacan cati yu, vati tava tiñu yu chihin ndo, ta cua nihin ndo cha vaha, soco ña ta satiñu ndo. Cha ni satiñu inga ñivi, soco vitin cua satiñu tahan maan ndo tiñu cha quechaha satiñu ñi. Tuhun can cati ra Jesuu chi ra sacuaha chi ra, vati cha vachi ñivi nu iyo ra ta ra, ta cuni ra cha cua coto ra sacuaha chi ra yoso cuhva cua cunda yahvi ñivi cua satiñu tiñu can. ");
INSERT INTO mioNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tacan cuu, ta tuvi ñivi ñuun Samaria can chinu ini chi ra Jesuu, vati cha cati ñahan can ti cha cati ra ndihi cha ni tahan ña. ");
INSERT INTO mioNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chacan cuu cha queta ñi nuun iyo ra, ta chica tuhun ñi ti na cua ndoo nuun ra chi ñi. Tacan cuu, ta ndoo nuun ra uvi quivi, ");
INSERT INTO mioNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ta tuvi ca ñivi chinu ini chi ra, vati cati tuhun ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chacan cuu cha quechaha cati ñi chi ña ñahan can ti: ―Ñavi ca cuenda tuhun cha ni cati cun chinu ini ndi, soco chinu ini ndi chi ra, vati cha ni chini soho tahan ndi cha cahan ra. Chacan cuu cha chito ndi ti racan cuu ra cua sacacu chi ndi chi ndihi ca ñivi ñuñivi ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yaha uvi quivi, ta quee ra Jesuu tican ñuhun Samaria can, ta cuahan ra iti ñuhun Galilea. ");
INSERT INTO mioNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tican cuu nu ni cati ra nu quichi quivi ti ña tuhva ñivi sacahnu ñi chi iin rai cahan cuenda ra Ndioo suvi ni ñuun nu chahnu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tacan cuu, ta queta ra iti ñuhun Galilea, ta cusii ini ñivi Galilea ndehe ñi chi ra, vati cha ni ndehe tahan ñi cha ni savaha ra ñuun Jerusalén quivi ni chacoo vico, vati ni chahan tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tacan cuu, ta cuahan ndico tucu ra Jesuu iti ñuun Caná cha iyo cuenda ñuhun Galilea can, ta suvi ni tican sanandacu ra nduta chiti uva. Iti ñuun Capernaum iyo iin ra cuu tiñu, ta cuhvi sehe ra, ");
INSERT INTO mioNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ta queta tuhun nuun ra ti cha ni quee ra Jesuu ñuhun Judea, ta ni quichi ndico ra iti ñuhun Galilea. Chacan cuu cha cuahan ra cuu tiñu can nu iyo ra Jesuu, ta quechaha cahan ndahvi ra chi ra Jesuu ti na coho iti vehe ra, ta na cua sanduvaha ra chi sehe ra. Tacan cahan ra cuu tiñu can, vati cha cuni cuvi sehe ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tacan cuu, ta quechaha cati ra Jesuu chi ra ti: ―Tu ña cua ndehe ndo iin cha cahnu, tu ña cua nduiyo ndo suhva, ña cua cuni ndo cuinu ini ndo chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ta cati ndico ra cuu tiñu can ti: ―Ra chahnu, na coho vitin, coto cua cuvi cuii sehi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ta cati ndico ra Jesuu chi ra: ―Cuahan iti vehun. Ña cua cuvi sehun ―cati ra. Tacan cuu, ta chinu ini racan tuhun cha ni cati ra Jesuu, ta cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cha cua queta ra vehe ra, ta quee musu ra cuu tiñu can vehe ra, vati cua satahan ra chi ra. Tacan cuu, ta quechaha cati ra chi ra ti: ―Cha ni nduvaha sehun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ta nducu tuhun ra chi musu ra: ―¿Ñaan hora nduvaha sehi? ―cati ra. Ta cati ndico musu ra ti: ―Icu ta hora cuu chi, ta ndico cahni chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tacan cuu, ta chito ra ti suvi ni hora can cati ra Jesuu chi ra ti ña cua cuvi sehe ra, cati ra, ta chinu ini ra chi ra Jesuu, ta chinu tahan ini ndihi ñivi ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Chacan cuu inga cuhva cha ni savaha ra Jesuu, ta cha ni quee ra ñuhun Judea, ta cuahan ra iti Galilea. Chacan cuu uvi cuhva cha ni savaha ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tacan cuu, ta cua coo inga vico sacahnu ñivi judío, ta cuahan ra Jesuu iti ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Iyo iin soco nduta tichi ñuun Jerusalén can, ta nani chi Betesda chi tuhun hebreo. Iyo uhun yuhu chi nu quihvi ñivi, ta yatin yu ñuun iyo chi, ta nani yuhu can nu yaha ri mbee. ");
INSERT INTO mioNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tuvi xaan ñivi cuhvi caa tican. Iyo ñi cuaa. Iyo ñi cojo. Iyo ñi nduñiin. Iyo ñi, ta tican ndatu ñi nda cua nda cua tuñu nduta can, ");
INSERT INTO mioNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","vati iyo hora quichi tatun Ndioo, ta quihvi ra tichi nduta, ta satuñu ra chi chi. Tacan cuu, ta cua quihvi tahan ñi cuhvi can, ta cua nduvaha ñi, tu cua quihvi xihna cuii ñi, ta cua naan cuehe tahan ñican. ");
INSERT INTO mioNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tican iyo tahan iin rai, ta cha queta oco chahun uni cuiya cha cuhvi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ndehe ra Jesuu chi racan nu caa ra, ta ni chito ra ti nahan xaan cha caa ra, ta quechaha nducu tuhun ra chi ra ti: ―¿Atu cuni cun nduvaha cun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ta cati ndico ra ndahvi can ti: ―Ra chahnu, cuni yu, soco yoni cua tindee chihin yu. Yoni cua cuiso chihin yu, ta cua quihvi yu tichi nduta ya hora tuñu chi. Cha cua quete, soco quihvi xihna inga ñivi ndihi ni chaha ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ta cati ra Jesuu chi ra ti: ―Cuinda. Canihun yuvi cun, ta cuahan iti vehun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ta suvi ni hora can ni nduvaha ra ndahvi can, ta canihin ra yuvi ra, ta cuahan ra, ta quivi sábadu quivi cha ndaa tatun ñivi judío cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chacan cuu cha quechaha cati ñivi judío can chi ra ndahvi can ti: ―Sábadu cuu chi, ta ñahni ndatu cha cua cuiso cun yuvi cun quivi vitin ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ta cati ndico ra chi ñi ti: ―Sanduvaha iin rai chihin yu, ta maan ra cati ti na cua canihin yu yuvi yu, ta na cuhin ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ta nducu tuhun ñi chi ra: ―¿Yoo ra cati chihun ti cua canihun yuvi cun, ta cua cuhun? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ta ña chito ra yoo rai cuu ra, vati cha cuahan ra Jesuu, vati cha ndutuvi ñivi tican. ");
INSERT INTO mioNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tacan cuu, ta ni tahan ra Jesuu chi ra soco ndavi ve ñuhun, ta cati ra Jesuu chi ra ti: ―Cha ni nduvahun. Ña cua savaha con cuati, coto cua tahun inga tu ndoho cahnu ca ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tacan cuu, ta cuahan racan, ta cati ra chi ñi judío can ti: ―Ra Jesuu cuu ra sanduvaha chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chacan cuu cha cuni cani tahan ñi chi ra Jesuu. Cuni cahni ñi chi ra, vati savaha ra chacan quivi ii, ");
INSERT INTO mioNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ta cati ra Jesuu chi ñi ti: ―Nda cua nda vitin satiñu ra Ndioo suti ndihi ni quivi, ta ta ni cuhva satiñu tahin ndihi ni quivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chacan cuu cha cuni xaan ca ñi cahni ñi chi ra. Cuni cahni ñi chi ra, vati ña sacahnu ra quivi ii, ta cuni cahni ñi chi ra, vati saxini ra ti Ndioo cuu tahan ra, vati cha cati ra ti ra Ndioo cuu sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ta cati ra Jesuu chi ñivi judío can ti: ―Cati ndicha yu ti ñahni cha cuu savaha ra cuu sehe Ndioo cha mani maan ra. Ndacu ra cuhva ndehe ra cha ni savaha sutu ra, vati ndacu tahan ra cuhva ndacu sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Chacan cuu chi, vati cuni mani ra Ndioo chi sehe ra, ta sanahan ra chi sehe ra ndihi cha ni savaha ra, ta ni cua sanahan ra cha cahnu ca chi sehe ra. Chacan cuu cha cua nduiyo ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Cha chaha ra suti cha natacu ndico ñivi ndii, ta chaha tahan ra cha iyo ndito ndico ñi. Ta ni cuhva chaha tahan sehe ra cha iyo ndito ndico ñivi cuhva ni cuni ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ña cua tachi tuni ra suti chi ñivi, soco cha chaha ra ndatu chi sehe ra, ta cua tachi tuni maan ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chacan cuu cha cua sacahnu ndihi ñivi chi sehe ra Ndioo cuhva sacahnu ñi chi maan sutu ra. Tu ña cua sacahnu ñivi chi sehe Ndioo, ña cua sacahnu ñi chi ra Ndioo sutu ra, ta maan ra cuu ra ni tava tiñu chi sehe ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Cati ndicha yu chi ndo ti tu cua tasoho ñivi tuhun cha cahin, tu cua cuinu ini ñi chi ra ni tava tiñu chihin yu, cua coo ndito ñi chi ra Ndioo. Ña cua cutuni ñi, ta ni ña cua cuvi ñi cuenda ra Ndioo, soco cua coo ndito ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Cati ndicha yu ti cua queta hora, ta cua tasoho ñivi ña chinu ini chi ra Ndioo. Cua tasoho ñi tuhun cahan sehe ra Ndioo, ta cua coo ndito ñi chi ra, ta vitin ni iyo hora can. ");
INSERT INTO mioNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Iyo tu ndee ini chi ra suti, ta cua cuhva ra cha cua coo ndito ñivi chi ra. Ta ni cuhva chaha ra ndatu chi sehe ra, ta cua cuhva tahan ra cha cua coo ndito ñivi, ");
INSERT INTO mioNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ta chaha tahan ra suti ndatu cha cua tachi tuni sehe ra, vati sehe ñivi ñuñivi cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ña cua nduiyo ndo cha cahin, vati cua queta hora, ta cua cuni soho ñivi ndii cha cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Tacan cuu, ta cua natacu ndico ñivi ni savaha cha vaha, ta cua coo ndito ñi chi ra Ndioo, ta ta ni cuhva cua natacu ndico ñivi savaha ndavaha ni, ta cua cutuni ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ni vii cahan ra Jesuu chi ñi judío can: ’Ñahni cha cuu savahi cha mani yu. Cua tachi tuni yu cuhva cua cati suti, ta iin cha ndicha ndicha cuu cha cua tachi tuni yu, vati ña cua savahi cuhva cuni yu, soco cua savahi cuhva cuni ra tachi chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tu cua cuhve cuenda yoso cuhva iye cha mani maan ni yu, vasi cua saxini ndo ti ña ndicha cuhva cati yu, ");
INSERT INTO mioNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","soco iyo inga ra cha chaha cuenda yoso cuhva iye, ta chite ti chaha ndicha ra cuenda yoso cuhva iye. ");
INSERT INTO mioNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tava tiñu ndo chi tahan ndo nu iyo ra Juaan ra sacuanduta, ta cati tuhun ra iin cha ndicha. ");
INSERT INTO mioNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ñavi cha cati tuhun ñivi quihin cuenda yu, soco cati tuhun yu tuhun can, vati cuni yu cha cua cacu ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ra Juaan can chaha cuenda yoso cuhva iye, soco suhva ni hora cuni ndo cusii ini ndo chi ra nu cati tuhun ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Cahnu cuu tuhun cati tuhun ra Juaan can cuenda yu, soco cahnu xaan ca cuu tuhun cati tuhun ra suti, ta yuhu ndacu yu ndihi tiñu cha chaha ra suti chihin yu. Tacan cua coto ndo yoso cuhva iye, ta cua coto ndo ti ra suti cuu ra ni tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tachi ra suti chihin yu. Chacan cuu cha maan ra chaha cuenda yoso cuhva iye, ta maan ndo ña ta tasoho ndo cha cahan ra, ta ni ña ni ndehe ndo yoso cuhva caa ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ña tasoho ndo tuhun cha cahan ra, ta ni ña chinu ini ndo chi sehe ra, ta maan ra ni tava tiñu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Sacuaha xaan ndo tutu Ndioo ni chacoo tiempu chahnu. Sacuaha ndo chi chi, vati saxini ndo ti tacan ni cua coo ndito ndo chi ra Ndioo, ta tutu can chaha cuenda yoso cuhva iye, ");
INSERT INTO mioNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ta vitin ña cuni ndo cuinu ini ndo chihin yu, ta tacan sa cua coo ndito ndicha ndo chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Ña cati yu chacan, vati cuni yu cha cua sacahnu ndo chihin yu, ");
INSERT INTO mioNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","soco chite ti ña cuni mani ndo chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yuhu cha quichi yu cuenda suti, ta maan ndo ña quihin cuenda ndo chihin yu. Tu cua quichi inga ñivi cuenda suvi ni maan ñi, cua quihin cuenda ndo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ña cua cuu cuinu ini ndo, vati cuni ndo cha cua sacahnu tahan ndo chi ndo. Ña cuni ndo cha cua sacahnu ra Ndioo chi ndo, ta iin tuhun ni maan ra iyo. ");
INSERT INTO mioNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ña cua saxini ndo ti yuhu cuu ra cua tiso cuati ndo iti nuun ra suti, vati Moisee cuu ra cha ni tiso cuati ndo nda ni iti chata, ta cuenda maan ra saxini ndo ti cua coo vaha ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tu cua cuinu ndicha ini ndo chi ra Moisee, cua cuinu tahan ini ndo chihin yu, vati iti chata cha ni taa ra nu tutu yoso cuhva cua coi. ");
INSERT INTO mioNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tu ña cua cuinu ndicha ini ndo tuhun cha ni taa ra, tacan tucu ña cua cuinu ini ndo tuhun cha cahan yu ―cati ra Jesuu chi ñivi judío can. ");
INSERT INTO mioNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tacan cuu, ta cuahan ra Jesuu chi ra sacuaha chi ra inga chiyo tañuhun Galilea, ta nani tahan tañuhun can tañuhun Tiberia. ");
INSERT INTO mioNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tuvi ñivi ndicu chi ra Jesuu, vati ni ndehe ñi cuhva cha ni savaha ra, ta cahnu xaan cuhva ni savaha ra, vati sanduvaha ra chi ñivi cuhvi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tacan cuu, ta iti yucu cuahan ra Jesuu chi ra sacuaha chi ra, ta ni chacunda ra tican. ");
INSERT INTO mioNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Cha yatin cua nducahnu vico cuenda cha ni cacu ñivi Israel ñuhun Egipto iti chata cha sacahnu ñivi judío can. ");
INSERT INTO mioNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tacan cuu, ta ni canihin nuun ra Jesuu, ta ndehe ra cha tuvi ñivi vachi nu ndaa ra, ta quechaha cati ra chi ra Felipe ti: ―¿Ndaa iti cua sata yo cha cua cachi ñi? ");
INSERT INTO mioNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tacan cati ra Jesuu chi ra, vati cuni ra coto ra yoso cuhva cua cati ndico ra Felipe, soco chito maan ra ñaan cha cuu cha cua savaha ra, ");
INSERT INTO mioNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ta cati ndico ra chi ra Jesuu ti: ―Tu cua sata yo uvi ciendu denario xuhun cha cuu paan, ña cua queta cha cua cachi ñi. Masi suhva cua cachi iin iin ñi, soco ña cua queta chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tacan cuu, ta nducahan inga ra sacuaha chi ra. Ndree yani ra Simón Pedro cuu ra, ta quechaha cati ra chi ra ti: ");
INSERT INTO mioNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Cha iyo iin ra luhu ihya, ta ndiso ra uhun paan ta uvi tiaca, soco ña cua queta chacan, vati tuvi ñivi cuu ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tacan cuu, ta cati ra Jesuu chi ra sacuaha chi ra ti: ―Cua cati ndo ti na cua cunda ñi ―cati ra. Tican nu iyo ñi iyo xaan ita cuii. Chacan cuu cha ni chacunda ra rai, ta vasi queta uhun mil ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tacan cuu, ta ni quihin ra Jesuu paan can, ta chaha ra iin tiahvi ndioo chi ra Ndioo, ta natahvi ra chi chi chi ra ta ra. Ta ni cuhva savaha ra Jesuu chi tiaca can, ta chachi vaha ra rai can. ");
INSERT INTO mioNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ndaha ini ra ta ra, ta cati ra Jesuu chi ra sacuaha chi ra ti: ―Cua canihin vaha ndo ndihi pedazu cuati cha ni ndoo. Chacan cuu cha ñahni chi cua ndoyo ñuhun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tacan cuu, ta canihin vaha ra ta ra ndihi chi, ta queta uchi uvi tica sacutu ra, ta uhun paan ni cuu chi, ta cha ña ni ndihi ca chachi ñi cuu chacan. ");
INSERT INTO mioNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ndehe ndihi ñivi can cha ni savaha ra Jesuu cuhva cahnu xaan can, ta quechaha cati ñi chi tahan ñi cuenda ra Jesuu ti: ―Ndicha ti rahya cuu ra cha cua coo nu ñuhun ñuñivi ya, ta cua cahan ra cuenda ra Ndioo ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tacan cuu, ta chito ra Jesuu ti cua quihin ñi chi ra, ta cua sanini ñi chi ra cha cua cundaca ñahan ra chi ñi. Chacan cuu cha nacoo ra chi ñi, ta quee ndico tucu ra, ta cuahan ndico ra iti yucu cha maan iin tuhun ni ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tacan cuu, ta cha cua cuaa, ta cuahan ra sacuaha chi ra Jesuu iti yuhu tañuhun can. ");
INSERT INTO mioNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Quihvi ra ta ra tichi tundoo, ta cuahan ra. Iti ñuun Capernaum inga chiyo nduta can cuahan ra, ta naan xaan hora can, ta ña ta quichi ra Jesuu nu iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nihin suhva quechaha tahnu nduta, vati nihin xaan caa tati. ");
INSERT INTO mioNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tacan cuu, ta sacunu ra ta ra tundoo can, ta queta iin uhun a iin iñu kilómetro cha chinu chi, ta quechaha ndehe ra ta ra ti cha vachi ra Jesuu. Chica ra nu nduta, ta cha cuyatin ra chi tundoo can. Tacan cuu, ta quechaha cuyuhvi ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ta quechaha cati ra Jesuu chi ra ta ra ti: ―Ña cuyuhvi ndo, vati yuhu cui ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tacan cuu, ta cusii ini ra ta ra cha cua quihvi tahan ra Jesuu tichi tundoo can. Tacan cuu, ta cha queta tundoo yuhu nduta can nu ni cuahan ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tuvi inga quivi, ta ni vii iyo ñivi can inga chiyo nduta can. Chito ñi ti iin tuhun ni tundoo ni chacoo yuhu tañuhun, ta chito ñi ti quihvi ra sacuaha chi ra Jesuu, ta cuahan ra ta ra, soco ña quihvi tahan ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Iyo ca tundoo quee iti ñuun Tiberia, ta queta chi yatin nu ni chaha ra Jesuu tiahvi ndioo chi ra Ndioo, ta sacachi ra chi ñi, ");
INSERT INTO mioNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ta ndehe ñi ti yoni ra Jesuu iyo, ta cha cuahan ra sacuaha chi ra. Chacan cuu cha quihvi tahan ñi tichi tundoo can, ta cuahan ñi iti ñuun Capernaum. Cuahan ñi, vati nanducu ñi chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nanihin ñivi can chi ra Jesuu tican inga chiyo nduta can, ta quechaha nducu tuhun ñi chi ra ti: ―¿Ñaan hora ni queta cun ihya, ta Maestru? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ta cati ndico ra Jesuu chi ñi ti: ―Cati ndicha yu ti nanducu ndo chihin yu, soco ñavi vati ndehe ndo iin cha cahnu. Nanducu ndo chihin yu, vati chahi cha chachi ndo, ta ndaha ini ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ña cua nanducu ni ndo cha cua cachi ndo cuenda ñuhun ñuñivi ya, vati chacan ña cua ndunahan chi chi ndo, soco na cua nducu ndo cha cua coo chi ndo cuenda ra Ndioo, vati cua coo chi chi ndo ndihi ni quivi ndihi ni tiempu. Cha cua cuhva ra cuu sehe ñivi chihin ndo cuu chi, vati chi racan cha chaha ra Ndioo suti tu ndee ini. Chacan cuu cha chito ndo yoo rai cuu ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ta cati ñi chi ra Jesuu ti: ―¿Ñaan cha cuu cha cua savaha ndi, ta cua savaha ndi cuhva cuni ra Ndioo? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ta cati ndico ra Jesuu chi ñi ti: ―Cha tava tiñu ra Ndioo chi iin rai. Tu cua cuinu ini ndo chi ra, cua savaha ndo cuhva cuni ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ta cati ñi chi ra ti: ―¿Ñaan cuhva cua savaha maun? Tu cua savahun iin cuhva, cua ndehe ndi, ta cua cuinu ini ndi chihun. ¿Ñaan cha cuu cha cua savahun? ");
INSERT INTO mioNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Iti chata ni chachi ñivi yo maná cha ni chaha ra Ndioo chi ñi. Chachi ñi chi chi tichi cuhu cuhva cati tutu Ndioo, vati cati chi ti chaha ra Ndioo cha chachi ñi, vati iti siqui andivi nuun chi. Tacan cati tutu Ndioo ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ta cati ndico ra Jesuu chi ñi ti: ―Cati ndicha yu ti ñavi ra Moisee cuu ra ni chaha cha chachi ñi iti chata, soco ra Ndioo cuu ra, ta vitin cua cuhva ra cuu suti iin cha ndicha ndicha chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Cha ni tachi ra Ndioo iin rai nu iyo ndo. Cha quichi nuun ra iti siqui andivi, ta maan ra cuu ra cua cuhva cha cua coo ndito ñivi ñuñivi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ta cati ñi chi ra Jesuu ti: ―Ra chahnu, na cua cuhvon cha ni cati cun chihin ndi ndihi ni quivi ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ta cati ndico ra Jesuu ti: ―Yuhu cuu sava ta cua iin cha cua cachi ndo, vati cua cuhve cha cua coo ndito ndo. Tu cua cuinu ini ndo chihin yu, cua cuu ndo sava ni ta cua iin ñivi, ta ña cua cuisoco ca ndo, vati ña cua ndoyo ñuhun ndo, soco cua coo ndito ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Cha cati yu chi ndo ti cha ni ndehe ndo chihin yu, ta ña ta cuinu ini ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Cua cuhva ra suti cha cua cuinu ini ñivi chihin yu. Ndihi ñican cua coo chihin yu, ta ña cua tava ndai chi ñivi cua cuinu ini chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Iti siqui andivi quichi nuun yu, vati cua savahi cuhva cuni ra ni tava tiñu chihin yu, ta ña cua savahi cuhva cuni yu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ña cuni ra cha cua ndoyo ñuhun ni iin ñi cha iyo cuenda yuhu, soco cua natacu ndico ñi quivi cua cutuni ñivi nu cuahan quivi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Cuni ra suti cha cua coo ndito ñivi chinu ini chi sehe ra. Cua coo ndito ñi chi ra ndihi ni quivi ndihi ni tiempu, vati cua cuhve tu ndee ini chi ñi, ta cua natacu ndico ñi quivi cua cutuni ñivi ndacu ndavaha ni ―cati ra Jesuu chi ñivi judío can. ");
INSERT INTO mioNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tacan cuu, ta ña ndoo ñivi judío can vaha, ta quechaha cati ñi chi tahan ñi ti: ―Ña vaha, vati cati ra Jesuu ti maan ra cuu ra cha ni quichi nuun iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ña vaha cha cahan ra tacan, vati nacoto yo chi sutu ra, ta nacoto yo chi sihi ra. Ra José cuu sutu ra, ta maan ra nani Jesuu. Ña vaha cha cati ra ti iti siqui andivi ni quichi nuun ra ―cati ñi chi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tacan cuu, ta cati ra Jesuu chi ñi ti: ―Ña cua cahan xaan ndo chi tahan ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni tava tiñu ra suti chihin yu. Tu ña cua tindee ra chi ndo, ña cua cuu cuinu ini ndo chihin yu. Tu cua cuinu ini ndo, cua cuhve tu ndee ini chi ndo, ta cua natacu ndico ndo quivi cua cutuni ñivi ndacu ndavaha ni. ");
INSERT INTO mioNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Iti chata cha ni taa ra ni cahan cuenda ra Ndioo tichi tutu ra, vati cati ra ti chaha ra Ndioo cha chini tuni chi ndihi ñivi chinu ini chi ra, cati tutu ra. Tu cua tasoho ndo cha cahan suti, tu cua savaha ndo cuhva cati ra, cua cuinu ini ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Yoni ñivi ñuñivi cha ni ndehe chi suti, soco iyo iin ra ni tava tiñu ra, ta iin tuhun ni racan cuu ra ni ndehe chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yuhu cati ti tu cua cuinu ini ndo chihin yu, cua coo ndito ndo chihin yu ndihi ni quivi ndihi ni tiempu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sava ni ta cua iin cha chachi ndo cuu yuhu, vati cua cuhve cha cua coo ndito ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Iti chata chachi ñivi ndo maná cha ni chaha ra Ndioo, soco queta quivi ni chihi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Vitin cha ni tachi ra Ndioo cha cuu sava ni ta cua iin cha cua cachi ndo. Chacan cuu cha cua cachi ndo, ta ña cua ndoyo ñuhun ndo cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yuhu cuu ra cha ni quichi nuun iti siqui andivi, ta cui sava ni ta cua iin cha cua cachi ndo, ta cua cuhve cha cua coo ndito ndo chi ra Ndioo. Tu cua cachi ndo cha cua cuhva yu, cua coo ndito ndo chihin ra Ndioo ndihi ni quivi ndihi ni tiempu, vati cua cuhva cuenda yu cuñu yu cuenda ñivi ñuñivi. Chacan cuu cha cua cuu coo ndito ñi chi ra Ndioo. Tacan ni cati ra Jesuu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tacan cuu, ta quechaha cahan yuhu ñivi judío can chi tahan ñi, ta cati ñi ti: ―¿Yoso cua savaha ra, ta cua cuu cachi yo cuñu ra? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ta cati ra Jesuu chi ñi ti: ―Cati ndicha yu ti tu ña cua cachi ndo cuñu ra cuu sehe ñivi, tu ña cua coho ndo niñi ra, ña cua coo ndito ndo chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tu cua cachi ndo cuñu yu, tu cua coho ndo niñi yu, cua coo ndito ndo chi ra Ndioo ndihi ni quivi ndihi ni tiempu, vati cua cuhve tu ndee ini chi ndo, ta cua natacu ndico ndo quivi cua cutuni ñivi ñuñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tu cua cachi ndo cuñu yu, tu cua coho ndo niñi yu, cua coo ndicha tu ndee ini chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tu tacan cua savaha ndo, cua coi chi ndo, ta cua coo ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Iyo ndito ra cuu suti, ta racan cuu ra ni tava tiñu chihin yu. Chacan cuu cha iyo ndito yu, vati tachi ra suti chihin yu. Tu cua coo ndo chihin yu, cua coo ndito ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yuhu cuu ra ni quichi nuun iti siqui andivi. Yuhu cuu sava ta cua cha cua cachi ndo, soco ña cua tahan ndo cuhva ni tahan ñivi yo iti chata. Chachi ñi maná can, soco queta quivi ni chihi tahan ñi. Tu cua coo ndo chihin yu, cua coo ndito ndo chihin yu ndihi ni quivi ndihi ni tiempu. ");
INSERT INTO mioNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tacan cati ra Jesuu ve ñuhun iyo ñuun Capernaum can nu ni sacuaha ra chi ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tuhun can ni chini soho tahan ñivi sacuaha chi ra, ta quechaha cati ñi chi tahan ñi ti: ―Ii xaan cha cua cuinu ini yo tuhun cahan ra, vati yoni cua cuu tasoho chacan ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tacan cuu, ta chito ra Jesuu chi anima ra ti quechaha cahan ñi tuhun can, ta cati ra chi ñi ti: ―Ña vaha cha saxini xaan ndo cuenda chacan. ");
INSERT INTO mioNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nu cua ndehe ndo cha cua cuhun ndico ra cuu sehe ñivi nu ni chacoo ra iti siqui andivi nu quichi quivi, ta ña vaha cha cua saxini ndico tucu ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Maan ra Tati Ndioo cuu ra chaha cha iyo ndito yo, ta ñahni yavi ndaa cuñu yo. Cha cati yu tuhun can, vati tacan cua coto ndo yoso cuhva iyo ra Ndioo, ta cua coto ndo yoso cuhva cua coo ndito ndo, ");
INSERT INTO mioNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","soco iyo ni ndo ña cua cuinu ini ndo. Tacan cati ra Jesuu, vati nda ni quivi xihna cuii chito ra ndaa ñi cuu ñi ña cua cuinu ini chi ra, ta chito ra ndaa ra cuu ra cua xico tuhun chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Cati ndico ra Jesuu ti: ―Chacan cuu cha cati yu ti tu ña cua cuhva ra cuu suti, ña cua cuu cuinu ini ndo chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tacan cuu, ta quechaha saña ñivi sacuaha chi ra. Tuvi ñivi cuu ñi saña chi ra, ta ña chahan ca ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tacan cuu, ta quechaha nducu tuhun ra Jesuu chi uchi uvi ra sacuaha ndicha chi ra ti: ―¿Atu cua cuhun tahan ndo chi ñivi can? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ta cati ndico ra Simón Pedro chi ra ti: ―Ñahni nu cua cuhun ndi, vati maun cuu ra cati tuhun chi ndi yoso cuhva cua coo ndito ndi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Cha chinu ini ndi chihun, ta cha chito ndi ti maun cuu ra Cristo, vati sehe ra Ndioo cuun, ra chahnu ―cati ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ta cati ra Jesuu chi ra ta ra ti: ―Yuhu nacachi chi ndihi ndo, ta uchi uvi rai cuu ndo, soco cuihna cuu iin ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Cahan ra tacan cuenda ra Juda Iscariote sehe ra Simón, vati racan cua xico tuhun chi ra Jesuu, ta chica tahan ra chi ra icaa ni. ");
INSERT INTO mioNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tacan cuu, ta chica cuu ra Jesuu ñuun ta ñuun iti ñuhun Galilea can. Ña cuni ra cuhun ra iti ñuhun Judea, vati nducu ñivi judío cuhva cha cua cahni ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Cha yatin cua coo vico cha iyo cuenda tiahva cha cua sacahnu ñivi judío can. ");
INSERT INTO mioNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Chacan cuu cha quechaha cati yani ra Jesuu chi ra ti: ―Saña tiñu ndaca cun ihya, ta cuahan iti ñuhun Judea. Chacan cuu cha cua ndehe tahan amigu cun iyo tican ndihi cha ndacu cun. ");
INSERT INTO mioNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tu cua cuni yo cha cua nacoto ñivi chi yo, ña cua cuindi xehe yo. Na cua ndehe ndihi ñivi cuhva ndacu cun ―cati ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tacan cati yani ra Jesuu chi ra, vati ña chinu ini ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Chacan cuu cha cati ra Jesuu chi ra ti: ―Ña ta queta quivi cha cua cuhin, soco ndihi ni quivi cua cuu cuhun maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ña cua cuxaan ini ñivi chihin ndo, soco chi yuhu xaan xaan cuni ñi ndehe ñi, vati chahi cuenda yoso cuhva iyo ñi, ta mani ndavaha ni ndacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cuahan maan ndo vico, soco yuhu ña cua cuhin, vati ña ta queta hora cha cua nacoto ñi yoo rai cui ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tuhun can cati ra Jesuu chi ra ta ra, ta ni ndoo ra ñuhun Galilea can. ");
INSERT INTO mioNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tacan cuu, ta cuahan yani ra Jesuu vico, ta sa cuahan tahan ra Jesuu, soco ña ndehe ñivi cha cuahan ra, vati cuahan xehe ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nanducu ñivi judío chi ra vico, ta quechaha nducu tuhun ñi ti: ―¿Ndaa iyo ra? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Cuaha xaan cahan ñi cuenda ra Jesuu, vati iyo ñi cati ti vaha xaan rai cuu ra, soco inga ñi cati ti ña ndicha ra, vati sandahyu ñahan ra chi ndihi ñivi, cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ña cachin cahan ñi cuenda ra, vati yuhvi ñi chi ra cumi tiñu iyo cuenda ñivi judío can. ");
INSERT INTO mioNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tichi vico can cuahan ra Jesuu iti ve ñuhun, ta quihvi ra cora soco ndavi, ta sa quechaha sacuaha ra chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Iyo xaan cuni ñivi judío can, ta quechaha nducu tuhun ñi chi tahan ñi ti: ―¿Ñacu chito xaan ra, ta ñahni cha sacuaha ra? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ta cati ndico ra Jesuu chi ñi ti: ―Ñavi tuhun saxini yu sacuahi chi ndo, soco tuhun ra ni tava tiñu chi yu sacuahi chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tu cua cuni ndo savaha ndo cuhva cuni ra, cua coto ndo ñaan cha cuu tuhun ra, ta cua coto ndo a tuhun Ndioo cati tuhin a cati tuhin tuhun saxini yu. ");
INSERT INTO mioNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Cahan ñivi cuenda suvi ni maan ñi, vati cuni ñi cha cua sacahnu ñivi chi ñi, soco yuhu cuni yu cha cua sacahnu ñivi chi ra ni tava tiñu chihin yu. Chacan cuu cha cahan ndicha yu, ta ña tuhve sandahyu ñahan. ");
INSERT INTO mioNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Chaha cuenda ra Moisee ley Ndioo chihin yo, soco yoni ndo sacuinu cuhva cati chi. ¿Ñacu cuni cahni ndo chihin yu? ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ta cati ndico ñivi can chi ra ti: ―Ña vaha cuni xini cun, vati yoni cuni cahni chihun ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ta cati ndico ra Jesuu chi ñi ti: ―Iin cha cahnu cha ni savahi quivi cahnu, ta nduiyo ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Chaha ra Moisee costumbre cha cua tahnda ñiin xini xuu ra cuati ndihli, soco ñavi ra Moisee cuu ra, vati iin ra cuu sutu ñuun iti chata cuu ra. Masi quivi ii cuu chi, soco ni sacuinu ndo costumbre can. ");
INSERT INTO mioNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Sacahnu ndo costumbre can quivi ii, vati cuni sacuinu ndo cuhva cati ley Moisee, soco nduxaan ndo chihin yu, vati sanduvahi chi ñivi, ta quivi ii cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ña cua tachi tuni ndo cuhva saxini maan ndo, soco cua tachi tuni ndo iin cha ndicha ndicha ―cati ra Jesuu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tacan cuu, ta quechaha nducu tuhun uvi uni ñivi xu ñuun Jerusalén can ti: ―¿Atu ña ndicha ti rahya cuu ra nanducu ñi, vati cuni cahni ñi chi ra? ");
INSERT INTO mioNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Vachi ra ihya, ta cati tuhun ra, ta ña cahan ra cumi tiñu chi ra. Vasi saxini ra ta ra ti ra Cristo cuu ra, ta ni tava tiñu ra Ndioo chi ra, ");
INSERT INTO mioNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","soco chito yo ndaa iti vachi ra, soco cua quichi ra cuu Cristo, ta yoni cua coto ndaa iti cua quichi ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tacan cuu, ta sacuaha ra Jesuu chi ñivi. Iyo ra tichi cora soco ndavi can, ta quechaha cati ra ti: ―Nacoto ndo chi yuhu, ta chito ndo ndaa iti vachi yu. Ñavi cha cuni main vachi, soco iyo ra ni tava tiñu chihin yu, ta rai ndicha ndicha cuu ra, soco ña nacoto ndo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yuhu nacote chi ra, vati iti nuun ra quichi yu, ta maan ra cuu ra ni tava tiñu chihin yu ―cati ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chacan cuu cha cuni ñi tiin ñi chi ra, soco ña cuu, vati ña ta queta hora ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tacan cuu, ta chinu ini ñivi chi ra. Tuvi ñi cuu ñi, ta quechaha cati ñi ti: ―Cuaha xaan cuhva cha ni savaha rahya, soco ra cuu Cristo ña cua savaha ca ra cuhva quivi cua quichi ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Chini soho ra fariseo cha cahan ñivi cuenda ra Jesuu. Chacan cuu cha nduinuun ra sutu chahnu chi ra fariseo, ta tachi ra chi ra cuu tatun ra, vati cua tiin ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tacan cuu, ta quechaha cati ra Jesuu chi ñivi can ti: ―Suhva ni ca quivi cua coi chi ndo, ta sa cua cuhin nu iyo ra ni tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Cua nanducu ndo chihin yu, soco ña cua nanihin ndo, ta ni ña cua cuu cuhun ndo nu cua cuhin ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tacan cuu, ta quechaha cahan ñivi judío can chi tahan ñi, ta cati ñi ti: ―¿Ndaa iti cua cuhun ra, ta ña cua cuu nanihin yo chi ra? ¿Atu cua cuhun ra nu iyo ñivi yo chi ñivi griego? ¿Atu cua sacuaha ra chi ñivi griego can? ");
INSERT INTO mioNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ñaan cha cuu tuhun cha cati ra ti cua nanducu yo chihin ra, soco ña cua nanihin yo chihin ra? ¿Ñaan tuhun cuu cha cati ra ti ña cua cuu cuhun yo nu cua cuhun ra? Tacan cahan ñi chi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Cha cua ndihi vico can, ta ni iyo ra Jesuu. Nihin xaan cahan ra, ta quechaha cati ra chi ñi ti: ―Tu cua neti ndo nduta, na cua quichi ndo chihin yu, ta cua cuhve cha cua coho ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tu cua cuinu ini ndo chihin yu, cua cuu anima ndo sava ni ta cua iin yuta cha ña cua ndoco, ta cua coo ndito ndo cuhva cati tutu Ndioo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tuhun can cati ra Jesuu, vati chaha ra cuenda yoso cuhva cua coo ra Tati Ndioo chi ñivi chinu ini chi ra. Ña ta quichi ra Tati Ndioo, vati ña ta cuhun ndico ra Jesuu iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Iyo ñivi chini soho ñi tuhun cha cahan ra Jesuu, ta quechaha cati ñi ti: ―Ndicha ti racan cahan cuenda ra Ndioo ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Inga ñi cati ñi ti: ―Ra Cristo cuu ra, vati ni tava tiñu ra Ndioo chi ra. Soco cati inga tucu ñivi ti: ―Ña cua quichi ra Cristo iti ñuhun Galilea, vati cati tutu Ndioo ti ñivi ra David cua cuu ra Cristo can. ");
INSERT INTO mioNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Cua quichi ra ñuun Belén nu ni chacoo ra David iti chata. Tacan cati tutu Ndioo ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chacan cuu cha ña nduinuun ñivi can, vati ña nihin ñi cuhva ndaa iti ni quichi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Iyo ñivi cuni ñi tihi ñi chi ra ve caa, soco yoni tiin chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tacan cuu, ta cuahan ndico ra tatun can nu iyo ra sutu chahnu chi ra fariseo, ta quechaha nducu tuhun ra ta ra chi ra tatun ti: ―¿Ñacu ña ndaca ndo chi ra? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ta cati ndico ra tatun chi ra ti: ―Yoni cahan cuhva ni cahan racan ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ta cati ra fariseo can chi ra ti: ―Cha ni sandahyu ñahan tahan ra chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ña chinu ini ni iin tuhun ndi chi ra, ta ra cumi tiñu cuu ndi, ta ra fariseo ña ni chinu tahan ini ni iin ra, ");
INSERT INTO mioNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","soco ñivi can ña chito ñi ñaan cha cuu cha cati ley chahnu yo, ta ni ñavi cha vaha vihi ndacu ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Iyo tahan ra Nicodemo nu iyo cuiti ra ta ra. Suvi ra Nicodemo cuu ra ni chahan nu ra Jesuu iin cha cuaa, ta ra cumi tiñu cuu tahan ra, ta quechaha cati ra Nicodemo can chi tahan ra ti: ");
INSERT INTO mioNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ña chaha ley yo cha cua tachi tuni yo chi ñivi, tu ña cua tasoho xihna yo cha cua cati ñi. Ña cua tachi tuni yo, tu ña cua coto vaha yo ñaan cha cuu cha ni savaha ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tacan cuu, ta cati ndico ra ta ra ti: ―¡Joi! Vasi iti ñuhun Galilea quichi tahun. Na cua sacuahun tutu Ndioo, ta cua coton ti ñahni ra cahan cuenda ra Ndioo cua quichi iti ñuhun Galilea ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tacan cuu, ta cuahan ra ta ra iti vehe ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tacan cuu, ta cuahan ra Jesuu iti yucu Olivo. ");
INSERT INTO mioNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tuvi inga quivi, ta cuahan ndico ra iti ve ñuhun. Ni vii nahan, ta cuahan ra, ta nducuiti ndico tucu ñivi nu iyo ra. Ni chacunda ra, ta sa quechaha sacuaha ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tacan cuu, ta vachi ra sacuaha ley chahnu chi ra fariseo nu iyo ra. Vachi ndaca ra ta ra iin ñahan, vati ndehe ra nu ni chacoo ña ndavaha ni chi ra rai inga chiyo, ta sayaha ra chi ña nu nducuiti ñivi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tacan cuu, ta quechaha cati ra chi ra Jesuu ti: ―Maestru, cha tiin ñivi chi ñahya suvi ni hora cha ndacu ña ndavaha ni chi ra rai inga chiyo. ");
INSERT INTO mioNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Iti chata cati ra Moisee tichi ley ti chi yuu cua cahni ndi chi ñahan savaha ndavaha ni can, ta yoho, ¿ñaan cua cati cun? ");
INSERT INTO mioNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tacan cati ra ta ra, vati cuni ndehe ra a ña vaha cua cati ndico ra Jesuu, ta cua cuu tiso ra ta ra cuati ra. Tacan cuu, ta ni chacunda toho ra Jesuu, ta sa quechaha taa ra chi nundaha ra nu ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ni vii nducu tuhun xaan ra ta ra chi ra, ta sa ni chacuinda ndico ra, ta quechaha cati ra chi ra ta ra ti: ―Tu ña ta savaha ndo ni iin cha ndavaha ni, na cua cani xihna ndo yuu chi ña ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tacan cuu, ta ni chacunda toho ndico ra Jesuu, ta taa ndico ra nu ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chini ra ta ra tuhun cha cati ra Jesuu, ta sa quechaha ca chahan ra ta ra. Cuahan xihna ra chanihin ca, ta sa cuahan ndihi ca ra ta ra. Tacan cuu, ta iin tuhun ni ña ñahan can ni ndoo chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ndehe ra Jesuu ti cha cuahan ndihi ca ñivi, ta sa quechaha cati ra chi ña ñahan can ti: ―Yoho sihi, cha cuahan ra ni tiso cuati cun. ¿Atu yoni cua tachi tuni chihun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ta cati ndico ña chi ra ti: ―Ña ta yoni cahan, ra chahnu ―cati ña. Ta cati ra Jesuu chi ña ti: ―Ni ña cua tachi tuni yu chihun. Cuahan, ta ña savaha con cuati ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tacan cuu, ta quechaha cati ndico tucu ra Jesuu chi ñivi can ti: ―Yuhu cuu sava ni ta cua iin ñuhun ndichin cua ndehe ñivi ñuñivi. Tu cua cuinu ini ndo chihin yu, ña cua savaha ndo ndavaha ni, vati ña cua coo ndo nu naan. Cua coo ndito ndo chi ra Ndioo, vati cua coo ra cuu sava ni ta cua iin ñuhun ndichin chihin ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ta cati ra fariseo chi ra ti: ―Suvi ni maun chaha cuenda yoso cuhva iyo cun. Chacan cuu cha ña chito ndi a ndicha cuhva cati cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ta cati ndico ra Jesuu chi ñi ti: ―Chahi cuenda yoso cuhva iye, soco cha ndicha cuu chi, vati chite ndaa iti ni quichi yu, ta chito tahin ndaa iti cua cuhun ndico yu. Maan ndo ña chito ndo ndaa iti ni quichi yu, ta ni ña chito ndo ndaa iti cua cuhun ndico tuqui. ");
INSERT INTO mioNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tachi tuni ndo cuhva saxini maan ndo, soco yoni cua tachi tuni yu vitin. ");
INSERT INTO mioNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Cua queta quivi cha cua tachi tuni yu chi ñivi, soco cua tachi tuni yu iin cha ndicha ndicha, vati uvi ndi cua tachi tuni. Cua tachi tuni yu, ta cua tachi tuni tahan ra ni tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Cha cati ley chahnu ndo ti tu cua queta uvi ñivi, ta inuun inuun cua cahan ñi, chito yo ti tuhun ndicha cahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Cati tuhin yoso cuhva iye, ta cati tuhun tahan ra cuu suti yoso cuhva iye, ta maan ra cuu ra ni tava tiñu chihin yu ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chacan cuu cha nducu tuhun ñi chi ra ti: ―¿Ndaa iti iyo sutu cun? ―cati ñi. Ta cati ndico ra Jesuu chi ñi ti: ―Ña nacoto ndo chihin yu, ta ni ña nacoto ndo chi ra suti. Tu cua nacoto ndo chihin yu, cua nacoto tahan ndo chi ra suti ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tacan cati ra Jesuu, ta sacuaha ra chi ñivi tichi cora soco ndavi ve ñuhun yatin nu iyo xuhun cha samani ñivi chi ra Ndioo, soco ña tiin ñi chi ra, vati ña ta queta hora ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tacan cuu, ta quechaha cati ndico tucu ra Jesuu chi ñivi can ti: ―Yuhu cua cuhin, ta cua nanducu ndo chihin yu, soco ña cua nanihin ndo chihin yu. Cua cuvi ndo, vati ña cua saña ndo cuati ndacu ndo, ta ña cua cuu cuhun ndo nu cua cuhin ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ta cati ñi judío can chi tahan ñi ti: ―Vasi cua cahni ra suvi ni chi maan ra, vati cati ra ti ña cua cuu cuhun yo nu cua cuhun ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tacan cuu, ta quechaha cati ra chi ñi ti: ―Cuenda ñivi ñuñivi iyo maan ndo, soco yuhu iye cuenda ra iyo iti siqui andivi. Iyo ndo cuenda ñuhun ñuñivi, soco yuhu ña iye cuenda chacan. ");
INSERT INTO mioNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chacan cuu cha cati yu ti cua cuvi ndo cuenda ra Ndioo, vati ña cua saña ndo cuati ndacu ndo. Tu ña cua cuinu ini ndo ti yuhu cuu ra cua sacacu chi ndo, cua cuvi ndo, vati ña cua saña ndo cuati ndacu ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tacan cuu, ta nducu tuhun ñi chi ra ti: ―¿Yoo rai cuun? ―cati ñi. Ta cati ndico ra Jesuu chi ñi ti: ―Xihna cuii cha ni cati yu chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Iyo xaan cha cua cati yu yoso cuhva iyo ndo, ta iyo xaan cha cua tachi tuni yu chihin ndo. Rai ndicha cuu ra ni tava tiñu chihin yu, ta cha chahi cuenda chi ndo chi ndihi ñivi ñuñivi ñaan cha cati ra chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tacan cuu, ta ña chito ñi ti cahan ra cuenda sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chacan cuu cha cati ra Jesuu chi ñi ti: ―Cua cahni ndo chi ra cuu sehe ñivi, ta sa cua coto ndo ti yuhu cuu ra. Cua coto ndo ti ña satiñu yu cuenda main, soco cati tuhin cuhva ni sanahan ra suti chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ni tava tiñu ra chihin yu, ta ni iyo ra chihin yu. Ña cua saña ihni ra chihin yu, vati ndihi ni quivi ndacu i cha cua cusii ini ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tacan cati ra Jesuu, ta tuvi ñivi quechaha chinu ini chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tacan cuu, ta quechaha cati ra Jesuu chi ñivi judío ñi ni chinu ini chi ra ti: ―Tu cua savaha ndo cuhva cati yu, ñivi ndicha yu cua cuu ndo, ");
INSERT INTO mioNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ta cua coto ndo ñaan cha cuu cha ndicha, ta sa cua ndoo ndo nu nuna ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ta cati ndico ñi chi ra ti: ―Ñivi ra Abraham ra ni chacoo iti chata tiempu chahnu cuu ndi. Ña ta ñahni nu ni satiñu cuatu ndi chi inga ñivi. ¿Ñacu cati cun ti cua ndoo ndi nu nuna? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ta cati ndico ra Jesuu chi ñi ti: ―Cati ndicha yu ti tu cua savaha ndo cuati, sava ni ta cua iin musu cua cuu ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Chito yo ti ña ndoo cuii ra cuu musu vehe chitoho ra, soco ra cuu sehe chitoho vehe can cuu ra ndoo cuii vehe sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chacan cuu cha tu cua savaha ra cuu sehe chitoho ndo cha cua ndoo ndo nu nuna, cua ndoo ndicha ndo nu nuna. ");
INSERT INTO mioNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yuhu chite ti ñivi ra Abraham cuu ndo, soco cuni ndo cahni ndo chihin yu, vati ña chinu ini ndo tuhun cati tuhin. ");
INSERT INTO mioNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Chahi cuenda chi ndo ñaan cha cuu cha ni sanahan suti chihin yu, soco ndacu ndo cuhva cati ra cuu sutu maan ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ta cati ndico ñi chi ra ti: ―Ra Abraham cuu sutu ndi ―cati ñi. Ta cati ra Jesuu ti: ―Tu sehe ra Abraham chi ndo, cua savaha ndo cuhva cha ni savaha maan ra nu quichi quivi. ");
INSERT INTO mioNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yuhu cha cati yu cha ndicha chi ndo cuhva cha ni cati ra Ndioo chihin yu, soco vitin cuni cahni ndo chihin yu. Ñavi cuhva ni savaha ra Abraham cuu chacan. ");
INSERT INTO mioNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ndacu ndo cuhva cuni ra cuu sutu maan ndo ―cati ra. Ta cati ndico ñi chi ra ti: ―Ñavi sehe cuati cuu ndi. Sehe ndicha ra Ndioo cuu ndi, vati maan ra cuu sutu ndi ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ta cati ra Jesuu chi ñi ti: ―Tu ndicha ti ra Ndioo cuu sutu ndo, cua cuni mani ndo chihin yu, vati iti nuun iyo ra quichi yu. Ñavi yuhu cati chi ra ti cua quichi yu, soco maan ra cuu ra ni tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ña nituni ini ndo tuhun cati yu, vati ña cuni ndo tasoho ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Run cuihna cuu sutu ndo, ta cuni savaha ndo cuhva cuni maan run, ta chahni run chi ñivi nda cua nda xihna cuii. Ña tuhva run savaha run cha ndicha, vati ña chito run ñaan cha cuu cha ndicha, ta sandahyu ñahan run. Tacan ni iyo run, vati ña ndicha run, ta maan run cuu run savaha cha sandahyu ñahan ñivi chi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ña chinu ini ndo cha cati yu, vati cati yu cha ndicha. ");
INSERT INTO mioNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yoni ndo cua cuu cati ti iyo cuati yu. Iyo cha cua cuinu ini ndo chihin yu, vati cati yu cha ndicha chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ndihi ñivi Ndioo tasoho tuhun cahan ra, soco ña tasoho maan ndo chi ra, vati ñavi ñivi ra chi ndo ―cati ra Jesuu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ta nducu tuhun ñivi judío can chi ra Jesuu ti: ―¿Atu ña ndicha ti rai ñuhun Samaria cuun? ¿Atu ña ndicha ti iyo tati cuihna chihun? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ta cati ndico ra Jesuu chi ñi ti: ―Ñahni tati cuihna iyo chi yu. Sacahnu yu chi ra suti, soco ña sacahnu ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ña nduqui cuhva cha cua sacahnu ndo chihin yu, soco iyo ra cuni ra cha cua sacahnu ndo chihin yu, ta maan ra cuu ra cua tachi tuni chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cati ndicha yu ti tu iyo ñivi cua savaha ñi cuhva cati yu, ña cua ndoyo ñuhun ñi, soco cua coo ndito ñi chi ra Ndioo ndihi ni quivi ndihi ni tiempu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ta cati ndico ñivi judío can chi ra ti: ―Vitin cha chito ndi ti iyo run tati cuihna chihun. Cha ni chihi ra Abraham ra cuu ñivi ndi tiempu chahnu, ta ni chihi tahan ndihi ra ni cahan cuenda ra Ndioo, ta cati maun ti tu cua savaha ñivi cuhva cati cun, ña cua cuvi cuii ñi, soco cua coo ndito ñi chi ra Ndioo ndihi ni quivi ndihi ni tiempu. ");
INSERT INTO mioNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Cahnu xaan rai cuu ra Abraham cha cuenda ra Ndioo, ta chihi maan ra. Chihi tahan ra ni cahan cuenda ra Ndioo, ta maun ña cahnu cun cuu. ¿Yoo rai cuun? ―cati ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ta cati ndico ra Jesuu chi ñi ti: ―Tu cua cati yu ti cahnu xaan rai cui, ñahni yavi ndaa cha cua cati yu, vati maan ra suti cuu ra cua cati ti rai cahnu cui. Cati ndo ti sacahnu ndo chi ra Ndioo, ta suvi ra cuu ra cuu suti. ");
INSERT INTO mioNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ña nacoto ndo chi ra, soco yuhu nacoto vahi chi ra. Tu cua cati yu ti ña nacote chi ra, cua sandahyu ñahin cuhva sandahyu ñahan maan ndo. Yuhu nacote chi ra, ta ndacu i cuhva cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Sii xaan cuni ra Abraham ñivi ndo, vati cua ndehe ra ti cua cacu yu nu ñuhun ñuñivi ya. Cha ni ndehe ra chihin yu, ta cusii ini ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ta cati ñivi judío can chi ra ti: ―Ña ta queta maun ni uvi xico uchi cuiya cun, ta cati cun ti cha ni ndehun chi ra Abraham ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ta cati ndico ra Jesuu chi ñi ti: ―Cati ndicha yu ti ña ta cacu ra Abraham, ta cha ni iye ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tacan cuu, ta quechaha canihin ñi yuu, vati cua cani ñi chi ra, soco ni chacuindi xehe ra, ta quee ra soco ndavi ve ñuhun can. Tacan ni quee ra nu iyo cuiti ñi, ta cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Cuahan ra Jesuu, ta ndehe ra ti iyo iin ra cuaa. Cuii nuun ra, vati tacan ni caa nuun ra nda ni cacu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tacan cuu, ta quechaha nducu tuhun ra sacuaha chi ra Jesuu ti: ―Maestru, ¿yoo savaha cuati, ta cacu ra cha cuii nuun ra? ¿Atu savaha maan ra cuati a savaha sutu ra chi sihi ra cuati? ―cati ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ta cati ndico ra Jesuu chi ra ti: ―Ñahni cuati savaha rahya, ta ni ñahni cuati savaha sutu ra chi sihi ra. Tacan tahan ni cacu maan ra, vati cua ndehe ñivi yoso cuhva cua savaha ra Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iyo cha cua savahi cuhva cuni ra ni tava tiñu chihin yu, vati ni vii cuu vitin. Cua queta quivi, ta ña cua cuu ca. ");
INSERT INTO mioNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ni iye nu ñuhun ñuñivi, ta cui sava ni ta cua iin ñuhun ndichin. Chacan cuu cha cua tindei chi ñivi ñuñivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tacan ni cati ra, ta sa tivi sivi ra nu ñuhun, ta savaha ra ndahyu nu tivi sivi ra, ta taa ra chi chi nuun ra cuaa can. ");
INSERT INTO mioNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tacan cuu, ta quechaha cati ra Jesuu chi ra ti: ―Cuahan iti soco Siloé, ta cua nacata cun nuun cun ―cati ra. Tuhun Siloé can cuni cati ti cha tachi yu chihun. Tacan cuu, ta cuahan ra cuaa can, ta nacata ra nuun ra. Quichi ndico ra, ta ndichin vaha ndehe ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ndehe ñivi ñuun ra chi ra, ta ndehe tahan ñivi nacoto chi ra, ta chito ñi ti cha chica ra caya ra, ta quechaha nducu tuhun ñi ta ñi ti: ―¿Atu ñavi ra chica caya cuu ra? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Iyo ñi cati ñi ti: ―Suvi ra cuu ra ―cati ñi. Ta inga ñi cati ti: ―Ñavi, soco cuhva caa racan caa ra ―cati ñi, soco maan ra cati ti: ―Yuhu cui. ");
INSERT INTO mioNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chacan cuu cha nducu tuhun ñi chi ra ti: ―¿Yoso ni nduvaha nuun cun? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Cati ndico ra chi ñi ti: ―Nacoto ndo chi ra nani Jesuu. Savaha maan ra ndahyu, ta taa ra chi chi nuin, ta cati ra ti na cua cuhin iti Siloé, ta cua nacate nuin. Chacan cuu cha chahin, ta nacate nuin, ta ndundichin vaha ndehi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ta nducu tuhun ñi chi ra ti: ―¿Ndaa iyo racan? ―cati ñi. Ta cati ndico ra chi ñi ti: ―Ña chite ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tacan cuu, ta ni chandaca ñivi can chi ra nuun ra fariseo, vati xihna ca cuii nuun ra, ta vitin ndichin vaha ndehe ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Quivi sábadu quivi ii ni savaha ra Jesuu ndahyu can, ta sanduvaha ra nuun ra cuaa can. ");
INSERT INTO mioNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Chacan cuu cha quechaha nducu tuhun tahan ra fariseo chi ra nduvaha nuun can ti: ―¿Yoso cuu cha ni ndundichin ndehun? ―cati ra. Ta cati ndico ra chi ra ti: ―Ni taa iin ra ndahyu nuin, soco nacate chi chi, ta ni ndundichin vaha ndehi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Chacan cuu cha iyo ra fariseo cati ra chi ra ti: ―Ña ni tava tiñu ra Ndioo chi racan, vati ña cumi ra quivi ii quivi cahnu ―cati ra. Ta cati ndico inga ra ti: ―Cahnu xaan cuhva ni savaha ra, ta ña cuu savaha rai ndacu cuati chacan ―cati ra. Tacan cuu, ta quechaha ndusaca cuni ra ta ra, ");
INSERT INTO mioNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ta nducu tuhun ndico tucu ra fariseo chi ra ti: ―¿Ñaan cha cuu cha cua cati maun? Nuun maun cha ni sanduvaha ra ―cati ra. Ta cati ndico ra ti: ―Yuhu cati ti iyo ra cuenda ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tacan cuu, ta ña cuni cuinu ini ra judío can ti ni nducuii ndicha nuun ra, ta ndundichin ndico ndehe ra. Cana xihna ra chi sutu ra chi sihi ra, ");
INSERT INTO mioNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ta quechaha nducu tuhun ra chi ñi ti: ―¿Atu sehe ndo chi rahya? ¿Atu cuaa ra, ta cacu ra? ¿Ñacu ndichin vaha ndehe ra vitin? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ta cati ndico sutu ra chi sihi ra ti: ―Chito ndi ti rahya cuu sehe ndi, ta chito ndi ti cuaa ra, ta cacu ra, ");
INSERT INTO mioNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","soco ña chito ndi yoso cuhva ni ndundichin vaha ndehe ra vitin, ta ni ña chito ndi yoo rai ni sanduvaha nuun ra. Cua nducu tuhun ndo chi maan ra, vati cha cahnu ra. Cua cati ndico maan ra ñaan cha ni tahan ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tacan cati sutu ra chi sihi ra, vati yuhvi ñi chi ra judío can, vati cha iyo vaha tuhun chi ra judío ti tu cua cati ñivi ti cha ni tava tiñu ra Ndioo chi ra Jesuu, cua tava ndaa ra chi ñi ve ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chacan cuu cha cati ñivi ra ti cha cahnu ra, ta na cua nducu tuhun maan ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chacan cuu cha cana ndico tucu ra judío can chi ra nduvaha nuun can inga chaha, ta cati ra chi ra ti: ―Cua cati cun iin cha ndicha, vati iyo cun iti nuun ra Ndioo, ta chito ndi ti ra ndacu cuati cuu racan ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ta cati ndico ra chi ra judío can ti: ―Ña chite tu ndacu ra cuati, soco chehe cuu cha ni chite. Chite ti ra cuaa cui nu quichi quivi, soco vitin ndichin vaha ndehi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ta nducu tuhun ndico ra ta ra chi ra ti: ―¿Ñaan cha ni savaha ra chihun? ¿Yoso ni sanduvaha ra nuun cun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ta cati ndico ra chi ra ti: ―Cha cati yu chihin ndo, soco ña tasoho ndo. ¿Ñacu cuni ndico tucu ndo cuni soho ndo? ¿Atu cuni tahan ndo coo ndo chi ra? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tacan cuu, ta quechaha nduxaan ra ta ra chi ra, ta cati ra chi ra ti: ―Iyo maun cuenda ra, soco iyo maan ndi cuenda ra Moisee. ");
INSERT INTO mioNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Chito ndi ti cahan ra Ndioo chi ra Moisee, soco ña chito ndi yoo rai cuu racan ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ta cati ndico ra ndahvi can chi ra ta ra ti: ―Iyo xaan cuni yu, vati ña chito ndo yoo rai cuu ra, ta ni sanduvaha ra nuin. ");
INSERT INTO mioNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Chito yo ti ña tasoho ra Ndioo chi ñivi ndacu cuati, soco tasoho ra chi ñivi sacahnu chi ra, ta tasoho ra chi ñivi ndacu cuhva cuni maan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nda quivi cha ni tuvi ñuhun ñuñivi, ta yoni sanduvaha nuun ñivi cuaa cha cuii tahan nuun ñi, ta cacu ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ni tava tiñu ra Ndioo chi ra ni sanduvaha chihin yu. Tu ña ndicha, ña cua cuu savaha ra cuhva cha ndacu ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ta cati ndico ra ta ra chi ra ti: ―Iyo xaan cuati chihun, ta ni cacu cun. Ña cua tasoho ndi cha cahun ―cati ra. Tacan cuu, ta tava ndaa ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ni chito ra Jesuu ti cha ni tava ndaa ra ta ra chi ra ndahvi can, ta nanducu ra Jesuu chi ra, ta nducu tuhun ra chi ra ti: ―¿Atu chinu ini cun chi ra cuu sehe ñivi? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ta cati ndico ra chi ra Jesuu ti: ―¿Yoo ra cuu ra, ta ra chahnu? Cua sanahun chihin yu, vati cua cuinu ini yu chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ta cati ndico ra Jesuu chi ra ti: ―Cha ni ndehun chi ra, ta vitin ndatuhun cun chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tacan cuu, ta sacahnu ra chi ra Jesuu, ta cati ra chi ra ti: ―Chinu ini yu chihun, ra chahnu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ta cati ndico ra Jesuu chi ra ti: ―Quichi yu nu ñuhun ñuñivi ya, vati cua tachi tuni yu chi ñivi ya. Chacan cuu cha cua ndundichin ndehe ñivi cuaa, ta ñivi cati ti ndichin vaha ndehe cua nducuii nuun ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Iyo tahan ra fariseo yatin nu inda ra Jesuu, ta chini soho ra cha cahan ra, ta quechaha nducu tuhun ra chi ra ti: ―¿Atu cuii tahan nuun ndi cuni cun? ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Tu cuaa nuun ndo, ñahni cuati ndo cua coo, soco cati ndo ti ndichin vaha ndehe ndo. Chacan cuu cha iyo xaan cuati ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ni vii cahan ra Jesuu chi ra: ’Cati ndicha yu chi ndo ti tu cua queta iin rai nu iyo cora nu indi sana ndo, ta ña cua quihvi ra iti chiyo yu cora, soco cua quihvi xehe ra, ñavi chitoho ri cuu ra. Ñasuhu cuu ra, ");
INSERT INTO mioNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","soco ra cuu chitoho ri―cua quihvi vaha ra iti yu cora. ");
INSERT INTO mioNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Cua nuna ra cumi chi ri, ta cua quihvi chitoho ri, ta cua cuni soho ri ndusu ra, ta cua cana ra sivi ri, ta cua cundaca ra chi ri inga chiyo. ");
INSERT INTO mioNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cua tava xihna ra chi ri tichi cora, ta tacan sa cuahan ra iti nuun, ta ndicu ri chi ra, vati nacoto ri chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ña cua cundicu ri chi inga ñivi, soco cua cunu ndico ri, vati ña nacoto ri chi ñi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Cati tuhun ra Jesuu cuhva can chi ñi, soco ña nituni ini ñi cha cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tacan cuu, ta cati ndico ra Jesuu chi ñi ti: ―Cati ndicha yu ti yuhu cuu sava ni ta cua iin nu cua yaha ri mbee. ");
INSERT INTO mioNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ña ta quichi yu, ta quichi ñivi cuni cundaca chi ri. Ñasuhu cuu ñican, soco ña tasoho ri mbee chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yuhu cuu sava ta cua iin nu cua yaha ri. Tu cua cuinu ini ñivi chihin yu, cua coo vaha ñi chi ra Ndioo. Cua sacuenda yu chi ñi nu iyo ñi, ta cua nihin ñi ndihi cha cua cuni ñuhun ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Vachi run ñasuhu, vati cua suhu run chi ri mbee. Cua sandoyo ñuhun run chi ri, ta cua cahni run chi ri, soco yuhu vachi, vati cua coo ndito ñivi chi ra Ndioo. Vaha xaan ca cua coo ñi chi ra cuni yu. ");
INSERT INTO mioNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yuhu cuu sava ni ta cua iin rai cumi vaha chi sana ra. Tu cua quichi iin tu ndoho chi sana ra, cua nducu ra cuhva cha cua cacu ri. Masi cua ndoyo ñuhun maan ra, soco tacan ni cua sacacu ra chi sana ra. ");
INSERT INTO mioNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tu ra musu cuu ra, ta ndehe ra ti vachi ri xaan, cua nacoo ihni ra chi ri, ta cua cunu ra, vati ñavi chi maan ra cuu ri. Tacan ni cua tiin ri xaan can chi ri, ta ndihi ni ri cua cuita cuati. ");
INSERT INTO mioNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tacan ni cua savaha ra cuu musu can, vati musu ni cuu ra, ta ña cua tichaha ra chi sana ra cuu chitoho ra. ");
INSERT INTO mioNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Yuhu cuu sava ni ta cua iin rai cumi vaha chi sana ra. Nacoto vahi chi ñivi yu, ta nacoto vaha ñi chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ta ni cuhva nacoto ra cuu suti chihin yu, ta nacote chihin ra. Cua cuvi yu cuenda ñivi yu, vati tacan ni cua sacacu i chi ñi cuhva sacacu ñivi chi sana ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ni iyo inga ñivi yu, soco ñavi ñivi iyo vitin cuu ñi. Ni cua coo ñi chihin yu nu cuahan quivi, ta cua tasoho ñi cha cua cahan yu, soco ini ñivi cua cuu ndihi ñi, ta ini rai cua cucumi chi ndihi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Chacan cuu cha cuni mani ra suti chihin yu, vati cua cuvi yu cuenda ñivi yu. Cua cuvi yu, vati cua coo ndito ndique. ");
INSERT INTO mioNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ñahni ndatu cha cua cahni ñivi chihin yu, soco yuhu cua sañe chihin yu cha na cua cahni ñi chihin yu. Iyo tu ndee ini chihin yu. Chacan cuu cha cua cuhve ndatu chi ñi, ta cua cuvi yu, soco iyo tu ndee ini chi yu, ta cua natacu ndique. Tacan ni cati suti chihin yu ―cati ra Jesuu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ndusaca ndico tucu cuni ñivi judío can, ta chini soho ñi tuhun cahan ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tuvi ñi cati chi tahan ñi ti: ―Iyo cuihna chi ra, ta ña vaha cuni xini ra. Ña cua tasoho yo cha cahan ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ta cati inga ñi ti: ―Ñahni cuihna chi ra, vati ña tuhva ñivi iyo cuihna cahan ñi tacan. Tu iyo cuihna chi ra, ña cua cuu sanduvaha ra nuun ñi cuaa ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Cha ni queta tiempu vichin, ta sacahnu ndico tucu ñivi judío inga vico iti ñuun Jerusalén, vati iti chata cundee ñi sandaa ñi ve ñuhun cahnu ñi. Chacan cuu cha sacahnu ñi vico can. ");
INSERT INTO mioNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tacan cuu, ta chica cuu ra Jesuu iti tichi soco ndavi ve ñuhun can nu cuu chi coredor Salomón. ");
INSERT INTO mioNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Queta ñivi judío can nu iyo ra, ta chasi ñi nuun ra, vati xaan xaan cuni ñi ndehe ñi chi ra, ta nducu tuhun ñi chi ra ti: ―¿Yoso quivi, ta sa cua cati cachin cun chi ndi? Tu ra Cristo cuun, tu cha ni tava tiñu ra Ndioo chihun, cua cati cachin cun chi ndi ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ta cati ndico ra Jesuu chi ñi ti: ―Cha ni cati yu, soco ña chinu ini ndo. Cha ni ndehe ndo cuhva ni savahi, ta savahi chacan, vati chaha ra suti tu ndee ini chihin yu. Chacan cuu cha cua cuu coto ndo yoo rai cui. ");
INSERT INTO mioNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ña chinu ini ndo chihin yu, vati ña iyo ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tasoho ñivi yu tuhun cha cahin, ta nacote chi ñi, ta iyo ñi chihin yu, ta tacan ni iyo tucu ri mbee chi chitoho ri. ");
INSERT INTO mioNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Cua cuhve cha cua coo ndito ñivi yu chihin yu ndihi ni quivi ndihi ni tiempu. Ña cua ndoyo ñuhun ñi, ta ni ña cua tava ndaa ñivi chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Iyo tu ndee ini chi ñivi, soco iyo xaan ca tu ndee ini chi ra suti, ta maan ra cuu ra chaha cha chinu ini ñi chihin yu. Chacan cuu cha ña cua cuu tava ndaa ñivi chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ini rai cuu ndi chi suti ―cati ra Jesuu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tacan cuu, ta canihin ndico tucu ñivi judío can yuu, vati cua cani ñi chi ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ta cati ndico tucu ra chi ñi ti: ―Chaha ra suti tu ndee ini, ta cuaha xaan cha vaha savahi chi ndo. Vasi cua cani ndo yuu chihin yu, vati savahi chacan ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ta cati ndico ñivi can chi ra ti: ―Ñavi cuenda cha vaha cha ni savahun cua cani ndi, soco cua cani ndi chihun, vati cha cahun ndavaha ni cuenda ra Ndioo. Cua cani ndi chihun, vati rai ñuñivi cuu cun, ta cati cun ti Ndioo cuu cun ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ta cati ra Jesuu chi ñi ti: ―Cha iyo nu cati tutu Ndioo ti cati ra Ndioo ti ndioo cuu ñivi ra, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Cati ra Ndioo ti ndioo cuu ñivi tasoho tuhun ra, ta ña cuu cati yo ti ña ndicha tutu Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Cati ndo ti cahan yu ndavaha ni chi ra Ndioo, vati cati yu ti sehe Ndioo cui, soco maan ra chaha tiñu chihin yu, ta tachi ra chihin yu ihya nu ñuhun ñuñivi ya. ");
INSERT INTO mioNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tu ña cua savahi cuhva cuni ra suti, na ña cua cuinu ini ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tu cua savahi cuhva cuni ra, vasi ña cua cuinu ini ndo chihin yu, soco na cua cuinu ini ndo ti cuhva cuni maan ra cuu chi. Tacan ni cua coto vaha ndo ti iyo ra suti chihin yu, ta iyo yu chihin ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tacan cuu, ta cuni ndico tucu ñi tiin ñi chi ra Jesuu, soco quee ra cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tacan cuu, ta cuahan ra Jesuu. Yaha ra inga chiyo yuta Jordán, ta queta tucu ra nu ni sacuanduta xihna ra Juaan chi ñivi nu quichi quivi, ta ndoo nuun ra tican. ");
INSERT INTO mioNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tuvi ñivi cuahan nu iyo ra, ta quechaha cati ñi chi tahan ñi cuenda ra Jesuu ti: ―Ñahni cuhva ni savaha ra Juaan, soco cha ndicha ndicha cuu cha cati ra yoso cuhva cua coo rahya ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tacan cuu, ta tuvi ñivi chinu ini chi ra Jesuu tican inga chiyo yuta Jordán can. ");
INSERT INTO mioNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ni chacoo iin ra ñuun Betania, ta Lázaro nani ra. Cuhva ña María chi ña Marta chi ra, ta cuhvi xaan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María can cuu ña ni choso aceite vixin chahan chaha ra chahnu Jesuu, ta nacuhva ña ixi xini ña chaha ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chacan cuu cha tachi ñi ñahan can tuhun chi ra Jesuu, ta cati ñi ti: ―Ra chahnu, cuhvi xaan ra cuu amigu cun ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Queta tuhun can nuun ra Jesuu, ta quechaha cati ra ti: ―Cuhvi ra, soco ña cua cuvi ra. Cuhvi ra, vati tacan ni cua ndehe ñivi ti iyo tu ndee ini chi ra Ndioo. Chacan cuu cha cua sacahnu ñi chi ra cuu sehe Ndioo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Cuni mani xaan ra Jesuu chi ña Marta chi cuhvi ña chi ra Lázaro. ");
INSERT INTO mioNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Chini ra Jesuu tuhun cha cuhvi ra Lázaro can, soco ni nducuee nuun ra nu iyo ra inga uvi quivi. ");
INSERT INTO mioNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tacan cuu, ta quechaha cati ra chi ra sacuaha chi ra ti: ―Coho, vati cua cuhun ndico yo iti ñuhun Judea ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ta cati ndico ra sacuaha chi ra ti: ―Maestru, cuni cani ñivi judío yuu chihun vitin. ¿Atu cua cuhun ndicon tican? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ta cati ndico ra Jesuu chi ra ti: ―Uchi uvi hora cuu chi iin nduvi. Tu cua caca cuu yo chinucahni, ta cua savaha yo cha vaha, ña cua ndoyo ñuhun yo, vati ndichin vaha ndehe yo. ");
INSERT INTO mioNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tu cua caca cuu yo cha cuaa, ta cua savaha yo ndavaha ni, cua ndoyo ñuhun yo, vati ñahni cha chini tuni iyo chi yo. ");
INSERT INTO mioNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tacan cati ra Jesuu, vati ña ta queta hora ra, ta cati ndico ra chi ra ti: ―Quixi ni ra Lázaro amigu yo, soco cua cuhin, vati cua sandoye chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ta cati ndico ra sacuaha chi ra Jesuu ti: ―Ra chahnu, cua ndoyo maan ra, vati cati cun ti quixi ni ra ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tacan ni cahan ra Jesuu iin cuhva, vati cha ni chihi cuii ra Lázaro, soco saxini ra ta ra ti quixi ni ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chacan cuu cha quechaha cati cachin ra chi ra ta ra ti: ―Cha chihi cuii ra Lázaro, ");
INSERT INTO mioNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ta cusii ini yu, vati ña iye tican. Vaha xaan ca cha tacan cuenda maan ndo. Chacan cuu cha cua cuinu ini ndo. Na coho vitin ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tacan cuu, ta quechaha cahan ra Tuma ra cuu xinihin, ta cati ra chi tahan ra ti: ―Coho, vati cua cuvi tahan yo chi ra ―cati ra, vati cua cuhun ndico ra nu iyo ñivi cuxaan ini chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tacan cuu, ta cuahan ra Jesuu iti ñuun Betania, ta cati ñi chi ra ti cha queta cumi quivi cha ni cuchi ra Lázaro. ");
INSERT INTO mioNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yatin ñuun Jerusalén iyo ñuun can. Vasi queta iin sava hora caca yo. ");
INSERT INTO mioNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Chacan cuu cha queta ñivi judío nu iyo ña Marta chi ña María. Tuvi ñi queta, ta cua tindee ñi chi ñi ñahan can, vati chihi cuhva ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tacan cuu, ta sa queta tuhun nuun ña Marta ti cha vachi ra Jesuu, ta quee ña cuahan ña, vati cua satahan ña chi ra, soco ndoo ña María vehe. ");
INSERT INTO mioNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tacan, ta tahan ña Marta chi ra, ta quechaha cati ña ti: ―Ra chahnu, cha ni chihi cuhve, vati ña iyo cun ihya, ");
INSERT INTO mioNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","soco chite ti cua savaha ra Ndioo ñaan cha cua cahun chi ra ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ta cati ndico ra Jesuu chi ña ti: ―Cua nandoto ndico ra cuhvon ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ta cati ña Marta chi ra ti: ―Chite ti cua coo ndito ndico ra quivi cua natacu ndico ñivi ndii quivi cua tachi tuni ra Ndioo chi ñivi ñuñivi ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ta cati ndico ra Jesuu chi ña ti: ―Yuhu cua savahi cha cua coo ndito ndico ñivi. Cua savahi cha cua natacu ndico ñi. Tu cua cuinu ini ñivi chihin yu, masi cua cuvi ñi, soco cua coo ndito ñi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tu cua cuinu ini ñivi ni iyo ndito chihin yu, ña cua cuvi ñi cuenda ra Ndioo. ¿Atu chinu ini maun chacan? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ta cati ña chi ra ti: ―Chinu ini yu, ra chahnu. Chinu ini yu ti ra Cristo cuun, ta sehe Ndioo cuun, ta cha ni tachi ra Ndioo chihun ihya nu ñuhun ñuñivi ya ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tacan ni cati ña Marta, ta cuahan ndico ña, ta cana ña chi María cuhvi ña. Cahan xehe ña chi ña, ta cati ña ti: ―Cha queta ra maestru, ta cana ra chihun ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tacan cuu, ta quii xaan ni chacuinda ña, ta cuahan ña nu iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ña ta quihvi ra tichi ñuun can, vati ni vii iyo ra nu ni cha satahan ña Marta chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ni iyo ñivi judío can chi ña, ta chaha ñi tu ndee ini chi ña. Ndehe ñi ti quii xaan ni chacuinda ña, ta cuahan ña. Chacan cuu cha ndicu ñi chi ña, vati saxini ñi ti cuahan ña nu ni cuchi ra ndii can, ta cua ndahyu ña tican. ");
INSERT INTO mioNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Queta ña María nu iyo ra Jesuu. Ndehe ña chi ra, ta sa chahnu chiti ña iti nuun ra, ta quechaha cati ña chi ra ti: ―Ra chahnu, ni chihi cuhve, vati ña iyo cun ihya ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ndehe ra Jesuu ti chacu xaan ña, ta chacu tahan ñivi judío can. Chacan cuu cha ndahvi xaan quechaha cuni anima ra. Ña vaha cuni ra, ");
INSERT INTO mioNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ta quechaha nducu tuhun ra chi ñi ti: ―¿Ndaa cuu nuun ni cuchi ndo chi ra? ―cati ra. Ta cati ndico ñi chi ra ti: ―Nahan, ra chahnu, ti cua ndehun ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tacan cuu, ta quechaha chacu tahan ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ta cati ñivi judío can chi tahan ñi ti: ―Ndicha ti cuni xaan ra chi ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Iyo inga ñi cati ñi ti: ―Cha ni sanduvaha ra chi ra cuaa. Vasi cua cuu tindee tahan ra chi ra Lázaro, tu ni vii ndito ra, ta queta ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ndahvi xaan quechaha cuni ndico anima ra Jesuu cha queta ra nu ni cuchi ra Lázaro. Yavi yuu cuu chi, ta ndasi yuu yuhu chi. ");
INSERT INTO mioNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tacan cuu, ta cati ra Jesuu chi ñi ti: ―Cua sachiyo ndo yuu can ―cati ra. Ta quechaha cati ña Marta ña cuu cuhva ra ndii can ti: ―Ra chahnu, ini xaan chahan, vati cha queta cumi quivi cha ni chihi ra ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ta cati ndico ra Jesuu chi ña ti: ―Cha cati yu ti tu cua cuinu ini cun, cua ndehun ti iyo xaan tu ndee ini chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chacan cuu cha sachiyo ñi yuu can, ta ndehe ndaa ra Jesuu iti siqui andivi, ta cati ra chi ra Ndioo ti: ―Tata, chahi iin tiahvi ndioo chihun, vati cha ni tasohun tuhun cahan yu. ");
INSERT INTO mioNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Chite ti ndihi ni hora tasohun cha cahin. Tacan cati yu, vati cua cuni soho ñivi ya, ta cua cuinu ini ñi ti maun cuu ra ni tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tacan cati ra, ta sa cana chaa ra ti: ―Yoho Lázaro, quee, xaa ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tacan cuu, ta quee ra Lázaro can, ta ni vii isucu sahma ndii chi ra. Chacan cuu cha nuhni ndaha ra. Nuhni chaha ra, ta cha nuhni pañitu nuun ra. Tacan cuu, ta cati ra Jesuu chi ñi ti: ―Cua ndachi ndo chi ra. Cua saña ndo na cuhun ra ―cati ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ñivi judío can cuu ñi ni queta vehe ña María, ta ndehe ñi cha ni savaha ra Jesuu, ta tuvi ñi chinu ini chi ra, ");
INSERT INTO mioNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","soco iyo ñi cuahan ñi nu iyo cuiti ra fariseo, ta chaha ñi cuenda ñaan cha ni savaha ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chacan cuu cha cati ra sutu chahnu chi ra fariseo ti cua nducuiti ndihi ra cumi tiñu can. Tacan cuu, ta nducu tuhun ra chi tahan ra ti: ―¿Ñaan cha cuu cha cua savaha yo, vati cuaha xaan cuhva cha ni savaha ra Jesuu can? ");
INSERT INTO mioNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tu ña cua casi yo nuun ra, cua cuinu ini ndihi ñivi chi ra, ta cua quichi sandaru ñuun Roma, ta cua sandoyo ñuhun ra ve ñuhun ya, ta cua cahni ra chi ndihi yo chi ñivi ñuun yo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Iyo ra Caifás. Sutu chahnu cuu ra cuiya can, ta quechaha cati ra chi ra ta ra ti: ―Ña chito cuii ni ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ña chito ndo ti vaha xaan ca cha cua cuvi iin tuhun ni maan ra Jesuu can, ta cua cacu ndihi maan yo. Tacan, ta ña cua ndoyo ñuhun yo chi ñivi yo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ñavi cuenda suvi ni maan ra cahan ra Caifás can, vati sutu chahnu cuu ra cuiya can. Chacan cuu cha cati ra ti cua cuvi ra Jesuu, ta cua cacu ndihi ñivi judío can. ");
INSERT INTO mioNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ñavi cuenda ñivi judío ni cua cuvi ra, soco cua cuvi ra, vati tacan ni cua sanducuiti ra chi ndihi ñivi chinu ini chi ra Ndioo, ta ini ñivi cua cuu ndihi ñi ―masi inga ñuhun iyo ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chacan cuu cha quivi can quechaha nducu ra judío can cuhva yoso cuhva cua cahni ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chacan cuu cha ña chahan ca ra Jesuu nu iyo ñivi judío can. Quee ra tican, ta cuahan ra iti ñuun Efraín, ta tichi cuhu cuu ñuun can. Tican ni ndoo ra chi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Cha yatin cua coo tucu vico sacahnu ñivi judío cuenda cha ni cacu ñi ñuhun Egipto iti chata. Chacan cuu cha tuvi ñivi cuahan iti ñuun Jerusalén. Iti nuun cuahan ñi, vati cua cu‑ii xihna ñi cuni ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nanducu ñi chi ra Jesuu ñuun Jerusalén can, soco ña nanihin ñi chi ra. Queta ñi ve ñuhun, ta quechaha nducu tuhun ñi chi tahan ñi ti: ―¿Yoso saxini ndo? ¿Atu cua quichi ra vico ya a ña cua quichi ra? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ta cha tachi ra sutu chahnu chi ra fariseo tuhun, vati tu cua coto ñivi ndaa iyo ra, cua cati ndico ñi, vati cua tiin ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Cumani iñu quivi cha cua nducahnu vico can, ta queta ra Jesuu ñuun Betania nu iyo ra Lázaro ra ni natacu ndico ni savaha ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chacan cuu cha sacahnu ñi iin vico luhu cuenda ra Jesuu. Tiso vaha ña Marta, ta iyo tahan ra Lázaro chi ra Jesuu mesa can. ");
INSERT INTO mioNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tacan cuu, ta quihin ña María iin sava litru aceite vixin chahan. Yahvi xaan chi, ta choso ña chi chi chaha ra Jesuu, ta nacuhva ña chaha ra chi xini ña. Ni tani xico nduta vixin can niniin vehe. Tacan savaha ña, vati cuni xaan ña chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Iyo tahan ra Juda Iscariote, vati sacuaha tahan ra chi ra Jesuu. Racan cuu ra cua xico tuhun chi ra, ta quechaha nducu tuhun ra Juda can ti: ");
INSERT INTO mioNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Ñacu ña ni xico ña nduta vixin ya? Tacan, ta nihin ña uni ciendu xuhun, ta cua tindee ña chi ñivi ndahvi. ");
INSERT INTO mioNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tacan ni cati ra Juda, soco ña tichaha ni ra yoso cuhva iyo ñivi ndahvi can, vati ñasuhu cuu ra. Maan ra cuu ra cumi xuhun ra ta ra, ta suhu ra cha samani ñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tacan cuu, ta cati ra Jesuu chi ra ti: ―Saña chi ña. Na cua cumi ña chi chi nda cua nda quivi cua cuchi yu, ");
INSERT INTO mioNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","vati ni cua coo ñivi ndahvi chi ndo ndihi ni quivi, soco yuhu ña nahan ca cua coi chi ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tacan cuu, ta quechaha chito ndihi ñivi judío ti cha iyo ndico ra Jesuu tican. Chacan cuu cha cuahan ñi, vati cuni ndehe tucu ñi chi ra Jesuu, ta cuni ndehe tahan ñi chi ra Lázaro, vati cha iyo ndito ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ta ra sutu chahnu can―cuni ra cahni ra chi ra Lázaro, ");
INSERT INTO mioNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","vati tuvi ñivi judío can ni ndehe cha ni tahan ra Lázaro can, ta saña ñi chi ra sutu chahnu, ta chinu ini ñi chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tuvi ñivi cuu ñi cha iyo ñuun Jerusalén, vati quichi ñi vico. Tuvi inga quivi, ta queta tuhun nuun ñi ti cha vachi ra Jesuu iti ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Chacan cuu cha quihin ñi ndaha ticaha, ta quee ñi. Cuahan ñi, vati cua satahan ñi chi ra. Tacan cuu, ta quechaha cana chaa ñi ti: ―¡Cahnu xaan cuu ra chahnu! ¡Cahnu xaan rai cuu ra vachi cuenda ra chahnu! ¡Cua cundaca ñahan ra chi ndihi yo iyo ñuhun Israel ya! ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nihin ra Jesuu iin buru yoso ra cuhva ni cati tutu Ndioo, vati cati chi cuenda ra Jesuu ti: ");
INSERT INTO mioNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ndioho ñivi iyo ñuhun Sión―ña cua cuyuhvi ndo. Cha vachi ra cua cundaca ñahan chi ndo, ta yoso ra buru, cati chi. ");
INSERT INTO mioNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Xihna ña cutuni ini ra sacuaha chi ra Jesuu cha cati tutu Ndioo can ti tacan ni cua quichi ra Jesuu iti ñuun Jerusalén, soco nu ni natacu ndico ra Jesuu, ta quechaha chacuhun ini ra ta ra ti cati tutu Ndioo ti tacan ni cua coo chi, ta tacan ndicha ni tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iyo ñivi ni chahan nu ni natacu ndico ra Lázaro, ta chaha ñi cuenda ti chahan ñi nu ni cuchi ra Lázaro, ta cana ra Jesuu chi ra, ta natacu ndico ra Lázaro ni savaha ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chacan cuu cha cuahan ñi cua satahan ñi chi ra Jesuu, vati chito ñi ti cha ni savaha ra chacan. ");
INSERT INTO mioNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tacan cuu, ta quechaha cati ra fariseo chi tahan ra ti: ―Cha ndehe yo ti ñahni cha cua cuu savaha yo. Ndihi ñivi ya cuni chi ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Iyo tahan ñivi griego ni queta ñuun Jerusalén can, vati cua sacahnu tahan ñi vico can. ");
INSERT INTO mioNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Cha nanducu ñi chi ra Felipe, ta maan ra cuu ra quichi ñuun Betsaida iyo cuenda ñuhun Galilea. Tacan cuu, ta quechaha cati ñi chi ra Felipe ti: ―Ra chahnu, cuni ndatuhun tahan ndi chi ra Jesuu ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tacan cuu, ta cuahan ra Felipe nuun iyo ra Ndree, ta chaha ra cuenda chi ra, ta nduvi tahan ra cuahan iti nuun iyo ra Jesuu, ta chaha ra cuenda chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tacan cuu, ta cati ndico ra Jesuu chi ra ta ra ti: ―Cha queta hora cha cua cuvi yu, ta cua coto ñivi ti cahnu xaan rai cui. ");
INSERT INTO mioNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cati ndicha yu ti tu ña cua quihvi nuni tichi ñuhun, tu ña cua tahyu soo chi tichi ñuhun, ña cua coo ndixi chi chi. ");
INSERT INTO mioNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ta ni cuhva iyo maan yo. Tu cua cuni yo suvi ni chi maan yo, cua ndoyo ñuhun yo cuenda ra Ndioo. Tu ña cua saxini yo ñaan cha cuu cha cua tahan yo ihya nu ñuhun ñuñivi, cua coo vaha yo chi ra Ndioo ndihi ni quivi ndihi ni tiempu. ");
INSERT INTO mioNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tu cua satiñu ndo cuenda yu, iyo cha cua caca ndo chihin yu icaa ni, ta cua coo yu nu iyo ndo, vati satiñu ndo cuenda yu. Tu cua satiñu ndo chihin yu, cua sacahnu ra suti chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ni vii cahan ra Jesuu chi ra ta ra: ’Vitin saxini xain, ta ña chite ñaan cha cua cati yu chi ra suti. Ña cua cati yu ti na cua sacacu ra chihin yu nu cua tahin tu ndoho vitin, vati chacan tiñu ni quichi yu. ");
INSERT INTO mioNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Cua cati yu chi ra ti na cua coto ñivi ti rai cahnu cuu ra. Tacan cuu, ta nducahan ra Ndioo iti siqui andivi, ta cati ra ti: ―Cha ni ndehe ñivi ti cahnu xaan rai cui, ta ni cua ndehe ndico tucu ñi ti cahnu xaan rai cui ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chini ñivi iyo tican ndusu can, ta cati ñi ti: ―Cha cahan ra savi ―cati ñi. Ta inga ñi cati ti: ―Cha cahan iin ra tatun Ndioo chi ra ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tacan cuu, ta cati ndico ra Jesuu chi ñi ti: ―Cahan ndusu can cuenda maan ndo. Ñavi cuenda yuhu cahan chi, ");
INSERT INTO mioNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ta vitin cua cutuni ñivi ñuñivi, ta cua quee ndaa run ndaca ñahan chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Cua sandaa ñivi chihin yu, ta cua savahi cha cua cuinu ini ñivi chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Cuhva can ni chaha ra cuenda chi ñi yoso cuhva cua cuvi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tacan cuu, ta cati ñivi chi ra ti: ―Chito ndi ti cati tutu ley Ndioo ti cua cuhva ra Ndioo tiñu chi iin rai, ta cua coo ndito ra ndihi ni quivi ndihi ni tiempu. Chacan cuu cha ña cutuni ini ndi ñacu cati cun ti iyo cha cua cuvi ra cuu sehe ñivi. ¿Yoo rai cuu racan? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ta cati ndico ra Jesuu chi ñi ti: ―Ni cua coo cha ndichin chihin ndo suhva ca quivi. Na cua coo vaha ndo, vati ni iyo cha ndichin nu iyo ndo, coto cua ndoyo ñuhun ndo nu naan. Tu cua caca cuu ndo nu naan, ña cua coto ndo ndaa iti cuahan ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Vitin iyo ra cuu sava ni ta cua iin ñuhun ndichin chihin ndo, ta cua cuinu ini ndo chi ra. Chacan cuu cha cua coo cha chini tuni chi ndo. Tacan cati ra Jesuu, ta cuahan ra, ta chacuindi xehe ra, vati ña cuni ra cha cua ndehe ñican chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Cuaha xaan cuhva savaha ra Jesuu ni ndehe ñivi judío can, soco ña chinu ini ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Chacan cuu cha quee chi cuhva cati ra Isaía iti chata, vati cha cati ra chi ra Ndioo ti: Ra chahnu, yoni chinu ini tuhun cati tuhun ndi. Yoni saxini ti iyo tu ndee ini chihun, ra chahnu, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chacan cuu cha ña cuu cuinu ini ñi, ta cati ndico tucu ra Isaía can cuenda ra Ndioo: ");
INSERT INTO mioNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ña chaha ra Ndioo cha cua cutuni ini ñi, ta saña ra cha na sanihin ini ñi. Chacan cuu cha ña cutuni ini ñi, ta ni ña nihin ñi cuhva. Chacan cuu cha ña cua saña ñi cha ndacu ñi, ta cua nduvaha anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tacan cati ra Isaía, vati ndehe ra ti cahnu xaan cuu ra Cristo, ta chaha ra cuenda yoso cuhva iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Chacan cuu cha tuvi ñivi judío can quechaha chinu ini chi ra Jesuu, ta iyo tahan ra ndaca ñahan chi ñi, ta chinu tahan ini ra, soco ña cati cachin ra, vati yuhvi ra chi ra fariseo, coto cua tava ndaa ra chi ra ve ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tacan iyo ra, vati cuni ra cha cua sacahnu ñivi chi ra, ta ña cuni ndicha ra cha cua sacahnu ra Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nihin xaan quechaha cahan ra Jesuu chi ñi, ta cati ra ti: ―Tu cua cuinu ini ndo chihin yu, cua cuinu tahan ini ndo chi ra ni tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tu cua nacoto ndo chihin yu, cua nacoto tahan ndo chi ra ni tachi chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Cha quichi yu ihya nu ñuhun ñuñivi ya, vati cua cuhve cha chini tuni chi ñivi. Chacan cuu cha tu cua cuinu ini ndo, ña cua ndoo ihni ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tu cua cuni soho ndo tuhun cati tuhin chi ndo, ta ña cua sacuinu ndo chi chi, ñavi yuhu cuu ra cua tachi tuni chi ndo. Ñavi cuenda chacan ni quichi yu vitin, soco quichi yu, vati cuni yu sacacu i chi ñivi ñuñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tu ña cua cuinu ini ndo chihin yu, tu ña cua tasoho ndo tuhun cahin, cua cutuni ndo, vati iyo ra cua tachi tuni chi ndo. Cua queta quivi cha cua cutuni ndo nu cuahan quivi, vati cha cati yu tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ña cahin cuhva cha saxini yu, soco cha tava tiñu ra suti chihin yu, ta maan ra cati ñaan tuhun cati tuhin. ");
INSERT INTO mioNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Chite ti tu cua savaha ndo cuhva cati ra, cua coo ndito ndo chi ra ndihi ni quivi ndihi ni tiempu. Chacan cuu cha chahi cuenda chi ndo cuhva cati suti chihin yu ―cati ra Jesuu chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ni vii cumani cha cua nducahnu vico can, ta quechaha chito ra Jesuu ti cha yatin cua queta hora ra. Chito ra ti cua nacoo ra ñuhun ñuñivi ya, ta cua cuhun ndico ra nu iyo sutu ra. Tacan ni chito ra, ta cuni mani xaan ra chi ra sacuaha chi ra, ta ña cua cahnda ini ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Chito ra ti cha ni chaha run cuihna cha chini tuni chi ra Juda Iscariote can ra cuu sehe ra Simón, ta cua xico tuhun ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Chito ra ti cha ni chaha sutu ra ndihi cuii tu ndee ini chi ra, ta chito ra ti quichi ra iti nuun ra sutu ra, ta cua cuhun ndico ra suvi ni iti nuun ra. Tacan ni saxini ra, ta cuxini ra chi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ndihi cuxini ra ta ra, ta ni chacuinda ra Jesuu, ta tava ra sahma ndichin ra, ta quihin ra inga sahma, ta chuhni ra tichi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tacan cuu, ta tihi ra nduta tichi chicoho, ta quechaha nacata ra chaha ra sacuaha chi ra, ta nacuhva ra chaha ra chi sahma nuhni tichi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ta queta ra nu ndecu ra Simón Pedro, ta quechaha cati ra Pedro chi ra ti: ―Ña cua nacata tahun chahi, ra chahnu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ta cati ndico ra Jesuu chi ra ti: ―Ña ta cutuni ini cun cha cua savahi chihun, soco cua queta quivi, ta cua cutuni vaha ini cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ta cati ra Pedro chi ra ti: ―Ña chahi cha cua nacata cun chahi. Ta cati ndico ra Jesuu chi ra ti: ―Tu ña cua nacate chahun, ña cua coun chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ta cati ndico ra Simón Pedro ti: ―Vaha. Cua nacata cun chahi, soco cua nacata tahun ndahi chi xini, ra chahnu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ta cati ndico ra Jesuu chi ra ti: ―Cha chiti cun. Ña chini ñuhun con cha cua sacuti chihun. Chaha ni cun cua nacate, vati ña yuma cun. Ndoo ndoo iyo ndo, soco ña ndihi ni ndo iyo tacan ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tacan ni cati ra Jesuu, vati chito ra ti iin ra cua xico tuhun chi ra. Chacan cuu cha cati ra ti ña ndihi ra iyo ndoo. ");
INSERT INTO mioNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tacan ni nacata ra Jesuu chaha ra ta ra, ta chacundichin ndico ra, ta ni chacunda ndico ra. Tacan cuu, ta quechaha cati ra chi ra ti: ―Ña chito ndo ñaan cha cuu cha ni savahi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Cati ndo ti sacuahi chi ndo, ta ndaca ñahin chi ndo, ta cha ndicha cahan ndo, vati tacan ni iye chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ndicha ndaca ñahin chi ndo, ta sacuahi chi ndo, ta yuhu nacate chaha ndo. Chacan cuu cha iyo cha cua nacata tahan ndo chaha tahan ndo, ");
INSERT INTO mioNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","vati cha sanahin chi ndo yoso cuhva cua coo ndo. Cua savaha ndo chi tahan ndo cuhva ni savahi chi maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cati ndicha yu chihin ndo ti ña cahnu cuu ra satiñu tatun, soco cahnu ca cuu ra ndaca ñahan, ta ñavi ca sa ra cuu tatun ra. Ta ni cuhva ña cahnu cuu ra tatun, soco cahnu ca cuu ra tava tiñu chi ra tatun can. Chacan cuu cha cuhva ni chacoi cua coo tahan maan ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ndihi chacan chito ndo. Tu cua savaha ndo cuhva cati yu, cua cusii ini ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Ña chahi cuenda yoso cuhva cua coo ndihi ndo. Nacote yoo ra ni nacachi yu, soco iyo cha cua coo chi cuhva cati tutu Ndioo, vati cati chi cuenda yu ti iyo ra chachi chihin yu icaa ni, ta cua savaha ra ndavaha ni chihin yu, cati chi. ");
INSERT INTO mioNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Chahi cuenda chihin ndo vitin, ta ña ta ñahni cha ni tahin. Chacan cuu cha cua cuinu ini ndo ti yuhu cuu ra cuu Cristo quivi cua coo tu ndoho chihin yu cuhva cati yu. ");
INSERT INTO mioNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cati ndicha yu ti iyo ra cua tava tiñu yu. Tu cua quihin cuenda ñivi chi ra, cua quihin cuenda tahan ñi chihin yu, ta cua quihin cuenda tahan ñi chi ra ni tava tiñu chihin yu ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tacan cati ra Jesuu, ta quechaha saxini ra suhva. Chacan cuu cha cati ra chi ra ta ra ti: ―Cati cachin yu chi ndo ti iin ndo cua xico tuhun chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tacan cuu, ta quechaha ndehe ra ta ra chi tahan ra, ta ña chito ra ndaa ra cuu ra cahan Jesuu tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yatin nu ndecu ra Jesuu ndecu tahan iin ra, ta amigu xaan ra Jesuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tacan cuu, ta sandaha ra Simón Pedro chi racan, ta quechaha cati ra chi ra ti: ―Cua nducu tuhun cun yoo ra cuu ra cahan ra chahnu. ");
INSERT INTO mioNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tacan sa ni tuhva ra amigu can suhva ca nu ndecu ra Jesuu, ta quechaha nducu tuhun ra chi ra ti: ―Ra chahnu, ¿yoo ra cuu ra? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ta cati ndico ra Jesuu ti: ―Cua tihi yu paan yu tichi cohi, ta cua cuhve chi chi chi ra. Racan cuu ra ―cati ra. Chacan cuu cha tihi ra Jesuu paan tichi coho ra, ta sa chaha ra chi chi chi ra Juda Iscariote ra cuu sehe ra Simón. ");
INSERT INTO mioNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chaha ra paan can chi ra Juda, ta sa quihvi run Satanaa anima ra Juda can. Chacan cuu cha cati ra Jesuu chi ra ti: ―Quii quii ni na cua savahun cha cua savahun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tacan cuu, ta ni iyo ra sacuaha chi ra, soco ña nihin ra ta ra cuhva ñacu cati ra Jesuu tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Chito ra ti cumi ra Juda xuhun. Chacan cuu cha iyo ra saxini ra ti cati ra Jesuu ti cua sata ra ñaan cha cua cuni ñuhun ra, ta cua sacahnu ra vico can, ta inga ra saxini ra ti cua cuhva ra xuhun can chi ñivi ndahvi. ");
INSERT INTO mioNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Quihin ra Juda paan can, ta quee ra. Cuahan ra. Cha cuaa cuu chi, ta cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tacan ni cuahan ra Juda, ta quechaha cati ra Jesuu ti: ―Vitin cua ndehe ñivi ti cha cahnu xaan cuu ra cuu sehe ñivi, ta cua ndehe tahan ñi ti cua sacahnu tahan ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tu cua sacahnu ra chi ra Ndioo, cua sacahnu tahan ra Ndioo chi ra, ta vitin vitin ni cua sacahnu ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yani xaa, ña nahan ca cua coi chi ndo. Cuhva ni cati yu chi ñi judío can cati yu chihin ndo vitin, vati cua nanducu ndo chihin yu, soco ña cua cuu cuhun ndo nu cua cuhin. ");
INSERT INTO mioNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Tuhun chaa cati tuhin chi ndo, vati na cua cuni mani ndo chi tahan ndo. Cua cuni mani ndo chi tahan ndo cuhva cuni mani yu chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chacan cuu cha cua coto ndihi ñivi ti cha ni sacuaha ndo chihin yu, vati cua cuni mani ndo chi tahan ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tacan cuu, ta quechaha nducu tuhun ra Simón Pedro chi ra ti: ―¿Ndaa iti cua cuhun, ta ra chahnu? Ta cati ndico ra Jesuu ti: ―Vitin ña cua cuu cuhun ndo nu cua cuhin, soco cua cuhun tahan ndo nu cuahan quivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ta nducu tuhun ndico ra Pedro chi ra ti: ―¿Ñacu ña cua cuu cuhin chihun vitin? Masi na cuvi yu, soco cua sacacu i chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ta cati ra Jesuu chi ra ti: ―¿Atu cua cuvi ndicha cun cuenda yu? Yu cati ti uni chaha cua sandahyu ñahun ti ña nacoto cun chihin yu, ta sa cua ndahyu ri chitoho ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ni vii cahan ra Jesuu chi ra sacuaha chi ra: ’Ña cua saxini ndo. Cua cuinu ini ndo chi ra Ndioo, ta cua cuinu tahan ini ndo chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nu iyo suti iyo cuaha xaan nuun cua coo ñivi. Chahi cuenda chi ndo, vati cha ndicha cuu chi. Chacan cuu cha cua cuhin tican, ta cua tiso vahi nu cua coo ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tu cua cuhin, ta cua tiso vahi nu cua coo ndo, cua quichi ndico tuqui, vati cua quichi quihin yu chihin ndo. Chacan cuu cha cua coo tahan ndo nu cua coi, ");
INSERT INTO mioNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ta chito ndo ndaa iti cua cuhin ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tacan cuu, ta quechaha nducu tuhun ra Tuma chi ra chahnu ti: ―Ña chito ndi ndaa iti cua cuhun. ¿Yoso cua nacoto ndi iti can? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ta cati ndico ra Jesuu chi ra ti: ―Yuhu cuu sava ni ta cua iin iti, ta cahin cha ndicha ndicha, ta cua cuhve cha cua coo ndito ñivi. Tu ña cua cuinu ini ñivi chihin yu, ña cua cuu yaha ñi iti nuun ra suti. ");
INSERT INTO mioNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Cua nacoto ndo chi ra suti, vati nacoto ndo chihin yu. Vitin cua nacoto ndo chi ra, ta cua ndehe ndo chi ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ta cati ra Felipe chi ra ti: ―Cua sanahun chi ra cuu sutu cun chi ndi. Tacan sa ndoo ndi vaha, ra chahnu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ta cati ndico ra Jesuu chi ra Felipe ti: ―Cuaha quivi cha iyo ndo chihin yu, ta ña ta nacoto ndo chihin yu. Cha ndehe ndo chi ra suti, vati cha ni ndehe ndo chihin yu. Ña vaha cha cati cun ti na cua sanahin chi ra suti chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Iyo cha cua cuinu ini ndo ti cha iyo ra suti chihin yu, ta iyo yu chihin ra. Ña cati tuhin chihin ndo cuhva cha saxini main. Iyo ra suti chihin yu, ta maan ra cuu ra ndacu cuhva cuni ra. ");
INSERT INTO mioNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na cua cuinu ini ndo ti iyo ra suti chihin yu, ta iye chi maan ra. Tu ña cua cuinu ini ndo cuenda chacan, na cua cuinu ini ndo, vati cha ni ndehe ndo cuhva cha ni savahi. ");
INSERT INTO mioNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Cati ndicha yu ti tu cua cuinu ini ndo chihin yu, cua savaha tahan ndo cuhva cha ni savahi. Cahnu ca cuhva cua savaha ndo, vati cua cuhin iti nuun ra suti, ");
INSERT INTO mioNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ta cua savahi ñaan cha cua ndaca ndo cuenda yu. Tacan ni cua savahi, ta cahnu xaan ca cua cuu ra suti. ");
INSERT INTO mioNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Cua savahi ndihi cha cua ndaca ndo cuenda yu. ");
INSERT INTO mioNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ni vii cahan ra Jesuu chi ra ta ra: ’Tu cua cuni ndo chihin yu, cua sacuinu ndo cuhva cati tuhin chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Cua cahin chi ra suti ti cua tachi ra chi inga ra. Ra Tati Ndioo cuu ra, ta rai ndicha cuu ra. Ta ni cuhva cua tindee ra chi ndo, ta cua coo ra chi ndo ndihi ni quivi. Ña cua tindee ra chi ñivi ndacu ndavaha ni, vati ña cua ndehe ñi chi ra, ta ni ña cua nacoto ñi chi ra, soco cua nacoto maan ndo chi ra, vati cua coo ra chi ndo icaa ni. ");
INSERT INTO mioNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ña cua nacoo ihni yu chihin ndo, vati cua quichi ndico tuqui nu iyo ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Cua yaha suhva quivi, ta ña cua ndehe ca ñivi ñuñivi chihin yu, soco maan ndo cua ndehe ndo chihin yu, vati cua coo ndito ndico ndo cuhva cua coo ndito yu. ");
INSERT INTO mioNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Quivi can cua coto ndo ti iyo ra suti chihin yu, ta iyo maan yo icaa ni. ");
INSERT INTO mioNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tu cua sacuinu ndo cuhva cati tuhin chi ndo, cua cuni ndo chihin yu. Tu cua cuni ndo chihin yu, cua cuni ra suti chi ndo. Tacan cua cuu, ta cua cuni tahin chi ndo, ta cua nacoto vaha ndo chihin yu ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tacan cuu, ta inga ra Juda quechaha nducu tuhun chi ra ti: ―¿Yoso cua savahun cha cua ndehe ndi chihun, ta ña cua ndehe tahan ñivi ñuñivi chihun? ");
INSERT INTO mioNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ta cati ndico ra Jesuu chi ra ti: ―Tu cua cuni ñivi chihin yu, cua sacuinu ñi cuhva cati yu, ta cua cuni suti chi ñi, ta cua coo ndi chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tu ña cua cuni ñivi chihin yu, ña cua sacuinu ñi cuhva cati yu. Ñavi cuenda yu cati tuhin tuhun ya chi ndo, soco cati tuhin chi chi cuenda ra suti ra ni tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ni vii cahin tuhun can chihin ndo, ta iyo yu chihin ndo, ");
INSERT INTO mioNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","soco cua tachi sutu yu chi ra cua tindee chi ndo, ta cua quichi racan cuenda yu. Ra Tati Ndioo cuu ra. Cua sanahan ra chi ndo, ta cua savaha ra cha cua cuñuhun ini ndo ndihi tuhun cha cati tuhin chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Cuni yu cha cua coo taxin anima ndo, ta cua saña tahan yo. Cua savahi cha cua coo taxin anima ndo, soco ñavi cuhva ndacu ñivi ñuñivi cua savahi chi ndo. Ña cua saxini ca ndo, ta ni ña cua tichaha ca ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chito ndo ti cati yu ti cua cuhin, soco cua quichi ndique nu iyo ndo. Cuni mani ndo chihin yu. Chacan cuu cha cua cusii ini ndo, vati cua cuhin nu iyo sutu yu, ta cahnu xaan ca ra cuu suti, ta ñavi ca sa yuhu. ");
INSERT INTO mioNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Vitin ña ta cuhin, soco chahi cuenda chi ndo. Chacan cuu cha cua cuinu ini ndo chihin yu, ta sa cua cuhin. ");
INSERT INTO mioNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ña cua cahan que chi ndo, vati ni vachi run ndaca ñahan chi ñivi ñuñivi. Ña ndaca ñahan run chihin yu, ");
INSERT INTO mioNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","soco cua savahi cuhva cati tuhun suti chihin yu. Chacan cuu cha cua coto ñivi ñuñivi ti cuni mani yu chi suti. Coho vitin. ");
INSERT INTO mioNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Cahan ndico tucu ra Jesuu chi ra sacuaha chi ra. Iin cuhva cahan ra, ta cati ra ti: ’Yuhu cuu sava ni ta cua iin yoho, ta ra suti cuu sava ta cua ra cumi yoho can. ");
INSERT INTO mioNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tu ña cua coo vaha chiti chaha ndaha yoho can, cua savita ra chi chi. Tu cua coo vaha chiti chi, cua sacuun ra ndaha chi, vati tacan ni cua coo ca chiti chi. ");
INSERT INTO mioNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Cha iyo vaha maan ndo, vati tasoho ndo tuhun cati tuhin chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Cua coo ndo chihin yu, ta cua coo tahin chi ndo. Ña cua cuu coo vaha ndo, tu ña cua coo ndo chihin yu. Tacan ni iyo ndaha yoho can, vati tu cua coyo cuii ndaha yoho can, ñahni chiti chi cua coo. ");
INSERT INTO mioNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Yuhu cuu sava ni ta cua yoho can, ta maan ndo cuu sava ta cua ndaha chi. Tu cua coo ndo chihin yu, cua quee vaha tiñu cua savaha ndo, soco tu ña cua coo ndo chihin yu, ñahni cha cua cuu savaha ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tu ña cua coo ndo chihin yu, cua tava ndai chi ndo, ta cua ndoyo ñuhun ndo cuhva cua ndoyo ñuhun ndaha yoho can. Cua neti chi, ta cua savita yu chi chi, ta cua tai ñuhun chi chi, ta cua cayu chi. ");
INSERT INTO mioNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Tu cua sacuinu ndo cuhva cati yu, cua ndaca ndo ñaan cha cuni ndo, ta cua cuhve chi chi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tacan, ta cahnu xaan ca cua cuu ra suti, vati cua savaha ndo cha vaha, ta cua ndehe ñivi ti chica ndo tiñu yu. ");
INSERT INTO mioNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Cuni mani yu chi ndo cuhva cuni mani ra suti chihin yu. Na cua coo vaha ndo chihin yu, ta cua cuni mani yu chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tu cua sacuinu ndo cuhva cati tuhin chi ndo, cua cuni mani yu chi ndo. Ta ni cuhva cha ni sacuinu yu cuhva cati tuhun ra suti chihin yu, ta cuni mani ra chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Tacan cati yu, vati tacan ni cua cusii ini xaan ndo cuhva cusii ini yu. ");
INSERT INTO mioNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yuhu cati tuhin chi ndo ti na cua cuni mani ndo chi tahan ndo cuhva cuni mani yu chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tu cua cuvi iin ñivi cuenda cha cua sacacu ñi chi amigu ñi, cua savaha ñi iin tu manini cahnu xaan, ta ñahni cha cahnu ca cha cua cuu savaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ndioho cuu amigu yu, tu cua savaha ndo cuhva cati tuhin chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ña cua cati yu ti musu yu chi ndo, vati ña chito ra musu ñaan cha ndacu ra cuu chitoho ra. Yu cati ti amigu yu chi ndo, vati cha chahi cuenda chi ndo ndihi cha ni cati ra suti chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ñavi maan ndo nacachi chihin yu, soco yuhu nacachi chi maan ndo, ta cha chahi tiñu chi ndo, vati cua satiñu ndo, ta cua quee vaha cha cua savaha ndo, ta cua ndoo chi. Chacan cuu cha cua cuhva ra suti ñaan cha cua ndaca ndo chi ra cuenda yu. ");
INSERT INTO mioNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Chacan cati yu ti cua cuni mani ndo chi tahan ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ni vii cahan ra Jesuu chi ra ta ra: ’Tu cua cuxaan ini ñivi ñuñivi chi ndo, cua coto ndo ti xihna ca cha cuxaan ini ñi chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tu cua coo ndo cuhva iyo ñivi ñuñivi, cua cuni ñi chi ndo, vati cuni ñi chi tahan ñi. Cuxaan ini ñi chihin ndo, vati nacachi yu chi ndo, ta ña ndacu ndo cuhva ndacu maan ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ña cua naan ini ndo cha cati yu chihin ndo, vati cati yu ti ña cahnu ca cuu ra musu chi chitoho ra. Cua coo ndo chi tu ndoho cua savaha ñi, vati tacan ni cha ni savaha ñi chihin yu. Ña cua savaha ñi cuhva cua cati ndo, vati ña ndacu ñi cuhva cha ni cati yu. ");
INSERT INTO mioNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Cua savaha ñi ndihi chacan chi ndo, vati iyo ndo chihin yu. Tacan cua savaha ñi, vati ña nacoto ñi chi ra ni tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Quichi yu, ta chahi cuenda chi ñi. Chacan cuu cha iyo cuati ñi. Tu ñavi tacan, ña cua coo cuati ñi, soco vitin ñahni cha cua cuu cati ñi ti ñahni cuati ñi iyo. ");
INSERT INTO mioNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tu cua cuxaan ini ñivi chihin yu, cua cuxaan ini tahan ñi chi ra ni tachi chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Iyo cuati ñi, vati cahnu xaan cuhva savahi iti nuun ñi, ta ña ni chinu ini ñi, ta yoni ca ñivi savaha tacan nu ni quichi quivi. Vitin cha ni ndehe ñi cuhva ni savahi, soco xaan cuni ñi ndehe ñi chihin yu chi suti. ");
INSERT INTO mioNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tacan ni iyo ñi, vati saqueta ñi cuhva cati tutu Ndioo, vati cati chi ti xaan xaan cuni ñi ndehe ñi chihin yu, soco ñahni cuati ni savahi, cati chi. ");
INSERT INTO mioNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Cua quichi ra cua tindee chi ndo, vati cua tachi yu chi ra hora cha cua queta yu nuun suti. Racan cuu ra cua quee iti nuun ra suti, ta cua cahan tahan ra cha ndicha, ta cua cahan ra cuenda yu. ");
INSERT INTO mioNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Cua cuhva tahan ndo cuenda, vati cha ni chica ndo chihin yu nda quivi quechaha cati tuhin chi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ndihi chacan chahi cuenda chi ndo, coto cua ndoyo ñuhun ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Cua tava ndaa ñivi chi ndo ve ñuhun, vati cua queta quivi cha cua saxini ñivi ti satiñu vaha ñi cuenda ra Ndioo, ta cua cahni ñi chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tacan ni cua savaha ñi, vati ña nacoto ñi chihin yu, ta ni ña nacoto ñi chi ra suti. ");
INSERT INTO mioNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Cha chahi cuenda chi ndo, vati cua queta quivi cua tahan ndo tacan, ta cua cucuhun ini ndo cha cati yu. Ni vii cahan ra Jesuu chi ra ta ra: ’Ña chahi cuenda chi ndo nda ni xihna cuii, vati ni vii iye chi ndo, ");
INSERT INTO mioNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","soco vitin cua cuhin nu iyo ra tachi chihin yu. Ña ta nducu tuhun ndo ndaa iti cua cuhin, ");
INSERT INTO mioNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","soco cuihya xaan cuni anima ndo, vati cati yu tuhun can chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Cati yu cha ndicha ti cua coo vaha ca ndo, vati cua cuhin. Tu ña cua cuhin, ña cua quichi ra cua tindee chi ndo, soco tu cua cuhin, cua tava tiñu yu chi ra, ta cua quichi ra nu iyo ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Cua quichi maan ra, ta cua sacoto ra chi ñivi ñuñivi ti ndacu ñi cuati, ta ña chinu ini ñi chihin yu. Cua sacoto ra yoso cuhva cua coo vaha ñi chi ra Ndioo, vati cua cuhin nu iyo suti, ta ña cua ndehe ca ndo chihin yu. Cua sacoto tahan ra yoso cuhva cua cutuni ñivi ndacu ndavaha ni, vati cua cutuni run cuu run ndaca ñahan chi ñivi ñuñivi ya. ");
INSERT INTO mioNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ni iyo cuaha tuhun cua cati tuhin chi ndo, soco ña cua cundee ini ndo vitin. ");
INSERT INTO mioNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Cua quichi xihna ra cuu Tati Ndioo, ta sa cua sacoto ra cha ndicha chi ndo, vati ndicha ra. Ña cua cahan ra yoso cuhva saxini maan ra, soco cua cuhva ra cuenda cha cati ra Ndioo, ta cua cati tuhun ra yoso cuhva cua coo chi iti nuun. ");
INSERT INTO mioNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Cua sacahnu ra chihin yu, vati cua tasoho ra cha cua cati yu chi ra, ta cua cuhva ra cuenda chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ndihi cha iyo chi ra suti iyo chi main. Chacan cuu cha cati yu ti cua tasoho ra cuu Tati Ndioo cha cua cati yu chi ra, ta cua cuhva ra cuenda chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ni vii cahan ra Jesuu chi ra ta ra: ’Suhva quivi, ta ña cua ndehe ca ndo chihin yu, ta inga suhva ca quivi, ta cua ndehe ndico tucu ndo chihin yu ―cati ra Jesuu chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tacan cuu, ta quechaha cati ra sacuaha chi ra chi tahan ra ti: ―¿Ñaan cha cuu cha cati ra chi yo? Cati ra ti suhva quivi, ta ña cua ndehe ca yo chi ra, ta inga suhva quivi, ta cua ndehe ndico tucu yo chi ra. Cati tahan ra ti tacan cua cuu chi, vati cua cuhun ra nu iyo sutu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ñacu cati ra ti suhva quivi cuu chi? Ña cutuni ini yo cha cahan ra ―cati ra chi tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Chito ra Jesuu ñaan cha cuni nducu tuhun ra ta ra chi ra. Chacan cuu cha cati ra chi ra ta ra ti: ―Cha cati yu ti suhva quivi, ta ña cua ndehe ca ndo chihin yu, ta inga suhva quivi, ta cua ndehe ndico tucu ndo chihin yu. Ñavi cha vaha cuu cha nducu tuhun ndo chi tahan ndo ñaan cha cuu tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Cati ndicha yu ti cuihya xaan cua cuni anima ndo, soco sii xaan cua cuni ñivi ñuñivi. Cuihya cua cuni ndo, soco cua naan chacan, ta cua cusii ini xaan ndico ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nu cuni cacu sehe ñi ñahan, ta cua tuvi ini ñi tu ndoho hora can, soco cua yaha ñi tu ndoho can, ta ña cua saxini ca ñi ti cha ni tuvi ini ñi tu ndoho, vati sii xaan cuni ñi cha ni cacu sehe ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Vitin cua coo tu cuihya ini chi maan ndo, soco cua ndehe ndico tucu ndo chihin yu, ta cua cusii ini ndico ndo. Tacan ni cua coo ndo, ta ña cua cuu naan cha sii cuni ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Ñahni cha cua ndaca ndo chihin yu quivi cua quichi racan, soco cati ndicha yu ti cua cuhva ra suti ñaan cha cuu cha cua ndaca ndo chi ra cuenda yu. ");
INSERT INTO mioNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ña ta ñahni cha ndaca ndo cuenda yu nda cua nda vitin. Na cua ndaca ndo chi ra, ta sa cua cuhva ra chi chi chi ndo. Tacan, ta cua cusii ini ndicha ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ni vii cahan ra Jesuu chi ra: ’Cha chahi cuenda chi ndo, soco mani chi cuhva ni cahin chi ndo. Cua queta quivi, ta ña cua cahan que chi ndo chi cuhva, vati cua cati cachin yu yoso cuhva iyo ra suti. ");
INSERT INTO mioNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Quivi can sa cua cahan maan ndo chi ra cuenda sivi yu, ta ña cua cati que chi ndo ti ni vii cahin chi ra cuenda ndo, vati cua cuu cahan maan ndo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Cuni mani ra suti chi ndo, vati cha cuni mani ndo chihin yu, ta cha chinu ini ndo ti iti nuun ra ni quichi yu. ");
INSERT INTO mioNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Quee yu iti nuun ra, ta quichi yu ihya nu ñuhun ñuñivi ya vitin, soco cua quee ndique nu ñuhun ñuñivi ya, ta cua cuhun ndico tuqui nu iyo ra ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tacan cuu, ta quechaha cati ra sacuaha chi ra ti: ―Vitin cati cachin cun, vati ña cahan con chi cuhva. ");
INSERT INTO mioNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vitin chito ndi ti chito cun ndihi cuii, ta chito ndi ti ña nini cha cua nducu tuhun ñivi chihun, ta cua cati ndico cun. Chacan ni chinu ini ndi ti quichi cun iti nuun ra Ndioo ―cati ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ta cati ndico ra Jesuu chi ra ta ra ti: ―Vitin cha chinu ini ndo, ");
INSERT INTO mioNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","soco cua queta hora cua cunu ndo. Cua queta hora can, ta ndihi ndo cua cuhun ndo vehe ndo, ta cua nacoo ihni ndo chihin yu, ta cua ndoo iin tuhun yu, soco ña cua ndoi cha maan iin tuhin, vati iyo ra suti chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tacan cati yu, vati cua cuhve cha cua coo taxin anima ndo. Ihya nu ñuhun ñuñivi ya cua coo tu ndoho chi ndo, soco na ña cua cucuihya ini ndo, vati cha ni sacanain chi run cua cani tahan chi ndo nu ñuhun ñuñivi ya. ");
INSERT INTO mioNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tacan ni cati ra Jesuu, ta ndehe ndaa ra iti siqui andivi, ta quechaha cati ra chi sutu ra ti: ―Tata, cha cua queta hora yu vitin. Na cua sacahnu cun chihin yu, vati tacan ni cua sacahnu tahin chihun ");
INSERT INTO mioNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","cuhva cha ni chahun tu ndee ini chihin yu, ta ndaca ñahin chi ndihi ñivi. Chacan cuu cha cua cuhve cha cua coo ndito ndihi ñi cha iyo chihin yu. Cua coo ndito ñi chihin yo ndihi ni quivi ndihi ni tiempu. ");
INSERT INTO mioNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Cua coo ndito ñi, vati nacoto ñi chihun, ta iin tuhun ni ra Ndioo ndicha cuun. Nacoto tahan ñi chi yuhu ra Jesucristo, ta maun tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Yuhu cha ni sacahnu i chihun ihya nu ñuhun ñuñivi ya, ta cha saquete tiñu cha ni chahun chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tata, na cua sacahnu cun chihin yu vitin, ta na cua cuhva cun cha cua coo ndico tucu cha vaha chihin yu cuhva ni chacoo chi chihin yu, ta ña ta tuvi ñuhun ñuñivi ya. ");
INSERT INTO mioNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Cha ni savahun cha chacoo rahya ta ra chihin yu, ta sanahin chi ra yoso cuhva iyo cun. Cha chacoo ra chi maun, ta savahun cha cua coo ra chihin yu, ta ni sacuinu ra cuhva cati cun. ");
INSERT INTO mioNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Vitin chito ra ti maun chaha ndihi cha ni savahi. ");
INSERT INTO mioNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Cha chahi cuenda chi ra cuhva cati cun chihin yu, ta cha ni tasoho ra cha cahin, ta chito ra ti ndicha quichi yu iti nuun cun. Chinu ini ra ti maun cuu ra ni tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Cahan ndahvi yu chihun cuenda ra. Ña cahan yu cuenda ndihi ñivi ñuñivi, soco cahan yu cuenda ra iyo chihin yu. Maun chaha cha iyo ra chihin yu, soco chi maun cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ndihi ra iyo chi yuhu, ta iyo tahan ra chi yoho, ta cha ndacu ra cha cahnu cui. ");
INSERT INTO mioNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Ña cua coo que nu ñuhun ñuñivi ya, vati cua cuhin nu iyo cun, soco cua ndoo maan ra ihya. Tata, na cua cumi cun chi ra, vati iyo tu ndee ini chihun, ta maun chaha chi ra chihin yu. Chacan cuu cha cua nduinuun ra cuhva iyo inuun yo. ");
INSERT INTO mioNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cha ni chacoi chi ra ihya nu ñuhun ñuñivi ya, ta chacucumi yu chi ra, vati chahun tu ndee ini chihin yu. Cha tindei chi ra, ta iin tuhun ni ra ndoyo ñuhun cuhva cati tutu cun, soco yoni ca ra ndoyo ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Vitin cua cuhin iti nuun cun, soco cahin chacan ihya. Chacan cuu cha cua cusii ini vaha ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Cha cati tuhin tuhun cun chi ra, ta cha cuxaan ini ñivi ñuñivi chi ra, vati ña iyo ra cuenda ñuhun ñuñivi cuhva cha ña iyo yu cuenda ñuhun ñuñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ña cati yu ti cua canihun chi ra ihya nu ñuhun ñuñivi ya, soco cahan ndahvi yu chihun ti na cua cucumi vahun chi ra, ta ña cua cuu savaha run cuihna ndavaha ni chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ña iyo ra cuenda ñuhun ñuñivi cuhva cha ña iyo yu cuenda chacan. ");
INSERT INTO mioNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Na cua sacu‑ii ndicha cun chi ra. Cha ndicha cuu tuhun cun. ");
INSERT INTO mioNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tava tiñu yu chi ra ihya cuhva ni tava tiñu cun chihin yu ihya. ");
INSERT INTO mioNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Cha iyo ii yu cuenda ra. Chacan cuu cha cua coo ii ndicha maan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Cahan ndahvi yu chihun cuenda racan ta ra, soco cahan ndahvi tahin cuenda ñivi cua tasoho tuhun cua cahan ra, ta cua cuinu ini ñi chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Cahan ndahvi yu chihun ti na cua coo inuun ndihi ñican cuhva iyo inuun yo, tata. Chacan cuu cha cua coo inuun ñi chihin yo, ta cua cuinu ini ñivi ñuñivi ti maun cuu ra ni tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Cha sanahin chi ñi ti chahun cha vaha chi ñi cuhva cha chahun cha vaha chihin yu. Chacan cuu cha cua coo inuun ñi cuhva iyo inuun maan yo. ");
INSERT INTO mioNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Inuun iyo cun chihin yu, ta inuun iyo yu chi ñi. Chacan cuu cha cua coo vaha ñi, vati iyo inuun ñi. Chacan cuu cha cua coto ñivi ñuñivi ti cha tava tiñu cun chihin yu, ta cuni mani cun chi ñi cuhva cuni mani cun chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tata, cha chaha cuenda cun chi ñi chihin yu, ta cuni yu cha cua coo ñi chihin yu nu iye. Chacan cuu cha cua coto ñi ti cha cahnu xaan cui cha ni savahun. Cua coto ñi ti tacan ni savahun chihin yu, ta ña ta tuvi ñuhun ñuñivi. ");
INSERT INTO mioNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata, ña nacoto ñivi ñuñivi chihun, soco yuhu nacote chihun, ta chito amigu yu ti maun cuu ra ni tava tiñu chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Cha sacote chi ñi yoo rai cuun, ta cha sacoto tahin chi ñi ti cua cuni mani tahan ñi chi tahan ñi cuhva cuni mani cun chihin yu. Sacoto tahin ti cua coi chi ñi nu cuahan quivi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chacan ni cahan ra Jesuu, ta quee ra. Cuahan ra chi ra sacuaha chi ra. Cuahan ra ta ra inga chiyo xahva Cedrón, ta queta ra ta ra iin nu cumi ñivi yutun tata, ta quihvi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Chito tahan run Juda ndaa iyo chi, vati cuaha chaha nducuiti ra Jesuu chi ra sacuaha chi ra tican. ");
INSERT INTO mioNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chacan cuu cha quihin run iin cuenda sandaru, ta quihin run chi tatun tachi ra sutu chahnu chi ra fariseo, ta cuahan ra tican, ta naan ra ta ra ñuhun. Naan ra ta ra espada. Naan ra ta ra garote. Naan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tacan cuu, ta chito ra Jesuu ñaan cha cuu cha cua tahan ra, ta quee ra, ta quechaha nducu tuhun ra chi ñi ti: ―¿Yochi nanducu ndo? ");
INSERT INTO mioNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ta cati ndico ñi chi ra ti: ―Chi ra Jesuu ra ñuun Nazaret vachi quihin ndi ―cati ñi. Ta cati ndico ra chi ñi ti: ―Yuhu cui ―cati ra. Chacuinda tahan run Juda chi ñi, ta maan run cuu run ni xico tuhun chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Cha cati ra Jesuu ti maan ra cuu ra, ta chinu chata ñi suhva, ta nduva ñi nu ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tacan cuu, ta nducu tuhun ndico tucu ra chi ñi ti: ―¿Yochi nanducu ndo? Ta cati ñi ti: ―Chi ra Jesuu ra ñuun Nazaret vachi quihin ndi. ");
INSERT INTO mioNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ta cati ndico ra Jesuu chi ñi ti: ―Cha cati yu ti yuhu cui. Na cua saña ndo chi rahya ta ra, vati chi yuhu vachi quihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tacan ni cati ra, ta saqueta ra tuhun cha ni cati ra, vati cha cati ra nu quichi quivi ti cha chaha cuenda sutu ra chi ra chica chihin ra, ta ña cua ndoyo ñuhun ni iin ra, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tacan cuu, ta xita ra Pedro cha cuu ta iin machete ra, ta cani ra chi ra cuu musu ra sutu chahnu, ta chahnda ra iin chiyo soho ra chiyo cuaha ra ndahvi can. Malco nani ra ndahvi can. ");
INSERT INTO mioNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tacan cuu, ta cati ra Jesuu chi ra Pedro ti: ―Tihi ndico machete cun tichi vena cun. Cua ndehi tu ndoho cuhva ni cati suti chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tacan cuu, ta tiin ra sandaru can chi ra Jesuu, ta chuhni ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ta chandaca xihna ra ta ra chi ra iti nuun ra Anaa, vati chiso ra chi ra Caifás ra cuu sutu chahnu cuiya can. ");
INSERT INTO mioNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Maan ra Caifás can cuu ra cati chi ñivi judío ti nini xaan cha cua cuvi iin ñivi, vati tacan ni cua cacu ndihi ca maan ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Chandicu ra Pedro chi ra Jesuu nuun cuahan ra chi ra sandaru ta ra, ta chandicu tahan inga ra sacuaha chi ra, ta nacoto ra sutu chahnu chi racan. Chacan cuu cha quihvi tahan ra chi ra Jesuu tihyo ra sutu chahnu can, ");
INSERT INTO mioNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","soco ndoo ra Pedro iti chata yatin yu vehe, vati iyo iin ñahan cumi yu vehe. Chacan cuu cha chahan ndico ra nacoto chi ra sutu chahnu iti yu vehe, ta cahan ra chi ña ñahan can, ta sa yaha tahan ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tacan cuu, ta quechaha cati ña ñahan can chi ra Pedro ti: ―¿Atu ña ndicha ti chica tahun chi ra Jesuu? Ta cati ndico ra Pedro chi ña ti: ―Ña ndicha ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Cha satahan ra musu ñuhun chi ra tatun can, vati cua tuni ra ta ra, vati vichin xaan suhva. Inda tahan ra Pedro, ta tuni tahan ra ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tacan cuu, ta nducu tuhun ra sutu chahnu chi ra Jesuu yoso cuhva iyo ra sacuaha chi ra, ta nducu tuhun tahan ra ñaan cha cuu cha ni sacuaha ra chi ñivi, ");
INSERT INTO mioNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ta cati ndico ra Jesuu chi ra ti: ―Cha cati cachin yu chi ndihi ñivi, ta cha sacuahi chi ñi ndihi ve ñuhun nu nducuiti ñivi judío, ta ñahni cha cahan xehi chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ña cua nducu tuhun ndo chihin yu. Cua nducu tuhun ndo chi maan ñi, vati chini soho ñi ndihi tuhun cha ni cahin, ta chito ñi ñaan tuhun cahin chi ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tacan cati ra Jesuu, ta cani iin ra tatun can chi ra Jesuu, vati yatin nu inda ra inda tahan ra, ta cati ra chi ra ti: ―Ña vaha cha cahun chi ra sutu chahnu tacan. ");
INSERT INTO mioNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ta cati ndico ra Jesuu chi ra ti: ―Tu ndavaha ni cuu cha ni cati yu, cua cuhvon cuenda ñaan ndavaha ni cuu chi, soco tu cha vaha cuu chi, ña vaha cha cani cun chihin yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tacan cuu, ta tachi ra Anaa chi ra Jesuu nu iyo ra Caifás ra cuu sutu chahnu, ta nuhni ra, ta cuahan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ni inda ra Simón Pedro tuni ra ñuhun, ta nducu tuhun ra ta ra chi ra ti: ―¿Atu sacuahun chi ra Jesuu? Ta cati ndico ra Pedro ti: ―Ñahni, xaa. ");
INSERT INTO mioNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Inda tahan iin musu ra sutu chahnu can, ta ñivi ra chi ra ni tahnda soho, ta quechaha cati ra chi ra Pedro ti: ―Cha ndehi chihun, vati cha iyo cun chi ra hora cha ni chaquihin ndi chi ra nu iyo yutun tata can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ta cati ndico tucu ra Pedro ti ña ndicha, ta sa ndahyu ri chitoho, vati cha queta uni hora cha ni sandahyu ñahan ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tacan cuu, ta quee ra ta ra nuun iyo ra Caifás, ta chandaca ra ta ra chi ra Jesuu iti nu iyo vehe ra cumi tiñu cha iyo cuenda ñuun Roma, ta ni vii nahan cuu chi. Ña quihvi ra judío can ve tiñu, coto cua coo ica ra, vati cuni ra sacahnu ra vico can. ");
INSERT INTO mioNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chacan cuu cha quee ra Pilato iti chata nu iyo ra ta ra, ta nducu tuhun ra chi ra ta ra ti: ―¿Ñaan cuati cuni ndo chi rahya? ");
INSERT INTO mioNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ta cati ndico ra ta ra chi ra ti: ―Ndacu ra ndavaha ni. Chacan cuu cha vachi ndaca ndi chi ra chihun ―cati ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ta cati ra Pilato chi ra ta ra ti: ―Cua ndehe maan ndo, vati cua tachi tuni maan ndo chi ra cuhva cati ley maan ndo ―cati ra. Ta cati ndico ra judío can ti: ―Ñahni ndatu cha cua cahni ndi chi ñivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chacan cuu cha quee chi cuhva ni cati ra Jesuu, vati cha ni cati ra yoso cuhva cua cuvi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tacan cuu, ta quihvi ndico tucu ra Pilato tichi ve tiñu, ta cana ra chi ra Jesuu, ta nducu tuhun ra chi ra ti: ―¿Atu maun cuu ra ndaca ñahan chi ñivi judío? ");
INSERT INTO mioNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ta cati ndico ra Jesuu chi ra ti: ―¿Atu cha saxini maun cuu chi a cha cati inga ñivi chihun ti tacan cuu chi? ");
INSERT INTO mioNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ta cati ra Pilato ti: ―Ñavi ra judío cui. Cha ni chaha cuenda ra sutu chahnu chi ndihi ñivi cuu ñivi cun chihun chihin yu. ¿Ñaan cha cuu cha ni savahun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ta cati ndico ra Jesuu ti: ―Ñavi cuenda ñuhun ñuñivi ya cua cundaca ñahin. Tu cua cundaca ñahin ihya nu ñuhun ñuñivi ya, cua cani tahan ñivi yu, ta ña cua cuu cuhva cuenda cun chihin yu chi ñivi judío can, soco ñavi tacan cuu chi. Ña cua cundaca ñahin ihya ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ta cati ndico ra Pilato chi ra ti: ―¿Atu cua cundaca ñahun chi ñi? Ta cati ndico ra Jesuu ti: ―Maun cati ti cua cundaca ñahin chi ñi. Chacan cuu cha quichi yu ihya nu ñuhun ñuñivi ya. Chacan cuu cha cacu yu ihya, vati cua cati tuhin cha ndicha. Tu cua cuni coto ñivi iin cha ndicha, cua tasoho ñi cuhva cati yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ta nducu tuhun ra Pilato chi ra ti: ―¿Ñaan cha cuu cha ndicha? ―cati ra. Tacan ni nducu tuhun ra Pilato, ta cuahan ndico ra nu iyo ra judío can, ta cati ra ti: ―Yuhu cati ti ñahni cuati savaha ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Chito ndo ti iyo costumbre cha cua sañe chi iin ra indi ve caa tichi vico ya. ¿Atu cuni ndo cha cua sañe chi ra cua cundaca ñahan chi ndo? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tacan cuu, ta cuvaa ndihi ñi, ta cati ñi ti: ―Ña cua sañon chi rahya. Cua sañon chi ra Barabaa ―cati ñi, ta ñasuhu cuu ra Barabaa can. ");
INSERT INTO mioNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tacan cuu, ta quihvi ndico ra Pilato, ta cati ra ti cua cani ra sandaru chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tacan cuu, ta savaha ra sandaru can iin tivi iñu, ta tihi ra chi chi xini ra Jesuu, ta sacundichin ra sahma tixinda chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tacan cuu, ta tuhva ra nu inda ra Jesuu, ta cati ra ti: ―Na cumi chi maun, tata. Yoho cuu ra cua cundaca ñahan chi ñivi judío ―cati ra, vati cahan cateni ra ta ra chi ra. Ta cani ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Cuahan ndico ra Pilato iti chata, ta cati ndico ra chi ra judío ta ra ti: ―Tava ndique chi ra ihya. Chacan cuu cha cua coto ndo ti ñahni cuati ra cuni yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chacan ni quee ndico ra Jesuu, ta indi xini ra tivi iñu can, ta ndichin ra sahma tixinda can, ta cati ra Pilato chi ra judío can ti: ―Na ndehe ndo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tacan cuu, ta ndehe ra sutu chahnu chi ra musu ra chi ra Jesuu, ta quechaha cana chaa ra ta ra ti: ―Cahni chi ra. Cahni chi ra ―cati ra. Ta cati ra Pilato ti: ―Cua quihin maan ndo chi ra, ta cua cahni maan ndo chi ra, vati ñahni cuati ra cuni yu. ");
INSERT INTO mioNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ta cati ndico ra judío can chi ra ti: ―Iyo ley ndi, ta iyo cha cua cuvi rahya cuenda ley ndi, vati cati ra ti sehe Ndioo cuu ra ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Chini ra Pilato cha cahan ra judío can, ta quechaha cuyuhvi cuni ra, vati cati ra ti sehe Ndioo cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Quihvi ndico tucu ra tichi ve tiñu, ta nducu tuhun ra chi ra Jesuu ti: ―¿Ndaa iti quichi cun? ―cati ra. Ta ra Jesuu taxin inda ra. Ñahni cha cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tacan cuu, ta cati ra Pilato chi ra ti: ―¿Atu ña cua cahun cha cahin? ¿Atu ña chito cun ti iyo ndatu chihin yu cha cua sañe chihun, ta iyo ndatu chihin yu cha cua cahni yu chihun? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ta cati ndico ra Jesuu chi ra ti: ―Tu ña cua cuhva ra Ndioo ndatu chihun, ña cua cuu tachi tuni cun chihin yu. Chacan cuu cha cahnu xaan ca iyo cuati ra ni chaha cuenda chihin yu chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chini ra Pilato cha cati ra Jesuu, ta quechaha nducu ra cuhva cha cua saña ndico ra chi ra, soco cana chaa ndico tucu ra judío can ti: ―Tu cua sañon chi ra, ñavi amigu cun chi ra César ra cumi tiñu cahnu iyo ñuun Roma. Xaan cuni ra Jesuu ya chi ra César, vati cuni ra Jesuu cundaca ñahan maan ra ―cati ra judío can. ");
INSERT INTO mioNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chini ra Pilato tuhun cha cahan ra judío can, ta cati ra ti cua tava ra sandaru chi ra Jesuu iti chata. Tacan cuu, ta ni chacunda ra Pilato nu cua tachi tuni ra chi ra nu nani chi Gabata cuhva cati ñivi judío can chi tuhun hebreo tuhun cahan maan ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Quivi can tiso vaha ñi, vati cua sacahnu ñi vico, ta cha cua cuu chi hora cuiti, ta quechaha cati ra Pilato chi ra judío can ti: ―¡Jihna! Ihya cha iyo ra ndaca ñahan chihin ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ta cana chaa ndico tucu ra ta ra ti: ―Cahni chi ra. Cahni chi ra nu cruu ―cati ra. Ta nducu tuhun ra Pilato chi ra ta ra ti: ―¿Atu cua cahni yu chi ra ndaca ñahan chi ndo? Ta quechaha cati ndico ra sutu chahnu ta ra ti: ―Iin tuhun ni ra César cuu ra ndaca ñahan chi ndi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tacan cuu, ta chaha cuenda ndico ra Pilato chi ra Jesuu chi ra judío can, vati cua cahni maan ra ta ra chi ra, ta quihin cuenda ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Cuahan ra Jesuu chi ra ta ra, ta ndiso ra cruu nu cua cuvi ra. Cuahan ra iti nu nani chi nu cuecu iquin xini ndii. Gólgota nani chi, cati ñivi judío can chi tuhun cahan maan ñi. ");
INSERT INTO mioNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tican chahni ñi chi ra. Nu cruu chahni ñi chi ra, ta chahni tahan ñi chi inga uvi ra. Mahñu ni chacuita caa ra Jesuu, ta iin iin chiyo xiin ra chacuita caa ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tacan cuu, ta cati ra Pilato ti cua taa ra ta ra iin vitu cahnu, ta cua taa ra ta ra chi chi xini cruu can, ta cati chi ti: “Jesuu ñuun Nazaret cuu rahya, ta ndaca ñahan ra chi ñivi judío,” cati chi. ");
INSERT INTO mioNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tacan cuu, ta tuvi ñivi judío ndehe tuhun can, vati yatin ñuun Jerusalén cuu nu ni taa ñi chi ra Jesuu nu cruu. Uni tuhun ndiso vitu can, ta ndiso chi tuhun cahan ñivi judío can. Ndiso tahan chi tuhun cahan ñivi ñuun Roma, ta ndiso tahan chi tuhun cahan ñivi griego. ");
INSERT INTO mioNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chacan cuu cha cati ra sutu chahnu chi ra Pilato ti: ―Ña vaha cha ni taun ti ndaca ñahan ra chi ñivi judío. Vaha ca cha cua taun ti maan ra cati ti ndaca ñahan ra chi ñivi judío. Tacan cati ra chi ra Pilato, vati ña ndoo ra vaha cha cua saxini ñivi ti ndaca ñahan ra Jesuu chi ñivi judío. ");
INSERT INTO mioNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ta cati ndico ra Pilato chi ra judío can ti: ―Cua ndoo chi cuhva can, vati cha ni tai chi chi. ");
INSERT INTO mioNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nu ni chahni ra sandaru chi ra Jesuu quihin ra ta ra sahma cuati ra, ta cumi cuenda chi natahvi ra chi chi, vati cua quihin iin iin ra iin iin chi. Quihin tahan ra sahma ndichin ra, soco ñahni nu cuicu chi, vati ini sahma niniin cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chacan cuu cha cati ra sandaru can chi tahan ra ti: ―Ña cua cahnda yo chehe, soco cua siqui yo yuu cuati, ta cua ndehe yo yoo cua quihin chi chi ―cati ra. Tacan ni savaha ra, ta saqueta ra cuhva cati tutu Ndioo nu cati chi ti natahvi ra ta ra sahma ra, ta quihin iin iin ra chi chi, soco siqui ra chi yuu cuati ti cua ndehe ra yoo cua quihin sahma ndichin ra, cati tutu Ndioo cuenda ra Jesuu. Chacan ni savaha ra sandaru can. ");
INSERT INTO mioNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yatin nu inda cruu nu chacuita caa ra Jesuu inda sihi ra chi ña María cuhvi ña. Ñasihi ra Cleofa chi ña, ta inda tahan ña María Magdalena. ");
INSERT INTO mioNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tacan cuu, ta ndehe ra Jesuu ti yatin inda sihi ra chi iin ra sacuaha chi ra, ta cuni xaan ra Jesuu chi racan. Tacan cuu, ta quechaha cati ra chi sihi ra ti: ―Yaya, ican inda sehun. ");
INSERT INTO mioNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ta cati ra chi racan ti: ―Ican inda sihun ―cati ra. Tacan cuu, ta hora can quihin ra chi ña, ta cha cucumi ra chi ña vehe ra sava ni ta cua sihi maan ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tacan cuu, ta chito ra Jesuu ti cha iyo vaha tiñu quichi ra, ta cati ra ti: ―Neti xaan cuni yu ―cati ra. Chacan cuu cha queta chi cuhva cati tutu Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tican iyo iin coho nduta chiti uva ndahvi. Chacan cuu cha tihi ñi iin yahma tichi nduta can, ta taa ñi chi chi nu yutun, ta sayaha ñi chi chi yuhu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tacan cuu, ta ni chihi ra Jesuu chi chi, ta cati ra ti: ―Cha iyo vaha. Tacan cuu, ta ni nducuhun xini ra, ta ni chihi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Chica ra judío tu manini chi ra Pilato ti cua cahnu ra iquin chaha ra ndaa nu cruu can. Tacan cua cahni ra chi ra ta ra, tu ña ta cuvi cuii ra, ta cua sanuun ndico ra ta ra chi ra nu cruu. Tacan ni cuni ra judío can, vati ni tiso vaha ra ta ra tiñu, vati inga quivi cuu quivi ii quivi cahnu. Chacan cuu cha ña cuni ra cha cua ndoo iquin cuñu ra ta ra nu cruu quivi sábadu can. ");
INSERT INTO mioNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tacan cuu, ta quichi ra sandaru, ta ni chahnu ra iquin chaha ra ni chihi chi ra Jesuu. Ndihi nduvi tahan ra chahnu ra iquin chaha ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tacan cuu, ta queta ra sandaru nu ndaa ra Jesuu, ta ndehe ra ti cha ni chihi ra. Chacan cuu cha ña chahnu ca ra iquin chaha ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tacan cuu, ta caan iin ra xiin ra Jesuu chi nduyu ra, ta chati niñi ra, ta chati nduta. ");
INSERT INTO mioNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ndihi chacan ni ndehe yu, ta chahi cuenda chi ndo. Ndicha cuhva cati tuhin cuu chi, vati ndicha yu, vati cuni yu cha cua cuinu tahan ini ndo chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tacan ni chacoo chi, vati cuhva cati tutu Ndioo cuu chi. Cati chi ti ña cua tahnu iquin ra, ");
INSERT INTO mioNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ta iyo inga nu cati chi ti cua ndehe ñivi chi ra nu ni caan ra, cati chi. ");
INSERT INTO mioNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tacan cuu, ta ni chica ra José ra ñuun Arimatea tu manini chi ra Pilato. Cuni ra José can quihin ra iquin cuñu ra Jesuu, vati amigu ra chi ra, soco ña chito ñivi cha amigu ra chi ra, vati yuhvi ra José chi ra judío tahan ra. Tacan cuu, ta chaha ra Pilato ndatu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tacan cuu, ta cuahan tahan ra Nicodemo chi ra José, ta ra Nicodemo can cuu ra ni cahan chi ra Jesuu iin cha cuaa nu quichi quivi. Chandaca ra xahan chahan xico vixin. Mirra chi áloe cuu chi, ta queta oco uchi kilu chi chandaca ra. ");
INSERT INTO mioNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tacan cuu, ta quihin ra ta ra iquin cuñu ra Jesuu, ta tuvi ra sahma vaha chi ra, ta cuhu ra xahan can iquin cuñu ra ticu sahma can cuhva iyo costumbre ñi cha cuchi ñi ndii. ");
INSERT INTO mioNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yatin nu chihi ra iyo iin nu iyo ita taqui. Tican iyo iin yavi yuu cha savaha ñivi, ta chaa chi, vati ña ta ñahni ndii cucuchi ican. ");
INSERT INTO mioNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tican cuchi ra chi ra Jesuu, vati quivi tiso vaha ñivi judío cha cua sacahnu ñi vico cuu chi, ta yatin iyo yavi yuu can. ");
INSERT INTO mioNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Xini vita cuu chi, ta cuahan ña María Magdalena nu ni cuchi ra Jesuu. Nahan xaan, ta ni vii naan, ta cuahan ña. Queta ña, ta ndehe ña ti ña ndasi ca yuu yuhu chi. ");
INSERT INTO mioNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chacan cuu cha chinu ndico ña, ta cuahan ña nu iyo ra Simón Pedro chi ra iyo mani xaan chi ra Jesuu, ta quechaha cati ña chi ra ti: ―Cha ni tava ndico ñivi chi ra chahnu tichi yuu can, ta ña chito ndi ndaa iti chanaan ñi chi ra ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chacan cuu cha quee ra Pedro chi tahan ra, ta cuahan ra. Cuahan ra iti nu ni cuchi ra Jesuu, ");
INSERT INTO mioNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ta chinu ra ta ra cuahan ra. Nduvi ra chinu, soco nihin ca chinu inga ra, ta queta xihna ra nu ni cuchi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Quechaha ndehe ihni ra, ta ndehe ra ti caa sahma, soco ña quihvi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tacan cuu, ta queta tahan ra Simón Pedro. Iti chata ra quichi ra, vati ña nihin vaha chinu ra, ta quihvi ra iti tichi, ta ndehe tahan ra ti caa sahma can. ");
INSERT INTO mioNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Caa tahan pañitu cha cunuhni xini ra, soco ña caa chi nu caa inga sahma. Caa siin chi iin chiyo, ta ituvi vaha chi. ");
INSERT INTO mioNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tacan cuu, ta quihvi tahan inga ra. Ra quichi xihna cuii cuu ra, ta ni ndehe tahan ra, ta ni chinu ini ra ti cha natacu ndico ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ña ta cutuni ini ra ta ra yoso cuhva cati tutu Ndioo ti cua cuvi ra, ta cua natacu ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tacan cuu, ta cuahan ndico ra ta ra iti vehe ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tacan cuu, ta inda ña María Magdalena can iti chata nu ni cuchi ra Jesuu. Ndahyu ña. Ndahyu ña, ta ndehe ihni ña, vati cuni ndehe ña iti tichi, ");
INSERT INTO mioNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ta ndehe ña ti iyo uvi tatun Ndioo. Ndichin ra sahma cuichin, ta ndaa ra nu ni chacava ra Jesuu. Iin ra ndaa nu chacoo xini ra, ta inga ra ndaa nu chacoo chaha ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tacan cuu, ta quechaha cati ra chi ña ti: ―Yoho sihi, ¿ñacu ndahyu xaun? Ta cati ña chi ra ti: ―Quichi quihin ñivi chi ra chahnu, ta ña chite ndaa iti cha cuchi ndico ñi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tacan cati ña, ta ndico coo ña, ta ndehe ña ti cha inda ra Jesuu, soco ña chito ña cha ra Jesuu cuu ra, ");
INSERT INTO mioNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ta quechaha cati ra chi ña ti: ―¿Ñacu ndahyu cun, ta sihi? ¿Yochi nanducu cun? ―cati ra. Saxini ña ti ra cumi ita cuu ra, ta cati ña chi ra ti: ―Vasi maun cuu ra quichi quihin iquin cuñu ra, taa. Cua cati cun chihin yu ndaa iti cha cuchi ndico cun chi ra ndii can, ta cua cuiso ndico main chi ra inga chiyo ―cati ña. ");
INSERT INTO mioNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ta cati ndico ra Jesuu chi ña ti: ―¡María! ―cati ra. Ta ndico coo ña, ta cahan ña chi ra. Tuhun hebreo cahan ña, ta cati ña ti: ―¡Raboni! ―cati ña. Maestru cuni cati tuhun can. ");
INSERT INTO mioNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Tacan cuu, ta cati ra Jesuu ti: ―Ña tiun chihin yu, vati ña ta cuhin nuun iyo suti. Cuahan nuun iyo ra amigu yu, ta cua cati cun chi ra ti cua cuhin nuun iyo suti nu iyo sutu ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tacan cuu, ta cuahan ña María Magdalena can, ta chaha ña cuenda ti cha ni ndehe ña chi ra chahnu, ta chaha ña cuenda ñaan tuhun cha ni cati ra chi ña. ");
INSERT INTO mioNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Cha cuaa domingu xini vita can, ta ndasi vaha yu vehe nu iyo cuiti ra sacuaha chi ra Jesuu, vati yuhvi ra cuenda ra judío. Tacan cuu, ta quichi ra Jesuu, ta ni chacuinda ra mahñu nu iyo ra, ta quechaha cati ra chi ra ti: ―Na cua coo taxin anima ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tacan cati ra, ta sanahan ra ndaha ra chi ra ta ra, ta sanahan ra xiin ra chi ra. Chacan cuu cha quechaha cusii ndico ini racan ta ra, vati ndehe ndico ra chi ra chahnu sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tacan cuu, ta cati ndico ra Jesuu chi ra ti: ―Na cua coo vii anima ndo. Tava tiñu yu chi ndo cuhva ni tava tiñu suti chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tacan cati ra, ta ni tivi ra tati ra chi ra, ta quechaha cati ra ti: ―Na cua coo ra Tati Ndioo chi ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tu cua sanaan ndo cuati ndacu ñivi, cua naan ndicha cuati ñi. Tu ña cua sanaan ndo cuati ndacu ñi, ña cua naan chi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ta ra Tuma cuu tahan ra iin ra uchi uvi ra sacuaha chi ra Jesuu, ta cati ñivi ti Tuma xinihin cuu ra. Racan ña iyo ra nu iyo cuiti tahan ra, ta ni quichi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chacan cuu cha quechaha cati tahan ra chi ra Tuma ti: ―Cha ni ndehe ndi chi ra chahnu ―cati ra. Ta cati ndico ra Tuma chi ra ti: ―Tu ña cua ndehi nu ni caan clavu ndaha ra, tu ña cua tihi nundahi nu ni caan clavu can, tu ña cua tihi ndahi nu caan nduyu xiin ra, ña cua cuinu ini yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yaha una quivi, ta ni nducuiti ndico tucu ra sacuaha chi ra Jesuu, ta iyo tahan ra Tuma. Ndasi ndico tucu yu vehe, soco quihvi ra Jesuu, ta ni chacuinda ra mahñu nu iyo cuiti ra, ta quechaha cati ra ti: ―Na cua coo taxin anima ndo. ");
INSERT INTO mioNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tacan cuu, ta quechaha cati ra chi ra Tuma ti: ―Ihya tichi ndahi cua tihun nundahun, ta cua tihun ndahun tihya xiin yu, ta cua ndehun. Ña cua saxini con, soco cua cuinu ini cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tacan cuu, ta cati ndico ra Tuma chi ra ti: ―Sacahnu ndicha yu chihun, vati Ndioo cuun, tata ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ta cati ndico ra Jesuu chi ra ti: ―Chinu ini cun, vati cha ndehun chihin yu. Iyo ñivi ña cua ndehe ñi chihin yu, ta cua cuinu ini ñi. Vaha xaan ca cua cusii ini ñican ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Cuaha xaan ca cuhva ni savaha ra Jesuu ndehe ra sacuaha chi ra, soco ña ni tai ndihi chacan tichi tutu ya. ");
INSERT INTO mioNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ndihi tuhun ya ni tai, vati tacan ni cua cuinu ini ndo ti ra Jesuu cuu sehe Ndioo, vati racan cuu ra ni tava tiñu ra Ndioo. Chacan cuu cha cua coo ndito ndo chi ra, tu cua cuinu ini ndo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tacan cuu, ta queta inga quivi, ta ndehe ndico tucu ra sacuaha chi ra Jesuu chi ra yu tañuhun Tiberia, ta tehen ni ndehe ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Iyo cuiti ra Simón Pedro chi ra Tuma xinihin chi ra Natanael ñuun Caná chi nduvi ra cuu sehe ra Zebedeo chi inga uvi ra sacuaha chi ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tacan ni iyo cuiti ra, ta quechaha cati ra Simón Pedro chi ra ta ra ti: ―Cuahin, vati cua tiin main tiaca. Ta cati ndico ra ta ra chi ra ti: ―Coho, vati cua cuhun tahan ndi chihun. Chacan cuu cha cuahan ra ta ra, ta quihvi ra tichi tundoo, ta ña ta ñahni cha tiin ra cha cuaa can. ");
INSERT INTO mioNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cha cua cundichin, ta ndehe ra cha inda Jesuu yu nduta can, soco ña chito ra ta ra ti ra Jesuu cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tacan cuu, ta cati ra Jesuu chi ra ta ra ti: ―¿Atu ña ta ñahni cha tiin ndo, ta yani xaa? Ta cati ndico ra ta ra ti: ―Ña ta ñahni. ");
INSERT INTO mioNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ta cati ra Jesuu chi ra ti: ―Cua cani ndo taraya inga chiyo, ta cua nihin ndo chi ri ―cati ra. Chacan cuu cha cani ra ta ra chi chi inga chiyo, ta ña cuu ca canihin ra chi chi, vati cuaha xaan ri tiaca indi. ");
INSERT INTO mioNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Iyo tahan ra cha cuni xaan ra Jesuu, ta cati racan chi ra Pedro ti: ―¡Jihna! Ra chahnu cuu ra cha inda. Nu ni chini ra Simón Pedro ti ra chahnu cuu ra chuhni ndico ra tichi ra, vati ña chanami vaha ra, ta chapa ra tichi nduta, ta cuahan ra iti yu nduta, ");
INSERT INTO mioNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","soco cuahan inga ra tichi tundoo can, vati ña cani iyo yuhu nduta. Vasi queta ciendu metro, ta queta ra ta ra yu nduta can. Xita queñuhun ra taraya can, ta cuaha xaan tiaca ñuhun tichi chi. ");
INSERT INTO mioNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tacan cuu, ta queta ra ta ra yu nduta can, ta ndehe ra cha cayu ñuhun, ta cha tihyo tiaca, ta iyo tahan paan. ");
INSERT INTO mioNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tacan cuu, ta cati ra Jesuu chi ra ta ra ti: ―Cua naquihin ndo uvi uni tiaca cha tiin ndo vitin ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Quihvi ra Simón Pedro tichi tundoo can, ta quechaha xita queñuhun ra chi ri nda cua nda nu ñuhun iti, ta mani tiaca nahnu ñuhun taraya can. Queta iin ciendu uvi xico uchi uni ri, ta cuaha xaan ri cuu ri, soco ña tahnda taraya can. ");
INSERT INTO mioNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tacan cuu, ta cati ra Jesuu chi ra ta ra ti: ―Nahan ndo, vati cua curamosa ndo ―cati ra. Ta yuhvi ra ta ra nducu tuhun ra chi ra yoo ra cuu ra, vati chito ra ti ra chahnu cuu ra, soco tucu cuhva iyo ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tacan cuu, ta ni tuhva ra Jesuu yu nuhun can, ta quihin ra paan can, ta ni chaha ra chi chi chi ra ta ra, ta ta ni cuhva chaha ra tiaca can. ");
INSERT INTO mioNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Chehe cuu uni chaha cha ni ndehe ra sacuaha chi ra Jesuu chi ra, ta cha ni chihi ra, ta natacu ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ndihi chachi ra ta ra, ta sa quechaha cati ra Jesuu chi ra Simón Pedro sehe Jonaa ti: ―Moon, cuni rahya ta ra chihin yu. ¿Atu cuni con chihin yu? Ta cati ndico ra Pedro chi ra ti: ―Chito cun ti cuni yu chihun, ra chahnu. Ta cati ra Jesuu ti: ―Cua tindeun chi ñivi yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tacan cuu, ta cati ndico tucu ra Jesuu chi ra Pedro ti: ―¿Atu cuni cun chihin yu, Moon? Ta cati ndico ra Pedro chi ra ti: ―Chito cun ti cuni yu chihun, ra chahnu. Ta cati ra Jesuu chi ra ti: ―Cua cumi cun chi ñivi yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tacan cuu, ta cati ndico tucu ra Jesuu chi ra cha cuu uni chaha: ―¿Atu cuni cun chihin yu, Moon? ―cati ra. Ta quechaha cucuihya cuni anima ra Pedro, vati cha uni chaha cha nducu tuhun ra tuhun can chi ra, ta cati ra chi ra ti: ―Ra chahnu, chito cun ndihi cha iyo. Chito cun ti cuni yu chihun. Ta cati ndico ra Jesuu ti: ―Cua tindeun chi ñivi yu. ");
INSERT INTO mioNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Cati ndicha yu chihun ti cha cuun ra tivaa, ta chacundichin cun sahmon, ta cuahun ndaa iti cuni maun cuhun, soco cua nduchahnu cun, ta sa cua sacaun ndahun, ta cua sacundichin inga ñivi chihun, ta cua cuiso ñi chihun ndaa iti cuni maan ñi. Ña cua cuu ca cati maun ndaa iti cua cuhun cun ―cati ra Jesuu chi ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tacan cati ra Jesuu, vati chaha ra cuenda yoso cuhva cua cuvi ra Pedro, ta cua sacahnu ra chi ra Ndioo. Tacan cuu, ta cati ndico tucu ra chi ra ti: ―Na cua savahun cuhva cuni yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tacan cuu, ta ndico coo ra Pedro, ta ndehe ra ti chata ra vachi iin ra, ta cuni xaan ra Jesuu chi ra. Racan cuu ra ni chacava yatin nu chacava ra Jesuu, ta chachi ra icaa ni nu quichi quivi, ta quivi can quechaha nducu tuhun ra chi ra Jesuu ti yoo ra cuu ra cua xico tuhun chihin ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ndehe ra Pedro ti ra cahan tuhun can cuu ra vachi iti chata, ta cati ra chi ra Jesuu ti: ―¿Ñaan cha cua tahan racan, ta ra chahnu? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ta cati ndico ra Jesuu chi ra Pedro ti: ―Tu cua cuni yu cha cua ndoo ra nda cua nda quivi cua quichi ndico yu, ñavi cuenda maun cua cuu chi. Maun na cua savahun cuhva cuni yu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tacan cuu, ta quechaha saxini ndihi ñivi Ndioo ti ña cua cuvi racan, soco ña cati ra Jesuu ti ña cua cuvi ra. Cati ra ti tu cua cuni ra cha cua ndoo ra nda cua nda quivi cua quichi ndico tucu ra, ñavi cuenda ra Pedro cua cuu chi, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ta ra cuu amigu xaan chi ra Jesuu cuu ra ni cati tuhun ndihi tuhun ya, ta ni taa ra chi chi nu tutu ya, ta chito yo ti cha ndicha cuu tuhun cati tuhun ra. ");
INSERT INTO mioNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iyo cuaha xaan ca cha ni savaha ra Jesuu, soco yuhu saxini ti ña cua cundee yo taa yo ndihi tuhun cha ni savaha ra, vati cuaha xaan chi cuu chi. Na cua cuu chi tacan ni.");
INSERT INTO mioNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Yuhu cha ni tai iin tutu chihun iti chata nu ni quichi quivi, yoho Teófilo. Tutu tai chihun xihna cuii cuu chacan, ta chahi cuenda yoso cuhva ni savaha ra Jesuu nu quichi quivi. Chaha tahin cuenda yoso cuhva ni sacuaha ra chi ñivi. Quivi can ni nacachi ra chi ra cuu tatun ra. Tacan cuu, ta cati ra Tati Ndioo chi ra Jesuu ti cua cati tuhun ra chi ra tatun ra ñaan tiñu cua savaha ra ta ra. Tacan ni savaha ra Tati Ndioo, ta sa cuahan ra Jesuu iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Xihna ca ni ndehe ra Jesuu tu ndoho, ta ni chihi ra. Chito tatun ra ti cha ndicha iyo ndito ndico ra Jesuu, vati ndehe ra ta ra cha ni savaha ra Jesuu quivi can. Uvi xico quivi cha iyo ndico ra chi tatun ra, ta cati tuhun maan ra yoso cuhva cua cundaca ñahan ra Ndioo chi ñivi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ni vii iyo ra Jesuu chi tatun ra, ta quechaha cati tuhun ra chi ra ta ra. Cati ra chi ra ta ra ti: ―Ña cua quee ndo tichi ñuun Jerusalén, soco cua cuatu nuun ndo. Na cua quichi xihna ra Tati Ndioo, vati cua tachi suti chi ra cuhva cati yu chi ndo. Nu quichi quivi chahi cuenda chi ndo, vati cua quichi ra Tati Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ni sacuanduta ra Juaan chi nduta, soco vaha xaan ca cha cua quichi ra Tati Ndioo. Inga suhva ca quivi, ta cua quichi coo ra chihin ndo ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tacan cuu, ta nducuiti tucu ra Jesuu chi ra tatun ra, ta quechaha nducu tuhun ra ta ra chi ra Jesuu ti: ―Ra chahnu, ¿atu tichi quivi ya cua cuhva ndico maun ndatu, ta cua cundaca ñahan ndico ra cuu ñivi judío? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Cati ndico ra Jesuu chi ra ta ra: ―Ña cua coto ndo ndaa quivi, ta ni ña cua coto ndo ñaan yoo cua cundaca ñahan ndico ra cuu ñivi judío. Chi sutu yu cuu ndatu can, ");
INSERT INTO mioNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","soco cua coo ra Tati Ndioo chihin ndo, ta cua coo tu ndee ini ra Ndioo chi ndo, ta cua cati tuhun ndo ñaan cuhva ni chacoi chi ndo. Cua cati tuhun ndo tichi ñuun Jerusalén, ta cua cati tuhun ndo nini cahnu ñuhun Judea chi ñuhun Samaria, ta cua cati tuhun tahan ndo nini cahnu ñuhun ñuñivi ―cati ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Cha ndihi cahan ra Jesuu, ta ndehe tatun ra ti ndaa ra iti siqui. Chasi iin vico nu cuahan ra. Ña ndehe ca ra tatun chi ra, ");
INSERT INTO mioNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","soco ndehe xaan ra ta ra iti siqui nu cuahan Jesuu, ta jihna cha iyo uvi rai nu inda ra ta ra. Nduvi tahan ra nami sahma cuichin, ");
INSERT INTO mioNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ta quechaha cati ra chi ra tatun Jesuu can ti: ―Ndioho yani xaa, ña cua ndehe ca ndo iti siqui andivi. Cha quee ra Jesuu nuun iyo ndo, ta cuahan ra iti siqui. Cua quichi ndico ra ta ni cuhva ni ndehe ndo cha cuahan ra iti siqui andivi ―cati racan ta ra. ");
INSERT INTO mioNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tacan cuu, ta quee ra tatun Jesuu ta ra yucu Olivo can, ta cuahan ndico ra iti ñuun Jerusalén. Yatin ñuun Jerusalén iyo yucu can. Vasi queta sava hora chica ñivi cha chahan ñi tican. ");
INSERT INTO mioNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Quihvi ndico ra tatun Jesuu tichi ñuun, ta cuahan ra ta ra nda vehe iyo nda siqui, ta ni chacunda ra ta ra. Ican iyo ra Pedro chi ra Jacobo chi ra Juaan chi ra Ndree chi ra Felipe chi ra Tuma chi ra Bartolomé chi ra Mateo chi ra Jacobo sehe ra Alfeo chi ra Simón ra cuni cuati chi ñivi ñuun Roma chi ra Juda yani ra Jacobo. ");
INSERT INTO mioNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ndihi ni quivi nducuiti ndihi ra ta ra, ta nducuiti tahan ña María sihi ra Jesuu chi inga ñi ñahan. Nducuiti tahan yani ra Jesuu chi ñi, ta nahan xaan tuhva ñi cahan ñi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tuvi ñivi Ndioo nducuiti quivi can. Iin cahnu ni nducuiti ñi. Vasi queta iin ciendu oco ñi, ta ni chacuinda ra Pedro, ta quechaha cati ra chi ñi ti: ");
INSERT INTO mioNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Ndioho yani xaa, nini xaan cua sacuinu yo cuhva cati ra Ndioo tichi tutu ra. Nu quichi quivi cati tuhun ra Tati Ndioo chi ra David ti cua taa ra tuhun yoso cuhva cua tahan ra Juda. Racan cuu ra ndaca chi ñivi tiin chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Chica tahan ra Juda can chi ndi, ta tiñu savaha ndi satiñu tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Quihin ra Juda xuhun yahvi ra, vati savaha ra ndavaha ni, ta sata ra iin ñuhun. Nduva ra iti xini ra, ta ndata tichi ra, ta quee chiti ra, ta chihi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chito ndihi ñivi iyo ñuun Jerusalén ñaan cha ni tahan ra Juda can. Chacan cuu cha Acéldama nani ñuhun can cati ñi chi tuhun cahan maan ñi. Nu chati niñi ñivi cuu tuhun can, vati tican ndoyo ñuhun ra Juda can. ");
INSERT INTO mioNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tichi libru Salmo cati ra Ndioo cuenda ra Juda ti: Taxin cua ndoo nu ni chacoo ra, ta yoni cua coo tican. ta cati ndico tucu ra Ndioo ti: Tiñu ni chiso ra cua quihin inga rai. Tacan ni cati ra Ndioo cuenda ra Juda iti chata. ");
INSERT INTO mioNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Chacan cuu cha cua quihin inga rai tiñu ni chiso ra Juda, ta cua cati tuhun tahan ra ti cha natacu ndico ra Jesuu. Iyo cha ni chica tahan ra chihin ndi ndihi ni quivi ni chacoo ra chahnu Jesuu chihin yo. Iyo cha chica ra chihin ra Jesuu nda quivi ni sacuanduta ra Juaan ta nda quivi cha cuahan ra Jesuu iti siqui andivi. ¿Ndaa ndo cuu ra? ―cati ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tacan cuu, ta cha nihin ñi uvi ra. Iin ra nani José Barsabaa. Justo nani tahan ra, ta inga ra nani Matía. ");
INSERT INTO mioNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tacan cuu, ta quechaha cahan ndahvi ñi chi ra Ndioo, ta cati ra Pedro chi ra ti: ―Yoho ra chahnu, chito cun yoso saxini ndihi ñivi chi anima ñi. Cua sanahun chihin ndi yoo rai cua quihin tiñu ni chiso ra Juda, vati uvi ra cuu ra iyo ihya. ");
INSERT INTO mioNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Cua sanahun yoo ra cua cuu tatun Jesuu, vati quee siin ra Juda, ta ndoyo ñuhun ra. Tacan ni cati ra Pedro chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tacan cuu, ta quechaha siqui ra ta ra chi yuu cuati, ta sacanaan ra Matía, vati quee yuu ra. Chacan cuu cha quihvi tahan ra Matía, ta cha cuu tahan ra tatun Jesuu, vati uchi iin ni ra ni ndoo. ");
INSERT INTO mioNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Queta iin vico sacahnu ñivi judío, ta ni nducuiti ndihi ñivi Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tacan cuu, ta quii xaan quechaha chini ñi iin ndusu. Iti siqui andivi quee ndusu can, ta cuhva caa tati nihin xaan caa chi. Chini ñi cha nihin xaan yaha tati can niniin vehe nu ndaa ñi, ");
INSERT INTO mioNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ta ndehe ñi iin cha caa cuhva caa yaa ñuhun. Chita cuati chi, ta chacoso chi xini iin iin ñivi can. ");
INSERT INTO mioNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Quihvi ra Tati Ndioo anima ndihi ñi, ta quechaha cahan ñi tuhun cahan ñivi cuu inga tucu ñivi, ta siin siin tuhun cahan ñi ta ñi. Cahan ñi cuhva chaha ra Tati Ndioo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Quivi can iyo ñivi judío cha quee ñi nini cahnu ñuhun ñuñivi, ta cha iyo cuii ñi ñuun Jerusalén. Cumi vaha ñi costumbre maan ñi cha sacahnu ñi chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chini tahan ñican ndusu quee iti siqui. Chacan cuu cha nducuiti ñi. Ña nihin ñi cuhva ñacu chini ñi cha cahan ñivi Ndioo can. Iin iin ñi judío can cutuni ini ñi cha cahan ñivi Ndioo can, vati tuhun cahan maan ñi ñuun ñi cahan tahan ñivi Ndioo can. ");
INSERT INTO mioNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iyo xaan iyo xaan cuni ñivi judío can, ta quechaha cati ñi chi tahan ñi ti: ―Ñivi ñuhun Galilea cuu ndihi ñi, ta cahan ñi tuhun cahan maan yo. ");
INSERT INTO mioNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Iin iin yo chini yo tuhun cha cahan ñivi can. Cahan ñi cuhva cahan ñivi iyo ñuun yo nu vachi cuahnu yo, ta siin siin ñuun yo. ");
INSERT INTO mioNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Iyo yo quichi yo ñuhun Partia. Inga yo quichi yo ñuhun Media, ta cuaha xaan ñuhun quichi yo. Quichi yo ñuhun Elam, ñuhun Mesopotamia, ñuhun Judea, ñuhun Capadocia, ñuhun Ponto, ñuhun Asia quichi yo. ");
INSERT INTO mioNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Quichi tahan yo ñuhun Frigia, ñuhun Panfilia, ñuhun Egipto, ta sava ñuhun Libia cha iyo cuenda ñuhun Cirene. Ndihi ñuhun can quichi yo, ta iyo ñivi tahan yo quichi ñi ñuun Roma, ta iyo ñi ihya. ");
INSERT INTO mioNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Iin cuhva yo cuu ñivi judío, vati tata judío vachi cuahnu yo, ta inga cuhva yo sacuaha yo, ta ni quihvi yo cuenda ñivi judío. Iyo tahan yo quichi yo ñuhun Creta chi ñuhun Arabia. Chini soho yo tuhun cha cahan ñivi Ndioo can, vati cahan ñi tuhun cahan maan yo, ta cati ñi ti cahnu xaan cha ni savaha ra Ndioo ―cati ñi chi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iyo xaan cuni ndihi ñivi can, ta ña nihin ñi cuhva ñaan cha cuu chi. Iyo ñi cati ñi chi tahan ñi ti: ―¿Ñaan cha cuu chehe? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Inga ñi sacateni ñi, ta cati ñi ti: ―Chini xaan ra, vati cha chihi ra ndixi ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tacan cuu, ta ni chacuinda ra Pedro chi ndihi ra tatun Jesuu, ta quechaha cati tuhun ra Pedro chi ñican cha iyo ñuun Jerusalén can. Cati ra ti: ―Ndioho yani xaa, na cua tasoho ndo tuhun cua cati tuhin chihin ndo, vati tacan cua coto ndo ñaan cuenda cha cahan ndi inga tuhun. ");
INSERT INTO mioNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ña chini ndi cuhva saxini maan ndo, vati caa iin cha nahan cuu chi, ta ña ta queta hora cha chica cuu ra chini. ");
INSERT INTO mioNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ni chacoo iin rai cha cunani Joel iti chata. Ra cahan cuenda ra Ndioo cuu ra, ta cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Cha cati ra Ndioo ti: nu cuahan quivi cua tachi yu Tati Ii yu, ta cua coo ra chi ndihi ñivi. Sehe ndo cua cahan tuhin. Cua ndehe ra tivaa cha cua sanahin chi ra, ta cua cahan ñumahna chi ra chanihin. ");
INSERT INTO mioNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nu cuahan quivi cua tachi yu Tati Ii yu, ta cua coo ra chi ñivi cuu musu yu, ta cua cahan ñi tuhin. ");
INSERT INTO mioNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Iti siqui cua savahi iin cuhva, ta cua nduiyo ñivi. Iti nu ñuhun cua savahi inga cuhva, ta cua ndehe ñi yoso cuhva iye. Cua coo tu ndoho, vati cua cuvi xaan ñivi, ta cahnu xaan ñuhun cua cayu, ta cuaha xaan yuhma cua coo. ");
INSERT INTO mioNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Cua ndahva ñuhun ri nicandi, ta cua nducuaha ri yoo. Cuaha ri cua cuu sava ta cua iyo niñi. Tacan cuu, ta cua queta quivi cahnu quivi cua quichi ndico ra chahnu, ta cua tachi tuni ra chi ndihi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tu cua cahan ndahvi ñivi chihin yu, cua cacu ñi chi tu ndoho can. Tacan ni cati ra Ndioo ―cati ra Joel can. ");
INSERT INTO mioNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Ndioho yani xaa, tasoho ndo tuhun cua cati tuhin chi ndo. Chahi cuenda chi ndo yoo rai cuu ra Jesuu ra ñuun Nazaret. Chito ndo ti tiso ra Ndioo tiñu chi ra Jesuu, vati savaha ra Jesuu iin cuhva inga cuhva. Chacan cuu cha chito ndo ti cha iyo tu ndee ini chihin ra Jesuu, ta chito ndo cha nduiyo ñivi ndehe ñi cha savaha ra, ta chito ndo yoso cuhva iyo ra Ndioo. Ndehe maan ndo ndihi cha savaha ra Jesuu, vati chaha ra Ndioo tu ndee ini chi ra chacoo nu iyo ndo. ");
INSERT INTO mioNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Iti chata nu quichi quivi chito ra Ndioo yoso cuhva cua savaha ndo chi ra Jesuu, ta vitin chaha ra cha savaha ndo cuhva cuni maan ndo. Chacan cuu cha chaha ndo cha taa ra savaha ndavaha ni chi ra Jesuu nu cruu. Tacan ni chahni ndo chi ra, ");
INSERT INTO mioNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","soco chaha ra Ndioo tu ndee ini chi ra, ta natacu ndico ra. Tava ra Ndioo chi ra Jesuu nu iyo ñivi ndii, vati ña cuu ndoo ra tican. ");
INSERT INTO mioNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Iti chata ni cati ra David cuenda ra Jesuu ti: Chite vati iyo ra chahnu chihin yu. Iyo ra ndihi ni hora, vati ndoo cuii ra chihin yu. Chacan cuu cha ña cua saxini yu. ");
INSERT INTO mioNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chacan cuu cha cusii ini yu, ta chahi cuenda vati sii cuni yu. Chito vahi cha cua nandoto ndico ndiche. ");
INSERT INTO mioNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ña tichahi, vati ña cua nacoo ihni cun chihin yu nuun iyo ñivi ndii, ta ni ña cua cuhvon cha cua tahyu iquin cuñu yu. ");
INSERT INTO mioNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Cha sanahun chihin yu yoso cua coo ndito yu chihun. Cua cusii ini yu cua savahun, vati cua coi chihun, cati ra David cuenda ra Jesuu, vati ña cua ndoyo ñuhun cuii ra Jesuu nu cuahan quivi. ");
INSERT INTO mioNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Yani xaa, cua cati cachin yu chihin ndo ñaan ni tahan ra chahnu David ra ndaca ñahan chi ñivi yo nu ni quichi quivi. Chihi tahan maan ra, ta cuchi ra, ta ihya ni iyo ñaña ra nda cua nda vitin. ");
INSERT INTO mioNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Iin ra cahan cuenda ra Ndioo cuu ra chahnu David can. Chito ra ti cua savaha ra Ndioo cuhva cati ra chi ra, vati cati ra ti nu cuahan quivi cua coo iin ñivi ra David, ta cua cundaca ñahan ra cuhva ndaca ñahan ra David quivi can, cati ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tuhun can chito ra David iti chata. Chito ra ti cua tava tiñu ra Ndioo chi ra Cristo nu cuahan quivi, ta cua sacacu ra chi ñivi nu iyo ñi chi tu ndoho. Chaha ra David cuenda ti cua natacu ndico ra Cristo. Chacan cuu cha cati ra cuenda ra Cristo ti ña cua ndoo ihni ra nu iyo ñivi ndii, ta ni ña cua tahyu iquin cuñu ra, cati ra David iti chata. ");
INSERT INTO mioNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ndihi ndi cati tuhun ndi cha ni ndehe ndi, ta ndehe ndi ti chaha ra Ndioo tu ndee ini chi maan ra Jesuu, ta natacu ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Chaha ra Ndioo ndatu cahnu xaan chi Jesuu iti siqui andivi, vati iti chata cati ra Ndioo chi ra ti cua queta quivi cua cuhun ra Tati Ndioo nu ñuhun ñuñivi, cati ra. Chacan cuu cha tachi ra Jesuu chi ra ihya. Maan ra Tati Ndioo cuu ra savaha ndihi cha ni ndehe ndo vitin quivi ya, ta suvi ra savaha ndihi cha ni chini ndo vitin, vati sa quichi ra chuhva. ");
INSERT INTO mioNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Chaha ra David cuenda yoso cuhva cua cuhun ra Jesuu iti siqui, vati ñavi ra David cuu ra cuahan iti siqui. Cati ndico tucu ra David can cuenda ra Jesuu ti: Maan ra ndaca ñahan chi yuhu, ta cati ra chahnu Ndioo chi ra ti cua cunda ra Jesuu iti chiyo ndaha cuaha ra, vati iyo ndatu chihin ra. ");
INSERT INTO mioNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Iyo ra cua cuxaan ini ra chihin ra, soco cua sacanaan ra chi racan ta ra, vati cua tindee ra Ndioo chihin ra. Tacan ni cati ra Ndioo, cati ra David tiempu chahnu, vati cua coo tu ndee ini chi ra Jesuu quivi cua ndehe ra tu ndoho. ");
INSERT INTO mioNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Ndihi ndioho yani xaa, na cua cutuni ndicha ini ndo tuhun cha cati tuhin chihin ndo, vati tava tiñu ra Ndioo chi ra Jesuu, vati cua sacacu ra chi ñivi nu iyo ñi chi tu ndoho. Chaha ra Ndioo tu ndee ini chi ra, ta ndaca ñahan ra chi ñivi ra. Maan ndo chahni ndo chi racan, vati taa ndo chi ra nu cruu ―cati ra Pedro chi ndihi ñivi iyo cuiti tican. ");
INSERT INTO mioNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sa chini ñi tuhun cati tuhun ra Pedro, ta cuihya xaan quechaha cuni anima ñi. Quechaha nducu tuhun ñi chi ra Pedro chi ndihi ra tatun Jesuu ti: ―Yani xaa, ¿ñaan cua savaha ndi? ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ta cati ndico ra Pedro chi ñi ti: ―Iin iin ndo cua saña ihni ndo cuati ndacu ndo, ta cua nducu ndo iti Ndioo. Cuanduta ndo cuenda ra Jesucristo, vati cua naan cuati ndo. Cua coo tahan ra Tati Ndioo chi ndo, vati iin cha samani Ndioo chihin ndo cuu chacan. ");
INSERT INTO mioNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Iti chata cati ra Ndioo ti cua tachi ra Tati Ii ra chihin ndo chi ñivi ndo chi ndihi ñivi cuu inga tucu ñivi. Cua coo ra Tati Ndioo chi ndihi ñivi, tu cua cana ra chihin ñi, cati ra Ndioo ―cati ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Cuaha tuhun cati tuhun ra Pedro, ta chaha ra cha chini tuni chi ñi. Cati ra chi ñi ti: ―Coo vaha ndo chi ra Ndioo, coto cua ndoyo ñuhun tahan ndo chi ñivi ndacu ndavaha ni ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Iyo ñi chinu ini ñi tuhun cati tuhun ra Pedro, ta ni chanduta ñi. Vasi queta uni mil ñivi quihvi cuenda ra Ndioo quivi can. ");
INSERT INTO mioNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ndihi ni quivi nducuiti ñivi, ta sacuaha xaan ñi chi ra tatun Jesuu. Inuun inuun chacoo ndihi ñi chi tahan ñi. Chachi tahan ñi paan Ndioo, vati ñuhun ini ñi ti chihi ra Jesuu cuenda maan ñi, ta cahan ndahvi ñi chi ra Ndioo ndihi ni quivi. ");
INSERT INTO mioNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tacan cuu, ta quechaha cuyuhvi ndihi ca ñivi, vati cuaha xaan cuhva savaha ra tatun Jesuu. Ndehe ñi cha savaha ra, ta nduiyo ñi suhva, ta ndehe ñi yoso cuhva iyo ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Iyo cuiti ndihi ñivi Ndioo, ta iin cahnu iyo ñi chi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Xico ndico ñi cha iyo chi ñi. Xico ñi tihyo ñi, ta xico ñi ndatiñu ñi, ta chaha ñi cha ni nihin ñi chi tahan ñi, tu iyo cha cumani chi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Inuun inuun iyo ñi ta ñi, ta ndihi ni quivi nducuiti xaan ñi ve ñuhun cahnu cha iyo cuenda ñivi judío can. Vehe tahan ñi chachi ñi paan Ndioo cha iyo cuenda ra Jesuu. Icaa ni chachi ñi chi tahan ñi ndihi ni quivi. Cusii ini ñi, ta ña xii anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Sacahnu ñi chi ra Ndioo, ta iyo xaan tu manini chi ñi. Chacan cuu cha vaha cuni ndihi ca ñivi ndehe ñi chi ñi. Ndihi ni quivi nducu ñivi cha cua naan cuati ñi, ta quihvi ñi cuenda ra Ndioo. Tacan ni savaha ra chahnu Ndioo quivi can. ");
INSERT INTO mioNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Iin quivi cuahan ra Pedro chi ra Juaan iti ve ñuhun cahnu nu sacahnu ñivi judío. Caa uni cha cua ini hora cha cahan ñivi judío can chi ra Ndioo cuu chi. ");
INSERT INTO mioNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Cha cua queta ra ta ra tican, ta yaha ñivi ndiso ñi chi iin ra cojo. Cojo cuu ra, vati tacan ni cacu ra, ta ndihi ni quivi nacoo ñi chihin ra yu cora soco ndavi ve ñuhun can. Nu taqui nani yu cora can. Ican ni nacoo ñi chi ra, ta caya ra xuhun, vati yaha xaan ñivi cha cua quihvi ñi ve ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tacan cuu, ta ndehe ra ti cua quihvi tahan ra Pedro chi ra Juaan, ta chica ra xuhun chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ndehe xaan ra ta ra chi ra, ta quechaha cati ra Pedro chi ra ti: ―Na cua ndehe cun chihin ndi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tacan cuu, ta ndehe ra cojo can chi ra ta ra, vati saxini ra ti cua cuhva ra ta ra xuhun chi ra, ");
INSERT INTO mioNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ta cati ra Pedro chi ra ti: ―Ñahni xuhun iyo chi yuhu, soco cua tindei chihun yoso cuu. Iyo tu ndee ini chi ra Jesucristo ra ñuun Nazaret. Cuenda racan cati yuhu ti cua cuindon, ta cacon ―cati ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tacan cuu, ta tiin ra Pedro ndaha cuaha ra ndahvi can. Sacuinda ra chi ra, ta ni nduvita ni chaha ra. ");
INSERT INTO mioNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Quii xaan ni chacuinda ra, ta quechaha chica cuu ra. Tacan, ta quihvi ra Pedro chi ra Juaan tichi cora ve ñuhun can, ta quihvi tahan ra chi ra ta ra. Chica cuu ra. Ndava lahndi ra, ta sacahnu ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ndehe ndihi ñivi ti chica cuu tahan ra, ta sacahnu ra chi Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nacoto ñi chi ra, vati chito ñi ti suvi ra cuu ra ni chacunda yu cora can, ta caya ra xuhun chi ñivi. Iyo xaan quechaha cuni ñi, ta ña nihin ñi cuhva yoso cuhva ni nduvaha ra. ");
INSERT INTO mioNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ña saña ra cojo can chi ra Pedro chi ra Juaan. Quii xaan nducuiti ndihi ñivi coredor iyo soco ndavi ve ñuhun can nu inda ra Pedro ta ra. Coredor Salomón nani chi. Tican chinu ñi cuahan ñi, ta iyo xaan iyo xaan cuni ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ndehe ra Pedro cha ni nducuiti ñi, ta quechaha cati ra chi ñivi can ti: ―Ndioho yani xaa, nduiyo xaan ndo, vati ndehe ndo cha nduvaha chaha rahya. Iyo xaan ndehe ndo chi ndi. Vasi saxini ndo ti iyo xaan tu ndee ini chi ndi. Vasi saxini ndo ti iyo vaha xaan ndi chi ra Ndioo. Vasi saxini ndo ti cuenda chacan ni sanduvaha ndi chaha ra. Ñavi, xaa. ");
INSERT INTO mioNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ñivi chahnu yo―ra Abraham, ra Isaac, ra Jacob―sacahnu ra ta ra chi ra Ndioo nu quichi quivi. Ini maan ra Ndioo sacahnu chi ra Jesuu musu ra. Maan ndo tiin chi ra Jesuu, ta sayaha ndo chi ra iti nuun ra Pilato. Saxini ra Pilato can ti cua saña ndico ra chi ra Jesuu, soco ña chaha ndo. ");
INSERT INTO mioNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ña chaha ndo cha saña ra Pilato chi ra, ta ra ii ndicha cuu ra Jesuu. Ra cuiti vaha cuu ra, ta chica ndo tu manini chi ra Pilato ti cua saña ra chi inga rai cuhva iyo costumbre cha cua saña ra chi iin ñivi vico suhun can. Chacan cuu cha saña ra Pilato chi inga ra, ta ra chahni ñivi cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Chahni ndo chi ra Jesuu, ta maan ra chaha cha cua coo ndito ñivi chi ra Ndioo, soco chaha ra Ndioo tu ndee ini chi ra, ta natacu ndico ra. Ña ndoo ra nu iyo ñivi ndii. Cha ni ndehe maan ndi ti cha ni natacu ndico ra, ta chaha ndi cuenda. ");
INSERT INTO mioNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Cha ndehe ndo chi ra cojo ya. Nacoto ndo chi ra. Chinu ini ra ti cha iyo tu ndee ini chi ra Jesuu, ta sanduvita ra Ndioo chaha ra. Chinu ini ra chi ra Jesuu. Chacan cuu cha nduvaha ra cuhva ni ndehe ndihi ndo. ");
INSERT INTO mioNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Yani xaa, chite ti ña chito maan ndo ti tava tiñu ra Ndioo chi ra Jesuu, ta ni ña chito tahan ra cumi tiñu ñuun ndo. ");
INSERT INTO mioNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Cati ra Ndioo ti cua cati tuhun ndihi ra ni cahan cuenda ra iti chata. Chacan cuu cha cati ra ta ra ti cua tava tiñu ra Ndioo chi ra cuu ra Cristo, vati cua sacacu ra chi ñivi nu iyo ñi chi tu ndoho, soco cua ndehe ra tu ndoho, ta cua cuvi ra. Tacan ni tahan ra Jesuu. Chacan cuu cha sacuinu ra Ndioo cuhva ni cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Vitin na cua saña ihni ndo cuati ndacu ndo. Cuinu ini ndo chi ra Ndioo, ta tacan ni cua naan cuati ndo. ");
INSERT INTO mioNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Chacan cuu cha cua savaha ra Ndioo cha cua coo vaha ndo chi ra. Tacan cuu, ta cua tachi ndico ra chi ra Jesuu nu cuahan quivi, vati chi maan ra Cristo can tiso ra Ndioo tiñu, ta nu iyo ndo cua tachi ra Ndioo chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Cua queta quivi cua nduchaa ñuhun ñuñivi ya cuhva cati ra Ndioo chi ra ni cahan cuenda ra iti chata, soco ni cua ndoo ra Jesuu iti andivi nda cua nda cua queta quivi can. ");
INSERT INTO mioNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Suvi ni iti chata cati ra Moisee ti cua tachi ra chahnu Ndioo iin ra cuu ñivi ra cuhva ni tachi ra chi ra Moisee, ta cua cahan ra cuenda ra Ndioo. Cua tasoho ñivi ra ndihi tuhun cua cati tuhun ra chihin ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tu ña cua tasoho ñivi cha cua cati tuhun racan, cua cuvi cuii ñi, ta ña cua coo ca ñi chi ñivi Ndioo, cati ra Moisee. ");
INSERT INTO mioNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ndihi ra ni cahan cuenda ra Ndioo iti chata cati tuhun ra yoso cuhva cua quichi ra Jesuu nu cuahan quivi, ta quivi vitin cha ni quichi ra. Ini tuhun ni cati tuhun ra Samuel, ta chacan ni cati tuhun tahan ndihi ra quichi iti nuun ra. ");
INSERT INTO mioNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nu quichi quivi ni chacoo ra ni cati tuhun ra cuenda ra Ndioo, ta tahan yo vitin cuhva ni cati ra iti chata. Chacoo vaha tuhun, vati nduinuun ra Ndioo chi ñivi yo iti chata, ta ini tuhun ndoo chi maan yo nda cua nda vitin. Iti chata ni cati ra Ndioo chi ra Abraham ti nu cuahan quivi cua savaha iin ñivi ra tu manini chi ndihi ñivi ñuñivi, cati ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Chacan cuu cha ni tava tiñu ra Ndioo chi Jesuu musu ra. Xihna cuii tachi ra Ndioo chi ra nu iyo maan ndo, vati cuni ra savaha ra tu manini chi ndihi ndo. Cuni ra cha cua nacoo ihni ndo cuati ndacu ndo ―cati ra Pedro chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ni vii cahan ra Pedro ta ra chi ñivi can, ta queta ra sutu judío ta ra chi ra saduceo chi ra cuu xini cuenda ra policía ve ñuhun cahnu can. ");
INSERT INTO mioNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ña ndoo ra sutu ta ra vaha, vati sacuaha ra Pedro ta ra chi ñivi can, ta cati tuhun xaan ra chi ñi ti chito ñi ti cua natacu ndico ñivi ndii, vati cha ni natacu ndico ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tacan cuu, ta tiin racan ta ra chi ra Pedro chi ra Juaan, ta tihi ra chi ra ta ra ve caa. Nda inga quivi cua cutuni ra, vati cha cua cuaa, ta tiin ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","soco tuvi ñivi tasoho ñi tuhun cati tuhun ra Pedro ta ra, ta quechaha chinu ini ñi chi ra Jesuu. Vasi queta uhun mil ra rai quihvi cuenda ra Ndioo, ta siin cuu ñi ñahan. ");
INSERT INTO mioNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tuvi inga quivi, ta nducuiti ra sutu chahnu chi ra mandoni ve ñuhun chi ra sacuaha ley chahnu. Nducuiti ra ta ra suvi ni ñuun Jerusalén can. ");
INSERT INTO mioNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Iyo ra Anaa ra cuu sutu chahnu chi ra Caifás chi ra Juaan chi ra Lejandru, ta cha iyo tahan ndihi ñivi maan ra sutu chahnu can. ");
INSERT INTO mioNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tacan cuu, ta cana tiñu chi ra Pedro chi ra Juaan, ta yaha ra ta ra iti nuun ra chanihin can, ta quechaha nducu tuhun ra chanihin can chi ra ta ra ti: ―¿Yoso cuhva ni sanduvaha ndo chi ra cojo can? ¿Yoo ni chaha ndatu chihin maan ndo? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tacan cuu, ta iyo ra Tati Ndioo chi ra Pedro, ta quechaha cati ra chi ndihi ra chanihin can ti: ―Ndihi ndioho tata, ");
INSERT INTO mioNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","vitin cha chica tuhun xaan ndo chi ndi, vati tindee ndi chi ra cojo ya. Cha chica tuhun ndo yoso cuhva ni nduvaha ra. ");
INSERT INTO mioNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tu tacan cuu, yuhu sacote chihin ndo chi ndihi ñivi judío ti ni nduvaha ra, vati iyo tu ndee ini chi ra Jesucristo ra ñuun Nazaret. Maan ndo taa chi ra Jesuu nu cruu, soco natacu ndico ra tañu ñivi ndii, vati chaha ra Ndioo tu ndee ini chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Maan ndo cuu sava ta cua ra sandaa vehe, ta tava ndaa ndo yuu vaha tutu vehe, ta ra Jesuu cuu sava ta cua iin yuu vaha xaan. Tava ndaa ndo chi ra, ta rai cahnu cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Maan ra Jesuu sanduvaha anima ñivi. Ña cuu chi inga ñivi, vati yoni ca ñivi iyo nu ñuhun ñuñivi ya cha cuu sanduvaha anima ñivi. Iin tuhun ni maan ra Jesuu tachi ra Ndioo ihya ñuhun ñuñivi ya, ta ini maan ra Jesuu sanduvaha anima yo ―cati ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tacan cuu, ta ndehe ra chanihin can vati ña yuhvi ra Pedro, ta ni ña yuhvi ra Juaan. Chito ra ta ra cha ña chahan ra ta ra sicuela, ta ra cuati ni cuu ra. Chacan cuu cha iyo xaan quechaha cuni ra chanihin ta ra, soco chito ra cha sacuaha ra ta ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ndehe tahan ra cumi tiñu can vati cha iyo tahan ra cojo can chi ra, ta ni nduvaha ra. Chacan cuu cha ña nihin ra ta ra cuhva cha cua cati ndico ra. ");
INSERT INTO mioNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tacan cuu, ta tava ndaa ra chanihin chi ra ta ra iti chata, vati cua ndatuhun xihna ra chi tahan ra. ");
INSERT INTO mioNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tacan cuu, ta quechaha nducu tuhun ra chi tahan ra ti: ―¿Ñaan cha cuu cha cua savaha yo chi ra? Ña cua cuu cati yo ti ñahni ñaan cha savaha ra, vati cha savaha ra iin cuhva cahnu xaan, ta chito vaha ndihi ñivi iyo ñuun ya. ");
INSERT INTO mioNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Cua sayuhvi yo chi ra, vati cua cati yo chi ra ti ña cua cahan ca ra tuhun yoso cuhva iyo ra Jesuu. Chacan cuu cha ña cua cati tuhun ca ra chi ñivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tacan cuu, ta cana ndico ra chi ra Pedro chi ra Juaan, ta cati tuhun ra chi ra ti ña cua cahan ca ra yoso cuhva iyo ra Jesuu, ta ni ña cua sacuaha ca ra chi ñivi, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ta cati ndico ra Pedro chi ra ta ra ti: ―Cua saxini xihna ndo, ta cua cati ndico ndo ñaan cha cuu cha vaha cuenda ra Ndioo. ¿Atu vaha cua savaha ndi cuhva cati maan ndo? ¿Atu vaha cua savaha ndi cuhva cati ra Ndioo? ");
INSERT INTO mioNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ndiuhu cati ti ña cua cuu ndoo taxin ndi, vati nini xaan cua cati ndico ndi cha ni ndehe ndi. Nini xaan cua cati ndico tahan ndi cha ni chini soho ndi ―cati ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tacan cuu, ta sayuhvi ndico tucu ra cumi tiñu can chi ra, ta saña ni ra chi ra, coto cua cuxaan ñivi chi ra, vati ña nihin ra cuhva yoso cuhva cua tachi tuni ra chi ra ta ra. Sacahnu xaan ñivi can chi ra Ndioo, vati ni nduvaha ra cojo can. ");
INSERT INTO mioNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Cha yaha uvi xico cuiya ra cha iyo ra chi tu ndoho, ta nduvaha ra. Tacan ni ndehe ñivi yoso cuhva iyo ra Ndioo, vati ni sanduvaha ra chi ra cojo can. ");
INSERT INTO mioNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tacan cuu, ta quee ra Pedro chi ra Juaan, ta cuahan ra ta ra nu iyo cuiti ñivi Ndioo. Chaha ra ta ra cuenda ñaan cha cati ra sutu chahnu chi ra chanihin can chihin ra. ");
INSERT INTO mioNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ni chini soho ñi cha cahan ra ta ra, ta inuun ni quechaha cahan ndahvi ñi chi ra Ndioo. Cati ñi chi ra ti: ―Yoho tata, chitoho ndi cuun. Maun ni savaha andivi chi ñuhun ñuñivi chi tañuhun, ta maun ni savaha ndihi cuii cha iyo. ");
INSERT INTO mioNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Iti chata chaha maun cuenda chi ra Tati Ii cun ti cua cati tuhun ra chi ra David ra cuu ñivi ndi tiempu chahnu, ta musu cun ni cuu ra. Chacan cuu cha ni savaha ra cuhva cuni cun, ta ni cati ra ti: Ndicha ti ndurai xaan ñivi cuu inga tucu ñivi, ta ndicha ti saxini xaan ñivi judío, ta ñahni yavi ndaa cha saxini ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ndurai ra rey iyo nu ñuhun ñuñivi ya, ta nducuiti ra cumi tiñu cahnu ta ra. Cuni cani tahan ra ta ra chi maun chi ra Cristo, ta tava tiñu maun chi ra, vati cua sacacu ra chi ñivi nu iyo ñi chi tu ndoho, cati ra David iti chata. ");
INSERT INTO mioNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Ihya ñuun ya ni nducuiti ndicha ra Herode chi ra Poncio Pilato chi ra ni quichi inga ñuhun chi ñivi judío, ta chahni ra ta ra chi ra Jesuu, ta musu ii cun cuu ra. Rai ni tava tiñu maun cuu ra Jesuu, vati cua cundaca ñahan maan ra. ");
INSERT INTO mioNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tacan ni savaha ra cumi tiñu can ta ra, vati iti chata ni cati tuhun maun yoso cuhva cua savaha ñivi iti nuun. ");
INSERT INTO mioNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yoho tata chahnu, na ndehe. Cuni sayuhvi xaan ra chi ndi. Cuhva maun tu ndee ini chi ndi, vati musu cun chihin ndi. Ña cuhvon cha cua cuyuhvi ndi ni suhva. Tacan cua cundee vaha ini ndi, ta cua cati tuhun ndi tuhun maun. ");
INSERT INTO mioNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Cua cati tuhun maan ndi, ta maun cua sanduvahun chi ñivi. Maun cua savahun iin cuhva inga cuhva, vati chaha maun tu ndee ini chi ra Jesuu, ta musu ii cun cuu ra. Cahnu xaan cuhva cua savahun, ta cua ndehe ñivi yoso cuhva iyo cun, ta cua nduiyo ñi cha cua ndehe ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cha ndihi cahan ñi chi ra Ndioo, ta taan nu iyo cuiti ñi, vati cha quichi tucu Tati Ndioo anima ndihi ñi, ta ña yuhvi ñi cati tuhun ñi tuhun Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Inuun xaan iyo ndihi ñivi cuu ñivi Ndioo. Ndihi ñi cati chi tahan ñi ti cua cuhva ñi cha iyo chi ñi chihin ñivi cuu tahan ñi cuenda Ndioo, cati ñi. Chacan cuu cha ndihi cha iyo chi ñi cuu chi tahan ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Chacoo xaan tu ndee ini chi ra tatun Jesuu, vati tindee ñivi Ndioo can chi tahan ñi, ta cati tuhun ra tatun Jesuu can tuhun cha ni natacu ndico ra Jesuu, ta iyo xaan tu manini chi ndihi ñi ta ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ñahni cha chini ñuhun ni iin ñi, vati tindee ñi chi tahan ñi. Xico ñi vehe ñi. Xico ñi tihyo ñi, ta quichi ndaca ñi xuhun yahvi chi chihin ra tatun Jesuu, ta sacha ra xuhun can chihin ñivi chini ñuhun chihin chi. ");
INSERT INTO mioNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tacan ni savaha iin ra nani José, ta sama ra tatun Jesuu sivi ra. Bernabé nani ra savaha ra ta ra, vati chaha xaan ra tu ndee ini chi ndihi ñivi. Ra ñuhun Chipre cuu ra, ta ñivi ra Leví ra cuu sutu cuenda ra Ndioo tiempu chahnu cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ni chacoo iin ñuhun chi ra, soco xico ra chihin chi, ta quichi ndaca ra xuhun yahvi chi iti nuun ra tatun Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tacan cuu, ta iyo tahan inga ra chi ñasihi ra. Ananía nani ra, ta ñasihi ra nani Safira. Xico tahan ñi iin ñuhun ñi, ");
INSERT INTO mioNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","soco naquihin xehe ra Ananía suhva xuhun yahvi chi, ta chito ñasihi ra. Suhva chi chandaca ra chi ra tatun Jesuu, ta quechaha cati ra chi ra ta ra ti vachi ndaca ra ndihi xuhun yahvi ñuhun xico ra, cati ra, ");
INSERT INTO mioNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ta quechaha cati ra Pedro chi ra ti: ―Yoho Ananía, cha chaha maun cha sandoyo ñuhun run Satanaa chihun. Cha sandahyu ñahun chi ra Tati Ndioo. Cha tixehun suhva xuhun yahvi ñuhun xicon. ");
INSERT INTO mioNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ndicha ti ñuhun maun cuu chi. Ndicha ti chi maun cuu xuhun yahvi chi cha xico maun chi chi, soco cha saxini xaun ndavaha ni, ta savahun chacan. Ñavi chi ñivi ni sandahyu ñahun. Chi maan ra Ndioo cha sandahyu ñahun ―cati ra Pedro chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Chini ni ra Ananía tuhun ni cahan ra Pedro, ta nduva ni ra, ta chihi ra. Chini soho ndihi ñivi tuhun can, ta quechaha cuyuhvi xaan ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Iyo tahan ra tivaa ta ra, ta ni tuhva ra nu nduva ra ndii can, ta ni tuvi ra ta ra sahma chi ra, ta canihin ra ta ra chi ndii can, ta cuahan ra ta ra, ta cuchi ra ta ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Yaha suhva hora, ta quichi tahan ñasihi ra ndii can. Ña ta coto ña ñaan cha ni tahan ii ña, ta quihvi ña, ");
INSERT INTO mioNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ta quechaha nducu tuhun ra Pedro chi ña ti: ―¿Atu tehen ni xico ndo ñuhun ndo? Ta cati ndico ña ti: ―Avi. Tacan ni, tioo. ");
INSERT INTO mioNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ta cati ndico ra Pedro chi ña ti: ―Ña vaha cha nduinuun ndo, ta sandahyu ñahan ndo chi ra Tati Ndioo. Ndehe. Cha vachi ndico ra cuati, ta chuhva ni cuchi ra ta ra chi ra ii cun. Vitin cua cuiso ndico ra chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tacan cuu, ta nduva ni ña iti nuun ra Pedro, ta chihi ña. Quihvi ra tivaa can, ta ndehe ra ta ra vati chihi tahan maan ña. Naquihin tahan ra ta ra chi ña, ta cuahan ra ta ra, ta cuchi tahan ra ta ra chi ña nu ni cuchi ii ña. ");
INSERT INTO mioNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Chini ndihi ñivi cha ni tahan ñi, ta yuhvi xaan cuni ñi, ta yuhvi tahan ñivi Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Cuaha xaan cuhva savaha ra tatun Jesuu. Tacan ni ndehe ñivi yoso cuhva iyo ra Ndioo, ta nduiyo tahan ñi. Inuun iyo ndihi ñivi Ndioo, ta nducuiti ñi soco ndavi ve ñuhun cahnu nu iyo coredor Salomón, ");
INSERT INTO mioNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","soco inga ñivi yuhvi ñi cha cua quihvi ñi cuenda Ndioo, soco chito ñi vati vaha xaan ñivi cuu ñivi Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Vasi iyo ñivi yuhvi, soco tuvi xaan ñivi quechaha chinu ini chi ra chahnu Jesuu. Quihvi ra rai, ta quihvi tahan ñi ñahan cuenda ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Chacan cuu cha ni chandaca ñi ta ñi chi ñivi cuhvi yuhu iti. Ican caa ñi cuhvi can. Caa ñi nu yuvi. Caa ñi nu ticati. Caa ñi. Yuhu iti queta ñi, vati saxini ñi ti tu cua yaha ra Pedro, vasi cua yani condahvi ra nu caa ñi cuhvi can, ta cua nduvaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Quichi tahan ñivi iyo ndihi ñuun iyo yatin ñuun Jerusalén, ta quichi ndaca ñi chi ñivi cuhvi chi ñivi iyo tati cuihna anima, ta ni nduvaha ndihi ñi ta ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tacan cuu, ta cha iyo cuiti tucu ra sutu chahnu chi ra saduceo ta ra. Ndusoo ra ta ra ndehe ra chi ra tatun Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Chacan cuu cha tiin ra ta ra chi ra tatun Jesuu, ta tihi ra chi ra ta ra ve caa. ");
INSERT INTO mioNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Cha cuaa can quichi iin ra tatun Ndioo, ta nuna ra yu ve caa can, ta tava ra chi ra ta ra. Cati ra tatun Ndioo can chi ra ta ra ti: ");
INSERT INTO mioNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Cuahan ndo ve ñuhun cahnu nu sacahnu ñivi judío, ta cati tuhun vaha ndo yoso cuhva cua nduvaha anima ñivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Cha ndihi cahan ra tatun Ndioo can, ta vachi cundichin. Cuahan ra tatun Jesuu ta ra, ta quihvi ra tichi cora soco ndavi can, ta quechaha sacuaha ra chi ñivi can. Tacan cuu, ta nducuiti tucu ra sutu chahnu chi tahan ra. Cana ra chi ndihi ra toho ñuun chi ndihi ra cumi tiñu ta ra cha iyo cuenda ñivi judío can, ta tachi ra tiñu ti cua quichi ndaca ra chi ra indi ve caa. ");
INSERT INTO mioNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Cha cuahan ra tatun, vati cua quihin ra chi ra indi ve caa can, soco ña nihin ra chi ra ta ra. Chacan cuu cha cuahan ndico ra tatun can, ta chaha ndico ra cuenda chi ra cumi tiñu, ");
INSERT INTO mioNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ta cati ra chi ra ti: ―Queta ndi tican, ta ndehe ndi ti ndasi vaha yu ve caa can, ta inda ra policía cumi vaha ra chi chi. Nuna ndi, ta ndehe ndi ti ñahni ra tatun Jesuu indi iti tichi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chini ra cuu xini cuenda ra policía ve ñuhun cahnu can chi ra sutu chahnu cha cahan ra tatun can, ta ña nihin ra ta ra cuhva ñaan cua savaha ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tacan cuu, ta sa quichi iin rai, ta quechaha cati ra chi ra ta ra ti: ―Ta ra ni tihi ndo ve caa, vitin cha iyo ra ve ñuhun cahnu, ta sacuaha ra chi ñivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tacan cuu, ta cuahan ra cuu xini chi ra policía ra, ta quihin ra chi ra tatun Jesuu. Vii xaan quihin ra chi ra, vati yuhvi xaan ra chi ñivi, coto cua cani ñi yuu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Quichi ndaca ra chi ra ta ra, ta sayaha ra chi ra ta ra iti nu ra cumi tiñu can, ta quechaha cati ra sutu chahnu chi ra ta ra ti: ");
INSERT INTO mioNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Cha cati tuhun xaan ndi chihin ndo. Cati ndi ti ña cua sacuaha ca ndo yoso cuhva iyo ra Jesuu, ta vitin nihin xaan ca cha sacuaha ndo. Ndihi ñivi iyo ihya ñuun Jerusalén ya cha chini soho ñi, ta cati ndo ti chahni ndi chi ra Jesuu ―cati ra sutu chahnu chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nducahan ra Pedro cuenda ndihi ra tatun Jesuu, ta cati ndico ra chi ra cumi tiñu can ti: ―Cua tasoho ndi cuhva cati maan ra Ndioo, soco ña cua tasoho ndi cuhva cati ñivi. ");
INSERT INTO mioNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Iti chata tiempu chahnu sacahnu ñivi yo chi ra Ndioo, ta suvi ra cuu ra chaha cha natacu ndico ra Jesuu. Maan ndo chahni chi ra, vati ni taa ndo chi ra nu cruu. ");
INSERT INTO mioNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Vitin cahnu xaan rai cuu ra Jesuu, vati chaha Ndioo ndatu chi ra. Chacan cuu cha ndaca ñahan ra chihin ndi, ta ni sanduvaha ra anima ndi. Cuni ra cha cua saña ihni ñivi judío cuati ndacu ñi, ta cua sanaan ra cuati ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tuhun can cati tuhun ndi, vati chito ndi ti cha ndicha cuu chi. Ta ni cuhva chaha ra Tati Ndioo cuenda. Tachi ra Ndioo chi ra Tati Ndioo, ta quichi ra chi ñivi tasoho chi ra Ndioo ―cati ra Pedro ta ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ndihi tuhun can chini ra cumi tiñu ta ra, ta xaan xaan quechaha cuni ra, ta cuni cahni ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ni chacoo iin ra nani Gamaliel, ta ra cumi tiñu can cuu tahan ra. Sacuaha tahan ra tuhun Ndioo tuhun chahnu, ta iyo tahan ra cuenda ra fariseo. Sacahnu ndihi ñivi chi ra. Ni chacuinda racan, ta tachi ra tuhun ti cua quee ndico ra tatun Jesuu iti chata iin hora luhu ni. Tacan cati ra, vati iyo cha cua cahan ra chi ra cumi tiñu ta ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tacan cuu, ta quechaha cati ra Gamaliel can chi tahan ra ti: ―Ndioho yani xaa, cua saha vaha ndo cuenda ñaan cua savaha ndo chi racan ta ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Cua cuñuhun ini ndo, vati nu quichi quivi ni chacoo iin ra nani Teuda, ta suvi ra cati ti cahnu xaan rai cuu ra. Vasi queta cumi ciendu rai cha chica chihin ra Teuda can, ta cani tahan ra ta ra chi ra cumi tiñu, soco chahni ñivi chi ra, ta chinu ndihi ra chica chi ra, ta ñahni yavi ndaa cha ni savaha ra Teuda can. ");
INSERT INTO mioNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Iti nuun ca quivi ni chacoo censo cha quihvi sivi ñivi nuun ra cumi tiñu, ta ni chacoo inga ra nani Juda. Rai ñuun Galilea cuu ra. Chica tahan ñivi chi ra, soco chahni tahan ñivi chi ra, ta chinu tahan ra ni chica chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Vitin, yani xaa, yuhu cati ti na cua saña ndo chi rahya ta ra, ta na cua quee siin ra ta ra. Tu cua savaha ra cuhva saxini ñivi, ñahni ndico tucu yavi ndaa chi, ");
INSERT INTO mioNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","soco tu cua savaha ra cuhva cati ra Ndioo, ña cua cuu casi yo cha savaha ra. Saña ndo, coto cua cani tahan ndo chi ra Ndioo ―cati ra Gamaliel chi ra ta ra. Tacan cuu, ta savaha ra cumi tiñu ta ra cuhva cati ra Gamaliel can. ");
INSERT INTO mioNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Chacan cuu cha cana ndico tucu ra cumi tiñu chi ra tatun Jesuu can, ta cani ra chi ra, ta cati tuhun xaan ndico ra chi ra ti ña cua cahan ca ra ta ra cuenda ra Jesuu, ta saña ra chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tacan cuu, ta quee ra tatun Jesuu can iti nuun ra cumi tiñu can, ta cusii ini ra, vati chaha ra Ndioo cha ni ndehe ra ta ra tu ndoho cuenda ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ña saña ra cha sacuaha ra, vati ndihi ni quivi sacuaha ra chi ñivi ve ñuhun cahnu nu sacahnu ñivi judío can, ta cati tuhun ra chi ñivi can ti: ―Ni vii ndatu ndo chi ra Cristo ra cua sacacu chi ndo nu iyo ndo chi tu ndoho. Yuhu cati ti ra Jesuu cuu ra, vati cha ni tava tiñu ra Ndioo chi ra nu iyo yo ihya ―cati ra. Tacan ni sacuaha tahan ra vehe ñivi. ");
INSERT INTO mioNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Quivi can cha cuahan ndutuvi ñivi Ndioo. Iyo ñi cahan tuhun griego, ta iyo tahan ñi cahan tuhun hebreo, ta quechaha cahan yuhu ñivi cahan griego chi tahan ñi cahan hebreo, vati ña nihin tahan ñi ñahan ndahvi can cha sacha ra tatun Jesuu ndihi ni quivi. ");
INSERT INTO mioNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chacan cuu cha cana ra tatun Jesuu chi ndihi ñivi Ndioo, ta quechaha cati ra ta ra chi ñi ti: ―Ña vaha cha cua saña nuun ndi cha cati tuhun ndi tuhun Ndioo, ta cua sacha ndi cha cua cachi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yani xaa, na cua nacachi ndo ucha ra yani yo. Cua nducu ndo ndaa ra yani yo cuu rai vaha ndicha, ta iyo vaha ra Tati Ndioo chi ra, ta nditi vaha xini ra. Cua nducu ndo chi ra, ta cua cuhva ndi tiñu chi ra, ta cua sacha ra cha cua cachi ñahan ndahvi can. ");
INSERT INTO mioNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ta ndiuhu ni cua cahan ndi chi ra Ndioo, ta cua cati tuhun ndi tuhun ra ndihi ni quivi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tacan cuu, ta ndoo ndihi ñi vaha. Ni nacachi ñi chi ra Esteban, vati vaha xaan chinu ini ra chi ra Jesuu, ta vaha xaan iyo ra Tati Ndioo chi ra. Nacachi tahan ñi chi ra Felipe chi ra Prócoro chi ra Nicanor chi ra Timón chi ra Parmena chi ra Nicolaa. Ra ñuun Antioquía cuu ra Nicolaa can, ta cha quihvi ra cuenda ñivi judío nu quichi quivi, vati ña ta nacoto ra chi ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yaha ra ta ra iti nu ra tatun Jesuu, ta cahan ndahvi ra tatun Jesuu chi ra Ndioo, ta tiso ra ndaha ra xini racan ta ra, vati cua quihin ra tiñu can. ");
INSERT INTO mioNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tuvi ñivi chini tuhun Ndioo, ta cha cuahan ndutuvi ca ñivi chinu ini chi ra Jesuu iti ñuun Jerusalén. Tuvi tahan ra sutu judío tasoho ra, ta chinu tahan ini ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Cahnu xaan cuhva savaha ra Esteban nu iyo ñivi can, vati tindee ra Ndioo chi ra. Ndehe ñivi yoso cuhva iyo ra Ndioo, ta nduiyo ñi suhva cha ndehe ñi cuhva ni savaha ra Esteban. Chacan cuu cha iyo xaan tu manini chi ra Esteban, ta iyo xaan tu ndee ini chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Iyo ra judío ta ra ni quichi iti ve ñuhun nu iyo ñivi ndoo nuna, vati ña satiñu cuatu ca ñi, ta iyo tahan ra judío quichi iti ñuun Alejandría chi ñuhun Cirene. Iyo tahan ra judío can quichi iti ñuhun Cilicia chi ñuhun Asia. Ndihi ñuhun can quichi ra ta ra, ta quechaha cahan yuhu ra ta ra chi ra Esteban. ");
INSERT INTO mioNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ña nihin ra ta ra cuhva yoso cua cati ndico ra cha ni cahan ra Esteban, vati nditi ra Esteban suhva, ta tindee ra Tati Ndioo chi ra. Chacan cuu cha cati vaha xaan ndico ra Esteban chi ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Quihin ra judío can rai vata, ta quechaha cati ra vata can ti: ―Chini ndi cha cahan ra Esteban, ta cahan ra ndavaha ni chi ra chahnu Moisee chi ra Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Chacan cuu cha quechaha ndusaca. Xaan cuni ñivi can. Nduxaan tahan ra chanihin can chi ra sacuaha ley chahnu cha ni ndehe ra ta ra chi ra Esteban. Chacan cuu cha chinu ñi nu iyo ra Esteban, ta tiin ñi chi ra, ta chandaca ñi chi ra nu iyo cuiti ra cumi tiñu. ");
INSERT INTO mioNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Quihin ñivi can chi ra testigu vata, ta quechaha cati ra vata can ti: ―Ndihi ni hora cahan ra Esteban ndavaha ni. Cati ra ti ñahni yavi ndaa ve ñuhun yo, ta ni ña vaha ley chahnu yo. ");
INSERT INTO mioNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Chini ndi vati cati ra ti cua sanduva ra Jesuu ra ñuun Nazaret ve ñuhun ya, ta cua sanaan tahan ra Jesuu costumbre cha sanahan ra Moisee chihin yo ―cati ra vata can. ");
INSERT INTO mioNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tacan cuu, ta quechaha ndehe xaan ra nducuiti tican chi ra Esteban. Ndehe ra ta ra ti cuhva caa nuun iin tatun Ndioo caa nuun ra Esteban, vati ndundichin suhva nuun ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ta quechaha nducu tuhun ra sutu chahnu can chi ra Esteban ti: ―¿Atu ndicha cuhva cati racan ta ra? ");
INSERT INTO mioNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ta cati ndico ra Esteban chi ra cumi tiñu can ti: ―Ndioho tata chahnu, ndioho yani xaa, na cua taa vaha ndo soho ndo cha cua cati yu chihin ndo. Ñivi ra Abraham chihin yo, ta iti chata ni ndehe ra chi ra Ndioo cahnu. Ni chacoo ra Abraham ñuhun Mesopotamia. Ña ta cuhun ra iti ñuun Harán, ta ni ndehe ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Quivi can cati ra Ndioo chi ra ti cua quee siin ra Abraham ñuun ra, ta cua nacoo ra ñivi ra. Cua cuhun ra ñuhun nu cua sanahan Ndioo chihin ra, cati ra Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chacan cuu cha quee siin ra Abraham ñuhun Mesopotamia nu iyo ñivi Caldea, ta cuahan ra cua coo cuii ra ñuun Harán can. Ican chihi sutu ra, ta cati ra Ndioo ti na cua quichi ra Abraham ihya ñuhun Israel nu iyo yo vitin. ");
INSERT INTO mioNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ña chaha ra Ndioo cha cua nihin ra ñuhun quivi can. Ña chaha ra ni iin pedazu chi nu cua cuañu chaha ra, soco cati ndicha ra Ndioo chi ra ti cua cuhva ra iin ñuhun chihin ra. Chi maan ra cua cuu chi, soco cua queta quivi cua cuvi ra, ta cua cuhva ra Ndioo chihin chi chi sehe ra chi ñivi sehe ra, cati ra Ndioo chi ra Abraham can. Ña ta coo ni iin sehe ra Abraham, soco tacan ni cati ra Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Cati tahan ra Ndioo chi ra ti cua coo nuun ñivi ra inga ñuhun nu iyo inga ñivi. Tican cua cani ñivi can chi ñivi ra, ta cua satiñu cuatu ñivi ra chihin ñi. Cumi ciendu cuiya cua ndehe ñivi ra tu ndoho, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ta cati ndico tucu ra Ndioo chi ra Abraham ti cua tachi tuni ra Ndioo chi ñivi savaha tu ndoho can. Cua yaha xihna ñivi ra Abraham tu ndoho, ta cua quee ñi tican. Cua queta ñi ñuhun Israel, ta cua sacahnu ñi chi ra Ndioo, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Cha ndoo vaha tuhun can, vati nduinuun ra Ndioo chi ra Abraham nu quichi quivi. Chacan cuu cha tiso ra Ndioo costumbre cha cua tahnda ñiin xini xuu ra cuati ndihli, ta ña cua naan ini ñi ti cha iyo vaha tuhun can chi ra Ndioo. Tacan cuu, ta ni cacu ra Isaac sehe ra Abraham. Queta ra una quivi ra, ta savaha ra Abraham chi ra cuhva cati ra Ndioo. Tacan ni savaha tahan Isaac chi ra Jacob sehe ra. Suvi ni tacan savaha tahan ra Jacob chi ndihi uchi uvi sehe ra, ta chahnu ra ta ra, ta ndihi ra cuu sutu ñuun iti chata nu ni quichi quivi. ");
INSERT INTO mioNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Iin ra cuu sehe ra Jacob nani José, ta ndusoo ndihi ra yani ra chi ra. Chacan cuu cha xico yani ra chi ra chi toho cuahan iti ñuhun Egipto, soco ña saña ra Ndioo chi ra José can. ");
INSERT INTO mioNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Sacacu ra Ndioo chi ra ndihi nu ndehe ra tu ndoho. Tindee ra Ndioo chi ra José, ta ndehe ra Faraón ra ndaca ñahan chi ñivi iyo ñuhun Egipto can ti iyo xaan tu manini chi ra José, ta nditi suhva xini ra. Chacan cuu cha tiso ra Faraón tiñu chi ra, ta ndaca ñahan ra José chi ndihi ñivi Egipto chi ndihi ñivi iyo vehe ra Faraón. Cumi cuenda ra ndihi ñuhun ra Faraón can chi ndihi ndatiñu ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Chacoo iin tama niniin ñuhun Egipto can chi ñuhun Canaán. Ndehe xaan ñivi can tu ndoho, ta ñivi yo ni chacoo iti chata tiempu chahnu ña nihin ñi cha cua cachi ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Queta tuhun nuun ra Jacob ti iyo nuni iti ñuhun Egipto, ta tachi ra chi sehe ra tican. Ñivi yo chi racan ta ra. Cha chahan ra xihna cuii cuu chacan. ");
INSERT INTO mioNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Cuahan ndico ra ta ra inga chaha cha cuu uvi chaha, ta sacoto ra José ti yani ra chi ra, ta quechaha chito ra Faraón ndaa ñivi cuu ñivi ra José. ");
INSERT INTO mioNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tachi ra José tuhun ti cua quichi ra Jacob sutu ra chi ndihi ñivi ra. Uni xico chahun ñivi ra cuu ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tacan cuu, ta cuahan ra Jacob iti ñuhun Egipto, ta chacoo cuii ra tican, ta queta quivi chihi ra. Suvi ni tican ni chihi tahan sehe ra, ");
INSERT INTO mioNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","soco queta quivi chiso ndico ñivi ra iquin ra Jacob chi sehe ra iti ñuun Siquem. Tihi ñi iquin ra ta ra tichi ndaca ñaña cha ni sata ra Abraham tiempu chahnu, vati sata ra chi chi chi sehe ra Hamor. Tiahvi ra xuhun cuichin chi ra quivi ni iyo ra ñuun Siquem can. ");
INSERT INTO mioNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Cha cuahan ndutuvi ñivi ra Abraham ñuhun Egipto can, ta cha cua queta quivi cha cua cuhva ra Ndioo ñuhun chi ñivi ra Abraham cuhva ni cati ra Ndioo chi ra xihna cuii. ");
INSERT INTO mioNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tacan cuu, ta sa quihvi inga ra rey ndaca ñahan ñuhun Egipto can. Ña chito ra yoo rai cuu ra José can, vati cha iyo cuiya cha ni chihi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Sandahyu ñahan ra rey can chi ñivi yo, ta savaha ra ndavaha ni chi ñi, vati cuaha xaan ñivi cuahan china. Chacan cuu cha cati tuhun ra ti tu cua cacu ve cuati sehe ñi, cua savita ñi chi ve, ta cua cuvi ve. Tacan cati ra, vati cuahan ndutuvi ñivi ra Abraham suhva. ");
INSERT INTO mioNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Suvi ni quivi can ni cacu ra Moisee, ta ndehe ra Ndioo ti rai vaha cuu ve. Uni yoo ni chacoo ve vehe sutu ve, ");
INSERT INTO mioNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","soco queta quivi tixehe sihi ve sutu ve chi ve tichi tuñiin, vati yuhvi ñi chi ra rey can, soco ni nanihin sehe sihi ra Faraón chi ve, ta quihin ña chi ve. Sacuahnu ña chi ve, ta cuu ve sava ni ta cua iin sehe maan ña. ");
INSERT INTO mioNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chacan cuu cha sacuaha ra Moisee ndihi cha chini tuni cha iyo chi ñivi Egipto can, ta chacoo tu ndee ini chi ra. Vaha xaan cha cahan ra, ta vaha xaan satiñu ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Tacan cuu, ta queta ra uvi xico cuiya ra, ta quechaha saxini ra chi anima ra ti cua cu ndehe ra yoso cuhva iyo ñivi tahan ra ñivi Israel nu iyo ñi, ");
INSERT INTO mioNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ta iin quivi ni ndehe ra Moisee cha cani ra ñuhun Egipto can chi iin ra cuu tahan ra Moisee. Tindee ra Moisee chi ra ni ndoho, vati cani ndico ra Moisee chi ra Egipto can. Ni chahni ra Moisee chi ra, vati nduxaan ra suhva. ");
INSERT INTO mioNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Saxini ra Moisee can ti cua nihin ñivi ra cuhva ti chaha ra Ndioo tu ndee ini chi ra, ta cua sacacu ra chi ñi nu iyo ñi chi tu ndoho. Tacan ni saxini ra, soco ña nihin ñi cuhva. ");
INSERT INTO mioNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Inga quivi yaha ndico tucu ra Moisee, ta ndehe ra chi ra cuu ñivi ra. Ndehe ra ti cani xaan iin ra chi tahan ra, ta cuni ra Moisee sandumani ndico ra chi ra, ta quechaha cati ra chi ra ta ra ti ini ñivi cuu ra ta ra, ta ña vaha cani tahan ra ta ra, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ta ra cani chi tahan ra―tindaihni ra chi ra Moisee, vati cuati cuni ra chi ra, ta quechaha cati ra chi ra Moisee ti ñavi maan ra ndaca ñahan chi ra. Ñavi maan ra tachi tuni chi ra. Yoni tiso tiñu chihin ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Vasi cua cahni ra chihin ra cuhva chahni ra chi ra Egipto inga quivi, cati ra chi ra Moisee. ");
INSERT INTO mioNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tacan cuu, ta chinu ra Moisee, vati yuhvi ra. Cuahan ra inga ñuhun nu cani nu nani chi Madián. Cua ndoo nuun ni ra tican, soco nihin ra ñasihi ra, ta ni chacoo uvi sehe ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Uvi xico cuiya cha iyo ra tican, ta queta iin quivi cha cuahan ra tichi cuhu. Yucu Sinaí yaha ra, ta ndehe ra nu cayu iin cuhu. Tichi yaa ñuhun nu cayu cuhu can ni chacuindi iin ra cuu tatun Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Chacan ni ndehe ra Moisee, ta iyo xaan cuni ra, soco tuhva ra suhva ca nu cayu cuhu can, vati cuni ndehe ra ñaan cha cuu chi. Tacan cuu, ta quechaha chini ra ti cahan ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Quechaha cati ra Ndioo chi ra ti ra Ndioo cuu ra, ta ndihi ñivi ra Moisee sacahnu chi ra tiempu chahnu. Ra Abraham, ra Isaac, ra Jacob―ndihi ra ta ra sacahnu chi ra Ndioo, cati ra, ta nihin xaan quechaha quisi chi chi ra Moisee, ta ña cuni ca ra ndehe ra tican. ");
INSERT INTO mioNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Cati ndico ra chahnu Ndioo chi ra ti cua tava ra ndichan ra, vati ñuhun ii cuu chi nu inda ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Chito vaha ra Ndioo ti ndehe xaan ñivi ra tu ndoho nu iyo ñi ñuhun Egipto can. Chini ra cha cati ñi, vati ña cundee ca ñi. Chacan cuu cha quichi nuun ra, vati cua sacacu ra chi ñi. Cua cuhun ra Moisee, vati chi maan ra cua tava tiñu ra Ndioo iti ñuhun Egipto can, cati ra Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Suvi ra Moisee cuu ra, soco xihna ca ña sacahnu ñi chi ra, vati cati ñi chi ra ti ñavi maan ra cuu ra ndaca ñahan chi ñi. Ñavi maan ra cuu ra tachi tuni chi ñi, cati ñi. Ta ndehe. Suvi ra Moisee cuu ra, ta ni tiso ra Ndioo tiñu chi ra. Tacan ni savaha ra Ndioo, vati cua sacacu ra Moisee chi ñi nu iyo ñi chi tu ndoho, ta cua cundaca ñahan ra chi ñi. Quivi ni ndehe ra Moisee chi ra tatun Ndioo nu cayu cuhu can―quivi can tava tiñu ra Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tacan cuu, ta cahnu xaan cuhva savaha ra Moisee ñuhun Egipto, ta cuyuhvi ra rey can, vati ndehe ra yoso cuhva iyo ra Ndioo. Tacan cundee quee ñi tican, ta ni chandaca ra Moisee chi ñi inga ñuhun. Savaha tahan ra Moisee inga cuhva cahnu xaan Tañuhun Cuaha can, ta savaha ndico tucu ra Moisee cuhva cahnu xaan nu chica cuu ñi tichi cuhu. Queta uvi xico cuiya savaha ra cuhva tican, ta ndehe ñivi can yoso cuhva iyo ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ini ra Moisee can cati chi ñivi Israel can ti cua tava tiñu ra Ndioo chi inga ra cua cahan cuenda ra cuhva tava tiñu ra chi ra. Cua cuu tahan ra ñivi ñi, ta cua tasoho ñi chi ra, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Chahan tahan ra Moisee chi ñivi Israel cha chica cuu ñi tichi cuhu tiempu chahnu. Tican yucu Sinaí can ni cahan ra tatun Ndioo chi ra, ta suvi ni tican cati tuhun ra Moisee chi ñivi yo tiempu chahnu. Tican ni quihin cuenda ra ley Ndioo, ta sacoto ndico ra chi chi chi maan yo. ");
INSERT INTO mioNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Ña cuni tasoho ñivi yo cha cahan ra Moisee quivi can. Chacan cuu cha ña cuni ca ñi chi ra, vati cuni xaan ñi coo ñi cuhva ni chacoo ñi ñuhun Egipto. ");
INSERT INTO mioNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Chacan cuu cha ni vii iyo ra Moisee yucu Sinaí, ta quechaha cati ñi chi ra Aarón yani ra ti cua savaha ra ita niñu chihin ñi, ta cua cundaca chi chihin ñi nu cua cuhun ñi. Ra Moisee chacundaca chihin ñi cha quee ñi ñuhun Egipto, soco ña chito ñi ñaan ni tahan ra quivi can, cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Quivi can savaha ñi iin ita niñu ñi. Sundiquin luhu cuu ri savaha ñi, ta quichi ndaca ñi sana ñi. Chahni ñi chi ri iti nuun ita niñu can, vati cha sacahnu ñi chi chi, ta cusii ini ñi ndehe ñi ita niñu cha ni savaha maan ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Chacan cuu cha saña ndaha ra Ndioo chi ñi, ta chaha ra cha sacahnu ñi chi ri nicandi chi ri yoo chi ri tiñu. Savaha ñi cuhva taa ra ni cahan cuenda ra Ndioo tichi tutu taa ra ta ra iti chata, vati ra Ndioo chaha cuenda chi ra, ta cati ra ta ra cuenda ra Ndioo ti: Ndioho ñivi Israel, ni chica cuu ndo tichi cuhu uvi xico cuiya, ta ña sacahnu ndo chi yuhu, vati ña chahni ndo sana ndo, ta samani ndo chi ri chi yuhu. ");
INSERT INTO mioNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ndihi nu chahan ndo chiso ndo vehe ñiin luhu nu ndaa ita niñu sacahnu ndo, ta nani chi Moloc. Chiso tahan ndo inga ita niñu sacahnu ndo, ta nani chi Renfán. Cuhva caa ri tiñu iti siqui caa chi. Ita niñu can savaha ndo, ta sacahnu ndo chi chi. Chacan cuu cha cua tava ndai chihin ndo, ta cani xaan inga chiyo ñuhun Babilonia cua tava ndai chihin ndo, cati ra Ndioo chihin ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Tiempu chahnu quivi cha chica cuu ñivi yo tichi cuhu cha ni chacoo iin vehe ñiin nu sacahnu ñi chi ra Ndioo. Savaha ñi vehe can cuhva ni cati tuhun ra Ndioo, vati cha sanahan ra yoso cuhva cua savaha ra Moisee chi chi. ");
INSERT INTO mioNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tacan cuu, ta queta quivi ndaca ñahan ra Josué chi ñivi yo tiempu can. Ni vii chiso tahan ñi vehe ñiin can quivi can, ta cundee quenda ñi ñuhun nu ni chacoo ñivi ñuhun Canaán, vati tava ndaa ra Ndioo chi ñivi Canaán can quivi cha cua quihvi ñivi maan yo. Tacan ni sacahnu ñi chi ra Ndioo tichi vehe ñiin can nda cua nda quivi cha cuu ra David tiñu. ");
INSERT INTO mioNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Cuni mani ra Ndioo chi ra David can. Chacan cuu cha chica ra David tu manini chi ra Ndioo, vati cuni ra David savaha ra iin vehe vaha cuenda ra Ndioo, ta ini ra Ndioo cuu ra sacahnu ra Jacob. Ña nihin ra David tu ndee ini iti nuun ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Chacan cuu cha Salomón cuu ra ni savaha vehe cuenda ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yuhu cati ti ñavi tichi vehe ni savaha ñivi cuu nu iyo ra Ndioo. Ña chini ñuhun ra Ndioo cahnu iin vehe nu cua ndoo ra. Iyo ra cuhva cati ra ni cahan cuenda ra Ndioo, vati cati ra ti: ");
INSERT INTO mioNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Cha cati ra Ndioo ti iyo ndatu yu iti siqui andivi, ta iyo tahan ndatu yu nu ñuhun ñuñivi. Ña cua cuu savaha ndo iin vehe vaha ndicha nu cua coi. Ña chini ñuhin iin nu cua cunda tatun i, ");
INSERT INTO mioNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","vati savaha main ndihi cuii cha iyo. Tacan ni cati ra Ndioo, cati ra ni cahan cuenda ra Ndioo tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Ndioho ñivi Israel, ndava xaan ini ndo. Ña tasoho cuii ni ndo. Cani tahan ndo chi ra Tati Ndioo. Savaha ndo cuhva ni savaha ñivi ndo tiempu chahnu. ");
INSERT INTO mioNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Iti chata cani ñivi ndo chi ndihi ra ni cahan cuenda ra Ndioo. Cati tuhun ra ti cua quichi iin rai cuiti vaha nu cuahan quivi, ta chahni ñi chi ra ni cahan cuenda ra Ndioo can. Quichi ra Jesuu, ta xico tuhun ndo chi ra, ta chahni ndo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Iti chata ni cati tuhun ra tatun Ndioo ñaan cha cuu ley ra Ndioo chi ñivi ndo. Chito tahan ndo chi chi, soco ña sacuinu ndo cuhva cati ra ―cati ra Esteban chihin ra ta ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sa chini ra cumi tiñu can cha cahan ra Esteban, ta quechaha chachi ndasun nuhun ra, vati xaan xaan cuni ra ndehe ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","soco vaha xaan iyo ra Tati Ndioo chi ra Esteban can. Ndehe ndaa ra iti siqui andivi, ta ndehe ra ti cahnu xaan cuu ra Ndioo, ta chiyo ndaha cuaha ra inda ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tacan cuu, ta quechaha cati ra Esteban ti: ―¡Jihna! Nuna iti siqui andivi, ta ndichin ndehi chi ra cuu sava ta cua ra cuu sehe ñivi. Chiyo ndaha cuaha ra Ndioo inda ra Jesuu can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tacan cuu, ta chasi ra ta ra soho ra, ta cana chaa xaan ra, vati quihin xaan ra tisihi, ta quii xaan tuhva ra ta ra nu ni chacuinda ra Esteban. ");
INSERT INTO mioNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tava ndaa ra ta ra chi ra Esteban can iti yuhu ñuun can, vati cua cani ra yuu chi ra, ta cua cahni ra chi ra. Tava ra ta ra sahma ndichin ra, ta chaha ra chi chi na cua cumi iin ra tivaa nani Saulu chi chi. ");
INSERT INTO mioNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tacan cuu, ta cani ra ta ra yuu chi ra Esteban can, ta quechaha cahan ndahvi ra Esteban chi ra Jesuu. Cati ra chi ra ti: ―Yoho ra chahnu Jesuu, na cua canihin vahun chi yuhu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ni chahnu chiti ra, ta nihin xaan cana chaa ra, ta cati ra chi ra Jesuu ti: ―Yoho ra chahnu Jesuu, ña cua tiso cun cuati ndacu ra vitin siqui ra. Tacan cati ra Esteban, ta chihi ni ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Tacan cuu, ta vaha xaan cuni ra Saulu, vati chahni ra ta ra chi ra Esteban. Iyo tahan ra sacahnu chi Ndioo, ta cuchi ra ta ra chi ra Esteban, ta chacu xaan ra suhva, vati cha ni chihi ra Esteban can. Suvi ni quivi can quechaha chacoo tu ndoho cahnu xaan chi ñivi Ndioo iyo ñuun Jerusalén, ta chinu ndihi ñi. Iyo ñi chinu ñi iti ñuhun Judea, ta iyo tahan ñi chinu ñi iti ñuhun Samaria, soco ra tatun Jesuu―ña chinu ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tacan cuu, ta quechaha cani tahan xaan ra Saulu chi ñivi Ndioo, vati cuati cuni ra chi ñi. Vehe ta vehe cuahan ra, ta xita queñuhun ra chi ra rai chi ñi ñahan, ta tihi ra chi ñi ve caa. ");
INSERT INTO mioNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Chinu ñivi Ndioo cha quee ñi ñuun Jerusalén, soco cati tuhun ñi tuhun Ndioo ndihi ni ñuun nu yaha ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Chinu tahan ra Felipe, ta cuahan ra iti ñuhun Samaria. Queta ra iin ñuun tican, ta cati tuhun ra chi ñivi yoso cuhva ni quichi ra Cristo, vati ni tava tiñu ra Ndioo chi ra nu quichi quivi, vati cua sacacu ra chi ñivi nu iyo ñi chi tu ndoho. ");
INSERT INTO mioNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Vaha xaan tasoho ñican cha cati tuhun ra Felipe can, ta ndehe ñi ti savaha tahan ra cuhva cahnu xaan. Chacan cuu cha inuun iyo ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Cuaha xaan tati cuihna tava ra tichi anima ñivi. Cana chaa maan run tati cuihna can, ta quee run, ta nduvaha tahan ñivi nduñiin chi ñivi cojo. ");
INSERT INTO mioNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Chacan cuu cha cusii ini ndihi ñivi iyo ñuun can. ");
INSERT INTO mioNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Iyo tahan iin rai nani Simón ñuun can. Ra tasi cuu ra, ta iyo xaan cuni ndihi ñivi iyo ñuhun Samaria can ndehe ñi chi ra. Cati ra ti cahnu xaan rai cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tasoho ndihi ñivi cha cahan ra. Vasi ñivi cahnu cuu ñi, vasi ñivi ndahvi cuu ñi, soco tasoho ñi chi ra. Cati ñi ti cahnu xaan tu ndee ini iyo chi ra, vati ni chaha ra Ndioo tu ndee ini chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tasoho ñivi cha cahan ra Simón can, vati nahan xaan cha sandahyu ñahan ra chi ñi, vati cuaha xaan cha savaha ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Cati tuhun ra Felipe yoso cuhva cua cundaca ñahan ra Ndioo, ta cati tuhun tahan ra yoso cuhva iyo tu ndee ini chi ra Jesucristo. Tacan cuu, ta chinu ini ñican cha cahan ra Felipe, ta ni chanduta ñi. Chanduta ra rai, ta chanduta tahan ñi ñahan. ");
INSERT INTO mioNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Suvi ra Simón chinu tahan ini ra, ta ni chanduta tahan ra. Tacan, ta quechaha chica ra chi ra Felipe, ta ndehe ra Simón can iin cuhva inga cuhva cha ni savaha ra Felipe can. Iyo xaan iyo xaan cuni ra Simón cha ni ndehe ra ndihi cuhva cha ni savaha ra Felipe. ");
INSERT INTO mioNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ni vii iyo ra tatun Jesuu ñuun Jerusalén, ta chini ra tuhun cha ni chinu ini ñivi iyo ñuhun Samaria can chi ra Jesuu. Chacan cuu cha tachi ra tatun Jesuu chi tahan ra. Chi ra Pedro chi ra Juaan tachi ra tican. ");
INSERT INTO mioNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Cuahan ra ta ra iti ñuhun Samaria. Queta ra ta ra, ta quechaha cahan ndahvi ra ta ra chi ra Ndioo, ta cati ra ti na cua quichi coo ra Tati Ndioo anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tacan ni cahan ra, vati cha chanduta ni ñivi can cuenda ra chahnu Jesuu, ta ña ta coo ra Tati Ndioo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tacan cuu, ta tiso ra ta ra ndaha ra chi ñican, ta quihvi ra Tati Ndioo anima ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ndehe ra Simón ti cha ni tiso ni ra tatun Jesuu ndaha ra chi ñivi, ta quichi ra Tati Ndioo chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Chacan cuu cha quechaha cati ra Simón chi ra ta ra ti: ―Cuhva ndo tu ndee ini chi yuhu, ta cua tiso tahin ndahi chi ñivi, ta cua coo ra Tati Ndioo chi ñi, ta cua tiahvi yu chihin ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Cati ndico ra Pedro chi ra ti: ―Cua ndoyo ñuhun xuhun cun, ta cua ndoyo ñuhun tahun, vati saxini cun ti cua cuu sata cun cha samani ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ña cua cuu satiñu tahun tiñu ya, vati ña iyo vahun chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nacoo ihni cun ndavaha ni cha saxini cun, ta cahan ndahvi cun chi ra chahnu Ndioo ti na cua naan chi cuhva saxini cun chi anima cun, tu cua cuu naan chi. ");
INSERT INTO mioNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Chite yoso cuhva iyo cun. Cha ndusoo cun. Ña ta saña cun cuati ndacu cun. Chacan cuu cha cua ndoyo ñuhun cun ―cati ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ta cati ndico ra Simón chi ra ti: ―Na cua cahan ndahvi ndo chi ra Ndioo cuenda yu, ta ña cua tahin cuhva cati ndo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tacan cuu, ta cati tuhun ra Pedro chi ra Juaan tuhun Ndioo, ta chaha ra ta ra cuenda yoso cuhva cha savaha ra Ndioo. Cuaha ñuun iyo ñuhun Samaria can yaha ra ta ra, ta cati tuhun ra yoso cuhva cua nduvaha anima ñivi, ta cuahan ndico ra iti ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tacan cuu, ta quechaha cati iin ra tatun Ndioo chi ra Felipe ti: ―Cuahan iti ñuun Gaza. Cua quihun iti ni tahan iti ñuun Jerusalén, ta cuahun iti ñuun Gaza can ―cati ra. Ñahni ñivi iyo nu yaha iti tican. ");
INSERT INTO mioNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tacan cuu, ta quee ra Felipe cuahan ra, ta ndehe ra ti yaha iin rai ñuhun Etiopía. Cha iyo ica racan suhva, vati ndiso tiñu ra. Tesorero ñuhun can cuu ra, vati cumi ra ndihi xuhun ña Candace ña ndaca ñahan chi ñivi iyo ñuhun Etiopía can. Chahan racan ñuun Jerusalén, vati cha sacahnu tahan ra chi ra Ndioo cuhva iyo costumbre ñivi judío. ");
INSERT INTO mioNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tichi careta ndaa ra, ta cuanuhun ndico ra ñuun ra. Ndaa ra sacuaha ra tuhun cha ni taa ra Isaía ra ni cahan cuenda ra Ndioo iti chata, ");
INSERT INTO mioNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ta cati ra Tati Ndioo chi ra Felipe ti: ―Cuahan, ta cua satahun chi ra yoso nu careta can ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Chacan cuu cha chinu ra Felipe nu cuahan ra Etiopía can, ta chini ra ti sacuaha ra tuhun ni taa ra Isaía, ta quechaha nducu tuhun ra Felipe chi ra ti: ―¿Atu cutuni ini cun tuhun sacuahun? ");
INSERT INTO mioNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ta cati ndico racan chi ra ti: ―Tu iyo ra cua sacuaha chi yuhu, cua cutuni ini yu ―cati ra. Tacan cuu, ta cana ra chi ra Felipe na cua ndaa ra nu careta, ta cunda tahan ra chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Chehe cuu tuhun sacuaha ra. Inda ri mbee nu cua sata ixi ri, ta ña ndahyu ri. Cha ndaca ñivi chi ri mbee nu cua cuvi ri, ta ña ndahyu ri. Ta ni cuhva cua ndehe ra tu ndoho, ta ña cua cahan ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Taxin cua ndoo ra, ta cua cutuni ra, soco ñahni cuati savaha ra. Yoni cua cuhva cuenda yoso cuhva ni savaha ñivi ndavaha ni chi ra quivi chacoo ra nu ñuhun ñuñivi, vati cua cahni ñi chi ra. Tuhun can ni sacuaha ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tacan cuu, ta quechaha cati ndico ra Etiopía can chi ra Felipe ti: ―Na cua savahun tu manini, ta cua cati tuhun ndico cun. ¿Yoo rai cuu ra cati tuhun ra ni cahan cuenda ra Ndioo? ¿Atu cuenda suvi ni maan ra cahan ra? ¿Atu cuenda inga rai cahan ra tuhun can? Tacan ni nducu tuhun ra chi ra Felipe. ");
INSERT INTO mioNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Chacan cuu cha quechaha cati tuhun ra Felipe chi ra. Chaha xihna ra cuenda ñaan tuhun cuu chi cha ni sacuaha ra, vati cati cachin ra ti ra Jesuu cuu ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ni vii cuahan ra ta ra iti, ta queta ra ta ra nu iyo nduta, ta quechaha cati ra Etiopía can chi ra ti: ―¡Jihna! Ihya iyo nduta. ¿Atu ña cua cuu cuandute? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ta cati ra Felipe chi ra ti: ―Tu chinu ini cun chi ra Jesuu chi ndihi cuii anima cun, cua cuu ―cati ra. Ta cati ndico ra chi ra Felipe ti: ―Chinu ini yu ti ra Jesucristo cuu sehe Ndioo ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tacan cuu, ta cati ra ñu Etiopía can ti cua cucuiñi careta can. Tacan cuu, ta nuun ra ta ra, ta quihvi ra ta ra tichi nduta, ta sacuanduta ra Felipe chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Quee ra ta ra tichi nduta can, ta quihin ra Tati Ndioo chi ra Felipe, ta ni chandaca ra chi ra ñuun Azoto. Chacan cuu cha ña ndehe ca racan chi ra. Sii xaan cuni ra Etiopía can nu cuahan ra, vati nihin ra cuhva yoso cuhva iyo ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tacan cuu, ta iyo ra Felipe ñuun Azoto can. Quee ra cuahan ra, ta cati tuhun ra tuhun Jesuu ndihi ni ñuun nu yaha ra, ta queta ra ñuun Cesarea. ");
INSERT INTO mioNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ña ta saña ra Saulu cha cani tahan ra chi ñivi Ndioo. Ni vii cati ra ti cua cahni ra chi ñi. Chacan cuu cha cuahan ra iti nuun ra sutu chahnu judío can, ");
INSERT INTO mioNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ta chica ra tutu cua cuhva ra chi ra cuu xini ve ñuhun ñivi judío iyo ñuun Damasco. Tacan, ta ni nihin ra ndatu. Tu cua nanihin ra chi ñivi chica iti Jesuu, cua tiin ra chi ñi, ta cua cundaca ra chi ñi iti ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tacan cuu, ta quee ra cuahan ra. Cha cua queta ra ñuun Damasco can, ta ni ndehe ra iin ñuhun iti siqui andivi, ta tuun chi nuun ra. ");
INSERT INTO mioNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Quehni ra Saulu can nu ñuhun, vati tuun ñuhun can nuun ra, ta chini ra ti cahan ra Jesuu. Cati ra chi ra Saulu ti: ―Yoho Saulu, cha cani tahan xaun chi yuhu ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Cati ndico ra Saulu chi ra: ―¿Yoo cahan, ta tata? Ta cati ndico ra Jesuu chi ra ti: ―Yuhu ra Jesuu cui. Chi yuhu cani tahan xaun, soco suvi ni chi maun sandoyo ñuhun cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yuhvi xaan ra Saulu, ta cati ndico ra chi ra chahnu ti: ―¿Ñaan cha cuun chihin yu, ta tata? ―cati ra. Ta cati ndico ra chahnu chi ra ti: ―Cuinda, ta cuahan tichi ñuun. Cua cuhva ñivi cuenda ñaan cha cua savahun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ta ra chica chi ra Saulu―ña cahan ra, vati yuhvi xaan ra. Chini ra ndusu cha cahan chi, soco ña ndehe ra yoo rai cahan. ");
INSERT INTO mioNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ni chacuinda ndico ra Saulu, ta nuna ra titi nuun ra, soco ña cuu ca ndehe ra. Chacan cuu cha tiin ra amigu ra Saulu ndaha ra, ta chandaca ra chi ra tichi ñuun Damasco can. ");
INSERT INTO mioNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Queta uni quivi ña ndehe ca ra. Ña chachi ca ra, ta ni ña chihi ca ra nduta. ");
INSERT INTO mioNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ñuun Damasco can cha iyo iin ra nani Ananía. Cha ni quihvi tahan ra cuenda ra Ndioo, ta tichi ñumahna nducahan ra chahnu Ndioo chi ra. Cati ra Ndioo chi ra ti: ―Yoho Ananía. Ta cati ndico ra Ananía chi ra ti: ―¿Ñaan cha cuu cha cuun chihin yu, ta tata? ");
INSERT INTO mioNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ta cati ndico ra chahnu chi ra ti: ―Cuahan maun iti nu nani chi iti cuiti, ta vehe ra Juda cua nanducu cun chi iin ra ñuun Tarso. Saulu nani ra, ta cahan ra chi yuhu. ");
INSERT INTO mioNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Tichi ñumahna ndehe ra cha vachi iin ra nani Ananía, ta tiso ra ndaha ra chi ra, vati cua ndundichin ndico ndehe ra ―cati ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Cati ndico ra Ananía chi ra Ndioo ti: ―Tata chahnu, tuvi xaan ñivi cuu ñi chaha cuenda yoso cuhva iyo ra Saulu can, vati cuaha xaan ndavaha ni cha ni savaha ra chi ñivi cun ñuun Jerusalén, cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Vitin cha iyo ra ihya, ta tava ra ndatu nuun ra sutu chahnu can, vati cua tiin ra chi ndihi ndi cuu ñivi cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ta cati ndico ra chahnu chi ra Ananía ti: ―Cuahan, vati ni nacachi main chi ra Saulu can. Cua cati tuhun ra tuhun yu chi ñivi cuu inga tucu ñivi. Cua cati tuhun ra chi ra cumi tiñu ndaca ñahan chi ñican, ta cua cati tuhun tahan ra chi ñivi judío. ");
INSERT INTO mioNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Cua cuhve cuenda chi ra yoso cuhva cua ndehe ra tu ndoho cuenda yu ―cati ra Ndioo chi ra Ananía tichi ñumahna can. ");
INSERT INTO mioNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tacan cuu, ta cuahan ra Ananía nu iyo ra Saulu. Quihvi ra tichi vehe can, ta tiso ra ndaha ra chi ra Saulu, ta quechaha cati ra Ananía chi ra ti: ―Yoho Saulu, yani xaa, cha ndehun chi ra Jesuu iti nu ni quichi cun. Maan ra tachi chi yuhu. Chacan cuu cha cua ndundichin ndico ndehun, ta cua coo vaha ra Tati Ndioo chihun ―cati ra Ananía. ");
INSERT INTO mioNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tacan cuu, ta ndundichin vaha ndehe ra Saulu, vati quicoyo iin cha cuu sava ta cua soo ri tiaca nuun ra. Tacan cuu, ta cha chanduta ra. ");
INSERT INTO mioNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Chachi ndico ra, ta cha coo ndico tu ndee ini chi ra, ta suhva quivi ni ndoo nuun ra Saulu chi ñivi Ndioo ñuun Damasco can. ");
INSERT INTO mioNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chahan tahan ra Saulu ve ñuhun ñivi judío, ta cati tuhun ra ti sehe Ndioo cuu ra Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Chini ñivi can cha cahan ra, ta iyo xaan cuni ndihi ñi, ta quechaha cati ñi chi tahan ñi ti: ―Rahya cuu ra cani tahan xaan chi ñivi Ndioo iti ñuun Jerusalén, ta quichi ra ihya, vati cua tiin tahan ra chi ñivi Ndioo ihya, ta cua cundaca ra chi ñi iti nuun ra sutu chahnu ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tacan cuu, ta chaha xaan ca ra Ndioo tu ndee ini ra chi ra Saulu, ta cachin xaan sanahan ra chi ñivi ti ra Jesuu cuu ra Cristo ndicha, vati tava tiñu ra Ndioo chi ra, vati cua sacacu ra chi ñivi nu iyo ñi chi tu ndoho, ta ña nihin ñivi judío can cuhva yoso cua cati ndico ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Yaha quivi, ta ni nduinuun ra judío can, vati cua cahni ra chi ra Saulu, ");
INSERT INTO mioNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","soco quechaha chito ra Saulu yoso saxini ra ta ra. Iyo ndaca yuu candaa yu ñuun can. Ndasi cutu chi, soco iyo yuhu chi nu yaha ñivi. Nduvi ta niñu cumi ra judío can ndihi yuhu chi, vati cua cahni ra chi ra Saulu, ");
INSERT INTO mioNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","soco iin cha cuaa sacacu amigu ra Saulu chi ra, vati tihi ra chi ra tichi tica. Tacan ni sanuun ra chi ra iti chata ndaca can, ta chinu ra Saulu. ");
INSERT INTO mioNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Cuahan ra Saulu can iti ñuun Jerusalén, vati cuni natahan ra chi ñivi Ndioo tican, soco yuhvi ñi, vati ña chinu ini ñi ti cha ni quihvi ra cuenda Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Quihin cuenda ra Bernabé chi ra, ta chandaca ra chi ra nu iyo ra tatun Jesuu, ta chaha ra cuenda chi ra ta ra ti ni ndehe ra Saulu chi ra chahnu Jesuu iti, ta cahan ra Jesuu chi ra. Ñuun Damasco cati tuhun ra tuhun Jesuu, ta ña yuhvi ra, cati ra Bernabé. ");
INSERT INTO mioNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tacan cuu, ta quihin cuenda ra tatun Jesuu chi ra Saulu can, ta chica tahan ra chi ra ta ra ñuun Jerusalén. ");
INSERT INTO mioNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Cati tuhun xaan ra Saulu tuhun ra chahnu, ta ña yuhvi ra. Quechaha nducahan ra chi ra judío ta ra, ta cati tuhun xaan ra chi ra ta ra. Suvi ra cahan tuhun griego cuu ra judío can ta ra, ta cuni cahni ra ta ra chi ra Saulu. ");
INSERT INTO mioNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Quechaha chito ñivi Ndioo cha tacan cuu chi, ta chandaca ñi chi ra Saulu iti ñuun Cesarea, ta tachi ndico ñi chi ra iti ñuun ra. ");
INSERT INTO mioNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tacan cuu, ta ñahni ca tu ndoho chacoo chi ñivi Ndioo tican ñuhun Judea chi ñuhun Galilea chi ñuhun Samaria, ta chacoo ca tu ndee ini chi ñivi Ndioo. Cha cuahan ndutuvi ca ñi, ta vaha xaan tasoho ñi cuhva cati ra Ndioo, ta chaha ra Tati Ndioo tu ndee ini chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tacan cuu, ta chahan ra Pedro ndihi ñuun nu iyo ñivi Ndioo. Chahan tahan ra ñuun Lida, vati cua ndehe tahan ra yoso cuhva iyo ñivi Ndioo tican. ");
INSERT INTO mioNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ican ni tahan ra chi iin ra nani Enea, ta cuhvi ra. Cha queta una cuiya cha caa ra, vati nduñiin ra, ");
INSERT INTO mioNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ta cati ra Pedro chi ra ti: ―Yoho Enea, cha ni sanduvaha ra Jesucristo chihun. Cuinda, ta tuvi cun yuvi cun ―cati ra. Tacan cuu, ta ni chacuinda ra Enea can, vati nduvaha ra. ");
INSERT INTO mioNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ndehe ndihi ñivi iyo ñuun Lida can chi ñuun Sarón cha ni nduvaha ra, ta quechaha chinu ini ñi chi ra chahnu Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ñuun Jope ni chacoo iin ñahan nani Tabita, ta Dorca nani ña chi tuhun cahan ñivi griego. Chinu tahan ini ña chi ra Jesuu, ta iyo xaan tu manini chi ña, ta tindee tahan ña chi ñivi ndahvi. ");
INSERT INTO mioNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Quivi can quihin cuehe chi ña Dorca can, ta chihi ña. Sacuti ñivi chihin ña, ta chaqui vaha ñi chi ña iin vehe iyo nda siqui. ");
INSERT INTO mioNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tacan cuu, ta chini ñivi Ndioo iyo ñuun Jope can ti cha iyo ra Pedro ñuun Lida. Chacan cuu cha tachi ñi chi uvi ra nu iyo ra Pedro, vati ña cani ñuun Lida can. Queta ra, ta cahan ndahvi ra ta ra chi ra Pedro ti na cua cuhun ra, vati caa ndii. Cati ra chi ra Pedro ti: ―Vitin vitin coho iti ñuun ndi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Tacan cuu, ta quee ra Pedro, ta cuahan ra chi ra. Queta ra ta ra, ta quihvi ra nda vehe iyo nda siqui nu caa ndii can. Iyo ndihi ñi ndahvi cha ñahni ii ñi, ta chacu xaan ñi. Sanahan ñi ndihi sahma ndihi cha savaha ña Dorca cha ni ndito ña, ");
INSERT INTO mioNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","soco tava ra Pedro chi ndihi ñi iti chata, ta chahnu chiti ra, ta quechaha cahan ndahvi ra chi Ndioo. Tacan cuu, ta tuhva ra nu caa ndii can, ta quechaha cati ra chi ña ti: ―Cuinda, Tabita ―cati ra. Tacan cuu, ta nuna ña Dorca titi nuun ña. Ndehe ña chi ra Pedro, ta ni chacunda ña. ");
INSERT INTO mioNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tiin ra ndaha ña, ta sacuinda ra chi ña. Cana ra Pedro chi ñi ndahvi can chi ndihi ñivi Ndioo, ta chaha ra cuenda chi ñi, ta ndehe ñi vati cha iyo ndito ndico ña. ");
INSERT INTO mioNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Chito ndihi ñivi ñuun Jope can ñaan cha ni tahan ña Dorca, ta tuvi ñi cuu ñi quechaha chinu ini chi ra chahnu Jesuu. ");
INSERT INTO mioNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Cuaha quivi ndoo nuun ra Pedro ñuun can, ta vehe ra nani Simón ra satahyu ñiin ni chacoo ra. ");
INSERT INTO mioNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cha iyo iin rai nani Cornelio ñuun Cesarea. Capitán cuu ra, vati queta iin ciendu sandaru sacuenda ra, ta iyo tahan ra cuenda ra sandaru quichi iti ñuhun Italia. ");
INSERT INTO mioNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Sacahnu xaan ra Cornelio can costumbre judío. Ñavi ra judío cuu ra, vati quichi ra inga ñuhun, soco sacahnu ra chi ra Ndioo. Ta ni cuhva iyo ndihi ñivi ra, vati sacahnu tahan ñi chi ra Ndioo. Samani xaan ra xuhun chi ñivi ndahvi, ta ndihi ni quivi cahan ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Caa uni cha cua ini ndehe ra iin ñumahna. Cachin xaan ndehe ra, vati quichi iin ra tatun Ndioo nu iyo ra, ta quechaha cati ra tatun Ndioo can chi ra ti: ―Yoho Cornelio ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ndehe xaan Cornelio chi ra, ta yuhvi xaan cuni ra, ta cati ndico ra chi ra ti: ―¿Ñaan cuu cun chihin yu, ta ra chahnu? ―cati ra. Ta cati ra tatun Ndioo can chi ra ti: ―Cha chini soho ra Ndioo tuhun cha cahan ndahvi cun chi ra, ta ndehe ra cha tindee xaun chi ñivi ndahvi. Chacan cuu cha ñuhun ini ra chihun. ");
INSERT INTO mioNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Vitin cua tachi maun uvi rai iti ñuun Jope, vati cua cana cun chi iin ra nani Simón Pedro ti na cua quichi ra ihya. ");
INSERT INTO mioNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ndoo nuun ra vehe inga ra nani Simón. Ra satahyu ñiin cuu racan, ta yu tañuhun iyo vehe ra. Cua cati maan ra Pedro can ñaan cha cuu cha cua savahun ―cati ra tatun Ndioo can. ");
INSERT INTO mioNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tacan cuu, ta quee ndico ra tatun Ndioo, ta cuahan ra. Cana ra Cornelio chi uvi ra musu ra ta iin ra sandaru cumi chi ra. Chinu tahan ini ra sandaru can chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Cati cachin ra Cornelio chi ra ta ra ndihi cha ni tahan ra, ta tava tiñu ra chi ra iti ñuun Jope can, vati cua cu quihin ra chi ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tuvi inga quivi, ta quee ra musu ta ra cuahan ra. Cha cua queta ra ñuun Jope can maan hora, ta suvi ni hora can ndaa ra Pedro xini vehe, vati cua cahan ra chi ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Chisoco ra suhva. Chacan cuu cha cuni cusama ra, soco ni vii tiso vaha ñi, ta ndaa ra xini vehe can. Tacan cuu, ta quechaha ndehe ra ñumahna. ");
INSERT INTO mioNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ndehe ra ti nuna andivi, ta vachi nuun iin cha cuu sava ta cua iin sunduhu cahnu. Nuhni ndihi cumi punta chi. Tacan ni vachi nuun chi iti nu ñuhun. ");
INSERT INTO mioNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ndihi ri quiti cuhu ta ndihi ri coo iyo nu ñuhun ñuñivi―ñuhun ri tichi chi, ta ñuhun tahan ndihi ri saa. ");
INSERT INTO mioNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Chini ra Pedro ti nducahan ra Ndioo chi ra, ta cati ra ti: ―Yoho Pedro, cuinda, vati cua cahni cun chi ri quiti cuhu can, ta cua cachi cun chi ri. ");
INSERT INTO mioNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ta cati ndico ra Pedro chi ra ti: ―Ña cuu, vati ña tuhva yu cachi yu ni iin cha iyo ica cuenda costumbre maan ndi, ra chahnu. ");
INSERT INTO mioNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Inga chaha cati ndico ra Ndioo chi ra ti: ―Ña cua cati cun ti cha iyo ica cha chaha yuhu chihun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tacan ni cahan ndico tucu ra Ndioo chi ra inga chaha cha cuu uni chaha. Tacan cuu, ta ndehe ra ti cuahan ndico sunduhu can iti siqui andivi. ");
INSERT INTO mioNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Chacan cuu cha iyo xaan cuni ra Pedro, ta suvi ni hora can cha cua queta musu ra Cornelio nu cuahan ra, ta nducu tuhun ra chi ñivi ti: ―¿Ndaa iti iyo vehe ra Simón? ―cati ra. Ni vii saxini ra Pedro ñaan cha cuu cha ni ndehe ra, ta queta ni musu can yu vehe ra Simón can. ");
INSERT INTO mioNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Cana ra musu can, ta quechaha nducu tuhun ra ti: ―¿Atu iyo iin ra nani Simón Pedro ihya? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ni vii saxini ra Pedro ñaan cha cuu cha ni ndehe ra, ta quechaha cati ra Tati Ndioo chi ra ti: ―Cha vachi uni rai, ti cha nanducu ra chihun. ");
INSERT INTO mioNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Cua nuun cun tichi vehe, ta cua cuhun cun chi ra. Ña cua saxini cun ti inga tucu ñivi cuu ra, vati yuhu tachi chi ra nu iyo cun ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tacan cuu, ta nuun ra Pedro xini vehe, ta queta ra nu inda musu ra Cornelio, ta quechaha cati ra Pedro chi ra ti: ―Yuhu cuu ra. Cha nanducu ndo chi yuhu. ¿Ñaan tiñu vachi ndo? ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ta quechaha cati ra musu can chi ra Pedro ti: ―Iyo iin rai nani Cornelio. Capitán cuu ra. Rai vaha cuu ra, ta sacahnu ra chi ra Ndioo. Ndihi ñivi judío cati ti vaha xaan rai cuu ra. Cha ni cati tuhun iin ra tatun Ndioo chi ra Cornelio can ti cua cana ra chihun ti na cua cuhun cun iti vehe ra. Chacan cuu cha cua cuu tasoho ra tuhun cua cahan maun chi ra ―cati ra musu can chi ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tacan cuu, ta cati ra Pedro chi ra ta ra ti: ―Yaha ndo tichi vehe. Iyo nu cua cusu ndo ihya ―cati ra. Tuvi inga quivi, ta quee ra Pedro ta ra, ta cuahan ra, ta icaa ni cuahan tahan uvi uni ra sacahnu tahan chi ra Jesuu ñuun Jope can. ");
INSERT INTO mioNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tuvi ndico tucu inga quivi, ta queta ra ta ra ñuun Cesarea. Cha nataca ndihi ñivi ra Cornelio chi amigu ra vehe ra, vati cana ñahan ra chi ñi. Chacan cuu cha iyo ra Cornelio chi ndihi ñi vehe ra, ta cha ndatu ñi chi ra Pedro. ");
INSERT INTO mioNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Sa queta ra Pedro chi ra ta ra, ta quihin cuenda ra Cornelio chi ra. Chahnu chiti ra iti nuun ra Pedro can, vati sacahnu ra chi ra, ");
INSERT INTO mioNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ta sacuinda ndico ra Pedro chi ra, ta quechaha cati ra chi ra ti: ―Cuinda, Cornelio. Ña vaha cha sacahnu cun chihin yu, vati rai ñuñivi cuu tahin. ");
INSERT INTO mioNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tacan cuu, ta quechaha ndatuhun ra ta ra, ta quihvi ra ta ra tichi vehe. Ndehe ra Pedro ti tuvi ñivi cha ni nducuiti, ");
INSERT INTO mioNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ta quechaha cati ra Pedro chi ñi ti: ―Cha chito ndo ti ñivi judío cuu ndi, ta tucu ñivi cuu maan ndo. Chacan cuu cha iyo costumbre cha ña cuu coo nuun ndi chi maan ndo, ta ni ña cuu natahan ndi chi ndo, vati ica xaan iyo ndi cuenda costumbre sacahnu ndi nu quichi quivi, soco vitin cha sacoto ra Ndioo chihin yu cha ña cuu cati yu ti ica iyo yu cuenda costumbre yu, ta ni ña cuu cati yu ti ña cuu natahin chi ñivi cuu inga tucu ñivi. ");
INSERT INTO mioNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chacan cuu cha ña saxini que cha iyo ica yu, ta quichi yu hora cha quichi quihin ra chihin yu, ta vitin cua nducu tuhin chi ndo ti: “¿Ñacu cha quihin ndo chihin yu?” ");
INSERT INTO mioNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ta quechaha cati ra Cornelio chi ra ti: ―Vitin cha iyo cumi quivi cha cahin chi ra Ndioo ihya tichi vehi. Tehen hora cuu chi, vati caa uni cha cua ini, ta cahin chi ra Ndioo. Ni chacoo ndita yu, vati tacan ni sacahnu i chi ra Ndioo, ta ndehi tichi ñumahna ti quichi iin rai iti nuin. Ndichin xaan sahma ndichin ra, vati tatun Ndioo cuu ra, ");
INSERT INTO mioNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ta quechaha cati ra chihin yu ti cha chini ra Ndioo ti cahan ndahvi yu chi ra, ta ndehe ra ti tindee xain chi ñivi ndahvi, ta ñuhun ini ra chihin yu. ");
INSERT INTO mioNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Hora can cua tachi yu tuhun iti ñuun Jope ti na cua quichi iin ra nani Simón Pedro ihya. Cua quichi ra, ta cua cati tuhun ra chihin yu. Iyo nuun ra vehe ra Simón ra satahyu ñiin, ta yu tañuhun iyo vehe ra, cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ña nducuei, ta tachi yu tuhun chihun. Vaha xaan rai cuun, vati cha quichi cun. Vitin cha iyo cuiti ndihi ndi iti nuun ra Ndioo, vati cuni tasoho ndi ndihi tuhun cha cati tuhun ra chahnu chihun ―cati ra Cornelio. ");
INSERT INTO mioNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Quechaha cati ra Pedro chi ñi ti: ―Chito ndicha yu ti cuni mani ra Ndioo chi ndihi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Vasi inga tucu ñivi cuu ñi, soco ini cuhva iyo ñi iti nuun ra. Tu cua sacahnu ñi chi ra Ndioo, tu cua savaha ñi cuhva cuni ra Ndioo, cua quihin cuenda ra chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Chito ndo ti tachi ra Ndioo tuhun chi ñivi judío. Cati tuhun ra tuhun vaha cha sanduvii ra Jesucristo anima ñivi, ta ndaca ñahan ra Jesuu chi ndihi ñivi. ");
INSERT INTO mioNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Chito ndo cha ni chacoo nu quichi quivi ya niniin ñuhun nu iyo ñivi judío, vati xihna cuii ni cati tuhun ra Juaan, ta sacuanduta ra chi ñivi. Tacan ni cuu, ta quechaha cati tuhun ra Jesuu ra ñuun Nazaret iti ñuhun Galilea, ta cati tuhun tahan ra niniin ñuhun nu iyo ñivi judío can. Chito ndi ti tava tiñu ra Ndioo chi ra, ta chaha ra Ndioo cha ni chacoo Tati Ndioo chi ra, ta chaha tahan ra tu ndee ini chi ra. Chica cuu ra Jesuu ñuun ta ñuun, ta cuaha xaan cha vaha savaha ra chi ñivi can. Sanduvaha ra chi ndihi ñivi ndehe tu ndoho cuenda run cuihna, vati tindee ra Ndioo chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Cati tuhun ndi ndihi cha ni savaha ra Jesuu iti ñuun Jerusalén chi ndihi ca ñuun nu iyo ra judío ta ra, vati ndehe ndi cuhva ni savaha ra. Tacan cuu, ta ni chahni ñivi judío chi ra, vati taa ñi chi ra nu cruu, ");
INSERT INTO mioNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","soco chaha ra Ndioo tu ndee ini chi ra Jesuu, ta tichi uni quivi natacu ndico ra, ta chaha ra Ndioo cha ndehe ndico tucu ndi chi ra. ");
INSERT INTO mioNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ña ni ndehe ndihi ñivi chi ra. Mani maan ndi ndehe chi ra, vati chi maan ndi ni nacachi ra Ndioo nu quichi quivi. Cati tuhun ndi cha ni ndehe ndi, vati icaa ni chachi ndi chi ra, ta icaa ni chihi tahan ndi nduta chi ra, vati quivi cha natacu ndico ra tañu ñivi ndii ni chacoo ndico ra chi ndi icaa ni. ");
INSERT INTO mioNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tava tiñu ra Jesuu chi ndi, vati cua cati tuhun ndi tuhun ra chi ñivi. Cua cati tuhun ndi ti tava tiñu ra Ndioo chi ra Jesuu, vati nu cuahan quivi cua ndehe ra yoso cuhva cha iyo ñivi cuenda ra. Ndihi ñivi chihi ta ndihi ñivi iyo ndito―cua queta ñi iti nuun ra. ");
INSERT INTO mioNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tuhun maan ra Jesuu ni cati tuhun ndihi ra ni cahan cuenda ra Ndioo nu ni quichi quivi, ta cati tuhun ra ta ra ti maan ra cua sanaan cuati ndacu ndihi ñivi, tu cua cuinu ini ñi chi ra, vati iyo tu ndee ini chi ra ―cati ra Pedro chi ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ni vii cati tuhun ra Pedro tuhun can chi ñivi iyo cuiti vehe ra Cornelio, ta sa quihvi ra Tati Ndioo anima ndihi ñivi tasoho tuhun cati tuhun ra Pedro can. ");
INSERT INTO mioNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tacan cuu, ta iyo xaan iyo xaan cuni ra quichi chi ra Pedro. Cha chinu tahan ini ra chi ra Jesuu nu quichi quivi, soco ra judío cuu ra. Chacan cuu cha iyo xaan cuni ra, vati chaha ra Ndioo ti quichi tahan ra Tati Ndioo coo ra chi ñi, ta ñavi ñivi judío cuu ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Chito ra ta ra cha quichi tahan ra Tati Ndioo anima ñi, vati chini ra ti cahan ñi tuhun cahan inga tucu ñivi, ta cati ñi ti cahnu xaan cuu ra Ndioo. ");
INSERT INTO mioNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tacan cuu, ta cati ndico ra Pedro chi ra quichi chi ra ti: ―Cha quichi tahan ra Tati Ndioo chi ñivi ya cuhva ni quichi ra chi maan yo. Chacan cuu cha yoni cua cati ti ña cua cuu cuanduta ñi ―cati ra. ");
INSERT INTO mioNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tacan cuu, ta cati tuhun ra Pedro ti cua cuanduta ñi cuenda ra Jesucristo. Tacan cuu, ta chica ñi tu manini chi ra Pedro ti cua ndoo nuun ra suhva quivi. ");
INSERT INTO mioNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ni queta tuhun nuun iyo ra tatun Jesuu chi ndihi ñivi Ndioo iyo ñuhun Judea ti tuhun Ndioo chinu tahan ini ñivi cuu inga tucu ñivi. ");
INSERT INTO mioNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Cuahan ndico ra Pedro iti ñuun Jerusalén, ta queta ra nu iyo ñivi Ndioo tican, ta quechaha cahan yuhu ñi chi ra, vati ni sacahnu tahan ñi costumbre judío, vati ñivi judío cuu ñi nu quichi quivi. ");
INSERT INTO mioNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Cati ñi chi ra ti: ―Ña vaha savahun, vati quihvi cun tichi vehe ñivi cuu inga tucu ñivi, ta chachi cun chi ñi icaa ni ―cati ñi. ");
INSERT INTO mioNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tacan cuu, ta chaha ra Pedro cuenda ndihi cha ni chacoo. Quechaha cati ra chi ñi ti: ");
INSERT INTO mioNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Ni iye ñuun Jope, ta quechaha cahin chi ra Ndioo, ta quechaha ndehi ñumahna. Ndehi iin cha cuu sava ta cua iin sunduhu cahnu, ta quichi nuun chi iti siqui andivi, ta queta chi nu iye. Nuhni ndihi cumi punta chi. ");
INSERT INTO mioNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Saha vahi cuenda, vati ndehe xain tichi chi, t