﻿USE sofia;
DROP TABLE IF EXISTS sofia.mim_vpl;
CREATE TABLE mim_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mim_vpl WRITE;
INSERT INTO mim_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yóꞌo va̱xi ki̱vi̱ naxi̱i̱ síkuá Jesucristo; ta̱yóꞌo kúu ra sa̱ꞌya ñani síkuá ta̱rey David, ta̱yóꞌo kúu sa̱ꞌya ñani síkuá ta̱Abraham na xi̱ndo̱o xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ta̱Abraham xi̱kuu yivá ta̱Isaac; ta̱Isaac xi̱kuu yivá ta̱Jacob; ta̱Jacob xi̱kuu yivá ta̱Judá xíꞌin inka̱ nañani ra. ");
INSERT INTO mim_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ta̱Judá xi̱kuu yivá ta̱Fares xíꞌin ta̱Zara, ta siꞌí o̱vi̱ ta̱yóꞌo xi̱naní ñá Tamar. Ta̱Fares xi̱kuu yivá ta̱Esrom; ta̱Esrom xi̱kuu yivá ta̱Aram. ");
INSERT INTO mim_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ta̱Aram xi̱kuu yivá ta̱Aminadab; ta̱Aminadab xi̱kuu yivá ta̱Naasón; ta̱Naasón xi̱kuu yivá ta̱Salmón. ");
INSERT INTO mim_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ta̱Salmón xi̱kuu yivá ta̱Booz, siꞌí ta̱Booz xi̱naní ñá Rahab. Ta̱Booz xi̱kuu yivá ta̱Obed, siꞌí ta̱Obed xi̱naní ñá Rut. Ta̱Obed xi̱kuu yivá ta̱Isaí. ");
INSERT INTO mim_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ta̱Isaí xi̱kuu yivá ta̱rey David ta ta̱yóꞌo xa̱ꞌnda chiño no̱o̱ naIsrael, ta ta̱rey David xi̱kuu yivá ta̱Salomón. Ta siꞌí ta̱Salomón xi̱kuu ñá na̱kiꞌin ta̱David tá ni̱xiꞌi̱ yii̱ ñá ta̱no̱ó, ta̱ xi̱naní Urías. ");
INSERT INTO mim_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ta̱Salomón xi̱kuu yivá ta̱Roboam; ta̱Roboam xi̱kuu yivá ta̱Abías; ta̱Abías xi̱kuu yivá ta̱Asa. ");
INSERT INTO mim_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ta̱Asa xi̱kuu yivá ta̱Josafat; ta̱Josafat xi̱kuu yivá ta̱Joram; ta̱Joram xi̱kuu yivá ta̱Uzías. ");
INSERT INTO mim_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ta̱Uzías xi̱kuu yivá ta̱Jotam; ta̱Jotam xi̱kuu yivá ta̱Acaz; ta̱Acaz xi̱kuu yivá ta̱Ezequías. ");
INSERT INTO mim_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ta̱Ezequías xi̱kuu yivá ta̱Manasés; ta̱Manasés xi̱kuu yivá ta̱Amón; ta̱Amón xi̱kuu yivá ta̱Josías. ");
INSERT INTO mim_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ta̱Josías xi̱kuu yivá ta̱Jeconías xíꞌin inka̱ ñani ra. Xi̱ndo̱o nayóꞌo ñoo Israel ta ki̱vi̱ saá ki̱xaa̱ nañoo Babilonia ta ki̱xáꞌá na káni táꞌan na xíꞌin naIsrael, ta ku̱ndeé naBabilonia no̱o̱ nayóꞌo. Ta saá ti̱in na naIsrael kua̱ꞌa̱n na xíꞌin na ñoo Babilonia. ");
INSERT INTO mim_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ta saá ta̱Jeconías xi̱kuu yivá ta̱Salatiel; ta̱Salatiel xi̱kuu yivá ta̱Zorobabel. ");
INSERT INTO mim_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ta̱Zorobabel xi̱kuu yivá ta̱Abiud; ta̱Abiud xi̱kuu yivá ta̱Eliaquim; ta̱Eliaquim xi̱kuu yivá ta̱Azor. ");
INSERT INTO mim_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ta̱Azor xi̱kuu yivá ta̱Sadoc; ta̱Sadoc xi̱kuu yivá ta̱Aquim; ta̱Aquim xi̱kuu yivá ta̱Eliud. ");
INSERT INTO mim_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ta̱Eliud xi̱kuu yivá ta̱Eleazar; ta̱Eleazar xi̱kuu yivá ta̱Matán; ta̱Matán xi̱kuu yivá ta̱Jacob. ");
INSERT INTO mim_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ta̱Jacob xi̱kuu yivá ta̱José, ta ta̱José xi̱kuu yii̱ ñáMaría, ta ñáyóꞌo xi̱kuu siꞌí ta̱Jesús, ta̱ kúu Cristo. ");
INSERT INTO mim_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ta saá ni̱yaꞌa u̱xu̱ ko̱mi̱ naveꞌe ra, na xi̱kuu xi̱i̱ síkuá Jesucristo ña ki̱xáꞌá nda̱ kui̱ya̱ xi̱taku̱ ta̱Abraham ta̱nda̱ kui̱ya̱ xi̱taku̱ ta̱David. Ta tuku ni̱yaꞌa u̱xu̱ ko̱mi̱ naveꞌe ra, ña ki̱xáꞌá nda̱ kui̱ya̱ xi̱taku̱ ta̱David ta̱nda̱ kui̱ya̱ nañoo Babilonia ti̱in na naIsrael kua̱ꞌa̱n na ñoo Babilonia. Ta ni̱yaꞌa inka̱ u̱xu̱ ko̱mi̱ naveꞌe ra, ña ki̱xáꞌá nda̱ kui̱ya̱ ke̱e nañoo Israel ni̱xa̱ꞌa̱n na ñoo Babilonia ta̱nda̱ kui̱ya̱ ka̱ku Jesucristo. ");
INSERT INTO mim_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ki̱vi̱ ka̱ku Jesucristo siꞌa ni̱xi̱yo. ÑáMaría ñá kuu siꞌí ra, ni̱xi̱yo ini ñá tonda̱ꞌa̱ ñá xíꞌin ta̱José. Ta ta̱yóꞌo, ta̱ꞌán ka̱ tonda̱ꞌa̱ ra xíꞌin ñá, ta ku̱nda̱a̱ ini ra ñóꞌo sa̱ꞌya ñá, ta o̱n si̱ví sa̱ꞌya ta̱José kía̱, chi ña ñóꞌo kúu ña sa̱ꞌya Níma̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ta ta̱José, ta̱ kóni kuu yii̱ ñáMaría, ñii ta̱a va̱ꞌa ní ini kúu ra, ta ni̱‑xiin ra ndato̱ꞌon ra xíꞌin ni̱vi ña ñóꞌo sa̱ꞌya ñáMaría ta sakukaꞌan ra no̱o̱ ñá. Ta saá chi̱kaa̱ ini ra sandakoo seꞌé ra ñá, ña o̱n koni ndiꞌi ni̱vi ñayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tá xáni si̱ni̱ ra sandakoo ra ñá, ta ñoó ni̱ki̱si̱n ta̱José ta ni̱xa̱ní ra ñii ñaángel ke̱e no̱o̱ Ndios ki̱xi ña no̱o̱ ra, ta káchí ña saá xíꞌin ra: ―Tata José, sa̱ꞌya ñani síkuá ta̱rey David kúu ún, o̱n kuyi̱ꞌví ini ún nakiꞌin ún ñáMaría koo ñá xíꞌin ún, chi sa̱ꞌya ñá ña kaku, sa̱ꞌya Níma̱ Ndios kúu ña. ");
INSERT INTO mim_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tá kaku ta̱a sa̱ꞌya ñá, ta chinóo ún ki̱vi̱ ra kunaní ra Jesús. Saá kunaní ra, chi ta̱ saka̱ku nani̱vi xa̱ꞌa̱ kua̱chi na kuu ra ―káchí ñaángel xíꞌin ta̱José. ");
INSERT INTO mim_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ta ndiꞌi ñayóꞌo ni̱xi̱yo, chi saá xíni̱ ñóꞌó kundivi ña ni̱ka̱ꞌa̱n Ndios xíꞌin ta̱profeta xi̱na̱ꞌá, chi ta̱profeta ni̱taa ra siꞌa: ");
INSERT INTO mim_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ñáñaꞌa̱ loꞌo, ñá yi̱i̱ ñá ta̱ꞌán to̱nda̱a ta̱a, ta ke̱e sa̱ꞌya ñá, ta sakaku ñá ñii ta̱a loꞌo, ta kunaní ra Emanuel, káchí to̱ꞌon Ndios ña ni̱taa ta̱profeta xi̱na̱ꞌá. Ta ki̱vi̱ “Emanuel” kóni kachí ña saá: Ndios yóo ra xíꞌin yó. ");
INSERT INTO mim_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ta saá na̱káxín ini ta̱José, ta nda̱koo ra, ta ki̱sa ndivi ra tá yóo ndiꞌi ña ni̱ka̱ꞌa̱n ñaángel xíꞌin ra, ta na̱kiꞌin va̱ꞌa ra ñáMaría ndu̱u ñá ñásíꞌí ra. ");
INSERT INTO mim_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ta ta̱José xíꞌin ñáMaría o̱n vása ní‑kisi̱n xíꞌin táꞌan na a̱nda̱ ki̱vi̱ ka̱ku sa̱ꞌya ñá, ta saá ta̱José chi̱nóo ra ki̱vi̱ ta̱loꞌo ka̱ku yóꞌo kunaní ra Jesús. ");
INSERT INTO mim_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ta̱Jesús ka̱ku ra ñoo Belén ña ndáꞌvi ndaa estado Judea, ta ta̱Herodes xi̱kuu rey ñoo estado Judea. Ta saá ki̱xaa̱ nandíchí na nákoni ki̱mi ñoo Jerusalén; nayóꞌo ki̱xi na chí no̱o̱ va̱xi kana ño̱ꞌo. ");
INSERT INTO mim_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ta saá ki̱xáꞌá na ndáka̱ to̱ꞌon na nañoo Jerusalén, káchí na siꞌa: ―¿Míkía̱ ka̱ku ta̱loꞌo ta̱ kuu rey no̱o̱ ndóꞌó najudío? Chí no̱o̱ va̱xi kana ño̱ꞌo xi̱ni ndi̱ ñii ki̱mi, ta saá ku̱nda̱a̱ ini ndi̱ xa ka̱ku ra, ta vitin va̱xi ndi̱ yóꞌo ña kasa to̱ꞌó ndi̱ ra ―káchí nandíchí. ");
INSERT INTO mim_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ki̱vi̱ xi̱ni̱ so̱ꞌo ta̱rey Herodes to̱ꞌon ña ni̱ka̱ꞌa̱n nandíchí yóꞌo, ta ni̱ndiꞌi ní ini ra. Ta ñii ki̱ꞌva saá ni̱ndiꞌi ini nañoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ta saá ta̱rey Herodes ka̱na ndiꞌi ra nanáꞌno no̱o̱ nasu̱tu̱, ta ka̱na ra ndiꞌi na sánáꞌa nda̱yí Ndios, ta ki̱xaa̱ ndiꞌi nayóꞌo no̱o̱ ra. Ta ni̱nda̱ka̱ to̱ꞌon ra nayóꞌo, míkía̱ kaku Cristo. ");
INSERT INTO mim_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ta nayóꞌo nda̱kuii̱n na, káchí na saá: ―Ñoo Belén ña ndáꞌvi ndaa estado Judea yóꞌo kaku ra, chi saá káchí to̱ꞌon Ndios ña ni̱taa ta̱profeta xi̱na̱ꞌá, káchí ña saá: ");
INSERT INTO mim_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ñoo Belén, ña ndáꞌvi ndaa estado Judea, kúu ña ñii ñoo ña ndáya̱ꞌví ní ka̱ no̱o̱ ndiꞌi ñoo; chi nda̱ ñoo yóꞌo kixi ta̱ kuiso chiño, ta kundaa ra nañoo Israel, káchí to̱ꞌon Ndios ña ni̱taa ta̱profeta ―káchí na ndíso chiño no̱o̱ nañoo judío xíꞌin ta̱rey Herodes. ");
INSERT INTO mim_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ta saá ta̱Herodes ka̱na seꞌé ra nandíchí na nákoni ki̱mi, ta nayóꞌo ki̱xaa̱ na no̱o̱ ra, ta ni̱nda̱ka̱ to̱ꞌon ra na, ndá ki̱vi̱ kúu ña ni̱ti̱vi na̱yeꞌe ki̱mi xi̱ni na. Ta saá nda̱to̱ꞌon na xíꞌin ra, ta ku̱nda̱a̱ ini ra. ");
INSERT INTO mim_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ta ti̱ꞌví ra na kua̱ꞌa̱n na ñoo Belén, ta ni̱ka̱ꞌa̱n ra siꞌa xíꞌin na: ―Kua̱ꞌa̱n ndó ñoo Belén, ta nandukú ndó míchí yóo ta̱loꞌo. Tá xi̱ni ndó ra, ta saá ndikó tuku ndó yóꞌo ta ndato̱ꞌon ndó xíꞌin i̱, ta saá yi̱ꞌi̱ ko̱ꞌo̱n i̱ kasa to̱ꞌó i̱ ra ―káchí ta̱Herodes xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ta ki̱vi̱ ndi̱ꞌi xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱rey, ta saá ke̱e na kua̱ꞌa̱n na. Ta ki̱mi tí xi̱ni na, kua̱ꞌa̱n siꞌna rí no̱o̱ na, ta ni̱xaa̱ rí ta xi̱kanóo rí no̱o̱ kándúꞌu̱ ta̱loꞌo. ");
INSERT INTO mim_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tá xi̱ni na xi̱kanóo tíki̱mi yóꞌo, ta saá ku̱sii̱ ní ini na. ");
INSERT INTO mim_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ta ni̱ki̱ꞌvi na ini veꞌe, ta xi̱ni na ta̱loꞌo xíꞌin siꞌí ra ñáMaría. Ta saá xi̱kuxítí na no̱o̱ ta̱loꞌo, ta ki̱sa to̱ꞌó na ra. Ta na̱kuiná na xa̱to̱n válí na, ta sa̱níꞌi na ra ñaoro, xíꞌin xuxa va̱ꞌa ña yáꞌví ní, xíꞌin nduta̱ va̱ꞌa tá támi xáꞌan na̱ní rá mirra. ");
INSERT INTO mim_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ta Ndios ti̱ꞌví ra xa̱ni no̱o̱ nandíchí yóꞌo, ta saá ku̱nda̱a̱ ini na ña o̱n ndikó na ñoo no̱o̱ yóo ta̱rey Herodes. Ta saá ndi̱kó na kua̱noꞌo̱ na inka̱ yichi̱, ta o̱n vása ní‑ndikó ka̱ na yichi̱ no̱o̱ ki̱xi na. ");
INSERT INTO mim_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tá ke̱e nandíchí na nákoni ki̱mi kua̱noꞌo̱ na, ta ñoó ni̱ki̱si̱n ta̱José ta ni̱xa̱ní ra ñii ñaángel ke̱e no̱o̱ Ndios ki̱xi ña no̱o̱ ra, ta káchí ña saá xíꞌin ra: ―Ndakoo ún, ta nakiꞌin ún tikuáꞌá loꞌo xíꞌin siꞌí ra, ta kama kee ndó ko̱ꞌo̱n ndó a̱nda̱ ñoo Egipto, ta kán kundo̱o ndó a̱nda̱ ki̱vi̱ ka̱ꞌa̱n i̱ xíꞌin ún, saá ndikó ndó. Chi ta̱rey Herodes nandukú ra tikuáꞌá loꞌo, chi kóni ra kaꞌni ñaꞌá ra ―káchí ñaángel xíꞌin ta̱José. ");
INSERT INTO mim_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ta xa̱ndi̱ko̱n ñoó saá ta̱José xíꞌin ñáMaría nda̱koo na, ta na̱kiꞌin na tikuáꞌá loꞌo, ta ke̱e na kua̱ꞌa̱n na a̱nda̱ ñoo Egipto. ");
INSERT INTO mim_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ta ñoo yóꞌo ni̱xi̱yo na a̱nda̱ kui̱ya̱ ni̱xiꞌi̱ ta̱rey Herodes. Saá ku̱ndivi to̱ꞌon Ndios ña ni̱taa ta̱profeta xi̱na̱ꞌá, káchí ña saá: “Ka̱na i̱ sa̱ꞌya i̱ va̱xi ra ña kee ra ñoo Egipto, ta noꞌo̱ ra ñoo ra”, káchí to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tá ta̱rey Herodes ku̱nda̱a̱ ini ra nandíchí na nákoni ki̱mi sa̱ndáꞌví na ra, ta ni̱saa̱ ní ra. Ta saá na̱káꞌán ra ña nda̱to̱ꞌon na xíꞌin ra ama ka̱ku ta̱loꞌo. Ta saá xa̱ꞌnda chiño ra no̱o̱ natropa ña kaꞌni ndiꞌi na nata̱a válí na o̱vi̱ kui̱ya̱ ta chí ni̱no̱ na ndóo ñoo Belén xíꞌin inka̱ na ñoo yatin. Ta saá kua̱ꞌa̱ ní naválí ni̱xiꞌi̱, ki̱sa natropa. ");
INSERT INTO mim_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ta saá ku̱ndivi ña ni̱taa ta̱profeta Jeremías, ka̱chí ra saá: ");
INSERT INTO mim_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Xi̱ni̱ so̱ꞌo na xáku ní ñaꞌa̱ ñoo Ramá, ndeé ní xáku ñá, ta kúchuchú ní ini ñá; ñáRaquel kúu ñá, xáku ní ñá xa̱ꞌa̱ sa̱ꞌya ñá, ta o̱n vása xi̱in ñá kindo̱o ini ñá ña kua̱ꞌa̱ ní nata̱a válí ni̱xiꞌi̱, káchí to̱ꞌon Ndios, ña ni̱taa ta̱Jeremías xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ta ni̱xiꞌi̱ ta̱rey Herodes, ta ta̱José yóo ra ñoo Egipto, ta ñoó ni̱ki̱si̱n ra ta ni̱xa̱ní ra ñii ñaángel ke̱e no̱o̱ Ndios ki̱xi ña no̱o̱ ra, ta nda̱to̱ꞌon ña xíꞌin ra: ");
INSERT INTO mim_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Ndakoo ún, ta nakiꞌin ún tikuáꞌá loꞌo xíꞌin siꞌí ra, ta noꞌo̱ ndó ñoo Israel, chi xa ni̱xiꞌi̱ na kóni kaꞌni tikuáꞌá loꞌo ―káchí ñaángel xíꞌin ra, ti̱xin xa̱ni ki̱xi no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ta saá nda̱koo ta̱José xíꞌin ñáMaría, ta na̱kiꞌin na tikuáꞌá loꞌo, ta kua̱noꞌo̱ na ñoo Israel. ");
INSERT INTO mim_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ta ki̱vi̱ xi̱ni̱ so̱ꞌo ta̱José to̱ꞌon ta̱Arquelao sa̱ꞌya ta̱Herodes kúu ta̱ na̱kuiso chiño no̱o̱ estado Judea, ta ni̱yi̱ꞌví ní ra ko̱ꞌo̱n ra ñoo yóꞌo. Ta tuku ni̱xa̱ní ra ñii ñaángel ni̱ka̱ꞌa̱n ña xíꞌin ra, ña o̱n ko̱ꞌo̱n ka̱ ra estado Judea, ta saá ki̱ꞌin ra kua̱ꞌa̱n ra inka̱ yichi̱ ña kua̱ꞌa̱n estado Galilea. ");
INSERT INTO mim_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ta ni̱xaa̱ ra estado yóꞌo, ta na̱kani ini ra va̱ꞌa ka̱ ko̱ꞌo̱n ra koo ra ñoo Nazaret, ñii ñoo ndíko̱n ndaa estado Galilea. Ta saá ku̱ndivi to̱ꞌon ni̱ka̱ꞌa̱n naprofeta, ka̱chí na saá xa̱ꞌa̱ ta̱ tiꞌví Ndios saka̱ku ra na ñoyívi: “Ñii ta̱ñoo Nazaret kuu ra”, káchí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ta saá ni̱yaꞌa kua̱ꞌa̱ ní kui̱ya̱, ta ki̱xaa̱ ta̱Juan ta̱ sákuchu ni̱vi, ni̱xaa̱ ra no̱o̱ yóo yuku̱ yi̱chí estado Judea. Ta ni̱xaa̱ kua̱ꞌa̱ ní ni̱vi xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ndoso ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","To̱ꞌon yóꞌo kúu ña ni̱ka̱ꞌa̱n ra xíꞌin na: ―O̱n vása keꞌé ka̱ ndó ña o̱n váꞌa, ta nandikó ini ndó xa̱ꞌa̱ ña o̱n váꞌa ke̱ꞌé ndó, chi xa yóo yatin ní yichi̱ ña xáꞌnda chiño Ndios kutaku̱ yó ―káchí ta̱Juan xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Xa̱ꞌa̱ ta̱Juan yóꞌo ni̱taa ta̱profeta Isaías xi̱na̱ꞌá, ka̱chí ra saá: Ta no̱o̱ yóo yuku̱ yi̱chí ko̱ꞌo̱n ra ka̱ꞌa̱n ndoso ra, kachí ra saá: “Ná koo tiꞌva ini ndó, saá chi ya̱chi̱ kixaa̱ mi̱i ta̱Káꞌno no̱o̱ yó; kindaa ndó ña o̱n váꞌa sási no̱o̱ ndó, ta saá va̱ꞌa kuchiño nakiꞌin ndó ra”, kachí ta̱a ta̱ koo yuku̱ yi̱chí, saá káchí to̱ꞌon Ndios ña ni̱taa ta̱Isaías xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tiko̱to̱ ta̱Juan ku̱va̱ꞌa ña xíꞌin yisi̱ tícamello, ta nóꞌni ñii ñáꞌño ñii̱ kiti̱ to̱ko̱ ra. Ta xíxi ra ti̱ka ndíama xíꞌin ño̱ño̱ tíyóko̱ válí yóo yuku̱. ");
INSERT INTO mim_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ta ni̱vi nañoo Jerusalén, xíꞌin na ndóo ndiꞌi saá kua̱ꞌa̱ ka̱ ñoo ña ndáꞌvi ndaa estado Judea, xíꞌin na ndóo yatin yuꞌu̱ yu̱ta Jordán va̱xi na, ta ki̱xaa̱ na ña koni̱ so̱ꞌo na to̱ꞌon ña káꞌa̱n ndoso ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ta saá xi̱ni̱ so̱ꞌo na, ta ki̱xáꞌá na náꞌma na xa̱ꞌa̱ kua̱chi na. Ta ta̱Juan sa̱kuchu ra nayóꞌo yu̱ta Jordán. ");
INSERT INTO mim_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ta ta̱Juan xi̱ni ra va̱xi kua̱ꞌa̱ ní nanáꞌno no̱o̱ najudío, na kúu nafariseo xíꞌin nasaduceo, chi kóni na kuchu na, kasa ta̱Juan. Ta ta̱Juan ni̱ka̱ꞌa̱n ra to̱ꞌon yóꞌo xíꞌin na: ―Ta ndóꞌó, ¡sa̱ꞌya ko̱o̱ xati̱ kúu ndó! ¿Yu kúu na ni̱ka̱ꞌa̱n xíꞌin ndó kuchu ndó, ta saá saka̱ku xíꞌin mi̱i ndó ña o̱n saxo̱ꞌvi̱ Ndios ndóꞌó ki̱vi̱ ña va̱xi? ");
INSERT INTO mim_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tá ndixa na̱ndikó ini ndó ta kóni ndó ko̱ꞌo̱n ndó yichi̱ Ndios, ta xíni̱ ñóꞌó kasa ndivi ndó chiño ña va̱ꞌa nda̱tán kóni Ndios. ");
INSERT INTO mim_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Saá chi o̱n váꞌa kani si̱ni̱ ndó ndí xa̱ꞌa̱ ña kúu ndó sa̱ꞌya ñani síkuá ta̱Abraham, Ndios saka̱ku ra ndóꞌó. Ta káꞌa̱n i̱ xíꞌin ndó, Ndios kúchiño ra ndasa ra yu̱u̱ yóꞌo ni̱vi na kuu sa̱ꞌya ñani síkuá ta̱Abraham. ");
INSERT INTO mim_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ta ni̱vi na o̱n vása kísa ndivi ña kóni Ndios, nda̱tán yóo yito̱n tón kóon kui̱ꞌi o̱n váꞌa ndaꞌa̱, saá yóo na no̱o̱ Ndios. Ta Ndios xa yóo tiꞌva ra xíꞌin yáchá si̱i̱n ña kaꞌnda ra ndiꞌi yito̱n tón o̱n vása kóon kui̱ꞌi va̱ꞌa ndaꞌa̱, ta kaꞌnda ra nó, ta taan ra nó ko̱ko̱ nó no̱o̱ xíxi̱ ñoꞌo̱. ");
INSERT INTO mim_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ta yi̱ꞌi̱, sákuchu i̱ ndóꞌó xíꞌin takuií, ña kunda̱a̱ ini ni̱vi ña ndixa na̱ndikó ini ndó. Ta ta̱a ta̱ va̱xi sa̱ta̱ i̱ kúu ta̱ ndeé ka̱ no̱o̱ yi̱ꞌi̱. Ta yi̱ꞌi̱ kúu ñii ta̱ kísa chiño kuiti no̱o̱ ra. Ta ta̱yóꞌo sakuchu ra ndóꞌó xíꞌin mi̱i Níma̱ Ndios, ña yóo nda̱tán yóo ñoꞌo̱ xíxi̱. ");
INSERT INTO mim_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Xa yóo tiꞌva ra kasa nani ra xa̱ꞌa̱ kua̱chi ni̱vi, ta keꞌé ra xíꞌin ni̱vi nda̱tán kéꞌé ni̱vi xíꞌin ndiki̱n trigo ña xa̱ꞌnda na ta sa̱xixin na ña. Saá chi ta̱yóꞌo nataꞌví ra ni̱vi na va̱ꞌa no̱o̱ na o̱n váꞌa. Ta taxi va̱ꞌa ra ni̱vi na va̱ꞌa ña kundo̱o na veꞌe ra, ta taan ra ni̱vi na o̱n váꞌa no̱o̱ xíxi̱ ñoꞌo̱, ta nda̱ ñii ki̱vi̱ o̱n nda̱ꞌva̱ ña ―káchí ta̱Juan xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ta saá ke̱e ta̱Jesús estado Galilea, ta ki̱xaa̱ ra no̱o̱ yóo ta̱Juan yuꞌu̱ yu̱ta Jordán, ta ta̱Jesús ndu̱kú ra no̱o̱ ta̱Juan ña sakuchu ñaꞌá ra. ");
INSERT INTO mim_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ta ta̱Juan ni̱‑xiin ra sakuchu ra ta̱Jesús, káchí ra saá xíꞌin ra: ―O̱n vása xíni̱ ñóꞌó sakuchu i̱ yóꞌó. Yóꞌó kúu ta̱ xíni̱ ñóꞌó sakuchu ún yi̱ꞌi̱ va ―káchí ta̱Juan xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―Va̱ꞌa ka̱ sakuchu ún yi̱ꞌi̱ vitin, saá chi xíni̱ ñóꞌó kasa ndivi yó ndiꞌi ña xáꞌnda chiño Ndios ―káchí ta̱Jesús. Ta saá ni̱noo ini ta̱Juan, ta sa̱kuchu ra ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tá ndi̱ꞌi sa̱kuchu ñaꞌá ra, ta ta̱Jesús ke̱ta ra yuꞌu̱ yu̱ta. Ta ni̱xo̱na̱ ñoyívi ni̱no no̱o̱ ra, ta xi̱ni ra va̱xi noo Níma̱ Ndios, nda̱tán va̱xi noo ñii tísa̱ta, saá va̱xi noo ña, ta xi̱kanóo ña no̱o̱ ñíndichi ra. ");
INSERT INTO mim_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ta ni̱vi na ndóo yuꞌu̱ yu̱ta xi̱ni̱ so̱ꞌo na to̱ꞌon Ndios ni̱ka̱ꞌa̱n ra nda̱ ñoyívi ni̱no, káchí ra saá: ―Ta̱yóꞌo kúu Sa̱ꞌya i̱, ta̱ kíꞌvi ní ini i̱ xíni i̱, ta kúsii̱ ní ini i̱ xíni i̱ ra ―káchí Ndios xa̱ꞌa̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ta saá Níma̱ Ndios ni̱ka̱ꞌa̱n ña xíꞌin ta̱Jesús ko̱ꞌo̱n ra yuku̱ yi̱chí, chi ñaníma̱ ndiva̱ꞌa káꞌno koto ndoso ña ra, chi kóni ña sandáꞌví ña ra. ");
INSERT INTO mim_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ta nda̱ loꞌo o̱n vása ní‑xixi ta̱Jesús, chi ni̱xi̱yo soꞌon ra o̱vi̱ si̱ko̱ ndiví xíꞌin o̱vi̱ si̱ko̱ ñoó, ta saá xíꞌi̱ ní ra so̱ko. ");
INSERT INTO mim_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ta ki̱xaa̱ ñandiva̱ꞌa káꞌno no̱o̱ ta̱Jesús ña koto ndoso ña ra, ta ni̱ka̱ꞌa̱n ña xíꞌin ra to̱ꞌon yóꞌo, káchí ña saá: ―Tá ndixa Sa̱ꞌya Ndios kúu ún, ta va̱ꞌa kaꞌnda chiño ún no̱o̱ yu̱u̱ ña ndóo yóꞌo ná nduu ña si̱ta̱ va̱ꞌa ―káchí ña xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin ñaníma̱ ndiva̱ꞌa: ―To̱ꞌon Ndios káchí ña saá: “O̱n si̱ví nina ña xíxi ni̱vi kúu ña xíni̱ ñóꞌó ña kutaku̱ na. Ta xíni̱ ñóꞌó kandixa va̱ꞌa na to̱ꞌon Ndios, ta saá kutaku̱ na”, káchí to̱ꞌon Ndios ―káchí ta̱Jesús xíꞌin ñaníma̱ ndiva̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ta saá ñaníma̱ ndiva̱ꞌa káꞌno ni̱ka̱ꞌa̱n ña xíꞌin ta̱Jesús ko̱ꞌo̱n ra xíꞌin ña, ta ni̱xaa̱ na yíta na si̱ni̱ torre veꞌe ño̱ꞌo káꞌno ñoo Jerusalén, ");
INSERT INTO mim_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ta ni̱ka̱ꞌa̱n ña xíꞌin ra, káchí ña saá: ―Tá ndixa Sa̱ꞌya Ndios kúu ún, ta sakana xíꞌin mi̱i ún nda̱ ni̱no̱, chi saá káchí to̱ꞌon Ndios: Ndios tiꞌví ra ángel ña chindeé na yóꞌó, ta kundaa va̱ꞌa na yóꞌó. Ta naángel natiin na yóꞌó kanóo ún no̱o̱ ndaꞌa̱ na, ko̱to̱ nakava ún no̱o̱ yu̱u̱, ta takuéꞌe̱ ún, káchí to̱ꞌon Ndios ―saá káchí ñandiva̱ꞌa xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ta nda̱kuii̱n ta̱Jesús: ―Saá tuku káchí to̱ꞌon Ndios: “O̱n váꞌa koto ndoso yó Ndios” ―káchí ta̱Jesús xíꞌin ñaníma̱ ndiva̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ta sondi̱ꞌi ñandiva̱ꞌa káꞌno ni̱ka̱ꞌa̱n tuku ña xíꞌin ta̱Jesús ko̱ꞌo̱n ra xíꞌin ña, ta saá nda̱a na ñii yuku̱ síkón ní, ta ñandiva̱ꞌa sa̱náꞌa ña ra ndiꞌi ñoo ña yóo ñoyívi yóꞌo xíꞌin ndiꞌi ñakuíká ñoyívi. ");
INSERT INTO mim_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ta saá ni̱ka̱ꞌa̱n ñandiva̱ꞌa xíꞌin ra, káchí ña: ―Tá kuxítí ún no̱o̱ i̱ ta kasa to̱ꞌó ún yi̱ꞌi̱, ta saá taxi i̱ nda̱yí ndaꞌa̱ ún kuu ún ta̱káꞌno no̱o̱ ndiꞌi ñoyívi yóꞌo xíꞌin ndiꞌi ñakuíká kómí ña ―káchí ñandiva̱ꞌa xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ña: ―¡Kutaꞌa ún no̱o̱ i̱, yóꞌó, ñaníma̱ ndiva̱ꞌa káꞌno Satanás!, chi káchí to̱ꞌon Ndios saá: “Ndasaá kuiti Ndios kasa to̱ꞌó yó, ta kasa ndivi yó xíꞌin ra, ta o̱n kasa to̱ꞌó yó, ni o̱n kasa ndivi yó xíꞌin inka̱ na”, káchí to̱ꞌon Ndios ―saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ñaníma̱ ndiva̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ta saá ñandiva̱ꞌa sa̱ndakoo ña ra, ta ke̱e ña kua̱ꞌa̱n ña, ta saá ki̱xaa̱ naángel chindeé na ta̱Jesús, ta̱xi na ndiꞌi ña xíni̱ ñóꞌó no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ki̱vi̱ xi̱ni̱ so̱ꞌo ta̱Jesús xa̱ꞌa̱ ña chi̱kaa̱ na ta̱Juan ini veꞌe ka̱a, ta ndi̱kó ta̱Jesús kua̱noꞌo̱ ra estado Galilea. ");
INSERT INTO mim_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ta ni̱xaa̱ ra ñoo Nazaret, ta ke̱e tuku ra kua̱ꞌa̱n ra koo ra ñoo Capernaum, ña nákaa̱ yatin yuꞌu̱ mi̱ni, no̱o̱ yóo yatin ñoo no̱o̱ ndóo sa̱ꞌya ñani síkuá ta̱Zabulón xíꞌin inka̱ ta̱Neftalí. ");
INSERT INTO mim_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ta saá ku̱ndivi ña ni̱ka̱ꞌa̱n ta̱profeta Isaías kui̱ya̱ xi̱na̱ꞌá, ta ka̱chí ra saá: ");
INSERT INTO mim_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ñoo no̱o̱ ndóo sa̱ꞌya ñani síkuá ta̱Zabulón xíꞌin inka̱ ta̱Neftalí, nákaa̱ ña yatin yuꞌu̱ mi̱ni, inka̱ yuꞌu̱ yu̱ta Jordán. Ta estado Galilea, ta kán ndóo sava ni̱vi na o̱n vása kúu najudío, ni o̱n vása ndíko̱n na yichi̱ najudío. ");
INSERT INTO mim_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nda̱tán ndóo na naa ní ini, án na naa ní no̱o̱, saá ndóo na, chi o̱n vása táku̱ na no̱o̱ Ndios. Ta ñii ki̱vi̱ koni na ñii ñoꞌo̱ káꞌno yéꞌe, ña yeꞌe ña no̱o̱ na ta̱nda̱ níma̱ na, chi Ndios taxi ra ña kunda̱a̱ ini na ñava̱ꞌa ña ná kundiko̱n na yichi̱ ra, ta o̱n ndiꞌi xa̱ꞌa̱ na no̱o̱ ra, káchí to̱ꞌon Ndios ña ni̱taa ta̱Isaías xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ta saá ki̱xáꞌá ta̱Jesús káꞌa̱n ndoso ra to̱ꞌon Ndios xíꞌin ni̱vi, káchí ra saá: ―Ta vitin o̱n vása keꞌé ka̱ ndó ña o̱n váꞌa, ta nandikó ini ndó, chi xa yóo yatin ní yichi̱ ña xáꞌnda chiño Ndios kutaku̱ yó ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tá kua̱ꞌa̱n ta̱Jesús yuꞌu̱ mi̱ni Galilea, ta xi̱ni ra o̱vi̱ ta̱a, ñii ra na̱ní Simón ta inka̱ ki̱vi̱ ra kúu Pedro, ta inka̱ ta̱a na̱ní ra Andrés, ñani ta̱Simón yóꞌo kúu ra. Ta o̱vi̱ ta̱a yóꞌo sákana na ñono̱ ini takuií, chi na táva tia̱ká kúu na. ");
INSERT INTO mim_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Naꞌa ndó kundiko̱n ndó yi̱ꞌi̱, ta sanáꞌa i̱ ndóꞌó ndasaá nakaya ndó ni̱vi kundiko̱n na yichi̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ta xa̱ndi̱ko̱n sa̱ndakoo nata̱a yóꞌo ñono̱ na, ta xi̱kundiko̱n na kua̱ꞌa̱n na sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ta ta̱Jesús kua̱ꞌa̱n ka̱ ra, ta xi̱ni ra inka̱ o̱vi̱ ta̱a, ta̱Jacobo xíꞌin ñani ra ta̱Juan, sa̱ꞌya ta̱Zebedeo. Ndóo na ini tón barco xíꞌin yivá na, sándaꞌa na ñono̱ na. Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―Naꞌa ndó kundiko̱n ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ta xa̱ndi̱ko̱n sa̱ndakoo nata̱a yóꞌo tón barco na, ta sa̱ndakoo na yivá na, ta xi̱kundiko̱n na kua̱ꞌa̱n na sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ta saá xíka ta̱Jesús kua̱ꞌa̱n ra ndiꞌi saá ñoo ndáꞌvi ndaa estado Galilea, ta sánáꞌa ra ni̱vi veꞌe ño̱ꞌo sinagoga, ta káꞌa̱n ndoso ra to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ yichi̱ ña xáꞌnda chiño Ndios, ta saá sándaꞌa ra ni̱vi na ndeé ndóꞌo ndiꞌi saá no̱o̱ kue̱ꞌe̱. ");
INSERT INTO mim_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ta ki̱xáꞌá ni̱xi̱ta̱ níꞌnó to̱ꞌon xa̱ꞌa̱ ta̱Jesús ndiꞌi saá ñoo Siria, ta ni̱vi kua̱ꞌa̱n na xíꞌin na ndeé ndóꞌo ta ni̱xaa̱ na no̱o̱ yóo ra estado Galilea. Ta na ndeé ndóꞌo yóꞌo, sava na kómí níma̱ ndiva̱ꞌa, sava na xíꞌi̱ yi̱ꞌí, sava na o̱n ki̱ví kaka, ta ta̱Jesús sa̱ndaꞌa ra ndiꞌi nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kua̱ꞌa̱ ní ni̱vi na ke̱e estado Galilea, na ke̱e ñii xiiña no̱o̱ na̱ní Decápolis, na ke̱e ñoo Jerusalén, xíꞌin inka̱ kua̱ꞌa̱ ñoo ña ndáꞌvi ndaa estado Judea, ta na ke̱e inka̱ táꞌví yuꞌu̱ yu̱ta Jordán, na̱kutáꞌan na ta kua̱ꞌa̱n na sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ta xi̱ni ta̱Jesús ki̱xaa̱ kua̱ꞌa̱ ní ni̱vi, ta saá nda̱a ra ñii xi̱ki̱, ta xi̱koo ra, ta ki̱xaa̱ naxíka xíꞌin ra yatin no̱o̱ ra ña koni̱ so̱ꞌo na ña ka̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ta ki̱xáꞌá ta̱Jesús sánáꞌa ra na, káchí ra saá xíꞌin na: ");
INSERT INTO mim_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Tá kúu ndó nandáꞌví, na kúnda̱a̱ ini ndí xíni̱ ñóꞌó ndó Ndios, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó, chi kúu ndó ni̱vi na ndíko̱n yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Tá kúchuchú ini ndó nda̱ xáku ndó xa̱ꞌa̱ ñoyívi yóꞌo, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó, chi va̱xi ñii ki̱vi̱ Ndios ndasa va̱ꞌa ra ini ndó. ");
INSERT INTO mim_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Tá na ni̱no̱ ini kúu ndó, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó, chi va̱xi ñii ki̱vi̱ ndiꞌi ñoꞌo̱ ñoyívi yóꞌo kuu ña nakiꞌin ndó, káchí Ndios. ");
INSERT INTO mim_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Tá nándukú ndó Ndios, nda̱tán ni̱vi na xíꞌi̱ ní so̱ko án na yíchi̱ ní takuií nándukú na ña kuxu na, án ña koꞌo na, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó, chi ñii ki̱vi̱ Ndios taxi ra ña kutú ini ndó xíꞌin ñava̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Tá kúndáꞌví ini ndó xíni ndó inka̱ ni̱vi, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó, chi Ndios kundáꞌví ini ra koni ra ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Tá ndinoꞌo ní ini ndó kúu ndó ni̱vi na va̱ꞌa no̱o̱ Ndios, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó, chi va̱xi ñii ki̱vi̱ xíꞌin nduchu̱ no̱o̱ ndó koni ndó Ndios. ");
INSERT INTO mim_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Tá ndóꞌó kúu na kísa chiño káꞌa̱n to̱ꞌon va̱ꞌa xíꞌin ni̱vi ña kundo̱o va̱ꞌa na xíꞌin táꞌan na, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó, chi Ndios nakiꞌin va̱ꞌa ra ndóꞌó chi sa̱ꞌya ra kúu ndó. ");
INSERT INTO mim_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Tá yóo ni̱vi na kéꞌé ñandiva̱ꞌa xíꞌin ndó chi táku̱ ndó nda̱tán kóni Ndios, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó, chi kúu ndó ni̱vi na ndíko̱n yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Tá yóo ni̱vi na kándiva̱ꞌa xíꞌin ndó, ta sáxo̱ꞌvi̱ na ndóꞌó, ta káꞌa̱n na ñavatá xa̱ꞌa̱ ndó chi ndíko̱n ndó yi̱ꞌi̱, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ki̱vi̱ ña ku̱ndeé ndó no̱o̱ ña xóꞌvi̱ ndó, ta ná kusii̱ ní ini ndó, chi káꞌno ní ñava̱ꞌa taxi Ndios ndaꞌa̱ ndó ñoyívi ni̱no. Nani̱vi na xi̱taku̱ xi̱na̱ꞌá sa̱xo̱ꞌvi̱ ní na naprofeta, ta ñii ki̱ꞌva saá ni̱vi saxo̱ꞌvi̱ na ndóꞌó vitin, chi ndíko̱n ndó yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ta tuku káchí ta̱Jesús saá xíꞌin naxíka xíꞌin ra: ―Nda̱tán yóo ñi̱i̱ yo̱ꞌva̱ ña chíkaa̱ yó xíꞌin ña kuxu yó, saá yóo ndóꞌó no̱o̱ nani̱vi ñoyívi yóꞌo. Tá yóo ñi̱i̱ ña o̱n vása yo̱ꞌva̱, ta o̱n kuchiño ka̱ nduva̱ꞌa ña. Ta o̱n vása xíni̱ ñóꞌó ka̱ ñi̱i̱ yóꞌo, ta va̱ꞌa ka̱ ná kui̱ta̱ ña yichi̱ no̱o̱ yaꞌa ni̱vi ta kundo̱so̱ na ña. ");
INSERT INTO mim_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Nda̱tán yóo ñoꞌo̱ ña yéꞌe, saá yóo ndóꞌó no̱o̱ ni̱vi ñoyívi yóꞌo. Ñii ñoo ña yóo si̱ni̱ yuku̱, o̱n si̱ví ña yóo seꞌé kúu ña, ta ndiꞌi ni̱vi kúchiño koni na ña. ");
INSERT INTO mim_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tá ni̱vi nátoo̱n na ñoꞌo̱, ta o̱n vása chíkaa̱ seꞌé na ña, ta chínóo na ña no̱o̱ síkón, ta saá náyeꞌe ña no̱o̱ ndiꞌi ni̱vi na ndóo veꞌe. ");
INSERT INTO mim_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ta saá ndóꞌó, tá kutaku̱ ndó nda̱tán kóni Ndios ta nayeꞌe ndó nda̱tán yóo ñoꞌo̱ yéꞌe ñoyívi yóꞌo, ta saá nani̱vi koni na ñava̱ꞌa keꞌé ndó, ta kasa káꞌno na Yivá yó Ndios, ta̱ yóo ñoyívi ni̱no ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ta tuku káchí ta̱Jesús saá xíꞌin na: ―O̱n kani ini ndó ndí yi̱ꞌi̱ kóni i̱ sandiꞌi i̱ xa̱ꞌa̱ nda̱yí Ndios, ni o̱n kani ini ndó ndí yi̱ꞌi̱ kóni i̱ sandiꞌi i̱ xa̱ꞌa̱ to̱ꞌon Ndios ña ni̱taa naprofeta xi̱na̱ꞌá. O̱n si̱ví xa̱ꞌa̱ ñayóꞌo kúu ña ki̱xaa̱ i̱; yi̱ꞌi̱ va̱xi i̱ kasa ndivi i̱ to̱ꞌon ña ni̱ka̱ꞌa̱n Ndios. ");
INSERT INTO mim_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ndixa káꞌa̱n i̱ xíꞌin ndó, ta ki̱vi̱ yóo ka̱ ñoyívi ni̱no xíꞌin ñoyívi yóꞌo, ta o̱n nondaa nda̱ ñii letra, ta nda̱ ñii punto no̱o̱ nda̱yí to̱ꞌon Ndios ña ni̱taa ta̱Moisés, ta ndixa kundivi ndiꞌi ña. ");
INSERT INTO mim_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ta saá tá yóo ñii ta̱a ta yáꞌa ndoso ra ñii nda̱yí yóꞌo, vará ña loꞌo ní kúu ña, ta saá tuku sánáꞌa ra inka̱ ni̱vi ña yaꞌa ndoso na nda̱yí yóꞌo, ta Ndios káchí ra ta̱yóꞌo kúu ta̱ loꞌo ní ka̱ no̱o̱ ndiꞌi inka̱ na ndíko̱n yichi̱ Ndios. Tá yóo ñii ta̱a ta kísa ndivi ra nda̱yí yóꞌo, ta sánáꞌa ra inka̱ ni̱vi ña kasa ndivi na ña, ta Ndios káchí ra ta̱yóꞌo kúu ta̱ káꞌno ní ka̱ no̱o̱ ndiꞌi inka̱ na ndíko̱n yichi̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Loꞌo ní kísa ndivi nafariseo xíꞌin na sánáꞌa nda̱yí Ndios ña kóni Ndios. Ta ndóꞌó, xíni̱ ñóꞌó kasa ndivi va̱ꞌa ka̱ ndó ndiꞌi ña kóni Ndios. Yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ndó, tá o̱n kasa ndivi ndó ñayóꞌo, ta saá o̱n kuchiño ndó ki̱ꞌvi ndó no̱o̱ xáꞌnda chiño Ndios ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ta ta̱Jesús ni̱ka̱ꞌa̱n tuku ra saá xíꞌin ni̱vi: ―Xa xi̱ni̱ so̱ꞌo ndó ña ni̱ka̱ꞌa̱n namaestro na sa̱náꞌa nda̱yí Ndios xi̱na̱ꞌá. Ni̱ka̱ꞌa̱n na xíꞌin naxi̱i̱ síkuá yó, káchí na saá: “O̱n kaꞌni ndó ni̱vi. Tá ñii ta̱a xa̱ꞌni ra inka̱ ta̱a, ta saá xíni̱ ñóꞌó ko̱ꞌo̱n ra no̱o̱ nachiño ña kasa nani na xa̱ꞌa̱ kua̱chi ra”, káchí namaestro. ");
INSERT INTO mim_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ta vitin yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ndó, tá yóo ñii ta̱a ta sáa̱ ní ini ra xíni ra ñani ra, ta ta̱ sáa̱ ini yóꞌo ndíso ra kua̱chi no̱o̱ Ndios. Tá yóo ñii ta̱a káꞌa̱n ra to̱ꞌon ña kándiva̱ꞌa ra xíꞌin ñani ra, ta ta̱ káꞌa̱n to̱ꞌon yóꞌo ndíso ra kua̱chi no̱o̱ nachiño náꞌno. Tá yóo ñii ta̱a káꞌa̱n ra to̱ꞌon ña sáta̱vi̱ chiꞌña ra ñani ra, káchí ra saá: “Ta̱kíꞌví kúu ún”, ta ta̱yóꞌo kúu ta̱a ta̱ kua̱ꞌa̱n yichi̱ no̱o̱ ko̱ꞌo̱n ra nda̱ya no̱o̱ xíxi̱ ñoꞌo̱ ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Tá kua̱ꞌa̱n ndó taxi ndó ñasóko̱ no̱o̱ Ndios veꞌe ño̱ꞌo káꞌno, ta nákáꞌán ndó yóo ta̱ñani ndó ta o̱n váꞌa kóni ra xíni ra ndóꞌó, saá chi xáni si̱ni̱ ra o̱n váꞌa ke̱ꞌé ndó xíꞌin ra, ");
INSERT INTO mim_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ta o̱n taxi ndó ñasóko̱ no̱o̱ Ndios, sandakoo naꞌá ndó ña, ta ko̱ꞌo̱n ndó ta kuaku ndáꞌví ndó no̱o̱ ta̱ñani ndó ña nakutáꞌan va̱ꞌa ndó xíꞌin ra, ta saá ndikó ndó taxi ndó ñasóko̱ no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Tá ñii ni̱vi kóni na taxi na kua̱chi xa̱ꞌa̱ ndó no̱o̱ nachiño, tá ta̱ꞌán ka̱ xaa̱ ndó veꞌe chiño, ta kama ndukú ndeé ndó kasa nani ndó kua̱chi xíꞌin na. Saá chi tá o̱n kasa nani ndó kua̱chi xíꞌin na, ta yi̱yo nataxi na ndóꞌó ndaꞌa̱ ta̱juez. Ta ta̱juez nataxi ra ndóꞌó ndaꞌa̱ ta̱policía, ta ko̱ꞌo̱n ndó veꞌe ka̱a. ");
INSERT INTO mim_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ndixa káꞌa̱n i̱ xíꞌin ndó, o̱n kee ya̱chi̱ ndó veꞌe ka̱a chi o̱n tava na ndóꞌó a̱nda̱ ná chaꞌvi ndó ndiꞌi si̱ꞌún ña níká ndó ―káchí ta̱Jesús xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ta tuku káchí ta̱Jesús saá xíꞌin na: ―Xa xi̱ni̱ so̱ꞌo ndó ña ni̱ka̱ꞌa̱n namaestro na sa̱náꞌa nda̱yí Ndios xi̱na̱ꞌá, káchí na saá: “O̱n váꞌa ku̱su̱n ñii ta̱a xíꞌin ñii ñaꞌa̱ ñá o̱n si̱ví kúu ñásíꞌí ra”, káchí namaestro. ");
INSERT INTO mim_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ta yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ndó, tá ñii ta̱a xíto ra ñii ñaꞌa̱ ta kóni ra ku̱su̱n ra xíꞌin ñá, ta ta̱yóꞌo xíꞌin níma̱ ra xa ni̱ki̱ꞌvi ra kua̱chi xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Tá nduchu̱ no̱o̱ ndó kúu ña chíndaꞌá ndóꞌó kua̱n ki̱ꞌvi ndó kua̱chi, ta saá va̱ꞌa ka̱ tava ndó ña ta sakana ndó ña. Chi va̱ꞌa ka̱ sandañóꞌó ndó ñii ñáꞌño yi̱kí ko̱ñu ndó, no̱o̱ ña ko̱ꞌo̱n ndó xíꞌin ndiꞌi yi̱kí ko̱ñu ndó nda̱ya. ");
INSERT INTO mim_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tá ndaꞌa̱ ndó kúu ña chíndaꞌá ndóꞌó kua̱n ki̱ꞌvi ndó kua̱chi, ta saá va̱ꞌa ka̱ kandoso ndó ña ta sakana ndó ña. Chi va̱ꞌa ka̱ sandañóꞌó ndó ñii ñáꞌño yi̱kí ko̱ñu ndó, no̱o̱ ña ko̱ꞌo̱n ndó xíꞌin ndiꞌi yi̱kí ko̱ñu ndó nda̱ya ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ta tuku káchí ta̱Jesús saá: ―Ni̱ka̱ꞌa̱n namaestro xi̱na̱ꞌá, káchí na saá: “Tá ñii ta̱a kóni ra sandakoo va̱ꞌa ra ñásíꞌí ra, ta saá xíni̱ ñóꞌó taxi ra ñii tutu ndaꞌa̱ ñá ña káꞌa̱n ndí sa̱ndakoo va̱ꞌa ra ñá”, káchí namaestro. ");
INSERT INTO mim_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ta yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ndó, tá ñii ñaꞌa̱ ñá yóo yii̱ o̱n vása ní‑kiꞌvi ñá kua̱chi xíꞌin inka̱ ta̱a, ta yii̱ ñá o̱n ko̱ó yichi̱ kómí ra sandakoo va̱ꞌa ra ñá. Tá ñii ta̱a sándakoo va̱ꞌa ra ñásíꞌí ra, ta ñáyóꞌo tonda̱ꞌa̱ tuku ñá, ta yii̱ ñá ta̱no̱ó ndíso ra kua̱chi, chi ke̱ꞌé ra ña ki̱ꞌvi ñá kua̱chi xíꞌin inka̱ ta̱a. Ta ta̱a ta̱ tonda̱ꞌa̱ xíꞌin ñáyóꞌo ki̱ꞌvi ra kua̱chi xíꞌin ñá, chi ñásíꞌí ta̱no̱ó kúu ñá no̱o̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ta káchí ta̱Jesús saá: ―Xa xi̱ni̱ so̱ꞌo ndó ña ni̱ka̱ꞌa̱n namaestro xíꞌin naxi̱i̱ síkuá yó xi̱na̱ꞌá, káchí na saá: “Tá chínáꞌa ndó Yivá yó Ndios ña kasa ndivi ndó ñii chiño, ta saá xíni̱ ñóꞌó kasa ndivi ndó ndiꞌi ña káꞌa̱n ndó”, káchí namaestro. ");
INSERT INTO mim_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ta yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ndó, o̱n vása va̱ꞌa chináꞌa ndó Yivá yó Ndios. Ni o̱n váꞌa chináꞌa ndó xa̱ꞌa̱ ñoyívi ni̱no. O̱n vása va̱ꞌa ka̱ꞌa̱n ndó saá, chi ñoyívi ni̱no kúu no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni o̱n váꞌa chináꞌa ndó xa̱ꞌa̱ ñoyívi yóꞌo. O̱n vása va̱ꞌa ka̱ꞌa̱n ndó saá, chi Ndios kúu ta̱káꞌno no̱o̱ ñoyívi yóꞌo. Ni o̱n váꞌa chináꞌa ndó xa̱ꞌa̱ ñoo Jerusalén. O̱n vása va̱ꞌa ka̱ꞌa̱n ndó saá, chi ñoo Jerusalén kúu ñoo no̱o̱ koo ta̱Rey káꞌno. ");
INSERT INTO mim_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni o̱n váꞌa chináꞌa ndó xa̱ꞌa̱ si̱ni̱ ndó. O̱n vása va̱ꞌa ka̱ꞌa̱n ndó saá, chi o̱n kuchiño mi̱i ndó nasama ndó ñii yisi̱ si̱ni̱ ndó nduu ña ña yaa án ña to̱ón. ");
INSERT INTO mim_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ta saá tá káꞌa̱n ndó, káchí ndó saá: “Kasa ndivi yó chiño yóꞌo”, ta saá xíni̱ ñóꞌó kasa ndivi ndó ña; tá káꞌa̱n ndó, káchí ndó saá: “O̱n vása kasa ndivi yó ñayóꞌo”, ta saá o̱n kasa ndivi ndó ña. O̱n vása xíni̱ ñóꞌó chinóo ndó ka̱ꞌa̱n ndó inka̱ to̱ꞌon ña kandixa ni̱vi ndóꞌó, chi inka̱ to̱ꞌon ña chinóo ndó va̱xi ña si̱ni̱ ñandiva̱ꞌa ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ta tuku káchí ta̱Jesús saá xíꞌin ni̱vi: ―Xa xi̱ni̱ so̱ꞌo ndó ña ni̱ka̱ꞌa̱n namaestro xi̱na̱ꞌá, káchí na saá: “Tá yóo ñii ta̱a sa̱takuéꞌe̱ ra nduchu̱ no̱o̱ inka̱ ta̱a, ta yóo nda̱yí ñii ki̱ꞌva saá satakuéꞌe̱ na nduchu̱ no̱o̱ mi̱i ra. Tá yóo ñii ta̱a ka̱ni ra yuꞌu̱ inka̱ ta̱a ta ta̱yóꞌo na̱kava ñii no̱ꞌo ra, ta yóo nda̱yí ñii ki̱ꞌva saá kani na yuꞌu̱ ra ta nakava ñii no̱ꞌo mi̱i ra”, káchí namaestro. ");
INSERT INTO mim_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ta yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ndó, o̱n ndikó niꞌi ndó ña o̱n váꞌa xíꞌin ni̱vi na sa̱takuéꞌe̱ ndóꞌó. Tá káni ni̱vi xa̱ꞌnda̱ ndaꞌa̱ na no̱o̱ ñii ndó, ta o̱n kani táꞌan ndó xíꞌin na, ta va̱ꞌa ka̱ taxi ndó ná kani na inka̱ táꞌví no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tá yóo ni̱vi káꞌa̱n kua̱chi na xa̱ꞌa̱ ndó no̱o̱ nachiño, ta kóni na kindaa na kotó ndó, ta va̱ꞌa ka̱ taxi ndó kotó ndó xíꞌin inka̱ tika̱chí ndó ndaꞌa̱ na. ");
INSERT INTO mim_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tá yóo ni̱vi kísa ndu̱xa̱ na xíꞌin ndó kuiso ndó ña̱ꞌa ña ko̱ꞌo̱n ndó xíꞌin na ñii kilómetro, ta va̱ꞌa ka̱ ko̱ꞌo̱n ndó xíꞌin na o̱vi̱ kilómetro. ");
INSERT INTO mim_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tá yóo ni̱vi ndúkú na ña̱ꞌa no̱o̱ ndó, ta va̱ꞌa taxi ndó ña ndúkú na ndaꞌa̱ na. Tá yóo ni̱vi ndúkú na ña satati ndó na, ta saá ndóꞌó, satati ndó na ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ta tuku káchí ta̱Jesús saá xíꞌin na: ―Xa xi̱ni̱ so̱ꞌo ndó ña ni̱ka̱ꞌa̱n namaestro xi̱na̱ꞌá, káchí na saá: “Kukiꞌvi ini ndó koni ndó natáꞌan ndó, ta kusaa̱ ini ndó koni ndó na sáa̱ ini xíni ndóꞌó”, káchí namaestro. ");
INSERT INTO mim_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ta yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ndó, kukiꞌvi ini ndó koni ndó na sáa̱ ini xíni ndóꞌó, ta ndukú ndó no̱o̱ Ndios ña keꞌé ra ñava̱ꞌa xíꞌin na sáta̱vi̱ chiꞌña ndóꞌó. Ta keꞌé ndó ñava̱ꞌa xíꞌin ni̱vi na o̱n xi̱in koni ndóꞌó, ta ka̱ꞌa̱n ndó xíꞌin Ndios xa̱ꞌa̱ ni̱vi na sáxo̱ꞌvi̱ ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tá kéꞌé ndó ñava̱ꞌa xíꞌin ni̱vi na sáa̱ ini xíni ndóꞌó, ta saá ni̱vi kunda̱a̱ ini na ndixa kúu ndó sa̱ꞌya Yivá yó Ndios, ta̱ yóo ñoyívi ni̱no. Chi Ndios kéꞌé ra ñava̱ꞌa xíꞌin ndiꞌi ni̱vi; chíndúꞌu̱ ra ña yeꞌe ño̱ꞌo no̱o̱ ni̱vi na o̱n váꞌa xíꞌin no̱o̱ ni̱vi na va̱ꞌa, ta sákoon ra sa̱vi̱ no̱o̱ ni̱vi na va̱ꞌa xíꞌin no̱o̱ ni̱vi na o̱n váꞌa. ");
INSERT INTO mim_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tá kíꞌvi ini ndó xíni ndó ndasaá kuiti ni̱vi na kíꞌvi ini xíni ndóꞌó, ta o̱n kundati ndó nakiꞌin ndó ñava̱ꞌa no̱o̱ Ndios, chi nda̱ ndiꞌi ni̱vi na káya si̱ꞌún xa̱ꞌa̱ nagobierno kíꞌvi ini nayóꞌo xíni na ni̱vi na kíꞌvi ini xíni ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tá káꞌa̱n ndó to̱ꞌon to̱ꞌó xíꞌin ndasaá kuiti natáꞌan ndó, ta, ¿yu kúu ka̱ ví ñava̱ꞌa kéꞌé ndó no̱o̱ inka̱ ni̱vi?, chi nda̱ ni̱vi na o̱n vása kándixa Ndios káꞌa̱n na to̱ꞌon to̱ꞌó xíꞌin táꞌan na. ");
INSERT INTO mim_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nda̱tán yóo Yivá yó Ndios ta̱va̱ꞌa, ta̱yi̱i̱, ta̱nda̱a̱, ñii ki̱ꞌva saá xíni̱ ñóꞌó kutaku̱ ndó ―káchí ta̱Jesús xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ni̱vi, káchí ra saá: ―Tá kéꞌé ndó ñava̱ꞌa ña kóni Ndios, ta kasa kuenda xíꞌin mi̱i ndó ña o̱n keꞌé ndó ñava̱ꞌa yóꞌo xa̱ꞌa̱ ña koto inka̱ ni̱vi. Saá chi tá ndasaá kuiti kéꞌé ndó ñava̱ꞌa xa̱ꞌa̱ ña kanóo va̱ꞌa to̱ꞌon ndó no̱o̱ inka̱ ni̱vi, ta saá Yivá yó Ndios, ta̱ yóo ñoyívi ni̱no, o̱n taxi ra nda̱ ñii ñava̱ꞌa ndaꞌa̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ta saá, tá sáníꞌi ndó si̱ꞌún ndaꞌa̱ nandáꞌví, ta o̱n ka̱ꞌa̱n ndoso ndó xíꞌin ndiꞌi ni̱vi ña kéꞌé ndó saá. Chi ni̱vi na o̱vi̱ yuꞌu̱, tá sáníꞌi na si̱ꞌún ndaꞌa̱ nandáꞌví, ta káꞌa̱n ndoso na xíꞌin ndiꞌi na ndóo veꞌe ño̱ꞌo sinagoga, ta káꞌa̱n ndoso na xíꞌin ni̱vi yichi̱, chi kóni na ña kasa to̱ꞌó ñaꞌá na, saá chi kéꞌé na ñava̱ꞌa xíꞌin nandáꞌví. Ndixa káꞌa̱n i̱ xíꞌin ndó, ñato̱ꞌó ña nákiꞌin na o̱vi̱ yuꞌu̱ ndaꞌa̱ inka̱ ni̱vi xa̱ꞌa̱ ña chíndeé na nandáꞌví, kúu ñii la̱á kuiti ñava̱ꞌa nakiꞌin na; saá chi o̱n ko̱ó ka̱ ñava̱ꞌa nakiꞌin na ki̱vi̱ ña va̱xi no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ta saá ndóꞌó, tá sáníꞌi ndó si̱ꞌún ndaꞌa̱ nandáꞌví, ta va̱ꞌa ka̱ ña o̱n koni̱ nda̱ ñii ni̱vi yukía̱ taxi ndó, vará natáꞌan ndó kúu na, ta o̱n ndato̱ꞌon ndó xíꞌin na, ");
INSERT INTO mim_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta saníꞌi seꞌé ndó ña̱ꞌa ndaꞌa̱ nandáꞌví. Ta saá Yivá yó Ndios, ta̱ xíto ña kéꞌé seꞌé ndó, taxi ra ñava̱ꞌa ndaꞌa̱ ndó xa̱ꞌa̱ ña sa̱níꞌi ndó ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ta káchí ta̱Jesús saá xíꞌin na: ―Tá káꞌa̱n ndó xíꞌin Ndios, ta o̱n keꞌé ndó nda̱tán kéꞌé ni̱vi na o̱vi̱ yuꞌu̱. Chi nayóꞌo kúsii̱ ní ini na yíta na no̱o̱ xíto ndiꞌi ni̱vi veꞌe ño̱ꞌo sinagoga, án yíta na yichi̱ no̱o̱ xíto kua̱ꞌa̱ ní ni̱vi ña káꞌa̱n na xíꞌin Ndios. Ta ndixa káꞌa̱n i̱ xíꞌin ndó, ñato̱ꞌó ña nákiꞌin na o̱vi̱ yuꞌu̱ ndaꞌa̱ inka̱ ni̱vi xa̱ꞌa̱ ña káꞌa̱n na xíꞌin Ndios, kúu ñii la̱á kuiti ñava̱ꞌa nakiꞌin na; saá chi o̱n ko̱ó ka̱ ñava̱ꞌa nakiꞌin na no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ta ndóꞌó, tá kóni ndó ka̱ꞌa̱n ndó xíꞌin Ndios, ta ki̱ꞌvi ndó ini veꞌe ndó, ta nakasi ndó yéꞌé ndó, ta saá ka̱ꞌa̱n ndó xíꞌin Ndios. Ta Yivá yó Ndios, ta̱a ta̱ o̱n vása kúchiño ndó koto ndó xíꞌin nduchu̱ no̱o̱ ndó, xíto ra ña kéꞌé seꞌé ndó, ta taxi ra ñava̱ꞌa ndaꞌa̱ ndó xa̱ꞌa̱ ña káꞌa̱n ndó xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Tá káꞌa̱n ndó xíꞌin Ndios, ta o̱n ka̱ꞌa̱n ndó to̱ꞌon ña o̱n vása ndáya̱ꞌví, nda̱tán káꞌa̱n ni̱vi na o̱n vása ndíko̱n Ndios, chi xáni si̱ni̱ na Ndios koni̱ so̱ꞌo ra na xa̱ꞌa̱ ña kua̱ꞌa̱ ní to̱ꞌon káꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","O̱n váꞌa ka̱ꞌa̱n ndó xíꞌin Ndios nda̱tán káꞌa̱n nayóꞌo, chi Yivá yó Ndios xíni̱ va̱ꞌa ra yu kúu ña xíni̱ ñóꞌó no̱o̱ ndó ta ta̱ꞌán ka̱ ndukú ndó ña no̱o̱ ra ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ta tuku káchí ra saá: ―Tá káꞌa̱n ndó xíꞌin Ndios, saá kachí ndó: Tata Yivá yó, ta̱ yóo ñoyívi ni̱no, ná kanóo síkón ní ñato̱ꞌó ún. ");
INSERT INTO mim_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ná kama kixaa̱ ki̱vi̱ kaꞌnda chiño ún no̱o̱ ndiꞌi ni̱vi. Nda̱tán yóo ñoyívi ni̱no kísa ndivi ndiꞌi na ña kóni ún, ñii ki̱ꞌva saá ñoyívi yóꞌo ná kasa ndivi ndiꞌi ni̱vi ña kóni ún. ");
INSERT INTO mim_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ndiꞌi saá ki̱vi̱ taxi ún ña xíni̱ ñóꞌó kuxu ndi̱. ");
INSERT INTO mim_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ta kasa káꞌno ini ún xa̱ꞌa̱ kua̱chi ndi̱, nda̱tán kísa káꞌno ini mi̱i ndi̱ xa̱ꞌa̱ ni̱vi na kéꞌé ña o̱n váꞌa xíꞌin ndi̱. ");
INSERT INTO mim_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tá xóꞌvi̱ ndi̱ tondóꞌó, ta chindeé ún ndi̱ꞌi̱ ña o̱n ki̱ꞌvi ndi̱ kua̱chi, ta saka̱ku ún ndi̱ꞌi̱ no̱o̱ ndiꞌi ña o̱n váꞌa. Chi yóꞌó kúu ta̱ xáꞌnda chiño, yóꞌó kúu ta̱ kómí ndee̱, ta ndiꞌi ni̱vi kasa káꞌno na yóꞌó ndiꞌi saá ki̱vi̱ ña va̱xi. Saá ná koo ña. Saá ka̱ꞌa̱n ndó xíꞌin Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ta káchí ka̱ ra saá xíꞌin na: ―Tá kasa káꞌno ini ndó xa̱ꞌa̱ ni̱vi na kéꞌé ñandiva̱ꞌa xíꞌin ndó, ta saá Yivá yó Ndios, ta̱ yóo ñoyívi ni̱no, kasa káꞌno ini ra xa̱ꞌa̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tá o̱n kasa káꞌno ini ndó xa̱ꞌa̱ kua̱chi ni̱vi, ta saá Yivá yó Ndios o̱n kasa káꞌno ini ra xa̱ꞌa̱ kua̱chi ndó ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ta káchí ta̱Jesús xíꞌin na: ―Tá yóo soꞌon ndó ña kasa to̱ꞌó ndó Ndios, ta o̱n ndasa chuchú ndó no̱o̱ ndó, nda̱tán yóo no̱o̱ ni̱vi na o̱vi̱ yuꞌu̱, chi nayóꞌo sánáꞌa na ña chuchú no̱o̱ na, ña kunda̱a̱ ini inka̱ ni̱vi ña yóo soꞌon na. Ndixa káꞌa̱n i̱ xíꞌin ndó, ñato̱ꞌó ña nákiꞌin na o̱vi̱ yuꞌu̱ ndaꞌa̱ inka̱ ni̱vi xa̱ꞌa̱ ña yóo soꞌon na, kúu ñii la̱á kuiti ñava̱ꞌa nakiꞌin na; saá chi o̱n ko̱ó ka̱ ñava̱ꞌa nakiꞌin na no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ta ndóꞌó, tá yóo soꞌon ndó, ta nakata ndó no̱o̱ ndó, ta nachoꞌon ndó si̱ni̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ta saá ni̱vi o̱n kunda̱a̱ ini na ña yóo soꞌon ndó. Ta Yivá yó Ndios, ta̱a ta̱ o̱n vása kúchiño ndó koto ndó xíꞌin nduchu̱ no̱o̱ ndó, xíto ra ña kéꞌé seꞌé ndó, ta taxi ra ñava̱ꞌa ndaꞌa̱ ndó xa̱ꞌa̱ ña yóo soꞌon ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ta tuku káchí ta̱Jesús saá xíꞌin na: ―O̱n ndukú ndó taan va̱ꞌa ndó ñakuíká ñoyívi yóꞌo, chi ñoyívi yóꞌo yóo tikisin xáxi ndiꞌi rí ña, ta inka̱ ñakuíká kivi kuxéꞌé ña ta ndiꞌi xa̱ꞌa̱ ña, án nakuíꞌná kivi ki̱ꞌvi na veꞌe ndó ta kasa kuíꞌná na ñakuíká ndó. ");
INSERT INTO mim_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Va̱ꞌa ka̱ kasa ndivi ndó ndiꞌi ña kóni Ndios, ta saá kukomí ndó ñakuíká ndinoꞌo ñoyívi ni̱no, chi ñoyívi ni̱no o̱n ko̱ó tikisin, ni o̱n kuxéꞌé ña̱ꞌa, ni nakuíꞌná o̱n ki̱ví kasa kuíꞌná na ñakuíká ndinoꞌo ña yóo ñoyívi ni̱no. ");
INSERT INTO mim_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Saá chi no̱o̱ ñóꞌo ñakuíká kómí ndó, kán yóo níma̱ ndó xíꞌin si̱ni̱ ndó ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ni̱vi, káchí ra saá: ―Nda̱tán yóo ñoꞌo̱ ña yéꞌe, saá yóo nduchu̱ no̱o̱ yó. Tá va̱ꞌa yóo nduchu̱ no̱o̱ ndó, ta va̱ꞌa yéꞌe ndiꞌi ini ndó, saá va̱ꞌa kunda̱a̱ ini ndó ñanda̱a̱. ");
INSERT INTO mim_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tá o̱n vása va̱ꞌa yóo nduchu̱ no̱o̱ ndó, ta naa ní ini ndó. Saá chi xáni si̱ni̱ ndó xíka ndó xíꞌin ñoꞌo̱ yéꞌe, ta o̱n si̱ví ñanda̱a̱ kúu ña. Ta saá, ¡nda̱chun naa ní ini ndó! ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ta tuku káchí ta̱Jesús saá xíꞌin na: ―Nda̱ ñii ta̱a o̱n ki̱ví kasa chiño ra no̱o̱ o̱vi̱ patrón. Tá yóo o̱vi̱ patrón ra, ta kivi kukiꞌvi ini ra koni ra ñii ra, ta kusaa̱ ini ra koni ra ta̱ inka̱. Ta kivi kusii̱ ini ra kasa chiño ra xíꞌin ñii ra, ta o̱n kuaꞌa ra kasa chiño ra xíꞌin ta̱ inka̱. To̱ꞌon yóꞌo káchí ña saá: Tá Ndios kúu ta̱ xáꞌnda chiño no̱o̱ yó, ta o̱n ki̱ví taxi yó kaꞌnda chiño si̱ꞌún no̱o̱ yó ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ta tuku káchí ta̱Jesús saá xíꞌin na: ―Ta káꞌa̱n i̱ xíꞌin ndó, o̱n kundiꞌi ini ndó xa̱ꞌa̱ ña xíni̱ ñóꞌó kutaku̱ ndó, ni o̱n kundiꞌi ini ndó mí kixi ña kuxu ndó, ña koꞌo ndó, ni o̱n kundiꞌi ini ndó xa̱ꞌa̱ tiko̱to̱ ña kundixin ndó ñoyívi yóꞌo, saá chi níma̱ yó ndáya̱ꞌví ní ka̱ ña no̱o̱ ña xíxi yó, ta yi̱kí ko̱ñu yó ndáya̱ꞌví ní ka̱ ña no̱o̱ tiko̱to̱ yó. ");
INSERT INTO mim_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ta koto ndó ndasaá táku̱ tísaa, ni o̱n vása chíꞌi rí, ni o̱n vása nákaya rí ña xáxi rí, ni o̱n vása táan va̱ꞌa rí ña xáxi rí. Mi̱i Yivá yó Ndios, ta̱ yóo ñoyívi ni̱no, táxi ra ña xáxi tísaa yóꞌo. Ta ndóꞌó, ndáya̱ꞌví ní ka̱ ndó no̱o̱ tísaa. ");
INSERT INTO mim_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ta ndóꞌó, o̱n si̱ví xíꞌin ña ndíꞌi ní ini ndó kúu ña kúchiño ndó sakuaꞌno síkón ka̱ ndó xíꞌin mi̱i ndó, chi ñii la̱á Ndios kúu ta̱ xáꞌnda chiño ndasaá ki̱ꞌva síkón koo ndó. ");
INSERT INTO mim_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Nda̱chun ndíꞌi ini ndó xa̱ꞌa̱ tiko̱to̱ ña xíni̱ ñóꞌó ndó? Koto ndó ndasaá livi ndáxaa yita ña yóo yuku̱; yita yóꞌo o̱n vása kísa chiño ña, ni o̱n vása kísa va̱ꞌa ña tiko̱to̱ ña. ");
INSERT INTO mim_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ta ndixa káꞌa̱n i̱ xíꞌin ndó, vará ta̱rey Salomón, ta̱kuíká ní xi̱kuu ra, ta xi̱komí ní ra kua̱ꞌa̱ ní tiko̱to̱ va̱ꞌa, ta yita ña yóo yuku̱ livi ní ka̱ ña no̱o̱ tiko̱to̱ va̱ꞌa ña xi̱ndixin ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Vará nda̱ loꞌo ki̱vi̱ táku̱ yita válí yuku̱, chi ñii ki̱vi̱ ndáxaa ña, ta inka̱ ki̱vi̱ ndáꞌva̱ ña, ta saá táan na ña ini xi̱to̱n ko̱ko̱ ña, ta Ndios ndáa ra ña, ta ndátón sákundixin ra ña. Ñayóꞌo sánáꞌa ndí Ndios ndáa va̱ꞌa ra ndóꞌó, chi ndóꞌó ndáya̱ꞌví ní ka̱ ndó no̱o̱ yita válí. ¿Nda̱chun loꞌo ní kándixa ndó Ndios ña kundaa ra ndóꞌó? ");
INSERT INTO mim_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ta saá o̱n kundiꞌi ini ndó, ta ni o̱n ka̱ꞌa̱n ndó, kachí ndó saá: “¿Mí kixi ña kuxu yó? ¿Mí kixi ña koꞌo yó? ¿Mí kixi ña kundixin yó?”, o̱n kachí ndó saá. ");
INSERT INTO mim_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Chi ni̱vi na o̱n vása ndíko̱n Ndios kúu ni̱vi na ndíꞌi ní ini xa̱ꞌa̱ ñayóꞌo. Ta Yivá yó Ndios xíni̱ va̱ꞌa ra yu kúu ndiꞌi ña xíni̱ ñóꞌó yó. ");
INSERT INTO mim_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ta mi̱i ndó, ndinoꞌo ini ndó ná kundiko̱n ndó yichi̱ no̱o̱ xáꞌnda chiño Ndios, ta kasa ndivi ndó ndiꞌi ña kóni mi̱i ra, ta ndixa Ndios taxi ndiꞌi ra ña xíni̱ ñóꞌó ndaꞌa̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ta saá o̱n kundiꞌi ní ini ndó xa̱ꞌa̱ ña koni̱ ñóꞌó no̱o̱ ndó ki̱vi̱ ña va̱xi. Ndiꞌi saá ki̱vi̱ kómí ndó tondíni, ta Ndios xíni̱ ra taxi ra ndiꞌi ña xíni̱ ñóꞌó ndaꞌa̱ ndó ki̱vi̱ vitin. Ta o̱n kundiꞌi ini ndó xa̱ꞌa̱ ki̱vi̱ taa̱n ―káchí ta̱Jesús xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ta káchí ta̱Jesús saá xíꞌin na: ―O̱n ka̱ꞌa̱n ndó to̱ꞌon ña o̱n váꞌa xa̱ꞌa̱ inka̱ ni̱vi, saá chi kua̱chi kúu ña no̱o̱ Ndios, ta̱a ta̱ kasa nani xa̱ꞌa̱ ndiꞌi kua̱chi ni̱vi ñii ki̱vi̱ va̱xi. ");
INSERT INTO mim_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nda̱tán ka̱ꞌa̱n ndó to̱ꞌon ña o̱n váꞌa xa̱ꞌa̱ inka̱ ni̱vi, saá ka̱ꞌa̱n Ndios ña o̱n váꞌa xa̱ꞌa̱ ndó. Nda̱tán yóo ki̱ꞌva taxi ndó ndaꞌa̱ inka̱ ni̱vi, ta mi̱i ki̱ꞌva yóꞌo taxi Ndios ndaꞌa̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nda̱tán yóo ni̱vi na kíꞌin va̱ꞌa kuenda ña nákaa̱ ñii mi̱ꞌí loꞌo nduchu̱ no̱o̱ ñani táꞌan na, ta o̱n vása kíꞌin na kuenda ña nákaa̱ ñii yito̱n káꞌno nduchu̱ no̱o̱ mi̱i na, ta saá yóo ndóꞌó, chi kíꞌin va̱ꞌa ndó kuenda ña kua̱chi loꞌo kéꞌé natáꞌan ndó, ta o̱n vása kíꞌin ndó kuenda ña kua̱chi káꞌno kéꞌé mi̱i ndó. ");
INSERT INTO mim_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tá ñii yito̱n káꞌno nákaa̱ nó nduchu̱ no̱o̱ ndó, ta o̱n váꞌa ka̱ꞌa̱n ndó xíꞌin ñani ndó, kachí ndó saá: “Taxi ún ná tava i̱ mi̱ꞌí loꞌo nákaa̱ nduchu̱ no̱o̱ ún”, kachí ndó. ");
INSERT INTO mim_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tá saá kéꞌé ndó, ta, ¡ni̱vi na o̱vi̱ yuꞌu̱ kúu ndóꞌó! Chi siꞌna xíni̱ ñóꞌó tava ndó yito̱n nákaa̱ nduchu̱ no̱o̱ ndó, ta saá kuchiño va̱ꞌa koto ndó ña tava ndó mi̱ꞌí loꞌo nákaa̱ nduchu̱ no̱o̱ ñani ndó. ");
INSERT INTO mim_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’O̱n taxi ndó ña̱ꞌa ñayi̱i̱ Ndios ndaꞌa̱ tí ina ko̱to̱ sandiꞌi rí xa̱ꞌa̱ ña, ta ndikó rí kaxi rí ndóꞌó. Ta o̱n kata ndó ñakuíká ndó no̱o̱ tíkini̱ ko̱to̱ kundo̱so̱ rí ña ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ta tuku káchí ta̱Jesús saá xíꞌin na: ―O̱n sandakoo ndó ndúkú ndó ña xíni̱ ñóꞌó ndó no̱o̱ Ndios, saá chi ndixa taxi ra ña ndaꞌa̱ ndó. Ta ni o̱n sandakoo ndó nándukú ndó Ndios, saá chi ndixa naníꞌi ndó ra. Ta ni o̱n sandakoo ndó kána ndó yéꞌé yichi̱ Ndios, saá chi ndixa nakuiná ra ña ki̱ꞌvi ndó yichi̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chi ndiꞌi ni̱vi na ndúkú no̱o̱ Ndios ña xíni̱ ñóꞌó na, ta nakiꞌin na ña. Ta ndiꞌi ni̱vi na nándukú Ndios, naníꞌi na ra. Ta ndiꞌi ni̱vi na kána Ndios, ta nakuiná ra yéꞌé ra ña ki̱ꞌvi na yichi̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Tá yóo ñii sa̱ꞌya ndó, tá ndúkú ra si̱ta̱ va̱ꞌa no̱o̱ ndó, ta o̱n ki̱ví taxi ndó yu̱u̱ ndaꞌa̱ ra, chi sa̱ꞌya ndó kúu ra. ");
INSERT INTO mim_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tá ndúkú ra ñii tia̱ká no̱o̱ ndó kuxu ra, ta o̱n ki̱ví taxi ndó ñii ko̱o̱ ndaꞌa̱ ra, chi sa̱ꞌya ndó kúu ra. ");
INSERT INTO mim_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Vará ndóꞌó kúu ndó ni̱vi na o̱n váꞌa, ta saá ni, táxi ndó ñava̱ꞌa ndaꞌa̱ sa̱ꞌya ndó. Ta Yivá yó Ndios, ta̱ yóo ñoyívi ni̱no, kúu ra ta̱ va̱ꞌa ní ka̱ no̱o̱ ni̱vi, ta ndixa taxi ra ñava̱ꞌa ndaꞌa̱ ndiꞌi ni̱vi na ndukú ña no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ñii ki̱ꞌva nda̱tán kóni ndó keꞌé ni̱vi ñava̱ꞌa xíꞌin ndó, saá keꞌé ndó ñava̱ꞌa xíꞌin na. Tá kéꞌé ndó saá, ta kísa ndivi ndó ña ni̱ka̱ꞌa̱n nda̱yí Ndios ña ni̱taa ta̱Moisés xíꞌin to̱ꞌon ña ni̱taa naprofeta xi̱na̱ꞌá ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ta káchí tuku ta̱Jesús xíꞌin na: ―Ta xíni̱ ñóꞌó ndixa xaꞌa ndó ndee̱ ña ki̱ꞌvi ndó yéꞌé ña táñó ní ña ko̱ꞌo̱n ndó yichi̱ Ndios. Chi yóo inka̱ yichi̱ ña ndíka̱ ní, ta ndíka̱ ní kúu yéꞌé ña; ta yichi̱ yóꞌo kua̱ꞌa̱n ña no̱o̱ ndiꞌi xa̱ꞌa̱ ni̱vi, ta kua̱ꞌa̱ ní ni̱vi kua̱ꞌa̱n na yichi̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ta yichi̱ táñó ña kómí yéꞌé táñó, kúu ña kua̱ꞌa̱n no̱o̱ kutaku̱ ni̱vi xíꞌin Ndios ndiꞌi saá ki̱vi̱, ta loꞌo ní ni̱vi kúu na náníꞌi yichi̱ táñó yóꞌo ta ndíko̱n na ña ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ta tuku káchí ta̱Jesús saá xíꞌin na: ―Koto va̱ꞌa ndó chi yóo naprofeta vatá. Xáni ini ndó nava̱ꞌa kúu na xa̱ꞌa̱ ña livi ní to̱ꞌon sánáꞌa na, ta o̱n xíni ndó ndí ña o̱n váꞌa yóo ini na, chi kóni na sandáꞌví na ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Koto ndó yukía̱ kéꞌé na, tá yóo ña o̱n váꞌa kéꞌé na, ta saá kunda̱a̱ ini ndó o̱n si̱ví na sánáꞌa to̱ꞌon Ndios kúu na. Nda̱ ñii ni̱vi o̱n ki̱ví kaꞌnda na tíuva ndaꞌa̱ tón ñiño̱, ni o̱n ki̱ví kaꞌnda na tíhigo ndaꞌa̱ tón viꞌnda̱. ");
INSERT INTO mim_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ndiꞌi yito̱n tón va̱ꞌa, kóon kui̱ꞌi tí va̱ꞌa ndaꞌa̱ nó, ta ndiꞌi yito̱n tón o̱n váꞌa, kóon kui̱ꞌi tí o̱n váꞌa ndaꞌa̱ nó. ");
INSERT INTO mim_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nda̱ ñii yito̱n tón va̱ꞌa, o̱n ki̱ví koon kui̱ꞌi tí o̱n váꞌa ndaꞌa̱ nó. Ta nda̱ ñii yito̱n tón o̱n váꞌa, o̱n ki̱ví koon kui̱ꞌi tí va̱ꞌa ndaꞌa̱ nó. ");
INSERT INTO mim_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ta ta̱a ta̱ kómí yito̱n, ta̱yóꞌo kaꞌnda ra ndiꞌi yito̱n tón kóon kui̱ꞌi tí o̱n váꞌa ndaꞌa̱, ta chikaa̱ ra nó no̱o̱ ñoꞌo̱ ko̱ko̱ nó. ");
INSERT INTO mim_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nda̱tán yóo yito̱n xíꞌin kui̱ꞌi nó, saá yóo ni̱vi xíꞌin ña kéꞌé na. Ta saá nakoni ndó ni̱vi na sánáꞌa ñavatá, chi kéꞌé na ña o̱n váꞌa ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ta káchí tuku ta̱Jesús saá xíꞌin na: ―Tá yóo ni̱vi na káꞌa̱n xíꞌin i̱: “Yóꞌó kúu ta̱Káꞌno ta̱ xáꞌnda chiño no̱o̱ ndi̱”, káchí na xíꞌin i̱, ta o̱n si̱ví ndiꞌi ni̱vi na káꞌa̱n to̱ꞌon yóꞌo kúu na kúchiño ki̱ꞌvi no̱o̱ xáꞌnda chiño Ndios. Ndasaá ni̱vi na kísa ndivi ña kóni Yivá i̱ Ndios, ta̱ yóo ñoyívi ni̱no, nayóꞌo kúu na kúchiño ki̱ꞌvi na yichi̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ki̱vi̱ ña va̱xi tá kasa nani Ndios xa̱ꞌa̱ kua̱chi ni̱vi, ta kua̱ꞌa̱ ní ni̱vi kachí na saá xíꞌin i̱: “Tata, Tata, ndíso ndi̱ to̱ꞌon ni̱xa̱ꞌa̱n ndi̱ ta ni̱ka̱ꞌa̱n ndoso ndi̱ to̱ꞌon ún no̱o̱ ni̱vi, ta xíꞌin to̱ꞌon ún ta̱va ndi̱ ñaníma̱ ndiva̱ꞌa, ta xíꞌin to̱ꞌon ún kua̱ꞌa̱ ní milagro ke̱ꞌé ndi̱ no̱o̱ ni̱vi”, kachí na. ");
INSERT INTO mim_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ta yi̱ꞌi̱ ndakuii̱n i̱, kachí i̱ xíꞌin nayóꞌo: “O̱n si̱ví na ndíko̱n yi̱ꞌi̱ kúu ndó, kutaꞌa ndó no̱o̱ i̱, chi na ndiva̱ꞌa kúu ndóꞌó”, kachí i̱ xíꞌin na ―káchí ta̱Jesús xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ta káchí tuku ta̱Jesús saá xíꞌin na: ―Nda̱tán yóo ñii ta̱a ta̱ ndíchí ní si̱ni̱, ta ta̱yóꞌo va̱ꞌa kísa va̱ꞌa ra veꞌe ra sa̱ta̱ yu̱u̱ chée kútu̱, saá yóo ni̱vi na xíni̱ so̱ꞌo to̱ꞌon i̱, ta kísa ndivi na ña káꞌa̱n i̱ xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ta ndeé ní kóon sa̱vi̱, ta xáꞌno ní yu̱ta, ta xa̱ꞌa̱ veꞌe ta̱yóꞌo ndeé ní káni takuií, ta saá ndeé ní káni ta̱chi̱ veꞌe ra, ta veꞌe yóꞌo o̱n vása ní‑nakava ña, chi xa̱ꞌa̱ veꞌe yóꞌo nákaa̱ kútu̱ ña sa̱ta̱ yu̱u̱ chée. ");
INSERT INTO mim_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nda̱tán yóo ñii ta̱a ta̱ o̱n vása ndíchí si̱ni̱, ta ta̱yóꞌo kísa va̱ꞌa ra veꞌe ra no̱o̱ yóo yo̱tí vitá, saá yóo ni̱vi na xíni̱ so̱ꞌo to̱ꞌon ña káꞌa̱n i̱, ta o̱n vása kísa ndivi na ña. ");
INSERT INTO mim_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ta ndeé ní kóon sa̱vi̱, ta xáꞌno ní yu̱ta, ta̱nda̱ xa̱ꞌa̱ veꞌe ta̱yóꞌo ndeé ní káni takuií, ta ndeé ní káni ta̱chi̱ veꞌe yóꞌo, ta saá o̱n vása ní‑kundeé ña, ta na̱kava ña ta ndi̱ꞌi xa̱ꞌa̱ ña ―káchí ta̱Jesús xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tá ta̱Jesús ndi̱ꞌi ni̱ka̱ꞌa̱n ra xíꞌin na, ta na̱kaꞌnda ini ndiꞌi ni̱vi xa̱ꞌa̱ ña xíni̱ so̱ꞌo na ña sánáꞌa ra, ");
INSERT INTO mim_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","chi sánáꞌa ra na nda̱tán sánáꞌa ñii ta̱a ta̱ kómí nda̱yí, ta inka̱ namaestro na sánáꞌa nda̱yí Ndios, nayóꞌo sánáꞌa na nda̱tán sánáꞌa ni̱vi na o̱n vása kómí nda̱yí. ");
INSERT INTO mim_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ta saá ke̱e ta̱Jesús ta va̱xi noo ra xi̱ki̱, ta kua̱ꞌa̱ ní ni̱vi xi̱kundiko̱n na sa̱ta̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ta ki̱xaa̱ ñii ta̱a ta̱ ndeé ní ndóꞌo kue̱ꞌe̱ táꞌyí ña na̱ní lepra. Ki̱xaa̱ ra xi̱kuxítí ra no̱o̱ ta̱Jesús, ta káchí ra saá xíꞌin ra: ―Tata, tá kóni ún, ta sandaꞌa ún yi̱ꞌi̱ no̱o̱ kue̱ꞌe̱ ña ndóꞌo i̱ ―káchí ta̱ ndeé ndóꞌo xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ta ta̱Jesús chi̱nóo ra ndaꞌa̱ ra so̱ko̱ ta̱yóꞌo, ta ni̱ka̱ꞌa̱n ra: ―Kóni i̱ chindeé i̱ yóꞌó. ¡Ndaꞌa ún! ―káchí ta̱Jesús xíꞌin ra. Ta xa̱ndi̱ko̱n sa̱ña kue̱ꞌe̱ táꞌyí xíꞌin ra, ta ndu̱va̱ꞌa ra. ");
INSERT INTO mim_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―O̱n ndato̱ꞌon ún xíꞌin nda̱ ñii ni̱vi. Ta vitin ko̱ꞌo̱n ún no̱o̱ ta̱su̱tu̱ ná koto ra yóꞌó ña kunda̱a̱ ini ra xa ni̱ndaꞌa ún. Ta kuniꞌi ún ndiꞌi ñasóko̱ ña xáꞌnda chiño nda̱yí Ndios ña ni̱taa ta̱Moisés, ta taxi ún ñayóꞌo ndaꞌa̱ Ndios ña kunda̱a̱ ini ni̱vi xa ni̱ndaꞌa ún ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ta saá ta̱Jesús ni̱ki̱ꞌvi ra ñoo Capernaum. Ta ñoo yóꞌo yóo ñii ta̱ñoo Roma, ta ndíso chiño ra xíꞌin ñii ciento natropa, ta ki̱xaa̱ ra no̱o̱ ta̱Jesús, xa̱ku ndáꞌví ra, ");
INSERT INTO mim_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","káchí ra saá xíꞌin ra: ―Tata, yóo ñii ta̱a ta̱ kísa chiño no̱o̱ i̱, ta ndeé ní ndóꞌo ra, kándúꞌu̱ ra veꞌe i̱, o̱n ki̱ví kanda ra, ta xóꞌvi̱ ní ra. ");
INSERT INTO mim_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Ko̱ꞌo̱n i̱ xíꞌin ún veꞌe ún ña sandaꞌa i̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ta nda̱kuii̱n ta̱ ndíso chiño xíꞌin natropa, káchí ra saá: ―Tata, yóꞌó kúu ta̱ káꞌno ní no̱o̱ i̱, ta yi̱ꞌi̱ kúu ta̱ ni̱no̱ ní no̱o̱ ún, ña̱kán o̱n vása va̱ꞌa ko̱ꞌo̱n ún veꞌe i̱. Chi kómí ún nda̱yí ña kuiti kaꞌnda chiño ún no̱o̱ kue̱ꞌe̱, ta nduva̱ꞌa ta̱ kísa chiño no̱o̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kúnda̱a̱ ini i̱ xa̱ꞌa̱ nda̱yí, chi yóo na xáꞌnda chiño no̱o̱ i̱, ta kísa ndivi i̱ ña káꞌa̱n na xíꞌin i̱; ta yi̱ꞌi̱ xáꞌnda chiño i̱ no̱o̱ inka̱ natropa, ta kísa ndivi na ña káꞌa̱n i̱. Tá yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ñii ta̱tropa ña ko̱ꞌo̱n ra, ta saá kua̱ꞌa̱n ra. Tá kána i̱ inka̱ ra, ta saá va̱xi ra. Tá káꞌa̱n i̱ xíꞌin ta̱ xíka chiño no̱o̱ i̱ kasa ndivi ra ñii chiño, ta kísa ndivi ra ña ―káchí ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ta ta̱Jesús na̱kaꞌnda ini ra xíni̱ so̱ꞌo ra to̱ꞌon yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi na ndóo xíꞌin ra: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, ndiꞌi saá ñoo Israel ta̱ꞌán nakutáꞌan i̱ xíꞌin ñii ta̱a ta̱ kándixa Ndios nda̱tán kándixa ta̱yóꞌo, ta ni o̱n si̱ví ta̱judío kúu ra. ");
INSERT INTO mim_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Káꞌa̱n i̱ xíꞌin ndó, ta va̱xi ñii ki̱vi̱ ka̱ꞌa̱n Ndios viko̱ ñoyívi ni̱no, ta kixaa̱ kua̱ꞌa̱ ní ni̱vi, na kixi no̱o̱ va̱xi kana ño̱ꞌo, ta inka̱ na kixi no̱o̱ kua̱n ke̱tá ño̱ꞌo, ta kixaa̱ na va̱xi ndiꞌi saá xiiña ñoyívi. Ta kundo̱o na kuxu na xíꞌin naxi̱i̱ síkuá yó ta̱Abraham, ta̱Isaac xíꞌin ta̱Jacob. ");
INSERT INTO mim_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Najudío kúu na siꞌna chi̱tóni̱ Ndios kundo̱o na xíꞌin ra viko̱ ñoyívi ni̱no, ta kua̱ꞌa̱ ní nayóꞌo o̱n xi̱in na kandixa na Ndios. Ta Ndios o̱n taxi ra ki̱ꞌvi na o̱n vása kándixa ñaꞌá kuxu na no̱o̱ yóo viko̱, ta ko̱ꞌo̱n na no̱o̱ yóo yavi̱ naa, no̱o̱ kuaku ní na, no̱o̱ ndeé ní xo̱ꞌvi̱ na ―káchí ta̱Jesús xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱ ndíso chiño xíꞌin natropa, káchí ra saá: ―Vitin va̱ꞌa, noꞌo̱ ún veꞌe ún. Ta xa ndu̱va̱ꞌa ta̱ kísa chiño no̱o̱ ún xa̱ꞌa̱ ña kándixa ún yi̱ꞌi̱ ―káchí ta̱Jesús. Ta mi̱i hora ni̱ka̱ꞌa̱n ta̱Jesús ñayóꞌo, ndu̱va̱ꞌa ta̱ ndeé ndóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ta saá kua̱ꞌa̱n ta̱Jesús veꞌe ta̱Pedro. Ta ni̱xaa̱ ra ta xi̱ni ra ñaꞌa̱ ñási̱so ta̱Pedro, kándúꞌu̱ ñá no̱o̱ xi̱to, ndeé ní ndóꞌo ñá kue̱ꞌe̱ kaꞌni̱. ");
INSERT INTO mim_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ta chi̱nóo ra ndaꞌa̱ ra sa̱ta̱ ndaꞌa̱ ñá, ta xa̱ndi̱ko̱n sa̱ña kue̱ꞌe̱ xíꞌin ñá ta ndu̱va̱ꞌa ñá. Ta saá nda̱koo ñá, ta ki̱xáꞌá ñá kísa ndivi ñá ña kuxu na. ");
INSERT INTO mim_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tá xikuaa kua̱ꞌa̱n kuñoó kúu ña, ta kua̱ꞌa̱ ní ni̱vi kua̱ꞌa̱n na xíꞌin natáꞌan na no̱o̱ ta̱Jesús; sava na kómí níma̱ ndiva̱ꞌa. Ta sava na kómí inka̱ no̱o̱ kue̱ꞌe̱. Ta ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ ndiꞌi ñaníma̱ ndiva̱ꞌa kee ña, ta ta̱va ra ña, ta saá tuku sa̱ndúva̱ꞌa ra ndiꞌi na kómí inka̱ no̱o̱ kue̱ꞌe̱. ");
INSERT INTO mim_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ña ke̱ꞌé ra ndiꞌi ñayóꞌo kúu ña ki̱sa ndivi ra ña ni̱taa ta̱profeta Isaías xi̱na̱ꞌá xa̱ꞌa̱ ta̱a ta̱ tiꞌví Ndios ñoyívi yóꞌo, ka̱chí ra saá: “Ki̱ndaa ra ndiꞌi kue̱ꞌe̱ ña xóꞌvi̱ yó, ta ndu̱va̱ꞌa yó”, ka̱chí ta̱Isaías xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ta xi̱ni ta̱Jesús kua̱ꞌa̱ ní ni̱vi xi̱no nduu na no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Ná koꞌyo̱ inka̱ xiiña no̱o̱ mi̱ni. ");
INSERT INTO mim_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ta saá ki̱xaa̱ ñii ta̱maestro ta̱ sánáꞌa nda̱yí Ndios, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús, káchí ra saá: ―Tata, kundiko̱n i̱ sa̱ta̱ ún, nda̱ mí ko̱ꞌo̱n ún ta ko̱ꞌo̱n i̱ xíꞌin ún ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―Tíñokuii kómí rí kavua̱ no̱o̱ kísi̱n rí, ta tísaa kómí rí ta̱ka̱ rí ndaꞌa̱ yito̱n no̱o̱ kísi̱n rí, ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, o̱n ko̱ó veꞌe i̱ no̱o̱ ku̱su̱n i̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ta inka̱ ta̱ ndíko̱n xíni̱ so̱ꞌo ña sánáꞌa ta̱Jesús, ni̱ka̱ꞌa̱n ra saá xíꞌin ra: ―Tata, kóni i̱ kundiko̱n i̱ yóꞌó. Ta siꞌna taxi ún ña kundati i̱ nda̱ ná kivi̱ yivá i̱, ta sandúxu̱n i̱ ra, ta saá kundiko̱n i̱ yichi̱ ún ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra, káchí ra saá: ―Ni̱vi na o̱n vása ndinoꞌo táku̱ no̱o̱ Ndios, va̱ꞌa sandúxu̱n na natáꞌan na nandi̱í. Ta yóꞌó, xíni̱ ñóꞌó kundiko̱n ún yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ta saá ni̱ki̱ꞌvi ta̱Jesús ini tón barco xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ta ki̱xáꞌá ndeé ní káni ta̱chi̱ naꞌá no̱o̱ takuií, ta ki̱xáꞌá nákutú takuií ini tón barco. Ta ta̱Jesús kándúꞌu̱ ra kísi̱n ra ini tón barco. ");
INSERT INTO mim_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ta naxíka xíꞌin ra sa̱nakáxín na ini ra, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tata, ¡saka̱ku ún ndi̱ꞌi̱! ¡Yi̱yo ní ka̱ꞌa̱ ndiꞌi yó xíꞌin takuií, chi kua̱n ke̱tá tón barco ini mi̱ni! ");
INSERT INTO mim_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―¿Nda̱chun yíꞌví ní ndó? ¿Nda̱chun o̱n vása kándixa ndó Ndios ndáa ra ndóꞌó? Ta nda̱koo ta̱Jesús, ta xa̱ꞌnda chiño ra no̱o̱ ta̱chi̱ naꞌá xíꞌin takuií mi̱ni. Ta saá ku̱tásin ta̱chi̱ naꞌá xíꞌin takuií mi̱ni, ñii ya̱a̱ ya̱a̱ ku̱u. ");
INSERT INTO mim_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ta na̱kaꞌnda ní ini na, ta ni̱nda̱ka̱ to̱ꞌon táꞌan na: ―¿Yu kúu ta̱yóꞌo? ¡Chi nda̱ ta̱chi̱ naꞌá xíꞌin takuií mi̱ni xíni̱ so̱ꞌo to̱ꞌon káꞌa̱n ra! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ta ni̱xaa̱ ta̱Jesús inka̱ táꞌví yuꞌu̱ mi̱ni no̱o̱ ndóo nañoo Gadara. Ta o̱vi̱ ta̱a ta̱ kómí níma̱ ndiva̱ꞌa ki̱xaa̱ na no̱o̱ ra. Ta o̱vi̱ ta̱yóꞌo sa̱kán ke̱e na kavua̱ no̱o̱ ndúxu̱n nandi̱í, chi kavua̱ yóꞌo táku̱ nata̱a yóꞌo. Kue̱ꞌe̱ ní na, ta nda̱ ñii ni̱vi o̱n ki̱ví yaꞌa na yichi̱ yuꞌu̱ kavua̱ no̱o̱ táku̱ o̱vi̱ ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ta o̱vi̱ ta̱yóꞌo xi̱ni na va̱xi ta̱Jesús, ta ki̱xáꞌá ñandiva̱ꞌa ña kómí na xíꞌin ndiꞌi ndee̱ ña ni̱ka̱ꞌa̱n ña, ta káchí ña saá: ―¿Yukía̱ kóni ún keꞌé ún xíꞌin ndi̱ vitin?, chi yóꞌó ta̱Jesús kúu Sa̱ꞌya Ndios. ¿Án ki̱xaa̱ ún vitin saxo̱ꞌvi̱ ún ndi̱ꞌi̱?, saá chi ta̱ꞌán kixaa̱ ki̱vi̱ ña kasa nani Ndios xa̱ꞌa̱ kua̱chi ―káchí ña xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ta yatin yóꞌo xíka kua̱ꞌa̱ ní tíkini̱ xíxaꞌan rí. ");
INSERT INTO mim_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ta ndiꞌi níma̱ ndiva̱ꞌa xa̱ku ndáꞌví ña no̱o̱ ta̱Jesús, káchí ña saá: ―Táná tava ún ndi̱ꞌi̱ ko̱ꞌo̱n ndi̱, ta taxi ún ki̱ꞌvi ndi̱ ini tíkini̱ kaa̱. ");
INSERT INTO mim_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ta ni̱ka̱ꞌa̱n ta̱Jesús saá xíꞌin ña: ―Va̱ꞌa, ¡ki̱ꞌvi ndó ini rí! Ta saá ke̱e ndiꞌi níma̱ ndiva̱ꞌa ña xi̱komí o̱vi̱ ta̱yóꞌo, ta ni̱xaa̱ ña ta ni̱ki̱ꞌvi ña ini ndiꞌi tíkini̱, ta ndiꞌi tíkini̱ xi̱no rí kua̱ꞌa̱n rí, ta sa̱ko̱yo xíꞌin mi̱i rí taꞌvi̱, no̱o̱ ni̱ko̱yo rí ini mi̱ni, ta ni̱ka̱ꞌa̱ ndiꞌi rí ta ni̱xiꞌi̱ ndiꞌi rí. ");
INSERT INTO mim_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ta ni̱vi na ndáa kini̱ xi̱no na kua̱ꞌa̱n na ndato̱ꞌon na xíꞌin nañoo, yukía̱ ndo̱ꞌo kini̱ sa̱na̱ na, ta nda̱to̱ꞌon na yukía̱ ndo̱ꞌo o̱vi̱ ta̱a ta̱ xi̱komí níma̱ ndiva̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ta saá ndiꞌi nañoo ke̱e na kua̱ꞌa̱n na no̱o̱ yóo ta̱Jesús. Tá xi̱ni na ra, ta xa̱ku ndáꞌví na no̱o̱ ra ná kee ra ko̱ꞌo̱n ra inka̱ ñoo. ");
INSERT INTO mim_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ta saá ta̱Jesús nda̱a ra tón barco, ta ndi̱kó ra kua̱ꞌa̱n ra inka̱ xiiña no̱o̱ mi̱ni, ta na̱xaa̱ ra ñoo ra. ");
INSERT INTO mim_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ta saá sava ni̱vi va̱xi na xíꞌin ñii ta̱ ndeé ndóꞌo no̱o̱ ta̱Jesús, kánóo ra no̱o̱ xi̱to, ñíso̱kó na, chi o̱n ki̱ví kanda ra. Tá ta̱Jesús xi̱ni ra ña kándixa na ndí kúndeé ra sandaꞌa ra ta̱táꞌan na, ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱ ndeé ndóꞌo, káchí ra saá: ―Ñani, o̱n kuyi̱ꞌví ún. Vitin xa ki̱sa káꞌno ini i̱ xa̱ꞌa̱ kua̱chi ún ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ta sava na sánáꞌa nda̱yí Ndios xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱Jesús, ta xáni si̱ni̱ na saá: “¿Nda̱chun kándiva̱ꞌa ta̱yóꞌo xíꞌin Ndios? ¿Án xáni ini ra mi̱i ra kúu Ndios?”, káchí na, xáni si̱ni̱ na. ");
INSERT INTO mim_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ta ta̱Jesús xíni̱ ra yukía̱ xáni si̱ni̱ nayóꞌo, ta ni̱ka̱ꞌa̱n ra saá: ―¿Nda̱chun xáni si̱ni̱ ndó ña o̱n váꞌa yóꞌo? ");
INSERT INTO mim_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Yukía̱ yo̱ꞌvi̱ ka̱ ka̱ꞌa̱n i̱ xíꞌin ta̱ o̱n ki̱ví kanda? ¿Án yo̱ꞌvi̱ ka̱ ka̱ꞌa̱n i̱ xíꞌin ra ña ndoo kua̱chi ra? ¿Án yo̱ꞌvi̱ ka̱ ka̱ꞌa̱n i̱ xíꞌin ra ña nakundichi ra, ta ko̱ꞌo̱n xáꞌá ra? ");
INSERT INTO mim_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ta vitin sandaꞌa i̱ ta̱yóꞌo, ta saá kunda̱a̱ ini ndóꞌó ndí yi̱ꞌi̱ kúu ta̱ kómí nda̱yí Ndios ñoyívi yóꞌo ña nakata i̱ kua̱chi ni̱vi ―káchí ta̱Jesús xíꞌin na. Ta saá ni̱ka̱ꞌa̱n ra xíꞌin ta̱ ndeé ndóꞌo: ―Nakundichi ún ta ná kuiso ún xi̱to ún, ta noꞌo̱ ún vitin ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ta na̱kundichi ta̱yóꞌo, ta kua̱noꞌo̱ ra veꞌe ra. ");
INSERT INTO mim_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ndiꞌi na yíta yóꞌo na̱kaꞌnda ní ini na xíto na ndasaá ke̱ta ra kua̱noꞌo̱ ra, ta ki̱sa káꞌno ní na Ndios, chi ta̱xi ra nda̱yí ra ndaꞌa̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ta saá ta̱Jesús ke̱e ra kua̱ꞌa̱n ra, ta xi̱ni ra ñii ta̱a na̱ní ra Mateo, yóo ra kísa chiño ra no̱o̱ káya ra si̱ꞌún xa̱ꞌa̱ nagobierno ñoo Roma. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱Mateo, káchí ra saá: ―Naꞌa, kundiko̱n ún sa̱ta̱ i̱ ―káchí ra xíꞌin ra. Ta saá na̱kundichi ta̱Mateo, ta kua̱ꞌa̱n ra sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tá ni̱xaa̱ ta̱Jesús xíꞌin naxíka xíꞌin ra veꞌe ta̱Mateo, ta ki̱xaa̱ kua̱ꞌa̱ ní na káya si̱ꞌún xa̱ꞌa̱ nagobierno xíꞌin kua̱ꞌa̱ ní inka̱ na kánóo to̱ꞌon ña o̱n váꞌa xa̱ꞌa̱, ta xi̱kundo̱o na xíxi na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ta nafariseo xi̱ni na yu kúu ni̱vi ndóo xíxi xíꞌin ta̱Jesús, ta ni̱ka̱ꞌa̱n na xíꞌin naxíka xíꞌin ta̱Jesús, káchí na saá: ―O̱n vása va̱ꞌa ñayóꞌo. ¿Nda̱chun xíxi ta̱Maestro xíꞌin ni̱vi na káya si̱ꞌún xa̱ꞌa̱ nagobierno, xíꞌin inka̱ na kánóo to̱ꞌon ña o̱n váꞌa xa̱ꞌa̱? ―káchí nafariseo xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ta xi̱ni̱ so̱ꞌo ta̱Jesús yukía̱ ni̱ka̱ꞌa̱n na, ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―Ni̱vi na o̱n vása ndeé ndóꞌo, o̱n vása xíni̱ ñóꞌó nayóꞌo na kasa ta̱ta̱n ñaꞌá, ta ni̱vi na ndeé ndóꞌo kúu na xíni̱ ñóꞌó kutátán. ");
INSERT INTO mim_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Xíni̱ ñóꞌó kunda̱a̱ ini ndó yukía̱ ka̱chí Ndios no̱o̱ to̱ꞌon ra, ña káchí saá: “Kóni i̱ ña kundáꞌví ini ndó koni ndó inka̱ ni̱vi, ta keꞌé ndó ñava̱ꞌa xíꞌin na. Tá o̱n xi̱in ndó kundáꞌví ini ndó koni ndó nayóꞌo, ta saá o̱n vása kusii̱ ini i̱ ña so̱ko̱ ndó ndaꞌa̱ i̱”, ka̱chí Ndios. O̱n si̱ví xa̱ꞌa̱ nani̱vi va̱ꞌa kúu ña ki̱xaa̱ i̱ ñoyívi yóꞌo. Ta xa̱ꞌa̱ nani̱vi o̱n váꞌa kúu ña ki̱xaa̱ i̱, ta kana i̱ na ña nandikó ini na ta kundiko̱n na yichi̱ Ndios ―káchí ta̱Jesús xíꞌin nafariseo. ");
INSERT INTO mim_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ta naxíka xíꞌin ta̱Juan ta̱ sa̱kuchu ni̱vi, ki̱xaa̱ na no̱o̱ ta̱Jesús, ta ni̱nda̱ka̱ to̱ꞌon na ra: ―Kua̱ꞌa̱ ní yichi̱ yóo soꞌon ndi̱, ta yóo soꞌon nafariseo. Ta naxíka xíꞌin mi̱i ún, ¿nda̱chun nda̱ ñii ki̱vi̱ o̱n vása yóo soꞌon na? ");
INSERT INTO mim_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―Tá yóo ñii ta̱a ta̱ tonda̱ꞌa̱, ta ndiꞌi ni̱vi na yóo viko̱ yóꞌo xíxi na, ta o̱n ki̱ví kuchuchú ini na, saá chi yóo ka̱ ta̱yóꞌo xíꞌin na. Ta ki̱vi̱ ña va̱xi o̱n kóo ka̱ ra xíꞌin na. Ta saá kía̱ koo soꞌon na. ");
INSERT INTO mim_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Tá yóo tiko̱to̱ ña yatá, ta nda̱ ñii ni̱vi o̱n sandaꞌa na ña xíꞌin tiko̱to̱ xa̱á, saá chi tá nakata na ña, ta nduu loꞌo ña xa̱á, ta nasita ña tiko̱to̱ yatá, ta kini ka̱ ta̱ꞌnda̱ tiko̱to̱ yatá yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ta vino xa̱á, ta nda̱ ñii ni̱vi o̱n vása taan na rá ini ñii̱ yatá, saá chi ta̱ꞌnda̱ ñii̱ yóꞌo, ta kui̱ta̱ ndiꞌi távino ta ndiꞌi xa̱ꞌa̱ ñii̱. Xíni̱ ñóꞌó taan na távino xa̱á ini ñii̱ xa̱á, ta saá kundeé rá koo rá, ta ñii̱ xa̱á yóꞌo o̱n ta̱ꞌnda̱ ña ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tá káꞌa̱n ta̱Jesús xíꞌin na, ta saá ki̱xaa̱ ñii ta̱ xáꞌnda chiño no̱o̱ nañoo judío, ta ki̱xaa̱ ra xi̱kuxítí ra no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n ra, káchí ra saá xíꞌin ra: ―Tata, sa̱kán ni̱xiꞌi̱ ñáloꞌo sa̱ꞌya i̱. Ná ko̱ꞌo̱n ún xíꞌin i̱ veꞌe i̱, ta ná chinóo ún ndaꞌa̱ ún si̱ni̱ ñá, ta nataku̱ ñá ―káchí ta̱yóꞌo xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ta saá na̱kundichi ta̱Jesús, ta ke̱e ra kua̱ꞌa̱n ra sa̱ta̱ ta̱yóꞌo, ta naxíka xíꞌin ra kua̱ꞌa̱n na xíꞌin ra veꞌe ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ta yóo ñii ñaꞌa̱ kua̱ꞌa̱n ñá xíꞌin ni̱vi na kua̱ꞌa̱n sa̱ta̱ ta̱Jesús. Ta xa u̱xu̱ o̱vi̱ kui̱ya̱ ndeé ní ndóꞌo ñá kue̱ꞌe̱ xíta̱ ni̱i̱. Ta ki̱xaa̱ ñá sa̱ta̱ ta̱Jesús, ta ni̱to̱nda̱a ndaꞌa̱ ñá yuꞌu̱ tiko̱to̱ ra, ");
INSERT INTO mim_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","chi xáni ini ñá saá: “Tá loꞌo kuiti ná to̱nda̱a ndaꞌa̱ yó tiko̱to̱ ra, ta saá nduva̱ꞌa yó”, xáni si̱ni̱ ñá. ");
INSERT INTO mim_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ta ndi̱kó koo ta̱Jesús ta xi̱ni ra ñá, ta káchí ra saá xíꞌin ñá: ―O̱n kuyi̱ꞌví ún, nana. Xa ndu̱va̱ꞌa ún chi kándixa ini ún yi̱ꞌi̱. Ta saá xa̱ndi̱ko̱n ndu̱va̱ꞌa ñá, ta ni̱ya̱a̱ xíta̱ ni̱i̱ ñá. ");
INSERT INTO mim_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ta ni̱xaa̱ ta̱Jesús veꞌe ta̱ xáꞌnda chiño. Ta xi̱ni ra na tívi tila̱lí, ta xi̱ni ra kua̱ꞌa̱ ní ni̱vi ndá síso̱ kúu na, xáku ní na xa̱ꞌa̱ ñáloꞌo ñá ni̱xiꞌi̱. ");
INSERT INTO mim_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Kua̱ꞌa̱n ndiꞌi ndó keꞌé. Ñáloꞌo yóꞌo o̱n vása ní‑xiꞌi̱ ñá, ñá kísi̱n kuiti kúu ñá ―káchí ra. Ta saá ku̱siki na ta̱Jesús ta ni̱xaku̱ ndaa na ra. ");
INSERT INTO mim_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ta ti̱ꞌví ra ndiꞌi ni̱vi kua̱ꞌa̱n na ke̱ꞌe, ta ni̱ki̱ꞌvi ra no̱o̱ kándúꞌu̱ ñáloꞌo, ta ti̱in ra ndaꞌa̱ ñá, ta nda̱koo ñá. ");
INSERT INTO mim_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ta saá ni̱xi̱ta̱ níꞌnó to̱ꞌon xa̱ꞌa̱ ña na̱taku̱ ñáloꞌo yóꞌo ndiꞌi saá ñoo. ");
INSERT INTO mim_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ta ke̱e ta̱Jesús kua̱ꞌa̱n ra, ta o̱vi̱ ta̱kuáá ndíko̱n ra sa̱ta̱ ra kua̱ꞌa̱n ra, ta ndáꞌyi o̱vi̱ saá ta̱kuáá, káchí ra saá: ―Tata, sa̱ꞌya ta̱David, ¡ná kundáꞌví ini ún koni ún ndi̱ꞌi̱! ―káchí o̱vi̱ ta̱kuáá yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tá ni̱ki̱ꞌvi ta̱Jesús ñii veꞌe, ta ki̱xaa̱ o̱vi̱ ta̱kuáá yóꞌo no̱o̱ ra, ta ni̱nda̱ka̱ to̱ꞌon ra o̱vi̱ ta̱yóꞌo, káchí ra xíꞌin ra: ―¿Án kándixa ndó yi̱ꞌi̱ kúchiño i̱ sandaꞌa i̱ ndóꞌó? ―Oon, Tata, kándixa ndi̱ yóꞌó ―káchí o̱vi̱ ta̱kuáá. ");
INSERT INTO mim_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ta saá ni̱to̱nda̱a ndaꞌa̱ ra nduchu̱ no̱o̱ ta̱kuáá yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Xa̱ꞌa̱ ña kándixa ndó yi̱ꞌi̱ saá ndaꞌa ndó vitin. ");
INSERT INTO mim_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ta ndu̱va̱ꞌa o̱vi̱ ra saá, va̱ꞌa na̱koto nduchu̱ no̱o̱ ra. Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Kuenda koo ndó, o̱n ndato̱ꞌon ndó xíꞌin nda̱ ñii ni̱vi ndasaá ndu̱va̱ꞌa ndó. ");
INSERT INTO mim_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ta saá ni, ta̱yóꞌo ke̱e ra ta sa̱kui̱ta̱ níꞌnó ndiꞌi ra to̱ꞌon xa̱ꞌa̱ yukía̱ ke̱ꞌé ta̱Jesús xíꞌin ra ndiꞌi saá ñoo yatin. ");
INSERT INTO mim_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tá ke̱e o̱vi̱ ta̱ xi̱kuu ta̱kuáá kua̱noꞌo̱ ra, ta inka̱ ni̱vi ki̱xaa̱ na no̱o̱ ta̱Jesús xíꞌin ñii ta̱a ta̱ñíꞌí chi kómí ra níma̱ ndiva̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ta ta̱va ta̱Jesús níma̱ ndiva̱ꞌa ña kómí ta̱yóꞌo, ta saá kúchiño kixáꞌá ka̱ꞌa̱n ta̱ xi̱kuu ta̱ñíꞌí. Ta na̱kaꞌnda ní ini ni̱vi na yíta yóꞌo, ta ni̱ka̱ꞌa̱n na, káchí na saá: ―¡Nda̱ ñii yichi̱ o̱n ta̱ꞌán koni ndi̱ ñava̱ꞌa yóꞌo ñoo Israel! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ta nafariseo na xi̱ni yukía̱ ni̱ndoꞌo ta̱ñíꞌí, káchí na saá: ―Ta̱yóꞌo táva ra níma̱ ndiva̱ꞌa xíꞌin ndee̱ ñandiva̱ꞌa káꞌno ña ndíso chiño xíꞌin ndiꞌi ñandiva̱ꞌa ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ta saá kua̱ꞌa̱n ta̱Jesús ndiꞌi saá ñoo náꞌno xíꞌin ñoo válí, ta sánáꞌa ra ni̱vi veꞌe ño̱ꞌo sinagoga, ta káꞌa̱n ndoso ra to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ yichi̱ ña xáꞌnda chiño Ndios, ta saá sándaꞌa ra ni̱vi na xóꞌvi̱ ndiꞌi saá no̱o̱ kue̱ꞌe̱. ");
INSERT INTO mim_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tá xi̱to ra ndiꞌi ni̱vi na ndíko̱n sa̱ta̱ ra, ta kúndáꞌví ní ini ra xíni ra na, chi ndeé ní xóꞌvi̱ na. Ta o̱n ki̱ví chindeé xíꞌin mi̱i na, ta ni o̱n ko̱ó ni̱vi na chindeé ñaꞌá. Nda̱tán yóo ndikachi tí o̱n ko̱ó ta̱a ta̱ ndáa rí, saá yóo ni̱vi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Nda̱tán yóo kui̱ꞌi ña xa yóo tiꞌva nakaya, saá yóo ni̱vi na xa yóo tiꞌva kundiko̱n yi̱ꞌi̱, ta o̱n ko̱ó ni̱vi kasa chiño no̱o̱ i̱ nakaya na nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ta saá kuaku ndáꞌví ndó ndukú ndó no̱o̱ Ndios ña tiꞌví ra inka̱ ni̱vi ña kasa ndivi na chiño ra ñoyívi yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ka̱na ta̱Jesús u̱xu̱ o̱vi̱ naxíka xíꞌin ra, ta ki̱xaa̱ na no̱o̱ ra, ta ta̱xi ra nda̱yí ndaꞌa̱ na ña tava na níma̱ ndiva̱ꞌa ña sáxo̱ꞌvi̱ inka̱ ni̱vi, ta ta̱xi ra nda̱yí ndaꞌa̱ na sandaꞌa na ndiꞌi no̱o̱ kue̱ꞌe̱. ");
INSERT INTO mim_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ta na u̱xu̱ o̱vi̱ ta̱a yóꞌo na̱ní na apóstol. Ta ñii ñii ta̱apóstol yóꞌo na̱ní siꞌa: siꞌna ñii ra na̱ní Simón ta inka̱ ki̱vi̱ ra kúu Pedro; inka̱ ra na̱ní Andrés, ñani ta̱Simón kúu ra; inka̱ ra na̱ní Jacobo, xíꞌin ñani ra ta̱Juan, sa̱ꞌya ta̱Zebedeo kúu o̱vi̱ ta̱yóꞌo; ");
INSERT INTO mim_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","inka̱ ra na̱ní Felipe; inka̱ ra na̱ní Bartolomé; inka̱ ra na̱ní Tomás; inka̱ ra na̱ní Mateo, ta̱yóꞌo xi̱kuu ta̱ na̱kaya si̱ꞌún xa̱ꞌa̱ nagobierno; inka̱ ra na̱ní Jacobo, sa̱ꞌya ta̱Alfeo kúu ra; inka̱ ra na̱ní Lebeo ta inka̱ ki̱vi̱ ra kúu Tadeo; ");
INSERT INTO mim_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","inka̱ ra na̱ní Simón, ta̱ kúu ta̱ ndíko̱n partido na̱ní ña cananeo; inka̱ ra na̱ní Judas Iscariote. Ta̱yóꞌo xi̱kuu ta̱a ta̱ ni̱to̱nda̱a ni̱si̱kó kuíꞌná ta̱Jesús ndaꞌa̱ na sáa̱ ini xíni ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ta ti̱ꞌví ta̱Jesús u̱xu̱ o̱vi̱ naapóstol ko̱ꞌo̱n na ka̱ꞌa̱n ndoso na to̱ꞌon ra, ta káchí ra xíꞌin na saá: ―O̱n ko̱ꞌo̱n ndó no̱o̱ inka̱ ni̱vi na o̱n si̱ví kúu najudío, o̱n ki̱ꞌvi ndó nda̱ ñii ñoo naSamaria. ");
INSERT INTO mim_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ta ko̱ꞌo̱n ndó no̱o̱ najudío ñoo Israel, chi nda̱tán yóo ndikachi tí nda̱ñóꞌó no̱o̱ xitoꞌo rí, saá yóo nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tá kua̱ꞌa̱n ndó, ta ka̱ꞌa̱n ndó xíꞌin na to̱ꞌon yóꞌo, kachí ndó saá: “Xa yóo yatin ní yichi̱ va̱ꞌa ña xáꞌnda chiño Ndios kutaku̱ yó”, kachí ndó xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ta sandaꞌa ndó ni̱vi na ndeé ndóꞌo, ta sanataku̱ ndó ni̱vi na ni̱xiꞌi̱, ta sandaꞌa ndó ni̱vi na ndeé ndóꞌo xíꞌin kue̱ꞌe̱ táꞌyí na̱ní lepra, ta tava ndó níma̱ ndiva̱ꞌa ña saña ña ni̱vi. Ta sa̱níꞌi i̱ ndóꞌó nda̱yí ña kasa ndivi ndó ndiꞌi ñayóꞌo, ta o̱n vása xíni̱ ñóꞌó chaꞌvi ndó ña. Ta saá, tá keꞌé ndó ñava̱ꞌa xíꞌin ni̱vi, ta o̱n ndukú ndó ña chaꞌvi na ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Tá kua̱ꞌa̱n ndó chiño yóꞌo, ta o̱n kuniꞌi ndó si̱ꞌún ko̱ꞌo̱n ndó, ");
INSERT INTO mim_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ni leká ndó, ni inka̱ tiko̱to̱ ndó, ni inka̱ ndu̱xa̱n ndó, ni o̱n kuniꞌi ndó yito̱n. Chi ndóꞌó kómí ndó nda̱yí nakiꞌin ndó ña xíni̱ ñóꞌó no̱o̱ ndó, ndaꞌa̱ ni̱vi na keꞌé ndó ñava̱ꞌa xíꞌin. ");
INSERT INTO mim_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Tá ni̱xaa̱ ndó ñii ñoo káꞌno án ñii ñoo loꞌo, ta nandukú ndó ni̱vi va̱ꞌa; tá naníꞌi ndó na, ta saá kundo̱o ndó veꞌe na nda̱ to̱nda̱a ki̱vi̱ kee ndó ñoo nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tá kua̱ꞌa̱n ki̱ꞌvi ndó veꞌe no̱o̱ kundo̱o ndó yóꞌo, ta ka̱ꞌa̱n ndó to̱ꞌon yóꞌo xíꞌin ni̱vi: “Ná koo ndiꞌi ñava̱ꞌa ini ni̱vi na yóo veꞌe yóꞌo”, kachí ndó. ");
INSERT INTO mim_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tá nayóꞌo nakiꞌin va̱ꞌa na ndóꞌó veꞌe na, ta saá kivi kasa ndivi Ndios ñava̱ꞌa ndu̱kú ndó no̱o̱ ra xa̱ꞌa̱ nayóꞌo. Tá o̱n xi̱in na nakiꞌin va̱ꞌa na ndóꞌó, ta o̱n vása nakiꞌin na ñava̱ꞌa ndu̱kú ndó no̱o̱ Ndios xa̱ꞌa̱ na, ta ñava̱ꞌa yóꞌo ndikó ña sa̱ta̱ mi̱i ndó. ");
INSERT INTO mim_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tá yóo ni̱vi na o̱n xi̱in nakiꞌin va̱ꞌa na ndóꞌó, ta o̱n xi̱in na koni̱ so̱ꞌo na to̱ꞌon ka̱ꞌa̱n ndó, ta saá kee ndó veꞌe na án ñoo na, ta ko̱ꞌo̱n ndó, ta sakisin ndó xa̱ꞌa̱ ndó ña nako̱yo yaa̱. ");
INSERT INTO mim_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ndixa káꞌa̱n i̱ xíꞌin ndó, to̱nda̱a ñii ki̱vi̱ ña kasa nani Ndios xa̱ꞌa̱ kua̱chi ndiꞌi ni̱vi ñoyívi yóꞌo, ta ki̱vi̱ yóꞌo ndeé ka̱ yo̱ꞌvi̱ saxo̱ꞌvi̱ ra nañoo yóꞌo no̱o̱ ni̱vi na o̱n váꞌa na xi̱ndo̱o ñoo Sodoma xíꞌin ñoo Gomorra kui̱ya̱ xi̱na̱ꞌá ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, káchí ra saá: ―Tiꞌví i̱ ndóꞌó ko̱ꞌo̱n ndó ka̱ꞌa̱n ndoso ndó to̱ꞌon i̱ xíꞌin ni̱vi. Ta kasa kuenda ndó, chi nda̱tán ko̱ꞌo̱n ndikachi ma̱ꞌñó tíndiva̱ꞌyí saá ko̱ꞌo̱n ndó, chi yóo ní ni̱vi na máñá na kóni keꞌé ñandiva̱ꞌa xíꞌin ndó. Ta saá ndíchí ní koo ndó no̱o̱ na, ta kuu ndó ni̱vi nanda̱a̱ no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Koto va̱ꞌa ndó no̱o̱ ni̱vi, chi taxi na kua̱chi xa̱ꞌa̱ ndó no̱o̱ na ndíso chiño xíꞌin veꞌe ño̱ꞌo sinagoga, ta kani na ndóꞌó xíꞌin kuártá. ");
INSERT INTO mim_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tiin na ndóꞌó ko̱ꞌo̱n ndó xíꞌin na no̱o̱ nachiño náꞌno án no̱o̱ ta̱rey, ta taxi na kua̱chi xa̱ꞌa̱ ndó no̱o̱ nayóꞌo, chi ndóꞌó kúu na ndíko̱n yichi̱ i̱. Tá kundo̱o ndó no̱o̱ nachiño yóꞌo, ta saá kukomí ndó yichi̱ ka̱ꞌa̱n ndó to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ i̱ xíꞌin nayóꞌo ta xíꞌin inka̱ ni̱vi na o̱n vása kúu najudío. ");
INSERT INTO mim_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Táná tiin na ndóꞌó, ta o̱n kundiꞌi ini ndó xa̱ꞌa̱ to̱ꞌon ña ndakuii̱n ndó, saá chi mi̱i ki̱vi̱ ña kundoꞌo ndó ñayóꞌo, Ndios taxi ra to̱ꞌon ña ka̱ꞌa̱n ndó. ");
INSERT INTO mim_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Chi o̱n si̱ví to̱ꞌon mi̱i ndó kúu ña ka̱ꞌa̱n ndó, saá chi Níma̱ Yivá yó Ndios kúu ña taxi to̱ꞌon ka̱ꞌa̱n ndó xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ki̱vi̱ ña va̱xi sava nata̱a taxi na kua̱chi xa̱ꞌa̱ ñani na no̱o̱ nachiño, ta sava na kúu yivá taxi na kua̱chi xa̱ꞌa̱ sa̱ꞌya na no̱o̱ nachiño. Ta sava na kúu sa̱ꞌya kasa toon na no̱o̱ yivá siꞌí na, ta taxi na kua̱chi xa̱ꞌa̱ mi̱i yivá siꞌí na yóꞌo no̱o̱ nachiño, ta nachiño ka̱ꞌa̱n na, kachí na saá: “Va̱ꞌa, ná kivi̱ nayóꞌo”, kachí na. ");
INSERT INTO mim_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ndiꞌi ni̱vi kusaa̱ ini na koni na ndóꞌó chi na ndíko̱n yichi̱ i̱ kúu ndó. Tá o̱n sandakoo ndó yichi̱ i̱ ta kundiko̱n va̱ꞌa ndó ña, nda̱ no̱o̱ ndi̱ꞌi ña xo̱ꞌvi̱ ndó ñoyívi yóꞌo, ta Ndios saka̱ku ra ndóꞌó ña kutaku̱ ndó xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tá ni̱vi saxo̱ꞌvi̱ na ndóꞌó ñii ñoo, ta saá kama kee ndó ko̱ꞌo̱n ndó inka̱ ñoo. Ndixa káꞌa̱n i̱ xíꞌin ndó, ta nda̱ ta̱ꞌán ndiꞌi ka̱ꞌa̱n ndoso ndó to̱ꞌon Ndios no̱o̱ ndiꞌi saá ñoo Israel, ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndikó tuku i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ñii ta̱ sákuáꞌá, o̱n vása kúu ra ta̱ káꞌno ka̱ no̱o̱ ta̱maestro ra, ta ñii ta̱mozo o̱n vása kúu ra ta̱ káꞌno ka̱ no̱o̱ ta̱ xáꞌnda chiño no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ta ta̱ sákuáꞌá kúchiño nduu ra nda̱tán yóo ta̱maestro ra, ta ta̱mozo kúchiño nduu ra nda̱tán yóo ta̱ xáꞌnda chiño no̱o̱ ra. Ñii ki̱ꞌva saá kundoꞌo ndó xíꞌin i̱ chi ni̱vi ni̱ka̱ꞌa̱n na xa̱ꞌa̱ i̱, sa̱kunaní na yi̱ꞌi̱ Beelzebú, ta ñii ki̱ꞌva saá ka̱ꞌa̱n na xa̱ꞌa̱ ndó, chi ndíko̱n ndó yichi̱ i̱ ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá: ―Ta saá o̱n kuyi̱ꞌví ndó no̱o̱ ni̱vi na kándiva̱ꞌa xíꞌin ndó. Xíni̱ ñóꞌó ka̱ꞌa̱n ndoso ndó xa̱ꞌa̱ i̱ xíꞌin na, chi nda̱tán yóo ña yóo seꞌé, saá yóo to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ i̱. Ta nda̱ ñii ñava̱ꞌa nákaa̱ seꞌé o̱n ki̱ví koo seꞌé ña ndiꞌi saá ki̱vi̱, ta xíni̱ ñóꞌó nati̱vi ña. ");
INSERT INTO mim_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","To̱ꞌon ña káꞌa̱n seꞌé i̱ no̱o̱ naa xíꞌin ndó, ndato̱ꞌon ndó ña xíꞌin ndiꞌi ni̱vi ki̱vi̱ ndiví yéꞌe ño̱ꞌo; ta to̱ꞌon ña káꞌa̱n ya̱a̱ i̱ xíꞌin kuiti ndó, ta kuita ndó si̱ni̱ veꞌe ta ka̱ꞌa̱n ndoso ndó to̱ꞌon yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","O̱n kuyi̱ꞌví ndó no̱o̱ ni̱vi na kóni kaꞌni ndóꞌó, chi o̱n kuchiño na sandiꞌi na xa̱ꞌa̱ níma̱ ndó. Va̱ꞌa ka̱ kuyi̱ꞌví ndó no̱o̱ Ndios, chi Ndios kivi sandiꞌi ra xa̱ꞌa̱ yi̱kí ko̱ñu ndó xíꞌin níma̱ ndó, ta sakana ra ndóꞌó nda̱ya. ");
INSERT INTO mim_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Koto ndó tísaa válí, ñii si̱ꞌún loꞌo kúu yaꞌvi o̱vi̱ rí. Tá o̱n si̱ví ña káchí ini Ndios kúu ña, ta nda̱ ñii tísaa loꞌo o̱n ki̱ví nakava rí no̱o̱ ñoꞌo̱ ta kivi̱ rí, chi Ndios ndáa ra ndiꞌi rí. ");
INSERT INTO mim_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ta ndóꞌó, Ndios ma̱ni̱ ní ka̱ ra ndóꞌó, chi xíni̱ ndiꞌi ra ndasaá kúu yisi̱ si̱ni̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ta ndixa ndáa va̱ꞌa ra ndóꞌó, ña̱kán o̱n kuyi̱ꞌví ndó, chi kua̱ꞌa̱ ní ka̱ ndáya̱ꞌví ndó no̱o̱ tísaa válí ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ta ni̱ka̱ꞌa̱n tuku ta̱Jesús xíꞌin na, káchí ra saá: ―Ni̱vi na ndákuii̱n xa̱ꞌa̱ i̱ no̱o̱ ni̱vi ñoyívi yóꞌo, ta yi̱ꞌi̱ ñii ki̱ꞌva saá ndakuii̱n i̱ xa̱ꞌa̱ na no̱o̱ Yivá i̱ Ndios, ta̱ yóo ñoyívi ni̱no. ");
INSERT INTO mim_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ta ni̱vi na o̱n xi̱in ndakuii̱n xa̱ꞌa̱ i̱, ta yi̱ꞌi̱ o̱n ndakuii̱n i̱ xa̱ꞌa̱ nayóꞌo no̱o̱ Yivá i̱ Ndios, ta̱ yóo ñoyívi ni̱no ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ta ni̱ka̱ꞌa̱n tuku ta̱Jesús, káchí ra saá: ―O̱n kani si̱ni̱ ndó ndí ña kundo̱o va̱ꞌa ndó xíꞌin natáꞌan ndó, kúu ña ki̱xaa̱ i̱ ñoyívi yóꞌo, chi xa̱ꞌa̱ ña nataꞌví i̱ ni̱vi kúu ña ki̱xaa̱ i̱. Nda̱tán yóo ñii espada si̱i̱n táꞌví ña ñii ña̱ꞌa o̱vi̱ ñáꞌño, saá yóo to̱ꞌon i̱. Saá chi sava ni̱vi kándixa na to̱ꞌon i̱, ta inka̱ ni̱vi o̱n vása kándixa na to̱ꞌon i̱. ");
INSERT INTO mim_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sava nata̱a ko̱ꞌo̱n na yichi̱ i̱, ta sava nata̱a sa̱ꞌya na ko̱ꞌo̱n na inka̱ yichi̱. Sava náñaꞌa̱ ko̱ꞌo̱n ná yichi̱ i̱, ta sava náñaꞌa̱ sa̱ꞌya ná ko̱ꞌo̱n ná inka̱ yichi̱. Sava náñaꞌa̱ ko̱ꞌo̱n ná yichi̱ i̱, ta xa̱no ná ko̱ꞌo̱n ná inka̱ yichi̱. Ta saá kunda̱a̱ ini yó ndí o̱n vása kivi koo yuꞌú ni̱vi xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta ni̱vi na o̱n kuaꞌa kutáꞌan xíꞌin ni̱vi na ndíko̱n yichi̱ i̱, kuu ni̱vi natáꞌan mi̱i na na táku̱ veꞌe na. ");
INSERT INTO mim_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ndiꞌi ni̱vi na kóni ko̱ꞌo̱n yichi̱ i̱, xíni̱ ñóꞌó kukiꞌvi ní ka̱ ini na koni na yi̱ꞌi̱ no̱o̱ naveꞌe mi̱i na. Tá ni̱vi kíꞌvi ka̱ ini na xíni na yivá na, án siꞌí na, án sa̱ꞌya na no̱o̱ yi̱ꞌi̱, ta saá nayóꞌo o̱n vása kómí na nda̱yí kundiko̱n na sa̱ta̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ndiꞌi ni̱vi na o̱n xi̱in kuso̱kó tón cruz mi̱i na, ta o̱n xi̱in na kasa ndivi na to̱ꞌon i̱, ta nayóꞌo o̱n vása kómí na nda̱yí kundiko̱n na yichi̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ndiꞌi ni̱vi na ndasaá kuiti ndúkú ña kutaku̱ va̱ꞌa na ñoyívi yóꞌo, ta o̱n xi̱in na xo̱ꞌvi̱ na xa̱ꞌa̱ i̱, ta nayóꞌo o̱n kuchiño na kutaku̱ na xíꞌin Ndios. Ta ni̱vi na o̱n vása ndíꞌi ini ndukú kutaku̱ va̱ꞌa na ñoyívi yóꞌo, xa̱ꞌa̱ ña kundiko̱n na yi̱ꞌi̱, nayóꞌo kúu ni̱vi na kutaku̱ xíꞌin i̱ ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús saá: ―Ndiꞌi ni̱vi na nákiꞌin va̱ꞌa ndóꞌó, chi na ndíko̱n yi̱ꞌi̱ kúu ndó, ta nayóꞌo nákiꞌin va̱ꞌa tuku na yi̱ꞌi̱. Ta ndiꞌi ni̱vi na nákiꞌin va̱ꞌa yi̱ꞌi̱, ta nayóꞌo nákiꞌin va̱ꞌa na Ndios, ta̱ kúu ta̱ ti̱ꞌví yi̱ꞌi̱ va̱xi i̱. ");
INSERT INTO mim_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ndiꞌi ni̱vi na nákiꞌin va̱ꞌa ñii ta̱profeta, chi káꞌa̱n ndoso ra to̱ꞌon Ndios, ta nayóꞌo ñii ki̱ꞌva nakiꞌin na ñava̱ꞌa xíꞌin ta̱profeta ndaꞌa̱ Ndios. Ta ndiꞌi ni̱vi na nákiꞌin va̱ꞌa ñii ta̱va̱ꞌa, chi ta̱va̱ꞌa ní kúu ra, ta nayóꞌo ñii ki̱ꞌva nakiꞌin na ñava̱ꞌa xíꞌin ta̱va̱ꞌa yóꞌo ndaꞌa̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ndiꞌi ni̱vi na táxi loꞌo takuií vi̱xin koꞌo ñii ndóꞌó, chi na ndíko̱n yi̱ꞌi̱ kúu ndó, vará o̱n si̱ví nanáꞌno kúu ndó, ta ndixa káꞌa̱n i̱ xíꞌin ndó, nayóꞌo nakiꞌin na ñava̱ꞌa ndaꞌa̱ Ndios ki̱vi̱ ña va̱xi ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tá ndi̱ꞌi sa̱náꞌa ta̱Jesús u̱xu̱ o̱vi̱ naxíka xíꞌin ra, ta ke̱e ra kua̱ꞌa̱n ra sánáꞌa ra ni̱vi kua̱ꞌa̱ ní ñoo estado Galilea, ta káꞌa̱n ndoso ra to̱ꞌon Ndios xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ta ta̱Juan ta̱a ta̱ sa̱kuchu ni̱vi, nákaa̱ ra ini veꞌe ka̱a, ta xi̱ni̱ so̱ꞌo ra xa̱ꞌa̱ ndiꞌi ñava̱ꞌa kéꞌé ta̱Jesús xíꞌin ni̱vi, ta ti̱ꞌví ra o̱vi̱ naxíka xíꞌin ra kua̱ꞌa̱n na no̱o̱ ta̱Jesús, ta ni̱xaa̱ na no̱o̱ ra, ");
INSERT INTO mim_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ta ni̱nda̱ka̱ to̱ꞌon na ra, káchí na saá: ―¿Án yóꞌó kúu ta̱a ta̱ ndáti ndi̱ tiꞌví Ndios saka̱ku ra na ñoyívi yóꞌo, án kundati ka̱ ndi̱ inka̱ ra? ");
INSERT INTO mim_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ta̱Juan, káchí ra saá: ―Ná ndikó ndó no̱o̱ ta̱Juan, ta ndato̱ꞌon ndó xíꞌin ra ña xíni̱ so̱ꞌo ndó ta ña xíni ndó yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Chi xa xi̱ni ndó ni̱vi na xi̱kuu nakuáá, ta xa va̱ꞌa xíto na vitin. Ta ni̱vi na o̱n vása ní‑kivi kaka, ta vitin xa va̱ꞌa xíka na. Ta ni̱vi na xi̱kuu na ndeé ní ndóꞌo xíꞌin kue̱ꞌe̱ táꞌyí na̱ní lepra, ta vitin xa ndu̱ndii na. Ni̱vi na ka̱ku sóꞌó, ta vitin xa va̱ꞌa xíni̱ so̱ꞌo na. Ta ni̱vi na ni̱xiꞌi̱, na̱taku̱ na. Ta vitin nandáꞌví xíni̱ so̱ꞌo na to̱ꞌon ñava̱ꞌa káꞌa̱n ndoso i̱. Ta ndiꞌi ña xi̱ni̱ so̱ꞌo ndó ta xi̱to ndó kísa ndivi i̱ yóꞌo, saá ndato̱ꞌon ndó xíꞌin ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ta ta̱a ta̱ kándixa yi̱ꞌi̱, tá o̱n sandakoo ra yi̱ꞌi̱, vará o̱n kasa ndivi i̱ chiño ña ndáti ra, ta nákaa̱ ñasi̱i̱ níma̱ ta̱yóꞌo ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ta saá ke̱e na kua̱noꞌo̱ na, ta ta̱Jesús ki̱xáꞌá káꞌa̱n ra xíꞌin ni̱vi na ndóo no̱o̱ ra, káchí ra saá xíꞌin na: ―Ta ki̱vi̱ ni̱xa̱ꞌa̱n ndó xi̱to ndó ta̱Juan no̱o̱ yuku̱ yi̱chí, ¿yukía̱ ndáti ndó koto ndó? ¿Án ndáti ndó koto ndó ñii tón toyo̱ó tón kísin ní, kísa ta̱chi̱? Óꞌon, o̱n si̱ví saá. ");
INSERT INTO mim_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Án káꞌán ndó koto ndó ñii ta̱a ta̱ va̱ꞌa ní tiko̱to̱ ndíxin? Óꞌon, chi ni̱vi nakuíká na va̱ꞌa ní tiko̱to̱ ndíxin o̱n vása ndóo na yuku̱ yi̱chí, nayóꞌo ndóo na veꞌe náꞌno ña livi ní. ");
INSERT INTO mim_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Án ni̱xa̱ꞌa̱n ndó xi̱to ndó ñii ta̱profeta? Saá va, ta̱Juan kúu ñii ta̱profeta ndinoꞌo, ta káꞌno ní ka̱ chiño ki̱sa ndivi ta̱Juan no̱o̱ chiño ki̱sa ndivi inka̱ naprofeta na ni̱ka̱ꞌa̱n ndoso to̱ꞌon Ndios xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ta kui̱ya̱ ni̱yaꞌa ñii ta̱profeta ni̱taa ra to̱ꞌon Ndios xa̱ꞌa̱ ta̱Juan, to̱ꞌon Ndios ña káchí saá: Ta̱yóꞌo kuu ta̱ xíka chiño no̱o̱ i̱, ta tiꞌví i̱ ra ko̱ꞌo̱n siꞌna ra no̱o̱ ta̱Káꞌno ta̱ tiꞌví i̱ ñoyívi. Ta ndasa va̱ꞌa ra yichi̱ ña ko̱ꞌo̱n ta̱Káꞌno ta̱ tiꞌví i̱ saka̱ku ni̱vi ñoyívi, saá ni̱ka̱ꞌa̱n Ndios xa̱ꞌa̱ ta̱Juan xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ta ni̱ka̱ꞌa̱n tuku ta̱Jesús xíꞌin na, káchí ra saá: ―Ñandixa káꞌa̱n i̱ xíꞌin ndó, o̱n ko̱ó inka̱ ta̱profeta káꞌno ka̱ no̱o̱ ta̱Juan, ta̱ sa̱kuchu ni̱vi. Ta saá ni, ta̱a ta̱ ni̱no̱ ní ka̱ yóo no̱o̱ ndiꞌi inka̱ ni̱vi na nákiꞌin yichi̱ ña xáꞌnda chiño Ndios, ta ta̱yóꞌo kúu ta̱ káꞌno ka̱ no̱o̱ ta̱Juan ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ta ni̱ka̱ꞌa̱n tuku ra saá xíꞌin na: ―Nda̱ ki̱vi̱ ki̱xáꞌá ta̱Juan káꞌa̱n ndoso ra to̱ꞌon Ndios ta̱nda̱ vitin, yóo ni̱vi na chíkaa̱ ndee̱ ndiva̱ꞌa ña sandiꞌi na xa̱ꞌa̱ yichi̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yóo nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá, ta yóo to̱ꞌon Ndios ña ni̱taa inka̱ naprofeta. Ta ndiꞌi ñayóꞌo ni̱ka̱ꞌa̱n ña yu kúu ña koo nda̱ xi̱na̱ꞌá ta̱nda̱ ki̱vi̱ ki̱xáꞌá ni̱ka̱ꞌa̱n ndoso ta̱Juan, ta̱a ta̱ sa̱kuchu ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","To̱ꞌon Ndios xi̱na̱ꞌá káchí ña ndí ta̱profeta Elías ndikó ra ñoyívi yóꞌo ki̱vi̱ ta̱ꞌán ka̱ kixaa̱ ta̱ tiꞌví Ndios saka̱ku na ñoyívi yóꞌo. Xíni̱ ñóꞌó kunda̱a̱ ini ndó ndí xa ku̱ndivi to̱ꞌon yóꞌo, saá chi nda̱tán ni̱xi̱yo ta̱Elías saá yóo ta̱Juan, ta̱a ta̱ sa̱kuchu ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ndiꞌi ndóꞌó ni̱vi na yóo so̱ꞌo, xíni̱ ñóꞌó chikaa̱ so̱ꞌo ndó ña káꞌa̱n i̱ xíꞌin ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ta ni̱ka̱ꞌa̱n tuku ra saá xíꞌin na: ―¿Ndasaá yóo ni̱vi na ndóo ñoyívi yóꞌo vitin? Nda̱tán yóo naválí na sásíki no̱yáꞌvi, saá yóo na. Sava naválí káꞌa̱n na xíꞌin inka̱ naválí táꞌan na, ");
INSERT INTO mim_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","káchí na saá: “Tá ti̱vi ndi̱ música livi xa̱ꞌa̱ ndó, ta ni̱‑xiin ndó kata xáꞌá ndó. Tá xi̱ta ndi̱ yaa ndáꞌya ní ña xíta na no̱o̱ ndúxu̱n na ni̱xiꞌi̱, ta ni̱‑xiin ndó kuaku ndó”, káchí naválí. ");
INSERT INTO mim_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nda̱tán yóo naválí yóꞌo, saá yóo ndó, chi ta̱Juan o̱n vása ní‑xixi va̱ꞌa ra, ta nda̱ ñii ki̱vi̱ o̱n vása ní‑xiꞌi ra vino, ta káchí ndó xa̱ꞌa̱ ra: “Ta̱yóꞌo kómí ra níma̱ ndiva̱ꞌa.” ");
INSERT INTO mim_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ki̱xaa̱ i̱ ñoyívi yóꞌo, ta xíxi va̱ꞌa i̱, ta xíꞌi i̱ vino, ta káchí ndó saá xa̱ꞌa̱ i̱: “Ta ndeé ní xíxi ra, ta kua̱ꞌa̱ ní xíꞌi ra. Ta kúsii̱ ní ini ra xíka ra xíꞌin na káya si̱ꞌún xa̱ꞌa̱ nagobierno, xíꞌin inka̱ ni̱vi na kánóo o̱n váꞌa to̱ꞌon xa̱ꞌa̱”, saá káchí ndó xa̱ꞌa̱ i̱. Ta ndiꞌi ni̱vi na kómí ñandíchí Ndios, kúu na kéꞌé ñava̱ꞌa, ta ñayóꞌo sánáꞌa ndí ñandíchí Ndios kúu ñanda̱a̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ta saá ki̱xáꞌá ta̱Jesús ni̱ka̱ꞌa̱n ndoso ra to̱ꞌon yo̱ꞌvi̱ ña sáa̱ ra no̱o̱ nañoo no̱o̱ ke̱ꞌé ra kua̱ꞌa̱ ní milagro xíꞌin ni̱vi, saá chi ni̱‑xiin na ndikó koo ini na ña sandakoo na ña o̱n váꞌa kéꞌé na. Ni̱ka̱ꞌa̱n ra xíꞌin nani̱vi ñoo yóꞌo, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Ndáꞌví ní ndó, ni̱vi nañoo Corazín! ¡Ndáꞌví ní ndó, ni̱vi nañoo Betsaida! Chi va̱xi ñii ki̱vi̱ ña xo̱ꞌvi̱ ní ndó. Saá chi kui̱ya̱ xi̱na̱ꞌá tá ní xini ví nañoo Tiro xíꞌin nañoo Sidón milagro ña kéꞌé i̱ xíꞌin ndó vitin, níkúu, ta nandikó ní ka̱ ini nayóꞌo, ta nakundixin na tiko̱to̱ ndayí no̱o̱, ta chikaa̱ na yaa̱ noꞌo̱ si̱ni̱ na ña kúchuchú ní ini na xa̱ꞌa̱ kua̱chi na. ");
INSERT INTO mim_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ta ndixa káꞌa̱n i̱ xíꞌin ndó, to̱nda̱a ñii ki̱vi̱ ña kasa nani Ndios xa̱ꞌa̱ kua̱chi ndiꞌi na ñoyívi yóꞌo, ta ki̱vi̱ yóꞌo xo̱ꞌvi̱ ní ndóꞌó, nañoo Corazín xíꞌin nañoo Betsaida. Ndeé ka̱ yo̱ꞌvi̱ saxo̱ꞌvi̱ Ndios ndóꞌó no̱o̱ ni̱vi na o̱n váꞌa na xi̱ndo̱o ñoo Tiro xíꞌin ñoo Sidón. ");
INSERT INTO mim_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ta ndóꞌó, nañoo Capernaum, ¿án xáni si̱ni̱ ndó kanóo va̱ꞌa ní to̱ꞌon ndó nda̱ ñoyívi ni̱no? ¡O̱n vása! Ta ndáꞌví ní ndó, chi Ndios tiꞌví ra ndóꞌó ko̱ꞌo̱n ndó ni̱no̱, nda̱ nda̱ya. Saá chi kui̱ya̱ xi̱na̱ꞌá tá ní xini ví nañoo Sodoma milagro ña kéꞌé i̱ xíꞌin ndó vitin, ta nañoo Sodoma o̱n ndiꞌi xa̱ꞌa̱ na, níkúu. ");
INSERT INTO mim_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ta ndixa káꞌa̱n i̱ xíꞌin ndó, to̱nda̱a ñii ki̱vi̱ ña kasa nani Ndios xa̱ꞌa̱ kua̱chi ndiꞌi ni̱vi ñoyívi yóꞌo, ta ki̱vi̱ yóꞌo xo̱ꞌvi̱ ní ndóꞌó, nañoo Capernaum. Ndeé ka̱ yo̱ꞌvi̱ saxo̱ꞌvi̱ Ndios ndóꞌó no̱o̱ ni̱vi na o̱n váꞌa na xi̱ndo̱o ñoo Sodoma ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ta saá ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin Ndios, káchí ra saá: ―Tata Yivá i̱, kísa káꞌno i̱ yóꞌó. Yóꞌó kúu ta̱Káꞌno ta̱ xáꞌnda chiño no̱o̱ ndiꞌi ña yóo ñoyívi yóꞌo xíꞌin ña yóo ñoyívi ni̱no. Kísa káꞌno i̱ yóꞌó chi xa sa̱náꞌa ún nayóꞌo, na ni̱no̱ ini kúu na, ta kúnda̱a̱ ini na ñava̱ꞌa xa̱ꞌa̱ ún. Ta chi̱seꞌé ún ñava̱ꞌa yóꞌo no̱o̱ inka̱ ni̱vi na na̱ní nandíchí, xíꞌin na na̱ní na káꞌvi ta tiꞌva ní yóo ñoyívi yóꞌo, ");
INSERT INTO mim_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","chi saá káchí ini ún keꞌé ún xíꞌin ndiꞌi ni̱vi, Tata ―káchí ta̱Jesús xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ni̱vi, káchí ra saá: ―Yivá i̱ Ndios ta̱xi ra ndiꞌi ñava̱ꞌa ndaꞌa̱ i̱. Nda̱ ñii ni̱vi o̱n vása xíni̱ na ini yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya Ndios, ta ñii la̱á mi̱i Ndios kúu ta̱ xíni̱ va̱ꞌa ini yi̱ꞌi̱. Ta nda̱ ñii ni̱vi o̱n vása xíni̱ na ini Yivá i̱ Ndios, ta ñii la̱á yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya ra, kúu ta̱ xíni̱ ini ra, ta ni̱vi na na̱ka̱xin i̱ taxi i̱ koni̱ na ini ra. ");
INSERT INTO mim_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ndiꞌi ndóꞌó ni̱vi na xa kúnaa̱ ní no̱o̱ ndiꞌi chiño, ta veé ní ndíso ndó, naꞌa ndó no̱o̱ i̱, ta yi̱ꞌi̱ taxi i̱ ña nakindée ndó. ");
INSERT INTO mim_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nakuiso ndó xíꞌin i̱ ña ndíso i̱ ta kasa chiño ndó xíꞌin i̱, ta kandixa ini ndó yi̱ꞌi̱, ta sakuáꞌá ndó yichi̱ i̱, chi ta̱a ta̱ ya̱a̱ ini ta̱ ndáꞌví ini kúu i̱, ta saá naníꞌi ndó ña koo va̱ꞌa ini ndó, ta nakindée níma̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Saá chi ña nakuiso ndó xíꞌin i̱ ta ña kasa chiño ndó xíꞌin i̱, o̱n vása yo̱ꞌvi̱ ní ña, ta ni o̱n vása veé ní chiño yóꞌo ―káchí ta̱Jesús xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ñii ki̱vi̱ yi̱i̱ ña nákindée najudío, ta ta̱Jesús xíꞌin naxíka xíꞌin ra kua̱ꞌa̱n na yáꞌa na ma̱ꞌñó no̱o̱ yóo yita trigo. Ta naxíka xíꞌin ta̱Jesús ki̱xáꞌá na xíꞌi̱ ní na so̱ko, ta saá xa̱ꞌnda na yoko̱ ta ki̱ndaa na so̱o̱ trigo, ta xa̱xi na trigo. ");
INSERT INTO mim_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ta xi̱ni nafariseo ña ke̱ꞌé nayóꞌo, ta ni̱ka̱ꞌa̱n na saá xíꞌin ta̱Jesús: ―Naxíka xíꞌin ún ni̱yaꞌa ndoso na nda̱yí Ndios chi xa̱ꞌnda na trigo, ta o̱n váꞌa kasa chiño yó ki̱vi̱ yi̱i̱ ña nákindée yó, káchí nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin na: ―¿Án o̱n vása ní‑kaꞌvi ndó to̱ꞌon Ndios no̱o̱ káꞌa̱n ña xa̱ꞌa̱ xi̱i̱ síkuá yó ta̱rey David xíꞌin natáꞌan ra, ki̱vi̱ ni̱xiꞌi̱ ní na so̱ko? ");
INSERT INTO mim_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Saá chi kui̱ya̱ xi̱na̱ꞌá ni̱ki̱ꞌvi nayóꞌo ini veꞌe Ndios, ta xi̱xi na si̱ta̱ va̱ꞌa ñayi̱i̱ vará o̱n si̱ví su̱tu̱ xi̱kuu na. Ta káchí nda̱yí Ndios saá: “Ndasaá su̱tu̱ kuiti kúchiño kuxu si̱ta̱ va̱ꞌa ñayi̱i̱.” ");
INSERT INTO mim_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ta xa ka̱ꞌvi ndó nda̱yí Ndios ña káꞌa̱n o̱n ki̱ví kasa chiño yó ki̱vi̱ yi̱i̱ ña nákindée yó. Ta nasu̱tu̱ kísa ndivi na chiño veꞌe ño̱ꞌo káꞌno ki̱vi̱ yi̱i̱ ña nákindée yó, ta o̱n ko̱ó kua̱chi ndíso na xa̱ꞌa̱ ñayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ta ndixa káꞌa̱n i̱ xíꞌin ndó, yi̱ꞌi̱ kúu ta̱a ta̱ kómí ní ka̱ nda̱yí no̱o̱ veꞌe ño̱ꞌo káꞌno. ");
INSERT INTO mim_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","To̱ꞌon Ndios káchí ña saá: “Kóni i̱ ña kundáꞌví ini ndó koni ndó inka̱ ni̱vi, ta keꞌé ndó ñava̱ꞌa xíꞌin na. Tá o̱n xi̱in ndó kundáꞌví ini ndó koni ndó nayóꞌo, ta saá o̱n vása kusii̱ ini i̱ ña sóko̱ ndó ndaꞌa̱ i̱”, ka̱chí Ndios. Tá va̱ꞌa ná kunda̱a̱ ini ndó to̱ꞌon yóꞌo, níkúu, ta saá o̱n chikaa̱ kua̱chi ini ndó koni ndó ni̱vi na o̱n ko̱ó kua̱chi kómí. ");
INSERT INTO mim_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, kómí i̱ nda̱yí ka̱ꞌa̱n i̱ yukía̱ va̱ꞌa keꞌé yó ki̱vi̱ yi̱i̱ ña nákindée yó ―káchí ta̱Jesús xíꞌin nafariseo. ");
INSERT INTO mim_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ta ke̱e ta̱Jesús kua̱ꞌa̱n ra, ta ni̱ki̱ꞌvi ra veꞌe ño̱ꞌo sinagoga. ");
INSERT INTO mim_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta yóo ñii ta̱a, ta̱ yi̱chí ndaꞌa̱ kúu ra, ta o̱n vása kánda ña. Ta ndóo nafariseo xíto na yu kúu ñii ña o̱n váꞌa keꞌé ta̱Jesús, ña kuchiño chikaa̱ na kua̱chi sa̱ta̱ ra. Ta saá ni̱nda̱ka̱ to̱ꞌon na ra: ―¿Yukía̱ káchí nda̱yí Ndios ña kándixa yó? ¿Án kúchiño sandaꞌa yó ni̱vi ki̱vi̱ yi̱i̱ ña nákindée yó? ");
INSERT INTO mim_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Tá ñii ndóꞌó kómí ndó ñii ndikachi sa̱na̱ ndó, ta nákava rí ñii yavi̱ kónó ki̱vi̱ yi̱i̱ ña nákindée yó, ta, ¿yukía̱ keꞌé ndó? ¿Án o̱n ko̱ꞌo̱n ndó tava ndó kiti̱ sa̱na̱ ndó tí na̱kava? ");
INSERT INTO mim_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Ta kua̱ꞌa̱ ní ka̱ ndáya̱ꞌví ñii ta̱a no̱o̱ ñii kiti̱ sa̱na̱ yó! Ta ndixa ñava̱ꞌa kúu ña keꞌé yó chiño va̱ꞌa ki̱vi̱ yi̱i̱ ña nákindée yó. ");
INSERT INTO mim_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱a ta̱ yi̱chí ndaꞌa̱: ―Sanakaa̱ ún ndaꞌa̱ ún vitin ―káchí ra. Ta ta̱yóꞌo sa̱nakaa̱ ra ndaꞌa̱ ra, ta ndu̱va̱ꞌa ña. Nda̱tán yóo inka̱ ndaꞌa̱ ra ña va̱ꞌa, saá ki̱ndo̱o ña. ");
INSERT INTO mim_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ta ke̱e nafariseo kua̱ꞌa̱n na, ta ki̱xáꞌá na káꞌa̱n na xíꞌin táꞌan na ndasaá koo kaꞌni na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ta ta̱Jesús xíni̱ ra yukía̱ xáni ini nafariseo, ta ke̱ta ra veꞌe ño̱ꞌo sinagoga ta kua̱ꞌa̱n ra. Ta kua̱ꞌa̱ ní ni̱vi xi̱kundiko̱n na sa̱ta̱ ra, ta saá sa̱ndaꞌa ra ndiꞌi na ndeé ndóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―O̱n ka̱ꞌa̱n ndó xíꞌin nda̱ ñii ni̱vi xa̱ꞌa̱ ña kéꞌé i̱. ");
INSERT INTO mim_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ñayóꞌo ni̱ka̱ꞌa̱n ra, ta saá ku̱ndivi to̱ꞌon ña ni̱ka̱ꞌa̱n Ndios xíꞌin ta̱profeta Isaías xi̱na̱ꞌá. Ta to̱ꞌon yóꞌo ni̱taa ta̱Isaías ña ni̱ka̱ꞌa̱n Ndios xa̱ꞌa̱ ta̱a ta̱ tiꞌví ra saka̱ku ni̱vi ñoyívi yóꞌo, káchí ña saá: ");
INSERT INTO mim_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yóꞌo yóo ta̱a ta̱ na̱ka̱xin i̱ ña kasa chiño ra no̱o̱ i̱, ta kíꞌvi ní ini i̱ xíni i̱ ra, ta kúsii̱ ní ini i̱ xíni i̱ ra. Ta nataxi i̱ Níma̱ i̱ ini ra, ta saá ka̱ꞌa̱n ndoso ra ñanda̱a̱ xíꞌin ndiꞌi ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","O̱n na̱a ra, ta ni o̱n kutee ra, ta o̱n nda̱ꞌyi ndaa ra xíꞌin nda̱ ñii ni̱vi. Ta o̱n nda̱ꞌyi ra ko̱ꞌo̱n ra yichi̱ ña koni̱ so̱ꞌo ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nda̱tán yóo ñii ta̱a ta̱ o̱n vása kaꞌno ka̱ ñii tón tamá táꞌnó chi tón xa táꞌnó kúu nó, saá yóo ta̱a ta̱ na̱ka̱xin i̱, ta nda̱tán yóo ñii ta̱a ta̱ o̱n vása ndaꞌva ka̱ ñii tímá tón xa kána ñi̱ꞌma̱ yiꞌva̱, saá yóo ta̱a ta̱ na̱ka̱xin i̱, chi ta̱ kundáꞌví ini kuu ra koni ra ni̱vi nandáꞌví na vitá ini, na o̱n ki̱ví chindeé xíꞌin mi̱i, a̱nda̱ kundeé ra no̱o̱ ndiꞌi ña o̱n váꞌa ta chinóo síkón ra ñava̱ꞌa ñanda̱a̱. ");
INSERT INTO mim_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ta ndiꞌi ni̱vi na ñoyívi yóꞌo xíꞌin ndinoꞌo níma̱ na kundati na ra ña keꞌé ra ñava̱ꞌa ta saka̱ku ra na, ka̱chí Ndios, ni̱taa ta̱Isaías xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ta ni̱vi kua̱ꞌa̱n na ña kua̱ꞌa̱n ñii ta̱a ta̱ kómí níma̱ ndiva̱ꞌa xíꞌin na no̱o̱ ta̱Jesús, ta ki̱xaa̱ na no̱o̱ yóo ra. Ta̱a ta̱ ndeé ndóꞌo yóꞌo kúu ra ta̱kuáá ta ñíꞌí ra, ta ta̱Jesús sa̱ndaꞌa ñaꞌá ra, ta saá kúchiño nakoto ra ta naka̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ta ndiꞌi ni̱vi na ndóo yóꞌo na̱kaꞌnda ní ini na xi̱ni na ña ke̱ꞌé ta̱Jesús, ta ni̱ka̱ꞌa̱n na, káchí na saá: ―¿Án ta̱yóꞌo kúu ta̱sa̱ꞌya ñani síkuá ta̱David, ta̱ ndáti yó tiꞌví Ndios kixaa̱? ");
INSERT INTO mim_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ta xi̱ni̱ so̱ꞌo nafariseo ña ni̱ka̱ꞌa̱n ni̱vi yóꞌo, ta saá ni̱ka̱ꞌa̱n táꞌan na: ―Xíꞌin ndee̱ ñaBeelzebú, ña kúu ñakáꞌno no̱o̱ ndiꞌi níma̱ ndiva̱ꞌa, táva ta̱yóꞌo níma̱ ndiva̱ꞌa ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ta ta̱Jesús xíni̱ ra ndiꞌi ña xáni ini nafariseo, ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―Tá yóo ñii ñoo, ta o̱n vása yóo yuꞌú ni̱vi, ta na̱ta̱ꞌvi̱ táꞌan na, ta ki̱xáꞌá na káni táꞌan na xíꞌin natáꞌan na, ta kama ní ndiꞌi xa̱ꞌa̱ ñoo yóꞌo. Tá yóo ñii veꞌe no̱o̱ na̱ta̱ꞌvi̱ táꞌan na, ta káni táꞌan na, ta ndiꞌi xa̱ꞌa̱ ni̱vi veꞌe yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tá ñaníma̱ ndiva̱ꞌa káꞌno Satanás nátava ña ini ni̱vi níma̱ ndiva̱ꞌa táꞌan ña, níkúu, ta saá na̱ta̱ꞌvi̱ táꞌan ñandiva̱ꞌa ta káni táꞌan ña xíꞌin táꞌan ña, ta ya̱chi̱ ní ndiꞌi xa̱ꞌa̱ yichi̱ ña. ");
INSERT INTO mim_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mi̱i ndó káꞌa̱n ndó ndí xíꞌin ndee̱ ñaníma̱ ndiva̱ꞌa káꞌno táva i̱ ñandiva̱ꞌa. Tá ndixa saá xáni ini ndó, ta na ndíko̱n sa̱ta̱ ndó na táva ñandiva̱ꞌa, ¿míchí va̱xi ndee̱ nayóꞌo táva na ñandiva̱ꞌa? Na ndíko̱n sa̱ta̱ ndó kachí na o̱n si̱ví ndee̱ ñaníma̱ ndiva̱ꞌa káꞌno kúu ña kómí na kivi tava na ñandiva̱ꞌa. Ta saá kixaa̱ ñii ki̱vi̱ na ndíko̱n sa̱ta̱ mi̱i ndó yóꞌo kuu na kasa nani xa̱ꞌa̱ kua̱chi ndíso ndó chi ñavatá káꞌa̱n ndó xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ta yi̱ꞌi̱, kómí i̱ ndee̱ Níma̱ Ndios ña tava i̱ níma̱ ndiva̱ꞌa, ta ña kéꞌé i̱ yóꞌo káchí ña saá: vitin ki̱xaa̱ ki̱vi̱ ña kíxáꞌá xáꞌnda chiño Ndios no̱o̱ ni̱vi ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ta yóo ñii ta̱a ndeé ní ndaku, ta ni̱vi o̱n kúchiño ki̱ꞌvi na veꞌe ra ña kindaa na ñakuíká kómí ra. Siꞌna xíni̱ ñóꞌó katón na ra, ta saá kuchiño ki̱ꞌvi na kindaa na ndiꞌi ñakuíká kómí ra. Nda̱tán yóo ta̱a ndeé ní ndaku yóꞌo, saá yóo ñaníma̱ ndiva̱ꞌa káꞌno. ");
INSERT INTO mim_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ndiꞌi ni̱vi na o̱n vása yóo yuꞌú xíꞌin i̱, nayóꞌo kúu na o̱n xi̱in koni na yi̱ꞌi̱. Ta ndiꞌi ni̱vi na o̱n vása chíndeé yi̱ꞌi̱ nakaya na ni̱vi ña kundiko̱n na yichi̱ Ndios, nayóꞌo kúu na sákui̱ta̱ níꞌnó ni̱vi ña o̱n kundiko̱n na yichi̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Ta ndixa káꞌa̱n i̱ xíꞌin ndó, Ndios kúchiño kasa káꞌno ini ra xa̱ꞌa̱ ndiꞌi ña o̱n váꞌa kéꞌé ni̱vi, ta kúchiño kasa káꞌno ini ra xa̱ꞌa̱ ndiꞌi to̱ꞌon ña káꞌa̱n ndiva̱ꞌa na xíꞌin Ndios. Ta ndiꞌi ni̱vi na káꞌa̱n ndiva̱ꞌa xíꞌin Níma̱ Ndios, ta Ndios o̱n kasa káꞌno ini ra xa̱ꞌa̱ ni̱vi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ta ni̱vi na káꞌa̱n ndiva̱ꞌa xíꞌin yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ta Ndios kúchiño kasa káꞌno ini ra xa̱ꞌa̱ na. Ta ni̱vi na káꞌa̱n ndiva̱ꞌa xíꞌin Níma̱ Ndios, ta Ndios o̱n kasa káꞌno ini ra xa̱ꞌa̱ nayóꞌo vitin, ni ndiꞌi saá kui̱ya̱ ña va̱xi ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, káchí ra saá: ―Tá yóo yito̱n tón va̱ꞌa, ta saá kóon kui̱ꞌi tí va̱ꞌa ndaꞌa̱ nó. Tá yóo yito̱n tón o̱n váꞌa, ta saá kóon kui̱ꞌi tí o̱n váꞌa ndaꞌa̱ nó. Tá xíto ndoso ndó kui̱ꞌi tí yóo ndaꞌa̱ yito̱n, ta saá kunda̱a̱ ini ndó án tón va̱ꞌa kúu nó, án tón o̱n váꞌa kúu nó. Nda̱tán yóo yito̱n, saá yóo ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ta ndóꞌó, káꞌa̱n i̱ xíꞌin ndó, ¡sa̱ꞌya ko̱o̱ xati̱ kúu ndó! Chi mi̱i ndó kúu ni̱vi na o̱n váꞌa, ta ña̱kán o̱n kúchiño ka̱ꞌa̱n ndó to̱ꞌon va̱ꞌa. Nda̱tán yóo níma̱ ni̱vi, saá yóo to̱ꞌon ña káꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ni̱vi na kómí níma̱ va̱ꞌa, káꞌa̱n na to̱ꞌon va̱ꞌa. Ta ni̱vi na kómí níma̱ o̱n váꞌa, káꞌa̱n na to̱ꞌon o̱n váꞌa. ");
INSERT INTO mim_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ta káꞌa̱n i̱ xíꞌin ndó, kixaa̱ ñii ki̱vi̱ ña kasa nani Ndios xa̱ꞌa̱ ndiꞌi ni̱vi ñoyívi yóꞌo, ta koni̱ ñóꞌó ndiꞌi ni̱vi taxi na kuenda xa̱ꞌa̱ ndiꞌi to̱ꞌon ña o̱n váꞌa ni̱ka̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chi xa̱ꞌa̱ to̱ꞌon mi̱i ndó ña ni̱ka̱ꞌa̱n ndó, Ndios kasa nani ra xa̱ꞌa̱ ndóꞌó, ta saá ka̱ꞌa̱n ra án kundo̱o ndó xíꞌin ra, án ko̱ꞌo̱n ndó nda̱ya ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ta sava nafariseo xíꞌin na sánáꞌa nda̱yí Ndios ni̱ka̱ꞌa̱n na xíꞌin ta̱Jesús, káchí na saá: ―Tata maestro, kóni ndi̱ ña keꞌé ún ñii milagro no̱o̱ ndi̱. ");
INSERT INTO mim_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ta nda̱kuii̱n ta̱Jesús: ―¡Ni̱vi na ndiva̱ꞌa ní ini, na o̱n vása kándixa Ndios kúu ndóꞌó! Saá chi ndúkú ndó ñii milagro no̱o̱ i̱ ña kandixa ndó ndí ta̱a ta̱ ki̱xi no̱o̱ Ndios kúu i̱. Ta o̱n keꞌé i̱ inka̱ milagro ña koto ndó, chi va̱ꞌa ka̱ xíni̱ ñóꞌó kunda̱a̱ ini ndó ña ni̱ndoꞌo ta̱profeta Jonás kui̱ya̱ xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ta ta̱Jonás xi̱nakaa̱ ra u̱ni̱ ndiví, ta u̱ni̱ ñoó ti̱xin títia̱ká káꞌno. Ta saá yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, kunakaa̱ i̱ u̱ni̱ ndiví, ta u̱ni̱ ñoó ti̱xin ñoꞌo̱. ");
INSERT INTO mim_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tá kixaa̱ ki̱vi̱ kasa nani Ndios xa̱ꞌa̱ ni̱vi ñoyívi yóꞌo, ta nañoo Nínive chikaa̱ na kua̱chi sa̱ta̱ ndóꞌó na táku̱ vitin. Saá chi xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱Jonás xíꞌin na, ta na̱ndikó ini na ta ka̱ndixa na Ndios. Ta yi̱ꞌi̱, ta̱a ta̱ yóo xíꞌin ndó vitin, kúu ñii ta̱káꞌno ka̱ no̱o̱ ta̱Jonás, ta o̱n xi̱in ndó koni̱ so̱ꞌo ndó ña káꞌa̱n i̱. ");
INSERT INTO mim_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tá kixaa̱ ki̱vi̱ kasa nani Ndios xa̱ꞌa̱ ni̱vi ñoyívi yóꞌo, ta saá tuku ñii ñáreina, ñá ni̱xaꞌnda chiño no̱o̱ ñoo na̱ní Sabá xi̱na̱ꞌá, chikaa̱ ñá kua̱chi sa̱ta̱ ndóꞌó na táku̱ vitin. Chi ñáreina yóꞌo xíká ní ni̱xa̱ꞌa̱n ñá xi̱ni̱ so̱ꞌo ñá to̱ꞌon ña ni̱ka̱ꞌa̱n ta̱rey Salomón, chi ta̱ ndíchí ní si̱ni̱ xi̱kuu ra. Ta yi̱ꞌi̱, ta̱a ta̱ yóo xíꞌin ndó vitin, kúu ñii ta̱káꞌno ka̱ no̱o̱ ta̱Salomón, ta o̱n xi̱in ndó koni̱ so̱ꞌo ndó to̱ꞌon ña káꞌa̱n i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Tá ñii níma̱ ndiva̱ꞌa sáña ña ñii ta̱a, ta saá kua̱ꞌa̱n ña no̱o̱ yuku̱ yi̱chí ña nandukú ña no̱o̱ nakindée ña. Tá o̱n vása náníꞌi ña no̱o̱ nakindée ña, ");
INSERT INTO mim_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ta xáni ini ña saá: “Ndikó yó ndi̱ꞌvi yó ini ta̱a no̱o̱ ke̱e yó va̱xi yó”, káchí ña. Ta ndíkó ña, náxaa̱ ña no̱o̱ yóo ta̱a no̱o̱ ke̱e ña, ta nákoto ña vi̱chí ini ra. Nda̱tán yóo ñii veꞌe ni̱ti̱ꞌví ta nda̱sa livi na, saá yóo ini ta̱a yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ta ndíkó níma̱ ndiva̱ꞌa kua̱ꞌa̱n ña, ta nándukú ña inka̱ níma̱ ndiva̱ꞌa, ta náníꞌi ña u̱xa̱ níma̱ ña ndiva̱ꞌa ní ka̱ no̱o̱ mi̱i ña. Ta ndíkó koo ña, ta kua̱ꞌa̱n u̱xa̱ níma̱ ndiva̱ꞌa yóꞌo xíꞌin ña, ta kíxaa̱ ndiꞌi ña nakoo ña ini ta̱a yóꞌo. Ta saá xóꞌvi̱ ní ka̱ ra vitin no̱o̱ ña siꞌna. Saá kundoꞌo ndóꞌó na ndóo ñoyívi yóꞌo vitin tá o̱n xi̱in ndó koni̱ so̱ꞌo ndó to̱ꞌon i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tá káꞌa̱n ka̱ ta̱Jesús xíꞌin ni̱vi, ta saá ki̱xaa̱ siꞌí ra xíꞌin nañani ra, ta yíta na ke̱ꞌe no̱o̱ yóo ra, ta kóni na ka̱ꞌa̱n na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ta ñii ta̱a nda̱to̱ꞌon ra xíꞌin ta̱Jesús: ―Tata, siꞌí ún xíꞌin nañani ún yíta na ke̱ꞌe, ta kóni na ka̱ꞌa̱n na xíꞌin ún ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ta̱yóꞌo: ―¿Yu kúu siꞌí i̱? ¿Ta yu kúu nañani i̱? ");
INSERT INTO mim_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ta sa̱náꞌa ndaꞌa̱ ra naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Yóꞌo ndóo siꞌí i̱ xíꞌin nañani i̱. ");
INSERT INTO mim_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chi ni̱vi na kísa ndivi ña kóni Yivá i̱ Ndios, ta̱ yóo ñoyívi ni̱no, nayóꞌo kúu ñani i̱ xíꞌin ki̱ꞌva̱ i̱ xíꞌin siꞌí i̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ta mi̱i ki̱vi̱ yóꞌo ke̱ta ta̱Jesús ñii veꞌe ta kua̱ꞌa̱n ra, ta ni̱xaa̱ ra xi̱koo ra yuꞌu̱ mi̱ni. ");
INSERT INTO mim_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ta ki̱xaa̱ kua̱ꞌa̱ ní ni̱vi no̱o̱ ra, ta saá nda̱a ra ñii tón barco ta xi̱koo ra sa̱ta̱ tón barco no̱o̱ mi̱ni, ta ndiꞌi ni̱vi yóꞌo yíta na yuꞌu̱ takuií. ");
INSERT INTO mim_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ta ki̱xáꞌá ra ndáto̱ꞌon ra kua̱ꞌa̱ ní cuento ña sanáꞌa ra na, ta káchí ra saá xíꞌin na: ―Saá ndo̱ꞌo ñii ta̱a ta̱ chíꞌi ndiki̱n trigo. ");
INSERT INTO mim_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ta ki̱xáꞌá ra xíta níꞌnó ra ndiki̱n trigo ña chiꞌi ra no̱o̱ ñoꞌo̱. Ta sava ña ni̱ko̱yo yichi̱, ta ki̱xaa̱ tísaa ta xa̱xi rí ña. ");
INSERT INTO mim_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sava ndiki̱n ni̱ko̱yo no̱o̱ yásín ní ñoꞌo̱ sa̱ta̱ yu̱u̱, ta ndiki̱n yóꞌo kama ní ni̱ndu̱ta̱ ña, chi o̱n vása kuíkon no̱o̱ ñoꞌo̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ta ke̱ta ño̱ꞌo ta ni̱yi̱chi̱ ña, ta ndi̱ꞌi xa̱ꞌa̱ ña, saá chi ni̱‑kee kónó tioꞌo ña. ");
INSERT INTO mim_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ta sava ña ni̱ko̱yo ma̱ꞌñó tón ñiño̱, ta ni̱ndu̱ta̱ ña, ta ni̱‑kuchiño kuaꞌno ña, saá chi xa̱ꞌno tón ñiño̱ yóꞌo ta xa̱ꞌni nduta̱ nó ña. ");
INSERT INTO mim_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ta sava ndiki̱n ni̱ko̱yo no̱o̱ ñoꞌo̱ va̱ꞌa ña kuíkon. Ta ni̱ndu̱ta̱ ña, ta xa̱ꞌno ña, ta kua̱ꞌa̱ ní ni̱xi̱yo ndiki̱n yita yóꞌo. Sava yita ta̱xi ña ñii ciento ndiki̱n, sava yita ta̱xi ña u̱ni̱ si̱ko̱ ndiki̱n, ta sava yita ta̱xi ña o̱ko̱ u̱xu̱ ndiki̱n. ");
INSERT INTO mim_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ndiꞌi ndóꞌó ni̱vi na yóo so̱ꞌo, xíni̱ ñóꞌó chikaa̱ so̱ꞌo ndó ña káꞌa̱n i̱ xíꞌin ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ta ki̱xaa̱ naxíka xíꞌin ra no̱o̱ ra, ta ni̱nda̱ka̱ to̱ꞌon na ra: ―¿Nda̱chun xíꞌin cuento sánáꞌa ún ni̱vi? ");
INSERT INTO mim_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ta nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta ndóꞌó, kúnda̱a̱ ini ndó to̱ꞌon ña ñóꞌo seꞌé ña yo̱ꞌvi̱ ní ña káꞌa̱n xa̱ꞌa̱ yichi̱ no̱o̱ xáꞌnda chiño Ndios, chi saá ta̱xi Ndios ndaꞌa̱ ndó. Ta inka̱ ni̱vi kuiti xíni̱ so̱ꞌo na to̱ꞌon yóꞌo, ta o̱n vása kúnda̱a̱ va̱ꞌa ini na yukía̱ káchí ña. ");
INSERT INTO mim_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ta ni̱vi na kúnda̱a̱ ini to̱ꞌon káꞌa̱n i̱, ta Ndios taxi ra ña kunda̱a̱ va̱ꞌa ka̱ ini na ña, ta ni̱vi na o̱n xi̱in kunda̱a̱ ini to̱ꞌon ña káꞌa̱n i̱, ta ña loꞌo to̱ꞌon xi̱ni̱ so̱ꞌo na ta sandañóꞌó na ndiꞌi ña. ");
INSERT INTO mim_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Xa̱ꞌa̱ ñayóꞌo kúu ña sánáꞌa i̱ ni̱vi xíꞌin cuento: Vará xíto na, ta o̱n vása xíni̱ na ñanda̱a̱. Vará xíni̱ so̱ꞌo na, ta o̱n vása chíkaa̱ so̱ꞌo na, ni o̱n vása kúnda̱a̱ ini na ña ndáto̱ꞌon i̱. ");
INSERT INTO mim_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ta saá kísa ndivi na to̱ꞌon ña ni̱taa ta̱profeta Isaías xi̱na̱ꞌá, ña káchí: Ndios káchí ra saá: “Vará xíni̱ so̱ꞌo ní na, ta nda̱ ñii ki̱vi̱ o̱n kunda̱a̱ ini na ña xíni̱ so̱ꞌo na. Vará xíto ní na, ta nda̱ ñii ki̱vi̱ o̱n kunda̱a̱ ini na yukía̱ xíto na. ");
INSERT INTO mim_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ta níma̱ ni̱vi yóꞌo xa ku̱táꞌyá yu̱u̱ ña. Ta nákasi kútu̱ na so̱ꞌo na, ta nákasi na nduchu̱ no̱o̱ na, chi o̱n xi̱in na koto na, ni o̱n xi̱in na koni̱ so̱ꞌo na. Ña kéꞌé na saá kúu ña o̱n xi̱in na kunda̱a̱ ini na ñanda̱a̱, ni o̱n xi̱in na ndikó na kixi na no̱o̱ i̱ ña sandaꞌa i̱ na”, káchí Ndios, káchí ta̱profeta xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Ta mi̱i ndó, nákaa̱ ñasi̱i̱ níma̱ ndó chi xíto ndó ñava̱ꞌa kéꞌé i̱, ta xíni̱ so̱ꞌo ndó ña káꞌa̱n i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ndixa káꞌa̱n i̱ xíꞌin ndó, kui̱ya̱ xi̱na̱ꞌá ni̱xi̱yo kua̱ꞌa̱ ní naprofeta xíꞌin inka̱ ni̱vi na ni̱xika nda̱kú no̱o̱ Ndios, ta ndiꞌi nayóꞌo ku̱too na koto na ña xíto ndó vitin, ta ni̱‑kuchiño na, ta ku̱too na koni̱ so̱ꞌo na ña xíni̱ so̱ꞌo ndó vitin, ta ni̱‑kuchiño na ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra: ―Ta vitin koni̱ so̱ꞌo ndó yukía̱ káchí cuento xa̱ꞌa̱ ta̱ chíꞌi ndiki̱n trigo. ");
INSERT INTO mim_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ndiki̱n ña ni̱ko̱yo yichi̱ ndáto̱ꞌon ña xa̱ꞌa̱ ni̱vi na xíni̱ so̱ꞌo xa̱ꞌa̱ yichi̱ no̱o̱ xáꞌnda chiño Ndios, ta nayóꞌo o̱n vása kúnda̱a̱ ini na, ta saá va̱xi ñandiva̱ꞌa káꞌno ta táva ña to̱ꞌon Ndios ña xi̱ni̱ so̱ꞌo na. ");
INSERT INTO mim_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ta ndiki̱n ña ni̱ko̱yo no̱o̱ yu̱u̱ ndáto̱ꞌon ña xa̱ꞌa̱ ni̱vi na xíni̱ so̱ꞌo to̱ꞌon Ndios, ta xa̱ndi̱ko̱n nákiꞌin va̱ꞌa na ña, ta kúsii̱ ní ini na. ");
INSERT INTO mim_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ta yáꞌa ñii káni̱ loꞌo, tá kíxáꞌá va̱xi ña xóꞌvi̱ na, án inka̱ ni̱vi o̱n xi̱in ka̱ na koni ñaꞌá na xa̱ꞌa̱ ña kándixa na to̱ꞌon Ndios, ta nayóꞌo xa̱ndi̱ko̱n sándakoo na yichi̱ Ndios, ta o̱n xi̱in ka̱ na kandixa na, saá chi o̱n ta̱ꞌán chikaa̱ va̱ꞌa ini na to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ta ndiki̱n ña ni̱ko̱yo no̱o̱ tón ñiño̱ ndáto̱ꞌon ña xa̱ꞌa̱ ni̱vi na xíni̱ so̱ꞌo to̱ꞌon Ndios. Ta saá chiño yóo ñoyívi yóꞌo sándiꞌi ní ini na, ta kíxáꞌá na kísa chiño na ña kukomí na kua̱ꞌa̱ ní ñakuíká ñoyívi yóꞌo, ta saá o̱n xi̱in ka̱ na kutaku̱ na nda̱tán káꞌa̱n to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ta ndiki̱n ña ni̱ko̱yo ñoꞌo̱ va̱ꞌa ña kuíkon ndáto̱ꞌon ña xa̱ꞌa̱ ni̱vi na xíni̱ so̱ꞌo to̱ꞌon Ndios, ta kándixa ini na ña. Nayóꞌo kúu na kúndeé nduu ni̱vi na va̱ꞌa ini ta keꞌé na kua̱ꞌa̱ ní ñava̱ꞌa no̱o̱ Ndios. Nda̱tán yóo ñii ndiki̱n ña táxi o̱ko̱ u̱xu̱ ndiki̱n, ta inka̱ ndiki̱n ña táxi u̱ni̱ si̱ko̱ ndiki̱n, ta inka̱ ndiki̱n ña táxi ñii ciento ndiki̱n, saá yóo ni̱vi na kándixa ndinoꞌo ini to̱ꞌon Ndios ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ta nda̱to̱ꞌon ta̱Jesús inka̱ cuento ña sanáꞌa ra ni̱vi, káchí ra saá: ―Nda̱tán yóo ñii ta̱a chíꞌi ra ndiki̱n trigo, saá yóo yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ki̱vi̱ kísi̱n ta̱ chi̱ꞌi trigo ta kísi̱n ndiꞌi ta̱ kísa chiño no̱o̱ ra, ta ki̱xaa̱ ñii ta̱a ta̱ sáa̱ ini xíni ñaꞌá, ta chi̱ꞌi ra ndiki̱n ku̱ꞌu̱ naꞌá no̱o̱ ñoꞌo̱ no̱o̱ xa chi̱ꞌi na ndiki̱n trigo, ta saá ke̱ta ra kua̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ta ni̱ndu̱ta̱ trigo ta xa̱ꞌno ña, ta ki̱xaa̱ ki̱vi̱ kána yoko̱ ña, ta saá xíni ni̱vi ndí ku̱ꞌu̱ naꞌá xáꞌno ña ma̱ꞌñó yita trigo. ");
INSERT INTO mim_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ta na kísa chiño no̱o̱ ta̱a ta̱ chi̱ꞌi trigo ki̱xaa̱ na no̱o̱ ra, ta ni̱ka̱ꞌa̱n na xíꞌin ra: “Tata, ¿án o̱n vása kuiti ní‑chiꞌi ún ndiki̱n trigo? Ta vitin yóo kua̱ꞌa̱ ní ku̱ꞌu̱ naꞌá xíꞌin trigo. ¿Míchí ki̱xi ña?”, káchí na. ");
INSERT INTO mim_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ta nda̱kuii̱n ta̱ chi̱ꞌi trigo: “Ñii ta̱a ta̱ sáa̱ ini xíni yi̱ꞌi̱ ki̱xi ra chi̱ꞌi ra ku̱ꞌu̱ naꞌá.” Ta na kísa chiño no̱o̱ ra ni̱nda̱ka̱ to̱ꞌon na ra: “¿Án kóni ún toꞌon ndi̱ ndiꞌi ku̱ꞌu̱ naꞌá?” ");
INSERT INTO mim_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ta nda̱kuii̱n ra, káchí ra saá: “Óꞌon, o̱n toꞌon ndó ku̱ꞌu̱ naꞌá ko̱to̱ toꞌon ndó trigo xíꞌin ña. ");
INSERT INTO mim_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Va̱ꞌa ná taxi yó kuaꞌno xíꞌin táꞌan ña a̱nda̱ ki̱vi̱ kaꞌnda yó ña. Ta ki̱vi̱ ta̱ꞌnda̱ ña ta ka̱ꞌa̱n i̱ xíꞌin na xáꞌnda, kachí i̱ saá: Kaꞌnda ndiꞌi ndó ña, ta tava síín ndó trigo, ta kiꞌin ndó ku̱ꞌu̱ naꞌá, ta katón nomi ndó ña ta ko̱ꞌo̱n ña ko̱ko̱ ña; ta saá taan va̱ꞌa ndó ndiki̱n trigo yaka̱ veꞌe i̱”, kachí ta̱a ta̱ chi̱ꞌi trigo xíꞌin na kísa chiño no̱o̱ ra ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ta nda̱to̱ꞌon ta̱Jesús inka̱ cuento ña sanáꞌa ra ni̱vi, káchí ra saá xíꞌin na: ―Nda̱tán yóo ñii ndiki̱n mostaza ña chi̱ꞌi ñii ta̱a ñoꞌo̱ ra, saá yóo yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ta ndiki̱n mostaza kúu ña válí ní ka̱ no̱o̱ ndiꞌi ndiki̱n yóo ñoyívi yóꞌo, ta ki̱vi̱ ndúta̱ ña ta ndúu ña ña káꞌno ní ka̱ no̱o̱ ndiꞌi inka̱ ñata̱ta̱ chíꞌi ni̱vi. Ki̱vi̱ xa̱ꞌno ña, ta ndu̱u ña ñii tón yito̱n káꞌno, ta kíxaa̱ tísaa kísa va̱ꞌa rí ta̱ka̱ rí ndaꞌa̱ nó. ");
INSERT INTO mim_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ta tuku nda̱to̱ꞌon ta̱Jesús inka̱ cuento, káchí ra saá: ―Nda̱tán yóo levadura ña na̱saka ni̱vi xíꞌin yuxa̱n si̱ta̱ va̱ꞌa, saá yóo yichi̱ ña xáꞌnda chiño Ndios. Vará loꞌo ní levadura na̱saka ni̱vi xíꞌin u̱ni̱ koꞌndo náꞌno yuxa̱n harina, ta ku̱ndeé ña sa̱naño ña ndiꞌi yuxa̱n yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ta ki̱vi̱ ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ni̱vi, ta ndasaá kuiti xíꞌin cuento sa̱náꞌa ra na; o̱n vása ní‑sanáꞌa ra nayóꞌo xíꞌin inka̱ no̱o̱ to̱ꞌon. ");
INSERT INTO mim_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Saá ki̱sa ndivi ra to̱ꞌon Ndios ña ni̱taa ñii ta̱profeta xi̱na̱ꞌá, ña káchí saá: Ka̱ꞌa̱n i̱ xíꞌin ni̱vi xíꞌin cuento; ta ndato̱ꞌon i̱ xíꞌin na xa̱ꞌa̱ to̱ꞌon ña ni̱xi̱yo seꞌé nda̱ ki̱vi̱ ki̱sa va̱ꞌa i̱ ñoyívi yóꞌo ta̱nda̱ ki̱vi̱ vitin, ka̱chí Ndios, ni̱taa ta̱profeta xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ta ni̱nda̱yi ta̱Jesús ni̱vi, ta ni̱ki̱ꞌvi ra veꞌe. Ta ki̱xaa̱ yatin naxíka xíꞌin ra no̱o̱ ra, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Nandaxin ún no̱o̱ ndi̱ yukía̱ kóni kachí cuento xa̱ꞌa̱ ku̱ꞌu̱ naꞌá xíꞌin yita trigo. ");
INSERT INTO mim_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ta nda̱kuii̱n ra, káchí ra saá xíꞌin na: ―Ta̱a ta̱ chi̱ꞌi ndiki̱n trigo kúu yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ta ñoꞌo̱ no̱o̱ chi̱ꞌi ra kúu ñoyívi yóꞌo, ta ndiki̱n trigo kúu ni̱vi na kua̱ꞌa̱n yichi̱ Ndios. Ta ku̱ꞌu̱ naꞌá kúu ni̱vi na ndíko̱n yichi̱ ñaníma̱ ndiva̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ta ta̱a ta̱ sáa̱ ini ta̱ chi̱ꞌi ku̱ꞌu̱ naꞌá kúu ñaníma̱ ndiva̱ꞌa káꞌno. Ta ki̱vi̱ ña kaꞌnda na trigo xíꞌin ku̱ꞌu̱ naꞌá kúu ki̱vi̱ sondíꞌí ñoyívi yóꞌo, ta na kaꞌnda kúu naángel. ");
INSERT INTO mim_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nda̱tán nátoꞌon ni̱vi ku̱ꞌu̱ naꞌá no̱o̱ ñoꞌo̱ chi̱ꞌi na, ta kaꞌmi na ku̱ꞌu̱ naꞌá yóꞌo no̱o̱ xíxi̱ ñoꞌo̱, saá keꞌé naángel ki̱vi̱ sondíꞌí ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, tiꞌví i̱ naángel ko̱ꞌo̱n na tava na ndiꞌi ni̱vi na chúꞌu inka̱ ni̱vi keꞌé na ña o̱n váꞌa, ta tava na ndiꞌi ni̱vi na keꞌé ña o̱n váꞌa. ");
INSERT INTO mim_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ta taan na ni̱vi yóꞌo no̱o̱ ndeé ní xíxi̱ ñoꞌo̱, no̱o̱ kuaku ní na ta xo̱ꞌvi̱ ní na. ");
INSERT INTO mim_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ta ndiꞌi ni̱vi na kísa ndivi ña kóni Ndios kundo̱o na no̱o̱ xáꞌnda chiño Yivá yó Ndios, ta nda̱tán yóo ña yéꞌe ño̱ꞌo, saá nayeꞌe ni̱vi yóꞌo. Ndiꞌi ni̱vi na yóo so̱ꞌo, xíni̱ ñóꞌó chikaa̱ so̱ꞌo na ña káꞌa̱n i̱ xíꞌin na ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ta tuku nda̱to̱ꞌon ta̱Jesús ñii cuento ña sanáꞌa ra na, káchí ra saá xíꞌin na: ―Ñii ñakuíká yóo seꞌé ti̱xin ñoꞌo̱, ta ñii ta̱a na̱níꞌi ra ña, ta kúsii̱ ní ini ra, ta tuku chi̱kaa̱ seꞌé ra ña, ta ni̱xa̱ꞌa̱n ra ni̱si̱kó ndiꞌi ra ña kómí ra, ta saá ndi̱kó ra sa̱ta ra ñoꞌo̱ yóꞌo no̱o̱ chi̱kaa̱ seꞌé ra ñakuíká. Nda̱tán yóo ñakuíká yóꞌo, saá yóo yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ta nda̱to̱ꞌon ta̱Jesús inka̱ cuento ña sanáꞌa ra na, káchí ra saá: ―Ñii ta̱a ta̱ síkó ña̱ꞌa ndúkú ra yu̱u̱ livi ní ña ndáya̱ꞌví ní na̱ní ña perla. ");
INSERT INTO mim_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ta na̱níꞌi ra ñii yu̱u̱ livi ña ndáya̱ꞌví ní, ta ni̱xa̱ꞌa̱n ra ni̱si̱kó ndiꞌi ra ña kómí ra, ta saá ndi̱kó ra sa̱ta ra yu̱u̱ livi yóꞌo. Nda̱tán yóo yu̱u̱ livi ña ndáya̱ꞌví ní, saá yóo yichi̱ ña xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ta nda̱to̱ꞌon ta̱Jesús inka̱ cuento ña sanáꞌa ra na, káchí ra saá: ―Nda̱tán yóo ñii ñono̱ ña chíkaa̱ na ini mi̱ni, ta kua̱ꞌa̱ ní no̱o̱ tia̱ká táva na, saá yóo yichi̱ ña xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tá chútú ñono̱, ta násita na ña yuꞌu̱ takuií. Ta saá náka̱xin na ndiꞌi tia̱ká tí va̱ꞌa ta táan na rí ini chikiva, ta xáta na tí o̱n váꞌa. ");
INSERT INTO mim_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Saá kundoꞌo ni̱vi ki̱vi̱ sondíꞌí ñoyívi yóꞌo: ta kixaa̱ naángel ta nataꞌví na ni̱vi na va̱ꞌa xíꞌin na o̱n váꞌa, ");
INSERT INTO mim_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ta na o̱n váꞌa kui̱ta̱ na ko̱ꞌo̱n na no̱o̱ xíxi̱ ñoꞌo̱ ndiꞌi saá ki̱vi̱, no̱o̱ kuaku ní na ta xo̱ꞌvi̱ ní na. ");
INSERT INTO mim_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra naxíka xíꞌin ra, káchí ra saá: ―¿Án kúnda̱a̱ ini ndó ndiꞌi ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó? ―Kúnda̱a̱ va̱ꞌa ini ndi̱, Tata ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, káchí ra saá: ―Ndiꞌi na sánáꞌa nda̱yí Ndios ña ni̱taa ta̱Moisés ta ndíko̱n na yichi̱ no̱o̱ xáꞌnda chiño Ndios, ta nda̱tán yóo ñii ta̱a xíꞌin veꞌe ra no̱o̱ ñóꞌo ñakuíká yatá xíꞌin ñakuíká xa̱á, saá yóo nayóꞌo. Ta saá kúchiño na koni̱ ñóꞌó na ñakuíká xa̱á xíꞌin ñakuíká yatá ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ta ndi̱ꞌi nda̱to̱ꞌon ta̱Jesús cuento ña sánáꞌa ra na, ta ke̱e ra kua̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ta na̱xaa̱ ra ñoo mi̱i ra, ta ki̱xáꞌá ra sánáꞌa ra ni̱vi veꞌe ño̱ꞌo sinagoga. Ta na̱kaꞌnda ní ini na, ta káchí na xíꞌin táꞌan na saá: ―¿Míkía̱ sa̱kuáꞌá ta̱yóꞌo ndiꞌi ña xíni̱ ní ra? ¿Míkía̱ ke̱e ndee̱ ña kéꞌé ra milagro xíꞌin ni̱vi? ");
INSERT INTO mim_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Án o̱n si̱ví ta̱yóꞌo kúu sa̱ꞌya ta̱carpintero? ¿Án o̱n si̱ví siꞌí ta̱yóꞌo kúu ñá na̱ní María? ¿Án o̱n si̱ví ñani ta̱Jacobo, ta̱José, ta̱Simón xíꞌin ta̱Judas kúu ra? ");
INSERT INTO mim_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Án o̱n ndixa ndóo ki̱ꞌva̱ ra ñoo yó yóꞌo? ¿Míkía̱ ki̱xi ña xíni̱ ní ta̱yóꞌo? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ta ni̱‑xiin na koni̱ so̱ꞌo na ña káꞌa̱n ra. Ta ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá xíꞌin na: ―Ndiꞌi saá ñoo ñoyívi yóꞌo kísa to̱ꞌó na ta̱profeta, ta nañoo mi̱i ra xíꞌin naveꞌe mi̱i ra o̱n xi̱in na kasa to̱ꞌó na ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta saá o̱n vása ní‑keꞌé ra kua̱ꞌa̱ ní milagro xíꞌin na, chi ni̱‑xiin na kandixa na ra. ");
INSERT INTO mim_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ta ki̱vi̱ yóꞌo ta̱rey Herodes, ta̱ xáꞌnda chiño no̱o̱ nañoo estado Galilea, xi̱ni̱ so̱ꞌo ra ndiꞌi ñava̱ꞌa ña ke̱ꞌé ta̱Jesús, ");
INSERT INTO mim_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ta ni̱ka̱ꞌa̱n ra xíꞌin na kísa chiño no̱o̱ ra: ―Ta̱Jesús yóꞌo kúu ta̱Juan, ta̱ sa̱kuchu ni̱vi, ta ni̱xiꞌi̱ ra ta vitin na̱taku̱ ra, ña̱kán kómí ra ndee̱ kéꞌé ra ndiꞌi milagro yóꞌo vitin ―káchí ta̱rey. ");
INSERT INTO mim_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ni̱ka̱ꞌa̱n ta̱Herodes to̱ꞌon yóꞌo chi xáni si̱ni̱ ra xa̱ꞌa̱ ña o̱n váꞌa ke̱ꞌé ra xíꞌin ta̱Juan. Chi ta̱Juan ni̱ka̱ꞌa̱n ra kua̱ꞌa̱ ní yichi̱ xíꞌin ta̱Herodes, káchí ra saá: ―Nda̱yí Ndios ña ni̱taa ta̱Moisés káchí ña, o̱n ko̱ó yichi̱ nakiꞌin ún ñásíꞌí ñani ún koo ñá xíꞌin ún ―káchí ra. Saá chi ta̱Herodes xa ni̱tonda̱ꞌa̱ ra xíꞌin ñáHerodías ñásíꞌí ta̱Felipe ta̱ kúu ñani mi̱i ra. Ta ta̱Herodes, xa̱ꞌa̱ ña sakusii̱ ra ini ñásíꞌí ra yóꞌo, xa̱ꞌnda chiño ra no̱o̱ natropa ña tiin na ta̱Juan, ta ka̱tón na ra ta chi̱kaa̱ na ra ini veꞌe ka̱a. ");
INSERT INTO mim_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ta ta̱Herodes kóni ra kaꞌni ra ta̱Juan, ta ni̱‑kuchiño ra chi yíꞌví ra no̱o̱ ni̱vi, chi ni̱vi xáni ini na ndí ta̱Juan kúu ra profeta. ");
INSERT INTO mim_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ta ñii ki̱vi̱ ka̱na viko̱ ni̱xi̱no̱ kui̱ya̱ ta̱Herodes, ta ñása̱ꞌya ñáHerodías ka̱ta xáꞌá ñá no̱o̱ ndiꞌi na ndóo viko̱ yóꞌo, ta kúsii̱ ní ini ta̱Herodes xíni ra ñá, ka̱ta xáꞌá ñá. ");
INSERT INTO mim_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ta saá chi̱náꞌa ra Ndios ña taxi ra ndaꞌa̱ ñáloꞌo yóꞌo ndiꞌi ña ndukú ñá no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ta siꞌí ñá ni̱ka̱ꞌa̱n ñá xíꞌin sa̱ꞌya ñá yukía̱ ndukú ñá no̱o̱ ta̱rey, ta saá ni̱ka̱ꞌa̱n ñáloꞌo yóꞌo xíꞌin ta̱rey: ―Chinóo ún si̱ni̱ ta̱Juan, ta̱ sa̱kuchu ni̱vi, no̱o̱ ko̱ꞌo̱ ña ndíka̱, ta taxi ún ña ndaꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ta kúchuchú ní ini ta̱rey ña xi̱ni̱ so̱ꞌo ra ña ndu̱kú ñáloꞌo, ta saá ni, xa̱ꞌnda chiño ra ña kasa ndivi na ña ndukú ñá no̱o̱ ra, xa̱ꞌa̱ ña xi̱ni̱ so̱ꞌo ndiꞌi na ndóo viko̱ yukía̱ ni̱ka̱ꞌa̱n ra xíꞌin ñáloꞌo ña chi̱náꞌa ra Ndios. ");
INSERT INTO mim_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ta ti̱ꞌví ra natropa kua̱ꞌa̱n na veꞌe ka̱a, ta ka̱ndoso na si̱ko̱n ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ta saá níꞌi na si̱ni̱ ta̱Juan kánóo ña no̱o̱ ko̱ꞌo̱ ta ta̱xi na ña ndaꞌa̱ ñáloꞌo, ta ñáloꞌo yóꞌo na̱taxi ñá ko̱ꞌo̱ yóꞌo ndaꞌa̱ siꞌí ñá. ");
INSERT INTO mim_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ta naxíka xíꞌin ta̱Juan ki̱xaa̱ na veꞌe ka̱a, ta na̱kuiso na yi̱kí ko̱ñu ra, ta ni̱xa̱ꞌa̱n na sa̱ndúxu̱n na ña. Ta saá ki̱xaa̱ na no̱o̱ yóo ta̱Jesús, ta nda̱to̱ꞌon na xíꞌin ra yukía̱ ni̱ndoꞌo ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ta ki̱vi̱ xi̱ni̱ so̱ꞌo ta̱Jesús ña ni̱ndoꞌo ta̱Juan, ta saá ke̱e ra kua̱ꞌa̱n ra ini tón barco, ta ni̱xaa̱ ra ñii xiiña no̱o̱ o̱n ko̱ó ni̱vi. Ta saá xi̱ni̱ so̱ꞌo ni̱vi mí kua̱ꞌa̱n ta̱Jesús, ta ke̱e na kua̱ꞌa̱n xáꞌá na sa̱ta̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tá no̱o ta̱Jesús tón barco, ta xi̱ni ra kua̱ꞌa̱ ní ni̱vi, ta kúndáꞌví ní ini ra xíni ra na, ta sa̱ndaꞌa ra ni̱vi na ndeé ndóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ta xa ni̱kuaa ní kúu ña, ta saá ni̱to̱nda̱a yatin u̱xu̱ o̱vi̱ naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tata, no̱o̱ ndóo yó vi̱chí ní, ta ni̱kuaa ní kúu ña vitin. Va̱ꞌa tiꞌví ún ndiꞌi ni̱vi yóꞌo ná ko̱ꞌo̱n na ñoo válí yatin ña ndukú na sata na ña kuxu na ―káchí naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra: ―O̱n vása xíni̱ ñóꞌó ko̱ꞌo̱n na. Mi̱i ndó taxi kuxu na ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ta ni̱ka̱ꞌa̱n na saá: ―O̱n ko̱ó kua̱ꞌa̱ ñaxíxi. Yóo kuiti o̱ꞌo̱n si̱ta̱ va̱ꞌa ta o̱vi̱ kúu tia̱ká. ");
INSERT INTO mim_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ta ni̱ka̱ꞌa̱n ta̱Jesús saá xíꞌin na: ―Taxi ndó ña yóo ndaꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi kundo̱o ndiꞌi na no̱o̱ yita síi. Ta ki̱ꞌin ra o̱ꞌo̱n si̱ta̱ va̱ꞌa xíꞌin o̱vi̱ tia̱ká, ta xi̱to ndaa ra ñoyívi ni̱no, ta ni̱ka̱ꞌa̱n ra, káchí ra: ―Tata Yivá yó Ndios, táxaꞌvi ñaꞌá ún ta̱xi ún ñaxíxi. Ta ta̱ꞌví ra si̱ta̱ va̱ꞌa, ta ta̱xi ra ña ndaꞌa̱ naxíka xíꞌin ra, ta nayóꞌo na̱taxi na ña ndaꞌa̱ ndiꞌi ni̱vi na ndóo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ta na̱ni ña xi̱xi ndiꞌi ni̱vi nda̱ ni̱xaa ini na. Tá ndi̱ꞌi xi̱xi na, ta naxíka xíꞌin ta̱Jesús sa̱kutú na u̱xu̱ o̱vi̱ chikiva xíꞌin ña ki̱ndo̱o ndoso, chi ni̱‑kundeé nani̱vi kuxu ndiꞌi na ña. ");
INSERT INTO mim_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ta ndiꞌi na xi̱xi yóꞌo xi̱kuu na ñii o̱ꞌo̱n mil ta̱a, xíꞌin inka̱ kua̱ꞌa̱ ní násíꞌí xíꞌin kua̱ꞌa̱ ní naválí. ");
INSERT INTO mim_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ta saá ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ naxíka xíꞌin ra ña ndaa na tón barco ta ko̱ꞌo̱n siꞌna na no̱o̱ ra nda̱ inka̱ xiiña no̱o̱ mi̱ni, saá chi ni̱ndo̱o ra nda̱yi ra ndiꞌi ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tá ndi̱ꞌi ni̱nda̱yi ra ni̱vi, ta nda̱a ra kua̱ꞌa̱n ra yuku̱ no̱o̱ ka̱ꞌa̱n ra xíꞌin Ndios. Ta saá ni̱ke̱tá ño̱ꞌo ta ku̱naa, ta yóo matóꞌón ra yuku̱ yóꞌo, ");
INSERT INTO mim_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ta tón barco kánóo nó ma̱ꞌñó mi̱ni. Ni̱‑kuchiño ko̱ꞌo̱n ka̱ nó chi ndeé ní káni ta̱chi̱ xíꞌin takuií ta sákuiko ní ña tón barco. ");
INSERT INTO mim_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ta xa yatin kóni ti̱vi kúu ña, ta ta̱Jesús xíka xáꞌá ra no̱o̱ takuií va̱xi ra no̱o̱ kánóo tón barco. ");
INSERT INTO mim_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tá xi̱ni naxíka xíꞌin ra ndí xíka ra no̱o̱ mi̱ni, ta saá ni̱yi̱ꞌví ní na, ta xíꞌin ndiꞌi ndee̱ na ni̱ka̱ꞌa̱n na: ―¡Ñii ñíꞌná kúu ñakaa̱! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ta saá kama ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―O̱n kundiꞌi ini ndó, chi yi̱ꞌi̱ va kúu i̱. O̱n kuyi̱ꞌví ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ta ni̱ka̱ꞌa̱n ta̱Pedro, káchí ra saá: ―Tata, tá ndixa yóꞌó kúu ún, ta kaꞌnda chiño ún no̱o̱ i̱ ta ná kundo̱so̱ i̱ no̱o̱ takuií ta xaa̱ i̱ no̱o̱ ún. ");
INSERT INTO mim_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","―Naꞌa ―káchí ta̱Jesús xíꞌin ra. Ta ta̱Pedro no̱o ra tón barco, ta ki̱xáꞌá ra xíka xáꞌá ra no̱o̱ takuií ña xaa̱ ra no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ta xi̱ni ra ndeé ní va̱xi ta̱chi̱, ta ni̱yi̱ꞌví ní ra, ta ki̱xáꞌá ra kua̱ꞌa̱n ni̱ke̱tá ra ini mi̱ni, ta xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra: ―Tata, ¡saka̱ku ún yi̱ꞌi̱! ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ta ta̱Jesús xa̱ndi̱ko̱n sa̱nakaa̱ ra ndaꞌa̱ ra, ta ti̱in ra ta̱Pedro, ta ni̱ka̱ꞌa̱n ra xíꞌin ra: ―¡Ta̱a ta̱ loꞌo ní kándixa ini yi̱ꞌi̱ kúu yóꞌó! ¿Nda̱chun xíka ini ún, ta o̱n vása kándixa ún yi̱ꞌi̱ chindeé i̱ yóꞌó? ");
INSERT INTO mim_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ta saá nda̱a na tón barco, ta ni̱ya̱a̱ ta̱chi̱. ");
INSERT INTO mim_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ta na ñóꞌo ini tón barco xi̱kuxítí na no̱o̱ ta̱Jesús, ta ki̱sa to̱ꞌó na ra, ni̱ka̱ꞌa̱n na saá xíꞌin ra: ―¡Ndixa yóꞌó kúu ún Sa̱ꞌya Ndios! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ni̱yaꞌa na mi̱ni ta ni̱xaa̱ na inka̱ xiiña, ta no̱o na tón barco ñoo Genesaret. ");
INSERT INTO mim_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ta na̱koni nani̱vi ñoo yóꞌo yu kúu ta̱Jesús, ta saá ti̱ꞌví na ni̱vi ndato̱ꞌon na xíꞌin inka̱ na ñoo yatin ña ki̱xaa̱ ta̱Jesús. Ta nayóꞌo ki̱xaa̱ na xíꞌin na ndeé ndóꞌo no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ta xa̱ku ndáꞌví na no̱o̱ ra ña taxi ra to̱nda̱a ndaꞌa̱ na ra, vará loꞌo yuꞌu̱ tiko̱to̱ ra, ta ndiꞌi ni̱vi na ni̱to̱nda̱a ndaꞌa̱ ñaꞌá ndu̱va̱ꞌa na. ");
INSERT INTO mim_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ta sava nafariseo xíꞌin sava na sánáꞌa nda̱yí Ndios ki̱xi na ñoo Jerusalén, ta ki̱xaa̱ na no̱o̱ ta̱Jesús, ta ni̱nda̱ka̱ to̱ꞌon na ra: ");
INSERT INTO mim_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Nda̱chun yáꞌa ndoso naxíka xíꞌin ún no̱o̱ ña sa̱náꞌa naxi̱i̱ síkuá yó xi̱na̱ꞌá? Chi o̱n vása ndáꞌá na ta xíxi na ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―Ta ndóꞌó, ¿nda̱chun yáꞌa ndoso ndó nda̱yí ña xáꞌnda chiño Ndios, ta kísa ndivi ndó ña sa̱náꞌa naxi̱i̱ síkuá ndó xi̱na̱ꞌá? ");
INSERT INTO mim_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Chi Ndios ni̱ka̱ꞌa̱n ra, ka̱chí ra saá: “Kasa to̱ꞌó ndó yivá ndó, ta kasa to̱ꞌó ndó siꞌí ndó”, ta “Xíni̱ ñóꞌó kivi̱ ndiꞌi ni̱vi na kándiva̱ꞌa xíꞌin yivá na án xíꞌin siꞌí na”, ka̱chí Ndios. ");
INSERT INTO mim_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ta ndóꞌó, sánáꞌa ndó káchí ndó yóo yichi̱ ka̱ꞌa̱n ñii ta̱a xíꞌin yivá ra ta xíꞌin siꞌí ra, kachí ra saá: “O̱n kúchiño i̱ chindeé i̱ ndóꞌó, saá chi xa ni̱ka̱ꞌa̱n i̱ taxi i̱ ndiꞌi ña kómí i̱ ndaꞌa̱ Ndios”, kachí ra. ");
INSERT INTO mim_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ta xa̱ꞌa̱ ña káꞌa̱n ra ñayóꞌo káchí ña saá: O̱n vása xíni̱ ñóꞌó ka̱ kasa to̱ꞌó ra yivá ra, ta o̱n vása xíni̱ ñóꞌó ka̱ kasa to̱ꞌó ra siꞌí ra. Ta saá chíkaa̱ ni̱no̱ ndó to̱ꞌon Ndios xa̱ꞌa̱ ña ndíko̱n ndó yichi̱ mi̱i ndó. ");
INSERT INTO mim_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Na o̱vi̱ yuꞌu̱ kúu ndóꞌó! Ta ñanda̱a̱ kúu to̱ꞌon Ndios ña ni̱taa ta̱profeta Isaías xa̱ꞌa̱ ndó kui̱ya̱ xi̱na̱ꞌá, ña káchí saá: ");
INSERT INTO mim_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ni̱vi yóꞌo kísa to̱ꞌó na yi̱ꞌi̱ xíꞌin ndasaá kuiti to̱ꞌon kée yuꞌu̱ na, ta níma̱ na xíká ní yóo ña no̱o̱ i̱, chi o̱n vása ndinoꞌo ini na kísa to̱ꞌó na yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ta nda̱ ma̱ni̱ kísa to̱ꞌó na yi̱ꞌi̱, chi sánáꞌa na ni̱vi ña kúu nda̱yí mi̱i na, ta o̱n vása sánáꞌa na ni̱vi ña xáꞌnda chiño i̱ no̱o̱ na, ka̱chí Ndios ―káchí ta̱Jesús xíꞌin nafariseo ta xíꞌin na sánáꞌa nda̱yí. ");
INSERT INTO mim_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ta ta̱Jesús ka̱na ra ni̱vi va̱xi na no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―Koni̱ so̱ꞌo ndó, ta kunda̱a̱ ini ndó ña ka̱ꞌa̱n i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ña xíxi ni̱vi ta ña kíꞌvi yuꞌu̱ na, ta o̱n vása ndása ña nduu ni̱vi na ya̱kua̱ no̱o̱ Ndios. Ta to̱ꞌon ña o̱n váꞌa va̱xi yuꞌu̱ ni̱vi, ta ñayóꞌo ndása ña nduu ni̱vi na ya̱kua̱ no̱o̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ta naxíka xíꞌin ra ki̱xaa̱ na no̱o̱ ra, ta ni̱nda̱ka̱ to̱ꞌon na ra: ―¿Án xíni̱ ún ña ni̱saa̱ ní nafariseo ña xíni̱ so̱ꞌo na to̱ꞌon ña ni̱ka̱ꞌa̱n ún xíꞌin na? ");
INSERT INTO mim_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ta nda̱kuii̱n ra: ―Nda̱tán yóo ku̱ꞌu̱ ña o̱n vása ní‑chiꞌi Yivá yó Ndios, ta xíni̱ ñóꞌó toꞌon ndiꞌi ra ña, saá yóo nafariseo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ta saá o̱n kani si̱ni̱ ndó xa̱ꞌa̱ na. Nda̱tán yóo nakuáá tíin na ndaꞌa̱ inka̱ nakuáá kua̱ꞌa̱n na yichi̱, saá yóo nayóꞌo. Tá ñii ta̱kuáá tíin ra ndaꞌa̱ inka̱ ta̱kuáá kua̱ꞌa̱n na yichi̱, ndio̱vi̱ ra saá ko̱yo taꞌvi̱. ");
INSERT INTO mim_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ta nda̱kuii̱n ta̱Pedro, ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Nandaxin ún no̱o̱ ndi̱ cuento sa̱náꞌa ún xa̱ꞌa̱ ña ndasaá nduu ni̱vi na ya̱kua̱ no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―¿Án ñii ki̱ꞌva nda̱tán yóo inka̱ ni̱vi, saá yóo ndóꞌó? ¿Án ta̱ꞌán kunda̱a̱ ini ndó? ");
INSERT INTO mim_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ndiꞌi ña xíxi ni̱vi kíꞌvi ña yuꞌu̱ na ta xáa̱ ña ti̱xin na, ta saá yáꞌa ña xíta̱ ña. ");
INSERT INTO mim_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ta to̱ꞌon ña o̱n váꞌa va̱xi ña yuꞌu̱ na chi káku ña níma̱ na, ta ñayóꞌo ndása ña nduu ni̱vi na ya̱kua̱ no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Chi ndiꞌi ña o̱n váꞌa xáni ini ni̱vi káku ña níma̱ na. Ta chíndaꞌá ña na keꞌé na ndiꞌi saá no̱o̱ ña o̱n váꞌa, ña kúu ña xáꞌni na inka̱ ni̱vi, xíꞌin ña kíꞌvi ta̱a kua̱chi ñoyívi xíꞌin inka̱ ñaꞌa̱ ñá o̱n si̱ví kúu ñásíꞌí ra, án kíꞌvi ñaꞌa̱ kua̱chi ñoyívi xíꞌin ta̱a ta̱ o̱n si̱ví kúu yii̱ ñá, xíꞌin ndiꞌi inka̱ no̱o̱ ñakini ña kéꞌé ni̱vi xíꞌin inka̱ ñaꞌa̱ án ta̱a. Ta inka̱ ña o̱n váꞌa kéꞌé na kúu ña kísa kuíꞌná na, xíꞌin ña káꞌa̱n na ñavatá, xíꞌin ña kándiva̱ꞌa na xíꞌin inka̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ndiꞌi ñayóꞌo kúu ña ndása ña nduu ni̱vi na ya̱kua̱ no̱o̱ Ndios. Tá ña o̱n vása ndáꞌá ni̱vi ña kuxu na, ñayóꞌo o̱n vása ndása ña nduu na ni̱vi ya̱kua̱ no̱o̱ Ndios ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ta ke̱e ta̱Jesús xíꞌin naxíka xíꞌin ra, ta kua̱ꞌa̱n na ñii xiiña no̱o̱ yóo yatin ñoo Tiro xíꞌin Sidón. ");
INSERT INTO mim_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ta ñii ñáCanaán va̱xi yatin ñá no̱o̱ kua̱ꞌa̱n ra, ta xíꞌin ndiꞌi ndee̱ ñá ni̱ka̱ꞌa̱n ñá, káchí ñá siꞌa xíꞌin ra: ―Tata, sa̱ꞌya ta̱David, ¡ná kundáꞌví ini ún koni ún yi̱ꞌi̱! Sa̱ꞌya i̱ ñáloꞌo ndeé ní xóꞌvi̱ ñá, chi kómí ñá níma̱ ndiva̱ꞌa ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ta o̱n vása ní‑ndakuii̱n ta̱Jesús nda̱ ñii to̱ꞌon. Ta saá naxíka xíꞌin ra ki̱xaa̱ na no̱o̱ ra, ta xa̱ku ndáꞌví na no̱o̱ ra: ―Ka̱ꞌa̱n ún xíꞌin ñáyóꞌo ná ko̱ꞌo̱n ñá, saá chi ndáꞌyi ní ñá va̱xi ñá sa̱ta̱ yó. ");
INSERT INTO mim_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ta ni̱ka̱ꞌa̱n ta̱Jesús: ―Ndios ti̱ꞌví ra yi̱ꞌi̱ va̱xi i̱ kuiti no̱o̱ nañoo Israel, chi nda̱tán yóo ndikachi tí nda̱ñóꞌó no̱o̱ xitoꞌo rí, saá yóo nayóꞌo ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ta ñáñaꞌa̱ yóꞌo ni̱to̱nda̱a yatin ñá, ta xi̱kuxítí ñá no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n ñá xíꞌin ra: ―Tata, ¡chindeé ún yi̱ꞌi̱! ");
INSERT INTO mim_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ta nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra: ―O̱n vása va̱ꞌa tava ni̱vi si̱ta̱ va̱ꞌa ña xíxi sa̱ꞌya na ta sakana na ña no̱o̱ tí ina kuxu rí ña. ");
INSERT INTO mim_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ta ni̱ka̱ꞌa̱n ñá xíꞌin ra, káchí ñá saá: ―Ndixa, Tata. Ta saá ni, tí ina xíxi rí ña cha̱chi kóyo yuꞌu̱ mesa xitoꞌo rí ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra: ―Nana, kónó ní chi̱kaa̱ ún ña ndáa ini ún yi̱ꞌi̱. Ta kasa ndivi i̱ ña ndúkú ún no̱o̱ i̱ ―káchí ra. Ta ñáloꞌo sa̱ꞌya ñáñaꞌa̱ yóꞌo mi̱i hora yóꞌo ndu̱va̱ꞌa ñá. ");
INSERT INTO mim_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ta saá ta̱Jesús ke̱e ra kua̱ꞌa̱n ra yuꞌu̱ mi̱ni Galilea. Ta nda̱a ra ñii yuku̱ ta xi̱koo ra. ");
INSERT INTO mim_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ta kua̱ꞌa̱ ní ni̱vi ki̱xaa̱ na no̱o̱ ra, ta xíꞌin nayóꞌo ki̱xaa̱ ni̱vi na o̱n ki̱ví kaka xáꞌá, ni̱vi nakuáá, ni̱vi nañíꞌí, ni̱vi na lavó ndaꞌa̱, ni̱vi na lavó xa̱ꞌa̱, xíꞌin inka̱ na ndeé ndóꞌo ndiꞌi saá no̱o̱ kue̱ꞌe̱ ki̱xaa̱ na no̱o̱ ta̱Jesús. Ta sa̱ndaꞌa ra ndiꞌi na ndeé ndóꞌo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ta saá na̱kaꞌnda ní ini ni̱vi xíni na ndí na xi̱kuu nañíꞌí káꞌa̱n na, na xi̱kuu na lavó ndaꞌa̱ xíꞌin na lavó xa̱ꞌa̱ ndu̱va̱ꞌa na, na xi̱kuu na o̱n ki̱ví kaka xáꞌá xíka na, na xi̱kuu nakuáá xíto na. Ta ndiꞌi ni̱vi ki̱sa káꞌno na ta ki̱sa to̱ꞌó na Ndios ta̱ xáꞌnda chiño no̱o̱ naIsrael. ");
INSERT INTO mim_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ta ta̱Jesús ka̱na ra naxíka xíꞌin ra va̱xi na no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―Kúndáꞌví ní ini i̱ xíni i̱ ni̱vi, chi xa u̱ni̱ ki̱vi̱ ndóo na yóꞌo ta o̱n ko̱ó ña kuxu na. O̱n xi̱in i̱ tiꞌví i̱ na noꞌo̱ na ko̱to̱ kivi̱ ndu̱ú na yichi̱, chi xíꞌi̱ ní na so̱ko ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ta nda̱kuii̱n naxíka xíꞌin ra: ―¿Míkía̱ sata yó si̱ta̱ va̱ꞌa kuxu ndiꞌi nani̱vi, chi vi̱chí ní káa yóꞌo? ");
INSERT INTO mim_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ta ni̱nda̱ka̱ to̱ꞌon ta̱Jesús naxíka xíꞌin ra: ―¿Ndasaá si̱ta̱ va̱ꞌa kómí ndó? Ta nda̱kuii̱n na: ―Yóo u̱xa̱ si̱ta̱ va̱ꞌa xíꞌin loꞌo tia̱ká válí. ");
INSERT INTO mim_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi kundo̱o ndiꞌi na no̱o̱ ñoꞌo̱. ");
INSERT INTO mim_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ta ki̱ꞌin ra u̱xa̱ si̱ta̱ va̱ꞌa xíꞌin loꞌo tia̱ká, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Tata Yivá yó Ndios, táxaꞌvi ñaꞌá ún ta̱xi ún ñaxíxi. Ta ta̱ꞌví ra si̱ta̱ va̱ꞌa yóꞌo, ta ta̱ꞌví ra tia̱ká, ta ta̱xi ra ña ndaꞌa̱ naxíka xíꞌin ra, ta nayóꞌo na̱taxi na ña ndaꞌa̱ ni̱vi kuxu na. ");
INSERT INTO mim_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ta na̱ni ña xi̱xi ndiꞌi ni̱vi nda̱ ni̱xaa ini na. Tá ndi̱ꞌi xi̱xi na, ta naxíka xíꞌin ta̱Jesús sa̱kutú na u̱xa̱ chikiva si̱ta̱ va̱ꞌa xíꞌin tia̱ká ña ki̱ndo̱o ndoso, chi ni̱‑kundeé ni̱vi kuxu ndiꞌi na ña. ");
INSERT INTO mim_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ta ndiꞌi ni̱vi na xi̱xi yóꞌo xi̱kuu na ko̱mi̱ mil ta̱a xíꞌin inka̱ kua̱ꞌa̱ ní násíꞌí xíꞌin kua̱ꞌa̱ ní naválí. ");
INSERT INTO mim_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra ni̱nda̱yi ra ni̱vi yóꞌo ta kua̱noꞌo̱ na, ta saá nda̱a ra tón barco, ta kua̱ꞌa̱n ra ñii xiiña na̱ní ña Magdala. ");
INSERT INTO mim_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ta nafariseo xíꞌin nasaduceo ki̱xaa̱ na no̱o̱ ta̱Jesús. Ta kóni koto ndoso na ra, káchí na saá xíꞌin ra: ―Keꞌé ún ñii milagro ña kunda̱a̱ ini ndi̱, tá ndixa Ndios ti̱ꞌví yóꞌó. ");
INSERT INTO mim_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin na: ―Tá ni̱kuaa, tá kukuáꞌá no̱o̱ sa̱kán ni̱ke̱tá ño̱ꞌo, ta káꞌa̱n ndó, káchí ndó saá: “Va̱ꞌa ní koo ki̱vi̱ taa̱n.” ");
INSERT INTO mim_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tá xita̱a̱n, tá kukuáꞌá ndiꞌi no̱o̱ sa̱kán va̱xi kana ño̱ꞌo, ta káꞌa̱n ndó, káchí ndó saá: “O̱n vása va̱ꞌa koo ki̱vi̱ vitin.” ¡Ni̱vi na o̱vi̱ yuꞌu̱ kúu ndóꞌó! Xíni̱ va̱ꞌa ndó ña kúu seña ña káchí ndasaá koo ki̱vi̱, ta, ¿nda̱chun o̱n vása kúnda̱a̱ ini ndó yukía̱ kóni kachí ña xíto ndó xíꞌin ña xíni̱ so̱ꞌo ndó kéꞌé i̱ vitin? ");
INSERT INTO mim_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","¡Ni̱vi na ndiva̱ꞌa ní ini, na o̱n vása kándixa Ndios kúu ndóꞌó! Saá chi ndúkú ndó ñii milagro no̱o̱ i̱ ña kandixa ndó tá ta̱a ta̱ ki̱xi no̱o̱ Ndios kúu i̱. Ta yi̱ꞌi̱ o̱n keꞌé i̱ inka̱ milagro ña koto ndó, chi va̱ꞌa ka̱ xíni̱ ñóꞌó kunda̱a̱ ini ndó ña ni̱ndoꞌo ta̱profeta Jonás kui̱ya̱ xi̱na̱ꞌá. Ta saá ke̱e ta̱Jesús kua̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ta nda̱a na tón barco ta kua̱ꞌa̱n na ni̱yaꞌa na inka̱ xiiña no̱o̱ mi̱ni, ta naxíka xíꞌin ta̱Jesús na̱ndoso na kuniꞌi na si̱ta̱ va̱ꞌa ko̱ꞌo̱n na. ");
INSERT INTO mim_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Koto va̱ꞌa ndó. O̱n nakiꞌin ndó levadura nafariseo xíꞌin nasaduceo. ");
INSERT INTO mim_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ta ni̱ka̱ꞌa̱n naxíka xíꞌin ra xíꞌin táꞌan na, káchí na saá: ―Káꞌa̱n ra saá xíꞌin yó chi o̱n ko̱ó si̱ta̱ va̱ꞌa níꞌi yó. ");
INSERT INTO mim_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ta ku̱nda̱a̱ ini ta̱Jesús yukía̱ ni̱ka̱ꞌa̱n xíꞌin táꞌan na, ta káchí ra saá xíꞌin na: ―Na o̱n vása kándixa kúu ndó. ¿Nda̱chun káꞌa̱n xíꞌin táꞌan ndó: “O̱n ko̱ó si̱ta̱ va̱ꞌa níꞌi yó”, káchí ndó? ");
INSERT INTO mim_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Án ta̱ꞌán kunda̱a̱ ini ndó? ¿Án na̱ndoso ndó ña ta̱ꞌví i̱ o̱ꞌo̱n si̱ta̱ va̱ꞌa xíxi na o̱ꞌo̱n mil ta̱a, ta ni̱ndo̱o kua̱ꞌa̱ ní ka̱ chikiva si̱ta̱ va̱ꞌa? ");
INSERT INTO mim_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Án na̱ndoso ndó xa̱ꞌa̱ u̱xa̱ si̱ta̱ va̱ꞌa xíxi na ko̱mi̱ mil ta̱a, ta ni̱ndo̱o kua̱ꞌa̱ ní ka̱ chikiva si̱ta̱ va̱ꞌa? ");
INSERT INTO mim_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nda̱chun o̱n vása kúnda̱a̱ ini ndó chi o̱n si̱ví xa̱ꞌa̱ si̱ta̱ va̱ꞌa kúu ña káꞌa̱n i̱ xíꞌin ndó vitin? Koto va̱ꞌa ndó, o̱n nakiꞌin ndó levadura nafariseo xíꞌin nasaduceo ―káchí ra xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ta saá ku̱nda̱a̱ ini na o̱n si̱ví xa̱ꞌa̱ levadura ña ñóꞌo xíꞌin si̱ta̱ va̱ꞌa kúu ña káꞌa̱n ta̱Jesús xa̱ꞌa̱. Ta ña káꞌa̱n ra xa̱ꞌa̱ xíꞌin na kúu ña koto va̱ꞌa na no̱o̱ to̱ꞌon ña sánáꞌa nafariseo xíꞌin nasaduceo. ");
INSERT INTO mim_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ta ki̱xaa̱ ta̱Jesús ñii xiiña no̱o̱ yóo yatin ñoo Cesarea Filipo, ta ni̱nda̱ka̱ to̱ꞌon ra naxíka xíꞌin ra: ―¿Yukía̱ káchí ni̱vi xa̱ꞌa̱ i̱ yu kúu i̱? ");
INSERT INTO mim_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ta nda̱kuii̱n na, káchí na saá: ―Sava ni̱vi káꞌa̱n yóꞌó kúu ún ta̱Juan, ta̱ sa̱kuchu ni̱vi. Sava na káꞌa̱n yóꞌó kúu ún ta̱profeta Elías. Ta inka̱ na káꞌa̱n yóꞌó kúu ún ta̱Jeremías án inka̱ ta̱profeta ta̱ xi̱taku̱ xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ta ni̱nda̱ka̱ to̱ꞌon ra na: ―Ta mi̱i ndó, ¿yukía̱ káchí ndó yu kúu i̱? ");
INSERT INTO mim_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ta nda̱kuii̱n ta̱Simón Pedro, ni̱ka̱ꞌa̱n ra: ―Yóꞌó kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ni̱vi ñoyívi yóꞌo, ta kúu ún Sa̱ꞌya Ndios ta̱táku̱. ");
INSERT INTO mim_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Ñava̱ꞌa ní ke̱ꞌé Ndios xíꞌin ún, tata Simón, sa̱ꞌya ta̱Jonás, chi o̱n si̱ví ni̱vi kúu na sa̱náꞌa yóꞌó ñanda̱a̱ yóꞌo. Ta Yivá i̱ Ndios, ta̱ yóo ñoyívi ni̱no, kúu ta̱ sa̱náꞌa yóꞌó. ");
INSERT INTO mim_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ndixa káꞌa̱n i̱ xíꞌin ún, ta vitin sakunaní i̱ yóꞌó Pedro, ta sa̱ta̱ yu̱u̱ yóꞌo kasa va̱ꞌa i̱ veꞌe ño̱ꞌo i̱ no̱o̱ nakutáꞌan ndiꞌi ni̱vi na kandixa yi̱ꞌi̱, ta nda̱ ñii ki̱vi̱ o̱n ndiꞌi xa̱ꞌa̱ ña, chi ndee̱ ña xáꞌni ni̱vi, o̱n kuchiño kundeé ka̱ ña no̱o̱ ni̱vi na kándixa yi̱ꞌi̱, ta kutaku̱ ndinoꞌo na ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ta nataxi i̱ ndaꞌa̱ ún llave ña nakuiná ún yéꞌé no̱o̱ ki̱ꞌvi nani̱vi yichi̱ no̱o̱ xáꞌnda chiño Ndios. Ta Ndios taxi ra nda̱yí ndaꞌa̱ ún ña ka̱ꞌa̱n ún yu kúu ñava̱ꞌa ta yu kúu ña o̱n váꞌa keꞌé ni̱vi ñoyívi yóꞌo. Ta saá koo yuꞌú ra xíꞌin ún xa̱ꞌa̱ ndiꞌi ñayóꞌo ―káchí ra xíꞌin ta̱Pedro. ");
INSERT INTO mim_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta o̱n ka̱ꞌa̱n ndó xíꞌin nda̱ ñii ni̱vi ndí yi̱ꞌi̱ kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ni̱vi ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nda̱ ki̱vi̱ yóꞌo ki̱xáꞌá ta̱Jesús ndáto̱ꞌon ra xíꞌin naxíka xíꞌin ra ndí xíni̱ ñóꞌó ko̱ꞌo̱n ra ñoo Jerusalén. Ta ñoo yóꞌo naxi̱kua̱ꞌa̱ no̱o̱ najudío, xíꞌin na sánáꞌa nda̱yí Ndios xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ saxo̱ꞌvi̱ ní na ra. Ta kaꞌni na ra, ta ki̱vi̱ u̱ni̱ nataku̱ ra, kasa Ndios. ");
INSERT INTO mim_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ta saá ta̱Pedro ta̱va síín ñaꞌá ra, ta ki̱xáꞌá ra ni̱na̱a ra xíꞌin ta̱Jesús xa̱ꞌa̱ ña ni̱ka̱ꞌa̱n ra, ta ta̱Pedro ni̱ka̱ꞌa̱n ra, káchí ra saá xíꞌin ta̱Jesús: ―¡Ná o̱n taxi Ndios kundoꞌo ún ñayóꞌo, Tata! ¡Nda̱ ñii ki̱vi̱ o̱n kundoꞌo ún saá! ");
INSERT INTO mim_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ta ndi̱kó koo ta̱Jesús ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Pedro, káchí ra saá: ―¡Kutaꞌa ún no̱o̱ i̱, ñandiva̱ꞌa káꞌno! Ta yóꞌó ta̱Pedro sási ún no̱o̱ i̱ ña o̱n kasa ndivi i̱ ña kóni Yivá i̱ Ndios. O̱n vása xáni ini ún nda̱tán xáni ini Ndios. Ta kuiti xáni ini ún nda̱tán xáni ini ni̱vi ―káchí ta̱Jesús xíꞌin ta̱Pedro. ");
INSERT INTO mim_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra: ―Ndiꞌi ni̱vi na kóni kundiko̱n yi̱ꞌi̱ xíni̱ ñóꞌó sandakoo na ndiꞌi ña káchí ini mi̱i na, ta kuso̱kó na tón cruz mi̱i na ta kundiko̱n na sa̱ta̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ndiꞌi ni̱vi na ndasaá kuiti ndúkú ña kutaku̱ va̱ꞌa na ñoyívi yóꞌo, ta o̱n xi̱in na xo̱ꞌvi̱ na xa̱ꞌa̱ i̱, ta nayóꞌo o̱n kuchiño na kutaku̱ na xíꞌin Ndios. Ta ni̱vi na o̱n vása ndíꞌi ini ndukú kutaku̱ va̱ꞌa na ñoyívi yóꞌo, xa̱ꞌa̱ ña kundiko̱n na yi̱ꞌi̱, nayóꞌo kúu ni̱vi na kutaku̱ xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tá kómí ni̱vi ndiꞌi ñakuíká ñoyívi yóꞌo, ta o̱n vása táku̱ ndinoꞌo na no̱o̱ Ndios, ta nda̱ ma̱ni̱ kúu ña. Saá chi o̱n kuchiño na chaꞌvi na xíꞌin ndiꞌi ñakuíká kómí na xa̱ꞌa̱ ña kutaku̱ na xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, va̱xi ñii ki̱vi̱ ndikó i̱ ñoyívi yóꞌo xíꞌin ndiꞌi ndee̱ ña va̱ꞌa ña livi yéꞌe Yivá i̱ Ndios, ta kixaa̱ naángel xíꞌin i̱, ta saá chaꞌvi i̱ ñii ñii ni̱vi xa̱ꞌa̱ ndiꞌi ñava̱ꞌa án ña o̱n váꞌa ke̱ꞌé na ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ndixa káꞌa̱n i̱ xíꞌin ndó, sava ndóꞌó na ndóo vitin, kutaku̱ ka̱ ndó ña kivi koni ndó yi̱ꞌi̱, ki̱vi̱ ndikó i̱ ñoyívi yóꞌo ña kaꞌnda chiño i̱ no̱o̱ ndiꞌi ni̱vi ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ni̱yaꞌa i̱ño̱ ki̱vi̱ ta ta̱Jesús na̱ka̱xin ra u̱ni̱ ta̱xíka xíꞌin ra, ta̱Pedro, ta̱Jacobo xíꞌin ta̱Juan ta̱ kúu ñani ta̱Jacobo yóꞌo, ta kua̱ꞌa̱n na xíꞌin ra ñii yuku̱ síkón. ");
INSERT INTO mim_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ta kán xi̱ni na na̱sama no̱o̱ ta̱Jesús. Nda̱tán yéꞌe ño̱ꞌo saá náyeꞌe no̱o̱ ra. Ta ndu̱yaa tiko̱to̱ ra. Nda̱tán yóo ñoꞌo̱ ña yéꞌe saá yóo tiko̱to̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ta saá ni̱ti̱vi ta̱Moisés xíꞌin ta̱Elías, ndáto̱ꞌon na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ta ni̱ka̱ꞌa̱n ta̱Pedro xíꞌin ta̱Jesús: ―Tata, va̱ꞌa ní ndóo yó yóꞌo. Tá kóni ún, ta kasa va̱ꞌa ndi̱ u̱ni̱ tia̱ꞌva, ñii ña koo mi̱i ún, ñii ña koo ta̱Moisés, ta inka̱ ña koo ta̱Elías ―káchí ta̱Pedro xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tá káꞌa̱n ka̱ ta̱Pedro, ta no̱o ñii vi̱ko̱ ña yéꞌe nda̱ no̱o̱ ñíndichi ra xíꞌin nata̱a yóꞌo, ta ni̱saꞌvi ndiꞌi na ti̱xin vi̱ko̱. Ta ti̱xin vi̱ko̱ yóꞌo ki̱xi to̱ꞌon ña ni̱ka̱ꞌa̱n Ndios, káchí ra saá: ―Ta̱yóꞌo kúu Sa̱ꞌya i̱, ta̱ kíꞌvi ní ini i̱ xíni i̱, ta kúsii̱ ní ini i̱ xíni i̱ ra. Ta koni̱ so̱ꞌo va̱ꞌa ndó to̱ꞌon ña káꞌa̱n ra ―káchí Ndios. ");
INSERT INTO mim_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tá xi̱ni̱ so̱ꞌo naxíka xíꞌin ta̱Jesús to̱ꞌon yóꞌo, ta xi̱kundee ndiꞌi na no̱o̱ ñoꞌo̱, ta ni̱yi̱ꞌví ní na. ");
INSERT INTO mim_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ta ta̱Jesús ki̱xaa̱ ra no̱o̱ na, ta ni̱to̱nda̱a ndaꞌa̱ ra na, ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―Ndakoo ndó. Ta o̱n kuyi̱ꞌví ndó. ");
INSERT INTO mim_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tá na u̱ni̱ yóꞌo na̱koto ndaa na, ta nda̱ ñii ni̱vi o̱n ko̱ó ka̱ ní‑xini na, nda̱ ñii la̱á kuiti ta̱Jesús ñíndichi no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tá va̱xi noo na yuku̱ yóꞌo, ta ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ na, káchí ra saá xíꞌin na: ―O̱n ndato̱ꞌon ndó xíꞌin nda̱ ñii ni̱vi ña sa̱kán xi̱ni ndó. Tá kixaa̱ ki̱vi̱ kivi̱ i̱ ta nataku̱ i̱, saá kivi ndato̱ꞌon ndó xíꞌin ni̱vi ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ta naxíka xíꞌin ra ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús, káchí na saá: ―¿Nda̱chun káꞌa̱n na sánáꞌa nda̱yí Ndios ndí siꞌna xíni̱ ñóꞌó kixi ta̱Elías, ta saá kixaa̱ ta̱a ta̱ tiꞌví Ndios saka̱ku ra ni̱vi ñoyívi yóꞌo? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ta nda̱kuii̱n ta̱Jesús: ―Ndixa ta̱Elías siꞌna xíni̱ ñóꞌó kixaa̱ ra, ta ndasa va̱ꞌa ndiꞌi ra ña̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ta yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ndó, xa ki̱xi ta̱Elías, ta o̱n vása ní‑nakoni ni̱vi ra, ta ke̱ꞌé na xíꞌin ra ndiꞌi ña o̱n váꞌa káchí ini mi̱i na. Ñii ki̱ꞌva sa̱xo̱ꞌvi̱ na ta̱yóꞌo, saá saxo̱ꞌvi̱ na yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ta saá ku̱nda̱a̱ ini naxíka xíꞌin ra ndí ta̱Jesús káꞌa̱n ra xa̱ꞌa̱ ta̱Juan, ta̱ sa̱kuchu ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ta ki̱xaa̱ ta̱Jesús xíꞌin naxíka xíꞌin ra no̱o̱ nákutáꞌan kua̱ꞌa̱ ní ni̱vi, ta ñii ta̱a ki̱xaa̱ yatin ra no̱o̱ ta̱Jesús, ta xi̱kuxítí ra no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ta ni̱ka̱ꞌa̱n ra, káchí ra saá xíꞌin ra: ―Tata, kundáꞌví ini ún koni ún ta̱loꞌo sa̱ꞌya i̱. Saá chi ta̱ xíꞌi̱ yi̱ꞌí kúu ra, ta ndeé ní kini xóꞌvi̱ ra. Kua̱ꞌa̱ ní yichi̱ nákava ra no̱o̱ xíxi̱ ñoꞌo̱, ta kua̱ꞌa̱ ní yichi̱ nákava ra ini takuií. ");
INSERT INTO mim_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ni̱xa̱ꞌa̱n ra xíꞌin i̱ no̱o̱ naxíka xíꞌin ún, ta o̱n vása ní‑kuchiño na sandaꞌa na ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi: ―¡Ni̱vi na toon ní ini kúu ndóꞌó, ta o̱n xi̱in ndó kandixa ndó Ndios! ¿Ndasaá ka̱ ki̱vi̱ xíni̱ ñóꞌó kutaku̱ i̱ xíꞌin ndó? ¿Nda̱ ama kundeé ini i̱ xíꞌin ndó? Ta vitin, va̱ꞌa taxi ndó ná kixi ta̱loꞌo yóꞌo no̱o̱ i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ta ki̱xaa̱ ta̱loꞌo ta ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ níma̱ ndiva̱ꞌa ña kee ña. Ta ñaníma̱ ndiva̱ꞌa yóꞌo ke̱e ña, ta xa̱ndi̱ko̱n ndu̱va̱ꞌa ta̱loꞌo. ");
INSERT INTO mim_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ta ki̱xaa̱ naxíka xíꞌin ta̱Jesús no̱o̱ ra, ta ni̱nda̱ka̱ to̱ꞌon seꞌé na ra: ―¿Nda̱chun o̱n vása ní‑kuchiño ndi̱ tava ndi̱ níma̱ ndiva̱ꞌa yóꞌo? ");
INSERT INTO mim_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ta nda̱kuii̱n ta̱Jesús, káchí ra xíꞌin na: ―O̱n vása ní‑kuchiño ndó chi xíni̱ ñóꞌó kandixa ka̱ ndó Ndios. Ndixa káꞌa̱n i̱ xíꞌin ndó, tá kandixa ndó Ndios vará nda̱ loꞌo kuiti, nda̱tán yóo ndiki̱n mostaza loꞌo ní ña, ta xa̱ꞌa̱ ña loꞌo kuiti kandixa ndó, ñayóꞌo taxi ña kukomí ndó ndee̱ ña ka̱ꞌa̱n ndó xíꞌin yuku̱ káꞌno ñíndichi yóꞌo: “Kutaꞌa ún yóꞌo ta kua̱ꞌa̱n ún inka̱ xiiña kaa̱”, kachí ndó, ta yuku̱ káꞌno ñíndichi yóꞌo kutaꞌa ña. Saá chi tá kándixa loꞌo ndó Ndios, ta kuchiño ndó kasa ndivi ndó ndiꞌi ña̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ta ñaníma̱ ndiva̱ꞌa táꞌan ña xi̱komí ta̱loꞌo yóꞌo, xíni̱ ñóꞌó koo soꞌon ndó ta ka̱ꞌa̱n ní ndó xíꞌin Ndios, saá kuchiño tava ndó ña ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ta yóo ta̱Jesús xíꞌin naxíka xíꞌin ra estado Galilea, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ñii ki̱vi̱ ña va̱xi ñii ta̱a nataxi ra yi̱ꞌi̱, ta̱ kúu ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndaꞌa̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ta nayóꞌo kaꞌni na yi̱ꞌi̱, ta to̱nda̱a ki̱vi̱ u̱ni̱ nataku̱ i̱, kasa Ndios ―káchí ra xíꞌin na. Ta kúchuchú ní ini naxíka xíꞌin ra xi̱ni̱ so̱ꞌo na to̱ꞌon yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tá ni̱xaa̱ ta̱Jesús xíꞌin naxíka xíꞌin ra ñoo Capernaum, ta na káya si̱ꞌún na̱ní dracma xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno ki̱xaa̱ na no̱o̱ ta̱Pedro, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá na: ―¿Án o̱n vása cháꞌvi ta̱Maestro si̱ꞌún xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno? ");
INSERT INTO mim_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ta nda̱kuii̱n ta̱Pedro, káchí ra saá: ―Cháꞌvi va ra ña ―káchí ra. Ta saá ta̱Pedro ni̱ki̱ꞌvi ra veꞌe, ta siꞌna ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra, káchí ra saá: ―¿Yukía̱ xáni ini ún, Simón? Narey ñoyívi yóꞌo, ¿yo no̱o̱ ni̱vi ndúkú na si̱ꞌún? ¿Án ndúkú na si̱ꞌún no̱o̱ nañoo mi̱i na, án ndúkú na si̱ꞌún no̱o̱ ni̱vi na inka̱ ñoo? ");
INSERT INTO mim_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ta nda̱kuii̱n ta̱Pedro: ―Ndúkú na ña no̱o̱ ni̱vi na inka̱ ñoo. Ta ni̱ka̱ꞌa̱n ta̱Jesús: ―Ta nañoo mi̱i narey o̱n vása cháꞌvi na. ");
INSERT INTO mim_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ta saá ni, xa̱ꞌa̱ ña o̱n sasaa̱ yó na, va̱ꞌa ka̱ kua̱ꞌa̱n ún mi̱ni, ta sakana ún ini takuií yiꞌva̱ ña kómí ka̱a chikíꞌí no̱o̱ ña satiin yuꞌu̱ títia̱ká, ta títia̱ká tíno̱ó tiin ún nakuiná ún yuꞌu̱ rí, ta naníꞌi ún ñii si̱ꞌún, ta ko̱ꞌo̱n ún veꞌe ño̱ꞌo káꞌno, ta chaꞌvi ún xa̱ꞌa̱ yi̱ꞌi̱ xíꞌin xa̱ꞌa̱ mi̱i ún ―káchí ta̱Jesús xíꞌin ta̱Pedro. ");
INSERT INTO mim_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ta ki̱xaa̱ naxíka xíꞌin ta̱Jesús no̱o̱ ra, ta ni̱nda̱ka̱ to̱ꞌon na ra: ―¿Yu kúu ta̱káꞌno ka̱ no̱o̱ xáꞌnda chiño Ndios? ");
INSERT INTO mim_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ta saá ka̱na ta̱Jesús ñii ta̱loꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱loꞌo yóꞌo kundichi ra ma̱ꞌñó no̱o̱ naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, tá o̱n vása ndasa ni̱no̱ xíꞌin mi̱i ndó, tá o̱n vása nduu ini ndó nda̱tán yóo ini naválí, ta o̱n ki̱ví ki̱ꞌvi ndó no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ta ta̱a ta̱ ndása loꞌo xíꞌin mi̱i, nda̱tán yóo ta̱loꞌo yóꞌo, ta ta̱yóꞌo kúu ta̱káꞌno ka̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ndiꞌi ni̱vi xa̱ꞌa̱ ña kándixa na yi̱ꞌi̱, ta nákiꞌin va̱ꞌa na naválí, kóni kachí ña saá, ndí yi̱ꞌi̱ nákiꞌin va̱ꞌa na ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá xíꞌin na: ―Tá yóo nakuálí na ndíko̱n yi̱ꞌi̱, ta ni̱vi na chíndaꞌá nakuálí yóꞌo ki̱ꞌvi na kua̱chi, ¡ndáꞌví ní ni̱vi yóꞌo! Va̱ꞌa ka̱ siꞌna inka̱ ni̱vi ná katón na ñii yu̱u̱ káꞌno si̱ko̱n nayóꞌo, ta sakana ñaꞌá na no̱o̱ kónó va̱ꞌa ini takuií, ña o̱n chindaꞌá na nakuálí ki̱ꞌvi na kua̱chi. ");
INSERT INTO mim_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ndáꞌví ní ni̱vi ñoyívi yóꞌo!, saá chi ndiꞌi ki̱vi̱ yóo kua̱ꞌa̱ ní ña o̱n váꞌa ña chíndaꞌá ni̱vi ki̱ꞌvi na kua̱chi. ¡Ta ndáꞌví ní ka̱ ni̱vi na chíndaꞌá inka̱ ni̱vi ki̱ꞌvi na kua̱chi! ");
INSERT INTO mim_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Tá ñii ndaꞌa̱ ndó án ñii xa̱ꞌa̱ ndó kúu ña chíndaꞌá ndóꞌó kua̱n ki̱ꞌvi ndó kua̱chi, ta saá va̱ꞌa ka̱ kandoso ndó ña ta sakana ndó ña. Chi va̱ꞌa ka̱ kutaku̱ ndó xíꞌin ñii la̱á ndaꞌa̱ ndó án ñii la̱á xa̱ꞌa̱ ndó, no̱o̱ ña ko̱ꞌo̱n ndó xíꞌin o̱vi̱ ndaꞌa̱ ndó ta xíꞌin o̱vi̱ xa̱ꞌa̱ ndó nda̱ya no̱o̱ xíxi̱ ñoꞌo̱ ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tá ñii nduchu̱ no̱o̱ ndó kúu ña chíndaꞌá ndóꞌó kua̱n ki̱ꞌvi ndó kua̱chi, ta va̱ꞌa ka̱ tava ndó ña ta sakana ndó ña. Chi va̱ꞌa ka̱ kutaku̱ ndó xíꞌin ñii la̱á nduchu̱ no̱o̱ ndó, no̱o̱ ña ko̱ꞌo̱n ndó xíꞌin o̱vi̱ nduchu̱ no̱o̱ ndó nda̱ya ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ta nda̱to̱ꞌon tuku ta̱Jesús ñii cuento ña sanáꞌa ra na, káchí ra saá: ―Koto va̱ꞌa ndó ña o̱n kani si̱ni̱ ndó na o̱n vása ndáya̱ꞌví kúu naválí yóꞌo. Káꞌa̱n i̱ xíꞌin ndó, naángel na ndáa naválí yóꞌo ndóo na ndiꞌi saá ki̱vi̱ xíꞌin Yivá i̱ Ndios, ta̱ yóo ñoyívi ni̱no. ");
INSERT INTO mim_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Saá chi yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ki̱xaa̱ i̱ ñoyívi yóꞌo saka̱ku i̱ ni̱vi na nda̱ñóꞌó. ");
INSERT INTO mim_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Yukía̱ xáni ini ndó? Tá yóo ñii ta̱a kómí ra ñii ciento ndikachi sa̱na̱ ra, ta ñii rí nda̱ñóꞌó, ta saá, ¿án o̱n sandakoo ra tí ko̱mi̱ si̱ko̱ xa̱ꞌo̱n ko̱mi̱ kundo̱o mi̱i rí yuku̱, ta ko̱ꞌo̱n ra nandukú ra tí nda̱ñóꞌó? ");
INSERT INTO mim_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ndixa káꞌa̱n i̱ xíꞌin ndó, tá naníꞌi ra rí, ta kusii̱ ní ka̱ ini ra xa̱ꞌa̱ tí na̱níꞌi ra no̱o̱ ndiꞌi inka̱ tí ko̱mi̱ si̱ko̱ xa̱ꞌo̱n ko̱mi̱ sa̱na̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nda̱tán yóo ta̱ ndáa ndikachi, saá yóo Yivá yó Ndios, ta̱ yóo ñoyívi ni̱no. O̱n xi̱in ra ndañóꞌó nda̱ ñii ni̱vi no̱o̱ ra ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Tá yóo ñii ta̱táꞌan ún, ta ke̱ꞌé ra ña o̱n váꞌa xíꞌin ún, ta xíni̱ ñóꞌó ko̱ꞌo̱n matóꞌón ún ka̱ꞌa̱n ún xíꞌin ra ña o̱n keꞌé ka̱ ra ña o̱n váꞌa saá xíꞌin ún. Tá ta̱yóꞌo chikaa̱ so̱ꞌo ra ña káꞌa̱n ún, ta ndikó ini ra xa̱ꞌa̱ ña o̱n váꞌa ke̱ꞌé ra, ta saá tuku nakoo va̱ꞌa ra xíꞌin ún ta nakoo va̱ꞌa ra xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tá ta̱yóꞌo o̱n xi̱in ra koni̱ so̱ꞌo ra ña káꞌa̱n ún, ta saá kana ún ñii án o̱vi̱ ni̱vi ko̱ꞌo̱n na xíꞌin ún, ta no̱o̱ nayóꞌo ka̱ꞌa̱n tuku ún xíꞌin ra. Ta saá kasa ndivi ún to̱ꞌon Ndios, ña káchí ndí xíni̱ ñóꞌó o̱vi̱ án u̱ni̱ ni̱vi na ndakuii̱n kasa nda̱a̱ xa̱ꞌa̱ kua̱chi. ");
INSERT INTO mim_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ta saá ni, tá ta̱yóꞌo o̱n xi̱in ra koni̱ so̱ꞌo ra ña káꞌa̱n u̱ni̱ ndó xíꞌin ra, ta saá ndato̱ꞌon ndó xíꞌin na veꞌe ño̱ꞌo yukía̱ ke̱ꞌé ra. Tá o̱n xi̱in ra koni̱ so̱ꞌo ra ña káꞌa̱n na veꞌe ño̱ꞌo, ta keꞌé ndó xíꞌin ta̱yóꞌo nda̱tán yóo ña kéꞌé ndó xíꞌin ta̱ o̱n vása kándixa Ndios, án nda̱tán yóo ña kéꞌé ndó xíꞌin ñii ta̱a ta̱ káya si̱ꞌún xa̱ꞌa̱ nagobierno ñoo Roma, saá keꞌé ndó xíꞌin ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ta Ndios taxi ra nda̱yí ndaꞌa̱ ndó ña ka̱ꞌa̱n ndó yu kúu ñava̱ꞌa ta yu kúu ña o̱n váꞌa keꞌé ni̱vi ñoyívi yóꞌo. Ta saá koo yuꞌú ra xíꞌin ndó xa̱ꞌa̱ ndiꞌi ñayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ta káꞌa̱n i̱ xíꞌin ndó, tá yóo yuꞌú o̱vi̱ ndó ñoyívi yóꞌo xa̱ꞌa̱ ña ndukú ndó no̱o̱ Ndios, ta saá Yivá i̱ ta̱ yóo ñoyívi ni̱no kasa ndivi ra ña. ");
INSERT INTO mim_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Saá chi no̱o̱ nákutáꞌan o̱vi̱ án u̱ni̱ na ndíko̱n sa̱ta̱ i̱ ta káꞌa̱n na xíꞌin i̱, ta yi̱ꞌi̱ yóo i̱ xíꞌin nayóꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ta saá ta̱Pedro ni̱to̱nda̱a yatin ra no̱o̱ ta̱Jesús, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá ra: ―Tata, ¿ndasaá yichi̱ xíni̱ ñóꞌó kasa káꞌno ini i̱ xa̱ꞌa̱ ta̱a ta̱ kéꞌé ña o̱n váꞌa xíꞌin i̱? ¿Án va̱ꞌa a̱nda̱ u̱xa̱ yichi̱ kasa káꞌno ini i̱ xa̱ꞌa̱ ra? ");
INSERT INTO mim_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ta nda̱kuii̱n ta̱Jesús: ―O̱n vása káꞌa̱n i̱ xíꞌin ún a̱nda̱ u̱xa̱ yichi̱ kasa káꞌno ini ún xa̱ꞌa̱ ra, káꞌa̱n i̱ xíꞌin ún a̱nda̱ u̱ni̱ si̱ko̱ u̱xu̱ yichi̱ u̱xa̱, saá kasa káꞌno ini ún xa̱ꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ta nda̱to̱ꞌon ta̱Jesús ñii cuento ña sanáꞌa ra na: ―Nda̱tán yóo ñii ta̱rey kóni ra ndasa va̱ꞌa ra kuenda xíꞌin na kísa chiño no̱o̱ ra, saá yóo no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ta yóo ñii ta̱a ta̱ kísa chiño no̱o̱ ta̱rey, ta níká ra no̱o̱ ta̱rey u̱xu̱ mil si̱ꞌún na̱ní talento. Ta ki̱vi̱ ki̱xáꞌá ta̱rey ndása va̱ꞌa ra kuenda, ta ni̱vi ki̱xaa̱ na xíꞌin ta̱ níká yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ta o̱n vása ní‑kuchiño taxaꞌvi ra si̱ꞌún ta̱rey, ta saá xa̱ꞌnda chiño ta̱rey ña si̱kó na ra kuu ra esclavo, nda̱tán kasa chiño kiti̱ saá kasa chiño ra no̱o̱ xitoꞌo ra. Ta xa̱ꞌnda chiño tuku ta̱rey ña si̱kó na ñásíꞌí ra xíꞌin sa̱ꞌya ra, xíꞌin ndiꞌi ña kómí ra ña chaꞌvi ra ndiꞌi ña níká ra. ");
INSERT INTO mim_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ta saá ta̱ kísa chiño yóꞌo xi̱kuxítí ra ta xa̱ku ndáꞌví ra no̱o̱ ta̱rey, káchí ra saá: “Tata, kundáꞌví ini ún koni ún yi̱ꞌi̱, ta saá chaꞌvi ndiꞌi i̱ si̱ꞌún ña níká i̱ ndaꞌa̱ ún.” ");
INSERT INTO mim_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ta saá ku̱ndáꞌví ini ta̱rey xi̱ni ra ta̱yóꞌo, ta ki̱sa káꞌno ini ra xa̱ꞌa̱ ña níká ra, ta ta̱xi ra nda̱yí kua̱ꞌa̱n ndíka̱ ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ta saá ta̱ kísa chiño yóꞌo ke̱e ra kua̱ꞌa̱n ra, ta yichi̱ na̱kutáꞌan ra xíꞌin inka̱ ta̱táꞌan mi̱i ra ta̱ níká no̱o̱ ra ñii ciento si̱ꞌún válí na̱ní denario. Ta ti̱in ra si̱ko̱n ta̱ níká loꞌo yóꞌo no̱o̱ ra ta ki̱xáꞌá ra sákuáꞌna ñaꞌá ra, káchí ra saá xíꞌin ra: “¡Chaꞌvi yi̱ꞌi̱ vitin ña níká ún no̱o̱ i̱!” ");
INSERT INTO mim_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ta saá ta̱táꞌan ra ta̱ níká loꞌo yóꞌo xi̱kuxítí ra ta xa̱ku ndáꞌví ra no̱o̱ ra, ta káchí ra saá: “Kundáꞌví ini ún koni ún yi̱ꞌi̱, ta chaꞌvi ndiꞌi i̱ ña níká i̱ ndaꞌa̱ ún.” ");
INSERT INTO mim_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ta ni̱‑xiin ra kundati ra. Ta saá chi̱kaa̱ ra ta̱ níká loꞌo yóꞌo no̱o̱ ra ini veꞌe ka̱a a̱nda̱ chaꞌvi ra ndiꞌi ña níká ra. ");
INSERT INTO mim_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ta inka̱ na kísa chiño no̱o̱ ta̱rey xi̱ni na ña ndóꞌo ta̱ níká loꞌo, ta kúchuchú ní ini na, ta ni̱xa̱ꞌa̱n na nda̱to̱ꞌon na xíꞌin ta̱rey ndiꞌi ña xi̱ni na ndo̱ꞌo ta̱ níká loꞌo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ta saá ta̱rey ka̱na ra ta̱ ki̱sa káꞌno ini ra xa̱ꞌa̱ yóꞌo, ta ki̱xaa̱ ra no̱o̱ ra, ta ta̱rey ni̱ka̱ꞌa̱n ra xíꞌin ra, káchí ra saá: “¡Yóꞌó ta̱a ndiva̱ꞌa kúu ún! Ki̱sa káꞌno ini i̱ xa̱ꞌa̱ ndiꞌi ña níká ún no̱o̱ i̱, chi xa̱ku ndáꞌví ún no̱o̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ñii ki̱ꞌva nda̱tán ki̱sa káꞌno ini i̱ xa̱ꞌa̱ ún, saá xíni̱ ñóꞌó kasa káꞌno ini ún xa̱ꞌa̱ ta̱táꞌan ún ta̱ níká loꞌo no̱o̱ ún.” ");
INSERT INTO mim_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ta ta̱rey ni̱saa̱ ní ini ra, ta chi̱kaa̱ ra ta̱yóꞌo ini veꞌe ka̱a, ta xa̱ꞌnda chiño ra ña saxo̱ꞌvi̱ ñaꞌá na a̱nda̱ kixaa̱ ki̱vi̱ ña chaꞌvi ndiꞌi ra ña níká ra. Saá ndi̱ꞌi cuento loꞌo yóꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ta tuku káchí ta̱Jesús saá: ―Nda̱tán ke̱ꞌé ta̱rey yóꞌo, ñii ki̱ꞌva saá keꞌé Yivá i̱ Ndios xíꞌin ndó, tá o̱n xi̱in ndó kasa káꞌno ndinoꞌo ini ndó xa̱ꞌa̱ natáꞌan ndó. ");
INSERT INTO mim_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ta ndi̱ꞌi ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, ta saá ke̱e ra estado Galilea ta kua̱ꞌa̱n ra estado Judea ña nákaa̱ inka̱ táꞌví yuꞌu̱ yu̱ta Jordán. ");
INSERT INTO mim_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ta kua̱ꞌa̱ ní ni̱vi xi̱ndiko̱n na sa̱ta̱ ra, ta sa̱ndaꞌa ra na ndeé ndóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ta sava nafariseo ki̱xaa̱ na no̱o̱ ra ña koto ndoso ñaꞌá na, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―¿Án yóo yichi̱ ñii ta̱a sandakoo va̱ꞌa ra ñásíꞌí ra xa̱ꞌa̱ ña káchí ini mi̱i ra? ");
INSERT INTO mim_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―¿Án o̱n vása ní‑kaꞌvi ndó to̱ꞌon Ndios ña káꞌa̱n xa̱ꞌa̱ ki̱vi̱ ki̱sa va̱ꞌa Ndios ñoyívi yóꞌo? Chi Ndios ki̱sa va̱ꞌa ra ñii ta̱a xíꞌin ñii ñaꞌa̱. ");
INSERT INTO mim_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ta ni̱ka̱ꞌa̱n Ndios: “Xa̱ꞌa̱ ñayóꞌo ñii ta̱a sandakoo ra yivá ra ta sandakoo ra siꞌí ra ña tonda̱ꞌa̱ ra xíꞌin ñásíꞌí ra, ta na o̱vi̱ yóꞌo nduu na ñii ni̱vi”, káchí to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ta saá, o̱n si̱ví ka̱ o̱vi̱ ni̱vi kúu na, saá chi ñii ni̱vi kúu na no̱o̱ Ndios. Ta ni̱vi na sa̱nakutáꞌan Ndios, nda̱ ñii inka̱ ni̱vi o̱n váꞌa sataꞌví táꞌan na nayóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ta ni̱nda̱ka̱ to̱ꞌon nafariseo ta̱Jesús: ―Ta saá, ¿nda̱chun ta̱xi ta̱Moisés nda̱yí ndaꞌa̱ ta̱a ña kasa va̱ꞌa ra tutu xa̱ꞌa̱ ña sandakoo va̱ꞌa ra ñásíꞌí ra, ta ka̱ꞌa̱n ra nda̱yi ra ñá ko̱ꞌo̱n ñá? ");
INSERT INTO mim_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ta nda̱kuii̱n ta̱Jesús: ―Ta̱Moisés ta̱xi ra nda̱yí ña sandakoo va̱ꞌa nata̱a ñásíꞌí na chi ndóꞌó najudío ni̱‑xiin ndó chikaa̱ ndó to̱ꞌon Ndios ini ndó. Chi xi̱na̱ꞌá ki̱vi̱ ki̱xáꞌá ñoyívi o̱n vása ní‑chitóni̱ Ndios sandakoo va̱ꞌa ta̱a ñásíꞌí ra. ");
INSERT INTO mim_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ta yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ndó, tá ñii ñaꞌa̱ ñá yóo yii̱ ta o̱n vása ní‑kiꞌvi ñá kua̱chi xíꞌin inka̱ ta̱a, ta yii̱ ñá o̱n ko̱ó yichi̱ kómí ra sandakoo va̱ꞌa ra ñá. Tá ñii ta̱a sandakoo va̱ꞌa ra ñásíꞌí ra, ta tonda̱ꞌa̱ tuku ra, ta̱yóꞌo ki̱ꞌvi ra kua̱chi xíꞌin ñásíꞌí ra ñáo̱vi̱. Ta ta̱a ta̱ tonda̱ꞌa̱ xíꞌin ñáñaꞌa̱ ñá ni̱ndo̱o, ki̱sa yii̱ ñá, ta ta̱yóꞌo ki̱ꞌvi ra kua̱chi xíꞌin ñá, chi ñásíꞌí ta̱no̱ó kúu ñá no̱o̱ Ndios ―káchí ta̱Jesús xíꞌin nafariseo. ");
INSERT INTO mim_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ta naxíka xíꞌin ra ni̱ka̱ꞌa̱n na, káchí na saá xíꞌin ta̱Jesús: ―Tá o̱n ko̱ó yichi̱ sandakoo va̱ꞌa ta̱a ñásíꞌí ra, ta va̱ꞌa ka̱ o̱n tonda̱ꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―Yóo ni̱vi na o̱n ki̱ví nakiꞌin to̱ꞌon yóꞌo. Ta ndasaá kuiti ni̱vi na chindeé Ndios kuchiño nakiꞌin va̱ꞌa to̱ꞌon yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yóo ta̱a ta̱ o̱n vása tónda̱ꞌa̱ chi saá ka̱ku ra. Yóo inka̱ ta̱a ta̱ o̱n kúchiño koni̱ ñóꞌó ra ñaꞌa̱, saá chi xa̱ꞌnda na ra ña o̱n koni̱ ñóꞌó ka̱ ra ñaꞌa̱. Ta yóo inka̱ ta̱a ta̱ chíkaa̱ ini o̱n tonda̱ꞌa̱, saá chi kóni ra kasa chiño ra no̱o̱ Ndios. Ndiꞌi ta̱a ta̱ va̱ꞌa kúchiño nakiꞌin to̱ꞌon yóꞌo, xíni̱ ñóꞌó kasa ndivi ra ña ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ta ki̱xaa̱ ni̱vi xíꞌin naválí no̱o̱ yóo ta̱Jesús ña chinóo ra ndaꞌa̱ ra si̱ni̱ na, ta ndukú ra ñava̱ꞌa no̱o̱ Ndios xa̱ꞌa̱ na. Ta naxíka xíꞌin ra ni̱ka̱ꞌa̱n na xíꞌin ni̱vi yóꞌo: ―O̱n kixi ndó xíꞌin naválí yóꞌo ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ta ni̱ka̱ꞌa̱n ta̱Jesús saá: ―Taxi ndó naválí ná kixi na no̱o̱ i̱, o̱n kasi ndó no̱o̱ na ña kixi na, chi ni̱vi na ndíko̱n yichi̱ no̱o̱ xáꞌnda chiño Ndios, nda̱tán yóo naválí yóꞌo, saá yóo na. ");
INSERT INTO mim_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ta chi̱nóo ra ndaꞌa̱ ra si̱ni̱ naválí yóꞌo, ta saá ke̱e ra kua̱ꞌa̱n ra inka̱ xiiña. ");
INSERT INTO mim_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ta ñii ta̱a ki̱xaa̱ ra no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Tata maestro, ta̱a va̱ꞌa ini kúu ún, ¿ndá chiño va̱ꞌa xíni̱ ñóꞌó keꞌé i̱, ta taxi Ndios ña kutaku̱ i̱ xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi? ");
INSERT INTO mim_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ta nda̱kuii̱n ta̱Jesús: ―¿Nda̱chun káꞌa̱n ún yi̱ꞌi̱ kúu ta̱a va̱ꞌa ini? Saá chi o̱n ko̱ó nda̱ ñii ni̱vi va̱ꞌa ini, ñii la̱á Ndios kuiti kúu ta̱ va̱ꞌa ndinoꞌo ini. Tá kóni ún kutaku̱ ún xíꞌin Ndios ndiꞌi saá ki̱vi̱ ña va̱xi, ta xíni̱ ñóꞌó kasa ndivi ún nda̱yí ra. ");
INSERT INTO mim_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ta saá ni̱nda̱ka̱ to̱ꞌon ta̱yóꞌo ta̱Jesús, káchí ra: ―¿Ndá nda̱yí xíni̱ ñóꞌó kasa ndivi i̱? ―káchí ra. Ta nda̱kuii̱n ta̱Jesús; ―O̱n kaꞌni ún ni̱vi, o̱n ki̱ꞌvi ún kua̱chi ñoyívi xíꞌin inka̱ ñaꞌa̱ ñá o̱n si̱ví kúu ñásíꞌí ún, o̱n kasa kuíꞌná ún ña kómí ni̱vi, o̱n ka̱ꞌa̱n ún ñavatá xa̱ꞌa̱ inka̱ ni̱vi, ");
INSERT INTO mim_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ta kasa to̱ꞌó ún yivá ún, ta kasa to̱ꞌó ún siꞌí ún, ta ñii ki̱ꞌva nda̱tán kíꞌvi ini ún xíni ún xíꞌin mi̱i ún, saá kukiꞌvi ini ún koni ún natáꞌan ún ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ta saá nda̱kuii̱n ta̱yóꞌo, ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Yi̱ꞌi̱ nda̱ loꞌo i̱ kísa ndivi i̱ ndiꞌi saá nda̱yí yóꞌo. ¿Án yóo inka̱ chiño kúma̱ni̱ kasa ndivi i̱? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ta nda̱kuii̱n ta̱Jesús: ―Tá kóni ún kuu ún ta̱ va̱ꞌa ndinoꞌo ini, ta kua̱ꞌa̱n ún si̱kó ún ndiꞌi ñakuíká kómí ún, ta saníꞌi ún si̱ꞌún ndaꞌa̱ nandáꞌví. Ta saá kukomí ún ñakuíká ndinoꞌo xíꞌin Ndios ñoyívi ni̱no. Tá ndi̱ꞌi ke̱ꞌé ún ñava̱ꞌa yóꞌo, ta kixi ún kundiko̱n ún yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ta xi̱ni̱ so̱ꞌo ta̱yóꞌo ña ni̱ka̱ꞌa̱n ta̱Jesús, ta kúchuchú ní ini ra, ta ke̱e ra kua̱ꞌa̱n ra, saá chi kua̱ꞌa̱ ní ñakuíká kómí ra. ");
INSERT INTO mim_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, yo̱ꞌvi̱ ní ki̱ꞌvi nakuíká yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tuku káꞌa̱n i̱ xíꞌin ndó, vará yo̱ꞌvi̱ ní tá kuchiño ñii tícamello yaꞌa rí yavi̱ xa̱ꞌa̱ túkú, ta yo̱ꞌvi̱ ní ka̱ kuchiño yaꞌa ñii ta̱kuíká yéꞌé ña ki̱ꞌvi ra yichi̱ no̱o̱ xáꞌnda chiño Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ta naxíka xíꞌin ra xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱Jesús, ta na̱kaꞌnda ní ini na, ta ni̱nda̱ka̱ to̱ꞌon na ra: ―Tá yo̱ꞌvi̱ ní ki̱ꞌvi nakuíká yichi̱ Ndios, ta, ¿yu kúu ni̱vi kuchiño ki̱ꞌvi yichi̱ Ndios ta kundo̱o na xíꞌin ra? ");
INSERT INTO mim_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ta ta̱Jesús xi̱to ra no̱o̱ na, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ni̱vi o̱n kúchiño na saka̱ku xíꞌin mi̱i na, ñii la̱á Ndios kúu ta̱ kúchiño saka̱ku ñaꞌá. Ndios kúchiño kasa ndivi ra ndiꞌi chiño. O̱n ko̱ó ña yo̱ꞌvi̱ no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ta ni̱ka̱ꞌa̱n ta̱Pedro xíꞌin ra: ―Ta mi̱i ndi̱, xa sa̱ndakoo ndi̱ ndiꞌi ñava̱ꞌa ña xi̱komí ndi̱, xa̱ꞌa̱ ña ndíko̱n ndi̱ sa̱ta̱ ún. ¿Yu kúu ñava̱ꞌa nakiꞌin ndi̱ xa̱ꞌa̱ ñayóꞌo? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, tá ki̱xaa̱ ki̱vi̱ ña nduxa̱á ñoyívi, ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, koo i̱ táyi̱ káꞌno tón livi ña kaꞌnda chiño i̱, ta mi̱i ndó na ndíko̱n yi̱ꞌi̱ kundo̱o ndó u̱xu̱ o̱vi̱ táyi̱ náꞌno, ta kaꞌnda chiño ndó no̱o̱ na u̱xu̱ o̱vi̱ tiꞌvi ni̱vi nañoo Israel. ");
INSERT INTO mim_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta ndiꞌi ni̱vi na sa̱ndakoo veꞌe na, án ñani na, án ki̱ꞌva̱ na, án yivá na, án siꞌí na, án ñásíꞌí na, án sa̱ꞌya na, án ñoꞌo̱ na, xa̱ꞌa̱ ña chi̱kaa̱ ini na ko̱ꞌo̱n na yichi̱ no̱o̱ xáꞌnda chiño Ndios, ta nayóꞌo nakiꞌin na ñava̱ꞌa no̱o̱ Ndios. Ñoyívi yóꞌo Ndios taxi ra ndaꞌa̱ na kua̱ꞌa̱ ní ka̱ ñava̱ꞌa, a̱nda̱ ñii ciento ñava̱ꞌa xa̱ꞌa̱ ñii ñii ñava̱ꞌa ña sa̱ndakoo na. Ta saá ñoyívi ni̱no Ndios taxi ra ña kutaku̱ na xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ta saá kua̱ꞌa̱ ní ni̱vi nano̱ó nduu na ni̱vi nasondíꞌí, ta ni̱vi nasondíꞌí vitin nduu na ni̱vi nano̱ó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ta nda̱to̱ꞌon ta̱Jesús ñii cuento ña sanáꞌa ra na: ―Nda̱tán yóo ñii ta̱a ta̱ kómí ñoꞌo̱, saá yóo yichi̱ no̱o̱ xáꞌnda chiño Ndios. Ta ta̱yóꞌo ke̱e ra veꞌe ra xita̱a̱n ní, ta kua̱ꞌa̱n ra ndukú ra na kasa chiño xíꞌin ra no̱o̱ ñoꞌo̱ no̱o̱ na̱taan ra tón uva. ");
INSERT INTO mim_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta na̱níꞌi ra ni̱vi, ta ni̱ka̱ꞌa̱n ra xíꞌin na: “Chaꞌvi i̱ ndóꞌó ñii si̱ꞌún denario tá ko̱ꞌo̱n ndó kasa chiño ndó ki̱vi̱ vitin no̱o̱ ñoꞌo̱ i̱ no̱o̱ na̱taan i̱ tón uva.” Ta saá kua̱ꞌa̱n na kasa chiño na. ");
INSERT INTO mim_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ta ka̱a i̱i̱n xita̱a̱n tuku kua̱ꞌa̱n ra, ta xi̱ni ra sava ni̱vi ndóo na no̱yáꞌvi chi o̱n ko̱ó chiño kómí na. ");
INSERT INTO mim_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ta ni̱ka̱ꞌa̱n ra xíꞌin na: “Ko̱ꞌo̱n ndó kasa chiño ndó no̱o̱ ñoꞌo̱ i̱ no̱o̱ na̱taan i̱ tón uva, ta chaꞌvi i̱ ndóꞌó ña kúu yaꞌvi ndó.” Ta saá kua̱ꞌa̱n na kasa chiño na no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ta ka̱a u̱xu̱ o̱vi̱ ta tuku ka̱a u̱ni̱ xikuaa tuku ke̱e ra kua̱ꞌa̱n ra, ta na̱níꞌi ra ni̱vi na kasa chiño no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ta ka̱a o̱ꞌo̱n xikuaa tuku ke̱e ra kua̱ꞌa̱n ra, ta na̱níꞌi ra inka̱ ni̱vi na ndóo mi̱i ta o̱n ko̱ó chiño kómí na. Ta ni̱nda̱ka̱ to̱ꞌon ra na: “¿Nda̱chun ndiví nda̱a̱ ndóo mi̱i ndó yóꞌo, ta o̱n vása kísa chiño ndó?” ");
INSERT INTO mim_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ta nda̱kuii̱n na: “Chi nda̱ ñii ni̱vi o̱n vása ní‑kaꞌa̱n xíꞌin ndi̱ kasa chiño ndi̱ xíꞌin na.” Ta saá ni̱ka̱ꞌa̱n ra xíꞌin na: “Ndóꞌó ko̱ꞌo̱n ndó kasa chiño ndó no̱o̱ ñoꞌo̱ i̱ no̱o̱ na̱taan i̱ tón uva, ta nakiꞌin ndó ña kúu yaꞌvi ndó.” ");
INSERT INTO mim_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tá xikuaa ni̱ke̱tá ño̱ꞌo kúu ña, ta ta̱ xíꞌin ñoꞌo̱ no̱o̱ kísa chiño na ni̱ka̱ꞌa̱n ra xíꞌin ta̱ ndíso chiño no̱o̱ na kísa chiño no̱o̱ ra, káchí ra saá: “Kana ún na kísa chiño kixi na yóꞌo, ta chaꞌvi ún na. Siꞌna kixáꞌá ún chaꞌvi ún na ni̱ki̱ꞌvi sondíꞌí, ta sandiꞌi ún chaꞌvi ún na siꞌna ni̱ki̱ꞌvi ki̱sa chiño.” ");
INSERT INTO mim_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ta ki̱xaa̱ na ni̱ki̱ꞌvi ki̱sa chiño ka̱a o̱ꞌo̱n xikuaa, ta ñii ñii na na̱kiꞌin na ñii si̱ꞌún denario. ");
INSERT INTO mim_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ta saá ki̱xaa̱ na ni̱ki̱ꞌvi no̱ó na xita̱a̱n ní ki̱xáꞌá ki̱sa chiño, ta nayóꞌo ndáti na nakiꞌin ka̱ na si̱ꞌún. Ta ñii ñii nayóꞌo na̱kiꞌin na ñii la̱á si̱ꞌún denario. ");
INSERT INTO mim_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ta ki̱xáꞌá na káꞌa̱n kuáchí na no̱o̱ ta̱a ta̱ xíꞌin ñoꞌo̱ no̱o̱ ki̱sa chiño na, ");
INSERT INTO mim_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","káchí na saá xíꞌin ra: “Ni̱vi na ki̱sa chiño ñii la̱á hora, ta na̱kiꞌin na si̱ꞌún ñii ki̱ꞌva nda̱tán yóo ña na̱kiꞌin ndi̱ꞌi̱ na ki̱sa chiño ndiví nda̱a̱, ta ndeé ní ki̱sa chiño ndi̱ ta ñiꞌní ní ni̱xiꞌi̱ ndi̱.” ");
INSERT INTO mim_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ta nda̱kuii̱n ta̱a ta̱ xíꞌin ñoꞌo̱, káchí ra saá xíꞌin ñii ta̱yóꞌo: “Tata migo, o̱n vása kéꞌé i̱ nda̱ ñii ña o̱n váꞌa xíꞌin ún. ¿Án o̱n vása ní‑kindo̱o yuꞌú ún xíꞌin i̱ nakiꞌin ún ñii si̱ꞌún denario? ");
INSERT INTO mim_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Va̱ꞌa ná kiꞌin ún si̱ꞌún ún ta kua̱noꞌo̱ ún vitin. Saá chi yi̱ꞌi̱ káchí ini i̱ chaꞌvi i̱ ñii si̱ꞌún ta̱ kísa chiño sondíꞌí nda̱tán yóo ña cha̱ꞌvi i̱ yóꞌó. ");
INSERT INTO mim_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Án o̱n ko̱ó yichi̱ kómí i̱ keꞌé i̱ ña kóni i̱ xíꞌin si̱ꞌún i̱? ¿Án kísa kuíni̱ ini ún chi ta̱ va̱ꞌa ini kúu i̱ xíꞌin ni̱vi?”, káchí ta̱ xíꞌin ñoꞌo̱ xíꞌin ta̱ kísa chiño no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ta saá ni̱vi nano̱ó nduu na ni̱vi nasondíꞌí, ta ni̱vi nasondíꞌí vitin nduu na ni̱vi nano̱ó. Saá chi Ndios nákana ra kua̱ꞌa̱ ní ni̱vi, ta loꞌo kuiti kúu na na̱ka̱xin ra ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ta kua̱ꞌa̱n ta̱Jesús yichi̱ kua̱n ndaa ñoo Jerusalén, ta ta̱va síín ra u̱xu̱ o̱vi̱ naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ");
INSERT INTO mim_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Ta vitin kua̱ꞌa̱n yó yichi̱ kua̱n ndaa ñoo Jerusalén, ta ñii ta̱a nataxi ra yi̱ꞌi̱, ta̱ kúu ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndaꞌa̱ nanáꞌno no̱o̱ nasu̱tu̱, xíꞌin ndaꞌa̱ na sánáꞌa nda̱yí Ndios. Ta nayóꞌo kachí na yi̱ꞌi̱ xíni̱ ñóꞌó kivi̱ i̱, ");
INSERT INTO mim_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ta nataxi na yi̱ꞌi̱ ndaꞌa̱ na o̱n vása kúu najudío kaꞌni na yi̱ꞌi̱. Ta kusiki ní na yi̱ꞌi̱, kuaku̱ ndaa na yi̱ꞌi̱, kani ní na yi̱ꞌi̱ xíꞌin kuártá, ta sondi̱ꞌi kaꞌni na yi̱ꞌi̱ ndaꞌa̱ tón cruz. Ta ki̱vi̱ u̱ni̱ nataku̱ i̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ta saá ki̱xaa̱ siꞌí ta̱Jacobo xíꞌin ta̱Juan, sa̱ꞌya ta̱Zebedeo kúu ra, ta ki̱xaa̱ ñá xíꞌin o̱vi̱ sa̱ꞌya ñá no̱o̱ ta̱Jesús, ta xi̱kuxítí ñá chi ndukú ñá ñii ñava̱ꞌa no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ñá: ―¿Ndá ñava̱ꞌa kóni ún keꞌé i̱ xíꞌin ún?, nana. Ta nda̱kuii̱n ñá: ―Tata, ki̱vi̱ kixáꞌá ún kaꞌnda chiño ún ñoyívi, taxi ún ná koo ñii sa̱ꞌya i̱ táyi̱ tón kundichi sii̱n kuaꞌá ún ta inka̱ ra koo táyi̱ tón kundichi sii̱n yitin ún. ");
INSERT INTO mim_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin o̱vi̱ sa̱ꞌya ñá: ―O̱n vása kúnda̱a̱ ini ndó yukía̱ ndúkú ndó no̱o̱ i̱ xa̱ꞌa̱ mi̱i ndó. ¿Án ndixa kúndeé ndó xo̱ꞌvi̱ ní ndó nda̱tán xo̱ꞌvi̱ yi̱ꞌi̱? Ta nda̱kuii̱n na o̱vi̱ yóꞌo: ―Kúchiño va ndi̱ ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ndixa xo̱ꞌvi̱ ní ndó ñii ki̱ꞌva nda̱tán xo̱ꞌvi̱ yi̱ꞌi̱. Ta o̱n kúchiño taxi i̱ nda̱yí kundo̱o ndó táyi̱ tón kuita sii̱n kuaꞌá i̱ xíꞌin sii̱n yitin i̱. Saá chi Yivá i̱ Ndios kúu ta̱a ta̱ chi̱tóni̱ yu kúu ni̱vi kundo̱o táyi̱ kán ―káchí ta̱Jesús xíꞌin o̱vi̱ ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ta xi̱ni̱ so̱ꞌo inka̱ u̱xu̱ naxíka xíꞌin ta̱Jesús yukía̱ ndu̱kú o̱vi̱ ta̱a yóꞌo no̱o̱ ra, ta ki̱xáꞌá na ni̱saa̱ ní na xi̱ni na ta̱ o̱vi̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ta ta̱Jesús ka̱na ra va̱xi ndiꞌi na no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Xíni̱ ndó na ndíso chiño no̱o̱ na ñoo inka̱ xiiña, nayóꞌo kísa káꞌno xíꞌin mi̱i na, ta yáꞌa ní ndeé xáꞌnda chiño na no̱o̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ta mi̱i ndó, o̱n váꞌa kutaku̱ ndó saá. Tá ñii ta̱a kóni ra kuu ra ta̱káꞌno no̱o̱ ndóꞌó, xíni̱ ñóꞌó nduu ra ta̱ kasa chiño no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tá ñii ta̱a kóni ra kuu ra ta̱no̱ó no̱o̱ ndóꞌó, xíni̱ ñóꞌó nduu ra ta̱mozo no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ki̱xi i̱ xa̱ꞌa̱ ña chindeé i̱ ni̱vi, ta o̱n si̱ví xa̱ꞌa̱ ña chindeé ni̱vi yi̱ꞌi̱ kúu ña ki̱xi i̱. Ta taxi xíꞌin mi̱i i̱ ña kivi̱ i̱, ta xíꞌin ñayóꞌo chaꞌvi i̱ ña va̱ꞌa sa̱ña̱ kua̱ꞌa̱ ní ni̱vi no̱o̱ ndiꞌi ña o̱n váꞌa ndíso na ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ta saá ke̱e ta̱Jesús xíꞌin naxíka xíꞌin ra ñoo Jericó, kua̱ꞌa̱n na yichi̱, ta kua̱ꞌa̱ ní ni̱vi ndíko̱n kua̱ꞌa̱n sa̱ta̱ na. ");
INSERT INTO mim_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ta ndóo o̱vi̱ ta̱kuáá yuꞌu̱ yichi̱ yóꞌo, ta xi̱ni̱ so̱ꞌo ra yáꞌa ta̱Jesús yichi̱, ta xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Tata, sa̱ꞌya ta̱David, ¡ná kundáꞌví ini ún koni ún ndi̱ꞌi̱! ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ta ni̱vi na kua̱ꞌa̱n yichi̱ ni̱ka̱ꞌa̱n na xíꞌin ra: ―¡Kasi ndó yuꞌu̱ ndó! ―káchí na. Ta ni̱‑chikaa̱ so̱ꞌo o̱vi̱ ta̱kuáá ña ni̱ka̱ꞌa̱n na xíꞌin ra, ta ki̱xáꞌá ra ndeé va̱ꞌa ka̱ káꞌa̱n ra: ―Tata, sa̱ꞌya ta̱David, ¡ná kundáꞌví ini ún koni ún ndi̱ꞌi̱! ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ta xi̱kundichi ta̱Jesús yichi̱ yóꞌo, ta ka̱na ra o̱vi̱ ta̱kuáá kixi ra no̱o̱ ra, ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra ta̱kuáá yóꞌo: ―¿Yukía̱ kóni ndó keꞌé i̱ xíꞌin ndó? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ta nda̱kuii̱n o̱vi̱ ta̱kuáá, káchí ra saá: ―Tata, kóni ndi̱ sandaꞌa ún nduchu̱ no̱o̱ ndi̱, ta va̱ꞌa koto ndi̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ta ku̱ndáꞌví ní ini ta̱Jesús xi̱ni ñaꞌá ra, ta ni̱to̱nda̱a ndaꞌa̱ ra nduchu̱ no̱o̱ ra. Ta xa̱ndi̱ko̱n ndu̱va̱ꞌa nduchu̱ no̱o̱ o̱vi̱ ra saá, ta xa va̱ꞌa xíto ra, ta saá na̱kundiko̱n o̱vi̱ ra saá sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ki̱vi̱ kua̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra yichi̱ ña kua̱ꞌa̱n ñoo Jerusalén, ta ni̱xaa̱ na ñoo Betfagé, ña nákaa̱ no̱o̱ xi̱ki̱ tón Olivo. Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin o̱vi̱ naxíka xíꞌin ra, ");
INSERT INTO mim_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","káchí ra saá: ―Kua̱ꞌa̱n ndó ñoo ña xíto ndaa ndó kaa̱. Tá ni̱xaa̱ ndó ñoo kaa̱, ta naníꞌi ndó ñii burra nóꞌni rí, ta ñii sa̱ꞌya rí xíꞌin rí. Ta ndaxin ndó rí ta kixi ndó xíꞌin rí yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tá yóo ni̱vi na nda̱ka̱ to̱ꞌon ndóꞌó: “¿Nda̱chun ndáxin ndó kiti̱ yóꞌo?”, kachí na xíꞌin ndó, ta ndakuii̱n ndó, kachí ndó saá xíꞌin na: “Ta̱Káꞌno no̱o̱ yó xíni̱ ñóꞌó rí, tá ndi̱ꞌi xíni̱ ñóꞌó ra rí, ta kama ní nataxi ra rí ndaꞌa̱ ndó”, kachí ndó xíꞌin na ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ta ndiꞌi ñayóꞌo ni̱xi̱yo, chi saá xíni̱ ñóꞌó kundivi ña ni̱ka̱ꞌa̱n Ndios xíꞌin ta̱profeta, chi ta̱profeta ni̱taa ra to̱ꞌon ña káchí saá: ");
INSERT INTO mim_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ka̱ꞌa̱n ún xíꞌin nañoo Jerusalén: “Koto ndó, ta̱Rey ñoo ndó va̱xi ra no̱o̱ ndó, ta̱ ndáꞌví ini kúu ra, yóso ra ñii burro, yóso ra ñii burro loꞌo, sa̱ꞌya tí ndíso ñaveé”, káchí to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ta kua̱ꞌa̱n o̱vi̱ naxíka xíꞌin ta̱Jesús, ta ki̱sa ndivi na chiño nda̱tán yóo ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ta saá ndi̱kó na ki̱xaa̱ na no̱o̱ ta̱Jesús xíꞌin burra ta xíꞌin sa̱ꞌya rí. Ta chi̱nóo na tiko̱to̱ na sa̱ta̱ rí, ta saá na̱koso ta̱Jesús ta kua̱ꞌa̱n ra yichi̱. ");
INSERT INTO mim_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ta kua̱ꞌa̱ ní ni̱vi chi̱ndoo na tiko̱to̱ na yichi̱ no̱o̱ yáꞌa ra kua̱ꞌa̱n ra, ta sava ni̱vi xa̱ꞌnda na no̱o̱ ndaꞌa̱ tón yito̱n ta chi̱ndoo na nó yichi̱ ña yaꞌa ra sa̱ta̱ nó, saá kísa to̱ꞌó na ra. ");
INSERT INTO mim_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ta ni̱vi kua̱ꞌa̱n siꞌna no̱o̱ ra xíꞌin na ndíko̱n kua̱ꞌa̱n sa̱ta̱ ra, ndeé ní kúsii̱ ini na, ta káꞌa̱n na, káchí na saá: ―¡Kasa káꞌno yó Ndios xa̱ꞌa̱ sa̱ꞌya ta̱David yóꞌo! ¡Ná keꞌé Ndios ñava̱ꞌa xíꞌin ta̱yóꞌo, ta̱a ta̱ ki̱xaa̱ xíꞌin nda̱yí Ndios! ¡Ná kanóo síkón ñato̱ꞌó Ndios! ―káchí ni̱vi na kua̱ꞌa̱n xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ta ta̱Jesús ni̱ki̱ꞌvi ra ñoo Jerusalén, ta ndiꞌi nañoo yóꞌo ñii ni̱si̱so̱ na, ndáka̱ to̱ꞌon na ta káꞌa̱n na xíꞌin táꞌan na: ―¿Yu kúu ta̱yóꞌo? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ta nda̱kuii̱n ni̱vi na kua̱ꞌa̱n xíꞌin ta̱Jesús: ―Ta̱yóꞌo kúu ta̱Jesús, ta̱profeta ta̱ ke̱e ñoo Nazaret estado Galilea ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ta ni̱ki̱ꞌvi ta̱Jesús ke̱ꞌe yéꞌé veꞌe ño̱ꞌo káꞌno, ta ki̱xáꞌá ra táva ndiꞌi ra na síkó xíꞌin na sáta ña kee na ko̱ꞌo̱n na. Ta sa̱ndiva ra mesa ni̱vi na sáma si̱ꞌún, ta xa̱ta ra táyi̱ na síkó tísa̱ta. ");
INSERT INTO mim_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ta ni̱ka̱ꞌa̱n ra xíꞌin ndiꞌi na: ―Saá káchí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá: “Veꞌe i̱ kunaní ña veꞌe no̱o̱ ko̱ꞌo̱n ni̱vi ña ka̱ꞌa̱n na xíꞌin i̱”, káchí to̱ꞌon Ndios. Ta ndóꞌó, o̱n vása va̱ꞌa kéꞌé ndó, chi sa̱nduu ndó veꞌe yóꞌo ñii kavua̱ nakuíꞌná ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ta saá ni̱vi nakuáá xíꞌin ni̱vi na o̱n ki̱ví kaka ki̱xaa̱ na no̱o̱ ta̱Jesús veꞌe ño̱ꞌo káꞌno yóꞌo, ta sa̱ndaꞌa ra na. ");
INSERT INTO mim_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ta na sánáꞌa nda̱yí Ndios xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ ni̱saa̱ ní na xíni na ta̱Jesús, chi xi̱ni na ndiꞌi milagro ke̱ꞌé ra, ta xi̱ni̱ so̱ꞌo na ni̱ka̱ꞌa̱n naválí na yíta ke̱ꞌe yéꞌé veꞌe ño̱ꞌo káꞌno, xíꞌin ndiꞌi ndee̱ na káchí na saá: ―¡Kasa káꞌno yó Ndios xa̱ꞌa̱ sa̱ꞌya ta̱David yóꞌo! ");
INSERT INTO mim_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ta na sánáꞌa nda̱yí Ndios xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ―¿Án xíni̱ so̱ꞌo ún yukía̱ káꞌa̱n naválí yóꞌo? Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―Oon, xíni̱ so̱ꞌo i̱ ña káꞌa̱n na. Ta ndóꞌó, ¿án o̱n vása ní‑kaꞌvi ndó to̱ꞌon Ndios, no̱o̱ káchí ña saá?: Ndios chi̱tóni̱ ra ka̱ꞌa̱n naválí ñato̱ꞌó xa̱ꞌa̱ ra. Nda̱ yuꞌu̱ naválí xíꞌin yuꞌu̱ naválí páꞌá na chíchín nakiꞌin ra ñato̱ꞌó, káchí to̱ꞌon Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ta sa̱ndakoo ta̱Jesús nanáꞌno yóꞌo ta kua̱ꞌa̱n ra ñoo Betania, no̱o̱ ni̱ki̱si̱n ra ñii ñoó. ");
INSERT INTO mim_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ta xita̱a̱n ní kúu ña, ta ke̱e ta̱Jesús ñoo yóꞌo ndikó ra kua̱ꞌa̱n ra ñoo Jerusalén, ta xíꞌi̱ ní ra so̱ko. ");
INSERT INTO mim_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ta xi̱ni ra ñii tón higo yatin yuꞌu̱ yichi̱, ta ni̱xaa̱ yatin ra no̱o̱ ñíndichi nó, ta ni̱‑naníꞌi ra nda̱ ñii kui̱ꞌi ndaꞌa̱ nó. Nina yu̱ku̱ kuiti yóo ndaꞌa̱ nó. Ta saá ni̱ka̱ꞌa̱n ra xíꞌin tón higo yóꞌo, káchí ra saá: ―O̱n koon ka̱ kui̱ꞌi ndaꞌa̱ ún nda̱ ñii ki̱vi̱ ña va̱xi ―káchí ra. Ta xa̱ndi̱ko̱n ni̱yi̱chi̱ tón higo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ta xi̱ni naxíka xíꞌin ra yukía̱ ni̱ndoꞌo tón higo yóꞌo, ta na̱kaꞌnda ní ini na, ta ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ―¿Nda̱chun kama ní ni̱yi̱chi̱ tón higo yóꞌo? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ta nda̱kuii̱n ta̱Jesús: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, tá kándixa ndinoꞌo ini ndó Ndios, ta o̱n vása xíka o̱vi̱ ini ndó, ta saá kuchiño kasa ndivi ndó nda̱tán yóo ña ke̱ꞌé i̱ xíꞌin tón higo yóꞌo. Tá ka̱ꞌa̱n ndó, kachí ndó saá xíꞌin ñii xi̱ki̱ káꞌno: “Kutaꞌa ún ta ko̱ꞌo̱n ún sakana xíꞌin mi̱i ún no̱o̱ mi̱ni”, ta saá koo ña. ");
INSERT INTO mim_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tá kándixa ndinoꞌo ini ndó Ndios, ta nakiꞌin ndó ndiꞌi ña ndukú ndó no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ta ki̱xaa̱ ta̱Jesús ke̱ꞌe yéꞌé veꞌe ño̱ꞌo káꞌno ta sánáꞌa ra ni̱vi, ta naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ ki̱xaa̱ na no̱o̱ ra, ta ni̱nda̱ka̱ to̱ꞌon na ra: ―¿Míkía̱ ki̱xi nda̱yí kéꞌé ún ñayóꞌo? ¿Yu kúu na ta̱xi nda̱yí ndaꞌa̱ ún keꞌé ún chiño yóꞌo saá? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Ta nda̱kuii̱n ta̱Jesús: ―Ta yi̱ꞌi̱ kóni i̱ nda̱ka̱ to̱ꞌon i̱ ndóꞌó ñii la̱á to̱ꞌon. ¿Míkía̱ ki̱xi nda̱yí ta̱Juan sa̱kuchu ra ni̱vi? ¿Án ta̱xi Ndios nda̱yí ndaꞌa̱ ra? ¿Án ni̱vi kúu na ta̱xi nda̱yí ndaꞌa̱ ra ña sakuchu ra ni̱vi? Tá ndakuii̱n ndó ña ndáka̱ to̱ꞌon i̱ ndóꞌó, ta saá ka̱ꞌa̱n i̱ xíꞌin ndó míkía̱ ki̱xi nda̱yí kéꞌé i̱ chiño yóꞌo ―káchí ta̱Jesús xíꞌin na. Ta saá ki̱xáꞌá na káꞌa̱n táꞌan xíꞌin mi̱i na: ―¿Ndasaá koo ndakuii̱n yó vitin? Chi táná ka̱ꞌa̱n yó Ndios ta̱xi nda̱yí ndaꞌa̱ ta̱Juan, ta saá nda̱ka̱ to̱ꞌon ta̱Jesús mi̱i yó: “¿Nda̱chun o̱n vása ní‑kandixa ndó ña ni̱ka̱ꞌa̱n ra?” ");
INSERT INTO mim_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Táná ka̱ꞌa̱n yó ni̱vi kuiti kúu na ta̱xi nda̱yí ndaꞌa̱ ta̱Juan, ta saá yi̱yo ní sasaa̱ yó nañoo, chi nayóꞌo kándixa na ndí ta̱Juan xi̱kuu ra ñii ta̱profeta ―káchí na, káꞌa̱n táꞌan na. ");
INSERT INTO mim_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ta saá nda̱kuii̱n na, káchí na siꞌa xíꞌin ta̱Jesús: ―O̱n xíni̱ ndi̱ yu kúu na ta̱xi nda̱yí ndaꞌa̱ ta̱Juan ―káchí na. Ta saá ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta ni yi̱ꞌi̱, o̱n ka̱ꞌa̱n i̱ xíꞌin ndó míkía̱ ki̱xi nda̱yí kómí i̱ ña kéꞌé i̱ chiño yóꞌo ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra na: ―¿Yukía̱ kani si̱ni̱ ndó xa̱ꞌa̱ ña kóni i̱ ndato̱ꞌon i̱ xíꞌin ndó vitin? Saá ndo̱ꞌo ñii ta̱a, kómí ra o̱vi̱ sa̱ꞌya ra. Ta ni̱ka̱ꞌa̱n ra xíꞌin sa̱ꞌya ra ta̱no̱ó, káchí ra saá: “Sa̱ꞌya i̱, ko̱ꞌo̱n ún vitin kasa chiño ún no̱o̱ ñoꞌo̱ i̱ no̱o̱ na̱taan i̱ tón uva.” ");
INSERT INTO mim_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ta nda̱kuii̱n sa̱ꞌya ra: “O̱n ko̱ꞌo̱n i̱”, káchí ra, ta saá ni̱yaꞌa ñii káni̱ loꞌo ta na̱ndikó ini ra, ta ni̱xa̱ꞌa̱n ra ki̱sa chiño ra. ");
INSERT INTO mim_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ta saá ta̱a ta̱ kómí o̱vi̱ sa̱ꞌya yóꞌo ni̱ka̱ꞌa̱n ra xíꞌin inka̱ sa̱ꞌya ra, ñii ki̱ꞌva ni̱ka̱ꞌa̱n ra xíꞌin ta̱no̱ó. Ta nda̱kuii̱n sa̱ꞌya ra ta̱o̱vi̱ yóꞌo, káchí ra saá: “Va̱ꞌa, tata, ko̱ꞌo̱n i̱”, káchí ra, ta ta̱yóꞌo o̱n vása ní‑xaꞌa̱n ra kasa ndivi ra chiño. ");
INSERT INTO mim_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ta vitin, ¿yukía̱ xáni ini ndó? ¿Ndá sa̱ꞌya ta̱yóꞌo kúu ta̱ ki̱sa ndivi ña xa̱ꞌnda chiño yivá ra? ―káchí ta̱Jesús. Ta nda̱kuii̱n na: ―Ta̱no̱ó kúu ta̱ ki̱sa ndivi chiño ña kóni yivá ra ―káchí na. Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, ni̱vi na káya si̱ꞌún xa̱ꞌa̱ nagobierno, xíꞌin náñaꞌa̱ ná kísi̱n xíꞌin kua̱ꞌa̱ ní ta̱a, kúu na siꞌna ka̱ kúchiño ki̱ꞌvi no̱o̱ ndó yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chi ta̱Juan ki̱xi ra no̱o̱ ndó ña sanáꞌa ra ndóꞌó ndasaá va̱ꞌa kutaku̱ ndó no̱o̱ Ndios, ta ni̱‑xiin ndó kandixa ndó ra. Ta na káya si̱ꞌún xa̱ꞌa̱ nagobierno xíꞌin náñaꞌa̱ ná kísi̱n xíꞌin kua̱ꞌa̱ ní ta̱a, na̱ndikó ini na ta ka̱ndixa na ña ni̱ka̱ꞌa̱n ra. Ta ndóꞌó xi̱ni ndó ndiꞌi ñayóꞌo, ta ni̱‑xiin ndó nandikó ini ndó, ta o̱n vása ní‑kandixa ndó ra ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ta ni̱ka̱ꞌa̱n ta̱Jesús: ―Koni̱ so̱ꞌo ndó inka̱ cuento ña sanáꞌa i̱ ndóꞌó. Saá ndo̱ꞌo ñii ta̱a, na̱taan ra tón uva. Ta ki̱sa va̱ꞌa ra ñii na̱ma̱ xi̱no nduu ña ndiꞌi no̱o̱ ñoꞌo̱ no̱o̱ na̱taan ra tón uva. Ta xa̱ta ra no̱o̱ ñoꞌo̱ ña ki̱sa va̱ꞌa ra ñii no̱o̱ koꞌon nduta̱ tíuva, ta ki̱sa va̱ꞌa ra ñii torre no̱o̱ kundo̱o ni̱vi kundaa na tón uva yóꞌo. ’Ta saá sa̱tati ra ñoꞌo̱ ra xíꞌin tón uva ra inka̱ ni̱vi, ta ke̱e ra kua̱ꞌa̱n ra inka̱ ñoo xíká ní. ");
INSERT INTO mim_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ta ki̱xaa̱ yatin ki̱vi̱ ña kaꞌnda na tíuva yóꞌo, ta ta̱a ta̱ xíꞌin yito̱n tón uva ti̱ꞌví ra namozo ra kua̱ꞌa̱n na nakiꞌin na sava tíuva ña kuu yaꞌvi ra. ");
INSERT INTO mim_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ta ni̱vi na táti ñoꞌo̱ no̱o̱ yóo tón uva ti̱in na namozo yóꞌo, ta ka̱ni ní na ñii ta̱yóꞌo, ta xa̱ꞌni na ñii ta̱táꞌan ta̱yóꞌo, ta ko̱on na yu̱u̱ inka̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ta ta̱a ta̱ xíꞌin yito̱n tón uva ti̱ꞌví ra kua̱ꞌa̱ ka̱ namozo kua̱ꞌa̱n na nakiꞌin na tíuva, ta ñii ki̱ꞌva ni̱ndoꞌo nano̱ó, saá ndóꞌo nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ta saá ta̱a ta̱ xíꞌin yito̱n tón uva ti̱ꞌví ra sa̱ꞌya mi̱i ra kua̱ꞌa̱n ra no̱o̱ na táti ñoꞌo̱, chi xa̱ni ini ra: “Ndixa kasa to̱ꞌó na sa̱ꞌya mi̱i yó.” ");
INSERT INTO mim_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ta na táti ñoꞌo̱ xi̱ni na kíxaa̱ ta̱loꞌo sa̱ꞌya ra, ta ni̱ka̱ꞌa̱n na xíꞌin táꞌan na, káchí na saá: “Ta̱kaa̱ kúu sa̱ꞌya ta̱ na̱taan tón uva, ta sa̱ꞌya ra yóꞌo kúu ta̱ nakiꞌin ñakuíká xíꞌin ñoꞌo̱ yóꞌo táná kivi̱ yivá ra. Naꞌa ndó ná koꞌyo̱ kaꞌni yó ra, ta kindo̱o yó xíꞌin ndiꞌi ñakuíká ra”, káchí na. ");
INSERT INTO mim_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ta saá ti̱in na ra, ta sa̱kana na ra nda̱ sa̱ta̱ na̱ma̱ ña xi̱no nduu no̱o̱ yóo tón uva, ta xa̱ꞌni na ra. Saá ndi̱ꞌi cuento yóꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra ni̱vi na xi̱ni̱ so̱ꞌo cuento yóꞌo: ―¿Yukía̱ xáni ini ndó? Ki̱vi̱ ndikó ta̱a ta̱ xíꞌin yito̱n tón uva, ¿yukía̱ kundoꞌo ni̱vi na táti ñoꞌo̱ no̱o̱ yóo tón uva, kasa ta̱ xíꞌin ñoꞌo̱? ");
INSERT INTO mim_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ta nda̱kuii̱n na, káchí na saá: ―O̱n kundáꞌví ini ra koni ra ni̱vi na o̱n váꞌa na táti ñoꞌo̱ no̱o̱ yóo tón uva, ta sandiꞌi ra xa̱ꞌa̱ na. Ta satati tuku ra ñoꞌo̱ ra inka̱ ni̱vi, ta nataxi na tíuva ndaꞌa̱ ra ña kuu yaꞌvi ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―¿Án o̱n vása ní‑kaꞌvi ndó to̱ꞌon Ndios, ña káchí saá?: Yóo yu̱u̱ ña ni̱‑xiin ni̱vi na kísa va̱ꞌa veꞌe koni̱ ñóꞌó na, ta mi̱i yu̱u̱ yóꞌo ndu̱u ña yu̱u̱ ñano̱ó nákaa̱ xa̱ꞌa̱ veꞌe. Ndios kúu ta̱ ki̱sa ndivi saá, ña̱ꞌa livi ní kúu ña ke̱ꞌé Ndios, ta mi̱i yó nákaꞌnda ini yó xíni yó ñayóꞌo, káchí ni̱vi, káchí to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ta saá káꞌa̱n i̱ xíꞌin ndó, Ndios tava ra ndóꞌó no̱o̱ xáꞌnda chiño ra, ta taxi ra kundo̱o inka̱ ni̱vi no̱o̱ xáꞌnda chiño ra, ta ni̱vi yóꞌo kúu na kasa ndivi ña kóni Ndios. ");
INSERT INTO mim_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ndiꞌi ni̱vi na kakiꞌi ta nakava na sa̱ta̱ yu̱u̱ ña nduu ñano̱ó yóꞌo, ni̱vi yóꞌo ndiꞌi xa̱ꞌa̱ na; ta yu̱u̱ yóꞌo, tá nakava ña sa̱ta̱ ni̱vi, ta chiꞌma ña na, nda̱ nduu na yaa̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ta xi̱ni̱ so̱ꞌo nafariseo xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ cuento ña nda̱to̱ꞌon ta̱Jesús, ta ku̱nda̱a̱ ini na cuento yóꞌo káꞌa̱n ña xa̱ꞌa̱ mi̱i na. ");
INSERT INTO mim_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ta saá xa̱ni si̱ni̱ na ndúkú na ndasaá koo tiin na ra, ta o̱n vása ní‑kuchiño na, chi yíꞌví na ko̱to̱ saa̱ nañoo, chi ndiꞌi nañoo kándixa na ta̱Jesús kúu ra ñii ta̱profeta. ");
INSERT INTO mim_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ta tuku nda̱to̱ꞌon ta̱Jesús ñii cuento ña sanáꞌa ra nafariseo xíꞌin nanáꞌno no̱o̱ nasu̱tu̱, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Nda̱tán yóo ñii ta̱rey xa̱ki̱n ra ñii viko̱ káꞌno ña tonda̱ꞌa̱ sa̱ꞌya ra, saá yóo yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ta mi̱i ki̱vi̱ viko̱ ti̱ꞌví ra namozo ra kua̱ꞌa̱n na nakana na ni̱vi na xa nda̱to̱ꞌon ra xíꞌin koo viko̱ yóꞌo, ta ni̱‑xiin na kixi na. ");
INSERT INTO mim_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ta saá tuku ti̱ꞌví ra inka̱ namozo ra, káchí ra saá: “Ko̱ꞌo̱n ndó ka̱ꞌa̱n ndó siꞌa xíꞌin ni̱vi na ka̱na i̱: Xa yóo ndivi ndiꞌi ña kuxu ndó. Xa ni̱xiꞌi̱ si̱ndi̱ki̱ xíꞌin inka̱ kiti̱ tí nduꞌu̱ sa̱na̱ ta̱rey kuxu ndó; xa yóo tiꞌva ndiꞌi ña̱ꞌa. Kama ndó kixi ndó viko̱ tonda̱ꞌa̱, kachí ndó xíꞌin na”, káchí ta̱rey xíꞌin namozo. ");
INSERT INTO mim_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ta ni̱vi na ka̱na ra yóꞌo ni̱‑xiin na ko̱ꞌo̱n na viko̱, ta sava na ke̱e kua̱ꞌa̱n no̱o̱ chi̱ꞌi na, ta inka̱ na kua̱ꞌa̱n no̱o̱ kísa chiño na. ");
INSERT INTO mim_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ta inka̱ na ti̱in na namozo ta̱rey, ta sa̱xo̱ꞌvi̱ ñaꞌá na, ta xa̱ꞌni ñaꞌá na. ");
INSERT INTO mim_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ta xi̱ni̱ so̱ꞌo ta̱rey ña ni̱ndoꞌo namozo ra, ta saá ndeé ní ni̱saa̱ ra. Ta ti̱ꞌví ra natropa ña sandiꞌi na xa̱ꞌa̱ ndiꞌi ni̱vi na xa̱ꞌni namozo ra ta chikaa̱ na ñoꞌo̱ ña ko̱ko̱ ndiꞌi ñoo nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin inka̱ namozo ra: “Xa yóo ndivi ndiꞌi viko̱ tonda̱ꞌa̱, ta ni̱vi na siꞌna ka̱na i̱ kixi viko̱, o̱n vása kómí ka̱ na nda̱yí kixi na. ");
INSERT INTO mim_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ta vitin ko̱ꞌo̱n ndó ndiꞌi yichi̱ no̱o̱ nákutáꞌan ni̱vi ta nakaya ndó na ná kixi na viko̱.” ");
INSERT INTO mim_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ta saá ke̱e namozo kua̱ꞌa̱n na yichi̱, ta na̱kaya na ndiꞌi ni̱vi na na̱níꞌi na yichi̱, nava̱ꞌa án na o̱n váꞌa kúu na, ta saá chútú nda̱a̱ veꞌe no̱o̱ yóo viko̱ tonda̱ꞌa̱. ");
INSERT INTO mim_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Ta ki̱xaa̱ ta̱rey viko̱ ta chi̱ndeé ra na na̱kutáꞌan yóꞌo, ta na̱koto ra ñii ta̱a o̱n vása ndíxin ra tiko̱to̱ yaa ña ndíxin na ñóꞌo viko̱ tonda̱ꞌa̱. ");
INSERT INTO mim_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ta ni̱nda̱ka̱ to̱ꞌon ra ta̱yóꞌo: “Tata, ¿nda̱chun ni̱ki̱ꞌvi ún yóꞌo, ta o̱n ko̱ó tiko̱to̱ yaa ndíxin ún?” Ta ta̱yóꞌo o̱n vása ní‑kunda̱a̱ ini ra ndasaá koo ndakuii̱n ra. ");
INSERT INTO mim_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ta ta̱rey ni̱ka̱ꞌa̱n ra xíꞌin namozo ra: “Katón ndó ndaꞌa̱ xíꞌin xa̱ꞌa̱ ta̱yóꞌo ta tava ndó ra ke̱ꞌe, ta chikaa̱ ndó ra no̱o̱ naa ní, no̱o̱ ndeé ní kuaku ra, no̱o̱ ndeé ní xo̱ꞌvi̱ ra”, káchí ta̱rey. ");
INSERT INTO mim_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Saá chi Ndios nákana ra kua̱ꞌa̱ ní ni̱vi, ta loꞌo kuiti kúu na na̱ka̱xin ra ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ta saá nafariseo ke̱e na kua̱ꞌa̱n na, ta na̱koo yuꞌú na ndasaá koo ndukú na ña ka̱ꞌa̱n ta̱Jesús to̱ꞌon o̱n váꞌa ña kuchiño na chikaa̱ na ra kua̱chi. ");
INSERT INTO mim_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ta ti̱ꞌví na na ndíko̱n sa̱ta̱ na xíꞌin na ndíko̱n partido ta̱Herodes, ta ki̱xaa̱ na no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n na saá xíꞌin ra: ―Tata maestro, xíni̱ ndi̱ yóꞌó kúu ún ta̱a ta̱ káꞌa̱n ñanda̱a̱, ta sánáꞌa ún ñanda̱a̱ xa̱ꞌa̱ yichi̱ Ndios. Ta o̱n vása ndíꞌi ini ún ña káꞌa̱n ni̱vi xa̱ꞌa̱ ña sánáꞌa ún, ta o̱n vása náka̱xin ún ni̱vi, ta ñii ki̱ꞌva káꞌa̱n ún xíꞌin ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ta saá ka̱ꞌa̱n ún yukía̱ xáni ini ún. ¿Án va̱ꞌa chaꞌvi yó kota no̱o̱ ta̱rey César ñoo Roma? ¿Án o̱n váꞌa chaꞌvi yó ña? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ta ta̱Jesús kúnda̱a̱ ini ra ndí kóni na koto ndoso na ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¡Na o̱vi̱ yuꞌu̱ kúu ndóꞌó! ¿Nda̱chun kóni ndó koto ndoso ndó yi̱ꞌi̱? ");
INSERT INTO mim_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Taxi ndó si̱ꞌún ña cháꞌvi ndó kota ná koto i̱ no̱o̱ ña. Ta sa̱náꞌa na ñii si̱ꞌún na̱ní denario. ");
INSERT INTO mim_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ta saá ni̱nda̱ka̱ to̱ꞌon ra na: ―¿Yo na̱ꞌná, ta yo ki̱vi̱ kúu ña yóo no̱o̱ si̱ꞌún yóꞌo? ");
INSERT INTO mim_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ta nda̱kuii̱n na: ―Si̱ꞌún yóꞌo kómí ña na̱ꞌná xíꞌin ki̱vi̱ ta̱rey César. Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Taxi ndó ndaꞌa̱ ta̱rey César ña kúu kuenda ra, ta taxi ndó ndaꞌa̱ Ndios ña kúu kuenda Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ta xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ra xíꞌin na, ta na̱kaꞌnda ní ini na. Ta saá sa̱ndakoo na ra, ta ke̱e na kua̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta mi̱i ki̱vi̱ yóꞌo, nasaduceo ki̱xaa̱ na no̱o̱ ta̱Jesús. Nasaduceo yóꞌo kúu nanáꞌno na sánáꞌa ta káꞌa̱n na ndí na ni̱xiꞌi̱ o̱n vása nataku̱ ka̱ na. Ta ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ");
INSERT INTO mim_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Tata maestro, nda̱yí Ndios ña ni̱taa ta̱Moisés, káchí ña saá: “Tá ñii ta̱a ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya ra ní‑xiyo xíꞌin ñásíꞌí ra, ta ñani ra xíni̱ ñóꞌó tonda̱ꞌa̱ ra xíꞌin ñá ni̱ndo̱o yóꞌo, ña kivi koo sa̱ꞌya na. Nda̱tán koo sa̱ꞌya ta̱ ni̱xiꞌi̱, saá koo sa̱ꞌya nayóꞌo”, káchí nda̱yí ña ni̱taa ta̱Moisés. ");
INSERT INTO mim_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ta, ¿yukía̱ káchí yóꞌó xa̱ꞌa̱ ñayóꞌo? Chi saá ndo̱ꞌo natáꞌan ndi̱, u̱xa̱ ñani kúu ra. Ta̱no̱ó to̱nda̱ꞌa̱ ra xíꞌin ñii ñaꞌa̱, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na ní‑xiyo. Ta ñani ra ta̱o̱vi̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ñii ki̱ꞌva ndo̱ꞌo ta̱no̱ó, saá ndo̱ꞌo inka̱ ñani ra. Ta̱o̱vi̱ ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na ní‑xiyo. Ta ñani ra ta̱u̱ni̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. Ta ñani ra ta̱ko̱mi̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. Ta ñani ra ta̱o̱ꞌo̱n to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. Ta ñani ra ta̱i̱ño̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. Ta ñani ra ta̱u̱xa̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. ");
INSERT INTO mim_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ta saá ni̱xiꞌi̱ mi̱i ñáñaꞌa̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ta ki̱vi̱ nataku̱ ndiꞌi na ni̱xiꞌi̱, ¿yukú ta̱a kuu yii̱ ñáñaꞌa̱ yóꞌo?, chi ndiꞌi ta̱a u̱xa̱ ñani ni̱xi̱yo ra xíꞌin ñá ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin na: ―Sándáꞌví xíꞌin mi̱i ndó, chi naa ní ini ndó, o̱n vása kúnda̱a̱ ini ndó ña káꞌa̱n to̱ꞌon Ndios, ni o̱n vása kúnda̱a̱ ini ndó ña kúu ndee̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Saá chi ki̱vi̱ nataku̱ ni̱vi na ni̱xiꞌi̱, o̱n vása tonda̱ꞌa̱ ka̱ na ñoyívi ni̱no, ni o̱n vása taxi na sa̱ꞌya na tonda̱ꞌa̱ na xíꞌin inka̱ ni̱vi. Nda̱tán yóo naángel ñoyívi ni̱no, saá koo ni̱vi na kundo̱o xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Xa̱ꞌa̱ ña nataku̱ na ni̱xiꞌi̱, ¿án o̱n vása ní‑kaꞌvi ndó yukía̱ ni̱ka̱ꞌa̱n Ndios xíꞌin ta̱Moisés xi̱na̱ꞌá? Ka̱chí ra saá: ");
INSERT INTO mim_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yi̱ꞌi̱ kúu Ndios, ta ta̱Abraham, ta̱Isaac, xíꞌin ta̱Jacob kísa to̱ꞌó ra yi̱ꞌi̱ vitin”, ka̱chí Ndios. Ta xíꞌin to̱ꞌon yóꞌo kúnda̱a̱ ini yó ndí táku̱ ka̱ xi̱i̱ síkuá yó yóꞌo, chi na ndixa ni̱xiꞌi̱ o̱n kuchiño na kasa to̱ꞌó na Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ta xi̱ni̱ so̱ꞌo ni̱vi ña ni̱ka̱ꞌa̱n ra xíꞌin nasaduceo, ta na̱kaꞌnda ní ini na. ");
INSERT INTO mim_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ta nafariseo xi̱ni̱ so̱ꞌo na ndí ta̱Jesús sa̱ya̱a̱ ra yuꞌu̱ nasaduceo ta o̱n vása ní‑naníꞌi ka̱ na ña ka̱ꞌa̱n na xíꞌin ra, ta saá nafariseo na̱kutáꞌan xíꞌin táꞌan mi̱i nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ñii ta̱fariseo yóꞌo kúu ñii ta̱a ta̱ xíni̱ va̱ꞌa nda̱yí ña ni̱taa ta̱Moisés, ta ni̱nda̱ka̱ to̱ꞌon ra ña koto ndoso ra ta̱Jesús, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Tata maestro, ¿ndá nda̱yí Ndios kúu ña xíni̱ ñóꞌó ní ka̱ no̱o̱ ndiꞌi inka̱ nda̱yí? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ta nda̱kuii̱n ta̱Jesús: ―Nda̱yí ña xíni̱ ñóꞌó ní ka̱ kúu ñayóꞌo: “Kukiꞌvi ini yó koni yó Yivá yó Ndios xíꞌin ndiꞌi níma̱ yó, xíꞌin ndiꞌi ini yó, xíꞌin ndiꞌi si̱ni̱ yó.” ");
INSERT INTO mim_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ñayóꞌo kúu nda̱yí ñano̱ó, ña xíni̱ ñóꞌó ní ka̱. ");
INSERT INTO mim_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nda̱tán sánáꞌa nda̱yí ñano̱ó, saá sánáꞌa nda̱yí ñao̱vi̱, káchí ña saá: “Ñii ki̱ꞌva nda̱tán kíꞌvi ini yó xíni yó xíꞌin mi̱i yó, saá kukiꞌvi ini yó koni yó natáꞌan yó.” ");
INSERT INTO mim_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","O̱vi̱ nda̱yí yóꞌo kúu ña náꞌno va̱ꞌa, ta kúu ña no̱o̱ ka̱ku ndiꞌi inka̱ nda̱yí ña ni̱taa ta̱Moisés, ta no̱o̱ ñayóꞌo ke̱e ndiꞌi to̱ꞌon ña sa̱náꞌa naprofeta xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ta ndóo ka̱ nafariseo, ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra na, ");
INSERT INTO mim_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","káchí ra saá xíꞌin na: ―¿Yukía̱ xáni ini ndó xa̱ꞌa̱ Cristo? ¿Yu kúu naveꞌe ta̱yóꞌo? Ta nda̱kuii̱n na: ―Ñii sa̱ꞌya ñani síkuá ta̱rey David kuu ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ta saá ni̱ka̱ꞌa̱n ra siꞌa xíꞌin na: ―Tá ndixa Cristo kuu ra sa̱ꞌya ñani síkuá ta̱rey David, ¿ta nda̱chun ni̱ka̱ꞌa̱n ta̱rey David xa̱ꞌa̱ Cristo, ka̱chí ra: “Ta̱Káꞌno no̱o̱ i̱ kúu ra”? Chi Níma̱ Ndios ni̱ka̱ꞌa̱n ini ta̱David, ta ni̱taa ra to̱ꞌon yóꞌo, ña káchí saá: ");
INSERT INTO mim_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ndios ni̱ka̱ꞌa̱n ra xíꞌin ta̱Káꞌno no̱o̱ i̱: “Koo ún xíꞌin i̱ sii̱n kuaꞌá i̱ no̱o̱ táyi̱ tón to̱ꞌó yóꞌo, ta̱nda̱ ki̱vi̱ taxi i̱ ko̱yo ndiꞌi na káni táꞌan xíꞌin ún ti̱xin xa̱ꞌa̱ ún”, ka̱chí Ndios, ni̱taa ta̱David xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Xíꞌin to̱ꞌon yóꞌo ta̱David ka̱chí ra Cristo kúu ta̱Káꞌno no̱o̱ ra. Ta, ¿mí kúchiño kúu Cristo sa̱ꞌya ñani síkuá ta̱David? ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ta nda̱ ñii nayóꞌo ni̱‑kuchiño ndakuii̱n na nda̱ ñii to̱ꞌon ña ni̱ka̱ꞌa̱n ra xíꞌin na, ta̱nda̱ ki̱vi̱ yóꞌo ni̱‑xiin ka̱ na nda̱ka̱ to̱ꞌon na ra ña koto ndoso na ra. ");
INSERT INTO mim_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ta saá ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi, ta xíꞌin naxíka xíꞌin ra, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Nafariseo xíꞌin na sánáꞌa nda̱yí Ndios kómí na yichi̱ nandaxin na nda̱yí ña ni̱taa ta̱Moisés. ");
INSERT INTO mim_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ta saá xíni̱ ñóꞌó kasa ndivi ndó ndiꞌi ña káꞌa̱n na xíꞌin ndó. Ta o̱n kutaku̱ ndó nda̱tán táku̱ nayóꞌo, chi ña sánáꞌa na ndóꞌó o̱n vása kísa ndivi mi̱i na. ");
INSERT INTO mim_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Chi nafariseo xíꞌin na sánáꞌa nda̱yí Ndios kéꞌé na nda̱tán kéꞌé ni̱vi na kátón chiño veé ní ta yo̱ꞌvi̱ ní kuiso ni̱vi, ta sákuiso na ña sa̱ta̱ inka̱ ni̱vi, ta mi̱i na nda̱ loꞌo o̱n xi̱in na tindaa na chiño veé ta yo̱ꞌvi̱ ní yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ndiꞌi ña kéꞌé na kúu xa̱ꞌa̱ ña kóni mi̱i na ña koto inka̱ ni̱vi ta ka̱ꞌa̱n na ndí va̱ꞌa ní ni̱vi kúu nafariseo xíꞌin na sánáꞌa nda̱yí. Ta nayóꞌo kátón ndaa na ta̱ꞌya̱ na ñii caja loꞌo no̱o̱ ñóꞌo tutu kómí to̱ꞌon Ndios, ta inka̱ caja loꞌo kátón ndaa na nó no̱o̱ chi̱yo̱ ndaꞌa̱ na, ta tón o̱vi̱ caja válí kátón nayóꞌo kúu tón náꞌno ka̱ no̱o̱ caja inka̱ ni̱vi. Ta ndíxin na tiko̱to̱ ña tákaa̱ yiꞌva̱ náni̱ ní ka̱ no̱o̱ ñayiꞌva̱ yuꞌu̱ tiko̱to̱ inka̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ta no̱o̱ yóo viko̱ xíxi, ndúkú na kundo̱o na no̱o̱ táyi̱ náꞌno tón to̱ꞌó. Ta kútoo ní na kundo̱o na táyi̱ tón náꞌno tón to̱ꞌó yóo veꞌe ño̱ꞌo sinagoga. ");
INSERT INTO mim_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ta xíka na no̱yáꞌvi, ta kóni na ña kasa to̱ꞌó ní ni̱vi na, kóni na ña ka̱ꞌa̱n ni̱vi xíꞌin na, kachí na saá: “Rabí, Rabí.” ");
INSERT INTO mim_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Ta ndóꞌó, o̱n vása va̱ꞌa keꞌé ndó ña ndáti ndó ñii ki̱ꞌva saá ka̱ꞌa̱n ni̱vi xíꞌin ndó, kachí na: “Rabí”, chi ñii la̱á kúu ta̱a ta̱Maestro no̱o̱ ndó, ta ndiꞌi ndóꞌó kúu ndó ñani ndó xíꞌin táꞌan ndó. ");
INSERT INTO mim_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ta o̱n ka̱ꞌa̱n ndó “Yivá i̱” kachí ndó xíꞌin nda̱ ñii ta̱a, saá chi ñii la̱á kúu Yivá yó Ndios, ta̱ yóo ñoyívi ni̱no. ");
INSERT INTO mim_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ta o̱n taxi ndó ka̱ꞌa̱n na xíꞌin ndó “Ta̱káꞌno” kachí na, chi ñii la̱á kúu Ta̱a ta̱Káꞌno no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ta ta̱ káꞌno ní ka̱ no̱o̱ ndóꞌó kuu ta̱ kasa chiño no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chi ndiꞌi na kísa káꞌno xíꞌin mi̱i nduu na nani̱no̱ ní, ta ndiꞌi na kísa ni̱no̱ xíꞌin mi̱i nduu na nanáꞌno ní, kasa Ndios xíꞌin na ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ta ni̱ka̱ꞌa̱n tuku ta̱Jesús xíꞌin nafariseo ta xíꞌin na sánáꞌa nda̱yí Ndios, káchí ra saá: ―¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, nafariseo xíꞌin na sánáꞌa nda̱yí Ndios! ¡Na o̱vi̱ yuꞌu̱ kúu ndó! Chi nákasi ndó yichi̱ ña o̱n yaꞌa nani̱vi ña ki̱ꞌvi na yichi̱ no̱o̱ xáꞌnda chiño Ndios. Ta ni mi̱i ndó, o̱n xi̱in ndó ki̱ꞌvi ndó yichi̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, nafariseo xíꞌin na sánáꞌa nda̱yí Ndios! ¡Na o̱vi̱ yuꞌu̱ kúu ndó! O̱n váꞌa kéꞌé ndó chi kíndaa ndó veꞌe náñaꞌa̱ ná ni̱xiꞌi̱ yii̱. Tá ndi̱ꞌi ke̱ꞌé ndó saá, ta xíꞌin ñavatá ini ndó, xáꞌa̱n ndó veꞌe ño̱ꞌo sinagoga, ta naꞌá ní káꞌa̱n ndó xíꞌin Ndios. Kéꞌé ndó saá xa̱ꞌa̱ ña kóni ndó kani si̱ni̱ ni̱vi ndí ndóꞌó kúu nava̱ꞌa ní no̱o̱ Ndios. Ta xa̱ꞌa̱ ña o̱n váꞌa kéꞌé ndó, Ndios saxo̱ꞌvi̱ ka̱ ra ndóꞌó no̱o̱ inka̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, nafariseo xíꞌin na sánáꞌa nda̱yí Ndios! ¡Na o̱vi̱ yuꞌu̱ kúu ndó! Saá chi kua̱ꞌa̱n ndó ndiꞌi saá xiiña nda̱ no̱o̱ mi̱ni, ta ndúkú ndó ni̱vi na kundiko̱n yichi̱ ndó. Ta ni̱vi na ndíko̱n yichi̱ ndó, ndása ndó nayóꞌo ni̱vi na ndiva̱ꞌa ní ka̱ ini no̱o̱ ndó, ta ndixa ko̱ꞌo̱n nayóꞌo nda̱ya xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, chi sánáꞌa ndó ni̱vi ko̱ꞌo̱n na yichi̱ ña káchí mi̱i ndó, ta ndixa mi̱i ndó nakuáá kúu ndó, o̱n vása xíni ndó yichi̱! Saá chi káꞌa̱n ndó, káchí ndó saá: “Tá ñii ni̱vi káꞌa̱n na chínáꞌa na xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno, ta o̱n vása xíni̱ ñóꞌó kasa ndivi na to̱ꞌon na. Tá káꞌa̱n na chínáꞌa na xa̱ꞌa̱ ñaoro ña yóo veꞌe ño̱ꞌo káꞌno, ta saá ndixa xíni̱ ñóꞌó kasa ndivi na ña káꞌa̱n na”, káchí ndó. ");
INSERT INTO mim_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Nakíꞌví kúu ndó ta nakuáá kúu ndó! ¿Yukía̱ kúu ñakáꞌno xíni̱ ñóꞌó ní ka̱? ¿Án ñaoro, án mi̱i veꞌe ño̱ꞌo káꞌno?, saá chi veꞌe ño̱ꞌo káꞌno kúu ña ndása yi̱i̱ ndiꞌi ñaoro ñóꞌo ini ña. ");
INSERT INTO mim_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ta tuku káꞌa̱n ndó: “Tá ñii ni̱vi káꞌa̱n na chínáꞌa na xa̱ꞌa̱ na̱ma̱ yi̱i̱ veꞌe ño̱ꞌo káꞌno, ta o̱n vása xíni̱ ñóꞌó kasa ndivi na to̱ꞌon na. Tá káꞌa̱n na chínáꞌa na xa̱ꞌa̱ ña sóko̱ na no̱o̱ Ndios ña ndóso no̱o̱ na̱ma̱ yóꞌo, ta saá ndixa xíni̱ ñóꞌó kasa ndivi na ña káꞌa̱n na”, káchí ndó. ");
INSERT INTO mim_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Nasóꞌó ta nakuáá kúu ndóꞌó! ¿Yukía̱ kúu ñakáꞌno xíni̱ ñóꞌó ní ka̱? ¿Án ña sóko̱ ni̱vi nándoso no̱o̱ na̱ma̱, án mi̱i na̱ma̱ yi̱i̱ veꞌe ño̱ꞌo káꞌno?, saá chi na̱ma̱ veꞌe ño̱ꞌo káꞌno kúu ña ndása yi̱i̱ ndiꞌi ñasóko̱ ña nándoso no̱o̱ ña. ");
INSERT INTO mim_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Chi ni̱vi na chínáꞌa xa̱ꞌa̱ na̱ma̱ yi̱i̱ veꞌe ño̱ꞌo káꞌno, nayóꞌo chínáꞌa na xa̱ꞌa̱ ndiꞌi ñasóko̱ ña nándoso no̱o̱ na̱ma̱ yóꞌo, ");
INSERT INTO mim_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ta ni̱vi na chínáꞌa xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno, nayóꞌo chínáꞌa na Ndios, ta̱ yóo veꞌe ño̱ꞌo káꞌno. ");
INSERT INTO mim_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ta ni̱vi na chínáꞌa xa̱ꞌa̱ ñoyívi ni̱no, nayóꞌo chínáꞌa na xa̱ꞌa̱ tón táyi̱ káꞌno Ndios, ta chínáꞌa na xa̱ꞌa̱ mi̱i Ndios, ta̱ yóo ñoyívi ni̱no. ");
INSERT INTO mim_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, nafariseo xíꞌin na sánáꞌa nda̱yí Ndios! ¡Ni̱vi na o̱vi̱ yuꞌu̱ kúu ndó! Saá chi táxi ndó ndaꞌa̱ Ndios ñii koꞌndo ña ta̱va ndó ti̱xin ña u̱xu̱ koꞌndo ña kúu ñii ñii no̱o̱ yu̱ku̱ válí ña xíxi yó, ta o̱n vása kísa ndivi ndó chiño ña xíni̱ ñóꞌó ní ka̱ no̱o̱ Ndios. Chi no̱o̱ Ndios ña xíni̱ ñóꞌó ní ka̱ kúu ña keꞌé yó ñanda̱a̱ xíꞌin inka̱ ni̱vi, ña kundáꞌví ini yó koni yó ndiꞌi ni̱vi, ta chikaa̱ ndinoꞌo ini yó ña kandixa yó Ndios. Xíni̱ ñóꞌó kasa ndivi ndó chiño náꞌno yóꞌo no̱o̱ Ndios. Ta saá ni, o̱n sandakoo ndó kasa ndivi ndó inka̱ chiño válí no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ndóꞌó sánáꞌa ndó ni̱vi ko̱ꞌo̱n na yichi̱, ta mi̱i ndó nakuáá kúu ndó! Kéꞌé ndó nda̱tán kéꞌé ni̱vi na xíꞌi takuií ta siꞌna sáxixin na títikon loꞌo ta ko̱ko̱ na tícamello ñóꞌo xíꞌin takuií xíꞌi na. ");
INSERT INTO mim_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, nafariseo xíꞌin na sánáꞌa nda̱yí Ndios! ¡Na o̱vi̱ yuꞌu̱ kúu ndó! Nákata ndó sa̱ta̱ vaso xíꞌin sa̱ta̱ ko̱ꞌo̱, ta ini mi̱i ndó chútú ní ñakuíꞌná, ta o̱n vása táku̱ ndó ñanda̱kú. ");
INSERT INTO mim_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Ndóꞌó nafariseo nakuáá kúu ndó! Siꞌna xíni̱ ñóꞌó ndasa ndii ndó níma̱ ndó, ta saá ndundii ndiꞌi mi̱i ndó no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, nafariseo xíꞌin na sánáꞌa nda̱yí Ndios! ¡Na o̱vi̱ yuꞌu̱ kúu ndó! Nda̱tán yóo ñii veꞌe yaa no̱o̱ ndúxu̱n ni̱vi na ni̱xiꞌi̱, saá yóo ndóꞌó, chi yaa ní sa̱ta̱ veꞌe yóꞌo ta ti̱xin ña nina chútú leke xíꞌin ndiꞌi ña táꞌyí. ");
INSERT INTO mim_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nda̱tán káa ni̱vi na va̱ꞌa ní, saá káa ndó no̱o̱ inka̱ ni̱vi, ta níma̱ ndó chútú ña o̱n váꞌa xíꞌin ñavatá. ");
INSERT INTO mim_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, nafariseo xíꞌin na sánáꞌa nda̱yí Ndios! ¡Na o̱vi̱ yuꞌu̱ kúu ndó! Livi ní kísa va̱ꞌa ndó veꞌe no̱o̱ ni̱ndu̱xu̱n naprofeta xi̱na̱ꞌá, ta saá livi ní ndása va̱ꞌa ndó no̱o̱ ni̱ndu̱xu̱n inka̱ ni̱vi na va̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ta káꞌa̱n ndó: “Tá ní xi̱taku̱ yó xi̱na̱ꞌá kui̱ya̱ xi̱taku̱ naxi̱i̱ síkuá yó, ta nda̱ loꞌo o̱n chindeé yó nayóꞌo ña kaꞌni na naprofeta”, káchí ndó. ");
INSERT INTO mim_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ta xíꞌin to̱ꞌon yóꞌo náꞌma mi̱i ndó ña kúu ndó sa̱ꞌya ñani síkuá na xa̱ꞌni naprofeta xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Ta vitin va̱ꞌa saxi̱no̱ ndó kasa ndivi ndó ña ki̱xáꞌá kéꞌé naxi̱i̱ síkuá ndó xi̱na̱ꞌá! ");
INSERT INTO mim_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Sa̱ꞌya ko̱o̱ xati̱ kúu ndóꞌó! ¿Ndasaá kuchiño saka̱ku xíꞌin mi̱i ndó ña o̱n ko̱ꞌo̱n ndó nda̱ya? ");
INSERT INTO mim_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ta saá tiꞌví i̱ naprofeta na káꞌa̱n ndoso to̱ꞌon i̱, ta tiꞌví i̱ nandíchí na xíni̱ to̱ꞌon i̱, ta tiꞌví i̱ na sánáꞌa to̱ꞌon i̱ ta ka̱ꞌa̱n na xíꞌin ndó. Ta ndóꞌó kaꞌni ndó sava nayóꞌo, ta inka̱ na katakaa̱ ndaa ndó ña kivi̱ na ndaꞌa̱ tón cruz, ta sava na kani ndó xíꞌin kuártá veꞌe ño̱ꞌo sinagoga, ta sava nayóꞌo ñii ñii ñoo ndó taxin ndó na. ");
INSERT INTO mim_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ta sa̱ta̱ mi̱i ndó nakava kua̱chi xa̱ꞌa̱ ña ni̱xi̱ta̱ ni̱i̱ ndiꞌi ni̱vi na va̱ꞌa xi̱na̱ꞌá, ta ki̱xáꞌá ña xíꞌin ña ni̱xiꞌi̱ ta̱Abel, ta ndi̱ꞌi ña xíꞌin ña ni̱xiꞌi̱ ta̱Zacarías, sa̱ꞌya ta̱Berequías. Ta ni̱vi xi̱i̱ síkuá ndó xa̱ꞌni na ta̱Zacarías ki̱vi̱ xi̱ndichi ra ma̱ꞌñó ña kúu yéꞌé veꞌe ño̱ꞌo káꞌno xíꞌin ña kúu na̱ma̱ yi̱i̱ no̱o̱ sóko̱ na ña̱ꞌa no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ta ndixa káꞌa̱n i̱ xíꞌin ndó, sa̱ta̱ mi̱i ndó ni̱vi na táku̱ vitin, nakava kua̱chi xa̱ꞌa̱ ña ni̱xi̱ta̱ ni̱i̱ ndiꞌi nava̱ꞌa yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá: ―¡Nañoo Jerusalén, ndóꞌó kúu na xáꞌni naprofeta, ndóꞌó kúu na kóon yu̱u̱ ni̱vi na ti̱ꞌví Ndios ña chindeé na ndóꞌó! ¡Kua̱ꞌa̱ ní yichi̱ káchí ini i̱ nakaya i̱ ndóꞌó, nda̱tán ñii nduxú siꞌí nákaya rí sa̱ꞌya rí ti̱xin ndi̱xi̱n rí, ta ni̱‑xiin ndó kundaa i̱ ndóꞌó! ");
INSERT INTO mim_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ta vitin sandakoo Ndios veꞌe ño̱ꞌo ndó, ta kuu vi̱chí ña ta ndu̱xu̱n ña. ");
INSERT INTO mim_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ta ndixa káꞌa̱n i̱ xíꞌin ndó, nañoo Jerusalén, o̱n koto ka̱ ndó yi̱ꞌi̱ nda̱ to̱nda̱a ki̱vi̱ ka̱ꞌa̱n ndó to̱ꞌon yóꞌo: “Ná keꞌé Ndios ñava̱ꞌa xíꞌin ta̱yóꞌo, ta̱a ta̱ ki̱xaa̱ xíꞌin nda̱yí Ndios”, kachí ndó xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ta saá ta̱Jesús ke̱ta ra veꞌe ño̱ꞌo káꞌno ta kua̱ꞌa̱n ra, ta naxíka xíꞌin ra ni̱xaa̱ yatin na no̱o̱ ra, ta ki̱xáꞌá na káꞌa̱n na xíꞌin ra xa̱ꞌa̱ veꞌe ño̱ꞌo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―¿Án xíto ndó ndiꞌi ñayóꞌo? Ta ndixa káꞌa̱n i̱ xíꞌin ndó, nda̱ ñii ka̱ yu̱u̱ o̱n kóo ka̱ sa̱ta̱ inka̱ yu̱u̱. Saá chi ñii ki̱vi̱ ña va̱xi tani veꞌe ño̱ꞌo yóꞌo ta ndiꞌi xa̱ꞌa̱ ña ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ta saá kua̱ꞌa̱n na xi̱ki̱ tón Olivo ta xi̱koo ta̱Jesús no̱o̱ ñoꞌo̱, ta naxíka xíꞌin ra xi̱to na o̱n ko̱ó ka̱ ni̱vi, ta ki̱xaa̱ na no̱o̱ ra, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tata, kóni ndi̱ ndato̱ꞌon ún xíꞌin ndi̱, ¿ama koo saá ña ka̱chí ún? ¿Ndá seña kuu ña koni ndi̱ ña kunda̱a̱ ini ndi̱ ña xa yatin kixi tuku ún, ta kixaa̱ ki̱vi̱ sondíꞌí ñoyívi yóꞌo? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin na: ―Koto va̱ꞌa ndó ña o̱n sandáꞌví ni̱vi ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Saá chi kua̱ꞌa̱ ní ta̱a kixaa̱, ta ki̱vi̱ kixaa̱ ñii ñii na, ta ka̱ꞌa̱n na xíꞌin ndó, kachí na saá: “Yi̱ꞌi̱ kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku na ñoyívi yóꞌo”, kachí na xíꞌin ndó, ta sandáꞌví na kua̱ꞌa̱ ní ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ta koni̱ so̱ꞌo ndó yóo kua̱chi xáꞌni táꞌan na ñoo yatin, ta xáꞌni táꞌan na ñoo xíká, ta o̱n kuyi̱ꞌví ndó. Chi xíni̱ ñóꞌó kundivi ndiꞌi ñayóꞌo, ta saá ni, ta̱ꞌán kixaa̱ ki̱vi̱ ñasondíꞌí ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ki̱vi̱ ña va̱xi nakuita ni̱vi na ñoo náꞌno kaꞌni táꞌan na xíꞌin ni̱vi na inka̱ ñoo náꞌno, ta ñoo no̱o̱ yóo narey kaꞌni táꞌan na xíꞌin inka̱ ñoo no̱o̱ yóo inka̱ narey. Ta kua̱ꞌa̱ ní xiiña ta̱an no̱o̱ ñoꞌo̱, ta koo ní so̱ko, xíꞌin ndiꞌi no̱o̱ kue̱ꞌe̱. ");
INSERT INTO mim_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ñayóꞌo kuiti kuu ña kixáꞌá ña xo̱ꞌvi̱ ní ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Sava ni̱vi tiin na ndóꞌó ko̱ꞌo̱n ndó xíꞌin na, ta nataxi na ndóꞌó ndaꞌa̱ nachiño náꞌno, ta saxo̱ꞌvi̱ na ndóꞌó, ta kaꞌni na sava ndóꞌó. Ndiꞌi ni̱vi ñoyívi yóꞌo kusaa̱ ini na koni na ndóꞌó chi na ndíko̱n yi̱ꞌi̱ kúu ndó. ");
INSERT INTO mim_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ta ki̱vi̱ kundivi ñayóꞌo saá, kua̱ꞌa̱ ní ni̱vi sandakoo na yichi̱ i̱, ta kusaa̱ ní ini na koni na xíꞌin táꞌan mi̱i na, ta sandáꞌví xíꞌin táꞌan mi̱i na nataxi na natáꞌan na ndaꞌa̱ nachiño. ");
INSERT INTO mim_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ta nakuita kua̱ꞌa̱ ní naprofeta vatá sandáꞌví na kua̱ꞌa̱ ní ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ndeé ní kuaꞌno ka̱ ña o̱n váꞌa, ta kua̱ꞌa̱ ní ni̱vi sandakoo na ña kukiꞌvi ini na koni táꞌan na. ");
INSERT INTO mim_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ta ni̱vi na o̱n vása sandakoo yichi̱ i̱, ta kundiko̱n va̱ꞌa na ña, nda̱ kixaa̱ ki̱vi̱ ndi̱ꞌi ña xo̱ꞌvi̱ na ñoyívi yóꞌo, ta Ndios saka̱ku ra na ña kutaku̱ na xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ta ni̱vi na ndíko̱n yi̱ꞌi̱ ndato̱ꞌon na xa̱ꞌa̱ i̱ xíꞌin ndiꞌi ni̱vi na ndóo ndiꞌi saá ñoo ñoyívi yóꞌo ña kunda̱a̱ ini na to̱ꞌon i̱, ta saá kixaa̱ ki̱vi̱ ñasondíꞌí ñoyívi yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ta ndóꞌó na káꞌvi to̱ꞌon yóꞌo xíni̱ ñóꞌó kunda̱a̱ ini ndó to̱ꞌon yóꞌo ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Kui̱ya̱ xi̱na̱ꞌá ta̱profeta Daniel ni̱ka̱ꞌa̱n ra xa̱ꞌa̱ ña o̱n váꞌa ñakini ña sandiꞌi xa̱ꞌa̱ ñayi̱i̱. Ta kixaa̱ ki̱vi̱ koto ndó yóo ña o̱n váꞌa ñakini yóꞌo veꞌe ño̱ꞌo káꞌno, ");
INSERT INTO mim_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ta ndiꞌi ni̱vi na ndóo estado Judea yóꞌo, xíni̱ ñóꞌó kee na ta kono na ko̱ꞌo̱n na no̱o̱ yóo yuku̱ síkón. ");
INSERT INTO mim_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tá ni̱vi nándoso na si̱ni̱ veꞌe na, ta nayóꞌo o̱n váꞌa noo na nakiꞌin na ña kómí na veꞌe na. ");
INSERT INTO mim_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tá ni̱vi ñóꞌo yuku̱, ta nayóꞌo, o̱n váꞌa ndikó ka̱ na veꞌe na nakiꞌin na tika̱chí na. ");
INSERT INTO mim_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ndáꞌví ní náñaꞌa̱ ná ñóꞌo sa̱ꞌya, ta ndáꞌví ní náñaꞌa̱ ná yóo sa̱ꞌya válí na chíchín, chi ndeé ní koo ña xo̱ꞌvi̱ ná ki̱vi̱ kundivi ñayóꞌo saá! ");
INSERT INTO mim_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ndukú ndó no̱o̱ Ndios ña o̱n kuu ña ki̱vi̱ vi̱xin ní, ni ki̱vi̱ yi̱i̱ ña nákindée yó ña kundoꞌo ndó saá. ");
INSERT INTO mim_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nda̱ ki̱vi̱ no̱ó ña ki̱sa va̱ꞌa Ndios ñoyívi yóꞌo ta̱nda̱ vitin, nani̱vi xóꞌvi̱ na. Ta ki̱vi̱ koo ña o̱n váꞌa yóꞌo saá, ndeé ní ka̱ xo̱ꞌvi̱ ndiꞌi ni̱vi. Ta nda̱ ñii ka̱ ki̱vi̱ ña va̱xi o̱n xo̱ꞌvi̱ ka̱ na nda̱tán xo̱ꞌvi̱ na ki̱vi̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ta xa̱ꞌa̱ ña kúndáꞌví ini Ndios xíni ra ni̱vi na na̱ka̱xin ra ndíko̱n yichi̱ ra kúu ña chi̱tóni̱ ra saloꞌo ki̱vi̱ xo̱ꞌvi̱ ni̱vi ñoyívi yóꞌo. Tá o̱n vása ní‑chitóni̱ ra saá, níkúu, ta nda̱ ñii ni̱vi o̱n ki̱ví ka̱ku na no̱o̱ ña xóꞌvi̱ na. ");
INSERT INTO mim_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Tá yóo ñii ni̱vi na ka̱ꞌa̱n xíꞌin ndó: “Yóꞌo yóo Cristo ta̱ ti̱ꞌví Ndios saka̱ku na ñoyívi yóꞌo”, án “Koto ndó, kaa̱ yóo ra”, kachí na xíꞌin ndó, ta o̱n kandixa ndó na. ");
INSERT INTO mim_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chi nakuita kua̱ꞌa̱ ní navatá ta ka̱ꞌa̱n na, kachí na siꞌa: “Yi̱ꞌi̱ kúu Cristo ta̱ ti̱ꞌví Ndios”, ta inka̱ na ka̱ꞌa̱n, kachí na: “Yi̱ꞌi̱ kúu ta̱profeta ta̱ káꞌa̱n ndoso to̱ꞌon Ndios”, ta o̱n si̱ví nanda̱a̱ kúu na. Navatá yóꞌo to̱nda̱a na keꞌé na milagro ña sandáꞌví na ni̱vi, ta̱nda̱ yatin kuchiño sandáꞌví na ni̱vi na na̱ka̱xin Ndios kundiko̱n yichi̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Vitin kúnda̱a̱ ini ndó ndiꞌi ñayóꞌo, chi xa nda̱to̱ꞌon i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ta saá tá ka̱ꞌa̱n ni̱vi xíꞌin ndó, kachí na: “Koto ndó no̱o̱ yóo yuku̱ yi̱chí, chi kán yóo ta̱a ta̱ ti̱ꞌví Ndios saka̱ku na ñoyívi yóꞌo”, kachí na, ta o̱n ko̱ꞌo̱n ndó no̱o̱ yóo yuku̱ yi̱chí koto ndó ra. Tá ka̱ꞌa̱n tuku na xíꞌin ndó: “Koto ndó ini veꞌe, chi yóꞌo yóo ta̱a ta̱ ti̱ꞌví Ndios saka̱ku na ñoyívi yóꞌo”, kachí na, ta o̱n kandixa ndó ña ka̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nda̱tán yóo ta̱xa̱ ña náyeꞌe ñoyívi, kíxáꞌá ña náyeꞌe ña nda̱ no̱o̱ kána ño̱ꞌo ta̱nda̱ no̱o̱ ndétá ño̱ꞌo náyeꞌe ña, saá koo ki̱vi̱ ndikó i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tá xíto ndó míkía̱ ndáchí kua̱ꞌa̱ ní tio̱ko chée, ta saá kúnda̱a̱ ini ndó míchí kándúꞌu̱ ñii kiti̱ tí ni̱xiꞌi̱. Ñii ki̱ꞌva saá kunda̱a̱ ini ndó seña ña kachí xa yatin ní to̱nda̱a ki̱vi̱ ña ndikó i̱ ñoyívi yóꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá xíꞌin na: ―Ta ki̱vi̱ ndiꞌi ña xo̱ꞌvi̱ ni̱vi, xa̱ndi̱ko̱n ña ño̱ꞌo káꞌno yéꞌe kunaa no̱o̱ ña, ta tíyo̱o̱ o̱n vása nayeꞌe ka̱ rí, ta tíki̱mi kee rí ñoyívi ni̱no ta ko̱yo rí, ta ndiꞌi ña kómí ndee̱ yóo ñoyívi ni̱no kanda ña ta kisin ndiꞌi ñayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ta ndiꞌi ni̱vi koni na ñii seña ñoyívi ni̱no ña sanáꞌa ña ndikó yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ta saá ndiꞌi nañoo ñoyívi yóꞌo kuchuchú ní ini na, ta kuaku ní na. Ta saá ndiꞌi ni̱vi koni na yi̱ꞌi̱, ta va̱xi i̱ ma̱ꞌñó vi̱ko̱, xíꞌin ndee̱ káꞌno, xíꞌin ndiꞌi ña yéꞌe livi. ");
INSERT INTO mim_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Xíꞌin ña ndáꞌyi trompeta, yi̱ꞌi̱ tiꞌví i̱ naángel ko̱ꞌo̱n na nakaya na ndiꞌi ni̱vi na na̱ka̱xin i̱ na kúu na ndíko̱n yichi̱ i̱. Ta ni̱vi yóꞌo kee na ndiꞌi saá xiiña no̱o̱ ñoꞌo̱ ñoyívi yóꞌo xíꞌin ñoyívi ni̱no, ta kixaa̱ na no̱o̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ta ndóꞌó, sakuáꞌá ndó ta kunda̱a̱ ini ndó ña sánáꞌa yito̱n tón higo: Tá xa va̱xi nduxa̱á nó, ta nákoo yu̱ku̱ yúta̱ ndaꞌa̱ nó, ta saá kúnda̱a̱ ini ndó xa ni̱kuyatin ní kixaa̱ sa̱vi̱. ");
INSERT INTO mim_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ta ki̱vi̱ xíto ndó xa kua̱ꞌa̱n kundivi ndiꞌi ñayóꞌo ña nda̱to̱ꞌon i̱ xíꞌin ndó, ta saá kunda̱a̱ ini ndó xa va̱xi kuyatin ki̱vi̱ ndikó i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ta ndixa káꞌa̱n i̱ xíꞌin ndó, ni̱vi na xíto kixáꞌá seña yóꞌo kutaku̱ ka̱ na nda̱ ndi̱ꞌi ku̱ndivi ndiꞌi ña nda̱to̱ꞌon i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ña ñoyívi ni̱no xíꞌin ña ñoyívi yóꞌo ñii ki̱vi̱ va̱xi ndiꞌi xa̱ꞌa̱ ña, ta to̱ꞌon i̱ o̱n ndiꞌi xa̱ꞌa̱ ña, ta kindo̱o ña ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Nda̱ ñii ni̱vi o̱n vása xíni̱ na ama ndikó i̱, ni ni̱vi na ndóo ñoyívi yóꞌo, ni naángel na ndóo ñoyívi ni̱no. Ta ñii la̱á Ndios Tata Yivá yó kúu ta̱a ta̱ xíni̱ ama ndikó i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ñii ki̱ꞌva xi̱taku̱ ni̱vi ki̱vi̱ ni̱xi̱yo ta̱Noé, saá kutaku̱ na ki̱vi̱ kuyatin ndikó i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Saá chi ki̱vi̱ xi̱taku̱ ta̱Noé xi̱na̱ꞌá ndiꞌi ni̱vi xíxi na, xíꞌi na, ta tónda̱ꞌa̱ na, ta táxi na tonda̱ꞌa̱ sa̱ꞌya na, saá yóo na nda̱ ni̱to̱nda̱a ki̱vi̱ ni̱ki̱ꞌvi ta̱Noé ini tón barco. ");
INSERT INTO mim_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ta o̱n vása ní‑kunda̱a̱ ini na yukía̱ kundoꞌo na a̱nda̱ ki̱vi̱ ki̱xáꞌá ni̱koon sa̱vi̱ naꞌá, ta saá ta̱ni ndiꞌi na ta ni̱ka̱ꞌa̱ na xíꞌin takuií ta ni̱xiꞌi̱ ndiꞌi ni̱vi yóꞌo. Saá chi o̱n vása ní‑xiyo tiꞌva na, ta ñii ki̱ꞌva saá o̱n vása koo tiꞌva ni̱vi ki̱vi̱ ndikó i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tá o̱vi̱ ta̱a kísa chiño ra yuku̱, ta nakiꞌin i̱ ñii ta̱yóꞌo ko̱ꞌo̱n ra xíꞌin i̱, ta inka̱ ra ndo̱o. ");
INSERT INTO mim_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tá o̱vi̱ násíꞌí yóo ná ndíko ná, ta nakiꞌin i̱ ñii ñá ko̱ꞌo̱n ñá xíꞌin i̱, ta inka̱ ñá ndo̱o. ");
INSERT INTO mim_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Ta saá ndóꞌó, kundo̱o tiꞌva ndó chi o̱n vása xíni̱ ndó ama ndikó yi̱ꞌi̱, ta̱Káꞌno no̱o̱ ndó, ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ta kunda̱a̱ va̱ꞌa ini ndó ñayóꞌo: Tá ñii ta̱a yóo ra veꞌe ra, ta xíni̱ ra ama kixaa̱ ta̱kuíꞌná, ta saá koo tiꞌva ra ta o̱n taxi ra ki̱ꞌvi ta̱kuíꞌná yóꞌo kasa kuíꞌná ra ñakuíká kómí ra veꞌe ra. ");
INSERT INTO mim_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ta saá ndóꞌó xíni̱ ñóꞌó kundo̱o tiꞌva ndó, saá chi ndikó i̱ ñoyívi yóꞌo ñii ki̱vi̱ ña o̱n vása ndáti ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ta ni̱ka̱ꞌa̱n tuku ta̱Jesús, káchí ra saá: ―¿Ndasaá keꞌé ñii ta̱káꞌno xíꞌin ñii ta̱a ta̱ kísa chiño xíꞌin ndinoꞌo ini no̱o̱ ra? Ta ta̱káꞌno yóꞌo sakuiso chiño ra ta̱yóꞌo ña taxi ta̱yóꞌo kuxu ni̱vi na yóo veꞌe ta kasa kuenda ra xíꞌin veꞌe yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ta saá kunakaa̱ ñasi̱i̱ níma̱ ta̱ kísa chiño xíꞌin ndinoꞌo ini ki̱vi̱ ndikó ta̱káꞌno no̱o̱ ra, ta koto ra va̱ꞌa ní ki̱sa ndivi ra chiño. ");
INSERT INTO mim_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ta ndixa káꞌa̱n i̱ xíꞌin ndó, ta̱káꞌno yóꞌo taxi ra ndaꞌa̱ ta̱ kísa chiño xíꞌin ndinoꞌo ini, ña kuiso chiño ra xíꞌin ndiꞌi ña̱ꞌa veꞌe ta̱káꞌno yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tá yóo ñii ta̱a ta o̱n vása kísa chiño ra xíꞌin ndinoꞌo ini ra, ta xáni si̱ni̱ ra saá: “Xa naꞌá ní kuáchi̱ ta̱káꞌno no̱o̱ yó, o̱n vása xíni̱ yó ndá ki̱vi̱ ndikó ra”, xáni si̱ni̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ta saá kíxáꞌá ra ndiꞌi saá ki̱vi̱ káni ra na kísa chiño xíꞌin ra, ta ñii ki̱ꞌva saá kíxáꞌá ra ndiꞌi saá ki̱vi̱ xíxi ra ta xíꞌi ra xíꞌin na xíꞌi ní. ");
INSERT INTO mim_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ta ñii ki̱vi̱ ña o̱n vása ndáti ra, ni hora ña o̱n vása yóo tiꞌva ra, ta ndikó ta̱káꞌno no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ta ta̱káꞌno no̱o̱ ra yóꞌo saxo̱ꞌvi̱ ní ñaꞌá ra, ta tiꞌví ñaꞌá ra ko̱ꞌo̱n ra no̱o̱ ndóo ni̱vi na o̱n váꞌa na o̱vi̱ yuꞌu̱, no̱o̱ kuaku ní na ta no̱o̱ xo̱ꞌvi̱ ní na ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ta ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá: ―Ná ndato̱ꞌon i̱ ñii cuento xíꞌin ndó ndasaá koo ki̱vi̱ kaꞌnda chiño Ndios ñoyívi yóꞌo. Saá ndo̱ꞌo u̱xu̱ násíꞌí ná ke̱e kua̱ꞌa̱n no̱o̱ yóo viko̱ tonda̱ꞌa̱ ñii ñátáꞌan ná. Ta ná u̱xu̱ yóꞌo níꞌi ná ñoꞌo̱ tóo̱n ta ke̱e ná kua̱ꞌa̱n ná nakutáꞌan ná xíꞌin ta̱a ta̱ tonda̱ꞌa̱. ");
INSERT INTO mim_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ta o̱ꞌo̱n násíꞌí yóꞌo ná ndíchí ní si̱ni̱ ta xa yóo tiꞌva ná, ta inka̱ o̱ꞌo̱n násíꞌí ná o̱n vása ndíchí si̱ni̱ ni o̱n vása yóo tiꞌva ná. ");
INSERT INTO mim_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ta o̱ꞌo̱n náñaꞌa̱ ná o̱n vása ndíchí si̱ni̱ yóꞌo, vará níꞌi ná ñoꞌo̱ tóo̱n, ta o̱n vása ndíso ka̱ ná aceite ña chikaa̱ ná ini ñoꞌo̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ta ná o̱ꞌo̱n ndíchí si̱ni̱, ndíso ka̱ ná ki̱si ñóꞌo aceite xíꞌin ñoꞌo̱ tóo̱n. ");
INSERT INTO mim_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ta xa naꞌá ní ni̱kuáchi̱ ta̱ kóni tonda̱ꞌa̱, o̱n ko̱ó ra kíxaa̱, ta u̱xu̱ násíꞌí yóꞌo ka̱ni maꞌná ná ta ni̱ki̱si̱n ná. ");
INSERT INTO mim_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ta ma̱ꞌñó ñoó xi̱ni̱ so̱ꞌo u̱xu̱ saá náñaꞌa̱ káꞌa̱n ni̱vi: “¡Xa va̱xi ta̱a ta̱ tonda̱ꞌa̱! ¡Kee ndó nakiꞌin va̱ꞌa ndó ra!”, káchí na. ");
INSERT INTO mim_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ta saá nda̱koo u̱xu̱ násíꞌí yóꞌo, ta ki̱xáꞌá ná kasa ndivi ná ña natoo̱n yeꞌe va̱ꞌa ñoꞌo̱ ná. ");
INSERT INTO mim_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ta o̱ꞌo̱n náñaꞌa̱ ná o̱n vása ndíchí si̱ni̱ ni̱ka̱ꞌa̱n ná xíꞌin náñaꞌa̱ ná xa yóo tiꞌva: “Taxi loꞌo ndó aceite ndaꞌa̱ ndi̱, saá chi kóni nda̱ꞌva̱ ñoꞌo̱ ndi̱”, káchí ná. ");
INSERT INTO mim_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ta nda̱kuii̱n násíꞌí ná xa yóo tiꞌva: “O̱n kúchiño taxi ndi̱ aceite, chi o̱n kunani ña koni̱ ñóꞌó ndóꞌó xíꞌin ndi̱ꞌi̱. Va̱ꞌa ka̱ kua̱ꞌa̱n ndó no̱o̱ síkó na aceite ta sata ndó ña koni̱ ñóꞌó mi̱i ndó”, káchí ná. ");
INSERT INTO mim_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tá kua̱ꞌa̱n násíꞌí ná o̱n vása ndíchí si̱ni̱ ña sata ná aceite, ta ki̱xaa̱ ta̱a ta̱ tonda̱ꞌa̱. Ta násíꞌí ná ndíchí si̱ni̱ ná xa yóo tiꞌva xíꞌin ñoꞌo̱ tóo̱n na̱kutáꞌan ná xíꞌin ra, ta ni̱ki̱ꞌvi ná xíꞌin ra viko̱ tonda̱ꞌa̱. Ta ndási̱ kútu̱ yéꞌé veꞌe no̱o̱ yóo viko̱. ");
INSERT INTO mim_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ta saá násíꞌí ná o̱n vása ndíchí si̱ni̱, ndi̱kó ná ki̱xaa̱ ná ta ka̱na ná, káchí ná saá: “¡Tata, tata, nakuiná ún yéꞌé ná ki̱ꞌvi ndi̱ viko̱!”, káchí ná. ");
INSERT INTO mim_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ta nda̱kuii̱n ta̱ tonda̱ꞌa̱, káchí ra saá: “Ndixa káꞌa̱n i̱ xíꞌin ndó, o̱n vása xíni̱ i̱ ndóꞌó”, káchí ra xíꞌin násíꞌí ná o̱n vása ndíchí si̱ni̱ ni o̱n vása yóo tiꞌva. Saá ndi̱ꞌi cuento loꞌo yóꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ta saá ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin na: ―Ta saá ndóꞌó, kundo̱o tiꞌva ndó chi o̱n vása xíni̱ ndó ama ndikó yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ta ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá: ―Ná ndato̱ꞌon i̱ inka̱ cuento xíꞌin ndó ndasaá koo ña kaꞌnda chiño Ndios ñoyívi yóꞌo. Saá ndo̱ꞌo ñii ta̱a siꞌna ka̱ kee ra ko̱ꞌo̱n ra ñii chiño inka̱ ñoo, ta ka̱na ra na kísa chiño no̱o̱ ra, ta ki̱xaa̱ na, ta sa̱kuiso chiño ra na ñakuíká kómí ra. ");
INSERT INTO mim_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Ta̱xi ra ñii bolsa káꞌno si̱ꞌún ña kómí o̱ꞌo̱n talento ndaꞌa̱ ñii ta̱ kísa chiño no̱o̱ ra, ta inka̱ bolsa si̱ꞌún ña kómí o̱vi̱ talento ndaꞌa̱ inka̱ ra, ta ñii bolsa si̱ꞌún ña kómí ñii talento ndaꞌa̱ ta̱u̱ni̱, saá chi xíni̱ va̱ꞌa ra ndasaá kísa chiño ñii ñii ta̱ kísa chiño no̱o̱ ra. Ta saá ke̱e ra kua̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ta̱a ta̱ na̱kiꞌin o̱ꞌo̱n bolsa náꞌno si̱ꞌún, ta ni̱xa̱ꞌa̱n ra sa̱ta ra ta ni̱si̱kó ra, ta saá na̱kiꞌin ra inka̱ o̱ꞌo̱n bolsa náꞌno si̱ꞌún. ");
INSERT INTO mim_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ñii ki̱ꞌva ki̱sa chiño ta̱a ta̱no̱ó saá ki̱sa chiño ta̱o̱vi̱ yóꞌo xíꞌin o̱vi̱ bolsa náꞌno si̱ꞌún, ta na̱kiꞌin ra inka̱ o̱vi̱ bolsa náꞌno si̱ꞌún sa̱ta̱ ña. ");
INSERT INTO mim_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ta ta̱u̱ni̱ na̱kiꞌin ñii bolsa káꞌno si̱ꞌún, ta xa̱ta kónó ra ñii yavi̱ no̱o̱ ñoꞌo̱, ta sa̱ndúxu̱n ra si̱ꞌún ta̱patrón ra. ");
INSERT INTO mim_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Ta ni̱yaꞌa kua̱ꞌa̱ ní ki̱vi̱, ta saá ndi̱kó ta̱patrón na̱xaa̱ ra veꞌe ra, ta kóni ndasa ra kuenda xíꞌin na kísa chiño no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ta ki̱xaa̱ ta̱ na̱kiꞌin o̱ꞌo̱n bolsa náꞌno si̱ꞌún, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱patrón: “Tata, ta̱xi ún o̱ꞌo̱n bolsa náꞌno si̱ꞌún ndaꞌa̱ i̱, ta vitin yóꞌo nakiꞌin ún ña, ta nakiꞌin ún inka̱ o̱ꞌo̱n bolsa náꞌno si̱ꞌún ña na̱kiꞌin i̱ sa̱ta̱ ña xa̱ꞌa̱ ña ki̱sa chiño i̱ ña”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ta ni̱ka̱ꞌa̱n ta̱patrón: “Va̱ꞌa ní ki̱sa ndivi ún chiño. Va̱ꞌa ní ta̱mozo kúu ún. Va̱ꞌa ní kúchiño kundaa ini i̱ yóꞌó. Ta sakuiso chiño i̱ yóꞌó kua̱ꞌa̱ ní ka̱ ña̱ꞌa, saá chi va̱ꞌa ní ki̱sa ndivi ún chiño loꞌo yóꞌo. Ta vitin naꞌa ki̱ꞌvi ún veꞌe i̱ ta kusii̱ ní ini ún xíꞌin i̱”, káchí ta̱patrón. ");
INSERT INTO mim_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ta ta̱ na̱kiꞌin o̱vi̱ bolsa náꞌno si̱ꞌún ki̱xaa̱ ra no̱o̱ ta̱patrón, ta ni̱ka̱ꞌa̱n ra: “Tata, ta̱xi ún o̱vi̱ bolsa náꞌno si̱ꞌún ndaꞌa̱ i̱, ta vitin yóꞌo nakiꞌin ún ña, ta nakiꞌin ún inka̱ o̱vi̱ bolsa náꞌno si̱ꞌún ña na̱kiꞌin i̱ sa̱ta̱ ña xa̱ꞌa̱ ña ki̱sa chiño i̱ ña”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ta ni̱ka̱ꞌa̱n ta̱patrón: “Va̱ꞌa ní ki̱sa ndivi ún chiño. Va̱ꞌa ní ta̱mozo kúu ún. Va̱ꞌa ní kúchiño kundaa ini i̱ yóꞌó. Ta sakuiso chiño i̱ yóꞌó kua̱ꞌa̱ ní ka̱ ña̱ꞌa, saá chi va̱ꞌa ní ki̱sa ndivi ún chiño loꞌo yóꞌo. Ta vitin naꞌa ki̱ꞌvi ún veꞌe i̱ ta kusii̱ ní ini ún xíꞌin i̱”, káchí ta̱patrón. ");
INSERT INTO mim_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ta ta̱ na̱kiꞌin ñii bolsa káꞌno si̱ꞌún ki̱xaa̱ ra, ta ni̱ka̱ꞌa̱n ra: “Tata, xíni̱ va̱ꞌa i̱ yóꞌó kúu ñii ta̱a ta̱ ndeé ní ini. Yóꞌó kúu ta̱ nákaya ña̱ꞌa no̱o̱ o̱n vása ní‑chiꞌi ún, ta nákiꞌin ún ñava̱ꞌa no̱o̱ o̱n vása ní‑kisa chiño ún. ");
INSERT INTO mim_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ta ni̱yi̱ꞌví ini i̱, ta ni̱xa̱ꞌa̱n i̱ chi̱kaa̱ seꞌé i̱ si̱ꞌún ún yavi̱ kónó ti̱xin ñoꞌo̱. Ta vitin yóꞌo nakiꞌin ún si̱ꞌún ún ña ta̱xi ún ndaꞌa̱ i̱”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ta nda̱kuii̱n ta̱patrón, káchí ra saá: “¡Yóꞌó kúu ta̱mozo ndiva̱ꞌa, ta̱ xúxán ní! Tá xa xíni̱ ún yi̱ꞌi̱ kúu ta̱ nákaya ña̱ꞌa no̱o̱ o̱n vása ní‑chiꞌi i̱, ta nákiꞌin i̱ ñava̱ꞌa no̱o̱ o̱n vása ní‑kisa chiño i̱, ");
INSERT INTO mim_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ta, ¿nda̱chun ni̱‑chikaa̱ va̱ꞌa ún si̱ꞌún i̱ ini veꞌe no̱o̱ táꞌvi̱ si̱ꞌún? Ta ki̱vi̱ ndi̱kó i̱, nakiꞌin i̱ si̱ꞌún i̱ xíꞌin si̱ki̱ ña, níkúu”, káchí ta̱patrón. ");
INSERT INTO mim_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ta saá ni̱ka̱ꞌa̱n ta̱patrón xíꞌin ni̱vi na ndóo xíꞌin ra: “Kindaa ndó ndaꞌa̱ ra bolsa káꞌno si̱ꞌún, ta taxi ndó ña ndaꞌa̱ ta̱a ta̱ kómí u̱xu̱ bolsa náꞌno si̱ꞌún. ");
INSERT INTO mim_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ta ndiꞌi ni̱vi na va̱ꞌa xíni̱ kukomí si̱ꞌún, ta nayóꞌo nakiꞌin ka̱ na kua̱ꞌa̱ ka̱ si̱ꞌún. Ta ni̱vi na o̱n vása xíni̱ ndasaá va̱ꞌa kukomí na si̱ꞌún, ta̱nda̱ ñaloꞌo kómí na, nondaa ña ndaꞌa̱ nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ta ta̱mozo ta̱ o̱n vása kísa chiño va̱ꞌa, tava ndó ra ke̱ꞌe no̱o̱ naa ní, no̱o̱ kuaku ní ra ta xo̱ꞌvi̱ ní ra”, káchí ta̱patrón. Ta ndi̱ꞌi cuento loꞌo yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ta ki̱vi̱ ndikó i̱ ñoyívi yóꞌo, yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndikó i̱ xíꞌin ndiꞌi ñalivi ña yéꞌe, xíꞌin ndiꞌi naángel, ta saá koo i̱ no̱o̱ táyi̱ tón káꞌno tón to̱ꞌó no̱o̱ kaꞌnda chiño i̱. ");
INSERT INTO mim_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ta ni̱vi na kixi ndiꞌi saá xiiña ñoyívi yóꞌo kixaa̱ na nakutáꞌan na no̱o̱ i̱, ta nataꞌví i̱ nayóꞌo nda̱tán nátaꞌví ñii ta̱a ndikachi sa̱na̱ ra xíꞌin ti̱súꞌu̱ sa̱na̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nda̱tán yóo ñii ta̱a chíndoo ra tíndikachi sa̱na̱ ra no̱o̱ yóo ndaꞌa̱ kuaꞌá ra, ta títi̱súꞌu̱ sa̱na̱ ra chíndoo ra rí no̱o̱ yóo ndaꞌa̱ yitin ra, saá chindoo i̱ nani̱vi na va̱ꞌa no̱o̱ yóo ndaꞌa̱ kuaꞌá i̱ ta ni̱vi na o̱n váꞌa chindoo i̱ na no̱o̱ yóo ndaꞌa̱ yitin i̱. ");
INSERT INTO mim_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ta yi̱ꞌi̱, ta̱Rey, ka̱ꞌa̱n i̱ xíꞌin ni̱vi na ndóo no̱o̱ yóo ndaꞌa̱ kuaꞌá i̱: “Ndóꞌó kúu na nakiꞌin ñava̱ꞌa ndaꞌa̱ Yivá i̱. Vitin naꞌa ndó ki̱ꞌvi ndó no̱o̱ xáꞌnda chiño Ndios, saá chi nda̱ ñano̱ó ki̱vi̱ ki̱xáꞌá ñoyívi ndóꞌó kúu na chi̱tóni̱ ra nakiꞌin ndiꞌi ñava̱ꞌa ra. ");
INSERT INTO mim_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Chi ki̱vi̱ ni̱xiꞌi̱ i̱ so̱ko ta ndóꞌó ta̱xi ndó ña xi̱xi i̱. Ki̱vi̱ ni̱yi̱chi̱ i̱ takuií ndóꞌó ta̱xi ndó takuií xi̱ꞌi i̱. Ta ki̱vi̱ ni̱xi̱yo xíká i̱ no̱o̱ ñoo i̱, ta ndóꞌó ta̱xi ndó ñii xiiña no̱o̱ xi̱ndúꞌu̱ i̱ na̱kindée i̱. ");
INSERT INTO mim_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ki̱vi̱ o̱n ko̱ó tiko̱to̱ i̱ ní‑xiyo, ta ndóꞌó ta̱xi ndó tiko̱to̱ xi̱ndixin i̱. Ki̱vi̱ ndeé ní sa̱xo̱ꞌvi̱ kue̱ꞌe̱ yi̱ꞌi̱ ta ndóꞌó ni̱xaa̱ ndó ni̱ka̱ꞌa̱n ndó to̱ꞌon va̱ꞌa xíꞌin i̱. Ki̱vi̱ xi̱nakaa̱ i̱ ini veꞌe ka̱a ta ni̱xa̱ꞌa̱n ndó chi̱ndeé ndó yi̱ꞌi̱”, kachí i̱ xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ta saá ni̱vi na va̱ꞌa ini yóꞌo nda̱ka̱ to̱ꞌon na yi̱ꞌi̱, kachí na saá: “Tata, ¿ama xi̱ni ndi̱ yóꞌó ni̱xiꞌi̱ ún so̱ko ta ta̱xi ndi̱ ña xi̱xi ún? ¿Ama xi̱ni ndi̱ yóꞌó ni̱yi̱chi̱ ún takuií ta ta̱xi ndi̱ takuií xi̱ꞌi ún? ");
INSERT INTO mim_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ama ni̱xi̱yo xíká ún no̱o̱ ñoo ún ta ta̱xi ndi̱ ñii xiiña no̱o̱ xi̱ndúꞌu̱ ún na̱kindée ún? ¿Ama xi̱ni ndi̱ yóꞌó o̱n ko̱ó tiko̱to̱ ún ní‑xiyo ta ta̱xi ndi̱ tiko̱to̱ ndaꞌa̱ ún xi̱ndixin ún? ");
INSERT INTO mim_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ama xi̱ni ndi̱ sa̱xo̱ꞌvi̱ ní kue̱ꞌe̱ yóꞌó, án xi̱ni ndi̱ yóꞌó xi̱nakaa̱ ún ini veꞌe ka̱a ta ni̱xa̱ꞌa̱n ndi̱ chi̱ndeé ndi̱ yóꞌó?” ");
INSERT INTO mim_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ta yi̱ꞌi̱, ta̱Rey, ndakuii̱n i̱, ka̱ꞌa̱n i̱ xíꞌin na: “Ndixa káꞌa̱n i̱ xíꞌin ndó, ndiꞌi saá yichi̱ chi̱ndeé ndó ni̱vi nandáꞌví ní na ndíko̱n yi̱ꞌi̱, ndí yi̱ꞌi̱ kúu ta̱ chi̱ndeé ndó saá”, kachí i̱ xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Ta yi̱ꞌi̱, ta̱Rey, ka̱ꞌa̱n i̱ xíꞌin na ndóo no̱o̱ yóo ndaꞌa̱ yitin i̱: “Kutaꞌa ndó no̱o̱ i̱, ndóꞌó na ndíso chiꞌña. Kua̱ꞌa̱n ndó koꞌon ndó no̱o̱ xíxi̱ ñoꞌo̱ ña o̱n vása nda̱ꞌva̱ ndiꞌi saá ki̱vi̱, chi Ndios ki̱sa va̱ꞌa ra ñoꞌo̱ xíxi̱ yóꞌo ña xo̱ꞌvi̱ ní ñaníma̱ ndiva̱ꞌa káꞌno xíꞌin ndiꞌi inka̱ níma̱ ndiva̱ꞌa táꞌan mi̱i ña. ");
INSERT INTO mim_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Saá chi ki̱vi̱ ni̱xiꞌi̱ i̱ so̱ko ta ndóꞌó ni̱‑taxi ndó ña kuxu i̱. Ki̱vi̱ ni̱yi̱chi̱ i̱ takuií, ta ndóꞌó ni̱‑taxi ndó takuií koꞌo i̱. Ki̱vi̱ ni̱xi̱yo xíká i̱ no̱o̱ ñoo i̱, ta ndóꞌó ni̱‑taxi ndó ñii xiiña kandúꞌu̱ i̱ nakindée i̱. ");
INSERT INTO mim_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ki̱vi̱ o̱n ko̱ó tiko̱to̱ ní‑xiyo kundixin i̱, ta ndóꞌó ni̱‑taxi ndó tiko̱to̱ ndaꞌa̱ i̱. Ki̱vi̱ ndeé ní sa̱xo̱ꞌvi̱ kue̱ꞌe̱ yi̱ꞌi̱ án ki̱vi̱ xi̱nakaa̱ i̱ ini veꞌe ka̱a ta ndóꞌó ni̱‑xaꞌa̱n ndó chindeé ndó yi̱ꞌi̱”, kachí i̱ xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ta ni̱vi na o̱n váꞌa yóꞌo nda̱ka̱ to̱ꞌon na yi̱ꞌi̱, kachí na saá: “Tata, ¿ama xi̱ni ndi̱ yóꞌó ni̱xiꞌi̱ ún so̱ko? ¿Ama xi̱ni ndi̱ yóꞌó ni̱yi̱chi̱ ún takuií? ¿Ama xi̱ni ndi̱ yóꞌó ni̱xi̱yo xíká ún no̱o̱ ñoo ún? ¿Ama xi̱ni ndi̱ yóꞌó o̱n ko̱ó tiko̱to̱ ní‑xiyo kundixin ún? ¿Ama xi̱ni ndi̱ ndeé ní sa̱xo̱ꞌvi̱ kue̱ꞌe̱ yóꞌó?, ¿ama xi̱ni ndi̱ yóꞌó xi̱nakaa̱ ún ini veꞌe ka̱a, ta o̱n vása ní‑chindeé ndi̱ yóꞌó?” ");
INSERT INTO mim_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ta yi̱ꞌi̱ ndakuii̱n i̱, ka̱ꞌa̱n i̱ xíꞌin na: “Ndixa káꞌa̱n i̱ xíꞌin ndó, ndiꞌi saá yichi̱ ña o̱n vása ní‑chindeé ndó ni̱vi nandáꞌví ní na ndíko̱n yi̱ꞌi̱, ndí yi̱ꞌi̱ kúu ta̱ o̱n vása ní‑chindeé ndó saá”, kachí i̱ xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ta na o̱n váꞌa yóꞌo ko̱ꞌo̱n na no̱o̱ xo̱ꞌvi̱ ní na ndiꞌi saá ki̱vi̱ ña va̱xi, ta ni̱vi na va̱ꞌa ko̱ꞌo̱n na kutaku̱ na xíꞌin Ndios ndiꞌi saá ki̱vi̱ ña va̱xi ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ta ndi̱ꞌi sa̱náꞌa ta̱Jesús ndiꞌi to̱ꞌon yóꞌo ni̱vi, ta saá ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra, káchí ra: ");
INSERT INTO mim_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Xíni̱ ndó kúma̱ni̱ o̱vi̱ ki̱vi̱ ña to̱nda̱a ki̱vi̱ kana viko̱ Pascua. Ta nataxi na yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndaꞌa̱ ni̱vi na o̱n xi̱in koni yi̱ꞌi̱ ña katakaa̱ ndaa na yi̱ꞌi̱ ña kivi̱ i̱ ndaꞌa̱ tón cruz ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ta saá mi̱i ki̱vi̱ yóꞌo na sánáꞌa nda̱yí Ndios xíꞌin naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin nanáꞌno no̱o̱ nasu̱tu̱, na̱kutáꞌan ndiꞌi na yéꞌé veꞌe ta̱Caifás, ta ta̱Caifás yóꞌo kúu ta̱káꞌno no̱o̱ ndiꞌi nasu̱tu̱. ");
INSERT INTO mim_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ta ni̱ka̱ꞌa̱n táꞌan ndiꞌi nayóꞌo ndasaá koo kasa va̱ꞌa na kua̱chi vatá xa̱ꞌa̱ ta̱Jesús, ta tiin na ra ña kaꞌni ñaꞌá na. ");
INSERT INTO mim_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ta ni̱ka̱ꞌa̱n na, káchí na saá: ―O̱n kuchiño tiin yó ra ki̱vi̱ viko̱, ko̱to̱ koni ndiꞌi nani̱vi ñoo yóꞌo, ta si̱so̱ na nda̱ꞌyi na, ta kani táꞌan na, ta koo ní kua̱chi ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ta yóo ta̱Jesús ñoo Betania veꞌe ta̱Simón, ta̱ xi̱komí kue̱ꞌe̱ táꞌyí na̱ní ña lepra. ");
INSERT INTO mim_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tá yóo ta̱Jesús xíxi ra no̱o̱ mesa, ta ki̱xaa̱ yatin ñii ñaꞌa̱ níꞌi ñá ñii yu̱yu̱ ña ku̱va̱ꞌa xíꞌin yu̱u̱ na̱ní alabastro, ti̱xin ña ñóꞌo nduta̱ tá xáꞌan támi ní, ta nduta̱ yóꞌo kúu tá yáꞌví ní. Ta chi̱kaa̱ ndiꞌi ñá rá si̱ni̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ta naxíka xíꞌin ra xi̱ni na ñayóꞌo ta ni̱saa̱ ní na, ta ni̱ka̱ꞌa̱n na: ―¿Nda̱chun sa̱ndiꞌi ñaꞌa̱ yóꞌo xa̱ꞌa̱ nduta̱ yáꞌví ní? ");
INSERT INTO mim_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Va̱ꞌa ka̱ ná si̱kó ñá nduta̱ yóꞌo ta kua̱ꞌa̱ ní si̱ꞌún nakiꞌin ñá, níkúu, ta saá kuchiño chindeé ñá nandáꞌví ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ta xi̱ni̱ so̱ꞌo ta̱Jesús yukía̱ ni̱ka̱ꞌa̱n na, ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―¿Nda̱chun káꞌa̱n ndó sándiꞌi ndó ñáyóꞌo? Chi ñava̱ꞌa kúu ña ke̱ꞌé ñá xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ndiꞌi saá ki̱vi̱ yóo nandáꞌví xíꞌin ndó. Ta yi̱ꞌi̱, saloꞌo ní ka̱ ki̱vi̱ yóo i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Chi̱kaa̱ ñá nduta̱ tá xáꞌan támi si̱ni̱ i̱ ña ki̱sa tiꞌva ñá yi̱kí ko̱ñu i̱ ña ndu̱xu̱n ña. ");
INSERT INTO mim_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ndixa káꞌa̱n i̱ xíꞌin ndó, ndiꞌi saá xiiña ñoyívi yóꞌo no̱o̱ ka̱ꞌa̱n ndoso na to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ i̱, ndato̱ꞌon na xíꞌin ni̱vi yukía̱ ke̱ꞌé ñáyóꞌo. Ta saá nakáꞌán ni̱vi xa̱ꞌa̱ ñava̱ꞌa ke̱ꞌé ñá xíꞌin i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ta saá ta̱Judas Iscariote, ta̱ kúu ñii ta̱ u̱xu̱ o̱vi̱ xíka xíꞌin ta̱Jesús, ke̱e ra ni̱xa̱ꞌa̱n ra no̱o̱ nanáꞌno no̱o̱ nasu̱tu̱, ");
INSERT INTO mim_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ta ni̱nda̱ka̱ to̱ꞌon ra na: ―¿Ndasaá si̱ꞌún taxaꞌvi ndó yi̱ꞌi̱ tá nataxi i̱ ta̱Jesús ndaꞌa̱ ndó? ―káchí ra xíꞌin na. Ta saá ta̱xaꞌvi na ra o̱ko̱ u̱xu̱ si̱ꞌún ñaplata. ");
INSERT INTO mim_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ta̱nda̱ saá ki̱xáꞌá ndúkú ta̱Judas ndasaá koo nataxi ra ta̱Jesús ndaꞌa̱ na. ");
INSERT INTO mim_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ta ni̱to̱nda̱a ki̱vi̱ ki̱xáꞌá viko̱ xíxi najudío si̱ta̱ va̱ꞌa ña o̱n ko̱ó levadura kómí, ta naxíka xíꞌin ta̱Jesús ki̱xaa̱ na no̱o̱ ra, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá na: ―¿Míkía̱ kóni ún kasa ndivi ndi̱ ña kuxu yó viko̱ Pascua? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ta nda̱kuii̱n ta̱Jesús: ―Kua̱ꞌa̱n ndó, ta kua̱ꞌa̱n ki̱ꞌvi ndó ñoo Jerusalén, ta kua̱ꞌa̱n ndó veꞌe ñii ta̱a ta̱ xíni̱ táꞌan xíꞌin yó, ta ka̱ꞌa̱n ndó siꞌa xíꞌin ra: “Ta̱Maestro káchí ra ndí xa kíxaa̱ yatin ki̱vi̱ kasa ndivi ra chiño káꞌno. Ta veꞌe ún kóni ra kuxu ra viko̱ Pascua xíꞌin naxíka xíꞌin ra”, saá kachí ndó xíꞌin ta̱a ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ta naxíka xíꞌin ra ni̱xa̱ꞌa̱n na, ta ki̱sa ndivi na ña kuxu ra xíꞌin na viko̱ Pascua, nda̱tán xa̱ꞌnda chiño ta̱Jesús no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tá kua̱ꞌa̱n kuñoó, ta ki̱xaa̱ ta̱Jesús xíꞌin u̱xu̱ o̱vi̱ naxíka xíꞌin ra, ta xi̱kundo̱o na no̱o̱ mesa kuxu na. ");
INSERT INTO mim_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tá ndóo na xíxi na, ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, ñii ndóꞌó kúu ta̱a ta̱ si̱kó kuíꞌná yi̱ꞌi̱ ta nataxi ra yi̱ꞌi̱ ndaꞌa̱ ni̱vi na sáa̱ ini xíni yi̱ꞌi̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ta ndiꞌi nayóꞌo kúchuchú ní ini na, ta ñii ñii na ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ―Tata, ¿án yi̱ꞌi̱ kúu ta̱ káꞌa̱n ún xa̱ꞌa̱? ");
INSERT INTO mim_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ta nda̱kuii̱n ta̱Jesús, káchí ra xíꞌin na: ―Ñii ndóꞌó ta̱ sáchii si̱ta̱ va̱ꞌa ini ko̱ꞌo̱ xíꞌin i̱, ta̱yóꞌo kúu ta̱ si̱kó kuíꞌná yi̱ꞌi̱ no̱o̱ na sáa̱ ini xíni yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndixa xo̱ꞌvi̱ ní i̱ ta kivi̱ i̱, nda̱tán ni̱taa naprofeta xi̱na̱ꞌá. Ta, ¡ndáꞌví ní ta̱a ta̱ si̱kó kuíꞌná yi̱ꞌi̱ no̱o̱ na sáa̱ ini xíni yi̱ꞌi̱! Va̱ꞌa ka̱ níxi̱yo o̱n kaku ta̱yóꞌo, níkúu ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ta ta̱Judas, ta̱ kúu ta̱ si̱kó kuíꞌná ta̱Jesús no̱o̱ na sáa̱ ini xíni ñaꞌá, ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús: ―Maestro, ¿án yi̱ꞌi̱ kúu ta̱ káꞌa̱n ún xa̱ꞌa̱? Ta nda̱kuii̱n ta̱Jesús: ―Saá va, yóꞌó kúu ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tá xíxi ka̱ na, ta̱Jesús ki̱ꞌin ra si̱ta̱ va̱ꞌa, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios: ―Tata Yivá yó, táxaꞌvi ún chi ta̱xi ún si̱ta̱ va̱ꞌa kuxu ndi̱ ―káchí ra. Ta ta̱ꞌví ra si̱ta̱ va̱ꞌa, ta ta̱xi ra ña ndaꞌa̱ ñii ñii naxíka xíꞌin ra kuxu na. Ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Nakiꞌin ndó kuxu ndó si̱ta̱ va̱ꞌa yóꞌo, chi ñayóꞌo kúu yi̱kí ko̱ñu i̱. ");
INSERT INTO mim_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ta ki̱ꞌin ta̱Jesús ñii copa ña ñóꞌo vino, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios: ―Tata Yivá yó, táxaꞌvi ún chi ta̱xi ún nduta̱ koꞌo ndi̱ yóꞌo ―káchí ra. Ta ta̱xi ra copa ñóꞌo vino yóꞌo ndaꞌa̱ ñii ñii naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―Ndiꞌi ndó, koꞌo ndó táyóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Chi nduta̱ yóꞌo kúu ni̱i̱ i̱ ña kui̱ta̱. Ta xíꞌin ñayóꞌo Ndios chindúꞌu̱ ra pacto xa̱á ña ka̱ꞌa̱n ndasaá ndoo ndiꞌi kua̱chi nani̱vi, ta saá kuchiño kundo̱o va̱ꞌa na xíꞌin ra ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ndixa káꞌa̱n i̱ xíꞌin ndó, o̱n koꞌo ka̱ i̱ vino nda̱ kixaa̱ ki̱vi̱ nakutáꞌan yó no̱o̱ xáꞌnda chiño Yivá yó Ndios. Ta saá koꞌo i̱ távino xa̱á xíꞌin ndó ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ta ndi̱ꞌi xi̱ta na ñii yaa ña káꞌa̱n xa̱ꞌa̱ Ndios, ta ke̱e na kua̱ꞌa̱n na xi̱ki̱ tón Olivo. ");
INSERT INTO mim_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ñoó vitin ndiꞌi ndóꞌó sandakoo ndó yi̱ꞌi̱, chi saá kundivi to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá, ña káchí saá: “Satakuéꞌe̱ i̱ ta̱a ta̱ ndáa tíndikachi, ta tíndikachi yóꞌo kui̱ta̱ níꞌnó ndiꞌi rí”, ka̱chí Ndios. ");
INSERT INTO mim_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ta ki̱vi̱ nataku̱ i̱, ko̱ꞌo̱n siꞌna i̱ ña kundati i̱ ndóꞌó ñoo estado Galilea ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ta ta̱Pedro nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Tata, tá ndiꞌi ni̱vi sandakoo na yóꞌó, ta yi̱ꞌi̱ o̱n sandakoo i̱ yóꞌó. ");
INSERT INTO mim_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Ndixa káꞌa̱n i̱ xíꞌin ún, ta̱ꞌán ka̱ kana nduxú chée ñoó vitin, ta xa u̱ni̱ yichi̱ ni̱ka̱ꞌa̱n ún xíꞌin ni̱vi ña o̱n vása xíni̱ ún yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ta ni̱ka̱ꞌa̱n ta̱Pedro xíꞌin ra: ―Tata, ta̱nda̱ xíni̱ ñóꞌó kivi̱ i̱ xíꞌin ún, ta nda̱ ñii yichi̱ o̱n vása ka̱ꞌa̱n i̱ o̱n vása xíni̱ i̱ yóꞌó ―káchí ta̱Pedro. Ta ñii káchí saá ni̱ka̱ꞌa̱n ndiꞌi ka̱ naxíka xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ta ta̱Jesús kua̱ꞌa̱n ra, ta naxíka xíꞌin ra kua̱ꞌa̱n na xíꞌin ra, ta ni̱xaa̱ na ñii no̱o̱ na̱ní Getsemaní, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Kundo̱o ndó yóꞌo ta ná ko̱ꞌo̱n i̱ ka̱ꞌa̱n i̱ xíꞌin Ndios ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Pedro, ta xíꞌin o̱vi̱ sa̱ꞌya ta̱Zebedeo, kua̱ꞌa̱n na xíꞌin ra ta ni̱xaa̱ na, ta ki̱xáꞌá ta̱Jesús kúchuchú ní ini ra ta ndíꞌi ní ini ra. ");
INSERT INTO mim_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ta ni̱ka̱ꞌa̱n ra xíꞌin u̱ni̱ ta̱yóꞌo: ―Ndeé ní kúchuchú ini i̱ a̱nda̱ ñii kóni ña kivi̱ i̱. Kundati ndó yóꞌo ta kundito ndó, o̱n ku̱su̱n ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ta ta̱Jesús ke̱e ra kua̱ꞌa̱n ra ñii xiiña xíká ka̱ loꞌo, ta xi̱kuxítí ra ta xi̱kundee ra nda̱ ni̱to̱nda̱a ta̱ꞌya̱ ra no̱o̱ ñoꞌo̱, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios, káchí ra saá: ―Tata Yivá mi̱i i̱, tá kuchiño, ta o̱n taxi ún ña xo̱ꞌvi̱ ní i̱ yóꞌo. Ta saá ni, o̱n kundivi ña kóni mi̱i i̱, ta va̱ꞌa ka̱ ná kundivi ña kóni mi̱i ún ―káchí ta̱Jesús xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ta saá na̱kundichi ra ta ndi̱kó ra ki̱xaa̱ ra no̱o̱ ndóo u̱ni̱ naxíka xíꞌin ra. Ta ndiꞌi nayóꞌo kísi̱n na. Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ta̱Pedro: ―¿Án o̱n vása kúchiño ndó kundito ndó xíꞌin i̱ vará ñii hora? ");
INSERT INTO mim_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","O̱n ku̱su̱n ka̱ ndó ta kundito ndó ka̱ꞌa̱n ndó xíꞌin Ndios ña o̱n nakava ndó kua̱chi. Ndóꞌó yóo ini ndó keꞌé ndó ñava̱ꞌa, ta o̱n kúchiño keꞌé ndó ñava̱ꞌa yóꞌo xíꞌin ndee̱ mi̱i ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ta yichi̱ o̱vi̱ tuku ndi̱kó ta̱Jesús kua̱ꞌa̱n ra ka̱ꞌa̱n ra xíꞌin Ndios, káchí ra saá: ―Tata Yivá mi̱i i̱, tá xíni̱ ñóꞌó xo̱ꞌvi̱ i̱ ña yo̱ꞌvi̱ ní yóꞌo, ta va̱ꞌa ka̱ saá ná koo ña kóni mi̱i ún ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ta ndi̱kó tuku ra ki̱xaa̱ ra no̱o̱ ndóo naxíka xíꞌin ra, ta na̱níꞌi ra na kísi̱n na, saá chi ndeé ní xíꞌi̱ na maꞌná. ");
INSERT INTO mim_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ta yichi̱ u̱ni̱ ndi̱kó tuku ra kua̱ꞌa̱n ra, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios nda̱tán yóo to̱ꞌon ña siꞌna ni̱ka̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ta tuku ndi̱kó ra ki̱xaa̱ ra no̱o̱ naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Án va̱ꞌa ku̱su̱n ka̱ ndó ta nakindée ka̱ ndó? Koto ndó, xa ni̱to̱nda̱a hora ña nataxi na yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndaꞌa̱ ni̱vi na o̱n váꞌa. ");
INSERT INTO mim_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ndakoo ndó, ná koꞌyo̱. Ta koto ndó, yóꞌo va̱xi ta̱ nataxi yi̱ꞌi̱ ndaꞌa̱ nani̱vi na sáa̱ ini xíni yi̱ꞌi̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tá ta̱ꞌán ka̱ ndiꞌi ka̱ꞌa̱n ta̱Jesús xíꞌin na, ta ki̱xaa̱ ta̱Judas ta̱ kúu ñii ta̱ u̱xu̱ o̱vi̱ xíka xíꞌin ta̱Jesús. Ta ki̱xaa̱ kua̱ꞌa̱ ní ni̱vi xíꞌin ra, ta níꞌi na espada xíꞌin yito̱n. Naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ xa ti̱ꞌví na ni̱vi yóꞌo ña tiin na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ta ta̱Judas xa siꞌna ni̱ka̱ꞌa̱n ra xíꞌin na ndasaá nakoni na ta̱Jesús, káchí ra siꞌa: ―Ta̱a ta̱ chindeé i̱ xíꞌin ña chi̱to i̱ no̱o̱ kúu ta̱Jesús. Ta tiin ndó ra ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ta saá ni̱to̱nda̱a yatin ra no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n ra: ―Kuaꞌa, Tata Maestro ―káchí ra. Ta ni̱chi̱to ra no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Tata, kasa ndivi ún ñachiño va̱xi ún. Ta saá ni̱vi na yóo xíꞌin ta̱Judas ni̱to̱nda̱a yatin na no̱o̱ ta̱Jesús ta ti̱in na ra. ");
INSERT INTO mim_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ta ñii ta̱xíka xíꞌin ta̱Jesús ta̱va ra espada, ta ka̱ndoso va̱ꞌa ra ñii so̱ꞌo ta̱ kísa chiño no̱o̱ ta̱káꞌno no̱o̱ nasu̱tu̱. ");
INSERT INTO mim_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱xíka xíꞌin ra yóꞌo: ―Taxi va̱ꞌa ún espada ún no̱o̱ nákaa̱ va̱ꞌa ña, saá chi ndiꞌi na xáꞌni xíꞌin espada ñii ki̱ꞌva saá tuku kivi̱ nayóꞌo xíꞌin espada. ");
INSERT INTO mim_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Án o̱n vása kúnda̱a̱ ini ún kúchiño ndukú i̱ no̱o̱ Yivá i̱ ta tikáꞌan kuiti tiꞌví ra kua̱ꞌa̱ ní mil naángel kixaa̱ na chindeé na yi̱ꞌi̱? ");
INSERT INTO mim_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Táná tiꞌví ra naángel, ta o̱n vása kuchiño kasa ndivi i̱ to̱ꞌon Ndios ña káchí xíni̱ ñóꞌó kundoꞌo i̱ ñayóꞌo ―káchí ra xíꞌin ta̱xíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin inka̱ ni̱vi: ―¿Án xáni si̱ni̱ ndó ta̱kuíꞌná kúu i̱? ¿Nda̱chun va̱xi ndó no̱o̱ i̱ níꞌi ndó espada xíꞌin yito̱n ña tiin ndó yi̱ꞌi̱? Ta yi̱ꞌi̱, ndiꞌi saá ki̱vi̱ ni̱xi̱yo i̱ sánáꞌa i̱ ni̱vi veꞌe ño̱ꞌo káꞌno, ta ni̱‑tiin ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ta ndiꞌi ñayóꞌo kundoꞌo i̱ vitin, chi saá xíni̱ ñóꞌó kundivi to̱ꞌon Ndios ña ni̱taa naprofeta ―káchí ta̱Jesús. Ta ndiꞌi naxíka xíꞌin ra sa̱ndakoo na ta̱Jesús, ta xi̱no na kua̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ta saá ni̱vi na ti̱in ta̱Jesús, ni̱xaa̱ ra xíꞌin na veꞌe ta̱Caifás, ta̱ kúu ta̱káꞌno no̱o̱ nasu̱tu̱. Ta veꞌe ta̱yóꞌo xa na̱kutáꞌan ndiꞌi naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin na sánáꞌa nda̱yí Ndios. ");
INSERT INTO mim_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ta ta̱Pedro ñii xíká ndíko̱n ra kua̱ꞌa̱n ra sa̱ta̱ ta̱Jesús a̱nda̱ ni̱xaa̱ ra veꞌe ta̱su̱tu̱ káꞌno. Ta xi̱koo ra xíꞌin napolicía ke̱ꞌe veꞌe ta̱su̱tu̱ yóꞌo ña koto ra yukía̱ kundoꞌo ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ta naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ xíꞌin ndiꞌi inka̱ nachiño na̱ní na Junta Suprema nándukú na ni̱vi na ka̱ꞌa̱n to̱ꞌon vatá ña kuva̱ꞌa kua̱chi xa̱ꞌa̱ ta̱Jesús, ta saá kuchiño nataxi na ra ndaꞌa̱ ni̱vi ña kaꞌni na ra. ");
INSERT INTO mim_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Vará kua̱ꞌa̱ ní ni̱vi ki̱xi na ni̱ka̱ꞌa̱n na ñavatá xa̱ꞌa̱ ta̱Jesús, ta o̱n vása ní‑naníꞌi na kua̱chi ra ña kaꞌni na ra. Ta sondi̱ꞌi ki̱xaa̱ o̱vi̱ ta̱a ta̱ vatá yuꞌu̱, ");
INSERT INTO mim_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ta ni̱ka̱ꞌa̱n nayóꞌo saá xa̱ꞌa̱ ta̱Jesús: ―Ta̱yóꞌo ni̱ka̱ꞌa̱n ra, ka̱chí ra: “Yi̱ꞌi̱ kúchiño i̱ sandiꞌi i̱ xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno, ta ti̱xin ña u̱ni̱ ki̱vi̱ tuku kasa va̱ꞌa i̱ ña”, ka̱chí ta̱Jesús ―káchí o̱vi̱ ta̱a yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ta saá ta̱káꞌno no̱o̱ nasu̱tu̱ na̱kundichi ra, ta ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús: ―¿Án o̱n vása ndákuii̱n ún yuꞌu̱ na? ¿Yukía̱ kachí ún xa̱ꞌa̱ to̱ꞌon ña káꞌa̱n nayóꞌo xa̱ꞌa̱ ún? ");
INSERT INTO mim_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ta ta̱Jesús tási̱ín yóo ra, o̱n vása ní‑ndakuii̱n ra. Ta tuku ni̱ka̱ꞌa̱n ta̱káꞌno no̱o̱ nasu̱tu̱ xíꞌin ra: ―Ta xáꞌnda chiño i̱ no̱o̱ ún chináꞌa ún Ndios ta̱táku̱, ta ka̱ꞌa̱n ún ñanda̱a̱ xíꞌin ndi̱, ¿án Cristo ta̱ ti̱ꞌví Ndios kúu ún? ¿Án ndixa Sa̱ꞌya Ndios kúu ún? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ta nda̱kuii̱n ta̱Jesús: ―Saá va, mi̱i ún ni̱ka̱ꞌa̱n. Ta yi̱ꞌi̱ tuku káꞌa̱n i̱ xíꞌin ndó, ki̱vi̱ ña va̱xi koto ndó yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, xa yóo i̱ no̱o̱ táyi̱ tón yóo sii̱n kuaꞌá Ndios, ta̱a ta̱ kómí ndiꞌi ndee̱. Ta koni ndó yi̱ꞌi̱ ndikó i̱ ñoyívi yóꞌo, ta va̱xi i̱ ma̱ꞌñó vi̱ko̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ta ta̱káꞌno no̱o̱ nasu̱tu̱ ndi̱ꞌi xi̱ni̱ so̱ꞌo ra ñayóꞌo, ta ni̱saa̱ ní ra, ta nda̱ta ra tiko̱to̱ mi̱i ra, ta ni̱ka̱ꞌa̱n ra: ―¡Ta̱yóꞌo kándiva̱ꞌa kini ra xíꞌin Ndios! O̱n vása xíni̱ ñóꞌó ka̱ yó inka̱ ni̱vi taxi na kua̱chi xa̱ꞌa̱ ra. Ndóꞌó xi̱ni̱ so̱ꞌo ndó ña o̱n váꞌa ni̱ka̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Yukía̱ xáni ini ndó keꞌé yó xíꞌin ta̱yóꞌo? ―káchí ra xíꞌin nanáꞌno na kúu nachiño. Ta nda̱kuii̱n nayóꞌo: ―Yóo kua̱chi ra. Ta xíni̱ ñóꞌó kivi̱ ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ta ki̱xáꞌá na kúndaa na tási̱i yuꞌu̱ na no̱o̱ ra, ta káni na ra xíꞌin yi̱kí ndaꞌa̱ na, ta inka̱ na xíꞌin xa̱ꞌnda̱ ndaꞌa̱ na káni na no̱o̱ ra, ");
INSERT INTO mim_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ta káchí na saá xíꞌin ra: ―Tá Cristo kúu ún, ta ka̱ꞌa̱n ún xíꞌin ndi̱, ¿yukú ndi̱ ka̱ni yóꞌó? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ta yóo ta̱Pedro ke̱ꞌe veꞌe ta̱káꞌno no̱o̱ nasu̱tu̱, ta ki̱xaa̱ ñii ñaꞌa̱ ñá kísa chiño no̱o̱ naveꞌe yóꞌo, ta ni̱ka̱ꞌa̱n ñá xíꞌin ta̱Pedro, káchí ñá saá: ―Saá tuku yóꞌó kúu ún ñii ta̱ ni̱xika xíꞌin ta̱Jesús, ta̱ ki̱xi estado Galilea ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ta no̱o̱ ndiꞌi na ndóo yóꞌo ta̱Pedro ni̱ka̱ꞌa̱n ra, káchí ra saá: ―O̱n vása kúnda̱a̱ ini i̱ yukía̱ káꞌa̱n ún xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ta saá ke̱e ra yéꞌé ke̱ꞌe veꞌe yóꞌo, ta yóo inka̱ ñaꞌa̱ ñá kísa chiño no̱o̱ naveꞌe yóꞌo, ta xíni ñá ta̱Pedro, ta ni̱ka̱ꞌa̱n ñá xíꞌin nani̱vi, káchí ñá saá: ―Ta̱yóꞌo kúu ñii ta̱ ni̱xika xíꞌin ta̱Jesús, ta̱ ki̱xi ñoo Nazaret ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ta ta̱Pedro tuku ni̱ka̱ꞌa̱n ra nda̱ chi̱náꞌa ra Ndios ña káchí ra saá: ―O̱n vása xíni̱ i̱ ta̱kaa̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ta ni̱yaꞌa ñii káni̱ loꞌo, ta nani̱vi yíta yóꞌo ni̱to̱nda̱a yatin na no̱o̱ ta̱Pedro, ta ni̱ka̱ꞌa̱n na xíꞌin ra, káchí na saá: ―Ndixa yóꞌó kúu ún ñii ta̱táꞌan ta̱Jesús, chi xíꞌin to̱ꞌon ña káꞌa̱n ún kúnda̱a̱ ini ndi̱ ke̱e ún estado Galilea ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ta ki̱xáꞌá ta̱Pedro xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Xa ni̱ka̱ꞌa̱n i̱ xíꞌin ndó, o̱n vása xíni̱ i̱ ta̱kaa̱. ¡Ndios ná saxo̱ꞌvi̱ ra yi̱ꞌi̱ tá ñavatá káꞌa̱n i̱! ―káchí ra. Ta xa̱ndi̱ko̱n ka̱na ñii nduxú chée. ");
INSERT INTO mim_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ta saá na̱káꞌán ta̱Pedro to̱ꞌon ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: “Ta̱ꞌán ka̱ kana ñii nduxú chée ta xa u̱ni̱ yichi̱ ni̱ka̱ꞌa̱n ún xíꞌin ni̱vi ndí o̱n vása xíni̱ ún yi̱ꞌi̱.” Ta ke̱e ta̱Pedro ke̱ꞌe, ta ndeé ní xáku ra xíꞌin ndinoꞌo ini ra. ");
INSERT INTO mim_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ta ni̱ti̱vi inka̱ ki̱vi̱ ta ndiꞌi naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ na̱kutáꞌan na ta na̱koo yuꞌú na ña kaꞌni na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ta saá ka̱tón na ra, ta kua̱ꞌa̱n ra xíꞌin na, ta ni̱xaa̱ na na̱taxi na ra ndaꞌa̱ ta̱gobernador Poncio Pilato. ");
INSERT INTO mim_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ta ta̱Judas ta̱ na̱taxi ta̱Jesús ndaꞌa̱ nanáꞌno no̱o̱ nasu̱tu̱, xi̱ni̱ ra ndí chi̱kaa̱ ini nayóꞌo kaꞌni na ta̱Jesús, ta kúchuchú ní ini ra ta ndi̱kó ini ra xa̱ꞌa̱ ñayóꞌo, ta sa̱ndikó ra o̱ko̱ u̱xu̱ si̱ꞌún ñaplata ndaꞌa̱ naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin nanáꞌno no̱o̱ nasu̱tu̱. ");
INSERT INTO mim_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ta ni̱ka̱ꞌa̱n ta̱Judas xíꞌin na, káchí ra saá: ―Ni̱ki̱ꞌvi i̱ kua̱chi na̱taxi i̱ ndaꞌa̱ ndó ta̱a ta̱ va̱ꞌa ta̱ o̱n ko̱ó kua̱chi kómí, ña kaꞌni ndó ra. Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na xíꞌin ta̱Judas: ―O̱n vása ndíꞌi ini ndi̱ xa̱ꞌa̱ ña ke̱ꞌé ún. O̱n si̱ví kua̱chi mi̱i ndi̱ kía̱, kua̱chi mi̱i ún kía̱ ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ta saá ta̱Judas ni̱xa̱ꞌa̱n ra sa̱kana ra si̱ꞌún ñaplata ini veꞌe ño̱ꞌo káꞌno, ta ke̱e ra kua̱ꞌa̱n ra. Ta ni̱xaa̱ ra ñii xiiña ta sa̱kuáꞌna xíꞌin mi̱i ra. ");
INSERT INTO mim_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ta nanáꞌno no̱o̱ nasu̱tu̱ na̱kaya na si̱ꞌún ñaplata yóꞌo, ta ni̱ka̱ꞌa̱n na, káchí na saá: ―O̱n ki̱ví taan yó si̱ꞌún yóꞌo ini caja veꞌe ño̱ꞌo káꞌno no̱o̱ ñóꞌo ña sóko̱ nani̱vi, chi si̱ꞌún ña cha̱ꞌvi yó xa̱ꞌa̱ ña kivi̱ ñii ta̱a kía̱ ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ta saá na̱koo yuꞌú na, ta sa̱ta na xíꞌin si̱ꞌún yóꞌo ñii ñoꞌo̱ na̱ní “Ñoꞌo̱ ta̱ kísa chiño xíꞌin ñoꞌo̱ kisín”, ta ta̱xi na ña ndaꞌa̱ ni̱vi na ke̱e inka̱ ñoo ña va̱ꞌa ndu̱xu̱n natáꞌan na ki̱vi̱ ni̱xiꞌi̱ na. ");
INSERT INTO mim_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ta saá sákunaní na ñoꞌo̱ yóꞌo “Ñoꞌo̱ Ni̱i̱” a̱nda̱ ki̱vi̱ vitin. ");
INSERT INTO mim_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ta ku̱ndivi ña ni̱ka̱ꞌa̱n ta̱profeta Jeremías xi̱na̱ꞌá, ka̱chí ra saá: “Na̱kiꞌin na o̱ko̱ u̱xu̱ si̱ꞌún ñaplata, ña ndáya̱ꞌví ña kivi̱ ra, ñayóꞌo kúu yaꞌvi chi̱nóo naIsrael, ");
INSERT INTO mim_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ta xíꞌin si̱ꞌún yóꞌo sa̱ta na ‘Ñoꞌo̱ ta̱ kísa chiño xíꞌin ñoꞌo̱ kisín’, nda̱tán yóo ña ni̱ka̱ꞌa̱n Ndios xíꞌin i̱”, ka̱chí ta̱profeta. ");
INSERT INTO mim_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ta ñíndichi ta̱Jesús no̱o̱ ta̱gobernador Pilato, ta ta̱yóꞌo ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús, káchí ra xíꞌin ra: ―¿Án ndixa yóꞌó kúu ún Rey no̱o̱ najudío? ―káchí ra. Ta nda̱kuii̱n ta̱Jesús: ―To̱ꞌon mi̱i ún káchí yi̱ꞌi̱ kúu ta̱rey. ");
INSERT INTO mim_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ta naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ ta̱xi na kua̱chi xa̱ꞌa̱ ta̱Jesús no̱o̱ ta̱Pilato, ta ta̱Jesús nda̱ ñii to̱ꞌon o̱n vása ní‑ndakuii̱n ra no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ta saá ta̱Pilato ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús: ―¿Án o̱n vása xíni̱ so̱ꞌo ún ndiꞌi ña káꞌa̱n na xa̱ꞌa̱ ún? ");
INSERT INTO mim_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ta ta̱Jesús nda̱ ñii to̱ꞌon ni̱‑xiin ra ndakuii̱n ra. Ta na̱kaꞌnda ní ini ta̱Pilato xa̱ꞌa̱ ñayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ñii ñii viko̱ Pascua ta̱gobernador sáña ra ñii ta̱ nákaa̱ ini veꞌe ka̱a ko̱ꞌo̱n ndíka̱ ra. Ta najudío káxin na yu kúu ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ta yóo ñii ta̱ kánóo ní to̱ꞌon xa̱ꞌa̱ ta nákaa̱ ra ini veꞌe ka̱a, na̱ní ra Barrabás. ");
INSERT INTO mim_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ta na̱kutáꞌan kua̱ꞌa̱ ní ni̱vi no̱o̱ ta̱gobernador, ta ta̱Pilato ni̱nda̱ka̱ to̱ꞌon ra na, káchí ra saá: ―¿Yukú ta̱a kóni ndó saña i̱ ko̱ꞌo̱n ndíka̱? ¿Án saña i̱ ta̱Barrabás? ¿Án saña i̱ ta̱Jesús, ta̱a ta̱ sákunaní ni̱vi Cristo? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Saá chi ku̱nda̱a̱ ini ta̱Pilato ndí na kísa kuíni̱ ini xíni ta̱Jesús kúu na, ña̱kán na̱taxi na ra ndaꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ta ta̱Pilato yóo ra no̱o̱ táyi̱ no̱o̱ kísa nani ra xa̱ꞌa̱ kua̱chi, ta ñásíꞌí ra ti̱ꞌví ñá ña ndato̱ꞌon ñá xíꞌin ra: “O̱n kasa nani ka̱ ún xa̱ꞌa̱ kua̱chi ta̱yóꞌo, saá chi ta̱a ta̱ o̱n ko̱ó kua̱chi kúu ra, chi ñoó ndiveꞌe kini ní ni̱xa̱ní i̱ xa̱ꞌa̱ ra, ta ndíꞌi ní ini i̱”, káchí ñá. ");
INSERT INTO mim_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ta naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ chúꞌu na ni̱vi ña ndukú na ko̱ꞌo̱n ndíka̱ ta̱Barrabás, ta ndukú na ña kivi̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ta ta̱gobernador tuku ni̱nda̱ka̱ to̱ꞌon ra na: ―¿Yukú ta̱ o̱vi̱ yóꞌo kóni ndó saña i̱ ko̱ꞌo̱n ndíka̱? ―káchí ta̱Pilato xíꞌin na. Ta nda̱kuii̱n na: ―Saña ún ta̱Barrabás ko̱ꞌo̱n ndíka̱ ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ta ta̱Pilato ni̱nda̱ka̱ to̱ꞌon tuku ra na: ―¿Ta yukía̱ koo ta̱Jesús, ta̱a ta̱ na̱ní Cristo? ―káchí ta̱Pilato. Ta ndiꞌi na nda̱kuii̱n na, káchí na saá: ―¡Ná kivi̱ ra! ¡Katakaa̱ ndaa ún ra ndaꞌa̱ tón cruz! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ta saá tuku ni̱nda̱ka̱ to̱ꞌon ta̱Pilato na: ―¿Yu kúu kua̱chi ni̱ki̱ꞌvi ra? Ta ndeé ka̱ ni̱ka̱ꞌa̱n nayóꞌo, káchí na saá: ―¡Katakaa̱ ndaa ún ra ndaꞌa̱ tón cruz! ");
INSERT INTO mim_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ta ku̱nda̱a̱ ini ta̱Pilato o̱n vása xi̱in ka̱ na chikaa̱ so̱ꞌo na to̱ꞌon ra, ta ki̱xáꞌá na ndeé ka̱ ni̱si̱so̱ na. Ta xa̱ꞌnda chiño ra no̱o̱ na kísa chiño xíꞌin ra taxi na takuií ndaꞌa̱ ra, ta saá nda̱ꞌá ra no̱o̱ nani̱vi, káchí ra saá: ―Yi̱ꞌi̱ o̱n vása kuiso i̱ kua̱chi xa̱ꞌa̱ ña kivi̱ ta̱va̱ꞌa yóꞌo. Mi̱i ndó kuiso kua̱chi xa̱ꞌa̱ ña kivi̱ ra ―káchí ta̱gobernador xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ta ndiꞌi ni̱vi nda̱kuii̱n na, káchí na saá: ―¡Mi̱i ndi̱ xíꞌin sa̱ꞌya ndi̱ kuiso ndi̱ kua̱chi xa̱ꞌa̱ ña kivi̱ ta̱yóꞌo! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ta saá ta̱Pilato sa̱ña ra ta̱Barrabás. Ta xa̱ꞌnda chiño ra no̱o̱ natropa ña kani na ta̱Jesús xíꞌin kuártá ña nóꞌni ka̱a si̱i̱n no̱o̱, ta katakaa̱ ndaa na ra ndaꞌa̱ tón cruz. ");
INSERT INTO mim_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ta natropa ta̱gobernador, kua̱ꞌa̱n ta̱Jesús xíꞌin na veꞌe chiño káꞌno, ta ni̱xaa̱ na ta na̱kaya na ndiꞌi ka̱ natropa, ta xi̱no nduu ndiꞌi na ra. ");
INSERT INTO mim_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ta ki̱ndaa na ndiꞌi tiko̱to̱ ndíxin ta̱Jesús ta sa̱kundixin na ra ñii tiko̱to̱ kuáꞌá, nda̱tán yóo tiko̱to̱ ndíxin ta̱rey, ");
INSERT INTO mim_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ta ki̱sa va̱ꞌa na ñii corona ñiño̱ ta chi̱nóo na ña si̱ni̱ ra. Ta ta̱xi na ndaꞌa̱ ra ña tiin ra ñii yito̱n xíꞌin ndaꞌa̱ kuaꞌá ra, ta xi̱kuxítí na no̱o̱ ra ña kúsiki na ra, ta xáku̱ ndaa na ra, káꞌa̱n na siꞌa xíꞌin ra: ―¡Ná koo va̱ꞌa ta̱Rey no̱o̱ najudío! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ta ku̱ndaa na tási̱i yuꞌu̱ na no̱o̱ ra, ta tón yito̱n ta̱xi na ndaꞌa̱ ra tuku ki̱ndaa na nó, ta su̱ku na nó si̱ni̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ta ndiꞌi na kúsiki na ra ta xáku̱ ndaa na ra, ta saá ki̱ndaa na tiko̱to̱ kuáꞌá ndíxin ra ta tuku sa̱kundixin na ra tiko̱to̱ mi̱i ra. Ta kua̱ꞌa̱n ra xíꞌin na ña katakaa̱ ndaa na ra ndaꞌa̱ tón cruz. ");
INSERT INTO mim_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ta ke̱e natropa, ta kua̱ꞌa̱n ta̱Jesús xíꞌin na, ta na̱kutáꞌan na xíꞌin ñii ta̱a ta̱ ki̱xi ñoo Cirene, na̱ní ra Simón, ta natropa ki̱sa ndu̱xa̱ na xíꞌin ta̱yóꞌo ña kuiso ra tón cruz ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ta ni̱xaa̱ na ñii xiiña na̱ní ña Gólgota, ña kóni kachí Leke Si̱ni̱ Ndi̱í. ");
INSERT INTO mim_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ta natropa ta̱xi na vino tá na̱sa̱ka̱ xíꞌin nduta̱ yo̱va̱ ní koꞌo ra, ta ta̱Jesús xi̱to ndoso ra loꞌo nduta̱ yóꞌo, ta ni̱‑xiin ra koꞌo ra rá. ");
INSERT INTO mim_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ta saá ka̱takaa̱ ndaa na ra ndaꞌa̱ tón cruz, ta natropa na̱taꞌví na tiko̱to̱ ra. Chi̱kaa̱ na ndati̱ ña koto na yukú ñii ñii nayóꞌo nakiꞌin ñii ñii loꞌo tiko̱to̱ ta̱Jesús. Ta saá ku̱ndivi ña ni̱taa ta̱profeta xi̱na̱ꞌá xa̱ꞌa̱ ta̱Jesús, ka̱chí ra ndí taꞌví na tiko̱to̱ ra ta chikaa̱ na ndati̱ xa̱ꞌa̱ tiko̱to̱ ndíxin ni̱no ra, saá ni̱taa ra xa̱ꞌa̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ta xi̱kundo̱o na ndáa na ra. ");
INSERT INTO mim_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ta chi̱nóo kútu̱ na ñii tón vi̱ti̱ loꞌo si̱ni̱ tón cruz, ta no̱o̱ tón vi̱ti̱ yóꞌo na̱ka̱ꞌyi̱ to̱ꞌon ña káꞌa̱n xa̱ꞌa̱ kua̱chi ra, ta káchí ña saá: “Ta̱yóꞌo kúu ta̱Rey no̱o̱ najudío.” ");
INSERT INTO mim_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ta ka̱takaa̱ ndaa na o̱vi̱ ta̱kuíꞌná sii̱n ta̱Jesús, ñii ta̱kuíꞌná tákaa̱ ndaa ndaꞌa̱ tón cruz tón ñíndichi sii̱n kuaꞌá ra, ta inka̱ ra tákaa̱ ndaa ndaꞌa̱ tón cruz tón ñíndichi sii̱n yitin ra. ");
INSERT INTO mim_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ta nani̱vi yáꞌa yichi̱ no̱o̱ tákaa̱ ndaa ta̱Jesús kándiva̱ꞌa ní na xíꞌin ra, ta káva na si̱ni̱ na, ");
INSERT INTO mim_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","káchí na saá xíꞌin ra: ―Yóꞌó kúu ta̱a ta̱ ni̱ka̱ꞌa̱n: “Yi̱ꞌi̱ sandiꞌi i̱ xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno, ta ti̱xin ña u̱ni̱ ki̱vi̱ tuku kasa va̱ꞌa i̱ ña”, ka̱chí ún, ta vitin, ¡saka̱ku xíꞌin mi̱i ún! Tá ndixa Sa̱ꞌya Ndios kúu ún, ta saá, ¡sanoo xíꞌin mi̱i ún ndaꞌa̱ tón cruz! ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ta ñii ki̱ꞌva saá nafariseo xíꞌin na sánáꞌa nda̱yí Ndios xíꞌin naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ kúsiki na ra ta xáku̱ ndaa na ra, káꞌa̱n na xíꞌin ra: ");
INSERT INTO mim_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ta̱yóꞌo sa̱ka̱ku ra inka̱ ni̱vi, ta o̱n vása ki̱ví saka̱ku xíꞌin mi̱i ra vitin. Tá ndixa kúu ra ta̱Rey ñoo yó Israel, ta ná sanoo xíꞌin mi̱i ra ndaꞌa̱ tón cruz vitin, ta saá kandixa yó ra. ");
INSERT INTO mim_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ta ta̱yóꞌo ni̱ka̱ꞌa̱n ra ndáa ini ra Ndios. Tá ndixa Ndios kíꞌvi ini ra xíni ra ta̱yóꞌo, ta Ndios ná saka̱ku ñaꞌá ra vitin, chi ni̱ka̱ꞌa̱n ta̱yóꞌo: “Yi̱ꞌi̱ kúu Sa̱ꞌya Ndios”, ka̱chí ra ―saá káꞌa̱n na, xáku̱ ndaa na ra. ");
INSERT INTO mim_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ta ñii ki̱ꞌva saá o̱vi̱ ta̱kuíꞌná tákaa̱ ndaa sii̱n ra kúsiki ñaꞌá ra ta kándiva̱ꞌa ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ta ni̱to̱nda̱a ka̱a u̱xu̱ o̱vi̱ ma̱ꞌñó ndiví, ta ki̱xáꞌá kúnaa ndiꞌi ñoyívi a̱nda̱ ka̱a u̱ni̱ xikuaa. ");
INSERT INTO mim_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ta ka̱a u̱ni̱ kúu ña, ta saá ndeé va̱ꞌa ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá: ―Elí, Elí, ¿lama sabactani? ―káchí ta̱Jesús. To̱ꞌon yóꞌo káchí ña saá: Tata Yivá mi̱i i̱, Tata Yivá mi̱i i̱, ¿nda̱chun sa̱ndakoo ún yi̱ꞌi̱?, káchí ña. ");
INSERT INTO mim_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ta sava ni̱vi na yíta yatin yóꞌo, xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ra, ta káchí na saá: ―Ta̱yóꞌo kána ra ta̱profeta Elías ña chindeé ñaꞌá ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ta xa̱ndi̱ko̱n ñii ta̱yóꞌo xi̱no ra kua̱ꞌa̱n ra, ta sa̱chii ra ñii tiko̱to̱ kuíkon xíꞌin vino yiyá, ta chi̱nóo ra ñayóꞌo no̱o̱ yito̱n, ta ndi̱kó ra taxi ra koꞌo ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ta inka̱ ni̱vi ni̱ka̱ꞌa̱n na saá xíꞌin ta̱yóꞌo: ―O̱n keꞌé ún ra. Ná koto yó án kixi ta̱Elías saka̱ku ñaꞌá ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ta saá ta̱Jesús xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra, ta ni̱xiꞌi̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tá mií saá xa̱ndi̱ko̱n ni̱nda̱ta̱ ma̱ꞌñó tiko̱to̱ tákaa̱ Cuarto Yi̱i̱ veꞌe ño̱ꞌo káꞌno, ta ki̱xáꞌá ña ni̱nda̱ta̱ ña chi ni̱no ta no̱o ña nda̱ ni̱no̱. Ta ni̱ta̱an no̱o̱ ñoꞌo̱, ta ñayu̱u̱ náꞌno cha̱chi ña. ");
INSERT INTO mim_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ta ni̱xo̱na̱ no̱o̱ ñóꞌo na ni̱xiꞌi̱, ta na̱taku̱ kua̱ꞌa̱ ní ni̱vi na xi̱kuu na ka̱ndixa Ndios. ");
INSERT INTO mim_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ta ki̱vi̱ na̱taku̱ ta̱Jesús, nde̱e nayóꞌo no̱o̱ ni̱ndu̱xu̱n na, ta ni̱ki̱ꞌvi na ñoo yi̱i̱ Jerusalén, ta kua̱ꞌa̱ ní ni̱vi xi̱ni na nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ta ta̱ ndíso chiño xíꞌin ñii ciento natropa, yóo ra xíꞌin inka̱ natropa ndáa na ta̱Jesús. Ta nayóꞌo xi̱ni na ni̱ta̱an no̱o̱ ñoꞌo̱, ta xi̱ni na ndiꞌi ña yi̱yo ní ni̱yaꞌa, ta ni̱yi̱ꞌví ní na, ta ni̱ka̱ꞌa̱n na: ―Ndixa ta̱yóꞌo xi̱kuu Sa̱ꞌya Ndios ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ta nda̱ xíká yíta kua̱ꞌa̱ ní násíꞌí xíto ná. Náyóꞌo kúu ná xi̱ndiko̱n sa̱ta̱ ta̱Jesús chíndeé ná ra kísa chiño ná no̱o̱ ra, ta ke̱e ná xíꞌin ra estado Galilea ta ki̱xaa̱ ná ñoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ñii ñáyóꞌo kúu ñáMaría Magdalena, inka̱ ñá kúu ñáMaría, siꞌí ta̱Jacobo xíꞌin ta̱José, ta inka̱ ñá kúu siꞌí ta̱ o̱vi̱ sa̱ꞌya ta̱Zebedeo. ");
INSERT INTO mim_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ta xikuaa ta xa kua̱ꞌa̱n kunaa kúu ña, ta ki̱xaa̱ ñii ta̱kuíká, ta̱ ki̱xi ñoo Arimatea, na̱ní ra José. Ta̱yóꞌo kúu ñii ta̱ xi̱ndiko̱n sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ta ni̱xa̱ꞌa̱n ra no̱o̱ ta̱Pilato, ta ndu̱kú ra yi̱kí ko̱ñu ta̱Jesús ña sandúxu̱n ra ña, ta ta̱Pilato xa̱ꞌnda chiño ra no̱o̱ natropa ña nataxi na ña ndaꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ta ni̱xaa̱ ta̱José ta na̱kiꞌin ra yi̱kí ko̱ñu ta̱Jesús, ta chi̱súku ndaa ra ña xíꞌin ñii tiko̱to̱ ndii ña o̱n vása ya̱kua̱. ");
INSERT INTO mim_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ta ni̱xa̱ꞌa̱n ra ta chi̱kaa̱ va̱ꞌa ra yi̱kí ko̱ñu ta̱Jesús ini kavua̱ ña xa̱á ña sa̱kán ki̱sa va̱ꞌa ra ini. Ta saá na̱kasi ra yéꞌé kavua̱ yóꞌo xíꞌin ñii yu̱u̱ káꞌno, ta ke̱e ra kua̱noꞌo̱ ra. ");
INSERT INTO mim_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ta ni̱ndo̱o ñáMaría Magdalena xíꞌin inka̱ ñáMaría, ndóo na yatin no̱o̱ yóo kavua̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ta inka̱ ki̱vi̱ ña kúu ki̱vi̱ yi̱i̱ ña nákindée najudío, ta nafariseo xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ ni̱xaa̱ na no̱o̱ ta̱Pilato. ");
INSERT INTO mim_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ta ni̱ka̱ꞌa̱n na, káchí na saá xíꞌin ra: ―Tata, nákáꞌán ndi̱ ña ni̱ka̱ꞌa̱n ta̱ vatá yuꞌu̱ ta̱Jesús ki̱vi̱ xi̱taku̱ ra, ni̱ka̱ꞌa̱n ra siꞌa: “Tá ni̱xiꞌi̱ i̱ ta ti̱xin ña u̱ni̱ ki̱vi̱ nataku̱ i̱”, ka̱chí ra. ");
INSERT INTO mim_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ña̱kán kaꞌnda chiño ún no̱o̱ natropa ná nakasi kútu̱ va̱ꞌa na kavua̱ no̱o̱ ni̱ndu̱xu̱n ra a̱nda̱ to̱nda̱a ki̱vi̱ u̱ni̱, ta saá ni̱vi na xi̱ndiko̱n sa̱ta̱ ra, ko̱to̱ kixi na ñii ñoó, ta tava na yi̱kí ko̱ñu ra ta ndato̱ꞌon na xíꞌin ni̱vi, kachí na saá: “Xa na̱taku̱ ra”, kachí na. Ta to̱ꞌon yóꞌo sandáꞌví ní ka̱ ña nani̱vi no̱o̱ ña sa̱ndáꞌví mi̱i ra na xíꞌin to̱ꞌon ra ―káchí nanáꞌno no̱o̱ najudío. ");
INSERT INTO mim_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ta ni̱ka̱ꞌa̱n ta̱Pilato xíꞌin na: ―Va̱ꞌa, yóo natropa, ná ko̱ꞌo̱n na xíꞌin ndó. Ta nakasi va̱ꞌa ndó yéꞌé kavua̱ no̱o̱ ni̱ndu̱xu̱n ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ta ni̱xa̱ꞌa̱n na ta ki̱sa kútu̱ va̱ꞌa na yéꞌé kavua̱, ta xa̱ki̱n na ñii sello yéꞌé ña o̱n no̱na̱ ña, ta saá ni̱ndo̱o natropa yatin yéꞌé kavua̱ ña kundaa na ña. ");
INSERT INTO mim_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ta ni̱yaꞌa ki̱vi̱ yi̱i̱ ña nákindée najudío, ta ni̱ti̱vi inka̱ ki̱vi̱; ñayóꞌo kúu ki̱vi̱ no̱ó semana ña kúu domingo, ta ñáMaría Magdalena xíꞌin inka̱ ñáMaría ni̱xaa̱ ná koto ná no̱o̱ ni̱ndu̱xu̱n ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ta xa̱ndi̱ko̱n ndeé ní ni̱ta̱an no̱o̱ ñoꞌo̱, saá chi ñii ángel ke̱e no̱o̱ Ndios nda̱ ñoyívi ni̱no, no̱o ña ñoyívi yóꞌo, ta ki̱xaa̱ ña ta sa̱kutaꞌa ña yu̱u̱ ndási̱ yéꞌé kavua̱, ta xi̱koo ña sa̱ta̱ yu̱u̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ta ñaángel yóꞌo náyeꞌe ní ña, nda̱tán náyeꞌe ñii ta̱xa̱, ta tiko̱to̱ ña yaa ní ña, nda̱tán yaa kaxin saá yóo ña. ");
INSERT INTO mim_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ta natropa na ndáa yéꞌé kavua̱ ndeé ní ni̱yi̱ꞌví na xi̱ni na ña, ñii kísin ni̱no na xíꞌin ña yíꞌví na, ta saá na̱ko̱yo na no̱o̱ ñoꞌo̱ ta nda̱ñóꞌó ini na. Nda̱tán ñii ki̱ꞌva yóo na ni̱xiꞌi̱, saá yóo na ndóo na. ");
INSERT INTO mim_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ta ñaángel ni̱ka̱ꞌa̱n ña xíꞌin násíꞌí yóꞌo: ―O̱n kuyi̱ꞌví ndó, saá chi yi̱ꞌi̱ xíni̱ i̱ ndí ndóꞌó nándukú ndó ta̱Jesús, ta̱a ta̱ ka̱takaa̱ ndaa na ndaꞌa̱ tón cruz. ");
INSERT INTO mim_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","O̱n ko̱ó ka̱ ra yóꞌo, chi xa na̱taku̱ ra, ñii ki̱ꞌva yóo to̱ꞌon ña ni̱ka̱ꞌa̱n ra xíꞌin ndó, saá yóo ña. Naꞌa ndó koto ndó no̱o̱ chi̱nóo na ra. ");
INSERT INTO mim_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ta saá kama ní ko̱ꞌo̱n ndó ta ndato̱ꞌon ndó xíꞌin na ni̱xika xíꞌin ra, kachí ndó saá xíꞌin na: “Xa na̱taku̱ ra, ta ko̱ꞌo̱n siꞌna ra no̱o̱ ndó ña kundati ra ndóꞌó estado Galilea. Kán koni ndó ra”, kachí ndó xíꞌin na. Ñayóꞌo kúu to̱ꞌon ña ndáto̱ꞌon i̱ xíꞌin ndó ―káchí ñaángel xíꞌin násíꞌí yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ta saá násíꞌí yóꞌo vará nda̱ yíꞌví ní ná, ta kúsii̱ ní ka̱ ini ná, ta kama ní ke̱e ná xíno ná kua̱ꞌa̱n ná ndato̱ꞌon ná xíꞌin na ni̱xika xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ta xa̱ndi̱ko̱n ta̱Jesús na̱kutáꞌan ra xíꞌin náñaꞌa̱ yóꞌo yichi̱, ta chi̱ndeé ra ná ta ni̱ka̱ꞌa̱n ra siꞌa xíꞌin ná: ―Kuaꞌa, nana. Ná koo ñava̱ꞌa ini ndó ―káchí ra xíꞌin ná. Ta ni̱xaa̱ yatin ná no̱o̱ ra, ta xi̱kuxítí ná ta no̱mi ná xa̱ꞌa̱ ra ta ki̱sa to̱ꞌó ná ra. ");
INSERT INTO mim_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ná: ―O̱n kuyi̱ꞌví ndó. Kua̱ꞌa̱n ndó ndato̱ꞌon ndó xíꞌin na ni̱xika xíꞌin i̱ ná ko̱ꞌo̱n na estado Galilea, ta kán koni na yi̱ꞌi̱ ―káchí ra xíꞌin ná. ");
INSERT INTO mim_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ta ke̱e násíꞌí kua̱ꞌa̱n ná, ta sava natropa na xi̱ndaa yéꞌé kavua̱ ndi̱kó na kua̱ꞌa̱n na ñoo káꞌno, ta nda̱to̱ꞌon na xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ ndiꞌi ña ni̱xi̱yo xi̱ni na. ");
INSERT INTO mim_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ta nanáꞌno no̱o̱ nasu̱tu̱ na̱kutáꞌan na xíꞌin naxi̱kua̱ꞌa̱ no̱o̱ najudío, ta na̱koo yuꞌú na taxi na kua̱ꞌa̱ ní si̱ꞌún ndaꞌa̱ natropa, ");
INSERT INTO mim_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ta ni̱ka̱ꞌa̱n na, káchí na saá xíꞌin na: ―Siꞌa koo ka̱ꞌa̱n ndó xíꞌin ni̱vi xa̱ꞌa̱ ña ni̱xi̱yo xi̱ni ndó, kachí ndó siꞌa: “Tá kísi̱n ndi̱ ñoó koni, ta na ni̱xika xíꞌin ta̱Jesús ni̱xaa̱ na, ta ki̱sa kuíꞌná na yi̱kí ko̱ñu ra, ta kua̱ꞌa̱n na xíꞌin ña”, saá kachí ndó xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tá ta̱gobernador koni̱ so̱ꞌo ra to̱ꞌon yóꞌo, ta mi̱i ndi̱ ndakuii̱n xa̱ꞌa̱ ndó, ña o̱n sakuiso ra kua̱chi ndóꞌó ―káchí nanáꞌno xíꞌin natropa. ");
INSERT INTO mim_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ta saá natropa na̱kiꞌin na si̱ꞌún ta ki̱sa ndivi na chiño ña ni̱ka̱ꞌa̱n na xíꞌin na. Ta to̱ꞌon yóꞌo kúu ña ni̱xi̱ta̱ níꞌnó no̱o̱ ndiꞌi najudío a̱nda̱ ki̱vi̱ vitin. ");
INSERT INTO mim_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ta saá na u̱xu̱ ñii naxíka xíꞌin ta̱Jesús kua̱ꞌa̱n na estado Galilea, ta ni̱xaa̱ na yuku̱ no̱o̱ ni̱ka̱ꞌa̱n ta̱Jesús ko̱ꞌo̱n na. ");
INSERT INTO mim_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ta xi̱ni na ra ta ki̱sa to̱ꞌó na ra, vará sava nayóꞌo ni̱xika ini na án ndixa kúu ta̱yóꞌo ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ta ni̱xaa̱ yatin ta̱Jesús no̱o̱ na ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―Ndios ta̱xi ra ndiꞌi nda̱yí ña kaꞌnda chiño i̱ no̱o̱ ndiꞌi na ndóo ñoyívi ni̱no xíꞌin ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ta saá káꞌa̱n i̱ xíꞌin ndó: Kua̱ꞌa̱n ndó ndiꞌi saá xiiña ñoyívi yóꞌo ta sanáꞌa ndó nani̱vi ndasaá koo kundiko̱n na yichi̱ i̱, ta sakuchu ndó na xíꞌin ki̱vi̱ Yivá yó, xíꞌin ki̱vi̱ yi̱ꞌi̱ ta̱Sa̱ꞌya ra, ta xíꞌin ki̱vi̱ Níma̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ta sanáꞌa ndó na ña kasa ndivi na ndiꞌi to̱ꞌon ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó. Ta ndixa yi̱ꞌi̱ koo i̱ xíꞌin ndó ndiꞌi saá ki̱vi̱ ña va̱xi a̱nda̱ ki̱vi̱ sondíꞌí ñoyívi yóꞌo. Saá ná koo ña ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra.");
INSERT INTO mim_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Siꞌa kíxáꞌá to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ Jesucristo, Sa̱ꞌya Ndios, ");
INSERT INTO mim_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","tá yóo ña ni̱taa ta̱profeta Isaías, ta̱a ta̱ ni̱ka̱ꞌa̱n ndoso to̱ꞌon Ndios kui̱ya̱ xi̱na̱ꞌá. Ni̱taa ra ña ni̱ka̱ꞌa̱n Ndios xíꞌin ta̱a ta̱ tiꞌví ra saka̱ku na ñoyívi yóꞌo, ka̱chí ra saá: Tiꞌví i̱ ñii ta̱ xíka chiño no̱o̱ i̱ ko̱ꞌo̱n siꞌna ra no̱o̱ ún, ña ndasa va̱ꞌa ra yichi̱ no̱o̱ ko̱ꞌo̱n ún. ");
INSERT INTO mim_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ta no̱o̱ yóo yuku̱ yi̱chí ko̱ꞌo̱n ra ka̱ꞌa̱n ndoso ra, kachí ra saá: “Ná koo tiꞌva ini ndó, saá chi ya̱chi̱ kixaa̱ mi̱i ta̱Káꞌno no̱o̱ yó; kindaa ndó ña o̱n váꞌa sási no̱o̱ ndó, ta saá va̱ꞌa kuchiño nakiꞌin ndó ra”, kachí ta̱a ta̱ koo yuku̱ yi̱chí, ka̱chí ta̱Isaías xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Saá ki̱xaa̱ ta̱Juan no̱o̱ yóo yuku̱ yi̱chí ta ñii xiiña no̱o̱ yóo takuií sa̱kuchu ra ni̱vi, ta ni̱ka̱ꞌa̱n ndoso ra xíꞌin ni̱vi, káchí ra saá: ―O̱n vása keꞌé ka̱ ndó ña o̱n váꞌa, ta nandikó ini ndó xa̱ꞌa̱ ña o̱n váꞌa ke̱ꞌé ndó ña kasa káꞌno ini Ndios xa̱ꞌa̱ kua̱chi ndó, ta saá naꞌa ndó kuchu ndó ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ta ni̱vi nañoo Jerusalén, xíꞌin na ndóo ndiꞌi saá kua̱ꞌa̱ ka̱ ñoo ña ndáꞌvi ndaa estado Judea va̱xi na, ta ki̱xaa̱ na ña koni̱ so̱ꞌo na to̱ꞌon káꞌa̱n ndoso ta̱Juan. Ta saá xi̱ni̱ so̱ꞌo na, ta ki̱xáꞌá náꞌma na xa̱ꞌa̱ kua̱chi na, ta ta̱Juan sa̱kuchu ra nayóꞌo yu̱ta Jordán. ");
INSERT INTO mim_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ta ta̱Juan ndíxin ra tiko̱to̱ ña ku̱va̱ꞌa xíꞌin yisi̱ tícamello, ta nóꞌni ñii ñáꞌño ñii̱ kiti̱ to̱ko̱ ra. Ta xíxi ra ti̱ka ndíama xíꞌin ño̱ño̱ tíyóko̱ válí yóo yuku̱. ");
INSERT INTO mim_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ta ni̱ka̱ꞌa̱n ndoso ra, káchí ra saá xíꞌin ni̱vi: ―Sa̱ta̱ yi̱ꞌi̱ va̱xi ñii ta̱a ta̱ ndeé ka̱ no̱o̱ yi̱ꞌi̱. Ta yi̱ꞌi̱ kúu ñii ta̱ kísa chiño kuiti no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yi̱ꞌi̱ sákuchu i̱ ndóꞌó xíꞌin takuií, ta ta̱ va̱xi sakuchu ra ndóꞌó xíꞌin mi̱i Níma̱ Ndios ―káchí ta̱Juan xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ta saá ke̱e ta̱Jesús ñoo Nazaret estado Galilea, ta ki̱xaa̱ ra no̱o̱ yóo ta̱Juan, ta ta̱Juan sa̱kuchu ra ta̱Jesús yu̱ta Jordán. ");
INSERT INTO mim_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ta ke̱ta ta̱Jesús yuꞌu̱ yu̱ta, ta xi̱ni ra ni̱xo̱na̱ ñoyívi ni̱no no̱o̱ ra, ta xi̱ni ra va̱xi noo Níma̱ Ndios, nda̱tán va̱xi noo ñii tísa̱ta, saá va̱xi noo ña, ta xi̱kanóo ña no̱o̱ ñíndichi ra. ");
INSERT INTO mim_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ta ni̱vi na ndóo yuꞌu̱ yu̱ta xi̱ni̱ so̱ꞌo na to̱ꞌon Ndios ni̱ka̱ꞌa̱n ra nda̱ ñoyívi ni̱no, káchí ra saá: ―Yóꞌó kúu Sa̱ꞌya i̱, ta̱ kíꞌvi ní ini i̱ xíni i̱, ta kúsii̱ ní ini i̱ xíni i̱ yóꞌó ―káchí Ndios. ");
INSERT INTO mim_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ta xa̱ndi̱ko̱n Níma̱ Ndios ni̱ka̱ꞌa̱n ña xíꞌin ta̱Jesús ko̱ꞌo̱n ra xíꞌin ña no̱o̱ yóo yuku̱ yi̱chí. ");
INSERT INTO mim_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ta o̱vi̱ si̱ko̱ ki̱vi̱ yóo ta̱Jesús no̱o̱ yuku̱ yi̱chí yóꞌo, yóo ra no̱o̱ táku̱ tíkiti̱ yukú, ta ñaníma̱ ndiva̱ꞌa káꞌno xíto ndoso ña ra. Ta saá ki̱xaa̱ naángel, ta chi̱ndeé na ra, ta̱xi na ndaꞌa̱ ra ña xíni̱ ñóꞌó no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ki̱vi̱ chi̱kaa̱ na ta̱Juan ini veꞌe ka̱a, ta ta̱Jesús kua̱ꞌa̱n ra estado Galilea, ta ni̱ka̱ꞌa̱n ndoso ra to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ Ndios xíꞌin ni̱vi, ");
INSERT INTO mim_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","káchí ra saá: ―Xa ki̱xaa̱ ki̱vi̱ ña chi̱tóni̱ Ndios. Ta xa yóo yatin ní yichi̱ ña xáꞌnda chiño Ndios kutaku̱ yó. O̱n vása keꞌé ka̱ ndó ña o̱n váꞌa, ta nandikó ini ndó ta kandixa ndó to̱ꞌon ñava̱ꞌa yóꞌo ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tá kua̱ꞌa̱n ta̱Jesús yuꞌu̱ mi̱ni Galilea, ta xi̱ni ra ta̱Simón xíꞌin ñani ra ta̱Andrés, nayóꞌo sákana na ñono̱ ini takuií, chi na táva tia̱ká kúu na. ");
INSERT INTO mim_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Naꞌa ndó kundiko̱n ndó yi̱ꞌi̱, ta sanáꞌa i̱ ndóꞌó ndasaá nakaya ndó ni̱vi kundiko̱n na yichi̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ta xa̱ndi̱ko̱n sa̱ndakoo nata̱a yóꞌo ñono̱ na, ta xi̱kundiko̱n na kua̱ꞌa̱n na sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ta loꞌo ka̱ kua̱ꞌa̱n ta̱Jesús, ta xi̱ni ra ta̱Jacobo xíꞌin ñani ra ta̱Juan, sa̱ꞌya ta̱Zebedeo, ndóo na ini tón barco sándaꞌa na ñono̱ na. ");
INSERT INTO mim_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Naꞌa ndó kundiko̱n ndó yi̱ꞌi̱. Ta saá sa̱ndakoo nata̱a yóꞌo yivá na ta̱Zebedeo, ta sa̱ndakoo na inka̱ na kísa chiño no̱o̱ na, ta xi̱kundiko̱n na kua̱ꞌa̱n na sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ta ni̱xaa̱ na ñoo Capernaum, ta ndiꞌi saá ki̱vi̱ yi̱i̱ ña nákindée najudío ta̱Jesús kíꞌvi ra veꞌe ño̱ꞌo sinagoga sánáꞌa ra ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ta na̱kaꞌnda ini ni̱vi xíni̱ so̱ꞌo na ña káꞌa̱n ra, chi sánáꞌa ra na nda̱tán sánáꞌa ñii ta̱a ta̱ kómí nda̱yí, ta inka̱ namaestro na sánáꞌa nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá, nayóꞌo sánáꞌa na nda̱tán sánáꞌa ni̱vi na o̱n vása kómí nda̱yí. ");
INSERT INTO mim_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ta veꞌe ño̱ꞌo sinagoga yóo ñii ta̱a ta̱ kómí níma̱ ndiva̱ꞌa, ta ñii ndeé ní ni̱ka̱ꞌa̱n ñandiva̱ꞌa, káchí ña saá: ");
INSERT INTO mim_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Yóꞌó kúu Jesús ta̱ñoo Nazaret, ta, ¿nda̱chun sándiꞌi ún ndi̱ꞌi̱? ¿Án xa ki̱xaa̱ ún sandiꞌi ún xa̱ꞌa̱ ndi̱? Xíni̱ va̱ꞌa i̱ yu kúu ún, yóꞌó kúu Ta̱a ta̱Yi̱i̱ ta̱ ki̱xi no̱o̱ Ndios ―káchí ña xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ñandiva̱ꞌa, káchí ra saá: ―¡Kasi yuꞌu̱ ún ta saña ún ta̱yóꞌo! ");
INSERT INTO mim_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ta níma̱ ndiva̱ꞌa ndeé ní sa̱kisin ña ta̱yóꞌo, ta ni̱nda̱ꞌyi ní ña, ta saá sa̱ña ña ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ta ndiꞌi na ndóo na̱kaꞌnda ini na xi̱ni na ñayóꞌo, ta ni̱nda̱ka̱ to̱ꞌon xíꞌin táꞌan mi̱i na: ―¿Yukía̱ yóꞌo? ¿Án inka̱ ndee̱ xa̱á sánáꞌa ra mi̱i yó vitin? Kómí ra nda̱yí xáꞌnda chiño ra no̱o̱ níma̱ ndiva̱ꞌa ta kísa ndivi ña ña káꞌa̱n ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ta kama ní ni̱xi̱ta̱ níꞌnó to̱ꞌon xa̱ꞌa̱ ta̱Jesús ndiꞌi ñoo estado Galilea. ");
INSERT INTO mim_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tá ke̱e na veꞌe ño̱ꞌo sinagoga yóꞌo, ta kua̱ꞌa̱n ta̱Jesús xíꞌin ta̱Jacobo xíꞌin ta̱Juan, ta ni̱xaa̱ na veꞌe ta̱Simón xíꞌin ñani ra ta̱Andrés. ");
INSERT INTO mim_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ta ñaꞌa̱ ñási̱so ta̱Simón kándúꞌu̱ ñá no̱o̱ xi̱to, ndeé ní ndóꞌo ñá kue̱ꞌe̱ kaꞌni̱. Tá ki̱xaa̱ ta̱Jesús ta nda̱to̱ꞌon na xíꞌin ra ña ndóꞌo ñá. ");
INSERT INTO mim_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ta saá ta̱Jesús ni̱to̱nda̱a yatin ra no̱o̱ kándúꞌu̱ ñá, ta ti̱in ra ndaꞌa̱ ñá chindeé ra ñá ndakoo ñá. Ta xa̱ndi̱ko̱n sa̱ña kue̱ꞌe̱ xíꞌin ñá ta ndu̱va̱ꞌa ñá, ta ki̱xáꞌá ñá kísa ndivi ñá ña kuxu na. ");
INSERT INTO mim_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tá xikuaa ni̱ke̱tá ño̱ꞌo, ta kua̱ꞌa̱ ní ni̱vi kua̱ꞌa̱n na xíꞌin natáꞌan na, na ndeé ndóꞌo, xíꞌin inka̱ na kómí níma̱ ndiva̱ꞌa, ta ni̱xaa̱ na no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ta saá kua̱ꞌa̱ ní nañoo na̱kutáꞌan na yéꞌé veꞌe no̱o̱ yóo ta̱Jesús, ");
INSERT INTO mim_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ta sa̱ndaꞌa ra kua̱ꞌa̱ ní na ndeé ndóꞌo, chi kua̱ꞌa̱ ní no̱o̱ kue̱ꞌe̱ yóo xíꞌin na. Ta ta̱va ra kua̱ꞌa̱ ní níma̱ ndiva̱ꞌa xi̱komí sava na, ta o̱n vása ní‑taxi ra ka̱ꞌa̱n nda̱ ñii níma̱ ndiva̱ꞌa yóꞌo, chi ñaníma̱ ndiva̱ꞌa xíni̱ ña yu kúu ra. ");
INSERT INTO mim_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ta xita̱a̱n ní ta naa ka̱, nda̱koo ta̱Jesús ta ke̱e ra kua̱ꞌa̱n ra ñii xiiña no̱o̱ o̱n ko̱ó ni̱vi, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ta ta̱Simón xíꞌin natáꞌan ra ke̱e na kua̱ꞌa̱n na nandukú na ra, ");
INSERT INTO mim_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ta na̱níꞌi na ra, ta ni̱ka̱ꞌa̱n na saá xíꞌin ra: ―Kua̱ꞌa̱ ní ni̱vi nándukú na yóꞌó. ");
INSERT INTO mim_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―Ko̱ꞌo̱n yó ndiꞌi ñoo yatin ña ka̱ꞌa̱n ndoso i̱ to̱ꞌon va̱ꞌa xíꞌin ni̱vi, chi xa̱ꞌa̱ ñayóꞌo kúu ña ki̱xaa̱ i̱ ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ta xíka ra ndiꞌi saá ñoo estado Galilea, ta kíꞌvi ra veꞌe ño̱ꞌo sinagoga ña ka̱ꞌa̱n ndoso ra to̱ꞌon va̱ꞌa xa̱ꞌa̱ Ndios, ta táva ra kua̱ꞌa̱ ní níma̱ ndiva̱ꞌa ña kómí ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ta ñii ta̱a, ndeé ní ndóꞌo ra kue̱ꞌe̱ táꞌyí ña na̱ní lepra, ta ki̱xaa̱ ra no̱o̱ yóo ta̱Jesús, ta xi̱kuxítí ra no̱o̱ ra, ta xa̱ku ndáꞌví ra, káchí ra saá: ―Tata, tá kóni ún, ta sandaꞌa ún yi̱ꞌi̱ no̱o̱ kue̱ꞌe̱ ña ndóꞌo i̱. ");
INSERT INTO mim_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ta ta̱Jesús kúndáꞌví ní ini ra xíni ra ta̱yóꞌo, ta chi̱nóo ra ndaꞌa̱ ra so̱ko̱ ta̱yóꞌo, ta ni̱ka̱ꞌa̱n ra: ―Kóni i̱ chindeé i̱ yóꞌó. ¡Ndaꞌa ún! ");
INSERT INTO mim_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ta xa̱ndi̱ko̱n sa̱ña kue̱ꞌe̱ táꞌyí xíꞌin ra, ta ndu̱va̱ꞌa ra. ");
INSERT INTO mim_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ta saá ta̱Jesús ni̱nda̱yi ra ta̱yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ra, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―O̱n ndato̱ꞌon ún xíꞌin nda̱ ñii ni̱vi. Ta vitin ko̱ꞌo̱n ún no̱o̱ ta̱su̱tu̱ ná koto ra yóꞌó ña kunda̱a̱ ini ra xa ni̱ndaꞌa ún. Ta kuniꞌi ún ndiꞌi ñasóko̱ ña xáꞌnda chiño nda̱yí Ndios ña ni̱taa ta̱Moisés, ta taxi ún ñayóꞌo ndaꞌa̱ Ndios ña kunda̱a̱ ini ni̱vi xa ni̱ndaꞌa ún ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ta ke̱e ra kua̱ꞌa̱n ra, ta nda̱ víka̱ nda̱to̱ꞌon ra xíꞌin ni̱vi ña ndo̱ꞌo ra, ta ni̱xi̱ta̱ níꞌnó to̱ꞌon ndasaá nda̱ꞌa ra, ki̱sa ta̱Jesús. Xa̱ꞌa̱ ñayóꞌo ta̱Jesús o̱n vása ki̱ví ki̱ꞌvi ka̱ ra inka̱ ñoo, ta kua̱ꞌa̱n ra yóo ra ñii xiiña no̱o̱ o̱n ko̱ó ni̱vi. Ta saá ni, kua̱ꞌa̱ ní ni̱vi na ke̱e ndiꞌi saá ñoo kíxaa̱ na no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ni̱yaꞌa sava ki̱vi̱ ta ta̱Jesús ndi̱kó tuku ra ñoo Capernaum, ta nani̱vi xi̱ni̱ so̱ꞌo na ña ndi̱kó ra. ");
INSERT INTO mim_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ta xa̱ndi̱ko̱n kua̱ꞌa̱ ní ni̱vi na̱kutáꞌan na veꞌe no̱o̱ yóo ra, ta ni̱‑kunani kundo̱o ndiꞌi na veꞌe yóꞌo, ni nda̱ yéꞌé o̱n vása ní‑kunani kundo̱o na. Ta káꞌa̱n ta̱Jesús to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ Ndios xíꞌin ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ta ko̱mi̱ ta̱a ñíso̱kó na ñii xi̱to no̱o̱ kánóo ta̱ o̱n ki̱ví kanda, ta kua̱ꞌa̱n na veꞌe no̱o̱ yóo ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ta ni̱‑kuchiño ki̱ꞌvi na xíꞌin ta̱yóꞌo ini veꞌe no̱o̱ yóo ta̱Jesús chi chútú ní ni̱vi. Ta saá nda̱a na si̱ni̱ veꞌe, ndíso na xi̱to no̱o̱ kánóo ta̱ o̱n ki̱ví kanda, ta ki̱ndaa na sava chíyó ña ni̱xo̱na̱ ñii yavi̱ no̱o̱ kúchiño sanoo na ta̱yóꞌo no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tá ta̱Jesús xi̱ni ra ña kándixa na ko̱mi̱ ta̱a yóꞌo ndí kúndeé ra sandaꞌa ra ta̱táꞌan na, ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱ ndeé ndóꞌo, káchí ra saá: ―Ñani, vitin xa ki̱sa káꞌno ini i̱ xa̱ꞌa̱ kua̱chi ún ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ta ndóo sava na sánáꞌa nda̱yí Ndios, ta xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱Jesús, ta xáni si̱ni̱ na saá: ");
INSERT INTO mim_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ndá nda̱yí kómí ta̱yóꞌo ka̱ꞌa̱n ra saá? Kándiva̱ꞌa ra xíꞌin Ndios. Chi kúnda̱a̱ ini yó ndí ñii la̱á Ndios kómí nda̱yí kasa káꞌno ini ra xa̱ꞌa̱ kua̱chi ni̱vi.” ");
INSERT INTO mim_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ta xa̱ndi̱ko̱n ta̱Jesús xi̱ni̱ ra yukía̱ xáni si̱ni̱ nayóꞌo, ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―¿Nda̱chun xáni si̱ni̱ ndó ña o̱n váꞌa yóꞌo? ");
INSERT INTO mim_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Yukía̱ yo̱ꞌvi̱ ka̱ ka̱ꞌa̱n i̱ xíꞌin ta̱ o̱n ki̱ví kanda? ¿Án yo̱ꞌvi̱ ka̱ ka̱ꞌa̱n i̱ xíꞌin ra ña ndoo kua̱chi ra? ¿Án yo̱ꞌvi̱ ka̱ ka̱ꞌa̱n i̱ xíꞌin ra ña nakundichi ra, ta ná kuiso ra xi̱to ra ta ko̱ꞌo̱n xáꞌá ra? ");
INSERT INTO mim_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ta vitin sandaꞌa i̱ ta̱yóꞌo, ta saá kunda̱a̱ ini ndóꞌó ndí yi̱ꞌi̱ kúu ta̱ kómí nda̱yí Ndios ñoyívi yóꞌo ña nakata i̱ kua̱chi ni̱vi ―káchí ta̱Jesús xíꞌin na. Ta saá ni̱ka̱ꞌa̱n ra xíꞌin ta̱ ndeé ndóꞌo yóꞌo: ");
INSERT INTO mim_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Nakundichi ún ta ná kuiso ún xi̱to ún, ta noꞌo̱ ún vitin ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ta xa̱ndi̱ko̱n na̱kundichi ta̱yóꞌo, ta na̱kuso̱kó ra xi̱to ra, ta ke̱e ra kua̱noꞌo̱ ra, xi̱ni ndiꞌi ni̱vi. Ta ndiꞌi nayóꞌo na̱kaꞌnda ní ini na, ta ki̱sa káꞌno ní na Ndios, ni̱ka̱ꞌa̱n na saá: ―¡Ta̱ꞌán koni yó ñava̱ꞌa yóꞌo! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ta ni̱yaꞌa ñayóꞌo, ta kua̱ꞌa̱n ta̱Jesús xíka ra yuꞌu̱ mi̱ni Galilea. Ta kua̱ꞌa̱ ní ni̱vi ki̱xaa̱ na no̱o̱ ra, ta ki̱xáꞌá ra sánáꞌa ra na. ");
INSERT INTO mim_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ta yáꞌa ra kua̱ꞌa̱n ra, ta xi̱ni ra ta̱Leví sa̱ꞌya ta̱Alfeo, yóo ra kísa chiño ra no̱o̱ káya ra si̱ꞌún xa̱ꞌa̱ nagobierno ñoo Roma. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra, káchí ra saá: ―Naꞌa, kundiko̱n ún sa̱ta̱ i̱ ―káchí ra. Ta saá na̱kundichi ta̱Leví, ta kua̱ꞌa̱n ra sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tá ni̱xaa̱ ta̱Jesús xíꞌin naxíka xíꞌin ra veꞌe ta̱Leví, ta ki̱xaa̱ kua̱ꞌa̱ ní na káya si̱ꞌún xa̱ꞌa̱ nagobierno xíꞌin kua̱ꞌa̱ ní inka̱ na kánóo to̱ꞌon ña o̱n váꞌa xa̱ꞌa̱, ta xi̱kundo̱o na xíxi na xíꞌin ta̱Jesús, chi kua̱ꞌa̱ ní nayóꞌo kúu na kua̱ꞌa̱n sa̱ta̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ta nafariseo xíꞌin sava na sánáꞌa nda̱yí Ndios xi̱ni na yu kúu ni̱vi ndóo xíxi xíꞌin ta̱Jesús, ta ni̱ka̱ꞌa̱n na xíꞌin naxíka xíꞌin ta̱Jesús: ―O̱n vása va̱ꞌa ñayóꞌo. ¿Nda̱chun xíxi ra xíꞌin ni̱vi na káya si̱ꞌún xa̱ꞌa̱ nagobierno, xíꞌin inka̱ na kánóo to̱ꞌon ña o̱n váꞌa xa̱ꞌa̱? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ta xi̱ni̱ so̱ꞌo ta̱Jesús yukía̱ ni̱ka̱ꞌa̱n na, ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―Ni̱vi na o̱n vása ndeé ndóꞌo, o̱n vása xíni̱ ñóꞌó nayóꞌo na kasa ta̱ta̱n ñaꞌá, ta ni̱vi na ndeé ndóꞌo kúu na xíni̱ ñóꞌó kutátán. O̱n si̱ví xa̱ꞌa̱ ni̱vi va̱ꞌa kúu ña ki̱xaa̱ i̱ ñoyívi yóꞌo. Ta xa̱ꞌa̱ ni̱vi o̱n váꞌa kúu ña ki̱xaa̱ i̱, ta kana i̱ na ña nandikó ini na ta kundiko̱n na yichi̱ Ndios ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nafariseo xíꞌin na ndíko̱n sa̱ta̱ ta̱Juan yóo soꞌon na. Ta ki̱xaa̱ sava ni̱vi no̱o̱ ta̱Jesús, ta ni̱nda̱ka̱ to̱ꞌon na ra: ―Kua̱ꞌa̱ ní yichi̱ yóo soꞌon na ndíko̱n sa̱ta̱ ta̱Juan, ta yóo soꞌon nafariseo. Ta naxíka xíꞌin mi̱i ún, ¿nda̱chun nda̱ ñii ki̱vi̱ o̱n vása yóo soꞌon na? ");
INSERT INTO mim_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―Tá yóo ñii ta̱a ta̱ tonda̱ꞌa̱, ta ndiꞌi ni̱vi na yóo viko̱ tonda̱ꞌa̱ yóꞌo xíxi na, ta o̱n ki̱ví koo soꞌon na, saá chi yóo ka̱ ta̱yóꞌo xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ta ki̱vi̱ ña va̱xi o̱n kóo ka̱ ra xíꞌin na. Ta saá kía̱ koo soꞌon na. ");
INSERT INTO mim_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Tá yóo tiko̱to̱ ña yatá, ta nda̱ ñii ni̱vi o̱n sandaꞌa na ña xíꞌin tiko̱to̱ xa̱á, saá chi tá nakata na ña, ta nduu loꞌo ña xa̱á, ta nasita ña tiko̱to̱ yatá, ta kini ka̱ ta̱ꞌnda̱ tiko̱to̱ yatá yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ta nduta̱ vino xa̱á, ta nda̱ ñii ni̱vi o̱n vása taan na rá ini ñii̱ yatá, saá chi ta̱ꞌnda̱ ñii̱ yóꞌo, ta kui̱ta̱ ndiꞌi tánduta̱ vino ta ndiꞌi xa̱ꞌa̱ ñii̱. Xíni̱ ñóꞌó taan na tánduta̱ vino xa̱á ini ñii̱ xa̱á ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ñii ki̱vi̱ yi̱i̱ ña nákindée najudío, ta ta̱Jesús xíꞌin naxíka xíꞌin ra, kua̱ꞌa̱n na yáꞌa na ma̱ꞌñó no̱o̱ yóo yita trigo. Ta naxíka xíꞌin ta̱Jesús ki̱xáꞌá na xáꞌnda na yoko̱ ta ki̱ndaa na so̱o̱ trigo, ta xa̱xi na trigo. ");
INSERT INTO mim_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ta xi̱ni nafariseo ña ke̱ꞌé nayóꞌo, ta ni̱ka̱ꞌa̱n na saá xíꞌin ta̱Jesús: ―Naxíka xíꞌin ún ni̱yaꞌa ndoso na nda̱yí Ndios chi xa̱ꞌnda na trigo, ta o̱n váꞌa kasa chiño yó ki̱vi̱ yi̱i̱ ña nákindée yó, káchí nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin na: ―¿Án o̱n vása ní‑kaꞌvi ndó to̱ꞌon Ndios no̱o̱ káꞌa̱n ña xa̱ꞌa̱ xi̱i̱ síkuá yó ta̱rey David xíꞌin natáꞌan ra, ki̱vi̱ ni̱xiꞌi̱ ní na so̱ko? ");
INSERT INTO mim_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kui̱ya̱ xi̱na̱ꞌá xi̱taku̱ ta̱Abiatar ta̱ ndíso chiño no̱o̱ ndiꞌi nasu̱tu̱, ta ni̱ki̱ꞌvi ta̱rey David ini veꞌe Ndios, ta xi̱xi ra si̱ta̱ va̱ꞌa ñayi̱i̱ vará o̱n si̱ví su̱tu̱ xi̱kuu ra. Ta ta̱xi ra si̱ta̱ va̱ꞌa yóꞌo ndaꞌa̱ natáꞌan ra xi̱xi na. Ta káchí nda̱yí Ndios saá: “Ndasaá su̱tu̱ kuiti kúchiño kuxu si̱ta̱ va̱ꞌa ñayi̱i̱” ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ta káchí ka̱ ra saá xíꞌin na: ―Xa̱ꞌa̱ ni̱vi kúu ña ki̱sa va̱ꞌa Ndios ki̱vi̱ ña nákindée yó, o̱n si̱ví xa̱ꞌa̱ ki̱vi̱ ña nákindée yó kúu ña ki̱sa va̱ꞌa ra ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, kómí i̱ nda̱yí ka̱ꞌa̱n i̱ yukía̱ va̱ꞌa keꞌé yó ki̱vi̱ yi̱i̱ ña nákindée yó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ñii ki̱vi̱ ta̱Jesús ni̱ki̱ꞌvi tuku ra veꞌe ño̱ꞌo sinagoga, ta yóo ñii ta̱a ta̱ yi̱chí ndaꞌa̱, ta o̱n vása kánda ña. ");
INSERT INTO mim_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ta ndóo sava nafariseo ña nándukú na ndasaá chikaa̱ na kua̱chi sa̱ta̱ ta̱Jesús. Ta xíto naní na yukía̱ keꞌé ta̱Jesús, án sandaꞌa ra ta̱yóꞌo, chi ki̱vi̱ yi̱i̱ ña nákindée na kúu ña. ");
INSERT INTO mim_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ta̱a ta̱ yi̱chí ndaꞌa̱ siꞌa: ―Naꞌa kundichi ún ma̱ꞌñó no̱o̱ ndiꞌi ni̱vi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ta saá ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra ni̱vi: ―¿Yukía̱ káchí nda̱yí Ndios xa̱ꞌa̱ ki̱vi̱ yi̱i̱ ña nákindée yó? ¿Án o̱n vása ndixa káchí ña keꞌé yó ñava̱ꞌa ta o̱n keꞌé yó ñandiva̱ꞌa? ¿Án o̱n vása ndixa káchí ña va̱ꞌa saka̱ku yó ni̱vi ta o̱n sandiꞌi yó xa̱ꞌa̱ na? ―káchí ra. Ta nayóꞌo nda̱ ñii na o̱n vása ndákuii̱n, tási̱ín ndóo na. ");
INSERT INTO mim_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ta ta̱Jesús na̱koto va̱ꞌa ra no̱o̱ ndiꞌi na, ta ni̱saa̱ ra xi̱ni ra na, ta kúchuchú ní ini ra chi na toon ní ini kúu na. Ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱a ta̱ yi̱chí ndaꞌa̱: ―Sanakaa̱ ún ndaꞌa̱ ún vitin ―káchí ra. Ta ta̱yóꞌo sa̱nakaa̱ ra ndaꞌa̱ ra, ta ndu̱va̱ꞌa ña. ");
INSERT INTO mim_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ta ke̱e nafariseo kua̱ꞌa̱n na, ta ki̱xáꞌá káꞌa̱n táꞌan na xíꞌin na ndíko̱n partido ta̱Herodes ndasaá koo kaꞌni na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ta ta̱Jesús xíꞌin naxíka xíꞌin ra ke̱e na kua̱ꞌa̱n na yuꞌu̱ mi̱ni Galilea. Ta kua̱ꞌa̱ ní ni̱vi na ki̱xi ndiꞌi saá ñoo estado Galilea kua̱ꞌa̱n na sa̱ta̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tá xi̱ni̱ so̱ꞌo ni̱vi na inka̱ ñoo ñava̱ꞌa kéꞌé ta̱Jesús, ta kua̱ꞌa̱ ní na ki̱xaa̱ no̱o̱ ra. Nayóꞌo ke̱e na ndiꞌi saá xiiña, ña kúu ñoo Jerusalén xíꞌin inka̱ kua̱ꞌa̱ ñoo estado Judea, kua̱ꞌa̱ ñoo estado Idumea, kua̱ꞌa̱ ñoo ña ñóꞌo inka̱ táꞌví yu̱ta Jordán, xíꞌin kua̱ꞌa̱ ñoo ña ndáꞌvi ndaa ñoo Tiro, xíꞌin ñoo Sidón. ");
INSERT INTO mim_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra ña koo tiꞌva ñii tón barco loꞌo, ña ndaa ra sa̱ta̱ tón yóꞌo, saá chi yóo kua̱ꞌa̱ ní ni̱vi, ta chútú ní na no̱o̱ ra, ta yi̱yo ní chindaꞌá na ra ta nakava ra ta takuéꞌe̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ta xa sa̱ndaꞌa ra kua̱ꞌa̱ ní ni̱vi, ña̱kán inka̱ na ndeé ndóꞌo kóni na to̱nda̱a yatin na ra a̱nda̱ tiin na ra ña koni na ndaꞌa na. ");
INSERT INTO mim_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ta ni̱vi na kómí níma̱ ndiva̱ꞌa xi̱ni na ra, ta xi̱kuxítí na nda̱ no̱o̱ ñoꞌo̱ no̱o̱ ra, ta xíꞌin ndiꞌi ndee̱ na ni̱ka̱ꞌa̱n na, káchí na saá: ―¡Yóꞌó kúu ún Sa̱ꞌya Ndios! ");
INSERT INTO mim_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ta ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ ndiꞌi ñaníma̱ ndiva̱ꞌa ña o̱n ndato̱ꞌon ña yu kúu ra. ");
INSERT INTO mim_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ta saá ta̱Jesús nda̱a ra ñii xi̱ki̱ ta ka̱na ra na na̱ka̱xin ra va̱xi no̱o̱ ra, ta ki̱xaa̱ na nakutáꞌan na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ta na̱ka̱xin ra u̱xu̱ o̱vi̱ ta̱a, ña kasa chiño na xíꞌin ra, ta ko̱ꞌo̱n na ka̱ꞌa̱n ndoso na to̱ꞌon ñava̱ꞌa xíꞌin ni̱vi inka̱ ñoo, ");
INSERT INTO mim_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ta kukomí na nda̱yí ña sandaꞌa na na ndeé ndóꞌo, ta kukomí na nda̱yí ña tava na níma̱ ndiva̱ꞌa ña sáxo̱ꞌvi̱ inka̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ta ñii ñii ta̱ u̱xu̱ o̱vi̱ yóꞌo na̱ní ra siꞌa: ñii ra na̱ní Simón, ta ta̱Jesús sa̱kunaní ñaꞌá ra Pedro; ");
INSERT INTO mim_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","inka̱ ra na̱ní Jacobo, xíꞌin ñani ra ta̱Juan, sa̱ꞌya ta̱Zebedeo kúu o̱vi̱ ta̱yóꞌo, ta ta̱Jesús na̱chinóo ra inka̱ ki̱vi̱ ña o̱vi̱ saá ta̱yóꞌo ña kúu Boanerges; to̱ꞌon yóꞌo kóni kachí ña: Ndason ní ta̱chi̱ na káꞌa̱n na, nda̱tán ndáꞌyi sa̱vi̱, saá káꞌa̱n na; ");
INSERT INTO mim_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","inka̱ ra na̱ní Andrés; inka̱ ra na̱ní Felipe; inka̱ ra na̱ní Bartolomé; inka̱ ra na̱ní Mateo; inka̱ ra na̱ní Tomás; inka̱ ra na̱ní Jacobo, sa̱ꞌya ta̱Alfeo; inka̱ ra na̱ní Tadeo; inka̱ ra na̱ní Simón ta̱ kúu ta̱ ndíko̱n partido na̱ní ña cananeo; ");
INSERT INTO mim_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","inka̱ ra na̱ní Judas Iscariote. Ta̱yóꞌo xi̱kuu ta̱a ta̱ ni̱to̱nda̱a ni̱si̱kó kuíꞌná ta̱Jesús ndaꞌa̱ na sáa̱ ini xíni ñaꞌá. Ta saá ta̱Jesús kua̱noꞌo̱ ra ñoo Capernaum, ta ni̱ki̱ꞌvi ra ñii veꞌe, ");
INSERT INTO mim_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ta kua̱ꞌa̱ ní ni̱vi tuku na̱kutáꞌan na veꞌe yóꞌo, ta chútú ní ni̱vi a̱nda̱ ni ni̱‑kivi kuxu ra xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tá xi̱ni̱ so̱ꞌo naveꞌe ra ñayóꞌo, ta ki̱xaa̱ na nakiꞌin na ra noꞌo̱ ra xíꞌin na veꞌe na, chi káchí na saá: ―Ta̱ sána ini kúu ra. ");
INSERT INTO mim_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ta na sánáꞌa nda̱yí Ndios na ki̱xi ñoo Jerusalén, ni̱ka̱ꞌa̱n na saá: ―Ñakáꞌno no̱o̱ ndiꞌi níma̱ ndiva̱ꞌa, na̱ní ña Beelzebú, tíin ní ña ta̱Jesús yóꞌo. Xíꞌin ndee̱ ñakáꞌno no̱o̱ ndiꞌi níma̱ ndiva̱ꞌa táva ta̱yóꞌo ñaníma̱ ndiva̱ꞌa ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ta ta̱Jesús ka̱na ra na va̱xi na no̱o̱ ra, ta nda̱to̱ꞌon ra xíꞌin na ñii cuento ña sanáꞌa ra na: ―¿Ndasaá kúchiño ñaníma̱ ndiva̱ꞌa káꞌno tava ña níma̱ ndiva̱ꞌa táꞌan mi̱i ña? ");
INSERT INTO mim_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tá yóo ñii ñoo, ta o̱n vása yóo yuꞌú ni̱vi, ta na̱ta̱ꞌvi̱ táꞌan na, ta ki̱xáꞌá na káni táꞌan na xíꞌin natáꞌan na, ta kama ní ndiꞌi xa̱ꞌa̱ ñoo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tá yóo ñii veꞌe no̱o̱ na̱ta̱ꞌvi̱ táꞌan na, ta káni táꞌan na, ta ndiꞌi xa̱ꞌa̱ ni̱vi veꞌe yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ta ñaníma̱ ndiva̱ꞌa káꞌno Satanás xíꞌin ndiꞌi níma̱ ndiva̱ꞌa táꞌan ña, táná nata̱ꞌvi̱ táꞌan ña án ná kani táꞌan ña xíꞌin táꞌan mi̱i ña, ta ya̱chi̱ ní ndiꞌi xa̱ꞌa̱ yichi̱ ña. ");
INSERT INTO mim_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Tá yóo ñii ta̱a ndeé ní ndaku, ta ni̱vi o̱n kúchiño ki̱ꞌvi na veꞌe ra ña kindaa na ñakuíká kómí ra. Siꞌna xíni̱ ñóꞌó katón na ra, ta saá kuchiño ki̱ꞌvi na kindaa na ndiꞌi ñakuíká kómí ra. Nda̱tán yóo ta̱a ndeé ní ndaku yóꞌo, saá yóo ñaníma̱ ndiva̱ꞌa káꞌno. ");
INSERT INTO mim_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ndixa káꞌa̱n i̱ xíꞌin ndó, Ndios kúchiño kasa káꞌno ini ra xa̱ꞌa̱ ndiꞌi ña o̱n váꞌa kéꞌé ni̱vi, ta kúchiño kasa káꞌno ini ra xa̱ꞌa̱ ndiꞌi to̱ꞌon ña káꞌa̱n ndiva̱ꞌa na xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ta ndiꞌi ni̱vi na káꞌa̱n ndiva̱ꞌa xíꞌin Níma̱ Ndios, ta Ndios o̱n kasa káꞌno ini ra xa̱ꞌa̱ ni̱vi yóꞌo, saá chi nakuiso na kua̱chi ña o̱n váꞌa yóꞌo ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ni̱ka̱ꞌa̱n ta̱Jesús saá xíꞌin na, saá chi na sánáꞌa nda̱yí Ndios ni̱ka̱ꞌa̱n na siꞌa: ―Níma̱ ndiva̱ꞌa tíin ña ta̱yóꞌo ―káchí na xa̱ꞌa̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ta saá ki̱xaa̱ nañani ta̱Jesús xíꞌin siꞌí ra. Ta yíta na ke̱ꞌe no̱o̱ yóo ra, ta ti̱ꞌví na ni̱ka̱ꞌa̱n na kana na ra kixi ra no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ta ni̱vi na ndóo xíni̱ so̱ꞌo ña káꞌa̱n ta̱Jesús, nda̱to̱ꞌon na xíꞌin ra, káchí na saá: ―Tata, siꞌí ún xíꞌin nañani ún yíta na ke̱ꞌe, ta ndúkú na yóꞌó ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Yu kúu siꞌí i̱? ¿Ta yu kúu ñani i̱? ");
INSERT INTO mim_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ta na̱koto ra no̱o̱ ndiꞌi ni̱vi na ndóo no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Yóꞌo ndóo siꞌí i̱ xíꞌin ñani i̱. ");
INSERT INTO mim_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chi ni̱vi na kísa ndivi ña kóni Ndios, nayóꞌo kúu ñani i̱ xíꞌin ki̱ꞌva̱ i̱ xíꞌin siꞌí i̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ta tuku ki̱xáꞌá ta̱Jesús sánáꞌa ra ni̱vi yuꞌu̱ mi̱ni. Ta ki̱xaa̱ kua̱ꞌa̱ ní ni̱vi no̱o̱ yóo ra, ta saá nda̱a ra ñii tón barco, ta xi̱koo ra sa̱ta̱ tón barco no̱o̱ mi̱ni, ta ndiꞌi ni̱vi yóꞌo yíta na yuꞌu̱ takuií. ");
INSERT INTO mim_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ta ki̱xáꞌá ra ndáto̱ꞌon ra kua̱ꞌa̱ ní cuento ña sanáꞌa ra na, ta káchí ra saá xíꞌin na: ");
INSERT INTO mim_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Koni̱ so̱ꞌo ndó cuento yóꞌo. Saá ndo̱ꞌo ñii ta̱a ta̱ chíꞌi ndiki̱n trigo. ");
INSERT INTO mim_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ta ki̱xáꞌá ra xíta níꞌnó ra ndiki̱n trigo ña chiꞌi ra no̱o̱ ñoꞌo̱. Ta sava ña ni̱ko̱yo yichi̱, ta ki̱xaa̱ tísaa ta xa̱xi rí ña. ");
INSERT INTO mim_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Sava ndiki̱n ni̱ko̱yo no̱o̱ yásín ní ñoꞌo̱ sa̱ta̱ yu̱u̱, ta ndiki̱n yóꞌo kama ní ni̱ndu̱ta̱ ña, chi o̱n vása kuíkon no̱o̱ ñoꞌo̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ta ke̱ta ño̱ꞌo ta ni̱yi̱chi̱ ña, ta ndi̱ꞌi xa̱ꞌa̱ ña, saá chi ni̱‑kee kónó tioꞌo ña. ");
INSERT INTO mim_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ta sava ña ni̱ko̱yo ma̱ꞌñó tón ñiño̱, ta ni̱ndu̱ta̱ ña, ta ni̱‑kuchiño kuaꞌno ña, saá chi xa̱ꞌno tón ñiño̱ yóꞌo ta xa̱ꞌni nduta̱ nó ña, ña̱kán ni̱‑kuchiño taxi ña ndiki̱n. ");
INSERT INTO mim_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ta sava ndiki̱n ni̱ko̱yo no̱o̱ ñoꞌo̱ va̱ꞌa ña kuíkon. Ta ni̱ndu̱ta̱ ña, ta xa̱ꞌno ña, ta kua̱ꞌa̱ ní ni̱xi̱yo ndiki̱n yita yóꞌo. Sava yita ta̱xi ña o̱ko̱ u̱xu̱ ndiki̱n, sava yita ta̱xi ña u̱ni̱ si̱ko̱ ndiki̱n, ta sava yita ta̱xi ña ñii ciento ndiki̱n. ");
INSERT INTO mim_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ta ni̱ka̱ꞌa̱n ka̱ ta̱Jesús: ―Ndiꞌi ndóꞌó ni̱vi na yóo so̱ꞌo, xíni̱ ñóꞌó chikaa̱ so̱ꞌo ndó ña káꞌa̱n i̱ xíꞌin ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tá xa ke̱e ni̱vi kua̱noꞌo̱ na, ta ni̱ndo̱o ta̱Jesús xíꞌin u̱xu̱ o̱vi̱ naxíka xíꞌin ra xíꞌin inka̱ na ndíko̱n sa̱ta̱ ra, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá na yukía̱ káchí cuento ña nda̱to̱ꞌon ra. ");
INSERT INTO mim_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta ndóꞌó kúnda̱a̱ ini ndó to̱ꞌon ña ñóꞌo seꞌé ña yo̱ꞌvi̱ ní ña káꞌa̱n xa̱ꞌa̱ yichi̱ no̱o̱ xáꞌnda chiño Ndios, chi saá ta̱xi Ndios ndaꞌa̱ ndó. Ta inka̱ ni̱vi kuiti xíni̱ so̱ꞌo na to̱ꞌon yóꞌo, ta o̱n vása kúnda̱a̱ va̱ꞌa ini na yukía̱ káchí ña. ");
INSERT INTO mim_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ta saá ku̱ndivi ña ni̱taa ñii ta̱profeta xi̱na̱ꞌá, ka̱chí ra: “Vará xíto na, ta o̱n vása xíni̱ na ñanda̱a̱. Vará xíni̱ so̱ꞌo na, ta o̱n vása chíkaa̱ so̱ꞌo na, ni o̱n vása kúnda̱a̱ ini na ña ndáto̱ꞌon i̱. Ña̱kán o̱n vása nándikó ini na, ta Ndios o̱n kúchiño kasa káꞌno ini ra xa̱ꞌa̱ na”, káchí to̱ꞌon Ndios ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ta saá ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Án o̱n vása kúnda̱a̱ ini ndó yukía̱ káchí cuento yóꞌo? Tá o̱n vása kúnda̱a̱ ini ndó ñayóꞌo, ta, ¿ndasaá kunda̱a̱ ini ndó inka̱ cuento ña ndato̱ꞌon i̱ xíꞌin ndó? ");
INSERT INTO mim_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ta cuento yóꞌo káchí ña saá: Ta̱a ta̱ chíꞌi ndiki̱n trigo ñii ki̱ꞌva yóo ra xíꞌin ñii ta̱a ta̱ káꞌa̱n ndoso to̱ꞌon Ndios xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sava ni̱vi nda̱tán ndóꞌo ndiki̱n ña ni̱ko̱yo yichi̱, saá ndóꞌo na. Saá chi xíni̱ so̱ꞌo na to̱ꞌon yóꞌo, ta kíxaa̱ ñandiva̱ꞌa káꞌno ta táva ña to̱ꞌon Ndios ña xi̱ni̱ so̱ꞌo na. ");
INSERT INTO mim_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Sava ni̱vi nda̱tán ndóꞌo ndiki̱n ña ni̱ko̱yo no̱o̱ yu̱u̱, saá ndóꞌo na. Saá chi xíni̱ so̱ꞌo na to̱ꞌon Ndios, ta xa̱ndi̱ko̱n nákiꞌin va̱ꞌa na ña, ta kúsii̱ ní ini na. ");
INSERT INTO mim_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ta yáꞌa ñii káni̱ loꞌo, tá kíxáꞌá va̱xi ña xóꞌvi̱ na, án inka̱ ni̱vi o̱n xi̱in ka̱ na koni ñaꞌá na xa̱ꞌa̱ ña kándixa na to̱ꞌon Ndios, ta nayóꞌo xa̱ndi̱ko̱n sándakoo na yichi̱ Ndios, ta o̱n xi̱in ka̱ na kandixa na, saá chi o̱n ta̱ꞌán chikaa̱ va̱ꞌa ini na to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ta sava ni̱vi nda̱tán ndóꞌo ndiki̱n ña ni̱ko̱yo no̱o̱ tón ñiño̱, saá ndóꞌo na. Saá chi xíni̱ so̱ꞌo na to̱ꞌon Ndios, ");
INSERT INTO mim_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ta chiño yóo ñoyívi yóꞌo sándiꞌi ní ini na, ta kíxáꞌá na kísa chiño na ña kukomí na kua̱ꞌa̱ ní ka̱ ñakuíká ñoyívi yóꞌo, ta chíkaa̱ ní ini na kasa ndivi na ña kúsii̱ ini mi̱i na, ta saá o̱n xi̱in ka̱ na kutaku̱ na nda̱tán káꞌa̱n to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ta sava ni̱vi nda̱tán ndóꞌo ndiki̱n ña ni̱ko̱yo ñoꞌo̱ va̱ꞌa ña kuíkon, saá ndóꞌo na. Saá chi xíni̱ so̱ꞌo na to̱ꞌon Ndios, ta nákiꞌin va̱ꞌa na ña, kándixa na ña, ta kúndeé na nduu na ni̱vi na va̱ꞌa ini, ta kéꞌé na kua̱ꞌa̱ ní ñava̱ꞌa no̱o̱ Ndios. Nda̱tán yóo ñii ndiki̱n ña táxi o̱ko̱ u̱xu̱ ndiki̱n, ta inka̱ ndiki̱n ña táxi u̱ni̱ si̱ko̱ ndiki̱n, ta inka̱ ndiki̱n ña táxi ñii ciento ndiki̱n, saá yóo ni̱vi na kándixa ndinoꞌo ini to̱ꞌon Ndios ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ta nda̱to̱ꞌon ta̱Jesús xíꞌin na inka̱ cuento ña sanáꞌa ra na: ―Tá nátoo̱n yó ñii ñoꞌo̱, ta o̱n chikaa̱ seꞌé yó ña ti̱xin ñii yaxi̱n án ti̱xin xi̱to. O̱n vása kéꞌé yó saá, ta va̱ꞌa ka̱ chinóo yó ña no̱o̱ síkón ña nayeꞌe ndiꞌi ña. ");
INSERT INTO mim_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kúnda̱a̱ ini yó ndí ndiꞌi ña yóo seꞌé vitin, ñii ki̱vi̱ ña va̱xi nati̱vi ndiꞌi ña, ña koni̱ ndiꞌi ni̱vi ña. ");
INSERT INTO mim_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ndiꞌi ndóꞌó ni̱vi na yóo so̱ꞌo, xíni̱ ñóꞌó chikaa̱ so̱ꞌo ndó ña káꞌa̱n i̱ xíꞌin ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Kani va̱ꞌa ini ndó xa̱ꞌa̱ ña xíni̱ so̱ꞌo ndó. Nda̱tán yóo ki̱ꞌva choꞌon ndó, saá koo ki̱ꞌva choꞌon Ndios xíꞌin ndó. Ta ndóꞌó na va̱ꞌa xíni̱ so̱ꞌo, Ndios taxi ra kua̱ꞌa̱ ka̱ ña kunda̱a̱ ini ndó ña xíni̱ so̱ꞌo ndó. ");
INSERT INTO mim_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ni̱vi na kúnda̱a̱ ini ñanda̱a̱ vitin, kunda̱a̱ ka̱ ini na ki̱vi̱ ña va̱xi, ta ni̱vi na o̱n xi̱in kunda̱a̱ ini ñanda̱a̱ vitin, ta ki̱vi̱ ña va̱xi Ndios kindaa ndiꞌi ra ñaloꞌo kúnda̱a̱ ini na. ");
INSERT INTO mim_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ni̱vi: ―Nda̱tán ndóꞌo ndiki̱n ña xi̱ta níꞌnó ñii ta̱a ña chi̱ꞌi ra no̱o̱ ñoꞌo̱, saá yóo yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ta ta̱yóꞌo án ta̱ kísi̱n án ta̱ ndíto kúu ra, ta saá yáꞌa ñoó ta yáꞌa ndiví, ta o̱n vása xíni̱ ra ndasaá ndúta̱ ndiki̱n trigo yóꞌo, ta xáꞌno ña no̱o̱ ñoꞌo̱. ");
INSERT INTO mim_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ñoꞌo̱ chíndeé ña ndiki̱n ña ndu̱ta̱ ña; siꞌna kuu ña nda̱tán ñii ku̱ꞌu̱ kuíi̱, ta saá koo yoko̱ ña, ta sondi̱ꞌi koo ndiki̱n ña. ");
INSERT INTO mim_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tá xa ni̱xi̱no̱ va̱ꞌa ñatrigo, ta tíꞌví ra ni̱vi kaꞌnda na ña, chi xa ki̱xaa̱ ki̱vi̱ kaꞌnda na ña ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ta ni̱ka̱ꞌa̱n tuku ta̱Jesús, káchí ra saá xíꞌin na: ―¿Ndasaá yóo yichi̱ no̱o̱ xáꞌnda chiño Ndios? ¿Ndá cuento ndato̱ꞌon yó ña nandaxin yó xa̱ꞌa̱ ña? ");
INSERT INTO mim_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nda̱tán yóo ñii ndiki̱n mostaza, saá yóo yichi̱ no̱o̱ xáꞌnda chiño Ndios. Válí ní ka̱ ndiki̱n yóꞌo no̱o̱ ndiꞌi ndiki̱n yóo ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tá xa chi̱ꞌi ni̱vi ndiki̱n yóꞌo, ta xáꞌno ña ta ndúu ña ña káꞌno ní ka̱ no̱o̱ ndiꞌi inka̱ ñata̱ta̱ chíꞌi ni̱vi. Ta nándika tón ndaꞌa̱ ña no̱o̱ táxi ña ku̱nda̱ti̱ nandoso tísaa ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ni̱vi kua̱ꞌa̱ ní ka̱ cuento ña sanáꞌa ra na xa̱ꞌa̱ yichi̱ no̱o̱ xáꞌnda chiño Ndios. Nda̱to̱ꞌon ra xíꞌin na xíꞌin cuento válí yóꞌo ña va̱ꞌa kúchiño kunda̱a̱ ini na. ");
INSERT INTO mim_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ta o̱n vása ní‑sanáꞌa ra nayóꞌo xíꞌin inka̱ no̱o̱ to̱ꞌon. Tá kíndo̱o matóꞌón ra xíꞌin naxíka xíꞌin ra, ta na̱ndaxin ndiꞌi ra cuento yóꞌo no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ta ki̱vi̱ yóꞌo tá kua̱ꞌa̱n kuñoó, ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin u̱xu̱ o̱vi̱ naxíka xíꞌin ra: ―Ná koꞌyo̱ inka̱ xiiña no̱o̱ mi̱ni. ");
INSERT INTO mim_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ta ni̱nda̱yi ra ni̱vi, ta naxíka xíꞌin ra nda̱a na kua̱ꞌa̱n na xíꞌin ta̱Jesús ini tón barco. Ta kua̱ꞌa̱ ka̱ tón barco ndíko̱n kua̱ꞌa̱n xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ta ki̱xáꞌá ndeé ní káni ta̱chi̱ naꞌá no̱o̱ takuií, ta̱nda̱ kua̱ꞌa̱n ndaa takuií ta na̱kutú rá ini tón barco, ta ki̱xáꞌá nó kua̱ꞌa̱n ke̱tá nó ini takuií. ");
INSERT INTO mim_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ta ta̱Jesús sa̱ta̱ tón barco kándúꞌu̱ ra kísi̱n ra ta kánóo si̱ni̱ ra no̱o̱ ñii ka̱chi̱. Ta naxíka xíꞌin ra sa̱nakáxín na ini ra, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―¡Tata Maestro! ¿Án o̱n vása ndíꞌi ini ún, yi̱yo ní ka̱ꞌa̱ ndiꞌi yó xíꞌin takuií, chi kua̱ꞌa̱n ke̱tá tón barco ini mi̱ni? ");
INSERT INTO mim_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ta nda̱koo ta̱Jesús, ta xa̱ꞌnda chiño ra no̱o̱ ta̱chi̱ naꞌá xíꞌin takuií mi̱ni: ―¡Koo ya̱a̱ ndó, koo tási̱ín ndó! ―káchí ra. Ta saá ni̱ya̱a̱ ta̱chi̱ ta takuií mi̱ni ñii ya̱a̱ ya̱a̱ na̱koo rá. ");
INSERT INTO mim_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra: ―¿Nda̱chun yíꞌví ní ndó? ¿Nda̱chun o̱n vása kándixa ndó Ndios ndáa ra ndóꞌó? ");
INSERT INTO mim_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Saá ni, ni̱yi̱ꞌví ka̱ na, ta ni̱nda̱ka̱ to̱ꞌon táꞌan na: ―¿Yu kúu ta̱yóꞌo? ¡Chi nda̱ ta̱chi̱ naꞌá xíꞌin takuií mi̱ni xíni̱ so̱ꞌo to̱ꞌon káꞌa̱n ra! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ta saá ni̱xaa̱ ta̱Jesús xíꞌin u̱xu̱ o̱vi̱ naxíka xíꞌin ra inka̱ táꞌví yuꞌu̱ mi̱ni no̱o̱ ndóo nañoo Gadara. ");
INSERT INTO mim_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tá no̱o ta̱Jesús tón barco, ta ñii ta̱a ta̱ kómí níma̱ ndiva̱ꞌa ke̱e ra kavua̱ no̱o̱ ndúxu̱n nandi̱í, ta kua̱ꞌa̱n ra ña nakutáꞌan ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ta ta̱yóꞌo táku̱ ra kavua̱, ta nda̱ ñii ni̱vi o̱n vása ki̱ví katón na ra, ni xíꞌin cadena ka̱a. ");
INSERT INTO mim_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Xa kua̱ꞌa̱ ní yichi̱ kátón na ndaꞌa̱ ra, kátón na xa̱ꞌa̱ ra, ta̱nda̱ ñii válí válí cháchi cadena ka̱a, ta táꞌnda̱ ña, ni o̱n vása kúchiño ña kunoꞌni ña ra. Nda̱ ñii ni̱vi ni̱‑kundeé na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ndiví ñoó ndáꞌyi ra xíka ra no̱o̱ ndúxu̱n na, ñii ki̱ꞌva saá ndáꞌyi ra xíka ra no̱o̱ yuku̱, ta sátakuéꞌe̱ ra ñii̱ ko̱ñu mi̱i ra xíꞌin yu̱u̱. ");
INSERT INTO mim_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tá xi̱ni ra ta̱Jesús nda̱ xíká ka̱, ta xíno ra ni̱xaa̱ ra xi̱kuxítí ra no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ta ki̱xáꞌá ñaníma̱ ndiva̱ꞌa ña kómí ra xíꞌin ndiꞌi ndee̱ ña ni̱ka̱ꞌa̱n ña, ta káchí ña saá: ―¿Yukía̱ kóni ún keꞌé ún xíꞌin i̱? Chi yóꞌó ta̱Jesús kúu Sa̱ꞌya Ndios ta̱Káꞌno. Ta̱nda̱ no̱o̱ Ndios káꞌa̱n i̱ xíꞌin ún, o̱n saxo̱ꞌvi̱ ún yi̱ꞌi̱ ―káchí ña xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ni̱ka̱ꞌa̱n ña siꞌa, saá chi ta̱Jesús xa ki̱xáꞌá ra táva ra níma̱ ndiva̱ꞌa, káchí ra saá: ―¡Níma̱ ndiva̱ꞌa, kee ún ta saña ún ta̱yóꞌo! ");
INSERT INTO mim_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra níma̱ ndiva̱ꞌa: ―¿Ndasaá na̱ní ún? Ta nda̱kuii̱n ña: ―Na̱ní ndi̱ Legión chi kua̱ꞌa̱ ní kúu ndi̱. ");
INSERT INTO mim_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ta xáku ndáꞌví ña no̱o̱ ta̱Jesús ña o̱n tiꞌví ra ndiꞌi ñaníma̱ ndiva̱ꞌa ko̱ꞌo̱n ña inka̱ xiiña. ");
INSERT INTO mim_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ta yatin no̱o̱ yóo ñii yuku̱, xíka kua̱ꞌa̱ ní tíkini̱ xíxaꞌan rí. ");
INSERT INTO mim_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ta ndiꞌi ñaníma̱ ndiva̱ꞌa xa̱ku ndáꞌví ña no̱o̱ ta̱Jesús, káchí ña saá: ―Tiꞌví ún ndi̱ꞌi̱ ko̱ꞌo̱n ndi̱ ki̱ꞌvi ndi̱ ini ndiꞌi tíkini̱ kaa̱ ―káchí ña. ");
INSERT INTO mim_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ta ta̱Jesús ta̱xi ra ña ndu̱kú níma̱ ndiva̱ꞌa. Ta saá ke̱e ndiꞌi níma̱ ndiva̱ꞌa ña xi̱komí ta̱yóꞌo, ta ni̱ki̱ꞌvi ña ini ndiꞌi tíkini̱. Ta o̱vi̱ mil kúu tíkini̱ yóꞌo. Ta ndiꞌi tíkini̱ xíno rí kua̱ꞌa̱n rí, ta sa̱ko̱yo xíꞌin mi̱i rí taꞌvi̱, no̱o̱ ni̱ko̱yo rí ini mi̱ni, ta ni̱ka̱ꞌa̱ ndiꞌi rí ta ni̱xiꞌi̱ ndiꞌi rí. ");
INSERT INTO mim_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ta ni̱vi na ndáa kini̱ xíno na kua̱ꞌa̱n na ndato̱ꞌon na xíꞌin na ndóo ñoo xíꞌin na ndóo yuku̱, ña ndo̱ꞌo kini̱ sa̱na̱ na. Ta saá ki̱xaa̱ ni̱vi xíto na yukía̱ ndo̱ꞌo tíkini̱ xíꞌin ta̱a ta̱ xi̱komí níma̱ ndiva̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ta ki̱xaa̱ na no̱o̱ yóo ta̱Jesús, ta yóꞌo xi̱ni na yóo ta̱ xi̱komí kua̱ꞌa̱ ní níma̱ ndiva̱ꞌa, xa ndíxin ra tiko̱to̱, ta xa na̱koo va̱ꞌa si̱ni̱ ra. Ta nani̱vi yóꞌo ni̱yi̱ꞌví ní na. ");
INSERT INTO mim_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ta ni̱vi na xa xi̱ni ña ni̱xi̱yo nda̱to̱ꞌon na xíꞌin inka̱ ni̱vi yukía̱ ndo̱ꞌo ta̱yóꞌo xíꞌin ndiꞌi tíkini̱. ");
INSERT INTO mim_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ta saá ki̱xáꞌá ni̱vi xáku ndáꞌví na no̱o̱ ta̱Jesús ña kee ra ko̱ꞌo̱n ra inka̱ ñoo. ");
INSERT INTO mim_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tá nda̱a ta̱Jesús ini tón barco, ta ta̱ xi̱komí níma̱ ndiva̱ꞌa xa̱ku ndáꞌví ra no̱o̱ ra: ―Taxi ún ná ko̱ꞌo̱n i̱ xíꞌin ún ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ta ta̱Jesús ni̱‑xiin ra taxi ra ko̱ꞌo̱n ra, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱yóꞌo: ―Noꞌo̱ ún veꞌe ún vitin, ta ndato̱ꞌon ún xíꞌin natáꞌan ún xa̱ꞌa̱ ñakáꞌno ní ke̱ꞌé Ndios xíꞌin ún, ta ndasaá ku̱ndáꞌví ní ini ra xíꞌin ún ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ta saá ke̱e ta̱yóꞌo kua̱noꞌo̱ ra, ta ki̱xáꞌá ra ndáto̱ꞌon ra xíꞌin ni̱vi na ndóo ndiꞌi ñoo no̱o̱ ñoꞌo̱ Decápolis, ta káꞌa̱n ra xa̱ꞌa̱ ñakáꞌno ní ke̱ꞌé ta̱Jesús xíꞌin ra. Ta ndiꞌi na ndóo yóꞌo na̱kaꞌnda ní ini na. ");
INSERT INTO mim_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tá tuku ndi̱kó ta̱Jesús xíꞌin tón barco, ta na̱xaa̱ ra nda̱ yuꞌu̱ mi̱ni no̱o̱ ke̱e ra kua̱ꞌa̱n ra, ta kua̱ꞌa̱ ní ni̱vi na̱kutáꞌan na xíꞌin ra yuꞌu̱ takuií yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ta ki̱xaa̱ ñii ta̱ xáꞌnda chiño xíꞌin veꞌe ño̱ꞌo sinagoga, na̱ní ra Jairo. Ta xi̱ni ra ta̱Jesús, ta xi̱kuxítí ra no̱o̱ ra, ");
INSERT INTO mim_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ta ndeé ní xa̱ku ndáꞌví ra no̱o̱ ra, káchí ra saá: ―Tata, ndeé ní ndóꞌo ñáloꞌo sa̱ꞌya i̱, xa ñá yóo kivi̱ kúu ñá. Ná ko̱ꞌo̱n ún xíꞌin i̱ veꞌe i̱, ta ná chinóo ún ndaꞌa̱ ún si̱ni̱ ñá, ta ndaꞌa ñá ta kutaku̱ ka̱ ñá ―káchí ta̱Jairo xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ta ke̱e ta̱Jesús kua̱ꞌa̱n ra xíꞌin ta̱Jairo veꞌe ra. Ta kua̱ꞌa̱ ní ni̱vi ndíko̱n na sa̱ta̱ ra nda̱ ñii chíndaꞌá na ra. ");
INSERT INTO mim_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ta yóo ñii ñaꞌa̱ kua̱ꞌa̱n ñá xíꞌin ni̱vi na kua̱ꞌa̱n sa̱ta̱ ta̱Jesús, ta xa u̱xu̱ o̱vi̱ kui̱ya̱ ndeé ní ndóꞌo ñá kue̱ꞌe̱ xíta̱ ni̱i̱. ");
INSERT INTO mim_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Xóꞌvi̱ ní ñá chi xa ni̱xa̱ꞌa̱n ñá no̱o̱ kua̱ꞌa̱ ní ndotor, ta sa̱ndiꞌi ñá si̱ꞌún ñá. Ta o̱n vása ní‑kuchiño nduva̱ꞌa ñá, ta ndeé ní ka̱ ndóꞌo ñá. ");
INSERT INTO mim_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ta xi̱ni̱ so̱ꞌo ñá xa̱ꞌa̱ ta̱Jesús, ta ki̱xaa̱ ñá sa̱ta̱ ra xíꞌin ni̱vi, ta ni̱to̱nda̱a ndaꞌa̱ ñá tiko̱to̱ ra, ");
INSERT INTO mim_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","chi xa̱ni si̱ni̱ ñá: “Tá loꞌo kuiti ná to̱nda̱a ndaꞌa̱ yó tiko̱to̱ ra, ta saá nduva̱ꞌa yó”, xáni si̱ni̱ ñá. ");
INSERT INTO mim_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tá ni̱to̱nda̱a ndaꞌa̱ ñá tiko̱to̱ ra, ta saá xa̱ndi̱ko̱n ni̱ya̱a̱ xíta̱ ni̱i̱ ñá, ta ku̱nda̱a̱ ini ñá ndí xa nda̱ꞌa ñá. ");
INSERT INTO mim_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ta ta̱Jesús ku̱nda̱a̱ ini ra ke̱e loꞌo ndee̱ ra. Ta ndi̱kó koo ra, ta ni̱nda̱ka̱ to̱ꞌon ra ni̱vi: ―¿Yukú ndó ni̱to̱nda̱a ndaꞌa̱ tiko̱to̱ i̱? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ta naxíka xíꞌin ra nda̱kuii̱n na: ―Xíto ún ndí kua̱ꞌa̱ ní ni̱vi ta ñii chíndaꞌá táꞌan na ta chíndaꞌá na yóꞌó, ta, ¿nda̱chun ndáka̱ to̱ꞌon ún: “Yukú ndó ni̱to̱nda̱a ndaꞌa̱ tiko̱to̱ i̱”? ");
INSERT INTO mim_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ta ta̱Jesús xi̱to ra no̱o̱ ni̱vi nándukú ra yukú na ni̱to̱nda̱a ndaꞌa̱ tiko̱to̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ta ñáñaꞌa̱ yóꞌo, ta yíꞌví ñá nda̱ kísin ñá, chi ku̱nda̱a̱ ini ñá yukía̱ ku̱va̱ꞌa xíꞌin ñá, ta ki̱xaa̱ ñá xi̱kuxítí ñá no̱o̱ ta̱Jesús, ta nda̱to̱ꞌon ñá ndiꞌi ñanda̱a̱ xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ñá: ―Nana, xa ndu̱va̱ꞌa ún chi kándixa ini ún yi̱ꞌi̱. Ta vitin noꞌo̱ ún, ta ná koo va̱ꞌa ini ún chi ndu̱va̱ꞌa ún, xa ke̱e kue̱ꞌe̱ yóꞌó. ");
INSERT INTO mim_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tá káꞌa̱n ka̱ ta̱Jesús xíꞌin ñáyóꞌo, ta saá ki̱xaa̱ ni̱vi na ke̱e veꞌe ta̱Jairo, ta ni̱ka̱ꞌa̱n na xíꞌin ta̱Jairo: ―Sa̱ꞌya ún xa ni̱xiꞌi̱ ñá. ¿Nda̱chun sándiꞌi ka̱ ún ta̱Maestro yóꞌo? ");
INSERT INTO mim_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ta xi̱ni̱ so̱ꞌo ta̱Jesús ña ni̱ka̱ꞌa̱n na, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jairo: ―O̱n kuyi̱ꞌví ún. Kundaa va̱ꞌa ini ún yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta ni̱‑xiin ra kundiko̱n ni̱vi sa̱ta̱ ra, kuiti ta̱xi ra ko̱ꞌo̱n u̱ni̱ naxíka xíꞌin ra na kúu ta̱Pedro, ta̱Jacobo, xíꞌin ta̱Juan, ñani ta̱Jacobo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ta ni̱xaa̱ ta̱Jesús veꞌe ta̱Jairo, ta xi̱ni ra kua̱ꞌa̱ ní ni̱vi ndá síso̱ kúu na, xáku ní na chi kúchuchú ní ini na xa̱ꞌa̱ ñáloꞌo ñá ni̱xiꞌi̱. ");
INSERT INTO mim_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ta ni̱ki̱ꞌvi ta̱Jesús ini veꞌe, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Nda̱chun xáku ní ndó? Ñáloꞌo yóꞌo o̱n vása ní‑xiꞌi̱ ñá, ñá kísi̱n kuiti kúu ñá ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ta saá ku̱siki na ta̱Jesús ta ni̱xaku̱ ndaa na ra. Ta ta̱yóꞌo ti̱ꞌví ra ndiꞌi na kua̱ꞌa̱n na ke̱ꞌe, ta ndasaá kuiti xíꞌin yivá ñáloꞌo xíꞌin siꞌí ñá xíꞌin u̱ni̱ ta̱xíka xíꞌin ra, ni̱ki̱ꞌvi ra no̱o̱ kándúꞌu̱ ñáloꞌo. ");
INSERT INTO mim_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ta ti̱in ra ndaꞌa̱ ñá, ta ni̱ka̱ꞌa̱n ra xíꞌin ñá: ―Talita cumi ―káchí ra. To̱ꞌon aramaico yóꞌo káchí ña: Ñáloꞌo, káꞌa̱n i̱ xíꞌin ún, ndakoo ún. ");
INSERT INTO mim_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ta xa̱ndi̱ko̱n nda̱koo ñá, na̱kundichi ñá, ta ki̱xáꞌá ñá xíka ñá, chi u̱xu̱ o̱vi̱ kui̱ya̱ kómí ñá. Ta na̱kaꞌnda ní ini na ndóo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ta xa̱ꞌnda chiño ta̱Jesús no̱o̱ na ña o̱n ndato̱ꞌon na xíꞌin nda̱ ñii ni̱vi yukía̱ ndo̱ꞌo ñáloꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin naveꞌe ñá taxi na kuxu ñá. ");
INSERT INTO mim_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ta ta̱Jesús ke̱e ra kua̱noꞌo̱ ra ñoo ra, ta naxíka xíꞌin ra kua̱ꞌa̱n na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tá ki̱xaa̱ ki̱vi̱ yi̱i̱ ña nákindée najudío, saá ki̱xáꞌá ra sánáꞌa ra ni̱vi veꞌe ño̱ꞌo sinagoga, ta kua̱ꞌa̱ ní na xi̱ni̱ so̱ꞌo ña ni̱ka̱ꞌa̱n ra, na̱kaꞌnda ní ini na, ta káchí na saá: ―¿Míkía̱ sa̱kuáꞌá ta̱yóꞌo ndiꞌi ñayóꞌo? ¿Mí ki̱xi ña ndíchí ní ra, ta míkía̱ ke̱e ndee̱ ña kéꞌé ra milagro xíꞌin ni̱vi? ");
INSERT INTO mim_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Án o̱n si̱ví ta̱yóꞌo kúu carpintero? ¿Án o̱n si̱ví siꞌí ta̱yóꞌo kúu ñáMaría? ¿Án o̱n si̱ví ñani ta̱Jacobo, ta̱José, ta̱Judas xíꞌin ta̱Simón kúu ra? ¿Án o̱n ndixa ndóo ki̱ꞌva̱ ra ñoo yó yóꞌo? ―káchí na. Ta ni̱‑xiin na kandixa na ra. ");
INSERT INTO mim_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ta ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá xíꞌin na: ―Ndiꞌi saá ñoo ñoyívi yóꞌo kísa to̱ꞌó na ta̱profeta, ta nañoo mi̱i ra xíꞌin naveꞌe mi̱i ra o̱n xi̱in na kasa to̱ꞌó na ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ta saá o̱n vása ní‑keꞌé ra nda̱ ñii milagro xíꞌin nañoo yóꞌo. Kuiti chi̱nóo ra ndaꞌa̱ ra sava na ndeé ndóꞌo, ta nda̱ꞌa nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ta ta̱Jesús na̱kaꞌnda ini ra chi nañoo mi̱i ra ni̱‑xiin na kandixa na ra. Ta saá ke̱e ra kua̱ꞌa̱n ra ñii ñii ñoo válí yatin sánáꞌa ra ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ta ka̱na ra u̱xu̱ o̱vi̱ naxíka xíꞌin ra va̱xi na no̱o̱ ra, ta ki̱xáꞌá ra tíꞌví ra o̱vi̱ o̱vi̱ na ko̱ꞌo̱n na ñii ñii ñoo, ta ta̱xi ra nda̱yí ndaꞌa̱ na ña tava na níma̱ ndiva̱ꞌa ña sáxo̱ꞌvi̱ inka̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Saá ni̱ka̱ꞌa̱n ra xíꞌin na: ―Tá kua̱ꞌa̱n ndó chiño yóꞌo, ta o̱n kuniꞌi ndó ña kuxu ndó, ni leká ndó, ni si̱ꞌún ndó o̱n kuniꞌi ndó. Ta kuiti va̱ꞌa kuniꞌi ndó ñii yito̱n ko̱ꞌo̱n ndó. ");
INSERT INTO mim_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Va̱ꞌa koꞌon ndu̱xa̱n xa̱ꞌa̱ ndó, ta o̱n kuiso ka̱ ndó inka̱ tiko̱to̱ ña nasama ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ta ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na: ―Tá ni̱xaa̱ ndó inka̱ ñoo, ta veꞌe no̱o̱ nakiꞌin va̱ꞌa na ndóꞌó, kundo̱o ndó nda̱ to̱nda̱a ki̱vi̱ kee ndó ñoo nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tá yóo ñii ñoo no̱o̱ o̱n xi̱in ni̱vi nakiꞌin va̱ꞌa na ndóꞌó, ta o̱n xi̱in na koni̱ so̱ꞌo na to̱ꞌon ka̱ꞌa̱n ndó, ta saá kee ndó ñoo yóꞌo, ta ko̱ꞌo̱n ndó, ta sakisin ndó xa̱ꞌa̱ ndó ña nako̱yo yaa̱. Saá sanáꞌa káxín ndó ndí nayóꞌo nákuiso na kua̱chi no̱o̱ Ndios, chi o̱n xi̱in na koni̱ so̱ꞌo na to̱ꞌon ra. Ndixa káꞌa̱n i̱ xíꞌin ndó, to̱nda̱a ñii ki̱vi̱ ña kasa nani Ndios xa̱ꞌa̱ kua̱chi ndiꞌi ni̱vi ñoyívi yóꞌo, ta ki̱vi̱ yóꞌo ndeé ka̱ yo̱ꞌvi̱ saxo̱ꞌvi̱ ra nañoo yóꞌo no̱o̱ ni̱vi na o̱n váꞌa na xi̱ndo̱o ñoo Sodoma xíꞌin ñoo Gomorra kui̱ya̱ xi̱na̱ꞌá ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ta saá ke̱e u̱xu̱ o̱vi̱ naxíka xíꞌin ra ni̱xa̱ꞌa̱n na ni̱ka̱ꞌa̱n ndoso na xíꞌin ni̱vi ndí xíni̱ ñóꞌó nandikó ini na ta sandakoo na kua̱chi na. ");
INSERT INTO mim_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ta ta̱va na kua̱ꞌa̱ ní níma̱ ndiva̱ꞌa ña xi̱komí ni̱vi, ta chi̱kaa̱ na aceite olivo si̱ni̱ án no̱o̱ kíꞌvi̱ yi̱kí ko̱ñu ni̱vi na ndeé ndóꞌo, ta nda̱ꞌa na. ");
INSERT INTO mim_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ta ta̱rey Herodes xi̱ni̱ so̱ꞌo ra ña kánóo va̱ꞌa to̱ꞌon xa̱ꞌa̱ ta̱Jesús xa̱ꞌa̱ ndiꞌi ñava̱ꞌa ña ke̱ꞌé ra. Ta ni̱ka̱ꞌa̱n ra saá: ―Ta̱yóꞌo kúu ta̱Juan, ta̱ sa̱kuchu ni̱vi, ta ni̱xiꞌi̱ ra ta vitin na̱taku̱ ra, ña̱kán kómí ra ndee̱ kéꞌé ra ndiꞌi milagro yóꞌo vitin ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Inka̱ na káꞌa̱n: ―Ta̱profeta Elías kúu ta̱yóꞌo ―káchí na. Ta inka̱ na káꞌa̱n: ―Ta̱ káꞌa̱n ndoso to̱ꞌon Ndios kúu ta̱yóꞌo, nda̱tán ni̱xi̱yo naprofeta xi̱na̱ꞌá, saá yóo ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ta xi̱ni̱ so̱ꞌo ta̱Herodes ña ni̱ka̱ꞌa̱n na xa̱ꞌa̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n ra: ―Yi̱ꞌi̱ xa̱ꞌnda chiño i̱ ña kandoso na si̱ko̱n ta̱Juan. Ta vitin na̱taku̱ ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ni̱ka̱ꞌa̱n ta̱Herodes to̱ꞌon yóꞌo chi xáni si̱ni̱ ra xa̱ꞌa̱ ña o̱n váꞌa ni̱keꞌé ra xíꞌin ta̱Juan. Chi ta̱Juan ni̱ka̱ꞌa̱n ra kua̱ꞌa̱ ní yichi̱ xíꞌin ta̱Herodes, káchí ra saá: ―Nda̱yí Ndios ña ni̱taa ta̱Moisés káchí ña, o̱n ko̱ó yichi̱ nakiꞌin ún ñásíꞌí ñani ún koo ñá xíꞌin ún ―káchí ra. Saá chi ta̱Herodes xa ni̱tonda̱ꞌa̱ ra xíꞌin ñáHerodías ñásíꞌí ta̱Felipe ta̱ kúu ñani mi̱i ra. Ta ta̱Herodes, xa̱ꞌa̱ ña sakusii̱ ra ini ñásíꞌí ra yóꞌo, xa̱ꞌnda chiño ra no̱o̱ natropa ña tiin na ta̱Juan, ta ka̱tón na ra, ta chi̱kaa̱ na ra ini veꞌe ka̱a. ");
INSERT INTO mim_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ta ñáHerodías sáa̱ ní ini ñá xíni ñá ta̱Juan ta kóni ñá kaꞌni ñá ra. Ta ni̱‑kuchiño ñá; ");
INSERT INTO mim_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","chi ta̱Herodes yíꞌví ra no̱o̱ ta̱Juan, ta ndáa ñaꞌá ra chi xi̱ni̱ ra ta̱va̱ꞌa kúu ta̱Juan, ta̱yi̱i̱ kúu ra. Ta xíni̱ so̱ꞌo ra to̱ꞌon ña káꞌa̱n ta̱Juan ta ñii sándiꞌi ña ini ta̱Herodes, ta saá ni, kúsii̱ ini ra xíni̱ so̱ꞌo ra to̱ꞌon káꞌa̱n ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ta sondi̱ꞌi ñáHerodías na̱níꞌi ñá ndasaá koo kaꞌni ñá ta̱Juan. Ñii ki̱vi̱ ta̱Herodes ni̱xi̱no̱ ra kui̱ya̱ ta ka̱na viko̱ ra, ta saá ta̱xi ra kuxu na ndíso chiño xíꞌin ra, xíꞌin na ndíso chiño no̱o̱ natropa ra, xíꞌin naxi̱kua̱ꞌa̱ ñoo estado Galilea. ");
INSERT INTO mim_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ta ki̱xaa̱ ñása̱ꞌya ñáHerodías ka̱ta xáꞌá ñá no̱o̱ na, ta kúsii̱ ní ini ta̱Herodes xíꞌin na ndóo viko̱ yóꞌo xíni na ñá, ka̱ta xáꞌá ñá. Ta ta̱rey ni̱ka̱ꞌa̱n ra xíꞌin ñáloꞌo: ―Ndukú ún nda̱ ndá ñava̱ꞌa kóni ún no̱o̱ i̱, ta taxi i̱ ña ndaꞌa̱ ún. ");
INSERT INTO mim_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ta tuku ni̱ka̱ꞌa̱n ra xíꞌin ñá: ―Chínáꞌa i̱ Ndios taxi i̱ nda̱ yukía̱ ndúkú ún no̱o̱ i̱, a̱nda̱ taꞌví sava i̱ ñakuíká kómí i̱ ta taxi i̱ ña ndaꞌa̱ ún. ");
INSERT INTO mim_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ta ke̱e ñá ni̱xa̱ꞌa̱n ñá ni̱ka̱ꞌa̱n ñá xíꞌin siꞌí ñá: ―¿Ndá ñava̱ꞌa ndukú i̱ no̱o̱ ta̱rey? Ta nda̱kuii̱n siꞌí ñá: ―Ndukú ún no̱o̱ ra si̱ni̱ ta̱Juan ta̱ sa̱kuchu ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ta kama ndi̱kó ñá no̱o̱ ta̱rey ta ni̱ka̱ꞌa̱n ñá xíꞌin ra: ―Kóni i̱ ña chinóo ún si̱ni̱ ta̱Juan ta̱ sa̱kuchu ni̱vi, no̱o̱ ko̱ꞌo̱ ña ndíka̱, ta taxi ún ña ndaꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ta kúchuchú ní ini ta̱rey ña xi̱ni̱ so̱ꞌo ra ña ndu̱kú ñáloꞌo, ta saá ni, xa̱ꞌa̱ ña xi̱ni̱ so̱ꞌo ndiꞌi na ndóo viko̱ yukía̱ ni̱ka̱ꞌa̱n ra xíꞌin ñáloꞌo ña chi̱náꞌa ra Ndios, ni̱‑kuchiño nasama ra ña ni̱ka̱ꞌa̱n ra xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ña̱kán xa̱ndi̱ko̱n ti̱ꞌví ra ñii ta̱tropa kua̱ꞌa̱n ra veꞌe ka̱a kiꞌin ra si̱ni̱ ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ta ni̱xaa̱ ta̱yóꞌo, ta ka̱ndoso ra si̱ko̱n ta̱Juan, ta níꞌi ra si̱ni̱ ta̱Juan kánóo ña no̱o̱ ko̱ꞌo̱ ta̱xi ra ña ndaꞌa̱ ñáloꞌo, ta ñáloꞌo yóꞌo na̱taxi ñá ko̱ꞌo̱ yóꞌo ndaꞌa̱ siꞌí ñá. ");
INSERT INTO mim_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tá xi̱ni̱ so̱ꞌo naxíka xíꞌin ta̱Juan yukía̱ ndo̱ꞌo ra, ta ki̱xaa̱ na veꞌe ka̱a ta na̱kuiso na yi̱kí ko̱ñu ra, ta ni̱xa̱ꞌa̱n na sa̱ndúxu̱n na ña ñii kavua̱. Saá ndi̱ꞌi historia xa̱ꞌa̱ ña ni̱xiꞌi̱ ta̱Juan, ki̱sa ta̱Herodes. ");
INSERT INTO mim_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ta ndi̱kó u̱xu̱ o̱vi̱ naxíka xíꞌin ta̱Jesús na̱xaa̱ na no̱o̱ ra, ta nda̱to̱ꞌon na xíꞌin ra ndiꞌi ña ke̱ꞌé na, nda̱to̱ꞌon na ndiꞌi ña sa̱náꞌa na ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ta kua̱ꞌa̱ ní ni̱vi yóo, na kua̱ꞌa̱n na kíxaa̱, ña̱kán o̱n ki̱ví kuxu na. Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra: ―Naꞌa ndó ko̱ꞌo̱n ndó xíꞌin i̱ no̱o̱ o̱n ko̱ó ni̱vi ña nakindée yó ñii káni̱ loꞌo. ");
INSERT INTO mim_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ta saá ke̱e na kua̱ꞌa̱n na xíꞌin tón barco no̱o̱ o̱n ko̱ó ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ta kua̱ꞌa̱ ní ni̱vi xi̱ni na ke̱e ta̱Jesús xíꞌin naxíka xíꞌin ra kua̱ꞌa̱n na. Ta kua̱ꞌa̱ ní nayóꞌo ke̱e na ñoo, ta kua̱ꞌa̱n xáꞌá na a̱nda̱ xíno na, ta ni̱xaa̱ siꞌna na no̱o̱ nakutáꞌan na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tá no̱o ta̱Jesús tón barco, ta xi̱ni ra kua̱ꞌa̱ ní ni̱vi, ta kúndáꞌví ní ini ra xíni ra na, chi nda̱tán yóo ndikachi tí o̱n ko̱ó ta̱ ndáa, saá yóo ni̱vi yóꞌo. Ta saá ki̱xáꞌá ra sánáꞌa ra na kua̱ꞌa̱ ní ñava̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ta xa ni̱kuaa ní kúu ña, ta saá ni̱to̱nda̱a yatin u̱xu̱ o̱vi̱ naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tata, no̱o̱ ndóo yó vi̱chí ní, ta ni̱kuaa ní kúu ña vitin. ");
INSERT INTO mim_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Va̱ꞌa tiꞌví ún ndiꞌi ni̱vi yóꞌo ná ko̱ꞌo̱n na rancho án ñoo válí ña yóo yatin ña ndukú na sata na ña kuxu na. ");
INSERT INTO mim_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra: ―Mi̱i ndó taxi kuxu na ―káchí ra. Ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―¿Án ko̱ꞌo̱n ndi̱ xíꞌin o̱vi̱ ciento si̱ꞌún denario, ta sata ndi̱ si̱ta̱ va̱ꞌa ña kuxu na? ");
INSERT INTO mim_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ta ni̱nda̱ka̱ to̱ꞌon ta̱Jesús na: ―¿Ndasaá si̱ta̱ va̱ꞌa kómí ndó? Kua̱ꞌa̱n ndó koto ndó ―káchí ra. Ta xi̱ni na ndasaá kúu ña yóo, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―O̱ꞌo̱n si̱ta̱ va̱ꞌa ta o̱vi̱ tia̱ká yóo. ");
INSERT INTO mim_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ta ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ naxíka xíꞌin ra ña nataꞌví na ñii tiꞌvi ñii tiꞌvi ni̱vi kundo̱o na no̱o̱ yita síi. ");
INSERT INTO mim_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ña̱kán xi̱kundo̱o na kua̱ꞌa̱ tiꞌvi ña ciento ni̱vi ta kua̱ꞌa̱ tiꞌvi ña o̱vi̱ si̱ko̱ u̱xu̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ta saá ki̱ꞌin ta̱Jesús o̱ꞌo̱n si̱ta̱ va̱ꞌa xíꞌin o̱vi̱ tia̱ká, ta xi̱to ndaa ra ñoyívi ni̱no, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Tata Yivá yó Ndios, táxaꞌvi ñaꞌá ún ta̱xi ún ñaxíxi. Ta ta̱ꞌví ra si̱ta̱ va̱ꞌa, ta ta̱xi ra ña ndaꞌa̱ naxíka xíꞌin ra, ta nayóꞌo na̱taxi na ña ndaꞌa̱ ndiꞌi ni̱vi na ndóo yóꞌo. Ta ta̱ꞌví ra o̱vi̱ tia̱ká ta na̱taxi na rí ndaꞌa̱ ndiꞌi ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ta na̱ni ña xi̱xi ndiꞌi ni̱vi nda̱ ni̱xaa ini na, ");
INSERT INTO mim_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ta naxíka xíꞌin ta̱Jesús na̱kiꞌin na u̱xu̱ o̱vi̱ chikiva si̱ta̱ va̱ꞌa xíꞌin tia̱ká ña ki̱ndo̱o ndoso, chi ni̱‑kundeé nani̱vi kuxu ndiꞌi na ña. ");
INSERT INTO mim_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ta ndiꞌi na xi̱xi yóꞌo xi̱kuu na ñii o̱ꞌo̱n mil ta̱a. ");
INSERT INTO mim_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ta saá ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ naxíka xíꞌin ra ña ndaa na tón barco ta ko̱ꞌo̱n siꞌna na no̱o̱ ra nda̱ inka̱ xiiña no̱o̱ mi̱ni no̱o̱ yóo ñoo Betsaida, saá chi ni̱ndo̱o ra nda̱yi ra ndiꞌi ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ta ndi̱ꞌi ni̱nda̱yi ra ni̱vi, ta nda̱a ra kua̱ꞌa̱n ra yuku̱ no̱o̱ ka̱ꞌa̱n ra xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ta saá ni̱ke̱tá ño̱ꞌo ta ku̱naa, ta kánóo tón barco ma̱ꞌñó mi̱ni, ta yóo matóꞌón ra yuku̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ta xi̱ni ta̱Jesús naxíka xíꞌin ra ñii ndeé kísa chiño na xíꞌin tón barco ña ko̱ꞌo̱n nó, chi ndeé ní káni ta̱chi̱ ta sándikó ña nó. Ta xa yatin kóni ti̱vi kúu ña, ta ta̱Jesús xíka xáꞌá ra no̱o̱ takuií va̱xi ra no̱o̱ kánóo tón barco. Ta ki̱xáꞌá ra yáꞌa ra yatin no̱o̱ yóo tón barco. ");
INSERT INTO mim_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ta xi̱ni naxíka xíꞌin ra ndí xíka ra no̱o̱ mi̱ni, ta xa̱ni si̱ni̱ na ndí kuiti ñíꞌná kúu ña. Ta ni̱nda̱ꞌyi ní na, ");
INSERT INTO mim_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","chi ndiꞌi na xi̱ni na, ta ni̱yi̱ꞌví ní na. Ta saá kama ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―O̱n kundiꞌi ini ndó, chi yi̱ꞌi̱ va kúu i̱. O̱n kuyi̱ꞌví ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ta nda̱a ra tón barco no̱o̱ ndóo na, ta ni̱ya̱a̱ ta̱chi̱. Ta na̱kaꞌnda ní ini na ndóo na, ");
INSERT INTO mim_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","chi nasóꞌó ní kúu na, ta o̱n vása kúnda̱a̱ ini na yu kúu ta̱Jesús, ta ni o̱n vása kúnda̱a̱ ini na mí va̱xi ndee̱ ra ña kéꞌé ra ña kúchiño ra taxi ra xíxi kua̱ꞌa̱ ní ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ni̱yaꞌa na mi̱ni ta ni̱xaa̱ na inka̱ xiiña no̱o̱ yóo ñoo Genesaret no̱o̱ ka̱tón ndaa na tón barco. ");
INSERT INTO mim_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tá no̱o na tón barco, ta nani̱vi na yíta yóꞌo xa̱ndi̱ko̱n na̱koni na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ta nani̱vi yóꞌo xi̱no na kua̱ꞌa̱n na ndiꞌi saá ñoo yatin nda̱to̱ꞌon na xíꞌin ndiꞌi ni̱vi, ta ni̱vi na xi̱ni̱ so̱ꞌo ñayóꞌo, na̱kuiso na ni̱vi ndeé ndóꞌo ta kua̱ꞌa̱n na xíꞌin na no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ta nda̱ mí xiiña xáa̱ ta̱Jesús, án ñoo válí, án ñoo náꞌno, án rancho, ta nani̱vi chi̱ndoo na na ndeé ndóꞌo no̱o̱ yáꞌa ra. Ta xa̱ku ndáꞌví na no̱o̱ ra ña taxi ra to̱nda̱a ndaꞌa̱ na ra, vará loꞌo yuꞌu̱ tiko̱to̱ ra, ta ndiꞌi ni̱vi na ni̱to̱nda̱a ndaꞌa̱ ñaꞌá ndu̱va̱ꞌa na. ");
INSERT INTO mim_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ta sava nafariseo xíꞌin sava na sánáꞌa nda̱yí Ndios ke̱e na ñoo Jerusalén, ta ki̱xaa̱ na no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ta xi̱ni na ndí sava naxíka xíꞌin ta̱Jesús ni̱‑ndaꞌá na nda̱tán chi̱ndúꞌu̱ naxi̱i̱ síkuá na xi̱na̱ꞌá, ta xi̱xi na. Ta nafariseo xíꞌin na sánáꞌa nda̱yí Ndios ni̱ka̱ꞌa̱n na xa̱ꞌa̱ naxíka xíꞌin ta̱Jesús, káchí na saá: ―Na ndíso kua̱chi kúu nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Saá chi nafariseo xíꞌin inka̱ najudío siꞌna vivíi ndáꞌá na ta saá xíxi na, chi kísa ndivi na ña sa̱náꞌa naxi̱i̱ síkuá na xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tá ki̱vi̱ xáꞌa̱n na sata na no̱yáꞌvi, ta ndíkó na veꞌe na, siꞌna nákata na ndiꞌi ña sa̱ta na, ta saá vivíi ndáꞌá na ta kuxu na. Ta kísa ndivi na kua̱ꞌa̱ ní inka̱ ña sa̱náꞌa naxi̱i̱ síkuá na xi̱na̱ꞌá, ña nákata na vaso, xíꞌin ki̱si, xíꞌin ndiꞌi ka̱a ña xíni̱ ñóꞌó na, ta saá nákata na no̱o̱ xi̱ndo̱o na xíxi na.) ");
INSERT INTO mim_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ta nafariseo xíꞌin na sánáꞌa nda̱yí Ndios ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ―¿Nda̱chun o̱n vása kísa ndivi naxíka xíꞌin ún ña sa̱náꞌa naxi̱i̱ síkuá yó xi̱na̱ꞌá, ña siꞌna vivíi ndaꞌá na ta kuxu na?, chi na o̱n vása ndáꞌá, naya̱kua̱ kúu na no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ta ta̱Jesús nda̱kuii̱n ra: ―¡Na o̱vi̱ yuꞌu̱ kúu ndóꞌó! Ta ñanda̱a̱ kúu to̱ꞌon Ndios ña ni̱taa ta̱profeta Isaías xa̱ꞌa̱ ndó kui̱ya̱ xi̱na̱ꞌá, ka̱chí Ndios saá: Ni̱vi yóꞌo kísa to̱ꞌó na yi̱ꞌi̱ xíꞌin ndasaá kuiti to̱ꞌon kée yuꞌu̱ na, ta níma̱ na xíká ní yóo ña no̱o̱ i̱, chi o̱n vása ndinoꞌo ini na kísa to̱ꞌó na yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ta nda̱ ma̱ni̱ kísa to̱ꞌó na yi̱ꞌi̱, chi sánáꞌa na ni̱vi ña kúu nda̱yí mi̱i na, ta o̱n vása sánáꞌa na ni̱vi ña xáꞌnda chiño i̱ no̱o̱ na, ka̱chí Ndios, ni̱taa ta̱Isaías. ");
INSERT INTO mim_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Xa sa̱ndakoo ndó nda̱yí ña xáꞌnda chiño Ndios, xa̱ꞌa̱ ña ndíko̱n ndó kísa ndivi ndó ña sánáꞌa ni̱vi ndasaá xíni̱ ñóꞌó nakata ndó ki̱si xíꞌin vaso. Ta kísa ndivi ndó kua̱ꞌa̱ ní inka̱ ña sánáꞌa na ña ñii kúu xíꞌin ñayóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ta tuku ni̱ka̱ꞌa̱n ra xíꞌin na: ―Xáa noo ndó nda̱yí ña xáꞌnda chiño Ndios, ta kuiti kísa ndivi ndó ña sa̱náꞌa naxi̱i̱ síkuá ndó xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chi nda̱yí Ndios ña ni̱taa ta̱Moisés káchí ña saá: “Kasa to̱ꞌó ndó yivá ndó, ta kasa to̱ꞌó ndó siꞌí ndó”, ta “Xíni̱ ñóꞌó kivi̱ ndiꞌi ni̱vi na kándiva̱ꞌa xíꞌin yivá na án xíꞌin siꞌí na”, ka̱chí Ndios. ");
INSERT INTO mim_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ta ndóꞌó, sánáꞌa ndó káchí ndó yóo yichi̱ ka̱ꞌa̱n ñii ta̱a xíꞌin yivá ra ta xíꞌin siꞌí ra, kachí ra saá: “O̱n kúchiño i̱ chindeé i̱ ndóꞌó, saá chi xa ni̱ka̱ꞌa̱n i̱ taxi i̱ ndiꞌi ña kómí i̱ ndaꞌa̱ Ndios”, kachí ra. ");
INSERT INTO mim_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ta ñayóꞌo kúu ñava̱ꞌa no̱o̱ ndóꞌó, ña o̱n vása xíni̱ ñóꞌó ka̱ kasa to̱ꞌó ra yivá ra, ta o̱n vása xíni̱ ñóꞌó ka̱ kasa to̱ꞌó ra siꞌí ra. ");
INSERT INTO mim_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ta saá chíkaa̱ ni̱no̱ ndó to̱ꞌon Ndios xa̱ꞌa̱ ña ndíko̱n ndó yichi̱ mi̱i ndó, ta sánáꞌa ndó yichi̱ mi̱i ndó inka̱ ni̱vi. Ta kísa ndivi ndó kua̱ꞌa̱ ní ka̱ ña o̱n váꞌa ña ñii kúu xíꞌin ñayóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ta ta̱Jesús ka̱na ra ni̱vi va̱xi na no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―Koni̱ so̱ꞌo ndiꞌi ndó, ta kunda̱a̱ ini ndó ña ka̱ꞌa̱n i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ña xíxi ni̱vi ta ña kíꞌvi yuꞌu̱ na, ta o̱n vása ndása ña nduu ni̱vi na ya̱kua̱ no̱o̱ Ndios. Ta to̱ꞌon ña o̱n váꞌa va̱xi yuꞌu̱ ni̱vi, ta ñayóꞌo ndása ña nduu ni̱vi na ya̱kua̱ no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ndiꞌi ndóꞌó ni̱vi na yóo so̱ꞌo, xíni̱ ñóꞌó chikaa̱ so̱ꞌo ndó ña káꞌa̱n i̱ xíꞌin ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tá sa̱ndakoo ra ni̱vi yóꞌo, ta ni̱ki̱ꞌvi ra veꞌe, ta naxíka xíꞌin ra ni̱nda̱ka̱ to̱ꞌon ñaꞌá na yukía̱ káchí cuento yóꞌo ña sa̱náꞌa ra. ");
INSERT INTO mim_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Án ñii ki̱ꞌva nda̱tán yóo inka̱ ni̱vi, saá yóo ndóꞌó? ¿Án ta̱ꞌán kunda̱a̱ ini ndó? Ndiꞌi ña xíxi ni̱vi ta kíꞌvi ña yuꞌu̱ na, ta o̱n vása ndása ña ña nduu na ni̱vi ya̱kua̱ no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ña xíxi ni̱vi o̱n vása xáa̱ ña níma̱ na, kuiti xáa̱ ña ti̱xin na, ta saá yáꞌa ña xíta̱ ña ―káchí ra. Xíꞌin to̱ꞌon yóꞌo ta̱Jesús káchí ra ndiꞌi ña xíxi ni̱vi ñandii kúu ña. ");
INSERT INTO mim_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ta ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na: ―Ña o̱n váꞌa va̱xi níma̱ ni̱vi kúu ña ndása ña nduu ni̱vi na ya̱kua̱ no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chi ndiꞌi ña o̱n váꞌa xáni ini ni̱vi káku ña níma̱ na. Ta chíndaꞌá ña na keꞌé na ndiꞌi saá no̱o̱ ña o̱n váꞌa, ña kúu ña kíꞌvi ta̱a kua̱chi ñoyívi xíꞌin inka̱ ñaꞌa̱ ñá o̱n si̱ví kúu ñásíꞌí ra, án kíꞌvi ñaꞌa̱ kua̱chi ñoyívi xíꞌin inka̱ ta̱a ta̱ o̱n si̱ví kúu yii̱ ñá, xíꞌin ndiꞌi inka̱ no̱o̱ ñakini ña kéꞌé ni̱vi xíꞌin inka̱ ñaꞌa̱ án ta̱a, xíꞌin kua̱chi ña xáꞌni ni̱vi inka̱ ni̱vi, ");
INSERT INTO mim_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","xíꞌin ña kísa kuíꞌná na, ta xíꞌin ña kóni na kukomí na ndiꞌi ñakuíká, ta xíꞌin ña kéꞌé na ndiꞌi saá no̱o̱ ña o̱n váꞌa, ta xíꞌin ña sándáꞌví na ni̱vi, ta xíꞌin ña nda̱ loꞌo o̱n vása násita xíꞌin mi̱i na no̱o̱ ña kéꞌé na ña o̱n váꞌa, ta xíꞌin ña kísa kuíni̱ na, ta xíꞌin ña káꞌa̱n vatá na, ta xíꞌin ña kúsii̱ ini na kísa káꞌno xíꞌin mi̱i na, ta xíꞌin ña xáni ini na ndiꞌi no̱o̱ ña o̱n vása ndáya̱ꞌví. ");
INSERT INTO mim_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ndiꞌi ña o̱n váꞌa yóꞌo va̱xi ini ni̱vi ta ndása ña nduu na naya̱kua̱ no̱o̱ Ndios ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ta ke̱e ta̱Jesús xíꞌin naxíka xíꞌin ra, ta kua̱ꞌa̱n na ñii xiiña no̱o̱ yóo yatin ñoo Tiro xíꞌin Sidón. Ni̱ki̱ꞌvi ra ñii veꞌe, ta o̱n xi̱in ra ña koni̱ ni̱vi míchí yóo ra, ta ni̱‑kivi koo seꞌé ra no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ta ñii ñaꞌa̱, yóo ñii ñáloꞌo sa̱ꞌya ñá, ta kómí ñáloꞌo yóꞌo níma̱ ndiva̱ꞌa. Tá ñaꞌa̱ yóꞌo xi̱ni̱ ñá míchí yóo ta̱Jesús, ta ki̱xaa̱ ñá ta xi̱kuxítí ñá no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ñii ñaꞌa̱ o̱n si̱ví ñájudía kúu ñá, naveꞌe ñá ke̱e na ñoo Grecia, ta ka̱ku ñá ñoo Siria Fenicia. Ta xa̱ku ndáꞌví ñá no̱o̱ ta̱Jesús tava ra níma̱ ndiva̱ꞌa sáxo̱ꞌvi̱ sa̱ꞌya ñá. ");
INSERT INTO mim_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ta ni̱ka̱ꞌa̱n ra xíꞌin ñá: ―Siꞌna xíni̱ ñóꞌó taxi ndi̱ ña kuxu sa̱ꞌya ndi̱ nda̱ xáa ini na, saá chi o̱n vása va̱ꞌa tava ni̱vi si̱ta̱ va̱ꞌa ña xíxi sa̱ꞌya na, ta sakana na ña no̱o̱ tí ina kuxu rí ña ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ta nda̱kuii̱n ñá: ―Ndixa, Tata. Ta saá ni, tí ina ñóꞌo ti̱xin mesa xíxi rí ña cha̱chi ña sáko̱yo naválí no̱o̱ ñoꞌo̱ ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra: ―Xa̱ꞌa̱ to̱ꞌon ñava̱ꞌa nda̱kuii̱n ún, vitin noꞌo̱ ún veꞌe ún, xa ke̱e níma̱ ndiva̱ꞌa ña sa̱xo̱ꞌvi̱ sa̱ꞌya ún. ");
INSERT INTO mim_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ta na̱xaa̱ ñá veꞌe ñá, ta kándúꞌu̱ sa̱ꞌya ñá no̱o̱ xi̱to, o̱n ko̱ó ka̱ níma̱ ndiva̱ꞌa kómí ñá. ");
INSERT INTO mim_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ta saá ke̱e ta̱Jesús ñii xiiña yóꞌo no̱o̱ yóo yatin ñoo Tiro ta ni̱yaꞌa yatin ra ñoo Sidón, ta kua̱ꞌa̱n ra ni̱yaꞌa ra ñii xiiña na̱ní ña Decápolis, ta ni̱xaa̱ ra yatin mi̱ni Galilea. ");
INSERT INTO mim_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ta ñii ta̱a ta̱sóꞌó ta ñíꞌí ra kua̱ꞌa̱n ra xíꞌin sava ni̱vi, ta ki̱xaa̱ na ta ndu̱kú na no̱o̱ ta̱Jesús ña chinóo ra ndaꞌa̱ ra ta̱yóꞌo xa̱ꞌa̱ ña sandaꞌa ñaꞌá ra. ");
INSERT INTO mim_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ta ta̱Jesús ta̱va síín ra ta̱sóꞌó yóꞌo, ta chi̱kaa̱ ra nduku ndaꞌa̱ ra ini so̱ꞌo ta̱yóꞌo. Ta chi̱kaa̱ ra tási̱i yuꞌu̱ ra no̱o̱ nduku ndaꞌa̱ ra ta chi̱so ra tási̱i yóꞌo no̱o̱ yáa̱ ta̱sóꞌó ta̱ñíꞌí. ");
INSERT INTO mim_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ta na̱koto ndaa ta̱Jesús ñoyívi ni̱no, ta siꞌna ñii kónó va̱ꞌa ta̱va ra ta̱chi̱ ra, ta ni̱ka̱ꞌa̱n ra to̱ꞌon yóꞌo: ―¡Efata! To̱ꞌon aramaico yóꞌo káchí ña: ¡Ná no̱na̱! ");
INSERT INTO mim_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ta ni̱ka̱ꞌa̱n ra saá, ta xa̱ndi̱ko̱n ni̱xo̱na̱ so̱ꞌo ta̱yóꞌo, ta ndu̱va̱ꞌa yáa̱ ra, ta kúchiño kixáꞌá va̱ꞌa káꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ta ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ na xi̱ni ña ke̱ꞌé ra, ña o̱n ndato̱ꞌon na xíꞌin nda̱ ñii ni̱vi ndasaá nda̱ꞌa ta̱yóꞌo. Vará ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na ndúkú ra ñayóꞌo no̱o̱ na, ta saá ni, ndu̱xa̱ nda̱to̱ꞌon na xíꞌin inka̱ ni̱vi ndasaá ndu̱va̱ꞌa ta̱sóꞌó. ");
INSERT INTO mim_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ta na̱kaꞌnda ní ini na ndóo na, káchí na saá: ―Ta̱yóꞌo kéꞌé ra ndiꞌi ñava̱ꞌa. Sándaꞌa ra nasóꞌó ta va̱ꞌa xíni̱ so̱ꞌo na, ta nañíꞌí va̱ꞌa káꞌa̱n na ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ñii ki̱vi̱ na̱kutáꞌan kua̱ꞌa̱ ní ni̱vi xíꞌin ta̱Jesús. Ta o̱n ko̱ó ña kuxu na, ta ta̱Jesús ka̱na ra naxíka xíꞌin ra va̱xi na no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Kúndáꞌví ní ini i̱ xíni i̱ ni̱vi, chi xa u̱ni̱ ki̱vi̱ ndóo na yóꞌo ta o̱n ko̱ó ña kuxu na. ");
INSERT INTO mim_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Xíꞌi̱ ní na so̱ko, ta o̱n xi̱in i̱ tiꞌví i̱ na noꞌo̱ na ko̱to̱ kivi̱ ndu̱ú na yichi̱, chi sava na ki̱xi na xíká ní ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ta nda̱kuii̱n naxíka xíꞌin ra: ―¿Míkía̱ sata yó si̱ta̱ va̱ꞌa kuxu ndiꞌi nani̱vi, chi vi̱chí ní káa yóꞌo? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ta ni̱nda̱ka̱ to̱ꞌon ta̱Jesús naxíka xíꞌin ra: ―¿Ndasaá si̱ta̱ va̱ꞌa kómí ndó? ―Yóo u̱xa̱ si̱ta̱ va̱ꞌa ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi kundo̱o ndiꞌi na no̱o̱ ñoꞌo̱. Ta ki̱ꞌin ra u̱xa̱ si̱ta̱ va̱ꞌa yóꞌo, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Tata Yivá yó Ndios, táxaꞌvi ñaꞌá ún ta̱xi ún ñaxíxi. Ta ta̱ꞌví ra si̱ta̱ va̱ꞌa yóꞌo, ta ta̱xi ra ña ndaꞌa̱ naxíka xíꞌin ra, ta nayóꞌo na̱taxi na ña ndaꞌa̱ ni̱vi kuxu na. ");
INSERT INTO mim_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ta yóo sava tia̱ká válí, ta ni̱ka̱ꞌa̱n ra táxaꞌvi ñaꞌá Ndios, ta ta̱xi ra rí ndaꞌa̱ naxíka xíꞌin ra ña taxi na rí ndaꞌa̱ ni̱vi kuxu na. ");
INSERT INTO mim_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ta na̱ni xi̱xi ndiꞌi ni̱vi nda̱ ni̱xaa ini na. Ta naxíka xíꞌin ta̱Jesús na̱kiꞌin na u̱xa̱ chikiva si̱ta̱ va̱ꞌa xíꞌin tia̱ká ña ki̱ndo̱o ndoso. ");
INSERT INTO mim_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ta ndiꞌi na xi̱xi yóꞌo xi̱kuu na ko̱mi̱ mil ni̱vi. Ta ta̱Jesús ni̱ka̱ꞌa̱n ra ni̱nda̱yi ra ni̱vi yóꞌo, ta kua̱noꞌo̱ na. ");
INSERT INTO mim_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ta saá nda̱a ra tón barco xíꞌin naxíka xíꞌin ra, ta kua̱ꞌa̱n ra ñii xiiña na̱ní ña Dalmanuta. ");
INSERT INTO mim_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ta nafariseo ki̱xaa̱ na no̱o̱ ta̱Jesús. Ta káꞌa̱n na to̱ꞌon kuáchí xíꞌin ra ña kóni na koto ndoso na ra, káchí na saá: ―Keꞌé ún ñii milagro ña kunda̱a̱ ini ndi̱ tá ndixa Ndios ti̱ꞌví yóꞌó. ");
INSERT INTO mim_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ta ta̱Jesús ñii kónó va̱ꞌa ta̱va ra ta̱chi̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Nda̱chun ndúkú ndóꞌó ña keꞌé i̱ ñii milagro koto ndó?, chi xa ni̱keꞌé i̱ kua̱ꞌa̱ ní milagro. Ndixa káꞌa̱n i̱ xíꞌin ndó, o̱n keꞌé ka̱ i̱ inka̱ milagro no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ta saá ta̱Jesús sa̱ndakoo ra na, ta tuku nda̱a ra tón barco, kua̱ꞌa̱n ra inka̱ xiiña no̱o̱ mi̱ni. ");
INSERT INTO mim_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ta ke̱e naxíka xíꞌin ta̱Jesús kua̱ꞌa̱n na xíꞌin tón barco yóꞌo, ta na̱ndoso na kuniꞌi na si̱ta̱ va̱ꞌa ko̱ꞌo̱n na, kuiti ñii la̱á si̱ta̱ va̱ꞌa nákaa̱ ndíso na kua̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Koto va̱ꞌa ndó, o̱n nakiꞌin ndó levadura nafariseo, xíꞌin levadura ta̱Herodes ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ta ni̱ka̱ꞌa̱n naxíka xíꞌin ra xíꞌin táꞌan na, káchí na saá: ―Káꞌa̱n ra saá xíꞌin yó chi o̱n ko̱ó si̱ta̱ va̱ꞌa níꞌi yó. ");
INSERT INTO mim_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ta ku̱nda̱a̱ ini ta̱Jesús yukía̱ ni̱ka̱ꞌa̱n xíꞌin táꞌan na, ta káchí ra saá xíꞌin na: ―¿Nda̱chun káꞌa̱n xíꞌin táꞌan ndó: “O̱n ko̱ó si̱ta̱ va̱ꞌa níꞌi yó”, káchí ndó? ¿Án o̱n vása xíni̱ ndó, ta kúnda̱a̱ ini ndó? ¿Nda̱chun toon ní ini ndó ta o̱n xi̱in ndó kandixa ndó? ");
INSERT INTO mim_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yóo nduchu̱ no̱o̱ ndó ta o̱n vása xíto ndó. Yóo so̱ꞌo ndó ta o̱n vása xíni̱ so̱ꞌo ndó. ¿Án o̱n vása nákáꞌán ndó ña xi̱ni ndó? ");
INSERT INTO mim_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tá ta̱ꞌví i̱ o̱ꞌo̱n si̱ta̱ va̱ꞌa ña xi̱xi o̱ꞌo̱n mil ni̱vi, ¿ndasaá chikiva sa̱kutú ndó si̱ta̱ va̱ꞌa ña ki̱ndo̱o ndoso na̱kiꞌin ndó? ―U̱xu̱ o̱vi̱ chikiva si̱ta̱ va̱ꞌa na̱kiꞌin ndi̱ ―káchí na, nda̱kuii̱n na. ");
INSERT INTO mim_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Tá ta̱ꞌví i̱ u̱xa̱ si̱ta̱ va̱ꞌa xa̱ꞌa̱ na ko̱mi̱ mil ni̱vi, ¿ndasaá chikiva sa̱kutú ndó si̱ta̱ va̱ꞌa ña ki̱ndo̱o ndoso na̱kiꞌin ndó? ―káchí ra. Ta nda̱kuii̱n na: ―U̱xa̱ chikiva na̱kiꞌin ndi̱. ");
INSERT INTO mim_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta saá ni, ¿án nda̱ vitin o̱n ki̱ví kunda̱a̱ ini ndó? ");
INSERT INTO mim_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ta ki̱xaa̱ na ñoo Betsaida, ta ñii ta̱a ta̱kuáá nduchu̱ no̱o̱ kua̱ꞌa̱n ra xíꞌin ni̱vi, ta ki̱xaa̱ na no̱o̱ ta̱Jesús, ta xa̱ku ndáꞌví na no̱o̱ ra ña to̱nda̱a ndaꞌa̱ ra ta̱kuáá ña nakoto nduchu̱ no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ta ta̱Jesús ti̱in ra ndaꞌa̱ ta̱kuáá ta kua̱ꞌa̱n ra xíꞌin ra, ke̱e ra nda̱ no̱o̱ ñoo loꞌo yóꞌo. Tá chi̱nóo ta̱Jesús tási̱i yuꞌu̱ ra nduchu̱ no̱o̱ ta̱kuáá, ta chi̱nóo ra ndaꞌa̱ ra sa̱ta̱ ta̱yóꞌo, ta ni̱nda̱ka̱ to̱ꞌon ta̱Jesús ra: ―¿Án xa va̱ꞌa xíto ún vitin? ");
INSERT INTO mim_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ta nda̱níꞌi ra no̱o̱ ra xíto ra, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Xíto i̱ nata̱a, nda̱tán káa yito̱n saá káa na, ta xíka na ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ta tuku ni̱to̱nda̱a ndaꞌa̱ ta̱Jesús sa̱ta̱ nduchu̱ no̱o̱ ta̱yóꞌo. Ta ni̱xo̱na̱ nduchu̱ no̱o̱ ra, ta ndu̱va̱ꞌa ra, ta̱nda̱ va̱ꞌa xíto káxín ra ndiꞌi ña yóo. ");
INSERT INTO mim_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ta ta̱Jesús ti̱ꞌví ra ta̱yóꞌo kua̱noꞌo̱ ra veꞌe ra, ta káchí ra saá xíꞌin ra: ―O̱n ki̱ꞌvi ún ñoo loꞌo yóꞌo, ta o̱n ndato̱ꞌon ún xíꞌin ni̱vi ndasaá nda̱ꞌa ún. ");
INSERT INTO mim_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ta ke̱e ta̱Jesús kua̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra ñii xiiña no̱o̱ yóo yatin ñoo Cesarea Filipo. Tá kua̱ꞌa̱n ra yichi̱, ni̱nda̱ka̱ to̱ꞌon ra naxíka xíꞌin ra: ―¿Yukía̱ káchí ni̱vi xa̱ꞌa̱ i̱ yu kúu i̱? ");
INSERT INTO mim_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ta nda̱kuii̱n na, káchí na saá: ―Sava ni̱vi káꞌa̱n yóꞌó kúu ún ta̱Juan ta̱ sa̱kuchu ni̱vi. Sava na káꞌa̱n yóꞌó kúu ún ta̱profeta Elías, ta inka̱ na káꞌa̱n yóꞌó kúu ún inka̱ ta̱profeta ta̱ xi̱taku̱ xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ta ni̱nda̱ka̱ to̱ꞌon ra na: ―Ta mi̱i ndó, ¿yukía̱ káchí ndó yu kúu i̱? Ta nda̱kuii̱n ta̱Pedro, ni̱ka̱ꞌa̱n ra: ―Yóꞌó kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ni̱vi ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta o̱n ka̱ꞌa̱n ndó xíꞌin nda̱ ñii ni̱vi yu kúu i̱. ");
INSERT INTO mim_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ta saá ki̱xáꞌá ta̱Jesús ndáto̱ꞌon ra xíꞌin naxíka xíꞌin ra ki̱vi̱ va̱xi naxi̱kua̱ꞌa̱ no̱o̱ najudío, xíꞌin na sánáꞌa nda̱yí Ndios xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ o̱n kuaꞌa na kandixa na ra ta saxo̱ꞌvi̱ ní na ra. Ta kaꞌni na ra, ta ki̱vi̱ u̱ni̱ nataku̱ ra, keꞌé Ndios. ");
INSERT INTO mim_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ta ni̱ka̱ꞌa̱n káxín ra xíꞌin na xa̱ꞌa̱ ña xo̱ꞌvi̱ ra. Ta ta̱Pedro ta̱va síín ra ta̱Jesús, ta ki̱xáꞌá ni̱na̱a ra xíꞌin ta̱Jesús xa̱ꞌa̱ ña ni̱ka̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ta ndi̱kó koo ta̱Jesús xíto ra no̱o̱ naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Pedro, káchí ra saá: ―¡Kutaꞌa ún no̱o̱ i̱, ñandiva̱ꞌa káꞌno! Ta yóꞌó ta̱Pedro o̱n vása xáni ini ún nda̱tán xáni ini Ndios. Ta kuiti xáni ini ún nda̱tán xáni ini ni̱vi ―káchí ta̱Jesús xíꞌin ta̱Pedro. ");
INSERT INTO mim_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ta saá ka̱na ta̱Jesús ndiꞌi ni̱vi va̱xi na no̱o̱ ra, ta ka̱na ra naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ndiꞌi ni̱vi na kóni kundiko̱n yi̱ꞌi̱ xíni̱ ñóꞌó sandakoo na ndiꞌi ña káchí ini mi̱i na, ta kuso̱kó na tón cruz mi̱i na ta kundiko̱n na sa̱ta̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ndiꞌi ni̱vi na ndasaá kuiti ndúkú ña kutaku̱ va̱ꞌa na ñoyívi yóꞌo, ta o̱n xi̱in na xo̱ꞌvi̱ na xa̱ꞌa̱ i̱, ta nayóꞌo o̱n kuchiño na kutaku̱ na xíꞌin Ndios. Ta ni̱vi na o̱n vása ndíꞌi ini ndukú kutaku̱ va̱ꞌa na ñoyívi yóꞌo, xa̱ꞌa̱ ña kundiko̱n na yi̱ꞌi̱ ta ndato̱ꞌon na to̱ꞌon i̱ xíꞌin ni̱vi, nayóꞌo kúu ni̱vi na kutaku̱ xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tá kómí ni̱vi ndiꞌi ñakuíká ñoyívi yóꞌo, ta o̱n vása táku̱ ndinoꞌo na no̱o̱ Ndios, ta nda̱ ma̱ni̱ kúu ña. ");
INSERT INTO mim_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Saá chi o̱n kuchiño na chaꞌvi na xíꞌin ndiꞌi ñakuíká kómí na xa̱ꞌa̱ ña kutaku̱ na xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kua̱ꞌa̱ ní ni̱vi na táku̱ vitin kúu na o̱n váꞌa, na o̱n vása kándixa Ndios. Ta saá tá yóo ni̱vi na kúkaꞌan no̱o̱ xa̱ꞌa̱ yi̱ꞌi̱ xíꞌin xa̱ꞌa̱ to̱ꞌon i̱ no̱o̱ inka̱ ni̱vi, ta saá yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, kukaꞌan no̱o̱ i̱ xa̱ꞌa̱ nayóꞌo no̱o̱ Ndios ki̱vi̱ ña ndikó i̱ ñoyívi yóꞌo xíꞌin ndiꞌi ndee̱ ña va̱ꞌa ña yéꞌe ña kómí Yivá i̱ Ndios, ta kixaa̱ naángel yi̱i̱ xíꞌin i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, sava ndóꞌó na ndóo vitin, kutaku̱ ka̱ ndó ña kivi koni ndó ña xáꞌnda chiño Ndios xíꞌin ndee̱ káꞌno ra ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ni̱yaꞌa i̱ño̱ ki̱vi̱ ta ta̱Jesús na̱ka̱xin ra u̱ni̱ ta̱xíka xíꞌin ra, ta̱Pedro, ta̱Jacobo xíꞌin ta̱Juan, ta kua̱ꞌa̱n na xíꞌin ra ñii yuku̱ síkón. Ta kán xi̱ni na na̱sama no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ta na̱taxa tiko̱to̱ ra, ndu̱u yaa ka̱chi̱ ña, ta nda̱ ñii ni̱vi ñoyívi yóꞌo o̱n kívi nakata na tiko̱to̱ ña yaa ní nda̱tán yóo tiko̱to̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ta saá ni̱ti̱vi ta̱Moisés xíꞌin ta̱Elías, ndáto̱ꞌon na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ta ni̱ka̱ꞌa̱n ta̱Pedro xíꞌin ta̱Jesús: ―Tata Maestro, va̱ꞌa ní ndóo yó yóꞌo. Va̱ꞌa ná kasa va̱ꞌa ndi̱ u̱ni̱ tia̱ꞌva, ñii ña koo mi̱i ún, ñii ña koo ta̱Moisés, ta inka̱ ña koo ta̱Elías ―káchí ta̱Pedro xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ni̱ka̱ꞌa̱n ta̱Pedro saá chi o̱n vása kúnda̱a̱ ini ra yukía̱ ka̱ꞌa̱n ra, chi na yíꞌví ní kúu u̱ni̱ na saá. ");
INSERT INTO mim_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ta no̱o ñii vi̱ko̱ chée nda̱ no̱o̱ yíta nata̱a yóꞌo, ta ni̱saꞌvi na ti̱xin vi̱ko̱, ta ti̱xin vi̱ko̱ yóꞌo ki̱xi to̱ꞌon ña ni̱ka̱ꞌa̱n Ndios, káchí ra saá: ―Ta̱yóꞌo kúu Sa̱ꞌya i̱, ta̱ kíꞌvi ní ini i̱ xíni i̱. Ta koni̱ so̱ꞌo va̱ꞌa ndó to̱ꞌon ña ka̱ꞌa̱n ra ―káchí Ndios. ");
INSERT INTO mim_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ta na̱koto na, ta xa̱ndi̱ko̱n nda̱ ñii ni̱vi ni̱‑xini ka̱ na, nda̱ ñii la̱á kuiti ta̱Jesús ñíndichi no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ta va̱xi noo na yuku̱ yóꞌo, ta ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ na ña o̱n ndato̱ꞌon na xíꞌin nda̱ ñii ni̱vi xa̱ꞌa̱ ña sa̱kán xi̱ni na. Tá kixaa̱ ki̱vi̱ kivi̱ ra ta nataku̱ ra, saá kivi ndato̱ꞌon na xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ta chi̱kaa̱ va̱ꞌa na ña xi̱ni na ini mi̱i na, ta o̱n vása ní‑ndato̱ꞌon na ñayóꞌo xíꞌin inka̱ ni̱vi. Ta ni̱nda̱ka̱ to̱ꞌon xíꞌin táꞌan na yukía̱ káchí ña “nataku̱ ra.” ");
INSERT INTO mim_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ta ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ―¿Nda̱chun káꞌa̱n na sánáꞌa nda̱yí Ndios ndí siꞌna xíni̱ ñóꞌó kixi ta̱Elías, ta saá kixaa̱ ta̱a ta̱ tiꞌví Ndios saka̱ku ra ni̱vi ñoyívi yóꞌo? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ta nda̱kuii̱n ta̱Jesús: ―Ndixa ta̱Elías siꞌna xíni̱ ñóꞌó kixaa̱ ra, ta ndasa va̱ꞌa ra ndiꞌi ña̱ꞌa. Ta, ¿nda̱chun káchí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá, ta̱a ta̱ kixi no̱o̱ Ndios xíni̱ ñóꞌó xo̱ꞌvi̱ ní ra ta nani̱vi kuchiton na ra? ");
INSERT INTO mim_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ta yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ndó, xa ki̱xi ta̱Elías, ta ke̱ꞌé na xíꞌin ra ndiꞌi ña o̱n váꞌa káchí ini mi̱i na, nda̱tán káchí to̱ꞌon Ndios ña ni̱taa na xa̱ꞌa̱ ra kui̱ya̱ xi̱na̱ꞌá ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ta ki̱xaa̱ ta̱Jesús xíꞌin u̱ni̱ ta̱xíka xíꞌin ra no̱o̱ ndóo inka̱ naxíka xíꞌin ra, ta xi̱ni ra na̱kutáꞌan kua̱ꞌa̱ ní ni̱vi no̱o̱ na, ta na sánáꞌa nda̱yí Ndios náa na xíꞌin naxíka xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ta ni̱vi xi̱ni na ta̱Jesús, na̱kaꞌnda ini na, ta xíno na ni̱xaa̱ na no̱o̱ ra chindeé ñaꞌá na. ");
INSERT INTO mim_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra ni̱vi yóꞌo: ―¿Yukía̱ náa ndó xa̱ꞌa̱ xíꞌin na? ");
INSERT INTO mim_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ta ñii ta̱táꞌan nani̱vi yóꞌo nda̱kuii̱n ra: ―Tata maestro, ki̱xaa̱ i̱ xíꞌin ta̱loꞌo sa̱ꞌya i̱ no̱o̱ ún, chi níma̱ ndiva̱ꞌa tíin ní ña ra ta o̱n ki̱ví ka̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tá tíin ña ra sákana ña ra no̱o̱ ñoꞌo̱, kée chikiño yuꞌu̱ ra, a̱nda̱ nákaxi no̱ꞌo ra, ta ndaꞌa̱ ra xíꞌin xa̱ꞌa̱ ra ñii kútoon ña ta kísin ña. Xa ni̱ndukú i̱ no̱o̱ naxíka xíꞌin ún ña tava na níma̱ ndiva̱ꞌa yóꞌo, ta o̱n vása ní‑kuchiño na ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―¡Ni̱vi na o̱n xi̱in kandixa Ndios kúu ndóꞌó! ¿Ndasaá ka̱ ki̱vi̱ xíni̱ ñóꞌó kutaku̱ i̱ xíꞌin ndó? ¿Nda̱ ama kundeé ini i̱ xíꞌin ndó? Ta vitin, va̱ꞌa taxi ndó ná kixi ta̱loꞌo yóꞌo no̱o̱ i̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ta ki̱xaa̱ ta̱loꞌo no̱o̱ ta̱Jesús. Tá níma̱ ndiva̱ꞌa xi̱ni ña ta̱Jesús, ta xa̱ndi̱ko̱n ti̱in ña ta̱loꞌo, ta kini ní sa̱kisin ña ra, ta na̱kava ra no̱o̱ ñoꞌo̱ ta ki̱xáꞌá ra kée ndaꞌa̱ ra, kée xa̱ꞌa̱ ra. Ta kée chikiño yuꞌu̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra yivá ta̱loꞌo: ―¿Ama ki̱xáꞌá ra ndóꞌo ra kue̱ꞌe̱ yóꞌo? Ta ni̱ka̱ꞌa̱n yivá ta̱loꞌo: ―Ki̱xáꞌá ña xíꞌin ra nda̱ loꞌo ra. ");
INSERT INTO mim_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kua̱ꞌa̱ ní yichi̱ sákana ña ra no̱o̱ xíxi̱ ñoꞌo̱, ta kua̱ꞌa̱ ní yichi̱ sákana ña ra ini takuií, chi kóni ña kaꞌni ña ra. Tá kúchiño ún, ta chindeé ún ndi̱ꞌi̱. Kundáꞌví ini ún koni ún ndi̱ꞌi̱, ta sandaꞌa ún ra ―káchí yivá ta̱loꞌo. ");
INSERT INTO mim_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ta ni̱ka̱ꞌa̱n ta̱Jesús: ―¿Nda̱chun káꞌa̱n ún, án kúchiño i̱? Ta mi̱i ún, ¿án kúchiño ún kandixa ún Ndios? Chi xíꞌin ni̱vi na kándixa, ta Ndios kúchiño ra kasa ndivi ra ndiꞌi saá no̱o̱ ñava̱ꞌa xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ta xa̱ndi̱ko̱n yivá ta̱loꞌo ni̱ka̱ꞌa̱n ra: ―Kándixa i̱ Ndios. Chindeé ún yi̱ꞌi̱ ná kandixa ka̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ta xi̱ni ta̱Jesús kua̱ꞌa̱ ní ka̱ ni̱vi xíno na kixaa̱ na no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin níma̱ ndiva̱ꞌa, káchí ra saá: ―Níma̱ sóꞌó, níma̱ ñíꞌí, yi̱ꞌi̱ xáꞌnda chiño i̱ no̱o̱ ún, kee ún ta̱loꞌo ta o̱n tiin ka̱ ún ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ta ni̱nda̱ꞌyi níma̱ ndiva̱ꞌa, ta tuku sa̱kisin ña ra ta sa̱kana ña ta̱loꞌo no̱o̱ ñoꞌo̱, ta saá ke̱e ña ra. Nda̱tán káa ta̱ ni̱xiꞌi̱, saá káa ta̱loꞌo kándúꞌu̱ ra, ta kua̱ꞌa̱ ní ni̱vi ni̱ka̱ꞌa̱n na: ―Ni̱xiꞌi̱ ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ta ta̱Jesús ti̱in ra ndaꞌa̱ ta̱loꞌo ta nda̱níꞌi ñaꞌá ra, ta na̱kundichi ta̱loꞌo. ");
INSERT INTO mim_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tá ni̱ki̱ꞌvi ta̱Jesús veꞌe, ta naxíka xíꞌin ra ni̱nda̱ka̱ to̱ꞌon seꞌé na ra: ―¿Nda̱chun o̱n vása ní‑kuchiño ndi̱ tava ndi̱ níma̱ ndiva̱ꞌa yóꞌo? ");
INSERT INTO mim_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Saá chi ñaníma̱ ndiva̱ꞌa táꞌan ña xi̱komí ta̱loꞌo yóꞌo, xíni̱ ñóꞌó koo soꞌon ndó ta ka̱ꞌa̱n ní ndó xíꞌin Ndios, saá kuchiño tava ndó ña ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ta ta̱Jesús xíꞌin naxíka xíꞌin ra ke̱e na ñoo yóꞌo ta ni̱yaꞌa na ñii xiiña estado Galilea. Ta ta̱Jesús ni̱‑xiin ra ña kunda̱a̱ ini ni̱vi míchí kua̱ꞌa̱n ra, ");
INSERT INTO mim_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","saá chi xíni̱ ñóꞌó sanáꞌa ra naxíka xíꞌin ra, ta ki̱xáꞌá ra káꞌa̱n ra xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Ñii ki̱vi̱ ña va̱xi ñii ta̱a nataxi ra yi̱ꞌi̱, ta̱ kúu ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndaꞌa̱ ni̱vi. Ta nayóꞌo kaꞌni na yi̱ꞌi̱, ta to̱nda̱a ki̱vi̱ u̱ni̱ nataku̱ i̱, keꞌé Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ta naxíka xíꞌin ra o̱n vása ní‑kunda̱a̱ ini na yukía̱ káchí to̱ꞌon ña ni̱ka̱ꞌa̱n ra xíꞌin na, ta yíꞌví na nda̱ka̱ to̱ꞌon na ra yukía̱ kóni kachí ña káꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ta ki̱xaa̱ ta̱Jesús xíꞌin naxíka xíꞌin ra ñoo Capernaum. Ta yóo ta̱Jesús veꞌe, ta ni̱nda̱ka̱ to̱ꞌon ra na: ―¿Yukía̱ náa ndó xa̱ꞌa̱ va̱xi yó yichi̱? ");
INSERT INTO mim_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ta nayóꞌo tási̱ín ndóo na, o̱n vása ndákuii̱n na, chi yichi̱ ni̱na̱a na xíꞌin táꞌan na xa̱ꞌa̱ yu kúu ta̱ káꞌno ka̱ no̱o̱ ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ta xi̱koo ta̱Jesús no̱o̱ táyi̱, ta ka̱na ra u̱xu̱ o̱vi̱ naxíka xíꞌin ra va̱xi na no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Tá ñii ta̱a kóni ra kuu ra ta̱káꞌno, xíni̱ ñóꞌó nduu ra ta̱ kísa ni̱no̱ xíꞌin mi̱i, ta kuu ra ta̱ kísa chiño no̱o̱ inka̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ta ka̱na ra ñii ta̱loꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ra nakundichi ra ma̱ꞌñó no̱o̱ naxíka xíꞌin ra. Ta nda̱níꞌi ra ta̱loꞌo yóꞌo ta xi̱nomi ndaa ñaꞌá ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ");
INSERT INTO mim_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Ndiꞌi ni̱vi xa̱ꞌa̱ ña kándixa na yi̱ꞌi̱, ta nákiꞌin va̱ꞌa na naválí, kóni kachí ña saá: ndí yi̱ꞌi̱ nákiꞌin va̱ꞌa na. Ta ndiꞌi ni̱vi na nákiꞌin va̱ꞌa yi̱ꞌi̱, kóni kachí ña saá: ndí nákiꞌin va̱ꞌa na Ndios, ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ta ni̱ka̱ꞌa̱n ta̱Juan xíꞌin ta̱Jesús: ―Tata Maestro, xi̱ni ndi̱ ñii ta̱a táva ra níma̱ ndiva̱ꞌa. Xáꞌnda chiño ra no̱o̱ níma̱ ndiva̱ꞌa xíꞌin nda̱yí ún, káchí ra. Ta ni̱ka̱ꞌa̱n ndi̱ xíꞌin ra sandakoo ra ña kéꞌé ra saá, chi o̱n si̱ví ta̱ ndíko̱n sa̱ta̱ ún xíꞌin ndi̱ kúu ra. ");
INSERT INTO mim_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―O̱n kasi ndó no̱o̱ ra, chi yóo yuꞌú ta̱kán xíꞌin mi̱i yó. Nda̱ ñii ni̱vi na kéꞌé milagro xíꞌin inka̱ ni̱vi ta xáꞌnda chiño na xíꞌin nda̱yí i̱, o̱n ki̱ví kama ní ka̱ꞌa̱n na ña o̱n váꞌa xa̱ꞌa̱ i̱, ");
INSERT INTO mim_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","chi ni̱vi na o̱n vása sáa̱ ini xíni mi̱i yó, nayóꞌo kúu na yóo yuꞌú xíꞌin mi̱i yó. ");
INSERT INTO mim_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ndixa káꞌa̱n i̱ xíꞌin ndó, ndiꞌi ni̱vi na táxi loꞌo takuií koꞌo ñii ndóꞌó, chi ndíko̱n ndó yi̱ꞌi̱ ta̱ kúu Cristo, nayóꞌo nakiꞌin na ñava̱ꞌa ndaꞌa̱ Ndios ki̱vi̱ ña va̱xi ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús saá xíꞌin na: ―Tá yóo nakuálí na ndíko̱n yi̱ꞌi̱, ta ni̱vi na chíndaꞌá nakuálí yóꞌo ki̱ꞌvi na kua̱chi, ¡ndáꞌví ní ni̱vi yóꞌo! Va̱ꞌa ka̱ siꞌna inka̱ ni̱vi ná katón na ñii yu̱u̱ káꞌno si̱ko̱n nayóꞌo, ta sakana ñaꞌá na no̱o̱ kónó va̱ꞌa ini takuií, ña o̱n chindaꞌá na nakuálí ki̱ꞌvi na kua̱chi. ");
INSERT INTO mim_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tá ñii ndaꞌa̱ ndó kúu ña chíndaꞌá ndóꞌó kua̱n ki̱ꞌvi ndó kua̱chi, ta saá va̱ꞌa ka̱ kandoso ndó ña. Chi va̱ꞌa ka̱ kutaku̱ ndó xíꞌin ñii la̱á ndaꞌa̱ ndó, no̱o̱ ña ko̱ꞌo̱n ndó xíꞌin o̱vi̱ ndaꞌa̱ ndó nda̱ya no̱o̱ xíxi̱ ñoꞌo̱ ndiꞌi saá ki̱vi̱, ");
INSERT INTO mim_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","no̱o̱ o̱n vása xíꞌi̱ títikusú, ta ni o̱n vása ndáꞌva̱ ñoꞌo̱ ña xíxi̱. ");
INSERT INTO mim_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tá ñii xa̱ꞌa̱ ndó kúu ña chíndaꞌá ndóꞌó kua̱n ki̱ꞌvi ndó kua̱chi, ta saá va̱ꞌa ka̱ kandoso ndó ña. Chi va̱ꞌa ka̱ kutaku̱ ndó xíꞌin ñii la̱á xa̱ꞌa̱ ndó, no̱o̱ ña ko̱ꞌo̱n ndó xíꞌin o̱vi̱ xa̱ꞌa̱ ndó nda̱ya no̱o̱ xíxi̱ ñoꞌo̱ ndiꞌi saá ki̱vi̱, ");
INSERT INTO mim_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","no̱o̱ o̱n vása xíꞌi̱ títikusú, ta ni o̱n vása ndáꞌva̱ ñoꞌo̱ ña xíxi̱. ");
INSERT INTO mim_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tá ñii nduchu̱ no̱o̱ ndó kúu ña chíndaꞌá ndóꞌó kua̱n ki̱ꞌvi ndó kua̱chi, ta va̱ꞌa ka̱ tava ndó ña. Chi va̱ꞌa ka̱ kutaku̱ ndó xíꞌin ñii la̱á nduchu̱ no̱o̱ ndó, no̱o̱ ña ko̱ꞌo̱n ndó xíꞌin o̱vi̱ nduchu̱ no̱o̱ ndó nda̱ya, ");
INSERT INTO mim_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","no̱o̱ o̱n vása xíꞌi̱ títikusú, ta ni o̱n vása ndáꞌva̱ ñoꞌo̱ ña xíxi̱. ");
INSERT INTO mim_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ta saá ndiꞌi na kóni ko̱ꞌo̱n yichi̱ Ndios xíni̱ ñóꞌó koo tiꞌva na ña xo̱ꞌvi̱ loꞌo na vitin ña nduu na nandii no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ña va̱ꞌa kúu ñi̱i̱ yo̱ꞌva̱. Tá yóo ñi̱i̱ ña o̱n vása yo̱ꞌva̱, ta o̱n kúchiño ka̱ nduva̱ꞌa ña. Ndixa xíni̱ ñóꞌó kuu ndó ni̱vi na va̱ꞌa nda̱tán yóo ñi̱i̱ yo̱ꞌva̱, ta xíni̱ ñóꞌó keꞌé ndó ñava̱ꞌa xíꞌin ni̱vi, ta vivíi kutaku̱ ndó xíꞌin ndiꞌi na ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ta ta̱Jesús ke̱e ra ñoo Capernaum ta kua̱ꞌa̱n ra estado Judea ta ni̱xaa̱ ra inka̱ táꞌví yuꞌu̱ yu̱ta Jordán. Tuku na̱kutáꞌan kua̱ꞌa̱ ní ni̱vi no̱o̱ ra, ta nda̱tán yóo chiño kéꞌé ra ndiꞌi saá ki̱vi̱, tuku sánáꞌa ra ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ta sava nafariseo ki̱xaa̱ na no̱o̱ ra ña koto ndoso ñaꞌá na, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―¿Án yóo yichi̱ ñii ta̱a sandakoo va̱ꞌa ra ñásíꞌí ra? ");
INSERT INTO mim_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―¿Yukía̱ káꞌa̱n nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá? ");
INSERT INTO mim_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ta ni̱ka̱ꞌa̱n na: ―Ta̱Moisés ta̱xi ra nda̱yí ndaꞌa̱ ta̱a ña kasa va̱ꞌa ra tutu xa̱ꞌa̱ ña sandakoo va̱ꞌa ra ñásíꞌí ra, ta ka̱ꞌa̱n ra xíꞌin ñá nda̱yi ra ñá ko̱ꞌo̱n ñá. ");
INSERT INTO mim_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ta nda̱kuii̱n ta̱Jesús: ―Ta̱Moisés ni̱taa ra nda̱yí yóꞌo chi ndóꞌó najudío ni̱‑xiin ndó chikaa̱ ndó to̱ꞌon Ndios ini ndó. ");
INSERT INTO mim_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ta xi̱na̱ꞌá ki̱vi̱ ki̱xáꞌá kísa va̱ꞌa Ndios ñoyívi yóꞌo, ki̱sa va̱ꞌa ra ñii ta̱a xíꞌin ñii ñaꞌa̱. ");
INSERT INTO mim_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Xa̱ꞌa̱ ñayóꞌo ñii ta̱a sandakoo ra yivá ra ta sandakoo ra siꞌí ra ña tonda̱ꞌa̱ ra xíꞌin ñásíꞌí ra, ");
INSERT INTO mim_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ta na o̱vi̱ yóꞌo nduu na ñii ni̱vi. Ta saá, o̱n si̱ví ka̱ o̱vi̱ ni̱vi kúu na, saá chi ñii ni̱vi kúu na no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ta ni̱vi na sa̱nakutáꞌan Ndios, nda̱ ñii inka̱ ni̱vi o̱n váꞌa sataꞌví táꞌan na nayóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ta ni̱ki̱ꞌvi na veꞌe, ta naxíka xíꞌin ta̱Jesús tuku ni̱nda̱ka̱ to̱ꞌon ñaꞌá na xa̱ꞌa̱ to̱ꞌon yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ta nda̱kuii̱n ta̱Jesús: ―Tá ñii ta̱a sandakoo va̱ꞌa ra ñásíꞌí ra, ta tonda̱ꞌa̱ tuku ra, ta̱yóꞌo ki̱ꞌvi ra kua̱chi xíꞌin ñásíꞌí ra ñáo̱vi̱. ");
INSERT INTO mim_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tá ñii ñaꞌa̱ sandakoo va̱ꞌa ñá yii̱ ñá, ta tonda̱ꞌa̱ tuku ñá, ñáyóꞌo ki̱ꞌvi ñá kua̱chi xíꞌin yii̱ ñá ta̱o̱vi̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ta ki̱xaa̱ ni̱vi xíꞌin naválí no̱o̱ yóo ta̱Jesús ña chinóo ra ndaꞌa̱ ra si̱ni̱ na, ta ndukú ra ñava̱ꞌa no̱o̱ Ndios xa̱ꞌa̱ na, ta naxíka xíꞌin ra ni̱ka̱ꞌa̱n na xíꞌin ni̱vi yóꞌo: ―O̱n kixi ndó xíꞌin naválí yóꞌo ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tá xi̱ni̱ so̱ꞌo ta̱Jesús ña ni̱ka̱ꞌa̱n naxíka xíꞌin ra, ta ni̱saa̱ ra xa̱ꞌa̱ ñayóꞌo. Ta ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra: ―Taxi ndó naválí ná kixi na no̱o̱ i̱, nda̱ loꞌo o̱n kasi ndó na ña kixi na, chi ni̱vi na ndíko̱n yichi̱ no̱o̱ xáꞌnda chiño Ndios, nda̱tán yóo naválí yóꞌo, saá yóo na. ");
INSERT INTO mim_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ndixa káꞌa̱n i̱ xíꞌin ndó, tá o̱n xi̱in ndó kasa ni̱no̱ xíꞌin mi̱i ndó no̱o̱ Ndios, nda̱tán ni̱no̱ yóo ini naválí yóꞌo, ta o̱n kívi ki̱ꞌvi ndó yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ta nda̱níꞌi ra ta xi̱nomi ndaa ra ñii ñii naválí yóꞌo, ta chi̱nóo ra ndaꞌa̱ ra si̱ni̱ na ta ndu̱kú ra ñava̱ꞌa no̱o̱ Ndios xa̱ꞌa̱ na. ");
INSERT INTO mim_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tá na̱kiꞌin ta̱Jesús kua̱ꞌa̱n ra, ta ñii ta̱a xíno ra ki̱xaa̱ ra no̱o̱ ta̱Jesús, ta xi̱kuxítí ra no̱o̱ ra, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá ra: ―Tata maestro, ta̱a va̱ꞌa ini kúu ún, ¿ndá chiño va̱ꞌa xíni̱ ñóꞌó keꞌé i̱, ta taxi Ndios ña kutaku̱ i̱ xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi? ");
INSERT INTO mim_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ta nda̱kuii̱n ta̱Jesús: ―¿Nda̱chun káꞌa̱n ún yi̱ꞌi̱ kúu ta̱a ta̱ va̱ꞌa ini? Saá chi o̱n ko̱ó nda̱ ñii ni̱vi va̱ꞌa ini, ñii la̱á Ndios kuiti kúu ta̱ va̱ꞌa ndinoꞌo ini. ");
INSERT INTO mim_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xíni̱ ún nda̱yí ña xa̱ꞌnda chiño Ndios kasa ndivi ni̱vi. Ka̱chí Ndios xíꞌin ni̱vi saá: “O̱n ki̱ꞌvi ndó kua̱chi ñoyívi xíꞌin inka̱ ñaꞌa̱ ñá o̱n si̱ví kúu ñásíꞌí ndó, ta o̱n ki̱ꞌvi ndó kua̱chi ñoyívi xíꞌin ta̱a ta̱ o̱n si̱ví kúu yii̱ ndó, o̱n kaꞌni ndó ni̱vi, o̱n kasa kuíꞌná ndó ña kómí ni̱vi, o̱n ka̱ꞌa̱n ndó ñavatá xa̱ꞌa̱ inka̱ ni̱vi, o̱n sandáꞌví ndó ni̱vi ña kindaa ndó ña kómí na, ta kasa to̱ꞌó ndó yivá ndó, ta kasa to̱ꞌó ndó siꞌí ndó”, saá káchí nda̱yí Ndios ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ta ni̱ka̱ꞌa̱n ta̱yóꞌo: ―Yi̱ꞌi̱ nda̱ loꞌo i̱ kísa ndivi i̱ ndiꞌi saá nda̱yí yóꞌo ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ndi̱ꞌi xi̱ni̱ so̱ꞌo ta̱Jesús ta xi̱to káxín ra no̱o̱ ta̱yóꞌo xa̱ꞌa̱ ña nda̱to̱ꞌon ra, ta ni̱kiꞌvi ini ta̱Jesús xíni ñaꞌá ra. ―Kúma̱ni̱ inka̱ chiño kasa ndivi ún. Kua̱ꞌa̱n ún si̱kó ún ndiꞌi ñakuíká kómí ún, ta saníꞌi ún si̱ꞌún ndaꞌa̱ nandáꞌví. Ta saá kukomí ún ñakuíká ndinoꞌo xíꞌin Ndios ñoyívi ni̱no. Tá ndi̱ꞌi ke̱ꞌé ún ñava̱ꞌa yóꞌo, ta kixi ún kundiko̱n ún yi̱ꞌi̱, ta koo tiꞌva ún xo̱ꞌvi̱ ún xa̱ꞌa̱ i̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ta xi̱ni̱ so̱ꞌo ta̱yóꞌo ña ni̱ka̱ꞌa̱n ta̱Jesús, ta kúchuchú ní ini ra. Ta ke̱e ra kua̱ꞌa̱n ra, saá chi kua̱ꞌa̱ ní ñakuíká kómí ra. ");
INSERT INTO mim_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ta ta̱Jesús xíto ra no̱o̱ ndiꞌi naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¡Nda̱chun yo̱ꞌvi̱ ní ki̱ꞌvi nakuíká yichi̱ no̱o̱ xáꞌnda chiño Ndios! ");
INSERT INTO mim_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Naxíka xíꞌin ra na̱kaꞌnda ini na xi̱ni̱ so̱ꞌo na to̱ꞌon yóꞌo. Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús: ―¡Nda̱chun yo̱ꞌvi̱ ní ki̱ꞌvi ni̱vi yichi̱ no̱o̱ xáꞌnda chiño Ndios xa̱ꞌa̱ ña ndáa ní ini na ñakuíká na! ");
INSERT INTO mim_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Vará yo̱ꞌvi̱ ní tá kuchiño ñii tícamello yaꞌa rí yavi̱ xa̱ꞌa̱ túkú, ta yo̱ꞌvi̱ ní ka̱ kuchiño yaꞌa ñii ta̱kuíká yéꞌé ña ki̱ꞌvi ra yichi̱ no̱o̱ xáꞌnda chiño Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ta naxíka xíꞌin ra na̱kaꞌnda ní ka̱ ini na, ta ni̱ka̱ꞌa̱n xíꞌin táꞌan na: ―Tá yo̱ꞌvi̱ ní ki̱ꞌvi nakuíká yichi̱ Ndios, ta, ¿yu kúu ni̱vi kuchiño ki̱ꞌvi na yichi̱ Ndios ta kundo̱o na xíꞌin ra? ");
INSERT INTO mim_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ta ta̱Jesús xi̱to ra no̱o̱ na, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ni̱vi o̱n kúchiño na saka̱ku xíꞌin mi̱i na, ñii la̱á Ndios kúu ta̱ kúchiño saka̱ku ñaꞌá. Ndios kúchiño kasa ndivi ra ndiꞌi chiño. O̱n ko̱ó ña yo̱ꞌvi̱ no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ta ki̱xáꞌá ta̱Pedro ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Ta mi̱i ndi̱, xa sa̱ndakoo ndi̱ ndiꞌi ñava̱ꞌa ña xi̱komí ndi̱, xa̱ꞌa̱ ña ndíko̱n ndi̱ sa̱ta̱ ún. ");
INSERT INTO mim_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin u̱xu̱ o̱vi̱ naxíka xíꞌin ra: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, ndiꞌi ni̱vi na sa̱ndakoo veꞌe na, án ñani na, án ki̱ꞌva̱ na, án yivá na, án siꞌí na, án ñásíꞌí na, án sa̱ꞌya na, án ñoꞌo̱ na, xa̱ꞌa̱ ña kundiko̱n na yi̱ꞌi̱ ta ndato̱ꞌon na to̱ꞌon i̱ xíꞌin ni̱vi, ");
INSERT INTO mim_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ta nayóꞌo nakiꞌin na ñava̱ꞌa no̱o̱ Ndios. Ñoyívi yóꞌo Ndios taxi ra ndaꞌa̱ na kua̱ꞌa̱ ní ka̱ ñava̱ꞌa, a̱nda̱ ñii ciento ñava̱ꞌa xa̱ꞌa̱ ñii ñii ñava̱ꞌa ña sa̱ndakoo na, ña kúu veꞌe na, xíꞌin ñani na, xíꞌin ki̱ꞌva̱ na, xíꞌin siꞌí na, xíꞌin sa̱ꞌya na, xíꞌin ñoꞌo̱ na, ta taxi ra ña xo̱ꞌvi̱ na xa̱ꞌa̱ ña kundiko̱n na yi̱ꞌi̱. Ta ñoyívi ni̱no Ndios taxi ra ña kutaku̱ na xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ta saá kua̱ꞌa̱ ní ni̱vi nano̱ó nduu na ni̱vi nasondíꞌí, ta ni̱vi nasondíꞌí vitin nduu na ni̱vi nano̱ó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ta kua̱ꞌa̱n na yichi̱ kua̱n ndaa ñoo Jerusalén, ta ta̱Jesús kua̱ꞌa̱n siꞌna ra no̱o̱ nani̱vi, ta nayóꞌo na̱kaꞌnda ní ini na, ta yíꞌví na ndíko̱n na kua̱ꞌa̱n na sa̱ta̱ ra. Ta ta̱va síín ta̱Jesús na u̱xu̱ o̱vi̱ xíka xíꞌin ra, ta nda̱to̱ꞌon ra xíꞌin na yukía̱ kundoꞌo ra. ");
INSERT INTO mim_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Ta vitin kua̱ꞌa̱n yó ñoo Jerusalén, ta ñii ta̱a nataxi ra yi̱ꞌi̱, ta̱ kúu ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndaꞌa̱ nanáꞌno no̱o̱ nasu̱tu̱, xíꞌin ndaꞌa̱ na sánáꞌa nda̱yí Ndios. Ta nayóꞌo kachí na yi̱ꞌi̱ xíni̱ ñóꞌó kivi̱ i̱, ta nataxi na yi̱ꞌi̱ ndaꞌa̱ na o̱n vása kúu najudío kaꞌni na yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ta kusiki na yi̱ꞌi̱, kuaku̱ ndaa na yi̱ꞌi̱, kundaa na tási̱i yuꞌu̱ na no̱o̱ i̱, kani ní na yi̱ꞌi̱ xíꞌin kuártá, ta sondi̱ꞌi kaꞌni na yi̱ꞌi̱. Ta ki̱vi̱ u̱ni̱ nataku̱ i̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ta ta̱Jacobo xíꞌin ta̱Juan, sa̱ꞌya ta̱Zebedeo, ni̱to̱nda̱a yatin na no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tata Maestro, kóni ndi̱ keꞌé ún ñii ñava̱ꞌa xíꞌin ndi̱. ");
INSERT INTO mim_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ta nda̱kuii̱n ta̱Jesús: ―¿Ndá ñava̱ꞌa kóni ndó keꞌé i̱ xíꞌin ndó? ");
INSERT INTO mim_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ta nda̱kuii̱n na: ―Tata, tá kixaa̱ ki̱vi̱ kaꞌnda chiño ún ñoyívi, taxi ún ná koo ndi̱ táyi̱ tón kundichi sii̱n kuaꞌá ún xíꞌin táyi̱ tón kundichi sii̱n yitin ún. ");
INSERT INTO mim_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―O̱n vása kúnda̱a̱ ini ndó yukía̱ ndúkú ndó no̱o̱ i̱ xa̱ꞌa̱ mi̱i ndó. ¿Án ndixa kúndeé ndó xo̱ꞌvi̱ ní ndó nda̱tán xo̱ꞌvi̱ yi̱ꞌi̱? ");
INSERT INTO mim_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ta nda̱kuii̱n na o̱vi̱ yóꞌo: ―Kúchiño va ndi̱ ―káchí na xíꞌin ta̱Jesús. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ndixa xo̱ꞌvi̱ ní ndó ñii ki̱ꞌva nda̱tán xo̱ꞌvi̱ yi̱ꞌi̱, ");
INSERT INTO mim_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ta o̱n kúchiño taxi i̱ nda̱yí kundo̱o ndó táyi̱ tón kuita sii̱n kuaꞌá i̱ xíꞌin sii̱n yitin i̱. Saá chi Yivá i̱ Ndios kúu ta̱a ta̱ chi̱tóni̱ yu kúu ni̱vi kundo̱o táyi̱ yóꞌo ―káchí ta̱Jesús xíꞌin o̱vi̱ ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ta xi̱ni̱ so̱ꞌo inka̱ u̱xu̱ naxíka xíꞌin ta̱Jesús yukía̱ ndu̱kú o̱vi̱ ta̱a yóꞌo no̱o̱ ra, ta ki̱xáꞌá na ni̱saa̱ ní na xi̱ni na ta̱Jacobo xíꞌin ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ta ta̱Jesús ka̱na ra va̱xi ndiꞌi na no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Xíni̱ ndó na ndíso chiño no̱o̱ na ñoo inka̱ xiiña, nayóꞌo kísa káꞌno xíꞌin mi̱i na, ta yáꞌa ní ndeé xáꞌnda chiño na no̱o̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ta mi̱i ndó, o̱n váꞌa kutaku̱ ndó saá. Tá ñii ta̱a kóni ra kuu ra ta̱káꞌno no̱o̱ ndóꞌó, xíni̱ ñóꞌó nduu ra ta̱ kasa chiño no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tá ñii ta̱a kóni ra kuu ra ta̱no̱ó no̱o̱ ndóꞌó, xíni̱ ñóꞌó nduu ra ta̱mozo no̱o̱ ndiꞌi ndó. ");
INSERT INTO mim_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ki̱xi i̱ xa̱ꞌa̱ ña chindeé i̱ ni̱vi, ta o̱n si̱ví xa̱ꞌa̱ ña chindeé ni̱vi yi̱ꞌi̱ kúu ña ki̱xi i̱. Ta taxi xíꞌin mi̱i i̱ ña kivi̱ i̱, ta xíꞌin ñayóꞌo chaꞌvi i̱ ña va̱ꞌa sa̱ña̱ kua̱ꞌa̱ ní ni̱vi no̱o̱ ndiꞌi ña o̱n váꞌa ndíso na ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ta ki̱xaa̱ na ñoo Jericó. Tá ke̱e ta̱Jesús kua̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra xíꞌin kua̱ꞌa̱ ní ni̱vi ñoo yóꞌo, ta yóo ñii ta̱kuáá na̱ní ra Bartimeo, sa̱ꞌya ta̱Timeo, yóo ra yuꞌu̱ yichi̱. Ta̱ ndáka̱ chiꞌña si̱ꞌún kúu ra no̱o̱ na yáꞌa yichi̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tá xi̱ni̱ so̱ꞌo ra yáꞌa ta̱Jesús, ta̱ñoo Nazaret, ta ki̱xáꞌá ra xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Tata Jesús, sa̱ꞌya ta̱David, ¡ná kundáꞌví ini ún koni ún yi̱ꞌi̱! ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ta ni̱vi na kua̱ꞌa̱n yichi̱ ni̱ka̱ꞌa̱n na xíꞌin ra: ―¡Kasi ún yuꞌu̱ ún! ―káchí na. Ta ni̱‑chikaa̱ so̱ꞌo ta̱kuáá ña ni̱ka̱ꞌa̱n na xíꞌin ra, ta ki̱xáꞌá ra ndeé va̱ꞌa ka̱ káꞌa̱n ra: ―Tata, sa̱ꞌya ta̱David, ¡ná kundáꞌví ini ún koni ún yi̱ꞌi̱! ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ta xi̱kundichi ta̱Jesús yichi̱ yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi yóꞌo: ―Kana ndó ra ná kixi ra no̱o̱ i̱. Ta saá ka̱na na ta̱kuáá, káchí na xíꞌin ra: ―Chikaa̱ ún ndee̱ ini ún. Nakundichi ún, chi kána ra yóꞌó kixi ún no̱o̱ ra ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ta sa̱ña ra tika̱chí ra, ta ñii ka̱ndeta ra na̱kundichi ra, ta ki̱xaa̱ ra no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―¿Yukía̱ kóni ún keꞌé i̱ xíꞌin ún? Ta nda̱kuii̱n ta̱kuáá: ―Tata Maestro, kóni i̱ sandaꞌa ún nduchu̱ no̱o̱ i̱ ta va̱ꞌa koto i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Va̱ꞌa kua̱noꞌo̱ ún. Xa ndu̱va̱ꞌa nduchu̱ no̱o̱ ún, saá chi kándixa ún yi̱ꞌi̱. Ta xa̱ndi̱ko̱n nda̱ꞌa nduchu̱ no̱o̱ ra, ta xa va̱ꞌa xíto ra, ta saá na̱kundiko̱n ra sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ki̱vi̱ kua̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra yichi̱ ña kua̱ꞌa̱n ñoo Jerusalén, ta ni̱xaa̱ na ñoo Betfagé yatin ñoo Betania. Ñoo yóꞌo ñóꞌo ña no̱o̱ xíto ndaa xi̱ki̱ tón Olivo. Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin o̱vi̱ naxíka xíꞌin ra, ");
INSERT INTO mim_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","káchí ra saá: ―Kua̱ꞌa̱n ndó ñoo ña xíto ndaa ndó kaa̱. Tá ni̱xaa̱ ndó ñoo kaa̱, ta naníꞌi ndó ñii burro loꞌo nóꞌni rí, tí ta̱ꞌán koso na kúu rí. Ta ndaxin ndó rí ta kixi ndó xíꞌin rí yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tá yóo ni̱vi na nda̱ka̱ to̱ꞌon ndóꞌó: “¿Nda̱chun ndáxin ndó burro yóꞌo?”, kachí na xíꞌin ndó, ta ndakuii̱n ndó, kachí ndó saá xíꞌin na: “Ta̱Káꞌno no̱o̱ yó xíni̱ ñóꞌó rí, tá ndi̱ꞌi xíni̱ ñóꞌó ra rí, ta kama ní nataxi ra rí ndaꞌa̱ ndó”, kachí ndó xíꞌin na ―káchí ta̱Jesús xíꞌin o̱vi̱ naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ta saá kua̱ꞌa̱n na, ta ni̱xaa̱ na ñoo, ta na̱níꞌi na ñii burro loꞌo nóꞌni ndaa rí no̱o̱ ke̱ꞌe yatin yéꞌé ñii veꞌe, ta nda̱xin na rí. ");
INSERT INTO mim_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ta sava na ndóo ni̱nda̱ka̱ to̱ꞌon ñaꞌá na: ―¿Nda̱chun ndáxin ndó rí? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ta saá nda̱kuii̱n o̱vi̱ ta̱yóꞌo ñii ki̱ꞌva nda̱tán ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, ta na ndóo yóꞌo ta̱xi na nda̱yí kua̱ꞌa̱n burro xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ta saá ndi̱kó na ki̱xaa̱ na no̱o̱ ta̱Jesús xíꞌin burro loꞌo, ta chi̱nóo na tiko̱to̱ na sa̱ta̱ rí, ta saá na̱koso ta̱Jesús ta kua̱ꞌa̱n ra yichi̱. ");
INSERT INTO mim_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ta kua̱ꞌa̱ ní ni̱vi chi̱ndoo na tiko̱to̱ na yichi̱ no̱o̱ yáꞌa ra kua̱ꞌa̱n ra, ta sava ni̱vi xa̱ꞌnda na no̱o̱ ndaꞌa̱ tón yito̱n, ta chi̱ndoo na nó yichi̱ no̱o̱ yáꞌa ra kua̱ꞌa̱n ra, saá kísa to̱ꞌó na ra. ");
INSERT INTO mim_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ta ni̱vi na kua̱ꞌa̱n siꞌna no̱o̱ ra xíꞌin na ndíko̱n kua̱ꞌa̱n sa̱ta̱ ra, ndeé ní kúsii̱ ini na, ta káꞌa̱n na, káchí na saá: ―¡Kasa káꞌno yó Ndios! ¡Ná keꞌé Ndios ñava̱ꞌa xíꞌin ta̱yóꞌo, ta̱a ta̱ ki̱xaa̱ xíꞌin nda̱yí Ndios! ");
INSERT INTO mim_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ná keꞌé Ndios ñava̱ꞌa xíꞌin yó ki̱vi̱ ña kixáꞌá kaꞌnda chiño ra no̱o̱ yó, nda̱tán ni̱ka̱ꞌa̱n Ndios xíꞌin xi̱i̱ síkuá yó ta̱rey David! ¡Ná kanóo síkón ñato̱ꞌó Ndios! ―káchí ni̱vi na kua̱ꞌa̱n xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ta ta̱Jesús ni̱ki̱ꞌvi ra ñoo Jerusalén ta ni̱ki̱ꞌvi ra yéꞌé veꞌe ño̱ꞌo káꞌno. Ta xi̱to káxín ra no̱o̱ ndiꞌi ña̱ꞌa ña yóo ini veꞌe ño̱ꞌo. Ta saá ndi̱kó ra ñoo Betania xíꞌin u̱xu̱ o̱vi̱ naxíka xíꞌin ra, chi xa ni̱kuaa ní kúu ña. ");
INSERT INTO mim_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ta inka̱ ki̱vi̱ ta ke̱e na ñoo Betania ta kua̱ꞌa̱n na ñoo Jerusalén, ta ta̱Jesús xíꞌi̱ ní ra so̱ko. ");
INSERT INTO mim_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ta xi̱ni ra nda̱ xíká ní ñii tón higo ta yóo yu̱ku̱ kuíi̱ ndaꞌa̱ nó, ta saá kua̱ꞌa̱n ra koto ra án o̱n ko̱ó kui̱ꞌi ndaꞌa̱ nó. Tá ni̱to̱nda̱a yatin ra no̱o̱ yóo yito̱n yóꞌo, ta nda̱ ñii kui̱ꞌi o̱n ko̱ó, nina yu̱ku̱ kuiti yóo chi ta̱ꞌán kixaa̱ ki̱vi̱ ña koon higo. ");
INSERT INTO mim_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin yito̱n tón higo, káchí ra saá: ―Nda̱ ñii ka̱ ki̱vi̱ ña va̱xi, nda̱ ñii ni̱vi o̱n kaxi na nda̱ ñii kui̱ꞌi ndaꞌa̱ ún ―káchí ra. Ta naxíka xíꞌin ra xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ra xíꞌin yito̱n yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ta ni̱xaa̱ na ñoo Jerusalén, ta ta̱Jesús ni̱ki̱ꞌvi ra ke̱ꞌe yéꞌé veꞌe ño̱ꞌo káꞌno, ta ki̱xáꞌá ra táva ra ndiꞌi na síkó xíꞌin na sáta ña kee na ko̱ꞌo̱n na. Ta sa̱ndiva ra mesa ni̱vi na sáma si̱ꞌún, ta xa̱ta ra táyi̱ na síkó tísa̱ta, ");
INSERT INTO mim_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ta o̱n vása ní‑taxi ra yaꞌa nda̱ ñii ni̱vi na ndíso ñakíaꞌvi yéꞌé veꞌe ño̱ꞌo. ");
INSERT INTO mim_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ta ki̱xáꞌá ra sa̱náꞌa ra ni̱vi, káchí ra saá: ―Saá káchí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá: “Veꞌe i̱ kunaní ña veꞌe no̱o̱ ko̱ꞌo̱n ndiꞌi ni̱vi ña ka̱ꞌa̱n na xíꞌin i̱”, káchí to̱ꞌon Ndios. Ta ndóꞌó, o̱n vása va̱ꞌa kéꞌé ndó, chi sa̱nduu ndó veꞌe yóꞌo ñii kavua̱ nakuíꞌná ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ta na sánáꞌa nda̱yí Ndios xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ra, ta ki̱xáꞌá na ndúkú na ndasaá koo kaꞌni na ta̱Jesús, chi yíꞌví ní na no̱o̱ ra, xa̱ꞌa̱ ña ndiꞌi ni̱vi nákaꞌnda ini na xíni̱ so̱ꞌo na ña sánáꞌa ra. ");
INSERT INTO mim_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ta xa kóni kuñoó kúu ña, ta ta̱Jesús ke̱e ra ñoo Jerusalén ta ndi̱kó ra ñoo Betania. ");
INSERT INTO mim_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ta inka̱ ki̱vi̱ xita̱a̱n ní, nda̱koo na ta kua̱ꞌa̱n tuku na yichi̱ ñoo Jerusalén, ta xi̱ni na xa ni̱yi̱chi̱ tón higo, nda̱ tioꞌo xa̱ꞌa̱ nó ni̱yi̱chi̱. ");
INSERT INTO mim_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ta na̱káꞌán ta̱Pedro to̱ꞌon ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin tón higo, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Tata Maestro, koto ún, ni̱yi̱chi̱ tón higo tón sa̱ta̱vi̱ chiꞌña ún ki̱vi̱ koni. ");
INSERT INTO mim_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin naxíka xíꞌin ra: ―Kandixa ndinoꞌo ini ndó Ndios. ");
INSERT INTO mim_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ndixa káꞌa̱n i̱ xíꞌin ndó, nda̱ yukú ndóꞌó ka̱ꞌa̱n ndó xíꞌin ñii xi̱ki̱ káꞌno, kachí ndó siꞌa: “Kutaꞌa ún ta ko̱ꞌo̱n ún sakana xíꞌin mi̱i ún no̱o̱ mi̱ni”, tá o̱n vása xíka o̱vi̱ ini ndó, ta ndixa kandixa ndó kasa ndivi ña ña ni̱ka̱ꞌa̱n ndó xíꞌin ña, ta saá kundivi ña. ");
INSERT INTO mim_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ta káꞌa̱n i̱ xíꞌin ndó, tá kandixa ndinoꞌo ini ndó Ndios, ta nakiꞌin ndó ndiꞌi ña ndukú ndó no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tá káꞌa̱n ndó xíꞌin Ndios, tá o̱n váꞌa kóni ini ndó xíni ndó inka̱ ni̱vi, ta va̱ꞌa ka̱ kasa káꞌno ini ndó xa̱ꞌa̱ na, ta saá Yivá yó Ndios, ta̱ yóo ñoyívi ni̱no, kivi kasa káꞌno ini ra xa̱ꞌa̱ kua̱chi ndó. ");
INSERT INTO mim_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tá o̱n xi̱in ndó kasa káꞌno ini ndó xa̱ꞌa̱ inka̱ ni̱vi, ta saá Yivá yó Ndios, ta̱ yóo ñoyívi ni̱no, o̱n kasa káꞌno ini ra xa̱ꞌa̱ kua̱chi ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ta ki̱xaa̱ tuku na ñoo Jerusalén. Ta xíka ta̱Jesús no̱o̱ ke̱ꞌe yéꞌé veꞌe ño̱ꞌo káꞌno, ta na sánáꞌa nda̱yí Ndios xíꞌin naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ ki̱xaa̱ na no̱o̱ ra, ");
INSERT INTO mim_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ta ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ―¿Míkía̱ ki̱xi nda̱yí kéꞌé ún ñayóꞌo? ¿Yu kúu na ta̱xi nda̱yí ndaꞌa̱ ún keꞌé ún chiño yóꞌo saá? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Ta nda̱kuii̱n ta̱Jesús: ―Ta yi̱ꞌi̱ kóni i̱ nda̱ka̱ to̱ꞌon i̱ ndóꞌó ñii la̱á to̱ꞌon. ¿Míkía̱ ki̱xi nda̱yí ta̱Juan sa̱kuchu ra ni̱vi? ¿Án ta̱xi Ndios nda̱yí ndaꞌa̱ ra? ¿Án ni̱vi kúu na ta̱xi nda̱yí ndaꞌa̱ ra ña sakuchu ra ni̱vi? Tá ndakuii̱n ndó ña ndáka̱ to̱ꞌon i̱ ndóꞌó, ta saá ka̱ꞌa̱n i̱ xíꞌin ndó míkía̱ ki̱xi nda̱yí kéꞌé i̱ chiño yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ta saá ki̱xáꞌá na káꞌa̱n táꞌan xíꞌin mi̱i na: ―¿Ndasaá koo ndakuii̱n yó vitin? Chi táná ka̱ꞌa̱n yó Ndios ta̱xi nda̱yí ndaꞌa̱ ta̱Juan, ta saá nda̱ka̱ to̱ꞌon ta̱Jesús mi̱i yó: “¿Nda̱chun o̱n vása ní‑kandixa ndó ña ni̱ka̱ꞌa̱n ra?” ");
INSERT INTO mim_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Án kivi ka̱ꞌa̱n yó ni̱vi kuiti kúu na ta̱xi nda̱yí ndaꞌa̱ ta̱Juan? ―káchí na, káꞌa̱n táꞌan na. Káꞌa̱n táꞌan na saá chi yíꞌví na ko̱to̱ saa̱ nañoo, chi ndiꞌi nañoo kándixa na ndí ta̱Juan xi̱kuu ra ñii ta̱profeta. ");
INSERT INTO mim_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ta saá nda̱kuii̱n na, káchí na siꞌa xíꞌin ta̱Jesús: ―O̱n xíni̱ ndi̱ yu kúu na ta̱xi nda̱yí ndaꞌa̱ ta̱Juan ―káchí na. Ta saá ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta ni yi̱ꞌi̱, o̱n ka̱ꞌa̱n i̱ xíꞌin ndó míkía̱ ki̱xi nda̱yí kómí i̱ ña kéꞌé i̱ chiño yóꞌo ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ta ki̱xáꞌá ta̱Jesús káꞌa̱n ra xíꞌin na, nda̱to̱ꞌon ra ñii cuento ña sanáꞌa ra na, káchí ra saá: ―Saá ndo̱ꞌo ñii ta̱a, na̱taan ra tón uva. Ta ki̱sa va̱ꞌa ra ñii na̱ma̱ xi̱no nduu ña ndiꞌi no̱o̱ ñoꞌo̱ no̱o̱ na̱taan ra tón uva. Ta xa̱ta ra no̱o̱ ñoꞌo̱ ta ki̱sa va̱ꞌa ra ñii no̱o̱ koꞌon nduta̱ tíuva, ta ki̱sa va̱ꞌa ra ñii torre no̱o̱ kundo̱o ni̱vi kundaa na tón uva yóꞌo. Ta saá sa̱tati ra ñoꞌo̱ ra xíꞌin tón uva inka̱ ni̱vi, ta ke̱e ra kua̱ꞌa̱n ra inka̱ ñoo xíká ní. ");
INSERT INTO mim_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ta ki̱xaa̱ yatin ki̱vi̱ ña kaꞌnda na tíuva yóꞌo, ta ta̱ xíꞌin yito̱n tón uva ti̱ꞌví ra ñii ta̱mozo ra kua̱ꞌa̱n ra nakiꞌin ra sava tíuva ña kuu yaꞌvi ra. ");
INSERT INTO mim_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ta ni̱vi na táti ñoꞌo̱ no̱o̱ yóo tón uva ti̱in na ta̱mozo yóꞌo, ta ka̱ni ní na ra, ni̱‑xiin na taxi na rí ndaꞌa̱ ra, ta saá ndi̱kó vi̱chí ra kua̱noꞌo̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ta ta̱a ta̱ xíꞌin yito̱n tón uva tuku ti̱ꞌví ra inka̱ ta̱a kua̱ꞌa̱n ra nakiꞌin ra tíuva. Ta ko̱on na yu̱u̱ ra, ta̱ꞌví na si̱ni̱ ra, ta sa̱kukaꞌan na no̱o̱ ra, ta ta̱xin na ra ndikó ra kua̱noꞌo̱ ra veꞌe ta̱patrón. ");
INSERT INTO mim_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ta ta̱a ta̱ xíꞌin yito̱n tón uva tuku ti̱ꞌví ra inka̱ ta̱mozo kua̱ꞌa̱n ra, ta xa̱ꞌni na ta̱yóꞌo. Ta saá ti̱ꞌví tuku ra kua̱ꞌa̱ ní namozo kua̱ꞌa̱n na, ta ka̱ni ní na sava nayóꞌo, ta xa̱ꞌni na sava nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ta saá o̱n ko̱ó ka̱ inka̱ na kúchiño tiꞌví ra ko̱ꞌo̱n, ta ni̱ndo̱o ñii ta̱a ta̱ kúu sa̱ꞌya mi̱i ra, ta kíꞌvi ní ini ra xíni ra sa̱ꞌya ra yóꞌo. Ta saá ti̱ꞌví ra sa̱ꞌya ra kua̱ꞌa̱n ra no̱o̱ ni̱vi na táti ñoꞌo̱, chi xa̱ni ini ra: “Ndixa kasa to̱ꞌó na sa̱ꞌya mi̱i yó”, káꞌán ra. ");
INSERT INTO mim_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ta na táti ñoꞌo̱ xi̱ni na kíxaa̱ ta̱loꞌo sa̱ꞌya ra, ta ni̱ka̱ꞌa̱n na xíꞌin táꞌan na, káchí na saá: “Ta̱kaa̱ kúu sa̱ꞌya ta̱ na̱taan tón uva, ta sa̱ꞌya ra yóꞌo kúu ta̱ nakiꞌin ñakuíká xíꞌin ñoꞌo̱ yóꞌo táná kivi̱ yivá ra. Naꞌa ndó ná koꞌyo̱ kaꞌni yó ra, ta kindo̱o yó xíꞌin ndiꞌi ñakuíká ra”, káchí na. ");
INSERT INTO mim_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ta saá ti̱in na ra, ta xa̱ꞌni na ra, ta sa̱kana na yi̱kí ko̱ñu ra nda̱ sa̱ta̱ na̱ma̱ ña xi̱no nduu no̱o̱ yóo tón uva. Saá ndi̱ꞌi cuento yóꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi na xi̱ni̱ so̱ꞌo cuento yóꞌo: ―¿Vitin yukía̱ keꞌé ta̱a ta̱ xíꞌin yito̱n tón uva? Káꞌa̱n i̱ xíꞌin ndó, ndikó ra naxaa̱ ra, ta sandiꞌi ra xa̱ꞌa̱ ni̱vi na táti ñoꞌo̱ ra. Ta tuku satati ra ñoꞌo̱ ra inka̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Án o̱n vása ní‑kaꞌvi ndó to̱ꞌon Ndios, ña káchí saá?: Yóo yu̱u̱ ña ni̱‑xiin ni̱vi na kísa va̱ꞌa veꞌe koni̱ ñóꞌó na, ta mi̱i yu̱u̱ yóꞌo ndu̱u ña yu̱u̱ ñano̱ó nákaa̱ xa̱ꞌa̱ veꞌe. ");
INSERT INTO mim_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ndios kúu ta̱ ki̱sa ndivi saá, ña̱ꞌa livi ní kúu ña ke̱ꞌé Ndios, ta mi̱i yó nákaꞌnda ini yó xíni yó ñayóꞌo, káchí ni̱vi, káchí to̱ꞌon Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ta saá xa̱ni si̱ni̱ na ndúkú na ndasaá koo tiin ñaꞌá na, chi ku̱nda̱a̱ ini na cuento ña ni̱ka̱ꞌa̱n ta̱Jesús ndí káꞌa̱n ña xa̱ꞌa̱ na. Ta ni̱‑kuchiño tiin na ra, chi yíꞌví na ko̱to̱ saa̱ ni̱vi na ndóo yóꞌo. Ta saá ke̱e na kua̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ta ti̱ꞌví na sava nafariseo xíꞌin na ndíko̱n partido ta̱Herodes kua̱ꞌa̱n na no̱o̱ ta̱Jesús ña sati̱ví na ñii to̱ꞌon ka̱ꞌa̱n ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ta ki̱xaa̱ na no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n na siꞌa xíꞌin ra: ―Tata maestro, xíni̱ ndi̱ yóꞌó kúu ún ta̱a ta̱ káꞌa̱n ñanda̱a̱, ta o̱n vása ndíꞌi ini ún ña káꞌa̱n ni̱vi xa̱ꞌa̱ ña sánáꞌa ún, ta o̱n vása náka̱xin ún ni̱vi, ta ñii ki̱ꞌva káꞌa̱n ún xíꞌin ndiꞌi na. Sánáꞌa ún ñanda̱a̱ xa̱ꞌa̱ yichi̱ Ndios. Ta vitin kóni ndi̱ nda̱ka̱ to̱ꞌon ndi̱ yóꞌó, ¿án va̱ꞌa chaꞌvi yó kota no̱o̱ ta̱rey César ñoo Roma? ¿Án o̱n váꞌa chaꞌvi yó ña? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ta ta̱Jesús kúnda̱a̱ ini ra ndí na o̱vi̱ yuꞌu̱ kúu na, kóni na koto ndoso na ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Nda̱chun kóni ndó koto ndoso ndó yi̱ꞌi̱? Taxi ndó ñii si̱ꞌún ná koto i̱ no̱o̱ ña. ");
INSERT INTO mim_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ta ta̱xi na ñii si̱ꞌún ndaꞌa̱ ra, ta xíto ra ña, ta ni̱nda̱ka̱ to̱ꞌon ra na: ―¿Yo na̱ꞌná, ta yo ki̱vi̱ kúu ña yóo no̱o̱ si̱ꞌún yóꞌo? Ta nda̱kuii̱n na: ―Si̱ꞌún yóꞌo kómí ña na̱ꞌná xíꞌin ki̱vi̱ ta̱rey César ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Taxi ndó ndaꞌa̱ ta̱rey César ña kúu kuenda ra, ta taxi ndó ndaꞌa̱ Ndios ña kúu kuenda Ndios ―káchí ta̱Jesús xíꞌin na. Ta na̱kaꞌnda ní ini na chi va̱ꞌa ní ni̱ka̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nasaduceo ki̱xaa̱ na no̱o̱ ta̱Jesús. Nasaduceo yóꞌo kúu na nanáꞌno na sánáꞌa ta káꞌa̱n na ndí na ni̱xiꞌi̱ o̱n vása nataku̱ ka̱ na. Ta ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ");
INSERT INTO mim_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Tata maestro, nda̱yí Ndios ña ni̱taa ta̱Moisés, káchí ña saá: “Tá ñii ta̱a ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya ra ní‑xiyo xíꞌin ñásíꞌí ra, ta ñani ra xíni̱ ñóꞌó tonda̱ꞌa̱ ra xíꞌin ñá ni̱ndo̱o yóꞌo, ña kivi koo sa̱ꞌya na. Nda̱tán koo sa̱ꞌya ta̱ ni̱xiꞌi̱, saá koo sa̱ꞌya nayóꞌo”, káchí nda̱yí ña ni̱taa ta̱Moisés. ");
INSERT INTO mim_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ta, ¿yukía̱ káchí yóꞌó xa̱ꞌa̱ ñayóꞌo? Chi saá ndo̱ꞌo ta̱a, u̱xa̱ ñani kúu ra. Ta̱no̱ó to̱nda̱ꞌa̱ ra xíꞌin ñii ñaꞌa̱, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na ní‑xiyo. ");
INSERT INTO mim_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ta ñani ra ta̱o̱vi̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na ní‑xiyo. Ta ñani ra ta̱u̱ni̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo. Ñii ki̱ꞌva ndo̱ꞌo ta̱no̱ó xíꞌin ta̱o̱vi̱, saá ndo̱ꞌo ta̱u̱ni̱ yóꞌo, ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na ní‑xiyo. ");
INSERT INTO mim_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ta ñani ra ta̱ko̱mi̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. Ta ñani ra ta̱o̱ꞌo̱n to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. Ta ñani ra ta̱i̱ño̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. Ta ñani ra ta̱u̱xa̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. Ta saá ni̱xiꞌi̱ mi̱i ñáñaꞌa̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ta ki̱vi̱ nataku̱ ndiꞌi na ni̱xiꞌi̱, ¿yukú ta̱a kuu yii̱ ñáñaꞌa̱ yóꞌo?, chi ndiꞌi ta̱a u̱xa̱ ñani ni̱xi̱yo ra xíꞌin ñá ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin na: ―Sándáꞌví xíꞌin mi̱i ndó, chi naa ní ini ndó, o̱n vása kúnda̱a̱ ini ndó ña káꞌa̱n to̱ꞌon Ndios, ni o̱n vása kúnda̱a̱ ini ndó ña kúu ndee̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Saá chi ki̱vi̱ nataku̱ na ni̱xiꞌi̱, o̱n vása tonda̱ꞌa̱ ka̱ na ñoyívi ni̱no, ni o̱n vása taxi na sa̱ꞌya na tonda̱ꞌa̱ na xíꞌin inka̱ ni̱vi. Nda̱tán yóo naángel ñoyívi ni̱no, saá koo ni̱vi na kundo̱o xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Xa̱ꞌa̱ ña nataku̱ na ni̱xiꞌi̱, ¿án o̱n vása ní‑kaꞌvi ndó yukía̱ ni̱ka̱ꞌa̱n Ndios xíꞌin ta̱Moisés xi̱na̱ꞌá, ki̱vi̱ xi̱ni ra yito̱n ñiño̱ xíxi̱ nó? Ka̱chí ra saá: “Yi̱ꞌi̱ kúu Ndios, ta ta̱Abraham, ta̱Isaac, xíꞌin ta̱Jacob kísa to̱ꞌó ra yi̱ꞌi̱ vitin”, ka̱chí Ndios. ");
INSERT INTO mim_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ta xíꞌin to̱ꞌon yóꞌo kúnda̱a̱ ini yó ndí táku̱ ka̱ xi̱i̱ síkuá yó yóꞌo, chi na ndixa ni̱xiꞌi̱ o̱n kuchiño na kasa to̱ꞌó na Ndios. Sána ini ndó chi o̱n vása kúnda̱a̱ ini ndó ndí ni̱vi na ni̱xiꞌi̱ tuku nataku̱ na ―káchí ta̱Jesús xíꞌin nasaduceo. ");
INSERT INTO mim_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ñii ta̱a ta̱ sánáꞌa nda̱yí Ndios ki̱xaa̱ ra xi̱ni̱ so̱ꞌo ra ña ni̱ka̱ꞌa̱n táꞌan na. Ta ku̱nda̱a̱ ini ra va̱ꞌa ní nda̱kuii̱n ta̱Jesús yuꞌu̱ na, ta saá ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús: ―Tata, ¿ndá nda̱yí Ndios kúu ña xíni̱ ñóꞌó ní ka̱ no̱o̱ ndiꞌi inka̱ nda̱yí? ");
INSERT INTO mim_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ta nda̱kuii̱n ta̱Jesús: ―Nda̱yí ña xíni̱ ñóꞌó ní ka̱ kúu ñayóꞌo: “Koni̱ so̱ꞌo ndó, naIsrael, Ndios Yivá yó kúu ñii la̱á Ndios. ");
INSERT INTO mim_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kukiꞌvi ini ndó koni ndó Ndios xíꞌin ndiꞌi níma̱ ndó, xíꞌin ndiꞌi ini ndó, xíꞌin ndiꞌi si̱ni̱ ndó, xíꞌin ndiꞌi ndee̱ ndó.” Ñayóꞌo kúu nda̱yí ñano̱ó, ña xíni̱ ñóꞌó ní ka̱. ");
INSERT INTO mim_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nda̱tán sánáꞌa nda̱yí ñano̱ó, saá sánáꞌa nda̱yí ñao̱vi̱, káchí ña saá: “Ñii ki̱ꞌva nda̱tán kíꞌvi ini ndó xíni ndó xíꞌin mi̱i ndó, saá kukiꞌvi ini ndó koni ndó natáꞌan ndó.” O̱n ko̱ó ka̱ inka̱ nda̱yí ña ndáya̱ꞌví ní ka̱ no̱o̱ o̱vi̱ nda̱yí yóꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ta ta̱ sánáꞌa nda̱yí Ndios ni̱ka̱ꞌa̱n ra: ―Va̱ꞌa ní káꞌa̱n ún, Tata Maestro. Ñanda̱a̱ káꞌa̱n ún yóo ñii la̱á Ndios, ta o̱n ko̱ó ka̱ inka̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ña kukiꞌvi ini yó koni yó Yivá yó Ndios xíꞌin ndiꞌi níma̱ yó, xíꞌin ndiꞌi si̱ni̱ yó, xíꞌin ndiꞌi ini yó, xíꞌin ndiꞌi ndee̱ yó, ta ña kukiꞌvi ini yó koni yó natáꞌan yó nda̱tán kíꞌvi ini yó xíni yó xíꞌin mi̱i yó kúu ña ndáya̱ꞌví ní ka̱ no̱o̱ ndiꞌi ña so̱ko̱ yó xíꞌin ña kaꞌmi yó no̱o̱ na̱ma̱ yi̱i̱ veꞌe Ndios ―káchí ta̱ sánáꞌa nda̱yí. ");
INSERT INTO mim_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tá ta̱Jesús xi̱ni̱ so̱ꞌo ra va̱ꞌa ní ndíchí ni̱ka̱ꞌa̱n ta̱ sánáꞌa nda̱yí, ta káchí ra saá xíꞌin ra: ―Yatin ní yóo ún ña ki̱ꞌvi ún yichi̱ no̱o̱ xáꞌnda chiño Ndios. Ta saá nda̱ ñii ni̱vi ni̱‑xiin ka̱ na nda̱ka̱ to̱ꞌon na ra ña koto ndoso ñaꞌá na. ");
INSERT INTO mim_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ta ta̱Jesús sa̱náꞌa ra ni̱vi yéꞌé veꞌe ño̱ꞌo káꞌno, ta káchí ra saá xíꞌin na: ―¿Nda̱chun na sánáꞌa nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá káchí na ndí Cristo, ta̱ tiꞌví Ndios saka̱ku ra ni̱vi, kuu ñii sa̱ꞌya ñani síkuá ta̱rey David? ");
INSERT INTO mim_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Chi Níma̱ Ndios ni̱ka̱ꞌa̱n ini ta̱David, ta ni̱taa ra to̱ꞌon yóꞌo, ña káchí saá: Ndios ni̱ka̱ꞌa̱n ra xíꞌin ta̱Káꞌno no̱o̱ i̱: “Koo ún xíꞌin i̱ sii̱n kuaꞌá i̱ no̱o̱ táyi̱ tón to̱ꞌó yóꞌo, ta̱nda̱ ki̱vi̱ taxi i̱ ko̱yo ndiꞌi na káni táꞌan xíꞌin ún ti̱xin xa̱ꞌa̱ ún”, ka̱chí Ndios, ni̱taa ta̱David xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Xíꞌin to̱ꞌon yóꞌo ta̱David ka̱chí ra Cristo kúu ta̱Káꞌno no̱o̱ ra. Ta, ¿mí kúchiño kúu Cristo sa̱ꞌya ñani síkuá ta̱David? ―káchí ta̱Jesús xíꞌin na. Ta kua̱ꞌa̱ ní ni̱vi ndóo yóꞌo, ta kúsii̱ ní ini na xíni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ta ta̱Jesús sa̱náꞌa ka̱ ra na, káchí ra saá: ―Koto va̱ꞌa ndó o̱n kundiko̱n ndó yichi̱ ni̱vi na sánáꞌa nda̱yí Ndios, chi kuiti káꞌvi na nda̱yí ta o̱n vása kasa ndivi na ña. Kísa káꞌno xíꞌin mi̱i na, kúsii̱ ní ini na kundixin na tiko̱to̱ va̱ꞌa, ta kua̱ꞌa̱n va̱xi na no̱o̱ ni̱vi ña koto ñaꞌá na. Ta xíka na no̱yáꞌvi, ta kóni na ña kasa to̱ꞌó ní ni̱vi na, ");
INSERT INTO mim_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ta kútoo ní na kundo̱o na táyi̱ tón náꞌno tón to̱ꞌó tón yóo veꞌe ño̱ꞌo sinagoga. Ta no̱o̱ yóo viko̱ xíxi, ndúkú na kundo̱o na no̱o̱ táyi̱ náꞌno tón to̱ꞌó. ");
INSERT INTO mim_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ta kéꞌé na ña o̱n váꞌa, chi kíndaa na veꞌe náñaꞌa̱ ná ni̱xiꞌi̱ yii̱. Ta ndi̱ꞌi ke̱ꞌé na saá ta xíꞌin ñavatá ini na, xáꞌa̱n na veꞌe ño̱ꞌo sinagoga, ta naꞌá ní káꞌa̱n na xíꞌin Ndios. Kéꞌé na saá xa̱ꞌa̱ ña kóni na kani si̱ni̱ ni̱vi ndí nayóꞌo kúu nava̱ꞌa ní no̱o̱ Ndios. Ta xa̱ꞌa̱ ña o̱n váꞌa kéꞌé na, Ndios saxo̱ꞌvi̱ ka̱ ra nayóꞌo no̱o̱ inka̱ ni̱vi ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ta saá xi̱koo ta̱Jesús yéꞌé veꞌe ño̱ꞌo káꞌno, yatin no̱o̱ ñíndichi caja ña ñóꞌo si̱ꞌún xa̱ꞌa̱ Ndios. Ta xi̱to ra ni̱vi táan na si̱ꞌún ini caja. Ta nakuíká táan na kua̱ꞌa̱ ní si̱ꞌún ini caja yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ta ki̱xaa̱ ñii ñaꞌa̱ ndáꞌví ñá ni̱xiꞌi̱ yii̱, táan ñá o̱vi̱ si̱ꞌún kuálí ini caja, ta loꞌo ní ndáka̱ si̱ꞌún yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ta ta̱Jesús ka̱na ra u̱xu̱ o̱vi̱ naxíka xíꞌin ra va̱xi na no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, ñándáꞌví yóꞌo ta̱xi ñá víꞌí ka̱ si̱ꞌún no̱o̱ ña ta̱xi nakuíká, ");
INSERT INTO mim_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","chi nakuíká, vará ta̱xi na kua̱ꞌa̱ ní si̱ꞌún, ta ki̱ndo̱o víꞌí ka̱ ña ndaꞌa̱ mi̱i na. Ta ñándáꞌví yóꞌo, vará loꞌo ní si̱ꞌún níꞌi ñá, ta ta̱xi ndiꞌi ñá si̱ꞌún ña kómí ñá, ta saá sa̱ndakoo ñá ndiꞌi ña xíni̱ ñóꞌó ñá ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ta saá ta̱Jesús ke̱ta ra veꞌe ño̱ꞌo káꞌno ta kua̱ꞌa̱n ra, ta ñii ta̱xíka xíꞌin ra ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Tata Maestro, koto ún, ¡nda̱chun náꞌno ní yu̱u̱ ñóꞌo ku̱va̱ꞌa veꞌe ño̱ꞌo yóꞌo! ¡Nda̱chun livi ní veꞌe ño̱ꞌo yóꞌo! ");
INSERT INTO mim_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―¿Án xíto ún ndiꞌi ñalivi yóꞌo? Nda̱ ñii ka̱ yu̱u̱ o̱n kóo ka̱ sa̱ta̱ inka̱ yu̱u̱. Saá chi ñii ki̱vi̱ ña va̱xi tani veꞌe ño̱ꞌo yóꞌo ta ndiꞌi xa̱ꞌa̱ ña ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ta saá kua̱ꞌa̱n na xi̱ki̱ tón Olivo ña nákaa̱ no̱o̱ xíto ndaa veꞌe ño̱ꞌo káꞌno. Ta xi̱koo ta̱Jesús no̱o̱ ñoꞌo̱, ta ta̱Pedro, ta̱Jacobo, ta̱Juan xíꞌin ta̱Andrés xi̱to na o̱n ko̱ó ka̱ ni̱vi, ta ki̱xaa̱ na no̱o̱ ra, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ");
INSERT INTO mim_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Tata, kóni ndi̱ ndato̱ꞌon ún xíꞌin ndi̱, ¿ama koo saá ña ka̱chí ún? ¿Ndá seña kuu ña koni ndi̱ ña kunda̱a̱ ini ndi̱ xa kúyatin ndiꞌi xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno yóꞌo? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin na: ―Koto va̱ꞌa ndó ña o̱n sandáꞌví ni̱vi ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Saá chi kua̱ꞌa̱ ní ta̱a kixaa̱, ta ki̱vi̱ kixaa̱ ñii ñii na, ta ka̱ꞌa̱n na xíꞌin ndó, kachí na saá: “Yi̱ꞌi̱ kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ni̱vi ñoyívi yóꞌo”, kachí na xíꞌin ndó, ta sandáꞌví na kua̱ꞌa̱ ní ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Ta koni̱ so̱ꞌo ndó yóo kua̱chi xáꞌni táꞌan na ñoo yatin, ta xáꞌni táꞌan na ñoo xíká, ta o̱n kuyi̱ꞌví ndó. Chi xíni̱ ñóꞌó kundivi ndiꞌi ñayóꞌo, ta saá ni, ta̱ꞌán kixaa̱ ki̱vi̱ ñasondíꞌí ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ki̱vi̱ ña va̱xi nakuita ni̱vi na ñoo náꞌno kaꞌni táꞌan na xíꞌin ni̱vi na inka̱ ñoo náꞌno, ta ñoo no̱o̱ yóo narey kaꞌni táꞌan na xíꞌin inka̱ ñoo no̱o̱ yóo inka̱ narey. Ta kua̱ꞌa̱ ní xiiña ta̱an no̱o̱ ñoꞌo̱, ta koo ní so̱ko, ta nakuita nani̱vi chi ndiꞌi ní ini na, ta saa̱ ní ini na, ta kani táꞌan na xíꞌin natáꞌan na. Ñayóꞌo kuiti kuu ña kixáꞌá ña xo̱ꞌvi̱ ní ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Ta ndóꞌó, kundaa xíꞌin mi̱i ndó, chi tiin na ndóꞌó ko̱ꞌo̱n ndó xíꞌin na, ta nataxi na ndóꞌó ndaꞌa̱ nachiño náꞌno, ta kani ní na ndóꞌó veꞌe ño̱ꞌo sinagoga. Taxi na kua̱chi xa̱ꞌa̱ ndó no̱o̱ nagobernador án no̱o̱ narey chi na ndíko̱n yi̱ꞌi̱ kúu ndó. Tá kundo̱o ndó no̱o̱ nachiño yóꞌo, ta saá kukomí ndó yichi̱ ka̱ꞌa̱n ndó to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Siꞌna ni̱vi na kándixa yi̱ꞌi̱ xíni̱ ñóꞌó ka̱ꞌa̱n ndoso na to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ i̱ no̱o̱ ndiꞌi ni̱vi na ndóo ndiꞌi saá ñoo ñoyívi yóꞌo, ta saá kixaa̱ ki̱vi̱ sondíꞌí. ");
INSERT INTO mim_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tá tiin na ndóꞌó ko̱ꞌo̱n ndó xíꞌin na, ta chikaa̱ na kua̱chi xa̱ꞌa̱ ndó no̱o̱ nachiño, ta o̱n kundiꞌi ini ndó xa̱ꞌa̱ to̱ꞌon ña ndakuii̱n ndó. Saá chi mi̱i ki̱vi̱ ña kundoꞌo ndó saá, Ndios taxi ra to̱ꞌon ña ka̱ꞌa̱n ndó no̱o̱ nayóꞌo, chi o̱n si̱ví mi̱i ndóꞌó kuu na ka̱ꞌa̱n no̱o̱ na, ta Níma̱ Ndios ña yóo ini ndó kuu ña ka̱ꞌa̱n. ");
INSERT INTO mim_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ki̱vi̱ ña va̱xi sava nata̱a taxi na kua̱chi xa̱ꞌa̱ ñani na no̱o̱ nachiño, ta sava na kúu yivá taxi na kua̱chi xa̱ꞌa̱ sa̱ꞌya na no̱o̱ nachiño. Ta sava na kúu sa̱ꞌya kasa toon na no̱o̱ yivá siꞌí na, ta taxi na kua̱chi xa̱ꞌa̱ mi̱i yivá siꞌí na yóꞌo no̱o̱ nachiño, ta nachiño ka̱ꞌa̱n na saá: “Ná kivi̱ nayóꞌo.” ");
INSERT INTO mim_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ndiꞌi ni̱vi kusaa̱ ini na koni na ndóꞌó chi na ndíko̱n yichi̱ i̱ kúu ndó. Tá o̱n sandakoo ndó yichi̱ i̱ ta kundiko̱n va̱ꞌa ndó ña, nda̱ kixaa̱ ki̱vi̱ ndi̱ꞌi ña xo̱ꞌvi̱ ndó ñoyívi yóꞌo, ta Ndios saka̱ku ra ndóꞌó ña kutaku̱ ndó xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ta ndóꞌó na káꞌvi to̱ꞌon yóꞌo, xíni̱ ñóꞌó kunda̱a̱ ini ndó to̱ꞌon yóꞌo ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Kui̱ya̱ xi̱na̱ꞌá ta̱profeta Daniel ni̱ka̱ꞌa̱n ra xa̱ꞌa̱ ña o̱n váꞌa ñakini ña sandiꞌi xa̱ꞌa̱ ñayi̱i̱. Ta kixaa̱ ki̱vi̱ koto ndó yóo ña o̱n váꞌa ñakini yóꞌo veꞌe ño̱ꞌo káꞌno, ta ndiꞌi na ndóo estado Judea yóꞌo, xíni̱ ñóꞌó kee na ta kono na ko̱ꞌo̱n na no̱o̱ yóo yuku̱ síkón. ");
INSERT INTO mim_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tá yóo ni̱vi ta nándoso na si̱ni̱ veꞌe na, ta nayóꞌo o̱n váꞌa noo na ndi̱ꞌvi na nakiꞌin na ña kómí na veꞌe na. ");
INSERT INTO mim_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tá yóo ni̱vi ta ñóꞌo na yuku̱, ta nayóꞌo, o̱n váꞌa ndikó ka̱ na veꞌe na nakiꞌin na tika̱chí na. ");
INSERT INTO mim_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ndáꞌví ní náñaꞌa̱ ná ñóꞌo sa̱ꞌya, ta ndáꞌví ní náñaꞌa̱ ná yóo sa̱ꞌya válí na chíchín, chi ndeé ní koo ña xo̱ꞌvi̱ ná ki̱vi̱ kundivi ñayóꞌo saá! ");
INSERT INTO mim_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ndukú ndó no̱o̱ Ndios ña o̱n kuu ña ki̱vi̱ vi̱xin ní ña kundoꞌo ndó saá. ");
INSERT INTO mim_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nda̱ ki̱vi̱ no̱ó ña ki̱sa va̱ꞌa Ndios ñoyívi yóꞌo ta̱nda̱ vitin, nani̱vi xóꞌvi̱ na. Ta ki̱vi̱ koo ña o̱n váꞌa yóꞌo saá, ndeé ní ka̱ xo̱ꞌvi̱ ndiꞌi ni̱vi. Ta nda̱ ñii ka̱ ki̱vi̱ ña va̱xi o̱n xo̱ꞌvi̱ ka̱ na nda̱tán xo̱ꞌvi̱ na ki̱vi̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ta xa̱ꞌa̱ ña kúndáꞌví ini Ndios xíni ra ni̱vi na na̱ka̱xin ra ndíko̱n yichi̱ ra kúu ña chi̱tóni̱ ra saloꞌo ki̱vi̱ xo̱ꞌvi̱ ni̱vi ñoyívi yóꞌo. Tá o̱n vása ní‑chitóni̱ ra saá, níkúu, ta nda̱ ñii ni̱vi o̱n kívi ka̱ku na no̱o̱ ña yo̱ꞌvi̱ ní xóꞌvi̱ na. ");
INSERT INTO mim_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Tá yóo ni̱vi na ka̱ꞌa̱n xíꞌin ndó: “Yóꞌo yóo Cristo ta̱ ti̱ꞌví Ndios saka̱ku na ñoyívi yóꞌo”, án “Koto ndó, kaa̱ yóo ra”, kachí na xíꞌin ndó, ta o̱n kandixa ndó na. ");
INSERT INTO mim_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chi nakuita kua̱ꞌa̱ ní navatá ta ka̱ꞌa̱n na, kachí na siꞌa: “Yi̱ꞌi̱ kúu Cristo ta̱a ta̱ ti̱ꞌví Ndios”, ta inka̱ na ka̱ꞌa̱n, kachí na: “Yi̱ꞌi̱ kúu ta̱profeta ta̱ káꞌa̱n ndoso to̱ꞌon Ndios”, ta o̱n si̱ví nanda̱a̱ kúu na. Navatá yóꞌo to̱nda̱a na keꞌé na milagro ña sandáꞌví na ni̱vi, ta̱nda̱ yatin kuchiño sandáꞌví na ni̱vi na na̱ka̱xin Ndios kundiko̱n yichi̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ta ndóꞌó koto va̱ꞌa ndó, chi vitin kúnda̱a̱ ini ndó ndiꞌi ñayóꞌo, chi xa nda̱to̱ꞌon i̱ xíꞌin ndó ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ta tuku ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá xíꞌin na: ―Ta ki̱vi̱ kán, tá ndiꞌi ña xóꞌvi̱ ni̱vi, ta ña ño̱ꞌo káꞌno yéꞌe kunaa no̱o̱ ña, ta tíyo̱o̱ o̱n vása nayeꞌe ka̱ rí, ");
INSERT INTO mim_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ta tíki̱mi kee rí ñoyívi ni̱no ta ko̱yo rí, ta ndiꞌi ña kómí ndee̱ yóo ñoyívi ni̱no kanda ña ta kisin ndiꞌi ñayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ta saá ndiꞌi ni̱vi koni na yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ta va̱xi i̱ ma̱ꞌñó vi̱ko̱, xíꞌin ndee̱ káꞌno, xíꞌin ndiꞌi ña yéꞌe livi. ");
INSERT INTO mim_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ta yi̱ꞌi̱ tiꞌví i̱ naángel ko̱ꞌo̱n na nakaya na ndiꞌi ni̱vi na na̱ka̱xin i̱ na kúu na ndíko̱n yichi̱ i̱. Ta ni̱vi yóꞌo kee na ndiꞌi saá xiiña no̱o̱ ñoꞌo̱ ñoyívi yóꞌo xíꞌin ñoyívi ni̱no, ta kixaa̱ na no̱o̱ i̱. ");
INSERT INTO mim_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Ta ndóꞌó, sakuáꞌá ndó ta kunda̱a̱ ini ndó ña sánáꞌa yito̱n tón higo: Tá xa va̱xi nduxa̱á nó, ta nákoo yu̱ku̱ yúta̱ ndaꞌa̱ nó, ta saá kunda̱a̱ ini ndó xa ni̱kuyatin ní kixaa̱ sa̱vi̱. ");
INSERT INTO mim_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ta ki̱vi̱ xíto ndó xa kua̱ꞌa̱n kundivi ndiꞌi ñayóꞌo ña nda̱to̱ꞌon i̱ xíꞌin ndó, ta saá kunda̱a̱ ini ndó xa va̱xi kuyatin ki̱vi̱ ndikó i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ta ndixa káꞌa̱n i̱ xíꞌin ndó, ni̱vi na xíto kixáꞌá seña yóꞌo kutaku̱ ka̱ na nda̱ ndi̱ꞌi ku̱ndivi ndiꞌi ña nda̱to̱ꞌon i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ña ñoyívi ni̱no xíꞌin ña ñoyívi yóꞌo ñii ki̱vi̱ va̱xi ndiꞌi xa̱ꞌa̱ ña, ta to̱ꞌon i̱ o̱n ndiꞌi xa̱ꞌa̱ ña, ta kindo̱o ña ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Nda̱ ñii ni̱vi o̱n vása xíni̱ na ama ndikó i̱, ni ni̱vi na ndóo ñoyívi yóꞌo, ni naángel na ndóo ñoyívi ni̱no, ni yi̱ꞌi̱ ta̱a ta̱Sa̱ꞌya Ndios. Ta ñii la̱á Ndios Tata Yivá yó kúu ta̱a ta̱ xíni̱ ama ndikó i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ta saá ndóꞌó, koto va̱ꞌa ndó, kundo̱o tiꞌva ndó ta ka̱ꞌa̱n ndó xíꞌin Ndios, chi o̱n vása xíni̱ ndó ama ndikó i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nda̱tán ke̱ꞌé ñii ta̱a ta̱ kua̱ꞌa̱n xíká, saá kéꞌé i̱ xíꞌin ndó. Saá chi ta̱yóꞌo sa̱ndakoo ra veꞌe ra, ta ta̱xi ra nda̱yí ndaꞌa̱ namozo ra, ta ñii ñii na sa̱kuiso ra na chiño, ta xa̱ꞌnda chiño ra no̱o̱ ta̱ ndáa yéꞌé veꞌe ra ña koo tiꞌva ra. ");
INSERT INTO mim_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ta káꞌa̱n i̱ xíꞌin ndó, kundito ndó chi o̱n vása xíni̱ ndó ama ndikó i̱, án kua̱ꞌa̱n kuñoó, án ma̱ꞌñó ñoó, án xita̱a̱n naa ka̱ ta kána nduxú chée, án xita̱a̱n ni̱ti̱vi, kuu ña ndikó i̱. ");
INSERT INTO mim_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Koto va̱ꞌa ndó ko̱to̱ ñii kama ndikó i̱, ta naníꞌi i̱ ndóꞌó ndóo ndó kísi̱n ndó. ");
INSERT INTO mim_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ta to̱ꞌon káꞌa̱n i̱ xíꞌin ndó, káꞌa̱n i̱ xíꞌin ndiꞌi ni̱vi: Ná kundo̱o tiꞌva ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ta kúma̱ni̱ o̱vi̱ ki̱vi̱ ña to̱nda̱a ki̱vi̱ kana viko̱ Pascua, xíꞌin inka̱ viko̱ no̱o̱ xíxi najudío si̱ta̱ va̱ꞌa ña o̱n ko̱ó levadura kómí. Ta na sánáꞌa nda̱yí Ndios xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ ndúkú na ndasaá koo kasa va̱ꞌa na kua̱chi vatá xa̱ꞌa̱ ta̱Jesús, ta tiin na ra ña kaꞌni ñaꞌá na. ");
INSERT INTO mim_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ta ni̱ka̱ꞌa̱n na, káchí na saá: ―O̱n kuchiño tiin yó ra ki̱vi̱ viko̱, ko̱to̱ koni ndiꞌi nani̱vi ñoo yóꞌo, ta si̱so̱ na nda̱ꞌyi na, ta kani táꞌan na, ta koo ní kua̱chi ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ta yóo ta̱Jesús ñoo Betania veꞌe ta̱Simón, ta̱ xi̱komí kue̱ꞌe̱ táꞌyí na̱ní ña lepra. Tá yóo ta̱Jesús xíxi ra no̱o̱ mesa, ta ki̱xaa̱ yatin ñii ñaꞌa̱ níꞌi ñá ñii yu̱yu̱ ña ku̱va̱ꞌa xíꞌin yu̱u̱ na̱ní alabastro, ti̱xin ña ñóꞌo nduta̱ tá xáꞌan támi ní, tá ku̱va̱ꞌa xíꞌin yu̱ku̱ nardo kúu rá, ta nduta̱ yóꞌo kúu tá yáꞌví ní. Ta ni̱xaꞌno ñá si̱ko̱n yu̱yu̱ yóꞌo ta chi̱kaa̱ ndiꞌi ñá rá si̱ni̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ta sava na ndóo ni̱saa̱ ní na xíni ñaꞌá na, ta ni̱ka̱ꞌa̱n na xíꞌin táꞌan na: ―¿Nda̱chun sa̱ndiꞌi ñaꞌa̱ yóꞌo xa̱ꞌa̱ nduta̱ yáꞌví ní? ");
INSERT INTO mim_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Va̱ꞌa ka̱ ná si̱kó ñá nduta̱ yóꞌo ta u̱ni̱ ciento si̱ꞌún denario nakiꞌin ñá, níkúu, ta saá kuchiño chindeé ñá nandáꞌví ―káchí na, káꞌa̱n na. Ta káꞌa̱n na to̱ꞌon o̱n váꞌa xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―O̱n ka̱ꞌa̱n ndó to̱ꞌon kuáchí xíꞌin ñáñaꞌa̱ yóꞌo. ¿Nda̱chun sándiꞌi ndó ñá? Chi ñava̱ꞌa kúu ña ke̱ꞌé ñá xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ndiꞌi saá ki̱vi̱ yóo nandáꞌví xíꞌin ndó ta kúchiño chindeé ndó na. Ta yi̱ꞌi̱, saloꞌo ní ka̱ ki̱vi̱ yóo i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ñáñaꞌa̱ yóꞌo ke̱ꞌé ñá ñava̱ꞌa, chi̱kaa̱ ñá nduta̱ tá xáꞌan támi si̱ni̱ i̱ ña ki̱sa tiꞌva ñá yi̱kí ko̱ñu i̱ ña ndu̱xu̱n ña. ");
INSERT INTO mim_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ndixa káꞌa̱n i̱ xíꞌin ndó, ndiꞌi saá xiiña ñoyívi yóꞌo no̱o̱ ka̱ꞌa̱n ndoso na to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ i̱, ndato̱ꞌon na xíꞌin ni̱vi yukía̱ ke̱ꞌé ñáyóꞌo. Ta saá nakáꞌán ni̱vi xa̱ꞌa̱ ñava̱ꞌa ke̱ꞌé ñá xíꞌin i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ta saá ta̱Judas Iscariote, ta̱ kúu ñii ta̱a ta̱ u̱xu̱ o̱vi̱ xíka xíꞌin ta̱Jesús, ke̱e ra ni̱xa̱ꞌa̱n ra no̱o̱ nanáꞌno no̱o̱ nasu̱tu̱ ña nataxi ra ta̱Jesús ndaꞌa̱ na. ");
INSERT INTO mim_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ta ku̱sii̱ ní ini na xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱Judas xíꞌin na, ta nayóꞌo ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tá nataxi ún ra ndaꞌa̱ ndi̱, ta taxaꞌvi ndi̱ yóꞌó ―káchí na. Ta saá ki̱xáꞌá ndúkú ta̱Judas ndasaá koo nataxi ra ta̱Jesús ndaꞌa̱ na. ");
INSERT INTO mim_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ta ni̱to̱nda̱a ki̱vi̱ ki̱xáꞌá viko̱ xíxi najudío si̱ta̱ va̱ꞌa ña o̱n ko̱ó levadura kómí, ta ñii ñii veꞌe na, xáꞌni na ndikachi loꞌo ña nákáꞌán na viko̱ Pascua. Ta naxíka xíꞌin ta̱Jesús ni̱nda̱ka̱ to̱ꞌon na ra: ―¿Míkía̱ kóni ún kasa ndivi ndi̱ ña kuxu yó viko̱ Pascua? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ta saá ti̱ꞌví ta̱Jesús o̱vi̱ naxíka xíꞌin ra, káchí ra saá xíꞌin na: ―Kua̱ꞌa̱n ndó, ta kua̱ꞌa̱n ki̱ꞌvi ndó ñoo Jerusalén, ta nakutáꞌan ndó xíꞌin ñii ta̱a ndíso ki̱si takuií, ta kundiko̱n ndó ko̱ꞌo̱n ndó sa̱ta̱ ra, ");
INSERT INTO mim_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ta veꞌe no̱o̱ ki̱ꞌvi ra, ka̱ꞌa̱n ndó xíꞌin ta̱a ta̱ xíꞌin veꞌe yóꞌo: “Ta̱Maestro ti̱ꞌví ndi̱ꞌi̱ va̱xi ndi̱ nda̱ka̱ to̱ꞌon ndi̱ yóꞌó: ¿Míkía̱ yóo ñii cuarto veꞌe ún no̱o̱ kuxu ra viko̱ Pascua xíꞌin ndi̱ꞌi̱, naxíka xíꞌin ra?”, kachí ndó. ");
INSERT INTO mim_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ta saá ta̱a ta̱ xíꞌin veꞌe sanáꞌa ra ndóꞌó míkía̱ yóo ñii cuarto káꞌno veꞌe ra ña kánóo piso o̱vi̱, no̱o̱ yóo ndiꞌi ña xíni̱ ñóꞌó ndó. Ta veꞌe yóꞌo kasa ndivi ndó ña kuxu yó viko̱ Pascua ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ta o̱vi̱ naxíka xíꞌin ra ke̱e na kua̱ꞌa̱n na, ta ni̱ki̱ꞌvi na ñoo Jerusalén, ta na̱níꞌi na nda̱tán yóo ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, ta ki̱sa ndivi na ña kuxu na viko̱ Pascua. ");
INSERT INTO mim_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tá kua̱ꞌa̱n kuñoó, ki̱xaa̱ ta̱Jesús xíꞌin u̱xu̱ o̱vi̱ naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ta ndóo na xíxi na no̱o̱ mesa, ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, ñii ndóꞌó na xíxi xíꞌin i̱ kúu ta̱a ta̱ si̱kó kuíꞌná yi̱ꞌi̱, ta nataxi ra yi̱ꞌi̱ ndaꞌa̱ ni̱vi na sáa̱ ini xíni yi̱ꞌi̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ta ki̱xáꞌá nayóꞌo kúchuchú ní ini na, ta ñii ñii na ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ―Tata, ¿án yi̱ꞌi̱ kúu ta̱ káꞌa̱n ún xa̱ꞌa̱? Ta inka̱ na ni̱ka̱ꞌa̱n: ―¿Án yi̱ꞌi̱ kúu ra? ");
INSERT INTO mim_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ta nda̱kuii̱n ta̱Jesús, káchí ra xíꞌin na: ―Ñii ndóꞌó ta̱ u̱xu̱ o̱vi̱ kúu ra, ta̱ sáchii si̱ta̱ va̱ꞌa ini ko̱ꞌo̱ xíꞌin i̱, ta̱yóꞌo kúu ta̱ si̱kó kuíꞌná yi̱ꞌi̱ no̱o̱ na sáa̱ ini xíni yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndixa xo̱ꞌvi̱ ní i̱ ta kivi̱ i̱, nda̱tán ni̱taa naprofeta xi̱na̱ꞌá. Ta, ¡ndáꞌví ní ta̱a ta̱ si̱kó kuíꞌná yi̱ꞌi̱ no̱o̱ na sáa̱ ini xíni yi̱ꞌi̱! Va̱ꞌa ka̱ níxi̱yo o̱n kaku ta̱yóꞌo, níkúu ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tá ndóo ka̱ na xíxi na, ta̱Jesús ki̱ꞌin ra si̱ta̱ va̱ꞌa, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios: ―Tata Yivá yó, táxaꞌvi ún chi ta̱xi ún si̱ta̱ va̱ꞌa kuxu ndi̱ ―káchí ra. Ta ta̱ꞌví ra si̱ta̱ va̱ꞌa, ta ta̱xi ra ña ndaꞌa̱ ñii ñii naxíka xíꞌin ra kuxu na. Ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Nakiꞌin ndó kuxu ndó si̱ta̱ va̱ꞌa yóꞌo, chi ñayóꞌo kúu yi̱kí ko̱ñu i̱. ");
INSERT INTO mim_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ta ki̱ꞌin ta̱Jesús ñii copa ña ñóꞌo nduta̱ vino, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios: ―Tata Yivá yó, táxaꞌvi ún chi ta̱xi ún nduta̱ koꞌo ndi̱ yóꞌo ―káchí ra. Ta ta̱xi ra copa ñóꞌo nduta̱ vino yóꞌo ndaꞌa̱ na, ta ndiꞌi na xíꞌi na rá, ");
INSERT INTO mim_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―Nduta̱ yóꞌo kúu ni̱i̱ i̱ ña kui̱ta̱. Ta xíꞌin ñayóꞌo Ndios chindúꞌu̱ ra pacto xa̱á ña ka̱ꞌa̱n ndasaá kuchiño nakiꞌin ni̱vi ñava̱ꞌa Ndios. ");
INSERT INTO mim_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ndixa káꞌa̱n i̱ xíꞌin ndó, o̱n koꞌo ka̱ i̱ nduta̱ vino nda̱ ki̱xaa̱ ki̱vi̱ nakutáꞌan yó no̱o̱ xáꞌnda chiño Ndios. Ta saá koꞌo yó tánduta̱ vino xa̱á ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ta ndi̱ꞌi xi̱ta na ñii yaa ña káꞌa̱n xa̱ꞌa̱ Ndios, ta ke̱e na kua̱ꞌa̱n na xi̱ki̱ tón Olivo. ");
INSERT INTO mim_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ñoó vitin ndiꞌi ndóꞌó sandakoo ndó yi̱ꞌi̱, chi saá kundivi to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá, ña káchí saá: “Satakuéꞌe̱ i̱ ta̱a ta̱ ndáa tíndikachi, ta tíndikachi yóꞌo kui̱ta̱ níꞌnó ndiꞌi rí”, ka̱chí Ndios. ");
INSERT INTO mim_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ta ki̱vi̱ nataku̱ i̱, ko̱ꞌo̱n siꞌna i̱ ña kundati i̱ ndóꞌó ñoo estado Galilea ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ta ta̱Pedro ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Tata, tá ndiꞌi ni̱vi sandakoo na yóꞌó, ta yi̱ꞌi̱ o̱n sandakoo i̱ yóꞌó. ");
INSERT INTO mim_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Ndixa káꞌa̱n i̱ xíꞌin ún, ta̱ꞌán ka̱ kana nduxú chée o̱vi̱ yichi̱ ñoó vitin, ta xa u̱ni̱ yichi̱ ni̱ka̱ꞌa̱n ún xíꞌin ni̱vi ña o̱n vása xíni̱ ún yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ta xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ta̱Pedro, káchí ra saá: ―Tata, ta̱nda̱ xíni̱ ñóꞌó kivi̱ i̱ xíꞌin ún, ta nda̱ ñii yichi̱ o̱n vása ka̱ꞌa̱n i̱ o̱n vása xíni̱ i̱ yóꞌó ―káchí ta̱Pedro. Ta ñii káchí saá ni̱ka̱ꞌa̱n ndiꞌi ka̱ naxíka xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ta ni̱xaa̱ na ñii no̱o̱ na̱ní Getsemaní, ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra: ―Kundo̱o ndó yóꞌo táná ko̱ꞌo̱n i̱ ka̱ꞌa̱n i̱ xíꞌin Ndios ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Pedro ta xíꞌin ta̱Jacobo xíꞌin ta̱Juan, kua̱ꞌa̱n na xíꞌin ra ta ni̱xaa̱ na, ta ki̱xáꞌá ta̱Jesús kúchuchú ní ini ra ta ndíꞌi ní ini ra. ");
INSERT INTO mim_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ta ni̱ka̱ꞌa̱n ra xíꞌin u̱ni̱ ta̱yóꞌo: ―Ndeé ní kúchuchú ini i̱ a̱nda̱ ñii kóni ña kivi̱ i̱. Kundati ndó yóꞌo ta kundito ndó, o̱n ku̱su̱n ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ta ta̱Jesús ke̱e ra kua̱ꞌa̱n ra ñii xiiña xíká ka̱ loꞌo, ta xi̱kuxítí ra ta xi̱kundee ra nda̱ no̱o̱ ñoꞌo̱, ndu̱kú ra no̱o̱ Ndios, tá kúchiño ví, ta o̱n taxi Ndios xo̱ꞌvi̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ta káchí ra xíꞌin Ndios saá: ―Tata Yivá mi̱i i̱, xíni̱ va̱ꞌa i̱ yóꞌó kúchiño kasa ndivi ún ndiꞌi saá ña̱ꞌa. Ta ña kóni i̱ kúu ña o̱n taxi ún ña xo̱ꞌvi̱ i̱. Ta saá ni, o̱n kundivi ña kóni mi̱i i̱, ta va̱ꞌa ka̱ ná kundivi ña kóni mi̱i ún ―káchí ta̱Jesús xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ta saá na̱kundichi ra, ta ndi̱kó ra ki̱xaa̱ ra no̱o̱ ndóo u̱ni̱ naxíka xíꞌin ra. Ta ndiꞌi nayóꞌo kísi̱n na. Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ta̱Pedro: ―¿Án kísi̱n ún? ¿Án o̱n vása kúchiño ún kundito ún vará ñii hora? ");
INSERT INTO mim_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ta ni̱ka̱ꞌa̱n ra xíꞌin u̱ni̱ naxíka xíꞌin ra: ―O̱n ku̱su̱n ka̱ ndó ta kundito ndó ka̱ꞌa̱n ndó xíꞌin Ndios ña o̱n nakava ndó kua̱chi. Ndóꞌó, yóo ini ndó keꞌé ndó ñava̱ꞌa, ta o̱n kúchiño ndó keꞌé ndó ñava̱ꞌa yóꞌo xíꞌin ndee̱ mi̱i ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ta tuku ndi̱kó ta̱Jesús kua̱ꞌa̱n ra, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios nda̱tán yóo to̱ꞌon ña siꞌna ni̱ka̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ta ndi̱kó tuku ra ki̱xaa̱ ra no̱o̱ ndóo naxíka xíꞌin ra, ta na̱níꞌi ra na kísi̱n na, saá chi ndeé ní xíꞌi̱ na maꞌná. Ta nayóꞌo o̱n vása xíni̱ na yukía̱ ka̱ꞌa̱n na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ta yichi̱ u̱ni̱ ni̱xa̱ꞌa̱n ra ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios, ta ndi̱kó ra ki̱xaa̱ tuku ra no̱o̱ ndóo naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Án va̱ꞌa ku̱su̱n ka̱ ndó ta nakindée ka̱ ndó? Koto ndó, xa ni̱to̱nda̱a hora ña nataxi na yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndaꞌa̱ ni̱vi na o̱n váꞌa. ");
INSERT INTO mim_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ndakoo ndó, ná koꞌyo̱. Ta koto ndó, yóꞌo va̱xi ta̱ nataxi yi̱ꞌi̱ ndaꞌa̱ nani̱vi na sáa̱ ini xíni yi̱ꞌi̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tá ta̱ꞌán ka̱ ndiꞌi ka̱ꞌa̱n ta̱Jesús xíꞌin na, ta ki̱xaa̱ ta̱Judas ta̱ kúu ñii ta̱ u̱xu̱ o̱vi̱ xíka xíꞌin ta̱Jesús. Ta ki̱xaa̱ kua̱ꞌa̱ ní ni̱vi xíꞌin ra, ta níꞌi na espada xíꞌin yito̱n. Naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin na sánáꞌa nda̱yí Ndios xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ xa ti̱ꞌví na ni̱vi yóꞌo ña tiin na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ta ta̱Judas xa siꞌna ni̱ka̱ꞌa̱n ra xíꞌin na ndasaá nakoni na ta̱Jesús, káchí ra siꞌa: ―Ta̱a ta̱ chindeé i̱ xíꞌin ña chi̱to i̱ no̱o̱ kúu ta̱Jesús. Ta tiin ndó ra katón ndó ra ta ko̱ꞌo̱n ra xíꞌin ndó no̱o̱ nanáꞌno ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ta saá ki̱xaa̱ ra, ta ni̱to̱nda̱a yatin ra no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n ra: ―Kuaꞌa, Tata Maestro. Ta ni̱chi̱to ra no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ta saá ni̱vi na yóo xíꞌin ta̱Judas xa̱ndi̱ko̱n ti̱in na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ta ñii ta̱ ndíko̱n sa̱ta̱ ta̱Jesús ta̱va ra espada, ta ka̱ndoso va̱ꞌa ra ñii so̱ꞌo ta̱ kísa chiño no̱o̱ ta̱káꞌno no̱o̱ nasu̱tu̱. ");
INSERT INTO mim_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ni̱vi na ti̱in ñaꞌá: ―¿Án xáni si̱ni̱ ndó ta̱kuíꞌná kúu i̱? ¿Nda̱chun va̱xi ndó no̱o̱ i̱ níꞌi ndó espada xíꞌin yito̱n ña tiin ndó yi̱ꞌi̱? ");
INSERT INTO mim_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ta yi̱ꞌi̱, ndiꞌi saá ki̱vi̱ ni̱xi̱yo i̱ sánáꞌa i̱ ni̱vi veꞌe ño̱ꞌo káꞌno, ta ni̱‑tiin ndó yi̱ꞌi̱. Ta ndiꞌi ñayóꞌo kundoꞌo i̱ vitin, chi saá xíni̱ ñóꞌó kundivi to̱ꞌon Ndios ña ni̱taa naprofeta ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ta ndiꞌi naxíka xíꞌin ra sa̱ndakoo na ta̱Jesús, ta xi̱no na kua̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ta ñii ta̱loꞌo ndíko̱n ra kua̱ꞌa̱n ra sa̱ta̱ ta̱Jesús, ta níꞌno ra ñii la̱á tiko̱to̱ ndíka̱ no̱o̱, ta ni̱vi ti̱in na ra, ");
INSERT INTO mim_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ta ta̱yóꞌo sa̱ndakoo ra tiko̱to̱ ndíka̱ no̱o̱ ndaꞌa̱ na, ta ke̱e ra yálá ra xi̱no ra kua̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ta saá ni̱vi na ti̱in ta̱Jesús, ni̱xaa̱ ra xíꞌin na no̱o̱ ta̱káꞌno no̱o̱ nasu̱tu̱. Ta na̱kutáꞌan ndiꞌi naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin na sánáꞌa nda̱yí Ndios xíꞌin nanáꞌno no̱o̱ nasu̱tu̱. ");
INSERT INTO mim_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ta ta̱Pedro ñii xíká ndíko̱n ra kua̱ꞌa̱n ra sa̱ta̱ ta̱Jesús a̱nda̱ ni̱xaa̱ ra veꞌe ta̱su̱tu̱ káꞌno. Ta xi̱koo ra xíꞌin napolicía nasaa̱ ra yatin no̱o̱ xíxi̱ ñoꞌo̱ ke̱ꞌe veꞌe yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ta nanáꞌno no̱o̱ nasu̱tu̱ xíꞌin ndiꞌi inka̱ nachiño na̱ní na Junta Suprema nándukú na ni̱vi na ka̱ꞌa̱n to̱ꞌon vatá ña kuva̱ꞌa kua̱chi xa̱ꞌa̱ ta̱Jesús, ta saá kuchiño nataxi na ra ndaꞌa̱ ni̱vi ña kaꞌni na ra, ta ni̱‑kuchiño naníꞌi na kua̱chi ra. ");
INSERT INTO mim_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Chi kua̱ꞌa̱ ní ni̱vi ni̱ka̱ꞌa̱n na to̱ꞌon vatá xa̱ꞌa̱ ra, ta ña ni̱ka̱ꞌa̱n na o̱n vása ní‑nakutáꞌan to̱ꞌon na. ");
INSERT INTO mim_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sava na na̱kuita na ni̱ka̱ꞌa̱n na ñavatá xa̱ꞌa̱ ra, káchí na saá: ");
INSERT INTO mim_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ndi̱ꞌi̱ xi̱ni̱ so̱ꞌo ndi̱ ni̱ka̱ꞌa̱n ra, ka̱chí ra: “Yi̱ꞌi̱ sandiꞌi i̱ xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno yóꞌo ña ki̱sa va̱ꞌa ni̱vi, ta ti̱xin ña u̱ni̱ ki̱vi̱ kasa va̱ꞌa i̱ inka̱ veꞌe ño̱ꞌo ña o̱n si̱ví kuva̱ꞌa xíꞌin ndaꞌa̱ ni̱vi kuu ña”, ka̱chí ta̱Jesús ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ta ni̱‑kuchiño nakutáꞌan to̱ꞌon ña ni̱ka̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ta ta̱káꞌno no̱o̱ nasu̱tu̱ na̱kundichi ra ma̱ꞌñó ndiꞌi na ndóo yóꞌo, ta ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús: ―¿Án o̱n vása ndákuii̱n ún yuꞌu̱ na? ¿Yukía̱ kachí ún xa̱ꞌa̱ to̱ꞌon ña káꞌa̱n nayóꞌo xa̱ꞌa̱ ún? ");
INSERT INTO mim_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ta ta̱Jesús tási̱ín yóo ra, o̱n vása ní‑ndakuii̱n ra nda̱ ñii to̱ꞌon. Ta ta̱káꞌno no̱o̱ nasu̱tu̱ tuku ni̱nda̱ka̱ to̱ꞌon ñaꞌá ra: ―¿Án Cristo ta̱ ti̱ꞌví Ndios kúu ún? ¿Án ndixa Sa̱ꞌya Ndios kúu ún? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ta nda̱kuii̱n ta̱Jesús: ―Oon, yi̱ꞌi̱ kúu i̱. Ta ki̱vi̱ ña va̱xi koto ndó yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, xa yóo i̱ no̱o̱ táyi̱ tón yóo sii̱n kuaꞌá Ndios, ta̱a ta̱ kómí ndiꞌi ndee̱, ta koni ndó yi̱ꞌi̱ ndikó i̱ ñoyívi yóꞌo, ta va̱xi i̱ ma̱ꞌñó vi̱ko̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ta ta̱káꞌno no̱o̱ nasu̱tu̱ ndi̱ꞌi xi̱ni̱ so̱ꞌo ra ñayóꞌo, ta ni̱saa̱ ní ra, ta nda̱ta ra tiko̱to̱ mi̱i ra, ta ni̱ka̱ꞌa̱n ra: ―O̱n vása xíni̱ ñóꞌó ka̱ yó inka̱ ni̱vi taxi na kua̱chi xa̱ꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ndóꞌó xi̱ni̱ so̱ꞌo ndó ndí ni̱ka̱ꞌa̱n ra ñii kúu ra xíꞌin Ndios, ta ñii kua̱chi káꞌno ní no̱o̱ Ndios kúu ña ni̱ka̱ꞌa̱n ra saá. ¿Yukía̱ xáni ini ndó keꞌé yó xíꞌin ta̱yóꞌo? ―káchí ra xíꞌin nanáꞌno na kúu nachiño. Ta ndiꞌi nayóꞌo ni̱ka̱ꞌa̱n na ndí yóo kua̱chi ra, ta xíni̱ ñóꞌó kivi̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ta sava na ki̱xáꞌá na kúndaa na tási̱i yuꞌu̱ na no̱o̱ ra, ta na̱kasi na no̱o̱ ra ta káni na ra xíꞌin yi̱kí ndaꞌa̱ na, ta káchí na saá: ―Tá ta̱profeta ta̱ xíni̱ va̱ꞌa kúu ún, ta saá ka̱ꞌa̱n ún xíꞌin ndi̱, ¿yukú ndi̱ ka̱ni yóꞌó? ―káchí na xíꞌin ra. Ta napolicía xíꞌin xa̱ꞌnda̱ ndaꞌa̱ na ka̱ni na no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ta yóo ta̱Pedro ke̱ꞌe veꞌe ta̱káꞌno no̱o̱ nasu̱tu̱, ta ki̱xaa̱ ñii ñaꞌa̱ ñá kísa chiño no̱o̱ naveꞌe yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ta xi̱ni ñá ta̱Pedro yóo ra násaa̱ ra yatin no̱o̱ xíxi̱ ñoꞌo̱, ta xi̱to káxín ñá no̱o̱ ra, ta ni̱ka̱ꞌa̱n ñá xíꞌin ra: ―Saá tuku yóꞌó kúu ún ñii ta̱ ni̱xika xíꞌin ta̱Jesús, ta̱ ki̱xi ñoo Nazaret ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ta ta̱Pedro ni̱ka̱ꞌa̱n ra, káchí ra saá: ―O̱n vása xíni̱ i̱ ta̱kaa̱, ni o̱n vása kúnda̱a̱ ini i̱ yukía̱ káꞌa̱n ún xíꞌin i̱. Ta saá ke̱e ra yéꞌé ke̱ꞌe veꞌe yóꞌo. Ta ka̱na ñii nduxú chée. ");
INSERT INTO mim_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ta ñáñaꞌa̱ kísa chiño yóꞌo xi̱ni tuku ñá ra, ta ni̱ka̱ꞌa̱n ñá xíꞌin nani̱vi, káchí ña saá: ―Ta̱yóꞌo kúu ñii ta̱táꞌan ta̱Jesús ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ta ta̱Pedro tuku ni̱ka̱ꞌa̱n ra: ―O̱n vása xíni̱ i̱ ta̱kaa̱ ―káchí ra. Ta ni̱yaꞌa ñii káni̱ loꞌo, ta nani̱vi yíta yatin no̱o̱ ta̱Pedro, ta ni̱ka̱ꞌa̱n tuku na xíꞌin ra saá: ―Ndixa yóꞌó kúu ún ñii ta̱táꞌan ta̱Jesús, chi ki̱xi ún estado Galilea, saá chi nda̱tán káꞌa̱n nakán saá káꞌa̱n ún ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ta ki̱xáꞌá ta̱Pedro xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Xa ni̱ka̱ꞌa̱n i̱ xíꞌin ndó, o̱n vása xíni̱ i̱ ta̱kaa̱. ¡Ndios ná saxo̱ꞌvi̱ ra yi̱ꞌi̱ tá ñavatá káꞌa̱n i̱! ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ta xa̱ndi̱ko̱n ka̱na nduxú chée yichi̱ o̱vi̱. Ta saá na̱káꞌán ta̱Pedro to̱ꞌon ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: “Ta̱ꞌán ka̱ kana nduxú chée o̱vi̱ yichi̱ ñoó vitin, ta xa u̱ni̱ yichi̱ ni̱ka̱ꞌa̱n ún xíꞌin ni̱vi ndí o̱n vása xíni̱ ún yi̱ꞌi̱.” Ta kúchuchú ní ini ta̱Pedro, ta ki̱xáꞌá ra ndeé ní xáku ra ña nákáꞌán ra to̱ꞌon yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ta ni̱ti̱vi inka̱ ki̱vi̱ xita̱a̱n ní, ta nanáꞌno no̱o̱ nasu̱tu̱ na̱kutáꞌan na xíꞌin naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin na sánáꞌa nda̱yí Ndios xíꞌin ndiꞌi inka̱ nachiño na kúu Junta Suprema, ta na̱koo yuꞌú na yukía̱ keꞌé na xíꞌin ta̱Jesús. Ta saá ka̱tón na ta̱Jesús, ta kua̱ꞌa̱n ra xíꞌin na, ta ni̱xaa̱ na na̱taxi na ra ndaꞌa̱ ta̱gobernador Pilato. ");
INSERT INTO mim_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ta ta̱Pilato ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús, káchí ra xíꞌin ra: ―¿Án ndixa yóꞌó kúu ún Rey no̱o̱ najudío? ―káchí ra. Ta nda̱kuii̱n ta̱Jesús: ―To̱ꞌon mi̱i ún káchí yi̱ꞌi̱ kúu ta̱rey. ");
INSERT INTO mim_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ta nanáꞌno no̱o̱ nasu̱tu̱ ta̱xi na kua̱ꞌa̱ ní kua̱chi xa̱ꞌa̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ta ta̱Pilato tuku ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús: ―¿Án o̱n ndakuii̱n ún yuꞌu̱ na? ¡Koni̱ so̱ꞌo ún ndí kua̱ꞌa̱ ní kua̱chi táxi na xa̱ꞌa̱ ún! ");
INSERT INTO mim_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ta ta̱Jesús nda̱ ñii to̱ꞌon ni̱‑ndakuii̱n ra. Ta na̱kaꞌnda ní ini ta̱Pilato xa̱ꞌa̱ ñayóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ñii ñii viko̱ Pascua ta̱gobernador sáña ra ñii ta̱ nákaa̱ ini veꞌe ka̱a ko̱ꞌo̱n ndíka̱ ra. Ta najudío káxin na yu kúu ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ta yóo ñii ta̱a na̱ní ra Barrabás, nákaa̱ ra ini veꞌe ka̱a xíꞌin natáꞌan ra, chi ki̱sa toon na ta ka̱ni táꞌan na xíꞌin nanáꞌno na xáꞌnda chiño no̱o̱ na, ta xa̱ꞌni na ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ta kua̱ꞌa̱ ní ni̱vi na̱kutáꞌan na no̱o̱ ta̱gobernador, ta ki̱xáꞌá na ndúkú na no̱o̱ ra ña saña ra ñii ta̱ nákaa̱ ini veꞌe ka̱a, chi saá kéꞌé ta̱gobernador ñii ñii kui̱ya̱. ");
INSERT INTO mim_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ta ta̱Pilato ni̱nda̱ka̱ to̱ꞌon ra ni̱vi yóꞌo, káchí ra saá: ―¿Án kóni ndó saña i̱ ta̱Rey no̱o̱ ndóꞌó najudío? ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Saá chi ku̱nda̱a̱ ini ta̱Pilato ndí nanáꞌno no̱o̱ nasu̱tu̱ na kísa kuíni̱ ini xíni ta̱Jesús kúu na, ña̱kán na̱taxi na ra ndaꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ta nanáꞌno no̱o̱ nasu̱tu̱ yóꞌo chúꞌu na ni̱vi ña ndukú na ko̱ꞌo̱n ndíka̱ ta̱Barrabás. ");
INSERT INTO mim_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ta ta̱Pilato tuku ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Yukía̱ koo ta̱a ta̱ sákunaní ndó ta̱Rey no̱o̱ ndó najudío? ");
INSERT INTO mim_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na: ―¡Ná kivi̱ ra! ¡Katakaa̱ ndaa ún ra ndaꞌa̱ tón cruz! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ta saá tuku ni̱nda̱ka̱ to̱ꞌon ta̱Pilato na: ―¿Yu kúu kua̱chi ni̱ki̱ꞌvi ra? Ta ndeé ka̱ ni̱ka̱ꞌa̱n nayóꞌo, káchí na saá: ―¡Katakaa̱ ndaa ún ra ndaꞌa̱ tón cruz! ");
INSERT INTO mim_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ta ta̱Pilato kóni ra kasa ndivi ra ña kóni ni̱vi, ta saá sa̱ña ra ta̱Barrabás, ta xa̱ꞌnda chiño ra no̱o̱ natropa ña kani na ta̱Jesús xíꞌin kuártá ña nóꞌni ka̱a si̱i̱n no̱o̱, ta katakaa̱ ndaa na ra ndaꞌa̱ tón cruz. ");
INSERT INTO mim_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ta natropa, kua̱ꞌa̱n ta̱Jesús xíꞌin na veꞌe chiño káꞌno, ta ni̱xaa̱ na ta na̱kaya na ndiꞌi ka̱ natropa. ");
INSERT INTO mim_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ta ki̱ndaa na tiko̱to̱ ndíxin ta̱Jesús ta sa̱kundixin na ra ñii tiko̱to̱ ndíꞌí, nda̱tán yóo tiko̱to̱ ndíxin ta̱rey, ta ki̱sa va̱ꞌa na ñii corona ñiño̱ ta chi̱nóo na ña si̱ni̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ta ki̱xáꞌá na káꞌa̱n na siꞌa xíꞌin ra: ―¡Ná koo va̱ꞌa ta̱Rey no̱o̱ najudío! ―káchí na, kúsiki na ra. ");
INSERT INTO mim_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ta su̱ku na tón yito̱n si̱ni̱ ra, ta ku̱ndaa na tási̱i yuꞌu̱ na no̱o̱ ra, ta xi̱kuxítí na no̱o̱ ra ña kusiki na kísa to̱ꞌó na ra. ");
INSERT INTO mim_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tá ndi̱ꞌi ña kúsiki na ra ta xáku̱ ndaa na ra, ta saá ki̱ndaa na tiko̱to̱ ndíꞌí ndíxin ra, ta tuku sa̱kundixin na ra tiko̱to̱ mi̱i ra. Ta kua̱ꞌa̱n ra xíꞌin na ña katakaa̱ ndaa na ra ndaꞌa̱ tón cruz. ");
INSERT INTO mim_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ta na̱kutáꞌan na xíꞌin ñii ta̱a ta̱ ki̱xi ñoo Cirene na̱ní ra Simón, ta̱yóꞌo kúu yivá ta̱Alejandro xíꞌin ta̱Rufo, ta nde̱e ra yuku̱ kua̱noꞌo̱ ra yichi̱ ñoo Jerusalén. Ta natropa ki̱sa ndu̱xa̱ na xíꞌin ta̱yóꞌo ña kuiso ra tón cruz ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ta kua̱ꞌa̱n ta̱Jesús xíꞌin na, ta ni̱xaa̱ na ñii xiiña na̱ní ña Gólgota, ña kóni kachí Leke Si̱ni̱ Ndi̱í. ");
INSERT INTO mim_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ta natropa ta̱xi na nduta̱ vino tá na̱sa̱ka̱ xíꞌin nduta̱ mirra koꞌo ra, ta ta̱Jesús ni̱‑xiin ra koꞌo ra nduta̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ta saá ka̱takaa̱ ndaa na ra ndaꞌa̱ tón cruz, ta natropa na̱taꞌví na tiko̱to̱ ra. Chi̱kaa̱ na ndati̱ ña koto na yukú ñii ñii nayóꞌo nakiꞌin ñii ñii loꞌo tiko̱to̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ni̱to̱nda̱a ka̱a i̱i̱n xita̱a̱n, ta ka̱takaa̱ ndaa na ra ndaꞌa̱ tón cruz. ");
INSERT INTO mim_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ta chi̱nóo kútu̱ na ñii tón vi̱ti̱ loꞌo si̱ni̱ tón cruz, ta no̱o̱ tón vi̱ti̱ yóꞌo na̱ka̱ꞌyi̱ to̱ꞌon ña káꞌa̱n xa̱ꞌa̱ kua̱chi ra, ta káchí ña saá: “Ta̱yóꞌo kúu ta̱Rey no̱o̱ najudío.” ");
INSERT INTO mim_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ta ka̱takaa̱ ndaa na o̱vi̱ ta̱kuíꞌná sii̱n ta̱Jesús, ñii ta̱kuíꞌná tákaa̱ ndaa ndaꞌa̱ tón cruz tón ñíndichi sii̱n kuaꞌá ra, ta inka̱ ra tákaa̱ ndaa ndaꞌa̱ tón cruz tón ñíndichi sii̱n yitin ra. ");
INSERT INTO mim_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Saá ku̱ndivi to̱ꞌon Ndios ña ni̱taa naprofeta xi̱na̱ꞌá xa̱ꞌa̱ ta̱a ta̱ tiꞌví Ndios saka̱ku ra na ñoyívi yóꞌo, káchí ña saá: “Kani si̱ni̱ ni̱vi ñii kúu ra xíꞌin ni̱vi na o̱n váꞌa, na toon ní ini”, káchí ña. ");
INSERT INTO mim_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ta nani̱vi yáꞌa yichi̱ no̱o̱ tákaa̱ ndaa ta̱Jesús kándiva̱ꞌa ní na xíꞌin ra, ta káva na si̱ni̱ na, káchí na saá xíꞌin ra: ―Yóꞌó kúu ta̱a ta̱ ni̱ka̱ꞌa̱n: “Yi̱ꞌi̱ sandiꞌi i̱ xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno, ta ti̱xin ña u̱ni̱ ki̱vi̱ tuku kasa va̱ꞌa i̱ ña”, ka̱chí ún, ");
INSERT INTO mim_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ta vitin, ¡saka̱ku xíꞌin mi̱i ún, ta sanoo xíꞌin mi̱i ún ndaꞌa̱ tón cruz! ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ta ñii ki̱ꞌva saá na sánáꞌa nda̱yí Ndios xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ kúsiki na ra ta xáku̱ ndaa na ra, káꞌa̱n na xíꞌin táꞌan na, káchí na saá: ―Ta̱yóꞌo sa̱ka̱ku ra inka̱ ni̱vi, ta o̱n vása ki̱ví saka̱ku xíꞌin mi̱i ra vitin. ");
INSERT INTO mim_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tá ndixa kúu ra Cristo, ta̱Rey ñoo yó Israel, ta ná sanoo xíꞌin mi̱i ra ndaꞌa̱ tón cruz vitin ña koto yó, ta saá kandixa yó ra ―káchí na. Ta na o̱vi̱ tákaa̱ ndaa xíꞌin ra kúsiki ñaꞌá na ta kándiva̱ꞌa na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ta ni̱to̱nda̱a ka̱a u̱xu̱ o̱vi̱ ma̱ꞌñó ndiví, ta ki̱xáꞌá kúnaa ndiꞌi ñoyívi a̱nda̱ ka̱a u̱ni̱ xikuaa. ");
INSERT INTO mim_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ta ka̱a u̱ni̱ kúu ña, ta saá ndeé va̱ꞌa ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá: ―Eloi, Eloi, ¿lama sabactani? ―káchí ta̱Jesús. To̱ꞌon yóꞌo káchí ña saá: Tata Yivá mi̱i i̱, Tata Yivá mi̱i i̱, ¿nda̱chun sa̱ndakoo ún yi̱ꞌi̱?, káchí ña. ");
INSERT INTO mim_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ta sava ni̱vi na yíta yatin yóꞌo, xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ra, ta káchí na saá: ―Koni̱ so̱ꞌo ndó, ta̱yóꞌo kána ra ta̱profeta Elías ña chindeé ñaꞌá ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ta ñii ta̱yóꞌo xíno ra kua̱ꞌa̱n ra, ta sa̱chii ra ñii tiko̱to̱ kuíkon xíꞌin vino yiyá, ta chi̱nóo ra ñayóꞌo no̱o̱ yito̱n, ta ndi̱kó ra taxi ra koꞌo ta̱Jesús, ta ni̱ka̱ꞌa̱n ta̱yóꞌo xíꞌin ni̱vi: ―O̱n keꞌé ndó ra. Ná koto yó án kixi ta̱Elías sanoo ñaꞌá ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ta saá ta̱Jesús xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra, ta ni̱xiꞌi̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tá mií saá xa̱ndi̱ko̱n ni̱nda̱ta̱ ma̱ꞌñó tiko̱to̱ tákaa̱ Cuarto Yi̱i̱ veꞌe ño̱ꞌo káꞌno, ta ki̱xáꞌá ña ni̱nda̱ta̱ ña chí ni̱no ta no̱o ña nda̱ ni̱no̱. ");
INSERT INTO mim_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ta ta̱ ndíso chiño xíꞌin ñii ciento natropa, yóo yatin ra no̱o̱ tákaa̱ ndaa ta̱Jesús, ta xi̱ni̱ so̱ꞌo ra ñii ndeé ni̱ka̱ꞌa̱n ta̱Jesús ta ni̱xiꞌi̱ ra, ta ta̱ ndíso chiño yóꞌo ni̱ka̱ꞌa̱n ra saá: ―Ndixa ta̱yóꞌo xi̱kuu Sa̱ꞌya Ndios ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ta nda̱ xíká yíta kua̱ꞌa̱ ní násíꞌí xíto ná. Ñii ñáyóꞌo kúu ñáMaría Magdalena, inka̱ ñá kúu ñáMaría, siꞌí ta̱José xíꞌin ta̱Jacobo ta̱loꞌo, ta inka̱ ñá kúu ñáSalomé. ");
INSERT INTO mim_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Náyóꞌo kúu ná xi̱ndiko̱n sa̱ta̱ ta̱Jesús, chi̱ndeé ná ra, ki̱sa chiño ná no̱o̱ ra estado Galilea. Ta yíta kua̱ꞌa̱ ní inka̱ násíꞌí ná ndíko̱n sa̱ta̱ ra, ná ki̱xaa̱ xíꞌin ra ñoo Jerusalén yóꞌo kúu ná. ");
INSERT INTO mim_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ta ki̱vi̱ viernes kúu ña, ta ki̱vi̱ yóꞌo kísa ndivi na ndiꞌi ña xíni̱ ñóꞌó na xa̱ꞌa̱ ki̱vi̱ yi̱i̱ ña nákindée na. Ta xikuaa ta xa kua̱ꞌa̱n kunaa kúu ña, xa yatin ní to̱nda̱a hora ña kixáꞌá ki̱vi̱ ña nakindée na. ");
INSERT INTO mim_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ta ki̱xaa̱ ta̱José, ta̱ ki̱xi ñoo Arimatea, ta kúu ra ta̱chiño káꞌno ta̱táꞌan naJunta Suprema. Ta ndáti ra ki̱vi̱ kixáꞌá kaꞌnda chiño Ndios ñoyívi yóꞌo. Ta o̱n vása ní‑yiꞌví ra, ta ni̱xa̱ꞌa̱n ra no̱o̱ ta̱Pilato ndu̱kú ra yi̱kí ko̱ñu ta̱Jesús ña sandúxu̱n ra ña. ");
INSERT INTO mim_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ta na̱kaꞌnda ní ini ta̱Pilato xi̱ni̱ so̱ꞌo ra ña kama ní ni̱xiꞌi̱ ta̱Jesús, ta ka̱na ra ta̱ ndíso chiño xíꞌin ñii ciento natropa va̱xi ra, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá ra: ―¿Án ñanda̱a̱ ni̱xiꞌi̱ ta̱Jesús? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ta ta̱ ndíso chiño yóꞌo ni̱ka̱ꞌa̱n ra, káchí ra: ―Ndixa xa ni̱xiꞌi̱ ta̱Jesús. Ta saá ta̱Pilato ta̱xi ra yichi̱ ndaꞌa̱ ta̱José nakiꞌin ra yi̱kí ko̱ñu ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ta ta̱José sa̱ta ra ñii tiko̱to̱ va̱ꞌa, ta ni̱xaa̱ ra ta sa̱noo ra yi̱kí ko̱ñu ta̱Jesús ndaꞌa̱ tón cruz, ta xíꞌin tiko̱to̱ va̱ꞌa yóꞌo chi̱súku ndaa ra yi̱kí ko̱ñu ta̱Jesús. Ta ni̱xa̱ꞌa̱n ra ta chi̱kaa̱ va̱ꞌa ñaꞌá ra ini kavua̱, ta na̱kasi ra yéꞌé kavua̱ yóꞌo xíꞌin ñii yu̱u̱ káꞌno. ");
INSERT INTO mim_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ta ñáMaría Magdalena xíꞌin ñáMaría siꞌí ta̱José xi̱to ná míkía̱ chi̱nóo na yi̱kí ko̱ñu ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ta ni̱yaꞌa ki̱vi̱ yi̱i̱ ña nákindée najudío, ta ñáMaría Magdalena xíꞌin ñáSalomé, xíꞌin ñáMaría siꞌí ta̱Jacobo, sa̱ta ná ña̱ꞌa ña xáꞌan támi ña ko̱ꞌo̱n ná chikaa̱ ná ña yi̱kí ko̱ñu ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta xita̱a̱n ní ta sa̱kán ke̱ta ño̱ꞌo, ki̱vi̱ no̱ó semana ña kúu domingo, kua̱ꞌa̱n ná no̱o̱ ni̱ndu̱xu̱n ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ta káꞌa̱n xíꞌin táꞌan mi̱i ná, káchí ná saá: ―¿Yu kúu na chindeé mi̱i yó ña sakutaꞌa na yu̱u̱ ña no̱na̱ ki̱ꞌvi yó kavua̱ yóꞌo? ―káchí ná. ");
INSERT INTO mim_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ta saá ni̱xaa̱ ná, ta na̱koto ná o̱n vása ndási̱ ka̱ yéꞌé kavua̱ xíꞌin yu̱u̱ káꞌno. ");
INSERT INTO mim_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ta ni̱ki̱ꞌvi ná ini kavua̱. Ta xi̱ni ná ñii ta̱a yóo ra sii̱n kuaꞌá no̱o̱ xi̱ndúꞌu̱ yi̱kí ko̱ñu ta̱Jesús, ta ndíxin ra ñii tiko̱to̱ káni̱, yaa ní ña, ta násíꞌí yóꞌo ni̱yi̱ꞌví ní ná. ");
INSERT INTO mim_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin ná: ―O̱n kuyi̱ꞌví ndó. Ndóꞌó nándukú ndó ta̱Jesús ta̱ñoo Nazaret, ta̱a ta̱ ka̱takaa̱ ndaa na ndaꞌa̱ tón cruz. Xa na̱taku̱ ra. O̱n ko̱ó ka̱ ra yóꞌo. Koto ndó no̱o̱ chi̱nóo na ra. ");
INSERT INTO mim_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ta kua̱ꞌa̱n ndó ta ndato̱ꞌon ndó xíꞌin ta̱Pedro xíꞌin inka̱ na ni̱xika xíꞌin ra, kachí ndó saá xíꞌin na: “Ko̱ꞌo̱n siꞌna ta̱Jesús no̱o̱ ndó ña kundati ra ndóꞌó estado Galilea. Kán koni ndó ra, tá yóo ña ni̱ka̱ꞌa̱n ra xíꞌin ndó”, kachí ndó xíꞌin na ―káchí ta̱a yóꞌo xíꞌin násíꞌí yóꞌo. ");
INSERT INTO mim_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ta saá násíꞌí yóꞌo ke̱e ná yéꞌé kavua̱, ta xíno ná kua̱ꞌa̱n ná, yíꞌví ní ná a̱nda̱ kísin ná kua̱ꞌa̱n ná. Ta ni̱‑xiin ná ndato̱ꞌon ná xíꞌin nda̱ ñii ni̱vi, saá chi yíꞌví ní ná. ");
INSERT INTO mim_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ta saá ta̱Jesús na̱taku̱ ra xita̱a̱n ní ki̱vi̱ no̱ó semana ña kúu domingo. Ta siꞌna ni̱ti̱vi ra no̱o̱ ñáMaría Magdalena ñá xa ta̱va ra u̱xa̱ níma̱ ndiva̱ꞌa xi̱komí. ");
INSERT INTO mim_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ta saá kua̱ꞌa̱n ñá ndato̱ꞌon ñá xíꞌin na ni̱xika xíꞌin ra. Ta na̱níꞌi ñá nayóꞌo, ndóo na kúchuchú ní ini na ta xáku ní na. ");
INSERT INTO mim_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ta xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ñá xa na̱taku̱ ta̱Jesús, saá chi xa xi̱ni ñá ra, ta ni̱‑xiin nayóꞌo kandixa na ñá. ");
INSERT INTO mim_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ta̱Jesús, ki̱vi̱ ni̱ti̱vi ra yichi̱ no̱o̱ o̱vi̱ ni̱vi na kua̱ꞌa̱n yuku̱, ta o̱n vása náꞌa ka̱ ra tá siꞌna xa na̱ꞌa ra. ");
INSERT INTO mim_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ta na o̱vi̱ yóꞌo ndi̱kó na ta ni̱xaa̱ na no̱o̱ yóo inka̱ na xi̱ndiko̱n sa̱ta̱ ta̱Jesús, ta nda̱to̱ꞌon na xíꞌin nayóꞌo ña xa xi̱ni na ra, ta na xi̱ni̱ so̱ꞌo ñayóꞌo ni̱‑xiin na kandixa na. ");
INSERT INTO mim_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ta saá ta̱Jesús ni̱ti̱vi ra no̱o̱ na u̱xu̱ ñii naxíka xíꞌin ra, tá ndóo ka̱ na no̱o̱ mesa. Ta ndeé ní ni̱ka̱ꞌa̱n ra xíꞌin na o̱n váꞌa kéꞌé na xa̱ꞌa̱ ña ni̱‑xiin na kandixa na ña na̱taku̱ ra, chi kísa sóꞌó xíꞌin mi̱i na, saá chi ni̱‑xiin na koni̱ so̱ꞌo na to̱ꞌon ña ni̱ka̱ꞌa̱n ni̱vi na xi̱ni xa na̱taku̱ ra. ");
INSERT INTO mim_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin na: ―Kua̱ꞌa̱n ndó ndiꞌi saá xiiña ñoyívi yóꞌo ta ka̱ꞌa̱n ndoso ndó to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ i̱ no̱o̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ni̱vi na kandixa yi̱ꞌi̱ ta kuchu na, ta saá Ndios saka̱ku ra na ña kutaku̱ na xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi. Ta ni̱vi na o̱n vása kandixa yi̱ꞌi̱, nayóꞌo kua̱chi ndíso na ta kua̱chi ñayóꞌo taxi ña ña xo̱ꞌvi̱ ní na ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ta vitin káꞌa̱n i̱ xíꞌin ndó, milagro yóꞌo koo xíꞌin na kándixa yi̱ꞌi̱: xíꞌin nda̱yí i̱ ta xíꞌin ki̱vi̱ i̱ tava na níma̱ ndiva̱ꞌa; ta ka̱ꞌa̱n na inka̱ no̱o̱ to̱ꞌon xa̱á ña o̱n vása ní‑sakuáꞌá na; ");
INSERT INTO mim_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","tá ñii sana tiin na tíko̱o̱ xati̱ ta o̱n kóo ña kundoꞌo na; tá ñii sana koꞌo na táveneno ta o̱n kóo ña kundoꞌo na; ta chinóo na ndaꞌa̱ na si̱ni̱ án no̱o̱ kíꞌvi̱ na ndeé ndóꞌo ta nduva̱ꞌa na. Milagro yóꞌo kuu ña kunakaa̱ xíꞌin na kándixa yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tá ndi̱ꞌi ni̱ka̱ꞌa̱n ta̱Jesús saá xíꞌin na, ta nda̱a ra kua̱noꞌo̱ ra ñoyívi ni̱no, ta xi̱koo ra sii̱n kuaꞌá Ndios. ");
INSERT INTO mim_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ta saá na ni̱xika xíꞌin ra ki̱xáꞌá na kua̱ꞌa̱n na ka̱ꞌa̱n ndoso na to̱ꞌon Ndios no̱o̱ ni̱vi ndiꞌi saá xiiña. Ta mi̱i ta̱Jesús chíndeé ra na ña yóo milagro xíꞌin ni̱vi. Xa̱ꞌa̱ ñayóꞌo ni̱vi na xi̱to milagro yóꞌo ta na ni̱xika xíꞌin ta̱Jesús kúnda̱a̱ ini na ndí to̱ꞌon káꞌa̱n ndoso na kúu ñanda̱a̱. Saá yóo ña.");
INSERT INTO mim_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","“Tata Teófilo, xa kua̱ꞌa̱ ní ni̱vi ni̱taa na xa̱ꞌa̱ ña ndixa ke̱ꞌé Jesucristo xíꞌin yó. ");
INSERT INTO mim_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ta ñii ki̱ꞌva nda̱tán yóo to̱ꞌon ña sa̱náꞌa na xi̱ndiko̱n sa̱ta̱ ra, saá yóo ña ni̱taa na. Ta̱nda̱ ki̱vi̱ ki̱xáꞌá Jesucristo kísa chiño ra ñoyívi yóꞌo, xi̱ni na ña ke̱ꞌé ra, ta xi̱ni̱ so̱ꞌo na ña sa̱náꞌa ra, ta nayóꞌo ni̱ka̱ꞌa̱n ndoso na to̱ꞌon ra. ");
INSERT INTO mim_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ta saá tuku yi̱ꞌi̱ xa sa̱kuáꞌá va̱ꞌa i̱ ndiꞌi ña ke̱ꞌé ra xíꞌin ndiꞌi ña sa̱náꞌa ra nda̱ ki̱vi̱ ki̱xaa̱ ra ñoyívi yóꞌo. Ta xáni si̱ni̱ i̱ va̱ꞌa ná taa i̱ to̱ꞌon ña nda̱a̱ yóꞌo, nda̱tán ni̱xi̱yo ña, ta tiꞌví i̱ tutu yóꞌo xaa̱ ña ndaꞌa̱ ún, Teófilo ta̱ to̱ꞌó. ");
INSERT INTO mim_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ta saá kunda̱a̱ va̱ꞌa ini ún ñanda̱a̱ kúu ña xa sa̱náꞌa na yóꞌó xa̱ꞌa̱ Jesucristo”, káchí ta̱Lucas xíꞌin ta̱Teófilo. ");
INSERT INTO mim_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ki̱vi̱ ta̱rey Herodes xáꞌnda chiño ra no̱o̱ nañoo estado Judea, ni̱xi̱yo ñii su̱tu̱ na̱ní ra Zacarías. Ta̱yóꞌo kúu ñii ta̱ nátaꞌan xíꞌin ñii tiꞌvi su̱tu̱, ta ki̱vi̱ tiꞌvi nasu̱tu̱ yóꞌo na̱ní Abías. Ñásíꞌí ta̱Zacarías yóꞌo na̱ní ñá Elisabet, ta mi̱i ra xíꞌin ñásíꞌí ra kúu nasa̱ꞌya ñani síkuá ta̱su̱tu̱ Aarón. ");
INSERT INTO mim_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ta̱Zacarías xíꞌin ñásíꞌí ra ñáElisabet ni̱vi nanda̱a̱ kúu na no̱o̱ Ndios, ta kándixa ndiꞌi na ña xáꞌnda chiño Ndios, ta inka̱ ni̱vi ni̱‑kuchiño naníꞌi na to̱ꞌon ña ka̱ꞌa̱n o̱n váꞌa na xa̱ꞌa̱ ta̱Zacarías xíꞌin ñásíꞌí ra. ");
INSERT INTO mim_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ta o̱n ko̱ó sa̱ꞌya na, chi ñánóma kúu ñáElisabet, ta ñáyóꞌo xíꞌin yii̱ ñá na xi̱kua̱ꞌa̱ ní kúu na. ");
INSERT INTO mim_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ta saá ni̱to̱nda̱a ki̱vi̱ nasu̱tu̱ natáꞌan ta̱Zacarías ki̱xaa̱ na kasa chiño na no̱o̱ Ndios veꞌe ño̱ꞌo káꞌno ña nákaa̱ ñoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chi̱kaa̱ na ndati̱ xíꞌin yu̱u̱ válí chi saá kéꞌé na ña koto na yukú chiño kukomí ñii ñii su̱tu̱. Ta saá ke̱ta ña ta̱Zacarías ni̱niꞌi ra chiño ña ki̱ꞌvi ra Cuarto Yi̱i̱ ña nákaa̱ ini veꞌe ño̱ꞌo yóꞌo, ta kaꞌmi ra xuxa va̱ꞌa ña ndóso no̱o̱ mesa tón yi̱i̱. ");
INSERT INTO mim_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ki̱vi̱ ni̱ki̱ꞌvi ta̱Zacarías Cuarto Yi̱i̱ ña kaꞌmi ra xuxa va̱ꞌa no̱o̱ Ndios, ta ndiꞌi ni̱vi ndóo na ndáti na ke̱ꞌe ña kúu yéꞌé veꞌe ño̱ꞌo, ta káꞌa̱n na xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ta saá ñii ángel ki̱xi no̱o̱ Ndios ki̱xaa̱ ña no̱o̱ ta̱Zacarías, ñíndichi ña sii̱n kuaꞌá mesa tón yi̱i̱ no̱o̱ xíxi̱ xuxa va̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ta xi̱ni ra ñaángel, ta ki̱xáꞌá ndíꞌi ní ini ra, ta yíꞌví ní ra. ");
INSERT INTO mim_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ta saá ni̱ka̱ꞌa̱n ñaángel xíꞌin ra: ―Tata Zacarías, o̱n kuyi̱ꞌví ún, chi Ndios xi̱ni̱ so̱ꞌo ra ña ni̱ka̱ꞌa̱n ún xíꞌin ra, ta keꞌé ra ñii ñava̱ꞌa xíꞌin ndó: koo sa̱ꞌya ún xíꞌin ñásíꞌí ún ñáElisabet, ta chinóo ndó ki̱vi̱ ra kunaní ra Juan. ");
INSERT INTO mim_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ki̱vi̱ kaku sa̱ꞌya ndó, ta kusii̱ ní ini ndóꞌó. Ta kusii̱ ní ini inka̱ ni̱vi ki̱vi̱ kaku ra, ");
INSERT INTO mim_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","chi no̱o̱ Ndios sa̱ꞌya ndó kuu ra ñii ta̱a ta̱ káꞌno. Ta nda̱ ñii ki̱vi̱ o̱n koꞌo ra vino, ni o̱n koꞌo ra inka̱ nduta̱ tá sáxíini ni̱vi. Ta̱nda̱ ki̱vi̱ kixáꞌá ra kunakaa̱ ra ti̱xin siꞌí ra, ta chútú níma̱ ra xíꞌin ñandee̱ Níma̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ta saá chindeé ra kua̱ꞌa̱ ní naIsrael sanandikó ra níma̱ na ña ko̱ꞌo̱n na yichi̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nda̱tán ñii ki̱ꞌva ni̱xi̱yo ndee̱ Níma̱ Ndios xíꞌin ta̱profeta Elías xi̱na̱ꞌá, saá koo Níma̱ Ndios xíꞌin sa̱ꞌya ndó yóꞌo. Ta kukomí ra yichi̱ ka̱ꞌa̱n ra xíꞌin ni̱vi ña nakutáꞌan va̱ꞌa na kúu yivá xíꞌin sa̱ꞌya na. Ta chindeé ra ni̱vi na o̱n xi̱in koni̱ so̱ꞌo ña nduu na ni̱vi na va̱ꞌa kandixa Ndios. Saá sa̱ꞌya ndó yóꞌo chindeé ra naIsrael ña koo tiꞌva na nakiꞌin na Ta̱a ta̱Káꞌno no̱o̱ yó ―káchí ñaángel xíꞌin ta̱Zacarías. ");
INSERT INTO mim_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ta nda̱kuii̱n ta̱Zacarías, ni̱nda̱ka̱ to̱ꞌon ra ñaángel, káchí ra saá: ―¿Ndasaá koo kunda̱a̱ ini i̱ ña kundivi ña káꞌa̱n ún xíꞌin i̱?, chi vitin ta̱xi̱kua̱ꞌa̱ ní kúu i̱, ta saá tuku ñáxi̱kua̱ꞌa̱ ní kúu ñásíꞌí i̱ ―káchí ta̱Zacarías xíꞌin ñaángel. ");
INSERT INTO mim_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ta nda̱kuii̱n ñaángel, ni̱ka̱ꞌa̱n ña xíꞌin ta̱Zacarías. ―Yi̱ꞌi̱ na̱ní i̱ Gabriel, ta ndiꞌi saá ki̱vi̱ ñíndichi i̱ no̱o̱ Ndios. Ta mi̱i Ndios kúu ta̱ ti̱ꞌví yi̱ꞌi̱ va̱xi i̱ ka̱ꞌa̱n i̱ ñava̱ꞌa yóꞌo xíꞌin ún. ");
INSERT INTO mim_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ta vitin xa̱ꞌa̱ ña o̱n vása ní‑kandixa ún to̱ꞌon ña ni̱ka̱ꞌa̱n i̱ xíꞌin ún, o̱n kuchiño ka̱ ka̱ꞌa̱n ún nda̱ ñii to̱ꞌon nda̱ kixaa̱ ki̱vi̱ kundivi to̱ꞌon yóꞌo. Ta ndixa va̱xi ñii ki̱vi̱ ña kundivi ndiꞌi ña ni̱ka̱ꞌa̱n i̱ xíꞌin ún ―káchí ñaángel xíꞌin ta̱Zacarías. ");
INSERT INTO mim_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ta ni̱vi na ndóo ndáti ke̱ꞌe, káꞌa̱n xíꞌin táꞌan na ña kuáchi̱ ní ta̱Zacarías, ta ki̱xáꞌá na ndíꞌi ní ini na xa̱ꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ta saá ke̱ta ta̱Zacarías, ta ni̱‑kuchiño ka̱ꞌa̱n ra xíꞌin na. Ta ku̱nda̱a̱ ini na ndí Ndios ti̱ꞌví ra ñii ña ni̱ti̱vi no̱o̱ ta̱yóꞌo ini Cuarto Yi̱i̱ veꞌe ño̱ꞌo. Ña̱kán kía̱ ni̱‑kuchiño ka̱ꞌa̱n ka̱ ra xíꞌin na, nda̱ sánáꞌa kuiti ra xíꞌin ndaꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ta ni̱to̱nda̱a ki̱vi̱ ndi̱ꞌi ki̱sa chiño ta̱Zacarías veꞌe ño̱ꞌo, ta kua̱noꞌo̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ta saá ni̱yaꞌa loꞌo ki̱vi̱, ta ñásíꞌí ra ñáElisabet ni̱ke̱e sa̱ꞌya ñá. Ta ni̱xi̱yo ñá o̱ꞌo̱n yo̱o̱ ini veꞌe ñá, ta nda̱ loꞌo o̱n vása ní‑keta ñá. Ta ni̱ka̱ꞌa̱n ñá, ka̱chí ñá saá: ");
INSERT INTO mim_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ndios ke̱ꞌé ra ñava̱ꞌa xíꞌin i̱, xa ni̱taxi ra ñii ñato̱ꞌó káꞌno ndaꞌa̱ i̱ chi vitin koo ñii sa̱ꞌya i̱, ta ki̱ndaa ra ña kúkaꞌan no̱o̱ i̱ no̱o̱ ni̱vi”, ka̱chí ñá. ");
INSERT INTO mim_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Xa i̱ño̱ yo̱o̱ ñóꞌo sa̱ꞌya ñáElisabet ta saá ti̱ꞌví Ndios ñaángel Gabriel kua̱ꞌa̱n ña ñoo Nazaret, ña nákaa̱ estado Galilea. ");
INSERT INTO mim_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kua̱ꞌa̱n ña koto ña ñii ñákuáa̱n loꞌo na̱ní ñá María, ñá ta̱ꞌán to̱nda̱a nda̱ ñii ta̱a kúu ñá. Ta xa ndási̱ ña tonda̱ꞌa̱ ñá xíꞌin ñii ta̱a na̱ní ra José, sa̱ꞌya ñani síkuá ta̱rey David kúu ra. ");
INSERT INTO mim_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ta ni̱xaa̱ ñaángel no̱o̱ ñáMaría yóꞌo ta chi̱ndeé ñaꞌá ña, ni̱ka̱ꞌa̱n ña, káchí ña saá: ―¡Kuaꞌa, nana! Yóꞌó kúu ñá ni̱niꞌi ñava̱ꞌa no̱o̱ Ndios, ta yóo ra xíꞌin ún. Ta keꞌé ra ñava̱ꞌa ní ka̱ xíꞌin ún no̱o̱ ndiꞌi inka̱ násíꞌí. ");
INSERT INTO mim_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ta ñáMaría xi̱ni ñá ñaángel yóꞌo, ta xi̱ni̱ so̱ꞌo ñá to̱ꞌon ña ni̱ka̱ꞌa̱n ña, ta ki̱xáꞌá ndíꞌi ní ini ñá, xáni si̱ni̱ ñá: “¿Nda̱chun ni̱ka̱ꞌa̱n ñaángel to̱ꞌon yóꞌo xíꞌin yó?” ");
INSERT INTO mim_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ta saá káꞌa̱n ka̱ ñaángel xíꞌin ñá: ―O̱n kuyi̱ꞌví ún, chi Ndios taxi ra ñii ñato̱ꞌó ní ndaꞌa̱ ún. ");
INSERT INTO mim_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ta vitin ke̱e sa̱ꞌya ún, ta ki̱vi̱ kaku ta̱loꞌo sa̱ꞌya ún, ta chinóo ún ki̱vi̱ ra kunaní ra Jesús. ");
INSERT INTO mim_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ta kuu ra ta̱a ta̱ káꞌno, ta sakunaní na ra Sa̱ꞌya Ndios ta̱Káꞌno, ta Ndios taxi ra ña kuu ta̱yóꞌo ta̱rey káꞌno. Nda̱tán ni̱xi̱yo xi̱i̱ síkuá ra ta̱rey David, saá koo ra. ");
INSERT INTO mim_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ta kaꞌnda chiño ra no̱o̱ naIsrael, ta nda̱ ñii ki̱vi̱ o̱n ndiꞌi xa̱ꞌa̱ ndee̱ ra, ta kuu ra ta̱rey ndiꞌi saá ki̱vi̱ ña va̱xi ―káchí ñaángel xíꞌin ñáMaría. ");
INSERT INTO mim_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ta saá nda̱kuii̱n ñáMaría: ―¿Ta ndasaá koo ñayóꞌo?, chi nda̱ ñii ta̱a o̱n ta̱ꞌán to̱nda̱a yi̱ꞌi̱ ―káchí ñá xíꞌin ñaángel. ");
INSERT INTO mim_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ta nda̱kuii̱n ñaángel: ―Ta Níma̱ Ndios kixaa̱ ña xíꞌin ún, ta ndee̱ Ndios ta̱Káꞌno kixaa̱ ña nda̱tán ñii ku̱nda̱ti̱ koo ña, ta nakundixin níí ndiꞌi ún ña. Ña̱kán sa̱ꞌya ún kuu ra ñii ta̱a yi̱i̱, ta kunaní ra Sa̱ꞌya Ndios. ");
INSERT INTO mim_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ta ñáveꞌe ún ñáElisabet xa ñóꞌo sa̱ꞌya ñá. Vará ñáxi̱kua̱ꞌa̱ ní kúu ñá, ta o̱n ki̱ví koo sa̱ꞌya ñá, káchí ni̱vi, ta vitin xa i̱ño̱ yo̱o̱ ñóꞌo sa̱ꞌya ñá. ");
INSERT INTO mim_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Saá chi Ndios kúchiño ra kasa ndivi ra ndiꞌi chiño, o̱n ko̱ó nda̱ ñii chiño ña yo̱ꞌvi̱ no̱o̱ Ndios ―káchí ñaángel xíꞌin ñáMaría. ");
INSERT INTO mim_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ta nda̱kuii̱n ñáMaría, káchí ñá saá: ―Yi̱ꞌi̱ kúu ñá kísa chiño no̱o̱ Ndios, ta va̱ꞌa ná keꞌé ra xíꞌin i̱ nda̱tán yóo ña ni̱ka̱ꞌa̱n ún xíꞌin i̱ ―káchí ñáMaría xíꞌin ñaángel. Ta saá ke̱e ñaángel kua̱ꞌa̱n ña. ");
INSERT INTO mim_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ta ni̱yaꞌa loꞌo ki̱vi̱, ta ke̱e ñáMaría, nómi̱ ñá kua̱ꞌa̱n ñá ñoo ña nákaa̱ ma̱ꞌñó yuku̱ estado Judea. ");
INSERT INTO mim_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ta ni̱xaa̱ ñáMaría, ta ni̱ki̱ꞌvi ñá veꞌe ta̱Zacarías, ta ni̱ka̱ꞌa̱n ñá to̱ꞌon chindeé ñá ñáElisabet. ");
INSERT INTO mim_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tá xi̱ni̱ so̱ꞌo ñáElisabet ña chi̱ndeé ñáMaría, ta ka̱ndeta sa̱ꞌya ñá ti̱xin ñá, ta Níma̱ Ndios ki̱xaa̱ ña, ta sa̱kutú ña níma̱ ñáElisabet xíꞌin ndee̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ta xíꞌin ndiꞌi ndee̱ ñá ni̱ka̱ꞌa̱n ñá xíꞌin ñáMaría, káchí ñá saá: ―¡Ta káꞌno ní ka̱ ñava̱ꞌa ke̱ꞌé Ndios xíꞌin ún no̱o̱ ndiꞌi inka̱ násíꞌí ñoyívi yóꞌo! ¡Ta káꞌno ní ñava̱ꞌa keꞌé ra xíꞌin sa̱ꞌya ún! ");
INSERT INTO mim_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ta, ¡nda̱chun Ndios ke̱ꞌé ra ñava̱ꞌa xíꞌin i̱ ña ta̱xi ra ki̱xaa̱ ún koto ún yi̱ꞌi̱! ¡Yu kúu yi̱ꞌi̱, ta va̱xi ún koto ún yi̱ꞌi̱! Chi yóꞌó kúu siꞌí ta̱Káꞌno no̱o̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Xi̱ni̱ so̱ꞌo i̱ to̱ꞌon chi̱ndeé ún yi̱ꞌi̱, ta saá sa̱ꞌya i̱ ka̱ndeta ra ti̱xin i̱ chi kúsii̱ ní ini ra. ");
INSERT INTO mim_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ta nákaa̱ ñasi̱i̱ níma̱ ún, chi kándixa ún Ndios ña kasa ndivi ra ña ni̱ka̱ꞌa̱n ra xíꞌin ún ―káchí ñáElisabet xíꞌin ñáMaría. ");
INSERT INTO mim_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ta ni̱ka̱ꞌa̱n ñáMaría saá: Xíꞌin níma̱ i̱ kísa káꞌno i̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kúsii̱ ní ini i̱ chi Ndios sa̱ka̱ku ra yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ndios ndáa ra yi̱ꞌi̱, vará ndasaá kuiti ñándáꞌví ñá kísa chiño no̱o̱ ra kúu i̱. Ña̱kán ni̱vi na táku̱ vitin xíꞌin ni̱vi na kutaku̱ ki̱vi̱ ña va̱xi sakunaní na yi̱ꞌi̱: Ñaꞌa̱ ñá nákaa̱ ñasi̱i̱ níma̱, kachí ni̱vi xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Saá chi Ndios ta̱ kómí ndee̱ káꞌno, ke̱ꞌé ra kua̱ꞌa̱ ní ñava̱ꞌa xíꞌin i̱. ¡Ta̱a ta̱yi̱i̱ kúu Ndios! ");
INSERT INTO mim_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ta ki̱vi̱ vitin xíꞌin ki̱vi̱ ña va̱xi Ndios kúndáꞌví ini ra xíni ra ni̱vi na kísa to̱ꞌó ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ndios xíꞌin ndee̱ mi̱i ra ki̱sa ndivi ra kua̱ꞌa̱ ní chiño náꞌno. Ta xíꞌin ndee̱ ra xa̱ta níꞌnó ra ni̱vi na kísa káꞌno xíꞌin mi̱i. ");
INSERT INTO mim_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ta Ndios sa̱noo ra nda̱ ni̱no̱ ni̱vi nanáꞌno ñoyívi yóꞌo, na kúu na ña̱ꞌa ní ini, ta nda̱níꞌi síkón ra ni̱vi na o̱n vása ña̱ꞌa ini ña nduu na nanáꞌno. ");
INSERT INTO mim_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ndios ta̱xi ra kua̱ꞌa̱ ní ñaxíxi ndaꞌa̱ ni̱vi nandáꞌví na xíꞌi̱ so̱ko, ta ta̱xi ra ni̱vi nakuíká kua̱ꞌa̱n vi̱chí na. ");
INSERT INTO mim_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ndios chi̱ndeé ra naIsrael, ndiꞌi saá ki̱vi̱ kúndáꞌví ini ra xíni ra na, ");
INSERT INTO mim_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","chi saá ni̱ka̱ꞌa̱n ra xíꞌin xi̱i̱ síkuá yó ta̱Abraham, ta xíꞌin ndiꞌi sa̱ꞌya ñani síkuá ta̱yóꞌo. Ndios káchí ra kundáꞌví ini ra koni ra mi̱i yó ndiꞌi saá ki̱vi̱ ña va̱xi, káchí ñáMaría. ");
INSERT INTO mim_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ta saá ni̱ndo̱o ñá, ni̱xi̱yo ñá xíꞌin ñáElisabet u̱ni̱ yo̱o̱, ta ke̱e ñá kua̱noꞌo̱ ñá. ");
INSERT INTO mim_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tá xa ni̱to̱nda̱a ki̱vi̱ kaku sa̱ꞌya ñáElisabet, ta ka̱ku ñii ta̱a loꞌo. ");
INSERT INTO mim_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ta saá ku̱nda̱a̱ ini naveꞌe ñá xíꞌin na xíni̱ táꞌan xíꞌin ñá ndí Ndios ke̱ꞌé ñava̱ꞌa xíꞌin ñá ña ka̱ku sa̱ꞌya ñá. Ta saá kúsii̱ ní ini ndiꞌi na xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ta ni̱to̱nda̱a ki̱vi̱ o̱na̱ ka̱ku tikuáꞌá loꞌo yóꞌo, ta ki̱sa ndivi na costumbre na̱ní ña circuncisión xíꞌin ra ña kóni kachí xáꞌnda na loꞌo ñii̱ si̱ni̱ ñate̱e ra. Ta kóni na sakunaní na ra Zacarías, chi saá na̱ní yivá ra. ");
INSERT INTO mim_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ta ni̱ka̱ꞌa̱n siꞌí ra ñáElisabet, káchí ñá saá: ―O̱n ki̱ví saá, va̱ꞌa ná kunaní ra Juan ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ta nda̱kuii̱n na, káchí na: ―¿Nda̱chun kóni ún kunaní ra saá? Nda̱ ñii naveꞌe ún o̱n ko̱ó na̱ní saá ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ta sa̱náꞌa ndaꞌa̱ na no̱o̱ yivá ra ndasaá kóni ra kunaní sa̱ꞌya ra. ");
INSERT INTO mim_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ta saá ndu̱kú ra ñii vi̱ti̱ no̱o̱ na, ta ta̱a ra ki̱vi̱ no̱o̱ tón vi̱ti̱ yóꞌo: “Kunaní ra Juan.” Ta na̱kaꞌnda ini ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ta saá xa̱ndi̱ko̱n ta̱Zacarías ki̱xáꞌá kúchiño ka̱ꞌa̱n ra, ta kísa káꞌno ra Ndios. ");
INSERT INTO mim_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ta ndiꞌi ni̱vi na ndóo yóꞌo na̱kaꞌnda ini na, ta ki̱xáꞌá na sákui̱ta̱ níꞌnó na to̱ꞌon xa̱ꞌa̱ ñayóꞌo ndiꞌi saá ñoo ña ñóꞌo yuku̱ estado Judea. ");
INSERT INTO mim_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ta ndiꞌi ni̱vi na xi̱ni̱ so̱ꞌo ña ndo̱ꞌo ta̱Zacarías, xáni ini na xa̱ꞌa̱ ña, ta ni̱nda̱ka̱ to̱ꞌon táꞌan na, káchí na saá: ―¿Yu kuu tikuáꞌá loꞌo sa̱ꞌya ta̱Zacarías ki̱vi̱ kukáꞌno ra? ―káchí na, chi kúnda̱a̱ ini na ndí kómí ta̱loꞌo yóꞌo ndee̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ta Níma̱ Ndios sa̱kutú ña ini ta̱Zacarías xíꞌin ndee̱ Ndios, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ná kasa káꞌno yó Ndios, ta̱ xáꞌnda chiño no̱o̱ mi̱i yó naIsrael, Ndios chi̱ndeé ra ni̱vi nañoo yó na kúu na ndíko̱n ñaꞌá, ta sa̱ka̱ku ra yó. ");
INSERT INTO mim_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ta ti̱ꞌví ra ñii ta̱a ta̱ndeé ní, ta kixaa̱ ra saka̱ku ra mi̱i yó. Ta̱ndeé yóꞌo kúu ñii sa̱ꞌya ñani síkuá ta̱rey David, ta̱a ta̱ ki̱sa chiño no̱o̱ Ndios kui̱ya̱ xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Saá yóo ña ki̱ndo̱o Ndios xíꞌin naxi̱i̱ síkuá yó naIsrael, chi Ndios ta̱xi ra to̱ꞌon ra ndaꞌa̱ naprofeta ña ni̱ka̱ꞌa̱n ndoso na kui̱ya̱ xi̱na̱ꞌá, ka̱chí na saá: ");
INSERT INTO mim_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ndios saka̱ku ra mi̱i yó no̱o̱ na sáa̱ ini xíni yó, ta saka̱ku ra mi̱i yó no̱o̱ ndiꞌi ni̱vi na o̱n xi̱in koni yó. ");
INSERT INTO mim_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Xi̱na̱ꞌá ku̱ndáꞌví ini Ndios xi̱ni ra naxi̱i̱ síkuá yó, ta kasa ndivi ra to̱ꞌon ra ña chi̱ndúꞌu̱ ra keꞌé ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ni̱ka̱ꞌa̱n Ndios xíꞌin xi̱i̱ síkuá yó ta̱Abraham ");
INSERT INTO mim_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ña ndixa saka̱ku ra mi̱i yó no̱o̱ ni̱vi na sáa̱ ini xíni yó, ña̱kán o̱n kuyi̱ꞌví yó kasa chiño yó no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ta kuu yó ni̱vi na nda̱kú ini, na nataxi xíꞌin mi̱i no̱o̱ Ndios, saá kasa ndivi yó chiño no̱o̱ ra ndiꞌi saá ki̱vi̱ ña kutaku̱ yó, káchí ta̱Zacarías. ");
INSERT INTO mim_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin tikuáꞌá loꞌo sa̱ꞌya ra, káchí ra saá: Yóꞌó, ta̱loꞌo, ki̱vi̱ kukáꞌno ún, ta kuu ún ta̱profeta ta̱ ka̱ꞌa̱n ndoso to̱ꞌon Ndios. Ndasa va̱ꞌa ún yichi̱ xa̱ꞌa̱ ña kivi kixaa̱ Ta̱a ta̱Káꞌno no̱o̱ yó, ta̱a ta̱ va̱xi ñoyívi yóꞌo, ta yóꞌó kuu ta̱ ko̱ꞌo̱n siꞌna no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ta sanáꞌa ún ni̱vi ndasaá koo ña saka̱ku Ndios ni̱vi na ndíko̱n ñaꞌá, chi kasa káꞌno ini ra xa̱ꞌa̱ kua̱chi na. ");
INSERT INTO mim_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sandoo ra ndiꞌi kua̱chi yó chi Ndios kúu ra ta̱ káꞌno ní ini. Ña̱kán tiꞌví ra ñii ta̱a ta̱ yóo ñoyívi ni̱no, ta nda̱tán yóo ñoꞌo̱ ña yéꞌe, saá yóo ta̱a ta̱ tiꞌví ra. Ki̱vi̱ kixaa̱ ra ñoyívi yóꞌo, ta nda̱tán yóo ñii ki̱vi̱ xa̱á, saá koo ña. ");
INSERT INTO mim_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Saá chi keꞌé ra ña nayeꞌe ñoꞌo̱ no̱o̱ ni̱vi na xíka yichi̱ naa no̱o̱ yóo ña o̱n váꞌa, ta saá kuchiño nakiꞌin na ko̱ꞌo̱n na yichi̱ va̱ꞌa, ta kunakaa̱ ñava̱ꞌa ini na, káchí ta̱Zacarías xíꞌin tikuáꞌá loꞌo sa̱ꞌya ra. ");
INSERT INTO mim_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ta saá ta̱loꞌo ta̱Juan yóꞌo xa̱ꞌno ra, ta ndu̱u ra ñii ta̱káꞌno xíꞌin ndee̱ Níma̱ Ndios. Ta ke̱e ra kua̱ꞌa̱n ra, ta táku̱ ra yuku̱ yi̱chí ta̱nda̱ ni̱to̱nda̱a ki̱vi̱ ki̱xáꞌá ra káꞌa̱n ndoso ra to̱ꞌon Ndios no̱o̱ nañoo mi̱i ra naIsrael. ");
INSERT INTO mim_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kui̱ya̱ saá xa̱ꞌnda chiño ta̱rey Augusto ña ndakoo ñii censo ndiꞌi ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Censo yóꞌo kúu ñano̱ó nda̱koo kui̱ya̱ xáꞌnda chiño ta̱gobernador Cirenio no̱o̱ na táku̱ ñoo estado Siria. ");
INSERT INTO mim_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ta saá ndiꞌi ni̱vi ni̱xa̱ꞌa̱n na ñoo no̱o̱ xi̱taku̱ xi̱i̱ síkuá na, ta náka̱ꞌyi̱ ki̱vi̱ na. ");
INSERT INTO mim_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ña̱kán kía̱ ke̱e ta̱José ñoo ra Nazaret ña ndáꞌvi ndaa estado Galilea, ta kua̱ꞌa̱n ra ñoo Belén ña ndáꞌvi ndaa estado Judea, chi ta̱José kúu ra sa̱ꞌya ñani síkuá ta̱rey David, ta̱a ta̱ xi̱taku̱ ñoo Belén kui̱ya̱ xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ta ke̱e ta̱José kua̱ꞌa̱n ra, ta kua̱ꞌa̱n ñáMaría xíꞌin ra naka̱ꞌyi̱ ki̱vi̱ na, chi xa ki̱ndo̱o ta̱José tonda̱ꞌa̱ ra xíꞌin ñá, ta ñáyóꞌo xa ñóꞌo sa̱ꞌya ñá. ");
INSERT INTO mim_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ta ni̱xaa̱ na ñoo Belén, ta ni̱to̱nda̱a ki̱vi̱ kaku sa̱ꞌya ñá. ");
INSERT INTO mim_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ta saá ka̱ku ñii ta̱a loꞌo, sa̱ꞌya no̱ó ñá kúu ra, ta chi̱súku ndaa ñá ra xíꞌin tiko̱to̱, ta chi̱ndúꞌu̱ ñá ra ini yito̱n no̱o̱ xíxaꞌan kiti̱, chi o̱n vása ní‑naníꞌi na veꞌe no̱o̱ kindo̱o na, saá chi xa chútú ndiꞌi veꞌe no̱o̱ kísi̱n ni̱vi na xíka yichi̱. ");
INSERT INTO mim_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tá ñoó ka̱ku sa̱ꞌya ñáMaría, ta yuku̱ yatin ñoo Belén, ndóo na ndáa ndikachi. ");
INSERT INTO mim_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ta saá ke̱ta ñii ñaángel ña ki̱xi no̱o̱ Ndios, ta livi ní, ta káꞌno ní náyeꞌe ñoꞌo̱ ña ke̱e no̱o̱ Ndios, ta náyeꞌe ña no̱o̱ ndóo na ndáa ndikachi, ta ni̱yi̱ꞌví ní ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ta ni̱ka̱ꞌa̱n ñaángel xíꞌin na, káchí ña saá: ―O̱n kuyi̱ꞌví ndó, chi va̱xi i̱ ndato̱ꞌon i̱ ñava̱ꞌa xíꞌin ndó, ta o̱n si̱ví ndasaá ñii ñava̱ꞌa xa̱ꞌa̱ ndóꞌó kúu ña káꞌa̱n i̱, ta vitin káꞌa̱n i̱ ñava̱ꞌa xa̱ꞌa̱ ndiꞌi ni̱vi, xa̱ꞌa̱ ña kusii̱ ní ini na xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ki̱vi̱ vitin ka̱ku ñii ta̱loꞌo ñoo ta̱rey David, ta ta̱loꞌo yóꞌo kúu Ta̱a ta̱ Saka̱ku ndóꞌó. Ta Cristo Ta̱a ta̱Káꞌno no̱o̱ yó kúu ra. ");
INSERT INTO mim_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ta ñayóꞌo koto ndó ña kunda̱a̱ ini ndó ndí to̱ꞌon ña káꞌa̱n i̱ kúu ñanda̱a̱, chi naníꞌi ndó ta̱loꞌo nísúku ra tiko̱to̱, ta nákaa̱ ra ini yito̱n no̱o̱ xíxaꞌan kiti̱ ―káchí ñaángel xíꞌin na ndáa ndikachi. ");
INSERT INTO mim_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ta xa̱ndi̱ko̱n ki̱xaa̱ kua̱ꞌa̱ ní ka̱ naángel, ta na̱kutáꞌan na xíꞌin ñaángel yóꞌo. Ta ki̱xáꞌá na kasa káꞌno na Ndios, káchí na saá: ");
INSERT INTO mim_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Ná kanóo síkón ñato̱ꞌó Ndios, ta̱ yóo ñoyívi ni̱no! Ná koo va̱ꞌa ini ni̱vi ñoyívi yóꞌo, na kúu ni̱vi na kúsii̱ ini Ndios xíni ra, káchí naángel. ");
INSERT INTO mim_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tá ndi̱ꞌi ñayóꞌo, ta saá ndiꞌi naángel kua̱noꞌo̱ na ñoyívi ni̱no. Ta na ndáa ndikachi ni̱ka̱ꞌa̱n xíꞌin táꞌan na, káchí na saá: ―Vitin ko̱ꞌo̱n yó ñoo Belén koto yó yu kúu ña yóo xa̱ꞌa̱ ña ni̱ka̱ꞌa̱n ñaángel ña ti̱ꞌví Ndios ki̱xi no̱o̱ yó ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ta saá kama ke̱e na kua̱ꞌa̱n na nandukú na tikuáꞌá loꞌo, ta ni̱xaa̱ na na̱níꞌi na ta̱José xíꞌin ñáMaría xíꞌin tikuáꞌá loꞌo, nákaa̱ ra ini yito̱n no̱o̱ xíxaꞌan kiti̱. ");
INSERT INTO mim_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tá xi̱ni na tikuáꞌá loꞌo, ta nda̱to̱ꞌon na ndiꞌi ña ni̱ka̱ꞌa̱n ñaángel xa̱ꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ta ndiꞌi ni̱vi na xi̱ni̱ so̱ꞌo to̱ꞌon ña nda̱to̱ꞌon na ndáa ndikachi, na̱kaꞌnda ní ini nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tá ñáMaría chi̱kaa̱ va̱ꞌa ñá to̱ꞌon yóꞌo níma̱ ñá, ta na̱kani ní si̱ni̱ ñá xa̱ꞌa̱ ña. ");
INSERT INTO mim_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ta saá ndiꞌi na ndáa ndikachi, kua̱noꞌo̱ na, ta ki̱sa káꞌno na ta ki̱sa to̱ꞌó na Ndios, chi kúsii̱ ní ini na xa̱ꞌa̱ ndiꞌi ña xi̱ni na xíꞌin ndiꞌi ña xi̱ni̱ so̱ꞌo na. Ñii ki̱ꞌva nda̱tán yóo ña ni̱ka̱ꞌa̱n ñaángel xíꞌin na, saá yóo ña. ");
INSERT INTO mim_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tá ni̱to̱nda̱a ki̱vi̱ o̱na̱ ka̱ku tikuáꞌá loꞌo, ta ki̱sa ndivi na costumbre na̱ní circuncisión xíꞌin ra, ña kúu ña xáꞌnda na loꞌo ñii̱ si̱ni̱ ñate̱e ra, ta sa̱kunaní na ra Jesús, chi saá ni̱ka̱ꞌa̱n ñaángel xíꞌin ñáMaría ki̱vi̱ ta̱ꞌán ka̱ ke̱e sa̱ꞌya ñá. ");
INSERT INTO mim_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ta ni̱to̱nda̱a ki̱vi̱ kasa ndivi ta̱José xíꞌin ñáMaría ña káꞌa̱n nda̱yí Ndios ña ni̱taa ta̱Moisés. Nda̱yí yóꞌo káchí ña yukía̱ keꞌé ñaꞌa̱ xa̱ꞌa̱ ña ka̱ku sa̱ꞌya ñá, ta kukomí ñá yichi̱ ki̱ꞌvi tuku ñá veꞌe ño̱ꞌo. Ta saá ta̱José xíꞌin ñáMaría ke̱e na kua̱ꞌa̱n na xíꞌin tikuáꞌá loꞌo Jesús, chi kóni na taxi na ra ndaꞌa̱ Ndios veꞌe ño̱ꞌo káꞌno ñoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Saá chi nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá káchí ña siꞌa: “Ndiꞌi ta̱válí ta̱no̱ó sa̱ꞌya ni̱vi, xíni̱ ñóꞌó taxi na ra ndaꞌa̱ Ndios”, káchí nda̱yí. ");
INSERT INTO mim_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ña̱kán kía̱ kua̱ꞌa̱n na veꞌe ño̱ꞌo káꞌno ña so̱ko̱ na kiti̱ válí no̱o̱ Ndios, chi yóo inka̱ nda̱yí Ndios ña káchí saá: “Ni̱vi nandáꞌví xíni̱ ñóꞌó so̱ko̱ na o̱vi̱ tíndúlú án o̱vi̱ tísa̱ta no̱o̱ Ndios xa̱ꞌa̱ ña ka̱ku sa̱ꞌya na”, káchí nda̱yí Ndios ña ni̱taa ta̱Moisés kui̱ya̱ xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ta ñoo Jerusalén, yóo ñii ta̱a na̱ní ra Simeón, ta̱a ta̱nda̱a̱ kúu ra, ta kísa to̱ꞌó ní ra Ndios, ta yóo Níma̱ Ndios xíꞌin ra. Ta ta̱Simeón yóꞌo ndáti ra ta̱a ta̱ tiꞌví Ndios saka̱ku ni̱vi naIsrael. ");
INSERT INTO mim_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ta Níma̱ Ndios xa ni̱ka̱ꞌa̱n ña xíꞌin ta̱Simeón yóꞌo: ―O̱n kivi̱ ya̱chi̱ ún, siꞌna koni ún Cristo, ta̱a ta̱ tiꞌví Ndios ―káchí Níma̱ Ndios xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ta ni̱xaa̱ ta̱José xíꞌin ñáMaría xíꞌin tikuáꞌá loꞌo Jesús veꞌe ño̱ꞌo káꞌno ña kasa ndivi na ña káꞌa̱n nda̱yí Ndios. Ta mi̱i ki̱vi̱ yóꞌo, Níma̱ Ndios xa ni̱ka̱ꞌa̱n ña xíꞌin ta̱Simeón ña ko̱ꞌo̱n ra veꞌe ño̱ꞌo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ta saá ta̱Simeón na̱kutáꞌan ra xíꞌin na, ta ti̱in ra xi̱nomi ndaa ra tikuáꞌá loꞌo Jesús, ta ki̱xáꞌá ra kísa káꞌno ra Ndios, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Tata, yóꞌó kúu ta̱Káꞌno no̱o̱ ndiꞌi ña yóo. Ta vitin va̱ꞌa taxi ún ña kivi̱ i̱ chi xa yóo va̱ꞌa ini i̱ vitin, chi xa ki̱sa ndivi ún ña ni̱ka̱ꞌa̱n ún xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Xa xi̱ni i̱ tikuáꞌá loꞌo yóꞌo, ta̱a ta̱ ti̱ꞌví ún saka̱ku ni̱vi ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","No̱o̱ ndiꞌi ni̱vi ki̱sa ndivi ún ñava̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nda̱tán yóo ñoꞌo̱ ña yéꞌe saá yóo tikuáꞌá loꞌo yóꞌo, chi sanáꞌa ra yichi̱ ún no̱o̱ ni̱vi na o̱n vása kúu naIsrael. Ta xa̱ꞌa̱ ta̱yóꞌo, kanóo síkón ñato̱ꞌó naIsrael na kúu na ndíko̱n yóꞌó, káchí ta̱Simeón xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ta ta̱José xíꞌin ñáMaría na̱kaꞌnda ini na ndóo na, ña xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱Simeón xa̱ꞌa̱ tikuáꞌá loꞌo Jesús. ");
INSERT INTO mim_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ta saá ta̱Simeón ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―Ndios keꞌé ra ñava̱ꞌa xíꞌin ndó, ná chindeé ka̱ ra ndóꞌó ―káchí ra xíꞌin na. Ta ni̱ka̱ꞌa̱n ka̱ ra xíꞌin ñáMaría, siꞌí tikuáꞌá loꞌo Jesús, káchí ra saá: ―Ndios chi̱tóni̱ ra sa̱ꞌya ún yóꞌo kuu ra ta̱a ta̱ saka̱ku kua̱ꞌa̱ ní naIsrael. Ta saá ni, sava naIsrael o̱n kuaꞌa na nakiꞌin va̱ꞌa na ra, ta nayóꞌo ndiꞌi xa̱ꞌa̱ na. Sa̱ꞌya ún yóꞌo sanáꞌa ra ni̱vi xa̱ꞌa̱ Ndios, ta kua̱ꞌa̱ ní ni̱vi o̱n kandixa na ra. ");
INSERT INTO mim_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ña kéꞌé ni̱vi yóꞌo kúu ña sanáꞌa yukía̱ xáni si̱ni̱ na. Ta saá, nana, to̱nda̱a ñii ki̱vi̱ ta̱ꞌvi̱ níma̱ ún; nda̱tán xa̱ꞌnda ña xíꞌin espada, saá kundoꞌo níma̱ ún, chi kuchuchú ini ún xa̱ꞌa̱ sa̱ꞌya ún ―káchí ta̱Simeón xíꞌin ñáMaría. ");
INSERT INTO mim_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ta ini veꞌe ño̱ꞌo káꞌno yóꞌo yóo ñii ñáprofeta, na̱ní ñá Ana. Ñii sa̱ꞌya ta̱Fanuel kúu ñá, ta xi̱i̱ síkuá ñá xi̱kuu ta̱Aser, ta ñáxi̱kua̱ꞌa̱ ní kúu ñá. Ki̱vi̱ xi̱kuu ñá ñáloꞌo, ni̱tonda̱ꞌa̱ ñá, ta ni̱xi̱yo ñá xíꞌin yii̱ ñá u̱xa̱ kui̱ya̱, ta saá ni̱xiꞌi̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ta ñáAna ki̱ndo̱o kuáa̱n ñá, ta ni̱xi̱no̱ ñá ko̱mi̱ si̱ko̱ ko̱mi̱ kui̱ya̱. Ta ndiví ñoó yóo ñá, kísa káꞌno ñá Ndios, ta nda̱ ñii ki̱vi̱ o̱n vása kéta ñá veꞌe ño̱ꞌo. Yóo ki̱vi̱ o̱n vása xíxi ñá chi yóo soꞌon ñá, káꞌa̱n ñá xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ta ki̱xaa̱ ñáAna no̱o̱ yóo ñáMaría xíꞌin ta̱José xíꞌin tikuáꞌá loꞌo Jesús, ta ni̱ka̱ꞌa̱n ñá xíꞌin Ndios: ―Tata Ndios, táxaꞌvi ún, chi ti̱ꞌví ún tikuáꞌá loꞌo yóꞌo ki̱xaa̱ ra ñoyívi yóꞌo ―káchí ñá. Ta ni̱ka̱ꞌa̱n ñá xa̱ꞌa̱ ta̱Jesús xíꞌin ndiꞌi ni̱vi na kúu na ndáti ndí Ndios saka̱ku ra nañoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ki̱vi̱ ndi̱ꞌi ki̱sa ndivi na ña káꞌa̱n nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá, ta saá ta̱José xíꞌin ñáMaría xíꞌin tikuáꞌá loꞌo Jesús na̱kiꞌin na kua̱noꞌo̱ na ñoo Nazaret estado Galilea. ");
INSERT INTO mim_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ta ñoo yóꞌo xa̱ꞌno ta̱loꞌo Jesús, ta ñii ñii kui̱ya̱ ndu̱u ndeé ka̱ ra. Ta ndu̱u ra ta̱ ndíchí ní si̱ni̱, ta Ndios kúsii̱ ní ini ra xíni ñaꞌá ra. ");
INSERT INTO mim_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ndiꞌi saá kui̱ya̱ ta̱José xíꞌin ñáMaría xáꞌa̱n na viko̱ Pascua ñoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ki̱vi̱ ni̱xi̱no̱ ta̱Jesús u̱xu̱ o̱vi̱ kui̱ya̱, ta ke̱e ra kua̱ꞌa̱n ra xíꞌin na viko̱ yóꞌo, chi saá ni̱xi̱yo costumbre na. ");
INSERT INTO mim_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ta ki̱vi̱ ndi̱ꞌi viko̱, ta na̱kiꞌin na kua̱noꞌo̱ na, ta ni̱ndo̱o ta̱Jesús ñoo Jerusalén, ta o̱n vása ní‑xini̱ ta̱José ni ñáMaría ña ni̱ndo̱o ra. ");
INSERT INTO mim_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Xáni ini na án va̱xi ta̱Jesús xíꞌin inka̱ naveꞌe na án va̱xi ra xíꞌin inka̱ natáꞌan na, káꞌán na. Saá kúu, ta xa ni̱yaꞌa ñii ki̱vi̱ xíka na kua̱ꞌa̱n na yichi̱, ta saá ki̱xáꞌá na nándukú na ra xíꞌin ñii ñii naveꞌe na, xíꞌin ñii ñii natáꞌan na. ");
INSERT INTO mim_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ta o̱n ko̱ó ra, ni̱‑naníꞌi na. Ta saá ñáMaría xíꞌin ta̱José ndi̱kó na kua̱ꞌa̱n na ñoo Jerusalén nandukú na ra. ");
INSERT INTO mim_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ta̱nda̱ ki̱vi̱ u̱ni̱ na̱níꞌi na ta̱Jesús veꞌe ño̱ꞌo káꞌno, yóo ra ma̱ꞌñó namaestro na sánáꞌa nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá. Xíni̱ so̱ꞌo ta̱loꞌo Jesús ña káꞌa̱n namaestro yóꞌo, ta ndáka̱ to̱ꞌon ra na. ");
INSERT INTO mim_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ta ndiꞌi nayóꞌo na̱kaꞌnda ini na xíni̱ so̱ꞌo na ña káꞌa̱n ta̱Jesús chi va̱ꞌa ní si̱ni̱ ra, ta ndíchí ní to̱ꞌon nda̱kuii̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ta ki̱xaa̱ ta̱José xíꞌin ñáMaría, xi̱ni na ta̱loꞌo Jesús, ta na̱kaꞌnda ini na xíto na, ta ni̱ka̱ꞌa̱n siꞌí ra xíꞌin ra: ―Ta̱loꞌo, ¿nda̱chun ke̱ꞌé ún saá xíꞌin ndi̱? Yivá ún xíꞌin yi̱ꞌi̱, na̱ndukú ndi̱ yóꞌó, ta ndíꞌi ní ini ndi̱ xa̱ꞌa̱ ún. ");
INSERT INTO mim_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ta saá nda̱kuii̱n ta̱Jesús: ―¿Nda̱chun na̱ndukú ndó yi̱ꞌi̱? ¿Án o̱n vása xíni̱ ndó ndí chiño Yivá i̱ xíni̱ ñóꞌó kasa ndivi i̱? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ta o̱n vása ní‑kunda̱a̱ ini na yukía̱ kóni kachí to̱ꞌon ña ni̱ka̱ꞌa̱n ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ta saá ke̱e ta̱Jesús ñoo Jerusalén xíꞌin ta̱José xíꞌin ñáMaría, ta kua̱noꞌo̱ na ñoo Nazaret. Ta na̱xaa̱ na kán, ta ndiꞌi saá ki̱vi̱ chi̱kaa̱ so̱ꞌo ra ta ki̱sa ndivi ra ndiꞌi ña káꞌa̱n yivá ra xíꞌin siꞌí ra. Ta siꞌí ra, níma̱ mi̱i ñá chi̱kaa̱ va̱ꞌa ñá ndiꞌi ña ndóꞌo ñá xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ta xa̱ꞌno ta̱Jesús, ta ndu̱u káꞌno ka̱ ra, ta ku̱u ndíchí ka̱ si̱ni̱ ra. Ta Ndios xíꞌin ni̱vi kúsii̱ ní ini na xíni na ra. ");
INSERT INTO mim_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kui̱ya̱ xa̱ꞌo̱n xáꞌnda chiño ta̱rey Tiberio no̱o̱ ndiꞌi ñoo ña ndáꞌvi ndaa ñoo Roma, ta̱gobernador Poncio Pilato xáꞌnda chiño ra no̱o̱ nañoo estado Judea, ta̱rey Herodes xáꞌnda chiño ra no̱o̱ nañoo estado Galilea, ta̱rey Felipe, ta kúu ñani ta̱Herodes yóꞌo, xáꞌnda chiño ra no̱o̱ nañoo estado Iturea xíꞌin Traconite, ta ta̱rey Lisanias xáꞌnda chiño ra no̱o̱ nañoo Abilinia. ");
INSERT INTO mim_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ta ta̱su̱tu̱ Anás xíꞌin ta̱su̱tu̱ Caifás kúu ta̱náꞌno no̱o̱ ndiꞌi nasu̱tu̱ ñoo Israel. Ta mi̱i kui̱ya̱ yóꞌo Ndios ni̱ka̱ꞌa̱n ra xíꞌin ta̱Juan, ta̱ yóo yuku̱ yi̱chí, ta̱ kúu sa̱ꞌya ta̱Zacarías. ");
INSERT INTO mim_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ta ke̱e ta̱Juan kua̱ꞌa̱n ra ndiꞌi saá xiiña yatin yu̱ta Jordán. Ta ni̱ka̱ꞌa̱n ndoso ra to̱ꞌon Ndios xíꞌin ni̱vi, káchí ra saá: ―O̱n vása keꞌé ka̱ ndó ña o̱n váꞌa, ta nandikó ini ndó xa̱ꞌa̱ ña o̱n váꞌa ke̱ꞌé ndó ña kasa káꞌno ini Ndios xa̱ꞌa̱ kua̱chi ndó, ta saá naꞌa ndó kuchu ndó ―káchí ra, káꞌa̱n ra xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ta xa̱ꞌa̱ ta̱Juan yóꞌo ni̱taa ta̱profeta Isaías xi̱na̱ꞌá, ka̱chí ra saá: No̱o̱ yóo yuku̱ yi̱chí ka̱ꞌa̱n ndoso ra, kachí ra saá: “Ná koo tiꞌva ini ndó, saá chi ya̱chi̱ kixaa̱ mi̱i ta̱Káꞌno no̱o̱ yó. Kindaa ndó ña o̱n váꞌa sási no̱o̱ ndó, ta saá va̱ꞌa kuchiño nakiꞌin ndó ra”, kachí ta̱a ta̱ koo yuku̱ yi̱chí. ");
INSERT INTO mim_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“Saá chi va̱xi ki̱vi̱ tá ndiꞌi no̱o̱ kónó nduu ndaa ña, ta ndiꞌi yuku̱ nduu ña yoso̱. Ndiꞌi yichi̱ ya̱kua nduu nda̱kú ña, ta ndiꞌi yichi̱ yu̱u̱ ní, ndundii ña, ta nduva̱ꞌa ña. ");
INSERT INTO mim_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ta ndiꞌi ni̱vi ñoyívi yóꞌo koni na yu kúu ta̱ tiꞌví Ndios ña saka̱ku ra na”, káchí to̱ꞌon Ndios ña ni̱taa ta̱Isaías xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ta kua̱ꞌa̱ ní ni̱vi ni̱xaa̱ na no̱o̱ yóo ta̱Juan, chi kóni na sakuchu ra na, ta ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―¡Ndóꞌó, sa̱ꞌya ko̱o̱ xati̱ kúu ndó! ¿Yu kúu na ni̱ka̱ꞌa̱n xíꞌin ndó kuchu ndó, ta saá saka̱ku xíꞌin mi̱i ndó ña o̱n saxo̱ꞌvi̱ Ndios ndóꞌó ki̱vi̱ ña va̱xi? ");
INSERT INTO mim_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tá ndixa na̱ndikó ini ndó ta kóni ndó ko̱ꞌo̱n ndó yichi̱ Ndios, ta xíni̱ ñóꞌó kasa ndivi ndó chiño va̱ꞌa nda̱tán kóni Ndios. Saá chi o̱n váꞌa kani si̱ni̱ ndó ndí xa̱ꞌa̱ ña kúu ndó sa̱ꞌya ñani síkuá ta̱Abraham, Ndios saka̱ku ra ndóꞌó. Ta káꞌa̱n i̱ xíꞌin ndó, Ndios kúchiño ra ndasa ra yu̱u̱ yóꞌo ni̱vi na nduu sa̱ꞌya ñani síkuá ta̱Abraham. ");
INSERT INTO mim_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ta ni̱vi na o̱n vása kísa ndivi ña kóni Ndios, nda̱tán yóo yito̱n tón kóon kui̱ꞌi o̱n váꞌa ndaꞌa̱, saá yóo na no̱o̱ Ndios. Ta Ndios xa yóo tiꞌva ra xíꞌin yáchá si̱i̱n ña kaꞌnda ra ndiꞌi yito̱n tón o̱n vása kóon kui̱ꞌi va̱ꞌa ndaꞌa̱, ta kaꞌnda ra nó, ta taan ra nó ko̱ko̱ nó no̱o̱ xíxi̱ ñoꞌo̱ ―káchí ta̱Juan, káꞌa̱n ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ta saá ni̱nda̱ka̱ to̱ꞌon na ta̱Juan: ―¿Yukía̱ va̱ꞌa xíni̱ ñóꞌó keꞌé ndi̱ ña o̱n xo̱ꞌvi̱ ndi̱ saá? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ta nda̱kuii̱n ta̱Juan, ni̱ka̱ꞌa̱n ra: ―Tá yóo ñii ta̱a, ta kómí ra o̱vi̱ tiko̱to̱, ta xíni̱ ñóꞌó taxi ra ñii tiko̱to̱ ndaꞌa̱ ta̱a ta̱ o̱n ko̱ó nda̱ ñii tiko̱to̱ kómí. Tá yóo ña xíxi ñii ta̱a, ta xíni̱ ñóꞌó taxi ra ña kuxu ta̱a ta̱ o̱n ko̱ó ñaxíxi ―káchí ta̱Juan xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ta sava ni̱vi na káya si̱ꞌún no̱o̱ nagobierno ñoo Roma ki̱xaa̱ na no̱o̱ ta̱Juan chi kóni na sakuchu ra na, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Maestro, ¿yukía̱ va̱ꞌa xíni̱ ñóꞌó kasa ndivi ndi̱? ");
INSERT INTO mim_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ta nda̱kuii̱n ra: ―O̱n sandáꞌví ndó ni̱vi, ta kuiti nakiꞌin ndó si̱ꞌún ña káchí nagobierno xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ta sava natropa ki̱xaa̱ na ni̱nda̱ka̱ to̱ꞌon na ra: ―Ta mi̱i ndi̱, ¿yukía̱ va̱ꞌa xíni̱ ñóꞌó kasa ndivi ndi̱? Ta nda̱kuii̱n ta̱Juan, ni̱ka̱ꞌa̱n ra xíꞌin na: ―O̱n kasa kuíꞌná ndó si̱ꞌún inka̱ ni̱vi, ta o̱n ka̱ꞌa̱n ndó ñavatá xa̱ꞌa̱ na. O̱n ka̱ꞌa̱n kuáchí ndó xa̱ꞌa̱ yaꞌvi ndó, ta kusii̱ ní ini ndó xíꞌin ña cháꞌvi na ndóꞌó xa̱ꞌa̱ chiño kéꞌé ndó ―káchí ta̱Juan xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ta kua̱ꞌa̱ ní ni̱vi ndáti na ña kixaa̱ Cristo, ta̱a ta̱ tiꞌví Ndios ña saka̱ku ra na, ta xáni ini na saá: “¿Án o̱n si̱ví mi̱i ta̱Juan kúu ra?” ");
INSERT INTO mim_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ta ta̱Juan ni̱ka̱ꞌa̱n ra xíꞌin na: ―Yi̱ꞌi̱ sákuchu i̱ ndóꞌó xíꞌin takuií, ta sa̱ta̱ yi̱ꞌi̱ va̱xi ñii ta̱a ta̱ ndeé ka̱ no̱o̱ yi̱ꞌi̱. Ta yi̱ꞌi̱ kúu ta̱ kísa chiño kuiti no̱o̱ ra. Ta ta̱ ndeé ka̱ no̱o̱ i̱ va̱xi sa̱ta̱ i̱, ta sakuchu ra ndóꞌó xíꞌin mi̱i Níma̱ Ndios, ña yóo nda̱tán yóo ñoꞌo̱ xíxi̱. ");
INSERT INTO mim_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Xa yóo tiꞌva ra kasa nani ra xa̱ꞌa̱ kua̱chi ni̱vi, ta keꞌé ra xíꞌin ni̱vi nda̱tán kéꞌé ni̱vi xíꞌin ndiki̱n trigo ña xa̱ꞌnda na ta sa̱xixin na ña. Saá chi ta̱yóꞌo nataꞌví ra ni̱vi na va̱ꞌa no̱o̱ na o̱n váꞌa. Ta taxi va̱ꞌa ra ni̱vi na va̱ꞌa ña kundo̱o na veꞌe ra, ta taan ra ni̱vi na o̱n váꞌa no̱o̱ xíxi̱ ñoꞌo̱, ta nda̱ ñii ki̱vi̱ o̱n nda̱ꞌva̱ ñoꞌo̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ta xíꞌin kua̱ꞌa̱ ní to̱ꞌon ndíchí, nda̱to̱ꞌon ta̱Juan xíꞌin ni̱vi ña nandikó ini na, ta saá tuku ni̱ka̱ꞌa̱n ndoso ra to̱ꞌon va̱ꞌa xa̱ꞌa̱ Ndios xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ta xa̱ꞌa̱ ta̱rey Herodes, ni̱ka̱ꞌa̱n ta̱Juan, káchí ra saá: “O̱n váꞌa ke̱ꞌé ta̱rey Herodes, chi to̱nda̱ꞌa̱ ra xíꞌin ñásíꞌí ñani mi̱i ra ta̱Felipe”, káchí ra, ni̱ka̱ꞌa̱n ra no̱o̱ ni̱vi. Ta ta̱Juan ni̱ka̱ꞌa̱n ka̱ ra xa̱ꞌa̱ kua̱ꞌa̱ ní inka̱ ña o̱n váꞌa ke̱ꞌé ta̱Herodes yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ta xíꞌin ndiꞌi ña o̱n váꞌa yóꞌo, ta̱Herodes ke̱ꞌé ka̱ ra inka̱ ña o̱n váꞌa ní ka̱ ña chi̱kaa̱ ra ta̱Juan ini veꞌe ka̱a. ");
INSERT INTO mim_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ta ki̱vi̱ ta̱ꞌán kunakaa̱ ta̱Juan ini veꞌe ka̱a, ta sa̱kuchu ra kua̱ꞌa̱ ní ni̱vi. Ta saá sa̱kuchu ra ta̱Jesús. Tá káꞌa̱n ka̱ ta̱Jesús xíꞌin Ndios, ta ni̱xo̱na̱ ñoyívi ni̱no no̱o̱ ra, ");
INSERT INTO mim_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ta va̱xi noo Níma̱ Ndios. Nda̱tán náꞌa tísa̱ta va̱xi noo rí, saá ki̱xi noo ña, ta xi̱kanóo ña no̱o̱ ñíndichi ta̱Jesús. Ta ni̱vi na ndóo yuꞌu̱ yu̱ta xi̱ni̱ so̱ꞌo na to̱ꞌon Ndios ni̱ka̱ꞌa̱n ra nda̱ ñoyívi ni̱no, káchí ra siꞌa: ―Yóꞌó kúu Sa̱ꞌya i̱, ta̱ kíꞌvi ní ini i̱ xíni i̱, ta kúsii̱ ní ini i̱ xíni i̱ yóꞌó ―káchí Ndios. ");
INSERT INTO mim_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tá ni̱xi̱no̱ ta̱Jesús o̱ko̱ u̱xu̱ kui̱ya̱, ta ki̱xáꞌá ra sánáꞌa ra ni̱vi. Xáni ini ni̱vi ndí sa̱ꞌya ta̱José kúu ra. Ta ta̱José kúu sa̱ꞌya ta̱Elí. ");
INSERT INTO mim_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ta ta̱Elí kúu sa̱ꞌya ta̱Matat, ta ta̱Matat kúu sa̱ꞌya ta̱Leví, ta ta̱Leví kúu sa̱ꞌya ta̱Melqui, ta ta̱Melqui kúu sa̱ꞌya ta̱Jana, ta̱Jana kúu sa̱ꞌya ta̱José. ");
INSERT INTO mim_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ta̱José kúu sa̱ꞌya ta̱Matatías, ta̱Matatías kúu sa̱ꞌya ta̱Amós, ta̱Amós kúu sa̱ꞌya ta̱Nahum, ta̱Nahum kúu sa̱ꞌya ta̱Esli, ta̱Esli kúu sa̱ꞌya ta̱Nagai. ");
INSERT INTO mim_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ta̱Nagai kúu sa̱ꞌya ta̱Maat, ta̱Maat kúu sa̱ꞌya ta̱Matatías, ta̱Matatías kúu sa̱ꞌya ta̱Semei, ta̱Semei kúu sa̱ꞌya ta̱José, ta̱José kúu sa̱ꞌya ta̱Judá. ");
INSERT INTO mim_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ta̱Judá kúu sa̱ꞌya ta̱Joana, ta̱Joana kúu sa̱ꞌya ta̱Resa, ta̱Resa kúu sa̱ꞌya ta̱Zorobabel, ta̱Zorobabel kúu sa̱ꞌya ta̱Salatiel, ta̱Salatiel kúu sa̱ꞌya ta̱Neri. ");
INSERT INTO mim_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ta̱Neri kúu sa̱ꞌya ta̱Melqui, ta̱Melqui kúu sa̱ꞌya ta̱Adi, ta̱Adi kúu sa̱ꞌya ta̱Cosam, ta̱Cosam kúu sa̱ꞌya ta̱Elmodam, ta̱Elmodam kúu sa̱ꞌya ta̱Er. ");
INSERT INTO mim_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ta̱Er kúu sa̱ꞌya ta̱Josué, ta̱Josué kúu sa̱ꞌya ta̱Eliezer, ta̱Eliezer kúu sa̱ꞌya ta̱Jorim, ta̱Jorim kúu sa̱ꞌya ta̱Matat, ta̱Matat kúu sa̱ꞌya ta̱Leví. ");
INSERT INTO mim_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ta̱Leví kúu sa̱ꞌya ta̱Simeón, ta̱Simeón kúu sa̱ꞌya ta̱Judá, ta̱Judá kúu sa̱ꞌya ta̱José, ta̱José kúu sa̱ꞌya ta̱Jonán, ta̱Jonán kúu sa̱ꞌya ta̱Eliaquim. ");
INSERT INTO mim_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ta̱Eliaquim kúu sa̱ꞌya ta̱Melea, ta̱Melea kúu sa̱ꞌya ta̱Mainán, ta̱Mainán kúu sa̱ꞌya ta̱Matata, ta̱Matata kúu sa̱ꞌya ta̱Natán. ");
INSERT INTO mim_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ta̱Natán kúu sa̱ꞌya ta̱David, ta̱David kúu sa̱ꞌya ta̱Isaí, ta̱Isaí kúu sa̱ꞌya ta̱Obed, ta̱Obed kúu sa̱ꞌya ta̱Booz, ta̱Booz kúu sa̱ꞌya ta̱Salmón, ta̱Salmón kúu sa̱ꞌya ta̱Naasón. ");
INSERT INTO mim_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ta̱Naasón kúu sa̱ꞌya ta̱Aminadab, ta̱Aminadab kúu sa̱ꞌya ta̱Aram, ta̱Aram kúu sa̱ꞌya ta̱Esrom, ta̱Esrom kúu sa̱ꞌya ta̱Fares, ta̱Fares kúu sa̱ꞌya ta̱Judá. ");
INSERT INTO mim_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ta̱Judá kúu sa̱ꞌya ta̱Jacob, ta̱Jacob kúu sa̱ꞌya ta̱Isaac, ta̱Isaac kúu sa̱ꞌya ta̱Abraham, ta̱Abraham kúu sa̱ꞌya ta̱Taré, ta̱Taré kúu sa̱ꞌya ta̱Nacor. ");
INSERT INTO mim_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ta̱Nacor kúu sa̱ꞌya ta̱Serug, ta̱Serug kúu sa̱ꞌya ta̱Ragau, ta̱Ragau kúu sa̱ꞌya ta̱Peleg, ta̱Peleg kúu sa̱ꞌya ta̱Heber, ta̱Heber kúu sa̱ꞌya ta̱Sala. ");
INSERT INTO mim_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ta̱Sala kúu sa̱ꞌya ta̱Cainán, ta̱Cainán kúu sa̱ꞌya ta̱Arfaxad, ta̱Arfaxad kúu sa̱ꞌya ta̱Sem, ta̱Sem kúu sa̱ꞌya ta̱Noé, ta̱Noé kúu sa̱ꞌya ta̱Lamec. ");
INSERT INTO mim_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ta̱Lamec kúu sa̱ꞌya ta̱Matusalén, ta̱Matusalén kúu sa̱ꞌya ta̱Enoc, ta̱Enoc kúu sa̱ꞌya ta̱Jared, ta̱Jared kúu sa̱ꞌya ta̱Mahalaleel, ta̱Mahalaleel kúu sa̱ꞌya ta̱Cainán. ");
INSERT INTO mim_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ta̱Cainán kúu sa̱ꞌya ta̱Enós, ta̱Enós kúu sa̱ꞌya ta̱Set, ta̱Set kúu sa̱ꞌya ta̱Adán, ta̱Adán kúu sa̱ꞌya Ndios. ");
INSERT INTO mim_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ta níma̱ ta̱Jesús chútú ní ña xíꞌin ndee̱ Níma̱ Ndios, ta ke̱e ra yu̱ta Jordán, ta Níma̱ Ndios ni̱ka̱ꞌa̱n ña xíꞌin ra ko̱ꞌo̱n ra no̱o̱ yóo yuku̱ yi̱chí. ");
INSERT INTO mim_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ta o̱vi̱ si̱ko̱ ki̱vi̱ yóo ta̱Jesús yuku̱ yi̱chí, ta ñaníma̱ ndiva̱ꞌa káꞌno xíto ndoso ña ra, chi kóni ña sandáꞌví ña ra. Ta nda̱ loꞌo o̱n vása ní‑xixi ta̱Jesús, chi ni̱xi̱yo soꞌon ra o̱vi̱ si̱ko̱ ki̱vi̱, ta saá xíꞌi̱ ní ra so̱ko. ");
INSERT INTO mim_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ta ki̱xaa̱ ñaníma̱ ndiva̱ꞌa káꞌno no̱o̱ ra ña koto ndoso ña ra, ta ni̱ka̱ꞌa̱n ña xíꞌin ra, káchí ña saá: ―Tá ndixa Sa̱ꞌya Ndios kúu ún, ta va̱ꞌa kaꞌnda chiño ún no̱o̱ yu̱u̱ ña ndóo yóꞌo ná nduu ña si̱ta̱ va̱ꞌa ―káchí ña xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin ñaníma̱ ndiva̱ꞌa: ―To̱ꞌon Ndios káchí ña saá: “O̱n si̱ví nina ña xíxi ni̱vi kúu ña xíni̱ ñóꞌó kutaku̱ na. Ta xíni̱ ñóꞌó kandixa va̱ꞌa na to̱ꞌon Ndios, ta saá kutaku̱ na”, káchí to̱ꞌon Ndios ―káchí ta̱Jesús xíꞌin ñaníma̱ ndiva̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ta saá ñaníma̱ ndiva̱ꞌa káꞌno ni̱ka̱ꞌa̱n ña xíꞌin ta̱Jesús ko̱ꞌo̱n ra xíꞌin ña, ta nda̱a na ñii yuku̱ síkón ní, ta ñandiva̱ꞌa sa̱náꞌa ña ra ndiꞌi ñoo ña yóo ñoyívi yóꞌo, ");
INSERT INTO mim_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ta ni̱ka̱ꞌa̱n ñaníma̱ ndiva̱ꞌa xíꞌin ta̱Jesús, káchí ña saá: ―Taxi i̱ nda̱yí ndaꞌa̱ ún kuu ún ta̱káꞌno no̱o̱ ndiꞌi ñoyívi yóꞌo, ta taxi i̱ ndiꞌi ñakuíká xíꞌin ndiꞌi ñava̱ꞌa ndaꞌa̱ ún. Saá chi ña̱ꞌa mi̱i i̱ kúu ndiꞌi ña, ta yóo yichi̱ i̱ taxi i̱ ña ndaꞌa̱ ni̱vi na káchí ini mi̱i i̱ xíni i̱. ");
INSERT INTO mim_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tá kuxítí ún no̱o̱ i̱, ta kasa to̱ꞌó ún yi̱ꞌi̱, ta taxi i̱ ndiꞌi ña kómí i̱ ndaꞌa̱ ún ―káchí ñaníma̱ ndiva̱ꞌa xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ta ta̱Jesús nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra xíꞌin ña: ―¡Kutaꞌa ún no̱o̱ i̱, yóꞌó, ñaníma̱ ndiva̱ꞌa káꞌno Satanás! Chi káchí to̱ꞌon Ndios saá: “Ndasaá kuiti Ndios kasa to̱ꞌó yó, ta kasa ndivi yó chiño ra, ta o̱n kasa to̱ꞌó yó, ni o̱n kasa ndivi yó chiño inka̱ na”, káchí to̱ꞌon Ndios ―saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ñaníma̱ ndiva̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ta saá ñaníma̱ ndiva̱ꞌa káꞌno ni̱ka̱ꞌa̱n ña xíꞌin ta̱Jesús ko̱ꞌo̱n ra xíꞌin ña, ta ni̱xaa̱ na yíta na si̱ni̱ torre veꞌe ño̱ꞌo káꞌno ñoo Jerusalén, ta ni̱ka̱ꞌa̱n ñaníma̱ ndiva̱ꞌa xíꞌin ra: ―Tá ndixa Sa̱ꞌya Ndios kúu ún, ta sakana xíꞌin mi̱i ún nda̱ ni̱no̱, ");
INSERT INTO mim_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","chi saá káchí to̱ꞌon Ndios: Ndios tiꞌví ra ángel ña chindeé na yóꞌó ta kundaa va̱ꞌa na yóꞌó. ");
INSERT INTO mim_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ta naángel natiin na yóꞌó kanóo ún no̱o̱ ndaꞌa̱ na, ko̱to̱ nakava ún no̱o̱ yu̱u̱, ta takuéꞌe̱ ún, káchí to̱ꞌon Ndios ―káchí ñaníma̱ ndiva̱ꞌa xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ta nda̱kuii̱n ta̱Jesús: ―Saá tuku káchí to̱ꞌon Ndios: “O̱n váꞌa koto ndoso yó Ndios” ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ta ndi̱ꞌi xi̱to ndoso ñaníma̱ ndiva̱ꞌa ta̱Jesús, ta ke̱e ña kua̱ꞌa̱n ña, ta ndáti ña inka̱ ki̱vi̱ ña ndikó ña koto ndoso ña ra. ");
INSERT INTO mim_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ta saá ndi̱kó ta̱Jesús kua̱ꞌa̱n ra, ta na̱xaa̱ ra estado Galilea, ta ndee̱ Níma̱ Ndios yóo ña xíꞌin ra. Ta ni̱xi̱ta̱ níꞌnó to̱ꞌon xa̱ꞌa̱ ra ñii ñii ñoo. ");
INSERT INTO mim_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ta ta̱Jesús sánáꞌa ra ni̱vi na nákutáꞌan kua̱ꞌa̱ ní veꞌe ño̱ꞌo sinagoga ña yóo estado Galilea yóꞌo. Ta ndiꞌi ni̱vi na xíni̱ so̱ꞌo ña káꞌa̱n ra, va̱ꞌa ní káꞌa̱n na xa̱ꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ta ta̱Jesús na̱xaa̱ ra ñoo Nazaret no̱o̱ xa̱ꞌno ra. Ta ndiꞌi saá ki̱vi̱ yi̱i̱ ña nákindée najudío xáꞌa̱n ra veꞌe ño̱ꞌo sinagoga. Ta saá ñii ki̱vi̱ yi̱i̱, na̱kundichi ra ña kaꞌvi ra to̱ꞌon Ndios no̱o̱ inka̱ ni̱vi na na̱kutáꞌan veꞌe ño̱ꞌo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ta ta̱xi na ndaꞌa̱ ra to̱ꞌon Ndios ña ni̱taa ta̱profeta Isaías xi̱na̱ꞌá. Ta ta̱Jesús na̱ndika ra ña, ta na̱níꞌi ra no̱o̱ káꞌa̱n ña saá: ");
INSERT INTO mim_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Níma̱ Ndios yóo ña xíꞌin i̱, ta na̱ka̱xin ña yi̱ꞌi̱ va̱xi i̱ ña ndato̱ꞌon i̱ to̱ꞌon va̱ꞌa xíꞌin nandáꞌví. Ti̱ꞌví ña yi̱ꞌi̱ ña sandúva̱ꞌa i̱ ni̱vi na táꞌvi̱ níma̱. Ta ti̱ꞌví ña yi̱ꞌi̱ va̱xi i̱ saña i̱ na nóꞌni ndaa xíꞌin kua̱chi na. Ti̱ꞌví ña yi̱ꞌi̱ sandaꞌa i̱ nduchu̱ no̱o̱ nakuáá, ña va̱ꞌa koto na, ta saka̱ku i̱ ni̱vi na xóꞌvi̱ no̱o̱ ña sáxo̱ꞌvi̱ ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ta ti̱ꞌví ña yi̱ꞌi̱ va̱xi i̱ ka̱ꞌa̱n ndoso i̱ xíꞌin ni̱vi ndí vitin ni̱to̱nda̱a ki̱vi̱ Ndios chindeé ra na, káchí to̱ꞌon Ndios ña ni̱taa ta̱Isaías ña ka̱ꞌvi ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ta saá na̱kasi ta̱Jesús tutu yóꞌo, ta na̱taxi ra ndaꞌa̱ ta̱a ta̱ xíka chiño no̱o̱ veꞌe ño̱ꞌo sinagoga, ta xi̱koo ra, ta ndiꞌi ni̱vi ndáti na, xíto na no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ta ki̱xáꞌá ta̱Jesús káꞌa̱n ra xíꞌin na, káchí ra saá: ―Mi̱i ki̱vi̱ vitin, Ndios xa ki̱sa ndivi ra to̱ꞌon ra ña xi̱ni̱ so̱ꞌo ndó ka̱ꞌvi i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ta ndiꞌi ni̱vi va̱ꞌa ní káꞌa̱n na xa̱ꞌa̱ ra. Ta na̱kaꞌnda ini na ndóo na, chi va̱ꞌa ní káꞌa̱n ra. Ta ni̱nda̱ka̱ to̱ꞌon táꞌan na: ―¿Án o̱n si̱ví sa̱ꞌya ta̱José kúu ta̱yóꞌo? ¡Nda̱chun va̱ꞌa ní xíni̱ ra! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Kúnda̱a̱ ini i̱ ndí kóni ndó ka̱ꞌa̱n ndó xíꞌin i̱: “Ndotor, kasa ta̱ta̱n xíꞌin mi̱i ún.” Saá chi xi̱ni̱ so̱ꞌo ndó xa̱ꞌa̱ ñava̱ꞌa ke̱ꞌé i̱ ñoo Capernaum, ta vitin kóni ndó ña ñii ki̱ꞌva saá keꞌé i̱ ñava̱ꞌa ñoo i̱ yóꞌo ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ta saá ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na, káchí ra saá: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, nda̱ ñii ta̱profeta, o̱n vása nákiꞌin va̱ꞌa na ra ñoo mi̱i ra. ");
INSERT INTO mim_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nakáꞌán ndó to̱ꞌon Ndios xa̱ꞌa̱ ta̱profeta Elías, ta̱a ta̱ ni̱ka̱ꞌa̱n ndoso to̱ꞌon Ndios xi̱na̱ꞌá. Ki̱vi̱ ni̱xika ta̱Elías ñoyívi yóꞌo, ta Ndios ke̱ꞌé ra ña o̱n vása ní‑koon sa̱vi̱ u̱ni̱ kui̱ya̱ sava, ta ndiꞌi ni̱vi ndeé ní ni̱xiꞌi̱ na so̱ko. ");
INSERT INTO mim_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tá mií saá ñoo Israel ni̱xi̱yo kua̱ꞌa̱ ní náñaꞌa̱ nándáꞌví, ná ni̱xiꞌi̱ yii̱. Ta saá ni, Ndios o̱n vása ní‑tiꞌví ra ta̱Elías ko̱ꞌo̱n ra nda̱ ñii veꞌe náñaꞌa̱ yóꞌo ná táku̱ ñoo Israel ña nataxi ná ñaxíxi ndaꞌa̱ ra. Ta ñii ñoo xíká na̱ní Sarepta, ña nákaa̱ no̱o̱ ñoꞌo̱ na̱ní Sidón, kúu ñoo no̱o̱ ti̱ꞌví Ndios ta̱Elías kua̱ꞌa̱n ra koo ra veꞌe ñii ñaꞌa̱ ndáꞌví ñá ni̱xiꞌi̱ yii̱. ");
INSERT INTO mim_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ta inka̱ kui̱ya̱ xi̱na̱ꞌá ta̱profeta Eliseo ni̱ka̱ꞌa̱n ndoso ra to̱ꞌon Ndios xíꞌin ni̱vi, ta ni̱xi̱yo kua̱ꞌa̱ ní naIsrael na xi̱ndeé ní ndóꞌo kue̱ꞌe̱ táꞌyí na̱ní ña lepra. Ta Ndios o̱n vása ní‑sandaꞌa ra nda̱ ñii ni̱vi nañoo Israel na xi̱komí kue̱ꞌe̱ lepra, ta Ndios sa̱ndaꞌa ra ñii la̱á ta̱Naamán, ta̱a ta̱ñoo Siria xi̱kuu ra. Ta̱yóꞌo o̱n si̱ví ta̱Israel xi̱kuu ra, ta ta̱yóꞌo kúu ta̱a ta̱ sa̱ndaꞌa Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tá ni̱vi na ndóo veꞌe ño̱ꞌo sinagoga ñoo Nazaret xíni̱ so̱ꞌo na to̱ꞌon ña ni̱ka̱ꞌa̱n ta̱Jesús, ta ni̱saa̱ ní na xi̱ni na ra. ");
INSERT INTO mim_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Saá na̱kuita na, ta ti̱in na ra, ta ta̱va na ra no̱o̱ ñoo, ta kua̱ꞌa̱n na xíꞌin ra ñii xi̱ki̱ síkón. Saá chi kóni na sakana na ra nda̱ ni̱no̱ no̱o̱ kónó. ");
INSERT INTO mim_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ta o̱n vása ní‑kuchiño na sakana na ra, chi ta̱Jesús ni̱yaꞌa ra ma̱ꞌñó na, ta na̱kiꞌin ra kua̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ta ni̱xaa̱ ta̱Jesús ñoo Capernaum estado Galilea, ta ki̱ndo̱o ra yóꞌo. Ta ndiꞌi saá ki̱vi̱ yi̱i̱ ña nákindée najudío, kíꞌvi ra veꞌe ño̱ꞌo sinagoga, ta sánáꞌa ra ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ta na̱kaꞌnda ini ni̱vi xíni̱ so̱ꞌo na ña káꞌa̱n ra, chi sánáꞌa ra na nda̱tán sánáꞌa ñii ta̱a ta̱ kómí nda̱yí. ");
INSERT INTO mim_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ta veꞌe ño̱ꞌo sinagoga yóꞌo yóo ñii ta̱a ta̱ kómí níma̱ ndiva̱ꞌa, ta ñii ndeé ní ni̱ka̱ꞌa̱n ñandiva̱ꞌa, káchí ña saá: ");
INSERT INTO mim_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Yóꞌó kúu ta̱Jesús ta̱ñoo Nazaret, ta, ¿nda̱chun sándiꞌi ún ndi̱ꞌi̱? ¿Án xa ki̱xaa̱ ún sandiꞌi ún xa̱ꞌa̱ ndi̱ vitin? Xíni̱ va̱ꞌa i̱ yu kúu ún, yóꞌó kúu Ta̱a ta̱Yi̱i̱ ta̱ ki̱xi no̱o̱ Ndios ―káchí ña xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ñandiva̱ꞌa, káchí ra saá: ―¡Kasi yuꞌu̱ ún ta saña ún ta̱yóꞌo! Ta níma̱ ndiva̱ꞌa sa̱nakava ña ta̱ ndeé ndóꞌo nda̱ no̱o̱ ñoꞌo̱, no̱o̱ ndiꞌi ni̱vi. Ta saá sa̱ña ña ra, ta nda̱ loꞌo o̱n vása ní‑satakuéꞌe̱ ña ra. ");
INSERT INTO mim_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ta ndiꞌi ni̱vi na ndóo, na̱kaꞌnda ini na xi̱ni na ñayóꞌo, ta ni̱nda̱ka̱ to̱ꞌon xíꞌin táꞌan mi̱i na: ―¿Yukía̱ yóꞌo? ¡Saá chi kómí ra ndee̱ xíꞌin nda̱yí, ta xáꞌnda chiño ra no̱o̱ níma̱ ndiva̱ꞌa, ta kísa ndivi ña ña káꞌa̱n ra! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ta kama ní ni̱xi̱ta̱ níꞌnó to̱ꞌon xa̱ꞌa̱ ta̱Jesús ndiꞌi ñoo ña ñóꞌo yatin. ");
INSERT INTO mim_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ta ke̱e ta̱Jesús veꞌe ño̱ꞌo sinagoga yóꞌo, ta na̱kiꞌin ra kua̱ꞌa̱n ra veꞌe ta̱Simón ta ni̱xaa̱ ra veꞌe ta̱yóꞌo. Ta ñaꞌa̱ ñási̱so ta̱Simón ndeé ní ndóꞌo ñá kue̱ꞌe̱ kaꞌni̱. Ta ni̱ndukú na ñava̱ꞌa no̱o̱ ta̱Jesús chindeé ra ñá. ");
INSERT INTO mim_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ta saá ta̱Jesús ni̱to̱nda̱a yatin ra no̱o̱ kándúꞌu̱ ñá, ta kíxáꞌá ra xáꞌnda chiño ra no̱o̱ kue̱ꞌe̱ ña saña ña ñáyóꞌo. Ta xa̱ndi̱ko̱n sa̱ña kue̱ꞌe̱ xíꞌin ñá, ta ndu̱va̱ꞌa ñá. Ta nda̱koo ñá, ta ki̱xáꞌá ñá kísa ndivi ñá ña kuxu na. ");
INSERT INTO mim_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tá xikuaa ni̱ke̱tá ño̱ꞌo, ta kua̱ꞌa̱ ní ni̱vi kua̱ꞌa̱n na xíꞌin natáꞌan na, na ndeé ndóꞌo, ta ni̱xaa̱ na no̱o̱ ta̱Jesús. Ta ta̱Jesús ni̱to̱nda̱a ndaꞌa̱ ra ñii ñii na, ta sa̱ndúva̱ꞌa ra na. ");
INSERT INTO mim_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ta ta̱va ra kua̱ꞌa̱ ní níma̱ ndiva̱ꞌa xi̱komí sava na. Tá ke̱e níma̱ ndiva̱ꞌa ni̱vi, ta xíꞌin to̱ꞌon ndason ni̱ka̱ꞌa̱n ña xíꞌin ta̱Jesús, káchí ña saá: ―Yóꞌó kúu Sa̱ꞌya Ndios ―káchí ña. Ta ta̱Jesús o̱n vása ní‑taxi ra ka̱ꞌa̱n ka̱ ñaníma̱ ndiva̱ꞌa, chi xíni̱ ña Cristo kúu ra. ");
INSERT INTO mim_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tá ni̱ti̱vi inka̱ ki̱vi̱, ke̱e ta̱Jesús kua̱ꞌa̱n ra ñii xiiña no̱o̱ o̱n ko̱ó ni̱vi. Ta kua̱ꞌa̱ ní ni̱vi ke̱e na kua̱ꞌa̱n na nandukú na ra. Ta ni̱xaa̱ na no̱o̱ ta̱Jesús, ta o̱n xi̱in na taxi na kee ra ko̱ꞌo̱n ra inka̱ ñoo. ");
INSERT INTO mim_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Xíni̱ ñóꞌó ka̱ꞌa̱n ndoso i̱ to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ yichi̱ Ndios no̱o̱ ni̱vi na inka̱ ñoo, chi xa̱ꞌa̱ ñayóꞌo Ndios ti̱ꞌví ra yi̱ꞌi̱ va̱xi i̱ ñoyívi yóꞌo ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ta saá ta̱Jesús ke̱e ra kua̱ꞌa̱n ra kua̱ꞌa̱ ní veꞌe ño̱ꞌo sinagoga estado Galilea, ta káꞌa̱n ndoso ra to̱ꞌon Ndios no̱o̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ñii ki̱vi̱ ñíndichi ta̱Jesús yuꞌu̱ mi̱ni káꞌno na̱ní Genesaret. Ta kua̱ꞌa̱ ní ni̱vi va̱xi taꞌa na no̱o̱ ra, chi kóni na koni̱ so̱ꞌo na to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ta ta̱Jesús xi̱ni ra o̱vi̱ tón barco yíta nó yuꞌu̱ mi̱ni chi xa no̱o nata̱a na táva tia̱ká, ta ki̱xáꞌá na nákata na ñono̱ na yuꞌu̱ takuií. ");
INSERT INTO mim_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ta ta̱Jesús nda̱a ra ñii tón barco, tón barco ta̱Simón kúu nó. Saá ndu̱kú ta̱Jesús ña sakutaꞌa loꞌo ka̱ ra nó ma̱ꞌñó takuií. Ta xi̱koo ta̱Jesús ini tón barco yóꞌo, ta ki̱xáꞌá ra sánáꞌa ra ni̱vi na yíta yuꞌu̱ takuií. ");
INSERT INTO mim_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tá ndi̱ꞌi ni̱ka̱ꞌa̱n ra xíꞌin nayóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Simón: ―Vitin va̱ꞌa sakutaꞌa ún tón barco no̱o̱ kónó va̱ꞌa takuií yóꞌo, ta sakana niꞌni ndó ñono̱ ña ná kako̱ꞌon tia̱ká ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ta nda̱kuii̱n ta̱Simón, káchí ra saá: ―Tata Maestro, xa ni̱kisa chiño ndi̱ niño ñoó, ta nda̱ ñii tia̱ká o̱n vása ní‑tava ndi̱. Ta vitin tuku sakana niꞌni ndi̱ ñono̱, chi saá xa̱ꞌnda chiño ún no̱o̱ ndi̱. ");
INSERT INTO mim_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ta sa̱kana niꞌni na ñono̱ ini takuií, ta kua̱ꞌa̱ ní tia̱ká ni̱kako̱ꞌon. Ni̱chútú nda̱a̱ rí ini ñono̱, ta̱nda̱ ki̱xáꞌá ña táꞌnda̱ ña xíꞌin ña veé ní tia̱ká. ");
INSERT INTO mim_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ta xíꞌin ndaꞌa̱ na ka̱na na natáꞌan na, na ñóꞌo ini inka̱ tón barco, ña kixi na chindeé ñaꞌá na. Ta saá ki̱xaa̱ nayóꞌo, ta sa̱kutú na o̱vi̱ tón barco xíꞌin tia̱ká. Ta chútú nda̱a̱ tón barco, ta ña veé ní ndíso nó ki̱xáꞌá nó kua̱n ke̱tá nó ini takuií. ");
INSERT INTO mim_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tá xi̱ni ta̱Simón ña chútú nda̱a̱ tón barco, ta xi̱kuxítí ra no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Yi̱ꞌi̱ kúu ta̱a ta̱ kómí kua̱chi, ta yóꞌó kúu ta̱yi̱i̱. Ña̱kán o̱n vása kómí i̱ yichi̱ kutáꞌan i̱ xíꞌin ún ―káchí ta̱Simón xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chi ta̱Simón yóꞌo xíꞌin natáꞌan ra, na̱kaꞌnda ini na ta ni̱yi̱ꞌví na ña xíto na chútú nda̱a̱ tón barco xíꞌin tia̱ká. ");
INSERT INTO mim_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ta ñii saá ni̱yi̱ꞌví o̱vi̱ sa̱ꞌya ta̱Zebedeo, na̱ní na Jacobo xíꞌin Juan, ta ñii káchí kísa chiño na xíꞌin ta̱Simón, ta u̱ni̱ ta̱a yóꞌo kúu ta̱ xíꞌin yito̱n tón barco. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱Simón: ―O̱n kuyi̱ꞌví ún. Saá chi vitin kíxáꞌá ún inka̱ chiño, ña kúu ña nakaya ún ni̱vi kundiko̱n na yichi̱ Ndios ―káchí ta̱Jesús xíꞌin ta̱Simón. ");
INSERT INTO mim_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ta saá na̱tava na tón barco nda̱ no̱o̱ yi̱chí yuꞌu̱ mi̱ni, ta sa̱ndakoo na ndiꞌi ña kómí na, ta xi̱kundiko̱n na kua̱ꞌa̱n na sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ñii ki̱vi̱ yóo ta̱Jesús ñii ñoo, ta ki̱xaa̱ ñii ta̱a ndeé ní ndóꞌo ra kue̱ꞌe̱ táꞌyí ña na̱ní lepra. Tá xi̱ni ra ta̱Jesús, ta ki̱xaa̱ ra no̱o̱ ra, ta xi̱kuxítí ra nda̱ chi̱ndúꞌu̱ ra ta̱ꞌya̱ ra no̱o̱ ñoꞌo̱, ta xa̱ku ndáꞌví ra no̱o̱ ta̱Jesús, káchí ra saá: ―Tata, tá kóni ún, ta sandaꞌa ún yi̱ꞌi̱ no̱o̱ kue̱ꞌe̱ ña ndóꞌo i̱ ―káchí ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ta ta̱Jesús chi̱nóo ra ndaꞌa̱ ra so̱ko̱ ta̱yóꞌo, ta ni̱ka̱ꞌa̱n ra: ―Kóni i̱ chindeé i̱ yóꞌó. ¡Ndaꞌa ún! ―káchí ra xíꞌin ra. Ta xa̱ndi̱ko̱n sa̱ña kue̱ꞌe̱ táꞌyí xíꞌin ra, ta ndu̱va̱ꞌa ra. ");
INSERT INTO mim_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ta ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ ra, káchí ra saá: ―O̱n ndato̱ꞌon ún xíꞌin nda̱ ñii ni̱vi. Ta vitin ko̱ꞌo̱n ún no̱o̱ ta̱su̱tu̱ ná koto ra yóꞌó ña kunda̱a̱ ini ra xa ni̱ndaꞌa ún. Ta kuniꞌi ún ndiꞌi ñasóko̱ ña xáꞌnda chiño nda̱yí Ndios ña ni̱taa ta̱Moisés, ta taxi ún ñayóꞌo ndaꞌa̱ Ndios ña kunda̱a̱ ini ni̱vi xa ni̱ndaꞌa ún ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ta ni̱xi̱ta̱ níꞌnó to̱ꞌon xa̱ꞌa̱ ña ke̱ꞌé ta̱Jesús, ta kua̱ꞌa̱ ní ni̱vi kua̱ꞌa̱n na nakutáꞌan na no̱o̱ ta̱Jesús ña koni̱ so̱ꞌo na to̱ꞌon ña káꞌa̱n ra, ta kóni na sandaꞌa ra na no̱o̱ ndiꞌi kue̱ꞌe̱ ndóꞌo na. ");
INSERT INTO mim_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ta kua̱ꞌa̱ ní yichi̱ ta̱Jesús xáꞌa̱n ra ñii xiiña no̱o̱ o̱n ko̱ó ni̱vi, ña ka̱ꞌa̱n ra xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ñii ki̱vi̱ ta̱Jesús sánáꞌa ra ni̱vi, ta ndóo sava nafariseo xíꞌin inka̱ na sánáꞌa nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá. Ki̱xi sava nayóꞌo kua̱ꞌa̱ ñoo estado Galilea, ta sava na ki̱xi ñoo Jerusalén xíꞌin inka̱ kua̱ꞌa̱ ñoo estado Judea. Ta ndóo na xíni̱ so̱ꞌo na ña káꞌa̱n ta̱Jesús, ta ndee̱ Ndios yóo xíꞌin ra ña sandaꞌa ra ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ta va̱xi ko̱mi̱ ta̱a ñíso̱kó na ñii xi̱to no̱o̱ kánóo ñii ta̱a ta̱ o̱n ki̱ví kanda, ta ki̱xaa̱ na veꞌe no̱o̱ yóo ta̱Jesús. Ndúkú na ki̱ꞌvi na xíꞌin ta̱ o̱n ki̱ví kanda ini veꞌe yóꞌo, chi kóni na chindúꞌu̱ na ra no̱o̱ ta̱Jesús ña sandaꞌa ñaꞌá ra. ");
INSERT INTO mim_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ta chútú nda̱a̱ ni̱vi, ta ni̱‑kuchiño ki̱ꞌvi na xíꞌin xi̱to no̱o̱ kánóo ta̱ o̱n ki̱ví kanda. Ta saá nda̱a na si̱ni̱ veꞌe, ndíso na xi̱to no̱o̱ kánóo ra, ta ki̱ndaa na sava chíyó ña ni̱xo̱na̱ ñii yavi̱ no̱o̱ kúchiño sanoo na ta̱yóꞌo no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tá ta̱Jesús xi̱ni ra ko̱mi̱ ta̱a yóꞌo kándixa na ndí kúndeé ra sandaꞌa ra ta̱táꞌan na, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱ ndeé ndóꞌo, káchí ra saá: ―Ñani, vitin xa ki̱sa káꞌno ini i̱ xa̱ꞌa̱ kua̱chi ún ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ta nafariseo xíꞌin inka̱ na sánáꞌa nda̱yí Ndios xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱Jesús, ta ki̱xáꞌá na xáni si̱ni̱ na saá: “¿Ndá nda̱yí kómí ta̱yóꞌo káꞌa̱n ra saá? ¿Án xáni ini ra mi̱i ra kúu Ndios? Chi kúnda̱a̱ ini yó ndí ñii la̱á Ndios kómí nda̱yí kasa káꞌno ini ra xa̱ꞌa̱ kua̱chi ni̱vi”, xáni si̱ni̱ na. ");
INSERT INTO mim_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ta ta̱Jesús xíni̱ ra yukía̱ xáni si̱ni̱ nayóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Nda̱chun xáni si̱ni̱ ndó ña o̱n váꞌa yóꞌo? ");
INSERT INTO mim_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Yukía̱ yo̱ꞌvi̱ ka̱ ka̱ꞌa̱n i̱ xíꞌin ta̱ o̱n ki̱ví kanda? ¿Án yo̱ꞌvi̱ ka̱ ka̱ꞌa̱n i̱ xíꞌin ra ña ndoo kua̱chi ra? ¿Án yo̱ꞌvi̱ ka̱ ka̱ꞌa̱n i̱ xíꞌin ra ña nakundichi ra ta ko̱ꞌo̱n xáꞌá ra? ");
INSERT INTO mim_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ta vitin sandaꞌa i̱ ta̱yóꞌo, ta saá kunda̱a̱ ini ndóꞌó ndí yi̱ꞌi̱ kúu ta̱ kómí nda̱yí Ndios ñoyívi yóꞌo ña nakata i̱ kua̱chi ni̱vi. Ta saá ni̱ka̱ꞌa̱n ra xíꞌin ta̱ ndeé ndóꞌo yóꞌo: ―Nakundichi ún ta ná kuiso ún xi̱to ún, ta noꞌo̱ ún vitin ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ta saá no̱o̱ ndiꞌi ni̱vi na yíta yóꞌo, xa̱ndi̱ko̱n na̱kundichi ta̱yóꞌo, ta na̱kuso̱kó ra xi̱to ra, ta na̱kiꞌin ra yichi̱ kua̱noꞌo̱ ra veꞌe ra. Ta kísa káꞌno ní ra Ndios chi nda̱ꞌa ra. ");
INSERT INTO mim_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ndiꞌi ni̱vi na̱kaꞌnda ní ini na, ta kísa káꞌno na Ndios. Ta ki̱xáꞌá na yíꞌví ní na, káꞌa̱n na: ―¡Nda̱chun ñava̱ꞌa ní xi̱ni ndi̱ ki̱vi̱ vitin! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ta saá ta̱Jesús ke̱e ra kua̱ꞌa̱n ra, ta xi̱ni ra ñii ta̱a na̱ní ra Leví, yóo ra kísa chiño ra no̱o̱ káya ra si̱ꞌún xa̱ꞌa̱ nagobierno ñoo Roma. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱Leví, káchí ra saá: ―Naꞌa kundiko̱n ún sa̱ta̱ i̱ ―káchí ra xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ta ta̱Leví sa̱ndakoo ra ndiꞌi ña kómí ra, ta na̱kundichi ra, ta kua̱ꞌa̱n ra sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ta saá ta̱Leví ki̱sa ndivi ra ñii viko̱ káꞌno veꞌe ra xa̱ꞌa̱ ta̱Jesús. Ta kua̱ꞌa̱ ní na káya si̱ꞌún xa̱ꞌa̱ nagobierno xíꞌin kua̱ꞌa̱ ní inka̱ na kánóo to̱ꞌon ña o̱n váꞌa xa̱ꞌa̱, ni̱xi̱yo na veꞌe yóꞌo xíxi na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ta nafariseo xíꞌin na sánáꞌa nda̱yí Ndios, xi̱ni na yu kúu ni̱vi ndóo xíxi xíꞌin ta̱Jesús. Ta saá ni̱ka̱ꞌa̱n na xíꞌin naxíka xíꞌin ta̱Jesús siꞌa: ―O̱n vása va̱ꞌa ñayóꞌo. ¿Nda̱chun xíxi ndó xíꞌin ni̱vi na káya si̱ꞌún xa̱ꞌa̱ nagobierno, xíꞌin inka̱ na kánóo to̱ꞌon ña o̱n váꞌa xa̱ꞌa̱? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ni̱vi na o̱n vása ndeé ndóꞌo, o̱n vása xíni̱ ñóꞌó nayóꞌo na kasa ta̱ta̱n ñaꞌá, ta ni̱vi na ndeé ndóꞌo kúu na xíni̱ ñóꞌó kutátán. ");
INSERT INTO mim_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","O̱n si̱ví xa̱ꞌa̱ ni̱vi va̱ꞌa kúu ña ki̱xaa̱ i̱ ñoyívi yóꞌo. Ta xa̱ꞌa̱ ni̱vi na o̱n váꞌa kúu ña ki̱xaa̱ i̱, ta kana i̱ na ña nandikó ini na ta kundiko̱n na yichi̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ta ni̱ka̱ꞌa̱n ni̱vi xíꞌin ta̱Jesús: ―Kua̱ꞌa̱ ní yichi̱ na ndíko̱n sa̱ta̱ ta̱Juan yóo soꞌon na, ta káꞌa̱n na xíꞌin Ndios, ta ñii ki̱ꞌva saá yóo nafariseo. Ta naxíka xíꞌin mi̱i ún, ¿nda̱chun nda̱ ñii ki̱vi̱ o̱n vása yóo soꞌon na? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―Tá yóo ñii ta̱a ta̱ tonda̱ꞌa̱, ta ndiꞌi ni̱vi na yóo viko̱ tonda̱ꞌa̱ yóꞌo xíxi na, ta o̱n ki̱ví koo soꞌon na, saá chi yóo ka̱ ta̱yóꞌo xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ta ki̱vi̱ ña va̱xi, o̱n kóo ka̱ ra xíꞌin na. Ta saá kía̱ koo soꞌon na. ");
INSERT INTO mim_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ta saá nda̱to̱ꞌon ta̱Jesús o̱vi̱ cuento ña sanáꞌa ra na, káchí ra saá: ―Tá yóo ñii tiko̱to̱ ña yatá, ta nda̱ ñii ni̱vi o̱n kaꞌnda na tiko̱to̱ xa̱á ña sandaꞌa na no̱o̱ tiko̱to̱ yatá. Saá chi tiko̱to̱ ña xa̱á ndiꞌi xa̱ꞌa̱ ña, ta ñii ñáꞌño tiko̱to̱ xa̱á o̱n vása va̱ꞌa kunaꞌa ña ña nakutáꞌan ña xíꞌin ña yatá. ");
INSERT INTO mim_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ta nduta̱ vino xa̱á, ta nda̱ ñii ni̱vi o̱n vása taan na rá ini ñii̱ yatá. Saá chi ta̱ꞌnda̱ ñii̱ yóꞌo, ta kui̱ta̱ ndiꞌi tánduta̱ vino, ta ndiꞌi xa̱ꞌa̱ ñii̱. ");
INSERT INTO mim_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Xíni̱ ñóꞌó taan na tánduta̱ vino xa̱á ini ñii̱ xa̱á, ta saá kundeé rá koo rá, ta ñii̱ xa̱á yóꞌo o̱n ta̱ꞌnda̱ ña. ");
INSERT INTO mim_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ta ni̱vi na kúsii̱ ini xíꞌi tánduta̱ vino yatá o̱n xi̱in na koꞌo na tánduta̱ vino xa̱á, chi káꞌa̱n na: “Tánduta̱ vino yatá kúu tá va̱ꞌa ka̱ no̱o̱ tánduta̱ vino xa̱á”, káchí na ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ñii ki̱vi̱ yi̱i̱ ña nákindée najudío, ta ta̱Jesús xíꞌin naxíka xíꞌin ra, kua̱ꞌa̱n na yáꞌa na ma̱ꞌñó no̱o̱ yóo yita trigo. Ta naxíka xíꞌin ta̱Jesús ki̱xáꞌá na xáꞌnda na yoko̱ ta ki̱ndaa na so̱o̱ trigo, ta xa̱xi na trigo. ");
INSERT INTO mim_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ta xi̱ni nafariseo ña ke̱ꞌé nayóꞌo, ta ni̱ka̱ꞌa̱n na: ―¿Nda̱chun yáꞌa ndoso ndó nda̱yí Ndios?, chi xa̱ꞌnda ndó trigo, ta o̱n váꞌa kasa chiño yó ki̱vi̱ yi̱i̱ ña nákindée yó, káchí nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá ―káchí nafariseo. ");
INSERT INTO mim_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―¿Án o̱n vása ní‑kaꞌvi ndó to̱ꞌon Ndios no̱o̱ káꞌa̱n ña xa̱ꞌa̱ xi̱i̱ síkuá yó ta̱rey David xíꞌin natáꞌan ra ki̱vi̱ ni̱xiꞌi̱ na so̱ko? ");
INSERT INTO mim_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Saá chi kui̱ya̱ xi̱na̱ꞌá ni̱ki̱ꞌvi ta̱rey David ini veꞌe Ndios, ta xi̱xi ra si̱ta̱ va̱ꞌa ñayi̱i̱, vará o̱n si̱ví ta̱su̱tu̱ xi̱kuu ra. Ta ta̱xi ra si̱ta̱ va̱ꞌa yóꞌo ndaꞌa̱ natáꞌan ra xíxi na. Ta káchí nda̱yí Ndios saá: “Ndasaá su̱tu̱ kuiti kúchiño kuxu si̱ta̱ va̱ꞌa yi̱i̱” ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ta káchí ka̱ ra saá xíꞌin na: ―Yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, kómí i̱ nda̱yí ka̱ꞌa̱n i̱ yukía̱ va̱ꞌa keꞌé yó ki̱vi̱ yi̱i̱ ña nákindée yó ―káchí ta̱Jesús xíꞌin nafariseo. ");
INSERT INTO mim_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ta inka̱ ki̱vi̱ yi̱i̱ ña nákindée najudío, ta̱Jesús ni̱ki̱ꞌvi ra veꞌe ño̱ꞌo sinagoga, ta ki̱xáꞌá ra sánáꞌa ra ni̱vi. Ta yóo ñii ta̱a, ña yi̱chí kúu ndaꞌa̱ kuaꞌá ra, ta o̱n vása kánda ña. ");
INSERT INTO mim_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ta ndóo sava nafariseo xíꞌin na sánáꞌa nda̱yí Ndios, nándukú na ndasaá chikaa̱ na kua̱chi sa̱ta̱ ta̱Jesús. Ta xíto naní na yukía̱ keꞌé ta̱Jesús, án sandaꞌa ra ta̱yóꞌo, chi ki̱vi̱ yi̱i̱ ña nákindée na kúu ña. ");
INSERT INTO mim_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ta ta̱Jesús xíni̱ ra ña xáni ini nayóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱a ta̱ yi̱chí ndaꞌa̱: ―Naꞌa kundichi ún ma̱ꞌñó no̱o̱ ndiꞌi ni̱vi yóꞌo. Ta saá na̱kundichi ra ta ki̱xaa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra ni̱vi: ―¿Yukía̱ káchí nda̱yí Ndios xa̱ꞌa̱ ki̱vi̱ yi̱i̱ ña nákindée yó? ¿Án o̱n vása ndixa káchí ña keꞌé yó ñava̱ꞌa, ta o̱n keꞌé yó ñandiva̱ꞌa? ¿Án o̱n vása ndixa káchí ña saka̱ku yó ni̱vi, ta o̱n sandiꞌi yó xa̱ꞌa̱ na? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ta ta̱Jesús na̱koto va̱ꞌa ra no̱o̱ ndiꞌi na, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱a ta̱ yi̱chí ndaꞌa̱: ―Sanakaa̱ ún ndaꞌa̱ ún vitin ―káchí ra. Ta ta̱yóꞌo sa̱nakaa̱ ra ndaꞌa̱ ra, ta ndu̱va̱ꞌa ña. ");
INSERT INTO mim_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ta nafariseo ni̱saa̱ ní ini na, ta ki̱xáꞌá na káꞌa̱n na xíꞌin táꞌan na ndasaá koo kaꞌni na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ñii ki̱vi̱ ke̱e ta̱Jesús kua̱ꞌa̱n ndaa ra ñii xi̱ki̱ ña ka̱ꞌa̱n ra xíꞌin Ndios. Niño ñoó ni̱ka̱ꞌa̱n ra xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ta ni̱ti̱vi inka̱ ki̱vi̱. Ta ka̱na ra na ndíko̱n sa̱ta̱ ra va̱xi na no̱o̱ ra, ta na̱ka̱xin ra u̱xu̱ o̱vi̱ ta̱a, ta sa̱kunaní ra na apóstol. ");
INSERT INTO mim_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ta ñii ñii ta̱ u̱xu̱ o̱vi̱ apóstol yóꞌo na̱ní ra siꞌa: ñii ra na̱ní Simón, ta ta̱Jesús sa̱kunaní ñaꞌá ra Pedro; inka̱ ra na̱ní Andrés, ñani ta̱Simón kúu ra; inka̱ ra na̱ní Jacobo; inka̱ ra na̱ní Juan; inka̱ ra na̱ní Felipe; inka̱ ra na̱ní Bartolomé; ");
INSERT INTO mim_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","inka̱ ra na̱ní Mateo; inka̱ ra na̱ní Tomás; inka̱ ra na̱ní Jacobo, sa̱ꞌya ta̱Alfeo kúu ra; inka̱ ra na̱ní Simón, ta̱a ta̱ ndíko̱n partido na̱ní ña zelote kúu ra; ");
INSERT INTO mim_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","inka̱ ra na̱ní Judas, sa̱ꞌya ta̱Jacobo kúu ra; inka̱ ra na̱ní Judas Iscariote, ta̱yóꞌo xi̱kuu ta̱a ta̱ ni̱to̱nda̱a ni̱si̱kó kuíꞌná ta̱Jesús ndaꞌa̱ na sáa̱ ini xíni ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ta no̱o̱ yuku̱ va̱xi noo ta̱Jesús xíꞌin na na̱ka̱xin ra kaka xíꞌin ra, ta ki̱xaa̱ na ñii yoso̱. Ta na̱kutáꞌan kua̱ꞌa̱ ní ni̱vi na ndíko̱n sa̱ta̱ ra xíꞌin inka̱ na ki̱xaa̱ no̱o̱ ra. Sava nayóꞌo ki̱xi na ñoo Jerusalén xíꞌin kua̱ꞌa̱ ka̱ ñoo estado Judea, inka̱ na ki̱xi ñoo Tiro xíꞌin ñoo Sidón, ña ñóꞌo yatin yuꞌu̱ takuií mi̱ni. Ki̱xaa̱ na koni̱ so̱ꞌo na to̱ꞌon ña ka̱ꞌa̱n ta̱Jesús xíꞌin na, ta ndúkú na ña sandaꞌa ra ni̱vi na ndeé ndóꞌo kue̱ꞌe̱. ");
INSERT INTO mim_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ta ta̱Jesús ta̱va ra ndiꞌi níma̱ ndiva̱ꞌa, ta sa̱ndaꞌa ra na ndeé ndóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ndiꞌi nayóꞌo kóni na to̱nda̱a na ta̱Jesús, saá chi ndee̱ Ndios kée ña ra, ta sándaꞌa ña na. ");
INSERT INTO mim_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ta saá xíto ta̱Jesús no̱o̱ naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Tá kúu ndóꞌó nandáꞌví, na kúnda̱a̱ ini ndí xíni̱ ñóꞌó ndó Ndios, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó, chi kúu ndó ni̱vi na ndíko̱n yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Tá nándukú ndó Ndios, nda̱tán ni̱vi na xíꞌi̱ ní so̱ko nándukú na ña kuxu na, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó, chi Ndios taxi ra ña kutú ini ndó xíꞌin ñava̱ꞌa. ’Tá kúchuchú ini ndó ta̱nda̱ xáku ndó xa̱ꞌa̱ ñoyívi yóꞌo, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó, chi va̱xi ki̱vi̱ Ndios sakutú ka̱ ra ñasi̱i̱ ní níma̱ ndó. ");
INSERT INTO mim_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Tá yóo ni̱vi ta sáa̱ ini na xíni na ndóꞌó, ta o̱n xi̱in na kutáꞌan va̱ꞌa na xíꞌin ndó, ta kándiva̱ꞌa na xíꞌin ndó ta chíkaa̱ na ñato̱ꞌó ndó nda̱ ni̱no̱ chi ndíko̱n ndó yi̱ꞌi̱, ta xa̱ꞌa̱ ñayóꞌo nákaa̱ ñasi̱i̱ níma̱ ndó. ");
INSERT INTO mim_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ki̱vi̱ ña ku̱ndeé ndó xóꞌvi̱ ndó siꞌa, ta ná kusii̱ ní ini ndó, chi káꞌno ní ñava̱ꞌa taxi Ndios ndaꞌa̱ ndó ñoyívi ni̱no. Nani̱vi na xi̱taku̱ xi̱na̱ꞌá sa̱xo̱ꞌvi̱ ní na naprofeta, ta ñii ki̱ꞌva saá sa̱ꞌya ñani síkuá na saxo̱ꞌvi̱ na ndóꞌó vitin, xa̱ꞌa̱ ña ndíko̱n ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’¡Ndáꞌví ní ndóꞌó nakuíká!, chi kúsii̱ ní ini ndó xíꞌin ña yóo ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’¡Ndáꞌví ní ndóꞌó na chútú ti̱xin vitin!, chi va̱xi ki̱vi̱ ña o̱n kóo ka̱ ña kuxu ndaꞌa̱ ndó, ta kivi̱ ndó so̱ko. ’¡Ndáꞌví ní ndóꞌó na si̱i̱ ní xáku̱ vitin!, chi va̱xi ki̱vi̱ ña kuchuchú ní ini ndó ta̱nda̱ kuaku ndó. ");
INSERT INTO mim_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’¡Ndáꞌví ní ndóꞌó na va̱ꞌa ní káꞌa̱n ndiꞌi ni̱vi xa̱ꞌa̱ vitin! Saá chi xi̱na̱ꞌá xi̱i̱ síkuá ndó ñii ki̱ꞌva saá va̱ꞌa ní ni̱ka̱ꞌa̱n na xa̱ꞌa̱ naprofeta vatá ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Saá ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin na, káchí ra saá: ―Kóni i̱ ka̱ꞌa̱n ka̱ i̱ xíꞌin ndóꞌó na xíni̱ so̱ꞌo ña káꞌa̱n i̱: Kukiꞌvi ini ndó koni ndó ni̱vi na sáa̱ ini xíni ndóꞌó, ta keꞌé ndó ñava̱ꞌa xíꞌin ni̱vi na o̱n xi̱in koni ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ndukú ndó no̱o̱ Ndios ña keꞌé ra ñava̱ꞌa xíꞌin ni̱vi na sáta̱vi̱ chiꞌña ndóꞌó, ta ka̱ꞌa̱n ndó xíꞌin Ndios xa̱ꞌa̱ ni̱vi na kándiva̱ꞌa xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tá káni ni̱vi xa̱ꞌnda̱ ndaꞌa̱ na no̱o̱ ñii ndó, ta o̱n kani táꞌan ndó xíꞌin na, ta va̱ꞌa ka̱ taxi ndó ná kani na inka̱ táꞌví no̱o̱ ndó. Tá ñii ni̱vi kíndaa na tika̱chí ndó, ta va̱ꞌa taxi ndó ña kindaa na nda̱ kotó ndó. ");
INSERT INTO mim_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tá yóo ni̱vi na ndúkú ña̱ꞌa no̱o̱ ndó, ta va̱ꞌa taxi ndó ña ndúkú na ndaꞌa̱ na. Tá yóo ni̱vi na kíndaa ña kómí ndó ndaꞌa̱ ndó, ta o̱n ndukú ndó nataxi na ña ki̱ndaa na ndaꞌa̱ ndó. ");
INSERT INTO mim_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ta ñii ki̱ꞌva nda̱tán kóni ndó keꞌé ni̱vi ñava̱ꞌa xíꞌin ndó, saá keꞌé ndó ñava̱ꞌa xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Saá chi tá kíꞌvi ini ndó xíni ndó ndasaá kuiti ni̱vi na kíꞌvi ini xíni ndóꞌó, ta o̱n vása káꞌno ñayóꞌo no̱o̱ Ndios, chi inka̱ ni̱vi, vará na o̱n váꞌa kúu na, ta saá ni, kíꞌvi ini nayóꞌo xíni na ni̱vi na kíꞌvi ini xíni ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tá kéꞌé ndó ñava̱ꞌa xíꞌin ndasaá kuiti na kéꞌé ñava̱ꞌa xíꞌin ndó, ta o̱n vása káꞌno ñayóꞌo no̱o̱ Ndios, chi inka̱ ni̱vi, vará na o̱n váꞌa kúu na, ta saá ni, kéꞌé na ñava̱ꞌa xíꞌin ni̱vi na kéꞌé ñava̱ꞌa xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tá sátati ndó ña kómí ndó ndasaá kuiti ndaꞌa̱ ni̱vi na ndáti ndó nataxi ña ndaꞌa̱ ndó, ta o̱n vása káꞌno ñayóꞌo no̱o̱ Ndios, chi nda̱ ni̱vi na o̱n váꞌa sátati na ña kómí na ndaꞌa̱ natáꞌan na, chi xáni si̱ni̱ na ñii ki̱vi̱ nakiꞌin tuku na ña sa̱tati na. ");
INSERT INTO mim_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ta ndóꞌó, xíni̱ ñóꞌó kukiꞌvi ini ndó koni ndó ni̱vi na sáa̱ ini xíni ndóꞌó. Keꞌé ndó ñava̱ꞌa xíꞌin na, ta satati ndó na ña kómí ndó, vará o̱n vása ndáti ndó nakiꞌin tuku ndó ña sa̱tati ndó. Ta saá kuchiño nakiꞌin ndó ñava̱ꞌa taxi Ndios ndaꞌa̱ ndó. Chi ñava̱ꞌa keꞌé ndó sanáꞌa ña ndixa kúu ndó sa̱ꞌya Ndios ta̱Káꞌno. Chi Ndios kéꞌé ra ñava̱ꞌa xíꞌin ni̱vi na o̱n váꞌa, ta xíꞌin ni̱vi na o̱n xi̱in nakoni ndiꞌi ñava̱ꞌa va̱xi no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kundáꞌví ini ndó koni ndó inka̱ ni̱vi, saá chi Yivá yó Ndios kúu ta̱ kúndáꞌví ní ini xíni ndiꞌi ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Tá o̱n ka̱ꞌa̱n ndó ña o̱n váꞌa xa̱ꞌa̱ inka̱ ni̱vi, ta Ndios o̱n ka̱ꞌa̱n ra ña o̱n váꞌa xa̱ꞌa̱ ndóꞌó. Tá o̱n sata̱vi̱ chiꞌña ndó inka̱ ni̱vi, ta Ndios o̱n sata̱vi̱ chiꞌña ra ndóꞌó. Tá kasa káꞌno ini ndó xa̱ꞌa̱ kua̱chi inka̱ ni̱vi, ta Ndios kasa káꞌno ini ra xa̱ꞌa̱ kua̱chi ndó. ");
INSERT INTO mim_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tá taxi ndó ñava̱ꞌa ndaꞌa̱ inka̱ ni̱vi, ta saá Ndios taxi ra ñava̱ꞌa ndaꞌa̱ ndó. Nda̱tán yóo ki̱ꞌva chútú ña sákutú niꞌi na, ta̱nda̱ kóyo ndaa mi̱i ña, saá koo ki̱ꞌva ña taxi Ndios ndaꞌa̱ ndó. Nda̱tán yóo ki̱ꞌva ña taxi ndó ndaꞌa̱ inka̱ ni̱vi, ta mi̱i ki̱ꞌva yóꞌo taxi Ndios ndaꞌa̱ ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ta nda̱to̱ꞌon ta̱Jesús ñii cuento ña sanáꞌa ra na. Ni̱ka̱ꞌa̱n ra, káchí ra saá: ―¿Án kúchiño ñii ta̱kuáá tiin ra ndaꞌa̱ inka̱ ta̱kuáá ña ko̱ꞌo̱n ra ñii yichi̱? O̱n kúchiño, chi o̱vi̱ ra saá ko̱yo taꞌvi̱. ");
INSERT INTO mim_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tá yóo ñii ta̱ sákuáꞌá, ta o̱n kuchiño kuu ra ta̱ káꞌno ka̱ no̱o̱ ta̱maestro ra. Ta saá ni, tá ndi̱ꞌi sa̱kuáꞌá ní ra, ta kuchiño to̱nda̱a ra koo ra nda̱tán yóo ta̱maestro ra ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ta nda̱to̱ꞌon ta̱Jesús inka̱ cuento ña sanáꞌa ra, káchí ra saá xíꞌin na: ―Nda̱tán yóo ni̱vi na kíꞌin va̱ꞌa kuenda ña nákaa̱ ñii mi̱ꞌí loꞌo nduchu̱ no̱o̱ ñani táꞌan na, ta o̱n vása kíꞌin na kuenda ña nákaa̱ ñii yito̱n tón káꞌno nduchu̱ no̱o̱ mi̱i na, ta saá yóo ndóꞌó, chi kíꞌin va̱ꞌa ndó kuenda ña kua̱chi loꞌo kéꞌé natáꞌan ndó, ta o̱n vása kíꞌin ndó kuenda ña kua̱chi káꞌno kéꞌé mi̱i ndó. ");
INSERT INTO mim_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tá nákaa̱ ñii yito̱n káꞌno nduchu̱ no̱o̱ ndó, ta o̱n váꞌa ka̱ꞌa̱n ndó xíꞌin ñani ndó, kachí ndó saá: “Taxi ún ná tava i̱ mi̱ꞌí loꞌo nákaa̱ nduchu̱ no̱o̱ ún”, kachí ndó. Tá kéꞌé ndó saá, ta, ¡ni̱vi na o̱vi̱ yuꞌu̱ kúu ndóꞌó! Chi siꞌna xíni̱ ñóꞌó tava ndó yito̱n nákaa̱ nduchu̱ no̱o̱ ndó, ta saá kuchiño va̱ꞌa koto ndó ña tava ndó mi̱ꞌí loꞌo nákaa̱ nduchu̱ no̱o̱ ñani ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","―Nda̱ ñii yito̱n tón va̱ꞌa, o̱n ki̱ví koon kui̱ꞌi tí o̱n váꞌa ndaꞌa̱ nó, ta nda̱ ñii yito̱n tón o̱n váꞌa, o̱n ki̱ví koon kui̱ꞌi va̱ꞌa ndaꞌa̱ nó. ");
INSERT INTO mim_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tá xíto ndó kui̱ꞌi ndaꞌa̱ yito̱n, ta saá kúnda̱a̱ ini ndó ndá yito̱n kúu nó. Yito̱n tón ñiño̱ ta o̱n vása kóon tíhigo ni tíuva ndaꞌa̱ nó. ");
INSERT INTO mim_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tón yito̱n sánáꞌa saá: Ni̱vi na kómí níma̱ va̱ꞌa, káꞌa̱n na to̱ꞌon va̱ꞌa. Ta ni̱vi na kómí níma̱ o̱n váꞌa, káꞌa̱n na to̱ꞌon o̱n váꞌa. Saá chi nda̱tán yóo níma̱ ni̱vi, saá yóo to̱ꞌon ña káꞌa̱n na ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ta saá ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na: ―Ta ndóꞌó, ¿nda̱chun káꞌa̱n ndó yi̱ꞌi̱ kúu ta̱Káꞌno no̱o̱ ndó, ta o̱n xi̱in ndó kasa ndivi ndó ña káꞌa̱n i̱ xíꞌin ndó? ");
INSERT INTO mim_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ta vitin ndáto̱ꞌon i̱ xíꞌin ndó ndasaá yóo ni̱vi na xíni̱ so̱ꞌo to̱ꞌon i̱ ta kísa ndivi na ña káꞌa̱n i̱ xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nda̱tán yóo ñii ta̱a ta̱ ndíchí si̱ni̱, saá yóo na. Saá chi ta̱a ta̱ ndíchí si̱ni̱ xáta kónó ra ta kísa va̱ꞌa ra veꞌe ra sa̱ta̱ yu̱u̱ chée kútu̱. Tá ndeé ní kóon sa̱vi̱, ta xáꞌno ní yu̱ta, ta xa̱ꞌa̱ veꞌe ta̱yóꞌo ndeé ní káni takuií, ta veꞌe ra o̱n vása ní‑nakava ña, chi xa̱ꞌa̱ veꞌe yóꞌo nákaa̱ kútu̱ ña sa̱ta̱ yu̱u̱ chée. ");
INSERT INTO mim_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ta nda̱tán yóo ñii ta̱a ta̱ o̱n vása ndíchí si̱ni̱, ta ta̱yóꞌo kísa va̱ꞌa ra veꞌe ra no̱o̱ yóo yo̱tí vitá, saá yóo ni̱vi na xíni̱ so̱ꞌo to̱ꞌon ña káꞌa̱n i̱, ta o̱n vása kísa ndivi na ña. Tá ndeé ní kóon sa̱vi̱, ta xáꞌno ní yu̱ta, ta̱nda̱ xa̱ꞌa̱ veꞌe ta̱yóꞌo ndeé ní káni takuií, ta o̱n vása ní‑kundeé ña, ta na̱kava ña ta ndi̱ꞌi xa̱ꞌa̱ ña ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tá ndi̱ꞌi ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, ta ndi̱kó ra kua̱noꞌo̱ ra ñoo Capernaum. ");
INSERT INTO mim_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ta yóo ñii ta̱ñoo Roma ta̱ ndíso chiño xíꞌin ñii ciento natropa kúu ra, ta ndeé ní ndóꞌo ñii ta̱ kísa chiño no̱o̱ ra nda̱ yóo ña kivi̱ ra. Ta ta̱patrón ra kíꞌvi ní ini ra xíni ñaꞌá ra. ");
INSERT INTO mim_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ta xi̱ni̱ so̱ꞌo ra to̱ꞌon ña ni̱ka̱ꞌa̱n ni̱vi xa̱ꞌa̱ ta̱Jesús, ta ti̱ꞌví ra sava naxi̱kua̱ꞌa̱ no̱o̱ najudío ko̱ꞌo̱n na ndukú na no̱o̱ ta̱Jesús kixi ra sandaꞌa ra ta̱ kísa chiño no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ki̱vi̱ ni̱xaa̱ naxi̱kua̱ꞌa̱ no̱o̱ ta̱Jesús, ta ki̱xáꞌá na xáku ndáꞌví na no̱o̱ ra, káꞌa̱n na xíꞌin ra: ―Tata, va̱xi ndi̱ ndúkú ndi̱ ñama̱ni̱ no̱o̱ ún sandaꞌa ún ta̱ kísa chiño no̱o̱ ta̱ ndíso chiño xíꞌin natropa ñoo Roma. Ta̱káꞌno yóꞌo kúu ñii ta̱a ta̱ va̱ꞌa ní, ta xa̱ꞌa̱ ñayóꞌo va̱ꞌa chindeé ún ra. ");
INSERT INTO mim_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Saá chi kíꞌvi ní ini ra xíni ra mi̱i yó nañoo Israel, ta ki̱sa va̱ꞌa ra veꞌe ño̱ꞌo sinagoga ñoo yó ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ta saá ke̱e ta̱Jesús kua̱ꞌa̱n ra xíꞌin na. Ta xa yatin xaa̱ na veꞌe no̱o̱ kándúꞌu̱ ta̱ ndeé ndóꞌo, ta ta̱ ndíso chiño xíꞌin natropa ti̱ꞌví ra sava natáꞌan ra kua̱ꞌa̱n na ka̱ꞌa̱n na xíꞌin ta̱Jesús siꞌa: ―Tata, siꞌa káchí ta̱táꞌan ndi̱, ta̱ ndíso chiño no̱o̱ natropa ñoo Roma: O̱n váꞌa sandiꞌi ka̱ ini ún ña kixi ún veꞌe ra. Saá chi xáni si̱ni̱ ra yóꞌó kúu ta̱ káꞌno ní no̱o̱ ra, ta ta̱ ni̱no̱ ní kúu ra no̱o̱ ún. Ña̱kán o̱n váꞌa ki̱ꞌvi ún ini veꞌe ra, ");
INSERT INTO mim_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ni o̱n vása kómí ra yichi̱ kixaa̱ ra no̱o̱ ún, xáni si̱ni̱ ra. Ta kómí ún nda̱yí ña kuiti kaꞌnda chiño ún no̱o̱ kue̱ꞌe̱, ta nduva̱ꞌa ta̱ ndeé ndóꞌo, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kúnda̱a̱ ini ra xa̱ꞌa̱ nda̱yí, chi yóo na xáꞌnda chiño no̱o̱ ra, ta kísa ndivi ra ña káꞌa̱n na xíꞌin ra; ta mi̱i ra xáꞌnda chiño ra no̱o̱ inka̱ natropa, ta kísa ndivi na ña káꞌa̱n ra. Tá káꞌa̱n ra xíꞌin ñii ta̱tropa ña ko̱ꞌo̱n ra, ta saá kua̱ꞌa̱n ra. Tá kána ra inka̱ ra, ta saá va̱xi ra. Tá káꞌa̱n ra xíꞌin ta̱ xíka chiño no̱o̱ ra kasa ndivi ra ñii chiño, ta kísa ndivi ra ña, saá káchí ta̱ ndíso chiño no̱o̱ natropa, ta ti̱ꞌví ra ndi̱ꞌi̱ ka̱ꞌa̱n ndi̱ to̱ꞌon yóꞌo xíꞌin ún ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ta ta̱Jesús na̱kaꞌnda ini ra xi̱ni̱ so̱ꞌo ra to̱ꞌon yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi na ndóo xíꞌin ra: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, ndiꞌi saá ñoo Israel ta̱ꞌán nakutáꞌan i̱ xíꞌin ñii ta̱a ta̱ kándixa Ndios nda̱tán kándixa ta̱yóꞌo, ta ni o̱n si̱ví ta̱judío kúu ra ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ta saá na ki̱xi xíꞌin chiño ndi̱kó na kua̱noꞌo̱ na. Tá na̱xaa̱ na veꞌe ta̱ ndíso chiño xíꞌin natropa, ta xi̱ni na xa ndu̱va̱ꞌa ta̱a ta̱ kísa chiño no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tá ndi̱ꞌi ñayóꞌo, ta ke̱e ta̱Jesús kua̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra ñii ñoo na̱ní ña Naín. Ta kua̱ꞌa̱ ní ni̱vi kua̱ꞌa̱n na sa̱ta̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ta ni̱xaa̱ na yatin no̱o̱ ñoo, ta na̱kutáꞌan na xíꞌin ni̱vi ñíso̱kó na xa̱to̱n no̱o̱ nákaa̱ ñii ta̱ ni̱xiꞌi̱ kua̱ꞌa̱n na sandúxu̱n na ra. Ta̱ ni̱xiꞌi̱ yóꞌo kúu ta̱loꞌo, ñii la̱á ra saá kúu sa̱ꞌya siꞌí ra, ta ni̱xiꞌi̱ ra, ta ni̱ndo̱o matóꞌón siꞌí ra, chi ñá xa ni̱xiꞌi̱ yii̱ kúu ñá. Ta kua̱ꞌa̱ ní natáꞌan ñá kua̱ꞌa̱n na xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ta xi̱ni ta̱Jesús ñáyóꞌo, ta na̱taꞌví ní ini ra xi̱ni ñaꞌá ra, ta ni̱ka̱ꞌa̱n ra xíꞌin ñá: ―O̱n kuaku ún ―káchí ra xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ta ni̱xaa̱ yatin ra, ta ni̱to̱nda̱a ndaꞌa̱ ra xa̱to̱n no̱o̱ nákaa̱ ta̱loꞌo ni̱xiꞌi̱. Ta ni̱vi na ñíso̱kó xa̱to̱n, xi̱kuita na, ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ta̱loꞌo ni̱xiꞌi̱, káchí ra saá: ―Ta̱loꞌo, káꞌa̱n i̱ xíꞌin ún, ¡ndakoo ún! ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ta na̱taku̱ ra, ta nda̱níꞌi loꞌo xíꞌin mi̱i ra, ta xi̱koo ra, ta ki̱xáꞌá ra káꞌa̱n ra. Ta ta̱Jesús na̱taxi ra ta̱loꞌo yóꞌo ndaꞌa̱ siꞌí ra. ");
INSERT INTO mim_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ta ndiꞌi ni̱vi na yíta yóꞌo ki̱xáꞌá na yíꞌví na, ta káꞌa̱n na ñava̱ꞌa xa̱ꞌa̱ Ndios, káchí na saá: ―Ñii ta̱profeta káꞌno xa ki̱xaa̱ ra no̱o̱ yó. Ndios xa ki̱xaa̱ ra chindeé ra nañoo ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ta saá ni̱xi̱ta̱ níꞌnó to̱ꞌon xa̱ꞌa̱ ta̱Jesús ndiꞌi saá ñoo estado Judea, xíꞌin inka̱ ñoo ñóꞌo yatin estado Judea. ");
INSERT INTO mim_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ta ni̱vi naxíka xíꞌin ta̱Juan ta̱a ta̱ sákuchu ni̱vi, ni̱xa̱ꞌa̱n na koto na ra, chi nákaa̱ ra ini veꞌe ka̱a, ta ni̱ka̱ꞌa̱n na xíꞌin ra xa̱ꞌa̱ ndiꞌi ña kéꞌé ta̱Jesús. Ta ta̱Juan ka̱na ra o̱vi̱ naxíka xíꞌin ra, ");
INSERT INTO mim_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ta ti̱ꞌví ra na kua̱ꞌa̱n na no̱o̱ ta̱Jesús, ña nda̱ka̱ to̱ꞌon na ra siꞌa: ―¿Án yóꞌó kúu ta̱a ta̱ ndáti ndi̱ tiꞌví Ndios saka̱ku ra na ñoyívi yóꞌo, án kundati ka̱ ndi̱ inka̱ ra? ");
INSERT INTO mim_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ta saá, ni̱xaa̱ naxíka xíꞌin ta̱Juan no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Ta̱Juan ta̱ sákuchu ni̱vi, ti̱ꞌví ra ndi̱ꞌi̱ va̱xi ndi̱ nda̱ka̱ to̱ꞌon ndi̱ yóꞌó: “¿Án yóꞌó kúu ta̱a ta̱ ndáti ndi̱ tiꞌví Ndios saka̱ku ra na ñoyívi yóꞌo, án kundati ka̱ ndi̱ inka̱ ra?” ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ta mi̱i hora ki̱xaa̱ nayóꞌo no̱o̱ ta̱Jesús, ta sa̱ndaꞌa ra kua̱ꞌa̱ ní ni̱vi na ndeé ndóꞌo ndiꞌi saá no̱o̱ kue̱ꞌe̱, ta ta̱va ra níma̱ ndiva̱ꞌa kómí ni̱vi, ta sa̱ndaꞌa ra nduchu̱ no̱o̱ nakuáá ña koto va̱ꞌa na. ");
INSERT INTO mim_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ta̱Juan: ―Ná ndikó ndó no̱o̱ ta̱Juan, ta ndato̱ꞌon ndó xíꞌin ra ña xi̱ni̱ so̱ꞌo ndó, ta ña xi̱ni ndó yóꞌo. Chi xa xi̱ni ndó ni̱vi na xi̱kuu nakuáá, ta xa va̱ꞌa xíto na vitin. Ta ni̱vi na o̱n vása ní‑kivi kaka, ta vitin xa va̱ꞌa xíka na. Ta ni̱vi na xi̱kuu na ndeé ní ndóꞌo xíꞌin kue̱ꞌe̱ táꞌyí na̱ní ña lepra, ta vitin xa ndu̱ndii na. Ta ni̱vi na ka̱ku sóꞌó, ta vitin xa va̱ꞌa xíni̱ so̱ꞌo na. Ta ni̱vi na ni̱xiꞌi̱, na̱taku̱ na. Ta vitin ni̱vi nandáꞌví xíni̱ so̱ꞌo na to̱ꞌon ñava̱ꞌa káꞌa̱n ndoso i̱. Ta ndiꞌi ña xi̱ni̱ so̱ꞌo ndó ta xi̱to ndó kísa ndivi i̱ yóꞌo, saá kachí ndó ndato̱ꞌon ndó xíꞌin ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ta ta̱a ta̱ kándixa yi̱ꞌi̱, tá o̱n sandakoo ra yi̱ꞌi̱, vará o̱n kasa ndivi i̱ chiño ña ndáti ra, ta nákaa̱ ñasi̱i̱ níma̱ ta̱yóꞌo ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ta saá ke̱e na kua̱noꞌo̱ na, ta ta̱Jesús ki̱xáꞌá káꞌa̱n ra xíꞌin ni̱vi na ndóo no̱o̱ ra, káchí ra saá: ―Ta ki̱vi̱ ni̱xa̱ꞌa̱n ndó xi̱to ndó ta̱Juan no̱o̱ yuku̱ yi̱chí, ¿yukía̱ ndáti ndó koto ndó? ¿Án ndáti ndó koto ndó ñii tón toyo̱ó tón kísin ní kísa ta̱chi̱? Óꞌon, o̱n si̱ví saá. ");
INSERT INTO mim_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Án káꞌán ndó koto ndó ñii ta̱a ta̱ va̱ꞌa ní tiko̱to̱ ndíxin? Óꞌon, chi ni̱vi na va̱ꞌa ní tiko̱to̱ ndíxin ta kómí na ñakuíká, o̱n vása ndóo na yuku̱ yi̱chí, nayóꞌo ndóo na veꞌe náꞌno ña livi ní. ");
INSERT INTO mim_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Án ni̱xa̱ꞌa̱n ndó xi̱to ndó ñii ta̱profeta? Saá va, ta̱Juan kúu ñii ta̱profeta ndinoꞌo, ta káꞌno ní ka̱ chiño ki̱sa ndivi ta̱Juan no̱o̱ chiño ki̱sa ndivi inka̱ naprofeta na ni̱ka̱ꞌa̱n ndoso to̱ꞌon Ndios xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta kui̱ya̱ ni̱yaꞌa ñii ta̱profeta ni̱taa ra to̱ꞌon Ndios xa̱ꞌa̱ ta̱Juan, to̱ꞌon Ndios ña káchí saá: Ta̱yóꞌo kuu ta̱ xíka chiño no̱o̱ i̱, ta tiꞌví i̱ ra ko̱ꞌo̱n siꞌna ra no̱o̱ ta̱Káꞌno ta̱ tiꞌví i̱ ñoyívi. Ta ndasa va̱ꞌa ra yichi̱ ña ko̱ꞌo̱n ta̱Káꞌno ta̱ tiꞌví i̱ saka̱ku ni̱vi ñoyívi, saá ni̱ka̱ꞌa̱n Ndios xa̱ꞌa̱ ta̱Juan xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ta ni̱ka̱ꞌa̱n tuku ta̱Jesús xíꞌin na, káchí ra saá: ―Ñandixa káꞌa̱n i̱ xíꞌin ndó, o̱n ko̱ó inka̱ ta̱profeta káꞌno ka̱ no̱o̱ ta̱Juan, ta̱ sa̱kuchu ni̱vi. Ta saá ni, ta̱a ta̱ ni̱no̱ ní ka̱ yóo no̱o̱ ndiꞌi inka̱ ni̱vi na nákiꞌin yichi̱ ña xáꞌnda chiño Ndios, ta ta̱yóꞌo kúu ta̱ káꞌno ka̱ no̱o̱ ta̱Juan ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ta nañoo yóꞌo xíꞌin na káya si̱ꞌún xa̱ꞌa̱ nagobierno ñoo Roma xi̱ni̱ so̱ꞌo na to̱ꞌon yóꞌo, ta xáni si̱ni̱ na ndí ña chi̱tóni̱ Ndios ñanda̱a̱ kúu ña. Saá chi xa ni̱xa̱ꞌa̱n na no̱o̱ ta̱Juan ta sa̱kuchu ra na. ");
INSERT INTO mim_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ta nafariseo xíꞌin inka̱ namaestro na xíni̱ va̱ꞌa nda̱yí Ndios ña ni̱taa ta̱Moisés, ni̱‑xiin na nakiꞌin na ñava̱ꞌa ña chi̱tóni̱ Ndios xa̱ꞌa̱ na, chi ni̱‑xiin na taxi na sakuchu ta̱Juan na. ");
INSERT INTO mim_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ta saá ki̱xáꞌá káꞌa̱n ta̱Jesús xíꞌin ni̱vi: ―¿Ndasaá yóo ni̱vi na ndóo ñoyívi yóꞌo vitin? ");
INSERT INTO mim_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nda̱tán yóo naválí na sásíki no̱yáꞌvi, saá yóo na. Sava naválí káꞌa̱n na xíꞌin inka̱ naválí táꞌan na, káchí na saá: “Tá ti̱vi ndi̱ música livi xa̱ꞌa̱ ndó, ta ni̱‑xiin ndó kata xáꞌá ndó. Tá xi̱ta ndi̱ yaa ndáꞌya ní ña xíta na no̱o̱ ndúxu̱n na ni̱xiꞌi̱, ta ni̱‑xiin ndó kuaku ndó”, káchí naválí. ");
INSERT INTO mim_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nda̱tán yóo naválí yóꞌo, saá yóo ndó, chi ta̱Juan o̱n vása ní‑xixi va̱ꞌa ra, ta nda̱ ñii ki̱vi̱ o̱n vása ní‑xiꞌi ra vino, ta káchí ndó xa̱ꞌa̱ ra: “Ta̱yóꞌo kómí ra níma̱ ndiva̱ꞌa.” ");
INSERT INTO mim_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ki̱xaa̱ i̱ ñoyívi yóꞌo, ta xíxi va̱ꞌa i̱, ta xíꞌi i̱ vino, ta káchí ndó saá xa̱ꞌa̱ i̱: “Ta ndeé ní xíxi ra, ta kua̱ꞌa̱ ní xíꞌi ra. Ta kúsii̱ ní ini ra xíka ra xíꞌin na káya si̱ꞌún xa̱ꞌa̱ nagobierno, xíꞌin inka̱ ni̱vi na kánóo o̱n váꞌa to̱ꞌon xa̱ꞌa̱”, saá káchí ndó xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ta ndiꞌi ni̱vi na kómí ñandíchí Ndios, kúu na kéꞌé ñava̱ꞌa, ta ñayóꞌo sánáꞌa ndí ñandíchí Ndios kúu ñanda̱a̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ñii ta̱fariseo na̱ní Simón ka̱na ra ta̱Jesús ko̱ꞌo̱n ra veꞌe ra kuxu ra. Ta ta̱Jesús ke̱e ra kua̱ꞌa̱n ra, ta ni̱xaa̱ ra veꞌe ta̱fariseo yóꞌo, ta xi̱koo ra kuxu ra. ");
INSERT INTO mim_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ta ñii ñaꞌa̱, ñáñoo yóꞌo kúu ñá, ta kánóo o̱n váꞌa to̱ꞌon xa̱ꞌa̱ ñá, ta xi̱ni̱ so̱ꞌo ñá ndí ni̱xaa̱ ta̱Jesús veꞌe ta̱Simón. Ta ke̱e ñá kua̱ꞌa̱n ñá xíꞌin ñii yu̱yu̱ ña ku̱va̱ꞌa xíꞌin yu̱u̱ na̱ní alabastro, ta chútú ñayóꞌo xíꞌin nduta̱ tá xáꞌan támi, tá yáꞌví ní kúu rá. ");
INSERT INTO mim_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ta ni̱xaa̱ ñá, xi̱kuxítí ñá xa̱ꞌa̱ ta̱Jesús, ta xáku ñá, ta xíꞌin táno̱o̱ ñá, ki̱xáꞌá ñá nákata ñá xa̱ꞌa̱ ra, ta náyakón ñá xa̱ꞌa̱ ra xíꞌin yisi̱ si̱ni̱ ñá. Ta chi̱kaa̱ ñá ndiꞌi nduta̱ tá xáꞌan támi xa̱ꞌa̱ ra, ta chíto ñá xa̱ꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ta xi̱to ta̱fariseo ña kéꞌé ñá xíꞌin ta̱Jesús, ta ki̱xáꞌá ra xáni si̱ni̱ ra saá: “Tá ndixa ta̱profeta ndinoꞌo kúu ta̱yóꞌo, níkúu, ta kunda̱a̱ ini ra ndí ñaꞌa̱ yóꞌo ñá kánóo o̱n váꞌa to̱ꞌon xa̱ꞌa̱ kúu ñá”, xáni ini ta̱fariseo. ");
INSERT INTO mim_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra saá xíꞌin ra: ―Tata Simón, yóo ña kóni i̱ ka̱ꞌa̱n i̱ xíꞌin ún ―káchí ra. Ta nda̱kuii̱n ta̱Simón, káchí ra saá: ―Va̱ꞌa, ka̱ꞌa̱n ún xíꞌin i̱, Tata Maestro ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ta ta̱Jesús nda̱to̱ꞌon ra ñii cuento xíꞌin ra, ni̱ka̱ꞌa̱n ra káchí ra saá: ―Saá ndo̱ꞌo o̱vi̱ ta̱a ta̱ níká si̱ꞌún no̱o̱ ñii ta̱ sa̱tati si̱ꞌún. Ñii ta̱a níká ra o̱ꞌo̱n ciento si̱ꞌún denario, ta inka̱ ra níká o̱vi̱ si̱ko̱ u̱xu̱ si̱ꞌún denario. ");
INSERT INTO mim_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ta nda̱ ñii ra o̱n vása kómí ra si̱ꞌún chaꞌvi ra ña níká ra. Ta saá ta̱ sa̱tati si̱ꞌún ki̱sa káꞌno ini ra xa̱ꞌa̱ ndio̱vi̱ nayóꞌo, o̱n vása ka̱ níká na. Saá ndi̱ꞌi cuento loꞌo ―káchí ta̱Jesús. Ta ni̱nda̱ka̱ to̱ꞌon ra ta̱Simón: ―¿Yukía̱ xáni si̱ni̱ ún? ¿Yukú ñii ta̱ o̱vi̱ yóꞌo kukiꞌvi ka̱ ini ra koni ra ta̱ sa̱tati si̱ꞌún ra? ");
INSERT INTO mim_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ta nda̱kuii̱n ta̱Simón, káchí ra saá: ―Ta̱a ta̱ níká kua̱ꞌa̱ ní ka̱ si̱ꞌún kúu ta̱a ta̱ kukiꞌvi ka̱ ini koni ra ta̱ sa̱tati si̱ꞌún ra ―káchí ra. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱Simón: ―Ndixa káꞌa̱n ún ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ta ndi̱kó koo ra xíto ra no̱o̱ ñaꞌa̱, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Simón: ―¿Án xíto ún ñáyóꞌo? Chi ñáyóꞌo na̱kata ñá xa̱ꞌa̱ i̱ xíꞌin táno̱o̱ ñá, ta na̱yakón ñá xa̱ꞌa̱ i̱ xíꞌin yisi̱ si̱ni̱ ñá. Ta yóꞌó, tá ni̱ki̱ꞌvi i̱ veꞌe ún, ta o̱n vása ní‑taxi ún takuií nakata i̱ xa̱ꞌa̱ i̱, ");
INSERT INTO mim_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ta o̱n vása ní‑chindeé ún yi̱ꞌi̱ xíꞌin ña chíto ún no̱o̱ i̱. Ta ñáyóꞌo chíto ñá xa̱ꞌa̱ i̱, nda̱ ni̱ki̱ꞌvi i̱ veꞌe ún ta̱nda̱ vitin o̱n vása sándakoo ñá chíto ñá xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ta yóꞌó, o̱n vása ní‑chikaa̱ ún aceite si̱ni̱ i̱ ña kasa to̱ꞌó ún yi̱ꞌi̱. Ta ñáyóꞌo chi̱kaa̱ ñá nduta̱ tá xáꞌan támi xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ta vitin kóni i̱ ka̱ꞌa̱n i̱ xíꞌin ún: Vará kua̱ꞌa̱ ní kua̱chi xi̱komí ñáyóꞌo, ta ki̱sa káꞌno ini i̱ xa̱ꞌa̱ ndiꞌi ña. Kíꞌvi ní ini ñá xíni ñá yi̱ꞌi̱, saá chi xíni̱ ñá kua̱ꞌa̱ ní kua̱chi ñá ki̱sa káꞌno ini i̱ xa̱ꞌa̱. Ta inka̱ ni̱vi, na kómí loꞌo kua̱chi, ta kasa káꞌno ini i̱ xa̱ꞌa̱ ña, nayóꞌo loꞌo kuiti kukiꞌvi ini na koni na yi̱ꞌi̱ ―káchí ra xíꞌin ta̱Simón. ");
INSERT INTO mim_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ñáyóꞌo: ―Xa ki̱sa káꞌno ini i̱ xa̱ꞌa̱ kua̱chi ún, nana ―káchí ra xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ta inka̱ na ndóo no̱o̱ mesa, ki̱xáꞌá na káꞌa̱n táꞌan na, káchí na saá: ―¿Yu kúu ta̱yóꞌo, ta kísa káꞌno ini ra xa̱ꞌa̱ kua̱chi? Chi ñii la̱á Ndios kómí ra yichi̱ ña kasa káꞌno ini ra xa̱ꞌa̱ kua̱chi ni̱vi ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ñaꞌa̱: ―Xa̱ꞌa̱ ña kándixa ún yi̱ꞌi̱, Ndios sa̱ka̱ku ra yóꞌó. Ta vitin ná koo va̱ꞌa ini ún ta kua̱noꞌo̱ ún veꞌe ún ―káchí ra xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ta saá ke̱e ta̱Jesús, kua̱ꞌa̱n ra kua̱ꞌa̱ ní ñoo náꞌno xíꞌin ñoo válí, káꞌa̱n ndoso ra no̱o̱ ni̱vi to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ yichi̱ no̱o̱ xáꞌnda chiño Ndios. Ta xíꞌin ra kua̱ꞌa̱n u̱xu̱ o̱vi̱ naapóstol, ");
INSERT INTO mim_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","xíꞌin násíꞌí ná ndíko̱n sa̱ta̱ ra. Sava násíꞌí yóꞌo ndeé xi̱ndoꞌo ná kue̱ꞌe̱, ta ta̱Jesús sa̱ndaꞌa ra ná. Ta ta̱va ra níma̱ ndiva̱ꞌa xi̱komí inka̱ ná, ta ndu̱va̱ꞌa ná. Ñii ñáñaꞌa̱ yóꞌo na̱ní ñá María Magdalena, ta xi̱komí ñá u̱xa̱ níma̱ ndiva̱ꞌa, ta ta̱Jesús ta̱va ra ndiꞌi ña, ta ndu̱va̱ꞌa ñá. ");
INSERT INTO mim_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Inka̱ ñá na̱ní Juana, ñá kúu ñásíꞌí ta̱Chuza, ta̱a ta̱ ndíso chiño xíꞌin veꞌe káꞌno ta̱rey Herodes. Inka̱ ñá na̱ní Susana, ta kua̱ꞌa̱ ní ka̱ násíꞌí ndíko̱n sa̱ta̱ ta̱Jesús, ta chíndeé ná ra xíꞌin ña xíni̱ ñóꞌó ra ndaꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ta na̱kutáꞌan kua̱ꞌa̱ ní ni̱vi na ke̱e ñii ñii ñoo, kua̱ꞌa̱n na koni̱ so̱ꞌo na ña ka̱ꞌa̱n ta̱Jesús, ta ni̱ka̱ꞌa̱n ra xíꞌin na ñii cuento ña sanáꞌa ra na, ta káchí ra saá xíꞌin na: ");
INSERT INTO mim_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Saá ndo̱ꞌo ñii ta̱a ta̱ chíꞌi ndiki̱n trigo. Ta ki̱xáꞌá ra xíta níꞌnó ra ndiki̱n trigo ña chiꞌi ra no̱o̱ ñoꞌo̱. Ta sava ña ni̱ko̱yo yichi̱, ta ni̱vi xi̱ndo̱so̱ na ña, ta ki̱xaa̱ tísaa ta xa̱xi rí ña. ");
INSERT INTO mim_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sava ndiki̱n ni̱ko̱yo no̱o̱ yásín ní no̱o̱ ñoꞌo̱ sa̱ta̱ yu̱u̱, ta ndiki̱n yóꞌo kama ní ni̱ndu̱ta̱ ña, ta ni̱yi̱chi̱ ña, ta ndi̱ꞌi xa̱ꞌa̱ ña, chi o̱n vása yóo ko̱ꞌyo no̱o̱ ñoꞌo̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ta sava ña ni̱ko̱yo ma̱ꞌñó tón ñiño̱, ta ni̱ndu̱ta̱ ña, ta ni̱‑kuchiño kuaꞌno ña, saá chi xa̱ꞌno tón ñiño̱ yóꞌo, ta xa̱ꞌni nduta̱ nó ña. ");
INSERT INTO mim_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ta sava ndiki̱n ni̱ko̱yo no̱o̱ ñoꞌo̱ va̱ꞌa ña kuíkon. Ta ni̱ndu̱ta̱ ña, ta xa̱ꞌno ña, ta kua̱ꞌa̱ ní ni̱xi̱yo ndiki̱n yita yóꞌo, nda̱ sava yita ta̱xi ñii ciento ndiki̱n ―káchí ta̱Jesús xíꞌin na. Tá ndi̱ꞌi cuento yóꞌo, ta saá xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ndiꞌi ndóꞌó ni̱vi na yóo so̱ꞌo, xíni̱ ñóꞌó chikaa̱ so̱ꞌo ndó ña káꞌa̱n i̱ xíꞌin ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ta saá naxíka xíꞌin ta̱Jesús ni̱nda̱ka̱ to̱ꞌon na ra: ―¿Yukía̱ kóni kachí cuento yóꞌo? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta ndóꞌó, Ndios ta̱xi ra ña kúnda̱a̱ ini ndó to̱ꞌon ña ñóꞌo seꞌé ña yo̱ꞌvi̱ ní ña káꞌa̱n xa̱ꞌa̱ yichi̱ no̱o̱ xáꞌnda chiño ra. Ta inka̱ ni̱vi kuiti xíni̱ so̱ꞌo na cuento ña ndáto̱ꞌon i̱ xíꞌin na, ta o̱n vása kúnda̱a̱ va̱ꞌa ini na yukía̱ káchí ña. Ta saá ku̱ndivi to̱ꞌon Ndios ña káchí saá: “Vará xíto na, ta o̱n vása xíni̱ na ñanda̱a̱. Vará xíni̱ so̱ꞌo na, ta o̱n vása chíkaa̱ so̱ꞌo na, ni o̱n vása kúnda̱a̱ ini na ña ndáto̱ꞌon i̱”, káchí to̱ꞌon Ndios ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ta saá ni̱ka̱ꞌa̱n ka̱ ra xíꞌin naxíka xíꞌin ra: ―Vitin káꞌa̱n i̱ xíꞌin ndó yukía̱ káchí cuento yóꞌo xa̱ꞌa̱ ta̱ chíꞌi ndiki̱n trigo. Ndiki̱n ña chi̱ꞌi ta̱a ndáto̱ꞌon ña xa̱ꞌa̱ to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ndiki̱n ña ni̱ko̱yo yichi̱ ndáto̱ꞌon ña xa̱ꞌa̱ ni̱vi na xíni̱ so̱ꞌo to̱ꞌon Ndios, ta saá va̱xi ñandiva̱ꞌa káꞌno, ta táva ña to̱ꞌon Ndios ña xi̱ni̱ so̱ꞌo na, ko̱to̱ kandixa na Ndios ta saka̱ku ra na. ");
INSERT INTO mim_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ta ndiki̱n ña ni̱ko̱yo no̱o̱ yu̱u̱ ndáto̱ꞌon ña xa̱ꞌa̱ ni̱vi na xíni̱ so̱ꞌo to̱ꞌon Ndios, ta xa̱ndi̱ko̱n nákiꞌin va̱ꞌa na ña, ta kúsii̱ ní ini na. Ta yáꞌa ñii káni̱ loꞌo, tá kíxáꞌá va̱xi ña xóꞌvi̱ na án ña xíto ndoso ñaꞌá, ta nayóꞌo sándakoo na yichi̱ Ndios, ta o̱n xi̱in ka̱ na kandixa na, saá chi o̱n ta̱ꞌán chikaa̱ va̱ꞌa ini na to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ta ndiki̱n ña ni̱ko̱yo no̱o̱ tón ñiño̱ ndáto̱ꞌon ña xa̱ꞌa̱ ni̱vi na xíni̱ so̱ꞌo to̱ꞌon Ndios. Ta saá chiño yóo ñoyívi yóꞌo sándiꞌi ní ña ini na, ta kíxáꞌá na kísa chiño na ña kukomí na kua̱ꞌa̱ ní ñakuíká ñoyívi yóꞌo, ta chíkaa̱ ní ini na kasa ndivi na ña kúsii̱ ini mi̱i na, ta saá o̱n xi̱in ka̱ na kutaku̱ na nda̱tán káꞌa̱n to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ta ndiki̱n ña ni̱ko̱yo ñoꞌo̱ va̱ꞌa ña kuíkon ndáto̱ꞌon ña xa̱ꞌa̱ ni̱vi na kúu na ndinoꞌo ini nákiꞌin to̱ꞌon Ndios. Saá chi ni̱vi yóꞌo xíni̱ so̱ꞌo na to̱ꞌon Ndios, ta kándixa na ña. Ta nayóꞌo o̱n vása sándakoo na yichi̱ Ndios, ta kúndeé na nduu na ni̱vi na va̱ꞌa ini, na keꞌé kua̱ꞌa̱ ní ñava̱ꞌa no̱o̱ Ndios. Nda̱tán yóo yita trigo ña táxi kua̱ꞌa̱ ní ndiki̱n, saá yóo ni̱vi na va̱ꞌa yóꞌo ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ta saá ni̱ka̱ꞌa̱n ka̱ ta̱Jesús, káchí ra saá: ―Tá nátoo̱n yó ñii ñoꞌo̱, ta o̱n chikaa̱ seꞌé yó ña ti̱xin ñii yaxi̱n án ti̱xin xi̱to. O̱n vása kéꞌé yó saá, ta va̱ꞌa ka̱ chinóo yó ña no̱o̱ síkón ña va̱ꞌa nayeꞌe ña, ta ndiꞌi ni̱vi na ki̱ꞌvi veꞌe kuchiño koto na ña. ");
INSERT INTO mim_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kúnda̱a̱ ini yó ndí ndiꞌi ña yóo seꞌé vitin, ñii ki̱vi̱ ña va̱xi nati̱vi ndiꞌi ña, ña koni̱ ndiꞌi ni̱vi ña, ta kunda̱a̱ ini na xa̱ꞌa̱ ña. ");
INSERT INTO mim_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Ta xíni̱ ñóꞌó kundaa xíꞌin mi̱i ndó ña koni̱ so̱ꞌo va̱ꞌa ndó. Saá chi ni̱vi na kúnda̱a̱ ini ñanda̱a̱ vitin, ta ki̱vi̱ ña va̱xi kunda̱a̱ ka̱ ini na. Ta ni̱vi na o̱n xi̱in kunda̱a̱ ini ñanda̱a̱ vitin, ta ki̱vi̱ ña va̱xi Ndios kindaa ndiꞌi ra ñaloꞌo kúnda̱a̱ ini na. ");
INSERT INTO mim_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ñii ki̱vi̱ ki̱xaa̱ siꞌí ta̱Jesús xíꞌin nañani ra, ta ni̱‑kuchiño na to̱nda̱a na no̱o̱ ra, chi chútú ní ni̱vi veꞌe yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ta ñii ta̱a nda̱to̱ꞌon ra xíꞌin ta̱Jesús, káchí ra saá: ―Tata, siꞌí ún xíꞌin nañani ún yíta na ke̱ꞌe, ta kóni na ka̱ꞌa̱n na xíꞌin ún ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Ni̱vi na xíni̱ so̱ꞌo to̱ꞌon Ndios ta kísa ndivi na ña, nayóꞌo kúu nañani i̱ xíꞌin siꞌí i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ñii ki̱vi̱ ta̱Jesús ni̱ki̱ꞌvi ra ini tón barco xíꞌin naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ná koꞌyo̱ inka̱ xiiña no̱o̱ mi̱ni ―káchí ra. Ta ke̱e na kua̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ta kua̱ꞌa̱n tón barco no̱o̱ takuií, ta ta̱Jesús xi̱kandúꞌu̱ ra ni̱ki̱si̱n ra. Ta ki̱xáꞌá ndeé ní káni ta̱chi̱ naꞌá no̱o̱ takuií, ta takuií ki̱xáꞌá rá nákutú rá ini tón barco, ta tón yóꞌo kóni ke̱tá nó ini takuií. ");
INSERT INTO mim_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Saá nata̱a naxíka xíꞌin ta̱Jesús sa̱nakáxín na ini ra, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―¡Maestro! ¡Maestro! ¡Yi̱yo ní ka̱ꞌa̱ ndiꞌi yó xíꞌin takuií mi̱ni! ―káchí na xíꞌin ra. Ta nda̱koo ta̱Jesús, ta xa̱ꞌnda chiño ra no̱o̱ ta̱chi̱ naꞌá xíꞌin takuií mi̱ni. Ta saá ku̱tásin ta̱chi̱ naꞌá xíꞌin takuií mi̱ni, ñii ya̱a̱ ya̱a̱ ku̱u. ");
INSERT INTO mim_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ta ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra: ―¿Nda̱chun o̱n vása kándixa ndó Ndios ndáa ra yó? ―káchí ra. Ta nayóꞌo yíꞌví ní na, ta na̱kaꞌnda ní ini na ndóo na, ta ni̱nda̱ka̱ to̱ꞌon táꞌan na: ―¿Yu kúu ta̱yóꞌo? Chi xáꞌnda chiño ra no̱o̱ ta̱chi̱ naꞌá xíꞌin takuií mi̱ni, ta xíni̱ so̱ꞌo ña to̱ꞌon káꞌa̱n ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ni̱xaa̱ barco inka̱ táꞌví yuꞌu̱ mi̱ni no̱o̱ ndóo nañoo Gadara. ");
INSERT INTO mim_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tá no̱o ta̱Jesús tón barco, ta na̱kutáꞌan ra xíꞌin ñii ta̱ñoo Gadara, ta ta̱yóꞌo kómí ra níma̱ ndiva̱ꞌa. Xa kua̱ꞌa̱ ní kui̱ya̱ xíka yálá ra, ta o̱n xi̱in ra koo ra veꞌe ra, ta táku̱ ra kavua̱ no̱o̱ ndúxu̱n na ni̱xiꞌi̱. ");
INSERT INTO mim_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tá xi̱ni ra ta̱Jesús, ta ni̱xaa̱ ra xi̱kuxítí ra no̱o̱ ta̱Jesús, ta xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra: ―¿Yukía̱ kóni ún keꞌé ún xíꞌin i̱? Chi yóꞌó ta̱Jesús kúu Sa̱ꞌya Ndios ta̱Káꞌno. Ta xáku ndáꞌví i̱ no̱o̱ ún ndí o̱n saxo̱ꞌvi̱ ún yi̱ꞌi̱ ―káchí ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ni̱ka̱ꞌa̱n ra siꞌa, saá chi ta̱Jesús xa ki̱xáꞌá ra táva ra níma̱ ndiva̱ꞌa, káchí ra saá: ―¡Níma̱ ndiva̱ꞌa, kee ún ta saña ún ta̱yóꞌo! ―káchí ta̱Jesús. Ki̱vi̱ ni̱yaꞌa, níma̱ ndiva̱ꞌa kua̱ꞌa̱ ní yichi̱ ti̱in ña ta̱yóꞌo. Vará inka̱ ni̱vi xi̱ndaa na ra, ta xíꞌin cadena ka̱a kua̱ꞌa̱ ní yichi̱ chi̱katón na ndaꞌa̱ ra, chi̱katón na xa̱ꞌa̱ ra, ta ni̱‑kuchiño ña, ta ña na̱kundeé ra kama cha̱chi cadena ka̱a yóꞌo, xíꞌin ndee̱ ñaníma̱ ndiva̱ꞌa xi̱komí ta̱yóꞌo. Ta ñandiva̱ꞌa ki̱sa ndu̱xa̱ ña xíꞌin ra kua̱ꞌa̱n ra yóo ra no̱o̱ yuku̱ yi̱chí. ");
INSERT INTO mim_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ta saá ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra ta̱yóꞌo, ni̱ka̱ꞌa̱n ra saá: ―¿Ndasaá na̱ní ún? Ta nda̱kuii̱n ra: ―Na̱ní ndi̱ Legión. Ni̱ka̱ꞌa̱n ra saá chi kua̱ꞌa̱ ní kúu níma̱ ndiva̱ꞌa kómí ra. ");
INSERT INTO mim_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ta xáku ndáꞌví níma̱ ndiva̱ꞌa no̱o̱ ta̱Jesús, ña o̱n tiꞌví ra ndiꞌi ña ko̱ꞌo̱n ña yavi̱ ña kónó ní ña o̱n vása ndiꞌi kónó. ");
INSERT INTO mim_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ta yatin yóo ñii yuku̱, xíka kua̱ꞌa̱ ní kini̱ xíxaꞌan rí. Ta ndiꞌi níma̱ ndiva̱ꞌa xa̱ku ndáꞌví ña no̱o̱ ta̱Jesús, káchí ña saá: ―Tiꞌví ún ndi̱ꞌi̱ ko̱ꞌo̱n ndi̱ ki̱ꞌvi ndi̱ ini ndiꞌi tíkini̱ kaa̱ ―káchí ña. Ta ta̱Jesús ta̱xi ra ña ndu̱kú níma̱ ndiva̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ta saá ke̱e ndiꞌi níma̱ ndiva̱ꞌa ña xi̱komí ta̱yóꞌo, ta ni̱ki̱ꞌvi ña ini ndiꞌi tíkini̱. Ta ndiꞌi tíkini̱ xíno rí kua̱ꞌa̱n rí, ta sa̱ko̱yo xíꞌin mi̱i rí taꞌvi̱, no̱o̱ ni̱ko̱yo rí ini mi̱ni, ta ni̱ka̱ꞌa̱ ndiꞌi rí ta ni̱xiꞌi̱ ndiꞌi rí. ");
INSERT INTO mim_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ta ni̱vi na ndáa kini̱ xi̱ni na ñayóꞌo, ta xíno na kua̱ꞌa̱n na ndato̱ꞌon na xíꞌin na ndóo ñoo xíꞌin na ndóo yuku̱, ña ndo̱ꞌo kini̱ sa̱na̱ na. ");
INSERT INTO mim_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ta saá ki̱xaa̱ ni̱vi xíto na yukía̱ ndo̱ꞌo tíkini̱ ta yukía̱ ndo̱ꞌo ta̱a ta̱ xi̱komí níma̱ ndiva̱ꞌa. Ta ki̱xaa̱ ni̱vi yóꞌo no̱o̱ yóo ta̱Jesús, ta xi̱ni na ta̱ xi̱komí kua̱ꞌa̱ ní níma̱ ndiva̱ꞌa, yóo ra yatin xa̱ꞌa̱ ta̱Jesús, ta xa ndíxin ra tiko̱to̱, ta xa na̱koo va̱ꞌa si̱ni̱ ra. Ta nani̱vi yóꞌo ni̱yi̱ꞌví ní na. ");
INSERT INTO mim_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ta inka̱ ni̱vi na xi̱ni ndasaá ndu̱va̱ꞌa ta̱ xi̱komí níma̱ ndiva̱ꞌa nda̱to̱ꞌon na xa̱ꞌa̱ ña ke̱ꞌé ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ta ndiꞌi na ndóo ñoo Gadara yóꞌo ki̱xáꞌá na xáku ndáꞌví na no̱o̱ ta̱Jesús ña kee ra ko̱ꞌo̱n ra inka̱ ñoo. Saá chi yíꞌví ní na. Ta nda̱a ta̱Jesús ini tón barco xíꞌin naxíka xíꞌin ra ta kua̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ta ki̱vi̱ nda̱a ta̱Jesús ini tón barco, ta ta̱ xi̱komí níma̱ ndiva̱ꞌa xa̱ku ndáꞌví ra no̱o̱ ra: ―Taxi ún ná ko̱ꞌo̱n i̱ xíꞌin ún ―káchí ra. Ta ta̱Jesús ni̱‑xiin ra taxi ra ko̱ꞌo̱n ra, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱yóꞌo: ");
INSERT INTO mim_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Noꞌo̱ ún veꞌe ún vitin, ta ndato̱ꞌon ún xíꞌin natáꞌan ún xa̱ꞌa̱ ñakáꞌno ní ke̱ꞌé Ndios xíꞌin ún ―káchí ta̱Jesús. Ta saá ke̱e ta̱yóꞌo kua̱noꞌo̱ ra, ta ki̱xáꞌá ra ndáto̱ꞌon ra xíꞌin ndiꞌi nañoo ra yu kúu ñava̱ꞌa ke̱ꞌé ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tá tuku ndi̱kó ta̱Jesús xíꞌin tón barco, ta na̱xaa̱ ra nda̱ yuꞌu̱ mi̱ni no̱o̱ ke̱e ra kua̱ꞌa̱n ra, ta kua̱ꞌa̱ ní ni̱vi kúsii̱ ní ini na na̱kutáꞌan na xíꞌin ra, chi ndáti na ndikó ra. ");
INSERT INTO mim_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ta ki̱xaa̱ ñii ta̱ xáꞌnda chiño xíꞌin veꞌe ño̱ꞌo sinagoga, na̱ní ra Jairo. Tá xi̱ni ra ta̱Jesús, ta xi̱kuxítí ra no̱o̱ ra, ta ndeé ní xa̱ku ndáꞌví ra no̱o̱ ra ña ko̱ꞌo̱n ra xíꞌin ra veꞌe ra. ");
INSERT INTO mim_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Saá chi ñii la̱á kuiti ñáloꞌo kúu sa̱ꞌya ta̱Jairo, ta kómí ñá u̱xu̱ o̱vi̱ kui̱ya̱, ta ndeé ní ndóꞌo ñá, xa ña yóo kivi̱ kúu ñá. Ta ke̱e ta̱Jesús kua̱ꞌa̱n ra xíꞌin ta̱Jairo veꞌe ra. Ta kua̱ꞌa̱ ní ni̱vi ndíko̱n na sa̱ta̱ ra nda̱ ñii chíndaꞌá na ra. ");
INSERT INTO mim_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ta yóo ñii ñaꞌa̱ kua̱ꞌa̱n ñá xíꞌin ni̱vi na kua̱ꞌa̱n sa̱ta̱ ta̱Jesús, ta xa u̱xu̱ o̱vi̱ kui̱ya̱ ndeé ní ndóꞌo ñá kue̱ꞌe̱ xíta̱ ni̱i̱. Ta xa ni̱xa̱ꞌa̱n ñá no̱o̱ kua̱ꞌa̱ ní ndotor, ta sa̱ndiꞌi ñá si̱ꞌún ñá. Ta o̱n vása ní‑kuchiño nduva̱ꞌa ñá. ");
INSERT INTO mim_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ta vitin va̱xi ñá sa̱ta̱ ta̱Jesús, ta ni̱to̱nda̱a ndaꞌa̱ ñá yuꞌu̱ tiko̱to̱ ra, ta saá xa̱ndi̱ko̱n ni̱ya̱a̱ xíta̱ ni̱i̱ ñá, ta nda̱ꞌa ñá. ");
INSERT INTO mim_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ta ni̱ka̱ꞌa̱n ta̱Jesús: ―¿Yukú ndó ni̱to̱nda̱a ndaꞌa̱ yi̱ꞌi̱? ―káchí ra. Ta ndiꞌi ni̱vi káꞌa̱n na: ―O̱n si̱ví yi̱ꞌi̱ ni̱to̱nda̱a ndaꞌa̱ yóꞌó ―káchí na. Ta ta̱Pedro xíꞌin inka̱ naxíka xíꞌin ta̱Jesús ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tata Maestro, yóo kua̱ꞌa̱ ní ni̱vi ta ñii chíndaꞌá táꞌan na, ta chíndaꞌá na yóꞌó, ta ndáka̱ to̱ꞌon ún: ¿Yukú ndó ni̱to̱nda̱a ndaꞌa̱ tiko̱to̱ i̱?, káchí ún ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ta nda̱kuii̱n ta̱Jesús, káꞌa̱n ra: ―Xíni̱ i̱ ndí ñii ni̱vi ni̱to̱nda̱a yi̱ꞌi̱, chi kúnda̱a̱ ini i̱ ke̱e loꞌo ndee̱ i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ta saá ku̱nda̱a̱ ini ñáñaꞌa̱ yóꞌo ndí o̱n kúchiño koo seꞌé ka̱ ñá, ta ki̱xáꞌá yíꞌví ñá nda̱ kísin ñá, ta ki̱xaa̱ ñá xi̱kuxítí ñá no̱o̱ ta̱Jesús. Ta no̱o̱ ndiꞌi ni̱vi, ki̱xáꞌá ñá nda̱to̱ꞌon ñá nda̱chun ni̱to̱nda̱a ndaꞌa̱ ñá tiko̱to̱ ra, ta xa̱ndi̱ko̱n ndu̱va̱ꞌa ñá. ");
INSERT INTO mim_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ñá: ―Nana, xa ndu̱va̱ꞌa ún chi kándixa ini ún yi̱ꞌi̱. Ta vitin noꞌo̱ ún, ta ná koo va̱ꞌa ini ún. ");
INSERT INTO mim_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tá káꞌa̱n ka̱ ta̱Jesús xíꞌin ñáyóꞌo, ta saá ki̱xaa̱ ni̱vi na ke̱e veꞌe ta̱Jairo, ta ni̱ka̱ꞌa̱n na xíꞌin ta̱Jairo: ―Sa̱ꞌya ún xa ni̱xiꞌi̱ ñá. ¿Nda̱chun sándiꞌi ka̱ ún ta̱Maestro yóꞌo? ");
INSERT INTO mim_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ta xi̱ni̱ so̱ꞌo ta̱Jesús ña ni̱ka̱ꞌa̱n na, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jairo: ―O̱n kuyi̱ꞌví ún. Kundaa va̱ꞌa ini ún yi̱ꞌi̱, ta nduva̱ꞌa sa̱ꞌya ún ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ta ni̱xaa̱ ta̱Jesús veꞌe ta̱Jairo, ta ni̱‑xiin ra kundiko̱n ni̱vi sa̱ta̱ ra, kuiti ta̱xi ra ko̱ꞌo̱n u̱ni̱ naxíka xíꞌin ra na kúu ta̱Pedro, ta̱Jacobo, xíꞌin ta̱Juan. Ta ta̱xi ra nda̱yí ña ki̱ꞌvi yivá ñáloꞌo xíꞌin siꞌí ñá ini veꞌe xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ta ndóo kua̱ꞌa̱ ní ni̱vi xáku ní na chi kúchuchú ní ini na xa̱ꞌa̱ ñáloꞌo ñá ni̱xiꞌi̱. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―O̱n kuaku ndó, chi ñáloꞌo yóꞌo o̱n vása ní‑xiꞌi̱ ñá, ñá kísi̱n kuiti kúu ñá ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ta saá ku̱siki na ta̱Jesús ta ni̱xaku̱ ndaa na ra, chi xi̱ni̱ na ndí ni̱xiꞌi̱ va̱ꞌa ñá. ");
INSERT INTO mim_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ta ta̱Jesús ti̱in ra ndaꞌa̱ ñáloꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ñá: ―Ñáloꞌo, káꞌa̱n i̱ xíꞌin ún, ¡ndakoo ún! ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ta saá na̱taku̱ ñá, ta xa̱ndi̱ko̱n nda̱koo ñá. Ta ni̱ka̱ꞌa̱n ta̱Jesús: ―Taxi ndó ña̱ꞌa ná kuxu ñá ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ta yivá ñá xíꞌin siꞌí ñá na̱kaꞌnda ini na ndóo na, ta ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ na, káchí ra saá: ―O̱n ndato̱ꞌon ndó xíꞌin nda̱ ñii ni̱vi xa̱ꞌa̱ ña na̱taku̱ sa̱ꞌya ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ñii ki̱vi̱ ta̱Jesús ka̱na ra u̱xu̱ o̱vi̱ naxíka xíꞌin ra, ta ki̱xaa̱ na no̱o̱ ra, ta ta̱xi ra ndee̱ xíꞌin nda̱yí ndaꞌa̱ na ña tava na níma̱ ndiva̱ꞌa ña sáxo̱ꞌvi̱ inka̱ ni̱vi, ta ta̱xi ra ndee̱ xíꞌin nda̱yí ndaꞌa̱ na ña sandaꞌa na ndiꞌi no̱o̱ kue̱ꞌe̱. ");
INSERT INTO mim_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ta ti̱ꞌví ra na ko̱ꞌo̱n na ka̱ꞌa̱n ndoso na xa̱ꞌa̱ yichi̱ ña xáꞌnda chiño Ndios, ta sandaꞌa na ni̱vi na ndeé ndóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―Tá kua̱ꞌa̱n ndó chiño yóꞌo, ta nda̱ ñii ña̱ꞌa o̱n kuniꞌi ndó ko̱ꞌo̱n ndó: o̱n kuniꞌi ndó yito̱n, ni leká ndó, ni ña kuxu ndó, ni si̱ꞌún ndó, ni inka̱ tiko̱to̱ ndó. ");
INSERT INTO mim_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tá ni̱xaa̱ ndó inka̱ ñoo, ta veꞌe no̱o̱ nakiꞌin va̱ꞌa na ndóꞌó, kundo̱o ndó nda̱ to̱nda̱a ki̱vi̱ kee ndó ñoo nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tá yóo ñii ñoo no̱o̱ o̱n xi̱in ni̱vi nakiꞌin va̱ꞌa na ndóꞌó, ta saá kee ndó ñoo yóꞌo ta ko̱ꞌo̱n ndó, ta sakisin ndó xa̱ꞌa̱ ndó ña nako̱yo yaa̱. Saá sanáꞌa káxín ndó ndí nayóꞌo nákuiso na kua̱chi no̱o̱ Ndios, chi o̱n xi̱in na koni̱ so̱ꞌo na to̱ꞌon ra ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ta saá ke̱e naxíka xíꞌin ta̱Jesús, ta kua̱ꞌa̱n na ndiꞌi ñoo, ta káꞌa̱n na xíꞌin ni̱vi to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ yichi̱ Ndios, ta sa̱ndaꞌa na ni̱vi na ndeé ndóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ta ta̱rey Herodes, xi̱ni̱ so̱ꞌo ra xa̱ꞌa̱ ndiꞌi ñava̱ꞌa ña ke̱ꞌé ta̱Jesús, ta o̱n vása xíni̱ ra yukía̱ kúu to̱ꞌon ña ndixa xa̱ꞌa̱ ta̱Jesús. Saá chi sava ni̱vi káꞌa̱n na siꞌa: ―Ta̱Jesús kúu ta̱Juan, ta̱ sa̱kuchu ni̱vi, ta ni̱xiꞌi̱ ra ta vitin na̱taku̱ ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ta inka̱ na káꞌa̱n: ―Ta̱profeta Elías, ta̱a ta̱ ni̱ka̱ꞌa̱n ndoso to̱ꞌon Ndios xi̱na̱ꞌá, vitin ki̱xaa̱ tuku ra ñoyívi yóꞌo ―káchí na. Ta inka̱ na káꞌa̱n: ―Ta̱Jesús kúu inka̱ ta̱profeta ta̱ xi̱taku̱ xi̱na̱ꞌá, ta vitin na̱taku̱ ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ta ta̱rey Herodes ni̱ka̱ꞌa̱n ra: ―Yi̱ꞌi̱ kúu ta̱ xa̱ꞌnda chiño ña kandoso na si̱ko̱n ta̱Juan. ¿Ta yu kúu ta̱yóꞌo ta̱ káꞌa̱n na xa̱ꞌa̱ vitin? ―káchí ra. Ta ki̱xáꞌá ra ndúkú ra ndasaá kuchiño koni ra ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ta ndi̱kó u̱xu̱ o̱vi̱ naapóstol na ti̱ꞌví ta̱Jesús, ta na̱xaa̱ na no̱o̱ ra, ta nda̱to̱ꞌon na xíꞌin ra ndiꞌi ña ke̱ꞌé na. Ta saá ta̱Jesús ka̱na ra nayóꞌo ña ko̱ꞌo̱n na xíꞌin ra inka̱ xiiña no̱o̱ o̱n ko̱ó ni̱vi, ta ni̱xaa̱ na yatin ñoo Betsaida. ");
INSERT INTO mim_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ta saá ni̱vi xi̱ni̱ so̱ꞌo na míchí kua̱ꞌa̱n ta̱Jesús, ta ke̱e na kua̱ꞌa̱n na sa̱ta̱ ra. Ta ki̱xaa̱ na no̱o̱ ra, ta ta̱Jesús na̱kiꞌin va̱ꞌa ra na. Sánáꞌa ra na xa̱ꞌa̱ yichi̱ ña xáꞌnda chiño Ndios, ta sa̱ndaꞌa ra ni̱vi na ndeé ndóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ta xa ni̱kuaa ní kúu ña, ta saá ni̱to̱nda̱a yatin na u̱xu̱ o̱vi̱ xíka xíꞌin ta̱Jesús, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tata, va̱ꞌa tiꞌví ún ndiꞌi ni̱vi yóꞌo ná ko̱ꞌo̱n na rancho án ñoo válí ña yóo yatin, ta nandukú na no̱o̱ ku̱su̱n na ñoó vitin, ta sata na ña kuxu na, chi no̱o̱ ndóo yó vi̱chí ní yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra: ―Mi̱i ndó taxi kuxu na ―káchí ra. Ta ni̱ka̱ꞌa̱n na saá: ―O̱n ko̱ó kua̱ꞌa̱ ñaxíxi. Yóo kuiti o̱ꞌo̱n si̱ta̱ va̱ꞌa ta o̱vi̱ kúu tia̱ká. ¿Án kóni ún ko̱ꞌo̱n ndi̱ ñoo sata ndi̱ ña kuxu ndiꞌi ni̱vi yóꞌo? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chi yóo kua̱ꞌa̱ ní ni̱vi, nda̱ o̱ꞌo̱n mil ta̱a ndóo. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra: ―Nataꞌví ndó ni̱vi ñii tiꞌvi ñii tiꞌvi kundo̱o na, ta o̱vi̱ si̱ko̱ u̱xu̱ ni̱vi kúu ñii ñii tiꞌvi ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ta ni̱ka̱ꞌa̱n na xíꞌin ni̱vi, ta xi̱kundo̱o ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ta saá ki̱ꞌin ta̱Jesús o̱ꞌo̱n si̱ta̱ va̱ꞌa xíꞌin o̱vi̱ tia̱ká, ta xi̱to ndaa ra ñoyívi ni̱no, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Tata Yivá yó Ndios, táxaꞌvi ñaꞌá ún ta̱xi ún ñaxíxi. Ta ta̱ꞌví ra si̱ta̱ va̱ꞌa, ta ta̱xi ra ña ndaꞌa̱ naxíka xíꞌin ra, ta nayóꞌo na̱taxi na ña ndaꞌa̱ ndiꞌi ni̱vi na ndóo yóꞌo. Ta ta̱ꞌví ra o̱vi̱ tia̱ká ta na̱taxi na rí ndaꞌa̱ ndiꞌi ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ta na̱ni ña xi̱xi ndiꞌi ni̱vi nda̱ ni̱xaa ini na. Tá ndi̱ꞌi xi̱xi na, ta naxíka xíꞌin ta̱Jesús na̱kiꞌin na u̱xu̱ o̱vi̱ chikiva si̱ta̱ va̱ꞌa xíꞌin tia̱ká ña ki̱ndo̱o ndoso, chi ni̱‑kundeé nani̱vi kuxu ndiꞌi na ña. ");
INSERT INTO mim_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ta saá ñii ki̱vi̱ ta̱Jesús káꞌa̱n matóꞌón ra xíꞌin Ndios, ta ndasaá kuiti naxíka xíꞌin ra yóo na xíꞌin ra. Tá ndi̱ꞌi ni̱ka̱ꞌa̱n ta̱Jesús, ta ni̱nda̱ka̱ to̱ꞌon ra na: ―¿Yukía̱ káchí ni̱vi xa̱ꞌa̱ i̱ yu kúu i̱? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ta nda̱kuii̱n na, káchí na saá: ―Sava ni̱vi káꞌa̱n yóꞌó kúu ún ta̱Juan, ta̱ sa̱kuchu ni̱vi. Sava na káꞌa̱n yóꞌó kúu ún ta̱profeta Elías, ta inka̱ na káꞌa̱n yóꞌó kúu ún inka̱ ta̱profeta ta̱ xi̱taku̱ xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra na: ―Ta mi̱i ndó, ¿yukía̱ káchí ndó yu kúu i̱? Ta nda̱kuii̱n ta̱Pedro, ni̱ka̱ꞌa̱n ra: ―Yóꞌó kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ni̱vi ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta o̱n ka̱ꞌa̱n ndó xíꞌin nda̱ ñii ni̱vi yu kúu i̱. ");
INSERT INTO mim_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ta ta̱Jesús ni̱ka̱ꞌa̱n ka̱ ra xíꞌin naxíka xíꞌin ra, káchí ra siꞌa: ―Yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ki̱vi̱ va̱xi naxi̱kua̱ꞌa̱ no̱o̱ najudío, xíꞌin na sánáꞌa nda̱yí Ndios xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ o̱n kuaꞌa na kandixa na yi̱ꞌi̱ ta saxo̱ꞌvi̱ ní na yi̱ꞌi̱. Ta kaꞌni na yi̱ꞌi̱, ta ki̱vi̱ u̱ni̱ nataku̱ i̱, saá keꞌé Ndios. ");
INSERT INTO mim_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tá ndi̱ꞌi ni̱ka̱ꞌa̱n ra ñayóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ndiꞌi ni̱vi na ndóo yatin: ―Ndiꞌi ni̱vi na kóni kundiko̱n yi̱ꞌi̱ xíni̱ ñóꞌó sandakoo na ndiꞌi ña káchí ini mi̱i na, ta ñii ñii ki̱vi̱ kuso̱kó na tón cruz mi̱i na ta kundiko̱n na sa̱ta̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ndiꞌi ni̱vi na ndasaá kuiti ndúkú ña kutaku̱ va̱ꞌa na ñoyívi yóꞌo, ta o̱n xi̱in na xo̱ꞌvi̱ na xa̱ꞌa̱ i̱, ta nayóꞌo o̱n kuchiño na kutaku̱ na xíꞌin Ndios. Ta ni̱vi na o̱n vása ndíꞌi ini ndukú kutaku̱ va̱ꞌa na ñoyívi yóꞌo, xa̱ꞌa̱ ña kundiko̱n na yi̱ꞌi̱, nayóꞌo kúu ni̱vi na kutaku̱ xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tá kómí ni̱vi ndiꞌi ñakuíká ñoyívi yóꞌo, ta o̱n vása táku̱ ndinoꞌo na no̱o̱ Ndios, ta nda̱ ma̱ni̱ kúu ña. ");
INSERT INTO mim_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ta ni̱vi na kúkaꞌan no̱o̱ xa̱ꞌa̱ yi̱ꞌi̱, ta kúkaꞌan no̱o̱ na xa̱ꞌa̱ to̱ꞌon i̱ no̱o̱ inka̱ ni̱vi, ta saá yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, kukaꞌan no̱o̱ i̱ xa̱ꞌa̱ nayóꞌo no̱o̱ Ndios ki̱vi̱ ña ndikó i̱ ñoyívi yóꞌo xíꞌin ndiꞌi ndee̱ ña va̱ꞌa ña yéꞌe ña kómí Yivá i̱ Ndios xíꞌin naángel yi̱i̱, na kixaa̱ xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ndixa káꞌa̱n i̱ xíꞌin ndó, sava ndóꞌó na ndóo vitin, kutaku̱ ka̱ ndó ña kivi koni ndó ñava̱ꞌa káꞌno no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ni̱yaꞌa yatin o̱na̱ ki̱vi̱, ta na̱ka̱xin ta̱Jesús u̱ni̱ ta̱xíka xíꞌin ra, ta̱Pedro, ta̱Jacobo xíꞌin ta̱Juan, ta kua̱ꞌa̱n na xíꞌin ra ñii yuku̱ síkón, ña ka̱ꞌa̱n ra xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tá mií káꞌa̱n ra xíꞌin Ndios, ta na̱sama no̱o̱ ta̱Jesús, ta nátaxa tiko̱to̱ ra, ndu̱yaa ní ña. ");
INSERT INTO mim_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ta saá ni̱ti̱vi ta̱Moisés xíꞌin ta̱Elías, ndáto̱ꞌon na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ta ñii káꞌno ña náyeꞌe, ta xi̱no nduu ndiꞌi ña no̱o̱ yíta na káꞌa̱n xíꞌin ta̱Jesús. Ni̱ka̱ꞌa̱n na ndasaá koo kee ra ñoyívi yóꞌo, chi xa yatin to̱nda̱a ki̱vi̱ ña nakuita nani̱vi ñoo Jerusalén ta kaꞌni na ra. ");
INSERT INTO mim_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Vará ta̱Pedro xíꞌin inka̱ o̱vi̱ natáꞌan ra kóni ní na ku̱su̱n na, ta saá ni, ku̱chiño na xi̱ndito na, ta xi̱ni na ñakáꞌno náyeꞌe, ta xi̱no nduu ña ta̱Jesús xíꞌin o̱vi̱ ta̱a na yóo xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tá xa yatin ko̱ꞌo̱n na o̱vi̱ yóꞌo, ta ni̱ka̱ꞌa̱n ta̱Pedro xíꞌin ta̱Jesús: ―Tata Maestro, va̱ꞌa ní ndóo yó yóꞌo. Tá kóni ún, ta kasa va̱ꞌa ndi̱ u̱ni̱ tia̱ꞌva, ñii ña koo mi̱i ún, ñii ña koo ta̱Moisés, ta inka̱ ña koo ta̱Elías. Ni̱ka̱ꞌa̱n ta̱Pedro saá chi o̱n vása kúnda̱a̱ ini ra yukía̱ káꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tá káꞌa̱n ka̱ ta̱Pedro, ta no̱o ñii vi̱ko̱ chée nda̱ no̱o̱ ñíndichi ra xíꞌin nata̱a yóꞌo, ta ni̱saꞌvi ndiꞌi na ti̱xin vi̱ko̱, ta ni̱yi̱ꞌví ní na. ");
INSERT INTO mim_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ta ti̱xin vi̱ko̱ yóꞌo ki̱xi to̱ꞌon ña ni̱ka̱ꞌa̱n Ndios, káchí ra saá: ―Ta̱yóꞌo kúu Sa̱ꞌya i̱, ta̱ kíꞌvi ní ini i̱ xíni i̱. Ta koni̱ so̱ꞌo va̱ꞌa ndó to̱ꞌon ña ka̱ꞌa̱n ra ―káchí Ndios. ");
INSERT INTO mim_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tá xi̱ni̱ so̱ꞌo na to̱ꞌon yóꞌo, ta ni̱‑xini ka̱ na o̱vi̱ ta̱a ta̱ ni̱ka̱ꞌa̱n xíꞌin ta̱Jesús, nda̱ ñii la̱á kuiti ta̱Jesús ñíndichi no̱o̱ na. Ta naxíka xíꞌin ta̱Jesús o̱n vása ní‑ndato̱ꞌon ya̱chi̱ na xíꞌin nda̱ ñii ni̱vi xa̱ꞌa̱ ña xi̱ni nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ta ni̱ti̱vi inka̱ ki̱vi̱, ta ndi̱kó ta̱Jesús va̱xi noo ra yuku̱ xíꞌin ta̱Pedro, ta̱Juan, xíꞌin ta̱Jacobo, ta na̱kutáꞌan na xíꞌin kua̱ꞌa̱ ní ni̱vi na ki̱xaa̱ no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ta ñii ta̱táꞌan nani̱vi yóꞌo, xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Tata maestro, kundáꞌví ini ún koni ún ta̱loꞌo sa̱ꞌya i̱. O̱n ko̱ó ka̱ inka̱ sa̱ꞌya i̱, ");
INSERT INTO mim_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ta kua̱ꞌa̱ ní yichi̱ ñaníma̱ ndiva̱ꞌa tíin ña ra, ta ndáꞌyi ní ra, ta ndeé ní sákisin ña ra, ta̱nda̱ kée chikiño yuꞌu̱ ra. Sátakuéꞌe̱ ní ña ra, ta o̱n xi̱in ña saña ña ra. ");
INSERT INTO mim_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ta xa xa̱ku ndáꞌví i̱ no̱o̱ naxíka xíꞌin ún tava na níma̱ ndiva̱ꞌa yóꞌo, ta o̱n vása ní‑kuchiño na ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―¡Ni̱vi na toon ní ini kúu ndóꞌó, ta o̱n xi̱in ndó kandixa ndó Ndios! ¿Ndasaá ka̱ ki̱vi̱ xíni̱ ñóꞌó kutaku̱ i̱ xíꞌin ndó? ¿Nda̱ ama kundeé ini i̱ xíꞌin ndó? ―káchí ra. Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin yivá ta̱loꞌo ta̱ kómí níma̱ ndiva̱ꞌa: ―Naꞌa xíꞌin sa̱ꞌya ún ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ta ki̱xaa̱ ta̱loꞌo yatin no̱o̱ ta̱Jesús, ta níma̱ ndiva̱ꞌa tuku ti̱in ña ra, ta sa̱kana ña ra no̱o̱ ñoꞌo̱, ta kini ní sa̱kisin ña ra nda̱ kée ndaꞌa̱ ra xíꞌin xa̱ꞌa̱ ra. Ta ta̱Jesús xa̱ꞌnda chiño ra no̱o̱ níma̱ ndiva̱ꞌa ña kee ña. Ta ñaníma̱ ndiva̱ꞌa yóꞌo ke̱e ña, ta xa̱ndi̱ko̱n ndu̱va̱ꞌa ta̱loꞌo, ta ta̱Jesús na̱taxi ra ta̱loꞌo yóꞌo ndaꞌa̱ yivá ra. ");
INSERT INTO mim_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ta ndiꞌi ni̱vi na̱kaꞌnda ní ini na, chi xi̱ni na ñandee̱ káꞌno kómí Ndios. Ta na ndóo yóꞌo na̱kaꞌnda ini na xa̱ꞌa̱ ñava̱ꞌa ke̱ꞌé ta̱Jesús, ta ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra: ");
INSERT INTO mim_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Chikaa̱ va̱ꞌa so̱ꞌo ndó to̱ꞌon ña káꞌa̱n i̱ xíꞌin ndó vitin. Ñii ki̱vi̱ ña va̱xi ñii ta̱a nataxi ra yi̱ꞌi̱, ta̱ kúu ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndaꞌa̱ ni̱vi ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ta naxíka xíꞌin ra o̱n vása ní‑kunda̱a̱ ini na yukía̱ káchí to̱ꞌon ña ni̱ka̱ꞌa̱n ra xíꞌin na, saá chi o̱n vása ní‑taxi ya̱chi̱ Ndios ña kunda̱a̱ ini na. Ta yíꞌví ní na nda̱ka̱ to̱ꞌon na ra yukía̱ kóni kachí ña káꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ñii ki̱vi̱ naxíka xíꞌin ta̱Jesús ki̱xáꞌá na náa na xíꞌin táꞌan na xa̱ꞌa̱ yu kúu ta̱ káꞌno ka̱ no̱o̱ ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ta xíni̱ ndiꞌi ta̱Jesús yukía̱ xáni ini na, ta ka̱na ra ñii ta̱loꞌo, ta ki̱xaa̱ ra xi̱kundichi ra sii̱n ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ta ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra: ―Ndiꞌi ni̱vi xa̱ꞌa̱ ña kándixa na yi̱ꞌi̱, ta nákiꞌin va̱ꞌa na naválí, kóni kachí ña saá: ndí yi̱ꞌi̱ nákiꞌin va̱ꞌa na. Ta ndiꞌi ni̱vi na nákiꞌin va̱ꞌa yi̱ꞌi̱, káchí ña saá: ndí nákiꞌin va̱ꞌa na Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ va̱xi i̱. Saá chi ta̱a ta̱ kúu ta̱ ni̱no̱ ka̱ no̱o̱ ndó, ta̱yóꞌo kúu ta̱ káꞌno ka̱ no̱o̱ ndiꞌi ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ta ni̱ka̱ꞌa̱n ta̱Juan xíꞌin ta̱Jesús: ―Tata Maestro, xi̱ni ndi̱ ñii ta̱a táva ra níma̱ ndiva̱ꞌa. Xáꞌnda chiño ra no̱o̱ níma̱ ndiva̱ꞌa xíꞌin nda̱yí ún, káchí ra. Ta ni̱ka̱ꞌa̱n ndi̱ xíꞌin ra sandakoo ra ña kéꞌé ra saá, chi o̱n si̱ví ta̱ ndíko̱n sa̱ta̱ ún xíꞌin ndi̱ kúu ra ―káchí ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―O̱n kasi ndó no̱o̱ ra, chi yóo yuꞌú ta̱kán xíꞌin mi̱i yó. Saá chi ni̱vi na o̱n vása sáa̱ ini xíni mi̱i yó, nayóꞌo kúu na yóo yuꞌú xíꞌin mi̱i yó ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ta xa va̱xi ki̱vi̱ ndikó ta̱Jesús ko̱ꞌo̱n ra ñoyívi ni̱no, ta chi̱kaa̱ ini ra ko̱ꞌo̱n ra ñoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ta saá ti̱ꞌví ra sava na xíka chiño no̱o̱ ra, ná ko̱ꞌo̱n na ñii ñoo estado Samaria ña kasa ndivi na ña xaa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ta nañoo kán ni̱‑xiin na nakiꞌin na ta̱Jesús, chi xíni̱ na ndí kóni ra ko̱ꞌo̱n ra ñoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ta o̱vi̱ ta̱a ta̱xíka xíꞌin ta̱Jesús, ta̱Jacobo xíꞌin ta̱Juan, xi̱ni na ndí ni̱‑xiin ni̱vi nañoo Samaria yóꞌo nakiꞌin va̱ꞌa na ta̱Jesús, ta ni̱ka̱ꞌa̱n nata̱a yóꞌo xíꞌin ta̱Jesús: ―Tata, ¿án kóni ún ndukú ndi̱ no̱o̱ Ndios chikaa̱ ra ñoꞌo̱ ta kaꞌmi ña ndiꞌi ni̱vi nañoo yóꞌo?, chi saá ki̱sa ta̱profeta Elías kui̱ya̱ xi̱na̱ꞌá ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ta ndi̱kó koo ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ndóꞌó, o̱n vása va̱ꞌa káꞌa̱n ndó saá, ");
INSERT INTO mim_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","chi o̱n si̱ví xa̱ꞌa̱ ña sandiꞌi i̱ xa̱ꞌa̱ ni̱vi kúu ña ki̱xaa̱ i̱ ñoyívi yóꞌo, ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ta̱ va̱xi saka̱ku ni̱vi kúu i̱ ―káchí ra. Ta saá ke̱e na kua̱ꞌa̱n na inka̱ ñoo. ");
INSERT INTO mim_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kua̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra yichi̱, ta na̱kutáꞌan na xíꞌin ñii ta̱a, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús siꞌa: ―Tata, kundiko̱n i̱ sa̱ta̱ ún, nda̱ mí ko̱ꞌo̱n ún ta ko̱ꞌo̱n i̱ xíꞌin ún ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Tíñokuii kómí rí kavua̱ no̱o̱ kísi̱n rí, ta tísaa kómí rí ta̱ka̱ rí ndaꞌa̱ yito̱n no̱o̱ kísi̱n rí, ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, o̱n ko̱ó veꞌe i̱ no̱o̱ ku̱su̱n i̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin inka̱ ta̱a: ―Naꞌa kundiko̱n ún sa̱ta̱ i̱ ―káchí ra. Ta nda̱kuii̱n ta̱yóꞌo, ni̱ka̱ꞌa̱n ra: ―Va̱ꞌa Tata, ta siꞌna taxi ún ña kundati i̱ nda̱ ná kivi̱ yivá i̱, ta sandúxu̱n i̱ ra, ta saá kundiko̱n i̱ yichi̱ ún ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Ni̱vi na o̱n vása ndinoꞌo táku̱ no̱o̱ Ndios, va̱ꞌa sandúxu̱n na natáꞌan na nandi̱í. Ta yóꞌó, yóo inka̱ chiño ña xíni̱ ñóꞌó ní ka̱ kasa ndivi ún: Va̱ꞌa ko̱ꞌo̱n ún ka̱ꞌa̱n ndoso ún to̱ꞌon xa̱ꞌa̱ yichi̱ no̱o̱ xáꞌnda chiño Ndios ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ta ni̱ka̱ꞌa̱n inka̱ ta̱a, káchí ra saá xíꞌin ta̱Jesús: ―Kóni kundiko̱n i̱ yóꞌó, Tata, ta siꞌna taxi ún ná ko̱ꞌo̱n i̱ nda̱yi i̱ naveꞌe i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ta saá nda̱kuii̱n ta̱Jesús, káchí ra: ―Tá yóo ñii ta̱ táꞌví no̱o̱ ñoꞌo̱, ta tiin ra xa̱ꞌa̱ ya̱ta̱, ta ndikó koo ra nakoto ra chí sa̱ta̱ ra, ta o̱n vása va̱ꞌa kasa chiño ra. Nda̱tán yóo ta̱yóꞌo, saá yóo ni̱vi na kíxáꞌá kua̱ꞌa̱n yichi̱ Ndios, ta o̱n xi̱in na sandakoo na yichi̱ yatá. Ta nayóꞌo o̱n vása va̱ꞌa kasa chiño na yichi̱ Ndios ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ta ndi̱ꞌi ñayóꞌo, ta ta̱Jesús na̱ka̱xin ra u̱ni̱ si̱ko̱ u̱xu̱ ta̱a, ta ti̱ꞌví ra na, o̱vi̱ o̱vi̱ na kua̱ꞌa̱n siꞌna na ndiꞌi saá ñoo, ta saá xaa̱ mi̱i ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ta ta̱ꞌán ka̱ ko̱ꞌo̱n na ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Nda̱tán yóo kui̱ꞌi ña xa yóo tiꞌva nakaya, saá yóo ni̱vi na xa yóo tiꞌva kundiko̱n yi̱ꞌi̱, ta o̱n ko̱ó ni̱vi kasa chiño na no̱o̱ i̱ nakaya na nayóꞌo. Ta saá kuaku ndáꞌví ndó ndukú ndó no̱o̱ Ndios ña tiꞌví ra inka̱ ni̱vi ña kasa ndivi na chiño ra ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ta vitin kua̱ꞌa̱n ndó kasa ndivi ndó chiño xa̱ꞌa̱ Ndios. Ta ndóꞌó, nda̱tán yóo ndikachi válí ma̱ꞌñó tíndiva̱ꞌyí, saá koo ndó, chi yóo kua̱ꞌa̱ ní ni̱vi na o̱n váꞌa ini no̱o̱ ko̱ꞌo̱n ndó. ");
INSERT INTO mim_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tá kua̱ꞌa̱n ndó, ta o̱n kuniꞌi ndó si̱ꞌún, ni leká ndó, ni inka̱ ndu̱xa̱n ndó. Ta o̱n kuita ndó ndato̱ꞌon ndó xíꞌin ni̱vi yichi̱. ");
INSERT INTO mim_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tá ni̱xaa̱ ndó no̱o̱ kua̱ꞌa̱n ndó, ta veꞌe no̱o̱ xaa̱ ndó, ka̱ꞌa̱n ndó xíꞌin ni̱vi: “Ná koo va̱ꞌa ini ndóꞌó na ndóo veꞌe yóꞌo”, kachí ndó xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tá yóo ni̱vi na va̱ꞌa ini veꞌe yóꞌo, ta ndixa ná koo va̱ꞌa ini na. Tá o̱n ko̱ó ni̱vi na va̱ꞌa ini veꞌe yóꞌo, ta saá ñava̱ꞌa ni̱ka̱ꞌa̱n ndó xa̱ꞌa̱ nayóꞌo, o̱n ndo̱o ña xíꞌin na, ta ndikó ña xíꞌin mi̱i ndó. ");
INSERT INTO mim_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ta no̱o̱ na̱kiꞌin va̱ꞌa ni̱vi ndóꞌó, ta kundo̱o ndó veꞌe nayóꞌo. Ta va̱ꞌa kuxu ndó ta koꞌo ndó nda̱ ndá ña taxi na ndaꞌa̱ ndó. Ndóꞌó kísa ndivi ndó chiño ña chindeé nayóꞌo, ta saá yóo nda̱yí xa̱ꞌa̱ ña taxi na ña kuxu ndó. Saá chi ndiꞌi ni̱vi na kísa chiño kómí na nda̱yí nakiꞌin na yaꞌvi na. ");
INSERT INTO mim_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tá xaa̱ ndó ñii ñoo, ta ni̱vi nakiꞌin va̱ꞌa na ndóꞌó, ta va̱ꞌa kuxu ndó ña taxi na ndaꞌa̱ ndó, ");
INSERT INTO mim_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ta sandaꞌa ndó ni̱vi na ndeé ndóꞌo, ta ka̱ꞌa̱n ndó saá xíꞌin na: “Xa yóo yatin yichi̱ no̱o̱ xáꞌnda chiño Ndios”, kachí ndó xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tá xaa̱ ndó ñii ñoo, tá o̱n vása nákiꞌin va̱ꞌa ni̱vi ndóꞌó, ta kee ndó kua̱ꞌa̱n ndó yichi̱ ñoo yóꞌo, ta ka̱ꞌa̱n ndó siꞌa: ");
INSERT INTO mim_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ná sakisin ndi̱ xa̱ꞌa̱ ndi̱ ña nako̱yo yaa̱ ñoo ndó. Xíꞌin ñayóꞌo kunda̱a̱ ini ndó ndí mi̱i ndó kúu na ndíso kua̱chi, chi ni̱‑xiin ndó koni̱ so̱ꞌo ndó to̱ꞌon Ndios. Ta kunda̱a̱ ini ndó ndí xa yóo yatin yichi̱ no̱o̱ xáꞌnda chiño Ndios”, kachí ndó xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ta káꞌa̱n i̱ xíꞌin ndó, to̱nda̱a ñii ki̱vi̱ ña kasa nani Ndios xa̱ꞌa̱ kua̱chi ndiꞌi ni̱vi ñoyívi yóꞌo. Ta ki̱vi̱ yóꞌo ndeé ka̱ yo̱ꞌvi̱ saxo̱ꞌvi̱ Ndios nañoo yóꞌo no̱o̱ ni̱vi na o̱n váꞌa na xi̱ndo̱o ñoo Sodoma kui̱ya̱ xi̱na̱ꞌá ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ta̱Jesús káꞌa̱n ka̱ ra, káchí ra saá: ―¡Ndáꞌví ní ndó, ni̱vi nañoo Corazín! ¡Ndáꞌví ní ndó, ni̱vi nañoo Betsaida! Chi va̱xi ñii ki̱vi̱ ña xo̱ꞌvi̱ ní ndó. Saá chi kui̱ya̱ xi̱na̱ꞌá tá xini ví ni̱vi nañoo Tiro xíꞌin nañoo Sidón milagro ña kéꞌé i̱ xíꞌin ndó vitin, níkúu, ta nandikó ní ka̱ ini nayóꞌo, ta nakundixin na tiko̱to̱ ndayí no̱o̱, ta chikaa̱ na yaa̱ noꞌo̱ si̱ni̱ na ña kúchuchú ní ini na xa̱ꞌa̱ kua̱chi na. ");
INSERT INTO mim_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ña̱kán kía̱, tá to̱nda̱a ñii ki̱vi̱ ña kasa nani Ndios xa̱ꞌa̱ kua̱chi ndiꞌi ni̱vi ñoyívi yóꞌo, ¡ta ki̱vi̱ yóꞌo xo̱ꞌvi̱ ní ndóꞌó, nañoo Corazín xíꞌin nañoo Betsaida! Ndeé ka̱ yo̱ꞌvi̱ saxo̱ꞌvi̱ Ndios ndóꞌó no̱o̱ ni̱vi na o̱n váꞌa na xi̱ndo̱o ñoo Tiro xíꞌin ñoo Sidón. ");
INSERT INTO mim_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ta ndóꞌó, ni̱vi nañoo Capernaum ¿án xáni si̱ni̱ ndó kanóo va̱ꞌa ní to̱ꞌon ndó nda̱ ñoyívi ni̱no? ¡O̱n vása! Ta ndáꞌví ní ndó, chi Ndios tiꞌví ra ndóꞌó ko̱ꞌo̱n ndó ni̱no̱, nda̱ nda̱ya ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ta saá ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin u̱ni̱ si̱ko̱ u̱xu̱ ta̱a, káchí ra: ―Ndóꞌó kómí ndó nda̱yí i̱ ndato̱ꞌon ndó xíꞌin ni̱vi. Ta ndiꞌi ni̱vi na nakiꞌin va̱ꞌa to̱ꞌon ña káꞌa̱n ndó, to̱ꞌon yi̱ꞌi̱ kúu ña nakiꞌin na. Ndiꞌi ni̱vi na o̱n xi̱in nakiꞌin ndóꞌó, ta yi̱ꞌi̱ kúu ta̱ o̱n xi̱in na nakiꞌin na. Ta ndiꞌi na o̱n xi̱in nakiꞌin yi̱ꞌi̱, Ndios kúu ta̱ o̱n xi̱in na nakiꞌin na, chi Ndios kúu ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ va̱xi i̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ta saá ni̱xa̱ꞌa̱n na u̱ni̱ si̱ko̱ u̱xu̱ ta̱a, ta ni̱to̱nda̱a ki̱vi̱ ndikó na, ta kúsii̱ ní ini na, ta ki̱xaa̱ na no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n na siꞌa: ―Tata, nda̱ níma̱ ndiva̱ꞌa ki̱sa ndivi ña ña xa̱ꞌnda chiño ndi̱ no̱o̱ ña xíꞌin nda̱yí ún. ");
INSERT INTO mim_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra saá: ―Xi̱ni i̱ ñandiva̱ꞌa káꞌno Satanás ke̱e ña ñoyívi ni̱no, ta na̱kava ña nda̱ no̱o̱ ñoꞌo̱. Nda̱tán káa ñii ta̱xa̱, saá káa ña na̱kava ña nda̱ no̱o̱ ñoꞌo̱. ");
INSERT INTO mim_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Xa ta̱xi i̱ ndee̱ i̱ ndaꞌa̱ ndó ña kuchiño kundo̱so̱ ndó sa̱ta̱ tíko̱o̱ xíꞌin títisi̱ꞌma̱, ta kundeé ndó no̱o̱ ndiꞌi ndee̱ ñandiva̱ꞌa, ta nda̱ loꞌo o̱n kuchiño ña satakuéꞌe̱ ña ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ndóꞌó, kúsii̱ ní ini ndó vitin, xa̱ꞌa̱ ña kúchiño ndó xáꞌnda chiño ndó no̱o̱ níma̱ ndiva̱ꞌa. Ta va̱ꞌa ná kusii̱ ní ka̱ ini ndó chi Ndios xa ni̱kaꞌyi ra ki̱vi̱ ndó no̱o̱ tutu ña yóo ñoyívi ni̱no ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ta mi̱i hora yóꞌo, ta Níma̱ Ndios sa̱kutú ña níma̱ ta̱Jesús xíꞌin ñasi̱i̱, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios siꞌa: ―Tata Yivá i̱, ¡kísa káꞌno i̱ yóꞌó! Yóꞌó kúu Ta̱a ta̱Káꞌno ta̱ xáꞌnda chiño no̱o̱ ndiꞌi ña yóo ñoyívi yóꞌo xíꞌin ña yóo ñoyívi ni̱no. Kísa káꞌno i̱ yóꞌó, chi xa sa̱náꞌa ún nayóꞌo, na ni̱no̱ ini kúu na, ta kúnda̱a̱ ini na ñava̱ꞌa xa̱ꞌa̱ ún. Ta chi̱seꞌé ún ñava̱ꞌa yóꞌo no̱o̱ inka̱ ni̱vi na na̱ní nandíchí, xíꞌin na na̱ní na káꞌvi ta tiꞌva ní yóo ñoyívi yóꞌo, chi saá káchí ini ún keꞌé ún xíꞌin ndiꞌi ni̱vi, Tata ―káchí ta̱Jesús xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ta ni̱ka̱ꞌa̱n ka̱ ra saá: ―Yivá i̱ Ndios xa ta̱xi ra ndiꞌi ñava̱ꞌa ndaꞌa̱ i̱. Nda̱ ñii ni̱vi o̱n vása xíni̱ na ini yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya Ndios, ta ñii la̱á mi̱i Ndios kúu ta̱ xíni̱ va̱ꞌa ini yi̱ꞌi̱. Ta nda̱ ñii ni̱vi o̱n vása xíni̱ na ini Yivá i̱ Ndios, ta ñii la̱á yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya ra, kúu ta̱ xíni̱ ini ra, ta ni̱vi na na̱ka̱xin i̱ taxi i̱ koni̱ na ini ra ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Nákaa̱ ñasi̱i̱ níma̱ ndó chi xíto ndó ñava̱ꞌa kéꞌé i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ta kui̱ya̱ xi̱na̱ꞌá ni̱xi̱yo kua̱ꞌa̱ ní naprofeta xíꞌin kua̱ꞌa̱ ní narey, ta ndiꞌi nayóꞌo ku̱too na koto na ña xíto ndó vitin, ta ni̱‑kuchiño na. Ta ku̱too na koni̱ so̱ꞌo na ña xíni̱ so̱ꞌo ndó vitin, ta ni̱‑kuchiño na ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ta saá ki̱xaa̱ ñii ta̱maestro ta̱ xíni̱ va̱ꞌa nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá, ta ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús, chi kóni ra koto ndoso ñaꞌá ra, káchí ra saá: ―Tata maestro, ¿yukía̱ keꞌé i̱, ta taxi Ndios koo i̱ xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―¿Yukía̱ káchí nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá? ¿Yukía̱ káꞌvi ún no̱o̱ nda̱yí yóꞌo? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ta nda̱kuii̱n ta̱yóꞌo, ni̱ka̱ꞌa̱n ra saá: ―Saá káchí ña: “Ná kukiꞌvi ini yó koni yó Yivá yó Ndios xíꞌin ndiꞌi níma̱ yó, xíꞌin ndiꞌi ini yó, xíꞌin ndiꞌi ndee̱ yó, xíꞌin ndiꞌi si̱ni̱ yó. Ñii ki̱ꞌva nda̱tán kíꞌvi ini yó xíni yó xíꞌin mi̱i yó, saá kukiꞌvi ini yó koni yó natáꞌan yó”, káchí nda̱yí Ndios ―káchí ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Va̱ꞌa ní káꞌa̱n ún. Tá kasa ndivi ún nda̱yí yóꞌo, ta Ndios taxi ra ña kutaku̱ ún xíꞌin ra ―káchí ta̱Jesús xíꞌin ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ta kóni ta̱maestro yóꞌo kasa nda̱a̱ ra xa̱ꞌa̱ mi̱i ra no̱o̱ ta̱Jesús, ta ña̱kán tuku ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús, ni̱ka̱ꞌa̱n ra saá: ―¿Yu kúu natáꞌan yó? ");
INSERT INTO mim_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ta nda̱kuii̱n ta̱Jesús, nda̱to̱ꞌon ra ñii cuento ña sanáꞌa ñaꞌá ra, káchí ra saá: ―Saá ndo̱ꞌo ñii ta̱a ke̱e ra ñoo Jerusalén, ta kua̱ꞌa̱n ra yichi̱ ña kua̱ꞌa̱n ñoo Jericó. Tá kua̱ꞌa̱n noo ra, ta ka̱na ko̱yo sava nakuíꞌná yichi̱ yóꞌo, ta sa̱si na ra, ki̱sa kuíꞌná na ndiꞌi ña kómí ra, ki̱ndaa na tiko̱to̱ ra, ka̱ni ní na ra, sa̱takuéꞌe̱ ní na ra nda̱ saloꞌo kivi̱ ra. Ta sa̱ndakoo na ra, ta kua̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ta saá va̱xi ñii su̱tu̱, ta ni̱xaa̱ ra no̱o̱ kándúꞌu̱ ta̱a ta̱ ta̱kuéꞌe̱, ta xi̱ni kuiti ñaꞌá ra, ta ni̱yaꞌa xíyo ra, ta kua̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ta saá va̱xi inka̱ ta̱a, ta̱táꞌan naLeví, na kúu na ndíso chiño xíꞌin veꞌe ño̱ꞌo káꞌno. Ki̱xaa̱ ra no̱o̱ kándúꞌu̱ ta̱ ta̱kuéꞌe̱, ta xi̱ni kuiti ñaꞌá ra, ta ni̱yaꞌa xíyo ra, ta kua̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ta saá va̱xi inka̱ ta̱a ta̱ñoo Samaria, ta ki̱xaa̱ ra no̱o̱ kándúꞌu̱ ta̱ ta̱kuéꞌe̱. Tá xi̱ni ñaꞌá ra, ta ku̱ndáꞌví ní ini ra xi̱ni ra ta̱ ta̱kuéꞌe̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ta ni̱xaa̱ yatin ra no̱o̱ ra, ta ki̱xáꞌá ra chíkaa̱ ra aceite xíꞌin vino no̱o̱ ta̱kuéꞌe̱ ta̱yóꞌo ña kasa ta̱ta̱n ñaꞌá ra. Ta chi̱katón ra tiko̱to̱ ndiꞌi saá no̱o̱ ta̱kuéꞌe̱ ra. Ta nda̱níꞌi ñaꞌá ra, ta sa̱ndaa ñaꞌá ra sa̱ta̱ tíburro sa̱na̱ ra, ta na̱kiꞌin ra kua̱ꞌa̱n ra xíꞌin ra ñii veꞌe no̱o̱ kísi̱n na xíka yichi̱, ta saá xi̱ndaa ñaꞌá ra. ");
INSERT INTO mim_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tá ni̱ti̱vi inka̱ ki̱vi̱, ta ta̱xi ta̱a ta̱Samaria yóꞌo o̱vi̱ si̱ꞌún denario ndaꞌa̱ ta̱ xíꞌin veꞌe yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ra: “Kundaa loꞌo ún ta̱ ta̱kuéꞌe̱ yóꞌo ná ndo̱o loꞌo ra veꞌe ún. Tá ni̱‑nani si̱ꞌún yóꞌo kutátán ra, ta chinóo ún si̱ꞌún mi̱i ún, ta saá chaꞌvi i̱ yóꞌó ki̱vi̱ ndikó i̱”, káchí ra. Saá ndi̱ꞌi cuento loꞌo yóꞌo ―káchí ta̱Jesús xíꞌin ta̱maestro ta̱ sánáꞌa nda̱yí Ndios. ");
INSERT INTO mim_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―U̱ni̱ ta̱a ni̱yaꞌa no̱o̱ kándúꞌu̱ ta̱a ta̱ ta̱kuéꞌe̱ yóꞌo. ¿Yukú ta̱a ke̱ꞌé ñava̱ꞌa nda̱tán kéꞌé ta̱táꞌan ra xíꞌin ra? ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ta nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra: ―Ta̱a ta̱ ke̱ꞌé ñava̱ꞌa xíꞌin ra kúu ta̱táꞌan ra ―káchí ra xíꞌin ta̱Jesús. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Kua̱ꞌa̱n ún, ta nda̱tán ke̱ꞌé ta̱ ku̱ndáꞌví ini xi̱ni ta̱ ta̱kuéꞌe̱ yóꞌo, saá keꞌé ún xíꞌin inka̱ ni̱vi ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kua̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra, ta ni̱xaa̱ na ñii ñoo loꞌo. Ta ñii ñaꞌa̱ na̱ní ñá Marta na̱kiꞌin ñá na, ta ni̱ki̱ꞌvi na ini veꞌe ñá. ");
INSERT INTO mim_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ta ñáMarta yóo ki̱ꞌvi̱ ñá na̱ní María, ta ki̱xaa̱ ñáMaría xi̱koo ñá yatin xa̱ꞌa̱ ta̱Jesús, ta xíni̱ so̱ꞌo ñá yukía̱ ndáto̱ꞌon ra. ");
INSERT INTO mim_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ta ñáMarta ndíꞌi ní ini ñá chi yóo kua̱ꞌa̱ ní chiño kasa ndivi ñá. Ta ki̱xaa̱ ñá no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n ñá xíꞌin ra: ―Tata, ¿án o̱n vása ndíꞌi ini ún, chi ñii la̱á mi̱i i̱ kísa chiño i̱? Chi ki̱ꞌvi̱ i̱ sa̱ndakoo ñá ndiꞌi chiño, ta kóni i̱ ña ka̱ꞌa̱n ún xíꞌin ñá ná chindeé ñá yi̱ꞌi̱ ―káchí ñá xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ta nda̱kuii̱n ra: ―Nana, ndíꞌi ní ini ún chi yóo kua̱ꞌa̱ ní chiño. ");
INSERT INTO mim_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ta ñii chiño kúu ña xíni̱ ñóꞌó ka̱ no̱o̱ ndiꞌi inka̱ ña kísa ndivi ún. Ki̱ꞌvi̱ ún ñáMaría xa na̱ka̱xin ñá kasa ndivi ñá chiño ña xíni̱ ñóꞌó ka̱, chi yóo ñá, xíni̱ so̱ꞌo ñá to̱ꞌon ña káꞌa̱n i̱. Ta nda̱ ñii ni̱vi, o̱n váꞌa kindaa na chiño yóꞌo ndaꞌa̱ ñá ―káchí ta̱Jesús xíꞌin ñáMarta. ");
INSERT INTO mim_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ñii ki̱vi̱ ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin Ndios, ta ñii ta̱xíka xíꞌin ra ki̱xaa̱ ra no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Tata, kóni ndi̱ ña sanáꞌa ún ndi̱ꞌi̱ ndasaá ka̱ꞌa̱n ndi̱ xíꞌin Ndios, saá chi ta̱Juan ta̱ sa̱kuchu ni̱vi sa̱náꞌa ra naxíka xíꞌin ra ndasaá koo ka̱ꞌa̱n na xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Tá káꞌa̱n ndó xíꞌin Ndios, saá kachí ndó: Tata Yivá yó, ta̱ yóo ñoyívi ni̱no, ná kanóo síkón ní ñato̱ꞌó ún. Ná kama kixaa̱ ki̱vi̱ kaꞌnda chiño ún no̱o̱ ndiꞌi ni̱vi. Nda̱tán yóo ñoyívi ni̱no kísa ndivi ndiꞌi na ña kóni ún, ñii ki̱ꞌva saá ñoyívi yóꞌo ná kasa ndivi ndiꞌi ni̱vi ña kóni ún. ");
INSERT INTO mim_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ndiꞌi saá ki̱vi̱ taxi ún ña xíni̱ ñóꞌó kuxu ndi̱. ");
INSERT INTO mim_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ta kasa káꞌno ini ún xa̱ꞌa̱ kua̱chi ndi̱, chi saá kísa káꞌno ini mi̱i ndi̱ xa̱ꞌa̱ ni̱vi na kéꞌé ña o̱n váꞌa xíꞌin ndi̱. Tá xóꞌvi̱ ndi̱ tondóꞌó, ta chindeé ún ndi̱ꞌi̱ ña o̱n ki̱ꞌvi ndi̱ kua̱chi, ta saka̱ku ún ndi̱ꞌi̱ no̱o̱ ndiꞌi ña o̱n váꞌa, saá ka̱ꞌa̱n ndó xíꞌin Ndios ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ta saá nda̱to̱ꞌon ra xíꞌin na inka̱ cuento ña sanáꞌa ra na, ni̱ka̱ꞌa̱n ra siꞌa: ―Ñii ma̱ꞌñó ñoó, ta ñii ndóꞌó ko̱ꞌo̱n ndó veꞌe ta̱migo ndó, ta ka̱ꞌa̱n ndó xíꞌin ra: “Ñani, ¿án kúchiño ún taxi ún u̱ni̱ si̱ta̱ va̱ꞌa ndaꞌa̱ i̱?, ");
INSERT INTO mim_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","chi ñii ta̱migo i̱ xíka ra viaje, ta sa̱kán ki̱xaa̱ ra veꞌe i̱, ta o̱n ko̱ó ña̱ꞌa no̱o̱ i̱ taxi i̱ kuxu ra”, kachí ndó. ");
INSERT INTO mim_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ta ta̱migo ndó yóꞌo o̱n keta ra veꞌe ra, ta ndakuii̱n ra, kachí ra saá: “O̱n sandiꞌi ún yi̱ꞌi̱. Xa ndási̱ kútu̱ yéꞌé i̱, ta xa kándúꞌu̱ i̱ xíꞌin sa̱ꞌya i̱, ña̱kán o̱n ki̱ví ndakoo i̱ taxi i̱ si̱ta̱ va̱ꞌa ndaꞌa̱ ún”, kachí ra xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Vará ta̱migo ndó kúu ra, ta o̱n kuaꞌa ra ndakoo ra taxi ra ña kuxu ndó. Ta xa̱ꞌa̱ ña o̱n xi̱in ndó sandakoo ndó sándiꞌi ndó ra, ta ndixa ndakoo ra taxi ra ndiꞌi ña xíni̱ ñóꞌó ndaꞌa̱ ndó. ");
INSERT INTO mim_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Cuento loꞌo yóꞌo sánáꞌa ña siꞌa: O̱n sandakoo ndó ndúkú ndó ña xíni̱ ñóꞌó ndó no̱o̱ Ndios, saá chi ndixa taxi ra ña ndaꞌa̱ ndó. Ta ni o̱n sandakoo ndó nándukú ndó Ndios, saá chi ndixa naníꞌi ndó ra. Ta ni o̱n sandakoo ndó kána ndó yéꞌé yichi̱ Ndios, saá chi ndixa nakuiná ra ña ki̱ꞌvi ndó yichi̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chi ndiꞌi ni̱vi na ndúkú no̱o̱ Ndios ña xíni̱ ñóꞌó na, ta nakiꞌin na ña. Ta ndiꞌi ni̱vi na nándukú Ndios, naníꞌi na ra. Ta ndiꞌi ni̱vi na kána Ndios, ta nakuiná ra yéꞌé ra ña ki̱ꞌvi na yichi̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Tá yóo ñii sa̱ꞌya ndó, tá ndúkú ra si̱ta̱ va̱ꞌa no̱o̱ ndó, ta o̱n ki̱ví taxi ndó yu̱u̱ ndaꞌa̱ ra, chi sa̱ꞌya ndó kúu ra. Tá ndúkú ra ñii tia̱ká no̱o̱ ndó kuxu ra, ta o̱n ki̱ví taxi ndó ñii ko̱o̱ ndaꞌa̱ ra, chi sa̱ꞌya ndó kúu ra. ");
INSERT INTO mim_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tá ndúkú ra ñii ndi̱vi̱ no̱o̱ ndó, ta o̱n ki̱ví taxi ndó tisi̱ꞌma̱ ndaꞌa̱ ra, chi sa̱ꞌya ndó kúu ra. ");
INSERT INTO mim_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Vará ndóꞌó kúu ndó ni̱vi na o̱n váꞌa, ta saá ni, táxi ndó ñava̱ꞌa ndaꞌa̱ sa̱ꞌya ndó. Ta Yivá yó Ndios, ta̱ yóo ñoyívi ni̱no, kúu ra ta̱ va̱ꞌa ní ka̱ no̱o̱ ni̱vi, ta ndixa taxi ra Níma̱ ra ndaꞌa̱ ndiꞌi ni̱vi na ndukú ña no̱o̱ ra ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Inka̱ ki̱vi̱ ta̱Jesús táva ra ñii níma̱ ndiva̱ꞌa ña kómí ñii ta̱a ta̱ñíꞌí. Tá ke̱e níma̱ ndiva̱ꞌa, ta saá va̱ꞌa na̱ka̱ꞌa̱n ra. Ta na̱kaꞌnda ini ni̱vi na xi̱ni ñayóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ta sava na ni̱ka̱ꞌa̱n na xa̱ꞌa̱ ta̱Jesús: ―Xíꞌin ndee̱ ñaBeelzebú, ña kúu ñakáꞌno no̱o̱ ndiꞌi níma̱ ndiva̱ꞌa, táva ta̱yóꞌo níma̱ ndiva̱ꞌa ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ta inka̱ ni̱vi kóni koto ndoso na ta̱Jesús, ta ndu̱kú na no̱o̱ ra ña keꞌé ra ñii milagro ña sanáꞌa ra no̱o̱ na ña ndixa kómí ra ndee̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ta ta̱Jesús xíni̱ ra ña xáni ini na, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Tá yóo ñii ñoo, ta o̱n vása yóo yuꞌú ni̱vi, ta na̱ta̱ꞌvi̱ táꞌan na, ta ki̱xáꞌá na káni táꞌan na xíꞌin natáꞌan na, ta kama ní ndiꞌi xa̱ꞌa̱ ñoo yóꞌo. Tá yóo ñii veꞌe no̱o̱ na̱ta̱ꞌvi̱ táꞌan na, ta káni táꞌan na, ta ndiꞌi xa̱ꞌa̱ ni̱vi veꞌe yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ta ñaníma̱ ndiva̱ꞌa káꞌno Satanás, táná tava ña ini ni̱vi níma̱ ndiva̱ꞌa táꞌan ña, níkúu, ta saá nata̱ꞌvi̱ táꞌan ñandiva̱ꞌa ta kani táꞌan ña xíꞌin táꞌan ña, ta ya̱chi̱ ní ndiꞌi xa̱ꞌa̱ yichi̱ ña. Ndáto̱ꞌon i̱ to̱ꞌon yóꞌo xíꞌin ndó, chi káchí ndó xíꞌin ndee̱ ñandiva̱ꞌa káꞌno táva i̱ níma̱ ndiva̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ta yi̱ꞌi̱, tá xíꞌin ndee̱ ñaníma̱ ndiva̱ꞌa káꞌno táva i̱ níma̱ ndiva̱ꞌa, níkúu, ta ni̱vi na ndíko̱n sa̱ta̱ ndó, ¿míchí va̱xi ndee̱ na táva na níma̱ ndiva̱ꞌa? Na ndíko̱n sa̱ta̱ ndó káchí na o̱n si̱ví ndee̱ níma̱ ndiva̱ꞌa káꞌno kúu ña kómí na kivi tava na níma̱ ndiva̱ꞌa. Ta saá kixaa̱ ñii ki̱vi̱ ni̱vi na ndíko̱n sa̱ta̱ mi̱i ndó yóꞌo kuu na kasa nani xa̱ꞌa̱ kua̱chi ndíso ndó, chi ñavatá káꞌa̱n ndó xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ta yi̱ꞌi̱, kómí i̱ ndee̱ Ndios ña tava i̱ níma̱ ndiva̱ꞌa, ta ña kéꞌé i̱ yóꞌo káchí ña saá: vitin ki̱xaa̱ ki̱vi̱ ña kíxáꞌá xáꞌnda chiño Ndios no̱o̱ ni̱vi ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Tá yóo ñii ta̱a, ta ndeé ní ndaku ra, ta kómí ra espada náꞌno xíꞌin inka̱ ña xíni̱ ñóꞌó kundaa ra veꞌe ra xíꞌin ndiꞌi ñakuíká ra, ta saá ni̱vi nakuíꞌná o̱n kuchiño na ki̱ꞌvi na ini veꞌe ra. ");
INSERT INTO mim_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tá ñii ki̱vi̱ kixaa̱ inka̱ ta̱a ta̱ ndaku ka̱ no̱o̱ ta̱a ta̱ xíꞌin veꞌe yóꞌo, ta kundeé ra no̱o̱ ta̱ xíꞌin veꞌe yóꞌo, ta kindaa ra ndiꞌi ñakuíká kómí ta̱yóꞌo, ta nataꞌví ra ña xíꞌin natáꞌan ra. Nda̱tán yóo ta̱ ndeé ní ndaku, saá yóo ñaníma̱ ndiva̱ꞌa káꞌno. Ta nda̱tán yóo ta̱ ndeé ka̱ no̱o̱ ra, saá yóo yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ta ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na, káchí ra saá: ―Ndiꞌi ni̱vi na o̱n vása yóo yuꞌú xíꞌin i̱, nayóꞌo kúu na o̱n xi̱in koni na yi̱ꞌi̱. Ta ndiꞌi ni̱vi na o̱n vása chíndeé yi̱ꞌi̱ nakaya na ni̱vi xa̱ꞌa̱ ña kundiko̱n na yichi̱ Ndios, nayóꞌo kúu na sákui̱ta̱ níꞌnó ni̱vi ña o̱n kundiko̱n na yichi̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Tá ñii níma̱ ndiva̱ꞌa sáña ña ñii ta̱a, ta saá kua̱ꞌa̱n ña yuku̱ yi̱chí ña nandukú ña no̱o̱ nakindée ña. Tá o̱n vása náníꞌi ña no̱o̱ nakindée ña, ta xáni ini ña saá: “Ndikó yó ndi̱ꞌvi yó ini ta̱a no̱o̱ ke̱e yó va̱xi yó”, káchí ña. ");
INSERT INTO mim_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ta ndíkó ña, náxaa̱ ña no̱o̱ yóo ta̱a no̱o̱ ke̱e ña. Ta nákoto ña, nda̱tán yóo ñii veꞌe ni̱ti̱ꞌví ta nda̱sa livi na, saá yóo ini ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ta ndíkó níma̱ ndiva̱ꞌa kua̱ꞌa̱n ña, ta nándukú ña inka̱ níma̱ ndiva̱ꞌa. Ta náníꞌi ña u̱xa̱ níma̱ ña ndiva̱ꞌa ní ka̱ no̱o̱ mi̱i ña. Ta ndíkó koo ña ta kua̱ꞌa̱n u̱xa̱ níma̱ ndiva̱ꞌa yóꞌo xíꞌin ña ta kíxaa̱ ndiꞌi ña nakoo ña ini ta̱yóꞌo. Ta saá xóꞌvi̱ ní ka̱ ra vitin no̱o̱ ña siꞌna ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tá káꞌa̱n ka̱ ra xíꞌin ni̱vi, ta ñii ñaꞌa̱ ñá ñíndichi ma̱ꞌñó ndiꞌi ni̱vi, xíꞌin ndiꞌi ndee̱ ñá ni̱ka̱ꞌa̱n ñá xíꞌin ra saá: ―¡Nda̱chun nákaa̱ ñasi̱i̱ ní ini siꞌí ún, chi sa̱kaku ñá yóꞌó ta sa̱kuaꞌno ñá yóꞌó! ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―¡Ta víꞌí ka̱ ñasi̱i̱ nákaa̱ ini ni̱vi na xíni̱ so̱ꞌo to̱ꞌon Ndios ta kísa ndivi na ña! ―káchí ra xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tá kua̱ꞌa̱ ní ni̱vi na̱kutáꞌan na ta ki̱xaa̱ yatin na, ta ta̱Jesús ki̱xáꞌá ra káꞌa̱n ra xíꞌin na, káchí ra saá: ―Ni̱vi na táku̱ ñoyívi yóꞌo vitin kúu na na ndiva̱ꞌa ní ini. Saá chi ndúkú na ñii milagro no̱o̱ i̱ ña kandixa na ndí ta̱a ta̱ ki̱xi no̱o̱ Ndios kúu i̱. Ta o̱n keꞌé i̱ inka̱ milagro ña koto na, chi va̱ꞌa ka̱ xíni̱ ñóꞌó kunda̱a̱ ini na ña ni̱ndoꞌo ta̱profeta Jonás kui̱ya̱ xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Saá chi nañoo Nínive ku̱nda̱a̱ ini na ndasaá ni̱ndoꞌo ta̱Jonás, ta na̱ndikó ini na. Ta ñii ki̱ꞌva saá ni̱vi na táku̱ vitin koni na ña kundoꞌo i̱, ta ni̱vi na kunda̱a̱ ini xa̱ꞌa̱ ñayóꞌo nandikó ini na. ");
INSERT INTO mim_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tá kixaa̱ ki̱vi̱ kasa nani Ndios xa̱ꞌa̱ ni̱vi ñoyívi yóꞌo, ta ñii ñáreina, ñá ni̱xaꞌnda chiño no̱o̱ ñoo na̱ní Sabá xi̱na̱ꞌá, chikaa̱ ñá kua̱chi sa̱ta̱ ndóꞌó na táku̱ vitin. Chi ñáreina yóꞌo xíká ní ni̱xa̱ꞌa̱n ñá xi̱ni̱ so̱ꞌo ñá to̱ꞌon ña ni̱ka̱ꞌa̱n ta̱rey Salomón, chi ta̱ ndíchí ní si̱ni̱ xi̱kuu ra. Ta yi̱ꞌi̱, ta̱ yóo xíꞌin ndó vitin, kúu ñii ta̱káꞌno ka̱ no̱o̱ ta̱Salomón, ta o̱n xi̱in ndó koni̱ so̱ꞌo ndó ña káꞌa̱n i̱. ");
INSERT INTO mim_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tá kixaa̱ ki̱vi̱ kasa nani Ndios xa̱ꞌa̱ na ñoyívi yóꞌo, ta saá tuku nañoo Nínive chikaa̱ na kua̱chi sa̱ta̱ ndóꞌó na táku̱ vitin. Saá chi xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱Jonás xíꞌin na, ta na̱ndikó ini na ta ka̱ndixa na Ndios. Ta yi̱ꞌi̱, ta̱a ta̱ yóo xíꞌin ndó vitin, kúu ñii ta̱káꞌno ka̱ no̱o̱ ta̱Jonás, ta o̱n xi̱in ndó koni̱ so̱ꞌo ndó to̱ꞌon ña káꞌa̱n i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, káchí ra saá: ―Ta ni̱vi, tá nátoo̱n na ñoꞌo̱, ta o̱n vása chíkaa̱ seꞌé na ña, ta chínóo na ña no̱o̱ síkón ña va̱ꞌa nayeꞌe ña, ta ndiꞌi ni̱vi na ki̱ꞌvi veꞌe kuchiño koto na. ");
INSERT INTO mim_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nda̱tán yóo ñoꞌo̱ ña yéꞌe, saá yóo nduchu̱ no̱o̱ yó. Tá va̱ꞌa yóo nduchu̱ no̱o̱ ndó, ta va̱ꞌa yéꞌe ndiꞌi ini ndó, saá va̱ꞌa kúnda̱a̱ ini ndó ñanda̱a̱. Tá o̱n vása va̱ꞌa yóo nduchu̱ no̱o̱ ndó, ta naa ní ini ndó. ");
INSERT INTO mim_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ña̱kán kía̱ xíni̱ ñóꞌó koto va̱ꞌa xíꞌin mi̱i ndó án ndixa xíka ndó no̱o̱ yéꞌe. Tá xáni si̱ni̱ ndó xíka ndó xíꞌin ñoꞌo̱ yéꞌe, ta o̱n si̱ví ñanda̱a̱ kúu ña, ta saá, ¡nda̱chun naa ní ini ndó! ");
INSERT INTO mim_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tá ndixa yéꞌe ñoꞌo̱ ini ndó, ta nda̱ loꞌo o̱n vása naa ini ndó, ta saá ñoꞌo̱ ña yéꞌe ini ndó nda̱tán yóo ñii ñoꞌo̱ káꞌno yéꞌe no̱o̱ xíka ndó, saá koo ña. ");
INSERT INTO mim_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ta ndi̱ꞌi ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, ta ñii ta̱fariseo ka̱na ra ta̱Jesús ko̱ꞌo̱n ra veꞌe ra kuxu ra. Ta ta̱Jesús kua̱ꞌa̱n ra xíꞌin ta̱fariseo veꞌe ra, ta ni̱xaa̱ ra, ta xi̱koo ra kuxu ra. ");
INSERT INTO mim_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ta na̱kaꞌnda ini ta̱fariseo xíto ra o̱n vása ní‑ndaꞌá ta̱Jesús, nda̱tán ki̱ꞌva yóo nda̱yí mi̱i na. ");
INSERT INTO mim_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Ndóꞌó nafariseo nákata ndó sa̱ta̱ vaso xíꞌin sa̱ta̱ ko̱ꞌo̱. Ta ini mi̱i ndó chútú ní ñakuíꞌná xíꞌin ña o̱n váꞌa. ");
INSERT INTO mim_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Nda̱chun kíꞌví ní ndó! ¿Án o̱n vása xíni̱ ndó mi̱i Ndios, ta̱a ta̱ ki̱sa va̱ꞌa ña kúu sa̱ta̱ yó, mi̱i ra kúu ta̱ ki̱sa va̱ꞌa ini yó? ");
INSERT INTO mim_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tá ndinoꞌo ini ndó taxi ndó ñava̱ꞌa ndó ña chindeé ndó nandáꞌví, ta saá ndundii ini ndó. ");
INSERT INTO mim_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, nafariseo! Vará táxi ndó ndaꞌa̱ Ndios ñii koꞌndo ña ta̱va ndó ti̱xin ña u̱xu̱ koꞌndo ña kúu ñii ñii no̱o̱ yu̱ku̱ válí ña xíxi yó, ta o̱n vása kísa ndivi ndó chiño ña xíni̱ ñóꞌó ní no̱o̱ Ndios. Chi no̱o̱ Ndios ña xíni̱ ñóꞌó ní kúu ña keꞌé yó ñanda̱a̱ xíꞌin inka̱ ni̱vi, ta kukiꞌvi ini yó koni yó Ndios. Xíni̱ ñóꞌó kasa ndivi ndó chiño náꞌno yóꞌo no̱o̱ Ndios, ta saá ni, o̱n sandakoo ndó kasa ndivi ndó inka̱ chiño válí no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, nafariseo! Kútoo ní ndó kundo̱o ndó táyi̱ tón náꞌno tón to̱ꞌó yóo veꞌe ño̱ꞌo sinagoga. Saá tá xíka ndó no̱yáꞌvi, ta kóni ndó ña kasa to̱ꞌó ní ni̱vi ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, nafariseo xíꞌin natáꞌan ndó! Saá chi nda̱tán yóo ñoꞌo̱ no̱o̱ ni̱ndu̱xu̱n na ni̱xiꞌi̱, ta o̱n vása tívi ña táꞌyí ñóꞌo ti̱xin ñoꞌo̱, saá yóo ndóꞌó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ta ñii ta̱maestro ta̱ xíni̱ va̱ꞌa nda̱yí Ndios ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Tá chíkaa̱ ún kua̱chi sa̱ta̱ nafariseo yóꞌo, ta ñii ki̱ꞌva saá chíkaa̱ ún kua̱chi sa̱ta̱ ndi̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra saá: ―¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, na xíni̱ va̱ꞌa nda̱yí Ndios! Chi sákuiso ndó ni̱vi chiño veé ní, ta yo̱ꞌvi̱ ní kuiso na. Ta mi̱i ndó, nda̱ loꞌo o̱n xi̱in ndó tindaa ndó chiño veé ta yo̱ꞌvi̱ ní yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, na xíni̱ va̱ꞌa nda̱yí Ndios! ¡Na o̱vi̱ yuꞌu̱ kúu ndó! Livi ní kísa va̱ꞌa ndó veꞌe no̱o̱ ni̱ndu̱xu̱n naprofeta xi̱na̱ꞌá. Ta naxi̱i̱ síkuá mi̱i ndó kúu na xa̱ꞌni naprofeta yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Xíꞌin ñayóꞌo kúnda̱a̱ ini yó ñii kúu ini ndó xíꞌin ini naxi̱i̱ síkuá ndó. Chi naxi̱i̱ síkuá ndó kúu na xa̱ꞌni naprofeta xi̱na̱ꞌá, ta ndóꞌó kúu na kísa va̱ꞌa veꞌe no̱o̱ ni̱ndu̱xu̱n na. ");
INSERT INTO mim_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ña̱kán kía̱ Ndios ni̱ka̱ꞌa̱n ra to̱ꞌon ndíchí xa̱ꞌa̱ ndó saá: “Tiꞌví i̱ naprofeta ña ka̱ꞌa̱n ndoso na to̱ꞌon i̱ xíꞌin nañoo Israel, ta tiꞌví i̱ naapóstol ña kasa ndivi na chiño i̱, ta nañoo yóꞌo, o̱n kuaꞌa na nakiꞌin va̱ꞌa na nda̱ ñii na tiꞌví i̱, ta kaꞌni na sava na, ta saxo̱ꞌvi̱ na inka̱ na”, ka̱chí Ndios. ");
INSERT INTO mim_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ta sa̱ta̱ mi̱i ndó ni̱vi na táku̱ vitin, nakava kua̱chi xa̱ꞌa̱ ña ni̱xi̱ta̱ ni̱i̱ ndiꞌi naprofeta, tá nda̱ ki̱xáꞌá ki̱vi̱ no̱ó ta̱nda̱ vitin. ");
INSERT INTO mim_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Saá chi ki̱xáꞌá ña xíꞌin ña ni̱xiꞌi̱ ta̱Abel, ta ndi̱ꞌi ña xíꞌin ña ni̱xiꞌi̱ ta̱Zacarías. Ta naxi̱i̱ síkuá ndó xa̱ꞌni na ta̱Zacarías ki̱vi̱ xi̱ndichi ra ma̱ꞌñó ña kúu yéꞌé veꞌe ño̱ꞌo káꞌno xíꞌin ña kúu na̱ma̱ yi̱i̱ no̱o̱ sóko̱ na ña̱ꞌa no̱o̱ Ndios. Ta ndixa káꞌa̱n i̱ xíꞌin ndó, sa̱ta̱ mi̱i ndó na táku̱ vitin, nakava kua̱chi xa̱ꞌa̱ ña ni̱xi̱ta̱ ni̱i̱ ndiꞌi nava̱ꞌa yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Ñii ki̱vi̱ xo̱ꞌvi̱ ní ndóꞌó, na xíni̱ va̱ꞌa nda̱yí Ndios! Nda̱tán kéꞌé ñii ta̱a ta̱ chíkaa̱ seꞌé llave, saá kéꞌé ndó. Saá chi sási ndó no̱o̱ ni̱vi na kóni ki̱ꞌvi yichi̱ Ndios, ta ni mi̱i ndó xi̱in ndó ki̱ꞌvi ndó yichi̱ ra ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tá káꞌa̱n ta̱Jesús xíꞌin na, ta nafariseo xíꞌin inka̱ na sánáꞌa nda̱yí Ndios, ni̱saa̱ ní na, ta ki̱xáꞌá na sándiꞌi ní na ra xíꞌin to̱ꞌon, ");
INSERT INTO mim_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","chi kóni na ña nakava ra ka̱ꞌa̱n ra to̱ꞌon ña o̱n váꞌa, ta saá kuchiño na taxi na kua̱chi xa̱ꞌa̱ ra no̱o̱ nachiño. ");
INSERT INTO mim_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kua̱ꞌa̱ ní mil ni̱vi na̱kutáꞌan na no̱o̱ ta̱Jesús, ñii chútú nda̱a̱ na ta̱nda̱ xíndo̱so̱ na xa̱ꞌa̱ táꞌan na. Ta ta̱Jesús ki̱xáꞌá ra káꞌa̱n ra xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Koto va̱ꞌa ndó o̱n ko̱ꞌo̱n ndó yichi̱ nafariseo, chi na o̱vi̱ yuꞌu̱ kúu na. Nda̱tán yóo levadura ña kísa chiño seꞌé xíꞌin yuxa̱n, saá yóo yichi̱ nafariseo. ");
INSERT INTO mim_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta nda̱ ñii ña nákaa̱ seꞌé o̱n kívi koo seꞌé ña ndiꞌi saá ki̱vi̱, chi ñii ki̱vi̱ nati̱vi ña. Ndiꞌi ña ndási̱ no̱o̱ ni̱vi, ta va̱xi ki̱vi̱ koni̱ ndiꞌi na ñayóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ñii ki̱vi̱ ndiꞌi to̱ꞌon ña ni̱ka̱ꞌa̱n seꞌé ndó no̱o̱ naa, koni̱ so̱ꞌo ndiꞌi ni̱vi ñayóꞌo ki̱vi̱ ndiví yéꞌe ño̱ꞌo. Ta to̱ꞌon ña ni̱ka̱ꞌa̱n ya̱a̱ ndó xíꞌin natáꞌan ndó ini veꞌe ndó, ta va̱xi ki̱vi̱ ndaa ni̱vi si̱ni̱ veꞌe na, ta ka̱ꞌa̱n ndoso na to̱ꞌon yóꞌo ña koni̱ so̱ꞌo ndiꞌi inka̱ ni̱vi ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Saá ni̱ka̱ꞌa̱n ka̱ ta̱Jesús: ―O̱n kuyi̱ꞌví ndó no̱o̱ ni̱vi na kóni kaꞌni ndóꞌó, chi o̱n kúchiño na sandiꞌi na xa̱ꞌa̱ níma̱ ndó. ");
INSERT INTO mim_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Va̱ꞌa ka̱ kuyi̱ꞌví ndó no̱o̱ Ndios, chi Ndios kivi sandiꞌi ra xa̱ꞌa̱ yi̱kí ko̱ñu ndó, ta kómí ra ndee̱ sakana ra ndóꞌó nda̱ya. Ña̱kán kía̱, va̱ꞌa ka̱ kuyi̱ꞌví ndó no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Koto ndó tísaa válí: o̱vi̱ si̱ꞌún válí kúu yaꞌvi o̱ꞌo̱n rí. Ta Ndios o̱n vása nándoso ra xa̱ꞌa̱ nda̱ ñii tísaa loꞌo yóꞌo, ta ndáa ra ndiꞌi rí. ");
INSERT INTO mim_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ta ndóꞌó, Ndios ma̱ni̱ ní ka̱ ra ndóꞌó, chi xíni̱ ndiꞌi ra ndasaá kúu yisi̱ si̱ni̱ ndó. Ta ndixa ndáa va̱ꞌa ra ndóꞌó, ña̱kán o̱n kuyi̱ꞌví ndó, chi kua̱ꞌa̱ ní ka̱ ndáya̱ꞌví ndó no̱o̱ tísaa válí ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ta saá ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin na, káchí ra saá: ―Ni̱vi na ndákuii̱n xa̱ꞌa̱ i̱ no̱o̱ ni̱vi ñoyívi yóꞌo, ta yi̱ꞌi̱, ñii ki̱ꞌva saá ndakuii̱n i̱ xa̱ꞌa̱ na no̱o̱ naángel xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ta ni̱vi na o̱n xi̱in ndakuii̱n xa̱ꞌa̱ i̱, ta yi̱ꞌi̱ o̱n ndakuii̱n i̱ xa̱ꞌa̱ nayóꞌo no̱o̱ naángel xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Ta ndiꞌi ni̱vi na káꞌa̱n to̱ꞌon ndiva̱ꞌa xíꞌin yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ta Ndios kúchiño kasa káꞌno ini ra xa̱ꞌa̱ na. Ta ndiꞌi ni̱vi na káꞌa̱n to̱ꞌon ndiva̱ꞌa xíꞌin Níma̱ Ndios, ta Ndios o̱n kasa káꞌno ini ra xa̱ꞌa̱ ni̱vi yóꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ta ni̱ka̱ꞌa̱n ka̱ ra xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Tá tiin na ndóꞌó ko̱ꞌo̱n ndó xíꞌin na, ta taxi na kua̱chi xa̱ꞌa̱ ndó no̱o̱ nachiño án no̱o̱ nanáꞌno veꞌe ño̱ꞌo sinagoga, ta o̱n kundiꞌi ini ndó xa̱ꞌa̱ to̱ꞌon ña ndakuii̱n ndó. ");
INSERT INTO mim_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Saá chi mi̱i ki̱vi̱ ña kundoꞌo ndó ñayóꞌo, Níma̱ Ndios taxi ña to̱ꞌon ña ka̱ꞌa̱n ndó ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ñii ta̱a ta̱ yóo xíꞌin ndiꞌi ni̱vi na ndóo xíni̱ so̱ꞌo ña káꞌa̱n ta̱Jesús, ki̱xaa̱ ra no̱o̱ ra ta ni̱ka̱ꞌa̱n ra xíꞌin ra saá: ―Tata maestro, ka̱ꞌa̱n ún xíꞌin ñani i̱ ndí xíni̱ ñóꞌó nataꞌví ra ñakuíká ña ki̱ndo̱o ki̱vi̱ ni̱xiꞌi̱ yivá ndi̱, ta taxi ra loꞌo ñakuíká yóꞌo ndaꞌa̱ i̱ ―káchí ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra saá: ―Tata, ¿nda̱chun xáni ini ún yi̱ꞌi̱ kúu ta̱chiño án juez ta̱ táꞌví ñakuíká xíꞌin ndó? ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ndiꞌi ni̱vi na ndóo yóꞌo: ―Kasa kuenda xíꞌin mi̱i ndó ña o̱n vása kútoo ndó koo kua̱ꞌa̱ ní ñakuíká ndaꞌa̱ ndó. Saá chi tá kómí ndó víꞌí ní ñakuíká, ta o̱n vása chíndeé ñakuíká ndóꞌó ña kutaku̱ va̱ꞌa ndó no̱o̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ta saá ni̱ka̱ꞌa̱n ra ñii cuento ña sanáꞌa ra na: ―Saá ndo̱ꞌo ñii ta̱a ta̱kuíká, ta̱ kómí kua̱ꞌa̱ ní ñoꞌo̱. Ta va̱ꞌa ní ke̱ta ra xíꞌin ña chi̱ꞌi ra, ta chútú veꞌe ra xíꞌin ña kuxu ra. ");
INSERT INTO mim_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ta ki̱xáꞌá ra xáni ini ra: “¿Yukía̱ keꞌé yó vitin? O̱n vása yóo ka̱ míchí taxi va̱ꞌa yó ña kómí yó”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ta saá ni̱ka̱ꞌa̱n ra: “¡Áan! Xíni̱ va yó mí taxi va̱ꞌa yó ña. Sandiꞌi yó xa̱ꞌa̱ veꞌe yatá, ta kasa va̱ꞌa yó inka̱ veꞌe xa̱á ña káꞌno ka̱ no̱o̱ kunani koꞌon ndiꞌi ndiki̱n trigo mi̱i yó, xíꞌin ndiꞌi ka̱ ña kómí yó. ");
INSERT INTO mim_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ta ndi̱ꞌi na̱koo va̱ꞌa ña kómí yó, ta ka̱ꞌa̱n yó xíꞌin mi̱i yó, kachí yó saá: Vitin yóo kua̱ꞌa̱ ní ña kómí yó, ta náni ñayóꞌo kuxu yó kua̱ꞌa̱ ní kui̱ya̱. Ta va̱ꞌa ní kuiti nakindée yó, kuxu va̱ꞌa yó, koꞌo va̱ꞌa yó, ña kusii̱ ní ini yó chi yóo víꞌí ní ña kómí yó”, xáni ini ta̱kuíká yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ta ni̱ka̱ꞌa̱n Ndios xíꞌin ra: “¡Yóꞌó kúu ta̱a ta̱ kíꞌví!, saá chi ñoó vitin kivi̱ ún. Ta ndiꞌi ña kómí ún, ñava̱ꞌa inka̱ ni̱vi nduu ña”, ka̱chí Ndios xíꞌin ra. Saá ndi̱ꞌi cuento loꞌo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nda̱tán ndo̱ꞌo ta̱kuíká yóꞌo, saá kundoꞌo ndiꞌi ni̱vi na kómí ñakuíká ñoyívi yóꞌo, tá o̱n vása kómí na ñakuíká ndinoꞌo ñoyívi ni̱no xíꞌin Ndios ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra: ―Ta káꞌa̱n i̱ xíꞌin ndó, o̱n kundiꞌi ini ndó xa̱ꞌa̱ ña xíni̱ ñóꞌó kutaku̱ ndó, ni o̱n kundiꞌi ini ndó mí kixi ña kuxu ndó, ni o̱n kundiꞌi ini ndó xa̱ꞌa̱ tiko̱to̱ ña kundixin ndó ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Saá chi níma̱ yó ndáya̱ꞌví ní ka̱ ña no̱o̱ ña xíxi yó. Ta yi̱kí ko̱ñu yó ndáya̱ꞌví ní ka̱ ña no̱o̱ tiko̱to̱ yó. ");
INSERT INTO mim_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Koto ndó ndasaá táku̱ títika̱ka, ni o̱n vása chíꞌi rí, ni o̱n vása nákaya rí ña xáxi rí, ta o̱n ko̱ó veꞌe rí no̱o̱ táan va̱ꞌa rí ña xáxi rí. Ta Ndios táxi ra ña xáxi títika̱ka yóꞌo. Ta ndóꞌó, ndáya̱ꞌví ní ka̱ ndó no̱o̱ títika̱ka yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ta ndóꞌó, o̱n si̱ví xíꞌin ña ndíꞌi ní ini ndó kúu ña kúchiño ndó sakuaꞌno síkón ka̱ ndó xíꞌin mi̱i ndó, chi ñii la̱á Ndios kúu ta̱ xáꞌnda chiño ndasaá ki̱ꞌva síkón koo ndó. ");
INSERT INTO mim_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","O̱n vása kúchiño ndó keꞌé ndó ñayóꞌo, vará loꞌo ní chiño kúu ña. Ta saá, ¿nda̱chun ndíꞌi ní ka̱ ini ndó xa̱ꞌa̱ inka̱ ña̱ꞌa? ");
INSERT INTO mim_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Koto ndó ndasaá livi ndáxaa yita ña yóo yuku̱; yita yóꞌo o̱n vása kísa chiño ña, ni o̱n vása kísa va̱ꞌa ña tiko̱to̱ ña. Ta ndixa káꞌa̱n i̱ xíꞌin ndó, vará ta̱rey Salomón, ta̱kuíká ní xi̱kuu ra, ta xi̱komí ní ra kua̱ꞌa̱ ní tiko̱to̱ va̱ꞌa, ta yita ña yóo yuku̱, livi ní ka̱ ña no̱o̱ tiko̱to̱ va̱ꞌa ña xi̱ndixin ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Vará nda̱ loꞌo ki̱vi̱ táku̱ yita válí yuku̱, chi ñii ki̱vi̱ ndáxaa ña, ta inka̱ ki̱vi̱ ndáꞌva̱ ña, ta saá táan na ña ini xi̱to̱n ko̱ko̱ ña, ta Ndios ndáa ra ña, ta livi ndátón sákundixin ra ña. Ñayóꞌo sánáꞌa ndí Ndios ndáa va̱ꞌa ra ndóꞌó, chi ndóꞌó ndáya̱ꞌví ní ka̱ ndó no̱o̱ yita válí. ¡Nda̱chun loꞌo ní kándixa ndó Ndios ña kundaa ra ndóꞌó! ");
INSERT INTO mim_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","O̱n kundiꞌi ini ndó xa̱ꞌa̱ mí kixi ña kuxu ndó, án mí kixi ña koꞌo ndó, án mí kixi inka̱ ña xíni̱ ñóꞌó ndó. ");
INSERT INTO mim_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Chi ni̱vi na o̱n vása ndíko̱n Ndios kúu ni̱vi na ndíꞌi ní ini xa̱ꞌa̱ ñayóꞌo. Ta Yivá yó Ndios xíni̱ va̱ꞌa ra yu kúu ndiꞌi ña xíni̱ ñóꞌó no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ta mi̱i ndó, ndinoꞌo ini ndó ná kundiko̱n ndó yichi̱ no̱o̱ xáꞌnda chiño Ndios, ta ndixa Ndios taxi ndiꞌi ra ña xíni̱ ñóꞌó ndaꞌa̱ ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ta ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Nda̱tán yóo ñii tiꞌvi ndikachi sa̱na̱ i̱, saá yóo ndóꞌó. Ta o̱n kuyi̱ꞌví ndó, chi kúsii̱ ini Ndios taxi ra ndaꞌa̱ ndó ñava̱ꞌa kómí ra no̱o̱ xáꞌnda chiño ra. ");
INSERT INTO mim_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Si̱kó ndó ña kómí ndó, ta taxi ndó si̱ꞌún ndaꞌa̱ ni̱vi nandáꞌví. Ta saá kukomí ndó ñakuíká ndinoꞌo ñoyívi ni̱no xíꞌin Ndios. Ta nda̱ ñii ki̱vi̱ o̱n ndiꞌi xa̱ꞌa̱ ñakuíká yóꞌo, chi ñoyívi ni̱no o̱n ko̱ó tikisin, ni o̱n kuxéꞌé ña̱ꞌa, ni nakuíꞌná o̱n ki̱ví kasa kuíꞌná na ñakuíká ndinoꞌo ña yóo ñoyívi ni̱no. ");
INSERT INTO mim_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Saá chi no̱o̱ ñóꞌo ñakuíká kómí ndó, kán yóo níma̱ ndó xíꞌin si̱ni̱ ndó. ");
INSERT INTO mim_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Ndiꞌi saá ki̱vi̱ namozo ndíxin na tiko̱to̱ ta níꞌi na ñoꞌo̱ náyeꞌe, saá yóo tiꞌva na nakiꞌin na ta̱káꞌno no̱o̱ na. Ta nda̱tán ndóo tiꞌva namozo yóꞌo, saá koo tiꞌva ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ndáti namozo yóꞌo ña ndikó ta̱káꞌno no̱o̱ na, chi kua̱ꞌa̱n ra viko̱ tonda̱ꞌa̱. Ta nda̱tán ndáti nayóꞌo saá kundati ndóꞌó ña ndikó i̱. Saá chi nda̱ ndá hora ndikó ta̱káꞌno ta kani ra yéꞌé, ta ndóo tiꞌva namozo ra ña xa̱ndi̱ko̱n nakuiná na yéꞌé no̱o̱ ra, ta nakiꞌin va̱ꞌa na ra. ");
INSERT INTO mim_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ta kunakaa̱ ñasi̱i̱ níma̱ namozo tá o̱n vása kísi̱n na, ta yóo tiꞌva na nakuiná na yéꞌé ña ki̱ꞌvi ta̱káꞌno no̱o̱ na. Ndixa káꞌa̱n i̱ xíꞌin ndó, ta̱káꞌno yóꞌo katón ra toalla ti̱xin ra, ta chinóo ra ñaxíxi no̱o̱ mesa ña kuxu namozo ra. ");
INSERT INTO mim_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ta kunakaa̱ ñasi̱i̱ níma̱ namozo tá kundo̱o tiꞌva na nda̱ ndá hora ndikó ta̱káꞌno, án ma̱ꞌñó ñoó, án xa va̱xi ti̱vi. ");
INSERT INTO mim_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ta kunda̱a̱ va̱ꞌa ini ndó ñayóꞌo: Tá ñii ta̱a yóo ra veꞌe ra, ta xíni̱ ra ama kixaa̱ ta̱kuíꞌná, ta saá koo tiꞌva ra ta o̱n taxi ra ki̱ꞌvi ta̱kuíꞌná yóꞌo kasa kuíꞌná ra ña yóo veꞌe ra. ");
INSERT INTO mim_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Saá tuku ndóꞌó, xíni̱ ñóꞌó kundo̱o tiꞌva ndó, chi ndikó i̱ ñoyívi yóꞌo ñii ki̱vi̱ ña o̱n vása ndáti ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ta ta̱Pedro ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús, ni̱ka̱ꞌa̱n ra saá: ―Tata, ¿án ndasaá xíꞌin mi̱i ndi̱ naxíka xíꞌin ún nda̱to̱ꞌon cuento yóꞌo, án nda̱to̱ꞌon ún ña xa̱ꞌa̱ ña sanáꞌa ún inka̱ ni̱vi? ―káchí ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―¿Ndasaá keꞌé ñii ta̱káꞌno xíꞌin ñii ta̱a ta̱ kísa chiño xíꞌin ndinoꞌo ini no̱o̱ ra? Ta ta̱káꞌno yóꞌo sakuiso chiño ra ta̱yóꞌo ña taxi ta̱yóꞌo kuxu ni̱vi na yóo veꞌe ta kasa kuenda ra xíꞌin veꞌe yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ta saá kunakaa̱ ñasi̱i̱ níma̱ ta̱ kísa chiño xíꞌin ndinoꞌo ini ki̱vi̱ ndikó ta̱káꞌno no̱o̱ ra, ta koto ra va̱ꞌa ní ki̱sa ndivi ra chiño. ");
INSERT INTO mim_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta ndixa káꞌa̱n i̱ xíꞌin ndó, ta̱káꞌno yóꞌo taxi ra ndaꞌa̱ ta̱ kísa chiño ndinoꞌo ini, ña kuiso chiño ra xíꞌin ndiꞌi ña̱ꞌa veꞌe ta̱káꞌno yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tá yóo ñii ta̱a ta o̱n vása kísa chiño ra xíꞌin ndinoꞌo ini ra, ta xáni si̱ni̱ ra saá: “Xa naꞌá ní kuáchi̱ ta̱káꞌno no̱o̱ yó, o̱n vása xíni̱ yó ndá ki̱vi̱ ndikó ra”, xáni si̱ni̱ ra. Ta saá kíxáꞌá ra ndiꞌi saá ki̱vi̱ káni ra nata̱a xíꞌin náñaꞌa̱ na kísa chiño xíꞌin ra, ta ñii ki̱ꞌva saá kíxáꞌá ra ndiꞌi saá ki̱vi̱ xíxi ní ra, ta xíꞌi ní ra, nina ta̱xíini kúu ra. ");
INSERT INTO mim_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ta ñii ki̱vi̱ o̱n vása ndáti ra, ni hora ña o̱n vása yóo tiꞌva ra, ta ndikó ta̱káꞌno no̱o̱ ra. Ta ta̱káꞌno no̱o̱ ra yóꞌo saxo̱ꞌvi̱ ní ñaꞌá ra, ta tiꞌví ñaꞌá ra ko̱ꞌo̱n ra no̱o̱ ndóo ni̱vi na o̱n váꞌa, na o̱n vása kísa ndivi ña xáꞌnda chiño ta̱káꞌno no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Tá yóo ñii ta̱mozo, ta xa xíni̱ ra yukía̱ kóni ta̱káꞌno no̱o̱ ra, ta o̱n vása ní‑xiin ra kasa ndivi ra ña, ni o̱n vása ní‑xiyo tiꞌva ra ki̱vi̱ ndikó ta̱káꞌno no̱o̱ ra, ta saá ndeé ní xo̱ꞌvi̱ ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ta inka̱ ta̱mozo, vará kéꞌé ra ña o̱n váꞌa, chi o̱n vása xíni̱ ra yukía̱ kóni ta̱káꞌno no̱o̱ ra, ta loꞌo xo̱ꞌvi̱ ra. Saá chi tá Ndios táxi ra kua̱ꞌa̱ ní ñava̱ꞌa ndaꞌa̱ ni̱vi, ta ndáti ra nayóꞌo kasa ndivi na kua̱ꞌa̱ ní chiño va̱ꞌa. Tá Ndios sákuiso víꞌí ní ka̱ chiño ni̱vi, ta ndáti ra nayóꞌo kasa ndivi na kua̱ꞌa̱ ní ka̱ chiño va̱ꞌa ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ta ni̱ka̱ꞌa̱n ta̱Jesús saá: ―Nda̱tán yóo ñoꞌo̱ ña xáꞌmi mi̱ꞌí, saá koo chiño ña kasa ndivi i̱ ñoyívi yóꞌo. ¡Kóni i̱ kama ní to̱nda̱a ki̱vi̱ ña kasa ndivi i̱ chiño yóꞌo! ");
INSERT INTO mim_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Xíni̱ ñóꞌó xo̱ꞌvi̱ ní i̱, ta ndíꞌi ní ini i̱ nda̱ kixaa̱ ki̱vi̱ ña xo̱ꞌvi̱ ní i̱. ");
INSERT INTO mim_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","O̱n kani si̱ni̱ ndó ndí ña kundo̱o va̱ꞌa ndó xíꞌin natáꞌan ndó, kúu ña ki̱xaa̱ i̱ ñoyívi yóꞌo, chi xa̱ꞌa̱ ña nataꞌví i̱ ni̱vi kúu ña ki̱xaa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chi ndiꞌi ki̱vi̱ ña va̱xi ñii veꞌe o̱n vása koo yuꞌú ndiꞌi na xa̱ꞌa̱ i̱. Tá ndóo o̱ꞌo̱n ni̱vi ñii veꞌe, ta u̱ni̱ na kundiko̱n yi̱ꞌi̱, ta o̱vi̱ na o̱n vása kándixa na yi̱ꞌi̱. Tá o̱vi̱ na ko̱ꞌo̱n yichi̱ i̱, ta u̱ni̱ na o̱n vása kándixa na yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Vará naveꞌe kúu na, o̱n kívi koo yuꞌú na: ñii ta̱a ko̱ꞌo̱n ra yichi̱ i̱, ta sa̱ꞌya ra ta̱loꞌo ko̱ꞌo̱n ra inka̱ yichi̱; ñii ta̱loꞌo ko̱ꞌo̱n ra yichi̱ i̱, ta yivá ra ko̱ꞌo̱n ra inka̱ yichi̱; ñii ñaꞌa̱ ko̱ꞌo̱n ñá yichi̱ i̱, ta sa̱ꞌya ñá ñáloꞌo ko̱ꞌo̱n ñá inka̱ yichi̱; ñii ñáloꞌo ko̱ꞌo̱n ñá yichi̱ i̱, ta siꞌí ñá ko̱ꞌo̱n ñá inka̱ yichi̱; ñii ñaꞌa̱ ko̱ꞌo̱n ñá yichi̱ i̱, ta xa̱no ñá ko̱ꞌo̱n inka̱ yichi̱; ñii ñaꞌa̱ ko̱ꞌo̱n ñá yichi̱ i̱, ta si̱so ñá ko̱ꞌo̱n inka̱ yichi̱. Ta saá kunda̱a̱ ini yó ndí o̱n vása ki̱ví koo yuꞌú ni̱vi xa̱ꞌa̱ i̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin kua̱ꞌa̱ ní ni̱vi na ndóo xíꞌin ra: ―Tá xíto ndó va̱xi vi̱ko̱ no̱o̱ kua̱n ke̱tá ño̱ꞌo, ta xíni̱ ndó yukía̱ koo, chi kachí ndó ya̱chi̱ ní koon sa̱vi̱, ta ñanda̱a̱ kía̱. ");
INSERT INTO mim_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tá xíto ndó va̱xi ta̱chi̱ chí sur, ta saá kachí ndó ñiꞌní ní koo ki̱vi̱ vitin, ta ñanda̱a̱ kía̱. ");
INSERT INTO mim_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Ni̱vi na o̱vi̱ yuꞌu̱ kúu ndó!, chi xíni̱ ndó yukía̱ koo tá xíka ta̱chi̱, ta xíni̱ ndó yukía̱ koo tá xíto ndó va̱xi vi̱ko̱. ¿Nda̱chun o̱n vása kúnda̱a̱ ini ndó yukía̱ kóni kachí ña xíto ndó xíꞌin ña xíni̱ so̱ꞌo ndó kéꞌé i̱ vitin? ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","―¿Nda̱chun o̱n vása kasa nani mi̱i ndó kua̱chi xíꞌin ñava̱ꞌa ñanda̱a̱? ");
INSERT INTO mim_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tá ñii ni̱vi kóni na taxi na kua̱chi xa̱ꞌa̱ ndó no̱o̱ nachiño, tá ta̱ꞌán ka̱ xaa̱ ndó veꞌe chiño, ta kama ndukú ndeé ndó kasa nani ndó kua̱chi xíꞌin na. Saá chi tá o̱n kasa nani ndó kua̱chi xíꞌin na, ta yi̱yo nataxi na ndóꞌó ndaꞌa̱ ta̱juez. Ta ta̱juez nataxi ra ndóꞌó ndaꞌa̱ ta̱policía, ta ko̱ꞌo̱n ndó veꞌe ka̱a. ");
INSERT INTO mim_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ndixa káꞌa̱n i̱ xíꞌin ndó, o̱n kee ya̱chi̱ ndó veꞌe ka̱a chi o̱n tava na ndóꞌó a̱nda̱ ná chaꞌvi ndó ndiꞌi si̱ꞌún ña níká ndó ―káchí ta̱Jesús xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mi̱i ki̱vi̱ yóꞌo, sava ni̱vi ke̱e na kua̱ꞌa̱n na, ta ni̱xaa̱ na no̱o̱ ta̱Jesús. Ta saá ki̱xáꞌá na káꞌa̱n na xíꞌin ra: ―Sava na estado Galilea na ñóꞌo yéꞌé veꞌe ño̱ꞌo káꞌno ña nákaa̱ ñoo Jerusalén, xa̱ꞌni na kiti̱ tí sóko̱ na ndaꞌa̱ Ndios. Ta ta̱gobernador Pilato xa̱ꞌnda chiño ra no̱o̱ natropa kaꞌni na ndiꞌi ni̱vi yóꞌo. Ta saá ni̱i̱ ni̱vi na ni̱xiꞌi̱ yóꞌo xíꞌin ni̱i̱ kiti̱ tí xa̱ꞌni na na̱sa̱ka̱ ña ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ta nda̱kuii̱n ta̱Jesús, káꞌa̱n ra xíꞌin na: ―¿Án xáni ini ndó ni̱vi na estado Galilea yóꞌo xi̱kuu ni̱vi na o̱n váꞌa ní ka̱ no̱o̱ inka̱ ni̱vi, ña̱kán ni̱xiꞌi̱ na saá? ");
INSERT INTO mim_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Óꞌon, o̱n si̱ví na o̱n váꞌa ní ka̱ ni̱‑xikuu na no̱o̱ inka̱ ni̱vi. Ta mi̱i ndó, tá o̱n xi̱in ndó nandikó ini ndó ta sandakoo ndó ña o̱n váꞌa kéꞌé ndó, ta saá tuku ndiꞌi xa̱ꞌa̱ ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Yukía̱ xáni si̱ni̱ ndó xa̱ꞌa̱ xa̱ꞌo̱n u̱ni̱ ni̱vi na ni̱xiꞌi̱ chi na̱kava torre ñoo Siloé sa̱ta̱ na? ¿Án xáni ini ndó na ni̱xiꞌi̱ yóꞌo xi̱kuu na ni̱vi o̱n váꞌa ní ka̱ no̱o̱ inka̱ nañoo Jerusalén? ");
INSERT INTO mim_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Óꞌon, o̱n si̱ví saá. Ta ndóꞌó, tá o̱n xi̱in ndó nandikó ini ndó, ta sandakoo ndó ña o̱n váꞌa kéꞌé ndó, ta saá tuku ndiꞌi xa̱ꞌa̱ ndóꞌó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ta saá ta̱Jesús nda̱to̱ꞌon ra ñii cuento xíꞌin na xa̱ꞌa̱ ña sanáꞌa ra na, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Saá ndo̱ꞌo ñii ta̱a xíꞌin yito̱n tón higo, tón ñíndichi no̱o̱ ñoꞌo̱ ra. Ñii ki̱vi̱ ki̱xaa̱ ra nándukú ra kui̱ꞌi ndaꞌa̱ tón yito̱n yóꞌo, ta nda̱ ñii rí, o̱n vása ní‑naníꞌi ra ndaꞌa̱ nó. ");
INSERT INTO mim_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ta saá ta̱a ta̱ xíꞌin yito̱n ni̱ka̱ꞌa̱n ra xíꞌin ta̱a ta̱ ndáa ñoꞌo̱ ra: “Xa u̱ni̱ kui̱ya̱ va̱xi i̱ nándukú i̱ kui̱ꞌi ndaꞌa̱ tón yóꞌo, ta o̱n ko̱ó rí. ¿Nda̱chun kundichi ka̱ nó?, chi sándiꞌi i̱ xa̱ꞌa̱ ñoꞌo̱ i̱ xíꞌin nó. Va̱ꞌa kaꞌnda ún yito̱n yóꞌo”, káchí ta̱a ta̱ xíꞌin yito̱n yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ta nda̱kuii̱n ta̱ ndáa ñoꞌo̱ ra, ni̱ka̱ꞌa̱n ra: “Tata, taxi ún ña kundichi nó inka̱ kui̱ya̱, ta kata tíkui̱ta̱ i̱ xa̱ꞌa̱ nó, ta taan i̱ siꞌví kiti̱ xa̱ꞌa̱ nó, ta saá koto yó án o̱n kóo kui̱ꞌi ndaꞌa̱ nó. ");
INSERT INTO mim_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tá o̱n kóo kui̱ꞌi koon ndaꞌa̱ nó, ta saá va̱ꞌa kaꞌnda yó nó”, káchí ra xíꞌin ra. Saá ndi̱ꞌi cuento loꞌo yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ñii ki̱vi̱ yi̱i̱ ña nákindée najudío, yóo ta̱Jesús ini veꞌe ño̱ꞌo sinagoga ta sánáꞌa ra ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ta yóo ñii ñaꞌa̱, ta xa̱ꞌo̱n u̱ni̱ kui̱ya̱ ndeé ndóꞌo ñá kue̱ꞌe̱. Saá chi níma̱ ndiva̱ꞌa tíin ñaꞌá, ta o̱n vása táxi ña nduu nda̱kú sa̱ta̱ ñá, ta xíꞌin ñandu̱xa̱ xíka toso ñá. ");
INSERT INTO mim_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tá xi̱ni ta̱Jesús ñáñaꞌa̱ ndeé ndóꞌo yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ñá kixi ñá no̱o̱ ra, ta káchí ra siꞌa: ―Nana, vitin xa ndu̱va̱ꞌa ún, o̱n vása ndeé ndóꞌo ka̱ ún ―káchí ra xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ta saá chi̱nóo ra ndaꞌa̱ ra sa̱ta̱ ñá, ta xa̱ndi̱ko̱n ndu̱u nda̱kú sa̱ta̱ ñá, ta ki̱xáꞌá ñá kísa káꞌno ñá Ndios. ");
INSERT INTO mim_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ta ta̱káꞌno no̱o̱ na veꞌe ño̱ꞌo sinagoga yóꞌo, sáa̱ ní ini ra xa̱ꞌa̱ ña sa̱ndaꞌa ta̱Jesús ñáyóꞌo, chi ki̱vi̱ yi̱i̱ ña nákindée najudío kúu ña, ta o̱n váꞌa kasa chiño ni̱vi ki̱vi̱ yóꞌo. Ta ni̱ka̱ꞌa̱n ra saá: ―Yóo i̱ño̱ ki̱vi̱ kasa chiño yó ñii ñii semana. Ña̱kán va̱ꞌa kixi ndó i̱ño̱ ki̱vi̱ yóꞌo nduva̱ꞌa ndó, ta ki̱vi̱ yi̱i̱ ña nákindée yó o̱n váꞌa kixi ndó ña nduva̱ꞌa ndó ―káchí ta̱káꞌno xíꞌin ni̱vi na ñóꞌo ini veꞌe ño̱ꞌo sinagoga. ");
INSERT INTO mim_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ta saá nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―¡Na o̱vi̱ yuꞌu̱ kúu ndó!, chi káꞌa̱n ndó o̱n váꞌa sandaꞌa i̱ ni̱vi ki̱vi̱ yi̱i̱ ña nákindée yó. Ta mi̱i ndó, vará ki̱vi̱ yi̱i̱ nákindée yó kúu ña, ta ma̱ni̱ ní ndó kiti̱ sa̱na̱ ndó. Chi tá yóo si̱ndi̱ki̱ án burro sa̱na̱ ndó ta yíchi̱ ní rí takuií, ta saá ndaxin ndó rí ko̱ꞌo̱n rí koꞌo rí takuií. ");
INSERT INTO mim_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ta ñaꞌa̱ yóꞌo, ñii ki̱ꞌva kúu ñá sa̱ꞌya ñani síkuá ta̱Abraham nda̱tán kúu mi̱i yó, ta xa xa̱ꞌo̱n u̱ni̱ kui̱ya̱ ndeé ndóꞌo ñá xíꞌin kue̱ꞌe̱ ña kéꞌé ñandiva̱ꞌa Satanás xíꞌin ñá. Ta saá, ¿án o̱n váꞌa ndaxin i̱ ñá, ta saña kue̱ꞌe̱ ñá, vará ki̱vi̱ yi̱i̱ ña nákindée yó kúu ña? ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tá xi̱ni̱ so̱ꞌo nayóꞌo ña ni̱ka̱ꞌa̱n ta̱Jesús, ta saá kúkaꞌan no̱o̱ ndiꞌi na, ta ndeé ka̱ sáa̱ ini na xíni na ta̱Jesús. Ta inka̱ nañoo yóꞌo, kúsii̱ ní ini na xa̱ꞌa̱ ñava̱ꞌa ña náꞌno ke̱ꞌé ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ta ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin ni̱vi, káchí ra saá: ―¿Ndasaá yóo yichi̱ no̱o̱ xáꞌnda chiño Ndios? ¿Ndá cuento ndato̱ꞌon yó ña nandaxin yó xa̱ꞌa̱ ña? ");
INSERT INTO mim_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nda̱tán yóo ñii ndiki̱n loꞌo mostaza, ña chi̱ꞌi ñii ta̱a ñoꞌo̱ ra, ta ndúta̱ yito̱n káꞌno, ta̱nda̱ va̱xi tísaa kísa va̱ꞌa rí ta̱ka̱ rí ndaꞌa̱ nó, saá yóo yichi̱ no̱o̱ xáꞌnda chiño Ndios ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Saá tuku ni̱ka̱ꞌa̱n ra: ―¿Ndasaá yóo yichi̱ no̱o̱ xáꞌnda chiño Ndios? ¿Ndá cuento ndato̱ꞌon yó ña nandaxin yó xa̱ꞌa̱ ña? ");
INSERT INTO mim_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nda̱tán yóo levadura ña na̱saka ni̱vi xíꞌin yuxa̱n si̱ta̱ va̱ꞌa, saá yóo yichi̱ ña xáꞌnda chiño Ndios. Vará loꞌo ní levadura na̱saka ni̱vi xíꞌin u̱ni̱ koꞌndo náꞌno yuxa̱n harina, ta ku̱ndeé ña sa̱naño ña ndiꞌi yuxa̱n yóꞌo ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ta kua̱ꞌa̱n ta̱Jesús yichi̱ ñoo Jerusalén, ta yáꞌa ra ñoo válí xíꞌin ñoo náꞌno, ta sánáꞌa ra ni̱vi na ñii ñii ñoo no̱o̱ kua̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ta saá ñii ta̱a ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús, káchí ra siꞌa: ―Tata, ¿án saka̱ku Ndios loꞌo ní ni̱vi, án kua̱ꞌa̱ ní ni̱vi saka̱ku ra? Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ");
INSERT INTO mim_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Yéꞌé no̱o̱ ki̱ꞌvi ni̱vi yichi̱ Ndios táñó ní ña, ña̱kán xíni̱ ñóꞌó ndixa xaꞌa ndó ndee̱ ña ki̱ꞌvi ndó. Saá chi ki̱vi̱ ña va̱xi kua̱ꞌa̱ ní ni̱vi ndukú na ki̱ꞌvi na, ta o̱n kuchiño ka̱ ki̱ꞌvi na. ");
INSERT INTO mim_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ñii ki̱vi̱ ta̱káꞌno nakasi ra yéꞌé, ta o̱n kuchiño ka̱ ki̱ꞌvi ndó. Tá kindo̱o ndó ke̱ꞌe ki̱vi̱ kán, ta kani ní ndó yéꞌé, ta kuaku ndáꞌví ndó no̱o̱ ra ña nakuiná ra yéꞌé ki̱ꞌvi ndó, ta saá ndakuii̱n ra: “O̱n vása xíni̱ i̱ ndóꞌó, ni o̱n vása xíni̱ i̱ mí ki̱xi ndó”, kachí ra xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ta saá ka̱ꞌa̱n ndó xíꞌin ra: “Xíni̱ ún ndi̱ꞌi̱, tata, chi xi̱xi ndi̱, ta xi̱ꞌi ndi̱ xíꞌin ún, ta ni̱xika ún ñoo ndi̱ sa̱náꞌa ún ndi̱”, kachí ndó xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ta ka̱ꞌa̱n ra xíꞌin ndó: “Xa ni̱ka̱ꞌa̱n i̱ xíꞌin ndó ña o̱n vása xíni̱ i̱ míchí ki̱xi ndó. O̱n si̱ví na ndíko̱n yi̱ꞌi̱ kúu ndó, kutaꞌa ndó no̱o̱ i̱, chi na ndiva̱ꞌa kúu ndóꞌó”, kachí ra xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ta saá ko̱ꞌo̱n ndó no̱o̱ kuaku ní ndó, no̱o̱ ndeé ní xo̱ꞌvi̱ ndó, chi koni ndó ta̱Abraham xíꞌin ta̱Isaac, xíꞌin ta̱Jacob, xíꞌin ndiꞌi naprofeta na ni̱ka̱ꞌa̱n ndoso to̱ꞌon Ndios xi̱na̱ꞌá, koto ndó ndóo na no̱o̱ yóo Ndios. Ta ndóꞌó, o̱n kívi ki̱ꞌvi ndó no̱o̱ yóo ra, ta ndo̱o ndó ke̱ꞌe. ");
INSERT INTO mim_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ta kixi ni̱vi na kee ndiꞌi saá xiiña ñoyívi yóꞌo nakutáꞌan na kuxu na viko̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ta kua̱ꞌa̱ ní ni̱vi na kúu nasondíꞌí nduu na nano̱ó, ta kua̱ꞌa̱ ní ni̱vi na kúu nano̱ó nduu na nasondíꞌí ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ta mi̱i ki̱vi̱ yóꞌo, ki̱xaa̱ sava nafariseo no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Va̱ꞌa ka̱ kee ún ta ko̱ꞌo̱n ún inka̱ xiiña, chi ta̱rey Herodes kóni ra kaꞌni ra yóꞌó ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Kua̱ꞌa̱n ndó no̱o̱ ñokuii Herodes, ta ka̱ꞌa̱n ndó xíꞌin ra: “Ki̱vi̱ vitin xíꞌin ki̱vi̱ taa̱n tava i̱ níma̱ ndiva̱ꞌa ña tíin sava ni̱vi, ta sandaꞌa i̱ inka̱ na ndeé ndóꞌo, ta̱nda̱ ki̱vi̱ u̱ni̱ sandiꞌi i̱ chiño i̱”, saá kachí ndó xíꞌin ta̱Herodes. ");
INSERT INTO mim_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Xíni̱ ñóꞌó ko̱ꞌo̱n i̱ ki̱vi̱ vitin xíꞌin ki̱vi̱ taa̱n xíꞌin ki̱vi̱ yi̱sa, ta saá xaa̱ i̱ ñoo Jerusalén. Saá chi nda̱ ñii naprofeta, o̱n váꞌa kivi̱ na inka̱ ñoo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Saá ki̱xáꞌá ra káꞌa̱n ka̱ ra: ―¡Nañoo Jerusalén, ndóꞌó kúu na xáꞌni naprofeta, ndóꞌó kúu na kóon yu̱u̱ ni̱vi na ti̱ꞌví Ndios ña chindeé na ndóꞌó! ¡Kua̱ꞌa̱ ní yichi̱ káchí ini i̱ nakaya i̱ ndóꞌó, nda̱tán ñii nduxú siꞌí nákaya rí sa̱ꞌya rí ti̱xin ndi̱xi̱n rí, ta ni̱‑xiin ndó kundaa i̱ ndóꞌó! ");
INSERT INTO mim_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ña̱kán vitin Ndios sandakoo ra veꞌe ño̱ꞌo ndó, ta kuu vi̱chí ña ta ndu̱xu̱n ña. Ta ndixa káꞌa̱n i̱ xíꞌin ndó, nañoo Jerusalén, o̱n koto ka̱ ndó yi̱ꞌi̱ nda̱ to̱nda̱a ki̱vi̱ ka̱ꞌa̱n ndó to̱ꞌon yóꞌo: “Ná keꞌé Ndios ñava̱ꞌa xíꞌin ta̱yóꞌo, ta̱a ta̱ ki̱xaa̱ xíꞌin nda̱yí Ndios”, kachí ndó xa̱ꞌa̱ i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ñii ki̱vi̱ yi̱i̱ ña nákindée najudío, kua̱ꞌa̱n ta̱Jesús veꞌe ñii ta̱káꞌno no̱o̱ nafariseo kuxu ra xíꞌin na. Ta veꞌe yóꞌo ndóo inka̱ nafariseo, xíto naní na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Saá chi yóo ñii ta̱a ta̱ ndeé ndóꞌo xíꞌin kue̱ꞌe̱ kuiño. ");
INSERT INTO mim_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra nafariseo xíꞌin sava namaestro na xíni̱ va̱ꞌa nda̱yí Ndios, káchí ra saá: ―¿Yukía̱ káchí nda̱yí Ndios ña ni̱taa ta̱Moisés? ¿Án káchí ña va̱ꞌa sandaꞌa yó ni̱vi ki̱vi̱ yi̱i̱ ña nákindée yó, án káchí ña o̱n váꞌa sandaꞌa yó na? ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ta o̱n vása ní‑ndakuii̱n na yuꞌu̱ ra. Ta ta̱Jesús, chi̱nóo ra ndaꞌa̱ ra sa̱ta̱ ta̱ ndeé ndóꞌo, ta sa̱ndaꞌa ñaꞌá ra. Ta saá ti̱ꞌví ñaꞌá ra kua̱noꞌo̱ ra veꞌe ra. ");
INSERT INTO mim_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ta tuku ni̱nda̱ka̱ to̱ꞌon ta̱Jesús nafariseo, ni̱ka̱ꞌa̱n ra saá: ―Ta ndóꞌó, ¿án o̱n ndixa kísa chiño ndó ki̱vi̱ yi̱i̱ ña nákindée yó? Saá chi tá ñii ki̱vi̱ yi̱i̱ ñii burro sa̱na̱ ndó, án ñii si̱ndi̱ki̱ sa̱na̱ ndó nakava rí ini takuií no̱o̱ kónó, ta, ¿án o̱n kama ko̱ꞌo̱n ndó tava ndó rí? ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ta o̱n vása ní‑naníꞌi na to̱ꞌon ña ndakuii̱n na. ");
INSERT INTO mim_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tá ki̱xaa̱ ni̱vi kuxu na, ta xi̱ni ta̱Jesús kútoo na koo na no̱o̱ táyi̱ tón to̱ꞌó ní ka̱. Ta saá nda̱to̱ꞌon ta̱Jesús xíꞌin na, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Tá ko̱ꞌo̱n ndó ñii viko̱ tonda̱ꞌa̱, ta o̱n ndukú ndó koo ndó táyi̱ tón to̱ꞌó ní, chi kivi kixaa̱ inka̱ ni̱vi na náꞌno ka̱ no̱o̱ ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ta saá ta̱a ta̱ káꞌa̱n viko̱ tonda̱ꞌa̱ ka̱ꞌa̱n ra xíꞌin ndó: “Taxi ndó táyi̱ ndó ná koo inka̱ nanáꞌno yóꞌo”, kachí ra xíꞌin ndó. Ta saá kukaꞌan no̱o̱ ndó chi ndu̱xa̱ ko̱ꞌo̱n ndó koo ndó inka̱ táyi̱ tón yóo sa̱ta̱. ");
INSERT INTO mim_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ñayóꞌo kúu ñava̱ꞌa keꞌé ndó tá kua̱ꞌa̱n ndó viko̱ tonda̱ꞌa̱: koo ndó no̱o̱ táyi̱ tón yóo sa̱ta̱. Ta saá ta̱a ta̱ káꞌa̱n viko̱ kixaa̱ ra ka̱ꞌa̱n ra xíꞌin ndó: “Ñani yó, naꞌa ndó koo ndó no̱o̱ táyi̱ tón to̱ꞌó yóꞌo”, kachí ra xíꞌin ndó. Ta saá kanóo va̱ꞌa ní ñato̱ꞌó ndó no̱o̱ ndiꞌi inka̱ na xíxi no̱o̱ mesa xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Saá chi ndiꞌi ni̱vi na kísa káꞌno xíꞌin mi̱i, ñii ki̱vi̱ kukaꞌan no̱o̱ na. Ta ni̱vi na kísa ni̱no̱ xíꞌin mi̱i nduu na nanáꞌno na to̱ꞌó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin ta̱ xíꞌin veꞌe yóꞌo: ―Tá xáki̱n ún ñii viko̱ veꞌe ún, ta o̱n nakana ún natáꞌan ún, ni ñani ún, ni nakuíká táꞌan ún, chi nayóꞌo nakana tuku na yóꞌó, ta saá taxaꞌvi na yóꞌó. ");
INSERT INTO mim_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tá xáki̱n ún viko̱ veꞌe ún, ta va̱ꞌa ka̱ kana ún ni̱vi nandáꞌví, na o̱n ko̱ó ña kómí, xíꞌin ni̱vi na o̱n ki̱ví kaka, xíꞌin ni̱vi na ni̱chiꞌña, xíꞌin inka̱ ni̱vi nakuáá. ");
INSERT INTO mim_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ná ko̱ꞌo̱n nayóꞌo kuxu na xíꞌin ún, ta saá kunakaa̱ ñasi̱i̱ ini ún. Saá chi nayóꞌo o̱n kuchiño na taxaꞌvi na yóꞌó xíꞌin inka̱ viko̱. Ta Ndios taxaꞌvi ra yóꞌó ki̱vi̱ nataku̱ na ni̱xiꞌi̱ na xi̱kuu na va̱ꞌa ini ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tá xi̱ni̱ so̱ꞌo ñii ta̱a ta̱ yóo no̱o̱ mesa xíꞌin ta̱Jesús ña ni̱ka̱ꞌa̱n ra, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús, káchí ra saá: ―¡Nákaa̱ ñasi̱i̱ ní ini ni̱vi na kuxu viko̱ ni̱no no̱o̱ xáꞌnda chiño Ndios! ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ta nda̱to̱ꞌon ta̱Jesús ñii cuento ña sanáꞌa ra na: ―Saá ndo̱ꞌo ñii ta̱a xa̱ki̱n ra ñii viko̱ káꞌno, ta ka̱na ra kua̱ꞌa̱ ní ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tá ki̱xaa̱ hora kuxu na, ta ti̱ꞌví ra ñii mozo ra ka̱ꞌa̱n ra xíꞌin ni̱vi kixi na viko̱, chi xa ki̱sa ndivi ndiꞌi ra ña kuxu na. ");
INSERT INTO mim_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Saá ke̱e ta̱mozo, kua̱ꞌa̱n ra ka̱ꞌa̱n ra xíꞌin ñii ñii ni̱vi ná ko̱ꞌo̱n kuxu viko̱ yóꞌo. Ta nani̱vi yóꞌo ki̱xáꞌá na ndúkú na no̱o̱ ra ña kasa káꞌno ini ra xa̱ꞌa̱ na, chi o̱n kúchiño ko̱ꞌo̱n na viko̱. Ñii ra ni̱ka̱ꞌa̱n: “Sa̱kán sa̱ta i̱ loꞌo ñoꞌo̱ ta ndu̱xa̱ ko̱ꞌo̱n i̱ koto i̱ ña. Ta saá xáku ndáꞌví i̱ no̱o̱ ún ña kasa káꞌno ini ún, o̱n kunaꞌa i̱ ko̱ꞌo̱n i̱ xíꞌin ún viko̱”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ta inka̱ ra ni̱ka̱ꞌa̱n: “Sa̱kán sa̱ta i̱ o̱ꞌo̱n yunta si̱ndi̱ki̱, ta kóni ko̱ꞌo̱n loꞌo i̱ koto ndoso i̱ rí. Xáku ndáꞌví i̱ no̱o̱ ún ña kasa káꞌno ini ún, chi o̱n kunaꞌa i̱ ko̱ꞌo̱n i̱ xíꞌin ún”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ta inka̱ ra ni̱ka̱ꞌa̱n: “Sa̱kán to̱nda̱ꞌa̱ i̱, ta saá o̱n ki̱ví ko̱ꞌo̱n i̱ viko̱ veꞌe ta̱káꞌno no̱o̱ ún”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ta saá ndi̱kó ta̱mozo, ta na̱xaa̱ ra no̱o̱ ta̱káꞌno no̱o̱ ra, ta nda̱to̱ꞌon ra xíꞌin ra: “Nda̱ ñii na ka̱na ún ni̱‑xiin kixi”, káchí ra. Ta ta̱káꞌno yóꞌo ni̱saa̱ ní ini ra, ta xa̱ꞌnda chiño ra no̱o̱ ta̱mozo ra: “Kua̱ꞌa̱n ún ndiꞌi saá yichi̱ náꞌno, ndiꞌi saá yichi̱ válí ñoo yóꞌo, ta nakaya ún ni̱vi nandáꞌví, na o̱n ko̱ó ña kómí, xíꞌin ni̱vi na o̱n ki̱ví kaka, xíꞌin ni̱vi na ni̱chiꞌña, xíꞌin ni̱vi nakuáá, ta kixi na xíꞌin ún ña kuxu na viko̱ yóꞌo”, káchí ta̱káꞌno xíꞌin ta̱mozo ra. ");
INSERT INTO mim_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ta saá ke̱e ta̱mozo ni̱xa̱ꞌa̱n ra na̱kaya ra ni̱vi yóꞌo. Tá ndi̱kó ra na̱xaa̱ ra, ta nda̱to̱ꞌon ra xíꞌin ta̱káꞌno no̱o̱ ra: “Xa ni̱kisa ndivi i̱ ndiꞌi ña ni̱ka̱ꞌa̱n ún xíꞌin i̱, ta saá ni, yóo ka̱ no̱o̱ kundo̱o ni̱vi na kivi kuxu viko̱ yóꞌo”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ta nda̱kuii̱n ta̱káꞌno, ni̱ka̱ꞌa̱n ra saá: “Tuku ko̱ꞌo̱n ún yichi̱ náꞌno xíꞌin yichi̱ válí kasa ndu̱xa̱ ún xíꞌin ni̱vi ná kixi ndiꞌi na, ta̱nda̱ chútú nda̱a̱ na veꞌe i̱. ");
INSERT INTO mim_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chi ndixa káꞌa̱n i̱ xíꞌin ún, ndiꞌi nano̱ó na ka̱na i̱ kuxu veꞌe i̱, ni̱‑xiin na kixi na. Ta nda̱ ñii nayóꞌo o̱n vása kuxu ka̱ na viko̱ i̱”, káchí ta̱káꞌno xíꞌin ra. Saá ndi̱ꞌi cuento loꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ñii ki̱vi̱ kua̱ꞌa̱n ñii tiꞌvi ni̱vi xíꞌin ta̱Jesús yichi̱, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ");
INSERT INTO mim_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Ndiꞌi ni̱vi na kóni ko̱ꞌo̱n yichi̱ i̱ xíni̱ ñóꞌó kukiꞌvi ní ka̱ ini na koni na yi̱ꞌi̱ no̱o̱ yivá na, án no̱o̱ siꞌí na, án no̱o̱ sa̱ꞌya na, án no̱o̱ ñásíꞌí na, án no̱o̱ ñani na xíꞌin ki̱ꞌva̱ na. Ta saá tuku xíni̱ ñóꞌó kukiꞌvi ka̱ ini na koni na yi̱ꞌi̱ no̱o̱ mi̱i na. Tá o̱n xi̱in na kasa ndivi na saá, ta o̱n kúchiño na kundiko̱n na yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ndiꞌi ni̱vi na o̱n xi̱in kuso̱kó tón cruz mi̱i na, ta o̱n xi̱in na kasa ndivi na to̱ꞌon i̱, ta nayóꞌo o̱n kúchiño na kundiko̱n na sa̱ta̱ i̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ta nda̱to̱ꞌon ra xíꞌin na o̱vi̱ cuento válí ña sanáꞌa ra na, ni̱ka̱ꞌa̱n ra saá: ―Tá ñii ndóꞌó kóni ndó kasa va̱ꞌa ndó ñii veꞌe, ta, ¿án o̱n siꞌna kani va̱ꞌa si̱ni̱ ndó án nani si̱ꞌún kuva̱ꞌa ña ta̱nda̱ xi̱no̱ veꞌe ndó? ");
INSERT INTO mim_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Saá chi tá kixáꞌá ndó loꞌo kuiti xa̱ꞌa̱ veꞌe, ta ndi̱ꞌi si̱ꞌún ndó, ta ndiꞌi nani̱vi kuaku̱ ndaa na ndóꞌó, ta ka̱ꞌa̱n na saá xa̱ꞌa̱ ndó: ");
INSERT INTO mim_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Nakíꞌví kúu ni̱vi yóꞌo, ki̱xáꞌá na kísa va̱ꞌa na veꞌe, ta ni̱‑kundeé na xi̱no̱ ña”, kachí na xa̱ꞌa̱ ndó. Saá ndi̱ꞌi cuento loꞌo yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra inka̱ cuento xíꞌin na, káchí ra saá: ―Tá yóo ñii ta̱rey kóni kani táꞌan ra xíꞌin inka̱ ta̱rey, ta saá siꞌna kani va̱ꞌa si̱ni̱ ra án kundeé u̱xu̱ mil natropa kómí ra kani táꞌan na xíꞌin o̱ko̱ mil natropa kómí inka̱ ta̱rey. ");
INSERT INTO mim_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tá xáni si̱ni̱ ra o̱n vása kúndeé natropa kómí ra, tá xíká ka̱ loꞌo va̱xi inka̱ ta̱rey ta̱ kani táꞌan xíꞌin ra, ta saá va̱ꞌa ka̱ tiꞌví ra na xíka chiño no̱o̱ ra ko̱ꞌo̱n na no̱o̱ ta̱rey yóꞌo ña kasa nani na kua̱chi xíꞌin ra. Ta saá kuchiño va̱ꞌa kutaku̱ ndiꞌi na. Saá ndi̱ꞌi cuento loꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ta ni̱ka̱ꞌa̱n ka̱ ra: ―Ta saá ndiꞌi ndóꞌó na kóni ko̱ꞌo̱n yichi̱ i̱, xíni̱ ñóꞌó kani si̱ni̱ ndó án kundeé ini ndó ndañóꞌó ndó ndiꞌi ña kómí ndó xa̱ꞌa̱ i̱. Tá xíto ndó o̱n kuchiño ndó, ta o̱n kívi kuu ndó ni̱vi na ndíko̱n yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Saá nda̱to̱ꞌon ta̱Jesús inka̱ cuento ña sanáꞌa ra na, káchí ra saá: ―Ña va̱ꞌa kúu ñi̱i̱ yo̱ꞌva̱. Tá yóo ñi̱i̱ ña o̱n vása yo̱ꞌva̱, ta o̱n kuchiño ka̱ nduva̱ꞌa ña. ");
INSERT INTO mim_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ñi̱i̱ ña o̱n vása yo̱ꞌva̱ ka̱, o̱n vása va̱ꞌa ka̱ ña nasa̱ka̱ ña xíꞌin ñoꞌo̱, ni o̱n vása va̱ꞌa nasaka yó ña xíꞌin abono. Ta o̱n vása ndáya̱ꞌví ka̱ ñi̱i̱ ña o̱n váꞌa yóꞌo, ta va̱ꞌa ka̱ ná kui̱ta̱ ña. Ndiꞌi ndóꞌó ni̱vi na yóo so̱ꞌo, xíni̱ ñóꞌó chikaa̱ so̱ꞌo ndó ña káꞌa̱n i̱ xíꞌin ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ñii ki̱vi̱ sava ta̱a ta̱ káya si̱ꞌún ko̱ꞌo̱n ndaꞌa̱ nagobierno, ta inka̱ ni̱vi na kánóo o̱n váꞌa to̱ꞌon xa̱ꞌa̱, ki̱xaa̱ ndiꞌi na koni̱ so̱ꞌo na ña káꞌa̱n ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ta saá nafariseo xíꞌin sava na sánáꞌa nda̱yí Ndios, ki̱xáꞌá káꞌa̱n kue̱ꞌe̱ na xa̱ꞌa̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n na saá: ―O̱n váꞌa ta̱a kúu ta̱yóꞌo, chi nákiꞌin va̱ꞌa ra ni̱vi na o̱n váꞌa, ta̱nda̱ xíxi ra xíꞌin na ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ta saá ta̱Jesús nda̱to̱ꞌon ra ñii cuento ña sanáꞌa ra na, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Tá ñii ndóꞌó kómí ndó ñii ciento ndikachi sa̱na̱ ndó, ta ñii rí nda̱ñóꞌó, ta saá, ¿án o̱n sandakoo ndó tí ko̱mi̱ si̱ko̱ xa̱ꞌo̱n ko̱mi̱ kundo̱o mi̱i rí yuku̱, ta ko̱ꞌo̱n ndó nandukú ndó tí nda̱ñóꞌó nda̱ mí naníꞌi ndó rí? ");
INSERT INTO mim_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tá naníꞌi ndó rí, ta kusii̱ ini ndó, ta tiin ndó rí chinóo ndó rí so̱ko̱ ndó, ta kua̱n ndixi ndó xíꞌin rí. ");
INSERT INTO mim_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tá naxaa̱ ndó veꞌe ndó, ta nakana ndó ndiꞌi naveꞌe ndó xíꞌin natáꞌan ndó, ta ka̱ꞌa̱n ndó xíꞌin na: “Ná kusii̱ ní ini ndó xíꞌin i̱ chi na̱níꞌi i̱ tíndikachi sa̱na̱ i̱ tí nda̱ñóꞌó”, kachí ndó xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ta ndixa káꞌa̱n i̱ xíꞌin ndó, nda̱tán kusii̱ ní ini ndó xa̱ꞌa̱ tíndikachi yóꞌo, saá kusii̱ ní ini Ndios koni ra ñii ta̱a án ñii ñaꞌa̱ na na̱ndikó ndinoꞌo ini, ta na̱kiꞌin na kua̱ꞌa̱n na yichi̱ ra. Kúsii̱ ka̱ ini Ndios xíni ra ñii nayóꞌo no̱o̱ ña kúsii̱ ini ra xíni ra kua̱ꞌa̱ ní inka̱ ni̱vi na va̱ꞌa, na o̱n vása xíni̱ ñóꞌó nandikó ka̱ ini ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ta ta̱Jesús nda̱to̱ꞌon ra inka̱ cuento ña sanáꞌa ra na, káchí ra saá: ―Tá yóo ñii ñaꞌa̱ kómí ñá u̱xu̱ si̱ꞌún ñaplata, ta nda̱ñóꞌó ñii si̱ꞌún yóꞌo, ta saá, ¿án o̱n ndixa natoo̱n ñá ñoꞌo̱, ta kixáꞌá ñá tiꞌví ñá veꞌe ñá, ta nandukú va̱ꞌa ñá a̱nda̱ naníꞌi ñá si̱ꞌún ña nda̱ñóꞌó? ");
INSERT INTO mim_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tá naníꞌi ñá si̱ꞌún, ta kana ñá natáꞌan ñá xíꞌin na ndóo yatin veꞌe ñá, ta ndato̱ꞌon ñá xíꞌin na: “Ná kusii̱ ini ndó xíꞌin i̱ chi na̱níꞌi i̱ si̱ꞌún i̱ ña nda̱ñóꞌó”, kachí ñá xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ndixa káꞌa̱n i̱ xíꞌin ndó, nda̱tán kúsii̱ ini ñáyóꞌo, saá kúsii̱ ini naángel na yóo xíꞌin Ndios xíni na ni̱vi na na̱ndikó ndinoꞌo ini, ta na̱kiꞌin na kua̱ꞌa̱n na yichi̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ta ta̱Jesús sa̱náꞌa ra ni̱vi xíꞌin inka̱ cuento xa̱ꞌa̱ Ndios, káchí ra saá: ―Saá ndo̱ꞌo ñii ta̱a, kómí ra o̱vi̱ sa̱ꞌya ra. ");
INSERT INTO mim_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sa̱ꞌya ra ta̱ kúu ta̱loꞌo ni̱ka̱ꞌa̱n ra xíꞌin yivá ra: “Tata, ñakuíká ña nakiꞌin i̱ tá ni̱xiꞌi̱ ún, vitin taxi ún ña ndaꞌa̱ i̱”, káchí ra xíꞌin yivá ra. Ta saá yivá ra ta̱ꞌví ra ndiꞌi ñakuíká, ta na̱taxi ra ña ndaꞌa̱ ndio̱vi̱ sa̱ꞌya ra. ");
INSERT INTO mim_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ta ni̱yaꞌa loꞌo kuiti ki̱vi̱, ta sa̱ꞌya ra ta̱ kúu loꞌo ni̱si̱kó ra ndiꞌi ña na̱kiꞌin ra, ta na̱kuiso ra ndiꞌi si̱ꞌún, ta ke̱e ra kua̱ꞌa̱n ra inka̱ ñoo xíká. Ta ñoo kán sa̱ndiꞌi ndiꞌi ra si̱ꞌún ra, chi nda̱ loꞌo ni̱‑nasita xíꞌin mi̱i ra, ta ke̱ꞌé ra ndiꞌi no̱o̱ ña o̱n váꞌa ña káchí níma̱ mi̱i ra. ");
INSERT INTO mim_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ta ni̱to̱nda̱a ki̱vi̱ sa̱ndiꞌi nda̱a̱ ra si̱ꞌún ra, ta saá ki̱xaa̱ ki̱vi̱ káni so̱ko ndiꞌi ñoo kán. Ta ta̱loꞌo yóꞌo, o̱n vása níꞌi ka̱ ra ña kuxu ra. ");
INSERT INTO mim_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ta saá ke̱e ra kua̱ꞌa̱n ra, ta na̱níꞌi ra chiño no̱o̱ ñii ta̱a ñoo kán. Ta ta̱yóꞌo xa̱ꞌnda chiño ra no̱o̱ ta̱loꞌo yóꞌo kundaa ra tíkini̱. ");
INSERT INTO mim_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ta xíꞌi̱ ní ta̱loꞌo yóꞌo so̱ko, nda̱ kóni ra kuxu ra ña xáxi tíkini̱, ta o̱n vása táxi na ña ndaꞌa̱ ra kuxu ra. ");
INSERT INTO mim_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ta saá ki̱xaa̱ ñii ki̱vi̱ na̱kiꞌin si̱ni̱ ra ñava̱ꞌa, ta xáni ini ra saá: “Ndiꞌi namozo veꞌe yivá i̱ xíxi va̱ꞌa na, ta yi̱ꞌi̱, o̱n ko̱ó ña kuxu i̱, xa yatin yóo ña kivi̱ i̱ xíꞌin so̱ko. ");
INSERT INTO mim_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ta vitin ndikó i̱ noꞌo̱ i̱ no̱o̱ yivá i̱, ta ka̱ꞌa̱n i̱ xíꞌin ra siꞌa: Tata, ni̱ki̱ꞌvi i̱ kua̱chi no̱o̱ Ndios ta ni̱ki̱ꞌvi i̱ kua̱chi no̱o̱ mi̱i ún. ");
INSERT INTO mim_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ña̱kán o̱n vása kómí ka̱ i̱ nda̱yí kuu i̱ sa̱ꞌya ún, ta va̱ꞌa ñii ki̱ꞌva tá kéꞌé ún xíꞌin namozo ún, saá keꞌé ún xíꞌin i̱ vitin”, xáni ini ta̱loꞌo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ta na̱kiꞌin ra kua̱noꞌo̱ ra ñoo ra no̱o̱ yóo yivá ra. ’Ta nda̱ no̱o̱ xíká tívi va̱xi ta̱loꞌo, ta na̱koto yivá ra, ta ku̱ndáꞌví ní ini yivá ra xi̱ni ñaꞌá ra, ta ke̱e yivá ra xíno ra kua̱ꞌa̱n ra nakutáꞌan ra. Tá ni̱xaa̱ ra, ta no̱mi ra sa̱ꞌya ra, ta ni̱chi̱to ra no̱o̱ ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ta saá ki̱xáꞌá sa̱ꞌya ra káꞌa̱n ra xíꞌin yivá ra: “Tata, ni̱ki̱ꞌvi i̱ kua̱chi no̱o̱ Ndios, ta ni̱ki̱ꞌvi i̱ kua̱chi no̱o̱ mi̱i ún. Ña̱kán o̱n vása kómí ka̱ i̱ nda̱yí kuu i̱ sa̱ꞌya ún”, káchí ra xíꞌin yivá ra. ");
INSERT INTO mim_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ta yivá ra ni̱ka̱ꞌa̱n ra xíꞌin namozo ra: “Kama ko̱ꞌo̱n ndó kiꞌin ndó tiko̱to̱ ña va̱ꞌa ní ka̱ ña kundixin sa̱ꞌya i̱ yóꞌo, ta taxi ndó ndu̱xa̱n ña koꞌon xa̱ꞌa̱ ra, ta taxi ndó seꞌe̱ ña kunakaa̱ ndaꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ta ko̱ꞌo̱n ndó tiin ndó ñii si̱ndi̱ki̱ loꞌo tí kúu tí nduꞌu̱ sa̱na̱ i̱, ta kaꞌni ndó rí ña koo viko̱ xa̱ꞌa̱ sa̱ꞌya i̱ ta̱ ndi̱kó. ");
INSERT INTO mim_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Chi ndeé ní kúchuchú ini i̱ xa̱ꞌa̱ sa̱ꞌya i̱, nda̱tán ni̱xi̱yo ta̱ ni̱xiꞌi̱ saá ni̱xi̱yo ra no̱o̱ i̱, ta vitin kúsii̱ ní ini i̱, chi táku̱ ra ndi̱kó ra ndi̱xaa̱ ra. Ta̱a ta̱ nda̱ñóꞌó xi̱kuu ra no̱o̱ i̱, ta vitin na̱níꞌi i̱ ra”, káchí yivá ta̱loꞌo xíꞌin namozo ra. Ta saá ki̱xáꞌá na káꞌa̱n na viko̱ veꞌe ra, ta kúsii̱ ní ini ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ta inka̱ sa̱ꞌya ra ta̱no̱ó kísa chiño ra yuku̱, ta kua̱n ndixi ra veꞌe ra, ta ki̱xaa̱ yatin ra sa̱ta̱ veꞌe, ta xi̱ni̱ so̱ꞌo ra música ña tívi na xíꞌin ña sákáꞌa na, ta xi̱ni̱ so̱ꞌo ra ña káta xáꞌá na. ");
INSERT INTO mim_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ta saá ka̱na ra ñii ta̱mozo, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá ra: “¿Yukía̱ kúu ni?”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ta nda̱kuii̱n ta̱mozo, ni̱ka̱ꞌa̱n ra: “Ta ñani ún ndi̱kó ndi̱xaa̱, ta yivá ún xa̱ꞌni ñii si̱ndi̱ki̱ loꞌo tí nduꞌu̱ ña ka̱ꞌa̱n ra viko̱, chi kúsii̱ ní ini ra ña ndi̱xaa̱ va̱ꞌa ñani ún”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ta saá ni̱saa̱ ní ñani ra ta̱no̱ó yóꞌo, ta ni̱‑xiin ra ndi̱ꞌvi ra veꞌe no̱o̱ yóo viko̱. Ta ke̱ta yivá ra xa̱ku ndáꞌví ra no̱o̱ ra ndi̱ꞌvi ra veꞌe. ");
INSERT INTO mim_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ta nda̱kuii̱n ra, káchí ra saá: “Xa kua̱ꞌa̱ ní kui̱ya̱ ki̱sa chiño i̱ no̱o̱ ún, ta ndiꞌi saá ki̱vi̱ ki̱sa ndivi i̱ ña káꞌa̱n ún. Ta saá ni, nda̱ ñii ti̱súꞌu̱ loꞌo o̱n vása ní‑taxi ún ndaꞌa̱ i̱ ña kasa ndivi i̱ viko̱ xíꞌin na nátaꞌan xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ta sa̱ꞌya ún ta̱ ndi̱kó ndi̱xaa̱ vitin, sa̱ndiꞌi ra ndiꞌi si̱ꞌún mi̱i ún xíꞌin náñaꞌa̱ ta̱ni̱ ra, ta xa̱ꞌa̱ ta̱yóꞌo xa̱ꞌni ún si̱ndi̱ki̱ loꞌo tí nduꞌu̱ ña yóo viko̱”, káchí ra xíꞌin yivá ra. ");
INSERT INTO mim_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ta nda̱kuii̱n yivá ra, ni̱ka̱ꞌa̱n ra: “Sa̱ꞌya i̱, ndiꞌi saá ki̱vi̱ yóo ún xíꞌin i̱, ta ndiꞌi ña kómí i̱, ña̱ꞌa mi̱i ún kúu ndiꞌi ña. ");
INSERT INTO mim_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ta xíni̱ ñóꞌó koo viko̱ ña kúsii̱ ní ini yó, chi nda̱tán ni̱xi̱yo ta̱ ni̱xiꞌi̱ saá ni̱xi̱yo ñani ún no̱o̱ i̱, ta vitin nda̱tán yóo ta̱ na̱taku̱ saá yóo ra. Ta̱ nda̱ñóꞌó no̱o̱ i̱ xi̱kuu ra, ta vitin na̱níꞌi i̱ ra”, káchí yivá ra. Saá ndi̱ꞌi cuento loꞌo yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ta ta̱Jesús nda̱to̱ꞌon ra inka̱ cuento xíꞌin naxíka xíꞌin ra ña sanáꞌa ñaꞌá ra: ―Saá ndo̱ꞌo ñii ta̱kuíká xíꞌin ta̱ ndíso chiño xíꞌin ñakuíká ra. Ta inka̱ ta̱a ni̱xaa̱ ra no̱o̱ ta̱kuíká nda̱to̱ꞌon ra xíꞌin ra: “Tata, ta̱ ndíso chiño xíꞌin ñakuíká ún sándáꞌví ra yóꞌó, chi o̱n váꞌa kísa chiño ra xíꞌin ñakuíká ún”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ta saá ta̱kuíká ka̱na ra ta̱ ndíso chiño xíꞌin ñakuíká ra, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá ra: “¿Án ñanda̱a̱ kúu to̱ꞌon ña ndáto̱ꞌon na xíꞌin i̱ xa̱ꞌa̱ ún? Ta vitin taxi ún ndiꞌi tutu kuenda ndaꞌa̱ i̱, ta o̱n vása kasa chiño ka̱ ún xíꞌin i̱”, káchí ta̱kuíká xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ta ta̱ ndíso chiño yóꞌo ki̱xáꞌá xáni ini ra saá: “¿Yukía̱ koo vitin? Ta ta̱káꞌno no̱o̱ yó o̱n xi̱in ka̱ ra kasa chiño yó xíꞌin ra, ta o̱n vása kúndeé yó kata yó xíꞌin pico, ta ná koꞌyo̱ nda̱ka̱ chiꞌña yó, ta kukaꞌan ní no̱o̱ yó. ");
INSERT INTO mim_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Áan! ¡Vitin ki̱xaa̱ si̱ni̱ yó ndá chiño keꞌé yó! Keꞌé yó ñava̱ꞌa xíꞌin ni̱vi na níká no̱o̱ ta̱patrón yó, ta saá nayóꞌo nakiꞌin va̱ꞌa na mi̱i yó koo yó veꞌe na”, xáni ini ra. ");
INSERT INTO mim_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ta saá ki̱xáꞌá ra kána ra ñii ñii na níká no̱o̱ ta̱patrón ra. Ta ni̱nda̱ka̱ to̱ꞌon ra ta̱no̱ó: “¿Ndasaá níká ún no̱o̱ ta̱patrón i̱?”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ta nda̱kuii̱n ta̱yóꞌo, káchí ra saá: “Ko̱mi̱ mil litro aceite ña xíxi kúu ña níká i̱.” Ta ni̱ka̱ꞌa̱n ta̱ ndíso chiño xíꞌin ra: “Va̱ꞌa nakiꞌin ún tutu ña káchí ko̱mi̱ mil litro níká ún, ta nasama yó ndá o̱vi̱ mil litro kuu ña níká ún vitin”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ta ka̱na ra inka̱ ta̱a, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá ra: “¿Ndasaá níká ún no̱o̱ ta̱patrón i̱?”, káchí ra. Ta nda̱kuii̱n ta̱ níká, ni̱ka̱ꞌa̱n ra: “Ñii mil chikiva trigo kúu ña níká i̱”, káchí ra. Ta ni̱ka̱ꞌa̱n ta̱ ndíso chiño xíꞌin ra: “Nakiꞌin ún tutu, ta nasama yó ña káchí tutu ndá o̱na̱ ciento chikiva kuníká ún”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tá xi̱ni̱ so̱ꞌo ta̱kuíká yukía̱ ke̱ꞌé ta̱ ndíso chiño yóꞌo, ta ni̱ka̱ꞌa̱n ta̱kuíká yóꞌo xíꞌin ra: “Ta̱a ta̱ ndíchí ní si̱ni̱ kúu ún, chi xíni̱ va̱ꞌa ún ndasaá kasa ndivi ún ña keta va̱ꞌa xíꞌin mi̱i ún”, káchí ra. Saá ndi̱ꞌi cuento loꞌo yóꞌo ―káchí ta̱Jesús. Ta tuku ni̱ka̱ꞌa̱n ra: ―Cuento yóꞌo káchí ña ndí nandíchí ní kúu ni̱vi na ndíko̱n yichi̱ o̱n váꞌa ñoyívi yóꞌo, chi xíni̱ va̱ꞌa na ndasaá kasa ndivi na xíꞌin natáꞌan na ña keta va̱ꞌa xíꞌin mi̱i na. Ta ni̱vi na ndíko̱n yichi̱ Ndios loꞌo kuiti xíni̱ na ndasaá kasa ndivi na xíꞌin natáꞌan na, ña keta va̱ꞌa xíꞌin mi̱i na no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ña̱kán káꞌa̱n i̱ xíꞌin ndó, si̱ꞌún ndó ña yóo ñoyívi o̱n váꞌa yóꞌo, va̱ꞌa ka̱ chindeé ndó inka̱ ni̱vi xíꞌin ña, ta ni̱vi na nakiꞌin si̱ꞌún yóꞌo nduu na migo ndó. Ta saá, tá to̱nda̱a ki̱vi̱ ña o̱n vása ndáya̱ꞌví ka̱ si̱ꞌún ñoyívi yóꞌo, ta koo na nakiꞌin va̱ꞌa ndóꞌó koo ndó ñoyívi ni̱no. ");
INSERT INTO mim_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Ta̱a ta̱ va̱ꞌa ini, tá va̱ꞌa kísa ndivi ra chiño válí, ta saá ta̱yóꞌo va̱ꞌa kasa ndivi ra chiño náꞌno. Ta ta̱a ta̱ o̱n váꞌa ini, tá o̱n váꞌa kísa ndivi ra chiño válí, ta ta̱yóꞌo o̱n váꞌa kasa ndivi ra chiño náꞌno. ");
INSERT INTO mim_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ta ndóꞌó, tá o̱n váꞌa kísa ndivi ndó xíꞌin ñakuíká ñoyívi o̱n váꞌa yóꞌo, ta saá, ¿án xáni si̱ni̱ ndó taxi Ndios ñakuíká ndinoꞌo ndaꞌa̱ ndó ñoyívi ni̱no? ");
INSERT INTO mim_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chi ndiꞌi ña kómí ndó ñoyívi yóꞌo o̱n si̱ví ñakuíká mi̱i ndó kúu ña, ta kúu ña kuiti ña sa̱tati Ndios ndóꞌó. Ta saá tá o̱n vása kúchiño váꞌa kasa ndivi ndó xíꞌin ñakuíká sa̱tati Ndios ndóꞌó ñoyívi yóꞌo, ta saá, ¿án xáni si̱ni̱ ndó taxi ra ñakuíká ndinoꞌo kukomí ndó ñoyívi ni̱no? ");
INSERT INTO mim_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Nda̱ ñii ta̱a o̱n ki̱ví kasa chiño ra no̱o̱ o̱vi̱ patrón. Tá yóo o̱vi̱ patrón ra, ta kivi kukiꞌvi ini ra koni ra ñii ra, ta kusaa̱ ini ra koni ra ta̱ inka̱. Ta kivi kusii̱ ini ra kasa chiño ra xíꞌin ñii ra, ta o̱n kuaꞌa ra kasa chiño ra xíꞌin ta̱ inka̱. To̱ꞌon yóꞌo káchí ña saá: Tá Ndios kúu ta̱ xáꞌnda chiño no̱o̱ yó, ta o̱n ki̱ví taxi yó kaꞌnda chiño si̱ꞌún no̱o̱ yó ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tá xi̱ni̱ so̱ꞌo nafariseo to̱ꞌon yóꞌo, ta ni̱xaku̱ ndaa na ta̱Jesús, chi kútoo ní na si̱ꞌún. ");
INSERT INTO mim_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ndóꞌó, na o̱n vása ndinoꞌo ini kúu ndó, chi kuiti kéꞌé ndó chiño ña káꞌán nani̱vi ndí nava̱ꞌa kúu ndó, ta Ndios xíni̱ va̱ꞌa ra ini ndó. Yóo chiño ña xáni si̱ni̱ ni̱vi kúu ña ñava̱ꞌa ní no̱o̱ na, ta o̱n si̱ví ñava̱ꞌa kúu ña no̱o̱ Ndios, ta ña̱kán sáa̱ ini ra xíni ra chiño yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ta ni̱ka̱ꞌa̱n ka̱ ta̱Jesús, káchí ra saá: ―Ki̱vi̱ ki̱xaa̱ ta̱Juan ta̱ sákuchu ni̱vi, xa yóo nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá, xa yóo to̱ꞌon Ndios ña ni̱taa naprofeta. Ta saá ki̱xáꞌá káꞌa̱n ndoso i̱ to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ yichi̱ ña xáꞌnda chiño Ndios, ta ndiꞌi ni̱vi chíkaa̱ na ndee̱ ña kua̱n ki̱ꞌvi na yichi̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Vará yo̱ꞌvi̱ ní yóo ña ndasaá koo ndiꞌi xa̱ꞌa̱ ñoyívi yóꞌo xíꞌin ñoyívi ni̱no, ta yo̱ꞌvi̱ ní ka̱ yóo ña ndasaá ndiꞌi xa̱ꞌa̱ ña káꞌa̱n nda̱yí Ndios. Ta nda̱ ñii loꞌo chíín o̱n sa̱ma̱ nda̱yí Ndios, ta ndixa ndiꞌi nda̱yí yóꞌo kundivi ndiꞌi nda̱a̱ ña ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ta ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá: ―Tá ñii ta̱a sandakoo va̱ꞌa ra ñásíꞌí ra, ta tonda̱ꞌa̱ tuku ra, ta̱yóꞌo ki̱ꞌvi ra kua̱chi xíꞌin ñásíꞌí ra ñáo̱vi̱. Ta ta̱a ta̱ tonda̱ꞌa̱ xíꞌin ñáñaꞌa̱ ñá ni̱ndo̱o, ki̱sa yii̱ ñá, ta ta̱yóꞌo ki̱ꞌvi ra kua̱chi xíꞌin ñá, chi ñásíꞌí ta̱no̱ó kúu ñá no̱o̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ñii ki̱vi̱ nda̱to̱ꞌon ta̱Jesús ñii cuento xíꞌin ni̱vi ña sanáꞌa ra na, káchí ra saá: ―Saá ndo̱ꞌo ñii ta̱kuíká, ta ndíxin ra tiko̱to̱ ña yáꞌví, tiko̱to̱ ñalino va̱ꞌa color ndíꞌí ndíxin ra, ta va̱ꞌa ní xíxi ra ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ta ni̱xi̱yo inka̱ ta̱a ta̱ndáꞌví na̱ní ra Lázaro, ndeé ní ndóꞌo ra, yóo kue̱ꞌe̱ ndi̱ꞌi táꞌyí yi̱kí ko̱ñu ra, ta kándúꞌu̱ ra yéꞌé veꞌe ta̱kuíká yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ta ta̱Lázaro kóni ra kuxu ra ña kóyo xa̱ꞌa̱ tón mesa ta̱kuíká. Ta̱nda̱ tí ina ki̱xaa̱ rí tiꞌvi ndaa rí no̱o̱ táꞌyi̱ yi̱kí ko̱ñu ra. ");
INSERT INTO mim_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Saá ni̱to̱nda̱a ñii ki̱vi̱ ta ni̱xiꞌi̱ ta̱Lázaro, ta naángel na̱kiꞌin na ra, ta kua̱ꞌa̱n ra xíꞌin na ña kutaku̱ ra ñoyívi ni̱no, no̱o̱ yóo xi̱i̱ síkuá yó ta̱Abraham. Ta saá ki̱xaa̱ ki̱vi̱ ni̱xiꞌi̱ ta̱kuíká ta ni̱ndu̱xu̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ta ta̱kuíká yóꞌo xóꞌvi̱ ní ra no̱o̱ yóo ra xíꞌin inka̱ na ni̱xiꞌi̱, ta na̱koto ndaa ra, ta xi̱ni ra nda̱ xíká yóo ta̱Abraham, ta sii̱n ra yóo ta̱Lázaro. ");
INSERT INTO mim_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ta ta̱kuíká xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra xíꞌin ta̱Abraham, káchí ra saá: “Tata yivá i̱ Abraham, kundáꞌví ini ún koni ún yi̱ꞌi̱, ta tiꞌví ún ta̱Lázaro ko̱ꞌo̱n ra saketá nduku ndaꞌa̱ ra takuií, ta chikaa̱ ra loꞌo takuií no̱o̱ yáa̱ i̱ ña ná ndi̱ko loꞌo ña, chi xóꞌvi̱ ní i̱ yóꞌo no̱o̱ xíxi̱ ñoꞌo̱”, káchí ta̱kuíká. ");
INSERT INTO mim_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ta nda̱kuii̱n ta̱Abraham, ni̱ka̱ꞌa̱n ra: “Sa̱ꞌya i̱, nakáꞌán ún ki̱vi̱ xi̱taku̱ ún ñoyívi, va̱ꞌa ní ni̱xi̱yo ún. Ni̱xi̱yo ndiꞌi ña káchí ini ún, ta ta̱Lázaro yóꞌo nina ña o̱n vása va̱ꞌa xi̱komí ra. Ta vitin ta̱Lázaro va̱ꞌa ní yóo ra yóꞌo, ta yóꞌó xóꞌvi̱ ní ún. ");
INSERT INTO mim_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ta o̱n ki̱ví yaꞌa ta̱Lázaro ko̱ꞌo̱n ra chindeé ra yóꞌó, chi yóo ñii taꞌvi̱ káꞌno, ta nda̱ ñii ndi̱ o̱n ki̱ví yaꞌa ndi̱ xaa̱ ndi̱ no̱o̱ yóo ndó, ni ndóꞌó, o̱n ki̱ví yaꞌa ndó kixi ndó yóꞌo”, káchí ta̱Abraham xíꞌin ta̱kuíká. ");
INSERT INTO mim_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Saá káꞌa̱n tuku ta̱kuíká: “Tata Abraham, xáku ndáꞌví i̱ no̱o̱ ún ka̱ꞌa̱n ún xíꞌin ta̱Lázaro ná ko̱ꞌo̱n ra veꞌe yivá i̱, ");
INSERT INTO mim_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","no̱o̱ ndóo o̱ꞌo̱n ñani i̱. Saá chi kóni i̱ ña va̱ꞌa ndato̱ꞌon ra xíꞌin ndiꞌi ñani i̱ ña nandikó ini na, ko̱to̱ kixi na no̱o̱ yóo i̱, no̱o̱ xóꞌvi̱ ní i̱”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ta ni̱ka̱ꞌa̱n ta̱Abraham xíꞌin ra: “Ñani ún xa kómí na to̱ꞌon Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá, ta xa kómí na to̱ꞌon Ndios ña ni̱taa inka̱ naprofeta. Va̱ꞌa ná chikaa̱ so̱ꞌo na to̱ꞌon yóꞌo”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Óꞌon, tata”, káchí ta̱kuíká. “O̱n chikaa̱ so̱ꞌo na to̱ꞌon ña ni̱taa nakán. Ta saá tá ñii ta̱ ni̱xiꞌi̱ nandikó ra ñoyívi, ta ndato̱ꞌon ra xíꞌin na, ta ndixa nandikó ini na”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ta ni̱ka̱ꞌa̱n ta̱Abraham: “Óꞌon, o̱n si̱ví saá. Tá o̱n xi̱in na koni̱ so̱ꞌo na to̱ꞌon Ndios ña ni̱taa ta̱Moisés xíꞌin inka̱ naprofeta xi̱na̱ꞌá, ta ni o̱n kandixa na ña ka̱ꞌa̱n ta̱ ni̱xiꞌi̱, táná nandikó ra ka̱ꞌa̱n ra xíꞌin na”, káchí ta̱Abraham xíꞌin ra. Saá ndi̱ꞌi cuento loꞌo yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ñii ki̱vi̱ ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra: ―Ndiꞌi saá ki̱vi̱ kua̱ꞌa̱ ní ña o̱n váꞌa yóo ña chíndaꞌá ni̱vi ki̱ꞌvi na kua̱chi. Ta, ¡ndáꞌví ní ka̱ ni̱vi na chíndaꞌá inka̱ ni̱vi ki̱ꞌvi na kua̱chi! ");
INSERT INTO mim_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ta va̱ꞌa ka̱ siꞌna inka̱ ni̱vi ná katón na ñii yu̱u̱ káꞌno si̱ko̱n nayóꞌo, ta sakana ñaꞌá na no̱o̱ kónó va̱ꞌa ini takuií, ña o̱n chindaꞌá na nakuálí ki̱ꞌvi na kua̱chi. ");
INSERT INTO mim_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Koto va̱ꞌa xíꞌin mi̱i ndó ña o̱n keꞌé ndó ña o̱n váꞌa. Tá yóo ñii ta̱táꞌan ndó, ta kéꞌé ra ña o̱n váꞌa xíꞌin ndó, ta saá ka̱ꞌa̱n ndó xíꞌin ra ña o̱n keꞌé ka̱ ra ña o̱n váꞌa saá xíꞌin ndó. Tá ta̱yóꞌo nandikó ini ra, ta xíni̱ ñóꞌó kasa káꞌno ini ndó xa̱ꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tá yóo ñii ta̱a u̱xa̱ yichi̱ ña ñii ki̱vi̱ ke̱ꞌé ra ña o̱n váꞌa xíꞌin ndó, ta u̱xa̱ yichi̱ saá na̱ndikó ini ra ta xáku ndáꞌví ra no̱o̱ ndó, ta xíni̱ ñóꞌó kasa káꞌno ini ndó xa̱ꞌa̱ ta̱yóꞌo ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ta saá ni̱ka̱ꞌa̱n naxíka xíꞌin ta̱Jesús xíꞌin ra, káchí na saá: ―Tata, chindeé ún ndi̱ꞌi̱ ña kandixa va̱ꞌa ní ka̱ ndi̱ Ndios ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―Ñii ndiki̱n mostaza, loꞌo ní ña. Ta ndóꞌó, tá kandixa ndó Ndios, vará nda̱ loꞌo kuiti, nda̱tán yóo ndiki̱n mostaza, ta xa̱ꞌa̱ ña loꞌo kuiti kandixa ndó, ñayóꞌo taxi ña kukomí ndó ndee̱ kaꞌnda chiño ndó no̱o̱ yito̱n káꞌno tón sicómoro yóꞌo, ta kasa ndivi nó to̱ꞌon ndó. Tá ka̱ꞌa̱n ndó xíꞌin yito̱n yóꞌo: “Kutaꞌa ún, ta kua̱ꞌa̱n ún kunakaa̱ ún ini takuií”, ta kasa ndivi yito̱n yóꞌo ña ka̱ꞌa̱n ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ta nda̱to̱ꞌon ta̱Jesús inka̱ cuento ña sanáꞌa ra na, káchí ra saá: ―Tá yóo ñii ta̱mozo ndó, ta kísa chiño ra ñoꞌo̱ ndó, án ndáa ra kiti̱ sa̱na̱ ndó, ta va̱xi ra veꞌe ndó, ¿yukía̱ ka̱ꞌa̱n ndó xíꞌin ra? ¿Án ka̱ꞌa̱n ndó xíꞌin ra ña kuiti nakindée ra ta kuxu ra? ");
INSERT INTO mim_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","O̱n ka̱ꞌa̱n ndó saá, chi ndixa kaꞌnda chiño ndó no̱o̱ ra ña siꞌna kasa va̱ꞌa ra ñaxíxi, ta taxi ra ña kuxu ndó. Tá ndi̱ꞌi xi̱xi ndóꞌó, ta ka̱ꞌa̱n ndó xíꞌin ra va̱ꞌa ná kuxu ra. ");
INSERT INTO mim_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ta o̱n kundati ra ka̱ꞌa̱n ndó xíꞌin ra: “Táxaꞌvi ún”, chi kuiti ki̱sa ndivi ra chiño no̱o̱ mi̱i ra. ");
INSERT INTO mim_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nda̱tán yóo ta̱mozo yóꞌo, saá yóo ndóꞌó no̱o̱ Ndios. Tá ki̱sa ndivi ndó ndiꞌi ña xa̱ꞌnda chiño Ndios no̱o̱ ndó, ta va̱ꞌa ka̱ꞌa̱n ndó: “O̱n si̱ví namozo tiꞌva ní kúu ndi̱, ta o̱n vása ní‑kisa ndivi ndi̱ ñii chiño káꞌno ní, ta kuiti ki̱sa ndivi ndi̱ chiño ña xíni̱ ñóꞌó kasa ndivi ndi̱”, kachí ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tá kua̱ꞌa̱n ta̱Jesús ñoo Jerusalén, ta ni̱yaꞌa ra yichi̱ no̱o̱ nákutáꞌan ñoꞌo̱ naSamaria xíꞌin ñoꞌo̱ naGalilea. ");
INSERT INTO mim_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Saá ni̱xaa̱ ra yatin no̱o̱ ñoo loꞌo, ta na̱kutáꞌan ra xíꞌin u̱xu̱ ta̱a, ta ndiꞌi nayóꞌo ndeé ní ndóꞌo na xíꞌin kue̱ꞌe̱ táꞌyí na̱ní ña lepra. Ta xíká loꞌo yíta na. ");
INSERT INTO mim_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ta saá ki̱xáꞌá na xíꞌin ndiꞌi ndee̱ na, káꞌa̱n na xíꞌin ta̱Jesús: ―¡Tata Maestro, kundáꞌví ini ún koni ún ndi̱ꞌi̱! ");
INSERT INTO mim_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tá xi̱ni ta̱Jesús na ndeé ndóꞌo yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Kua̱ꞌa̱n ndó no̱o̱ su̱tu̱ ná koto ra ndóꞌó án xa ni̱ndaꞌa ndó ―káchí ra xíꞌin na. Saá ke̱e na kua̱ꞌa̱n na yichi̱, ta o̱n vása ka̱ ndeé ndóꞌo na, xa ndu̱va̱ꞌa ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ñii ta̱a na̱koto ra xa ndu̱va̱ꞌa ra, ta ndi̱kó ra kua̱ꞌa̱n ra, ta ndeé ní kísa káꞌno ra Ndios. ");
INSERT INTO mim_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tá ni̱xaa̱ ra no̱o̱ ta̱Jesús, ta xi̱kuxítí ra, ta̱nda̱ no̱o̱ ñoꞌo̱ ni̱to̱nda̱a ta̱ꞌya̱ ra, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Táxaꞌvi ún sa̱ndaꞌa ún yi̱ꞌi̱ ―káchí ra. Ta ta̱yóꞌo o̱n si̱ví ta̱Israel kúu ra, ki̱xi ra ñoo estado Samaria. ");
INSERT INTO mim_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra ni̱vi na ndóo xíꞌin ra: ―¿Án o̱n si̱ví u̱xu̱ kúu ta̱a ta̱ ndu̱va̱ꞌa? ¿Nda̱chun ñii la̱á ta̱yóꞌo ndi̱kó? ¿Míkía̱ yóo inka̱ nata̱a táꞌan ta̱yóꞌo? ");
INSERT INTO mim_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Chi ñii la̱á ta̱yóꞌo, ta o̱n si̱ví ta̱Israel kúu ra, ta ndi̱kó ra ta kísa káꞌno ra Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱a ta̱ ndu̱va̱ꞌa: ―Nakundichi ún, ta kua̱noꞌo̱ ún. Xa ndu̱va̱ꞌa ún chi ka̱ndixa ún yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ñii ki̱vi̱ nafariseo ki̱xaa̱ na no̱o̱ ta̱Jesús, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá na, káchí na saá: ―¿Ama kixaa̱ ki̱vi̱ kixáꞌá Ndios kaꞌnda chiño ra ñoyívi yóꞌo? ―káchí na. Ta nda̱kuii̱n ta̱Jesús, káꞌa̱n ra: ―Yichi̱ no̱o̱ xáꞌnda chiño Ndios, o̱n si̱ví ñii ña kúchiño koni yó kúu ña. ");
INSERT INTO mim_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ña̱kán kía̱ nda̱ ñii ni̱vi o̱n kívi ka̱ꞌa̱n na: “Yóꞌo yóo ña”, ni o̱n kívi ka̱ꞌa̱n na: “Kaa̱ yóo ña.” Saá chi yichi̱ no̱o̱ xáꞌnda chiño Ndios xa ki̱xaa̱ ña, yóo ña ma̱ꞌñó ndó ―káchí ta̱Jesús xíꞌin nafariseo. ");
INSERT INTO mim_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Va̱xi ki̱vi̱ ña kachí ní ini ndó koto ndó yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios. Kachí ini ndó koo i̱ xíꞌin ndó, vará ñii ki̱vi̱, ta o̱n kuchiño ka̱. ");
INSERT INTO mim_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ta saá ka̱ꞌa̱n ni̱vi xíꞌin ndó: “¡Koto ndó! Yóꞌo yóo ra”, án “Kaa̱ yóo ra”, kachí na, ta o̱n kandixa ndó na. ");
INSERT INTO mim_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nda̱tán yóo ta̱xa̱ ña náyeꞌe ñoyívi, kíxáꞌá ña náyeꞌe ña nda̱ no̱o̱ kána ño̱ꞌo ta̱nda̱ no̱o̱ ndétá ño̱ꞌo náyeꞌe ña, saá koo ki̱vi̱ ndikó i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ta siꞌna xíni̱ ñóꞌó xo̱ꞌvi̱ ní i̱, ta ni̱vi na táku̱ ñoyívi yóꞌo vitin o̱n kuaꞌa na kandixa na yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ñii ki̱ꞌva xi̱taku̱ ni̱vi ki̱vi̱ ni̱xi̱yo ta̱Noé, saá kutaku̱ na ki̱vi̱ kuyatin ndikó i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Saá chi ki̱vi̱ xi̱taku̱ ta̱Noé xi̱na̱ꞌá ndiꞌi ni̱vi xíxi na, xíꞌi na, ta tónda̱ꞌa̱ na, ta táxi na tonda̱ꞌa̱ sa̱ꞌya na, saá yóo na nda̱ ni̱to̱nda̱a ki̱vi̱ ni̱ki̱ꞌvi ta̱Noé ini tón barco. Ta saá ki̱xáꞌá ni̱koon sa̱vi̱ naꞌá, ta ta̱ni ndiꞌi ni̱vi ta ni̱ka̱ꞌa̱ na xíꞌin takuií, ta ni̱xiꞌi̱ ndiꞌi ni̱vi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ñii ki̱ꞌva nda̱tán xi̱taku̱ ni̱vi ki̱vi̱ xi̱taku̱ ta̱Noé, saá xi̱taku̱ ni̱vi ki̱vi̱ xi̱taku̱ ta̱Lot xi̱na̱ꞌá. Saá chi xíxi na, xíꞌi na, sáta na, síkó na, chíꞌi na, ta kísa va̱ꞌa na veꞌe na. ");
INSERT INTO mim_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ta ki̱vi̱ ña ke̱e ta̱Lot xíꞌin naveꞌe ra ñoo Sodoma, Ndios sa̱ko̱yo ra ñoꞌo̱ xíxi̱ xíꞌin ñoꞌo̱ káꞌndi na̱ní ña azufre ki̱xi ña ñoyívi ni̱no, ta ndiꞌi ni̱vi ñoo yóꞌo ni̱xi̱xi̱ na ta ndi̱ꞌi xa̱ꞌa̱ na. ");
INSERT INTO mim_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ñii ki̱ꞌva nda̱tán ni̱xi̱yo ni̱vi na xi̱taku̱ xi̱na̱ꞌá xíꞌin ta̱Noé án xíꞌin ta̱Lot, saá kutaku̱ na ki̱vi̱ ndikó i̱ ñoyívi yóꞌo, ta ki̱vi̱ yóꞌo ndiꞌi ni̱vi nakoni na ndí yi̱ꞌi̱ kúu ta̱a ta̱ ki̱xi no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ta ki̱vi̱ ña ndikó i̱, tá ni̱vi nándoso na si̱ni̱ veꞌe na, ta nayóꞌo o̱n váꞌa noo na nakiꞌin na ña kómí na veꞌe na. Tá ni̱vi ñóꞌo na yuku̱, ta nayóꞌo, o̱n váꞌa ndikó ka̱ na veꞌe na nakiꞌin na ña kómí na. ");
INSERT INTO mim_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nakáꞌán ndó yukía̱ ndo̱ꞌo ñásíꞌí ta̱Lot ki̱vi̱ ke̱e ñá ñoo Sodoma. ");
INSERT INTO mim_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ndiꞌi ni̱vi na ndasaá kuiti ndúkú ña kutaku̱ va̱ꞌa na ñoyívi yóꞌo, ta nayóꞌo o̱n kuchiño na kutaku̱ na xíꞌin Ndios. Ta ni̱vi na o̱n vása ndíꞌi ní ini ndukú kutaku̱ va̱ꞌa na ñoyívi yóꞌo, xa̱ꞌa̱ ña kundiko̱n na yi̱ꞌi̱, nayóꞌo kúu ni̱vi na kutaku̱ xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Ki̱vi̱ ndikó i̱ ñoyívi yóꞌo, ta nakiꞌin i̱ sava ni̱vi ko̱ꞌo̱n na xíꞌin i̱, ta sava na ndo̱o. Tá o̱vi̱ ni̱vi kísi̱n na ñii no̱o̱ xi̱to, ta nakiꞌin i̱ ñii na, ta inka̱ na ndo̱o. ");
INSERT INTO mim_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tá ñii veꞌe yóo o̱vi̱ násíꞌí ndíko ná, ta nakiꞌin i̱ ñii ñá, ta inka̱ ñá ndo̱o. ");
INSERT INTO mim_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tá o̱vi̱ ta̱a kísa chiño ra yuku̱, ta nakiꞌin i̱ ñii ta̱yóꞌo, ta inka̱ ra ndo̱o ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ta naxíka xíꞌin ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ñaꞌá na, káchí na saá: ―¿Míkía̱ kundivi ñayóꞌo?, Tata ―káchí na. Ta nda̱kuii̱n ta̱Jesús ni̱ka̱ꞌa̱n ra: ―Tá xíto ndó míkía̱ ndáchí kua̱ꞌa̱ ní tio̱ko chée, ta saá kúnda̱a̱ ini ndó míchí kándúꞌu̱ ñii kiti̱ tí ni̱xiꞌi̱. Ta ki̱vi̱ ña ndikó i̱, ndiꞌi ni̱vi kunda̱a̱ ini na xa̱ꞌa̱ ñayóꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ñii ki̱vi̱ nda̱to̱ꞌon ta̱Jesús ñii cuento xíꞌin naxíka xíꞌin ra. Xíꞌin cuento yóꞌo sánáꞌa ra na ña o̱n nakava ini na ka̱ꞌa̱n na xíꞌin Ndios, ta xíni̱ ñóꞌó ka̱ꞌa̱n na xíꞌin Ndios ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ta káchí ta̱Jesús saá: ―Saá ndo̱ꞌo ñii ta̱juez yóo ra ñii ñoo, ta o̱n vása kísa to̱ꞌó ra Ndios, ni o̱n vása kísa to̱ꞌó ra nda̱ ñii ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ta ñoo yóꞌo, yóo ñii ñaꞌa̱, ñá ni̱xiꞌi̱ yii̱ kúu ñá, ta ñáyóꞌo kua̱ꞌa̱n ñá ndiꞌi saá ki̱vi̱ no̱o̱ ta̱juez ña kasa nani ra kua̱chi xa̱ꞌa̱ ñá. Ni̱ka̱ꞌa̱n ñá saá xíꞌin ra: “Ná kasa nani ún ñanda̱a̱ xíꞌin i̱, chi yóo ñii ta̱a, ta sáa̱ ini ra xíni ra yi̱ꞌi̱, kóni ra sandáꞌví ra yi̱ꞌi̱”, káchí ñá xíꞌin ta̱juez. ");
INSERT INTO mim_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ta o̱n vása xi̱in ta̱juez chindeé ra ñá. Ta ni̱yaꞌa kua̱ꞌa̱ ní ki̱vi̱, ta saá xa̱ni ini ta̱juez: “Vará o̱n vása kísa to̱ꞌó i̱ Ndios, ni o̱n vása kísa to̱ꞌó i̱ ni̱vi, ");
INSERT INTO mim_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ta chindeé i̱ ñaꞌa̱ yóꞌo, chi sándiꞌi ní ñá yi̱ꞌi̱, ta o̱n vása kúndeé ka̱ ini i̱, chi va̱xi ñá sándiꞌi ñá yi̱ꞌi̱ ndiꞌi saá ki̱vi̱. Ta ña̱kán kasa nani i̱ ñanda̱a̱ xa̱ꞌa̱ ñá”, káchí ta̱juez. Saá ndi̱ꞌi cuento loꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ta ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na: ―Koni̱ so̱ꞌo va̱ꞌa ndó to̱ꞌon ni̱ka̱ꞌa̱n ta̱juez. Vará ta̱ o̱n váꞌa kúu ra, ta ki̱sa ndivi ra ñanda̱a̱ xíꞌin ñáñaꞌa̱ yóꞌo, chi ndiꞌi saá ki̱vi̱ xáku ndáꞌví ñá no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ta Ndios kúu ta̱va̱ꞌa ta̱nda̱a̱. ¿Án o̱n vása ndixa Ndios kasa nani ra ñanda̱a̱ xíꞌin ni̱vi na na̱ka̱xin ra, na kúu na xáku ndáꞌví no̱o̱ ra ndiví ñoó? ¿Án xáni si̱ni̱ ndó ña naꞌá ní kundati na, ta saá ndakuii̱n Ndios yuꞌu̱ na? ");
INSERT INTO mim_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ndixa káꞌa̱n i̱ xíꞌin ndó. Ndios kama ní kasa nani ra ñanda̱a̱ xa̱ꞌa̱ na. Ta yi̱ꞌi̱, o̱n vása xíni̱ i̱, ¿án naníꞌi i̱ ni̱vi na ndixa kándixa yi̱ꞌi̱, ki̱vi̱ ña ndikó i̱ ñoyívi yóꞌo? ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ta saá ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi na xáni si̱ni̱ kuiti mi̱i na kúu nava̱ꞌa, ta xáni si̱ni̱ na inka̱ ni̱vi, o̱n vása va̱ꞌa nayóꞌo. Ta ta̱Jesús nda̱to̱ꞌon ra ñii cuento ña sanáꞌa ra nayóꞌo: ");
INSERT INTO mim_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Saá ndo̱ꞌo o̱vi̱ ta̱a ni̱xa̱ꞌa̱n ra veꞌe ño̱ꞌo ka̱ꞌa̱n ra xíꞌin Ndios. Ñii ta̱yóꞌo kúu ta̱fariseo ta inka̱ ra kúu ta̱ káya si̱ꞌún xa̱ꞌa̱ nagobierno. ");
INSERT INTO mim_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ta ta̱fariseo ñíndichi ra, ta káꞌa̱n ra xa̱ꞌa̱ mi̱i ra, káchí ra saá: “Tata Ndios, táxaꞌvi ún, yi̱ꞌi̱ o̱n vása yóo i̱ nda̱tán yóo inka̱ ni̱vi, chi o̱n si̱ví ta̱ kísa kuíꞌná kúu i̱, ni o̱n si̱ví ta̱ o̱n váꞌa kúu i̱, ni o̱n si̱ví ta̱ kísi̱n xíꞌin inka̱ ñaꞌa̱ kúu i̱, ni o̱n vása yóo i̱ nda̱tán yóo ta̱a ta̱ ñíndichi kaa̱, ta̱ káya si̱ꞌún xa̱ꞌa̱ nagobierno. ");
INSERT INTO mim_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ta̱a ta̱ va̱ꞌa kúu i̱ chi o̱vi̱ ki̱vi̱ ñii ñii semana yóo soꞌon i̱. Ta táꞌví i̱ u̱xu̱ koꞌndo si̱ꞌún ña kómí i̱. Ta ñii koꞌndo yóꞌo táxi i̱ ndaꞌa̱ ún. Saá kéꞌé i̱ ndiꞌi saá ki̱vi̱”, káchí ra xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ta inka̱ ta̱a ta̱ káya si̱ꞌún xa̱ꞌa̱ nagobierno ñíndichi ra xíká loꞌo. Ta ki̱sa ni̱no̱ xíꞌin mi̱i ra no̱o̱ Ndios, ta ni o̱n xi̱in ra koto ra ñoyívi ni̱no, ta kuiti xíto ra no̱o̱ ñoꞌo̱. Ta kúchuchú ní ini ra nda̱ káni ra kándíká ra, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios siꞌa: “Tata Ndios, kundáꞌví ini ún koni ún yi̱ꞌi̱, vará ta̱ o̱n váꞌa kúu i̱”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ndixa káꞌa̱n i̱ xíꞌin ndó, ki̱vi̱ kua̱noꞌo̱ ta̱yóꞌo veꞌe ra ki̱ndo̱o va̱ꞌa ra no̱o̱ Ndios. Ta ta̱fariseo, o̱n vása ní‑kindo̱o va̱ꞌa ra no̱o̱ Ndios. Saá chi ndiꞌi ni̱vi na kísa káꞌno xíꞌin mi̱i no̱o̱ Ndios, ta Ndios chikaa̱ ra nayóꞌo ni̱no̱. Ta ni̱vi na kísa ni̱no̱ xíꞌin mi̱i no̱o̱ Ndios, ta Ndios chinóo va̱ꞌa ra ñato̱ꞌó na ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ta ki̱xaa̱ ni̱vi xíꞌin nakuálí no̱o̱ yóo ta̱Jesús ña chinóo ra ndaꞌa̱ ra si̱ni̱ na, ta ndukú ra ñava̱ꞌa no̱o̱ Ndios xa̱ꞌa̱ na, ta naxíka xíꞌin ra ni̱ka̱ꞌa̱n na xíꞌin ni̱vi yóꞌo: ―O̱n kixi ndó xíꞌin nakuálí yóꞌo ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ta ta̱Jesús ka̱na ndiꞌi ra nakuálí va̱xi na no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra: ―Taxi ndó nakuálí ná kixi na no̱o̱ i̱, nda̱ loꞌo o̱n kasi ndó na ña kixi na, chi ni̱vi na ndíko̱n yichi̱ no̱o̱ xáꞌnda chiño Ndios, nda̱tán yóo nakuálí yóꞌo, saá yóo na. ");
INSERT INTO mim_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ndixa káꞌa̱n i̱ xíꞌin ndó, tá o̱n xi̱in ndó kasa ni̱no̱ xíꞌin mi̱i ndó no̱o̱ Ndios nda̱tán ni̱no̱ yóo ini nakuálí yóꞌo, ta o̱n kívi ki̱ꞌvi ndó yichi̱ no̱o̱ xáꞌnda chiño Ndios ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ñii ta̱chiño ki̱xaa̱ ra no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Tata maestro, ta̱a va̱ꞌa ní ini kúu ún. ¿Ndá chiño va̱ꞌa xíni̱ ñóꞌó keꞌé i̱ ta taxi Ndios ña kutaku̱ i̱ xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi? ");
INSERT INTO mim_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―¿Nda̱chun káꞌa̱n ún yi̱ꞌi̱ kúu ta̱a ta̱ va̱ꞌa ini? Saá chi o̱n ko̱ó nda̱ ñii ni̱vi va̱ꞌa ini, ñii la̱á Ndios kuiti kúu ta̱ va̱ꞌa ndinoꞌo ini. ");
INSERT INTO mim_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Xíni̱ ún nda̱yí ña xa̱ꞌnda chiño Ndios kasa ndivi ni̱vi. Ka̱chí Ndios xíꞌin ni̱vi saá: “O̱n ki̱ꞌvi ndó kua̱chi ñoyívi xíꞌin inka̱ ñaꞌa̱ ñá o̱n si̱ví kúu ñásíꞌí ndó, ta o̱n ki̱ꞌvi ndó kua̱chi ñoyívi xíꞌin ta̱a ta̱ o̱n si̱ví kúu yii̱ ndó, o̱n kaꞌni ndó ni̱vi, o̱n kasa kuíꞌná ndó ña kómí ni̱vi, o̱n ka̱ꞌa̱n ndó ñavatá xa̱ꞌa̱ inka̱ ni̱vi, ta kasa to̱ꞌó ndó yivá ndó, ta kasa to̱ꞌó ndó siꞌí ndó”, saá káchí nda̱yí Ndios ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ta ni̱ka̱ꞌa̱n ta̱yóꞌo: ―Yi̱ꞌi̱ nda̱ loꞌo i̱ kísa ndivi i̱ ndiꞌi saá nda̱yí yóꞌo ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tá xi̱ni̱ so̱ꞌo ta̱Jesús ña nda̱kuii̱n ra, ta ni̱ka̱ꞌa̱n tuku ra xíꞌin ra: ―Kúma̱ni̱ inka̱ chiño kasa ndivi ún. Kua̱ꞌa̱n ún si̱kó ún ndiꞌi ñakuíká kómí ún, ta saníꞌi ún si̱ꞌún ndaꞌa̱ ni̱vi nandáꞌví. Ta saá kukomí ún ñakuíká ndinoꞌo xíꞌin Ndios ñoyívi ni̱no. Tá ndi̱ꞌi ke̱ꞌé ún ñava̱ꞌa yóꞌo, ta kixi ún kundiko̱n ún yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tá xi̱ni̱ so̱ꞌo ta̱yóꞌo ña ni̱ka̱ꞌa̱n ta̱Jesús, ta kúchuchú ní ini ra, saá chi kua̱ꞌa̱ ní ñakuíká kómí ra. ");
INSERT INTO mim_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tá xi̱ni ta̱Jesús ña kúchuchú ní ini ra, ta ni̱ka̱ꞌa̱n ra saá: ―¡Nda̱chun yo̱ꞌvi̱ ní ki̱ꞌvi nakuíká yichi̱ no̱o̱ xáꞌnda chiño Ndios! ");
INSERT INTO mim_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Vará yo̱ꞌvi̱ ní tá kuchiño tícamello yaꞌa rí yavi̱ xa̱ꞌa̱ túkú, ta yo̱ꞌvi̱ ní ka̱ kuchiño yaꞌa ñii ta̱kuíká yéꞌé ña ki̱ꞌvi ra yichi̱ no̱o̱ xáꞌnda chiño Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ta ni̱vi na xi̱ni̱ so̱ꞌo to̱ꞌon yóꞌo, ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ―Tá yo̱ꞌvi̱ ní ki̱ꞌvi nakuíká yichi̱ Ndios, ta saá, ¿yu kúu ni̱vi kúchiño ki̱ꞌvi na yichi̱ Ndios, ta kundo̱o na xíꞌin ra? ");
INSERT INTO mim_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra saá: ―Ni̱vi o̱n kúchiño na saka̱ku xíꞌin mi̱i na, ñii la̱á Ndios kúu ta̱ kúchiño saka̱ku ñaꞌá. Ndios kúchiño kasa ndivi ra ndiꞌi chiño. O̱n ko̱ó ña yo̱ꞌvi̱ no̱o̱ Ndios ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ta saá ni̱ka̱ꞌa̱n ta̱Pedro xíꞌin ra: ―Ta mi̱i ndi̱, xa sa̱ndakoo ndi̱ ndiꞌi ñava̱ꞌa ña xi̱komí ndi̱, xa̱ꞌa̱ ña ndíko̱n ndi̱ sa̱ta̱ ún. ");
INSERT INTO mim_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, ndiꞌi ni̱vi na sa̱ndakoo veꞌe, án yivá na, án siꞌí na, án ñani na, án ki̱ꞌva̱ na, án ñásíꞌí na, án sa̱ꞌya na, xa̱ꞌa̱ ña chíkaa̱ ini na ko̱ꞌo̱n na yichi̱ no̱o̱ xáꞌnda chiño Ndios, ");
INSERT INTO mim_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ta nayóꞌo nakiꞌin na kua̱ꞌa̱ ní ka̱ ñava̱ꞌa taxi Ndios ndaꞌa̱ na ñoyívi yóꞌo. Ta ñoyívi ni̱no Ndios taxi ra ña kutaku̱ na xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ta ta̱Jesús, ka̱na ra ndiꞌi saá u̱xu̱ o̱vi̱ naxíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta vitin kua̱ꞌa̱n yó yichi̱ kua̱n ndaa ñoo Jerusalén, ta ñoo kán kundivi ndiꞌi to̱ꞌon Ndios ña ni̱taa naprofeta xa̱ꞌa̱ yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nataxi na yi̱ꞌi̱ ndaꞌa̱ na o̱n vása kúu najudío, ta kuaku̱ ndaa na yi̱ꞌi̱, kandiva̱ꞌa na xíꞌin i̱, ta kundaa na tási̱i yuꞌu̱ na no̱o̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ta kani ní na yi̱ꞌi̱ xíꞌin kuártá, ta sondi̱ꞌi kaꞌni na yi̱ꞌi̱. Ta ki̱vi̱ u̱ni̱ nataku̱ i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ta naxíka xíꞌin ra ni̱‑kunda̱a̱ ini na yukía̱ kóni kachí to̱ꞌon yóꞌo, chi ña xi̱nakaa̱ seꞌé no̱o̱ na xi̱kuu ña. ");
INSERT INTO mim_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ñii ki̱vi̱ kua̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra, ta kua̱ꞌa̱ ní ni̱vi ndíko̱n na kua̱ꞌa̱n na sa̱ta̱ ra. Ta xa yatin xáa̱ ra ñoo Jericó, ta ñii ta̱kuáá yóo ra yuꞌu̱ yichi̱, ta ndáka̱ chiꞌña ra si̱ꞌún no̱o̱ ni̱vi na yáꞌa yichi̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tá xi̱ni̱ so̱ꞌo ta̱kuáá yóꞌo ñii síso̱ yáꞌa kua̱ꞌa̱ ní ni̱vi kua̱ꞌa̱n na yichi̱, ta ni̱nda̱ka̱ to̱ꞌon ra na: ―¿Yukía̱ koo vitin? ");
INSERT INTO mim_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Ta̱Jesús ta̱ñoo Nazaret kúu ta̱ yáꞌa yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tá xi̱ni̱ so̱ꞌo ra ñayóꞌo, ta ki̱xáꞌá ra xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Tata Jesús, sa̱ꞌya ta̱David, ¡ná kundáꞌví ini ún koni ún yi̱ꞌi̱! ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ta ni̱vi na kua̱ꞌa̱n siꞌna yichi̱ ni̱ka̱ꞌa̱n na xíꞌin ra: ―¡Kasi ún yuꞌu̱ ún! ―káchí na. Ta ni̱‑chikaa̱ so̱ꞌo ta̱kuáá ña ni̱ka̱ꞌa̱n na xíꞌin ra, ta ki̱xáꞌá ra ndeé va̱ꞌa ka̱ káꞌa̱n ra: ―Tata, sa̱ꞌya ta̱David, ¡ná kundáꞌví ini ún koni ún yi̱ꞌi̱! ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ta xi̱kundichi ta̱Jesús yichi̱ yóꞌo, ta xa̱ꞌnda chiño ra no̱o̱ ni̱vi ña ko̱ꞌo̱n na kiꞌin na ta̱kuáá ta kixi ra xíꞌin na no̱o̱ ra. Tá ki̱xaa̱ ta̱kuáá no̱o̱ ta̱Jesús, ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ñaꞌá ra, ni̱ka̱ꞌa̱n ra saá: ");
INSERT INTO mim_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Yukía̱ kóni ún keꞌé i̱ xíꞌin ún? Ta nda̱kuii̱n ta̱kuáá: ―Tata, kóni i̱ sandaꞌa ún nduchu̱ no̱o̱ i̱ ta va̱ꞌa koto i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Va̱ꞌa, xa ndu̱va̱ꞌa nduchu̱ no̱o̱ ún, saá chi kándixa ún yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ta xa̱ndi̱ko̱n nda̱ꞌa nduchu̱ no̱o̱ ra, ta xa va̱ꞌa xíto ra, ta saá na̱kundiko̱n ra sa̱ta̱ ta̱Jesús, ta ki̱xáꞌá ra kísa káꞌno ra Ndios. Tá xi̱ni ni̱vi yóꞌo ndí ta̱Jesús sa̱ndaꞌa ra ta̱kuáá, ta ndiꞌi ni̱vi yóꞌo ki̱xáꞌá na kísa káꞌno na Ndios. ");
INSERT INTO mim_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ta ni̱xaa̱ ta̱Jesús ñoo Jericó, ta kua̱ꞌa̱n ra yichi̱ ma̱ꞌñó ñoo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ta yóo ñii ta̱a ta̱kuíká na̱ní ra Zaqueo, ta̱a ta̱ ndíso chiño xíꞌin ni̱vi na káya si̱ꞌún xa̱ꞌa̱ nagobierno kúu ra. ");
INSERT INTO mim_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ta kóni ra koto ra yu kúu ta̱Jesús, ta o̱n vása kúchiño ra, chi chútú ní ni̱vi. Saá chi ta̱Zaqueo kúu ra ta̱a ta̱ kuítí ní. ");
INSERT INTO mim_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ta saá ke̱e ra, xíno ra kua̱ꞌa̱n siꞌna ra, ta ni̱xaa̱ ra no̱o̱ kúma̱ni̱ yaꞌa ta̱Jesús. Ta ta̱Zaqueo nda̱a ra ndaꞌa̱ ñii yito̱n tón sicómoro káꞌno, ña kuchiño koni ra ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ta ni̱xaa̱ ta̱Jesús xa̱ꞌa̱ yito̱n no̱o̱ kánóo ta̱Zaqueo, ta na̱koto ndaa ra, ta xi̱ni ra ta̱Zaqueo, ta ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Tata, xa̱ndi̱ko̱n noo ún chi xíni̱ ñóꞌó kindo̱o i̱ veꞌe ún ki̱vi̱ vitin ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ta saá xa̱ndi̱ko̱n no̱o ta̱Zaqueo, ta kúsii̱ ní ini ra na̱kiꞌin ra ta̱Jesús veꞌe ra. ");
INSERT INTO mim_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tá xi̱ni ni̱vi ñayóꞌo, ta ki̱xáꞌá na kándiva̱ꞌa na xíꞌin ta̱Jesús, káꞌa̱n na, káchí na saá: ―O̱n váꞌa koo ta̱Jesús veꞌe ta̱Zaqueo, chi ta̱ o̱n váꞌa kúu ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ta ta̱Zaqueo na̱kundichi ra ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Koto ví, Tata, vitin taꞌví i̱ ndiꞌi ñakuíká kómí i̱, ta taxi i̱ ñii sava ñayóꞌo ndaꞌa̱ nandáꞌví. Tá yóo ni̱vi na sa̱ndáꞌví i̱ ki̱ndaa i̱ ña xi̱komí na, ta vitin taxi i̱ ndaꞌa̱ na ko̱mi̱ yichi̱ ka̱ ñayóꞌo ―káchí ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Ki̱vi̱ vitin Ndios sa̱ka̱ku ra ta̱yóꞌo xíꞌin naveꞌe ra, chi ñii ki̱ꞌva nda̱tán xi̱i̱ síkuá yó ta̱Abraham ka̱ndixa ra Ndios, saá kándixa ta̱Zaqueo vitin. Ta saá kúnda̱a̱ ini yó ta̱Zaqueo kúu ñii sa̱ꞌya ndinoꞌo ta̱Abraham. ");
INSERT INTO mim_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yi̱ꞌi̱, ta̱ kúu ta̱a ta̱ ki̱xi no̱o̱ Ndios, va̱xi i̱ nandukú i̱ ta saka̱ku i̱ ni̱vi na nda̱ñóꞌó no̱o̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ta ni̱vi na kua̱ꞌa̱n sa̱ta̱ ta̱Jesús xíni̱ so̱ꞌo na to̱ꞌon ña káꞌa̱n ra, ta xa yatin xaa̱ ra ñoo Jerusalén, ta xáni si̱ni̱ ni̱vi vitin to̱nda̱a ki̱vi̱ Ndios kixáꞌá ra kaꞌnda chiño ra no̱o̱ na ñoyívi yóꞌo. Ta saá ta̱Jesús nda̱to̱ꞌon ra ñii cuento ña sanáꞌa ra na, ");
INSERT INTO mim_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","káchí ra saá: ―Saá ndo̱ꞌo ñii ta̱káꞌno, kóni ra ko̱ꞌo̱n ra inka̱ ñoo xíká, ta ndikó ra, chi ñoo xíká yóꞌo sakuiso na chiño ra kuu ra ta̱rey ñoo ra, ta kaꞌnda chiño ra no̱o̱ nañoo ra. ");
INSERT INTO mim_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tá xa yatin to̱nda̱a ki̱vi̱ kee ta̱káꞌno yóꞌo ko̱ꞌo̱n ra, ta ka̱na ra u̱xu̱ namozo ra, ta ki̱xaa̱ na no̱o̱ ra. Ta ta̱xi ra ñii si̱ꞌún na̱ní mina ndaꞌa̱ ñii ñii namozo, ta ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: “Kasa chiño ndó si̱ꞌún yóꞌo nda̱ ki̱vi̱ ndikó i̱”, káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ta ni̱vi nañoo ra o̱n xi̱in na koni na ra, ña̱kán ti̱ꞌví na sava natáꞌan na ko̱ꞌo̱n na ka̱ꞌa̱n na xíꞌin mi̱i ta̱rey káꞌno ñoo xíká, kachí na saá: “O̱n vása kóni ndi̱ ta̱yóꞌo nduu ra ta̱rey, ta kaꞌnda chiño ra no̱o̱ ndi̱”, kachí na. ");
INSERT INTO mim_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ta saá ni, ni̱xa̱ꞌa̱n ra, ta ndu̱u ra ta̱rey, ta ndi̱kó ra ñoo ra. Ta ni̱ka̱ꞌa̱n ra xíꞌin namozo ra: “Vitin ko̱ꞌo̱n ndó kana ndó u̱xu̱ ta̱a ta̱ ta̱xi i̱ si̱ꞌún ndaꞌa̱, ná kixi na yóꞌo ña kunda̱a̱ ini i̱ ndasaá si̱ꞌún na̱kiꞌin nayóꞌo sa̱ta̱ si̱ꞌún ña ta̱xi i̱ ndaꞌa̱ na”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ta ta̱no̱ó ki̱xaa̱ ra, ta ka̱chí ra saá: “Tata, ki̱sa chiño i̱ si̱ꞌún ña ta̱xi ún ndaꞌa̱ i̱, ta na̱kiꞌin i̱ u̱xu̱ si̱ꞌún sa̱ta̱ ña”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ta káchí ta̱rey: “Va̱ꞌa, ta̱mozo va̱ꞌa kúu ún. Va̱ꞌa ní ki̱sa ndivi ún xíꞌin chiño ña loꞌo, ta vitin táxi i̱ yóꞌó nduu ún ta̱a ta̱ kaꞌnda chiño no̱o̱ u̱xu̱ ñoo”, káchí ta̱rey xíꞌin ta̱mozo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ta ta̱mozo o̱vi̱ ki̱xaa̱ ra no̱o̱ ta̱rey, ta ni̱ka̱ꞌa̱n ra: “Tata, ki̱sa chiño i̱ si̱ꞌún ña ta̱xi ún ndaꞌa̱ i̱, ta na̱kiꞌin i̱ o̱ꞌo̱n si̱ꞌún sa̱ta̱ ña”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ta nda̱kuii̱n ta̱rey, ni̱ka̱ꞌa̱n ra xíꞌin ra: “Va̱ꞌa, ta vitin taxi i̱ yóꞌó nduu ún ta̱ kaꞌnda chiño no̱o̱ o̱ꞌo̱n ñoo”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ta ki̱xaa̱ inka̱ ta̱mozo no̱o̱ ta̱rey, ta ni̱ka̱ꞌa̱n ra: “Tata, yóꞌo yóo si̱ꞌún ña ta̱xi ún ndaꞌa̱ i̱. Ta̱xi va̱ꞌa i̱ ña, chi̱súku ndaa i̱ ña xíꞌin tiko̱to̱. Ni̱‑xiin sandañóꞌó i̱ ña, ");
INSERT INTO mim_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","chi yíꞌví i̱ no̱o̱ ún. Saá chi yóꞌó kúu ñii ta̱a ta̱ ndeé ní ini, chi kíndaa ún si̱ꞌún vará o̱n vása ní‑kisa chiño ún, ta nákaya ún ña̱ꞌa no̱o̱ o̱n vása ní‑chiꞌi ún”, káchí ta̱mozo xíꞌin ta̱rey. ");
INSERT INTO mim_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ta ni̱ka̱ꞌa̱n ta̱rey xíꞌin ra: “¡Ta̱mozo ndiva̱ꞌa kúu yóꞌó! Ta xíꞌin to̱ꞌon ña ni̱ka̱ꞌa̱n mi̱i ún, vitin sanakuiso i̱ kua̱chi yóꞌó. Káchí ún ndí yi̱ꞌi̱ kúu ta̱ ndeé ini, ta̱a ta̱ kíndaa si̱ꞌún vará o̱n vása ní‑kisa chiño i̱, ta yi̱ꞌi̱ nákaya ña̱ꞌa no̱o̱ o̱n vása ní‑chiꞌi i̱, káchí ún. ");
INSERT INTO mim_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tá ndixa ñayóꞌo kúu ña xáni ini ún, ta saá, ¿nda̱chun ni̱‑chikaa̱ va̱ꞌa ún si̱ꞌún i̱ ini veꞌe no̱o̱ táꞌvi̱ si̱ꞌún?, ta ki̱vi̱ ndi̱kó i̱, nakiꞌin i̱ si̱ꞌún i̱ xíꞌin si̱ki̱ ña, níkúu”, káchí ta̱rey xíꞌin ta̱mozo o̱n váꞌa yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ta ni̱ka̱ꞌa̱n ta̱rey xíꞌin na ndóo xíꞌin ra: “Kindaa ndó si̱ꞌún ndaꞌa̱ ta̱yóꞌo, ta taxi ndó ña ndaꞌa̱ ta̱a ta̱ kómí u̱xu̱ si̱ꞌún”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na: “Tata, ta̱yóꞌo xa kómí ra u̱xu̱ si̱ꞌún”, káchí na. ");
INSERT INTO mim_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ta ni̱ka̱ꞌa̱n ta̱rey: “Ta ndiꞌi ni̱vi na va̱ꞌa xíni̱ kukomí ña̱ꞌa, ta nayóꞌo nakiꞌin ka̱ na ñava̱ꞌa. Ta ni̱vi na o̱n vása xíni̱ ndasaá va̱ꞌa kukomí na ña̱ꞌa, ta̱nda̱ ñaloꞌo kómí na, nondaa ña ndaꞌa̱ nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ta vitin tónda̱a ki̱vi̱ kasa nani i̱ kua̱chi xa̱ꞌa̱ ni̱vi na o̱n xi̱in koni yi̱ꞌi̱, ni̱vi na o̱n xi̱in taxi yi̱ꞌi̱ kuu ta̱a ta̱ kaꞌnda chiño no̱o̱ na. Va̱ꞌa ko̱ꞌo̱n ndó kiꞌin ndó na ta kixi na yóꞌo, ta saá kaꞌni ndó na no̱o̱ i̱”, káchí ta̱rey xíꞌin na. Saá ndi̱ꞌi cuento loꞌo yóꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ta ndi̱ꞌi ni̱ka̱ꞌa̱n ta̱Jesús to̱ꞌon yóꞌo, ta na̱kiꞌin ra kua̱ꞌa̱n ra yichi̱ ñoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ta ni̱xaa̱ ra yatin ñoo Betania xíꞌin ñoo Betfagé, ña ñóꞌo no̱o̱ xi̱ki̱ tón Olivo. Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin o̱vi̱ naxíka xíꞌin ra, ");
INSERT INTO mim_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","káchí ra saá: ―Kua̱ꞌa̱n ndó ñoo ña xíto ndaa ndó kaa̱. Ta ni̱xaa̱ ndó ñoo kaa̱, ta naníꞌi ndó ñii burro loꞌo nóꞌni rí, tí o̱n ta̱ꞌán koso na kúu rí. Ta ndaxin ndó rí ta kixi ndó xíꞌin rí yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tá yóo ni̱vi na nda̱ka̱ to̱ꞌon ndóꞌó: “¿Nda̱chun ndáxin ndó burro yóꞌo?”, kachí na xíꞌin ndó, ta ndakuii̱n ndó, kachí ndó saá xíꞌin na: “Ta̱Káꞌno no̱o̱ yó xíni̱ ñóꞌó rí”, kachí ndó xíꞌin na ―káchí ta̱Jesús xíꞌin o̱vi̱ naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ta saá kua̱ꞌa̱n na, ta ni̱xaa̱ na ñoo ta na̱níꞌi na burro loꞌo. Ñii ki̱ꞌva nda̱tán yóo ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, saá yóo ña na̱níꞌi na. ");
INSERT INTO mim_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tá ndáxin na burro loꞌo, ta ni̱vi xíꞌin sa̱na̱ tíyóꞌo, ni̱nda̱ka̱ to̱ꞌon ñaꞌá na: ―¿Nda̱chun ndáxin ndó rí? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ta nda̱kuii̱n na, káchí na saá: ―Mi̱i ta̱Káꞌno no̱o̱ yó xíni̱ ñóꞌó rí ―káchí na xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ta saá ndi̱kó na ki̱xaa̱ na no̱o̱ ta̱Jesús xíꞌin burro loꞌo, ta chi̱nóo na tiko̱to̱ na sa̱ta̱ rí, ta na̱koso ta̱Jesús ta kua̱ꞌa̱n ra yichi̱. ");
INSERT INTO mim_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tá yóso ra rí, kua̱ꞌa̱n ra yichi̱, ta kua̱ꞌa̱ ní ni̱vi chi̱ndoo na tiko̱to̱ na yichi̱ no̱o̱ yáꞌa ra kua̱ꞌa̱n ra, saá kísa to̱ꞌó na ra. ");
INSERT INTO mim_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tá ki̱xáꞌá ra va̱xi noo ra xi̱ki̱ tón Olivo, ta ndiꞌi ni̱vi na ndíko̱n sa̱ta̱ ra kúsii̱ ní ini na, ta ki̱xáꞌá na ndeé ní káꞌa̱n na, ta kísa káꞌno na Ndios xa̱ꞌa̱ ña kua̱ꞌa̱ ní milagro ke̱ꞌé ra, xi̱ni na. ");
INSERT INTO mim_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ni̱ka̱ꞌa̱n na saá: ―¡Ná keꞌé Ndios ñava̱ꞌa xíꞌin ta̱rey yóꞌo, ta̱a ta̱ ki̱xaa̱ xíꞌin nda̱yí Ndios! ¡Vitin Ndios taxi ra koo va̱ꞌa ni̱vi xíꞌin ra ñoyívi ni̱no! ¡Ná kanóo síkón ñato̱ꞌó Ndios! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ta sava nafariseo kua̱ꞌa̱n na xíꞌin ni̱vi yóꞌo, ta ni̱ka̱ꞌa̱n na xíꞌin ta̱Jesús: ―Tata maestro, ka̱ꞌa̱n ún xíꞌin na ndíko̱n sa̱ta̱ ún, ña o̱n ka̱ꞌa̱n na saá ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Táná ka̱ꞌa̱n i̱ xíꞌin nayóꞌo ndí tási̱ín koo yuꞌu̱ na, ta saá nda̱ yu̱u̱ ndóo yóꞌo kixáꞌá ña ndeé ní kasa káꞌno ña yi̱ꞌi̱ ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ta ki̱xaa̱ ta̱Jesús yatin ñoo Jerusalén. Tá xi̱ni ra ñoo yóꞌo, ta ki̱xáꞌá ra kúchuchú ní ini ra, ta xáku ra xa̱ꞌa̱ ni̱vi nañoo yóꞌo, ");
INSERT INTO mim_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ta ni̱ka̱ꞌa̱n ra saá: ―¡Kóni ní i̱ vitin kunda̱a̱ ini ndó yu kúu ña kivi taxi koo va̱ꞌa ini ndó! Saá chi ña nákaa̱ seꞌé no̱o̱ ndó kúu ña vitin, ta o̱n ki̱ví koni ndó ña. ");
INSERT INTO mim_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ta va̱xi ñii ki̱vi̱ ndiꞌi na sáa̱ ini xíni ndóꞌó kono nduu ndiꞌi na ñoo ndó, ta nakasi na ndiꞌi yichi̱ ndó, ta o̱n kuchiño kee ndó ñoo ndó. Ta ndiꞌi saá xiiña ñoo ndó, kixáꞌá ni̱vi yóꞌo kani táꞌan na xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ta sandiꞌi na xa̱ꞌa̱ ndiꞌi veꞌe ndó, ta sandiꞌi na xa̱ꞌa̱ ndiꞌi ndóꞌó. O̱n ndo̱o ka̱ nda̱ ñii yu̱u̱ ndíso táꞌan na̱ma̱ veꞌe ndó ña koto ndó, chi ndiꞌi xa̱ꞌa̱ veꞌe ndó. Saá kundoꞌo ndó chi ki̱vi̱ ki̱xaa̱ i̱ ña saka̱ku i̱ ndóꞌó, ta ni̱‑xiin ndó nakoni ndó yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin nañoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ta ni̱xaa̱ na ñoo Jerusalén, ta ta̱Jesús ni̱ki̱ꞌvi ra ke̱ꞌe yéꞌé veꞌe ño̱ꞌo káꞌno, ta ki̱xáꞌá ra táva ra ndiꞌi ni̱vi na síkó xíꞌin ni̱vi na sáta, ña kee na ko̱ꞌo̱n na. ");
INSERT INTO mim_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Saá káchí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá: “Veꞌe i̱ kuu veꞌe no̱o̱ ko̱ꞌo̱n ni̱vi ña ka̱ꞌa̱n na xíꞌin i̱”, káchí to̱ꞌon Ndios. Ta ndóꞌó, o̱n vása va̱ꞌa kéꞌé ndó, chi sa̱nduu ndó veꞌe yóꞌo ñii kavua̱ nakuíꞌná ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ndiꞌi saá ki̱vi̱ ta̱Jesús xíka ra sánáꞌa ra ni̱vi ini veꞌe ño̱ꞌo káꞌno ñoo Jerusalén yóꞌo, ta na sánáꞌa nda̱yí Ndios xíꞌin nachiño náꞌno xíꞌin nanáꞌno no̱o̱ nasu̱tu̱, ndúkú na ndasaá koo kaꞌni na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ta ni̱‑kivi naníꞌi na ndasaá kaꞌni na ra, chi ndiꞌi ni̱vi kúsii̱ ini na xíni̱ so̱ꞌo na to̱ꞌon ña káꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ñii ki̱vi̱ yóo ta̱Jesús ke̱ꞌe yéꞌé veꞌe ño̱ꞌo káꞌno ñoo Jerusalén, ta sánáꞌa ra ni̱vi, káꞌa̱n ra xíꞌin na to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ yichi̱ Ndios. Ta saá na sánáꞌa nda̱yí Ndios xíꞌin naxi̱kua̱ꞌa̱ no̱o̱ najudío xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ ki̱xaa̱ na no̱o̱ ta̱Jesús, ");
INSERT INTO mim_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ta ni̱ka̱ꞌa̱n na xíꞌin ra siꞌa: ―Ka̱ꞌa̱n ún xíꞌin ndi̱, ¿míkía̱ ki̱xi nda̱yí kéꞌé ún ñayóꞌo? ¿Yu kúu na ta̱xi nda̱yí ndaꞌa̱ ún keꞌé ún chiño yóꞌo saá? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ta yi̱ꞌi̱ kóni i̱ nda̱ka̱ to̱ꞌon i̱ ndóꞌó ñii la̱á to̱ꞌon, ta va̱ꞌa ndakuii̱n ndó yuꞌu̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Míkía̱ ki̱xi nda̱yí ta̱Juan sa̱kuchu ra ni̱vi? ¿Án ta̱xi Ndios nda̱yí ndaꞌa̱ ra? ¿Án ni̱vi kúu na ta̱xi nda̱yí ndaꞌa̱ ra ña sakuchu ra ni̱vi? ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ta saá ki̱xáꞌá na káꞌa̱n táꞌan xíꞌin mi̱i na: ―¿Ndasaá koo ndakuii̱n yó vitin? Chi táná ka̱ꞌa̱n yó Ndios ta̱xi nda̱yí ndaꞌa̱ ta̱Juan, ta saá nda̱ka̱ to̱ꞌon ta̱Jesús mi̱i yó: “¿Nda̱chun o̱n vása ní‑kandixa ndó ña ni̱ka̱ꞌa̱n ra?” ");
INSERT INTO mim_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Táná ka̱ꞌa̱n yó ni̱vi kuiti kúu na ta̱xi nda̱yí ndaꞌa̱ ta̱Juan, ta saá yi̱yo ní sasaa̱ yó nañoo, ta kixáꞌá na tiin na yu̱u̱, ta koon na mi̱i yó, chi ndiꞌi ni̱vi yóꞌo kándixa na ndí ta̱Juan xi̱kuu ra ñii ta̱profeta ―káchí na, káꞌa̱n táꞌan na. ");
INSERT INTO mim_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ta saá nda̱kuii̱n na, káchí na siꞌa xíꞌin ta̱Jesús: ―O̱n xíni̱ ndi̱ yu kúu na ta̱xi nda̱yí ndaꞌa̱ ta̱Juan ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ta saá ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta ni yi̱ꞌi̱, o̱n ka̱ꞌa̱n i̱ xíꞌin ndó míkía̱ ki̱xi nda̱yí kómí i̱ ña kéꞌé i̱ chiño yóꞌo ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ta saá ta̱Jesús nda̱to̱ꞌon ra inka̱ cuento ña sanáꞌa ra na, káchí ra saá: ―Saá ndo̱ꞌo ñii ta̱a, na̱taan ra tón uva, ta saá sa̱tati ra ñoꞌo̱ ra xíꞌin tón uva inka̱ ni̱vi, ta ke̱e ra kua̱ꞌa̱n ra koo ra inka̱ ñoo kua̱ꞌa̱ ní ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ta ki̱xaa̱ yatin ki̱vi̱ ña kaꞌnda na tíuva yóꞌo, ta ta̱ xíꞌin yito̱n tón uva ti̱ꞌví ra ñii ta̱mozo ra kua̱ꞌa̱n ra nakiꞌin ra sava tíuva ña kuu yaꞌvi ra. Ta ni̱vi na táti ñoꞌo̱ no̱o̱ yóo tón uva ti̱in na ta̱mozo yóꞌo, ta ka̱ni ní na ra, ni̱‑xiin na taxi na rí ndaꞌa̱ ra, ta saá ndi̱kó vi̱chí ra kua̱noꞌo̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ta ta̱a ta̱ xíꞌin yito̱n tón uva tuku ti̱ꞌví ra inka̱ ta̱a kua̱ꞌa̱n ra nakiꞌin ra tíuva. Ta ni̱kandiva̱ꞌa na xíꞌin ra, ta ka̱ni ní na ra, ta sa̱kukaꞌan na no̱o̱ ra, ta ta̱xin na ra ndikó ra kua̱noꞌo̱ ra veꞌe ta̱patrón. ");
INSERT INTO mim_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ta ta̱a ta̱ xíꞌin yito̱n tón uva tuku ti̱ꞌví ra inka̱ ta̱mozo kua̱ꞌa̱n ra, ta ti̱in na ra, ta sa̱takuéꞌe̱ ní na ra, ta ta̱xin na ra, kua̱noꞌo̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ta saá ta̱a ta̱ xíꞌin yito̱n tón uva ni̱ka̱ꞌa̱n ra: “¿Yukía̱ koo keꞌé yó vitin? Va̱ꞌa ka̱ tiꞌví yó sa̱ꞌya yó, ta̱ kíꞌvi ní ini yó xíni yó. Tá ni̱vi na táti ñoꞌo̱ yó nakoni na sa̱ꞌya yó yóꞌo, ta kasa to̱ꞌó na ra”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ta ni̱vi na táti ñoꞌo̱ xi̱ni na kíxaa̱ ta̱loꞌo sa̱ꞌya ra, ta ni̱ka̱ꞌa̱n na xíꞌin táꞌan na, káchí na saá: “Ta̱kaa̱ kúu sa̱ꞌya ta̱ na̱taan tón uva, ta sa̱ꞌya ra yóꞌo kúu ta̱ nakiꞌin ñakuíká xíꞌin ñoꞌo̱ yóꞌo táná kivi̱ yivá ra. Naꞌa ndó ná koꞌyo̱ kaꞌni yó ra, ta kindo̱o yó xíꞌin ndiꞌi ñakuíká ra”, káchí na. ");
INSERT INTO mim_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ta saá ti̱in na ra, ta sa̱kana na ra nda̱ sa̱ta̱ na̱ma̱ ña xi̱no nduu no̱o̱ yóo tón uva, ta xa̱ꞌni na ra. Saá ndi̱ꞌi cuento yóꞌo ―káchí ta̱Jesús. Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi na xi̱ni̱ so̱ꞌo cuento yóꞌo: ―¿Vitin yukía̱ keꞌé ta̱ xíꞌin yito̱n tón uva? ");
INSERT INTO mim_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Káꞌa̱n i̱ xíꞌin ndó, ndixa ndikó ra naxaa̱ ra ta sandiꞌi ra xa̱ꞌa̱ ni̱vi na táti ñoꞌo̱ ra. Ta tuku satati ra ñoꞌo̱ ra inka̱ ni̱vi ―káchí ta̱Jesús xíꞌin na. Ta nda̱kuii̱n ni̱vi, ni̱ka̱ꞌa̱n na: ―¡Ná o̱n taxi Ndios kundoꞌo ndi̱ saá! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ta ta̱Jesús xíto ra no̱o̱ na, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Án o̱n vása kúnda̱a̱ ini ndó ña kóni kachí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá, ña káchí saá?: Yóo yu̱u̱ ña ni̱‑xiin ni̱vi na kísa va̱ꞌa veꞌe koni̱ ñóꞌó na, ta mi̱i yu̱u̱ yóꞌo ndu̱u ña yu̱u̱ ñano̱ó nákaa̱ xa̱ꞌa̱ veꞌe, káchí to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ndiꞌi ni̱vi na kakiꞌi ta nakava na sa̱ta̱ yu̱u̱ yóꞌo ndiꞌi xa̱ꞌa̱ na. Ta yu̱u̱ yóꞌo, táná nakava ña sa̱ta̱ ni̱vi, ta chiꞌma ña na nda̱ nduu na yaa̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ta saá nanáꞌno no̱o̱ nasu̱tu̱ xíꞌin na sánáꞌa nda̱yí Ndios xa̱ni si̱ni̱ na ndúkú na ndasaá koo tiin ñaꞌá na, chi nayóꞌo ku̱nda̱a̱ ini na cuento ña ni̱ka̱ꞌa̱n ta̱Jesús ndí káꞌa̱n ña xa̱ꞌa̱ na. Ta ni̱‑kuchiño tiin na ra, chi yíꞌví na ko̱to̱ saa̱ ni̱vi na ndóo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ta saá nanáꞌno no̱o̱ nasu̱tu̱ xíꞌin na sánáꞌa nda̱yí Ndios ti̱ꞌví na sava ni̱vi ña koto ndoso na ta̱Jesús. Ña káꞌa̱n na nda̱tán káꞌa̱n ni̱vi na ndinoꞌo ini, saá ka̱ꞌa̱n nayóꞌo xíꞌin ta̱Jesús, chi kóni na ña sati̱ví na ñii to̱ꞌon káꞌa̱n ra, ta kuchiño na taxi na kua̱chi xa̱ꞌa̱ ra no̱o̱ ta̱gobernador. ");
INSERT INTO mim_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Saá ki̱xaa̱ na no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tata maestro, xíni̱ ndi̱ yóꞌó kúu ún ta̱a ta̱ sánáꞌa ñanda̱a̱. Ta o̱n vása náka̱xin ún ni̱vi, ta ñii ki̱ꞌva káꞌa̱n ún ñanda̱a̱ xíꞌin ndiꞌi na, ni o̱n vása násama ún to̱ꞌon ún, ta sánáꞌa ún ñanda̱a̱ xa̱ꞌa̱ yichi̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ta vitin kóni ndi̱ nda̱ka̱ to̱ꞌon ndi̱ yóꞌó, ¿án va̱ꞌa chaꞌvi yó kota no̱o̱ ta̱rey César ñoo Roma? ¿Án o̱n váꞌa chaꞌvi yó ña? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ta ta̱Jesús kúnda̱a̱ ini ra ndí na o̱vi̱ yuꞌu̱ kúu na, kóni na koto ndoso na ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Nda̱chun kóni ndó koto ndoso ndó yi̱ꞌi̱? ");
INSERT INTO mim_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Taxi ndó ñii si̱ꞌún ná koto i̱ no̱o̱ ña. ¿Yo na̱ꞌná, ta yo ki̱vi̱ kúu ña yóo no̱o̱ si̱ꞌún yóꞌo? ―káchí ta̱Jesús xíꞌin na. Ta nda̱kuii̱n na: ―Si̱ꞌún yóꞌo kómí ña na̱ꞌná xíꞌin ki̱vi̱ ta̱rey César ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Taxi ndó ndaꞌa̱ ta̱rey César ña kúu kuenda ra, ta taxi ndó ndaꞌa̱ Ndios ña kúu kuenda Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ta saá ni̱‑kuchiño naníꞌi na to̱ꞌon ña taxi na kua̱chi xa̱ꞌa̱ ta̱Jesús no̱o̱ nachiño. Ta na̱kaꞌnda ini na chi va̱ꞌa ní ni̱ka̱ꞌa̱n ra, ta ni̱‑naníꞌi na ña ndakuii̱n na. ");
INSERT INTO mim_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nasaduceo ki̱xaa̱ na no̱o̱ ta̱Jesús. Nasaduceo yóꞌo kúu na nanáꞌno na sánáꞌa ta káꞌa̱n na ndí na ni̱xiꞌi̱ o̱n vása nataku̱ ka̱ na. Ta ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ");
INSERT INTO mim_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Tata maestro, nda̱yí Ndios ña ni̱taa ta̱Moisés káchí ña saá: “Tá ñii ta̱a ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya ra ní‑xiyo xíꞌin ñásíꞌí ra, ta ñani ra xíni̱ ñóꞌó tonda̱ꞌa̱ ra xíꞌin ñá ni̱ndo̱o yóꞌo, ña kivi koo sa̱ꞌya na. Nda̱tán koo sa̱ꞌya ta̱ ni̱xiꞌi̱, saá koo sa̱ꞌya nayóꞌo”, káchí nda̱yí ña ni̱taa ta̱Moisés. ");
INSERT INTO mim_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ta, ¿yukía̱ káchí yóꞌó xa̱ꞌa̱ ñayóꞌo? Chi saá ndo̱ꞌo ta̱a, u̱xa̱ ñani kúu ra. Ta̱no̱ó to̱nda̱ꞌa̱ ra xíꞌin ñii ñaꞌa̱, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya ra ní‑xiyo. ");
INSERT INTO mim_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ta ñani ra ta̱o̱vi̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na ní‑xiyo. ");
INSERT INTO mim_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ta ñani ra ta̱u̱ni̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na ní‑xiyo. Ta ñani ra ta̱ko̱mi̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. Ta ñani ra ta̱o̱ꞌo̱n to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. Ta ñani ra ta̱i̱ño̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. Ta ñani ra ta̱u̱xa̱ to̱nda̱ꞌa̱ ra xíꞌin ñáñaꞌa̱ yóꞌo, ta ni̱xiꞌi̱ ra, ta o̱n ko̱ó sa̱ꞌya na. ");
INSERT INTO mim_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ta saá ni̱xiꞌi̱ mi̱i ñáñaꞌa̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ta ki̱vi̱ nataku̱ ndiꞌi na ni̱xiꞌi̱, ¿yukú ta̱a kuu yii̱ ñáñaꞌa̱ yóꞌo?, chi ndiꞌi ta̱a u̱xa̱ ñani ni̱xi̱yo ra xíꞌin ñá ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin na: ―O̱n vása kúnda̱a̱ va̱ꞌa ini ndó xa̱ꞌa̱ ñoyívi ni̱no xíꞌin Ndios. Saá chi ñoyívi yóꞌo kúu no̱o̱ tónda̱ꞌa̱ ta̱a xíꞌin ñaꞌa̱, ta táxi na sa̱ꞌya na tonda̱ꞌa̱ na xíꞌin inka̱ na. ");
INSERT INTO mim_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ta ki̱vi̱ nataku̱ ni̱vi na ni̱xiꞌi̱, o̱n vása tonda̱ꞌa̱ ka̱ na ñoyívi ni̱no, ni o̱n vása taxi na sa̱ꞌya na tonda̱ꞌa̱ na xíꞌin inka̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ta ni̱vi na̱taku̱ o̱n kuchiño kivi̱ ka̱ na, ta nda̱tán yóo naángel saá koo ni̱vi na kundo̱o xíꞌin Ndios. Sa̱ꞌya ndinoꞌo Ndios kuu nayóꞌo, xa̱ꞌa̱ ña nataku̱ na. ");
INSERT INTO mim_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Xa̱ꞌa̱ ña nataku̱ na ni̱xiꞌi̱, mi̱i ta̱Moisés ni̱taa ra to̱ꞌon ña kísa nda̱a̱ ndí ni̱vi na ni̱xiꞌi̱ xíni̱ ñóꞌó nataku̱ na. Saá chi ñii ki̱vi̱ xi̱ni ta̱Moisés yito̱n ñiño̱ xíxi̱ nó, ta saá ni̱ka̱ꞌa̱n Ndios xíꞌin ra, ka̱chí ra saá: “Yi̱ꞌi̱ kúu Ndios no̱o̱ ta̱Abraham, ta̱Isaac, xíꞌin ta̱Jacob, ta nayóꞌo kísa káꞌno na yi̱ꞌi̱”, ka̱chí Ndios xíꞌin ta̱Moisés. ");
INSERT INTO mim_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ta xíꞌin to̱ꞌon yóꞌo kúnda̱a̱ ini yó ndí táku̱ ka̱ xi̱i̱ síkuá yó yóꞌo. Ndóꞌó káchí ndó na ni̱xiꞌi̱ kúu na, ta no̱o̱ Ndios nayóꞌo táku̱ na, chi na ndixa ni̱xiꞌi̱ o̱n kúchiño na kasa káꞌno na Ndios ―káchí ta̱Jesús xíꞌin nasaduceo. ");
INSERT INTO mim_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ta ni̱ka̱ꞌa̱n sava na sánáꞌa nda̱yí Ndios: ―Va̱ꞌa ní káꞌa̱n ún, tata maestro ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ta saá nasaduceo ni̱‑xiin ka̱ na nda̱ka̱ to̱ꞌon na ra ña koto ndoso na ra. ");
INSERT INTO mim_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra na ndóo xíꞌin ra: ―¿Nda̱chun káchí na ndí Cristo, ta̱ tiꞌví Ndios saka̱ku ra ni̱vi, kuu ñii sa̱ꞌya ñani síkuá ta̱rey David? ");
INSERT INTO mim_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Chi mi̱i ta̱rey David ni̱taa ra no̱o̱ tutu na̱ní ña Salmos, ka̱chí ra saá: Ndios ni̱ka̱ꞌa̱n ra xíꞌin ta̱Káꞌno no̱o̱ i̱: “Koo ún xíꞌin i̱ sii̱n kuaꞌá i̱ no̱o̱ táyi̱ tón to̱ꞌó yóꞌo, ");
INSERT INTO mim_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ta̱nda̱ ki̱vi̱ taxi i̱ ko̱yo ndiꞌi na káni táꞌan xíꞌin ún ti̱xin xa̱ꞌa̱ ún”, ka̱chí Ndios, ni̱taa ta̱David xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Xíꞌin to̱ꞌon yóꞌo ta̱David ka̱chí ra Cristo kúu ta̱Káꞌno no̱o̱ ra. Ta, ¿mí kúchiño kúu Cristo sa̱ꞌya ñani síkuá ta̱David? ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tá xíni̱ so̱ꞌo ndiꞌi ni̱vi, ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Koto va̱ꞌa ndó o̱n kundiko̱n ndó yichi̱ ni̱vi na sánáꞌa nda̱yí Ndios, chi kuiti káꞌvi na nda̱yí ta o̱n vása kasa ndivi na ña. Kísa káꞌno xíꞌin mi̱i na, kúsii̱ ní ini na kundixin na tiko̱to̱ va̱ꞌa, ta kua̱ꞌa̱n va̱xi na no̱o̱ ni̱vi ña koto ñaꞌá na. Ta xíka na no̱yáꞌvi, ta kóni na ña kasa to̱ꞌó ní ni̱vi na, ta kútoo ní na kundo̱o na táyi̱ tón náꞌno tón to̱ꞌó yóo veꞌe ño̱ꞌo sinagoga. Ta no̱o̱ yóo viko̱ xíxi, ndúkú na kundo̱o na no̱o̱ táyi̱ náꞌno tón to̱ꞌó. ");
INSERT INTO mim_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ta kéꞌé na ña o̱n váꞌa, chi kíndaa na veꞌe náñaꞌa̱ ná ni̱xiꞌi̱ yii̱. Ta ndi̱ꞌi ke̱ꞌé na saá ta xíꞌin ñavatá ini na, xáꞌa̱n na veꞌe ño̱ꞌo sinagoga, ta naꞌá ní káꞌa̱n na xíꞌin Ndios. Kéꞌé na saá xa̱ꞌa̱ ña kóni na kani si̱ni̱ ni̱vi ndí nayóꞌo kúu nava̱ꞌa ní no̱o̱ Ndios. Ta xa̱ꞌa̱ ña o̱n váꞌa kéꞌé na, Ndios saxo̱ꞌvi̱ ka̱ ra nayóꞌo no̱o̱ inka̱ ni̱vi ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ta ta̱Jesús yóo ra yéꞌé veꞌe ño̱ꞌo káꞌno, ta xi̱to ra ni̱vi nakuíká táan na si̱ꞌún ini caja ña ñóꞌo si̱ꞌún xa̱ꞌa̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ta xi̱ni ra ñii ñaꞌa̱ ñándáꞌví ñá ni̱xiꞌi̱ yii̱, táan ñá o̱vi̱ si̱ꞌún kuálí ini caja, ta loꞌo ní ndáka̱ si̱ꞌún yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra: ―Ndixa káꞌa̱n i̱ xíꞌin ndó, ñándáꞌví yóꞌo ta̱xi víꞌí ka̱ ñá si̱ꞌún no̱o̱ ña ta̱xi nakuíká. ");
INSERT INTO mim_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chi nakuíká, vará ta̱xi na kua̱ꞌa̱ ní si̱ꞌún, ta ki̱ndo̱o víꞌí ní ka̱ ña ndaꞌa̱ mi̱i na. Ta ñándáꞌví yóꞌo, vará loꞌo ní si̱ꞌún níꞌi ñá, ta ta̱xi ndiꞌi ñá si̱ꞌún ña kómí ñá, ta saá sa̱ndakoo ñá ndiꞌi ña xíni̱ ñóꞌó ñá ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ta sava naxíka xíꞌin ta̱Jesús káꞌa̱n táꞌan na ndí livi ní yóo yu̱u̱ ñóꞌo ku̱va̱ꞌa veꞌe ño̱ꞌo káꞌno, ta livi ní náꞌa inka̱ ña sa̱níꞌi ni̱vi koo ini veꞌe ño̱ꞌo yóꞌo. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ");
INSERT INTO mim_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ñii ki̱vi̱ ña va̱xi ndiꞌi ñalivi ña xíto ndó veꞌe ño̱ꞌo yóꞌo, ndiꞌi xa̱ꞌa̱ ña, ta nda̱ ñii ka̱ yu̱u̱, o̱n kóo ka̱ sa̱ta̱ inka̱ yu̱u̱. Saá chi tani veꞌe ño̱ꞌo ta ndiꞌi xa̱ꞌa̱ ndiꞌi ña ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ta ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús: ―Tata Maestro, ¿ama koo saá ña ka̱chí ún? ¿Ndá seña kuu ña koni ndi̱ ña kunda̱a̱ ini ndi̱ ña xa yatin ndiꞌi xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno yóꞌo? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ta nda̱kuii̱n ta̱Jesús: ―Koto va̱ꞌa ndó ña o̱n sandáꞌví ni̱vi ndóꞌó. Saá chi kua̱ꞌa̱ ní ta̱a kixaa̱, ta ki̱vi̱ kixaa̱ ñii ñii na, ta ka̱ꞌa̱n na xíꞌin ndó, kachí na saá: “Yi̱ꞌi̱ kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ni̱vi ñoyívi yóꞌo, ta xa yatin to̱nda̱a ki̱vi̱ kixáꞌá kaꞌnda chiño i̱ no̱o̱ na ñoyívi yóꞌo”, kachí na xíꞌin ndó. Ta o̱n kundiko̱n ndó sa̱ta̱ ni̱vi na káꞌa̱n saá xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ta koni̱ so̱ꞌo ndó yóo kua̱chi xáꞌni táꞌan na ñoo yatin, ta xáꞌni táꞌan na ñoo xíká, ta o̱n kuyi̱ꞌví ndó. Chi xíni̱ ñóꞌó kundivi ndiꞌi ñayóꞌo, ta saá ni, ta̱ꞌán ka̱ kixaa̱ ki̱vi̱ sondíꞌí ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","’Ki̱vi̱ ña va̱xi nakuita ni̱vi na ñoo náꞌno kaꞌni táꞌan na xíꞌin ni̱vi na inka̱ ñoo náꞌno, ta ñoo no̱o̱ yóo narey kaꞌni táꞌan na xíꞌin inka̱ ñoo no̱o̱ yóo inka̱ narey. ");
INSERT INTO mim_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ta kua̱ꞌa̱ ní xiiña ndeé ní ta̱an no̱o̱ ñoꞌo̱, ta koo ní so̱ko, ta kua̱ꞌa̱ ní ñoo kunakaa̱ ndiꞌi no̱o̱ kue̱ꞌe̱, ta ñoyívi ni̱no koo seña náꞌno koni na, ta yi̱ꞌví ní ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ta saá ni, tá ta̱ꞌán ka̱ kixaa̱ ki̱vi̱ kundivi ñayóꞌo, ta xo̱ꞌvi̱ ní ndóꞌó, chi sava ni̱vi tiin na ndóꞌó, ta nataxi na ndóꞌó ndaꞌa̱ nanáꞌno veꞌe ño̱ꞌo sinagoga, ta taan na ndóꞌó ini veꞌe ka̱a. Taxi na kua̱chi xa̱ꞌa̱ ndó no̱o̱ nagobernador án no̱o̱ narey chi na ndíko̱n yi̱ꞌi̱ kúu ndó. ");
INSERT INTO mim_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tá kundo̱o ndó no̱o̱ nachiño yóꞌo, ta saá kukomí ndó yichi̱ ka̱ꞌa̱n ndó to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ta o̱n kundiꞌi ini ndó xa̱ꞌa̱ to̱ꞌon ña ndakuii̱n ndó no̱o̱ nachiño, ");
INSERT INTO mim_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","chi yi̱ꞌi̱ taxi i̱ to̱ꞌon xíꞌin ñandíchí si̱ni̱ ndó, ta saá ka̱ꞌa̱n ndó xíꞌin na. Ta ni̱vi na o̱n xi̱in koni ndóꞌó, o̱n kívi naníꞌi na to̱ꞌon ña ndakuii̱n na yuꞌu̱ ndó. ");
INSERT INTO mim_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ta ki̱vi̱ ña va̱xi, ta yivá ndó, án siꞌí ndó, án ñani ndó, án inka̱ naveꞌe ndó, án migo ndó chikaa̱ na kua̱chi sa̱ta̱ ndó, ta kaꞌni na sava ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ndiꞌi ni̱vi ñoyívi yóꞌo kusaa̱ ini na koni na ndóꞌó chi na ndíko̱n yi̱ꞌi̱ kúu ndó. ");
INSERT INTO mim_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ta Ndios kundaa va̱ꞌa ra ndóꞌó, ta nda̱ ñii yisi̱ si̱ni̱ ndó, o̱n taxi ra ña ndiꞌi xa̱ꞌa̱ ña. ");
INSERT INTO mim_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tá o̱n vása sandakoo ndó yichi̱ i̱, ta kundiko̱n va̱ꞌa ndó ña, nda̱ kixaa̱ ki̱vi̱ ndi̱ꞌi ña xo̱ꞌvi̱ ndó, ta Ndios saka̱ku ra ndóꞌó ña kutaku̱ ndó xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Tá xíto ndó xa xi̱no nduu natropa ñoo Jerusalén yóꞌo, ta saá kunda̱a̱ ini ndó xa ki̱xaa̱ ki̱vi̱ ndiꞌi xa̱ꞌa̱ ña. ");
INSERT INTO mim_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ta ki̱vi̱ yóꞌo, ndiꞌi ni̱vi na ndóo estado Judea yóꞌo, xíni̱ ñóꞌó kono na ko̱ꞌo̱n na no̱o̱ yóo yuku̱ síkón. Ta ndiꞌi ni̱vi na ndóo ñoo Jerusalén xíni̱ ñóꞌó kee ndiꞌi na ko̱ꞌo̱n na. Ta ndiꞌi ni̱vi na ndóo yuku̱, o̱n váꞌa ndi̱ꞌvi na ñoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Saá chi ki̱vi̱ yóꞌo Ndios xíni̱ ñóꞌó saxo̱ꞌvi̱ ra nañoo Jerusalén, ta saá kundivi ndiꞌi to̱ꞌon ra ña ni̱taa na xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ndáꞌví ní náñaꞌa̱ ná ñóꞌo sa̱ꞌya, ta ndáꞌví ní náñaꞌa̱ ná yóo sa̱ꞌya válí na chíchín ki̱vi̱ kán!, chi ndeé ní koo ña xo̱ꞌvi̱ ni̱vi ñoyívi, ta ndeé ní saxo̱ꞌvi̱ Ndios nañoo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Natropa kaꞌni na sava ni̱vi xíꞌin espada, ta tiin na inka̱ ni̱vi ko̱ꞌo̱n xíꞌin na kua̱ꞌa̱ ní ñoo xíká, ta kán kasa ndu̱xa̱ na xíꞌin na ña kasa chiño na. Ta ni̱vi na o̱n si̱ví najudío kúu, kuu na kaꞌnda chiño no̱o̱ nañoo Jerusalén. Saá koo ta̱nda̱ to̱nda̱a ki̱vi̱ ña chi̱tóni̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ki̱vi̱ xa yatin ndikó i̱ ñoyívi yóꞌo koni ndó seña ñoyívi ni̱no: koto ndó koo seña xíꞌin ki̱mi, xíꞌin yo̱o̱, xíꞌin ño̱ꞌo káꞌno ña yéꞌe. Ta ndiꞌi ni̱vi ñoyívi ndiꞌi ní ini na, ta yi̱ꞌví ní na koni na takuií mi̱ni, chi ndeé ní ni̱ꞌi̱ rá ta nakuita ní ya̱ka̱ rá no̱o̱ rá. ");
INSERT INTO mim_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sava ni̱vi nda̱ kivi̱ ndu̱ú na xíꞌin ña yíꞌví ní na, ta o̱n vása kunda̱a̱ ini na yukía̱ kundoꞌo ñoyívi yóꞌo. Saá chi ndiꞌi ña kómí ndee̱ yóo ñoyívi ni̱no kanda ña ta kisin ndiꞌi ñayóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ta saá ndiꞌi ni̱vi koni na yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ta va̱xi i̱ ma̱ꞌñó vi̱ko̱, xíꞌin ndee̱ káꞌno, xíꞌin ndiꞌi ña yéꞌe livi. ");
INSERT INTO mim_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tá kíxáꞌá xíto ndó seña ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó, ta va̱ꞌa kusii̱ ní ini ndó, ta koto ndaa ndó ñoyívi ni̱no, chi xa va̱xi kuyatin ki̱vi̱ ndikó i̱ saka̱ku i̱ ndóꞌó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ta saá nda̱to̱ꞌon ta̱Jesús ñii cuento ña sanáꞌa ra na: ―Va̱ꞌa koto ndó yito̱n higo, án ndiꞌi inka̱ yito̱n. ");
INSERT INTO mim_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tá xa va̱xi nduxa̱á nó ta nákoo yu̱ku̱ yúta̱ ndaꞌa̱ nó, ta saá kúnda̱a̱ ini ndó xa ni̱kuyatin ní kixaa̱ sa̱vi̱. ");
INSERT INTO mim_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ta ki̱vi̱ xíto ndó xa kua̱ꞌa̱n kundivi ndiꞌi ñayóꞌo ña nda̱to̱ꞌon i̱ xíꞌin ndó, ta saá kunda̱a̱ ini ndó xa va̱xi kuyatin ki̱vi̱ kixáꞌá kaꞌnda chiño Ndios ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ta ndixa káꞌa̱n i̱ xíꞌin ndó, ni̱vi na xíto kixáꞌá seña yóꞌo kutaku̱ ka̱ na nda̱ ndi̱ꞌi ku̱ndivi ndiꞌi ña nda̱to̱ꞌon i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ña ñoyívi ni̱no xíꞌin ña ñoyívi yóꞌo ñii ki̱vi̱ va̱xi ndiꞌi xa̱ꞌa̱ ña, ta to̱ꞌon i̱ o̱n ndiꞌi xa̱ꞌa̱ ña, ta kindo̱o ña ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ta koto va̱ꞌa xíꞌin mi̱i ndó ña o̱n nduu ndó ni̱vi nasóꞌó, na o̱n vása kandixa ka̱ Ndios. O̱n kutaku̱ ndó nda̱tán káchí níma̱ mi̱i ndó, ni o̱n kuu ndó ni̱vi na xíini, ni o̱n kuu ndó ni̱vi na ndíꞌi ní ini xa̱ꞌa̱ chiño ñoyívi yóꞌo. Saá chi xíni̱ ñóꞌó koo tiꞌva ndó kundati ndó yi̱ꞌi̱, ko̱to̱ nakaꞌnda ini ndó ki̱vi̱ ndikó i̱. ");
INSERT INTO mim_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chi nda̱tán kama ní nákava ñono̱ sakako̱ꞌon ña kiti̱, saá kixaa̱ ki̱vi̱ ña ndikó i̱ no̱o̱ ni̱vi na ndóo ndiꞌi saá xiiña ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ta ndóꞌó, xíni̱ ñóꞌó kundo̱o tiꞌva ndó ndiꞌi saá ki̱vi̱ xa̱ꞌa̱ ña ndikó i̱. Ndiꞌi saá ki̱vi̱ ndukú ndó no̱o̱ Ndios ña taxi ra ndee̱ ña kuchiño kundeé ndó no̱o̱ ndiꞌi ña yo̱ꞌvi̱ va̱xi, ta saá kuchiño kuita ndó no̱o̱ yi̱ꞌi̱ ki̱vi̱ ndikó i̱ ñoyívi yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ta ndiꞌi saá ki̱vi̱ ta̱Jesús sánáꞌa ra ni̱vi veꞌe ño̱ꞌo káꞌno ñoo Jerusalén, ta xa kua̱ꞌa̱n kuñoó, kée ra xáꞌa̱n ra xi̱ki̱ tón Olivo. ");
INSERT INTO mim_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ta ndiꞌi saá xita̱a̱n va̱xi ni̱vi veꞌe ño̱ꞌo yóꞌo ña koni̱ so̱ꞌo na to̱ꞌon ña káꞌa̱n ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Xa ni̱kuyatin ní kana viko̱ Pascua, ta viko̱ yóꞌo naIsrael xíxi na si̱ta̱ va̱ꞌa ña o̱n ko̱ó levadura kómí. ");
INSERT INTO mim_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ta na sánáꞌa nda̱yí Ndios xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ ndúkú na ndasaá koo kaꞌni seꞌé na ta̱Jesús, chi yíꞌví na no̱o̱ ni̱vi na ndíko̱n sa̱ta̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ta ñandiva̱ꞌa káꞌno Satanás ni̱ki̱ꞌvi ña ini ta̱Judas Iscariote ta̱ kúu ñii ta̱a ta̱ u̱xu̱ o̱vi̱ xíka xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ta saá ke̱e ra ni̱xa̱ꞌa̱n ra no̱o̱ nanáꞌno no̱o̱ nasu̱tu̱ xíꞌin nanáꞌno no̱o̱ napolicía na ndáa veꞌe ño̱ꞌo káꞌno, ta ni̱ka̱ꞌa̱n ra xíꞌin na ndasaá koo nataxi ra ta̱Jesús ndaꞌa̱ na. ");
INSERT INTO mim_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ta ku̱sii̱ ní ini na xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱Judas xíꞌin na, ta nayóꞌo ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tá nataxi ún ra ndaꞌa̱ ndi̱, ta taxaꞌvi ndi̱ yóꞌó ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ta ta̱Judas ki̱ndo̱o ra saá xíꞌin na, ta ki̱xáꞌá ndúkú ra ndasaá koo nataxi ra ta̱Jesús ndaꞌa̱ na. Ndúkú ra ki̱vi̱ ña o̱n ko̱ó kua̱ꞌa̱ ní ni̱vi xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Saá ni̱to̱nda̱a ki̱vi̱ viko̱ najudío xíxi na si̱ta̱ va̱ꞌa ña o̱n ko̱ó levadura kómí, ta ñii ñii veꞌe na xáꞌni na ndikachi loꞌo ña nákáꞌán na viko̱ Pascua. ");
INSERT INTO mim_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱Pedro xíꞌin ta̱Juan, káchí ra: ―Kua̱ꞌa̱n ndó kasa ndivi ndó ña kuxu yó viko̱ Pascua. ");
INSERT INTO mim_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na: ―¿Míkía̱ kóni ún kasa ndivi ndi̱ ña? ");
INSERT INTO mim_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Kua̱ꞌa̱n ndó, ta kua̱ꞌa̱n ki̱ꞌvi ndó ñoo Jerusalén, ta nakutáꞌan ndó xíꞌin ñii ta̱a ndíso ki̱si takuií, ta kundiko̱n ndó ko̱ꞌo̱n ndó sa̱ta̱ ra nda̱ naxaa̱ ta̱yóꞌo veꞌe ra no̱o̱ ki̱ꞌvi ra, ");
INSERT INTO mim_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ta ka̱ꞌa̱n ndó xíꞌin ta̱a ta̱ xíꞌin veꞌe yóꞌo, kachí ndó saá: “Ta̱Maestro ti̱ꞌví ndi̱ꞌi̱ va̱xi ndi̱ nda̱ka̱ to̱ꞌon ndi̱ yóꞌó: ¿Míkía̱ yóo ñii cuarto veꞌe ún no̱o̱ kuxu ra viko̱ Pascua xíꞌin ndi̱, naxíka xíꞌin ra?”, kachí ndó. ");
INSERT INTO mim_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ta saá ta̱a ta̱ xíꞌin veꞌe sanáꞌa ra ndóꞌó míkía̱ yóo ñii cuarto veꞌe ra ña kánóo piso o̱vi̱, no̱o̱ yóo ndiꞌi ña xíni̱ ñóꞌó ndó. Ta veꞌe yóꞌo kasa ndivi ndó ña kuxu yó viko̱ Pascua ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ta ke̱e na kua̱ꞌa̱n na, ta ni̱ki̱ꞌvi na ñoo Jerusalén, ta na̱níꞌi na nda̱tán yóo ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, ta ki̱sa ndivi na ña kuxu na viko̱ Pascua. ");
INSERT INTO mim_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ta xikuaa ta xa kua̱ꞌa̱n kunaa, ki̱xaa̱ ta̱Jesús xíꞌin u̱xu̱ o̱vi̱ naxíka xíꞌin ra, ta xi̱kundo̱o na no̱o̱ mesa kuxu na. ");
INSERT INTO mim_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Xa naꞌá ní kóni i̱ kuxu i̱ xíꞌin ndó viko̱ Pascua yóꞌo, ki̱vi̱ siꞌna ka̱ no̱o̱ ña kixaa̱ ña xo̱ꞌvi̱ i̱. ");
INSERT INTO mim_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ndixa káꞌa̱n i̱ xíꞌin ndó, o̱n kuxu ka̱ i̱ xíꞌin ndó inka̱ viko̱ Pascua nda̱ ndixa kasa ndivi i̱ chiño ña kasa nda̱a̱ xa̱ꞌa̱ viko̱ yóꞌo, ta̱nda̱ nakutáꞌan yó no̱o̱ xáꞌnda chiño Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ta saá ki̱ꞌin ta̱Jesús ñii copa ña ñóꞌo vino, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios: ―Tata Yivá yó, táxaꞌvi ún chi ta̱xi ún nduta̱ koꞌo ndi̱ yóꞌo ―káchí ra, ta ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra: ―Kiꞌin ndó ña ñóꞌo vino yóꞌo, ta ñii ñii ndó koꞌo loꞌo ndó. ");
INSERT INTO mim_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ndixa káꞌa̱n i̱ xíꞌin ndó, o̱n koꞌo ka̱ i̱ vino ta̱nda̱ ki̱xaa̱ ki̱vi̱ nakutáꞌan yó no̱o̱ xáꞌnda chiño Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ta ki̱ꞌin ra si̱ta̱ va̱ꞌa, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios: ―Tata Yivá yó, táxaꞌvi ún chi ta̱xi ún si̱ta̱ va̱ꞌa kuxu ndi̱ ―káchí ra. Ta ta̱ꞌví ra si̱ta̱ va̱ꞌa, ta ta̱xi ra ña ndaꞌa̱ ñii ñii naxíka xíꞌin ra kuxu na. Ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Nakiꞌin ndó kuxu ndó si̱ta̱ va̱ꞌa yóꞌo, chi ñayóꞌo kúu yi̱kí ko̱ñu i̱ ña taxi i̱ xa̱ꞌa̱ ndó. Ta nda̱tán ta̱ꞌví i̱ si̱ta̱ va̱ꞌa ña kuxu ndó vitin, saá ki̱vi̱ ña va̱xi taꞌví ndó si̱ta̱ va̱ꞌa ta kuxu ndó ña xa̱ꞌa̱ ña nakáꞌán ndó yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ta ndi̱ꞌi xi̱xi na, ta ki̱ꞌin ta̱Jesús copa ña ñóꞌo vino, ta ni̱ka̱ꞌa̱n ra: ―Nduta̱ yóꞌo kúu ni̱i̱ i̱ ña kui̱ta̱ xa̱ꞌa̱ ndóꞌó. Ta xíꞌin ñayóꞌo Ndios chindúꞌu̱ ra pacto xa̱á ña ka̱ꞌa̱n ndasaá kuchiño nakiꞌin ndó ñava̱ꞌa Ndios. ");
INSERT INTO mim_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Ta vitin ñii ndóꞌó na xíxi xíꞌin i̱ kúu ta̱a ta̱ si̱kó kuíꞌná yi̱ꞌi̱ no̱o̱ ni̱vi na sáa̱ ini xíni yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ndixa xo̱ꞌvi̱ ní i̱ ta kivi̱ i̱, nda̱tán chi̱tóni̱ Ndios. Ta, ¡ndáꞌví ní ta̱a ta̱ si̱kó yi̱ꞌi̱ no̱o̱ ni̱vi na sáa̱ ini xíni yi̱ꞌi̱! ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ta ki̱xáꞌá naxíka xíꞌin ra ni̱nda̱ka̱ to̱ꞌon táꞌan na yukú ta̱a nataxi ta̱Jesús ndaꞌa̱ na sáa̱ ini xíni ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ta saá ki̱xáꞌá na náa ní na xa̱ꞌa̱ yu kúu ta̱ káꞌno ka̱ no̱o̱ ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Narey na xáꞌnda chiño no̱o̱ na ñoo inka̱ xiiña, nayóꞌo kísa káꞌno xíꞌin mi̱i na, ta yáꞌa ní ndeé xáꞌnda chiño na no̱o̱ ni̱vi. Ta narey yóꞌo sákunaní xíꞌin mi̱i na: Na va̱ꞌa ní kéꞌé chiño ña chindeé na ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ta mi̱i ndó, o̱n váꞌa kutaku̱ ndó saá. O̱n kasa káꞌno xíꞌin mi̱i ndó, ta va̱ꞌa ka̱ kasa ni̱no̱ xíꞌin mi̱i ndó. Tá ñii ta̱a kúu ta̱káꞌno no̱o̱ ndóꞌó, ta xíni̱ ñóꞌó nduu ra ta̱ kasa chiño no̱o̱ ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ta saá ni̱nda̱ka̱ to̱ꞌon ta̱Jesús naxíka xíꞌin ra: ―¿Yukía̱ káchí ndó? ¿Yu kúu ta̱káꞌno ka̱, án ta̱a ta̱ xíxi no̱o̱ mesa, án ta̱a ta̱ kísa chiño no̱o̱ ta̱ xíxi? ¿Án o̱n ndixa ta̱káꞌno ka̱ kúu ta̱ xíxi no̱o̱ mesa? Ta yi̱ꞌi̱, vará ta̱Káꞌno no̱o̱ ndó kúu i̱, ta nda̱tán kéꞌé ta̱ kísa chiño no̱o̱ ndó, saá kéꞌé i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ta ndóꞌó kúu na xi̱ndo̱o xíꞌin i̱ ki̱vi̱ ña ni̱yaꞌa i̱ kua̱ꞌa̱ ní tondóꞌó yo̱ꞌvi̱, ta o̱n vása ní‑sandakoo ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ta yi̱ꞌi̱ taxi i̱ nda̱yí ndaꞌa̱ ndó ña kaꞌnda chiño ndó, nda̱tán Yivá i̱ Ndios xa ta̱xi ra nda̱yí ndaꞌa̱ i̱ kaꞌnda chiño i̱. ");
INSERT INTO mim_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ta ña̱kán kuchiño kuxu ndó ta koꞌo ndó xíꞌin i̱ no̱o̱ mesa no̱o̱ xáꞌnda chiño yi̱ꞌi̱, ta kundo̱o ndó u̱xu̱ o̱vi̱ táyi̱ náꞌno, ta kaꞌnda chiño ndó no̱o̱ na u̱xu̱ o̱vi̱ tiꞌvi ni̱vi nañoo Israel ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ta̱Pedro, káchí ra saá: ―Simón, Simón, ¡koto ví!, chi ñandiva̱ꞌa Satanás xa ndu̱kú ña yichi̱ no̱o̱ Ndios ña ndeé ní koto ndoso ña ndóꞌó. Nda̱tán ndóꞌo ndiki̱n trigo ki̱vi̱ sáxixin na ña, saá kundoꞌo ndó. ");
INSERT INTO mim_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ta yi̱ꞌi̱, xa xa̱ku ndáꞌví i̱ no̱o̱ Ndios xa̱ꞌa̱ ún xa̱ꞌa̱ ña o̱n sandakoo ún kándixa ún yi̱ꞌi̱. Ta yóꞌó, ta ndi̱ꞌi ni̱yaꞌa ñayóꞌo ta tuku kundiko̱n ún yichi̱ i̱, ta saá chindeé ún natáꞌan ún ña va̱ꞌa kundiko̱n na yichi̱ i̱ xíꞌin ún ―káchí ta̱Jesús xíꞌin ta̱Pedro. ");
INSERT INTO mim_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ta nda̱kuii̱n ta̱Pedro, ni̱ka̱ꞌa̱n ra: ―Tata, yóo tiꞌva i̱ ko̱ꞌo̱n i̱ xíꞌin ún nda̱ veꞌe ka̱a, án nda̱ kivi̱ i̱ xíꞌin ún ―káchí ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Ndixa káꞌa̱n i̱ xíꞌin ún, ta̱ꞌán ka̱ kana nduxú chée ñoó vitin, ta xa u̱ni̱ yichi̱ ni̱ka̱ꞌa̱n ún xíꞌin ni̱vi ña o̱n vása xíni̱ ún yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin inka̱ naxíka xíꞌin ra: ―Nákáꞌán ndó ki̱vi̱ ña ni̱yaꞌa, ki̱vi̱ ti̱ꞌví i̱ ndóꞌó ni̱xa̱ꞌa̱n ndó kua̱ꞌa̱ ní ñoo ni̱ka̱ꞌa̱n ndó to̱ꞌon ñava̱ꞌa xa̱ꞌa̱ Ndios. Vará o̱n ko̱ó leká ní‑xiniꞌi ndó, ni o̱n ko̱ó inka̱ ndu̱xa̱n ní‑xiniꞌi ndó, ta, ¿án ki̱sa ma̱ni̱ ñii ña̱ꞌa xíni̱ ñóꞌó ndó? ―káchí ta̱Jesús xíꞌin na. Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na xíꞌin ra: ―Óꞌon Tata, o̱n ko̱ó ña̱ꞌa ní‑kisa ma̱ni̱ ndaꞌa̱ ndi̱ ki̱vi̱ ni̱xa̱ꞌa̱n ndi̱ ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ta vitin yóo inka̱ ña ndáto̱ꞌon i̱ xíꞌin ndó: Tá kómí ndó si̱ꞌún, kuniꞌi ndó ña. Tá o̱n ko̱ó espada níꞌi ndó, ta va̱ꞌa si̱kó ndó tika̱chí ndó ta sata ndó espada kuniꞌi ndó. ");
INSERT INTO mim_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Chi vitin tónda̱a ki̱vi̱ ña kundivi to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá xa̱ꞌa̱ i̱, káchí ña saá: “Ñii ki̱ꞌva nda̱tán xóꞌvi̱ ta̱a ta̱ o̱n váꞌa, saá kundoꞌo ta̱a ta̱ ki̱xi no̱o̱ Ndios”, káchí ña. Ta ndiꞌi to̱ꞌon Ndios ña ni̱taa na xa̱ꞌa̱ i̱ xíni̱ ñóꞌó kundivi ndiꞌi ña ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ta nda̱kuii̱n naxíka xíꞌin ra, ni̱ka̱ꞌa̱n na: ―Tata, yóꞌo yóo o̱vi̱ espada ―káchí na. Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Xa va̱ꞌa ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Saá ke̱e ta̱Jesús ñoo Jerusalén, na̱kiꞌin ra kua̱ꞌa̱n ra xi̱ki̱ tón Olivo, no̱o̱ xáꞌa̱n ra kua̱ꞌa̱ ní yichi̱ táꞌan ñoó. Ta naxíka xíꞌin ra ndíko̱n na sa̱ta̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ta ni̱xaa̱ na, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ndukú ndó no̱o̱ Ndios ña chindeé ra ndóꞌó ña kundeé ndó no̱o̱ ña va̱xi koto ndoso ndóꞌó, ta o̱n nakava ndó kua̱chi ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ta saá ta̱Jesús ke̱e ra kua̱ꞌa̱n ra ñii xíká ka̱ loꞌo, ta ñii ki̱ꞌva no̱o̱ nakava yu̱u̱ ña sákana yó xíꞌin ndaꞌa̱ yó, saá kúu ñaxíká kua̱ꞌa̱n ra no̱o̱ na, ta xi̱kuxítí ra káꞌa̱n ra xíꞌin Ndios: ");
INSERT INTO mim_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","―Tata Yivá mi̱i i̱, tá kóni ún, ta o̱n taxi ún ña xo̱ꞌvi̱ ní i̱ yóꞌo. Ta saá ni, o̱n kundivi ña kóni mi̱i i̱, ta va̱ꞌa ka̱ ná kundivi ña kóni mi̱i ún ―káchí ta̱Jesús xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ta saá ñii ñaángel ña ki̱xi no̱o̱ Ndios, ki̱xaa̱ ña no̱o̱ ta̱Jesús taxi ña ndee̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ta ki̱xáꞌá xóꞌvi̱ ní ta̱Jesús xíꞌin ña ndíꞌi ní ini ra, ta xíꞌin ndiꞌi níma̱ ra ni̱ka̱ꞌa̱n ra xíꞌin Ndios, ta ni̱xi̱no̱ táti̱i̱n ra. Nda̱tán yóo ni̱i̱, saá ni̱xi̱yo táti̱i̱n ra, ta na̱ko̱yo táti̱i̱n ra nda̱ no̱o̱ ñoꞌo̱. ");
INSERT INTO mim_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ta ndi̱ꞌi ni̱ka̱ꞌa̱n ra xíꞌin Ndios, ta na̱kundichi ra ndi̱kó ra ki̱xaa̱ ra no̱o̱ naxíka xíꞌin ra. Ta nayóꞌo ni̱‑kuchiño kundeé na xíꞌin ña kúchuchú ní ini na, ta ña̱kán ni̱ki̱si̱n ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―¿Nda̱chun kísi̱n ní ndó? Va̱ꞌa ndakoo ndó, ta ndukú ndó no̱o̱ Ndios ña chindeé ra ndóꞌó ña o̱n vása nakava ndó kua̱chi ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ta ta̱ꞌán ka̱ ndiꞌi ka̱ꞌa̱n ta̱Jesús xíꞌin na, ta ki̱xaa̱ ñii tiꞌvi káꞌno ni̱vi no̱o̱ ra. Ta ta̱Judas Iscariote ta̱ kúu ñii ta̱ u̱xu̱ o̱vi̱ xíka xíꞌin ta̱Jesús, va̱xi siꞌna ra, ta ki̱xaa̱ ra, ta kóni ra chi̱to ra no̱o̱ ta̱Jesús ña chindeé ñaꞌá ra. ");
INSERT INTO mim_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Tata Judas, ¿án xíꞌin ña chi̱to ún no̱o̱ i̱, nataxi ún yi̱ꞌi̱ ndaꞌa̱ ni̱vi na sáa̱ ini xíni yi̱ꞌi̱? ―káchí ra xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tá naxíka xíꞌin ta̱Jesús xi̱to na ñayóꞌo, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá na: ―Tata, ¿án kani ndi̱ nayóꞌo xíꞌin espada? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ta xa̱ndi̱ko̱n ñii ta̱xíka xíꞌin ta̱Jesús ta̱va ra espada, ta ka̱ndoso va̱ꞌa ra so̱ꞌo kuaꞌá ñii ta̱a ta̱ kísa chiño no̱o̱ ta̱káꞌno no̱o̱ nasu̱tu̱. ");
INSERT INTO mim_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Xa va̱ꞌa, o̱n keꞌé ka̱ ndó saá ―káchí ra. Ta ni̱to̱nda̱a ndaꞌa̱ ra so̱ꞌo ta̱a ta̱kuéꞌe̱, ta sa̱ndaꞌa ra ña. ");
INSERT INTO mim_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin nanáꞌno no̱o̱ nasu̱tu̱, xíꞌin nanáꞌno no̱o̱ napolicía na ndáa veꞌe ño̱ꞌo káꞌno, xíꞌin inka̱ naxi̱kua̱ꞌa̱, na kóni tiin ñaꞌá: ―¿Án xáni si̱ni̱ ndó ta̱kuíꞌná kúu i̱? ¿Nda̱chun va̱xi ndó no̱o̱ i̱ níꞌi ndó espada xíꞌin yito̱n ña tiin ndó yi̱ꞌi̱? ");
INSERT INTO mim_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ta yi̱ꞌi̱, ndiꞌi saá ki̱vi̱ ni̱xi̱yo i̱ sánáꞌa i̱ ni̱vi veꞌe ño̱ꞌo káꞌno, ta ni̱‑tiin ndó yi̱ꞌi̱. Ta vitin ni̱to̱nda̱a ki̱vi̱ Ndios taxi ra ña kasa ndivi ndó chiño ña kóni mi̱i ndó, ta ki̱vi̱ vitin kúu ña ndeé ka̱ xáꞌnda chiño ñandiva̱ꞌa no̱o̱ ñoyívi yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ta saá ti̱in na ta̱Jesús, ta kua̱ꞌa̱n ra xíꞌin na, ni̱xaa̱ na veꞌe ta̱káꞌno no̱o̱ nasu̱tu̱. Ta ta̱Pedro ñii xíká ndíko̱n ra kua̱ꞌa̱n ra sa̱ta̱ ta̱Jesús a̱nda̱ ni̱xaa̱ ra veꞌe yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ta xa̱ꞌmi na ñoꞌo̱ ke̱ꞌe veꞌe ta̱káꞌno no̱o̱ nasu̱tu̱, ta na̱kutáꞌan sava ni̱vi xi̱ndo̱o na yatin no̱o̱ xíxi̱ ñoꞌo̱. Ta ta̱Pedro xi̱koo ra xíꞌin nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ta ñii ñaꞌa̱ ñá kísa chiño no̱o̱ naveꞌe yóꞌo, xi̱ni ñá ta̱Pedro yóo ra yatin no̱o̱ xíxi̱ ñoꞌo̱, ta xi̱to káxín ñá no̱o̱ ra, ta ni̱ka̱ꞌa̱n ñá: ―Ta̱yóꞌo kúu ñii ta̱ ni̱xika xíꞌin ta̱Jesús ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ta nda̱kuii̱n ta̱Pedro, ni̱ka̱ꞌa̱n ra: ―Nana, o̱n vása xíni̱ i̱ ta̱ káꞌa̱n ún xa̱ꞌa̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ta ni̱yaꞌa ñii káni̱ loꞌo, ta saá ñii ta̱a xi̱ni ra ta̱Pedro, ta ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Saá tuku yóꞌó kúu ún ñii ta̱táꞌan ta̱Jesús ―káchí ra. Ta nda̱kuii̱n ta̱Pedro, ni̱ka̱ꞌa̱n ra: ―Tata, o̱n si̱ví yi̱ꞌi̱ kúu ta̱ ni̱xika xíꞌin ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ta saá ni̱yaꞌa inka̱ hora, ta inka̱ ta̱a ni̱ka̱ꞌa̱n ra: ―Ndixa ta̱yóꞌo kúu ñii ta̱ ni̱xika xíꞌin ta̱Jesús, chi ta̱ñoo estado Galilea kúu ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ta nda̱kuii̱n ta̱Pedro, ni̱ka̱ꞌa̱n ra: ―O̱n vása kúnda̱a̱ ini i̱ yukía̱ káꞌa̱n ún xíꞌin i̱. Ta̱nda̱ ta̱ꞌán ka̱ ndiꞌi ka̱ꞌa̱n ta̱Pedro, ta ka̱na ñii nduxú chée. ");
INSERT INTO mim_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ta saá ndi̱kó koo ta̱Jesús xi̱to káxín ra no̱o̱ ta̱Pedro. Ta na̱káꞌán ta̱Pedro to̱ꞌon ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: “Ta̱ꞌán ka̱ kana ñii nduxú chée ta xa u̱ni̱ yichi̱ ni̱ka̱ꞌa̱n ún xíꞌin ni̱vi ndí o̱n vása xíni̱ ún yi̱ꞌi̱.” ");
INSERT INTO mim_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ta ke̱e ta̱Pedro ke̱ꞌe, ta kúchuchú ní ini ra, ta ndeé ní xáku ra xíꞌin ndinoꞌo ini ra. ");
INSERT INTO mim_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ta saá napolicía na ndáa ta̱Jesús, ki̱xáꞌá na xáku̱ ndaa na ra, ta káni ní na ra. ");
INSERT INTO mim_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ta na̱kasi na no̱o̱ ra ta káni na ra xíꞌin yi̱kí ndaꞌa̱ na, ta káchí na saá: ―Tá ta̱profeta kúu ún, ta ka̱ꞌa̱n ún xíꞌin ndi̱, ¿yukú ndi̱ ka̱ni yóꞌó? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ta xíꞌin kua̱ꞌa̱ ní to̱ꞌon kini kándiva̱ꞌa na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ta saá ni̱ti̱vi inka̱ ki̱vi̱, ta na̱kutáꞌan ndiꞌi naxi̱kua̱ꞌa̱ no̱o̱ najudío, xíꞌin nanáꞌno no̱o̱ nasu̱tu̱, xíꞌin na sánáꞌa nda̱yí Ndios, na̱kutáꞌan ndiꞌi na ndóo na veꞌe chiño. Ta kua̱ꞌa̱n ta̱Jesús xíꞌin napolicía, ta ni̱xaa̱ na no̱o̱ nachiño na kúu naJunta Suprema. Ta nayóꞌo ni̱ka̱ꞌa̱n na xíꞌin ta̱Jesús: ");
INSERT INTO mim_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Ka̱ꞌa̱n ún xíꞌin ndi̱, ¿án Cristo ta̱ ti̱ꞌví Ndios kúu ún? Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Nda̱ ma̱ni̱ ka̱ꞌa̱n i̱ xíꞌin ndó yi̱ꞌi̱ kúu ra, chi o̱n vása kandixa ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ta nda̱ ma̱ni̱ nda̱ka̱ to̱ꞌon i̱ ndóꞌó, chi o̱n ndakuii̱n ndó yuꞌu̱ i̱, ni o̱n kuaꞌa ndó saña ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ta ndiꞌi saá ki̱vi̱ ña va̱xi, yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, koo i̱ no̱o̱ táyi̱ tón yóo sii̱n kuaꞌá Ndios, ta̱a ta̱ kómí ndiꞌi ndee̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ta saá ni̱nda̱ka̱ to̱ꞌon na ra: ―¿Án kóni kachí ún ndí Sa̱ꞌya Ndios kúu yóꞌó? ―káchí na. Ta nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra: ―Ndixa káchí mi̱i ndó, yi̱ꞌi̱ kúu Sa̱ꞌya Ndios ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ta saá ni̱ka̱ꞌa̱n na xíꞌin natáꞌan na: ―O̱n vása xíni̱ ñóꞌó yó inka̱ ni̱vi taxi na kua̱chi xa̱ꞌa̱ ta̱yóꞌo, chi mi̱i yó xi̱ni̱ so̱ꞌo yó káchí ra kúu ra Sa̱ꞌya Ndios, ta xíꞌin to̱ꞌon yóꞌo kándiva̱ꞌa ra xíꞌin Ndios ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ta saá na̱kuita ndiꞌi na, ta kua̱ꞌa̱n ta̱Jesús xíꞌin ndiꞌi na, ta̱nda̱ ni̱xaa̱ na no̱o̱ ta̱gobernador Pilato. ");
INSERT INTO mim_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ta ki̱xáꞌá na táxi na kua̱chi xa̱ꞌa̱ ta̱Jesús no̱o̱ ra, ni̱ka̱ꞌa̱n na, káchí na saá: ―Xi̱ni ndi̱ ta̱yóꞌo sánáꞌa ra nañoo yó ña sandakoo na yichi̱ va̱ꞌa. Káꞌa̱n ra xíꞌin na ña o̱n váꞌa taxi na kota ndaꞌa̱ ta̱rey César. Ta káꞌa̱n ra mi̱i ra kúu Cristo, ña kóni kachí mi̱i ra kúu ñii ta̱rey ―káchí na xíꞌin ta̱Pilato. ");
INSERT INTO mim_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ta ta̱Pilato ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús, káchí ra xíꞌin ra: ―¿Án ndixa yóꞌó kúu ún Rey no̱o̱ najudío? ―káchí ra. Ta nda̱kuii̱n ta̱Jesús: ―To̱ꞌon mi̱i ún káchí yi̱ꞌi̱ kúu ta̱rey. ");
INSERT INTO mim_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ta saá ni̱ka̱ꞌa̱n ta̱Pilato xíꞌin nanáꞌno no̱o̱ nasu̱tu̱, ta ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi, káchí ra: ―Nda̱ ñii kua̱chi ta̱yóꞌo o̱n vása ní‑naníꞌi i̱, o̱n ko̱ó xa̱ꞌa̱ ña kivi̱ ra ―káchí ta̱Pilato. ");
INSERT INTO mim_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ta tuku tuku ndeé ka̱ ni̱ka̱ꞌa̱n na xíꞌin ta̱Pilato saá: ―Xíꞌin to̱ꞌon ña sánáꞌa ta̱yóꞌo sásaa̱ ra ni̱vi ndiꞌi saá ñoo estado Judea ña kani táꞌan na xíꞌin nagobierno. Ki̱xáꞌá ra ñoo estado Galilea sásaa̱ ra ni̱vi, ta̱nda̱ ñoo Jerusalén yóꞌo sásaa̱ ra ni̱vi xíꞌin to̱ꞌon ña o̱n váꞌa káꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tá xi̱ni̱ so̱ꞌo ta̱Pilato ñayóꞌo, ta ni̱nda̱ka̱ to̱ꞌon ra na, ni̱ka̱ꞌa̱n ra saá: ―¿Án ta̱ñoo estado Galilea kúu ta̱yóꞌo? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tá ku̱nda̱a̱ ini ta̱Pilato ndí ta̱Jesús kúu ñii ta̱a ta̱ñoo estado Galilea, ta ni̱ka̱ꞌa̱n ra: ―Ta ta̱rey Herodes kúu ta̱ ndíso chiño kasa nani kua̱chi yóꞌo ―káchí ta̱Pilato. Ta saá ti̱ꞌví ta̱Pilato ta̱Jesús kua̱ꞌa̱n ra no̱o̱ ta̱Herodes, chi ta̱Herodes yóo ra ñoo Jerusalén ki̱vi̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ta ta̱Herodes kúsii̱ ní ini ra ña xíni ra ta̱Jesús, chi xa naꞌá ní kóni ní ra koni ra ta̱Jesús. Saá chi xa xi̱ni̱ so̱ꞌo ta̱Herodes kua̱ꞌa̱ ní to̱ꞌon ña káꞌa̱n ni̱vi xa̱ꞌa̱ ta̱Jesús, ta kóni ra ta̱Jesús keꞌé ra ñii milagro ñava̱ꞌa no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ta kua̱ꞌa̱ ní yichi̱ ta̱Herodes ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús, ta nda̱ ñii to̱ꞌon ni̱‑xiin ra ndakuii̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ta nanáꞌno no̱o̱ nasu̱tu̱ xíꞌin na sánáꞌa nda̱yí Ndios, ta ndeé ní ka̱ káꞌa̱n na, chíkaa̱ na kua̱chi sa̱ta̱ ta̱Jesús no̱o̱ ta̱Herodes. ");
INSERT INTO mim_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ta saá ta̱Herodes xíꞌin natropa ra ki̱xáꞌá na kéꞌé na ña o̱n váꞌa xa̱ꞌa̱ ña sakukaꞌan na no̱o̱ ta̱Jesús, ta ku̱siki na ra. Ta níꞌi na ñii tiko̱to̱ livi, nda̱tán yóo tiko̱to̱ ndíxin ta̱rey, ta chi̱nóo na ña sa̱ta̱ ta̱Jesús xa̱ꞌa̱ ña kuaku̱ ndaa na ra. Ta saá tá ndi̱ꞌi ku̱siki na ra, ta ta̱Herodes sa̱ndikó ra ta̱Jesús kua̱ꞌa̱n tuku ra no̱o̱ ta̱Pilato. ");
INSERT INTO mim_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ta ki̱vi̱ yóꞌo ta̱Herodes xíꞌin ta̱Pilato ki̱xáꞌá ra ndúu migo táꞌan ra, chi ki̱vi̱ xi̱na̱ꞌá ta̱nda̱ ki̱vi̱ yóꞌo ta̱Herodes xíꞌin ta̱Pilato ni̱‑xiin ra koni táꞌan ra. ");
INSERT INTO mim_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ta ta̱Pilato ka̱na ra ndiꞌi nanáꞌno no̱o̱ nasu̱tu̱ xíꞌin inka̱ nanáꞌno no̱o̱ naIsrael xíꞌin ndiꞌi inka̱ ni̱vi, ");
INSERT INTO mim_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ta ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―Ndóꞌó kúu ni̱vi na ta̱xi kua̱chi xa̱ꞌa̱ ta̱Jesús no̱o̱ i̱. Ni̱ka̱ꞌa̱n ndó xíꞌin i̱ xa̱ꞌa̱ ra ña xíka ra chúꞌu ra ni̱vi ña kani táꞌan na xíꞌin nagobierno, káchí ndó. Ta xi̱to ndoso va̱ꞌa i̱ ra no̱o̱ ndiꞌi ndó, ta o̱n vása ní‑naníꞌi i̱ nda̱ ñii kua̱chi ña chi̱kaa̱ ndó sa̱ta̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ta ni ta̱Herodes ni̱‑naníꞌi ra kua̱chi ta̱yóꞌo, ña̱kán sa̱ndikó tuku ñaꞌá ra va̱xi ra no̱o̱ i̱. O̱n vása ní‑naníꞌi i̱ kua̱chi ndeé sa̱ta̱ ta̱yóꞌo, ta saá o̱n vása xíni̱ ñóꞌó kivi̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ta va̱ꞌa kuiti natropa kani na ra xíꞌin kuártá, ta saña i̱ ra ko̱ꞌo̱n ndíka̱ ra ―káchí ta̱Pilato xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Saá chi ñii ñii viko̱ Pascua ta̱gobernador xíni̱ ñóꞌó saña ra ñii ta̱a ta̱ nákaa̱ ini veꞌe ka̱a, ko̱ꞌo̱n ndíka̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ta nda̱ ñii ni̱vi ni̱‑xiin na saña ra ta̱Jesús, ta ñii yuꞌú kúu ndiꞌi ni̱vi yóꞌo, káchí na saá: ―¡Ná kivi̱ ta̱yóꞌo! ¡Va̱ꞌa saña ún ta̱Barrabás ko̱ꞌo̱n ndíka̱ ra! ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ta̱Barrabás yóꞌo nákaa̱ ra ini veꞌe ka̱a, chi ki̱sa toon ra ta ka̱ni táꞌan ra xíꞌin nanáꞌno na xáꞌnda chiño no̱o̱ nañoo ra, ta xa̱ꞌni ra ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ta ta̱Pilato kóni ra saña ra ta̱Jesús, ta tuku ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi ndí saña ra ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ta ndeé ní ka̱ ni̱ka̱ꞌa̱n na: ―¡Ná kivi̱ ta̱Jesús! ¡Katakaa̱ ndaa ún ra ndaꞌa̱ tón cruz! ¡Katakaa̱ ndaa ún ra ndaꞌa̱ tón cruz! ");
INSERT INTO mim_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ta yichi̱ u̱ni̱ ni̱ka̱ꞌa̱n ta̱Pilato xíꞌin na: ―¿Yu kúu kua̱chi ni̱ki̱ꞌvi ra? O̱n vása náníꞌi i̱ nda̱ ñii kua̱chi ndeé sa̱ta̱ ra, o̱n vása xíni̱ ñóꞌó kivi̱ ra. Va̱ꞌa ka̱ saxo̱ꞌvi̱ ní i̱ ra, ta saña i̱ ra ko̱ꞌo̱n ndíka̱ ra ―káchí ta̱Pilato xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ta ni̱‑xiin ni̱vi yóꞌo, ta tuku ndeé ní káꞌa̱n na: ―¡Ná kivi̱ ta̱Jesús! ¡Katakaa̱ ndaa ún ra ndaꞌa̱ tón cruz! ―káchí na. Nanáꞌno no̱o̱ nasu̱tu̱ xíꞌin inka̱ ni̱vi, ñii yuꞌú ndiꞌi na, ni̱ka̱ꞌa̱n na xíni̱ ñóꞌó kivi̱ ta̱Jesús. Ta saá ku̱chiño na to̱nda̱a to̱ꞌon na xa̱ꞌa̱ ña kóni na. ");
INSERT INTO mim_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ta ta̱Pilato xa̱ꞌnda chiño ra ña kasa ndivi na xíꞌin ta̱Jesús ña kóni ni̱vi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ta sa̱ña ra ta̱a ta̱ na̱ka̱xin na ko̱ꞌo̱n ndíka̱, vará xi̱nakaa̱ ra ini veꞌe ka̱a xa̱ꞌa̱ ña ka̱ni táꞌan ra xíꞌin nagobierno, ta xa̱ꞌni ra ni̱vi. Ta saá ta̱Pilato na̱taxi ra ta̱Jesús ndaꞌa̱ na ña keꞌé na xíꞌin ra nda̱tán yóo ña kóni mi̱i na. ");
INSERT INTO mim_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ta saá ke̱e natropa, ta kua̱ꞌa̱n ta̱Jesús xíꞌin na, ta na̱kutáꞌan na xíꞌin ñii ta̱a ta̱ ki̱xi ñoo Cirene, na̱ní ra Simón, ta nde̱e ra yuku̱ kua̱noꞌo̱ ra yichi̱ ñoo Jerusalén, ta natropa ki̱sa ndu̱xa̱ na xíꞌin ta̱yóꞌo ña kuiso ra tón cruz ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ta kua̱ꞌa̱ ní ni̱vi ndíko̱n na kua̱ꞌa̱n na sa̱ta̱ ta̱Jesús. Sava náñaꞌa̱ ná ndíko̱n sa̱ta̱ ra, ndeé ní xáku ná, nda̱ ndáꞌyi ná, chi kúchuchú ní ini ná xa̱ꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ta ndi̱kó koo ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ná: ―Ndóꞌó, náñaꞌa̱ ñoo Jerusalén, o̱n kuaku ndó xa̱ꞌa̱ i̱, ta xa̱ꞌa̱ mi̱i ndó, xíꞌin xa̱ꞌa̱ sa̱ꞌya ndó kuaku ndó. ");
INSERT INTO mim_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chi va̱xi ki̱vi̱ ña xo̱ꞌvi̱ ní nañoo Jerusalén, ta ka̱ꞌa̱n ni̱vi saá: “Nákaa̱ ñasi̱i̱ níma̱ náñaꞌa̱ nóma, ná o̱n ko̱ó sa̱ꞌya, ta nákaa̱ ñasi̱i̱ níma̱ náñaꞌa̱ ná o̱n ko̱ó sa̱ꞌya válí na chíchín”, kachí na. ");
INSERT INTO mim_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tá to̱nda̱a ki̱vi̱ kixáꞌá xo̱ꞌvi̱ ní ni̱vi, ta ka̱ꞌa̱n na saá: “Va̱ꞌa ka̱ ná nakava yuku̱ sa̱ta̱ yó, ta va̱ꞌa ka̱ ná sandúxu̱n xi̱ki̱ mi̱i yó ña o̱n xo̱ꞌvi̱ ka̱ yó”, kachí ni̱vi. ");
INSERT INTO mim_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tá taxi Ndios keꞌé ni̱vi ña o̱n váꞌa yóꞌo xíꞌin yi̱ꞌi̱, vará ta̱a ta̱ o̱n vása kómí kua̱chi kúu i̱, ta ñii ki̱vi̱ ña va̱xi ndeé ka̱ xo̱ꞌvi̱ ni̱vi na kómí kua̱chi ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ta ni̱xi̱yo o̱vi̱ ta̱a ta̱ kómí kua̱chi, ta kua̱ꞌa̱n ra xíꞌin natropa xa̱ꞌa̱ ña kivi̱ ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ta ni̱xaa̱ na ñii xiiña na̱ní ña Leke Si̱ni̱ Ndi̱í, ta yóꞌo ka̱takaa̱ ndaa na ta̱Jesús ndaꞌa̱ tón cruz. Ta ka̱takaa̱ ndaa na o̱vi̱ ta̱a ta̱ kómí kua̱chi, ñii ta̱yóꞌo tákaa̱ ndaa ndaꞌa̱ tón cruz tón ñíndichi sii̱n kuaꞌá ta̱Jesús, ta inka̱ ra tákaa̱ ndaa ndaꞌa̱ tón cruz tón ñíndichi sii̱n yitin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin Ndios: ―Tata Yivá i̱, kasa káꞌno ini ún xa̱ꞌa̱ ni̱vi na xáꞌni yi̱ꞌi̱, chi o̱n vása kúnda̱a̱ ini nayóꞌo yukía̱ kéꞌé na ―káchí ra. Ta natropa na̱taꞌví na tiko̱to̱ ra, chi̱kaa̱ na ndati̱ ña koto na yukú ñii ñii nayóꞌo nakiꞌin ñii ñii loꞌo tiko̱to̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ta xíto ni̱vi ña ndóꞌo ta̱Jesús, ta nanáꞌno no̱o̱ naIsrael xáku̱ ndaa na ra, ta káꞌa̱n na: ―Ta̱yóꞌo sa̱ka̱ku ra inka̱ ni̱vi. Ta va̱ꞌa ka̱ ná saka̱ku xíꞌin mi̱i ra vitin, tá ndixa kúu ra Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku mi̱i yó ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ta natropa ni̱xaa̱ yatin na xa̱ꞌa̱ tón cruz no̱o̱ tákaa̱ ta̱Jesús, ta xáku̱ ndaa na ra. Chi̱kaa̱ na nduta̱ vino yiyá yuꞌu̱ ra ña koꞌo ra, ");
INSERT INTO mim_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tá ndixa ta̱Rey no̱o̱ najudío kúu yóꞌó, ta va̱ꞌa saka̱ku xíꞌin mi̱i ún vitin ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ta chi̱nóo kútu̱ na ñii tón vi̱ti̱ loꞌo si̱ni̱ tón cruz. Ta no̱o̱ tón vi̱ti̱ yóꞌo na̱ka̱ꞌyi̱ u̱ni̱ no̱o̱ to̱ꞌon ña kúu to̱ꞌon griego, latín, xíꞌin hebreo, ña káꞌa̱n xa̱ꞌa̱ kua̱chi ra, ta káchí ña saá: “Ta̱yóꞌo kúu ta̱Rey no̱o̱ najudío.” ");
INSERT INTO mim_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ta ñii ta̱ kómí kua̱chi, tákaa̱ ndaa ra ndaꞌa̱ tón cruz sii̱n ta̱Jesús, ki̱xáꞌá ra kándiva̱ꞌa ra xíꞌin ra, ni̱ka̱ꞌa̱n ra saá: ―Tá Cristo, ta̱a ta̱ ti̱ꞌví Ndios va̱xi saka̱ku mi̱i yó kúu ún, ta vitin saka̱ku xíꞌin mi̱i ún ta saka̱ku ún ndi̱ꞌi̱ ―káchí ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ta inka̱ ta̱ kómí kua̱chi, ta̱ tákaa̱ ndaa ndaꞌa̱ tón cruz inka̱ sii̱n ta̱Jesús, nda̱kuii̱n ra ni̱ka̱ꞌa̱n ra xíꞌin ta̱yóꞌo: ―¡O̱n váꞌa káchí ún saá! ¿Án o̱n vása yíꞌví ún no̱o̱ Ndios?, chi vitin kivi̱ yó. ");
INSERT INTO mim_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ta yóꞌó xíꞌin yi̱ꞌi̱, xo̱ꞌvi̱ yó xíꞌin ñanda̱a̱, chi ndixa ni̱ki̱ꞌvi yó kua̱chi. Ta ta̱yóꞌo, o̱n ko̱ó kua̱chi ndíso ra ―káchí ra xíꞌin inka̱ ta̱táꞌan ra. ");
INSERT INTO mim_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ta saá ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Tata, tá to̱nda̱a ki̱vi̱ kaꞌnda chiño ún no̱o̱ kixáꞌá kuu ún rey, ta nakáꞌán ún xa̱ꞌa̱ i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Ki̱vi̱ vitin koo ún xíꞌin i̱ no̱o̱ yóo Ndios, no̱o̱ yóo ndiꞌi ñava̱ꞌa ña livi ní ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ta ni̱to̱nda̱a ka̱a u̱xu̱ o̱vi̱ ma̱ꞌñó ndiví, ta ki̱xáꞌá kúnaa ndiꞌi ñoyívi a̱nda̱ ka̱a u̱ni̱ xikuaa. ");
INSERT INTO mim_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ta ku̱naa ndiꞌi, ta o̱n vása yéꞌe ka̱ ño̱ꞌo. Ta ni̱nda̱ta̱ ma̱ꞌñó tiko̱to̱ tákaa̱ Cuarto Yi̱i̱ veꞌe ño̱ꞌo káꞌno. ");
INSERT INTO mim_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ta saá ta̱Jesús xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra xíꞌin Ndios: ―Tata Yivá i̱, ndaꞌa̱ mi̱i ún táxi i̱ níma̱ i̱. Ta ndi̱ꞌi ni̱ka̱ꞌa̱n ra saá, ta ni̱xiꞌi̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ta yóo ñii ta̱a ta̱ ndíso chiño xíꞌin ñii ciento natropa, ta xi̱ni ra ndiꞌi ña yi̱yo ní ni̱yaꞌa, ta ki̱sa káꞌno ra Ndios, ni̱ka̱ꞌa̱n ra saá: ―Ndixa ta̱yóꞌo xi̱kuu ñii ta̱va̱ꞌa, ta̱ o̱n vása ndíso kua̱chi ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ta kua̱ꞌa̱ ní ni̱vi xi̱kuita yatin na no̱o̱ yóo tón cruz, ta xi̱to na yukía̱ ni̱ndoꞌo ta̱Jesús. Ta saá ndi̱kó na kua̱noꞌo̱ na, ta káni na kándíká mi̱i na kua̱ꞌa̱n na, chi kúchuchú ní ini na. ");
INSERT INTO mim_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ta nda̱ xíká yíta kua̱ꞌa̱ ní ni̱vi na xíni̱ táꞌan va̱ꞌa xíꞌin ta̱Jesús, ta saá tuku yíta náñaꞌa̱ ná xi̱ndiko̱n sa̱ta̱ ta̱Jesús, nda̱ ki̱vi̱ ke̱e ra estado Galilea ta̱nda̱ ki̱xaa̱ ra ñoo Jerusalén, ta vitin xíto ná yukía̱ ndóꞌo ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ni̱xi̱yo ñii ta̱va̱ꞌa ta̱to̱ꞌó, na̱ní ra José, ta kúu ra ta̱chiño táꞌan naJunta Suprema. Kúu ra ta̱ñoo Arimatea, ña nákaa̱ estado Judea. ");
INSERT INTO mim_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ta ndáti ra ki̱vi̱ kixáꞌá kaꞌnda chiño Ndios ñoyívi yóꞌo. Vará ñii kúu ra xíꞌin natáꞌan ra naJunta Suprema na ndu̱kú kivi̱ ta̱Jesús, ta o̱n vása ní‑xiyo yuꞌú ra xíꞌin nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ta ta̱José yóꞌo ni̱xa̱ꞌa̱n ra no̱o̱ ta̱Pilato, ta ndu̱kú ra yi̱kí ko̱ñu ta̱Jesús ña sandúxu̱n ra ña. ");
INSERT INTO mim_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ta saá ni̱xaa̱ ra ta sa̱noo ra yi̱kí ko̱ñu ta̱Jesús ndaꞌa̱ tón cruz, ta xíꞌin ñii tiko̱to̱ va̱ꞌa chi̱súku ndaa ra yi̱kí ko̱ñu ta̱Jesús. Ta ni̱xa̱ꞌa̱n ra ta chi̱kaa̱ va̱ꞌa ra ña ini kavua̱ ña xa̱á, no̱o̱ nda̱ ñii ni̱vi o̱n ta̱ꞌán ndu̱xu̱n. ");
INSERT INTO mim_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ta ki̱vi̱ viernes kúu ña, ta ki̱vi̱ yóꞌo kísa ndivi najudío ndiꞌi ña xíni̱ ñóꞌó na xa̱ꞌa̱ ki̱vi̱ ña nákindée na. Ta xikuaa ta xa kua̱ꞌa̱n kunaa, xa yatin ní to̱nda̱a hora ña kixáꞌá ki̱vi̱ ña nakindée na. ");
INSERT INTO mim_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ta náñaꞌa̱, ná xi̱ndiko̱n sa̱ta̱ ta̱Jesús nda̱ estado Galilea ta̱nda̱ ñoo yóꞌo, kua̱ꞌa̱n ná sa̱ta̱ ta̱José, ta xi̱ni ná kavua̱ no̱o̱ sa̱ndúxu̱n na ta̱Jesús, ta xi̱to ná míkía̱ chi̱nóo na yi̱kí ko̱ñu ra. ");
INSERT INTO mim_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ta saá kua̱noꞌo̱ ná ta ki̱sa ndivi ná ta̱ta̱n ña xáꞌan támi ña chikaa̱ ná yi̱kí ko̱ñu ta̱Jesús. Ta na̱kindée ná ki̱vi̱ yi̱i̱, chi saá ki̱sa ndivi ná ña káꞌa̱n nda̱yí Ndios ña ni̱taa ta̱Moisés. ");
INSERT INTO mim_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ta ni̱ti̱vi inka̱ ki̱vi̱; ñayóꞌo kúu ki̱vi̱ no̱ó semana ña kúu domingo, ta náñaꞌa̱ yóꞌo níꞌi ná ta̱ta̱n ña xáꞌan támi ki̱sa va̱ꞌa ná, ta kua̱ꞌa̱n ná no̱o̱ ni̱ndu̱xu̱n ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ta ni̱xaa̱ yatin ná no̱o̱ ni̱ndu̱xu̱n ra, ta na̱koto ná o̱n vása ndási̱ ka̱ yéꞌé kavua̱ xíꞌin yu̱u̱ káꞌno. ");
INSERT INTO mim_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ta ni̱ki̱ꞌvi ná ini kavua̱, ta o̱n ko̱ó ka̱ yi̱kí ko̱ñu ta̱Jesús ní‑xini ná. ");
INSERT INTO mim_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ta ndíꞌi ní ini ná, ta xíka si̱ni̱ ná yukía̱ koo keꞌé ná. Ta xa̱ndi̱ko̱n xi̱ni ná o̱vi̱ ta̱a yíta yatin ra no̱o̱ ná, ndíxin ra tiko̱to̱ yaa ña náyeꞌe táxa. ");
INSERT INTO mim_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ta ni̱yi̱ꞌví ní náñaꞌa̱ yóꞌo, ta xi̱kuxítí ná nda̱ ni̱to̱nda̱a ta̱ꞌya̱ ná nda̱ no̱o̱ ñoꞌo̱. Ta ni̱ka̱ꞌa̱n ta̱a ta̱ ndíxin tiko̱to̱ yaa ña náyeꞌe táxa xíꞌin ná: ―¿Nda̱chun nándukú ndó ñii ta̱ táku̱ no̱o̱ sándúxu̱n na na ni̱xiꞌi̱? ");
INSERT INTO mim_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","O̱n ko̱ó ka̱ ra yóꞌo. ¡Xa na̱taku̱ ra! Nakáꞌán ini ndó ña ni̱ka̱ꞌa̱n ra xíꞌin ndó ki̱vi̱ ni̱xi̱yo ra estado Galilea, ");
INSERT INTO mim_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","chi ni̱ka̱ꞌa̱n ra saá: “Xíni̱ ñóꞌó tiin na yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ta nataxi na yi̱ꞌi̱ ndaꞌa̱ ni̱vi na o̱n váꞌa, ta katakaa̱ ndaa na yi̱ꞌi̱ ndaꞌa̱ tón cruz, ta kivi̱ i̱. Tá to̱nda̱a ki̱vi̱ u̱ni̱, ta nataku̱ i̱”, káchí ta̱Jesús xíꞌin ndó ―káchí naángel xíꞌin náñaꞌa̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Saá na̱káꞌán ini ná to̱ꞌon ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ná, ");
INSERT INTO mim_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ta ndi̱kó ná kua̱ꞌa̱n ná, ta nda̱to̱ꞌon ná xíꞌin mi̱i na u̱xu̱ ñii ni̱xika xíꞌin ta̱Jesús, ta nda̱to̱ꞌon ná xíꞌin inka̱ na xi̱ndiko̱n sa̱ta̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Náñaꞌa̱ yóꞌo na̱ní ná: María Magdalena, Juana, xíꞌin inka̱ ñáMaría, ñá kúu siꞌí ta̱Jacobo. Ta ni̱xi̱yo inka̱ ka̱ náñaꞌa̱ xíꞌin ná. ");
INSERT INTO mim_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ta ni̱vi na xi̱ni̱ so̱ꞌo ña káꞌa̱n náñaꞌa̱ yóꞌo, ni o̱n vása kándixa na ña káꞌa̱n ná, chi nda̱tán yóo to̱ꞌon ña o̱n vása ndáya̱ꞌví, saá yóo ña no̱o̱ ni̱vi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ta ta̱Pedro xa̱ndi̱ko̱n na̱kundichi ra, ta xi̱no ra kua̱ꞌa̱n ra nda̱ ni̱xaa̱ ra no̱o̱ ni̱ndu̱xu̱n ta̱Jesús. Ta xi̱kundee ra, xi̱to ra no̱o̱ xi̱nakaa̱ yi̱kí ko̱ñu ta̱Jesús, ta o̱n ko̱ó ka̱ ña ní‑xini ra. Nda̱ tiko̱to̱ ra kuiti ndóo no̱o̱ xi̱ndúꞌu̱ yi̱kí ko̱ñu ra. Saá na̱kaꞌnda ini ra, kua̱noꞌo̱ ra, chi o̱n vása kúnda̱a̱ ini ra yukía̱ ndo̱ꞌo yi̱kí ko̱ñu ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ta mi̱i ki̱vi̱ yóꞌo o̱vi̱ ni̱vi na xi̱ndiko̱n sa̱ta̱ ta̱Jesús, ke̱e na kua̱ꞌa̱n na ñoo Emaús. Nda̱ ñoo Jerusalén ta̱nda̱ ñoo Emaús kómí ña u̱xu̱ ñii kilómetro. ");
INSERT INTO mim_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ta ndio̱vi̱ na saá káꞌa̱n táꞌan na xa̱ꞌa̱ ña ndo̱ꞌo ta̱Jesús ñoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tá ta̱ꞌán ka̱ ndiꞌi ka̱ꞌa̱n táꞌan na kua̱ꞌa̱n na yichi̱, ta ki̱xaa̱ ta̱Jesús na̱kutáꞌan ra xíꞌin na, ta ki̱xáꞌá ra kua̱ꞌa̱n ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ta ni̱‑kuchiño na nakoni na ta̱Jesús, chi Ndios ke̱ꞌé ra ña o̱n nakoni na ra. ");
INSERT INTO mim_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ta ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ñaꞌá ra: ―¿Yu kúu ña ndáto̱ꞌon ndó xa̱ꞌa̱, kua̱ꞌa̱n ndó yichi̱ yóꞌo? Ta, ¿nda̱chun kúchuchú ní ini ndó? ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ta ñii nayóꞌo na̱ní Cleofas, nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Ndiꞌi ni̱vi na ndóo ñoo Jerusalén xíni̱ na yu kúu ña ni̱xi̱yo ki̱vi̱ sa̱kán ni̱yaꞌa. ¿Án yóꞌó kúu si̱ín la̱á ta̱a, ta̱ o̱n vása ní‑xini̱ ña ni̱xi̱yo? ―káchí ta̱Cleofas xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ta nda̱kuii̱n ta̱Jesús: ―¿Yo xa̱ꞌa̱ káꞌa̱n ndó? ¿Yukía̱ ni̱xi̱yo? ―káchí ra. Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na: ―Káꞌa̱n ndi̱ xa̱ꞌa̱ ta̱Jesús ta̱ñoo Nazaret. Ta̱yóꞌo xi̱kuu ra ñii ta̱profeta, ta ndeé ní ni̱xi̱yo ñava̱ꞌa ke̱ꞌé ra, ta to̱ꞌon ña ni̱ka̱ꞌa̱n ra xi̱komí ña ndee̱ no̱o̱ ni̱vi ta no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ta nanáꞌno no̱o̱ nasu̱tu̱ xíꞌin inka̱ na xáꞌnda chiño no̱o̱ yó, ti̱in na ra, ta ta̱xi na kua̱chi xa̱ꞌa̱ ra no̱o̱ nagobierno, ta ña̱kán xa̱ꞌni na ra ndaꞌa̱ tón cruz. ");
INSERT INTO mim_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ta ndi̱ꞌi̱, xi̱ndati ndi̱ ta̱Jesús yóꞌo kúu ta̱a ta̱ va̱xi saka̱ku nañoo mi̱i yó naIsrael. Ta ki̱vi̱ vitin ni̱xi̱no̱ u̱ni̱ ki̱vi̱ ña ni̱xiꞌi̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ta saá ni, sava náñaꞌa̱ nátáꞌan ndi̱ nda̱to̱ꞌon ná xíꞌin ndi̱ to̱ꞌon ña ta̱xi na̱kaꞌnda ní ini ndi̱ vitin, chi xita̱a̱n ní ki̱vi̱ vitin ni̱xa̱ꞌa̱n náyóꞌo no̱o̱ ni̱ndu̱xu̱n ta̱Jesús, ");
INSERT INTO mim_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ta ni̱‑naníꞌi ka̱ ná yi̱kí ko̱ñu ra. Ta ndi̱kó ná kua̱noꞌo̱ ná, ta ni̱ka̱ꞌa̱n ná xíꞌin ndi̱ꞌi̱, ta xíꞌin inka̱ na xi̱ndiko̱n sa̱ta̱ ta̱Jesús ndí xi̱ni ná naángel na ni̱ka̱ꞌa̱n xíꞌin ná xa na̱taku̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ta sava natáꞌan ndi̱ ni̱xa̱ꞌa̱n na no̱o̱ ni̱ndu̱xu̱n ta̱Jesús. Nda̱tán ni̱ka̱ꞌa̱n náñaꞌa̱ xíꞌin na, ta saá ndixa yóo ña, ta o̱n vása ní‑xini ka̱ na ta̱Jesús ―káchí nayóꞌo xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―¿Án kíꞌví si̱ni̱ ndó? ¡Nda̱chun yo̱ꞌvi̱ ní kandixa ndó ndiꞌi to̱ꞌon ña ni̱taa naprofeta, na ni̱ka̱ꞌa̱n ndoso to̱ꞌon Ndios xi̱na̱ꞌá! ");
INSERT INTO mim_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Án o̱n ndixa naprofeta ka̱chí na ndí Cristo ta̱ tiꞌví Ndios xíni̱ ñóꞌó xo̱ꞌvi̱ ní ra, ta ki̱vi̱ kundivi ñayóꞌo, ta ki̱ꞌvi ra no̱o̱ kaꞌnda chiño ra, ta kasa káꞌno ní na ra? ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ta saá ki̱xáꞌá ta̱Jesús xíꞌin to̱ꞌon Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá, ta sa̱náꞌa ra xa̱ꞌa̱ to̱ꞌon ña ni̱taa ndiꞌi inka̱ naprofeta. Nda̱to̱ꞌon káxín ra xíꞌin na yukía̱ káchí ndiꞌi to̱ꞌon Ndios yóꞌo xa̱ꞌa̱ mi̱i ra. ");
INSERT INTO mim_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ta ni̱xaa̱ na ñoo Emaús, ta ta̱Jesús xi̱to yaꞌa ra ko̱ꞌo̱n ra. ");
INSERT INTO mim_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ta xa̱ku ndáꞌví na no̱o̱ ra, ni̱ka̱ꞌa̱n na xíꞌin ra: ―Kindo̱o ún veꞌe yóꞌo xíꞌin ndi̱, chi xa ni̱kuaa ní kúu ña ―káchí na xíꞌin ta̱Jesús. Ta ni̱ki̱ꞌvi ra veꞌe xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ta ndóo ndiꞌi na no̱o̱ mesa, ta ta̱Jesús ki̱ꞌin ra si̱ta̱ va̱ꞌa, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios: ―Táxaꞌvi ún xa̱ꞌa̱ ñayóꞌo kuxu yó. Ta ta̱ꞌví ra si̱ta̱ va̱ꞌa, ta ta̱xi ra ña ndaꞌa̱ na. ");
INSERT INTO mim_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ta xíꞌin ña ke̱ꞌé ta̱Jesús saá, Ndios ta̱xi ra ña na̱koni na ta̱Jesús kúu ra. Ta xa̱ndi̱ko̱n nda̱ñóꞌó ra no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ta ni̱ka̱ꞌa̱n na xíꞌin táꞌan na: ―¿Án o̱n ndixa nda̱ ka̱ndeta mi̱i níma̱ yó va̱xi yó ki̱vi̱ ni̱ka̱ꞌa̱n ra xíꞌin yó yichi̱, ta nda̱to̱ꞌon káxín ra xíꞌin yó yukía̱ kóni kachí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ta saá xa̱ndi̱ko̱n na̱kuita na, ta ndi̱kó na kua̱ꞌa̱n tuku na ñoo Jerusalén. Ta ki̱xaa̱ na no̱o̱ ndóo u̱xu̱ ñii naapóstol xíꞌin naxíka xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ta nayóꞌo ni̱ka̱ꞌa̱n na xíꞌin na o̱vi̱ ki̱xaa̱ yóꞌo: ―¡Ñanda̱a̱ kía̱ na̱taku̱ ta̱Jesús ta̱Káꞌno no̱o̱ yó! Ta̱Simón Pedro xa xi̱ni ñaꞌá ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ta saá na o̱vi̱ ni̱vi ki̱xaa̱ yóꞌo, nda̱to̱ꞌon na xíꞌin na ndóo ndí na̱kutáꞌan na xíꞌin ta̱Jesús ki̱vi̱ kua̱ꞌa̱n na yichi̱ ñoo Emaús. Ta ni̱ka̱ꞌa̱n na tá mi̱i xíni na táꞌví ta̱Jesús si̱ta̱ va̱ꞌa ña taxi ra ndaꞌa̱ na kuxu na, ta saá na̱koni na ra. ");
INSERT INTO mim_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ta ta̱ꞌán ka̱ ndiꞌi ndato̱ꞌon na, ta ki̱xaa̱ ta̱Jesús xi̱kundichi ra ma̱ꞌñó na, ta káchí ra saá: ―¡Ná koo ñava̱ꞌa ini ndó! ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ta ni̱yi̱ꞌví ní na xi̱ni na ta̱Jesús, chi kuiti káꞌán na ndí níma̱ ra kúu ña. ");
INSERT INTO mim_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―¿Nda̱chun yíꞌví ní ndó? ¿Nda̱chun xíka ini ndó án ndixa yi̱ꞌi̱ kúu ta̱Jesús? ");
INSERT INTO mim_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Koto ndó ndaꞌa̱ i̱ yóꞌo, koto ndó xa̱ꞌa̱ i̱ yóꞌo, ta saá kunda̱a̱ ini ndó yi̱ꞌi̱ kúu ta̱Jesús. To̱nda̱a ndaꞌa̱ ndó yi̱ꞌi̱, ta saá kunda̱a̱ ini ndó, chi níma̱ o̱n ko̱ó ko̱ñu ña, ni leke ña o̱n ko̱ó; ta yi̱ꞌi̱, kúchiño koto ndó leke i̱ xíꞌin ko̱ñu i̱ ―káchí ra xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ta saá sa̱náꞌa ra ndaꞌa̱ ra xíꞌin xa̱ꞌa̱ ra no̱o̱ xi̱ñoꞌo clavo. ");
INSERT INTO mim_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Vará nda̱ kúsii̱ ní ini na, ta o̱n ki̱ví kandixa na ta̱Jesús kúu ra, ta na̱kaꞌnda ní ini na. Ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Án yóo loꞌo ñaxíxi? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ta ta̱xi na ño̱ño̱ tíyóko̱ xíꞌin ñii ñáꞌño tia̱ká tí yatan ndaꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ta ki̱ꞌin ra ña, ta xa̱xi ra ña no̱o̱ ndiꞌi na. ");
INSERT INTO mim_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ta ki̱vi̱ ni̱xika i̱ xíꞌin ndó, ta nda̱to̱ꞌon i̱ xíꞌin ndó ndí xíni̱ ñóꞌó xo̱ꞌvi̱ ní i̱, chi saá kasa ndivi i̱ ndiꞌi to̱ꞌon Ndios ña káꞌa̱n xa̱ꞌa̱ i̱, ña kúu nda̱yí ña ni̱taa ta̱Moisés xíꞌin tutu ña ni̱taa inka̱ naprofeta, xíꞌin tutu na̱ní ña Salmos. Ta ñii ki̱ꞌva nda̱tán káchí to̱ꞌon Ndios yóꞌo xa̱ꞌa̱ i̱, saá ki̱sa ndivi i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Saá vivíi nda̱to̱ꞌon ta̱Jesús xíꞌin na ña kunda̱a̱ va̱ꞌa ini na to̱ꞌon Ndios yóꞌo ña ni̱taa na xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―To̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá káchí ña ndí Cristo xíni̱ ñóꞌó kivi̱ ra, ta nataku̱ ra ki̱vi̱ u̱ni̱. ");
INSERT INTO mim_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Saá na kándixa ra kixáꞌá na ka̱ꞌa̱n ndoso na to̱ꞌon ra no̱o̱ ni̱vi nañoo Jerusalén, ta ka̱ꞌa̱n ndoso na to̱ꞌon ra no̱o̱ ndiꞌi ni̱vi nañoo ñoyívi yóꞌo. Ta xíꞌin nda̱yí mi̱i ra, ndato̱ꞌon na xíꞌin ni̱vi ndí xíni̱ ñóꞌó ndikó ini na ta sandakoo na ña o̱n váꞌa, ta saá Ndios kasa káꞌno ini ra xa̱ꞌa̱ kua̱chi na. ");
INSERT INTO mim_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ta ndóꞌó kúu na xíni̱ va̱ꞌa xa̱ꞌa̱ ndiꞌi ñayóꞌo, ta kúchiño ndó ndakuii̱n ndó xa̱ꞌa̱ ña. ");
INSERT INTO mim_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Va̱xi ki̱vi̱ tiꞌví i̱ ñava̱ꞌa ña ni̱ka̱ꞌa̱n Yivá i̱ Ndios ndixa kixaa̱ ña no̱o̱ ndó. Ta xíni̱ ñóꞌó kundati ndó ñoo Jerusalén nda̱ ki̱vi̱ nakiꞌin ndó ndee̱ ña kixi ñoyívi ni̱no ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ta saá kua̱ꞌa̱n ta̱Jesús xíꞌin na ndíko̱n sa̱ta̱ ra, ta ni̱xaa̱ na yatin no̱o̱ ñoo Betania. Ta ta̱Jesús nda̱níꞌi ra ndaꞌa̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na: ―¡Ná keꞌé Ndios ñava̱ꞌa xíꞌin ndó! ");
INSERT INTO mim_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ta ndi̱ꞌi ni̱ka̱ꞌa̱n ra ñayóꞌo, ta nda̱a ra kua̱noꞌo̱ ra ñoyívi ni̱no. ");
INSERT INTO mim_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ta saá na ndíko̱n ta̱Jesús ki̱sa káꞌno na ra, ta ndi̱kó na kua̱noꞌo̱ na ñoo Jerusalén, ta kúsii̱ ní ini na. ");
INSERT INTO mim_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ta ndiꞌi saá ki̱vi̱ ndóo na veꞌe ño̱ꞌo káꞌno ñoo Jerusalén, kísa káꞌno na Ndios. Saá yóo ña.");
INSERT INTO mim_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nda̱ ta̱ꞌán ka̱ kixáꞌá kuva̱ꞌa ndiꞌi ña yóo ñoyívi, xa yóo To̱ꞌon Ndios. Ta To̱ꞌon Ndios xa yóo ña xíꞌin Ndios nda̱ siꞌna, ta To̱ꞌon yóꞌo kúu mi̱i Ndios. ");
INSERT INTO mim_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","To̱ꞌon Ndios yóꞌo xa yóo ña xíꞌin Ndios nda̱ siꞌna ka̱ no̱o̱ ndiꞌi ña̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Xíꞌin To̱ꞌon yóꞌo Ndios ki̱sa va̱ꞌa ra ndiꞌi ña yóo ñoyívi ni̱no xíꞌin ña yóo ñoyívi yóꞌo. Ta ndiꞌi ña yóo, ku̱va̱ꞌa ña xíꞌin mi̱i To̱ꞌon Ndios. Ta nda̱ ñii ña yóo, o̱n vása ní‑kuva̱ꞌa ña xíꞌin inka̱ ndee̱ án inka̱ to̱ꞌon. ");
INSERT INTO mim_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ta To̱ꞌon Ndios yóꞌo kúu ta̱a ta̱ táku̱ ndinoꞌo, ta ndee̱ ña táxi kutaku̱ ndiꞌi ni̱vi, káku ña no̱o̱ ra. Ta nda̱tán yóo ñoꞌo̱ ña yéꞌe no̱o̱ ni̱vi ña táxi kuchiño koto na, saá yóo ta̱a yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ta ndiꞌi saá ki̱vi̱ nda̱tán yóo ñoꞌo̱ ña yéꞌe no̱o̱ naa ní, saá yóo ra, ta ñanaa ní yóꞌo, nda̱ loꞌo o̱n vása kúchiño ña ndaꞌva ña ñoꞌo̱ yéꞌe yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ni̱xi̱yo ñii ta̱a ta̱ ti̱ꞌví Ndios ña ka̱ꞌa̱n ndoso ra to̱ꞌon Ndios no̱o̱ ni̱vi, ta ta̱yóꞌo xi̱naní ra Juan. ");
INSERT INTO mim_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ta Ndios ti̱ꞌví ra ta̱yóꞌo ña ndakuii̱n ra xa̱ꞌa̱ ta̱a ta̱ yóo nda̱tán yóo ñoꞌo̱ ndinoꞌo ña yéꞌe. Ta ta̱Juan yóꞌo nda̱to̱ꞌon ra xíꞌin ni̱vi xa̱ꞌa̱ ta̱a yóꞌo xa̱ꞌa̱ ña kuchiño kandixa na ra. ");
INSERT INTO mim_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ta ndixa ta̱Juan yóꞌo o̱n si̱ví mi̱i ra xi̱kuu ñoꞌo̱ ndinoꞌo ña yéꞌe, ta ndasaá kuiti ki̱xi ra ndato̱ꞌon ra to̱ꞌon ña nda̱a̱ xa̱ꞌa̱ ta̱a ta̱ kúu ñoꞌo̱ ndinoꞌo. ");
INSERT INTO mim_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ta saá ki̱xaa̱ ki̱vi̱ ka̱ku ta̱Juan, ta loꞌo kuiti ni̱yaꞌa, ta ka̱ku ta̱a ta̱ kúu ñoꞌo̱ ndinoꞌo. Ta ñoꞌo̱ ndinoꞌo yóꞌo yéꞌe no̱o̱ ndiꞌi ni̱vi na táku̱ ñoyívi xa̱ꞌa̱ ña kuchiño koto na yu kúu yichi̱ va̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ta ta̱a ta̱ kúu ñoꞌo̱ ndinoꞌo ki̱xaa̱ ra ñoyívi yóꞌo, ta xi̱taku̱ ra xíꞌin ni̱vi. Vará ndiꞌi ni̱vi xíꞌin ndiꞌi ña yóo ñoyívi ku̱va̱ꞌa ña xíꞌin ndee̱ ra, ta nani̱vi ñoyívi yóꞌo ní‑nakoni na yu kúu ra. ");
INSERT INTO mim_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ta̱yóꞌo ki̱xaa̱ ra no̱o̱ ni̱vi na kúu nañoo mi̱i ra, ta nayóꞌo ni̱‑xiin na nakiꞌin na ra. ");
INSERT INTO mim_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ta saá ni, ni̱xi̱yo sava ni̱vi na na̱kiꞌin va̱ꞌa ñaꞌá, ta ka̱ndixa na ra. Ta ndaꞌa̱ ni̱vi yóꞌo na na̱kiꞌin va̱ꞌa ñaꞌá, ta̱xi ra nda̱yí nduu na sa̱ꞌya Ndios. ");
INSERT INTO mim_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ta ni̱vi na ndu̱u sa̱ꞌya Ndios, nayóꞌo ka̱ku xa̱á na, ta o̱n vása ní‑kaku tuku na ñii ki̱ꞌva nda̱tán siꞌna ka̱ku na ti̱xin siꞌí na. Saá chi o̱n si̱ví xa̱ꞌa̱ ña kóni yivá siꞌí na kúu ña tuku ka̱ku xa̱á na. Ta xa̱ꞌa̱ ña kóni Ndios kúu ña ndu̱u ni̱vi sa̱ꞌya mi̱i Ndios. ");
INSERT INTO mim_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ta To̱ꞌon Ndios ndu̱u ña ñii ta̱a ndinoꞌo, ta xi̱komí ra yi̱kí ko̱ñu ni̱vi, ta xi̱taku̱ ra xíꞌin ndi̱ ñoyívi yóꞌo. Ta xi̱ni ndi̱ ñava̱ꞌa káꞌno ña livi ní ña kómí ra. Ta mi̱i ñava̱ꞌa káꞌno ña livi ní ña kómí Ndios kúu ña kómí ra, chi ñii la̱á mi̱i ra kúu Sa̱ꞌya Ndios, ta ta̱a ta̱ ndixa nda̱a̱ ndinoꞌo ini kúu ra, ta chútú ini ra xíꞌin ndiꞌi saá no̱o̱ ñava̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ta ta̱Juan nda̱kuii̱n ra ñanda̱a̱ xa̱ꞌa̱ ta̱a yóꞌo ta̱ kúu To̱ꞌon Ndios, ta ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Vará yi̱ꞌi̱ siꞌna ka̱ku i̱ no̱o̱ ta̱yóꞌo, ta ndixa ta̱a ta̱ káꞌno no̱o̱ yi̱ꞌi̱ kúu ra, chi o̱n ta̱ꞌán ka̱ kutaku̱ i̱ ti̱xin siꞌí i̱, ta xa táku̱ ta̱yóꞌo ―káchí ta̱Juan, ta̱a ta̱ sákuchu ni̱vi, xa̱ꞌa̱ Jesucristo, ta̱a ta̱ kúu To̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ta ta̱a yóꞌo, chútú nda̱a̱ ini ra xíꞌin ndiꞌi saá no̱o̱ ñava̱ꞌa. Ta mi̱i yó, xa nákiꞌin yó kua̱ꞌa̱ ní ñava̱ꞌa táxi ra ndaꞌa̱ yó ñii ñii ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kui̱ya̱ xi̱na̱ꞌá, ndaꞌa̱ xi̱i̱ síkuá yó ta̱Moisés, Ndios ta̱xi ra nda̱yí ña xa̱ꞌnda chiño no̱o̱ yó. Ta saá ki̱xaa̱ Jesucristo ñoyívi yóꞌo, ta ta̱xi ra ña kúnda̱a̱ ini yó ñava̱ꞌa káꞌno ña yóo ini Ndios, ta ta̱xi ra ña kúnda̱a̱ ini yó ñanda̱a̱ ndinoꞌo. ");
INSERT INTO mim_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nda̱ ñii ni̱vi o̱n ta̱ꞌán koni na Ndios xíꞌin nduchu̱ no̱o̱ mi̱i na. Ta Jesucristo sa̱náꞌa ra mi̱i yó yu kúu Ndios ta ndasaá yóo ini Ndios, chi yóo ra xíꞌin Ndios ta xíni̱ va̱ꞌa ñaꞌá ra, ta ñii la̱á mi̱i ra kúu Sa̱ꞌya Ndios. ");
INSERT INTO mim_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ñii ki̱vi̱ yóo ta̱Juan sánáꞌa ra ni̱vi, ta nanáꞌno no̱o̱ najudío na táku̱ ñoo Jerusalén ti̱ꞌví na sava nasu̱tu̱ xíꞌin sava naLeví, na kúu na ndíso chiño xíꞌin veꞌe ño̱ꞌo káꞌno, kua̱ꞌa̱n na nda̱ka̱ to̱ꞌon na ta̱Juan. Ta ni̱xaa̱ na no̱o̱ ta̱yóꞌo, ta ni̱ka̱ꞌa̱n na xíꞌin ra, káchí na saá: ―¿Yu kúu yóꞌó? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ta ta̱Juan o̱n vása ní‑yiꞌví ra ka̱ꞌa̱n ra xíꞌin na, ta nda̱kuii̱n ra, káchí ra saá: ―O̱n si̱ví yi̱ꞌi̱ kúu Cristo, ta̱a ta̱ tiꞌví Ndios saka̱ku ni̱vi ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ta tuku ni̱nda̱ka̱ to̱ꞌon na ra, káchí na saá: ―¿Ta yu kúu yóꞌó? ¿Án yóꞌó kúu ta̱profeta Elías? Ta ni̱ka̱ꞌa̱n ta̱Juan xíꞌin na: ―O̱n si̱ví ta̱Elías kúu yi̱ꞌi̱ ―káchí ra. Ta ni̱nda̱ka̱ to̱ꞌon ka̱ na ra, káchí na saá: ―¿Án yóꞌó kúu inka̱ ta̱profeta káꞌno ta̱ ndáti ndi̱ kixaa̱? Ta nda̱kuii̱n ta̱Juan, ni̱ka̱ꞌa̱n ra saá: ―O̱n si̱ví yi̱ꞌi̱ kúu ta̱profeta ndáti ndó ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ta saá ni̱ka̱ꞌa̱n ka̱ na xíꞌin ra, káchí na saá: ―Va̱ꞌa ka̱ꞌa̱n ún xíꞌin ndi̱ yu kúu ún, chi xíni̱ ñóꞌó ndikó ndi̱ ta ndato̱ꞌon ndi̱ xíꞌin ni̱vi na ti̱ꞌví ndi̱ va̱xi ndi̱. Ta vitin ka̱ꞌa̱n ún xíꞌin ndi̱ ndixa yu kúu ún. ");
INSERT INTO mim_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ta ni̱ka̱ꞌa̱n ta̱Juan xíꞌin na, káchí ra saá: ―Yi̱ꞌi̱ kúu ta̱a ta̱ ni̱ka̱ꞌa̱n ta̱profeta Isaías xa̱ꞌa̱, chi kui̱ya̱ xi̱na̱ꞌá ta̱profeta Isaías yóꞌo ni̱taa ra to̱ꞌon Ndios ña káchí saá: Ñii ki̱vi̱ no̱o̱ yóo yuku̱ yi̱chí koo ñii ta̱a, ta ndeé ní ka̱ꞌa̱n ndoso ra no̱o̱ ni̱vi, kachí ra saá: “Nda̱tán yóo ña ndasa nda̱kú ni̱vi yichi̱, ta nakuiná na yichi̱ yóꞌo no̱o̱ ña kixaa̱ ta̱káꞌno, ta ñii ki̱ꞌva saá xíni̱ ñóꞌó nakuiná ndó ini ndó ña koo tiꞌva ndó nakiꞌin ndó Ta̱a ta̱Káꞌno no̱o̱ yó”, káchí to̱ꞌon Ndios ña ni̱taa ta̱Isaías kui̱ya̱ xi̱na̱ꞌá ―káchí ta̱Juan xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ta sava na ki̱xaa̱ no̱o̱ ta̱Juan yóꞌo kúu na nafariseo, ");
INSERT INTO mim_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ta nafariseo yóꞌo ni̱nda̱ka̱ to̱ꞌon na ta̱Juan, káchí na saá: ―Tá o̱n si̱ví Cristo kúu ún, ta ni o̱n si̱ví ta̱Elías kúu ún, ta ni o̱n si̱ví inka̱ ta̱profeta káꞌno kúu ún, ta saá, ¿nda̱chun sákuchu ún ni̱vi? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ta nda̱kuii̱n ta̱Juan, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Xíꞌin takuií kuiti sákuchu i̱ ni̱vi. Ta ndixa xa yóo ñii ta̱a ta̱ táku̱ ñoo Israel xíꞌin ndó vitin, ta o̱n ta̱ꞌán koni ndó ra. ");
INSERT INTO mim_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ta̱yóꞌo kúu ta̱a ta̱ va̱xi sa̱ta̱ i̱. Ta ta̱a ta̱ káꞌno ní no̱o̱ i̱ kúu ra, ta yi̱ꞌi̱ kúu ta̱a ta̱ ni̱no̱ ní ka̱ no̱o̱ ra. Yi̱ꞌi̱ kúu ta̱ kísa chiño kuiti no̱o̱ ra ―káchí ta̱Juan xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Saá ndo̱ꞌo ta̱Juan xíꞌin ni̱vi yóꞌo yatin ñoo Betábara ña nákaa̱ yuꞌu̱ yu̱ta Jordán no̱o̱ sákuchu ta̱Juan ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ta saá ni̱ti̱vi inka̱ ki̱vi̱, ta ta̱Juan na̱koto ra va̱xi ta̱Jesús, ta ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi, káchí ra saá: ―¡Koto ndó! Ta̱yóꞌo kúu ta̱a ta̱ ti̱ꞌví Ndios kivi̱ xa̱ꞌa̱ kua̱chi ni̱vi. Nda̱tán yóo ndikachi loꞌo tí sóko̱ ni̱vi no̱o̱ Ndios ña kasa káꞌno ini ra xa̱ꞌa̱ kua̱chi na, saá yóo ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ta̱yóꞌo kúu ta̱a ta̱ nda̱to̱ꞌon i̱ xíꞌin ndó xa̱ꞌa̱. Ni̱ka̱ꞌa̱n i̱ xíꞌin ndó ndí va̱xi ñii ta̱a sa̱ta̱ i̱, ta ta̱a ta̱ káꞌno no̱o̱ i̱ kúu ra, chi ki̱vi̱ ka̱ku i̱, xa táku̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ta siꞌna o̱n vása ní‑kunda̱a̱ ini i̱ tá ta̱yóꞌo kúu ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ra mi̱i yó. Ta yi̱ꞌi̱ sákuchu i̱ ni̱vi xíꞌin takuií, chi saá kísa ndivi i̱ ña kóni Ndios xa̱ꞌa̱ ña kuchiño nañoo Israel nakoni na yu kúu ta̱yóꞌo ―káchí ta̱Juan xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ta saá ni̱ka̱ꞌa̱n ka̱ ta̱Juan xa̱ꞌa̱ ta̱Jesús, káchí ra saá: ―Yi̱ꞌi̱ xi̱ni i̱ ndasaá ki̱xi noo Níma̱ Ndios nda̱ ñoyívi ni̱no, ta no̱o ña nda̱tán va̱xi noo ñii tísa̱ta, ta xi̱kanóo ña no̱o̱ ñíndichi ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Siꞌna o̱n vása ní‑kunda̱a̱ ini i̱ tá ta̱yóꞌo kúu ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ra mi̱i yó, ta mi̱i Ndios ta̱ ti̱ꞌví yi̱ꞌi̱ sakuchu i̱ ni̱vi, ni̱ka̱ꞌa̱n ra xíꞌin i̱, ka̱chí ra saá: “Ñii ki̱vi̱ koto ún Níma̱ i̱ ndasaá kixi noo ña nda̱ ñoyívi ni̱no, ta kanóo ña no̱o̱ ñíndichi ñii ta̱a, ta ta̱yóꞌo kúu ta̱a ta̱ sakuchu ni̱vi xíꞌin Níma̱ i̱”, ka̱chí Ndios xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ta vitin xa xi̱ni i̱ ñayóꞌo nda̱tán yóo ña ni̱ka̱ꞌa̱n Ndios xíꞌin i̱, ta saá káꞌa̱n i̱ ñanda̱a̱ xíꞌin ndó ndí ta̱Jesús yóꞌo kúu Sa̱ꞌya Ndios ―káchí ta̱Juan xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ta ni̱ti̱vi inka̱ ki̱vi̱, ta tuku yóo ta̱Juan xíꞌin o̱vi̱ naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ta xi̱ni ta̱Juan ni̱yaꞌa ta̱Jesús kua̱ꞌa̱n ra, ta ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Koto ndó kaa̱, chi ta̱a ta̱ kua̱ꞌa̱n kaa̱, nda̱tán yóo ndikachi loꞌo tí sóko̱ ni̱vi no̱o̱ Ndios xa̱ꞌa̱ kua̱chi na, saá yóo ra ―káchí ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tá xi̱ni̱ so̱ꞌo o̱vi̱ ta̱a yóꞌo ña káꞌa̱n ta̱Juan, ta xa̱ndi̱ko̱n ki̱xáꞌá na ndíko̱n na kua̱ꞌa̱n na sa̱ta̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ta saá ta̱Jesús na̱ndikó koo ra ta ni̱nda̱ka̱ to̱ꞌon ra na, káchí ra saá: ―¿Yukía̱ ndúkú ndó? Ta nda̱kuii̱n na, ni̱nda̱ka̱ to̱ꞌon na ra, káchí na saá: ―Tata Rabí, ¿míkía̱ yóo veꞌe no̱o̱ kíndo̱o ún vitin? ―káchí na xíꞌin ra. (Ta to̱ꞌon Rabí kóni kachí ña Maestro.) ");
INSERT INTO mim_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―Naꞌa ndó ko̱ꞌo̱n ndó xíꞌin i̱ ta koni ndó mí yóo ña ―káchí ra xíꞌin na. Ta saá kua̱ꞌa̱n na xíꞌin ra nda̱ veꞌe no̱o̱ kíndo̱o ra. Tá ni̱xaa̱ na veꞌe yóꞌo, ta xa ni̱to̱nda̱a ka̱a ko̱mi̱ xikuaa kúu ña, ta ki̱ndo̱o na veꞌe yóꞌo xíꞌin ra nda̱ inka̱ ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ñii ta̱yóꞌo na̱ní Andrés, ta kúu ra ta̱a ta̱ xa xi̱ni̱ so̱ꞌo ña ni̱ka̱ꞌa̱n ta̱Juan, ta ki̱xáꞌá ra ndíko̱n ra sa̱ta̱ ta̱Jesús. Ta̱Andrés yóꞌo kómí ra ñii ñani ra, ta̱ na̱ní Simón Pedro. ");
INSERT INTO mim_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ta saá kama ní ke̱e ta̱Andrés yóꞌo kua̱ꞌa̱n ra nandukú ra ñani ra ta̱Simón Pedro. Tá ni̱xaa̱ ra ta na̱níꞌi ñaꞌá ra, ta ni̱ka̱ꞌa̱n ra xíꞌin ra, káchí ra saá: ―Xa na̱kutáꞌan ndi̱ xíꞌin ta̱a ta̱ kúnda̱a̱ ini ndi̱ kúu ta̱Mesías ―káchí ra. (To̱ꞌon Mesías kúu to̱ꞌon hebreo ña kóni kachí Cristo to̱ꞌon griego.) ");
INSERT INTO mim_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ta saá ta̱Andrés xa̱ndi̱ko̱n kua̱ꞌa̱n ra, ta kua̱ꞌa̱n ñani ra xíꞌin ra, ta ni̱xaa̱ na no̱o̱ yóo ta̱Jesús. Ta ta̱Jesús xi̱to káxín ra no̱o̱ ta̱a ta̱ kúu ñani ta̱Andrés yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin ra, káchí ra saá: ―Yóꞌó kúu ta̱Simón, sa̱ꞌya ta̱Jonás. Ta vitin kunaní ún Cefas ―káchí ra. (Ta ki̱vi̱ Cefas kúu to̱ꞌon arameo, ta kóni kachí ña Pedro to̱ꞌon griego, ta o̱vi̱ ki̱vi̱ yóꞌo kóni kachí ña yu̱u̱.) ");
INSERT INTO mim_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ta ni̱ti̱vi inka̱ ki̱vi̱, ta xáni si̱ni̱ ta̱Jesús ko̱ꞌo̱n ra ñoo estado Galilea. Ta ke̱e ra kua̱ꞌa̱n ra, ta ni̱xaa̱ ra ñoo yóꞌo, ta na̱níꞌi ra ta̱Felipe. Ta ni̱ka̱ꞌa̱n ra xíꞌin ra, káchí ra saá: ―Naꞌa, kundiko̱n ún sa̱ta̱ i̱ ―káchí ta̱Jesús xíꞌin ta̱Felipe. ");
INSERT INTO mim_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ñoo Betsaida estado Galilea kúu ñoo mi̱i ta̱Felipe yóꞌo. Ta saá tuku ta̱Simón Pedro xíꞌin ta̱Andrés kúu na nañoo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ta saá ta̱Felipe ke̱e ra kua̱ꞌa̱n ra nándukú ra ta̱Natanael. Tá na̱níꞌi ñaꞌá ra, ta ni̱ka̱ꞌa̱n ra xíꞌin ra, káchí ra saá: ―Xa na̱kutáꞌan ndi̱ xíꞌin ñii ta̱a ta̱ kúu ta̱ ndáti yó chi kui̱ya̱ xi̱na̱ꞌá ta̱Moisés xíꞌin inka̱ naprofeta ni̱taa na xa̱ꞌa̱ ta̱yóꞌo. Ta̱Jesús sa̱ꞌya ta̱José kúu ra, ta kúu ra ta̱ñoo Nazaret ―saá ni̱ka̱ꞌa̱n ta̱Felipe xíꞌin ta̱Natanael. ");
INSERT INTO mim_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ta nda̱kuii̱n ta̱Natanael, káchí ra saá: ―Ñoo Nazaret, ¿káchí ún? ¿Án ndixa kúchiño kee ñii ta̱va̱ꞌa ñoo yóꞌo? ―káchí ta̱Natanael xíꞌin ta̱Felipe. Ta nda̱kuii̱n ta̱Felipe, káchí ra saá: ―Naꞌa ko̱ꞌo̱n ún xíꞌin i̱, ta koto ún ―káchí ra. Ta ke̱e na kua̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ta saá ta̱Jesús xi̱ni ra ta̱Natanael va̱xi yatin ra no̱o̱ yóo ra, ta ni̱ka̱ꞌa̱n ta̱Jesús, káchí ra saá: ―Ta̱yóꞌo kúu ta̱Israel ndinoꞌo. Ta̱a ta̱ nda̱a̱ ini kúu ra, ta nda̱ loꞌo o̱n vása sándáꞌví ra ni̱vi ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ta nda̱kuii̱n ta̱Natanael, káchí ra saá: ―¿Ndasaá va̱ꞌa xíni̱ ún yi̱ꞌi̱, tata? Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ra: ―O̱n ta̱ꞌán ka̱ xaa̱ ta̱Felipe kana ra yóꞌó, ta xa xi̱ni i̱ yóꞌó, yóo ún xa̱ꞌa̱ yito̱n tón higo ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ta nda̱kuii̱n ta̱Natanael, káchí ra saá: ―Tata Rabí, ndixa yóꞌó kúu Sa̱ꞌya Ndios, yóꞌó kúu ta̱a ta̱Rey, ta̱káꞌno no̱o̱ naIsrael. ");
INSERT INTO mim_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá: ―¿Án kuiti kándixa ún yi̱ꞌi̱ xa̱ꞌa̱ ña ni̱ka̱ꞌa̱n i̱ xíꞌin ún ndí xi̱ni i̱ yóꞌó ki̱vi̱ yóo ún xa̱ꞌa̱ yito̱n tón higo? Ta saá ni, va̱xi ñii ki̱vi̱ koni ka̱ ún ñanáꞌno ní ka̱ no̱o̱ ñayóꞌo ―káchí ta̱Jesús xíꞌin ta̱Natanael. ");
INSERT INTO mim_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ndiꞌi ni̱vi na ndíko̱n sa̱ta̱ ra, káchí ra saá: ―Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó ndí ñii ki̱vi̱ ña va̱xi koni ndó ndasaá no̱na̱ ñoyívi ni̱no, ta saá koni ndó kua̱ꞌa̱ ní naángel Ndios na kua̱ꞌa̱n ndaa nda̱ ñoyívi ni̱no ta na va̱xi noo nda̱ ñoyívi yóꞌo, no̱o̱ yóo yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ni̱to̱nda̱a ki̱vi̱ u̱ni̱, ta ka̱na viko̱ tonda̱ꞌa̱ ñoo Caná ña nákaa̱ estado Galilea. Ta ñáMaría ñá kúu siꞌí ta̱Jesús xa yóo ñá no̱o̱ koo viko̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ta ni̱vi na káꞌa̱n viko̱ yóꞌo xa ka̱na na ta̱Jesús xíꞌin naxíka xíꞌin ra ña koo na viko̱ yóꞌo. Ta saá ke̱e na kua̱ꞌa̱n na, ta ni̱xaa̱ na no̱o̱ yóo viko̱ tonda̱ꞌa̱. ");
INSERT INTO mim_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tá yóo na viko̱ yóꞌo, ta saá ndi̱ꞌi nduta̱ vino tá xíꞌi ni̱vi, ta nda̱ loꞌo ka̱ rá o̱n ko̱ó. Ta saá ñáMaría siꞌí ta̱Jesús ni̱ka̱ꞌa̱n ñá xíꞌin ra, káchí ñá saá: ―Ndi̱ꞌi nda̱a̱ nduta̱ vino, ta o̱n ko̱ó ka̱ rá koꞌo ni̱vi na ki̱xaa̱ ―káchí ñá xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ta nda̱kuii̱n ta̱Jesús, káchí ra saá xíꞌin siꞌí ra: ―¿Nda̱chun ndáto̱ꞌon ún tondíni yóꞌo xíꞌin i̱, nana?, chi o̱n ta̱ꞌán to̱nda̱a hora ña chi̱tóni̱ Ndios ña kasa ndivi i̱ chiño náꞌno ―káchí ta̱Jesús xíꞌin siꞌí ra. ");
INSERT INTO mim_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ta saá ni̱ka̱ꞌa̱n ñá xíꞌin ni̱vi na kísa chiño no̱o̱ na káꞌa̱n viko̱ yóꞌo, káchí ñá saá xíꞌin na: ―Ndiꞌi ña kaꞌnda chiño sa̱ꞌya i̱ no̱o̱ ndó, va̱ꞌa kasa ndivi ndó ña ―káchí siꞌí ta̱Jesús xíꞌin na kísa chiño viko̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yatin no̱o̱ yóo ta̱Jesús yíta i̱ño̱ ki̱si yu̱u̱ náꞌno, chi najudío xíni̱ ñóꞌó na takuií tá ñóꞌo ini ki̱si yóꞌo ña kasa ndivi na nda̱yí na, ña káchí ndasaá xíni̱ ñóꞌó ndaꞌá na xa̱ꞌa̱ ña koo na ni̱vi na ndii no̱o̱ Ndios. Ta ñii ñii ki̱si yu̱u̱ yóꞌo kúndeé ña koꞌon ko̱mi̱ si̱ko̱ litro án nda̱ ñii ciento litro takuií ini ña. ");
INSERT INTO mim_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ni̱vi na kísa chiño no̱o̱ na káꞌa̱n viko̱, káchí ra saá xíꞌin na: ―Sakutú nda̱a̱ ndó takuií ini ndiꞌi ki̱si yóꞌo ―káchí ra xíꞌin na. Ta ki̱xáꞌá na sákutú nda̱a̱ na takuií ini ndiꞌi ki̱si yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ta ni̱ka̱ꞌa̱n tuku ta̱Jesús xíꞌin na, káchí ra saá: ―Vitin tava ndó loꞌo rá ta taxi ndó rá ndaꞌa̱ ta̱ ndíso chiño xíꞌin viko̱ yóꞌo ―káchí ta̱Jesús. Ta saá ke̱ꞌé ni̱vi na kísa chiño yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tá ta̱ ndíso chiño xíꞌin viko̱ xi̱to ndoso ra nduta̱ yóꞌo, ta o̱n si̱ví ka̱ takuií kúu rá, chi ndu̱u rá vino. Ta ta̱yóꞌo o̱n vása ní‑xini̱ ra míchí ki̱xi távino yóꞌo, ta ndasaá kuiti na kísa chiño no̱o̱ ra xíni̱ na míchí ke̱e rá. Ta saá ta̱ ndíso chiño xíꞌin viko̱ ka̱na ra ta̱a ta̱ to̱nda̱ꞌa̱, ");
INSERT INTO mim_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ta ni̱ka̱ꞌa̱n ra xíꞌin ra, káchí ra saá: ―Inka̱ ni̱vi siꞌna táxi na vino tá va̱ꞌa ní ka̱ koꞌo ni̱vi na ki̱xaa̱ viko̱. Ta saá, xa kua̱ꞌa̱ ní vino va̱ꞌa yóꞌo xíꞌi na, ta saá ta̱a ta̱ sákana viko̱ táxi ra vino tá ni̱no̱ ní kóni koꞌo ni̱vi na ki̱xaa̱ viko̱. Ta yóꞌó, ni̱‑keꞌé ún saá, chi chi̱kaa̱ va̱ꞌa ún vino tá va̱ꞌa ní, ta̱nda̱ vitin ta̱va ún rá ta ta̱xi ún rá koꞌo yó ―káchí ra xíꞌin ta̱ to̱nda̱ꞌa̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ta seña yóꞌo kúu ñano̱ó ke̱ꞌé ta̱Jesús, ta ñoo Caná ña nákaa̱ estado Galilea kúu no̱o̱ ke̱ꞌé ra ña. Xíꞌin ñava̱ꞌa yóꞌo ta̱Jesús sa̱náꞌa ra ndee̱ káꞌno ña livi ní kómí ra. Ta naxíka xíꞌin ta̱Jesús ka̱ndixa na ra. ");
INSERT INTO mim_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ta ndi̱ꞌi ni̱yaꞌa ñayóꞌo, ta ke̱e ta̱Jesús kua̱ꞌa̱n ra. Ta siꞌí ra, xíꞌin ñani ra, xíꞌin naxíka xíꞌin ra, kua̱ꞌa̱n na xíꞌin ra, ta ni̱xaa̱ na ñoo Capernaum, ta xi̱ndo̱o na ñoo yóꞌo loꞌo kuiti ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ta xa va̱xi yatin ki̱vi̱ kana viko̱ Pascua najudío ñoo Jerusalén, ta ta̱Jesús ke̱e ra kua̱ꞌa̱n ra viko̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ki̱xaa̱ ra no̱o̱ yóo ke̱ꞌe yéꞌé veꞌe ño̱ꞌo káꞌno ñoo Jerusalén, ta yóꞌo xi̱ni ra ni̱vi na síkó tísi̱ndi̱ki̱, na síkó tíndikachi, xíꞌin na síkó tísa̱ta. Ta yóo inka̱ ni̱vi na sáma si̱ꞌún. ");
INSERT INTO mim_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tá ta̱Jesús xi̱ni ra nayóꞌo, ta ki̱ꞌin ra ñii tu̱chu káni̱, ta ki̱sa va̱ꞌa ra ñii kuártá xíꞌin tu̱chu yóꞌo. Ta xíꞌin kuártá yóꞌo ki̱xáꞌá ra táva ra ndiꞌi ni̱vi na síkó yóꞌo, ta saá kama ke̱e ndiꞌi na kua̱ꞌa̱n na xíꞌin tíndikachi ta xíꞌin tísi̱ndi̱ki̱ síkó na. Ta ta̱Jesús sa̱ndiva ra mesa ni̱vi na sáma si̱ꞌún, ta ni̱xi̱ta̱ níꞌnó ndiꞌi si̱ꞌún na. ");
INSERT INTO mim_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ta xa̱ꞌnda chiño ra no̱o̱ ni̱vi na síkó tísa̱ta, káchí ra saá xíꞌin na: ―¡Tiin ndó tava ndó tísa̱ta yóꞌo! O̱n váꞌa sanduu ndó veꞌe Yivá i̱ ñii no̱yáꞌvi ―káchí ra xíꞌin na síkó tísa̱ta. ");
INSERT INTO mim_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ta saá naxíka xíꞌin ra na̱káꞌán na ña káchí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá xa̱ꞌa̱ ña ke̱ꞌé ta̱Jesús yóꞌo vitin, chi káchí ña saá: “Ñii ni̱xi̱no̱ sáa̱ i̱ xíꞌin ña káꞌu̱n ini i̱ xa̱ꞌa̱ ña o̱n váꞌa kéꞌé ni̱vi xíꞌin veꞌe Yivá i̱ Ndios”, káchí to̱ꞌon Ndios. ");
INSERT INTO mim_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ta najudío na xi̱ni ña ke̱ꞌé ra saá ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús, káchí na saá: ―¿Ndá milagro keꞌé ún koni ndi̱ ña sanáꞌa ún kunda̱a̱ ini ndi̱ ña ndixa kómí ún nda̱yí ke̱ꞌé ún saá xíꞌin veꞌe ño̱ꞌo yóꞌo? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Táná sandiꞌi ndó xa̱ꞌa̱ veꞌe ño̱ꞌo yóꞌo, ta saá ti̱xin ña u̱ni̱ ki̱vi̱ kasa va̱ꞌa i̱ ña ta tuku nakundichi ña ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ta nda̱kuii̱n tuku najudío, ni̱ka̱ꞌa̱n na xíꞌin ra, káchí na saá: ―O̱vi̱ si̱ko̱ i̱ño̱ kui̱ya̱ xa ki̱sa chiño ni̱vi xa̱ꞌa̱ ña ki̱sa va̱ꞌa na veꞌe ño̱ꞌo káꞌno yóꞌo. Ta yóꞌó, ¿án xáni si̱ni̱ ún ndí kúchiño ún kasa va̱ꞌa ún veꞌe ño̱ꞌo yóꞌo ti̱xin ña u̱ni̱ kuiti ki̱vi̱? ");
INSERT INTO mim_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ta ta̱Jesús o̱n si̱ví xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno ña nákaa̱ ñoo Jerusalén yóꞌo kúu ña káꞌa̱n ra, chi ta̱yóꞌo káꞌa̱n ra xa̱ꞌa̱ yi̱kí ko̱ñu mi̱i ra. ");
INSERT INTO mim_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ta naxíka xíꞌin ta̱Jesús o̱n vása kúnda̱a̱ ini na ñayóꞌo, ta̱nda̱ ki̱xaa̱ ki̱vi̱ ña ni̱xiꞌi̱ ta̱Jesús ta ti̱xin ña u̱ni̱ ki̱vi̱ na̱taku̱ ra, ta̱nda̱ saá na̱káꞌán na to̱ꞌon yóꞌo, ta ka̱ndixa na to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá, ta ka̱ndixa na to̱ꞌon ña ni̱ka̱ꞌa̱n ta̱Jesús xi̱ni̱ so̱ꞌo na vitin. ");
INSERT INTO mim_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ta yóo ta̱Jesús ñoo Jerusalén no̱o̱ kána viko̱ Pascua, ta ñii ñii ki̱vi̱ kána viko̱ Pascua yóꞌo, ke̱ꞌé ra kua̱ꞌa̱ ní milagro ña xi̱ni ni̱vi, ta kua̱ꞌa̱ ní ni̱vi yóꞌo ki̱xáꞌá na kándixa na ra. ");
INSERT INTO mim_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ta ta̱Jesús o̱n vása ndáa ini ra ni̱vi yóꞌo chi xíni̱ ra ndasaá yóo ini ndiꞌi ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ni o̱n vása ní‑xini̱ ñóꞌó ra inka̱ ni̱vi ña ndato̱ꞌon na xíꞌin ra, chi xa xíni̱ va̱ꞌa ra ndasaá yóo ini ndiꞌi ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ni̱xi̱yo ñii ta̱a ta̱ na̱ní Nicodemo, ta̱fariseo kúu ra, ta ñii ta̱káꞌno no̱o̱ najudío kúu ra, ta ta̱táꞌan nachiño na̱ní Junta Suprema kúu ra. ");
INSERT INTO mim_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ta ñii ñoó, ta xa ñoó ní kúu ña, ke̱e ta̱Nicodemo kua̱ꞌa̱n ra, ta ni̱xaa̱ ra no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n ra xíꞌin ra, káchí ra saá: ―Tata Rabí, xíni̱ ndi̱ yóꞌó kúu ñii ta̱maestro ta̱ ti̱ꞌví Ndios, chi nda̱ ñii ni̱vi o̱n vása kúchiño keꞌé na milagro nda̱tán yóo ña kéꞌé ún, tá o̱n ko̱ó Ndios yóo xíꞌin na ―saá káchí ta̱Nicodemo xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Ñandixa káꞌa̱n i̱ xíꞌin ún, nda̱ ñii ni̱vi o̱n ki̱ví ki̱ꞌvi na yichi̱ no̱o̱ xáꞌnda chiño Ndios tá o̱n kaku tuku na inka̱ yichi̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ta saá ta̱Nicodemo ni̱nda̱ka̱ to̱ꞌon tuku ra ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―¿Ndasaá kuchiño keꞌé ñii ta̱xi̱kua̱ꞌa̱ ña tuku kaku ra?, chi o̱n kuchiño ndikó tuku ra ndi̱ꞌvi ra ti̱xin siꞌí ra ta kaku ra inka̱ yichi̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra saá: ―Ñandixa káꞌa̱n i̱ xíꞌin ún, xíni̱ ñóꞌó kaku ni̱vi xíꞌin takuií ta xíꞌin Níma̱ Ndios. Tá o̱n keꞌé na saá, ta o̱n kuchiño na ki̱ꞌvi na yichi̱ no̱o̱ xáꞌnda chiño Ndios. ");
INSERT INTO mim_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ndiꞌi ni̱vi na káku ti̱xin siꞌí kómí na ko̱ñu xíꞌin níma̱ ni̱vi, chi ni̱vi kúu na. Ta ni̱vi na káku xíꞌin ndee̱ Níma̱ Ndios kúu ni̱vi na ndixa táku̱ Níma̱ Ndios ini. ");
INSERT INTO mim_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ta saá o̱n nakaꞌnda ini ún xa̱ꞌa̱ to̱ꞌon ña ni̱ka̱ꞌa̱n i̱ xíꞌin ún ndí xíni̱ ñóꞌó kaku tuku ni̱vi inka̱ yichi̱. ");
INSERT INTO mim_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nda̱tán yóo ta̱chi̱ saá yóo Níma̱ Ndios, chi ta̱chi̱ xíka ña yóꞌo ta xíka ña kaa̱, ta o̱n vása xíni̱ yó míchí va̱xi ña, ni o̱n vása xíni̱ yó míchí kua̱ꞌa̱n ña. Ndasaá kuiti xíni̱ so̱ꞌo yó mí níꞌi̱ ña. Ñii ki̱ꞌva saá yóo ña xíꞌin ni̱vi na ka̱ku xa̱á xíꞌin ndee̱ Níma̱ Ndios. Saá chi o̱n kúchiño koto yó ndasaá kísa chiño Níma̱ Ndios ini ni̱vi yóꞌo ―káchí ta̱Jesús xíꞌin ta̱Nicodemo. ");
INSERT INTO mim_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ta ta̱Nicodemo ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús, káchí ra saá: ―¿Ndasaá kuchiño koo ña káꞌa̱n ún xa̱ꞌa̱, tata? ");
INSERT INTO mim_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Yóꞌó kúu ta̱maestro ta̱káꞌno no̱o̱ nañoo Israel. ¿Nda̱chun o̱n vása kúnda̱a̱ ini ún ña káꞌa̱n i̱ xíꞌin ún? ");
INSERT INTO mim_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ñandixa káꞌa̱n i̱ xíꞌin ún ndí mi̱i ndi̱ káꞌa̱n ndi̱ xa̱ꞌa̱ ña xíni̱ ndi̱, ta ndákuii̱n ndi̱ xa̱ꞌa̱ ña xi̱to ndi̱, ta ndóꞌó o̱n xi̱in ndó kandixa ndó to̱ꞌon káꞌa̱n ndi̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ta vitin ndáto̱ꞌon i̱ xíꞌin ndó xa̱ꞌa̱ ña yóo ñoyívi yóꞌo, ta o̱n vása kándixa ndó yi̱ꞌi̱. Ta saá yo̱ꞌvi̱ ní ka̱ kandixa ndó yi̱ꞌi̱ táná ndato̱ꞌon i̱ xíꞌin ndó xa̱ꞌa̱ ña yóo ñoyívi ni̱no no̱o̱ yóo Ndios. ");
INSERT INTO mim_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Nda̱ ki̱vi̱ no̱ó ta̱nda̱ ki̱vi̱ vitin o̱n ta̱ꞌán ndaa nda̱ ñii ni̱vi ñoyívi ni̱no ta noo tuku na nda̱ ñoyívi yóꞌo. Ta ndasaá kuiti yi̱ꞌi̱ kúu ñii la̱á ta̱a ta̱ ke̱e ñoyívi ni̱no no̱o̱ yóo Ndios, ta no̱o i̱ ki̱xaa̱ i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kui̱ya̱ xi̱na̱ꞌá ki̱vi̱ ni̱xi̱yo ta̱Moisés yuku̱ yi̱chí, ta xíꞌin ka̱a ña na̱ní bronce ki̱sa va̱ꞌa ra ñii ko̱o̱, chi saá ni̱ka̱ꞌa̱n Ndios xíꞌin ra keꞌé ra. Ta ta̱Moisés ka̱ni ndichi ra ñii yito̱n ta no̱o̱ yito̱n yóꞌo, ka̱takaa̱ ndaa ra ko̱o̱ yóꞌo. Ta ndiꞌi ni̱vi na ndeé ndóꞌo, tá ndasaá kuiti xi̱to ndaa na ko̱o̱ ka̱a yóꞌo, ta ndu̱va̱ꞌa ndiꞌi ni̱vi na ke̱ꞌé saá. Ta ñayóꞌo xi̱kuu ñii ña chi̱ndúꞌu̱ Ndios ña sanáꞌa ra ndasaá kundoꞌo yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, chi ñii ki̱vi̱ ña va̱xi ni̱vi ñoyívi yóꞌo kani ndichi na ñii yito̱n síkón ta katakaa̱ ndaa na yi̱ꞌi̱ no̱o̱ yito̱n yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Saá kundoꞌo i̱ xa̱ꞌa̱ ña ndiꞌi ni̱vi na kandixa yi̱ꞌi̱, ndixa kutaku̱ na xíꞌin Ndios ndiꞌi saá ki̱vi̱ ña va̱xi, ta nda̱ ñii ki̱vi̱ o̱n ndiꞌi xa̱ꞌa̱ na ―káchí ta̱Jesús xíꞌin ta̱Nicodemo. ");
INSERT INTO mim_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ta ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin ta̱Nicodemo, káchí ra saá: ―Kíꞌvi ní ini Ndios xíni ra ni̱vi ñoyívi yóꞌo, ña̱kán ti̱ꞌví ra yi̱ꞌi̱, ta kúu ñii la̱á Sa̱ꞌya ra no̱o̱ ra, ta ki̱xaa̱ i̱ ñoyívi yóꞌo, ta ndiꞌi ni̱vi na ndinoꞌo kandixa yi̱ꞌi̱, o̱n ndiꞌi xa̱ꞌa̱ nayóꞌo, ta ndixa kutaku̱ na xíꞌin Ndios ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","O̱n si̱ví xa̱ꞌa̱ ña ko̱ꞌo̱n ni̱vi no̱o̱ xo̱ꞌvi̱ ní na kúu xa̱ꞌa̱ ña ti̱ꞌví Ndios yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya mi̱i ra, ña ki̱xaa̱ i̱ ñoyívi yóꞌo. Ta Ndios ti̱ꞌví ra yi̱ꞌi̱ xa̱ꞌa̱ ña kasa ndivi i̱ chiño ña kuchiño saka̱ku ra ni̱vi ñoyívi yóꞌo no̱o̱ ndee̱ ña o̱n váꞌa. ");
INSERT INTO mim_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Saá chi ndiꞌi ni̱vi na ndinoꞌo kándixa yi̱ꞌi̱, o̱n ko̱ꞌo̱n na no̱o̱ xo̱ꞌvi̱ ní na. Ta ndiꞌi ni̱vi na o̱n xi̱in kandixa yi̱ꞌi̱ kúu ni̱vi na ndíso kua̱chi no̱o̱ Ndios, ta xíni̱ ñóꞌó ko̱ꞌo̱n na no̱o̱ xo̱ꞌvi̱ ní na. Saá chi ni̱‑xiin na kandixa na yi̱ꞌi̱, ta̱a ta̱ kúu ñii la̱á Sa̱ꞌya Ndios. ");
INSERT INTO mim_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ñayóꞌo kúu xa̱ꞌa̱ ña Ndios káꞌa̱n ra ndí ni̱vi ndíso na kua̱chi no̱o̱ ra: vará xa ki̱xaa̱ i̱ ñoyívi yóꞌo, ta yi̱ꞌi̱ kúu Ñoꞌo̱ ndinoꞌo yéꞌe, ta kua̱ꞌa̱ ní ni̱vi o̱n xi̱in na koni na Ñoꞌo̱ yóꞌo. Nda̱ víka̱, kúsii̱ ní ka̱ ini na xíni na ñanaa ní, chi kútoo ní na kéꞌé na ña o̱n váꞌa. ");
INSERT INTO mim_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ta ndiꞌi ni̱vi na kéꞌé ña o̱n váꞌa, nayóꞌo sáa̱ ini na xíni na Ñoꞌo̱ ndinoꞌo yéꞌe, ta ni o̱n xi̱in na kuyatin na no̱o̱ ña, chi yíꞌví na ko̱to̱ nati̱vi ndiꞌi ña o̱n váꞌa ke̱ꞌé na. ");
INSERT INTO mim_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ta saá ni, ni̱vi na kéꞌé ñava̱ꞌa, nayóꞌo ndixa kúsii̱ ini na kúyatin na no̱o̱ yóo Ñoꞌo̱ yéꞌe, chi saá nati̱vi káxín ndí kéꞌé na chiño va̱ꞌa kuiti xíꞌin ndee̱ Ndios ―káchí ta̱Jesús xíꞌin ta̱Nicodemo. ");
INSERT INTO mim_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ta ndi̱ꞌi ni̱yaꞌa ñayóꞌo, ta saá ke̱e ta̱Jesús kua̱ꞌa̱n ra. Ta naxíka xíꞌin ra kua̱ꞌa̱n na xíꞌin ra nda̱ ñoo estado Judea, ta sa̱kán loꞌo ki̱vi̱ ndóo na ñoo yóꞌo, ta sákuchu na ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ta ñii ki̱ꞌva saá yóo ta̱Juan sákuchu ra ni̱vi inka̱ ñoo na̱ní Enón ña nákaa̱ yatin ñoo Salim, chi yatin ñoo yóꞌo yóo kua̱ꞌa̱ ní takuií. Ta kua̱ꞌa̱ ní ni̱vi ki̱xaa̱ na no̱o̱ ra, ta sa̱kuchu ra na. ");
INSERT INTO mim_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Saá chi o̱n ta̱ꞌán kixaa̱ ki̱vi̱ tiin na ta̱Juan ko̱ꞌo̱n ra veꞌe ka̱a. ");
INSERT INTO mim_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ta ñii ki̱vi̱ saá sava naxíka xíꞌin ta̱Juan ki̱xáꞌá na náa na xíꞌin inka̱ najudío chi o̱n vása yóo yuꞌú na xa̱ꞌa̱ ndasaá xíni̱ ñóꞌó kuchu ni̱vi án ndasaá xíni̱ ñóꞌó ndaꞌá na xíꞌin takuií ña koo ndii na no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ta saá ki̱xaa̱ nayóꞌo no̱o̱ ta̱Juan ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tata Rabí, ¿án nákáꞌán ún ta̱a ta̱ ni̱xi̱yo xíꞌin ún inka̱ táꞌví yuꞌu̱ yu̱ta Jordán, ta̱a ta̱ nda̱to̱ꞌon ún xa̱ꞌa̱ xíꞌin ndi̱? Ta vitin yóo ra inka̱ xiiña sákuchu ra ni̱vi, ta ndiꞌi ni̱vi kua̱ꞌa̱n na no̱o̱ yóo ra ―káchí nayóꞌo xíꞌin ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ta nda̱kuii̱n ta̱Juan ni̱ka̱ꞌa̱n ra, káchí ra saá xíꞌin na: ―Nda̱ ñii ni̱vi o̱n ki̱ví kasa ndivi na chiño va̱ꞌa, tá o̱n si̱ví Ndios kúu ta̱ taxi nda̱yí xíꞌin ndee̱ ndaꞌa̱ na ña keꞌé na saá. ");
INSERT INTO mim_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Xa xi̱ni̱ so̱ꞌo ndó ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó: “O̱n si̱ví yi̱ꞌi̱ kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ni̱vi. Ta yi̱ꞌi̱ ndasaá kuiti kúu i̱ ta̱a ta̱ ti̱ꞌví Ndios va̱xi siꞌna no̱o̱ Cristo ña chindeé i̱ ni̱vi koo tiꞌva na xa̱ꞌa̱ ña kixaa̱ ra”, saá ni̱ka̱ꞌa̱n i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ta vitin nda̱tán yóo ñii ta̱a ta̱ xa yóo tiꞌva nakiꞌin ra ñii ñaꞌa̱ ñá kuu ñásíꞌí ra, saá yóo Cristo. Ta yi̱ꞌi̱ nda̱tán yóo ta̱migo ta̱a ta̱ tonda̱ꞌa̱ yóꞌo, saá yóo i̱, chi ta̱migo ra kúsii̱ ní ini ra ña xíni̱ so̱ꞌo ra to̱ꞌon ña káꞌa̱n ta̱a ta̱ tonda̱ꞌa̱ yóꞌo. Ta ñii ki̱ꞌva saá chútú ñasi̱i̱ ini i̱ vitin, chi xa ki̱xaa̱ Cristo ta xíni̱ so̱ꞌo i̱ to̱ꞌon ra. ");
INSERT INTO mim_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ta ñato̱ꞌó ta̱yóꞌo xíni̱ ñóꞌó kuaꞌno ka̱ ña, ta yi̱ꞌi̱ xíni̱ ñóꞌó nduu i̱ ta̱ ni̱no̱ ní ka̱ no̱o̱ ra ―káchí ta̱Juan xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ta ni̱ka̱ꞌa̱n ka̱ ta̱Juan, káchí ra saá: ―Ta̱a ta̱ ki̱xi no̱o̱ Ndios kúu ra ta̱a ta̱káꞌno no̱o̱ ndiꞌi ña yóo. Ta ni̱vi na ka̱ku ñoyívi yóꞌo kúu na ni̱vi ñoyívi yóꞌo, ta ndasaá kuiti káꞌa̱n na xa̱ꞌa̱ ña yóo ñoyívi yóꞌo. Ta ta̱a ta̱ ki̱xi ñoyívi ni̱no no̱o̱ yóo Ndios, kúu ra ta̱a ta̱káꞌno no̱o̱ ndiꞌi ña yóo ñoyívi yóꞌo xíꞌin ñoyívi ni̱no. ");
INSERT INTO mim_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ta̱yóꞌo ndákuii̱n ra káꞌa̱n ra ña ndixa nda̱a̱ xíꞌin ni̱vi xa̱ꞌa̱ ña xi̱ni̱ so̱ꞌo ra, ta xa̱ꞌa̱ ña xi̱ni ra, ta ni̱vi o̱n xi̱in na kandixa na to̱ꞌon káꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ta saá ni, yóo sava ni̱vi na kándixa ta nákiꞌin va̱ꞌa na to̱ꞌon ra, ta ni̱vi yóꞌo ndákuii̱n na ndí Ndios kúu ta̱nda̱a̱ ndinoꞌo. ");
INSERT INTO mim_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ta ta̱a ta̱ ti̱ꞌví Ndios káꞌa̱n ra ndasaá kuiti to̱ꞌon Ndios, ta Ndios ndiꞌi saá ki̱vi̱ sákutú ra xíꞌin Níma̱ ra ini ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kíꞌvi ní ini Ndios xíni ra Sa̱ꞌya ra, ta saá Ndios ta̱xi ra ndiꞌi ndee̱ xíꞌin ndiꞌi nda̱yí ndaꞌa̱ ra, ta kúu ra ta̱a ta̱káꞌno no̱o̱ ndiꞌi ña yóo. ");
INSERT INTO mim_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ndiꞌi ni̱vi na kándixa Sa̱ꞌya Ndios kúu ni̱vi na ndinoꞌo táku̱ no̱o̱ Ndios ndiꞌi saá ki̱vi̱. Ta ndiꞌi ni̱vi na o̱n xi̱in kandixa Sa̱ꞌya Ndios kúu ni̱vi na o̱n vása táku̱ no̱o̱ Ndios, ta ki̱vi̱ ña va̱xi Ndios saxo̱ꞌvi̱ ní ra ni̱vi yóꞌo ―káchí ta̱Juan. ");
INSERT INTO mim_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nafariseo xi̱ni̱ so̱ꞌo na ndí kua̱ꞌa̱ ní ka̱ ni̱vi ndíko̱n sa̱ta̱ ta̱Jesús vitin no̱o̱ ni̱vi na ndíko̱n sa̱ta̱ ta̱Juan, ta ta̱Jesús sákuchu ra kua̱ꞌa̱ ní ka̱ ni̱vi no̱o̱ ta̱Juan káchí na, káꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ta o̱n si̱ví mi̱i ta̱Jesús kúu ta̱ sákuchu ni̱vi, chi naxíka xíꞌin ra kúu na sákuchu ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ta ki̱vi̱ xi̱ni̱ so̱ꞌo ta̱Jesús ña káꞌa̱n ni̱vi saá xa̱ꞌa̱ ra, ta ke̱e ra ñoo estado Judea ta kua̱noꞌo̱ ra ñii ñoo estado Galilea. ");
INSERT INTO mim_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ta saá ndu̱xa̱ xíni̱ ñóꞌó yaꞌa ra ma̱ꞌñó estado Samaria. ");
INSERT INTO mim_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ta ni̱xaa̱ ra ñii ñoo na̱ní Sicar, ña nákaa̱ yatin no̱o̱ yóo ñoꞌo̱ ña ni̱taxi ta̱Jacob ndaꞌa̱ sa̱ꞌya ra ta̱José kui̱ya̱ xi̱na̱ꞌá ní. ");
INSERT INTO mim_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ta pozo ña ki̱sa va̱ꞌa ta̱Jacob kui̱ya̱ xi̱na̱ꞌá yóo ka̱ ña ñoo yóꞌo. Ta xa yatin tónda̱a ma̱ꞌñó ndiví kúu ña, ta ki̱xaa̱ ta̱Jesús no̱o̱ yóo pozo yóꞌo, ta kúnaa̱ ní ra, chi xíká ní ki̱xi ra, ta saá xi̱koo ra nakindée loꞌo ra. ");
INSERT INTO mim_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ta ki̱xaa̱ ñii ñaꞌa̱ ñáñoo Samaria ña tava ñá takuií pozo yóꞌo, ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ñá, káchí ra saá: ―Nana, ¿án taxi loꞌo ún takuií koꞌo i̱? ―káchí ra xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ta o̱n ko̱ó naxíka xíꞌin ta̱Jesús, chi kua̱ꞌa̱n na ñii ñoo yatin ña sata na ña kuxu na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ta nda̱kuii̱n ñáñaꞌa̱, ni̱ka̱ꞌa̱n ñá saá xíꞌin ta̱Jesús: ―Yóꞌó kúu ta̱judío ta yi̱ꞌi̱ kúu ñii ñaꞌa̱ ñáñoo Samaria. ¿Nda̱chun ndúkú ún no̱o̱ yi̱ꞌi̱ taxi i̱ takuií koꞌo ún? ―káchí ñá. (Saá chi najudío o̱n vása nátaꞌan va̱ꞌa na xíꞌin nañoo Samaria.) ");
INSERT INTO mim_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ta saá nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ñá: ―Tá xíni̱ ví ún ñava̱ꞌa ña kóni Ndios taxi ra ndaꞌa̱ ún, ta tá xíni̱ ví ún yu kúu yi̱ꞌi̱, ta saá ndukú ún no̱o̱ i̱ takuií koꞌo ún, ta yi̱ꞌi̱ taxi i̱ rá ndaꞌa̱ ún. Ta takuií tá taxi i̱ ndaꞌa̱ ún kúu takuií tá kómí ndee̱ ña taxi rá kutaku̱ ndinoꞌo ni̱vi ―káchí ta̱Jesús xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ta nda̱kuii̱n ñáñaꞌa̱ yóꞌo, ni̱ka̱ꞌa̱n ñá, káchí ñá saá: ―Tata, o̱n vása níꞌi ún nda̱ ñii ña kuchiño tava ún takuií, ta kónó ní ñóꞌo rá pozo yóꞌo. Ta saá, ¿míkía̱ va̱xi takuií tá káꞌa̱n ún xa̱ꞌa̱? ");
INSERT INTO mim_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Án káꞌno ka̱ ndee̱ kómí ún no̱o̱ ndee̱ ña xi̱komí xi̱i̱ síkuá yó ta̱Jacob?, chi ta̱Jacob sa̱ndakoo ra pozo yóꞌo xa̱ꞌa̱ ndi̱, na kúu sa̱ꞌya ñani síkuá ra, chi ta̱yóꞌo xíꞌin sa̱ꞌya ra xi̱ꞌi na takuií pozo yóꞌo kui̱ya̱ xi̱na̱ꞌá, ta ñii ki̱ꞌva saá xi̱ꞌi kiti̱ sa̱na̱ ndiꞌi na ―káchí ñá xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ta ta̱Jesús nda̱kuii̱n ra ni̱ka̱ꞌa̱n ra xíꞌin ñá: ―Ndiꞌi ni̱vi na xíꞌi takuií pozo yóꞌo, ñii káni̱ loꞌo yáꞌa, ta tuku yi̱chi̱ na takuií. ");
INSERT INTO mim_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ta ndiꞌi ni̱vi na koꞌo takuií tá taxi i̱ ndaꞌa̱ na, nayóꞌo nda̱ ñii ki̱vi̱ o̱n yi̱chi̱ ka̱ na takuií. Saá chi takuií tá taxi i̱ koꞌo ni̱vi nduu rá ñii pozo káꞌno ní ini na, ta nda̱ ñii ki̱vi̱ o̱n ndoko takuií yóꞌo. Ta ni̱vi na koꞌo takuií tá taxi i̱ o̱n kivi̱ na, chi takuií tá taxi i̱ kómí rá ndee̱ ña taxi rá kutaku̱ ndinoꞌo ni̱vi ndiꞌi saá ki̱vi̱ ña va̱xi ―káchí ta̱Jesús xíꞌin ñáñoo Samaria. ");
INSERT INTO mim_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ta nda̱kuii̱n ñá káchí ñá saá: ―Tata, taxi ún ndaꞌa̱ i̱ takuií tá káꞌa̱n ún xa̱ꞌa̱ ná koꞌo i̱. Ta saá o̱n yi̱chi̱ ka̱ i̱ takuií nda̱ ñii ki̱vi̱, ta ni o̱n kuikó ka̱ i̱ takuií ndiꞌi saá ki̱vi̱ ―káchí ñá xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ta tuku nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ñá: ―Kua̱ꞌa̱n ún kana ún yii̱ ún, ña kixaa̱ ra xíꞌin ún yóꞌo ―káchí ra xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ta nda̱kuii̱n ñá, ni̱ka̱ꞌa̱n ñá xíꞌin ra: ―O̱n ko̱ó yii̱ i̱ kómí i̱, tata ―káchí ñá. Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ñá: ―Ñandixa kúu ña káꞌa̱n ún ndí o̱n ko̱ó yii̱ ún, nana, ");
INSERT INTO mim_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","chi xa o̱ꞌo̱n ta̱a xi̱kuu yii̱ ún, ta ta̱a ta̱ yóo xíꞌin ún vitin o̱n si̱ví yii̱ ún kúu ra. Ñandixa kúu ña káꞌa̱n ún ndí o̱n ko̱ó yii̱ ún kómí ún, nana ―káchí ta̱Jesús xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ta nda̱kuii̱n tuku ñá ni̱ka̱ꞌa̱n ñá: ―Tata, vitin kúnda̱a̱ ini i̱ ndí yóꞌó kúu ñii ta̱profeta. ");
INSERT INTO mim_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ta vitin, tata, ¿yukía̱ káchí ún?, chi yuku̱ káꞌno xíto yó kaa̱ kúu xiiña no̱o̱ ni̱vi naxi̱i̱ síkuá ndi̱ ki̱sa káꞌno na Ndios, ta ndóꞌó najudío káchí ndó xíni̱ ñóꞌó kasa káꞌno yó Ndios veꞌe ño̱ꞌo káꞌno ñoo Jerusalén ―káchí ñá xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ñá, káchí ra saá: ―Kandixa ún ña ndato̱ꞌon i̱ xíꞌin ún vitin, nana. Xa yatin va̱xi ki̱vi̱ ña o̱n koni̱ ñóꞌó ka̱ ko̱ꞌo̱n ni̱vi yuku̱ kaa̱, ni o̱n koni̱ ñóꞌó ka̱ ko̱ꞌo̱n na veꞌe ño̱ꞌo káꞌno ñoo Jerusalén xa̱ꞌa̱ ña kasa káꞌno na Ndios. ");
INSERT INTO mim_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Vitin ndóꞌó, ni̱vi nañoo Samaria, xíꞌin ñanaa ini ndó kísa káꞌno ndó Ndios, chi o̱n ta̱ꞌán kunda̱a̱ ini ndó xa̱ꞌa̱ ra. Ta mi̱i ndi̱ najudío xíni̱ ndi̱ yu kúu Ndios ta̱a ta̱ kísa káꞌno ndi̱, chi Ndios chi̱tóni̱ ra ndí ti̱xin nañoo judío kixi ñii ta̱a ta̱ saka̱ku ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Xa yatin ní va̱xi ki̱vi̱, ta xa vitin kúu ki̱vi̱ ña ni̱vi na kúu na ndixa kasa káꞌno Yivá i̱ Ndios, nayóꞌo xíni̱ ñóꞌó kasa káꞌno na ra xíꞌin ña ndinoꞌo níma̱ na, ta xíꞌin ña xíni̱ na to̱ꞌon ndixa xa̱ꞌa̱ ra. Saá chi Yivá i̱ nándukú ra ni̱vi ña kasa káꞌno na ra saá. ");
INSERT INTO mim_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ndios kúu Níma̱ ndinoꞌo, ta saá ni̱vi xíni̱ ñóꞌó ña koo Níma̱ Ndios ini na ña kuchiño va̱ꞌa kasa káꞌno na ra, ta xíꞌin ña ndinoꞌo nda̱a̱ ini na xíni̱ ñóꞌó kasa káꞌno na ra. ");
INSERT INTO mim_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ta nda̱kuii̱n ñá, ni̱ka̱ꞌa̱n ñá, káchí ñá saá: ―Xíni̱ i̱ ndí ñii ki̱vi̱ kixaa̱ ta̱Mesías, ta̱a ta̱ tiꞌví Ndios saka̱ku ra mi̱i yó. Ta ta̱yóꞌo tuku sákunaní na ra Cristo. Ta ki̱vi̱ kixaa̱ ta̱yóꞌo, ta sanáꞌa ra mi̱i yó ña nandaxin ra ndiꞌi ña xíni̱ ñóꞌó kunda̱a̱ ini yó ―káchí ñá xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ta nda̱kuii̱n ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ñá: ―Yi̱ꞌi̱, ta̱a ta̱ káꞌa̱n xíꞌin ún, kúu ta̱a ta̱ káꞌa̱n ún xa̱ꞌa̱ ―káchí ra xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ta saá ki̱xaa̱ naxíka xíꞌin ta̱Jesús, ta na̱kaꞌnda ini na xi̱ni na ña káꞌa̱n ra xíꞌin ñii ñaꞌa̱. Ta nda̱ ñii nayóꞌo ni̱‑kaꞌa̱n na xíꞌin ra yu kúu ña ndáka̱ to̱ꞌon ra ñá, án yu kúu ña ndáto̱ꞌon ra xíꞌin ñáñaꞌa̱ yóꞌo. Tási̱ín kuiti yíta na. ");
INSERT INTO mim_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ta saá ñáñaꞌa̱ ñoo Samaria sa̱ndakoo ñá ki̱si ña xíni̱ ñóꞌó ñá xíkó ñá takuií no̱o̱ yóo pozo yóꞌo, ta ndi̱kó ñá kua̱noꞌo̱ ñá ñoo ñá. Tá na̱xaa̱ ñá, ta ni̱ka̱ꞌa̱n ñá xíꞌin nani̱vi ñoo ñá, káchí ñá saá xíꞌin na: ");
INSERT INTO mim_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Naꞌa ndó koto ndó ñii ta̱a ta̱ ni̱ka̱ꞌa̱n xíꞌin i̱ xa̱ꞌa̱ ndiꞌi ña ke̱ꞌé i̱. ¿Án o̱n si̱ví Cristo kúu ta̱yóꞌo? ―káchí ñá xíꞌin ni̱vi ñoo ñá. ");
INSERT INTO mim_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ta saá ke̱e nayóꞌo ña kua̱ꞌa̱n na no̱o̱ yóo ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ta o̱n ta̱ꞌán ka̱ kixaa̱ ñáñaꞌa̱ yóꞌo xíꞌin ni̱vi no̱o̱ yóo ta̱Jesús, ta naxíka xíꞌin ta̱Jesús xa̱ku ndáꞌví na no̱o̱ ra, káchí na xíꞌin ra saá: ―Tata Rabí, naꞌa kuxu ún ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Yóo ñaxíxi kómí yi̱ꞌi̱, ta ndóꞌó o̱n vása xíni̱ ndó yu kúu ña ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ta naxíka xíꞌin ra káꞌa̱n na xíꞌin táꞌan na, káchí na saá: ―¿Án xa ki̱xi ni̱vi ta̱xi na xi̱xi ra? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―Ñaxíxi ndinoꞌo kúu ña kasa ndivi i̱ ta saxi̱no̱ i̱ ña kóni Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yóo to̱ꞌon ña káꞌa̱n saá: “Tá chíꞌi yó ndiki̱n trigo, ta ndáti yó yaꞌa ko̱mi̱ yo̱o̱, ta saá nákaya yó yoko̱ trigo ña nakiꞌin yó ndiki̱n ña”, káchí to̱ꞌon ña xíni̱ yó. Ta saá ni, o̱n vása xíni̱ ñóꞌó kundati ka̱ yó, ta vitin ná kixáꞌá yó nakaya yó ña xa ni̱xi̱no̱. Saá chi vitin koto ndó kaa̱, kua̱ꞌa̱ ní ni̱vi va̱xi. Ta nda̱tán yóo kua̱ꞌa̱ ní yoko̱ trigo ña xa ni̱xi̱no̱, ta xa yóo tiꞌva ña nakaya yó ña, saá yóo ni̱vi na va̱xi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ta ndixa Ndios chaꞌvi ra ndóꞌó na kúu na nakaya ni̱vi yóꞌo ña ki̱ꞌvi na yichi̱ ra. Ta inka̱ ni̱vi siꞌna chi̱ꞌi na to̱ꞌon Ndios ini nayóꞌo, ta saá na chi̱ꞌi yóꞌo kusii̱ ní ini na xíꞌin ndó xa̱ꞌa̱ ña ki̱ꞌvi ni̱vi yichi̱ Ndios ta kutaku̱ na xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yóo inka̱ to̱ꞌon káchí saá: “Yóo ni̱vi na chíꞌi, ta inka̱ kúu ni̱vi na nákaya ña xa ni̱xi̱no̱”, káchí to̱ꞌon ña xíni̱ yó. Ta ñanda̱a̱ kúu ña káꞌa̱n to̱ꞌon yóꞌo, ");
INSERT INTO mim_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","chi nda̱tán yóo ni̱vi na chi̱ꞌi, saá yóo ni̱vi na siꞌna ni̱ka̱ꞌa̱n to̱ꞌon Ndios xíꞌin nañoo Samaria yóꞌo. Ta ndóꞌó, nda̱tán yóo ni̱vi na ki̱xáꞌá nakaya ña xa ni̱xi̱no̱ no̱o̱ chi̱ꞌi inka̱ ni̱vi, saá yóo ndóꞌó. Saá chi inka̱ ni̱vi xa ndeé ní ki̱sa chiño na xíꞌin nayóꞌo, ta ña̱kán kía̱ xa yóo tiꞌva na vitin ña ki̱ꞌvi na yichi̱ Ndios. Ta ndóꞌó, o̱n vása ní‑kisa chiño ndó xíꞌin nayóꞌo, ta yi̱ꞌi̱ ti̱ꞌví i̱ ndóꞌó ña nakaya ndó ni̱vi yóꞌo ña ki̱ꞌvi na yichi̱ Ndios. Xíni̱ ñóꞌó kunda̱a̱ ini ndó ndí inka̱ ni̱vi kúu na ndeé ní ki̱sa chiño, ta ndóꞌó vitin nakiꞌin ndó yaꞌvi xa̱ꞌa̱ chiño nayóꞌo ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kua̱ꞌa̱ ní ni̱vi naSamaria, na kúu na táku̱ ñoo yóꞌo, ka̱ndixa na ta̱Jesús chi chi̱kaa̱ so̱ꞌo na to̱ꞌon ña nda̱to̱ꞌon ñáñaꞌa̱ ñoo mi̱i na xíꞌin na, káchí ñá saá: “Ta̱yóꞌo nda̱to̱ꞌon káxín ra xíꞌin i̱ xa̱ꞌa̱ ndiꞌi ña ke̱ꞌé i̱”, káchí ñá xíꞌin ni̱vi nañoo ñá. ");
INSERT INTO mim_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ta saá ki̱xaa̱ nañoo Samaria yóꞌo no̱o̱ ta̱Jesús, ta xa̱ku ndáꞌví na no̱o̱ ra ña ná ndo̱o ra xíꞌin na ñoo na, ta ta̱Jesús ni̱xi̱yo ra o̱vi̱ ki̱vi̱ ñoo nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ta saá kua̱ꞌa̱ ní ka̱ ni̱vi ka̱ndixa na ta̱Jesús chi chi̱kaa̱ so̱ꞌo na to̱ꞌon ña ni̱ka̱ꞌa̱n ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ta ni̱ka̱ꞌa̱n na xíꞌin ñaꞌa̱ ñáñoo mi̱i na yóꞌo, káchí na saá: ―Siꞌna ka̱ndixa ndi̱ ra xa̱ꞌa̱ to̱ꞌon ña nda̱to̱ꞌon ún xa̱ꞌa̱ ra. Ta vitin kándixa va̱ꞌa ndi̱ ra chi xi̱ni̱ so̱ꞌo ndi̱ to̱ꞌon ña ni̱ka̱ꞌa̱n mi̱i ra, ta kúnda̱a̱ ini ndi̱ ndí ndixa ta̱yóꞌo kúu Cristo, Ta̱a ta̱ Saka̱ku ni̱vi ñoyívi yóꞌo ―káchí na xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tá ni̱yaꞌa o̱vi̱ ki̱vi̱ ni̱xi̱yo ta̱Jesús ñoo Samaria, ta saá ke̱e ra kua̱noꞌo̱ ra ñoo estado Galilea. ");
INSERT INTO mim_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ta ta̱Jesús xa ni̱ka̱ꞌa̱n ra ndí nda̱ ñii ta̱profeta o̱n vása kísa to̱ꞌó na ra ñoo mi̱i ra. ");
INSERT INTO mim_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ta saá ni, ki̱vi̱ na̱xaa̱ ta̱Jesús ñoo estado Galilea, ta nani̱vi ñoo yóꞌo va̱ꞌa ní na̱kiꞌin na ra. Kua̱ꞌa̱ ní ni̱vi na estado Galilea yóꞌo ni̱xi̱yo na ñoo Jerusalén ki̱vi̱ ka̱na viko̱ Pascua, ta xa xi̱ni na ndiꞌi ñava̱ꞌa ke̱ꞌé ta̱Jesús xíꞌin ni̱vi ñoo Jerusalén yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ta saá ta̱Jesús ke̱e tuku ra kua̱ꞌa̱n ra ñoo Caná ña nákaa̱ estado Galilea, ta ki̱xaa̱ ta̱Jesús ñoo yóꞌo. Ta ñoo Caná yóꞌo kúu no̱o̱ ke̱ꞌé ta̱Jesús ña takuií ndu̱u rá vino. Ta yóo ñii ta̱a ta̱ ki̱xi ñoo Capernaum, ta kúu ra ta̱chiño káꞌno ta̱ kísa chiño no̱o̱ ta̱rey, ta ndeé ní ndóꞌo sa̱ꞌya ra ta̱ kándúꞌu̱ nda̱ ñoo Capernaum. ");
INSERT INTO mim_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tá xi̱ni̱ so̱ꞌo ta̱chiño káꞌno yóꞌo ndí ki̱xaa̱ tuku ta̱Jesús ñoo Caná, chi ke̱e ra estado Judea, ta saá kua̱ꞌa̱n ra ta ni̱xaa̱ ra xa̱ku ndáꞌví ra no̱o̱ ta̱Jesús ña ko̱ꞌo̱n ta̱yóꞌo xíꞌin ra ña sandaꞌa ra ta̱loꞌo sa̱ꞌya ra, ta̱ ndeé ní ndóꞌo, ta xa nda̱ yóo ña kivi̱ ta̱loꞌo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ta nda̱kuii̱n ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ra, káchí ra saá: ―Ndóꞌó, o̱n xi̱in ndó kandixa ndó yi̱ꞌi̱. Ta̱nda̱ keꞌé i̱ milagro koni ndó, án nda̱ keꞌé i̱ ñava̱ꞌa ña nakaꞌnda ini ndó koni ndó, ta̱nda̱ saá kixáꞌá ndó kandixa ndó yi̱ꞌi̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ta nda̱kuii̱n ta̱chiño káꞌno ta̱ kísa chiño no̱o̱ ta̱rey, káchí ra saá: ―Tata, kama ní ko̱ꞌo̱n ún xíꞌin i̱ ko̱to̱ kivi̱ ta̱loꞌo sa̱ꞌya i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Va̱ꞌa, tata, kua̱noꞌo̱ ún vitin, chi ta̱loꞌo sa̱ꞌya ún o̱n kivi̱ ra, kutaku̱ ka̱ ra ―káchí ta̱Jesús xíꞌin ta̱káꞌno yóꞌo. Ta ta̱yóꞌo ndixa ka̱ndixa ra to̱ꞌon ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra, ta ke̱e ra kua̱noꞌo̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tá kua̱ꞌa̱n ra yichi̱ no̱o̱ kua̱noꞌo̱ ra, ta na̱kutáꞌan ra xíꞌin sava na kísa chiño no̱o̱ ra va̱xi na. Ta nayóꞌo ni̱ka̱ꞌa̱n na xíꞌin ta̱káꞌno no̱o̱ na, káchí na saá: ―Tata, táku̱ ta̱loꞌo sa̱ꞌya ún, xa ndu̱va̱ꞌa ra vitin ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ta ni̱nda̱ka̱ to̱ꞌon ta̱káꞌno no̱o̱ na, káchí ra saá xíꞌin na: ―¿Ama ki̱xáꞌá saña kue̱ꞌe̱ xíꞌin ta̱loꞌo sa̱ꞌya i̱? ―káchí ra. Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na: ―Tá ni̱to̱nda̱a ka̱a ñii xikuaa ki̱vi̱ koni kúu ña sa̱ña kue̱ꞌe̱ kaꞌni̱ xíꞌin ra ―káchí na xíꞌin ta̱káꞌno no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ta saá ta̱káꞌno yóꞌo na̱káꞌán ra ndí mi̱i hora yóꞌo kúu ña ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra ndí o̱n kivi̱ sa̱ꞌya ra. Ta saá ta̱chiño káꞌno yóꞌo xíꞌin ndiꞌi naveꞌe ra ka̱ndixa na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ñayóꞌo kúu milagro ñao̱vi̱ ke̱ꞌé ta̱Jesús ñoo estado Galilea, ta ke̱ꞌé ra ñava̱ꞌa yóꞌo ki̱vi̱ ndi̱kó ra ki̱xaa̱ ra, ña ni̱xa̱ꞌa̱n ra ñoo Judea. ");
INSERT INTO mim_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tá ndi̱ꞌi ñayóꞌo, ta saá ke̱e ta̱Jesús estado Galilea, ta kua̱ꞌa̱n ra ñoo Jerusalén no̱o̱ koo ñii viko̱ káꞌno ña sakana najudío. ");
INSERT INTO mim_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ta ñoo Jerusalén yóꞌo nákaa̱ veꞌe ño̱ꞌo káꞌno, ta veꞌe ño̱ꞌo káꞌno yóꞌo xi̱no nduu ña xíꞌin ñii na̱ma̱ káꞌno, ta ñii yéꞌé ña kómí na̱ma̱ yóꞌo na̱ní ña Yéꞌé Ndikachi. Ta yatin yéꞌé yóꞌo yóo ñii pozo káꞌno, ta to̱ꞌon hebreo na̱ní pozo yóꞌo Betesda. Ta yuꞌu̱ pozo yóꞌo xi̱no nduu ña xíꞌin o̱ꞌo̱n tia̱ꞌva ña o̱n vása ndási̱ xa̱ꞌa̱. ");
INSERT INTO mim_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ta ndiꞌi saá ki̱vi̱ kua̱ꞌa̱ ní ni̱vi na ndeé ndóꞌo ndóo na ini tia̱ꞌva yóꞌo. Nayóꞌo kúu ni̱vi nakuáá xíꞌin ni̱vi na yo̱ꞌvi̱ ní xíka, xíꞌin ni̱vi na o̱n ki̱ví kanda. Ta nayóꞌo yóo na ndáti na kixáꞌá kanda takuií pozo, chi kóni na ki̱ꞌvi na ini takuií yóꞌo xa̱ꞌa̱ ña nduva̱ꞌa na no̱o̱ kue̱ꞌe̱ ndóꞌo na. ");
INSERT INTO mim_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Saá chi nda̱ ama ví yóo ki̱vi̱ ña ñii ñaángel ña ke̱e no̱o̱ Ndios nóo ña, ta kíxaa̱ ña sákanda ña takuií pozo yóꞌo. Ta saá ndiꞌi ni̱vi na ndeé ndóꞌo nákundeé na ña xaa̱ na no̱o̱ yóo pozo, ta ñii ni̱vi na siꞌna kúchiño noo nda̱ yuꞌu̱ takuií ta kíꞌvi na ini takuií pozo, ta xa̱ndi̱ko̱n ndúva̱ꞌa ni̱vi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ta ini ñii tia̱ꞌva ña xi̱no nduu pozo yóꞌo, kándúꞌu̱ ñii ta̱a ta̱ ndeé ndóꞌo, chi o̱n ki̱ví kanda xa̱ꞌa̱ ra. Ta xa o̱ko̱ xa̱ꞌo̱n u̱ni̱ kui̱ya̱ yóo ña o̱n vása kúchiño kaka ra. ");
INSERT INTO mim_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ta saá ki̱xaa̱ ta̱Jesús, ta xi̱ni ra ta̱ kándúꞌu̱ yóꞌo. Ta nda̱to̱ꞌon na xíꞌin ta̱Jesús ndí xa naꞌá ní ndeé ndóꞌo ta̱yóꞌo. Ta saá ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra ta̱ ndeé ndóꞌo yóꞌo, káchí ra saá xíꞌin ra: ―¿Án kóni ún nduva̱ꞌa ún no̱o̱ kue̱ꞌe̱ ndóꞌo ún? ");
INSERT INTO mim_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ta nda̱kuii̱n ta̱ kándúꞌu̱, ni̱ka̱ꞌa̱n ra: ―Tata, o̱n ko̱ó nda̱ ñii ni̱vi chindeé yi̱ꞌi̱ ña kuchiño ki̱ꞌvi i̱ ini takuií. Saá chi ki̱vi̱ kíxaa̱ ñaángel sákanda ña takuií, ta yi̱ꞌi̱ ndúkú ndeé i̱ ki̱ꞌvi i̱ ini takuií, ta o̱n ta̱ꞌán ka̱ xaa̱ i̱, ta inka̱ ni̱vi ya̱chi̱ ka̱ kíꞌvi na ini takuií no̱o̱ i̱ ―káchí ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Ta vitin nakundichi ún ta ná kuiso ún xi̱to ún, ta xa va̱ꞌa kaka xáꞌá ún ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ta saá xa̱ndi̱ko̱n ndu̱va̱ꞌa ta̱yóꞌo, ta na̱kundichi ra, ta na̱kuso̱kó ra xi̱to ra, ta ki̱xáꞌá ra kua̱ꞌa̱n xáꞌá ra. Ta ñii ki̱vi̱ yi̱i̱ ña nákindée najudío kúu ki̱vi̱ ña sa̱ndaꞌa ta̱Jesús ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tá nanáꞌno no̱o̱ najudío na̱kutáꞌan na xíꞌin ta̱a ta̱ nda̱ꞌa yóꞌo, ta ni̱ka̱ꞌa̱n na xíꞌin ra káchí na saá: ―Vitin kúu ki̱vi̱ yi̱i̱ ña nákindée yó, ta ni̱yaꞌa ndoso ún nda̱yí xa̱ꞌa̱ ki̱vi̱ yi̱i̱ yóꞌo, chi ñíso̱kó ún xi̱to ún xíka ún ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ta nda̱kuii̱n ta̱a ta̱ ndu̱va̱ꞌa yóꞌo, ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―Ta̱a ta̱ sa̱ndaꞌa yi̱ꞌi̱ ni̱ka̱ꞌa̱n ra xíꞌin i̱: “Ná kuiso ún xi̱to ún ta va̱ꞌa ko̱ꞌo̱n xáꞌá ún”, káchí ra xíꞌin i̱ ―saá káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ta ni̱nda̱ka̱ to̱ꞌon na ra: ―¿Yu kúu ta̱a ta̱ ni̱ka̱ꞌa̱n xíꞌin ún ndí ndaníꞌi ún xi̱to ún ta va̱ꞌa ko̱ꞌo̱n xáꞌá ún? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ta ta̱a ta̱ ndu̱va̱ꞌa yóꞌo o̱n vása xíni̱ ra yu kúu ta̱a ta̱ sa̱ndaꞌa ñaꞌá, chi kama ní ni̱yaꞌa ta̱Jesús ma̱ꞌñó no̱o̱ chútú ni̱vi, ta kua̱ꞌa̱n ra inka̱ xiiña. ");
INSERT INTO mim_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ta ni̱yaꞌa loꞌo, ta saá ta̱Jesús na̱kutáꞌan ra xíꞌin ta̱a ta̱ ndu̱va̱ꞌa yóꞌo ini veꞌe ño̱ꞌo káꞌno, ta ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Koto ún, vitin xa ndu̱va̱ꞌa ún, ta saá o̱n ki̱ꞌvi ka̱ ún kua̱chi, chi ko̱to̱ kixaa̱ inka̱ ña ndeé ní ka̱ kundoꞌo ún ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ta saá ta̱a ta̱ ndu̱va̱ꞌa yóꞌo ke̱e ra kua̱ꞌa̱n ra, ta ni̱xaa̱ ra nda̱to̱ꞌon ra xíꞌin nanáꞌno no̱o̱ najudío, káchí ra saá: ―Ta̱Jesús kúu ta̱a ta̱ sa̱ndúva̱ꞌa yi̱ꞌi̱ ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ta saá nanáꞌno no̱o̱ najudío ki̱xáꞌá na sáa̱ ní ini na, ta ndu̱kú na ndiꞌi no̱o̱ ña o̱n váꞌa ña kúchiño keꞌé na xíꞌin ta̱Jesús, ta̱nda̱ to̱nda̱a na ña kaꞌni na ra, kóni na. Saá chi ki̱vi̱ yi̱i̱ ña nákindée najudío kúu ki̱vi̱ ña ta̱Jesús sa̱ndúva̱ꞌa ra ta̱yóꞌo, ta káchí na ndí ta̱Jesús ni̱yaꞌa ndoso ra nda̱yí chi ki̱sa chiño ra ki̱vi̱ yi̱i̱, káchí na. ");
INSERT INTO mim_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ta saá ta̱Jesús na̱kutáꞌan ra xíꞌin nanáꞌno yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―Ndiꞌi saá ki̱vi̱ kísa chiño Yivá i̱ Ndios, ña̱kán ndiꞌi saá ki̱vi̱ kísa chiño i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ta saá nanáꞌno no̱o̱ najudío ni̱saa̱ ka̱ na, ta ndeé ka̱ ndúkú na kaꞌni na ta̱Jesús, chi xáni si̱ni̱ na ndí ni̱ki̱ꞌvi ra o̱vi̱ kua̱chi ndeé ní. Xáni si̱ni̱ na ndí ni̱yaꞌa ndoso ra nda̱yí xa̱ꞌa̱ ki̱vi̱ yi̱i̱, ta inka̱ kua̱chi ra kúu ña káꞌa̱n ra ndí Ndios kúu Yivá ra, ña kóni kachí ñii kúu ra xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, káchí ra saá: ―Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó ndí o̱n ko̱ó nda̱ ñii chiño kéꞌé i̱ xíꞌin nda̱yí mi̱i i̱, chi Yivá i̱ Ndios kúu ta̱a ta̱ táxi nda̱yí ndaꞌa̱ i̱ keꞌé i̱ ndiꞌi chiño, ta ndasaá kuiti kéꞌé i̱ chiño ña xíni i̱ kéꞌé Yivá i̱. Ta ñii ki̱ꞌva nda̱tán kéꞌé Yivá i̱, saá kéꞌé yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya ra. ");
INSERT INTO mim_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Saá chi kíꞌvi ní ini Yivá i̱ xíni ra yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya ra, ña̱kán sánáꞌa ra yi̱ꞌi̱ keꞌé i̱ ndiꞌi no̱o̱ ñava̱ꞌa, nda̱tán yóo ña kéꞌé mi̱i ra. Ta ndixa sanáꞌa ra yi̱ꞌi̱ keꞌé i̱ ñava̱ꞌa náꞌno ka̱ no̱o̱ ñayóꞌo, ta̱nda̱ nakaꞌnda ní ini ndó koni ndó ña keꞌé i̱. ");
INSERT INTO mim_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Saá chi nda̱tán Yivá i̱ Ndios sanataku̱ ra ni̱vi na ni̱xiꞌi̱, saá yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya ra, taxi i̱ ña kutaku̱ ndinoꞌo ndiꞌi ni̱vi na kúu na kóni i̱ keꞌé i̱ saá xíꞌin. ");
INSERT INTO mim_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yivá i̱ Ndios o̱n vása kísa nani ra kua̱chi nda̱ ñii ni̱vi, ta ndaꞌa̱ yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya ra, ta̱xi ra nda̱yí ña kasa nani i̱ ndiꞌi kua̱chi ni̱vi, ");
INSERT INTO mim_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","chi Ndios kóni ra ndí ndiꞌi ni̱vi ná kasa to̱ꞌó na Sa̱ꞌya ra, nda̱tán ñii ki̱ꞌva kísa to̱ꞌó na mi̱i ra. Ta ndiꞌi ni̱vi na o̱n xi̱in kasa to̱ꞌó yi̱ꞌi̱, nayóꞌo o̱n vása kísa to̱ꞌó na Yivá i̱ Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó ndí ndiꞌi ni̱vi na chíkaa̱ so̱ꞌo to̱ꞌon káꞌa̱n i̱, ta kándixa na Yivá i̱ Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱, ta nayóꞌo kúu ni̱vi na ndinoꞌo táku̱, ta kutaku̱ na ndiꞌi saá ki̱vi̱ ña va̱xi. Saá chi ni̱vi yóꞌo sa̱ndakoo va̱ꞌa na ña kua̱ꞌa̱n na yichi̱ no̱o̱ ndiꞌi xa̱ꞌa̱ na, ta vitin kua̱ꞌa̱n na yichi̱ Ndios no̱o̱ táku̱ ndinoꞌo na ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó ndí ni̱vi na o̱n ta̱ꞌán kukomí Níma̱ Ndios, nda̱tán yóo na ni̱xiꞌi̱, saá yóo nayóꞌo. Ta̱nda̱ ki̱vi̱ vitin ta̱nda̱ ki̱vi̱ va̱xi ni̱vi yóꞌo koni̱ so̱ꞌo na to̱ꞌon ña ka̱ꞌa̱n yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya Ndios. Ta ndiꞌi ni̱vi na chikaa̱ so̱ꞌo to̱ꞌon i̱, nduu na ni̱vi na kutaku̱ ndinoꞌo. Ta vitin xa ki̱xaa̱ ki̱vi̱ ña kundivi ndiꞌi ñayóꞌo saá. ");
INSERT INTO mim_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yivá i̱ Ndios kúu ta̱a ta̱táku̱ ndinoꞌo, ta ndiꞌi ndee̱ ña táxi kutaku̱ ni̱vi, káku ña ini Ndios. Ta ñii ki̱ꞌva saá yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya Ndios, kúu ta̱a ta̱táku̱ ndinoꞌo, ta ndiꞌi ndee̱ ña táxi kutaku̱ ni̱vi, káku ña ini i̱, chi saá ta̱xi Ndios nda̱yí ndaꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ta saá tuku ta̱xi Ndios nda̱yí ndaꞌa̱ i̱ ña kasa nani i̱ kua̱chi ni̱vi, chi yi̱ꞌi̱ kúu ta̱a ta̱ ki̱xi no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","O̱n nakaꞌnda ini ndó ña xi̱ni̱ so̱ꞌo ndó to̱ꞌon ña xa ni̱ka̱ꞌa̱n i̱ xíꞌin ndó vitin, chi va̱xi ki̱vi̱ ni̱vi na ni̱xiꞌi̱ ta ni̱ndu̱xu̱n na, nayóꞌo koni̱ so̱ꞌo na to̱ꞌon i̱, ");
INSERT INTO mim_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ta nataku̱ na, ta ndakoo na, ta sandakoo na ñáñá no̱o̱ ni̱ndu̱xu̱n na. Ta ni̱vi na ni̱xiꞌi̱ ta nataku̱ yóꞌo, tá xi̱kuu na ni̱vi na ke̱ꞌé ñava̱ꞌa, ta nayóꞌo kutaku̱ na xíꞌin Ndios. Ta tá xi̱kuu na ni̱vi na ke̱ꞌé ña o̱n váꞌa, ta nayóꞌo ko̱ꞌo̱n na no̱o̱ xo̱ꞌvi̱ ní na ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ta ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na, káchí ra saá: ―O̱n si̱ví xíꞌin nda̱yí mi̱i i̱ kasa nani i̱ kua̱chi ni̱vi, ta xíꞌin nda̱yí ña ta̱xi Ndios ndaꞌa̱ i̱ kúu ña kasa nani i̱ kua̱chi ni̱vi. Ñii ki̱ꞌva nda̱tán káꞌa̱n Ndios xíꞌin i̱, saá kasa nani i̱ kua̱chi ni̱vi. Ta xíꞌin ñanda̱a̱ kasa nani i̱ kua̱chi na, chi o̱n si̱ví xíꞌin ña kóni mi̱i i̱ kúu ña kasa nani i̱ kua̱chi ni̱vi, ta kasa nani i̱ xa̱ꞌa̱ kua̱chi na nda̱tán kóni Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tá ndasaá kuiti mi̱i i̱ kuu ta̱ ndakuii̱n xa̱ꞌa̱ i̱, ta saá o̱n vása ndáya̱ꞌví ña káꞌa̱n i̱ no̱o̱ ñii ta̱juez, vará to̱ꞌon ña nda̱a̱ kúu ña káꞌa̱n i̱. ");
INSERT INTO mim_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ta ndixa yóo inka̱ ta̱a ta̱ ndákuii̱n xa̱ꞌa̱ i̱, ta yi̱ꞌi̱ xíni̱ i̱ ndí ta̱yóꞌo káꞌa̱n ra ñanda̱a̱ xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ta ndóꞌó, xa ti̱ꞌví ndó na xíka chiño no̱o̱ ndó kua̱ꞌa̱n na no̱o̱ ta̱Juan, ta̱a ta̱ sákuchu ni̱vi, ta ni̱nda̱ka̱ to̱ꞌon na ra xa̱ꞌa̱ i̱. Ta ta̱yóꞌo nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra ñanda̱a̱ xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ta yi̱ꞌi̱, o̱n vása xíni̱ ñóꞌó i̱ ni̱vi ña ndakuii̱n na xa̱ꞌa̱ i̱. Ta saá ni, káꞌa̱n i̱ xíꞌin ndó xa̱ꞌa̱ ta̱Juan, chi kóni i̱ ña kandixa ndó to̱ꞌon ña nda̱a̱ ni̱ka̱ꞌa̱n ra xa̱ꞌa̱ i̱. Ta saá Ndios kuchiño saka̱ku ra ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ta nda̱tán yóo ñoꞌo̱ loꞌo ña ndeé ní yéꞌe, saá ni̱xi̱yo ta̱Juan. Ta ñii káni̱ loꞌo ku̱too ní ndó xíni ndó ñoꞌo̱ ña yéꞌe yóꞌo, chi sánáꞌa ña ndóꞌó yichi̱ ña nda̱a̱. ");
INSERT INTO mim_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ta yóo inka̱ ña ndákuii̱n xa̱ꞌa̱ i̱, ta ña káꞌno ka̱ ndáya̱ꞌví no̱o̱ to̱ꞌon ña ni̱ka̱ꞌa̱n ta̱Juan kúu ñayóꞌo. Saá chi chiño ña sa̱kuiso Ndios yi̱ꞌi̱ ña kasa ndivi i̱, chiño yóꞌo kúu ña ndákuii̱n xa̱ꞌa̱ i̱, chi chiño ña kísa ndivi i̱ sánáꞌa káxín ña no̱o̱ ndóꞌó ndí Yivá i̱ Ndios kúu ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ kasa ndivi i̱ ña kóni ra. ");
INSERT INTO mim_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ta mi̱i Ndios ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ kúu inka̱ ta̱ ndákuii̱n xa̱ꞌa̱ i̱. Ta ndóꞌó, o̱n ta̱ꞌán koni̱ so̱ꞌo ndó to̱ꞌon ra, ta ni o̱n vása xíni ndó ndasaá káa ra, ");
INSERT INTO mim_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ta ni o̱n vása nákaa̱ to̱ꞌon ra níma̱ ndó. Saá chi o̱n xi̱in ndó kandixa ndó yi̱ꞌi̱, ta̱a ta̱ ti̱ꞌví Ndios. ");
INSERT INTO mim_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ndiꞌi saá ki̱vi̱ ndeé ní sákuáꞌá ndó ta káꞌvi ndó to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá, chi xáni si̱ni̱ ndó ndí to̱ꞌon yóꞌo chindeé ña ndóꞌó ña kutaku̱ ndó xíꞌin Ndios ndiꞌi saá ki̱vi̱ ña va̱xi. Ta mi̱i to̱ꞌon Ndios yóꞌo kúu ña ndákuii̱n xa̱ꞌa̱ i̱, ");
INSERT INTO mim_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ta ndóꞌó, o̱n xi̱in ndó kixi ndó no̱o̱ i̱ xa̱ꞌa̱ ña taxi i̱ kutaku̱ ndinoꞌo ndó xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’O̱n vása ndúkú i̱ ña kasa káꞌno ni̱vi yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ta xíni̱ va̱ꞌa i̱ ndasaá yóo ini ndóꞌó, ta xíni̱ va̱ꞌa i̱ o̱n vása kíꞌvi ini ndó xíni ndó Ndios. ");
INSERT INTO mim_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yi̱ꞌi̱ ki̱xaa̱ i̱ xíꞌin nda̱yí Yivá i̱ Ndios, ta ndóꞌó o̱n xi̱in ndó nakiꞌin va̱ꞌa ndó yi̱ꞌi̱. Táná kixaa̱ inka̱ ta̱a xíꞌin ndasaá kuiti nda̱yí mi̱i ra, ta ndóꞌó nakiꞌin va̱ꞌa ndó ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tá o̱n xi̱in ndó keꞌé ndó ña kóni Ndios, ta saá o̱n kuchiño kandixa ndó yi̱ꞌi̱. Saá chi ndiꞌi mi̱i ndó ndixa sándiꞌi ndó ini ndó ña ndukú ndó ndasaá va̱ꞌa kuchiño kasa káꞌno ndó xíꞌin táꞌan mi̱i ndó. Ta nda̱ loꞌo o̱n vása sándiꞌi ndó ini ndó ña ndukú ndó keꞌé ndó ña xíni̱ ñóꞌó xa̱ꞌa̱ ña kasa káꞌno Ndios ndinoꞌo mi̱i ndó. ");
INSERT INTO mim_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ta yi̱ꞌi̱, o̱n taxi i̱ kua̱chi xa̱ꞌa̱ ndó no̱o̱ Ndios. Saá chi mi̱i ta̱xi̱i̱ síkuá ndó ta̱Moisés kúu ta̱a ta̱ taxi kua̱chi xa̱ꞌa̱ ndó no̱o̱ Ndios. Ta ndóꞌó ndáa ini ndó ta̱Moisés ndakuii̱n ra ka̱ꞌa̱n ra ñava̱ꞌa xa̱ꞌa̱ ndó no̱o̱ Ndios, ta ta̱Moisés ndixa o̱n vása ndakuii̱n ra saá xa̱ꞌa̱ ndó. ");
INSERT INTO mim_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Saá chi kui̱ya̱ xi̱na̱ꞌá ta̱Moisés ni̱taa ra to̱ꞌon Ndios xa̱ꞌa̱ i̱, ta o̱n vása kándixa ndó to̱ꞌon yóꞌo. Tá ndixa ndinoꞌo ini ndó kandixa ndó to̱ꞌon ña ni̱taa ta̱Moisés, níkúu, ta saá kuchiño kandixa ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tá o̱n vása kúchiño ndó kandixa ndó to̱ꞌon ña ni̱taa ta̱Moisés, ta saá, ¿ndasaá kuchiño kandixa ndó to̱ꞌon ña káꞌa̱n i̱ xíꞌin ndó vitin? ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ta ndi̱ꞌi ni̱yaꞌa ñayóꞌo, ta saá ta̱Jesús nda̱a ra tón barco xíꞌin naxíka xíꞌin ra, ta kua̱ꞌa̱n na xíꞌin ra inka̱ táꞌví yuꞌu̱ mi̱ni na̱ní Galilea. Yóo inka̱ ki̱vi̱ mi̱ni yóꞌo, na̱ní ña Tiberias. ");
INSERT INTO mim_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kua̱ꞌa̱ ní ni̱vi ndíko̱n na kua̱ꞌa̱n na sa̱ta̱ ta̱Jesús chi xa xi̱ni na milagro va̱ꞌa ke̱ꞌé ra ña sa̱ndaꞌa ra ni̱vi na ndeé ndóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ta ni̱xaa̱ tón barco yuꞌu̱ takuií mi̱ni, ta no̱o ta̱Jesús xíꞌin naxíka xíꞌin ra. Ta saá na̱kiꞌin ra kua̱ꞌa̱n ndaa ra ñii xi̱ki̱, ta naxíka xíꞌin ra kua̱ꞌa̱n na sa̱ta̱ ra. Ta saá ni̱xaa̱ ra no̱o̱ xi̱ki̱, ta xi̱koo ra ta ñii saá xi̱kundo̱o naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ta ki̱vi̱ yóꞌo kúu ki̱vi̱ ña yatin kana viko̱ Pascua najudío. ");
INSERT INTO mim_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ta ta̱Jesús nda̱níꞌi ra no̱o̱ ra, ta xi̱ni ra kua̱ꞌa̱ ní ni̱vi va̱xi, ta ni̱nda̱ka̱ to̱ꞌon ra ñii ta̱xíka xíꞌin ra, ta̱ na̱ní Felipe, káchí ra saá xíꞌin ra: ―Tata Felipe, ¿míkía̱ sata yó si̱ta̱ va̱ꞌa kuxu ni̱vi yóꞌo? ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ta xa xíni̱ va̱ꞌa ta̱Jesús yukía̱ keꞌé ra xa̱ꞌa̱ ña kuxu ni̱vi, ta saá ni, ni̱nda̱ka̱ to̱ꞌon ra ta̱Felipe chi kóni ra koto ndoso ra ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ta nda̱kuii̱n ta̱Felipe, ni̱ka̱ꞌa̱n ra: ―Táná ko̱ꞌo̱n yó xíꞌin o̱vi̱ ciento si̱ꞌún denario, ta o̱n kunani si̱ꞌún yóꞌo ña sata yó vará nda̱ loꞌo ní ña kuxu ñii ñii ni̱vi, chi víꞌí ní ni̱vi kúu nayóꞌo ―káchí ta̱Felipe xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ta saá ta̱Andrés, ta̱ kúu ñii ta̱xíka xíꞌin ta̱Jesús, ta ñani ta̱Simón Pedro kúu ra, ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ñii ta̱loꞌo yóꞌo níꞌi ra o̱ꞌo̱n si̱ta̱ va̱ꞌa ña ku̱va̱ꞌa xíꞌin cebada, ta níꞌi ra o̱vi̱ tia̱ká válí. Ta loꞌo ní kúu ña, ta o̱n kunani ña kuxu ndiꞌi ni̱vi ―káchí ta̱Andrés xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin nata̱a naxíka xíꞌin ra, káchí ra saá: ―Ka̱ꞌa̱n ndó xíꞌin ni̱vi ná kundo̱o na ―káchí ra. Saá chi yóo kua̱ꞌa̱ ní yita síi no̱o̱ va̱ꞌa kundo̱o ni̱vi yóꞌo. Ta saá ndiꞌi ni̱vi xi̱kundo̱o na, ta yatin o̱ꞌo̱n mil kúu nina ta̱a, xíꞌin kua̱ꞌa̱ ní ka̱ ñaꞌa̱ xíꞌin naválí. ");
INSERT INTO mim_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ta saá ki̱ꞌin ta̱Jesús o̱ꞌo̱n si̱ta̱ va̱ꞌa yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios, káchí ra saá: ―Tata Yivá yó Ndios, táxaꞌvi ún xa̱ꞌa̱ si̱ta̱ va̱ꞌa yóꞌo ―káchí ra. Ta saá ta̱xi ra ña ndaꞌa̱ naxíka xíꞌin ra, ña nataꞌví na ña kuxu ndiꞌi ni̱vi. Ta ñii káchí saá ke̱ꞌé ta̱Jesús xíꞌin o̱vi̱ tia̱ká válí, ta na̱ni rí xi̱xi ndiꞌi ni̱vi. Ta ndiꞌi ni̱vi yóꞌo xi̱xi na nda̱ ni̱xaa ini na. ");
INSERT INTO mim_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tá ndi̱ꞌi xi̱xi nayóꞌo, ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Nakaya ndó ndiꞌi ña kíndo̱o ndoso yóꞌo, ña o̱n kui̱ta̱ nda̱ loꞌo ña xíꞌin mi̱ꞌí ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ta saá na̱kaya ndiꞌi na ña ki̱ndo̱o ndoso no̱o̱ ña xi̱xi na, ña xi̱kuu o̱ꞌo̱n si̱ta̱ va̱ꞌa válí. Ta xíꞌin ñayóꞌo sa̱kutú na u̱xu̱ o̱vi̱ chikiva si̱ta̱ va̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tá xi̱ni ni̱vi milagro yóꞌo ña ke̱ꞌé ta̱Jesús, ta saá ki̱xáꞌá na káꞌa̱n na xíꞌin táꞌan na, káchí na saá: ―Ndixa ta̱yóꞌo kúu mi̱i ta̱profeta káꞌno ta̱ ndáti yó kixaa̱ ñoyívi yóꞌo ―káchí na, káꞌa̱n na xíꞌin táꞌan na. ");
INSERT INTO mim_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ta kúnda̱a̱ ini ta̱Jesús ña xáni si̱ni̱ ni̱vi yóꞌo ña kasa ndu̱xa̱ na xíꞌin ra nduu ra rey no̱o̱ na, ta saá kama ke̱e matóꞌón ra kua̱ꞌa̱n ra, ta kua̱ꞌa̱n ndaa ra ñii xi̱ki̱. ");
INSERT INTO mim_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tá xa kua̱ꞌa̱n kuñoó kúu ña, ta naxíka xíꞌin ta̱Jesús na̱kiꞌin na kua̱ꞌa̱n na yuꞌu̱ takuií mi̱ni, ");
INSERT INTO mim_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ta nda̱a na ini tón barco, ta kua̱ꞌa̱n na ñoo Capernaum. Ta xa naa kúu ña, ta ta̱Jesús o̱n ta̱ꞌán ndikó ra ki̱xaa̱ ra no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ta saá kua̱ꞌa̱n na xíꞌin tón barco no̱o̱ takuií mi̱ni, ta ki̱xáꞌá ndeé ní káni ta̱chi̱ ta sákanda ní ña takuií yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ta nayóꞌo, xíꞌin ndiꞌi ndee̱ na síta na takuií xíꞌin yito̱n ña chíndaꞌá tón barco kua̱ꞌa̱n nó, ta xa kua̱ꞌa̱n na ñii o̱ꞌo̱n án ñii i̱ño̱ kilómetro no̱o̱ takuií, ta saá na̱koto na va̱xi xáꞌá ta̱Jesús no̱o̱ takuií mi̱ni yóꞌo, ta ki̱xáꞌá na yíꞌví ní na. Ta xa yatin va̱xi ra no̱o̱ tón barco ñóꞌo na, ");
INSERT INTO mim_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―O̱n kuyi̱ꞌví ndó, chi yi̱ꞌi̱ va kúu i̱ ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ta saá kúsii̱ ní ini na, ta na̱kiꞌin na ta̱Jesús nda̱a ra tón barco xíꞌin na, ta kama ní ni̱xaa̱ na no̱o̱ kua̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ta ni̱ti̱vi inka̱ ki̱vi̱, ta inka̱ táꞌví yuꞌu̱ mi̱ni yóꞌo, xa ndóo ni̱vi ndáti na kixaa̱ ta̱Jesús, chi xi̱ni na ñii la̱á barco ni̱xi̱yo yuꞌu̱ takuií yóꞌo, ta saá ku̱nda̱a̱ ini na ndí ta̱Jesús o̱n vása ní‑ndaa ra ini tón barco yóꞌo, ta ndasaá kuiti naxíka xíꞌin ra nda̱a na ini tón barco yóꞌo, ta xa kua̱ꞌa̱n na xíꞌin nó. ");
INSERT INTO mim_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ta saá xi̱to na sava barco tón ki̱xi ñoo Tiberias ki̱xaa̱ nó yuꞌu̱ takuií mi̱ni yóꞌo. Ta ndiꞌi tón barco yóꞌo ki̱xaa̱ nó mi̱i xiiña yatin no̱o̱ xi̱xi na si̱ta̱ va̱ꞌa ña ta̱xi ta̱Jesús ndaꞌa̱ na, ki̱vi̱ siꞌna ni̱ka̱ꞌa̱n ra ta̱xi ra ña táxaꞌvi ñaꞌá ndaꞌa̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ta saá ku̱nda̱a̱ ini na o̱n ko̱ó ta̱Jesús ní‑kixaa̱, ni o̱n ko̱ó naxíka xíꞌin ra yóo ka̱ na yóꞌo, ta saá nani̱vi yóꞌo nda̱a na ini tón barco tón ki̱xi ñoo Tiberias, ta kua̱ꞌa̱n na ñoo Capernaum nandukú na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ta saá nani̱vi yóꞌo ni̱xaa̱ na inka̱ táꞌví yuꞌu̱ takuií mi̱ni yatin ñoo Capernaum, ta na̱níꞌi na ta̱Jesús. Ta saá ni̱nda̱ka̱ to̱ꞌon na ra, káchí na xíꞌin ra: ―Tata Rabí, ¿ama ki̱xaa̱ ún yóꞌo? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta ndixa káꞌa̱n i̱ xíꞌin ndó o̱n si̱ví xa̱ꞌa̱ ña xi̱ni ndó milagro ña ke̱ꞌé i̱ no̱o̱ ndó kúu ña nándukú ndó yi̱ꞌi̱. Ta xa̱ꞌa̱ ña ta̱xi i̱ si̱ta̱ va̱ꞌa xi̱xi ndó a̱nda̱ ni̱xaa ini ndó kúu ña nándukú ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","O̱n váꞌa tá ndasaá kuiti sandiꞌi ndó ini ndó ña ndúkú ndó ña kuxu ndó, chi ñayóꞌo ña ya̱chi̱ ní táꞌyi̱ kúu ña. Ta va̱ꞌa ka̱ chikaa̱ ndó ndee̱ ña ndukú ndó inka̱ no̱o̱ ñaxíxi ña o̱n vása táꞌyi̱. Ta yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, taxi i̱ ña kuxu ndó si̱ta̱ va̱ꞌa ña kómí ndee̱ ña taxi kutaku̱ ndinoꞌo ndó, ta nda̱ ñii ki̱vi̱ o̱n ndiꞌi xa̱ꞌa̱ ndó. Saá chi Yivá i̱ Ndios xa ta̱xi ra nda̱yí ra ndaꞌa̱ i̱ ña keꞌé i̱ saá ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ta saá ni̱nda̱ka̱ to̱ꞌon na ra, káchí na xíꞌin ra: ―¿Yukía̱ xíni̱ ñóꞌó keꞌé ndi̱ ña kivi kasa ndivi ndi̱ chiño ña kóni Ndios? ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ta ta̱Jesús nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra saá: ―Ñayóꞌo kúu ña kóni Ndios keꞌé ndó ña kasa ndivi ndó chiño ña kóni ra: xíni̱ ñóꞌó kandixa ndó yi̱ꞌi̱, ta̱a ta̱ ti̱ꞌví ra ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ta saá ni̱nda̱ka̱ to̱ꞌon tuku na ra: ―¿Ndá milagro kúu ña keꞌé ún no̱o̱ ndi̱ ña koni ndi̱, ta saá kandixa ndi̱ ndí yóꞌó kúu ún ta̱a ta̱ ti̱ꞌví Ndios? Ta vitin, ¿yu kúu ña keꞌé ún? ");
INSERT INTO mim_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chi naxi̱i̱ síkuá yó xi̱xi na si̱ta̱ va̱ꞌa ña na̱ní maná ki̱vi̱ ni̱xi̱yo na yuku̱ yi̱chí. Ta xa̱ꞌa̱ ñayóꞌo káchí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá: “Ta̱xi ra si̱ta̱ va̱ꞌa ña ki̱xi ñoyívi ni̱no, xi̱xi na”, káchí to̱ꞌon Ndios ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ta nda̱kuii̱n ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó, o̱n si̱ví ta̱Moisés xi̱kuu ta̱ ta̱xi si̱ta̱ va̱ꞌa ña ki̱xi ñoyívi ni̱no xi̱xi na, ta Yivá i̱ Ndios kúu ta̱ ta̱xi ña xi̱xi naxi̱i̱ síkuá yó. Ta vitin Ndios táxi ra ndaꞌa̱ ndó si̱ta̱ va̱ꞌa ndinoꞌo ña ki̱xi ñoyívi ni̱no. ");
INSERT INTO mim_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ta si̱ta̱ va̱ꞌa ndinoꞌo ña táxi Ndios kúu ta̱a ta̱ ki̱xi no̱o̱ Ndios ta no̱o ra ta ki̱xaa̱ ra nda̱ ñoyívi yóꞌo, ta ta̱yóꞌo ndixa taxi ra kutaku̱ ndinoꞌo ni̱vi ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na xíꞌin ra: ―Tata, ndiꞌi saá ki̱vi̱ taxi ún si̱ta̱ va̱ꞌa yóꞌo ndaꞌa̱ ndi̱ ña kuxu ndi̱ ña ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ta nda̱kuii̱n ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―Yi̱ꞌi̱ kúu si̱ta̱ va̱ꞌa ndinoꞌo, ta táxi i̱ ña kutaku̱ ndinoꞌo ni̱vi. Ta ni̱vi na ndíko̱n yi̱ꞌi̱ nda̱ ñii ki̱vi̱ o̱n kivi̱ ka̱ na so̱ko, ta ni̱vi na kándixa yi̱ꞌi̱ nda̱ ñii ki̱vi̱ o̱n yi̱chi̱ ka̱ na takuií. ");
INSERT INTO mim_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Xa nda̱to̱ꞌon i̱ xíꞌin ndó to̱ꞌon yóꞌo, ta tuku káꞌa̱n i̱ xíꞌin ndó vitin ndí ndóꞌó, vará xíto ndó yi̱ꞌi̱ xíꞌin nduchu̱ no̱o̱ ndó, ta o̱n xi̱in ndó kandixa ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta ni̱vi na chi̱tóni̱ Yivá i̱ Ndios kundiko̱n na sa̱ta̱ i̱, ndiꞌi nayóꞌo kixaa̱ na no̱o̱ i̱. Ta nakiꞌin va̱ꞌa i̱ ndiꞌi na kixaa̱ no̱o̱ i̱, ta nda̱ ñii ki̱vi̱ o̱n vása taxin i̱ nda̱ ñii nayóꞌo ña kuxíká na no̱o̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Chi yi̱ꞌi̱ ke̱e i̱ no̱o̱ Yivá i̱ Ndios ta ki̱xaa̱ i̱ ñoyívi yóꞌo xa̱ꞌa̱ ña kasa ndivi i̱ ña kóni Yivá i̱, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ va̱xi i̱. Ta o̱n si̱ví xa̱ꞌa̱ ña kóni mi̱i i̱ kúu ña ki̱xaa̱ i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ta Yivá i̱, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ va̱xi i̱, kóni ra ña o̱n sandañóꞌó i̱ nda̱ ñii ni̱vi na ta̱xi ra ndaꞌa̱ i̱. Ta saá tá kixaa̱ ki̱vi̱ sondíꞌí ñoyívi yóꞌo, ta sanataku̱ i̱ ndiꞌi ni̱vi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yivá i̱ Ndios kóni ra ndí ni̱vi na xíni yi̱ꞌi̱ ta kándixa na yi̱ꞌi̱, ta ndiꞌi nayóꞌo kutaku̱ ndinoꞌo na xíꞌin ra ndiꞌi saá ki̱vi̱ ña va̱xi, ta ki̱vi̱ sondíꞌí, yi̱ꞌi̱ sanataku̱ i̱ ndiꞌi ni̱vi yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ta saá ki̱xáꞌá najudío káꞌa̱n o̱n váꞌa na xa̱ꞌa̱ ta̱Jesús, chi ni̱ka̱ꞌa̱n ra, káchí ra saá: “Yi̱ꞌi̱ kúu si̱ta̱ va̱ꞌa ndinoꞌo ña ki̱xi no̱o̱ Ndios”, káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ta ki̱xáꞌá na káꞌa̱n na xíꞌin táꞌan na, káchí na saá: ―¿Án o̱n si̱ví ta̱yóꞌo kúu ta̱Jesús sa̱ꞌya ta̱José?, chi xíni̱ va̱ꞌa yó yivá ra, xíꞌin siꞌí ra. Ta saá, ¿nda̱chun káꞌa̱n ra ke̱e ra ñoyívi ni̱no no̱o̱ yóo Ndios? ―káchí na, káꞌa̱n na xíꞌin táꞌan na. ");
INSERT INTO mim_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―O̱n ka̱ꞌa̱n kuáchí ka̱ ndó to̱ꞌon o̱n váꞌa xa̱ꞌa̱ i̱ xíꞌin táꞌan ndó. ");
INSERT INTO mim_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Saá chi tá Yivá i̱ Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ va̱xi i̱, o̱n vása chíkaa̱ ra ini ni̱vi ña kixaa̱ na no̱o̱ i̱ ña kundiko̱n na yi̱ꞌi̱, ta nda̱ ñii ni̱vi o̱n kuchiño keꞌé na saá. Ta tá kixaa̱ ki̱vi̱ sondíꞌí, ta ndixa yi̱ꞌi̱ sanataku̱ i̱ ndiꞌi ni̱vi yóꞌo, na kúu na ndíko̱n yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","To̱ꞌon Ndios ña ni̱taa naprofeta kui̱ya̱ xi̱na̱ꞌá káchí ña saá: “Mi̱i Ndios sanáꞌa ra ndiꞌi ni̱vi”, káchí to̱ꞌon yóꞌo. Ta ndiꞌi ni̱vi na chikaa̱ so̱ꞌo to̱ꞌon ña sánáꞌa Yivá i̱ Ndios ta sakuáꞌá na ña, nayóꞌo kixaa̱ na no̱o̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ndixa nda̱ ñii ni̱vi o̱n ta̱ꞌán koni na Ndios xíꞌin nduchu̱ no̱o̱ na, ta ndasaá kuiti yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ ra kúu ta̱a ta̱ xa xi̱ni ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó: Ndiꞌi ni̱vi na kándixa yi̱ꞌi̱ kúu ni̱vi na táku̱ ndinoꞌo ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yi̱ꞌi̱ kúu si̱ta̱ va̱ꞌa ndinoꞌo, ta kómí i̱ ndee̱ ña taxi i̱ ña kutaku̱ ndinoꞌo ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Vará naxi̱i̱ síkuá yó xi̱na̱ꞌá xi̱xi na si̱ta̱ va̱ꞌa ña na̱ní maná ki̱vi̱ ni̱xi̱yo na yuku̱ yi̱chí, ta saá ni, ni̱xiꞌi̱ ndiꞌi nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ta yi̱ꞌi̱ kúu si̱ta̱ va̱ꞌa ña ki̱xi no̱o̱ Ndios. Táná kuxu ni̱vi si̱ta̱ va̱ꞌa yóꞌo, ta saá o̱n kivi̱ ka̱ na, ta kutaku̱ ndinoꞌo na ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yi̱ꞌi̱ kúu si̱ta̱ va̱ꞌa ña táku̱, ña ki̱xi no̱o̱ Ndios, ta no̱o ña ki̱xaa̱ ña ñoyívi yóꞌo. Táná kuxu ni̱vi si̱ta̱ va̱ꞌa yóꞌo, ta ndixa o̱n ndiꞌi xa̱ꞌa̱ na, ta ni̱vi yóꞌo kutaku̱ na ndiꞌi saá ki̱vi̱. Si̱ta̱ va̱ꞌa ña káꞌa̱n i̱ xa̱ꞌa̱ yóꞌo kúu ko̱ñu i̱ ña so̱ko̱ i̱ xa̱ꞌa̱ ndiꞌi ni̱vi ñoyívi yóꞌo ña kuchiño kutaku̱ na ndiꞌi saá ki̱vi̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tá najudío na ndóo yóꞌo xi̱ni̱ so̱ꞌo na to̱ꞌon yóꞌo, ta saá ki̱xáꞌá na náa na xíꞌin táꞌan na, chi o̱n vása kúnda̱a̱ ini na to̱ꞌon ni̱ka̱ꞌa̱n ta̱Jesús. Ta ni̱ka̱ꞌa̱n na, káchí na saá: ―¿Ndasaá keꞌé ta̱yóꞌo ña taxi ra ko̱ñu ra kuxu yó? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ña ndixa nda̱a̱ kúu to̱ꞌon yóꞌo: Ni̱vi na o̱n kuxu ko̱ñu i̱ ni o̱n koꞌo na ni̱i̱ i̱, nayóꞌo ndixa o̱n kutaku̱ ndinoꞌo na. ");
INSERT INTO mim_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ta ndiꞌi ni̱vi na xíxi ko̱ñu i̱ ta xíꞌi na ni̱i̱ i̱, nayóꞌo kúu ni̱vi na ndixa táku̱ ndinoꞌo, ta ki̱vi̱ sondíꞌí, yi̱ꞌi̱ sanataku̱ i̱ nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Saá chi ko̱ñu i̱ kúu ñava̱ꞌa ndinoꞌo xíxi ni̱vi, ta ni̱i̱ i̱ kúu ñava̱ꞌa ndinoꞌo xíꞌi ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ndiꞌi ni̱vi na xíxi ko̱ñu i̱ ta xíꞌi na ni̱i̱ i̱ kúu ni̱vi na ñii yóo xíꞌin i̱, ta yi̱ꞌi̱ ñii yóo i̱ xíꞌin nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ndios ta̱a ta̱táku̱ ndinoꞌo, ti̱ꞌví ra yi̱ꞌi̱, ta yi̱ꞌi̱ táku̱ ndinoꞌo i̱ chi táku̱ Ndios. Ta ñii ki̱ꞌva saá ndiꞌi ni̱vi na kuxu ko̱ñu i̱, nayóꞌo kutaku̱ ndinoꞌo na chi táku̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yi̱ꞌi̱ kúu si̱ta̱ va̱ꞌa ndinoꞌo ña ke̱e ñoyívi ni̱no no̱o̱ yóo Ndios. O̱n vása ñii kúu si̱ta̱ va̱ꞌa yóꞌo xíꞌin si̱ta̱ va̱ꞌa ña na̱ní maná ña xi̱xi naxi̱i̱ síkuá yó xi̱na̱ꞌá. Saá chi, vará xi̱xi na si̱ta̱ va̱ꞌa maná yóꞌo, ta saá ni, ni̱xiꞌi̱ ndiꞌi na. Ta ndiꞌi ni̱vi na kuxu si̱ta̱ va̱ꞌa ndinoꞌo ña kúu ko̱ñu i̱, ta ni̱vi yóꞌo kutaku̱ ndinoꞌo na ndiꞌi saá ki̱vi̱ ña va̱xi ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ta̱Jesús ni̱ka̱ꞌa̱n ra to̱ꞌon yóꞌo ki̱vi̱ yóo ra sánáꞌa ra ni̱vi veꞌe ño̱ꞌo sinagoga ñoo Capernaum. ");
INSERT INTO mim_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tá xi̱ni̱ so̱ꞌo na ndiꞌi to̱ꞌon ña ni̱ka̱ꞌa̱n ta̱Jesús yóꞌo, ta kua̱ꞌa̱ ní ni̱vi na ndíko̱n sa̱ta̱ ra, ki̱xáꞌá na káꞌa̱n táꞌan na, káchí na saá: ―To̱ꞌon yóꞌo yo̱ꞌvi̱ ní ña. ¿Yu kúu ni̱vi kuchiño kandixa na to̱ꞌon yóꞌo? ―káchí na xíꞌin táꞌan na. ");
INSERT INTO mim_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ta kúnda̱a̱ ini ta̱Jesús ña káꞌa̱n o̱n váꞌa na xa̱ꞌa̱ to̱ꞌon nda̱to̱ꞌon ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―¿Án to̱ꞌon ña nda̱to̱ꞌon i̱ xíꞌin ndó sándiꞌi ña ini ndó? ");
INSERT INTO mim_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ta saá, ¿ndasaá ka̱ ví nakaꞌnda ní ini ndó táná koto ndó yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ki̱vi̱ ndikó i̱ ndaa i̱ ñoyívi ni̱no no̱o̱ siꞌna ni̱xi̱yo i̱? ");
INSERT INTO mim_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ñii la̱á Níma̱ Ndios kómí ña ndee̱ ña taxi ña kutaku̱ ndinoꞌo ni̱vi, ta ndee̱ ña kómí yi̱kí ko̱ñu ni̱vi o̱n vása kúndeé ña taxi ña kutaku̱ ndinoꞌo nda̱ ñii ni̱vi. To̱ꞌon ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó kúu to̱ꞌon Níma̱ Ndios ta kómí ña ndee̱ ña taxi ña kutaku̱ ndinoꞌo ndó. ");
INSERT INTO mim_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ta saá ni, sava ndóꞌó o̱n vása kándixa ndó to̱ꞌon ña káꞌa̱n i̱ xíꞌin ndó ―káchí ta̱Jesús xíꞌin na. Chi nda̱ ki̱vi̱ no̱ó xa ku̱nda̱a̱ ini ta̱Jesús yu kuu ni̱vi na o̱n kandixa ñaꞌá, ta ku̱nda̱a̱ ini ra yu kuu ta̱a ta̱ ko̱ꞌo̱n si̱kó kuíꞌná ñaꞌá ndaꞌa̱ ni̱vi na sáa̱ ini xíni ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ta saá ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na: ―Ña̱kán kía̱ xa nda̱to̱ꞌon i̱ xíꞌin ndó ndí nda̱ ñii ni̱vi o̱n kuchiño na kixaa̱ mi̱i na no̱o̱ i̱ ña kundiko̱n na yi̱ꞌi̱, tá o̱n vása chíkaa̱ Ndios ini na keꞌé na saá ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ta̱nda̱ ki̱vi̱ saá kua̱ꞌa̱ ní ni̱vi na xi̱ndiko̱n sa̱ta̱ ta̱Jesús, sa̱ndakoo na ra, ta o̱n vása ka̱ kua̱ꞌa̱n na sa̱ta̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ta saá ta̱Jesús ni̱nda̱ka̱ to̱ꞌon ra na u̱xu̱ o̱vi̱ xíka xíꞌin ra, ta ni̱ka̱ꞌa̱n ra saá xíꞌin na: ―Ta ndóꞌó, ¿yukía̱ káchí ini ndó? ¿Án kóni ndó sandakoo ndó yi̱ꞌi̱ nda̱tán ni̱vi yóꞌo sa̱ndakoo na yi̱ꞌi̱? ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ta nda̱kuii̱n ta̱Simón Pedro ni̱ka̱ꞌa̱n ra: ―Tata, ¿yu kúu ka̱ ví inka̱ ta̱a ta̱ kuchiño ndi̱ kundiko̱n ndi̱?, chi ñii la̱á yóꞌó kúu ta̱a ta̱ káꞌa̱n to̱ꞌon ña kómí ndee̱ ña taxi kutaku̱ ndinoꞌo ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Xa kándixa va̱ꞌa ndi̱ yóꞌó, ta xíni̱ ndi̱ yóꞌó kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ni̱vi ñoyívi yóꞌo ta kúu ún Sa̱ꞌya Ndios ta̱táku̱ ―káchí ta̱Pedro xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ta ta̱Jesús nda̱kuii̱n ra ni̱ka̱ꞌa̱n ra, káchí ra saá: ―¿Án o̱n ndixa mi̱i yi̱ꞌi̱ kúu ta̱a ta̱ na̱ka̱xin mi̱i u̱xu̱ o̱vi̱ ndóꞌó ña kundiko̱n ndó yi̱ꞌi̱?, ta ini ñii ndóꞌó nákaa̱ ñaníma̱ ndiva̱ꞌa ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Káchí ra saá xa̱ꞌa̱ ta̱Judas sa̱ꞌya ta̱Simón Iscariote, chi ta̱Judas yóꞌo kúu ñii ta̱táꞌan na u̱xu̱ o̱vi̱ xíka xíꞌin ta̱Jesús, ta va̱xi ki̱vi̱ ta̱Judas yóꞌo si̱kó kuíꞌná ra ta̱Jesús ndaꞌa̱ na sáa̱ ini xíni ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ta saá ta̱Jesús xíka ra kua̱ꞌa̱ ní ñoo ña ñóꞌo estado Galilea, chi o̱n xi̱in ra kaka ka̱ ra ñoo ña ñóꞌo estado Judea, chi nanáꞌno no̱o̱ najudío ndúkú na kaꞌni na ra. ");
INSERT INTO mim_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ta saá xa yatin tónda̱a ki̱vi̱ ña sákana najudío viko̱ káꞌno, ña na̱ní viko̱ veꞌe tia̱ꞌva. ");
INSERT INTO mim_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ta nañani ta̱Jesús ki̱xaa̱ na no̱o̱ ra, ta ni̱ka̱ꞌa̱n na xíꞌin ra, káchí na saá: ―¿Án o̱n váꞌa sandakoo ún ñoo válí yóꞌo ta ko̱ꞌo̱n ún ñoo náꞌno ña ñóꞌo estado Judea?, chi ñoo kán kua̱ꞌa̱ ní ka̱ ni̱vi na ndíko̱n sa̱ta̱ ún kuchiño koto na milagro keꞌé ún. ");
INSERT INTO mim_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tá ndixa kéꞌé ún chiño náꞌno, ta, ¿nda̱chun o̱n vása sanáꞌa ún ña no̱o̱ ndiꞌi ni̱vi ña kuchiño na koni na ña kéꞌé ún? Chi nda̱ ñii ta̱a o̱n to̱nda̱a ra kuu ra ta̱káꞌno, tá ta̱yóꞌo kísa chiño seꞌé ra ―káchí nañani ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nañani ra ni̱ka̱ꞌa̱n na saá xíꞌin ra chi o̱n ta̱ꞌán kandixa na ra. ");
INSERT INTO mim_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―O̱n ko̱ꞌo̱n i̱ viko̱ vitin chi o̱n ta̱ꞌán to̱nda̱a ki̱vi̱ ña chi̱tóni̱ Ndios. Ta mi̱i ndó, nda̱ ndá ka̱ ki̱vi̱ kúu ña va̱ꞌa ko̱ꞌo̱n ndó, ");
INSERT INTO mim_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","chi nani̱vi ñoyívi yóꞌo o̱n ki̱ví kusaa̱ ini na koni na ndóꞌó. Ta yi̱ꞌi̱, sáa̱ ní ini ni̱vi yóꞌo xíni na yi̱ꞌi̱, chi káꞌa̱n káxín i̱ xíꞌin na xa̱ꞌa̱ ña o̱n váꞌa kéꞌé na. ");
INSERT INTO mim_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ta va̱ꞌa kua̱ꞌa̱n ndó viko̱ vitin, ta yi̱ꞌi̱, o̱n ko̱ꞌo̱n i̱ xíꞌin ndó, chi o̱n ta̱ꞌán kixaa̱ ki̱vi̱ ña chi̱tóni̱ Ndios ko̱ꞌo̱n i̱ ―káchí ta̱Jesús xíꞌin nañani ra. ");
INSERT INTO mim_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ta saá ni̱ndo̱o ra ñoo estado Galilea. ");
INSERT INTO mim_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ta nañani ta̱Jesús ke̱e na kua̱ꞌa̱n na viko̱ ña kána ñoo Jerusalén. Ta saá ni̱yaꞌa loꞌo ki̱vi̱, ta ke̱e ta̱Jesús kua̱ꞌa̱n seꞌé ra viko̱ yóꞌo, ña o̱n vása koni ni̱vi kua̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ta najudío na ndóo viko̱ yóꞌo nándukú na ta̱Jesús, ta káꞌa̱n na xíꞌin táꞌan na, káchí na saá: ―¿Míkía̱ yóo ta̱Jesús? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ta kua̱ꞌa̱ ní ni̱vi káꞌa̱n na ndáto̱ꞌon na xíꞌin táꞌan na xa̱ꞌa̱ ta̱Jesús. Sava na káꞌa̱n xa̱ꞌa̱ ra va̱ꞌa ní ta̱a kúu ra, ta inka̱ na káꞌa̱n xa̱ꞌa̱ ra o̱n vása va̱ꞌa ta̱a kúu ra, chi ta̱ sándáꞌví kuiti ni̱vi kúu ra, káchí na. ");
INSERT INTO mim_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ta ndiꞌi ni̱vi na káꞌa̱n yóꞌo, ndasaá kuiti xíꞌin táꞌan mi̱i na káꞌa̱n na, chi o̱n xi̱in na ña koni̱ so̱ꞌo nanáꞌno no̱o̱ najudío xa̱ꞌa̱ ña nda̱to̱ꞌon na. Saá chi yíꞌví na no̱o̱ nanáꞌno yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ta tónda̱a ki̱vi̱ ña kúu mi̱i ma̱ꞌñó viko̱ yóꞌo, ta ta̱Jesús ni̱xaa̱ ra veꞌe ño̱ꞌo káꞌno, ta ki̱xáꞌá ra sánáꞌa ra ni̱vi na ndóo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tá najudío xi̱ni̱ so̱ꞌo na ña káꞌa̱n ta̱Jesús sánáꞌa ra, ta na̱kaꞌnda ini na xa̱ꞌa̱ ña xi̱ni̱ so̱ꞌo na, ta ni̱ka̱ꞌa̱n na, káchí na saá: ―¿Nda̱chun va̱ꞌa ní xíni̱ ta̱yóꞌo?, ta o̱n vása ní‑kaꞌvi ra kua̱ꞌa̱ ní kui̱ya̱ veꞌe no̱o̱ káꞌvi na ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―O̱n si̱ví to̱ꞌon mi̱i i̱ kúu ña sánáꞌa i̱, ta sánáꞌa i̱ to̱ꞌon Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ta ndiꞌi ni̱vi na chíkaa̱ ini ña kasa ndivi na ña kóni Ndios, ni̱vi yóꞌo kúu na kúchiño kunda̱a̱ va̱ꞌa ini ndí án ndixa xíꞌin nda̱yí Ndios sánáꞌa i̱ ni̱vi, án kuiti xíꞌin nda̱yí mi̱i i̱ sánáꞌa i̱ na. ");
INSERT INTO mim_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ta ta̱a ta̱ káꞌa̱n xíꞌin nda̱yí mi̱i, ta̱yóꞌo káꞌa̱n ra ña kasa káꞌno xíꞌin mi̱i ra no̱o̱ ni̱vi. Ta ta̱a ta̱ ndúkú ña kanóo síkón ñato̱ꞌó inka̱ ta̱a ta̱ ti̱ꞌví ñaꞌá, ta ta̱a ta̱ ndúkú ñayóꞌo kúu ta̱ káꞌa̱n ña ndixa nda̱a̱, ta o̱n ko̱ó ñavatá ini ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Án o̱n si̱ví ñanda̱a̱ kúu ña ta̱Moisés ta̱xi ra nda̱yí Ndios ndaꞌa̱ naxi̱i̱ síkuá yó? Ta nda̱ ñii ndóꞌó o̱n vása kándixa ndó nda̱yí yóꞌo. Ta vitin, ¿nda̱chun kóni ndó kaꞌni ndó yi̱ꞌi̱? ");
INSERT INTO mim_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na xíꞌin ra, káchí na saá: ―Yóꞌó, ¡ndixa nákaa̱ níma̱ ndiva̱ꞌa ini ún, ta sáka ní ña si̱ni̱ ún! ¿Yu kúu ni̱vi kóni kaꞌni yóꞌó? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ta nda̱kuii̱n ta̱Jesús: ―Ñii milagro ke̱ꞌé i̱ no̱o̱ ndó, ta ndiꞌi ndóꞌó na̱kaꞌnda ní ini ndó, chi ke̱ꞌé i̱ ñava̱ꞌa yóꞌo ki̱vi̱ yi̱i̱. ");
INSERT INTO mim_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ta mi̱i ndó, ki̱vi̱ yi̱i̱ ña nákindée ndó, ta saá ni, kísa chiño ndó. Saá chi tá ñii ta̱loꞌo sa̱ꞌya ndó ni̱xi̱no̱ ra o̱na̱ ki̱vi̱ mi̱i ki̱vi̱ yi̱i̱, ta ndu̱xa̱ kasa ndivi ndó costumbre ña na̱ní circuncisión, chi saá kísa ndivi ndó ña xa̱ꞌnda chiño ta̱Moisés no̱o̱ naxi̱i̱ síkuá yó. (Ta o̱n si̱ví ta̱Moisés kúu ta̱no̱ó xa̱ꞌnda chiño ña kasa ndivi ni̱vi ña na̱ní circuncisión yóꞌo, chi o̱n ta̱ꞌán ka̱ kixaa̱ ki̱vi̱ ka̱ku ta̱Moisés, ta naxi̱i̱ síkuá yó ta̱Abraham, ta̱Isaac, xíꞌin ta̱Jacob xa ki̱sa ndivi na ñayóꞌo.) ");
INSERT INTO mim_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ta xa̱ꞌa̱ ña o̱n xi̱in ndó yaꞌa ndoso ndó no̱o̱ nda̱yí ta̱Moisés, ta ndu̱xa̱ kasa ndivi ndó chiño loꞌo ña na̱ní circuncisión, vará mi̱i ki̱vi̱ yi̱i̱ kúu ña. Ta saá, ¿nda̱chun sáa̱ ini ndó xíni ndó yi̱ꞌi̱ xa̱ꞌa̱ ña ki̱sa ndivi i̱ chiño va̱ꞌa, chi sa̱ndaꞌa i̱ ñii ta̱ ndeé ndóꞌo, vará ki̱vi̱ yi̱i̱ xi̱kuu ña? ");
INSERT INTO mim_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tá ndasaá kuiti xíto ndó ña kéꞌé ni̱vi, ta o̱n vása kúchiño kasa nani ndó xa̱ꞌa̱ ña kéꞌé na. Saá chi xíni̱ ñóꞌó kunda̱a̱ ini ndó yu kúu ña ndixa nda̱a̱, ta saá kuchiño kasa nani ndó xa̱ꞌa̱ ni̱vi án ndixa ndíso na kua̱chi ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ta saá sava ni̱vi na táku̱ ñoo Jerusalén káꞌa̱n táꞌan na, káchí na saá: ―¿Án o̱n si̱ví ta̱yóꞌo kúu ta̱a ta̱ kóni nachiño náꞌno kaꞌni na? ");
INSERT INTO mim_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ta vitin yóꞌo yóo ra, káꞌa̱n ndoso ra no̱o̱ yó, ta nda̱ ñii nanáꞌno o̱n vása káꞌa̱n na xíꞌin ra. ¿Án xáni si̱ni̱ nachiño náꞌno yóꞌo ndí ta̱yóꞌo kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku mi̱i yó? ");
INSERT INTO mim_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ta ta̱yóꞌo o̱n ki̱ví kuu ra Cristo, chi xáni si̱ni̱ yó ndí nda̱ ñii ni̱vi o̱n koni̱ na míchí ki̱xi Cristo. Ta ta̱Jesús yóꞌo, xíni̱ yó ndá ñoo ki̱xi ra ―káchí na, káꞌa̱n na xíꞌin táꞌan na. ");
INSERT INTO mim_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ta yóo ta̱Jesús sánáꞌa ra ni̱vi veꞌe ño̱ꞌo káꞌno, ta saá ndeé ka̱ nda̱níꞌi ra ta̱chi̱ ra, ta ni̱ka̱ꞌa̱n ra: ―¿Án ndixa xíni̱ ndó yi̱ꞌi̱? ¿Án ndixa xíni̱ ndó míkía̱ ki̱xi i̱? O̱n si̱ví xíꞌin nda̱yí mi̱i i̱ kúu ña ki̱xaa̱ i̱ ñoyívi yóꞌo, ta yi̱ꞌi̱ ki̱xaa̱ i̱ xíꞌin nda̱yí Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱, ta ta̱yóꞌo kúu ta̱a ta̱nda̱a̱ ndinoꞌo. Ta ndóꞌó, o̱n vása xíni̱ ndó ra. ");
INSERT INTO mim_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ta yi̱ꞌi̱, xíni̱ va̱ꞌa i̱ ra chi ki̱xi i̱ no̱o̱ ra, ta ta̱yóꞌo ti̱ꞌví ra yi̱ꞌi̱ ki̱xaa̱ i̱ ñoyívi yóꞌo ―káchí ta̱Jesús, káꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tá xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ra, ta ki̱xáꞌá na ndúkú ndeé na tiin na ra, ta nda̱ ñii ni̱vi ni̱‑kuchiño na to̱nda̱a na tiin na ra, chi o̱n ta̱ꞌán to̱nda̱a ki̱vi̱ ña chi̱tóni̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ta kua̱ꞌa̱ ní ni̱vi ka̱ndixa na ra, ta káꞌa̱n na, káchí na saá: ―Ndixa ta̱yóꞌo kúu Cristo, chi o̱n ki̱ví kixaa̱ inka̱ ta̱a ta̱ kuchiño keꞌé milagro náꞌno ka̱ no̱o̱ ña kéꞌé ta̱yóꞌo ―káchí na, káꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ta nafariseo xi̱ni̱ so̱ꞌo na ña nda̱to̱ꞌon ni̱vi xa̱ꞌa̱ ta̱Jesús. Ta saá nafariseo yóꞌo xíꞌin nanáꞌno no̱o̱ nasu̱tu̱ ti̱ꞌví na napolicía na ndáa veꞌe ño̱ꞌo káꞌno ña ko̱ꞌo̱n na tiin na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ni̱vi: ―Ñii káni̱ loꞌo koo ka̱ i̱ xíꞌin ndó, ta saá ko̱ꞌo̱n i̱ ndikó i̱ no̱o̱ yóo ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ta saá nandukú ndó yi̱ꞌi̱, ta o̱n kuchiño ndó naníꞌi ndó yi̱ꞌi̱, ta ni o̱n kuchiño ndó ko̱ꞌo̱n ndó no̱o̱ koo i̱ ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ta saá nanáꞌno no̱o̱ najudío káꞌa̱n táꞌan na, káchí na saá: ―¿Míkía̱ ko̱ꞌo̱n ta̱yóꞌo? ¿Nda̱chun káꞌa̱n ra ko̱ꞌo̱n ra no̱o̱ o̱n kívi naníꞌi yó ra? ¿Án ko̱ꞌo̱n ra ñoo xíká ña kúu ñoo griego no̱o̱ táku̱ kua̱ꞌa̱ ní najudío? ¿Án ko̱ꞌo̱n ra ñoo kán ña sanáꞌa ra nagriego? ");
INSERT INTO mim_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Chi o̱n vása kúnda̱a̱ ini yó yukía̱ káchí to̱ꞌon káꞌa̱n ra, chi ni̱ka̱ꞌa̱n ra ndí nandukú yó ra ta o̱n vása naníꞌi yó ra, ta ni o̱n kuchiño yó xaa̱ yó no̱o̱ ko̱ꞌo̱n ra koo ra ―káchí na, káꞌa̱n na xíꞌin táꞌan na. ");
INSERT INTO mim_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ta ni̱to̱nda̱a ki̱vi̱ sondíꞌí viko̱ yóꞌo, ta mi̱i ñayóꞌo kúu ki̱vi̱ káꞌno ní ka̱. Ta saá na̱kundichi ta̱Jesús, ta xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Ndiꞌi ni̱vi na yíchi̱ ní takuií, va̱ꞌa kixi na no̱o̱ i̱, ta taxi i̱ takuií koꞌo na. ");
INSERT INTO mim_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ta ni̱vi na kandixa yi̱ꞌi̱, ta ini nayóꞌo kaku takuií tá táku̱, ta na̱ndika takuií yóꞌo kua̱ꞌa̱n rá, ta nduu rá kua̱ꞌa̱ ní yu̱ta náꞌno, chi saá káchí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kua̱ꞌa̱ ní yu̱ta náꞌno xíꞌin takuií tá táku̱ yóꞌo káꞌa̱n ña xa̱ꞌa̱ Níma̱ Ndios ña nakiꞌin ni̱vi na kandixa ta̱Jesús. Ta ki̱vi̱ ni̱ka̱ꞌa̱n ra ñayóꞌo, ta o̱n ta̱ꞌán ka̱ nakiꞌin ni̱vi Níma̱ Ndios saá, chi o̱n ta̱ꞌán to̱nda̱a ki̱vi̱ ña ndi̱kó ta̱Jesús ñoyívi ni̱no no̱o̱ yóo ñalivi káꞌno xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tá xi̱ni̱ so̱ꞌo na ña káꞌa̱n ta̱Jesús, ta sava ni̱vi ni̱ka̱ꞌa̱n na, káchí na saá: ―Ñanda̱a̱ kía̱ ta̱yóꞌo kúu ta̱profeta káꞌno ta̱ ndáti ndi̱ kixaa̱ ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ta inka̱ na káꞌa̱n, káchí na saá: ―Ta̱yóꞌo kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ra mi̱i yó ―káchí na. Ta sava na káꞌa̱n: ―O̱n ki̱ví kuu ta̱yóꞌo Cristo chi Cristo o̱n ki̱ví kuu ra ta̱ ki̱xi ñoo estado Galilea. ");
INSERT INTO mim_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","To̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá káchí ña Cristo kuu ra ñii sa̱ꞌya ñani síkuá ta̱rey David, ta kaku ra ñoo Belén ña nákaa̱ estado Judea no̱o̱ xi̱taku̱ ta̱rey David, káchí to̱ꞌon Ndios ―káchí na, káꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ta saá ki̱xáꞌá na náta̱ꞌvi̱ táꞌan na xa̱ꞌa̱ ta̱Jesús, chi o̱n vása kúchiño ñii koo yuꞌú na xa̱ꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sava na kóni na tiin na ra ña ko̱ꞌo̱n ra veꞌe ka̱a, ta nda̱ ñii na ni̱‑kuchiño ña to̱nda̱a na tiin na ra. ");
INSERT INTO mim_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ta saá napolicía ndi̱kó na ki̱xaa̱ na no̱o̱ ndóo nafariseo xíꞌin inka̱ nanáꞌno no̱o̱ nasu̱tu̱. Ta nayóꞌo ni̱nda̱ka̱ to̱ꞌon na napolicía yóꞌo: ―¿Nda̱chun ni̱‑tiin ndó ta̱Jesús kixi ra yóꞌo xíꞌin ndó? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ta nda̱kuii̱n napolicía ni̱ka̱ꞌa̱n na: ―Nda̱ ñii yichi̱ o̱n ta̱ꞌán koni̱ so̱ꞌo ndi̱ ñii ta̱a káꞌa̱n ra to̱ꞌon nda̱tán káꞌa̱n ta̱yóꞌo ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ta nda̱kuii̱n nafariseo, ni̱ka̱ꞌa̱n na, káchí na saá: ―¿Án xa sa̱ndáꞌví ra ndóꞌó? ");
INSERT INTO mim_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Chi nda̱ ñii nanáꞌno ñoo yóꞌo, ta nda̱ ñii mi̱i ndi̱ nafariseo o̱n vása kándixa ndi̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ta ni̱vi na chíkaa̱ so̱ꞌo ña káꞌa̱n ra, nayóꞌo kúu na o̱n vása xíni̱ va̱ꞌa nda̱yí Ndios ña ni̱taa ta̱Moisés, ta ni̱vi na ni̱ta̱vi̱ chiꞌña kúu nayóꞌo ―káchí nafariseo xíꞌin napolicía. ");
INSERT INTO mim_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ta ñii ta̱fariseo ta̱ yóo xíꞌin nayóꞌo kúu ta̱Nicodemo, ta ta̱yóꞌo kúu ta̱a ta̱ ya̱chi̱ ka̱ ni̱xa̱ꞌa̱n ra ñii ñoó no̱o̱ ta̱Jesús. Ta vitin káꞌa̱n ra xíꞌin nafariseo yóꞌo, káchí ra saá: ");
INSERT INTO mim_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Nda̱yí Ndios ña ni̱taa ta̱Moisés ña kándixa yó káchí ña saá: Tá yóo ni̱vi taxi kua̱chi xa̱ꞌa̱ ñii ta̱a, ta saá siꞌna nachiño xíni̱ ñóꞌó koni̱ so̱ꞌo na to̱ꞌon ña ka̱ꞌa̱n mi̱i ra ndakuii̱n ra xa̱ꞌa̱ ra. Ta saá nachiño kuchiño kasa nani na xa̱ꞌa̱ ra án ndíso ra kua̱chi. Saá káchí nda̱yí ña kándixa yó ―káchí ta̱Nicodemo xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na xíꞌin ra: ―¿Án yóꞌó kúu ta̱táꞌan ra? ¿Án ta̱ñoo Galilea kúu yóꞌó xíꞌin ra? Xíni̱ ñóꞌó kaꞌvi va̱ꞌa ún to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá, ta saá kunda̱a̱ ini ún ndí nda̱ ñii ta̱profeta o̱n ta̱ꞌán kee ra ñoo estado Galilea ―káchí na xíꞌin ta̱Nicodemo. ");
INSERT INTO mim_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ta saá ke̱e ndiꞌi na kua̱noꞌo̱ na veꞌe na. ");
INSERT INTO mim_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ta ta̱Jesús kua̱ꞌa̱n ra, ta kua̱ꞌa̱n ndaa ra ñii xi̱ki̱ ña na̱ní Xi̱ki̱ tón Olivo. ");
INSERT INTO mim_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ta ni̱ti̱vi xita̱a̱n inka̱ ki̱vi̱, ta ndi̱kó ta̱Jesús, ki̱xaa̱ ra veꞌe ño̱ꞌo káꞌno ñoo Jerusalén. Ta saá ki̱xaa̱ ñii tiꞌvi káꞌno ni̱vi no̱o̱ ra, ta xi̱koo ra, ta ki̱xáꞌá ra sánáꞌa ra ni̱vi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ta saá sava nafariseo xíꞌin nata̱a na sánáꞌa nda̱yí Ndios ña ni̱taa ta̱Moisés kui̱ya̱ xi̱na̱ꞌá, va̱xi na no̱o̱ ta̱Jesús. Ta ki̱xaa̱ na no̱o̱ ra xíꞌin ñii ñaꞌa̱, ñá ti̱in na, chi na̱níꞌi na ñá táꞌan mi̱i kíꞌvi ñá kua̱chi xíꞌin ñii ta̱a ta̱ o̱n si̱ví yii̱ ñá kúu, káchí na. Ta ka̱ni ndichi na ñáñaꞌa̱ yóꞌo ma̱ꞌñó no̱o̱ ndóo kua̱ꞌa̱ ní ni̱vi, yatin no̱o̱ yóo ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ta saá nafariseo xíꞌin nata̱a na sánáꞌa nda̱yí ni̱ka̱ꞌa̱n na xíꞌin ta̱Jesús, káchí na saá: ―Tata maestro, na̱níꞌi ndi̱ ñáñaꞌa̱ yóꞌo táꞌan mi̱i kíꞌvi ñá kua̱chi xíꞌin ñii ta̱a ta̱ o̱n si̱ví yii̱ ñá kúu. ");
INSERT INTO mim_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ta nda̱yí Ndios ña ni̱taa ta̱Moisés xi̱na̱ꞌá xáꞌnda chiño ña ndí xíni̱ ñóꞌó koon yó yu̱u̱ ndiꞌi náñaꞌa̱ ná kéꞌé saá, a̱nda̱ kivi̱ ná. Ta yóꞌó, ¿yukía̱ káchí ún xa̱ꞌa̱ ñayóꞌo? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Saá ni̱nda̱ka̱ to̱ꞌon na ta̱Jesús chi ndúkú na ña nakava ra kua̱chi, ña̱kán kuchiño na taxi na kua̱chi xa̱ꞌa̱ ra no̱o̱ nachiño. Ta ta̱Jesús o̱n vása ní‑ndakuii̱n ra yuꞌu̱ na, ta chi̱ndee ra no̱o̱ ra, ta xíꞌin nduku ndaꞌa̱ ra, ki̱xáꞌá ra táa ra no̱o̱ ñoꞌo̱. ");
INSERT INTO mim_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ta tuku tuku ndáka̱ to̱ꞌon na yu kúu ña keꞌé na xíꞌin ñáñaꞌa̱ yóꞌo. Ta saá ta̱Jesús nda̱níꞌi ra no̱o̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―Yukú ndóꞌó na o̱n ko̱ó nda̱ ñii kua̱chi kómí, ta vitin kuu ndó nano̱ó sakana yu̱u̱ sa̱ta̱ ñáñaꞌa̱ yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ta tuku chi̱ndee ra no̱o̱ ra, ta ta̱a ra xíꞌin nduku ndaꞌa̱ ra no̱o̱ ñoꞌo̱. ");
INSERT INTO mim_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ta ni̱vi yóꞌo xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ra xíꞌin na, ta saá ñii ñii na ke̱e na kua̱ꞌa̱n na. Siꞌna ke̱e na xi̱kua̱ꞌa̱ ní ka̱, ta saá xi̱kundiko̱n ndiꞌi inka̱ na, kua̱ꞌa̱n na. Ta saá si̱ín la̱á kuiti ñáñaꞌa̱ yóꞌo ni̱ndo̱o ñíndichi no̱o̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ta ta̱Jesús nda̱níꞌi ra no̱o̱ ra, ta ni̱nda̱ka̱ to̱ꞌon ra ñáñaꞌa̱ yóꞌo, káchí ra xíꞌin ñá: ―Nana, ¿míchí kua̱ꞌa̱n ni̱vi na chi̱kaa̱ kua̱chi sa̱ta̱ ún? ¿Án o̱n ko̱ó nda̱ ñii nayóꞌo yíta na káꞌa̱n na ndí xíni̱ ñóꞌó kivi̱ ún? ―káchí ra xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ta nda̱kuii̱n ñá, ni̱ka̱ꞌa̱n ñá: ―O̱n ko̱ó ka̱ nda̱ ñii ni̱vi na káꞌa̱n xíni̱ ñóꞌó kivi̱ i̱ yíta yóꞌo, Tata. Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra saá: ―Ta ni yi̱ꞌi̱, o̱n ka̱ꞌa̱n i̱ ndí xíni̱ ñóꞌó kivi̱ ún, nana. Ta vitin kua̱noꞌo̱ ún, ta o̱n ki̱ꞌvi ka̱ ún kua̱chi ―káchí ta̱Jesús xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ta saá ta̱Jesús tuku ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi na ndóo veꞌe ño̱ꞌo yóꞌo: ―Yi̱ꞌi̱ kúu ñoꞌo̱ ndinoꞌo yéꞌe no̱o̱ ni̱vi ñoyívi. Ta ndiꞌi ni̱vi na kundiko̱n yi̱ꞌi̱, o̱n ko̱ꞌo̱n ka̱ na yichi̱ naa ní ña o̱n váꞌa, chi kukomí na ñoꞌo̱ ndinoꞌo ña taxi kutaku̱ ndinoꞌo na ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ta nafariseo ni̱ka̱ꞌa̱n na xíꞌin ra, káchí na saá: ―Ndasaá kuiti mi̱i ún káꞌa̱n ún ndákuii̱n ún xa̱ꞌa̱ ún, ta o̱n ko̱ó inka̱ ni̱vi ndákuii̱n xa̱ꞌa̱ ún. Ta saá ña káꞌa̱n ún xa̱ꞌa̱ mi̱i ún, o̱n vása ndáya̱ꞌví ña no̱o̱ ndi̱ ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Vará ndákuii̱n i̱ xa̱ꞌa̱ mi̱i i̱, ta saá ni, ña ndáya̱ꞌví kúu to̱ꞌon ña káꞌa̱n i̱, chi xíni̱ va̱ꞌa i̱ míchí ki̱xi i̱, ta xíni̱ va̱ꞌa i̱ míchí ko̱ꞌo̱n i̱. Ta ndóꞌó, o̱n vása xíni̱ ndó míchí ki̱xi i̱, ta ni o̱n vása xíni̱ ndó míchí ko̱ꞌo̱n i̱. ");
INSERT INTO mim_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ta ndóꞌó, ndasaá kuiti xíꞌin ñandíchí si̱ni̱ ni̱vi kísa nani ndó xa̱ꞌa̱ kua̱chi inka̱ ni̱vi. Ta yi̱ꞌi̱, o̱n vása kísa nani i̱ xa̱ꞌa̱ kua̱chi nda̱ ñii ni̱vi vitin. ");
INSERT INTO mim_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ta saá ni, táná kasa nani i̱ xa̱ꞌa̱ kua̱chi ni̱vi, ta xíꞌin ña ndixa nda̱a̱ keꞌé i̱ saá. Chi o̱n si̱ví ñii la̱á mi̱i i̱ kasa nani i̱ xa̱ꞌa̱ kua̱chi ni̱vi, ta Yivá i̱ Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱, ñii yóo ra xíꞌin i̱ ña kasa nani ndi̱ xa̱ꞌa̱ kua̱chi ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yóo nda̱yí ña kísa ndivi ndó ña káchí ndí xíni̱ ñóꞌó koo o̱vi̱ ni̱vi, tá ñii koo yuꞌú to̱ꞌon ña ndakuii̱n na o̱vi̱ yóꞌo, ta saá va̱ꞌa kandixa yó ña káꞌa̱n na, chi saá kísa nda̱a̱ na xa̱ꞌa̱ kua̱chi, káchí nda̱yí ña kísa ndivi ndó. ");
INSERT INTO mim_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ta yi̱ꞌi̱ kúu ñii ta̱a ta̱ ndákuii̱n xa̱ꞌa̱ mi̱i i̱, ta Yivá i̱, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱, kúu inka̱ ta̱ ndákuii̱n xa̱ꞌa̱ i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ta saá ni̱nda̱ka̱ to̱ꞌon na ra, káchí na saá xíꞌin ra: ―¿Míkía̱ yóo Yivá ún? ―káchí na. Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―O̱n vása xíni̱ ndó yi̱ꞌi̱, ni o̱n vása xíni̱ ndó Yivá i̱. Tá kunda̱a̱ ini ndó yu kúu i̱, níkúu, ta saá ndixa kunda̱a̱ ini ndó yu kúu Yivá i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ndiꞌi to̱ꞌon yóꞌo ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na ki̱vi̱ yóo ra veꞌe ño̱ꞌo káꞌno ñoo Jerusalén, chi yóo ra sánáꞌa ra ni̱vi na ndóo yatin no̱o̱ yíta caja no̱o̱ táan na si̱ꞌún ña sóko̱ ni̱vi no̱o̱ Ndios. Ta nda̱ ñii ni̱vi ni̱‑tiin na ra ña nataxi na ra ndaꞌa̱ nachiño, chi o̱n ta̱ꞌán to̱nda̱a ki̱vi̱ chitóni̱ Ndios saá keꞌé na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ya̱chi̱ ní kee i̱ ko̱ꞌo̱n i̱, ta ndóꞌó nandukú ndó yi̱ꞌi̱, ta o̱n kuchiño ndó naníꞌi ndó yi̱ꞌi̱. Saá chi o̱n xi̱in ndó ndikó ini ndó xa̱ꞌa̱ kua̱chi ndíso ndó, ta ndixa kivi̱ ndó xíꞌin kua̱chi ndíso ndó. Ta saá o̱n ki̱ví ko̱ꞌo̱n ndó ta xaa̱ ndó no̱o̱ ko̱ꞌo̱n i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ta nanáꞌno no̱o̱ najudío káꞌa̱n na xíꞌin táꞌan na, káchí na saá: ―O̱n ki̱ví ko̱ꞌo̱n yó no̱o̱ ko̱ꞌo̱n ra, káchí ra. ¿Án xáni si̱ni̱ ra kaꞌni xíꞌin mi̱i ra, ña̱kán ni̱ka̱ꞌa̱n ra saá? ―káchí na káꞌa̱n na xíꞌin táꞌan na. ");
INSERT INTO mim_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na, káchí ra saá: ―Ndiꞌi ndóꞌó kúu ndó ni̱vi ñoyívi yóꞌo, ta ndasaá kuiti ndíko̱n ndó yichi̱ ñoyívi yóꞌo. Ta yi̱ꞌi̱, ta̱a ta̱ ke̱e ñoyívi ni̱no kúu i̱, ta o̱n vása ndíko̱n i̱ yichi̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Xa nda̱to̱ꞌon i̱ xíꞌin ndó ndixa kivi̱ ndó xíꞌin kua̱chi ndíso ndó. Saá chi tá o̱n vása kándixa ndó to̱ꞌon ña nda̱to̱ꞌon i̱ xa̱ꞌa̱ i̱ xíꞌin ndó yu kúu yi̱ꞌi̱, ta ndixa kivi̱ ndó xíꞌin kua̱chi ndíso ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ta saá ni̱ka̱ꞌa̱n na xíꞌin ra: ―Ta yóꞌó, ¿yu kúu ún? ―káchí na xíꞌin ra. Ta nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta̱nda̱ ki̱vi̱ ki̱xáꞌá i̱ káꞌa̱n i̱ xíꞌin ndó, xa ndáto̱ꞌon i̱ xíꞌin ndó yu kúu i̱. ");
INSERT INTO mim_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yóo kua̱ꞌa̱ ní ña kúchiño ka̱ꞌa̱n i̱ xíꞌin ndó xa̱ꞌa̱ ña o̱n váꞌa kéꞌé ndó. Saá chi ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ va̱xi i̱ kúu ta̱nda̱a̱ ndinoꞌo, ta ñii ki̱ꞌva saá nda̱tán yóo to̱ꞌon ña xíni̱ so̱ꞌo i̱ káꞌa̱n ra, saá yóo ña káꞌa̱n i̱ xíꞌin ni̱vi ñoyívi yóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ta ni̱vi yóꞌo o̱n vása ní‑kunda̱a̱ ini na ndí ta̱Jesús káꞌa̱n ra xa̱ꞌa̱ Yivá ra Ndios. ");
INSERT INTO mim_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ta saá ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin na, káchí ra: ―Ta ñii ki̱vi̱ tiin ndó yi̱ꞌi̱ ta ndaníꞌi ndó yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, ta katakaa̱ ndaa ndó yi̱ꞌi̱ ñii no̱o̱ síkón. Ta saá kunda̱a̱ ini ndó yu kúu i̱. Ta ki̱vi̱ yóꞌo ndixa kunda̱a̱ ini ndó ndí nda̱ ñii chiño o̱n vása kísa ndivi matóꞌón i̱ ña, ta ni o̱n vása káꞌa̱n i̱ to̱ꞌon ña va̱xi kuiti si̱ni̱ mi̱i i̱. Ndasaá kuiti to̱ꞌon ña káꞌa̱n Yivá i̱ xíꞌin i̱, ñayóꞌo kúu ña káꞌa̱n i̱ xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ va̱xi i̱, yóo ra xíꞌin i̱ ndiꞌi saá ki̱vi̱, ta nda̱ ñii ki̱vi̱ o̱n vása sándakoo matóꞌón ra yi̱ꞌi̱, chi ndiꞌi saá ki̱vi̱ kísa ndivi i̱ chiño ña kúsii̱ ini ra xíni ra ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tá xíni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ra, ta kua̱ꞌa̱ ní ni̱vi na ndóo yóꞌo ka̱ndixa na ra. ");
INSERT INTO mim_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin najudío na xa ka̱ndixa ñaꞌá: ―Ta ndóꞌó, tá ñii ñii ki̱vi̱ va̱xi chikaa̱ so̱ꞌo ndó to̱ꞌon i̱, ta kasa ndivi ndó to̱ꞌon ña sánáꞌa i̱ ndóꞌó, ta saá kuu ndó ni̱vi na ndinoꞌo ini ndíko̱n ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ta saá koni̱ va̱ꞌa ndó yu kúu ña ndixa nda̱a̱ ndinoꞌo, ta ñanda̱a̱ ndinoꞌo yóꞌo kúu ña saña ndó ña kuchiño ko̱ꞌo̱n ndíka̱ ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na, káchí na saá: ―Ndi̱ꞌi̱ kúu ndi̱ sa̱ꞌya ñani síkuá ta̱Abraham, ta nda̱ ñii ki̱vi̱ o̱n vása ní‑xikuu ndi̱ namozo na o̱n vása kómí nda̱yí sandakoo na chiño ña kísa chiño na no̱o̱ napatrón na. ¿Nda̱chun káꞌa̱n ún xíꞌin ndi̱ ñii ki̱vi̱ va̱xi sa̱ña̱ ndi̱ ko̱ꞌo̱n ndíka̱ ndi̱? ");
INSERT INTO mim_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ña ndixa nda̱a̱ kúu to̱ꞌon káꞌa̱n i̱ xíꞌin ndó: Ndiꞌi ni̱vi na kéꞌé ña o̱n váꞌa, nayóꞌo yóo na nda̱tán yóo namozo na kísa chiño no̱o̱ ña o̱n váꞌa, chi ña o̱n váꞌa yóꞌo kúu ña xáꞌnda chiño no̱o̱ na. ");
INSERT INTO mim_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nda̱ ñii ni̱vi na ndasaá kuiti kísa chiño no̱o̱ ta̱káꞌno, o̱n vása kómí nayóꞌo nda̱yí kutaku̱ na veꞌe ta̱káꞌno ndiꞌi saá ki̱vi̱ ña va̱xi. Ta ta̱a ta̱ kúu sa̱ꞌya mi̱i ta̱káꞌno xíꞌin veꞌe, ndixa kómí ta̱yóꞌo nda̱yí kutaku̱ ra veꞌe yivá ra ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ta saá ndixa tá Sa̱ꞌya mi̱i Ta̱a ta̱Káꞌno kúu ta̱a ta̱ saña ndóꞌó ko̱ꞌo̱n ndíka̱ ndó no̱o̱ ña o̱n váꞌa, ta mi̱i ña ndixa nda̱a̱ ko̱ꞌo̱n ndíka̱ ndó, ta ña o̱n váꞌa o̱n kukomí ka̱ ña nda̱yí kaꞌnda chiño ña no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Xíni̱ va̱ꞌa i̱ ndóꞌó kúu ndó sa̱ꞌya ñani síkuá ta̱Abraham. Ta saá ni, kóni ndó kaꞌni ndó yi̱ꞌi̱, chi o̱n xi̱in ndó nakiꞌin va̱ꞌa ndó to̱ꞌon i̱ ña kutaku̱ ña ini ndó. ");
INSERT INTO mim_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yi̱ꞌi̱ káꞌa̱n i̱ xíꞌin ndó ndasaá kuiti ña xi̱ni i̱ ta xi̱ni̱ so̱ꞌo i̱ no̱o̱ ni̱xi̱yo i̱ xíꞌin Yivá i̱. Ta ndóꞌó, kéꞌé ndó ndasaá kuiti ña xíni̱ so̱ꞌo ndó káꞌa̱n yivá ndó xíꞌin ndó ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na xíꞌin ta̱Jesús: ―Ta̱Abraham kúu yivá ndi̱ ―káchí na xíꞌin ra. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Tá sa̱ꞌya ndinoꞌo ta̱Abraham kúu ndó, ta saá ko̱ꞌo̱n ndó kundiko̱n ndó yichi̱ ra, níkúu. ");
INSERT INTO mim_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ta ndóꞌó, o̱n vása ndíko̱n ndó yichi̱ ta̱Abraham, chi kóni ndó kaꞌni ndó yi̱ꞌi̱, ta yi̱ꞌi̱ kúu ta̱a ta̱ káꞌa̱n to̱ꞌon ña nda̱a̱, ña kúu to̱ꞌon ña xi̱ni̱ so̱ꞌo i̱ ni̱ka̱ꞌa̱n Ndios xíꞌin i̱. Ta ta̱Abraham, o̱n vása ní‑keꞌé ra nda̱tán kéꞌé ndó vitin. ");
INSERT INTO mim_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ta ndóꞌó, kéꞌé ndó nda̱tán yóo ña kéꞌé mi̱i yivá ndó ―káchí ra xíꞌin na. ―O̱n si̱ví sa̱ꞌya sáká kúu ndi̱. Chi xíni̱ ndi̱ ñii la̱á kúu yivá ndi̱, ta̱ kúu Ndios ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Tá ndixa Ndios kúu yivá ndó, ta saá kukiꞌvi ini ndó koni ndó yi̱ꞌi̱, chi yi̱ꞌi̱ ke̱e i̱ no̱o̱ Ndios, ta ki̱xaa̱ i̱ yóo i̱ yóꞌo vitin. Ta o̱n vása ní‑kixaa̱ i̱ xíꞌin nda̱yí mi̱i i̱, ta xíꞌin nda̱yí Ndios ki̱xaa̱ i̱, chi Ndios kúu ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ va̱xi i̱. ");
INSERT INTO mim_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Nda̱chun o̱n vása kúnda̱a̱ ini ndó to̱ꞌon ña káꞌa̱n i̱ xíꞌin ndó? O̱n vása kúchiño ndó kunda̱a̱ ini ndó chi o̱n xi̱in ndó chikaa̱ so̱ꞌo ndó to̱ꞌon i̱. ");
INSERT INTO mim_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Saá chi yivá ndó kúu ñaníma̱ ndiva̱ꞌa káꞌno, ta ndóꞌó kóni ndó kasa ndivi ndó ña o̱n váꞌa ña sakusii̱ ndó ini yivá ndó. Ta̱nda̱ ki̱xáꞌá ki̱vi̱ no̱ó ta̱nda̱ vitin ñaníma̱ ndiva̱ꞌa káꞌno yóꞌo kúu ña xáꞌni ni̱vi. Ta ñandiva̱ꞌa káꞌno yóꞌo, nda̱ loꞌo o̱n vása ndíko̱n ña yichi̱ nda̱a̱, saá chi nda̱ loꞌo o̱n vása yóo ña ndixa nda̱a̱ ini ña. To̱ꞌon ña vatá káꞌa̱n ña kúu to̱ꞌon ña káku ini mi̱i ña, chi ndixa nina ñavatá kuiti kúu ñaníma̱ ndiva̱ꞌa káꞌno, ta kúu ña yivá ndiꞌi ñavatá. ");
INSERT INTO mim_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ta yi̱ꞌi̱, káꞌa̱n i̱ ñanda̱a̱ xíꞌin ndó, ta xa̱ꞌa̱ ñayóꞌo, o̱n xi̱in ndó kandixa ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Án yóo ñii ndóꞌó na kúchiño naníꞌi ndó ta kasa nda̱a̱ ndó xa̱ꞌa̱ ñii ña o̱n váꞌa ke̱ꞌé i̱? Tá to̱ꞌon ña ndixa nda̱a̱ kúu ña káꞌa̱n i̱ xíꞌin ndó, ta saá, ¿nda̱chun o̱n xi̱in ndó kandixa ndó to̱ꞌon káꞌa̱n i̱? ");
INSERT INTO mim_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ndiꞌi ni̱vi na kúu sa̱ꞌya ndinoꞌo Ndios chíkaa̱ so̱ꞌo na to̱ꞌon ña káꞌa̱n ra. Ta ndóꞌó, o̱n si̱ví sa̱ꞌya Ndios kúu ndó, ña̱kán o̱n vása chíkaa̱ so̱ꞌo ndó to̱ꞌon ña káꞌa̱n Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ta nda̱kuii̱n sava najudío, ni̱ka̱ꞌa̱n na xíꞌin ta̱Jesús, káchí na saá: ―¿Án o̱n si̱ví ndixa yóꞌó kúu ún ta̱ñoo Samaria? ¿Án o̱n si̱ví ndixa kúu ún ta̱a ta̱ kómí ñii ñaníma̱ ndiva̱ꞌa ña sáka ní si̱ni̱ ún? ");
INSERT INTO mim_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―O̱n ko̱ó níma̱ ndiva̱ꞌa kómí i̱, ta ndixa kísa to̱ꞌó i̱ Yivá i̱ Ndios. Ta ndóꞌó, nda̱ loꞌo o̱n vása kísa to̱ꞌó ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ta o̱n vása ndúkú i̱ ña kasa káꞌno ni̱vi yi̱ꞌi̱. Ta saá ni, yóo inka̱ Ta̱a ta̱Káꞌno, ta ta̱yóꞌo kúu ta̱ ndúkú ña kasa káꞌno ni̱vi yi̱ꞌi̱, ta mi̱i ra kúu ta̱ kísa nani xa̱ꞌa̱ kua̱chi xíꞌin ñanda̱a̱. ");
INSERT INTO mim_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ña ndixa nda̱a̱ káꞌa̱n i̱ ndí ndiꞌi ni̱vi na chíkaa̱ so̱ꞌo to̱ꞌon ña sánáꞌa i̱, o̱n kivi̱ nayóꞌo, ta kutaku̱ na ndiꞌi saá ki̱vi̱ va̱xi ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ta saá najudío ni̱ka̱ꞌa̱n na xíꞌin ra, káchí na saá: ―Vitin xíni̱ va̱ꞌa ndi̱ ndí ndixa kómí ún níma̱ ndiva̱ꞌa, chi nina to̱ꞌon sána káꞌa̱n ún. Saá chi mi̱i ta̱xi̱i̱ síkuá yó ta̱Abraham xíꞌin ndiꞌi inka̱ naprofeta na ni̱ka̱ꞌa̱n to̱ꞌon Ndios xi̱na̱ꞌá, nayóꞌo ni̱xiꞌi̱ ndiꞌi na. Ta yóꞌó, káchí ún ña táná chikaa̱ so̱ꞌo ni̱vi to̱ꞌon ña sánáꞌa ún, ta nda̱ ñii ki̱vi̱ o̱n kivi̱ na. ");
INSERT INTO mim_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Án xáni si̱ni̱ ún kúu ún ta̱ káꞌno ka̱ no̱o̱ ta̱Abraham, xi̱i̱ síkuá yó? ¿Án xáni si̱ni̱ ún kúu ún ta̱ káꞌno ka̱ no̱o̱ inka̱ naprofeta? Ndiꞌi nayóꞌo, xa ni̱xiꞌi̱ na. ¿Yu kúu yóꞌó, ña̱kán kísa káꞌno xíꞌin mi̱i ún? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ta yi̱ꞌi̱, táná kasa káꞌno xíꞌin mi̱i i̱, ta o̱n vása ndáya̱ꞌví ña kéꞌé i̱ saá. Ta Yivá i̱ kúu ta̱a ta̱ kísa káꞌno yi̱ꞌi̱, ta Yivá i̱ yóꞌo kúu Ndios ta̱a ta̱ kísa káꞌno ndó, káchí ndó. ");
INSERT INTO mim_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ta ndóꞌó, o̱n vása xíni̱ ndó Yivá i̱ Ndios, ta yi̱ꞌi̱ xíni̱ va̱ꞌa i̱ ra. Chi tá yi̱ꞌi̱ ná ka̱ꞌa̱n i̱ o̱n vása xíni̱ i̱ ra, ta kuu i̱ ñii ta̱a ta̱ káꞌa̱n to̱ꞌon vatá kuiti, ñii ki̱ꞌva nda̱tán yóo mi̱i ndó káꞌa̱n ndó nina to̱ꞌon vatá. Ta ña ndixa nda̱a̱ kúu ña xíni̱ va̱ꞌa i̱ Yivá i̱ Ndios ta chíkaa̱ so̱ꞌo i̱ to̱ꞌon káꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kui̱ya̱ xi̱na̱ꞌá ta̱xi̱i̱ síkuá ndó ta̱Abraham kúsii̱ ní ini ra xa̱ꞌa̱ ña ni̱ka̱ꞌa̱n Ndios xíꞌin ra ndí koto ra ña kixaa̱ i̱ ñoyívi yóꞌo. Ta saá ndixa xi̱ni ta̱Abraham ki̱xaa̱ i̱ ñoyívi yóꞌo, ta ku̱sii̱ ní ini ra xi̱ni ra ñayóꞌo ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ta ni̱ka̱ꞌa̱n najudío xíꞌin ta̱Jesús, káchí na saá: ―Ni o̱n ta̱ꞌán kukomí ún o̱vi̱ si̱ko̱ u̱xu̱ kui̱ya̱, ta káꞌa̱n ún xa xi̱ni ún ta̱Abraham. ¿Ndasaá kuchiño kandixa ndi̱ ña káꞌa̱n ún? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó ndí ki̱vi̱ o̱n ta̱ꞌán ka̱ kaku ta̱Abraham, xa yóo i̱ ta xa táku̱ i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tá ndi̱ꞌi xi̱ni̱ so̱ꞌo na to̱ꞌon yóꞌo, ta ni̱saa̱ ní ka̱ ini na xi̱ni na ta̱Jesús, ta ki̱xáꞌá na tíin na yu̱u̱, ña kóni na koon na yu̱u̱ ra ña kaꞌni na ra. Ta ta̱Jesús ni̱ki̱ꞌvi ra ma̱ꞌñó ni̱vi, ta ni̱‑kuchiño na koni ka̱ na ra, ta ke̱e ra veꞌe ño̱ꞌo káꞌno kua̱ꞌa̱n ra. ");
INSERT INTO mim_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ta ta̱Jesús xíka ra kua̱ꞌa̱n ra, ta na̱kutáꞌan ra xíꞌin ñii ta̱a ta̱kuáá. Ta ta̱yóꞌo, ta̱kuáá nduchu̱ no̱o̱ kúu ra ka̱ku ra. ");
INSERT INTO mim_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ta naxíka xíꞌin ta̱Jesús ni̱nda̱ka̱ to̱ꞌon na ra, káchí na saá: ―Tata Rabí, ¿yukú na ndíso kua̱chi, xa̱ꞌa̱ ña ka̱ku ta̱yóꞌo kuáá nduchu̱ no̱o̱ ra? ¿Án yivá ra xíꞌin siꞌí ra, án mi̱i ra ndíso kua̱chi xa̱ꞌa̱ ña ka̱ku kuáá ra? ");
INSERT INTO mim_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―O̱n si̱ví kua̱chi mi̱i ra kúu ña, ni o̱n si̱ví kua̱chi yivá ra xíꞌin siꞌí ra kúu ña ka̱ku ra saá. Ta̱yóꞌo ka̱ku kuáá ra xa̱ꞌa̱ ña kuchiño koto ni̱vi chiño va̱ꞌa ña kasa ndivi Ndios xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Vitin kúu ki̱vi̱ ndiví yéꞌe ño̱ꞌo, ta xíni̱ ñóꞌó yó kasa ndivi yó chiño Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ kixaa̱ i̱. Saá chi va̱xi ña kuñoó, ta saá tá kixaa̱ ñanaa ní, ta nda̱ ñii ni̱vi o̱n kívi ka̱ kasa chiño na. ");
INSERT INTO mim_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ta ndiꞌi ki̱vi̱ ña yóo ka̱ i̱ ñoyívi yóꞌo, yi̱ꞌi̱ kúu i̱ ñoꞌo̱ yéꞌe no̱o̱ ndiꞌi ni̱vi ná sanáꞌa i̱ yichi̱ ña nda̱a̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ta saá ta̱Jesús, chi̱kaa̱ ra tási̱i yuꞌu̱ ra no̱o̱ ñoꞌo̱ no̱o̱ ñíndichi ra, ta ki̱sa va̱ꞌa ra loꞌo nda̱ꞌyi̱ xíꞌin tási̱i yuꞌu̱ ra, ta chi̱nóo ra loꞌo nda̱ꞌyi̱ yóꞌo sa̱ta̱ ndio̱vi̱ nduchu̱ no̱o̱ ta̱kuáá yóꞌo, ");
INSERT INTO mim_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ta ni̱ka̱ꞌa̱n ra xíꞌin ta̱kuáá, káchí ra saá: ―Va̱ꞌa vitin kua̱ꞌa̱n ún pozo na̱ní Siloé, ta nakata ún nduchu̱ no̱o̱ ún xíꞌin takuií pozo yóꞌo ―káchí ta̱Jesús xíꞌin ra. (Ta to̱ꞌon Siloé kóni kachí ña: Ta̱a ta̱ ti̱ꞌví na kua̱ꞌa̱n.) Ta saá ke̱e ta̱kuáá kua̱ꞌa̱n ra no̱o̱ yóo pozo yóꞌo, ta ni̱xaa̱ ra, ta na̱kata ra nduchu̱ no̱o̱ ra xíꞌin takuií pozo. Ta saá ndi̱kó ra kua̱noꞌo̱ ra veꞌe ra, ta xa va̱ꞌa xíto nduchu̱ no̱o̱ ra, chi xa ndu̱va̱ꞌa ra. ");
INSERT INTO mim_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ta ni̱vi na táku̱ yatin no̱o̱ yóo ra, xíꞌin inka̱ ni̱vi na xi̱ni ñaꞌá ki̱vi̱ xi̱ndukú chiꞌña ra si̱ꞌún no̱o̱ na, nayóꞌo ni̱ka̱ꞌa̱n na, káchí na saá: ―¿Án o̱n si̱ví ta̱yóꞌo kúu ta̱a ta̱ ni̱xi̱yo xi̱ndukú chiꞌña si̱ꞌún no̱o̱ ni̱vi? ―káchí na, káꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","―Ndixa ta̱yóꞌo kúu ra ―káchí sava na. Ta inka̱ na ni̱ka̱ꞌa̱n: ―Óꞌon, o̱n si̱ví ta̱yóꞌo kúu ra, ndasaá kuiti náꞌa ra nda̱tán náꞌa ta̱ xi̱ndukú chiꞌña ―káchí na. Ta mi̱i ra, ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―Ndixa yi̱ꞌi̱ kúu ta̱a ta̱ xi̱kuu ta̱kuáá ta̱ xi̱ndukú chiꞌña ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ta saá ni̱nda̱ka̱ to̱ꞌon na ra, káchí na saá xíꞌin ra: ―¿Ndasaá va̱ꞌa xíto nduchu̱ no̱o̱ ún vitin? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ta nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra: ―Ta̱a ta̱ na̱ní Jesús ki̱sa va̱ꞌa ra loꞌo nda̱ꞌyi̱ ta chi̱nóo ndaa ra ña sa̱ta̱ nduchu̱ no̱o̱ i̱. Ta ni̱ka̱ꞌa̱n ra xíꞌin i̱ ko̱ꞌo̱n i̱ nakata i̱ no̱o̱ i̱ xíꞌin takuií tá ñóꞌo ini pozo Siloé. Tá ndi̱ꞌi ki̱sa ndivi i̱ ñayóꞌo, ta saá va̱ꞌa tívi xíto i̱ ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","―Ta vitin, ¿míkía̱ yóo ta̱ ke̱ꞌé saá xíꞌin ún? ―káchí na xíꞌin ra. ―O̱n vása xíni̱ i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ta ni̱vi kóni na ndí ta̱a ta̱ xi̱kuu ta̱kuáá yóꞌo ko̱ꞌo̱n ra xíꞌin na no̱o̱ nafariseo, ta saá ke̱e ra kua̱ꞌa̱n ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Saá chi ñii ki̱vi̱ yi̱i̱ ña nákindée najudío kúu ki̱vi̱ ña ta̱Jesús ki̱sa va̱ꞌa ra nda̱ꞌyi̱ ta chi̱nóo ra loꞌo ña sa̱ta̱ nduchu̱ no̱o̱ ta̱kuáá, ta va̱ꞌa náti̱vi xíto ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ta saá ni̱xaa̱ ra xíꞌin na, ta nafariseo ni̱nda̱ka̱ to̱ꞌon na ta̱a ta̱ xi̱kuu ta̱kuáá yóꞌo, káchí na xíꞌin ra: ―¿Ndasaá va̱ꞌa xíto nduchu̱ no̱o̱ ún? ―káchí na. Ta nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Chi̱nóo ndaa ra loꞌo nda̱ꞌyi̱ sa̱ta̱ nduchu̱ no̱o̱ i̱, ta saá na̱kata i̱ no̱o̱ i̱ xíꞌin takuií, ta xíꞌin ña ke̱ꞌé i̱ saá va̱ꞌa xíto i̱ vitin ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ta sava nafariseo ni̱ka̱ꞌa̱n na xíꞌin táꞌan na, káchí na saá: ―Ta̱a ta̱ ke̱ꞌé saá xíꞌin ta̱yóꞌo o̱n ki̱ví kuu ra ñii ta̱a ta̱ ki̱xi no̱o̱ Ndios, chi o̱n vása kísa to̱ꞌó ra nda̱yí Ndios ña káchí o̱n váꞌa kasa chiño yó ki̱vi̱ yi̱i̱ ―káchí na, káꞌa̱n na. Ta inka̱ na káꞌa̱n, káchí na saá: ―Ndixa ta̱a ta̱ va̱ꞌa kúu ra chi nda̱ ñii ta̱a ta̱ o̱n váꞌa o̱n kúchiño ra keꞌé ra milagro va̱ꞌa nda̱tán yóo ña kéꞌé ta̱yóꞌo ―káchí na. Ta saá o̱n vása kivi koo yuꞌú na xa̱ꞌa̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ta tuku ni̱nda̱ka̱ to̱ꞌon nafariseo ta̱a ta̱ xi̱kuu ta̱kuáá: ―Ta, ¿yukía̱ káchí yóꞌó xa̱ꞌa̱ ra? Chi yóꞌó kúu ta̱a ta̱ sa̱ndaꞌa ra nduchu̱ no̱o̱. Ta nda̱kuii̱n ta̱a ta̱ xi̱kuu ta̱kuáá, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ñii ta̱profeta kúu ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ta nanáꞌno no̱o̱ najudío o̱n xi̱in na kandixa na ndí ndixa ta̱yóꞌo xi̱kuu ta̱kuáá ta vitin ndu̱va̱ꞌa ra. Ta saá ka̱na na yivá ra xíꞌin siꞌí ra va̱xi na ña kasa nda̱a̱ na ndiꞌi ñayóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ta saá ni̱nda̱ka̱ to̱ꞌon na yivá ta̱yóꞌo xíꞌin siꞌí ra, káchí na saá: ―¿Án ña ndixa nda̱a̱ ta̱yóꞌo kúu sa̱ꞌya ndó? Chi ka̱ku ra kúu ra ta̱kuáá, káchí ndó, ta vitin, ¿nda̱chun va̱ꞌa xíto ra? ");
INSERT INTO mim_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ta nda̱kuii̱n yivá ra xíꞌin siꞌí ra, káchí na saá: ―Ndixa xíni̱ ndi̱ ta̱yóꞌo kúu sa̱ꞌya ndi̱, ta xíni̱ ndi̱ ta̱ ka̱ku kuáá kúu ra. ");
INSERT INTO mim_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ta o̱n vása xíni̱ ndi̱ nda̱chun va̱ꞌa xíto ra vitin, ni o̱n vása xíni̱ ndi̱ yu kúu ta̱a ta̱ sa̱ndaꞌa nduchu̱ no̱o̱ ra. Va̱ꞌa nda̱ka̱ to̱ꞌon ndó mi̱i sa̱ꞌya ndi̱ yóꞌo ndasaá yóo ña ndu̱va̱ꞌa nduchu̱ no̱o̱ ra, chi xa ta̱chée kúu mi̱i ra vitin, ta va̱ꞌa kúchiño ra ndakuii̱n ra xa̱ꞌa̱ mi̱i ra ―káchí na xíꞌin nanáꞌno no̱o̱ najudío yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ni̱ka̱ꞌa̱n yivá ra xíꞌin siꞌí ra saá, chi yíꞌví na ko̱to̱ nanáꞌno no̱o̱ najudío saxo̱ꞌvi̱ ñaꞌá na, chi nanáꞌno yóꞌo xa xa̱ꞌnda chiño na ndí nda̱ ñii ni̱vi o̱n ka̱ꞌa̱n na kachí na ndí ta̱Jesús kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios. Ta ndiꞌi ni̱vi na káꞌa̱n saá o̱n kívi ki̱ꞌvi ka̱ na ini veꞌe ño̱ꞌo sinagoga, ni o̱n kívi kutáꞌan ka̱ na xíꞌin inka̱ najudío, káchí nanáꞌno yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ta xa̱ꞌa̱ ña yi̱yo kundoꞌo na saá, yivá ta̱ xi̱kuu ta̱kuáá xíꞌin siꞌí ra nda̱kuii̱n na ni̱ka̱ꞌa̱n na: “Sa̱ꞌya ndi̱ xa kúu ra ta̱chée vitin, va̱ꞌa ka̱ nda̱ka̱ to̱ꞌon ndó mi̱i ra”, káchí na xíꞌin nanáꞌno no̱o̱ najudío. ");
INSERT INTO mim_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ta saá tuku ka̱na nafariseo ta̱a ta̱ xi̱kuu ta̱kuáá, ta ni̱ka̱ꞌa̱n na xíꞌin ra: ―Va̱ꞌa kasa káꞌno ún Ndios xa̱ꞌa̱ ña va̱ꞌa xíto nduchu̱ no̱o̱ ún. Saá chi mi̱i ndi̱, xíni̱ ndi̱ ña ta̱Jesús yóꞌo kúu ta̱a ta̱ kéꞌé ña o̱n váꞌa ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ta nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra saá: ―O̱n vása loꞌo xíni̱ i̱ tá ta̱a ta̱ kéꞌé ña o̱n váꞌa kúu ra. Ta ñii la̱á ñandixa xíni̱ va̱ꞌa i̱ kúu ñayóꞌo: ta̱kuáá xi̱kuu i̱, ta vitin va̱ꞌa xíto i̱ ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ta tuku ni̱nda̱ka̱ to̱ꞌon na ra: ―¿Yukía̱ ke̱ꞌé ra xíꞌin ún? ¿Ndasaá yóo ña va̱ꞌa xíto nduchu̱ no̱o̱ ún vitin? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ta tuku nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra, káchí ra saá xíꞌin na: ―Xa nda̱to̱ꞌon ndiꞌi i̱ xíꞌin ndó ndasaá ke̱ꞌé ra xíꞌin i̱, ta o̱n xi̱in ndó kandixa ndó ña ni̱ka̱ꞌa̱n i̱. ¿Nda̱chun kóni ndó tuku inka̱ yichi̱ ndato̱ꞌon i̱ xíꞌin ndó ndasaá ke̱ꞌé ra xíꞌin i̱? ¿Án saá tuku mi̱i ndó vitin kóni ndó kundiko̱n ndó ra xíꞌin i̱? ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tá ndi̱ꞌi xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱yóꞌo, ta ki̱xáꞌá na sáa̱ ní ini na xíni na ra, ta kándiva̱ꞌa na xíꞌin ra, káchí na saá: ―Yóꞌó kúu ta̱a ta̱ ndíko̱n sa̱ta̱ ta̱a ta̱ kéꞌé ña o̱n váꞌa yóꞌo. Ta ndi̱ꞌi̱ kúu na ndixa ndíko̱n yichi̱ ta̱Moisés, ta̱xi̱i̱ síkuá yó. ");
INSERT INTO mim_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Chi xíni̱ ndi̱ ndixa Ndios ni̱ka̱ꞌa̱n ra xíꞌin ta̱Moisés, ta ta̱Jesús yóꞌo, o̱n vása xíni̱ ndi̱ míchí ki̱xi ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ta nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra xíꞌin na, káchí ra saá: ―Ndixa nákaꞌnda ini i̱ xíni̱ so̱ꞌo i̱ to̱ꞌon káꞌa̱n ndó, chi káꞌa̱n ndó o̱n vása xíni̱ ndó míchí ki̱xi ra, ta ta̱yóꞌo kúu ta̱a ta̱ sa̱ndaꞌa nduchu̱ no̱o̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ta xíni̱ yó ndí Ndios o̱n vása chíkaa̱ so̱ꞌo ra to̱ꞌon ña káꞌa̱n ni̱vi na kéꞌé ña o̱n váꞌa. Ta Ndios ndixa chíkaa̱ so̱ꞌo ra to̱ꞌon ña káꞌa̱n ni̱vi na kísa to̱ꞌó ñaꞌá, na kúu na kísa ndivi ña kóni ra. ");
INSERT INTO mim_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ta̱nda̱ ki̱vi̱ no̱ó ku̱va̱ꞌa ñoyívi yóꞌo, ta̱nda̱ ki̱vi̱ vitin nda̱ ñii ni̱vi o̱n ta̱ꞌán koni̱ so̱ꞌo na xa̱ꞌa̱ ñii ta̱a ta̱ sa̱ndaꞌa nduchu̱ no̱o̱ ñii ta̱ ka̱ku kuáá, ta va̱ꞌa xíto ra. ");
INSERT INTO mim_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tá o̱n vása ní‑kixi ta̱a yóꞌo no̱o̱ Ndios, ta saá o̱n kóo ndee̱ kukomí ra keꞌé ra ñava̱ꞌa ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na xíꞌin ra: ―¡Ta̱a ta̱ kómí chiꞌña kúu yóꞌó! ¡Nda̱ ki̱vi̱ ka̱ku ún ta̱nda̱ vitin ta̱a ta̱ o̱n váꞌa kúu ún! ¿Án xáni si̱ni̱ ún kúu ún ta̱a ta̱ ndíchí ka̱, ña̱kán kóni ún sanáꞌa ún ndi̱ꞌi̱? ―káchí na xíꞌin ra. Ta saá ta̱xin va̱ꞌa na ra veꞌe ño̱ꞌo sinagoga, ta kua̱ꞌa̱n ra ke̱ꞌe. ");
INSERT INTO mim_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ki̱vi̱ xi̱ni̱ so̱ꞌo ta̱Jesús ña ta̱xin va̱ꞌa na ta̱a ta̱ xi̱kuu ta̱kuáá yóꞌo, ta o̱n taxi ka̱ na ki̱ꞌvi ra ini veꞌe ño̱ꞌo sinagoga, ta saá ta̱Jesús na̱ndukú ra ta̱yóꞌo, ta na̱níꞌi ñaꞌá ra, ta ni̱ka̱ꞌa̱n ra xíꞌin ra, káchí ra saá: ―¿Án kándixa ún ta̱a ta̱ ki̱xi no̱o̱ Ndios? ―káchí ra xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","―¿Yu kúu ta̱yóꞌo, tata? Ka̱ꞌa̱n ún xíꞌin i̱, chi kóni kandixa i̱ ra ―káchí ra, nda̱kuii̱n ra. ");
INSERT INTO mim_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ra: ―Xíꞌin nduchu̱ no̱o̱ ún xa xi̱ni ún ra, ta̱a ta̱ káꞌa̱n xíꞌin ún vitin kúu ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ta saá nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús: ―Tata, ta̱Káꞌno no̱o̱ i̱ kúu ún, kándixa i̱ yóꞌó ―káchí ra, ta ki̱sa káꞌno ñaꞌá ra. ");
INSERT INTO mim_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Ki̱xaa̱ i̱ ñoyívi yóꞌo xa̱ꞌa̱ ña sanati̱vi i̱ ndasaá yóo ini ni̱vi, án ni̱vi na kándixa ñanda̱a̱ kúu na, án ni̱vi na o̱n xi̱in kandixa ñanda̱a̱ kúu na. Ta saá ni̱vi na o̱n ki̱ví koto, chi ndixa nakuáá kúu na, sandaꞌa i̱ nduchu̱ no̱o̱ nayóꞌo ña va̱ꞌa koto na. Ta ni̱vi na va̱ꞌa xíto, tá o̱n xi̱in na kandixa na to̱ꞌon ña nda̱a̱, ta nayóꞌo kua̱ꞌa̱n na yichi̱ o̱n váꞌa ña kúu no̱o̱ naa, ta to̱nda̱a na koo na nda̱tán yóo ni̱vi nakuáá. ");
INSERT INTO mim_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ta sava nafariseo yíta na yóꞌo, ta xi̱ni̱ so̱ꞌo na ña ni̱ka̱ꞌa̱n ta̱Jesús, ta ni̱nda̱ka̱ to̱ꞌon na ra, káchí na saá xíꞌin ra: ―¿Án kóni ún kachí ún ndí ndi̱ꞌi̱ kúu ni̱vi nakuáá? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Tá ndixa ndóꞌó kúu ndó ni̱vi nakuáá, níkúu, ta saá o̱n vása ndíso ndó kua̱chi xa̱ꞌa̱ ña o̱n vása xíto nduchu̱ no̱o̱ ndó. Ta ndóꞌó, vará káchí ndó ndí va̱ꞌa ní xíto nduchu̱ no̱o̱ ndó, ta o̱n xi̱in ndó koto ndó ñanda̱a̱, ni o̱n xi̱in ndó kandixa ndó ña. Ta xa̱ꞌa̱ ñayóꞌo, ndíso ka̱ ndó kua̱chi no̱o̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ta saá ta̱Jesús nda̱to̱ꞌon ra ñii cuento ña sanáꞌa ra na, káchí ra saá xíꞌin na: ―Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó to̱ꞌon yóꞌo. Tá yóo ñii korra no̱o̱ kísi̱n tíndikachi, ta ki̱xaa̱ ñii ta̱a, ta ta̱yóꞌo na̱kundeé ra ki̱ꞌvi ra ñii xiiña no̱o̱ o̱n si̱ví yéꞌé kúu, ta ña ke̱ꞌé ra saá táxi ña kunda̱a̱ ini yó ndí ta̱yóꞌo o̱n si̱ví ta̱a ta̱ va̱ꞌa kúu ra, ta ta̱yóꞌo kúu ra ta̱a ta̱kuíꞌná. ");
INSERT INTO mim_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tá yóo inka̱ ta̱a ta̱ ki̱xaa̱, ta xíto yó ta̱yóꞌo kua̱n ki̱ꞌvi ra yéꞌé korra no̱o̱ ñóꞌo tíndikachi, ta saá kúnda̱a̱ ini yó ndí ndixa ta̱yóꞌo kúu ra ta̱a ta̱ ndáa tíndikachi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ta inka̱ ta̱a ta̱ ndáa yéꞌé ña ndási̱ korra no̱o̱ ñóꞌo tíndikachi, tá xíto ta̱yóꞌo va̱xi ta̱a ta̱ ndáa ndikachi, ta nakoná ra yéꞌé ña ki̱ꞌvi ta̱a ta̱ ndáa tíndikachi. Ta ta̱a ta̱ ndáa tíndikachi yóꞌo kána ra, káꞌa̱n ra ñii ñii ki̱vi̱ tíndikachi sa̱na̱ ra ña kundiko̱n rí sa̱ta̱ ra. Ta saá ñii ñii tíndikachi yóꞌo xíni̱ so̱ꞌo rí ta̱chi̱ ta̱yóꞌo, ta kée rí kua̱ꞌa̱n rí ndíko̱n rí sa̱ta̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tá ndi̱ꞌi ke̱e ndiꞌi tíndikachi sa̱na̱ ra, ta saá kua̱ꞌa̱n siꞌna ra, ta ndiꞌi tíyóꞌo ndíko̱n rí kua̱ꞌa̱n rí sa̱ta̱ ra. Saá chi va̱ꞌa xíni̱ rí ta̱chi̱ xitoꞌo rí. ");
INSERT INTO mim_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ta tíndikachi yóꞌo o̱n vása ko̱ꞌo̱n rí sa̱ta̱ inka̱ ta̱a, chi o̱n vása xíni̱ rí ra. Nda̱ víka̱ xíno rí no̱o̱ ta̱yóꞌo, chi o̱n vása nákoni rí ta̱chi̱ káꞌa̱n ra ―káchí ta̱Jesús, nda̱to̱ꞌon ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Nda̱to̱ꞌon ra cuento yóꞌo xíꞌin ni̱vi ña sanáꞌa ra na, ta nayóꞌo o̱n vása ní‑kunda̱a̱ ini na yukía̱ kóni kachí cuento yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ta saá ta̱Jesús tuku ni̱ka̱ꞌa̱n ra xíꞌin na: ―Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó: Nda̱tán yóo yéꞌé korra no̱o̱ ndási̱ ñóꞌo tíndikachi, saá yóo i̱. Ta ni̱vi na ndíko̱n yi̱ꞌi̱, nda̱tán yóo ndikachi sa̱na̱ i̱ saá yóo na. ");
INSERT INTO mim_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ta o̱n ta̱ꞌán ka̱ kixaa̱ i̱ ñoyívi yóꞌo, ki̱xi kua̱ꞌa̱ ní ni̱vi na o̱n váꞌa, ta nakuíꞌná xi̱kuu ndiꞌi na. Ta nayóꞌo ndu̱kú na ña kundiko̱n tíndikachi ko̱ꞌo̱n rí sa̱ta̱ na, ta ni̱‑kuchiño na, chi tíndikachi sa̱na̱ i̱ o̱n vása ní‑chikaa̱ so̱ꞌo rí ña ni̱ka̱ꞌa̱n na xíꞌin rí. ");
INSERT INTO mim_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ta ñii la̱á yéꞌé yóo, ta yi̱ꞌi̱ kúu yéꞌé yóꞌo. Ta ndiꞌi ni̱vi na ki̱ꞌvi ñii la̱á yéꞌé yóꞌo, ta saka̱ku i̱ nayóꞌo. Ta nayóꞌo, nda̱tán yóo tíndikachi tí vivíi ndáa i̱, saá yóo na, chi táxi i̱ ña ko̱ꞌo̱n ndíka̱ na ta chindeé i̱ na ña ndixa naníꞌi na ña xíni̱ ñóꞌó na ña va̱ꞌa kutaku̱ na. ");
INSERT INTO mim_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ta ni̱vi nakuíꞌná, ndasaá kuiti va̱xi na xa̱ꞌa̱ ña kasa kuíꞌná na ni̱vi na kúu tíndikachi sa̱na̱ i̱, án xa̱ꞌa̱ ña kaꞌni ñaꞌá na ta sandiꞌi na xa̱ꞌa̱ na. Ta yi̱ꞌi̱, ki̱xaa̱ i̱ xa̱ꞌa̱ ña taxi i̱ ña ndixa nda̱a̱ kutaku̱ ni̱vi na kúu tíndikachi sa̱na̱ i̱, ta ki̱xaa̱ i̱ xa̱ꞌa̱ ña víꞌí ní va̱ꞌa kutaku̱ nayóꞌo na kúu na ndíko̱n yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ta yi̱ꞌi̱ nda̱tán yóo ta̱a ta̱ va̱ꞌa ndáa ndikachi saá yóo i̱. Saá chi ndixa ta̱a ta̱ va̱ꞌa ndáa tíndikachi táxi xíꞌin mi̱i ra nda̱ kivi̱ ra xa̱ꞌa̱ rí. ");
INSERT INTO mim_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ta ta̱a ta̱ o̱n si̱ví xitoꞌo tíndikachi kúu, ta ndáa ra ndikachi xa̱ꞌa̱ ña kiꞌin yaꞌvi ra si̱ꞌún, ta̱yóꞌo o̱n vása va̱ꞌa chíkuenda ra xíꞌin rí. Chi ta̱yóꞌo, tá xíto ra va̱xi tíndiva̱ꞌyí ña kaꞌni rí tíndikachi, ta saá yíꞌví ra ta kama xíno ra kua̱ꞌa̱n ra, ta sándakoo ra tíndikachi yóꞌo. Ta saá kíꞌvi tíndiva̱ꞌyí ña satakuéꞌe̱ rí, ta sákui̱ta̱ níꞌnó rí ndiꞌi tíndikachi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ta ta̱a ta̱ kísa chiño kuiti xa̱ꞌa̱ si̱ꞌún, ta̱yóꞌo xíno ra kua̱ꞌa̱n ra, chi o̱n si̱ví sa̱na̱ ra kúu tíndikachi, ni o̱n vása kíꞌvi ini ra xíni ra rí. ");
INSERT INTO mim_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Ta yi̱ꞌi̱ o̱n vása kéꞌé i̱ nda̱tán kéꞌé ta̱yóꞌo, chi yi̱ꞌi̱ kúu ta̱a ta̱ va̱ꞌa ní ndáa tíndikachi sa̱na̱ i̱. Yi̱ꞌi̱ xíni̱ va̱ꞌa i̱ ndikachi sa̱na̱ i̱, ta tíndikachi sa̱na̱ i̱ xíni̱ va̱ꞌa rí yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ñii ki̱ꞌva saá mi̱i Yivá i̱ xíni̱ va̱ꞌa ra yi̱ꞌi̱, ta yi̱ꞌi̱ xíni̱ va̱ꞌa i̱ Yivá i̱. Ta ndixa kíꞌvi ní ini i̱ xíni i̱ tíndikachi sa̱na̱ i̱, ta̱nda̱ yóo tiꞌva i̱ taxi xíꞌin mi̱i i̱ ña kivi̱ i̱ xa̱ꞌa̱ rí. ");
INSERT INTO mim_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yóo inka̱ ndikachi sa̱na̱ i̱ ta o̱n ko̱ó rí ñóꞌo xíꞌin tí xa ndíko̱n sa̱ta̱ i̱ vitin. Ta xíni̱ ñóꞌó ko̱ꞌo̱n i̱ nakaya i̱ rí ña kundiko̱n rí sa̱ta̱ i̱. Ta saá tíyóꞌo chikaa̱ so̱ꞌo rí to̱ꞌon i̱, ta tíyóꞌo xíꞌin tí xa yóo xíꞌin i̱, nduu ndiꞌi rí ñii la̱á kuiti tiꞌvi ndikachi sa̱na̱ i̱, ta ñii la̱á yi̱ꞌi̱ kuu ta̱a ta̱ ndáa ndiꞌi tíndikachi sa̱na̱ i̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Yivá i̱ Ndios kíꞌvi ní ini ra xíni ra yi̱ꞌi̱ chi yi̱ꞌi̱ taxi xíꞌin mi̱i i̱ ña kivi̱ i̱ xa̱ꞌa̱ tíndikachi sa̱na̱ i̱. Ta taxi xíꞌin mi̱i i̱ ña kivi̱ i̱ saá xa̱ꞌa̱ ña tuku nakiꞌin xíꞌin mi̱i i̱ ta nataku̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nda̱ ñii ni̱vi o̱n vása kómí na nda̱yí kindaa na ña táku̱ i̱. Ta yi̱ꞌi̱ xíꞌin ña káchí ini i̱, taxi xíꞌin mi̱i i̱ ña kivi̱ i̱. Saá chi kómí i̱ nda̱yí ña taxi xíꞌin mi̱i i̱ ña kivi̱ i̱, ta kómí i̱ nda̱yí ña tuku nakiꞌin xíꞌin mi̱i i̱ ta nataku̱ i̱. Kómí i̱ nda̱yí yóꞌo chi saá xa̱ꞌnda chiño Yivá i̱ no̱o̱ i̱ ña keꞌé i̱ saá ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tá ndi̱ꞌi xi̱ni̱ so̱ꞌo na to̱ꞌon yóꞌo, ta tuku ni̱ta̱ꞌvi̱ táꞌan najudío. O̱n vása kúchiño koo yuꞌú na xa̱ꞌa̱ ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kua̱ꞌa̱ ní nayóꞌo káꞌa̱n na, káchí na saá: ―Ta̱Jesús yóꞌo kúu ta̱a ta̱ sána si̱ni̱, chi kómí ra ñii níma̱ ndiva̱ꞌa. Nda̱ ma̱ni̱ koni̱ so̱ꞌo yó ña káꞌa̱n ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ta inka̱ najudío yóꞌo káꞌa̱n na, káchí na saá: ―O̱n si̱ví saá, chi ñii ta̱a ta̱ kómí níma̱ ndiva̱ꞌa o̱n vása kúchiño ka̱ꞌa̱n ra to̱ꞌon nda̱tán káꞌa̱n ta̱yóꞌo. ¿Án yóo ñii níma̱ ndiva̱ꞌa ña kómí ndee̱ ña sandúva̱ꞌa ña ñii ta̱kuáá? ―káchí na, káꞌa̱n na xíꞌin táꞌan na. ");
INSERT INTO mim_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ta saá ni̱to̱nda̱a yo̱o̱ vi̱xin, ta kána viko̱ káꞌno ñoo Jerusalén, ña kúu viko̱ xa̱ꞌa̱ ña nákáꞌán najudío ndasaá naxi̱i̱ síkuá na tuku na̱taxi na veꞌe ño̱ꞌo káꞌno ndaꞌa̱ Ndios kui̱ya̱ xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ta ta̱Jesús xíka ra ñii xiiña ña na̱ní Corredor ta̱rey Salomón, ña nákaa̱ no̱o̱ yóo ke̱ꞌe veꞌe ño̱ꞌo káꞌno yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ta nanáꞌno no̱o̱ najudío ki̱xi taꞌa na no̱o̱ ra, ta xi̱no nduu na ra, ta ni̱nda̱ka̱ to̱ꞌon na ra, káchí na saá xíꞌin ra: ―¿Ndasaá ka̱ ki̱vi̱ yaꞌa, ta saá kasa nda̱a̱ ún xa̱ꞌa̱ mi̱i ún ña kunda̱a̱ ini ndi̱ yu kúu ún? Tá yóꞌó kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios saka̱ku ra mi̱i ndi̱, ta va̱ꞌa ka̱ꞌa̱n káxín ún xíꞌin ndi̱ vitin ndí sivi kúu ún ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Xa ni̱ka̱ꞌa̱n i̱ xíꞌin ndó yi̱ꞌi̱ kúu ra, ta o̱n xi̱in ndó kandixa ndó yi̱ꞌi̱. Yóo kua̱ꞌa̱ ní milagro va̱ꞌa ña kéꞌé i̱, ta xíꞌin nda̱yí Yivá i̱ Ndios kéꞌé i̱ ndiꞌi ña. Ta ndiꞌi ñava̱ꞌa yóꞌo kúu ña ndákuii̱n xa̱ꞌa̱ i̱ ta sánáꞌa ña no̱o̱ ndóꞌó yu kúu i̱. ");
INSERT INTO mim_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ta ndóꞌó, o̱n xi̱in ndó kandixa ndó yi̱ꞌi̱ chi o̱n vása yóo ndó nda̱tán yóo tíndikachi sa̱na̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Chi ndiꞌi ni̱vi na yóo nda̱tán yóo tíndikachi sa̱na̱ i̱, nayóꞌo nákoni na ta̱chi̱ i̱ ña káꞌa̱n i̱ xíꞌin na. Ta yi̱ꞌi̱, xíni̱ va̱ꞌa i̱ ndiꞌi nayóꞌo, ta ndiꞌi nayóꞌo ndíko̱n na sa̱ta̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yi̱ꞌi̱ táxi i̱ ña ndixa kutaku̱ na ndiꞌi saá ki̱vi̱ ña va̱xi, ta nda̱ ñii ki̱vi̱ o̱n ndiꞌi xa̱ꞌa̱ na. Ta nda̱ ñii ni̱vi o̱n kuchiño na kindaa na nayóꞌo ndaꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yivá i̱ Ndios kúu ta̱a ta̱ ta̱xi ni̱vi yóꞌo ndaꞌa̱ i̱. Ta Yivá i̱ kúu ta̱a ta̱ káꞌno va̱ꞌa ka̱ no̱o̱ ndiꞌi ni̱vi. Ta xa̱ꞌa̱ ñayóꞌo, nda̱ ñii ni̱vi o̱n kuchiño na kindaa na nda̱ ñii nayóꞌo ndaꞌa̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ta yi̱ꞌi̱ xíꞌin Yivá i̱ Ndios, ñii la̱á kúu ndi̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ta saá najudío yóꞌo tuku na̱tiin na yu̱u̱ ña koon na ra, chi kóni na kaꞌni na ra. ");
INSERT INTO mim_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―No̱o̱ ndóꞌó xa ke̱ꞌé i̱ kua̱ꞌa̱ ní milagro va̱ꞌa xíꞌin nda̱yí Yivá i̱. Ta vitin, ¿ndá ñava̱ꞌa ke̱ꞌé i̱ kúu ña kóni ndó kaꞌni ndó yi̱ꞌi̱ xa̱ꞌa̱? ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ta nanáꞌno no̱o̱ najudío yóꞌo nda̱kuii̱n na, káchí na saá xíꞌin ra: ―O̱n si̱ví xa̱ꞌa̱ ña milagro va̱ꞌa ke̱ꞌé ún kúu ña kóni ndi̱ kaꞌni ndi̱ yóꞌó, ta xa̱ꞌa̱ to̱ꞌon ña o̱n váꞌa káꞌa̱n ún xa̱ꞌa̱ Ndios kúu ña kóni ndi̱ kaꞌni ndi̱ yóꞌó, chi vará ndasaá kuiti ñii ta̱a kúu ún, ta káꞌa̱n ún xa̱ꞌa̱ mi̱i ún kúu ún Ndios ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Án o̱n vása ndixa yóo ñii xiiña no̱o̱ káꞌa̱n to̱ꞌon Ndios ña káchí saá: “Nda̱tán yóo ndios válí saá yóo ndó”?, ka̱chí Ndios xíꞌin nanáꞌno no̱o̱ naxi̱i̱ síkuá ndó kui̱ya̱ xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ta xíni̱ yó to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá ñanda̱a̱ ndinoꞌo kúu ña, ta nda̱ ñii ki̱vi̱ o̱n vása násama ña. Ta to̱ꞌon yóꞌo káchí ndí mi̱i Ndios kúu ta̱a ta̱ ni̱ka̱ꞌa̱n xíꞌin ni̱vi na na̱kiꞌin to̱ꞌon ra kui̱ya̱ xi̱na̱ꞌá, ta káchí ra saá: “Ta ndóꞌó, nda̱tán yóo ndios válí, saá yóo ndó”, káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ta ndixa mi̱i Ndios yóꞌo kúu ta̱a ta̱ na̱ka̱xin yi̱ꞌi̱, ta ti̱ꞌví ra yi̱ꞌi̱ ki̱xaa̱ i̱ ñoyívi yóꞌo ña kasa ndivi i̱ chiño ra. Ta saá, ¿nda̱chun káꞌa̱n ndó xíꞌin i̱ ndí yi̱ꞌi̱ káꞌa̱n i̱ to̱ꞌon ña o̱n váꞌa xa̱ꞌa̱ Ndios chi káꞌa̱n i̱, káchí i̱ kúu i̱ Sa̱ꞌya Ndios? ");
INSERT INTO mim_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ta yi̱ꞌi̱, tá o̱n vása kéꞌé i̱ chiño va̱ꞌa, nda̱tán yóo ña kéꞌé Yivá i̱ Ndios, ta saá o̱n vása xíni̱ ñóꞌó kandixa ndó ndí to̱ꞌon nda̱a̱ káꞌa̱n i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ta saá ni, tá ndixa kísa ndivi i̱ chiño va̱ꞌa nda̱tán yóo ña kéꞌé Yivá i̱ Ndios, ta saá xíni̱ ñóꞌó kandixa ndó ndí to̱ꞌon nda̱a̱ káꞌa̱n i̱ xíꞌin ndó. Tá o̱n xi̱in ndó kandixa ndó to̱ꞌon ña káꞌa̱n i̱, ta saá xíni̱ ñóꞌó kani si̱ni̱ ndó xa̱ꞌa̱ milagro va̱ꞌa ña kéꞌé i̱. Ta saá kunda̱a̱ ini ndó ndí ñandixa kúu ña káꞌa̱n i̱ xíꞌin ndó, ta kandixa ndó ndí Yivá i̱ Ndios táku̱ ra ini i̱, ta yi̱ꞌi̱ táku̱ i̱ ini Yivá i̱ Ndios ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ta saá nanáꞌno no̱o̱ najudío yóꞌo tuku ndu̱kú na tiin na ra ña chikaa̱ na ra ini veꞌe ka̱a, ta ni̱‑kuchiño na, chi ta̱Jesús ni̱ka̱ku ra, kua̱ꞌa̱n ndíka̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ta ndi̱kó ta̱Jesús, kua̱ꞌa̱n ra inka̱ táꞌví yuꞌu̱ yu̱ta Jordán, ta ni̱xaa̱ ra no̱o̱ siꞌna ta̱Juan ni̱xi̱yo ra, sákuchu ra ni̱vi, ta yuꞌu̱ yu̱ta yóꞌo ki̱ndo̱o ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ta kua̱ꞌa̱ ní ni̱vi ni̱xaa̱ na no̱o̱ yóo ra. Ni̱vi yóꞌo káꞌa̱n na xíꞌin táꞌan na, káchí na saá: ―Ta̱Juan o̱n vása ní‑keꞌé ra nda̱ ñii milagro, ta saá ni, ndiꞌi to̱ꞌon ña ni̱ka̱ꞌa̱n ra xa̱ꞌa̱ ta̱Jesús yóꞌo kúu to̱ꞌon ña ndixa nda̱a̱ ―káchí na, káꞌa̱n na xíꞌin táꞌan na. ");
INSERT INTO mim_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ta mi̱i xiiña yóꞌo no̱o̱ ni̱xaa̱ na, kua̱ꞌa̱ ní ni̱vi ka̱ndixa na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ta ñoo Betania yóo ñii ta̱a na̱ní ra Lázaro, ta ndeé ní ndóꞌo ra. Ta mi̱i ñoo yóꞌo táku̱ ñáMaría xíꞌin ñáMarta, ná kúu ki̱ꞌva̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ta ñáMaría ñá kúu ki̱ꞌva̱ ta̱Lázaro yóꞌo kúu ñaꞌa̱ ñá chi̱kaa̱ nduta̱ tá xáꞌan támi ní xa̱ꞌa̱ ta̱Jesús, ta na̱yakón ñá xa̱ꞌa̱ ra xíꞌin yisi̱ si̱ni̱ ñá. ");
INSERT INTO mim_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ta xa̱ꞌa̱ ña ndeé ndóꞌo ta̱Lázaro, náki̱ꞌva̱ ra ñáMaría xíꞌin ñáMarta ti̱ꞌví ná ñii ta̱ xíka chiño no̱o̱ ná, kua̱ꞌa̱n ra no̱o̱ ta̱Jesús, ña ka̱ꞌa̱n ra xíꞌin ra. Ta ni̱xaa̱ ra, ta káchí ra saá: ―Tata, vitin ndeé ní ndóꞌo ta̱a ta̱ kúu ta̱ kíꞌvi ini mi̱i ún xíni ún ―káchí ta̱yóꞌo xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tá xi̱ni̱ so̱ꞌo ta̱Jesús ñayóꞌo, ta ni̱ka̱ꞌa̱n ra: ―O̱n si̱ví xa̱ꞌa̱ ña kivi̱ ta̱Lázaro kúu ña ndeé ní ndóꞌo ra vitin. Ta ña ndeé ní ndóꞌo ra kúu xa̱ꞌa̱ ña kua̱ꞌa̱ ní ni̱vi chinóo síkón na ñato̱ꞌó Ndios, ta ñii ki̱ꞌva saá chinóo síkón na ñato̱ꞌó yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya Ndios. ");
INSERT INTO mim_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ta ta̱Jesús kíꞌvi ní ini ra xíni ra ñáMarta xíꞌin ki̱ꞌvi̱ ñá ñáMaría, xíꞌin ki̱ꞌva̱ ná ta̱Lázaro. ");
INSERT INTO mim_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ta ki̱vi̱ xi̱ni̱ so̱ꞌo ra ndí ndeé ní ndóꞌo ta̱Lázaro, ta saá ni, ki̱ndo̱o ka̱ ra o̱vi̱ ka̱ ki̱vi̱ no̱o̱ yóo ra. ");
INSERT INTO mim_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tá ni̱yaꞌa o̱vi̱ ki̱vi̱ yóꞌo, ta ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Vitin kee yó ndikó tuku yó ko̱ꞌo̱n yó ñoo estado Judea ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ta naxíka xíꞌin ra ni̱ka̱ꞌa̱n na, káchí na saá: ―Tata Rabí, sa̱kán loꞌo ki̱vi̱ ni̱yaꞌa, nanáꞌno no̱o̱ najudío na ndóo ñoo estado Judea, saloꞌo kuiti, ta kaꞌni na yóꞌó xíꞌin yu̱u̱, níkúu. ¿Nda̱chun kóni ún ndikó tuku yó ñoo yóꞌo? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―¿Án o̱n ndixa u̱xu̱ o̱vi̱ hora kómí ñii ndiví ña yéꞌe ño̱ꞌo? Ta ta̱a ta̱ xíka ndiví, o̱n vása káchiꞌi xa̱ꞌa̱ ra ña̱ꞌa, chi va̱ꞌa yéꞌe ño̱ꞌo no̱o̱ yichi̱ xíka ra. ");
INSERT INTO mim_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ta ta̱a ta̱ xíka ñoó naa, ta̱yóꞌo káchiꞌi xa̱ꞌa̱ ra kua̱ꞌa̱ ní ña̱ꞌa, chi o̱n ko̱ó ño̱ꞌo yeꞌe yichi̱ no̱o̱ kua̱ꞌa̱n ra ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ta saá ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na, káchí ra saá: ―Ta̱a ta̱migo yó ta̱Lázaro kísi̱n ra vitin, ta ko̱ꞌo̱n i̱ ña sanakáxín i̱ ini ra. ");
INSERT INTO mim_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ta saá nda̱kuii̱n naxíka xíꞌin ra, ni̱ka̱ꞌa̱n na: ―Tata, tá ta̱ kísi̱n kúu ra, ta saá kúnda̱a̱ ini yó ndí ta̱ xa kua̱ꞌa̱n nduva̱ꞌa kúu ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nayóꞌo o̱n vása kúnda̱a̱ ini na ña káꞌa̱n ta̱Jesús, chi kóni kachí ra ni̱xiꞌi̱ ta̱Lázaro, ta nayóꞌo xáni si̱ni̱ na ndasaá kuiti kísi̱n ta̱Lázaro. ");
INSERT INTO mim_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ta saá ta̱Jesús ni̱ka̱ꞌa̱n káxín ra xíꞌin na, káchí ra saá: ―Ta̱Lázaro xa ni̱xiꞌi̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ta kúsii̱ ini i̱ ña o̱n vása ní‑xiyo i̱ xíꞌin ta̱Lázaro ki̱vi̱ ni̱xiꞌi̱ ra, chi ña ndóꞌo ra saá kúu ñava̱ꞌa xa̱ꞌa̱ mi̱i ndó. Saá chi ñayóꞌo chindeé ña mi̱i ndó ña kandixa va̱ꞌa ndó yi̱ꞌi̱. Ta koꞌyo̱ vitin koto yó no̱o̱ kándúꞌu̱ ra ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ta ñii ta̱xíka xíꞌin ta̱Jesús na̱ní ra Tomás, ta̱ kúu ta̱ sa̱kunaní na ta̱Kuátí, ni̱ka̱ꞌa̱n ra xíꞌin inka̱ naxíka xíꞌin ta̱Jesús: ―Va̱ꞌa ko̱ꞌo̱n ndiꞌi yó xíꞌin ra xa̱ꞌa̱ ña kivi̱ yó xíꞌin ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tá ni̱xaa̱ na ñoo Betania, ta xi̱ni̱ so̱ꞌo ta̱Jesús ña xa ni̱yaꞌa ko̱mi̱ ki̱vi̱ ni̱ndu̱xu̱n ta̱Lázaro yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ta ñoo Betania yóꞌo nákaa̱ yatin ña ñoo Jerusalén, ñii u̱ni̱ kilómetro kúu ñaxíká. ");
INSERT INTO mim_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ta kua̱ꞌa̱ ní najudío xa ki̱xaa̱ na ñoo Betania yóꞌo, chi nayóꞌo kóni na chikaa̱ na ndee̱ ini ñáMaría xíꞌin ñáMarta, chi kúchuchú ní ini náyóꞌo xa̱ꞌa̱ ña ni̱xiꞌi̱ ta̱ki̱ꞌva̱ náñaꞌa̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tá ki̱xaa̱ ni̱vi nda̱to̱ꞌon na ndí va̱xi ta̱Jesús, ta xi̱ni̱ so̱ꞌo ñáMarta to̱ꞌon yóꞌo, ta ke̱e ñá kua̱ꞌa̱n ñá nakutáꞌan ñá xíꞌin ra. Ta ñáMaría ki̱ndo̱o ñá veꞌe. ");
INSERT INTO mim_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ta ni̱xaa̱ ñáMarta no̱o̱ ta̱Jesús, ta ni̱ka̱ꞌa̱n ñá xíꞌin ra, káchí ñá saá: ―Tata, tá ni̱xi̱yo ún xíꞌin ndi̱ yóꞌo, níkúu, ta o̱n kivi̱ ta̱ki̱ꞌva̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ta saá ni, vitin kúnda̱a̱ ini i̱ ndí Ndios ndixa taxi ra ndaꞌa̱ ún nda̱ kúu ka̱ ñava̱ꞌa ndukú ún no̱o̱ ra ―káchí ñáMarta xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ñá, káchí ra saá: ―Ta̱a ta̱ki̱ꞌva̱ ún nataku̱ ra ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ta nda̱kuii̱n ñáMarta: ―Xa xíni̱ i̱ ndí ndixa nataku̱ ra, ta ñayóꞌo kundivi ki̱vi̱ sondíꞌí ñoyívi, chi ki̱vi̱ saá ndiꞌi ni̱vi na ni̱xiꞌi̱ nataku̱ na ―káchí ñá xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra saá: ―Yi̱ꞌi̱ kúu ndee̱ ña táxi nataku̱ ni̱vi na ni̱xiꞌi̱, ta yi̱ꞌi̱ kúu ndee̱ ña táxi kutaku̱ ndinoꞌo ni̱vi. Ndiꞌi ni̱vi na kándixa yi̱ꞌi̱, vará kixaa̱ ñii ki̱vi̱ ña kivi̱ na, ta nayóꞌo ndixa kutaku̱ ndinoꞌo na ndiꞌi saá ki̱vi̱ va̱xi. ");
INSERT INTO mim_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ta ndiꞌi ni̱vi na kúu na táku̱ ndinoꞌo chi kándixa na yi̱ꞌi̱, nayóꞌo nda̱ ñii ki̱vi̱ o̱n ndiꞌi xa̱ꞌa̱ na. ¿Án kándixa ún to̱ꞌon yóꞌo ña káꞌa̱n i̱ xíꞌin ún? ―káchí ta̱Jesús xíꞌin ñáMarta. ");
INSERT INTO mim_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ta nda̱kuii̱n ñá, ni̱ka̱ꞌa̱n ñá: ―Ndixa, Tata, kándixa i̱ to̱ꞌon káꞌa̱n ún, ta kándixa i̱ yóꞌó kúu Cristo, Sa̱ꞌya Ndios, ta̱a ta̱ xi̱ndati ndi̱ ña tiꞌví Ndios, ta vitin xa ki̱xaa̱ ra ñoyívi yóꞌo ―káchí ñáMarta xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ta saá ndi̱kó ñáMarta kua̱noꞌo̱ ñá, ta na̱xaa̱ ñá veꞌe ñá. Ta ka̱na ñá ki̱ꞌvi̱ ñá ñáMaría kixi ñá no̱o̱ ñá, ta ni̱ka̱ꞌa̱n seꞌé ñá xíꞌin ñáyóꞌo, káchí ñá saá: ―Ta̱Maestro ki̱xaa̱ ra yatin no̱o̱ ñoo yóꞌo, ta kána ra yóꞌó ko̱ꞌo̱n ún no̱o̱ ra ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tá xi̱ni̱ so̱ꞌo ñáMaría to̱ꞌon yóꞌo, ta kama ní na̱kundichi ñá, ta ke̱e ñá kua̱ꞌa̱n ñá no̱o̱ yóo ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ta ta̱Jesús o̱n ta̱ꞌán ka̱ ki̱ꞌvi ra ñoo Betania, ta yóo ka̱ ra mi̱i xiiña no̱o̱ na̱kutáꞌan ñáMarta xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ta najudío na xa ki̱xaa̱ ndóo veꞌe no̱o̱ táku̱ ñáMaría xíꞌin ñáMarta xa̱ꞌa̱ ña chíkaa̱ na ndee̱ ini náyóꞌo, xi̱to na kama ní na̱kundichi ñáMaría, ta ke̱e ñá kua̱ꞌa̱n ñá, ta saá ke̱e na kua̱ꞌa̱n na sa̱ta̱ ñá, chi xa̱ni si̱ni̱ na: “Kua̱ꞌa̱n ñá no̱o̱ ni̱ndu̱xu̱n ta̱Lázaro ña kuaku ñá xa̱ꞌa̱ ra”, saá xa̱ni si̱ni̱ na. ");
INSERT INTO mim_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ta ni̱xaa̱ ñáMaría no̱o̱ yóo ta̱Jesús, ta xi̱kuxítí ñá xa̱ꞌa̱ ra, ta ni̱ka̱ꞌa̱n ñá xíꞌin ra, káchí ñá saá: ―Tata, tá ni̱xi̱yo ún xíꞌin ndi̱ yóꞌo, níkúu, ta o̱n kivi̱ ta̱ki̱ꞌva̱ i̱ ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tá xi̱to ta̱Jesús xáku ní ñáMaría, ta xáku ní natáꞌan ñá na ki̱xaa̱ xíꞌin ñá, ta saá ña xíto ra yóꞌo nda̱ sa̱kanda ña ini ra, ta ni̱ta̱ꞌvi̱ ní ini ra. ");
INSERT INTO mim_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ta ni̱nda̱ka̱ to̱ꞌon ra na, káchí ra saá: ―¿Míkía̱ sa̱ndúxu̱n ndó ta̱ ni̱xiꞌi̱? Ta nda̱kuii̱n na, ni̱ka̱ꞌa̱n na: ―Naꞌa, ko̱ꞌo̱n ún xíꞌin ndi̱ ta koni ún no̱o̱ ni̱ndu̱xu̱n ra ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ta ta̱Jesús ki̱xáꞌá ra xáku ní ra. ");
INSERT INTO mim_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ta sava najudío na ndóo yóꞌo, ni̱ka̱ꞌa̱n xíꞌin táꞌan na, káchí na saá: ―Koto ndó, ndeé ní kíꞌvi ini ra xi̱ni ra ta̱a ta̱ ni̱xiꞌi̱ ―káchí na, káꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ta inka̱ na káꞌa̱n xíꞌin táꞌan na, káchí na saá: ―Ta̱yóꞌo sa̱ndaꞌa ra nduchu̱ no̱o̱ ta̱kuáá. ¿Nda̱chun o̱n vása ní‑xiyo ra ña chíndeé ra ta̱Lázaro ña o̱n kivi̱ ra, níkúu? ―káchí na. ");
INSERT INTO mim_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ta tuku nda̱ mi̱i níma̱ ta̱Jesús kánda ña xíꞌin ña kúchuchú ní ini ra, ta kua̱ꞌa̱n ra, ta ni̱xaa̱ ra no̱o̱ yóo kavua̱ no̱o̱ ni̱ndu̱xu̱n ta̱Lázaro. Ta xi̱ni ra ñii yu̱u̱ veé ña káꞌno ní, ña va̱ꞌa ndási̱ yuꞌu̱ kavua̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ni̱vi na yíta yóꞌo, káchí ra saá: ―Tiin ndó yu̱u̱ ña ndási̱ yuꞌu̱ kavua̱ yóꞌo, ta sakutaꞌa ndó ña ―káchí ra xíꞌin na. Ta ni̱ka̱ꞌa̱n ñáMarta xíꞌin ra, káchí ñá saá: ―O̱n váꞌa vitin, Tata, chi xa ni̱xi̱no̱ ko̱mi̱ ki̱vi̱ ni̱xiꞌi̱ ra, ta saá xa xáꞌan táꞌyí ní ra vitin ―káchí ñá. ");
INSERT INTO mim_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin ñá, káchí ra saá: ―¿Án o̱n vása nákáꞌán ún ña ni̱ka̱ꞌa̱n i̱ xíꞌin ún, nana? Chi ni̱ka̱ꞌa̱n i̱ tá kandixa ún yi̱ꞌi̱, ta saá koni ún ñava̱ꞌa káꞌno ña táxi ña kua̱ꞌa̱ ní ni̱vi chinóo síkón na ñato̱ꞌó Ndios ―káchí ra xíꞌin ñá. ");
INSERT INTO mim_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ta saá sa̱kutaꞌa na yu̱u̱ ña ndási̱ yuꞌu̱ kavua̱ no̱o̱ ni̱ndu̱xu̱n ta̱Lázaro. Ta ta̱Jesús na̱koto ndaa ra ñoyívi ni̱no, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios, káchí ra saá: ―Tata Yivá i̱, táxaꞌvi ún chi xíni̱ so̱ꞌo ún xa̱ꞌa̱ ña ndúkú i̱ no̱o̱ ún vitin. ");
INSERT INTO mim_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Xíni̱ va̱ꞌa i̱ ña ndiꞌi saá ki̱vi̱ xíni̱ so̱ꞌo ún ña káꞌa̱n i̱ xíꞌin ún, ta vitin káꞌa̱n i̱ to̱ꞌon yóꞌo, saá chi kóni i̱ ña kunda̱a̱ ini ni̱vi na yíta yóꞌo ndí yóꞌó kúu ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱ ―káchí ta̱Jesús xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ta ndi̱ꞌi ni̱ka̱ꞌa̱n ra to̱ꞌon yóꞌo xíꞌin Ndios, ta xíꞌin ndiꞌi ndee̱ ra ni̱ka̱ꞌa̱n ra xíꞌin ta̱Lázaro, káchí ra saá: ―Lázaro, keta ún, ta naꞌa ún yóꞌo ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ta saá ta̱Lázaro, ta̱a ta̱ xa ni̱xiꞌi̱ kúu ra, ta na̱taku̱ ra vitin, ta ke̱ta ra ti̱xin kavua̱, ta ki̱xaa̱ ra xi̱kundichi ra no̱o̱ ni̱vi na yíta yóꞌo. Ta yi̱kí ko̱ñu ta̱Lázaro násúku ndaa ndiꞌi ña xíꞌin tiko̱to̱ ña chi̱súku na ra ki̱vi̱ ni̱ndu̱xu̱n ra. Ta si̱ni̱ ra xíꞌin no̱o̱ ra násúku ndaa ña xíꞌin inka̱ tiko̱to̱. Ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na: ―Ndaxin ndó ra no̱o̱ tiko̱to̱ ña nóꞌni ra, ta sa̱ña̱ ra ko̱ꞌo̱n ndíka̱ ra ―káchí ta̱Jesús xíꞌin ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ta saá najudío, na kua̱ꞌa̱n xíꞌin ñáMaría ni̱xaa̱ na no̱o̱ yóo ta̱Jesús, xi̱ni na ñava̱ꞌa yóꞌo ke̱ꞌé ta̱Jesús ña sa̱nataku̱ ra ta̱Lázaro, ta kua̱ꞌa̱ ní nayóꞌo ka̱ndixa na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ta inka̱ najudío yóꞌo kua̱ꞌa̱n na, ta ni̱xaa̱ na no̱o̱ nafariseo ta nda̱to̱ꞌon na xíꞌin na yukía̱ ke̱ꞌé ta̱Jesús xíꞌin ta̱Lázaro. ");
INSERT INTO mim_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ta nafariseo xíꞌin nasu̱tu̱ náꞌno no̱o̱ najudío ka̱na na ni̱vi na kúu nachiño náꞌno, na na̱ní Junta Suprema, ta na̱kutáꞌan na. Ta saá ki̱xaa̱ na, ta káꞌa̱n na xíꞌin táꞌan na, káchí na saá: ―¿Yukía̱ keꞌé yó vitin? Chi ta̱Jesús yóꞌo kéꞌé ra kua̱ꞌa̱ ní milagro. ");
INSERT INTO mim_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Táná taxi yó ña keꞌé ka̱ ra saá, ta ndiꞌi ni̱vi kixáꞌá na kundiko̱n na ra. Ta saá yi̱yo ní sakaku ra kua̱chi xíꞌin nagobierno ñoo Roma, ta kama ní nachiño ñoo Roma tiꞌví na natropa ta sandiꞌi na xa̱ꞌa̱ nañoo yó Israel, ta ñii saá sandiꞌi na xa̱ꞌa̱ veꞌe ño̱ꞌo káꞌno ñoo yó ―káchí na, káꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ta ñii su̱tu̱ ta̱táꞌan naJunta Suprema yóꞌo, na̱ní ra Caifás, ta kui̱ya̱ yóꞌo xi̱kuu ra ta̱su̱tu̱ káꞌno no̱o̱ ndiꞌi nasu̱tu̱, ta ni̱ka̱ꞌa̱n ndoso ra xíꞌin natáꞌan ra naJunta Suprema, káchí ra saá: ―¿Án nakíꞌví kúu ndó?, ¡chi o̱n váꞌa xáni si̱ni̱ ndó! ");
INSERT INTO mim_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","O̱n vása kúnda̱a̱ ini ndó ndí va̱ꞌa ka̱ kúu ña kivi̱ ñii ta̱a xa̱ꞌa̱ ni̱vi ñoo yó, ko̱to̱ ndiꞌi xa̱ꞌa̱ ndiꞌi yó nañoo Israel ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ta o̱n si̱ví si̱ni̱ mi̱i ra kúu ña ka̱ku to̱ꞌon yóꞌo ña ni̱ka̱ꞌa̱n ra saá, ta to̱ꞌon ña ke̱e no̱o̱ Ndios kúu ña. Saá chi chi̱tóni̱ Ndios ta̱su̱tu̱ káꞌno kuu ta̱a ta̱ ka̱ꞌa̱n to̱ꞌon ña káchí ndí ta̱Jesús kivi̱ ra xa̱ꞌa̱ ndiꞌi nañoo Israel. ");
INSERT INTO mim_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ta o̱n si̱ví ndasaá kuiti xa̱ꞌa̱ nañoo Israel kúu ña kivi̱ ta̱Jesús, ta kivi̱ ra xa̱ꞌa̱ ni̱vi na táku̱ ndiꞌi xiiña ñoyívi. Saá keꞌé ra xa̱ꞌa̱ ña nakaya ra ni̱vi na kúu sa̱ꞌya Ndios, na ndóo ndiꞌi saá xiiña no̱o̱ ñoꞌo̱, ña nduu na ñii tiꞌvi ni̱vi xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ta ki̱vi̱ na̱kutáꞌan naJunta Suprema yóꞌo, ta xi̱koo yuꞌú na, ta chi̱kaa̱ ini na kaꞌni na ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ta ña̱kán ta̱Jesús o̱n vása ní‑xika tívi ka̱ ra no̱o̱ ni̱vi, ta ke̱e ra ñoo estado Judea yóꞌo, ta ni̱xaa̱ ra ñii ñoo loꞌo na̱ní Efraín, ña nákaa̱ yatin no̱o̱ yóo yuku̱ yi̱chí. Ta ki̱ndo̱o ra yóꞌo xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ta saá xa yatin tónda̱a ki̱vi̱ ña kasa ndivi najudío viko̱ Pascua. Ta kua̱ꞌa̱ ní ni̱vi ke̱e na ñoo na, ta kua̱ꞌa̱n na ñoo Jerusalén. Ña siꞌna ka̱ ta̱ꞌán kana viko̱ Pascua yóꞌo, kua̱ꞌa̱n na xa̱ꞌa̱ ña kasa ndivi na nda̱yí ña ni̱taa ta̱Moisés kui̱ya̱ xi̱na̱ꞌá. Nda̱yí yóꞌo káꞌa̱n ña ndasaá keꞌé na xíꞌin mi̱i na ña koo ndii na no̱o̱ Ndios xa̱ꞌa̱ viko̱ yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ta ni̱xaa̱ na ñoo Jerusalén, ta na̱ndukú ní na ta̱Jesús ndiníí xiiña ñoo Jerusalén yóꞌo. Ta na̱kutáꞌan na yíta na ke̱ꞌe yatin yéꞌé veꞌe ño̱ꞌo káꞌno, ta ndáka̱ to̱ꞌon táꞌan na, káchí na saá: ―¿Yukía̱ xáni si̱ni̱ ndó? ¿Án xáni si̱ni̱ ndó kixaa̱ ta̱Jesús viko̱ Pascua yóꞌo? ―káchí na, káꞌa̱n na xíꞌin táꞌan na. ");
INSERT INTO mim_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ta nafariseo xíꞌin nasu̱tu̱ náꞌno no̱o̱ najudío xa siꞌna xa̱ꞌnda chiño na no̱o̱ ni̱vi, káchí na saá: ―Tá yóo ni̱vi na xíni̱ míkía̱ yóo ta̱Jesús, ta nayóꞌo xíni̱ ñóꞌó ndato̱ꞌon na xíꞌin nachiño náꞌno ña kuchiño tiin na ra ―káchí nanáꞌno yóꞌo, xa̱ꞌnda chiño na. ");
INSERT INTO mim_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ta i̱ño̱ ki̱vi̱ ya̱chi̱ ka̱ o̱n ta̱ꞌán kixáꞌá viko̱ Pascua, ta ndi̱kó tuku ta̱Jesús ki̱xaa̱ ra ñoo Betania no̱o̱ yóo ta̱Lázaro. Ta ta̱Lázaro yóꞌo kúu ta̱a ta̱ xa ni̱xiꞌi̱, ta ta̱Jesús sa̱nataku̱ ñaꞌá ra. ");
INSERT INTO mim_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ta ni̱xaa̱ ta̱Jesús ñii veꞌe no̱o̱ xa̱ki̱n na ñii viko̱ loꞌo ña kísa to̱ꞌó na ta̱Jesús. Ta ñáMarta xíka ñá táxi ña xíxi ni̱vi na ndóo viko̱ yóꞌo, ta ta̱Lázaro kándúꞌu̱ ra no̱o̱ yóo tón mesa, xíxi ra xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ta saá inka̱ ñáki̱ꞌva̱ ta̱Lázaro ñáMaría, ki̱xaa̱ ñá no̱o̱ yóo xa̱ꞌa̱ ta̱Jesús. Níꞌi ñá ñii yu̱yu̱ ña sava litro chútú ña xíꞌin nduta̱ va̱ꞌa tá xáꞌan támi, na̱ní rá nardo, tá yáꞌví ní kúu rá. Ta ñáMaría chi̱kaa̱ ñá rá xa̱ꞌa̱ ta̱Jesús, ta yákón ñá xa̱ꞌa̱ ra xíꞌin yisi̱ si̱ni̱ ñá. Ta siko̱ ña xáꞌan támi nduta̱ yóꞌo, ni̱xi̱ta̱ níꞌnó ndiꞌi ña ini veꞌe yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ta ñii ta̱xíka xíꞌin ta̱Jesús, na̱ní ra Judas Iscariote, sa̱ꞌya ta̱Simón kúu ra, ta o̱n váꞌa kóni ta̱yóꞌo xa̱ꞌa̱ ña ke̱ꞌé ñáñaꞌa̱ yóꞌo saá. Ta̱Judas yóꞌo kúu ta̱a ta̱ si̱kó kuíꞌná ta̱Jesús ndaꞌa̱ ni̱vi na sáa̱ ini xíni ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ta ni̱ka̱ꞌa̱n ta̱Judas, káchí ra saá: ―¿Nda̱chun o̱n vása ní‑sikó ñá nduta̱ yóꞌo xíꞌin yaꞌvi rá ña kúu u̱ni̱ ciento si̱ꞌún denario, ta saníꞌi ñá si̱ꞌún yóꞌo ndaꞌa̱ ni̱vi nandáꞌví, níkúu? ―káchí ta̱Judas xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ta o̱n si̱ví xa̱ꞌa̱ ña ndixa kíꞌvi ini ra xíni ra ni̱vi nandáꞌví kúu ña ni̱ka̱ꞌa̱n ta̱Judas saá, chi ta̱Judas kúu ta̱a ta̱ ndíso chiño xíꞌin si̱ꞌún ña xíni̱ ñóꞌó ta̱Jesús xíꞌin naxíka xíꞌin ra. Ta yóo sava ki̱vi̱ ta̱Judas kísa kuíꞌná ra loꞌo si̱ꞌún yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ta ta̱Jesús nda̱kuii̱n ra, ni̱ka̱ꞌa̱n ra xíꞌin ta̱Judas, káchí ra saá: ―O̱n sandiꞌi ún ñáñaꞌa̱ yóꞌo chi ñava̱ꞌa ke̱ꞌé ñá xíꞌin i̱. Saá chi chi̱kaa̱ va̱ꞌa ñá nduta̱ yóꞌo ña koni̱ ñóꞌó ñá rá ki̱vi̱ vitin xa̱ꞌa̱ ña kasa tiꞌva ñá yi̱kí ko̱ñu i̱, chi xa yatin kíxaa̱ ña kivi̱ i̱ ta ndu̱xu̱n i̱. ");
INSERT INTO mim_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ta ndóꞌó, ndiꞌi saá ki̱vi̱ yóo nandáꞌví xíꞌin ndó, ta yi̱ꞌi̱, saloꞌo ní ka̱ ki̱vi̱ yóo i̱ xíꞌin ndó ―káchí ta̱Jesús xíꞌin ni̱vi na ndóo viko̱ loꞌo yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kua̱ꞌa̱ ní najudío xi̱ni̱ so̱ꞌo na ña ki̱xaa̱ ta̱Jesús ñoo Betania, ta kua̱ꞌa̱n na koto na ra, ta ñii saá kóni na koto na ta̱Lázaro ta̱a ta̱ xi̱kuu ta̱ ni̱xiꞌi̱, ta ta̱Jesús sa̱nataku̱ ñaꞌá ra. ");
INSERT INTO mim_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ta saá nanáꞌno no̱o̱ nasu̱tu̱ na kúu na xa yóo yuꞌú ña kaꞌni na ta̱Jesús, ta vitin na̱koo yuꞌú nayóꞌo ña kaꞌni na ta̱Lázaro. ");
INSERT INTO mim_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kóni na kaꞌni na ta̱Lázaro chi kua̱ꞌa̱ ní najudío xa sa̱ndakoo na yichi̱ nasu̱tu̱ yóꞌo, ta ki̱xáꞌá na ndíko̱n na sa̱ta̱ ta̱Jesús, chi sa̱nataku̱ ra ta̱Lázaro. ");
INSERT INTO mim_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ta ni̱ti̱vi inka̱ ki̱vi̱, ta chútú ní ni̱vi ñoo Jerusalén chi xa kóni kixáꞌá viko̱ Pascua, ta ni̱vi na nákutáꞌan yóꞌo xi̱ni̱ so̱ꞌo na vitin kixaa̱ ta̱Jesús ñoo Jerusalén yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ta saá ke̱e na kua̱ꞌa̱n na, ta xa̱ꞌnda na no̱o̱ ndaꞌa̱ tón yito̱n ño̱o̱, ta níꞌi na kua̱ꞌa̱ ní ño̱o̱ yóꞌo, ta kua̱ꞌa̱n na nakutáꞌan na xíꞌin ta̱Jesús yichi̱ no̱o̱ va̱xi ra. Ta xíꞌin ndiꞌi ndee̱ na, ni̱ka̱ꞌa̱n na, káchí na saá: ―¡Ná kasa káꞌno yó Ndios! ¡Ná keꞌé Ndios ñava̱ꞌa xíꞌin ta̱yóꞌo, ta̱a ta̱ ki̱xaa̱ xíꞌin nda̱yí Ndios! ¡Ná keꞌé Ndios ñava̱ꞌa xíꞌin ta̱yóꞌo ta̱a ta̱ kúu Rey, ta̱káꞌno no̱o̱ naIsrael! ―káchí na, káꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ta ta̱Jesús xa na̱níꞌi ra ñii burro loꞌo ta yóso ra va̱xi ra. Saá ki̱sa ndivi ra ña káchí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá, ña káchí saá: ");
INSERT INTO mim_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","O̱n kuyi̱ꞌví ndó, nañoo Jerusalén. Koto ndó, yóꞌo va̱xi ta̱a ta̱ kúu Rey no̱o̱ ndó, va̱xi ra yóso ra ñii burro loꞌo, saá káchí to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ta naxíka xíꞌin ta̱Jesús o̱n vása ní‑kunda̱a̱ ini na yukía̱ kóni kachí ndiꞌi ña xíto na yóꞌo. Ta saá ni, ki̱vi̱ ndi̱ꞌi ku̱ndivi ña ni̱xiꞌi̱ ta̱Jesús ta na̱taku̱ ra ta ndi̱kó ra nda̱a ra ñoyívi ni̱no, ta̱nda̱ saá na̱káꞌán na to̱ꞌon Ndios ña ni̱taa na xi̱na̱ꞌá xa̱ꞌa̱ ta̱Jesús. Ta saá ku̱nda̱a̱ ini na ndí ndiꞌi ña ke̱ꞌé ni̱vi xíꞌin ta̱Jesús kúu ña ki̱sa ndivi na to̱ꞌon Ndios yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ni̱xi̱yo kua̱ꞌa̱ ní ni̱vi na xi̱ni ta̱Jesús ki̱vi̱ sa̱nataku̱ ra ta̱Lázaro. Chi ta̱ xa ni̱xiꞌi̱ xi̱kuu ra, ta ni̱ndu̱xu̱n ra ti̱xin kavua̱, ta saá ki̱xaa̱ ta̱Jesús, ta ka̱na ra ta̱Lázaro xíꞌin ki̱vi̱ ra, ta sa̱nataku̱ ñaꞌá ra. Ta ni̱vi na xi̱ni ñayóꞌo xa̱ta níꞌnó na to̱ꞌon xa̱ꞌa̱ ñava̱ꞌa yóꞌo ke̱ꞌé ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ña̱kán kía̱ ndiꞌi ni̱vi na xi̱ni̱ so̱ꞌo to̱ꞌon yóꞌo, ke̱e na kua̱ꞌa̱n na ña nakutáꞌan na xíꞌin ta̱Jesús yichi̱ no̱o̱ va̱xi ra ña kixaa̱ ra ñoo Jerusalén. ");
INSERT INTO mim_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ta xa̱ꞌa̱ ñayóꞌo nafariseo ni̱ka̱ꞌa̱n na xíꞌin táꞌan na, káchí na saá: ―¡Nda̱ ma̱ni̱ kúu ña ndukú yó kundeé yó no̱o̱ ta̱yóꞌo! ¡Koto ndó! Ndiꞌi saá ni̱vi ñoyívi yóꞌo ndíko̱n na sa̱ta̱ ta̱Jesús vitin ―káchí na, káꞌa̱n na xíꞌin táꞌan na. ");
INSERT INTO mim_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ta sava ni̱vi na ki̱xaa̱ ñoo Jerusalén ña kasa to̱ꞌó na Ndios viko̱ Pascua kúu na inka̱ ñoo, ta káꞌa̱n na to̱ꞌon griego. ");
INSERT INTO mim_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ta sava nagriego yóꞌo ki̱xaa̱ na no̱o̱ ñii ta̱xíka xíꞌin ta̱Jesús ta̱ na̱ní Felipe, ta̱a ta̱ ke̱e ñoo Betsaida estado Galilea kúu ra. Ki̱xaa̱ nagriego no̱o̱ ta̱Felipe yóꞌo, ta ni̱ka̱ꞌa̱n na xíꞌin ra, káchí na saá: ―Tata, kóni ndi̱ koto ndi̱ ta̱Jesús ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ta ta̱Felipe ni̱xa̱ꞌa̱n ra nda̱to̱ꞌon ra xíꞌin inka̱ ta̱xíka xíꞌin ta̱Jesús, ta̱ na̱ní Andrés, ta ndio̱vi̱ na saá ke̱e na kua̱ꞌa̱n na, ta ni̱xaa̱ na no̱o̱ ta̱Jesús ña ndato̱ꞌon na xíꞌin ra xa̱ꞌa̱ ña kóni nagriego yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra saá: ―Xa kíxaa̱ yatin ní ki̱vi̱ ña yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios, kasa ndivi i̱ chiño káꞌno, ta xa̱ꞌa̱ ñayóꞌo Ndios kasa káꞌno ra yi̱ꞌi̱, ta kanóo síkón ñato̱ꞌó i̱. ");
INSERT INTO mim_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ta ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó tá yóo ñii ndiki̱n trigo, ta tá o̱n chiꞌi ni̱vi ndiki̱n yóꞌo, ta kindo̱o matóꞌón ña. Ta saá ni, tá chiꞌi ni̱vi ndiki̱n trigo yóꞌo ti̱xin ñoꞌo̱, ta saá ndixa ta̱ꞌvi̱ so̱o̱ ña, ta ndu̱ta̱ ña ta kuaꞌno ña, ta nduu ña kua̱ꞌa̱ ní ndiki̱n trigo. Ta nda̱tán yóo ndiki̱n trigo ña chiꞌi ni̱vi ti̱xin ñoꞌo̱ saá yóo i̱ chi xíni̱ ñóꞌó kivi̱ i̱, ta ndu̱xu̱n i̱, ta nataku̱ i̱. Ta xa̱ꞌa̱ ña kundoꞌo i̱ saá, kua̱ꞌa̱ ní ni̱vi kutaku̱ na xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ta nda̱tán yi̱ꞌi̱ táxi xíꞌin mi̱i i̱ ña kasa ndivi i̱ ña kóni Ndios, ñii ki̱ꞌva saá ni̱vi na ndíko̱n yichi̱ i̱, xíni̱ ñóꞌó na taxi xíꞌin mi̱i na ña keꞌé na ña kóni Ndios. Chi ndiꞌi ni̱vi na ndasaá kuiti kúsii̱ ini kutaku̱ va̱ꞌa ñoyívi yóꞌo, nayóꞌo ndañóꞌó na no̱o̱ Ndios. Ta ndiꞌi ni̱vi na o̱n vása ndíꞌi ní ini xa̱ꞌa̱ ña kutaku̱ va̱ꞌa na ñoyívi yóꞌo, nayóꞌo kúu na naníꞌi yichi̱ nda̱a̱ ña va̱ꞌa kutaku̱ na xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ndiꞌi ni̱vi na kóni kasa chiño no̱o̱ i̱, xíni̱ ñóꞌó kundiko̱n na yichi̱ i̱, ta saá nda̱tán yóo ña kéꞌé i̱, saá keꞌé na. Ta Yivá i̱ Ndios kasa to̱ꞌó ra ndiꞌi ni̱vi na kúu na kísa chiño no̱o̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Ta vitin ndíꞌi ní ini i̱, ta xáni ní ini i̱ yukía̱ ka̱ꞌa̱n i̱ xíꞌin Ndios. ¿Án ndukú i̱ no̱o̱ Yivá i̱ Ndios ña saka̱ku ra yi̱ꞌi̱ no̱o̱ ña xo̱ꞌvi̱ ní i̱? Óꞌon, o̱n ka̱ꞌa̱n i̱ saá, chi xa̱ꞌa̱ ña kasa ndivi i̱ chiño yo̱ꞌvi̱ ní, nda̱ kivi̱ i̱ kúu ña ki̱xaa̱ i̱ ñoyívi yóꞌo ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ta saá ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin Ndios, káchí ra saá: ―Tata Yivá i̱, vitin kasa ndivi ún chiño xa̱ꞌa̱ ña kasa káꞌno ni̱vi yóꞌó ta chinóo síkón na ñato̱ꞌó ún ―káchí ta̱Jesús xíꞌin Ndios. Ta saá xi̱ni̱ so̱ꞌo ra ta̱chi̱ to̱ꞌon Ndios ña ki̱xi ñoyívi ni̱no ña ni̱ka̱ꞌa̱n ña, káchí ña saá: ―Xa ki̱sa ndivi i̱ chiño káꞌno ña ki̱sa káꞌno ni̱vi yi̱ꞌi̱, ta chi̱nóo síkón na ñato̱ꞌó i̱, ta tuku inka̱ yichi̱ keꞌé i̱ saá ―káchí to̱ꞌon ni̱ka̱ꞌa̱n ña xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ta ni̱vi na ndóo xíꞌin ta̱Jesús xi̱ni̱ so̱ꞌo na ta̱chi̱ yóꞌo, ta sava ni̱vi xa̱ni si̱ni̱ na án ndáꞌyi sa̱vi̱. Ta inka̱ na ni̱ka̱ꞌa̱n, káchí na: ―Ñii ángel ña ki̱xi no̱o̱ Ndios ni̱ka̱ꞌa̱n ña xíꞌin ra ―káchí na, káꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin na: ―O̱n si̱ví xa̱ꞌa̱ yi̱ꞌi̱ kúu ña ni̱ka̱ꞌa̱n ta̱chi̱ yóꞌo, ta ni̱ka̱ꞌa̱n ta̱chi̱ yóꞌo xa̱ꞌa̱ ña chindeé ña ndóꞌó ña ndixa kandixa ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vitin xa yatin kíxaa̱ ki̱vi̱ ña kasa nani Ndios xa̱ꞌa̱ kua̱chi ni̱vi ñoyívi yóꞌo. Ta saá ñaníma̱ ndiva̱ꞌa káꞌno, ña kúu ña xáꞌnda chiño no̱o̱ ni̱vi ñoyívi yóꞌo vitin, Ndios sakana ra níma̱ yóꞌo ko̱ꞌo̱n ña ke̱ꞌe no̱o̱ naa ní. ");
INSERT INTO mim_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ta yi̱ꞌi̱, ki̱vi̱ ndaníꞌi ni̱vi yi̱ꞌi̱ no̱o̱ síkón, ta xíꞌin ñayóꞌo keꞌé i̱ ña ndiꞌi ni̱vi kixaa̱ na no̱o̱ i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ni̱ka̱ꞌa̱n ra to̱ꞌon yóꞌo ña ndato̱ꞌon ra xíꞌin ni̱vi ña kunda̱a̱ ini na ndí kivi̱ ra ndaꞌa̱ tón cruz. ");
INSERT INTO mim_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ta nda̱kuii̱n ni̱vi, ni̱ka̱ꞌa̱n na, káchí na saá: ―Xa ka̱ꞌvi ndi̱ to̱ꞌon Ndios ña ni̱taa na kui̱ya̱ xi̱na̱ꞌá ña káchí xa̱ꞌa̱ Cristo, ta̱a ta̱ tiꞌví Ndios. Ta to̱ꞌon yóꞌo káchí ña ndí Cristo kutaku̱ ra ndiꞌi saá ki̱vi̱ ña va̱xi. Ta yóꞌó káchí ún ndí ndaníꞌi na ta̱a ta̱ ki̱xi no̱o̱ Ndios, ta sandaa na ra ndaꞌa̱ tón cruz. Ta, ¿yu kúu ta̱a ta̱ káꞌa̱n ún xa̱ꞌa̱, ta̱ káchí ún kúu ta̱a ta̱ ki̱xi no̱o̱ Ndios? ―káchí na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin na: ―Nda̱tán yóo ñoꞌo̱ ndinoꞌo yéꞌe, saá yóo i̱, ta saloꞌo kuiti ka̱ ki̱vi̱ yóo i̱ xíꞌin ndó. Xíni̱ ñóꞌó kundiko̱n ndó yichi̱ i̱ ña yéꞌe ndinoꞌo, ko̱to̱ ñii kama nakiꞌin yichi̱ ña naa ndóꞌó. Chi ni̱vi na xíka yichi̱ naa o̱n vása xíni̱ nayóꞌo míchí kua̱ꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yi̱ꞌi̱ kúu Ñoꞌo̱ ndinoꞌo yéꞌe, ta vitin ki̱vi̱ ña yóo ka̱ i̱ xíꞌin ndó, xíni̱ ñóꞌó kandixa ndó yi̱ꞌi̱. Ta saá nduu ndó ni̱vi na kua̱ꞌa̱n yichi̱ no̱o̱ yéꞌe Ñoꞌo̱ ndinoꞌo ―káchí ta̱Jesús xíꞌin na. Ta ndi̱ꞌi ni̱ka̱ꞌa̱n ra saá, ta ke̱e ra kua̱ꞌa̱n ra, ta ni̱xaa̱ ra ñii xiiña no̱o̱ chi̱seꞌé xíꞌin mi̱i ra ko̱to̱ naníꞌi nani̱vi ra. ");
INSERT INTO mim_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Vará ta̱Jesús xa ke̱ꞌé ra kua̱ꞌa̱ ní milagro xi̱ni ni̱vi, ta saá ni, ni̱‑xiin na kandixa na ra. ");
INSERT INTO mim_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ta xíꞌin ña o̱n kandixa na ra, ki̱sa ndivi na ña ni̱ka̱ꞌa̱n to̱ꞌon Ndios ña ni̱taa ta̱profeta Isaías kui̱ya̱ xi̱na̱ꞌá, ña káchí saá: Yivá yó Ndios, loꞌo ní ni̱vi ka̱ndixa na to̱ꞌon ún ña nda̱to̱ꞌon i̱ xíꞌin na. Ni o̱n vása ní‑kunda̱a̱ ini na ndí xíꞌin ndee̱ mi̱i ún kúu ña ki̱sa ndivi i̱ ndiꞌi chiño náꞌno ña xi̱ni na, káchí to̱ꞌon ña ni̱taa ta̱Isaías xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Vitin kísa ndivi najudío yóꞌo nda̱tán yóo ña ni̱taa ta̱Isaías kui̱ya̱ xi̱na̱ꞌá, chi ni̱‑kuchiño na kandixa na ta̱Jesús. Ta inka̱ xiiña no̱o̱ to̱ꞌon Ndios ña ni̱taa ta̱Isaías xi̱na̱ꞌá, káchí ña saá xa̱ꞌa̱ ni̱vi yóꞌo: ");
INSERT INTO mim_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","O̱n vása ní‑xiin na nakoni na ta ko̱ꞌo̱n na yichi̱ ña kúu ñanda̱a̱, ña̱kán kía̱ Ndios ta̱xi ra ña nduu nayóꞌo nda̱tán yóo ni̱vi nakuáá, chi o̱n vása kúchiño na koni na ñanda̱a̱. Ta xa̱ꞌa̱ ña ni̱‑xiin na kandixa na ñanda̱a̱, Ndios ta̱xi ra ña nduu toon ní ka̱ ini na, nduu na ni̱vi na o̱n vása kúchiño kandixa ñanda̱a̱. Ta xa̱ꞌa̱ ni̱vi yóꞌo, Ndios ni̱ka̱ꞌa̱n ra, ka̱chí ra saá: “Nda̱ loꞌo ni̱‑xiin na nandikó ini na, ta ni̱‑xiin na kixi na no̱o̱ i̱ xa̱ꞌa̱ ña sandaꞌa i̱ na ña va̱ꞌa kutaku̱ na yichi̱ nda̱a̱”, ka̱chí Ndios no̱o̱ to̱ꞌon ra ña ni̱taa ta̱Isaías kui̱ya̱ xi̱na̱ꞌá. ");
INSERT INTO mim_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ta̱Isaías yóꞌo xi̱kuu ñii ta̱profeta ta̱ ni̱ka̱ꞌa̱n ndoso to̱ꞌon Ndios kui̱ya̱ xi̱na̱ꞌá, ta xi̱ni ra ndiꞌi ndee̱ ña livi káꞌno ña kómí ta̱Jesús ñoyívi ni̱no. Ta saá ta̱Isaías ni̱taa ra to̱ꞌon yóꞌo, ña ndáto̱ꞌon xa̱ꞌa̱ ña ndóꞌo ta̱Jesús ki̱vi̱ táku̱ ra ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Vará sava nachiño náꞌno no̱o̱ najudío kándixa na ta̱Jesús ndí ndixa kúu ra ta̱a ta̱ ti̱ꞌví Ndios, ta o̱n vása ní‑xiin na ka̱ꞌa̱n na saá xíꞌin inka̱ ni̱vi chi yíꞌví na no̱o̱ nafariseo. Saá chi nafariseo xa xa̱ꞌnda chiño na ndí ndiꞌi ni̱vi na kándixa ndí ta̱Jesús kúu Cristo, ta̱a ta̱ ti̱ꞌví Ndios va̱xi, nayóꞌo o̱n kuchiño ka̱ na ki̱ꞌvi na ini veꞌe ño̱ꞌo sinagoga, káchí nafariseo. ");
INSERT INTO mim_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ndiꞌi ni̱vi na kúu na yíꞌví ka̱ꞌa̱n ña kándixa na ta̱Jesús, nayóꞌo xáni si̱ni̱ na ndí ña ndáya̱ꞌví ní ka̱ kúu ña kanóo va̱ꞌa ñato̱ꞌó na no̱o̱ ni̱vi ñoyívi yóꞌo, ta xáni si̱ni̱ na loꞌo ní ndáya̱ꞌví ña kúu ña kanóo va̱ꞌa ñato̱ꞌó na no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ta saá xíꞌin ndiꞌi ndee̱ ra, ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ni̱vi, káchí ra saá: ―Ta ni̱vi na kándixa yi̱ꞌi̱, nayóꞌo o̱n si̱ví ñii la̱á mi̱i i̱ kándixa na, ta kándixa na Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ta ni̱vi na xíni yi̱ꞌi̱, nayóꞌo xíni na Yivá i̱ Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yi̱ꞌi̱ kúu Ñoꞌo̱ ndinoꞌo yéꞌe ñoyívi yóꞌo. Ta ndiꞌi ni̱vi na ndixa kándixa yi̱ꞌi̱, nayóꞌo o̱n ko̱ꞌo̱n ka̱ na yichi̱ no̱o̱ naa. ");
INSERT INTO mim_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ta ndiꞌi ni̱vi na kuiti xíni̱ so̱ꞌo to̱ꞌon ña káꞌa̱n i̱, ta o̱n xi̱in na kasa ndivi na ña, ta o̱n si̱ví yi̱ꞌi̱ kúu ta̱a ta̱ kasa nani xa̱ꞌa̱ ña o̱n váꞌa kéꞌé nayóꞌo. Saá chi o̱n si̱ví xa̱ꞌa̱ ña kasa nani i̱ xa̱ꞌa̱ kua̱chi ni̱vi kúu ña ki̱xaa̱ i̱ ñoyívi yóꞌo, ta xa̱ꞌa̱ ña saka̱ku i̱ ni̱vi ñoyívi yóꞌo kúu ña ki̱xaa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ta ni̱vi na o̱n xi̱in koni yi̱ꞌi̱, ta ni o̱n xi̱in na kandixa na to̱ꞌon i̱, ta ndixa xa yóo ña kasa nani xa̱ꞌa̱ kua̱chi nayóꞌo. Chi tá ki̱xaa̱ ki̱vi̱ sondíꞌí ñoyívi yóꞌo, ta mi̱i to̱ꞌon ña ni̱ka̱ꞌa̱n i̱ xíꞌin nayóꞌo kasa nani xa̱ꞌa̱ kua̱chi na ña kúu ña o̱n vása ní‑xiin na chikaa̱ so̱ꞌo na to̱ꞌon yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chi xíꞌin nda̱yí Yivá i̱ Ndios káꞌa̱n i̱ to̱ꞌon ña ndáto̱ꞌon i̱ xíꞌin ndó. Ta o̱n si̱ví ndasaá kuiti to̱ꞌon mi̱i i̱ kúu ña káꞌa̱n i̱. Saá chi Yivá i̱ Ndios kúu ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱, ta xa̱ꞌnda chiño ra ndá to̱ꞌon kúu ña ka̱ꞌa̱n i̱ xíꞌin ndó, ta xa̱ꞌnda chiño ra yu kúu ña sanáꞌa i̱ ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ta yi̱ꞌi̱, xíni̱ va̱ꞌa i̱ ndí ña xáꞌnda chiño Yivá i̱ Ndios kúu ña táxi kutaku̱ ndinoꞌo ni̱vi ndiꞌi saá ki̱vi̱. Ta ñii ki̱ꞌva nda̱tán yóo to̱ꞌon ña xa̱ꞌnda chiño ra ka̱ꞌa̱n i̱, saá káꞌa̱n i̱ xíꞌin ni̱vi ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ta o̱n ta̱ꞌán ka̱ kixáꞌá kana viko̱ Pascua, ta ta̱Jesús xíni̱ ra ña xa yatin ní to̱nda̱a ki̱vi̱ ña kee ra ñoyívi yóꞌo, ta ndikó ra noꞌo̱ ra no̱o̱ yóo Yivá yó Ndios. Ndiꞌi saá ki̱vi̱ ta̱Jesús xa kíꞌvi ní ini ra xíni ra ni̱vi na kándixa ñaꞌá ñoyívi yóꞌo, ta vitin ki̱xaa̱ ki̱vi̱ ña sanáꞌa ra na ndasaá ndixa ndeé ní kíꞌvi ini ra xíni ra na, chi nda̱ loꞌo o̱n ndiꞌi ña kíꞌvi ini ra xíni ra na. ");
INSERT INTO mim_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ta xikuaa ní, xa kóni kunaa kúu ña, ta saá yóo ta̱Jesús xíxi ra xíꞌin naxíka xíꞌin ra. Ta ñaníma̱ ndiva̱ꞌa káꞌno xa chi̱kaa̱ ña ini ta̱Judas Iscariote, sa̱ꞌya ta̱Simón, ña nataxi ra ta̱Jesús ndaꞌa̱ ni̱vi na sáa̱ ini xíni ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ta ta̱Jesús kúnda̱a̱ ini ra ndí Yivá ra Ndios xa ta̱xi ra ndaꞌa̱ ra ndiꞌi nda̱yí no̱o̱ ndiꞌi ña yóo, ta xíni̱ ta̱Jesús ña ki̱xi ra no̱o̱ Ndios ta vitin ya̱chi̱ ní ndikó ra noꞌo̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ta saá na̱kundichi ra ta ta̱va ra tiko̱to̱ káni̱ ña kánóo sa̱ta̱ tiko̱to̱ ndíxin ra, ta chi̱nóo va̱ꞌa ra ña ñii xiiña, ta saá ka̱tón ra ñii toalla to̱ko̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chi̱kaa̱ ra takuií ini ñii ka̱a ña kónó ini, ta ki̱xáꞌá ra nakata ra xa̱ꞌa̱ ñii ñii ta̱xíka xíꞌin ra. Ta xíꞌin toalla yákón ra xa̱ꞌa̱ ñii ñii ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tá ki̱xaa̱ ra no̱o̱ yóo xa̱ꞌa̱ ta̱Simón Pedro, ta ni̱ka̱ꞌa̱n ta̱Pedro xíꞌin ra: ―Tata, yóꞌó kúu ta̱a ta̱káꞌno no̱o̱ i̱. ¿Án nakata ún xa̱ꞌa̱ i̱? ");
INSERT INTO mim_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Vitin o̱n vása kúnda̱a̱ ini ún yukía̱ kóni kachí ña kéꞌé i̱ yóꞌo, ta ñii ki̱vi̱ va̱xi kunda̱a̱ va̱ꞌa ini ún xa̱ꞌa̱ ñayóꞌo ―káchí ta̱Jesús xíꞌin ta̱Pedro. ");
INSERT INTO mim_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","―O̱n váꞌa saá, Tata ―káchí ta̱Pedro xíꞌin ta̱Jesús ―nda̱ ñii ki̱vi̱ o̱n taxi i̱ nakata ún xa̱ꞌa̱ i̱ ―káchí ra. Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Tá o̱n taxi ún nakata i̱ xa̱ꞌa̱ ún, ta o̱n kuchiño ka̱ ún kuu ún ta̱a ta̱ ndíko̱n yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ta nda̱kuii̱n ta̱Pedro, ni̱ka̱ꞌa̱n ra: ―Tá saá yóo ña káꞌa̱n ún, Tata, ta va̱ꞌa ka̱ o̱n nakata ún ndasaá kuiti xa̱ꞌa̱ i̱, ta nakata ún nda̱ ndaꞌa̱ i̱ ta̱nda̱ si̱ni̱ i̱ ―káchí ta̱Pedro xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Ndiꞌi ni̱vi na xa chi̱chi takuií, na xa yóo ndii ndiꞌi sa̱ta̱ ko̱ñu kúu nayóꞌo, ta ndasaá kuiti xíni̱ ñóꞌó ndoo xa̱ꞌa̱ na. Ta ndóꞌó, nani̱vi ndii kúu ndó, ta saá ni, o̱n si̱ví ndiꞌi ndó kúu ni̱vi ndii ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ni̱ka̱ꞌa̱n ra saá xíꞌin na, chi xíni̱ ra yu kúu ta̱a ta̱ nataxi kuíꞌná ñaꞌá ndaꞌa̱ ni̱vi na sáa̱ ini xíni ñaꞌá. ");
INSERT INTO mim_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tá ndi̱ꞌi na̱kata ra xa̱ꞌa̱ naxíka xíꞌin ra, ta na̱kundixin ra tiko̱to̱ ra, ta tuku na̱koo ra no̱o̱ yóo tón mesa, no̱o̱ xíxi ra xíꞌin na. Ta saá ni̱nda̱ka̱ to̱ꞌon ra na, káchí ra saá xíꞌin na: ―¿Án kúnda̱a̱ ini ndó yukía̱ kóni kachí ñachiño ke̱ꞌé i̱ ña na̱kata i̱ xa̱ꞌa̱ ndó? ");
INSERT INTO mim_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Chi ndóꞌó káchí ndó yi̱ꞌi̱ kúu ta̱Káꞌno no̱o̱ ndó, ta káchí ndó xíꞌin i̱ kúu i̱ ta̱Maestro ndó, ta ñanda̱a̱ kúu ña káchí ndó saá. ");
INSERT INTO mim_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ta xa̱ꞌa̱ ña kúu i̱ ta̱Maestro ndó, ta xa̱ꞌa̱ ña kúu i̱ ta̱Káꞌno no̱o̱ ndó, ndixa xíni̱ ñóꞌó kasa ndivi ndó chiño nda̱tán yóo ña ki̱sa ndivi i̱ xíꞌin ndó, ta̱nda̱ kasa ni̱no̱ ka̱ xíꞌin mi̱i ndó ta saá koo tiꞌva ndó nakata ndó xa̱ꞌa̱ táꞌan ndó. ");
INSERT INTO mim_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Saá chi xa chi̱ndúꞌu̱ i̱ ña ke̱ꞌé i̱ yóꞌo ña sanáꞌa i̱ ndóꞌó, ta ñii ki̱ꞌva saá xíni̱ ñóꞌó keꞌé ndó xíꞌin táꞌan ndó. Yi̱ꞌi̱ ki̱sa ni̱no̱ xíꞌin mi̱i i̱ xa̱ꞌa̱ ña chindeé i̱ ndóꞌó, ta ñii ki̱ꞌva saá xíni̱ ñóꞌó kasa ni̱no̱ xíꞌin mi̱i ndó xa̱ꞌa̱ ña chindeé táꞌan ndó. ");
INSERT INTO mim_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ña ndixa nda̱a̱ kúu to̱ꞌon yóꞌo: Nda̱ ñii ta̱mozo o̱n vása kúu ra ta̱ káꞌno ka̱ no̱o̱ ta̱ xáꞌnda chiño no̱o̱ ra, ta nda̱ ñii ta̱a ta̱ tíꞌví ta̱patrón ko̱ꞌo̱n chiño no̱o̱ ra, o̱n vása kúu ta̱yóꞌo ta̱ káꞌno ka̱ no̱o̱ ta̱patrón ta̱ ti̱ꞌví ñaꞌá ko̱ꞌo̱n ra chiño. ");
INSERT INTO mim_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ta ndóꞌó, tá ndixa kúnda̱a̱ ini ndó to̱ꞌon yóꞌo, ta saá ná kunakaa̱ ñasi̱i̱ ini ndó xa̱ꞌa̱ ña ki̱sa ndivi ndó ña. ");
INSERT INTO mim_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’O̱n vása káꞌa̱n i̱ saá xa̱ꞌa̱ ndiꞌi ndó, chi xíni̱ va̱ꞌa i̱ ini ñii ñii ndóꞌó na kúu ni̱vi na na̱ka̱xin i̱. Ta yóo to̱ꞌon Ndios ña ni̱taa na kui̱ya̱ xi̱na̱ꞌá, ña káchí saá: “Ñii ta̱a ta̱ yóo xíxi si̱ta̱ va̱ꞌa xíꞌin i̱, vitin ta̱yóꞌo ndu̱u ra ta̱ sáa̱ ini xíni yi̱ꞌi̱”, káchí to̱ꞌon Ndios. Ta ndiꞌi to̱ꞌon Ndios yóꞌo xíni̱ ñóꞌó kundivi ña. ");
INSERT INTO mim_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ndáto̱ꞌon i̱ ñayóꞌo xíꞌin ndó vitin ña o̱n ta̱ꞌán ka̱ kundivi ña. Ta saá tá kixaa̱ ki̱vi̱ ña kundivi ndiꞌi ñayóꞌo, ta kandixa ndó ndí Yi̱ꞌi̱ Kúu i̱ ta̱a ta̱ ki̱xi no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó, ndiꞌi ni̱vi na nákiꞌin va̱ꞌa ni̱vi na ti̱ꞌví i̱ ko̱ꞌo̱n chiño no̱o̱ i̱, ña kéꞌé na saá kóni kachí ña nákiꞌin va̱ꞌa na yi̱ꞌi̱. Ta ndiꞌi ni̱vi na nákiꞌin va̱ꞌa yi̱ꞌi̱, ña kéꞌé na saá kóni kachí ña nákiꞌin va̱ꞌa na Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ va̱xi i̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ta saá ta̱Jesús kónó ní nákaa̱ ña ndíꞌi ní ini ra, nda̱ sákisin ña níma̱ ra, ta ni̱ka̱ꞌa̱n ra xíꞌin naxíka xíꞌin ra: ―Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó vitin ndí ñii ndóꞌó kúu ta̱a ta̱ si̱kó kuíꞌná yi̱ꞌi̱ ta nataxi ra yi̱ꞌi̱ ndaꞌa̱ ni̱vi na sáa̱ ini xíni yi̱ꞌi̱ ―káchí ra xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ta naxíka xíꞌin ra na̱koto na no̱o̱ táꞌan na, ta xáni si̱ni̱ na yu kúu ta̱a ta̱ káꞌa̱n ta̱Jesús xa̱ꞌa̱. ");
INSERT INTO mim_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ta ñii ta̱xíka xíꞌin ta̱Jesús, ta̱ kúu ta̱ kíꞌvi ní ini ta̱Jesús xíni ra, yóo yatin ra sii̱n ta̱Jesús, ");
INSERT INTO mim_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ta ta̱Simón Pedro ni̱xika ndaꞌa̱ ra no̱o̱ ta̱yóꞌo ña nda̱ka̱ to̱ꞌon ra ta̱Jesús yu kúu ta̱a ta̱ káꞌa̱n ra xa̱ꞌa̱. ");
INSERT INTO mim_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ta saá ta̱yóꞌo ndi̱kó koo ra ta na̱koto ra no̱o̱ ta̱Jesús, ta ni̱nda̱ka̱ to̱ꞌon ñaꞌá ra, káchí ra saá: ―¿Yu kúu ta̱a ta̱ káꞌa̱n ún xa̱ꞌa̱, Tata? ―káchí ra. ");
INSERT INTO mim_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Kúu ra ta̱a ta̱ taxi i̱ ndaꞌa̱ si̱ta̱ va̱ꞌa ña chindaxin i̱ yóꞌo ―káchí ta̱Jesús. Ta chi̱ndaxin ra si̱ta̱ va̱ꞌa ta ta̱xi ra ña ndaꞌa̱ ta̱Judas Iscariote ta̱ kúu sa̱ꞌya ta̱Simón. ");
INSERT INTO mim_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ta ta̱Judas na̱kiꞌin ra si̱ta̱ va̱ꞌa yóꞌo, ta xi̱xi ra ña, ta saá xa̱ndi̱ko̱n ñaníma̱ ndiva̱ꞌa káꞌno na̱ní Satanás ni̱ki̱ꞌvi ña ini ra. Ta ta̱Jesús ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Va̱ꞌa kama kasa ndivi ún chiño ña chi̱kaa̱ ini ún keꞌé ún ―káchí ra xíꞌin ta̱Judas. ");
INSERT INTO mim_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ta nda̱ ñii naxíka xíꞌin ra na ndóo xíxi no̱o̱ mesa, o̱n vása kúnda̱a̱ ini na nda̱chun ni̱ka̱ꞌa̱n ta̱Jesús saá xíꞌin ta̱Judas. ");
INSERT INTO mim_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Saá chi ta̱Judas kúu ta̱ ndíso chiño xíꞌin si̱ꞌún ña sáta na ña xíni̱ ñóꞌó ta̱Jesús xíꞌin ndiꞌi naxíka xíꞌin ra, ta saá sava na xáni si̱ni̱ na ndí ta̱Jesús káꞌa̱n ra xíꞌin ta̱Judas ña ko̱ꞌo̱n ra sata ra ña koni̱ ñóꞌó na xa̱ꞌa̱ viko̱ Pascua, án káꞌa̱n ra xíꞌin ta̱Judas ña taxi ra loꞌo si̱ꞌún ndaꞌa̱ ni̱vi na kúu nandáꞌví. ");
INSERT INTO mim_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tá ndi̱ꞌi xi̱xi ta̱Judas si̱ta̱ va̱ꞌa ña ta̱xi ta̱Jesús ndaꞌa̱ ra, ta ke̱e ra kua̱ꞌa̱n ra ke̱ꞌe. Ta xa ñoó ní kúu ña. ");
INSERT INTO mim_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ta ndi̱ꞌi ke̱e ta̱Judas, kua̱ꞌa̱n ra ke̱ꞌe, ta ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin na ni̱ndo̱o xíꞌin ra, káchí ra saá: ―Vitin kasa ndivi i̱ ñii ñava̱ꞌa káꞌno, ta xa̱ꞌa̱ ñayóꞌo ni̱vi kasa káꞌno na yi̱ꞌi̱ ta chinóo síkón na ñato̱ꞌó yi̱ꞌi̱, ta̱a ta̱ ki̱xi no̱o̱ Ndios. Ta ñii ki̱ꞌva saá kasa káꞌno na Ndios ta chinóo síkón na ñato̱ꞌó ra, xa̱ꞌa̱ ñava̱ꞌa káꞌno yóꞌo ña kasa ndivi i̱. ");
INSERT INTO mim_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ndixa xíꞌin ñava̱ꞌa ña kasa ndivi i̱ vitin, yi̱ꞌi̱ chinóo síkón i̱ ñato̱ꞌó Ndios. Ta mi̱i Ndios chinóo síkón ra ñato̱ꞌó yi̱ꞌi̱. Ta ya̱chi̱ ní kasa ndivi Ndios saá. ");
INSERT INTO mim_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ta ndóꞌó, sa̱ꞌya mi̱i i̱, saloꞌo kuiti ki̱vi̱ yóo ka̱ i̱ xíꞌin ndó, ta vitin ndato̱ꞌon i̱ xíꞌin ndó nda̱tán yóo to̱ꞌon ña xa ni̱ka̱ꞌa̱n i̱ xíꞌin nanáꞌno no̱o̱ najudío, ki̱vi̱ ni̱ka̱ꞌa̱n i̱ xíꞌin na, ka̱chí i̱ saá: “Nandukú ndó yi̱ꞌi̱, ta o̱n kuchiño ndó ko̱ꞌo̱n ndó no̱o̱ ko̱ꞌo̱n i̱”, saá ka̱chí i̱ xíꞌin na, ta ñii ki̱ꞌva saá káꞌa̱n i̱ xíꞌin ndóꞌó vitin. ");
INSERT INTO mim_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ta vitin ndato̱ꞌon i̱ xíꞌin ndó xáꞌnda chiño i̱ no̱o̱ ndó ñii nda̱yí xa̱á, ña káchí saá: Ndixa kukiꞌvi ní ini ndó koni táꞌan ndó. Ñii ki̱ꞌva nda̱tán kíꞌvi ini i̱ xíni i̱ ndóꞌó, saá kukiꞌvi ní ini ndó koni táꞌan ndó. ");
INSERT INTO mim_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tá ndixa kíꞌvi ini ndó xíni táꞌan ndó, ta xa̱ꞌa̱ ñayóꞌo ndiꞌi ni̱vi kunda̱a̱ ini na ndí ndóꞌó kúu ni̱vi na kándixa yi̱ꞌi̱ ta ndíko̱n ndó yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ta ta̱Simón Pedro ni̱nda̱ka̱ to̱ꞌon ra ta̱Jesús, káchí ra saá: ―Tata, ¿míchí ko̱ꞌo̱n ún? Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra: ―Vitin o̱n ki̱ví ko̱ꞌo̱n ún xíꞌin i̱ no̱o̱ ko̱ꞌo̱n i̱. Ta saá ni, tá ndi̱ꞌi ni̱yaꞌa kua̱ꞌa̱ ní ki̱vi̱, ta saá kuchiño ún ko̱ꞌo̱n ún no̱o̱ ko̱ꞌo̱n i̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ta ta̱Pedro ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Tata, ¿nda̱chun o̱n ki̱ví ko̱ꞌo̱n i̱ xíꞌin ún vitin? Chi yi̱ꞌi̱, xa yóo tiꞌva i̱ nda̱ kivi̱ i̱ no̱o̱ ún ―káchí ta̱Pedro xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ta̱Pedro: ―¿Án ndixa kía̱ xa yóo tiꞌva ún kivi̱ ún no̱o̱ i̱? Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ún vitin, tá o̱n ta̱ꞌán ka̱ kana nduxú chée ñoó vitin, ta xa u̱ni̱ yichi̱ ni̱ka̱ꞌa̱n ún xíꞌin ni̱vi ña o̱n vása xíni̱ ún yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin ta̱Pedro. ");
INSERT INTO mim_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra, káchí ra saá: ―O̱n kundiꞌi ini ndó. Ndixa ndinoꞌo ini ndó kandixa ndó Ndios, ta ndixa ndinoꞌo ini ndó kandixa ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Veꞌe Yivá i̱ Ndios ñoyívi ni̱no káꞌno ní ña. Yóo kua̱ꞌa̱ ní xiiña no̱o̱ va̱ꞌa kutaku̱ ndiꞌi ndó. Tá o̱n si̱ví ñanda̱a̱ kúu ña káꞌa̱n i̱ xa̱ꞌa̱ veꞌe Yivá i̱, níkúu, ta nda̱ loꞌo o̱n ndato̱ꞌon i̱ saá xíꞌin ndó. Ta vitin ko̱ꞌo̱n i̱ ña kasa ndivi i̱ xiiña no̱o̱ va̱ꞌa kutaku̱ ndó. ");
INSERT INTO mim_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tá ndi̱ꞌi ki̱sa ndivi i̱ xiiña no̱o̱ va̱ꞌa kutaku̱ ndó veꞌe Yivá i̱, ta ndikó i̱ ñoyívi yóꞌo ña nakiꞌin i̱ ndóꞌó ta ko̱ꞌo̱n ndó xíꞌin i̱. Ta saá nda̱ mi̱i no̱o̱ táku̱ i̱, ndóꞌó kutaku̱ ndó xíꞌin i̱ ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ndóꞌó, xa xíni̱ ndó yichi̱ ña ndasaá kuchiño xaa̱ ndó no̱o̱ ko̱ꞌo̱n i̱ ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ta ñii ta̱xíka xíꞌin ta̱Jesús, na̱ní ra Tomás, ni̱nda̱ka̱ to̱ꞌon ra, káchí ra saá: ―Tata, o̱n vása xíni̱ ndi̱ míchí ko̱ꞌo̱n ún, ta saá, ¿ndasaá koo kuchiño koni̱ ndi̱ yichi̱? ");
INSERT INTO mim_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Yi̱ꞌi̱ kúu yichi̱ ña kuchiño xaa̱ ni̱vi no̱o̱ Ndios, ta yi̱ꞌi̱ kúu no̱o̱ káku ñanda̱a̱ ndinoꞌo, ta yi̱ꞌi̱ kúu ndee̱ ña táxi kutaku̱ ndinoꞌo ni̱vi. O̱n ko̱ó inka̱ yichi̱ ña kuchiño xaa̱ ni̱vi no̱o̱ Ndios: ñii la̱á yi̱ꞌi̱ kúu yichi̱ ña taxi xaa̱ ni̱vi no̱o̱ Ndios ta kutaku̱ na xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ta ndóꞌó, tá ndixa xíni̱ ndó yi̱ꞌi̱, ta saá ndixa koni̱ ndó Yivá i̱ Ndios. Ta̱nda̱ vitin ta̱nda̱ ndiꞌi ki̱vi̱ va̱xi, xa xíni̱ va̱ꞌa ndó ra, ta xíꞌin nduchu̱ no̱o̱ ndó xa xi̱ni ndó ra ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ta inka̱ ta̱xíka xíꞌin ta̱Jesús, na̱ní ra Felipe, ni̱ka̱ꞌa̱n ra, káchí ra saá: ―Tata, sanáꞌa ún ndi̱ꞌi̱ ndasaá kuchiño koni ndi̱ Yivá yó Ndios, ta ñayóꞌo kuiti kúu ndiꞌi ña xíni̱ ñóꞌó ndi̱. ");
INSERT INTO mim_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Xa kua̱ꞌa̱ ní ki̱vi̱ yóo i̱ xíꞌin ndó, ta, ¿án o̱n ta̱ꞌán koni̱ ún yi̱ꞌi̱, tata? Ndiꞌi ni̱vi na xíni yi̱ꞌi̱, nayóꞌo ñii káchí xíni na Yivá i̱. Ta saá, ¿nda̱chun káꞌa̱n ún xíꞌin i̱ xíni̱ ñóꞌó sanáꞌa i̱ ndóꞌó ndasaá kuchiño koni ndó Yivá i̱? ");
INSERT INTO mim_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Án o̱n ta̱ꞌán kandixa ún ndí yi̱ꞌi̱ táku̱ i̱ ini Yivá i̱ ta Yivá i̱ táku̱ ra ini mi̱i i̱? To̱ꞌon ña káꞌa̱n i̱ xíꞌin ndó, o̱n si̱ví ndasaá kuiti to̱ꞌon mi̱i i̱ kúu ña, chi to̱ꞌon Yivá i̱ Ndios kúu ña. Saá chi Yivá i̱ táku̱ ra ini mi̱i i̱, ta chiño mi̱i ra kúu ña kísa ndivi i̱. ");
INSERT INTO mim_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Va̱ꞌa kandixa ndó to̱ꞌon ña káꞌa̱n i̱ xíꞌin ndó ndí yi̱ꞌi̱ táku̱ i̱ ini Yivá i̱ ta Yivá i̱ táku̱ ra ini mi̱i i̱. Tá o̱n ki̱ví kandixa ndó yi̱ꞌi̱ xa̱ꞌa̱ to̱ꞌon yóꞌo, ta va̱ꞌa kandixa ndó yi̱ꞌi̱ xa̱ꞌa̱ milagro ñava̱ꞌa ke̱ꞌé i̱ no̱o̱ ndó ña sánáꞌa yu kúu i̱. ");
INSERT INTO mim_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó, ndiꞌi ni̱vi na kándixa yi̱ꞌi̱ kúchiño na keꞌé na ñii ki̱ꞌva nda̱tán yóo chiño kéꞌé i̱. Ta ndixa nayóꞌo keꞌé na chiño ña náꞌno ka̱ no̱o̱ chiño ke̱ꞌé i̱, chi yi̱ꞌi̱ ndikó i̱ no̱o̱ Yivá i̱. ");
INSERT INTO mim_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ta ndóꞌó na kándixa yi̱ꞌi̱, tá xíꞌin nda̱yí ki̱vi̱ i̱, ndukú ndó ñava̱ꞌa ña xíni̱ ñóꞌó ndó, ta yi̱ꞌi̱ kasa ndivi i̱ ndiꞌi ña ndukú ndó. Ta xa̱ꞌa̱ ña keꞌé i̱ saá, ni̱vi kasa káꞌno na Yivá yó ta chinóo síkón na ñato̱ꞌó ra. ");
INSERT INTO mim_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tuku káꞌa̱n i̱ xíꞌin ndóꞌó na kúu ni̱vi na kándixa yi̱ꞌi̱: Tá xíꞌin nda̱yí ki̱vi̱ i̱ ndukú ndó ñava̱ꞌa, ta yi̱ꞌi̱ kasa ndivi i̱ ndiꞌi ña ndukú ndó no̱o̱ i̱ ―káchí ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ta ta̱Jesús ni̱ka̱ꞌa̱n ka̱ ra xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Ta ndóꞌó, tá kíꞌvi ini ndó xíni ndó yi̱ꞌi̱, ta saá kasa ndivi ndó ña xáꞌnda chiño i̱ no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ta yi̱ꞌi̱, ndukú i̱ no̱o̱ Yivá yó Ndios ta ndixa tiꞌví ra Níma̱ ña na̱ní “Níma̱ ña chíkaa̱ ndee̱ ini ni̱vi”, ta kutaku̱ ña xíꞌin ndó ndiꞌi saá ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ta Níma̱ yóꞌo sanáꞌa ña ndóꞌó ndasaá kuiti ña ndixa nda̱a̱ ndinoꞌo. Ta ni̱vi na ndíko̱n yichi̱ o̱n váꞌa ñoyívi yóꞌo o̱n vása kúchiño na nakiꞌin na Níma̱ yóꞌo, saá chi o̱n vása kúchiño koto na ña, ni o̱n vása xíni̱ na ña. Ta ndóꞌó, ni̱vi na kándixa yi̱ꞌi̱, ndixa xíni̱ ndó Níma̱ yóꞌo, chi yóo ña xíꞌin ndó vitin, ta ki̱vi̱ ña va̱xi kunakaa̱ ña ini ñii ñii ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ta yi̱ꞌi̱, o̱n sandakoo matóꞌón i̱ ndóꞌó, ña kutaku̱ ndó nda̱tán táku̱ naválí xi̱ndáꞌví na o̱n ko̱ó yivá siꞌí. Ta yi̱ꞌi̱ ya̱chi̱ ní ndikó i̱ ta kixaa̱ i̱ no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ti̱xin ña saloꞌo ki̱vi̱, ni̱vi na ndíko̱n yichi̱ o̱n váꞌa ñoyívi yóꞌo, o̱n kuchiño ka̱ na koto na yi̱ꞌi̱. Ta ndóꞌó, o̱n kundoꞌo ndó saá, chi ndixa koto ka̱ ndó yi̱ꞌi̱. Ta xa̱ꞌa̱ ña ndixa ndinoꞌo táku̱ i̱, ndóꞌó ndixa ndinoꞌo kutaku̱ ndó. ");
INSERT INTO mim_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ki̱vi̱ kundivi ñayóꞌo saá, ta ndóꞌó ndixa kunda̱a̱ ini ndó ndí yi̱ꞌi̱ táku̱ i̱ ini Yivá i̱, ta ndóꞌó táku̱ ndó ini yi̱ꞌi̱, ta yi̱ꞌi̱ táku̱ i̱ ini ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ndiꞌi ni̱vi na nákiꞌin va̱ꞌa ña xáꞌnda chiño i̱ no̱o̱ na, ta kísa ndivi na ña, nayóꞌo sánáꞌa na ndí ndixa kúu na ni̱vi na kíꞌvi ini xíni yi̱ꞌi̱. Ta ndiꞌi ni̱vi na kíꞌvi ini xíni yi̱ꞌi̱, ta Yivá i̱ Ndios ndixa kukiꞌvi ini ra koni ra nayóꞌo. Ta saá tuku yi̱ꞌi̱ ndixa kukiꞌvi ini i̱ koni i̱ nayóꞌo ta taxi xíꞌin mi̱i i̱ no̱o̱ na, ña koni̱ va̱ꞌa na yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ta saá inka̱ ta̱xíka xíꞌin ta̱Jesús, na̱ní ra Judas (ta o̱n si̱ví ta̱Judas Iscariote kúu ta̱yóꞌo), ni̱ka̱ꞌa̱n ra xíꞌin ta̱Jesús, káchí ra saá: ―Tata, ¿nda̱chun taxi ún ndasaá kuiti mi̱i ndi̱ kuu ni̱vi na kuchiño koni̱ va̱ꞌa yóꞌó? ¿Nda̱chun o̱n vása keꞌé ún saá xíꞌin ndiꞌi ni̱vi ñoyívi yóꞌo ña kuchiño koni̱ na yóꞌó? ");
INSERT INTO mim_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ta nda̱kuii̱n ta̱Jesús, ni̱ka̱ꞌa̱n ra xíꞌin ra: ―Ndiꞌi ni̱vi na kíꞌvi ini xíni yi̱ꞌi̱, ni̱vi yóꞌo kasa ndivi na to̱ꞌon i̱. Ta Yivá i̱ Ndios kukiꞌvi ini ra koni ra nayóꞌo, ta Yivá i̱ xíꞌin yi̱ꞌi̱ ndixa kixaa̱ ndi̱ no̱o̱ nayóꞌo, ta kutaku̱ ndi̱ xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ta ni̱vi na o̱n vása kíꞌvi ini xíni na yi̱ꞌi̱, nayóꞌo o̱n vása kísa ndivi na to̱ꞌon i̱. Ta o̱n si̱ví ndasaá kuiti to̱ꞌon yi̱ꞌi̱ kúu ña káꞌa̱n i̱, ta ndixa kúu ña to̱ꞌon Yivá yó Ndios, ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ndiꞌi ñayóꞌo ndáto̱ꞌon i̱ xíꞌin ndó ki̱vi̱ yóo ka̱ i̱ xíꞌin ndó vitin. ");
INSERT INTO mim_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ta kixaa̱ ki̱vi̱ Yivá yó Ndios tiꞌví ra Níma̱ ña chíkaa̱ ndee̱ ini ni̱vi, ta xíꞌin nda̱yí ki̱vi̱ i̱ tiꞌví ra Níma̱ yóꞌo, ta kixaa̱ ña kutaku̱ ña ini ndó, ta sanáꞌa ña ndóꞌó ndiꞌi ña xíni̱ ñóꞌó kunda̱a̱ ini ndó, ta sanakáꞌán ña ndóꞌó ndiꞌi to̱ꞌon ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Ta vitin táxi i̱ ña kunakaa̱ ñava̱ꞌa ini ndó. Ta ñava̱ꞌa yóꞌo kúu ña káku ini i̱, ta sáníꞌi i̱ ña ndóꞌó. Ta ñava̱ꞌa yóꞌo ña táxi i̱ ña kunakaa̱ ña ini ndó, o̱n si̱ví ñii kúu ña xíꞌin ña táxi ni̱vi na ndíko̱n yichi̱ ñoyívi yóꞌo ndaꞌa̱ ndó ña koo va̱ꞌa ini ndó. Ta saá ndóꞌó ni̱vi na kándixa yi̱ꞌi̱, vitin xáꞌnda chiño i̱ no̱o̱ ndó: O̱n kundiꞌi ini ndó, ta ni o̱n kuyi̱ꞌví ini ndó. ");
INSERT INTO mim_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xa xi̱ni̱ so̱ꞌo ndó ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó ndí kee i̱ ko̱ꞌo̱n i̱ vitin, ta kixaa̱ ñii ki̱vi̱ ndikó i̱ no̱o̱ ndó. Tá ndixa ndinoꞌo kíꞌvi ini ndó xíni ndó yi̱ꞌi̱, ta saá kusii̱ ní ini ndó ña kunda̱a̱ ini ndó kua̱ꞌa̱n i̱ no̱o̱ yóo Yivá yó, chi Yivá yó kúu ta̱a ta̱ káꞌno ka̱ no̱o̱ yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ta xa nda̱to̱ꞌon i̱ xíꞌin ndó ndiꞌi ñayóꞌo vitin tá o̱n ta̱ꞌán ka̱ kundivi ña. Ta saá tá kixaa̱ ki̱vi̱ kundivi ndiꞌi ña nda̱to̱ꞌon i̱ xíꞌin ndó, ta koni ndó ña, ta saá kandixa ka̱ ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’O̱n vása kua̱ꞌa̱ ní ka̱ ndato̱ꞌon i̱ xíꞌin ndó vitin, chi xa va̱xi ñaníma̱ ndiva̱ꞌa káꞌno ña kúu ña xáꞌnda chiño no̱o̱ ni̱vi na ndíko̱n yichi̱ ñoyívi yóꞌo. Ta saá ni, ñaníma̱ ndiva̱ꞌa káꞌno yóꞌo nda̱ loꞌo o̱n vása xáꞌnda chiño ña no̱o̱ yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ta yi̱ꞌi̱, ndasaá kuiti kísa ndivi i̱ ña xáꞌnda chiño Yivá i̱ Ndios no̱o̱ i̱. Ta xa̱ꞌa̱ ña kísa ndivi i̱ saá, kunda̱a̱ ini ni̱vi ndí ndixa kíꞌvi ní ini i̱ xíni i̱ Yivá i̱ Ndios. Ta vitin, nakuita ndó, naꞌa ndó ko̱ꞌo̱n ndó xíꞌin i̱ ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ta saá ta̱Jesús nda̱to̱ꞌon ra inka̱ cuento ña sanáꞌa ra naxíka xíꞌin ra, káchí ra saá: ―Ta yi̱ꞌi̱, nda̱tán yóo mi̱i tón uva ndinoꞌo, saá yóo i̱. Ta Yivá i̱ Ndios nda̱tán yóo ta̱a ta̱ ndáa tón uva xíꞌin ndiꞌi ndaꞌa̱ nó, saá yóo ra. ");
INSERT INTO mim_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta xáꞌnda ra ndiꞌi ndaꞌa̱ tón uva no̱o̱ o̱n vása kóon tíuva. Ta ndaꞌa̱ tón uva no̱o̱ va̱ꞌa kóon rí, nákaꞌnda tuku loꞌo ra no̱o̱ ña, ña taxi ña va̱ꞌa ka̱ koon tíuva. ");
INSERT INTO mim_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ta to̱ꞌon ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó, nda̱tán yóo ña si̱i̱n xáꞌnda, ta kindaa ña ndiꞌi ña o̱n vása va̱ꞌa yóo ini ndó, saá yóo to̱ꞌon yóꞌo. Ta vitin ni̱vi na ndu̱ndii kúu ndó xa̱ꞌa̱ ña chi̱kaa̱ so̱ꞌo ndó to̱ꞌon ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ta saá xíni̱ ñóꞌó koo ndó xíꞌin i̱ ndiꞌi saá ki̱vi̱, ta yi̱ꞌi̱ koo i̱ xíꞌin ndóꞌó. Saá chi táná ta̱ꞌnda̱, ta na̱ndoso xíká yoꞌo̱ ndaꞌa̱ tón uva, ta ña na̱ndoso xíká yóꞌo, o̱n vása kúchiño mi̱i ña taxi ña nda̱ ñii kui̱ꞌi. Ñayóꞌo sánáꞌa ña ndóꞌó tá o̱n vása ñii yóo ndó xíꞌin i̱, ta saá o̱n kuchiño ndó keꞌé ndó nda̱ ñii ñava̱ꞌa. ");
INSERT INTO mim_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Yi̱ꞌi̱, nda̱tán yóo mi̱i tón uva ndinoꞌo saá yóo i̱, ta ndóꞌó, nda̱tán yóo yoꞌo̱ ndaꞌa̱ tón uva yóꞌo, saá yóo ndóꞌó xíꞌin i̱. Tá ñii yóo ndóꞌó xíꞌin i̱, ta yi̱ꞌi̱, ñii yóo i̱ xíꞌin ndó, ta saá ndixa kéꞌé ndó kua̱ꞌa̱ ní chiño va̱ꞌa. Ta chiño yóꞌo nda̱tán tíkui̱ꞌi va̱ꞌa ní ña kóon ndaꞌa̱ tón uva saá yóo ña. Ta saá ni, tá yóo yoꞌo̱ ndaꞌa̱ tón uva ña ni̱ta̱ꞌnda̱ na̱ndoso xíká, ñayóꞌo o̱n kuchiño ña taxi ña koon nda̱ ñii kui̱ꞌi ndaꞌa̱ ña. Ta ñii ki̱ꞌva saá, tá o̱n vása ka̱ ñii yóo ndó xíꞌin i̱, ta nda̱ ñii chiño va̱ꞌa o̱n kuchiño ndó keꞌé ndó. ");
INSERT INTO mim_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ta ni̱vi na kúxíká no̱o̱ yi̱ꞌi̱, ta o̱n vása ñii yóo ka̱ na xíꞌin i̱, nayóꞌo nda̱tán yóo ndaꞌa̱ tón uva ña ni̱ta̱ꞌnda̱ na̱ndoso xíká ta ni̱yi̱chi̱ ña, saá yóo na no̱o̱ i̱. Ta ndaꞌa̱ ni̱yi̱chi̱ yóꞌo, ni̱vi nakaya na ña, ta taan na ña no̱o̱ yóo ñoꞌo̱ xíxi̱, ta ko̱ko̱ ña. ");
INSERT INTO mim_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Ta ndóꞌó, tá ñii yóo ndó xíꞌin i̱, ta to̱ꞌon i̱ táku̱ ña ini ndó, ta saá va̱ꞌa ndukú ndó no̱o̱ Yivá i̱ Ndios nda̱ ndá ka̱ ña kóni ndó, ta ndixa taxi ra ña ndúkú ndó ndaꞌa̱ ndó. ");
INSERT INTO mim_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ta vitin ñayóꞌo keꞌé ndó xa̱ꞌa̱ ña chinóo síkón ndó ñato̱ꞌó Ndios no̱o̱ inka̱ ni̱vi: Xíni̱ ñóꞌó nduu ndó ni̱vi na va̱ꞌa ini, na kísa ndivi ña kóni Ndios, ta saá sanáꞌa ndó ndixa kúu ndó ni̱vi na ndíko̱n yi̱ꞌi̱ ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ta ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na, káchí ra saá: ―Ñii ki̱ꞌva nda̱tán kíꞌvi ini Yivá i̱ Ndios xíni ra yi̱ꞌi̱, saá kíꞌvi ini i̱ xíni i̱ ndóꞌó. Ta saá ñii ñii ki̱vi̱ ná kutaku̱ ka̱ ndó ti̱xin ña kíꞌvi ní ini i̱ xíni i̱ ndóꞌó, ta o̱n sandakoo ndó yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tá kasa ndivi ndó ña xáꞌnda chiño i̱ no̱o̱ ndó, ta saá ñii ñii ki̱vi̱ kutaku̱ ndó ti̱xin ña kíꞌvi ní ini i̱ xíni i̱ ndóꞌó. Saá chi yi̱ꞌi̱, ñii ki̱ꞌva saá kísa ndivi i̱ ña kóni Yivá i̱ Ndios, ta ndiꞌi saá ki̱vi̱ táku̱ i̱ ti̱xin ña kíꞌvi ní ini ra xíni ra yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Nda̱to̱ꞌon i̱ ñayóꞌo xíꞌin ndó chi kóni i̱ ña ndixa ná kusii̱ ní ini ndóꞌó. Chi mi̱i ñasi̱i̱ ña káku ini mi̱i i̱, kóni i̱ ndí ná kunakaa̱ ñasi̱i̱ yóꞌo ini ndóꞌó, ta saá kuu ndó ni̱vi na kusii̱ ndinoꞌo ini. ");
INSERT INTO mim_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ña xáꞌnda chiño i̱ no̱o̱ ndó kúu ñayóꞌo: Ndixa kukiꞌvi ini ndó koni táꞌan ndó, nda̱tán kíꞌvi ini i̱ xíni i̱ ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Saá chi ta̱a ta̱ ndixa káꞌno ní ka̱ kíꞌvi ini xíni natáꞌan kúu ta̱a ta̱ táxi xíꞌin mi̱i nda̱ kivi̱ ra xa̱ꞌa̱ nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ta ndóꞌó, táná kasa ndivi ndó ña káꞌa̱n i̱ xíꞌin ndó, ta kuu ndó ni̱vi na nátaꞌan va̱ꞌa xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","O̱n ka̱ꞌa̱n ka̱ i̱ xíꞌin ndó kúu ndó ndasaá kuiti na kísa chiño no̱o̱ i̱, chi ni̱vi na kísa chiño no̱o̱ ñii ta̱káꞌno o̱n vása xíni̱ na yu kúu ña xáni si̱ni̱ ta̱káꞌno yóꞌo keꞌé ra. Ta yi̱ꞌi̱ sa̱kunaní i̱ ndóꞌó namigo i̱ na nátaꞌan va̱ꞌa xíꞌin i̱, saá chi xa nda̱to̱ꞌon i̱ xíꞌin ndó ndiꞌi ña sa̱náꞌa Yivá i̱ Ndios yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","O̱n si̱ví mi̱i ndó kúu ni̱vi na na̱ka̱xin kundiko̱n ndó yi̱ꞌi̱, ta yi̱ꞌi̱ kúu ta̱a ta̱ na̱ka̱xin i̱ ndóꞌó ña kundiko̱n ndó yi̱ꞌi̱, ta sa̱kuiso chiño i̱ ndóꞌó ña kasa ndivi ndó kua̱ꞌa̱ ní chiño va̱ꞌa. Ta chiño va̱ꞌa yóꞌo koo ña nda̱tán yóo kui̱ꞌi va̱ꞌa ña koo naꞌá ní ki̱vi̱. Ta saá Yivá i̱ Ndios taxi ra ndaꞌa̱ ndó ndiꞌi ña ndúkú ndó no̱o̱ ra xíꞌin nda̱yí ki̱vi̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ñayóꞌo kúu ña xáꞌnda chiño i̱ no̱o̱ ndó: Kukiꞌvi ini ndó koni táꞌan ndó ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ta ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Tá ni̱vi na ndíko̱n yichi̱ o̱n váꞌa ñoyívi yóꞌo sáa̱ ini na xíni na ndóꞌó, ta saá nakáꞌán ndó ndí siꞌna ka̱ ñii ki̱ꞌva saá ke̱ꞌé na xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Táná koo yuꞌú ndó xíꞌin ni̱vi ñoyívi yóꞌo, ta saá nani̱vi ñoyívi yóꞌo kukiꞌvi ini na koni na ndóꞌó. Ta ndóꞌó, o̱n si̱ví na ndíko̱n yichi̱ o̱n váꞌa ñoyívi yóꞌo kúu ndó, chi yi̱ꞌi̱ na̱ka̱xin i̱ ndóꞌó ña sandakoo ndó yichi̱ o̱n váꞌa yóꞌo xa̱ꞌa̱ ña kundiko̱n ndó yichi̱ i̱. Ña̱kán kía̱ ni̱vi na ndíko̱n yichi̱ o̱n váꞌa ñoyívi yóꞌo sáa̱ ní ini na xíni na ndóꞌó. ");
INSERT INTO mim_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nakáꞌán ndó to̱ꞌon ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó saá: “Nda̱ ñii ta̱mozo o̱n vása kúu ra ta̱ káꞌno ka̱ no̱o̱ ta̱ xáꞌnda chiño no̱o̱ ra”, káchí i̱ xíꞌin ndó. Ta to̱ꞌon yóꞌo kóni kachí ña ñii ki̱ꞌva kéꞌé na xíꞌin yi̱ꞌi̱, Ta̱a ta̱Káꞌno no̱o̱ ndó, saá keꞌé na xíꞌin ndóꞌó na kísa chiño no̱o̱ i̱. Ni̱vi ñoyívi yóꞌo sa̱xo̱ꞌvi̱ na yi̱ꞌi̱, ta saá ndixa saxo̱ꞌvi̱ na ndóꞌó. Ta saá ni, ni̱xi̱yo ni̱vi na chi̱kaa̱ so̱ꞌo to̱ꞌon i̱, ta ñii ki̱ꞌva saá koo ni̱vi na chikaa̱ so̱ꞌo to̱ꞌon ña ka̱ꞌa̱n ndó xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Saá keꞌé ni̱vi xíꞌin ndó chi ndóꞌó kúu na ndíko̱n yichi̱ i̱. Chi ni̱vi na kua̱ꞌa̱n yichi̱ o̱n váꞌa ñoyívi yóꞌo o̱n vása xíni̱ na Ndios, ta̱ kúu ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tá o̱n vása ní‑kixi i̱ no̱o̱ na, tá ni o̱n vása ní‑ndato̱ꞌon i̱ xíꞌin na, níkúu, ta saá o̱n vása ndíso na kua̱chi no̱o̱ ña nda̱to̱ꞌon i̱ xíꞌin na. Ta vitin o̱n ki̱ví kachí na o̱n vása ndíso na kua̱chi, chi ni̱ka̱ꞌa̱n i̱ xíꞌin na yu kúu ñanda̱a̱, ta ni̱‑xiin na kasa ndivi na ña nda̱to̱ꞌon i̱ xíꞌin na. ");
INSERT INTO mim_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ndiꞌi ni̱vi na sáa̱ ini xíni yi̱ꞌi̱ kúu na sáa̱ ini xíni Yivá i̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Xa ki̱sa ndivi i̱ kua̱ꞌa̱ ní milagro náꞌno, ta nda̱ ñii ni̱vi, ta ni siꞌna ta ni vitin, o̱n vása ní‑keꞌé na ñava̱ꞌa nda̱tán yóo ñamilagro ki̱sa ndivi i̱ ñoyívi yóꞌo. Tá o̱n vása ní‑keꞌé i̱ saá, níkúu, ta ni̱vi o̱n vása ndíso na kua̱chi xa̱ꞌa̱ ña ni̱‑xiin na kandixa na yi̱ꞌi̱. Ta ndixa xi̱ni na milagro ke̱ꞌé i̱, ta saá ni, sáa̱ ní ini na xíni na yi̱ꞌi̱, ta ñii ki̱ꞌva saá, sáa̱ ini na xíni na Yivá i̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Saá kéꞌé ni̱vi yóꞌo chi to̱ꞌon Ndios xíni̱ ñóꞌó kundivi ña. Ta ñii xiiña no̱o̱ to̱ꞌon Ndios yóꞌo va̱xi nda̱yí ña ni̱taa ta̱Moisés kui̱ya̱ xi̱na̱ꞌá, ta káchí ña saá: “Sáa̱ ini ni̱vi xíni na yi̱ꞌi̱, vará nda̱ loꞌo o̱n ko̱ó xa̱ꞌa̱ ña kéꞌé na saá”, káchí to̱ꞌon Ndios ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ta ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Va̱xi ki̱vi̱ kixaa̱ Níma̱ Ndios no̱o̱ ndó, ta Níma̱ yóꞌo kúu ña chíkaa̱ ndee̱ ini ni̱vi, ta ndáto̱ꞌon ña ndasaá kuiti ñanda̱a̱ ndinoꞌo xíꞌin ni̱vi. Níma̱ yóꞌo kee ña no̱o̱ Ndios ta kixaa̱ ña no̱o̱ ndó, chi yi̱ꞌi̱ tiꞌví i̱ ña xíꞌin nda̱yí Yivá i̱, ta Níma̱ Ndios yóꞌo ka̱ꞌa̱n ña xíꞌin ndó ndiꞌi ñanda̱a̱ xa̱ꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ta saá ndóꞌó kuu ndó ni̱vi na ka̱ꞌa̱n xa̱ꞌa̱ i̱ ndiꞌi ñanda̱a̱ xíꞌin inka̱ ni̱vi, saá chi nda̱ ki̱vi̱ ki̱xáꞌá i̱ kísa ndivi i̱ chiño Yivá i̱ ñoyívi yóꞌo, ndóꞌó kúu ni̱vi na ki̱xáꞌá kísa chiño xíꞌin i̱ ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ta ta̱Jesús ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na, káchí ra saá: ―Ndiꞌi to̱ꞌon yóꞌo xa ni̱ka̱ꞌa̱n i̱ ña xíꞌin ndó xa̱ꞌa̱ ña o̱n sandakoo ndó yichi̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chi va̱xi ki̱vi̱ tá nanáꞌno no̱o̱ najudío o̱n taxi ka̱ na ki̱ꞌvi ndó ini veꞌe ño̱ꞌo sinagoga. Ta va̱xi ki̱vi̱ ni̱vi kani si̱ni̱ na ndí ñava̱ꞌa ní kúu ña keꞌé na ña kaꞌni na ndóꞌó, chi xíꞌin ña kéꞌé na saá kúu ñava̱ꞌa kasa ndivi na ña kóni Ndios, saá kani si̱ni̱ mi̱i na. ");
INSERT INTO mim_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Saxo̱ꞌvi̱ na ndóꞌó saá, chi nda̱ ñii ki̱vi̱ o̱n ta̱ꞌán koni̱ ndixa na Yivá yó Ndios, ta ni o̱n ta̱ꞌán koni̱ ndixa na yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ta vitin xa nda̱to̱ꞌon i̱ xíꞌin ndó ñayóꞌo, ta saá tá kixaa̱ ki̱vi̱ ña kundoꞌo ndó ñayóꞌo, ta saá nakáꞌán ndó to̱ꞌon yóꞌo ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó ―káchí ta̱Jesús. Ta ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Ta ki̱vi̱ ki̱xáꞌá ndó kísa ndivi ndó chiño xíꞌin i̱, o̱n vása ní‑kaꞌa̱n i̱ xíꞌin ndó ndasaá kundoꞌo ndó xa̱ꞌa̱ i̱, chi yóo ka̱ i̱ xíꞌin ndó. ");
INSERT INTO mim_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ta vitin ndikó i̱ noꞌo̱ i̱ no̱o̱ ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱, ta nda̱ ñii ndóꞌó o̱n vása ndáka̱ to̱ꞌon ndó yi̱ꞌi̱ míchí ko̱ꞌo̱n i̱. ");
INSERT INTO mim_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ta saá ni, vitin kúchuchú ní ini ndó xa̱ꞌa̱ ña xi̱ni̱ so̱ꞌo ndó ña káꞌa̱n i̱ ko̱ꞌo̱n i̱. ");
INSERT INTO mim_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ta ña ndixa nda̱a̱ káꞌa̱n i̱ xíꞌin ndó ndí ñii ñava̱ꞌa xa̱ꞌa̱ ndó kúu ña ko̱ꞌo̱n i̱. Saá chi tá o̱n vása ko̱ꞌo̱n i̱, ta o̱n kívi kixaa̱ Níma̱ ña na̱ní Níma̱ ña chíkaa̱ ndee̱ ini ni̱vi. Ta yi̱ꞌi̱, táná ko̱ꞌo̱n i̱, ta tiꞌví i̱ Níma̱ yóꞌo kixaa̱ ña no̱o̱ ndó. ");
INSERT INTO mim_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tá ki̱vi̱ kixaa̱ Níma̱ Ndios yóꞌo, ta sanáꞌa ña ni̱vi ñoyívi yóꞌo ña kunda̱a̱ va̱ꞌa ini na yu kúu na ndíso kua̱chi no̱o̱ Ndios, ta kunda̱a̱ va̱ꞌa ini na yu kúu nava̱ꞌa nanda̱a̱, ta kunda̱a̱ va̱ꞌa ini na ndixa Ndios kasa nani ra xa̱ꞌa̱ ndiꞌi ni̱vi na ndíso kua̱chi. ");
INSERT INTO mim_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Saá chi Níma̱ Ndios yóꞌo chindeé ña ni̱vi ña kunda̱a̱ ini na ndí ndíso na kua̱chi xa̱ꞌa̱ ña ni̱‑xiin na kandixa na yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ta Níma̱ Ndios chindeé ña ni̱vi ña kunda̱a̱ ini na ndí yi̱ꞌi̱ kúu ta̱a ta̱ va̱ꞌa, ta̱ nda̱a̱, saá chi yi̱ꞌi̱ ndikó i̱ noꞌo̱ i̱ no̱o̱ Yivá i̱ Ndios, ta ndóꞌó o̱n kívi koni ka̱ ndó yi̱ꞌi̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ta Níma̱ Ndios chindeé ña ni̱vi ña kunda̱a̱ ini na ndixa Ndios kasa nani ra xa̱ꞌa̱ kua̱chi na, chi xa ki̱sa nani ra kua̱chi ñaníma̱ ndiva̱ꞌa káꞌno, ña kúu ña xáꞌnda chiño no̱o̱ ni̱vi ñoyívi yóꞌo, ta ndixa xo̱ꞌvi̱ ní ñandiva̱ꞌa yóꞌo xa̱ꞌa̱ kua̱chi ndíso ña ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ta ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na, káchí ra saá: ―Yóo kua̱ꞌa̱ ní ka̱ to̱ꞌon ña kóni i̱ ka̱ꞌa̱n i̱ xíꞌin ndó, ta o̱n ka̱ꞌa̱n i̱ ña xíꞌin ndó vitin, chi vitin o̱n kúchiño kundeé ndó koni̱ so̱ꞌo ndó ndiꞌi to̱ꞌon yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tá kixaa̱ Níma̱ Ndios, nina ñanda̱a̱ ndato̱ꞌon ña xíꞌin ndó, ta sanáꞌa káxín ña ndóꞌó ndasaá va̱ꞌa kundiko̱n ndó yichi̱ ña nda̱a̱. Saá chi Níma̱ Ndios yóꞌo o̱n vása ka̱ꞌa̱n ña ndasaá kuiti to̱ꞌon mi̱i ña, ta ka̱ꞌa̱n ña nda̱tán yóo mi̱i to̱ꞌon ña xi̱ni̱ so̱ꞌo ña ni̱ka̱ꞌa̱n Ndios, saá ka̱ꞌa̱n ña xíꞌin ndó. Ta Níma̱ Ndios yóꞌo ndato̱ꞌon ña xíꞌin ndó yukía̱ koo ki̱vi̱ ña va̱xi. ");
INSERT INTO mim_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ta chinóo síkón ña ñato̱ꞌó i̱ no̱o̱ ni̱vi, chi ndiꞌi ñandíchí ña kómí i̱, Níma̱ Ndios nakiꞌin ña ñayóꞌo, ta taxi ña ñandíchí yóꞌo ndaꞌa̱ ndó ña kunda̱a̱ ini ndó ndiꞌi ñanda̱a̱. ");
INSERT INTO mim_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ndiꞌi ñava̱ꞌa kómí Yivá i̱ kúu ñava̱ꞌa kómí i̱. Ña̱kán kía̱ ni̱ka̱ꞌa̱n i̱ xíꞌin ndó ndí Níma̱ Ndios nakiꞌin ña ñandíchí i̱, ta taxi ñandíchí yóꞌo ndaꞌa̱ ndó ña kunda̱a̱ ini ndó ndiꞌi ñanda̱a̱ ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ta ni̱ka̱ꞌa̱n ka̱ ta̱Jesús xíꞌin naxíka xíꞌin ra, káchí ra saá: ―Saloꞌo ka̱ kuiti kúma̱ni̱ ta o̱n koni ka̱ ndó yi̱ꞌi̱, ta saá yaꞌa loꞌo kuiti ki̱vi̱ ta tuku koni ka̱ ndó yi̱ꞌi̱. Saá chi saloꞌo ka̱ ki̱vi̱ kúma̱ni̱, ta ndikó i̱ noꞌo̱ i̱ no̱o̱ yóo Yivá i̱ Ndios ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ta sava naxíka xíꞌin ra ni̱ka̱ꞌa̱n na xíꞌin táꞌan na, káchí na saá: ―¿Yukía̱ kóni kachí to̱ꞌon ña ni̱ka̱ꞌa̱n ra xíꞌin yó? Chi ni̱ka̱ꞌa̱n ra saloꞌo ka̱ kuiti kúma̱ni̱ ta o̱n koni ka̱ yó ra. Ta saá yaꞌa loꞌo kuiti ki̱vi̱ ta saá tuku koni yó ra, saá chi ko̱ꞌo̱n ra no̱o̱ yóo Yivá ra, káchí ra. ¿Yukía̱ kóni kachí to̱ꞌon yóꞌo ña ni̱ka̱ꞌa̱n ra xíꞌin yó? ");
INSERT INTO mim_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ta tuku ndáka̱ to̱ꞌon táꞌan na, káchí na saá: ―¿Yukía̱ kóni kachí to̱ꞌon “saloꞌo kuiti kúma̱ni̱”? O̱n vása kúnda̱a̱ ini yó yukía̱ kóni kachí ra xíꞌin to̱ꞌon yóꞌo ―káchí na, káꞌa̱n na. ");
INSERT INTO mim_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ta ta̱Jesús xíni̱ ra ndí kóni na nda̱ka̱ to̱ꞌon na ra xa̱ꞌa̱ to̱ꞌon ña ni̱ka̱ꞌa̱n ra xíꞌin na, ta saá tuku ni̱ka̱ꞌa̱n ra, káchí ra xíꞌin na: ―¿Án kóni ndó kunda̱a̱ ini ndó yukía̱ káchí to̱ꞌon ña ni̱ka̱ꞌa̱n i̱ xíꞌin ndó ña káchí saá: “Saloꞌo ka̱ kuiti kúma̱ni̱ ta o̱n koni ka̱ ndó yi̱ꞌi̱, ta saá yaꞌa loꞌo kuiti ki̱vi̱ ta tuku koni ndó yi̱ꞌi̱”? ");
INSERT INTO mim_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ña ndixa nda̱a̱ kúu to̱ꞌon yóꞌo ndí ndóꞌó kuaku ndó ta ndáꞌví ní ka̱ꞌa̱n ndó, ta mi̱i ki̱vi̱ yóꞌo nani̱vi ñoyívi yóꞌo va̱ꞌa ní koni na, ta kusii̱ ní ini na. Ta ndóꞌó, vará loꞌo kuiti ki̱vi̱ kuchuchú ní ini ndó, ta saá kixaa̱ ñasi̱i̱ ní, ta kunakaa̱ ña ini ndó. ");
INSERT INTO mim_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nda̱tán yo̱ꞌvi̱ ndóꞌo ñii ñaꞌa̱ ñá xa kóni kaku sa̱ꞌya, saá kundoꞌo ndó. Ndeé ní xóꞌvi̱ ñaꞌa̱ yóꞌo táꞌan mi̱i xa yatin kaku sa̱ꞌya ñá. Ta saá, tá ndi̱ꞌi ni̱yaꞌa ka̱ku sa̱ꞌya ñá, ta kúsii̱ ní ini ñá. Ta saá nándoso ñá xa̱ꞌa̱ ndiꞌi ña yo̱ꞌvi̱ ní ni̱xo̱ꞌvi̱ ñá, chi kúsii̱ ní ini ñá xa̱ꞌa̱ ña ka̱ku inka̱ ta̱a ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nda̱tán yóo ña ni̱ndoꞌo ñaꞌa̱ yóꞌo, saá koo ña kundoꞌo ndó ki̱vi̱ va̱xi, chi kuaku ní ndó ta kuchuchú ní ini ndó xa̱ꞌa̱ ña ko̱ꞌo̱n i̱. Ta saá kixaa̱ ki̱vi̱ ña ndikó tuku i̱ xíꞌin ndó, ta kusii̱ ní ini ndó, ta nda̱ ñii ni̱vi o̱n kuchiño na kindaa na ñasi̱i̱ kunakaa̱ ini ndó. ");
INSERT INTO mim_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Ta ki̱vi̱ yóꞌo o̱n vása ndáka̱ to̱ꞌon ka̱ ndó yi̱ꞌi̱. Ta ña ndixa nda̱a̱ kúu to̱ꞌon ña káꞌa̱n i̱ xíꞌin ndó vitin: Ndiꞌi ña ndukú ndó no̱o̱ Yivá i̱ Ndios xíꞌin nda̱yí ki̱vi̱ i̱, Yivá i̱ ndixa taxi ra ndaꞌa̱ ndó ndiꞌi ña ndúkú ndó no̱o̱ ra. ");
INSERT INTO mim_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ta̱nda̱ vitin o̱n ta̱ꞌán ndukú ndó nda̱ ñii ñava̱ꞌa no̱o̱ Ndios xíꞌin nda̱yí ki̱vi̱ i̱. Ta vitin va̱ꞌa ndukú ndó ña kóni ndó no̱o̱ Ndios, ta nakiꞌin ndó ña, ta saá kunakaa̱ ndinoꞌo ñasi̱i̱ ini ndó. ");
INSERT INTO mim_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Nda̱ ki̱vi̱ xíni̱ táꞌan yó ta̱nda̱ vitin nda̱to̱ꞌon i̱ xíꞌin ndó ta sa̱náꞌa i̱ ndóꞌó xíꞌin to̱ꞌon ña yo̱ꞌvi̱ kunda̱a̱ ini ndó. Ta vitin ki̱xaa̱ ki̱vi̱ ña o̱n ka̱ꞌa̱n ka̱ i̱ xíꞌin ndó xíꞌin to̱ꞌon yo̱ꞌvi̱, ta ndixa ndato̱ꞌon káxín i̱ xíꞌin ndó xa̱ꞌa̱ Yivá i̱. ");
INSERT INTO mim_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ta ki̱vi̱ kunda̱a̱ ini ndó to̱ꞌon yóꞌo, ta saá mi̱i ndó, xíꞌin nda̱yí ki̱vi̱ i̱, ndukú ndó ña xíni̱ ñóꞌó ndó no̱o̱ Ndios. O̱n vása koni̱ ñóꞌó kuaku ndáꞌví i̱ no̱o̱ Ndios xa̱ꞌa̱ ndó, ");
INSERT INTO mim_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","chi ndixa mi̱i Ndios kíꞌvi ní ini ra xíni ra ndóꞌó. Saá chi ndóꞌó kíꞌvi ní ini ndó xíni ndó yi̱ꞌi̱, ta kándixa ndó yi̱ꞌi̱ ki̱xi i̱ no̱o̱ Ndios. ");
INSERT INTO mim_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ke̱e i̱ no̱o̱ Yivá i̱ Ndios ta ki̱xaa̱ i̱ ñoyívi yóꞌo. Ta vitin kee i̱ ñoyívi yóꞌo ta ndikó i̱ noꞌo̱ i̱ no̱o̱ Yivá i̱ Ndios ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ta nda̱kuii̱n naxíka xíꞌin ra, ni̱ka̱ꞌa̱n na, káchí na saá: ―Vitin to̱ꞌon ña káxín ní kúu ña káꞌa̱n ún xíꞌin ndi̱. Vitin o̱n vása káꞌa̱n ún to̱ꞌon ña yo̱ꞌvi̱ ní kunda̱a̱ ini ndi̱. ");
INSERT INTO mim_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ta vitin kúnda̱a̱ ini ndi̱ ndí ña ndixa o̱n ko̱ó nda̱ ñii ña o̱n vása xíni̱ ún. Tá o̱n ta̱ꞌán ka̱ nda̱ka̱ to̱ꞌon ni̱vi yóꞌó, xa xíni̱ ndiꞌi ún ña xáni si̱ni̱ na. Ta xa̱ꞌa̱ ñayóꞌo kándixa ndi̱ yóꞌó kúu ún ta̱a ta̱ ki̱xi no̱o̱ Ndios ―káchí na xíꞌin ta̱Jesús. ");
INSERT INTO mim_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ta saá ta̱Jesús ni̱ka̱ꞌa̱n ka̱ ra xíꞌin na: ―¿Án ndixa kándixa ndó yi̱ꞌi̱ vitin? ");
INSERT INTO mim_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ta ya̱chi̱ ní kixaa̱ ña kui̱ta̱ níꞌnó ndiꞌi ndó, ta saá ñii ñii ndó noꞌo̱ ndó veꞌe mi̱i ndó. Ta sandakoo matóꞌón ndó yi̱ꞌi̱. Ta ndixa o̱n vása koo matóꞌón i̱ chi Yivá i̱ Ndios yóo ra xíꞌin i̱. ");
INSERT INTO mim_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nda̱to̱ꞌon i̱ ñayóꞌo xíꞌin ndó ña o̱n kundiꞌi ní ini ndó, ta ná koo ñava̱ꞌa ini ndó xa̱ꞌa̱ ña ñii yóo ndó xíꞌin i̱. Vará ndixa ndeé ní xo̱ꞌvi̱ ndó ñoyívi yóꞌo, ta o̱n kuyi̱ꞌví ndó ta chikaa̱ ndee̱ xíꞌin mi̱i ndó, chi yi̱ꞌi̱ xa ku̱ndeé i̱ no̱o̱ yichi̱ o̱n váꞌa ñoyívi yóꞌo ―káchí ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ta ndi̱ꞌi nda̱to̱ꞌon ra ñayóꞌo xíꞌin naxíka xíꞌin ra, ta saá ta̱Jesús na̱koto ndaa ra ñoyívi ni̱no, ta ni̱ka̱ꞌa̱n ra xíꞌin Ndios, káchí ra saá: ―Tata Yivá i̱, xa ki̱xaa̱ mi̱i ki̱vi̱ káꞌno ní. Ta vitin yi̱ꞌi̱, ta̱a ta̱ kúu Sa̱ꞌya ún, ndúkú i̱ no̱o̱ ún ña chinóo síkón ún ñato̱ꞌó i̱ no̱o̱ ni̱vi. Ñava̱ꞌa yóꞌo ndúkú i̱ no̱o̱ ún xa̱ꞌa̱ ña chinóo síkón i̱ ñato̱ꞌó mi̱i ún no̱o̱ ni̱vi. ");
INSERT INTO mim_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yóꞌó kúu ta̱a ta̱ ta̱xi nda̱yí ndaꞌa̱ yi̱ꞌi̱ ña kuu i̱ ta̱a ta̱káꞌno no̱o̱ ndiꞌi ni̱vi, xa̱ꞌa̱ ña taxi i̱ ndiꞌi saá ki̱vi̱ kutaku̱ ndinoꞌo ndiꞌi ni̱vi na kúu na ta̱xi ún ndaꞌa̱ i̱. ");
INSERT INTO mim_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Yóꞌó kúu ñii la̱á Ndios ndinoꞌo, ta yi̱ꞌi̱ kúu Jesucristo, ta̱a ta̱ ti̱ꞌví ún ki̱xaa̱ i̱ ñoyívi yóꞌo ña saka̱ku i̱ ni̱vi. Ta saá tá to̱nda̱a ni̱vi koni̱ ndixa na yóꞌó, ta koni̱ ndixa na yi̱ꞌi̱ Jesucristo, ta ña ke̱ꞌé na saá kúu ña táxi kutaku̱ ndinoꞌo ni̱vi ndiꞌi saá ki̱vi̱. ");
INSERT INTO mim_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ta vitin xa ki̱sa ndivi i̱ ndiꞌi chiño ña ta̱xi ún ndaꞌa̱ i̱, ta xa̱ꞌa̱ ñayóꞌo kua̱ꞌa̱ ní ni̱vi kasa káꞌno ní na yóꞌó. ");
INSERT INTO mim_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ta vitin, Tata Yivá i̱, chinóo síkón ún ñato̱ꞌó i̱ no̱o̱ mi̱i ún. Ñii ki̱ꞌva nda̱tán ni̱xi̱yo síkón ñato̱ꞌó i̱ ki̱vi̱ xi̱taku̱ i̱ xíꞌin ún ñoyívi ni̱no siꞌna tá o̱n ta̱ꞌán ka̱ kuva̱ꞌa ñoyívi yóꞌo, saá ná koo ña. ");
INSERT INTO mim_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ni̱vi na ta̱xi ún ndaꞌa̱ i̱ ña kundiko̱n na yi̱ꞌi̱, ta sa̱náꞌa va̱ꞌa i̱ nayóꞌo ña kunda̱a̱ ini na xa̱ꞌa̱ ún. Ni̱vi na na̱ka̱xin ún kúu na, ta ta̱xi ún na ndaꞌa̱ i̱ ña kundiko̱n na yi̱ꞌi̱, ta ndixa chi̱kaa̱ so̱ꞌo na to̱ꞌon ún. ");
INSERT INTO mim_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ta vitin ni̱vi yóꞌo kúnda̱a̱ ini na ndí ndiꞌi ña ta̱xi ún ndaꞌa̱ i̱ kúu ña va̱xi no̱o̱ mi̱i ún, ");
INSERT INTO mim_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","chi ni̱ka̱ꞌa̱n i̱ xíꞌin na ndiꞌi to̱ꞌon ña ta̱xi ún ña ndato̱ꞌon i̱ xíꞌin na. Ta ndiꞌi to̱ꞌon yóꞌo na̱kiꞌin va̱ꞌa na ña, ta xa ku̱nda̱a̱ ini na ndí ndixa yi̱ꞌi̱ ke̱e i̱ no̱o̱ ún, ta kándixa na ndí yóꞌó kúu ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Xa̱ꞌa̱ ni̱vi yóꞌo na ndíko̱n yi̱ꞌi̱ ndúkú i̱ no̱o̱ ún, ta o̱n vása ndúkú i̱ no̱o̱ ún xa̱ꞌa̱ ni̱vi na ndíko̱n yichi̱ o̱n váꞌa ñoyívi yóꞌo. Ndúkú i̱ no̱o̱ ún xa̱ꞌa̱ ni̱vi na ta̱xi ún ndaꞌa̱ i̱, chi ni̱vi na na̱ka̱xin mi̱i ún kúu nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Chi ndiꞌi ni̱vi na ndíko̱n yi̱ꞌi̱ kúu na ndíko̱n yóꞌó, ta ndiꞌi ni̱vi na ndíko̱n yóꞌó kúu na ndíko̱n yi̱ꞌi̱. Xa̱ꞌa̱ ña kéꞌé nayóꞌo kúu ña kánóo síkón ñato̱ꞌó i̱. ");
INSERT INTO mim_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Ta yi̱ꞌi̱, o̱n kóo ka̱ i̱ ñoyívi yóꞌo, chi saloꞌo ki̱vi̱ kúma̱ni̱ ta ndikó i̱ noꞌo̱ i̱ no̱o̱ mi̱i ún ñoyívi ni̱no, ta ni̱vi na ndíko̱n yi̱ꞌi̱ kundo̱o ka̱ na ñoyívi yóꞌo. Tata Yivá i̱, ta̱a ta̱ kúu ta̱ ndinoꞌo yi̱i̱, xáku ndáꞌví i̱ no̱o̱ ún ña xíꞌin nda̱yí ki̱vi̱ ún kundaa va̱ꞌa ún ni̱vi na ta̱xi ún ndaꞌa̱ i̱. Kundaa va̱ꞌa ún nayóꞌo xa̱ꞌa̱ ña ñii kuu na. Ñii ki̱ꞌva nda̱tán ñii kúu mi̱i yó, saá ná kuu nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ta ki̱vi̱ ni̱xi̱yo i̱ xíꞌin ni̱vi na ndíko̱n sa̱ta̱ i̱ ñoyívi yóꞌo, ta ndiꞌi saá ki̱vi̱ xi̱ndaa i̱ nayóꞌo na kúu na ta̱xi ún ndaꞌa̱ i̱. Ta xíꞌin nda̱yí ki̱vi̱ ún xi̱ndaa i̱ na, ta saá nda̱ ñii nayóꞌo ni̱‑ndañóꞌó na no̱o̱ i̱. Ndasaá kuiti ta̱a ta̱ ndíko̱n yichi̱ ñandiva̱ꞌa kúu ta̱a ta̱ nda̱ñóꞌó no̱o̱ i̱. Saá ni̱xi̱yo xa̱ꞌa̱ ña kundivi to̱ꞌon mi̱i ún ña ni̱taa na xi̱na̱ꞌá xa̱ꞌa̱ ta̱yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Vitin ndikó i̱ xaa̱ i̱ no̱o̱ ún, Tata Yivá i̱. Ta ña yóo ka̱ i̱ ñoyívi yóꞌo, káꞌa̱n i̱ to̱ꞌon yóꞌo ña koni̱ so̱ꞌo ni̱vi na ndíko̱n yi̱ꞌi̱ ña kusii̱ ini na. Nda̱tán ñii ki̱ꞌva chútú ini i̱ xíꞌin ñasi̱i̱, saá ná kutú ñasi̱i̱ ini nayóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Xa nda̱to̱ꞌon i̱ to̱ꞌon ún xíꞌin nayóꞌo na kúu na ndíko̱n yi̱ꞌi̱. Ta ni̱vi na ndíko̱n yichi̱ ñoyívi yóꞌo sáa̱ ini na xíni na nayóꞌo, saá chi ni̱vi na ndíko̱n yi̱ꞌi̱ o̱n vása ñii yóo yuꞌú na xíꞌin ni̱vi na ndíko̱n yichi̱ o̱n váꞌa ñoyívi yóꞌo. Ta ñii ki̱ꞌva saá yi̱ꞌi̱, o̱n vása ñii yóo yuꞌú i̱ xíꞌin ni̱vi na ndíko̱n yichi̱ o̱n váꞌa ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ta o̱n vása ndúkú i̱ no̱o̱ ún ña tava ún ni̱vi na ndíko̱n yi̱ꞌi̱ ña sandakoo na ñoyívi yóꞌo, ta ndixa ndúkú i̱ no̱o̱ ún ña kundaa va̱ꞌa ún ni̱vi yóꞌo no̱o̱ ña o̱n váꞌa ndiꞌi ki̱vi̱ táku̱ ka̱ na ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ni̱vi na ndíko̱n yi̱ꞌi̱ o̱n vása ndíko̱n na yichi̱ o̱n váꞌa ñoyívi yóꞌo, chi yi̱ꞌi̱ o̱n vása ndíko̱n i̱ yichi̱ o̱n váꞌa yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tata Yivá i̱, chindeé ún nayóꞌo ña chikaa̱ so̱ꞌo na to̱ꞌon mi̱i ún ña kúu ña ndixa nda̱a̱, ta xíꞌin ñayóꞌo, ndasa ndii ún ini na. ");
INSERT INTO mim_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nda̱tán yóo ña ti̱ꞌví ún yi̱ꞌi̱ kasa ndivi i̱ chiño ña kóni ún ñoyívi yóꞌo, saá yóo ña tiꞌví i̱ ni̱vi na ndíko̱n yi̱ꞌi̱ ña kasa ndivi na chiño ña kóni ún ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ta táxi ndinoꞌo xíꞌin mi̱i i̱ kasa ndivi i̱ ña kóni ún. Ta xa̱ꞌa̱ ña kéꞌé i̱ saá, na ndíko̱n yi̱ꞌi̱ nduu na ni̱vi na nataxi ndinoꞌo xíꞌin mi̱i ña kasa ndivi na ña kóni ún. ");
INSERT INTO mim_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’O̱n si̱ví ndasaá kuiti xa̱ꞌa̱ ni̱vi na ndíko̱n yi̱ꞌi̱ vitin kúu ña xáku ndáꞌví i̱ no̱o̱ ún, ta xáku ndáꞌví i̱ no̱o̱ ún xa̱ꞌa̱ ni̱vi na kundiko̱n yi̱ꞌi̱ ki̱vi̱ ña va̱xi, chi nayóꞌo kúu na kandixa to̱ꞌon ña ndato̱ꞌon na ndíko̱n yi̱ꞌi̱ vitin. ");
INSERT INTO mim_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Xáku ndáꞌví i̱ no̱o̱ ún xa̱ꞌa̱ ndiꞌi ni̱vi na kundiko̱n yi̱ꞌi̱ ña chindeé ún na ña ñii kuu ndiꞌi na. Nda̱tán yóꞌó táku̱ ún ini mi̱i i̱, ta yi̱ꞌi̱ táku̱ i̱ ini mi̱i ún, ñii ki̱ꞌva saá kóni i̱ ndí ni̱vi yóꞌo kutaku̱ na ini mi̱i yó. Saá ná koo ña xa̱ꞌa̱ ña kunda̱a̱ ini ni̱vi ñoyívi yóꞌo ndí ndixa yóꞌó kúu ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mi̱i ñava̱ꞌa káꞌno ña ta̱xi ún ndaꞌa̱ i̱ kúu ñava̱ꞌa káꞌno táxi i̱ ndaꞌa̱ ni̱vi na ndíko̱n yi̱ꞌi̱ xa̱ꞌa̱ ña ñii kuu ndiꞌi na, ñii ki̱ꞌva nda̱tán ñii kúu mi̱i yó. ");
INSERT INTO mim_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Chi yi̱ꞌi̱ kutaku̱ i̱ ini ni̱vi yóꞌo, nda̱tán yóꞌó táku̱ ún ini mi̱i i̱. Ta saá ñii nduu ini ndiꞌi yó, ta xa̱ꞌa̱ ñayóꞌo ni̱vi ñoyívi yóꞌo kunda̱a̱ ini na ndí yóꞌó kúu ta̱a ta̱ ti̱ꞌví yi̱ꞌi̱ ki̱xaa̱ i̱ ñoyívi yóꞌo, ta kunda̱a̱ ini na ndí ndixa ñii ki̱ꞌva nda̱tán kíꞌvi ini ún xíni ún yi̱ꞌi̱, saá kíꞌvi ini ún xíni ún ni̱vi na ndíko̱n yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tata Yivá i̱, ndúkú i̱ no̱o̱ ún xa̱ꞌa̱ ndiꞌi ni̱vi na ta̱xi ún ndaꞌa̱ i̱, chi kóni i̱ ña xaa̱ nayóꞌo kutaku̱ na xíꞌin i̱ ñoyívi ni̱no. Ndixa kóni i̱ ña koto na ñava̱ꞌa káꞌno ña livi yéꞌe ña kómí i̱ chi ta̱xi ún ñava̱ꞌa yóꞌo ndaꞌa̱ i̱. Saá ke̱ꞌé ún xíꞌin i̱, chi siꞌna tá o̱n ta̱ꞌán kuva̱ꞌa ñoyívi, ta xa kíꞌvi ini ún xíni ún yi̱ꞌi̱. ");
INSERT INTO mim_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata Yivá i̱, yóꞌó kúu ta̱a ta̱ ndinoꞌo nda̱a̱. Vará ni̱vi na ndíko̱n yichi̱ o̱n váꞌa ñoyívi yóꞌo o̱n vása xíni̱ na yóꞌó, ta yi̱ꞌi̱ xíni̱ va̱ꞌa i̱ yóꞌó, ta ni̱vi na ndíko̱n sa̱ta̱ i̱ xíni̱ na ña ti̱ꞌví ún yi̱ꞌi̱ ki̱xaa̱ i̱ ñoyívi yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Xa sa̱náꞌa i̱ nayóꞌo ndiꞌi ña kúu ña xíni̱ ñóꞌó kunda̱a̱ ini na xa̱ꞌa̱ ún, ta o̱n vása sandakoo i̱ ña sanáꞌa i̱ na ndiꞌi ña xíni̱ ñóꞌó kunda̱a̱ ini na xa̱ꞌa̱ ún. Ta xa̱ꞌa̱ ñayóꞌo nda̱tán ñii ki̱ꞌva kíꞌvi ini ún xíni ún yi̱ꞌi̱, ñii ki̱ꞌva saá kukiꞌvi ini na koni táꞌan na. Ta saá tuku yi̱ꞌi̱ kutaku̱ i̱ ini na ―káchí ta̱Jesús xíꞌin Ndios. ");
INSERT INTO mim_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tá ndi̱ꞌi ni̱ka̱ꞌa̱n ta̱Jesús xíꞌin Ndios, ta ke̱e ra kua̱ꞌa̱n ra, ta naxíka xíꞌin ra ke̱e na ndíko̱n na kua̱ꞌa̱n na sa̱ta̱ ra. Ni̱yaꞌa na ñii yivi̱ na̱ní ña Cedrón. Ta inka̱ táꞌví yuꞌu̱ yivi̱ yóꞌo yóo ñii jardín, ta ki̱xaa̱ ta̱Jesús xíꞌin naxíka xíꞌin ra, ta ni̱ki̱ꞌvi na jardín yóꞌo. ");
INSERT INTO mim_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ta ta̱Judas, ta̱ kúu ta̱ ni̱si̱kó kuíꞌná ta̱Jesús ndaꞌa̱ na sáa̱ ini xíni ñaꞌá, xa xíni̱ ra no̱o̱ yóo jardín yóꞌo, chi yóꞌo kúu xiiña no̱o̱ kua̱ꞌa̱ ní yichi̱ xi̱xa̱ꞌa̱n ta̱Jesús xíꞌin naxíka xíꞌin ra. ");
INSERT INTO mim_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ta saá ta̱Judas ki̱xaa̱ ra yóꞌo, ta ñii tiꞌvi natropa xíꞌin napolicía na ndáa veꞌe ño̱ꞌo káꞌno ki̱xaa̱ na xíꞌin ra. Sava nafariseo xíꞌin sava nanáꞌno no̱o̱ nasu̱tu̱ ti̱ꞌví na napolicía yóꞌo ña tiin na ta̱Jesús. Sava nayóꞌo níꞌi na candil no̱o̱ xíxi̱ ñoꞌo̱, sava na níꞌi na yito̱n no̱o̱ kánóo ñoꞌo̱ ña xíxi̱, ta sava na níꞌi espada. ");
INSERT INTO mim_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ta ta̱Jes