﻿USE sofia;
DROP TABLE IF EXISTS sofia.milNT_vpl;
CREATE TABLE milNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES milNT_vpl WRITE;
INSERT INTO milNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Te ñaní tnáhá Xǐtohó Jesucrìstú ní cuu ndíi Dàvií ndɨhɨ ndíi Àbrahám, cue tée ní xíndecu ndéé sanaha vìhi‑gá ñuyíú‑a. Te duha ndùu cuendá dava‑gá cue tée ní cuu ñaní tnáhá‑gǎ ní xíndecu ndéé sanaha. ");
INSERT INTO milNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ndíi Àbrahám ní xóo ɨɨⁿ déhe ndíi, te ndíi‑áⁿ nǐ xínani ndǐi Isàác. Te déhe ndíi Isàác‑áⁿ nǐ cuu ndíi Jàcób, te déhe ndíi Jàcób‑áⁿ nǐ cuu ndíi Jùdá, te dɨu‑ni ndíi Jàcób‑áⁿ nǐ cuu tǎtá dava‑gá cue ñaní ndíi Jùdá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Te déhe ndíi Jùdá‑áⁿ ndɨhɨ ñadɨ̀hɨ́ ndíi, ndíi Tàmár ní cuu ndíi Fàrés ndɨhɨ ndíi Zàrá. Te déhe ndíi Fàrés‑áⁿ nǐ cuu ndíi Èsróm, te déhe ndíi Èsróm‑áⁿ nǐ cuu ndíi Àrám. ");
INSERT INTO milNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Te déhe ndíi Àrám‑áⁿ nǐ cuu ndíi Aminàdáb, te déhe ndíi Aminàdáb‑áⁿ nǐ cuu ndíi Nàsón, te déhe ndíi Nàsón‑áⁿ nǐ cuu ndíi Sàlmón. ");
INSERT INTO milNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Te ñadɨ̀hɨ́ ndíi Sàlmón‑áⁿ nǐ xínani‑aⁿ Ràháb, te ní xóo ɨɨⁿ déhe‑yu ní xínani‑dě Bòóz. Te ñadɨ̀hɨ́ ndíi Bòóz‑áⁿ nǐ xínani‑aⁿ Rǔt, te ní xóo ɨɨⁿ déhe‑yu ní xínani‑dě Òbéd, te déhe ndíi Òbéd‑áⁿ nǐ cuu ndíi Isàí. ");
INSERT INTO milNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Te déhe ndíi Isàí‑áⁿ nǐ cuu ndíi Dàvií tée ní xɨ́ndaha ñàha xii cue ñáyiu isràél. Te déhe ndíi Dàvií‑áⁿ ndɨhɨ ñadɨ̀hɨ́ ndíi ní cuu ndíi Salòmón. Te díhna‑gá ndíi Ùriás ní cándeca ndíi ñadɨ̀hɨ́‑áⁿ te dǎtnùní ní naqueheⁿ ñaha ndǐi Dàvií‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Te déhe ndíi Salòmón ní cuu ndíi Ròboám, te déhe ndíi Ròboám‑áⁿ nǐ cuu ndíi Àbiás, te déhe ndíi Àbiás‑áⁿ nǐ cuu ndíi Àsá. ");
INSERT INTO milNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Te déhe ndíi Àsá‑áⁿ nǐ cuu ndíi Josàfát, te déhe ndíi Josàfát‑áⁿ nǐ cuu ndíi Jòrám, te déhe ndíi Jòrám‑áⁿ nǐ cuu ndíi Ùziás. ");
INSERT INTO milNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Te déhe ndíi Ùziás‑áⁿ nǐ cuu ndíi Jòtám, te déhe ndíi Jòtám‑áⁿ nǐ cuu ndíi Àcáz, te déhe ndíi Àcáz‑áⁿ nǐ cuu ndíi Ezèquiás. ");
INSERT INTO milNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Te déhe ndíi Ezèquiás‑áⁿ nǐ cuu ndíi Manàsés, te déhe ndíi Manàsés‑áⁿ nǐ cuu ndíi Àmón, te déhe ndíi Àmón‑áⁿ nǐ cuu ndíi Jòsiás. ");
INSERT INTO milNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Te déhe ndíi Jòsiás‑áⁿ nǐ cuu ndíi Jecòniás. Te dɨu‑ni ndíi Jòsiás‑áⁿ nǐ cuu tǎtá nchaa dava‑gá cue ñaní ndíi Jecòniás‑áⁿ. Te dàvá‑áⁿ nǐ quide yica cuè tée ñuú Babìloniá ndécá‑güedě ñáyiu isràél cuáháⁿ ñuú‑güedé cuèndá yàcáⁿ cundecú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Te sátá nǐ yáha ducaⁿ nǐ cuu, te ndíi Jecòniás ní xóo ɨɨⁿ déhe ndíi ndɨhɨ ñadɨ̀hɨ́ ndíi, te tée‑áⁿ nǐ xínani‑dě Salàtiél. Te déhe ndíi Salàtiél‑áⁿ nǐ cuu ndíi Zorobàbél. ");
INSERT INTO milNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Te déhe ndíi Zorobàbél‑áⁿ nǐ cuu ndíi Àbiúd, te déhe ndíi Àbiúd‑áⁿ nǐ cuu ndíi Eliàquím, te déhe ndíi Eliàquím‑áⁿ nǐ cuu ndíi Àzór. ");
INSERT INTO milNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Te déhe ndíi Àzór‑áⁿ nǐ cuu ndíi Sàdóc, te déhe ndíi Sàdóc‑áⁿ nǐ cuu ndíi Àquím, te déhe ndíi Àquím‑áⁿ nǐ cuu ndíi Èliúd. ");
INSERT INTO milNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Te déhe ndíi Èliúd‑áⁿ nǐ cuu ndíi Eleàzár, te déhe ndíi Eleàzár‑áⁿ nǐ cuu ndíi Màtán, te déhe ndíi Màtán‑áⁿ nǐ cuu ndíi Jàcób. ");
INSERT INTO milNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Te déhe ndíi Jàcób‑áⁿ nǐ cuu ndíi Chèé tée ní cuu yɨɨ tá Màriá xíchí nǐ cuu nǎná Jèsús Yaá ní tendaha Dǔtú Ndiǒxí ní quixi ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Te sa ní cuu úxúú tnàhá cue tée cùu ñaní tnáhá ndǐi Àbrahám ndécú dàvá‑áⁿ, te dǎtnùní ní cacu ndíi Dàvií dɨu‑ni ñaní tnáhá ndǐi. Te núú tnàhá méé ndǐi Àbrahám ndɨhɨ ndíi Dàvií ní cuu úxícúmí tnàhá‑güedé. Te ducaⁿ te sa ní xínu úxícúmí‑gǎ tucu‑güedé ní cacu, te dǎtnùní ní tnɨɨ ñaha cuè tée ñuú Babìloniá xii ñáyiu isràél ndécá ñàha‑güedé xií‑yu cuáháⁿ ñuú‑güedé cuèndá yàcáⁿ cundecú‑yu. Te sátá nǐ yáha sá dúcáⁿ nǐ cuu, te ní cacu úxúní tucu cue tée ní cuu ñaní tnáhá ndǐi Àbrahám ndɨhɨ ndíi Dàvií, te dǎtnùní ní cacu Xítohó Jesucrìstú ñuyíú‑a. Te núú tnàhá méé‑gǎ ní cuu úxícúmí tnàhá‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Te duha ní cuu cútnàhá ní cacu Xítohó Jesucrìstú, chi dàvá‑áⁿ nǐ xíndecu ɨɨⁿ xíchí cuéchí nǐ xínani Màriá. Te xíchí‑ǎⁿ sa ní cundáá tnúhu sá tnǎndaha‑xi ndɨhɨ ɨɨⁿ tée nàni Cheé. Te cùmání‑gǎ tnándaha‑xi ndɨhɨ tée‑áⁿ te Espíritú Yǎ Ndiǒxí ní quide ní ngúhuⁿ déhe‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Te té Chèé tée cuìní candeca ñaha xìi xíchí‑ǎⁿ nǐ cutnùní iní‑dé sá ñúhú děhe‑xi. Te cùu‑dé ɨɨⁿ tée quìde ndáá, núu xíǎⁿ duuⁿ duuⁿ ní sani iní‑dé sá vǎ tnǎndaha‑gá‑dé ndɨhɨ‑xi, te dìcó‑ni sá ñà túú ní cǎháⁿ‑dé chi ní cuiní‑dé sá vǎ càháⁿ cuèhé cáháⁿ duha ñáyiu cuèndá‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Te sátá dúcáⁿ nǐ sani iní‑dé te ní ngáva‑dé ní xídí‑dé, te núú sàní‑dé ní sáháⁿ ɨɨⁿ espíritú xínú cuèchi núú Yǎ Ndiǒxí ní xáhaⁿ‑xi xìi‑dé: —Yòhó té Chèé tée cùu ñaní tnáhá ndǐi Dàvií, yúhú càchí tnúhu‑í xii‑n sǎ ñà túú nǎ cani iní‑n, tnǎndaha nahi‑ni‑n ndɨ̀hɨ tá Màriá cuěi ñùhu déhe‑xi, chi mee Espíritú Yǎ Ndiǒxí ní quide‑xi ducaⁿ nǐ ngúhuⁿ déhe‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Te na càcu déhe‑xi‑áⁿ te danàni‑n‑dé Jèsús. Te ducaⁿ cùnani‑dé, chi tée‑áⁿ cada‑dé cuèndá sá vǎ cúndècu‑gá cue ñaní tnáhá‑dě ñáyiu isràél ichi cuèhé ichi duha —duha ní xáhaⁿ espíritú‑áⁿ xii té Chèé‑áⁿ nǔú sàní‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa ní xáhaⁿ Yǎ Ndiǒxí xii ɨɨⁿ tée ní cáháⁿ tnúhu‑gá ndéé sanaha. Te tée‑áⁿ nǐ chídó tnùní‑dé núú tùtú‑gá nàcuáa ní xáhaⁿ‑gǎ xii‑dé, te duha ní xáhaⁿ‑gǎ: ");
INSERT INTO milNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Cundecu ɨɨⁿ xíchí cuéchí ndèé cuèé‑gá. Te òré ndécú ǐí‑xi vátá nìhí‑gá yɨɨ‑xi te ngúhuⁿ déhe‑xi. Te òré ná cácú děhe‑xi te danàni ñahá‑yu Emànuél. Duha ní xáhaⁿ‑gǎ xii tée‑áⁿ nǐ chídó tnùní‑dé núú tùtú‑gá. Te tnúhu Emànuél‑áⁿ quéé‑xí: Yá Ndiǒxí ndécú ndɨ̀hɨ‑o. Núu xíǎⁿ ducaⁿ nǐ cuu vitna. ");
INSERT INTO milNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Te òré ní ndɨquɨ́ú ìní té Chèé‑áⁿ te ní quide‑dé nàcuáa ní xáhaⁿ espíritú‑áⁿ xii‑dé chi ní tnándaha‑dé ndɨhɨ tá Màriá. ");
INSERT INTO milNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Dico ndɨ dɨ́ɨ́ⁿ nǐ xíndecú‑yu ndéé ní sáá nduu nǐ cacu déhe‑xi. Te òré ní cacu déhe‑xi‑áⁿ te ní dánání ñàha‑dé Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Te Jèsús ní cacu‑gá ɨɨⁿ ñuú nání Bèlén, te ñuú‑áⁿ yɨ́ndèhu‑xi distritú Jùdeá. Te dàvá‑áⁿ cúnùu té Hèrodés yɨ́ndàha‑dé ñáyiu. Te ñuú Jerusàlén ní quexìo cue tée véxi ndàa xio nacuáa quène nchícanchii, cue tée túha dàcuaha cuendá nchaa sá ndèé andɨu. ");
INSERT INTO milNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Te ndùcu tnúhu‑güedé núú ñǎyiu ñuú‑áⁿ, te xǎhaⁿ‑güedě: —¿Vá cúndèe iní‑ndó càchí tnúhu‑ndo ndèé ndécú těe quɨndaha ñàha xii ñáyiu isràél‑ǎⁿ? Chi ní xiní‑ndɨ́ ní quene chódíní‑dě ndàa xio nacuáa quène nchícanchii, núu xíǎⁿ véxi‑ndɨ́ chi cuìní‑ndɨ́ quiní‑ndɨ́‑dé te chiñuhu‑ndɨ̌‑dé —càchí‑güedé xǎhaⁿ‑güedě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Te òré ní níhí těe cùnuu nani Herodés tnúhu sá ndúcú tnǔhu cue tée‑áⁿ ndèé ndécú těe quɨndaha ñàha xii ñáyiu isràél, te ñá túú tnàhí ni cùu váha iní‑dé, te dɨu‑ni ducaⁿ ñà túú ní cùu váha iní tnàhá nchaa ñáyiu ñuú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Te ní cana‑dé cue tée cùu dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, te ní xícáⁿ tnúhú‑dě núú‑güedě nǔu xìní‑güedé ndèé cacu Crìstú tée tendaha Yǎ Ndiǒxí quixi ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Te ní xáhaⁿ‑güedě xii‑dé: —Ɨɨⁿ ñuú yɨ́ndèhu distritú Jùdeá cacu‑dé, te ñuú‑áⁿ nání‑xí Bèlén, chi quee ndáá‑xi nàcuáa ní xáhaⁿ Yǎ Ndiǒxí xii ɨɨⁿ tée ní xóo cáháⁿ tnúhu‑gá ndéé sanaha. Te duha ndùu tnúhu ní chídó tnùní‑dé núú tùtú‑gá: ");
INSERT INTO milNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ñuú Bèlén cúú‑xí ɨ̀ɨⁿ ñuú lǐhli yɨ̀ndehu distritú Jùdeá, te ío‑gá cúnùu‑xi dacúúxí dàva‑gá ñuú cúnùu yɨndehu distritú‑áⁿ, chi dɨu ñuú‑áⁿ quee ɨɨⁿ tée ío cùnuu. Te tée cunuu‑ǎⁿ quɨndaha‑dě ñáyiu cùu cuendá‑í ñáyiu isràél. Duha ní xáhaⁿ‑gǎ xii tée ní xóo cáháⁿ tnúhu‑gá, te ducaⁿ nǐ chídó tnùní‑dé núú tùtú‑gá —càchí‑güedé xǎhaⁿ‑güedě xii té Hèrodés. ");
INSERT INTO milNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Te sátá dúcáⁿ te té Hèrodés dayuhu nǐ cana‑dé cue tée ndùcu tnúhu núu ndèé ní cacu tée quɨndaha ñàha xii ñáyiu isràél, te ní xícáⁿ tnúhú‑dě núú‑güedě ná nduu cùu‑xi nduu díhna nuu nǐ xiní‑güedé chódíní. ");
INSERT INTO milNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Te sátá dúcáⁿ te ní xáhaⁿ‑dě xii‑güedé: —Chí cuàháⁿ ñuú Bèlén te nducu tnǔhu váha‑ndo nǔu ndèé ní cacu tée ducaⁿ quɨ̀ndaha ñaha xii ñáyiu isràél. Te òré ná nàníhí‑ndó‑dě te quixi‑ndo càchí tnúhu‑ndo cuèndá quɨ́hɨ́ⁿ‑í tnàhá‑í chiñuhu‑í‑dé —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Te sátá dúcáⁿ nǐ xáhaⁿ tě Hèrodés‑áⁿ te ní xica‑güedé cuáháⁿ‑güedé. Te chódíní nǐ xiní‑güedé ní quene ndàa xio nacuáa quène nchícanchii‑áⁿ yòdo nuu‑dɨ núú‑güedě cuáháⁿ. Te ní ngüɨ́ñɨ́ chódíní‑ǎⁿ, te núú nǐ ngüɨ́ñɨ́‑dɨ‑áⁿ yɨ́ndǎá núú ndécú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Te òré ní xiní cue tée‑áⁿ nǐ ngüɨ́ñɨ́ chódíní‑ǎⁿ nǔú yɨ́ndǎá ndécú‑gǎ, te ní cudɨ́ɨ́ víhí ìní‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Te ducaⁿ te ní quexìo‑güedé ndéé núú cáá vèhe ndecu Jesús. Te òré cuánguɨhu‑güedé xɨtɨ́ vehe te ní xiní‑güedé Jèsús ndécú‑gǎ ndɨhɨ nǎná‑gǎ Màriá. Te ní ngüɨ́ñɨ́ xɨ́tɨ́‑güedě, te ní ngüíta‑güedé ní cachí‑güedé sá ǐo càhnu cuu Jesús. Te dǎtnùní ní nacaáⁿ‑güedé càjá xǐnehe‑güedé, te ní tava‑güedé díhúⁿ cuàáⁿ, ndɨhɨ dúsa sá ǐo váha sàháⁿ tnámí nàni insiensú, ndɨhɨ yúcú sǎ nání mìrrá ní taxi ndecu‑güedé núú Jèsús cuèndá cuu‑xi ɨɨⁿ táhú sǎ cúú‑xí‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Te Yá Ndiǒxí ní cáháⁿ‑gá núú sàní‑güedé, te xǎhaⁿ‑gǎ xii‑güedé sá vǎ náyǎha‑gá‑güedé cáháⁿ ndɨhɨ‑güedé té Hèrodés. Núu xíǎⁿ cue tée‑áⁿ cuǎnuhú‑güedé ɨngá ichi, te ñá túú‑gǎ ní nàyáha‑güedé núú ndécú tě Hèrodés. ");
INSERT INTO milNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Te sátá nǐ yáha cuánuhú cue tée ní sángoto ñaha xìi Jesús, te ní quexìo ɨɨⁿ espíritú xínú cuèchi núú Yǎ Ndiǒxí núú sàní té Chèé, te xǎhaⁿ‑xi xìi‑dé: —Véxi‑í càchí tnúhu‑í xii‑n sǎ ndàcóo‑n, te ndee‑n ñùú‑a ndɨhɨ Jèsús, ndɨhɨ nǎná‑gǎ cunu‑ndo quɨ̌hɨ́ⁿ‑ndó nàcióⁿ Ègiptú, chi té Hèrodés tendaha‑dě cue tée quixi nanducu ñàha xii Jesús cuèndá cahni ñaha‑güedě. Te yàcáⁿ cundecu‑ndo nděé cachí tnúhu‑í xii‑n ndùu ndixi‑ndo —cachí espíritú‑áⁿ xǎhaⁿ‑xi xìi té Chèé núú sàní‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Te té Chèé‑áⁿ nǐ ndacóo‑dé, te niú ní xica‑dé ndɨhɨ tá Màriá ndécǎ‑yu Jèsús cuáháⁿ nàcióⁿ Ègiptú. ");
INSERT INTO milNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Te nàcióⁿ Ègiptú‑áⁿ ndécǔ‑yu ní xíhí té Hèrodés. Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa ní cachí ɨɨⁿ tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǐ quide‑dé núú‑gǎ ní cáháⁿ‑dé yuhu‑gá, te duha ní xáhaⁿ‑gǎ ní cáháⁿ‑dé: “Nàcióⁿ Ègiptú ndécú Děhe‑í ní cùu, te ní xáhaⁿ‑ǐ xii‑dé sá ndéé‑dě ñuú‑áⁿ vǎ cúndècu‑gá‑dé”, duha ní xáhaⁿ‑gǎ xii tée ní cáháⁿ tnúhu‑gá ní quide‑dé núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Te cue tée ní sángoto ñaha xìi Jesús ní dándàhú‑güedé té Hèrodés, chi ñá túú ní nàyáha‑güedé cúñaha‑güedě sá nǐ naníhí‑güedě Jèsús. Te sátá nǐ cutnùní iní té Hèrodés sá nǐ dándàhú ñáhá‑güedě xii‑dé te ní cudééⁿ víhí‑dě, te ní tendaha‑dě cue tée cuáháⁿ ñuú Bèlén, ndɨhɨ nchaa dava‑gá ñuú cáá yàtni xíáⁿ cuèndá cahni‑güedé mee‑ni cuè landú tée. Te ndéé cue landú íchí nǐ cacu, ndɨhɨ ndéé cue landú sa ní nútnahá úú cuíá‑xi nchaa‑güexi cahni‑güedé ní xáhaⁿ‑dě. Te ducaⁿ nǐ quide‑dé chi ní quide cuèndá‑dé nàcuáa ndùu tnúhu ní xáhaⁿ cuè tée ní sángoto ñaha xìi Jesús nduu nǐ xiní‑güedé chódíní, núu xíǎⁿ ducaⁿ nǐ táúchíúⁿ‑dě ní quide cue tée‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa ní cachí ndíi Jerèmiás tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, te duha ní cachí ndíi: ");
INSERT INTO milNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ní tecú ndàhí víhí ñǎyiu ñuú Ràmá sá ndɨ̀hú iní‑yu, te ñáyiu xǐndáhyú‑áⁿ cúǔ‑yu ñaní tnáhá tǎ Ràquél, te ndàhyú‑yu cuèndá sá nǐ xíhí déhe‑yu. Te ñáyiu‑áⁿ ñà túú ní cuìní‑yu dàñá‑yu sá ndɨ̀hú iní‑yu cuèndá sá nǐ xíhí déhe‑yu. Duha ní cachí ndíi Jerèmiás. ");
INSERT INTO milNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Te sátá nǐ xíhí té Hèrodés te ní sáháⁿ tucu espíritú xínú cuèchi núú Yǎ Ndiǒxí núú sàní té Chèé òré ndécú‑dě nàcióⁿ Ègiptú, te ní xáhaⁿ‑xi xìi‑dé: ");
INSERT INTO milNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Véxi tucu‑í càchí tnúhu‑í xii‑n sǎ ndácǒo‑n, te núhú‑n ndɨ̀hɨ Jesús ndɨhɨ nǎná‑gǎ ñuú cue ñaní tnáhá‑n ñǎyiu isràél cundecu‑ndo, chi sa ní xíhí cue tée cuìní cahni ñaha xìi Jesús ní cùu —cachí espíritú‑áⁿ xǎhaⁿ‑xi xìi té Chèé núú sàní‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Te té Chèé‑áⁿ nǐ ndacóo‑dé, te ní ndee‑dé ndɨhɨ Jèsús ndɨhɨ nǎná‑gǎ cuánuhú‑yu ñuú cue ñáyiu isràél ñáyiu cùu ñaní tnáhǎ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Te té Chèé ní níhí‑dě tnúhu sá tě Arquèlaú ní nucúnutnɨ́ɨ‑dé núú tǎtá‑dě té Hèrodés distrìtú Jùdeá yɨ́ndàha‑dé ñáyiu. Te ní yùhú té Chèé‑áⁿ, te ñá túú ní cuìní‑dé quɨ́hɨ́ⁿ‑dé cundecu‑dé distrìtú‑áⁿ. Te Yá Ndiǒxí ní cáháⁿ‑gá núú sàní‑dé, te ní xáhaⁿ‑gǎ xii‑dé sá quɨ̀hɨ́ⁿ‑dé distrìtú Galìleá, núu xíǎⁿ yàcáⁿ cuáháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Te òré ní quexìó‑yu distrìtú Galìleá, te ní sáháⁿ‑yu ɨɨⁿ ñuú nání Nàzarét ní xíndecú‑yu. Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa ní cachí cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha sá Jèsús cuu‑gá tée ñuú Nazàrét. ");
INSERT INTO milNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Te ní xica nduu sá dúcáⁿ nǐ cuu, te tée nàni Juaá tée dacuàndute ñaha xii ñáyiu ní quexìo‑dé yucu distrìtú Jùdeá càháⁿ‑dé tnúhu Yá Ndiǒxí núú ñǎyiu xɨtɨ́ yucu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Te xǎhaⁿ‑dě xií‑yu: —Chí dándìxi túu iní sá ñà túú quìde váha‑ndo ndècu‑ndo, te daña‑ndo nchàa ichi cuehé ichi duha, chi sa ní cuyatni nduu ndɨ́hu ndaha ñàha Yá Ndiǒxí xii‑ndo —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Te dɨu cuèndá té Juàá‑áⁿ nǐ chídó tnùní ndíi Chàiá tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, te duha ndùu tnúhu ní chídó tnùní ndíi cuèndá‑dé: Tècú càháⁿ níhi ɨɨⁿ tée yɨ̀hɨ xɨtɨ́ yucu, te càchí‑dé: “Chí dáñá nchàa ichi cuehé ichi duha ndècu‑ndo, te tnɨɨ‑ndo ìchi váha, Te ducaⁿ càda‑ndo cuendá cundecu túha‑ndo chi véxi Yaá ío cùnuu”, duha quesaha těe‑áⁿ. Duha ndùu tnúhu ní chídó tnùní ndíi Chàiá‑áⁿ cuèndá té Juàá. ");
INSERT INTO milNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Te té Juàá‑áⁿ nǐ xóo cuihnu‑dé dóó idi càméyu, te ɨɨⁿ ñɨɨ ní cuu pàñú xɨtɨ́‑dé, te ní xóo caxi‑dé tɨ́ca làngóstá ndɨhɨ ndudí ñúñú cuéchí. ");
INSERT INTO milNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Te ñáyiu ñuú Jerusàlén, ndɨhɨ ñáyiu nchaa ñuú yɨ́ndèhu distritú Jùdeá, ndɨhɨ ñáyiu nchaa ñuú cáá yàtni yúte Jòrdán ní sáháⁿ‑yu ní xíndedóho‑yu nàcuáa ní cáháⁿ té Juàá. ");
INSERT INTO milNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Te ní ngüíta‑yu ní náhmá‑yu nchaa cuéchi‑yu núú Yǎ Ndiǒxí. Te òré ducaⁿ nǐ náhmá‑yu te ní dácuándùte ñaha té Juàá xií‑yu yúte Jòrdán. ");
INSERT INTO milNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Te vài cue tée cùu fariséú ndɨhɨ cue tée cùu saducéú cuáháⁿ‑güedé núú ndécú tě Juàá cuìní‑güedé dacuàndute ñaha‑dé xii‑güedé. Te òré ní quexìo‑güedé núú ndécú‑dě, te ní xáhaⁿ‑dě xii‑güedé: —¡Nchaa nchòhó cúú‑ndó dàtná ɨɨⁿ cóó děéⁿ chi ío cuihna ìní‑ndó! ¿Te nása ní cuu núu tnàhá nchòhó ndúcú‑ndó nàcuáa cada‑ndo cǎcu nihnu‑ndo nǔú tnǔndòho cahnu vihi ta cuyatni ñaha xii‑ndo véxi‑i? ");
INSERT INTO milNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Te chí cádá vǎha vitna cundecu‑ndo cuèndá ducaⁿ cùtnuní sá nǐ dáñá‑ndó nchàa ichi cuehé ichi duha ndècu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Te vá càchí‑ndó sǎ ǐo càhnu cuu‑ndo cuendá sá cúú‑ndó ñàní tnáhá ndǐi Àbrahám. Chi cuěi ndéé yúú te ndacu Yá Ndiǒxí ndada‑gá ñáyiu te cuú‑yu ñaní tnáhá ndǐi Àbrahám. ");
INSERT INTO milNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Te caá chi ndècu túha‑xi sá quèhndé‑xi nchaa yutnu sá dúcáⁿ ñà túú càváha sávìdí‑xi‑áⁿ, chi nchaa yutnu‑áⁿ tèhndé‑xi te cuángee‑xi núú ñùhú càyú‑xi. Te duha sǎtnàhá‑xi ndoho nchaa ñáyiu ñá túú quìde váha‑áⁿ chi nchaa ñáyiu ñá túú quìde váha cùú‑yu dàtná nchaa yutnu sá ñà túú càváha sávìdí‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ yǔhú dácuàndute‑í mee‑ni ñǎyiu ní dáñá nchàa ichi cuehé ichi duha. Dico nchìcúⁿ tucu ɨngá tée véxi, te tée‑áⁿ taxi‑dé Espíritú Yǎ Ndiǒxí cundecu ndɨhɨ‑ndo. Te cùu‑xi datná ɨɨⁿ ñuhú, chi ndada ndoo ndada nine‑xi iní‑ndó. Te tée‑áⁿ ǐo‑gá cúnùu‑dé dàcúúxí yǔhú, chi yúhú cúù‑í ɨɨⁿ tée duuⁿ duuⁿ ñá túú tàú cuita nehe ni chàú‑dé dico quìde‑í chìuⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Te tée‑áⁿ sa véxi túha‑dé sá cádá dɨ̀ɨⁿ ñaha‑dé xii‑o dàtná quídé ñǎyiu ndàda ndoo triú, chi ñáyiu‑áⁿ sa nèhe túha‑ná‑yu yaxíⁿ‑yu òré náñǎni cuèndá ndada ndoó‑yu. Te òré ndádá ndòó‑yu trìú‑áⁿ te dàquee dɨɨ́ⁿ‑yu mihi‑xi, te tàxúha‑yu mee‑nǎ trìú‑áⁿ te sàhmí‑yu mihi‑xi‑áⁿ. Te dàtná quídě‑yu mihi trìú‑áⁿ ducaⁿ sǎtnahá‑xi cada ñaha tée‑áⁿ xii nchaa ñáyiu ñá túú quìde váha, chi daquɨ̀hɨ́ⁿ ñáhá‑dě xií‑yu núú ñùhú núú càyú, te ñuhú‑áⁿ ñà túú tnàhí ndàhvá —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Te Jèsús ní quee‑gá distrìtú Galìleá cuáháⁿ‑gá yúte Jòrdán núú ndécú tě Juàá cuèndá dacuàndute ñaha‑dé xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Te òré ní quexìo Jesús núú ndécú tě Juàá, te ñá cuìní‑dé dacuàndute ñaha‑dé xii‑gá ní cùu, te ní xáhaⁿ‑dě xii‑gá: —Yúhú tàú‑í sá dácuàndute ñaha‑n xii‑í, te ñá dɨ́ú dà yúhú dacuàndute ñaha‑í xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Queheⁿ daña, chi dacuɨtɨ́í xìni ñuhu‑xi ducaⁿ cada‑o nacuáa cundáá‑ó nǔú Yǎ Ndiǒxí —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te té Juàá‑áⁿ nǐ sáháⁿ uuⁿ‑dé tnúhu ní xáhaⁿ Jèsús xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Te ní dácuándùte‑dé Jèsús. Te òré ní nene‑gá xɨtɨ́ ndute te ní xiní‑gá nchìí andɨu, te ní quee Espíritú Yǎ Ndiǒxí véxi cuuⁿ‑xi ngúndecu ndɨhɨ ñaha‑xi xìi‑gá, te dàtná cáá ɨ̀ɨⁿ lómá cáá Espíritú‑áⁿ věxi cuuⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Te òré‑áⁿ nǐ tecú ní cáháⁿ Yǎ Ndiǒxí ndéé andɨu, te xǎhaⁿ‑gǎ xii Jèsús: —Yòhó cúú‑n Děhe‑í tée ío cùu iní‑í te ío cùdɨ́ɨ́ ìní ñáhà‑í xii‑n —càchí‑gá xǎhaⁿ‑gǎ xii Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Te Espíritú Yǎ Ndiǒxí ndécá‑xí Jèsús cuáháⁿ ɨɨⁿ xɨtɨ́ yucu cuèndá yàcáⁿ cundecu tnaa‑gá, te yàcáⁿ quexìo sácuíhná coto ndeé ñáhá‑xí xìi‑gá te núu ndisa sá vǎ cádá‑gǎ ɨɨⁿ sá ñà túú tàú‑gá cada‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Te Jèsús ñá ní xèxi‑gá údico nduu údico niú, te ducaⁿ te dǎtnùní ní xícáⁿ iní‑gá caxi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Te sátá dúcáⁿ te ní quexìo sácuíhná quídé yìca‑xi cada Jesús ɨɨⁿ sá ñà túú tàú‑gá cada‑gá, te xǎhaⁿ‑xi xìi‑gá: —Te núu ndisa sá cúú‑n Děhe Yá Ndiǒxí te cúñaha xìi yúú‑a na ndùu‑xi paá —càchí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Te Jèsús ní xáhaⁿ‑gǎ xii‑xi: —Núú tùtú Yǎ Ndiǒxí càchí‑xi: “Ñá dɨ́ú mèe‑ni paá candeca‑xi iní ñáyiu ñuyíú, chi tnàhá nchaa tnúhu càháⁿ Yǎ Ndiǒxí candeca‑xi iní‑yu”, duha càchí‑xi núú tùtú‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Te dǎtnùní sácuíhná‑ǎⁿ ndécá ñàha‑xi xii‑gá cuáháⁿ ñuú Jerusàlén, te yàcáⁿ ní xáhaⁿ‑xi xìi‑gá cuásaá‑gá dɨ́quɨ́ véñǔhu càhnu sá ǐo cùnuu núú ñǎyiu isràél, ");
INSERT INTO milNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","te dǎtnùní ní xáhaⁿ tùcu‑xi xii‑gá: —Te núu ndisa cùu‑n Déhe Yá Ndiǒxí te cuandèe ndava núú ñúhú cuèndá quee ndáá‑xi nàcuáa càháⁿ‑xi núú tùtú‑gá núú càchí‑xi: “Yá Ndiǒxí tendaha‑gǎ cue espíritú xínú cuèchi núú‑gǎ quixi‑xi cuèndá coto ñaha‑xi xìi‑n, te núú ndáhá‑xí càundodo‑n cuendá sá vǎ dánǐcuèhé yúú sǎhá‑n”, duha càchí‑xi núú tùtú‑gá —càchí sácuíhná‑ǎⁿ xǎhaⁿ‑xi xìi Jesús. ");
INSERT INTO milNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Te Jèsús ní xáhaⁿ‑gǎ xii‑xi: —Te càchí tucu‑xi núú tùtú Yǎ Ndiǒxí: “Vá cání ìní‑n còto ndeé‑n Dǔtú Ndiǒxí Yaá cúú Ndiǒxí‑n cuèndá‑ni sá cuìní‑n sǎ dácǎcu nihnu ñaha‑gǎ xii‑n ɨ̀ɨⁿ sá sání ìní‑n càda‑n”, duha càchí‑xi núú tùtú‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Te sácuíhná ndécá tùcu‑xi Jesús cuáháⁿ ɨɨⁿ núú tɨ̀ndúú dùcúⁿ, te uuⁿni ní dánèhé núú ñáhá‑xí xìi‑gá nchaandɨ túhú nàcióⁿ cáá ñùyíú, ndɨhɨ nchaa sá vǎha ìó ɨɨⁿ ɨɨⁿ nàcióⁿ‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Te ní xáhaⁿ‑xi xìi‑gá: —Te núu yòhó ngüɨ́ñɨ́ xɨ́tɨ́‑n nǔù‑í chiñuhu ñaha‑n xìi‑í ñá, te taxi cuèndá‑í nchaa sá nǐ dánèhé ñáhà‑í‑a cuu cuèndá‑n —càchí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Te Jèsús ní xáhaⁿ‑gǎ xii‑xi: —Xocuɨ̀ñɨ́ yòhó sácuíhná nǔú ndécù‑í‑a, chi vá cúú càda‑í nàcuáa càchí‑n, chi núú tùtú Yǎ Ndiǒxí càchí‑xi: “Chiñuhu‑ndo Dǔtú Ndiǒxí Yaá cúú Ndiǒxí‑ndó, te dɨu‑ni‑gá cada‑ndo nchàa nacuáa càháⁿ‑gá”, duha càchí‑xi núú tùtú‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Te dǎtnùní sácuíhná nǐ dáñá‑xí Jèsús ní xica‑xi cuáháⁿ‑xi. Te sátá dúcáⁿ te ní quexìo cue espíritú xínú cuèchi núú Yǎ Ndiǒxí ní xinu cuechi‑xi nǔú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Te òré ní níhí Jèsús tnúhu sá nǐ ngava té Juàá tée dàcuandute ñaha xii ñáyiu vecaá, te ní xica‑gá cuáháⁿ‑gá distrìtú Galìleá. ");
INSERT INTO milNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Te ni ñà túú ní xǐndecu‑gá ñuú Nazàrét, chi ní yáha‑gá cuáháⁿ‑gá ndéé ñuú Capèrnaúm yàcáⁿ ní xíndecu‑gá, te ñuú‑áⁿ cáá yàtni yuhu lagúná, te yatni xíáⁿ cáá ñùhu nani Zabulón, ndɨhɨ ñuhu nàni Neftalí. ");
INSERT INTO milNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa ní chídó tnùní ndíi Chàiá tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǔú tùtú‑gá núú càchí‑xi: ");
INSERT INTO milNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ñuhu nàni Zabulón, ndɨhɨ ñuhu nàni Neftalí, ñuhu‑áⁿ yɨ́ndèhu‑xi distritú Galìleá, te xíáⁿ xǐndecu cue ñáyiu ñá túú cùu ñáyiu isràél, te càa‑xi yatni yuhu lagúná te ndàa ɨngá xio yúte Jòrdán cúú‑xí. ");
INSERT INTO milNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Te cue ñáyiu‑áⁿ ndécǔ‑yu ɨɨⁿ núú néé chi ndècú‑yu ichi cuèhé ichi duha, te sáá nduu te cada iní‑ndó sǎ ñǎyiu‑áⁿ queé‑yu núú dìtó chi vá cúndècu‑gá‑yu ichi cuèhé ichi duha. Te dɨu‑ni ñáyiu‑áⁿ cúǔ‑yu ñáyiu ta xǐta nihnu duuⁿ cuáháⁿ, dico sáá nduu te vá cuǐta nihnu‑gá‑yu. Duha ní chídó tnùní ndíi núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Te dàvá‑áⁿ nǐ ngüíta Jèsús ní dánèhé‑gá ñáyiu, te ní xáhaⁿ‑gǎ xií‑yu: —Chí dándìxi túu iní sá ñà túú quìde váha‑ndo ndècu‑ndo te daña‑ndo nchàa ichi cuehé ichi duha, chi sa ní cuyatni nduu ndɨ̌hu ndaha ñàha Yá Ndiǒxí xii‑ndo —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Te Jèsús ñúhú‑gǎ ichi cuáháⁿ‑gá tá yǎha‑gá yuhu làgúná Galìleá, te ní xiní‑gá úú tnàhá cue tée xǐdáquěe‑güedé ñunu‑güedé xɨtɨ́ ndute tnɨ̀ɨ‑güedé chácá, chi quɨtɨ tnàhí‑áⁿ cúú chìuⁿ‑güedé tnɨ́ɨ́‑güedě‑dɨ. Te ɨɨⁿ‑dé nání‑dě Xǐmú, àdi Pelú chi úú dɨ̀u‑dé, te ñaní‑dé cúú ɨ̀ngá tée ndɨhɨ‑dé te tée‑áⁿ nání‑dě Ndrǐxí. ");
INSERT INTO milNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí dáñá chìuⁿ quide‑ndo‑áⁿ te quixi‑ndo chìtnahá ñáhá‑ndó xìi‑í, te taxi‑í ɨngá núú chìuⁿ cada‑ndo chi quɨ́hɨ́ⁿ‑ndó dàcaháⁿ‑ndó ñǎyiu cuèndá tuha ñàhá‑yu xii‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Te òré‑ni‑áⁿ nǐ dáñá cuè tée‑áⁿ ñunu‑güedé, te ní tuha‑güedé Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Te ní xica tucu Jèsús cuáháⁿ‑gá luha‑gá, te ní xiní tucu‑gá úú‑gá tnàhá cue tée tnɨ̀ɨ chácá. Te ɨɨⁿ tée‑áⁿ nání‑dě Jàcobó, te ñaní‑dé cúú ɨ̀ngá tée ndɨhɨ‑dé te tée‑áⁿ nání‑dě Juàá, te ndɨ ndùú‑güedé cúú‑güedě déhe té Zebèdeú. Te xǐxínucóo‑güedé ndɨhɨ tǎtá‑güedě xɨtɨ́ bàrcú xǐnatɨ́cu‑güedé ñunu‑güedé, te Jèsús ní cana ñaha‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Te òré‑ni‑áⁿ nǐ dándǒo‑güedé bàrcú‑güedé, ndɨhɨ tǎtá‑güedě, te ní tuha ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Te Jèsús tá xìca ndodo‑gá nɨhìí distrìtú Galìleá cuáháⁿ tá dànehé‑gá ñáyiu tnúhu váha tnúhu sá sánú ìchi ñaha xií‑yu nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu. Te ndɨ tnahá ɨɨⁿ ɨɨⁿ ñuú sàá‑gá te ducaⁿ cuǎnguɨhu‑gá xɨtɨ́ veñúhu dànehé‑gá ñáyiu tnúhu‑áⁿ. Te ndɨ dɨ́ɨ́ⁿ ndɨ̀ dɨ́ɨ́ⁿ nǔú cuěhé tnàhá ɨɨⁿ ɨɨⁿ ñáyiu dico nchaa‑ní‑yu ta quìde tátna‑gá cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Te ndéé nchaa ñáyiu yɨ̀ndehu distritú Sìriá ní níhǐ‑yu tnúhu nchaa nàcuáa quìde Jesús. Te ní queé‑yu ñuú‑yu te ndècá‑yu nchaa ñáyiu tnàhá ndɨ dɨ́ɨ́ⁿ nǔú cuěhé cuǎháⁿ núú ndécú Jèsús. Te cuěi ñáyiu xǐyɨ̀hɨ́, ndɨhɨ ñáyiu ñá túú‑gǎ càndá nihnu, ndɨhɨ ñáyiu yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha ndècá‑yu cuáháⁿ núú‑gǎ, te nchaá‑yu ní quide tátna ñaha‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Te ío vài ñáyiu ní chinchícúⁿ ñáhá xìi Jesús, chi ní chinchícúⁿ ñáhá ñǎyiu distrìtú Galìleá, ndɨhɨ ñáyiu nchaa ñuú xǐndáa Dècápolís, ndɨhɨ ñáyiu ñuú Jerusàlén, ndɨhɨ cue ñáyiu nchaa ñuú yɨ́ndèhu distritú Jùdeá, ndɨhɨ ñáyiu xǐndecu yatni yúte Jòrdán ndàa xio quene nchícanchii. ");
INSERT INTO milNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Te sátá nǐ xiní Jèsús sá cuěhé víhí ñǎyiu nchìcúⁿ ñáhá xìi‑gá, te ní xica‑gá cuásaá‑gá ɨɨⁿ núú tɨ̀ndúú te xíáⁿ nǐ ngóo‑gá, te cue tée xìca cuu ndɨhɨ‑gá ní nadúcúⁿ ndèé ñáhá‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Te ní ngüíta‑gá dánèhé ñáhá‑gǎ xii‑güedé ndɨhɨ cue ñáyiu‑áⁿ, te xǎhaⁿ‑gǎ: ");
INSERT INTO milNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Váha táhú nchaa ñáyiu cùtnuní iní‑xi sá ǐo‑gá cúmǎnǐ‑yu cudɨ̀ú‑yu núú Yǎ Ndiǒxí, chi ñáyiu‑áⁿ nduu táhǔ‑yu ndɨ́hu ndaha ñàha‑gá xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Váha táhú nchaa ñáyiu ndàhyú sá ndɨ̀hú iní‑yu, chi Yá Ndiǒxí cuáñaha‑gǎ tnúhu ndee ìní cundecu ndɨhɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Váha táhú nchaa ñáyiu ndàhú iní‑xi, chi ñáyiu‑áⁿ nduu táhǔ‑yu cundecú‑yu ɨɨⁿ xichi núú cuǎñaha Yǎ Ndiǒxí xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Váha táhú nchaa ñáyiu ío cuìní cada nchaa nàcuáa càháⁿ Yǎ Ndiǒxí, chi ñáyiu‑áⁿ ǐo nduu vétú iní‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Váha táhú nchaa ñáyiu cùndahú iní tnàha ñáyiu‑xi, chi ñáyiu‑áⁿ dɨu‑ni ducaⁿ càda ñaha Yá Ndiǒxí xií‑yu cundàhú iní ñáhá‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Váha táhú nchaa ñáyiu ní nduu ndoo ní nduu nine iní‑xi, chi cue ñáyiu‑áⁿ nduu táhǔ‑yu cundecú‑yu ndɨhɨ Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Váha táhú nchaa ñáyiu càháⁿ dóho tnàha ñáyiu‑xi nàcuáa cundecu ndɨhɨ váha tnàhá‑yu, chi cùtnuní sá ñǎyiu‑áⁿ cuú‑yu déhe Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Váha táhú nchaa ñáyiu ío ndòho ndecu ñuyíú‑a sá cuèndá sá quídě‑yu nàcuáa càháⁿ Yǎ Ndiǒxí, chi ñáyiu‑áⁿ nduu táhǔ‑yu ndɨ́hu ndaha ñàha‑gá xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Te cùu‑ndo ñáyiu ío váha táhú‑xi te núu na cǔcuèhé ñáhá ñǎyiu, àdi cada úhú ñáhǎ‑yu xii‑ndo, àdi dacaa dɨ́quɨ́ ñáhǎ‑yu nándɨ cuéchi neñùú xii‑ndo sǎ cuèndá‑í. ");
INSERT INTO milNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Te òré ducaⁿ na càda ñahá‑yu xii‑ndo te cudɨ́ɨ́ víhí‑ní ìní‑ndó cùndecu‑ndo, chi ío váha càa sá ndécú àndɨu nduu táhú‑ndó cùndecu ndɨhɨ‑ndo nduu na saá‑ndó yàcáⁿ cundecu‑ndo, chi dɨu‑ni ducaⁿ nǐ xóo cada ñaha cuè ñaní tnáhǎ‑yu xii cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ní xíndecu ndéé sanaha. ");
INSERT INTO milNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Te nchòhó cada iní‑ndó sǎ cúú‑ndó dàtná ñɨ́ɨ́ cuèndá ñuyíú‑a. Te ñɨ́ɨ́ chi nàndɨ́hɨ‑xi dico núu na ndùu víxiⁿ‑xi, te ñá túú‑gǎ nándɨ̌hɨ‑xi chi dǎngoyo‑ná‑ó, te yǎha ñáyiu xěnihnú‑yu. Te ducaⁿ sǎtnahá‑xi cùu nchohó chi cùu‑ndo datná ñɨ́ɨ́ vǎha te núu na càda váha‑ndo, te núu vá cádá vǎha‑ndo te quee tɨ́hú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Te nchòhó cada iní‑ndó sǎ cúú‑ndó dàtná ɨɨⁿ sá dáyèhé ndécú ñùyíú‑a, chi sànu ichi‑ndo ñáyiu ichi váha. Te nchòhó xìní‑ndó sǎ nǔu ɨɨⁿ ñuú cáá ɨ̀ɨⁿ núú tɨ̀ndúú te vá cúú càchí‑ó sǎ nguɨ̌vǎha‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Te ñá túú xìní‑ó ɨ̀ɨⁿ ñáyiu teñuhú‑yu ɨɨⁿ lìntérná te chiváha‑yu xɨtɨ́ ɨɨⁿ càjá, chi tàxi ndecú‑yu núú nǐnu cuèndá cutnùní núú nchàa ñáyiu ndècu vehe. ");
INSERT INTO milNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Te ducaⁿ càda nchohó cada váha‑ndo dàtná quídé ɨ̀ɨⁿ ñuhú dayèhe‑xi núú ñǎyiu, te ducaⁿ quìní ñáyiu nàcuáa quìde‑ndo ndecu‑ndo, te tnàhá‑yu cachí‑yu sá ǐo càhnu cuu Dútú Ndiǒxí Yaá cúú Tǎtá‑ndó ndècu andɨu chi quiní‑yu sá quídé vǎha‑ndo ndècu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Te vá cání ìní‑ndó sǎ yǔhú véxi‑í xocàni‑í tnúhu ní chídó tnùní ndíi Moìsés, te ni vǎ cání ìní‑ndó sǎ věxi‑í xocàni‑í tnúhu ní chídó tnùní cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, chi yúhú véxi‑í sá cádà‑í nàcuáa càháⁿ nchaa tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ tnǔhu ní chídó tnùní ndíi Moìsés ío ndáá càháⁿ‑xi, chi dacuɨtɨ́í cùu nchaa nacuáa càháⁿ‑xi. Te yáchí‑gá naa andɨu ndɨ̀hɨ ñuyíú dàcúúxí sǎ quěe cáva ɨɨⁿ tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Núu xíǎⁿ nchaa ñáyiu na càchí sá dává tnǔhu ní chídó tnùní ndíi Moìsés ñá túú xìni ñuhu‑xi chi ñá túú cùnuu‑xi, te ñáyiu‑áⁿ dɨu‑ni ducaⁿ dànehé‑yu nchaa dava‑gá tnàha ñáyiú‑yu, te sá dúcáⁿ quìdé‑yu te vá cúnùu vihí‑yu núú ndécú Yǎ Ndiǒxí táxí tnùní‑gá, chi cuú‑yu dàtná ɨɨⁿ ñáyiu nchìcúⁿ cuìí‑nǎ. Dico nchaa ñáyiu nchìcúⁿ nihnu quìde nchaa nacuáa càháⁿ nchaa tnúhu‑áⁿ, te dɨu‑ni ducaⁿ dànehé‑yu nchaa dava‑gá tnàha ñáyiú‑yu, te ñáyiu‑áⁿ ǐo cunùú‑yu núú ndécú Yǎ Ndiǒxí táxí tnùní‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Te na càchí tnúhu‑í xii‑ndo sǎ ǐo xìni ñuhu‑xi cada‑ndo nchaa nacuáa càháⁿ Yǎ Ndiǒxí, te vá cádá‑ndó dàtná xǐquide cue tée dànehé ñáhá xìi ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ dàtná xǐquide cue tée cùu fariséú, chi núu na càda‑ndo datná xǐquide cue tée‑áⁿ ñá, te vá ndúú tǎhú‑ndó ndɨ̌hu ndaha ñàha Yá Ndiǒxí xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Te nchòhó sa xìní‑ndó sǎ ncháá ñǎyiu ní cuu ñaní tnáhá‑ndó nǐ xíndecu ndéé sanaha nǐ níhǐ‑yu tnúhu sá vǎ cúú càhní‑yu tnàha ñáyiú‑yu, chi núu ducaⁿ na càdá‑yu te nacháhu‑yu cuéchi‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Dico vitna na càchí tnúhu‑í xii‑ndo sǎ nǔu ndědani càa‑ndo na cudééⁿ‑ndó nǔú tnàha ñáyiu‑ndo, te nacháhu‑ndo sǎ dúcáⁿ quìde‑ndo, àdi núu na cǔcuèhé‑ndǒ‑yu te núú chítú nǔú tàcá cundáá cuéchi‑ndo te núu ducaⁿ na càda‑ndo, àdi núu nà cúu‑ndo tnàha ñáyiu‑ndo ɨ̀ɨⁿ tnúhu vée vìhi, te cucuéchi vìhi xii‑ndo chi quɨ́hɨ́ⁿ‑ndó nǔú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Te xíǎⁿ nǔu nchòhó òré ndécú ndɨ̀hɨ‑ndo ɨɨⁿ sá cuìní‑ndó cuǎha‑ndo Yǎ Ndiǒxí nduu táhú‑gǎ, te òré cuáháⁿ‑ndó cuǎñaha‑ndo xìi‑gá, te òré ní quexìo‑ndo núú dúcáⁿ cuǎñaha‑ndo xìi‑gá sá ndúú tǎhú‑gǎ, te ní ndacu iní‑ndó sǎ ndécú ñǎyiu ñá túú cùu váha iní ñáhá xìi‑ndo cuendá ɨɨⁿ sá nǐ cumání nǔú tnáhá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Te dàndóo‑ndo sǎ dúcáⁿ nèhe‑ndo cuáháⁿ nduu táhú Yǎ Ndiǒxí, te díhna‑gá quɨ́hɨ́ⁿ‑ndó nàcaháⁿ cáhnú ìní tnáhá‑ndó ndɨ̀hɨ ñáyiu ñá túú cùu váha iní ñáhá xìi‑ndo‑áⁿ, te dǎtnùní ducaⁿ te quɨ́hɨ́ⁿ‑ndó cuǎha‑ndo Yǎ Ndiǒxí sá ndúú tǎhú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Te núu ìó ɨɨⁿ‑ndo nǐ sáháⁿ ñáyiu núú těe cùchiuⁿ ní sacáⁿ cuéchi‑yu cuèndá‑ndó cuèndá ɨɨⁿ sá nǐ quide‑ndo, te òré ní naníhí tnáhá‑ndó ndɨ̀hɨ́‑yu cuáháⁿ‑ndó nǔú těe cùchiuⁿ‑áⁿ, te nacáháⁿ cáhnú ìní tnáhá‑ndó ndɨ̀hɨ́‑yu cuèndá sá vǎ cuǎha cuèndá ñáhá‑gǎ‑yu xii‑ndo nǔú tě cùchiuⁿ, chi núu ducaⁿ na càdá‑yu te tée cùchiuⁿ‑áⁿ cuǎha cuèndá ñáhá‑dě xii‑ndo nǔú cuè tée cùu poleciá, te cue tée‑áⁿ chihi ñaha‑güedě vecaá xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ vǎ cǎcu‑ndo te núu na ngàva‑ndo vecaá ndéé nacháhu‑ndo nchàa sá tàú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Te nchòhó sa xìní‑ndó nàcuáa ndùu tnúhu ní cáháⁿ cue tée ní xíndecu ndéé sanaha, te duha ní cachí‑güedé: “Nchaa cue tée vá cúú cǎháⁿ ndɨhɨ‑güedé ñadɨ̀hɨ́ te núu ñá dɨ́ú ñàdɨhɨ́‑güedé cúǔ‑yu, te dɨu‑ni ducaⁿ tùcu nchaa cue ñáyiu dɨ̀hɨ́ vá cúú cǎháⁿ ndɨhɨ́‑yu tée te núu ñá dɨ́ú yɨ̀ɨ́‑yu cùu‑güedé”, duha ní cachi‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Dico yúhú càchí tnúhu‑í xii‑ndo sǎ nděda‑ni càa cue tée na cùndehe ɨɨⁿ ñadɨhɨ́ te núu na càni iní‑güedé cundecu dɨ́ɨ́ ìní‑güedé ndɨhɨ́‑yu te cada iní‑ndó sǎ dàtná sá sà ní cáháⁿ ndɨhɨ ñaha‑güedě xií‑yu sá dúcáⁿ nǐ sani iní‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Te núu ɨɨⁿ xio tɨnùu‑ndo quide‑xi quide‑ndo nándɨ sá cuèhé sá dúhá te tava‑ndo, chi váha‑gá sá ná cuǐta te ñá dɨ́ú nɨ̀hií nɨ́ ndúú yɨ̀quɨ cuñú‑ndó quɨ̌hɨ́ⁿ‑xi núú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te núu ɨɨⁿ xio ndaha‑ndo quìde‑xi quide‑ndo nándɨ sá cuèhé sá dúhá te quehndé‑ndó, chi váha‑gá sá ná cuǐta ɨɨⁿ xio ndaha‑ndo te ñá dɨ́ú sǎ nɨ̀hií nɨ́ ndúú yɨ̀quɨ cuñú‑ndó quɨ̌hɨ́ⁿ‑xi núú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Te nchòhó sa nàha tucu‑ndo nacuáa ní cáháⁿ tucu cue tée ní xíndecu ndéé sanaha, te duha ní cachí‑güedé: “Te núu ɨɨⁿ tée na dàña tnaha‑dé ndɨhɨ ñadɨ̀hɨ́‑dé, te xìni ñuhu‑xi cadúha‑dé ɨɨⁿ tutú cuáñaha‑dě núú càháⁿ‑xi sá nǐ dáñá ñàha‑dé”, duha ní cachí‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dico yúhú càchí tnúhu‑í xii‑ndo sǎ cúú dàña ɨɨⁿ tée ñadɨ̀hɨ́‑dé, te núu cùtnuní ndáá iní‑dé sá càháⁿ ndɨhɨ‑aⁿ ɨngá tée. Dico núu ñá túú dùcaⁿ quide‑aⁿ te ñá túú ndùu váha‑xi daña ñàha‑dé. Te núu ñá túú dùcaⁿ quide ñadɨhɨ́‑dé, te cada iní‑ó sǎ méé‑dě ní sanu ichi ñaha‑dě xii‑aⁿ cáháⁿ ndɨhɨ‑aⁿ ɨngá tée te núu na dàña ñaha‑dé. Te tée na nàqueheⁿ ñaha xii ñaha ní dáñá ñàha yɨɨ‑xi‑áⁿ, te dɨu‑ni ñá túú ní quìde váha‑dé sá dúcáⁿ nǐ naqueheⁿ‑dé ñaha‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Te sa nàha tucu‑ndo nacuáa ní cáháⁿ tucu cue tée ní xíndecu ndéé sanaha, chi cue tée‑áⁿ nǐ cachí‑güedé: “Te núu càcunehe‑ndo Yá Ndiǒxí núú tnàha ñáyiu‑ndo nàcuáa cutnùní iní‑yu sá ndàá cada‑ndo ɨ̀ɨⁿ sá sání ìní‑ndó càda‑ndo, te cada‑ndo”, duha ní cáháⁿ dóho tnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Dico yúhú càchí tnúhu‑í xii‑ndo sǎ ñà túú nǎ cacunehe‑ndo sǎ ndàá cada‑ndo ɨ̀ɨⁿ sá sání ìní‑ndó càda‑ndo. Te ni vǎ cácú nèhe‑ndo andɨu chi yàcáⁿ cúú‑xí nǔú núcǒo Yá Ndiǒxí táxí tnùní‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Te ni vǎ cácú nèhe‑ndo ñuyíú‑a, chi tnàhá ñuyíú‑a ndècu‑gá, te ni vǎ cácú nèhe‑ndo ñuú Jerusàlén chi ñuú‑áⁿ cúú cuèndá‑gá, te dɨu‑gá cúú‑gǎ Yaá ío cùnuu. ");
INSERT INTO milNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Te ni vǎ cácú nèhe‑ndo dɨ́quɨ́‑ndó chi nàha‑ndo sá nì ɨɨⁿ idi dɨ́quɨ́‑ndó ñǎ ndácú‑ndó ndàda cuixíⁿ‑ndó àdi ndada tnuu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Te váha‑gá sá nǔu ɨɨⁿ sá sání ìní‑ndó càda‑ndo, te cachí‑ni‑ndo: “Cuu cada‑ndɨ́, àdi vá cúú càda‑ndɨ́”, cachí‑ni‑ndo. Chi nchaa dava‑gá sá chídó‑ndó càháⁿ‑ndó òré ducaⁿ sàni iní‑ndó càda‑ndo ɨɨⁿ sá cádá‑ndó cùu‑xi sá dácàhu iní ñáhá yùcu ñávǎha. ");
INSERT INTO milNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Te sa nàha tucu‑ndo nacuáa ní cáháⁿ tucu cue tée ní xíndecu ndéé sanaha, chi cue tée‑áⁿ nǐ cachí‑güedé: “Ñáyiu na càda ñaha tnaha ñáyiu‑xi ɨɨⁿ sá ñà túú vǎha, te nanchòcáva‑yu nachinaá‑yu sá nǐ quide ñaha tnàha ñáyiú‑yu”, duha ní cachí‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Dico yúhú càchí tnúhu‑í xii‑ndo sǎ ñà túú nǎ cada‑ndo nchàa cue ñáyiu cuihna ìní‑xi te núu quìde ñahá‑yu ɨɨⁿ sá ñà túú vǎha xii‑ndo. Te núu ní canìhá‑yu ɨɨⁿ xito te cuìní tucú‑yu canìhá‑yu ɨngá xito te daña‑ndo na cànihá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Àdi ní sacáⁿ cuéchi‑yu núú cuè tée cùchiuⁿ cuendá‑ndó, te cuìní‑yu quendeé‑yu dúhnú‑ndó te daña‑ndo na cànehé‑yu quɨ́hɨ́ⁿ, te tnàhá‑ni dóó ndíxí ndòdo‑ndo daña‑ndo na canehé‑yu quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Te núu quìde yicá‑yu caca‑ndo dàtná úú kìlómetrú cuido‑ndo ndàchiúⁿ‑yu ña, te chido‑ndo ǔú‑gá tucu kìlómetrú cuido‑ndo ndàchiúⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Te núu ìó ɨɨⁿ sá xìcáⁿ‑yu núú‑ndó te cuáñaha‑ndo, àdi ió ɨɨⁿ sá sánùú‑yu núú‑ndó te cuáñaha nùu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Te sa nàha tucu‑ndo nacuáa ní cachí tucu cue tée ní xíndecu ndéé sanaha, chi cue tée‑áⁿ nǐ cachí‑güedé: “Cuu iní‑ndó cuè ñáyiu ndècu ndɨhɨ váha‑ndo, te cuu úhú iní‑ndó cuè ñáyiu cùu úhú iní ñáhá xìi‑ndo”, duha ní cachí‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Dico yúhú càchí tnúhu‑í xii‑ndo sǎ cúú ìní‑ndó cuè ñáyiu cùu úhú iní ñáhá xìi‑ndo, te cáháⁿ váha‑ndo cuèndá cue ñáyiu càháⁿ úhú ñáhá xìi‑ndo, te cada‑ndo sǎ vǎha sá cúú‑xí cuè ñáyiu cùu úhú iní ñáhá xìi‑ndo, te cáháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí cuèndá cue ñáyiu xǐcuèhé ñáhá xìi‑ndo, ndɨhɨ cuèndá cue ñáyiu quìde úhú ñáhá xìi‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Te núu na càda‑ndo nchaa nacuáa càháⁿ‑í‑a, te ducaⁿ te cutnùní sá cúú‑ndó děhe Tǎtá‑ndó Dǔtú Ndiǒxí Yaá ndécú àndɨu. Te dɨu‑gá cúú‑gǎ Yaá quídé quène nchícanchii, te dɨu‑ni‑gá cúú‑gǎ Yaá dácùuⁿ dáú ñuyíú‑a, te ducaⁿ quìde‑gá cuèndá cuu‑xi sá vǎha sá cúú‑xí cuè ñáyiu quìde váha, ndɨhɨ sá cúú‑xí cuè ñáyiu ñá túú quìde váha. ");
INSERT INTO milNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Te núu nchòhó ná cúú ìní‑ndó mèe‑ni ñáyiu na cùu iní ñáhá xìi‑ndo, te vá càchí‑ndó sǎ Yǎ Ndiǒxí taxi‑gá sá ndúú tǎhú‑ndó sǎ dúcáⁿ quìde‑ndo, chi cuěi cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi cue ñáyiu cuèndá impuèstú ducaⁿ xǐquide‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te núu mee‑ni ñǎyiu ndècu ndɨhɨ váha‑ndo ǐo váha cáháⁿ ndɨhɨ‑ndǒ‑yu, te vá càchí‑ndó sǎ ǐo váha quìde‑ndo sá dúcáⁿ quìde‑ndo, chi cuěi ndéé nchaa ñáyiu ñá túú xìní dana cuèndá Yǎ Ndiǒxí ducaⁿ xǐquidé‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Te duha ndùu tnúhu càháⁿ‑í cuèndá sá nchòhó cada ndáá‑ndó cùndecu‑ndo datná quídé ndǎá méé Tǎtá‑ndó Dǔtú Ndiǒxí Yaá ndécú àndɨu —duha ní dánèhé ñáhá Jèsús xii cue tée xìca cuu ndɨhɨ‑gá ndɨhɨ nchaa ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Te Jèsús ndécú‑ní‑gǎ dánèhé‑gá cue tée xìca cuu ndɨhɨ‑gá ndɨhɨ nchaa ñáyiu, te xǎhaⁿ‑gǎ: —Te òré quídé‑ndó sǎ vǎha te vá cádá‑ndó nǔú ñǎyiu cuèndá‑ni sá cuìní‑ndó cǎháⁿ váha‑yu cuèndá‑ndó, chi núu núú ñǎyiu ducaⁿ na càda‑ndo te Dútú Ndiǒxí Yaá cúú Tǎtá‑ndó vǎ táxí‑gǎ sá ndúú tǎhú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Te xíǎⁿ nǔu nchòhó òré chíndèe‑ndo ñáyiu ndàhú, te vá cǔñaha‑ndo xìi cue ñáyiu sá chíndèe‑ndo cue ñáyiu ndàhú‑áⁿ dàtná xǐquide cue ñáyiu dàndahú méé‑xí sǎ quídé ndǎá te ñá ndàá sá quídé ndǎá‑yu, chi ñáyiu‑áⁿ ducaⁿ xǐquidé‑yu òré sàháⁿ‑yu veñúhu, chi dàtecú tnúhu‑yu nchaa ñáyiu òré ducaⁿ chìndeé‑yu ñáyiu ndàhú. Te dɨu‑ni ducaⁿ quìdé‑yu xǎhǎⁿ‑yu xii cue ñáyiu sá chíndèé‑yu cue ñáyiu ndàhú‑áⁿ nchaa núú xícá cùú‑yu, te ducaⁿ xǐquidé‑yu cuèndá cuìní‑yu cáháⁿ váha ñáyiu cuèndá‑yu. Te yúhú na càchí tnúhu ndáá‑í xii‑ndo sǎ ñà túú nǎ nduu táhú ñǎyiu‑áⁿ nǔú Yǎ Ndiǒxí sá dúcáⁿ quìdé‑yu chi mee‑ni nǔú tnàha ñáyiú‑yu cùdɨú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Te nchòhó òré chíndèe‑ndo ñáyiu ndàhú, te cuěi ñáyiu ío‑gá váha ndècu ndɨhɨ‑ndo dico vá cǔñaha‑ndo sǎ dúcáⁿ chìndee‑ndo cue ñáyiu ndàhú‑áⁿ, te ni cuè dava‑gá ñáyiu vá cǔñaha‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chi váha‑gá sá ìní méé‑ní‑ndó ná cùhuⁿ sá dúcáⁿ chìndee‑ndo cue ñáyiu ndàhú‑áⁿ. Te núu ducaⁿ na càda‑ndo ña, te Dútú Ndiǒxí Yaá cúú Tǎtá‑ndó tàxi‑gá sá ndúú tǎhú‑ndó chi dɨu‑ni mee‑gǎ ndéhé‑gǎ nàcuáa quìde‑ndo ndecu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Te nchòhó òré càháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí, te vá cádá‑ndó dàtná xǐquide cue ñáyiu dàndahú méé‑xí càchí sá quídé ndǎá te ñá ndàá sá quídé ndǎá‑yu, chi ñáyiu‑áⁿ tnàhá iní‑yu cunutnɨ́ɨ‑yu càháⁿ ndɨhɨ́‑yu Yá Ndiǒxí òré yɨ́hɨ̌‑yu veñúhu. Te dɨu‑ni ducaⁿ xǐquidé‑yu nchaa núú xícá cùú‑yu, te ducaⁿ quìdé‑yu cuèndá sá cuìní‑yu quiní ñáyiu nàcuáa xǐquidé‑yu. Te na càchí tnúhu ndáá‑í xii‑ndo sǎ ñà túú nǎ nduu táhú ñǎyiu‑áⁿ nǔú Yǎ Ndiǒxí sá dúcáⁿ quìdé‑yu chi mee‑ni nǔú tnàha ñáyiú‑yu cùdɨú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Te nchòhó òré cuìní‑ndó cǎháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí, te ndɨ́hu ndedɨ́ nihnu‑ndo xɨ̀tɨ́ vehe‑ndo, chi dɨu‑gá cúú Tǎtá‑ndó te ndècu ndɨhɨ ñaha‑gá xii‑ndo, te dɨu‑ni mee‑gǎ ndéhé ñàha‑gá xii‑ndo nàcuáa quìde‑ndo, te núu ducaⁿ na càda‑ndo te taxi‑gá sá ndúú tǎhú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Te òré càháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí te vá sǔúní cuèndá‑ni dacàá‑ndó tnǔhu cáháⁿ ndɨhɨ‑ndo‑gǎ dàtná xǐquide cue ñáyiu ñá túú xìní tnúhu‑gá, chi ñáyiu‑áⁿ sání ìní‑yu sá tédǒho ñaha vìhi‑gá Yǎ Ndiǒxí xií‑yu sá dúcáⁿ sǔúní dàcaá‑yu tnúhu càháⁿ ndɨhɨ ñàhá‑yu xii‑gá dico ñáhá. ");
INSERT INTO milNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dico nchòhó, vá cádá‑ndó dàtná xǐquide cue ñáyiu‑áⁿ, chi mee Tǎtá‑ndó Dǔtú Ndiǒxí sa nàha‑gá ná cúú nchàa sá xíní ñùhu‑ndo cuéi òré vátá càcáⁿ‑gá‑ndó nǔú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Te duha cáháⁿ‑ndó òré càháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí: Yòhó Tǎtá‑ndɨ̌ Dútú Ndiǒxí Yaá ndécú àndɨu, nchaa ñáyiu na càháⁿ‑yu sá cúú‑n Yàá ío yɨñùhu. ");
INSERT INTO milNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Te xìcáⁿ táhú‑ndɨ̌ núú‑n sǎ ná sàá nduu ndɨ́hu ndàhá‑n‑yu. Te cada‑n dàtná càchí iní‑n ñùyíú‑a dàtná quídé‑n àndɨu. ");
INSERT INTO milNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Te xìcáⁿ táhú‑ndɨ̌ núú‑n sǎ táxí‑n sǎ cóhó‑ndɨ̌ sá cáxí‑ndɨ̌ ɨɨⁿ nduu ɨɨⁿ nduu. ");
INSERT INTO milNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Te cada càhnu iní‑n nchàa yícá cuěchi‑ndɨ́, chi tnàhá nchúhú quídé càhnu iní‑ndɨ́ nchaa sá quídé ñàha tnaha ñáyiu‑ndɨ́. ");
INSERT INTO milNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Te vá dáñá‑n dàcaháⁿ ñáhá yùcu ñávǎha xii‑ndɨ́ cada‑ndɨ́ sá ñà túú vǎha, chi coto ñaha‑n xìi‑ndɨ́ cuèndá sá vǎ dúcáⁿ càda ñaha‑xi. Te dɨu‑n cùu‑n Yaá ío cùnuu nchaa nduu nchaa quɨ́ú, te ío càhnu cuu‑n, te dɨu‑ni‑n quɨ̀ndaha ñaha‑n xii‑ndɨ́ nɨ caa nɨ quɨ́hɨ́ⁿ. Te ducaⁿ na cùnduu. Duha dànehé ñáhà‑í xii‑ndo cǎháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Te núu nchòhó quídé càhnu iní‑ndó nchàa sá quídé ñàha tnaha ñáyiu‑ndo, te ducaⁿ te Tǎtá‑ndó Dǔtú Ndiǒxí Yaá ndécú àndɨu cada cahnu iní‑gá nchaa sá ñà túú vǎha quìde‑ndo tucu. ");
INSERT INTO milNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Dico núu nchòhó vá cádá càhnu iní‑ndó nchàa sá quídé ñàha tnaha ñáyiu‑ndo ña, te ni Dǔtú Ndiǒxí Yaá cúú Tǎtá‑ndó vǎ cádá càhnu iní‑gá nchaa sá quídé‑ndó tùcu. ");
INSERT INTO milNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Te nchòhó, nduu ñà túú tnàhí ná xéxí‑ndó càháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí, te vá cúndɨ̀yɨ́‑ndó dàtná xǐquide nchaa ñáyiu dàndahú méé‑xí càchí sá quídé ndǎá te ñá ndàá sá quídé ndǎá‑yu, chi ñáyiu‑áⁿ ducaⁿ xǐquidé‑yu cuèndá sá cuìní‑yu cutnùní iní ñáyiu sá ñà túú tnàhí ná xéxǐ‑yu càháⁿ ndɨhɨ́‑yu Yá Ndiǒxí. Te yúhú càchí tnúhu‑í xii‑ndo sǎ sà dúcáⁿ quìdé‑yu te ñá túú nǎ chindee ñàha‑xi xií‑yu cuèndá níhǐ‑yu ɨɨⁿ sá ndúú tǎhǔ‑yu núú Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Dico nchòhó, nduu dùcaⁿ quide‑ndo ñá túú tnàhí ná xéxí‑ndó càháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí, te váha váha naquete‑ndo nǔú‑ndó, te váha váha chihi‑ndo cǔcá ");
INSERT INTO milNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","cuèndá sá vǎ cútnùní iní ñáyiu sá ñà túú nǎ xéxí‑ndó ndùu ducaⁿ caháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí. Te Dútú Ndiǒxí Yaá cúú Tǎtá‑ndó ndècu ndɨhɨ‑ndo dɨu‑ni mee‑gǎ ndéhé‑gǎ nàcuáa quìde‑ndo ndecu‑ndo, te dɨu‑gá taxi‑gá sá ndúú tǎhú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Te vá cání ìní‑ndó cùu‑ndo ñáyiu cuica nǎndɨ sá cúndècu ndɨhɨ‑ndo ñuyíú‑a chi vá cúdǐi‑xi, chi dava quee tɨ́quidi, te dava caxi cudi ñùhu, àdi quɨ́hu ñadúhú vehe‑ndo te duhu‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Te váha‑gá chí ndúcú nàcuáa cada‑ndo cuèndá ducaⁿ ngǔndecu sá ndúú tǎhú‑ndó àndɨu, te xíǎⁿ cudíi‑xi cundecu ndɨhɨ‑ndo nɨ̀ caa nɨ quɨ́hɨ́ⁿ, chi yàcáⁿ vá quéé‑gǎ tɨ́quidi, te ni vǎ cáxí‑gǎ cudi ñùhu, te ni vǎ quìní‑gá‑ndó ñàdúhú duhu‑güedě ndachìuⁿ‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Te núu cùu‑ndo ñáyiu cuica ndècu ñuyíú‑a, te dɨu‑ni nchaa sá ndécú ndɨ̀hɨ‑ndo ñuyíú‑a ñùhu iní‑ndó. Àdi cuu‑ndo ñáyiu quìde nacuáa ngúndecu sá ndúú tǎhú‑ndó àndɨu, te dɨu‑ni sá ndúú tǎhú‑ndó ndècu andɨu‑áⁿ ñúhú ìní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Te cada iní‑ndó sǎ nǔú‑ndó cùu‑xi datná ɨɨⁿ ñuhú. Te núu núú‑ndó càváha te cùtnuní iní‑ndó nǎ cúú sǎ ndécú nǔú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Dico núu cùhú núú‑ndó ñà túú cùtnuní cundehe‑ndo ña, te ñá túú cùtnuní iní‑ndó nǎ cúú sǎ ndécú nǔú‑ndó. Te sá dúcáⁿ cùhú núú‑ndó te cada iní‑ndó sǎ ndécú‑ndó dàtná ɨɨⁿ núú néé. Te duha ndùu tnúhu càháⁿ‑í chi núu sàni váha iní‑ndó cuèndá Yǎ Ndiǒxí ñá, te cùu vii cuu váha iní‑ndó ndècu‑ndo. Áⁿ te núu ñá túú sàni váha iní‑ndó cuèndá‑gá ñá, te ñá túú tnàhí cùu váha iní‑ndó ndècu‑ndo. Te sá dúcáⁿ ñà túú sàni váha iní‑ndó cuèndá‑gá te cada iní‑ndó sǎ ndécú‑ndó dàtná ɨɨⁿ núú néé. ");
INSERT INTO milNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Te ni ɨ̀ɨⁿ tée xìnu cuechi vá ndácú‑dě cunu cuechi‑dě núú ùú pàtróóⁿ, chi tée‑áⁿ cuu váha iní‑dé núú ɨɨⁿ pàtróóⁿ‑dě te tnɨɨ‑dé nchaa tnúhu càháⁿ pàtróóⁿ tée cùu váha iní‑dé núú‑xi‑áⁿ. Te núú ɨ̀ngá tucu pàtróóⁿ‑dě vá cúú vǎha iní‑dé, te ni vǎ tnɨ́ɨ́‑dě tnúhu càháⁿ ɨngá tée‑áⁿ. Te ducaⁿ sǎtnahá‑xi cùu nchohó chi vá ndácú‑ndó cùnu cuechi‑ndo núú Yǎ Ndiǒxí te cuhuⁿ iní‑ndó nchàa sá ìó ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Te na càchí tnúhu‑í xii‑ndo sǎ vǎ ǐo cani iní‑ndó nǔu nása níhí‑ndó sǎ cóhó sǎ cáxí‑ndó, te ni vǎ ǐo cani iní‑ndó nǔu nása níhí‑ndó dǒó cuihnu‑ndo, chi cùnuu‑gá méé‑ndó dàcúúxí sǎ nchító‑ndó, te ducaⁿ cùnuu‑gá yɨquɨ cùñú‑ndó dàcúúxí dǒó sácuǐhnu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Te chí cádá cuèndá sá ncháá quɨ̀tɨ ndava ñá túú tnàhí ná xítú‑güèdɨ, te ni ñà túú ndèé cuáháⁿ‑güedɨ nàtahu‑güedɨ, te ni ñà túú nǎ nátàxúha‑güedɨ, te ni ñà túú ndèé cáá yàcá‑güedɨ, chi mee Tǎtá‑ó Dǔtú Ndiǒxí Yaá ndécú àndɨu xito ñaha‑gá xii‑güedɨ nìhí‑güedɨ sá xéxí‑güèdɨ. Te núu cue quɨtɨ‑áⁿ ducaⁿ xìto ñaha‑gá xii‑güedɨ, ¡te uuⁿ‑gá xító ñàha‑gá xii nchòhó, chi nchòhó ío‑gá cúnùu‑ndo dacúúxí cuè quɨtɨ‑áⁿ! ");
INSERT INTO milNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Te cuěi nándɨ sá sání vìhi iní‑ndó ndècu‑ndo, dico ñá ndácú‑ndó càda‑ndo nacuáa cuehnu‑ndo cuědìcó ɨɨⁿ yɨquɨ‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Te vá ǐo cani iní‑ndó nǔu nása níhí‑ndó dǒó cuihnu‑ndo. Te chí cádá cuèndá nàcuáa sàhnu nchaa itá ìó yucu, chi nchaa itá‑áⁿ ñà túú quìde chiuⁿ‑xi, te ni ñà túú quèheⁿ‑xi idi. ");
INSERT INTO milNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Te na càchí tnúhu‑í xii‑ndo sǎ ndǐi Salòmón cuěi ío vii ní xínduu dóó nǐ xóo cuihnu ndíi, dico ñá túú nǔtnahá‑xi nàcuáa càa nchaa itá, chi ío‑gá vii càa nchaa itá. ");
INSERT INTO milNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Te nchaa itá ìó yucu tnaa‑ni cùdíi‑xi, te yìchí‑xi te sàhmi ñáyiu. Te cuěi ducaⁿ dico mee Yǎ Ndiǒxí quídé‑gǎ ío vii sàcúnduu‑xi. Te núu nchaa itá‑áⁿ ducaⁿ quìde‑gá xító‑gǎ sácǔnduu vii‑xi, te xíǎⁿ cútnùní sá ǐo‑gá coto ñaha‑gǎ xii‑ndo, dìcó‑ni sá ñà túú sàndáá váha iní‑ndó‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Te xíǎⁿ nǔu ñá túú xìni ñuhu vihi‑xi cani iní‑ndó nǔu nása níhí‑ndó sǎ cóhó sǎ cáxí‑ndó, àdi nása níhí‑ndó dǒó cuihnu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Chi nchaa ñáyiu ñá túú xìní nàcuáa càháⁿ tnúhu Yá Ndiǒxí mee‑ni nchàa xíǎⁿ ñúhú ìní‑yu. Dico nchòhó chi mee Tǎtá‑ndó Dǔtú Ndiǒxí sa nàha‑gá ná cúú sǎ xíní ñùhu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Te xíǎⁿ nǔu ío xìni ñuhu‑xi sá cúhúⁿ ìní‑ndó sǎ Yǎ Ndiǒxí yɨ́ndàha ñaha‑gá xii‑ndo, te ducaⁿ càda‑ndo nchaa nacuáa cuìní‑gá, te ducaⁿ te taxi‑gá nchaa sá xíní ñùhu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Núu xíǎⁿ vá ǐo cani iní‑ndó nǎsa cundecu‑ndo ndùu tneé, chi cani iní‑ndó nàcuáa cada‑ndo cùndecu‑ndo vitna, chi nduu tněé‑áⁿ te òré‑nǎ te cutnùní nǔu nása cada‑ndo cùndecu‑ndo. Chi nchòhó sa nàha‑ndo sá ǐo tɨtnɨ́ núú sǎ quídé‑xí ɨ̀ɨⁿ nduu ɨɨⁿ nduu —duha ní dánèhé ñáhá Jèsús xii cue tée xìca cuu ndɨhɨ‑gá ndɨhɨ nchaa ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Te Jèsús nděcuu‑ni‑gá dánèhé‑gá cue tée xìca cuu ndɨhɨ‑gá ndɨhɨ nchaa ñáyiu, te xǎhaⁿ‑gǎ: —Vá càháⁿ cuèhé‑ndó cuèndá tnàha ñáyiu‑ndo, te ducaⁿ te Yá Ndiǒxí ñá túú nǎ tnúhu cúñaha‑gǎ xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chi núu na càháⁿ cuèhé‑ndó cuèndá tnàha ñáyiu‑ndo, te Yá Ndiǒxí ìó ɨɨⁿ sá cádá ñàha‑gá xii‑ndo. Te núu nchòhó ná càháⁿ cuèhé víhí‑ndó cuèndá tnàha ñáyiu‑ndo te Yá Ndiǒxí ío‑gá dandòho ñaha‑gá xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Te ná cuèndá ndéhé‑ndó ɨ̀ɨⁿ sá ñà túú vǎha quìde tnaha ñáyiu‑ndo te mee‑ndo vìhi‑gá quídé‑ndó‑í? Te sá dúcáⁿ quìde‑ndo te cada iní‑ndó sǎ ndéhé‑ndó dàtná ɨɨⁿ mihi lǐhli ñùhu núú tnàha ñáyiu‑ndo te mee‑ndo ñùhu ɨɨⁿ mihi cahnu‑gá núú‑ndó te ñá túú quìde cuendá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Te núu na nàcanu ichi‑ndo tnaha ñáyiu‑ndo cuèndá sá ñà túú quìde váha‑yu ndècú‑yu, te mee‑ndo vìhi‑gá quídé‑ndó ñá, te cada iní‑ndó sǎ xǎhaⁿ‑ndo xìi tnaha ñáyiu‑ndo sǎ nátàva‑ndo mihi líhli ñùhu núǔ‑yu sá dúcáⁿ quìde‑ndo, te mihi càhnu ñuhu núú méé‑ndó ñà túú quìde cuendá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Te sá dúcáⁿ quìde‑ndo te ío dàndahú‑ndó mèe‑ndo sá quídé ndǎá‑ndó te ñá ndàá sá quídé ndǎá‑ndó, te xìni ñuhu‑xi díhna‑gá daña‑ndo nchàa sá ñà túú vǎha quìde‑ndo, te dǎtnùní ducaⁿ te cuu nacanu ichi‑ndo tnàha ñáyiu‑ndo cuèndá nchaa sá ñà túú vǎha quìdé‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Te nchaa ñáyiu ío sàá iní‑xi, te vá cádá yìca‑ndó‑yu cundedóho‑yu tnúhu Yá Ndiǒxí, chi núu na càda yica‑ndó‑yu te ngóo‑yu cuu úhú iní ñáhǎ‑yu xii‑ndo. Te ñáyiu‑áⁿ cúǔ‑yu dàtná iná chi quɨtɨ‑áⁿ nǔu na cuǎñaha‑o ɨ̀ɨⁿ sá cuǎñaha‑o, te núu ñá túú cùtnuní iní‑dɨ ná cúú xǐǎⁿ te tnɨɨ ñaha‑dɨ xìi‑o. Te cùu tucú‑yu dàtná cùchí chi quɨtɨ‑áⁿ nǔu na chùcu‑o núú‑dɨ yúú vǎha sá ǐo vii càa nani pérlá, te dìcó‑ni cùnu sáhá‑dɨ chi ñá túú cùtnuní iní‑dɨ sá cúú‑xí yǔú vǎha. ");
INSERT INTO milNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Te na càchí tnúhu‑í xii‑ndo sǎ cǎcáⁿ‑ndó nǔú Yǎ Ndiǒxí te núu ná cuìní‑ndó te taxi‑gá, te vá dáñá ndèé‑ndó cǎcáⁿ‑ndó nǔú‑gǎ nǔu ná cuìní‑ndó te ducaⁿ te níhí‑ndó. Te cada iní‑ndó sǎ nǐ quexìo‑ndo vehe ɨɨⁿ tnaha ñáyiu‑ndo te ní cáháⁿ‑ndó, te ñáyiu‑áⁿ nǐ tedóho ñàhá‑yu xii‑ndo te ní nacaáⁿ‑yu yuyèhe. Te ducaⁿ càda iní‑ndó chi Yá Ndiǒxí tedóho ñaha‑gǎ xii‑ndo, te taxi‑gá sá ná càcáⁿ‑ndó nǔú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chi nchaa ñáyiu ducaⁿ xǐquide, te Yá Ndiǒxí tédǒho ñaha‑gǎ xií‑yu te nìhí‑yu sá cuìní‑yu. Te dɨu‑ni ducaⁿ tùcu nchaa ñáyiu na càcáⁿ núú‑gǎ ɨɨⁿ sá cuìní‑yu, chi sǎñaha‑gǎ sá xìcáⁿ‑yu núú‑gǎ. Te dɨu‑ni ducaⁿ tùcu nchaa ñáyiu ñá túú dàña ndeé xìcáⁿ núú Yǎ Ndiǒxí sá cuìní‑yu chi nìhí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Te nchòhó cue tée cùu tátá, ñá túú cùndee iní‑ndó cuǎñaha‑ndo xìi cue déhe‑ndo ɨ̀ɨⁿ yúú caxi‑güexi òré xìcáⁿ‑güexi ɨɨⁿ pàá núú‑ndó càxi‑güexi. ");
INSERT INTO milNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Te ni ñà túú cùndee iní‑ndó cuǎñaha‑ndo ɨ̀ɨⁿ cóó caxi‑güexi òré xìcáⁿ‑güexi ɨɨⁿ chácá nǔú‑ndó càxi‑güexi. ");
INSERT INTO milNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Te nchòhó cuěi ndèé dau‑na sàá iní‑ndó dico sǎha‑ndo cuè déhe‑ndo sǎ vǎha xèxi‑güexi oré ná cúú sǎ xìcáⁿ‑güexi núú‑ndó càxi‑güexi. Te núu nchòhó ducaⁿ quìde‑ndo, ¡te uuⁿ‑gá ducaⁿ quìde Tátá‑ndó Dǔtú Ndiǒxí Yaá ndécú àndɨu, chi taxi‑gá sá vǎha sá cúú‑xí‑ndó te núu na càcáⁿ‑ndó nǔú‑gǎ! ");
INSERT INTO milNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Te nchaa sá vǎha cuìní‑ndó càda tnaha ñáyiu‑ndo, te cada‑ndo tnàhá‑ndó ndɨ̀hɨ́‑yu, chi ducaⁿ sànu ichi ñaha tnúhu ní chídó tnùní ndíi Moìsés, te dɨu‑ni ducaⁿ sànu ichi ñaha tucu nchaa tnúhu ní chídó tnùní cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha. ");
INSERT INTO milNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","’Te xìni ñuhu‑xi nducu‑ndo nacuáa cada‑ndo tnɨ̀ɨ‑ndo ichi Yá Ndiǒxí. Te ichi‑gá‑áⁿ cúú‑xí dàtná ɨɨⁿ ichi cuɨ̀ñɨ, àdi datná ɨɨⁿ yuyèhe cuɨñɨ. Te duha càháⁿ‑í chi ío úhú xínu iní‑ndó tnɨ̀ɨ‑ndo ichi Yá Ndiǒxí, te sacú‑ni nchòhó cue ñáyiu ndècu ñuyíú‑a tnɨɨ‑ndo ìchi‑gá. Te nchaa ñáyiu ndècu ichi cuehé ichi duha ta xǐta nihnú‑yu cuáháⁿ. Te ichi ndècú‑yu‑áⁿ cada iní‑ndó sǎ cúú‑xí ɨ̀ɨⁿ ichi cahnu ichi quehéⁿ, àdi ɨɨⁿ yuyehe quehéⁿ. Te duha càháⁿ‑í chi ío vài ñáyiu ndècú‑yu ichi‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Te càchí tnúhu‑í xii‑ndo sǎ ǐo quɨhɨ iní‑ndó cùndecu‑ndo cuendá sá vǎ dándàhú ñáhá cuè tée càchí sá càháⁿ tnúhu Yá Ndiǒxí te ñá ndàá sá càháⁿ‑güedé tnúhu‑gá. Chi cue tée‑áⁿ sànuu sá quídé‑güedě dàtná quídé mběé quɨtɨ ío váha iní‑xi, dico ñá ndàá chi ñá túú ñùhu váha iní‑güedé, chi quìde‑güedé dàtná quídé quɨ̀tɨ dééⁿ quɨtɨ nàni yɨ́hɨ́. ");
INSERT INTO milNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Te òré quexìo‑güedé núú ndécú‑ndó te cada cuèndá‑ndó nàcuáa quìde‑güedé cuèndá ducaⁿ cùtnuní iní‑ndó nǎ ñáyiu cùu‑güedé. Te nchòhó xìní‑ndó sǎ ñà túú cùuⁿ ndéhé yoho yàha stilé tnu ìñu, te ni ñà túú xìní‑ndó cùuⁿ ngúxí ɨɨⁿ tnu ìñu. ");
INSERT INTO milNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Te xìní tucu‑ndo sǎ ncháá yùtnu váha cùuⁿ sávìdí váha, te nchaa yutnu váha‑áⁿ ñà túú cùuⁿ sávìdí sá ñà túú vǎha. Te nchaa yutnu sá ñà túú vǎha ñá túú cùuⁿ sávìdí váha, chi mee‑ni sǎvìdí sá ñà túú vǎha cùuⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Te nchaa yutnu sá ñà túú cùuⁿ sávìdí váha xèhndé‑güedé, te cuánguee‑xi núú ñùhú càyú‑xi. Te ducaⁿ sǎtnahá‑xi yáha nchaa cue tée dàndahú ñáhá càchí sá càháⁿ tnúhu Yá Ndiǒxí te ñá ndàá sá càháⁿ‑güedé tnúhu‑gá, chi quɨ́hɨ́ⁿ‑güedé núú ñùhú núú càyú. ");
INSERT INTO milNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Te nchòhó cutnùní iní‑ndó nǎ ñáyiu cùu cue tée‑áⁿ cuèndá nchaa sá quídé‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Te na càchí tnúhu‑í xii‑ndo sǎ ǐo vài ñáyiu cachí‑yu sá yǔhú cúù‑í Xítohó‑yu, dico ñá ncháǎ‑yu nduu táhǔ‑yu cundecú‑yu núú ndécú Tǎtà‑í Dútú Ndiǒxí táxí tnùní‑gá, chi mee‑ni nchàa ñáyiu na càda nchaa nacuáa càháⁿ‑gá ñáyiu‑áⁿ nduu táhǔ‑yu cundecú‑yu núú ndécú‑gǎ táxí tnùní‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Te na sàá nduu càda ndáá Yǎ Ndiǒxí cuéchi nchaa ñáyiu, te vàí‑yu cúñàhá‑yu xii‑í: “Yòhó Xítohó Jesucrìstú nchúhú cúú‑ndɨ̌ ñáyiu ní cáháⁿ tnúhu‑n nàcuáa ní cachí‑n, te dɨu‑ni‑n nǐ cacunehe‑ndɨ́ te ní sándáá iní ñáhá nchàa espíritú cúndɨ̀hɨ yucu ñávǎha xii‑ndɨ́ ní quee‑xi yɨquɨ cùñú ñáyiu, te dɨu‑ni yòhó ní chindee ñàha‑n xii‑ndɨ́ ní ndacu‑ndɨ́ ní quide‑ndɨ́ tɨtnɨ́ núú sǎ vǎ yǒo tnàhí ndàcu cada”, duha cúñàhá‑yu xii‑í dàvá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dico yúhú cúñaha‑ǐ xií‑yu: “Ñá túú tnàhí xìní ñáhà‑í xii nchòhó nǔu ndèé ñáyiu cùu‑ndo, te chí xócuɨ̀ñɨ́ nchaa nchòhó ñáyiu quìde nchaa sá cuèhé sá dúhá nǔú ndécù‑í‑a”, duha cúñaha‑ǐ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Te nchaa ñáyiu sàcúndedóho tnúhu càháⁿ‑í te núu na tnɨ̀ɨ́‑yu, te ñáyiu‑áⁿ cúǔ‑yu dàtná ɨɨⁿ tée ío váha cùtnuní iní‑xi. Chi tée‑áⁿ nǐ dácáá‑dě ɨɨⁿ vehe, dico díhna‑gá ní xete‑dé ndéé ní tnahá‑dé yúú cáxíⁿ te dǎtnùní ní tava‑dé cimièntú‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Te òré ní cuuⁿ dáú te ní ndee ndute ñuhu, te ní dándáá‑xí nděé núú cáá vèhe‑áⁿ, dico ñá túú ní ndàcu‑xi cuido‑xi. Te ní quene tucu táchí nǐhi dico ñá túú ní ndàcu‑xi cuido‑xi vehe‑áⁿ, te ducaⁿ chi tée ní dácáá vèhe‑áⁿ nǐ tava‑dé cimièntú‑xi núú yǔú cáxíⁿ. Duha sǎtnahá‑xi cùu nchaa ñáyiu tnɨ̀ɨ tnúhu càháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Dico nchaa ñáyiu sàcúndedóho tnúhu càháⁿ‑í te ñá túú cuìní‑yu tnɨɨ́‑yu, ñáyiu‑áⁿ cúǔ‑yu dàtná ɨɨⁿ tée ñá túú tnàhí cùtnuní iní‑xi. Chi tée‑áⁿ nǐ dácáá‑dě ɨɨⁿ vehe núú yúcú mèe‑ni ñuhu cúchí. ");
INSERT INTO milNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Te òré ní cuuⁿ dáú te ní ndee ndute ñuhu, te ní dándáá‑xí nděé núú cáá vèhe‑áⁿ, te ní quene táchí nǐhi te íí‑ni ní xido‑xi vehe‑áⁿ cuèndá sá nǔú ñuhu cúchí nǐ sáá. Duha sǎtnahá‑xi cùu nchaa ñáyiu sàcúndedóho tnúhu càháⁿ‑í te ñá túú cuìní‑yu tnɨɨ́‑yu —duha ní dánèhé ñáhá Jèsús xii cue tée xìca cuu ndɨhɨ‑gá ndɨhɨ nchaa ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Te òré ní ndɨhɨ Jèsús sá dúcáⁿ nǐ cáháⁿ‑gá, te nchaa ñáyiu ní xíndedóho nchaa tnúhu ní cáháⁿ‑gá ío ní cuñúhu‑yu nàcuáa ní dánèhé ñáhá‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Chi ní cáháⁿ‑gá dàtná càháⁿ cue tée cùnuu, te cùnuu ndisa‑gá, te ñá túú ní cǎháⁿ‑gá dàtná càháⁿ nchaa cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés. ");
INSERT INTO milNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Te Jèsús ní xica‑gá cuánuu‑gá dɨ̀ñɨ tɨndúú nǔú dúcáⁿ nǐ xíndecu‑gá ní dánèhé‑gá ñáyiu‑áⁿ, te cuéhé víhí ñǎyiu nchìcúⁿ ñáhá xìi‑gá cuánuu. ");
INSERT INTO milNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Te ní quexìo ɨɨⁿ tée tnàhá cuéhé sǎ dátèhyú nihnu‑xi yɨquɨ cùñú‑ó nǔú Jèsús, te ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú‑gǎ, te xǎhaⁿ‑dě xii‑gá: —Mèstrú, véxi‑í càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n càda tátna ñaha‑n xìi‑í, chi cùtnuní iní‑í sá ndácú‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Te Jèsús ní dácàá‑gá ndaha‑gá ní tendaha ñàha‑gá xii‑dé, te xǎhaⁿ‑gǎ: —Cuu cada tátna ñaha‑ǐ xii‑n, te vitna ndúha‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te òré‑ni‑áⁿ nǐ xócuɨ̀ñɨ́ cuéhé tnàhá‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Te Jèsús ní xáhaⁿ tùcu‑gá xii‑dé: —Te vitna cuanùhú te vá yǒo ɨɨⁿ cúñaha‑n sǎ yǔhú ní quide tátna ñaha‑ǐ xii‑n, núú dǔtú‑ni cuàháⁿ cuèndá sá ná quìní ñáhá‑dě xii‑n sǎ nǐ ndúha‑n, te cuáñaha‑n sǎ ndúú tǎhú Yǎ Ndiǒxí dàtná ní cachí ndíi Moìsés. Te ducaⁿ càda‑n cuendá cutnùní iní ñáyiu sá nǐ ndúha‑n —càchí‑gá xǎhaⁿ‑gǎ xii tée ní quide tátna‑gá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Te Jèsús ní xica‑gá cuáháⁿ‑gá ñuú Capèrnaúm. Te òré cuánguɨhu‑gá ñuú‑áⁿ te ní quexìo ɨɨⁿ tée cùu capitáⁿ càháⁿ ndàhú‑dé núú‑gǎ, ");
INSERT INTO milNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","te xǎhaⁿ‑dě xii‑gá: —Mèstrú, véxi‑í càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n càda tátna‑n ɨ̀ɨⁿ tée xìnu cuechi núù‑í, chi cùhú‑dé te càhú víhí tnàhá‑dé, te ío ndòho‑dé te ni ñǎ cúndèe‑gá‑dé candá nihnu‑dé —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Te na quɨ̀hɨ́ⁿ‑ó càda tátna‑í‑dé —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Te tée cùu capitáⁿ‑áⁿ nǐ xáhaⁿ‑dě xii‑gá: —Mèstrú, ñá túú tàú‑í sá quɨ̌hu‑n ndèé xɨtɨ́ vehe‑í, chi cùu‑í ɨɨⁿ tée cùtexínu sá cúú‑xí‑n, te cáháⁿ‑ni sá ndǔha tée xìnu cuechi núù‑í te ndúha‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Chi yúhú ndècu cue tée tàxi tnuní ñáhá xìi‑í, te ducaⁿ yǔhú tucu ndècu cue sandadú táxí tnùní‑í. Te òré xǎhaⁿ‑ǐ xii ɨɨⁿ‑dé quɨ́hɨ́ⁿ‑dé ɨɨⁿ chìuⁿ te cuáháⁿ‑dé, te òré xǎhaⁿ‑ǐ xii ɨngá‑dé quixi‑dé te véxi‑dé, te òré xǎhaⁿ‑ǐ xii ɨɨⁿ tée xìnu cuechi núù‑í cada‑dé ɨɨⁿ chìuⁿ te quìde‑dé. Núu xíǎⁿ yòhó cáháⁿ‑ni sá ndǔha tée xìnu cuechi núù‑í te ndúha‑dé —càchí‑dé xǎhaⁿ‑dě xii Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Te Jèsús ío ní cuñúhu‑gá sá dúcáⁿ nǐ cáháⁿ tée cùu capitáⁿ‑áⁿ, te ní xáhaⁿ‑gǎ xii nchaa ñáyiu nchìcúⁿ ñáhá xìi‑gá: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ vǎtá quìní‑gá‑í ni ɨ̀ɨⁿ ñáyiu isràél, ñáyiu súúní ǐo váha sàndáá iní ñáhá xìi Yá Ndiǒxí dàtná sàndáá iní ñáhá těe‑a xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Te na càchí tnúhu ndáá tucu‑í xii‑ndo sǎ ǐo cuéhé ñǎyiu quixi ndàa xio nacuáa quène nchícanchii, te dɨu‑ni ducaⁿ ǐo cuéhé tucú‑yu quixi ndàa xio nacuáa quée tucu nchícanchii. Te nchaa ñáyiu‑áⁿ naníhí tnáhǎ‑yu ndɨhɨ té Àbrahám, ndɨhɨ té Isàác, ndɨhɨ té Jàcób núú ndécú Yǎ Ndiǒxí táxí tnùní‑gá te yàcáⁿ cundecu ndɨhɨ ñàhá‑yu xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Te nchaa ñáyiu tàú nduu táhú cundecu núú ndécú Yǎ Ndiǒxí táxí tnùní‑gá ní cùu, ñáyiu‑áⁿ quee tɨ́hǔ‑yu, chi quɨ́hɨ́ⁿ‑yu ɨɨⁿ xichi núú néé nǔú ǐo ndohó‑yu cundecú‑yu, te yàcáⁿ ío ndáhí‑yu, te dìcó rúhñú‑nǎ cuu núhu‑yu sá sàtú iní‑yu cuèndá sá ndóhǒ‑yu —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Te Jèsús ní xáhaⁿ tùcu‑gá xii tée cùu capitáⁿ‑áⁿ: —Yòhó tée ndècu ndɨhɨ tée cùhú cuanùhú vehe‑n vìtna chi ndúha‑dé chi ní sándáá iní‑n Yǎ Ndiǒxí —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te dɨu‑ni òré ducaⁿ nǐ xáhaⁿ Jèsús xii tée cùu capitáⁿ‑áⁿ nǐ ndúha tée xìnu cuechi núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Te Jèsús ní xica‑gá cuáháⁿ‑gá vehe té Pèlú, te òré ní quexìo‑gá vehe‑dé te ní xiní‑gá cáá nǎná ñadɨ̀hɨ́‑dé cùhú‑aⁿ ñùhu vihi‑aⁿ cahni. ");
INSERT INTO milNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Te Jèsús ní tnɨɨ‑gá ndaha ñaha cùhú‑áⁿ, te òré‑ni‑áⁿ nǐ nchíco‑aⁿ cahni te ní ndacóo‑aⁿ ní xinu cuechi‑aⁿ nǔú‑güedě ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Te òré ní dáhu nchícanchii te ní quexìo ñáyiu núú ndécú Jèsús, te ndècá‑yu vài ñáyiu yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha ní sáá núú‑gǎ te ndèca tucú‑yu vài ñáyiu tnàhá dava‑gá núú cuěhé. Te ɨɨⁿ‑ni tnúhu ní cáháⁿ Jèsús ní tenàá‑gá nchaa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii nchaa ñáyiu‑áⁿ, te ní quee‑xi yɨquɨ cùñú‑yu cuáháⁿ‑xi. Te tnàhá nchaa dava‑gá ñáyiu cùhú‑áⁿ nǐ quide tátna‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa ní cáháⁿ ndíi Chàiá tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, te duha ní cachí ndíi: “Mee‑gǎ cada tátna ñaha‑gǎ xii‑o, chi dɨu‑gá xocàni‑gá nchaa sá quídé ǔhú yɨquɨ cùñú‑ó”, duha ní cachí ndíi. ");
INSERT INTO milNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Te òré ní xiní Jèsús sá ǐo cuéhé ñǎyiu xǐxúcu núú ndécú‑gǎ, te ní xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá sá quěe‑gá ndɨhɨ‑güedé bàrcú cuèndá téhndé‑gá ndɨhɨ‑güedé ndàa ɨngá xio yuhu làgúná. ");
INSERT INTO milNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Te mei òré‑áⁿ nǐ quexìo ɨɨⁿ tée dàcuaha ñaha xii cue ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, te xǎhaⁿ‑dě xii‑gá: —Mèstrú, cuìní‑í canchicúⁿ ñáhà‑í xii‑n nděni ní cuu na quɨ̀hɨ́ⁿ‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Nchaa ñúcuii chi ndècu yaú cúú vèhe‑güedɨ saquɨ́hɨ‑güedɨ, te nchaa cue quɨtɨ ndàva caa tacá‑güedɨ dɨquɨ́ yutnu. Dico yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo chi ñá túú ndèé cáá vèhe‑í ñuyíú‑a ndetatú‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Te ɨɨⁿ tée ní chitnahá ñáhá xìi Jesús ní xáhaⁿ‑dě xii‑gá: —Jèsús, daña na nùhú‑í cundetu‑í cuú tǎtà‑í te chindúxi‑í‑dé dǎtnùní quixi‑í chitnahá ñáhá dùcaⁿ‑ná‑í xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Daña ñǎyiu ñá túú sàndáá iní ñáhá xìi‑í ná chìndúxi tnàha meé‑yu, chi ñáyiu‑áⁿ cúǔ‑yu dàtná ñáyiu ní xíhí cuěi ndècu‑ní‑yu núú ñuyíú‑a, te yòhó canchicúⁿ ñáhá‑ní xìi‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Te sátá dúcáⁿ te Jèsús cuánguee‑gá bàrcú ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te ní xica bàrcú‑áⁿ cuǎháⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Te nɨni ñùhu barcú‑áⁿ ichi cuáháⁿ‑xi núú ndute ní xídí Jèsús, te ní ngüíta‑xi níhi vìhi quene táchí, te ta nàdachitú‑xi ndute xɨtɨ́ bàrcú cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Te cue tée xìca cuu ndɨhɨ‑gá cuáháⁿ‑güedé núú cáá‑gǎ xìdí‑gá, te xǎhaⁿ‑güedě xii‑gá: —¡Mèstrú, ndɨquɨ́ú ìní chi dàcácu ñaha‑n xìi‑o chi quée naa‑o cuìní‑xi! —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —¿Ná cuèndá ndéé ducaⁿ ǐo yùhú‑ndó? ¿Náa ñá túú sàndáá iní ñáhá ndìsa‑ndo xii‑í‑ǎⁿ? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te Jèsús ní ndacóo‑gá te ní tenàá‑gá táchí‑ǎⁿ ndɨhɨ ndute‑áⁿ, te ní ngüɨ́ñɨ́ táchí‑ǎⁿ te ní nucúndecu nahi‑nǎ ndute làgúná‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Te nchaa cue tée ñùhu xɨtɨ́ bàrcú‑áⁿ nǐ cuñúhu‑güedé sá dúcáⁿ nǐ quide‑gá ní xiní‑güedé, te ní xítnàha‑güedé: —¿Te ná tée cùu tée‑a núu duha ní cáháⁿ‑ni‑dé te ní ngüɨ́ñɨ́ táchí te ní nucúndecu nahi‑ni ndùte lagúná‑a‑i? —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Te òré ní quèxio Jesús ndàa ɨngá xio yuhu làgúná yucu cue tée ñuú Gàdará, te úú tnàhá cue tée quìde vehe núú yɨ́ndǔxi ndɨ́yɨ ní quee‑güedé cuáháⁿ‑güedé núú ndécú Jèsús, te ndɨ ndùú‑güedé yɨ́hɨ́ ñàha espíritú cúndɨ̀hɨ yucu ñávǎha xii‑güedé, te ío màñá‑güedé chi vá yǒo tnàhí dàña‑güedé yáha yatni núú ndécú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Te cue espíritú yɨ́hɨ́ ñàha xii‑güedé‑áⁿ nǐ quide‑xi níhi ní cáháⁿ‑güedé, te xǎhaⁿ‑güedě xii‑gá: —¿Ná cuèndá véxi‑ǒ Jèsús Déhe Dútú Ndiǒxí chidácá ñáhá‑n xìi‑ndɨ́? ¿Áⁿ sàma véxi‑n dàndoho ñaha‑n xii‑ndɨ́? Te vátá sàá‑gá nduu dùcaⁿ cada‑n —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Te yatni xíáⁿ xǐxica cuu vài cuchí xǐxexi‑güedɨ. ");
INSERT INTO milNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Te cue espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii cue tée‑áⁿ nǐ cáháⁿ ndàhú‑xi núú Jèsús, te xǎhaⁿ‑xi: —Te núu vá dáñá‑gǎ‑n quɨ̀hɨ‑ndɨ́ yɨquɨ cùñú cue tée‑a, te càháⁿ ndàhú‑ndɨ́ núú‑n sǎ dàña‑n na quɨ́hɨ́ⁿ‑ndɨ́ quɨ́hu‑ndɨ́ yɨquɨ cùñú nchaa cùchí‑ǎⁿ —càchí cue espíritú‑áⁿ xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Te Jèsús ní xáhaⁿ‑gǎ xii cue espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ: —Chí táquèe yɨquɨ cuñú cue tée‑áⁿ te quɨ́hɨ́ⁿ‑ndó nǔu ndèé ichi quɨ́hɨ́ⁿ‑ndó —càchí‑gá xǎhaⁿ‑gǎ xii nchaa espíritú‑áⁿ. Te cue espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ nǐ quee‑xi yɨquɨ cùñú cue tée‑áⁿ, te cuáháⁿ‑xi cuánguɨhu‑xi nchaa cùchí‑áⁿ. Te cue quɨtɨ‑áⁿ nǐ xinu‑güedɨ duha ní quée‑güedɨ ndàa núú dèhvá yuhu làgúná‑áⁿ, te ní ngaunihnu‑güedɨ xɨtɨ́ ndute, te ní ndɨhɨ‑güedɨ ní cáhá. ");
INSERT INTO milNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Te cue tée xìto ñaha xii nchaa cuchí‑áⁿ nǐ yùhú‑güedé te ní xinu‑güedé, te ní sáháⁿ‑güedé ní cani‑güedé cuèndú núú cuè ñáyiu ndècu xɨtɨ́ ñuú nchaa nàcuáa ní cuu cuèndá cue tée ní xɨ́hɨ ñaha nchàa espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Te nchaa ñáyiu ñuú‑áⁿ nǐ queé‑yu cuáháⁿ‑yu núú ndécú Jèsús. Te òré ní quexìó‑yu núú ndécú‑gǎ te ní cáháⁿ ndàhú‑yu núú‑gǎ sá ná quèe‑gá yucu ñuú‑yu núhú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Te sátá dúcáⁿ nǐ cuu te Jèsús cuándee‑gá bàrcú cuáháⁿ‑gá ní natehndé‑gá ndàa ɨngá xio yuhu làgúná. Te xíáⁿ nǐ ndexìo‑gá ñuú núú quídé ñùú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Te xíáⁿ ndécú‑gǎ ní quexìo cue tée nchìdo‑güedé ɨɨⁿ tée cùhú ñá cúú‑gǎ candá nihnu ñùhu‑dé xíto, te Jèsús ní cutnùní iní‑gá sá sàndáá ndisa iní ñáhá‑güedě xii‑gá nǔu ní xáhaⁿ‑gǎ xii tée cùhú‑áⁿ: —Yòhó tée cùhú vá ndɨ̀hú‑gá iní‑n, chi sa ní quide càhnu iní‑í nchaa cuéchi‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Te sá dúcáⁿ nǐ cáháⁿ‑gá nǔu xíǎⁿ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés ní sani iní‑güedé: “Tée‑a càháⁿ cuèhé‑dé cuèndá Yǎ Ndiǒxí”, duha ní sani iní‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Te Jèsús ní cutnùní iní‑gá nàcuáa sàni iní‑güedé nǔu ní xáhaⁿ‑gǎ xii‑güedé: —¿Ná cuèndá ducaⁿ sàni cuehé sání dùha iní‑ndó? ");
INSERT INTO milNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Te sá dúhá nǐ xáhaⁿ‑ǐ xii tée cùhú‑a sá nǐ quide càhnu iní‑í nchaa yícá cuěchi‑dé, te xíǎⁿ nchòhó ñá túú cùtnuní iní‑ndó nǔu ndáá càháⁿ‑í àdi ñá ndàá. Dico núu cúu‑í‑dé sá ndácǒo‑dé te caca‑dé, te cutnùní ndáá iní‑ndó nǔu ndáá càháⁿ‑í àdi ñá ndàá, chi cundehe nǔú‑ndó nàcuáa cada‑í. ");
INSERT INTO milNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Te vitna na càda‑í nàcuáa cutnùní iní‑ndó nchàa‑ndo sá yǔhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ndecu ndɨhɨ‑í tnúhu ndee ìní ñuyíú‑a sá cádá càhnu iní‑í nchaa cuéchi ñáyiu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te sátá dúcáⁿ te ní xáhaⁿ‑gǎ xii té cùhú‑áⁿ: —Ndacóo, te ndocani‑n xǐto ñùhu‑n véxi‑áⁿ te núhú‑n vèhe‑n —cachí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Te òré‑ni‑áⁿ nǐ ndúha tée cùhú‑áⁿ te ní ndacóo‑dé te ní ndocani‑dé xíto ñùhu‑dé ní quexìo‑áⁿ te ní xica‑dé cuánuhú‑dé vehe‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Te nchaa ñáyiu xǐndecu‑áⁿ ǐo ní cuñúhu‑yu sá dúcáⁿ nǐ quide Jèsús ní xiní‑yu, te ní cachí‑yu sá ǐo càhnu cuu Yá Ndiǒxí cuèndá sá nǐ sáñaha‑gǎ xii Jèsús tnúhu ndee ìní cada‑gá nchaa sá vǎ yǒo tnàhí ndàcu cada. ");
INSERT INTO milNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Te Jèsús ní nucúhuⁿ tucu‑gá ichi cuáháⁿ‑gá, te ichi ñùhu‑gá ní xiní‑gá núcǒo ɨɨⁿ tée nàni Mateú quídé còbrá‑dé ñáyiu chi cobràdór impuèstú cúú‑dě, te ní xáhaⁿ‑gǎ xii‑dé: —Màteú, néhé chitnahá ñáhá‑n xìi‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te té Màteú‑áⁿ nǐ ndacuɨ́ñɨ́‑dé ní chitnahá ñáhá‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Te ɨɨⁿ xito ndècu Jesús ɨɨⁿ vehe, te yɨ̀hɨ‑gá mèsá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá xéxí ndɨ̀hɨ ñaha‑gá xii‑güedé. Te tnàhá cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú yɨ́hɨ́ ndɨ̀hɨ‑gá mèsá, te tnàhá tucu dava‑gá cue tée ndècu ichi cuehé ichi duha yɨ̀hɨ ndɨhɨ‑gá mèsá. ");
INSERT INTO milNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Te sá nǐ xiní cue tée cùu fariséú xéxí Jèsús ndɨhɨ nchaa cue tée‑áⁿ, te ní xícáⁿ tnúhú‑güedě núú cuè tée xìca cuu ndɨhɨ‑gá, te xǎhaⁿ‑güedě: —¿Ná cuèndá ducaⁿ quìde tée cùu mestrú‑ndó xèxi‑dé ndɨhɨ cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú, ndɨhɨ nchaa dava‑gá cue tée ndècu ichi cuehé ichi duha‑i? —càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Te Jèsús ní tecú dóho‑gá nàcuáa ndùu tnúhu ní xáhaⁿ‑güedě xii cue tée xìca cuu ndɨhɨ‑gá, núu ní xáhaⁿ‑gǎ xii‑güedé: —Nchaa ñáyiu ñá túú cùhú chi ñá túú xìni ñuhú‑yu ñátátná, dico nchaa ñáyiu cùhú chi xìni ñuhú‑yu ñátátná. Te yúhú véxi‑í cáháⁿ‑í ñáyiu cùtnuní iní‑xi sá ndécú cuěchi‑xi cuèndá dàñá‑yu nchaa sá cuèhé sá dúhá quìdé‑yu, te ñá túú věxi‑í cáháⁿ‑í ñáyiu càchí sá ñà túú ndècu cuéchi‑xi. Te chí cádá cuèndá váha nàcuáa càháⁿ Yǎ Ndiǒxí núú tùtú‑gá núú càchí‑xi: “Yúhú cuìní‑í sá cúndàhú iní‑ndó cuè tnaha ñáyiu‑ndo, te ñá dɨ́ú mèe‑ni sá cáhní‑ndó quɨ̀tɨ nduu táhù‑í”, duha càchí‑gá núú tùtú‑gá —càchí Jèsús xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Te cue tée xìca cuu ndɨhɨ té Juàá tée dàcuandute ñaha xii ñáyiu ní sáháⁿ‑güedé núú ndécú Jèsús, te xìcáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě: —Cuìní‑ndɨ́ cachí tnúhu‑n nǎ cuèndá nchúhú, ndɨhɨ cue tée cùu fariséú ñá túú tnàhí ná xéxí‑ndɨ̌ áma càháⁿ ndɨhɨ‑ndɨ́ Yǎ Ndiǒxí, te cue tée xìca cuu ndɨhɨ‑n ñá túú dùcaⁿ quide‑güedé —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó xìní‑ndó sǎ vǎ cúú cǔñaha‑o xìi ñáyiu ñùhu vico tnándaha sá vǎ cúú càxí‑yu nɨni ndècu ndɨhɨ ñaha tée tnǎndaha xií‑yu, dico sáá nduu vǎ cúndècu ndɨhɨ ñaha‑gá tée tnǎndaha‑áⁿ xií‑yu, te dàvá‑áⁿ te cahni iní‑yu vá cáxǐ‑yu cuèndá sá ndɨ̀hú iní‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Te ni vǎ yǒo dàndée luha dóó sáá ɨ̀ɨⁿ dóó sa ní cuu tùhú víhí, chi dóó sáá‑ǎⁿ nàndɨyɨ‑xi te uuⁿ‑gá ndata‑xi dǒó sǎ nǐ cuu tùhú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Te ni vǎ yǒo chìhi ndidí sáá xɨ̀tɨ́ ɨɨⁿ lamba sa ní cuu tùhú víhí, chi núu yoo ducaⁿ na càda te ndava lamba sa ní cuu tùhú‑áⁿ chi ío níhi yócó ndìdí‑áⁿ, te cuíta‑ni ndidí‑áⁿ te cuíta‑ni lamba‑áⁿ te núu ducaⁿ na càdá‑yu, núu xíǎⁿ xíní ñùhu‑xi quée ndidí sáá‑ǎⁿ xɨtɨ́ ɨɨⁿ lamba saa cuèndá ducaⁿ ñà túú nǎ cuu cováha‑xi —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Te càháⁿ dúcáⁿ‑ní Jèsús ní quexìo ɨɨⁿ tée cùnuu núú ndécú‑gǎ, ɨɨⁿ tée tàxi tnuní veñúhu, te ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú‑gǎ càháⁿ ndàhú‑dé, te xǎhaⁿ‑dě xii‑gá: —Véxi‑í càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n quɨ̌hɨ́ⁿ‑ó vèhe‑í dandòto‑n déhe yoco‑ǐ chi ní xíhí‑xi tnàvíí, te yúhú cútnùní iní‑í sá nǔu quɨ́hɨ́ⁿ‑n tèndaha‑n yɨquɨ cuñú‑xi te ndoto‑xi —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Te Jèsús ní xica‑gá cuáháⁿ‑gá ndɨhɨ‑dé ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Te ichi ñùhu‑gá cuáháⁿ‑gá ní sáháⁿ ɨɨⁿ ñadɨ̀hɨ́ ní tnándeé‑aⁿ yuhu dǒó‑gǎ ndàa sátá‑gǎ, te ñaha‑áⁿ sa ní cuu úxúú cuíá sǎ cùhú‑aⁿ ngòyo ñaha nɨ́ñɨ́ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Te ducaⁿ nǐ quide‑aⁿ chi ní sani iní‑aⁿ sá nǔu ndacu‑aⁿ tnándeé‑aⁿ cuědìcó luha yuhu dǒó Jèsús te ndúha‑aⁿ ní sani iní‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Te Jèsús ní nchócótó‑gǎ ndàa sátá‑gǎ te ní xiní‑gá ñadɨ̀hɨ́‑áⁿ, te ní xáhaⁿ‑gǎ: —Yòhó ñaha cùhú, vá ndɨ̀hú‑gá iní‑n vìtna chi sa ní ndúha‑n, chi ní sándáá iní ñáhá‑n xìi‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑aⁿ. Te òré‑ni‑áⁿ nǐ ndúha ñaha cùhú‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Te òré ní quexìo Jesús vehe tée cùnuu taxi tnuní veñúhu‑áⁿ, te ní xiní‑gá xǐndáhí víhí ñǎyiu, te xǐndecu mǔsicú. ");
INSERT INTO milNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Te ní xáhaⁿ‑gǎ xií‑yu: —Chí táquèe xɨtɨ́ vehe‑a, chi xíchí‑a ñá túú ní xǐhí‑xi chi dìcó xìdí‑xi —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. Te ní sácú ndeé ñáhǎ‑yu xii‑gá sá dúcáⁿ nǐ cáháⁿ‑gá, chi sá cúú‑xí mèé‑yu te ní xíhí ndisa xíchí‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Te ñáyiu‑áⁿ nǐ queé‑yu te cuánguɨhu Jèsús núú cándòdo xíchí nǐ xíhí‑áⁿ, te ní tnɨɨ‑gá ndaha‑xi te òré‑ni‑áⁿ nǐ ndacóo‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Te nchaa ñuú cáá yàtni xíáⁿ nǐ níhí ñǎyiu tnúhu nàcuáa ní quide Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Te sátá dúcáⁿ nǐ cuu te ní xica Jèsús cuánuhú‑gá, te ichi ñùhu‑gá ní chinchícúⁿ ñáhá ǔú tnàhá cue tée cuàá xii‑gá, te níhi càháⁿ‑güedé, te xǎhaⁿ‑güedě xii‑gá: —Yòhó Jèsús, tée cùu ñaní tnáhá ndǐi Dàvií, cundàhú iní ñáhá xìi‑ndɨ́ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Te òré ní nasáá Jèsús núú quídé vèhe‑gá, te cue tée cuàá‑áⁿ nǐ quexìo‑güedé ndéé núú‑gǎ, te ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ: —¿Sàndáá iní‑ndó sǎ yǔhú ndacu‑í cada tátna‑í núú‑ndó‑ǎⁿ? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Sàndáá iní‑ndɨ́ sá dɨ́ú yòhó Jèsús ndacu‑n càda tátna‑n nǔú‑ndɨ̌ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Te Jèsús ní dácàá‑gá ndaha‑gá ní tendaha‑gǎ núú‑güedě, te ní xáhaⁿ‑gǎ xii‑güedé: —Te vitna, ndúha núú‑ndó chi ní sándáá iní‑ndó sǎ dɨ́ú yǔhú ndacu‑í cada tátna‑í núú‑ndó —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Te òré‑ni‑áⁿ nǐ ndúha núú‑güedě, te Jèsús ní cáháⁿ víhí‑gǎ dóho‑güedé cuèndá sá vǎ càháⁿ‑güedé nàcuáa ní cuu ní ndúha núú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Te cue tée‑áⁿ òré ní ndee‑güedé núú ndécú Jèsús, te ní ngüíta‑ni‑güedé ní cani‑güedé cuèndú núú ñǎyiu nàcuáa ní quide ñaha‑gǎ xii‑güedé. Te nchaa dava‑gá ñuú cáá yàtni xíáⁿ nǐ sáháⁿ‑güedé ní cani‑güedé cuèndú núú ñǎyiu nàcuáa ní quide ñaha Jèsús xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Te íchí nǐ ndee cue tée ní ndúha núú‑xi‑áⁿ nǔú ndécú Jèsús, te ní quexìo ɨɨⁿ úú ñáyiu ndècá‑yu ɨɨⁿ tée ñɨ̀hɨ́ yɨ́hɨ́ ñàha espíritú cúndɨ̀hɨ yucu ñávǎha. ");
INSERT INTO milNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Te Jèsús ní queñuhu‑gá espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii tée‑áⁿ, te òré‑ni‑áⁿ nǐ cuu ní nacáháⁿ‑dé. Te nchaa ñáyiu xǐndecu‑áⁿ ǐo ní cuñúhu‑yu, te ní xítnàhá‑yu: —Ñá túú tnàhí xìní‑ó ɨ̀ɨⁿ tée duha cada ñuú nchoo cuè ñáyiu isràél ní cùu —cachí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Te cue tée cùu fariséú ní ngüíta‑güedé xǐtnàha‑güedé: —Tée‑a chi sácuíhná chíndèe ñaha‑xi xii‑dé quéñùhu‑dé nchaa espíritú yɨ́hɨ́ ñàha xii ñáyiu te dɨu‑ni sácuíhná‑ǎⁿ táxí tnùní‑xi nchaa espíritú‑áⁿ —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Te Jèsús cuáháⁿ‑gá nchaa ñuú náhnú ndɨ̀hɨ nchaa ñuú lǐhli, te ndɨ tnahá ɨɨⁿ ɨɨⁿ ñuú sàá‑gá te ducaⁿ cuǎnguɨhu‑gá ɨɨⁿ ɨɨⁿ veñúhu càa nchaa ñuú‑áⁿ dánèhé‑gá ñáyiu tnúhu váha, tnúhu sá sánú ìchi ñaha xií‑yu nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu. Te ducaⁿ‑ni ta quìde tátna‑gá nchaa ñáyiu cùhú cuáháⁿ cuěi ndɨ dɨ́ɨ́ⁿ ndɨ̀ dɨ́ɨ́ⁿ nǔú cuěhé tnàhá‑yu ɨɨⁿ ɨɨ́ⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Te sá nǐ xiní Jèsús sá ǐo vài ñáyiu nchìcúⁿ ñáhá xìi‑gá, te ní cundàhú iní ñáhá‑gǎ xií‑yu chi ío ndɨ̀hú iní‑yu, te vá yǒo nèhe cuendá ñáhá xìí‑yu, te cùú‑yu dàtná cue mběé cue quɨtɨ ñá túú tòli‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Te Jèsús ní xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá: —Nchòhó xìní‑ndó sǎ òré ná sàá nduu cùu nchaa sá xítú ñǎyiu te ío vài cuu. Te na càchí tnúhu ndáá‑í xii‑ndo sǎ dàtná ío vài sá xítú ñǎyiu cùu, ducaⁿ ǐo vài ñáyiu cùmání cundedóho tnúhu‑í, te ío sacú ñáyiu dàcuaha ñaha xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Núu xíǎⁿ xíní ñùhu‑xi cácáⁿ‑ndó nǔú Yǎ Ndiǒxí Yaá cúú Xǐtohó‑ndó ndɨ̀hɨ́‑yu cuèndá sá ná dàcaháⁿ‑gá iní‑yu cáháⁿ‑yu tnúhu‑gá núú nchàa dava‑gá tnàha ñáyiú‑yu cùmání cundedóho tnúhu‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Te Jèsús ní cana‑gá ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá, te ní sáñaha‑gǎ xii‑güedé tnúhu ndee ìní cundecu ndɨhɨ‑güedé cuèndá queñuhu‑güedé nchaa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu, ndɨhɨ cuèndá sá cádá tǎtna‑güedé nchaa dava‑gá ñáyiu cùhú cuěi nándɨ núú cuěhé tnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Te duha xǐnani ndɨ ùxúú cue tée‑áⁿ: tée cùnuu‑gá nání‑dě Xǐmú, àdi Pelú chi úú dɨ̀u‑dé, te ñaní‑dé cúú tě Ndrǐxí, te tnàhá tée‑áⁿ cúú‑dě tée xìca cuu ndɨhɨ Jesús, ndɨhɨ té Jàcobó ndɨhɨ ñaní té Jàcobó‑áⁿ těe nàni Juaá, te ndɨ ndùú cue tée‑áⁿ cúú‑güedě déhe té Zebèdeú. ");
INSERT INTO milNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Te tnàhá té Lìpé xícá cùu ndɨhɨ‑gá, ndɨhɨ té Bartolòmé, ndɨhɨ té Mǎxí, ndɨhɨ té Màteú tée cùu cobradór impuèstú ní cùu, ndɨhɨ té Jàcobó déhe té Àlfeú, ndɨhɨ té Lèbeú tée dànani‑güedé Tàdeú, ");
INSERT INTO milNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ndɨhɨ té Xǐmú tée ní cundɨhɨ cue tée canànistá, ndɨhɨ té Jùdás Iscàrioté tée ní sáá nduu nǐ sáha cuèndá ñáhá xìi Jesús núú cuè tée cùu úhú iní ñáhá xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Te Jèsús ní xáhaⁿ‑gǎ xii ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá sá quɨ̀hɨ́ⁿ‑güedé cáháⁿ‑güedé tnúhu‑gá núú ñǎyiu, te cùmání‑gǎ caca‑güedé quɨ́hɨ́ⁿ‑güedé, te ní xáhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu‑í xii‑ndo sǎ méé‑ní ñùú núú xǐndecu cue ñáyiu isràél quɨ́hɨ́ⁿ‑ndó cǎháⁿ‑ndó tnǔhu‑í, te vá quɨ̀hɨ́ⁿ‑ndó nì ɨɨⁿ ñuú yɨ́ndèhu distritú Sàmariá, te ni vǎ quɨ̀hɨ́ⁿ‑ndó dàva‑gá ñuú núú xǐndecu ñáyiu ñá túú cùu ñáyiu isràél. Te cue ñáyiu isràél‑áⁿ cúǔ‑yu dàtná cue mběé cue quɨtɨ ní xíta chi ta xǐta nihnú‑yu cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Te cúñaha‑ndo xìí‑yu sá sà ní cuyatni nduu ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Te cada tátna‑ndo nchàa ñáyiu cùhú cuěi ñáyiu tnàhá cuéhé sǎ dátèhyú nihnu‑xi yɨquɨ cùñú‑yu, te queñuhu‑ndo nchàa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu, te dandòto‑ndo cue ñáyiu sa ní xíhí, te vá càcáⁿ‑ndó yǎhu‑ndo nǔú ñǎyiu òré cada‑ndo nchàa chiuⁿ‑áⁿ, chi sa nàha‑ndo sá dìcó ducaⁿ nǐ taxi‑í tnúhu ndee ìní ndécú ndɨ̀hɨ‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Te vá cánèhe‑ndo díhúⁿ cuu ichi‑ndo, ");
INSERT INTO milNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","te ni vǎ cánèhe‑ndo ñunu cuhuⁿ ndachiuⁿ‑ndo, te ni vǎ cánèhe‑ndo ɨngá ichi dóó‑ndó nàdáma‑ndo, te ni vǎ cánèhe‑ndo úú‑gá chàú‑ndó chi dɨu‑ni chàú yɨ́hɨ́‑ndó‑ǎⁿ xíǎⁿ‑ni quɨhɨ‑ndo, te ni vǎ cánèhe‑ndo tatnu, te ducaⁿ càda‑ndo chi nchòhó sa nàha‑ndo sá ncháá ñǎyiu quìde chiuⁿ te dɨu‑ni cuèndá chìuⁿ quidé‑yu nìhí‑yu sá xéxǐ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Te ndɨ tnahá ñuú ná quèxio‑ndo te nducu‑ndo ñǎyiu cùtnuní iní‑ndó sǎ cúǔ‑yu ñáyiu váha, te vehe ñáyiu‑áⁿ cundecu‑ndo ndèé sáá nduu ndèe‑ndo ñuú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Te òré quexìo‑ndo vehé‑yu te cúñaha‑ndo xìí‑yu: “Yá Ndiǒxí chíndèe chitúu ñaha‑gǎ xii‑ndo ndècu‑ndo”, duha cúñaha‑ndo xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Te núu ní cáháⁿ váha ndɨhɨ ñàhá‑yu xii‑ndo, te cuu‑xi sá vǎha sá cúú‑xǐ‑yu cuèndá tnúhu ní xáhaⁿ‑ndo‑ǎⁿ, dico núu ñá túú ní càháⁿ váha ndɨhɨ ñàhá‑yu xii‑ndo, te cúñaha‑ndo xìí‑yu sá vǎ cúú‑xí sǎ vǎha xií‑yu tnúhu ní xáhaⁿ‑ndo‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Te núu ní sáá‑ndó ɨ̀ɨⁿ ñuú àdi ɨɨⁿ vehe, te núu ñá túú ní cǎháⁿ ndɨhɨ ñaha vǎha‑yu xii‑ndo te ni ñà túú ní cuìní‑yu cundedóho‑yu tnúhu càháⁿ‑ndó te ndee‑ndo ñùú‑áⁿ àdi vehe‑áⁿ, te naquɨdɨ‑ndo tɨ̌cá chúhmá nǐ tnɨ́ɨ sáhá‑ndó cuèndá ná cùtnuní iní‑yu sá ñà túú quìde váha‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ sàá nduu te ío‑gá dandòho ñaha Yá Ndiǒxí xii ñáyiu ducaⁿ na càda ñaha xii‑ndo‑áⁿ dàcúúxí ñǎyiu ní xíndecu ñuú Sòdomá ndɨhɨ ñuú Gòmorrá. ");
INSERT INTO milNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Te cada iní‑ndó sǎ cúú‑ndó dàtná cue mběé cue quɨtɨ cuáháⁿ núú ìó yɨ́hɨ́. Te ducaⁿ sǎtnahá‑xi cùu‑ndo chi yúhú tendaha ñaha‑ǐ xii‑ndo quɨ̌hɨ́ⁿ‑ndó nǔú xǐndecu cue ñáyiu cuihna ìní‑xi, te ío váha cuáha‑ndo cuèndá nàcuáa cada‑ndo dàtná quídé cǒó, dico cunduu váha iní‑ndó ñà túú nǎ cada‑ndo dàtná quídé lǒmá. ");
INSERT INTO milNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Te quɨhɨ iní‑ndó chi cue ñáyiu na cùu úhú iní ñáhá xìi‑ndo, te cuáha cuèndá ñáhǎ‑yu xii‑ndo nǔú cuè tée cùchiuⁿ, te caniha‑güedě xii‑ndo xɨ̀tɨ́ veñúhu‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Te dava tucu ñáyiu cuu úhú iní ñáhá xìi‑ndo candeca ñahá‑yu xii‑ndo quɨ̌hɨ́ⁿ núú cuè tée cùnuu yɨndaha nacióⁿ, àdi núú dàva‑gá cue tée cùnuu sá cuèndá‑í. Te nchòhó níhí‑ndó nàcuáa cada‑ndo cǎháⁿ váha‑ndo cuèndá‑í núú‑güedě ndɨhɨ núú cuè ñáyiu ñá túú cùu ñáyiu isràél. ");
INSERT INTO milNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Dico òré cuáha cuèndá ñáhǎ‑yu xii‑ndo nǔú nchàa cue tée‑áⁿ, te vá cání ìní‑ndó nǔu nása cunduu tnúhu cáháⁿ‑ndó nǔú‑güedě, chi òré‑nǎ te níhí‑ndó tnǔhu cáháⁿ‑ndó. Te ñá dɨ́ú mèe‑ndo cahu iní‑ndó tnǔhu cáháⁿ‑ndó, chi mee Espíritú Yǎ Ndiǒxí Yaá cúú Tǎtá‑ndó dàcahú iní ñáhá‑xí xìi‑ndo nacuáa cunduu tnúhu cáháⁿ‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Te dava cue tée cuáha cuèndá‑güedé ñaní‑güedé núú cuè tée cùchiuⁿ cuendá cahni ñaha‑güedě, te dava cue tée cùu tátá dɨu‑ni ducaⁿ càda‑güedé déhe‑güedé, te dɨu‑ni ducaⁿ càda ñaha dava cue ñáyiu cùu déhe xii tǎtǎ‑yu ndɨhɨ nǎnǎ‑yu, chi cuáha cuèndá ñáhǎ‑yu núú cuè tée cùchiuⁿ cuendá cahni ñaha‑güedě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Te nchòhó chi nchaa ñáyiu ngüíta‑yu cuu úhú iní ñáhǎ‑yu xii‑ndo sǎ cuèndá‑í. Te núu na càda ndee‑ni iní‑ndó cànchicúⁿ nihnu‑ni‑ndo ìchi‑í cuěi nándɨ sá ná càda ñahá‑yu xii‑ndo ndèé ná sàá nduu vǎ cúndècu‑gá‑ndó ñùyíú‑a ña, te nduu táhú‑ndó cùndecu‑ndo nɨ caa nɨ quɨ́hɨ́ⁿ ndɨhɨ Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Te núu ɨɨⁿ ñuú cuìní‑güedé tnɨɨ ñaha‑güedě xii‑ndo càda úhú ñáhá‑güedě sá cuèndá‑í, te cunu‑ndo nǔú‑güedě quɨ́hɨ́ⁿ‑ndó ɨ̀ngá ñuú. Te na càchí tnúhu ndáá‑í xii‑ndo sǎ cùmání‑gǎ quɨ́hɨ́ⁿ‑ndó nchàa dava‑gá ñuú núú xǐndecu ñáyiu isràél cáháⁿ‑ndó tnǔhu‑í, te sa quixi tucu yúhú, Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","’Te nchòhó xìní‑ndó sǎ nì ɨɨⁿ tée dàcuaha ñá túú cùnuu‑dé dàcúúxí mèstrú‑dé, te núu mèstrú tée‑áⁿ nǎndɨ yǎha‑dé ndécú‑dě te tàú‑dé nduu vétú iní‑dé te núu tnàhá‑dé yǎha‑dé dàtná yǎha mèstrú‑dé‑áⁿ. Te dɨu‑ni ducaⁿ sǎtnahá tucu‑xi cùu ɨɨⁿ tée xìnu cuechi, chi ñá túú cùnuu‑dé dàcúúxí pàtróóⁿ‑dě, te nchaa sá yǎha pàtróóⁿ‑dě‑áⁿ te tàú‑dé nduu vétú iní‑dé te núu tnàhá‑dé yǎha‑dé dàtná yǎha pàtróóⁿ‑dě‑áⁿ. Te núu yúhú Yaá táxí tnùní ñáhá xìi‑ndo cachí‑yu sá cúù‑í sácuíhná, te uuⁿ‑gá ducaⁿ cǔñàhá‑yu xii nchòhó cue tée cùndɨhɨ‑í. ");
INSERT INTO milNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Te nchòhó vá yùhú‑ndó nǔú ñǎyiu. Chi nchaa tnúhu sá cúú yùhu ni cuu vá cúú yùhu‑gá, chi nchaa dacuɨtɨ́í sǎ quéé tǔu‑xi núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Te nchaa tnúhu sá càchí tnúhu‑í xii‑ndo nǔú méé nǔú ɨ́ɨ́ⁿ‑ó, cùu‑xi tnúhu sá ndúú yùhu ni cuu datúu‑ndo nǔú cuè ñáyiu cuěi núú chítú nǔú tàcá. ");
INSERT INTO milNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Te xìni ñuhu‑xi sá vǎ yùhú‑ndó cuè ñáyiu cuěi na càhni ñahá‑yu xii‑ndo, chi dɨu‑ni yɨquɨ cùñú‑ndó ndàcú‑yu cahní‑yu, dico ñá túú nǎgá ndacú‑yu cada ñàhá‑yu xii‑ndo. Te tàú‑ndó sǎ Yǎ Ndiǒxí yùhú‑ndó chi Yaá‑áⁿ ndacu‑gá danàa‑gá yɨquɨ cùñú‑ndó, te ndacu‑gá daquɨ̀hɨ́ⁿ ñáhá‑gǎ xii‑ndo nǔú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Te nchòhó xìní‑ndó sǎ ndèé úú tnàhá tɨ́laá cúyǎhu‑dɨ núú ɨ́ɨ́ⁿ‑ní dǐhúⁿ, te ni ɨ̀ɨⁿ‑dɨ ñá túú xìhí cùtexínu‑dɨ chi ndéé nǔu mee Yǎ Ndiǒxí Yaá cúú Tǎtá‑ndó ná càchí‑gá te xìhí‑dɨ. ");
INSERT INTO milNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dico nchòhó chi ío‑gá néhé cuèndá ñáhá Yǎ Ndiǒxí xii‑ndo chi ndéé idi dɨ́quɨ́‑ndó yɨ̀ndehu. ");
INSERT INTO milNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Núu xíǎⁿ càchí‑í sá vǎ yùhú‑ndó chi cùnuu‑gá‑ndó dàcúúxí tɨ̌laá cuěi vài vihi‑güedɨ. ");
INSERT INTO milNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Te na càchí tnúhu‑í xii‑ndo sǎ ncháá ñǎyiu na dàtúu núú tnàha ñáyiu‑xi sá ndécú ndɨ̀hɨ ñahá‑yu xii‑í, te ducaⁿ te tnàhá yúhú dàtúu‑í núú Tǎtà‑í Dútú Ndiǒxí Yaá ndécú àndɨu sá ndécú ndɨ̀hɨ‑í‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Dico nchaa ñáyiu na cǔñaha xìi tnaha ñáyiu‑xi sá ñà túú ndècu ndɨhɨ ñahá‑yu xii‑í, te dɨu‑ni ducaⁿ càda yúhú tucu chi cúñaha‑ǐ xii Tǎtà‑í Dútú Ndiǒxí Yaá ndécú àndɨu sá ñà túú ndècu ndɨhɨ‑í‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Te na càchí tnúhu‑í xii‑ndo sǎ vǎ cání ìní‑ndó sǎ yǔhú véxi‑í ñuyíú‑a te cuu ɨɨⁿnuu‑gǎ ñáyiu cundecú‑yu, chi da ngüǐta‑yu vá cúú ɨ̀ɨⁿnuu‑gá‑yu cundecú‑yu, te ducaⁿ chi nchaa ñáyiu vá quɨ̀ndáá iní ñáhá xìi‑í ñáyiu‑áⁿ ngǒo‑yu cuu úhú iní‑yu nchaa ñáyiu quɨndáá iní ñáhá xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Te dava cue tée xǐndecu tǎtá‑xi te ngóo‑güedé cuu úhú iní‑güedé tǎtá‑güedě, te dɨu‑ni ducaⁿ càda cue ñáyiu dɨ̀hɨ́ xǐndecu nǎná‑xi, chi ngóo‑yu cuu úhú iní‑yu nǎnǎ‑yu, te dɨu‑ni ducaⁿ càda tucu cue ñáyiu cùu sánu, chi ngóo‑yu cuu úhú iní‑yu nǎná yɨɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Te ndɨ mèé‑yu vehé‑yu ngóo‑yu vá cúú ɨ̀ɨⁿnuu‑gá‑yu cundecú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Te na càchí tnúhu tucu‑í xii‑ndo sǎ ncháá ñǎyiu ío‑gá ná cùu iní tǎtá‑xi àdi náná‑xi dàcúúxí yǔhú, te ñáyiu‑áⁿ ñà túú tàú‑yu cundecu ndɨhɨ ñàhá‑yu xii‑í, te nchaa ñáyiu ío‑gá ná cùu iní déhe ducuⁿ‑xi, àdi déhe yoco‑xi dàcúúxí yǔhú, te dɨu‑ni ducaⁿ ñà túú tàú‑yu cundecu ndɨhɨ ñàhá‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Te nchaa ñáyiu vá cánchǐcúⁿ nihnu ñaha xìi‑í cuèndá sá yùhú‑yu ndohó‑yu dàtná ndoho‑í ñáyiu‑áⁿ ñà túú tàú‑yu cundecu ndɨhɨ ñàhá‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Te cue ñáyiu na yùhú cuú sá cuèndá‑í te ñáyiu‑áⁿ cuǐta nihnú‑yu, dico nchaa ñáyiu vá yùhú cuú sá cuèndá‑í, te ñáyiu‑áⁿ nduu táhǔ‑yu cundecú‑yu nɨ caa nɨ quɨ́hɨ́ⁿ ndɨhɨ Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Te nchaa ñáyiu na quèheⁿ cuendá ñáhá xìi‑ndo te cada iní‑yu sá tnàhá yúhú ní queheⁿ cuèndá‑yu. Te nchaa ñáyiu na quèheⁿ cuendá ñáhá xìi‑í, te cada iní‑yu sá tnàhá Tǎtà‑í Dútú Ndiǒxí Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a ní queheⁿ cuèndá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Te nchaa ñáyiu na quèheⁿ cuendá ɨɨⁿ tée càháⁿ tnúhu Yá Ndiǒxí cuèndá sá quídé‑dě chìuⁿ‑gá, te dàtná‑ni càa táhú cuǎñaha‑gǎ nduu táhú těe ducaⁿ càháⁿ tnúhu‑gá‑áⁿ, dɨu‑ni ducaⁿ cùnduu táhú cuǎñaha‑gǎ nduu táhú ñǎyiu ducaⁿ na quèheⁿ cuendá ñáhá xìi‑dé. Te nchaa ñáyiu na quèheⁿ cuendá ɨɨⁿ tée quìde váha cuèndá sá dúcáⁿ quìde váha‑dé, te dàtná‑ni càa táhú nduu táhú těe‑áⁿ dɨu‑ni ducaⁿ cùnduu táhú nduu táhú ñǎyiu na quèheⁿ cuendá ñáhá xìi‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Te nchaa ñáyiu na cuǎñaha ɨ̀ɨⁿ yaxiⁿ ndute coho ɨɨⁿ ñáyiu cùu cuendá‑í cuèndá sá nǐ tuha ñàhá‑yu xii‑í cuěi ñá túú cùnuu vihí‑yu, te ñáyiu ducaⁿ na cuǎñaha ndùte‑áⁿ nǐhǐ‑yu sá ndúú tǎhǔ‑yu núú Yǎ Ndiǒxí —càchí Jèsús xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Te sátá nǐ yáha ducaⁿ nǐ xáhaⁿ Jèsús xii ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá, te ní xica‑gá cuáháⁿ‑gá nchaa ñuú cáá yàtni xíáⁿ dánèhé‑gá ñáyiu tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Te té Juàá yɨ̀hɨ‑dé vecaá te ní níhí‑dě tnúhu nchaa nàcuáa quìde Xítohó Jesucrìstú. Te sátá dúcáⁿ te ní tendaha‑dě ɨɨⁿ ǔú cue tée xìca cuu ndɨhɨ‑dé cuáháⁿ‑güedé núú ndécú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Te òré ní quexìo‑güedé núú ndécú‑gǎ, te xìcáⁿ tnúhú‑güedě núú‑gǎ nàcuáa ní xáhaⁿ tě Juàá xii‑güedé, te xǎhaⁿ‑güedě xii‑gá: —Véxi‑ndɨ́ xìcáⁿ tnúhú‑ndɨ̌ núú‑n nǔu sá dɨ́ú‑n cùu‑n Cristú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a, àdi sá cúndètu nahi‑ni‑ndɨ́ mei Yàá‑áⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí cuánùhú te cani‑ndo cuèndú núú tě Juàá nchaa sá nǐ xiní‑ndó quìde‑í, ndɨhɨ nchaa nàcuáa ndùu tnúhu ní cáháⁿ‑í ní xíndedóho‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Te cúñaha‑ndo xìi‑dé sá quídé tǎtna‑í núú cuè ñáyiu cuàá, te quìde tátna‑í cue ñáyiu yacua, ndɨhɨ cue ñáyiu tnàhá cuéhé sǎ dátèhyú nihnu‑xi yɨquɨ cùñú‑yu, ndɨhɨ cue ñáyiu doho, nchaa ñáyiu‑áⁿ quídé tǎtna‑í, te ndǔha‑yu, te ndéé tnàhá cue ñáyiu sa ní xíhí dándòto‑í cúñaha‑ndo. Te cúñaha tùcu‑ndo xii‑dé sá nděcuu‑í dánèhé‑í nchaa ñáyiu ndàhú, tnúhu sá sánú ìchi ñaha xií‑yu nàcuáa naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Te cúñaha tùcu‑ndo xii‑dé sá ǐo váha táhú nchaa ñáyiu ñá túú quìde sáá iní‑xi nchaa tnúhu càháⁿ‑í, duha cúñaha‑ndo xìi‑dé —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Te sátá nǐ yáha‑güedé cuánuhú‑güedé te ní ngüíta Jèsús ní cáháⁿ‑gá núú ñǎyiu cuèndá té Juàá, te xǎhaⁿ‑gǎ xií‑yu: —Nchòhó ní sáháⁿ ndéhé‑ndó ɨ̀ɨⁿ tée ndècu xɨtɨ́ yucu, te tée‑áⁿ ñà túú sàni ɨɨⁿ sani úú iní‑dé, chi ñá túú quìde‑dé dàtná quídé nchàa ité náhnú cuǎháⁿ‑xi duha cuáháⁿ‑xi dàcáⁿ òré quéné tǎchí. ");
INSERT INTO milNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Te ni ñà túú ní sǎháⁿ ndéhé‑ndó ɨ̀ɨⁿ tée nìhnu dóó vǎha dóó vii càa. Te nchòhó xìní‑ndó sǎ ncháá ñǎyiu nìhnu dóó vǎha dóó vii càa xíndecú‑yu vehe cue tée cùnuu yɨndaha ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dico nchòhó chi ní sándéhé‑ndó ɨ̀ɨⁿ tée càháⁿ tnúhu Yá Ndiǒxí, te ndáá sá dɨ́ú ɨ̀ɨⁿ tée càháⁿ tnúhu‑gá cúú‑dě, te cùnuu‑gá‑dé dàcúúxí dàva‑gá cue tée càháⁿ tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Te dɨu cuèndá té Juàá‑áⁿ càháⁿ‑xi núú tùtú Yǎ Ndiǒxí nàcuáa ní xáhaⁿ‑gǎ xii Crìstú, te duha ní xáhaⁿ‑gǎ: Tendaha‑ǐ ɨɨⁿ tée cáháⁿ‑dé tnúhu‑í codonùu‑dé núú‑n, cuèndá dàtúha‑dé ñáyiu cuèndá quɨ́ndáá iní‑yu tnúhu‑n. Duha ní xáhaⁿ‑gǎ, te ducaⁿ nǐ ngódó tnùní núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nì ɨɨⁿ cue tée ñuyíú‑a ñá túú cùnuu‑güedé dàtná cúnùu té Juàá tée dàcuandute ñaha xii ñáyiu. Te nchaa ñáyiu sa ta ndɨ̌hu ndaha ñàha Yá Ndiǒxí vitna cuáháⁿ cúnùu‑gá‑ni tucú‑yu dàcúúxí tě Juàá cuěi cùú‑yu ñáyiu ñá túú cùnuu dacúúxí dàva‑gá ñáyiu yɨ̀ndaha‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Te ndéé cútnàhá ní ngüíta té Juàá tée dàcuandute ñaha xii ñáyiu càháⁿ‑dé tnúhu Yá Ndiǒxí ñuyíú‑a, ndéé dàvá‑áⁿ nǐ ngüíta ñáyiu cuìní‑yu sá ndɨ̌hu ndaha ñàha Yá Ndiǒxí xií‑yu te ndùcu ndeé‑yu quìdé‑yu nàcuáa ndɨ́hu ndaha ñàha‑gá xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Te nchaa cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǐ cáháⁿ‑güedé sá dɨ́ú‑gǎ ndɨ́hu ndaha‑gǎ cue ñáyiu, te dɨu‑ni ducaⁿ nǐ cáháⁿ tucu ndíi Moìsés ní ngódó tnùní núú tùtú ndíi. Te dɨu‑ni ducaⁿ cùnuu nchaa tnúhu‑áⁿ càháⁿ‑xi nàcuáa ndɨ́hu ndaha Yǎ Ndiǒxí ñáyiu ndéé ní sáá nduu nǐ ngüíta té Juàá càháⁿ‑dé tnúhu‑gá ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Te na càchí tnúhu‑í xii‑ndo sǎ cádá cuèndá‑ndó, chi núú tùtú Yǎ Ndiǒxí càchí‑xi sá ndíxí tě Èliás, te dɨu núú tě Èliás‑áⁿ nǐ quide té Juàá. ");
INSERT INTO milNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Te nchaa nchòhó ñáyiu ndèdóho nchaa tnúhu càháⁿ‑í‑a te ío váha chí cuǎha cuèndá. ");
INSERT INTO milNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Te na càchí tnúhu tucu‑í xii‑ndo nàcuáa sǎtnahá‑xi cùu ñáyiu ndècu vitna. Chi ñáyiu‑áⁿ cúǔ‑yu dàtná cue landú sácǒo núú yǎhu dàdɨquɨ‑güexi te níhi càháⁿ‑güexi, te xǐtnàha‑güexi ndɨ mee landú‑güexi: ");
INSERT INTO milNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ní tɨú‑ndɨ́ yaá ndɨhɨ vǐlu te ñá túú ní cuìní‑ndó càta‑ndo. Te ío yica ìní ní xita yuhu‑ndɨ̌ te ñá túú ní ndǎhyú‑ndó”, càchí‑güexi xǐtnàha‑güexi. Te ducaⁿ sǎtnahá‑xi cùu ñáyiu ndècu vitna, ");
INSERT INTO milNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","chi té Juàá ío ndàhú ní xóo caxi‑dé, te ni ñà túú ní xǒo coho‑dé ndudí ndéhé yoho yàha stilé sá sà ní nduu‑xi ndidí, te sá dúcáⁿ nǐ xóo cada‑dé te ní cachí‑yu sá nǐ xíndecu ndɨhɨ‑dé espíritú cúndɨ̀hɨ yucu ñávǎha. ");
INSERT INTO milNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Te sátá nǐ quexìo yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, te xèxi‑í xìhi‑í quídè‑í, te càchí‑yu sá yǔhú cúù‑í ɨɨⁿ tée xèxi vihi te xìhi vihi, te càchí tucú‑yu sá cúù‑í tée xìca cuu ndɨhɨ cue tée cuihna ìní‑xi quìde cobrá ñáhá xìí‑yu cuèndá impuèstú ndɨhɨ nchaa dava‑gá cue tée ndècu ichi cuehé ichi duha, duha càchí‑yu. Te ñáyiu ní tnahá tnúhu ndɨhɨ Yá Ndiǒxí, ñáyiu‑áⁿ quídě‑yu sá vǎha nàcuáa cutnùní sá méé‑gǎ ío ndècu ndɨhɨ‑gá sá xìní tnùní‑gá —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Te Jèsús ní ngüíta‑gá càháⁿ‑gá dóho nchaa ñáyiu ñuú núú ǐo‑gá vài núú sǎ vǎ yǒo tnàhí ndàcu cada ní quide‑gá, chi nchaa ñáyiu ñuú‑áⁿ ñà túú cuìní‑yu ndixi túu iní‑yu sá ñà túú quìde váha‑yu ndècú‑yu, te xǎhaⁿ‑gǎ xií‑yu: ");
INSERT INTO milNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Ndàhú nchòhó cue ñáyiu ñuú Coràzín! ¡Te ndàhú nchòhó cue ñáyiu ñuú Bètsaidá! Chi núu dìcó ñuú Tìrú ndɨhɨ ñuú Sìdón ní quìde‑í nchaa sá vǎ yǒo tnàhí ndàcu cada datná ní quide‑í ñuú‑ndó‑á nǐ xiní‑ndó ñá, te sá ndéé ama‑gá cuihnú‑yu dóó ndàhú te cunu cóo‑yu núú yàá cuèndá sá ndíxí cuěchi iní‑yu sá ñà túú quìde váha‑yu ni cùu. ");
INSERT INTO milNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Dico sáá nduu te ío‑gá dandòho ñaha Yá Ndiǒxí xii‑ndo dàcúúxí ñǎyiu ñuú Tìrú ndɨhɨ ñáyiu ñuú Sìdón. ");
INSERT INTO milNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Te nchòhó cue ñáyiu ñuú Capèrnaúm ío quìde cahnu‑ndo mee‑ndo, te quìde iní‑ndó sǎ sà cuándaa‑ná‑ndó àndɨu, dico ñáhá chi núú ùhú núú ndàhú nduu táhú‑ndó cùndecu‑ndo. Te núu dìcó ñuú Sòdomá ní quìde‑í nchaa sá vǎ yǒo tnàhí ndàcu cada datná ní quide‑í ñuú‑ndó nǐ xiní‑ndó ñá, te ñáyiu‑áⁿ vǎ náǎ‑yu chi cundecu‑ní‑yu ndéé vitna ni cùu. ");
INSERT INTO milNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Te na càchí tnúhu‑í xii‑ndo sǎ sàá nduu te ío‑gá dandòho ñaha Yá Ndiǒxí xii‑ndo dàcúúxí ñǎyiu ñuú Sòdomá —càchí‑gá xǎhaⁿ‑gǎ xii nchaa ñáyiu ñuú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Te sátá xǐǎⁿ te Jèsús ní ngüíta‑gá càháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te xǎhaⁿ‑gǎ: —Yòhó Tǎtà‑í Dútú Ndiǒxí, ío chìñuhu ñaha‑í xii‑n chi dɨu‑n tàxi tnuní‑n àndɨu ndɨhɨ ñuyíú‑a, te dànehé‑n cuè ñáyiu nchaa tnúhu váha, te dɨu‑ni ñáyiu‑áⁿ cúǔ‑yu ñáyiu ñá túú cùtnuní iní‑xi nchaa tnúhu càháⁿ cue tée càchí sá ǐo túha, te nchaa tnúhu váha‑áⁿ ñà túú dàtúu‑n nǔú ñǎyiu càchí sá ǐo túha te ío váha sàá dɨ́quɨ́‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chi ducaⁿ cuìní‑n cùnduu —cachí‑gá xǎhaⁿ‑gǎ xii Tǎtá‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Te xǎhaⁿ‑gǎ xii nchaa ñáyiu xǐndecu‑áⁿ: —Mee Tǎtà‑í Dútú Ndiǒxí ní cachí‑gá sá cúnùu‑í núú nchàandɨ túhú sá ìó. Te vá yǒo ɨɨⁿ‑gá xìní nàcuáa sàni iní yúhú Déhe Dútú Ndiǒxí, chi ɨɨⁿdìi díí‑ni mee‑gǎ xìní‑gá nàcuáa sàni iní‑í, te mee‑ǐ xìní‑í nàcuáa sàni iní méé‑gǎ. Te nchaa ñáyiu càchí iní‑í sá quìní‑yu nàcuáa sàni iní Tǎtà‑í Dútú Ndiǒxí te xǐtnǔhu‑í‑yu, te vá yǒo ɨɨⁿ‑gá xìní chi dɨu‑ni ñáyiu ducaⁿ xǐtnǔhu‑í‑áⁿ xìní‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Te nchaa nchòhó ñáyiu ñá túú ndècu váha, ñáyiu ñá túú nìhí nàcuáa cada cundecu váha iní‑xi quixi‑ndo tùha ñaha‑ndo xii‑í nàcuáa ducaⁿ cùndecu váha iní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Te cuu vii cuu váha iní‑ndó tnɨ̀ɨ‑ndo nchaa tnúhu càháⁿ‑í, te ío dacuàha‑ndo, te ducaⁿ càda‑ndo chi yúhú ío càhnu iní‑í, te ío ndàhú iní‑í. Te núu ducaⁿ na càda‑ndo te ío váha cuu iní‑ndó cùndecu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Te tnɨɨ‑ndo nchàa tnúhu càháⁿ‑í chi ñá túú cùu‑xi ɨɨⁿ sá věe, chi cada iní‑ndó sǎ cúú‑xí dàtná ɨɨⁿ chìuⁿ ñamá —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Te ɨɨⁿ nduu cùu‑xi nduu ndetatú ñáyiu ñùhu Jesús ichi ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te ta yǎha‑gá ndɨhɨ‑güedé ɨɨⁿ xichi núú cáá trìú te xǐxíhí‑güedé docó nǔu xíǎⁿ ní ngüíta‑güedé sàhnú‑güedé yoco trìú‑áⁿ, te ndɨhɨ ndaha‑güedé quɨ́ɨ́ⁿ‑güedě quéé trìú‑áⁿ tá xèxi‑güedé cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Te cue tée cùu fariséú ní xiní‑güedé nàcuáa quìde cue tée xìca cuu ndɨhɨ Jesús, núu ní xáhaⁿ‑güedě xii‑gá: —¿Ná cuèndá ducaⁿ quìde cue tée xìca cuu ndɨhɨ‑n sahnú‑güedé yoco trìú, te vitna cùu‑xi nduu ndetatú‑i? Te ñá túú tàú‑güedé ducaⁿ càda‑güedé —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —¿Náa ñá túú dàcuaha‑ndo núú tùtú Yǎ Ndiǒxí núú càháⁿ‑xi nàcuáa ní quide ndíi Dàvií cútnàhá ní xíhí ndíi docó ndɨhɨ cue tée ní xica cuu ndɨhɨ ndíi‑ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Chi ndíi‑áⁿ nǐ quɨ́hu ndíi vehe Yá Ndiǒxí ní queheⁿ ndíi pàá ní cuu íí ndécú‑ǎⁿ nǐ xexi ndíi ndɨhɨ cue tée ní xica cuu ndɨhɨ ndíi, te ñá túú tàú ndíi sá dúcáⁿ càda ndíi ndɨhɨ cue tée‑áⁿ ní cùu, chi mee‑ni cuè dútú tàú‑güedé caxi‑güedé pàá‑áⁿ ní cùu. ");
INSERT INTO milNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Te náa ñá túú xìní‑ndó nàcuáa càháⁿ‑xi núú tùtú ndíi Moìsés sá ncháá cuè dútú vǎ ndétàtú‑güedé nduu cùu‑xi nduu ndetatú‑ǎⁿ? Te ñá dɨ́ú ɨ̀ɨⁿ cuéchi cùu‑xi sá dúcáⁿ ñà túú ndètatú‑güedé nduu cùu‑xi nduu ndetatú. ");
INSERT INTO milNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Te na càchí tnúhu‑í xii‑ndo sǎ yǔhú cúù‑í tée ío‑gá cúnùu ndecu ndɨhɨ‑ndo dacúúxí vèñúhu sá ǐo cùnuu. ");
INSERT INTO milNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dico nchòhó chi ñá tècú tnùní‑ndó nàcuáa càháⁿ Yǎ Ndiǒxí núú tùtú‑gá núú càchí‑xi: “Yúhú cuìní‑í sá cúndàhú iní‑ndó cuè tnaha ñáyiu‑ndo te ñá dɨ́ú mèe‑ni sá cáhní‑ndó quɨ̀tɨ nduu táhù‑í”, duha càchí‑gá núú tùtú‑gá. Te núu dìcó nchòhó tècú tnùní‑ndó ñá, te vá càháⁿ cuèhé‑ndó cuèndá nchaa ñáyiu ñá túú ndècu cuéchi‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Te yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, tnàhá‑í ndécú ndɨ̀hɨ‑í tnúhu ndee ìní sá cǔu‑í nchaa ñáyiu nàcuáa cadá‑yu nduu ndètatú‑ó‑á —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Te Jèsús ní xica‑gá cuáháⁿ‑gá, te cuánguɨhu‑gá xɨtɨ́ ɨɨⁿ veñúhu. ");
INSERT INTO milNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Te xíáⁿ ndécú ɨ̀ɨⁿ tée ní yíchí ɨɨⁿ xio ndaha‑dé. Te dava cue tée xǐndecu‑áⁿ ndúcú‑güedě nàcuáa cada‑güedé cacáⁿ cuéchi‑güedé cuèndá‑gá núú cuè tée cùnuu, te ní xícáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě: —Cachí tnúhu xii‑ndɨ́ nǔu cuu cada tátna‑o ɨ̀ɨⁿ tée cùhú nduu cùu‑xi nduu ndetatú‑ó ǎⁿ ñǎhá —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te nchòhó òré ná ngàunihnu ɨɨⁿ mbéé‑ndó ɨ̀ɨⁿ déhvá cùnú te nàtava‑ndo‑dɨ cuéi cùu‑xi nduu ndetatú‑ó. ");
INSERT INTO milNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Te ɨɨⁿ ñáyiu ío‑gá cúnùú‑yu dàcúúxí ɨ̀ɨⁿ mbéé, núu xíǎⁿ tàú‑ó sǎ cádá‑ó sǎ vǎha sá cúú‑xǐ‑yu cuěi cùu‑xi nduu ndetatú‑ó —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Te dǎtnùní ní xáhaⁿ‑gǎ xii tée cùhú ndaha‑xi‑áⁿ: —Ndacani ndaha‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te tée‑áⁿ nǐ ndacani‑dé ndaha‑dé, te òré‑ni ní ndúha ní nduu‑xi dàtná cáá ɨ̀ngá xio ndaha‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Te cue tée cùu fariséú ní ndee‑güedé xɨtɨ́ veñúhu, te ní ngüíta‑güedé ndátnǔhu‑güedé nǔu nása cada‑güedé cahni‑güedé Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Te sátá nǐ cutnùní iní Jèsús nàcuáa cuìní‑güedé cada ñaha‑güedě xii‑gá te ní xica‑gá cuáháⁿ‑gá, te ío vài ñáyiu nchìcúⁿ ñáhá xìi‑gá cuáháⁿ, te tnàhá cue ñáyiu cùhú nchìcúⁿ ñáhá xìi‑gá cuáháⁿ, te ní quide tátna‑gá cue ñáyiu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Te ní xáhaⁿ‑gǎ xií‑yu sá vǎ càháⁿ‑yu yoo cùu‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa ní xáhaⁿ Yǎ Ndiǒxí xii ndíi Chàiá tée ní xóo cáháⁿ tnúhu‑gá ndéé sanaha nǐ chídó tnùní ndíi núú tùtú‑gá, te duha ndùu tnúhu ní xáhaⁿ‑gǎ: ");
INSERT INTO milNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Tée‑a cùu‑dé tée ní sani iní‑í sá cúnú cuèchi‑dé núù‑í, te ío cùu iní‑í‑dé, te cùdɨ́ɨ́ ìní‑í‑dé. Te yúhú cuáñaha‑ǐ Espíritú‑í cundecu ndɨhɨ‑dé, te dɨu‑dé cúñaha‑dě xii nchaa ñáyiu ñuyíú sǎ yǔhú ío ndáá quídè‑í. ");
INSERT INTO milNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Te vá dácàá‑dé tnúhu cáháⁿ‑dé ndɨhɨ ñáyiu, te ni vǎ cáná sàa‑dé òré cáháⁿ‑dé, te ni vǎ yǒo níhí tnǔhu nása cáháⁿ‑dé cuhuⁿ‑dé ichi. ");
INSERT INTO milNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Te ni ñà túú nǎ cada‑dé cue ñáyiu cùu datná ɨɨⁿ tnu ndǒó sá cuìní‑xi tnáhnú, te dɨu‑ni ñáyiu‑áⁿ cúú tùcú‑yu dàtná ɨɨⁿ mèchá càndíl sá ǐo quène ñúhmá te cuìní‑xi ndahvá. Te ducaⁿ sǎtnahá‑xi cùu ñáyiu‑áⁿ chi ñá túú nìhí ndéě‑yu cundecú‑yu sá cúú‑xì‑í, te mee‑ni sǎ vǎha cada ñaha‑dě xií‑yu, te dɨu‑ni ducaⁿ càda‑dé ndéé sáá nduu cùtnuní iní nchaa ñáyiu sá ǐo ndáá quídé‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Te nchaa ñáyiu nɨhìí ñuyíú ǐo cundee cùu cahnu iní ñáhǎ‑yu xii‑dé. Duha ní xáhaⁿ‑gǎ xii ndíi Chàiá ní chídó tnùní ndíi núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Te ní quexìo ɨɨⁿ úú cue tée núú ndécú Jèsús, te ndèca‑güedé ɨɨⁿ tée ñɨ̀hɨ́ te cuàá‑dé, te yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha xii‑dé, te Jèsús ní queñuhu‑gá espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii‑dé, te òré‑ni‑áⁿ nǐ cuu ní nacáháⁿ‑dé te ní ndúha núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Te nchaa ñáyiu xǐndecu‑áⁿ ǐo ní cuñúhu‑yu sá dúcáⁿ nǐ quide‑gá, te ní xítnàhá‑yu: —Váa tée‑a cùu‑dé ñaní tnáhá ndǐi Dàvií tée tendaha Yǎ Ndiǒxí quixi ñuyíú‑a —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Te cue tée cùu fariséú ní tecú dóho‑güedé nàcuáa ndùu tnúhu xǐtnàhá‑yu, núu xíǎⁿ ní xítnàha‑güedé: —Tée‑a ndèñuhu‑dé nchaa espíritú cúndɨ̀hɨ sácuíhná yɨ́hɨ́ ñàha xii ñáyiu, chi dɨu‑ni sácuíhná‑ǎⁿ chíndèe ñaha‑xi xii‑dé te dɨu‑ni‑xi tàxi tnuní‑xi nchaa espíritú‑áⁿ —duha ní xítnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Te Jèsús ní cutnùní iní‑gá nàcuáa ndùu tnúhu ní xítnàha‑güedé, núu ní xáhaⁿ‑gǎ xii‑güedé: —Te nchòhó xìní‑ndó sǎ nǔu ɨɨⁿ tée yɨ̀ndaha ɨɨⁿ nacióⁿ vá cúú ɨ̀ɨⁿnuu‑dé ndɨhɨ cue tée cùndɨhɨ‑dé, te vá cúdǐi‑dé cunuu‑dě. Te dɨu‑ni ducaⁿ sǎtnahá tucu‑xi cùu tucu cue tée cùchiuⁿ ɨɨⁿ ñuú, chi núu vá cúú ɨ̀ɨⁿnuu‑güedé cundecu‑güedé, te vá cúdǐi‑güedé cundecu‑güedé taxi tnùní‑güedé. Te dɨu‑ni ducaⁿ sǎtnahá tucu‑xi cùu cue ñáyiu xǐndecu ɨɨⁿ‑ni vèhe, chi núu vá cúú ɨ̀ɨⁿnuú‑yu cundecú‑yu te vá cúdǐi‑yu cundecu càhnú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Te núu sácuíhná ducaⁿ quìde‑xi queñuhu‑xi cue espíritú cúndɨ̀hɨ‑xi yɨhɨ ñaha xii ñáyiu ña, te ñá túú cùu ɨɨⁿnuu‑xi ndecu‑xi te núu ducaⁿ, te vá cúdǐi sácuíhná‑ǎⁿ cundecu‑xi taxi tnùní‑xi te núu ducaⁿ quìde‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Te duha càháⁿ‑í chi nchòhó càchí‑ndó sǎ chíndèe ñaha sácuíhná xii‑í quéñùhu‑í nchaa espíritú cúndɨ̀hɨ‑xi yɨhɨ ñaha xii ñáyiu. Te núu yúhú quídé cuèndá‑ndó sǎ sàcuíhná chíndèe ñaha‑xi xii‑í, te xìni ñuhu‑xi cada cuendá‑ndó yòo chindee ñaha xii cue tée xìca cuu ndɨhɨ‑ndo queñuhu‑güedé nchaa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu. Te mee‑güedě càchí‑güedé sá nchòhó ñá túú càháⁿ ndáá‑ndó sǎ dúcáⁿ càháⁿ‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dico yúhú chi Espíritú Yǎ Ndiǒxí chíndèe ñaha‑xi xii‑í quéñùhu‑í nchaa espíritú cúndɨ̀hɨ sácuíhná yɨ́hɨ́ ñàha xii ñáyiu, te sá dúcáⁿ chìndee ñaha Espíritú‑gá xii‑í, xíǎⁿ cútnùní sá sà ní sáá nduu cuìní‑gá ndɨ́hu ndaha ñàha‑gá xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Te nchòhó xìní‑ndó sǎ cuè ñadúhú chi vá ndácú‑güedě cuèndá‑ni quɨ́hu‑güedé duhu‑güedě vehe ɨɨⁿ tée ío ndee, chi díhna‑gá xíní ñùhu‑xi tnɨɨ‑güedé tée‑áⁿ dacùtu ñaha‑güedé xii‑dé dǎtnùní ducaⁿ te ndacu‑güedé duhu‑güedě nchaa sá ndécú ndɨ̀hɨ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Te nchaa ñáyiu ñá túú cùndɨhɨ ñaha xii‑í, te cùu úhú iní ñáhǎ‑yu. Te nchaa ñáyiu ñá túú chìndee ñaha xii‑í, te dàquee tɨ́hǔ‑yu chìuⁿ quide‑í. ");
INSERT INTO milNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Te na càchí tnúhu‑í xii‑ndo sǎ ncháá ñǎyiu quìde nchaa sá cuèhé sá dúhá cuu cada càhnu iní ñáhá Yǎ Ndiǒxí xií‑yu, te dɨu‑ni ducaⁿ cùu cada cahnu iní‑gá nchaa tnúhu cuèhé tnúhu duha càháⁿ‑yu. Dico cue ñáyiu na càháⁿ úhú cuèndá Espíritú‑gá, te ñáyiu‑áⁿ vǎ cádá càhnu iní ñáhá tnàhí‑gá xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Te nchaa ñáyiu na càháⁿ úhú cuèndá yúhú Tée cùu ñaní tnáhǎ‑yu nchaá‑yu, te cuu cada càhnu iní ñáhá Yǎ Ndiǒxí xií‑yu. Dico cue ñáyiu na càháⁿ úhú cuèndá Espíritú‑gá te vá cádá càhnu iní ñáhá tnàhí‑gá xií‑yu cuěi vitna ndècu vívǔ‑yu, te cuěi na cùú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Te nchòhó xìní‑ndó sǎ ndɨ̀ dɨ́ɨ́ⁿ nǔú yutnu xìní‑ó nǎ yutnu cùu‑xi cuendá sá sǎvìdí‑xi, te xìní‑ó sǎ ncháá yùtnu váha cùuⁿ mee‑ni sávìdí váha, dico nchaa yutnu sá ñà túú vǎha te cùuⁿ mee‑ni sávìdí sá ñà túú vǎha. Te duha càháⁿ‑í cuèndá cada cuèndá váha‑ndo nàcuáa ndùu chiuⁿ quide‑ndo ɨɨⁿ ɨɨⁿ‑ndo cuendá ducaⁿ cùtnuní ná ñáyiu cùu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Dico nchòhó cúú‑ndó dàtná ɨɨⁿ cóó děéⁿ chi ío cuihna ìní‑ndó, te vá cání ìní‑ndó sǎ ndácú‑ndó cǎháⁿ‑ndó ɨ̀ɨⁿ tnúhu váha, chi ío cuihna ìní‑ndó. Te nchòhó xìní‑ndó sǎ ncháá ñǎyiu càháⁿ‑yu náni véxi iní‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Te nchaa ñáyiu váha iní‑xi càháⁿ‑yu tnúhu váha, chi dɨu‑ni tnúhu váha‑áⁿ ñúhú ìní‑yu. Te nchaa ñáyiu cuihna ìní‑xi càháⁿ‑yu tnúhu cuèhé tnúhu duha, chi dɨu‑ni tnúhu cuèhé tnúhu duha‑áⁿ ñúhú ìní‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Te na càchí tnúhu‑í xii‑ndo sǎ ná sàá nduu càda ndáá Yǎ Ndiǒxí cuéchi nchaa nchòhó ñáyiu ndècu ñuyíú‑a, te nchaa tnúhu cuèhé tnúhu duha càháⁿ‑ndó cǎháⁿ‑gá sá ñà túú ní quìde váha‑ndo sǎ dúcáⁿ nǐ cáháⁿ‑ndó tnǔhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Te nàcuáa ndùu tnúhu ní cáháⁿ‑ndó ɨ̀ɨⁿ ɨɨⁿ‑ndo, te ducaⁿ cǎháⁿ Yǎ Ndiǒxí te núu ndècu cuéchi‑ndo àdi ñá túú ndècu cuéchi‑ndo. Te núu ñá túú cuěchi‑ndo te cácu‑ndo, dico núu ndècu cuéchi‑ndo te vá cǎcu‑ndo —càchí‑gá xǎhaⁿ‑gǎ xii cue tée cùu fariséú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Te cue tée cùu fariséú, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés xǎhaⁿ‑güedě xii Jèsús: —Mèstrú, cuìní‑ndɨ́ cada‑n ɨ̀ɨⁿ sá vǎ yǒo tnàhí ndàcu cada cuendá ducaⁿ cùtnuní iní‑ndɨ́ sá Yǎ Ndiǒxí chíndèe ñaha‑gá xii‑n —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ñáyiu ndècu ichi cuehé ichi duha ñá túú cuìní‑yu tnɨɨ́‑yu tnúhu càháⁿ Yǎ Ndiǒxí, te ñáyiu‑áⁿ cuìní‑yu cada‑í ɨɨⁿ sá vǎ yǒo tnàhí ndàcu cada nacuáa cutnùní iní‑yu núu ndáá sá Yǎ Ndiǒxí chíndèe ñaha‑gá xii‑í. Dico yúhú chi ñá túú nǎgá cada‑í quiní‑yu, chi sa nìhí‑yu tnúhu nàcuáa ní yáha ndíi Jònás tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, te dɨu‑ni ducaⁿ yǎha yúhú tucu. ");
INSERT INTO milNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chi ndíi Jònás‑áⁿ nǐ xúhuⁿ ndíi úní nduu úní niú xɨtɨ́ ɨɨⁿ chácá cáhnú vìhi nani ballená. Te dɨu‑ni ducaⁿ yǎha yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, chi úní nduu úní niú cuhuⁿ‑í xɨtɨ́ ñuhu. ");
INSERT INTO milNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Te na sàá nduu càda ndáá Yǎ Ndiǒxí cuéchi nchaa ñáyiu ndècu ñuyíú‑a, te dàvá‑áⁿ cachí nchaa ñáyiu ñuú Nǐnivé sá ñà túú ní quìde ndáá nchaa ñáyiu ndècu vitna, te ducaⁿ cǎháⁿ‑yu chi mèé‑yu ní dáñǎ‑yu ichi cuèhé ichi duha cútnàhá ní sáháⁿ ndíi Jònás ñuú‑yu ní cáháⁿ ndíi tnúhu Yá Ndiǒxí núǔ‑yu. Dico vitna iha ndècu ndɨhɨ ñaha‑ndo xii yúhú, te dɨu‑í ío‑gá cúnùu‑í dàcúúxí ndǐi Jònás. ");
INSERT INTO milNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Te nduu càda ndáá Yǎ Ndiǒxí cuéchi nchaa ñáyiu, te dàvá‑áⁿ quiní‑ndó ɨ̀ɨⁿ ñadɨhɨ́ ñaha ní xɨ́ndaha ɨ̀ɨⁿ nacióⁿ cáá ndàa xio datni núú quéné nchǐcanchii, te ñaha‑áⁿ ǐo xica nǐ xíndecu‑aⁿ te ní sáháⁿ‑aⁿ ní xíndedóho‑aⁿ nchaa tnúhu ní cáháⁿ ndíi Salòmón, chi ndíi‑áⁿ ǐo ní sáá sá xìní tnùní ndíi. Te tnàhá ñaha‑áⁿ cǎháⁿ‑aⁿ sá ñà túú ní quìde ndáá nchaa ñáyiu ndècu vitna. Dico vitna iha ndècu ndɨhɨ ñaha‑ndo xii yúhú, te dɨu‑í ío‑gá cúnùu‑í dàcúúxí ndǐi Salòmón. ");
INSERT INTO milNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Te òré ná quéé ñàha ɨɨⁿ espíritú cúndɨ̀hɨ yucu ñávǎha xii ɨɨⁿ ñáyiu, te cuáháⁿ‑xi ndùcu‑xi ɨɨⁿ xichi núú cúndècu‑xi te ñá nìhí‑xi te ní sani iní‑xi: ");
INSERT INTO milNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Váha‑gá núhú tucu‑í núú nǐ xíndecu‑í”, duha ní sani iní‑xi. Te cuánuhú‑xi, te òré ní nasáá‑xi, te ní xiní‑xi sá cáá ìní ñáyiu‑áⁿ dàtná cáá‑nǎ ɨɨⁿ vehe ní natɨ́hú ní nduu vií‑ná te vá yǒo‑gá ndécú. ");
INSERT INTO milNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Te sátá dúcáⁿ te ní xica‑xi cuáháⁿ‑xi cuándúcú‑xí ǔsá tnàhá espíritú cúndɨ̀hɨ‑xi sá nèhé víhí‑gǎ xǐquide. Te òré ní níhí‑xi cue espíritú‑áⁿ te ndèca ñaha‑xi cuáháⁿ cuèndá ngúndecu ndɨhɨ‑xi ñáyiu‑áⁿ. Te ñáyiu‑áⁿ uuⁿ‑gá nándɨ yáha‑yu dàcúúxí ndèé díhna. Te dɨu‑ni ducaⁿ sǎtnahá‑xi yáha nchaa ñáyiu cuihna ìní‑xi ndècu ñuyíú‑a vitna —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Te càháⁿ dúcáⁿ‑ní Jèsús ní quexìo náná‑gǎ ndɨhɨ cue ñaní‑gá cuìní‑yu cáháⁿ ndɨhɨ ñàhá‑yu xii‑gá, te ní ngúnu tnɨ́ɨ‑yu ndàa quehé vehe núú ndécú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Te ɨɨⁿ cue ñáyiu xǐndecu‑áⁿ nǐ xáhǎⁿ‑yu xii‑gá: —Ní quexìo náná‑n ndɨ̀hɨ cue ñaní‑n xǐnutnɨ́ɨ‑yu quehé, te cuìní‑yu cáháⁿ ndɨhɨ ñàhá‑yu xii‑n —càchí ñáyiu‑áⁿ xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Te ní xáhaⁿ‑gǎ xii ñáyiu ducaⁿ xǎhaⁿ xìi‑gá‑áⁿ: —Te cachí tnúhu yóndɨ‑gá ñáyiu cùu datná nǎnà‑í ndɨhɨ dàtná cue ñaní‑í —càchí‑gá xǎhaⁿ‑gǎ xii ñáyiu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Te ní dánèhé ñáhá‑gǎ nchaa cue tée xìca cuu ndɨhɨ‑gá, te ní xáhaⁿ‑gǎ xii ñáyiu‑áⁿ: —Cue tée‑a cùu‑güedé dàtná nǎnà‑í, ndɨhɨ dàtná cue ñaní‑í. ");
INSERT INTO milNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Te nchaa ñáyiu na càda nchaa nacuáa càháⁿ Tǎtà‑í Dútú Ndiǒxí Yaá ndécú àndɨu, te ñáyiu‑áⁿ cúǔ‑yu dàtná nǎnà‑í, ndɨhɨ dàtná cue ñaní‑í, ndɨhɨ dàtná cue cúha‑í —càchí‑gá xǎhaⁿ‑gǎ xii ñáyiu ducaⁿ nǐ dáyǎha tnúhu núú‑gǎ‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Te dɨu‑ni nduu‑ǎⁿ ní quee Jèsús vehe núú ndécú‑gǎ, te ní xica‑gá cuáháⁿ‑gá ní ngóo‑gá yuhu làgúná. ");
INSERT INTO milNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Te ío cuéhé ñǎyiu ní tacá núú ndécú‑gǎ. Te sá dúcáⁿ ǐo cuéhé ñǎyiu núu ní quée‑gá xɨtɨ́ ɨɨⁿ bàrcú nútnɨ̌ɨ xɨtɨ́ ndute làgúná‑áⁿ, te núú xǐǎⁿ ní ngóo‑gá, te nchaa ñáyiu‑áⁿ xǐxúcu‑yu yuhu làgúná‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Te Jèsús ní ngüíta‑gá ní cani‑gá tɨtnɨ́ cuèndú núǔ‑yu nàcuáa tecú tnùní‑yu nchaa nàcuáa ndùu tnúhu‑gá, te xǎhaⁿ‑gǎ xií‑yu: —Ɨɨⁿ tée cuángacáⁿ‑dé trìú, ");
INSERT INTO milNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","te òré ní ngüíta‑dé dǎngoyo‑dé trìú‑áⁿ, te dava ní quene ndava ní ngava ndéé ichi, te ní xiní cue tɨ́laá te ní nadatàcá‑güedɨ. ");
INSERT INTO milNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Te dava ní ngava ñuhu yadi nǔú yɨ́hɨ́ vìhi yúú, te ndɨ̌hɨ‑ni ní xínu‑xi chi ñá túú càvihi ñuhu. ");
INSERT INTO milNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Dico òré ní nayehé te ñá túú ní cùndee iní‑xi chi ní yíchí‑xi, chi ñá túú ní nǐhí quɨ̌hɨ́ⁿ cùnú yóho‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Te dava ní ngava núú yúcú ndɨ̌quɨ́ⁿ tnu ìñu, te ɨɨⁿnuu‑ni nǐ xínu‑xi ndɨhɨ tnu ìñu. Te tnu ìñu‑áⁿ nǐ sahnu‑xi te ní dánáá‑xí nchàa triú sá nǐ xínu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Dico dava‑gá trìú ní ngava núú ndécú ñùhu cocoⁿ te xíǎⁿ ío váha ní cuu, chi núú ɨ́ɨ́ⁿ‑ní trìú‑áⁿ te dava yoco‑xi ní nguɨ́hɨ ócó úxí trìú‑xi, te dava yoco‑xi ní nguɨ́hɨ únídico trìú‑xi, te dava yoco‑xi ní nguɨ́hɨ ɨɨⁿ cièndú trìú‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Te vitna nchaa nchòhó ñáyiu ní xíndedóho tnúhu ní cáháⁿ‑í‑a, te ío váha chí cuǎha cuèndá —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Te cue tée xìca cuu ndɨhɨ Jesús ní sáháⁿ‑güedé ndéé núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Ndùcu tnúhu‑ndɨ́ núú‑n nǔu ná cuèndá ducaⁿ mèe‑ni cuendú cání‑n nǔú ñǎyiu —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Te ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó chi sa càchí tnúhu Yá Ndiǒxí xii‑ndo ɨ̀ɨⁿ sá vǎtá quìní‑gá‑ndó, chi càchí tnúhu‑gá nàcuáa quìde‑gá ndɨ̌hu ndaha‑gǎ ñáyiu, dico dava‑gá ñáyiu chi ñá túú nǎ xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Te nchaa ñáyiu sa tècú tnùní te uuⁿ‑gá cuita tecú tnùní‑yu quɨ́hɨ́ⁿ, te nchaa ñáyiu ñá túú tècú tnùní te uuⁿ‑gá vá tècú tnùní‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Te xíǎⁿ nǔu duha càni‑í mee‑ni cuèndú núǔ‑yu, chi cuěi na quìní‑yu nchaa nàcuáa cuu dico ni vǎ cútnùní iní‑yu ná cuèndá ducaⁿ cùu, te cuěi na cùndedóho‑yu dico ni vǎ tècú tnùní‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Te dɨu cuèndá ñáyiu‑áⁿ nǐ xáhaⁿ Yǎ Ndiǒxí xii ndíi Chàiá tée ní xóo cáháⁿ tnúhu‑gá ndéé sanaha nǐ chídó tnùní ndíi núú tùtú‑gá núú càchí‑xi: Nchaa nchòhó cundedóho‑ndo tnǔhu càháⁿ‑í, dico ni vǎ tècú tnùní‑ndó, te cuěi na quìní‑ndó nchàa nacuáa cada‑xi, dico ni vǎ cútnùní iní‑ndó nǎ cuèndá ducaⁿ quìde‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Te ducaⁿ chi cùu‑ndo ñáyiu ío sàá iní‑xi, te cùu‑ndo ñáyiu ñá túú tècú tnùní tnúhu càháⁿ‑í, te cùu tucu‑ndo datná cue ñáyiu cuàá chi ñá túú cuìní‑ndó càda cuendá‑ndó tnǔhu‑í, te ni ñà túú cuìní‑ndó cùndedóho‑ndo, te ni ñà túú cuìní‑ndó tècú tnùní‑ndó, te ni ñà túú cuìní‑ndó nàtuha ñaha‑ndo xii‑í cuèndá cada càhnu iní‑í nchaa yícá cuěchi‑ndo nàcuáa ío váha cuu iní‑ndó cùndecu‑ndo. Duha ní xáhaⁿ Yǎ Ndiǒxí xii ndíi Chàiá ní chídó tnùní ndíi núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Dico nchòhó chi ío váha táhú‑ndó chi cùtnuní iní‑ndó nchàa nacuáa quìde‑í, te cùtnuní tucu iní‑ndó nchàa nacuáa ndùu tnúhu càháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ ǐo vài cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha ndɨ̀hɨ nchaa dava‑gá ñáyiu váha iní‑xi ní cuiní‑yu cundèhé‑yu nchaa sá ndéhé‑ndó vìtna quide‑í dico ñá túú ní xìní‑yu, te ní cuiní tucú‑yu cundedóho‑yu nchaa tnúhu ndèdóho‑ndo vìtna cáháⁿ‑í te ñá túú ní xǐndedóho‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Te vitna cundedóho váha‑ndo na càchí tnúhu‑í xii‑ndo nàcuáa quèe‑xi cuendú tée cuángacáⁿ trìú ní cani‑í núú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Te trìú sá nǐ quene ndava ní ngava ndéé ichi, xíǎⁿ cúú‑xí dàtná ñáyiu ní xíndedóho tnúhu sá càháⁿ nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu, dico ñá túú ní cuìní‑yu tnɨɨ́‑yu, chi sácuíhná cuǎháⁿ‑xi nàdatuhú‑xi iní‑yu cuèndá sá vǎ cánchìcúⁿ nihnú‑yu nàcuáa càháⁿ tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Te trìú sá nǐ ngava ñuhu yadi nǔú yɨ́hɨ́ vìhi yúú‑ǎⁿ, xíǎⁿ cúú‑xí dàtná ñáyiu ní xíndedóho tnúhu Yá Ndiǒxí te dɨ́ɨ́ ìní ní tnɨɨ́‑yu tnúhu‑gá, ");
INSERT INTO milNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","dico òré ná ngüǐta ñáyiu cúcuèhé ñáhǎ‑yu xií‑yu àdi nándɨ‑gá sá yǎha‑yu sá cuèndá tnúhu‑gá, te ñá cúndèe iní‑yu chi dàñá‑yu tnúhu‑gá cuèndá sá ñà túú nìhí ndéě‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Te trìú sá nǐ ngava núú yúcú ndɨ̌quɨ́ⁿ tnu ìñu‑áⁿ, xíǎⁿ cúú‑xí dàtná ñáyiu ní tecú dóho‑xi tnúhu Yá Ndiǒxí dico cuèé cuèé ní nacuanaá‑yu tnúhu‑gá, chi cuèndá mee‑ni sǎ ìó ñuyíú‑a ñùhu iní‑yu, ndɨhɨ cuèndá sá ǐo sàni iní‑yu cuu cuìcá‑yu, te mee‑ni nchàa xíǎⁿ ñúhú ìní‑yu te ñá túú ñùhu iní‑yu tnúhu sá nǐ xíndedóho‑yu‑áⁿ nàcuáa cada váha‑yu cundecú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dico trìú sá nǐ ngava núú ndécú ñùhu cocoⁿ‑áⁿ, xíǎⁿ cúú‑xí dàtná ñáyiu ní xíndedóho tnúhu Yá Ndiǒxí te quìdé‑yu nàcuáa càháⁿ tnúhu‑gá. Te cada iní‑ndó sǎ ñǎyiu‑áⁿ cúǔ‑yu dàtná trìú sá nǐ nguɨ́hɨ yoco‑xi ócó úxí trìú‑xi, ndɨhɨ trìú sá nǐ nguɨ́hɨ yoco‑xi únídico trìú‑xi, ndɨhɨ trìú sá nǐ nguɨ́hɨ yoco‑xi ɨɨⁿ cièndú trìú‑xi. Ducaⁿ sǎtnahá‑xi cùú‑yu chi ío váha quìdé‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Te Jèsús ní cani‑gá ɨɨⁿ cuèndú núú ñǎyiu nàcuáa tecú tnùní‑yu tnúhu‑gá, te xǎhaⁿ‑gǎ xií‑yu: —Te vitna na càni‑í ɨɨⁿ cuèndú núú‑ndó nàcuáa tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Ɨɨⁿ tée ío váha trìú ní sacáⁿ‑dé núú ñúhú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dico xɨtɨ́ niú ní sáháⁿ ɨɨⁿ tée cùu úhú iní ñáhá xìi‑dé, te ní dǎngoyo‑dé ndɨ́quɨ́ⁿ yǔcú sǎ ñà túú vǎha núú nǐ sacáⁿ‑dé trìú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Te òré vitna váha váha ní ngüíta‑xi quène yoco nchaa triú‑áⁿ, te ní xínu coyo nchaa yúcú sǎ ñà túú vǎha‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Te cue tée xìnu cuechi núú těe ní sacáⁿ trìú‑áⁿ nǐ xítnǔhu ñaha‑güedě xii‑dé sá dúcáⁿ nǐ xínu cúhú sǎ ñà túú vǎha‑áⁿ nǔú trìú‑dé, te xǎhaⁿ‑güedě: “Pàtróóⁿ, ¿nása ní cuu núu ní xínu cúhú sǎ ñà túú vǎha núú trìú‑n, te ío váha càa triú ní sacáⁿ‑n ní cùu?”, cachí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Te tée cùu patróóⁿ‑güedě‑áⁿ nǐ xáhaⁿ‑dě xii‑güedé: “Ɨɨⁿ tée cùu úhú iní ñáhá nàhi xii‑í ducaⁿ nǐ quide‑dé ní sáháⁿ‑dé ní dǎngoyo‑dé ndɨ́quɨ́ⁿ cǔhú sǎ ñà túú vǎha‑áⁿ nǔú trìú‑í nǔu ducaⁿ nǐ xínu coyo‑xi”, càchí‑dé xǎhaⁿ‑dě xii‑güedé. Te cue tée xìnu cuechi núú‑dě ní xáhaⁿ‑güedě xii‑dé: “Te núu cuìní‑n te quɨ́hɨ́ⁿ‑ndɨ́ tnuhu‑ndɨ́ nchaa cúhú sǎ ñà túú vǎha ní xínu núú trìú‑n”, càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Te tée cùu xítohó trìú‑áⁿ nǐ xáhaⁿ‑dě xii cue tée xìnu cuechi núú‑dě‑áⁿ: “Ñáhá, vá quɨ̀hɨ́ⁿ‑ndó tnùhu‑ndo, chi òré tnuhu‑ndo te tnàhá‑ni trìú quene chi càa vihi cúhú‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Váha‑gá chí dáñá ná cuìhnu nahi ndéé ná cùu triú, te dǎtnùní nducu‑ǐ cue tée quɨ́hɨ́ⁿ‑güedé tnuhu‑güedé nchaa cúhú sǎ ñà túú vǎha‑áⁿ, te dacùtu nuhní‑güedé te cahmi‑güedé, te dǎtnùní nàquehndé‑güedé trìú nacani‑güedé te nataxúha‑güedé xɨtɨ́ yacá‑í”, càchí‑dé xǎhaⁿ‑dě xii‑güedé —duha ní cani Jèsús cuèndú núǔ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Te Jèsús ní cani tucu‑gá ɨngá cuèndú núú ñǎyiu nàcuáa tecú tnùní‑yu tnúhu‑gá, te xǎhaⁿ‑gǎ xií‑yu: —Na càni‑í ɨɨⁿ cuèndú núú‑ndó nàcuáa tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Ɨɨⁿ tée ní queheⁿ‑dé ndɨ́quɨ́ⁿ yutnu nàni mostázá te nèhe‑dé cuáháⁿ ní sacáⁿ‑dé núú ñúhú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Te ndɨ́quɨ́ⁿ yutnu‑áⁿ ǐo chàhu, dico òré ná xǐnu‑xi te sàhnu‑gá‑xi dàcúúxí nchàa cúhú, te cue quɨtɨ ndàva núú tàchí cádǔha‑güedɨ tacá‑güedɨ núú dìté‑xi —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Te Jèsús ní xáhaⁿ tùcu‑gá xii ñáyiu: —Te na càchí tnúhu tucu‑í xii‑ndo nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Ɨɨⁿ ñadɨ̀hɨ́ ní chihi‑aⁿ levadùrá úní arròbá yuchi trìú, te levadùrá‑áⁿ nǐ quide‑xi ní ndaa nɨhìí yusaⁿ‑áⁿ —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Te mee‑ni cuèndú ní cani Jèsús núú ñǎyiu ndɨ tnahá òré ní dánèhé ñáhá‑gǎ xií‑yu tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Te ducaⁿ nǐ quide‑gá chi ní quee ndáá‑xi nàcuáa ní chídó tnùní ɨɨⁿ tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǔú tùtú‑gá núú càchí‑xi: Mee‑ni cuèndú cani‑í núú ñǎyiu òré danèhé‑í‑yu tnúhu‑í cuèndá tecú tnùní‑yu, te nchaa tnúhu sá vǎtá yǒo‑gá cundedóho danèhé‑í‑yu, te nchaa tnúhu‑áⁿ ndúú yùhu‑xi ndéé cútnàhá ní ngáva ñuyíú. Duha ní chídó tnùní tée‑áⁿ nǔú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Te Jèsús ní dándácá‑gǎ ñáyiu te cuánuhú‑gá vehe, te cue tée xìca cuu ndɨhɨ‑gá ní xáhaⁿ‑güedě xii‑gá: —Cachí tnúhu xii‑ndɨ́ nása quèe‑xi cuendá cúhú sǎ ñà túú vǎha càa xɨtɨ́ trìú —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Tée càchí‑í ní sacáⁿ trìú cávǎha‑áⁿ cúú yǔhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Te nchaa núú nǐ sacáⁿ tée‑áⁿ trìú cúú‑xí ñùyíú. Te tatá váha‑áⁿ cúú‑xí cuè ñáyiu yɨ̀ndaha ñaha Yá Ndiǒxí. Te nchaa cúhú sǎ ñà túú vǎha‑áⁿ cúú‑xí ñǎyiu yɨ̀ndaha ñaha sácuíhná. ");
INSERT INTO milNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Te tée ní dǎngoyo ndɨ́quɨ́ⁿ cǔhú sǎ ñà túú vǎha núú trìú‑áⁿ cúú‑dě mee sàcuíhná. Te nduu nàtehndé‑nǎ trìú‑áⁿ cúú‑xí ndùu ndɨhɨ nihnu‑ná nchaa sá ìó ñuyíú‑a. Te nchaa ñáyiu nàquehndé trìú‑áⁿ cúǔ‑yu mee‑ni cuè espíritú xínú cuèchi núú Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Te dàtná cada cue tée quɨ́hɨ́ⁿ tnuhu nchaa cúhú sǎ ñà túú vǎha‑áⁿ dacùtu nuhní‑güedé te cahmi‑güedé, ducaⁿ sǎtnahá‑xi yáha nchaa ñáyiu cùndɨhɨ yucu ñávǎha na sàá nduu. ");
INSERT INTO milNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Te yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo tendaha‑í nchaa espíritú xínú cuèchi núù‑í quɨ́hɨ́ⁿ‑xi nadatàcá‑xi nchaa ñáyiu sànu ichi cue tnaha ñáyiu‑xi ichi cuèhé ichi duha, ndɨhɨ nchaa dava‑gá ñáyiu ñá túú quìde váha, te nchaa ñáyiu‑áⁿ xǐndecú‑yu nchaa núú ndécú cuè ñáyiu yɨ̀ndaha‑í. ");
INSERT INTO milNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Te cue espíritú‑áⁿ daquɨ̀hɨ́ⁿ‑xi cue ñáyiu‑áⁿ nǔú ñùhú núú càyú, te yàcáⁿ ío ndáhyú‑yu te dìcó rúhñú‑nǎ cuu núhu‑yu sá sàtú iní‑yu sá ndóhǒ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Te nchaa ñáyiu quìde nchaa nacuáa cuìní Tǎtǎ‑yu Dútú Ndiǒxí, ñáyiu‑áⁿ ǐo cunùú‑yu cundecú‑yu núú ndécú‑gǎ táxí tnùní‑gá, chi cuú‑yu dàtná nchícanchii dayèhé‑yu cundecú‑yu núú ndécú‑gǎ. Te nchaa nchòhó ñáyiu ndèdóho nchaa tnúhu càháⁿ‑í‑a, te ío váha chí cuǎha cuèndá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Te Jèsús xǎhaⁿ tùcu‑gá xii‑güedé: —Na càni tucu‑í ɨngá cuèndú núú‑ndó nàcuáa tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Ɨɨⁿ tée ní naníhí‑dě ɨɨⁿ sá ǐo ndèyáhu yɨ̀ndúxi ɨɨⁿ xichi, te ní nachindúxi tucu‑dé dɨu‑ni núú nǐ naníhí‑dě‑áⁿ, te ío ní cudɨ́ɨ́ ìní‑dé sá dúcáⁿ nǐ naníhí‑dě xíǎⁿ. Te ní xica‑dé cuánuhú‑dé te ní nadico‑dě nchaa sá ndécú ndɨ̀hɨ‑dé, te ní nacuaaⁿ‑dé ñuhu núú dúcáⁿ nǐ naníhí‑dě xíǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Te na càni tucu‑í ɨngá cuèndú núú‑ndó nàcuáa tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Ɨɨⁿ tée quìde ndáhú ndúcú‑dě sá nání pěrlá sá ǐo ndèyáhu. ");
INSERT INTO milNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Te ní naníhí‑dě ñáyiu ndècu ndɨhɨ ɨɨⁿ pérlá sá ǐo‑gá ndèyáhu, te ní xica‑dé cuánuhú‑dé te ní nadico‑dě nchaa sá ndécú ndɨ̀hɨ‑dé, te ní sáháⁿ‑dé ní saaⁿ‑dé pěrlá sá ǐo‑gá ndèyáhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Te na càni tucu‑í ɨngá cuèndú núú‑ndó nàcuáa tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Cue tée tnɨ̀ɨ chácá nǐ dáquěe‑güedé ñunu‑güedé xɨtɨ́ ndute làmár tnɨ́ɨ́‑güedě chácá, te dàcá nuu dàcá nihnu chácá cuǎnguee‑güedɨ xɨtɨ́ ñunu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Te òré ní cutnùní iní‑güedé sá nǐ chítú ñunu‑güedé, te ní natava‑güedé ní nene yuhu làmár, te ní ngüíta‑güedé nácǎxi‑güedé nchaa chácá‑ǎⁿ. Te nchaa chácá vǎha dàquée‑güedé‑dɨ xɨtɨ́ tɨ́dihi, te nchaa chácá nèhé dǎngoyo‑güedé‑dɨ. ");
INSERT INTO milNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Te dàtná ní quide cue tée‑áⁿ ducaⁿ càda cue espíritú xínú cuèchi núú Yǎ Ndiǒxí ná sàá nduu vǎ cúndècu‑gá nchaa sá ìó ñuyíú‑a, chi cue espíritú‑áⁿ daquèe dɨɨⁿ‑xi nchaa ñáyiu ní quide váha tnuú nchaa ñáyiu ñá túú ní quìde váha. ");
INSERT INTO milNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Te nchaa ñáyiu ñá túú ní quìde váha‑áⁿ daquɨ̀hɨ́ⁿ ñáhá‑xí xìí‑yu núú ñùhú núú càyú, te yàcáⁿ ío ndáhyú‑yu, te dìcó rúhñú‑nǎ cuu núhu‑yu sá sàtú iní‑yu cuèndá sá ndóhǒ‑yu —càchí‑gá xǎhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Te Jèsús ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ xii‑güedé: —¿Ní tecú tnùní‑ndó nàcuáa ndùu nchaa tnúhu ní cáháⁿ‑í‑ǎⁿ? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Ní tecú tnùní‑ndɨ́ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Te ní xáhaⁿ tùcu Jesús xii‑güedé: —Te núu ɨɨⁿ tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés ná cùtnuní iní‑dé nàcuáa quìde Yá Ndiǒxí ndɨ̌hu ndaha‑gǎ ñáyiu, te tée‑áⁿ cúú‑dě dàtná ɨɨⁿ tée cùu xítohó vehe. Te tée cùu xítohó vehe‑áⁿ nǐ queñuhu‑dé nchaa sá nǐ quee túu díhna ndècu ndɨhɨ‑dé, ndɨhɨ nchaa sá nǐ quee túu saa. Te ducaⁿ sǎtnahá‑xi cùu tée‑áⁿ te núu na cùtnuní iní‑dé nàcuáa quìde Yá Ndiǒxí ndɨ̌hu ndaha‑gǎ ñáyiu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Te sátá nǐ yáha ducaⁿ nǐ cani Jèsús cuèndú núú‑güedě, te ní xica‑gá cuánuhú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Te ní ndexìo‑gá ñuú núú cúú ñùú‑gá, te cuánguɨhu‑gá xɨtɨ́ veñúhu càa ñuú‑áⁿ te ní ngüíta‑gá dánèhé‑gá ñáyiu. Te nchaa ñáyiu ndèdóho nchaa tnúhu càháⁿ‑gá xǐcuñúhu‑yu, te xǐtnàhá‑yu: —¿Nása ní cuu núu ío váha cùtnuní iní tée‑a nàcuáa cunduu tnúhu cáháⁿ‑dé, te quìde‑dé nchaa sá vǎ yǒo tnàhí ndàcu cada‑i? ");
INSERT INTO milNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Te dìcó déhe tée cùu carpinterú ndɨhɨ tá Màriá cúú‑dě, te ñaní‑dé cúú tě Jàcobó, ndɨhɨ té Chèé, ndɨhɨ té Xǐmú, ndɨhɨ té Jùdás. ");
INSERT INTO milNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Te cue cúha‑dé ndécú ndɨ̀hɨ ñahá‑yu xii‑o ñùú‑a. ¿Te nása ní quide‑dé nǔu ndéé dàcáⁿ ío váha cùtnuní iní‑dé nàcuáa cunduu tnúhu cáháⁿ‑dé‑i? —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Te ñá túú ní cuìní‑yu cáháⁿ ndɨhɨ váha‑yu Jèsús, dico mee‑gǎ ní xáhaⁿ‑gǎ xií‑yu: —Te núu ɨɨⁿ tée càháⁿ tnúhu Yá Ndiǒxí ná nàsáá‑dé ñuú‑dé, te nchaa ñáyiu ñuú‑dé‑áⁿ ndɨhɨ nchaa ñáyiu cùu ndɨmee‑dé ñá túú nèhé‑yu sá yɨ́ñùhu núú‑dě, dico cue ñáyiu nchaa dava‑gá ñuú chi nèhé‑yu sá yɨ́ñùhu núú‑dě —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Te ñá túú ní quìde Jesús tɨtnɨ́ núú sǎ vǎ yǒo tnàhí ndàcu cada ñuú‑áⁿ, chi ñá túú ní cuìní‑yu quɨndáá iní ñáhǎ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Te dɨu‑ni dàvá‑áⁿ nǐ níhí tě Hèrodés tnúhu nchaa nàcuáa quìde Jesús, te té Hèrodés‑áⁿ cúú‑dě tée tàxi tnuní distrìtú Galìleá. ");
INSERT INTO milNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Te ní xáhaⁿ‑dě xii nchaa cue tée ndècu ndɨhɨ‑dé: —Tée dii cuèndú‑xi nìhí‑ó‑áⁿ cùu‑dé té Juàá tée dàcuandute ñaha xii ñáyiu, tée ní xíhí ní cùu te ní ndoto‑dé nǔu dàcáⁿ ndácú‑dě quídé‑dě nchaa sá vǎ yǒo tnàhí ndàcu cada —cachí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Te ducaⁿ nǐ cáháⁿ té Hèrodés chi mee‑dě ní táúchíúⁿ‑dě ní tnɨɨ ñaha‑güedě xii té Juàá, te ní dácútú ñàha‑güedé xii‑dé, te ní chihi ñaha‑güedě vecaá. Te ducaⁿ nǐ quide té Hèrodés‑áⁿ sǎ cuèndá ñaha nàni Herodiás, ñaha ní cándeca ñaní‑dé té Lìpé, te ní naqueheⁿ ñaha‑dě xii‑aⁿ ndèca ñaha‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Te té Juàá ní xáhaⁿ‑dě xii té Hèrodés: —Ñá túú ní quìde váha‑n dùha ní naqueheⁿ‑n ñàha ní cándeca ñaní‑n —duha ní xáhaⁿ tě Juàá xii té Hèrodés. ");
INSERT INTO milNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Te sá dúcáⁿ nǐ xáhaⁿ tě Juàá‑áⁿ xii té Hèrodés, te ní cuiní té Hèrodés‑áⁿ cahni‑dé té Juàá‑áⁿ, dico ñá túú ní cùyɨɨ‑dé chi ní yùhú‑dé núú cuè ñáyiu, chi nchaá‑yu ní cutnùní iní‑yu sá tě Juàá cúú‑dě ɨɨⁿ tée càháⁿ tnúhu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Te ɨɨⁿ nduu ní quide té Hèrodés vico vehe‑dé ní quide càhnu‑dé nduu nǐ cacu‑dé. Te ndècu ɨɨⁿ déhe yoco ñàha nani Herodiás‑áⁿ, te xíchí‑ǎⁿ nǐ quɨ́hu‑xi xɨtɨ́ vehe núú cúú vìco‑áⁿ nǐ xita saha‑xi. Te nùcóo té Hèrodés ndɨhɨ cue tée ní cáháⁿ‑dé ndéhé‑güedě, te ío ní cudɨ́ɨ́ ìní‑dé nàcuáa ní xita xíchí‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Te té Hèrodés‑áⁿ nǐ cacunehe‑dé ndéé Yǎ Ndiǒxí nàcuáa cutnùní iní xíchí‑ǎⁿ sǎ ndàá cuáñaha‑dě nǔu ná cúú sǎ ná càcáⁿ‑xi núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Te xíchí‑ǎⁿ nǐ dácáhú ìní ñáhá nǎná‑xi xii‑xi ná cúú sǎ càcáⁿ‑xi núú tě Hèrodés, núu xíǎⁿ ní xáhaⁿ‑xi xìi‑dé: —Cuìní‑í quehndé‑n dɨ̌quɨ́ tě Juàá tée dàcuandute ñaha xii ñáyiu te taxi‑n, dico na cùhuⁿ ɨɨⁿ xɨtɨ́ cóhó taxi‑n —càchí‑xi xǎhaⁿ‑xi xìi‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Te sá dúcáⁿ nǐ xáhaⁿ‑xi, te ní cundɨ̀yɨ́ té Hèrodés, dico ñá túú ní nǐhí‑dě nása cada‑dé, chi ndèdóho ñáyiu òré ní cacunehe‑dé Yǎ Ndiǒxí sá ndàá cuáñaha‑dě ɨɨⁿ sá ná càcáⁿ‑xi núú‑dě. Te ní quide‑dé nàcuáa ní xáhaⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Chi ní táúchíúⁿ‑dě ní sáháⁿ cue tée ní xehndé‑güedé dɨ́quɨ́ tě Juàá òré yɨ́hɨ́‑dě vecaá. ");
INSERT INTO milNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Te ní chihi‑güedé dɨ́quɨ́‑dě ɨɨⁿ xɨtɨ́ cóhó te nèhe‑güedé cuánuhú ní sáñaha‑güedě xii xíchí‑ǎⁿ, te xíchí‑ǎⁿ nǐ nacuáñaha‑xi xìi náná‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Te cue tée xìca cuu ndɨhɨ té Juàá‑áⁿ nǐ sáháⁿ‑güedé ní naqueheⁿ‑güedé yɨquɨ cùñú‑dé ní chindúxi‑güedé, te dǎtnùní ní sáháⁿ‑güedé ní xáhaⁿ‑güedě xii Jèsús nàcuáa ní cuu. ");
INSERT INTO milNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Te Jèsús ní níhí‑gǎ tnúhu nàcuáa ní cuu ní xíhí té Juàá. Te sátá xǐǎⁿ te cuánguee‑gá ɨɨⁿ bàrcú cuáháⁿ‑gá ɨɨⁿ xichi núú ñà túú ñǎyiu ndècu, dico nchaa ñáyiu xǐndecu nchaa ñuú cáá yàtni xíáⁿ nǐ níhǐ‑yu tnúhu sá cuàháⁿ‑gá, te ní queé‑yu ñuú‑yu xìca sahá‑yu cuáháⁿ núú quídě‑yu cuèndá quexìo Jesús. ");
INSERT INTO milNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Te òré ní quexìo Jesús núú cuàháⁿ‑gá, te ní quene‑gá bàrcú, te ní xiní‑gá cuéhé víhí ñǎyiu xǐxúcu‑yu xíáⁿ, te ní cundàhú iní ñáhá‑gǎ xií‑yu, te ní quide tátna‑gá nchaa ñáyiu cùhú ndɨhɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Te sátá nǐ cuaa te ní sáháⁿ cue tée xìca cuu ndɨhɨ Jesús núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Sa ní cuu dandàca‑n nchaa ñáyiu‑a chi sa ní cuaa, te na quɨ̀hɨ́ⁿ‑yu nchaa ñuú cáá yàtni iha cuaáⁿ‑yu sá cáxǐ‑yu, chi núú ndécú‑ó ìha ñá túú tnàhí ná ìó —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ñáhá, vá dándàca‑í‑yu, váha‑gá mee‑ndo chǐ cuǎñaha sǎ ná càxí‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Te ní xáhaⁿ‑güedě xii‑gá: —Ñá túú nǎgá ndécú ndɨ̀hɨ‑ndɨ́, chi úhúⁿ duha‑ná pàá ndɨhɨ úú‑nǎ chácá ndécú ndɨ̀hɨ‑ndɨ́ —càchi‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí cánèhe paá‑áⁿ ndɨhɨ chácá‑ǎⁿ táquìxi iha —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Te Jèsús ní xáhaⁿ‑gǎ xii nchaa ñáyiu sá ná ngǒo‑yu nchaá‑yu núú ìté cuíí càa xíáⁿ, te ní queheⁿ‑gá ndɨ ùhúⁿ pàá‑áⁿ ndɨhɨ ndɨ ndùú chácá‑ǎⁿ te ní ndacoto‑gá andɨu, te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí, te dǎtnùní ní táhú cuèchi‑gá pàá‑áⁿ te ní sáñaha‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá ní dácǎhñu‑güedé cue ñáyiu ní xexí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Te nchaá‑yu ní xexí‑yu ní ndahá xɨtɨ́‑yu. Te sátá nǐ túhú cóhǒ‑yu te ní nadatàcá‑güedé nchaa sá nǐ quendóo, te ní chítú ùxúú tnàhá tɨ́dihi mee‑ni sǎ nǐ quendóo. ");
INSERT INTO milNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Te nchaa ñáyiu ní xexi‑áⁿ nǐ xínu úhúⁿ mǐl mee‑ni cuè tée chi mee‑ni cuè tée‑áⁿ nǐ quɨ́úndehu, te dɨ̀ɨⁿ cue ñáyiu dɨ̀hɨ́ ndɨhɨ cue landú. ");
INSERT INTO milNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Te òré‑ni‑áⁿ nǐ xáhaⁿ Jèsús xii cue tée xìca cuu ndɨhɨ‑gá sá quěe‑güedé bàrcú téhndé‑güedé ndàa ɨngá xio yuhu làgúná, te mee‑gǎ quendóo‑gá cada ndee ìní tnáhá‑gǎ ndɨhɨ cue ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Te sátá nǐ yáha ní quide ndee ìní tnáhá‑gǎ ndɨhɨ cue ñáyiu, te medìi‑gá ní xica‑gá cuásaá‑gá ɨɨⁿ tɨndúú cáá yàtni xíáⁿ cuèndá cáháⁿ ndɨhɨ‑gá Yǎ Ndiǒxí, te dɨu‑ni medìi‑gá ndécú xǐáⁿ nǐ cundɨquɨⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Te bàrcú sá ñúhú cuè tée xìca cuu ndɨhɨ‑gá‑áⁿ sa cuáháⁿ‑xi ndéé cuádava xɨtɨ́ làgúná‑áⁿ, te níhi vìhi quene táchí ndàa ichi cuáháⁿ‑xi, te dàcandau ndeé‑xi ndute nchaa dɨ̀ñɨ‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Te tàcuíhndá váhi‑gá tá xìca Jesús núú ndute cuáháⁿ tá cùyatni‑gá bàrcú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Te cue tée xìca cuu ndɨhɨ‑gá ní xiní ñáhá‑güedě xii‑gá tá xìca‑gá núú ndute cuáháⁿ, te ní yùhú‑güedé te níhi ní cáháⁿ‑güedé te xǐtnàha‑güedé: —¡Ɨɨⁿ àlmá! —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Te Jèsús ní cáháⁿ‑gá, te xǎhaⁿ‑gǎ xii‑güedé: —Ñɨɨ́ cunduu‑ndo vǎ yùhú‑ndó, chi yúhú cúù‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Te té Pèlú ní xáhaⁿ‑dě xii‑gá: —Mèstrú, te núu dɨu‑n te tauchìuⁿ sá tnàhá‑í ná càca‑í núú ndute quixi tnahá ñáhà‑í xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Taquìxi —cachí‑gá xǎhaⁿ‑gǎ xii‑dé. Te té Pèlú ní nuu‑dé núú bàrcú, te ní ngüíta‑dé tá xìca‑dé núú ndute cuáháⁿ cuátnahá ñáhá‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Te ní cutnùní iní‑dé sá ǐo níhi xìco táchí, te ní ngüíta‑dé yùhú‑dé. Te òré‑ni‑áⁿ tá quěe naa‑dé xɨtɨ́ ndute cuáháⁿ ní cùu, te níhi ní cáháⁿ‑dé xǎhaⁿ‑dě xii Jèsús: —¡Mèstrú, vá dáñá‑n quěe naa‑í xɨtɨ́ ndute! —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Te òré‑ni‑áⁿ nǐ tnɨɨ Jèsús ndaha‑dé, te ní xáhaⁿ‑gǎ xii‑dé: —¿Ná cuèndá ñá túú sàndáá ndisa iní ñáhá‑n xìi‑í sàni ɨɨⁿ sani úú iní‑n‑i? —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Te òré cuánguee Jèsús ndɨhɨ té Pèlú xɨtɨ́ bàrcú, te òré‑ni‑áⁿ nǐ ngüɨ́ñɨ́ táchí. ");
INSERT INTO milNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Te cue tée ñùhu xɨtɨ́ bàrcú‑áⁿ nǐ ngüɨ́ñɨ́ xɨ́tɨ́‑güedě núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Sá ndàá sá cuɨ́tɨ́ sǎ dɨ́ú yòhó cúú‑n Děhe Dútú Ndiǒxí —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Te ní quexìo Jesús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ndàa ɨngá xio yuhu làgúná, te núú nǐ quexìo‑gá ndɨhɨ‑güedé‑áⁿ nání‑xí Gènesarét. ");
INSERT INTO milNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Te nchaa ñáyiu xǐndecu xíáⁿ nǐ cutnùní iní‑yu sá dɨ́ú‑gǎ ní quexìo, te ní dátècú tnúhu‑yu nchaa dava‑gá ñáyiu xǐndecu yatni xíáⁿ sǎ nǐ quexìo‑gá. Te ndècá‑yu nchaa ñáyiu cùhú ndécú ndɨ̀hɨ́‑yu cuáháⁿ núú ndécú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Te nchaa ñáyiu cùhú‑áⁿ nǐ ngüíta‑yu càháⁿ ndàhú‑yu núú Jèsús sá ná dàña‑gá tnándeé‑yu cuědìcó luha yuhu dǒó‑gǎ cuèndá ndúha‑yu, te cue ñáyiu cùhú, ñáyiu ní tnándeé yuhu dǒó‑gǎ ní ndúha‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Te sátá dúcáⁿ te ɨɨⁿ ǔú cue tée cùu fariséú ní quee‑güedé ñuú Jerusàlén, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés ní quexìo‑güedé núú ndécú Jèsús, te xǎhaⁿ‑güedě xii‑gá: ");
INSERT INTO milNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Ná cuèndá cue tée xìca cuu ndɨhɨ‑n ñá túú nàquete‑güedé ndaha‑güedé òré caxi‑güedé nàcuáa ní cachí cue ñaní tnáhá‑ó nǐ xíndecu ndéé sanaha‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te nchòhó tucu, ¿ná cuèndá ñá túú quìde‑ndo nacuáa ní cachí Yǎ Ndiǒxí cada‑ndo, núu da nàcuáa ta quìde cue tée ñuyíú‑a quìde‑ndo‑i? ");
INSERT INTO milNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Te Yá Ndiǒxí càchí‑gá núú tùtú‑gá: “Canehe‑ndo sǎ yɨ́ñùhu núú tǎtá‑ndó ndɨ̀hɨ núú nǎná‑ndó”, càchí‑gá. Te càchí tucu‑gá ɨngá xichi núú tùtú‑gá: “Nchaa ñáyiu na càháⁿ úhú tǎtá‑xi àdi náná‑xi te cahni ñaha‑güedě xií‑yu”, duha càchí‑gá núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Dico nchòhó càchí‑ndó sǎ cuè ñáyiu chi cuu cúñàhá‑yu xii tǎtǎ‑yu àdi nánǎ‑yu: “Vá cúú chìndee ñaha‑ndɨ́ xii‑n, chi sá táxí‑ndɨ̌ xii‑n ni cùu, xíǎⁿ ní nduu cuèndá Yǎ Ndiǒxí”, cuu duha cúñaha ñǎyiu xii tǎtǎ‑yu àdi nánǎ‑yu càchí‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Te càchí‑ndó sǎ cuè ñáyiu ducaⁿ na cǔñaha xìi tátá‑xi àdi náná‑xi te ñá túú‑gǎ tàú‑yu chindèé‑yu ni tǎtǎ‑yu ni nǎnǎ‑yu. Te ducaⁿ quìde‑ndo chi ní dáquéé tɨ̌hú‑ndó nàcuáa ní cachí Yǎ Ndiǒxí cada‑ndo, te mee‑ni nàcuáa ta quìde cue tée ñuyíú‑a véxi nchìcúⁿ nihnu‑ndo quìde‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Te nchòhó cúú‑ndó ñǎyiu ío dàndahú méé‑xí, chi càchí‑ndó sǎ quídé ndǎá‑ndó te ñá ndàá sá quídé ndǎá‑ndó! Te ní quee ndáá‑xi nàcuáa ní chídó tnùní ndíi Chàiá tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǔú tùtú‑gá núú càháⁿ‑xi nàcuáa ní cáháⁿ‑gá cuèndá‑ndó, te duha ní cachí‑gá: ");
INSERT INTO milNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ñáyiu‑a càchí‑yu sá ǐo càhnu cuu‑í dico dìcó‑ni yuhu càháⁿ‑yu, chi duuⁿ duuⁿ ñá túú ñùhu iní ñáhǎ‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Te àúⁿ nǎ cuu chìñuhu ñahá‑yu xii‑í chi ñá túú vědana ndèé nándɨ̌hɨ‑xi, chi cue ñáyiu‑a dàcuahá‑yu cue tnàha ñáyiú‑yu nàcuáa cundecú‑yu, dico mee‑ni tnǔhu sá nǐ cahu iní cue ñáyiu ñuyíú‑a càháⁿ‑yu. Duha ní chídó tnùní ndíi Chàiá núú tùtú Yǎ Ndiǒxí nàcuáa ní cáháⁿ‑gá cuèndá‑ndó —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Te ní xáhaⁿ‑gǎ xii cue ñáyiu: —Chí táquìxi ndehe iha, te cundedóho váha‑ndo tnǔhu na càháⁿ‑í, te ío váha cuáha‑ndo cuèndá. ");
INSERT INTO milNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nchaa sá xéxí‑ndó chi ñá túú nǎ quídé‑xí ìní‑ndó, dico nchaa sá cuèhé sá dúhá sàni iní‑ndó càháⁿ‑ndó nchàa xíǎⁿ quídé‑xí ndècu cuéchi‑ndo —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Te cue tée xìca cuu ndɨhɨ‑gá ní sáháⁿ‑güedé ndéé núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Véxi‑ndɨ́ càchí tnúhu‑ndɨ́ xii‑n sǎ cuè tée cùu fariséú ñá túú cùu váha iní‑güedé cuèndá tnúhu ní cáháⁿ‑n —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Te ní xáhaⁿ‑gǎ xii‑güedé: —Nchaa ñáyiu ñá túú cùu cuendá Tǎtà‑í Dútú Ndiǒxí cuíta nihnú‑yu, chi ñáyiu‑áⁿ cúǔ‑yu dàtná nchaa cúhú sǎ ñà túú nàndɨ́hɨ te tnùhu ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Te vá cádá cuèndá‑ndó nàcuáa càháⁿ cue tée‑áⁿ, chi cùu‑güedé dàtná cue ñáyiu cuàá sácuǐta nehe tnàha. Te nchòhó xìní‑ndó sǎ nǔu ɨɨⁿ ñáyiu cuàá ná cuítá nèhe tucú‑yu ɨngá ñáyiu cuàá, te ndɨ ndùú‑yu quée‑yu déhvá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Te té Pèlú ní xáhaⁿ‑dě xii‑gá: —Cachí tnúhu xii‑ndɨ́ nàcuáa quèe‑xi tnúhu ní cáháⁿ‑n‑ǎⁿ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Te Jèsús ní xáhaⁿ‑gǎ: —¿Náa tnàhá nchòhó ñá túú ní tècú tnùní‑ndó nàcuáa ndùu tnúhu ní cáháⁿ‑í núú ñǎyiu‑ǎⁿ ñǎ? ");
INSERT INTO milNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nchaa sá xéxǐ‑yu cuánguee‑xi xɨtɨ́‑yu, te dǎtnùní náyǎha ñaha‑xi xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dico nchaa tnúhu cuèhé tnúhu duha càháⁿ‑yu xíǎⁿ véxi quene‑xi iní‑yu, te dɨu nchaa xíǎⁿ quídé‑xí ndècu cuéchi‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Te iní‑yu‑áⁿ cácú nìhnu nchaa sá cuèhé sá dúhá, chi sàni cuehé sání dùha iní‑yu, te sàhní‑yu tnàha ñáyiú‑yu, te cue tée càháⁿ ndɨhɨ‑güedé ñáyiu dɨ̀hɨ́ te ñá dɨ́ú ñàdɨhɨ́‑güedé cúǔ‑yu. Te dɨu‑ni ducaⁿ quìde cue ñáyiu dɨ̀hɨ́ càháⁿ ndɨhɨ́‑yu cue tée te ñá dɨ́ú yɨ̀ɨ́‑yu cùu‑güedé, te cuěi tée te cuěi ñadɨ̀hɨ́ mee‑ni ìchi dɨ́ɨ́ ìní cúdɨ̌ɨ́ ìní‑yu cundecú‑yu, te dùhu ndachiuⁿ tnahá‑yu, te dàcuandehndé‑yu, te càháⁿ cuèhé‑yu cuèndá tnàha ñáyiú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Te nchaa xíǎⁿ quídé‑xí ndècu cuéchi‑yu, dico ñá dɨ́ú sǎ ñà túú ndàhá‑yu dàtná ní cachí cue tée ndéé sanaha, chi xíǎⁿ ñá túú quìde‑xi cuendá ngúndecu cuéchi‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Te Jèsús ní xica‑gá cuáháⁿ‑gá ní sáá‑gá yucu cue tée ñuú Tìrú, ndɨhɨ yucu cue tée ñuú Sìdón. ");
INSERT INTO milNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Te ɨɨⁿ ñadɨ̀hɨ́ ñaha cùu ñaní tnáhá ñǎyiu canàneá ndécú yàtni‑aⁿ xíáⁿ, te níhi ta càháⁿ‑aⁿ ní quexìo núú ndécú Jèsús, te xǎhaⁿ‑aⁿ xìi‑gá: —¡Mèstrú, ñaní tnáhá ndǐi Dàvií, cundàhú iní ñáhá xìi‑í cada tátna‑n děhe yoco‑ǐ! Chi yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha xii‑xi te ío dàndoho ñaha‑xi —cachí‑aⁿ xǎhaⁿ xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dico Jèsús ñá túú tnàhí ni cǎháⁿ‑gá, te cue tée xìca cuu ndɨhɨ‑gá ní sáháⁿ‑güedé núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Cúñaha xìi ñaha‑áⁿ ná nùhú‑aⁿ, chi ío níhi càháⁿ‑aⁿ nchìcúⁿ ñáhá‑áⁿ xìi‑o —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Yá Ndiǒxí ní tendaha ñàha‑gá xii‑í véxi‑í mee‑ni ñùú núú xǐndecu cue ñáyiu isràél, chi ñáyiu‑áⁿ cúǔ‑yu dàtná cue mběé cue quɨtɨ ní xíta, chi ta xǐta nihnú‑yu cuáháⁿ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Te ñadɨ̀hɨ́‑áⁿ nǐ sáháⁿ‑aⁿ ndéé núú Jèsús ní ngüɨ́ñɨ́ xɨ́tɨ́‑áⁿ, te xǎhaⁿ‑aⁿ xìi‑gá: —¡Mèstrú, chindee ñàha xii‑í! —càchí‑aⁿ xǎhaⁿ‑aⁿ xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Te Jèsús ní xáhaⁿ‑gǎ xii‑aⁿ: —Vá cúú chìndee‑í cue ñáyiu ñá túú cùu ñáyiu isràél, chi ɨɨⁿ‑ni cùu‑xi núu na quèheⁿ‑o paá cúú cuèndá cue landú te cuáha‑o ìná caxi‑dɨ —càchí‑gá xǎhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dico ñaha‑áⁿ nǐ xáhaⁿ‑aⁿ xìi‑gá: —Ndáá càháⁿ‑n, dico cue iná chi nàdatacá‑güedɨ sá ngóyó yùhu cóhó xǐtohó‑güedɨ —càchí‑aⁿ xǎhaⁿ‑aⁿ xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Te Jèsús ní xáhaⁿ‑gǎ xii‑aⁿ: —¡Yòhó ñaha cùhú déhe‑xi, ío váha sàndáá iní ñáhá‑n xìi‑í! Te na càda‑í nàcuáa cuìní‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑aⁿ. Te òré‑ni‑áⁿ nǐ ndúha déhe‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Te sátá dúcáⁿ nǐ cuu te Jèsús ní xica‑gá cuáháⁿ‑gá ní yáha‑gá yuhu làgúná distrìtú Galìleá, te cuásaá‑gá ɨɨⁿ tɨndúú te xíáⁿ nǐ ngóo‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Te xíáⁿ núcǒo‑gá ní quexìo cuéhé víhí ñǎyiu, te ndècá‑yu ñáyiu yacua, ndɨhɨ ñáyiu ní yíchí ɨɨⁿ xio ndaha‑xi, ndɨhɨ ñáyiu cuàá, ndɨhɨ ñáyiu ñɨ̀hɨ́, te vài dava‑gá cue ñáyiu cùhú tnàhá dava‑gá núú cuěhé ndécǎ‑yu ní quexìo núú ndécú‑gǎ. Te ní taxi ndecu ñàhá‑yu núú Jèsús te ní quide tátna ñaha‑gǎ xií‑yu te ní ndúha‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Te nchaa ñáyiu xǐndecu‑áⁿ ǐo ní cuñúhu‑yu sá dúcáⁿ nǐ xiní‑yu ní cuu ní nacáháⁿ nchaa ñáyiu ñɨ̀hɨ́, ndɨhɨ cuèndá sá nǐ ndúha nchaa cue ñáyiu yacua, ndɨhɨ cuèndá sá nǐ ndúha cue ñáyiu ní yíchí ɨɨⁿ xio ndaha‑xi, ndɨhɨ cuèndá sá nǐ ndúha núú cuè ñáyiu cuàá. Te nchaá‑yu ní cachí‑yu sá ǐo càhnu cuu Yá Ndiǒxí Yaá cúú Ndiǒxí cue ñáyiu isràél. ");
INSERT INTO milNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Te Jèsús ní cana‑gá cue tée xìca cuu ndɨhɨ‑gá, te ní xáhaⁿ‑gǎ xii‑güedé: —Yúhú cúndàhú iní‑í nchaa ñáyiu‑a, chi sa ní cuu úní nduu ndècu ndɨhɨ ñahá‑yu xii‑o ìha, te ñá túú tnàhí‑gá sá cáxǐ‑yu, te ñá túú cuìní‑í natendaha‑ǐ‑yu núhú tnámǎ‑yu vehé‑yu, chi ná ndèé cuáháⁿ cuneé‑yu docó ichi —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Te ní xáhaⁿ‑güedě xii‑gá: —¿Te ndèé níhí‑ó sǎ cuǎñaha‑o càxi nchaa ñáyiu‑a, te ío cuéhě‑yu te ñá túú nǎ ìó iha chi cùu‑xi xɨtɨ́ yucu‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Te Jèsús ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ: —¿Ná daha‑gá pàá ndécú ndɨ̀hɨ‑ndo‑i? —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Ndècu ndɨhɨ‑ndɨ́ úsá‑gá tnàhá pàá ndɨhɨ ɨɨⁿ ǔú‑gá chácá —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Te Jèsús ní xáhaⁿ‑gǎ xii nchaa ñáyiu sá ná ngǒo‑yu nchaá‑yu, te ní ngóo‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Te ní queheⁿ‑gá ndɨ ùsá pàá‑áⁿ ndɨ ɨɨⁿ ǔú‑gá chácá‑ǎⁿ, te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí, te dǎtnùní ní táhú cuèchi‑gá pàá‑áⁿ ndɨhɨ chácá‑ǎⁿ te ní sáñaha‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá ní dácǎhñu‑güedé nchaa ñáyiu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Te nchaá‑yu ní xexí‑yu ní ndahá xɨtɨ́‑yu. Te sátá nǐ túhú cóhǒ‑yu te ní nadatàcá‑güedé nchaa sá nǐ quendóo, te ní chítú ǔsá tnàhá tɨ́dihi mee‑ni sǎ nǐ quendóo‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Te núú ncháá ñǎyiu ní xexi te ní xínu cúmí mǐl mee‑ni cuè tée chi dɨu‑ni cue tée‑áⁿ nǐ quɨ́úndehu, te dɨ̀ɨⁿ cue ñáyiu dɨ̀hɨ́ ndɨhɨ cue landú. ");
INSERT INTO milNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Te sátá dúcáⁿ te Jèsús ní dándácá ñàha‑gá xií‑yu, te cuánguee‑gá bàrcú cuáháⁿ‑gá yucu cue tée ñuú Màgdalá. ");
INSERT INTO milNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Te cue tée cùu fariséú ndɨhɨ cue tée cùu saducéú ní sáá‑güedé núú ndécú Jèsús xító ndèé ñáhá‑güedě xii‑gá, te xǎhaⁿ‑güedě sá ná cádá‑gǎ ɨɨⁿ sá vǎ yǒo tnàhí ndàcu cada cundehe‑güedé nàcuáa cutnùní iní‑güedé nǔu ndáá sá Yǎ Ndiǒxí ní tendaha ñàha‑gá xii‑gá véxi‑gá ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó chi òré tá cuàa cuáháⁿ te ndàcoto‑ndo andɨu, te càchí‑ndó: “Ío váha cada‑xi tneé chi càa vícó tɨ́cuèhé andɨu”, duha càchí‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Te òré dátnéé ndácòto tucu‑ndo andɨu, te càchí‑ndó: “Vá cádá vǎha‑xi nduu vìtna chi tɨcuèhé andɨu, te càa vícó”, duha càchí‑ndó. ¡Dico nchòhó cúú‑ndó ñǎyiu ío dàndahú méé‑xí sǎ quídé ndǎá te ñá ndàá sá quídé ndǎá‑ndó! Te cùtnuní iní‑ndó nàcuáa quìde‑xi andɨu, dico ñá túú cùtnuní iní‑ndó nàcuáa quèe‑xi nchaa sá quídé Yǎ Ndiǒxí vitna. ");
INSERT INTO milNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Dico nchaa nchòhó ñáyiu ndècu ñuyíú vitna ío cuihna ìní‑ndó, te ñá túú cuìní‑ndó càda ndáá‑ndó nǔú Yǎ Ndiǒxí, te cuìní‑ndó càda‑í ɨɨⁿ sá vǎ yǒo tnàhí ndàcu cada dico ñá túú nǎgá cada‑í, chi dɨu‑ni nàcuáa ní quide Yá Ndiǒxí ndíi Jònás dɨu‑ni ducaⁿ càda tucu‑gá vitna —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ducaⁿ te ní xica‑gá cuáháⁿ‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Te òré ní quexìo ndɨhɨ ñaha‑gá xii‑güedé ndàa ɨngá xio yuhu làgúná, te ní ndacu iní‑güedé sá nǐ cunaa‑güedé canehe‑güedé pàá quɨ́hɨ́ⁿ caxi‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Te Jèsús ní cáháⁿ‑gá dóho‑güedé, te xǎhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu‑í xii‑ndo sǎ ǐo quɨhɨ iní‑ndó cùndecu‑ndo, te vá cádá cuèndá tnàhí‑ndo lèvadurá cue tée cùu fariséú ndɨhɨ cue tée cùu saducéú —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Te ní ngüíta‑güedé xǐtnàha‑güedé: —Cuèndá sá ñà túú ní cǎnehe‑o pàá quixi xíǎⁿ duha càháⁿ‑gá —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Te Jèsús ní cutnùní iní‑gá nàcuáa ndùu tnúhu xǐtnàha‑güedé, núu ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó chi ñá túú sàndáá iní ñáhá vǎha‑ndo xìi‑í nǔu xíǎⁿ da sá ñà túú ní cǎnehe‑ndo pàá quixi càháⁿ‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Te náa ñá ndácú ìní‑ndó sǎ nǔú ùhúⁿ‑ni pàá, te ní taxi‑í ní dácǎhñu‑ndo nǐ xexi úhúⁿ mǐl cue tée, chi dɨu‑ni cue tée‑áⁿ nǐ quɨ́úndehu, te sátá nǐ túhú cóhó‑güedě te ní chítú tɨ̀tnɨ́ tɨ́dihi mee‑ni sǎ nǐ quendóo‑ǎⁿ? Te ñá tècú tnùní‑ndó nàcuáa quèe‑xi nacuáa ní quide‑í. ");
INSERT INTO milNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Te náa ñá ndácú tùcu iní‑ndó sǎ nǔú ùsá‑ni pàá te ní taxi‑í ní dácǎhñu tucu‑ndo nǐ xexi cúmí mǐl cue tée, chi dɨu‑ni cue tée‑áⁿ nǐ quɨ́úndehu, te sátá nǐ túhú cóhó‑güedě te ní nadatàcá‑ndó nchàa sá nǐ quendóo, te ní chítú tɨ̀tnɨ́ tɨ́dihi mee‑ni sǎ nǐ quendóo‑ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Dico nchòhó chi ñá túú ní quìde cuendá‑ndó nàcuáa ndùu tnúhu càháⁿ‑í òré ní cachí‑í sá vǎ quéhéⁿ cuèndá‑ndó lèvadurá cue tée cùu fariséú ndɨhɨ cue tée cùu saducéú, chi ñá dɨ́ú cuèndá pàá ní cǎháⁿ‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Te sátá dúcáⁿ nǐ xáhaⁿ Jèsús xii cue tée xìca cuu ndɨhɨ‑gá, te ní tecú tnùní‑güedé sá xǎhaⁿ‑gǎ xii‑güedé sá vǎ tnɨ́ɨ́‑güedě tnúhu càháⁿ cue tée cùu fariséú ndɨhɨ cue tée cùu saducéú, te ñá dɨ́ú cuèndá levadùrá sá quɨ̌hu yuchi cuǎha pàá ní cǎháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Te Jèsús ní quexìo‑gá yucu cue tée ñuú Cèsareá Fìlipú, te ní xícáⁿ tnúhú‑gǎ núú cuè tée xìca cuu ndɨhɨ‑gá, te xǎhaⁿ‑gǎ xii‑güedé: —¿Yoo cùu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo cachí cue ñáyiu‑va? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Te ní xáhaⁿ‑güedě xii‑gá: —Davá‑yu càchí‑yu sá cúú‑n ndǐi Juàá tée ní xóo dacuàndute ñaha xii ñáyiu, te davá‑yu càchí‑yu sá cúú‑n tě Èliás, te davá‑yu càchí‑yu sá cúú‑n ndǐi Jerèmiás tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, àdi cuu‑n ɨngá tée ní xóo cáháⁿ tnúhu‑gá ndéé sanaha, duha càchí‑yu —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Te Jèsús ní xícáⁿ tnúhú tùcu‑gá núú‑güedě, te xǎhaⁿ‑gǎ xii‑güedé: —Te nchòhó, ¿yoo sàni iní‑ndó cùu‑í‑i? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Te té Xǐmú, àdi Pelú chi úú dɨ̀u‑dé, ní xáhaⁿ‑dě xii‑gá: —Yòhó cúú‑n Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a, te dɨu Yá Ndiǒxí cúú‑gǎ Yaá ndécú nchàa nduu nchaa quɨ́ú, te yòhó cúú‑n Děhe‑gá —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Yòhó té Xǐmú déhe té Jònás, ío váha táhú‑n chi mee Tǎtà‑í Dútú Ndiǒxí ní dácáhú ìní ñáhá‑gǎ xii‑n nàcuáa cunduu tnúhu cáháⁿ‑n, te ñá dɨ́ú ɨ̀ɨⁿ ñáyiu ñuyíú‑a ducaⁿ ni dàcahu iní ñáhǎ‑yu xii‑n tnǔhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Te yúhú xǎhaⁿ‑ǐ Pèlú xii‑n, te tnúhu‑áⁿ quéé‑xí yǔú, chi quèe ndáá‑xi nàcuáa nàni‑n, chi cuu‑n ɨ̀ɨⁿ tée vá cání ɨ̀ɨⁿ cani úú iní‑xi canu ichi‑n cuè ñáyiu nàcuáa cundecu ndɨhɨ ñàhá‑yu xii‑í. Te nchaa ñáyiu cùu cuendá‑í vá ndácú yùcu ñávǎha dacuǐta nihnu ñaha‑xi xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Te yúhú taxi‑í tnúhu ndee ìní cundecu ndɨhɨ‑n cuèndá cunuu‑n nǔú cuè ñáyiu yɨ̀ndaha ñaha Yá Ndiǒxí, te nchaa sá ná càháⁿ‑n sǎ cúú‑xí sǎ vǎha, te dɨu‑ni ducaⁿ cǎháⁿ Yǎ Ndiǒxí, te nchaa sá ná càháⁿ‑n sǎ ñà túú cùu‑xi sá vǎha, te dɨu‑ni ducaⁿ cǎháⁿ tucu‑gá, chi quìde‑n nacuáa cuìní‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Te sátá dúcáⁿ te ní xáhaⁿ Jèsús xii cue tée xìca cuu ndɨhɨ‑gá sá vǎ yǒo cúñaha‑güedě sá dɨ́ú‑gǎ cúú‑gǎ Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Te ndéé dàvá‑áⁿ nǐ ngüíta Jèsús xǎhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá: —Dacuɨtɨ́í sǎ quɨ̀hɨ́ⁿ‑í ñuú Jerusàlén, te yàcáⁿ cue tée cùu sacuéhé nǔú ñǎyiu isràél, ndɨhɨ cue dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, nchaa cue tée‑áⁿ ǐo dandòho ñaha‑güedé xii‑í, te cahni ñaha‑güedě, dico nduu úní sá cùú‑í te ndoto‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Te té Pèlú ní cana‑dé Jèsús ɨɨⁿ xio, te ní ngüíta‑dé ténàá ñáhá‑dě xii‑gá, te xǎhaⁿ‑dě: —¡Sá vǎ càchí Ndiǒxí sá dúcáⁿ ndòho‑n chi ñá túú tàú‑n sǎ dúcáⁿ ndòho‑n! —cachí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Te ndàa sátá Jèsús nútnɨ̌ɨ té Pèlú òré ducaⁿ xǎhaⁿ‑dě xii‑gá nǔu ní nchócuǐhnu‑gá, te xǎhaⁿ‑gǎ xii‑dé: —¡Xocuɨ̀ñɨ́ yòhó yucu ñǎvǎha núù‑í‑a chi dìcó quídé tnèñu‑n! Chi ñá túú sàni iní‑ǒ dàtná sání ìní Yǎ Ndiǒxí chi ɨɨⁿ‑ni sàni iní‑ǒ ndɨhɨ dava‑gá cue ñáyiu ndècu ñuyíú‑a —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Te sátá dúcáⁿ te ní xáhaⁿ‑gǎ xii nchaa cue tée xìca cuu ndɨhɨ‑gá: —Nchaa ñáyiu cuìní chitnahá ñáhá xìi‑í, te xìni ñuhu‑xi dañá‑yu vá cádá‑gǎ‑yu sá sání ìní méě‑yu, te ío cada ndee ìní‑yu cundecu túha‑yu ndohó‑yu cuèndá‑í, te cuěi na ndòhó‑yu dàtná ndoho‑í. ");
INSERT INTO milNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Te nchaa ñáyiu cuìní sá ñà túú tnàhí ná yáha cundecu ñuyíú‑a cuíta nihnú‑yu, dico nchaa ñáyiu ñá túú tnàhí yùhú cuěi nándɨ sá ná yǎha‑yu cundecú‑yu ñuyíú‑a sá cuèndá‑í, te ñáyiu‑áⁿ naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Te cuěi nchaandɨ túhú sá ìó ñuyíú‑a na nìhí ñáyiu cundecu ndɨhɨ́‑yu, dico núu dɨu nchaa xíǎⁿ ná càda cuíta nihnú‑yu te ñá túú vědana nàndɨ́hɨ‑xi sá dúcáⁿ ndècu ndɨhɨ́‑yu nchaa xíǎⁿ. Te ni ɨ̀ɨⁿ sá ìó ñuyíú‑a vá chíndèe ñaha‑xi xií‑yu cuèndá naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Te ndáá quéé‑xí tnǔhu càháⁿ‑í, chi na quìxi tucu yúhú Tée cùu ñaní tnáhǎ‑yu nchaá‑yu, te dàvá‑áⁿ quiní‑yu sá ǐo càhnu cuu‑í dàtná càhnu cuu Tátà‑í Dútú Ndiǒxí, te quixi‑í ndɨhɨ cue espíritú xínú cuèchi núú‑gǎ, te dàvá‑áⁿ cuǎha‑í nchaa ñáyiu sá ndúú tǎhǔ‑yu nàcuáa ndùu sá nǐ quidé‑yu ɨɨⁿ ɨɨ́ⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ ìó dava nchòhó ñáyiu ndècu iha vitna vá cùú‑ni‑ndo, chi cundecu‑ni‑ndo ndèé quiní‑ndó quìxi tucu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo taxi tnuní‑í nchaa ñáyiu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Te núú ìñú nduu sá dúcáⁿ nǐ cáháⁿ Jèsús, te ní xica‑gá cuásaá‑gá ɨɨⁿ yucu dùcúⁿ, te ndèca‑gá té Pèlú, ndɨhɨ té Jàcobó, ndɨhɨ té Juàá ñaní té Jàcobó‑áⁿ cuǎsaá. Te úní tnàhí‑ni cue tée‑áⁿ ndécá‑gǎ cuásaá. ");
INSERT INTO milNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Te yucu‑áⁿ ndécú‑gǎ ní nadáma núú‑gǎ ndɨhɨ dóó‑gǎ, te núú‑gǎ súúní dàtásaⁿ‑xi dàtná quídé‑xí nǔú nchǐcanchii, te dóó‑gǎ súúní nǐ nduu cuìxíⁿ dàtná cáá ñùhú cuìxíⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Te òré‑ni‑áⁿ nǐ xiní‑güedé ndíi Moìsés ndɨhɨ té Èliás nútnɨ̌ɨ‑güedé ndɨhɨ‑gá ndátnǔhu ndɨhɨ ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Te té Pèlú ní xáhaⁿ‑dě xii Jèsús: —Mèstrú, ¡váha ní cuu sá ndécú‑ó ìha vitna! Te núu cuìní‑n, te na dàcaa‑ndɨ́ úní tnàhá vehe tnuvixiⁿ, te ɨɨⁿ cuu cuèndá‑n, te ɨɨⁿ cuu cuèndá té Moìsés, te ɨɨⁿ cuu cuèndá té Èliás —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Te nɨni dùcaⁿ caháⁿ té Pèlú ní quexìo ɨɨⁿ vícó nǔú ndécú‑güedě ní dádǎhu ñaha‑xi xìi‑güedé te súúní chàhnchí. Te xɨtɨ́ vícó‑ǎⁿ nǐ tecú ní cáháⁿ Yǎ Ndiǒxí, te xǎhaⁿ‑gǎ xii‑güedé: —Tée‑a cùu‑dé Déhe‑í tée ío cùu iní‑í, te ío cùdɨ́ɨ́ ìní‑í‑dé, te cundedóho‑ndo nchàa tnúhu càháⁿ‑dé —duha ní xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Te sá dúcáⁿ nǐ cáháⁿ Yǎ Ndiǒxí ní tecú dóho cue tée xìca cuu ndɨhɨ Jesús te ío ní yùhú‑güedé, te ní ngüɨ́ñɨ́ xɨ́tɨ́‑güedě te ní nuu núú‑güedě ndàa núú ñúhú. ");
INSERT INTO milNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Te Jèsús cuáháⁿ‑gá núú xǐndecu cue tée xìca cuu ndɨhɨ‑gá, te ní tendaha ñàha‑gá, te xǎhaⁿ‑gǎ xii‑güedé: —Chí ndácuɨ̌ñɨ́, vá yùhú‑ndó —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Te òré ní ndanehe núú‑güedě, te ñá túú‑gǎ ní xìní‑güedé cue tée úú‑áⁿ chi mee‑nǎ Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Te òré cuánuu ndɨhɨ ñaha Jèsús xii‑güedé tɨndúú‑ǎⁿ, te ní xáhaⁿ‑gǎ xii‑güedé: —Vá yǒo cúñaha‑ndo nì ɨɨⁿ sá nǐ xiní‑ndó nǔú nì sáá‑ó‑á, te cuu cáháⁿ‑ndó dico ndéé ná yǎha ndoto yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo sá cùú‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Te cue tée xìca cuu ndɨhɨ‑gá ní xáhaⁿ‑güedě xii‑gá: —Cuìní‑ndɨ́ cachí tnúhu‑n nǎ cuèndá cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés càchí‑güedé sá dǐhna‑gá té Èliás quixi, te dǎtnùní quixi Yaá tendaha Yǎ Ndiǒxí quixi ñuyíú‑a —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ndáá sá códó nùu ɨɨⁿ tée quixi‑dé te cada‑dé dàtná ní quide té Èliás te tée‑áⁿ cada ndáá‑dé nchaa nàcuáa cùu. ");
INSERT INTO milNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Te na càchí tnúhu‑í xii‑ndo vìtna sá sà ní quixi tée ní quide dàtná ní xóo cada té Èliás, te cue ñáyiu ñá túú ní cùtnuní iní‑yu sá dɨ́ú‑dě, te ní quide ñàhá‑yu xii‑dé nchaa nàcuáa ní quixi iní méě‑yu, te dɨu‑ni ducaⁿ càda ñaha tucú‑yu xii yúhú Tée cùu ñaní tnáhǎ‑yu nchaá‑yu, chi dandòho ñahá‑yu xii‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Te cue tée xìca cuu ndɨhɨ‑gá ní cutnùní iní‑güedé sá cuèndá ndíi Juàá tée ní xóo dacuàndute ñaha xii ñáyiu ní cáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Te Jèsús ní nasáá‑gá ndɨhɨ cue tée ní sáá ndɨhɨ‑gá tɨndúú‑ǎⁿ núú xǐndecu vài ñáyiu, te ní quexìo ɨɨⁿ tée núú‑gǎ ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě, te xǎhaⁿ‑dě xii‑gá: ");
INSERT INTO milNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Mèstrú, cundàhú iní déhe‑í chi tnàhá‑dé cuéhé xǐyɨ̀hɨ́, te ío dàndoho ñaha‑xi xii‑dé, te ní cuu vài xito daquée ñaha‑xi nǔú ñùhú xii‑dé, te ní cuu vài tucu xito dangaunihnu ñaha‑xi ndute xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Te sa ndèca‑í‑dé ní quixi núú cuè tée xìca cuu ndɨhɨ‑n dico ñá túú ní ndàcu‑güedé cada tátna ñaha‑güedě xii‑dé —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Te Jèsús ní xáhaⁿ‑gǎ xii nchaa ñáyiu xǐndecu‑áⁿ: —Nchaa nchòhó ñáyiu ndècu ñuyíú‑a, ío sàá iní‑ndó chi ñá túú cuìní‑ndó quɨ̀ndáá iní‑ndó Yǎ Ndiǒxí, te ní cuu vài nduu quide ndee iní‑í nchaa sá quídé‑ndó. ¿Te ná ndéé ama vá dúcáⁿ‑gǎ cada‑ndo‑i? Te chí cándèca tée cùhú‑áⁿ táquìxi iha —cachí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Te Jèsús ní tenàá‑gá espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii tée‑áⁿ, te ní quee ñaha‑xi xìi‑dé, te òré‑ni‑áⁿ nǐ ndúha‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Te sátá dúcáⁿ te òré ndécú mèe Jesús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te ní xícáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Cachí tnúhu xii‑ndɨ́ ná cuèndá ñá túú ní ndàcu‑ndɨ́ queñuhu‑ndɨ́ espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii tée‑ǎⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te ñá túú ní ndàcu‑ndo, chi ñá túú sàndáá ndisa iní‑ndó Yǎ Ndiǒxí. Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nǔu nchòhó quɨ́ndáá ndisa iní‑ndó Yǎ Ndiǒxí cuědìcó luha lií dàtná lǐhli ndɨ́quɨ́ⁿ yutnu nàni mostázá, te ducaⁿ te cuu cúñaha‑ndo xìi ɨɨⁿ tɨndúú xocuɨ̀ñɨ́‑xi núú ndécú‑xí te xocuɨ̀ñɨ́‑xi. Te nchaa núú sǎ vǎha ndacu‑ndo càda‑ndo te núu na quɨ̀ndáá iní ndisa‑ndo Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Te xìni ñuhu‑xi sá ǐo cáháⁿ ndɨhɨ‑ndo‑gǎ te ñá túú tnàhí ná caxi‑ndo cǎháⁿ ndɨhɨ‑ndo‑gǎ, te ducaⁿ te ndacu‑ndo quèñuhu‑ndo espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu, dàtná cúú espíritú sá yɨ́hɨ́ ñàha xii tée‑ǎⁿ ní cùu —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Te nɨni xìca cuu Jesús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá distrìtú Galìleá, te ní xáhaⁿ‑gǎ xii‑güedé: —Yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo sáá ɨɨⁿ nduu te cuáha cuèndá ñáhá‑güedě xii‑í núú cuè tée cùu úhú iní ñáhá, ");
INSERT INTO milNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","te cahni ñaha‑güedě xii‑í dico nduu úní sá cùú‑í te ndoto‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te sá dúcáⁿ nǐ xáhaⁿ‑gǎ xii‑güedé, te ío ní ndɨ́hú iní‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Te òré ní quexìo Jesús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ñuú Capèrnaúm, te cue tée quìde cobrá díhúⁿ cuèndá veñúhu ní sáháⁿ‑güedé ní cáháⁿ ndɨhɨ‑güedé té Pèlú, te xǎhaⁿ‑güedě: —¿Chǎhu mèstrú‑ndó ǔú díhúⁿ sǎ nání drǎcmá cuèndá veñúhu ǎⁿ ñǎhá? —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Te té Pèlú ní xáhaⁿ‑dě: —Chǎhu‑dé —càchí‑dé xǎhaⁿ‑dě xii‑güedé. Te té Pèlú cuánguɨhu‑dé xɨtɨ́ vehe núú ndécú Jèsús, te díhna‑gá ní cáháⁿ‑gá, te xǎhaⁿ‑gǎ xii‑dé: —Xǐmú, ¿nása sàni iní‑n, ná cúú ñǎyiu quìde cobrá ñáhá cuè tée yɨ̀ndaha ñáyiu ndècu ñuyíú‑a cuèndá nchaa sá ndúú yǎhu ñuú‑güedé ndɨhɨ cuèndá nchaa díhúⁿ sǎ ngàútnàha, cue ñáyiu ñuú‑güedé ǎⁿ cuè ñáyiu véxi xica quìde cobrá‑güedé? —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Te té Pèlú ní xáhaⁿ‑dě xii‑gá: —Cue ñáyiu véxi xica quìde cobrá‑güedé —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Te núu ducaⁿ te cue ñáyiu ñuú‑güedé ñá túú nǎ chǎhu‑yu te núu ducaⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dico cuèndá sá vǎ yǒo dasàtú‑ó ìní‑xi, te cuàháⁿ làgúná te dàquée‑n sǎ tnɨ́ɨ́‑n chǎcá xɨtɨ́ ndute, te chácá dǐhnanuu na tàva‑n te cundehe‑n yùhu‑dɨ, chi yɨ̀hɨ ɨɨⁿ díhúⁿ cuìxíⁿ. Te díhúⁿ‑ǎⁿ canehe‑n quɨ̌hɨ́ⁿ cháhu‑n cuèndá‑í ndɨhɨ cuèndá‑n, chi díhúⁿ‑ǎⁿ sa tnahá quéyǎhu cuèndá‑ó ndɨ̀ ndúú‑ó —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Te sátá dúcáⁿ te cue tée xìca cuu ndɨhɨ Jesús ní sáháⁿ‑güedé núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Cachí tnúhu xii‑ndɨ́, yoo ío‑gá cúnùu núú cuè ñáyiu yɨ̀ndaha ñaha Yá Ndiǒxí —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Te Jèsús ní cana‑gá ɨɨⁿ té lǐhli te ní sanutnɨ́ɨ ñaha‑gǎ xii‑dé cuádava tnuú‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Te xǎhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ nǔu vá dáñá‑ndó nchàa sá ñà túú vǎha quìde‑ndo, te nduu ndàhú iní‑ndó dàtná ndàhú iní té lǐhli‑a, te vá ndúú tǎhú‑ndó ndɨ̌hu ndaha ñàha Yá Ndiǒxí xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Te ñáyiu quìde datná quídé tě lǐhli‑a ndàhú iní‑yu, te ñá túú quìde cahnú‑yu mèé‑yu, ñáyiu‑áⁿ ǐo cunùú‑yu núú ndécú Yǎ Ndiǒxí táxí tnùní‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Te nchaa ñáyiu na quèheⁿ cuendá ɨɨⁿ landú dàtná té lǐhli‑a cuèndá sá cúú ìní ñáhǎ‑yu xii‑í ñá, te cada iní‑yu sá yǔhú ní queheⁿ cuèndá‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Te Jèsús xǎhaⁿ tùcu‑gá xii‑güedé: —Te núu ɨɨⁿ tée na dàcaháⁿ‑dé cue ñáyiu sàndáá iní ñáhá xìi‑í cadá‑yu nándɨ sá cuèhé sá dúhá, te váha‑gá sá ná dàcutu ndeé‑güedé ɨɨⁿ yúú yǒdó dǔcúⁿ‑dě, te dàquée ñaha‑güedě xii‑dé xɨtɨ́ ndute làmár, te ñá dɨ́ú sǎ cúndècu‑dé ducaⁿ càda‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Te ndàhú ní cuu nchaa ñáyiu xǐndecu ñuyíú‑a, chi coo cue tée dacàháⁿ ñáhá xìí‑yu cadá‑yu nándɨ sá cuèhé sá dúhá te dacuɨtɨ́í sǎ dúcáⁿ càda‑xi! ¡Dico ndàhú ní cuu cue tée ducaⁿ na dàcaháⁿ ñáhá xìí‑yu cadá‑yu nándɨ sá cuèhé sá dúhá! ");
INSERT INTO milNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Te núu ɨɨⁿ xio ndaha‑ndo àdi ɨɨⁿ xio sáhá‑ndó quìde‑xi quide‑ndo nándɨ sá cuèhé sá dúhá, te quehndé‑ndó ná cuǐta, chi váha‑gá sá nánìhí tàhú‑ndó cuěi na cuǐta ɨɨⁿ xio ndaha‑ndo àdi ɨɨⁿ xio sáhá‑ndó, te ñá dɨ́ú sǎ quɨ̀hɨ́ⁿ‑ndó nɨ̀hií nɨ́ ndúú‑ndó nǔú ñùhú núú càyú. ");
INSERT INTO milNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Te núu ɨɨⁿ xio tɨnùu‑ndo quide‑xi quide‑ndo nándɨ sá cuèhé sá dúhá, te tava‑ndo na cuǐta‑xi, chi váha‑gá sá nánìhí tàhú‑ndó cuěi na cuǐta ɨɨⁿ xio tɨnùu‑ndo, te ñá dɨ́ú sǎ ndɨ̀ ndúú xio núú‑ndó quɨ̌hɨ́ⁿ‑ndó nǔú ñùhú núú càyú. ");
INSERT INTO milNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Te vá dáquèe tɨhú‑ndó cuè ñáyiu cùu cuendá‑í cuěi cùú‑yu ñáyiu ío ndàhú iní‑xi. Te na càchí tnúhu‑í xii‑ndo sǎ cuè espíritú xínú cuèchi núú Yǎ Ndiǒxí, cue espíritú néhé cuèndá ñáhá xìí‑yu ñuyíú‑a, nchaa‑ni nduu nchaa‑ni òré ndécú‑xí nǔú Tǎtà‑í Dútú Ndiǒxí Yaá ndécú àndɨu. ");
INSERT INTO milNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Te ducaⁿ chi yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo véxi‑í ñuyíú‑a dàcácu nihnu‑í ñáyiu núú ùhú núú ndàhú, ñáyiu ta xǐta nihnu cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Te nása sàni iní‑ndó cuèndá ɨɨⁿ tée ndècu ɨɨⁿ ciendú mběé‑xi?, chi núu na cuǐta ɨɨⁿ‑dɨ te dàndóo‑dé cúmídícó sǎhúⁿ cúmí‑dɨ cundecu‑dɨ ɨɨⁿ yucu te quɨ́hɨ́ⁿ‑dé cúnúndúcú‑dě quɨtɨ ní xíta‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Te núu na nàníhí‑dě‑dɨ, te nchòhó sa cùtnuní iní‑ndó sǎ ǐo‑gá cudɨ́ɨ́ ìní‑dé cuèndá quɨtɨ ní xíta‑áⁿ òré naníhí‑dě‑dɨ dàcúúxí cǔmídícó sǎhúⁿ cúmí quɨtɨ ñá túú ní xǐta‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Te ducaⁿ sǎtnahá‑xi quìde Tátá‑ó Dǔtú Ndiǒxí Yaá ndécú àndɨu, chi cuìní‑gá sá vǎ cuǐta ni ɨ̀ɨⁿ cue ñáyiu cùu cuendá‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Te núu ɨɨⁿ ñáyiu ndècu ndɨhɨ‑ndo ní quidé‑yu ɨɨⁿ sá ñà túú tàú‑yu cadá‑yu sá cúú‑xí‑ndó, te cáháⁿ‑ndó dǒho‑yu núú méé nǔú ɨ́ɨ́ⁿ‑ndó ndɨ̀hɨ́‑yu cuèndá sá ná ndìxi cuéchi iní‑yu sá ñà túú quìde váha‑yu. Te núu ní tnɨɨ́‑yu tnúhu ní xáhaⁿ‑ndo xìí‑yu, te ní ndacu‑ndo nǐ nacanu ichi‑ndǒ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Te núu ñá túú ní cuìní‑yu tnɨɨ́‑yu tnúhu xǎhaⁿ‑ndo xìí‑yu, te nducu‑ndo ɨ̀ɨⁿ àdi úú tnàhá cue tée canehe núú‑güedě cuèndá cundedóho‑güedé nàcuáa ndùu tnúhu ndàtnúhu‑ndo ndɨ̀hɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te tnàhá cue tée‑áⁿ cǎháⁿ‑güedé dóho‑yu, dico núu ni tnǔhu càháⁿ cue tée‑áⁿ ñà túú ní cuìní‑yu tnɨɨ́‑yu, te dàtúu‑ndo nǔú dàva‑gá ñáyiu ndècu ndɨhɨ‑ndo ichi Xítohó Jesucrìstú cuèndá cutnùní iní‑yu nàcuáa quìde ñáyiu‑áⁿ. Te núu ñáyiu ndècuéchi‑áⁿ ñà túú ní cuìní‑yu tnɨɨ́‑yu tnúhu sá nǐ xáhaⁿ dàva‑gá cue ñáyiu ndècu ichi‑gá, te cada‑ná iní‑ndó sǎ cúǔ‑yu ñáyiu ñá túú ndècu ichi Yá Ndiǒxí dàtná cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú. ");
INSERT INTO milNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nǔu nchòhó ná càchí‑ndó sǎ ndécú cuěchi ñáyiu, te dɨu‑ni ducaⁿ cǎháⁿ Yǎ Ndiǒxí, àdi cachí‑ndó sǎ ñà túú cuěchi‑yu te dɨu‑ni ducaⁿ cǎháⁿ tucu‑gá, te ducaⁿ chi nchòhó quídé‑ndó nàcuáa càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Te na càchí tnúhu‑í xii‑ndo sǎ nǔu úú tnàhá‑ndó cùu ɨɨⁿnuu‑ndo caháⁿ ndɨhɨ‑ndo Tǎtà‑í Dútú Ndiǒxí Yaá ndécú àndɨu xicáⁿ‑ndó nǔú‑gǎ nǔu ná cúú sǎ cuìní‑ndó, te taxi‑gá nǔu ná cúú sǎ xìcáⁿ‑ndó nǔú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Te núu úú tnàhá‑ndó àdi úní tnàhá‑ndó nǐ natacá‑ndó ɨ̀ɨⁿ xichi cuendá sá ñúhú ìní ñáhá‑ndó xìi‑í, te xíáⁿ ndécú ndɨ̀hɨ ñaha‑í xii‑ndo —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Te té Pèlú ní sáháⁿ ndehe yatni‑dé núú Jèsús, te xǎhaⁿ‑dě xii‑gá: —Mèstrú, cachí tnúhu xii‑í ná daha xito cada càhnu iní‑í tnàha ñáyiu‑í te núu ɨɨⁿ sá ná càda ñahá‑yu xii‑í. ¿Cuědìcó úsá xito‑ǎⁿ? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Yúhú càchí‑í sá ñà dɨ́ú‑ní ǔsá xito cada càhnu iní‑n‑yu, chi únídico úxí xito ndɨhɨ úsá ndɨhɨ úsá xito cada càhnu iní‑n‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Te xǎhaⁿ tùcu‑gá xii‑güedé: —Na càni‑í ɨɨⁿ cuèndú núú‑ndó nàcuáa tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Ɨɨⁿ tée yɨ̀ndaha ñaha xii ñáyiu ní sani iní‑dé sá cádá ndǎá‑dé ndɨhɨ cue tée xìnu cuechi núú‑dě cuèndá nchaa sá tàú‑güedé núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Te òré sa ní ngúndecu túha‑dé te ní quexìo ɨɨⁿ tée xìnu cuechi núú‑dě. Te tée‑áⁿ tàú‑dé cuéhé víhí dǐhúⁿ nǔú‑dě, chi tàú‑dé úxí mǐl díhúⁿ sǎ nání tàlentú. ");
INSERT INTO milNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Te tée xìnu cuechi‑áⁿ ñà túú dǐhúⁿ ndécú ndɨ̀hɨ‑dé nacháhu‑dé sá tàú‑dé núú pàtróóⁿ‑dě‑áⁿ, núu xíǎⁿ ní táúchíúⁿ těe cùu patróóⁿ‑dě‑áⁿ dico ñàha‑güedé xii‑dé ndɨhɨ ñadɨ̀hɨ́‑dé ndɨhɨ cue déhe‑dé ndɨhɨ nchaa sá ndécú ndɨ̀hɨ‑dé cuèndá nchaá‑yu cuú‑yu ñáyiu ñá túú tnàhí dàñá quee núú chíúⁿ pàtróóⁿ‑xi, te ducaⁿ te ndéyǎhu sá tàú‑dé núú pàtróóⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Te tée xìnu cuechi‑áⁿ nǐ ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú pàtróóⁿ‑dě, te xǎhaⁿ‑dě: “Pàtróóⁿ, càháⁿ ndàhú‑í núú‑n sǎ ǐo ndee ǐo càhnu cada iní‑n sǎ dúhá tàú‑í núú‑n, te ñá túú nǎ cani iní‑n chi nacháhu‑í nchaa sá tàú‑í núú‑n”, càchí‑dé xǎhaⁿ‑dě xii pàtróóⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Te tée cùu patróóⁿ‑dě‑áⁿ nǐ cundàhú iní ñáhá‑dě xii‑dé, te ní quide càhnu iní ñáhá‑dě, te ní dáñá ñàha‑dé cuánuhú‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Te tée xìnu cuechi‑áⁿ nǐ naníhí‑dě ɨɨⁿ tée xìnu cuechi ndɨhɨ‑dé ichi cuánuhú‑dé, te tée ní naníhí‑dě‑áⁿ tàú‑dé sacú‑ni díhúⁿ nǔú‑dě chi ɨɨⁿ cièndú‑ni díhúⁿ denàriú tàú‑dé. Te ní tnɨɨ‑dé tée tàú núú‑dě‑áⁿ dácuèhné ñáhá‑dě xii‑dé, te xǎhaⁿ‑dě: “Nacháhu sá tàú‑n nǔù‑í”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Te tée tàú‑áⁿ nǐ ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú těe dii nǔú‑xi tàú‑dé‑áⁿ, te xǎhaⁿ‑dě: “Càháⁿ ndàhú‑í núú‑n sǎ cádá càhnu iní ñáhá‑n xìi‑í sá tàú‑í núú‑n, te nacháhu cuèé‑í nchaa sá tàú‑í núú‑n”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Dico tée dii nǔú‑xi tàú‑dé‑áⁿ ñà túú ní cuìní‑dé cada ndee ìní‑dé cundetu‑dé nacháhu cuèé tée‑áⁿ sǎ tàú‑dé, chi ní chihi ñaha‑dě vecaá cuèndá yàcáⁿ quɨhɨ‑dé ndéé nacháhu‑dé nchaa sá tàú‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Te dava‑gá cue tée xìnu cuechi ní xiní‑güedé nàcuáa ní quide tée‑áⁿ, te ní cudééⁿ‑güedě núú‑dě, te ní sáháⁿ‑güedé ní xítnǔhu‑güedé tée cùu patróóⁿ‑güedě sá dúcáⁿ nǐ quide‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Te tée cùu patróóⁿ‑güedě‑áⁿ nǐ cana‑dé tée ducaⁿ nǐ quide‑áⁿ, te ní xáhaⁿ‑dě: “Yòhó cúú‑n ɨ̀ɨⁿ tée ío cuihna ìní‑xi xìnu cuechi núù‑í, chi yúhú ní quide càhnu iní ñáhà‑í xii‑n cuèndá nchaa sá tàú‑n nǔù‑í òré ní cáháⁿ ndàhú‑n. ");
INSERT INTO milNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Te tnàhá yòhó tàú‑n dùcaⁿ cada‑n cada cahnu iní‑n těe xìnu cuechi ndɨhɨ‑n núù‑í cuèndá nchaa sá tàú‑dé núú‑n dàtná ní quide ñaha‑ǐ xii‑n nǐ quide càhnu iní‑í cuèndá nchaa sá tàú‑n”, càchí tée cùu patróóⁿ‑áⁿ xǎhaⁿ‑dě xii tée ducaⁿ nǐ quide‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Te tée cùu patróóⁿ‑áⁿ nǐ cudééⁿ víhí‑dě sá dúcáⁿ nǐ quide tée‑áⁿ, te ní táúchíúⁿ‑dě dandòho ñaha‑güedé xii‑dé ndéé nacháhu‑dé nchaa sá tàú‑dé —duha ní cani Jèsús cuèndú núú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Te xǎhaⁿ tùcu‑gá xii‑güedé: —Dàtná ní quide tée cùu patróóⁿ‑ǎⁿ nǐ dándóhó‑dě tée tàú núú‑dě‑áⁿ ducaⁿ càda ñaha Tátà‑í Dútú Ndiǒxí Yaá ndécú àndɨu xii‑ndo, te núu vá nɨ́ yùhu nɨ iní‑ndó càda cahnu iní‑ndó sǎ quídé ñàha tnaha ñáyiu‑ndo xìi‑ndo —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Te sátá nǐ yáha ducaⁿ nǐ cáháⁿ Jèsús, te ní ndee‑gá distrìtú Galìleá cuáháⁿ‑gá ndàa ɨngá xio yúte Jòrdán yucu distrìtú Jùdeá. ");
INSERT INTO milNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Te ío cuéhé ñǎyiu nchìcúⁿ ñáhá xìi‑gá cuáháⁿ, te yàcáⁿ ní quide tátna‑gá nchaa ñáyiu cùhú. ");
INSERT INTO milNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Te ní quexìo ɨɨⁿ úú cue tée cùu fariséú núú ndécú Jèsús xító ndèé ñáhá‑güedě xii‑gá nǔu nása cunduu tnúhu cáháⁿ‑gá, te xǎhaⁿ‑güedě xii‑gá: —Véxi‑ndɨ́ xìcáⁿ tnúhú‑ndɨ̌ núú‑n, ¿cuu daña ɨ̀ɨⁿ tée ñadɨ̀hɨ́‑dé nǔu ndědani càa ɨɨⁿ sá ñà túú cùndáá‑yu‑ǎⁿ? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te nchòhó, ¿náa ñá túú dàcuaha‑ndo núú tùtú Yǎ Ndiǒxí, te dɨu núú tùtú‑gá càháⁿ‑xi sá cǔtnàhá ní cadúha‑gá ñáyiu, te tée ñadɨ̀hɨ́ ní cadúha‑gá‑ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Te duha càchí tucu‑xi núú tùtú Yǎ Ndiǒxí nàcuáa ní cáháⁿ‑gá: “Cue tée na nìhí ñadɨ̀hɨ́‑xi te dɨ̀ɨⁿ‑ná cada‑güedé tǎtá‑güedě ndɨhɨ nǎná‑güedě, chi ñadɨ̀hɨ́‑nǎ‑güedé cuu cuu ndɨhɨ‑güedé, te cada iní‑ndó sǎ ɨ́ɨ́ⁿ‑nǎ yɨquɨ cùñú cuú‑yu cundecú‑yu”, duha càchí Yǎ Ndiǒxí núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Te xíǎⁿ nǔu cada iní‑ndó sǎ cuè ñáyiu úú‑áⁿ ɨɨⁿ‑nǎ yɨquɨ cùñú cúǔ‑yu, te ñá túú‑gǎ ndɨ dɨ́ɨ́ⁿ ndɨ̀ dɨ́ɨ́ⁿ yɨ̀quɨ cuñú cúǔ‑yu. Núu xíǎⁿ ñá túú ndùu váha‑xi daña cuè tée ñadɨ̀hɨ́‑güedé, chi mee Yǎ Ndiǒxí ní cachí‑gá sá cúú ǔú‑yu cundecú‑yu —càchí Jèsús xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Te ní xáhaⁿ‑güedě xii Jèsús: —Te núu ducaⁿ, ¿te ná cuèndá ndíi Moìsés ní cachí ndíi sá nǔu ɨɨⁿ tée cuìní‑dé daña‑dě ñadɨ̀hɨ́‑dé, te cuu cadúha‑dé ɨɨⁿ tutú núú càháⁿ‑xi sá nǐ dáñá‑dě ñadɨ̀hɨ́‑dé, te ducaⁿ te cuu daña ñàha‑dé ní cachí ndíi vǎⁿ? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te ducaⁿ nǐ cachí ndíi Moìsés sá cúú dàña‑ndo ñadɨhɨ́‑ndó, chi nchòhó ío sàá iní‑ndó, dico ndéé díhna chi ní tecú tnúhu nchaa cue tée sá vǎ dáñá‑güedě ñadɨ̀hɨ́‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Dico yúhú càchí tnúhu‑í xii‑ndo sǎ nǔu ɨɨⁿ tée na dàña‑dé ñadɨ̀hɨ́‑dé te naqueheⁿ‑dé ɨngá ñadɨ̀hɨ́ te ío nèhé quídé‑dě, te núu ñá dɨ́ú cuèndá sá càháⁿ ndɨhɨ‑aⁿ ɨngá tée ducaⁿ na dàña ñaha‑dé. Te sá dúcáⁿ cuèndá‑ni na dàña ɨɨⁿ tée ñadɨ̀hɨ́‑dé, te ɨɨⁿ‑ni cuěchi cùu‑xi ndɨhɨ cuéchi quìde tée ndèca ñadɨhɨ́ te càháⁿ ndɨhɨ‑dé ɨngá ñadɨ̀hɨ́ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Te cue tée xìca cuu ndɨhɨ‑gá ní xáhaⁿ‑güedě xii‑gá: —Te núu ducaⁿ cùu cuendá cue tée ndɨhɨ ñadɨ̀hɨ́‑güedé, te váha‑gá sá vǎ cándèca cue tée ñadɨ̀hɨ́ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ñá ncháá ñǎyiu ducaⁿ ndùu táhǔ‑yu cundecú‑yu, chi mee‑ni ñǎyiu ní cachí Yǎ Ndiǒxí sá dúcáⁿ tnàhí nduu táhú cundecu mee. ");
INSERT INTO milNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Te ìó cue tée ducaⁿ tnàhí ní nduu táhú‑güedě ndéé òré ní cacu‑güedé sá vǎ cándèca‑güedé ñadɨ̀hɨ́. Te ìó cue tée ñá ndácú‑güedě candeca‑güedé ñadɨ̀hɨ́ cuèndá sá nǐ quide ñaha dàva‑gá cue tnàha tée‑güedé xii‑güedé. Te dava‑güedé ñá túú cǎndeca‑güedé ñadɨ̀hɨ́ chi cuìní‑güedé sá vǎ dáñá ndèé‑güedé cunu cuechi‑güedě núú Yǎ Ndiǒxí. Te nchaa cue tée ducaⁿ nǐ nduu táhú nǔú Yǎ Ndiǒxí cundecu mee, te váha‑ni te núu na cùndecu mee‑güedé —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Te ɨɨⁿ ǔú ñáyiu ndècá‑yu landú lǐhli cuáháⁿ núú Jèsús, chi cuìní‑yu sá téndàha ñaha‑gá xii‑güexi, te cácáⁿ táhú‑gǎ núú Yǎ Ndiǒxí cuèndá‑güexi. Te cue tée xìca cuu ndɨhɨ‑gá ní ngüíta‑güedé ténàá ñáhá‑güedě xií‑yu, te xǎhaⁿ‑güedě sá vǎ dúcáⁿ càdá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí dáñá ná quìxi nahi cue landú lǐhli‑áⁿ nǔù‑í‑a, te vá càdɨ́‑ndó ìchi‑güexi, chi dàtná cúú vǎha iní cue landú lǐhli‑áⁿ ducaⁿ cùu váha iní cue ñáyiu yɨ̀ndaha ñaha Yá Ndiǒxí —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Te ní tendaha ñàha‑gá xii‑güexi, te ní xícáⁿ táhú‑gǎ núú Yǎ Ndiǒxí cuèndá‑güexi, te sátá dúcáⁿ nǐ quide‑gá te ní xica‑gá cuáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Te ɨɨⁿ tée cuechi nǐ quexìo‑dé núú ndécú Jèsús, te xìcáⁿ tnúhú‑dě núú‑gǎ, te xǎhaⁿ‑dě xii‑gá: —Yòhó Mèstrú, cùu‑n tée ío váha iní‑xi, te cuìní‑í nǔu vá cúndèe iní‑n càchí tnúhu‑n nǎ cúú sǎ vǎha cada‑í cuèndá nduu táhù‑í cundecu‑í ndɨhɨ Yá Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —¿Te cùtnuní iní‑n nàcuáa ndùu tnúhu càháⁿ‑n sǎ yǔhú váha iní‑ǎⁿ?, chi ɨɨⁿdìi díí‑ni Yá Ndiǒxí ío váha iní‑gá. Te núu cuìní‑n nàníhí tǎhú‑n te tnɨɨ‑n nchàa tnúhu càháⁿ Yǎ Ndiǒxí, tnúhu sá sánú ìchi ñaha xii ñáyiu nàcuáa cadá‑yu cundecú‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Te tée cuechi‑ǎⁿ ní xáhaⁿ‑dě xii‑gá: —¿Te nděndɨda càa tnúhu càháⁿ Yǎ Ndiǒxí cada‑í‑i? —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Te duha ní cachí Yǎ Ndiǒxí cada ñáyiu: “Vá cáhní‑ndó tnàha ñáyiu‑ndo, vá càháⁿ ndɨhɨ‑ndo ñàdɨhɨ́ te núu ñá dɨ́ú ñàdɨhɨ́‑ndó cùú‑yu, te ducaⁿ‑ni nchòhó cue ñáyiu dɨ̀hɨ́ tucu vá càháⁿ ndɨhɨ‑ndo těe te núu ñá dɨ́ú yɨ̀ɨ‑ndo cuu‑güedé, te vá dúhú‑ndó sǎ ndécú ndɨ̀hɨ tnaha ñáyiu‑ndo, vá dácàcu‑ndo cuéchi neñùú sá cúú‑xí tnàha ñáyiu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Te canehe‑ndo sǎ yɨ́ñùhu núú tǎtá‑ndó ndɨ̀hɨ núú nǎná‑ndó, te cundàhú iní‑ndó tnàha ñáyiu‑ndo dàtná cúndàhú iní‑ndó mèe‑ndo”, duha ní cachí Yǎ Ndiǒxí cada ñáyiu —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Te tée cuechi‑ǎⁿ ní xáhaⁿ‑dě xii‑gá: —Nchaa xíǎⁿ ní ngüíta‑í quídè‑í ndéé cútnàhá cúú làndú‑í, ¿te vitna nágá cúmǎní cada‑í‑i? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Te núu cuìní‑n cùu‑n ɨɨⁿ tée ío váha cada ndáá, te cuàháⁿ dico‑n nchàa sá ndécú ndɨ̀hɨ‑n, te díhúⁿ‑n cuǎha táhú‑n cuè ñáyiu ndàhú, te ducaⁿ te nduu táhú‑n ngǔndecu váha‑n nǔú ndécú Yǎ Ndiǒxí táxí tnùní‑gá. Te sátá ná yǎha ducaⁿ càda‑n te quixi‑n chìtnahá ñáhá‑n xìi‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Te sá dúcáⁿ nǐ xáhaⁿ Jèsús xii‑dé te ío ní cundɨ̀yɨ́‑dé, chi ío cuica‑dě, te ní xica‑dé cuáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Te Jèsús ní xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ ǐo úhú quɨ́ndáá iní ñaha cuè ñáyiu cuica xìi Yá Ndiǒxí cuèndá ndɨ́hu ndaha ñàha‑gá xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Te na càchí tnúhu tucu‑í xii‑ndo sǎ yǎchí‑gá yáha ɨɨⁿ càméyu yaú ɨɨⁿ yɨquɨ tɨ̀cú dàcúúxí sǎ quɨ̀ndáá iní ɨɨⁿ ñáyiu cuica Yǎ Ndiǒxí cuèndá ndɨ́hu ndaha ñàha‑gá xií‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Te sá dúcáⁿ nǐ cáháⁿ Jèsús, xíǎⁿ ío ní cuñúhu cue tée xìca cuu ndɨhɨ‑gá, te ní ngüíta‑güedé xǐtnàha‑güedé: —¿Yoo naníhí tǎhú te núu ducaⁿ vàíⁿ? —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Te Jèsús ní ndacoto‑gá núú‑güedě, te xǎhaⁿ‑gǎ xii‑güedé: —Nchaa ñáyiu ñuyíú‑a chi vá ndácǔ‑yu ná cadá‑yu nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu, dico mee‑gǎ chi ndacu‑gá ndɨ́hu ndaha ñàha‑gá xií‑yu chi nchaandɨ túhú sá vǎha ndàcu‑gá quídé‑gǎ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Te té Pèlú ní xáhaⁿ‑dě xii‑gá: —Nchúhú ní dándǒo‑ndɨ́ nchaa sá ndécú ndɨ̀hɨ‑ndɨ́, te ní tuha ñaha‑ndɨ̌ xii‑n, ¿te ná cúú sǎ nìhí‑ndɨ́ nduu táhú‑ndɨ̌ sá dúcáⁿ nǐ quide‑ndɨ́‑i? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ ná sàá nduu, ndùu saa nchaa sá ìó andɨu ndɨ̀hɨ ñuyíú‑a, te dàvá‑áⁿ cunucóo yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ɨɨⁿ núú xìlé váha, te nchaa ñáyiu quiní‑yu sá ǐo càhnu cuu‑í, te nchòhó cue tée ní tuha ñaha xìi‑í tnàhá‑ndó cùnucóo‑ndo nǔú ɨɨⁿ caa xìlé váha ndɨ ùxúú tnàhá‑ndó, te xíáⁿ cunucóo‑ndo càda ndáá‑ndó cuěchi ndɨ ùxúú xichi cue ñáyiu isràél. ");
INSERT INTO milNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Te nchaa ñáyiu na dàndóo vehe‑xi, àdi ñaní‑xi, àdi cúha‑xi, àdi tátá‑xi, àdi náná‑xi, àdi ñadɨhɨ́‑xi, àdi déhe‑xi, àdi ñuhu‑xi, te núu ducaⁿ na càdá‑yu sá cuèndá‑í te ío‑gá cuéhé sǎ cuǎñaha Yǎ Ndiǒxí cundecu ndɨhɨ́‑yu, te ñá dɨ́ú‑ní xǐǎⁿ chi tnàhá nduu táhǔ‑yu cundecú‑yu ndɨhɨ‑gá nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Te dava ñáyiu cùnuu ndecu ichi Yá Ndiǒxí vitna, ñáyiu‑áⁿ sǎá nduu te vá ǐo‑gá cunùú‑yu dàtná cúnùú‑yu vitna, te dava ñáyiu nchìcúⁿ ñá túú cùnuu vitna, ñáyiu‑áⁿ sǎá nduu te ío cunùú‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Te xǎhaⁿ tùcu Jesús xii cue tée xìca cuu ndɨhɨ‑gá: —Na càni‑í ɨɨⁿ cuèndú núú‑ndó cuèndá tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Ɨɨⁿ tée ní xitu‑dé yoho yàha stilé, te ɨɨⁿ nduu ní quee‑dé nehé‑ni cuándúcú‑dě cue tée cada chìuⁿ núú dúcáⁿ nǐ xitu‑dé yoho yàha stilé‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Te òré ní níhí‑dě cue tée cada chìuⁿ‑áⁿ, te ní quide ndáá‑dé ndɨhɨ‑güedé sá chǎhu ñaha‑dě xii‑güedé ɨɨⁿ díhúⁿ denàriú ɨɨⁿ nduu. Te sátá dúcáⁿ te ní tendaha ñàha‑dé xii‑güedé cuáháⁿ‑güedé cada chìuⁿ‑güedé núú dúcáⁿ nǐ xitu‑dé yoho yàha stilé‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Te dǎtnùní ní xica tucu‑dé cuáháⁿ‑dé dàtná òré caá ɨ́ɨ́ⁿ dátnéé cuǎndúcú‑gǎ‑dé cue tée cada chìuⁿ núú nǐ xitu‑dé yoho yàha stilé‑áⁿ, te ní xiní‑dé xǐnutnɨ́ɨ ɨɨⁿ ǔú cue tée núú yǎhu te ñá túú nǎ chìuⁿ xíquide‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Te ní xáhaⁿ‑dě xii‑güedé: “Ñá túú cùdana cuyáchí‑ndó càda‑ndo chiuⁿ‑í te cháhu ñaha‑ǐ xii‑ndo nàcuáa tàú‑xi cunduu‑ǎⁿ”, càchí‑dé xǎhaⁿ‑dě xii‑güedé. Te cue tée‑áⁿ nǐ sáha‑güedé tnúhu cada chìuⁿ‑güedé te ní xica‑güedé cuáháⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Te tée ní xitu yoho yàha stilé‑áⁿ nǐ xica tucu‑dé dàtná òré caúxúú nduu cuǎndúcú‑gǎ‑dé cue tée cada chìuⁿ‑dé, te ní níhí tucu‑dé cue tée cada chìuⁿ. Te ní quee tucu‑dé dàtná òré caá úní sacuaa, te dɨu‑ni ducaⁿ nǐ quide tucu‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Te ní quee tucu‑dé dàtná òré caá úhúⁿ sacuaa cuándúcú‑gǎ‑dé cue tée cada chìuⁿ‑dé, te ní xiní‑dé xǐnutnɨ́ɨ ɨɨⁿ ǔú cue tée dɨu‑ni núú yǎhu‑áⁿ te ñá túú nǎ chìuⁿ quide‑güedé, te ní xáhaⁿ‑dě xii‑güedé: “Sànuu sá nchòhó ní cuu nchàca vitna ñá túú nìhí‑ndó chìuⁿ cada‑ndo”, cachí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Te cue tée‑áⁿ nǐ xáhaⁿ‑güedě xii‑dé: “Ñá túú nìhí‑ndɨ́ chìuⁿ cada‑ndɨ́ chi vá yǒo ndùcu ñaha xii‑ndɨ́”, càchí‑güedé xǎhaⁿ‑güedě xii‑dé. Te ní xáhaⁿ‑dě xii‑güedé: “Yúhú taxi‑í chìuⁿ cada‑ndo, te quɨ́hɨ́ⁿ‑ndó nǔú nǐ xitu‑í yoho yàha stilé yàcáⁿ cada chìuⁿ‑ndo, te cháhu ñaha‑ǐ xii‑ndo nàcuáa tàú‑xi cunduu”, càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Te sátá nǐ dáhu nchícanchii, te tée dii chìuⁿ‑xi‑áⁿ nǐ xáhaⁿ‑dě xii tée tàxi tnuní ñáhá xìi cue tée quìde chiuⁿ‑áⁿ: “Cúñaha xìi nchaa cue tée quìde chiuⁿ‑áⁿ ná quíxí‑güedě te cháhu‑n‑güedě, te díhna‑gá cue tée nchìcúⁿ cuìí‑nǎ cuánguɨhu núú chíúⁿ ngüǐta‑n chǎhu‑n, te ndéé núú nǐ ndɨhɨ‑ná cháhu‑n cuè tée cuánguɨhu díhna nuu‑gǎ núú chíúⁿ”, càchí‑dé xǎhaⁿ‑dě xii tée tàxi tnuní ñáhá xìi cue tée quìde chiuⁿ‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Te díhna‑gá cue tée cuánguɨhu caá úhúⁿ sacuaa ní quexìo‑güedé cuèndá cháhu ñaha‑dě, te ní cháhu ñaha‑dě ɨɨⁿ caa dǐhúⁿ denàriú xii ɨɨⁿ ɨɨⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Te sátá nǐ cháhu‑dé dava‑gá cue tée ní quide chìuⁿ. Te ndéé núú nǐ ndɨhɨ‑ná ní cháhu‑dé cue tée cuánguɨhu díhna nuu‑gǎ núú chíúⁿ. Te cue tée‑áⁿ nǐ sani iní‑güedé sá váí‑gǎ cháhu ñaha‑dě xii‑güedé, dico ñáhá chi ɨɨⁿ caa‑ni díhúⁿ denàriú ní cháhu ñaha‑dě xii ɨɨⁿ ɨɨⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Te cue tée‑áⁿ nǐ queheⁿ cuèndá‑güedé díhúⁿ‑güedě dico ñá túú ní quìde váha‑xi iní‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Te ní xáhaⁿ‑güedě xii tée dii chìuⁿ‑xi ní quide‑güedé: “¿Ná cuèndá cue tée nchìcúⁿ cuìí‑nǎ cuánguɨhu núú chíúⁿ ɨɨⁿ‑ni nǐ cháhu ñaha‑n xìi‑ndɨ́ ndɨhɨ‑güedé, te ɨɨⁿdìi oré duha ní quide chìuⁿ‑güedé? Te nchúhú nchàca nchaa ní sahni iní‑ndɨ́ ní quide chìuⁿ‑ndɨ́, te ní ndoho‑ndɨ́ cahni, te ɨɨⁿ‑ni nǐ cháhu ñaha‑n xìi‑ndɨ́ ndɨhɨ‑güedé”, càchí‑güedé xǎhaⁿ‑güedě xii tée dii chìuⁿ‑xi ní quide‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Te tée dii chìuⁿ‑xi ní quide‑güedé‑áⁿ nǐ xáhaⁿ‑dě xii ɨɨⁿ tée‑áⁿ: “Yòhó, ñá túú quìde‑í ɨɨⁿ sá ñà túú tàú‑í cada‑í sá cúú‑xí‑n, chi ní quide ndáá‑ó sǎ dɨ́ú‑ní ɨ̀ɨⁿ díhúⁿ denàriú cháhu ñaha‑ǐ xii‑n ɨ̀ɨⁿ nduu. ");
INSERT INTO milNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Te vitna queheⁿ díhúⁿ cuèndá nduu‑n te núhú‑n, chi yúhú cuìní‑í sá ɨ́ɨ́ⁿ‑ní chǎhu ñaha‑ǐ xii‑n ndɨ̀hɨ cue tée nchìcúⁿ cuìí‑nǎ cuánguɨhu núú chíúⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Chi yúhú cuu‑ni cada‑í náni cuìní‑í ndɨhɨ díhùⁿ‑í, ¿àdi dico ñá túú quìde váha‑xi iní‑n sǎ dúhá cùndahú iní‑í cue tée‑ǎⁿ ducaⁿ chǎhu‑í‑güedé?”, càchí tée cùu patróóⁿ‑áⁿ xǎhaⁿ‑dě xii tée‑áⁿ. Duha ndùu cuendú cánì‑í núú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Te duha càháⁿ‑í chi dava ñáyiu cùnuu ndecu ichi Yá Ndiǒxí vitna sáá nduu te vá cúnùu vihi‑gá‑yu dàtná cúnùú‑yu vitna, te dava ñáyiu ñá túú cùnuu vitna sáá nduu ǐo cunùú‑yu. Te ío cuéhé ñǎyiu càháⁿ ñáhá Yǎ Ndiǒxí xií‑yu dico sacú‑ni‑yu nduu táhǔ‑yu cundecú‑yu ndɨhɨ‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Te ñùhu Jesús ichi cuásaá‑gá ñuú Jerusàlén ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te ní cana ñaha‑gǎ xii‑güedé ní naníhí tnáhá‑güedě ndɨhɨ‑gá, te ta ndàtnúhu ndɨhɨ ñaha‑gǎ xii‑güedé cuáháⁿ, te xǎhaⁿ‑gǎ xii‑güedé: ");
INSERT INTO milNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Vitna ñùhu‑o ichi cuásaá‑ó ñùú Jerusàlén, te yàcáⁿ cuáha cuèndá ñáhá‑güedě xii yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo núú cuè tée cùu dútú cúnùu, ndɨhɨ núú cuè tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés. Te dɨu cue tée‑áⁿ cǔñaha‑güedě xii dava‑gá cue tée sá cáhní ñàha‑güedé xii‑í. ");
INSERT INTO milNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Te cuáha cuèndá ñáhá‑güedě xii‑í núú cuè tée ñá túú cùu cue tée isràél, te cue tée‑áⁿ cudɨ́quɨ́ ndeé ñáhá‑güedě xii‑í, te caniha‑güedě ndɨhɨ ñɨɨ, te dǎtnùní cata caa ñaha‑güedě xii‑í núú cùrúxí te núú cùrúxí‑áⁿ cuú‑í, dico nduu úní sá cùú‑í te ndoto‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Te cue déhe té Zebèdeú té Jàcobó ndɨhɨ té Juàá ndécá ñàha náná‑güedě xii‑güedé cuáháⁿ núú ndécú Jèsús, te òré ní quexìo‑aⁿ ndɨhɨ‑güedé núú ndécú‑gǎ te ní ngüɨ́ñɨ́ xɨ́tɨ́‑áⁿ nǔú‑gǎ cuèndá cuìní‑aⁿ ndàtnúhu ndɨhɨ ñaha‑aⁿ xìi‑gá cuèndá sá cúú‑xí cuè déhe‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Te cùmání‑gǎ cáháⁿ‑aⁿ te ní xícáⁿ tnúhú Jèsús núú‑aⁿ, te xǎhaⁿ‑gǎ: —¿Ná cuìní‑n? —càchí‑gá xǎhaⁿ‑gǎ xii‑aⁿ. Te ní xáhaⁿ‑aⁿ xìi‑gá: —Véxi‑í càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n cùnucóo ɨɨⁿ déhe‑í‑a xio cùha‑n, te ɨngá‑dé cunucóo‑dé xio dàtni‑n na saá nduu cùnucóo‑n nǔú táxí tnùní‑n —càchí‑áⁿ xǎhaⁿ‑aⁿ xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Te Jèsús ní xáhaⁿ‑gǎ xii úú cue tée‑áⁿ: —Nchòhó, ñá túú cùtnuní váha iní‑ndó nàcuáa ndùu sá xìcáⁿ‑ndó nǔù‑í. ¿Te náa cundee ìní‑ndó dàndoho ñaha ñáyiu xii‑ndo dàtná dandòho ñahá‑yu xii‑í, te cundee tùcu iní‑ndó càhni ñahá‑yu xii‑ndo dàtná cahni ñàhá‑yu xii‑í‑ǎⁿ? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Cundee ìní‑ndɨ́ yáha‑ndɨ́ nchaa nàcuáa càháⁿ‑n‑ǎⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ndáá sá cúndèe iní‑ndó ndòho‑ndo nchaa nacuáa ndoho‑í, dico sá dúcáⁿ cuìní‑ndó sǎ ɨ́ɨ́ⁿ‑ndó cùnucóo‑ndo xìo cuha‑í, te ɨɨⁿ‑ndo cùnucóo‑ndo xìo datni‑í, te xíǎⁿ chi ñá dɨ́ú yǔhú tàú‑í cachí‑í nǔu sá cúú cùnucóo‑ndo àdi sá vǎ cúú cùnucóo‑ndo, chi mee Tǎtà‑í Dútú Ndiǒxí cachí‑gá te núu ná cúú ñǎyiu nduu táhú cunucóo dɨ̀ñɨ‑í dàvá‑áⁿ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Te òré ní níhí ǔxí‑gá cue tée xìca cuu ndɨhɨ‑gá tnúhu nàcuáa ndùu sá cuìní cue tée úú‑áⁿ, te ní cudééⁿ‑güedě núú cuè tée úú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Te Jèsús ní cana‑gá nchaa cue tée xìca cuu ndɨhɨ‑gá, te ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó xìní‑ndó sǎ cuè tée yɨ̀ndaha nacióⁿ quídé‑güedě sá ǐo cùnuu‑güedé, te nchaa dava‑gá cue tée cùnuu ndɨhɨ‑güedé quídé‑güedě tnàhá‑güedé sá ǐo cùnuu‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dico nchòhó chi vá dúcáⁿ càda‑ndo, chi núu dava‑ndo cuìní‑ndó cùnuu‑ndo, te xìni ñuhu‑xi cunu cuechi núú tnáhá‑ndó te vá cádá‑ndó sǎ cúnùu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Te núu dava‑ndo cuìní‑ndó quène cáva‑ndo, te cuu‑ndo dàtná cue ñáyiu ñá túú tnàhí dàñá quee núú chíúⁿ pàtróóⁿ‑xi cunu cuechi nǔú tnáhá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Te cada‑ndo dàtná quídé yǔhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, chi yúhú véxi‑í ñuyíú‑a dico ñá dɨ́ú sǎ cúnú cuèchi ñáyiu núù‑í chi véxi‑í sá cúnú cuèchi‑í núǔ‑yu. Te cuú‑í ñuyíú‑a cuèndá vàí‑yu cácu nihnú‑yu núú ùhú núú ndàhú —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Te òré ní quee Jèsús ñuú Jerìcó ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te cuéhé víhí ñǎyiu nchìcúⁿ ñáhá xìi‑gá cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Te yuhu ìchi cuáháⁿ‑gá xǐnucóo úú tnàhá cue tée cuàá, te cue tée‑áⁿ nǐ cutnùní iní‑güedé sá Jèsús ñúhú‑gǎ ichi‑áⁿ te ní ngüíta‑güedé níhi càháⁿ‑güedé, te xǎhaⁿ‑güedě xii‑gá: —¡Yòhó Mèstrú, ñaní tnáhá ndǐi Dàvií, cundàhú iní ñáhá xìi‑ndɨ́! —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Te cue ñáyiu tènaá ñáhǎ‑yu xii‑güedé, te xǎhǎⁿ‑yu sá ná càdɨ́‑güedé yuhu‑güedé, dico uuⁿ‑gá níhi ní cáháⁿ‑güedé, te xǎhaⁿ‑güedě xii‑gá: —¡Yòhó Mèstrú, ñaní tnáhá ndǐi Dàvií, cundàhú iní ñáhá xìi‑ndɨ́! —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Te ní ngüɨ́ñɨ́ Jèsús te ní cana ñaha‑gǎ xii‑güedé, te ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ: —¿Ná cuìní‑ndó càda ñaha‑í xii‑ndo‑i? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Te ní xáhaⁿ‑güedě xii‑gá: —Mèstrú, cuìní‑ndɨ́ sá cádá tǎtna‑n nǔú‑ndɨ̌ cuèndá cundehe‑ndɨ̌ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Te Jèsús ní cundàhú iní ñáhá‑gǎ xii‑güedé, te ní tendaha‑gǎ núú‑güedě. Te òré‑ni ní ndúha núú‑güedě, te nchìcúⁿ ñáhá‑güedě xii‑gá cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Te òré sa ta cùyatni Jesús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ñuú Jerusàlén, te ní quexìo‑gá ndɨhɨ‑güedé yatni vií‑nǎ ñuú Bètfagé, te xíáⁿ cáá yùcu nani Olívú. Te ní ndatnúhu‑gá ndɨhɨ úú cue tée xìca cuu ndɨhɨ‑gá, ");
INSERT INTO milNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","te ní xáhaⁿ‑gǎ xii‑güedé: —Chí cuàháⁿ ñuú cáá yàtni yacáⁿ, te òré quexìo‑ndo yacáⁿ te nanihí‑ndó ɨ̀ɨⁿ búrru dɨ̀hɨ́ ndètnɨ́ɨ‑dɨ ndɨhɨ déhe‑dɨ, te nandaxi‑ndo‑güèdɨ te candeca‑ndo‑güèdɨ quixi. ");
INSERT INTO milNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te núu ìó ñáyiu dàdahaⁿ ñaha xii‑güedɨ, te cúñaha‑ndo xìí‑yu sá yǔhú Yaá xícá cùu ndɨhɨ‑ndo xini ñuhu‑í‑güedɨ, te ndɨ̌hɨ‑ni natendaha‑ǐ‑güedɨ núhú‑güedɨ cúñaha‑ndo —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa ní chídó tnùní ɨɨⁿ tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǔú tùtú‑gá núú càchí‑xi: ");
INSERT INTO milNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Chí cǔñaha cuè ñáyiu ñuú Sìón ná cádá cuèndá‑yu, chi véxi tée yɨ̀ndaha ñaha xií‑yu yòdo‑dé ɨɨⁿ bǔrru lǐhli déhe ɨɨⁿ bǔrru quɨtɨ sa xìdo, te cùu‑dé ɨɨⁿ tée ío ndàhú iní‑xi. Duha ní chídó tnùní ɨɨⁿ tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǔú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Te cue tée xìca cuu ndɨhɨ‑gá ní xica‑güedé cuáháⁿ‑güedé, te ní quide‑güedé nàcuáa ní xáhaⁿ‑gǎ xii‑güedé cada‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Te ní ndexìo‑güedé ndécá‑güedě ɨɨⁿ bǔrru dɨ̀hɨ́ ndɨhɨ déhe‑dɨ, te ní sacáⁿ ndodo‑güedé dóó‑güedě sátá‑güedɨ, te dǎtnùní cuásaá Jèsús sátá ɨɨⁿ‑dɨ ní ngódó ñàha‑gá xii‑dɨ. ");
INSERT INTO milNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Te ío cuéhé ñǎyiu ta sàcáⁿ‑yu dóǒ‑yu ichi cuáháⁿ‑gá cuèndá núú dǒǒ‑yu‑áⁿ yǎha‑gá ndɨhɨ quɨtɨ yòdo‑gá. Te davá‑yu xèhndé‑yu ndaha yùtnu ñúú tá sàcáⁿ‑yu cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Te nchaa ñáyiu yòdonuu núú‑gǎ ndɨhɨ nchaa ñáyiu nchìcúⁿ ndàa sátá‑gǎ ní ngüíta‑yu níhi càháⁿ‑yu, te càchí‑yu: —¡Ío càhnu cuu Yaá cúú ñàní tnáhá ndǐi Dàvií! ¡Te Yá Ndiǒxí ío na chìndee ñaha‑gá chi cùu‑gá Yaá ní tendaha Yǎ Ndiǒxí véxi quìde núú‑gǎ! ¡Te ndéé nchaa sá ìó andɨu na càchí‑xi sá ǐo càhnu cuu‑gá! —duha càchí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Te òré cuánguɨhu Jèsús ñuú Jerusàlén, te nchaa ñáyiu ñuú‑áⁿ nǐ ngüíta‑yu xǐcuáá‑yu, te davá‑yu ní ngüíta‑yu xǐtnàhá‑yu: —¿Yoo cùu tée‑ǎⁿ? —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Te davá‑yu xǐtnàhá‑yu: —Tée‑ǎⁿ cúú‑dě Jèsús tée càháⁿ tnúhu Yá Ndiǒxí, te cùu‑dé tée ñuú Nazàrét ñuú yɨ́ndèhu distritú Galìleá —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Te Jèsús cuánguɨhu‑gá xɨtɨ́ veñúhu càhnu sá ǐo cùnuu, te xɨtɨ́ veñúhu‑áⁿ xǐndecu ñáyiu quìde ndáhú nádìcó‑yu, ndɨhɨ ñáyiu xǐsaaⁿ, te nchaá‑yu ní queñuhu ñaha Jèsús xií‑yu quehé, te ní dándùá‑gá mèsá nchaa ñáyiu dàma díhúⁿ, ndɨhɨ nchaa xìlé sácǒo nchihi ñáyiu dìco lómá xǐndecu xɨtɨ́ veñúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Te ní xáhaⁿ‑gǎ xií‑yu: —Núú tùtú Yǎ Ndiǒxí càháⁿ‑xi nàcuáa ní cáháⁿ‑gá, te ní cachí‑gá: “Vehe‑í cúú‑xí nǔú càháⁿ ndɨhɨ ñaha ñǎyiu xii‑í”, duha ní cáháⁿ‑gá càchí‑xi núú tùtú‑gá. Dico nchòhó quídé‑ndó vèhe‑gá vehe ñadúhú —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Te xíáⁿ ndécú Jèsús ní quexìo cue tée cuàá ndɨhɨ cue tée yacua, te ní quide tátna ñaha‑gǎ xii‑güedé te ní ndúha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Te cue dútú cúnùu ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés ní xiní‑güedé ní quide Jèsús sá vǎ yǒo tnàhí ndàcu cada, te ndèdóho tucu‑güedé níhi xǐcáháⁿ cue landú xɨtɨ́ veñúhu càhnu sá ǐo cùnuu‑áⁿ, te càchí‑güexi: “Ío càhnu cuu Yaá cúú ñàní tnáhá ndǐi Dàvií”, càchí‑güexi. Te ní cudééⁿ‑güedě, ");
INSERT INTO milNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","te ní xáhaⁿ‑güedě xii Jèsús: —¿Ndèdóho‑n nàcuáa càháⁿ cue landú‑ǎⁿ ñǎ? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ndèdóho‑í, te nchòhó náa ñá túú dàcuaha‑ndo núú tùtú Yǎ Ndiǒxí núú càháⁿ‑xi cuèndá cue landú‑ǎⁿ, te duha càchí‑xi: Yòhó ní quide‑n sǎ cuè landú vitna sàdi, ndɨhɨ cue dava‑gá landú, chiñuhu ñaha‑güexi xii‑n nàcuáa tàú‑xi cunduu. Duha càchí‑xi núú tùtú‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Te xíáⁿ nǐ dándǒo ñaha Jèsús xii‑güedé, te ní xica‑gá cuáháⁿ‑gá ñuú Bètaniá, yàcáⁿ ní xíndecu‑gá niú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Te nduu tněé‑áⁿ nehé‑ni cuáháⁿ tucu Jèsús ñuú Jerusàlén, te ichi ñùhu‑gá ní xíhí‑gá docó. ");
INSERT INTO milNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Te ní xiní‑gá ɨɨⁿ yutnu ngǔxí nútnɨ̌ɨ ɨɨⁿ xio yuhu ìchi, te ní xica‑gá cuáháⁿ ndéhé‑gǎ nǔu ndèé sávìdí‑xi, dico ñá túú nǎ ndèé chi mee‑ni ndàha‑xi ndeé. Te ní xáhaⁿ‑gǎ xii yutnu ngǔxí‑áⁿ: —¡Vitna te vá ɨ́ɨ́ⁿ ndùu‑gá cuuⁿ sávìdí‑n! —càchí‑gá xǎhaⁿ‑gǎ xii‑xi. Te òré‑ni‑áⁿ nǐ yíchí yutnu ngǔxí‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Te sá dúcáⁿ nǐ cuu ní xiní cue tée xìca cuu ndɨhɨ Jesús, te ío ní cuñúhu‑güedé, te ní xícáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě: —¿Ná cuèndá ndéé dàcáⁿ ío ndɨ̌hɨ ní yíchí yutnu ngǔxí‑ǎⁿ‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ nǔu nchòhó quɨ́ndáá ndisa iní‑ndó Yǎ Ndiǒxí, te vá cání ɨ̀ɨⁿ cani úú iní‑ndó, te ñá dɨ́ú‑ní sǎ nǐ quide‑í‑a ní xiní‑ndó ndàcu‑ndo cada‑ndo, chi ndéé tɨ́ndúú‑a xocuɨ̀ñɨ́‑xi núú ndécú‑xí te núu cúñaha‑ndo sǎ xócuɨ̀ñɨ́‑xi te quɨ́hɨ́ⁿ‑xi quée‑xi xɨtɨ́ làmár. Te dɨu ducaⁿ càda‑xi te núu na quɨ̀ndáá iní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te nchaa sá ná càcáⁿ‑ndó nǔú Yǎ Ndiǒxí òré càháⁿ ndɨhɨ‑ndo‑gǎ te taxi‑gá te núu sàndáá ndisa iní‑ndó sǎ táxí‑gǎ sá xìcáⁿ‑ndó nǔú‑gǎ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Te Jèsús cuánguɨhu‑gá xɨtɨ́ veñúhu càhnu sá ǐo cùnuu danehé‑gá ñáyiu, te xíáⁿ ndécú‑gǎ ní quexìo cue dútú cúnùu ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél, te xǎhaⁿ‑güedě xii‑gá: —Cuìní‑ndɨ́ cachí tnúhu‑n xìi‑ndɨ́ nása ndùu tnúhu ndee ìní ndécú ndɨ̀hɨ‑n núu quìde‑n nándɨ sá quídé‑n, ¿te yoo ducaⁿ nǐ taxi tnúhu ndee ìní‑áⁿ xii‑n‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Yúhú tnàhá‑í cuìní‑í cácáⁿ tnúhu‑í ɨɨⁿ sá càcáⁿ tnúhu‑í núú‑ndó, te núu na càchí tnúhu‑ndo te cachí tnúhu‑í xii‑ndo yòo ní taxi tnúhu ndee ìní duha quìde‑í. ");
INSERT INTO milNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Te chí càchí tnúhu xii‑í yoo ní táúchíúⁿ nǐ dácuándùte ndíi Juàá ñáyiu, ¿Yá Ndiǒxí ǎⁿ cuè tée ñuyíú‑a ní táúchíúⁿ dùcaⁿ ní quide ndíi?, te chí càchí tnúhu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní ngüíta‑güedé xǐtnàha‑güedé: —¿Nása cúñaha‑o? Chi núu na cǔñaha‑o sǎ Yǎ Ndiǒxí ní táúchíúⁿ dùcaⁿ ní quide ndíi Juàá ñá, te quesaha‑dě: “¿Ná cuèndá ñá túú ní sàndáá iní‑ndó tnǔhu ní cáháⁿ ndíi vàíⁿ?”, quesaha‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Te núu na cǔñaha‑o sǎ cuè ñáyiu ñuyíú‑a ní táúchíúⁿ dùcaⁿ ní quide ndíi ña, te cudééⁿ ñǎyiu núú‑ó, chi nchaá‑yu càchí‑yu sá Yǎ Ndiǒxí ní xáhaⁿ‑gǎ xii ndíi sá càháⁿ ndíi tnúhu‑gá núú ñǎyiu —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Te ní xáhaⁿ‑güedě xii Jèsús: —Ñá túú xìní‑ndɨ́ yoo ní táúchíúⁿ dùcaⁿ ní dácuándùte ndíi Juàá ñáyiu —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te ní xáhaⁿ‑gǎ xii‑güedé: —Te núu ducaⁿ te ni yǔhú vá càchí tnúhu‑í xii‑ndo yòo ní taxi tnúhu ndee ìní duha quìde‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Te Jèsús ní xáhaⁿ tùcu‑gá xii‑güedé: —Na càni‑í ɨɨⁿ cuèndú núú‑ndó nàcuáa tecú tnùní‑ndó tnǔhu càháⁿ‑í. Ɨɨⁿ tée ndècu úú déhe‑dé, te ní xáhaⁿ‑dě xii déhe‑dé tée sacuéhé‑gǎ: “Yòhó déhe‑í, véxi‑í càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n cuǎnùndaha ñaha‑n xii‑í cada chìuⁿ‑o núú nǐ xitu‑í yoho yàha stilé”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Te ní xáhaⁿ děhe‑dé xii‑dé: “Vá quɨ̀hɨ́ⁿ‑í cada chìuⁿ‑í núú chíúⁿ‑n”, càchí‑dé xǎhaⁿ‑dě xii tǎtá‑dě. Dico cuèé ní nacani iní‑dé te ní sáháⁿ‑dé ní quide chìuⁿ‑dé núú chíúⁿ tǎtá‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Te tée‑áⁿ nǐ sáháⁿ tucu‑dé ní xáhaⁿ‑dě xii déhe‑dé té lǐhli‑gá nǔu vá cúndèe iní‑dé cuánùndaha ñaha‑dé, te ní xáhaⁿ děhe‑dé‑áⁿ xii‑dé: “Cuu cuánùndaha ñaha‑í xii‑n”, càchí‑dé xǎhaⁿ‑dě. Dico ñá túú ní sǎháⁿ‑dé cada chìuⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Te vitna chí càháⁿ nǔu ndědacàa cue tée úú‑áⁿ nǐ quide‑güedé sá cuìní tǎtá‑güedě —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Tée cùu sacuéhé‑gǎ, tée ní cáháⁿ ndɨhɨ‑dé díhna —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ ncháá cuè tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú, ndɨhɨ cue ñáyiu dɨ̀hɨ́ xǐndecu ichi dɨ́ɨ́ ìní yáchí‑gá ndɨ́hu ndaha ñàha Yá Ndiǒxí xii cue tée‑áⁿ ndɨhɨ cue ñáyiu dɨ̀hɨ́‑áⁿ dàcúúxí nchòhó. ");
INSERT INTO milNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chi ndíi Juàá tée ní xóo dacuàndute ñaha xii ñáyiu ní cáháⁿ ndíi nàcuáa cadá‑yu cundecú‑yu, dico nchòhó chi ñá túú cuìní‑ndó quɨ̀ndáá iní‑ndó nàcuáa ní cáháⁿ ndíi, dico cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú, ndɨhɨ cue ñáyiu dɨ̀hɨ́ xǐndecu ichi dɨ́ɨ́ ìní, chi sàndáá iní‑güedé ndɨhɨ́‑yu tnúhu ní cáháⁿ ndíi. Te nchòhó cuěi ndèhe‑ndo sá sàndáá iní cue ñáyiu‑áⁿ nchaa tnúhu ní cáháⁿ ndíi, dico ñá túú cuìní‑ndó ndìxi cuéchi iní‑ndó cuèndá nchaa sá cuèhé sá dúhá quìde‑ndo cuendá tnɨɨ‑ndo tnǔhu ní cáháⁿ ndíi —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Te xǎhaⁿ tùcu Jesús xii‑güedé: —Cundedóho‑ndo na càni tucu‑í ɨngá cuèndú núú‑ndó cuèndá tecú tnùní‑ndó tnǔhu càháⁿ‑í. Ɨɨⁿ tée ní nacúxi‑dé mee‑ni yòho yaha stilé núú ñúhú‑dě, te ní chidoco‑dě cuèndá sá vǎ cúú dàñú, te ní cadúha‑dé núú quíhní‑dě ndéhé yoho yàha stilé‑áⁿ òré ná cùu, te ní cadúha‑dé ɨɨⁿ xíto dùcúⁿ núú cáúndòdo cue tée coto nchaa yoho yàha stilé‑áⁿ. ’Te ní sáá ɨɨⁿ nduu quèe‑dé quɨ́ngaca cuu xica‑dě te ní dándǒo ndaha‑dě sá nǐ xitu‑dé‑áⁿ xii ɨɨⁿ ǔú cue tée xìní tnáhá ndɨ̀hɨ‑dé cuèndá cada chìuⁿ‑güedé, te ní ndatnúhu‑güedé sá òré ná cúú te cuu cuèndá dava‑güedé, te ducaⁿ te ní quee‑dé cuáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Te sátá nǐ sáá nduu nǐ cuu ndéhé nchaa yoho yàha stilé sá nǐ xitu‑dé‑áⁿ, te ní xáhaⁿ‑dě xii ɨɨⁿ ǔú cue tée xìnu cuechi núú‑dě: “Chí cuàháⁿ cácáⁿ‑ndó sǎ cúú cuèndá‑í núú cuè tée ní dándǒo ndàha‑í nchaa yoho yàha stilé sá nǐ xitu‑í”, càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Te cue tée ní dándǒo ndaha‑dě nchaa yoho yàha stilé sá nǐ xitu‑dé‑áⁿ nǐ tnɨɨ‑güedé cue tée xìnu cuechi núú‑dě‑áⁿ, te ɨɨⁿ‑dé ní cani‑güedé, te ɨɨⁿ‑dé ní sahni ñaha‑güedě, te ɨngá‑dé ní sáñaha‑güedě yúú. ");
INSERT INTO milNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Te tée ní xitu yoho yàha stilé‑áⁿ nǐ tendaha‑dě tɨtnɨ́‑gá tucu cue tée xìnu cuechi núú‑dě cuáháⁿ‑güedé cuángácáⁿ‑güedé sá cúú cuèndá‑dé núú cuè tée ní dándǒo ndaha‑dě sá nǐ xitu‑dé‑áⁿ, dico dɨu‑ni ducaⁿ nǐ quide ñaha cuè tée‑áⁿ xii cue tée xìnu cuechi núú‑dě‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Te tée cùu xítohó nchaa yoho yàha stilé‑áⁿ nǐ sani iní‑dé: “Váha‑gá nǔu tendaha‑ǐ déhe‑í‑a núhú‑dé, chi òré quiní ñáhá‑güedě xii‑dé te canehe‑güedé sá yɨ́ñùhu núú‑dě”, duha ní sani iní‑dé. Te ní tendaha‑dě déhe‑dé cuánuhú‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Dico òré ní xiní cue tée quìde chiuⁿ‑áⁿ děhe tée cùu xítohó nchaa yoho yàha stilé‑áⁿ, te ní xítnàha‑güedé: “Tée‑ǎⁿ tée véxi nduu táhú ñuhu‑a ndɨhɨ nchaa sá cáá nǔú‑xi, dico cahni‑o‑dě te mee‑o ndùu táhú‑ó sǎ ndúú tǎhú‑dě”, càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Te ní tnɨɨ‑güedé tée‑áⁿ te ndèca ñaha‑güedé cuáháⁿ ɨɨⁿ xio yuhu ñùhu‑áⁿ, te ní sahni ñaha‑güedě xii‑dé —duha cuáháⁿ cuèndú ní cani Jèsús núú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Te ní xáhaⁿ tùcu Jesús xii‑güedé: —¿Te nchòhó sa cùtnuní iní‑ndó nǎsa cada ñaha xǐtohó ñuhu‑áⁿ xii cue tée‑áⁿ ñǎ? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Te cue tée‑áⁿ nǐ xáhaⁿ‑güedě xii‑gá: —Tée cùu xítohó ñuhu‑áⁿ nǔhú‑dé, te vá cúndàhú iní‑dé cue tée cuihna ìní‑xi‑áⁿ chi cahni ñaha‑dě xii‑güedé, te dàndóo ndaha‑dě ñuhu‑dé xii cue tée cùtnuní iní‑dé cada ndáá cuèndá ndɨ tnahá cúúⁿ nděhé nchaa yoho yàha stilé sá nǐ xitu‑dé‑áⁿ te cuáñaha‑güedě xii‑dé sá cúú cuèndá‑dé —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te nchòhó, náa ñá túú dàcuaha‑ndo núú tùtú Yǎ Ndiǒxí núú càchí‑xi: Yúú sǎ nǐ dáquéé tɨ̌hú cue tée dàcaa vehe, ní cuu‑xi yúú cúnùu vitna. Chi mee Dǔtú Ndiǒxí ducaⁿ nǐ cachí‑gá cunduu, te cùu‑xi ɨɨⁿ sá ǐo cùñúhu‑o vìtna. Duha càchí‑xi núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Te duha càháⁿ‑í chi Yá Ndiǒxí cada‑gá te vá nìhí‑ndó tnǔhu ndee ìní cundecu ndɨhɨ‑ndo cuèndá ndɨ́hu ndaha ñàha‑gá xii‑ndo, chi tnúhu ndee ìní‑áⁿ cundecu ndɨhɨ cue ñáyiu cada ndáá cuèndá ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Te yúú sǎ cúnùu‑áⁿ cúú‑xí yǔhú, te nchaa ñáyiu ñá túú tnɨ̀ɨ tnúhu‑í cùú‑yu dàtná ɨɨⁿ ñáyiu ndùá núú yǔú‑ǎⁿ te tnàhnú duúⁿ‑yu, àdi núu na tàú ñáhá‑xí xìí‑yu, te dacàchi duuⁿ ñaha‑xi —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Te sá dúcáⁿ ndùu cuendú ní cani Jèsús te cue tée cùu dútú cúnùu‑áⁿ, ndɨhɨ cue tée cùu fariséú ní cutnùní iní‑güedé sá cuèndá‑güedé ní cáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Te ní cuiní‑güedé tnɨɨ ñaha‑güedě xii‑gá òré‑áⁿ dico ñá túú ní cùyɨɨ‑güedé, chi ní yùhú‑güedé cue ñáyiu, chi ní cutnùní iní‑yu sá cúú‑gǎ ɨɨⁿ tée càháⁿ tnúhu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Te Jèsús ní ngüíta tucu‑gá cání‑gǎ ɨngá cuèndú núú‑güedě, te xǎhaⁿ‑gǎ: ");
INSERT INTO milNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Na càni tucu‑í ɨngá cuèndú núú‑ndó cuèndá tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Ɨɨⁿ tée yɨ̀ndaha ñaha xii ñáyiu ní quide‑dé ɨɨⁿ vico ní dátnǎndaha‑dé déhe ducuⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Te ní tendaha‑dě cue tée xìnu cuechi núú‑dě cuáháⁿ‑güedé cuángana‑güedé cue ñáyiu sa ní cáháⁿ‑dé cuhuⁿ vico, dico ñáyiu‑áⁿ ñà túú ní cuìní‑yu quɨ́hɨ́ⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Te ní xáhaⁿ tùcu‑dé xii dava‑gá cue tée xìnu cuechi núú‑dě: “Quɨ́hɨ́ⁿ‑ndó cǔñaha‑ndo xìi cue ñáyiu sa ní cáháⁿ‑í cuhuⁿ vico sá sà ní quide túha‑í sá cáxǐ‑yu, te sa ní sahni‑í ndɨcutu ndɨhɨ nchaa dava‑gá quɨtɨ ní dánúcuǐhnu‑í, te nchaa sa ní quide túha‑í, te na quìxí‑yu cuhúⁿ‑yu vico càchí‑í cúñaha‑ndo”, càchí‑dé xǎhaⁿ‑dě xii cue tée xìnu cuechi núú‑dě‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Dico ni ɨ̀ɨⁿ ñáyiu ní cáháⁿ‑dé‑áⁿ ñà túú ní cuìní‑yu quɨ́hɨ́ⁿ‑yu cuhúⁿ‑yu vico. Chi ɨɨ́ⁿ‑yu ní sáháⁿ‑yu ní quide chìúⁿ‑yu núú ñúhǔ‑yu, te ɨngá‑yu ní sáháⁿ‑yu ní nadìcó‑yu núu nándɨ cùu ndáhú quídě‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Te dava‑gá‑yu ní tnɨɨ́‑yu dava cue tée xìnu cuechi núú těe quìde vico‑áⁿ, te ní canìhá‑yu ndéé ní sahni ñàhá‑yu xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Te tée yɨ̀ndaha ñaha xii ñáyiu quìde vico‑áⁿ nǐ cudééⁿ víhí‑dě sá dúcáⁿ nǐ quidé‑yu, te ní tendaha‑dě cue sandàdú‑dé ní sáháⁿ‑güedé ní sahni‑güedé cue ñáyiu ducaⁿ nǐ quide‑áⁿ, te ní sahmi‑güedé nchaa vehe càa ñuú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Te sátá dúcáⁿ te ní xáhaⁿ‑dě xii dava‑gá cue tée xìnu cuechi núú‑dě: “Nchaa sa ndècu túha, te cue ñáyiu ní cáháⁿ‑í cuhuⁿ vico‑a ni cùu ñá túú‑gǎ tàú‑yu sá cúhǔⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Te chí cuàháⁿ nděni ní cuu te cáháⁿ‑ndó nchàa ñáyiu na nàníhí‑ndó ìchi na quixí‑yu cuhúⁿ‑yu vico‑a”, càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Te cue tée xìnu cuechi‑áⁿ nǐ quee‑güedé cuáháⁿ‑güedé, te ní cáháⁿ‑güedé nchaa ñáyiu ní naníhí‑güedě ichi, te cuěi ñáyiu váha iní‑xi, te cuěi ñáyiu cuihna ìní‑xi, te ní chítǔ‑yu núú cúú vìco‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Te sátá dúcáⁿ te tée yɨ̀ndaha ñáyiu quìde vico‑áⁿ nǐ quɨ́hu‑dé xɨtɨ́ vehe ní xíndéhé‑dě cue ñáyiu ñùhu vico‑áⁿ, te ní xiní‑dé ɨɨⁿ tée ñùtnahá tnuú‑yu te ñá túú càa dóó‑dě dàtná cáá dǒó níhnú cuè ñáyiu ñùhu vico‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Te ní xáhaⁿ‑dě xii tée‑áⁿ: “¿Tǎta, nása ní cuu cuánguɨhu‑ǒ iha, te ñá túú càa dóó‑n dàtná cáá dǒó níhnú cuè ñáyiu ñùhu vico tnándaha‑i?”, càchí‑dé xǎhaⁿ‑dě xii tée‑áⁿ. Dico tée‑áⁿ ñà túú ní nǐhí‑dě tnúhu cáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Te tée yɨ̀ndaha ñáyiu quìde vico‑áⁿ nǐ xáhaⁿ‑dě xii cue ñáyiu xìnu cuechi núú mèsá: “Chí tnɨ́ɨ́ těe‑áⁿ te dacùtu‑ndo‑dé, te queñuhu‑ndo‑dě ná quɨ̀hɨ́ⁿ‑dé cundecu‑dé ɨɨⁿ xichi núú néé nǔú ǐo ndoho‑dé, te yàcáⁿ ío ndáhyú‑dé te dìcó rúhñú‑nǎ cuu núhu‑dé sá sàtú iní‑dé sá ndóhó‑dě”, càchí‑dé xǎhaⁿ‑dě xii cue ñáyiu xìnu cuechi núú mèsá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Te duha ndùu cuendú càháⁿ‑í chi ío cuéhé ñǎyiu càháⁿ ñáhá Yǎ Ndiǒxí xií‑yu, dico sacú‑ni‑yu nduu táhǔ‑yu cundecú‑yu ndɨhɨ‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Te cue tée cùu fariséú ní sáháⁿ‑güedé ɨɨⁿ xichi ní ndatnúhu‑güedé nàcuáa cada‑güedé datɨ̀cánuu‑güedé Jèsús núú tnǔhu càháⁿ‑gá cuèndá ducaⁿ nǐhí‑güedě nàcuáa cada‑güedé cacáⁿ cuéchi‑güedé cuèndá‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Te ní tendaha‑güedě ɨɨⁿ ǔú cue tée cùndɨhɨ‑güedé, ndɨhɨ cue tée cùndɨhɨ té Hèrodés cuáháⁿ‑güedé núú ndécú Jèsús. Te òré ní quexìo‑güedé núú ndécú‑gǎ, te ní xáhaⁿ‑güedě xii‑gá: —Mèstrú, nìhí‑ndɨ́ tnúhu sá ǐo ndáá càháⁿ‑n, te càháⁿ ndáá‑n nàcuáa càháⁿ Yǎ Ndiǒxí cundecu‑o ñùyíú‑a, te cuěi nděda‑ni càa ñáyiu ɨɨⁿ‑ni càháⁿ‑n ndɨ̀hɨ́‑yu chi ñá túú quìde cuendá‑n cuěi ná ñáyiu cùú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Te cachí tnúhu xii‑ndɨ́, núu váha‑ni quìde‑ndɨ́ sá chǎhu‑ndɨ́ té Cèsár tée ío cùnuu cuendá impuèstú áⁿ ñǎhá —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dico Jèsús ní cutnùní iní‑gá sá xító ndèé ñáhá‑güedě xii‑gá, núu ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó cue tée dàndahú méé‑xí sǎ quídé ndǎá te ñá ndàá sá quídé ndǎá‑ndó, ¿ná cuèndá xító ndèé ñáhá‑ndó xìi‑í? ");
INSERT INTO milNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Chí dánèhé ñáhá xìi‑í ɨɨⁿ díhúⁿ sǎ chǎhu‑ndo cuèndá impuèstú nǔu nása càa —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní dánèhé ñáhá‑güedě xii‑gá ɨɨⁿ díhúⁿ sǎ nání dènariú. ");
INSERT INTO milNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Te òré ní xiní‑gá díhúⁿ‑ǎⁿ te ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ: —Chí càchí tnúhu yoo núú‑xi ndèé ndɨhɨ yoo dɨ̀u‑xi ndeé —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Te ní xáhaⁿ‑güedě xii‑gá: —Núú tě Cèsár ndèé ndɨhɨ dɨ̀u‑dé —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te núu ducaⁿ te chí nácuǎha té Cèsár sá cúú cuèndá‑dé, te sá cúú cuèndá méé Yǎ Ndiǒxí te xíǎⁿ nacuáha‑ndo‑gǎ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Te cue tée‑áⁿ ǐo ní cuñúhu‑güedé sá dúcáⁿ nǐ cáháⁿ‑gá, te ní natnɨɨ‑güedé ichi cuánuhú‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Te dɨu‑ni nduu‑ǎⁿ nǐ quexìo ɨɨⁿ úú cue tée cùu saducéú núú ndécú Jèsús. Te cue tée‑áⁿ ñà túú sàndáá iní‑güedé sá ndótó cuè ñáyiu ní xíhí, te ní xáhaⁿ‑güedě xii‑gá: ");
INSERT INTO milNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Mèstrú, ndíi Moìsés ní cachí ndíi sá nǔu ɨɨⁿ tée ndècu ñadɨhɨ́‑xi cuú‑dé te quendóo ñadɨ̀hɨ́‑dé, te núu ñá túú děhe‑dé ní xǒo ndɨhɨ‑aⁿ te tée cùu ñaní‑dé naqueheⁿ‑dé ñaha ní quendóo quèé‑áⁿ cuèndá coo déhe‑dé ndɨhɨ‑aⁿ cuèndá ñaní‑dé tée ní xíhí‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Te ñuú‑ndɨ́‑a ní xíndecu úsá tnàhá cue tée mee‑ni ndɨ̀ ñaní‑güedé. Te tée díhna ní níhí ñadɨ̀hɨ́‑dé te ñá túú ní cùdíi‑dé cundecu‑dé chi ní xíhí‑dé, te ni ɨ̀ɨⁿ déhe‑dé ñá túú ní xǒo ndɨhɨ ñadɨ̀hɨ́‑dé‑áⁿ. Te tée cùu uú ní nàqueheⁿ‑dé ñaha ní quendóo quèé‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Dico ní xíhí tucu‑dé, te ni ɨ̀ɨⁿ tucu déhe‑dé ñá túú ní xǒo ndɨhɨ ñaha‑áⁿ, te dɨu‑ni ducaⁿ nǐ yáha tée cùu uní, te ní xínu ndɨ ùsá‑güedé ní cándeca ñaha‑güedě xii ñaha‑áⁿ dico dɨu‑ni ducaⁿ nǐ xíhí‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Te ndéé núú nǐ ndɨhɨ‑ná te ní xíhí tnàhá ñadɨ̀hɨ́‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Te na sàá nduu ndòto‑güedé ndɨhɨ ñaha‑áⁿ, ¿te ndědacàa‑güedé ñadɨ̀hɨ́‑güedé cuu‑aⁿ‑i? Chi ndɨ ùsá‑güedé ní cándeca ñaha‑güedě xii‑aⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ní xíta nchòhó tnúhu càháⁿ‑ndó, chi ñá túú xìní‑ndó nàcuáa càháⁿ Yǎ Ndiǒxí núú tùtú‑gá, te ni ñà túú cùtnuní iní‑ndó sǎ dɨ́ú‑gǎ ndácú‑gǎ quídé‑gǎ nchaandɨ túhú sá vǎha. ");
INSERT INTO milNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Te na càchí tnúhu‑í xii‑ndo sǎ òré ná sàá nduu ndòto nchaa ñáyiu ní xíhí, te dàvá‑áⁿ vǎ yǒo‑gá dasaⁿ děhe yoco‑xi chi vá yǒo‑gá candeca tnàha, chi cuu‑ná‑yu dàtná cue espíritú xínú cuèchi núú Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Te náa ñá túú quìde cuendá‑ndó nàcuáa càháⁿ Yǎ Ndiǒxí núú tùtú‑gá núú càháⁿ‑gá cuèndá cue ñáyiu ní xíhí‑ǎⁿ? Te duha càchí‑gá: ");
INSERT INTO milNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yúhú cúù‑í Ndiǒxí tě Àbrahám, ndɨhɨ té Isàác, ndɨhɨ té Jàcób”, duha càchí‑gá núú tùtú‑gá. Te cue tée‑áⁿ chi cuěi ní xíhí‑güedé núú ñùyíú‑a, dico sá cúú‑xí Yǎ Ndiǒxí chi ndècu vívú‑ni‑güedě. Chi dɨu‑gá cúú‑gǎ Ndiǒxí mee‑ni cuè ñáyiu xǐndecu vǐvú, te ñá túú cùu‑gá Ndiǒxí cue ñáyiu ñá túú ndècu vívú —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Te sá dúcáⁿ nǐ cáháⁿ‑gá ní xíi‑gá cue tée‑áⁿ, te ío ní cuñúhu nchaa ñáyiu cuèndá sá ǐo váha ndùu tnúhu ní cáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Te cue tée cùu fariséú ní xiní‑güedé ní sadɨ́ Jèsús yuhu cue tée cùu saducéú, chi ñá túú ní nǐhí‑gǎ‑güedé tnúhu cúñaha‑güedě xii‑gá, te cue tée cùu fariséú‑áⁿ nǐ natacá‑güedé te cuáháⁿ‑güedé núú ndécú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Te ɨɨⁿ tée cùu fariséú‑áⁿ ǐo váha cùtnuní iní‑dé nàcuáa ndùu nchaa tnúhu ní chídó tnùní ndíi Moìsés te xìto ndeé‑dé Jèsús, te xǎhaⁿ‑dě xii‑gá: ");
INSERT INTO milNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Mèstrú, cachí tnúhu ndědacàa tnúhu sá nǐ chídó tnùní ndíi Moìsés ío‑gá cúnùu cada‑o —cachí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Duha càháⁿ tnúhu sá ǐo‑gá cúnùu: “Cuu iní‑ndó Dǔtú Ndiǒxí Yaá cúú Ndiǒxí‑ndó nɨ̀ yuhu nɨ iní‑ndó, te cani iní‑ndó càda‑ndo datná cuìní méé‑gǎ, te mee‑ni tnǔhu váha cani iní‑ndó nàcuáa cuu vii cuu váha‑ndo nǔú‑gǎ”, ");
INSERT INTO milNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","duha càháⁿ tnúhu sá ǐo‑gá cúnùu. ");
INSERT INTO milNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Te duha càháⁿ tucu ɨngá tnúhu cùu uú sá ǐo cùnuu, te sa yatni ɨɨⁿ‑ni cùu‑xi ndɨhɨ tnúhu díhna nuu, te càchí‑xi: “Cuu iní‑ndó tnàha ñáyiu‑ndo dàtná cúú ìní‑ndó mèe‑ndo”, duha càháⁿ tnúhu cùu uú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Te cuèndá úú tnúhu‑a ní cáá nchaa tnúhu ní cáháⁿ ndíi Moìsés nàcuáa cada ñáyiu, te dɨu‑ni cuèndá úú tnúhu‑a ní cáá tnúhu ní cáháⁿ nchaa cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Te ndècu ducaⁿ‑ni cue tée cùu fariséú núú ndécú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Te ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ: —Cuìní‑í cachí tnúhu‑ndo yòo déhe‑xi cùu Cristú Yaá tendaha Yǎ Ndiǒxí quixi ñuyíú‑a —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Déhe ndíi Dàvií cúú Yàá‑áⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —¿Te nása càchí‑tu‑ndo sǎ děhe ndíi Dàvií cúú Crìstú Yaá tendaha Yǎ Ndiǒxí quixi ñuyíú‑a, te mee ndǐi Dàvií‑áⁿ nǐ dácáhú ìní ñáhá Espíritú Yǎ Ndiǒxí xii ndíi, te ní cachí ndíi sá Crìstú Yaá tendaha Yǎ Ndiǒxí quixi ñuyíú‑a cùu‑gá Xítohó ndíi? Te duha ní cachí ndíi: ");
INSERT INTO milNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dútú Ndiǒxí ní xáhaⁿ‑gǎ xii Yaá cúú Xǐtohó‑í: “Ngóo xio cùha‑í, te yúhú cada‑í te nchaa sá cúú ǔhú iní ñáhá xìi‑n canehe‑xi sá yɨ́ñùhu núú‑n.” Duha ní xáhaⁿ Dǔtú Ndiǒxí xii Yaá cúú Xǐtohó‑í, càchí ndíi. ");
INSERT INTO milNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Te nása cùu Cristú déhe ndíi Dàvií, te mee ndǐi ní cachí ndíi sá cúú‑gǎ Xítohó ndíi? —càchí Jèsús xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Te ni ɨ̀ɨⁿ‑güedé ñá túú‑gǎ ní nǐhí‑güedě tnúhu cúñaha‑güedě xii‑gá. Te ndéé nduu‑ǎⁿ ñà túú‑gǎ ní cùyɨɨ‑güedé ná tnúhu cácáⁿ tnúhú‑güedě núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Te Jèsús ní cáháⁿ ndodo‑gá núú nchàa ñáyiu, ndɨhɨ núú cuè tée xìca cuu ndɨhɨ‑gá, te xǎhaⁿ‑gǎ: ");
INSERT INTO milNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùu fariséú ndécú ndɨ̀hɨ‑güedé tnúhu ndee ìní cáháⁿ‑güedé nchaa tnúhu sá nǐ chídó tnùní ndíi Moìsés‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Te cada‑ndo nàcuáa dànehé ñáhá‑güedě xii‑ndo, dico vá cádá‑ndó dàtná xǐquide‑güedé, chi tucu ndùu tnúhu càháⁿ‑güedé, te tucu quìde‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Te quìde‑güedé dàtná quídé ñǎyiu dàcuido ɨɨⁿ tnaha ñáyiu‑xi ɨɨⁿ sá ǐo vée, te mèé‑yu ni lùha ñá túú cuìní‑yu cuidó‑yu. Te ducaⁿ sǎtnahá‑xi cùu‑güedé chi dànehé ñáhá‑güedě xii‑ndo nàcuáa cada‑ndo, dico mee‑güedě chi ni lùha ñá túú cuìní‑güedé cada‑güedé nàcuáa dànehé ñáhá‑güedě xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Te mee‑ni ndùcu‑güedé nàcuáa quìde‑güedé cuèndá quiní ñáyiu sá ǐo cùu cahnu‑güedé. Te ndèé xìndá sá ndèé ɨɨⁿ ǔú tnúhu Yá Ndiǒxí tneé‑güedé ndɨhɨ ndaha‑güedé, te tnàhá iní‑güedé sá ǐo‑gá cunduu quèhéⁿ xìndá‑áⁿ dàcúúxí xìndá dava‑gá ñáyiu. Te tnàhá tucu iní‑güedé sá ǐo‑gá cunduu nàni núú dǒó sácuǐhnu‑güedé dàcúúxí dǒó sácuǐhnu dava‑gá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Te ndɨ tnahá òré sácǒo vico, òré quɨ́hu‑güedé mèsá caxi‑güedé te ío‑gá cúdɨ̌ɨ́ ìní‑güedé cunucóo‑güedé núú xìlé núú sácǒo cue tée cùnuu‑gá, te dɨu‑ni ducaⁿ quìde tucu‑güedé cuěi xɨtɨ́ veñúhu. ");
INSERT INTO milNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Te nchaa núú xícá cùu‑güedé cuìní‑güedé sá ndɨ̀hɨ tnúhu yɨñùhu cáháⁿ ndɨhɨ ñaha ñǎyiu xii‑güedé, te cuìní tucu‑güedé sá cǔñàhá‑yu xii‑güedé mèstrú. ");
INSERT INTO milNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Dico nchòhó vá cǔñaha‑ndo xìi ñáyiu sá cǔñàhá‑yu mèstrú xii‑ndo, chi nchòhó ɨɨⁿ‑ni cùu‑ndo ndecu‑ndo, chi ducaⁿ ɨ̀ɨⁿdii‑ni yúhú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a cùu‑í Mèstrú ndécú ndɨ̀hɨ ñaha‑í xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Te ɨɨⁿdìi‑ni Dútú Ndiǒxí Yaá ndécú àndɨu cuu‑gá Tǎtá‑ndó, núu xíǎⁿ vá càháⁿ‑ndó sǎ dàva cue tée ñuyíú‑a cùu‑güedé tǎtá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Te ni vǎ cání ìní‑ndó càda‑ndo nacuáa cáháⁿ ñáyiu sá cúnùu‑ndo, chi ɨɨⁿdìi‑ni yúhú Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a cùnuu‑í. ");
INSERT INTO milNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Te ñáyiu ío‑gá cúnùu ndecu ndɨhɨ‑ndo, ñáyiu‑áⁿ cúǔ‑yu ñáyiu xìnu cuechi núú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Te nchaa ñáyiu quìde cahnu mee‑xi ñáyiu‑áⁿ vǎ cúǔ‑yu ñáyiu cùnuu, te nchaa ñáyiu ñá túú quìde cahnu mee‑xi ñáyiu‑áⁿ cunùú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Te nchòhó cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ nchòhó cue tée cùu fariséú, cùu‑ndo cue tée ío dàndahú méé‑xí sǎ quídé ndǎá te ñá ndàá sá quídé ndǎá‑ndó, te ndàhú ní cuu‑ndo chi sàdɨ́‑ndó ìchi ñáyiu ñá dáñá‑ndó ndɨ̌hu ndaha ñàha Yá Ndiǒxí xií‑yu, te ni mèe‑ndo ñá túú quìde‑ndo nacuáa ndɨ́hu ndaha ñàha‑gá xii‑ndo, te ni dàva‑gá cue ñáyiu cuìní sá ndɨ̌hu ndaha ñàha‑gá xií‑yu ñá dáñá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Te nchòhó cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ nchòhó cue tée cùu fariséú, cúú‑ndó cuè tée ío dàndahú méé‑xí sǎ quídé ndǎá te ñá ndàá sá quídé ndǎá‑ndó, te ndàhú ní cuu‑ndo chi quèndeé‑ndó vèhe cue ñáyiu quèé, te ío naha càháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí cuèndá cuìní‑ndó sǎ vǎ yǒo cutnùní iní‑xi nàcuáa quìde‑ndo. Te sá dúcáⁿ quìde‑ndo te ío‑gá ndoho‑ndo nǔú ùhú núú ndàhú dàcúúxí dàva‑gá ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Te nchòhó cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ nchòhó cue tée cùu fariséú, cúú‑ndó cuè tée ío dàndahú méé‑xí sǎ quídé ndǎá te ñá ndàá sá quídé ndǎá‑ndó, te ndàhú ní cuu‑ndo chi sàhni iní‑ndó cuǎháⁿ‑ndó nděni ní cuu dàcaháⁿ‑ndó ñǎyiu cuèndá cuìní‑ndó tnɨ̀ɨ́‑yu ichi ndècu‑ndo. Te òré ná xǐnu iní‑yu tnɨɨ́‑yu ichi ndècu‑ndo‑áⁿ te uuⁿ‑gá cuíta nihnú‑yu dàcúúxí mèe‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Te nchòhó cúú‑ndó dàtná cue ñáyiu cuàá, chi ñá cútnùní iní‑ndó nàcuáa canu ichi‑ndo ñǎyiu, te ndàhú ní cuu‑ndo chi càchí‑ndó: “Ɨɨⁿ ñáyiu na càcunehe veñúhu càhnu sá ǐo cùnuu oré cuìní‑yu cutnùní iní tnàha ñáyiú‑yu sá ndàá cadá‑yu ɨɨⁿ sá sání ìní‑yu cadá‑yu, te vá cúú cuěchi xií‑yu cuěi vá cádǎ‑yu. Dico núu na càcu nehé‑yu díhúⁿ cuàáⁿ yɨ́hɨ́ xɨ̀tɨ́ veñúhu‑áⁿ te cuu cuéchi xií‑yu te núu vá cádǎ‑yu sá nǐ cachí‑yu cadá‑yu”, duha càchí‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","’¡Nchòhó cúú‑ndó cuè tée ío nɨɨ dɨ̌quɨ́‑xi, te cùu‑ndo datná cue ñáyiu cuàá chi ñá tècú tnùní‑ndó! Te vá càchí‑ndó sǎ ǐo‑gá cúnùu díhúⁿ cuàáⁿ dàcúúxí vèñúhu, chi dɨu cuèndá veñúhu‑áⁿ nǐ cuu íí dǐhúⁿ cuàáⁿ‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Te càchí tucu‑ndo: “Ɨɨⁿ ñáyiu na càcunehe xíto núú sácǒdó sǎ ndúú tǎhú Yǎ Ndiǒxí òré cuìní‑yu cutnùní iní tnàha ñáyiú‑yu sá ndàá cadá‑yu ɨɨⁿ sá sání ìní‑yu cadá‑yu, te vá cúú cuěchi xií‑yu cuěi vá cádǎ‑yu, dico núu na càcu nehé‑yu sá ndúú tǎhú Yǎ Ndiǒxí yódó nǔú xǐto‑áⁿ te cuu cuéchi xií‑yu te núu vá cádǎ‑yu sá nǐ sani iní‑yu cadá‑yu”, duha càchí‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Te cùu‑ndo cue tée ío nɨɨ dɨ̌quɨ́‑xi, te cùu‑ndo datná cue ñáyiu cuàá chi ñá tècú tnùní‑ndó! Te vá cání ìní‑ndó sǎ ǐo‑gá nándɨ̌hɨ sá ndúú tǎhú Yǎ Ndiǒxí sácǒdó nǔú xǐto núú sácǒdó tnàhí sá ndúú tǎhú‑gǎ‑áⁿ dàcúúxí mèe xíto‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Chi nchaa ñáyiu ducaⁿ càcunehe xíto‑áⁿ, te tnàhá‑ni sá yódó nǔú‑xi càcu nehé‑yu òré ducaⁿ càháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Te nchaa ñáyiu ducaⁿ càcunehe veñúhu càhnu sá ǐo cùnuu te ñá dɨ́ú mèe‑ni veñúhu càcu nehé‑yu òré ducaⁿ càháⁿ‑yu, chi tnàhá‑ni Yá Ndiǒxí Yaá cúú cuèndá veñúhu‑áⁿ cácú nèhé‑yu òré ducaⁿ càháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Te nchaa ñáyiu càcunehe andɨu cuendá cutnùní iní tnàha ñáyiú‑yu sá ndàá cadá‑yu ɨɨⁿ sá sání ìní‑yu cadá‑yu, te ñá dɨ́ú mèe‑ni andɨu cacu nehé‑yu chi tnàhá‑ni núú núcǒo Yá Ndiǒxí táxí tnùní‑gá cácú nèhé‑yu òré ducaⁿ càháⁿ‑yu, te tnàhá méé‑gǎ cácú nèhé‑yu òré ducaⁿ càháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Te nchòhó cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ nchòhó cue tée cùu fariséú, cúú‑ndó cuè tée ío dàndahú méé‑xí sǎ quídé ndǎá te ñá ndàá sá quídé ndǎá‑ndó. Te cuěi núú ùxí xichi yúcú mèntá nìhí‑ndó, te sǎñaha‑ndo ɨ̀ɨⁿ xichi xii Yá Ndiǒxí, te dɨu‑ni ducaⁿ quìde‑ndo yúcú nání ànís, ndɨhɨ yúcú nání còminú, dico ndàhú ní cuu‑ndo chi ñá túú quìde cuendá‑ndó nàcuáa càháⁿ nchaa tnúhu sá ǐo‑gá cúnùu sanu ichi ñaha xii‑ndo, te tnúhu‑áⁿ càchí‑xi sá ǐo xìni ñuhu‑xi cada ndáá‑ndó cùndecu‑ndo, te cundàhú iní‑ndó cuè tnaha ñáyiu‑ndo, te quɨndáá iní‑ndó Yǎ Ndiǒxí, te cada‑ndo nchàa nacuáa ndùu tnúhu càháⁿ‑ndó, te nchaa tnúhu‑áⁿ cúú‑xí tnǔhu sá ǐo cùnuu xini ñuhu‑xi cada‑ndo nacuáa càháⁿ‑xi, dico vá dáñá ndèé‑ndó càda‑ndo nchaa dava‑gá nàcuáa càháⁿ tnúhu sá sánú ìchi ñaha xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Te nchòhó cúú‑ndó dàtná cue ñáyiu cuàá, chi ñá túú cùtnuní iní‑ndó nàcuáa canu ichi‑ndo ñǎyiu, chi quìde cuendá‑ndó mèe‑ni nchaa tnúhu sá ñà túú ǐo cùnuu, dico nchaa tnúhu sá ǐo‑gá cúnùu xini ñuhu‑xi cada cuendá‑ndó ñà túú quìde cuendá‑ndó! ");
INSERT INTO milNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Te nchòhó cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ nchòhó cue tée cùu fariséú, cùu‑ndo cue tée ío dàndahú méé‑xí sǎ quídé ndǎá te ñá ndàá sá quídé ndǎá‑ndó. Te ndàhú ní cuu‑ndo chi cùu‑ndo datná cue ñáyiu nàquete sátá‑ni tàsáⁿ ndɨhɨ sátá‑ni cǒhó te xɨtɨ́‑xi càndehe caduha‑ni. Te ducaⁿ sǎtnahá‑xi cùu‑ndo chi mee‑ni sǎ ndécú ndɨ̀hɨ tnaha ñáyiu‑ndo ñùhu iní‑ndó, te nándɨ dàndahú‑ndǒ‑yu te quèheⁿ‑ndo sá ndécú ndɨ̀hɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Te nchòhó cue tée cùu fariséú, cúú‑ndó dàtná cue ñáyiu cuàá, chi ñá túú cùtnuní iní‑ndó nàcuáa ndùu sá quídé‑ndó. Te ío xìni ñuhu‑xi sá cádá‑ndó nàcuáa nduu ndoo nduu nine iní‑ndó cuèndá ndacu‑ndo càda‑ndo sá vǎha, te xíǎⁿ nǔu chí cádá dàtná xǐquide ñáyiu nàquete ndaa xɨtɨ́ tàsáⁿ ndɨhɨ ndàa xɨtɨ́ cóhó. ");
INSERT INTO milNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Te nchòhó cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ nchòhó cue tée cùu fariséú, cùu‑ndo cue tée ío dàndahú méé‑xí sǎ quídé ndǎá te ñá ndàá sá quídé ndǎá‑ndó. Te ndàhú ní cuu‑ndo chi cùu‑ndo datná núú yɨ́ndǔxi ndɨ́yɨ núú nì cuáha vii te ní nacáhyú sǎ cuìxíⁿ, dico xɨtɨ́ yaú‑áⁿ chi càndehe caduha chi mee‑ni yɨ̀quɨ ndɨ́yɨ ñùhu. ");
INSERT INTO milNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Te ducaⁿ sǎtnahá‑xi cùu‑ndo chi sànuu sá cúú‑ndó cuè tée váha dico iní‑ndó chi mee‑ni sǎ cuèhé sá dúhá ñùhu, te ío dàndahú‑ndó mèe‑ndo sá quídé ndǎá‑ndó te ñá ndàá sá quídé ndǎá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Te nchòhó cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ nchòhó cue tée cùu fariséú, cúú‑ndó cuè tée ío dàndahú méé‑xí sǎ quídé ndǎá te ñá ndàá sá quídé ndǎá‑ndó. Te ndàhú ní cuu‑ndo chi càdúha‑ndo nchàa núú nǐ nguɨ́ndǔxi cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, te ío vii quìde‑ndo nchaa núú sǎ nǐ cuáha núú yɨ́ndǔxi cue ñáyiu ní quide váha ní xíndecu ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Te càchí‑ndó: “Te núu dìcó nchoo ni xǐndecu‑o cǔtnàhá ní xíndecu cue ñaní tnáhá‑ó nděé sanaha, te vá chítnàhá‑ó‑güedě cahni‑o cuè tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí dàvá‑áⁿ ní cùu”, duha càchí‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Te sá dúcáⁿ càháⁿ‑ndó, te xíǎⁿ cútnùní sá ɨ́ɨ́ⁿ‑ní cùu‑ndo ndɨhɨ cue ñaní tnáhá‑ndó cuè tée ní xíndecu ndéé sanaha, cue tée ní sahni ñaha xìi cue tée ní cáháⁿ tnúhu Yá Ndiǒxí dàvá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Te núu ducaⁿ te chí dáxǐnu cava chìuⁿ ní tausaha‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Te nchòhó cúú‑ndó cuè tée ío cuihna ìní‑xi, chi cùu‑ndo datná cóó děéⁿ! Te nchòhó vá nìhí‑ndó nàcuáa cada‑ndo cǎcu nihnu‑ndo nǔú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Te cuèndá xíǎⁿ nǔu tendaha‑ǐ cue tée càháⁿ tnúhu Yá Ndiǒxí quixi núú‑ndó, ndɨhɨ cue tée cùu mestrú danèhé ñáhá xìi‑ndo tnúhu‑gá, ndɨhɨ cue tée ío váha cùtnuní iní‑xi cuèndá cáháⁿ‑güedé tnúhu‑gá núú‑ndó. Dico nchòhó chi da cùu úhú iní‑ndó‑güedě, chi dava‑güedé cahni‑ndo‑güedě, te dava‑güedé cata caa‑ndo‑güedě núú cùrúxí, te dava‑güedé cani‑ndo‑güedě xɨtɨ́ veñúhu, te ndɨ tnahá ñuú ndɨ tnahá ñuú quɨ́hɨ́ⁿ‑ndó nànducu‑ndo‑güedé cuèndá cada úhú iní‑ndó‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Te sá dúcáⁿ ná càda‑ndo, te ndadɨ́quɨ́‑ndó cuè tée ní quide ndáá ní xíndecu ní xíhí ní sahni ñaha cuè ñaní tnáhá‑ndó. Te ndéé ndíi Àbél tée ío váha ní quide ndáá ní xíndecu ní sahni‑güedé ndadɨ́quɨ́‑ndó, ndɨhɨ nchaa dava‑gá cue tée ní sahni‑güedé, ndɨhɨ ndéé ndíi Zacàriá déhe ndíi Berèquiás tée ní sahni‑güedé ndéé núú nǐ ndɨhɨ‑ná ndadɨ́quɨ́‑ndó, te ndíi‑áⁿ nǐ sahni‑güedé mei tnùú veñúhu càhnu sá ǐo cùnuu ndɨhɨ xíto núú sácǒdó sǎ ndúú tǎhú Yǎ Ndiǒxí, te nchaa cue tée‑áⁿ ndadɨ́quɨ́‑ndó chi dàtná tnúhu mee‑ndo nǐ sahni‑ndo cuè tée‑áⁿ, chi dɨu‑ni ñaní tnáhá mèe‑ndo ducaⁿ ní sahni ñaha xìi‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nchàa cue tée ní quide ndáá ní xíndecu ní sahni‑güedé, nchaa cue tée‑áⁿ ndadɨ́quɨ́ nchaa ñáyiu ndècu vitna —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Te xǎhaⁿ Jèsús xii ñáyiu ñuú Jerusàlén: —Nchòhó ñáyiu ñuú Jerusàlén sàhni‑ndo cue tée ní tendaha Yǎ Ndiǒxí véxi càháⁿ tnúhu‑gá núú‑ndó, te mee‑ni ndɨ̀hɨ yúú sáhní‑ndó dàva‑güedé. ¡Te yúhú tɨtnɨ́ xito ní cuiní‑í coto ñaha‑ǐ xii‑ndo dàtná quídé nchùxi xito‑güedɨ déhe‑güedɨ sàquɨ́hɨ‑güedɨ xɨtɨ́ ndíxíⁿ‑güedɨ, dico nchòhó ñá túú ní cuìní‑ndó, te dɨu‑ni ducaⁿ sàni iní‑í ndéé vitna! ");
INSERT INTO milNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ sàá nduu te ío ndàhú yáha ñuú‑ndó, te vá cúndècu‑gá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Te na càchí tnúhu tucu‑í xii‑ndo sǎ vǎ quìní ñáhá‑gǎ‑ndó xìi‑í, dico sáá nduu quìní ñáhá tùcu‑ndo, te dàvá‑áⁿ cachí‑ndó: “Ío càhnu cuu Yaá ní tendaha Dǔtú Ndiǒxí véxi”, duha cachí‑ndó —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Te Jèsús ní quee‑gá veñúhu càhnu sá ǐo cùnuu, te mei òré ní queheⁿ‑gá ichi quɨ́hɨ́ⁿ‑gá ɨɨⁿ xichi, te ní sándehe yatni cue tée xìca cuu ndɨhɨ‑gá dɨ̀ñɨ‑gá, te xǎhaⁿ‑güedě xii‑gá: —Cundehe vèñúhu‑a nǎ ío váha ní sáá —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ ncháá sǎ ndéhé‑ndó‑á vìtna saá nduu te vá cúndùu‑gá‑xi dàtná cáá‑xí vìtna, chi ni ɨ̀ɨⁿ‑gá yúú vǎ códó nchìhi tnaha‑xi chi ndɨhɨ ngoyo —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Te Jèsús ní sáá‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá yucu Òlívú, te xíáⁿ nǐ ngóo‑gá te núú núcǒo‑gá‑áⁿ nǐ sáháⁿ cue tée xìca cuu ndɨhɨ‑gá, te dayuhu nǐ xáhaⁿ‑güedě xii‑gá: —Cuìní‑ndɨ́ cachí tnúhu‑n nǎ nduu dùcaⁿ cada‑xi ngoyo veñúhu càhnu sá ǐo cùnuu, ndɨhɨ nándɨ cùu sá cádá‑xí òré sa ta cùyatni nduu quixi tucu‑n ñuyíú‑a, ndɨhɨ òré sa ta cùyatni naa‑xi —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ío quɨhɨ iní‑ndó cùndecu‑ndo cuendá sá vǎ yǒo dandàhú ñáhá xìi‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Chi ío cuéhé cue tée coo ñuyíú, te danàni‑güedé méé‑güedě dàtná nánì‑í, te cachí‑güedé: “Yúhú cúù‑í Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a”, duha cachí‑güedé. Te sá dúcáⁿ cǎháⁿ‑güedé te ío vài ñáyiu dandàhú‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Te níhí‑ndó tnǔhu nàá‑güedé nděni ní cuu, dico vá yùhú‑ndó chi dacuɨtɨ́í sǎ dúcáⁿ càda‑xi, dico vátá sàá‑gá nduu nàa ñuyíú òré ducaⁿ càda‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chi cue tée ɨɨⁿ nàcióⁿ nàá‑güedé ndɨhɨ cue tée ɨngá nàcióⁿ, te tɨtnɨ́ ñuú ngüíta‑güedé nàá‑güedé, te tɨtnɨ́ xichi ñuyíú coo tnamá, te tɨtnɨ́ tucu xichi ñuyíú quixi cuéhé, te tɨtnɨ́ tucu xichi ñuyíú ǐo níhi tnáa. ");
INSERT INTO milNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Te nchaa xíǎⁿ cuu‑xi tnúndòho sá vítná vǎha váha quèsaha sá cúú‑xí cuè ñáyiu xǐndecu ñuyíú. ");
INSERT INTO milNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Te cue ñáyiu na cùu úhú iní ñáhá xìi‑ndo cuáha cuèndá ñáhǎ‑yu núú cuè tée cùchiuⁿ cuendá caniha‑güedě xii‑ndo, te dava‑ndo càhni ñaha‑güedé, te nchaa ñáyiu cuu úhú iní ñáhǎ‑yu xii‑ndo sǎ cuèndá‑í. ");
INSERT INTO milNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Te dàvá‑áⁿ ǐo vài ñáyiu dàñá‑yu sá sàndáá iní‑yu Yá Ndiǒxí, te ngóo‑yu cuu úhú iní tnáhǎ‑yu, te cuáha cuèndá tnáhǎ‑yu núú cuè tée cùchiuⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Te ío vài cue tée cachí‑güedé sá càháⁿ‑güedé tnúhu Yá Ndiǒxí te ñá ndàá sá càháⁿ‑güedé tnúhu‑gá, te ducaⁿ ǐo vài ñáyiu dandàhú‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Te dàvá‑áⁿ cunuu mèe‑ni nchaa sá cuèhé sá dúhá càdá‑yu, te vàí‑yu vá cúú ìní‑gá‑yu tnàha ñáyiú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Dico nchaa ñáyiu na càda ndee‑ni iní canchicúⁿ nihnu ñaha‑ni xìi‑í, ñáyiu‑áⁿ naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Te nɨhìí ñuyíú quɨ̌hɨ́ⁿ ñáyiu cáháⁿ‑yu tnúhu váha, tnúhu sá càháⁿ nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu, te sátá ná nìhí nchaa ñáyiu tnúhu‑áⁿ te naa ñuyíú. ");
INSERT INTO milNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Te ndíi Dàniél tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǐ chídó tnùní ndíi cuèndá ɨɨⁿ sá dáquèe tɨhú Yǎ Ndiǒxí cundecu ɨɨⁿ xichi núú nǐ cuu íí, te xíǎⁿ cada‑xi sá vǎ cúndècu‑gá ni ɨ̀ɨⁿ ñáyiu xíáⁿ. Te cada cuèndá váha‑ndo nàcuáa ní cáháⁿ ndíi, chi nduu na quìní‑ndó xǐǎⁿ cundecu‑xi núú dúcáⁿ nǐ cuu íí, ");
INSERT INTO milNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","te dàvá‑áⁿ nchaa ñáyiu xǐndecu distrìtú Jùdeá xíní ñùhu‑xi cunú‑yu quɨ́hɨ́ⁿ‑yu xɨtɨ́ yucu. ");
INSERT INTO milNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Te nchaa ñáyiu ndáa ndódó dɨ̌quɨ́ véhé‑xí vǎ ndɨ̌hu‑gá‑yu vehé‑yu quehéⁿ‑yu ɨɨⁿ ndachìúⁿ‑yu canehé‑yu quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Te nchaa ñáyiu cuáháⁿ yucu vá nùhú‑gá‑yu vehé‑yu cúnúquehéⁿ‑yu dóǒ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Te ndàhú ní cuu nchaa ñáyiu dɨ̀hɨ́ ñúhú děhe‑xi, ndɨhɨ cue ñáyiu dɨ̀hɨ́ xǐndeca déhe vitna sàdi na saá nduu dùcaⁿ cada‑xi! ");
INSERT INTO milNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Te nchòhó, chí càcáⁿ táhú nǔú Yǎ Ndiǒxí cuèndá sá vǎ dúcáⁿ ndòho‑ndo yóó quídé vǐxiⁿ‑xi, te ni vǎ dúcáⁿ ndòho‑ndo nduu cuu‑xi nduu ndetatú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chi dàvá‑áⁿ coo tnúndòho cahnu vihi ñuyíú, te vátá ɨ́ɨ́ⁿ ndùu‑gá coo tnúndòho cahnu vihi‑áⁿ ndèé cútnàhá ní ngáva ñuyíú, chi dɨu‑ni dàvá‑áⁿ coo tnúndòho cahnu vihi‑áⁿ, te ni nǔú cuàháⁿ núú věxi vá cóó‑gǎ tnúndòho‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Te Yá Ndiǒxí càchí‑gá sá vǎ ǐo vài nduu coo tnúndòho cahnu vihi‑áⁿ sǎ cuèndá nchaa ñáyiu ní cáháⁿ‑gá cundecu ndɨhɨ‑gá. Chi núu vài nduu na coo tnúndòho‑áⁿ te vá yǒo cácu nihnu. ");
INSERT INTO milNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Te núu ìó ñáyiu càchí‑yu xii‑ndo: “Chí cúndèhe iha, chi iha ní quexìo Cristú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a”, àdi cachí‑yu: “Chí cúndèhe yacáⁿ chi yàcáⁿ ndécú‑gǎ”, càchí‑yu ña. Te vá quɨ̀ndáá iní‑ndó tnǔhu càháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chi coo cue tée cachí‑güedé sá cúú‑güedě Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a, te dava‑güedé cachí‑güedé sá cúú‑güedě cue tée càháⁿ tnúhu Yá Ndiǒxí dico ñá ndàá sá cúú‑güedě cue tée càháⁿ tnúhu‑gá, te cada‑güedé tɨtnɨ́ núú sǎ vǎ yǒo tnàhí ndàcu cada cuendá dandàhú‑güedé ñáyiu. Te cani iní‑güedé dandàhú‑güedé ndéé cue ñáyiu ní cáháⁿ Yǎ Ndiǒxí cundecu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Te duha ndùu tnúhu càháⁿ‑í dátǔha ñaha‑ǐ xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Te núu càchí‑yu xii‑ndo: “Xɨtɨ́ yucu‑ǎⁿ ní quexìo Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a”, càchí‑yu. Te vá quɨ̀ndáá iní‑ndó quɨ̌hɨ́ⁿ‑ndó, àdi cachí‑yu: “Vehe‑ǎⁿ ndécú Yàá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a”, càchí‑yu. Te vá quɨ̀ndáá iní‑ndó tnǔhu càháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Chi dàtná xìní nchaa ñáyiu quìde‑xi oré sàá ndúté dàyehé‑xi nɨ càa xico ñuyíú ducaⁿ càda‑xi oré quixi tucu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo chi nchaá‑yu quiní ñáhǎ‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Te nchòhó xìní‑ndó sǎ ncháá nǔú yúcú yɨ̀quɨ cuñú ní xíhí te yàcáⁿ tàcá nchaa ndɨxíí xéxí‑güèdɨ. ");
INSERT INTO milNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Te na yǎha‑ni coo tnúndòho cahnu vihi‑áⁿ, te vá dáyèhé‑gá nchícanchii, te ni vǎ dáyèhé‑gá yóó, te ngoyo nchaa chódíní ndèé andɨu, te quɨdɨ‑xi andɨu ");
INSERT INTO milNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","nàcuáa cutnùní iní ñáyiu sá sà véxi yúhú Tée cùu ñaní tnáhǎ‑yu nchaá‑yu. Te cue ñáyiu nɨhìí ñuyíú ndǎhyú‑yu sá ndɨ̀hú iní‑yu òré ducaⁿ càda‑xi, te nchaá‑yu quiní ñáhǎ‑yu xii‑í quee‑í andɨu quìxi‑í ichi xɨtɨ́ vícó, te quiní‑yu sá ǐo càhnu cuu‑í, te quìde‑í nchaa sá vǎha. ");
INSERT INTO milNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Te tauchìuⁿ‑í cue espíritú xínú cuèchi núù‑í níhi tɨú‑xi cútú nadatàcá‑xi nchaa ñáyiu ní cáháⁿ‑í chitnahá ñáhá xìi‑í xǐndecu nɨ càa xico ñuyíú. ");
INSERT INTO milNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Te nchòhó sa xìní‑ndó nàcuáa quìde yutnu ngúxí, chi yutnu‑áⁿ ndúú yùte núú dìté‑xi te nàtáhú ndaha‑xi. Te òré ducaⁿ quìde‑xi te càchí‑ndó sǎ sà ní cuyatni nuu cahni. ");
INSERT INTO milNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Te dɨu‑ni ducaⁿ sǎtnahá‑xi cada‑xi ñuyíú‑a òré ná quìní‑ndó càda‑xi nchaa nacuáa ní cáháⁿ‑í, te cutnùní iní‑ndó sǎ sà ní cuyatni vií‑nǎ nduu nàa ñuyíú. ");
INSERT INTO milNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ òré vátá cùú‑gá nchaa ñáyiu xǐndecu ñuyíú‑a vitna, te cada‑xi nchaa nàcuáa ní cáháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Te andɨu ndɨ̀hɨ ñuyíú‑a chi ndɨhɨ nihnu‑xi, dico tnúhu‑í chi vá ndɨ́hɨ́ nìhnu‑xi chi cùu‑xi tnúhu ndáá cuɨtɨ. ");
INSERT INTO milNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Dico ñá túú cùtnuní ná nduu quìxi tucu‑í, te ni ñà túú cùtnuní ná òré chi vá yǒo xìní, te ni cuè espíritú xínú cuèchi núú Yǎ Ndiǒxí ñá túú xìní‑xi ná nduu quìxi‑í, te ni mèe yúhú Tée cùu Déhe Dútú Ndiǒxí ñá túú xìní‑í ná nduu quìxi tucu‑í, chi ɨɨⁿdìi díí‑ni mee‑gǎ xìní‑gá nǔu ná nduu quìxi‑í. ");
INSERT INTO milNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Te nduu na quìxi tucu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ñuyíú‑a te cada‑xi dàtná ní quide‑xi cútnàhá ní xíndecu ndíi Nǒé. ");
INSERT INTO milNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chi nchaa ñáyiu ní xíndecu dàvá‑áⁿ òré vátá ndáá‑gǎ ndute ñuyíú, te xèxí‑yu xìhí‑yu quìdé‑yu, te davá‑yu ìó‑yu vico tnǎndaha, te davá‑yu dàsáⁿ‑yu déhe yòcó‑yu candeca ñaha těe, te ducaⁿ‑ni xǐquidé‑yu ndéé ní sáá nduu cuǎnguee té Nǒé xɨtɨ́ bàrcú. ");
INSERT INTO milNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Te ñá túú ní cùtnuní iní‑yu nàcuáa cada‑xi ñuyíú ndèé ní sáá nduu nǐ ngüíta‑xi ní cuuⁿ dáú nǐ ndaa ndute ñuyíú nǐ dánáá ñàha‑xi xií‑yu. Te dɨu‑ni ducaⁿ sǎtnahá tucu‑xi cada‑xi nduu na quìxi tucu yúhú Tée cùu ñaní tnáhǎ‑yu nchaá‑yu ñuyíú‑a, chi nduu ñà túú nǎ yɨ́hɨ́ ìní‑yu te quixi tucu‑í. ");
INSERT INTO milNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Te dàvá‑áⁿ nǔu úú tnàhá cue tée yɨ̀hɨ‑güedé xɨtɨ́ yucu, te ɨɨⁿ‑dé ndanchita te ɨɨⁿ‑dé quendóo. ");
INSERT INTO milNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Àdi úú ñáyiu dɨ̀hɨ́ nchícǒ‑yu ɨɨⁿ‑ni vèhe, te ɨɨ́ⁿ‑yu ndanchita te ɨɨ́ⁿ‑yu quendóo. ");
INSERT INTO milNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Te duha ndùu tnúhu càháⁿ‑í cuèndá nchòhó cundecu túha‑ndo, chi ñá túú xìní‑ndó nǎ òré quixi tucu yúhú Yaá cúú Xǐtohó‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Te nchòhó xìní‑ndó sǎ nǔu ɨɨⁿ tée cùu xítohó vehe xìní‑dé ná òré cúú‑xí nìú quɨ́hu ñadúhú vehe‑dé duhu‑güedě, te quɨhɨ iní‑dé cundecu‑dé cuèndá sá vǎ dáñá‑dě quɨ́hu ñadúhú‑ǎⁿ vehe‑dé duhu‑güedě, dico ñá túú xìní‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Te duha càháⁿ‑í chi nchòhó xíní ñùhu‑xi cundecu túha‑ndo, chi na cuáháⁿ òré ñá túú nǎ yɨ́hɨ́ ìní‑ndó quèxio yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Te na càni‑í ɨɨⁿ cuèndú núú‑ndó. Ɨɨⁿ tée xìnu cuechi núú ɨɨⁿ pàtróóⁿ cúú‑dě ɨɨⁿ tée ío váha tècú tnùní, te quìde ndáá‑dé ndécú‑dě. Te ɨɨⁿ xito ní dándǒo ndaha ñàha patróóⁿ‑dě xii‑dé nchaa cue ñáyiu ndècu vehe‑dé cuèndá coto ñaha‑dě xií‑yu cuáñaha‑dě sá cáxǐ‑yu òré tàú‑xi caxí‑yu, te tée cùu patróóⁿ‑áⁿ nǐ quee‑dé cuáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Te váha táhú těe xìnu cuechi‑áⁿ te núu nděcuu‑dé quídé‑dě nchaa nàcuáa ní xáhaⁿ pàtróóⁿ‑dě cada‑dé mei òré ní nasáá pàtróóⁿ‑dě‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ těe cùu patróóⁿ‑dě‑áⁿ cǔñaha‑dě xii‑dé sá quɨ́ndàha‑dé nchaa sá ndécú ndɨ̀hɨ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dico núu tée xìnu cuechi‑áⁿ ní cùu‑dé ɨɨⁿ tée cuihna ìní‑xi, te ngóo‑dé cani iní‑dé sá cúyàa patróóⁿ‑dě vá násàá ndɨ̌hɨ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Te ngüíta‑dé cani‑dé nchaa dava‑gá cue ñáyiu xìnu cuechi ndɨhɨ‑dé, te ngóo‑dé caxi‑dé coho‑dé cada‑dé ndɨhɨ nchaa cue tée quɨhu. ");
INSERT INTO milNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Te ɨɨⁿ nduu òré ñá túú yɨ̀hɨ iní‑dé nasáá pàtróóⁿ‑dě, ");
INSERT INTO milNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","te ío dandòho ñaha patróóⁿ‑dě xii‑dé, chi daquɨ̀hɨ́ⁿ ñáhá‑dě xii‑dé núú xǐndecu cue ñáyiu ní cachí sá nǐ quide ndáá te ñá ndàá sá nǐ quide ndáá‑yu. Te ducaⁿ sǎtnahá‑xi dandòho ñaha Yá Ndiǒxí xii ñáyiu, chi daquɨ̀hɨ́ⁿ ñáhá‑gǎ xií‑yu ɨɨⁿ xichi núú ǐo ndohó‑yu te yàcáⁿ ío ndáhyú‑yu, te dìcó rúhñú‑nǎ cuu núhu‑yu sá sàtú iní‑yu sá ndóhǒ‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Te xǎhaⁿ tùcu Jesús xii‑güedé: —Na càni‑í ɨɨⁿ cuèndú núú‑ndó nàcuáa tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Te úxí tnàhá ñáyiu dɨ̀hɨ́ ñáyiu cuechi nǐ quehéⁿ‑yu lìntérnǎ‑yu, te cuáháⁿ‑yu ɨɨⁿ xichi núú cóó vìco tnándaha cuèndá cundetú‑yu quexìo tée tnándaha. ");
INSERT INTO milNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Te úhúⁿ ñáyiu cuechi‑ǎⁿ ǐo váha cùtnuní iní‑yu, te úhúⁿ‑yu ñáhá. ");
INSERT INTO milNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Te ndɨ ùhúⁿ ñáyiu cuechi dùcaⁿ ñá túú cùtnuní iní‑xi‑áⁿ ñà túú ní cǎnehé‑yu sá nděe lìntérnǎ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dico ndɨ ùhúⁿ ñáyiu cuechi cùtnuní iní‑xi‑áⁿ néhě‑yu sá nděe lìntérnǎ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Te tée tnándaha‑áⁿ cúyàa‑dé quexìo‑dé núú ndétú ñàhá‑yu‑áⁿ, te nɨni dùcaⁿ cuyaa‑dé ní tnɨɨ ñaha sàní xií‑yu ní xídí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Te cùu‑xi datná dava niú níhi ní cáháⁿ dava‑gá ñáyiu, te càchí‑yu: “Sa véxi tée tnándaha, chí táquèe quehé queheⁿ cuèndá‑ndó‑dě”, càchí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Te ndɨ ùxí ñáyiu cuechi‑ǎⁿ nǐ ndacóo‑yu quìde túha‑yu lìntérnǎ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Te ndɨ ùhúⁿ ñáyiu cuechi ñà túú cùtnuní iní‑xi‑áⁿ nǐ xáhǎⁿ‑yu xii cue ndɨ ùhúⁿ ñáyiu cùtnuní iní‑xi‑áⁿ: “Chí táxí nùu luha sá nděe lìntérná‑ndó ná nděe lìntérná‑ndɨ̌ chi ñá cuìní‑xi cáyú mee‑ni ndàhvá”, càchí‑yu xǎhǎⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Te cue ñáyiu cuechi cùtnuní iní‑xi‑áⁿ nǐ xáhǎⁿ‑yu: “Vá táxí nùu‑ndɨ́ chi vá tnàhá canehe chìuⁿ mee‑ndɨ́, te váha‑gá chí cuàháⁿ cuaaⁿ‑ndo nǔú cuè ñáyiu xǐdícó cuèndá sá vǎ cúmǎní xii‑ndo, te vá cúmǎní xii nchúhú tucu”, càchí‑yu xǎhǎⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Te nɨni cuǎháⁿ ndɨ ùhúⁿ ñáyiu ducaⁿ ñà túú cùtnuní iní‑xi‑áⁿ cuǎnguaáⁿ‑yu sá nděe lìntérnǎ‑yu ní quexìo tée tnándaha. Te ndɨ ùhúⁿ ñáyiu cuechi cùtnuní iní‑xi‑áⁿ nǐ queheⁿ cuèndá ñáhǎ‑yu xii‑dé, te cuánguɨhu ndɨhɨ ñàhá‑yu xii‑dé núú cóó vìco tnándaha, te sátá dúcáⁿ te ní nandedɨ́ yuyèhe. ");
INSERT INTO milNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Te òré ní nasáá cue ñáyiu cuechi ñǎyiu ní sánguaaⁿ sá nděe lìntérná‑xi‑áⁿ, te ní ngüíta‑yu càháⁿ‑yu xǐnutnɨ́ɨ‑yu ndàa sátá yuyèhe ndaa quehé, te xǎhǎⁿ‑yu xii tée tnǎndaha‑áⁿ: “¡Tǎta, nacaáⁿ yuyèhe na quɨ́hu‑ndɨ́!”, càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Te tée tnǎndaha‑áⁿ nǐ xáhaⁿ‑dě xií‑yu: “Na càchí tnúhu ndáá‑í xii‑ndo sǎ nchòhó ñá túú tàú‑ndó quɨ̌hu‑ndo vìco‑a, chi ñá túú tnàhá tnúhu ndɨhɨ ñaha‑ndo xìi‑í”, càchí‑dé xǎhaⁿ‑dě xií‑yu —càchí Jèsús xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Te xǎhaⁿ tùcu Jesús xii‑güedé: —Ío quɨhɨ iní‑ndó cùndecu‑ndo, chi ñá túú xìní‑ndó nǎ nduu, te ni ñà túú xìní‑ndó nǎ òré quixi tucu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Te xǎhaⁿ tùcu Jesús xii‑güedé: —Na càni tucu‑í ɨngá cuèndú núú‑ndó nàcuáa tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Ɨɨⁿ tée sa ñùhu ichi‑ná‑dé sá cácá‑dě quɨ́ngaca cuu xica‑dě, te ní cana‑dé cue tée xìnu cuechi núú‑dě cuèndá dàndóo ndaha ñàha‑dé díhúⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Te nàcuáa ndùu chiuⁿ quide ɨɨⁿ ɨɨⁿ‑güedé te ducaⁿ dǐhúⁿ nǐ sáñaha‑dě xii‑güedé, te ɨɨⁿ‑dé ní sáñaha‑dě úhúⁿ tnàhá díhúⁿ sǎ ǐo yahu nàni talentú, te ɨngá‑dé ní sáñaha‑dě úú tnàhá díhúⁿ‑ǎⁿ, te ɨngá‑dé ní sáñaha‑dě ɨɨⁿ díhúⁿ‑ǎⁿ, te dǎtnùní ní quee‑dé cuáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Te tée ní queheⁿ cuèndá úhúⁿ tnàhá díhúⁿ sǎ nání tàlentú ní quide‑dé ndáhú ndɨhɨ‑xi te ní níhí tucu‑dé úhúⁿ‑gá tucu tnàhá díhúⁿ‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Te dɨu‑ni ducaⁿ nǐ quide tucu tée ní níhí ǔú díhúⁿ sǎ nání tàlentú‑áⁿ, chi ní quide‑dé ndáhú te ní níhí tucu‑dé úú‑gá tucu tnàhá. ");
INSERT INTO milNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dico tée ní níhí ɨɨⁿ‑ni díhúⁿ‑ǎⁿ chi da ní chiváha‑dé díhúⁿ pàtróóⁿ‑dě, chi ní xete‑dé ɨɨⁿ yaú te ní chindúxi‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Te ní cuu cuéhé nduu sá nǐ quee pàtróóⁿ‑güedě‑áⁿ ní sángaca cuu‑dé, te ní nasáá‑dé te ní ngüíta‑dé quídé ndǎá‑dé ndɨhɨ‑güedé cuèndá díhúⁿ sǎ nǐ dándǒo ndaha ñàha‑dé xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Te tée ní quendóo ndaha ǔhúⁿ tnàhá díhúⁿ‑ǎⁿ nǐ xáhaⁿ‑dě xii pàtróóⁿ‑dě: “Pàtróóⁿ, náu úhúⁿ tnàhá díhúⁿ sǎ nǐ dándǒo ndaha ñàha‑n xii‑í‑a, te ní sáháⁿ‑í ní quide‑í ndɨhɨ‑xi ndáhú te ní chídó‑xí ǔhúⁿ‑gá tucu tnàhá, te náu‑a naqueheⁿ cuèndá‑n”, càchí‑dé xǎhaⁿ‑dě xii pàtróóⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Te tée cùu patróóⁿ‑dě‑áⁿ nǐ xáhaⁿ‑dě xii‑dé: “Ío váha ní quide‑n, te vitna quìde ñaha‑í xii‑n ɨ̀ɨⁿ tée váha tée quìde ndáá, te sá sàcú díhúⁿ nǐ dándǒo ndaha ñaha‑ǐ xii‑n te ní quide ndáá‑n, te sá dúcáⁿ nǐ quide‑n te vài‑gá taxi cuèndá ñáhà‑í xii‑n. Te vitna cuu cundecu‑n nǔú ndécù‑í, te ío cudɨ́ɨ́ ìní‑ó cùndecu ndɨhɨ tnaha‑o”, cachí tée cùu patróóⁿ‑dě‑áⁿ xǎhaⁿ‑dě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Te sátá dúcáⁿ te tée ní quendóo ndaha ǔú tnàhá díhúⁿ sǎ nání tàlentú‑áⁿ nǐ xáhaⁿ‑dě xii pàtróóⁿ‑güedě: “Pàtróóⁿ, náu úú tnàhá díhú sǎ nǐ dándǒo ndaha ñàha‑n‑a, te ní sáháⁿ‑í ní quide‑í ndɨhɨ‑xi ndáhú, te ní chídó‑xí ǔú‑gá tucu tnàhá, te náu‑a naqueheⁿ cuèndá‑n”, càchí‑dé xǎhaⁿ‑dě xii pàtróóⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Te ní xáhaⁿ těe cùu patróóⁿ‑áⁿ xii‑dé: “Ío váha ní quide‑n, te vitna quìde ñaha‑í xii‑n ɨ̀ɨⁿ tée váha tée quìde ndáá, te sá sàcú díhúⁿ nǐ dándǒo ndaha ñaha‑ǐ xii‑n te ní quide ndáá‑n, te sá dúcáⁿ nǐ quide‑n te vài‑gá taxi cuèndá‑í. Te vitna cuu cundecu‑n nǔú ndécù‑í, te ío cudɨ́ɨ́ ìní‑ó cùndecu ndɨhɨ tnaha‑o”, cachí tée cùu patróóⁿ‑áⁿ xǎhaⁿ‑dě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Te tée ní ndóo ndaha ɨ̀ɨⁿ‑ni díhúⁿ‑ǎⁿ nǐ xáhaⁿ‑dě xii tée cùu patróóⁿ‑dě‑áⁿ: “Pàtróóⁿ, yúhú sa nàha‑í sá yòhó cúú‑n ɨ̀ɨⁿ tée ndùcu mee‑ni sá cúú‑xí mèe‑xi te tàhu‑n chiuⁿ cuáháⁿ nchúhú cue tée xìnu cuechi núú‑n sàcáⁿ‑ndɨ́ trìú, te òré ná nàtaxi tnaha‑ndɨ́, te yòhó dìcó‑nǎ náquèheⁿ cuendá‑n tàxúha‑n. ");
INSERT INTO milNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Te núu xíǎⁿ ní yùhú‑í cada‑í ndáhú ndɨhɨ díhúⁿ‑n, te ní sáháⁿ‑í ní xete‑í ɨɨⁿ yaú te ní chindúxi‑í, te náu díhúⁿ‑n‑áⁿ naqueheⁿ cuèndá‑n”, càchí‑dé xǎhaⁿ‑dě xii tée cùu patróóⁿ‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Te tée cùu patróóⁿ‑áⁿ nǐ xáhaⁿ‑dě: “Yòhó cúú‑n ɨ̀ɨⁿ tée cuihna ìní‑xi xìnu cuechi núù‑í te cuhndu‑n, te núu yòhó sání ìní‑n sǎ cúù‑í ɨɨⁿ tée tàuchiuⁿ cuáháⁿ‑ndó sàcáⁿ‑ndó trìú te òré nátàxi tnaha‑ndo, te yúhú dìcó‑nǎ náquèheⁿ cuendá‑í nátàxúha‑í. ");
INSERT INTO milNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Te núu sàni iní‑n sǎ dúcáⁿ quìde‑í, te dasaⁿ nùu‑n díhùⁿ‑í te cúñaha‑n chǎhu‑yu dɨ́quɨ́‑xi ni cùu, te òré ndexìo‑í te sa ngódó lùha‑gá dɨ́quɨ́‑xi naqueheⁿ‑í ní cùu”, cachí‑dé xǎhaⁿ‑dě xii tée xìnu cuechi‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Te tée cùu patróóⁿ‑áⁿ nǐ xáhaⁿ‑dě xii dava‑gá cue tée ndècu ndɨhɨ‑dé: “Chí quéndèé ɨɨⁿ díhúⁿ sǎ nání tàlentú néhé těe‑áⁿ, te cuáha‑ndo těe nèhe úxí tnàhá dɨu‑ni díhúⁿ‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chi cue tée sa ndècu ndɨhɨ te níhí‑gǎ‑güedé cundecu ndɨhɨ‑güedé, te ni vǎ nìhí‑gá‑güedé ndèé cundecu nchaa sá cúndècu ndɨhɨ‑güedé. Te cue tée ñá túú nǎ ndécú ndɨ̀hɨ vai, te nchaa sá ndécú ndɨ̀hɨ‑güedé vá cúndècu ndɨhɨ‑gá‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Te tée xìnu cuechi ñá túú vědana nàndɨ́hɨ‑áⁿ, chí tnɨ́ɨ́‑dě te daquɨ̀hɨ́ⁿ‑ndó‑dě ɨɨⁿ xichi núú néé nǔú ǐo ndoho‑dé, te yàcáⁿ ndáhyú‑dé, te dìcó rúhñú‑nǎ cuu núhu‑dé sá sàtú iní‑dé sá ndóhó‑dě”, càchí tée cùu patróóⁿ‑áⁿ xǎhaⁿ‑dě xii‑güedé. Duha sǎtnahá‑xi ndoho nchaa ñáyiu ñá túú quìde váha —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Te xǎhaⁿ tùcu Jesús xii‑güedé: —Te nduu na quìxi tucu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, te quixi‑í ndɨhɨ nchaa cue espíritú xínú cuèchi núù‑í, te nchaa ñáyiu quiní‑yu sá ǐo càhnu cuu‑í, te dàvá‑áⁿ cunucóo‑í núú táxí tnùní‑í, te ío cuñúhu ñáyiu sá ǐo càhnu cuu‑í. ");
INSERT INTO milNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Te dàvá‑áⁿ natacá nchaa ñáyiu xǐndecu nɨ càa xico ñuyíú cundecú‑yu núù‑í, te cada‑í‑yu dàtná quídé ɨ̀ɨⁿ toli oré táú dɨ̀ɨⁿ‑dé nchaa mběé ndɨhɨ nchaa chìvá chi dɨ̀ɨⁿ taxi ndecu‑dé nchaa mběé, te dɨ̀ɨⁿ taxi ndecu‑dé nchaa chìvá. ");
INSERT INTO milNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Te ducaⁿ sǎtnahá‑xi cada‑í chi nchaa ñáyiu ní quide ndáá núù‑í ñáyiu‑áⁿ taxi ndecu‑í‑yu xio cùha‑í, te nchaa ñáyiu cuihna ìní‑xi ñá túú ní cuìní cada ndáá núù‑í ñáyiu‑áⁿ taxi ndecu‑í‑yu xio dàtni‑í. ");
INSERT INTO milNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Te ducaⁿ te yúhú tée ío cùnuu cúñaha‑ǐ xii ñáyiu na cùndecu xio cuha‑í: “Nchaa nchòhó ñáyiu ní quide váha ñaha Tǎtà‑í Dútú Ndiǒxí, chí nèhé chi vitna ní sáá nduu cùndecu‑ndo núú ndécú‑gǎ táxí tnùní‑gá, chi ndéé cútnàhá ní ngáva ñuyíú sa ndècu túha tnàhí núú ndécú‑gǎ‑áⁿ sǎ nchòhó nduu táhú‑ndó cùndecu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Te ducaⁿ chi òré xìhí‑í docó te ní taxi‑ndo sǎ nǐ xexi‑í, te òré yìchí‑í ndute te ní taxi‑ndo ndùte ní xihi‑í, te òré ñúhù‑í ichi te ní taxi‑ndo vèhe ní ndetatú‑í. ");
INSERT INTO milNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Te òré xíní ñùhu‑í dóó cuihnu‑í te ní taxi‑ndo, te òré ní cuhú‑í te ní quixi coto ñaha‑ndo xìi‑í, te òré ní xɨ́hɨ‑í vecaá te ní quixi tucu‑ndo nǐ quixi coto ñaha‑ndo xìi‑í”, duha cúñaha‑ǐ xii nchaa ñáyiu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Te nchaa ñáyiu ducaⁿ nǐ quide ndáá‑áⁿ cǔñàhá‑yu xii‑í: “Yòhó Yaá cúú Xǐtohó‑ndɨ́, ni ɨ̀ɨⁿ xito ñá túú ní tàxi‑ndɨ́ sá cáxí‑n òré xìhí‑n dòcó, te ni ɨ̀ɨⁿ xito ñá túú ní tàxi‑ndɨ́ ndute coho‑n òré yìchí‑n. ");
INSERT INTO milNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Te ni ñà túú ní tàxi‑ndɨ́ vehe ndetatú‑n òré ñúhú‑n ìchi, te ni ñà túú ní tàxi‑ndɨ́ dóó cuihnu‑n òré xíní ñùhu‑n. ");
INSERT INTO milNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Te ni ñà túú ní quìxi coto ñaha‑ndɨ́ xii‑n òré ní cuhú‑n, te ni ñà túú ní quìxi coto ñaha‑ndɨ́ xii‑n òré ní xɨ́hɨ‑n vècaá”, duha quesàhá‑yu cúñàhá‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Te yúhú tée cùnuu cúñaha‑ǐ xií‑yu: “Na càchí tnúhu ndáá‑í xii‑ndo sǎ ncháá sǎ vǎha ní quide‑ndo sǎ cúú‑xí nchàa ñáyiu xǐndecu ichi‑í cuěi ío ndàhú xǐndáa‑yu, te sá dúcáⁿ nǐ quide‑ndo sǎ vǎha sá cúú‑xǐ‑yu, te cada iní‑ndó sǎ mèe‑í ducaⁿ nǐ quide‑ndo nǐ xito ñaha‑ndo xìi‑í”, duha cúñaha‑ǐ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Te dǎtnùní cúñaha‑ǐ xii ñáyiu na cùndecu xio datni‑í: “Nchaa nchòhó ñáyiu ní xíta nihnu chí xócuɨ̀ñɨ́ núú ndécù‑í‑a, chi nchòhó ní nduu táhú‑ndó cùndecu‑ndo núú ñùhú núú càyú, dɨu‑ni núú nǐ quide túha‑í cundecu sácuíhná ndɨhɨ nchaa espíritú cúndɨ̀hɨ‑xi, te yàcáⁿ cundecu‑ndo nɨ̀ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Chi yúhú òré xìhí‑í docó te ñá túú ní tàxi‑ndo sá cáxì‑í, te ni òré yìchí‑í ndute te ñá túú ní tàxi‑ndo ndute coho‑í. ");
INSERT INTO milNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Te ni òré ní xúhuⁿ‑í ichi ñá túú ní tàxi‑ndo vehe ndetatú‑í, te ni òré xíní ñùhu‑í dóó cuihnu‑í te ñá túú ní tàxi‑ndo, te ni òré ní cuhú‑í te ñá túú ní quìxi‑ndo quixi coto ñaha‑ndo xii‑í, te ni òré ní xɨ́hɨ‑í vecaá te dɨu‑ni ducaⁿ nǐ quide‑ndo ñà túú ní quìxi‑ndo quixi coto ñaha‑ndo xii‑í”, duha cúñaha‑ǐ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Te ñáyiu‑áⁿ cǔñàhá‑yu xii‑í: “Yòhó Yaá cúú Xǐtohó‑ndɨ́ ni ɨ̀ɨⁿ xito ñá túú ní xìní‑ndɨ́ òré xìhí‑n dòcó cuèndá taxi‑ndɨ́ sá cáxí‑n, te ni ɨ̀ɨⁿ xito ñá túú ní xìní‑ndɨ́ òré yìchí‑n ndùte cuendá taxi‑ndɨ́ ndute coho‑n, te ni ɨ̀ɨⁿ xito ñá túú ní xìní‑ndɨ́ cuhuⁿ‑n ìchi cuendá taxi‑ndɨ́ vehe ndetatú‑n, te ni ɨ̀ɨⁿ xito ñá túú ní xìní‑ndɨ́ òré xíní ñùhu‑n dóó cuèndá taxi‑ndɨ́ dóó cuihnu‑n, te ni ɨ̀ɨⁿ xito ñá túú ní xìní‑ndɨ́ òré cùhú‑n cuèndá quixi coto ñaha‑ndɨ̌ xii‑n, te ni ɨ̀ɨⁿ xito ñá túú ní xìní‑ndɨ́ quɨhɨ‑n vècaá cuèndá quixi coto ñaha‑ndɨ̌ xii‑n”, duha quesàhá‑yu cúñàhá‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Te yúhú cúñaha‑ǐ xií‑yu: “Na càchí tnúhu ndáá‑í xii‑ndo sǎ sǎ cuèndá sá ñà túú ní quìde‑ndo ɨɨⁿ sá vǎha sá cúú‑xí cuè ñáyiu ndècu ichi‑í cuěi ío ndàhú xǐndáa‑yu, te sá dúcáⁿ nǐ quide‑ndo ñà túú ní quìde‑ndo sá vǎha sá cúú‑xǐ‑yu, te cada iní‑ndó sǎ mèe‑í ducaⁿ nǐ quide‑ndo ñà túú ní quìde‑ndo sá vǎha sá cúú‑xì‑í”, duha cúñaha‑ǐ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Te nchaa ñáyiu‑áⁿ quɨ̌hɨ́ⁿ‑yu núú ùhú núú ndàhú nɨ caa nɨ quɨ́hɨ́ⁿ. Te nchaa ñáyiu ní quide ndáá núù‑í ní xíndecu ñuyíú‑a, ñáyiu‑áⁿ nduu táhǔ‑yu ío váha cundecú‑yu nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Te sátá nǐ yáha ducaⁿ nǐ cáháⁿ Jèsús, te ní xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá: ");
INSERT INTO milNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Nchòhó sa xìní‑ndó sǎ cùmání ǔú‑gá nduu te coo vico pàscuá, te càchí tnúhu‑í xii‑ndo sǎ yǔhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo tnɨɨ ñaha‑güedé xii‑í, te cuáha cuèndá ñáhá‑güedě núú cuè tée cùu úhú iní ñáhá xìi‑í, te cata caa ñaha‑güedě núú cùrúxí te núú cùrúxí‑áⁿ cuú‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Te dɨu‑ni òré càháⁿ ndɨhɨ Jèsús cue tée xìca cuu ndɨhɨ‑gá ní natacá cue tée cùu dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél. Te mei quèhé vehe núú cúú vèchiuⁿ té Caìfás tée cùu dútú ǐo‑gá cúnùu ní natacá‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Te xíáⁿ nǐ ndatnúhu‑güedé nàcuáa cada‑güedé dandàhú‑güedé Jèsús cuèndá tnɨɨ ñaha‑güedě xii‑gá, te cahni ñaha‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Te ní xítnàha‑güedé: —Váha‑gá sá vǎ tnɨ́ɨ́‑ó Jèsús mei ndùu vico, chi núu ducaⁿ na càda‑o te ío dusaⁿ càda ñáyiu —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Te ndècu Jesús ñuú Bètaniá vehe ɨɨⁿ tée nàni Xímú, tée ní tnahá cuéhé sǎ dátèhyú nihnu‑xi yɨquɨ cùñú‑ó. ");
INSERT INTO milNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Te xíáⁿ ndécú‑gǎ ní quexìo ɨɨⁿ ñadɨhɨ́ néhé‑áⁿ ɨ̀ɨⁿ sá nǐ cuáha yúú vǎha nàni alabastrú, te xɨtɨ́ xíǎⁿ ñúhú àcití sàháⁿ tnámí sǎ ǐo ndèyáhu. Te yɨ̀hɨ Jesús mèsá xéxí‑gǎ, te ñaha‑áⁿ nǐ sáháⁿ‑aⁿ ní sódó‑aⁿ àcití ñúhú xɨ̀tɨ́ xíǎⁿ dɨ́quɨ́‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Te òré ní xiní cue tée xìca cuu ndɨhɨ Jesús sá dúcáⁿ nǐ quide ñaha‑áⁿ te ní cudééⁿ‑güedě, te ní ngüíta‑güedé xǐtnàha‑güedé: —Ñá túú quìde váha ñaha‑ǎⁿ dàcáⁿ quídé‑áⁿ dacuǐta‑aⁿ acìtí‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Chi váha‑gá nǔu cuyáhu acìtí‑ǎⁿ ní cùu chi ío ndèyáhu, te díhúⁿ cuyáhu acìtí‑ǎⁿ cuu cuèndá cue ñáyiu ndàhú ní cùu —cachí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Te Jèsús ní cutnùní iní‑gá nàcuáa ndùu tnúhu xǐtnàha‑güedé, núu ní xáhaⁿ‑gǎ xii‑güedé: —Vá dásàtú‑ndó ìní ñadɨ̀hɨ́‑a, chi sá nǐ quide ñaha‑aⁿ xìi‑í cúú‑xí ɨ̀ɨⁿ sá vǎha. ");
INSERT INTO milNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Chi cue ñáyiu ndàhú ducaⁿ‑ni cùtnahá ñáyiu‑áⁿ tnuú‑ndó, dico yúhú chi vá ncháá ndùu cundecu ndɨhɨ ñaha‑í xii‑ndo ñùyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Te sá dúhá nǐ quide ñaha ñàdɨhɨ́‑a xii‑í ní sódó‑aⁿ àcití dɨ́quɨ̀‑í, te xíǎⁿ cada iní‑ndó sǎ sà quide túha‑aⁿ yɨquɨ cùñú‑í cuèndá nguɨ́ndǔxi‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nděni ní cuu nɨhìí ñuyíú ná càháⁿ ñáyiu tnúhu‑í, te cáháⁿ‑yu tnàhá cuèndá ñadɨ̀hɨ́‑a cuèndá quiní nchaa ñáyiu nàcuáa ní quide‑aⁿ te ducaⁿ vǎ nácuànaá‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Te sátá dúcáⁿ te té Jùdás Iscàrioté ní sáháⁿ‑dé ní ndatnúhu‑dé ndɨhɨ cue tée cùu dútú cúnùu. Te núú tnàhá té Jùdás‑áⁿ cúú ùxúú cue tée xìca cuu ndɨhɨ Jesús. ");
INSERT INTO milNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Te ní xáhaⁿ‑dě xii cue tée cùu dútú cúnùu‑áⁿ: —¿Ndědau cháhu ñaha‑ndo xìi‑í te taxi cuèndá‑í Jèsús xii‑ndo‑i? —càchí‑dé xǎhaⁿ‑dě xii‑güedé. Te cue dútú‑ǎⁿ nǐ xáhaⁿ‑güedě xii‑dé sá cuǎñaha‑güedě ócó úxí díhúⁿ cuìxíⁿ, te dɨu‑ni ducaⁿ nǐ sáñaha‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Te ndéé òré ní queheⁿ cuèndá té Jùdás‑áⁿ dǐhúⁿ, te ní ngüíta‑dé ndúcú‑dě nàcuáa cada‑dé cuáha cuèndá‑dé Jèsús núú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Te ní sáá nduu nǐ quesaha vìco xexi ñáyiu pàá sá ñà túú yɨ̀hɨ levadurá dɨu‑ni vico pàscuá, te cue tée xìca cuu ndɨhɨ Jesús ní sándehe yatni‑güedé dɨ̀ñɨ‑gá, te xǎhaⁿ‑güedě xii‑gá: —Mèstrú, véxi‑ndɨ́ xìcáⁿ tnúhú‑ndɨ̌ núú‑n nǔu ndèé cuìní‑n càda túha‑ndɨ́ cuèndá cudìni‑o sacuaa nduu vico pascuá —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí cuàháⁿ xɨtɨ́ ñuú‑ǎⁿ, te yàcáⁿ naníhí‑ndó ɨ̀ɨⁿ tée cùtnuní iní‑ndó sǎ sà xiní ñáhá‑dě xii‑o, te cúñaha‑ndo xìi‑dé: “Yaá cúú Mèstrú càchí‑gá sá sà ní cuyatni nduu vǎ cúndècu‑gá ñuyíú‑a, te vehe‑n cuìní‑gá cada‑gá vico pàscuá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá”, duha cúñaha‑ndo xìi tée‑áⁿ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Te cue tée xìca cuu ndɨhɨ‑gá‑áⁿ nǐ xica‑güedé cuáháⁿ‑güedé, te ní quide‑güedé nàcuáa ní xáhaⁿ‑gǎ xii‑güedé, te ní quide túha‑güedé sá cúdìni‑güedé ndɨhɨ‑gá sacuaa nduu vìco pascuá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Te òré sa ní cundɨquɨⁿ te cuánguɨhu Jèsús ndɨhɨ ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá mèsá cuèndá cudìni‑gá ndɨhɨ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Te nɨni xèxi‑gá ndɨhɨ‑güedé ní xáhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ dɨ́ú ɨ̀ɨⁿ nchohó cue tée xìca cuu ndɨhɨ‑í cuáha cuèndá ñáhá‑ndó xìi‑í núú cuè tée cùu úhú iní ñáhá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Te sá dúcáⁿ nǐ xáhaⁿ‑gǎ xii‑güedé te nchaa‑güedé ní ngüíta‑güedé cúndɨ̀yɨ́‑güedé, te da ɨɨⁿ da ɨɨⁿ‑güedé ní ngüíta‑güedé xǎhaⁿ‑güedě xii‑gá: —Mèstrú, ¿ñá dɨ́ú yǔhú ducaⁿ sàni iní‑n càda‑í‑u? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Te ní xáhaⁿ‑gǎ xii‑güedé: —Tée nacaxi ndɨhɨ‑í ɨɨⁿ‑ni cóhó caxi‑ndɨ́, tée‑áⁿ cuǎha cuèndá ñáhá‑dě xii‑í núú cuè tée cùu úhú iní ñáhá. ");
INSERT INTO milNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Te yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ñuhu ichi‑í cuáháⁿ‑í yáha‑í nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí, dico ndàhú ní cuu tée ducaⁿ na cuǎha cuèndá ñáhá xìi‑í núú cuè tée cùu úhú iní ñáhá, chi váha‑gá sá vǎ cácú těe‑áⁿ cundecu‑dé ní cùu, te ñá dɨ́ú sǎ nǐ cacu‑dé te ducaⁿ càda‑dé —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Te sátá dúcáⁿ te ní cáháⁿ té Jùdás tée cuáha cuèndá ñáhá xìi‑gá, te xǎhaⁿ‑dě: —Mèstrú, ¿te náa sàni iní‑n sǎ yǔhú cuáha cuèndá ñáhà‑í xii‑n nǔú cuè tée cùu úhú iní ñáhá xìi‑n‑áⁿ? —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Dɨu‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Te nɨni cùdini cue tée xìca cuu ndɨhɨ Jesús ní queheⁿ‑gá pàá, te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí, te dǎtnùní ní táhú cuèchi‑gá te ní ngüíta‑gá dácǎhñu‑gá cue tée xìca cuu ndɨhɨ‑gá‑áⁿ, te xǎhaⁿ‑gǎ xii‑güedé: —Chí quéhéⁿ pàá‑a caxi‑ndo, te cada iní‑ndó sǎ yɨ̀quɨ cuñú‑í cúú‑xí —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Te ní queheⁿ‑gá vàsú ñúhú ndùdí ndéhé yoho yàha stilé, te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí, te dǎtnùní ní ngüíta‑gá sǎñaha‑gǎ xii‑güedé cuèndá coho‑güedé luha luha sá ñúhú xɨ̀tɨ́‑xi, te xǎhaⁿ‑gǎ xii‑güedé: —Chí cóhó nchàa nchohó ndudí ndéhé yoho yàha stilé ñúhú xɨ̀tɨ́ vàsú‑a. ");
INSERT INTO milNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Te cada iní‑ndó sǎ cúú‑xí dàtná nɨ́ñɨ̀‑í sá cátɨ́ òré cahni ñaha‑güedě xii‑í, te sá dúcáⁿ càtɨ nɨ́ñɨ̀‑í xíǎⁿ cutnùní ndáá sá Yǎ Ndiǒxí cada‑gá ɨngá núú sǎ vǎha sá cúú‑xí vài ñáyiu dàtná ní cachí‑gá cada‑gá, te ío vài ñáyiu cada càhnu iní‑gá cuéchi‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Te na càchí tnúhu‑í xii‑ndo sǎ vítná‑nǎ duha xìhi ndɨhɨ ñaha‑í xii‑ndo ndùdí ndéhé yoho yàha stilé‑a, te vá cóhó ndɨ̀hɨ ñaha‑gá‑í xii‑ndo, dico na sàá nduu nànihí tnáhá‑ó nǔú ndécú Tǎtà‑í Dútú Ndiǒxí táxí tnùní‑gá te dàvá‑áⁿ cada iní‑ndó sǎ dàtná sá cóhó ndɨ̀hɨ ñaha tucu‑í xii‑ndo chi ío cudɨ́ɨ́ ìní‑ó —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Te Jèsús ní xita‑gá ɨɨⁿ ndudú ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te dǎtnùní ní xica‑gá cuáháⁿ‑gá ndɨhɨ‑güedé yucu Òlívú. ");
INSERT INTO milNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Te yàcáⁿ ní xáhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu‑í xii‑ndo sǎ ncháá‑ndó dàndóo ñaha‑ndo xìi‑í niú vitna, chi quee ndáá‑xi nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí núú càchí‑xi: “Yúhú cuáha‑í tnúhu cahni‑güedé tée cùu toli, te nchaa mběé‑dě ndɨhɨ‑güedɨ cuténuu”, duha càchí‑xi núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Dico na ndòto‑í te codonùu‑í núú‑ndó quɨ̌hɨ́ⁿ distrìtú Galìleá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Te té Pèlú ní xáhaⁿ‑dě xii‑gá: —Te cuěi nchaa‑güedé ná dàndóo ñaha‑güedě xii‑n, dico yúhú chi vá dándǒo ñaha‑ǐ xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Na càchí tnúhu ndáá‑í xii‑n sǎ nìú vitna cùmání‑gǎ cana ɨɨⁿ lǐhi, te úní xito cáháⁿ‑n nǔú ñǎyiu sá ñà túú xìní ñáhá‑n xìi‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Te té Pèlú ní xáhaⁿ‑dě xii‑gá: —Cuěi na cùú ndɨhɨ ñaha‑ǐ xii‑n dico vá càháⁿ‑í núú ñǎyiu sá ñà túú xìní ñáhà‑í xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te nchaa dava‑gá cue tée xìca cuu ndɨhɨ‑gá dɨu‑ni ducaⁿ nǐ xáhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Te Jèsús ní quexìo‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ɨɨⁿ xichi núú nání Gètsemaní, te xíáⁿ nǐ xáhaⁿ‑gǎ xii‑güedé: —Chí cúnúcǒo iha cundetu‑ndo na quɨ̀hɨ́ⁿ‑í yàcáⁿ cáháⁿ ndɨhɨ‑í Yǎ Ndiǒxí —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Te ndèca‑gá té Pèlú, ndɨhɨ ndɨ ndùú déhe té Zebèdeú cuáháⁿ, te ní ngüíta‑xi súúní ndɨ̀hú iní‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Te ní xáhaⁿ‑gǎ xii cue tée úní‑áⁿ: —Súúní ndɨ̀hú iní‑í dàtná sá cùú‑í, te chí quéndǒo nchòhó iha te vá cùdú‑ndó chi yúhú vá cùdú‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Te sa ñùnchií luha ní xica ndehe Jèsús núú ndécú‑güedě, te ní ngüɨ́ñɨ́ xɨ́tɨ́‑gǎ te ní nuu núú‑gǎ ndàa núú ñúhú, te ní ngüíta‑gá càháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te xǎhaⁿ‑gǎ: —Yòhó Tǎtá méè‑í, càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n tàunihnu ñaha‑n xii‑í cuèndá sá vǎ ndóhò‑í ná sàá òré, dico vá cádá‑n nàcuáa càchí iní méè‑í, chi cada‑n nàcuáa càchí iní méé‑n —càchí‑gá xǎhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Te sátá nǐ yáha ní cáháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te cuánuhú‑gá núú nǐ dándǒo‑gá cue tée úní‑áⁿ te xǐxídí‑güedé òré ní nasáá‑gá, te ní xáhaⁿ‑gǎ xii té Pèlú: —¿Náa ñá cúndèe iní‑ndó vǎ cùdú‑ni‑ndo cuědìcó ɨɨⁿ òré nɨni càháⁿ ndɨhɨ‑í Yǎ Ndiǒxí‑ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Te chí quéndǒo tucu te cuhuⁿ iní‑ndó vǎ cùdú‑ndó, te cáháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí cuèndá sá vǎ dácàháⁿ ñáhá yùcu ñávǎha xii‑ndo càda‑ndo sá ñà túú tàú‑ndó càda‑ndo. Te xìní ndáá‑í sá nchòhó cuìní‑ndó càda‑ndo nchaa nacuáa càháⁿ‑í dìcó‑ni sá ñà túú nìhí ndéé‑ndó —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Te xito cùu uú cuáháⁿ tucu Jèsús cáháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te xǎhaⁿ‑gǎ: —Yòhó Tǎtá méè‑í, te núu vá cúndèe iní‑n tàunihnu ñaha‑n xii‑í cuèndá sá vǎ ndóhò‑í, te cada nàcuáa càchí iní méé‑n —càchí‑gá xǎhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Te òré ní yáha ní cáháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te cuánuhú tucu‑gá núú xǐndecu cue tée úní xícá cùu ndɨhɨ‑gá‑áⁿ, te xìdí‑ni tucu‑güedé òré ní nasáá‑gá, te ducaⁿ nǐ quide‑güedé chi súúní ñùhu saní núú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Te ní dándǒo ñaha tùcu Jesús xii‑güedé xíáⁿ, te cuáháⁿ tucu‑gá xito cùu uní cáháⁿ ndɨhɨ tucu‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te dɨu‑ni tnúhu sá sà ní xáhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí, dɨu‑ni tnúhu‑áⁿ nǐ xáhaⁿ tùcu‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Te sátá nǐ yáha ní cáháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te cuánuhú tucu‑gá núú ndécú cuè tée xìca cuu ndɨhɨ‑gá‑áⁿ, te òré ní nasáá‑gá, te ní xáhaⁿ‑gǎ xii‑güedé: —¿Te náa xìdí‑ni tucu‑ndo? Te sa ní sáá òré cuáha cuèndá ñáhá‑güedě xii‑í núú cuè tée ndècu ichi cuehé ichi duha. ");
INSERT INTO milNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Dico vitna chí ndácǒo na quɨ̀hɨ́ⁿ‑ó, chi sa véxi tée cuáha cuèndá ñáhá xìi‑í núú cuè tée cùu úhú iní ñáhá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Te càháⁿ dúcáⁿ‑ní Jèsús ní quexìo té Jùdás. Te núú tnàhá tée‑áⁿ cúú ùxúú tnàhá cue tée xìca cuu ndɨhɨ‑gá ní cùu te ducaⁿ nǐ quide‑dé. Te ndɨhɨ‑dé vài cue tée ní quexìo te dava‑güedé xǐnehe‑güedé machìtí, te dava‑güedé xǐnehe‑güedé carrùtí. Te cue tée‑áⁿ nǐ tendaha ñàha cue dútú cúnùu, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél. ");
INSERT INTO milNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Te té Jùdás tée cuáha cuèndá ñáhá xìi‑gá‑áⁿ sa ní xítnǔhu‑dé cue tée‑áⁿ nàcuáa cada‑dé cuáha cuèndá‑dé Jèsús núú‑güedě, te duha ní xáhaⁿ‑dě xii‑güedé: —Cundehe‑ndo těe na tèyuhu‑í te tée‑áⁿ tnɨɨ‑ndo‑dě chi tée‑áⁿ cúú‑dě tée ndèé iní‑ndó —duha ní xáhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Te sátá dúcáⁿ nǐ xáhaⁿ‑dě xii‑güedé, te ní sándehe yatni‑dé núú Jèsús, te ní xáhaⁿ‑dě xii‑gá: —¡Ràcióⁿ Mèstrú! —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te ní teyuhu ñàha‑dé xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Yòhó tée ní chitnahá ñáhá xìi‑í, ¿ná cuìní‑n nǔu véxi‑n nǔù‑í? —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te òré‑ni‑áⁿ nǐ tnɨɨ ñaha cuè tée ndɨhɨ té Jùdás‑áⁿ xii Jèsús, te ndèca ñaha‑güedé xii‑gá cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Te ɨɨⁿ cue tée ndɨhɨ Jèsús ní tava‑dé machìtí‑dé, te ní xehndé‑ni‑dé ɨɨⁿ xio lóho ɨɨⁿ tée xìnu cuechi núú dǔtú cúnùu te ní quendeé duuⁿ lóho‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Te Jèsús ní xáhaⁿ‑gǎ xii tée ducaⁿ nǐ xehndé lóho tée‑áⁿ: —Nachihi machìtí‑n ñɨ̀ɨ‑xi, chi nchaa cue tée na nàá ndɨhɨ machìtí cahni‑güedé tnàha ñáyiu‑güedé te dɨu‑ni ndɨhɨ machìtí cuú méé‑güedě tucu. ");
INSERT INTO milNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Te na càchí tnúhu‑í xii‑ndo sǎ nǔu yúhú cuìní‑í cácu‑í te cáháⁿ ndɨhɨ‑í Tǎtà‑í Dútú Ndiǒxí, te tendaha‑gǎ cuéhé víhí espíritú xínú cuèchi núú‑gǎ quixi‑xi dàcácu ñaha‑xi xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Dico núu ducaⁿ na càda‑í te vá quéé ndǎá‑xi nàcuáa càháⁿ‑xi núú tùtú Tǎtà‑í Dútú Ndiǒxí núú ndèé tnuní sá dàcuɨtɨ́í xìni ñuhu‑xi nándɨ ndoho‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Te Jèsús ní xáhaⁿ‑gǎ xii cue tée ducaⁿ nǐ tnɨɨ ñaha xìi‑gá‑áⁿ: —Nchaa‑ni nduu ní xiní‑ndó nǐ xóo cunucóo‑í xɨtɨ́ veñúhu càhnu sá ǐo cùnuu ní xóo danèhé‑í ñáyiu, te ñá túú ní tnɨ̀ɨ ñaha‑ndo xii‑í, ¿te ná cuèndá vitna quìde ñaha‑ná‑ndó xìi‑í dàtná quídé‑ndó ɨ̀ɨⁿ ñadúhú, nèhe‑ná‑ndó màchití nèhe‑ná‑ndó càrrutí ní quexìo ní tnɨɨ ñaha‑ndo xìi‑í‑i? ");
INSERT INTO milNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dico dacuɨtɨ́í sǎ dúhá càda‑xi nacuáa quee ndáá‑xi nàcuáa ní cáháⁿ cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǐ ngódó tnùní núú tùtú‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te nchaa cue tée xìca cuu ndɨhɨ‑gá ní xinu‑güedé ní dándǒo ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Te cue tée ní tnɨɨ ñaha xìi Jesús ndécá ñàha‑güedé xii‑gá cuáháⁿ núú tě Caìfás tée cùu dútú cúnùu‑gá. Te núú ndécú dǔtú cúnùu‑gá‑áⁿ sa ní tacá cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél cuèndá cada‑güedé jùndá. ");
INSERT INTO milNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Te té Pèlú xica xìca‑ni nchicúⁿ ñáhá‑dě xii‑gá cuáháⁿ ní sáá‑dé ndéé quehé vehe núú ndécú těe cùu dútú cúnùu‑gá‑áⁿ, te xíáⁿ nǐ ngóo‑dé ndɨhɨ cue tée cùu poleciá cuèndá cuìní‑dé quiní‑dé nása cada ñaha‑güedě xii Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Te cue tée cùu dútú cúnùu, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél, ndɨhɨ nchaa dava‑gá cue tée xǐndecu jùndá ndúcú‑güedě nàcuáa cada‑güedé dacàa‑güedé ɨɨⁿ cuéchi dɨ́quɨ́ Jèsús cuěi cùu‑xi ɨɨⁿ sá ñǎ ndàá cuèndá níhí‑güedě nàcuáa cada‑güedé cahni ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Te vài cue tée ní ngüíta‑güedé dácàa‑güedé cuéchi dɨ́quɨ́‑gǎ, dico ñá túú ní cùndee tnúhu‑güedé chi mee‑ni tnǔhu ndehnde cùu‑xi. Te sátá dúcáⁿ te ní quexìo tucu úú tnàhá cue tée dàcuandehnde‑güedé, ");
INSERT INTO milNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","te xǎhaⁿ‑güedě xii nchaa cue tée xǐndecu jùndá: —Véxi‑ndɨ́ càchí tnúhu‑ndɨ́ xii‑ndo sǎ těe‑a càchí‑dé sá dángòyo‑dé veñúhu càhnu sá ǐo cùnuu núú chíñùhu‑o Yá Ndiǒxí, te dandàa‑dé ɨngá veñúhu saa, dɨu‑ni núú cáá tnàhí veñúhu‑ǎⁿ, te xɨtɨ́ úní‑ni nduu sa nadaxǐnu‑dé, duha càchí‑dé —càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Te tée cùu dútú cúnùu‑gá‑áⁿ nǐ ndacuɨ́ñɨ́‑dé, te xǎhaⁿ‑dě xii Jèsús: —¿Ná cuèndá duha ndùu tnúhu càháⁿ cue tée‑a cuèndá‑n? Te cáháⁿ nǔu nása cunduu tnúhu cáháⁿ‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Dico Jèsús ñá túú tnàhí ni cǎháⁿ‑gá. Te tée cùu dútú cúnùu‑gá‑áⁿ nǐ xáhaⁿ tùcu‑dé xii‑gá: —Yúhú, cácú nèhe‑í Yǎ Ndiǒxí chi cuìní‑í sá càchí tnúhu ndáá‑n xìi‑ndɨ́ nǔu sá dɨ́ú Crìstú Déhe Yá Ndiǒxí Yaá ní tendaha‑gǎ véxi ñuyíú‑a cùu‑n —cachí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Dɨu Yaá‑áⁿ cúù‑í dàtná càchí‑n‑ǎⁿ, te na càchí tnúhu‑í xii‑ndo sǎ sàá nduu te quiní‑ndó yǔhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo cunucóo‑í xio cùha Dútú Ndiǒxí Yaá ndácú quìde nchaandɨ túhú sá vǎha. Te dàvá‑áⁿ quiní ñáhá‑ndó xìi‑í quee‑í andɨu quìxi‑í ichi xɨtɨ́ vícó —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Te dútú cúnùu‑gá‑áⁿ nǐ ndátá‑dě dóó níhnú‑dě cuèndá sá ñà túú ní tnàhá iní‑dé nàcuáa ní cáháⁿ Jèsús, te ní xáhaⁿ‑dě xii nchaa cue tée xǐndecu jùndá: —Tée‑a càháⁿ úhú‑dé cuèndá Yǎ Ndiǒxí, te vitna ñá túú‑gǎ xíní ñùhu‑xi cue tée cáháⁿ ndáá nǔu ndáá sá ndècuéchi‑dé àdi ñá túú ndècuéchi‑dé, chi sa ní tecú dóho‑o nàcuáa ndùu tnúhu ní cáháⁿ‑dé ní cáháⁿ úhú‑dé cuèndá Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Te nchaa‑ndo chǐ càháⁿ vitna núu nása sàni iní‑ndó cùnduu cuendá tée‑a —càchí‑dé xǎhaⁿ‑dě xii nchaa cue tée‑áⁿ. Te cue tée‑áⁿ nǐ xáhaⁿ‑güedě: —Nchúhú càchí‑ndɨ́ sá tàú‑xi cuú‑dé chi ndècuéchi‑dé —càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Te ní ngüíta‑güedé ní tɨú dɨɨ́ ñáhá‑güedě xii‑gá te ní caniha‑güedě, te tnàhá núú‑gǎ ní cani‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Te ní cudɨ́quɨ́ ndeé ñáhá‑güedě xii‑gá, te xǎhaⁿ‑güedě: —Yòhó Tée càchí sá cúú Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a, cáháⁿ ná còto yoo ní caniha xìi‑n —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Te nɨni nùcóo té Pèlú quehé, te ní sáháⁿ ɨɨⁿ xíchí xínú cuèchi vehe‑áⁿ nǔú‑dě, te xǎhaⁿ‑xi xìi‑dé: —Yòhó tnàhá‑n cùu‑n tée xìca cuu ndɨhɨ Jesús tée distrìtú Galìleá —càchí‑xi xǎhaⁿ‑xi xìi‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Te té Pèlú ñá túú ní nǔnuu‑dé, te ndèdóho nchaa ñáyiu xǐndecu‑áⁿ nǐ xáhaⁿ‑dě xii xíchí‑ǎⁿ: —Yúhú, ñá túú cùtnuní iní‑í nása ndùu tnúhu càháⁿ‑n —càchí‑dé xǎhaⁿ‑dě xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Te ní xica té Pèlú cuáháⁿ‑dé ndàa nacuáa nchìí yuyèhe vehe‑áⁿ, te ní xiní ñáhá tùcu ɨngá xíchí xínú cuèchi vehe‑áⁿ, te xǎhaⁿ‑xi xìi nchaa ñáyiu xǐndecu‑áⁿ: —Tée‑a tnàhá‑dé xícá cùu‑dé ndɨhɨ Jèsús tée ñuú Nazàrét —càchí‑xi xǎhaⁿ‑xi xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Te té Pèlú ní xáhaⁿ‑dě: —Nchàcuɨtɨ Yá Ndiǒxí sá ñà túú xìní‑í tée càcunehe‑ndo‑áⁿ —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Te tna tnaa‑ni ní cuu, te dava ñáyiu xǐndecu xíáⁿ nǐ xáhaⁿ tùcú‑yu xii té Pèlú: —Ndáá sá tnàhá‑n xìca cuu‑n ndɨhɨ tée ndèca‑güedé cuánguɨhu‑ǎⁿ, chi ñáyúhú càháⁿ‑n —càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Te té Pèlú ní xáhaⁿ‑dě xií‑yu: —Nchàcuɨtɨ Yá Ndiǒxí sá yǔhú càháⁿ ndáá‑í sá ñà túú xìní‑í tée càcunehe‑ndo‑áⁿ —càchí‑dé xǎhaⁿ‑dě xií‑yu. Te òré‑ni‑áⁿ nǐ cana ɨɨⁿ lǐhi. ");
INSERT INTO milNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Te ní ndacu iní té Pèlú nàcuáa ní xáhaⁿ Jèsús xii‑dé sá cùmání‑gǎ cana ɨɨⁿ lǐhi te úní xito cáháⁿ‑dé sá ñà túú xìní ñáhá‑dě xii‑gá. Te ní quee‑dé tnuú ñáyiu‑áⁿ cuǎháⁿ‑dé ɨɨⁿ xio ní ndáhyú víhí‑dě ní ndixi cuéchi iní‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Te sátá nǐ túndaá te nchaa cue tée cùu dútú cúnùu, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél ní ndatnúhu‑güedé nàcuáa cada‑güedé cahni‑güedé Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Te ní dácútú ñàha‑güedé xii‑gá, te ndèca ñaha‑güedé cuáháⁿ núú tě Pìlatú tée cùu gobiernú. ");
INSERT INTO milNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Te té Jùdás tée ní sáha cuèndá ñáhá xìi Jesús ní cutnùní iní‑dé sá cáhní ñàha‑güedé xii‑gá, te ní ndixi cuéchi iní‑dé sá ñà túú ní quìde váha‑dé sá dúcáⁿ nǐ quide‑dé ní sáha cuèndá ñáhá‑dě xii‑gá núú cuè tée cùu úhú iní ñáhá, te ní xica‑dé cuáháⁿ‑dé danchòcáva‑dé ócó úxí díhúⁿ cuìxíⁿ núú cuè dútú cúnùu‑áⁿ, ndɨhɨ núú cuè tée cùu sacuéhé nǔú ñǎyiu isràél, chi dɨu cue tée‑áⁿ nǐ sáñaha‑güedě díhúⁿ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Te òré ní quexìo té Jùdás‑áⁿ nǔú ndécú‑güedě, te xǎhaⁿ‑dě xii‑güedé: —Yúhú, ñá túú ní quìde váha‑í sá dúcáⁿ nǐ quide‑í ní taxi cuèndá‑í ɨɨⁿ tée ñá túú tnàhí cuéchi‑xi cahni‑ndo‑dě —càchí‑dé xǎhaⁿ‑dě xii‑güedé. Te cue tée‑áⁿ nǐ xáhaⁿ‑güedě xii‑dé: —Nchúhú, ñá túú nǎgá cuèndú cuìní‑ndɨ́ cáháⁿ ndɨhɨ ñaha‑ndɨ̌ xii‑n, te mee‑n nàha núu nása sàni iní‑n càda‑n —cachí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Te té Jùdás ní dǎngoyo‑dé díhúⁿ‑ǎⁿ xɨtɨ́ veñúhu càhnu sá ǐo cùnuu, te ní xica‑dé cuáháⁿ‑dé ní dácuèhné‑dé méé‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Te cue dútú cúnùu ní naqueheⁿ‑güedé díhúⁿ‑ǎⁿ, te ní xítnàha‑güedé: —Díhúⁿ‑a ní quéyǎhu cuèndá sá cùú ɨɨⁿ ñáyiu, núu xíǎⁿ vá cúú nàchihi‑o xɨtɨ́ càjá núú ñúhú sǎ cúú cuèndá Yǎ Ndiǒxí —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Te ní ndatnúhu‑güedé te ní cuu ɨɨⁿnuu‑güedě cuèndá nacuaaⁿ‑güedé ɨɨⁿ xichi núú cáá ñùhu danani‑güedé Núú Cuǎha Nchaa Sá Cuǎha Ñuhu, te xíáⁿ nǐ saaⁿ‑güedé cuèndá xíáⁿ nguɨ̌ndǔxi nchaa ñáyiu véxi xica. ");
INSERT INTO milNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Te ní nadáma dɨ̀u ñuhu‑áⁿ, te vitna dànani‑güedé Ñuhu Yáhu Nɨ́ñɨ́, duha dànani‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa ní cáháⁿ ndíi Jerèmiás tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, te duha ní cachí ndíi: “Cue tée isràél ní cachí‑güedé sá òcó úxí díhúⁿ cuìxíⁿ cháhu‑güedé cuèndá ɨɨⁿ tée queheⁿ cuèndá‑güedé. Te díhúⁿ‑ǎⁿ nàqueheⁿ‑güedé, ");
INSERT INTO milNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","te cuaaⁿ‑güedé ɨɨⁿ xichi núú nání Nǔú Cuǎha Nchaa Sá Cuǎha Ñuhu, te ducaⁿ càda‑xi chi ducaⁿ nǐ cachí Yǎ Ndiǒxí cunduu”, duha ní cachí ndíi Jerèmiás‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Te Jèsús ndécú‑gǎ núú tě Pìlatú tée cùu gobiernú, te tée‑áⁿ nǐ xícáⁿ tnúhú‑dě núú‑gǎ, te xǎhaⁿ‑dě xii‑gá: —¿Ndáá sá dɨ́ú‑n cùu‑n tée yɨ̀ndaha ñaha xii ñáyiu isràél‑ǎⁿ? —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Dɨu‑í yɨ́ndàha‑í‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Te cue dútú cúnùu ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél sàcáⁿ cuéchi‑güedé núú tě Pìlatú cuèndá Jèsús, dico mee‑gǎ ni ɨ̀ɨⁿ tnúhu ñá túú ní cǎháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Te té Pìlatú ní xáhaⁿ‑dě xii‑gá: —Cáháⁿ, ná cuèndá ñá túú càháⁿ‑n, te cundehe nǎ ndéé duha tɨtnɨ́ cuéchi dàcaa cue tée‑a dɨ́quɨ́‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Dico Jèsús ñá túú tnàhí ni cǎháⁿ‑gá, te té Pìlatú tée cùu gobiernú‑áⁿ ǐo ní cuñúhu‑dé sá dúcáⁿ ñà túú tnàhí ni cǎháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Te ndɨ tnahá nduu vìco pascuá dácǎcu té Pìlatú tée cùu gobiernú‑áⁿ ɨɨⁿ tée yɨ̀hɨ vecaá chi ducaⁿ tnàhí quìde‑dé, te mee ñǎyiu càháⁿ‑yu te núu ndědacàa tée yɨ̀hɨ vecaá‑áⁿ cǎcu‑dé te tée‑áⁿ dácǎcu‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Te dàvá‑áⁿ yɨ́hɨ́ ɨ̀ɨⁿ tée nàni Barrabás vecaá, te tée‑áⁿ ìó cuèndú‑dé sá ǐo nèhé ní quide‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Te ní natacá nchaa ñáyiu, te té Pìlatú ní xícáⁿ tnúhú‑dě núǔ‑yu, te xǎhaⁿ‑dě: —¿Ndědacàa núú ùú cue tée‑a cuìní‑ndó dàcácu‑í‑güedé‑i? ¿Té Barràbás ǎⁿ Jèsús tée nàni Cristú? —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Te ducaⁿ nǐ cáháⁿ té Pìlatú, chi ní cutnùní iní‑dé sá dìcó sá cuèdú íní‑güedě ducaⁿ nǐ quide‑güedé ní sáha cuèndá ñáhá‑güedě xii Jèsús núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Te nɨni nùcóo té Pìlatú núú xèhndé‑dé cuéchi ní tendaha ñàdɨhɨ́‑dé tnúhu cuáháⁿ núú‑dě, te duha ndùu tnúhu ní tendaha‑aⁿ: “Vá cání ìní‑n nǎ cada‑n těe ní taxi cuèndá ñáhá‑güedě xii‑n, tée ñá túú tnàhí cuéchi‑xi, chi icuini ío nèhé ní dácótó ñàha saní‑í cuèndá‑dé”, duha ndùu tnúhu ní xáhaⁿ‑aⁿ xìi té Pìlatú. ");
INSERT INTO milNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Dico cue tée cùu dútú cúnùu, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél ní xáhaⁿ‑güedě xii ñáyiu sá ná cǔñàhá‑yu xii té Pìlatú dàcácu‑dé té Barràbás te cahni‑dé Jèsús, te ní quidé‑yu nàcuáa ní xáhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Te té Pìlatú‑áⁿ nǐ xáhaⁿ tùcu‑dé xií‑yu: —¿Ndědacàa núú ùú cue tée‑a cuìní‑ndó dàcácu‑í? —càchí‑dé xǎhaⁿ‑dě xií‑yu. Te ní xáhǎⁿ‑yu xii‑dé: —Té Barràbás dàcácu‑n —càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Te té Pìlatú ní xícáⁿ tnúhú‑dě núǔ‑yu, te xǎhaⁿ‑dě: —¿Te ná cuìní‑ndó càda‑í Jèsús tée nàni Cristú tée càchí sá Yǎ Ndiǒxí ní tendaha ñàha xii‑dé véxi‑dé ñuyíú‑a‑i? —càchí‑dé xǎhaⁿ‑dě xií‑yu. Te nchaá‑yu ní cáháⁿ‑yu, te xǎhǎⁿ‑yu: —Cata caa‑dé núú cùrúxí —càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Te té Pìlatú ní xáhaⁿ tùcu‑dé xií‑yu: —¿Te ná cúú cuěchi ní quide‑dé nǔu ducaⁿ cuìní‑ndó càda‑í‑dé‑i? —càchí‑dé xǎhaⁿ‑dě xií‑yu. Dico nchaá‑yu uuⁿ‑gá níhi ní cáháⁿ‑yu, te xǎhǎⁿ‑yu xii‑dé: —¡Cata caa‑dé núú cùrúxí! —càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Te té Pìlatú ní cutnùní iní‑dé sá vǎ nìhí‑dé nàcuáa cada‑dé, chi uuⁿ‑gá ní ngüíta ñáyiu xǐcuáá‑yu, te xíǎⁿ ní xícáⁿ‑dé ndute ní ndáhá‑dě núú nchàa ñáyiu, te ní xáhaⁿ‑dě xií‑yu: —Tée‑a cùu‑dé ɨɨⁿ tée ñá túú tnàhí cuéchi‑xi, te nchòhó cuìní‑ndó sǎ cùú‑dé, dico dɨu‑ni mee‑ndo cuìdo yáhu‑ndo‑dě chi yúhú vá cuídó yǎhu‑í‑dé —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Te nchaá‑yu ní xáhǎⁿ‑yu xii‑dé: —¡Dɨu nchúhú ndɨhɨ cue déhe‑ndɨ́ cuido yǎhu‑ndɨ́‑dé! —càchí‑yu xǎhǎⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Te sátá dúcáⁿ te té Pìlatú ní dácǎcu‑dé té Barràbás, te ní táúchíúⁿ‑dě ní cani‑güedé Jèsús. Te sátá dúcáⁿ nǐ quide ñaha‑güedě xii‑gá, te ní táúchíúⁿ‑dě candeca ñaha‑güedě xii‑gá quɨ́hɨ́ⁿ cata caa ñaha‑güedě xii‑gá núú cùrúxí. ");
INSERT INTO milNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Te cue tée cùu sandadú té Pìlatú ndécá‑güedě Jèsús cuánguɨhu xɨtɨ́ vehe càhnu cuu cuendá‑dé, te cue tée cùu sandadú‑áⁿ nǐ cana‑güedé dava‑gá cue sandàdú núú dúcáⁿ ndèca‑güedé Jèsús cuánguɨhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Te xíáⁿ nǐ taunuu‑güedé dóó‑gǎ, te ní dácuíhnú ñàha‑güedé xii‑gá ɨɨⁿ dóó tɨ́cuèhé víhí. ");
INSERT INTO milNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Te ní cadúha‑güedé ɨɨⁿ coròná iñu ní chihi‑güedé dɨ́quɨ́‑gǎ, te ní chitnɨ́ɨ‑güedé ɨɨⁿ carrùtí ndaha cùha‑gá, te ní ngüɨ́ñɨ́ xɨ́tɨ́‑güedě núú‑gǎ cúdɨ̀quɨ́ ndeé ñáhá‑güedě xii‑gá, te xǎhaⁿ‑güedě: —¡Ío càhnu cuu yohó tée yɨ̀ndaha ñaha xii ñáyiu isràél! —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Te ní tɨú dɨɨ́ ñáhá‑güedě xii‑gá, te ní queheⁿ‑güedé carrùtí sá nǐ sáñaha‑güedě xii‑gá te ní ducuⁿ‑güedé dɨ́quɨ́‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Te sátá nǐ yáha ní cudɨ́quɨ́ ndeé ñáhá‑güedě xii‑gá, te ní nataunuu ñaha‑güedě xii‑gá dóó tɨ́cuèhé víhí sǎ nǐ dácuíhnú ñàha‑güedé xii‑gá, te ní dándɨ̌únuu ñaha‑güedě xii‑gá dóó méé‑gǎ, te dǎtnùní ndécá ñàha‑güedé cuáháⁿ núú cátá càa ñaha‑güedé xii‑gá núú cùrúxí. ");
INSERT INTO milNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Te ñùhu‑güedé ndɨhɨ‑gá ichi, te ní naníhí‑güedě ɨɨⁿ tée ñuú Cìrené nání‑dě Xǐmú, te tée‑áⁿ nǐ quide yica‑güedě ní xido‑dé cùrúxí sá nchídó Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Te ní sáá‑güedé ndɨhɨ‑gá ɨɨⁿ xichi núú nání Gǒlgotá, te tnúhu‑áⁿ quéé‑xí: Núú nání yɨ̀quɨ dɨ́quɨ́ ndɨ̌yɨ, duha quèe‑xi tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Te xíáⁿ sǎñaha‑güedě ndudí úá coho‑gá ní cùu, te ñá túú ní xìhi‑gá chi dico‑ni ní xito ndéé‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Te ní sata caa ñaha‑güedě xii‑gá núú cùrúxí, te sátá dúcáⁿ te cue tée cùu sandadú‑áⁿ nǐ xito ndéé‑güedé nǔu ndědacàa‑güedé cuu cuèndá‑güedé dóó‑gǎ. Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa ní cáháⁿ ɨɨⁿ tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha yòdo tnuní núú tùtú‑gá, te duha càchí‑xi: “Ní xito ndéé‑güedé nǔu ndědacàa‑güedé cuu cuèndá‑güedé dóó‑gǎ”, duha ní cachí tée‑áⁿ te ducaⁿ nǐ ngódó tnùní núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Te sátá dúcáⁿ nǐ quide‑güedé, te ní ngóo‑güedé ndèé ñáhá‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Te ní taxi ndecu‑güedé ɨɨⁿ sá ndèé lètrá ndàa dɨ́quɨ́‑gǎ. Te lètrá‑áⁿ càháⁿ‑xi ná cuèndá ducaⁿ nǐ quide ñaha‑güedě xii‑gá, te duha càháⁿ lètrá‑áⁿ: “Tée‑a cùu‑dé tée yɨ̀ndaha ñaha xii ñáyiu isràél”, duha càchí‑xi. ");
INSERT INTO milNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Te tnàhá úú cue tée cùu ñadúhú nǐ sata caa‑güedé dɨu‑ni núú cùrúxí tucu, te ɨɨⁿ‑dé ní sata caa‑güedé xio cùha‑gá, te ɨngá‑dé ní sata caa‑güedé xio dàtni‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Te nchaa ñáyiu yǎha yatni núú tácàa‑gá‑áⁿ, te dàcuicó‑yu dɨ́quɨ̌‑yu ndèhe ñahá‑yu xii‑gá, te xǐcuèhé ñáhǎ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Te xǎhǎⁿ‑yu xii‑gá: —Yòhó càchí‑n sǎ dàngoyo‑n veñúhu càhnu sá ǐo cùnuu, te dandàa‑n ɨngá veñúhu saa, te xɨtɨ́ úní‑ni nduu sa nadaxǐnu‑n, te vitna tanùu núú cùrúxí‑áⁿ dàcácu‑n mèe‑n te núu ndisa sá Děhe Yá Ndiǒxí cúú‑n —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Te dɨu‑ni ducaⁿ cùdɨquɨ́ ndeé ñáhá cuè tée cùu dútú cúnùu xii‑gá, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùu fariséú, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél, te xǐtnàha‑güedé: ");
INSERT INTO milNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Tée‑a ní ndacu‑dé ní dácǎcu‑dé dava ñáyiu, te mee‑dě ñá ndácú‑dě dàcácu nihnu‑dé méé‑dě. Te núu ndisa sá cúú‑dě tée yɨ̀ndaha ñaha xii ñáyiu isràél, te na cùndehe‑o nuu‑dé núú cùrúxí‑a cuèndá quɨ́ndáá iní‑ó‑dě. ");
INSERT INTO milNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Te càchí‑dé sá sàndáá iní‑dé Yǎ Ndiǒxí, te mee‑gǎ ná dàcácu ñaha‑gǎ xii‑dé te núu cùndahú iní ñáhá‑gǎ, chi mee‑dě càchí‑dé sá Děhe‑gá cúú‑dě —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Te ndéé tnàhá cue tée cùu ñadúhú tácàa xio xio dɨñɨ‑gá xǐcuèhé ñáhá‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Te òré ní cuu cuádava nduu te ní cunee nɨhìí ñuyíú, te ducaⁿ‑ni càa ní cuu caá úní sacuaa. ");
INSERT INTO milNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Te òré sa ta cùyatni cuu caá úní sacuaa‑áⁿ, te níhi ní cáháⁿ Jèsús, te càchí‑gá: —Èlí, Èlí, ¿láma sabàctaní? —càchí‑gá. Te tnúhu‑áⁿ quéé‑xí: Ndiǒxí méè‑í, Ndiǒxí méè‑í, ¿ná cuèndá ní dáñá ñàha‑n xii‑í?, duha quèe‑xi tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Te dava cue tée xǐndecu yatni núú tácàa‑gá‑áⁿ nǐ tecú dóho‑güedé nàcuáa ní cáháⁿ‑gá, te ní xítnàha‑güedé: —Tée‑a càna‑dé té Èliás —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Te òré‑ni‑áⁿ nǐ quene cunu ɨɨⁿ cue tée xǐndecu‑áⁿ nǐ queheⁿ‑dé luha cáchí, te ní chindóyo‑dé xɨtɨ́ ndudí íá, te ní chinenu‑dé dɨ́quɨ́ ɨɨⁿ yutnu càni te ní ndocani‑dé ní chihi‑dé yuhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Te dava‑güedé ní xáhaⁿ‑güedě xii tée‑áⁿ: —Cundetu tnaa na cùndehe‑o nacoto núu quixi té Èliás dàcácu ñaha‑dě xii‑dé —càchí‑güedé xǎhaⁿ‑güedě xii tée‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Te Jèsús níhi ní cana saa‑gá, te ní xíhí‑ni‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Te sátá dúcáⁿ te ní ndátá dǒó cúú còrtiná xɨtɨ́ veñúhu càhnu sá ǐo cùnuu ní quée dava ndáá, te ndàa núú nǐnu ní ngüíta‑xi ní ndátá, te ní tnáa, te dava cava nàhnu ní táhú. ");
INSERT INTO milNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Te dava yaú núú yɨ́ndǔxi ñáyiu ní xíhí ní sándáá iní ñáhá xìi Yá Ndiǒxí ní nacaáⁿ te ní ndotó‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Te sátá nǐ yáha ní ndoto Jèsús, te cue ñáyiu ní ndoto‑áⁿ cuǎnguɨhú‑yu xɨtɨ́ ñuú Jerusàlén, te cue ñáyiu ñuú‑áⁿ ǐo vàí‑yu ní xiní‑yu cue ñáyiu ducaⁿ nǐ ndoto‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Te sá dúcáⁿ nǎndɨ ní quide‑xi, ndɨhɨ sá dúcáⁿ nǐ tnáa xíǎⁿ ío ní yùhú tée cùu capitáⁿ ndɨhɨ nchaa dava‑gá cue tée ndècu ndɨhɨ‑dé ndèé‑güedé yɨquɨ cùñú Jèsús, te ní xítnàha‑güedé: —Sá ndàá ndisa sá dɨ́ú těe‑a cùu‑dé Déhe Yá Ndiǒxí ní cùu —cachí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Te xica xǐnutnɨ́ɨ vài ñáyiu dɨ̀hɨ́ ndéhě‑yu nchaa nàcuáa ní quide ñaha‑güedě xii Jèsús, te ñáyiu‑áⁿ cúǔ‑yu ñáyiu ní chindèé‑yu Jèsús, te ndéé distrìtú Galìleá ní chinchícúⁿ ñáhǎ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Te tnuú ñáyiu‑áⁿ tnàhá tá Màriá Magdalèná, ndɨhɨ tá Màriá nǎná tě Jàcobó ndɨhɨ té Chèé, ndɨhɨ nǎná cue déhe té Zebèdeú. ");
INSERT INTO milNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Te ndècu ɨɨⁿ tée cuica nàni‑dé Chèé te cùu‑dé tée ñuú Arimàteá, te tnàhá‑dé ní tnahá tnúhu‑dé ndɨhɨ Jèsús. Te òré sa ní cuaa, ");
INSERT INTO milNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","te ní sáháⁿ‑dé núú tě Pìlatú, te xǎhaⁿ‑dě nǔu vá cúndèe iní‑dé daña‑dě chindúxi‑dé yɨquɨ cùñú Jèsús. Te té Pìlatú‑áⁿ nǐ sáha‑dé tnúhu, te ní táúchíúⁿ‑dě sá cuǎha cuèndá‑güedé té Chèé‑áⁿ yɨquɨ cùñú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Te té Chèé‑áⁿ nǐ queheⁿ cuèndá‑dé yɨquɨ cùñú‑gá, te ní chidúcúⁿnuu‑dé ɨɨⁿ dóó cuìxíⁿ dóó cándòo. ");
INSERT INTO milNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Te sa nchìí ɨɨⁿ yaú sáá nǐ caáⁿ té Chèé‑áⁿ ɨɨⁿ yɨquɨ naha càva te xíáⁿ cúú cuèndá‑dé, te yaú‑áⁿ nǐ chihi‑dé yɨquɨ cùñú Jèsús, te dǎtnùní ní sadɨ́‑dé ɨɨⁿ yúú cáhnú yǔú quèhéⁿ yuhu yàú‑áⁿ, te ní xica‑dé cuánuhú‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Te tnàhá tá Màriá Magdalèná, ndɨhɨ ɨngá xíchí nání Màriá ní quexìó‑yu ní ngóo‑yu yatni núú nchìí yaú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Te sátá nǐ yáha ní quide túha ñáyiu nchaa sá nándɨ̌hɨ‑yu nduu tněé nduu ndètatú‑yu‑áⁿ, te dɨu‑ni nduu ndètatú‑yu‑áⁿ nǐ sáháⁿ cue dútú cúnùu, ndɨhɨ cue tée cùu fariséú ní cáháⁿ ndɨhɨ‑güedé té Pìlatú. ");
INSERT INTO milNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Te xǎhaⁿ‑güedě xii‑dé: —Yòhó tée cùnuu, véxi‑ndɨ́ càchí tnúhu‑ndɨ́ sá nǐ ndacu iní‑ndɨ́ sá těe ndehnde nǐ xíhí‑ǎⁿ càchí‑dé òré ndécú‑gǎ‑dé sá ndùu úní sá cùú‑dé, te ndoto‑dé. ");
INSERT INTO milNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Te tendaha‑n cuè tée na quɨ̀hɨ́ⁿ‑güedé cundeé‑güedé yuhu yàú núú nǐ chihi‑güedé yɨquɨ cùñú‑dé, chi na cuáháⁿ quɨ́hɨ́ⁿ cue tée ní xica cuu ndɨhɨ‑dé duhu‑güedě yɨquɨ cùñú‑dé, te cúñaha‑güedě xii ñáyiu sá nǐ ndoto‑dé. Chi núu ducaⁿ na càda‑güedé te ío‑gá dandàhú‑güedé cue ñáyiu dàcúúxí dàtná ní quide mee těe ní xíhí‑ǎⁿ —càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Te té Pìlatú ní xáhaⁿ‑dě xii‑güedé: —Náu cue sandàdú‑a candeca‑ndo‑güedě quɨ́hɨ́ⁿ, te cadɨ́ váha‑ndo ndɨ̀hɨ‑güedé yuhu yàú‑áⁿ nàcuáa tàú‑xi cunduu, te na cùndeé‑güedé nàcuáa sàni iní‑ndó cùnduu —cachí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Te cue tée‑áⁿ nǐ xica‑güedé cuáháⁿ‑güedé, te ní tee‑güedé ɨɨⁿ sèñá yúú ndèdɨ́ yèhe yaú‑áⁿ, te ní dándǒo‑güedé cue sandàdú‑áⁿ ndèé‑güedé yaú‑áⁿ, te ducaⁿ nǐ quide‑güedé cuèndá sá vǎ yǒo quɨ́hɨ́ⁿ nacaáⁿ yaú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Te sátá nǐ yáha nduu ndètatú ñáyiu, te ndumìngú nehé víhí‑ní nǐ xica tá Màriá Magdalèná ndɨhɨ ɨngá xíchí nání Màriá cuángotó‑yu yaú núú nǐ chihi‑güedé yɨquɨ cùñú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Te uuⁿni níhi vìhi ní tnáa, te òré ducaⁿ nǐ quide‑xi chi ɨɨⁿ espíritú xínú cuèchi núú Yǎ Ndiǒxí ní quexìo‑xi núú dúcáⁿ nchìí yaú núú nǐ chihi‑güedé yɨquɨ cùñú Jèsús, te ní xócání espíritú‑áⁿ yǔú ndèdɨ́ yèhe yaú‑áⁿ te ní ngóo‑xi núú yǔú‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Te dàtná dátǎsaⁿ‑xi òré sàá ndúté dùcaⁿ datásaⁿ‑xi núú espíritú‑áⁿ, te dóó níhnú‑xí cuìxíⁿ quɨyɨ́. ");
INSERT INTO milNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Te òré ducaⁿ nǐ quide‑xi te cue sandàdú ndèé yaú‑áⁿ nǐ quɨdɨ ñaha‑xi xìi‑güedé sá nǐ yùhú‑güedé, te ní nduá‑güedé, te ní xíta sá xìní tnùní‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Te espíritú‑áⁿ nǐ xáhaⁿ‑xi xìi cue ñáyiu dɨ̀hɨ́ cuángoto yaú‑áⁿ: —Nchòhó ñáyiu dɨ̀hɨ́ véxi coto yaú‑a, vá yùhú‑ndó chi yúhú cútnùní iní‑í sá nchòhó véxi‑ndo nànducu‑ndo yɨquɨ cuñú Jèsús Yaá ní xíhí núú cùrúxí. ");
INSERT INTO milNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Dico Yaá‑áⁿ chi ñá túú‑gǎ ndécú yɨ̀quɨ cuñú‑gá iha, chi sa ní ndoto‑gá, te dɨu ducaⁿ nǐ cachí‑gá sá ndótó‑gǎ cútnàhá vátá cùú‑gá, te chí táquìxi cundehe‑ndo núú nǐ sacáⁿ‑güedé yɨquɨ cùñú‑gá ní cùu te quiní‑ndó nǎ ñá túú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Te vitna ío ndɨ̌hɨ chí cuàháⁿ núú xǐndecu cue tée ní xica cuu ndɨhɨ‑gá, te duha cúñaha‑ndo xìi‑güedé: “Ní ndoto Jèsús Yaá ní xíhí ní cùu, te codonùu‑gá núú‑ndó quɨ̌hɨ́ⁿ distrìtú Galìleá te yàcáⁿ quiní‑ndó‑gǎ”, duha cúñaha‑ndo xìi‑güedé. Duha ndùu tnúhu ní cachí tnúhu‑í xii‑ndo —càchí espíritú‑áⁿ xǎhaⁿ‑xi xìi cue ñáyiu dɨ̀hɨ́‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Te cue ñáyiu dɨ̀hɨ́‑áⁿ nǐ natnɨɨ́‑yu ichi, te súúní ndɨ̌hɨ cuánuhú‑yu núú xǐndecu cue tée ní xica cuu ndɨhɨ Jèsús cuèndá nacani tnúhu‑yu núú‑güedě nàcuáa ní xáhaⁿ espíritú‑áⁿ xií‑yu, te cuěi ní yùhú‑yu dico súúní cùdɨ́ɨ́ ìní‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Te ichi ñùhú‑yu cuánuhú‑yu, te na iní‑yu ní quexìo Jesús núǔ‑yu ní dándácǒo váha ñaha‑gǎ xií‑yu. Te ñáyiu‑áⁿ nǐ ngüɨ́ñɨ́ xɨ́tɨ̌‑yu núú‑gǎ, te ní numi ñàhá‑yu xii‑gá, te ní chiñuhu ñàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Te ní xáhaⁿ‑gǎ xií‑yu: —Vá yùhú‑ndó, chí cuàháⁿ cúñaha‑ndo xìi cue tée ní xica cuu ndɨhɨ‑í sá ná quɨ̀hɨ́ⁿ‑güedé distrìtú Galìleá, te yàcáⁿ quiní ñáhá‑güedě xii‑í —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Te nɨni ñùhu cue ñáyiu dɨ̀hɨ́‑áⁿ ichi cuánuhú‑yu, te dava cue sandàdú cue tée ndèé yaú‑áⁿ ní cùu ní xica‑güedé cuánuhú‑güedé ñuú cuèndá nacani tnúhu‑güedé núú cuè tée cùu dútú cúnùu nacuáa ní cuu. ");
INSERT INTO milNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Te cue tée cùu dútú cúnùu‑áⁿ nǐ quide‑güedé jùndá ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél, te ní ndatnúhu‑güedé nàcuáa cada‑güedé, te ní quide ndáá‑güedé ndɨhɨ cue sandàdú‑áⁿ sǎ cuǎñaha‑güedě vài díhúⁿ cuèndá dacuàndehnde‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Te ní xáhaⁿ‑güedě xii cue sandàdú‑áⁿ: —Cuìní‑ndɨ́ sá vǎ càháⁿ ndáá‑ndó nǔú ñǎyiu nàcuáa ní cuu, chi cúñaha‑ndo xìí‑yu sá òré xìdí‑ndó nǐ quixi cue tée ní xica cuu ndɨhɨ‑dé ní dúhú‑güedě yɨquɨ cùñú‑dé néhé‑güedě cuáháⁿ, duha cúñaha‑ndo xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Te núu na nìhí té Pìlatú tée cùu gobiernú tnúhu nàcuáa cúñaha‑ndo xìi ñáyiu, te nchúhú cada ndáá‑ndɨ́ ndɨhɨ‑dé cuèndá sá ñà túú nǎ cada ñaha‑dě xii‑ndo —càchí‑güedé xǎhaⁿ‑güedě xii cue sandàdú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Te cue sandàdú‑áⁿ nǐ queheⁿ cuèndá‑güedé díhúⁿ, te ní xica‑güedé cuáháⁿ‑güedé te ní cáháⁿ‑güedé nàcuáa ní xáhaⁿ cuè tée‑áⁿ cǎháⁿ‑güedé. Te nchaa ñáyiu isràél ní níhǐ‑yu tnúhu ní cáháⁿ‑güedé‑áⁿ, te dɨu‑ni tnúhu‑áⁿ càháⁿ‑yu ndéé vitna. ");
INSERT INTO milNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Te ndɨ ùxí ɨɨⁿ cue tée ní xica cuu ndɨhɨ Jèsús ní xica‑güedé cuáháⁿ‑güedé ɨɨⁿ yucu càa distritú Galìleá núú nǐ xáhaⁿ‑gǎ naníhí tnáhá‑güedě ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Te òré ní xiní‑güedé Jèsús te ní chiñuhu ñaha‑güedě xii‑gá, dico dava‑güedé sàni ɨɨⁿ sani úú iní‑güedé nǔu dɨu‑gá àdi ñá dɨ́ú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Te Jèsús ní sándehe yatni‑gá ndéé núú‑güedě, te ní xáhaⁿ‑gǎ xii‑güedé: —Yúhú ndécú ndɨ̀hɨ‑í tnúhu ndee ìní táxí tnùní‑í cuěi andɨu te cuěi ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Te vitna tàuchiuⁿ‑í sá quɨ̀hɨ́ⁿ‑ndó nɨ̀hií ñuyíú cǎháⁿ‑ndó tnǔhu‑í núú ñǎyiu cuèndá tuha ñàhá‑yu xii‑í, te dacuàndute‑ndó‑yu. Te òré ducaⁿ càda‑ndo, te cacunehe‑ndo tǎtá‑ó Dǔtú Ndiǒxí ndɨhɨ yúhú Yaá cúú Děhe‑gá ndɨhɨ Espíritú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Te cúñaha‑ndo xìí‑yu sá ná càdá‑yu nchaa nàcuáa sa ní dánèhé ñáhà‑í xii‑ndo càda‑ndo. Te na càchí tnúhu‑í sá cúndècu ndɨhɨ ñaha‑ni‑í xii‑ndo ñùyíú‑a ndéé ná sàá nduu nàa‑xi —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ducaⁿ na cùnduu.");
INSERT INTO milNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Duha ní quesaha tnǔhu sá càháⁿ nàcuáa naníhí tàhú‑ó tnǔhu Xítohó Jesucrìstú Déhe Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Te ndíi Chàiá tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǐ chídó tnùní ndíi nàcuáa ní xáhaⁿ Yǎ Ndiǒxí xii Déhe‑gá, te duha ní xáhaⁿ‑gǎ: Tendaha‑ǐ ɨɨⁿ tée codonùu‑dé núú‑n, te dàtúha‑dé ñáyiu cuèndá tnɨɨ́‑yu tnúhu‑n. ");
INSERT INTO milNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Te tée‑áⁿ quɨhɨ‑dé xɨtɨ́ yucu te níhi cáháⁿ‑dé cúñaha‑dě xii ñáyiu: “Chí dáñá nchàa ichi cuehé ichi duha ndècu‑ndo, te tnɨɨ‑ndo ìchi váha, te ducaⁿ càda‑ndo cuendá cundecu túha‑ndo, chi véxi Yaá ío cùnuu”, duha cúñaha‑dě xií‑yu. Duha ndùu tnúhu ní chídó tnùní ndíi Chàiá nàcuáa ní xáhaⁿ Yǎ Ndiǒxí xii Déhe‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Te tée dii cuèndá‑xi ní ngódó tnùní‑áⁿ nání‑dě Juàá, te tée‑áⁿ nǐ xɨ́hɨ‑dé xɨtɨ́ yucu ní cáháⁿ‑dé tnúhu Yá Ndiǒxí, te ní xóo dacuàndute‑dé ñáyiu, te duha ní xáhaⁿ‑dě xií‑yu: —Chí dándìxi túu iní sá ñà túú quìde váha‑ndo ndècu‑ndo, te daña‑ndo nchàa ichi cuehé ichi duha te cuandute‑ndo, te ducaⁿ te Yá Ndiǒxí cada càhnu iní‑gá nchaa yícá cuěchi‑ndo —duha ní xáhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Te nchaa ñáyiu distrìtú Jùdeá, ndɨhɨ ñáyiu ñuú Jerusàlén ní sáháⁿ‑yu ndéé yúte Jòrdán núú ndécú tě Juàá ní xíndedóho‑yu nchaa tnúhu ní cáháⁿ‑dé. Te cue ñáyiu ní náhmá nchaa yícá cuěchi‑xi te ní dácuándùte ñaha‑dé xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Te té Juàá‑áⁿ nǐ xíhnu‑dé dóó idi càméyu, te ɨɨⁿ ñɨɨ ní cuu pàñú xɨtɨ́‑dé, te ní xóo caxi‑dé tɨ́ca làngóstá ndɨhɨ ndudí ñúñú cuéchí. ");
INSERT INTO milNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Te ní xáhaⁿ tùcu‑dé xii ñáyiu: —Nchìcúⁿ ɨɨⁿ tée véxi, te tée‑áⁿ ǐo‑gá cúnùu‑dé dàcúúxí yǔhú, chi yúhú cúù‑í ɨɨⁿ tée duuⁿ duuⁿ ñá túú tàú‑í ngúnundeyɨ‑í nandaxi cuědìcó ñɨɨ nihnu chàú‑dé dico quìde‑í chìuⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Te yúhú dácuàndute ñaha‑í xii‑ndo, dico mee‑dě taxi‑dé Espíritú Yǎ Ndiǒxí cundecu ndɨhɨ‑ndo —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Te dàvá‑áⁿ nǐ quee Jèsús ñuú Nazàrét ɨɨⁿ ñuú yɨ́ndèhu distritú Galìleá cuáháⁿ‑gá yúte Jòrdán. Te yàcáⁿ ní dácuándùte ñaha té Juàá xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te òré ní nene‑gá xɨtɨ́ ndute, te ní xiní‑gá nchìí andɨu, te ní quee Espíritú Yǎ Ndiǒxí véxi cuuⁿ‑xi ngúndecu ndɨhɨ ñaha‑xi xìi‑gá, te dàtná cáá ɨ̀ɨⁿ lómá cáá Espíritú‑áⁿ věxi cuuⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Te òré‑áⁿ nǐ tecú ní cáháⁿ Yǎ Ndiǒxí ndéé andɨu, te xǎhaⁿ‑gǎ xii Jèsús: —Yòhó cúú‑n Děhe‑í tée ío cùu iní‑í te ío cùdɨ́ɨ́ ìní ñáhà‑í xii‑n —càchí‑gá xǎhaⁿ‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Te Espíritú Yǎ Ndiǒxí ndécá‑xí Jèsús cuáháⁿ ɨɨⁿ xɨtɨ́ yucu. ");
INSERT INTO milNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Te xɨtɨ́ yucu‑áⁿ ìó víhí quɨ̀tɨ dééⁿ, te xíáⁿ ndécú Jèsús ní ngüíta sácuíhná quídé yìca‑xi cada‑gá ɨɨⁿ sá ñà túú tàú‑gá cada‑gá dico ñá túú ní sàndáá iní‑gá. Te cue espíritú xínú cuèchi núú Yǎ Ndiǒxí ní xinu cuechi‑xi nǔú‑gǎ. Te ní xíndecu‑gá údico nduu xɨtɨ́ yucu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Te sátá nǐ ngava té Juàá vecaá, te Jèsús cuáháⁿ‑gá distrìtú Galìleá dànehé‑gá ñáyiu tnúhu váha, tnúhu sá càháⁿ nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Te xǎhaⁿ‑gǎ xií‑yu: —Vitna sa ní cuyatni nduu ndɨ̌hu ndaha ñàha Yá Ndiǒxí xii‑ndo, te chí dáñá nchàa ichi cuehé ichi duha ndècu‑ndo, te quɨndáá iní‑ndó tnǔhu váha, tnúhu sá càháⁿ nàcuáa naníhí tàhú‑ndó —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Te Jèsús ñúhú‑gǎ ichi cuáháⁿ‑gá tá yǎha‑gá yuhu làgúná Galìleá, te ní xiní‑gá té Xǐmú ndɨhɨ ñaní‑dé té Ndrǐxí xǐdáquěe‑güedé ñunu‑güedé xɨtɨ́ ndute tnɨ̀ɨ‑güedé chácá, chi quɨtɨ tnàhí‑áⁿ cúú chìuⁿ‑güedé tnɨ́ɨ́‑güedě‑dɨ. ");
INSERT INTO milNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí dáñá chìuⁿ quide‑ndo‑áⁿ, te quixi‑ndo chìtnahá ñáhá‑ndó xìi‑í te taxi‑í ɨngá núú chìuⁿ cada‑ndo chi quɨ́hɨ́ⁿ‑ndó cǎháⁿ‑ndó ñǎyiu cuèndá dacuàhá‑yu tnúhu‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Te òré‑ni‑áⁿ nǐ dáñá cuè tée‑áⁿ ñunu‑güedé te ní tuha ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Te cuáháⁿ‑gá luha‑gá, te ní xiní‑gá té Jàcobó ndɨhɨ ñaní‑dé té Juàá ñúhú‑güedě xɨtɨ́ bàrcú‑güedé nátɨ̌cu‑güedé ñunu‑güedé, te ndɨ ndùú‑güedé cúú‑güedě déhe té Zebèdeú. ");
INSERT INTO milNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Te ní cana ñaha‑gǎ xii‑güedé, te ní dándǒo‑güedé tǎtá‑güedě ndɨhɨ cue tée xìnu cuechi núú‑güedě xɨtɨ́ bàrcú, te ní tuha ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Te ní quexìo Jesús ndɨhɨ cue tée‑áⁿ ɨɨⁿ ñuú nání Càpernaúm, te yàcáⁿ ndécú‑gǎ ní tnahá nduu ndètatú ñáyiu, te cuánguɨhu‑gá veñúhu ñáyiu isràél dànehé ñáhá‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Te xǐcuñúhu vìhí‑yu nchaa tnúhu càháⁿ‑gá, chi quìde‑gá sá cúú‑gǎ ɨɨⁿ Yaá táxí tnùní víhí, te ñá túú dàcuaha ñaha‑gá xií‑yu dàtná dácuàha ñaha cue tée dàcuaha ñaha xií‑yu nchaa tnúhu ní chídó tnùní ndíi Moìsés. ");
INSERT INTO milNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Te xɨtɨ́ veñúhu‑áⁿ ndécú tnàhá ɨɨⁿ tée yɨ̀hɨ ñaha ɨɨⁿ espíritú cúndɨ̀hɨ yucu ñávǎha, te espíritú‑áⁿ nǐ quide‑xi níhi ní cáháⁿ tée‑áⁿ, te xǎhaⁿ‑dě xii Jèsús: ");
INSERT INTO milNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Te ná cuìní yòhó Jèsús tée ñuú Nazàrét cada ñaha‑n xìi‑ndɨ́ nǔu véxi‑n nǔú ndécú‑ndɨ̌‑i? ¿Áⁿ věxi‑n dànaa ñaha‑n xii‑ndɨ́? Chi yúhú xìní ñáhà‑í xii‑n sǎ cúú‑n ɨ̀ɨⁿ tée ñá túú tnàhí cuéchi‑xi, chi núú Yǎ Ndiǒxí ní quee‑n věxi‑n ñùyíú‑a —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dico Jèsús ní tenàá‑gá espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ, te xǎhaⁿ‑gǎ: —¡Cadɨ́ yuhu‑n, te taquèe yɨquɨ cuñú tée‑áⁿ! —càchí‑gá xǎhaⁿ‑gǎ xii espíritú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Te espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ nǐ dácǔyɨ̀hɨ́ ñáhá‑xí xìi tée‑áⁿ, te ní dácáná sàa ñaha‑xi, te ní quee‑xi yɨquɨ cùñú‑dé cuáháⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Te nchaa ñáyiu xǐndecu‑áⁿ ǐo ní cuñúhu‑yu, te ní xítnàhá‑yu: —¿Te nása ndùu‑tu sá quídé těe‑a? ¿Ndudú sáá càháⁿ‑tu‑dé sánùu? Te quìde‑dé dàtná quídé ɨ̀ɨⁿ tée cùnuu vihi, chi càháⁿ‑ni‑dé te sàndáá iní ñáhá nchàa espíritú cúndɨ̀hɨ yucu ñávǎha —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Te ío ndɨ̌hɨ ní níhí nchaa ñáyiu dava‑gá ñuú yɨ́ndèhu distritú Galìleá tnúhu nchaa nàcuáa càháⁿ Jèsús ndɨhɨ nchaa sá quídé‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Te òré ní ndee Jèsús veñúhu cue ñáyiu isràél, te cuáháⁿ‑gá ndɨhɨ té Jàcobó ndɨhɨ té Juàá vehe té Xǐmú ndɨhɨ té Ndrǐxí. ");
INSERT INTO milNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Te nǎná ñadɨ̀hɨ́ té Xǐmú cùhú‑aⁿ ñùhu vihi‑aⁿ cahni, te ndɨ̌hɨ‑ni ní xáhaⁿ‑güedě xii Jèsús sá cùhú‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Te ní sáháⁿ‑gá núú cáá ñàha cuhú‑áⁿ te ní tnɨɨ‑gá ndaha‑aⁿ ní ndocani ñaha‑gǎ xii‑aⁿ. Te òré‑ni‑áⁿ nǐ nchíco‑aⁿ cahni, te ní ngüíta‑aⁿ xìnu cuechi‑aⁿ núú‑güedě ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Te òré sa cuìní‑xi cundɨquɨⁿ te ní quexìo ñáyiu núú ndécú Jèsús, te nchaa ñáyiu cùhú ní dátàcá‑yu ndècá‑yu ní sáá núú‑gǎ, te tnàhá cue ñáyiu yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha ndècá‑yu ní sáá núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Te nchaa ñáyiu ñuú‑áⁿ nǐ chítú níhnǔ‑yu yuyèhe vehe núú nǐ quexìo Jesús. ");
INSERT INTO milNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Te Jèsús ní quide tátna‑gá nchaa ñáyiu cùhú cuěi ndɨ dɨ́ɨ́ⁿ ndɨ̀ dɨ́ɨ́ⁿ nǔú cuěhé tnàhá‑yu ɨɨⁿ ɨɨ́ⁿ‑yu, te ní queñuhu‑gá nchaa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu, te ñá túú ní dàña‑gá cáháⁿ cue espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ ni ɨ̀ɨⁿ tnúhu, te ducaⁿ nǐ quide‑gá chi cue espíritú‑áⁿ sa xìní‑xi yoo cùu‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Te òré vátá tǔndaá váha‑gá ní ndacóo Jèsús cuáháⁿ‑gá ɨɨⁿ xio yuhu ñùú núú ñà túú ñǎyiu ndècu cuendá yàcáⁿ cáháⁿ ndɨhɨ‑gá Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Te té Xǐmú ndɨhɨ cue tée cùndɨhɨ‑dé nándùcu ñaha‑güedé xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Te òré ní naníhí ñáhá‑güedě xii‑gá, te ní xáhaⁿ‑güedě: —Nchaa ñáyiu nànducu ñahá‑yu xii‑n —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Te ní xáhaⁿ‑gǎ xii‑güedé: —Chí ná quɨ̀hɨ́ⁿ‑ó nchàa ñuú xǐndáa yatni‑a, chi danèhé‑í ñáyiu tnúhu Yá Ndiǒxí chi dɨu chìuⁿ‑áⁿ věxi‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Te Jèsús tá xìca ndodo‑gá cuáháⁿ nchaa ñuú yɨ́ndèhu distritú Galìleá dánèhé‑gá ñáyiu, te ndɨ tnahá ɨɨⁿ ɨɨⁿ ñuú sàá‑gá te ducaⁿ cuǎnguɨhu‑gá veñúhu‑yu dànehé ñáhá‑gǎ xií‑yu tnúhu Yá Ndiǒxí, te cue ñáyiu yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha ta quèñuhu‑gá nchaa espíritú‑áⁿ yɨquɨ cùñú‑yu cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Te ní quexìo ɨɨⁿ tée tnàhá cuéhé sǎ dátèhyú nihnu‑xi yɨquɨ cùñú‑ó nǔú Jèsús, te ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú‑gǎ càháⁿ ndàhú‑dé, te xǎhaⁿ‑dě xii‑gá: —Véxi‑í càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n càda tátna ñaha‑n xìi‑í chi cùtnuní iní‑í sá ndácú‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Te Jèsús ní cundàhú iní ñáhá‑gǎ xii‑dé te ní dácàá‑gá ndaha‑gá ní tendaha ñàha‑gá xii‑dé, te xǎhaⁿ‑gǎ: —Cuu cada tátna ñaha‑ǐ xii‑n, te vitna ndúha‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Te òré‑ni‑áⁿ nǐ xócuɨ̀ñɨ́ cuéhé tnàhá‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Te Jèsús ní cáháⁿ víhí‑gǎ dóho‑dé, te xǎhaⁿ‑gǎ xii‑dé: —Vitna cuanùhú‑na, dico vá yǒo ɨɨⁿ cúñaha‑n sà ní quide tátna ñaha‑ǐ xii‑n, te núú dǔtú‑ni cuàháⁿ cuèndá sá ná quìní ñáhá‑dě xii‑n sà ní ndúha‑n te cuáha‑n‑dě sá ndúú tǎhú Yǎ Ndiǒxí dàtná ní cachí ndíi Moìsés cuèndá ná quìní ñáyiu sá ndàá ní ndúha‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Te tée ní cuhú‑áⁿ nǐ xica‑dé cuáháⁿ‑dé, te ní ngüíta‑dé xǎhaⁿ‑dě xii nchaa ñáyiu ta nàníhí‑dě nàcuáa ní quide Jèsús ní quide tátna ñaha‑gǎ xii‑dé. Te sá dúcáⁿ nǐ xíté nuu tée‑áⁿ cuèndú nàcuáa ní quide ñaha Jèsús xii‑dé ní quide tátna ñaha‑gǎ ní ndúha‑dé, te xíǎⁿ nǔu dayuhu nǐ xóo quɨ́hu‑gá dava ñuú núú ǐo vài ñáyiu ndèhe ñaha xii‑gá, te ní xóo cundecu‑gá xɨtɨ́ yucu núú ñà túú ñǎyiu ndècu. Te nchaa ñuú ní quee ñáyiu ní sáháⁿ‑yu núú ndécú‑gǎ ní cáháⁿ ndɨhɨ ñàhá‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Te sátá nǐ cuu ɨɨⁿ ǔú nduu sá nǐ quee Jèsús ñuú Capèrnaúm te ní nasáá tucu‑gá, te cue ñáyiu ní níhǐ‑yu tnúhu sá nǐ ndexìo‑gá núú quídé vèhe‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Te ndɨ̌hɨ‑ni ní tacá cuéhé víhǐ‑yu, te ní chítú víhǐ‑yu ndéé yuyèhe te ñá ní tnàhá‑gá‑yu. Te ní ngüíta‑gá ní dánèhé ñáhá‑gǎ xií‑yu tnúhu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Te òré‑áⁿ nǐ quexìo cúmí tnàhá cue tée núú ndécú‑gǎ nchídó‑güedě ɨɨⁿ tée cùhú ñá cúú‑gǎ candá nihnu‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dico ñá túú ní ndàcu‑güedé sáá‑güedé ndéé núú‑gǎ chi ío cuéhé ñǎyiu ndècu. Te xíǎⁿ nǔu ní sáá‑güedé dɨ́quɨ́ véhé nǔú yɨ́hɨ́‑gǎ‑áⁿ nǐ caáⁿ‑güedé, te ichi ndàa dɨ́quɨ́ véhé‑ǎⁿ nǐ dáquěe‑güedé tée cùhú‑áⁿ, te ñùhu‑dé ɨɨⁿ xíto ní dáquěe ñaha‑güedě ndéé núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Te Jèsús sa ní cutnùní iní‑gá sá sàndáá iní ñáhá‑güedě xii‑gá nǔu ní xáhaⁿ‑gǎ xii tée cùhú‑áⁿ: —Yòhó tée cùhú, sa ní quide càhnu iní‑í nchaa cuéchi‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Te xíáⁿ xǐnucóo ɨɨⁿ ǔú cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, te sá dúcáⁿ nǐ cáháⁿ Jèsús núú cue tée‑áⁿ nǐ sani iní‑güedé: ");
INSERT INTO milNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Tée‑a càháⁿ cuèhé‑dé cuèndá Yǎ Ndiǒxí duha càháⁿ‑dé, chi vá yǒo ɨɨⁿ ndàcu cada cahnu iní nchaa yícá cuěchi ñáyiu chi ɨɨⁿdìi díí‑ni Yá Ndiǒxí quídé càhnu iní‑gá”, duha ní sani iní‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dico òré‑ni‑áⁿ nǐ cutnùní iní Jèsús nàcuáa sàni iní‑güedé, núu ní xáhaⁿ‑gǎ xii‑güedé: —¿Te ná cuèndá ducaⁿ sàni iní‑ndó‑í? ");
INSERT INTO milNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Te sá dúhá nǐ xáhaⁿ‑ǐ xii tée cùhú‑a sá nǐ quide càhnu iní‑í nchaa yícá cuěchi‑dé, te xíǎⁿ nchòhó ñá túú cùtnuní iní‑ndó nǔu ndáá càháⁿ‑í àdi ñá ndàá. Dico núu cúu‑í‑dé sá ndácǒo‑dé, te ndocani‑dé xíto ñùhu‑dé véxi, te caca‑dé, te cutnùní ndáá iní‑ndó nǔu ndáá càháⁿ‑í àdi ñá ndàá chi cundehe nǔú‑ndó nàcuáa cada‑í. ");
INSERT INTO milNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Te vitna na càda‑í nàcuáa cutnùní iní‑ndó nchàa‑ndo sá yǔhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ndecu ndɨhɨ‑í tnúhu ndee ìní sá cádá càhnu iní‑í nchaa cuéchi ñáyiu ñuyíú‑a —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te sátá dúcáⁿ te ní xáhaⁿ‑gǎ xii tée cùhú‑áⁿ: ");
INSERT INTO milNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ndacóo te ndocani‑n xǐto ñùhu‑n véxi‑áⁿ, te núhú‑n vèhe‑n —cachí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Te òré‑ni‑áⁿ nǐ ndacóo‑dé, te ní ndocani‑dé xíto ñùhu‑dé ní quexìo‑áⁿ, te ndèhe nchaa ñáyiu xǐndecu‑áⁿ nǐ ndee‑dé tnuú‑yu cuáháⁿ‑dé. Te sá dúcáⁿ nǐ quide Jèsús ní quide tátna‑gá tée‑áⁿ, xíǎⁿ ío ní cuñúhu nchaa ñáyiu, te ní xítnàhá‑yu: —Càhnu vihi cuu Yá Ndiǒxí, chi ñá ɨ́ɨ́ⁿ ndùu quiní‑ó dùha cuu datná ní cuu vitna —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Te Jèsús cuáháⁿ tucu‑gá yuhu làgúná, te ío cuéhé ñǎyiu ní sátnàhá ñáhá xìi‑gá, te ní dánèhé ñáhá‑gǎ xií‑yu tnúhu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Te òré ní yáha ní dánèhé ñáhá‑gǎ xií‑yu, te ní naqueheⁿ‑gá ichi, te ní yáha yatni‑gá ɨɨⁿ xichi núú núcǒo ɨɨⁿ tée nàni Leví déhe ɨɨⁿ tée nàni Alfeú quídé còbrá‑dé ñáyiu cuèndá impuèstú chi cobràdór cúú‑dě. Te òré ní xiní ñáhá‑gǎ xii‑dé, te ní xáhaⁿ‑gǎ: —Néhé chitnahá ñáhá‑n xìi‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te té Lèví‑áⁿ nǐ ndacuɨ́ñɨ́‑dé, te ní tuha ñaha‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Te té Lèví‑áⁿ cuǎháⁿ‑dé ndɨhɨ Jèsús vehe‑dé. Te yɨ̀hɨ Jesús mèsá xéxí‑gǎ ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te tnàhá vài cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú, ndɨhɨ dava‑gá cue tée ndècu ichi cuehé ichi duha nùcóo ndɨhɨ ñaha‑güedě xii‑gá xéxí ndɨ̀hɨ ñaha‑güedé, te ducaⁿ chi ío vài ñáyiu nchìcúⁿ ñáhá xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Te sá nǐ xiní cue tée dàcuáha ñaha xií‑yu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùu fariséú xéxí Jèsús ndɨhɨ nchaa cue tée‑áⁿ nǔu ní xícáⁿ tnúhú‑güedě núú cuè tée xìca cuu ndɨhɨ‑gá, te xǎhaⁿ‑güedě: —¿Ná cuèndá ducaⁿ quìde tée cùu mestrú‑ndó xèxi‑dé ndɨhɨ cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú, ndɨhɨ nchaa dava‑gá cue tée ndècu ichi cuehé ichi duha‑i? —càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Te Jèsús ní tecú dóho‑gá nàcuáa ndùu tnúhu ní xáhaⁿ‑güedě xii cue tée xìca cuu ndɨhɨ‑gá, núu ní xáhaⁿ‑gǎ xii‑güedé: —Nchaa ñáyiu ñá túú cùhú chi ñá túú xìni ñuhú‑yu ñátátná, dico nchaa ñáyiu cùhú chi xìni ñuhú‑yu ñátátná. Te yúhú véxi‑í càháⁿ‑í ñáyiu cùtnuní iní‑xi sá ndécú cuěchi‑xi te ñá túú věxi‑í càháⁿ‑í ñáyiu càchí sá ñà túú ndècu cuéchi‑xi —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Te cue tée xìca cuu ndɨhɨ té Juàá, ndɨhɨ cue tée xìca cuu ndɨhɨ cue tée cùu fariséú ñá túú tnàhí ná xéxí‑güedě áma càháⁿ ndɨhɨ‑güedé Yǎ Ndiǒxí. Te ɨɨⁿ nduu ducaⁿ xǐquide‑güedé, te ní sáháⁿ ñáyiu ní xícáⁿ tnúhǔ‑yu núú Jèsús, te xǎhǎⁿ‑yu xii‑gá: —Cuìní‑ndɨ́ cachí tnúhu‑n nǎ cuèndá cue tée xìca cuu ndɨhɨ té Juàá, ndɨhɨ cue tée xìca cuu ndɨhɨ cue tée cùu fariséú ñá túú tnàhí ná xéxí‑güedě áma càháⁿ ndɨhɨ‑güedé Yǎ Ndiǒxí, te cue tée xìca cuu ndɨhɨ‑n ñá túú dùcaⁿ quide‑güedé —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Te Jèsús ní xáhaⁿ‑gǎ xií‑yu: —Nchòhó xìní‑ndó sǎ vǎ cúú cǔñaha‑o xìi ñáyiu ñùhu vico tnándaha sá vǎ cúú càxí‑yu nɨni ndècu ndɨhɨ ñaha tée tnǎndaha xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Dico sáá nduu te vá cúndècu ndɨhɨ ñaha‑gá tée tnǎndaha‑áⁿ xií‑yu, te dàvá‑áⁿ te cahni iní‑yu vá cáxǐ‑yu cuèndá sá ndɨ̀hú iní‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Te vá yǒo ɨɨⁿ dàndée luha dóó sáá ɨ̀ɨⁿ dóó sa ní cuu tùhú víhí, chi dóó sáá‑ǎⁿ nàndɨyɨ‑xi te uuⁿ‑gá ndata‑xi dǒó sà ní cuu tùhú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Te ni vǎ yǒo ɨɨⁿ chìhi ndidí sáá xɨ̀tɨ́ ɨɨⁿ lamba sa ní cuu tùhú víhí, chi núu yoo ducaⁿ na càda te ndava lamba sa ní cuu tùhú‑áⁿ, chi ío níhi yócó ndìdí‑áⁿ, te cuíta‑ni ndidí‑áⁿ te cuíta‑ni lamba‑áⁿ te núu ducaⁿ na càdá‑yu. Núu xíǎⁿ xíní ñùhu‑xi quée ndidí sáá‑ǎⁿ xɨtɨ́ ɨɨⁿ lamba saa —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Te ɨɨⁿ nduu cùu‑xi nduu ndetatú ñáyiu ñùhu Jesús ichi ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te ta yǎha‑gá ndɨhɨ‑güedé ɨɨⁿ xichi núú cáá trìú, te ní ngüíta‑güedé sàhnú‑güedé yoco trìú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Te cue tée cùu fariséú ní xáhaⁿ‑güedě xii‑gá: —¿Ná cuèndá ducaⁿ quìde cue tée xìca cuu ndɨhɨ‑n sahnú‑güedé yoco trìú vitna cùu‑xi nduu ndetatú‑i? Te ñá túú tàú‑güedé ducaⁿ càda‑güedé —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Te ní xáhaⁿ‑gǎ xii‑güedé: —¿Te náa vátá dácuàha tnahi‑gá‑ndó nǔú tùtú Yǎ Ndiǒxí núú càháⁿ‑xi nàcuáa ní quide ndíi Dàvií cútnàhá ní xíhí ndíi docó ndɨhɨ cue tée ní xica cuu ndɨhɨ ndíi‑ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Te dàvá‑áⁿ nǐ xíndecu ɨɨⁿ tée ní xínani Abiàtár ní cuu‑dé dútú cúnùu, te ndíi Dàvií ní quɨ́hu ndíi xɨtɨ́ vehe Yá Ndiǒxí ní queheⁿ ndíi pàá ní cuu íí ndécú‑ǎⁿ nǐ dácǎhñu ndíi cue tée ní xica cuu ndɨhɨ ndíi ní xexi ndíi ndɨhɨ‑güedé, te mee‑ni cuè dútú tàú‑güedé caxi‑güedé pàá‑áⁿ ní cùu —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Te ní xáhaⁿ tùcu Jesús xii‑güedé: —Mee Yǎ Ndiǒxí ní taxi ndecu‑gá nduu ndètatú ñáyiu, te ñá túú ní càchí‑gá sá méě‑yu nándɨ cani iní‑yu cadá‑yu canehe íǐ‑yu nduu ndètatú‑yu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Te yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, tnàhá‑í ndécú ndɨ̀hɨ‑í tnúhu ndee ìní sá cǔu‑í nchaa ñáyiu nàcuáa cadá‑yu nduu ndètatú‑ó‑áⁿ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Te Jèsús cuánguɨhu tucu‑gá xɨtɨ́ veñúhu, te xɨtɨ́ veñúhu‑áⁿ ndécú ɨ̀ɨⁿ tée ní yíchí ɨɨⁿ xio ndaha‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Te xíáⁿ ndécú cuè tée xìto dayuhu ñaha xii‑gá, te núu cada tátna‑gá tée cùhú‑áⁿ nduu cùu‑xi nduu ndetatú‑güedé ndɨhɨ ñáyiu, cuèndá ducaⁿ te níhí‑güedě nàcuáa cada‑güedé cacáⁿ cuéchi‑güedé cuèndá‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Te ní xáhaⁿ‑gǎ xii tée cùhú ndaha‑xi‑áⁿ: —Ndacuɨ́ñɨ́ te ngúnutnɨ́ɨ‑n cuǎdava iha —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Te ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ: —Chí càchí tnúhu ná cúú sǎ cúú càda‑o nduu ndetatú‑ó. ¿Sá vǎha ñǎ sá cuèhé? ¿Sá cádá tǎtna‑o ñǎyiu cùhú ñǎ sá cáhnì‑ó‑yu? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Dico ni ɨ̀ɨⁿ‑güedé ñá túú tnàhí ni cǎháⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Te Jèsús ní xíndéhé vǎha‑gá núú nchàa‑güedé te ní cudééⁿ‑gǎ, te ní ndɨ́hú iní‑gá chi ío sàá iní‑güedé, te ní xáhaⁿ‑gǎ xii tée cùhú ndaha‑xi‑áⁿ: —Ndocani ndaha‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te ní ndocani‑dé ndaha‑dé, te òré‑ni‑áⁿ nǐ ndúha. ");
INSERT INTO milNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Te cue tée cùu fariséú ní xica‑güedé cuáháⁿ‑güedé ɨɨⁿ xichi núú nǐ naníhí tnáhá‑güedě ndɨhɨ cue tée cùndɨhɨ té Hèrodés cuèndá ndatnúhu‑güedé nása cada‑güedé cahni‑güedé Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Te Jèsús ní xica‑gá cuáháⁿ‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá yuhu làgúná distrìtú Galìleá, te ío cuéhé ñǎyiu distrìtú‑áⁿ nchìcúⁿ ñáhǎ‑yu xii‑gá cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Te núú nǐ quexìo‑gá‑áⁿ nǐ sáháⁿ ñáyiu distrìtú Jùdeá, ñáyiu ñuú Jerusàlén, ñáyiu distrìtú Idùmeá, ñáyiu xǐndecu ndàa ɨngá xio yúte Jòrdán, ndɨhɨ ñáyiu xǐndecu yatni ñuú Tìrú ndɨhɨ ñuú Sìdón, te ducaⁿ ǐo vàí‑yu ní sáháⁿ núú ndécú‑gǎ chi ní níhǐ‑yu tnúhu nchaa nàcuáa quìde‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Te Jèsús ní xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá sá cádá tǔha‑güedé ɨɨⁿ bàrcú cuèndá caa‑gá núú‑xi cuèndá sá vǎ dádèhnde ñahá‑yu xii‑gá chi ío cuéhě‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Te sá dúcáⁿ nǐ níhǐ‑yu tnúhu sá quídé tǎtna‑gá ñáyiu cùhú, núu xíǎⁿ nchaa dava‑gá ñáyiu cùhú súúní dìcó ngǒnchihi tnàhá‑yu cuáháⁿ‑yu núú ndécú‑gǎ cuìní‑yu tnándeé ñáhǎ‑yu xii‑gá cuèndá sá cuìní‑yu ndúha‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Te cue ñáyiu yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha ní sanu xɨtɨ ñàha‑xi xií‑yu núú Jèsús òré ní xiní ñáhá‑xí xìi‑gá, te xíǎⁿ ní quide níhi ní cáháⁿ‑yu, te xǎhǎⁿ‑yu xii Jèsús: —¡Yòhó cúú‑n Děhe Yá Ndiǒxí! —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Te Jèsús ní tenàá‑gá nchaa espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ, te ní xáhaⁿ‑gǎ xii nchaa ñáyiu ní xɨ́hɨ‑xi‑áⁿ sǎ vǎ càháⁿ‑yu núú ñǎyiu yoo cùu‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Te sátá dúcáⁿ nǐ cuu te Jèsús ní sáá‑gá ɨɨⁿ yucu, te xíáⁿ ndécú‑gǎ ní cana‑gá nchaa cue tée càchí iní‑gá. Te òré ní quexìo nchaa cue tée‑áⁿ nǔú‑gǎ, ");
INSERT INTO milNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","te ní cáxi‑gá úxúú tnàhá cue tée caca cuu ndɨhɨ‑gá, te dɨu‑ni cue tée‑áⁿ tendaha‑gǎ quɨ́hɨ́ⁿ‑güedé cáháⁿ‑güedé tnúhu‑gá núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Te ní sáñaha‑gǎ xii‑güedé tnúhu ndee ìní cundecu ndɨhɨ‑güedé cuèndá cada tátna‑güedé ñáyiu cùhú, ndɨhɨ cuèndá queñuhu‑güedé nchaa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Te duha xǐnani ndɨ ùxúú cue tée‑áⁿ: Ɨɨⁿ‑dé nání‑dě Xǐmú, te mee‑gǎ ní taudɨ̀u ñaha‑gá xii‑dé sá cúnàni‑dé Pèlú. ");
INSERT INTO milNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Te ɨngá‑dé nání‑dě Jàcobó, te ɨngá‑dé nání‑dě Juàá, te ñaní té Jàcobó‑áⁿ cúú tě Juàá te ndɨ ndùú‑güedé cúú‑güedě déhe té Zebèdeú, te ndɨ ndùú cue tée‑áⁿ nǐ dánání ñàha Jesús xii‑güedé Boànergés, te tnúhu‑áⁿ quéé‑xí: Cue tée ío yáchí cúděéⁿ, duha quèe‑xi tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Te duha xǐnani dàva‑gá‑güedé: Té Ndrǐxí, té Lìpé, té Bartolòmé, té Màteú, té Mǎxí, té Jàcobó déhe té Àlfeú, té Tàdeú, té Xǐmú tée ní cundɨhɨ cue tée canànistá ní cùu, ");
INSERT INTO milNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ndɨhɨ té Jùdás Iscàrioté tée ní sáá nduu nǐ sáha cuèndá ñáhá xìi Jesús núú cuè tée cùu úhú iní ñáhá xìi‑gá, duha xǐnani cuè tée ní cáxi Jèsús ní xica cuu ndɨhɨ‑gá. Te sátá dúcáⁿ te cuáháⁿ‑gá ndɨhɨ‑güedé núú quídé vèhe‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Te ío vài ñáyiu ní tacá‑ni tucú‑yu xíáⁿ, te ni ñǎ ní nǐhí‑gǎ nása cada‑gá caxi‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá cuèndá sá ǐo vàí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Te cue ñáyiu cùu ndɨ mee Jesús ní níhǐ‑yu tnúhu nchaa nàcuáa cùu, te nchaa ñáyiu ñá cùtnuní váha iní‑xi ní cachí‑yu sá nǐ nduu lùcú‑gá nǔu xíǎⁿ cuáháⁿ ñáyiu cùu ndɨ mee Jesús núú ndécú‑gǎ cuèndá candeca ñàhá‑yu xii‑gá núhú ní cùu. ");
INSERT INTO milNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Te cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés véxi ndéé ñuú Jerusàlén ní cáháⁿ cuèhé‑güedé cuèndá Jèsús, chi ní xítnàha‑güedé: —Tée‑a ndècu ndɨhɨ‑dé sácuíhná, te dɨu xíǎⁿ chíndèe ñaha‑xi xii‑dé quéñùhu‑dé nchaa espíritú cúndɨ̀hɨ‑xi yɨhɨ ñaha xii ñáyiu, te dɨu‑ni‑xi tàxi tnuní‑xi nchaa espíritú‑áⁿ —duha ní xítnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Te Jèsús ní cana ñaha‑gǎ xii‑güedé, te ní cani‑gá ɨɨⁿ cuèndú núú‑güedě nàcuáa tecú tnùní‑güedé tnúhu‑gá, te xǎhaⁿ‑gǎ xii‑güedé: —¿Te nása cada sácuíhná queñuhu‑xi cue espíritú cúndɨ̀hɨ‑xi yɨhɨ ñaha xii ñáyiu‑i? ");
INSERT INTO milNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Te nchòhó xìní‑ndó sǎ nǔu ɨɨⁿ tée yɨ̀ndaha ɨɨⁿ nacióⁿ vá cúú ɨ̀ɨⁿnuu‑dé ndɨhɨ cue tée cùndɨhɨ‑dé, te vá cúdǐi‑dé cunuu‑dě. ");
INSERT INTO milNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te dɨu‑ni ducaⁿ sǎtnahá‑xi cùu tucu ñáyiu xǐndecu ɨɨⁿ‑ni vèhe, chi núu vá cúú ɨ̀ɨⁿnuú‑yu, te vá cúdǐi‑yu cundecu càhnú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Te núu sácuíhná ñà túú cùu ɨɨⁿnuu‑xi ndɨhɨ cue espíritú cúndɨ̀hɨ‑xi, te vá cúdǐi‑xi cundecu‑xi taxi tnùní‑xi te núu ducaⁿ quìde‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Te nchòhó xìní‑ndó sǎ cuè ñadúhú chi vá ndácú‑güedě cuèndá‑ni quɨ́hu‑güedé duhu‑güedě vehe ɨɨⁿ tée ío ndee, chi díhna‑gá xíní ñùhu‑xi tnɨɨ‑güedé tée‑áⁿ dacùtu ñaha‑güedé xii‑dé dǎtnùní ducaⁿ te ndacu‑güedé duhu‑güedě nchaa sá ndécú ndɨ̀hɨ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Te na càchí tnúhu ndáá‑í xii‑ndo sǎ ncháá sǎ cuèhé sá dúhá quìde ñáyiu, ndɨhɨ nchaa tnúhu cuèhé tnúhu duha càháⁿ‑yu cuèndá Yǎ Ndiǒxí cuu cada càhnu iní‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Dico cue ñáyiu na càháⁿ cuèhé cuèndá Espíritú Yǎ Ndiǒxí, ñáyiu‑áⁿ vǎ cádá càhnu iní ñáhá tnàhí‑gá xií‑yu, chi cundecu‑ni cuéchi‑yu núú‑gǎ nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Te ducaⁿ nǐ cáháⁿ‑gá chi càchí‑güedé sá ndécú ndɨ̀hɨ‑gá espíritú cúndɨ̀hɨ yucu ñávǎha. ");
INSERT INTO milNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Te ní quexìo náná Jèsús ndɨhɨ cue ñaní‑gá núú ndécú‑gǎ xǐnutnɨ́ɨ‑yu quehé, te ní xáhǎⁿ‑yu xii ɨɨⁿ ñáyiu xǐndecu‑áⁿ sǎ dáyǎha‑yu tnúhu núú‑gǎ cuèndá quee‑gá ndatnúhu ndɨhɨ ñaha‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Te cue ñáyiu xǐnucóo nɨ càndéé dɨ̀ñɨ‑gá ní xáhǎⁿ‑yu xii‑gá: —Nǎná‑n ndɨ̀hɨ cue ñaní‑n ndècú‑yu quehé nándùcu ñahá‑yu xii‑n —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Te Jèsús ní xáhaⁿ‑gǎ xií‑yu: —Te cachí tnúhu‑ndo yǒndɨ‑gá ñáyiu cùu datná nǎnà‑í ndɨhɨ dàtná cue ñaní‑í —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Te dǎtnùní ní xíndéhé vǎha‑gá núú nchàa ñáyiu xǐnucóo nɨ càndéé dɨ̀ñɨ‑gá‑áⁿ, te ní xáhaⁿ‑gǎ xií‑yu: —Nchaa ñáyiu‑a cùú‑yu dàtná nǎnà‑í ndɨhɨ dàtná cue ñaní‑í. ");
INSERT INTO milNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chi nchaa ñáyiu quìde nacuáa càháⁿ Yǎ Ndiǒxí, ñáyiu‑áⁿ cúǔ‑yu dàtná cue ñaní‑í, ndɨhɨ dàtná cue cúha‑í, ndɨhɨ dàtná nǎnà‑í —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Te Jèsús ní ngüíta‑gá dácuàha tucu‑gá ñáyiu yuhu làgúná. Te cuéhé víhǐ‑yu ní tacá xíáⁿ nǔu cuásaá‑gá núú ɨɨⁿ bàrcú nútnɨ̌ɨ xɨtɨ́ ndute làgúná‑áⁿ, te núú xǐǎⁿ ní ngóo‑gá te ní ngüíta‑gá dánèhé ñáhá‑gǎ xií‑yu, te nchaá‑yu xǐxúcu‑yu yuhu làgúná‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Te ní ngüíta‑gá ní cani‑gá tɨtnɨ́ cuèndú núǔ‑yu nàcuáa tecú tnùní‑yu tnúhu‑gá, te xǎhaⁿ‑gǎ xií‑yu: ");
INSERT INTO milNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Chí cúndèdóho váha ɨɨⁿ cuèndú ná càni‑í‑a. Ɨɨⁿ tée cuángacáⁿ‑dé trìú. ");
INSERT INTO milNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Te òré ní ngüíta‑dé dǎngoyo‑dé trìú‑áⁿ, te dava ní quene ndava ní ngava ndéé ichi, te ní xiní cue tɨ́laá te ní nadatàcá‑güedɨ. ");
INSERT INTO milNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Te dava ní ngava ñuhu yadi nǔú yɨ́hɨ́ vìhi yúú, te ndɨ̌hɨ‑ni ní xínu‑xi cuèndá sá ñà túú càvihi ñuhu. ");
INSERT INTO milNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dico òré ní nayehé ñá túú ní cùndee iní‑xi chi ní yíchí‑xi, chi ñá túú ní nǐhí quɨ̌hɨ́ⁿ cùnú yóho‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Te dava ní ngava núú yúcú ndɨ̌quɨ́ⁿ tnu ìñu, te ɨɨⁿnuu‑ni nǐ xínu‑xi ndɨhɨ tnu ìñu, te tnu ìñu‑áⁿ nǐ sahnu‑xi te ní dánáá‑xí nchàa triú sá nǐ xínu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Dico dava trìú‑áⁿ nǐ ngava‑xi núú ndécú ñùhu cocoⁿ, te xíǎⁿ ní xínu‑xi te ní sahnu‑xi te ío váha ní cuu, chi núú ɨ́ɨ́ⁿ‑ní trìú‑áⁿ te dava yoco‑xi ní nguɨ́hɨ ócó úxí trìú‑xi, te dava yoco‑xi ní nguɨ́hɨ únídico trìú‑xi, te dava yoco‑xi ní nguɨ́hɨ ɨɨⁿ cièndú trìú‑xi —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Te xǎhaⁿ tùcu‑gá xií‑yu: —Nchaa nchòhó ñáyiu ní xíndedóho nchaa tnúhu ní cáháⁿ‑í‑a, te ío váha chí cuǎha cuèndá —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Te sátá nǐ ndaca ñáyiu‑áⁿ te ní quendóo mee‑nǎ Jèsús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, ndɨhɨ ɨɨⁿ ǔú‑nǎ ñáyiu. Te ñáyiu‑áⁿ ndɨhɨ cue tée‑áⁿ nǐ xícáⁿ tnúhǔ‑yu ndɨhɨ‑güedé núú‑gǎ, núu nása quèe‑xi cuendú ní cani‑gá núǔ‑yu ndɨhɨ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Te ní xáhaⁿ‑gǎ: —Nchòhó chi sa càchí tnúhu Yá Ndiǒxí xii‑ndo ɨ̀ɨⁿ sá vǎtá quìní‑gá‑ndó, chi càchí tnúhu‑gá nàcuáa cada‑gá ndɨ́hu ndaha‑gǎ ñáyiu, dico dava‑gá ñáyiu càni‑í mee‑ni cuèndú núǔ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chi cuěi na quìní‑yu nchaa nàcuáa cuu dico ni vǎ cútnùní iní‑yu ná cuèndá ducaⁿ cùu, àdi cuéi na cùndedóho‑yu dico ni vǎ tècú tnùní‑yu. Te ducaⁿ ndòhó‑yu cuèndá sá vǎ quɨ̀ndáá iní‑yu Yá Ndiǒxí, ndɨhɨ cuèndá sá vǎ cádá càhnu iní‑gá nchaa yícá cuěchi‑yu —càchí‑gá xǎhaⁿ‑gǎ xií‑yu ndɨhɨ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Te ní xáhaⁿ tùcu Jesús xii cue tée xìca cuu ndɨhɨ‑gá, ndɨhɨ cue ñáyiu‑áⁿ: —Nchòhó, ñá túú ní tècú tnùní‑ndó cuèndú ní cani‑í núú‑ndó, te núu ducaⁿ, ¿te nása tecú tnùní‑ndó dàva‑gá cuèndú cani‑í núú‑ndó‑í? Te na càchí tnúhu‑í xii‑ndo nàcuáa quèe‑xi cuendú ní cani‑í núú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Te tée cuángacáⁿ trìú‑áⁿ cúú‑dě dàtná ɨɨⁿ tée cuáháⁿ càháⁿ tnúhu Yá Ndiǒxí núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Te trìú‑áⁿ cúú‑xí dàtná tnúhu Yá Ndiǒxí, te trìú sá nǐ quene ndava ní ngava ndéé ichi, xíǎⁿ cúú‑xí dàtná ñáyiu ní tnahá iní‑xi tnúhu Yá Ndiǒxí, dico sácuíhná cuǎháⁿ‑xi xòcani‑xi tnúhu‑gá iní‑yu cuèndá sá vǎ cánchǐcúⁿ nihnú‑yu nàcuáa càháⁿ tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Te trìú sá nǐ ngava ñuhu yadi nǔú yɨ́hɨ́ vìhi yúú, xíǎⁿ cúú‑xí dàtná ñáyiu ní xíndedóho tnúhu Yá Ndiǒxí te dɨ́ɨ́ ìní ní tnɨɨ́‑yu tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Dico òré ná ngüǐta ñáyiu cúcuèhé ñáhǎ‑yu xií‑yu àdi nándɨ‑gá sá yǎha‑yu sá cuèndá tnúhu‑gá, te ñá cúndèe iní‑yu chi dàñá‑yu tnúhu‑gá cuèndá sá ñà túú nìhí ndéě‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Te trìú sá nǐ ngava núú yúcú ndɨ̌quɨ́ⁿ tnu ìñu xíǎⁿ cúú‑xí dàtná ñáyiu ní tecú dóho‑xi tnúhu Yá Ndiǒxí, ");
INSERT INTO milNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","dico cuèé cuèé ní nacuanaá‑yu tnúhu‑gá, chi cuèndá mee‑ni sǎ cúú‑xí mèé‑yu ñùhu iní‑yu, ndɨhɨ cuèndá sá ǐo sàni iní‑yu cuu cuìcá‑yu, ndɨhɨ cuèndá sá ǐo cùdɨ́ɨ́ ìní‑yu nchaa sá ìó ñuyíú‑a, te ñá túú ñùhu iní‑yu tnúhu sá nǐ xíndedóho‑yu‑áⁿ nàcuáa cada váha‑yu cundecú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dico trìú sá nǐ ngava núú ndécú ñùhu cocoⁿ, xíǎⁿ cúú‑xí dàtná ñáyiu ní xíndedóho tnúhu Yá Ndiǒxí te quìdé‑yu nchaa nàcuáa càháⁿ tnúhu‑áⁿ. Te cada iní‑ndó sǎ ñǎyiu‑áⁿ cúǔ‑yu dàtná trìú sá nǐ nguɨ́hɨ yoco‑xi ócó úxí trìú‑xi, ndɨhɨ trìú sá nǐ nguɨ́hɨ yoco‑xi únídico trìú‑xi, ndɨhɨ trìú sá nǐ nguɨ́hɨ yoco‑xi ɨɨⁿ cièndú trìú‑xi. Te ducaⁿ sǎtnahá‑xi cùú‑yu chi ío váha quìdé‑yu —càchí‑gá xǎhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá ndɨhɨ cue ñáyiu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Te xǎhaⁿ‑gǎ xii nchaa ñáyiu: —Ñá túú nì ɨɨⁿ ñáyiu tèñuhú itɨ te chiváha‑yu ɨɨⁿ xɨtɨ́ quɨ́dɨ, àdi chiváha‑yu ɨɨⁿ caha càmá, chi tàxi ndecú‑yu ɨɨⁿ núú dùcúⁿ cuèndá cutnùní núú nchàa ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Te ni ɨ̀ɨⁿ tnúhu sá ñǎ tècú tnùní ñáyiu vitna cachí‑ó sǎ vǎ tècú tnùní‑yu chi dacuɨtɨ́í sǎ tècú tnùní‑yu, te ni ɨ̀ɨⁿ tnúhu sá càchí‑ó cùu yuhu vitna vá cúú yùhu chi dacuɨtɨ́í sǎ quéé tǔu‑xi núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Te nchòhó cue ñáyiu ní xíndedóho nchaa tnúhu ní cáháⁿ‑í‑a, te ío váha chí ná cuǎha cuèndá —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Te ní xáhaⁿ tùcu‑gá: —Ío váha chí cúndèdóho tnúhu na càháⁿ‑í‑a. Te nàcuáa‑ni quìde‑ndo danehé‑ndó ñǎyiu tnúhu Yá Ndiǒxí, te dɨu‑ni ducaⁿ càda ñaha‑gá xii‑ndo, te uuⁿ‑gá ducaⁿ càda‑gá sá cúú‑xí‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Te nchaa nchòhó ñáyiu tècú tnùní tnúhu Yá Ndiǒxí, uuⁿ‑gá cuita tecú tnùní‑ndó tnǔhu‑gá quɨ́hɨ́ⁿ. Te nchaa nchòhó ñáyiu ñá túú tècú tnùní tnúhu‑gá, te uuⁿ‑gá vá tècú tnùní‑ndó —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Te Jèsús xǎhaⁿ tùcu‑gá: —Na càni‑í ɨɨⁿ cuèndú núú‑ndó cuèndá tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. Ɨɨⁿ tée cuángacáⁿ‑dé trìú. ");
INSERT INTO milNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","28","Te sátá nǐ yáha ní sacáⁿ‑dé trìú‑áⁿ, te cuánuhú‑dé vehe‑dé ndétàtú‑dé. Te ducaⁿ‑ni ta xìca nduu cuáháⁿ te ní xínu trìú‑áⁿ, te nàcuáa ta sàhnu‑xi cuáháⁿ te ta quèe ndaha‑xi, te ducaⁿ‑ni cùu ní sáá nduu nǐ quene yoco‑xi te ní nguɨ́hɨ trìú‑xi, dico tée ní sacáⁿ trìú‑áⁿ ñà túú xìní‑dé nása ní sahnu‑xi, chi mee ñùhu ní quide‑xi ní sahnu trìú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te òré sa ní ndɨhɨ ní cuaaⁿ te ní ngüíta tée ní sacáⁿ‑áⁿ náquèhndé‑dé nátàxi tnaha‑dé —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Te xǎhaⁿ tùcu Jesús xií‑yu: —Na càni tucu‑í ɨngá cuèndú núú‑ndó cuèndá tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ɨɨⁿ yutnu nàni mostázá cúú‑xí ɨ̀ɨⁿ yutnu sá lǐhli vìhi‑gá ndɨ́quɨ́ⁿ‑xi dàcúúxí ndɨ̌quɨ́ⁿ nchaa cúhú, ");
INSERT INTO milNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","dico òré ná càcáⁿ‑güedé núú ñúhú‑güedě, te na xǐnu‑xi te sàhnu‑gá‑xi dàcúúxí nchàa cúhú, te nchaa dité‑xi ío cùu cahnu‑xi, te ndéé cue quɨtɨ ndàva núú tàchí sácǒo‑güedɨ nchaa núú dìté‑xi xìnu ndetɨ‑güedɨ —cachí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Te ío‑gá vài cuendú ní cani Jèsús núú ñǎyiu cuèndá tecú tnùní‑yu tnúhu Yá Ndiǒxí, dico dava cuèndú ñá túú ní càni‑gá núǔ‑yu, chi ní cutnùní iní‑gá sá vǎ tècú tnùní‑yu nchaa. ");
INSERT INTO milNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Te mee‑ni cuèndú ní cani Jèsús núú ñǎyiu ndɨ tnahá òré ní dánèhé ñáhá‑gǎ xií‑yu tnúhu‑gá. Te òré ndécú mèe Jesús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te ní xáhaⁿ‑gǎ xii‑güedé nàcuáa quèe‑xi ɨɨⁿ ɨɨⁿ cuendú ní cani‑gá núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Te dɨu‑ni nduu‑ǎⁿ òré sa ta cùndɨquɨⁿ cuáháⁿ ní xáhaⁿ Jèsús xii cue tée xìca cuu ndɨhɨ‑gá: —Chí ná quɨ̀hɨ́ⁿ‑ó ndàa ɨngá xio yuhu làgúná —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Te ní quide ndee ìní‑gá nchaa ñáyiu xǐxúcu‑áⁿ, te dɨu‑ni bàrcú sá ñúhú‑gǎ òré ní dánèhé‑gá ñáyiu tnúhu‑gá dɨu‑ni xíǎⁿ ní dácácá cuè tée xìca cuu ndɨhɨ‑gá ndécá ñàha‑güedé xii‑gá cuáháⁿ, te tnàhá ɨɨⁿ ǔú‑gá bàrcú ní xica‑xi nchìcúⁿ‑xi bàrcú ñúhú‑gǎ‑áⁿ cuǎháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Te ñùhu barcú ñúhú‑gǎ‑áⁿ ichi cuáháⁿ‑xi núú ndute, te ní quexìo ɨɨⁿ táchí nǐhi, te ta nàdachitú‑xi ndute xɨtɨ́ bàrcú‑áⁿ cuǎháⁿ, te sa cuìní‑nǎ‑xi quée naa bàrcú‑áⁿ xɨtɨ́ ndute ni cùu. ");
INSERT INTO milNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Te Jèsús cáá‑gǎ xìdí‑gá ɨɨⁿ xichi ndàa sátá bàrcú‑áⁿ, te yɨ̀nchihi ɨɨⁿ dóó dɨ̌quɨ́‑gǎ. Te sá dúcáⁿ cuìní‑xi quée naa bàrcú‑áⁿ nǔu ní sáháⁿ‑güedé ní ndocani ñaha‑güedě xii‑gá, te xǎhaⁿ‑güedě: —¡Mèstrú, ndɨquɨ́ú ìní! ¿Náa ñá túú ndɨ̀hú iní‑n sǎ tá quěe naa‑o cuǎháⁿ‑ǎⁿ? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Te Jèsús ní ndɨquɨ́ú ìní‑gá te ní ndacóo‑gá, te ní tenàá‑gá táchí‑ǎⁿ, te ní xáhaⁿ‑gǎ xii ndute làgúná: —¡Tnavíí‑nǎ cuhuⁿ, chi ío dusaⁿ! —càchí‑gá xǎhaⁿ‑gǎ xii ndute‑áⁿ. Te òré‑ni ní ngüɨ́ñɨ́ táchí‑ǎⁿ te ní nucúndecu nahi‑nǎ ndute làgúná‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —¿Ná cuèndá ndéé dúcáⁿ yùhú‑ndó‑í? ¿Náa ñá túú sàndáá iní ñáhá ndìsa‑ndo xii‑í‑ǎⁿ? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dico mee‑güedě chi ío ní yùhú‑güedé sá ducaⁿ nǐ quide‑gá ní xiní‑güedé, te ní xítnàha‑güedé: —¿Te ná tée cùu tée‑a núu ní cáháⁿ‑ni‑dé, te ní ngüɨ́ñɨ́ táchí te ní nucúndecu nahi ndùte lagúná‑a‑i? —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Te ní sáá Jèsús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ndàa ɨngá xio yuhu làgúná yucu cue tée ñuú Gàdará. ");
INSERT INTO milNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Te òré ní quene‑gá xɨtɨ́ bàrcú te ɨɨⁿ tée yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha ní quee‑dé núú yɨ́ndǔxi ndɨ́yɨ cuáháⁿ‑dé núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Te mee‑ni nǔú yɨ́ndǔxi ndɨ́yɨ‑áⁿ quídé vèhe‑dé, te cuěi dàcutu ñaha‑güedé cadèná xii‑dé dico ñá túú tnàhí ndàcu‑güedé núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Te ío tɨtnɨ́ xito ní dácútú‑güedě cadèná sáhá‑dě ndɨhɨ ndaha‑dé dico ní dándává‑ni‑dě, te ní xóo dacàchi‑gá‑dé nchaa cadèná‑áⁿ, te ñá túú tnàhí ni ndàcu‑güedé núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Te cuěi nduu cuěi niú ní xóo cana saa‑dé, te váha‑ni núu xɨtɨ́ yucu ndècu‑dé àdi núú yɨ́ndǔxi ndɨ́yɨ dico càna saa nahi‑ni‑dé, te ío ní xóo dànícuèhé‑dé méé‑dě ndɨhɨ yúú. ");
INSERT INTO milNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Te òré ní xiní‑dé Jèsús te xìnu‑dé ní sáháⁿ núú‑gǎ, te ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě, ");
INSERT INTO milNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","te espíritú yɨ́hɨ́ ñàha xii‑dé‑áⁿ nǐ quide‑xi níhi ní cáháⁿ‑dé, te xǎhaⁿ‑dě xii‑gá: —¿Ná cuèndá véxi yòhó Jèsús Déhe Dútú Ndiǒxí sàdɨ́‑n ìchi‑í? Te càháⁿ ndàhú‑í núú Ndiǒxí yuhu nǔú‑n sǎ vǎ dándòho ñaha‑n xii‑í —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Te ducaⁿ nǐ cáháⁿ‑dé cuèndá sá Jèsús ní xáhaⁿ‑gǎ xii espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii‑dé‑áⁿ sǎ quéé ñàha‑xi xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Te Jèsús ní xícáⁿ tnúhú‑gǎ núú‑dě, te xǎhaⁿ‑gǎ: —¿Nása nàni‑n‑i? —cachí‑gá xǎhaⁿ‑gǎ xii‑dé. Te ní xáhaⁿ‑dě: —Vài Sandadú, duha nàni‑í chi ío cuéhé‑ndɨ̌ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Te cue espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ nǐ cáháⁿ ndàhú‑xi núú Jèsús sá vǎ téndàha ñaha‑gá xii‑xi quɨ́hɨ́ⁿ‑xi ɨngá xichi. ");
INSERT INTO milNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Te dɨu‑ni yatni yucu núú ndécú Jèsús‑áⁿ yɨ́hɨ́ vài cuchí xǐxexi‑güedɨ. ");
INSERT INTO milNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Te nchaa cue espíritú‑áⁿ nǐ cáháⁿ ndàhú‑xi núú‑gǎ, te xǎhaⁿ‑xi xìi‑gá: —Càháⁿ ndàhú‑ndɨ́ núú‑n sǎ dáñá‑n quɨ̌hu‑ndɨ́ yɨquɨ cùñú nchaa cùchí‑ǎⁿ —càchí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Te Jèsús ní xáhaⁿ‑gǎ sá cúú quɨ̌hu‑xi yɨquɨ cùñú‑güedɨ, te xǐnu dàtná úú mǐl‑güedɨ yɨ̀hɨ yucu‑áⁿ. Te nchaa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii tée‑áⁿ nǐ quee ñaha‑xi xìi‑dé, te cuánguɨhu‑xi yɨquɨ cùñú nchaa cùchí‑áⁿ, te nchaa‑güedɨ ní xinu‑güedɨ duha ní quée‑güedɨ ndàa núú dèhvá yuhu làgúná‑áⁿ, te ní ngaunihnu‑güedɨ xɨtɨ́ ndute te ní ndɨhɨ‑güedɨ ní cáhá. ");
INSERT INTO milNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Te òré ní xiní cue tée xìto cuchí‑áⁿ nàcuáa ní cuu te ní xinu‑güedé, te ní sáháⁿ‑güedé ní cani‑güedé cuèndú núú cuè ñáyiu ndècu xɨtɨ́ ñuú, ndɨhɨ núú cuè ñáyiu ndècu xɨtɨ́ yucu. Te nchaa ñáyiu ní níhí tnǔhu ní xicá‑yu cuáháⁿ ndéhě‑yu nàcuáa ní cuu. ");
INSERT INTO milNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Te òré ní quexìó‑yu núú ndécú Jèsús te ní xiní‑yu tée ní xɨ́hɨ ñaha cuè espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ núcǒo‑dé núú sàhá Jèsús, te nìhnu‑ná‑dé dóó‑dě te nùcóo‑ná‑dé dàtná ɨɨⁿ ñáyiu váha, te ní yùhú‑yu òré ní xiní ñáhǎ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Te nchaa ñáyiu ní xiní nàcuáa ní cuu ní ndúha tée yɨ̀hɨ ñaha cue espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ ní cùu ní caní‑yu cuèndú núú nchàa ñáyiu ní quexìo‑áⁿ nàcuáa ní cuu ní ndúha tée‑áⁿ ndɨhɨ nàcuáa ní cuu cuèndá nchaa cùchí‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Te sá dúcáⁿ ni nǐhí ñǎyiu‑áⁿ tnǔhu nàcuáa ní cuu núu nchaá‑yu ní ngüíta‑yu càháⁿ ndàhú‑yu núú Jèsús sá ná quèe‑gá yucu ñuú‑yu núhú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Te ní xica‑gá cuáháⁿ‑gá núú ndécú bàrcú, te òré ndée‑gá bàrcú‑áⁿ nǔhú‑gá ní ngüíta tée ní xɨ́hɨ ñaha cuè espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ càháⁿ ndàhú‑dé núú‑gǎ nǔu vá cúndèe iní‑gá quɨ́hɨ́ⁿ ndɨhɨ ñaha‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Dico ñá túú ní sǎha‑gá tnúhu quɨ́hɨ́ⁿ ndɨhɨ ñaha‑gǎ xii‑dé, te ní xáhaⁿ‑gǎ xii‑dé: —Cuanùhú vehe‑n, te cani‑n cuèndú núú cuè ñáyiu sá Yǎ Ndiǒxí ní cundàhú iní ñáhá‑gǎ xii‑n, te ío càhnu cuu nchaa sá vǎha ní quide‑gá sá cúú‑xí‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Te tée‑áⁿ nǐ xica‑dé cuánuhú‑dé, te ní sáháⁿ‑dé ndɨ ùxí ñuú nání Dècápolís, te ní cani‑dé cuèndú núú nchàa ñáyiu sá ǐo càhnu cuu nchaa sá vǎha ní quide ñaha Jèsús xii‑dé, te nchaá‑yu ío ní cuñúhu‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Te Jèsús cuándee‑gá bàrcú, te ní natehndé‑gá ndàa ɨngá xio yuhu làgúná, te ío vài ñáyiu ní tacá núú nǐ quexìo‑gá‑áⁿ, te xíáⁿ ndécú‑gǎ ");
INSERT INTO milNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ní quexìo ɨɨⁿ tée tàxi tnuní veñúhu núú‑gǎ, te tée‑áⁿ nání‑dě Jàirú, te ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Te ní ngüíta‑dé càháⁿ ndàhú‑dé núú‑gǎ, te xǎhaⁿ‑dě xii‑gá: —Ío càhú tnàhá déhe yoco‑ǐ cùhú‑xi, te ndècu‑ná‑xi sá cùú‑xi, te véxi‑í càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n quɨ̌hɨ́ⁿ‑ó vèhe‑í tendaha‑n‑xi cuèndá ndúha‑xi, te cundecu‑xi —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Te Jèsús ní xica‑gá cuáháⁿ‑gá ndɨhɨ tée‑áⁿ, te ío vài ñáyiu nchìcúⁿ ñáhá xìi‑gá cuáháⁿ, te dàdehnde ñaha‑ná‑yu xii‑gá ni cùu. ");
INSERT INTO milNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Te tnuú nchaa ñáyiu‑áⁿ ñútnàhá ɨɨⁿ ñaha cùhú, te ñaha‑áⁿ sa ní cuu úxúú cuíá sǎ cùhú‑aⁿ ngòyo ñaha nɨ́ñɨ́ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Te ío ta ndòho‑aⁿ véxi, te ío cuéhé ñǎtátná nǐ cuu ta quìde tátna ñaha xìi‑aⁿ, te sa ní ndɨhɨ nchaa sá ndécú ndɨ̀hɨ‑aⁿ ní nadico‑aⁿ cuèndá ní níhí‑aⁿ díhúⁿ nǐ queheⁿ nchaa ñáyiu ní quide tátna ñaha xìi‑aⁿ dico ni ɨ̀ɨ́ⁿ‑yu ñá túú ní ndàcú‑yu ndúha‑aⁿ, chi da uuⁿ‑gá tá cùu cahú‑aⁿ cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Te òré ní níhí‑aⁿ tnúhu cuèndá Jèsús, te ní xica‑aⁿ cuáháⁿ‑aⁿ núú ndécú‑gǎ. Te òré ní quexìo‑aⁿ núú ndécú‑gǎ te ní sáháⁿ ndehe yatni‑aⁿ ndàa sátá‑gǎ ní tnándeé‑aⁿ dóó‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Te ducaⁿ nǐ quide‑aⁿ chi ní sani iní‑aⁿ sá nǔu ndacu‑aⁿ tnándeé‑aⁿ cuědìcó luha yuhu dǒó Jèsús te ndúha‑aⁿ ní sani iní‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Te òré ducaⁿ nǐ quide‑aⁿ te ñá túú‑gǎ ní ngòyo ñaha‑gá nɨ́ñɨ́ xii‑aⁿ, te òré‑áⁿ nǐ cutnùní iní‑aⁿ sá nǐ ndúha‑aⁿ cuéhé tnàhá‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Te Jèsús ní cutnùní iní‑gá sá ɨ̀ɨⁿ ñáyiu ní ndúha sá cuèndá‑gá, núu ní nchócótó‑gǎ ndàa sátá‑gǎ te ní xícáⁿ tnúhú‑gǎ núú nchàa ñáyiu nchìcúⁿ ñáhá xìi‑gá, te xǎhaⁿ‑gǎ xií‑yu: —¿Ndědacàa‑ndo ní tnándeé ñáhá xìi‑í? —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Te cue tée xìca cuu ndɨhɨ‑gá ní xáhaⁿ‑güedě xii‑gá: —Mèstrú, ndèhe‑n sá váí ñǎyiu nchìcúⁿ ñáhá xìi‑n, te texio texio dàdehnde ñahá‑yu xii‑n te xìcáⁿ tnúhú‑gǎ‑n yòo ní tnándeé ñáhá xìi‑n —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Te Jèsús ní xíndéhé vǎha‑gá xio xio dɨ̀ñɨ‑gá nǔu ndědacàa ñáyiu ní tnándeé ñáhá xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Te sá dúcáⁿ nǐ cutnùní iní ñadɨ̀hɨ́‑áⁿ nàcuáa ní cuu, núu yùhú yùhú‑aⁿ ní sáháⁿ‑aⁿ ní ngüɨ́ñɨ́ xɨ́tɨ́‑áⁿ nǔú Jèsús, te ní xáhaⁿ ndǎá‑aⁿ xii‑gá nàcuáa ndùu cuendá‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Te Jèsús ní xáhaⁿ‑gǎ xii‑aⁿ: —Yòhó ñaha cùhú ní cùu, ní sándáá iní ñáhá‑n xìi‑í, núu ní ndúha‑n, te vitna cuanùhú te vá ndɨ̀hú‑gá iní‑n, chi vá dúcáⁿ‑gǎ ndoho‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Te càháⁿ dúcáⁿ‑ní Jèsús ní sáá cue tée xìnu cuechi vehe té Jàirú tée tàxi tnuní veñúhu‑áⁿ, te xǎhaⁿ‑güedě xii‑dé: —Sa ní xíhí déhe‑n, vá chíchìuⁿ‑gá‑n Mèstrú —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dico Jèsús ñá túú ní quìde cuendá‑gá nàcuáa ndùu tnúhu ní cáháⁿ cue tée‑áⁿ, te ní xáhaⁿ‑gǎ xii tée tàxi tnuní veñúhu‑áⁿ: —Ñá túú nǎ cani iní‑n, quɨndáá iní ñáhá‑ní‑n xìi‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Te Jèsús vá yǒo‑gá ní cuìní‑gá canchicúⁿ ñáhá xìi‑gá quɨ́hɨ́ⁿ, chi té Pèlú‑ni, ndɨhɨ té Jàcobó‑ni, ndɨhɨ ñaní‑ni‑dé té Juàá cuáháⁿ ndɨhɨ ñaha‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Te òré ní quexìo‑gá ndɨhɨ‑güedé vehe tée tàxi tnuní veñúhu‑áⁿ, te ní xiní‑gá sá ǐo vài ñáyiu xǐndecu, te súúní dùsaⁿ quidé‑yu te níhi xǐcáháⁿ‑yu te xǐndáhí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Te òré cuánguɨhu‑gá xɨtɨ́ vehe, te ní xáhaⁿ‑gǎ xií‑yu: —¿Ná cuèndá ndéé dúcáⁿ ǐo dusaⁿ quìde‑ndo, te ndàhyú‑ndó? Te xíchí‑a ñá túú ní xǐhí‑xi chi dìcó xìdí‑xi —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Te ní sácú ndeé ñáhǎ‑yu xii‑gá sá dúcáⁿ nǐ cáháⁿ‑gá, chi sá cúú‑xí mèé‑yu chi ní xíhí ndisa xíchí‑ǎⁿ. Te òré‑áⁿ nǐ queñuhu‑gá nchaá‑yu quehé, te cuánguɨhu‑gá núú cándòdo yɨquɨ cuñú xíchí nǐ xíhí‑áⁿ. Te ndèca‑gá tǎtá xǐchí nǐ xíhí‑áⁿ ndɨhɨ nǎná‑xi cuánguɨhu, te tnàhá cue tée úní ndɨhɨ‑gá‑áⁿ cuǎnguɨhu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Te ní tnɨɨ‑gá ndaha xíchí nǐ xíhí‑áⁿ, te ní xáhaⁿ‑gǎ: —Tàlíta, cúmí —càchí‑gá xǎhaⁿ‑gǎ. Te tnúhu‑áⁿ quéé‑xí: Yòhó xíchí cuéchí yúhú càchí‑í sá ndácǒo‑n, duha quèe‑xi tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Te òré‑ni‑áⁿ nǐ ndoto xíchí cuéchí‑ǎⁿ nǐ ndacóo‑xi ní nacaca cuu‑xi, te ndècu‑xi úxúú cuíá‑xi. Te ío ní cuñúhu nchaa ñáyiu sá dúcáⁿ nǐ dándótó ñàha Jesús xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Te Jèsús ní cáháⁿ víhí‑gǎ dóho tǎtá‑xi ndɨhɨ nǎná‑xi sá vǎ yǒo ɨɨⁿ cúñàhá‑yu sá nǐ dándótó ñàha‑gá xii‑xi. Te sátá dúcáⁿ te ní xáhaⁿ‑gǎ xií‑yu sá cuǎñàhá‑yu xii‑xi sá cáxí‑xí. ");
INSERT INTO milNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Te Jèsús ní ndee‑gá ñuú núú nǐ dándótó‑gǎ xíchí nǐ xíhí‑áⁿ, te cuánuhú‑gá núú cúú ñùú‑gá, te tnàhá cue tée xìca cuu ndɨhɨ‑gá cuánuhú ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Te ndècu Jesús ñuú‑gá ní tnahá nduu ndètatú ñáyiu. Te nduu‑ǎⁿ cuǎnguɨhu‑gá xɨtɨ́ veñúhu dàcuaha ñaha‑gá xií‑yu. Te vài ñáyiu ndèdóho nchaa tnúhu càháⁿ‑gá, te xǐcuñúhu vìhí‑yu, te xǐtnàhá‑yu: —¿Ndèé ní sáháⁿ dácuáhá těe‑a núu ndéé duha váha càháⁿ‑dé, nása ní quide‑dé nǔu ndéé duha ío váha cùtnuní iní‑dé, te ndàcu‑dé quídé‑dě nchaa sá vǎ yǒo tnàhí ndàcu cada‑i? ");
INSERT INTO milNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Te dìcó carpintèrú cúú‑dě, dìcó déhe tá Màriá cúú‑dě, te ñaní‑dé cúú tě Jàcobó, ndɨhɨ té Chèé, ndɨhɨ té Jùdás, ndɨhɨ té Xǐmú, te dɨu‑ni cue cúha‑dé cúú ñǎyiu ndècu ndɨhɨ‑o ñuú‑a —càchí‑yu xǐtnàhá‑yu. Te ñá túú ní cuìní‑gá‑yu cáháⁿ ndɨhɨ váha ñàhá‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Te Jèsús ní xáhaⁿ‑gǎ xií‑yu: —Te núu ɨɨⁿ tée càháⁿ tnúhu Yá Ndiǒxí ná nàsáá‑dé ñuú‑dé dacuàha‑dé ñáyiu tnúhu‑gá, te nchaa ñáyiu ñuú‑dé‑áⁿ, ndɨhɨ nchaa ñáyiu ndècu ndɨhɨ‑dé vehe‑dé, ndɨhɨ nchaa ñáyiu cùu ndɨ mee‑dé ñá túú nèhé‑yu sá yɨ́ñùhu núú‑dě, dico cue ñáyiu nchaa dava‑gá ñuú chi nèhé‑yu sá yɨ́ñùhu núú‑dě —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Te ñá túú ní quìde tátna Jèsús vài ñáyiu cuèndá sá ñà túú ní sàndáá iní ñáhǎ‑yu xii‑gá, dico ní quide tátna‑gá ɨɨⁿ ǔú ñáyiu cùhú ní sándáá iní ñáhá xìi‑gá. Te ní tendaha ñàha‑ni‑gá xií‑yu te ní ndúha‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Te ío ní cuñúhu‑gá sá dúcáⁿ ñà túú ní cuìní‑yu quɨndáá iní ñáhǎ‑yu xii‑gá. Te sátá dúcáⁿ te ní xica‑gá cuáháⁿ‑gá nchaa dava‑gá ñuú lǐhli càa yatni xíáⁿ cuèndá dacuàha‑gá ñáyiu tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Te Jèsús ní cana‑gá ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá, te ní sáñaha‑gǎ xii‑güedé tnúhu ndee ìní cundecu ndɨhɨ‑güedé cuèndá queñuhu‑güedé nchaa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu. Te ní xáhaⁿ‑gǎ xii‑güedé sá ndɨ̀ ndúú ndɨ ndúú‑güedě quɨ́hɨ́ⁿ‑güedé cáháⁿ‑güedé tnúhu Yá Ndiǒxí núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Te cùmání‑gǎ caca‑güedé quɨ́hɨ́ⁿ‑güedé, te ni xáhaⁿ‑gǎ xii‑güedé: —Vá cánèhe‑ndo ñunu cuhuⁿ ndachiuⁿ‑ndo, te ni vǎ cánèhe‑ndo sá cáxí‑ndó, te ni vǎ cánèhe‑ndo díhúⁿ, chi ɨɨⁿ caa‑ni tàtnu canehe‑ndo, te chàú yɨ́hɨ́‑ní‑ndó‑ǎⁿ xíǎⁿ‑ni quɨhɨ‑ndo, te vá cánèhe‑gá‑ndó ɨ̀ngá ichi dóó‑ndó chi dɨu‑ni dóó níhnú‑ndó‑ǎⁿ xíǎⁿ tnàhí‑ni cuihnu‑ndo te ñá túú tnàhí‑gá ná canehe‑ndo —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Te xǎhaⁿ tùcu‑gá: —Te òré ná sàá‑ndó ɨ̀ɨⁿ ñuú, te ìó ñáyiu cáháⁿ ñáhǎ‑yu xii‑ndo vèhé‑yu, te xíáⁿ‑ni cundecu‑ndo ndèé ná sàá nduu ndèe‑ndo ñuú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te núu ìó dava ñuú ñá túú cuìní‑yu cáháⁿ ndɨhɨ ñaha vǎha‑yu xii‑ndo, te ni ñà túú cuìní‑yu cundedóho‑yu tnúhu càháⁿ‑ndó, te ndee‑ni‑ndo ñùú‑áⁿ te naquɨdɨ‑ndo tɨ̀cáchúhmá nǐ tnɨ́ɨ sáhá‑ndó cuèndá ná cùtnuní iní‑yu sá ñà túú quìde váha‑yu. Te na càchí tnúhu ndáá‑í xii‑ndo sǎ ná sàá nduu càda ndáá Yǎ Ndiǒxí cuéchi nchaa ñáyiu, te cue ñáyiu ducaⁿ na càda ñaha xii‑ndo‑áⁿ ǐo‑gá ndohó‑yu dàvá‑áⁿ dàcúúxí dàtná ndoho cue ñáyiu ñuú Sòdomá ndɨhɨ cue ñáyiu ñuú Gòmorrá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Te cue tée‑áⁿ nǐ xica‑güedé cuáháⁿ‑güedé te ní ngüíta‑güedé dácuàha‑güedé cue ñáyiu tnúhu Yá Ndiǒxí, te xǎhaⁿ‑güedě xií‑yu: —Chí dándìxi túu iní sá ñà túú quìde váha‑ndo ndècu‑ndo, te daña‑ndo nchàa ichi cuehé ichi duha ndècu‑ndo. —càchí‑güedé xǎhaⁿ‑güedě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Te vài espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu ta quèñuhu‑güedé yɨquɨ cùñú‑yu cuáháⁿ, te vài tucu ñáyiu cùhú tá quìde tátna‑güedé cuáháⁿ chíhí ñàha‑güedé acìtí xií‑yu te ndǔha‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Te nchaa xichi ní níhí ñǎyiu tnúhu nchaa nàcuáa quìde Jesús, te tnàhá té Hèrodés tée yɨ̀ndaha ñaha xii ñáyiu ní níhí‑dě tnúhu nchaa nàcuáa quìde‑gá, te ní cachí‑dé: —Té Juàá tée ní xóo dacuàndute ñaha xii ñáyiu ní ndoto núu dàcáⁿ ndácú‑dě quídé‑dě nchaa sá vǎ yǒo tnàhí ndàcu cada —duha ní cachí‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Te dava ñáyiu càchí‑yu sá tě Èliás tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha ní nasáá‑dé. Te davá‑yu càchí‑yu sá cúú‑gǎ dàtná ɨɨⁿ tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha. ");
INSERT INTO milNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Te té Hèrodés ní níhí‑dě tnúhu nchaa nàcuáa càháⁿ‑yu, te ní cachí‑dé: —Dɨu té Juàá tée ní táúchíùⁿ‑í ní xehndé‑güedé dɨ́quɨ́‑xi ní ndoto —càchí‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Te duha ní cuu cútnàhá ní sahni té Hèrodés té Juàá, chi dàvá‑áⁿ nǐ naqueheⁿ té Hèrodés‑áⁿ ɨɨⁿ ñaha nàni Herodiás ndécá‑dě, te ñaha‑áⁿ sà ní cándeca ñaha ñàní‑dé té Lìpé. Te té Juàá ní xáhaⁿ‑dě xii té Hèrodés sá ñà túú ní quìde váha‑dé sá dúcáⁿ nǐ naqueheⁿ‑dé ñaha ní cándeca ñaní‑dé, núu sá cuèndá ñaha‑áⁿ nǐ táúchíúⁿ tě Hèrodés ní tnɨɨ‑güedé té Juàá ní chihi ñaha‑güedě vecaá, te ní dácútú ñàha‑güedé xii‑dé, te ducaⁿ nǐ quide‑dé cuèndá sá ndécá ñàha‑dé xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Te ñaha nàni Herodiás ndécá tě Hèrodés‑áⁿ ǐo ní cuu úhú iní‑aⁿ té Juàá, te ní cuiní‑aⁿ cahni‑aⁿ‑dé, dico ñá túú ní nǐhí‑aⁿ nàcuáa cada‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Te mee tě Hèrodés chi ní cutnùní ndáá iní‑dé sá tě Juàá cúú‑dě ɨɨⁿ tée quìde mee‑ni sá vǎha, te quìde ndáá‑dé núú Yǎ Ndiǒxí, te ní xóo yùhú ñáhá‑dě nǔu xíǎⁿ ñá túú ní dàña‑dé ná cada ñaha ñàha ndeca‑dé‑áⁿ xii té Juàá. Te té Hèrodés‑áⁿ ǐo ní cudɨ́ɨ́ ìní‑dé ní xíndedóho‑dé nchaa tnúhu ní xáhaⁿ tě Juàá xii‑dé, dico ñá túú ní sàni iní‑dé duuⁿ duuⁿ tnɨɨ‑dé tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Te ɨɨⁿ nduu ní xóo vico vehe té Hèrodés ní quide càhnu‑dé nduu nǐ cacu‑dé. Te nduu‑ǎⁿ nǐ níhí ñaha nàni Herodiás‑áⁿ nàcuáa cada‑aⁿ cuèndá cuú té Juàá. Te nduu‑ǎⁿ ní cáháⁿ té Hèrodés nchaa cue tée cùchiuⁿ, ndɨhɨ nchaa cue tée tàxi tnuní ñáhá xìi cue sandadú, ndɨhɨ nchaa cue tée cuica ndècu distritú Galìleá cuèndá cudìni ndɨhɨ ñaha‑dé xii‑güedé nduu‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Te ndècu ɨɨⁿ déhe yoco ñàha nani Herodiás‑áⁿ, te xíchí‑ǎⁿ nǐ quɨ́hu‑xi vehe núú cúú vìco‑áⁿ nǐ xita saha‑xi mèi oré yɨ́hɨ́ tě Hèrodés mèsá ndɨhɨ nchaa cue tée ní cáháⁿ‑dé, te ío ní cudɨ́ɨ́ ìní‑dé ndɨhɨ nchaa cue tée‑áⁿ nàcuáa ní xita xíchí‑ǎⁿ. Te té Hèrodés ní xáhaⁿ‑dě xii‑xi: —Cácáⁿ núù‑í nǔu ná cuìní‑n te taxi‑í —càchí‑dé xǎhaⁿ‑dě xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Te ní cacunehe‑dé ndéé Yǎ Ndiǒxí nàcuáa cutnùní iní xíchí‑ǎⁿ sǎ ndàá cuáñaha‑dě nǔu ná cúú sǎ ná càcáⁿ‑xi núú‑dě cuěi ndéé cuádava nchaa sá ndécú ndɨ̀hɨ‑dé, te núu na càcáⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Te sá dúcáⁿ nǐ xáhaⁿ‑dě xii‑xi núu ní quee‑xi quehé ní xáhaⁿ‑xi xìi náná‑xi: —Nǎá, ¿ná cúú sǎ càcáⁿ‑í núú tě Hèrodés? —càchí‑xi xǎhaⁿ‑xi xìi‑aⁿ. Te nǎná‑xi‑áⁿ nǐ xáhaⁿ‑aⁿ xìi‑xi: —Cuàháⁿ cácáⁿ‑n dɨ̌quɨ́ tě Juàá tée dàcuandute ñaha xii ñáyiu —càchí‑aⁿ xǎhaⁿ‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Te ndɨ̌hɨ‑ni cuándɨhu xíchí‑ǎⁿ xɨtɨ́ vehe núú yɨ́hɨ́ tě Hèrodés‑áⁿ, te xǎhaⁿ‑xi xìi‑dé: —Cuìní‑í sá mèi nduu vitna quehndé‑n dɨ̌quɨ́ tě Juàá tée dàcuandute ñaha xii ñáyiu te taxi‑n, dico na cùhuⁿ ɨɨⁿ xɨtɨ́ cóhó taxi‑n —càchí‑xi xǎhaⁿ‑xi xìi‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Te té Hèrodés ní ngüíta‑dé ndɨ̀hú víhí ìní‑dé sá dúcáⁿ nǐ xáhaⁿ‑xi xìi‑dé, dico ñá túú ní cùyɨɨ‑dé cúñaha‑dě xii‑xi sá vǎ cúú cuǎñaha‑dě sá xìcáⁿ‑xi, chi cuèndá sá nǔú nchaa ñáyiu ní xáhaⁿ‑dě sá cúú cuǎñaha‑dě nǔu ná cúú sǎ ná càcáⁿ‑xi, te ní cacunehe‑dé ndéé Yǎ Ndiǒxí nàcuáa cutnùní iní‑xi sá ndàá cuáñaha‑dě sá ná càcáⁿ‑xi núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Te té Hèrodés‑áⁿ ndɨ̌hɨ‑ni ní xáhaⁿ‑dě xii ɨɨⁿ sandàdú sá quɨ̀hɨ́ⁿ‑dé quehndé‑dé dɨ́quɨ́ tě Juàá. ");
INSERT INTO milNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Te sandàdú‑áⁿ nǐ xica‑dé cuáháⁿ‑dé vecaá núú yɨ́hɨ́ tě Juàá‑áⁿ, te ní quexìo‑dé te ní xehndé‑ni‑dé dɨ́quɨ́ tě Juàá, te ní chihi‑dé ɨɨⁿ xɨtɨ́ cóhó te nèhe‑dé cuánuhú ní sáha‑dé xíchí xìcáⁿ‑áⁿ, te xíchí‑ǎⁿ nǐ nacuáha‑xi nǎná‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Te òré ní níhí nchaa cue tée ní xica cuu ndɨhɨ ndíi Juàá‑áⁿ tnǔhu sá dúcáⁿ nǐ sahni ñaha‑güedě xii ndíi, te ní sáháⁿ‑güedé ní ndocani‑güedé yɨquɨ cùñú ndíi te ní chindúxi‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Te nchaa cue tée ní táúchíúⁿ Jèsús cuáháⁿ cáháⁿ tnúhu Yá Ndiǒxí núú ñǎyiu ní ndexìo‑güedé núú‑gǎ te ní ngüíta‑güedé nácàni tnúhu‑güedé nchaa nàcuáa ní quide‑güedé ndɨhɨ nchaa nàcuáa ní dánèhé ñáhá‑güedě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí nèhé ná quɨ̀hɨ́ⁿ‑ó ɨ̀ɨⁿ xichi núú ñà túú ñǎyiu ndetatú‑ó —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ducaⁿ nǐ xáhaⁿ‑gǎ xii‑güedé, chi ío cuéhé ñǎyiu cuáháⁿ véxi‑yu cùú‑yu núú ndécú‑gǎ. Te ni ñǎ nìhí‑gá nása cada‑gá caxi‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Te Jèsús cuánguee‑gá bàrcú ndɨhɨ mee‑ni cuè tée ní táúchíúⁿ‑gǎ cáháⁿ tnúhu‑gá, te cuáháⁿ‑gá ndɨhɨ‑güedé ɨɨⁿ xichi núú ñà túú ñǎyiu ndècu. ");
INSERT INTO milNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Dico vài ñáyiu ní cutnùní iní‑yu sá dɨ́ú‑gǎ ñúhú bàrcú‑áⁿ cuǎháⁿ ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te nchaa ñuú cáá yàtni xíáⁿ nǐ quee ñáyiu xǐxinú‑yu cuáháⁿ núú nǐ quidé‑yu cuèndá quexìo Jesús, te sa ndècú‑yu xíáⁿ nǐ quexìo‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Te òré ní quene Jèsús xɨtɨ́ bàrcú, te ní xiní‑gá cuéhé víhí ñǎyiu xǐxúcu núú nǐ quexìo‑gá‑áⁿ, te ní cundàhú iní ñáhá‑gǎ xií‑yu chi ndècú‑yu dàtná xǐndecu cue mběé cue quɨtɨ ñá túú tòli‑xi, te ío vài núú sǎ nǐ ngüíta‑gá ní dácuáhá ñàha‑gá xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Te sátá tá cuàa cuáháⁿ te ní sáháⁿ cue tée xìca cuu ndɨhɨ Jesús núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Sa ní cuaa te ñá túú ñǎyiu ndècu yatni iha. ");
INSERT INTO milNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Váha‑gá dandàca nchaa ñáyiu‑a chi na quɨ̀hɨ́ⁿ‑yu nchaa vehe càa xɨtɨ́ yucu‑a, ndɨhɨ nchaa ñuú cáá nchàa yatni iha cuaáⁿ‑yu sá cáxǐ‑yu —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Te Jèsús ní xáhaⁿ‑gǎ: —Mee‑ndo chǐ cuǎñaha sǎ ná càxí‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te xǎhaⁿ‑güedě xii‑gá: —¿Te nása cada‑ndɨ́, chi xìni ñuhu‑xi datná úú cièndú díhúⁿ denàriú cuèndá cuaaⁿ‑ndɨ́ sá cáxǐ‑yu? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí cuàháⁿ cundehe‑ndo nǔu ná daha pàá ndécú ndɨ̀hɨ‑ndo te cachí tnúhu‑ndo —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní sáháⁿ ndéhé‑güedě nǔu ná daha pàá ndécú, te ní xáhaⁿ‑güedě xii‑gá: —Úhúⁿ duha‑ná pàá ndɨhɨ úú‑nǎ chácá ndécú —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Te Jèsús ní xáhaⁿ‑gǎ xii nchaa ñáyiu sá ná nìhí tnáhǎ‑yu cuu tɨtnɨ́ xichí‑yu, te ngóo‑yu nchaa núú cǔhú cuíí càa xíáⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Te nchaá‑yu ní ngóo‑yu, te dava xichí‑yu ní ngóo ɨɨⁿ cièndú‑yu, te dava xichí‑yu ní ngóo údico úxí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Te sátá nǐ ndɨhɨ́‑yu ní ngóo, te ní queheⁿ Jèsús ndɨ ùhúⁿ pàá ndɨ úú chácá‑ǎⁿ, te ní ndacoto‑gá andɨu te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí, te dǎtnùní ní táhú cuèchi‑gá pàá‑áⁿ te ní sáñaha‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá ní dácǎhñu‑güedé nchaa ñáyiu‑áⁿ nǐ xexí‑yu. Te dɨu‑ni ducaⁿ nǐ quide tucu‑gá úú chácá‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Te nchaá‑yu ní xexí‑yu ní ndahá xɨtɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Te sátá nǐ túhú cóhǒ‑yu te ní nadatàcá‑güedé nchaa sá nǐ quendóo, te ní chítú ùxúú tnàhá tɨ́dihi mee‑ni sǎ nǐ quendóo núú ùhúⁿ‑ni pàá, ndɨhɨ núú ùú‑ni chácá. ");
INSERT INTO milNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Te nchaa ñáyiu ní xexi‑áⁿ chi xǐnu úhúⁿ mǐl mee‑ni cuè tée chi dɨu‑ni cue tée‑áⁿ nǐ quɨ́úndehu, te dɨ̀ɨⁿ ñáyiu dɨ̀hɨ́ ndɨhɨ cue landú. ");
INSERT INTO milNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Te òré‑ni‑áⁿ nǐ xáhaⁿ Jèsús xii cue tée xìca cuu ndɨhɨ‑gá sá quěe‑güedé bàrcú codonùu‑güedé quɨ́hɨ́ⁿ‑güedé ɨɨⁿ ñuú nání Bètsaidá cáá ndàa ɨngá xio yuhu làgúná núú ndécú‑güedě‑áⁿ, te mee‑gǎ quendóo‑gá cada ndee ìní tnáhá‑gǎ ndɨhɨ cue ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Te sátá nǐ yáha ní quide ndee ìní tnáhá‑gǎ ndɨhɨ́‑yu, te ní xica‑gá cuáháⁿ‑gá ɨɨⁿ tɨndúú cáá yàtni xíáⁿ cuèndá cáháⁿ ndɨhɨ‑gá Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Te òré sa ní cundɨquɨⁿ te bàrcú sá ñúhú cuè tée xìca cuu ndɨhɨ‑gá sa cuáháⁿ‑xi ndéé cuádava xɨtɨ́ làgúná‑áⁿ, te mee‑gǎ ndécú‑gǎ ɨɨⁿ núú tɨ̀ndúú. ");
INSERT INTO milNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Te túu ndèhe‑gá sá sǔúní ndòho‑güedé tá dàcaca‑güedé bàrcú‑áⁿ cuǎháⁿ, chi cuèndá ndàa nacuáa cuáháⁿ‑xi‑áⁿ duha véxi táchí te nàtúndaha‑xi. Te ɨngá nduu‑ǎⁿ tàcuíhndá‑gá sa ní cuyatni vií‑nǎ Jèsús bàrcú ñúhú‑güedě‑áⁿ, dico núú ndute tá xìca‑gá cuáháⁿ te luha‑ná te yáha ñaha‑gǎ xii‑güedé ní cùu. ");
INSERT INTO milNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Te òré ní xiní ñáhá cuè tée ñùhu barcú‑áⁿ xii‑gá te ní yùhú‑güedé ní cana saa‑güedé, chi ní sani iní‑güedé sá ɨ̀ɨⁿ almá cúú‑gǎ. Te ní xáhaⁿ‑gǎ xii‑güedé: —¡Ñɨɨ́ cunduu‑ndo, vá yùhú‑ndó, chi yúhú cúù‑í! —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Te Jèsús cuánguee‑gá xɨtɨ́ bàrcú ñúhú‑güedě‑áⁿ, te sátá cuǎnguee‑gá te òré‑ni ní ngüɨ́ñɨ́ táchí, te ní cuñúhu vìhi‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Te ducaⁿ chi cue tée‑áⁿ ñà túú ní cùtnuní iní‑güedé nása quìde‑gá, chi ñá túú ní cùtnuní váha iní‑güedé nàcuáa ndùu sá nǐ quide‑gá òré ní nadacàyá‑gá pàá, chi ío nɨɨ dɨ̌quɨ́‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Te ní yáha‑güedé ndɨhɨ‑gá ndàa ɨngá xio yuhu làgúná, te ní sáá‑güedé ndɨhɨ‑gá yucu cue tée ñuú Genesàrét. Te yàcáⁿ ní dácútú ndèé‑güedé bàrcú‑güedé yuhu làgúná. ");
INSERT INTO milNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Te òré ní quene Jèsús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá xɨtɨ́ bàrcú, te nchaa ñáyiu xǐndecu‑áⁿ nǐ cutnùní iní‑yu sá dɨ́ú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Te ñáyiu‑áⁿ ndɨ̌hɨ‑ni ní sáháⁿ‑yu nchaa núú xǐndecu cue ñáyiu cùhú, te cue ñáyiu cùhú‑áⁿ nǐ quée‑yu xíto nchìdo ñahá‑yu cuáháⁿ ndɨ tnahá ɨɨⁿ ɨɨⁿ xichi núú nìhí‑yu tnúhu quèxio Jesús. ");
INSERT INTO milNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Te nchaa ñuú náhnú ndɨ̀hɨ nchaa ñuú lǐhli núú cuàháⁿ Jèsús, ducaⁿ xǐndecá‑yu nchaa ñáyiu cùhú cuáháⁿ xɨtɨ́ ñuú sàcáⁿ ñáhǎ‑yu núú‑gǎ cuèndá cada tátna ñaha‑gǎ xií‑yu. Te dɨu‑ni ducaⁿ xǐquidé‑yu nchaa dava‑gá xichi núú cuàháⁿ‑gá núú xǐndecu cue ñáyiu, te càháⁿ ndàhú‑yu núú‑gǎ sá ná dáñá‑gǎ tnándeé cue ñáyiu cùhú‑áⁿ cuědìcó luha yuhu dǒó‑gǎ cuèndá ndúha‑yu. Te nchaa ñáyiu cùhú ní tnándeé yuhu dǒó‑gǎ ní ndúha‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Te ñuú Jerusàlén ní quee cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, te ní quexìo‑güedé núú ndécú Jèsús, te tnàhá cue tée cùu fariséú ní quexìo ndɨhɨ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Te cue tée‑áⁿ nǐ xiní‑güedé sá dàva cue tée xìca cuu ndɨhɨ Jesús ñá túú ndàha‑güedé dàtná ndáhá mèe cue tée cùu fariséú‑áⁿ òré caxi‑güedé. Te xíǎⁿ nǔu cue tée ní quexìo‑áⁿ nǐ cáháⁿ cuèhé‑güedé cuèndá cue tée xìca cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Te ducaⁿ chi nchaa cue tée cùu fariséú‑áⁿ ndɨhɨ nchaa ñáyiu isràél nchìcúⁿ nihnú‑yu quìdé‑yu dàtná ní xóo cada nchaa cue ñaní tnáhǎ‑yu ní xíndecu ndéé sanaha, chi nchaa ñáyiu‑áⁿ và cáxǐ‑yu te núu vá ndáhǎ‑yu dàtná ní xóo ndaha nchàa cue ñaní tnáhǎ‑yu ní xíndecu ndéé sanaha‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Te ñáyiu‑áⁿ ndɨ tnahá òré cuáháⁿ‑yu núú yǎhu te nàsáá‑yu, te ndàhá‑yu nàcuáa sàni iní‑yu ndùvétú iní Yǎ Ndiǒxí, te núu vá dúcáⁿ càdá‑yu te vá cáxǐ‑yu. Te tnàhá náquèté‑yu vàsú sá sácǔhuⁿ sá xíhǐ‑yu, ndɨhɨ lǐtu, ndɨhɨ cóhó càá, ndɨhɨ càmá. Te nchaa xéhé náquèté‑yu nàcuáa sàni iní‑yu ndùvétú iní Yǎ Ndiǒxí. Te ío‑gá tɨtnɨ́ sá nǐ xóo cada nchaa ñáyiu ní xíndecu ndéé sanaha‑ǎⁿ nchìcúⁿ nihnú‑yu quìdé‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Te cue tée cùu fariséú‑áⁿ, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés‑áⁿ nǐ xáhaⁿ‑güedě xii Jèsús: —¿Ná cuèndá cue tée xìca cuu ndɨhɨ‑n ñá túú nàquete‑güedé ndaha‑güedé òré caxi‑güedé dàtná ní cachí nchaa cue tée ní xíndecu ndéé sanaha‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó cúú‑ndó cuè tée ío dàndahú méé‑xí chi càchí‑ndó sǎ ǐo quìde ndáá‑ndó te ñá ndàá sá quídé ndǎá‑ndó. Te ní quee ndáá‑xi nàcuáa ní chídó tnùní ndíi Chàiá tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǔú tùtú‑gá núú càháⁿ‑xi nàcuáa ní cáháⁿ‑gá cuèndá‑ndó, te duha ní cachí‑gá: Ñáyiu‑a càchí‑yu sá ǐo càhnu cuu‑í, dico dìcó‑ni yuhu càháⁿ‑yu, chi ñá túú ñùhu iní ñáhǎ‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Te àúⁿ nǎ cuu chìñuhu ñahá‑yu xii‑í, chi ñá túú vědana ndèé nándɨ̌hɨ‑xi, chi cue ñáyiu‑a dàcuahá‑yu cue tnàha ñáyiú‑yu nàcuáa cundecú‑yu, dico mee‑ni tnǔhu sá nǐ cahu iní cue ñáyiu ñuyíú‑a càháⁿ‑yu. Duha ní chídó tnùní ndíi Chàiá núú tùtú Yǎ Ndiǒxí nàcuáa ní cáháⁿ‑gá cuèndá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Te nchòhó ní dáñá‑ndó nàcuáa ní cachí Yǎ Ndiǒxí cada‑ndo, te nchìcúⁿ nihnu‑ndo quìde‑ndo nacuáa ní cahu iní cue ñáyiu ñuyíú‑a, chi nàquete‑ni‑ndo lítu, te nàquete‑ni‑ndo vasú sácǔhuⁿ sá xíhí‑ndó nàtava‑ndo nacuáa ní xóo cada ñáyiu‑áⁿ nǐ xóo naqueté‑yu nchaa xíǎⁿ, te nándɨ‑gá nchaa núú sǎ quídé‑ndó —càchí Jèsús xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Te ní xáhaⁿ tùcu‑gá xii‑güedé: —Te nchòhó, ñá túú cuìní‑ndó càda‑ndo nacuáa cuìní Yǎ Ndiǒxí, chi mee‑ni nàcuáa ní cachí cue tée ní xíndecu ndéé sanaha nchìcúⁿ nihnu‑ndo quìde‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Te ndíi Moìsés ní cachí ndíi sá ncháá ñǎyiu canehé‑yu sá yɨ́ñùhu núú tǎtǎ‑yu ndɨhɨ núú nǎnǎ‑yu. Te nchaa ñáyiu na càháⁿ úhú cuèndá tǎtǎ‑yu àdi cuendá nǎnǎ‑yu te cahni ñaha‑güedě xií‑yu ní cachí ndíi. ");
INSERT INTO milNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Te nchòhó càchí‑ndó sǎ nǔu ɨɨⁿ tée na cǔñaha‑dě xii tǎtá‑dě ndɨhɨ nǎná‑dě sá sǎ nǐ sani iní‑dé cuáñaha‑dě xií‑yu cùu‑xi Corbán, te ñá túú‑gǎ xíní ñùhu‑xi sá cuǎñaha‑dě xií‑yu, te tnúhu Còrbán‑áⁿ quéé‑xí: Sá cúú cuèndá Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Te sá dúcáⁿ ná càháⁿ ɨɨⁿ tée‑áⁿ te nchòhó chíndèe tnúhu‑ndo‑dě cuèndá sá vǎ chíndèe‑gá‑dé tǎtá‑dě ndɨhɨ nǎná‑dě. ");
INSERT INTO milNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Te ducaⁿ quìde‑ndo chi ní dáquéé tɨ̌hú‑ndó nàcuáa ní cachí Yǎ Ndiǒxí cada‑ndo, te mee‑ni nàcuáa ta quìde cue tée ñuyíú‑a véxi nchìcúⁿ nihnu‑ndo quìde‑ndo, te dɨu‑ni ducaⁿ ta sànu ichi tnaha‑ndo véxi, te nándɨ‑gá nchaa sá cáhú ìní‑ndó quìde‑ndo —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Te Jèsús ní xáhaⁿ tùcu‑gá xii cue ñáyiu xǐndecu‑áⁿ: —Chí táquìxi ndehe iha, te cundedóho váha‑ndo tnǔhu na càháⁿ‑í‑a te ío váha cuáha‑ndo cuèndá. ");
INSERT INTO milNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nchaa sá xéxí‑ndó chi ñá túú nǎ quídé‑xí ìní‑ndó, dico nchaa sá cuèhé sá dúhá sàni iní‑ndó quìde‑ndo, nchaa xíǎⁿ quídé‑xí ndècu cuéchi‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Te nchaa nchòhó ñáyiu ndèdóho nchaa tnúhu càháⁿ‑í‑a ío váha chí cuǎha cuèndá —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Te Jèsús ní dándǒo‑gá nchaa ñáyiu núú xǐxúcu‑yu‑áⁿ te cuándɨhu‑gá xɨtɨ́ vehe. Te cue tée xìca cuu ndɨhɨ‑gá ní xícáⁿ tnúhú‑güedě núú‑gǎ nǔu nása quèe‑xi cuendú ní cani‑gá núú ñǎyiu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Te ní xáhaⁿ‑gǎ xii‑güedé: —¿Te náa tnàhá nchòhó ñá túú ní tècú tnùní‑ndó cuèndú ní cani‑í núú ñǎyiu‑ǎⁿ? Nchaa sá xéxǐ‑yu cuánguee xɨtɨ́‑yu ñá túú quìde‑xi iní‑yu nàcuáa ngúndecu cuéchi‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Chi ñá dɨ́ú ìní‑yu cuánguee‑xi chi cuánguee ndáá‑xi xɨtɨ́‑yu, te nàyáha ñaha‑xi xìí‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te sá dúcáⁿ nǐ cáháⁿ‑gá te ní dátǔu‑gá sá cúú càxi‑o nchaa núú sǎ cúú càxi‑o. ");
INSERT INTO milNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Te ní xáhaⁿ tùcu‑gá xii‑güedé: —Nchaa sá cuèhé sá dúhá quìde ñáyiu xíǎⁿ cácú nìhnu‑xi iní‑yu, te nchaa xíǎⁿ quídé‑xí ndècu cuéchi‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Te iní‑yu‑áⁿ cácú nìhnu nchaa sá cuèhé sá dúhá, chi sàni cuehé sání dùha iní‑yu. Te cue tée càháⁿ ndɨhɨ‑güedé ñadɨ̀hɨ́ te ñá dɨ́ú ñàdɨhɨ́‑güedé cúǔ‑yu, te dɨu‑ni ducaⁿ quìde cue ñáyiu dɨ̀hɨ́ càháⁿ ndɨhɨ́‑yu tée te ñá dɨ́ú yɨ̀ɨ́‑yu cùu‑güedé. Te sàhní‑yu cue tnàha ñáyiú‑yu, te mee‑ni ìchi dɨ́ɨ́ ìní cúdɨ̌ɨ́ ìní‑yu cundecú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Te dùhu ndachiuⁿ tnahá‑yu, te xìhó‑yu cundecu ndɨhɨ́‑yu sá ndécú ndɨ̀hɨ tnaha ñáyiú‑yu, te ío quìde úhú iní‑yu sá cúú‑xí tnàha ñáyiú‑yu, te ío dàndahú tnáhǎ‑yu, te mee‑ni nchàa sá cuèhé sá dúhá cùdɨ́ɨ́ ìní‑yu quìdé‑yu, te ío cuédú ínǐ‑yu, te ío yɨtɨ yùhú‑yu, te ío quìde cahnú‑yu mèé‑yu, te quìdé‑yu nándɨ‑gá sá ñà túú tàú‑yu cadá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Te nchaa sá cuèhé sá dúhá‑ǎⁿ cácú nìhnu‑xi iní‑yu, te nchaa xíǎⁿ quídé‑xí ndècu cuéchi‑yu, te ñá túú cùu‑xi sá vǎha sá cúú‑xí ìní‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Te ní xica Jèsús cuáháⁿ‑gá ndéé yucu cue tée ñuú Tìrú, ndɨhɨ yucu cue tée ñuú Sìdón. Te òré ní quexìo‑gá xíáⁿ te cuánguɨhu‑gá ɨɨⁿ vehe te xíáⁿ cundecu‑gá, te cuìní‑gá sá vǎ quìní ñáyiu sá xǐáⁿ ndécú‑gǎ ní cùu, dico dai ní níhǐ‑yu tnúhu. ");
INSERT INTO milNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Te ɨɨⁿ ñadɨ̀hɨ́ ndécú ɨ̀ɨⁿ déhe yoco‑aⁿ, te yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha xii‑xi, te ñaha‑áⁿ ǐo ndɨ̌hɨ ní níhí‑aⁿ tnúhu sá nǐ quexìo Jesús xíáⁿ nǔu ní sáháⁿ‑aⁿ núú ndécú‑gǎ, te ní ngüɨ́ñɨ́ xɨ́tɨ́‑áⁿ nǔú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Te ní ngüíta‑aⁿ càháⁿ ndàhú‑aⁿ núú‑gǎ, te xǎhaⁿ‑aⁿ sǎ nǔu vá cúndèe iní‑gá queñuhu‑gá espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii déhe‑aⁿ. Dico ñá dɨ́ú ñàha israél cúú‑áⁿ chi ñaha ñuú Sirofèniciá cúú‑áⁿ te tnúhu grìégú cúú tnǔhu‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Te xíǎⁿ nǔu ní xáhaⁿ Jèsús xii‑aⁿ: —Daña na càxi tnaa nchaa landú chítú xɨ̀tɨ́‑güexi, te dǎtnùní caxi cue iná, chi ñá túú ndùu váha‑xi queheⁿ‑o sǎ xéxí làndú te cuáha‑o ìná —càchí‑gá xǎhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Te ní xáhaⁿ‑aⁿ xìi‑gá: —Mèstrú, ndáá‑ni càháⁿ‑n, dico iná chi nàdatacá‑güedɨ sá ngóyó yùhu cóhó làndú —càchí‑aⁿ xǎhaⁿ‑aⁿ xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Te Jèsús ní xáhaⁿ‑gǎ xii‑aⁿ: —Ío váha ní cáháⁿ‑n, te cuanùhú te ñá túú‑gǎ ná cani iní‑n, chi sa ní quee espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii déhe‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Te ñaha‑áⁿ nǐ nasáá‑aⁿ vehe‑aⁿ te càa déhe‑aⁿ núú càmá, dico ñá túú‑gǎ espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii‑xi chi sa ní quee ñaha‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Te Jèsús ní ndee‑gá yucu cue tée ñuú Tìrú te ní yáha‑gá yucu cue tée ñuú Sìdón, ndɨhɨ yucu ndɨ ùxí ñuú nání Dècápolís, te ní sáá‑gá ndéé yuhu làgúná distrìtú Galìleá. ");
INSERT INTO milNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Te xíáⁿ ndécú‑gǎ ní quexìo ñáyiu ndéé núú‑gǎ ndécǎ‑yu ɨɨⁿ tée ñá cúú cǎháⁿ váha‑dé te doho‑dě. Te càháⁿ ndàhú‑yu núú‑gǎ sá ná tèndaha ñaha‑gá xii‑dé cuèndá ndúha‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Te Jèsús ní queñuhu ñaha‑gǎ xii‑dé tnuú‑yu, te ndèca ñaha‑gá cuáháⁿ ɨɨⁿ xio, te ní dáquɨ̌hu‑gá dɨ́quɨ́ ndáhá‑gǎ yaú lóho‑dé, te ní dácánùu‑gá dɨɨ́‑gá dɨ́quɨ́ ndáhá‑gǎ, te ní tendaha‑gǎ yàa‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Te ní ndacoto‑gá andɨu te ní sánuu iní‑gá, te ní cáháⁿ‑gá tnúhu mee‑gǎ, te xǎhaⁿ‑gǎ: —¡Ěfatá! —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te tnúhu‑áⁿ quéé‑xí: Nacaáⁿ yòhó lóho. ");
INSERT INTO milNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Te òré‑ni‑áⁿ nǐ nacaáⁿ lóho‑dé, te ní nduu váha yàa‑dé, te ní cuu cáháⁿ váha‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Te Jèsús ní cáháⁿ víhí‑gǎ dóho ñáyiu ndɨhɨ ñaha xìi tée ní quide tátna‑gá‑áⁿ sǎ vǎ yǒo ɨɨⁿ cúñàhá‑yu sá nǐ quide tátna ñaha‑gǎ xii‑dé, dico uuⁿ‑gá ní quidé‑yu ní cáháⁿ‑yu núú ñǎyiu sá nǐ quide tátna‑gá tée‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Te nchaá‑yu ío ní cuñúhu‑yu, te ní xítnàhá‑yu: —Váha vìhi quide‑dé, chi nchaa‑ni ndàcu‑dé quídé‑dě, chi quìde tátna‑ni‑dé ñáyiu doho, te quìde tátna‑ni‑dé ñáyiu ñɨ̀hɨ́ —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Te ɨɨⁿ nduu tucu ío cuéhé ñǎyiu ní tacá núú ndécú Jèsús, te ñá túú tnàhí sá cáxǐ‑yu. Te ní cana‑gá cue tée xìca cuu ndɨhɨ‑gá, te ní xáhaⁿ‑gǎ xii‑güedé: ");
INSERT INTO milNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Yúhú, cùndahú iní‑í nchaa ñáyiu‑a chi sa ní cuu úní nduu ndècu ndɨhɨ ñahá‑yu xii‑o ìha, te ñá túú tnàhí ná sá cáxǐ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Te núu na nàtendaha‑í‑yu núhú tnámǎ‑yu vehé‑yu, te cuneé‑yu docó ichi, chi davá‑yu ío xica ndècú‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Te ní xáhaⁿ‑güedě xii‑gá: —¿Te ndèé níhí‑ó sǎ cuǎñaha‑o càxi nchaa ñáyiu‑a, te iha ñá túú nǎ ìó chi cùu‑xi xɨtɨ́ yucu‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Te Jèsús ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ: —¿Ná daha‑gá pàá ndécú ndɨ̀hɨ‑ndo‑i? —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Ndècu ndɨhɨ‑ndɨ́ úsá‑gá tnàhá —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Te Jèsús ní xáhaⁿ‑gǎ xii nchaa ñáyiu sá ngǒo‑yu nchaá‑yu, te ní ngóo‑yu, te ní queheⁿ‑gá ndɨ ùsá pàá‑áⁿ, te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí. Te dǎtnùní ní táhú cuèchi‑gá te ní sáñaha‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá ní dácǎhñu‑güedé nchaa ñáyiu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Te ndècu ndɨhɨ‑güedé ɨɨⁿ ǔú chácá lǐhli, te dɨu‑ni ducaⁿ nǐ quide‑gá ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí. Te dǎtnùní ní táúchíúⁿ‑gǎ ní dácǎhñu ñaha‑güedě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Te nchaá‑yu ní xexí‑yu ní ndahá xɨtɨ́‑yu. Te sátá nǐ túhú cóhǒ‑yu te ní nadatàcá‑güedé nchaa sá nǐ quendóo, te ní chítú ǔsá tnàhá tɨ́dihi mee‑ni sǎ nǐ quendóo‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Te núú ncháá ñǎyiu ní xexi‑áⁿ xǐnu dàtná cúmí mǐl‑yu. Te sátá nǐ yáha ní dácáxí ñàha Jesús xií‑yu te ní dándácá ñàha‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Te dǎtnùní cuánguee‑gá bàrcú ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá cuáháⁿ‑gá ndɨhɨ‑güedé yucu cue tée ñuú Dalmànutá. ");
INSERT INTO milNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Te núú nǐ quexìo Jesús xíáⁿ nǐ sáá cue tée cùu fariséú, te ní ngüíta‑güedé nándɨ tnúhu xáhaⁿ‑güedě xii‑gá xító ndèé ñáhá‑güedě. Te xǎhaⁿ‑güedě sá ná cádá‑gǎ ɨɨⁿ sá vǎ yǒo tnàhí ndàcu cada cundehe‑güedé nàcuáa cutnùní iní‑güedé nǔu ndáá sá Yǎ Ndiǒxí ní tendaha ñàha‑gá xii‑gá véxi‑gá ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Te ní sánuu iní‑gá te ní xáhaⁿ‑gǎ xii‑güedé: —Nchaa nchòhó ñáyiu ndècu ñuyíú‑a cuìní‑ndó càda‑í ɨɨⁿ sá vǎ yǒo tnàhí ndàcu cada nacuáa cutnùní iní‑ndó nǔu ndáá sá Yǎ Ndiǒxí chíndèe ñaha‑gá xii‑í. Dico na càchí tnúhu ndáá‑í xii‑ndo sǎ vǎ cádà‑í sá cuìní‑ndó —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Te ní dándǒo‑gá ñáyiu xǐndecu‑áⁿ, te cuándee‑gá bàrcú ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá te cuáháⁿ‑gá ndɨhɨ‑güedé ndàa ɨngá xio yuhu làgúná. ");
INSERT INTO milNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Te ní cunaa‑güedé canehe‑güedé sá cáxí‑güedě quɨ́hɨ́ⁿ, te ɨɨⁿdìi‑ni paá ndécú xɨ̀tɨ́ bàrcú‑áⁿ nǐ naníhí‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Te Jèsús ní cáháⁿ‑gá dóho‑güedé, te xǎhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu‑í xii‑ndo sǎ ǐo quɨhɨ iní‑ndó cùndecu‑ndo te vá cádá cuèndá tnàhí‑ndo lèvadurá cue tée cùu fariséú, ndɨhɨ levadùrá cue tée cùndɨhɨ té Hèrodés —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Te ní ngüíta‑güedé xǐtnàha‑güedé: —Cuèndá sá ñà túú ní cǎnehe‑o pàá quixi núu xíǎⁿ duha càháⁿ‑gá —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Te Jèsús ní cutnùní iní‑gá nàcuáa ndùu tnúhu xǐtnàha‑güedé, núu ní xáhaⁿ‑gǎ xii‑güedé: —¿Ná cuèndá da sá ñà túú ní cǎnehe‑ndo pàá quixi càháⁿ‑ndó? Te ñá dɨ́ú cuèndá pàá‑áⁿ ní cǎháⁿ‑í, te dìcó‑ni sá méé‑ndó ñà túú quìde cuendá váha‑ndo nàcuáa ndùu tnúhu càháⁿ‑í, te ni ñǎ tècú tnùní‑ndó chi ío nɨɨ dɨ̌quɨ́‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Te cuěi ndèhe‑ndo dico ñá túú cùtnuní iní‑ndó nǎ cúú nchàa sá quídè‑í, te cuěi ndèdóho‑ndo nchàa tnúhu càháⁿ‑í dico ñá cútnùní iní‑ndó nǎsa ndùu‑xi, te ni ñǎ ndácú ìní‑ndó nchàa sá tá quìde‑í véxi. ");
INSERT INTO milNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Te chí dándàcu iní cútnàhá ní táhú cuèchi‑í úhúⁿ‑ni pàá te ní xexi úhúⁿ mǐl mee‑ni cuè tée chi dɨu‑ni cue tée‑áⁿ nǐ quɨ́úndehu. Te chí càchí tnúhu ná daha tɨ́dihi ní chítú mee‑ni sǎ nǐ quendóo òré ní nadatàcá‑ndó —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Úxúú tnàhá tɨ́dihi ní chítú mee‑ni sǎ nǐ quendóo —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te xǎhaⁿ tùcu‑gá: ");
INSERT INTO milNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Te cútnàhá ní táhú cuèchi tucu‑í úsá tnàhá pàá ní xexi cúmí mǐl ñáyiu, te chí càchí tnúhu ná daha tucu tɨ́dihi ní chítú mee‑ni sǎ nǐ quendóo —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Úsá tnàhá tɨ́dihi ní chítú mee‑ni sǎ nǐ quendóo —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Te Jèsús ní xáhaⁿ tùcu‑gá xii‑güedé: —Vitna, ¿te sa ní tecú tnùní‑ndó tnǔhu ní cáháⁿ‑í ǎⁿ ñǎhá? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Te Jèsús ní sáá‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ñuú Bètsaidá. Te ñuú‑áⁿ ndécú‑gǎ ní quexìo ñáyiu núú‑gǎ tánèhé‑yu ɨɨⁿ tée cuàá, te càháⁿ ndàhú‑yu núú‑gǎ nǔu vá cúndèe iní‑gá tendaha ñàha‑gá xii‑dé cuèndá ndúha núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Te Jèsús ní tnɨɨ‑gá ndaha tée cuàá‑áⁿ, te ní queñuhu ñaha‑gǎ tnuú‑yu, te ndèca ñaha‑gá cuáháⁿ ɨɨⁿ xio yuhu ñùú. Te yàcáⁿ ní dácánùu‑gá dɨɨ́‑gá núú‑dě te ní tendaha ñàha‑gá xii‑dé, te dǎtnùní ní xícáⁿ tnúhú‑gǎ núú‑dě, te xǎhaⁿ‑gǎ: —¿Cùtnuní núú‑n‑ǎⁿ? —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Te tée cuàá‑áⁿ nǐ ndonehe núú‑dě, te xǎhaⁿ‑dě xii‑gá: —Cùtnuní núù‑í ndéhè‑í nchaa cue tée‑ǎⁿ, dico dà ndáa yutnu cuìi ndáa‑güedé te xìca‑güedé —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Te Jèsús ní tendaha tùcu‑gá núú‑dě te ní cuu ní ndacoto váha‑gá‑dé, te òré‑áⁿ nǐ ndúha núú‑dě. Te nchaandɨ túhú sá ndéhé‑dě ní cutnùní váha núú‑dě nándɨ cùu nchaa xíǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Te ní xáhaⁿ Jèsús xii‑dé: —Vitna te núhú‑n, dico ndáá ichi vehe‑n nǔhú‑n te ñá dɨ́ú dà xɨtɨ́ ñuú quɨ́hɨ́ⁿ‑n, te vá yǒo ɨɨⁿ cúñaha‑n sǎ yǔhú ní quide tátna‑í núú‑n nǐ ndúha —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Te Jèsús ní xica‑gá cuáháⁿ‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá nchaa ñuú lǐhli càa ñuú Cèsareá Fìlipú, te òré ñúhú‑gǎ ndɨhɨ‑güedé ichi te ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ xii‑güedé: —Chí càchí tnúhu nása càháⁿ ñáyiu cuèndá‑í. ¿Yoo cùu‑í càchí‑yu‑va? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Te ní xáhaⁿ‑güedě xii‑gá: —Davá‑yu càchí‑yu sá cúú‑n ndǐi Juàá tée ní xóo dacuàndute ñaha xii ñáyiu, te davá‑yu càchí‑yu sá cúú‑n tě Èliás, te dava tucú‑yu càchí‑yu sá cúú‑n ɨ̀ɨⁿ tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, duha càchí‑yu —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Te ní xícáⁿ tnúhú tùcu‑gá núú‑güedě, te xǎhaⁿ‑gǎ xii‑güedé: —Te nchòhó, ¿yoo sàni iní‑ndó cùu‑í‑i? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te té Pèlú ní xáhaⁿ‑dě xii‑gá: —Yòhó cúú‑n Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Te Jèsús ní cáháⁿ‑gá dóho‑güedé, te xǎhaⁿ‑gǎ: —Vá yǒo ɨɨⁿ cúñaha‑ndo yòo cuu‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Te Jèsús ní ngüíta‑gá xǐtnǔhu‑gá cue tée xìca cuu ndɨhɨ‑gá nàcuáa yáha‑gá, te xǎhaⁿ‑gǎ xii‑güedé: —Yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo chi ío ndoho‑í, chi daquèe tɨ́hú ñáhá nchàa cue tée cùu sacuéhé nǔú ñǎyiu isràél, ndɨhɨ cue dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ní chídó tnùní ndíi Moìsés, nchaa cue tée‑áⁿ dàquee tɨhú ñáhá‑güedě xii‑í. Te sáá nduu te cahni ñaha‑güedě xii‑í, dico nduu úní sá cùú‑í te ndoto‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Te ducaⁿ nǐ cáháⁿ Jèsús núú cuè tée xìca cuu ndɨhɨ‑gá nàcuáa tecú tnùní váha‑güedé tnúhu càháⁿ‑gá. Te té Pèlú ní cana ñaha‑dě xii‑gá ɨɨⁿ xio, te ní ngüíta‑dé ténàá ñáhá‑dě xii‑gá ní cùu. ");
INSERT INTO milNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Dico Jèsús ndɨ̌hɨ‑ni ní nchócuǐhnu‑gá ní ndàcoto‑gá núú nchàa‑güedé chi ndàa sátá‑gǎ xǐndecu‑güedé, te ní ngüíta‑gá ténàá‑gá té Pèlú, te xǎhaⁿ‑gǎ xii‑dé: —¡Xocuɨ̀ñɨ́ yòhó núù‑í‑a, chi dàtná càháⁿ yucu ñǎvǎha càháⁿ‑n! Chi ñá túú sàni iní‑ǒ dàtná sání ìní Yǎ Ndiǒxí, chi ɨɨⁿ‑ni sàni iní‑ǒ ndɨhɨ dava‑gá cue ñáyiu ndècu ñuyíú‑a —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Te Jèsús ní cana‑gá nchaa cue tée xìca cuu ndɨhɨ‑gá, ndɨhɨ nchaa ñáyiu xǐndecu‑áⁿ, te ní xáhaⁿ‑gǎ: —Nchaa ñáyiu cuìní chitnahá ñáhá xìi‑í, te xìni ñuhu‑xi vá cádá‑gǎ‑yu sá sání ìní méě‑yu, te ío cada ndee ìní‑yu cundecu túha‑yu ndohó‑yu cuèndá‑í, te cuěi na ndòhó‑yu dàtná ndoho‑í. ");
INSERT INTO milNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Te nchaa ñáyiu cuìní sá ñà túú tnàhí ná yáha cundecu ñuyíú‑a cuíta nihnú‑yu, dico nchaa ñáyiu ñá túú tnàhí yùhú cuěi nándɨ sá ná yǎha‑yu cundecú‑yu ñuyíú‑a sá cuèndá‑í, ndɨhɨ sá cuèndá tnúhu‑í, te ñáyiu‑áⁿ naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Te cuěi nchaandɨ túhú sá ìó ñuyíú‑a na nìhí ñáyiu cundecu ndɨhɨ́‑yu, dico núu dɨu nchaa xíǎⁿ ná càda cuíta nihnú‑yu te ñá túú vědana nàndɨ́hɨ‑xi sá dúcáⁿ ndècu ndɨhɨ́‑yu nchaa xíǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Te ni ɨ̀ɨⁿ sá ìó ñuyíú‑a vá chíndèe‑xi ñáyiu cuèndá naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Te nchaa ñáyiu na cùcahaⁿ núú‑xi cáháⁿ váha cuèndá‑í, ndɨhɨ cuèndá tnúhu‑í núú nchàa ñáyiu dàquee tɨhú ñáhá xìi Yá Ndiǒxí, ñáyiu xǐndecu ichi cuèhé ichi duha, te tnàhá yúhú Tée cùu ñaní tnáhǎ‑yu nchaá‑yu cucahaⁿ núù‑í núǔ‑yu òré ná quìxi tucu‑í ndɨhɨ cue espíritú xínú cuèchi núú Tǎtà‑í Dútú Ndiǒxí. Te mee‑gǎ cada cutnùní iní nchaa ñáyiu sá yǔhú ío càhnu cuu‑í. ");
INSERT INTO milNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","’Te na càchí tnúhu ndáá‑í xii‑ndo sǎ ìó dava nchòhó ñáyiu xǐndecu iha vitna vá cùú‑ni‑ndo, chi cundecu‑ni‑ndo ndèé quiní‑ndó sàá nduu ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu, te dàvá‑áⁿ quiní‑ndó sǎ ndácú‑gǎ quídé‑gǎ nchaandɨ túhú sá vǎha —càchí‑gá xǎhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá ndɨhɨ cue ñáyiu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Te núú ìñú nduu sá dúcáⁿ nǐ cáháⁿ Jèsús te ní xica‑gá cuásaá‑gá ɨɨⁿ yucu dùcúⁿ, te ndèca‑gá té Pèlú, ndɨhɨ té Jàcobó, ndɨhɨ té Juàá cuásaá, te úní tnàhí‑ni cue tée‑áⁿ ndécá‑gǎ cuásaá. Te yucu‑áⁿ ndécú‑gǎ ní nadama núú‑gǎ, ");
INSERT INTO milNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","te ní nadama dóó‑gǎ. Te dóó‑gǎ‑áⁿ sǔúní nǐ nduu cuìxíⁿ quɨyɨ́ te tǎsaⁿ, te ni ɨ̀ɨⁿ ñáyiu ñuyíú‑a ñá túú ndàcú‑yu naqueté‑yu ɨɨⁿ dóó nduu cuìxíⁿ dàtná ní nduu dóó‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Te ní xiní‑güedé té Moìsés ndɨhɨ té Èliás nútnɨ̌ɨ‑güedé ndɨhɨ‑gá ndátnǔhu ndɨhɨ ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Te té Pèlú ní xáhaⁿ‑dě xii Jèsús: —Mèstrú, ¡váha ní cuu sá ndécú‑ó ìha vitna! Te na dàcaa‑ndɨ́ úní tnàhá vehe tnuvixiⁿ, te ɨɨⁿ cuu cuèndá‑n te ɨɨⁿ cuu cuèndá té Moìsés te ɨɨⁿ cuu cuèndá té Èliás —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Te ducaⁿ nǐ cáháⁿ‑dé chi ío ní yùhú‑güedé, te cuèndá‑ni ní cuu yáchí‑dé ní cáháⁿ‑dé, te ni mèe‑dé ñá túú ní cùtnuní iní‑dé nása ndùu tnúhu ní cáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Te òré‑áⁿ nǐ quexìo ɨɨⁿ vícó nǔú ndécú‑güedě ndɨhɨ Jèsús ní dádǎhu ñaha‑xi xìi‑güedé ndɨhɨ‑gá, te xɨtɨ́ vícó‑ǎⁿ nǐ cáháⁿ Yǎ Ndiǒxí ní tecú dóho‑güedé, te xǎhaⁿ‑gǎ xii‑güedé: —Tée‑a cùu‑dé Déhe‑í tée ío cùu iní‑í, te cundedóho‑ndo nchàa tnúhu càháⁿ‑dé —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Te òré ní quide cuèndá‑güedé, te ñá túú‑gǎ ní xìní‑güedé cue tée úú‑áⁿ chi mee‑nǎ Jèsús ndécú. ");
INSERT INTO milNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Te òré cuánuu ndɨhɨ ñaha‑gǎ xii‑güedé yucu‑áⁿ, te ní cáháⁿ‑gá dóho‑güedé, te xǎhaⁿ‑gǎ: —Vá yǒo ɨɨⁿ cúñaha‑ndo nchàa sá nǐ xiní‑ndó nǔú nǐ sáá‑ó‑á, te cuu cáháⁿ‑ndó dico ndéé ná yǎha ndoto yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo sá cùú‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Núu xíǎⁿ cue tée‑áⁿ nǐ xúhuⁿ nahi‑ni ìní‑güedé nchaa sá nǐ xiní‑güedé núú nǐ sáháⁿ‑güedé ndɨhɨ Jèsús te ñá túú tnàhí ni cǎháⁿ‑güedé, dico ní ndúcú tnǔhu núú tnáhá‑güedě ná cuèndá ducaⁿ nǐ cáháⁿ‑gá sá ndèé ná yǎha ndoto‑gá sá cùú‑gá te dǎtnùní cáháⁿ‑güedé nàcuáa ndùu nchaa sá nǐ xiní‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Te ní xícáⁿ tnúhú‑güedě núú Jèsús, te xǎhaⁿ‑güedě xii‑gá: —¿Cuìní‑ndɨ́ cachí tnúhu‑n nǎ cuèndá càchí cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés sá dǐhna‑gá té Èliás ndixi‑dé te dǎtnùní quixi Yaá tendaha Yǎ Ndiǒxí quixi ñuyíú‑a? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Te Jèsús ní xáhaⁿ‑gǎ: —Ndáá sá códó nùu ɨɨⁿ tée quixi‑dé te cada‑dé dàtná ní quide té Èliás, te tée‑áⁿ cada ndáá‑dé nchaa nàcuáa cùu. Dico núú tùtú Yǎ Ndiǒxí càháⁿ‑xi cuèndá yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo sá ǐo ndoho‑í, te daquèe tɨhú ñáhá ñǎyiu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Te na càchí tnúhu‑í xii‑ndo vìtna sá sà ní quixi ɨɨⁿ tée ní quide dàtná ní xóo cada té Èliás, te cue ñáyiu ñá túú ní cǎnehé‑yu sá yɨ́ñùhu núú‑dě, te ní quide ñàhá‑yu xii‑dé nchaa nàcuáa ní quixi iní méě‑yu. Te núú tùtú Yǎ Ndiǒxí sa ndèé tnuní nchaa nàcuáa yáha‑dé, te nchaa xíǎⁿ sa ní quide ñaha ñáyiu xii‑dé —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Te Jèsús ní ndexìo‑gá ndɨhɨ cue tée úní‑áⁿ nǔú xǐndecu dava‑gá cue tée xìca cuu ndɨhɨ‑gá, te vài vihi ñáyiu ndècu núú ndécú‑güedě‑áⁿ, te tnàhá cue tée dàcuaha ñaha xií‑yu nchaa tnúhu ní chídó tnùní ndíi Moìsés xǐndecu, te cue tée‑áⁿ nǎndɨ tnúhu xǎhaⁿ‑güedě xii cue tée xìca cuu ndɨhɨ Jesús. ");
INSERT INTO milNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Te òré ní xiní‑yu ní ndexìo‑gá, te nchaá‑yu ío ní cuñúhu‑yu, te xìnú‑yu ní sáháⁿ ní cáháⁿ ndɨhɨ ñàhá‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Te ní xícáⁿ tnúhú‑gǎ núú cuè tée xìca cuu ndɨhɨ‑gá nǔu ná tnúhu ndàtnúhu‑güedé ndɨhɨ cue tée‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Te ɨɨⁿ ñáyiu xǐndecu xíáⁿ nǐ xáhǎⁿ‑yu xii‑gá: —Mèstrú, ndèca‑í déhe‑í véxi nànducu ñaha‑í xii‑n, chi yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha xii‑dé, te dɨu xíǎⁿ ní quide ní cuu ñɨ̀hɨ́‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Te ío ndòho‑dé chi súúní nděni ní cuu ngǒtnɨɨ ñaha‑xi xìi‑dé, te òré ducaⁿ quìde ñaha‑xi xii‑dé te dànduá ñáhá‑xí, te quène tɨ́ñú yuhu‑dé, te cùrúhñú nǔhu‑dé, te ndàda ruúⁿ ñáhá‑xí xìi‑dé. Te sa ní xáhaⁿ‑ǐ xii cue tée xìca cuu ndɨhɨ‑n sá quéñùhu‑güedé espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii‑dé dico ñá túú ní ndàcu‑güedé queñuhu‑güedé‑xi —càchí ñáyiu‑áⁿ xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Te Jèsús ní xáhaⁿ‑gǎ: —¡Nchaa nchòhó ñáyiu ndècu ñuyíú‑a ío sàá iní‑ndó, chi ñá túú cuìní‑ndó quɨ̀ndáá iní‑ndó Yǎ Ndiǒxí, te ní cuu vài nduu quide ndee iní‑í nchaa sá quídé‑ndó! ¿Te ná ndéé ama vá dúcáⁿ‑gǎ cada‑ndo‑i? Te chí cándèca tée cùhú‑áⁿ táquìxi iha —cachí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Te ñáyiu ndɨhɨ ñaha xìi tée yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ ndécá ñàhá‑yu xii‑dé cuáháⁿ ndéé núú Jèsús, te òré ní xiní ñáhá espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ xii‑gá, te ní ngüíta‑ni‑xi sàhni yɨhɨ́ ñáhá tùcu‑xi xii‑dé, te ní dándùá ñáhá‑xí xìi‑dé, te ní ngüíta‑dé xíchí ñùhu‑dé, te quène tɨ́ñú yuhu‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Te Jèsús ní xícáⁿ tnúhú‑gǎ núú tǎtá‑dě, te xǎhaⁿ‑gǎ xii‑dé: —¿Ná ndéé ama ní ngüíta‑xi duha ndòho déhe‑n? —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te tée‑áⁿ nǐ xáhaⁿ‑dě xii‑gá: —Ndéé cútnàhá cúú lǐhli‑dé ní ngüíta espíritú cúndɨ̀hɨ yucu ñávǎha duha quìde ñaha‑xi xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Te ní cùtɨtnɨ́ xito dàngaunihnu ñaha‑xi xii‑dé núú ñùhú, te ní cutɨtnɨ́ tucu xito dàngaunihnu ñaha‑xi xii‑dé ndute cuìní‑xi cahni ñaha‑xi xìi‑dé. Te ndèca‑í‑dé véxi núú‑n te núu ndacu‑n càda tátna‑n‑dě, te cundàhú iní ñáhá‑n xìi‑ndɨ́ chindee ñàha‑n —cachí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Te Jèsús ní xáhaⁿ‑gǎ: —Te ná cuèndá càchí‑n nǔu ndacu‑í cada tátna‑í déhe‑n, chi nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í te nìhí‑yu sá ná càcáⁿ‑yu núù‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Te tǎtá těe cuechi‑ǎⁿ nǐhi ní cáháⁿ‑dé xǎhaⁿ‑dě xii‑gá: —Sàndáá iní ñáhà‑í xii‑n, dico chindee ñàha xii‑í cuèndá ná quɨ̀ndáá iní ñáhá‑gǎ‑í xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Te Jèsús ndéhé‑gǎ sá ǐo vài ñáyiu ta tàcá núú ndécú‑gǎ‑áⁿ. Te ní tenàá‑gá espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ, te xǎhaⁿ‑gǎ xii‑xi: —Yòhó espíritú cúndɨ̀hɨ yucu ñávǎha, ní quide ñɨ̀hɨ́‑n nǐ quide doho‑n těe‑a, dico vitna yúhú càchí‑í sá quéé‑n yɨ̀quɨ cuñú‑dé te vá ndɨ̌hu‑gá‑n —càchí‑gá xǎhaⁿ‑gǎ xii espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Te espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ nǐ dácáná sàa ñaha‑xi xii tée‑áⁿ, te ní sahni yɨ̀hɨ́ ñáhá tùcu‑xi xii‑dé, te dǎtnùní ní quee ñaha‑xi xìi‑dé cuáháⁿ‑xi, dico tée‑áⁿ chi dacàa‑ni ndɨ́yɨ càa‑dé cátùu‑dé. Te nchaa ñáyiu xǐndecu xíáⁿ càchí‑yu sá nǐ xíhí‑dé ní cùu. ");
INSERT INTO milNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Te Jèsús ní tnɨɨ‑gá ndaha‑dé ní ndocani ñaha‑gǎ xii‑dé, te ní ndacóo‑dé ní nucúnutnɨ́ɨ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Te Jèsús cuándɨhu‑gá xɨtɨ́ vehe ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te òré ndéhé‑güedě ñá túú‑gǎ ñáyiu, te ní xícáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Cachí tnúhu xii‑ndɨ́ ná cuèndá ñá túú ní ndàcu‑ndɨ́ queñuhu‑ndɨ́ espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii tée‑ǎⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu‑í xii‑ndo sǎ nǔu òré cuìní‑ndó quèñuhu‑ndo espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu dàtná cúú espíritú cúndɨ̀hɨ‑xi yɨhɨ ñaha xii tée‑ǎⁿ ní cùu ña, te xìni ñuhu‑xi sá ǐo cáháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí te ñá túú tnàhí ná caxi‑ndo cǎháⁿ ndɨhɨ‑ndo‑gǎ, te ducaⁿ te ndacu‑ndo quèñuhu‑ndo espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Te Jèsús ní quee‑gá núú ndécú‑gǎ‑áⁿ ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá cuáháⁿ‑gá ndɨhɨ‑güedé distrìtú Galìleá, te cuìní‑gá sá vǎ quìní ñáyiu ndèé ichi cuáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Te ducaⁿ nǐ sani iní‑gá, chi mee‑gǎ sa nàha‑gá sá ndàá cada‑xi nàcuáa xǎhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá, te duha xǎhaⁿ‑gǎ xii‑güedé: —Yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo sáá ɨɨⁿ nduu te cuáha cuèndá ñáhá‑güedě xii‑í núú cuè tée cùu úhú iní ñáhá, te cahni ñaha‑güedě xii‑í, dico nduu úní sá cùú‑í te ndoto‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dico ñá túú tnàhí ni tècú tnùní‑güedé nása ndùu tnúhu ní cáháⁿ‑gá, te ni ñà túú ní cùyɨɨ‑güedé cácáⁿ tnúhú‑güedě núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Te Jèsús ní quexìo‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ñuú Capèrnaúm, te òré sa ndècu‑gá ɨɨⁿ vehe te ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ xii‑güedé: —¿Nándɨ cùu tnúhu ta xǐtnàha‑ndo véxi? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Dico ñá túú tnàhí ni cǎháⁿ‑güedé cúñaha‑güedě xii‑gá nǔu ná tnúhu xǐtnàha‑güedé òré ñúhú‑güedě ichi. Te ducaⁿ nǐ quide‑güedé chi cuèndá tá ndàtnúhu‑güedé nǔu ndědacàa‑güedé ío‑gá cúnùu. ");
INSERT INTO milNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Te Jèsús ní ngóo‑gá, te ní xáhaⁿ‑gǎ xii ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá: —Chí táquìxi iha te cundedóho‑ndo tnǔhu na càháⁿ‑í‑a. Te núu ìó dava‑ndo cuìní‑ndó cùnuu‑ndo, te cada‑ndo sǎ cúú‑ndó ñǎyiu nchìcúⁿ cuìí‑nǎ, te cunu cuechi‑ndo nǔú tnàha ñáyiu‑ndo —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Te Jèsús ní sanutnɨ́ɨ‑gá ɨɨⁿ té lǐhli cuádava tnuú‑güedé, te dǎtnùní ní nguɨ́dèhé ñáhá‑gǎ xii‑dé, te xǎhaⁿ‑gǎ xii‑güedé: ");
INSERT INTO milNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Nchaa ñáyiu na quèheⁿ cuendá ɨɨⁿ té lǐhli dàtná té lǐhli‑a cuèndá sá ñúhú ìní ñáhǎ‑yu xii‑í ñá, te cada iní‑yu sá yǔhú ní queheⁿ cuèndá‑yu. Te nchaa ñáyiu na quèheⁿ cuendá ñáhá xìi‑í te ñá dɨ́ú‑ní mèe‑í ní quèheⁿ cuendá‑yu, chi tnàhá Tǎtà‑í Dútú Ndiǒxí Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a ní queheⁿ cuèndá‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Te té Juàá dɨu‑ni ɨɨⁿ tée xìca cuu ndɨhɨ‑gá ní xáhaⁿ‑dě xii‑gá: —Mèstrú, ní xiní‑ndɨ́ ɨɨⁿ tée càcunehe ñaha‑dé xii‑n, te quèñuhu‑dé espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu, te nchúhú ñá túú ní dàña‑gá‑ndɨ́ ducaⁿ càda‑dé, chi ñá túú xìca cuu ndɨhɨ ñaha‑dé xii‑o —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Daña‑ndo na càda nahi‑dé ní cùu, chi ñá túú nì ɨɨⁿ ñáyiu ndɨ̌hɨ ndɨ̌hɨ‑ni ndacu cáháⁿ cuèhé cuèndá‑í te núu càcunehe ñahá‑yu xii‑í, te quìdé‑yu sá vǎ yǒo tnàhí ndàcu cada. ");
INSERT INTO milNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Te nchaa ñáyiu ñá túú cùu úhú iní ñáhá xìi‑o te cùndɨhɨ ñahá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Te na càchí tnúhu‑í xii‑ndo sǎ cuè ñáyiu na tàxi ɨɨⁿ yaxiⁿ ndute coho‑ndo cuendá sá cúú‑ndó cuè tée xìca cuu ndɨhɨ‑í, te ñáyiu‑áⁿ sǎá nduu te dacuéi sá nìhí‑yu sá ndúú tǎhǔ‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Te xǎhaⁿ tùcu Jesús xii‑güedé: —Te núu ɨɨⁿ tée na dàcaháⁿ‑dé cue ñáyiu sàndáá iní ñáhá xìi‑í cadá‑yu nándɨ sá cuèhé sá dúhá, te váha‑gá sá nǔu na dàcutu ndeé‑güedé ɨɨⁿ yúú yǒdó dǔcúⁿ‑dě, te dàquée ñaha‑güedě xii‑dé xɨtɨ́ ndute làmár, te ñá dɨ́ú sǎ cúndècu‑dé ducaⁿ càda‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Te núu ɨɨⁿ xio ndaha‑ndo quìde‑xi quide‑ndo nándɨ sá cuèhé sá dúhá, te quehndé‑ndó cuǐta‑xi, chi váha‑gá sá nánìhí tàhú‑ndó cuěi na cuǐta ɨɨⁿ xio ndaha‑ndo te ñá dɨ́ú sǎ quɨ̀hɨ́ⁿ‑ndó nɨ̀hií nɨ́ ndúú‑ndó nǔú ùhú núú ndàhú núú dìcó sàá ndáhá ìtá ñuhú nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Chi yàcáⁿ cúú‑xí nǔú ñà túú tnàhí ndàhvá ñuhú, te ío ndoho‑ndo cùndecu‑ndo xíáⁿ nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Te núu ɨɨⁿ xio sáhá‑ndó quìde‑xi quide‑ndo nándɨ sá cuèhé sá dúhá, te quehndé‑ndó cuǐta‑xi, chi váha‑gá sá nánìhí tàhú‑ndó cuěi na cuǐta ɨɨⁿ xio sáhá‑ndó, te ñá dɨ́ú sǎ quɨ̀hɨ́ⁿ‑ndó nɨ̀hií nɨ́ ndúú‑ndó nǔú ùhú núú ndàhú núú dìcó sàá ndáhá ìtá ñuhú nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Chi yàcáⁿ ñá túú tnàhí ndàhvá ñuhú, te ío ndoho‑ndo cùndecu‑ndo xíáⁿ nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te núu ɨɨⁿ xio tɨnùu‑ndo quide‑xi quide‑ndo nándɨ sá cuèhé sá dúhá, te tava‑ndo cuǐta‑xi, chi váha‑gá sá cúndècu‑ndo núú ndécú Yǎ Ndiǒxí táxí tnùní‑gá cuěi na cuǐta ɨɨⁿ xio tɨnùu‑ndo, te ñá dɨ́ú sǎ ndɨ̀ nduú xio núú‑ndó quɨ̌hɨ́ⁿ‑ndó nǔú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chi yàcáⁿ ñá túú tnàhí ndàhvá ñuhú, te ío ndoho‑ndo cùndecu‑ndo xíáⁿ nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Te dàtná quídé‑güedě quɨtɨ sàhni‑güedé chìhi‑güedé cuñú‑dɨ ñɨɨ́ te dàquée‑güedé núú ñùhú, ducaⁿ sǎtnahá‑xi ndoho cue ñáyiu chi ío ndohó‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Te ñɨ́ɨ́ chi ío váha nàndɨ́hɨ‑xi, dico núu na ndùu víxiⁿ‑xi te ñá túú‑gǎ nándɨ̌hɨ‑xi te ni ñà túú‑gǎ nása cada‑o ndùu úhá tucu‑xi. Te ío váha cada cuèndá‑ndó nàcuáa cundecu‑ndo cuèndá cuu‑ndo ñǎyiu váha, te ducaⁿ te cuu‑ndo dàtná ñɨ́ɨ́ sǎ ñà túú ndùu víxiⁿ, te ío váha cundecu ndɨhɨ tnàha‑ndo —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Te Jèsús ní xica‑gá cuáháⁿ‑gá ní yáha‑gá yucu distrìtú Jùdeá ní téhndé‑gá ndàa ɨngá xio yúte Jòrdán. Te yàcáⁿ ndécú‑gǎ ní tacá tucu cuéhé víhí ñǎyiu, te ní ngüíta‑ni tucu‑gá dánèhé ñáhá‑gǎ xií‑yu tnúhu‑gá chi ducaⁿ tnàhí quìde‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Te ní quèxio ɨɨⁿ úú cue tée cùu fariséú núú ndécú Jèsús xíto ndèé ñáhá‑güedě xii‑gá nǔu nása cunduu tnúhu cáháⁿ‑gá, te xǎhaⁿ‑güedě xii‑gá: —Véxi‑ndɨ́ xìcáⁿ tnúhú‑ndɨ̌ núú‑n nǔu cuu daña ɨ̀ɨⁿ tée ñadɨ̀hɨ́‑dé ǎⁿ ñǎhá —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te nchòhó, ¿nása ní cachí ndíi Moìsés cada‑ndo‑i? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Te ní xáhaⁿ‑güedě xii‑gá: —Ndíi Moìsés ní cachí ndíi sá cúú dàña ɨɨⁿ tée ñadɨ̀hɨ́‑dé dìcó‑ni sá cádǔha‑dé ɨɨⁿ tutú cuáñaha‑dě, te núú tùtú‑áⁿ codo tnùní sá nǐ dáñá ñàha‑dé, te ducaⁿ te cuu daña‑dě ñadɨ̀hɨ́‑dé —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te ducaⁿ nǐ chídó tnùní ndíi Moìsés cada‑ndo cuèndá sá ǐo sàá iní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dico Yá Ndiǒxí cútnàhá ní cadúha‑gá ñuyíú ndɨhɨ nchaa sá ìó, chi tée ñadɨ̀hɨ́ ní cadúha‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Te xíǎⁿ nǔu nchaa cue tée na nìhí ñadɨ̀hɨ́‑xi, te dɨ̀ɨⁿ‑ná cada‑güedé tǎtá‑güedě ndɨhɨ nǎná‑güedě, chi mee‑nǎ ñadɨ̀hɨ́‑güedé cuu cuu ndɨhɨ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Te cue ñáyiu úú‑áⁿ ñà túú‑gǎ ndɨ́ dɨ́ɨ́ⁿ ndɨ̀ dɨ́ɨ́ⁿ yɨ̀quɨ cuñú cúǔ‑yu, chi cada iní‑ndó sǎ ɨ́ɨ́ⁿ‑nǎ yɨquɨ cùñú cúǔ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Te xíǎⁿ nǔu ñá túú ndùu váha‑xi daña cuè tée ñadɨ̀hɨ́‑güedé, chi mee Yǎ Ndiǒxí ní cachí‑gá sá cúú ǔú‑yu cundecú‑yu ndéé naa ndéé cuú‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Te òré yɨ́hɨ́ Jèsús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá vehe, te ní xícáⁿ tnúhú‑güedě núú‑gǎ nása ndùu tnúhu ní cáháⁿ‑gá cuèndá cue ñáyiu dàña tnaha. ");
INSERT INTO milNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te núu ɨɨⁿ tée na dàña‑dé ñadɨ̀hɨ́‑dé te naqueheⁿ‑dé ɨngá ñadɨ̀hɨ́, te ío nèhé quídé‑dě, te ɨɨⁿ‑ni cuěchi cùu‑xi ndɨhɨ cuéchi quìde tée ndèca ñadɨhɨ́ te càháⁿ ndɨhɨ‑dé ɨngá ñadɨ̀hɨ́. ");
INSERT INTO milNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Te dɨu‑ni ducaⁿ sǎtnahá‑xi cùu tucu ñáyiu dɨ̀hɨ́ te núu na dàñá‑yu yɨɨ́‑yu te naquehéⁿ‑yu ɨngá tée, chi ɨɨⁿ‑ni cuěchi cùu‑xi sá quídě‑yu ndɨhɨ sá quídé cuè ñáyiu dɨ̀hɨ́ ndécú yɨ̀ɨ‑xi, te càháⁿ ndɨhɨ́‑yu ɨngá tée —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Te ɨɨⁿ ǔú ñáyiu ndècá‑yu landú lǐhli cuáháⁿ núú Jèsús, chi cuìní‑yu sá téndàha ñaha‑gá xii‑güexi. Te cue tée xìca cuu ndɨhɨ‑gá ní ngüíta‑güedé ténàá ñáhá‑güedě xií‑yu, te xǎhaⁿ‑güedě sá vǎ dúcáⁿ càdá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Te òré ní xiní‑gá sá dúcáⁿ quìde‑güedé, te ní cudééⁿ‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ xii‑güedé: —Chí dáñá ná quìxi nahi cue landú lǐhli‑áⁿ nǔù‑í‑a te vá càdɨ́‑ndó ìchi‑güexi, chi dàtná cúú vǎha iní cue landú lǐhli‑áⁿ ducaⁿ cùu váha iní cue ñáyiu yɨ̀ndaha Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nǔu vá quɨ̀ndáá iní ñáhá‑ndó dàtná quídé cuè landú lǐhli sàndáá iní ñáhá xìi‑í, te vá ndɨ̌hu ndaha ñàha Yá Ndiǒxí xii‑ndo —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Te sátá dúcáⁿ nǐ xáhaⁿ‑gǎ te ní nguɨ́dèhé‑gá cue landú‑áⁿ te ní tendaha ñàha‑gá xii‑güexi, te ní xícáⁿ táhú‑gǎ núú Yǎ Ndiǒxí cuèndá‑güexi. ");
INSERT INTO milNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Te òré sa ñùhu ichi Jesús caca‑gá quɨ́hɨ́ⁿ‑gá ɨngá xichi ni cùu ní quexìo cunu ɨɨⁿ tée ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú‑gǎ, te xǎhaⁿ‑dě xii‑gá: —Yòhó Mèstrú, cùu‑n tée ío váha iní‑xi, te cuìní‑í nǔu vá cúndèe iní‑n càchí tnúhu‑n nǎ cúú sǎ cádà‑í cuèndá nduu táhù‑í cundecu‑í ndɨhɨ Yá Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —¿Te cùtnuní iní‑n nàcuáa ndùu tnúhu càháⁿ‑n sǎ yǔhú váha iní‑ǎⁿ? Chi ɨɨⁿdìi díí‑ni Yá Ndiǒxí ío váha iní‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Te yòhó xìní‑n nàcuáa ní cachí Yǎ Ndiǒxí cada ñáyiu, te duha ní cachí‑gá: “Nchòhó cue tée vá càháⁿ ndɨhɨ‑ndo ñàdɨhɨ́ te núu ñá dɨ́ú ñàdɨhɨ́‑ndó cùú‑yu, te ducaⁿ‑ni nchòhó cue ñáyiu dɨ̀hɨ́ tucu vá càháⁿ ndɨhɨ‑ndo těe te núu ñá dɨ́ú yɨ̀ɨ‑ndo cuu‑güedé, te vá cáhní‑ndó tnàha ñáyiu‑ndo, te ni vǎ dúhú‑ndó sǎ ndécú ndɨ̀hɨ́‑yu, te ni vǎ dácàcu‑ndo cuéchi neñùú sá cúú‑xí tnàha ñáyiu‑ndo, te ni vǎ dácuàndehnde‑ndo, te canehe‑ndo sǎ yɨ́ñùhu núú tǎtá‑ndó ndɨ̀hɨ núú nǎná‑ndó”, duha ní cachí Yǎ Ndiǒxí cada ñáyiu —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Te tée‑áⁿ nǐ xáhaⁿ‑dě xii‑gá: —Mèstrú, nchaa xíǎⁿ ní ngüíta‑í quídè‑í ndéé cútnàhá cúú làndú‑í —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Te Jèsús ní xíndéhé ñàha váha‑gá xii‑dé, te ní cuu váha iní ñáhá‑gǎ, te ní xáhaⁿ‑gǎ xii‑dé: —Dico cùmání ɨ̀ngá núú sǎ cádá‑n. Vitna te quɨ́hɨ́ⁿ‑n te dico‑n nchàa sá ndécú ndɨ̀hɨ‑n, te díhúⁿ‑n cuǎha táhú‑n cuè ñáyiu ndàhú. Te ducaⁿ, te nduu táhú‑n nùcúndecu váha‑n nǔú ndécú Yǎ Ndiǒxí táxí tnùní‑gá, te sátá ná yǎha ducaⁿ càda‑n, te quixi‑n chìtnahá ñáhá‑n xìi‑í cuěi na ndòho‑n datná ndoho‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Te sá dúcáⁿ nǐ xáhaⁿ Jèsús xii‑dé te ío ní cundɨ̀yɨ́‑dé chi ío cuica‑dě, te ní xica‑dé cuánuhú‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Te ní ndacoto‑gá nɨ càndéé dɨ̀ñɨ‑gá, te ní xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá: —Cue ñáyiu cuica chi ío úhú quɨ́ndáá iní‑yu Yá Ndiǒxí cuèndá ndɨ́hu ndaha ñàha‑gá xií‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Te cue tée xìca cuu ndɨhɨ‑gá‑áⁿ ǐo ní cuñúhu‑güedé nàcuáa ní cáháⁿ‑gá, te ní xáhaⁿ tùcu‑gá xii‑güedé: —Nchòhó cue tée xìca cuu ndɨhɨ‑í càchí tnúhu tucu‑í xii‑ndo sǎ ǐo úhú quɨ́ndáá iní cue ñáyiu cuica Yǎ Ndiǒxí cuèndá ndɨ́hu ndaha ñàha‑gá xií‑yu, chi sàni iní‑yu sá ncháá sǎ ndécú ndɨ̀hɨ́‑yu dàcácu nihnu ñaha‑xi xìí‑yu núú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Te yáchí‑gá yáha ɨɨⁿ càméyu yaú ɨɨⁿ yɨquɨ tɨ̀cú dàcúúxí sǎ quɨ̀ndáá iní ɨɨⁿ ñáyiu cuica Yǎ Ndiǒxí cuèndá ndɨ́hu ndaha ñàha‑gá xií‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Te cue tée xìca cuu ndɨhɨ‑gá ní cuñúhu vìhi‑gá‑güedé sá dúcáⁿ nǐ cáháⁿ‑gá, te ní ngüíta‑güedé xǐtnàha‑güedé: —¿Te yoo sa ndacu naníhí tàhú te núu ducaⁿ vàíⁿ? —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Te Jèsús ní xíndéhé vǎha ñaha‑gǎ xii‑güedé, te ní xáhaⁿ‑gǎ: —Nchaa ñáyiu ñuyíú‑a chi vá ndácǔ‑yu ná cadá‑yu nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu, dico mee‑gǎ chi ndacu‑gá ndɨ́hu ndaha ñàha‑gá xií‑yu, chi nchaandɨ túhú sá vǎha ndàcu‑gá quídé‑gǎ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Te té Pèlú ní xáhaⁿ‑dě xii‑gá: —Nchúhú ní dándǒo‑ndɨ́ nchaandɨ túhú sá ndécú ndɨ̀hɨ‑ndɨ́ te ní tuha ñaha‑ndɨ̌ xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ ncháá ñǎyiu na dàndóo vehe‑xi, àdi ñaní‑xi, cúha‑xi, tǎtá‑xi, nǎná‑xi, déhe‑xi, àdi ñuhu‑xi, te núu ducaⁿ na càdá‑yu sá cuèndá‑í ndɨhɨ sá cuèndá tnúhu‑í, ");
INSERT INTO milNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","te ío‑gá cuéhé sǎ cuǎñaha Yǎ Ndiǒxí cundecu ndɨhɨ́‑yu, chi níhǐ‑yu vehé‑yu, ñuhú‑yu, ñaní‑yu, cúha‑yu, nǎnǎ‑yu, déhe‑yu, te ñá dɨ́ú‑ní sǎ nchàa xíǎⁿ níhǐ‑yu cundecu ndɨhɨ́‑yu, chi tnàhá nduu táhǔ‑yu cundecu ndɨhɨ ñàhá‑yu xii‑í nɨ caa nɨ quɨ́hɨ́ⁿ ná sàá nduu. Dico díhna‑gá ndoho tnahá‑yu núú ñuyíú‑a sá cuèndá‑í. ");
INSERT INTO milNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Te dava ñáyiu cùnuu ndecu ichi Yá Ndiǒxí vitna, ñáyiu‑áⁿ sǎá nduu te vá ǐo‑gá cunùú‑yu dàtná cúnùú‑yu vitna, te dava ñáyiu nchìcúⁿ ñá túú cùnuu vitna ñáyiu‑áⁿ sǎá nduu te ío cunùú‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Te ñùhu Jesús ichi ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá cuásaá ndɨhɨ ñaha‑gǎ xii‑güedé ñuú Jerusàlén, te yòdo nuu‑gá núú‑güedě cuásaá. Te cue tée‑áⁿ xǐcuñúhu‑güedé sá dúcáⁿ cuǎháⁿ‑gá ñuú Jerusàlén, te dava cue ñáyiu xǐnchícúⁿ xǐyùhú‑yu. Te ní taudɨ̀ɨⁿ‑gá ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá, te ní ngüíta‑gá cání‑gǎ cuèndú núú‑güedě nchaa nàcuáa yáha‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Te xǎhaⁿ‑gǎ xii‑güedé: —Vitna ñùhu‑o ichi cuásaá‑ó ñùú Jerusàlén, te yàcáⁿ cuáha cuèndá ñáhá‑güedě xii yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo núú cuè tée cùu dútú cúnùu, ndɨhɨ núú cuè tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés. Te dɨu cue tée‑áⁿ cǔñaha‑güedě xii dava‑gá cue tée sá cáhní ñàha‑güedé xii‑í, te cuáha cuèndá ñáhá‑güedě xii‑í núú cuè tée ñá túú cùu cue tée isràél. ");
INSERT INTO milNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Te cue tée‑áⁿ cudɨ́quɨ́ ndeé ñáhá‑güedě xii‑í, te caniha‑güedě ndɨhɨ ñɨɨ, te tɨú dɨɨ́ ñáhá‑güedě, te cahni ñaha‑güedě xii‑í dico nduu úní sá cùú‑í te ndoto‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Te cue déhe té Zebèdeú té Jàcobó ndɨhɨ té Juàá ní quexìo‑güedé núú Jèsús, te xǎhaⁿ‑güedě xii‑gá: —Mèstrú, véxi‑ndɨ́ càháⁿ ndàhú‑ndɨ́ núú‑n nǔu vá cúndèe iní‑n càda‑n ɨɨⁿ sá cuìní‑ndɨ́ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Te Jèsús ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xǎhaⁿ‑gǎ: —¿Ná cúú sǎ cuìní‑ndó càda‑í‑i? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Te ní xáhaⁿ‑güedě xii‑gá: —Cuìní‑ndɨ́ sá òré ná sàá nduu cùndecu‑n núú táxí tnùní‑n, te ɨɨⁿ‑ndɨ́ cunucóo‑ndɨ́ xio cùha‑n te ɨɨⁿ‑ndɨ́ cunucóo‑ndɨ́ xio dàtni‑n —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó, ñá túú cùtnuní iní‑ndó nàcuáa ndùu sá xìcáⁿ‑ndó nǔù‑í. ¿Te náa cundee ìní‑ndó dàndoho ñaha ñáyiu xii‑ndo dàtná dandòho ñahá‑yu xii‑í, te cundee tùcu iní‑ndó càhni ñahá‑yu xii‑ndo dàtná cahni ñàhá‑yu xii‑í‑ǎⁿ? —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Te ní xáhaⁿ‑güedě xii‑gá: —Cundee ìní‑ndɨ́ yáha‑ndɨ́ nchaa nàcuáa càháⁿ‑n‑ǎⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ndáá sá cúndèe iní‑ndó ndòho‑ndo nchaa nacuáa ndoho‑í, te cundee tùcu iní‑ndó càhni ñahá‑yu xii‑ndo, chi yúhú cahni ñàhá‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Dico sá dúcáⁿ cuìní‑ndó sǎ ɨ́ɨ́ⁿ‑ndó cùnucóo‑ndo xìo cuha‑í te ɨɨⁿ‑ndo cùnucóo‑ndo xìo datni‑í, te xíǎⁿ chi ñá dɨ́ú yǔhú tàú‑í cachí‑í te núu sá cúú cùnucóo‑ndo àdi sá vǎ cúú cùnucóo‑ndo, chi mee Tǎtà‑í Dútú Ndiǒxí cachí‑gá te núu ná cúú ñǎyiu nduu táhú cunucóo dɨ̀ñɨ‑í dàvá‑áⁿ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Te òré ní níhí ǔxí‑gá cue tée xìca cuu ndɨhɨ‑gá tnúhu nàcuáa ndùu sá cuìní té Jàcobó ndɨhɨ ñaní‑dé té Juàá, te ní cudééⁿ‑güedě núú cuè tée úú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Te Jèsús ní cana‑gá nchaa cue tée xìca cuu ndɨhɨ‑gá‑áⁿ, te ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó xìní‑ndó sǎ cuè tée yɨ̀ndaha ɨɨⁿ nacióⁿ quìde‑güedé sá ǐo cùnuu‑güedé, te nchaa dava‑gá cue tée cùndɨhɨ‑güedé tnàhá‑güedé quídé‑güedě sá ǐo cùnuu‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dico nchòhó chi vá dúcáⁿ càda‑ndo. Chi núu dava‑ndo cuìní‑ndó cùnuu‑ndo te xìni ñuhu‑xi cunu cuechi núú tnáhá‑ndó te vá cádá‑ndó sǎ cúnùu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Te núu dava‑ndo cuìní‑ndó quène cáva‑ndo, te cuu‑ndo dàtná cue ñáyiu ñá túú tnàhí dàñá quee núú chíúⁿ pàtróóⁿ‑xi cunu cuechi nǔú tnáhá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Te yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, chi ñá túú věxi‑í sá cúnú cuèchi ñáyiu núù‑í, chi véxi‑í sá cúnú cuèchi‑í núǔ‑yu. Te cuú‑í ñuyíú‑a cuèndá vàí‑yu cácu nihnu núú ùhú núú ndàhú —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Te Jèsús ní quexìo‑gá ñuú Jerìcó ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te ní yáha‑gá ndɨhɨ‑güedé ichi xɨtɨ́ ñuú‑áⁿ, te ío cuéhé ñǎyiu nchìcúⁿ ñáhá xìi‑gá cuáháⁿ te ɨɨⁿ xio yuhu ìchi sá nǐ quee xɨtɨ́ ñuú‑áⁿ núcǒo ɨɨⁿ tée cuàá nání‑dě Bartìmeú, te tǎtá‑dě nání‑dě Tìmeú, te tée‑áⁿ núcǒo‑dé yuhu ìchi‑áⁿ xìcáⁿ ndàhú‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Te tée‑áⁿ nǐ cutnùní iní‑dé sá Jèsús tée ñuú Nazàrét ñúhú‑dě ichi, te ní ngüíta‑dé níhi càháⁿ‑dé, te xǎhaⁿ‑dě xii‑gá: —¡Jèsús, ñaní tnáhá ndǐi Dàvií, cundàhú íní ñáhá xìi‑í! —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Te vài ñáyiu tènaá ñáhǎ‑yu xii‑dé, te xǎhǎⁿ‑yu sá ná càdɨ́‑dé yuhu‑dé dico uuⁿ‑gá níhi ní cáháⁿ‑dé xǎhaⁿ‑dě xii‑gá: —¡Jèsús, ñaní tnáhá ndǐi Dàvií cundàhú iní ñáhá xìi‑í! —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Te Jèsús ní ngüɨ́ñɨ́‑gá te ní xáhaⁿ‑gǎ xii cue tée ndɨhɨ‑gá: —Chí cuǎnguaca tée cuàá‑ǎⁿ candeca‑ndo‑dě quixi iha —càchí‑gá xǎhaⁿ‑gǎ. Te cue tée‑áⁿ nǐ xica‑güedé cuánguaca‑güedé tée cuàá‑áⁿ, te òré ní quexìo‑güedé núú‑dě te ní xáhaⁿ‑güedě xii‑dé: —Ndacuɨ́ñɨ́ te vá ndɨ̀hú‑gá iní‑n, na quɨ̀hɨ́ⁿ‑ó chi càna ñaha Jesús xii‑n —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Te tée‑áⁿ nǐ xócání‑dě dóó ndíxí‑dě, te ndɨ̌hɨ‑ni ní ndacuɨ́ñɨ́‑dé te ní xica‑dé cuáháⁿ‑dé núú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Te òré ní quexìo‑dé te ní xícáⁿ tnúhú‑gǎ núú‑dě, te xǎhaⁿ‑gǎ xii‑dé: —¿Ná cuìní‑n càda ñaha‑í xii‑n‑i? —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te tée cuàá‑áⁿ nǐ xáhaⁿ‑dě xii‑gá: —Mèstrú, cuìní‑í cada tátna‑n nǔù‑í cuèndá cundehe‑ǐ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Cuanùhú vitna, chi sa ní ndúha núú‑n chi ní sándáá iní‑n Yǎ Ndiǒxí —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te òré‑ni‑áⁿ nǐ ndúha núú‑dě te nchìcúⁿ‑dé Jèsús cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Te Jèsús ní cuyatni‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ñuú Bètaniá, ndɨhɨ ñuú Bètfagé, te xíáⁿ cáá yùcu nani Olívú, te yatni vií‑nǎ xíáⁿ cáá ñùú Jerusàlén. Te Jèsús ní cana‑gá úú‑ni tnàhá cue tée xìca cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Te ní xáhaⁿ‑gǎ xii‑güedé: —Chí cuàháⁿ ñuú cáá yàtni yacáⁿ, te òré quexìo‑ndo yacáⁿ te naníhí‑ndó ɨ̀ɨⁿ búrru ndètnɨ́ɨ‑dɨ, te vátá yǒo ɨɨⁿ‑gá codo ñàha xii‑dɨ, te nandaxi‑ndo‑dɨ te candeca‑ndo‑dɨ quìxi. ");
INSERT INTO milNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te núu yoo na càcáⁿ tnúhú nǔú‑ndó nǎ cuèndá nándàxi‑ndo‑dɨ, te cúñaha‑ndo sǎ yǔhú Yaá xícá cùu ndɨhɨ‑ndo xini ñuhu‑í‑dɨ, te na yǎha canehe chìuⁿ‑í‑dɨ te ndɨ̌hɨ‑ni natendaha‑ǐ‑dɨ, duha cúñaha‑ndo —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Te cue tée‑áⁿ nǐ xica‑güedé cuáháⁿ‑güedé, te òré ní quexìo‑güedé ñuú‑áⁿ te ní naníhí‑güedě ɨɨⁿ bǔrru ndètnɨ́ɨ‑dɨ ɨɨⁿ yutnu nìhnu yatni ɨɨⁿ yuyehe vehe caa yatni yuhu ichi, te ní ngüíta‑güedé nándàxi‑güedé‑dɨ. ");
INSERT INTO milNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Te mei òré nándàxi‑güedé‑dɨ ní quexìo ñáyiu xǎhǎⁿ‑yu xii‑güedé: —¿Ná cuèndá nándàxi‑ndo búrru‑áⁿ‑i? —càchí‑yu xǎhǎⁿ‑yu xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Te cue tée‑áⁿ nǐ xáhaⁿ‑güedě xií‑yu nàcuáa ní xáhaⁿ Jèsús cúñaha‑güedě. Te sátá dúcáⁿ te ní dáñǎ‑yu ndèca‑güedé bǔrru‑áⁿ cuǎháⁿ núú ndécú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Te òré ní quexìo‑güedé ndɨhɨ‑dɨ núú ndécú‑gǎ, te ní sacáⁿ ndodo‑güedé dóó‑güedě sátá‑dɨ, ní ngódó ñàha Jesús xii‑dɨ. ");
INSERT INTO milNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Te ío cuéhé ñǎyiu ta sàcáⁿ‑yu dóǒ‑yu ichi cuáháⁿ‑gá cuèndá núú dǒǒ‑yu‑áⁿ yǎha‑gá ndɨhɨ quɨtɨ yòdo‑gá, te davá‑yu xèhndé‑yu ndaha yùtnu ta sacáⁿ‑yu cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Te nchaa ñáyiu yòdo nuu núú‑gǎ ndɨhɨ nchaa ñáyiu nchìcúⁿ ndàa sátá‑gǎ ní ngüíta‑yu níhi càháⁿ‑yu, te càchí‑yu: —¡Ío càhnu cuu Yaá‑a! ¡Te Yá Ndiǒxí ná chìndee ñaha‑gá, chi dɨu‑gá cúú‑gǎ Yaá ní tendaha‑gǎ véxi quìde núú‑gǎ! ");
INSERT INTO milNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Te dɨu‑ni Yaá‑á cúú‑gǎ Yaá véxi quɨndaha ñàha xii‑o datná ní xóo cada ndíi Dàvií! ¡Te ndéé nchaa sá ìó andɨu na càchí‑xi sá ǐo càhnu cuu‑gá! —duha càchí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Te Jèsús ní quexìo‑gá ñuú Jerusàlén, te cuánguɨhu‑gá xɨtɨ́ veñúhu càhnu sá ǐo cùnuu, te ní xíndéhé vǎha‑gá nchaa sá ndécú xɨ̀tɨ́ veñúhu‑áⁿ. Te sátá dúcáⁿ te ní ndee‑gá cuáháⁿ‑gá ñuú Bètaniá ndɨhɨ ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá chi sa ní cuaa. ");
INSERT INTO milNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Te nduu tněé‑áⁿ nǐ quee Jèsús ñuú Bètaniá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te ichi ñùhu‑gá ní xíhí‑gá docó. ");
INSERT INTO milNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Te xica nǐ xiní‑gá nútnɨ̌ɨ ɨɨⁿ yutnu ngǔxí, te ní xica‑gá cuándéhé‑gǎ nǔu ndèé sávìdí‑xi te ñá túú nǎ ndèé, chi mee‑ni ndàha‑xi ndeé chi ñá dɨ́ú yǒó sácǔndeé sávìdí‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Te Jèsús ní xáhaⁿ‑gǎ xii yutnu ngǔxí‑áⁿ: —Vitna te vá yǒo ɨɨⁿ‑gá caxi sávìdí‑n, chi vá cúúⁿ‑gǎ —càchí‑gá xǎhaⁿ‑gǎ xii yutnu ngǔxí‑áⁿ. Te cue tée xìca cuu ndɨhɨ‑gá ní tecú dóho‑güedé nàcuáa ní xáhaⁿ‑gǎ xii yutnu ngǔxí‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Te Jèsús ní quexìo tucu‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ñuú Jerusàlén, te cuánguɨhu tucu‑gá xɨtɨ́ veñúhu càhnu sá ǐo cùnuu, te xɨtɨ́ veñúhu‑áⁿ xǐndecu cue ñáyiu quìde ndáhú nádìcó‑yu, ndɨhɨ cue ñáyiu xǐsaaⁿ. Te nchaá‑yu ní queñuhu ñaha Jèsús xií‑yu quehé, te ní dándùá‑gá mèsá cue ñáyiu dàma díhúⁿ, ndɨhɨ nchaa xìlé sácǒo nchihi cue ñáyiu dìco lómá xǐndecu xɨtɨ́ veñúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Te ñá túú tnàhí‑gá ní dàña‑gá yáha cue ñáyiu ndɨhɨ nchaa sá nchídǒ‑yu ichi xɨtɨ́ veñúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Te ní xáhaⁿ‑gǎ xií‑yu: —Núú tùtú Yǎ Ndiǒxí càháⁿ‑xi nàcuáa ní cáháⁿ‑gá, te ní cachí‑gá: “Vehe‑í cúú‑xí vèhe núú tàcá ñáyiu nɨhìí ñuyíú càháⁿ ndɨhɨ ñàhá‑yu xii‑í”, duha ní cáháⁿ‑gá càchí‑xi núú tùtú‑gá. Dico nchòhó quídé‑ndó vèhe‑gá vehe ñadúhú —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Te nchaa dútú cúnùu, ndɨhɨ nchaa cue tée dàcuaha ñaha xií‑yu nchaa tnúhu ní chídó tnùní ndíi Moìsés ní tecú dóho‑güedé nàcuáa ní cáháⁿ‑gá te ní ngüíta‑güedé ndúcú‑güedě nàcuáa cada‑güedé cahni ñaha‑güedě xii‑gá, chi yùhú‑güedé sá ǐo cunuu‑gǎ, te ducaⁿ chi nchaa ñáyiu ío cùñúhu‑yu nchaa tnúhu càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Te òré sa ní cuaa cuìí‑nǎ, te ní quee tucu Jèsús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ñuú Jerusàlén cuáháⁿ‑gá ndɨhɨ‑güedé ɨngá xichi. ");
INSERT INTO milNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Te nduu tněé nehé‑ni ní yáha tucu Jèsús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá núú níhnú yùtnu ngúxí, te ní xiní‑güedé sa ní yíchí nɨhìí ndéé yóho‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Te té Pèlú ní ndacu iní‑dé nàcuáa ní xáhaⁿ Jèsús xii yutnu ngǔxí‑áⁿ, te ní xáhaⁿ‑dě xii‑gá: —Mèstrú, cundehe nǎ ní yíchí yutnu ngǔxí sá nǐ xáhaⁿ‑n sǎ vǎ cúúⁿ‑gǎ sávìdí‑xi —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Quɨndáá ndisa iní‑ndó Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nǔu nchòhó cúñaha‑ndo xìi tɨndúú‑a xocuɨ̀ñɨ́‑xi núú ndécú‑xí, te quɨ́hɨ́ⁿ‑xi quée‑xi xɨtɨ́ làmár. Te dɨu ducaⁿ càda‑xi te núu nchòhó vá cání ɨ̀ɨⁿ cani úú iní‑ndó, te quɨndáá iní‑ndó sǎ dúcáⁿ càda‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Te xíǎⁿ nǔu càchí tnúhu‑í xii‑ndo sǎ nchàa sá ná càcáⁿ‑ndó nǔú Yǎ Ndiǒxí òré càháⁿ ndɨhɨ‑ndo‑gǎ, te taxi‑gá te núu nchòhó sàndáá ndisa iní‑ndó sǎ táxí‑gǎ sá xìcáⁿ‑ndó nǔú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Te òré càháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí te dandàcu iní‑ndó te núu ndècu ñáyiu ñá túú cùu váha iní ñáhá xìi‑ndo, te cada càhnu iní‑ndǒ‑yu cuèndá ducaⁿ càda cahnu iní ñáhá Tǎtá‑ndó Dǔtú Ndiǒxí Yaá ndécú àndɨu xii‑ndo cuendá nchaa sá ñà túú vǎha quìde‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Dico núu nchòhó vá cádá càhnu iní‑ndó sǎ quídé ñàha tnaha ñáyiu‑ndo xìi‑ndo, te ni Tǎtá‑ndó Dǔtú Ndiǒxí vá cádá càhnu iní ñáhá‑gǎ xii‑ndo cuèndá nchaa sá ñà túú vǎha quìde‑ndo —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Te Jèsús ní ndexìo tucu‑gá ñuú Jerusàlén ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te cuánguɨhu tucu‑gá xɨtɨ́ veñúhu càhnu sá ǐo cùnuu ndɨhɨ‑güedé. Te xɨtɨ́ veñúhu‑áⁿ yɨ́hɨ́‑gǎ ní quexìo cue dútú cúnùu ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél. ");
INSERT INTO milNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Te xǎhaⁿ‑güedě xii‑gá: —Cuìní‑ndɨ́ cachí tnúhu‑n xìi‑ndɨ́ nása ndùu tnúhu ndee ìní ndécú ndɨ̀hɨ‑n núu quìde‑n nándɨ sá quídé‑n, ¿te yoo ducaⁿ nǐ taxi tnúhu ndee ìní‑áⁿ xii‑n‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Yúhú tnàhá‑í cuìní‑í cácáⁿ tnúhu‑í ɨɨⁿ sá càcáⁿ tnúhu‑í núú‑ndó te núu na càchí tnúhu‑ndo, te cachí tnúhu‑í xii‑ndo yòo ní taxi tnúhu ndee ìní xii‑í duha quìde‑í. ");
INSERT INTO milNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Te chí càchí tnúhu xii‑í yoo ní táúchíúⁿ nǐ dácuándùte ndíi Juàá ñáyiu, ¿Yá Ndiǒxí ǎⁿ cuè tée ñuyíú‑a ní táúchíúⁿ dùcaⁿ ní quide ndíi? Te chí càchí tnúhu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Te ní ngüíta‑güedé xǐtnàha‑güedé: —¿Nása cúñaha‑o? Chi núu na cǔñaha‑o sǎ Yǎ Ndiǒxí ní táúchíúⁿ dùcaⁿ ní quide ndíi Juàá ñá, te quesaha‑dě: “¿Ná cuèndá ñá túú ní sàndáá iní‑ndó tnǔhu ní cáháⁿ ndíi vàiⁿ?”, quesaha‑dě. ");
INSERT INTO milNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te ni vǎ cúú cǔñaha‑o sǎ cuè ñáyiu ñuyíú‑a ní táúchíúⁿ dùcaⁿ ní quide ndíi Juàá —càchí‑güedé xǐtnàha‑güedé. Te ducaⁿ nǐ xítnàha‑güedé chi ñá túú ní cùtnuní iní‑güedé nása cúñaha‑güedě xii‑gá, chi xǐyùhú‑güedé cue ñáyiu chi nchaa ñáyiu‑áⁿ nǐ cutnùní ndáá iní‑yu sá Yǎ Ndiǒxí ní táúchíúⁿ‑gǎ ducaⁿ nǐ quide ndíi Juàá. ");
INSERT INTO milNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Te ní xáhaⁿ‑güedě xii Jèsús: —Ñá túú xìní‑ndɨ́ yoo ní táúchíúⁿ dùcaⁿ ní dácuándùte ndíi Juàá ñáyiu —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te núu ducaⁿ te ni yǔhú vá càchí tnúhu‑í xii‑ndo yòo ní taxi tnúhu ndee ìní duha quìde‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Te Jèsús ní ngüíta‑gá cání‑gǎ ɨɨⁿ cuèndú núú ñǎyiu nàcuáa tecú tnùní‑yu tnúhu‑gá, te xǎhaⁿ‑gǎ xií‑yu: —Ɨɨⁿ tée ní nacúxi‑dé mee‑ni yòho yaha stilé núú ñúhú‑dě, te ní chidoco‑dě cuèndá sá vǎ cúú dàñú, te ní cadúha‑dé núú quíhní‑dě ndéhé yoho yàha stilé‑áⁿ òré ná cùu, te ní cadúha‑dé ɨɨⁿ xíto dùcúⁿ núú cáúndòdo cue tée coto yoho yàha stilé‑áⁿ. ’Te ní sáá ɨɨⁿ nduu quèe‑dé quɨ́ngaca cuu xica‑dě vài nduu, te ní dándǒo ndaha‑dě sá nǐ xitu‑dé‑áⁿ xii ɨɨⁿ ǔú cue tée càháⁿ ndɨhɨ‑dé cuèndá cada chìuⁿ‑güedé, te ní ndatnúhu‑güedé sá òré ná cúú te cuu cuèndá dava‑güedé te ducaⁿ te ní quee‑dé cuáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Te sátá nǐ sáá nduu nǐ cuu ndéhé yoho yàha stilé sá nǐ xitu‑dé‑áⁿ, te ní xáhaⁿ‑dě xii ɨɨⁿ tée xìnu cuechi núú‑dě: “Cuàháⁿ cácáⁿ‑n sǎ cúú cuèndá‑í núú cuè tée ní dándǒo ndàha‑í nchaa yoho yàha stilé sá nǐ xitu‑í‑áⁿ”, càchí‑dé xǎhaⁿ‑dě. Te tée xìnu cuechi‑áⁿ nǐ xica‑dé cuáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Te cue tée‑áⁿ nǐ tnɨɨ‑güedé tée xìnu cuechi‑áⁿ, te ní caniha‑güedě xii‑dé, te dǎtnùní ní nacuícúⁿ ñáhá‑güedě, te ñá túú tnàhí ná ní sǎñaha‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Te tée cùu xítohó yoho yàha stilé‑áⁿ nǐ tendaha tùcu‑dé ɨngá tée xìnu cuechi núú‑dě cuáháⁿ‑dé. Te òré ní quexìo tée xìnu cuechi‑áⁿ te cue tée‑áⁿ nǐ sáha ñaha‑güedě yúú xii‑dé, te ní táhú‑güedě dɨ́quɨ́‑dě, te ní xícuèhé ñáhá‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Te tée cùu xítohó nchaa yoho yàha stilé‑áⁿ nǐ tendaha tùcu‑dé ɨngá tée xìnu cuechi núú‑dě cuáháⁿ‑dé núú cuè tée‑áⁿ, dico tée‑áⁿ òré ní quexìo‑dé te ní sahni ñaha‑güedě xii‑dé. Te tée cùu xítohó nchaa yoho yàha stilé‑áⁿ nǐ tendaha‑dě vài‑gá cue tée xìnu cuechi núú‑dě cuáháⁿ ngácáⁿ‑güedé sá cúú cuèndá‑dé ní cùu dico dɨu‑ni ducaⁿ nǐ quide ñaha tùcu cue tée ndèé nchaa yoho yàha stilé‑áⁿ xii‑güedé, chi dava‑güedé ní caniha‑güedě te dava‑güedé ní sahni ñaha‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Te tée cùu xítohó nchaa yoho yàha stilé‑áⁿ ndécú ɨ̀ɨⁿdii‑ná tée tendaha‑dě quɨ́hɨ́ⁿ núú cuè tée ní dándǒo ndaha‑dě sá nǐ xitu‑dé‑áⁿ, te tée tendaha‑dě‑áⁿ cúú‑dě déhe ducuⁿ‑dé, te ío cùu iní ñáhá‑dě. Te ní sani iní‑dé: “Váha‑gá nǔu tendaha‑ǐ déhe‑í‑a núhú‑dé, chi òré quiní ñáhá‑güedě xii‑dé te cànehe‑güedé sá yɨ́ñùhu núú‑dě”, duha ní sani iní‑dé. Te ducaⁿ te ní xáhaⁿ‑dě xii déhe‑dé‑áⁿ sǎ nùhú‑dé, te tée‑áⁿ cuǎnuhú‑dé cuáháⁿ ngácáⁿ‑dé sá cúú cuèndá tǎtá‑dě núú cuè tée‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Dico òré ní xiní cue tée quìde chiuⁿ‑áⁿ děhe tée cùu xítohó nchaa yoho yàha stilé‑áⁿ, te ní xítnàha‑güedé: “Tée‑ǎⁿ tée véxi nduu táhú ñuhu‑a ndɨhɨ sá cáá nǔú‑xi, dico cahni‑o‑dě te mee‑o ndùu táhú‑ó sǎ ndúú tǎhú‑dě”, duha ní xítnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Te ní tnɨɨ‑güedé tée‑áⁿ, te ní sahni ñaha‑güedě, te ní dáquéné‑güedě yɨquɨ cùñú‑dé ɨɨⁿ xio yuhu ñùhu núú cáá yòho yaha stilé‑áⁿ —duha cuáháⁿ cuèndú ní cani Jèsús núǔ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Te Jèsús ní xáhaⁿ tùcu‑gá xií‑yu: —¿Te nchòhó sa cùtnuní iní‑ndó nàcuáa cada xítohó ñuhu‑áⁿ ǎⁿ? Chi núhú‑dé te cahni‑dé cue tée‑áⁿ te dàndóo ndaha‑dě ñuhu‑dé xii cue tée cùtnuní iní‑dé cada ndáá —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Te xǎhaⁿ tùcu‑gá xií‑yu: —Te nchòhó, náa ñá túú dàcuaha‑ndo núú tùtú Yǎ Ndiǒxí núú càchí‑xi: Yúú sǎ nǐ dáquéé tɨ̌hú cue tée dàcaa vehe, ní cuu‑xi yúú cúnùu vitna. ");
INSERT INTO milNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chi mee Yǎ Ndiǒxí ducaⁿ nǐ cachí‑gá cunduu, te cùu‑xi ɨɨⁿ sá ǐo cùñúhu‑o vìtna. Duha càchí‑xi núú tùtú‑gá —càchí Jèsús xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Te cue tée ní xíndedóho nàcuáa ndùu tnúhu ní cáháⁿ‑gá ní cuiní‑güedé tnɨɨ ñaha‑güedě xii‑gá ní cùu, chi ní cutnùní iní‑güedé sá cuèndá‑güedé ní cáháⁿ‑gá, dico ní yùhú‑güedé tnɨɨ ñaha‑güedě xii‑gá cuèndá sá ǐo vài ñáyiu, te ná ìó ná cada ñàhá‑yu xii‑güedé ní sani iní‑güedé, te ní xica‑güedé cuáháⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Te sátá nǐ xica‑güedé cuáháⁿ‑güedé, te ní tendaha‑güedě ɨɨⁿ ǔú cue tée cùu fariséú, ndɨhɨ ɨɨⁿ ǔú cue tée cùndɨhɨ té Hèrodés cuáháⁿ‑güedé núú ndécú Jèsús ndúcú‑güedě nàcuáa cada‑güedé datɨ̀cánuu ñaha‑güedě xii‑gá núú tnǔhu càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Te cue tée‑áⁿ nǐ quexìo‑güedé núú Jèsús, te xǎhaⁿ‑güedě xii‑gá: —Mèstrú, cùtnuní iní‑ndɨ́ sá ǐo ndáá càháⁿ‑n, te ñá túú quìde cuendá‑n nàcuáa càháⁿ ñáyiu, te cuěi ndědani càá‑yu ɨɨⁿ‑ni càháⁿ‑n ndɨ̀hɨ́‑yu chi ñá túú quìde cuendá‑n cuěi ná ñáyiu cùú‑yu, te càháⁿ ndáá‑n nàcuáa càháⁿ Yǎ Ndiǒxí cundecu‑o ñùyíú‑a. Te cachí tnúhu xii‑ndɨ́ nǔu váha‑ni quìde‑ndɨ́ sá chǎhu‑ndɨ́ té Cèsár tée ío cùnuu cuendá impuèstú ǎⁿ ñǎhá —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dico Jèsús ní cutnùní iní‑gá sá xító ndèé ñáhá‑güedě xii‑gá, núu ní xáhaⁿ‑gǎ xii‑güedé: —¿Ná cuèndá ducaⁿ xìto ndeé ñáhá‑ndó xìi‑í? Chí dánèhé ñáhá xìi‑í ɨɨⁿ díhúⁿ sǎ chǎhu‑ndo cuèndá impuèstú te núu nása càa —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Te cue tée‑áⁿ nǐ dánèhé ñáhá‑güedě xii‑gá ɨɨⁿ díhúⁿ sǎ chǎhu‑güedé cuèndá impuèstú. Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí càchí tnúhu xii‑í nǔu yoo núú‑xi ndèé ndɨhɨ yoo dɨ̀u‑xi ndeé —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Núú tě Cèsár ndèé ndɨhɨ dɨ̀u‑dé —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te núu ducaⁿ te chí nácuǎha té Cèsár sá cúú cuèndá‑dé, te sá cúú cuèndá méé Yǎ Ndiǒxí te xíǎⁿ nacuáha‑ndo‑gǎ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te cue tée‑áⁿ ǐo ní cuñúhu‑güedé sá dúcáⁿ nǐ cáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Te sátá dúcáⁿ te ní quexìo ɨɨⁿ úú cue tée cùu saducéú núú ndécú Jèsús, te cue tée‑áⁿ ñǎ túú sàndáá iní‑güedé sá ndótó cuè ñáyiu ní xíhí, te ní xáhaⁿ‑güedě xii‑gá: ");
INSERT INTO milNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Mèstrú, ndíi Moìsés càchí ndíi núú tùtú ndíi ndècu vitna sá nǔu ɨɨⁿ tée na cùú‑dé te quendóo ñadɨ̀hɨ́‑dé, te núu ñá túú ní xǒo déhe‑dé ndɨhɨ ñadɨ̀hɨ́‑dé‑áⁿ, te tée cùu ñaní‑dé naqueheⁿ‑dé ñaha ní quendóo quèé‑áⁿ cuèndá coo déhe‑dé ndɨhɨ‑aⁿ cuèndá tée ní xíhí‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Te ní xíndecu úsá tnàhá cue tée mee‑ni ndɨ̀ ñaní‑güedé. Te tée díhna ní níhí ñadɨ̀hɨ́‑dé, te ñá túú ní cùdíi‑dé cundecu‑dé chi ní xíhí‑dé, te ni ɨ̀ɨⁿ déhe‑dé ñá túú ní xǒo ndɨhɨ ñadɨ̀hɨ́‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Te tée cùu uú ní naqueheⁿ‑dé ñaha ní quendóo quèé‑áⁿ, dico ní xíhí tucu‑dé, te ni ɨ̀ɨⁿ tucu déhe‑dé ñá túú ní xǒo ndɨhɨ ñaha‑áⁿ. Te dɨu‑ni ducaⁿ nǐ xíhí tée cùu uní. ");
INSERT INTO milNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Te ní xínu ndɨ ùsá‑güedé ní cándeca ñaha‑güedě xii ñaha‑áⁿ, dico ni ɨ̀ɨⁿ‑güedé ñá túú ní xǒo déhe‑güedé ndɨhɨ‑aⁿ, te ní ndɨhɨ‑güedé ní xíhí te ndéé núú nǐ ndɨhɨ‑ná ní xíhí tnàhá ñadɨ̀hɨ́‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Te na sàá nduu ndòto‑güedé ndɨhɨ ñaha‑ǎⁿ, ¿te ndědacàa‑güedé ñadɨ̀hɨ́‑güedé cuu‑aⁿ‑i? Chi ndɨ ùsá‑güedé ní cándeca ñaha‑güedě xii‑aⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ní xíta nchòhó tnúhu càháⁿ‑ndó, chi ñá túú xìní‑ndó nàcuáa càháⁿ Yǎ Ndiǒxí núú tùtú‑gá, te ni ñà túú xìní‑ndó sǎ dɨ́ú‑gǎ ndácú‑gǎ quídé‑gǎ nchaandɨ túhú sá vǎha. ");
INSERT INTO milNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Te na càchí tnúhu‑í xii‑ndo sǎ òré ná sàá nduu ndòto nchaa ñáyiu ní xíhí, te dàvá‑áⁿ vǎ yǒo‑gá dasaⁿ děhe yoco‑xi chi vá yǒo‑gá candeca tnàha, chi na ndòtó‑yu te cuu‑ná‑yu dàtná cue espíritú xínú cuèchi núú Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Te núu nchòhó cuìní‑ndó cǎháⁿ‑ndó cuèndá nchaa ñáyiu ndoto, te díhna‑gá dacuàha‑ndo nacuáa ní chídó tnùní ndíi Moìsés núú tùtú ndíi ni cùu. Chi dɨu núú tùtú ndíi càháⁿ‑xi nàcuáa ní xáhaⁿ Yǎ Ndiǒxí xii ndíi cútnàhá ní cáháⁿ ndɨhɨ ñaha‑gǎ ɨɨⁿ xichi núú níhnú tnùtaú nchìcúⁿ ñuhú. Te duha ní xáhaⁿ‑gǎ xii ndíi: “Yúhú cúù‑í Ndiǒxí tě Àbrahám, ndɨhɨ té Isàác, ndɨhɨ té Jàcób”, duha ní xáhaⁿ Yǎ Ndiǒxí xii ndíi càchí‑xi núú tùtú ndíi. ");
INSERT INTO milNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Te Yá Ndiǒxí ñá túú cùu‑gá Ndiǒxí cue ñáyiu ní xíhí, chi cùu‑gá Ndiǒxí cue ñáyiu xǐndecu vǐvú, núu xíǎⁿ nchòhó ío xǐta‑ndo tnǔhu càháⁿ‑ndó. Te sá dúcáⁿ nǐ cáháⁿ‑gá cuèndá cue tée‑áⁿ, te xíǎⁿ cútnùní sá cuěi ní xíhí‑güedé sá cúú‑xí tnàha ñáyiu‑güedé, dico ndècu vívú‑güedě sá cúú‑xí‑gǎ —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Te tnàhá ɨɨⁿ tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés ndèdóho‑dé nchaa tnúhu càháⁿ Jèsús ndɨhɨ cue tée cùu saducéú‑áⁿ, te ndèdóho‑dé sá sǔúní vǎha nìhí‑gá tnúhu nàdanchocáva‑gá. Te ní sándehe yatni‑dé núú‑gǎ, te xǎhaⁿ‑dě xii‑gá: —Cachí tnúhu xii‑í ndědacàa tnúhu sá nǐ cáháⁿ Yǎ Ndiǒxí ío‑gá cúnùu cuu díhna —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Duha càháⁿ tnúhu sá ǐo‑gá cúnùu: “Nchòhó ñáyiu isràél ío váha chí cúndèdóho tnúhu‑a. Ɨɨⁿdìi díí‑ni Yá Ndiǒxí ndécú, te dɨu‑ni‑gá cúú‑gǎ Ndiǒxí‑ó. ");
INSERT INTO milNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Te cuu iní‑ndó Dǔtú Ndiǒxí Yaá cúú Ndiǒxí‑ndó nɨ̀ yuhu nɨ iní‑ndó, te cani iní‑ndó càda‑ndo datná cuìní méé‑gǎ, te mee‑ni tnǔhu váha cani iní‑ndó cuèndá cuu vii cuu váha‑ndo nǔú‑gǎ, te coo iní‑ndó càda‑ndo nacuáa cuu váha iní‑gá”, duha càháⁿ tnúhu sá ǐo‑gá cúnùu. ");
INSERT INTO milNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Te duha càháⁿ tucu ɨngá tnúhu cùu uú sá ǐo cùnuu: “Cuu iní‑ndó tnàha ñáyiu‑ndo dàtná cúú ìní‑ndó mèe‑ndo”, duha càháⁿ tnúhu cùu uú‑áⁿ. Te úú duha‑ni tnúhu‑a cùu‑xi tnúhu sá ǐo‑gá cúnùu —cachí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Te tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés ní xáhaⁿ‑dě xii‑gá: —Mèstrú, váha‑ni càháⁿ‑n chi ndáá sá ɨ̀ɨⁿdii‑ni Yá Ndiǒxí ndécú, te ñá túú‑gǎ ndèé ndécú ɨ̀ngá ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Te dàtná ní cachí‑n sǎ nɨ̀ yuhu nɨ iní‑ó cùu iní‑ó Yǎ Ndiǒxí, te cani iní‑ó càda‑o nacuáa cuu vii cuu váha iní‑gá te ío vii ío váha cuu iní‑ó dàtná cuìní méé‑gǎ, te coo iní‑ó càda‑o nacuáa cuu váha iní‑gá, te cuu iní‑ó cuè tnaha ñáyiu‑o dàtná cúú ìní‑ó mèe‑o. Te nchaa xíǎⁿ ío‑gá xíní ñùhu‑xi cada‑o dacúúxí sǎ cuǎñaha‑o quɨ̀tɨ cahni‑güedé te cáyú‑dɨ nduu táhú ñáhá Yǎ Ndiǒxí, ndɨhɨ dàcúúxí nchàa dava‑gá sá sǎñaha‑o ndùu táhú‑gǎ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Te sá dúcáⁿ ǐo váha ndùu tnúhu ní cáháⁿ tée‑áⁿ, núu ní xáhaⁿ Jèsús xii‑dé: —Luha‑ná cúmǎní xii‑n te ndɨ́hu ndaha ñàha Yá Ndiǒxí —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te sá dúcáⁿ nǐ xáhaⁿ‑gǎ xii tée‑áⁿ, núu vá yǒo ɨɨⁿ‑gá ní cùyɨɨ nágá tnúhu nducu tnǔhu‑yu núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Te Jèsús yɨ́hɨ́‑gǎ xɨtɨ́ veñúhu càhnu sá ǐo cùnuu danehé‑gá ñáyiu, te xǎhaⁿ‑gǎ xií‑yu: —Cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés càchí‑güedé sá Crìstú Yaá tendaha Yǎ Ndiǒxí quixi ñuyíú‑a cùu‑gá déhe ndíi Dàvií, te ndíi‑áⁿ nǐ cunaha vìhi ní xíhí ndíi. ¿Te ná cuèndá ducaⁿ càháⁿ‑güedé? ");
INSERT INTO milNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Te mee ndǐi Dàvií‑áⁿ nǐ dácáhú ìní ñáhá Espíritú Yǎ Ndiǒxí xii ndíi nàcuáa cáháⁿ ndíi, te duha ní cachí ndíi: Dútú Ndiǒxí ní xáhaⁿ‑gǎ xii Yaá cúú Xǐtohó‑í: “Ngóo xio cùha‑í, te yúhú cada‑í te nchaa sá cúú ǔhú iní ñáhá xìi‑n canehe‑xi sá yɨ́ñùhu núú‑n.” Duha ní xáhaⁿ Dǔtú Ndiǒxí xii Yaá cúú Xǐtohó‑í. Duha ní cachí ndíi. ");
INSERT INTO milNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Te nása cùu Cristú déhe ndíi Dàvií, te mee ndǐi ní cachí ndíi sá cúú‑gǎ Xítohó ndíi? —càchí Jèsús xǎhaⁿ‑gǎ xií‑yu. Te ío cuéhé ñǎyiu ní xíndedóho nchaa tnúhu ní cáháⁿ‑gá, te ío ní cudɨ́ɨ́ ìní‑yu ní xíndedóho ñàhá‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Te òré dánèhé ñáhá Jèsús xii cue ñáyiu, te xǎhaⁿ‑gǎ xií‑yu: —Cada cuèndá‑ndó vǎ cádá‑ndó dàtná quídé cuè tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, chi cue tée‑áⁿ tnàhá iní‑güedé cuihnu‑güedé dóó nání sǎ sácuǐhnu cue tée cùnuu‑gá te cuìní‑güedé sá méé‑ní ndɨ̀hɨ tnúhu yɨñùhu cáháⁿ ndɨhɨ ñaha ñáyiu xii‑güedé nchaa núú xícá cùu‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Te nàcáxi‑güedé xìlé sácǒo nchihi cue tée cùnuu‑gá xɨtɨ́ veñúhu sàcóo nchihi‑güedé. Te ducaⁿ‑ni quìde‑güedé cuěi òré quɨ́hu‑güedé mèsá caxi‑güedé òré ndécú‑güedě ɨɨⁿ vico, chi mee‑ni nǔú sácǒo cue tée cùnuu cuiní‑güedé coo‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Te quèndeé‑güedé vehe nchaa ñáyiu quèé, te ío naha càháⁿ ndɨhɨ‑güedé Yǎ Ndiǒxí dàndahú‑güedé méé‑güedě sá ǐo quìde ndáá‑güedé cuèndá sá cuìní‑güedé cáháⁿ váha ñáyiu cuèndá‑güedé. Te sá dúcáⁿ quìde‑güedé te ío‑gá ndoho‑güedé núú ùhú núú ndàhú dàcúúxí dàva‑gá ñáyiu —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Te nùcóo Jèsús xɨtɨ́ veñúhu yatni núú ndécú àlcanciá te ndèhe‑gá xǐdáquěe ñáyiu díhúⁿ xɨtɨ́ alcancìá‑áⁿ, te tnàhá cue ñáyiu cuica xǐdáquěe‑yu vài díhúⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Te ní quexìo ɨɨⁿ ñaha ndahú ñaha quèé, te ndèhe‑gá ní dáquěe‑aⁿ úú tnàhá díhúⁿ còbrí xɨtɨ́ alcancìá, te díhúⁿ‑ǎⁿ ǐo sacú yáhu‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Te Jèsús ní cana‑gá cue tée xìca cuu ndɨhɨ‑gá, te ní xáhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ ñàha ndahú ñaha quèé‑a ío‑gá nándɨ̌hɨ díhúⁿ nǐ dáquěe‑aⁿ xɨtɨ́ alcancìá dàcúúxí dǐhúⁿ nǐ dáquěe dava‑gá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chi nchaa ñáyiu‑áⁿ nǐ dáquěe‑yu mee‑nǎ díhúⁿ sǎ nǐ quendóo‑ná, dico ñaha quèé‑a cuěi ndàhú‑aⁿ dico ní dáquěe‑aⁿ nɨhìí díhúⁿ sǎ cuááⁿ sǎ cáxí‑áⁿ ní cùu —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Te òré ní ndee Jèsús xɨtɨ́ veñúhu càhnu sá ǐo cùnuu, te ɨɨⁿ tée xìca cuu ndɨhɨ‑gá ní xáhaⁿ‑dě xii‑gá: —¡Mèstrú, cundehe nǎ ío vii ní sáá veñúhu‑aⁿ ndɨhɨ nchaa vehe nèhe tnaha ndɨhɨ‑xi, te ío vii ndǎa nchaa yúú yɨ́hɨ́! —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Nchaa nàcuáa càa nchaa vehe sá cúñǔhu‑n‑a vìtna sáá nduu te vá cúndùu‑gá‑xi dàtná cáá‑xí vìtna, chi ni ɨ̀ɨⁿ‑gá yúú vǎ códó nchìhi tnaha‑xi, chi ndɨhɨ ngoyo —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Te Jèsús ní xica‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá cuáháⁿ ndɨhɨ ñaha‑gǎ xii‑güedé yucu nàni Olívú, te yucu Òlívú‑áⁿ tǔu ndáá núú cáá vèñúhu càhnu sá ǐo cùnuu. Te Jèsús ní quexìo‑gá ndɨhɨ‑güedé yucu Òlívú‑áⁿ, te xíáⁿ nǐ ngóo‑gá te núú núcǒo‑gá‑áⁿ nǐ sáháⁿ té Pèlú ndɨhɨ té Jàcobó ndɨhɨ té Juàá ndɨhɨ té Ndrǐxí, te dayuhu nǐ xáhaⁿ‑güedě xii‑gá: ");
INSERT INTO milNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Cuìní‑ndɨ́ cachí tnúhu‑n nǎ nduu dùcaⁿ cada‑xi ngoyo veñúhu càhnu sá ǐo cùnuu, àdi nándɨ cùu sá cádá‑xí cuèndá cutnùní iní‑ndɨ́ sá sà ta cuyatni nduu ducaⁿ cada‑xi —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ío quɨhɨ iní‑ndó cùndecu‑ndo cuendá sá vǎ yǒo dandàhú ñáhá xìi‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Chi ío cuéhé cue tée coo ñuyíú te danàni‑güedé méé‑güedě dàtná nánì‑í, te cachí‑güedé: “Yúhú cúù‑í Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a”, duha cachí‑güedé. Te sá dúcáⁿ cǎháⁿ‑güedé te ío vài ñáyiu dandàhú‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Te òré ná nìhí‑ndó tnǔhu sá nàá‑güedé nděni ní cuu, te vá yùhú‑ndó chi dacuɨtɨ́í sǎ dúcáⁿ càda‑xi, dico vátá sàá‑gá nduu nàa ñuyíú òré ducaⁿ càda‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chi cue tée ɨɨⁿ nàcióⁿ nàá‑güedé ndɨhɨ cue tée ɨngá nàcióⁿ, te tɨtnɨ́ ñuú ngüíta‑güedé nàá‑güedé, te tɨtnɨ́ xichi ñuyíú nǐhi vìhi tnáa, te tɨtnɨ́ tucu xichi ñuyíú coo tnamá, te ío‑gá cuéhé sǎ yǎha ñáyiu. Te nchaa sá dúcáⁿ càda‑xi‑áⁿ cúú‑xí tnǔndòho sá vítná vǎha váha quèsaha‑xi sácúú‑xí cuè ñáyiu ndècu ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Dico nchòhó ío quɨhɨ iní‑ndó cùndecu‑ndo, chi nchaa ñáyiu na cùu úhú iní ñáhá xìi‑ndo cuáha cuèndá ñáhǎ‑yu xii dava‑ndo nǔú cuè tée cùchiuⁿ, te candeca ñaha‑güedě xii‑ndo quɨ̌hɨ́ⁿ xɨtɨ́ veñúhu‑güedé, te yàcáⁿ caniha‑güedě xii‑ndo. Te quɨ́hɨ́ⁿ‑ndó nǔú cuè tée yɨ̀ndaha nacióⁿ àdi núú dàva‑gá cue tée cùnuu sá cuèndá‑í, te nchòhó níhí‑ndó nàcuáa cada‑ndo cǎháⁿ váha‑ndo cuèndá‑í núú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Te cùmání‑gǎ sáá nduu nàa ñuyíú‑a te sa cuténuu tnúhu‑í nɨ càa xico ñuyíú‑a, te tnúhu‑áⁿ càháⁿ‑xi nàcuáa naníhí tǎhú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Te òré ná càndeca ñaha ñáyiu xii‑ndo quɨ̌hɨ́ⁿ núú cuè tée cùchiuⁿ cuáha cuèndá ñáhǎ‑yu, te òré vátá sàá‑gá‑ndó nǔú‑güedě te vá cání ìní‑ndó nǔu nása cunduu tnúhu cúñaha‑ndo xìi‑güedé. Chi òré‑nǎ te Yá Ndiǒxí dacàhu iní ñáhá‑gǎ xii‑ndo nǎsa cunduu tnúhu cúñaha‑ndo xìi‑güedé, te dɨu‑ni tnúhu sá dácàhu iní ñáhá‑gǎ‑áⁿ cǔñaha‑ndo xìi‑güedé. Te ñá dɨ́ú mèe‑ndo cáháⁿ‑ndó chi Espíritú Yǎ Ndiǒxí cáháⁿ‑xi yuhu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Te dava cue tée cuáha cuèndá‑güedé ñaní‑güedé núú cuè tée cùchiuⁿ cuendá cahni ñaha‑güedě. Te dava cue tée cùu tátá dɨu‑ni ducaⁿ càda‑güedé cuáha cuèndá‑güedé déhe‑güedé núú cuè tée cùchiuⁿ. Te dava cue tée cùu déhe cuu úhú iní‑güedé tǎtá‑güedě ndɨhɨ nǎná‑güedě, te cuáha cuèndá ñáhá‑güedě xií‑yu núú cuè tée cùchiuⁿ cuendá cahni ñaha‑güedě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Te ío cuéhé ñǎyiu cuu úhú iní ñáhǎ‑yu xii‑ndo sǎ cuèndá‑í, dico nchaa nchòhó ñáyiu na càda ndee‑ni iní canchicúⁿ nihnu ñaha‑ni xìi‑í te naníhí tàhú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Te ndíi Dàniél tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǐ chídó tnùní ndíi núú tùtú ndíi cuèndá ɨɨⁿ sá dáquèe tɨ́hú Yǎ Ndiǒxí cundecu ɨɨⁿ xichi núú ñà túú tàú‑xi cundecu‑xi, te xíǎⁿ cada‑xi sá vǎ cúndècu‑gá ni ɨ̀ɨⁿ ñáyiu xíáⁿ. Te cada cuèndá váha‑ndo nàcuáa ní cáháⁿ ndíi, chi nduu na quìní‑ndó xǐǎⁿ cundecu‑xi ɨɨⁿ xichi núú ñà túú tàú‑xi cundecu‑xi, te dàvá‑áⁿ nchaa ñáyiu xǐndecu distrìtú Jùdeá xíní ñùhu‑xi cunú‑yu quɨ́hɨ́ⁿ‑yu xɨtɨ́ yucu. ");
INSERT INTO milNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Te nchaa ñáyiu ndáa ndódó dɨ̀quɨ́ véhé‑xí vǎ ndɨ̌hu‑gá‑yu vehé‑yu quehéⁿ‑yu ɨɨⁿ ndachìúⁿ‑yu canehé‑yu quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Te nchaa ñáyiu cuáháⁿ yucu ni vǎ nùhú‑gá‑yu vehé‑yu cúnúquehéⁿ‑yu dóǒ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Te ndàhú ní cuu nchaa ñáyiu dɨ̀hɨ́ ñúhú děhe‑xi, ndɨhɨ cue ñáyiu dɨ̀hɨ́ xǐndeca déhe vitna sàdi na saá nduu dùcaⁿ cada‑xi! ");
INSERT INTO milNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Te nchòhó ío chí càcáⁿ táhú nǔú Yǎ Ndiǒxí cuèndá sá vǎ dúcáⁿ ndòho‑ndo yóó quídé vǐxiⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chi dàvá‑áⁿ coo tnúndòho cahnu vihi ñuyíú, te vátá ɨ́ɨ́ⁿ ndùu‑gá coo tnúndòho cahnu vihi‑áⁿ nděé cútnàhá ní cadúha Yá Ndiǒxí ñuyíú, chi dɨu‑ni dàvá‑áⁿ coo tnúndòho cahnu vihi‑áⁿ, te ni nǔú cuàháⁿ núú věxi vá cóó‑gǎ tnúndòho‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Te Yá Ndiǒxí càchí‑gá sá vǎ ǐo vài nduu coo tnúndòho cahnu vihi‑áⁿ ñuyíú sǎ cuèndá nchaa ñáyiu ní cáháⁿ‑gá cundecu ndɨhɨ‑gá. Te núu vài nduu na coo tnúndòho‑áⁿ, te vá yǒo cácu nihnu. ");
INSERT INTO milNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Te dàvá‑áⁿ cǔñaha ñǎyiu xii‑ndo: “Chí cúndèhe iha, chi iha ní quexìo Cristú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a”, duha cúñàhá‑yu xii‑ndo. Àdi quesahá‑yu: “Chí cúndèhe yacáⁿ chi yàcáⁿ ndécú‑gǎ”, quesàhá‑yu. Te vá quɨ̀ndáá iní‑ndó tnǔhu càháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Te coo cue tée danàni‑güedé méé‑güedě dàtná nánì‑í te cachí‑güedé sá cúú‑güedě Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a. Te dava‑güedé cachí‑güedé sá cúú‑güedě cue tée càháⁿ tnúhu Yá Ndiǒxí dico ñá ndàá sá cúú‑güedě cue tée càháⁿ tnúhu‑gá, te cada‑güedé tɨtnɨ́ núú sǎ vǎ yǒo tnàhí ndàcu cada cuendá dandàhú‑güedé ñáyiu, te cani iní‑güedé dandàhú‑güedé ndéé cue ñáyiu ní cáháⁿ Yǎ Ndiǒxí cundecu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Te vitna ío váha cuáha‑ndo cuèndá, te quɨhɨ iní‑ndó cùndecu‑ndo, chi nchaa sa ní dátǔha ñaha‑ǐ xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Te nà yáha‑ni coo tnúndòho cahnu vihi‑áⁿ, te vá dáyèhé‑gá nchícanchii te ni vǎ dáyèhé‑gá yóó. ");
INSERT INTO milNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Te ngoyo nchaa chódíní ndèé andɨu, te quɨdɨ‑xi andɨu. ");
INSERT INTO milNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Te dàvá‑áⁿ quiní ñáhá nchàa ñáyiu xii yúhú Tée cùu ñaní tnáhǎ‑yu nchaá‑yu quee‑í andɨu quìxi‑í ichi xɨtɨ́ vícó, te quiní‑yu sá ǐo càhnu cuu‑í, te quìde‑í nchaa sá vǎha. ");
INSERT INTO milNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Te tendaha‑ǐ cue espíritú xínú cuèchi núù‑í quɨ́hɨ́ⁿ‑xi nadatàcá‑xi nchaa ñáyiu ní cáháⁿ‑í chitnahá ñáhá xìi‑í xǐndecu nɨ càa xico ñuyíú. ");
INSERT INTO milNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Te cundehe‑ndo nàcuáa quìde yutnu ngúxí, chi yutnu‑áⁿ ndúú yùte núú dìté‑xi te nàtahú ndaha‑xi, te òré ducaⁿ quìde‑xi te càchí‑ndó sǎ sà ní cuyatni nuu cahni. ");
INSERT INTO milNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Te ducaⁿ sǎtnahá‑xi cada‑xi òré ná quìní‑ndó càda‑xi nchaa nacuáa ní cáháⁿ‑í, te cutnùní iní‑ndó sǎ sà ní cuyatni vií‑nǎ nduu nàa ñuyíú. ");
INSERT INTO milNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ òré vátá cùú‑gá cue ñáyiu xǐndecu ñuyíú‑a vitna, te cada‑xi nchaa nàcuáa ní cáháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Te andɨu ndɨ̀hɨ ñuyíú‑a chi ndɨhɨ nihnu‑xi, dico tnúhu‑í chi vá ndɨ́hɨ́ nìhnu‑xi chi cùu‑xi tnúhu ndáá. ");
INSERT INTO milNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Dico ñá túú cùtnuní ná nduu quìxi tucu‑í, te ni ñà túú cùtnuní ná òré chi vá yǒo xìní, te ni cuè espíritú xínú cuèchi núú Yǎ Ndiǒxí ñá túú xìní‑xi ná nduu quìxi‑í, te ni mèe yúhú tée cùu Déhe Dútú Ndiǒxí ñá túú xìní‑í ná nduu quìxi tucu‑í, chi ɨɨⁿdìi díí‑ni mee Tǎtà‑í Dútú Ndiǒxí xìní‑gá nǔu ná nduu quìxi‑í. ");
INSERT INTO milNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Te nchòhó xíní ñùhu‑xi sá ǐo quɨhɨ iní‑ndó cùndecu‑ndo, te cáháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí, chi ñá túú xìní‑ndó nǎ nduu quìxi tucu‑í. ");
INSERT INTO milNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Te na càchí tnúhu‑í xii‑ndo cuèndá ɨɨⁿ tée cuìní quɨ́ngaca cuu xica. Te tée‑áⁿ cùmání‑gǎ quee‑dé vehe‑dé te ní xáhaⁿ‑dě xii cue tée xìnu cuechi núú‑dě sá ná cádá cuèndá‑güedé vehe‑dé. Te ní sáñaha‑dě xii‑güedé ndɨ́ dɨ́ɨ́ⁿ nǔú‑güedě chìuⁿ cada‑güedé. Te ní xáhaⁿ‑dě xii tée ndèé yuyèhe sá ná cùndecu túha‑ni‑dé yuyèhe ndéé nàsáá‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Te duha ndùu tnúhu càháⁿ‑í cuèndá nchòhó cundecu túha‑ndo, chi ñá túú xìní‑ndó nǎ nduu te ni ñà túú xìní‑ndó nǎ òré quixi tucu yúhú Yaá cúú Xǐtohó‑ndó, núu òré sa ní cundɨquɨⁿ, àdi dava niú, àdi oré sa ní cana uuⁿ lǐhi, àdi oré sa ta cùditó cuáháⁿ, núu xíǎⁿ ío chí cúndècu túha. ");
INSERT INTO milNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Te duha càháⁿ‑í chi na cuáháⁿ òré ñá túú nǎ yɨ́hɨ́ ìní‑ndó quèxio‑í, te ñá túú ndècu túha‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Te dàtná‑ni xǎhaⁿ‑ǐ xii nchòhó sá cúndècu túha‑ndo, te dɨu‑ni ducaⁿ xǎhaⁿ‑ǐ xii nchaa dava‑gá ñáyiu sá cúndècu túha‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Te cùmání ǔú‑gá nduu te quesaha vìco pascuá, vico xèxi ñáyiu pàá sá ñà túú yɨ̀hɨ levadurá. Te cue dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés ndúcú‑güedě nàcuáa cada‑güedé dandàhú‑güedé Jèsús cuèndá tnɨɨ ñaha‑güedě xii‑gá te cahni ñaha‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Te ní xítnàha‑güedé: —Váha‑gá sá vǎ tnɨ́ɨ́‑ó Jèsús mei ndùu vico, chi núu ducaⁿ na càda‑o te ío dusaⁿ càda ñáyiu —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Te Jèsús ndécú‑gǎ ñuú Bètaniá vehe ɨɨⁿ tée nàni Xímú, tée ní tnahá cuéhé sǎ dátèhyú nihnu‑xi yɨquɨ cùñú‑ó. Te yɨ̀hɨ Jesús mèsá xéxí‑gǎ ní quexìo ɨɨⁿ ñadɨhɨ́ néhé‑áⁿ ɨ̀ɨⁿ sá nǐ cuáha yúú vǎha yúú nání àlabastrú, te xɨtɨ́ xíǎⁿ ñúhú àcití sàháⁿ tnámí sǎ nání nǎrdú sá ǐo ndèyáhu, te ní táhú‑áⁿ xǐǎⁿ te acìtí ñúhú xɨ̀tɨ́‑xi‑áⁿ nǐ sódó‑aⁿ dɨ́quɨ́ Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Te ɨɨⁿ ǔú cue tée xǐndecu‑áⁿ nǐ cudééⁿ‑güedě sá dúcáⁿ nǐ quide‑aⁿ, te ní xítnàha‑güedé: —Ñá túú quìde váha ñaha‑ǎⁿ dàcáⁿ quídé‑áⁿ, chi íí nǐ dácuǐta‑aⁿ acìtí váha‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chi váha‑gá nǔu cuyáhu acìtí‑ǎⁿ sá ùní cièndú díhúⁿ denàriú, te díhúⁿ sǎ cúyǎhu acìtí‑ǎⁿ cuu cuèndá ñáyiu ndàhú ní cùu —cachí‑güedé xǐtnàha‑güedé. Te ní tenàá‑güedé ñaha‑áⁿ sǎ dúcáⁿ nǐ quide‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí dáñá, vá dásàtú‑ndó ìní ñadɨ̀hɨ́‑a, chi sá nǐ quide ñaha‑aⁿ xìi‑í cúú‑xí ɨ̀ɨⁿ sá vǎha. ");
INSERT INTO milNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Chi cue ñáyiu ndàhú ducaⁿ‑ni cùtnahá ñáyiu‑áⁿ tnuú‑ndó, te náni òré càchí iní‑ndó te chindee‑ndǒ‑yu. Dico yúhú chi vá ncháá ndùu cundecu ndɨhɨ ñaha‑í xii‑ndo ñùyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Te ñadɨ̀hɨ́‑a ní quide‑aⁿ ɨɨⁿ sá vǎha ndèé není ní ndacu‑aⁿ, chi sá dúhá nǐ quide ñaha‑aⁿ xìi‑í ní chihi ñaha‑aⁿ àcití, te xíǎⁿ cada iní‑ndó sǎ sà quide túha‑aⁿ yɨquɨ cùñú‑í cuèndá quɨ́ndúxi‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nděni ní cuu nɨhìí ñuyíú ná càháⁿ ñáyiu tnúhu‑í, te cáháⁿ‑yu tnàhá cuèndá ñadɨ̀hɨ́‑a cuèndá quiní nchaa ñáyiu nàcuáa ní quide‑aⁿ, te ducaⁿ vǎ nácuànaá‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Te té Jùdás Iscàrioté ní sáháⁿ‑dé ní ndatnúhu‑dé ndɨhɨ cue tée cùu dútú cúnùu sá cuǎha cuèndá‑dé Jèsús núú‑güedě, te núú tnàhá té Jùdás‑áⁿ cúú ùxúú tnàhá cue tée xìca cuu ndɨhɨ‑gá ní cùu. ");
INSERT INTO milNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Te òré ducaⁿ nǐ ndatnúhu‑dé ndɨhɨ‑güedé, te ío ní cudɨ́ɨ́ ìní‑güedé, te ní xáhaⁿ‑güedě xii‑dé sá cuǎñaha‑güedě díhúⁿ xii‑dé. Te té Jùdás‑áⁿ nǐ ngüíta‑dé ndúcú‑dě nàcuáa cada‑dé cuáha cuèndá‑dé Jèsús núú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Te ní sáá nduu nǐ quesaha vìco pascuá, vico ñá túú xèxi ñáyiu pàá sá ñà túú yɨ̀hɨ levadurá, te dɨu‑ni nduu‑ǎⁿ sáhní‑güedě ɨɨⁿ mběé lǐhli xèxí‑yu nduu vìco pascuá‑áⁿ. Te cue tée xìca cuu ndɨhɨ Jesús ní xícáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Mèstrú, véxi‑ndɨ́ xìcáⁿ tnúhú‑ndɨ̌ núú‑n nǔu ndèé cáá vèhe cuiní‑n càda túha‑ndɨ́ sá cúdìni‑o sacuaa nduu vico pascuá —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Te Jèsús ní xáhaⁿ‑gǎ xii úú‑ni tnàhá cue tée xìca cuu ndɨhɨ‑gá: —Chí cuàháⁿ xɨtɨ́ ñuú‑ǎⁿ, te yàcáⁿ naníhí‑ndó ɨ̀ɨⁿ tée tànehe yóó ndute, te tée‑áⁿ cánděndaha‑ndo‑dě quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Te núu ndědacàa vehe na ndɨ́hu‑dé te xíáⁿ quɨ̌hu‑ndo. Te cúñaha‑ndo xìi xítohó vehe‑áⁿ: “Yaá cúú Mèstrú càchí‑gá sá nǔu ndědacàa xichi xɨtɨ́ vehe‑n cuǎñaha nùu‑n xii‑gá cudìni‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá sacuaa nduu pàscuá”, duha cúñaha‑ndo. ");
INSERT INTO milNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Te dǎtnùní danèhé ñáhá‑dě xii‑ndo ɨ̀ɨⁿ cuartú cáhnú càa núú nǐnu, chi vehe yòdo tnaha cuu‑xi, te sa ní quide túha‑dé nchaa sá nándɨ̌hɨ, te nchòhó dìcó‑nǎ comìdá cada túha‑ndo cùdini‑o —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Te cue tée‑áⁿ nǐ xica‑güedé cuáháⁿ‑güedé xɨtɨ́ ñuú‑áⁿ, te nchaa‑ni nàcuáa ní xáhaⁿ Jèsús ní cuu. Te ní quide túha‑güedé sá cúdìni‑güedé ndɨhɨ‑gá sacuaa nduu vìco pascuá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Te sátá nǐ cundɨquɨⁿ te ní quexìo Jesús ndɨhɨ ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Te cuánguɨhu‑gá mèsá ndɨhɨ‑güedé cuèndá cudìni ndɨhɨ ñaha‑gá xii‑güedé, te òré yɨ́hɨ́‑gǎ mèsá ndɨhɨ‑güedé, te xǎhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ ɨ̀ɨⁿ nchohó cue tée xèxi ndɨhɨ ñaha xii‑í cuáha cuèndá ñáhá‑ndó nǔú cuè tée cùu úhú iní ñáhá xìi‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Te sá dúcáⁿ nǐ xáhaⁿ‑gǎ xii‑güedé, te nchaa‑güedé ní ngüíta‑güedé cúndɨ̀yɨ́‑güedé. Te da ɨɨⁿ da ɨɨⁿ‑güedé ní ngüíta‑güedé xìcáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —¿Ñá dɨ́ú yǔhú ducaⁿ sàni iní‑n càda‑í‑u? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Dɨu‑ni ɨɨⁿ nchòhó cue tée úxúú xícá cùu ndɨhɨ‑í, tée na dàquéndaha cǒhó òré daquěndaha‑ǐ, tée‑áⁿ cuǎha cuèndá ñáhá‑dě xii‑í núú cuè tée cùu úhú iní ñáhá. ");
INSERT INTO milNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Te yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ñuhu ichi‑í cuáháⁿ‑í ndoho‑í nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí. Dico ndàhú ní cuu tée ducaⁿ na cuǎha cuèndá ñáhá xìi‑í núú cuè tée cùu úhú iní ñáhá, chi váha‑gá sá vǎ cácú těe‑áⁿ cundecu‑dé ní cùu, te ñá dɨ́ú sǎ nǐ cacu‑dé te ducaⁿ càda‑dé —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Te nɨni cùdini cue tée xìca cuu ndɨhɨ Jesús ní queheⁿ‑gá pàá, te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí, te dǎtnùní ní táhú cuèchi‑gá, te ní ngüíta‑gá dácǎhñu ñaha‑gǎ xii‑güedé, te xǎhaⁿ‑gǎ: —Chí quéhéⁿ pàá‑a caxi‑ndo, te cada iní‑ndó sǎ cúú‑xí dàtná yɨquɨ cùñú‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Te ní queheⁿ‑gá vàsú ñúhú ndùdí ndéhé yoho yàha stilé, te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí, te dǎtnùní ní ngüíta‑gá sǎñaha‑gǎ xii‑güedé cuèndá coho‑güedé luha luha sá ñúhú xɨ̀tɨ́‑xi, te nchaa‑güedé ní xihi. ");
INSERT INTO milNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Te ní xáhaⁿ‑gǎ xii‑güedé: —Ndudí ndéhé yoho yàha stilé‑a cada iní‑ndó sǎ cúú‑xí dàtná nɨ́ñɨ̀‑í sá cátɨ́ òré cahni ñaha‑güedě xii‑í. Te sá dúcáⁿ càtɨ nɨ́ñɨ̀‑í xíǎⁿ cutnùní ndáá sá Yǎ Ndiǒxí cada‑gá ɨngá núú sǎ vǎha sá cúú‑xí vài ñáyiu dàtná ní cachí‑gá cada‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ vítná‑nǎ duha xìhi‑í ndudí ndéhé yoho yàha stilé‑a te vá cóhó‑gǎ‑í, dico na sàá nduu cùndecu‑í núú ndécú Yǎ Ndiǒxí táxí tnùní‑gá, te dàvá‑áⁿ cada iní‑í sá dàtná sá cóhó tùcu‑í chi ío cudɨ́ɨ́ ìní‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Te Jèsús ní xita‑gá ɨɨⁿ ndudú ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te dǎtnùní ní xica‑gá cuáháⁿ‑gá ndɨhɨ‑güedé yucu Òlívú. ");
INSERT INTO milNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Te yàcáⁿ ní xáhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu‑í xii‑ndo sǎ ncháá‑ndó dàña nihnu ñaha‑ndo xii‑í niú vitna, chi quee ndáá‑xi nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí núú càchí‑xi: “Yúhú cuáha‑í tnúhu cahni‑güedé tée cùu toli, te nchaa mběé‑dě ndɨhɨ‑güedɨ cuténuu”, duha càchí‑xi núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Dico na cùú‑í te ndoto‑í te codonùu‑í núú‑ndó quɨ̌hɨ́ⁿ distrìtú Galìleá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Te té Pèlú ní xáhaⁿ‑dě xii‑gá: —Te cuěi nchaa‑güedé ná dàndóo ñaha‑güedě xii‑n, dico yúhú chi vá dándǒo ñaha‑ǐ xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Na càchí tnúhu ndáá‑í xii‑n sǎ nìú vitna cùmání‑gǎ cana lǐhi úú xito, te úní xito cáháⁿ‑n nǔú ñǎyiu sá ñà túú xìní ñáhá‑n xìi‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Dico té Pèlú ní cáháⁿ ñɨɨ́‑dé, te xǎhaⁿ‑dě xii‑gá: —Cuěi na cùú ndɨhɨ ñaha‑ǐ xii‑n dico vá càháⁿ‑í núú ñǎyiu sá ñà túú xìní ñáhà‑í xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te nchaa dava‑gá cue tée xìca cuu ndɨhɨ‑gá dɨu‑ni ducaⁿ nǐ xáhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Te Jèsús cuáháⁿ‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ɨɨⁿ xichi núú nání Gètsemaní. Te òré ní quexìo‑gá ndɨhɨ‑güedé xíáⁿ, te ní xáhaⁿ‑gǎ xii‑güedé: —Chí cúnúcǒo iha cundetu‑ndo na quɨ̀hɨ́ⁿ‑í yàcáⁿ cáháⁿ ndɨhɨ‑í Yǎ Ndiǒxí —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Te ndèca‑gá té Pèlú, ndɨhɨ té Jàcobó, ndɨhɨ té Juàá cuáháⁿ, te ñá túú tnàhí‑gá cúú vǎha iní‑gá te ní ngüíta‑xi súúní ndɨ̀hú iní‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Te ní xáhaⁿ‑gǎ xii cue tée úní‑áⁿ: —Súúní ndɨ̀hú iní‑í dàtná sá cùú‑í, te chí quéndǒo iha te vá cùdú‑ndó —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Te sa ñùnchií luha ní xica ndehe Jèsús núú ndécú‑güedě, te ní ngáundeyɨ‑gá ndéé ñuhu càháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí sá nǔu vá cúndèe iní‑gá taunihnu ñaha‑gǎ xii‑gá cuèndá nchaa nàcuáa yáha‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Te òré càháⁿ ndɨhɨ Jèsús Tǎtá‑gǎ Dútú Ndiǒxí, te xǎhaⁿ‑gǎ: —Yòhó tǎtá méè‑í, nchaandɨ túhú sá vǎha ndàcu‑n quide‑n, te càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n tàunihnu ñaha‑n xii‑í cuèndá sá vǎ ndóhò‑í ná sàá òré, dico vá cádá‑n nàcuáa càchí iní méè‑í chi cada‑n nàcuáa càchí mee‑n —càchí‑gá xǎhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Te sátá nǐ yáha ní cáháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te cuánuhú‑gá núú nǐ dándǒo‑gá cue tée úní‑áⁿ, te xǐxídí‑güedé òré ní nasáá‑gá, te ní xáhaⁿ‑gǎ xii té Pèlú: —Xǐmú, ¿náa sama xìdí‑n? ¿Náa ñá cúndèe tnahi núú‑n vǎ cùdú‑ni‑n cuědìcó ɨɨⁿ òré‑ǎⁿ? —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te ní xáhaⁿ tùcu‑gá xii‑güedé: ");
INSERT INTO milNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","—Te chí quéndǒo tucu, te cuhuⁿ iní‑ndó vǎ cùdú‑ndó, te cáháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí cuèndá sá vǎ dácàháⁿ ñáhá yùcu ñávǎha xii‑ndo càda‑ndo sá ñà túú tàú‑ndó càda‑ndo. Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nchòhó cuìní‑ndó càda‑ndo nchaa nacuáa càháⁿ‑í dìcó‑ni sá ñà túú nìhí ndéé‑ndó —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Te Jèsús ní xica tucu‑gá cuáháⁿ‑gá cáháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te dɨu‑ni nàcuáa ní xáhaⁿ‑gǎ díhna xǎhaⁿ tùcu‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Te òré ní yáha ní cáháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te cuánuhú tucu‑gá núú xǐndecu cue tée úní xícá cùu ndɨhɨ‑gá‑áⁿ, te xìdí‑ni tucu‑güedé òré ní nasáá‑gá, te ducaⁿ nǐ quide‑güedé chi súúní ñùhu saní núú‑güedě, te ñá ní nǐhí‑güedě tnúhu cúñaha‑güedě xii‑gá òré ní nasáá‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Te ní sáháⁿ tucu‑gá xito cùu uní ní cáháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te òré ní nasáá tucu‑gá núú xǐndecu‑güedé, te xǎhaⁿ‑gǎ xii‑güedé: —¿Te náa xìdí‑ni tucu‑ndo?, te vitna vá cùdú‑gá‑ndó chi sa ní sáá òré cuáha cuèndá ñáhá‑güedě xii yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo núú cuè tée ndècu ichi cuehé ichi duha. ");
INSERT INTO milNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Te vitna chí ndácǒo na quɨ̀hɨ́ⁿ‑ó chi sa véxi tée cuáha cuèndá ñáhá xìi‑í núú cuè tée cùu úhú iní ñáhá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Te càháⁿ dúcáⁿ‑ní Jèsús ní quexìo té Jùdás. Te núú tnàhá tée‑áⁿ cúú ùxúú tnàhá cue tée xìca cuu ndɨhɨ‑gá. Te ndɨhɨ‑dé vài cue tée ní quexìo, te dava‑güedé xǐnehe‑güedé machìtí te dava‑güedé xǐnehe‑güedé carrùtí. Te cue tée‑áⁿ nǐ tendaha ñàha cue dútú cúnùu ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél. ");
INSERT INTO milNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Te té Jùdás tée cuáha cuèndá ñáhá xìi Jesús sa ní xítnǔhu‑dé cue tée‑áⁿ nàcuáa cada‑dé cuáha cuèndá ñáhá‑dě xii Jèsús núú‑güedě. Te duha ní xáhaⁿ‑dě xii‑güedé: —Cundehe‑ndo těe na tèyuhu‑í, te tée‑áⁿ tnɨɨ‑ndo‑dě chi tée‑áⁿ cúú‑dě tée ndèé iní‑ndó, te ío quɨhɨ iní‑ndó càndeca‑ndo‑dé quɨ́hɨ́ⁿ —duha ní xáhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Te òré ní quexìo té Jùdás ndɨhɨ cue tée‑áⁿ nǔú ndécú Jèsús, te ní xáhaⁿ‑dě xii‑gá: —Mèstrú —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te ní teyuhu ñàha‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Te nchaa cue tée ndɨhɨ‑dé‑áⁿ nǐ tnɨɨ‑güedé Jèsús cuèndá candeca ñaha‑güedě xii‑gá quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Te ɨɨⁿ cue tée cùndɨhɨ Jesús ní tava‑dé machìtí‑dé, te ní xehndé‑ni‑dé ɨɨⁿ xio lóho ɨɨⁿ tée xìnu cuechi núú dǔtú cúnùu, te ní quendeé duuⁿ lóho tée‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Te Jèsús ní xáhaⁿ‑gǎ xii cue tée ní tnɨɨ ñaha xìi‑gá‑áⁿ: —Nchòhó, nèhe‑ná‑ndó màchití, nèhe‑ná‑ndó càrrutí véxi ní tnɨɨ ñaha‑ndo xìi‑í, dàtná quídé‑ndó ɨ̀ɨⁿ ñadúhú quídé ñàha‑ndo xii‑í. ");
INSERT INTO milNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Te nchaa‑ni nduu ní xiní‑ndó nǐ xíndecu‑í xɨtɨ́ veñúhu càhnu sá ǐo cùnuu ní xóo danèhé‑í ñáyiu, te ñá túú ní tnɨ̀ɨ ñaha‑ndo xii‑í. Dico dàcuɨtɨ́í sǎ dúhá yǎha‑í cuèndá quee ndáá‑xi nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Te nchaa cue tée xìca cuu ndɨhɨ‑gá ní xinu‑güedé ní dándǒo ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Te ɨɨⁿ tée cuechi nděndaha‑dě Jèsús cuáháⁿ, te lavichi‑dě, ɨɨⁿ‑ni dóó yádí yɨ̀dúcúⁿ nuu‑dé nɨhìí‑dé, te ní tnɨɨ ñaha‑güedě xii‑dé, ");
INSERT INTO milNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","dico ní ndacu‑dé ní quenuñɨɨ‑dě te ní dándǒo‑dé dóó yɨ́dǔcúⁿ nuu‑dé‑áⁿ nǐ xinu‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Te cue tée ní tnɨɨ ñaha xìi Jesús ndécá ñàha‑güedé xii‑gá cuáháⁿ núú těe cùu dútú cúnùu‑gá. Te xíáⁿ nǐ tacá nchaa dava‑gá cue tée cùu dútú cúnùu, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél, ndɨhɨ cue tée dàcuaha ñaha xií‑yu nchaa tnúhu ní chídó tnùní ndíi Moìsés cuèndá cada‑güedé jùndá. ");
INSERT INTO milNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Te té Pèlú xica xìca‑ni nchicúⁿ ñáhá‑dě xii‑gá cuáháⁿ ní sáá‑dé ndéé quehé vehe núú ndécú těe cùu dútú cúnùu‑gá‑áⁿ, te xíáⁿ nǐ ngóo teté‑dé yuhu nùhú ndɨhɨ cue tée cùu poleciá. ");
INSERT INTO milNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Te cue tée cùu dútú cúnùu ndɨhɨ nchaa dava‑gá cue tée xǐndecu jùndá ndúcú‑güedě ñáyiu dacàa ɨɨⁿ cuéchi dɨ́quɨ́ Jèsús cuèndá ducaⁿ nǐhí‑güedě nàcuáa cada‑güedé cahni ñaha‑güedě xii‑gá, dico ñá túú ní ndàcu‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Te cuěi vài ñáyiu dàcaá‑yu cuéchi dɨ́quɨ́‑gǎ dico mee‑ni sǎ nǐ cahu iní méě‑yu ní cáháⁿ‑yu, chi tucu càháⁿ ɨɨⁿ tucu càháⁿ ɨɨ́ⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Te davá‑yu ní ndacuɨ́ñɨ́‑yu te ní ngüíta‑yu dàcaá‑yu ɨɨⁿ cuéchi neñùú dɨ́quɨ́‑gǎ, te xǎhǎⁿ‑yu xii nchaa cue tée cùnuu: ");
INSERT INTO milNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nchúhú ní tecú dóho‑ndɨ́ càchí‑dé sá dángòyo‑dé veñúhu càhnu sá ǐo cùnuu sá nǐ dácáá cuè tée ñuyíú‑a, te dandàa tucu‑dé ɨngá veñúhu saa, dɨu‑ni núú cáá tnàhí veñúhu‑áⁿ te xɨtɨ́ úní‑ni nduu sa nadaxǐnu‑dé, te vá cúú‑gǎ‑xi veñúhu sá nǐ dácáá cuè tée ñuyíú‑a, duha càchí‑dé ní tecú dóho‑ndɨ́ —càchí‑yu xǎhǎⁿ‑yu xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Dico ni dùcaⁿ ñá túú ní cùu ɨɨⁿnuú‑yu nchaa tnúhu ní cáháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Te tée cùu dútú cúnùu‑gá ní ndacuɨ́ñɨ́‑dé tnuú nchaa ñáyiu, te xǎhaⁿ‑dě xii Jèsús: —¿Ná cuèndá duha ndùu tnúhu càháⁿ ñáyiu‑a cuèndá‑n? Te cáháⁿ nǔu nása ndùu tnúhu cáháⁿ‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dico Jèsús ñá túú tnàhí ni cǎháⁿ‑gá. Te tée cùu dútú cúnùu‑gá‑áⁿ nǐ xáhaⁿ tùcu‑dé xii‑gá: —Cuìní‑í cachí tnúhu‑n xìi‑ndɨ́ nǔu sá dɨ́ú Crìstú Déhe Yá Ndiǒxí Yaá ní tendaha‑gǎ véxi ñuyíú‑a cùu‑n. Te dɨu Yá Ndiǒxí cúú‑gǎ Yaá quídé càhnu‑ndɨ́ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Dɨu Yaá‑áⁿ cúù‑í, te na càchí tnúhu‑í xii‑ndo sǎ sàá nduu te quiní‑ndó yǔhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo cunucóo‑í xio cùha Dútú Ndiǒxí Yaá ndácú quìde nchaandɨ túhú sá vǎha. Te dàvá‑áⁿ quiní ñáhá‑ndó xìi‑í quee‑í andɨu quìxi‑í ichi xɨtɨ́ vícó —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Te dútú cúnùu‑gá‑áⁿ nǐ ndátá‑dě dóó cání nìhnu‑dé cuèndá sá ñà túú ní tnàhá iní‑dé nàcuáa ní cáháⁿ Jèsús, te ní xáhaⁿ‑dě xii nchaa cue tée xǐndecu jùndá: —Ñá túú‑gǎ xíní ñùhu‑xi cue tée cáháⁿ nǔu ndáá sá ndècuéchi‑dé àdi ñá túú ndècuéchi‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chi sa ní xíndedóho‑o nàcuáa ndùu tnúhu ní cáháⁿ‑dé ní cáháⁿ úhú‑dé cuèndá Yǎ Ndiǒxí, te nchaa‑ndo chǐ càháⁿ vitna núu nása sàni iní‑ndó cùnduu cuendá tée‑a —càchí‑dé xǎhaⁿ‑dě xii‑í‑güedé. Te nchaa‑güedé ní cachí‑güedé sá ná cùú‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Te dava‑güedé ní ngüíta‑güedé ní tɨú dɨɨ́ ñáhá‑güedě xii‑gá, te ní dádǎhu‑güedé núú‑gǎ, te ní ngüíta‑güedé cánìha‑güedé xii‑gá, te xǎhaⁿ‑güedě: —¡Cáháⁿ ná cótó nǎ cúú těe ní caniha xìi‑n! —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. Te cue tée cùu poleciá ní cani‑güedé núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Te ndéé xɨtɨ́ vehe càa núú nǐnu quìde‑güedé jùndá, chi vehe yòdo tnaha cuu‑xi, te té Pèlú núcǒo‑dé quehé vehe‑áⁿ. Te ɨɨⁿ xíchí xínú cuèchi núú dǔtú cúnùu‑áⁿ nǐ quexìo‑xi núú núcǒo té Pèlú. ");
INSERT INTO milNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Te òré ní xiní ñáhá‑xí xìi‑dé núcǒo teté‑dé yuhu nùhú, te ní xíndéhé ñàha váha‑xi xii‑dé, te xǎhaⁿ‑xi: —Yòhó tnàhá‑n cùu‑n tée xìca cuu ndɨhɨ Jesús tée ñuú Nazàrét —càchí‑xi xǎhaⁿ‑xi xìi‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Te té Pèlú ní xáhaⁿ‑dě xii‑xi: —Yúhú ñá túú xìní‑í tée‑ǎⁿ, te ni ñà túú cùtnuní iní‑í nása ndùu tnúhu càháⁿ‑n —càchí‑dé xǎhaⁿ‑dě xii‑xi. Te té Pèlú ní xica‑dé cuáháⁿ‑dé ndàa nacuáa nchìí yuyèhe vehe‑áⁿ, te ní cana ɨɨⁿ lǐhi. ");
INSERT INTO milNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Te xíchí xínú cuèchi‑áⁿ nǐ xiní ñáhá tùcu‑xi xii‑dé, te xǎhaⁿ‑xi xìi nchaa ñáyiu xǐndecu‑áⁿ: —Dɨu tée‑ǎⁿ tnàhá‑dé xícá cùu‑dé ndɨhɨ tée ndèca‑güedé cuánguɨhu‑a —càchí‑xi xǎhaⁿ‑xi xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Dico té Pèlú ñá túú ní nǔnuu tucu‑dé sá xícá cùu‑dé ndɨhɨ Jèsús. Te tna tnaa‑ni ní cuu sá dúcáⁿ nǐ xáhaⁿ xǐchí‑ǎⁿ xii‑dé, te ní xáhaⁿ tùcu dava cue ñáyiu xǐndecu‑áⁿ xii‑dé: —Ndáá sá tnàhá‑n cùu‑n tée xìca cuu ndɨhɨ tée ndèca‑güedé cuánguɨhu‑ǎⁿ chi cùu‑n tée distrìtú Galìleá, te càháⁿ‑n dàtná càháⁿ‑güedé —càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Te té Pèlú ní xáhaⁿ‑dě xií‑yu: —Nchàcuɨtɨ Yá Ndiǒxí sá yǔhú càháⁿ ndáá‑í sá ñà túú xìní‑í tée càcunehe‑ndo‑áⁿ —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Te òré‑ni‑áⁿ nǐ cana tucu lǐhi xito cùu uú, te òré‑áⁿ nǐ ndacu iní té Pèlú nàcuáa ní xáhaⁿ Jèsús xii‑dé sá cùmání‑gǎ cana ɨɨⁿ lǐhi úú xito te úní xito cáháⁿ‑dé núú ñǎyiu sá ñà túú xìní ñáhá‑dě xii‑gá. Te òré ducaⁿ nǐ ndacu iní‑dé nàcuáa ní xáhaⁿ Jèsús xii‑dé, te ní ndáhyú‑dé ní ndixi cuéchi iní‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Te sátá nǐ túndaá te cue tée cùu dútú cúnùu, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ nchaa dava‑gá cue tée cùnuu ní xíndecu jùndá ní natacá‑güedé, te ní dácútú‑güedě Jèsús te ndèca ñaha‑güedé xii‑gá cuáháⁿ núú tě Pìlatú. ");
INSERT INTO milNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Te té Pìlatú ní xícáⁿ tnúhú‑dě núú Jèsús, te xǎhaⁿ‑dě xii‑gá: —¿Ndáá sá dɨ́ú‑n cùu‑n tée yɨ̀ndaha ñaha xii ñáyiu isràél‑ǎⁿ? —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Dɨu‑í yɨ́ndàha‑í‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Te cue tée cùu dútú cúnùu dacaa‑güedé vài cuéchi dɨ́quɨ́‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Te té Pìlatú ní xícáⁿ tnúhú tùcu‑dé núú‑gǎ, te xǎhaⁿ‑dě xii‑gá: —Cáháⁿ, ná cuèndá ñá càháⁿ‑n te cundehe nǎ ndéé duha tɨtnɨ́ cuéchi dàcaa dɨ́quɨ́ ñáhá cuè tée‑a xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Dico Jèsús ñá túú tnàhí ni cǎháⁿ‑gá te té Pìlatú ío ní cuñúhu‑dé sá dúcáⁿ ñà túú tnàhí ni cǎháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Te ndɨ tnahá nduu vìco pascuá dácǎcu té Pìlatú ɨɨⁿ tée yɨ̀hɨ vecaá chi ducaⁿ tnàhí quìde‑dé, te mee ñǎyiu càháⁿ‑yu te núu ndědacàa tée yɨ̀hɨ vecaá‑áⁿ cǎcu‑dé, te tée‑áⁿ dácǎcu‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Te yɨ̀hɨ ɨɨⁿ tée nàni Barrabás vecaá ndɨhɨ dava‑gá cue tée cùndɨhɨ‑dé. Te té Barràbás‑áⁿ nǐ sanu ichi‑dé ñáyiu ñuú ɨngá ichi, te ní ngüíta‑yu ndɨhɨ‑dé ní cuu úhú iní‑yu cue tée cùchiuⁿ, te ní sahni‑dé ndɨ́yɨ núu xíǎⁿ ní chihi ñaha‑güedě vecaá xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Te nchaa ñáyiu ní sáháⁿ‑yu núú tě Pìlatú, te càháⁿ ndàhú‑yu núú‑dě sá ná cádá nàhi‑ni‑dé dàtná quídé‑dě. ");
INSERT INTO milNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Te té Pìlatú ní xáhaⁿ‑dě xií‑yu: —¿Cuìní‑ndó sǎ dácǎcu‑í tée yɨ̀ndaha ñaha xii ñáyiu isràél‑ǎⁿ? —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Te ducaⁿ nǐ cáháⁿ té Pìlatú, chi ní cutnùní iní‑dé sá dìcó sá cuèdú íní cuè dútú cúnùu núu xíǎⁿ ducaⁿ nǐ quide‑güedé ní sáha cuèndá ñáhá‑güedě xii Jèsús núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Te cue dútú cúnùu ní xáhaⁿ‑güedě xii nchaa ñáyiu sá ná cǔñàhá‑yu xii té Pìlatú dàcácu‑dé té Barràbás, te ní quidé‑yu nàcuáa ní xáhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Te té Pìlatú ní xícáⁿ tnúhú‑dě núǔ‑yu, te xǎhaⁿ‑dě xií‑yu: —¿Ná cuìní‑ndó càda‑í tée càchí‑ndó yɨ̀ndaha ñaha xii ñáyiu isràél‑i? —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Te nchaá‑yu níhi ní cáháⁿ‑yu, te xǎhǎⁿ‑yu xii‑dé: —¡Cata caa‑dé núú cùrúxí! —càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Te té Pìlatú ní xáhaⁿ‑dě xií‑yu: —¿Te ná cúú cuěchi ní quide‑dé te núu ducaⁿ cuìní‑ndó càda‑í‑dé‑i? —càchí‑dé xǎhaⁿ‑dě xií‑yu. Dico nchaá‑yu uuⁿ‑gá níhi ní cáháⁿ‑yu, te xǎhǎⁿ‑yu xii‑dé: —¡Cata caa‑dé núú cùrúxí! —càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Te té Pìlatú ní quide‑dé nàcuáa ní xáhǎⁿ‑yu xii‑dé cuèndá sá cúdɨ̀u‑dé núǔ‑yu, te ní dácǎcu‑dé té Barràbás, te ní táúchíúⁿ‑dě ní cani‑güedé Jèsús ndɨhɨ ñɨɨ. Te sátá dúcáⁿ nǐ quide ñaha‑güedě xii‑gá, te ní táúchíúⁿ‑dě candeca ñaha‑güedě quɨ́hɨ́ⁿ cata caa ñaha‑güedě xii‑gá núú cùrúxí. ");
INSERT INTO milNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Te cue tée cùu sandadú ndécá ñàha‑güedé xii‑gá cuáháⁿ vechìuⁿ, te dɨu‑ni xíáⁿ cúú vèhe tée cùu gobiernú. Te xíáⁿ nǐ tacá nchaa dava‑gá cue tée cùu sandadú. ");
INSERT INTO milNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Te xíáⁿ nǐ dácuíhnú ñàha‑güedé xii‑gá ɨɨⁿ dóó tɨ̌cuèhé víhí, te ní cadúha‑güedé ɨɨⁿ coròná iñu ní chihi‑güedé dɨ́quɨ́‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Te ní ngüíta‑güedé níhi càháⁿ‑güedé cúdɨ̀quɨ́ ndeé ñáhá‑güedě xii‑gá, te xǎhaⁿ‑güedě: —¡Ío càhnu cuu yohó tée yɨ̀ndaha ñaha xii ñáyiu isràél! —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Te càni‑güedé dɨ́quɨ́‑gǎ ndɨhɨ ɨɨⁿ carrùtí, te tɨ̀ú dɨɨ́ ñáhá‑güedě xii‑gá, te ngüɨ̀ñɨ́ xɨ́tɨ́‑güedě núú‑gǎ quídé‑güedě sá néhé‑güedě sá yɨ́ñùhu núú‑gǎ dico ñá ndàá chi dìcó cúdɨ̀quɨ́ ndeé ñáhá‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Te sátá dúcáⁿ nǐ cudɨ́quɨ́ ndeé ñáhá‑güedě xii‑gá, te ní nataunuu ñaha‑güedě xii‑gá dóó tɨ̌cuèhé víhí sǎ nǐ dácuíhnú ñàha‑güedé, te ní dándɨ̌únuu ñaha‑güedě xii‑gá dóó méé‑gǎ. Te dǎtnùní ndécá ñàha‑güedé cuáháⁿ núú cátá càa ñaha‑güedé xii‑gá núú cùrúxí. ");
INSERT INTO milNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Te ichi cuáháⁿ‑güedé ndɨhɨ Jèsús ní naníhí‑güedě ɨɨⁿ tée ñuú Cìrené nání‑dě Xǐmú, te déhe‑dé cúú ɨ̀ɨⁿ tée nàni Lijandrú, ndɨhɨ ɨngá tée nàni Rúfú. Te té Xǐmú‑áⁿ ñúhú‑dě ichi duha cuándixi‑dé ní sáháⁿ‑dé yucu, te ní quide yica‑güedě ní xido‑dé cùrúxí sá nchídó Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Te ndèca‑güedé Jèsús cuáháⁿ ɨɨⁿ xichi núú nání Gǒlgotá, te tnúhu‑áⁿ quéé‑xí: Ɨɨⁿ xichi núú nání yɨ̀quɨ dɨ́quɨ́ ndɨ̌yɨ, duha quèe‑xi tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Te ní sáñaha‑güedě xii‑gá ndudí sá nǐ quée yúcú nání mìrrá coho‑gá ní cùu dico ñá túú ní xìhi‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Te ní sata caa ñaha‑güedě xii‑gá núú cùrúxí. Te sátá dúcáⁿ te cue tée cùu sandadú‑áⁿ nǐ xito ndeé‑güedé nǔu ndědacàa‑güedé cuu cuèndá‑güedé dóó‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Te cùu‑xi caá ɨ́ɨ́ⁿ dátnéé òré ní sata caa ñaha‑güedě xii‑gá núú cùrúxí. ");
INSERT INTO milNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Te ní taxi ndecu‑güedé ɨɨⁿ sá ndèé lètrá núú tácàa‑gá. Te lètrá‑áⁿ càháⁿ‑xi ná cuèndá ducaⁿ nǐ quide ñaha‑güedě xii‑gá. Te duha càháⁿ lètrá‑áⁿ: “Tée yɨ̀ndaha ñaha xii ñáyiu isràél”, duha càchí‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Te tnàhá úú cue tée cùu ñadúhú nǐ sata caa‑güedé dɨu‑ni núú cùrúxí tucu. Te ɨɨⁿ‑dé ní sata caa‑güedé xio cùha‑gá, te ɨngá‑dé ní sata caa‑güedé xio dàtni‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí núú càchí‑xi: “Ɨɨⁿ‑ni nǐ quide ñaha‑güedě xii‑gá ndɨhɨ cue tée ndècu cuéchi‑xi”, duha càchí‑xi núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Te nchaa ñáyiu yǎha yatni núú tácàa‑gá dácuìcó‑yu dɨ́quɨ̌‑yu te xǐcuèhé ñáhǎ‑yu xii‑gá, te xǎhǎⁿ‑yu: —Te ná cuèndá ducaⁿ càa‑n tacaa‑n xíáⁿ, te càchí‑n sǎ dàngoyo‑n veñúhu càhnu sá ǐo cùnuu te dandàa‑n ɨngá veñúhu saa, te xɨtɨ́ úní‑ni nduu sa nadaxǐnu‑n càchí‑n. ");
INSERT INTO milNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Te vitna tanùu núú cùrúxí‑áⁿ dàcácu‑n mèe‑n —cachí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Te dɨu‑ni ducaⁿ nǐ quide cue tée cùu dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, chi ní cudɨ́quɨ́ ndeé ñáhá‑güedě xii‑gá, te ní xítnàha‑güedé: —Tée‑a ní ndacu‑dé ní dácǎcu nihnu‑dé ñáyiu, ¿te ná cuèndá ñá ndácú‑dě dàcácu nihnu‑dé méé‑dě‑i? ");
INSERT INTO milNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Te núu ndáá sá dɨ́ú‑dě cúú‑dě Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a quɨndaha ñàha xii ñáyiu isràél, te na cùndehe‑o nuu‑dé núú cùrúxí, cuèndá quɨ́ndáá iní‑ó‑dě —càchí‑güedé xǐtnàha‑güedé. Te ndéé tnàhá cue tée tàcaa xio xio dɨñɨ‑gá xǐcuèhé ñáhá‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Te òré ní cuu cuádava nduu, te ní cunee nɨhìí ñuyíú, te ducaⁿ‑ni càa ní cuu ndéé caá úní sacuaa. ");
INSERT INTO milNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Te dɨu‑ni òré caá úní sacuaa‑áⁿ nǐhi ní cáháⁿ Jèsús, te xǎhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí: —Elòí, Elòí, láma sabàctaní —càchí‑gá xǎhaⁿ‑gǎ. Te tnúhu‑áⁿ quéé‑xí: Ndiǒxí méè‑í, Ndiǒxí méè‑í, ná cuèndá ní dáñá ñàha‑n xii‑í, duha quèe‑xi tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Te dava cue tée xǐndecu yatni núú tácàa‑gá‑áⁿ nǐ tecú dóho‑güedé nàcuáa ní cáháⁿ‑gá, te ní xítnàha‑güedé: —Chí cúndèdóho chi càna‑dé té Èliás —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Te ɨɨⁿ cue tée xǐndecu‑áⁿ xínú‑dě ní sáháⁿ ní chindóyo‑dé luha cáchí xɨ̀tɨ́ ndudí íá, te ní chinenu‑dé dɨ́quɨ́ ɨɨⁿ yutnu càni te ní ndocani‑dé chíhí‑dě yuhu‑gá cuèndá coho‑gá. Te ní xáhaⁿ cuè tée xǐndecu‑áⁿ xii tée‑áⁿ: —Cundetu tnaa na cùndehe‑o nacoto núu quixi té Èliás nunehe ñaha‑dě xii‑dé núú cùrúxí —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Te Jèsús níhi ní canasaa‑gá te ní xíhí‑ni‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Te sátá dúcáⁿ te ní ndátá dǒó cúú còrtiná xɨtɨ́ veñúhu càhnu sá ǐo cùnuu ní quée dava ndáá, te ndàa núú nǐnu ní ngüíta‑xi ní ndátá. ");
INSERT INTO milNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Te tée cùu capitáⁿ nútnɨ̌ɨ‑dé ndàa núú Jèsús, te ndèhe‑dé nàcuáa ní quide‑gá òré ní xíhí‑gá, te ní cachí‑dé: —Sá ndàá ndisa sá dɨ́ú těe‑a cùu‑dé Déhe Yá Ndiǒxí ní cùu —duha ní cachí‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Te xica xǐnutnɨ́ɨ ɨɨⁿ ǔú ñáyiu dɨ̀hɨ́ ndéhě‑yu nchaa nàcuáa ní quide ñaha‑güedě xii Jèsús, te tnàhá tá Màriá Magdalèná, ndɨhɨ tá Salòmé, ndɨhɨ tá Màriá nǎná tě Chèé ndɨhɨ té Jàcobó tée càchí‑güedé cúú lǐhli‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Te cue ñáyiu dɨ̀hɨ́‑áⁿ nǐ xica cuú‑yu ndɨhɨ Jèsús distrìtú Galìleá ní xinu cuèchí‑yu núú‑gǎ. Te cue ñáyiu dɨ̀hɨ́‑áⁿ nchìcúⁿ ñáhǎ‑yu xii‑gá ní quexìo ndéé ñuú Jerusàlén ndɨhɨ dava‑gá ñáyiu dɨ̀hɨ́ nchìcúⁿ ñáhá xìi‑gá cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Te cùu‑xi nduu vispré nduu ndètatú ñáyiu. Te nduu‑ǎⁿ xǐquide túha‑yu sá cúú ɨ̀ngá nduu nduu ndètatú‑yu‑áⁿ, te dɨu‑ni nduu‑ǎ sa ní cuaa vìhi, ");
INSERT INTO milNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","te ɨɨⁿ tée nàni Cheé tée ñuú Arimàteá ní cuyɨɨ‑dě ní sáháⁿ‑dé núú tě Pìlatú, te ní xáhaⁿ‑dě sá nǔu vá cúndèe iní‑dé daña‑dě chindúxi‑dé yɨquɨ cùñú Jèsús. Te tnàhá té Chèé‑áⁿ cúú‑dě ɨɨⁿ tée cùnuu cundɨhɨ‑dé cue tée quìde jundá, te tnàhá‑dé ndétú‑dě sáá nduu ndɨ́hu ndaha ñàha Yá Ndiǒxí xii‑dé ndɨhɨ cue ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Te té Pìlatú ío ní cuñúhu‑dé sá dúcáⁿ ǐo ndɨ̌hɨ ní xíhí Jèsús, te ní cana‑dé tée cùu capitáⁿ ní xícáⁿ tnúhú‑dě núú‑dě nǔu ndisa sá sà ní xíhí‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Te tée cùu capitáⁿ‑áⁿ nǐ xáhaⁿ‑dě xii té Pìlatú sá ndàá ní xíhí Jèsús, núu xíǎⁿ té Pìlatú‑áⁿ nǐ sáha‑dé tnúhu chindúxi té Chèé‑áⁿ yɨquɨ cùñú‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Te té Chèé‑áⁿ nǐ saaⁿ‑dé ɨɨⁿ dóó vǎha, te ní sáháⁿ‑dé ní nunehe‑dé yɨquɨ cùñú Jèsús núú cùrúxí, te ní chidúcúⁿnuu‑dé yɨquɨ cùñú‑gá dóó vǎha sá nǐ saaⁿ‑dé‑áⁿ, te dǎtnùní néhé‑dě yɨquɨ cùñú‑gá cuáháⁿ ní chihi‑dé ɨɨⁿ yaú nchìí yɨquɨ naha càva, te ní sadɨ́‑dé yuhu yàú‑áⁿ ndɨhɨ ɨɨⁿ yúú quèhéⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Te tá Màriá Magdalèná, ndɨhɨ tá Màriá nǎná tě Chèé ní xiní‑yu núú nǐ chihi‑dé yɨquɨ cùñú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Te sátá nǐ cundɨquɨⁿ nduu ndètatú ñáyiu, te tá Màriá Magdalèná, ndɨhɨ tá Salòmé, ndɨhɨ tá Màriá nǎná tě Jàcobó ní saáⁿ‑yu acìtí sàháⁿ tnámí cuèndá canehé‑yu quɨ́hɨ́ⁿ chihí‑yu yɨquɨ cùñú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Te ndumìngú nehé‑ni òré vitna váha váha ní xínu coto núú nchǐcanchii ní quexìó‑yu núú nchìí yaú yɨ́hɨ́ yɨ̀quɨ cuñú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Te ní xítnàhá‑yu: —Yoo cúñaha‑o xòcani yúú ndèdɨ́ yuhu yàú‑a, chi vá yǒo tnàhí ndècu iha —cachí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Te òré ní xíndéhé vǎha‑yu te ní xiní‑yu sá yǔú cáhnú ndèdɨ́ yuhu yàú‑áⁿ ɨɨⁿ xio‑ná ndécú. ");
INSERT INTO milNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Te cuánguɨhú‑yu xɨtɨ́ yaú‑áⁿ, te ní xiní‑yu nùcóo ɨɨⁿ espíritú xínú cuèchi núú Yǎ Ndiǒxí ndàa xio cuhá‑yu, te càa‑xi datná cáá ɨ̀ɨⁿ tée cuechi, te nìhnu‑xi ɨɨⁿ dóó cuìxíⁿ dóó cání, te ní yùhú‑yu òré ní xiní‑yu espíritú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Te espíritú‑áⁿ nǐ xáhaⁿ‑xi xìí‑yu: —Vá yùhú‑ndó, chi yúhú sa cùtnuní iní‑í sá nchòhó véxi‑ndo nànducu‑ndo yɨquɨ cuñú Jèsús tée ñuú Nazàrét tée ní sahni‑güedé núú cùrúxí, dico ñá túú‑gǎ yɨquɨ cùñú‑dé ndécú ìha chi sa ní ndoto‑dé, te chí cúndèhe núú nǐ sacáⁿ‑güedé yɨquɨ cùñú‑dé te quiní‑ndó nǎ ñá túú‑gǎ‑dé. ");
INSERT INTO milNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Te chí cuàháⁿ núú ndécú tě Pèlú ndɨhɨ dava‑gá cue tée ní xica cuu ndɨhɨ‑dé, te duha cúñaha‑ndo xìi‑güedé: “Jèsús codonùu‑gá núú‑ndó quɨ̌hɨ́ⁿ distrìtú Galìleá, te yàcáⁿ quiní‑ndó‑gǎ dàtná ní cachí‑gá xii‑ndo”, duha cúñaha‑ndo xìi‑güedé —càchí espíritú‑áⁿ xǎhaⁿ‑xi xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Te cue ñáyiu dɨ̀hɨ́‑áⁿ ǐo ní yùhú‑yu, te ní quene cunú‑yu cuánuhú‑yu, te quɨ̀dɨ ñaha‑ná‑xi xií‑yu sá ǐo ní yùhú‑yu, te ñá túú tnàhí ná tnúhu ni xǎhǎⁿ‑yu xii cue ñáyiu ní naníhǐ‑yu ichi cuèndá sá ǐo ní yùhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Te sátá dúcáⁿ nǐ ndoto Jèsús ndumìngú nehé‑ni‑áⁿ, te díhna nuu‑gǎ tá Màriá Magdalèná ní quee túu‑gá núú‑xi, te dɨu tá Màriá‑áⁿ cúú‑xí xǐchí nǐ xɨ́hɨ ñaha ǔsá espíritú cúndɨ̀hɨ yucu ñávǎha ni cùu, te Jèsús ní queñuhu‑gá nchaa espíritú‑áⁿ yɨquɨ cùñú‑xi. ");
INSERT INTO milNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Te xíchí‑ǎⁿ nǐ sáháⁿ‑xi ní xítnǔhu‑xi cue tée ní xica cuu ndɨhɨ Jèsús nàcuáa ní cuu, te xǐndáhí‑güedé sá ndɨ̀hú iní‑güedé òré ní quexìo‑xi núú ndécú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Te òré ní xáhaⁿ tǎ Màriá xii‑güedé sá nǐ ndoto Jèsús ndɨhɨ sá nǐ xiní ñáhá‑xí xìi‑gá, te ñá túú ní sàndáá iní‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Te úú tnàhá cue tée ní xica cuu ndɨhɨ Jèsús ñúhú‑güedě ichi cuáháⁿ‑güedé yucu, te uuⁿni ní quee túu‑gá núú‑güedě, te ní dácótó ñàha‑xi xii‑güedé sá ñà túú‑gǎ cáá‑gǎ dàtná cáá‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Te cue tée úú‑áⁿ nǐ xica‑güedé cuáháⁿ‑güedé ní xítnǔhu‑güedé nchaa dava‑gá cue tée ní xica cuu ndɨhɨ‑gá sá nǐ xiní ñáhá‑güedě xii‑gá, dico dɨu‑ni ducaⁿ ñà túú ní sàndáá iní cue tée‑áⁿ tnǔhu ní cáháⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Te ndɨ ùxí ɨɨⁿ cue tée ní xica cuu ndɨhɨ Jèsús yɨ́hɨ́‑güedě mèsá xéxí‑güedě, te ní quee túu‑gá núú‑güedě te ní tenàá ñáhá‑gǎ xii‑güedé cuèndá sá ǐo sàá iní‑güedé ñá túú sàndáá iní ñáhá vǎha‑güedé xii‑gá, chi ñá túú ní cuìní‑güedé quɨ́ndáá iní‑güedé nàcuáa ní xáhaⁿ ñǎyiu ní xiní ñáhá xìi‑gá sátá nǐ yáha ní ndoto‑gá. ");
INSERT INTO milNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Te ní xáhaⁿ‑gǎ xii‑güedé: —Quɨ́hɨ́ⁿ‑ndó nɨ̀hií ñuyíú cǎháⁿ‑ndó nǔú nchàa ñáyiu tnúhu váha tnúhu sá càháⁿ nàcuáa naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Te nchaa ñáyiu na quɨ̀ndáá iní tnúhu‑áⁿ te cuanduté‑yu, te naníhí tàhú‑yu, dico nchaa ñáyiu vá quɨ̀ndáá iní tnúhu‑áⁿ te cuíta nihnú‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Te nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í te cadá‑yu sá vǎ yǒo tnàhí ndàcu cada, te cacunehe ñàhá‑yu xii‑í, te queñuhú‑yu nchaa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu. Te uuⁿni ndacú‑yu cáháⁿ‑yu ɨngá núú tnǔhu sá vǎtá dácuàha‑gá‑yu. ");
INSERT INTO milNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Te cuěi na tnɨ̀ɨ́‑yu cóó děéⁿ dico ñá túú nǎ cada ñaha‑dɨ xìí‑yu, te cuěi venènú ná cáxǐ‑yu dico ñá túú nǎ tnahá‑yu, te tendàhá‑yu cue ñáyiu cùhú te ndúha‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Te sátá nǐ yáha ducaⁿ nǐ xáhaⁿ Jèsús xii cue tée ní xica cuu ndɨhɨ‑gá, te ní ndanchita‑gá cuándaa‑gá andɨu te ní ngóo‑gá xio cùha Dútú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Te cue tée‑áⁿ nǐ xica‑güedé cuáháⁿ‑güedé, te ní ngüíta‑güedé càháⁿ‑güedé tnúhu Xítohó Jesucrìstú nchaa xichi. Te mee‑gǎ ní chindee ñàha‑gá xii‑güedé ní quide‑güedé nchaa sá vǎ yǒo tnàhí ndàcu cada cuendá cutnùní iní ñáyiu sá ndàá càháⁿ‑güedé tnúhu‑gá. Duha ní cuu dàvá‑áⁿ.");
INSERT INTO milNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Te vài ñáyiu chìdo tnuní‑yu nchaa nàcuáa ndùu tnúhu nìhí‑yu nàcuáa ní cuu, te nchoo tnàhá‑ó sà naha‑o nacuáa ní cuu. ");
INSERT INTO milNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Te dɨu‑ni nchaa tnúhu chìdo tnuní‑yu‑áⁿ cúú‑xí tnǔhu ní cáháⁿ nchaa cue tée ní xiní ndáá nàcuáa ní cuu ndéé díhna, cue tée ní cáháⁿ tnúhu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Te yúhú sa ní cuu nduu quìde cuendá‑í nchaa nàcuáa ní cuu, núu xíǎⁿ ní sani iní‑í tee váha‑í nchaa tnúhu‑a núú tùtú sá cúú‑xí yòhó té Těofilú chi ío váha cùu iní‑í sá cúú‑xí‑n, ");
INSERT INTO milNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","te tèe‑í cuèndá cutnùní iní‑n sǎ sǎ ndàá cúú‑xí nchàa sá nǐ dánèhé ñáhá‑güedě xii‑n. ");
INSERT INTO milNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Te cútnàhá ní xɨ́ndaha té Hèrodés ñáyiu distrìtú Jùdeá dàvá‑áⁿ nǐ xíndecu ɨɨⁿ dútú nǐ xínani‑dě Zacàriá, te ní cundɨhɨ‑dé cue dútú Àbiás. Te ñadɨ̀hɨ́‑dé ní xínani‑aⁿ Èlisabét, te ñaha‑áⁿ nǐ cuu‑aⁿ ñaní tnáhá ndǐi Àrón. ");
INSERT INTO milNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Te ndɨ ndùú‑yu ío ní quide ndáá‑yu núú Dǔtú Ndiǒxí, chi ní tnɨɨ́‑yu nchaa tnúhu ní cáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Te ñá túú nì ɨɨⁿ déhe‑yu, chi ducaⁿ tǎhú tǎ Elisàbét sá vǎ cóó děhe‑aⁿ, te ducaⁿ ndɨ̀ nduú‑yu ío ní sahnú‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Te ɨɨⁿ nduu xìnu cuechi tucu té Zacàriá ndɨhɨ nchaa cue tée cùndɨhɨ‑dé núú Yǎ Ndiǒxí xɨtɨ́ veñúhu. ");
INSERT INTO milNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Te dàvá‑áⁿ nǐ xito ndeé‑güedé cuèndá cutnùní iní‑güedé nǔu ndědacàa‑güedé quɨ́hu núú nàá xɨtɨ́ veñúhu‑áⁿ cahmi‑güedé sá sàháⁿ tnámí, te ní cutnùní sá tě Zacàriá quɨ́hu‑dé. Te ducaⁿ nǐ quide‑güedé, chi ducaⁿ tnàhí ní xóo cada nchaa cue dútú dàvá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Te nɨni sàhmi té Zacàriá sá sàháⁿ tnámí nǔú nàá, te vài vihi ñáyiu xǐndecu quehé veñúhu‑áⁿ càháⁿ ndɨhɨ́‑yu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Te ní xiní té Zacàriá ɨɨⁿ espíritú xínú cuèchi núú Yǎ Ndiǒxí nútnɨ̌ɨ‑xi xio cùha núú nàá núú càyú sá sàháⁿ tnámí‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Te òré ní xiní té Zacàriá espíritú‑áⁿ te ñá ní cùtnuní iní‑dé nása cada‑dé chi ío ní yùhú‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Te espíritú‑áⁿ nǐ xáhaⁿ‑xi: —Zacàriá, vá yùhú‑n chi Yá Ndiǒxí ní tedóho‑gá tnúhu ní cáháⁿ‑n, te vitna coo ɨɨⁿ déhe ñadɨ̀hɨ́‑n tǎ Elisàbét te danàni‑n‑dé Juàá. ");
INSERT INTO milNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Te ío cudɨ́ɨ́ ìní‑n, te ducaⁿ ǐo vài ñáyiu cudɨ́ɨ́ ìní‑yu na càcu‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Te ío cudɨ̀u‑dé núú Yǎ Ndiǒxí, te ni vǎ cóhó‑dě ndidí te ni vǎ cóhó‑dě ndudí sá nǐ natɨu, te sa cundecu ndɨhɨ‑dé Espíritú Yǎ Ndiǒxí òré cacu‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Te dɨu‑dé cada te ío vài ñáyiu isràél natuhá‑yu ichi Dútú Ndiǒxí Yaá cúú Ndiǒxí‑ó. ");
INSERT INTO milNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Te té Juàá‑áⁿ codonùu‑dé núú‑gǎ, te cundecu ndɨhɨ‑dé Espíritú‑gá, te taxi tnùní‑dé dàtná ní quide té Èliás. Te nacanu ichi‑dé cue tée cùu sacuéhé cuèndá cada‑güedé sá vǎha sá cúú‑xí cuè tée cuechi, te cuěi cue tée ío sàá iní‑xi, te dɨu‑dé cada te tnɨɨ‑güedé tnúhu váha, tnúhu càháⁿ ñáyiu quìde ndáá. Te ducaⁿ càda‑dé cada túha‑dé ñáyiu cuèndá cunu cuèchí‑yu núú Dǔtú Ndiǒxí —càchí‑xi xǎhaⁿ‑xi xìi‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Te té Zacàriá ní ndúcú tnǔhu‑dé núú espíritú‑áⁿ, te xǎhaⁿ‑dě: —¿Te nása cutnùní ndáá iní‑í tnúhu càháⁿ‑n‑í? Chi yúhú ío ní sahnu‑í ndɨhɨ ñadɨ̀hɨ́‑í —càchí‑dé xǎhaⁿ‑dě xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Te espíritú‑áⁿ nǐ xáhaⁿ‑xi: —Yúhú cúù‑í espíritú nání Gàbriél, te xìnu cuechi‑í núú Yǎ Ndiǒxí, te mee‑gǎ ní táúchíúⁿ‑gǎ náhà‑í tnúhu‑gá véxi cuèndá cutnùní iní‑n nàcuáa cada ñaha‑gǎ xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Te vitna cuu ñɨ̀hɨ́‑n te vá càháⁿ‑gá‑n ndèé ná sàá nduu càcu déhe ñadɨ̀hɨ́‑n, chi ñá túú ní sàndáá‑ni iní‑n tnǔhu ní cáháⁿ‑í. Te dacuɨtɨ́í sǎá nduu càda‑xi nacuáa ní cáháⁿ‑í‑a —càchí espíritú‑áⁿ xǎhaⁿ‑xi xìi‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Te nchaa ñáyiu xǐndecu quehé ndétǔ‑yu té Zacàriá, te xǐcuñúhu‑yu sá ǐo cùyaa‑dé xɨtɨ́ veñúhu. ");
INSERT INTO milNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Te òré ní ndee té Zacàriá, te ñá ní cùu‑gá cáháⁿ ndɨhɨ ñaha‑dě xií‑yu, te òré‑áⁿ nǐ cutnùní iní‑yu sá nǐ xiní‑dé ɨɨⁿ espíritú xínú cuèchi núú Yǎ Ndiǒxí xɨtɨ́ veñúhu. Te mee‑nǎ ndaha‑dé ní quide‑dé núǔ‑yu chi ñá ní cùu‑gá cáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Te ní xínu nduu nǐ xinu cuechi tě Zacàriá núú Yǎ Ndiǒxí xɨtɨ́ veñúhu, te cuánuhú‑dé vehe‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Te sátá dúcáⁿ nǐ cuu te ñadɨ̀hɨ́‑dé tá Elisàbét ní ngúhuⁿ déhe‑aⁿ, te úhúⁿ yóó ñà túú tnàhí‑gá ní quèe‑aⁿ caca cuu‑aⁿ, te ní cachí‑aⁿ: ");
INSERT INTO milNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Mee Dǔtú Ndiǒxí duha ní cundàhú iní ñáhá‑gǎ sá cóó ɨ̀ɨⁿ déhe‑í cuèndá sá vǎ cúú yǐchí iní ñáhá ñǎyiu xii‑í”, duha ní cachí‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Te núú ìñú yóó sǎ nǐ ngúhuⁿ déhe tá Elisàbét, te ní tendaha tùcu Yá Ndiǒxí espíritú nání Gàbriél cuáháⁿ‑xi ɨɨⁿ ñuú nání Nàzarét cuáháⁿ ngoto‑xi ɨɨⁿ xíchí cuéchí nàni Mariá. Te ñuú‑áⁿ yɨ́ndèhu‑xi distritú Galìleá. Te xíchí‑ǎⁿ sa ní cundáá tnúhu sá tnǎndaha‑xi ndɨhɨ ɨɨⁿ tée nàni Cheé ñaní tnáhá ndǐi Dàvií. ");
INSERT INTO milNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Te espíritú‑áⁿ nǐ quɨ́hu‑xi ndéé xɨtɨ́ vehe núú ndécú tǎ Màriá, te ní xáhaⁿ‑xi: —¡Cóvǎha‑n‑aⁿ! Dútú Ndiǒxí ío cùu iní ñáhá‑gǎ xii‑n te ndècu ndɨhɨ ñaha‑gá, te ío‑gá xító ñàha‑gá xii‑n dàcúúxí dàva‑gá ñáyiu dɨ̀hɨ́ —càchí espíritú‑áⁿ xǎhaⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dico òré ní xiní tá Màriá espíritú‑áⁿ, te ní quɨyùhú iní‑xi sá dúcáⁿ nǐ cáháⁿ espíritú‑áⁿ. Te ní sani iní‑xi: “¿Ná cuèndá duha càháⁿ‑tu espíritú‑a‑i?”, duha ní sani iní‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Te espíritú‑áⁿ nǐ xáhaⁿ‑xi: —Màriá, vá yùhú‑n chi ducaⁿ nǐ nduu táhú‑n nǔu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Te vitna ngúhuⁿ déhe‑n, te na càcu‑dé te danàni‑n‑dé Jèsús. ");
INSERT INTO milNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Te ío cunuu‑dě, chi Dútú Ndiǒxí Yaá ío cùnuu cachí‑gá sá Děhe‑gá cúú‑dě, te dɨu‑gá cada te cuu‑dé ɨɨⁿ tée cùnuu núú ñǎyiu isràél dàtná ní quide‑gá ndíi Dàvií. ");
INSERT INTO milNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Te taxi tnùní‑dé ñáyiu isràél, te ducaⁿ‑ni cùnuu‑dé nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑xi xǎhaⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Te tá Màriá ní xáhaⁿ‑xi xìi espíritú‑áⁿ: —¿Te nása cuu tnúhu càháⁿ‑n te ñá túú yɨ̀ɨ‑í‑i? —càchí‑xi xǎhaⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Te ní xáhaⁿ espíritú‑áⁿ: —Espíritú Yǎ Ndiǒxí quixi cundecu ndɨhɨ‑n, te ducaⁿ Yǎ Ndiǒxí cada‑gá ɨɨⁿ sá vǎha sá cúú‑xí‑n ná càcu déhe‑n. Te Yá Ndiǒxí càchí‑gá sá ǐo cundecu yɨñùhu‑dé núú‑gǎ, chi Déhe‑gá cúú‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Te tnàhá didí‑n tǎ Elisàbét ñúhú děhe‑aⁿ cuěi ío ní sahnu‑aⁿ, te dɨu‑aⁿ càchí‑yu sá vǎ cóó děhe‑aⁿ ni cùu, te vitna sa ní cuu íñú yóó ñúhú děhe‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Chi Yá Ndiǒxí ndácú‑gǎ quídé‑gǎ nchaa sá vǎ yǒo tnàhí ndàcu cada —cachí‑xi xǎhaⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Te tá Màriá ní xáhaⁿ‑xi: —Yúhú ná cúnú cuèchi‑í núú Dǔtú Ndiǒxí, te mee‑gǎ ná cádá ñàha‑gá xii‑í nàcuáa ní cachí‑n —càchí‑xi xǎhaⁿ‑xi xìi espíritú‑áⁿ. Te sátá dúcáⁿ te espíritú‑áⁿ nǐ xica‑xi cuáháⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Te tá Màriá ío ndɨ̌hɨ cuáháⁿ‑xi ɨɨⁿ ñuú cáá xɨ̀tɨ́ yucu distrìtú Jùdeá. ");
INSERT INTO milNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Te ní sáá‑xi vehe té Zacàriá, te cuánguɨhu‑xi ní dándácǒo váha‑xi tá Elisàbét. ");
INSERT INTO milNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Te òré ní tecú dóho tá Elisàbét ní cáháⁿ tá Màriá, te ní candá déhe‑aⁿ xɨtɨ́‑aⁿ, te òré‑áⁿ nǐ ngúndecu ndɨhɨ‑aⁿ Espíritú Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Te níhi ní cáháⁿ‑aⁿ, te xǎhaⁿ‑aⁿ xìi tá Màriá: —Yá Ndiǒxí ío xìto ñaha‑gá xii‑n dàcúúxí dàva‑gá tnàha dɨhɨ́‑ó, te ducaⁿ‑ni xìto‑gá cuěi déhe‑n. ");
INSERT INTO milNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Te ná cúú yǔhú nǔu véxi coto ñaha yòhó nǎná Yaá cúú Xǐtohó‑í‑i? ");
INSERT INTO milNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Chi òré‑ni ní tecú dóho‑í ní cáháⁿ‑n te ní candá‑ni déhe‑í xɨtɨ́‑í sá cùdɨ́ɨ́ ìní‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Te váha táhú yòhó sá ni sàndáá iní‑n, chi dacuɨtɨ́í sǎ cádá Dǔtú Ndiǒxí nàcuáa ní cáháⁿ espíritú ní tendaha‑gǎ ní quixi ní cachí tnúhu xii‑n nàcuáa cada‑gá —càchí‑aⁿ xǎhaⁿ‑aⁿ xìi tá Màriá. ");
INSERT INTO milNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Te ní xáhaⁿ tǎ Màriá: Ío càhnu cuu Dútú Ndiǒxí, ");
INSERT INTO milNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ío cùdɨ́ɨ́ ìní‑í chi dɨu‑gá taunihnu ñaha‑gǎ xii‑í núú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Chi ní ndacu iní ñáhá‑gǎ xii yúhú, te dìcó ɨɨⁿ xíchí xínú cuèchi núú‑gǎ cúù‑í, te vitna te nchaandɨ túhú ñáyiu cachí‑yu sá ǐo váha táhù‑í. ");
INSERT INTO milNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Te Yá Ndiǒxí cándòo caa nine iní‑gá, te ío càhnu ɨɨⁿ sá vǎha ní quide‑gá sá cúú‑xì‑í. ");
INSERT INTO milNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Te cùndahú iní‑gá nchaa ñáyiu nèhe sá yɨ́ñùhu núú‑gǎ. Te ducaⁿ‑ni cuěi ñáyiu sa ndècu ñuyíú‑a ndɨhɨ ñáyiu vitna véxi. ");
INSERT INTO milNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Chi ta quìde‑gá nchaa sá vǎ yǒo tnàhí ndàcu cada véxi, te ta dàndóo canúú‑gǎ cue ñáyiu quìde cahnu mee‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Te cue ñáyiu tàxi tnuní ñá túú‑gǎ dáñá‑gǎ taxi tnùní‑yu, te cue ñáyiu ndàhú ní quide nínu ñaha‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Te cue ñáyiu ndècu ndɨhɨ tnúndòho tnúhu ndàhú ní quide váha ñaha‑gǎ xií‑yu, te cue ñáyiu cuica ñà túú nǎ ní nǐhí‑gǎ‑yu cundecu ndɨhɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Te chìndee‑gá ñáyiu isràél, ñáyiu xìnu cuechi núú‑gǎ, te ñá túú dàña nihnu ñaha‑gá xií‑yu, chi cùndahú iní ñáhá‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chi ducaⁿ nǐ xáhaⁿ‑gǎ xii ndíi Àbrahám, ndɨhɨ cue ñaní tnáhá ndǐi. Duha ní xáhaⁿ tǎ Màriá xii tá Elisàbét. ");
INSERT INTO milNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Te ní xíndecu tá Màriá dàtná úní yóó ndɨhɨ tá Elisàbét te dǎtnùní cuánuhú‑xi vehe‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Te ní sáá nduu nǐ cacu ɨɨⁿ déhe tée tá Elisàbét. ");
INSERT INTO milNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Te nchaa ñáyiu ndècu yatni ndɨhɨ‑aⁿ, ndɨhɨ nchaa ñaní tnáhá‑áⁿ nǐ níhǐ‑yu tnúhu nàcuáa ní chindee ñàha Yá Ndiǒxí xii‑aⁿ. Te ío ní cudɨ́ɨ́ ìní‑yu cuèndá‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Te núú ùná nduu sá nǐ cacu déhe‑aⁿ, te ní sáháⁿ ñáyiu núú ndécú‑áⁿ cuèndá cuáhǎ‑yu sèñá ñɨɨ déhe‑aⁿ. Te cuìní‑yu cunani děhe‑áⁿ Zacàriá dàtná nání tǎtá ní cùu. ");
INSERT INTO milNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Te ní xáhaⁿ nǎná děhe‑áⁿ: —Ñáhá, chi Juàá cunani‑dě —càchí‑aⁿ xǎhaⁿ‑aⁿ xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Te ní xáhǎⁿ‑yu: —¿Te ná cuèndá te ñá túú nì ɨɨⁿ ñaní tnáhá‑ndó dùcaⁿ nani‑i? —cachí‑yu xǎhǎⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Te ní quidé‑yu ndàhá‑yu núú tǎtá děhe‑áⁿ cuèndá cuìní‑yu núu nása cuìní méé‑dě cunani děhe‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Te ní xícáⁿ‑dé ɨɨⁿ tutú ní chídó tnùní‑dé nàcuáa cunani děhe‑dé, te duha ní chídó tnùní‑dé: “Juàá cunani‑dě”, càchí‑xi núú tùtú ní tee‑dé‑áⁿ. Te nchaa ñáyiu xǐndecu‑áⁿ nǐ cuñúhu‑yu nàcuáa ní cuu. ");
INSERT INTO milNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Te òré‑áⁿ nǐ nacáháⁿ té Zacàriá sá nǐ cuu ñɨ̀hɨ́‑dé ní cùu, te ní ngüíta‑dé ní cachí‑dé sá ǐo càhnu cuu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Te nchaa ñáyiu xǐndecu yatni ndɨhɨ‑dé ní cuñúhu‑yu, te nchaa ñáyiu xǐndecu nɨhìí xɨtɨ́ yucu distrìtú Jùdeá ní níhǐ‑yu tnúhu nàcuáa ní cuu. ");
INSERT INTO milNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Te nchaa ñáyiu‑áⁿ ǐo vài ní sani iní‑yu, te ní xítnàhá‑yu: —¿Ná cúú sǎ cádá těe‑ǎⁿ ndéé ìdá‑gá ná cuèhnu‑dé? —càchí‑yu xǐtnàhá‑yu. Te ducaⁿ nǐ xítnàhá‑yu chi Dútú Ndiǒxí ndécú ndɨ̀hɨ ñaha‑gá xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Te té Zacàriá tǎtá tě lǐhli‑áⁿ nǐ ngúndecu ndɨhɨ‑dé Espíritú Yǎ Ndiǒxí te ní cáháⁿ‑dé nchaa tnúhu sá nǐ dánèhé ñáhá‑gǎ, te ní cachí‑dé: ");
INSERT INTO milNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ío càhnu cuu Dútú Ndiǒxí nchoo ñǎyiu isràél, chi ní quixi coto ñaha‑gǎ xii‑o, te cùu‑o ñáyiu cùu cuendá‑gá, chi dàcácu nihnu ñaha‑gǎ xii‑o vìtna. ");
INSERT INTO milNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Chi ní tendaha‑gǎ ɨɨⁿ tée véxi‑dé dàcácu nihnu ñaha‑dě xii‑o nǔú ùhú núú ndàhú. Te cùu‑dé ñaní tnáhá ndǐi Dàvií tée ní xinu cuechi nǔú‑gǎ ndéé sanaha. ");
INSERT INTO milNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Te dɨu‑ni tnúhu ní cáháⁿ Yǎ Ndiǒxí ní cáháⁿ cue tée ní quide ndáá ní xíndecu núú‑gǎ ñuyíú‑a ndéé sanaha. ");
INSERT INTO milNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Te ní cachí‑güedé sá táúnìhnu ñaha‑gá xii‑o nǔú nchàa ñáyiu cùu úhú iní ñáhá, ndɨhɨ núú nchàa ñáyiu ñá túú cùu quiní ndee ñáhá. ");
INSERT INTO milNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Te ní xáhaⁿ‑gǎ sá cúndàhú iní ñáhá‑gǎ xii‑o, te ducaⁿ càda‑gá chi vá nácuànaa‑gá tnúhu ní cáháⁿ‑gá ndɨhɨ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Te dɨu ducaⁿ ndùu tnúhu ní xáhaⁿ‑gǎ xii ndíi Àbrahám sá ");
INSERT INTO milNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","táúnìhnu ñaha‑gá xii‑o nǔú nchàa ñáyiu cùu úhú iní ñáhá, cuèndá sá vǎ yùhú‑ó cùnu cuechi‑o núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Te cada ndáá‑ó, te cundecu yɨñùhu‑o núú‑gǎ ndɨ nchàa nduu cundecu‑o ñuyíú‑a. Duha ní cachí té Zacàriá. ");
INSERT INTO milNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Te xǎhaⁿ‑dě xii té lǐhli‑áⁿ: Te yòhó té lǐhli, cáháⁿ ñáyiu cuèndá‑n sǎ cúú‑n ɨ̀ɨⁿ tée càháⁿ tnúhu Dútú Ndiǒxí Yaá ío cùnuu, chi quɨ́hɨ́ⁿ‑n còdonuu‑n núú Yǎá cúú Xǐtohó‑ó dàtúha‑n ñǎyiu cuèndá cundecu túha‑yu òré quexìo‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Te cúñaha‑n xìi ñáyiu isràél sá cuìní‑gá cada càhnu iní‑gá nchaa cuéchi‑yu, te naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Te ducaⁿ càda‑gá chi ío cùu iní ñáhá‑gǎ xii‑o, chi ndéé andɨu nǐ tendaha‑gǎ ɨɨⁿ tée véxi cuuⁿ‑dé dandìxi túu‑dé iní‑ó cuèndá cutnùní iní‑ó nàcuáa ndùu cuendá Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Te ducaⁿ dàndixi túu‑dé iní nchaa ñáyiu ndècu ichi cuehé ichi duha ta xǐta nihnu cuáháⁿ cuèndá nucúnu ichí‑yu ɨɨⁿ ichi váha. Duha ní xáhaⁿ tě Zacàriá xii déhe‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Te té lǐhli‑áⁿ tá sàhnu‑dé, te ta chìndee chitúu ñaha Yǎ Ndiǒxí xii‑dé cuáháⁿ, te ní xíndecu‑dé xɨtɨ́ yucu ndéé ní sáá nduu nǐ ngüíta‑dé ní cáháⁿ‑dé núú cuè ñáyiu isràél tnúhu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Te dàvá‑áⁿ nǐ táúchíúⁿ tě Aùgustú Cèsár nucódó tnùní nchaa ñáyiu nàcióⁿ yɨ́ndàha‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Te xéhé sǎ dǐhnanuu nǐ nucódó tnùní ñáyiu, te dɨu‑ni dàvá‑áⁿ nǐ cunuu té Cìreniú distrìtú Sìriá. ");
INSERT INTO milNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Te nchaa ñáyiu ní natacá‑yu ñuú núú nǐ cacú‑yu cuèndá nucódó tnùní‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Núu xíǎⁿ ní quee té Chèé ñuú Nazàrét ɨɨⁿ ñuú yɨ́ndèhu distritú Galìleá, te cuáháⁿ‑dé ñuú Bèlén ɨɨⁿ ñuú yɨ́ndèhu distritú Jùdeá, chi xíáⁿ nǐ cuu ñuú ndíi Dàvií, te dɨu‑ni ñaní tnáhá tě Chèé‑áⁿ nǐ cuu ndíi. ");
INSERT INTO milNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Núu xíǎⁿ cuáháⁿ‑dé ndéé ñuú Bèlén nucódó tnùní‑dé, te tnàhá tá Màriá xíchí nǐ cundáá tnúhu sá tnǎndaha ndɨhɨ‑dé cuáháⁿ ndɨhɨ ñaha‑dě, te sa ñùhu déhe‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Te nɨni cùyaá‑yu ñuú Bèlén‑áⁿ nǐ sáá òré cacu déhe‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Te ní cacu déhe díhna‑xi, te ní chidúcúⁿnuu‑xi dóó, te ní sacáⁿ ñáhá‑xí ɨ̀ɨⁿ vehe núú cúú vèhe quɨtɨ, chi ñá túú ní nǐhǐ‑yu vehe coó‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Te yatni ñuú‑áⁿ xǐndecu ɨɨⁿ ǔú toli ndèé‑güedé mběé‑güedě ndécú‑güèdɨ majadá niú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Te uuⁿni ní quexìo ɨɨⁿ espíritú xínú cuèchi núú Yǎ Ndiǒxí, te Yá Ndiǒxí ní quide‑gá ní dáyèhé‑xi nɨ càndéé núú xǐndecu‑güedé, te ní yùhú víhí‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Te ní xáhaⁿ espíritú‑áⁿ: —Vá yùhú‑ndó, chi nàha‑í ɨɨⁿ tnúhu váha véxi sá cúú‑xí‑ndó, te ío cudɨ́ɨ́ ìní‑ndó ndɨ̀hɨ nchaa ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Chi vitna ní cacu ɨɨⁿ tée dàcácu nihnu ñaha xìi‑ndo núú ùhú núú ndàhú ñuú ndíi Dàvií, te tée‑áⁿ cúú‑dě Xítohó Jesucrìstú. ");
INSERT INTO milNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Te dàtná ɨɨⁿ sèñá te naníhí‑ndó tě lǐhli‑áⁿ yɨ́dǔcúⁿ nuu‑dé dóó cáá‑dě ɨɨⁿ vehe quɨtɨ —càchí‑xi xǎhaⁿ‑xi xìi‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Te òré‑áⁿ nǐ quexìo cuéhé víhí espíritú véxi cuuⁿ andɨu nǐ naníhí tnáhá‑xí ndɨ̀hɨ espíritú‑áⁿ, te ní ngüíta‑xi ní chiñuhu‑xi Yǎ Ndiǒxí, te càchí‑xi: ");
INSERT INTO milNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Ío càhnu cuu Yá Ndiǒxí Yaá ndécú àndɨu, te na cùndecu váha‑ni nchaa ñáyiu cùu iní méé‑gǎ! Duha càchí cue espíritú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Te òré cuándaa cue espíritú‑áⁿ andɨu, te ní ngüíta cue toli‑ǎⁿ xǐtnàha‑güedé: —Na quɨ̀hɨ́ⁿ‑ó ñùú Bèlén quiní‑ó nàcuáa ní cuu, chi Dútú Ndiǒxí sa ní cachí tnúhu‑gá —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Te ní tnɨɨ‑güedé ichi súúní ndɨ̌hɨ cuáháⁿ‑güedé, te ní naníhí‑güedě tá Màriá ndɨhɨ té Chèé, ndɨhɨ té lǐhli‑áⁿ cáá‑dě xɨtɨ́ ɨɨⁿ vehe quɨtɨ. ");
INSERT INTO milNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Te òré ní xiní ñáhá‑güedě te ní xáhaⁿ‑güedě xií‑yu nàcuáa ní xáhaⁿ espíritú‑áⁿ xii‑güedé cuèndá té lǐhli‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Te nchaa ñáyiu ní tecú dóho‑xi ní cuñúhu‑yu nàcuáa ní cáháⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Dico tá Màriá chi ñùhu nahi‑ni iní‑xi, te dìcó‑ni sàni iní‑xi cuèndá nchaa tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Te cue toli‑ǎⁿ nǐ natnɨɨ‑güedé ichi, te ta xǐtnàha‑güedé cuánuhú sá ǐo càhnu cuu Yá Ndiǒxí cuèndá nchaa tnúhu ní xíndedóho‑güedé, ndɨhɨ cuèndá nchaa sá nǐ xiní‑güedé, chi cuèndá sá ndàá ní cuu nchaa nàcuáa ní tecú tnúhu‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Te núú ùná nduu sá nǐ cacu té lǐhli‑áⁿ, te ní sáha‑güedé sèñá ñɨɨ‑dé, te ní dánání ñàha‑güedé Jèsús xii‑dé, dɨu‑ni nàcuáa ní xáhaⁿ espíritú xínú cuèchi núú Yǎ Ndiǒxí xii tá Màriá ndéé cútnàhá vátá ngǔhuⁿ‑gá‑dé xɨtɨ́‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Te sátá nǐ tnahá nduu, ndùu íǐ‑yu nàcuáa càháⁿ nchaa tnúhu ní chídó tnùní ndíi Moìsés, te ndècá‑yu té lǐhli‑áⁿ cuǎháⁿ ñuú Jerusàlén cuèndá quee túu‑dé núú Dǔtú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Te ducaⁿ nǐ quidé‑yu, chi ducaⁿ càháⁿ‑xi núú tùtú Yǎ Ndiǒxí sá ncháá làndú tée na càcu díhna quetúu‑güexi núú‑gǎ cuèndá cundecu‑ná‑güexi cuèndá‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Te ní quidé‑yu nàcuáa càháⁿ Yǎ Ndiǒxí núú tùtú‑gá núú càchí‑xi: “Canehe‑ndo ǔú lǒmá àdi úú cǔcu quɨ́hɨ́ⁿ nduu táhú ñáhá Yǎ Ndiǒxí”, duha càháⁿ‑gá núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Te dàvá‑áⁿ ndécú ɨ̀ɨⁿ tée nàni Mió ñuú Jerusàlén. Te ío váha iní‑dé, te chìñuhu‑dé Yǎ Ndiǒxí, te ndètu‑dé sáá nduu chìndee ñaha Yá Ndiǒxí xii ñáyiu isràél. Te ndècu ndɨhɨ té Mìó‑áⁿ Espíritú Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Te sa ní xáhaⁿ‑xi xìi‑dé sá vǎ cùú‑ni‑dé, chi dacuɨtɨ́í quìní‑dé Crìstú Yaá tendaha Yǎ Ndiǒxí quixi ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Te tée‑áⁿ ndécá ñàha Espíritú Yǎ Ndiǒxí xii‑dé cuáháⁿ veñúhu càhnu sá ǐo cùnuu. Te cuáháⁿ‑yu ndɨhɨ Jèsús veñúhu‑áⁿ cuèndá cadá‑yu ndɨhɨ‑gá nàcuáa càháⁿ tnúhu ní chídó tnùní ndíi Moìsés. ");
INSERT INTO milNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Te òré ní sáá‑yu, te té Mìó‑áⁿ nǐ nguɨ́dèhé‑dé Jèsús, te ní cáháⁿ‑dé sá ǐo càhnu cuu Yá Ndiǒxí, te ní xáhaⁿ‑dě xii‑gá: ");
INSERT INTO milNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Yòhó Dútú Ndiǒxí sa ní cuu daña‑n cùú‑í vitna, chi sa ní quide‑n nàcuáa ní cachí‑n xìi yúhú tée xìnu cuechi núú‑n. ");
INSERT INTO milNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chi sa ní xiní núù‑í Yaá dàcácu nihnu ñaha xìi ñáyiu núú ùhú núú ndàhú vitna. ");
INSERT INTO milNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Te Yaá ní tendaha‑n věxi núú ndécú nchàa ñáyiu ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Te cùu‑gá dàtná ɨɨⁿ ñuhú, chi dandìxi túu‑gá iní ñáyiu cuèndá cutnùní iní‑yu cuèndá Yǎ Ndiǒxí cuěi ñá dɨ́ú ñǎyiu isràél cúǔ‑yu. Te dɨu‑gá cada, te canehe ñáyiu dava‑gá ñuú sá yɨ́ñùhu núú ñǎyiu isràél chi dɨu ñáyiu isràél cúǔ‑yu ñáyiu cùu cuendá‑n. Duha ní xáhaⁿ tě Mìó xii Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Te té Chèé ndɨhɨ nǎná Jèsús ní cuñúhu‑yu tnúhu ní cáháⁿ té Mìó cuèndá‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Te dǎtnùní té Mìó ní xícáⁿ táhú‑dě núú Yǎ Ndiǒxí cuèndá‑yu, te xǎhaⁿ‑dě xii tá Màriá nǎná Jèsús: —Cundedóho tnúhu na càháⁿ‑í‑a, té lǐhli‑a ní nduu táhú‑dě nacanu ichi‑dé dava ñáyiu isràél ichi Yá Ndiǒxí, te davá‑yu vá tnɨ́ɨ̌‑yu tnúhu cáháⁿ‑dé, te ñáyiu‑áⁿ cuǐta nihnú‑yu, te cada‑dé nàcuáa cutnùní iní ñáyiu sá Yǎ Ndiǒxí ní tendaha ñàha‑gá xii‑dé, dico vá quɨ̀ndáá iní‑yu, chi daquèe tɨ́hú ñáhǎ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Te ducaⁿ te cutnùní nàcuáa sàni iní ɨɨⁿ ɨɨⁿ ñáyiu. Dico sá cúú‑xí yòhó chi ío cada ndàhú‑xi iní‑n, chi súúní dàtná sá nǐ nícuèhé iní‑n càda‑xi —cachí‑dé xǎhaⁿ‑dě xii tá Màriá. ");
INSERT INTO milNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Te xíáⁿ ndécú tnàhá ɨɨⁿ ñaha càháⁿ tnúhu Yá Ndiǒxí nání‑áⁿ Àná, te tǎtá‑aⁿ ní xínani‑dě Fànuél ñaní tnáhá ndǐi Àsér. Te ñaha‑áⁿ sa ní sahnu vìhi‑aⁿ, te cuechi‑ni‑aⁿ nǐ tnándaha‑aⁿ te úsá‑ni cuíá nǐ xíndecu‑aⁿ ndɨhɨ yɨɨ‑aⁿ, ");
INSERT INTO milNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","te ní quendóo quèé‑aⁿ, te sa ñùhu‑aⁿ cúmídícó cǔmí cuǐá‑aⁿ. Te ñá túú ní xǒo quee‑aⁿ veñúhu càhnu sá ǐo cùnuu, chi nduu nìú ní xóo chiñuhu‑aⁿ Dútú Ndiǒxí, te áma ñá túú tnàhí ná ní xǒo caxi‑aⁿ ní xóo cáháⁿ ndɨhɨ‑aⁿ Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Te dɨu‑ni òré ndécǔ‑yu ndɨhɨ Jèsús ní quexìo‑aⁿ núǔ‑yu, te ní ndacáⁿ táhú‑áⁿ nǔú Yǎ Ndiǒxí cuèndá sá nǐ xiní‑aⁿ Jèsús, te dǎtnùní ní ngüíta‑aⁿ càháⁿ váha‑aⁿ cuèndá‑gá núú nchàa ñáyiu, ñáyiu ndètu quiní sáá nduu dàcácu Yá Ndiǒxí ñáyiu Jerusàlén núú tnǔndòho tnúhu ndàhú. ");
INSERT INTO milNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Te sátá nǐ quidé‑yu nchaa nàcuáa càháⁿ tnúhu Yá Ndiǒxí, te cuánuhú‑yu ñuú Nazàrét núú ndécú tnàhí‑yu, te ñuú‑áⁿ yɨ́ndèhu‑xi distritú Galìleá. ");
INSERT INTO milNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Te té lǐhli nàni Jesús‑áⁿ tá sàhnu‑dé, te ta nìhí ndéé‑dě cuáháⁿ, te ducaⁿ ǐo váha ta sàá sá xìní tnùní‑dé cuáháⁿ, chi Yá Ndiǒxí ndécú ndɨ̀hɨ ñaha‑gá xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Te ndɨ tnahá cuíá nǐ xóo quɨ́hɨ́ⁿ té Chèé ndɨhɨ nǎná Jèsús vico pàscuá ñuú Jerusàlén. ");
INSERT INTO milNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Te cútnàhá ní chítú Jèsús úxúú cuíá‑gǎ, te cuáháⁿ‑yu ndɨhɨ‑gá ñuú Jerusàlén vico pàscuá, chi ducaⁿ tnàhí quìdé‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Te òré ní yáha vico, te ní natnɨɨ́‑yu ichi cuánuhú‑yu, te ní quendóo‑gá ñuú Jerusàlén, te ni nǎná‑gǎ, te ni tě Chèé ñá túú ní xìní ní quendóo‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Chi ní sani iní‑yu sá ñútnàhá‑gá tnuú nchaa ñáyiu ní sáháⁿ vico cuánuhú. Te ní xúhuⁿ‑yu ɨɨⁿ nduu ichi ta ndùcu tnúhu‑yu‑gá núú nchàa ñaní tnáhǎ‑yu, ndɨhɨ núú nchàa ñáyiu xìní tnáhá ndɨ̀hɨ́‑yu, ");
INSERT INTO milNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","te ñá túú ní nàníhí ñáhǎ‑yu xii‑gá. Núu ní nacuìcó‑yu cuánuhú tucú‑yu ñuú Jerusàlén cuèndá yàcáⁿ nanducu ñàhá‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Te núú ùní nduu sá nǐ dana núú ñáhǎ‑yu xii‑gá, te ní naníhí ñáhǎ‑yu nùcóo‑gá xɨtɨ́ veñúhu càhnu sá ǐo cùnuu tnuú cue tée dàcuaha ñaha xií‑yu nchaa tnúhu ní chídó tnùní ndíi Moìsés, te ndèdóho ñaha‑gǎ xii‑güedé, te nándɨ sá ndúcú tnǔhu‑gá núú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Te nchaa cue tée xǐndedóho ñaha xìi‑gá xǐcuñúhu‑güedé sá ǐo váha sàá sá xìní tnùní‑gá, te ío váha nìhí‑gá tnúhu nàdanchocáva‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Te òré ní xiní ñáhá tě Chèé ndɨhɨ nǎná‑gǎ xii‑gá, te ío ní cuñúhu‑yu, te ní xáhaⁿ nǎná‑gǎ xii‑gá: —Yòhó déhe‑í, ¿ná cuèndá ducaⁿ nǐ quide ñaha‑n xìi‑ndɨ́? Te tǎtá‑n ndɨ̀hɨ yúhú ndɨ̀hú iní‑ndɨ́ xícá nànducu ñaha‑ndɨ́ xii‑n —càchí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Te ní xáhaⁿ Jèsús xií‑yu: —¿Ná cuèndá nándùcu ñaha‑ndo? ¿Náa ñá túú xìní‑ndó sǎ nǔú chíúⁿ Tǎtà‑í tàú‑í caca cuu‑í‑ǎⁿ? —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Dico mèé‑yu ñá túú ní tècú tnùní‑yu nàcuáa ní xáhaⁿ‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Te sátá dúcáⁿ te cuánuhú ndɨhɨ ñàhá‑yu xii‑gá ñuú Nazàrét, te ío ní sándáá iní ñáhá‑gǎ xií‑yu. Te nchaa sá nǐ quide‑gá‑áⁿ nǐ xúhuⁿ nahi‑ni ìní nǎná‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Te Jèsús ducaⁿ‑ni ta sàhnu‑gá cuáháⁿ, te ta sàá‑gá sá xìní tnùní‑gá cuáháⁿ, te ducaⁿ cùdɨu‑gá núú Yǎ Ndiǒxí, ndɨhɨ núú nchàa ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Te ní cuu sáhúⁿ cuíá sǎ yɨ́ndàha té Tìberiú cuéhé nàcióⁿ, te dàvá‑áⁿ nǐ cunuu té Pìlatú distrìtú Jùdeá, te té Hèrodés ní cunuu‑dě distrìtú Galìleá, te ñaní‑dé té Lìpé ní cunuu‑dě distrìtú Itùreá ndɨhɨ ɨngá distrìtú nání Tràconité, te té Lisàniás ní cunuu‑dě distrìtú Abìliniá. ");
INSERT INTO milNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Te té Ànás ndɨhɨ té Caìfás ní cuu‑güedé dútú cúnùu. Te dàvá‑áⁿ nǐ cáháⁿ ndɨhɨ ñaha Yǎ Ndiǒxí xii té Juàá déhe té Zacàriá xɨtɨ́ yucu sá quɨ̀hɨ́ⁿ‑dé cáháⁿ‑dé tnúhu‑gá núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Te té Juàá ní yáha‑dé nchaa ñuú cáá yàtni yúte Jòrdán, te xǎhaⁿ‑dě xii nchaa ñáyiu: —Chí dándìxi túu iní sá ñà túú quìde váha‑ndo, te daña‑ndo nchàa ichi cuehé ichi duha ndècu‑ndo, te cuandute‑ndo, te ducaⁿ te cada càhnu iní Yǎ Ndiǒxí nchaa yícá cuěchi‑ndo —duha ní xáhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Te ducaⁿ nǐ quide‑dé chi ní quee ndáá‑xi nàcuáa ní chídó tnùní ndíi Chàiá tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǔú tùtú ndíi núú càchí‑xi: Tècú càháⁿ níhi ɨɨⁿ tée yɨ̀hɨ xɨtɨ́ yucu, te xǎhaⁿ‑dě xii ñáyiu: “Chí dáñá nchàa ichi cuehé ichi duha ndècu‑ndo, te tnɨɨ‑ndo ìchi váha, te ducaⁿ càda‑ndo cuendá cundecu túha‑ndo, chi véxi Yaá ío cùnuu. ");
INSERT INTO milNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Te nchaa núú cùnú nachítú, te nchaa tɨndúú ndɨhɨ nchaa yucu ngoyo nihnu cuèndá nduu ndáá, te nchaa ichi ñá túú cuǎháⁿ ndáá nduu ndáá, te nchaa ichi ñá túú càváha nduu váha. ");
INSERT INTO milNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Te nchaa ñáyiu ñuyíú‑a níhǐ‑yu tnúhu sá Yǎ Ndiǒxí véxi‑gá dàcácu nihnu ñaha‑gǎ xií‑yu núú ùhú núú ndàhú.” Duha ní chídó tnùní ndíi Chàiá núú tùtú ndíi. ");
INSERT INTO milNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Te òré ní xica ñáyiu cuáháⁿ‑yu cuèndá dacuàndute ñaha té Juàá xií‑yu, te ní xáhaⁿ‑dě: —¡Nchaa nchòhó cúú‑ndó dàtná ɨɨⁿ cóó děéⁿ chi ío cuihna ìní‑ndó! ¿Te nása ní cuu núu tnàhá nchòhó ndúcú‑ndó nàcuáa cácu nihnu‑ndo nǔú tnǔndòho cahnu vihi sá tá cùyatni ñaha xii‑ndo véxi‑i? ");
INSERT INTO milNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Te chí cádá vǎha vitna cuèndá ducaⁿ cùtnuní sá nǐ dáñá‑ndó nchàa ichi cuehé ichi duha ndècu‑ndo. Te vá càchí‑ndó sǎ ǐo càhnu cuu‑ndo cuendá sá cúú‑ndó ñàní tnáhá ndǐi Àbrahám, chi cuěi ndéé yúú te ndacu Yá Ndiǒxí ndada‑gá ñáyiu te cuú‑yu ñaní tnáhá ndǐi Àbrahám. ");
INSERT INTO milNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Te caá chi ndècu túha‑xi sá quèhndé‑xi nchaa yutnu sá ñà túú càváha sávìdí‑xi, chi nchaa yutnu‑áⁿ tèhndé‑xi te cuánguee‑xi núú ñùhú càyú‑xi. Te duha sǎtnahá‑xi ndoho nchaa ñáyiu ñá túú quìde váha, chi nchaa ñáyiu ducaⁿ ñà túú quìde váha cùú‑yu dàtná nchaa yutnu sá ñà túú càváha sávìdí‑xi. —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Te ní xícáⁿ tnúhu‑yu núú‑dě, te xǎhǎⁿ‑yu: —¿Te nása cada‑ndɨ́ váíⁿ? —càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Te xǎhaⁿ‑dě: —Te núu ndědacàa‑ndo ndecu ndɨhɨ‑ndo úú dóó te cuáñaha‑ndo ɨ̀ɨⁿ xii ñáyiu ñá túú ndècu ndɨhɨ, àdi núu ndècu ndɨhɨ‑ndo sá nchító‑ó te cuáha‑ndǒ‑yu na càxí‑yu —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Te ní quexìo ɨɨⁿ úú cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú cuèndá cuàndute‑güedé, te ní xícáⁿ tnúhu‑güedé núú tě Juàá, te xǎhaⁿ‑güedě: —Mèstrú, ¿te nása cada‑ndɨ́ cuèndá cuu váha iní Yǎ Ndiǒxí‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Te té Juàá ní xáhaⁿ‑dě: —Vá cuìdó‑ndó càda cobrá‑ndó ñǎyiu —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Te tnàhá ɨɨⁿ ǔú cue tée cùu sandadú xǐndecu‑áⁿ nǐ xícáⁿ tnúhú‑güedě núú tě Juàá, te xǎhaⁿ‑güedě: —Te nchúhú ¿nása cada‑ndɨ́ cuèndá cuu váha iní Yǎ Ndiǒxí‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. Te ní xáhaⁿ tě Juàá: —Vá quéndèé‑ndó sǎ néhé tnàha ñáyiu‑ndo, te ni vǎ dácàa dɨ́quɨ́‑ndǒ‑yu ɨɨⁿ sá ñà túú nǎ quídě‑yu, te nduu vétú iní‑ndó nàcuáa ñùhu yáhu‑ndo —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Te nchaa ñáyiu xǐndetu sá quíxí Crìstú sàni ɨɨⁿ sani úú iní‑yu núu sá dɨ́ú Crìstú Yaá tendaha Yǎ Ndiǒxí quixi ñuyíú‑a cùu te Juàá àdi ñáhá. ");
INSERT INTO milNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Dico té Juàá ní cáháⁿ ndodo‑dé núǔ‑yu nchaá‑yu, te xǎhaⁿ‑dě: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ yǔhú véxi‑í sá cuèndá‑ni dacuàndute ñaha‑í xii‑ndo dàtná ní cachí Yǎ Ndiǒxí, dico nchìcúⁿ ɨngá tée véxi, te tée‑áⁿ taxi‑dé Espíritú Yǎ Ndiǒxí cundecu ndɨhɨ‑ndo, te cùu‑xi datná ɨɨⁿ ñuhú, chi ndada ndoo ndada nine‑xi iní‑ndó. Te tée‑áⁿ ǐo‑gá cúnùu‑dé dàcúúxí yǔhú, chi yúhú cúù‑í ɨɨⁿ tée duuⁿ duuⁿ ñá túú tàú‑í nandaxi‑ǐ cuědìcó ñɨɨ chàú‑dé dico quìde‑í chìuⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Te tée‑áⁿ sa véxi túha‑dé sá cádá dɨ̀ɨⁿ ñaha‑dé xii‑o dàtná quídé ñǎyiu ndàda ndoo triú, chi ñáyiu‑áⁿ sa nèhe túha‑ná‑yu yaxíⁿ‑yu òré náñǎni cuèndá ndada ndoó‑yu, te òré ndádá ndòó‑yu trìú‑áⁿ te dàquee dɨɨ́ⁿ‑yu mihi‑xi, te tàxúha‑yu mee‑nǎ trìú‑áⁿ, te mihi‑xi‑áⁿ sáhmǐ‑yu. Te dàtná quídě‑yu mihi trìú‑áⁿ ducaⁿ sǎtnahá‑xi cada ñaha tée‑áⁿ xii nchaa ñáyiu ñá túú quìde váha, chi daquɨ̀hɨ́ⁿ ñáhá‑dě xií‑yu núú ñùhú núú càyú, te ñuhú‑áⁿ ñà túú tnàhí ndàhvá —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Te tɨtnɨ́ víhí‑gǎ tnúhu váha ní xáhaⁿ tě Juàá xií‑yu òré ní dásàhú ñáhá‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Te ní cáháⁿ‑dé dóho té Hèrodés cuèndá sá ndécá‑dě ɨɨⁿ ñaha nàni Herodiás ñaha ní cándeca ñaní‑dé té Lìpé, te ní xáhaⁿ‑dě cuèndá nchaa dava‑gá sá cuèhé sá dúhá quìde‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Dico té Hèrodés ñá túú ní quìde cuendá‑dé tnúhu ní cáháⁿ té Juàá, chi nèhé‑gá tucu ní quide‑dé, chi da vecaá ní chihi‑dé té Juàá. ");
INSERT INTO milNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Te òré dácuàndute té Juàá nchaa ñáyiu, te tnàhá Jèsús ní dácuándùte ñaha‑dé xii‑gá. Te nɨni càháⁿ ndɨhɨ‑gá Dútú Ndiǒxí ní nacaáⁿ andɨu, ");
INSERT INTO milNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","te ní quee Espíritú Yǎ Ndiǒxí véxi cuuⁿ túu‑xi, te càa‑xi datná cáá ɨ̀ɨⁿ lómá, te òré‑áⁿ nǐ tecú ní cáháⁿ Yǎ Ndiǒxí ndéé andɨu, te xǎhaⁿ‑gǎ xii Jèsús: —Yòhó cúú‑n Děhe‑í tée ío cùu iní‑í, te ío cùdɨ́ɨ́ ìní ñáhà‑í xii‑n —càchí‑gá xǎhaⁿ‑gǎ xii Jèsús. ");
INSERT INTO milNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Te ndècu Jesús dàtná ócó úxí cuíá‑gǎ cútnàhá ní chisaha‑gǎ chìuⁿ ní táhú Tǎtá‑gǎ Dútú Ndiǒxí cada‑gá. Te ní cuu‑gá déhe té Chèé chi ducaⁿ sàni iní ñáyiu ñuyíú‑a. Te té Chèé‑áⁿ nǐ cuu‑dé déhe té Èlí, ");
INSERT INTO milNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","te tée‑áⁿ nǐ cuu‑dé déhe té Màtát. Te té Màtát‑áⁿ nǐ cuu‑dé déhe té Lèví, te tée‑áⁿ nǐ cuu‑dé déhe té Mèlquí. Te té Mèlquí‑áⁿ nǐ cuu‑dé déhe té Jàná, te tée‑áⁿ nǐ cuu‑dé déhe té Chèé. ");
INSERT INTO milNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Te té Chèé‑áⁿ nǐ cuu‑dé déhe té Matàtiás, te tée‑áⁿ nǐ cuu‑dé déhe té Àmós. Te té Àmós‑áⁿ nǐ cuu‑dé déhe té Nàhúm, te tée‑áⁿ nǐ cuu‑dé déhe té Èslí. Te té Èslí‑áⁿ nǐ cuu‑dé déhe té Nagàí, ");
INSERT INTO milNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","te tée‑áⁿ nǐ cuu‑dé déhe té Màát. Te té Màát‑áⁿ nǐ cuu‑dé déhe té Matàtiás, te tée‑áⁿ nǐ cuu‑dé déhe té Semèí. Te té Semèí‑áⁿ nǐ cuu‑dé déhe té Chèé, te tée‑áⁿ nǐ cuu‑dé déhe té Jùdá. ");
INSERT INTO milNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Te té Jùdá‑áⁿ nǐ cuu‑dé déhe té Jòaná, té tée‑áⁿ nǐ cuu‑dé déhe té Rèsá. Te té Rèsá‑áⁿ nǐ cuu‑dé déhe té Zorobàbél, te tée‑áⁿ nǐ cuu‑dé déhe té Salàtiél. Te té Salàtiél‑áⁿ nǐ cuu‑dé déhe té Nèrí, ");
INSERT INTO milNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","te tée‑áⁿ nǐ cuu‑dé déhe té Mèlquí. Te té Mèlquí‑áⁿ nǐ cuu‑dé déhe té Àdí, te tée‑áⁿ nǐ cuu‑dé déhe té Còsám. Te té Còsám‑áⁿ nǐ cuu‑dé déhe té Elmòdám, te tée‑áⁿ nǐ cuu‑dé déhe té Ěr. ");
INSERT INTO milNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Te té Ěr‑áⁿ nǐ cuu‑dé déhe té Jòsué, te tée‑áⁿ nǐ cuu‑dé déhe té Elièzér. Te té Elièzér‑áⁿ nǐ cuu‑dé déhe té Jòrím, te tée‑áⁿ nǐ cuu‑dé déhe té Màtát. ");
INSERT INTO milNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Te té Màtát‑áⁿ nǐ cuu‑dé déhe té Lèví, te tée‑áⁿ nǐ cuu‑dé déhe té Mìó. Te té Mìó‑áⁿ nǐ cuu‑dé déhe té Jùdá, te tée‑áⁿ nǐ cuu‑dé déhe té Chèé. Te té Chèé‑áⁿ nǐ cuu‑dé déhe té Jònán, te tée‑áⁿ nǐ cuu‑dé déhe té Eliàquím. ");
INSERT INTO milNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Te té Eliàquím‑áⁿ nǐ cuu‑dé déhe té Mèleá, te tée‑áⁿ nǐ cuu‑dé déhe té Maìnán. Te té Maìnán‑áⁿ nǐ cuu‑dé déhe té Màtatá, te tée‑áⁿ nǐ cuu‑dé déhe té Nàtán. ");
INSERT INTO milNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Te té Nàtán‑áⁿ nǐ cuu‑dé déhe té Dàvií, te tée‑áⁿ nǐ cuu‑dé déhe té Isàí. Te té Isàí‑áⁿ nǐ cuu‑dé déhe té Òbéd, te tée‑áⁿ nǐ cuu‑dé déhe té Bòóz. Te té Bòóz‑áⁿ nǐ cuu‑dé déhe té Sàlmón, te tée‑áⁿ nǐ cuu‑dé déhe té Naàsón. ");
INSERT INTO milNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Te té Naàsón‑áⁿ nǐ cuu‑dé déhe té Aminàdáb, te tée‑áⁿ nǐ cuu‑dé déhe té Àrám. Te té Àrám‑áⁿ nǐ cuu‑dé déhe té Èsróm, te tée‑áⁿ nǐ cuu‑dé déhe té Fàrés. Te té Fàrés‑áⁿ nǐ cuu‑dé déhe té Jùdá, ");
INSERT INTO milNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","te tée‑áⁿ nǐ cuu‑dé déhe té Jàcób. Te té Jàcób‑áⁿ nǐ cuu‑dé déhe té Isàác, te tée‑áⁿ nǐ cuu‑dé déhe té Àbrahám. Te té Àbrahám‑áⁿ nǐ cuu‑dé déhe té Tàré, te tée‑áⁿ nǐ cuu‑dé déhe té Nàcór. ");
INSERT INTO milNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Te té Nàcór‑áⁿ nǐ cuu‑dé déhe té Sèrúg, te tée‑áⁿ nǐ cuu‑dé déhe té Ragàú. Te té Ragàú‑áⁿ nǐ cuu‑dé déhe té Pèlég, te tée‑áⁿ nǐ cuu‑dé déhe té Hèbér. Te té Hèbér‑áⁿ nǐ cuu‑dé déhe té Sàlá, ");
INSERT INTO milNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","te tée‑áⁿ nǐ cuu‑dé déhe té Caìnán. Te té Caìnán‑áⁿ nǐ cuu‑dé déhe té Arfàxád, te tée‑áⁿ nǐ cuu‑dé déhe té Sěm. Te té Sěm‑áⁿ nǐ cuu‑dé déhe té Nǒé, te tée‑áⁿ nǐ cuu‑dé déhe té Làméc. ");
INSERT INTO milNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Te té Làméc‑áⁿ nǐ cuu‑dé déhe té Matusàlén, te tée‑áⁿ nǐ cuu‑dé déhe té Ènóc. Te té Ènóc‑áⁿ nǐ cuu‑dé déhe té Jàréd, te tée‑áⁿ nǐ cuu‑dé déhe té Mahalàleél. Te té Mahalàleél‑áⁿ nǐ cuu‑dé déhe té Caìnán, ");
INSERT INTO milNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","te tée‑áⁿ nǐ cuu‑dé déhe té Ènós. Te té Ènós‑áⁿ nǐ cuu‑dé déhe té Sět, te tée‑áⁿ nǐ cuu‑dé déhe té Àdán. Te té Àdán‑áⁿ chi mee Yǎ Ndiǒxí ní cadúha ndaha ñàha‑gá xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Te Jèsús ní naqueheⁿ‑gá ichi yuhu yúte Jòrdán cuánuhú‑gá. Te sa ndècu ndɨhɨ‑gá Espíritú Yǎ Ndiǒxí, te Espíritú‑áⁿ ndécá ñàha‑xi xii‑gá cuáháⁿ ɨɨⁿ xɨtɨ́ yucu. ");
INSERT INTO milNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Te yàcáⁿ ní xíndecu‑gá údico nduu, te sácuíhná nǐ cuiní‑xi coto ndeé ñáhá‑xí xìi‑gá te núu ndisa sá vǎ cádá‑gǎ ɨɨⁿ sá ñà túú tàú‑gá cada‑gá. Te ñá túú tnàhí ná ní xèxi‑gá ndɨ ǔdico nduu‑áⁿ, te sátá dúcáⁿ te ní xícáⁿ iní‑gá caxi‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Te sácuíhná‑ǎⁿ nǐ xáhaⁿ‑xi xìi‑gá: —Te núu ndisa sá cúú‑n Děhe Yá Ndiǒxí, te cúñaha xìi yúú‑a na ndùu‑xi paá —càchí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Te Jèsús ní xáhaⁿ‑gǎ xii‑xi: —Núú tùtú Yǎ Ndiǒxí càchí‑xi: “Ñá dɨ́ú mèe‑ni paá candeca‑xi iní ñáyiu, chi tnàhá nchaa tnúhu càháⁿ Yǎ Ndiǒxí candeca‑xi iní‑yu”, duha càchí‑xi núú tùtú‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Te dǎtnùní sácuíhná ndécá ñàha‑xi xii‑gá cuáháⁿ ɨɨⁿ núú tɨ̀ndúú dùcúⁿ, te uuⁿni ní dánèhé núú ñáhá‑xí xìi‑gá nchaandɨ túhú nàcióⁿ cáá ñùyíú. ");
INSERT INTO milNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Te ní xáhaⁿ‑xi xìi‑gá: —Yúhú cada‑í, te taxi tnùní‑n nchàa‑ndɨ túhú nàcióⁿ‑a ndɨhɨ nchaa sá vǎha ìó dɨu‑ni nchaa nàcióⁿ‑a, te cachí ñáyiu sá ǐo cùnuu‑n, chi yúhú cúú cuèndá‑í nchaa sá ìó nchaa nàcióⁿ‑a, te ndědani càa ñáyiu cùu iní‑í te cúñaha‑ǐ xií‑yu taxi tnùní‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Te núu nɨ yùhu nɨ iní‑n chìñuhu ñaha‑n xii‑í ñá, te nchaa taxi‑í cuu cuèndá‑n —càchí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Te Jèsús ní xáhaⁿ‑gǎ xii‑xi: —Xocuɨ̀ñɨ́ yòhó sácuíhná nǔú ndécù‑í‑a, chi vá cúú càda‑í nàcuáa càchí‑n chi núú tùtú Yǎ Ndiǒxí càchí‑xi: “Chiñuhu‑ndo Dǔtú Ndiǒxí Yaá cúú Ndiǒxí‑ndó, te ɨɨⁿdìi díí‑ni‑gǎ cada‑ndo nchàa nacuáa càháⁿ‑gá”, duha càchí‑xi núú tùtú‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Te sácuíhná ndécá ñàha tucu‑xi xii‑gá cuáháⁿ ñuú Jerusàlén, te ní xáhaⁿ‑xi xìi‑gá cuásaá‑gá dɨ́quɨ́ veñúhu càhnu sá ǐo cùnuu, te ní xáhaⁿ tùcu‑xi: —Te núu ndisa cùu‑n Déhe Yá Ndiǒxí te cuandèe ndava ndéé núú ñúhú ");
INSERT INTO milNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","cuèndá quee ndáá‑xi nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí núú càchí‑xi: Yá Ndiǒxí tendaha‑gǎ cue espíritú xínú cuèchi núú‑gǎ quixi‑xi coto ñaha‑xi xìi‑n. ");
INSERT INTO milNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Te núú ndáhá‑xí càundodo‑n cuendá sá vǎ dánǐcuèhé yúú sǎhá‑n, duha càchí‑xi núú tùtú‑gá —càchí sácuíhná xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Te Jèsús ní xáhaⁿ‑gǎ xii‑xi: —Te càchí tucu‑xi núú tùtú Yǎ Ndiǒxí: “Vá cání ìní‑n còto ndeé‑n Dǔtú Ndiǒxí Yaá cúú Ndiǒxí‑n nǔu ndisa sá dácǎcu nihnu ñaha‑gǎ xii‑n cuèndá ɨɨⁿ sá sání ìní‑n càda‑n sá cúú‑xí mèe‑n”, duha càchí‑xi núú tùtú‑gá —càchí‑gá xǎhaⁿ‑gǎ xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Te sátá dúcáⁿ te sácuíhná ñà túú‑gǎ ní cùtnuní iní‑xi nása cada‑xi Jèsús, núu xíǎⁿ ní xica‑xi cuáháⁿ‑xi ní sanaa tnaa‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Te Jèsús cuáháⁿ tucu‑gá distrìtú Galìleá, dico sa ndècu ndɨhɨ‑gá Espíritú Yǎ Ndiǒxí, te nɨ càa xico xíáⁿ nǐ níhǐ‑yu tnúhu nchaa nàcuáa quìde‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Te ndɨ tnahá ñuú cuáháⁿ‑gá ducaⁿ cuǎnguɨhu‑gá veñúhu‑yu dànehé ñáhá‑gǎ xií‑yu, te nchaá‑yu càchí‑yu sá ǐo càhnu cuu‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Te Jèsús ní sáháⁿ‑gá ñuú Nazàrét ñuú núú nǐ sahnu‑gá. Te nduu ndètatú ñáyiu ní quɨ́hu‑gá veñúhu, chi ducaⁿ tnàhí quìde‑gá, te ní ngúnutnɨ́ɨ‑gá dácuàha‑gá tutú ndèé tnúhu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Te ní sáñaha‑güedě xii‑gá tutú ndèé tnúhu ní cáháⁿ ndíi Chàiá tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, te òré ní nandɨcá‑gá núú tùtú‑áⁿ te ní naníhí‑gǎ núú càchí‑xi: ");
INSERT INTO milNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritú Yǎ Ndiǒxí ndécú ndɨ̀hɨ ñaha‑xi xii‑í, chi ní cachí‑gá sá càháⁿ‑í tnúhu‑gá sá cúú‑xí ñǎyiu ndàhú, ñáyiu vátá cúndèdóho tnàhí‑gá. Te véxi‑í cuèndá vá ndɨ̀hú‑gá iní ñáyiu ñá túú ndècu váha iní‑xi, te cue ñáyiu sa nèhe váha ñaha‑nǎ yucu ñǎvǎha dàcácu nihnu‑í‑yu. Te cue ñáyiu cuàá nacaáⁿ‑í núǔ‑yu, te ñáyiu ndòho dandoho ñaha tnaha ñáyiu‑xi taunihnu‑í‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Te cúñaha‑ǐ xii ñáyiu sá sàá nduu càda Yá Ndiǒxí ɨɨⁿ sá vǎha sá cúú‑xǐ‑yu. Duha càchí‑xi núú tùtú dácuàha‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Te Jèsús ní nacadɨ́‑gá núú tùtú‑áⁿ, te ní nacuáha‑gá ɨɨⁿ tée xìnu cuechi veñúhu‑áⁿ, te ní ngóo‑gá. Te nchaa ñáyiu yɨ̀hɨ veñúhu ñá núú nǔǔ‑yu ndèhe ñahá‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Te xǎhaⁿ‑gǎ xií‑yu: —Mei vìtna ní quee ndáá‑xi nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Te nchaá‑yu ní cáháⁿ váha‑yu cuèndá‑gá, te ní cuñúhu‑yu tnúhu váha càháⁿ‑gá, te xǐtnàhá‑yu: —¿Te náa ñá dɨ́ú těe‑a cùu‑dé déhe té Chèé‑ǎⁿ? —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Te Jèsús ní xáhaⁿ‑gǎ: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ ñúhú ìní‑ndó cǔñaha‑ndo xìi‑í ɨɨⁿ tnúhu cùtexínu sá càháⁿ méé‑ndó, te quesaha‑ndo: “Ñátátná cada tátna mee‑n”, duha quesaha‑ndo. Te cúñaha tùcu‑ndo xii‑í: “Sa ní níhí‑ndɨ̌ tnúhu nàcuáa ní quide‑n ñùú Capèrnaúm, te cada‑n tnàhá ñuú núú nǐ sahnu‑n”, duha quesaha‑ndo —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Te ní xáhaⁿ tùcu‑gá: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ nì ɨɨⁿ tée càháⁿ tnúhu Yá Ndiǒxí ñá túú tnàhá iní ñáhá ñǎyiu ñuú‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Te na càchí tnúhu ndáá tucu‑í xii‑ndo sǎ ǐo vài ñáyiu dɨ̀hɨ́ ñáyiu quèé ní xíndecu nàcióⁿ Isràél cútnàhá ní xíndecu té Èliás cútnàhá ñá túú ní cùuⁿ dáú ǔní cuíá dava, te dàvá‑áⁿ ǐo ní ndoho ñáyiu docó nɨtùhú nàcióⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Dico Yá Ndiǒxí ñá túú ní tèndaha‑gá té Èliás quɨ́hɨ́ⁿ‑dé vehe ndědani càa ñáyiu dɨ̀hɨ́‑áⁿ, chi vehe ɨɨⁿ ñaha ñuú Sàreptá ní xáhaⁿ‑gǎ ní sáháⁿ‑dé, te ñuú‑áⁿ cáá yàtni‑xi ñuú Sìdón. ");
INSERT INTO milNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Te ní xíndecu tucu ɨngá tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, te tée‑áⁿ nǐ xínani‑dě Elìseú, te dɨu‑ni dàvá‑áⁿ nǐ xíndecu tucu vài ñáyiu cùhú nàcióⁿ Isràél, ñáyiu ní tnahá cuéhé sǎ dátèhyú nihnu‑xi yɨquɨ cùñú‑yu dico ñá túú ní ndǔha‑yu, chi ɨɨⁿdìi‑ni té Nàamán tée distrìtú Sìriá ní ndúha‑dé —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Te sá dúcáⁿ nǐ cáháⁿ‑gá te xíǎⁿ ní cudééⁿ víhí nchàa ñáyiu yɨ̀hɨ veñúhu‑ǎⁿ núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Te ní queñuhú‑yu Jèsús yuhu děhvá tɨ̀ndúú nǔú cáá ñùú‑yu‑áⁿ cuèndá yàcáⁿ dàquée‑yu‑gá déhvá ní cùu. ");
INSERT INTO milNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Dico Jèsús vii‑ni ní quee‑gá tnuú‑yu cuáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Te Jèsús cuáháⁿ‑gá ñuú Capèrnaúm, te ñuú‑áⁿ yɨ́ndèhu‑xi distritú Galìleá. Te yàcáⁿ ndécú‑gǎ ní tnahá nduu ndètatú ñáyiu, te ní ngüíta‑gá dácuàha‑gá ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Te xǐcuñúhu‑yu nchaa nàcuáa dànehé ñáhá‑gǎ xií‑yu, chi càháⁿ‑gá dàtná càháⁿ ɨɨⁿ tée cùnuu, te cùnuu ndisa‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Te xɨtɨ́ veñúhu yɨ̀hɨ ɨɨⁿ tée yɨ̀hɨ ñaha ɨɨⁿ espíritú cúndɨ̀hɨ yucu ñávǎha, te espíritú‑áⁿ nǐ quide‑xi níhi ní cáháⁿ tée‑áⁿ, te xǎhaⁿ‑dě xii Jèsús: ");
INSERT INTO milNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Te ná cuìní yòhó Jèsús tée ñuú Nazàrét cada ñaha‑n xìi‑ndɨ́ nǔu véxi‑n nǔú ndécú‑ndɨ̌‑i? ¿Áⁿ věxi‑n dànaa ñaha‑n xii‑ndɨ́? Chi yúhú xìní ñáhà‑í xii‑n sǎ cúú‑n ɨ̀ɨⁿ tée ñá túú tnàhí cuéchi‑xi chi núú Yǎ Ndiǒxí ní quee‑n věxi‑n ñùyíú‑a —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Te Jèsús ní tenàá‑gá espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ, te xǎhaⁿ‑gǎ: —¡Cadɨ́ yuhu‑n, te taquèe yɨquɨ cuñú tée‑áⁿ! —càchí‑gá xǎhaⁿ‑gǎ. Te espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ nǐ dándùá‑xi tée‑áⁿ ndèé ñuhu tnuú ñáyiu xǐndecu‑áⁿ, te ñá túú‑gǎ ná ní quìde ñaha‑xi, te ní quee ñaha‑xi xìi‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Te nchaa ñáyiu xǐndecu‑áⁿ nǐ cuñúhu‑yu, te ní xítnàhá‑yu: —¿Te nása ndùu‑tu tnúhu càháⁿ tée‑ǎⁿ ñá? ¡Te càháⁿ‑dé dàtná càháⁿ ɨɨⁿ tée tàxi tnuní víhí, chi càháⁿ‑ni‑dé te nchaa espíritú cúndɨ̀hɨ yucu ñávǎha quèe‑ni‑xi yɨquɨ cuñú‑yu! —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Te nchaa xichi ní níhǐ‑yu tnúhu nàcuáa quìde Jesús. ");
INSERT INTO milNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Te Jèsús ní ndee‑gá xɨtɨ́ veñúhu, te cuáháⁿ‑gá vehe té Xǐmú. Te nǎná ñadɨ̀hɨ́ té Xǐmú‑áⁿ cùhú‑aⁿ ñùhu vihi‑aⁿ cahni, te ní cáháⁿ ndàhú‑yu núú Jèsús cuèndá‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Te Jèsús ní sáháⁿ‑gá núú ndécú‑áⁿ, te ní ngúnundeyɨ‑gá te ní xáhaⁿ‑gǎ xii cahni‑áⁿ sǎ ná xòcuɨñɨ́‑xi, te ní xócuɨ̀ñɨ́‑ni‑xi, te òré‑ni‑áⁿ nǐ ndúha ñaha cùhú‑áⁿ te ní ndacóo‑aⁿ ní xinu cuechi‑aⁿ nǔú‑güedě ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Te òré ní ngódó tnùú nchícanchii, te nchaa ñáyiu xǐndecu ndɨhɨ ñáyiu cùhú vehe‑xi ndèca ñahá‑yu cuáháⁿ núú Jèsús. Te Jèsús ní sacáⁿ ndodo‑gá ndaha‑gá dɨ́quɨ́ ɨɨⁿ ɨɨⁿ ñáyiu cùhú‑áⁿ, te ducaⁿ nǐ quide‑gá te ní ndúha‑yu. Te ndɨ dɨ́ɨ́ⁿ nǔú cuěhé tnàhá‑yu ɨɨⁿ ɨɨ́ⁿ‑yu ni cùu. ");
INSERT INTO milNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Te tnàhá dava ñáyiu cùhú‑áⁿ yɨ́hɨ́ ñàha espíritú cúndɨ̀hɨ yucu ñávǎha xií‑yu ni cùu, te òré ní quee ñaha‑xi xìí‑yu, te xíǎⁿ ní quide‑xi níhi ní cáháⁿ‑yu, te xǎhǎⁿ‑yu xii Jèsús: —Yòhó cúú‑n Děhe Dútú Ndiǒxí —càchí‑yu xǎhǎⁿ‑yu xii‑gá. Dico Jèsús níhi ní cáháⁿ‑gá ní tenàá‑gá nchaa espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ, te xǎhaⁿ‑gǎ sá vǎ dúcáⁿ‑gǎ cada‑xi, chi sa xìní‑xi sá dɨ́ú‑gǎ cúú‑gǎ Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Te ɨɨⁿ nduu ní túndaá‑ni ní quee Jèsús ñuú núú ndécú‑gǎ‑áⁿ cuǎháⁿ‑gá ɨɨⁿ xichi núú ñǎ túú ñǎyiu ndècu. Te cue ñáyiu ní ngüíta‑yu nànducu ñahá‑yu xii‑gá te ní naníhí ñáhǎ‑yu, te cuìní‑yu ngani ñàhá‑yu xii‑gá cuèndá sá ñà túú‑gǎ ndèé quɨ́hɨ́ⁿ‑gá ní cùu. ");
INSERT INTO milNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Dico ní xáhaⁿ‑gǎ xií‑yu: —Dacuɨtɨ́í quɨ̌hɨ́ⁿ‑í cúñaha‑ǐ xii nchaa ñáyiu dava‑gá ñuú tnúhu sá càháⁿ nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu, chi chìuⁿ tnahí‑ǎⁿ věxi‑í —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Te ní xica cuu Jèsús ní dánèhé‑gá ñáyiu tnúhu‑gá nchaa xɨtɨ́ veñúhu ndǎa distrìtú Galìleá. ");
INSERT INTO milNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Te ɨɨⁿ xito ndècu Jesús yuhu làgúná Genesàrét, te ío cuéhé ñǎyiu ní sáá, te ta dàdehnde ñaha‑ná‑yu xii‑gá cuáháⁿ sá cuìní‑yu cundedóho‑yu nchaa tnúhu càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Te Jèsús ní xiní‑gá úú bàrcú cue tée tnɨ̀ɨ chácá xǐnutnɨ́ɨ‑xi yatni yuhu làgúná‑áⁿ, te sa ní quene cue tée ñùhu xɨtɨ́‑xi‑áⁿ xǐnaquete‑güedé ñunu‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Te Jèsús cuásaá‑gá núú ɨɨⁿ bàrcú‑áⁿ, te bàrcú‑áⁿ cúú‑xí bàrcú té Xǐmú, te ní xáhaⁿ‑gǎ xii té Xǐmú‑áⁿ sǎ dánǔndehe‑dé‑xi luha‑gá xɨtɨ́ ndute. Te dǎtnùní ní ngóo‑gá núú bàrcú‑áⁿ, te xíáⁿ núcǒo‑gá ní ngüíta‑gá dánèhé‑gá ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Te òré ní túhú ní dánèhé ñáhá‑gǎ xií‑yu, te ní xáhaⁿ‑gǎ xii té Xǐmú: —Daquɨ̀hɨ́ⁿ bàrcú‑a xɨtɨ́ làgúná mei nǔú cùnú‑gá, te dàquée‑ndo ñùnu‑ndo tnɨɨ‑ndo chácá —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Te té Xǐmú ní xáhaⁿ‑dě: —Mèstrú, nɨ niú ní quide chìuⁿ‑ndɨ́ te ni ɨ̀ɨⁿ chácá ñà túú ní nǐhí‑ndɨ̌, dico vitna cuèndá‑ni sá yòhó táúchìuⁿ‑n te na dàquée‑ndɨ́ ñunu‑ndɨ́ váⁿ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Te òré ní dáquěe‑güedé ñunu‑güedé te súúní vài chácá nǐ níhí‑güedě, te ta ndǎtá‑nǎ ñunu‑güedé cuáháⁿ ní cùu. ");
INSERT INTO milNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Núu ní quide‑güedé ndaha‑güedé núú dàva‑gá cue tée cùndɨhɨ‑güedé xǐxúhuⁿ ɨngá bàrcú cuèndá quɨ́hɨ́ⁿ‑güedé chindee ñàha‑güedé. Te cue tée‑áⁿ nǐ sáháⁿ‑güedé ní chindee tnàha‑güedé ní dáchìtú‑güedé ndɨ ndùú bàrcú mee‑ni chǎcá, te súúní nǐ cuu vée núu cuìní‑na‑xi quée naa‑güedé ndɨhɨ bàrcú ní cùu. ");
INSERT INTO milNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Te sá dúcáⁿ cuìní‑xi quée naa bàrcú ní cùu, núu té Xǐmú, àdi Pelú chi úú dɨ̀u‑dé, ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú Jèsús, te xǎhaⁿ‑dě: —Xocuɨ̀ñɨ́ yòhó Jèsús núú ndécù‑í‑a, chi yúhú cúù‑í ɨɨⁿ tée ío ndècu cuéchi‑xi —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Te ducaⁿ nǐ cáháⁿ‑dé chi ní yùhú‑dé, te ní cuñúhu‑dé ndɨhɨ nchaa cue tée ndɨhɨ‑dé‑áⁿ cuèndá sá ǐo vài chácá nǐ níhí‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Te tnàhá té Jàcobó ndɨhɨ té Juàá cue déhe té Zebèdeú ío ní cuñúhu‑güedé, te dɨu‑ni cue tée cùndɨhɨ té Xǐmú‑áⁿ cúú‑güedě tnàhá‑güedé. Te Jèsús ní xáhaⁿ‑gǎ xii té Xǐmú: —Vá yùhú‑n, chi není vitna quɨ́hɨ́ⁿ‑n dàcaháⁿ‑n ñǎyiu cuèndá tuha ñàhá‑yu xii‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Te ní quene‑güedé ndɨhɨ bàrcú ndéé ñuhu yìchí yuhu làgúná‑áⁿ. Te òré‑áⁿ nǐ dándǒo‑güedé nchaandɨ túhú sá ndécú ndɨ̀hɨ‑güedé, te ní tuha‑güedé Jèsús. ");
INSERT INTO milNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Te òré ní quexìo Jesús ɨɨⁿ ñuú, te ní quexìo ɨɨⁿ tée cùhú tnàhá‑dé cuéhé sǎ dátèhyú nihnu‑xi yɨquɨ cùñú‑ó, te òré ní xiní‑dé Jèsús te ní sáháⁿ‑dé núú ndécú‑gǎ, te ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú‑gǎ te ní nuu núú‑dě ndàa núú ñúhú te càháⁿ ndàhú‑dé, te xǎhaⁿ‑dě xii‑gá: —Mèstrú, véxi‑í càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n càda tátna ñaha‑n xìi‑í, chi cùtnuní iní‑í sá ndácú‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Te Jèsús ní dácàá‑gá ndaha‑gá ní tendaha ñàha‑gá xii‑dé, te xǎhaⁿ‑gǎ: —Cuu cada tátna ñaha‑ǐ xii‑n, te vitna te ndúha‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te òré‑ni ní xócuɨ̀ñɨ́ cuéhé tnàhá‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Te dǎtnùní ní xáhaⁿ tùcu Jesús xii‑dé: —Vá yǒo ɨɨⁿ cúñaha‑n sǎ nǐ quide tátna ñaha‑ǐ xii‑n, núú dǔtú‑ni cuàháⁿ cuèndá sá ná quìní ñáhá‑dě xii‑n sǎ nǐ ndúha‑n te cuáha‑n‑dě sá ndúú tǎhú Yǎ Ndiǒxí dàtná ní cachí ndíi Moìsés cuèndá ná quìní ñáyiu sá ndàá ní ndúha‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Te ducaⁿ ta xǐté nuu‑gá tnúhu nchaa nàcuáa quìde Jesús, te ío cuéhé ñǎyiu ní xóo tacá nchaa núú nǐ xíndecu‑gá cuèndá sá cuìní‑yu cundedóho‑yu tnúhu càháⁿ‑gá, ndɨhɨ cuèndá sá cuìní‑yu cada tátna ñaha‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Dico Jèsús ní xóo quee nihni‑gá tnuú‑yu ní xóo quɨ́hɨ́ⁿ‑gá núú ñà túú ñǎyiu ndècu ní xóo cáháⁿ ndɨhɨ‑gá Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Te ɨɨⁿ nduu dànehé‑gá ñáyiu, te xǐnucóo ɨɨⁿ ǔú cue tée cùu fariséú, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés. Te cue tée‑áⁿ nǐ quee‑güedé nchaa ñuú yɨ́ndèhu distritú Galìleá, ndɨhɨ distrìtú Jùdeá, ndɨhɨ ñuú Jerusàlén, te nchaa ñuú‑áⁿ nǐ quee‑güedé cuáháⁿ‑güedé núú ndécú‑gǎ. Te Yá Ndiǒxí chíndèe ñaha‑gá quídé tǎtna‑gá ñáyiu cùhú. ");
INSERT INTO milNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Te ɨɨⁿ ǔú cue tée nchìdo‑güedé ɨɨⁿ tée cùhú ñá cúú‑gǎ candá nihnu ñùhu‑dé xíto ní quexìo ndɨhɨ ñaha‑güedé, te cuìní‑güedé quɨ́hu ndɨhɨ ñaha‑güedě ndéé xɨtɨ́ vehe, sáá‑güedé ndéé núú Jèsús ndɨhɨ tée cùhú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Dico ñá túú ní nǐhí‑güedě ndèé ichi quɨ́hu‑güedé, chi cuèndá ío cuéhé ñǎyiu ndècu, núu xíǎⁿ ní sáá‑güedé dɨ́quɨ́ véhé‑ǎⁿ nǐ caáⁿ‑güedé te ndàa dɨ́quɨ́ véhé‑ǎⁿ nǐ dáquěe‑güedé tée cùhú‑áⁿ, te ñùhu‑ni‑dé xíto ní dáquěe ñaha‑güedě tnuú ñáyiu ní sáá ndéé núú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Te Jèsús ní cutnùní iní‑gá sá nɨ̀ yuhu nɨ iní‑güedé sàndáá iní ñáhá‑güedě xii‑gá, núu ní xáhaⁿ‑gǎ xii tée cùhú‑áⁿ: —Yòhó tée cùhú, sa ní quide càhnu iní‑í nchaa cuéchi‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Te cue tée dàcuaha ñaha xií‑yu nchaa tnúhu ní chídó tnùní ndíi Moìsés ndɨhɨ cue tée cùu fariséú ní sani iní‑güedé: “¿Ná cúú těe‑a núu càháⁿ cuèhé‑dé cuèndá Yǎ Ndiǒxí‑i? Te vá yǒo ɨɨⁿ ndàcu cada cahnu iní nchaa yícá cuěchi ñáyiu, chi ɨɨⁿdìi díí‑ni Yá Ndiǒxí quídé càhnu iní‑gá”, duha ní sani iní‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dico Jèsús sa ní cutnùní iní‑gá nàcuáa sàni iní‑güedé nǔu ní xáhaⁿ‑gǎ xii‑güedé: —¿Te ná cuèndá ducaⁿ sàni iní‑ndó‑í? ");
INSERT INTO milNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Te sá dúhá nǐ xáhaⁿ‑ǐ xii tée cùhú‑a sá cádá càhnu iní‑í nchaa yícá cuěchi‑dé, te xíǎⁿ nchòhó ñá túú cùtnuní iní‑ndó nǔu ndáá càháⁿ‑í àdi ñá ndàá. Dico núu cúu‑í‑dé sá ndácǒo‑dé, te caca‑dé te cutnùní ndáá iní‑ndó nǔu ndáá càháⁿ‑í àdi ñá ndàá, chi cundehe nǔú‑ndó nàcuáa cada‑í. ");
INSERT INTO milNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Te vitna na càda‑í nàcuáa cutnùní iní‑ndó nchàa‑ndo sá yǔhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ndecu ndɨhɨ‑í tnúhu ndee ìní sá cádá càhnu iní‑í nchaa cuéchi ñáyiu ñuyíú‑a —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. Te sátá dúcáⁿ te ní xáhaⁿ‑gǎ xii tée cùhú‑áⁿ: —Ndacóo, te ndocani‑n xǐto ñùhu‑n véxi‑áⁿ, te núhú‑n vèhe‑n —cachí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Te òré‑ni‑áⁿ nǐ ndúha tée cùhú‑áⁿ te ní ndacóo‑dé, te ní ndocani‑dé xíto ñùhu‑dé ní quexìo‑áⁿ, te ní natnɨɨ‑dé ichi ta cǎháⁿ‑dé cuánuhú sá ǐo càhnu cuu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Te nchaa ñáyiu xǐndecu‑áⁿ nǐ cuñúhu‑yu, te tnàhá‑yu ní cachí‑yu sá ǐo càhnu cuu Yá Ndiǒxí, te ducaⁿ ǐo ní yùhú‑yu, te ní xítnàhá‑yu: —Vitna ní xiní‑ó ɨ̀ɨⁿ sá ñà túú tnàhí xìní‑ó ní cùu —cachí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Te sátá dúcáⁿ nǐ cuu te ní quee Jèsús xíáⁿ, te ní xiní‑gá ɨɨⁿ tée nàni Leví núcǒo‑dé ɨɨⁿ xichi quìde cobrá‑dé ñáyiu cuèndá impuèstú, chi cobràdór cúú‑dě, te ní xáhaⁿ‑gǎ xii‑dé: —Néhé chìtnahá ñáhá‑n xìi‑í —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Te té Lèví‑áⁿ nǐ ndàcuɨ́ñɨ́‑dé te ní dándǒo‑dé nchaa sá ndécú ndɨ̀hɨ‑dé núú núcǒo‑dé‑áⁿ, te ní tuha‑dé Jèsús. ");
INSERT INTO milNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Te sátá dúcáⁿ te té Lèví‑áⁿ nǐ quide‑dé ɨɨⁿ vico càhnu vehe‑dé sá cúú‑xí Jèsús, te ní tacá vài cue tée quìde chiuⁿ quide‑dé, te nchaa‑güedé cuánguɨhu‑güedé mèsá ní ngóo‑güedé ndɨhɨ dava‑gá ñáyiu ní quexìo cuendá caxi‑güedé ndɨhɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Dico cue tée cùu fariséú ndɨhɨ cue tée dàcuaha ñaha xií‑yu nchaa tnúhu ní chídó tnùní ndíi Moìsés ní ngüíta‑güedé xǐcuèhé‑güedé cue tée xìca cuu ndɨhɨ‑gá, te xǎhaⁿ‑güedě: —¿Ná cuèndá xéxí‑ndó xìhi‑ndo ndɨhɨ cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú, ndɨhɨ nchaa dava‑gá cue tée ndècu ichi cuehé ichi duha‑i? —càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Nchaa ñáyiu ñá túú cùhú chi ñá túú xìni ñuhú‑yu ñátátná, dico nchaa ñáyiu cùhú chi xìni ñuhu ñahá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Te yúhú véxi‑í càháⁿ‑í ñáyiu cùtnuní iní‑xi sá ndécú cuěchi‑xi cuèndá dàñá‑yu nchaa sá cuèhé sá dúhá quìdé‑yu, te ñá túú věxi‑í càháⁿ‑í ñáyiu càchí sá ñà túú ndècu cuéchi‑xi —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Te ní xáhaⁿ‑güedě xii Jèsús: —Te áma ñá túú tnàhí ná xéxí cuè tée xìca cuu ndɨhɨ té Juàá càháⁿ ndɨhɨ‑güedé Yǎ Ndiǒxí, te dɨu‑ni ducaⁿ quìde cue tée xìca cuu ndɨhɨ nchúhú cue tée cùu fariséú. ¿Te ná cuèndá cue tée xìca cuu ndɨhɨ‑n ñá túú dùcaⁿ quide‑güedé nǔu nchaa‑ni nduu xèxi‑güedé xìhi‑güedé quídé‑güedě‑i? —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó xìní‑ndó sǎ vǎ cúú cǔñaha‑o xìi cue ñáyiu ñùhu vico tnándaha sá vǎ cúú càxí‑yu nɨni ndècu ndɨhɨ ñaha tée tnǎndaha‑áⁿ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dico sáá nduu te vá cúndècu ndɨhɨ ñaha‑gá tée tnǎndaha‑áⁿ xií‑yu, te dàvá‑áⁿ te cahni iní‑yu vá cáxǐ‑yu sá ndɨ̀hú iní‑yu —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Te ní cani‑gá ɨɨⁿ cuèndú núú ñǎyiu nàcuáa tecú tnùní‑yu tnúhu‑gá, te xǎhaⁿ‑gǎ: —Vá yǒo ɨɨⁿ dàndée luha dóó sáá ɨ̀ɨⁿ dóó sa ní cuu tùhú víhí, chi núu yoo ducaⁿ na càda, te dóó sáá‑ǎⁿ nàndɨyɨ‑xi te uuⁿ‑gá ndata‑xi dǒó sǎ nǐ cuu tùhú‑áⁿ, te luha dóó sáá‑ǎⁿ ñà túú nàtaú‑xi ndée dóó sǎ nǐ cuu tùhú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Te nì vá yǒo ɨɨⁿ chìhi ndidí sáá xɨ̀tɨ́ ɨɨⁿ lamba sa ní cuu tùhú víhí, chi núu yoo ducaⁿ na càda, te ndava lamba sa ní cuu tùhú‑áⁿ chi ío níhi yócó ndìdí‑áⁿ, te cuíta‑ni ndidí‑áⁿ te cuíta‑ni lamba‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Núu xíǎⁿ xíní ñùhu‑xi quée ndidí sáá‑ǎⁿ xɨtɨ́ ɨɨⁿ lamba saa cuèndá ducaⁿ ñà túú nǎ cuu cováha‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Te ni ɨ̀ɨⁿ ñáyiu ñá túú tnàhá iní‑yu cohó‑yu ndidí sáá, te núu díhna‑gá ná còhó‑yu ndidí sá nǐ quene díhna‑gá, chi càchí‑yu sá xíhí vǎha‑gá ndidí sá nǐ quene díhna‑gá‑áⁿ dàcúúxí ndìdí sáá —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Te ɨɨⁿ nduu cùu‑xi nduu ndetatú ñáyiu ñùhu Jesús ichi ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te ta yǎha‑gá ndɨhɨ‑güedé ɨɨⁿ xichi núú cáá trìú, te ní ngüíta‑güedé sàhnú‑güedé yoco trìú‑áⁿ te ndɨhɨ ndaha‑güedé quɨ́ɨ́ⁿ‑güedě quéé trìú tá xèxi‑güedé cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Te ɨɨⁿ ǔú cue tée cùu fariséú ní xáhaⁿ‑güedě xii cue tée xìca cuu ndɨhɨ‑gá: —¿Te ná cuèndá ducaⁿ quìde nchohó ɨɨⁿ sá ñà túú tàú‑ó càda‑o vitna cuu‑xi nduu ndetatú‑ó‑í? —càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —¿Te náa ñá túú dàcuaha‑ndo núú tùtú Yǎ Ndiǒxí núú càháⁿ‑xi nàcuáa ní quide ndíi Dàvií cútnàhá ní xíhí ndíi docó ndɨhɨ cue tée ní xica cuu ndɨhɨ ndíi‑ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Chi ní quɨ́hu ndíi vehe Yá Ndiǒxí, te ní queheⁿ ndíi pàá ní cuu íí ndécú‑ǎⁿ nǐ dácǎhñu ndíi cue tée xìca cuu ndɨhɨ ndíi ní xexi ndíi ndɨhɨ‑güedé, te ñá túú tàú ndíi sá dúcáⁿ càda ndíi ni cùu, chi mee‑ni cuè dútú tàú‑güedé caxi‑güedé pàá‑áⁿ ní cùu —cachí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Te ní xáhaⁿ tùcu‑gá: —Te yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, tnàhá‑í ndécú ndɨ̀hɨ‑í tnúhu ndee ìní sá cǔu‑í nchaa ñáyiu nàcuáa cadá‑yu nduu ndètatú‑ó‑á —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Te ɨngá nduu dɨu‑ni nduu ndètatú ñáyiu cuánguɨhu Jèsús xɨtɨ́ veñúhu dànehé‑gá ñáyiu. Te xíáⁿ ndécú ɨ̀ɨⁿ tée cùhú ní yíchí nihnu ɨɨⁿ xio ndaha cùha‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Te cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùu fariséú ndéhé‑güedě nǔu cada tátna ñaha Jèsús xii tée cùhú‑áⁿ nduu ndètatú‑güedé‑áⁿ cuèndá níhí‑güedě nàcuáa cada‑güedé cacáⁿ cuéchi‑güedé cuèndá‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Dico Jèsús sa ní cutnùní iní‑gá nàcuáa sàni iní‑güedé, te ní xáhaⁿ‑gǎ xii tée cùhú ndaha‑xi‑áⁿ: —Ndàcuɨñɨ́ te ngúnutnɨ́ɨ‑n cuǎdava tnuú‑ndɨ́‑a —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te tée‑áⁿ nǐ ndacuɨ́ñɨ́‑dé te ní ngúnutnɨ́ɨ‑dé cuádava tnuú‑güedé ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Te dǎtnùní Jèsús ní xícáⁿ tnúhú‑gǎ núú cuè ñáyiu xǐndecu‑áⁿ, te xǎhaⁿ‑gǎ xií‑yu: —Cuìní‑í cachí tnúhu‑ndo nǎ cúú sǎ vǎha cada‑o ndùu ndetatú‑ó. ¿Ɨɨⁿ chìuⁿ váha àdi ɨɨⁿ chiuⁿ cuehé, sá cádá tǎtna‑o ñǎyiu cùhú àdi sá cáhnì‑ó‑yu? —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Te dǎtnùní ní ndacoto‑gá núǔ‑yu nchaá‑yu, te ní xáhaⁿ‑gǎ xii tée cùhú ndaha‑xi‑áⁿ: —Ndocani ndaha‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te ní ndocani‑dé ndaha‑dé, te òré‑ni ní ndúha. ");
INSERT INTO milNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Te cue tée xǐndecu‑áⁿ sǔúní nǐ cudééⁿ‑güedě sá dúcáⁿ nǐ quide tátna Jèsús tée cùhú‑áⁿ, te ní ngüíta‑güedé ndátnǔhu‑güedé nǔu nása cada ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Te sátá dúcáⁿ nǐ cuu te ní xica Jèsús cuáháⁿ‑gá xɨtɨ́ yucu cuèndá yàcáⁿ cáháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te nɨ niú ní cáháⁿ ndɨhɨ ñaha‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Te sátá nǐ túndaá, te ní cana‑gá nchaa cue tée xìca cuu ndɨhɨ‑gá, te ní cáxi‑gá úxúú tnàhá‑güedé, te cue tée‑áⁿ nǐ xáhaⁿ‑gǎ sá dɨ́ú‑güedě cuu‑güedé cue tée quɨ́hɨ́ⁿ cáháⁿ tnúhu‑gá núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Te duha xǐnani ndɨ ùxúú cue tée‑áⁿ. Té Xǐmú, àdi Pelú chi úú dɨ̀u‑dé, ndɨhɨ ñaní‑dé té Ndrǐxí, ndɨhɨ té Jàcobó, ndɨhɨ té Juàá, ndɨhɨ té Lìpé, ndɨhɨ té Bartolòmé, ");
INSERT INTO milNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ndɨhɨ té Màteú, ndɨhɨ té Mǎxí, ndɨhɨ té Jàcobó déhe té Àlfeú, ndɨhɨ ɨngá té Xǐmú tée ní cundɨhɨ cue tée canànistá, ");
INSERT INTO milNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ndɨhɨ té Jùdás ñaní té Jàcobó, ndɨhɨ té Jùdás Iscàrioté tée ní sáá nduu nǐ sáha cuèndá ñáhá xìi Jesús núú cuè tée cùu úhú iní ñáhá xìi‑gá, duha xǐnani cuè tée ní cáxi Jèsús ní xica cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Te Jèsús cuánuu‑gá yucu núú nǐ sáá‑gá‑áⁿ, te ní ngava‑gá ɨɨⁿ núú ndàá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te xíáⁿ nǐ ngúnutnɨ́ɨ‑gá. Te xíáⁿ ndécú dàva‑gá cue tée xìca cuu ndɨhɨ‑gá ndɨhɨ vài ñáyiu ndètu ñahá‑yu xii‑gá, te ñáyiu‑áⁿ věxi‑yu nchaa ñuú cáá dìstritú Jùdeá, ndɨhɨ ñuú Jerusàlén, te ndècu ñáyiu véxi ndàa yuhu lamár yatni ñuú Tìrú, ndɨhɨ ñuú Sìdón. Te nchaa ñáyiu‑áⁿ nǐ quexìó‑yu cuìní‑yu cundedóho‑yu nchaa tnúhu càháⁿ Jèsús, ndɨhɨ cuèndá sá cuìní‑yu ndúha‑yu nchaa cuéhé tnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Te tnàhá ñáyiu yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha. ");
INSERT INTO milNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Te nchaá‑yu cuìní‑yu dacàá‑yu ndahá‑yu tendàhá‑yu Jèsús ní cùu cuendá sá nǐ níhǐ‑yu tnúhu sá ndècu ndɨhɨ‑gá tnúhu ndee ìní quídé tǎtna‑gá nchaa ñáyiu cùhú. ");
INSERT INTO milNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Te Jèsús ní ndacoto‑gá núú cuè tée xìca cuu ndɨhɨ‑gá, te ní xáhaⁿ‑gǎ: —Váha táhú nchaa nchòhó cue ñáyiu ndàhú, chi nduu táhú‑ndó cùndecu‑ndo núú táxí tnùní Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Váha táhú nchaa nchòhó ñáyiu ío cuìní cundedóho tnúhu Yá Ndiǒxí chi ío vii ío váha cuu iní‑ndó. ’Váha táhú nchaa nchòhó ñáyiu ndàhyú sá ndɨ̀hú iní‑ndó, chi sáá nduu te cudɨ́ɨ́ ìní‑ndó nɨ̀ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Váha táhú nchaa nchòhó ñáyiu na cùu úhú iní ñáhá tnàha ñáyiu‑xi, chi sáá nduu te vá dáñá‑gǎ‑yu quɨ́hu‑ndo vèñúhu, te cúcuèhé ñáhǎ‑yu xii‑ndo, te cachí‑yu sá ñà dɨ́ú ñǎyiu váha cùu‑ndo, te ducaⁿ càda ñahá‑yu xii‑ndo sǎ cuèndá yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Te òré ducaⁿ na càda ñahá‑yu xii‑ndo te cudɨ́ɨ́ víhí‑ní ìní‑ndó cùndecu‑ndo, chi sáá nduu ndùu táhú‑ndó sǎ ǐo váha càa ndecu andɨu cundecu ndɨhɨ‑ndo nduu na nasaá‑ndó yàcáⁿ cundecu‑ndo, chi dɨu‑ni ducaⁿ nǐ xóo cada ñaha cuè ñaní tnáhǎ‑yu xii cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ní xíndecu ndéé sanaha. ");
INSERT INTO milNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Te ndàhú ní cuu nchaa ñáyiu cuica ñà túú sàndáá iní ñáhá xìi Yá Ndiǒxí, chi vitna ío váha ndècú‑yu, dico sáá nduu te nduu ndàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Te ndàhú ní cuu tucu nchaa ñáyiu ñá túú tnàhí ná cúmǎní xii‑xi vitna, chi sáá nduu quìní‑yu tnúndòho tnúhu ndàhú. ’Te ndàhú ní cuu nchaa ñáyiu cùdɨ́ɨ́ ìní‑xi ndècu ichi cuehé ichi duha vitna, chi sáá nduu te ndáhyú‑yu sá ndɨ̀hú iní‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Te ndàhú ní cuu nchaa ñáyiu na càháⁿ váha dava‑gá ñáyiu cuèndá‑xi, chi ducaⁿ nǐ xóo cáháⁿ váha‑yu cuèndá nchaa cue tée ní xóo dandàhú ñáhá xìi ñáyiu ndéé sanaha, chi ní cachí‑güedé sá càháⁿ‑güedé tnúhu Yá Ndiǒxí te ñá ndàá —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Te Jèsús ní xáhaⁿ‑gǎ xii nchaa ñáyiu xǐndecu‑áⁿ: —Nchaa nchòhó ñáyiu xǐndedóho ñaha càchí tnúhu‑í xii‑ndo sǎ cúú ìní‑ndó ñǎyiu cùu úhú iní ñáhá xìi‑ndo, te cada‑ndo sǎ vǎha sá cúú‑xǐ‑yu cuěi nándɨ sá ná cádá ñàhá‑yu xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Te cácáⁿ táhú‑ndó nǔú Yǎ Ndiǒxí cuèndá ñáyiu càháⁿ úhú ñáhá xìi‑ndo, ndɨhɨ cuèndá ñáyiu tèe ñaha cuéchi neñùú xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Te núu ní canìhá‑yu xii‑ndo ɨ̀ɨⁿ xito te cuìní tucú‑yu canìhá‑yu, te daña‑ndo na cànihá‑yu, àdi núu na quèndeé‑yu dóó ndíxí ndòdo‑ndo, ndɨhɨ dúhnú‑ndó, te daña‑ndo na cànehé‑yu quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Te núu xìcáⁿ‑yu ɨɨⁿ sá nándɨ̌hɨ‑yu núú‑ndó te cuáñaha‑ndo, àdi quendeé‑yu ɨɨⁿ ndachìuⁿ‑ndo, te vá nándàcáⁿ‑ndó nǔǔ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Te nchaa sá vǎha cuìní‑ndó càda tnaha ñáyiu‑ndo, te cada‑ndo tnàhá‑ndó ndɨ̀hɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Chi núu nchòhó ná cùu iní‑ndó mèe‑ni ñáyiu cùu iní ñáhá xìi‑ndo, te vá càchí‑ndó sǎ ǐo váha quìde‑ndo, chi tnàhá nchaa ñáyiu ndècu ichi cuehé ichi duha ducaⁿ xǐquidé‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Àdi mee‑ni ñáyiu quìde ñaha sá vǎha xii‑ndo quìde váha‑ndǒ‑yu, te vá càchí‑ndó sǎ ǐo váha quìde‑ndo, chi tnàhá nchaa ñáyiu ndècu ichi cuehé ichi duha ducaⁿ xǐquidé‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Àdi mee‑ni ñáyiu sàni iní‑ndó nàcoto ñaha xii‑ndo cuáñaha‑ndo ɨ̀ɨⁿ sá xìcáⁿ‑yu núú‑ndó, te vá cání ìní‑ndó sǎ ǐo quìde váha‑ndo, chi tnàhá ñáyiu ndècu ichi cuehé ichi duha dàsaⁿ nuú‑yu ɨɨⁿ sá néhé vǎha‑yu, te ndètu cahnu‑ná‑yu nacoto ñaha ñáyiu ní sáha nùú‑yu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dico nchòhó xíní ñùhu‑xi cuu iní‑ndó ñǎyiu cùu úhú iní ñáhá xìi‑ndo, te cada‑ndo sǎ vǎha sá cúú‑xǐ‑yu, te cuáñaha nùu‑ndo ɨɨⁿ sá ná ndɨ̌hɨ‑yu te núu xìcáⁿ‑yu núú‑ndó, te vá cúndètu‑ndo nacoto ñahá‑yu xii‑ndo. Te ducaⁿ te ío‑gá cuéhé nǐhí‑ndó cùndecu ndɨhɨ‑ndo, te cuu ndisa‑ndo děhe Dútú Ndiǒxí, chi ío càhnu iní‑gá sá cúú‑xí nchàa ñáyiu ñá túú ndàcáⁿ táhú nǔú‑gǎ cuèndá nchaa sá vǎha quìde‑gá, ndɨhɨ sá cúú‑xí nchàa ñáyiu ndècu ichi cuehé ichi duha. ");
INSERT INTO milNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Te cunduu càhnu iní nchòhó tucu dàtná càhnu iní Tǎtá‑ó Dǔtú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Te vá càháⁿ cuèhé‑ndó cuèndá sá quídé tnàha ñáyiu‑ndo, te ducaⁿ te Yá Ndiǒxí ñá túú nà tnúhu cúñaha‑gǎ xii‑ndo. Te vá cǔñaha‑ndo xìi ñáyiu sá quɨ̀hɨ́ⁿ‑yu ɨɨⁿ xichi núú ùhú núú ndàhú ndohó‑yu cuèndá nchaa sá ñà túú vǎha quìdé‑yu, te ducaⁿ te Yá Ndiǒxí vá cǔñaha‑gǎ xii‑ndo sǎ tnàhá‑ndó quɨ̌hɨ́ⁿ‑ndó ɨ̀ɨⁿ xichi núú ùhú núú ndàhú ndoho‑ndo. Te chí cádá càhnu iní nchaa sá quídě‑yu, te ducaⁿ te Yá Ndiǒxí cada càhnu iní ñáhá‑gǎ xii‑ndo tùcu. ");
INSERT INTO milNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Te chí cuǎñaha xìi ñáyiu núu ná cúú sǎ xíní ñùhú‑yu, te dàtná chitu ɨ̀ɨⁿ yicá súúní xìdó coyo‑ná, ducaⁿ tàxi Yá Ndiǒxí xii‑ndo. Te nánicuáa na càda‑ndo cada váha‑ndo sǎ cúú‑xí tnàha ñáyiu‑ndo, te dɨu‑ni ducaⁿ càda ñaha Yá Ndiǒxí xii‑ndo —càchí Jèsús xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Te dǎtnùní ní cani‑gá ɨɨⁿ cuèndú núǔ‑yu nàcuáa tecú tnùní‑yu tnúhu‑gá, te xǎhaⁿ‑gǎ: —Ɨɨⁿ tée cuàá chi ñá ndácú‑dě cuita nehe‑dé ɨngá tée cuàá, chi núu ducaⁿ na càda‑güedé te ndɨ ndùú‑güedé ngaunihnu‑güedé déhvá. ");
INSERT INTO milNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Te ni ɨ̀ɨⁿ landú yɨ́hɨ́ scuèlá ñá túú cùnuu‑gá‑güexi dàcúúxí mèstrú‑güexi, te ndéé nǔu na cùtúha váha‑güexi, te dǎtnùní nútnahá‑güexi tée dànehé ñáhá xìi‑güexi. ");
INSERT INTO milNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Te na càchí tnúhu‑í xii‑ndo sǎ nchàa cuéchi quìde ñáyiu cùu‑xi datná ɨɨⁿ mihi lǐhli. ¿Te ná cuèndá ndéhé‑ndó ɨ̀ɨⁿ sá ñà túú vǎha quìde tnaha ñáyiu‑ndo, te mee‑ndo vìhi‑gá quídé‑ndó‑í? Te sá dúcáⁿ quìde‑ndo te cada iní‑ndó sǎ ndéhé‑ndó dàtná ɨɨⁿ mihi lǐhli ñùhu núú tnàha ñáyiu‑ndo, te mee‑ndo ñùhu ɨɨⁿ mihi cahnu‑gá núú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Te núu na nàcanu ichi‑ndo tnaha ñáyiu‑ndo cuèndá sá ñà túú quìde váha‑yu ndècú‑yu te mee‑ndo vìhi‑gá quídé‑ndó ñá, te cada iní‑ndó sǎ xǎhaⁿ‑ndo xìí‑yu sá nátàva‑ndo mihi líhli ñùhu núǔ‑yu, te mihi càhnu ñuhu núú méé‑ndó ñà túú quìde cuendá‑ndó. ¡Te sá dúcáⁿ quìde‑ndo te ío dàndahú‑ndó mèe‑ndo sá quídé ndǎá‑ndó te ñá ndàá sá quídé ndǎá‑ndó! Te xìni ñuhu‑xi díhna‑gá daña‑ndo nchàa sá ñà túú vǎha quìde‑ndo, te dǎtnùní ducaⁿ te cutnùní váha iní‑ndó nàcuáa nacanu ichi‑ndo tnàha ñáyiu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Te ñá túú nì ɨɨⁿ yutnu váha te quiní‑ó cùuⁿ sávìdí sá ñà túú vǎha, te ni ɨ̀ɨⁿ yutnu sá ñà túú vǎha, te quiní‑ó cùuⁿ sávìdí váha, chi mee‑ni sǎvìdí sá ñà túú vǎha cùuⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Te ndɨ dɨ́ɨ́ⁿ nǔú yutnu xìní‑ó nǎ yutnu cùu‑xi cuendá sá sǎvìdí‑xi, chi ñá túú xìní‑ó cùuⁿ ngúxí ɨɨⁿ tnu ìñu, te ni ñà túú xìní‑ó cùuⁿ ndéhé yoho yàha stilé dɨ́quɨ́ ɨɨⁿ yoho yàha cutexínu. ");
INSERT INTO milNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Te nchaa ñáyiu váha iní‑xi càháⁿ‑yu tnúhu váha, chi dɨu‑ni tnúhu váha tnàhí‑áⁿ ñúhú ìní‑yu, te nchaa ñáyiu ñá túú vǎha iní‑xi càháⁿ cuèhé‑yu, chi dɨu‑ni tnúhu cuèhé tnàhí‑áⁿ ñúhú ìní‑yu, chi nchaa sá ñúhú ìní‑yu te xíǎⁿ càháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Te ná cuèndá càchí‑ndó sǎ yǔhú cúù‑í Yaá cúú Xǐtohó‑ndó te ñá túú quìde‑ndo nchaa nacuáa càháⁿ‑í‑i? ");
INSERT INTO milNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Te na càchí tnúhu‑í xii‑ndo cuèndá ñáyiu tùha ñaha xii‑í, chi ñáyiu‑áⁿ sácǔndedóho‑yu nchaa tnúhu càháⁿ‑í te tnɨ̀ɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Te ñáyiu‑áⁿ cúǔ‑yu dàtná ɨɨⁿ tée ní dácáá ɨ̀ɨⁿ vehe, chi tée‑áⁿ dǐhna‑gá ní xete‑dé ndéé ní tnahá‑dé yúú cáxíⁿ te dǎtnùní ní tava‑dé cimièntú‑xi, te òré ní cuuⁿ dáú, te ní ndee ndute ñuhu, te ní ndacáⁿ‑xi ndéé núú cáá vèhe‑áⁿ, dico ñá túú ní ndàcu‑xi cuido‑xi, te ducaⁿ chi tée ní dácáá vèhe‑áⁿ nǐ tava‑dé cimièntú‑xi núú yǔú cáxíⁿ. Duha sǎtnahá‑xi cùu nchaa ñáyiu sàcúndedóho tnúhu càháⁿ‑í te tnɨ̀ɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Te ñáyiu sàcúndedóho tnúhu càháⁿ‑í te ñá túú tnɨ̀ɨ́‑yu, ñáyiu‑áⁿ cúǔ‑yu dàtná ɨɨⁿ tée ní dácáá ɨ̀ɨⁿ vehe, te ñá túú ní tàva‑dé cimièntú‑xi, te òré ní cuuⁿ dáú, te ní ndee ndute ñuhu, te ní ndacáⁿ‑xi ndéé núú cáá vèhe‑áⁿ, te íí‑ni ní xido‑xi vehe‑áⁿ cuèndá sá ñà túú ní quène cimientú‑xi. Duha sǎtnahá‑xi cùu nchaa ñáyiu sàcúndedóho tnúhu‑í te ñá túú cuìní‑yu tnɨɨ́‑yu —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Te sátá nǐ yáha ní cáháⁿ Jèsús ndɨhɨ ñáyiu, te cuáháⁿ‑gá ñuú Capèrnaúm. ");
INSERT INTO milNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Te yàcáⁿ ndécú ɨ̀ɨⁿ tée cùu capitáⁿ, te cùhú ɨɨⁿ tée xìnu cuechi núú‑dě tée ío‑gá cúú ìní‑dé, te sa ndècu‑ná‑dé sá cùú‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Te òré ní níhí těe cùu capitáⁿ‑áⁿ tnǔhu cuèndá Jèsús, te ní tendaha‑dě ɨɨⁿ ǔú cue tée cùu sacuéhé nǔú ñǎyiu isràél cuáháⁿ‑güedé cáháⁿ ndàhú‑güedé núú‑gǎ nǔu vá cúndèe iní‑gá quɨ́hɨ́ⁿ‑gá cada tátna‑gá tée xìnu cuechi núú‑dě‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Te ní quexìo‑güedé núú ndécú Jèsús, te ní ngüíta‑güedé càháⁿ ndàhú víhí‑güedě núú‑gǎ, te xǎhaⁿ‑güedě: —Tée cùu capitáⁿ ní cachí‑dé véxi‑ndɨ́ nǔu vá cúndèe iní‑n quɨ̌hɨ́ⁿ‑n càda tátna‑n ɨ̀ɨⁿ tée xìnu cuechi núú‑dě chi cùhú‑dé, te tàú ndisa‑n càda‑n nacuáa càháⁿ capìtáⁿ‑áⁿ, ");
INSERT INTO milNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","chi tée‑ǎⁿ ío cùu iní ñáhá‑dě xii nchaa nchúhú ñáyiu isràél te dɨu‑dé ní táúchíúⁿ‑dě ní sáá veñúhu‑ndɨ́ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Te sátá dúcáⁿ te Jèsús ní xica‑gá cuáháⁿ‑gá ndɨhɨ‑güedé, te òré tá cùyatni‑gá vehe núú ndécú těe cùhú‑áⁿ cuǎháⁿ, te tée cùu capitáⁿ‑áⁿ nǐ xáhaⁿ‑dě xii ɨɨⁿ ǔú cue tée càháⁿ ndɨhɨ‑dé: —Quɨ́hɨ́ⁿ‑ndó cǔñaha‑ndo xìi Yaá cúú Mèstrú sá càchí‑í sá ñà túú nǎ cani iní‑gá, chi ñá túú tàú‑í sá quɨ̌hu‑gá ndéé xɨtɨ́ vehe‑í, ");
INSERT INTO milNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","chi nì sá cùnú ndúcú mèe‑í‑gá ñá túú ní cùyɨɨ‑í. Núu xíǎⁿ cúñaha‑ndo xìi‑gá sá ná càháⁿ‑ni‑gá sá ndǔha tée xìnu cuechi núù‑í‑a te ndúha‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Chi yúhú ndécú cuè tée tàxi tnuní ñáhá xìi‑í, te ducaⁿ yǔhú tucu ndècu cue sandadú táxí tnùní‑í. Te òré xǎhaⁿ‑ǐ xii ɨɨⁿ‑dé quɨ́hɨ́ⁿ‑dé ɨɨⁿ chìuⁿ te cuáháⁿ‑dé, te òré xǎhaⁿ‑ǐ xii ɨngá‑dé quixi‑dé te véxi‑dé, te òré xǎhaⁿ‑ǐ xii tée xìnu cuechi núù‑í cada‑dé ɨɨⁿ chìuⁿ te quìde‑dé. Duha càchí‑í cúñaha‑ndo xìi‑gá —càchí‑dé xǎhaⁿ‑dě xii cue tée càháⁿ ndɨhɨ‑dé‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Te sátá dúcáⁿ nǐ xáhaⁿ‑güedě xii Jèsús, te ní cuñúhu‑gá nchaa tnúhu ní cáháⁿ tée cùu capitáⁿ‑áⁿ, te ní nchócótó‑gǎ núú nchàa ñáyiu nchìcúⁿ ñáhá xìi‑gá cuáháⁿ, te ní xáhaⁿ‑gǎ: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ vǎtá quìní‑gá‑í ni ɨ̀ɨⁿ ñáyiu isràél, ñáyiu ío váha sàndáá iní‑xi Yá Ndiǒxí dàtná sàndáá iní ñáhá těe‑ǎⁿ xii‑gá —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Te òré ní ndexìo cue tée nèhe tnúhu‑áⁿ nǐ sáháⁿ núú Jèsús, te sa ní ndúha tée cùhú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Te sátá dúcáⁿ nǐ cuu te ní xica Jèsús cuáháⁿ‑gá ɨɨⁿ ñuú nání Nàín, ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, ndɨhɨ vài ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Te òré ní sáá‑gá yuhu ñùú‑áⁿ, te ní xiní‑gá nchídó‑güedě ɨɨⁿ ndɨ́yɨ cuáháⁿ chindúxi ñaha‑güedě, te ndɨ́yɨ‑áⁿ cúú děhe ɨɨⁿ ñaha quèé, te ɨɨⁿdìi ducaⁿ‑ni déhe‑aⁿ ndècu ni cuu te ní xíhí‑dé. Te ío cuéhé ñǎyiu cuáháⁿ chindúxi ñaha. ");
INSERT INTO milNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Te òré ní xiní ñáhá Jèsús xii‑aⁿ ndàhyú‑aⁿ te ní cundàhú iní ñáhá‑gǎ, te ní xáhaⁿ‑gǎ: —Vá ndàhyú‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Te ní dáyátní‑gǎ càjá ñúhú ndɨ̌yɨ‑áⁿ te ní dácàá‑gá ndaha‑gá te ní tendaha‑gǎ càjá‑áⁿ, te ní ngüɨ́ñɨ́ cue tée nchìdo ñaha‑áⁿ. Te ní xáhaⁿ‑gǎ xii ndɨ́yɨ‑áⁿ: —Tée cuechi, yúhú càchí‑í sá ndácǒo‑n —càchí‑gá xǎhaⁿ‑gǎ xii ndɨ́yɨ‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Te tée ní xíhí‑áⁿ nǐ nucúnucóo‑dé te ní ngüíta‑dé càháⁿ‑dé, te Jèsús ní nacuáha cuèndá ñáhá‑gǎ xii‑dé ndaha nǎná‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Te sá dúcáⁿ nǐ quide Jèsús ní xiní‑yu te ío ní yùhú‑yu, te ní xítnàhá‑yu: —Ío càhnu cuu Yá Ndiǒxí chi ɨɨⁿ tée càháⁿ tnúhu‑gá ní quexìo núú ndécú‑ó —càchí‑yu xǐtnàhá‑yu. Te ní xítnàha tucú‑yu: —Yá Ndiǒxí véxi‑gá chindee ñàha‑gá xii nchaa nchoo ñǎyiu cùu cuendá‑gá —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Te nchaa ñuú distrìtú Jùdeá, ndɨhɨ dava‑gá ñuú ní níhǐ‑yu tnúhu nàcuáa ní quide Jèsús. ");
INSERT INTO milNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Te cue tée xìca cuu ndɨhɨ té Juàá ní xáhaⁿ‑güedě xii‑dé nchaa sá nǐ quide‑gá, núu ní cana‑dé úú tnàhá‑güedé ");
INSERT INTO milNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","cuèndá cúñaha‑dě quɨ́hɨ́ⁿ‑güedé nducu tnǔhu‑güedé núú Jèsús, te núu sá dɨ́ú‑gǎ cúú‑gǎ Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a àdi sá cúndètu nahi‑ni‑güedé mei Yàá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Te òré ní quexìo cue tée ní tendaha tě Juàá núú ndécú Jèsús, te xǎhaⁿ‑güedě xii‑gá: —Té Juàá tée dàcuandute ñaha xii ñáyiu ní tendaha ñàha‑dé xii‑ndɨ́ véxi‑ndɨ́ cácáⁿ tnúhú‑ndɨ̌ núú‑n, núu sá dɨ́ú‑n cùu Cristú Yaá quixi ñuyíú‑a, àdi sá cúndètu‑ndɨ́ mei Crìstú càchí‑dé —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Te mei òré ní quexìo‑güedé‑áⁿ nǐ quide tátna Jèsús vài ñáyiu cùhú, te davá‑yu càhú víhí tnàhá‑yu, te ndɨ dɨ́ɨ́ⁿ ndɨ̀ dɨ́ɨ́ⁿ nǔú cuèhé tnàhá‑yu ɨɨⁿ ɨɨ́ⁿ‑yu, te cue ñáyiu yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha ní queñuhu‑gá espíritú‑áⁿ yɨquɨ cùñú‑yu, te ío vài ñáyiu cuàá ní nacaáⁿ‑gá núǔ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí cuánùhú te cani‑ndo cuèndú núú tě Juàá nchaa sá nǐ xiní‑ndó quìde‑í, ndɨhɨ nchaa nàcuáa ndùu tnúhu ní cáháⁿ‑í ní xíndedóho‑ndo. Te cúñaha‑ndo xìi‑dé sá quídé tǎtna‑í núú cuè ñáyiu cuàá, te quìde tátna‑í cue ñáyiu yacua, ndɨhɨ cue ñáyiu tnàhá cuéhé sǎ dátèhyú nihnu‑xi yɨquɨ cùñú‑yu, ndɨhɨ cue ñáyiu doho, nchaa ñáyiu‑áⁿ quìde tátna‑í te ndǔha‑yu, te ndéé cue ñáyiu sa ní xíhí dándòto‑í cúñaha‑ndo xìi‑dé, te cúñaha tùcu‑ndo xii‑dé sá nděcuu‑í dánèhé‑í nchaa ñáyiu ndàhú tnúhu sá sánú ìchi ñaha xií‑yu nàcuáa naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Te cúñaha tùcu‑ndo xii‑dé sá ǐo váha táhú nchaa ñáyiu ñá túú quìde sáá iní nchaa tnúhu càháⁿ‑í, duha cúñaha‑ndo xìi‑dé —càchí‑gá xǎhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Te sátá nǐ yáha‑güedé cuánuhú‑güedé, te ní ngüíta Jèsús ní cáháⁿ‑gá núú ñǎyiu cuèndá té Juàá, te xǎhaⁿ‑gǎ xií‑yu: —Nchòhó ní sándéhé‑ndó ɨ̀ɨⁿ tée ndècu xɨtɨ́ yucu, te tée‑áⁿ ñà túú sàni ɨɨⁿ sani úú iní‑dé, chi ñá túú quìde‑dé dàtná quídé nchàa ité náhnú cuǎháⁿ‑xi duha cuáháⁿ‑xi dàcáⁿ òré quéné tǎchí. ");
INSERT INTO milNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Te ni ñà túú ní sàndéhé‑ndó ɨ̀ɨⁿ tée nìhnu dóó vǎha dóó vii càa. Te nchòhó xìní‑ndó sǎ ñǎyiu sàcuíhnu dóó vǎha dóó vii càa ñá túú nǎ cúmǎní xií‑yu, te nchaa ñáyiu‑áⁿ ndécǔ‑yu vehe cue tée cùnuu yɨndaha ñaha xii ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Dico nchòhó chi ní sándéhé‑ndó ɨ̀ɨⁿ tée càháⁿ tnúhu Yá Ndiǒxí. Te ndáá sá dɨ́ú těe càháⁿ tnúhu‑gá cúú‑dě dico cùnuu‑gá‑dé dàcúúxí dàva‑gá cue tée càháⁿ tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Te dɨu cuèndá té Juàá‑áⁿ càháⁿ‑xi núú tùtú Yǎ Ndiǒxí nàcuáa ní xáhaⁿ‑gǎ xii Crìstú, te duha ní xáhaⁿ‑gǎ: Tendaha‑ǐ ɨɨⁿ tée cáháⁿ tnúhu‑í codonùu‑dé núú‑n cuèndá dàtúha‑dé ñáyiu cuèndá quɨ́ndáá iní‑yu tnúhu‑n. Duha ní xáhaⁿ‑gǎ, te ducaⁿ nǐ ngódó tnùní núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Te na càchí tnúhu‑í xii‑ndo sǎ nì ɨɨⁿ cue tée ñuyíú‑a ñá túú cùnuu‑güedé dàtná cúnùu té Juàá tée dàcuandute ñaha xii ñáyiu. Te nchaa ñáyiu sa ta ndɨ̌hu ndaha ñàha Yá Ndiǒxí vitna cuáháⁿ cúnùu‑gá‑ni tucú‑yu dàcúúxí tě Juàá cuěi cùú‑yu ñáyiu ñá túú cùnuu dacúúxí dàva‑gá ñáyiu yɨ̀ndaha‑gá —càchí Jèsús xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Te sá dúcáⁿ nǐ cáháⁿ Jèsús, núu nchaa ñáyiu ní dácuándùte té Juàá ní cachí‑yu sá ǐo váha quìde Yá Ndiǒxí, te dɨu‑ni ducaⁿ nǐ cáháⁿ cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú, cue tée ní dácuándùte‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Dico cue tée cùu fariséú, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, cue tée ñá túú ní dàcuandute té Juàá ñá túú ní tnàhá iní‑güedé cada‑güedé nchaa sá vǎha cuìní Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Te Xítohó Jesucrìstú ní xáhaⁿ‑gǎ xií‑yu: —Na càchí tnúhu‑í xii‑ndo nàcuáa sǎtnahá‑xi cùu ñáyiu ndècu vitna. ");
INSERT INTO milNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Chi ñáyiu‑áⁿ cúǔ‑yu dàtná cue landú sácǒo núú yǎhu dàdɨquɨ‑güexi te níhi càháⁿ‑güexi, te xǐtnàha‑güexi: “Ní tɨú‑ndɨ́ yaá ndɨhɨ vǐlu te ñá túú ní cuìní‑ndó càta‑ndo. Te ío yica ìní ní xita yuhu‑ndɨ̌ te ñá túú ní ndǎhyú‑ndó”, càchí‑güexi xǐtnàha‑güexi. Te ducaⁿ sǎtnahá‑xi cùu ñáyiu ndècu vitna. ");
INSERT INTO milNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Te té Juàá tée ní xóo dacuàndute ñaha xii ñáyiu ío ndàhú ní xóo caxi‑dé, te ni ñà túú ní xǒo coho‑dé ndudí ndéhé yoho yàha stilé sá sà ní nduu‑xi ndidí, te ní cachí‑ndó sǎ nǐ xíndecu ndɨhɨ‑dé espíritú cúndɨ̀hɨ yucu ñávǎha. ");
INSERT INTO milNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Te sátá nǐ quexìo yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, te xèxi‑í xìhi‑í ndécù‑í te càchí‑ndó sǎ cúù‑í tée xèxi vihi te xìhi vihi‑í. Te càchí tucu‑ndo sǎ cúù‑í tée xìca cuu ndɨhɨ cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú, ndɨhɨ nchaa dava‑gá cue tée ndècu ichi cuehé ichi duha, duha càchí‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Te ñáyiu ní tnahá tnúhu ndɨhɨ Yá Ndiǒxí, ñáyiu‑áⁿ quídě‑yu nàcuáa cutnùní sá méé‑gǎ ío ndècu ndɨhɨ‑gá sá xìní tnùní‑gá —càchí‑gá xǎhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Te ɨɨⁿ tée cùu fariséú ní cáháⁿ‑dé Jèsús vehe‑dé caxi‑gá, te òré ní quexìo‑gá te cuánguɨhu‑gá mèsá. ");
INSERT INTO milNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Te xíáⁿ núcǒo‑gá ní sáá ɨɨⁿ ñadɨ̀hɨ́ te dɨu‑ni ñaha ñuú‑áⁿ cúú‑áⁿ, te ndècu‑aⁿ ichi dɨ́ɨ́ ìní, te sá nǐ níhí‑aⁿ tnúhu sá cuǎngaxi Jèsús vehe tée cùu fariséú‑áⁿ, núu nèhe‑aⁿ ɨɨⁿ yoó chitu àcití sàháⁿ tnámí. ");
INSERT INTO milNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Te ní ngóo‑aⁿ ɨɨⁿ xio dɨ̀ñɨ Jesús, te ní ngüíta‑aⁿ ndàhyú‑aⁿ te ndɨhɨ ndute núú‑aⁿ ní naquete‑aⁿ sáhá‑gǎ. Te dǎtnùní ní nadayìchí‑aⁿ ndɨhɨ idi dɨ́quɨ́‑aⁿ, te ní teyuhu‑aⁿ sǎhá‑gǎ, te ní chihi ñaha‑aⁿ àcití sàháⁿ tnámí‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Te sá dúcáⁿ nǐ quide‑aⁿ ní xiní tée cùu fariséú tée ní cáháⁿ ñáhá xìi‑gá‑áⁿ nǔu ní sani iní‑dé: “Te núu dìcó ndisa tée càháⁿ tnúhu Yá Ndiǒxí cúú těe‑a ña, te sa cutnùní iní‑dé yoo cùu ñaha tnándeé ñáhá xìi‑dé, àdi ná ñáyiu cùu‑aⁿ, te dìcó ɨɨⁿ ñaha ndècu ichi dɨ́ɨ́ ìní cúú‑áⁿ”, duha ní sani iní‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Xǐmú, ndècu ɨɨⁿ tnúhu cachí tnúhu‑í xii‑n —càchí‑gá xǎhaⁿ‑gǎ xii‑dé. Te tée cùu fariséú‑áⁿ xǎhaⁿ‑dě xii‑gá: —Cachí tnúhu, Mèstrú —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Te Jèsús ní xáhaⁿ‑gǎ: —Ní xíndecu ɨɨⁿ tée ní xóo dasaⁿ nùu díhúⁿ, te ní xítaú úú tnàhá‑güedé núú‑dě. Te ɨɨⁿ‑dé ní sáha‑dé úhúⁿ cièndú díhúⁿ denàriú, te ɨngá‑dé ní sáha‑dé údico úxí. ");
INSERT INTO milNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Te ñá ní nǐhí‑güedě nacháhu‑güedé núú‑dě, te tée ní sánùu ñaha‑áⁿ nǐ quide càhnu iní‑dé ndɨ ndùú‑güedé. Te vitna cachí‑ǒ tucu te núu nděda càa‑güedé cúú ìní ñáhá‑gǎ‑güedé xii‑dé —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Te ní xáhaⁿ tě Xǐmú‑áⁿ: —Sànuu sá těe tàú vài‑gá díhúⁿ ǐo‑gá cúú ìní‑dé tée ní sánùu ñaha díhúⁿ‑ǎⁿ —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te ní xáhaⁿ Jèsús: —Sá ndàá càháⁿ‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","46","Te Jèsús ní ndacoto‑gá núú ñadɨ̀hɨ́‑áⁿ, te ní xáhaⁿ‑gǎ xii té Xǐmú‑áⁿ: —¿Ndèhe‑n nacuáa quìde ñadɨhɨ́‑a ñǎ? Chi cuánguɨhu‑í vehe‑n, dico ñá túú ní tàxi‑n ndute ndoo sáhà‑í, te ni ñà túú ní tèyuhu ñaha‑n, te ni ñà túú ní chìhi‑n acití dɨ́quɨ̀‑í, dico ñadɨ̀hɨ́‑a ní naquete‑aⁿ ndɨhɨ ndute núú‑aⁿ sǎhà‑í, te ní nadayìchí‑aⁿ ndɨhɨ idi dɨ́quɨ́‑aⁿ, te nuu núu teyuhu‑aⁿ sáhà‑í, te ní chihi‑aⁿ acìtí sàháⁿ tnámí sǎhà‑í. ");
INSERT INTO milNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Te na càchí tnúhu‑í xii‑n sǎ ǐo cùu iní ñáhá‑áⁿ xìi‑í, te núu xíǎⁿ cútnùní iní‑ó sǎ cuěi ío vài sá cuèhé sá dúhá nǐ quide‑aⁿ, dico Yá Ndiǒxí sa ní quide càhnu iní ñáhá‑gǎ xii‑aⁿ. Chi Yá Ndiǒxí quídé càhnu iní‑gá ñáyiu cuěi vài àdi sacú cuéchi‑yu, te núu sacú cuéchi‑yu te sacú cúú ìní ñáhǎ‑yu xii‑í —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Te ní xáhaⁿ‑gǎ xii ñadɨ̀hɨ́‑áⁿ: —Sa ní quide càhnu iní‑í nchaa cuéchi‑n —càchí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Te cue tée xǐnucóo ndɨhɨ‑gá xǐtnàha‑güedé: —¿Ná tée cùu tée‑a núu nándɨ sá quídé‑dě, te ndéé nchaa yícá cuěchi ñáyiu quìde cahnu iní‑dé‑i? —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Te Jèsús ní xáhaⁿ tùcu‑gá xii ñadɨ̀hɨ́‑áⁿ: —Sa ní cácu nihnu‑n nǔú ùhú núú ndàhú vitna chi ní sándáá iní ñáhá‑n xìi‑í, te vitna cuanùhú te ñá túú‑gǎ ná cani iní‑n —càchí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Te sátá dúcáⁿ nǐ cuu te Jèsús ní xica‑gá cuáháⁿ‑gá tɨtnɨ́ víhí ñùú náhnú, ndɨhɨ ñuú lǐhli dànehé‑gá ñáyiu nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu. Te cuáháⁿ ndɨhɨ‑gá ndɨ ùxúú tnàhá cue tée xìca cuu ndɨhɨ‑gá, ");
INSERT INTO milNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ndɨhɨ ɨɨⁿ ǔú ñáyiu dɨ̀hɨ́ ní quide tátna‑gá ní xɨ́hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha, ndɨhɨ ñáyiu tnàhá dava‑gá cuéhé ǔhú ní cùu. Te xíáⁿ tnàhá tucu ɨɨⁿ ñaha nàni Mariá Magdalèná, te ñaha‑áⁿ nǐ xɨ́hɨ ñaha ǔsá espíritú cúndɨ̀hɨ yucu ñávǎha xii‑aⁿ ni cùu, te ní quee ñaha‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Te tnàhá ɨɨⁿ ñaha nàni Juáná ñadɨ̀hɨ́ ɨɨⁿ tée nàni Chúza tée ní cunuu nǐ xinu cuechi vèhe té Hèrodés, ndɨhɨ ɨngá ñaha nàni Susaná nchaa ñáyiu‑áⁿ nǐ chindee ñàhá‑yu xii‑gá ndɨhɨ nchaa sá ndécú ndɨ̀hɨ́‑yu, te dɨu‑ni ducaⁿ nǐ quide vài‑gá tucu ñáyiu nchìcúⁿ ñáhá xìi‑gá cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Te ío vài ñáyiu ndaa ñuú ní tacá‑yu núú ndécú Jèsús, te ní ngüíta‑gá ní cani‑gá ɨɨⁿ cuèndú núǔ‑yu cuèndá tecú tnùní‑yu tnúhu‑gá, te xáhaⁿ‑gǎ xií‑yu: ");
INSERT INTO milNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Ɨɨⁿ tée cuángacáⁿ‑dé trìú. Te òré ní ngüíta‑dé dǎngoyo‑dé trìú‑áⁿ te dava ní quene ndava ní ngava ndéé ichi, te ní xénihnu ñáyiu, te ní xiní tɨ́laá te ní nadatàcá‑güedɨ. ");
INSERT INTO milNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Te dava ní ngava ñuhu yadi nǔú yɨ́hɨ́ vìhi yúú, te ní xínu‑xi dico núú sàcú‑ni nduu te ní yíchí‑xi, chi ñá túú cǒhyo yɨ̀hɨ. ");
INSERT INTO milNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Te dava ní ngava núú yúcú ndɨ̌quɨ́ⁿ tnu ìñu, te ɨɨⁿnuu‑ni nǐ xínu‑xi ndɨhɨ tnu ìñu‑áⁿ, te tnu ìñu‑áⁿ nǐ dánáá‑xí nchàa triú sá nǐ xínu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Dico dava trìú‑áⁿ nǐ ngava‑xi núú ndécú ñùhu cocoⁿ, te xíǎⁿ ní xínu‑xi te ní sahnu‑xi, te ío váha ní cuu, chi núú ɨ́ɨ́ⁿ‑ní trìú te ní nguɨ́hɨ yoco‑xi ɨɨⁿ cièndú trìú‑xi —càchí‑gá xáhaⁿ‑gǎ xií‑yu. Te níhi ní cáháⁿ‑gá ní xáhaⁿ tùcu‑gá xií‑yu: —Nchaa nchòhó ñáyiu ní xíndedóho tnúhu ní cáháⁿ‑í‑a, te ío váha chí cuǎha cuèndá —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Te cue tée xìca cuu ndɨhɨ Jesús ní xícáⁿ tnúhú‑güedě núú‑gǎ nǔu nása quèe‑xi cuendú ní cani‑gá núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Te ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó chi sa càchí tnúhu Yá Ndiǒxí xii‑ndo ɨ̀ɨⁿ sá vǎtá quìní‑gá‑ndó, chi càchí tnúhu‑gá nàcuáa cada‑gá ndɨ́hu ndaha‑gǎ ñáyiu, dico dava‑gá ñáyiu càni‑í mee‑ni cuèndú núǔ‑yu, chi cuěi na quìní‑yu nchaa nàcuáa cuu dico nì vá cútnùní iní‑yu ná cuèndá ducaⁿ cùu, àdi cuéi na cùndedóho‑yu dico nì vá tècú tnùní‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Te xǎhaⁿ tùcu‑gá xii‑güedé: —Duha quèe‑xi cuendú ní cani‑í núú‑ndó, chi trìú ní sacáⁿ tée‑áⁿ cúú‑xí dàtná tnúhu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Te trìú sá nǐ quene ndava ní ngava ndéé ichi‑áⁿ, xíǎⁿ cúú‑xí dàtná ñáyiu ní quée iní‑xi tnúhu Yá Ndiǒxí, dico sácuíhná cuǎháⁿ‑xi xòcani‑xi tnúhu‑gá iní‑yu cuèndá sá vǎ quɨ̀ndáá iní‑yu, te vá nánìhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Te trìú sá nǐ ngava ñuhu yadi nǔú yɨ́hɨ́ vìhi yúú, xíǎⁿ cúú‑xí dàtná ñáyiu ní xíndedóho tnúhu Yá Ndiǒxí te dɨ́ɨ́ ìní ní tnɨɨ́‑yu tnúhu‑gá, dico òré ná dàcaháⁿ ñáhá yùcu ñávǎha xií‑yu nándɨ cadá‑yu, te dàña nihnú‑yu tnúhu‑gá chi ñá nìhí ndéě‑yu canchicúⁿ nihnú‑yu nàcuáa càháⁿ tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Te trìú sá nǐ ngava núú yúcú ndɨ̌quɨ́ⁿ tnu ìñu‑áⁿ, xíǎⁿ cúú‑xí dàtná ñáyiu ní tecú dóho‑xi tnúhu Yá Ndiǒxí, dico cuèé cuèé ní nacuanaá‑yu tnúhu‑gá, chi cuèndá mee‑ni sǎ cúú‑xí mèé‑yu ñùhu iní‑yu, ndɨhɨ cuèndá sá ǐo sàni iní‑yu cuu cuìcá‑yu, ndɨhɨ cuèndá sá ǐo cùdɨ́ɨ́ ìní‑yu nchaa sá ìó ñuyíú‑a núu xíǎⁿ àúⁿ nǎ cuu ní xíndedóho‑yu tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Dico trìú sá nǐ ngava núú ndécú ñùhu cocoⁿ, xíǎⁿ cúú‑xí dàtná ñáyiu váha iní‑xi ní xíndedóho tnúhu Yá Ndiǒxí chi ñá túú dàña nihnú‑yu, te nɨ yùhu nɨ iní‑yu quìdé‑yu nchaa nàcuáa càháⁿ tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Te ñá túú nì ɨɨⁿ ñáyiu tèñuhú‑yu ɨɨⁿ itɨ te dàdáhu‑yu, àdi chiváha‑yu ɨɨⁿ caha càmá, chi tàxi ndecú‑yu núú nǐnu cuèndá cutnùní núú nchàa ñáyiu ndècu vehe. ");
INSERT INTO milNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Te ni ɨ̀ɨⁿ tnúhu sá ñǎ tècú tnùní ñáyiu vitna vá càchí‑ó sǎ vǎ tècú tnùní‑yu chi dacuéi sá tècú tnùní‑yu, te ni ɨ̀ɨⁿ tnúhu sá càchí‑ó cùu yuhu vitna vá cúú yùhu chi dacuɨtɨ́í sǎ quéé tǔu‑xi núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Te chí cúndèdóho váha tnúhu na càháⁿ‑í‑a. Nchaa ñáyiu sàndáá iní ñáhá xìi Yá Ndiǒxí ío‑gá cuita quɨndáá‑gá iní ñáhǎ‑yu xii‑gá quɨ́hɨ́ⁿ, te nchaa ñáyiu ñá túú sàndáá iní ñáhá xìi‑gá uuⁿ‑gá cuita cuu sàá‑gá iní‑yu núú‑gǎ quɨ́hɨ́ⁿ —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Te ní quexìo náná Jèsús ndɨhɨ cue ñaní‑gá vehe núú ndécú‑gǎ, te ñá ndácǔ‑yu cáháⁿ ndɨhɨ ñàhá‑yu xii‑gá chi ío cuéhé ñǎyiu ndècu núú ndécú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Te ɨɨⁿ ñáyiu xǐndecu‑áⁿ nǐ dáyǎha‑yu tnúhu núú‑gǎ, te xǎhǎⁿ‑yu: —Ní quexìo náná‑n ndɨ̀hɨ cue ñaní‑n xǐnutnɨ́ɨ‑yu quehé, te cuìní‑yu cáháⁿ ndɨhɨ ñàhá‑yu xii‑n —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Te ní xáhaⁿ‑gǎ: —Nchaa ñáyiu sàcúndedóho tnúhu Yá Ndiǒxí te quìdé‑yu nchaa nàcuáa càháⁿ tnúhu‑gá, ñáyiu‑áⁿ cúǔ‑yu dàtná nǎnà‑í ndɨhɨ dàtná cue ñaní‑í —càchí‑gá xáhaⁿ‑gǎ xii ñáyiu ní dáyǎha tnúhu núú‑gǎ‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Te ɨɨⁿ nduu ní quée Jèsús bàrcú ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te ní xáhaⁿ‑gǎ: —Chí ná quɨ̀hɨ́ⁿ‑ó ndàa ɨngá xio yuhu làgúná —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. Te cuáháⁿ‑güedé ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Te nɨni ñùhu barcú ichi cuáháⁿ‑xi núú ndute ní xídí Jèsús. Te ní ngüíta‑xi níhi vìhi quene táchí te ta nàdachitú‑xi ndute xɨtɨ́ bàrcú‑áⁿ cuǎháⁿ, te sa cuìní‑nǎ‑xi quée naa bàrcú‑áⁿ xɨtɨ́ ndute ni cùu. ");
INSERT INTO milNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Te ní sáháⁿ‑güedé núú cáá Jèsús xìdí‑gá, te ní xáhaⁿ‑güedě xii‑gá: —¡Mèstrú, ndɨquɨ́ú ìní chi tà quée naa‑o cuǎháⁿ! —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te Jèsús ní ndɨquɨ́ú ìní‑gá te ní ndacóo‑gá te ní tenàá‑gá táchí‑ǎⁿ ndɨhɨ ndute làgúná‑áⁿ, te ní ngüɨ́ñɨ́‑ni táchí‑ǎⁿ te ní nucúndecu nahi‑nǎ ndute làgúná‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Te ní xáhaⁿ‑gǎ xii‑güedé: —¿Náa ñá túú sàndáá iní ñáhá ndìsa‑ndo xii‑í ǎⁿ? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. Te ní cuñúhu‑güedé sá dúcáⁿ nǐ quide‑gá ní xiní‑güedé, te ní yùhú‑güedé, te ní xítnàha‑güedé: —¿Te ná tée cùu tée‑a núu ní cáháⁿ‑ni‑dé te ní ngüɨ́ñɨ́ táchí te ní nucúndecu nahi‑ni ndùte lagúná‑a‑i? —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Te ní sáá‑gá ndɨhɨ‑güedé yucu cue tée ñuú Gàdará, te yɨ̀hɨ ndáá‑ni ndàa ɨngá xio làgúná‑áⁿ cáá dìstritú Galìleá. ");
INSERT INTO milNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Te òré ní quene Jèsús xɨtɨ́ bàrcú te ní dáyátní ñàha ɨɨⁿ tée ñuú‑áⁿ xii‑gá, te yɨ̀hɨ ñaha tɨtnɨ́ espíritú cúndɨ̀hɨ yucu ñávǎha xii‑dé. Te ní cunaha ñà túú‑gǎ sácuǐhnu‑dé dóó‑dě, te ni ñà túú‑gǎ sácǔndecu‑dé vehe‑dé, chi da nchaa núú yɨ́ndǔxi ndɨ́yɨ quìde vehe‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Te òré ní xiní‑dé Jèsús te ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú‑gǎ, te cue espíritú yɨ́hɨ́ ñàha xii‑dé‑áⁿ nǐ quide‑xi níhi ní cáháⁿ‑dé, te xǎhaⁿ‑dě xii‑gá: —¿Ná cuèndá véxi‑ǒ Jèsús Déhe Dútú Ndiǒxí sàdɨ́‑n ìchi‑í‑i? Te càháⁿ ndàhú‑í núú‑n sǎ và dándòho ñaha‑n xii‑í —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Te ducaⁿ nǐ cáháⁿ‑dé cuèndá sá Jèsús ní xáhaⁿ‑gǎ xii nchaa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha sá ná quèe ñaha‑xi xii‑dé. Te nchaa xíǎⁿ ní xóo dacàháⁿ‑xi iní‑dé nándɨ sá nǐ xóo cada‑dé nǔu ní xóo dacùtu ñaha‑güedé cadèná xii‑dé cuèndá sá ñà túú‑gǎ ná cada‑dé, te ní xóo cundeé ñáhá‑güedě, dico cuěi ducaⁿ dico ní xóo dandàva‑ni‑dé cadèná, te cue espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ nǐ xóo dacùnu ñaha‑xi xii‑dé ní xóo quɨ́hɨ́ⁿ‑dé xɨtɨ́ yucu. ");
INSERT INTO milNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Te Jèsús ní xícáⁿ tnúhú‑gǎ núú‑dě, te xáhaⁿ‑gǎ: —¿Nása nàni‑n‑i? —cachí‑gá xáhaⁿ‑gǎ. Te ní xáhaⁿ‑dě: —Vài Sandadú nánì‑í —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te ducaⁿ nǐ xáhaⁿ‑dě xii‑gá cuèndá sá ǐo cuéhé espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Te nchaa espíritú‑áⁿ nǐ cáháⁿ ndàhú‑xi núú Jèsús sá vǎ téndàha ñaha‑gá xii‑xi quɨ́hɨ́ⁿ‑xi núú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Te dɨu‑ni yatni yucu núú ndécú Jèsús‑áⁿ yɨ́hɨ́ vài cuchí xǐxexi‑güedɨ, te nchaa espíritú‑áⁿ nǐ cáháⁿ ndàhú‑xi núú‑gǎ sá ná dàña‑gá quɨ́hu‑xi yɨquɨ cùñú nchaa cùchí‑áⁿ, te Jèsús ní xáhaⁿ‑gǎ sá cúú quɨ̌hu‑xi yɨquɨ cùñú‑güedɨ. ");
INSERT INTO milNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Te ní quee ñaha nchàa espíritú‑áⁿ xii tée‑áⁿ, te ní quɨ́hu‑xi nchaa cùchí‑áⁿ, te cùchí‑áⁿ nǐ xinu‑güedɨ duha ní quée‑güedɨ ndàa núú dèhvá yuhu làgúná‑áⁿ, te ní ngaunihnu‑güedɨ xɨtɨ́ ndute te ní ndɨhɨ‑güedɨ ní cáhá. ");
INSERT INTO milNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Te òré ní xiní cue tée xìto cuchí‑áⁿ nàcuáa ní cuu te ní yùhú‑güedé ní xinu‑güedé, te ní sáháⁿ‑güedé ní cani‑güedé cuèndú núú cuè ñáyiu ndècu xɨtɨ́ ñuú, ndɨhɨ núú cuè ñáyiu ndècu xɨtɨ́ yucu. ");
INSERT INTO milNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Te nchaa ñáyiu ní níhí tnǔhu ní queé‑yu cuáháⁿ ndéhě‑yu nàcuáa ní cuu. Te òré ní quexìó‑yu núú ndécú Jèsús, te ní xiní‑yu tée ní xɨ́hɨ ñaha cuè espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ núcǒo‑dé núú sàhá Jèsús, te nìhnu‑ná‑dé dóó‑dě, te nùcóo‑dé dàtná ɨɨⁿ ñáyiu váha, te ní yùhú‑yu òré ní xiní ñáhǎ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Te nchaa ñáyiu ní xiní nàcuáa ní cuu ní ndúha tée yɨ̀hɨ ñaha cue espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ ní cùu ní caní‑yu cuèndú núú nchàa ñáyiu ní quexìo‑áⁿ nàcuáa ní cuu ní ndúha tée‑áⁿ ndɨhɨ nàcuáa ní cuu cuèndá nchaa cùchí‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Te sá dúcáⁿ nǐ níhǐ‑yu tnúhu nàcuáa ní cuu, núu nchaa ñáyiu ñuú Gàdará ío ní yùhú‑yu te ní ngüíta‑yu càháⁿ ndàhú‑yu núú Jèsús sá ná nùhú‑gá nǔu ndèé ichi véxi‑gá. Te sá dúcáⁿ nǐ cáháⁿ‑yu núu cuáháⁿ‑gá núú ndécú bàrcú. Te òré ndée‑gá bàrcú‑áⁿ nǔhú‑gá ");
INSERT INTO milNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ní ngüíta tée ní xɨ́hɨ ñaha cuè espíritú cúndɨ̀hɨ yucu ñávǎha càháⁿ ndàhú‑dé núú‑gǎ nǔu vá cúndèe iní‑gá quɨ́hɨ́ⁿ ndɨhɨ ñaha‑gǎ xii‑dé, dico Jèsús ní quide ndee ìní ñáhá‑ni‑gǎ xii‑dé, te ní xáhaⁿ‑gǎ: ");
INSERT INTO milNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Cuanùhú vehe‑n, te cani‑n cuèndú núú nchàa ñáyiu sá ǐo càhnu cuu nchaa sá vǎha ní quide ñaha Yǎ Ndiǒxí xii‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. Te tée‑áⁿ nǐ xica‑dé cuánuhú‑dé te ní ngüíta‑dé ní cani‑dé cuèndú núú nchàa ñáyiu xǐndecu nɨhìí ñuú sá ǐo càhnu cuu nchaa sá vǎha ní quide ñaha Jèsús xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Te òré ní ndexìo Jesús ndàa ɨngá xio yuhu làgúná, te ñáyiu xǐndecu xíáⁿ sa ndètu cahnu ñaha‑ná‑yu, te ío váha ní cáháⁿ ndɨhɨ ñàhá‑yu xii‑gá òré ní nasáá‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Te ɨɨⁿ tée tàxi tnuní veñúhu ní quexìo‑dé núú ndécú Jèsús, te tée‑áⁿ nání‑dě Jàirú, te ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú‑gǎ càháⁿ ndàhú‑dé, te xǎhaⁿ‑dě xii‑gá: —Véxi‑í càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n quɨ̌hɨ́ⁿ‑ó vèhe‑í cada tátna‑n děhe yoco‑ǐ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Te ducaⁿ nǐ xáhaⁿ‑dě chi ndècu ɨɨⁿ dii‑ni déhe yoco‑dě, te ndècu‑xi datná úxúú cuíá‑xi, te càhú víhí tnàhá‑xi cùhú‑xi te cuìní‑xi cuú‑xi. Te Jèsús ní xica‑gá cuáháⁿ‑gá ndɨhɨ tée‑áⁿ, te ío vài ñáyiu nchìcúⁿ ñáhá xìi‑gá cuáháⁿ, te dàdehnde ñaha‑ná‑yu xii‑gá ní cùu. ");
INSERT INTO milNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Te tnuú nchaa ñáyiu‑áⁿ ñútnàhá ɨɨⁿ ñaha cùhú, te ñaha‑áⁿ sà ní cuu úxúú cuíá sǎ cùhú‑aⁿ ngòyo ñaha nɨ́ñɨ́ xii‑aⁿ, te ío cuéhé dǐhúⁿ nǐ cuu dàndoñuhu‑aⁿ chi ní nadico‑aⁿ nchàa sá ndécú ndɨ̀hɨ‑aⁿ cuendá ní níhí‑aⁿ díhúⁿ nǐ queheⁿ nchaa ñáyiu ní quide tátna ñaha xìi‑aⁿ, dico ni ɨ̀ɨ́ⁿ‑yu ñá túú ní ndàcú‑yu ndúha‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Te ní sáháⁿ ndehe yatni‑aⁿ ndàa sátá Jèsús, te ní tnándeé‑aⁿ luha yuhu dǒó‑gǎ te òré‑ni‑áⁿ nǐ ndúha‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Te Jèsús ní xícáⁿ tnúhú‑gǎ núǔ‑yu, te xáhaⁿ‑gǎ: —¿Ndědacàa‑ndo ní tnándeé ñáhá xìi‑í? —càchí‑gá xáhaⁿ‑gǎ xií‑yu. Te nchaá‑yu ní xáhǎⁿ‑yu sá nǐ ɨɨ́ⁿ‑yu ñá túú ní tnǎndeé ñáhá xìi‑gá. Te té Pèlú ndɨhɨ cue tée cùndɨhɨ‑dé ní xáhaⁿ‑güedě xii‑gá: —Mèstrú, ndèhe‑n sá váí ñǎyiu nchìcúⁿ ñáhá xìi‑n, te xio xio dàdehnde ñahá‑yu, te xìcáⁿ tnúhú‑gǎ‑n yòo ní tnándeé ñáhá xìi‑n —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Dico Jèsús ní xáhaⁿ‑gǎ xií‑yu: —Dico dɨu ɨɨⁿ‑ndo nǐ tnándeé ñáhá xìi‑í, chi ní cutnùní iní‑í sá ɨ̀ɨⁿ ñáyiu cùhú ní tnándeé ñáhá xìi‑í te ní ndúha‑yu —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Te sátá nǐ xiní ñaha‑áⁿ sǎ nǐ cutnùní iní Jèsús sá nǐ tnándeé ñáhá‑áⁿ xìi‑gá, te yùhú yùhú‑aⁿ ní sáhá‑aⁿ ní ngüɨ́ñɨ́ xɨ́tɨ́‑áⁿ nǔú‑gǎ, te ní náhmá‑aⁿ núú‑gǎ, ndɨhɨ núú nchàa ñáyiu ná cuèndá ducaⁿ nǐ quide‑aⁿ ní tnándeé‑aⁿ‑gá, ndɨhɨ cuèndá sá òré‑ni‑áⁿ nǐ ndúha‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Te Jèsús ní xáhaⁿ‑gǎ xii‑aⁿ: —Yòhó ñaha cùhú, ní sándáá iní ñáhá‑n xìi‑í nǔu ní ndúha‑n, te cuanùhú vitna te ñá túú‑gǎ ná cani iní‑n —càchí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Te càháⁿ dúcáⁿ‑ní Jèsús ní sáá ɨɨⁿ tée xìnu cuechi vehe té Jàirú tée tàxi tnuní veñúhu, te xǎhaⁿ těe xìnu cuechi‑áⁿ xii‑dé: —Sa ní xíhí déhe‑n, vá chíchìuⁿ‑gá‑n Mèstrú —càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Te sá dúcáⁿ xǎhaⁿ těe xìnu cuechi‑áⁿ xii té Jàirú ní tecú dóho Jèsús, núu ní xáhaⁿ‑gǎ xii‑dé: —Vá ndɨ̀hú iní‑n, quɨndáá iní ñáhá‑ní‑n xìi‑í te ndúha déhe‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Te òré ní sáá‑gá vehe té Jàirú te ñá ní dàña‑gá quɨ́hu ñáyiu cùtexínu, núu té Pèlú‑ni ndɨhɨ té Jàcobó‑ni, ndɨhɨ té Juàá‑ni, ndɨhɨ tǎtá ndɨhɨ nǎná‑ni xǐchí nǐ xíhí‑áⁿ cuǎnguɨhu ndɨhɨ‑gá xɨtɨ́ vehe. ");
INSERT INTO milNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Te nchaa ñáyiu sa xíndecu vehe‑dé‑áⁿ xǐndáhyú‑yu sá ndɨ̀hú iní‑yu cuèndá sá nǐ xíhí‑xi. Te Jèsús ní xáhaⁿ‑gǎ xií‑yu: —Vá ndàhyú‑ndó, chi dìcó‑ni xìdí‑xi ñá túú ní xǐhí‑xi —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Te ní sácú ndeé ñáhǎ‑yu xii‑gá, chi sá cúú‑xí mèé‑yu chi ní xíhí ndisa xíchí‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Te Jèsús ní tnɨɨ‑gá ndaha xíchí nǐ xíhí‑áⁿ, te níhi ní cáháⁿ‑gá, te xáhaⁿ‑gǎ: —Xíchí cuéchí, ndacóo —càchí‑gá xáhaⁿ‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Te xíchí‑ǎⁿ nǐ ndoto‑xi, te òré‑ni ní ndacóo‑xi, te Jèsús ní xáhaⁿ‑gǎ sá ná cuǎñàhá‑yu sá cáxí‑xí. ");
INSERT INTO milNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Te tǎtá‑xi ndɨhɨ nǎná‑xi súúní nǐ cuñúhu‑yu sá dúcáⁿ nǐ dándótó ñàha Jesús xii‑xi, te ní xáhaⁿ‑gǎ xií‑yu sá vǎ yǒo ɨɨⁿ cúñàhá‑yu sá dúcáⁿ nǐ quide‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Te Jèsús ní cana‑gá ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá, te ní sáñaha‑gǎ xii‑güedé tnúhu ndee ìní cundecu ndɨhɨ‑güedé cuèndá queñuhu‑güedé nchaa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu, ndɨhɨ cuèndá sá cádá tǎtna‑güedé nchaa ñáyiu cùhú. ");
INSERT INTO milNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Te ní xáhaⁿ‑gǎ xii‑güedé sá quɨ̀hɨ́ⁿ‑güedé danèhé‑güedé ñáyiu nàcuáa cada Yá Ndiǒxí ndɨ́hu ndaha ñàha‑gá xií‑yu, te ducaⁿ càda tátna‑güedé cue ñáyiu cùhú. ");
INSERT INTO milNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Te cùmání‑gǎ caca‑güedé quɨ́hɨ́ⁿ‑güedé, te ní xáhaⁿ‑gǎ xii‑güedé: —Ñá túú tnàhí ná canehe‑ndo cùu ichi‑ndo, ni tàtnu, ni ñùnu, ni sǎ cáxí‑ndó, ni dǐhúⁿ. Te ni vǎ cánèhe‑ndo ɨngá ichi dóó‑ndó, chi dɨu‑ni dóó níhnú‑ndó‑ǎⁿ xíǎⁿ tnàhí‑ni. ");
INSERT INTO milNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Te ndědani càa vehe na saá‑ndó, te xíáⁿ cundecu‑ndo ndèé ná sàá nduu ndèe‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Te núu ñá túú cuìní‑yu queheⁿ cuèndá ñáhǎ‑yu xii‑ndo, te ndee‑ndo ñùú‑áⁿ, te naquɨdɨ‑ndo tɨ̀cá chúhmá nǐ tnɨ́ɨ sáhá‑ndó cuèndá sá ná cùtnuní iní‑yu sá ñà túú quìde váha‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Te sátá dúcáⁿ nǐ xáhaⁿ Jèsús xii‑güedé, te ní quee‑güedé cuáháⁿ‑güedé nchaa ñuú dácuàha‑güedé ñáyiu tnúhu Yá Ndiǒxí, tnúhu sá càháⁿ nàcuáa naníhí tàhú‑yu, te ducaⁿ ta quìde tátna‑güedé nchaa ñáyiu cùhú cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Te té Hèrodés tée cùu gobiernú ní níhí‑dě tnúhu nchaa nàcuáa quìde Jesús, te quɨ̀yuhú iní‑dé te sàni iní‑dé yoo cùu‑gá. Te ducaⁿ nǐ sani iní‑dé chi dava ñáyiu càchí‑yu sá tě Juàá tée ní xóo dacuàndute ñaha xii ñáyiu ní ndoto cùu‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Te davá‑yu càchí‑yu sá tě Èliás cúú‑gǎ, te davá‑yu càchí‑yu sá ɨ̀ɨⁿ tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha vìhi ní ndoto cùu‑gá, càchí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Dico té Hèrodés ní cachí‑dé: —Yúhú ní táúchíùⁿ‑í ní xehndé‑güedé dɨ́quɨ́ tě Juàá. ¿Te yoo cùu tée dii cuèndú‑xi nìhí‑a sá sǔúní cuěhé nǔú sǎ quídé‑dě váíⁿ? —duha ní cachí‑dé. Te té Hèrodés ndúcú‑dě nàcuáa cada‑dé cuèndá quiní‑dé Jèsús. ");
INSERT INTO milNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Te nchaa cue tée ní táúchíúⁿ Jèsús cuáháⁿ cáháⁿ tnúhu Yá Ndiǒxí núú ñǎyiu ní ndexìo‑güedé núú‑gǎ te ní ngüíta‑güedé nácàni tnúhu‑güedé nchaa nàcuáa ní quide‑güedé. Te dǎtnùní ní xica‑gá medìi‑ni‑gá ndécá ñàha‑gá xii‑güedé cuáháⁿ ɨɨⁿ xichi núú ñà túú ñǎyiu ndècu, yatni núú cáá ñùú Bètsaidá. ");
INSERT INTO milNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Dico òré ní níhí ñǎyiu tnúhu sá cuàháⁿ Jèsús, te nchìcúⁿ‑yu‑gá cuáháⁿ, te òré ní quexìó‑yu núú‑gǎ, te ní queheⁿ cuèndá ñáhá‑gǎ xií‑yu, te ní dánèhé ñáhá‑gǎ xií‑yu nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu, te ní quide tátna‑gá nchaa ñáyiu cùhú. ");
INSERT INTO milNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Te òré sa ní cuaa te ní natacá ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá núú‑gǎ, te ní xáhaⁿ‑güedě xii‑gá: —Sa ní cuu dandàca‑n nchaa ñáyiu‑a, chi sa ní cuaa, te na quɨ̀hɨ́ⁿ‑yu nchaa vehe càa yatni iha, ndɨhɨ nchaa xɨtɨ́ ñuú cáá yàtni iha cuaáⁿ‑yu sá cáxǐ‑yu, te dɨu‑ni yàcáⁿ ndetatú‑yu, chi núú ndécú‑ó ìha ñá túú tnàhí ná ìó —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Mee‑ndo chǐ cuǎñaha sǎ ná càxí‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Ñá túú nǎgá ndécú ndɨ̀hɨ‑ndɨ́, chi úhúⁿ duha‑ná pàá, ndɨhɨ úú‑nǎ chácá ndécú ndɨ̀hɨ‑ndɨ́, te dɨu‑ni núu quɨ́hɨ́ⁿ‑ndɨ́ cuaaⁿ‑ndɨ́ sá cáxǐ‑yu —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Te xǐnu dàtná úhúⁿ mǐl mee‑ni cuè tée, te dɨ̀ɨⁿ ñáyiu dɨ̀hɨ́ ndɨhɨ landú. Te Jèsús ní xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá: —Chí cǔñaha na ngǒo ndɨ údico úxí ndɨ údico úxí‑yu ɨɨⁿ ɨɨⁿ xichi —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Te ducaⁿ nǐ quide‑güedé, te ní ngóo‑yu nchaá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Te dǎtnùní ní queheⁿ‑gá ndɨ ùhúⁿ pàá‑áⁿ, ndɨhɨ ndɨ ndùú chácá‑ǎⁿ. Te ní ndacoto‑gá andɨu, te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí, te dǎtnùní ní táhú cuèchi‑gá pàá‑áⁿ ndɨhɨ chácá‑ǎⁿ, te ní sáha‑gá nchaa cue tée xìca cuu ndɨhɨ‑gá ní dácǎhñu ñaha‑güedě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Te nchaá‑yu ní xexí‑yu ní ndahá xɨtɨ́‑yu. Te sátá nǐ túhú cóhǒ‑yu te ní nadatàcá‑güedé nchaa sá nǐ quendóo, te ní chítú ùxúú tnàhá tɨ́dihi mee‑ni sǎ nǐ quendóo. ");
INSERT INTO milNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Te ɨɨⁿ nduu ndècu mee Jesús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te càháⁿ ndɨhɨ‑gá Yǎ Ndiǒxí, te sátá nǐ yáha ní cáháⁿ ndɨhɨ‑gá Yǎ Ndiǒxí, te ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xáhaⁿ‑gǎ xii‑güedé: —¿Yoo cùu yúhú càchí ñáyiu‑va? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Te ní xáhaⁿ‑güedě xii‑gá: —Davá‑yu càchí‑yu sá cúú‑n ndǐi Juàá tée ní xóo dacuàndute ñaha xii ñáyiu, te davá‑yu càchí‑yu sá cúú‑n tě Èliás, te davá‑yu càchí‑yu sá ɨ̀ɨⁿ tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǐ ndoto cùu‑n, duha càchí‑yu —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Te ní xícáⁿ tnúhú tùcu‑gá núú‑güedě, te xáhaⁿ‑gǎ xii‑güedé: —Te nchòhó, ¿yoo sàni iní‑ndó cùu‑í‑i? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. Te té Pèlú ní xáhaⁿ‑dě xii‑gá: —Yòhó cúú‑n Crìstú Déhe Dútú Ndiǒxí —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Te ní xáhaⁿ‑gǎ xii‑güedé sá vǎ yǒo ɨɨⁿ cúñaha‑güedě yoo cùu‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Te ní xáhaⁿ‑gǎ xii‑güedé: —Yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ío cuéhé sǎ ndóhò‑í, chi daquèe tɨ́hú ñáhá cuè tée cùu sacuéhé nǔú ñǎyiu isràél, ndɨhɨ cue dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, te sáá nduu te cahni ñaha‑güedě xii‑í, dico nduu úní sá cùú‑í te ndoto‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Te dǎtnùní ní xáhaⁿ‑gǎ xii nchaa ñáyiu: —Nchaa ñáyiu cuìní chitnahá ñáhá xìi‑í, te xìni ñuhu‑xi vá cádá‑gǎ‑yu sá sání ìní méě‑yu, te ɨɨⁿ nduu ɨɨⁿ nduu cada ndee ìní‑yu cundecu túha‑yu ndohó‑yu cuèndá‑í, te cuěi na ndòhó‑yu dàtná ndoho‑í. ");
INSERT INTO milNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Te nchaa ñáyiu cuìní sá ñà túú tnàhí ná yáha cundecu ñuyíú‑a cuíta nihnú‑yu. Dico nchaa ñáyiu ñá túú yùhú cuěi nándɨ sá ná yǎha‑yu cundecú‑yu ñuyíú‑a sá cuèndá‑í, te ñáyiu‑áⁿ naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Te cuěi nchaandɨ túhú sá ìó ñuyíú‑a na nìhí ñáyiu cundecu ndɨhɨ́‑yu, dico núu dɨu nchaa xíǎⁿ ná càda cuíta nihnú‑yu te ñá túú vědana nàndɨ́hɨ‑xi sá dúcáⁿ ndècu ndɨhɨ́‑yu nchaa xíǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Te nchaa ñáyiu na cùcahaⁿ núú‑xi cáháⁿ váha cuèndá‑í ndɨhɨ cuèndá nchaa tnúhu‑í, te tnàhá yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo cucahaⁿ núù‑í núǔ‑yu òré quixi tucu‑í ndɨhɨ cue espíritú xínú cuèchi núú Tǎtà‑í Dútú Ndiǒxí, te mee‑gǎ cada cutnùní iní nchaa ñáyiu sá ǐo càhnu cuu‑í. ");
INSERT INTO milNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ ìó dava nchòhó ñáyiu ndècu iha vitna vá cùú‑ni‑ndo, chi cundecu‑ni‑ndo nděé quiní‑ndó sǎá nduu ndɨ́hu ndaha ñàha Yá Ndiǒxí xii ñáyiu —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Te ní cuu dàtná úná nduu sá dúcáⁿ nǐ cáháⁿ Jèsús, te cuásaá‑gá ɨɨⁿ yucu cáháⁿ ndɨhɨ‑gá Yǎ Ndiǒxí, te ndèca‑gá té Pèlú, ndɨhɨ té Jàcobó, ndɨhɨ té Juàá cuásaá. ");
INSERT INTO milNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Te nɨni càháⁿ ndɨhɨ‑gá Yǎ Ndiǒxí ní nadáma núú‑gǎ ndɨhɨ dóó‑gǎ, te dóó‑gǎ‑áⁿ sǔúní nǐ nduu cuìxíⁿ víhí, te súúní dàtásaⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Te òré‑ni‑áⁿ nǐ xiní‑güedé úú tnàhá cue tée càháⁿ ndɨhɨ‑gá, te ɨɨⁿ‑dé cúú‑dě té Moìsés, te ɨngá‑dé cúú‑dě té Èliás, ");
INSERT INTO milNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","te súúní dàtásaⁿ‑xi nɨ càndéé núú ndécú cuè tée úú‑áⁿ ndɨhɨ‑gá, te xǐndatnúhu‑güedé nàcuáa ndoho Jèsús cuú‑gá ñuú Jerusàlén dàtná ní cachí méé‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Te té Pèlú ndɨhɨ úú‑gá‑güedé cuìní víhí‑güedě cúdú‑güedé, dico ní sahni iní‑güedé ñá túú ní xǐdí‑güedé, te ní dánèhé núú ñáhá‑xí xìi‑güedé sá sǔúní vǎha càa núú ndécú Jèsús, ndɨhɨ úú cue tée càháⁿ ndɨhɨ‑gá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Te òré sa ndùcu ndee cue tée úú‑áⁿ caca‑güedé núhú‑güedé, te ní xáhaⁿ tě Pèlú xii‑gá: —Mèstrú, ¡váha ní cuu sá ndécú‑ó ìha vitna! Te na dàcaa‑ndɨ́ úní tnàhá vehe tnuvixiⁿ, ɨɨⁿ cuu cuèndá‑n, te ɨɨⁿ cuu cuèndá té Moìsés, te ɨɨⁿ cuu cuèndá té Èliás —càchí‑dé xǎhaⁿ‑dě xii‑gá. Dico té Pèlú chi ni mèe‑dé ñá túú ní cùtnuní iní‑dé nása ndùu tnúhu ní cáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Te nɨni càháⁿ‑dé ní quexìo ɨɨⁿ vícó nǔú ndécú‑güedě‑áⁿ nǐ dádǎhu ñaha‑xi xìi‑güedé, te ní yùhú‑güedé sá dúcáⁿ nǐ quexìo vícó‑ǎⁿ nǐ dádǎhu ñaha‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Te xɨtɨ́ vícó‑ǎⁿ nǐ tecú ní cáháⁿ Yǎ Ndiǒxí, te xáhaⁿ‑gǎ xii‑güedé: —Tée‑a cùu‑dé Déhe‑í, tée ío cùu iní‑í, te tnɨɨ‑ndo nchàa tnúhu càháⁿ‑dé —duha ní xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Te sátá dúcáⁿ nǐ cáháⁿ Yǎ Ndiǒxí, te ní quide cuèndá‑güedé sá mèdii‑ná Jèsús ndécú‑gǎ xíáⁿ. Te vá yǒo ɨɨⁿ nǐ xáhaⁿ‑güedě nàcuáa ndùu nchaa sá nǐ xiní‑güedé‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Te ɨngá nduu‑ǎⁿ cuǎnuu‑gá yucu‑áⁿ ndɨhɨ‑güedé, te ío cuéhé ñǎyiu cuáháⁿ tnahá ñáhá xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Te ɨɨⁿ tée ñùhu tnahá tnuú‑yu‑áⁿ nǐ cáháⁿ níhi‑dé, te xǎhaⁿ‑dě xii‑gá: —Mèstrú, ío càháⁿ ndàhú‑í núú‑n nǔu vá cúndèe iní‑n càda tátna‑n děhe‑í, chi ɨɨⁿdìi duha‑dé ndécú, ");
INSERT INTO milNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","te yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha xii‑dé, te òré ná nàtnɨɨ ñaha‑xi xii‑dé, te dàcana saa ñaha‑xi, te ndàda ruúⁿ ñáhá‑xí xìi‑dé, te tàva‑xi tɨ́ñú yuhu‑dé. Te ío dàndoho ñaha‑xi xii‑dé, chi ndéé núú ñà cúú‑gǎ, te dàña ñaha tnaa‑xi xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Te sa ní cáháⁿ ndàhú‑í núú cuè tée xìca cuu ndɨhɨ‑n queñuhu‑güedé‑xi, dico ñá túú ní ndàcu‑güedé —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Te Jèsús ní xáhaⁿ‑gǎ xii nchaa ñáyiu: —¡Nchaa nchòhó ñáyiu ndècu ñuyíú‑a ío sàá iní‑ndó, chi ñá túú cuìní‑ndó quɨ̀ndáá iní‑ndó Yǎ Ndiǒxí! Te ní cuu vài nduu quide ndee iní‑í nchaa sá quídé‑ndó, ¿te ná ndéé ama vá dúcáⁿ‑gǎ cada‑ndo‑i? —càchí‑gá xáhaⁿ‑gǎ xií‑yu. Te ní xáhaⁿ‑gǎ xii tée cùhú déhe‑xi‑áⁿ: —Taxi déhe‑n ìha —cachí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Te òré cuáháⁿ tée cuechi‑ǎⁿ nǔú‑gǎ, te espíritú cúndɨ̀hɨ yucu ñávǎha‑áⁿ nǐ dándùá ñáhá‑xí xìi‑dé, te sàhni yɨhɨ́ ñáhá tùcu‑xi xii‑dé ní cùu, dico Jèsús níhi ní cáháⁿ‑gá ní tenàá‑gá espíritú‑áⁿ, te ní quee ñaha‑xi xìi‑dé, te ní nacuáha cuèndá ñáhá‑gǎ xii‑dé tǎtá‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Te nchaá‑yu ní cuñúhu‑yu sá dúcáⁿ nǐ cuu, te ní cachí‑yu sá ǐo càhnu cuu Yá Ndiǒxí. Te nɨni xǐcuñúhu‑yu nàcuáa ní quide Jèsús, te ní xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá: ");
INSERT INTO milNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Nchòhó cundedóho váha‑ndo tnǔhu na càháⁿ‑í‑a, te vá ná cuànaa‑ndo, chi yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo sáá ɨɨⁿ nduu te cuáha cuèndá ñáhá‑güedě xii‑í núú cuè tée cùu úhú iní ñáhá —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Dico cue tée‑áⁿ ñà túú ní tècú tnùní‑güedé nàcuáa ndùu tnúhu ní xáhaⁿ‑gǎ xii‑güedé, te ducaⁿ nǐ yáha‑güedé, chi ducaⁿ tnàhí ní cachí‑gá sá vǎ tècú tnùní‑güedé, te ní yùhú‑güedé cácáⁿ tnúhú‑güedě núú‑gǎ nása ndùu tnúhu ní xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Te cue tée xìca cuu ndɨhɨ‑gá ní ngüíta‑güedé ndátnǔhu‑güedé nǔu ndědacàa‑güedé ío‑gá cúnùu, ");
INSERT INTO milNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","dico Jèsús ní cutnùní iní‑gá nàcuáa sàni iní‑güedé nǔu ní cana‑gá ɨɨⁿ té lǐhli, te ní sanu tnɨ́ɨ ñaha‑gǎ ɨɨⁿ xio dɨ̀ñɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Te ní xáhaⁿ‑gǎ xii‑güedé: —Nchaa ñáyiu na quèheⁿ cuendá ɨɨⁿ té lǐhli dàtná té lǐhli‑a cuèndá sá ñúhú ìní ñáhǎ‑yu xii‑í ñá, te cada iní‑yu sá yǔhú ní queheⁿ cuèndá‑yu, te nchaa ñáyiu na quèheⁿ cuendá ñáhá xìi yúhú, te cada iní‑yu sá tnàhá Tǎtà‑í Dútú Ndiǒxí Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a ní queheⁿ cuèndá‑yu. Te nchaa ñáyiu ío ndàhú iní‑xi mee‑ni xìnu cuechí‑yu, ñáyiu‑áⁿ ǐo‑gá cúnùú‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Te té Juàá dɨu‑ni ɨɨⁿ tée xìca cuu ndɨhɨ‑gá ní xáhaⁿ‑dě xii‑gá: —Mèstrú, ní xiní‑ndɨ́ ɨɨⁿ tée càcunehe ñaha‑dé xii‑n, te ndèñuhu‑dé espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu, te nchúhú ñá túú ní dàña‑gá‑ndɨ́ ducaⁿ càda‑dé, chi ñá túú xìca cuu ndɨhɨ ñaha‑dé xii‑o —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Daña‑ndo na càda nahi‑dé ní cùu, chi ñáyiu ñá túú cùu úhú iní ñáhá xìi‑o te cùndɨhɨ ñahá‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Te òré sa ta cùyatni ndaa Jesús andɨu, te ní xica‑gá cuáháⁿ‑gá ñuú Jerusàlén, chi duuⁿ duuⁿ ní sani iní‑gá sá quɨ̀hɨ́ⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Te ní tendaha‑gǎ cue tée yòdo nuu cuáháⁿ, te ní quexìo‑güedé ɨɨⁿ ñuú, te ñuú‑áⁿ yɨ́ndèhu‑xi distritú Sàmariá, te ndùcu‑güedé ɨɨⁿ vehe cada túha‑güedé òré quexìo‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Dico ñáyiu Sàmariá ñá túú ní cuìní‑yu cuáñaha nùú‑yu vehe, chi cuèndá sá nǐ cutnùní iní‑yu sá ìchi yáha‑ni‑gá quɨ́hɨ́ⁿ‑gá ñuú Jerusàlén. ");
INSERT INTO milNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Te sá dúcáⁿ nǐ quidé‑yu ñá túú ní cuìní‑yu cuáñaha nùú‑yu vehe ndetatú‑gá, núu ní xáhaⁿ tě Jàcobó ndɨhɨ té Juàá cue tée xìca cuu ndɨhɨ‑gá xii‑gá: —Mèstrú, ¿cuìní‑n càcáⁿ táhú‑ó nǔú Yǎ Ndiǒxí cuèndá dangàva‑gá ñuhú danàa‑gá ñáyiu ñuú‑a dàtná ní quide té Èliás tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha‑ǎⁿ? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Te Jèsús ní nchócótó‑gǎ núú‑güedě, te níhi ní cáháⁿ‑gá dóho‑güedé, te xáhaⁿ‑gǎ: —Nchòhó, chi ñá túú vǎha iní‑ndó te núu ducaⁿ càháⁿ‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chi yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo véxi‑í sá dácǎcu nihnu‑í ñáyiu, te ñá dɨ́ú věxi‑í sá dácuǐta nihnu‑í‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. Te sátá dúcáⁿ nǐ xáhaⁿ‑gǎ, te ní xica‑gá cuáháⁿ‑gá ndɨhɨ‑güedé ɨngá ñuú. ");
INSERT INTO milNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Te ñùhu Jesús ichi ndɨhɨ‑güedé, te ɨɨⁿ tée ní xáhaⁿ‑dě xii‑gá: —Mèstrú, cuìní‑í canchicúⁿ ñáhà‑í xii‑n nděni ní cuu na quɨ̀hɨ́ⁿ‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Nchaa ñúcuii chi ndècu yaú cúú vèhe‑güedɨ saquɨhɨ‑güedɨ, te nchaa quɨtɨ ndàva caa tacá‑güedɨ dɨ́quɨ́ yutnu, dico yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo chi ñá túú ndèé cáá vèhe‑í ñuyíú‑a ndetatú‑í —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Te dǎtnùní ní xáhaⁿ tùcu‑gá xii ɨngá‑dé: —Yòhó taquìxi chitnahá ñáhá‑n xìi‑í —càchí‑gá xáhaⁿ‑gǎ xii‑dé. Dico tée‑áⁿ nǐ xáhaⁿ‑dě xii‑gá: —Mèstrú, daña na nùhú‑í cundetu‑í cuú tǎtà‑í te chindúxi‑í‑dé, te dǎtnùní quixi‑í chitnahá ñáhá dùcaⁿ‑ná‑í xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Daña ñǎyiu ñá túú sàndáá iní ñáhá xìi‑í ná chíndǔxi tnàha meé‑yu, chi ñáyiu‑áⁿ cúǔ‑yu dàtná ñáyiu ní xíhí cuěi ndècu‑ní‑yu núú ñuyíú‑a. Te yòhó taquìxi, chi quɨ́hɨ́ⁿ‑n dànehé‑n ñǎyiu nàcuáa cada Yá Ndiǒxí ndɨ́hu ndaha ñàha‑gá xií‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Te ní xáhaⁿ tùcu ɨngá‑dé xii‑gá: —Mèstrú, cuìní‑í chitnahá ñáhà‑í xii‑n, dico díhna‑gá daña na nùhú‑í cada ndee ìní‑í nchaa ñáyiu ndècu vehe‑í, te dǎtnùní quixi‑í —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Te Jèsús ní xáhaⁿ‑gǎ: —Nchaa ñáyiu ní sándáá iní ñáhá xìi‑í, te núu vá cánchǐcúⁿ nihnu ñàhá‑yu nɨ yùhu nɨ iní‑yu, te cùú‑yu dàtná ɨɨⁿ tée ní tnɨɨ ndaha làtú cutu‑dé, chi tée‑áⁿ nǔu na ndàcoto‑dé ndàa sátá‑dě òré xítú‑dě, te vá quɨ̀hɨ́ⁿ ndáá làtú‑dé ducaⁿ sǎtnahá‑xi cùú‑yu. Te cue ñáyiu chi vá cúú ndǎá‑yu nàcuáa ndɨ́hu ndaha‑gá dava‑gá ñáyiu— càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Te sátá dúcáⁿ nǐ cuu, te ní cáxi tucu Xítohó Jesucrìstú únídico úxí cue tée codonùu‑güedé quɨ́hɨ́ⁿ‑güedé cáháⁿ‑güedé tnúhu‑gá nchaa ñuú, ndɨhɨ nchaa dava‑gá xichi núú quɨ̌hɨ́ⁿ‑gá, te ndɨ ndúú ndɨ ndúú‑güedě tendaha ñàha‑gá xii‑güedé quɨ́hɨ́ⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Te cùmání‑gǎ caca‑güedé, te ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó xìní‑ndó sǎ òré ná sàá yóó cuu nchaa sá xítú ñǎyiu, te ío vài cuu. Te na càchí tnúhu ndáá‑í xii‑ndo sǎ dàtná vài sá xítú ñǎyiu cùu, ducaⁿ ǐo vài ñáyiu cùmání cundedóho tnúhu Yá Ndiǒxí te ío sacú ñáyiu dàcuaha ñaha xií‑yu tnúhu‑gá, núu xíǎⁿ xíní ñùhu‑xi cácáⁿ‑ndó nǔú Yǎ Ndiǒxí cuèndá sá ná dàcaháⁿ‑gá iní ñáyiu cáháⁿ‑yu tnúhu‑gá núú ñǎyiu cùmání cundedóho tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Te nchòhó cúú‑ndó dàtná cue mběé cue quɨtɨ cuáháⁿ núú yɨ́hɨ́ cuè quɨtɨ dééⁿ. Chi tendaha ñaha‑ǐ xii‑ndo quɨ̌hɨ́ⁿ‑ndó nǔú xǐndecu nchaa ñáyiu cuihna ìní‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Te vá cánèhe‑ndo ñunu cuhuⁿ ndachiuⁿ‑ndo, ni nǔú cúhúⁿ dǐhúⁿ‑ndó, te ni vǎ cádá tǔha‑gá‑ndó chàú‑ndó chi dɨu‑ni chàú yɨ́hɨ́‑ndó‑ǎⁿ xíǎⁿ‑ni quɨhɨ‑ndo, te vá ǐo cuyaa‑ndo cǎháⁿ ndɨhɨ‑ndo ñǎyiu ñùhu ichi. ");
INSERT INTO milNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Te òré ná quèxio‑ndo ɨɨⁿ vehe, te duha cúñaha‑ndo xìi ñáyiu dii vèhe‑xi‑áⁿ: “Yá Ndiǒxí chindee ñàha‑gá xii‑ndo ǐo váha cuu iní‑ndó cùndecu‑ndo”, duha cúñaha‑ndo xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Te núu ñáyiu‑áⁿ nǐ nduu táhǔ‑yu sá cúndècu váha iní‑yu núú Yǎ Ndiǒxí, te cuu‑xi sá vǎha sá cúú‑xǐ‑yu tnúhu cúñaha‑ndo‑ǎⁿ, dico núu ñá túú ní càháⁿ váha ndɨhɨ ñàhá‑yu xii‑ndo, te cúñaha‑ndo sǎ vǎ cúú‑xí sǎ vǎha sá cúú‑xǐ‑yu. Dico núu ní cáháⁿ váha ndɨhɨ ñàhá‑yu xii‑ndo, ");
INSERT INTO milNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","te dɨu‑ni vehe‑áⁿ cada vehe tnaa‑ndo, te ñá túú‑gǎ ndèé nducu‑ndo vèhe cundecu‑ndo, te caxi‑ndo nchàa sá ná tàxí‑yu, chi nchaa cue tée quìde chiuⁿ dacuɨtɨ́í tàú‑güedé sá nìhí‑güedé sá cáxí‑güedě cuèndá nchaa chìuⁿ quide‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Te núu ní sáá‑ndó ɨ̀ɨⁿ ñuú núú nǐ queheⁿ cuèndá ñáhǎ‑yu xii‑ndo, te caxi‑ndo nchàa sá ná tàxí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Te cada tátna‑ndo cuè ñáyiu cùhú xǐndecu ñuú‑áⁿ, te cúñaha‑ndo xìí‑yu sá sà ní sáá nduu ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Dico núu ní sáá‑ndó ɨ̀ɨⁿ ñuú núú ñà túú ní quèheⁿ cuendá ñáhǎ‑yu xii‑ndo, te tnɨɨ‑ndo ìchi cuita cáháⁿ‑ndó cuǎháⁿ, te cúñaha‑ndo xìí‑yu: ");
INSERT INTO milNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ndéé tɨ́cá chúhmá nǐ tnɨ́ɨ sáhá‑ndɨ̌ ñuú‑ndó nàquɨdɨ‑ndɨ́, te duha quìde‑ndɨ́ cuèndá cutnùní iní‑ndó sǎ ñà túú quìde váha‑ndo ndècu‑ndo. Dico cunaha‑ndo sǎ sà ní sáá nduu ndɨ́hu ndaha ñàha Yá Ndiǒxí xii‑ndo ni cùu”, duha cúñaha‑ndo xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Te na càchí tnúhu‑í xii‑ndo sǎ ná sàá nduu càda ndáá Yǎ Ndiǒxí cuéchi nchaa ñáyiu, te ñáyiu ñuú‑áⁿ ǐo‑gá ndohó‑yu dàvá‑áⁿ dàcúúxí ñǎyiu ñuú Sòdomá —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Te Jèsús xáhaⁿ‑gǎ xii ñáyiu dava ñuú ñá túú sàndáá iní tnúhu‑gá: —¡Ndàhú nchòhó cue ñáyiu ñuú Coràzín! ¡Te ndàhú nchòhó cue ñáyiu ñuú Bètsaidá! Chi núu dìcó ñuú Tìrú, ndɨhɨ ñuú Sìdón ní quìde‑í nchaa sá vǎ yǒo tnàhí ndàcu cada datná ní quide‑í ñuú‑ndó‑áⁿ nǐ xiní‑ndó ñá, te sá nděé ama‑gá cuihnú‑yu dóó ndàhú, te cunucóo‑yu núú yàá cuèndá sá ndíxí cuěchi iní‑yu sá ñà túú quìde váha‑yu ni cùu. ");
INSERT INTO milNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Dico sáá nduu te ío‑gá dandòho ñaha Yá Ndiǒxí xii‑ndo dàcúúxí ñǎyiu ñuú Tìrú, ndɨhɨ ñáyiu ñuú Sìdón. ");
INSERT INTO milNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Te nchòhó ñáyiu ñuú Capèrnaúm quìde iní‑ndó sǎ sà cuándaa‑ndo àndɨu, dico ñáhá chi núú ùhú núú ndàhú cundecu‑ndo —duha ní xáhaⁿ‑gǎ xii nchaa ñáyiu ñuú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Te xǎhaⁿ tùcu‑gá xii cue tée tendaha‑gǎ quɨ́hɨ́ⁿ cáháⁿ tnúhu‑gá‑áⁿ: —Nchaa ñáyiu na cùndedóho nchaa tnúhu cáháⁿ‑ndó, te cada iní‑yu sá yǔhú càháⁿ‑í ndèdóho‑yu, te nchaa ñáyiu na dàquee tɨhú ñáhá xìi‑ndo, te tnàhá yúhú daquèe tɨ́hǔ‑yu, te nchaa ñáyiu ducaⁿ na dàquee tɨ́hú ñáhá xìi‑í, te tnàhá Tǎtà‑í Dútú Ndiǒxí Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a dàquee tɨ́hǔ‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. Te ducaⁿ te ní xica‑güedé cuáháⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Te cue tée únídico úxí‑áⁿ nǐ nasáá‑güedé te súúní cùdɨ́ɨ́ ìní‑güedé, te xǎhaⁿ‑güedě xii Jèsús: —Mèstrú, ndéé espíritú cúndɨ̀hɨ yucu ñávǎha sàndáá iní ñáhá‑xí xìi‑ndɨ́ òré cácú nèhe ñaha‑ndɨ́ xii‑n —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Te Jèsús ní xáhaⁿ‑gǎ: —Ndáá càháⁿ‑ndó chi yúhú ní xiní‑í cútnàhá ní xíta nihnu yucu ñǎvǎha, chi dàtná ní ngava ɨɨⁿ tasaⁿ nǐ ngava‑xi ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Te dàtná quídé‑ndó òré xěnihnu‑ndo ɨ̀ɨⁿ cóó, àdi ɨɨⁿ nchacua ducaⁿ cada‑ndo daquee tɨ́hú‑ndó yùcu ñávǎha, te ñá túú nǎ cada ñaha‑xi xìi‑ndo, chi ní taxi‑í tnúhu ndee ìní ndécú ndɨ̀hɨ‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Dico vá cúdɨ̌ɨ́ ìní‑ndó cuèndá sá sàndáá iní ñáhá cuè espíritú cúndɨ̀hɨ yucu ñávǎha xii‑ndo, chi cudɨ́ɨ́ ìní‑ndó cuèndá sá sà yodo tnuní‑ndó nǔú tùtú Yǎ Ndiǒxí Yaá ndécú àndɨu —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Te òré‑áⁿ sǔúní nǐ quide dɨ́ɨ́ ìní ñáhá Espíritú Yǎ Ndiǒxí xii Jèsús, te ní xáhaⁿ‑gǎ xii Yá Ndiǒxí: —Yòhó Tǎtà‑í Dútú Ndiǒxí, ío chìñuhu ñaha‑í xii‑n chi dɨu‑n tàxi tnuní‑n àndɨu ndɨhɨ ñuyíú‑a, te dànehé‑n cuè ñáyiu nchaa tnúhu váha, te dɨu‑ni ñáyiu‑áⁿ cúǔ‑yu ñáyiu ñá túú cùtnuní iní‑xi nchaa tnúhu càháⁿ cue tée túha, te nchaa tnúhu càháⁿ‑n‑ǎⁿ ñà túú ní dàtúu‑n nǔú ñǎyiu càchí sá ǐo túha, te ío váha sàá dɨ́quɨ́‑xi. Te ducaⁿ quìde‑n, chi ducaⁿ cuìní‑n cùnduu —cachí‑gá xáhaⁿ‑gǎ xii Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Te xǎhaⁿ tùcu‑gá xii cue tée ní nasáá‑áⁿ: —Mee Tǎtà‑í Dútú Ndiǒxí ní cachí‑gá sá cúnùu‑í núú nchàa‑ndɨ túhú sá ìó. Te vá yǒo ɨɨⁿ xìní nàcuáa sàni iní yúhú Déhe Dútú Ndiǒxí, chi ɨɨⁿdìi díí‑ni mee‑gǎ xìní‑gá nàcuáa sàni iní‑í. Te ducaⁿ ɨ̀ɨⁿdii‑ni yúhú xìní‑í nàcuáa sàni iní méé‑gǎ, te nchaa ñáyiu càchí iní‑í sá quìní‑yu nàcuáa sàni iní Tǎtà‑í Dútú Ndiǒxí te xǐtnǔhu‑í‑yu, te vá yǒo ɨɨⁿ‑gá xìní nàcuáa sàni iní‑gá chi dɨu‑ni ñáyiu ducaⁿ xǐtnǔhu‑í‑áⁿ xìní‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Te ní nchócótó‑gǎ núú xǐndecu mee‑ni cuè tée xìca cuu ndɨhɨ‑gá, te ní xáhaⁿ‑gǎ xii‑güedé: —Váha táhú nchòhó ndɨhɨ nchaa ñáyiu ndèhe nchaa nacuáa quìde‑í vitna. ");
INSERT INTO milNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Chi ío cuéhé cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, ndɨhɨ cue tée ní xɨ́ndaha ñàha xii ñáyiu ní cuiní‑güedé cundehe‑güedě nchaa sá ndéhé‑ndó quìde‑í vitna, te ñá túú ní xìní‑güedé, te ní cuiní‑güedé cundedóho‑güedé nchaa tnúhu càháⁿ‑í ndèdóho‑ndo vìtna, te ñá túú ní xǐndedóho‑güedé —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Te ɨɨⁿ tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés ní ndacuɨ́ñɨ́‑dé xító ndèé‑dé Jèsús nǔu nása cunduu tnúhu cáháⁿ‑gá, te xǎhaⁿ‑dě xii‑gá: —Mèstrú, ¿ná cúú sǎ cádà‑í cuèndá nduu táhù‑í cundecu‑í ndɨhɨ Yá Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ‑i? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Cuìní‑í cachí tnúhu‑n nǎsa càháⁿ‑xi núú tùtú ndíi Moìsés —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Te xǎhaⁿ‑dě xii‑gá: —Ndíi Moìsés càchí ndíi núú tùtú ndíi: “Cuu iní‑ndó Dǔtú Ndiǒxí Yaá cúú Ndiǒxí‑ndó nɨ̀ yuhu nɨ iní‑ndó, te cani iní‑ndó càda‑ndo datná cuìní méé‑gǎ, te mee‑ni tnǔhu váha cani iní‑ndó nàcuáa cuu vii cuu váha‑ndo nǔú‑gǎ, te coo iní‑ndó cùu iní‑ndó‑gǎ. Te cuu iní‑ndó tnàha ñáyiu‑ndo dàtná cúú ìní‑ndó mèe‑ndo”, duha càchí ndíi núú tùtú ndíi —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Te Jèsús ní xáhaⁿ‑gǎ: —Váha‑ni càháⁿ‑n, te núu cada‑n nàcuáa càháⁿ‑n ǎⁿ, te nduu táhú‑n cùndecu‑n ndɨhɨ Yá Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Te sá dúcáⁿ nǐ xáhaⁿ Jèsús xii‑dé nǔu ndùcu‑dé nàcuáa cada‑dé cácu nihnu‑dé núú tnǔhu ní cáháⁿ‑dé, te ní xícáⁿ tnúhú‑dě núú‑gǎ, te xǎhaⁿ‑dě: —¿Yoo cùu tnaha ñáyiu‑í‑i? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Te Jèsús ní cani‑gá ɨɨⁿ cuèndú núú‑dě nàcuáa tecú tnùní‑dé tnúhu‑gá, te xáhaⁿ‑gǎ: —Ɨɨⁿ tée ní ndee‑dé ñuú Jerusàlén ñúhú‑dě ichi cuánuu‑dé cuáháⁿ‑dé ñuú Jerìcó, te ní quee ñadúhú ichi‑dé ní dúhú‑güedě dóó níhnú‑dě, ndɨhɨ nchaa sá néhé‑dě, te ní caniha vìhi‑güedé, te nchìto dɨu‑ná‑dé ní dáñá ñàha‑güedé te cuáháⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Te mei òré cátùu‑dé‑áⁿ ñúhú ɨ̀ɨⁿ dútú ichi‑áⁿ, te òré ní xiní ñáhá dǔtú‑ǎⁿ xii‑dé, te ɨɨⁿ xio‑ni ní xócǒo ndee‑dé ní yáha‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Te ñùhu tucu ɨɨⁿ tée cùu levítá ichi‑áⁿ, te òré ní xiní‑dé tée‑áⁿ cátùu‑dé, te dɨu‑ni ducaⁿ nǐ quide‑dé ɨɨⁿ xio‑ni ní xócǒo ndee‑dé ní yáha‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Dico ɨɨⁿ tée distrìtú Sàmariá ñúhú tùcu‑dé ichi‑áⁿ te òré ní xiní‑dé tée‑áⁿ cátùu‑dé, te ní cundàhú iní ñáhá‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Te ní sáháⁿ‑dé núú cátùu tée‑áⁿ, te ní quide tátna‑dé nchaa núú nǐ nícuèhé xii tée‑áⁿ nǐ chihi‑dé yúcú, te ní dácútú‑dě. Te dǎtnùní ní dácáá ñàha‑dé sátá quɨtɨ‑dé, te ndèca ñaha‑dé cuáháⁿ ɨɨⁿ vehe núú sácǒo cue ñáyiu sàcúhuⁿ ichi, te yàcáⁿ ní xito ñaha‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Te ɨngá nduu òré ní nucúhuⁿ tée Samaritànú‑áⁿ ichi, te ní tava‑dé úú díhúⁿ denàriú, te ní sáha‑dé tée cùu xítohó vehe‑áⁿ, te ní xáhaⁿ‑dě: “Coto saú‑n těe‑a, te núu ñá ní tnàhá díhúⁿ sǎ nǐ taxi‑í, te cuěi na dàndoñuhu‑gá‑n dǐhúⁿ‑n cuèndá‑dé, te òré ná quìxi tucu‑í te nacháhu‑í”, duha ní xáhaⁿ těe Samaritànú‑áⁿ xii tée dii vèhe xíáⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Te vitna cáháⁿ, te núu ndědacàa cue tée úní‑áⁿ cúú‑güedě tée váha cùu iní‑güedé tnàha ñáyiu‑güedé —càchí‑gá xáhaⁿ‑gǎ xii tée dàcuaha ñaha xii‑í ñáyiu‑áⁿ nchaa tnúhu ní chídó tnùní ndíi Moìsés. ");
INSERT INTO milNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Te tée‑áⁿ nǐ xáhaⁿ‑dě xii‑gá: —Tée ní cundàhú iní ñáhá xìi tée ní dánǐcuèhé ñáhá cuè ñadúhú‑ǎⁿ, tée‑áⁿ cúú‑dě tée cùu iní tnàha ñáyiu‑xi —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ: —Cuàháⁿ te dɨu‑ni ducaⁿ càda‑n tnahá‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Te Jèsús ñúhú‑ni‑gǎ ichi cuáháⁿ‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, te ní sáá‑gá ɨɨⁿ ñuú lǐhli, te xíáⁿ nǐ quee ɨɨⁿ xíchí nání Mǎrta ní cáháⁿ ñáhá‑xí xìi‑gá vehe‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Te tá Mǎrta ndècu ɨɨⁿ cúhú‑xi nàni‑xi Mariá, te xíchí‑ǎⁿ nǐ ngóo‑xi núú Jèsús ndèdóho‑xi nchaa tnúhu càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Te tá Mǎrta‑áⁿ ndɨ̌hɨ vìhi‑ni iní‑xi quìde‑xi chiuⁿ‑xi, te ní sáháⁿ‑xi núú Jèsús, te ní xáhaⁿ‑xi: —Mèstrú, ¿náa ñá túú tnàhí sàni iní‑n sǎ nǐ dándǒo ndaha ñàha cúhù‑í nchaa chìuⁿ‑áⁿ? Cúñaha sàú ná quìxi‑xi chindee ñaha‑xi —cachí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dico Jèsús ní xáhaⁿ‑gǎ: —Yòhó Mǎrta, ñùhu tneñu vihi‑n, te ndɨ̀hú iní‑n sǎ ǐo vài chiuⁿ‑n ñuhu, ");
INSERT INTO milNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","dico xìni ñuhu vihi‑gá‑xi cundedóho‑n tnǔhu càháⁿ‑í, chi tá Màriá‑a sa ndèdóho‑xi tnúhu‑í, te vá yǒo ɨɨⁿ ndacu xocàni tnúhu‑í sá nǐ ngúndecu ndɨhɨ‑xi —càchí‑gá xáhaⁿ‑gǎ xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Te ɨɨⁿ nduu càháⁿ ndɨhɨ Jèsús Yǎ Ndiǒxí ɨɨⁿ xichi, te sátá nǐ yáha ní cáháⁿ ndɨhɨ‑gá Yǎ Ndiǒxí, te ní xáhaⁿ ɨ̀ɨⁿ tée xìca cuu ndɨhɨ‑gá xii‑gá: —Mèstrú, danèhé ñáhá xìi‑ndɨ́ nása cáháⁿ ndɨhɨ‑ndɨ́ Yǎ Ndiǒxí dàtná ní quide ndíi Juàá ní dánèhé ndíi cue tée ní xica cuu ndɨhɨ ndíi —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Te Jèsús ní xáhaⁿ‑gǎ: —Òré cáháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí, te cachí‑ndó: Yòhó tǎtá‑ndɨ̌ Dútú Ndiǒxí Yaá ndécú àndɨu, nchaa ñáyiu na càháⁿ‑yu sá cúú‑n Yàá ío yɨñùhu. Te xìcáⁿ táhú‑ndɨ̌ núú‑n sǎ ná sàá nduu ndɨ́hu ndàhá‑n‑yu. Te cada‑n dàtná càchí iní‑n ñùyíú‑a dàtná quídé‑n àndɨu. ");
INSERT INTO milNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Te xìcáⁿ táhú‑ndɨ̌ núú‑n sǎ táxí‑n sǎ cándèca iní‑ndɨ́ ɨɨⁿ nduu ɨɨⁿ nduu. ");
INSERT INTO milNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Te cada càhnu iní‑n nchàa yícá cuěchi‑ndɨ́, chi tnàhá nchúhú quídé càhnu iní‑ndɨ́ nchaa sá quídé ñàha tnaha ñáyiu‑ndɨ́. Te vá dáñá‑n dàcaháⁿ ñáhá yùcu ñávǎha xii‑ndɨ́ cada‑ndɨ́ sá ñà túú vǎha, chi coto ñaha‑n xìi‑ndɨ́ cuèndá sá vǎ dúcáⁿ càda ñaha‑xi, duha cáháⁿ‑ndó —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Te Jèsús ní xáhaⁿ tùcu‑gá: —Te núu ndědacàa nchohó ndécú ɨ̀ɨⁿ tée tnàha tnúhu ndɨhɨ‑ndo, te dava niú cuáháⁿ‑ndó vèhe‑dé, te òré ní quexìo‑ndo, te xǎhaⁿ‑ndo xìi‑dé: “Véxi‑í nǔu vá cúndèe iní‑n tàxi nuu‑n úní tnàhá pàá, ");
INSERT INTO milNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","chi ɨɨⁿ tée xìní tnáhá ndɨ̀hɨ‑í ñúhú‑dě ichi ní quexìo‑dé vehe‑í, te ñá túú tnàhí ná cuáñaha‑ǐ caxi‑dé”, quesaha‑ndo cǔñaha‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Te tée‑áⁿ cǎháⁿ‑dé ndéé xɨtɨ́ vehe‑dé, te cúñaha‑dě xii‑ndo: “Vá dásàtú nihá‑n chi ndèdɨ́ yuyèhe‑í, te càa‑í ndɨhɨ cue landú‑í, te vá cúú ndàcóo‑í taxi‑í sá cuìní‑n”, quesaha‑dě cúñaha‑dě xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Te na càchí tnúhu‑í xii‑ndo sǎ cuěi cùu‑dé tée tnàha tnúhu ndɨhɨ‑ndo, dico ducaⁿ cǔñaha‑dě xii‑ndo, dico dacuɨtɨ́í sǎ ndácǒo‑dé taxi‑dé sá cuìní‑ndó cuèndá sá vǎ dásàtú‑gá‑ndó ìní‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Te yúhú càchí‑í xii‑ndo sǎ cǎcáⁿ‑ndó nǔu ná cuìní‑ndó nǔú Yǎ Ndiǒxí te taxi‑gá. Te vá dáñá ndèé‑ndó cǎcáⁿ‑ndó nǔú‑gǎ nǔu ná cuìní‑ndó, te ducaⁿ te níhí‑ndó. Te cada iní‑ndó sǎ nǐ quexìo‑ndo vehe ɨɨⁿ tnaha ñáyiu‑ndo te ní cáháⁿ‑ndó, te ñáyiu‑áⁿ nǐ tedóho ñàhá‑yu xii‑ndo te ní nacaáⁿ‑yu yuyèhe. Te ducaⁿ càda iní‑ndó chi Yá Ndiǒxí tedóho ñaha‑gǎ xii‑ndo, te taxi‑gá sá ná càcáⁿ‑ndó nǔú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chi nchaa ñáyiu ducaⁿ xǐquide te Yá Ndiǒxí tédǒho ñaha‑gǎ xií‑yu nìhí‑yu sá cuìní‑yu. Te dɨu‑ni ducaⁿ tùcu nchaa ñáyiu na càcáⁿ núú‑gǎ ɨɨⁿ sá cuìní‑yu, chi sǎñaha‑gǎ sá xìcáⁿ‑yu núú‑gǎ. Te dɨu‑ni ducaⁿ tùcu níhí nchaa ñáyiu ñá túú dàña ndeé xìcáⁿ núú Yǎ Ndiǒxí sá cuìní‑yu, chi nìhí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Te nchòhó cue tée cùu tátá ñá túú cùndee iní‑ndó cuǎha‑ndo cuè déhe‑ndo ɨ̀ɨⁿ yúú caxi‑güexi òré xìcáⁿ‑güexi ɨɨⁿ pàá núú‑ndó càxi‑güexi, te ni ñà túú cùndee iní‑ndó cuǎñaha‑ndo ɨ̀ɨⁿ cóó caxi‑güexi òré xìcáⁿ‑güexi ɨɨⁿ chácá nǔú‑ndó càxi‑güexi. ");
INSERT INTO milNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Te ni ñà túú cùndee iní‑ndó cuǎñaha‑ndo ɨ̀ɨⁿ nchacua caxi‑güexi oré xìcáⁿ‑güexi ɨɨⁿ ndɨ́ú nǔú‑ndó càxi‑güexi. ");
INSERT INTO milNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Te nchòhó cuěi ndèé dau sàá iní‑ndó, dico sǎha‑ndo cuè déhe‑ndo sǎ vǎha xèxi‑güexi oré xìcáⁿ‑güexi núú‑ndó. Te núu nchòhó ducaⁿ quìde‑ndo, ¡te uuⁿ‑gá ducaⁿ quìde Tátá‑ndó Dǔtú Ndiǒxí Yaá ndécú àndɨu, chi taxi‑gá Espíritú‑gá cundecu ndɨhɨ‑ndo te núu na càcáⁿ‑ndó nǔú‑gǎ! —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Te Jèsús ndéñùhu‑gá espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ɨɨⁿ tée ní quide ñɨ̀hɨ́‑xi, te òré ní ndee ñaha espíritú‑áⁿ xii tée‑áⁿ, te ní nacáháⁿ‑dé. Te ío ní cuñúhu ñáyiu sá dúcáⁿ nǐ quide‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Te davá‑yu ní xítnàhá‑yu: —Tée‑a ndèñuhu‑dé nchaa espíritú cúndɨ̀hɨ sácuíhná yɨ́hɨ́ ñàha xii ñáyiu, chi dɨu‑ni sácuíhná‑ǎⁿ chíndèe ñaha‑xi xii‑dé, te dɨu‑ni‑xi tàxi tnuní‑xi nchaa espíritú‑áⁿ —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Te davá‑yu xìto ndeé ñáhǎ‑yu xii‑gá, te xǎhǎⁿ‑yu sá ná cádá‑gǎ ɨɨⁿ sá vǎ yǒo tnàhí ndàcu cada ñuyíú‑a cundèhé‑yu nàcuáa cutnùní iní‑yu núu ndáá sá Yǎ Ndiǒxí ní tendaha ñàha‑gá xii‑gá véxi‑gá ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Dico mee‑gǎ sa ní cutnùní iní‑gá nchaa nàcuáa sàni iní‑yu, núu ní xáhaⁿ‑gǎ xií‑yu: —Te nchòhó xìní‑ndó sǎ nǔu ɨɨⁿ tée yɨ̀ndaha ɨɨⁿ nacióⁿ vá cúú ɨ̀ɨⁿnuu‑dé ndɨhɨ cue tée cùndɨhɨ‑dé, te vá cúdǐi‑dé cunuu‑dě. Te dɨu‑ni ducaⁿ sǎtnahá tucu‑xi cùu cue ñáyiu xǐndecu ɨɨⁿ‑ni vèhe, chi núu vá cúú ɨ̀ɨⁿnuú‑yu cundecú‑yu, te vá cúdǐi‑yu cundecu càhnú‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Te ducaⁿ sǎtnahá‑xi cùu sácuíhná, chi núu vá cúú ɨ̀ɨⁿnuu‑xi ndɨhɨ nchaa espíritú cúndɨ̀hɨ‑xi te vá cúdǐi‑xi cundecu‑xi taxi tnùní‑xi. Te duha càháⁿ‑í chi nchòhó càchí‑ndó sǎ sàcuíhná chíndèe ñaha‑xi xii‑í quéñùhu‑í nchaa espíritú cúndɨ̀hɨ‑xi yɨhɨ ñaha xii ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Te núu yúhú quídé cuèndá‑ndó sǎ sàcuíhná chíndèe ñaha‑xi xii‑í, te xìni ñuhu‑xi cada cuendá‑ndó yòo chindee ñaha xii cue tée xìca cuu ndɨhɨ‑ndo queñuhu‑güedé nchaa espíritú cúndɨ̀hɨ‑xi yɨhɨ ñaha xii ñáyiu. Te mee‑güedě càchí‑güedé sá nchòhó ñá túú càháⁿ ndáá‑ndó sǎ dúcáⁿ càháⁿ‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Te ndáá sá Yǎ Ndiǒxí chíndèe ñaha‑gá xii‑í quéñùhu‑í nchaa espíritú cúndɨ̀hɨ sácuíhná yɨ́hɨ́ ñàha xii ñáyiu, te xíǎⁿ cutnùní iní‑ndó sǎ sà ní sáá nduu ndɨ́hu ndaha ñàha Yá Ndiǒxí xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Te núu ɨɨⁿ tée ío ndee, te súúní ñɨ̀ɨ́ cáá‑dě, te ndèé‑dé vehe‑dé cuèndá sá vǎ cuǐta, te ní quide túha‑dé tɨtnɨ́ sá děéⁿ, te ío váha nèhe váha‑dé nchaa ndachìuⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Dico núu quexìo ɨngá tée ío‑gá ñɨɨ́ cáá te ndee‑gǎ‑dé, te ngüíta‑dé nàá‑dé ndɨhɨ tée ndèé vehe‑xi‑áⁿ, te cada cànárí ñáhá těe‑áⁿ xii tée ndèé vehe‑xi‑áⁿ, te quendeé‑dé nchaa sá děéⁿ cúndèe iní‑dé, te taxi tnùní‑na‑dé nchaa xíǎⁿ, ndɨhɨ nchaa sá ndécú ndɨ̀hɨ‑dé, te dàcáhñu‑dé nchaa cue tée cùndɨhɨ‑dé nchaa sá ná nìhí‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Te nchaa ñáyiu ñá túú cùndɨhɨ ñaha xii‑í, te cùu úhú iní ñáhǎ‑yu, te nchaa ñáyiu ñá túú chìndee ñaha xii‑í, te dàquee tɨ́hǔ‑yu chìuⁿ quide‑í. ");
INSERT INTO milNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Te òré ná quèe ñaha ɨɨⁿ espíritú cúndɨ̀hɨ yucu ñávǎha xii ɨɨⁿ ñáyiu, te cuáháⁿ‑xi ndùcu‑xi ɨɨⁿ xichi núú cúndècu‑xi te ñá nìhí‑xi, te ní sani iní‑xi: “Váha‑gá núhú tucu‑í núú nǐ xíndecu‑í”, duha ní sani iní‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Te cuánuhú‑xi, te òré ní nasáá‑xi, te ní xiní‑xi sá cáá ìní ñáyiu‑áⁿ dàtná cáá‑nǎ ɨɨⁿ vehe ní natɨ́hú, chi ní nduu vii‑ná, vá yǒo‑gá ndécú. ");
INSERT INTO milNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Te sátá dúcáⁿ te ní xica‑xi cuáháⁿ‑xi cuándúcú‑xí ǔsá tnàhá espíritú cúndɨ̀hɨ‑xi sá nèhé víhí‑gǎ xǐquide, te òré ní níhí‑xi cue espíritú‑áⁿ te ndèca ñaha‑xi cuáháⁿ cuèndá ngúndecu ndɨhɨ‑xi ñáyiu‑áⁿ, te ñáyiu‑áⁿ uuⁿ‑gá nándɨ yáha‑yu dàcúúxí ndèé díhna —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Te nɨni càháⁿ Jèsús tnúhu‑áⁿ nǔú ñǎyiu ní cáháⁿ níhi ɨɨⁿ ñadɨ̀hɨ́ tnuú‑yu, te xǎhaⁿ‑aⁿ xìi Jesús: —¡Sá vǎha táhú ñadɨ̀hɨ́ ní dácácú ñàha xii‑n, te ní dácuéhnú ñàha‑aⁿ! —cachí‑aⁿ xǎhaⁿ‑aⁿ xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Te Jèsús ní xáhaⁿ‑gǎ: —¡Váha‑gá táhú nchàa ñáyiu sàcúndedóho nchaa tnúhu càháⁿ Yǎ Ndiǒxí te sàndáá iní‑yu! —càchí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Te ta tàcá vài ñáyiu te dàdehnde tnaha‑ná‑yu, te ní ngüíta Jèsús xáhaⁿ‑gǎ xií‑yu: —Nchòhó ñáyiu ndècu ñuyíú vitna, chi ío sàá iní‑ndó, te cuìní‑ndó càda‑í ɨɨⁿ sá vǎ yǒo tnàhí ndàcu cada cuendá cuìní‑ndó cùtnuní iní‑ndó nǔu ndisa sá Yǎ Ndiǒxí ní tendaha ñàha‑gá xii‑í véxi‑í. Dico ñá túú nǎgá cada‑í quiní‑ndó, chi sa nìhí‑ndó tnǔhu nàcuáa ní yáha ndíi Jònás tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, te dɨu‑ni ducaⁿ yǎha yúhú tucu. ");
INSERT INTO milNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Chi nchaa ñáyiu ñuú Nǐnivé ní cutnùní iní‑yu sá Yǎ Ndiǒxí ní tendaha ñàha‑gá xii ndíi Jònás ní sáháⁿ ndíi ñuú‑yu. Te ducaⁿ sǎtnahá‑xi cùu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, chi sáá nduu te cutnùní iní‑ndó sǎ Yǎ Ndiǒxí ní tendaha ñàha‑gá xii‑í véxi‑í ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Te na sàá nduu càda ndáá Yǎ Ndiǒxí cuéchi nchaa nchòhó ñáyiu ndècu ñuyíú‑a, te dàvá‑áⁿ quiní‑ndó ɨ̀ɨⁿ ñadɨhɨ́ ñaha ní xɨ́ndaha ɨ̀ɨⁿ nacióⁿ cáá ndàa xio cuha núú quéné nchǐcanchii. Te ñaha‑áⁿ ǐo xica nǐ xíndecu‑aⁿ, te ní sáháⁿ‑aⁿ ní xíndedóho‑aⁿ nchaa tnúhu ní cáháⁿ ndíi Salòmón, chi ndíi‑áⁿ ǐo ní sáá sá xìní tnùní ndíi. Te ñaha‑áⁿ cǎháⁿ‑aⁿ dàvá‑áⁿ sǎ nchòhó ñáyiu ndècu vitna ñá túú ní quìde ndáá‑ndó. Dico vitna iha ndècu ndɨhɨ ñaha‑ndo xii yúhú, te dɨu‑í ío‑gá cúnùu‑í dàcúúxí ndǐi Salòmón. ");
INSERT INTO milNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Te dɨu‑ni nduu càda ndáá Yǎ Ndiǒxí cuéchi nchaa nchòhó ñáyiu ndècu ñuyíú‑a vitna, dàvá‑áⁿ tnàhá cue ñáyiu ní xíndecu ñuú Nǐnivé cundecú‑yu núú Yǎ Ndiǒxí, te tnàhá‑yu cachí‑yu sá ñà túú ní quìde ndáá‑ndó. Chi ñáyiu ñuú Nǐnivé‑áⁿ nǐ ndixi túu iní‑yu sá ñà túú quìde váha‑yu ndècú‑yu te ní natuhá‑yu ichi Yá Ndiǒxí cútnàhá ní cáháⁿ ndɨhɨ ñaha ndíi Jònás tnúhu‑gá xií‑yu. Dico vitna iha ndècu ndɨhɨ ñaha‑ndo xii yúhú tée càháⁿ tucu tnúhu Yá Ndiǒxí, te dɨu‑í ío‑gá cúnùu‑í dàcúúxí ndǐi Jònás. ");
INSERT INTO milNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Te ñá túú nì ɨɨⁿ ñáyiu tèñuhú ɨɨⁿ lìntérná, te taxi ndecú‑yu ɨɨⁿ núú yɨ́dǎhu, àdi chiváha‑yu xɨtɨ́ ɨɨⁿ tɨ́dihi, chi tàxi ndecú‑yu ɨɨⁿ núú nǐnu cuèndá nchaa ñáyiu quɨ́hu vehe cutnùní núǔ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Te núú‑ndó cùu‑xi datná ɨɨⁿ ñuhú, chi ɨɨⁿ sá ná quìní‑ndó te ndìxi túu iní‑ndó nǎ cúú xǐǎⁿ, te núu càváha núú‑ndó, te ducaⁿ cùtnuní iní‑ndó nǎ cúú sǎ ndécú nǔú‑ndó, áⁿ te núu cùhú, te vá cútnùní iní‑ndó nǎ cúú sǎ ndécú nǔú‑ndó. Te sá dúcáⁿ cùhú núú‑ndó te cada iní‑ndó sǎ ndécú‑ndó dàtná ɨɨⁿ núú néé. ");
INSERT INTO milNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Te ío cada cuèndá‑ndó vǎ cání cuèhé iní‑ndó cuèndá tnúhu Yá Ndiǒxí cuèndá cutnùní iní‑ndó nàcuáa cundecu‑ndo, chi núu na càni cuehé iní‑ndó cuèndá tnúhu‑gá, te cùu‑ndo datná ɨɨⁿ ñáyiu ñá túú cùtnuní núú‑xí. ");
INSERT INTO milNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Te núu càndoo canine iní‑ndó, te mee‑ni sǎ vǎha ñùhu iní‑ndó, te cùtnuní váha iní‑ndó tnǔhu ndáá dàtná cútnùní váha núú‑ndó òré càyú ñuhú, ducaⁿ cùtnuní iní‑ndó —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Te òré ní ndɨhɨ tnúhu ní cáháⁿ Jèsús, te ɨɨⁿ tée cùu fariséú ní cáháⁿ ñáhá‑dě xii‑gá vehe‑dé caxi‑gá, te cuánguɨhu‑gá vehe‑dé, te ní ngóo‑gá mèsá. ");
INSERT INTO milNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Te tée cùu fariséú‑áⁿ ǐo ní cuñúhu‑dé, chi Jèsús ñá túú ní ndàha‑gá nàcuáa sàni iní‑güedé nduu vétú iní Yǎ Ndiǒxí òré ní ngóo‑gá caxi‑gá dàtná quídé mèe‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Nchòhó cue tée cùu fariséú xìní‑ndó sǎ ìó ñáyiu nàquete sátá‑ni tàsáⁿ ndɨhɨ sátá‑ni cǒhó, te xɨtɨ́‑xi càndehe caduha‑ni. Te ducaⁿ sǎtnahá‑xi cùu nchohó, chi ndaha‑ni‑ndo nàquete‑ndo, te iní‑ndó ñà túú ndùu ndoo, te nándɨ dàndahú‑ndó tnàha ñáyiu‑ndo, te quèheⁿ‑ndo sá ndécú ndɨ̀hɨ́‑yu, te nándɨ‑gá nchaa sá cuèhé sá dúhá ñùhu iní‑ndó quìde‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Te nchòhó cúú‑ndó cuè tée ío ñɨɨ́ iní‑xi! ¿Te náa ñá túú cùtnuní iní‑ndó sǎ Yǎ Ndiǒxí Yaá ní cadúha yɨquɨ cùñú‑ó dɨu‑ni‑gá ní chihi‑gá iní‑ó‑ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Te nchaa sá vǎha ndècu ndɨhɨ‑ndo cuáha‑ndo nchàa ñáyiu xìni ñuhu na cundecu ndɨhɨ́‑yu, te núu ducaⁿ na càda‑ndo, te cuu‑ndo ñǎyiu sa ní nduu ndoo ní nduu nine iní‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Te ndàhú ní cuu nchaa nchòhó cue tée cùu fariséú! Chi sǎha‑ndo Yǎ Ndiǒxí núú ùxí xichi yúcú nání mèntá, ndɨhɨ yúcú rùdá, ndɨhɨ nchaa dava‑gá núú yǔcú quěe comìdá, dico ñá túú quìde ndáá‑ndó, te ni ñà túú ñùhu iní‑ndó Yǎ Ndiǒxí. Dico tnúhu càháⁿ‑í‑a tàú‑ndó càda‑ndo, te ni vǎ dáñá ndèé‑ndó càda‑ndo nchaa dava‑gá sá vǎha. ");
INSERT INTO milNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Te ndàhú ní cuu nchòhó cue tée cùu fariséú! Chi cuìní‑ndó cùnucóo‑ndo nǔú sácǒo cue tée ío cùnuu xɨtɨ́ veñúhu, te cuìní‑ndó mèe‑ni ndɨhɨ tnúhu yɨñùhu cáháⁿ ndɨhɨ ñaha ñǎyiu xii‑ndo nchàa núú xícá cùu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Te ndàhú ní cuu nchòhó cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ nchòhó cue tée cùu fariséú chi ío dàndahú‑ndó mèe‑ndo sá quídé ndǎá‑ndó te ñá ndàá sá quídé ndǎá‑ndó! Chi cùu‑ndo datná ɨɨⁿ ñáyiu ní xíhí te ní nguɨ́ndǔxi, te ñá túú cùtnuní‑gá ndèé yɨ́ndǔxi‑yu, te cuěi nà yáha ñáyiu dico ñá túú cùtnuní sá yɨ́ndǔxi ndɨ́yɨ. Te ducaⁿ sǎtnahá‑xi cùu nchohó, chi nchaa ñáyiu ndèhe ñaha xii‑ndo ñá túú cùtnuní iní‑yu nchaa sá cuèhé sá dúhá sàni iní‑ndó —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Te ní xáhaⁿ ɨ̀ɨⁿ tée dàcuaha ñaha xií‑yu nchaa tnúhu ní chídó tnùní ndíi Moìsés xii‑gá: —Mèstrú, te sá dúcáⁿ càháⁿ‑n te tnàhá nchúhú xǐcuèhé‑n ǎⁿ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Te Jèsús ní xáhaⁿ‑gǎ: —¡Ndàhú ní cuu tnàhá nchaa nchòhó cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés! Chi quìde‑ndo datná quídé ñǎyiu dàcuido ɨɨⁿ tnaha ñáyiu‑xi ɨɨⁿ sá ǐo vée, te mèé‑yu ni lùha ñá túú cuìní‑yu cuidó‑yu. Te ducaⁿ sǎtnahá‑xi quìde nchohó chi dànehé‑ndó ñǎyiu nàcuáa cadá‑yu, dico mee‑ndo chi ni lùha ñá túú cuìní‑ndó càda‑ndo nacuáa dànehé‑ndǒ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Te ndàhú ní cuu tucu‑ndo! Chi càdúha‑ndo nǔú nǐ nguɨ́ndǔxi cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha cuèndá sá cúnàha‑ndo núú yɨ́ndǔxi cue ndíi, te dɨu‑ni cue ñaní tnáhá‑ndó nǐ sahni‑güedé cue ndíi. ");
INSERT INTO milNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Te nchòhó sa nàha‑ndo nacuáa ní quide cue ñaní tnáhá‑ndó, te càchí‑ndó sǎ nǐ quide váha‑güedé sá dúcáⁿ nǐ sahni‑güedé cue ndíi‑áⁿ, te vitna càdúha‑ndo nǔú nǐ nguɨ́ndǔxi cue ndíi. ");
INSERT INTO milNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Te Yá Ndiǒxí ío sàá nchaa sá xìní tnùní‑gá, te ní cachí‑gá sá dácàháⁿ‑gá iní cue tée cuèndá cáháⁿ‑güedé tnúhu‑gá núú ñǎyiu, te cada‑güedé nchaa nàcuáa cuìní‑gá, te dava‑güedé cahni ñàhá‑yu xii‑güedé, te dava‑güedé ío dandòho ñahá‑yu xii‑güedé duha ní cachí‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Te nchaa ñáyiu ñuyíú vitna tnàhá‑yu nacháhu‑yu núú Yǎ Ndiǒxí cuèndá sá nǐ sahni‑güedé cue tée ní cáháⁿ tnúhu‑gá ndéé cútnàhá ní ngáva ñuyíú. ");
INSERT INTO milNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Te ndéé ndíi Àbél tée ní sahni‑güedé ndéé díhna nuu, ndɨhɨ ndéé ndíi Zacàriá tée ní sahni‑güedé ndéé núú nǐ ndɨhɨ‑ná ndácáⁿ cuèndá ñáhá Yǎ Ndiǒxí núú ñǎyiu ndècu ñuyíú vitna, te dɨu ndíi‑áⁿ nǐ sahni‑güedé mei tnùú veñúhu càhnu sá ǐo cùnuu, ndɨhɨ xíto núú sácǒdó sǎ ndúú tǎhú Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Te ndàhú ní cuu tucu nchaa nchòhó cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés! Chi quìde‑ndo datná quídé ɨ̀ɨⁿ tée tàxi tnuní ɨɨⁿ vehe, chi nacadɨ́‑dé te ñá dáñá‑dě quɨ́hu ñáyiu te ni mèe‑dé ñá túú quɨ̌hu‑dé. Te ducaⁿ sǎtnahá‑xi quìde‑ndo, chi dàcuaha‑ndo tnúhu Yá Ndiǒxí te ñá túú cuìní‑ndó quɨ̀ndáá iní‑ndó te ni ñà túú dànehé‑ndó ñǎyiu cuìní tnɨɨ tnúhu‑gá nàcuáa tàú‑xi cunduu cuèndá naníhí tàhú‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Te òré ní ndee Jèsús vehe tée cùu fariséú‑áⁿ, te cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùu fariséú ní cudééⁿ‑güedě núú‑gǎ, te ní ngüíta‑güedé nándɨ sá xìcáⁿ tnúhú‑güedě núú‑gǎ cuèndá cuìní‑güedé nǔu vá cuǐta‑gá ɨɨⁿ tnúhu càháⁿ‑gá ");
INSERT INTO milNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","cuèndá ducaⁿ nǐhí‑güedě nàcuáa cada‑güedé cacáⁿ cuéchi‑güedé cuèndá‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Te òré‑áⁿ nǐ tacá tɨtnɨ́ mǐl ñáyiu núú ndécú Jèsús, te súúní dìcó ngǒnchihi tnàha‑ná‑yu. Te ndèdóho‑yu ní xáhaⁿ Jèsús xii cue tée xìca cuu ndɨhɨ‑gá: —Cada cuèndá‑ndó vǎ cánchǐcúⁿ nihnu‑ndo nàcuáa quìde cue tée cùu fariséú, chi cue tée‑áⁿ ǐo dàndahú‑güedé méé‑güedě sá quídé ndǎá‑güedé dico ñá ndàá sá quídé ndǎá‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Te nchaa tnúhu sá cúú yùhu ni cuu vá cúú yùhu‑gá, chi nchaa dacuɨtɨ́í sǎ quéé tǔu‑xi núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chi nchaa tnúhu càháⁿ dayuhu‑ndo quèe túu‑xi núú chítú nǔú tàcá, te nchaa tnúhu càháⁿ méé‑ndó vèhe‑ndo dacuɨtɨ́í sǎ nìhí ñáyiu tnúhu. ");
INSERT INTO milNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Te nchòhó cue tée ío váha tnàhá tnúhu ndɨhɨ‑í ná càchí tnúhu‑í xii‑ndo sǎ vǎ yùhú‑ndó cuè ñáyiu cuěi na càhni ñahá‑yu xii‑ndo, chi dɨu‑ni yɨquɨ cùñú‑ndó ndàcú‑yu cahní‑yu, te ñá túú nǎgá ndacú‑yu cada ñàhá‑yu xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Te na càchí tnúhu‑í xii‑ndo sǎ Yǎ Ndiǒxí tàú‑ndó yùhú‑ndó‑gǎ, chi mee‑gǎ ío cùnuu‑gá, te dɨu‑gá quídé‑gǎ sá vǎ cúndècu‑gá ñáyiu ñuyíú, te daquɨ̀hɨ́ⁿ ñáhá‑gǎ xií‑yu núú ùhú núú ndàhú, núu xíǎⁿ càchí tnúhu‑í xii‑ndo sǎ Yàá‑áⁿ tàú‑ndó yùhú‑ndó‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Te nchòhó xìní‑ndó sǎ ndèé úhúⁿ tnàhá tɨ́laá cúyǎhu‑dɨ núú ùú díhúⁿ, dico Yá Ndiǒxí ñá túú cùnaa‑gá ni ɨ̀ɨⁿ‑güedɨ, chi nèhe cuendá ñáhá‑gǎ xii‑güedɨ. ");
INSERT INTO milNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Te nchòhó ndéé ɨɨⁿ ɨɨⁿ idi dɨ́quɨ́‑ndó yɨ̀ndehu, núu xíǎⁿ càchí‑í sá vǎ yùhú‑ndó, chi cùnuu‑gá‑ndó dàcúúxí tɨ̌laá cuěi vài vihi‑güedɨ. ");
INSERT INTO milNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Te na càchí tnúhu‑í xii‑ndo sǎ nǔu na dàtúu‑ndo nǔú dàva‑gá ñáyiu sá ndécú ndɨ̀hɨ ñaha‑í xii‑ndo. Te ducaⁿ te tnàhá yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo datúu‑í núú nchàa cue espíritú xínú cuèchi núú Yǎ Ndiǒxí sá nchòhó ndécú ndɨ̀hɨ ñaha‑ndo xii‑í. ");
INSERT INTO milNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Dico núu na cǔñaha‑ndo xìi ñáyiu sá ñà túú ndècu ndɨhɨ ñaha‑ndo xii‑í, te dɨu‑ni ducaⁿ càda yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, chi cúñaha‑ǐ xii cue espíritú xínú cuèchi núú Yǎ Ndiǒxí sá ñà túú ndècu ndɨhɨ ñaha‑í xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Te ndědani càa ñáyiu na càháⁿ cuèhé cuèndá yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, te cada càhnu iní ñáhá Yǎ Ndiǒxí xií‑yu. Dico ñáyiu na càháⁿ cuèhé cuèndá Espíritú Yǎ Ndiǒxí, te ñáyiu‑áⁿ vǎ cádá càhnu iní ñáhá‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Te òré ná càndeca ñaha‑güedé xii‑ndo quɨ̌hɨ́ⁿ veñúhu, àdi núú cuè tée cùchiuⁿ, te ni vǎ cání ìní‑ndó nǔu nása cunduu tnúhu cúñaha‑ndo xìi‑güedé, te ni vǎ cání ìní‑ndó nǔu ná tnúhu nadànchocáva‑ndo nǔu ná tnúhu na cǔñaha‑güedě xii‑ndo, ");
INSERT INTO milNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","chi òré‑nǎ te mee Espíritú Yǎ Ndiǒxí dacàhu iní ñáhá‑xí xìi‑ndo tnúhu cúñaha‑ndo xìi‑güedé —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Te ɨɨⁿ tée ñùhu tnahá tnuú ñáyiu‑áⁿ nǐ xáhaⁿ‑dě xii Jèsús: —Mèstrú, cúñaha xìi ñaní‑í sá ná chìdava‑dé sá nǐ dándǒo tǎtá‑ndɨ̌ cuu cuèndá‑ndɨ́ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —¿Te ná cuèndá ducaⁿ càháⁿ‑n? Te ñá dɨ́ú chìuⁿ‑áⁿ věxi‑í cada‑í, chi ñá dɨ́ú těe cùchiuⁿ cuu‑í —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Te xáhaⁿ‑gǎ xii nchaa ñáyiu xǐndecu‑áⁿ: —Nchaa nchòhó ñáyiu ndèdóho nchaa tnúhu càháⁿ‑í ío váha cada cuèndá‑ndó, te vá cání ìní‑ndó nǎndɨ nducu‑ndo cùndecu ndɨhɨ‑ndo, chi cuěi vài vihi na nihí‑ndó cùndecu ndɨhɨ‑ndo, dico vá chíndèe ñaha‑xi cudíi‑ndo cùndecu‑ndo ñuyíú‑a —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Te dǎtnùní ní ngüíta‑gá cání‑gǎ ɨɨⁿ cuèndú núǔ‑yu cuèndá tecú tnùní‑yu tnúhu‑gá, te xáhaⁿ‑gǎ: —Ɨɨⁿ tée cuica sǔúní nǐ cuu nchaa tatá ní xitu‑dé núú ñúhú‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Te ní ngüíta‑dé sání ìní‑dé: “¿Te nása cada‑í? Te ñá túú ndèé nataxúha‑í nchaa sá nǐ xitu‑í”, duha ní sani iní‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Te dǎtnùní ní sáha váha tucu‑dé cuèndá nàcuáa cada‑dé, te ní cachí‑dé: “Duha na cùnduu, dangòyo‑í yacá‑í, te ndada càhnu‑gá‑í, te xɨtɨ́‑xi nataxúha‑í nchaandɨ túhú sá nǐ xitu‑í, ndɨhɨ nchaa dava‑gá sá ndécú ndɨ̀hɨ‑í. ");
INSERT INTO milNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Te sátá dúcáⁿ, te cachí‑í: Ío vài sá ndécú ndɨ̀hɨ‑í, te cudíi‑xi cuéhé cuǐá, te vitna ndetatú‑í, te coho‑í te caxi‑í cada‑í, te nándɨ‑gá cada‑í cuèndá cudɨ́ɨ́ ìní‑í cundecu‑í, duha quesaha‑ǐ”, càchí‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dico Yá Ndiǒxí ní xáhaⁿ‑gǎ xii‑dé: “Yòhó, ñá túú nàndɨ́hɨ sá sání ìní‑n, chi yúhú càchí‑í sá nìú vitna cuú‑n, te nchaa sá ndécú ndɨ̀hɨ‑n ¿yoo cuu sá vǎha xii‑aⁿ‑i?”, càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Duha yáha nchaa ñáyiu nándɨ sàni iní‑xi cundecu ndɨhɨ́‑xi ñuyíú‑a, dico ñáyiu‑áⁿ ǐo ndàhú‑yu chi ñá túú nǎ nduu táhǔ‑yu núú Yǎ Ndiǒxí cundecu ndɨhɨ́‑yu —càchí Jèsús xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Te ní xáhaⁿ Jèsús xii cue tée xìca cuu ndɨhɨ‑gá: —Te na càchí tnúhu‑í xii‑ndo sǎ vǎ ǐo cani iní‑ndó nǔu nása cundecu‑ndo, àdi nása níhí‑ndó sǎ cáxí‑ndó, àdi nása níhí‑ndó dǒó cuihnu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Chi cùnuu‑gá méé‑ndó dàcúúxí sǎ nchító‑ndó, te ducaⁿ yɨ̀quɨ cuñú‑ndó cùnuu‑gá‑xi dàcúúxí dǒó sácuǐhnu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Te chí cuǎha cuèndá nàcuáa quìde cue tɨ́cácá, chi ni ñà túú chìhi‑güedɨ tatá cuu itú natahu‑güèdɨ te ni ñà túú ndèé nútnɨ̌ɨ yacá‑güedɨ, te nìhí‑güedɨ xèxi‑güedɨ, chi Yá Ndiǒxí xító ñàha‑gá xii‑güedɨ. ¡Te nchòhó cúnùu‑gá‑ndó dàcúúxí nchàa cue quɨtɨ ndava! ");
INSERT INTO milNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Te cuěi nándɨ sá sání vìhi iní‑ndó ndècu‑ndo, dico ñá ndácú‑ndó càda‑ndo nacuáa cuehnu‑ndo cuědìcó ɨɨⁿ yɨquɨ‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Te núu ni sǎ lúhá xǐǎⁿ ñá ndácú‑ndó càda‑ndo, ¿te ná cuèndá ío sàni iní‑ndó cuèndá nchaa sá cuìní‑ndó nǐhí‑ndó cùndecu ndɨhɨ‑ndo? ");
INSERT INTO milNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Te chí cádá cuèndá nàcuáa sàhnu ɨɨⁿ tnu itá, chi ni ñà túú quìde chiuⁿ‑xi, te ni ñà túú quèheⁿ‑xi idi. Te na càchí tnúhu‑í xii‑ndo sǎ ndǐi Salòmón ío vii ní cáa nchaa sá nǐ xíndecu ndɨhɨ ndíi, dico vií‑gá tucu càa nchaa itá dàcúúxí nchàa sá nǐ xíndecu ndɨhɨ ndíi. ");
INSERT INTO milNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Te cúhú sǎ ìó vitna tnaa‑ni cùdíi‑xi te sàhmí‑yu, te cuěi ducaⁿ dico ío vii càdúha Yá Ndiǒxí nchaa cúhú‑ǎⁿ. ¡Te nchòhó ío cùnuu‑ndo dacúúxí nchàa cúhú‑ǎⁿ, núu xíǎⁿ ío xìto ñaha‑gá xii‑ndo, te dìcó yica cùu iní‑ndó sàndáá iní‑ndó‑gǎ! ");
INSERT INTO milNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Te vá ǐo canchicúⁿ nihnu‑ndo sǎ cóhó sǎ cáxí‑ndó, te ni vǎ dándɨ̀hú‑ndó ìní‑ndó nǔu nása cada‑ndo nǐhí‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Chi nchaa ñáyiu ñá túú sàndáá iní ñáhá xìi Yá Ndiǒxí ducaⁿ mèe‑ni sá cóhó sǎ cáxǐ‑yu xìca nchicúⁿ nihnú‑yu. Dico mee Tǎtá‑ó Dǔtú Ndiǒxí sa nàha‑gá nándɨ cùu sá xíní ñùhu‑ndo, te taxi‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Te cada‑ndo nchàa nacuáa càháⁿ Yǎ Ndiǒxí Yaá yɨ́ndàha ñaha xii‑ndo, te ducaⁿ te taxi‑gá nchaa sá xíní ñùhu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Te vá yùhú nchòhó cue tée ndècu ndɨhɨ‑í cuěi ío sacú‑ndó, chi Tǎtá‑ó Dǔtú Ndiǒxí ní cachí‑gá sá ndúú tǎhú‑ndó cùndecu‑ndo núú ndécú‑gǎ taxi tnùní‑ndó tnàhá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Te chí dícó nchàa sá ndécú ndɨ̀hɨ‑ndo, te chí cuǎha nchaa ñáyiu ndàhú díhúⁿ‑ndó ñǎyiu xìni ñuhu, te cada váha‑ndo cùndecu‑ndo, te ducaⁿ te nduu táhú‑ndó sǎ ǐo‑gá váha núú Yǎ Ndiǒxí cundecu ndɨhɨ‑ndo, te xíǎⁿ vá cúú tùhú tnàhí‑gá‑xi, te ni vǎ ndɨ́hɨ́ nìhnu‑gá‑xi, te ni ñàdúhú vǎ ndácú‑güedě duhu‑güedě, te ni tɨ̌quidi vá quéé‑dɨ́. ");
INSERT INTO milNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Te núu xíǎⁿ cúú cuèndá‑ndó ñá, te dɨu‑ni xíǎⁿ ñúhú ìní‑ndó, áⁿ te núu mee‑ni sǎ ndécú ñùyíú‑a ndècu ndɨhɨ‑ndo, te dɨu‑ni nchaa xíǎⁿ ñúhú ìní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","’Te ío quɨhɨ iní‑ndó cùndecu‑ndo, te cada‑ndo dàtná quídé dàva cue tée xìnu cuechi sacúndecu túha‑güedé cuěi náni òré‑áⁿ ndétú‑güedě pàtróóⁿ‑güedě ná òré nasáá‑dé sá cuàháⁿ‑dé vico tnǎndaha. Te núu niú te sa cúu cáyú‑ni ñuhú‑güedé sá cúndètu ñaha‑güedé, chi òré ná nàsáá‑dé dacàsaⁿ‑dé yuyèhe, te ndɨ̌hɨ‑ni nacaáⁿ‑güedé ndɨ́hu‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Te váha táhú nchaa cue tée xìnu cuechi‑áⁿ, chi ndècu túha‑ni‑güedé ndétú‑güedě ndéé òré ní nasáá pàtróóⁿ‑güedě, te na càchí tnúhu ndáá‑í xii‑ndo sǎ òré ná nàsáá pàtróóⁿ‑güedě‑áⁿ te chihi ñaha‑dě mèsá xii‑güedé, te ndacáⁿ ndee‑dé dóó níhnú‑dě núú yɨ́quɨ́‑dě, te ngüíta‑dé cani‑dé cóhó‑güedě cuèndá caxi‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Te dɨu‑ni ducaⁿ càda‑dé cuěi dava niú, àdi tacuíhndá‑gá, te núu ñá túú xìdí‑güedé òré nasáá‑dé, te cue tée xìnu cuechi‑áⁿ ǐo váha tnahá‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Te núu dìcó ɨɨⁿ tée cùu xítohó ɨɨⁿ vehe xìní‑dé ná òré quɨ́hu ñadúhú vehe‑dé ñá, te quɨhɨ iní‑dé te vá cùdú‑dé, te vá dáñá‑dě nacaáⁿ‑güedé yuyèhe‑dé quɨ́hu‑güedé duhu‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Te nchòhó tucu nchaa‑ni nduu quɨhɨ iní‑ndó cùndecu túha‑ndo, chi na cuáháⁿ nduu ñǎ túú yɨ̀hɨ iní‑ndó, te quixi tucu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Te té Pèlú ní xícáⁿ tnúhú‑dě núú Jèsús, te xǎhaⁿ‑dě: —Mèstrú, ¿te tnúhu ní cáháⁿ‑n‑ǎⁿ cùu‑xi mee‑ni cuendá nchúhú ǎⁿ cuèndá nchaa ñáyiu? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Te Jèsús ní xáhaⁿ‑gǎ: —Càháⁿ‑í cuèndá ñáyiu quìde váha dàtná quídé ɨ̀ɨⁿ tée tàxi tnuní ñáhá xìi cue ñáyiu xìnu cuechi ndecu vehe patróóⁿ‑xi, chi tée‑áⁿ ǐo váha tècú tnùní‑dé, te quìde‑dé nchaa nàcuáa càháⁿ pàtróóⁿ‑dě, te dàcaxi‑dé cue ñáyiu xìnu cuechi oré tàú‑xi caxí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Te núu ducaⁿ quìde váha tée tàxi tnuní ñáhá xìi cue ñáyiu xìnu cuechi‑áⁿ ñá, te ío váha tnàhá‑dé òré násǎá pàtróóⁿ‑dě nǔu ndèé cuáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ těe quìde ndáá táxí tnùní ñáhá xìi cue ñáyiu xìnu cuechi‑áⁿ cǔñaha‑nǎ pàtróóⁿ‑dě xii‑dé sá ncháándɨ̀ túhú‑nǎ sá ndécú ndɨ̀hɨ‑dé quɨndaha‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Dico núu tée tàxi tnuní ñáhá xìi cue ñáyiu xìnu cuechi‑áⁿ ná càni iní‑dé sá cúyàa patróóⁿ‑dě vá násàá ndɨ̌hɨ‑ni‑dé ñá, te ngüíta‑dé cani‑dé nchaa ñáyiu xìnu cuechi, cuěi tée cuěi ñadɨ̀hɨ́, te ngüíta‑dé caxi‑dé coho‑dé, te dàxíni‑dé méé‑dě, ");
INSERT INTO milNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","te nduu ñà túú yɨ̀hɨ iní‑dé te nasáá pàtróóⁿ‑dě, te dandòho ñaha patróóⁿ‑dě‑áⁿ xii‑dé, te daquɨ̀hɨ́ⁿ ñáhá‑dě xii‑dé núú ndécú ñǎyiu ñá túú ní quìde ndáá. ");
INSERT INTO milNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Te dava cue tée xìnu cuechi xiní‑güedé nàcuáa cuìní pàtróóⁿ‑güedě cada‑güedé te ñá túú quìde‑güedé, te ni ñà túú cuìní‑güedé cundecu túha‑güedé cundetu‑güedé pàtróóⁿ‑güedě, te nchaa cue tée ducaⁿ xǐquide dandòho ñaha patróóⁿ‑güedě, chi ñáni vìhi‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Te dava cue tée xìnu cuechi ñá túú xìní‑güedé nàcuáa cuìní pàtróóⁿ‑güedě cada‑güedé, te ní quide‑güedé sá néñùú‑güedé ɨɨⁿ sá ñà túú tàú‑güedé cada‑güedé ñá, te cue tée‑áⁿ sacú‑gá dandòho ñaha patróóⁿ‑güedě, chi sacú‑gá ñáni‑güedé. Te ñáyiu cùtnuní iní‑xi nàcuáa cuìní Yǎ Ndiǒxí cadá‑yu, te dɨu‑ni ducaⁿ tàú‑yu cadá‑yu nàcuáa cuìní‑gá. Te ñáyiu vài‑gá tècú tnùní nàcuáa càháⁿ‑gá, te dɨu‑ni ducaⁿ vài nchaa sá càháⁿ‑gá tàú‑yu cadá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Te yúhú véxi‑í ñuyíú‑a cuèndá cutnùní iní ñáyiu nàcuáa cada ñaha Yǎ Ndiǒxí xií‑yu, ¡te cuìní‑í sá ndɨ̌hɨ‑ni cada‑gá nàcuáa sàni iní‑gá! ");
INSERT INTO milNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Te yúhú ío vài tnúhu sàni iní‑í, ¡chi sáá nduu te ío ndoho‑í, te dɨu‑ni xíǎⁿ cuhuⁿ iní‑í ndéé ná sàá nduu dùcaⁿ yáha‑í! ");
INSERT INTO milNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Te nchòhó vá cání ìní‑ndó sǎ yǔhú véxi‑í ñuyíú‑a te cundecu ndɨhɨ tnàha váha‑ni ñáyiu, te ñáhá chi da ngüíta‑yu vá cúú ɨ̀ɨⁿnuú‑yu cundecú‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Te ndéé není vitna ngüíta ñáyiu vá cúú ɨ̀ɨⁿnuú‑yu cundecú‑yu, te na càda‑o cuendá te núu úhúⁿ ñáyiu xǐndecu ɨɨⁿ‑ni vèhe, te vá cúú ɨ̀ɨⁿnuu‑gá‑yu, chi úní‑yu ndatnúhu‑yu te nàá‑yu ndɨhɨ úú‑gá‑yu, àdi ñáyiu úú‑áⁿ ndatnúhu‑yu te nàá‑yu ndɨhɨ ñáyiu úní‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Te dava cue tée cùu tátá vá cúú ɨ̀ɨⁿnuu‑gá‑güedé ndɨhɨ déhe ducuⁿ‑güedé, te ni dàva cue ñáyiu cùu náná vá cúú ɨ̀ɨⁿnuu‑gá‑yu ndɨhɨ déhe yòcó‑yu, te ni sǎnu‑yu vá cúú ɨ̀ɨⁿnuu ndɨhɨ‑gá‑yu. Te ducaⁿ càdá‑yu chi davá‑yu quɨndáá iní ñáhǎ‑yu xii‑í, te davá‑yu vá quɨ̀ndáá iní ñáhǎ‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Te Jèsús ní xáhaⁿ‑gǎ xii nchaa ñáyiu xǐndecu‑áⁿ: —Te nchòhó òré ndéhé‑ndó ndànchita vícó ndàa xio quée nchícanchii, te càchí‑ndó sǎ cúúⁿ dǎú, te dɨu ducaⁿ ndìsa quide‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te òré ná quène táchí ndàa xio datni nacuáa quène nchícanchii, te càchí‑ndó sǎ ǐo cada ihni‑xi, te dɨu ducaⁿ ndìsa quide‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Te nchòhó ío váha cùtnuní iní‑ndó nàcuáa quìde‑xi andɨu ndɨhɨ ñuyíú, ¿te ná cuèndá quídé‑ní‑ndó sǎ ñǎ tècú tnùní‑ndó nàcuáa quìde Yá Ndiǒxí vitna? Te sá dúcáⁿ quìde‑ndo‑áⁿ ǐo dàndahú‑ndó mèe‑ndo sá ǐo váha cùtnuní iní‑ndó, chi ñá ndàá sá cútnùní iní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Te nchòhó, ¿ná cuèndá ñá túú dàndixi túu‑ndo ìní‑ndó càda‑ndo mee‑ni sá vǎha sá tàú‑ndó càda‑ndo‑i? ");
INSERT INTO milNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Te núu ìó ɨɨⁿ‑ndo nǐ sacáⁿ cuéchi ñáyiu cuèndá‑ndó cuèndá ɨɨⁿ sá nǐ quide‑ndo, te cuáháⁿ‑ndó ndɨ̀hɨ́‑yu núú těe cùchiuⁿ, te nɨni ñùhu‑ndo ndɨhɨ́‑yu ichi, te nducu‑ndo nàcuáa cada‑ndo nàcáháⁿ cáhnú ìní tnáhá‑ndó ndɨ̀hɨ́‑yu cuèndá sá vǎ cándèca ñaha‑gá‑yu quɨ́hɨ́ⁿ núú těe cùchiuⁿ, chi núu ducaⁿ na càdá‑yu te tée cùchiuⁿ‑áⁿ nachihi ñaha‑dě ndaha cue tée cùu poleciá, te cue tée‑áⁿ chihi ñaha‑güedě vecaá xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Te na càchí tnúhu‑í xii‑ndo sǎ nǔu na ngàva‑ndo vecaá, te vá cǎcu‑ndo te núu vá náchǎhu‑ndo nchàa sá tàú‑ndó —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Te dɨu‑ni òré‑áⁿ nǐ ngúnutnɨ́ɨ ɨɨⁿ ǔú ñáyiu núú Jèsús cánǐ‑yu cuèndú núú‑gǎ nàcuáa ní quide ñaha té Pìlatú xii cue tée distrìtú Galìleá cue tée ní sahni quɨtɨ nduu táhú Yǎ Ndiǒxí, te mei òré ní sahni‑güedé cue quɨtɨ‑áⁿ nǐ táúchíúⁿ tě Pìlatú cue sandàdú‑dé ní sahni‑güedé cue tée Galìleá‑áⁿ, te ní xica nɨ́ñɨ́‑güedě núú ñúhú ndɨ̀hɨ nɨ́ñɨ́ cue quɨtɨ‑áⁿ, te ní nadácánuu‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Te Jèsús ní xáhaⁿ‑gǎ xií‑yu: —Te núu nchòhó sání ìní‑ndó sǎ sà dúcáⁿ nǐ yáha cue tée distrìtú Galìleá‑áⁿ te cùu‑güedé cue tée ndècu vihi‑gá cuéchi‑xi dàcúúxí cuè tée ñuú‑güedé ñá. ");
INSERT INTO milNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Te na càchí tnúhu‑í xii‑ndo sǎ ñǎhá. Te núu nchòhó vá ndíxí cuěchi iní‑ndó cuèndá nchaa sá cuèhé sá dúhá quìde‑ndo ndecu‑ndo ña, te tnàhá nchaa nchòhó cuíta nihnu‑ndo te núu vá nátnɨ̀ɨ‑ndo ichi Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Te núu nchòhó sání ìní‑ndó sǎ ñǎyiu sáhúⁿ úní ní xíhí ní táú ñáhá vèhe ducúⁿ Silòé ío‑gá ndécú cuěchi‑yu dàcúúxí nchàa ñáyiu xǐndecu ñuú Jerusàlén ñá, ");
INSERT INTO milNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","te na càchí tnúhu tucu‑í xii‑ndo sǎ ñǎhá. Te núu nchòhó vá ndíxí cuěchi iní‑ndó cuèndá nchaa sá cuèhé sá dúhá quìde‑ndo ndecu‑ndo ña, te tnàhá nchaa nchòhó cuíta nihnu‑ndo te núu vá nátnɨ̀ɨ‑ndo ichi Yá Ndiǒxí —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Te Jèsús ní cani tucu‑gá ɨɨⁿ cuèndú núǔ‑yu nàcuáa tecú tnùní‑yu tnúhu‑gá, te xáhaⁿ‑gǎ: —Ɨɨⁿ tée nùtnɨ́ɨ ɨɨⁿ yutnu ngǔxí núú ñúhú‑dě, te cuáháⁿ ndéhé‑dě nǔu ní cuuⁿ sávìdí‑xi ni cùu, te ni ɨ̀ɨⁿ ñá túú ní cùuⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Te ní xáhaⁿ těe‑áⁿ xii tée ndèé ñuhu‑dé: “Nàha‑n sá vìtna ní cuu úní cuíá quíxí còto‑í yutnu ngǔxí‑a te ñá túú xìní‑í ni ɨ̀ɨⁿ sávìdí‑xi. Te quehndé‑n vìtna, chi àúⁿ nǎ cuu nùtnɨ́ɨ‑xi quìde tneñu‑xi núú ñuhu‑áⁿ”, càchí‑dé xǎhaⁿ‑dě xii tée ndèé ñuhu‑dé‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Te tée ndèé ñuhu‑áⁿ nǐ xáhaⁿ‑dě: “Pàtróóⁿ, daña na cuìhnu‑xi cuíá vitna‑ná, te na nàdatayá‑í ñuhu núú sàhá‑xi, te chihi‑í saháⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Te ducaⁿ te cudana cuuⁿ sávìdí‑xi, àdi núu ñá túú ní cùuⁿ sávìdí‑xi ña te téhndé‑nǎ‑xi”, càchí‑dé xǎhaⁿ‑dě xii pàtróóⁿ‑dě —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Te ɨɨⁿ xito cùu‑xi nduu ndetatú ñáyiu, te yɨ̀hɨ Jesús ɨɨⁿ veñúhu dànehé‑gá ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Te xíáⁿ ndécú ɨ̀ɨⁿ ñadɨhɨ́ ní cuu sáhúⁿ úní cuíá sǎ cùhú‑aⁿ yɨ̀hɨ ñaha espíritú cúndɨ̀hɨ yucu ñávǎha xii‑aⁿ, te xíǎⁿ ní ndada cueyɨ‑xi sǎtá‑aⁿ, te ñá dáñá‑gǎ‑xi nucúnutnɨ́ɨ ndáá‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Te òré ní xiní ñáhá Jèsús xii‑aⁿ te ní cana ñaha‑gǎ, te xáhaⁿ‑gǎ: —Yòhó ñaha cùhú, ndúha‑n cuěhé tnàhá‑n —càchí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Te ní dácàá‑gá ndaha‑gá ní tendaha ñàha‑gá xii‑aⁿ, te òré‑ni‑áⁿ nǐ ndúha‑aⁿ te ní nucúnutnɨ́ɨ ndáá‑aⁿ, te ní ngüíta‑aⁿ ní cachí‑aⁿ sá ǐo càhnu cuu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Dico tée tàxi tnuní veñúhu ní cudééⁿ‑dě sá dúcáⁿ nǐ quide Jèsús ní quide tátna‑gá ñaha cùhú‑áⁿ nduu ndètatú‑yu, te ní xáhaⁿ‑dě xií‑yu: —Ìó íñú nduu tàú‑ó càda chiuⁿ‑o, te ndědani càa nduu‑áⁿ quixi‑ndo cùtátna‑ndo, dico ñá dɨ́ú ndùu cuu‑xi nduu ndetatú‑ó —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Te ní xáhaⁿ Jèsús: —Nchòhó chi ío dàndahú‑ndó mèe‑ndo sá quídé ndǎá‑ndó dico ñá ndàá sá quídé ndǎá‑ndó, ¿náa ñá túú nàndaxi‑ndo ndɨcutu‑ndo àdi búrru‑ndo dàcoho‑ndo‑güedɨ ndute nduu ndetatú‑ó ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Te ñadɨ̀hɨ́‑a cùu‑aⁿ ñaní tnáhá ndǐi Àbrahám, te dìcó‑ni sá yùcu ñávǎha quìde duha cuhú‑aⁿ ní cuu sáhúⁿ úní cuíá, ¿te náa ñá túú xìni ñuhu‑xi cutátna‑aⁿ cuěi cùu‑xi nduu ndetatú‑ó ǎⁿ? —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Te sá dúcáⁿ nǐ cáháⁿ Jèsús, núu nchaa cue tée cùu úhú iní ñáhá xìi‑gá ní cucahaⁿ núú‑güedě, dico nchaa dava‑gá ñáyiu chi xǐcudɨ́ɨ́ ìní‑yu xǐndéhě‑yu nchaa sá vǎ yǒo tnàhí ndàcu cada quide‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Te ní xáhaⁿ‑gǎ xií‑yu: —Na càni‑í ɨɨⁿ cuèndú núú‑ndó nàcuáa tecú tnùní‑ndó nàcuáa cada‑xi òré ndɨ́hu ndaha ñàha Yá Ndiǒxí xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ɨɨⁿ tée ní queheⁿ‑dé ndɨ́quɨ́ⁿ yutnu nàni mostázá te nèhe‑dé cuáháⁿ ní sacáⁿ‑dé núú ñúhú‑dě te ní xínu‑xi, te ní sahnu‑xi ní cuu dùcúⁿ‑xi, te cue quɨtɨ ndàva núú tàchí cádǔha‑güedɨ tacá‑güedɨ núú dìté‑xi —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Te ní xáhaⁿ tùcu Jesús xií‑yu: —Te na càchí tnúhu tucu‑í xii‑ndo nàcuáa cada tucu Yá Ndiǒxí òré ndɨ́hu ndaha ñàha‑gá xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ɨɨⁿ ñadɨ̀hɨ́ ní queheⁿ‑aⁿ levadùrá ní chihi‑aⁿ úní arròbá yuchi trìú, te levadùrá‑áⁿ nǐ quide‑xi ní ndaa nɨhìí yusaⁿ‑áⁿ —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Te ichi ñùhu Jesús cuáháⁿ‑gá ñuú Jerusàlén, te nchaa ñuú náhnú, ndɨ̀hɨ nchaa ñuú lǐhli ta yǎha‑gá ducaⁿ ta dànehé‑gá ñáyiu tnúhu‑gá cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Te ɨɨⁿ ñuú‑áⁿ nǐ xáhaⁿ ɨ̀ɨⁿ tée xii‑gá: —Mèstrú, cuìní‑í cácáⁿ tnúhu‑í ɨɨⁿ tnúhu núú‑n, ¿ndáá sá ǐo sacú ñáyiu nàníhí tàhú‑ǎⁿ? —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑dé ndɨhɨ nchaa ñáyiu: ");
INSERT INTO milNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Cada‑ndo sǎ nánìhí tàhú‑ndó, te tnɨɨ‑ndo ìchi Yá Ndiǒxí, te ichi‑gá‑áⁿ cúú‑xí dàtná ɨɨⁿ yuyèhe cuɨñɨ, te càchí tnúhu‑í xii‑ndo sǎ ǐo cuéhé ñǎyiu cachí iní‑yu quɨ́hu‑yu yuyèhe cuɨñɨ́‑áⁿ dico vá ndácǔ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Te na càni tucu‑í ɨngá cuèndú núú‑ndó nàcuáa tecú tnùní‑ndó tnǔhu càháⁿ‑í. Te òré ná ndàcuɨ́ñɨ́ tée cùu xítohó vehe, te nacadɨ́‑dé yuyèhe, te nchaa nchòhó ñáyiu na quèndóo quehé dacàsaⁿ‑ndo yuyehe, te quesaha‑ndo cǔñaha‑ndo xìi‑dé: “Tǎtá, nacaáⁿ yuyèhe na quɨ́hu‑ndɨ́”, quesaha‑ndo cǔñaha‑ndo xìi‑dé. Dico tée cùu xítohó vehe‑áⁿ cǔñaha‑dě xii‑ndo: “Ñá túú xìní‑í nchòhó ndèé ñáyiu cùu‑ndo”, duha cúñaha‑dě xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Te dǎtnùní ngüíta nchòhó cúñaha‑ndo xìi‑dé: “Nchúhú ní xexi ndɨhɨ ñaha‑ndɨ̌, te ní xihi ndɨhɨ ñaha‑ndɨ̌ xii‑n, te nchaa ichi ní xóo dacuàha ñaha‑n xii‑ndɨ́”, quesaha‑ndo cǔñaha‑ndo xìi‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Dico cachí tucu tée cùu xítohó vehe‑áⁿ cǔñaha‑dě xii‑ndo: “Sa ní cachí‑í sá ñà túú xìní‑í ndèé ñáyiu cùu‑ndo. Te chí xócuɨ̀ñɨ́ nchòhó ñáyiu ndècu ichi cuehé ichi duha núú ndècu‑í”, quesaha‑dě cúñaha‑dě xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Te na sàá nduu dùcaⁿ cada‑xi te quiní‑ndó tě Àbrahám, ndɨhɨ té Isàác, ndɨhɨ té Jàcób, ndɨhɨ nchaa cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí, te nchaa cue tée‑áⁿ ndécú‑güedě núú ndécú‑gǎ táxí tnùní‑gá, te nchòhó quee tɨ́hú‑ndó nǔú‑gǎ sá tnǔhu ñá túú ní cuìní cada ndáá, te dàvá‑áⁿ ndǎhyú‑ndó te cuu rúhñú‑nǎ núhu‑ndo sǎ sàtú iní‑ndó cuèndá sá ndóhó‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Te dàvá‑áⁿ quɨ̌hu nchaa ñáyiu ndɨ cùmí xio ñuyíú nǔú ndécú Yǎ Ndiǒxí táxí tnùní‑gá caxí‑yu ndɨhɨ‑gá, te cundecú‑yu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Te dava ñáyiu nchìcúⁿ ñá túú cùnuu ndecu ichi Yá Ndiǒxí vitna, ñáyiu‑áⁿ sǎá nduu te ío cunùú‑yu. Te dava ñáyiu cùnuu ndecu ichi‑gá vitna, ñáyiu‑áⁿ sǎá nduu te vá ǐo‑gá cunùú‑yu —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Te dɨu‑ni nduu‑ǎⁿ nǐ quexìo ɨɨⁿ úú cue tée cùu fariséú núú ndécú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Quee‑n ìha quɨ́hɨ́ⁿ‑n nǔu ndèé quɨ́hɨ́ⁿ‑n, chi tée cùu Herodés cuìní‑dé cahni ñaha‑dě xii‑n —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Te Jèsús ní xáhaⁿ‑gǎ: —Chí cuàháⁿ te cúñaha‑ndo xìi tée nèhe mañá‑áⁿ sǎ càchí‑í sá ná cùndedóho váha‑dé ɨɨⁿ tnúhu càháⁿ‑í, chi cùmání ɨɨⁿ ǔú‑gá nduu cundecu‑í xocàni‑í nchaa espíritú cúndɨ̀hɨ yucu ñávǎha yɨ̀hɨ ñaha xii ñáyiu, te cada tátna‑í nchaa dava‑gá ñáyiu cùhú, te ducaⁿ te ndɨhɨ chìuⁿ‑í, duha cúñaha‑ndo xìi‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Dico dacuɨtɨ́í sǎ cúhùⁿ‑í ichi ɨɨⁿ ǔú‑gá nduu, te ducaⁿ te sáá‑í núú quɨ̀hɨ́ⁿ‑í, chi vá cúú tnàhí cuú ɨɨⁿ tée càháⁿ tnúhu Yá Ndiǒxí ɨngá ñuú, chi mei ñùú Jerusàlén cuú‑güedé —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Te ní xáhaⁿ‑gǎ xii ñáyiu ñuú Jerusàlén: —Nchòhó chi sàhni‑ndo nchaa cue tée càháⁿ tnúhu Yá Ndiǒxí, cue tée ní tendaha‑gǎ véxi, te mee‑ni ndɨ̀hɨ yúú sáhní‑ndó‑güedě. ¡Te tɨtnɨ́ xito ní cuiní‑í nadatàcá ñáhà‑í xii‑ndo dàtná nádàtacá ɨɨⁿ nchuxi cuè déhe‑dɨ sàquɨhɨ‑güedɨ xɨtɨ́ ndíxíⁿ‑dɨ, dico ñá ní cuìní‑ndó, te ducaⁿ‑ni sàni iní‑í ndéé vitna! ");
INSERT INTO milNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Te chí cúndèdóho tucu ɨngá tnúhu na càháⁿ‑í‑a: Yá Ndiǒxí daña ñàha‑gá xii‑ndo. Te na càchí tnúhu tucu‑í xii‑ndo sǎ vǎ quìní ñáhá‑gǎ‑ndó xìi‑í, dico sáá nduu te quiní ñáhá tùcu‑ndo, te nduu‑ǎⁿ cachí‑ndó sǎ ǐo càhnu cuu yúhú Yaá ní tendaha Dǔtú Ndiǒxí véxi ñuyíú‑a —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Te duha ní cuu ɨɨⁿ nduu, nduu ndètatú ñáyiu chi ɨɨⁿ tée cùu fariséú cúnùu ní cáháⁿ‑dé Jèsús vehe‑dé caxi‑gá, te cue tée ndècu vehe‑dé ndéhé‑güedě nǔu nása cada‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Te xíáⁿ ndécú tnàhá ɨɨⁿ tée cùhú ñúhú‑dě cuiñu. ");
INSERT INTO milNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Te Jèsús ní xícáⁿ tnúhú‑gǎ núú cuè tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ núú cuè tée cùu fariséú, te xáhaⁿ‑gǎ: —¿Cuu cada tátna‑o ɨ̀ɨⁿ ñáyiu cùhú nduu ndètatú‑ó ǎⁿ ñǎhá? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dico cue tée‑áⁿ ñà túú tnàhí ni cǎháⁿ‑güedé. Te ní dácàá‑gá ndaha‑gá ní tendaha‑gǎ tée cùhú‑áⁿ nǐ quide tátna ñaha‑gǎ xii‑dé, te ní xáhaⁿ‑gǎ sá ná nùhú‑dé vehe‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Te ní xícáⁿ tnúhú‑gǎ núú nchàa cue tée‑áⁿ, te xáhaⁿ‑gǎ: —¿Te núu nchòhó ná ngáúnìhnu ɨɨⁿ búrru‑ndo àdi ɨɨⁿ ndɨcutu‑ndo déhvá, te vá ná tàva ndɨ́hɨ‑ni‑ndo‑dɨ cuěi cùu‑xi nduu ndetatú‑ndó‑ǎⁿ? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Te ñá túú ní nǐhí‑güedě tnúhu na dànchocáva‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Te ndèhe Jesús nàcuáa xǐquide nchaa ñáyiu ndècu vico sá sǔúní nǐ nacáxi‑yu xìlé sácǒo nchihi cue tée cùnuu‑gá conchihí‑yu òré cuánguɨhú‑yu mèsá caxí‑yu, núu ní xáhaⁿ‑gǎ xií‑yu: ");
INSERT INTO milNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Òré ná càháⁿ ñáhá ɨ̀ɨⁿ ñáyiu xii‑ndo ɨ̀ɨⁿ vico tnándaha, te vá cóó‑ndó nǔú xìlé sácǒo cue tée cùnuu‑gá, chi núu ducaⁿ na càda‑ndo, te cudana quexìo dava‑gá ñáyiu cùnuu‑gá dàcúúxí nchòhó. ");
INSERT INTO milNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Te ñáyiu ní cáháⁿ ñáhá xìi‑ndo‑áⁿ quixí‑yu te cúñàhá‑yu xii‑ndo: “Chí cuǎñaha xìlé núcǒo nchihi‑ndo‑ǎⁿ ná cònchihi ñáyiu ní quexìo‑a”, quesàhá‑yu cúñàhá‑yu xii‑ndo. Te cuìní‑ndó ñǎhá cuěi cùcahaⁿ núú‑ndó ndàcuɨ́ñɨ́‑ndó quɨ̌hɨ́ⁿ‑ndó ngǒo‑ndo nǔú xìlé xǐnutnɨ́ɨ ndéé núú nǐ ndɨhɨ‑ná ndàa sátá‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Te yúhú càchí‑í sá òré ná càháⁿ ñáhǎ‑yu xii‑ndo, te ngóo‑ndo nǔú xìlé xǐnutnɨ́ɨ ndéé núú nǐ ndɨhɨ‑ná ndàa sátá‑xi chi cuèndá òré ná quèxio ñáyiu ní cáháⁿ ñáhá xìi‑ndo, te cúñàhá‑yu xii‑ndo: “Nchòhó cue ñáyiu càháⁿ ndɨhɨ‑í, chí yǎha núú xìlé sácǒo cue tée cùnuu‑gá coo‑ndo”, duha cúñàhá‑yu xii‑ndo. Te ducaⁿ te cada nínu ñaha nchàa ñáyiu yɨ̀hɨ ndɨhɨ‑ndo mesá. ");
INSERT INTO milNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Te nchaa ñáyiu na càda nínu mee‑xi, te ñáyiu‑áⁿ ñà túú cùu nínu‑yu, te nchaa ñáyiu ñá túú quìde nínu mee‑xi, ñáyiu‑áⁿ cúú nǐnu‑yu —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Te dǎtnùní ní xáhaⁿ‑gǎ xii tée ní cáháⁿ ñáhá xìi‑gá: —Te yòhó òré cuìní‑n càda‑n ɨɨⁿ vico, te vá càháⁿ‑n mèe‑ni cue tée càháⁿ ndɨhɨ‑n, ni cuè ñaní‑n, ni cuè ñáyiu cùu ñaní tnáhá‑n, ni cuè ñáyiu cuica ndècu yatni ndɨhɨ‑n, chi ñáyiu‑áⁿ ducaⁿ càdá‑yu ɨɨⁿ nduu cáháⁿ ñáhǎ‑yu xii‑n te ndéyǎhu‑ni sá nǐ quìdé‑n‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Te ñáhá chi òré ná càda‑n ɨɨⁿ vico, te cáháⁿ‑n ñǎyiu ndàhú, ndɨhɨ ñáyiu ñá cúú càca, ndɨhɨ ñáyiu yacua, ndɨhɨ ñáyiu cuàá. ");
INSERT INTO milNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Te núu ducaⁿ na càda‑n, te cuu‑xi ɨɨⁿ sá vǎha xii‑n, chi ñáyiu‑áⁿ vǎ nìhí‑yu nacoto ñàhá‑yu xii‑n, dico na cùú‑n te sáá nduu ndòto‑n ndɨhɨ nchaa ñáyiu ní quide ndáá ní xíndecu ichi Yá Ndiǒxí, te dàvá‑áⁿ taxi‑gá sá ndúú tàhú‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Te sá dúcáⁿ nǐ cáháⁿ Jèsús ní tecú dóho cue tée yɨ̀hɨ mesá‑áⁿ, núu ní xáhaⁿ ɨ̀ɨⁿ‑dé xii‑gá: —Ío váha táhú nchaa ñáyiu na càxi nchaa sá cuǎha ñaha Yǎ Ndiǒxí nduu na sàá‑yu cundecú‑yu núú ndécú‑gǎ táxí tnùní‑gá —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Ɨɨⁿ tée quìde‑dé vico, te ní dátècú tnúhu‑dé cuéhé víhí ñǎyiu quɨ́hɨ́ⁿ‑yu caxí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Te òré sa ní cuu‑ná sá cáxǐ‑yu, te ní xáhaⁿ‑dě xii tée xìnu cuechi núú‑dě sá quɨ̀hɨ́ⁿ‑dé cúñaha‑dě quɨ́hɨ́ⁿ‑yu caxí‑yu, chi sa ndècu túha nchaa sá cáxǐ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Dico nchaá‑yu ní xáhǎⁿ‑yu xii‑dé sá ná cádá càhnu iní tée càháⁿ ñáhá‑ǎⁿ, chi ñá túú cùyáchí‑yu quɨ́hɨ́ⁿ‑yu vico‑áⁿ. Te tée ní cáháⁿ ndɨhɨ tée xìnu cuechi‑áⁿ dǐhna ní xáhaⁿ‑dě: “Íchí nǐ saaⁿ‑í ɨɨⁿ pedàsú ñuhu, te quɨ́hɨ́ⁿ ndéhè‑í tnavíí, núu xíǎⁿ càháⁿ ndàhú‑í núú‑n sǎ cǔñaha‑n xìi tée càháⁿ ñáhá‑ǎⁿ xii‑í sá ná cádá càhnu iní‑dé chi ñá túú cùyáchí‑í”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Te ɨngá‑dé ní xáhaⁿ‑dě: “Ní saaⁿ‑í úhúⁿ yùndá ndɨcutu sa xìtu, te cue quɨtɨ‑áⁿ quɨ̌hɨ́ⁿ‑í coto ndeé‑í‑güedɨ vitna, núu xíǎⁿ càháⁿ ndàhú‑í núú‑n sǎ cǔñaha‑n xìi tée càháⁿ ñáhá‑ǎⁿ xii‑í sá ná cádá càhnu iní‑dé chi ñá túú cùyáchí‑í”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Te ɨngá tucu‑dé ní xáhaⁿ‑dě: “Íchí nǐ tnándaha‑í nǔu xíǎⁿ vá cúyǎchí‑í quɨ́hɨ́ⁿ‑í”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Te òré ní nasáá tée xìnu cuechi‑áⁿ, te ní nacani tnúhu‑dé núú pàtróóⁿ‑dě nchaa nàcuáa ní xáhǎⁿ‑yu. Te ní cudééⁿ těe cùu patróóⁿ‑ǎⁿ, te ní xáhaⁿ‑dě xii tée xìnu cuechi núú‑dě‑áⁿ: “Yáchí cuàháⁿ nanducu‑n nchàa ñáyiu ndàhú, ndɨhɨ nchaa ñáyiu ñá cúú càca, ndɨhɨ nchaa ñáyiu yacua, ndɨhɨ nchaa ñáyiu cuàá, te nděni ní cuu na nàníhǐ‑n‑yu te candècá‑n‑yu quixi”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Te sátá nǐ nasáá tée xìnu cuechi‑áⁿ, te ní xáhaⁿ‑dě xii pàtróóⁿ‑dě: “Pàtróóⁿ, sa ní quide‑í chìuⁿ ní táhú‑n, dico ndècu‑gá núú cóo‑yu”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Te tée cùu patróóⁿ‑dě‑áⁿ nǐ xáhaⁿ‑dě: “Cuàháⁿ tucu nděni ní cuu te cada yica‑n na quìxí‑yu quɨ́hu‑yu cuèndá ná chìtú vehe‑í. ");
INSERT INTO milNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Te na càchí tnúhu‑í xii‑n sǎ nì ɨɨⁿ ñáyiu ní cáháⁿ‑í díhna vá cúú‑gǎ caxí‑yu sá sà ní quide túha‑í caxí‑yu ni cùu”, cachí tée‑áⁿ xǎhaⁿ‑dě xii tée xìnu cuechi núú‑dě —càchí‑gá xáhaⁿ‑gǎ xii tée‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Te ío cuéhé ñǎyiu nchìcúⁿ‑yu Jèsús, te ní xáhaⁿ‑gǎ xií‑yu: ");
INSERT INTO milNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Te núu dava nchòhó cuìní‑ndó chìtnahá ñáhá‑ndó xìi‑í, te cuu iní ñáhá ndìsa‑ndo. Te cuěi na dàndóo‑ndo tǎtá‑ndó, ndɨ̀hɨ náná‑ndó, ndɨ̀hɨ ñadɨhɨ́‑ndó, ndɨhɨ déhe‑ndo, ndɨhɨ ñaní‑ndó, ndɨhɨ cúha‑ndo, te cani iní‑ndó sǎ cuěi na cùú‑ndó sǎ cuèndá‑í, te ducaⁿ te cuu ndisa‑ndo cuè ñáyiu tnàhá tnúhu ndɨhɨ‑í. ");
INSERT INTO milNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Te nchaa ñáyiu vá cánchǐcúⁿ nihnu ñaha xìi‑í cuèndá sá yùhú‑yu ndohó‑yu dàtná ndoho‑í, ñáyiu‑áⁿ vǎ cúǔ‑yu ñáyiu tnahá tnúhu ndɨhɨ‑í. ");
INSERT INTO milNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Te núu ɨɨⁿ nchòhó ná càni iní‑ndó dàcaa‑ndo ɨɨⁿ vehe ducúⁿ, ¿te náa ñá dɨ́ú dǐhna‑gá cada cuèndá‑ndó nǔu ndědau díhúⁿ cuu, ducaⁿ te cutnùní iní‑ndó nǔu tnahá díhúⁿ‑ndó càa vehe‑áⁿ àdi ñáhá? ");
INSERT INTO milNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Chi núu vá dúcáⁿ càda‑ndo, te na ngüǐta‑ndo tàusaha‑ndo te vá xǐnu cada‑ndo, te nchaa ñáyiu na cùndehe ñaha xii‑ndo, te cáháⁿ cuèhé‑yu cuèndá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Te cachí‑yu: “Tée‑ǎⁿ ní ngüíta‑dé dácàa‑dé ɨɨⁿ vehe te ñá ní ndàcu‑dé xínu”, cachí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Àdi te núu ɨɨⁿ tée yɨ̀ndaha ñaha xii ñáyiu cuìní‑dé nàá‑dé ndɨhɨ ɨngá tucu tée yɨ̀ndaha ñaha xii ñáyiu, ¿te náa ñá dɨ́ú dǐhna‑gá cada cuèndá‑dé te núu ndacu‑dé ndɨhɨ úxí mǐl cue sandàdú‑dé nàá‑güedé, ndɨhɨ ócó mǐl cue sandàdú ɨngá tucu tée yɨ̀ndaha ñaha xii ñáyiu cùu úhú iní tnáhá ndɨ̀hɨ‑dé‑ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Àdi te núu xìto‑dé sá vǎ ndácú‑dě ñá, te òré vátá cúyàtni ñaha‑gá tée cùu úhú iní tnáhá ndɨ̀hɨ‑dé‑áⁿ, te tendaha‑dě ɨɨⁿ tée quɨ́hɨ́ⁿ‑dé quɨ́hu‑dé tnúhu ndàhú núú těe‑áⁿ cuèndá sá vǎ nàá‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Te duha càháⁿ‑í chi núu nchòhó vá cádá ndèe iní‑ndó dàña‑ndo nchaa sá ndécú ndɨ̀hɨ‑ndo cuendá chitnahá ñáhá‑ndó xìi‑í, te vá cúú‑ndó cuè ñáyiu tnàhá tnúhu ndɨhɨ‑í. ");
INSERT INTO milNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Te ñɨ́ɨ́ chi ío váha, dico núu na ndùu víxiⁿ‑xi, ¿te nása‑gá cada‑o nàndɨ́hɨ‑o te núu ducaⁿ‑i? ");
INSERT INTO milNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Chi ñá túú‑gǎ nándɨ̌hɨ‑xi nì sá dàcá ñuhu, te nì sá dàcá saháⁿ, chi cuèndá‑nǎ dǎngoyo‑o. Te nchaa nchòhó ñáyiu ní xíndedóho tnúhu ní cáháⁿ‑í‑a xìni ñuhu‑xi ío váha cuáha‑ndo cuèndá —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Te cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú ndɨhɨ cue dava‑gá ñáyiu ndècu ichi cuehé ichi duha ní quexìó‑yu núú ndécú Jèsús cuèndá cundedóho‑yu tnúhu càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Te ní ngüíta cue tée cùu fariséú, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés xǐcáháⁿ cuèhé‑güedé cuèndá‑gá, te càchí‑güedé: —Tée‑a quèheⁿ cuendá‑dé ñáyiu ndècu ichi cuehé ichi duha, te xèxi ndɨhɨ ñaha‑dé xií‑yu —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Te Jèsús ní cani‑gá ɨɨⁿ cuèndú nàcuáa tecú tnùní‑güedé tnúhu‑gá, te xáhaⁿ‑gǎ xii‑güedé: ");
INSERT INTO milNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Ɨɨⁿ tée ndècu ɨɨⁿ ciendú mběé‑dě, te ní xíta ɨɨⁿ‑dɨ, te nchòhó sa cùtnuní iní‑ndó nàcuáa cada tée‑áⁿ, chi dàndóo‑dé cúmídícó sǎhúⁿ cúmí‑dɨ ɨɨⁿ yucu, te cúnúndúcú‑dě quɨtɨ ní xíta xíǎⁿ ndèé ndéé naníhí‑dě‑dɨ. ");
INSERT INTO milNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Te òré ní naníhí‑dě‑dɨ te ní dácáá‑dě‑dɨ chíó‑dě ní docó‑dé‑dɨ sá cúdɨ̌ɨ́ ìní‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Te òré ní nasáá‑dé vehe‑dé, te ní dátàcá‑dé nchaa cue tée càháⁿ ndɨhɨ‑dé, ndɨhɨ nchaa ñáyiu ndècu yatni ndɨhɨ‑dé, te ní xáhaⁿ‑dě: “Chí ná cùdɨ́ɨ́ ìní‑ó vìtna, chi ní naníhì‑í mběè‑í quɨtɨ ní xíta ni cùu”, cachí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Te yúhú càchí‑í sá ǐo‑gá cúdɨ̌ɨ́ ìní Yǎ Ndiǒxí ndɨhɨ cue espíritú xínú cuèchi núú‑gǎ nǔu ɨɨⁿ ñáyiu ndècu ichi cuehé ichi duha na ndìxi cuéchi iní‑yu cuèndá nchaa sá ñà túú vǎha quìdé‑yu ndècú‑yu te tnɨɨ́‑yu ichi‑gá, dàcúúxí cǔmídícó sǎhúⁿ cúmí ñǎyiu sa ní tuha ichi‑gá, chi ñá túú‑gǎ xíní ñùhu‑xi ndixi cuéchi iní‑yu chi sa ndècú‑yu ichi‑gá —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Te ní cani Jèsús ɨngá cuèndú núú‑güedě, te xáhaⁿ‑gǎ: —Ɨɨⁿ ñadɨ̀hɨ́ ndécú ndɨ̀hɨ‑aⁿ úxí díhúⁿ cuìxíⁿ, te ní dácuǐta‑aⁿ ɨɨⁿ te ní teñuhú‑aⁿ itɨ, te ní ngüíta‑aⁿ nàtɨhu‑aⁿ vehe, te súúní vǎha vǎha ní nanducu‑aⁿ nděé ní naníhí‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Te òré ní naníhí‑aⁿ, te ní dátàcá‑aⁿ nchaa ñáyiu dɨ̀hɨ́ càháⁿ ndɨhɨ‑aⁿ ndɨhɨ nchaa ñáyiu ndècu yatni ndɨhɨ‑aⁿ, te ní xáhaⁿ‑aⁿ: “Chí ná cùdɨ́ɨ́ ìní‑ó vìtna chi ní naníhì‑í díhùⁿ‑í sá nǐ xíta ni cùu”, cachí‑aⁿ xǎhaⁿ‑aⁿ xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Te yúhú càchí‑í sá dúcáⁿ ǐo cùdɨ́ɨ́ ìní nchaa espíritú xínú cuèchi núú Yǎ Ndiǒxí, núu ɨɨⁿ ñáyiu ndècu ichi cuehé ichi duha na ndìxi cuéchi iní‑yu cuèndá nchaa sá ñà túú vǎha quìdé‑yu, te tnɨɨ́‑yu ichi‑gá —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Te ní cani tucu Jèsús ɨngá cuèndú núú‑güedě, te xáhaⁿ‑gǎ: —Ɨɨⁿ tée ndècu úú déhe ducuⁿ‑dé, ");
INSERT INTO milNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","te tée lǐhli‑gá ní xáhaⁿ‑dě xii tǎtá‑dě: “Táu, taxi‑n tǎhú sǎ cúú cuèndá‑í”, càchí‑dé xǎhaⁿ‑dě. Te tǎtá‑dě‑áⁿ nǐ sáñaha‑dě ndɨ́ dɨ́ɨ́ⁿ nǔú‑güedě sá cúú cuèndá‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Te núú sàcú‑ni nduu, te déhe‑dé tée lǐhli‑gá‑áⁿ nǐ nadico‑dě nchaa sá nǐ sáñaha tǎtá‑dě, te ní xica‑dé cuáháⁿ‑dé ɨɨⁿ ñuú xícá, te yàcáⁿ ní tnɨɨ‑dé ɨɨⁿ ichi cuèhé ichi duha, te ní ndɨhɨ díhúⁿ‑dě ní dándóñùhu‑dé ndɨhɨ cue tée càháⁿ ndɨhɨ‑dé, ndɨhɨ nchaa ñáyiu dɨ̀hɨ́ xǐndecu ichi dɨ́ɨ́ ìní. ");
INSERT INTO milNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Te ní ndɨhɨ ndoo díhúⁿ‑dě ní dándóñùhu‑dé, te núú sàcú‑ni nduu ní sáá tnamá ñuú núú ndécú‑dě‑áⁿ, te ñá nìhí‑gá‑dé sá cáxí‑dě, te xìhí‑dé docó. ");
INSERT INTO milNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Núu ní xica‑dé cuáháⁿ ndúcú chìuⁿ‑dé núú ɨ̀ɨⁿ tée dɨu‑ni ñuú xíáⁿ, te tée‑áⁿ nǐ sáha chìuⁿ ñaha‑dé ɨɨⁿ xichi núú ñúhú‑dě coto‑dé cùchí. ");
INSERT INTO milNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Te súúní xìhí‑dé docó te cuìní‑dé caxi‑dé nchaa sá sǎha‑yu cùchí‑áⁿ ní cùu, dico ñá túú ní sǎñàhá‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Te uuⁿni ní sani váha iní‑dé, te ní cachí‑dé: “¡Ío cuéhé cue tée xìnu cuechi vehe tátà‑í te ío cuéhé sǎ xéxí‑güedě ndécú, te yúhú duha ndòho‑í docó iha! ");
INSERT INTO milNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Te ndacuɨ́ñɨ́‑í te núhú‑í vehe tǎtà‑í, te cúñaha‑ǐ xii‑dé: Táu, ñá túú ní quìde váha‑í núú Yǎ Ndiǒxí te ni ñà túú ní quìde váha‑í núú‑n, ");
INSERT INTO milNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","te ñá túú‑gǎ tàú‑í sá cúù‑í déhe‑n vìtna, te cada ñaha‑nǎ‑n xìi‑í dàtná ɨɨⁿ tée xìnu cuechi núú‑n”, duha ní sani iní‑dé cúñaha‑dě xii tǎtá‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Te sátá dúcáⁿ nǐ sani iní‑dé, te ní natnɨɨ‑dé ichi cuánuhú‑dé vehe tǎtá‑dě, te xica‑gǎ cuánuhú‑dé ní xiní ñáhá tǎtá‑dě xii‑dé te ní cundàhú iní ñáhá‑dě. Te xìnu tátá‑dě‑áⁿ nǐ sáháⁿ nútnahá ñáhá‑dě, te ní numi ñaha‑dě, te ío váha ní cáháⁿ ndɨhɨ ñaha‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Te ní xáhaⁿ děhe‑dé‑áⁿ xii‑dé: “Táu, ñá túú ní quìde váha‑í núú Yǎ Ndiǒxí te ni ñà túú ní quìde váha‑í núú‑n, te ñá túú‑gǎ tàú‑í sá cúù‑í déhe‑n vìtna”, cachí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","’Dico tǎtá‑dě‑áⁿ nǐ xáhaⁿ‑dě xii cue tée xìnu cuechi núú‑dě: “Chí quéñùhu ndɨ́hɨ‑ni dóó vǎha‑gá cuáha‑ndo děhe‑í‑a na cuìhnu‑dé, ndɨhɨ ɨɨⁿ dehé ná quɨ̀hɨ dɨ́quɨ́ ndáhá‑dě, ndɨhɨ chàú váha na quɨ̀hɨ‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Te quɨ́hɨ́ⁿ ngueheⁿ‑ndo ɨ̀ɨⁿ ndɨcutu numa quɨtɨ caváha‑gá, te cahni‑ndo‑dɨ, te na càda‑o vico, te na càxi‑o‑dɨ. ");
INSERT INTO milNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Chi déhe‑í‑a ní sani iní‑í sá nǐ xíhí‑dé ní cùu, te ñáhá chi ndècu vívú‑dě, te ní sani tucu iní‑í sá nǐ xíta‑dé ní cùu te ní nasáá méé‑dě”, càchí‑dé xǎhaⁿ‑dě xii cue tée xìnu cuechi núú‑dě‑áⁿ. Te ní ngüíta‑güedé ní quide‑güedé vico. ");
INSERT INTO milNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Te déhe‑dé tée sàcuéhé‑gǎ cuáháⁿ‑dé yucu, te òré cuándixi‑dé tá ndùu yatni‑dé vehe, te ní tecú dóho‑dé ìó yaá cúú vìco. ");
INSERT INTO milNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Te ní cana‑dé ɨɨⁿ tée xìnu cuechi, te ní xícáⁿ tnúhú‑dě núú‑dě ná cuèndá ducaⁿ ìó yaá. ");
INSERT INTO milNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Te tée xìnu cuechi‑áⁿ nǐ xáhaⁿ‑dě: “Ñaní‑n těe cuáháⁿ ní cùu ní nasáá‑dé, te tǎtá‑n nǐ táúchíúⁿ‑dě ní xíhí ɨɨⁿ ndɨcutu nùma quɨtɨ caváha‑gá cuèndá sá nǐ nasáá váha‑dé”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","’Dico ñaní‑dé tée sàcuéhé‑ǎⁿ nǐ cudééⁿ‑dě, te ní cachí‑dé sá vǎ ndɨ̌hu‑dé vehe cundecu‑dé vico‑áⁿ ní cùu, dico ní quee tǎtá‑güedě ní cáháⁿ ndàhú‑dé núú‑dě cuèndá ndɨ́hu‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Te ní xáhaⁿ‑dě xii tǎtá‑dě: “Táu, cundedóho váha saú‑n tnǔhu na càháⁿ‑í‑a, yúhú ío cuéhé cuǐá nǐ cuu xìnu cuechi‑í núú‑n, te ni ɨ̀ɨⁿ xito ñá túú quìde sáá iní‑í núú‑n, te ni ɨ̀ɨⁿ chivá lǐhli ñá túú tàxi‑n‑dɨ caxi dɨ́ɨ́ ìní‑í‑dɨ ndɨhɨ cue tée càháⁿ ndɨhɨ‑í. ");
INSERT INTO milNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Te vitna ní nasáá déhe‑n těe ní sáháⁿ ní dándóñùhu díhúⁿ‑n ndɨhɨ nchaa ñáyiu xǐndecu ichi dɨ́ɨ́ ìní. Te ní sahni‑n ɨ̀ɨⁿ ndɨcutu numa quɨtɨ caváha‑gá sá cuèndá‑dé”, càchí‑dé xǎhaⁿ‑dě xii tǎtá‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Te ní xáhaⁿ tǎtá‑dě xii‑dé: “Yòhó déhe‑í ducaⁿ‑ni ndècu ndɨhɨ ñaha‑n xii‑í, te nchaa sá ndécú ndɨ̀hɨ‑í cúú‑xí cuèndá‑n. ");
INSERT INTO milNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Te vitna dacuɨtɨ́í tàú‑xi sá cádá‑ó vìco, te cudɨ́ɨ́ ìní‑ó, chi ñaní‑n‑áⁿ nǐ quide‑í cuèndá sá nì xíhí‑dé ní cùu, te ñáhá chi ndècu vívú‑dě, te sa ní xíta‑dé ní cùu, te ní nasáá méé‑dě”, càchí‑dé xǎhaⁿ‑dě xii déhe‑dé tée sàcuéhé‑gǎ‑áⁿ —duha cuáháⁿ cuèndú ní cani Jèsús núú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Te Jèsús xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá: —Ní xíndecu ɨɨⁿ tée cuica, te ducaⁿ nǐ xíndecu ɨɨⁿ tée ní taxi tnùní ñáhá xìi cue tée ní xinu cuechi nǔú‑dě. Te tée‑áⁿ nǐ xiní ñáhá ñǎyiu dùhu‑dé díhúⁿ těe cùu patróóⁿ‑dě, te cuáháⁿ‑dé dándòñuhu‑dé, te ní xáhǎⁿ‑yu xii tée cùu patróóⁿ‑dě sá dúcáⁿ quìde‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Te tée cùu patróóⁿ‑dě‑áⁿ nǐ cana ñaha‑dě xii‑dé, te ní xáhaⁿ‑dě: “¿Ná cuèndá duha càháⁿ ñáyiu cuèndá‑n? Yáchí chi na tàxi cuendá‑n nchàa chiuⁿ ní quide‑n, chi vitna te vá táxí tnùní‑gá‑n cuè tée xìnu cuechi núù‑í”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Te tée tàxi tnuní ñáhá xìi cue tée xìnu cuechi‑áⁿ nǐ sani iní‑dé: “¿Te nása cada‑í vitna na quèhndé pàtróòⁿ‑í chìuⁿ‑í? Chi ñá cúndèe‑gá‑í cada‑í chìuⁿ vée, te cùcahaⁿ núù‑í cácáⁿ ndàhú‑í. ");
INSERT INTO milNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Dico duha cada‑í cuèndá queheⁿ cuèndá ñáhá ñǎyiu vehé‑yu òré ná quèhndé duuⁿ‑ná pàtróòⁿ‑í chìuⁿ‑í”, duha ní sani iní‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Te sátá dúcáⁿ te ní cana‑dé ɨɨⁿ ɨɨⁿ cue tée tàú núú pàtróóⁿ‑güedě. Te tée díhna ní xícáⁿ tnúhú‑dě núú‑dě, te xǎhaⁿ‑dě: “¿Ndèé dau tàú‑n nǔú pàtróóⁿ‑i?”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Te tée‑áⁿ nǐ xáhaⁿ‑dě: “Tàú‑í ɨɨⁿ cièndú bàrríl acìtí”, càchí‑dé xǎhaⁿ‑dě. Te tée tàxi tnuní ñáhá xìi cue tée xìnu cuechi‑áⁿ nǐ xáhaⁿ‑dě: “Iha náu recìú‑n‑á, te ndadúha ɨngá sá ǔdico úxí taxi‑n”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Te dǎtnùní ní xícáⁿ tnúhú tùcu‑dé núú ɨ̀ngá‑dé, te xǎhaⁿ‑dě: “Te yòhó, ¿ndèé dau tàú‑n‑í?”, càchí‑dé xǎhaⁿ‑dě. Te tée tàú‑áⁿ nǐ xáhaⁿ‑dě: “Ɨɨⁿ cièndú ngohnchi trìú tàú‑í”, càchí‑dé xǎhaⁿ‑dě. Te tée tàxi tnuní ñáhá xìi cue tée xìnu cuechi‑áⁿ nǐ xáhaⁿ‑dě: “Iha náu recìú‑n‑á, te cadúha ɨngá sá cùmídícó‑nǎ taxi‑n”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Te tée cùu patróóⁿ‑áⁿ nǐ cachí‑dé sá ǐo váha ñùhu dɨ́quɨ́ těe dùhu‑áⁿ nàcuáa cada‑dé cundecu váha‑dé. Te nchaa ñáyiu xǐndecu ichi cuèhé ichi duha, ío‑gá váha ñùhu dɨ́quɨ̌‑yu nàcuáa cadá‑yu cundecu váha‑yu ndɨhɨ nchaa ñáyiu cùndɨhɨ́‑yu dàcúúxí ñǎyiu ndècu ichi Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Te yúhú càchí‑í sá cádá‑ndó sǎ vǎha ndɨhɨ nchaa sá ndécú ndɨ̀hɨ‑ndo ní cuáha ñuyíú yǐcá cuěchi‑a, te ducaⁿ te coo cue tée ío váha tnahá tnúhu ndɨhɨ‑ndo, te òré ná ndɨ̀hɨ nchaa sá ìó ñuyíú‑a, te Yá Ndiǒxí queheⁿ cuèndá ñáhá‑gǎ xii‑ndo, te cundecu‑ndo ndɨ̀hɨ‑gá nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Te núu ɨɨⁿ tée quìde ndáá cuěi ɨɨⁿ chìuⁿ líhli na càda‑dé, te dɨu‑ni ducaⁿ quìde ndáá‑dé cuěi ɨɨⁿ chìuⁿ cahnu na cada‑dé. Dico tée ñá túú quìde ndáá, chi cuěi chìuⁿ líhli àdi chiuⁿ cahnu na cada‑dé dico ɨɨⁿ‑ni quìde‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Te núu nchòhó vá cádá‑ndó sǎ vǎha ndɨ̀hɨ nchaa sá nǐ cuáha ñuyíú yǐcá cuěchi‑a ña, te Yá Ndiǒxí vá táxí‑gǎ sá vǎha ndècu ndɨhɨ‑gá xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te núu vá cádá ndǎá‑ndó còto‑ndo nchaa sá táxí nùu tnaha ñáyiu‑ndo, te vá yǒo taxi sá ndúú tàhú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Te ni ɨ̀ɨⁿ tée xìnu cuechi vá ndácú‑dě cunu cuechi‑dě núú ǔú pàtróóⁿ, chi tée‑áⁿ cuu váha iní‑dé núú ɨɨⁿ pàtróóⁿ‑dě te tnɨɨ‑dé nchaa tnúhu càháⁿ pàtróóⁿ těe cùu váha iní‑dé núú‑xi‑áⁿ. Te núú ɨ̀ngá tucu pàtróóⁿ‑dě vá cúú vǎha iní‑dé, te ni vǎ tnɨ́ɨ́‑dě tnúhu càháⁿ pàtróóⁿ‑dě‑áⁿ. Te ducaⁿ sǎtnahá‑xi cùu nchohó chi vá ndácú‑ndó cùnu cuechi‑ndo núú Yǎ Ndiǒxí te cuhuⁿ iní‑ndó nchàa sá ìó ñuyíú‑a —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Te nchaa cue tée cùu fariséú ío ñùhu iní‑güedé nchaa sá ìó ñuyíú‑a, te xǐndedóho‑güedé nchaa tnúhu càháⁿ Jèsús, te ní cáháⁿ yíchí‑güedé cuèndá‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó cúú‑ndó cuè tée ío váha càháⁿ núú ñǎyiu cuèndá‑ni sá cuìní‑ndó cǎháⁿ váha‑yu cuèndá‑ndó, dico Yá Ndiǒxí xìní ndáá‑gá nàcuáa càa iní‑ndó ɨ̀ɨⁿ ɨɨⁿ‑ndo, te nchaa sá càchí cue ñáyiu ñuyíú‑a sá ǐo nàndɨ́hɨ, Yá Ndiǒxí dáquèe tɨ́hú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Te nchaa tnúhu ní chídó tnùní ndíi Moìsés cúnùu‑xi ni cuu, ndɨhɨ nchaa tnúhu ní chídó tnùní cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha. Dico cútnàhá ní ngüíta té Juàá tée ní xóo dacuàndute ñaha xii ñáyiu ní cáháⁿ‑dé tnúhu‑í, ndéé dàvá‑áⁿ ñà túú‑gǎ ní cùnuu nchaa tnúhu ní chídó tnùní ndíi Moìsés ndɨhɨ nchaa tnúhu ní chídó tnùní cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha. Te dɨu‑ni ndéé dàvá‑áⁿ nǐ quesaha ta tècú tnùní ñáyiu nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu, te vài ñáyiu ío sàni iní‑yu vitna nàcuáa cadá‑yu ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Te nchaa tnúhu ní chídó tnùní ndíi Moìsés ío ndáá càháⁿ‑xi, te ndɨ̌hɨ‑gá naa andɨu ndɨ̀hɨ ñuyíú dàcúúxí sǎ ndɨ́hɨ́ ɨ̀ɨⁿ ɨɨⁿ tnúhu‑áⁿ cada‑xi nàcuáa càháⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Te núu ɨɨⁿ tée na dàña tnaha‑dé, ndɨhɨ ñadɨ̀hɨ́‑dé, te tnándaha tucu‑dé ndɨhɨ ɨngá‑yu, te nèhé víhí quìde‑dé te núu ducaⁿ na càda‑dé, te tée na tnǎndaha ndɨhɨ ñaha ní dáñá yɨ̀ɨ‑xi, te dɨu‑ni ducaⁿ ñà túú cùu‑xi sá vǎha te núu ducaⁿ na càdá‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Te xǎhaⁿ tùcu‑gá xii‑güedé: —Ní xíndecu ɨɨⁿ tée cuica, te ní xóo cuihnu‑dé mee‑ni dǒó vǎha dóó vii càa, te nchaa nduu súúní vǎha ní xóo cada‑dé vico vehe‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Te ní xíndecu tucu ɨɨⁿ tée ndàhú ní xínani‑dě Lǎzarú, te tée‑áⁿ nǐ cuhú‑dé ní xíndeé‑dé nɨtùhú‑dé ndɨ́hyɨ, te ɨɨⁿ nduu ɨɨⁿ nduu ní xóo taxinucóo ñaha‑güedě xii‑dé yuyèhe tée cuica‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Te tée ndàhú‑áⁿ nǐ xóo cuú‑dé docó, te ní xóo cuiní‑dé caxi‑dé nchaa sá ñà túú‑gǎ ní xǒo yáha caxi tée cuica‑ǎⁿ, te ñá túú ní xǒo níhí‑dě. Te cuěi iná ní xóo quɨ́hɨ́ⁿ‑dɨ ní xóo nayuu‑dɨ nchaa núú ndɨ̌hyɨ ndèé‑dé‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Te ní sáá ɨɨⁿ nduu te ní xíhí tée ndàhú‑áⁿ, te cue espíritú xínú cuèchi núú Yǎ Ndiǒxí ndécá ñàha‑xi xii‑dé cuándaa núú ndécú tě Àbrahám cundecu‑dé. Te ní sáá nduu nǐ xíhí tée cuica‑ǎⁿ tnàhá‑dé, te ní chindúxi ñaha‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Te ní sáá‑dé núú xǐndecu nchaa ñáyiu ní xíhí ñá túú ní quìde ndáá núú Yǎ Ndiǒxí te xíáⁿ ǐo ndòho‑dé ndécú‑dě, te ní ndonehe núú‑dě te xica nǐ xiní‑dé té Àbrahám ndɨhɨ té Lǎzarú‑áⁿ xǐndecu‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Te níhi ní cáháⁿ‑dé, te xǎhaⁿ‑dě: “Yòhó tǎtá Àbrahám, cundàhú iní ñáhá xìi‑í, te cúñaha xìi té Lǎzarú ná dàndaxiⁿ‑dé dɨ́quɨ́ ndáhá‑dě, te na quìxi‑dé dandàxiⁿ‑dé yàa‑í, chi ío ndòho‑í ñúhù‑í núú ñùhú núú càyú‑a”, càchí‑dé xǎhaⁿ‑dě xii té Àbrahám. ");
INSERT INTO milNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Dico té Àbrahám ní xáhaⁿ‑dě: “Ndàhú yòhó ñaní tnáhà‑í, dandàcu iní sá ǐo váha ní xíndecu‑n ñùyíú, te té Lǎzarú ío ndàhú ní ndoho‑dé ní xíndecu‑dé. Te vitna ní nucúndecu váha‑dé iha, te yòhó ndóhó‑n vìtna. ");
INSERT INTO milNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Te ñá dɨ́ú‑ní sǎ xǐǎⁿ tucu, chi cuádava ndècu ɨɨⁿ déhvá cùnú ñúhú nèhu‑xi núú ndécú‑ó, te cuěi nchaa ñáyiu xǐndecu iha na càchí iní‑yu quixí‑yu núú ndécú‑ndó dico vá ndácǔ‑yu, te ni nchòhó vá ndácú‑ndó quìxi‑ndo núú ndécú‑ndɨ̌”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Te ní xáhaⁿ těe cuica‑ǎⁿ: “Te núu ducaⁿ te càháⁿ ndàhú‑í núú yòhó tǎtá Àbrahám vitna sá téndàha‑n té Lǎzarú ná quɨ̀hɨ́ⁿ‑dé vehe tǎtà‑í, ");
INSERT INTO milNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","chi ndècu úhúⁿ‑gá ñaní‑í, te na cǔñaha‑dě xii‑güedé sá vǎ cádá‑güedě dàtná ní quide‑í cuèndá sá vǎ quíxí‑güedě tnàhá‑güedé núú ndécù‑í ndóhò‑í‑a”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Te té Àbrahám ní xáhaⁿ‑dě: “Mee‑güedě ndécú ndɨ̀hɨ‑güedé nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ nchaa tnúhu ní chídó tnùní cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, te nchaa tnúhu‑áⁿ ná tnɨ̀ɨ‑güedé nàcuáa càháⁿ‑xi”, càchí‑dé xǎhaⁿ‑dě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Te ní xáhaⁿ tùcu tée cuica‑ǎⁿ: “Tǎtá Àbrahám, dico vá cádá cuèndá‑güedé nchaa tnúhu‑áⁿ, dico núu ɨɨⁿ ñáyiu ñá túú‑gǎ ndécú ñùyíú ɨɨⁿ ñáyiu ndècu ndɨhɨ‑n quɨ́hɨ́ⁿ‑yu cáháⁿ ndɨhɨ ñàhá‑yu xii‑güedé nàcuáa ndùu tnúhu váha, te ndixi cuéchi iní‑güedé nchaa sá ñà túú quìde váha‑güedé ndécú‑güedě, te cada váha‑güedé”, càchí‑dé xǎhaⁿ‑dě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Dico té Àbrahám ní xáhaⁿ‑dě: “Te núu ñá túú cuìní‑güedé tnɨɨ‑güedé tnúhu ní cáháⁿ ndíi Moìsés, ndɨhɨ tnúhu ní cáháⁿ cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha ña, te dɨu‑ni ducaⁿ càda‑güedé cuěi ɨɨⁿ ñáyiu ní xíhí ná ndòtó‑yu cúñàhá‑yu nàcuáa ndùu tnúhu váha, chi vá quɨ̀ndáá iní‑güedé”, càchí té Àbrahám xǎhaⁿ‑dě xii tée cuica‑ǎⁿ —càchí Jèsús xáhaⁿ‑gǎ xii cue tée cùu fariséú. ");
INSERT INTO milNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Te Jèsús ní xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá: —Dacuɨtɨ́í sǎ cóó cuè tée dacàháⁿ‑güedé ñáyiu cadá‑yu nándɨ sá cuèhé sá dúhá, ¡dico ndàhú ní cuu cue tée ducaⁿ na dàcaháⁿ ñáhá xìí‑yu cadá‑yu nándɨ sá cuèhé sá dúhá! ");
INSERT INTO milNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Chi váha‑gá sá nǔu na dàcutu ndeé ñáyiu ɨɨⁿ yúú yǒdó dǔcúⁿ‑güedě te dàquée ñàhá‑yu xii‑güedé xɨtɨ́ ndute làmár, te ñá dɨ́ú sǎ cúndècu‑güedé dacàháⁿ‑güedé ñáyiu cadá‑yu nándɨ sá cuèhé sá dúhá, cuěi ñáyiu ndàhú iní‑xi dandàhú‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Te ío quɨhɨ iní‑ndó cùndecu‑ndo. ’Te núu ɨɨⁿ ñaní tnáhá‑ndó quìde‑dé ɨɨⁿ sá ñà túú tàú‑dé cada‑dé sá cúú‑xí‑ndó te cáháⁿ‑ndó dǒho‑dé, te núu ní ndixi cuéchi iní‑dé sá ñà túú ní quìde váha‑dé, te cada càhnu iní‑ndó sǎ nǐ quide‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Te cuěi úsá xito na càda‑dé nándɨ sá ñà túú tàú‑dé cada‑dé sá cúú‑xí‑ndó ɨ̀ɨⁿ nduu, te núu na quìxi‑dé úsá xito núú‑ndó, te cachí‑dé sá vǎ dúcáⁿ‑gǎ cada‑dé, te xìni ñuhu‑xi cada cahnu iní‑ndó‑dě —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Te ní xáhaⁿ cuè tée xìca cuu ndɨhɨ Jesús xii‑gá: —Chindee ñàha xii‑ndɨ́ cuèndá ducaⁿ te quɨndáá‑gá iní‑ndɨ́ sá Yǎ Ndiǒxí ndácú‑gǎ quídé‑gǎ nchaa sá vǎha —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Te ní xáhaⁿ Jèsús: —Te núu nchòhó quɨ́ndáá ndisa iní‑ndó sǔúní cuědìcó luha lií dàtná cuìní‑ndó càa ɨɨⁿ ndɨ́quɨ́ⁿ yutnu nàni mostázá, te ducaⁿ te cuu cúñaha‑ndo xìi ɨɨⁿ yutnu: “Quene‑n ìha te quɨ́hɨ́ⁿ‑n cuìhnu‑n xɨtɨ́ làmár”, duha cúñaha‑ndo. Te ducaⁿ càda‑xi te núu na quɨ̀ndáá ndisa iní ñáhá‑ndó xìi‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Te xǎhaⁿ tùcu‑gá xii‑güedé: —Te núu ɨɨⁿ nchòhó ndécú ɨ̀ɨⁿ tée xìnu cuechi núú‑ndó, te cuáháⁿ‑dé yucu cuángada chìuⁿ‑dé, àdi cuáháⁿ‑dé yucu coto‑dé quɨtɨ, te òré ní nasáá‑dé vehe sá nǐ sáháⁿ‑dé yucu, te vá cǔñaha nchòhó cue tée cùu patróóⁿ‑dě xii‑dé: “Yáchí nehé caxi‑n dǐtá”, vá dúhá cǔñaha‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Chi nchòhó cue tée cùu patróóⁿ‑dě cúñaha‑ndo xìi‑dé: “Cundɨhɨ́ iní cada túha sá cúdìni‑í, te díhna‑gá‑í caxi‑í dítá te dǎtnùní caxi‑n”, duha cúñaha nchòhó cue tée cùu patróóⁿ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Te òré ná ndɨ́hɨ́ chìuⁿ ní táhú nchòhó cue tée cùu patróóⁿ cada tée xìnu cuechi núú‑ndó, te ñá túú tàú‑ndó ndàcáⁿ táhú‑ndó nǔú těe xìnu cuechi núú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Te duha càháⁿ‑í chi núu òré ná ndɨ̀hɨ nchaa chiuⁿ ní táhú Yǎ Ndiǒxí cada‑ndo, te cachí‑ndó: “Nchúhú cúú‑ndɨ̌ cue tée xìnu cuechi núú Yǎ Ndiǒxí, dico ñá túú tàú‑gá ndacáⁿ táhú‑gǎ núú‑ndɨ̌, chi mee‑ni chìuⁿ ní táhú‑gǎ ní quide‑ndɨ́”, duha cachí‑ndó —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Te ñùhu Jesús ichi cuáháⁿ‑gá ñuú Jerusàlén, te ní yáha‑gá núú ràyá distrìtú Sàmariá ndɨhɨ distrìtú Galìleá. ");
INSERT INTO milNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Te ta cùyatni‑gá ɨɨⁿ ñuú lǐhli cuáháⁿ, te ní sátnahá ñáhá ǔxí tnàhá cue tée cùhú xii‑gá, te tnàhá‑güedé cuéhé sǎ dátèhyú nihnu‑xi yɨquɨ cùñú‑ó dico xica lùha ní ngúnu tnɨ́ɨ‑güedé, ");
INSERT INTO milNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","te níhi ní cáháⁿ‑güedé, te xǎhaⁿ‑güedě xii Jèsús: —¡Mèstrú, cundàhú iní ñáhá xìi‑ndɨ́! —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Te òré ní xiní ñáhá Jèsús xii‑güedé, te ní xáhaⁿ‑gǎ: —Chí cuàháⁿ núú dǔtú ná cùndehe ñaha‑dé xii‑ndo —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. Te ní xica‑güedé cuáháⁿ‑güedé, te ichi‑ni ñùhu‑güedé cuáháⁿ‑güedé ní ndúha‑güedé cuéhé tnàhá‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Te nchaa‑güedé ní cutnùní iní‑güedé sá nǐ ndúha‑güedé, dico ɨɨⁿ‑ni‑dé ní nacuico‑dě, te ní ngüíta‑dé níhi ní cáháⁿ‑dé, te ní cachí‑dé sá ǐo càhnu cuu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Te ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú Jèsús, te ní nuu núú‑dě ndàa núú ñúhú ndàcáⁿ táhú‑dě núú‑gǎ. Te tée‑áⁿ cúú‑dě tée distrìtú Sàmariá. ");
INSERT INTO milNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Te Jèsús ní cachí‑gá: —Úxí tnàhá‑güedé ní ndúha cuéhé tnàhá‑güedé. ¿Te ndèé ndécú dàva‑gá‑güedé‑i? ");
INSERT INTO milNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Te náa ɨɨⁿdìi‑ni tée ɨngá ñuú‑a ní nacuico‑dě ndàcáⁿ táhú‑dě núú Yǎ Ndiǒxí, te càchí‑dé sá ǐo càhnu cuu‑gá ñǎ? —càchí‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Te ní xáhaⁿ‑gǎ xii tée‑áⁿ: —Ndacuɨ́ñɨ́ te núhú‑n, chi sa ní ndúha‑n cuěhé tnàhá‑n, chi ní sándáá iní‑n Yǎ Ndiǒxí —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Te cue tée cùu fariséú ní xícáⁿ tnúhú‑güedě núú Jèsús nǔu ná ama ngüíta Yá Ndiǒxí ndɨ́hu ndaha‑gǎ ñáyiu. Te ní xáhaⁿ‑gǎ: —Ñá túú nǎ cada‑xi ñuyíú quiní‑ndó cuèndá cutnùní iní‑ndó sǎ ndɨ̌hu ndaha ñàha Yá Ndiǒxí xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Te ni vǎ yǒo cachí: “Iha ndècu‑gá táxí tnùní‑gá, àdi yacáⁿ ndécú‑gǎ táxí tnùní‑gá”, chi tnuú‑ndó sà ndecu‑gá ndɨhɨ nchaa ñáyiu yɨ̀ndaha‑gá —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Te ní xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá: —Te nchòhó chi sáá nduu, te cachí iní‑ndó sǎ sǔúní cuědìcó ɨɨⁿ nduu quiní ñáhá‑ndó xìi yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, dico vá quìní ñáhá‑gǎ‑ndó xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Te coo ñáyiu cúñàhá‑yu xii‑ndo: “Iha ndècu‑gá, áⁿ yàcáⁿ ndécú‑gǎ”, quesàhá‑yu cúñàhá‑yu xii‑ndo. Dico vá quɨ̀ndáá iní‑ndó quɨ̌hɨ́ⁿ‑ndó ndɨ̀hɨ́‑yu núú càchí‑yu, te ni vǎ cání ìní‑ndó quɨ̌hɨ́ⁿ méé‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Chi dàtná cuìní‑ndó quìde‑xi oré sàá ndúté àndɨu, chi uuⁿni dàyehé‑xi nɨhìí ñuyíú, ducaⁿ càda‑xi nduu na quixi tucu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, te dàvá‑áⁿ quiní ñáhá nchàa‑ndɨ túhú ñáyiu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Dico díhna‑gá ndoho vìhi‑í, te daquèe tɨ́hú ñáhá ñǎyiu ñuyíú‑a xii‑í. ");
INSERT INTO milNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Te cadá‑yu dàtná ní quide ñáyiu ní xíndecu cútnàhá ní xíndecu té Nǒé, te dɨu‑ni ducaⁿ sǎtnahá‑xi cada nchaa ñáyiu ndècu vitna ndéé sáá nduu quìxi tucu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chi caxi‑ní‑yu, coho‑ní‑yu, te caca cuu‑ni cue tée xìca ndáhú, te tnǎndaha‑ní‑yu, chi ducaⁿ nǐ quidé‑yu dàvá‑áⁿ nděé ní sáá nduu cuǎnguee té Nǒé xɨtɨ́ bàrcú, te ní ngüíta‑xi ní cuuⁿ dáú nǐ ndaa ndute ñuyíú, te nchaá‑yu ní xíhí ní cáhá‑yu dàvá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Te dɨu‑ni ducaⁿ nǐ quide tucu ñáyiu cútnàhá ní xíndecu té Lǒt, chi xèxí‑yu xìhí‑yu, te sàáⁿ‑yu te nàdicó‑yu, te xǐxitú‑yu nándɨ sá xǐxitú‑yu, te nchaa cue tée xǐdácáá‑güedě vehe. ");
INSERT INTO milNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Te òré ní quee té Lǒt ñuú Sòdomá, te ní ngoyo ñuhú andɨu, te dàcá yúú sǔúní dìcó ní nduu ñuhú‑nǎ‑xi, te ní xíhí nchaandɨ túhú ñáyiu ñuú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Te dɨu‑ni ducaⁿ sǎtnahá‑xi cada ñáyiu na sàá nduu quìxi tucu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Te núu ɨɨⁿ ñáyiu càndodó‑yu dɨ́quɨ́ véhě‑yu nduu‑ǎⁿ, te nì vá ndɨ̌hu‑gá‑yu quehéⁿ‑yu ɨɨⁿ ndachìúⁿ‑yu canehé‑yu quɨ́hɨ́ⁿ, te ñáyiu cuáháⁿ yucu, te nì vá nùhú‑gá‑yu vehé‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Te chí dándàcu iní nàcuáa ní yáha ñadɨ̀hɨ́ té Lǒt. ");
INSERT INTO milNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Te nchaa ñáyiu cuìní dàcácu nihnu mee‑xi ñùyíú‑a ña, te cuíta nihnú‑yu, te nchaa ñáyiu na cùú sá cuèndá‑í, te naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Te na càchí tnúhu tucu‑í xii‑ndo sǎ ndùu‑áⁿ, te núu úú‑yu càa ɨɨⁿ núú xǐto, te ɨɨ́ⁿ‑yu ndanchitá‑yu ndaá‑yu andɨu, te ɨɨ́ⁿ‑yu quendóo. ");
INSERT INTO milNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Te núu úú ñáyiu dɨ̀hɨ́ nchícǒ‑yu ɨɨⁿ‑ni vèhe, te ɨɨ́ⁿ‑yu ndanchitá‑yu ndaá‑yu andɨu, te ɨɨ́ⁿ‑yu quendóo. ");
INSERT INTO milNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Te núu úú cue tée yɨ̀hɨ‑güedé yucu, te ɨɨⁿ‑dé ndànchita‑dé ndaa‑dé andɨu, te ɨɨⁿ‑dé quendóo —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Te sá dúcáⁿ nǐ cáháⁿ‑gá nǔu ní xícáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Mèstrú, ¿te ndèé ducaⁿ càda‑xi‑i? —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. Te ní xáhaⁿ‑gǎ: —Te nchòhó xìní‑ndó sǎ ncháá nǔú yúcú yɨ̀quɨ cuñú ní xíhí, te yàcáⁿ tàcá cue ndɨxíí xéxí‑güèdɨ —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Te Jèsús ní cani‑gá ɨɨⁿ cuèndú núú‑güedě cuèndá sá vǎ ná tǔhú iní‑güedé cáháⁿ ndɨhɨ‑güedé Yǎ Ndiǒxí nchaa‑ni òré. ");
INSERT INTO milNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Te xáhaⁿ‑gǎ: —Ɨɨⁿ ñuú ndécú ɨ̀ɨⁿ juéxí, te ni ñà túú sàndáá iní‑dé Yǎ Ndiǒxí, te ni ɨ̀ɨⁿ tnúhu xáhaⁿ ñǎyiu ñá túú cuìní‑dé cada cuèndá‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Te dɨu‑ni ñuú‑áⁿ ndécú tùcu ɨɨⁿ ñadɨhɨ́ ñaha quèé, te ní sáháⁿ‑aⁿ càháⁿ ndàhú‑aⁿ núú juěxí‑áⁿ cuèndá cada ndáá‑dé ɨɨⁿ cuéchi. ");
INSERT INTO milNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Te tɨtnɨ́ xito ní cuu sàháⁿ‑aⁿ càháⁿ ndàhú‑aⁿ núú‑dě te ñá túú cuìní‑dé cada cuèndá‑dé tnúhu càháⁿ‑aⁿ ni cùu, te ndéé núú ñà cúú‑gǎ te ní sani iní‑dé: “Te cuěi ñá túú sàndáá iní‑í Yǎ Ndiǒxí, te ni ñà túú quìde cuendá‑í nchaa tnúhu càháⁿ ñáyiu cada‑í, ");
INSERT INTO milNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","dico na càda ndáá‑í cuèndá ñaha quèé‑a ndɨhɨ ñáyiu cùu úhú iní tnáhá ndɨ̀hɨ‑aⁿ, chi vá cúndèe‑gá iní‑í nuu núu quixi‑aⁿ dasàtú iní ñáhá xìi‑í”, duha ní sani iní tée cùu juéxí‑áⁿ —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Te ní xáhaⁿ tùcu‑gá xii‑güedé: —Cada cuèndá‑ndó nàcuáa ní sani iní juěxí tée cuihna ìní‑xi‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Te Yá Ndiǒxí ío chìndee‑gá nchaa ñáyiu ní cáháⁿ‑gá cundecu ndɨhɨ‑gá, chi cuěi nduu cuěi niú càháⁿ ndɨhɨ ñàhá‑yu xii‑gá, te vá cúyàa‑gá nachinaa‑gá nchaa sá quídé ñàha nchaa ñáyiu cùu úhú iní ñáhá xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Te ío ndɨ̌hɨ ducaⁿ càda‑gá. Te òré ná quìxi yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, ¿te náa naníhí‑gǎ‑í ñáyiu sàndáá ndisa iní Yǎ Ndiǒxí‑ǎⁿ? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Te Jèsús ní cáháⁿ‑gá núú ñǎyiu nàcuáa quìde ñáyiu sàni iní sá ǐo quìde ndáá te dàquee tɨ́hǔ‑yu tnàha ñáyiú‑yu, te xáhaⁿ‑gǎ xií‑yu: ");
INSERT INTO milNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Úú cue tée cuáháⁿ‑güedé veñúhu càhnu sá ǐo cùnuu cáháⁿ ndɨhɨ‑güedé Yǎ Ndiǒxí, te ɨɨⁿ‑dé cúú‑dě tée cùu fariséú, te ɨngá‑dé cúú‑dě tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú. ");
INSERT INTO milNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Te tée cùu fariséú‑áⁿ nútnɨ̌ɨ‑dé càháⁿ ndɨhɨ‑dé Yǎ Ndiǒxí, te xǎhaⁿ‑dě xii‑gá: “Yòhó Dútú Ndiǒxí ndàcáⁿ táhù‑í núú‑n, chi ñá túú quìde‑í dàtná quídé dàva‑gá‑güedé, chi dùhu‑güedé, càháⁿ ndɨhɨ‑güedé ñadɨ̀hɨ́ te ñá dɨ́ú ñàdɨhɨ́‑güedé cúǔ‑yu, te nándɨ‑gá nchaa sá cuèhé sá dúhá quìde‑güedé, te ni ñà túú quìde‑í dàtná quídé těe cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú ndécú ìha. ");
INSERT INTO milNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Chi yúhú ñá túú tnàhí ná xéxì‑í úú nduu xɨtɨ́ samàná cuèndá sá càháⁿ ndɨhɨ ñaha‑ǐ xii‑n, te nchaa sá nìhí‑í te càhu‑í úxí xichi, te ɨɨⁿ xichi tàxi‑í xii‑n”, càchí‑dé xǎhaⁿ‑dě xii Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dico tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú‑áⁿ chi xica lùha nutnɨ́ɨ‑dé, te ni lùha ñá túú cùyɨɨ‑dé ndonehe núú‑dě andɨu cuèndá sá ndíxí cuěchi iní‑dé nchaa sá ñà túú vǎha quìde‑dé, te ndèdí ndaha‑dé pèchú‑dé sá ndɨ̀hú iní‑dé, te xǎhaⁿ‑dě xii Yá Ndiǒxí: “¡Yòhó Dútú Ndiǒxí cundàhú iní ñáhá xìi‑í, chi ío cuéhé sǎ ñà túú vǎha quìde‑í núú‑n!”, càchí‑dé xǎhaⁿ‑dě xii Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Te na càchí tnúhu‑í xii‑ndo sǎ těe cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu‑áⁿ nǐ tedóho Yá Ndiǒxí nchaa tnúhu ní cáháⁿ‑dé, te ní quide càhnu iní‑gá nchaa sá ñà túú vǎha ní quide‑dé, te cuánuhú‑dé vehe‑dé. Te tée cùu fariséú‑áⁿ ñà túú ní tèdóho ñaha Yǎ Ndiǒxí xii‑dé. Chi nchaa ñáyiu na càda cahnu mee‑xi ñuyíú‑a te vá cúǔ‑yu ñáyiu cùnuu, te nchaa ñáyiu ñá túú quìde cahnu mee‑xi, ñáyiu‑áⁿ cunùú‑yu —càchí Jèsús xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Te ɨɨⁿ ǔú ñáyiu ndècá‑yu landú lǐhli cuáháⁿ núú Jèsús chi cuìní‑yu sá téndàha ñaha‑gá xii‑güexi, te òré ní xiní cue tée xìca cuu ndɨhɨ‑gá sá ndécǎ‑yu landú‑áⁿ cuǎháⁿ núú‑gǎ, te ní ngüíta‑güedé ténàá ñáhá‑güedě xií‑yu, te xǎhaⁿ‑güedě sá vǎ dúcáⁿ càdá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Dico Jèsús ní cana ñaha‑gǎ xii‑güedé, te ní xáhaⁿ‑gǎ: —Chí dáñá ná quìxi nahi landú lǐhli‑áⁿ nǔù‑í‑a, te vá càdɨ́‑ndó ìchi‑güexi, chi dàtná cúú vǎha iní cue landú lǐhli‑áⁿ ducaⁿ cùu váha iní cue ñáyiu yɨ̀ndaha ñaha Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nǔu vá quɨ̀ndáá iní ñáhá‑ndó dàtná quídé dàva landú lǐhli sàndáá iní ñáhá xìi‑í, te vá ndɨ̌hu ndaha ñàha Yá Ndiǒxí xii‑ndo, te vá ndúú tǎhú‑ndó cùndecu‑ndo ndɨhɨ‑gá nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Te ɨɨⁿ tée cùnuu ní xícáⁿ tnúhú‑dě núú Jèsús, te xǎhaⁿ‑dě xii‑gá: —Yòhó Mèstrú, cùu‑n tée ío váha iní‑xi, te cuìní‑í nǔu vá cúndèe iní‑n càchí tnúhu‑n nǎ cúú sǎ vǎha cada‑í cuèndá nduu táhù‑í cundecu‑í ndɨhɨ Yá Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —¿Te cùtnuní iní‑n nàcuáa ndùu tnúhu càháⁿ‑n sǎ yǔhú váha iní‑ǎⁿ? Chi ɨɨⁿdìi díí‑ni Yá Ndiǒxí váha iní‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Te yòhó xìní‑n nàcuáa ní cachí Yǎ Ndiǒxí cada ñáyiu, te duha ní cachí‑gá: “Nchòhó cue tée vá càháⁿ ndɨhɨ‑ndo ñàdɨhɨ́ te núu ñá dɨ́ú ñàdɨhɨ́‑ndó cùú‑yu, te ducaⁿ‑ni nchòhó cue ñáyiu dɨ̀hɨ́ tucu vá càháⁿ ndɨhɨ‑ndo těe te núu ñá dɨ́ú yɨ̀ɨ‑ndo cuu‑güedé, te vá cáhní‑ndó tnàha ñáyiu‑ndo, te ni vǎ dúhú‑ndó sǎ ndécú ndɨ̀hɨ́‑yu, te ni vǎ dácàcu‑ndo cuéchi neñùú sá cúú‑xí tnàha ñáyiu‑ndo, te canehe‑ndo sǎ yɨ́ñùhu núú tǎtá‑ndó ndɨ̀hɨ núú nǎná‑ndó”, duha ní cachí Yǎ Ndiǒxí cada ñáyiu —càchí Jèsús xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Te tée‑áⁿ nǐ xáhaⁿ‑dě xii‑gá: —Nchaa xíǎⁿ ní ngüíta‑í quídè‑í ndéé cútnàhá cúú làndú‑í —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Dico cùmání ɨ̀ngá núú sǎ cádá‑n, vitna te quɨ́hɨ́ⁿ‑n te dico‑n nchàa sá ndécú ndɨ̀hɨ‑n, te díhúⁿ‑n cuǎha táhú‑n cuè ñáyiu ndàhú, te ducaⁿ te nduu táhú‑n cùndecu váha‑n nǔú ndécú Yǎ Ndiǒxí táxí tnùní‑gá, te na yǎha ducaⁿ càda‑n te quixi‑n chìtnahá ñáhá‑n xìi‑í —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Te sá dúcáⁿ nǐ xáhaⁿ Jèsús xii‑dé, te ío ní cundɨ̀yɨ́‑dé, chi ío cuica‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Te sá nǐ xiní ñáhá Jèsús xii‑dé cúndɨ̀yɨ́‑dé, núu ní cachí‑gá: —¡Ío úhú quɨ́ndáá iní ñáyiu cuica Yǎ Ndiǒxí cuèndá ndɨ́hu ndaha ñàha‑gá xií‑yu! ");
INSERT INTO milNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Te yáchí‑gá yáha ɨɨⁿ càméyu yaú ɨɨⁿ yɨquɨ tɨ̀cú dàcúúxí sǎ quɨ̀ndáá iní ɨɨⁿ ñáyiu cuica Yǎ Ndiǒxí cuèndá ndɨ́hu ndaha ñàha‑gá xií‑yu —duha ní cachí‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Te nchaa ñáyiu ní tecú dóho‑xi tnúhu ní cáháⁿ‑gá ní xáhǎⁿ‑yu xii‑gá: —¿Te yoo naníhí tàhú te núu ducaⁿ vàíⁿ? —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Te Jèsús ní xáhaⁿ‑gǎ xií‑yu: —Cue ñáyiu ñuyíú‑a chi vá ndácǔ‑yu ná cadá‑yu nàcuáa ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu, dico mee‑gǎ chi ndacu‑gá ndɨ́hu ndaha ñàha‑gá xií‑yu chi nchaa sá vǎha ndàcu‑gá quídé‑gǎ —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Te té Pèlú ní xáhaⁿ‑dě xii‑gá: —Nchúhú ní dándǒo‑ndɨ́ nchaa sá ndécú ndɨ̀hɨ‑ndɨ́, te ní tuha ñaha‑ndɨ̌ xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Te ní xáhaⁿ‑gǎ xii ñáyiu: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ ncháá ñǎyiu na dàndóo vehe‑xi, àdi tátá‑xi, nǎná‑xi, ñaní‑xi, cúha‑xi, ñadɨ̀hɨ́‑xi, déhe‑xi cuèndá sá cuìní‑yu ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu, ");
INSERT INTO milNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","te ío‑gá cuéhé sǎ cuǎñaha‑gǎ xií‑yu cundecu ndɨhɨ́‑yu, te ñá dɨ́ú‑ní xǐǎⁿ, chi tnàhá nduu táhǔ‑yu cundecu ndɨhɨ ñàhá‑yu xii‑í nɨ caa nɨ quɨ́hɨ́ⁿ ná sàá nduu —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Te Jèsús ní taudɨ̀ɨⁿ‑gá ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá tnuú ñáyiu, te ní xáhaⁿ‑gǎ xii‑güedé: —Vitna te quɨ́hɨ́ⁿ‑ó ñùú Jerusàlén, chi yàcáⁿ cada‑xi nchaa nàcuáa sa ní chídó tnùní cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nàcuáa yáha yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chi cuáha cuèndá ñáhá‑güedě xii‑í núú cuè tée ñá túú cùu cue tée isràél, te cudɨ́quɨ́ ndeé ñáhá‑güedě xii‑í, te cúcuèhé ñáhá‑güedě, te tɨú dɨɨ́ ñáhá‑güedě xii‑í. ");
INSERT INTO milNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Te caniha‑güedě ndɨhɨ ñɨɨ, te dǎtnùní cahni ñaha‑güedě xii‑í, dico nduu úní sá cùú‑í te ndoto‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Dico ni ɨ̀ɨⁿ tnúhu ní cáháⁿ‑gá ñá túú ní tècú tnùní‑güedé, chi ío yɨ̀dáhu tnúhu ní cáháⁿ‑gá nǔu xíǎⁿ ni ɨ̀ɨⁿ ñá túú ní tècú tnùní‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Te òré tá cùyatni Jesús ñuú Jerìcó cuáháⁿ, te yuhu ìchi cuáháⁿ‑gá‑áⁿ núcǒo ɨɨⁿ tée cuàá xìcáⁿ ndàhú‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Te òré ní tecú dóho‑dé xǐcáháⁿ vài ñáyiu xǐyáha‑yu, te ní xícáⁿ tnúhú‑dě núú ñǎyiu ndècu ndɨhɨ‑dé ná cuèndá ducaⁿ vàí‑yu yáha. ");
INSERT INTO milNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Te ní xáhǎⁿ‑yu sá Jèsús tée ñuú Nazàrét ñúhú‑dě ichi. ");
INSERT INTO milNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Te níhi ní cáháⁿ‑dé, te xǎhaⁿ‑dě xii‑gá: —¡Jèsús ñaní tnáhá ndǐi Dàvií, cundàhú iní ñáhá xìi‑í! —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Te ñáyiu xǐxódó núú nǔú Jèsús ní tenàá ñáhǎ‑yu xii‑dé, te xǎhǎⁿ‑yu sá ná càdɨ́‑dé yuhu‑dé dico uuⁿ‑gá níhi ní cáháⁿ‑dé xǎhaⁿ‑dě xii‑gá: —¡Yòhó tée cùu ñaní tnáhá ndǐi Dàvií, cundàhú iní ñáhá xìi‑í! —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Te Jèsús ní ngüɨ́ñɨ́‑gá, te ní táúchíúⁿ‑gǎ ní sángueheⁿ ñaha cuè tée ndɨhɨ‑gá. Te òré ní quexìo‑dé núú‑gǎ, te ní xícáⁿ tnúhú‑gǎ núú‑dě, te xáhaⁿ‑gǎ: ");
INSERT INTO milNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ná cuìní‑n càda ñaha‑í xii‑n‑i? —càchí‑gá xáhaⁿ‑gǎ xii‑dé. Te tée cuàá‑áⁿ nǐ xáhaⁿ‑dě: —Mèstrú, cuìní‑í cada tátna‑n nǔù‑í cuèndá cundehe‑ǐ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Te Jèsús ní xáhaⁿ‑gǎ: —Sa ní ndúha núú‑n chi ní sándáá iní‑n Yǎ Ndiǒxí —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Te òré‑ni‑áⁿ nǐ ndúha núú‑dě, te ní chinchícúⁿ‑dé Jèsús, te ní cachí‑dé sá ǐo càhnu cuu Yá Ndiǒxí. Te nchaa ñáyiu ní xiní nàcuáa ní cuu ní ndúha núú‑dě tnàhá‑yu ní cachí‑yu sá ǐo càhnu cuu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Te Jèsús ní sáá‑gá ñuú Jerìcó, te ta yǎha‑gá xɨtɨ́ ñuú‑áⁿ cuǎháⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Te ñuú‑áⁿ ndécú ɨ̀ɨⁿ tée cuica nàni‑dé Zàqueú, te cùnuu‑dé táxí tnùní‑dé cue tée cùndɨhɨ‑dé, cue tée cuihna ìní‑xi quìde cobrá ñáhá xìi ñáyiu cuèndá impuèstú. ");
INSERT INTO milNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Te tée‑áⁿ cuìní‑dé quiní‑dé Jèsús òré‑áⁿ ní cùu te ñá ní ndàcu‑dé, chi ío cuéhé ñǎyiu, te ñá túú dùcúⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Te xìnu‑dé ní ngódó núú‑dě te ní sáá‑dé dɨ́quɨ́ ɨɨⁿ yutnu sìcómorú nùtnɨ́ɨ yatni yuhu ìchi núú yǎha Jèsús cuèndá cuìní‑dé quiní ñáhá‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Te òré tá yǎha Jèsús xíáⁿ, te ní ndonehe núú‑gǎ dɨ́quɨ́ yutnu núú cándòdo‑dé‑áⁿ, te ní xáhaⁿ‑gǎ xii‑dé: —Zàqueú, tanùu ndɨ́hɨ dɨ́quɨ́ yutnu‑áⁿ, chi tnavíí quexìo‑í vehe‑n ndètatú‑í —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Te té Zàqueú‑áⁿ nǐ nuu ndɨ̌hɨ‑dé dɨ́quɨ́ yutnu‑áⁿ, te ío ní cudɨ́ɨ́ ìní‑dé ní queheⁿ cuèndá‑dé Jèsús vehe‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Te sá nǐ xiní ñáyiu ní quexìo Jesús vehe‑dé, te nchaá‑yu ní ngüíta‑yu càháⁿ cuèhé‑yu cuèndá‑gá, te xǐtnàhá‑yu: —Tée‑a cuánguɨhu‑dé vehe ɨɨⁿ tée ndècu ichi cuehé ichi duha —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Te té Zàqueú‑áⁿ nǐ ndacuɨ́ñɨ́‑dé tnuú‑yu, te xǎhaⁿ‑dě xii Jèsús: —Yòhó Mèstrú, na cuǎha‑í ñáyiu ndàhú cuádava nchaa sá ndécú ndɨ̀hɨ‑í. Te núu yoo ní dándàhú‑í ní dúhù‑í, te codo ǔní‑gá tnàhá sá nǐ dúhù‑í‑yu nacuáñaha‑ǐ xií‑yu —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Te Jèsús ní xáhaⁿ‑gǎ xii té Zàqueú: —Vitna ní naníhí tàhú‑n ndɨ̀hɨ nchaa ñáyiu xǐndecu vehe‑n, chi tnàhá‑n cùu‑n ñaní tnáhá ndǐi Àbrahám. ");
INSERT INTO milNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Te yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo véxi‑í nándùcu‑í ñáyiu ní xíta nihnu cuèndá dàcácu nihnu‑í‑yu núú ùhú núú ndàhú —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Te nchaa ñáyiu‑áⁿ nǐ sani iní‑yu sá ndɨ̌hɨ‑ni ndɨ́hu ndaha ñàha Yá Ndiǒxí xií‑yu cuèndá sá nǐ cuyatni Jèsús ñuú Jerusàlén, te xíǎⁿ nǔu ní ngüíta Jèsús ní cani‑gá ɨɨⁿ cuèndú núǔ‑yu cuèndá tecú tnùní váha‑yu tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Te xáhaⁿ‑gǎ xií‑yu: —Ní xíndecu ɨɨⁿ tée cùu ñaní tnáhá ñǎyiu cùnuu, te cuáháⁿ‑dé ɨngá ñuú xícá cuèndá yàcáⁿ cuáha ñaha‑güedě chìuⁿ coo‑dé, te dǎtnùní ndixi‑dé quɨndaha‑dě tɨtnɨ́ ñuú. ");
INSERT INTO milNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Te cùmání‑gǎ quee‑dé quɨ́hɨ́ⁿ‑dé, te ní cana‑dé úxí cue tée xìnu cuechi núú‑dě, te ní sáñaha‑dě ndɨ́ dɨ́ɨ́ⁿ nǔú‑güedě ɨɨⁿ caa ɨɨⁿ caa díhúⁿ cuàáⁿ, te ní xáhaⁿ‑dě: “Chí cádá ndǎhú ndɨhɨ díhúⁿ‑ǎⁿ ndèé ná sàá nduu nàsáá‑í”, càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dico nchaa ñáyiu ñuú quɨndaha‑dě‑áⁿ ñà túú tnàhá iní‑yu sá quɨ́ndàha ñaha‑dé, núu ní tendàhá‑yu cue tée nèhe tnúhu cuáháⁿ núú cuè tée cuáñaha chìuⁿ coo‑dé‑áⁿ, te ní xáhǎⁿ‑yu sá cǔñaha‑güedě sá ñà túú tnàhá iní‑yu sá těe‑áⁿ quɨndaha ñàha‑dé xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Dico dacuɨtɨ́í sǎ nǐ sáha‑güedé tée‑áⁿ chìuⁿ coo‑dé sá dɨ́ú‑dě quɨndaha‑dě ñáyiu nchaa ñuú‑áⁿ, te ní nacuico‑dě cuánuhú‑dé ñuú‑dé. Te òré ní nasáá‑dé vehe‑dé, te ní tendaha‑dě ɨɨⁿ tée ní sánúcana ñaha xìi cue tée xìnu cuechi núú‑dě, cue tée ní dándǒo ndaha‑dě díhúⁿ cuèndá cácáⁿ tnúhú‑dě núú‑güedě ɨɨⁿ ɨɨⁿ‑güedé nǔu ndèé dau ní chídó‑xí dɨ̌quɨ́ dǐhúⁿ sǎ nǐ dándǒo ndaha ñàha‑dé‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Te tée ní ndèxio díhna xǎhaⁿ‑dě: “Pàtróóⁿ, ní quide‑í ndáhú ndɨhɨ díhúⁿ‑n sǎ nǐ dándǒo ndaha ñàha‑n xii‑í, te sá ɨ́ɨ́ⁿ nǐ taxi‑n te ní chídó‑xí ǔxí‑gá tnàhá te náu‑a naqueheⁿ cuèndá‑n”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Te tée cùu patróóⁿ‑dě‑áⁿ nǐ xáhaⁿ‑dě: “Ío váha tée xìnu cuechi cuu‑n chi ío váha ní quide‑n, te sá nǐ quide váha‑n ndɨ̀hɨ sacú díhúⁿ sǎ nǐ dándǒo ndaha ñaha‑ǐ xii‑n, te xíǎⁿ nǔu yúhú càchí‑í sá táxí tnùní‑n ǔxí ñuú vitna”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Te ní ndexìo ɨngá‑dé, te ní xáhaⁿ‑dě: “Pàtróóⁿ, ní quide‑í ndáhú ndɨhɨ díhúⁿ‑n sǎ nǐ dándǒo ndaha ñàha‑n xii‑í, te sá ɨ́ɨ́ⁿ nǐ taxi‑n te ní chídó‑xí ǔhúⁿ‑gá tnàhá te náu‑a naqueheⁿ cuèndá‑n”, càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Te ní xáhaⁿ těe cùu patróóⁿ‑dě‑áⁿ xii‑dé: “Te yòhó taxi tnùní‑n ǔhúⁿ ñuú”, càchí‑dé xǎhaⁿ‑dě xii tée xìnu cuechi‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Te dǎtnùní ní ndexìo tucu ɨngá‑dé, te xǎhaⁿ‑dě: “Pàtróóⁿ, náu díhúⁿ‑n‑á, te naqueheⁿ cuèndá‑n chi ní taxúha‑í ní chidúcúⁿnuu‑í ɨɨⁿ pàñú te ñá túú ní quìde‑í ndáhú ndɨhɨ díhúⁿ‑n, ");
INSERT INTO milNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","chi ní yùhú ñáhà‑í xii‑n, chi cùu‑n ɨɨⁿ tée díi, te nàqueheⁿ‑n ɨɨⁿ sá ñà túú ní tàxi ndecu‑n, te nàtahu‑n ɨɨⁿ xichi núú ñà túú ní chìhi‑n tatá”, càchí‑dé xǎhaⁿ‑dě xii pàtróóⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Te ní xáhaⁿ pàtróóⁿ‑dě xii‑dé: “Yòhó cúú‑n ɨ̀ɨⁿ tée cuihna ìní‑xi xìnu cuechi núù‑í, te dɨu‑ni nchaa tnúhu càháⁿ‑n‑ǎⁿ càchí tnùní‑xi nàcuáa cuu ndáá cuéchi‑n. Te núu sàni iní‑n sǎ cúù‑í ɨɨⁿ tée díi, te nàqueheⁿ‑í ɨɨⁿ sá ñà túú ní tàxi ndecu‑í, te nàtahu‑í ɨɨⁿ xichi núú ñà túú nǐ chihi‑í tatá, ");
INSERT INTO milNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","te núu ducaⁿ ña, ¿te ná cuèndá ñá túú ní càhu iní‑n dàsaⁿ nuu‑n díhúⁿ nǐ taxi‑í, te cúñaha‑n chǎhu‑yu dɨ́quɨ́‑xi, te òré ná nàsáá‑í vehe‑í, te sa ngódó lùha‑gá dɨ́quɨ́‑xi naqueheⁿ cuèndá‑í ní cùu‑i?”, cachí‑dé xǎhaⁿ‑dě xii tée xìnu cuechi‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Te ní xáhaⁿ těe cùu patróóⁿ‑áⁿ xii cue tée xǐndecu xíáⁿ: “Chí quéndèé díhúⁿ cuàáⁿ néhé těe‑a, te cuáha‑ndo těe nèhe úxí tucu díhúⁿ cuàáⁿ‑áⁿ”, càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Te ní xáhaⁿ‑güedě: “Pàtróóⁿ, dico sa nèhe‑dé úxí díhúⁿ cuàáⁿ”, càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Te ní xáhaⁿ těe cùu patróóⁿ‑áⁿ: “Na càchí tnúhu‑í xii‑ndo sǎ cuè ñáyiu ìó xii‑xi te níhí‑gǎ‑yu cundecu ndɨhɨ́‑yu, te cue ñáyiu sacú ndécú ndɨ̀hɨ cuita ndɨhɨ nihnu nchaa sá ndécú ndɨ̀hɨ́‑yu”, càchí tée cùu patróóⁿ‑áⁿ xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Te xǎhaⁿ tùcu‑dé xii‑güedé: “Nchaa ñáyiu cùu úhú iní ñáhá xìi‑í ñá tnàhá iní‑yu quɨndaha‑ǐ‑yu, te chí cándècá‑yu taquìxi iha, te cahni‑ndǒ‑yu núù‑í‑a”, càchí tée cùu patróóⁿ‑áⁿ xǎhaⁿ‑dě xii‑güedé —duha cuáháⁿ cuèndú ní cani Jèsús núú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Te sátá dúcáⁿ nǐ cáháⁿ‑gá, te ní nucúhuⁿ ichi‑gá cuáháⁿ‑gá ñuú Jerusàlén. ");
INSERT INTO milNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Te òré sa ní cuyatni‑gá ñuú Bètfagé, ndɨhɨ ñuú Bètaniá te xíáⁿ cáá yùcu nani Olívú, te ní xáhaⁿ‑gǎ xii úú cue tée xìca cuu ndɨhɨ‑gá: ");
INSERT INTO milNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Chí cuàháⁿ ñuú cáá yàtni yacáⁿ, te òré quexìo‑ndo yacáⁿ, te naníhí‑ndó ɨ̀ɨⁿ búrru ndètnɨ́ɨ‑dɨ, te vátá yǒo ɨɨⁿ‑gá codo ñàha xii‑dɨ, te nandaxi‑ndo‑dɨ te candeca‑ndo‑dɨ quìxi. ");
INSERT INTO milNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te núu yoo na càcáⁿ tnúhu núú‑ndó nǎ cuèndá nándàxi‑ndo‑dɨ, te cúñaha‑ndo xìí‑yu sá yǔhú Yaá xícá cùu ndɨhɨ‑ndo xini ñuhu‑í‑dɨ —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Te cue tée‑áⁿ nǐ xica‑güedé cuáháⁿ‑güedé, te nchaa‑ni nàcuáa ní xáhaⁿ Jèsús ducaⁿ nǐ cuu, ");
INSERT INTO milNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","chi mei òré nándàxi‑güedé bǔrru‑áⁿ nǐ quexìo cue ñáyiu cùu xítohó‑dɨ xìcáⁿ tnúhu‑yu núú‑güedě, te xǎhǎⁿ‑yu: —¿Ná cuèndá nándàxi‑ndo búrru‑ndɨ́‑i? —càchí‑yu xǎhǎⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Te ní xáhaⁿ‑güedě xií‑yu: —Nà ndaxi‑ndɨ́‑dɨ chi Yaá xícá cùu ndɨhɨ‑ndɨ́ xíní ñùhu ñaha‑gá xii‑dɨ —càchí‑güedé xǎhaⁿ‑güedě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Te ndèca‑güedé‑dɨ cuáháⁿ núú ndécú Jèsús, te òré ní quexìo‑güedé ndɨhɨ‑dɨ núú ndécú‑gǎ te ní sacáⁿ ndodo‑güedé dóó‑güedě sátá‑dɨ, te ní ngódó ñáhá‑gǎ xii‑dɨ. ");
INSERT INTO milNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Te ío cuéhé ñǎyiu ta sàcáⁿ‑yu dóǒ‑yu ichi cuáháⁿ‑gá cuèndá núú dǒǒ‑yu‑áⁿ yǎha‑gá ndɨhɨ quɨtɨ yòdo‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Te ní nucuíta nuu‑gá ichi tɨndúú yucu Òlívú tá cùyatni‑gá ñuú Jerusàlén cuáháⁿ, te nchaa ñáyiu sàndáá iní ñáhá xìi‑gá nchìcúⁿ ñáhǎ‑yu te ní ngüíta‑yu níhi càháⁿ‑yu sá cúdɨ̌ɨ́ ìní‑yu, te càchí‑yu sá ǐo càhnu cuu Yá Ndiǒxí cuèndá sá nǐ xiní‑yu nchaa sá vǎ yǒo tnàhí ndàcu cada ní quide‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Te càchí‑yu: —¡Ío càhnu cuu Yaá véxi quɨndaha ñàha xii‑o, te dɨu‑gá cúú‑gǎ Yaá ní tendaha Yǎ Ndiǒxí véxi quìde núú‑gǎ! ¡Te ío càhnu cuu mee‑gá! ¡Te andɨu ñà túú tnàhí ná cúú! —duha càchí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Te ɨɨⁿ ǔú cue tée cùu fariséú ñúhú tnàhá tnuú ñáyiu‑áⁿ nǐ xáhaⁿ‑güedě xii Jèsús: —Mèstrú, cúñaha nchàa ñáyiu ndɨhɨ‑n na càdɨ́‑yu yuhú‑yu —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Dico Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te na càchí tnúhu‑í xii‑ndo sǎ nǔu ñáyiu‑a na càdɨ́‑yu yuhú‑yu ña, te nchaa yúú cǎháⁿ níhi‑xi dàtná ɨɨⁿ ñáyiu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Te òré ní cuyatni‑gá ñuú Jerusàlén te ní xiní‑gá, te ní ndáhyú‑gá cuèndá nchaa ñáyiu dii ñùú‑xi‑áⁿ sǎ ndɨ̀hú iní‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Te ní xáhaⁿ‑gǎ xii cue ñáyiu‑áⁿ: —Ío cuu váha iní‑í te núu dìcó nchòhó tecú tnùní‑ndó vìtna ɨɨⁿ tnúhu sá cádá vǎha ñaha xìi‑ndo, chi ñá túú‑gǎ ná cuu cundecu‑ndo, te núu na tècú tnùní‑ndó. Dico ñá tècú tnùní‑ndó, chi ío yɨ̀dáhu tnúhu‑a. ");
INSERT INTO milNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Te sáá nduu tnǔndòho tnúhu ndàhú sá cúú‑xí‑ndó, te nchaa cue tée dava‑gá ñuú cúú ǔhú iní tnáhá ndɨ̀hɨ‑ndo quixi‑güedé chidoco ñàha‑güedé xii‑ndo, te nɨ càndéé núú ndécú‑ndó‑ǎⁿ dacàa‑güedé ndóho cuèndá xíáⁿ quɨhɨ váha‑güedé nàá ndɨhɨ ñaha‑güedě xii‑ndo, te vá dáñá‑güedě cunu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Te cahni ñaha‑güedě xii‑ndo, te ndɨhɨ nchaa vehe‑ndo dàngoyo‑güedé ndéé cimièntú‑xi, chi ñá túú ní cuìní‑ndó nàcuáha‑ndo cuèndá òré ní quixi coto ñaha Yǎ Ndiǒxí xii‑ndo —duha ní xáhaⁿ‑gǎ xii ñáyiu ñuú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Te Jèsús cuánguɨhu‑gá xɨtɨ́ veñúhu càhnu sá ǐo cùnuu, te xɨtɨ́ veñúhu‑áⁿ xǐndecu cue ñáyiu quìde ndáhú ndɨhɨ cue ñáyiu xǐsaaⁿ. Te ní queñuhu ñaha Jèsús xií‑yu quehé. ");
INSERT INTO milNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Te ní xáhaⁿ‑gǎ xií‑yu: —Núú tùtú Yǎ Ndiǒxí càháⁿ‑xi nàcuáa ní cáháⁿ‑gá, te duha ní cachí‑gá: “Vehe‑í cúú‑xí nǔú càháⁿ ndɨhɨ ñaha ñáyiu xii‑í”, duha ní cáháⁿ‑gá càchí‑xi núú tùtú‑gá. Dico nchòhó quídé‑ndó vèhe‑gá vehe ñadúhú —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Te Jèsús nchaa nduu dànehé‑gá ñáyiu xɨtɨ́ veñúhu, dico cue tée cùu dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùnuu ñuú‑áⁿ ndúcú‑güedě nàcuáa cada‑güedé cahni ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Dico ñá nìhí‑güedé nàcuáa cada‑güedé, chi cuèndá nchaa ñáyiu ío cùdɨ́ɨ́ ìní‑yu ndèdóho‑yu nchaa tnúhu càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Te ɨɨⁿ nduu yɨ̀hɨ Jesús xɨtɨ́ veñúhu càhnu sá ǐo cùnuu danehé‑gá ñáyiu tnúhu sá càháⁿ nàcuáa naníhí tàhú‑yu. Te ní quexìo cue tée cùu dútú cúnùu ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél, ");
INSERT INTO milNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","te ní xáhaⁿ‑güedě xii‑gá: —Cuìní‑ndɨ́ cachí tnúhu‑n xìi‑ndɨ́ nása ndùu tnúhu ndee ìní ndécú ndɨ̀hɨ‑n núu quìde‑n nándɨ sá quídé‑n. ¿Te yoo ducaⁿ nǐ taxi tnúhu ndee ìní‑áⁿ xii‑n? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Te Jèsús ní xáhaⁿ‑gǎ: —Yúhú tnàhá‑í cuìní‑í cácáⁿ tnúhu‑í ɨɨⁿ sá càcáⁿ tnúhu‑í núú‑ndó, te cachí tnúhu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Te chí càchí tnúhu xii‑í yoo ní táúchíúⁿ nǐ dácuándùte ndíi Juàá ñáyiu. ¿Yá Ndiǒxí ǎⁿ cuè tée ñuyíú‑a ní táúchíúⁿ dùcaⁿ ní quide ndíi? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Te ní ngüíta‑güedé xǐtnàha‑güedé: —¿Nása cúñaha‑o? Chi núu nà cúñaha‑o sǎ Yǎ Ndiǒxí ní táúchíúⁿ dùcaⁿ ní quide ndíi Juàá ñá, te quesaha‑dě: “¿Ná cuèndá ñá túú ní sàndáá iní‑ndó tnǔhu ní cáháⁿ ndíi vàíⁿ?”, quesaha‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Àdi te núu nà cúñaha‑o sǎ cuè ñáyiu ñuyíú‑a ní táúchíúⁿ dùcaⁿ ní quide ndíi ña, te nchaa ñáyiu cuáha ñàhá‑yu yúú xii‑o, te cahni ñàhá‑yu, chi càchí‑yu sá ndàá sá Yǎ Ndiǒxí ní táúchíúⁿ‑gǎ ní cáháⁿ ndíi Juàá tnúhu‑gá núú ñǎyiu —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Te ní xáhaⁿ‑güedě xii‑gá sá ñà túú xìní‑güedé yoo ní táúchíúⁿ dùcaⁿ ní dácuándùte ndíi Juàá ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Te ní xáhaⁿ Jèsús xii‑güedé: —Te núu ducaⁿ te ni yǔhú vá càchí tnúhu‑í xii‑ndo yòo ní taxi tnúhu ndee ìní duha quìde‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Te sátá dúcáⁿ te ní ngüíta Jèsús ní cani‑gá ɨɨⁿ cuèndú núú ñǎyiu nàcuáa tecú tnùní‑yu tnúhu‑gá, te xáhaⁿ‑gǎ xií‑yu: —Ɨɨⁿ tée ní xitu‑dé mee‑ni yòho yaha stilé núú ñúhú‑dě. Te ní sáá ɨɨⁿ nduu quɨ̌ngaca cuu xica‑dě vài nduu te ní dándǒo ndaha‑dě sá nǐ xitu‑dé‑áⁿ xii ɨɨⁿ ǔú cue tée càháⁿ ndɨhɨ‑dé cuèndá cada chìuⁿ‑güedé, te ní ndatnúhu‑güedé sá òré ná cùu te cuu cuèndá dava‑güedé te ducaⁿ te ní quee‑dé cuáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Te sátá nǐ sáá nduu nǐ cuu nchaa ndéhé yoho yàha stilé sá nǐ xitu‑dé‑áⁿ, te ní xáhaⁿ‑dě xii ɨɨⁿ tée xìnu cuechi núú‑dě: “Cuàháⁿ cácáⁿ‑n sǎ cúú cuèndá‑í núú cuè tée ní dándǒo ndàha‑í nchaa yoho yàha stilé sá nǐ xitu‑í”, càchí‑dé xǎhaⁿ‑dě. Te tée xìnu cuechi‑áⁿ nǐ xica‑dé cuáháⁿ‑dé, dico cue tée ndèé nchaa yoho yàha stilé‑áⁿ nǐ tnɨɨ‑güedé tée xìnu cuechi‑áⁿ te ní caniha‑güedě, te ní nacuícúⁿ ñáhá‑güedě xii‑dé, te ñá túú tnàhí ná ní sǎñaha‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Te dǎtnùní tée cùu xítohó nchaa yoho yàha stilé‑áⁿ nǐ tendaha tùcu‑dé ɨngá tée xìnu cuechi núú‑dě cuáháⁿ‑dé, dico dɨu‑ni ducaⁿ nǐ quide ñaha‑güedě xii‑dé, chi ní xícuèhé ñáhá‑güedě, te ní caniha‑güedě te ní nacuícúⁿ ñáhá‑güedě, te ñá túú tnàhí ná ní sǎñaha‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Te tée cùu xítohó nchaa yoho yàha stilé‑áⁿ nǐ tendaha tùcu‑dé ɨngá‑dé cuáháⁿ‑dé, te dɨu‑ni ducaⁿ nǐ quide ñaha tùcu‑güedé, chi ní dánǐcuèhé ñáhá‑güedě, te ní nacuícúⁿ ñáhá‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Te tée cùu xítohó nchaa yoho yàha stilé‑áⁿ nǐ sani iní‑dé: “¿Nása cada‑í vitna? Váha‑gá tendaha‑ǐ déhe‑í tée ío cùu iní‑a núhú‑dé, chi cudana te òré quiní ñáhá‑güedě xii‑dé, te canehe‑güedé sá yɨ́ñùhu núú‑dě”, duha ní sani iní‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dico òré ní xiní cue tée quìde chiuⁿ‑áⁿ děhe xítohó nchaa yoho yàha stilé‑áⁿ, te ní xítnàha‑güedé: “Tée‑ǎⁿ tée véxi nduu táhú ñuhu‑a ndɨhɨ nchaa sá cáá nǔú‑xi, dico cahni‑o‑dě te mee‑o ndùu tahú‑ó sǎ ndúú tǎhú‑dě”, càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Te ní queñuhu ñaha‑güedě ɨɨⁿ xio yuhu ñùhu‑áⁿ, te ní sahni ñaha‑güedě xii‑dé —duha cuáháⁿ cuèndú ní cani Jèsús núǔ‑yu. Te dǎtnùní ní xáhaⁿ tùcu‑gá xií‑yu: —¿Te nchòhó sa cùtnuní iní‑ndó nàcuáa cada ñaha xǐtohó ñuhu‑áⁿ xii cue tée‑áⁿ ñǎ? ");
INSERT INTO milNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chi núhú‑dé te cahni‑dé cue tée‑áⁿ, te dàndóo ndaha‑dě ñuhu‑dé xii cue tée cùtnuní iní‑dé cada ndáá —càchí‑gá xáhaⁿ‑gǎ xií‑yu. Te sá dúcáⁿ nǐ cáháⁿ‑gá, núu ní cachí‑yu: —¡Sá vǎ càchí Ndiǒxí sá dúcáⁿ yǎha‑o! —càchí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Te Jèsús ní ndacoto‑gá núǔ‑yu, te ní xáhaⁿ‑gǎ: —Chí càchí tnúhu nása quèe‑xi nacuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí, núú càchí‑xi: Yúú sǎ nǐ dáquéé tɨ̌hú cue tée dàcaa vehe ní saa‑xi cùu‑xi yúú cúnùu vitna. Duha càchí‑xi núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Te nchaa ñáyiu ñá túú cuìní tnɨɨ tnúhu‑í, te ndohó‑yu dàtná ɨɨⁿ ñáyiu tnàhnú duuⁿ òré ndùá‑yu núú yǔú, àdi núu na tàú ñáhá‑xí te dàcachi duuⁿ ñaha‑xi —cachí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Te cue tée cùu dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés ní cuiní‑güedé tnɨɨ‑güedé Jèsús òré‑ni‑á ní cùu, chi ní cutnùní iní‑güedé sá cuèndá‑güedé ní cáháⁿ‑gá, dico ní yùhú‑güedé cuèndá sá ǐo vài ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Te ní ndúcú‑güedě nàcuáa cada‑güedé tnɨɨ ñaha‑güedě xii‑gá, te ní tendaha‑güedě cue tée cuáháⁿ ngoto dayuhu ñàha xii‑gá, te cuáháⁿ‑güedé dàtná cue tée váha iní‑xi, te ndùcu‑güedé nàcuáa cada‑güedé nǔu cáháⁿ‑gá ɨɨⁿ tnúhu sá ñà túú tàú‑gá cáháⁿ‑gá cuèndá ducaⁿ te candeca ñaha‑güedě xii‑gá quɨ́hɨ́ⁿ cuáha cuèndá ñáhá‑güedě núú těe cùnuu. ");
INSERT INTO milNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Te ní xáhaⁿ‑güedě xii Jèsús: —Mèstrú, nìhí‑ndɨ́ tnúhu sá dánèhé‑n ñǎyiu mee‑ni tnǔhu váha, te cuěi ndědani càa ñáyiu ɨɨⁿ‑ni càháⁿ‑n ndɨ̀hɨ́‑yu, te càháⁿ ndáá‑n nàcuáa càháⁿ Yǎ Ndiǒxí cundecu‑o ñùyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Te cachí tnúhu xii‑ndɨ́ nǔu váha‑ni cháhu‑ndɨ́ té Cèsár tée ío cùnuu cuendá impuèstú ǎⁿ ñǎhá —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Dico Jèsús ní cutnùní iní‑gá sá xító ndèé ñáhá‑güedě xii‑gá, núu ní xáhaⁿ‑gǎ xii‑güedé: ");
INSERT INTO milNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Chí dánèhé ñáhá xìi‑í ɨɨⁿ díhúⁿ cuìxíⁿ te cachí tnúhu‑ndo nǔu yoo núú‑xi ndèé, ndɨhɨ yoo dɨ̀u‑xi ndeé —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Núú tě Cèsár ndèé ndɨhɨ dɨ̀u‑dé —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Te ní xáhaⁿ tùcu‑gá xii‑güedé: —Te núu ducaⁿ te chí nácuǎha té Cèsár sá cúú cuèndá‑dé, te sá cúú cuèndá méé Yǎ Ndiǒxí, te xíǎⁿ nacuáha‑ndo‑gǎ —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Te ñá ní ndàcu tnahí‑güedé datɨ̀cánuu ñaha‑güedě xii‑gá núú tnǔhu càháⁿ‑gá, chi òré ní cáháⁿ‑gá, te da ní cuñúhu‑güedé nchaa tnúhu ní cáháⁿ‑gá, te váha‑gá ní sadɨ́‑güedé yuhu‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Te sátá dúcáⁿ te ní sáá ɨɨⁿ ǔú cue tée cùu saducéú núú ndécú Jèsús. Te cue tée‑áⁿ ñà túú sàndáá iní‑güedé sá ndótó cuè ñáyiu ní xíhí, te ní xáhaⁿ‑güedě xii‑gá: ");
INSERT INTO milNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Mèstrú, ndíi Moìsés càchí ndíi núú tùtú ndècu vitna sá nǔu ɨɨⁿ tée na cùú, te quendóo ñadɨ̀hɨ́‑dé te ñá túú děhe‑dé ní xǒo ndɨhɨ‑aⁿ, te tée cùu ñaní‑dé naqueheⁿ‑dé ñaha ní quendóo quèé‑áⁿ cuèndá coo déhe‑dé ndɨhɨ‑aⁿ cuèndá ñaní‑dé tée ní xíhí‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Te ní xíndecu úsá tnàhá cue tée mee‑ni ndɨ̀ ñaní‑güedé. Te tée díhna ní níhí ñadɨ̀hɨ́‑dé, dico ñá túú ní cùdíi‑dé cundecu‑dé chi ní xíhí‑dé, te ni ɨ̀ɨⁿ déhe‑dé ñá túú ní xǒo ndɨhɨ ñadɨ̀hɨ́‑dé‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Te tée cùu uú ní naqueheⁿ‑dé ñaha ní quendóo quèé‑áⁿ dico ní xíhí tucu‑dé, te ni ɨ̀ɨⁿ tucu déhe‑dé ñá túú ní xǒo ndɨhɨ ñaha‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Te tée cùu uní ní naqueheⁿ tucu‑dé ñaha ní quendóo quèé‑áⁿ, te dɨu‑ni ducaⁿ nǐ xíhí‑dé, te ní xínu ndɨ ùsá‑güedé ní cándeca ñaha‑güedě xii ñaha‑áⁿ, dico ni ɨ̀ɨⁿ‑güedé ñá túú ní xǒo déhe‑güedé ndɨhɨ‑aⁿ, te ní ndɨhɨ‑güedé ní xíhí. ");
INSERT INTO milNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Te ndéé núú nǐ ndɨhɨ‑ná ní xíhí tnàhá ñadɨ̀hɨ́‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Te na sàá nduu ndòto‑güedé ndɨhɨ ñaha‑áⁿ ¿Te ndědacàa‑güedé ñadɨ̀hɨ́‑güedé cuu‑aⁿ‑i? Chi ndɨ ùsá‑güedé ní cándeca ñaha‑güedě xii‑aⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Nchaa ñáyiu ñuyíú‑a tnǎndahá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Dico nchaa ñáyiu ní nduu táhú ndoto díhna nuu ñáyiu‑áⁿ cundecú‑yu ndɨhɨ Yá Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ, te yàcáⁿ ñá túú‑gǎ sá cándèca tnahá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Te ni ñà túú‑gǎ tnúhu xìhí, chi cuu‑ná‑yu dàtná cue espíritú xínú cuèchi núú Yǎ Ndiǒxí cuèndá sá nǐ ndotó‑yu, chi cùú‑yu déhe‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Te ndéé ndíi Moìsés ní chídó tnùní ndíi núú tùtú ndíi sá ncháá ñǎyiu ní xíhí ndotó‑yu, te dɨu‑ni xíáⁿ càháⁿ‑xi cuèndá tnutàú nchìcúⁿ ñuhú, te dɨu‑ni xíáⁿ càchí tucu‑xi sá Yǎ Ndiǒxí cúú‑gǎ Ndiǒxí ndíi Àbrahám, ndíi Isàác, ndɨhɨ ndíi Jàcób. ");
INSERT INTO milNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Te cue tée‑áⁿ chi cuěi ní xíhí‑güedé sá cúú‑xí nchòhó, dico sá cúú‑xí Yǎ Ndiǒxí chi ndècu vívú‑ni‑güedě. Chi cùtnuní iní‑ó sǎ Yǎ Ndiǒxí cúú‑gǎ Ndiǒxí mee‑ni cuè ñáyiu xǐndecu vǐvú, te ñá túú cùu‑gá Ndiǒxí cue ñáyiu ñá túú ndècu vívú. Te sá cúú‑xí mèe‑gá chi nchaa ñáyiu ndècu ndɨhɨ‑gá ndécú vǐvǔ‑yu cuěi sa ní xíhí‑yu núú ñùyíú‑a —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Te ɨɨⁿ tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés ní xáhaⁿ‑dě xii Jèsús: —Mèstrú, váha‑ni càháⁿ‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Te ñá túú‑gǎ ní cùyɨɨ‑güedé cácáⁿ tnúhú‑güedě ni ɨ̀ɨⁿ tnúhu núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —¿Te nása càchí‑tu‑yu sá Crìstú Yaá tendaha Yǎ Ndiǒxí quixi ñuyíú‑a cùu‑gá déhe ndíi Dàvií? ");
INSERT INTO milNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Te mee ndǐi Dàvií‑áⁿ nǐ cachí ndíi núú lìbrú Sǎlmú: Dútú Ndiǒxí ní xáhaⁿ‑gǎ xii Yaá cúú Xǐtohó‑í: “Ngóo xio cùha‑í, ");
INSERT INTO milNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","te yúhú cada‑í te nchaa sá cúú ǔhú iní ñáhá xìi‑n canehe‑xi sá yɨ́ñùhu núú‑n.” Duha ní xáhaⁿ Dǔtú Ndiǒxí xii Yaá cúú Xǐtohó‑í càchí ndíi núú lìbrú Sǎlmú. ");
INSERT INTO milNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Te nása cùu Cristú déhe ndíi Dàvií, te mee ndǐi ní cachí ndíi sá cúú‑gǎ Xítohó ndíi‑i? —càchí Jèsús xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Te òré ndátnǔhu Jèsús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá xǐndedóho ñaha ñáyiu, te xáhaⁿ‑gǎ xii‑güedé: ");
INSERT INTO milNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Cada cuèndá‑ndó vǎ cádá‑ndó nàcuáa quìde cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, chi tnàhá iní‑güedé cuihnu‑güedé dóó nání sǎ sácuǐhnu cue tée cùnuu. Te nchaa núú tàcá ñáyiu cuìní‑güedé sá ndɨ̀hɨ tnúhu yɨñùhu cáháⁿ ndɨhɨ ñàhá‑yu xii‑güedé, te nàcáxi‑güedé xìlé sácǒo nchihi cue tée cùnuu‑gá xɨtɨ́ veñúhu conchihi‑güedé, te ducaⁿ‑ni quìde‑güedé cuěi òré quɨ́hu‑güedé mèsá caxi‑güedé òré ndécú‑güedě ɨɨⁿ vico, chi mee‑ni nǔú sácǒo cue tée cùnuu‑gá cuìní‑güedé coo‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Te quèndeé‑güedé vehe nchaa ñáyiu dɨ̀hɨ́ ñáyiu quèé, te ío naha càháⁿ ndɨhɨ‑güedé Yǎ Ndiǒxí cuèndá cuìní‑güedé cáháⁿ váha‑yu cuèndá‑güedé. Te sá dúcáⁿ quìde‑güedé te sáá nduu te ío‑gá ndoho‑güedé núú ùhú núú ndàhú dàcúúxí dàva‑gá ñáyiu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Te Jèsús ní xiní‑gá xɨtɨ́ veñúhu xǐdáquěe cue tée cuica dǐhúⁿ nduu táhú Yǎ Ndiǒxí xɨtɨ́ alcancìá. ");
INSERT INTO milNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Te ní xiní‑gá tnàhá ɨɨⁿ ñaha ndàhú ñaha quèé ní dáquěe‑aⁿ úú díhúⁿ còbrí, ");
INSERT INTO milNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","te ní xáhaⁿ Jèsús xii cue ñáyiu xǐndecu‑áⁿ: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ ñàha ndahú ñaha quèé‑a ío‑gá nándɨ̌hɨ díhúⁿ nǐ dáquěe‑aⁿ xɨtɨ́ alcancìá nduu táhú Yǎ Ndiǒxí dàcúúxí dǐhúⁿ nǐ dáquěe dava‑gá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chi nchaa ñáyiu‑áⁿ nǐ dáquěe‑yu mee‑nǎ sá nǐ ndóo‑ná, dico ñaha quèé‑a cuěi ndàhú‑aⁿ dico ní dáquěe‑aⁿ nɨhìí díhúⁿ sǎ cuááⁿ‑áⁿ sǎ cáxí‑áⁿ ní cùu —cachí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Te ɨɨⁿ ǔú ñáyiu xǐcáháⁿ‑yu cuèndá veñúhu càhnu sá ǐo cùnuu sá ǐo vii càa nchaa yúú yɨ́hɨ́, ndɨhɨ cuèndá nchaa sá nǐ sáñaha tǎhú ñǎyiu yɨ̀hɨ xɨtɨ́‑xi. Te Jèsús ní xáhaⁿ‑gǎ xií‑yu: ");
INSERT INTO milNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Sáá nduu te nchaa sá cúñǔhu‑ndo‑a vǎ cúndùu‑gá‑xi dàtná cáá‑xí vìtna, chi ni ɨ̀ɨⁿ‑gá yúú vǎ códó nchìhi tnaha‑gá‑xi chi ndɨhɨ ngoyo —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Te cue tée xǐndecu‑áⁿ nǐ xícáⁿ tnúhú‑güedě núú Jèsús, te xǎhaⁿ‑güedě xii‑gá: —Mèstrú, ¿te ná nduu dùcaⁿ cada‑xi ngoyo veñúhu, àdi nándɨ cùu sá cádá‑xí cuèndá cutnùní iní‑ndɨ́ sá sà ta cuyatni nduu ducaⁿ cada‑xi‑i? —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Ío quɨhɨ iní‑ndó cùndecu‑ndo, te vá dáñá‑ndó mèe‑ndo dandahú ñáhá ñǎyiu xii‑ndo. Chi ío cuéhé cue tée coo ñuyíú‑a, te danàni‑güedé méé‑güedě dàtná nánì‑í te cachí‑güedé: “Yúhú cúù‑í Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a”, duha cachí‑güedé. Te cachí tucu‑güedé: “Vitna sa ní sáá nduu càda‑xi nchaa nacuáa ní cáháⁿ‑í”, duha cachí‑güedé. Dico vá quɨ̀ndáá iní‑ndó, te nì vá túhá‑ndó‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Te òré ná nìhí‑ndó tnǔhu sá tɨ̀tnɨ́ nàcióⁿ xǐnàá‑güedé te dava ñuú xǐnàá‑güedé ndɨ mèe‑güedé, te vá yùhú‑ndó chi dacuɨtɨ́í sǎ dúcáⁿ càda‑xi, dico vátá sàá‑gá nduu nàa ñuyíú òré ducaⁿ càda‑xi —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Te xǎhaⁿ tùcu‑gá xii‑güedé: —Nchaa cue tée ɨɨⁿ nàcióⁿ nàá‑güedé ndɨhɨ cue tée ɨngá nàcióⁿ, te tɨtnɨ́ ñuú ngüíta‑güedé nàá‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Te tɨtnɨ́ xichi ñuyíú nǐhi vìhi tnáa, te tɨtnɨ́ tucu xichi ñuyíú coo tnamá, te tɨtnɨ́ tucu xichi ñuyíú quixi cuéhé, te tɨtnɨ́ núú sǎ cádá‑xí àndɨu, te yùhú ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Te òré cúmǎní‑gǎ cada‑xi nchaa nàcuáa càháⁿ‑í‑a, te cue tée cùu úhú iní ñáhá xìi‑ndo tnɨɨ ñaha‑güedé, te candeca ñaha‑güedě xii‑ndo quɨ̌hɨ́ⁿ xɨtɨ́ veñúhu‑güedé cada ndáá‑güedé cuéchi‑ndo, te chihi ñaha‑güedě vecaá xii‑ndo, te candeca ñaha‑güedě quɨ́hɨ́ⁿ núú cuè tée cùnuu yɨndaha nacióⁿ àdi núú dàva‑gá cue tée cùnuu sá cuèndá‑í. ");
INSERT INTO milNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Te òré ducaⁿ na càda ñaha‑güedé xii‑ndo, te òré‑áⁿ tàú‑xi cáháⁿ váha‑ndo cuèndá‑í núú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Te vá cání ìní‑ndó nǔu nása cunduu tnúhu cúñaha‑ndo xìi‑güedé cuèndá cácu nihnu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chi yúhú dacàhu iní ñáhà‑í xii‑ndo tnǔhu cúñaha‑ndo xìi‑güedé, te taxi‑í sá vǎtá quìní tnùní‑gá‑ndó, te ni ɨ̀ɨⁿ ñáyiu cùu úhú iní ñáhá xìi‑ndo vá nìhí‑gá‑yu tnúhu cúñàhá‑yu xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Te ndéé tǎtá‑ndó, ndɨ̀hɨ ñaní‑ndó, ndɨhɨ cue ñáyiu cùu ñaní tnáhá‑ndó, ndɨhɨ cue ñáyiu càháⁿ ndɨhɨ váha‑ndo cuǎha cuèndá ñáhǎ‑yu xii‑ndo nǔú cuè tée cùchiuⁿ, te dava‑ndo càhni ñaha‑güedé xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Te ío cuéhé ñǎyiu cuu úhú iní ñáhǎ‑yu xii‑ndo sǎ cuèndá‑í. ");
INSERT INTO milNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Dico Yá Ndiǒxí ío coto ñaha‑gǎ xii‑ndo chi ndéé idi dɨ́quɨ́‑ndó còto‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Te núu na càda ndee iní‑ndó cànchicúⁿ nihnu ñaha‑ndo xìi‑í, te nduu táhú‑ndó cùndecu‑ndo ndɨhɨ Yá Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Te nduu na quìní‑ndó ñùhu doco sandadú nɨ càndéé yuhu ñùú Jerusàlén, te sa cutnùní iní‑ndó sǎ sà ní cuyatni nduu dànaa‑güedé ñuú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Te dàvá‑áⁿ nchaa ñáyiu xǐndecu distrìtú Jùdeá xíní ñùhu‑xi cunú‑yu quɨ́hɨ́ⁿ‑yu xɨtɨ́ yucu, te nchaa ñáyiu xǐndecu ñuú Jerusàlén queé‑yu xɨtɨ́ ñuú‑áⁿ, te ñáyiu ñá túú xǐndecu ñuú‑áⁿ vǎ ndɨ̌hu‑gá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chi dàvá‑áⁿ cuu‑xi nduu tnǔndòho tnúhu ndàhú, te ducaⁿ càda‑xi chi ducaⁿ ndèé tnuní núú tùtú Yǎ Ndiǒxí nàcuáa dandòho ñaha‑gá xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Te ndàhú ní cuu nchaa ñáyiu dɨ̀hɨ́ ñúhú děhe‑xi, ndɨhɨ nchaa ñáyiu ndèca déhe vitna sàdi na sáá nduu dùcaⁿ cada‑xi! Chi ío cuéhé tnǔndòho tnúhu ndàhú coo núú ndécǔ‑yu dàvá‑áⁿ, te xíǎⁿ cuu‑xi ɨɨⁿ tnúndòho tendaha Yá Ndiǒxí quixi sá cúú‑xǐ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Te dava cue tée cuú‑güedé cahni ñaha‑güedě, te dava‑güedé tnɨɨ ñaha‑güedě candeca ñaha‑güedě quɨ́hɨ́ⁿ nchaa ñuú xícá, te cue tée dava‑gá ñuú cunuu‑güedě ñuú Jerusàlén, te mee Yǎ Ndiǒxí cachí‑gá te núu ná daha nduu cunuu‑güedě ñuú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Te cada‑xi ɨɨⁿ sá vǎtá quìní‑gá ñáyiu núú nchǐcanchii, ndɨhɨ núú yǒó, ndɨhɨ núú nchàa chódíní, te ñuyíú‑a coo tnúhu ndɨ̀hú iní‑xi te vá cútnùní iní‑yu nása cadá‑yu cuèndá sá ǐo dusaⁿ càda ndute lamár òré candaundéé tnáhá‑xí. ");
INSERT INTO milNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Te nchaa ñáyiu cuneé‑yu sá yùhú‑yu, ndɨhɨ sá ndɨ̀hú iní‑yu cuèndá nchaa sá cádá‑xí ñùyíú‑a, te quɨdɨ‑xi andɨu. ");
INSERT INTO milNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Te sátá dúcáⁿ te quiní‑ndó yǔhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo quee‑í andɨu quìxi‑í ichi xɨtɨ́ vícó, te dàvá‑áⁿ quiní ñáhá nchàa ñáyiu sá ǐo cùnuu‑í te ndàcu‑í quìde‑í nchaa sá vǎha. ");
INSERT INTO milNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Te òré ná ngüǐta‑xi ducaⁿ càda‑xi, te cuita cundee‑gǎ iní‑ndó quɨ̌hɨ́ⁿ, te quɨhɨ iní‑ndó chi sa ní cuyatni vií‑nǎ nduu cǎcu nihnu‑ndo vǎ cúndècu‑gá‑ndó nǔú ñùyíú yǐcá cuěchi‑a —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Te ní cani‑gá ɨɨⁿ cuèndú núú‑güedě nàcuáa tecú tnùní váha‑güedé tnúhu‑gá, te xáhaⁿ‑gǎ xii‑güedé: —Chí cúndèhe yutnu ngúxí ndɨhɨ nchaa dava‑gá yutnu. ");
INSERT INTO milNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chi nàtahú ndaha‑xi, te òré ducaⁿ quìde‑xi te càchí‑ndó sǎ sà ní cuyatni nuu cahni. ");
INSERT INTO milNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Te dɨu‑ni ducaⁿ sǎtnahá‑xi cùu oré ná quìní‑ndó càda‑xi nchaa nacuáa càháⁿ‑í, te sá dúcáⁿ te cutnùní iní‑ndó sǎ sà ní cuyatni nduu ndɨ́hu ndaha ñàha Yá Ndiǒxí xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Te na càchí tnúhu ndáá‑í xii‑ndo sǎ òré vátá cùú‑gá cue ñáyiu xǐndecu ñuyíú‑a vitna, te cada‑xi nchaa nàcuáa ní cáháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Te andɨu ndɨ̀hɨ ñuyíú‑a chi ndɨhɨ nihnu‑xi, dico tnúhu‑í chi vá ndɨ́hɨ́ nìhnu‑xi, chi cùu‑xi tnúhu ndáá. ");
INSERT INTO milNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Te quɨhɨ iní‑ndó vǎ cúndècu‑ndo ichi cuehé ichi duha, te vá cúú‑ndó ñǎyiu quɨhu, te vá cúhúⁿ ìní‑ndó mèe‑ni nchaa sá ìó ñuyíú‑a, chi núu ducaⁿ na càda‑ndo te nacuanaa‑ndo sǎ sàá nduu càda‑xi nacuáa ní cáháⁿ‑í. Te uuⁿni sáá nduu‑ǎⁿ, ");
INSERT INTO milNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","te cada‑xi dàtná cuìní‑ndó quìde ɨɨⁿ trampá chi uuⁿni ngàva‑xi, te ducaⁿ càda‑xi nchaa ñáyiu xǐndecu ñuyíú‑a, chi uuⁿni sáá nduu‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Te nchòhó cundecu túha‑ndo te ío cáháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí cuèndá ndacu‑ndo yǎha‑ndo nchàa tnúndòho quixi ñuyíú‑a, te ducaⁿ te nasáá‑ndó cùndecu‑ndo núú ndécú yǔhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Te nduu ndùu ní xóo danèhé Jèsús ñáyiu tnúhu‑gá xɨtɨ́ veñúhu càhnu sá ǐo cùnuu, te niú niú ní xóo quɨ́hɨ́ⁿ ngúdú‑gá xɨtɨ́ yucu Òlívú. ");
INSERT INTO milNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Te nehé nehé ní xóo quɨ́hɨ́ⁿ nchaa ñáyiu veñúhu‑áⁿ nǐ xóo cundedóho‑yu nchaa tnúhu càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Te sa ní cuyatni nduu tnàhá vico pàscuá, te vico‑áⁿ xéxí ñǎyiu pàá sá ñà túú yɨ̀hɨ levadurá. ");
INSERT INTO milNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Te cue tée cùu dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés ndúcú‑güedě nàcuáa cada‑güedé cahni‑güedé Jèsús, te dìcó‑ni sá xǐyùhú‑güedé ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Te yucu ñávǎha ní dácáhú ìní ñáhá‑xí xìi té Jùdás déhe té Iscàrioté, te núú tnàhá tée‑áⁿ cúú ùxúú tnàhá cue tée xìca cuu ndɨhɨ‑gá ní cùu. ");
INSERT INTO milNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Te té Jùdás‑áⁿ nǐ sáháⁿ‑dé ní ndatnúhu‑dé ndɨhɨ cue tée cùu dútú cúnùu, ndɨhɨ cue tée tàxi tnuní ñáhá xìi cue tée quìde cuendá veñúhu nàcuáa cada‑dé cuáha cuèndá‑dé Jèsús núú‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Te ío ní cudɨ́ɨ́ ìní‑güedé, te ní xáhaⁿ‑güedě xii‑dé sá cuǎñaha‑güedě díhúⁿ, ");
INSERT INTO milNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","te ní xáhaⁿ‑dě sá cúú quèheⁿ‑dé díhúⁿ‑ǎⁿ, te ní ngüíta‑dé ndúcú‑dě nàcuáa cada‑dé cuáha cuèndá‑dé Jèsús núú‑güedě òré ñá túú ñǎyiu. ");
INSERT INTO milNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Te ní sáá nduu nǐ quesaha vìco xexí‑yu pàá sá ñà túú yɨ̀hɨ levadurá, te dɨu‑ni nduu‑ǎⁿ sáhní‑güedě ɨɨⁿ mběé lǐhli xèxí‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Te Jèsús ní xáhaⁿ‑gǎ xii té Pèlú ndɨhɨ té Juàá: —Chí cuàháⁿ chi cada túha‑ndo nǔú cúdìni‑o sacuaa nduu vico pascuá —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Te ní xícáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —¿Te ndèé cáá vèhe cuiní‑n càda túha‑ndɨ́‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Te ní xáhaⁿ Jèsús xii‑güedé: —Chí cúndèdóho na càchí tnúhu‑í xii‑ndo nàcuáa cada‑ndo. Òré quɨ́hu‑ndo xɨ̀tɨ́ ñuú núú quɨ̌hɨ́ⁿ‑ndó, te naníhí‑ndó ɨ̀ɨⁿ tée tànehe ɨɨⁿ yoó ndute, te tée‑áⁿ candéndaha‑ndo‑dě quɨ́hɨ́ⁿ, te núu ndědacàa vehe na ndɨ́hu‑dé te xíáⁿ quɨ̌hu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Te cúñaha‑ndo xìi xítohó vehe‑áⁿ: “Yaá cúú Mèstrú càchí‑gá nǔu ndědacàa xichi xɨtɨ́ vehe‑n cuǎñaha nùu‑n xii‑gá cudìni‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá sacuaa nduu vìco pascuá”, duha cúñaha‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Te dǎtnùní danèhé ñáhá‑dě xii‑ndo ɨ̀ɨⁿ cuartú cáhnú càa núú nǐnu, chi vehe yòdo tnaha cuu‑xi, te sa ní quide túha‑dé nchaa sá ná ndɨ̌hɨ, te nchòhó dìcó‑nǎ sá cúdìni‑o cada túha‑ndo —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Te ní xica‑güedé cuáháⁿ‑güedé, te nchaa‑ni nàcuáa ní xáhaⁿ Jèsús xii‑güedé ní cuu, chi nchaa sa ndècu túha, te ní quide túha‑güedé sá cúdìni‑güedé ndɨhɨ‑gá sacuaa nduu vìco pascuá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Te sátá nǐ tnahá òré cudìni Jesús ndɨhɨ cue tée ní táúchíúⁿ‑gǎ cáháⁿ tnúhu‑gá núú ñǎyiu, te cuánguɨhu ndɨhɨ ñaha‑gǎ xii‑güedé mèsá. ");
INSERT INTO milNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Te xáhaⁿ‑gǎ xii‑güedé: —¡Ducaⁿ‑ni ǐo sàni iní‑í sá cúdìni ndɨhɨ ñaha‑í xii‑ndo sàcuaa nduu vico pascuá òré cúmǎní‑gǎ sáá nduu ndòho‑í te cuú‑í! ");
INSERT INTO milNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Te na càchí tnúhu‑í xii‑ndo sǎ vǎ dúhá‑gǎ caxi ndɨhɨ ñaha‑ǐ xii‑ndo ndùu vico pascuá, chi ndéé òré ná sàá nduu nàsáá‑ndó nǔú táxí tnùní Yǎ Ndiǒxí cundecu‑o, te dàvá‑áⁿ cada iní‑ndó sǎ dàtná sá cáxí tùcu‑o chi ío váha cuu iní‑ó cùndecu‑o —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Te ní queheⁿ‑gá ɨɨⁿ vàsú ñúhú ndùdí ndéhé yoho yàha stilé, te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí, te dǎtnùní ní xáhaⁿ‑gǎ xii‑güedé: —Chí quéhéⁿ vàsú ñúhú ndùdí ndéhé yoho yàha stilé‑a, te coho‑ndo lùha luha nchaa‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Te na càchí tnúhu tucu‑í xii‑ndo sǎ vítná‑nǎ duha xìhi ndɨhɨ ñaha‑í xii‑ndo ndùdí ndéhé yoho yàha stilé‑a te vá cóhó ndɨ̀hɨ ñaha‑gá‑í, dico na sàá nduu nàníhí tnáhá‑ó nǔú ndécú Tǎtà‑í Dútú Ndiǒxí táxí tnùní‑gá, te dàvá‑áⁿ cada iní‑ó sǎ dàtná sá cóhó ndɨ̀hɨ ñaha tucu‑í xii‑ndo, chi ío cudɨ́ɨ́ ìní‑ó —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Te sátá nǐ túhú cóhó‑güedě ní cudìni‑güedé, te ní queheⁿ‑gá pàá te ní ndacáⁿ táhú tùcu‑gá núú Yǎ Ndiǒxí, te dǎtnùní ní táhú cuèchi‑gá, te ní dácǎhñu ñaha‑gǎ xii‑güedé, te xáhaⁿ‑gǎ: —Pàá‑a cùu‑xi datná yɨquɨ cùñú‑í, chi cahni ñaha‑güedě xii‑í sá cuèndá‑ndó, te ducaⁿ‑ni càxi‑ndo paá‑a cuèndá ndacu iní ñáhá‑ndó xìi‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Te dɨu‑ni ducaⁿ nǐ quide‑gá ndɨhɨ vàsú ñúhú ndùdí ndéhé yoho yàha stilé, chi ní queheⁿ‑gá te òré sǎñaha‑gǎ xii‑güedé coho‑güedé, te ní xáhaⁿ‑gǎ: —Ndudí ñúhú vàsú‑a cada iní‑ndó sǎ cúú‑xí dàtná nɨ́ñɨ̀‑í sá cátɨ́ òré cahni ñaha‑güedě xii‑í. Te sá dúcáⁿ càtɨ nɨ́ñɨ̀‑í xíǎⁿ cutnùní ndáá sá Yǎ Ndiǒxí cada‑gá ɨngá núú sǎ vǎha sá cúú‑xí‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Dico vitna chi iha tnàhá tée cuáha cuèndá ñáhá xìi‑í núú cuè tée cùu úhú iní ñáhá yɨ̀hɨ‑dé mèsá. ");
INSERT INTO milNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Te yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ñuhu ichi‑í cuáháⁿ‑í cuú‑í dàtná ní cachí Yǎ Ndiǒxí. ¡Dico ndàhú ní cuu tée ducaⁿ na cuǎha cuèndá ñáhá xìi‑í núú cuè tée cùu úhú iní ñáhá! —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Te ní ngüíta‑güedé ndúcú tnǔhu núú tnáhá‑güedě nǔu nděda càa‑güedé ducaⁿ càda cuáha cuèndá ñáhá xìi‑gá núú cuè tée cùu úhú iní ñáhá. ");
INSERT INTO milNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Te sátá dúcáⁿ te ní ngüíta‑güedé xǐndatnúhu‑güedé nǔu ndědacàa‑güedé tàú‑güedé cunuu‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dico Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Nchaa cue tée yɨ̀ndaha ñaha xii ñáyiu ío tàxi tnuní‑güedé, te mee‑güedě cuìní‑güedé sá càháⁿ váha ñáyiu cuèndá‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dico nchòhó vá dúcáⁿ càda‑ndo, chi núu ɨɨⁿ‑ndo cùnuu te cada‑ni‑ndo sǎ ñà túú cùnuu‑ndo, àdi cuu‑ndo ɨɨⁿ tée tàxi tnuní ñáhá xìi cue tée xìnu cuechi, te cada‑ni‑ndo sǎ cúú‑ndó ɨ̀ɨⁿ tée xìnu cuechi‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Te vá càchí‑ó sǎ těe xìnu cuechi cunuu‑gá‑dé, chi tée quɨ́hu mèsá cúnùu‑gá‑dé. Dico yúhú ndécú ndɨ̀hɨ ñaha‑í xii‑ndo dàtná ɨɨⁿ tée xìnu cuechi. ");
INSERT INTO milNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Te nchòhó ducaⁿ‑ni ndècu ndɨhɨ ñaha‑ndo xii‑í, te tàyáha ndɨhɨ ñaha‑ndo xìi‑í nchaa sá táyǎha‑í véxi. ");
INSERT INTO milNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Te Tǎtà‑í Dútú Ndiǒxí ní cachí‑gá sá táxí tnùní‑í, te yúhú càchí‑í xii‑ndo sǎ sàá nduu te tnàhá‑ndó tàxi tnuní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Te dàvá‑áⁿ caxi‑o coho‑o càda‑o núú táxí tnùní‑í, te yàcáⁿ ngüíta‑ndo càda ndáá‑ndó cuěchi ndɨ ùxúú xichi ñáyiu isràél —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Te Xítohó Jesucrìstú ní xáhaⁿ‑gǎ xii té Xǐmú: —Yòhó Xǐmú, cundedóho váha ɨɨⁿ tnúhu na càháⁿ‑í‑a, chi dàtná cuìní‑n quìde táchí trìú sàcáⁿ‑xi duha sàcáⁿ‑xi dàcáⁿ, ducaⁿ quèsaha yucu ñávǎha cada ñaha‑xi xìi‑ndo. Chi coto ndeé ñáhá‑xí xìi‑ndo te núu ndisa sàndáá iní ñáhá‑ndó xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Dico yúhú xìcáⁿ táhù‑í núú Yǎ Ndiǒxí cuèndá‑n, cuèndá sá vǎ dáñá ndèé‑n quɨ̀ndáá iní ñáhá‑n xìi‑í. Te òré ndixi túu iní‑n sǎ ñà túú ní quìde váha‑n, te quɨ́hɨ́ⁿ‑n cuǎha‑n cuè tée cùndɨhɨ‑n tnúhu ndee ìní cuèndá canchicúⁿ nihnu‑ni‑güedé ichi Yá Ndiǒxí —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Te ní xáhaⁿ‑dě xii‑gá: —Mèstrú, sa ndècu túha‑í sá quɨ̀hɨ́ⁿ ndɨhɨ ñaha‑ǐ xii‑n vècaá, àdi cuéi na cùú ndɨhɨ ñaha‑ǐ xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Te Jèsús ní xáhaⁿ‑gǎ: —Pèlú, na càchí tnúhu‑í xii‑n sǎ cùmání‑gǎ cana ɨɨⁿ lǐhi te úní xito cáháⁿ‑n nǔú ñǎyiu sá ñà túú xìní ñáhá‑n xìi‑í —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Te cútnàhá ní tendaha ñaha‑ǐ xii‑ndo nǐ sáháⁿ‑ndó chìuⁿ‑í, chi ñá túú ní cǎnehe‑ndo nì ɨɨⁿ sá cúhúⁿ dǐhúⁿ‑ndó, te ni ɨ̀ɨⁿ sá cúhúⁿ ndàchiuⁿ‑ndo ñá túú ní cǎnehe‑ndo. Te chí càchí tnúhu núu ìó ɨɨⁿ sá nǐ cumání xii‑ndo —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě: —Ñáhá, chi ni ɨ̀ɨⁿ sá ñà túú ní cùmání xii‑ndɨ́ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Te ní xáhaⁿ‑gǎ: —Te vitna núu ndècu ndɨhɨ‑ndo sá sácǔhuⁿ díhúⁿ‑ndó, àdi sá sácǔhuⁿ ndachìuⁿ‑ndo te canehe‑ndo. Te núu ñá túú ndècu ndɨhɨ‑ndo machití, te nadico‑ndo dǒó tɨ̌cachi nìhnu‑ndo te cuaaⁿ‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Te na càchí tnúhu‑í xii‑ndo sǎ dàcuɨtɨ́í sǎ yǎha‑í nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí núú càchí‑xi: “Ɨɨⁿ‑ni nǐ quide ñaha‑güedě xii‑gá, ndɨhɨ cue tée ndècu cuéchi‑xi”, duha càchí‑xi núú tùtú‑gá. Te ñá dɨ́ú‑ní xǐǎⁿ yáha‑í chi nchaandɨ túhú nàcuáa càháⁿ‑xi núú tùtú‑gá yáha‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Te xǎhaⁿ‑güedě: —Mèstrú, iha ndècu úú machìtí —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te ní xáhaⁿ‑gǎ: —Chí návìí‑nǎ yuhu‑ndo, vá càháⁿ‑gá‑ndó —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Te Jèsús ní quee‑gá cuáháⁿ‑gá yucu Òlívú, chi ducaⁿ tnàhí quìde‑gá. Te cue tée xìca cuu ndɨhɨ‑gá nchìcúⁿ ñáhá‑güedě xii‑gá cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Te òré ní quexìo‑gá xíáⁿ, te ní xáhaⁿ‑gǎ xii‑güedé: —Chí càháⁿ ndɨhɨ Yá Ndiǒxí cuèndá sá vǎ dácàháⁿ ñáhá yùcu ñávǎha xii‑ndo càda‑ndo sá ñà túú tàú‑ndó càda‑ndo —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Te sátá dúcáⁿ te ní quee dɨ̀ɨⁿ‑gá tnuú‑güedé cuáháⁿ‑gá ɨɨⁿ xio, te sa ñùnchií luha ní xica ndehe‑gá núú ndécú‑güedě, te xíáⁿ nǐ ngüɨ́ñɨ́ xɨ́tɨ́‑gǎ càháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Te xáhaⁿ‑gǎ: —Táu, te núu dìcó cachí‑n te taunihnu ñaha‑n xìi‑í cuèndá sá vǎ ndóhò‑í ná sàá òré, dico vá cádá‑n nàcuáa càchí iní méè‑í, chi cada‑n nàcuáa càchí iní méé‑n —càchí‑gá xáhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Te sátá dúcáⁿ te ní quexìo ɨɨⁿ espíritú xínú cuèchi núú Yǎ Ndiǒxí ní sáñaha‑gǎ‑xi tnúhu ndee ìní xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Te òré súúní ndɨ̀hú iní‑gá, te uuⁿ‑gá súúní nɨ̀ yuhu nɨ iní‑gá càháⁿ ndɨhɨ‑gá Dútú Ndiǒxí, te tnéé‑gǎ cáá dàtná cáá nɨ̌ñɨ́ te ngóyó nǔú ñúhú. ");
INSERT INTO milNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Te sátá nǐ yáha ní cáháⁿ ndɨhɨ‑gá Tǎtá‑gǎ Dútú Ndiǒxí, te ní ndacuɨ́ñɨ́‑gá cuánuhú‑gá núú nǐ dándǒo‑gá cue tée‑áⁿ, te òré ní nasáá‑gá te xǐxídí‑güedé cuèndá sá ǐo cuéhé tnǔhu sàni iní‑güedé cuèndá‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Te xáhaⁿ‑gǎ xii‑güedé: —¿Ná cuèndá xìdí‑ndó? Chí ndácǒo, te cáháⁿ ndɨhɨ‑ndo Yǎ Ndiǒxí cuèndá sá vǎ dácàháⁿ ñáhá yùcu ñávǎha xii‑ndo càda‑ndo sá ñà túú tàú‑ndó càda‑ndo —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Te càháⁿ dúcáⁿ‑ní Jèsús ní quexìo vai cue tée, te ɨɨⁿ tée xìca cuu ndɨhɨ‑gá nání Jùdás cúnùu‑dé yódó nùu‑dé núú‑güedě ní quexìo ndéé núú‑gǎ, te ní teyuhu ñàha‑dé xii‑gá, te núú tnàhá tée‑áⁿ cúú ùxúú cue tée xìca cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Te ní xáhaⁿ Jèsús xii‑dé: —Jùdás, ¿te yòhó cuáha cuèndá ñáhá‑n xìi yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo núú cuè tée cùu úhú iní ñáhá xìi‑í cáháⁿ‑n nǔu duha tèyuhu ñaha‑n‑áⁿ? —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Te sátá nǐ xiní nchaa cue tée cùndɨhɨ Jesús nàcuáa cùu cue tée ní quexìo‑áⁿ, núu ní xícáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —Mèstrú, ¿cuu nàá‑ndɨ́ ndɨhɨ‑güedé ndɨhɨ machìtí‑a ñǎ? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Te ɨɨⁿ‑dé ní xehndé‑ni‑dé lóho xio cùha ɨɨⁿ cue tée ní quexìo‑áⁿ, te tée‑áⁿ xínú cuèchi‑dé núú dǔtú cúnùu‑gá, te ní quendeé duuⁿ lóho‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —Chí dáñá‑güedě, vá dúcáⁿ càda‑ndo —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. Te ní dácàá‑gá ndaha‑gá ní tendaha‑gǎ núú nǐ xíndeé lóho tée‑áⁿ, te ní nduu váha dàtná‑ni càa. ");
INSERT INTO milNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Te nchaa cue tée cùu dútú cúnùu, ndɨhɨ cue tée tàxi tnuní nchaa cue tée quìde cuendá veñúhu sá ǐo cùnuu, ndɨhɨ cue tée cùu sacuéhé nǔú ñǎyiu isràél, nchaa cue tée‑áⁿ věxi tnɨɨ ñaha‑güedě xii‑gá, te ní xáhaⁿ‑gǎ xii‑güedé: —Nchòhó, nèhe‑ná‑ndó màchití, nèhe‑ná‑ndó càrrutí véxi‑ndo nǔú ndécù‑í, dàtná quídé‑ndó ɨ̀ɨⁿ ñadúhú quídé ñàha‑ndo xii‑í. ");
INSERT INTO milNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Te ducaⁿ‑ni nǐ xiní‑ndó nǐ xíndecu‑í xɨtɨ́ veñúhu càhnu sá ǐo cùnuu ní xóo danèhé‑í ñáyiu, te ni lùha ñá túú ní cùu tnándeé ñáhá‑ndó xìi‑í òré‑áⁿ, te vitna ní sáá òré ducaⁿ càda‑ndo, te cada sácuíhná nàcuáa cùu iní‑xi —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Te ní tnɨɨ‑güedé Jèsús, te ndèca ñaha‑güedé xii‑gá cuáháⁿ vehe tée cùu dútú cúnùu‑gá, te té Pèlú xica xìca‑ni nchicúⁿ ñáhá‑dě xii‑gá cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Te òré ní quexìo‑güedé xíáⁿ te ní dátnàhá‑güedé ñuhú quehé vehe‑áⁿ, te nɨ càndéé yuhu nùhú‑áⁿ nǐ ngóo teté‑güedé, chi quìde víxiⁿ‑xi, te tnàhá té Pèlú ní ngóo teté ndɨhɨ ñaha‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Te xíáⁿ ndécú ɨ̀ɨⁿ xíchí xínú cuèchi vehe‑áⁿ, te òré ní xiní‑xi nùcóo teté tnàhá té Pèlú, te ní ndacoto‑xi núú‑dě, te ní xáhaⁿ‑xi xìi‑güedé: —Tnàhá tée‑a xìca cuu ndɨhɨ‑dé tée ndèca‑güedé cuánguɨhu‑ǎⁿ —càchí‑xi xǎhaⁿ‑xi xìi‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dico té Pèlú ñá túú ní nǔnuu‑dé, te xǎhaⁿ‑dě xii‑xi: —Yúhú ñá túú xìní‑í tée‑ǎⁿ —càchí‑dé xǎhaⁿ‑dě xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Te tna tnaa‑ni ní cuu, te ní xiní ñáhá tùcu ɨɨⁿ‑dé, te xǎhaⁿ‑dě: —Yòhó tnàhá‑n xìca cuu ndɨhɨ‑n tée ndèca‑güedé cuánguɨhu‑ǎⁿ —càchí‑dé xǎhaⁿ‑dě xii‑dé. Dico té Pèlú ní xáhaⁿ‑dě: —Ñáhá, ñá dɨ́ú yǔhú xícá cùu ndɨhɨ‑í‑dé —càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Te sa ní cuu dàtná ɨɨⁿ òré te càchí tucu ɨngá‑dé: —Ndáá sá těe‑a xìca cuu ndɨhɨ‑dé tée ndèca‑güedé cuánguɨhu‑ǎⁿ, chi tnàhá‑dé cúú‑dě tée distrìtú Galìleá —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Te té Pèlú ní xáhaⁿ‑dě xii tée‑áⁿ: —Yúhú ñá túú cùtnuní iní‑í nása ndùu tnúhu càháⁿ‑n —càchí‑dé xǎhaⁿ‑dě. Te ni vǎtá xǐnu ducaⁿ‑gǎ tnúhu càháⁿ‑dé ní cana‑ni ɨɨⁿ lǐhi. ");
INSERT INTO milNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Te Xítohó Jesucrìstú ní nchócótó‑gǎ núú‑dě, te òré‑ni‑áⁿ nǐ ndacu iní‑dé tnúhu ní xáhaⁿ‑gǎ xii‑dé sá cùmání‑gǎ cana ɨɨⁿ lǐhi, te úní xito cáháⁿ‑dé sá ñà túú xìní ñáhá‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Te té Pèlú ní quee‑dé tnuú‑güedé cuáháⁿ‑dé ɨɨⁿ xio, te ní ndáhyú víhí‑dě ní ndixi cuéchi iní‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Te cue tée ndèé ñáhá xìi Jesús ní cudɨ́quɨ́ ndeé ñáhá‑güedě xii‑gá, te ní dádǎhu‑güedé núú‑gǎ, te ní caniha‑güedě xii‑gá, te xǎhaⁿ‑güedě: —¡Cáháⁿ ná cótó yòo ní caniha xìi‑n! —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Te cuéhé víhí‑gǎ tnúhu cuèhé ní xáhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Te sátá nǐ túndaá, te ní tacá cue tée cùu sacuéhé nǔú ñǎyiu isràél, ndɨhɨ cue tée cùu dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xií‑yu nchaa tnúhu ní chídó tnùní ndíi Moìsés, te ndèca‑güedé Jèsús cuáháⁿ núú cádá‑güedě jùndá, te òré ní quexìo‑güedé ndɨhɨ‑gá núú cádá‑güedě jùndá‑áⁿ, te ní xáhaⁿ‑güedě xii‑gá: ");
INSERT INTO milNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Cuìní‑ndɨ́ cachí tnúhu‑n xìi‑ndɨ́ nǔu dɨu‑n cùu‑n Cristú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te ní xáhaⁿ‑gǎ xii‑güedé: —Te núu na càchí‑í sá dɨ́ù‑í cúú Crìstú ñá, te nì vá quɨ̀ndáá iní‑ndó, ");
INSERT INTO milNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","àdi te núu ɨɨⁿ sá ná càcáⁿ tnúhu‑í núú‑ndó, te nì vá càchí tnúhu‑ndo, te ni vǎ dáñá ñàha‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Dico vitna ní cuyatni nduu ngóo yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo xio cuha Dútú Ndiǒxí Yaá ío cùnuu —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Te dǎtnùní nchaa‑güedé ní xícáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě xii‑gá: —¿Te yòhó cúú‑n Děhe Yá Ndiǒxí te núu ducaⁿ vàni? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te ní xáhaⁿ Jèsús: —Ndáá sá dɨ́ú Děhe‑gá cúù‑í dàtná càchí méé‑ndó‑ǎⁿ —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Te ní xítnàha‑güedé: —Ñá túú‑gǎ xíní ñùhu‑xi cue tée cáháⁿ nǔu ndáá sá ndècuéchi‑dé àdi ñá túú ndècuéchi‑dé chi yuhu mee‑dě ní cáháⁿ‑dé vitna ní xíndedóho‑o —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Te nchaa‑güedé ní ndacuɨ́ñɨ́‑güedé, te ndèca‑güedé Jèsús cuáháⁿ núú tě Pìlatú, ");
INSERT INTO milNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","te núú těe‑áⁿ nǐ ngüíta‑güedé sàcáⁿ cuéchi‑güedé cuèndá‑gá, te xǎhaⁿ‑güedě: —Ní naníhí‑ndɨ̌ tée‑a dàndahú‑dé ñáyiu ñuú‑ó, chi xǎhaⁿ‑dě xií‑yu sá vǎ chǎhu‑gá‑yu impuèstú xii té Cèsár tée ío cùnuu, te càchí‑dé sá dɨ́ú‑dě cúú‑dě Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a te yɨ̀ndaha‑dé ñáyiu càchí‑dé —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Te té Pìlatú ní xícáⁿ tnúhu‑dé núú‑gǎ, te xǎhaⁿ‑dě xii‑gá: —¿Ndáá sá dɨ́ú‑n cùu‑n tée yɨ̀ndaha ñaha xii ñáyiu isràél‑ǎⁿ? —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te Jèsús ní xáhaⁿ‑gǎ xii‑dé: —Dɨu‑í yɨ́ndàha‑í‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Te té Pìlatú ní xáhaⁿ‑dě xii nchaa ñáyiu, ndɨhɨ cue tée cùu dútú cúnùu: —Yúhú cútnùní iní‑í sá ñà túú nì ɨɨⁿ cuéchi tée‑a —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Dico níhi‑gá ní cáháⁿ‑güedé, te xǎhaⁿ‑güedě: —Càchí‑ndɨ́ sá ǐo dusaⁿ xǐquide ñáyiu cuèndá nchaa sá dánèhé ñáhá‑dě xií‑yu, te ní quesaha‑dě ndéé distrìtú Galìleá, te ní yáha‑dé nɨhìí distrìtú Jùdeá dánèhé‑dé ñáyiu, te vitna ní sáá‑ni‑tu‑dé ndéé ndíha dànehé‑dé‑yu —càchí‑güedé xǎhaⁿ‑güedě xii té Pìlatú. ");
INSERT INTO milNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Te sá dúcáⁿ nǐ tecú dóho té Pìlatú ní cacu nehé‑yu distrìtú Galìleá, núu xíǎⁿ ní xícáⁿ tnúhú‑dě núǔ‑yu núu tée Galìleá cúú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Te ní xáhǎⁿ‑yu sá dɨ́ú těe yàcáⁿ cúú‑gǎ, núu xíǎⁿ ní na dàyáha ñaha‑dě xii‑gá ndaha té Hèrodés tée cùu gobiernú distrìtú Galìleá chi nduu‑ǎⁿ ndécú‑dě tnàhá‑dé ñuú Jerusàlén‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Te òré ní xiní té Hèrodés‑áⁿ Jèsús te ío ní cudɨ́ɨ́ ìní‑dé, chi ní cunaha dùcaⁿ‑ni cuiní‑dé quiní ñáhá‑dě xii‑gá te ñá túú tnàhí xìní ñáhá‑dě xii‑gá ní cùu, chi cuèndá‑ni tnúhu nìhí‑dé cuèndá‑gá, te ndètu‑dé sáá ɨɨⁿ nduu quìní ñáhá‑dě xii‑gá, te cada‑gá ɨɨⁿ sá vǎ yǒo tnàhí ndàcu cada cundehe‑dé ní sani iní‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Te vài sá nǐ xícáⁿ tnúhú‑dě núú Jèsús, dico ni ɨ̀ɨⁿ tnúhu ñá túú ní cǎháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Te xíáⁿ xǐndecu tnàhá cue tée cùu dútú cúnùu, ndɨhɨ cue tée dàcuaha ñaha xii ñáyiu nchaa tnúhu ní chídó tnùní ndíi Moìsés, te cue tée‑áⁿ sǔúní ìó iní‑güedé sàcáⁿ cuéchi‑güedé cuèndá‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Te té Hèrodés ndɨhɨ cue tée cùu sandadú‑dé ñá túú ní cùu váha iní‑güedé núú Jèsús, te ní cudɨ́quɨ́ ndeé ñáhá‑güedě xii‑gá, te ní dácuíhnú ñàha‑güedé dóó vǎha xii‑gá dàtná cáá dǒó sácuǐhnu cue tée sàquɨ́ndaha ñàha xii ñáyiu. Te dǎtnùní té Hèrodés ní dánùhú ñáhá tùcu‑dé xii‑gá ndaha té Pìlatú. ");
INSERT INTO milNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Te nduu‑ǎⁿ nǐ tnahá tnúhu té Pìlatú ndɨhɨ té Hèrodés, chi cùu úhú iní tnáhá‑güedě ní cùu. ");
INSERT INTO milNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Te té Pìlatú ní nadatàcá‑dé nchaa cue tée cùu dútú cúnùu ndɨhɨ dava‑gá cue tée cùnuu, ndɨhɨ nchaa ñáyiu ñuú‑áⁿ, ");
INSERT INTO milNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","te ní xáhaⁿ‑dě: —Nchòhó ndécá‑ndó těe‑a véxi ní taxi cuèndá‑ndó‑dě iha, te càchí‑ndó sǎ ǐo dusaⁿ quìde ñáyiu cuèndá nchaa sá dánèhé ñáhá‑dě xií‑yu, te núú‑ndó ndùcu tnúhu‑í núú‑dě nǔu ná ní quide‑dé. Dico yúhú cútnùní iní‑í sá ñà túú nì ɨɨⁿ cuéchi‑dé dàtná càháⁿ‑ndó‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Te cuěi té Hèrodés dɨu‑ni ducaⁿ càháⁿ‑dé sá ñà túú cuěchi‑dé nǔu ní techìuⁿ ñaha tucu‑dé cuándixi‑dé iha. Te vitna sa ní cutnùní iní‑ó sǎ ñà túú tàú‑xi cahni‑o‑dě chi ñá túú cuěchi ni quìde‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Te na dàndoho‑ni‑í‑dé te dàcácu‑í‑dé —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Te ndɨ tnahá nduu vìco pascuá te dacuɨtɨ́í sǎ dácǎcu té Pìlatú‑áⁿ ɨɨⁿ cue tée yɨ̀hɨ vecaá, chi ducaⁿ tnàhí quìde‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dico nchaá‑yu ní cuáá‑yu, te xǎhǎⁿ‑yu xii‑dé: —¡Queñuhu tée nàni Jesús‑áⁿ, te cahni‑n‑dě! ¡Te dàcácu‑n tě Barràbás! —càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Te té Barràbás‑áⁿ nǐ sanu ichi‑dé ñáyiu ñuú ɨngá ichi, te ní ngüíta‑yu ndɨhɨ‑dé ní cuu úhú iní‑yu cue tée cùchiuⁿ, te ní sahni‑dé ndɨ́yɨ núu xíǎⁿ ní chihi ñaha‑güedě vecaá xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Te té Pìlatú cuìní‑dé dàcácu‑dé Jèsús nǔu xíǎⁿ càháⁿ ndɨhɨ ñaha tùcu‑dé xií‑yu ni cùu, ");
INSERT INTO milNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","dico uuⁿ‑gá níhi ní cuáá‑yu, te ní xáhǎⁿ‑yu xii‑dé úú xito: —¡Cata caá‑dé núú cùrúxí! ¡Cata caá‑dé núú cùrúxí! —càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Te xito cuu úní ní xáhaⁿ tě Pìlatú: —¿Te ná cúú cuěchi ní quide‑dé te núu ducaⁿ cuìní‑ndó càda‑í‑dé‑i? Te yúhú cútnùní iní‑í sá ñà túú cuěchi ni quìde‑dé nǔu xíǎⁿ ñá túú tàú‑xi cahni‑o‑dě, te na dàndoho‑ni‑í‑dé te dàcácu‑í‑dé —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Dico níhi‑ni càháⁿ‑yu xǎhǎⁿ‑yu sá ná càta caa ñaha‑dé xii‑gá núú cùrúxí, te ñáyiu‑áⁿ ndɨhɨ nchaa cue tée cùu dútú cúnùu xícáháⁿ níhi‑güedé ndɨhɨ́‑yu ndéé ní xínu iní té Pìlatú cada‑dé nàcuáa càchí iní‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Te ní xáhaⁿ‑dě xií‑yu sá cúú càda‑dé nàcuáa xǎhǎⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Te ducaⁿ te ní dácǎcu‑dé té Barràbás tée ní sanu ichi ñáyiu ñuú ɨngá ichi, te dɨu‑ni‑dé ní sahni‑dé ndɨ́yɨ núu xíǎⁿ ní xɨ́hɨ‑dé vecaá, te dǎtnùní ní táúchíúⁿ‑dě cada‑güedé Jèsús nàcuáa xǎhǎⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Te ndèca‑güedé Jèsús cuáháⁿ núú cátá càa ñaha‑güedé xii‑gá, te ichi cuáháⁿ‑güedé ndɨhɨ‑gá ní tnɨɨ‑güedé ɨɨⁿ tée ñuú Cìrené nání‑dě Xǐmú ñúhú‑dě ichi duha cuándixi‑dé ní sáháⁿ‑dé yucu, te ní dácuídó ñàha‑güedé xii‑dé cùrúxí nchídó Jèsús, te ní ngüíta nchicúⁿ‑dé sátá‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Te ío cuéhé ñǎyiu nchìcúⁿ ñáhá xìi‑gá cuáháⁿ, te vài ñáyiu dɨ̀hɨ́ ío níhi ndàhí‑yu sá ndɨ̀hú iní‑yu cuèndá Jèsús. ");
INSERT INTO milNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Te Jèsús ní nchócótó‑gǎ núǔ‑yu, te ní xáhaⁿ‑gǎ: —Nchòhó ñáyiu dɨ̀hɨ́ ñuú Jerusàlén, vá ndàhyú‑ndó cuèndá‑í chí ndàhyú cuèndá méé‑ndó ndɨ̀hɨ cuendá déhe‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chi sáá nduu quèsaha ñáyiu: “Sá vǎha táhú nchaa ñáyiu ñá túú càcu déhe‑xi, ndɨhɨ nchaa ñáyiu vátá quìní‑gá cuhuⁿ déhe‑xi, chi ni ñà túú xìní‑yu dacàdí‑yu”, duha quesàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Te dàvá‑áⁿ cǔñaha ñǎyiu xii nchaa tɨndúú ndɨhɨ nchaa núú xɨ̀quɨ́: “Chí tácùuⁿ ngónchihi ñaha‑ndo xìi‑ndɨ́”, duha cúñàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Te núu yúhú tée quìde ndáá duha quìde ñaha‑güedé xii‑í vitna, te ndèé‑gá cada‑güedé nchaa ñáyiu ndècu ichi cuehé ichi duha —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Te ndèca tucu‑güedé úú tnàhá cue tée ndècu ndisa cuéchi‑xi cuáháⁿ cuèndá cahni ñaha‑güedě xii‑güedé ndɨhɨ Jèsús. ");
INSERT INTO milNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Te òré ní quexìo‑güedé ndɨhɨ‑gá ɨɨⁿ xichi núú nání Yɨ̀quɨ Dɨ́quɨ́ Ndɨ̌yɨ, te xíáⁿ nǐ sata caa ñaha‑güedě xii‑gá núú cùrúxí, ndɨhɨ úú cue tée ndècu ndisa cuéchi‑xi‑áⁿ, te ɨɨⁿ‑dé ní sata caa‑güedé xio cùha‑gá te ɨngá‑dé ní sata caa‑güedé xio dàtni‑gá dɨu‑ni núú cùrúxí tucu. ");
INSERT INTO milNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Te ní xáhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí: —Táu, cada càhnu iní sá quídé‑güedě, chi ñá túú cùtnuní iní‑güedé ná cúú sǎ quídé‑güedě —càchí‑gá xáhaⁿ‑gǎ. Te cue tée cùu sandadú ní xito ndéé‑güedé nǔu ndědacàa‑güedé cuu cuèndá‑güedé dóó‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Te nchaa ñáyiu xǐndecu‑áⁿ ndéhě‑yu nàcuáa quìde‑güedé Jèsús, te nchaa cue tée cùnuu ní cudɨ́quɨ́ ndeé ñáhá‑güedě xii‑gá, te ní xítnàha‑güedé: —Te dava ñáyiu ní ndacu‑dé ní dácǎcu nihnu‑dé, te vitna na dàcácu nihnu‑dé méé‑dě, te núu ndisa sá Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a cùu‑dé —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Te tnàhá cue tée cùu sandadú ní cudɨ́quɨ́ ndeé ñáhá‑güedě xii‑gá, chi ní sándehe yatni‑güedé núú tácàa‑gá sǎñaha‑güedě ndudí íá còho‑gá ní cùu, ");
INSERT INTO milNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","te ní xáhaⁿ‑güedě xii‑gá: —Te núu yòhó cúú‑n těe yɨ̀ndaha ñaha xii ñáyiu isràél, te dàcácu nihnu mee‑n —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Te ní taxi ndecu‑güedé ɨɨⁿ sá ndèé lètrá ndàa dɨ́quɨ́‑gǎ te ndèé úní núú tnǔhu, tnúhu grìégú, ndɨhɨ tnúhu làtín, ndɨhɨ tnúhu hèbreú, te duha quèe‑xi ndɨ nuní núú tnǔhu‑áⁿ “Tée‑a cùu‑dé tée yɨ̀ndaha ñaha xii ñáyiu isràél”, duha quèe‑xi. ");
INSERT INTO milNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Te ɨɨⁿ tée ndècu ndisa cuéchi‑xi, tée ní sata caa‑güedé dɨ̀ñɨ‑gá xǐcuèhé ñáhá‑dě xii‑gá, te xǎhaⁿ‑dě: —Te núu yòhó cúú‑n Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a, te dàcácu nihnu mee‑n, te dàcácu nihnu ñaha xìi nchúhú tnàhá‑ndɨ́ tucu —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Dico ɨngá tée cùndɨhɨ‑dé tée tàcaa ɨngá xio dɨ̀ñɨ‑gá ní tenàá ñáhá‑dě xii‑dé, te xǎhaⁿ‑dě: —¿Te náa ñá túú ndàcu iní‑n Yǎ Ndiǒxí vitna duha càa‑o ndoho‑o ndɨhɨ tée nàni Jesús‑a ñǎ? ");
INSERT INTO milNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Chi nchoo tàú ndisa‑o sǎ dúhá ndòho‑o nacháhu‑o cuěchi‑o, dico Jèsús‑a chi ñá túú cuěchi‑dé —càchí‑dé xǎhaⁿ‑dě xii tée tàcaa ndɨhɨ‑dé‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Te dǎtnùní ní xáhaⁿ‑dě xii‑gá: —Jèsús, ndacu iní ñáhá‑n xìi‑í òré ná quìxi‑n taxi tnuní‑n ñùyíú‑a —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Te Jèsús ní xáhaⁿ‑gǎ: —Na càchí tnúhu ndáá‑í xii‑n sǎ méí ndùu vitna cundecu ndɨhɨ ñaha‑í xii‑n nǔú nǐ nduu táhù‑í cundecu‑í —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Te òré ní cuu cuádava nduu. Te ní cunee nɨhìí ñuyíú, te ducaⁿ‑ni càa ní cuu ndéé caá úní sacuaa. ");
INSERT INTO milNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Chi ñá túú‑gǎ ní dàyehé nchícanchii te ní ndátá dǒó cúú còrtiná veñúhu càhnu sá ǐo cùnuu ní quée dava ndáá. ");
INSERT INTO milNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Te níhi ní cáháⁿ Jèsús, te xáhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí: —Táu, naqueheⁿ cuèndá‑n espíritú‑í —càchí‑gá xáhaⁿ‑gǎ xii Tǎtá‑gǎ. Te tnúhu‑ná‑áⁿ nǐ cáháⁿ‑gá te ní xíhí‑ni‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Te òré ní xiní tée cùu capitáⁿ sá dúcáⁿ nǐ cuu, te ní ndacu iní‑dé Yǎ Ndiǒxí, te ní cachí‑dé: —Sá ndàá ndisa sá těe‑a cùu‑dé ɨɨⁿ tée ío quìde ndáá ndécú ñùyíú‑a ni cùu —duha ní cachí‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Te chitu ñǎyiu ní tacá xíáⁿ chi cuìní‑yu cundèhé‑yu nása cada‑güedé Jèsús. Te sátá nǐ yáha ní xiní‑yu nàcuáa ní quide ñaha‑güedě xii‑gá, te ní ndɨhɨ́‑yu ní ndaca ta càní‑yu pèchú‑yu cuánuhú sá ndɨ̀hú iní‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dico ndècu tnahá cue ñáyiu xìní tnáhá ndɨ̀hɨ Jesús, ndɨhɨ ñáyiu dɨ̀hɨ́ ní chinchícúⁿ ñáhá xìi‑gá ndéé distrìtú Galìleá, te ñáyiu‑áⁿ xica‑ni xǐxínutnɨ́ɨ‑yu xǐndéhě‑yu nchaa nàcuáa ní quide ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Te ndècu ɨɨⁿ tée ñuú Arimàteá nání‑dě Chèé, te ñuú‑áⁿ yɨ́ndèhu‑xi distritú Jùdeá, te ío váha iní‑dé te quìde ndáá‑dé núú Yǎ Ndiǒxí, te tnàhá‑dé cúú‑dě chìuⁿ te ní xíndecu‑dé jùndá cue tée isràél. ");
INSERT INTO milNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Te ñá ní tnàhá tnàhí iní‑dé nàcuáa ní cáháⁿ‑güedé núú jùndá nàcuáa cada‑güedé Jèsús. Te tée‑áⁿ ndétú‑dě sáá nduu ndɨ́hu ndaha ñàha Yá Ndiǒxí xii‑dé ndɨhɨ ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Te tée‑áⁿ nǐ sáháⁿ‑dé núú tě Pìlatú te ní xáhaⁿ‑dě sá nǔu vá cúndèe iní‑dé daña‑dě chindúxi‑dé yɨquɨ cùñú Jèsús. Te té Pìlatú‑áⁿ nǐ sáha‑dé tnúhu. ");
INSERT INTO milNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Te ní nunehe‑dé yɨquɨ cùñú‑gá núú cùrúxí, te ní chidúcúⁿnuu‑dé ɨɨⁿ dóó cuìxíⁿ, te ní chihi‑dé ɨɨⁿ yaú nchìí yɨquɨ naha càva, te vátá yǒo ɨɨⁿ‑gá nguɨ́ndǔxi yaú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Te cùu‑xi nduu vispré nduu ndètatú ñáyiu, núu xǐquide túha‑ná‑yu sá cúú ɨ̀ngá nduu. ");
INSERT INTO milNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Te nchaa ñáyiu dɨ̀hɨ́ ní chinchícúⁿ ñáhá xìi Jesús ndéé distrìtú Galìleá nděndàhá‑yu té Chèé ní sáháⁿ núú nchìí yaú‑áⁿ, núu ní xiní‑yu nàcuáa ní sacáⁿ‑dé yɨquɨ cùñú‑gá xɨtɨ́ yaú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Te ducaⁿ te cuánuhú‑yu vehé‑yu, te ní quide túha‑yu acìtí sàháⁿ tnámí, ndɨhɨ pomàdá, te ní ndetatú‑yu ɨngá nduu‑ǎⁿ nǐ quidé‑yu nàcuáa càháⁿ tnúhu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Te ndumìngú nehé víhí‑ní cuǎháⁿ tucu ñáyiu dɨ̀hɨ́ núú nchìí yaú ní chihi‑güedé yɨquɨ cùñú Jèsús, te nèhé‑yu nchaa sá sàháⁿ tnámí nǐ quide túha‑yu‑áⁿ cuǎháⁿ, te tnàhá tucu ɨɨⁿ ǔú‑gá tnàha dɨhɨ́‑yu nchìcúⁿ ñáhá xìí‑yu cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Te òré ní quexìó‑yu yuhu yàú‑áⁿ te ní xiní‑yu sá yǔú ndèdɨ́ ɨɨⁿ xio‑ná ndécú, ");
INSERT INTO milNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","te ní quɨ́hu‑yu xɨtɨ́ yaú‑áⁿ, dico ñá túú‑gǎ yɨquɨ cùñú Jèsús yɨ́hɨ́. ");
INSERT INTO milNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Te ñá ní cùtnuní tnàhí iní‑yu ndèé ichi cuáháⁿ yɨquɨ cùñú‑gá, te ní xiní‑yu úú espíritú xínú cuèchi núú Yǎ Ndiǒxí xǐnutnɨ́ɨ‑xi dɨ̀ñɨ́‑yu te xǐxíhnu‑xi dóó chàhnchí. ");
INSERT INTO milNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Te ní yùhú‑yu te ñá túú ní cùyɨɨ́‑yu cundèhé‑yu cue espíritú‑áⁿ, te cue espíritú‑áⁿ nǐ xáhaⁿ‑xi xìí‑yu: —¿Ná cuèndá nándùcu‑ndo Jesús Yaá ndécú vǐvú núú yɨ́ndǔxi ñáyiu ní xíhí‑i? ");
INSERT INTO milNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Te ñá túú‑gǎ yɨquɨ cùñú‑gá ndécú ìha chi sa ní ndoto‑gá, te chí dándàcu iní nàcuáa ní cáháⁿ‑gá cútnàhá ní xíndecu‑ndo ndɨ̀hɨ‑gá distrìtú Galìleá, ");
INSERT INTO milNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","chi ní cachí‑gá sá méé‑gǎ cúú‑gǎ ñaní tnáhá‑ndó nchàa‑ndo, te dacuɨtɨ́í cuǎha cuèndá ñáhá‑güedě xii‑gá núú cuè tée ndècu ichi cuehé ichi duha, te cata caa ñaha‑güedě xii‑gá núú cùrúxí, te núú cùrúxí‑áⁿ cuú‑gá dico nduu úní sá cùú‑gá te ndoto‑gá, duha ní cachí‑gá xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Te òré‑áⁿ nǐ ndacu iní‑yu tnúhu ní cáháⁿ Jèsús. ");
INSERT INTO milNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Te sátá dúcáⁿ te ní naquehéⁿ‑yu ichi cuánuhú‑yu, te ní caní‑yu cuèndú núú ndɨ̀ úxí ɨɨⁿ cue tée ní táúchíúⁿ Jèsús cáháⁿ tnúhu‑gá, ndɨhɨ núú dàva‑gá ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Te ñáyiu ducaⁿ nàha tnúhu cuánuhú núú‑güedě‑áⁿ cúú tǎ Màriá Magdalèná, ndɨhɨ tá Juǎná, ndɨhɨ tá Màriá nǎná tě Jàcobó, ndɨhɨ dava‑gá ñáyiu dɨ̀hɨ́. ");
INSERT INTO milNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Dico cue tée‑áⁿ nǐ sani iní‑güedé sá dìcó cáhú ìní‑yu tnúhu xǎhǎⁿ‑yu xii‑güedé nǔu ñá túú ní sàndáá iní‑güedé nàcuáa ní xáhǎⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Dico té Pèlú ní quee‑dé xínú‑dě cuáháⁿ cuándéhé‑dě yaú núú nǐ chihi‑güedé yɨquɨ cùñú Jèsús, te ní sáá‑dé te ní ngáundeyɨ‑dé xító nìhni‑dé xɨtɨ́ yaú‑áⁿ te ní xiní‑dé sá méé‑nǎ dóó nǐ xɨ́ducúⁿ nuu‑gá yúcú ɨ̀ɨⁿ xio, te ío ní cuñúhu‑dé sá dúcáⁿ nǐ cuu, te ní natnɨɨ‑dé ichi cuánuhú‑dé vehe núú xǐndecu‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Te dɨu‑ni nduu‑ǎⁿ ñúhú ǔú cue tée ní xica cuu ndɨhɨ Jèsús ichi cuáháⁿ‑güedé ɨɨⁿ ñuú nání Emàús, te sàcúhuⁿ‑güedé dàtná úú òré ichi ndéé ñuú Jerusàlén, te ndéé ñuú Emàús. ");
INSERT INTO milNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Te ta ndàtnúhu‑güedé cuáháⁿ nchaa nàcuáa ní cuu, ");
INSERT INTO milNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","te nɨni dùcaⁿ xícáháⁿ‑güedé, te Jèsús ní natnahá ñáhá‑gǎ xii‑güedé te ndèca tnaha‑gá ndɨhɨ‑güedé cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Te cuěi ndèhe ñaha‑güedé xii‑gá dico dàtná ɨɨⁿ sá ndèdɨ́ núú‑güedě, chi ñá ná quìní ñáhá‑güedě xii‑gá ní cùu. ");
INSERT INTO milNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Te Jèsús ní xícáⁿ tnúhú‑gǎ núú‑güedě, te xáhaⁿ‑gǎ: —¿Ná tnúhu xǐcáháⁿ‑ndó ñùhu‑ndo ichi núu ducaⁿ ǐo cùu ndɨyɨ́‑ndó‑í? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Te ɨɨⁿ tée nàni Cleofás ní xáhaⁿ‑dě xii‑gá: —¿Te ná cuèndá nchaa ñáyiu íchí nǐ sáá ñuú Jerusàlén xìní‑yu nchaa nàcuáa ní cuu, te ɨɨⁿ dìi‑ná yòhó ñá túú xìní‑n‑í? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Te ní xáhaⁿ‑gǎ xii‑güedé: —¿Te ná ní cuu‑i? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě xii‑gá: —Cuèndá Jèsús tée ñuú Nazàrét càháⁿ‑ndɨ́, chi tée‑áⁿ cúú‑dě ɨɨⁿ tée càháⁿ tnúhu Yá Ndiǒxí, te ío váha ndùu tnúhu càháⁿ‑dé ní cùu, te quìde‑dé sá vǎ yǒo tnàhí ndàcu cada nacuáa cudɨ́ɨ́ ìní Yǎ Ndiǒxí ndɨhɨ ñáyiu ni cùu. ");
INSERT INTO milNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Te cue tée cùu dútú cúnùu, ndɨhɨ cue tée cùnuu taxi tnuní ñáhá xìi‑ndɨ́ ní sáha cuèndá ñáhá‑güedě xii‑dé núú tě Pìlatú te ní sata caa ñaha‑güedě te núú cùrúxí‑áⁿ nǐ xíhí‑dé. ");
INSERT INTO milNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Dico vitna sa ní cuu úní nduu sá nǐ xíhí‑dé, te nchúhú ní sani iní‑ndɨ́ sá těe‑áⁿ dàcácu nihnu ñaha‑dě xii nchúhú ñáyiu isràél núú nchàa tnúndòho tnúhu ndàhú ndécú‑ndɨ̌. ");
INSERT INTO milNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Dico ío cùñúhu‑ndɨ́ cúú, chi ɨɨⁿ ǔú ñáyiu dɨ̀hɨ́ ní tuha ñaha xìi‑dé ndécú ndɨ̀hɨ‑ndɨ́ ní sáháⁿ ngotó‑yu ndéxuehe tàcuíhndá‑gá yaú núú nǐ chihi‑güedé yɨquɨ cùñú‑dé, ");
INSERT INTO milNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","te ní nasáá‑yu càchí‑yu xii‑ndɨ́ sá ñà túú‑gǎ yɨquɨ cùñú‑dé yɨ́hɨ́ xɨ̀tɨ́ yaú‑áⁿ. Te ní xiní‑yu espíritú xínú cuèchi núú Yǎ Ndiǒxí, te ní xáhaⁿ‑xi xìí‑yu sá ndécú vǐvú‑dě. ");
INSERT INTO milNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Te sátá dúcáⁿ te ɨɨⁿ ǔú cue tée cùndɨhɨ‑ndɨ́ ní sáháⁿ ndéhé‑güedě yaú‑áⁿ, te ní xiní‑güedé sá ndàá cúú‑xí nchàa tnúhu ní cáháⁿ ñáyiu dɨ̀hɨ́‑áⁿ, dico ñá túú ní xìní‑güedé tée‑áⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Te Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —¡Ío cùmání sǎ xìní tnùní‑ndó, chi ío cuèé sàndáá iní‑ndó tnǔhu ní cáháⁿ cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha! ");
INSERT INTO milNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Te náa ñá túú tàú‑xi sá ndóhó Crìstú òré cúmǎní‑gǎ sáá nduu ndàa‑gá andɨu nǔú ndécú Dǔtú Ndiǒxí cundecu‑gá‑ǎⁿ? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Te ní ngüíta‑gá xáhaⁿ‑gǎ nàcuáa quèe‑xi nchaa tnúhu càháⁿ‑xi núú tùtú Yǎ Ndiǒxí cuèndá‑gá, te díhna‑gá ní cáháⁿ‑gá nàcuáa ndùu nchaa tnúhu yòdo tnuní núú tùtú ndíi Moìsés, te dǎtnùní ní cáháⁿ‑gá nàcuáa ndùu nchaa tnúhu yòdo tnuní núú tùtú nchaa cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha. ");
INSERT INTO milNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Te òré ní quexìo‑güedé yuhu ñùú núú cuàháⁿ‑güedé‑áⁿ, te Jèsús ní quide‑ni‑gá sá yǎha‑gá quɨ́hɨ́ⁿ‑gá ɨngá xichi ni cùu. ");
INSERT INTO milNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Dico ní cáháⁿ ndàhú‑güedé núú‑gǎ sá quéndǒo‑gá xíáⁿ ndetatú‑gá ndɨhɨ‑güedé, te xǎhaⁿ‑güedě xii‑gá: —Quendóo ndɨhɨ ñaha xìi‑ndɨ́ iha ndetatú‑n chi sa ní cuaa, te tnavíí cundɨquɨⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te xíáⁿ cáá ɨ̀ɨⁿ vehe cuánguɨhu‑güedé ndetatú‑güedé ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Te òré sa yɨ̀hɨ‑güedé mèsá ndɨhɨ‑gá cùdini ndɨhɨ ñaha‑güedé, te ní queheⁿ‑gá pàá te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí, te ní táhú cuèchi‑gá te dǎtnùní ní dácǎhñu ñaha‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Te òré‑áⁿ nǐ naquiní ñáhá‑güedě xii‑gá ní cùu, dico uuⁿni ní ndóñúhú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Te ní xítnàha‑güedé: —Te ndáá sá sǔúní cùdɨ́ɨ́ ìní‑ó òré tá ndàtnúhu‑o ndɨ̀hɨ Jesús véxi ichi, te ta dànehé ñáhá‑gǎ xii‑o nchàa nacuáa quèe‑xi tnúhu càháⁿ‑xi núú tùtú Yǎ Ndiǒxí —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Te ñá túú‑gǎ ní xǐndetu‑güedé chi ndɨ̌hɨ‑ni ní natnɨɨ‑güedé ichi cuánuhú‑güedé ñuú Jerusàlén, te ní nasáá‑güedé núú xǐndecu ndɨ ùxí ɨɨⁿ cue tée ní táúchíúⁿ Jèsús cáháⁿ tnúhu‑gá, ndɨhɨ dava‑gá ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Te cue tée xǐndecu‑áⁿ xǎhaⁿ‑güedě: —Ndáá sá nǐ ndoto Yaá cúú Mèstrú, chi ní xiní ñáhá tě Xǐmú —càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Te cue tée ní nasáá‑áⁿ nǐ cani‑güedé cuèndú nàcuáa ní cuu ichi, ndɨhɨ nàcuáa ní cuu ní naquiní‑güedé Jèsús òré ní táhú‑gǎ pàá ní dácǎhñu ñaha‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Te càháⁿ dúcáⁿ‑ní‑güedě nàcuáa ní cuu ní quexìo Jesús ní ngúnutnɨ́ɨ‑gá ndéé tnuú‑güedé, te xáhaⁿ‑gǎ xii‑güedé: —Yá Ndiǒxí chíndèe ñaha‑gá xii‑ndo ǐo váha cùu iní‑ndó ndècu‑ndo —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Te da ní yùhú‑güedé, te ní sani iní‑güedé sá dìcó ɨɨⁿ espíritú cúú sǎ ndéhé‑güedě ní cùu. ");
INSERT INTO milNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Dico Jèsús ní xáhaⁿ‑gǎ xii‑güedé: —¿Ná cuèndá yùhú‑ndó, te sàni ɨɨⁿ sani úú iní‑ndó‑í? ");
INSERT INTO milNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Chí cúndèhe ndaha‑í ndɨhɨ sáhà‑í te quiní‑ndó nǎ dɨu‑ni‑í. Te chí téndàha ñaha xii‑í te cundehe‑ndo, te núu ɨɨⁿ espíritú ndécú yɨ̀quɨ cuñú‑xi dàtná ndécú ndɨ̀hɨ yúhú —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Te sátá dúcáⁿ nǐ xáhaⁿ‑gǎ te ní dánèhé ñáhá‑gǎ xii‑güedé ndaha‑gá ndɨhɨ sáhá‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Te ío ní cuñúhu‑güedé, te ní cudɨ́ɨ́ ìní‑güedé sá ndécú‑gǎ tnuú‑güedé dico sàni ɨɨⁿ sani úú iní‑güedé, te ní xáhaⁿ Jèsús xii‑güedé: —¿Ndècu ndɨhɨ‑ndo luha sá cáxí‑ó ìha ñá? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Te ní sáñaha‑güedě xii‑gá luha chácá nǐ chíhó, ndɨhɨ dítá ñǔñú ñúhú ndùdí, ");
INSERT INTO milNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","te ní queheⁿ‑gá te ndèhe‑güedé ní xexi‑gá. ");
INSERT INTO milNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Te dǎtnùní ní xáhaⁿ‑gǎ: —Nchaa sá nǐ yáha‑í‑a cùu‑xi sá nǐ cachí tnúhu‑í xii‑ndo cǔtnàhá ndécú ndɨ̀hɨ ñaha‑gá‑í xii‑ndo, chi ní cachí‑í sá dàcuɨtɨ́í càda‑xi nchaa nacuáa càháⁿ‑xi núú tùtú ndíi Moìsés, ndɨhɨ núú tùtú ndèé tnúhu ní cáháⁿ cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha, ndɨhɨ núú lìbrú Sǎlmú —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Te òré‑áⁿ nǐ sáñaha‑gǎ sá xìní tnùní‑güedé, te ní tecú tnùní‑güedé nchaa tnúhu càháⁿ‑xi núú tùtú Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Te ní xáhaⁿ‑gǎ xii‑güedé: —Ducaⁿ ndèé tnuní núú tùtú Yǎ Ndiǒxí sá dàcuɨtɨ́í sǎ yǔhú Crìstú cuú‑í, te nduu úní ndoto‑í. ");
INSERT INTO milNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Te nɨhìí ñuyíú cùténuu tnúhu ní cáháⁿ‑í, dico díhna nuu‑gǎ ñuú Jerusàlén ngüíta‑yu cacunehe ñàhá‑yu xii‑í, te cáháⁿ‑yu nàcuáa ní dánèhé‑í‑yu, te cúñàhá‑yu xii cue ñáyiu sá ná dàndixi túu‑yu iní‑yu sá ñà túú quìde váha‑yu, te dàñá‑yu nchaa ichi cuèhé ichi duha ndècú‑yu, te natnɨɨ́‑yu ichi Yá Ndiǒxí, te ducaⁿ te cada càhnu iní‑gá nchaa yícá cuěchi‑yu. ");
INSERT INTO milNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Te vitna nchòhó cuu‑ndo cuè tée cáháⁿ ndáá nchaa nàcuáa ní cuu chi ní xiní núú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Te yúhú tendaha‑ǐ Espíritú Yǎ Ndiǒxí quixi cundecu ndɨhɨ‑ndo, chi ducaⁿ nǐ cachí‑gá. Dico chí cúndècu‑ni ñuú Jerusàlén‑áⁿ ndèé ná quèxio Espíritú Yǎ Ndiǒxí ngúndecu ndɨhɨ‑ndo cuèndá chindee ñàha‑xi xii‑ndo cada‑ndo nchaa nacuáa ní cáháⁿ‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Te Jèsús ní queñuhu ñaha‑gǎ xii‑güedé ñuú Jerusàlén ndécá ñàha‑gá cuáháⁿ ñuú Bètaniá, te xíáⁿ nǐ ndonehe‑gá ndaha‑gá núú nǐnu, te ní xícáⁿ táhú ñàha‑gá xii‑güedé núú Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Te sátá nǐ xícáⁿ táhú ñàha‑gá xii‑güedé núú Yǎ Ndiǒxí, te ní quee‑gá tnuú‑güedé cuándaa‑gá andɨu. ");
INSERT INTO milNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Te ní ngüíta‑güedé ní cachí‑güedé sá ǐo càhnu cuu Jesús, te ní natnɨɨ‑güedé ichi cuánuhú‑güedé ñuú Jerusàlén, te súúní cùdɨ́ɨ́ ìní‑güedé ñúhú‑güedě ichi. ");
INSERT INTO milNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Te nchaa nduu ní xíndecu‑güedé veñúhu càhnu sá ǐo cùnuu ní ndacáⁿ táhú‑güedě núú Yǎ Ndiǒxí, te ní cachí‑güedé sá ǐo càhnu cuu‑gá. Duha ní cuu dàvá‑áⁿ.");
INSERT INTO milNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cùmání‑gǎ ngáva ñuyíú, te sa ndècu ndɨhɨ Yá Ndiǒxí Déhe‑gá. Te ɨɨⁿ‑ni xǐcuu‑gá. Te Déhe‑gá‑áⁿ nǐ cuu‑gá dàtná ɨɨⁿ tnúhu, chi ní cachí tnúhu‑gá nàcuáa càa Tátá‑gǎ Dútú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Te sa ndècu‑gá ndɨhɨ Dútú Ndiǒxí te ní ngáva ñuyíú. ");
INSERT INTO milNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Te dɨu‑ni tnúhu mee Dǔtú Ndiǒxí ní cuu ní cadúha Déhe‑gá nchaa sá ìó ñuyíú. Te núu ñá túú Děhe‑gá ñá, te ñá túú nǎ coo ñuyíú‑a ni cùu. ");
INSERT INTO milNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Te dɨu‑ni Déhe‑gá quídé‑gǎ ndécú‑ó, te ní dáyèhé‑gá iní‑ó nàcuáa cundecu‑o. ");
INSERT INTO milNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Te tnúhu‑gá ní xíté nuu‑xi núú ndécú nchàa ñáyiu ñùhu ichi cuehé ichi duha. Te ñáyiu‑áⁿ cúǔ‑yu dàtná cue ñáyiu ndècu ɨɨⁿ núú néé, te dɨu‑ní‑yu cachí iní‑yu xocàní‑yu tnúhu‑gá dico vá ndácǔ‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Te ní xíndecu ɨɨⁿ tée ní xínani‑dě Juàá, te tée‑áⁿ nǐ táúchíúⁿ Yǎ Ndiǒxí sá càháⁿ‑dé tnúhu‑gá núú ñǎyiu. Te ní xáhaⁿ‑dě xií‑yu sá věxi Déhe‑gá ñuyíú‑a, te dandìxi túu‑gá iní‑yu cuèndá cutnùní iní‑yu nàcuáa ndùu cuendá Yǎ Ndiǒxí cuèndá quɨ́ndáá iní‑yu tnúhu‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Te ñá dɨ́ú mèe té Juàá ní dàndixi túu‑dé iní‑yu cuèndá cutnùní iní‑yu nàcuáa ndùu cuendá Yǎ Ndiǒxí, chi cuèndá‑ni ní xica cuu‑dé ní cáháⁿ‑dé sá Děhe Yá Ndiǒxí véxi‑gá dandìxi túu‑gá iní‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Te ndáá ndisa sá méé‑gǎ dándìxi túu‑gá iní ñáyiu ñuyíú‑a cuèndá cutnùní iní‑yu nàcuáa ndùu cuendá Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Te ní xíndecu‑gá ñuyíú‑a, te ñáyiu ñuyíú‑a ñá ní cùtnuní iní‑yu yoo cùu‑gá, te dɨu‑ni mee‑gǎ ní cadúha‑gá ñuyíú‑a ní quide‑gá chìuⁿ ní táhú Dǔtú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Te ní quixi‑gá ñuyíú nǐ càdúha mee‑gǎ, dico cue ñáyiu ñuyíú‑a ñá ní cùu váha iní‑yu núú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Dico davá‑yu ní sándáá iní ñáhǎ‑yu xii‑gá, te ní nduu táhǔ‑yu ní nduu déhe ñaha Yǎ Ndiǒxí xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Te ñá túú ní ndùu déhe ñaha‑gǎ xií‑yu sá cúǔ‑yu déhe ñáyiu ñuyíú‑a, àdi sá ndécú tǎtǎ‑yu, nǎnǎ‑yu chi mee Yǎ Ndiǒxí ducaⁿ nǐ cuiní‑gá cunduu sá ndúú děhe ñaha‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Te Déhe‑gá ní quixi túu‑gá ñuyíú‑a, te ní cuu‑gá ɨɨⁿ yɨquɨ cùñú ní xíndecu ndɨhɨ ñaha‑gǎ xii nchoo cuè ñáyiu ní xica cuu túu ndɨhɨ‑gá. Te ní xiní‑ó sǎ ǐo càhnu cuu‑gá cuèndá sá ɨ́ɨ́ⁿ dìi díí‑ni‑gǎ cúú‑gǎ Déhe Yá Ndiǒxí, te ío cùndahú iní ñáhá‑gǎ chíndèe ñaha‑gá xii nchoo ñǎyiu ndècu ñuyíú‑a, te ío ndáá càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Te duha ní cáháⁿ té Juàá cuèndá Déhe Yá Ndiǒxí ní xáhaⁿ‑dě xii ñáyiu: —Cuèndá tée iha ni cáháⁿ‑í ndéé cǎni‑gá ní cachí‑í sá quíxí ɨ̀ɨⁿ tée quixi. Te tée‑áⁿ cúnùu‑gá‑dé, chi díhna‑gá‑dé sa ndècu‑dé dàcúúxí yǔhú —duha ní xáhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Te ío váha iní Yaá‑áⁿ chi xìto ñaha‑gá xii‑o nchàa‑o ɨɨⁿ nduu ɨɨⁿ nduu. ");
INSERT INTO milNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Te ndíi Moìsés ní cachí tnúhu ndíi tnúhu Yá Ndiǒxí tnúhu sá sánú ìchi ñaha xii‑o nacuáa cundecu‑o, dico Déhe‑gá Xítohó Jesucrìstú ní cachí‑gá sá ǐo cùu iní ñáhá Yǎ Ndiǒxí xii‑o. Te ní cáháⁿ‑gá nchaa dava‑gá tnúhu ndáá. ");
INSERT INTO milNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Te ñá ɨ́ɨ́ⁿ ñǎyiu xìní túu‑yu Yá Ndiǒxí. Dico ɨɨⁿdìi díí‑ni Déhe‑gá Yaá ndécú ndɨ̀hɨ‑gá càchí tnúhu‑gá nàcuáa càa‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Te cue tée isràél ndécú ñùú Jerusàlén ní tendaha‑güedě cue dútú ndɨhɨ cue tée cùu levítá cuáháⁿ‑güedé núú ndécú tě Juàá ndúcú tnǔhu‑güedé núú‑dě nǔu ná tée cùu‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Te ní cáháⁿ ndáá‑dé ní xáhaⁿ‑dě xii‑güedé: —Yúhú, ñá dɨ́ú Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a cùu‑í —càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Te ní xáhaⁿ tùcu‑güedé: —¿Te yoo cùu yohó váíⁿ? ¿Á yòhó cúú‑n tě Èliás? —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. Te ní xáhaⁿ tě Juàá: —Yúhú, ñá dɨ́ú tě Èliás cúù‑í —càchí‑dé xǎhaⁿ‑dě. Te xǎhaⁿ tùcu‑güedé: —¿Te yòhó cúú‑n těe ní cachí cue tée ndéé sanaha quìxi cáháⁿ tnúhu Yá Ndiǒxí‑ǎⁿ? —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. Te ní xáhaⁿ‑dě: —Ni ñà dɨ́ú těe‑áⁿ cúù‑í —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Te ní xáhaⁿ tùcu‑güedé: —¿Te ná tée cùu yohó váíⁿ?, cuèndá ducaⁿ nàcani tnúhu‑ndɨ́ núú cuè tée ní tendaha ñàha xii‑ndɨ́ véxi‑ndɨ́, te cáháⁿ duuⁿ‑n nǔu ná tée cùu‑n —cachí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Te ní xáhaⁿ tě Juàá: —Yúhú cúù‑í tée xìca cáháⁿ xɨtɨ́ yucu nàcuáa ní cáháⁿ ndíi Chàiá, chi ndíi‑áⁿ nǐ cachí ndíi: “Chí dáñá ìchi cuehé ichi duha ndècu‑ndo te tnɨɨ‑ndo ìchi váha, chi véxi Yaá ío cùnuu”, duha ní cachí ndíi —càchí té Juàá xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Te cue tée ndùcu tnúhu núú tě Juàá nǔu ná tée cùu‑dé, cue tée‑áⁿ nǐ tendaha ñàha cue tée cùu fariséú xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Te ní xáhaⁿ tùcu‑güedé xii té Juàá: —¿Ná cuèndá dácuàndute‑n ñáyiu te núu ñá dɨ́ú Crìstú cúú‑n, te ni ñà dɨ́ú tě Èliás, te ni ñà dɨ́ú těe véxi cáháⁿ tnúhu Yá Ndiǒxí cúú‑n vàíⁿ? —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Te ní xáhaⁿ tě Juàá: —Yúhú ní ngódó núù‑í dácuàndute‑í ñáyiu. Dico nchìcúⁿ ɨɨⁿ tée véxi, te tée‑áⁿ cúnùu‑gá‑dé dàcúúxí yǔhú, chi yúhú cúù‑í ɨɨⁿ tée duuⁿ duuⁿ ñá túú tàú nandaxi cuědìcó ñɨɨ chàú‑dé dico quìde‑í chìuⁿ‑dé. Te tée‑áⁿ sa ñùhu tnahá‑dé tnuú‑ndó dìcó‑ni sá ñǎ túú xìní‑ndó‑dě —càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Duha ní cuu ñuú Bètábará ñuú cáá ndàa ɨngá xio yúte Jòrdán, yàcáⁿ ní xíndecu té Juàá ní dácuándùte‑dé ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Te nduu tněé ní xiní té Juàá Jèsús véxi yatni‑gá núú ndécú‑dě ndɨhɨ ñáyiu. Te ní xáhaⁿ‑dě xií‑yu: —Chí cúndèhe tée‑ǎⁿ, chi tée‑ǎⁿ cúú‑dě Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a, te véxi‑dé cada càhnu iní‑dé nchaa yícá cuěchi ñáyiu ñuyíú. Te cùu‑dé dàtná ɨɨⁿ mběé quɨtɨ ío váha iní‑xi. ");
INSERT INTO milNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Te dɨu tée‑ǎⁿ ní cachí‑í sá cánchǐcúⁿ‑dé quixi. Te cùnuu‑gá‑dé dàcúúxí yǔhú, chi díhna‑gá‑dé sa ndècu ní cachí‑í xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Te ni yǔhú ñá túú xìní‑í‑dé ní cùu, dico xìca cuu‑í dácuàndute‑í ñáyiu cuèndá nchaa ñáyiu isràél quiní ñáhǎ‑yu xii‑dé —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Te ní xáhaⁿ tùcu‑dé: —Ní xiní‑í Espíritú Yǎ Ndiǒxí ní quee‑xi andɨu věxi cuuⁿ‑xi ngúndecu ndɨhɨ ñaha‑xi xìi‑dé, te dàtná cáá lǒmá cáá Espíritú‑áⁿ věxi cuuⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Te yúhú ñá túú xìní‑í‑dé ní cùu, dico Yá Ndiǒxí Yaá ní tendaha ñàha xii‑í xícá cùu‑í dácuàndute‑í ñáyiu, Yaá‑áⁿ nǐ cachí tnúhu‑gá sá těe na quìní‑í ngúndecu ndɨhɨ Espíritú‑gá sá věxi cuuⁿ andɨu, te tée‑áⁿ taxi‑dé Espíritú‑gá cundecu ndɨhɨ‑o. ");
INSERT INTO milNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Te yúhú ní xiní‑í‑dé te xìní ndáá‑í sá Děhe Dútú Ndiǒxí cúú‑dě. Te xíǎⁿ càchí tnúhu‑í xii‑ndo —càchí té Juàá xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Te nduu tněé‑áⁿ dɨu‑ni xíáⁿ ndécú tě Juàá ndɨhɨ úú cue tée xìca cuu ndɨhɨ‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Te ní xiní‑dé Jèsús ñúhú‑gǎ ichi, te ní xáhaⁿ‑dě xii cue tée xìca cuu ndɨhɨ‑dé‑áⁿ: —Chí cúndèhe tée‑ǎⁿ, chi tée‑ǎⁿ cúú‑dě Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a. Te cùu‑dé dàtná ɨɨⁿ mběé quɨtɨ ío váha iní‑xi —càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Te sá dúcáⁿ nǐ cáháⁿ té Juàá núú cuè tée úú ndɨhɨ‑dé‑áⁿ nǔu ní chinchícúⁿ‑güedé Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Te ní nchócótó‑gǎ ndàa sátá‑gǎ, te ní xiní‑gá sá nchìcúⁿ ñáhá‑güedě xii‑gá. Te ní xáhaⁿ‑gǎ xii‑güedé: —¿Ná nándùcu‑ndo? —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. Te ní xáhaⁿ‑güedě: —¿Ndèé ndécú‑n, Ràbií? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te Ràbií‑áⁿ quéé‑xí Mèstrú tnúhu mee‑güedě. ");
INSERT INTO milNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Te ní xáhaⁿ Jèsús xii‑güedé: —Chí nèhé te quiní‑ndó —càchí‑gá xáhaⁿ‑gǎ. Te ní xica‑güedé cuáháⁿ‑güedé, te ní quexìo‑güedé núú quídé vèhe‑gá. Te ndècu‑ni‑güedé ndɨhɨ‑gá ní cuaa, chi dàtná òré caa cúmí sacuaa ní sáá‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Te úú cue tée‑áⁿ nǐ tnɨɨ‑güedé tnúhu ní cáháⁿ té Juàá, te ní chinchícúⁿ‑güedé Jèsús. Te núú ùú cue tée‑áⁿ, ɨɨⁿ‑dé nání‑dě Ndrǐxí, te ñaní‑dé cúú tě Xǐmú, àdi Pelú chi úú dɨ̀u‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Te té Ndrǐxí‑áⁿ nǐ nanducu‑ni‑dě ñaní‑dé te ní xáhaⁿ‑dě: —Ní naníhí‑ndɨ̌ tée cùu Mesiás —càchí‑dé xǎhaⁿ‑dě. Te Mèsiás‑áⁿ quéé‑xí Crìstú tnúhu mee‑güedě, Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Te ndèca té Ndrǐxí ñaní‑dé cuáháⁿ núú ndécú Jèsús. Te òré ní xiní ñáhá Jèsús xii té Xǐmú, te ní xáhaⁿ‑gǎ: —Yòhó cúú‑n tě Xǐmú déhe té Jònás, te vitna danàni ñaha‑í Cèfás xii‑n —càchí‑gá xáhaⁿ‑gǎ. Te Cèfás‑ǎⁿ quéé‑xí Pèlú tnúhu mee‑güedě. ");
INSERT INTO milNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Te nduu tněé ní sani iní‑gá quɨ́hɨ́ⁿ‑gá distrìtú Galìleá. Te ní naníhí‑gǎ ɨɨⁿ tée nàni Lipé, te ní xáhaⁿ‑gǎ xii‑dé: —Néhé ná quɨ̀hɨ́ⁿ‑ó nǔú quɨ̀hɨ́ⁿ‑í‑a —càchí‑gá xáhaⁿ‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Te té Lìpé‑áⁿ cúú‑dě tée ñuú Bètsaidá. Te dɨu‑ni ñuú yàcáⁿ cúú ñùú té Ndrǐxí ndɨhɨ té Pèlú. ");
INSERT INTO milNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Te té Lìpé ní naníhí tnáhá‑dě ndɨhɨ té Natanàél, te ní xáhaⁿ‑dě: —Ní naníhí‑ndɨ̌ tée dii cuèndú‑xi ní chídó tnùní ndíi Moìsés ndɨhɨ dava‑gá cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha. Te tée‑áⁿ nání‑dě Jèsús déhe té Chèé, tée ñuú Nazàrét —càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Te ní xáhaⁿ tě Natanàél xii té Lìpé: —¿Te náa ío váha càa ñuú Nazàrét nǔu da yàcáⁿ quee tée cáháⁿ tnúhu Yá Ndiǒxí? —càchí‑dé xǎhaⁿ‑dě. Te ní xáhaⁿ tě Lìpé: —Néhé ná quɨ̀hɨ́ⁿ‑ó te quiní‑n —càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Te òré ní xiní Jèsús té Natanàél tá cùyatni‑dé cuáháⁿ, te ní cáháⁿ‑gá cuèndá‑dé te ní cachí‑gá: —Tée véxi‑ǎⁿ cúú‑dě mei těe isràél, te ñá ɨ́ɨ́ⁿ ndùu dandahú‑dé ñáyiu —càchí‑gá xáhaⁿ‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Te ní xáhaⁿ tě Natanàél xii Jèsús: —¿Te nása náquiní ñáhá‑n? —càchí‑dé xǎhaⁿ‑dě. Te ní xáhaⁿ Jèsús: —Yúhú sa ní xiní ñáhà‑í xii‑n òré ndécú‑gǎ‑n càha yutnu ngúxí‑ǎⁿ te ni tě Lìpé vátá cáná ñàha‑gá‑dé xii‑n òré‑áⁿ —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Te sá dúcáⁿ nǐ cáháⁿ‑gá, núu ní xáhaⁿ tě Natanàél xii‑gá: —Mèstrú, yòhó cúú‑n Děhe Dútú Ndiǒxí yɨ́ndàha‑n ñáyiu isràél —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Te Jèsús ní xáhaⁿ‑gǎ: —Cuèndá sá nǐ xiní ñáhà‑í xii‑n càha yutnu ngúxí xíǎⁿ iní ñáhá‑n, dico cuéhé‑gǎ núú sǎ quìní‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Te ní xáhaⁿ tùcu‑gá: —Na càchí tnúhu ndáá‑í sá sàá nduu, te quiní‑ndó nàcaáⁿ andɨu. Te quiní‑ndó cuè espíritú xínú cuèchi núú Yǎ Ndiǒxí sá ndàa nuu‑xi quide‑xi núú cúndècu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Te nduu úní sá dúcáⁿ nǐ cuu te ní xóo ɨɨⁿ vico tnǎndaha ñuú Cànaá, ɨɨⁿ ñuú yɨ́ndèhu distritú Galìleá. Te yàcáⁿ ní xíndecu nǎná Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Te tnàhá Jèsús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ní cáháⁿ‑yu cuáháⁿ‑gá ndɨhɨ‑güedé vico‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Te òré ní ndɨhɨ vìnú, te ní xáhaⁿ nǎná Jèsús xii‑gá: —Ñá túú‑gǎ vìnú ndécú ndɨ̀hɨ́‑yu —càchí‑aⁿ xǎhaⁿ‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Te ní xáhaⁿ Jèsús xii‑aⁿ: —Nǎá, ñá túú xìni ñuhu‑xi da yúhú cúñaha‑n cuèndá vìnú‑áⁿ, chi vátá tnàhá‑gá òré quiní‑yu yoo cùu yúhú —càchí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Te ní xáhaⁿ‑aⁿ xìi ñáyiu xìnu cuechi: —Cada‑ndo nchàa nacuáa na càháⁿ Jèsús —càchí‑aⁿ xǎhaⁿ‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Te yàcáⁿ nútnɨ̌ɨ íñú quɨ́dɨ yúú te quée dàtná ɨɨⁿ cièndú lǐtrú ndute ɨɨⁿ ɨɨⁿ quɨ́dɨ‑áⁿ. Te ndute‑áⁿ nándɨ̌hɨ ñáyiu isràél ndáhǎ‑yu te nàqueté‑yu cóhǒ‑yu chi ducaⁿ tnàhí quìdé‑yu nàcuáa sàndáá iní‑yu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Te ní xáhaⁿ Jèsús xii nchaa cue tée xìnu cuechi: —Nadachìtú‑ndó ndùte ndɨ nchaa quɨ́dɨ‑áⁿ —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. Te ní nadachìtú‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Te ní xáhaⁿ‑gǎ: —Vitna te tava‑ndo lùha, te canehe‑ndo quɨ̌hɨ́ⁿ cuáha‑ndo těe quìde vico —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. Te ducaⁿ nǐ quide‑güedé ní tava‑güedé luha nèhe‑güedé cuáháⁿ ní sáha‑güedé tée quìde vico. ");
INSERT INTO milNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Te ní xito ndéé tée quìde vico‑áⁿ, te sa ní nduu‑xi vìnú, te ñá túú ní xìní‑dé ndèé véxi‑xi, dico mee cuè tée xìnu cuechi sa naha‑güedé núú nǐ tava‑güedé. Ducaⁿ te tée quìde vico‑áⁿ nǐ cana‑dé tée tnǎndaha. ");
INSERT INTO milNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Te ní xáhaⁿ‑dě: —Nchaa ñáyiu quìde vico queñuhú‑yu díhna‑gá vìnú váha. Te sa vài vinú váha xìhí‑yu, te dǎtnùní quéñùhú‑yu vìnú ndàhú. Te yòhó díhna‑gá vìnú ndàhú ní queñuhu‑n, te ndéé núú nǐ ndɨhɨ‑ná ní queñuhu‑n vìnú váha —càchí tée quìde vico‑áⁿ xǎhaⁿ‑dě xii tée tnǎndaha‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Te sá nǐ nadatɨ̀u Jesús ndute‑áⁿ nǐ nduu‑xi vìnú cúú‑xí ɨ̀ɨⁿ chiuⁿ díhna nuu sǎ vǎ yǒo tnàhí ndàcu cada ní quide‑gá ñuú Cànaá, ɨɨⁿ ñuú yɨ́ndèhu distritú Galìleá, te chìuⁿ ní quide‑gá‑áⁿ cúú‑xí ɨ̀ɨⁿ chiuⁿ cahnu vihi, núu xíǎⁿ ní cutnùní iní‑yu sá ǐo càhnu cuu‑gá, te ní sándáá iní ñáhá nchàa cue tée xìca cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Te sátá nǐ yáha vico, te ní xica Jèsús ndɨhɨ nǎná‑gǎ, ndɨhɨ cue ñaní‑gá, ndɨhɨ nchaa cue tée xìca cuu ndɨhɨ‑gá cuáháⁿ‑yu ñuú Capèrnaúm. Te yàcáⁿ ní xíndecú‑yu ɨɨⁿ ǔú nduu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Te ta cùyatni cada ñáyiu isràél vico pàscuá, te ní xica Jèsús cuáháⁿ‑gá ñuú Jerusàlén. ");
INSERT INTO milNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Te sátá nǐ sáá‑gá yàcáⁿ, te ní xica‑gá cuáháⁿ‑gá veñúhu càhnu sá ǐo cùnuu, te xɨtɨ́ veñúhu‑áⁿ nǐ xiní‑gá ndécú ñǎyiu dìcó‑yu ndɨcutu, mběé ndɨhɨ lǒmá, te tnàhá ñáyiu dàma díhúⁿ núcǒo‑yu ní xiní‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Te ní queheⁿ‑gá ɨɨⁿ ǔú yoho, te ní cáunuu tnàha‑gá, te ní dáyùhu‑gá ñáyiu ní queé‑yu quehé veñúhu, ndɨhɨ ndɨcutú‑yu ndɨhɨ mběě‑yu. Te cue ñáyiu dàma díhúⁿ‑ǎⁿ ní dángǒyo‑gá díhǔⁿ‑yu, te ní dándùá‑gá mèsá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Te ní xáhaⁿ‑gǎ xii cue ñáyiu dìco lómá: —¡Queñuhu‑ndo nchàa quɨtɨ‑a xɨtɨ́ veñúhu‑a! ¡Vá cádá‑ndó vèhe núú yǎhu núú cúú vèhe Tátà‑í Dútú Ndiǒxí! —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Te xíǎⁿ ní ndacu iní cue tée xìca cuu ndɨhɨ‑gá sá dúcáⁿ yòdo tnuní núú tùtú‑gá, te càchí‑xi: “Ío cùyica iní‑í chi ñá cuìní‑yu canehe íǐ‑yu vehe Tǎtà‑í”, duha càchí‑xi núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Te ní xáhaⁿ cuè tée isràél xii‑gá: —¿Ná cúú sǎ vǎ yǒo tnàhí ndàcu cada, cada‑n cuèndá cutnùní iní‑ndɨ́ sá cúú dùha taxi tnuní ñáhá‑n xìi‑ndɨ́‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Te ní xáhaⁿ Jèsús: —Chí dángòyo veñúhu‑a, te není xɨtɨ́ úní nduu te sa nadàxínu‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Te ní xáhaⁿ tùcu cue tée isràél: —Údico íñú cuíá nǐ xíndecuu‑güedé ní sáá veñúhu‑a, te yòhó cuìní‑n nàdaxínu‑n xɨ̀tɨ́ úní‑ni nduu —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Dico sá nǐ cáháⁿ‑gá chi ñá dɨ́ú cuèndá veñúhu ni cǎháⁿ‑gá chi cuèndá yɨquɨ cùñú‑gá ní cáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Núu sátá nǐ xíhí‑gá, te ní ndoto‑gá, te òré‑áⁿ nǐ ndacu iní cue tée ní xica cuu ndɨhɨ‑gá nàcuáa ní cáháⁿ‑gá, núu xíǎⁿ ní sándáá iní‑güedé tnúhu yòdo tnuní núú tùtú‑gá. Te ducaⁿ te ní sándáá iní‑güedé tnúhu ní cáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Te òré ndécú Jèsús vico pàscuá, te ío vài ñáyiu ní sándáá iní ñáhá xìi‑gá cuèndá ío tɨtnɨ́ sá vǎ yǒo tnàhí ndàcu cada ní quide‑gá ní xiní‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Dico Jèsús ñá ní cǎháⁿ‑gá nchaa tnúhu ñùhu iní‑gá, chi sa ní cutnùní iní‑gá sá ñà túú cùu váha iní‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Te ñá túú xìni ñuhu‑gá ɨɨⁿ ñáyiu cúñaha nàcuáa càa iní nchaa tnàha ñáyiú‑yu, chi mee‑gǎ sa nàha ndáá‑gá nàcuáa càa iní‑yu nchaá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ní xíndecu ɨɨⁿ tée cùu fariséú ní xínani‑dě Nicòdemú, te ní cuu‑dé ɨɨⁿ tée cùnuu núú ñǎyiu isràél. ");
INSERT INTO milNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Te tée‑áⁿ nǐ sáháⁿ‑dé niú ní cáháⁿ ndɨhɨ‑dé Jèsús, te ní xáhaⁿ‑dě: —Mèstrú, yúhú ndɨhɨ dava‑gá‑güedé sa nàha‑ndɨ́ sá Yǎ Ndiǒxí ní tendaha ñàha‑gá xii‑n věxi‑n dànehé ñáhá‑n xìi‑ndɨ́, chi núu ñá túú Yǎ Ndiǒxí ndécú ndɨ̀hɨ‑n, te vá ndácú‑n càda‑n nchaa sá vǎ yǒo tnàhí ndàcu cada quide‑n —cachí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Te ní xáhaⁿ Jèsús: —Na càchí tnúhu ndáá‑í xii‑n sǎ ncháá ñǎyiu vá ná càcu saa tucu, te vá ndɨ̌hu ndaha ñàha Yá Ndiǒxí xií‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Te ní xáhaⁿ tě Nicòdemú: —¿Te nása cada ɨɨⁿ ñáyiu sa ní yɨɨ te cacu‑ni tucú‑yu? ¿Náa ndɨ́hu tucú‑yu xɨtɨ́ nǎnǎ‑yu te cacu tucú‑yu xito cùu uú‑ǎⁿ? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Te ní xáhaⁿ Jèsús: —Na càchí tnúhu ndáá‑í xii‑n sǎ nchàa ñáyiu na ndùu ndoo nduu nine iní‑xi cuú‑yu ñáyiu ní na càcu saa ndɨhɨ ndute ndɨhɨ Espíritú Yǎ Ndiǒxí, ñáyiu‑áⁿ ndɨ̌hu ndaha ñàha‑gá xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Te nchaa ñáyiu càcu ñuyíú‑a, chi déhe ñáyiu ñuyíú‑a cùú‑yu. Te ñáyiu ní nduu ndoo ní nduu nine iní‑xi, ñáyiu‑áⁿ nǐ nduu táhǔ‑yu Espíritú Yǎ Ndiǒxí te tàxi tnuní ñáhá‑nǎ Espíritú‑gá xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Te vá cúñǔhu‑n tnǔhu ní cáháⁿ‑í‑a, chi nchaa ñáyiu ní sándáá iní ñáhá xìi‑í ní nduu ndoo ní nduu nine iní‑yu, te ñáyiu‑áⁿ cúǔ‑yu dàtná ñáyiu ní nacacu saa. ");
INSERT INTO milNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Táchí nděni xíáⁿ tècú dóho‑o xìco‑xi, dico ñá túú xìní‑ó ndèé ichi véxi‑xi, te ni ñà túú xìní‑ó ndèé ichi cuáháⁿ‑xi. Ducaⁿ sǎtnahá‑xi cùu Espíritú‑gá ndécú ndɨ̀hɨ ñáyiu ní nduu ndoo ní nduu nine iní‑xi —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Te dǎtnùní ní xícáⁿ tnúhú tùcu té Nicòdemú núú‑gǎ, te xǎhaⁿ‑dě xii‑gá: —¿Te nása ndùu tnúhu càháⁿ‑n dùcaⁿ caháⁿ‑n? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Te ní xáhaⁿ Jèsús: —Yòhó cúú‑n ɨ̀ɨⁿ tée cùtnuní iní‑xi, chi dàcuaha‑n ñáyiu isràél, ¿te ñá tècú tnùní‑n tnǔhu càháⁿ‑í‑u? ");
INSERT INTO milNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Te na càchí tnúhu ndáá‑í xii‑n sǎ nchǔhú càháⁿ‑ndɨ́ ɨɨⁿ sá nǐ tecú tnùní‑ndɨ́, te càháⁿ ndáá‑ndɨ́ cuèndá ɨɨⁿ sá nǐ xiní‑ndɨ́. Dico nchòhó ñá tècú tnùní‑ndó tnǔhu càháⁿ‑ndɨ́. ");
INSERT INTO milNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Te ñá sàndáá iní‑ndó tnǔhu càháⁿ‑í cuèndá nchaa nàcuáa cùu ñuyíú‑a, te uuⁿ‑gá cada‑ndo nǔu cáháⁿ‑í cuèndá nchaa nàcuáa cùu andɨu. ");
INSERT INTO milNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Vá yǒo ɨɨⁿ sàá andɨu, te cani‑xi cuèndú nàcuáa càa. Chi ɨɨⁿdìi díí‑ni yúhú véxi cuuⁿ‑í andɨu, te cùu‑í ñaní tnáhá‑ndó nchàa‑ndo. Te dɨu‑ni yàcáⁿ ndaa‑í cundecu‑í. ");
INSERT INTO milNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Te dàtná ní ndanehe ndíi Moìsés cóó nǐ sata caa ndíi‑dɨ xɨtɨ́ yucu, ducaⁿ càda ñaha‑güedé cata caa ñaha‑güedě núú cùrúxí xii yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ɨɨⁿ nduu, ");
INSERT INTO milNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","te ducaⁿ yǎha‑í cuèndá nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í te nduu táhǔ‑yu cundecú‑yu ndɨhɨ Yá Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Te Yá Ndiǒxí ío cùu iní‑gá ñáyiu ñuyíú‑a. Te ɨɨⁿdìi‑ni Déhe‑gá ndécú, te ní tendaha ñàha‑gá ní quixi‑gá ñuyíú‑a, te núu na quɨ̀ndáá iní ñáhá ñǎyiu, te vá cuǐta nihnú‑yu, chi nduu táhǔ‑yu cundecú‑yu ndɨhɨ‑gá nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Te Yá Ndiǒxí ñá túú ní tèndaha‑gá Déhe‑gá quixi‑gá ñuyíú‑a dacuǐta nihnu‑gá ñáyiu, chi ní tendaha‑gǎ Déhe‑gá ní quixi‑gá sá dácǎcu nihnu‑gá ñáyiu ñuyíú‑a núú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nchaa ñáyiu sàndáá iní ñáhá xìi Déhe‑gá, te vá cuǐta nihnú‑yu. Te nchaa ñáyiu ñá túú sàndáá iní ñáhá xìi Déhe‑gá ñùhú‑yu ichi cuáháⁿ‑yu núú ùhú núú ndàhú, chi ñá túú sàndáá iní‑yu Déhe Dútú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chi ní quixi Déhe‑gá ñuyíú‑a ní dándíxí tǔu‑gá iní‑yu cuèndá cutnùní iní‑yu nàcuáa ndùu cuendá Yǎ Ndiǒxí te tnɨɨ́‑yu ɨɨⁿ ichi váha ni cùu, te ñá ní tnàhá iní‑yu, chi ní cudɨ́ɨ́‑gǎ iní‑yu nchaa sá cuèhé sá dúhá dàcúúxí sǎ vǎha, núu xíǎⁿ tá xǐta nihnú‑yu cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Te nchaa ñáyiu quìde nchaa sá cuèhé sá dúhá ñǎ tnàhá iní‑yu cutnùní iní‑yu nàcuáa ndùu cuendá Yǎ Ndiǒxí, te ñá tnɨ́ɨ̌‑yu tnúhu‑gá cuèndá yùhú‑yu nduu tnùní nchaa sá quídě‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Te nchaa ñáyiu ñùhu ichi ndáá cuìní‑yu cutnùní iní‑yu nàcuáa ndùu cuendá Yǎ Ndiǒxí, te cùtnuní sá chíndèe ñaha‑gá xií‑yu, chi quìde váha‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Te sátá dúcáⁿ nǐ cuu, te ní quee Jèsús cuáháⁿ‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá distrìtú Jùdeá. Te yàcáⁿ ní xíndecu tnaa‑gá ndɨhɨ‑güedé ní xóo dacuàndute‑güedé ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Te ndècu té Juàá ɨɨⁿ xichi núú nání Ènón yatni ñuú Sàlém dácuàndute‑dé ñáyiu, chi yàcáⁿ ío váha ñùhu ndute, núu xíǎⁿ ní xóo quɨ́hɨ́ⁿ ñáyiu yàcáⁿ ní xóo cuanduté‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Duha ní cuu cútnàhá vátá ngává‑gǎ té Juàá vecaá. ");
INSERT INTO milNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Te ní cacu ɨɨⁿ cuèndú ní cáháⁿ cue tée xìca cuu ndɨhɨ té Juàá ndɨhɨ ɨɨⁿ ǔú cue tée isràél, núu ndědacàa sá vǎha‑gá cada ñáyiu cuèndá nduu íǐ‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Te ní sáháⁿ‑güedé núú ndécú tě Juàá ní xáhaⁿ‑güedě: —Mèstrú, tée ní quixi núú nǐ xíndecu‑n ndàa ɨngá xio yúte Jòrdán, tée dii cuèndú‑xi ní cáháⁿ‑n, tée‑ǎⁿ dácuàndute‑dé tnàhá‑dé ñáyiu. Te ío vài ñáyiu ní chinchícúⁿ ñáhá xìi‑dé —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Te ní xáhaⁿ tě Juàá: —Te vá yǒo ɨɨⁿ ndàcu cada ɨɨⁿ chiuⁿ nacuáa cuu váha iní Yǎ Ndiǒxí, te núu ñá túú mèe‑gá chíndèe ñaha‑gá xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Te nchòhó sa nàha‑ndo sá yǔhú ní cáháⁿ ndáá‑í sá ñà dɨ́ú Crìstú cúù‑í, dico mee Yǎ Ndiǒxí ní tendaha ñàha‑gá yódó nùu‑í véxi núú Yàá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Te nchòhó xìní‑ndó sǎ ɨ̀ɨⁿ tée tnǎndaha te xíchí tnǎndaha ndɨhɨ‑ná‑dé cúndɨ̀hɨ‑dé. Te tée ní xica ndáhú ǐo cùdɨ́ɨ́ ìní‑dé ndèdóho‑dé nchaa tnúhu càháⁿ tée tnǎndaha‑áⁿ. Te ducaⁿ sǎtnahá‑xi cùu yúhú, chi ío cùdɨ́ɨ́ ìní‑í sá váí ñǎyiu ta chìnchícúⁿ ñáhá xìi Jesús cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Te uuⁿ‑gá cuita cuu vài ñáyiu cutnùní iní‑xi sá ǐo cùnuu‑gá, te yúhú cuita ndóo ndee‑í quɨ́hɨ́ⁿ —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Te ɨɨⁿdìi díí‑ni Crìstú Yaá véxi cuuⁿ andɨu cùnuu‑gá núú ñùyíú‑a. Te nchaa ñáyiu ndècu ñuyíú‑a cùú‑yu ñáyiu ñuyíú iha, te càháⁿ‑yu sá cúú‑xí ñùyíú‑a. Dico Crìstú Yaá véxi cuuⁿ andɨu ");
INSERT INTO milNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","càháⁿ‑gá ɨɨⁿ sá nǐ xiní‑gá, te càháⁿ‑gá ɨɨⁿ sá nǐ tecú dóho‑gá. Te ñá túú cuìní‑yu quɨndáá iní‑yu tnúhu càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Te nchaa ñáyiu tnɨ̀ɨ tnúhu càháⁿ Yaá véxi cuuⁿ andɨu‑áⁿ càháⁿ‑yu sá tnǔhu Yá Ndiǒxí cúú‑xí ɨ̀ɨⁿ sá ndàá. ");
INSERT INTO milNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Te Déhe‑gá Yaá véxi cuuⁿ andɨu càháⁿ‑gá mee‑ni tnǔhu‑gá. Te ñá ùhú iní‑gá ní sáñaha‑gǎ Espíritú‑gá ndécú ndɨ̀hɨ Déhe‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Te Dútú Ndiǒxí ío cùu iní‑gá Déhe‑gá, núu ní xáhaⁿ‑gǎ sá méé‑gǎ taxi tnùní‑gá nchaandɨ túhú sá ìó. ");
INSERT INTO milNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Te nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi Déhe‑gá, ñáyiu‑áⁿ cundecú‑yu ndɨhɨ‑gá nɨ caa nɨ quɨ́hɨ́ⁿ. Te nchaa ñáyiu vá quɨ̀ndáá iní ñáhá xìi Déhe Yá Ndiǒxí ío dandòho ñaha‑gá xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Te ní níhí cue tée cùu fariséú tnúhu sá vài‑gá ñáyiu ta chìnchícúⁿ ñáhá xìi Jesús. Te ducaⁿ vài‑gá‑yu ta dàcuandute‑gá cuáháⁿ dàcúúxí tě Juàá. ");
INSERT INTO milNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Te cuěi ñá dɨ́ú mèe‑gá dácuàndute ñaha‑gá xií‑yu, dico cue tée xìca cuu ndɨhɨ‑gá dácuàndute ñaha‑güedé xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Te ní níhí Jèsús tnúhu nàcuáa càháⁿ cue tée cùu fariséú, núu ní ndee‑gá distrìtú Jùdeá cuánuhú tucu‑gá distrìtú Galìleá. ");
INSERT INTO milNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Te ichi ñùhu‑gá ní nayáha‑gá distrìtú Sàmariá. ");
INSERT INTO milNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Te ní sáá‑gá ɨɨⁿ ñuú nání Sìcár te ñuú‑áⁿ yɨ́ndèhu‑xi distritú Sàmariá. Te xíáⁿ cáá yàtni ñuhu núú nǐ sáha táhú ndǐi Jàcób déhe ndíi ndíi Chèé. ");
INSERT INTO milNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Te yàcáⁿ cáá dòco ní cuu cuèndá ndíi Jàcób. Te cùu‑xi datná cuádava nduu ñùhu Jesús ichi, te ío ní xàú‑gá nǔu ní sáá‑gá yuhu dòco‑áⁿ nǐ ngóo‑gá ndétàtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Te ní xica cue tée xìca cuu ndɨhɨ‑gá cuáháⁿ‑güedé xɨtɨ́ ñuú Sìcár cuánguaaⁿ‑güedé sá cáxí‑güedě. Te yuhu dòco‑áⁿ núcǒo‑gá ní sáá ɨɨⁿ ñadɨ̀hɨ́ ñaha distrìtú Sàmariá véxi quéhnu‑aⁿ ndute, te ní xáhaⁿ Jèsús: —Taxi táhú luha ndute na còho‑í —càchí‑gá xáhaⁿ‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Te ní xáhaⁿ ñàdɨhɨ́‑áⁿ: —¿Ná cuèndá da núù‑í xìcáⁿ‑n ndùte coho‑n? Te yòhó cúú‑n těe isràél, te yúhú cúù‑í ñaha Sàmariá —càchí‑aⁿ xǎhaⁿ‑aⁿ xìi‑gá. Te ducaⁿ nǐ xáhaⁿ‑aⁿ, chi ñá túú ndècu váha ñáyiu isràél ndɨhɨ ñáyiu distrìtú Sàmariá. ");
INSERT INTO milNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Te ní xáhaⁿ Jèsús xii‑aⁿ: —Ñá cútnùní iní‑n nǎ taxi Yá Ndiǒxí xii‑n, te ni ñǎ cútnùní iní‑n yòo xicáⁿ ndute núú‑n. Te núu dìcó xìní‑n yòo cuu yúhú á, te da mee‑n cǎcáⁿ‑n ndùte núù‑í coho‑n, te yúhú taxi‑í ndute cundecu ndɨhɨ‑n nǔú cuàháⁿ núú věxi —càchí‑gá xáhaⁿ‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Te ní xáhaⁿ tùcu ñadɨhɨ́‑áⁿ: —Tǎtá, nì sá quěhnu‑n ndùte ñá túú nèhe‑n, te doco‑a cùnú víhí, te ñá túú ndèé quɨ́ngueheⁿ‑n ndùte taxi‑n coho‑í. ");
INSERT INTO milNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ndíi Jàcób ñaní tnáhá‑ndɨ̌ ní xíndecu ndèé sanaha nǐ cadúha ndíi doco‑a nǐ tóo ndute ní xihi ndíi, ndɨhɨ nchaa déhe ndíi, ndɨhɨ nchaa quɨtɨ ndíi, te ní ndóo cùu cuendá‑ndɨ́. ¿Te násai, te yòhó cúnùu‑gá‑n dàcúúxí ndǐi‑ǎⁿ? —càchí‑aⁿ xǎhaⁿ‑aⁿ xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Te ní xáhaⁿ Jèsús: —Nchaa ñáyiu xìhi ndute doco‑a, te vá cúú větú dúcáⁿ ìní‑yu chi dayìchí ñáhá‑ní tùcu‑xi ndute‑a. ");
INSERT INTO milNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Dico nchaa ñáyiu na còho ndute na cuáñaha‑ǐ, te vá ɨ́ɨ́ⁿ ndùu‑gá dayìchí ñáhá‑xí ndùte‑áⁿ xií‑yu, chi ndute cuáñaha‑ǐ cúú‑xí ndùte váha‑gá. Te dàtná quéé nìhni ndute xɨtɨ́ doco‑a, nchaa‑ni nduu ñùhu ñá túú yìchí, ducaⁿ sǎtnahá‑xi cada‑xi chi candeca‑xi iní‑yu nɨ caa nɨ quɨ́hɨ́ⁿ, te núu na còhó‑yu ndute cuáñaha yǔhú —càchí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Te ní xáhaⁿ‑aⁿ: —Tǎtá, taxi ndute‑áⁿ ná còho‑í cuèndá sá vǎ dáyìchí ñáhá tnàhí‑gá‑xi ndute. Te vá quíxí‑gǎ‑í quixi quéhnu‑í ndute doco‑a —càchí‑aⁿ xǎhaⁿ‑aⁿ xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Te ní xáhaⁿ Jèsús: —Cuàháⁿ cuángàna yɨɨ‑n, te quixi‑ndo ìha —cachí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Te ní xáhaⁿ‑aⁿ: —Ñá túú yɨ̀ɨ‑í —càchí‑aⁿ xǎhaⁿ‑aⁿ xìi‑gá. Te ní xáhaⁿ tùcu Jesús: —Ndáá càháⁿ‑n sǎ ñà túú yɨ̀ɨ‑n. ");
INSERT INTO milNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Dico ní cuu úhúⁿ tée cǎndeca‑n, te tée ndèca‑n vitna chi ñá dɨ́ú yɨ̀ɨ‑n cuu‑dé, te ndáá càháⁿ‑n sǎ ñà túú yɨ̀ɨ‑n —cachí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Te sá dúcáⁿ nǐ xáhaⁿ‑gǎ nǔu ní xáhaⁿ tùcu‑aⁿ: —Tǎtá, yúhú sání ìní‑í sá yòhó cúú‑n ɨ̀ɨⁿ tée càháⁿ tnúhu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Te cue ñaní tnáhá‑ndɨ̌ ní xíndecu ndéé sanaha nǐ xóo cada càhnú‑yu Yá Ndiǒxí tɨndúú‑a, dico nchòhó ñáyiu isràél càchí‑ndó sǎ nděé ñuú Jerusàlén cada càhnu‑o‑gá —càchí‑aⁿ xǎhaⁿ‑aⁿ xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Te ní xáhaⁿ Jèsús xii‑aⁿ: —Ɨɨⁿ tnúhu na càháⁿ‑í‑a, te quɨndáá iní‑n. Sa ta cùyatni sáá nduu sá ñà dɨ́ú‑gǎ mee‑ni tɨ̀ndúú‑a, te ni ñà dɨ́ú‑gǎ mee‑ni ñùú Jerusàlén cada càhnu‑ndo Tátá‑ó Dǔtú Ndiǒxí, chi nděni ní cuu cada càhnu‑ndo‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Te nchòhó cue ñáyiu Sàmariá chi ñá cútnùní iní‑ndó nǎ cúú sǎ quídé càhnu‑ndo, dico nchúhú ñáyiu isràél, chi cùtnuní iní‑ndɨ́ ná cúú sǎ quídé càhnu‑ndɨ́. Chi ɨɨⁿ tée isràél véxi‑dé dàcácu nihnu‑dé ñáyiu cuèndá vá quɨ̀hɨ́ⁿ‑yu núú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Te není vitna ngüíta‑yu cada càhnu ndisá‑yu Tǎtá‑ó Dǔtú Ndiǒxí, te cadá‑yu nɨ yùhu nɨ iní‑yu sá cúú‑xí‑gǎ, chi mee‑gǎ ducaⁿ cuìní‑gá cadá‑yu cada càhnú‑yu‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Te Yá Ndiǒxí chi ɨɨⁿ espíritú cúú‑gǎ. Te nchaa ñáyiu na càda cahnu ñaha, te cadá‑yu nɨ yùhu nɨ iní‑yu sá cúú‑xí‑gǎ te cadá‑yu dàtná càháⁿ tnúhu‑gá —càchí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Te ní xáhaⁿ ñàdɨhɨ́‑áⁿ: —Xìní‑í sá quíxí těe cùu Mesiás, tée càchí‑güedé nání Crìstú. Te tée‑ǎⁿ ná sàá‑dé, te cachí tnúhu ndáá‑dé nàcuáa cuu —càchí‑aⁿ xǎhaⁿ‑aⁿ xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Te ní xáhaⁿ Jèsús: —Dɨu tée‑áⁿ cúú yǔhú tée ndàtnúhu ndɨhɨ‑n —càchí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Te òré‑áⁿ nǐ ndexìo cue tée xìca cuu ndɨhɨ‑gá, te ní cuñúhu‑güedé sá ndátnǔhu‑gá ndɨhɨ ñadɨ̀hɨ́‑áⁿ. Dico ni ɨ̀ɨⁿ‑güedé ñá ní xìcáⁿ tnúhú‑güedě núú‑gǎ nǔu ná cuèndú ndátnǔhu‑gá ndɨhɨ ñadɨ̀hɨ́‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ducaⁿ te ní dándǒo ñadɨ̀hɨ́‑áⁿ yoó ndute‑aⁿ xíáⁿ, te ní xica‑aⁿ cuánuhú‑aⁿ ñuú cútnǔhu‑aⁿ ñáyiu cuèndá Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Te ní xáhaⁿ‑aⁿ: —Chí nèhé ná quɨ̀hɨ́ⁿ‑ó, chi quiní‑ndó nǎ cúú ɨ̀ɨⁿ tée nùcóo yuhu dòco‑áⁿ nǔu ñá dɨ́ú Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a cùu‑dé nǔu ní cáháⁿ ndáá‑dé nàcuáa cùu ndecu‑í —càchí‑aⁿ xǎhaⁿ‑aⁿ xìí‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Te sá nǐ níhí ñǎyiu ñuú‑áⁿ tnǔhu, xíǎⁿ ní xicá‑yu cuáháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Te òré vátá sàá‑gá‑yu xíáⁿ nǐ xáhaⁿ cuè tée xìca cuu ndɨhɨ‑gá xii‑gá: —Mèstrú, cudèhñu na cudehñu‑o —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Te ní xáhaⁿ‑gǎ: —Ndècu ɨɨⁿ sá cáxì‑í, ɨɨⁿ sá ñà túú xìní nchòhó —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Te cue tée xìca cuu ndɨhɨ‑gá xǐtnàha‑güedé: —Váa ìó ñáyiu ní quixi nehe sá nǐ xexi‑gá nǔu duha càháⁿ‑gá —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Te ní xáhaⁿ‑gǎ: —Dàtná cuìní‑ndó cùu vétú iní‑ó òré xéxí‑ó, ducaⁿ cùu vétú iní‑í quídè‑í nchaa nàcuáa ní cáháⁿ Yǎ Ndiǒxí Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a, te chìuⁿ‑gá ío cùdɨ́ɨ́ ìní‑í dandɨ̀hɨ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Te nchòhó càchí‑ndó sǎ cùmání cǔmí‑gǎ yóó te cuu itú. Dico yúhú càchí‑í sá cùndehe‑ndo ñáyiu‑ǎⁿ, chi sa ndècu túha‑yu, dàtná cúú‑nǎ itú sá sà ní cuu‑ná natahu‑o cùú‑yu, chi sa ndècu túha‑ná‑yu cundedóho‑yu tnúhu‑í. ");
INSERT INTO milNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Te dàtná cúú ñǎyiu nàtahu itú chi sa cúhuⁿ yáhu‑yu, ducaⁿ sǎtnahá‑xi cùu ñáyiu na càháⁿ tnúhu‑í, chi cuáñaha‑ǐ sá ndúú tǎhǔ‑yu na sàá nduu. Te nchaa ñáyiu na tnɨ̀ɨ tnúhu‑í te nduu táhǔ‑yu cundecu‑í ndɨhɨ́‑yu nɨ caa nɨ quɨ́hɨ́ⁿ. Te dàtná cúú ñǎyiu ní chihi tatá‑xi, ndɨhɨ ñáyiu ní natahu ìtú‑xi cùdɨ́ɨ́‑nǎ iní‑yu. Ducaⁿ sǎtnahá‑xi cùu ñáyiu na càháⁿ tnúhu‑í. ");
INSERT INTO milNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chi ndáá quéé‑xí nàcuáa cuáháⁿ ɨɨⁿ cuèndú sá càchí‑xi: “Tucu tée ní chihi tatá, te tucu tée ní natahu”, duha cuáháⁿ cuèndú‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Te yúhú tendaha ñaha‑ǐ xii‑ndo quɨ̌hɨ́ⁿ‑ndó cǎháⁿ‑ndó tnǔhu‑í núú sà ní yáha‑güedé ní cáháⁿ‑güedé tnúhu‑í. Te nchòhó quɨ́hɨ́ⁿ‑ndó dìcó‑nǎ nduu cuèndá‑ndó chìuⁿ‑áⁿ —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Te ío cuéhé ñǎyiu ñuú‑áⁿ nǐ xíndèdóho‑yu cuèndú ní cani ñadɨ̀hɨ́‑áⁿ nǔǔ‑yu sá Jèsús ní xáhaⁿ‑gǎ nchaa nàcuáa quìde‑aⁿ, te xíǎⁿ ío vàí‑yu ní sándáá iní‑yu Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Te ní quexìó‑yu núú ndécú‑gǎ, te ní cáháⁿ ndàhú‑yu núú‑gǎ sá quéndǒo‑gá ñuú‑yu, núu xíǎⁿ ní xíndecu‑gá ndɨhɨ́‑yu úú nduu. ");
INSERT INTO milNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Te ío cuéhé‑gǎ‑yu ní sándáá iní‑yu tnúhu ní cáháⁿ méé‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Te ní xáhǎⁿ‑yu xii ñadɨ̀hɨ́‑áⁿ: —Vitna te ñá dɨ́ú mèe‑ni tnúhu ní cáháⁿ‑n ní sàndáá iní‑ndɨ́‑gá, chi ní cáháⁿ méé‑gǎ ní xíndedóho‑ndɨ́ vitna núu ní sándáá ndisa iní‑ndɨ́ sá dɨ́ú‑gǎ cúú‑gǎ Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a dàcácu nihnu‑gá ñáyiu núú ùhú núú ndàhú —càchí‑yu xǎhǎⁿ‑yu xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Te nduu úní ní nucúhuⁿ Jèsús ichi cuáháⁿ‑gá distrìtú Galìleá. ");
INSERT INTO milNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Te cuáháⁿ‑gá yàcáⁿ, chi mee‑gǎ ní cachí‑gá sá nǔu ɨɨⁿ tée na càháⁿ‑dé tnúhu Yá Ndiǒxí ñuú núú nǐ cacu‑dé, te ñá túú nèhé‑yu sá yɨ́ñùhu núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Te òré ní sáá‑gá distrìtú Galìleá, te ío váha ní cuu iní ñáhǎ‑yu xii‑gá, chi cuèndá tnàhá‑yu ní xíndecu ndɨhɨ‑gá vico pàscuá ñuú Jerusàlén. Te yàcáⁿ ní xiní‑yu nchaa sá nǐ quide‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Te ní sáháⁿ tucu‑gá ñuú Cànaá ɨɨⁿ ñuú yɨ́ndèhu distritú Galìleá, núú nǐ nadatɨ̀u‑gá ndute ní nduu‑xi vìnú. Te ñuú Capèrnaúm ndécú ɨ̀ɨⁿ tée ndèé chíúⁿ nǔú těe cùu gobiernú, te tée‑áⁿ cùhú ɨɨⁿ déhe‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Te ní níhí‑dě tnúhu sá nǐ ndee Jèsús distrìtú Jùdeá ní ndexìo‑gá distrìtú Galìleá, núu ní sáháⁿ‑dé núú ndécú‑gǎ, te ní cáháⁿ ndàhú‑dé núú‑gǎ sá quɨ̀hɨ́ⁿ‑gá cada tátna‑gá déhe‑dé, chi sa ndècu‑na‑dé sá cùú‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Te ní xáhaⁿ Jèsús xii‑dé: —Nchòhó, chi vá quɨ̀ndáá iní ñáhá‑ndó xìi‑í te núu vá cádà‑í ɨɨⁿ sá vǎ yǒo tnàhí ndàcu cada quiní‑ndó —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Te ní xáhaⁿ tùcu tée cùhú déhe‑xi‑áⁿ xii‑gá: —Tǎtá, cundee ìní‑n ná quɨ̀hɨ́ⁿ‑ni‑o càda tátna‑n děhe‑í ná cuu‑dé, chi càhú víhí tnàhá‑dé —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Te ní xáhaⁿ Jèsús: —Cuanùhú te quiní‑n nǎ ní ndúha déhe‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. Te ní sándáá iní‑dé tnúhu ní cáháⁿ Jèsús, te cuánuhú‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Te ñùhu‑dé ichi cuánuhú‑dé ní sánú tnàhá ñáhá cuè tée xìnu cuechi núú‑dě. Te ní xáhaⁿ‑güedě sá sà ta ndúha déhe‑dé cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Te ní xícáⁿ tnúhú‑dě núú‑güedě ná òré cúú‑xí nǐ ngüíta‑xi ta quětaú cuéhé‑dě. Te ní xáhaⁿ‑güedě: —Icu dàtná òré caá ɨɨⁿ sacuaa ní nchíco‑dé cahni —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Te tǎtá těe cùhú‑áⁿ nǐ ndacu iní‑dé sá dɨ́ú òré ní quétaú cuéhé‑dě ní cáháⁿ ndɨhɨ‑dé Jèsús ní xáhaⁿ‑gǎ sá ndǔha déhe‑dé. Te xíǎⁿ nǔu ndɨ nchàa tée‑áⁿ vehe‑dé ní sándáá iní‑yu Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Te sá nǐ quide‑gá‑áⁿ cúú ǔú xito quìde‑gá sá vǎ yǒo tnàhí ndàcu cada. Te sá nǐ quide‑gá xito cùu uú‑áⁿ cúú‑xí sǎ nǐ quide‑gá cútnàhá ní ndee‑gá distrìtú Jùdeá cuánuhú‑gá distrìtú Galìleá. ");
INSERT INTO milNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Te sátá dúcáⁿ nǐ cuu, te ní tnahá nduu nǐ quide ñáyiu isràél ɨɨⁿ vico. Te ní sáháⁿ Jèsús ñuú Jerusàlén. ");
INSERT INTO milNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Te nɨ càa xico yuhu ñuú‑áⁿ ñúhú dòco, te tɨtnɨ́ yèhe‑xi ndecu. Te ɨɨⁿ yèhe‑xi‑áⁿ nání Yùyehe Mbéé, te yatni xíáⁿ cáá ɨ̀ɨⁿ tanquí ndute dàna‑ní‑yu Bètesdá tnúhu mèé‑yu tnúhu hèbreú, te yuhu tànquí‑áⁿ cáá ǔhúⁿ corrèdór. ");
INSERT INTO milNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Te xɨtɨ́ corrèdór‑áⁿ xǐndecu cuéhé ñǎyiu cùhú, ñáyiu cuàá, ñáyiu yacua, ñáyiu ñá cúú‑gǎ candá nihnu, ndètú‑yu candá ndute‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Chi nìhí‑yu tnúhu sá ǎma nihnu cùuⁿ ɨɨⁿ espíritú xínú cuèchi núú Yǎ Ndiǒxí, te dàcandá‑xi ndute ñùhu tanquí‑áⁿ. Te ñáyiu díhna nuu nà quée xɨtɨ́ ndute‑áⁿ, te òré‑ni ndúha‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Te yàcáⁿ ñútnàhá ɨɨⁿ tée ní cuu ócó sáhúⁿ úní cuíá sǎ cùhú‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Te ní xiní Jèsús cáá‑dě, te ní cutnùní iní‑gá sá nǐ cuu cuéhé cuǐá cùhú‑dé, te ní xáhaⁿ‑gǎ: —¿Cuìní‑n ndǔha‑n‑ǎⁿ? —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Te ní xáhaⁿ těe cùhú‑áⁿ: —Tǎta, vá yǒo nìhí‑í dàquée ñaha xìi‑í xɨtɨ́ tànquí‑a òré càndá ndute, chi òré cuìní‑í quée‑í, te ɨngá‑ni tucú‑yu quènduú‑yu núù‑í cuángueé‑yu —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Te ní xáhaⁿ Jèsús: —Ndacuɨ́ñɨ́, te ndaca‑ni‑n yùu‑n, te caca‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Te òré‑ni‑áⁿ nǐ ndúha tée cùhú‑áⁿ, te ní ndaca‑ni‑dé yuu‑dé, te ní xica‑dé cuáháⁿ‑dé. Te nduu‑ǎⁿ cúú‑xí ndùu ndetatú ñáyiu, ");
INSERT INTO milNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","núu ní xáhaⁿ cuè tée isràél xii tée ní cuhu‑áⁿ: —Vitna cùu‑xi nduu ndetatú‑ó nǔu vá cúú cuìdo‑n yuu‑n —cachí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Te ní xáhaⁿ‑dě: —Mee těe ní quide tátna ñaha xìi‑í ní cachí‑dé sá ndácàni‑í yuu‑í, te caca‑í —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Te ní xáhaⁿ‑güedě: —¿Te ná cúú těe ducaⁿ nǐ cachí sá ndácàni‑n yuu‑n te caca‑n‑i? —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dico tée ní cuhú‑áⁿ ñà túú ní cùtnuní iní‑dé ná cúú těe ní quide tátna ñaha xìi‑dé, chi Jèsús òré‑ni ní xica‑gá cuáháⁿ‑gá tnuú nchaa ñáyiu chitu xǐndecu xíáⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Te sátá dúcáⁿ te ní naníhí tnáhá Jèsús ndɨhɨ tée ní quide tátna‑gá‑áⁿ xɨtɨ́ veñúhu càhnu sá ǐo cùnuu, te ní xáhaⁿ‑gǎ xii‑dé: —Ní xiní‑n nǎ ní ndúha‑n‑va. Te vitna vá cádá‑gǎ‑n nǎndɨ sá cuèhé sá dúhá, chi núu na càda‑ni‑n ña, te quixi ɨngá cuéhé, te vìhi‑gá ndoho‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ducaⁿ te ní xica tée ní cuhú‑áⁿ cuǎngúñaha‑dě xii cue tée isràél sá Jèsús ní quide tátna ñaha‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Núu sátá nǐ níhí cue tée isràél tnúhu, te ní cuu úhú iní‑güedé Jèsús. Te ní cuiní‑güedé cahni ñaha‑güedě xii‑gá cuèndá sá dúcáⁿ nǐ quide tátna‑gá nduu ndètatú‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Te ní xáhaⁿ Jèsús xii‑güedé: —Tǎtà‑í Dútú Ndiǒxí quídé chìuⁿ‑ni‑gá nǔu xíǎⁿ quídé chìuⁿ‑í tnàhá‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Te ní cudééⁿ‑güedě sá ñǎ ní cǎnehe íí‑gǎ nduu ndètatú‑güedé, te ní cuiní‑güedé cahni ñaha‑güedě, te uuⁿ‑gá ní cuiní‑güedé cahni ñaha‑güedě xii‑gá sá nǐ cachí‑gá sá Tǎtá‑gǎ cúú Dǔtú Ndiǒxí, chi ní sani iní‑güedé sá cuìní‑gá nútnahá‑gá Yǎ Ndiǒxí nǔu xíǎⁿ ío ní cudééⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Te ní xáhaⁿ tùcu Jesús xii‑güedé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ yǔhú chi ni ɨ̀ɨⁿ sá ñǎ ndácù‑í cada mee‑ǐ nǔu ñá túú mèe Tátà‑í dánèhé ñáhá‑gǎ xii‑í nàcuáa cada‑í, chi nchaa sá quídé Tǎtà‑í quídè‑í tnàhá‑í. ");
INSERT INTO milNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Te Tǎtà‑í ío cùu iní ñáhá‑gǎ xii‑í nǔu dànehé ñáhá‑gǎ nchaa nàcuáa quìde‑gá. Te vitna ndècu vai‑gá chìuⁿ tahu‑gá cada‑í, chìuⁿ sá vǎtá quìní‑gá‑ndó càda‑í nàcuáa cuñúhu vìhi‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Chi Tǎtà‑í dandòto‑gá ñáyiu ní xíhí. Te yúhú cada‑í te nduu táhú nchaa ñáyiu càchí iní‑í cundecu ndɨhɨ ñàhá‑yu xii‑í nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Te na sàá nduu te ñá dɨ́ú Tǎtà‑í cada ndáá‑gá cuéchi ñáyiu, chi ní cachí‑gá sá yǔhú cada ndáá‑í ");
INSERT INTO milNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","cuèndá nchaa ñáyiu canehé‑yu sá yɨ́ñùhu núù‑í dàtná néhě‑yu sá yɨ́ñùhu núú Tǎtà‑í Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a. Te nchaa ñáyiu ñá túú nèhe sá yɨ́ñùhu núú yǔhú, te ni nǔú Tǎtà‑í ñá túú nèhé‑yu sá yɨ́ñùhu. ");
INSERT INTO milNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nchàa ñáyiu na cùndedóho tnúhu na càháⁿ‑í, te núu na quɨ̀ndáá iní‑yu Dútú Ndiǒxí Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a ña, te vá cuǐta nihnú‑yu chi nduu táhǔ‑yu cundecú‑yu ndɨhɨ‑gá nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Te vitna na càchí tnúhu ndáá‑í xii‑ndo sǎ nchàa ñáyiu ndècu ichi cuehé ichi duha cùú‑yu dàtná ɨɨⁿ ñáyiu ní xíhí, te vitna ní sáá nduu cùndedóho‑yu tnúhu càháⁿ yúhú Déhe Dútú Ndiǒxí, te nchaa ñáyiu na quɨ̀ndáá iní‑xi, te naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Te dàtná quídé mèe Tátà‑í dácǎcu nihnu‑gá ñáyiu, ducaⁿ nǐ cachí‑gá cada‑í dàcácu nihnu‑í‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Te ní cachí tucu‑gá sá sàá ɨɨⁿ nduu, te cada ndáá‑í cuéchi nchaa ñáyiu ñá túú quìde ndáá, chi yúhú táxí tnùní‑í, te cùu‑í ñaní tnáhá‑ndó nchàa‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Te ni vǎ cúñǔhu‑ndo tnǔhu càháⁿ‑í, chi sáá nduu te nchaa ñáyiu ní xíhí tecú dóho‑yu tnúhu càháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Te ndoto nchaa ñáyiu ní quide váha cundecu ndɨhɨ‑í‑yu nɨ caa nɨ quɨ́hɨ́ⁿ, te ndoto tnàhá nchaa ñáyiu ní quide cuèhé ní quide duha, te ñáyiu‑áⁿ quɨ̌hɨ́ⁿ‑yu núú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Te yúhú, chi ni ɨ̀ɨⁿ sá ñǎ ndácù‑í cada mee‑ǐ nǔu ñá dɨ́ú mèe Yá Ndiǒxí táúchìuⁿ‑gá nàcuáa cada‑í. Te quìde ndáá‑í cuéchi ñáyiu nàcuáa tàxi tnuní‑gá cada‑í, te yúhú ñá túú quìde‑í sá cúú ìní méè‑í chi Tǎtà‑í ní táúchíúⁿ‑gǎ nàcuáa cada‑í. ");
INSERT INTO milNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Te núu na càháⁿ‑í sá méè‑í táxí tnùní‑í, te vá quɨ̀ndáá iní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Chi Yá Ndiǒxí chíndèe tnúhu ñaha‑gǎ xii‑í, te yúhú xìní‑í sá tnǔhu càháⁿ‑gá cuèndá‑í cúú‑xí ɨ̀ɨⁿ sá ndàá. ");
INSERT INTO milNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Te nchòhó ní téchíúⁿ‑ndó cuè tée ní sáháⁿ ní ndúcú tnǔhu‑güedé núú tě Juàá nǔu ná tnúhu cáháⁿ‑dé cuèndá‑í, te tée‑ǎⁿ ní cáháⁿ ndáá‑dé nàcuáa ndùu cuendá‑í. ");
INSERT INTO milNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Dico yúhú, chi ñá túú xìni ñuhu‑í ɨɨⁿ ñáyiu ñuyíú‑a chindee tnǔhu ñàhá‑yu xii‑í, dico té Juàá ní cáháⁿ váha‑dé cuèndá‑í, te xíǎⁿ càchí tnúhu tucu‑í cuèndá quɨ́ndáá iní‑ndó, te naníhí tàhú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Te dàtná cuìní‑ndó cùu ɨɨⁿ itɨ ndéñuhú te dàyehé‑xi, ducaⁿ sǎtnahá‑xi ní cuu té Juàá, chi sacú‑ni nduu ío ní cudɨ́ɨ́ ìní‑ndó tnǔhu ní cáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Te váha‑ni ní cáháⁿ té Juàá, dico yúhú chi ndècu nchaa sá tá quìde‑í véxi nàcuáa ní táúchíúⁿ Yǎ Ndiǒxí cada‑í, te nchaa xíǎⁿ cúú‑xí ɨ̀ɨⁿ sá cútnùní iní‑ndó sǎ méé Yǎ Ndiǒxí ní tendaha ñàha‑gá xii‑í véxi‑í ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Te dɨu‑ni‑gá chíndèe tnúhu ñaha‑gǎ xii‑í, dìcó‑ni sá méé‑ndó ñà túú cuìní‑ndó càda cuendá‑ndó tnǔhu càháⁿ‑gá, te ni ñà túú xìní‑ndó nàcuáa càa‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Te ñá túú quěe iní nchòhó tnúhu càháⁿ‑gá, chi ñá túú sàndáá iní ñáhá‑ndó xìi yúhú Déhe‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Te dàcuaha vihi‑ndo tutú ndèé tnúhu‑gá, chi sàni iní‑ndó sǎ xǐǎⁿ‑ni dacuàha‑ndo te naníhí tàhú‑ndó. Te váha‑ni quìde‑ndo, chi dɨu tutú‑áⁿ càháⁿ‑xi cuèndá‑í. ");
INSERT INTO milNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Te nchòhó ñá túú cuìní‑ndó quɨ̀ndáá iní ñáhá‑ndó xìi‑í cuèndá naníhí tàhú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Te yúhú, ñá túú xìni ñuhu‑í sá cádá càhnu ñaha‑ndo xii‑í. ");
INSERT INTO milNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Dico sa xìní‑í nàcuáa sàni iní‑ndó chi ñá túú cùu iní‑ndó Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Te yúhú véxi‑í ñuyíú‑a chi Tǎtà‑í ní tendaha ñàha‑gá, te nchòhó ñá túú cuìní‑ndó tnɨ̀ɨ‑ndo tnúhu càháⁿ‑í, dico núu quixi ɨɨⁿ tée cáháⁿ cuèndá méé‑xí, chi quɨndáá iní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Te ná váha nchòhó ná tnɨ́ɨ́‑ndó tnǔhu càháⁿ‑í, te xio xio‑ni quìde cahnu tnaha‑ndo, te ñá túú quìde cuendá‑ndó sǎ tnǔhu váha càháⁿ Yǎ Ndiǒxí cuu xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Te vá cání ìní‑ndó sǎ yǔhú ndàcáⁿ cuéchi‑í núú Tǎtà‑í nàcuáa quìde‑ndo, chi ndíi Moìsés ní chídó tnùní ndíi núú tùtú Yǎ Ndiǒxí nàcuáa quìde‑ndo sá ñà túú quìde váha‑ndo, te mee‑ndo sàni iní‑ndó sǎ nánìhí tàhú‑ndó cuèndá tnúhu ní cáháⁿ ndíi. ");
INSERT INTO milNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Chi núu nchòhó sàndáá ndisa iní‑ndó tnǔhu ní cáháⁿ ndíi Moìsés ñá, te ducaⁿ te quɨndáá iní‑ndó yǔhú ní cùu, chi ndíi‑ǎⁿ ní chídó tnùní ndíi nàcuáa cada‑í ñuyíú‑a vitna. ");
INSERT INTO milNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Te núu ñá túú sàndáá iní‑ndó tnǔhu ní chídó tnùní ndíi, te dɨu‑ni ducaⁿ càda ñaha‑ndo xii‑í vá quɨ̀ndáá iní‑ndó tnǔhu càháⁿ‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Te sátá dúcáⁿ nǐ cuu, te ní quee Jèsús cuáháⁿ‑gá ɨngá xio yuhu làgúná Galìleá, àdi Tiberiás chi úú dɨ̀u‑xi. ");
INSERT INTO milNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Te ío cuéhé ñǎyiu nchìcúⁿ ñáhá xìi‑gá cuáháⁿ cuèndá sá nǐ xiní‑yu nchaa sá vǎ yǒo tnàhí ndàcu cada ní quide‑gá, chi ní quide tátna‑gá nchaa ñáyiu cùhú. ");
INSERT INTO milNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Te ní sáá Jèsús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ɨɨⁿ núú tɨ̀ndúú, te xíáⁿ nǐ ngóo‑gá ndɨhɨ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Te ta cùyatni coo vico pascuá, vico quìde ñáyiu isràél. ");
INSERT INTO milNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Te ní xiní‑gá sá ǐo vài ñáyiu nchìcúⁿ ñáhá xìi‑gá cuáháⁿ, te ní xáhaⁿ‑gǎ xii té Lìpé: —¿Ndèé quɨ́hɨ́ⁿ‑ó quɨ̌nguaaⁿ‑o sǎ cáxí nchàa ñáyiu‑a? —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Te ducaⁿ nǐ xáhaⁿ‑gǎ xii‑dé cuèndá sá cuìní‑gá quiní‑gá nása cunduu tnúhu cáháⁿ‑dé, dico mee‑gǎ sa xìní‑gá nàcuáa cada‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Te ní xáhaⁿ tě Lìpé xii‑gá: —Te cuěi úú cièndú díhúⁿ denàriú ná dàndoñuhu‑o cuaaⁿ‑o paá, te ni vǎ tnàhá caxí‑yu luha luha —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Te té Ndrǐxí ɨngá tée xìca cuu ndɨhɨ‑gá, ñaní té Xǐmú, àdi Pelú chi úú dɨ̀u‑dé, ní xáhaⁿ‑dě: ");
INSERT INTO milNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Iha ndècu ɨɨⁿ té lǐhli nèhe‑dé úhúⁿ pàá cebàdá te úú chácá, dico nděé tnahá xéhé, te cuéhé víhí ñǎyiu —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Te ní xáhaⁿ Jèsús xii‑güedé: —Chí cǔñaha nà ngóo‑yu nchaá‑yu —càchí‑gá xáhaⁿ‑gǎ. Te ñáyiu‑áⁿ nǐ ngóo‑yu, te càa vihi ité núú nǐ ngóo‑yu‑áⁿ, te xínu dàtná úhúⁿ mǐl mee‑ni cuè tée, te dɨ̀ɨⁿ ñáyiu dɨ̀hɨ́ ndɨhɨ landú. ");
INSERT INTO milNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Te ní queheⁿ Jèsús pàá, te ní ndacáⁿ táhú‑gǎ núú Yǎ Ndiǒxí, te ní sáñaha‑gǎ pàá‑áⁿ xii cue tée xìca cuu ndɨhɨ‑gá, te cue tée‑áⁿ nǐ dácǎhñu‑güedé ní xexi nchaa ñáyiu xǐxúcu‑áⁿ. Te dɨu‑ni ducaⁿ nǐ quide‑gá chácá, te ní dácǎhñu tucu‑güedé‑dɨ ní xexi ñáyiu ní ndahá xɨtɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Te òré ní túhú cóhǒ‑yu, te ní xáhaⁿ Jèsús xii cue tée xìca cuu ndɨhɨ‑gá sá ná nàqueheⁿ‑güedé nchaa sá nǐ quendóo cuèndá sá vǎ quɨ̀hɨ́ⁿ‑xi núú míhí. ");
INSERT INTO milNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Te cue tée‑ǎⁿ ní naqueheⁿ‑güedé nchaa sá nǐ quendóo, te ní chítú ùxúú tɨ́dihi núú ùhúⁿ‑ni pàá cebàdá. ");
INSERT INTO milNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Te sá nǐ xiní‑yu ní nadacàyá‑gá sá nǐ xexí‑yu, xíǎⁿ ní ngüíta‑yu ní xítnàhá‑yu: —Ndáá sá těe‑a sa ìó cuèndú sá quíxí‑dě ñuyíú‑a cáháⁿ‑dé tnúhu Yá Ndiǒxí —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Te ní cutnùní iní Jèsús sá cádá yìcá‑yu candeca ñàhá‑yu xii‑gá quɨ́hɨ́ⁿ cuèndá cundecu‑gá quɨndaha ñàha‑gá xií‑yu ni cùu, núu xíǎⁿ ní xica tucu‑gá cuáháⁿ‑gá xɨtɨ́ yucu mee dìi chícuú‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Te òré ní cuu ndɨquɨⁿ, te cuáháⁿ cue tée xìca cuu ndɨhɨ‑gá yuhu làgúná. ");
INSERT INTO milNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Te ní quée‑güedé bàrcú cuáháⁿ‑güedé ñuú Capèrnaúm cáá ndàa ɨngá xio yuhu làgúná, te sa ní cuu ndɨquɨⁿ, te ñá túú Jèsús quéxìo quée‑gá bàrcú ñúhú‑güedě‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Te ní ngüíta‑xi quène táchí nǐhi, te níhi dàcandau ndéé tnáhá ndùte lagúná‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Te sa ní cuu dàtná úhúⁿ kìlómetrú cuáháⁿ‑güedé, te ní xiní‑güedé Jèsús tá cùyatni‑gá bàrcú ñúhú‑güedě véxi‑gá núú ndúté, te ní yùhú‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Te ní xáhaⁿ Jèsús xii‑güedé: —Yúhú véxi‑í, vá yùhú‑ndó —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Te ío ní cudɨ́ɨ́ ìní‑güedé sá nǐ quexìo‑gá cuánguee‑gá bàrcú, te òré‑ni ní quexìo‑güedé ndɨhɨ‑gá ndéé ɨngá xio yuhu làgúná núú cuàháⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Te ɨngá nduu‑ǎⁿ xǐndecu‑ni nchaa ñáyiu ní quendóo yuhu làgúná. Te ní quide cuèndá‑yu sá ɨ́ɨ́ⁿ dìi‑ná bàrcú nútnɨ̌ɨ‑áⁿ ní cùu ñá túú‑gǎ, chi cue tée xìca cuu ndɨhɨ Jesús ní quée‑güedé bàrcú‑áⁿ cuǎháⁿ‑güedé. Te ní níhǐ‑yu tnúhu sá ñà túú ní quěe tnàhá Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Te dɨu‑ni nduu‑ǎⁿ nǐ quee ɨɨⁿ ǔú bàrcú ñuú Tìberiás ní sáá‑xi yatni núú nǐ xexí‑yu pàá sá nǐ ndacáⁿ táhú Jèsús núú Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Te ní xiní‑yu sá ñà túú Jèsús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá, núu ní quée‑yu bàrcú‑áⁿ cuǎháⁿ‑yu ñuú Capèrnaúm cuánúndúcú ñàhá‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Te ní sáá‑yu ɨngá xio yuhu làgúná, xíáⁿ nǐ naníhǐ‑yu Jèsús, te ní xáhǎⁿ‑yu xii‑gá: —Mèstrú, ¿ná òré ní sáá‑n ìha? —cachí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Te ní xáhaⁿ Jèsús: —Na càchí tnúhu ndáá‑í sá nchòhó nándùcu ñaha‑ndo xii‑í cuèndá‑ni sá nǐ xexi‑ndo nǐ ndahá xɨtɨ́‑ndó, dico ñá dɨ́ú cuèndá sá nǐ quide‑í sá vǎ yǒo tnàhí ndàcu cada nanducu ñaha‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Te vá cádá cuèndá‑ndó sǎ méé‑ní sǎ cáxí‑ndó càda chiuⁿ‑ndo chi xíǎⁿ vá cúdǐi‑xi. Chi ío‑gá xíní ñùhu‑xi cada cuendá‑ndó tnǔhu Yá Ndiǒxí te tnɨɨ‑ndo, te naníhí tàhú‑ndó. Te tnúhu‑áⁿ cachí tnúhu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, te xíǎⁿ candeca‑xi iní‑ndó nɨ̀ caa nɨ quɨ́hɨ́ⁿ, chi mee Dǔtú Ndiǒxí ní cachí‑gá sá dúcáⁿ càda‑í —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Te ní xáhǎⁿ‑yu: —¿Nása cada‑ndɨ́ cuèndá ngúnu ichi‑ndɨ́ nàcuáa cuìní Yǎ Ndiǒxí cunduu‑i? —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Te ní xáhaⁿ Jèsús xií‑yu: —Yá Ndiǒxí cuìní‑gá sá quɨ̀ndáá iní ñáhá‑ndó xìi yúhú, tée ní tendaha‑gǎ véxi ñuyíú‑a —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Te ní xáhaⁿ tùcú‑yu xii‑gá: —¿Ná cúú sǎ vǎ yǒo tnàhí ndàcu cada, cada‑n cùndehe‑ndɨ́ cuèndá quɨ́ndáá iní ñáhá‑ndɨ̌ xii‑n‑i? ¿Àdi nágá cúú sǎ cádá‑n cuèndá cutnùní iní‑ndɨ́ sá ndàá càháⁿ‑n‑í? ");
INSERT INTO milNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chi cue ñaní tnáhá‑ó nǐ xíndecu ndéé sanaha nǐ xexí‑yu pàá nání mànáá xɨtɨ́ yucu dàtná yódó tnùní núú tùtú Yǎ Ndiǒxí núú càchí‑xi: “Yá Ndiǒxí ní sáñaha‑gǎ sá nǐ xexí‑yu, te ní cuuⁿ túu‑xi andɨu”, duha càchí‑xi núú tùtú‑gá —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Te ní xáhaⁿ Jèsús: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ ñà dɨ́ú ndǐi Moìsés ní sǎñaha ndǐi pàá ní cuuⁿ andɨu nǐ xexí‑yu, chi mee Tǎtà‑í ní sáñaha‑gǎ sá nǐ xexí‑yu. Te sá táxí‑gǎ vitna cùu‑xi ");
INSERT INTO milNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","datná pàá véxi cuuⁿ andɨu càndeca‑xi iní‑ndó nɨ̀ caa nɨ quɨ́hɨ́ⁿ —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Te ní xáhǎⁿ‑yu xii‑gá: —Tǎtá, mee‑ni pàá‑áⁿ taxi‑n càxi‑ndɨ́ —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Te ní xáhaⁿ Jèsús: —Yúhú cúù‑í dàtná ɨɨⁿ sá xéxí‑ndó cǎndeca‑xi iní‑ndó. Te duha ndùu tnúhu càháⁿ‑í, chi nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í, te vá ndóhó‑gǎ‑yu docó te vá ndóhó‑gǎ‑yu ndute. ");
INSERT INTO milNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Dìcó‑ni sá nchòhó ñá túú sàndáá iní ñáhá‑ndó cuěi xìní ñáhá‑ndó xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Te nchaa ñáyiu na càchí Tǎtà‑í nduu cuèndá‑í nasaá‑yu núù‑í, te ñáyiu‑áⁿ vǎ dáquèe tɨ́hù‑í‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Te ñá dɨ́ú yǔhú sá věxi cuuⁿ‑í andɨu te quìde‑í nchaa sá cúú ìní méè‑í, chi véxi cuuⁿ‑í sá cádà‑í nchaa nàcuáa ní táúchíúⁿ mèe Tátà‑í Dútú Ndiǒxí Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Te cuìní‑gá sá ncháá ñǎyiu ní cachí‑gá nduu cuèndá‑í vá dáñà‑í‑yu cuíta nihnú‑yu, te na sàá nduu te dɨu‑ni‑í dandòto‑í‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Chi ducaⁿ nǐ cachí Dútú Ndiǒxí cunduu sá ncháá ñǎyiu na tnɨ̀ɨ tnúhu càháⁿ‑í, te quɨndáá ndisa iní ñáhǎ‑yu xii yúhú Déhe‑gá, te nduu táhǔ‑yu cundecú‑yu ndɨhɨ Yá Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ, te yúhú dandòto‑í‑yu na sàá nduu —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Te ñá ní tnàhá iní ñáyiu isràél tnúhu ní cáháⁿ Jèsús nǔu ní ngüíta‑yu ní cáháⁿ cuèhé‑yu cuèndá‑gá cuèndá sá nǐ xáhaⁿ‑gǎ sá méé‑gǎ cúú‑gǎ dàtná sá xéxí‑ó věxi cuuⁿ andɨu. ");
INSERT INTO milNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Te ní xítnàhá‑yu: —¿Náa ñá dɨ́ú těe‑a cùu‑dé Jèsús déhe té Chèé? Nchoo xìní‑ó tǎtá‑dě, te xìní‑ó nǎná‑dě, ¡ná cachí‑tu tée‑a sá andɨu věxi cuuⁿ‑dé! —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Te ní xáhaⁿ Jèsús xií‑yu: —Vá càháⁿ cuèhé‑gá‑ndó cuèndá‑í, chí dáñá. ");
INSERT INTO milNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Vá yǒo quɨndáá iní ñáhá xìi yúhú nǔu ñá túú mèe Tátà‑í táxí cuèndá ñáhá‑gǎ xií‑yu. Te dɨu‑gá ní tendaha ñàha‑gá xii‑í véxi‑í, te yúhú dandòto‑í‑yu na sàá nduu. ");
INSERT INTO milNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Te núú tùtú cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha càchí‑xi: “Yá Ndiǒxí danèhé ñáhá‑gǎ xií‑yu tnúhu‑gá”, duha càchí‑xi. Te nchaa ñáyiu na cùndedóho nchaa tnúhu càháⁿ Dútú Ndiǒxí, te cutúha‑yu nàcuáa càháⁿ‑gá, te ñáyiu‑áⁿ quɨ̀ndáá iní ñáhǎ‑yu xii yúhú. ");
INSERT INTO milNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Te vá yǒo xìní ñáhá xìi Dútú Ndiǒxí chi ɨɨⁿdìi‑ni yúhú xìní‑í‑gá, chi núú ndécú‑gǎ ní quee‑í véxi cuuⁿ‑í —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Te xǎhaⁿ tùcu‑gá: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ nchàa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í, te naníhí tàhú‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Te yúhú cúù‑í dàtná ɨɨⁿ sá xéxí‑ndó cǎndeca‑xi iní‑ndó, te ducaⁿ sǎtnahá‑xi cùu‑í chi yúhú cada‑í te nduu táhú‑ndó cùndecu‑ndo ndɨhɨ Yá Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Te cue ñaní tnáhá‑ó nǐ xíndecu ndéé sanaha nǐ xexí‑yu pàá nání mànáá xɨtɨ́ yucu, dico ní sáá nduu te dacuɨtɨ́í nǐ xíhí‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Te yúhú càháⁿ‑í cuèndá méè‑í, chi véxi cuuⁿ‑í andɨu. Te cùu‑í dàtná ɨɨⁿ sá nchító‑ndó, te nchaa ñáyiu na càxi te candeca‑xi iní‑yu nɨ caa nɨ quɨ́hɨ́ⁿ te vá cuǐta nihnu‑gá‑yu. Te sá táxì‑í xii‑ndo xíǎⁿ cúú‑xí yɨ̀quɨ cuñú‑í, te cùu‑xi cuendá nchaa ñáyiu nɨhìí ñuyíú cuèndá nduu táhǔ‑yu cundecú‑yu ndɨhɨ Yá Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Te ní ngüíta ñáyiu isràél xǐtnàhá‑yu: —¿Nása cada‑tu tée‑a núu càchí‑tu‑dé sá yɨ̀quɨ cuñú‑dé taxi‑dé caxi‑o‑i? —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Te ní xáhaⁿ Jèsús: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ nǔu na càda iní‑ndó sǎ dàtná sá cáxí‑ndó yɨ̀quɨ cuñú yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, te cada tucu iní‑ndó sǎ dàtná sá cóhó‑ndó nɨ̌ñɨ̀‑í ñá, te xíǎⁿ quéé‑xí sǎ quɨ̀ndáá iní ñáhá‑ndó nɨ̀ yuhu nɨ iní‑ndó te naníhí tàhú‑ndó, te núu ñáhá te cuíta nihnu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nchaa ñáyiu na càda iní‑xi sá dàtná sá cáxǐ‑yu yɨquɨ cùñú‑í te cohó‑yu nɨ́ñɨ̀‑í, ñáyiu‑áⁿ naníhí tàhú‑yu te yúhú dandòto‑í‑yu na sàá nduu. ");
INSERT INTO milNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chi yɨquɨ cùñú‑í ndɨhɨ nɨ́ñɨ̀‑í cúú‑xí mèe‑í. ");
INSERT INTO milNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Te nchaa ñáyiu na càda iní‑xi sá dàtná sá cáxǐ‑yu yɨquɨ cùñú‑í te cohó‑yu nɨ́ñɨ̀‑í, te ñáyiu‑áⁿ ɨɨⁿ‑nǎ cuu‑í ndɨhɨ́‑yu chi cundecu ndɨhɨ‑í‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Te yúhú nchìto‑í chi ducaⁿ nchìto Tátà‑í Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a. Te dɨu‑ni ducaⁿ nchàa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í te cundecu ndɨhɨ‑í‑yu nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Te yúhú cúù‑í dàtná ɨɨⁿ sá nchító‑ndó věxi cuuⁿ andɨu, dico ñá dɨ́ú pàá sá nání mànáá ní xèxi cue ñaní tnáhá‑ó nǐ xíndecu ndéé sanaha, chi ní xexí‑yu pàá te dacuéi ní xíhí‑yu. Te nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi yúhú Yaá véxi cuuⁿ andɨu, te cundecu ndɨhɨ‑í‑yu nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nchaa tnúhu‑a ní cáháⁿ‑gá xɨtɨ́ veñúhu ñáyiu ñuú Capèrnaúm. ");
INSERT INTO milNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Te sá dúcáⁿ nǐ cáháⁿ‑gá nǔu vài ñáyiu nchìcúⁿ ñáhá xìi‑gá ní xítnàhá‑yu: —Vá tnɨ́ɨ́ cuɨ̀tɨ‑o tnúhu càháⁿ‑dé chi ñá dɨ́ú tnǔhu sá cúú vǎha iní‑ó càháⁿ‑dé —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Te ní cutnùní iní Jèsús sá ñà túú càháⁿ váha‑yu cuèndá tnúhu ní cáháⁿ‑gá, núu ní xáhaⁿ‑gǎ xií‑yu: —¿Náa ñá tnàhá iní‑ndó nàcuáa càháⁿ‑í‑a? ");
INSERT INTO milNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Te uuⁿ‑gá cada nchòhó nǔu quiní‑ndó yǔhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo ndaa‑í núú nǐ xíndecu‑í díhna. ");
INSERT INTO milNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Te espíritú ndécú ndɨ̀hɨ yɨquɨ cuñú‑ó, xíǎⁿ ndécá ñàha‑xi xii‑o, te núu ñá túú xǐǎⁿ, te yɨquɨ cùñú‑ó ñà túú nàndɨ́hɨ‑xi. Dico núu nchaa tnúhu càháⁿ‑í‑a quée‑xi iní‑ndó ñá, te quiní‑ndó nǎ xéhé candeca ñaha‑xi xìi‑ndo núú cuàháⁿ núú věxi. ");
INSERT INTO milNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Te dava nchòhó chi ñá túú sàndáá iní‑ndó —càchí‑gá xáhaⁿ‑gǎ xií‑yu. Te ducaⁿ nǐ xáhaⁿ‑gǎ chi sa nàha‑gá nándɨ cùu ñáyiu vá quɨ̀ndáá iní ñáhá xìi‑gá. Te ducaⁿ sà naha‑gá ndědacàa tée cuáha cuèndá ñáhá xìi‑gá núú cuè tée cùu úhú iní ñáhá. ");
INSERT INTO milNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Te ní xáhaⁿ tùcu Jesús xií‑yu: —Te duha càháⁿ‑í chi sa ní cachí tnúhu‑í xii‑ndo sǎ vǎ yǒo ɨɨⁿ cuìní tnɨɨ tnúhu‑í te núu ñá túú Tǎtà‑í Dútú Ndiǒxí sánú ìchi ñaha‑gá xií‑yu —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Te òré‑áⁿ ǐo vài ñáyiu nchìcúⁿ ñáhá xìi‑gá ní xócǒo‑yu ñá ní xìca cuu‑gá‑yu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Te xíǎⁿ ní xáhaⁿ Jèsús xii ndɨ ùxúú cue tée xìca cuu ndɨhɨ‑gá: —¿Cuìní‑ndó dàndóo ñaha‑ndo tnàhá‑ndó‑ǎⁿ? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Te ní xáhaⁿ tě Xǐmú, àdi Pelú chi úú dɨ̀u‑dé: —Mèstrú, ñá túú‑gǎ ndèé quɨ́hɨ́ⁿ‑ndɨ́, chi nchúhú náhá‑ndɨ̌ sá tnǔhu mee‑n cùu‑xi sá vǎha candeca‑xi iní‑ndɨ́ nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Chi nchúhú sa ní sándáá iní ñáhá‑ndɨ̌ xii‑n chi nàha‑ndɨ́ sá yòhó cúú‑n Crìstú Déhe Dútú Ndiǒxí yaá ndécú àndɨu —cachí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Te ní xáhaⁿ Jèsús: —Nàha‑ndo sá yǔhú ní cáháⁿ ñáhà‑í xii ndɨ ùxúú‑ndó xìca cuu ndɨhɨ ñaha‑í xii‑ndo, dico ɨɨⁿ‑ndo quɨ̌hu ñaha yùcu ñávǎha xii‑ndo —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Duha ní cáháⁿ Jèsús cuèndá té Jùdás déhe té Xǐmú Iscàrioté ɨɨⁿ tée ñùtnahá núú ùxí ɨɨⁿ cue tée xìca cuu ndɨhɨ‑gá, chi sa nàha‑gá sá těe‑ǎⁿ cuǎha cuèndá ñáhá‑dě xii‑gá ɨɨⁿ nduu núú cuè tée cùu úhú iní ñáhá. ");
INSERT INTO milNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Te sátá dúcáⁿ nǐ cuu, te ní xica cuu Jèsús distrìtú Galìleá, te ñá ní sǎháⁿ‑gá distrìtú Jùdeá, chi yàcáⁿ cuìní cue tée isràél cahni ñaha‑güedě xii‑gá ní cùu. ");
INSERT INTO milNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Te ní cuyatni nduu càdá‑yu vico, vico sá dánàní‑yu Vico Vehe Tnuvixiⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Te ní xáhaⁿ cuè ñaní Jèsús xii‑gá: —Váha‑gá quɨ́hɨ́ⁿ‑n dìstritú Jùdeá te vá cúndècu‑n iha, chi yàcáⁿ cada‑n nchàa sá quídé‑n ìha cuendá quiní nchaa ñáyiu cùndɨhɨ ñaha xii‑n ndecu yacáⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Chi núu cuìní‑ó quìní nchaa ñáyiu ná chìuⁿ cada‑o te vá cádá dàyuhu‑o. Te yòhó cuéhé nǔú sǎ quídé‑n, te cada‑n na quìní nchaa ñáyiu —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ducaⁿ nǐ cáháⁿ cue ñaní‑gá, chi ni mèe‑güedé ñá túú sàndáá iní‑güedé nàcuáa ndùu tnúhu càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Te ní xáhaⁿ Jèsús xii‑güedé: —Vátá tnàhá‑gá òré quɨ́hɨ́ⁿ‑í dico nchòhó ndědani càa oré cuu quɨ́hɨ́ⁿ‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Chi nchaa ñáyiu ñùhu ichi cuehé ichi duha chi ñá túú cùu úhú iní ñáhǎ‑yu xii nchòhó. Dico yúhú chi cùu úhú iní ñáhǎ‑yu xii‑í cuèndá sá càháⁿ‑í sá quídě‑yu nchaa sá cuèhé sá dúhá. ");
INSERT INTO milNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Te chí cuàháⁿ nchòhó vico chi yúhú vá quɨ̀hɨ́ⁿ‑ni‑í chi vátá tnàhá‑gá òré quɨ́hɨ́ⁿ‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Te ducaⁿ nǐ xáhaⁿ‑gǎ te ní ndóo‑gá Galìleá, te cue tée‑áⁿ cuǎháⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Dico sátá cuǎháⁿ cue ñaní‑gá, te ní xica‑gá cuáháⁿ‑gá tnàhá‑gá dìcó‑ni sá dàyuhu cuáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Te ñáyiu isràél ñáyiu xǐndecu vico nànducú‑yu Jèsús, te xǐtnàhá‑yu: —¿Ndèé ndécú Jèsús? —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Te nchaa ñáyiu xǐndecu vico xǐndatnúhu‑yu cuèndá‑gá. Te davá‑yu xǐtnàhá‑yu sá ǐo váha iní‑gá, te davá‑yu xǐtnàhá‑yu sá ñà dɨ́ú těe váha cùu‑gá, chi dàndahú‑gá ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Dico mee‑ni xǐcáháⁿ náhǐ‑yu, chi xǐyùhú‑yu cue tée cùnuu núǔ‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Te ta ngǔhuⁿ dava vico, te cuánguɨhu Jèsús veñúhu càhnu sá ǐo cùnuu, te ní ngüíta‑gá dácuàha‑gá ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Te ñáyiu isràél ní cuñúhu vìhí‑yu sá ǐo váha càháⁿ‑gá, te ní xítnàhá‑yu: —¿Ná cuèndá ío váha ñùhu‑tu dɨ́quɨ́ těe‑a tnúhu cáháⁿ‑dé te ñá túú ní dàcuaha‑dé‑i? —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Te ní xáhaⁿ Jèsús: —Ñá dɨ́ú cuèndá méè‑í cúú‑xí sǎ dánèhé ñáhà‑í xii‑ndo, chi cuèndá Dútú Ndiǒxí Yaá ní tendaha ñàha xii‑í véxi‑í cúú‑xí. ");
INSERT INTO milNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Te núu ìó dava‑ndo nɨ̀ yuhu nɨ iní‑ndó cuìní‑ndó càda‑ndo nacuáa cuìní Yǎ Ndiǒxí cunduu, te cutnùní ndáá iní‑ndó sǎ tnǔhu dàcuaha ñaha‑í xii‑ndo cùu‑xi cuendá méé Dǔtú Ndiǒxí, te ñá dɨ́ú cuèndá méè‑í cúú‑xí. ");
INSERT INTO milNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Te tée cuìní sá cádá càhnu ñaha ñáyiu xii‑dé, tée‑áⁿ càháⁿ‑dé nàcuáa véxi iní méé‑dě. Dico yúhú cuìní‑í sá cádá càhnú‑yu Dútú Ndiǒxí Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a, te càháⁿ ndáá‑í te ñá túú dàcuandehnde‑í. ");
INSERT INTO milNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Te ndíi Moìsés ní taxi ndíi tnúhu sá sánú ìchi ñaha xii‑ndo nacuáa cundecu‑ndo, te ni dùcaⁿ ñá túú sàndáá iní‑ndó nàcuáa càháⁿ tnúhu‑áⁿ. ¿Te ná cuèndá cuìní‑ndó càhni ñaha‑ndo xii‑í? —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Te ní xáhǎⁿ‑yu xii‑gá: —Yucu ñǎvǎha dàcoto ñaha xii‑ó, chi vá yǒo ɨɨⁿ cuìní cahni ñaha xìi‑n —cachí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Te ní xáhaⁿ Jèsús xií‑yu: —Sá nǐ quide‑í ɨɨⁿ sá vǎ yǒo tnàhí ndàcu cada nduu cuu‑xi nduu ndetatú‑ó, xíǎⁿ ío ní cuñúhu ñaha‑ndo xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Te ndíi Moìsés ní cachí ndíi sá cuǎha‑yu sèñá ñɨɨ cue landú tée, dico ñá dɨ́ú mèe ndíi ni càhu iní ndíi chi ducaⁿ tnàhí ní xóo cada cue ñaní tnáhá‑ó dàvá‑áⁿ, núu xíǎⁿ nchòhó sǎha‑ndo sèñá ñɨɨ landú tée cuěi cùu‑xi nduu ndetatú‑ó. ");
INSERT INTO milNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Te ducaⁿ quìde‑ndo cuendá sá ñà túú nǎ cumání‑ndó nǔú tnǔhu sá sánú ìchi ñaha xii‑ndo ní dándǒo ndíi Moìsés. ¿Te ná cuèndá cúděéⁿ‑ndó nǔù‑í sá nǐ quide tátna‑í tée cùhú nduu ndètatú‑ó‑í? ");
INSERT INTO milNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Te váha váha cada cuèndá‑ndó, te vá cuèndá‑ni cáháⁿ‑ndó sǎ yǔhú ndècuéchi‑í chi ñá túú xìní‑ndó —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Te dava ñáyiu ñuú Jerusàlén ní ngüíta‑yu xǐtnàhá‑yu: —¿Náa ñá dɨ́ú těe‑áⁿ nándùcu‑güedé cahni‑güedé?, ");
INSERT INTO milNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","núu nái‑dé nútnɨ̌ɨ núú chítú nǔú tàcá‑ǎⁿ càháⁿ‑dé, te vá yǒo cùyɨɨ cúñaha xìi‑dé ɨɨⁿ tnúhu. Cudana te cue tée cùchiuⁿ sandáá iní‑güedé sá dɨ́ú‑dě cúú‑dě Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Dico nchoo xìní‑ó ndèé ichi véxi tée‑ǎⁿ, dico Crìstú ná quìxi‑gá chi vá yǒo ɨɨⁿ quiní ndèé ichi quixi Yaá‑áⁿ —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Te yɨ̀hɨ Jesús xɨtɨ́ veñúhu càhnu sá ǐo cùnuu danehe‑gá ñáyiu, te ní tecú dóho‑gá tnúhu càháⁿ‑yu. Te níhi ní cáháⁿ‑gá, te xáhaⁿ‑gǎ xií‑yu: —¡Ná quiní‑tu nchòhó ndèé ichi véxi yúhú! Yúhú véxi‑í dico ñá dɨ́ú sǎ cúú ìní méè‑í, chi Yá Ndiǒxí Yaá quídé nchàa‑ndɨ túhú sá vǎha ní tendaha ñàha‑gá xii‑í véxi‑í, te nchòhó ñá túú xìní‑ndó‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Te yúhú xìní‑í‑gá chi núú ndécú‑gǎ ní quee‑í véxi‑í, te dɨu mee‑gǎ ní tendaha ñàha‑gá véxi‑í —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Te sá dúcáⁿ nǐ cáháⁿ‑gá, núu cuìní‑güedé tnɨɨ ñaha‑güedě xii‑gá quɨ́hɨ́ⁿ‑gá vecaá ní cùu, dico vá yǒo ɨɨⁿ ni cùyɨɨ tnɨɨ ñaha xii‑gá chi vátá sàá‑gá òré tnɨɨ ñaha‑güedě. ");
INSERT INTO milNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Dico vàí‑yu ní sándáá iní ñáhǎ‑yu xii‑gá, te ní xítnàhá‑yu: —¿Nágá cúú sǎ cádá Crìstú ná quìxi‑gá‑i?, te tée‑a ío cuéhé nǔú sǎ tá quìde‑dé véxi. Váa dɨu tée‑a cùu‑dé Crìstú Yaá ní tendaha Yá Ndiǒxí véxi ñuyíú‑a —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Te ní níhí cue tée cùu fariséú tnúhu nàcuáa càháⁿ ñáyiu cuèndá Jèsús, núu ní ndatnúhu‑güedé ndɨhɨ cue dútú cúnùu, te ní techìuⁿ‑güedé cue tée quìde cuendá veñúhu cuáháⁿ‑güedé cuátnɨɨ ñaha‑güedě xii‑gá ní cùu. ");
INSERT INTO milNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Te ní xáhaⁿ‑gǎ xii‑güedé: —Sacú duha nduu cundecu ndɨhɨ ñaha‑ǐ xii‑ndo, te núhú tucu‑í núú ndécú tǎtà‑í Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Te cuěi na nànducu ñaha‑ndo dico vá ná nìhí ñáhá‑ndó chi vá sàá‑ndó nǔú cúndècu‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Te ní ngüíta ñáyiu isràél xǐtnàhá‑yu: —¿Ndèé quɨ́hɨ́ⁿ‑tu tée‑a te vá ná nìhí‑ó‑dě‑i? ¿Àdi quɨ́hɨ́ⁿ‑dé na chìtnahá‑dé ñáyiu isràél ñáyiu nchìténuu nchaa ñuú xícá cuèndá danèhé‑dé ñáyiu grìégú? ");
INSERT INTO milNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nása càháⁿ‑tu‑dé duha càháⁿ‑dé: “Nanducu ñàha‑ndo te vá nánìhí ñáhá‑ndó chi vá sàá‑ndó nǔú cúndècu‑í”, càchí‑tu‑dé? —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Te nduu nǐ yáha‑ná vico cùu‑xi nduu cahnu vihi, te nduu‑ǎⁿ nǐ ngúnu tnɨ́ɨ Jèsús tnuú ñáyiu, te níhi ní cáháⁿ‑gá, te xáhaⁿ‑gǎ xií‑yu: —Núu ìó dava‑ndo yìchí‑ndó ndùte, te quixi‑ndo nǔù‑í, te coho‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Duha càháⁿ‑í chi nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í, te cada‑xi iní‑yu dàtná ɨɨⁿ núú xícá ndùte, nchaa‑ni nduu xìca ñá túú yìchí, ducaⁿ càda‑xi iní‑yu núú cuàháⁿ núú věxi dàtná càháⁿ‑xi núú tùtú Yǎ Ndiǒxí —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Te ducaⁿ nǐ cáháⁿ‑gá cuèndá sá quíxí Espíritú Yǎ Ndiǒxí ngúndecu ndɨhɨ nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑gá, chi sáá nduu ndàa‑gá andɨu càda cahnu ñaha Tátá‑gǎ xii‑gá, te dàvá‑áⁿ te quixi Espíritú Yǎ Ndiǒxí cundecu ndɨhɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Te dava ñáyiu ní xíndedóho tnúhu ní cáháⁿ Jèsús ní xítnàhá‑yu: —Ndáá sá těe‑a cùu‑dé tée càchí‑yu quixi cáháⁿ tnúhu Yá Ndiǒxí —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Te dava tucú‑yu xǐtnàhá‑yu: —Tée‑a cùu‑dé Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a —càchí‑yu xǐtnàhá‑yu. Te dava‑gá tucú‑yu xǐtnàhá‑yu: —¿Náa ndàa distritú Galìleá quixi Crìstú Yaá tendaha Yǎ Ndiǒxí quixi ñuyíú‑a? ");
INSERT INTO milNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Chi núú tùtú Yǎ Ndiǒxí càchí‑xi sá Crìstú Yaá tendaha Yǎ Ndiǒxí quixi ñuyíú‑a cuu‑gá ɨɨⁿ ñaní tnáhá ndǐi Dàvií, te quee‑gá ñuú Bèlén ñuú méé ndǐi Dàvií, duha càháⁿ‑xi núú tùtú Yǎ Ndiǒxí —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Te xíǎⁿ nǔu ñá ní cùu ɨɨⁿnuú‑yu cuèndá Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Te davá‑yu cuìní‑yu tnɨɨ́‑yu Jèsús quɨ́hɨ́ⁿ‑gá vecaá ní cùu, dico ni ɨ̀ɨ́ⁿ‑yu ñá túú ní cùyɨɨ́‑yu tnɨɨ ñàhá‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Te cue tée cuáháⁿ tnɨɨ ñaha xìi Jesús ní cùu ní ndexìo‑güedé núú cuè tée cùu fariséú ndɨhɨ núú cuè dútú cúnùu. Te xǎhaⁿ cuè tée cùnuu‑áⁿ: —¿Ná cuèndá ñá ní cǎndeca‑ndo těe‑ǎⁿ quixi? —càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Te cue tée ní sáháⁿ chìuⁿ ní xáhaⁿ‑güedě: —Ni ɨ̀ɨⁿ tée ñá túú xìní‑ndɨ́ cáháⁿ dàtná càháⁿ tée‑ǎⁿ —càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Te ní xáhaⁿ cuè tée cùu fariséú: —¿Náa tnàhá nchòhó ní sándáá iní‑ndó tnǔhu ndehnde càháⁿ tée‑ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Náa ñá túú xìní‑ndó sǎ nì ɨɨⁿ cue tée tàxi tnuní nchúhú, te ni ɨ̀ɨⁿ nchúhú cue tée cùu fariséú ñá túú sàndáá iní‑ndɨ́ tée‑ǎⁿ ñǎ? ");
INSERT INTO milNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nchaa ñáyiu tùha ñaha xii tée‑ǎⁿ ñá túú sàndáá iní‑yu nàcuáa càháⁿ tnúhu sá sánú ìchi ñaha xii‑o, dico cuíta nihnú‑yu sá dúcáⁿ quìdé‑yu —càchí‑güedé xǎhaⁿ‑güedě xii cue tée‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Te té Nicòdemú tée ní sáháⁿ niú ní ndatnúhu‑dé ndɨhɨ Jèsús cúú‑dě tnàhá‑dé ɨɨⁿ tée farìséú, te ní xáhaⁿ‑dě xii‑güedé: ");
INSERT INTO milNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Tnúhu sá sánú ìchi ñaha xii‑o nacuáa cundecu‑o càchí‑xi sá ndèé cundedóho‑o nǎsa càháⁿ tée tàú cuéchi cuèndá cutnùní iní‑ó nǎ ní quide‑dé, te dǎtnùní cáháⁿ‑ó nǔu ndisa ndècuéchi‑dé àdi ñá túú ndècuéchi‑dé —càchí‑dé xǎhaⁿ‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Te ní xáhaⁿ‑güedě: —Cùu ní cachí sá tnàhá‑ǒ cúú‑n těe distrìtú Galìleá nǔu ducaⁿ càháⁿ‑n. Dacuàha tutú yódó tnùní tnúhu Yá Ndiǒxí te quiní‑n nàcuáa càháⁿ‑xi sá nì ɨɨⁿ tée véxi distrìtú Galìleá ñá túú càháⁿ‑dé tnúhu Yá Ndiǒxí —càchí‑güedé xǎhaⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ducaⁿ te ndɨ dɨ́ɨ́ⁿ cuǎnuhú‑güedé vehe‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Te Jèsús cuáháⁿ‑gá yucu Òlívú. ");
INSERT INTO milNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Te sátá nǐ túndaá nduu tněé, te cuáháⁿ tucu‑gá veñúhu càhnu sá ǐo cùnuu. Te ío cuéhé ñǎyiu ní chítú níhnǔ‑yu núú‑gǎ, te ní ngóo‑gá ní dánèhé ñáhá‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Te ní quexìo cue tée dàcuaha ñaha xií‑yu nchaa tnúhu ní chídó tnùní ndíi Moìsés, ndɨhɨ cue tée cùu fariséú, te ndèca‑güedé ɨɨⁿ ñadɨ̀hɨ́ ní sáá, te ñaha‑áⁿ nǐ xiní ñáhǎ‑yu càháⁿ ndɨhɨ‑aⁿ ɨɨⁿ tée dico ñá dɨ́ú yɨ̀ɨ‑aⁿ cuu‑dé, te ní sanutnɨ́ɨ ñaha‑güedě xii‑aⁿ tnuú nchaa ñáyiu xǐndecu núú Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Te ní xáhaⁿ‑güedě xii Jèsús: —Mèstrú, ñadɨ̀hɨ́‑a ní xiní ñáhá ñǎyiu xii‑aⁿ càháⁿ ndɨhɨ‑aⁿ ɨɨⁿ tée dico ñá dɨ́ú yɨ̀ɨ‑aⁿ cuu‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Te tnúhu ní chídó tnùní ndíi Moìsés càchí‑xi sá yǔú cahni‑o nchàa ñáyiu dɨ̀hɨ́ duha quìde. Te yòhó, ¿nása càchí‑n cùnduu‑i? —cachí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Duha ní cáháⁿ‑güedé chi cuèndá sá cuìní‑güedé coto ndeé ñáhá‑güedě xii‑gá nǔu nása cáháⁿ‑gá cuèndá nùcóo nchihi ñaha‑güedě xii‑gá ní cáháⁿ‑güedě. Te ní ngúnu ndeyɨ‑gá te ní ngüíta‑gá téé‑gǎ ndɨhɨ dɨ́quɨ́ ndáhá‑gǎ lètrá núú ñúhú. ");
INSERT INTO milNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Te xìcáⁿ tnúhú‑ní tùcu‑güedé núú‑gǎ nǔu ní ndonehe núú‑gǎ, te ní xáhaⁿ‑gǎ: —Ndědani càa nchohó te núu ñá túú nǎ cuéchi quìde‑ndo te díhna nuu‑gǎ‑ndó chǐ cuǎha‑aⁿ yúú —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Te ní ngúnu ndeyɨ tucu‑gá téé tùcu‑gá lètrá núú ñúhú. ");
INSERT INTO milNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Te sá dúcáⁿ nǐ xáhaⁿ‑gǎ xii‑güedé te ní ndixi túu iní‑güedé sá ñà túú quìde váha mee‑güedě tnàhá‑güedé, núu da ɨɨⁿ da ɨɨⁿ‑güedé ní ndee, te díhna‑gá cue tée cùu sacuéhé nǐ ndee te ní ngüíta nchicúⁿ dava‑gá‑güedé. Te sátá nǐ ndɨhɨ‑güedé ní ndee, te ní quendóo mee‑nǎ Jèsús ndɨhɨ ñadɨ̀hɨ́‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Te ní ndonehe núú Jèsús te ní xiní‑gá sá nǐ ndɨhɨ‑güedé cuáháⁿ te mee‑nǎ ñadɨ̀hɨ́‑áⁿ nǐ ndóo‑aⁿ, te ní xáhaⁿ‑gǎ xii‑aⁿ: —¿Nděndɨ cuáháⁿ cue tée càchí sá nǐ quide‑n cuěchi? ¿Ni ɨ̀ɨⁿ‑güedé ñá ní cùndee tnúhu‑güedé quɨ́hɨ́ⁿ‑n càstiú‑va? —càchí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Te ní xáhaⁿ‑aⁿ xìi Jesús: —Ñáhá, chi ni ɨ̀ɨⁿ‑güedé ñá ní ndàcu‑güedé —càchí‑aⁿ xǎhaⁿ‑aⁿ. Te ní xáhaⁿ Jèsús: —Te ni yǔhú vá dáquɨ̀hɨ́ⁿ ñáhà‑í castìú xii‑n. Te vitna te núhú‑n te vá cádá‑gǎ‑n nǎndɨ sá cuèhé sá dúhá —càchí‑gá xáhaⁿ‑gǎ xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Te ní cáháⁿ tucu Jèsús núú ñǎyiu, te xáhaⁿ‑gǎ xií‑yu: —Yúhú cúù‑í dàtná ɨɨⁿ ñuhú dáyèhe‑í ñuyíú‑a, te nchaa ñáyiu na chìtnahá ñáhá xìi‑í, te vá cúndècu‑gá‑yu ichi cuèhé ichi duha, chi yúhú dandìxi túu‑í iní‑yu cuèndá cutnùní iní‑yu nàcuáa ndùu cuendá Yǎ Ndiǒxí, te cundecu‑í ndɨhɨ́‑yu nɨ caa nɨ quɨ́hɨ́ⁿ —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Te ní xáhaⁿ cuè tée cùu fariséú xii‑gá: —Medìi‑n caháⁿ‑n sǎ cúú‑n těe váha, te vá yǒo ɨɨⁿ‑gá chíndèe tnúhu ñaha xìi‑n núu ná tée cùu‑n, dico xíǎⁿ ñá túú nàndɨ́hɨ‑xi —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Te ní xáhaⁿ Jèsús: —Cuěi càháⁿ‑í cuèndá méè‑í dico nàndɨ́hɨ tnúhu càháⁿ‑í. Chi yúhú nàha‑í ndèé ichi véxi‑í, te xìní‑í ndèé ichi núhú‑í, dico nchòhó chi ñá túú xìní‑ndó ndèé ichi véxi‑í, te ni ñà túú xìní‑ndó ndèé ichi quɨ́hɨ́ⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Te nchòhó chi cuèndá‑ni càháⁿ‑ndó cuèndá ñáyiu núu quìde váha‑yu àdi ñá túú quìde váha‑yu. Te yúhú ñá túú càháⁿ‑í cuèndá ñáyiu núu quìde váha‑yu àdi ñá túú quìde váha‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Àdi núu càháⁿ‑í dico ɨɨⁿ tnúhu ndáá càháⁿ‑í chi ñá dɨ́ú‑ní mèe‑í càháⁿ, chi tnàhá Tǎtà‑í Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a càháⁿ‑gá chíndèe tnúhu ñaha‑gǎ xii‑í. ");
INSERT INTO milNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Te tnúhu sá sánú ìchi ñaha xii‑ndo cachí‑xi sá nǔu na cùndecu úú cue tée cáháⁿ ndáá‑güedé nàcuáa cùu ɨɨⁿ sá cúndǎá, te núu ɨɨⁿ‑ni tnǔhu na càháⁿ‑güedé ndɨ ndùú‑güedé te xíǎⁿ nándɨ̌hɨ‑xi, duha càchí tnúhu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Te dɨu‑ni ducaⁿ cùu‑xi yúhú chi càháⁿ‑í ɨɨⁿ tnúhu ndáá sá cúú‑xí mèe‑í, te dɨu‑ni dàtná càháⁿ‑í càháⁿ Tǎtà‑í Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Te ní xáhaⁿ‑güedě xii‑gá: —¿Te ndèé ndécú Tǎtá‑n‑í? —càchí‑güedé xǎhaⁿ‑güedě. Te ní xáhaⁿ Jèsús: —Te núu dìcó xìní‑ndó yòo cuu yúhú‑á te ducaⁿ te quiní‑ndó Tǎtà‑í. Te ni yǔhú ñá túú xìní‑ndó yòo cuu‑í nǔu xíǎⁿ ñá túú xìní‑ndó Tǎtà‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Duha ní cáháⁿ Jèsús nɨni dàcuaha‑gá ñáyiu xɨtɨ́ veñúhu núú ndécú àlcanciá díhúⁿ. Te vá yǒo ɨɨⁿ ni cùyɨɨ tnɨɨ ñaha xii‑gá chi vátá sàá‑gá òré tnɨɨ ñaha‑güedě. ");
INSERT INTO milNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Te ní xáhaⁿ tùcu Jesús xii‑güedé: —Yúhú núhú‑í te nanducu ñàha‑ndo te vá nánǐhí ñáhá‑ndó, te cuú‑ndó nǔú yǐcá cuěchi‑ndo, chi vá ndácú‑ndó sǎá‑ndó nǔú nùhú‑í cundecu‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Te ní xítnàha cue tée isràél: —¿Te náa cahni‑dé méé‑dě nǔu càchí‑dé sá vǎ ndácú‑ó sàá‑ó nǔú quɨ̌hɨ́ⁿ‑dé‑ǎⁿ? —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Te ní xáhaⁿ Jèsús xii‑güedé: —Nchòhó chi cue tée ñuyíú‑a cùu‑ndo, núu ío ñùhu iní‑ndó sǎ ìó ñuyíú‑a. Te yúhú chi tée núú nǐnu cùu‑í nǔu xíǎⁿ ñá túú sǎ ìó ñuyíú‑a ñùhu iní‑í. ");
INSERT INTO milNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Te xíǎⁿ nǔu càchí‑í sá cùú‑ndó nǔú yǐcá cuěchi‑ndo, chi ñá cuìní‑ndó quɨ̀ndáá iní‑ndó sǎ yǔhú véxi cuuⁿ‑í andɨu, te núu xíǎⁿ dɨu‑ni núú yǐcá cuěchi‑ndo cùú‑ndó —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Te ní xícáⁿ tnúhú‑güedě núú‑gǎ, te xǎhaⁿ‑güedě: —¿Te ná cúú yòhó nǔu ducaⁿ càháⁿ‑n‑í? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te ní xáhaⁿ‑gǎ: —Sa ní cachí tnúhu‑í xii‑ndo nděé díhna —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Te xǎhaⁿ tùcu‑gá: —Ndècu cuéhé tnǔhu cáháⁿ‑í cada ndáá‑í cuèndá nchòhó. Te Tǎtà‑í Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a càháⁿ‑gá tnúhu ndáá, te tnúhu càháⁿ yúhú ñuyíú‑a cùu‑xi tnúhu ní cáháⁿ‑gá ní xíndedóho‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Te mee‑güedě ñá túú ní tècú tnùní‑güedé sá cuèndá Dútú Ndiǒxí ní cáháⁿ Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Te ní xáhaⁿ‑gǎ xii‑güedé: —Òré ná cátá càa ñaha‑ndo xii yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo núú cùrúxí cahni ñaha‑ndo, te òré‑áⁿ cutnùní iní‑ndó yòo cuu‑í, te ñá túú quìde‑í sá cúú ìní méè‑í, chi yúhú càháⁿ‑í nàcuáa ní dánèhé ñáhá Tǎtà‑í ");
INSERT INTO milNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yaá ní tendaha ñàha xii‑í véxi‑í. Te dɨu‑gá ndécú ndɨ̀hɨ ñaha‑gá xii‑í, te ñá túú dàña nihnu ñaha‑gá chi quìde‑í nchaa nàcuáa cùu iní‑gá —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Te sá dúcáⁿ nǐ cáháⁿ‑gá nǔu ío vài ñáyiu ní sándáá iní ñáhá xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Te ní xáhaⁿ Jèsús xii ñáyiu isràél ñáyiu ní sándáá iní ñáhá xìi‑gá: —Te núu vá dáñá ndèé‑ndó càda‑ndo nchaa nacuáa càháⁿ‑í, te cuu ndisa‑ndo cuè tée tnàhá tnúhu ndɨhɨ‑í, ");
INSERT INTO milNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","te tecú tnùní‑gá‑ndó tnǔhu ndáá, te ducaⁿ te cácu nihnu‑ndo —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Te ní xáhǎⁿ‑yu: —Nchúhú cúú‑ndɨ̌ cue ñaní tnáhá ndǐi Àbrahám, te ni ɨ̀ɨⁿ nduu ñá túú ndèé sácǔndedɨ́ nihnu‑ndɨ́ ndoho tnahá‑ndɨ́ nǔu cáchí‑ǒ sá dàcácu nihnu ñaha‑n xìi‑ndɨ́ —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Te ní xáhaⁿ Jèsús xií‑yu: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ nchàa ñáyiu quìde nchaa sá cuèhé sá dúhá tàxi tnuní ñáhá‑nǎ‑xi xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Te cue ñáyiu xìnu cuechi te vá cúú ɨ̀ɨⁿ‑ná cuú‑yu ndɨhɨ ñáyiu dii vèhe‑xi xinu cuechí‑yu, dico cue déhe ñáyiu dii vèhe‑xi‑áⁿ chi ɨɨⁿ‑ni cùu ndɨhɨ ñaha‑güexi xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Te núu yúhú Yaá cúú Děhe Yá Ndiǒxí dàcácu nihnu ñaha‑ǐ xii‑ndo nǔú nchàa yícá cuěchi‑ndo, te ndáá sá nchòhó cácu nihnu ndisa‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Te yúhú sa xìní‑í sá nchòhó cúú‑ndó ñàní tnáhá ndǐi Àbrahám, te dìcó‑ni sá ñǎ tnàhá iní‑ndó tnǔhu càháⁿ‑í nǔu xíǎⁿ cuìní‑ndó càhni ñaha‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Te yúhú càháⁿ‑í nàcuáa ní dánèhé ñáhá Tǎtà‑í, te nchòhó quídé‑ndó nàcuáa càháⁿ tǎtá‑ndó —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Te ní xáhǎⁿ‑yu: —Ndíi Àbrahám cúú tǎtá‑ndɨ̌ —càchí‑yu xǎhǎⁿ‑yu xii‑gá. Te ní xáhaⁿ Jèsús: —Núu ndisa ñaní tnáhá ndǐi Àbrahám cúú‑ndó, te cada‑ndo nàcuáa ní xóo cada ndíi ni cùu. ");
INSERT INTO milNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Te yúhú cuěi càháⁿ‑í ɨɨⁿ tnúhu ndáá nàcuáa càháⁿ Yǎ Ndiǒxí càchí tnúhu‑gá xii‑í, te cuìní‑ndó càhni ñaha‑ndo. ¡Dico ndíi Àbrahám chi ñá túú dùcaⁿ ni quide ndíi! ");
INSERT INTO milNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Te nchòhó quídé‑ndó nàcuáa quìde tátá‑ndó —càchí‑gá xáhaⁿ‑gǎ xií‑yu. Te ní xáhǎⁿ‑yu: —Nchúhú, ñá túú yàyacáⁿ ndécú tǎtá‑ndɨ̌, chi ɨɨⁿdìi Yá Ndiǒxí cúú tǎtá‑ndɨ̌ —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Te ní xáhaⁿ Jèsús: —Núu dìcó Yǎ Ndiǒxí ndisa cùu Tátá‑ndó te cuu iní ñáhá‑ndó xìi‑í ní cùu chi yúhú ní quee‑í núú ndécú‑gǎ véxi‑í ñuyíú‑a. Te ñá túú věxi‑í sá cúú ìní méè‑í, chi mee‑gǎ ní tendaha ñàha‑gá véxi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Te ñá túú tècú tnùní‑ndó tnǔhu càháⁿ‑í chi ñá túú tnàhá iní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Te nchòhó chi tǎtá‑ndó cùu yucu ñávǎha núu cùdɨ́ɨ́ ìní‑ndó quìde‑ndo nchaa nacuáa cùu iní‑xi, chi ndéé òré ní ngáva ñuyíú ducaⁿ‑ni ndècu‑xi dacáháⁿ‑xi iní‑ndó sàhni tnaha‑ndo. Te ñá ɨ́ɨ́ⁿ ndùu cáháⁿ‑xi ɨɨⁿ tnúhu ndáá chi ñá túú xìca‑xi ichi ndáá, chi mee‑ni ìchi tnúhu ndehnde xìca‑xi chi ducaⁿ ìní‑xi. Te dɨu‑xi dàcahu‑xi iní‑ndó dàcuandehnde‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Te yúhú càháⁿ‑í tnúhu ndáá te ñá túú cuìní‑ndó quɨ̀ndáá iní ñáhá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Te ndědacàa nchohó xìní‑ndó sǎ quídè‑í ɨɨⁿ sá cuèhé sá dúhá‑í?, te yúhú ñá túú nǎ quídè‑í chi càháⁿ ndáá‑í, ¿te ná cuèndá ñá túú cuìní‑ndó quɨ̀ndáá iní‑ndó tnǔhu càháⁿ‑í? ");
INSERT INTO milNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Te nchaa ñáyiu ndècu ichi Yá Ndiǒxí, ñáyiu‑áⁿ sácǔndedóho‑yu nchaa tnúhu càháⁿ‑gá. Te nchòhó chi ñá dɨ́ú ìchi Yá Ndiǒxí ndécú‑ndó nǔu ñá túú sàcúndedóho‑ndo tnǔhu càháⁿ‑gá —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Te ní xáhaⁿ ñǎyiu isràél: —Váha‑ni càháⁿ‑ndɨ́ sá těe samaritànú cúú‑n, te yucu ñǎvǎha ndècu ndɨhɨ‑n —cachí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Te ní xáhaⁿ Jèsús: —Yúhú, ñá túú yùcu ñávǎha ndècu ndɨhɨ‑í, chi Tǎtà‑í quídé càhnu‑í, te nchòhó da cùu úhú iní ñáhá‑ndó xìi‑í —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Te xǎhaⁿ tùcu‑gá: —Yúhú, ñá túú càchí‑í sá cádá càhnu ñaha‑ndo, dico Dútú Ndiǒxí cuìní‑gá sá cádá càhnu ñaha‑ndo xii‑í. Te mee‑gǎ cáháⁿ‑gá nǔu ndědacàa‑ndo quide váha, te ndědacàa‑ndo ñá túú quìde váha. ");
INSERT INTO milNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nchàa ñáyiu na tnɨ̀ɨ tnúhu càháⁿ‑í te vá cuǐta nihnú‑yu —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Te ní xáhaⁿ tùcu ñáyiu isràél: —Vitna te ní xiní ndáá‑ndɨ́ sá yùcu ñávǎha ndècu ndɨhɨ‑n, chi ndíi Àbrahám ndɨhɨ nchaa cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǐ xíhí‑güedé, te yòhó càchí‑tu‑n sǎ ncháá ñǎyiu na tnɨ̀ɨ tnúhu càháⁿ‑n te vá cùú‑gá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Náa ío‑gá càhnu cuu‑ó dàcúúxí ñàní tnáhá‑ndɨ̌ ndíi Àbrahám‑ǎⁿ? Tée‑áⁿ dai ní xíhí‑dé ndɨhɨ cue tée ní xóo cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha. ¿Te yòhó nágá‑tu cùu‑n te vá cùú‑n càhaⁿ‑n‑i? —cachí‑yu xǎhǎⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Te ní xáhaⁿ Jèsús: —Te núu dìcó méè‑í quídé càhnu‑í méè‑í ñá, te ñá túú nàndɨ́hɨ sá quídè‑í nǔu ducaⁿ. Dico Tǎtà‑í quídé càhnu ñaha‑gá xii‑í, te dɨu‑ni Yaá‑áⁿ càchí‑ndó cùu Ndióxí‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Te nchòhó chi ñá túú xìní‑ndó‑gǎ. Te yúhú chi xìní‑í‑gá. Te núu na càchí‑í sá ñà túú xìní‑í‑gá te dàcuandehnde‑í dàtná ndehnde mèe‑ndo. Te yúhú chi xìní ndisa‑í‑gá te tnɨ̀ɨ‑í nchaa tnúhu càháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Te ndíi Àbrahám ñaní tnáhá‑ndó nǐ xíndecu ndéé sanaha ío ní cudɨ́ɨ́ ìní ndíi sá quìní ñáhá ndǐi xii‑í, te ní sáá nduu nǐ xiní ñáhá ndǐi xii‑í nǔu ío ní cudɨ́ɨ́ ìní ndíi —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Te ní xáhaⁿ ñǎyiu isràél xii Jèsús: —Ni vǎtá cúhúⁿ‑gǎ‑n ǔdico úxí cuíá‑n te càchí‑n sǎ nǐ xiní‑n ndǐi Àbrahám, te ní cunaha vìhi ní xíhí ndíi‑áⁿ —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Te ní xáhaⁿ Jèsús: —Te na càchí tnúhu ndáá‑í xii‑ndo sǎ cùmání‑gǎ cundecu ndíi‑áⁿ ñuyíú‑a te yúhú sa ndècu‑gá‑í —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Te sá dúcáⁿ nǐ cáháⁿ‑gá nǔu xíǎⁿ ní quehéⁿ‑yu yúú cuǎha ñàhá‑yu xii‑gá ní cùu, te ní nguɨ́vǎha‑gá núǔ‑yu te ní quee‑gá xɨtɨ́ veñúhu cuáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Te núú xícá cùu Jesús ní naníhí‑gǎ ɨɨⁿ tée cuàá, te sa ducaⁿ tnàhí càa núú‑dě ní cacu‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Te ní xáhaⁿ cuè tée xìca cuu ndɨhɨ‑gá xii‑gá: —Mèstrú, ¿ná cuèndá dàcáⁿ cuàá tée‑ǎⁿ ní cacu‑dé? ¿Sá cuèndá nchaa yícá cuěchi tǎtá‑dě, ǎⁿ sǎ cuèndá nchaa yícá cuěchi nǎná‑dě, ǎⁿ sá cuèndá nchaa yícá cuěchi mee‑dě dàcáⁿ cáá‑dě ní cacu‑dé? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Te ní xáhaⁿ Jèsús: —Ni ñà dɨ́ú sǎ cuèndá nchaa yícá cuěchi mee‑dě, te ni ñà dɨ́ú sǎ cuèndá nchaa yícá cuěchi tǎtá‑dě, te ni ñà dɨ́ú sǎ cuèndá nchaa yícá cuěchi nǎná‑dě, chi mee Yǎ Ndiǒxí ní cuiní‑gá sá dúcáⁿ cùnduu‑dé sáá‑dé ñuyíú‑a cuèndá sá ñùyíú‑a quiní ñáyiu nása cada ñaha Yǎ Ndiǒxí xii‑dé ndúha núú‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Te vitna ìó‑gá nduu cùyica sá cádà‑í nchaa chìuⁿ ní táhú Yàá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a, chi sáá nduu te vá ndácú‑gǎ‑í cada‑í chìuⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Te nɨni ndècu‑gá‑í ñuyíú‑a te dàndixi túu‑í iní nchaa ñáyiu cuèndá cutnùní iní‑yu nàcuáa ndùu cuendá Yǎ Ndiǒxí —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Te sátá dúcáⁿ nǐ cáháⁿ‑gá, te ní satɨ‑gá dɨɨ́‑gá núú ñúhú te ní dácá‑gǎ luha ñuhu ní cuáha ndéhyú, te ndéhyú‑ǎⁿ nǐ dácánùu‑gá ndúú xio núú těe cuàá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Te ní xáhaⁿ‑gǎ xii‑dé: —Quɨ́hɨ́ⁿ‑n nàquete‑n núú‑n ndùte tanquí Silòé —càchí‑gá xáhaⁿ‑gǎ xii‑dé. Te Silòé‑áⁿ quéé‑xí tnǔhu mèé‑yu: Tée xìca chiuⁿ. Te ní sáháⁿ tée cuàá‑áⁿ nǐ naquete‑dé núú‑dě, te òré ní ndexìo‑dé te sa ndèhe‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Te nchaa ñáyiu ndècu yatni núú ndécú‑dě ndɨhɨ nchaa ñáyiu xìní ñáhá xìi‑dé núú xìcáⁿ ndàhú‑dé ní xítnàhá‑yu: —¿Náa ñá dɨ́ú těe‑ǎⁿ ní xóo cácáⁿ ndàhú‑dé? —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Te davá‑yu càchí‑yu sá dɨ́ú‑dě, te davá‑yu càchí‑yu sá ñà dɨ́ú‑dě, dico ducaⁿ càa‑dé, càchí‑yu xǐtnàhá‑yu. Dico mee‑dě ní xáhaⁿ‑dě xií‑yu sá dɨ́ú‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Te ní xícáⁿ tnúhǔ‑yu núú‑dě, te xǎhǎⁿ‑yu: —¿Nása ní cuu núu ní ndúha núú‑n ndèhe‑n vitna? —cachí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Te ní xáhaⁿ‑dě: —Tée nàni Jesús‑ǎⁿ ní cadúha‑dé luha ndéhyú te ní dácánùu‑dé núù‑í, te ní táúchíúⁿ‑dě ní sáháⁿ‑í tànquí Silòé ní naquete‑í núù‑í, te òré‑áⁿ nǐ cuu cundehe‑ǐ —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Te ní xícáⁿ tnúhú tùcú‑yu núú‑dě, te xǎhǎⁿ‑yu: —¿Te ndèé ndécú těe‑áⁿ? —càchí‑yu xǎhǎⁿ‑yu xii‑dé. Te ní xáhaⁿ‑dě: —Ñá túú xìní‑í —càchí‑dé xǎhaⁿ‑dě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Te ndèca‑güedé tée ní ndúha núú‑xi‑áⁿ cuǎháⁿ núú cuè tée cùu fariséú. ");
INSERT INTO milNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Te cuèndá sá ndùu ndetatú‑yu ní cadúha Jèsús ndéhyú nǐ dácánùu‑gá núú těe‑áⁿ te ní ndúha, ");
INSERT INTO milNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","xíǎⁿ nǔu ní xícáⁿ tnúhú cuè tée cùu fariséú núú‑dě, te xǎhaⁿ‑güedě: —¿Nása ní cuu ní ndúha núú‑n? —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. Te ní xáhaⁿ‑dě xii‑güedé: —Ɨɨⁿ tée ní dácánùu‑dé ndéhyú nǔù‑í te ní sáháⁿ‑í ní naquete‑í, te ní cuu ndèhe‑í vitna —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Te dava cue tée cùu fariséú ní xítnàha‑güedé: —Ñá dɨ́ú Yǎ Ndiǒxí ní tèndaha ñaha‑gá xii tée‑ǎⁿ véxi‑dé nǔu duha quìde‑dé nchaa sá vǎ yǒo tnàhí ndàcu cada, te ñá túú sàndáá iní‑dé canehe íí‑dě nduu ndètatú‑ó —càchí‑güedé xǐtnàha‑güedé. Te dava‑güedé ní xítnàha‑güedé: —¿Nása ndacu‑dé cada‑dé sá vǎ yǒo tnàhí ndàcu cada te núu cùu‑dé tée yícá cuěchi? —càchí‑güedé xǐtnàha‑güedé. Te ñá túú ní cùu ɨɨⁿnuu‑güedé tnúhu ní cáháⁿ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Te ní xícáⁿ tnúhú tùcu‑güedé núú těe ní ndúha núú‑xi‑áⁿ, te xǎhaⁿ‑güedě: —Te yòhó, ¿nása càchí‑n cuèndá tée ní quide tátna núú‑n te ní ndúha? —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. Te ní xáhaⁿ‑dě: —Yúhú càchí‑í sá ɨ́ɨ́ⁿ těe càháⁿ tnúhu Yá Ndiǒxí cúú‑dě —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Dico cue tée isràél ñá ní sàndáá iní‑güedé sá cuàá‑dé ní cùu, chi cuèndá sa ní ndúha núú‑dě ní xiní ñáhá‑güedě, te xíǎⁿ nǔu ní cana‑güedé tǎtá‑dě ndɨhɨ nǎná‑dě, ");
INSERT INTO milNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","te ní xícáⁿ tnúhú‑güedě núǔ‑yu, te xǎhaⁿ‑güedě: —¿Dɨu tée‑a déhe‑ndo těe càchí‑ndó cuàá‑dé ní cacu‑dé‑ǎⁿ? ¿Te nása ní cuu ní ndúha núú‑dě? —càchí‑güedé xǎhaⁿ‑güedě xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Te ní xáhaⁿ tǎtá‑dě ndɨhɨ nǎná‑dě: —Dɨu déhe‑ndɨ́ cúú‑dě te sa cuàá ndisa‑dé ní cacu‑dé, ");
INSERT INTO milNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","dico ñá túú xìní‑ndɨ́ nása ní cuu ní ndúha núú‑dě, te ni ñà túú xìní‑ndɨ́ yoo ní quide tátna. Chí càcáⁿ tnúhú nǔú méé‑dě xíǎⁿ nǔu sa sàcuéhé‑dě, te na càháⁿ‑dé nǔu nása ní cuu ní ndúha núú‑dě —càchí‑yu xǎhǎⁿ‑yu xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Duha ní cáháⁿ tǎtá‑dě ndɨhɨ nǎná‑dě ní xáhǎⁿ‑yu xii‑güedé cuèndá sá yùhú‑yu cue tée cùnuu núú ñǎyiu isràél, chi cue tée‑ǎⁿ sa ní ndatnúhu‑güedé ní cuu ɨɨⁿnuu‑güedě sá nǔu ndědacàa ñáyiu na càháⁿ sá Jèsús cúú‑gǎ Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a, te vá dáñá‑gǎ‑güedé quɨ́hu‑yu veñúhu. ");
INSERT INTO milNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Núu xíǎⁿ ní xáhaⁿ tǎtá‑dě ndɨhɨ nǎná‑dě sá ná càcáⁿ tnúhú‑güedě núú méé‑dě chi sa sacuéhé‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Te xíǎⁿ nǔu ní cana tucu‑güedé tée ní ndúha núú‑xi‑áⁿ, te ní xáhaⁿ‑güedě: —Cáháⁿ‑n ɨ̀ɨⁿ tnúhu ndáá chi Yá Ndiǒxí ndéhé ndɨ̀ɨ‑gá nàcuáa ní cuu ní ndúha núú‑n, chi nchúhú xìní‑ndɨ́ sá dìcó ɨɨⁿ tée ndècu yícá cuěchi‑xi cùu tée càchí‑n nǐ quide tátna núú‑n —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Te ní xáhaⁿ‑dě: —Yúhú, ñá túú xìní‑í te núu tée ndècu yícá cuěchi‑xi cùu‑dé àdi ñáhá. Dìcó‑ni sá xìní‑í sá cuàá‑í ní cùu te vitna ní cuu cundehe‑ǐ —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Te ní xícáⁿ tnúhú tùcu‑güedé núú‑dě, te xǎhaⁿ‑güedě: —¿Nása ní quide ñaha‑dě xii‑n te ní ndúha núú‑n‑í? —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Te ní xáhaⁿ‑dě: —Yúhú sa ní cáháⁿ‑í te ñá túú quìde cuendá‑ndó. ¿Te ná cuèndá cuìní‑ndó càchí tnúhu‑ni tucu‑í? ¿Á tnàhá‑ndó cuìní‑ndó quɨ̀ndáá iní‑ndó tnǔhu càháⁿ‑dé? —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Te ní cudééⁿ‑güedě núú‑dě, te ní xáhaⁿ‑güedě xii‑dé: —Te núu yòhó cuìní‑n chìnchícúⁿ‑n těe‑ǎⁿ te cuàháⁿ, dico nchúhú chi canchicúⁿ nihnu nahi‑ni‑ndɨ̌ nàcuáa ní cáháⁿ ndíi Moìsés. ");
INSERT INTO milNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Te nchúhú chi nàha‑ndɨ́ sá Yǎ Ndiǒxí ní cáháⁿ ndɨhɨ‑gá ndíi Moìsés, dico tée càchí‑n‑ǎⁿ chi ni ñà túú xìní‑ndɨ́ ndèé tée cùu‑dé —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Te ní xáhaⁿ těe ní ndúha núú‑xi‑áⁿ: —¿Te náa ñá dɨ́ú nchòhó càchí‑ndó sǎ ǐo túha‑ndo? Te núu ducaⁿ càháⁿ‑ndó sǎ ñà túú xìní‑ndó ndèé tée cùu‑dé, te dɨu‑dé ní quide tátna‑dé núù‑í ní ndúha —càchí‑dé xǎhaⁿ‑dě xii‑güedé. Te xǎhaⁿ tùcu‑dé: ");
INSERT INTO milNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","—Xìní‑ó sǎ Yǎ Ndiǒxí ñá túú tèdóho‑gá tnúhu càháⁿ ñáyiu quìde nchaa sá cuèhé sá dúhá, chi nchaa ñáyiu quìde cahnu ñaha xii‑gá te quìdé‑yu nchaa nàcuáa cùu iní‑gá, te ñáyiu‑áⁿ tédǒho‑gá tnúhu càháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Te ñá ɨ́ɨ́ⁿ ndùu cáháⁿ ñáyiu cuèndá ɨɨⁿ tée cada tátna núú ɨ̀ɨⁿ ñáyiu cuàá ndéé ní cacu‑xi te ndúha. ");
INSERT INTO milNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Te núu ñá dɨ́ú mèe Yá Ndiǒxí ní tèndaha ñaha‑gá xii tée‑ǎⁿ véxi‑dé ñá, te vá ndácú‑dě cada tátna‑dé núù‑í ní cùu —cachí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Te ní xáhaⁿ‑güedě: —Dico yòhó ndèé yatni vài cuéchi sa ta quìde‑n véxi, ¿te vitna nacanu ichi ñaha‑n xìi‑ndɨ́ cáháⁿ‑n‑ǎⁿ? —càchí‑güedé xǎhaⁿ‑güedě xii‑dé. Te ní queñuhu ñaha‑güedě xii‑dé tnuú‑güedé ñá túú ní dàña‑gá‑güedé níhí tnáhá ndɨ̀hɨ ñaha‑dé xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Te ní níhí Jèsús tnúhu sá nǐ queñuhu‑güedé tée ní cuhú núú‑xi‑áⁿ tnuú‑güedé cuèndá sá vǎ tnàhá tnúhu ndɨhɨ ñaha‑gǎ‑dé xii‑güedé, te ní naníhí ñáhá‑gǎ xii‑dé te ní xáhaⁿ‑gǎ: —¿Sàndáá iní‑n Děhe Yá Ndiǒxí‑ǎⁿ? —càchí‑gá xáhaⁿ‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Te ní xáhaⁿ těe ní cuhú núú‑xi‑áⁿ: —Mèstrú, cachí tnúhu núu ndèé ndécú těe‑áⁿ cuèndá quɨ́ndáá iní‑í‑dé —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Te ní xáhaⁿ Jèsús: —Sa xìní‑n‑dě chi dɨu‑dé cúú yǔhú tée ndàtnúhu ndɨhɨ‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Te ní ngüɨ́ñɨ́ xɨ́tɨ́‑dě núú‑gǎ, te ní xáhaⁿ‑dě: —Xítohó Jesucrìstú, sàndáá iní ñáhà‑í xii‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Te ní xáhaⁿ tùcu Jesús: —Yúhú véxi‑í ñuyíú‑a cada ndáá‑í cuéchi ñáyiu. Te nchaa ñáyiu ñá túú quìde váha cùú‑yu dàtná ɨɨⁿ ñáyiu cuàá, dico nchaa ñáyiu cùtnuní iní‑xi sá ñà túú quìde váha, te núu na quɨ̀ndáá iní‑yu tnúhu càháⁿ‑í, te cada iní‑ndó sǎ dàtná sá nǐ nacaáⁿ núǔ‑yu chi tnɨɨ́‑yu tnúhu càháⁿ‑í. Te ñáyiu càchí sá quídé vǎha vá nǔu núu‑yu cuéchi‑yu chi quesàhá‑yu sá ǐo ndáá quídě‑yu, ñáyiu‑áⁿ cúǔ‑yu dàtná ɨɨⁿ ñáyiu cuàá, chi vá ndíxí tǔu iní‑yu sá ñà túú quìde váha‑yu ndècú‑yu, te vá tnɨ́ɨ̌‑yu tnúhu càháⁿ‑í —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Te sá dúcáⁿ nǐ cáháⁿ‑gá, núu ní cáháⁿ ɨɨⁿ ǔú cue tée cùu fariséú, te xǎhaⁿ‑güedě: —¿Te náa tnàhá nchúhú cuàá‑ndɨ́ cáháⁿ‑n‑ǎⁿ? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Te ní xáhaⁿ Jèsús: —Te núu dìcó nchòhó cuàá‑ndó ñá, te vá cúndècu cuéchi‑ndo ni cùu, dico càchí‑ndó sǎ ndéhé‑ndó ɨ̀ɨⁿ sá quídé‑ndó te ñá ndàá, núu xíǎⁿ ío ndècu cuéchi‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Te na càchí tnúhu ndáá‑í xii‑ndo sǎ ɨ̀ɨⁿ tée ñá túú quɨ̌hu ndàa yuyehe ɨɨⁿ currálí mběé, te cùtexínu‑ni na cuìdó‑dé, tée‑áⁿ cúú‑dě ñádúhú. ");
INSERT INTO milNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Dico tée quɨ́hu ichi yèhe currálí‑güedɨ, tée‑áⁿ cúú‑dě xítohó‑güedɨ. ");
INSERT INTO milNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Te tée ndèé yèhe currálí‑güedɨ nàcaáⁿ‑dé te cuánguɨhu xítohó‑güedɨ te ní cáháⁿ‑dé, te ní nucúhuⁿ ndudú ñáhá‑güèdɨ xii‑dé. Te ní cáháⁿ dɨ́ú‑dě‑güedɨ te ní queñuhu‑dé‑güedɨ cùrrálí. ");
INSERT INTO milNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Te sátá nǐ quee‑güedɨ cùrrálí, te ní ngódó núú‑dě núú‑güedɨ, te ní ngüíta nchicúⁿ ñáhá‑güèdɨ xii‑dé chi ní nucúhuⁿ ndudú ñáhá‑güèdɨ. ");
INSERT INTO milNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Te ñá túú chìnchícúⁿ‑güedɨ ɨɨⁿ tée tàtú, chi nùcúhuⁿ ndudú‑güedɨ sá ñà dɨ́ú xǐtohó‑güedɨ cùu‑dé, núu xíǎⁿ xínú‑güèdɨ núú‑dě —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Duha ní cáháⁿ Jèsús cuèndá sá cuìní‑gá dacuàhá‑yu tnúhu‑gá ní cùu, dico ñá ní tècú tnùní‑yu nása ndùu tnúhu ní cáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Te ní xáhaⁿ tùcu Jesús xii‑güedé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ yǔhú cúù‑í dàtná ɨɨⁿ yèhe currálí núú ndɨ̌hu cue mběé. ");
INSERT INTO milNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Te nchaa cue tée sa yòdo nuu‑gá ní quixi ní dándàhú‑güedé ñáyiu cùu‑güedé dàtná ñádúhú dùhu‑güedé cue mběé ní cùu, dico ñá ní quìde cuendá ñáhá‑güèdɨ xii‑güedé, chi ní cutnùní iní‑güedɨ sá ñà dɨ́ú xǐtohó‑güedɨ cùu‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Te yúhú cúù‑í dàtná yuyèhe currálí cue mběé. Te ducaⁿ sǎtnahá‑xi cùu‑í chi nchaa ñáyiu na tùha ñaha xii‑í te naníhí tàhú‑yu. Te cùú‑yu dàtná cue mběé quɨtɨ xǐquee cùrrálí‑xi cuáháⁿ‑güedɨ núú cáá ìté caxi‑güedɨ, te dǎtnùní cuándɨhu‑ná‑güedɨ cùrrálí, ducaⁿ sǎtnahá‑xi cùú‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ñádúhú òré véxi‑dé chi dùhu‑dé, sàhni‑dé te dànaa‑dé mběé, dico yúhú chi véxi‑í cuèndá sá nánìhí tàhú‑ndó te ío cudɨ́ɨ́ ìní‑ndó cùnu cuechi‑ndo núú Dǔtú Ndiǒxí nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Te yúhú cúù‑í dàtná ɨɨⁿ toli tée ío nèhe cuendá mběé‑xi, chi tée‑áⁿ cuěi na cùú‑dé sá cúú‑xí mběé‑dě cuèndá‑nǎ sá ná cǎcu‑güedɨ. ");
INSERT INTO milNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Te núu ɨɨⁿ tée na còto ñaha xii‑güedɨ, te tée‑áⁿ cuèndá‑ni sá ñúhú yǎhu‑dé xító‑dě‑güedɨ. Te núu na quìní‑dé sáá ɨɨⁿ quɨtɨ dééⁿ te dàña‑dé‑güedɨ xìnu‑dé, te ndɨ̀hɨ‑güedɨ xité nuu ñaha quɨ̀tɨ dééⁿ‑ǎⁿ, chi ñá dɨ́ú mèi xítohó‑güedɨ cùu‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chi cuèndá‑ni sá ñúhú yǎhu‑dé xító‑dě‑güedɨ núu ñá túú nǎ ndɨ̀hú iní‑dé cuěi na dàndɨhɨ ñaha quɨtɨ cuihna. ");
INSERT INTO milNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Te yúhú cúù‑í dàtná ɨɨⁿ tée ío váha xìto mbéé‑xi, chi tée‑áⁿ da ɨɨⁿ da ɨɨⁿ‑dɨ xìní‑í‑dé nàcuáa ndǎa‑dɨ, te ducaⁿ xìní ñáhá‑güèdɨ xii‑dé. Te ducaⁿ sǎtnahá‑xi cùu yúhú ndɨhɨ nchaa ñáyiu sàndáá iní ñáhá xìi‑í, chi yúhú xìní‑í‑yu te ducaⁿ mèé‑yu xìní ñáhǎ‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","’Te dɨu‑ni ducaⁿ cùu‑í ndɨhɨ Tǎtà‑í, chi xìní ñáhá‑gǎ xii‑í te xìní‑í‑gá. Te sáá nduu cùú‑í cuèndá nchaa ñáyiu sàndáá iní ñáhá xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Te ndècu‑gá ñáyiu vátá quɨ̀ndáá iní ñáhá‑gǎ xii‑í. Te xìni ñuhu‑xi cundedóho‑yu tnúhu‑í te quɨndáá iní ñáhǎ‑yu cuèndá ɨɨⁿ‑nǎ ichi cuú‑yu, te ducaⁿ cùndecu ɨɨⁿ‑ná tée coto ñaha xìí‑yu cuu‑dé dàtná ɨɨⁿ tòlí‑yu, te tée coto ñaha xìí‑yu‑áⁿ cúú yǔhú. ");
INSERT INTO milNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Te Tǎtà‑í ío cùdɨ́ɨ́ ìní ñáhá‑gǎ xii‑í cuèndá sá sàá ɨɨⁿ nduu te cuú‑í, te cuú‑í chi ducaⁿ càchí iní‑í, te ñá dɨ́ú sǎ cúú ìní ñáyiu ñuyíú‑a cuú‑í, te cuú‑í dico ndoto‑í. ");
INSERT INTO milNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Te vá yǒo ɨɨⁿ te ndacu cahni ñaha xìi‑í, te núu ñá dɨ́ú sǎ cúú ìní méè‑í cuú‑í. Te dàtná‑ni cùu iní‑í sá cùú‑í te dɨu‑ni ducaⁿ ndòto‑í chi ducaⁿ nǐ cachí Tǎtà‑í Dútú Ndiǒxí cunduu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Te sá dúcáⁿ nǐ cáháⁿ‑gá te ñá ní cùu ɨɨⁿnuu tucu ñáyiu isràél. ");
INSERT INTO milNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Te davá‑yu ní xítnàhá‑yu: —¿Ná cuèndá sàndáá‑tu iní‑ndó tnǔhu càháⁿ tée‑ǎⁿ, te yucu ñǎvǎha ndècu ndɨhɨ‑dé, lùcú tée‑ǎⁿ? —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Te davá‑yu ní xítnàhá‑yu: —¿Náa xìní‑ndó ɨ̀ɨⁿ tée ndècu ndɨhɨ yucu ñávǎha duha váha càháⁿ‑dé? ¿Náa xìní‑ndó nǔu ndàcu yucu ñávǎha cada tátna‑xi núú ɨ̀ɨⁿ tée cuàá te ndúha? —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Te ndɨ tnahá cuíá ndádá càhnú‑yu vico veñúhu càhnu sá ǐo cùnuu ñuú Jerusàlén, te mei yǒó quídé vǐxiⁿ‑xi quìdé‑yu vico‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Te corrèdór veñúhu‑áⁿ nání‑xí Sàlomón, te xíáⁿ xícá cùu Jesús. ");
INSERT INTO milNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Te ní chítú níhnú ñǎyiu isràél núú‑gǎ, te ní xáhǎⁿ‑yu: —¿Ná ndéé òré cachí tnúhu ndáá‑n, te núu sá Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a cùu‑n, àdi ná tée cùu‑n?, cáháⁿ‑ni‑n —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Te ní xáhaⁿ Jèsús: —Sa ní cachí tnúhu‑í te ñá sàndáá iní‑ndó, te ndèhe‑ndo sá váí nǔú sǎ quídè‑í sá nǐ táúchíúⁿ Tǎtà‑í cada‑í, te cùu‑xi ɨɨⁿ sá cútnùní iní‑ndó nǎ tée cùu‑í. ");
INSERT INTO milNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Dico nchòhó ñá sàndáá iní‑ndó, chi ñá túú cùu‑ndo ñáyiu ní chitnahá ñáhá xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Chi nchaa ñáyiu ní chitnahá ñáhá xìi‑í cùú‑yu dàtná cue mběé quɨtɨ xǐndecu ndɨhɨ xítohó‑xi chi nùcúhuⁿ ndudú‑güedɨ xítohó‑güedɨ, te ducaⁿ nàquiní ñáhá‑ní xǐtohó‑güedɨ xii‑güedɨ. Ducaⁿ sǎtnahá‑xi cùu nchaa ñáyiu ní chitnahá ñáhá xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Te yúhú cada‑í te nduu táhǔ‑yu cundecu ndɨhɨ ñàhá‑yu xii‑í nɨ caa nɨ quɨ́hɨ́ⁿ te vá ɨ́ɨ́ⁿ ndùu‑gá cuíta nihnú‑yu, te ni vǎ yǒo ɨɨⁿ ndacu naquendeé ñáhá xìí‑yu ndaha‑í. ");
INSERT INTO milNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Chi Tǎtà‑í ní taxi cuèndá ñáhá‑gǎ xií‑yu. Te ío cùnuu‑gá nǔu xíǎⁿ vá yǒo ɨɨⁿ ndacu naquendeé ñáhá xìí‑yu ndaha‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yúhú ndɨhɨ Tǎtà‑í Dútú Ndiǒxí ɨɨⁿ‑ni cùu‑ndɨ́ —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Te ní queheⁿ tucu ñáyiu isràél yúú cuǎha ñàhá‑yu xii‑gá ní cùu. ");
INSERT INTO milNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Te ní xáhaⁿ‑gǎ xií‑yu: —Ío cuéhé sǎ vǎha ní quide‑í núú‑ndó nǐ chindee ñàha Tátà‑í Dútú Ndiǒxí. ¿Te ndědacàa sá ñǎ tnàhá iní‑ndó nǔu cuìní‑ndó cuǎha ñaha‑ndo yǔú xii‑í‑i? —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Te ní xáhaⁿ ñǎyiu isràél: —Ñá dɨ́ú cuèndá nchaa sá vǎha ni quìde‑n cuiní‑ndɨ́ cuáha ñaha‑ndɨ̌ yúú xii‑n, chi ɨɨⁿ dìi‑ni sá ǐo càháⁿ úhú‑n cuèndá Yǎ Ndiǒxí. Te dìcó ɨɨⁿ tée ñuyíú‑a cùu‑n te càchí‑n sǎ cúú‑n Ndiǒxí —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Te ní xáhaⁿ Jèsús: —Núú tùtú Yǎ Ndiǒxí sá ndécú ndɨ̀hɨ‑ndo cáháⁿ‑xi nàcuáa ní cáháⁿ‑gá, te duha ní cachí‑gá: “Nchòhó quídé‑ndó nǔù‑í”, duha ní cachí‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Te nàha‑o sá vǎ cúú quèhndé nihnu‑o tnǔhu yòdo tnuní núú tùtú Yǎ Ndiǒxí, chi mee‑gǎ ní cachí‑gá sá cádǎ‑yu núú‑gǎ, te vá càchí‑ó sǎ ñǎ ndàá. ");
INSERT INTO milNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Te núu ducaⁿ nǐ cáháⁿ‑gá sá nǔú‑gǎ quídé nchàa ñáyiu ní sándáá iní ñáhá xìi‑gá ñá, ¿te ná cuèndá cúděéⁿ‑ndó nǔú yǔhú sá càchí‑í sá cúù‑í Déhe‑gá? Te mee Yǎ Ndiǒxí ní tendaha ñàha‑gá xii‑í véxi‑í ñuyíú‑a sá cádà‑í chìuⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Te núu ñá túú quìde‑í nàcuáa ní táúchíúⁿ Tǎtà‑í cada‑í ñá, te vá quɨ̀ndáá iní ñáhá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Te núu quìde‑í ñá, te cuěi vá quɨ̀ndáá iní ñáhá‑ndó xìi mee‑í dico quɨndáá iní‑ndó nchàa chiuⁿ quide‑í. Ducaⁿ te cutnùní ndáá iní‑ndó sǎ Yǎ Ndiǒxí ndécú ndɨ̀hɨ‑í te ɨɨⁿ‑ni cùu‑ndɨ́ —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Te ní cuiní‑güedé tnɨɨ ñaha tùcu‑güedé xii‑gá quɨ́hɨ́ⁿ‑gá vecaá ní cùu, dico ní xinu núú ñáhá‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Te ní xica‑gá cuáháⁿ‑gá ndàa ɨngá xio yúte Jòrdán núú nǐ xóo dacuàndute ndíi Juàá ñáyiu ndéé díhna, yàcáⁿ ní xíndecu‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Te yàcáⁿ ío vài ñáyiu ní sáháⁿ ní cáháⁿ ndɨhɨ ñaha xìi‑gá, te ní xítnàhá‑yu: —Ndíi Juàá, cuěi ñá túú ní quìde ndíi sá vǎ yǒo tnàhí ndàcu cada dico ndáá ní cáháⁿ ndíi, chi dàtná‑ni ní cáháⁿ ndíi quìde tée‑a —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Te yàcáⁿ ío vàí‑yu ní sándáá iní ñáhǎ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ñuú Bètaniá ní xíndecu ɨɨⁿ tée ní xínani‑dě Lǎzarú. Te càhú víhí nǐ tnahá‑dé ní cuhú‑dé, te ní xíndecu ndɨhɨ‑dé cue cúha‑dé tá Màriá ndɨhɨ tá Mǎrta chi xíáⁿ ñùú‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Te tá Màriá‑áⁿ cúú‑xí xǐchí nǐ sódó àcití sàháⁿ tnámí sǎhá Jèsús, te ní nadayìchí‑xi sáhá‑gǎ ndɨhɨ idi dɨ́quɨ́‑xi. Te cuèndá sá cùhú cúha‑yu té Lǎzarú, ");
INSERT INTO milNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","núu ní tendàhá‑yu ñáyiu nàha tnúhu cuáháⁿ núú Jèsús, te xǎhǎⁿ‑yu xii‑gá: —Mèstrú, tée ío cùu iní‑n ǐo càhú tnàhá‑dé cùhú‑dé —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Te sá dúcáⁿ càa tnúhu ní sáá, núu ní xáhaⁿ Jèsús xií‑yu: —Dico cuéhé‑ǎⁿ chi vá cùú‑dé sá cùú dúcáⁿ‑dě, chi Yá Ndiǒxí cuìní‑gá sá quìní‑yu nchaa sá cádá‑gǎ cuèndá chiñuhu ñàhá‑yu xii‑gá, te dɨu‑ni ducaⁿ chìñuhu ñahá‑yu xii yúhú Déhe‑gá —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Te cuěi ío cùu iní ñáhá Jèsús xii té Lǎzarú ndɨhɨ cue cúha‑dé ");
INSERT INTO milNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","dico òré ní níhí‑gǎ tnúhu, te ní cuyaa‑gǎ úú‑gá nduu núú ndécú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Te ní xáhaⁿ‑gǎ xii cue tée xìca cuu ndɨhɨ‑gá: —Na quɨ̀hɨ́ⁿ tucu‑o dìstritú Jùdeá —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Te ní xáhaⁿ cuè tée xìca cuu ndɨhɨ‑gá xii‑gá: —Mèstrú, vitna‑ni cuìní cue tée isràél xǐndecu yàcáⁿ cuáha ñaha‑güedě xii‑n yùú ní cùu, ¿te cuìní‑ni tucu‑n quɨ̌hɨ́ⁿ‑n‑ú? —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Te ní xáhaⁿ Jèsús: —Úxúú òré cúú ɨ̀ɨⁿ nduu, te núu nduu na càca cuu‑o, te ñá túú nǎ candaundeé‑ó chi cùtnuní núú‑ó chi dìtó. ");
INSERT INTO milNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Dico núu niú ná càca cuu‑o, te ìó ná candaundeé‑ó chi vá cútnùní núú‑ó —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Te ní xáhaⁿ Jèsús: —Té Lǎzarú tée ío váha tnàhá tnúhu ndɨhɨ‑o nǐ xídí‑dé dico quɨ́hɨ́ⁿ‑ó chi ndocani‑o‑dě —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Te ní xáhaⁿ‑güedě xii‑gá: —Mèstrú, te núu xìdí‑dé te váa sa ta ndǔha‑dé cuáháⁿ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Duha ní cáháⁿ Jèsús, chi té Lǎzarú sa ní xíhí‑dé te cue tée xìca cuu ndɨhɨ‑gá ní sani iní‑güedé sá nǐ xídí ndisa‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Te Jèsús ní xáhaⁿ ndǎá‑gá xii‑güedé: —Sa ní xíhí té Lǎzarú. ");
INSERT INTO milNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Váha‑gá sá ñǎ ní sǎháⁿ‑í quɨ́ngoto‑í‑dé, chi ndècu ɨngá chìuⁿ cada‑í quiní‑ndó, te quɨndáá iní ñáhá‑gǎ‑ndó xìi‑í, te vitna na quɨ̀hɨ́ⁿ‑ó nǔú ndécú yɨ̀quɨ cuñú ndíi —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Te té Mǎxí tée xǎhaⁿ‑güedě cuǎchí ní xáhaⁿ‑dě xii dava‑gá‑güedé: —Na quɨ̀hɨ́ⁿ‑ó nchàa‑o chi yàcáⁿ cuú‑ó ndɨ̀hɨ‑dé —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Te òré ní sáá Jèsús ñuú Bètaniá, te ní xáhǎⁿ‑yu sá sà ní cuu cúmí nduu ní xíhí té Lǎzarú. ");
INSERT INTO milNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Te ñuú‑áⁿ cáá yàtni‑ni‑gá ñuú Jerusàlén, dàtná cuádava‑ná òré cuhuⁿ‑o ìchi te saá‑ó. ");
INSERT INTO milNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Núu xíǎⁿ vài ñáyiu isràél ní sáháⁿ‑yu ní cáháⁿ ndɨhɨ́‑yu tá Mǎrta ndɨhɨ cúhú‑xi tá Màriá, te ní sáñàhá‑yu tnúhu ndee ìní sá dúcáⁿ nǐ xíhí cúha‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Te ní níhí tǎ Mǎrta tnúhu sá ñúhú Jèsús ichi cuáháⁿ‑gá núú ndécǔ‑yu núu ní sáháⁿ‑xi ní sátnahá‑xi‑gá, te cúhú‑xi tá Màriá ní ndóo‑xi vehe. ");
INSERT INTO milNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Te òré ní naníhí tǎ Mǎrta Jèsús, te ní xáhaⁿ‑xi xìi‑gá: —Mèstrú, te núu dìcó ní xǐndecu‑n ìha te vá cùú cúha‑ndɨ́ ní cùu. ");
INSERT INTO milNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Te cuěi vitna te núu ná sá ná càcáⁿ‑n nǔú Yǎ Ndiǒxí te taxi‑gá xii‑n —càchí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Te ní xáhaⁿ Jèsús: —Vá ndɨ̀hú iní‑n chi ndoto cúha‑n —càchí‑gá xáhaⁿ‑gǎ xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Te ní xáhaⁿ tǎ Mǎrta: —Ndáá chi sa xìní‑í sá ndótó‑dě ná quɨ̌tnahá nduu ndòto nchaa ñáyiu ní xíhí —càchí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Te ní xáhaⁿ Jèsús: —Yúhú dandòto‑í‑yu cuèndá cundecú‑yu nɨ caa nɨ quɨ́hɨ́ⁿ ná sàá nduu. Te nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í, te cuěi na cùú‑yu dico ndotó‑yu cundecu‑í ndɨhɨ́‑yu nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Te nchaa ñáyiu ndècu vívú ñuyíú‑a te núu na quɨ̀ndáá iní ñáhǎ‑yu xii‑í, te cundecu ndɨhɨ‑í‑yu nɨ caa nɨ quɨ́hɨ́ⁿ. ¿Sàndáá iní‑n tnǔhu‑a ñǎ? —càchí‑gá xáhaⁿ‑gǎ xii tá Mǎrta. ");
INSERT INTO milNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Te xǎhaⁿ‑xi: —Mèstrú, sàndáá iní‑í, te sàndáá tucu iní‑í sá dɨ́ú‑n cùu‑n Cristú Déhe Yá Ndiǒxí, Yaá ní tendaha‑gǎ véxi ñuyíú‑a —càchí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Sátá dúcáⁿ nǐ cáháⁿ‑xi te ní sáháⁿ ngana‑xi cúhú‑xi tá Màriá, te dayuhu nǐ xáhaⁿ‑xi: —Yàcáⁿ ní quexìo Mestrú, te càna ñaha‑dé xii‑n —càchí‑xi xǎhaⁿ‑xi. ");
INSERT INTO milNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Te sá dúcáⁿ xǎhaⁿ cǔhú tǎ Màriá sá cáná ñàha Jesús xii‑xi, núu ndɨ̌hɨ‑ni ní xica‑xi cuáháⁿ‑xi núú ndécú‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Te Jèsús vátá quɨ̌hu‑gá xɨtɨ́ ñuú, chi ndècu‑ni‑gá núú nǐ sáháⁿ tnahá ñáhá tǎ Mǎrta. ");
INSERT INTO milNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Te ñáyiu isràél ndécú sǎñaha tnǔhu ndee ìní xii tá Màriá ndɨhɨ cúhú‑xi ní sani iní‑yu sá cuàháⁿ‑xi núú yɨ́ndǔxi cúha‑xi ndáhyú‑xi ní cáhǎⁿ‑yu, núu nchìcúⁿ‑yu‑xi cuáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Te ní sáá tá Màriá núú ndécú Jèsús te ní ngüɨ́ñɨ́ xɨ́tɨ́‑xí nǔú‑gǎ, te xǎhaⁿ‑xi xìi‑gá: —Mèstrú, te núu dìcó ní xǐndecu‑n ìha te vá cùú cúha‑ndɨ́ ní cùu —cachí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Te sá nǐ xiní Jèsús ndàhyú tá Màriá ndɨhɨ ñáyiu isràél nchìcúⁿ ñáhá cuǎháⁿ, xíǎⁿ ío ní cuyica ìní‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Te ní xáhaⁿ‑gǎ xií‑yu: —¿Ndèé ní taxi ndecu‑ndo yɨ̀quɨ cuñú‑dé‑i? —càchí‑gá xáhaⁿ‑gǎ xií‑yu. Te ní xáhǎⁿ‑yu: —Mèstrú, néhé ná quɨ̀hɨ́ⁿ‑ó te quiní‑n —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Te ní ndáhyú‑gá tnàhá‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Te ní xítnàha ñáyiu isràél: —Súúní cùu iní‑dé ndíi ni cùu —cachí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Te davá‑yu xǐtnàhá‑yu: —Tée‑a ní quide tátna‑dé núú těe cuàá te ní ndúha. ¿Te nása ní cuu núu ñá túú ní quìde tátna‑dé té Lǎzarú cuèndá sá vǎ cùú‑dé ní cùu‑i? —cachí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Te ío ní cuyica tùcu iní Jèsús òré ní quexìo‑gá yuhu yàú núú nǐ chihi‑güedé yɨquɨ cùñú té Lǎzarú. Te yuhu yàú‑áⁿ ndèdɨ́ ɨɨⁿ yúú. ");
INSERT INTO milNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Te ní xáhaⁿ Jèsús xií‑yu: —Chí xócàni yúú‑ǎⁿ —càchí‑gá xáhaⁿ‑gǎ xií‑yu. Te ní xáhaⁿ tǎ Mǎrta cúha tée ní xíhí‑áⁿ: —Mèstrú, sa tucu sàháⁿ‑dé chi sa ní cuu cúmí nduu sá nǐ xíhí‑dé —càchí‑xi xǎhaⁿ‑xi xìi‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Te ní xáhaⁿ Jèsús: —¿Náa ñá dɨ́ú nǐ cachí‑í sá nǔu na quɨ̀ndáá iní‑n, te quiní‑n sǎ ǐo càhnu cuu Yá Ndiǒxí? —càchí‑gá xáhaⁿ‑gǎ xii‑xi. ");
INSERT INTO milNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Te ní xócánǐ‑yu yúú ndèdɨ́ yuhu yàú‑áⁿ. Te ní ndacoto‑gá andɨu, te ní xáhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí: —Táu, ndàcáⁿ táhù‑í núú‑n sǎ nǐ tèdoho‑n tnúhu ní cáháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Te yúhú sa nàha‑í sá ncháá‑ni òré ndèdóho ñaha‑n xìi‑í, dico duha càháⁿ‑í cuèndá sá ná tècú dóho nchaa ñáyiu ndècu iha cuendá quɨ́ndáá iní‑yu sá dɨ́ú‑n nǐ tendaha ñàha‑n xii‑í véxi‑í ñuyíú‑a —càchí‑gá xáhaⁿ‑gǎ xii Dútú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Te sátá dúcáⁿ nǐ cáháⁿ‑gá ndɨhɨ Yá Ndiǒxí, te níhi ní cáháⁿ‑gá xáhaⁿ‑gǎ xii tée ní xíhí‑áⁿ: —¡Lǎzarú, tandèe xíáⁿ! —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Te ní ndee tée ní xíhí‑áⁿ yaú‑áⁿ, te ndùtu dóó cuɨ́ñɨ́ ndàha‑dé ndɨhɨ sáhá‑dě, te dǎhu tucu ɨɨⁿ dóó nǔú‑dě. Te ní xáhaⁿ Jèsús xií‑yu: —Chí nándàxi‑dé te daña‑ndo‑dě ná cácá‑dě —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Te nchaa ñáyiu nchìcúⁿ ñáhá xìi tá Màriá cuáháⁿ ío vàí‑yu ní sándáá iní‑yu Jèsús sá nǐ xiní‑yu nàcuáa ní quide‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Dico davá‑yu ní sáháⁿ‑yu núú cuè tée cùu fariséú, te ní caní‑yu cuèndú núú‑güedě nàcuáa ní quide Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Te cue tée cùu fariséú ndɨhɨ cue dútú cúnùu ní natacá‑güedé ní xóo‑güedé jùndá, te ní xítnàha‑güedé: —¿Nása cada‑o?, chi tée‑ǎⁿ ío vài sá vǎ yǒo tnàhí ndàcu cada quide‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Te núu na dàña íó te nchaa ñáyiu quɨndáá iní ñáhǎ‑yu xii‑dé, te quixi cue tée ñuú Ròmá dangòyo‑güedé veñúhu‑o te danàa‑güedé nchaa ñuú‑ó —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Te ɨɨⁿ cue tée‑áⁿ nání‑dě Caìfás, te cùnuu‑gá‑dé núú dàva‑gá cue dútú cuǐá‑ǎⁿ, te ní xáhaⁿ‑dě xii‑güedé: —Nchòhó ni lùha ñá túú cùtnuní iní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Te ni ñǎ sǎha‑ndo cuèndá sá vǎha‑gá tnahá‑ó, te núu na cùú ɨɨⁿ‑ni tée cuèndá nchaa ñáyiu isràél, te ñá dɨ́ú sǎ dánàa ñaha‑güedé xií‑yu —càchí‑dé xǎhaⁿ‑dě xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Dico té Caìfás chi ñá dɨ́ú sǎ cúú ìní méé‑dě ní cǎháⁿ‑dé, chi cuèndá sá cuǐá‑ǎⁿ nǐ cunuu‑dě núú cuè dútú, núu xíǎⁿ Yǎ Ndiǒxí ní dácáhú ìní ñáhá‑gǎ nàcuáa cáháⁿ‑dé sá Jèsús cuú‑gá sá cúú‑xí nchàa ñáyiu isràél. ");
INSERT INTO milNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Te ñá dɨ́ú cuèndá mee‑ni ñǎyiu‑áⁿ cuú‑gá, chi cuú‑gá tnàhá cuèndá nchaa ñáyiu ní sándáá iní ñáhá xìi‑gá, ñáyiu nchìténuu nɨhìí ñuyíú, te ɨɨⁿ‑nǎ cuú‑yu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Núu ndéé nduu‑ǎⁿ nǐ ndatnúhu cue tée cùnuu núú ñǎyiu isràél nàcuáa cada‑güedé cahni‑güedé Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Te xíǎⁿ nǔu ñá ní xìca cuu‑gá Jèsús quiní ñáhá ñǎyiu isràél, te ní quee‑gá cuáháⁿ‑gá ñuú Efràín, ɨɨⁿ ñuú cáá yàtni yucu, yàcáⁿ ní ngüɨ́ñɨ́‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Te ta cùyatni nduu cadá‑yu vico pàscuá. Te cuéhé ñǎyiu ní queé‑yu ñuú‑yu cuáháⁿ‑yu ñuú Jerusàlén cuèndá sá sà ndɨhɨ́‑yu nchaá‑yu nduu íí, te tnahá nduu vìco pascuá. ");
INSERT INTO milNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Te yàcáⁿ nándùcú‑yu Jèsús ní cùu te ñá túú‑gǎ òré‑áⁿ, te ní naníhí tnáhǎ‑yu xɨtɨ́ veñúhu, te xǐtnàhá‑yu: —¿Nása sàni iní‑ndó‑í? ¿Quixi Jèsús vico ǎⁿ ñǎhá? —càchí‑yu xǐtnàhá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Te cue tée cùu fariséú ndɨhɨ cue dútú cúnùu sa ní xáhaⁿ‑güedě xii ñáyiu sá nǔu nděda‑ni càá‑yu xìní‑yu núú ndécú Jèsús te na càháⁿ‑ni‑yu cuèndá tnɨɨ ñaha‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Íñú‑gá nduu cùmání tnahá vico pàscuá, te ní sáháⁿ Jèsús ñuú Bètaniá, ñuú té Lǎzarú tée ní dándótó‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Te xíáⁿ nǐ cadúha‑yu sá nǐ cudìni Jesús. Te tá Mǎrta ní sani‑xi cóhó, te té Lǎzarú yɨ́hɨ́‑dě mèsá ndɨhɨ Jèsús, ndɨhɨ dava‑gá‑güedé xéxí‑güedě. ");
INSERT INTO milNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Te tá Màriá néhé‑xí cuǎdava lǐtrú acìtí sàháⁿ tnámí sǎ ǐo ndèyáhu, te acìtí‑áⁿ nǐ cuáha mee‑ni yǔcú nǎrdú, te ní sódó‑xi sáhá Jèsús, te ní nadayìchí‑xi ndɨhɨ idi dɨ́quɨ́‑xi sáhá‑gǎ. Te nɨhìí xɨtɨ́ vehe ní xíté nuu dicó acìtí‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Te té Jùdás déhe té Xǐmú Iscàrioté dɨu‑ni ɨɨⁿ tée xìca cuu ndɨhɨ‑gá, tée cuáha cuèndá ñáhá xìi‑gá núú cuè tée cùu úhú iní ñáhá nǐ xáhaⁿ‑dě xii‑gá: ");
INSERT INTO milNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Ná cuèndá ñá ní cùyáhu acìtí‑a sá ùní cièndú díhúⁿ denàriú cuu cuèndá ñáyiu ndàhú? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Dico sá dúcáⁿ nǐ cáháⁿ té Jùdás chi ñá dɨ́ú sǎ ndísá ñùhu iní‑dé ñáyiu ndàhú chi dìcó‑ni ɨɨⁿ ñádúhú cúú‑dě, chi dɨu‑dé néhé cuèndá‑dé díhúⁿ‑güedě nchaa‑güedé te ní xóo duhu ñàha‑dé xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Te ní xáhaⁿ Jèsús: —Daña, vá dásàtú‑n ìní xíchí‑a na tàxúha nahi‑xi àcití‑a, chi nàndɨ́hɨ ndéé òré ná nguɨ̌ndǔxi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chi nchòhó chi cuhuⁿ tnahá‑ni ñáyiu ndàhú tnuú‑ndó, dico yúhú chi vá ncháá ndùu cundecu ndɨhɨ ñaha‑í xii‑ndo —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Te vài ñáyiu isràél ní níhǐ‑yu tnúhu sá ndécú Jèsús ñuú Bètaniá. Te ní sáháⁿ‑yu cuèndá quiní‑yu‑gá, te quiní‑yu tnàhá té Lǎzarú tée ní dándótó‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Te cue dútú cúnùu ní ndatnúhu‑güedé ní cuu ɨɨⁿnuu‑güedě cuèndá sá cáhní‑güedě tnàhá té Lǎzarú ní cùu, ");
INSERT INTO milNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","chi dɨu cuèndá tée‑áⁿ nǐ cuu cuéhé ñǎyiu isràél tá dàña nihnú‑yu‑güedé cuáháⁿ cuèndá sá nǐ sándáá iní‑yu Jèsús. ");
INSERT INTO milNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Te nduu tněé‑áⁿ vài ñáyiu ní quexìo ñuú Jerusàlén cuèndá cundecú‑yu vico, te ní níhǐ‑yu tnúhu sá Jèsús sáá‑gá tnàhá‑gá cundecu‑gá vico‑áⁿ, ");
INSERT INTO milNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","núu ní xehndé‑yu ndaha yùtnu ñúú, te nèhé‑yu ní sáháⁿ ní sátnahá ñáhǎ‑yu xii‑gá. Te níhi ní cáháⁿ‑yu, te càchí‑yu: —¡Ío càhnu cuu Yá Ndiǒxí! Te ducaⁿ‑ni ǐo càhnu cuu Yaá ní tendaha‑gǎ véxi quɨndaha ñàha xii‑o —duha ní cachí‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Te Jèsús ní níhí‑gǎ ɨɨⁿ bǔrru, te yòdo‑gá‑dɨ cuáháⁿ. Te ducaⁿ nǐ cuu chi ní quee ndáá‑xi nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí núú càchí‑xi: ");
INSERT INTO milNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Vá yùhú nchòhó cue ñáyiu ndècu ñuú Sìón, chi iha véxi tée yɨ̀ndaha ñaha xii‑ndo yodo‑dé ɨɨⁿ bǔrru. Duha càchí‑xi núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Dico cue tée xìca cuu ndɨhɨ Jesús ñá ní ndàcu iní‑güedé nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí nàcuáa cada Jèsús. Dico sátá cuǎndaa‑gá andɨu càda cahnu ñaha Tátá‑gǎ xii‑gá, te ní ndacu iní‑güedé sá dúcáⁿ yòdo tnuní nàcuáa cada‑gá, te ducaⁿ nǐ cuu. ");
INSERT INTO milNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nchaa ñáyiu ní xíndecu ndɨhɨ Jèsús òré ní dándótó‑gǎ té Lǎzarú, ya yàcáⁿ ní caní‑yu cuèndú núú ñǎyiu nàcuáa ní quide ñaha‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Te vàí‑yu ní sáháⁿ‑yu núú ndécú Jèsús cuèndá sá nǐ níhǐ‑yu tnúhu ní quide‑gá sá vǎ yǒo tnàhí ndàcu cada. ");
INSERT INTO milNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Te cue tée cùu fariséú ní xítnàha‑güedé: —Ní xito‑ndo nǎ ñá túú nàndɨhɨ sá quídé‑ó‑vá, chi nchaa ñáyiu ní chinchícúⁿ ñáhǎ‑yu xii‑dé —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Te tnàhá ñáyiu ñá túú cùu ñáyiu isràél ní sáháⁿ‑yu vico ñuú Jerusàlén ní quide càhnú‑yu Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Te ñáyiu‑áⁿ nǐ sáháⁿ‑yu núú tě Lìpé tée ñuú Bètsaidá, te ñuú‑áⁿ yɨ́ndèhu‑xi distritú Galìleá. Te ní xáhǎⁿ‑yu xii‑dé: —Tǎtá, vá cúndèe iní‑n càchí tnúhu‑n nǔu ndèé ndécú Jèsús, chi cuìní‑ndɨ́ cáháⁿ ndɨhɨ‑ndɨ́‑gá —càchí‑yu xǎhǎⁿ‑yu xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Te té Lìpé ní naníhí‑dě té Ndrǐxí te ní xáhaⁿ‑dě nàcuáa càháⁿ‑yu, te ndɨ ndùú‑güedé ní sáháⁿ‑güedé ní xáhaⁿ‑güedě xii Jèsús nàcuáa càháⁿ‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Te ní xáhaⁿ Jèsús xii‑güedé: —Vitna ní cuyatni òré cada càhnu ñaha Tátà‑í xii‑í, te quiní‑yu sá ǐo càhnu cuu yúhú Tée cùu ñaní tnáhǎ‑yu nchaá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nǔu ɨɨⁿ tatá vá ngává‑xí nǔú ñúhú těhyú‑xi ña, te dɨu‑ni ducaⁿ cùnduu‑xi cundecu‑xi. Dico ɨɨⁿ tatá ná ngává nǔú ñúhú xǐnu déhe‑xi, te xíǎⁿ nádàcayá tnáhá‑xí, te mee‑xi tèhyú‑xi. ");
INSERT INTO milNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Te nchaa ñáyiu ío ñùhu iní‑xi cundecu ñuyíú‑a ñá túú ñùhu iní‑yu Yá Ndiǒxí, te ñáyiu‑áⁿ cuǐta nihnú‑yu. Te nchaa ñáyiu ío ñùhu iní ñáhá xìi Yá Ndiǒxí, ñáyiu‑áⁿ cundecú‑yu ndɨhɨ‑gá nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Te nchaa ñáyiu cuìní cunu cuechi nǔù‑í xìni ñuhu‑xi natuha ñahá‑yu xii‑í, te nduu táhǔ‑yu cundecú‑yu núú nùhú‑í cundecu‑í. Te nchaa ñáyiu na cùnu cuechi núù‑í, te cada càhnu ñaha Tátà‑í xií‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Te ní xáhaⁿ tùcu‑gá: —Ío ndɨ̀hú iní‑í. Te cúñaha‑ǐ xii Tǎtà‑í taunihnu ñaha‑gǎ nǔu dìcó sá cúú, dico vá cúú chi cuèndá tnàhí‑a véxi‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Te ní xáhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí: —Táu, cada nàcuáa ní sani iní‑n cùnduu cuendá sá ná cádá càhnu ñaha ñáyiu xii‑n —càchí‑gá xáhaⁿ‑gǎ. Te ducaⁿ te ní tecú ní cáháⁿ Yǎ Ndiǒxí ndéé andɨu, te càchí‑gá: —Sa ní quide‑í nàcuáa cachí ñáyiu sá ǐo càhnu cuu‑í. Te cada tucu‑í cuèndá cada càhnu ñaha‑gá‑yu xii‑í —càchí Yǎ Ndiǒxí xáhaⁿ‑gǎ xii Déhe‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Te nchaa ñáyiu xǐndecu ní tecú dóho‑yu ní cáháⁿ‑gá, dico ñá túú ní sàni iní‑yu sá méé‑gǎ ní cáháⁿ, chi davá‑yu ní xítnàhá‑yu sá ñǔhu ní cáháⁿ, te davá‑yu ní xítnàhá‑yu sá ɨ̀ɨⁿ espíritú xínú cuèchi núú Yǎ Ndiǒxí ní cáháⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Te ní xáhaⁿ Jèsús xií‑yu: —Ñá dɨ́ú cuèndá yúhú ní cǎháⁿ Yǎ Ndiǒxí, chi ní cáháⁿ‑gá cuèndá sá nchòhó cundedóho‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Te vitna ní sáá nduu càda ndáá Yǎ Ndiǒxí cuéchi nchaa ñáyiu ñuyíú‑a, te ducaⁿ te vá cúnùu‑gá yucu ñǎvǎha. ");
INSERT INTO milNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Te na càta caa ñaha‑güedé xii‑í núú cùrúxí, te xíáⁿ cuú‑í te níhǐ‑yu tnúhu nɨ càa xico ñuyíú, te quɨndáá iní‑yu tnúhu‑í —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Duha ní cáháⁿ‑gá cuèndá cutnùní iní‑yu nàcuáa ndoho‑gá òré cuú‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Te ní xáhǎⁿ‑yu xii‑gá: —Nìhí‑ndɨ́ tnúhu sá nǔú tùtú yódó tnùní tnúhu Yá Ndiǒxí càháⁿ‑xi sá Crìstú Yaá tendaha‑gǎ quixi ñuyíú‑a cundecu‑gá nɨ caa nɨ quɨ́hɨ́ⁿ. ¿Te yòhó nása càháⁿ‑tu‑n sǎ ɨ̀ɨⁿ tée cùu ñaní tnáhá nchàa ñáyiu ñuyíú‑a cahni ñaha‑güedě núú cùrúxí? Te cachí tnúhu‑n nǎ cúú těe‑áⁿ —càchí‑yu xǎhǎⁿ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Te ní xáhaⁿ Jèsús: —Yúhú cúù‑í dàtná ɨɨⁿ ñuhú dáyèhé ñuyíú‑a, dico sacú‑ni nduu ndècu ndɨhɨ ñaha‑í xii‑ndo. Te caca‑ndo ìchi ndáá vitna dàyehé‑gá‑í núú‑ndó chi na cùnee te vá cútnùní‑gá núú‑ndó ndèé ichi quɨ́hɨ́ⁿ‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Quɨndáá iní ñáhá‑ndó xìi‑í vitna ndècu ndɨhɨ ñaha‑gá‑í xii‑ndo dàndixi túu‑í iní‑ndó, cuèndá cutnùní iní‑ndó nàcuáa ndùu cuendá Yǎ Ndiǒxí, te cuu‑ndo děhe‑í —càchí‑gá xáhaⁿ‑gǎ xií‑yu. Te sátá dúcáⁿ nǐ cáháⁿ Jèsús, te ní quee‑gá cuáháⁿ‑gá ɨɨⁿ núú vǎ ná nìhí ñáhǎ‑yu xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Te cuěi ío vài sá vǎ yǒo tnàhí ndàcu cada ní quide Jèsús ní xiní‑yu, dico ni dùcaⁿ ñá túú ní sàndáá iní‑yu‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Te ducaⁿ nǐ quidé‑yu chi dacuɨtɨ́í nǐ quee ndáá‑xi nàcuáa ní chídó tnùní ndíi Chàiá ndíi ní cáháⁿ tnúhu Yá Ndiǒxí ndéé sanaha nǔú tùtú‑gá núú càchí‑xi: Yòhó Yaá cúú Xǐtohó‑í, vá yǒo ɨɨⁿ sàndáá iní tnúhu càháⁿ‑ndɨ́. Te vá yǒo ɨɨⁿ cùtnuní iní‑xi sá ǐo càhnu cuu‑n. Duha ní chídó tnùní ndíi Chàiá núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Te ñá ní sàndáá iní‑yu chi ní quee ndáá‑xi nàcuáa ní chídó tnùní tucu ndíi Chàiá núú tùtú Yǎ Ndiǒxí nàcuáa cáháⁿ Jèsús: ");
INSERT INTO milNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Mee Yǎ Ndiǒxí ní quide‑gá sá vǎ tècú tnùní‑yu, chi ní dádǎhu ndodo iní ñáhá‑gǎ xií‑yu, chi ío sàá iní‑yu núu ñá ní cuìní‑gá‑yu quɨndáá iní ñáhǎ‑yu xii‑gá. Te ni vǎ túhá ñàhá‑yu xii yúhú cuèndá dacǎcu nihnu‑í‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Duha ní chídó tnùní ndíi Chàiá nàcuáa cáháⁿ Jèsús chi ní xiní ndíi sá ǐo càhnu cuu‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Te cuěi ducaⁿ nǐ cuu dico tɨtnɨ́ cue tée cùnuu núú ñǎyiu isràél ní sándáá iní ñáhá‑güedě xii‑gá. Dico ñá túú ní xǒo cáháⁿ ndáá‑güedé chi ní xóo yùhú‑güedé sá vǎ dáñá‑gǎ cue tée cùu fariséú quɨ́hu‑güedé veñúhu. ");
INSERT INTO milNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Chi ní xóo cudɨ́ɨ́‑gǎ iní‑güedé sá càháⁿ ñáyiu dàcúúxí tnǔhu càháⁿ Yǎ Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jèsús níhi ní cáháⁿ‑gá, te càchí‑gá: —Nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í, te ñá dɨ́ú‑ní mèe‑í quɨ́ndáá iní‑yu, chi tnàhá Tǎtà‑í Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a quɨndáá iní‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Te ñáyiu xìní ñáhá xìi yúhú xìní‑yu tnàhá Tǎtà‑í. ");
INSERT INTO milNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Te yúhú véxi‑í dandìxi túu‑í iní ñáyiu ñuyíú‑a cuèndá cutnùní iní‑yu nàcuáa ndùu cuendá Yǎ Ndiǒxí, te nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í te vá cúndècu‑gá‑yu ichi cuèhé ichi duha. ");
INSERT INTO milNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Te núu ìó davá‑yu ndèdóho‑yu nàcuáa càháⁿ‑í te ñá túú tnɨ̀ɨ́‑yu tnúhu‑í, te ñá dɨ́ú yǔhú dàcuíta nihnu‑í‑yu, chi ñá túú věxi‑í ñuyíú‑a sá dácuǐta nihnu‑í‑yu, chi véxi‑í sá dácǎcu nihnu‑í‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Te nchaa ñáyiu na cùyíchí iní ñáhá xìi‑í te ñá túú quìde cuendá‑yu nàcuáa càháⁿ‑í, te ñáyiu‑áⁿ ná sàá nduu te cuíta nihnú‑yu chi ñá ní tnɨ̀ɨ́‑yu tnúhu ní cáháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Te yúhú ñá túú càháⁿ‑í tnúhu véxi iní méè‑í, chi mee Tǎtà‑í Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a ní cachí tnúhu‑gá nàcuáa cunduu tnúhu cáháⁿ‑í danèhé‑í ñáyiu. ");
INSERT INTO milNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Te yúhú xìní‑í sá tnǔhu ní táúchíúⁿ Tǎtà‑í cáháⁿ‑í cúú‑xí ɨ̀ɨⁿ sá vǎha sá cúú xìi‑ndo chi nduu táhú‑ndó cùndecu‑ndo ndɨhɨ‑gá nɨ caa nɨ quɨ́hɨ́ⁿ, núu xíǎⁿ càháⁿ‑í nchaa nàcuáa ní táúchíúⁿ‑gǎ —càchí‑gá xáhaⁿ‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Te cùmání‑gǎ tnahá vico pàscuá, te Jèsús sa nàha‑gá sá sà ní cuyatni òré dàndóo‑gá ñuyíú‑a, te ndaa‑gá núú ndécú Tǎtá‑gǎ. Te ío ní cuu iní‑gá nchaa ñáyiu ní sándáá iní ñáhá xìi‑gá, te ní quide ndisa‑gá sá nǐ cuu iní ñáhá‑gǎ xií‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Te ní quɨ́hu yucu ñǎvǎha dɨ́quɨ́ tě Jùdás déhe té Xǐmú Iscàrioté, te ní sani iní‑dé nàcuáa cada‑dé cuáha cuèndá‑dé Jèsús núú cuè tée cùu úhú iní ñáhá xìi‑gá. Te Jèsús sa nàha‑gá sá méé Yǎ Ndiǒxí Yaá cúú Tǎtá‑gǎ ní sáñaha‑gǎ tnúhu ndee ìní xii‑gá sá cádá‑gǎ núú‑gǎ, te nàha‑gá sá dɨ́ú nǔú Tǎtá‑gǎ ní quee‑gá véxi‑gá ñuyíú‑a. Te sáá nduu nàsáá tucu‑gá núú Tǎtá‑gǎ. Te cùdini Jesús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá ní cùu, te ní ndacuɨ́ñɨ́‑gá yuhu mèsá, te ní taunuu‑gá ɨɨⁿ dóó níhnú‑gǎ, te ní queheⁿ‑gá ɨɨⁿ dóó nǐ dácútú‑gǎ núú yɨ́quɨ́‑gǎ. ");
INSERT INTO milNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Te ní chihi‑gá ndute ɨɨⁿ tǐná, te xíáⁿ nǐ naquete‑gá sáhá cuè tée xìca cuu ndɨhɨ‑gá, te ndɨhɨ dóó ndútú nǔú yɨ́quɨ́‑gǎ‑áⁿ nǐ nadayìchí‑gá sáhá‑güedě. ");
INSERT INTO milNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Te òré naquete‑gá sáhá tě Xǐmú, àdi Pelú, ní cùu ní xáhaⁿ‑dě xii‑gá: —Mèstrú, ¿te yòhó naquete‑n sǎhà‑í‑u? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Te ní xáhaⁿ Jèsús: —Vitna ñá cútnùní iní‑n sǎ quídè‑í‑a dico sáá nduu te cutnùní iní‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Te ní xáhaⁿ tě Pèlú: —Yúhú chi vá ɨ́ɨ́ⁿ ndùu te naquete‑n sǎhà‑í —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te ní xáhaⁿ Jèsús: —Te núu vá náquète‑í sáhá‑n áⁿ, te vá cádá‑gǎ‑n cuèndá sá ndécú ndɨ̀hɨ ñaha‑í xii‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Te ní xáhaⁿ tě Pèlú: —Te núu ducaⁿ te vá méé‑ní sǎhà‑í naquete‑n, chi naquete‑n tnàhá ndaha‑í ndɨhɨ dɨ́quɨ̀‑í —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Te ní xáhaⁿ Jèsús xii‑dé: —Tée íchí nǐ xichi chi xìni ñuhu‑xi sá sǎhá‑na‑dě ndoo, te ducaⁿ te nduu ndoo‑dé nɨhìí‑dé. Te nchòhó sa càndoo‑ndo cuéi ñá ncháá‑ndó càndoo —cachí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Te ducaⁿ nǐ cáháⁿ Jèsús chi sa nàha‑gá sá ɨ́ɨ́ⁿ cuè tée‑áⁿ cuǎha cuèndá ñáhá‑güedě xii‑gá núú cuè tée cùu úhú iní ñáhá, xíǎⁿ nǔu ní xáhaⁿ‑gǎ sá ñà túú càndoo‑güedé nchaa‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Te sátá nǐ naquete‑gá sáhá‑güedě, te ní ndécuǐhnu‑gá dóó‑gǎ, te ní nucóo‑gá yuhu mèsá, te ní xáhaⁿ‑gǎ xii‑güedé: —¿Te ní cutnùní iní‑ndó sǎ nǐ quide ñaha‑ǐ xii‑ndo‑ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Te nchòhó váha‑ni càháⁿ‑ndó sǎ cúnùu‑í, te dànani ñaha tucu‑ndo Mestrú xii‑í, te ndáá càháⁿ‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Te núu yúhú cúù‑í Mèstrú, te cùu tucu‑í tée cùnuu te nàquete‑í sáhá‑ndó, te dɨu‑ni ducaⁿ càda nchohó tucu naquete sáhá tnáhá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yúhú sànu ichi ñaha‑í xii‑ndo nàcuáa cada‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nì ɨɨⁿ tée xìnu cuechi ñá túú cùnuu‑dé dàcúúxí pàtróóⁿ‑dě, te ni ɨ̀ɨⁿ tée xìca chiuⁿ ñá túú cùnuu‑dé dàcúúxí těe tèndaha ñaha xii‑dé cuáháⁿ‑dé chìuⁿ. Te ducaⁿ sǎtnahá‑xi cùu yúhú ndɨhɨ nchòhó. ");
INSERT INTO milNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Te núu ní cutnùní iní‑ndó nàcuáa ní quide ñaha‑ǐ xii‑ndo ña, te ducaⁿ càda tnaha‑ndo te cuu váha iní ñáhá Yǎ Ndiǒxí xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Yúhú, ñá túú càháⁿ‑í cuèndá‑ndó nchàa‑ndo, chi yúhú sa nàha‑í nàcuáa sàni iní ɨɨⁿ ɨɨⁿ nchòhó cue tée ní nanducu nìhnu‑í tnuú nchaa ñáyiu ñùhu ichi cuehé ichi duha ní cachí‑í chitnahá ñáhá‑ndó xìi‑í. Chi dacuɨtɨ́í sǎ quéé ndǎá‑xi nàcuáa càháⁿ‑xi núú tùtú Yǎ Ndiǒxí núú càchí‑xi: “Tée xèxi ndɨhɨ ñaha xii‑í ngóo‑dé cuu úhú iní ñáhá‑dě”, duha càchí‑xi núú tùtú‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Te cùmání‑gǎ sáá nduu càda ñaha‑dé sá sání ìní‑dé, núu xíǎⁿ càchí tnúhu‑í xii‑ndo nàcuáa cada‑dé, chi na sàá nduu‑ǎⁿ te cutnùní iní‑ndó sǎ yǔhú cúù‑í Crìstú Yaá ní tendaha Yǎ Ndiǒxí véxi ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nchàa ñáyiu na quèheⁿ cuendá ñáhá xìi cue tée tendaha‑ǐ cáháⁿ tnúhu‑í, te cada iní‑yu sá tnàhá yúhú ní queheⁿ cuèndá‑yu. Te nchaa ñáyiu na quèheⁿ cuendá ñáhá xìi‑í, te cada iní‑yu sá tnàhá Tǎtà‑í Dútú Ndiǒxí Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a ní queheⁿ cuèndá‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Te sátá dúcáⁿ nǐ cáháⁿ Jèsús te ío ní ndɨ́hú iní‑gá, te ní xáhaⁿ‑gǎ xii‑güedé: —Na càchí tnúhu ndáá‑í xii‑ndo sǎ dɨ́ú‑ní ɨ̀ɨⁿ nchohó cuáha cuèndá ñáhá‑ndó xìi‑í núú cuè tée cùu úhú iní ñáhá —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Te ní ngüíta cue tée xìca cuu ndɨhɨ‑gá ndéhé ɨ̀ɨⁿ ndehe ɨɨⁿ núú tnáhá‑güedě, chi ñá ní cùtnuní iní‑güedé ndědacàa‑güedé cuèndá‑güedé ní cáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Te ɨɨⁿ tée‑áⁿ ǐo cùdɨ́ɨ́ ìní ñáhá Jèsús, te ndècu yatni‑dé dɨ̀ñɨ‑gá cúdìni‑dé ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Te té Xǐmú, àdi Pelú chi úú dɨ̀u‑dé, ní quide‑dé sèñá núú těe ndècu yatni dɨñɨ‑gá‑áⁿ sá càcáⁿ tnúhú‑dě núú‑gǎ nǔu ndědacàa‑güedé cuèndá‑güedé ní cáháⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Te tée‑ǎⁿ ní sáháⁿ ndehe yatni‑gá‑dé dɨ̀ñɨ Jesús, te ní xáhaⁿ‑dě xii‑gá: —Mèstrú, ¿ndědacàa‑ndɨ́ cuèndá‑ndɨ́ ní cáháⁿ‑n‑i? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Te ní xáhaⁿ Jèsús: —Na chìndóyo‑í luha pàá, te tée na cuǎha‑í te tée‑áⁿ cúú‑dě —càchí‑gá xáhaⁿ‑gǎ xii‑dé. Te ní chindóyo‑gá luha pàá, te ní sáha‑gá té Jùdás déhe té Xǐmú Iscàrioté. ");
INSERT INTO milNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Te òré ní queheⁿ‑dé pàá, te ní ngúndecu ndɨhɨ ñaha dùuⁿ‑ná yucu ñǎvǎha xii‑dé. Te ní xáhaⁿ Jèsús: —Sá nǐ sani iní‑n càda‑n te cada ndɨ̌hɨ‑ni‑n —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Te ni ɨ̀ɨⁿ cue tée cùdini ndɨhɨ‑gá ñá ní tècú tnùní‑güedé nása ndùu tnúhu ní xáhaⁿ‑gǎ xii té Jùdás. ");
INSERT INTO milNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Te dava‑güedé ní sani iní‑güedé sá sǎ cuèndá sá ndécú ndɨ̀hɨ‑dé sá ñúhú dǐhúⁿ, te váa ìó ɨɨⁿ sá cuááⁿ‑dě nàndɨ́hɨ‑güedé vico, àdi díhúⁿ cuǎha‑dé ñáyiu ndàhú xáhaⁿ‑gǎ ní cáháⁿ‑güedě. ");
INSERT INTO milNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Te sa ní cundɨquɨⁿ ní queheⁿ cuèndá té Jùdás pàá caxi‑dé, te òré ní níhí‑dě pàá‑áⁿ te ní quee‑dé cuáháⁿ‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Te sátá nǐ quee té Jùdás cuáháⁿ‑dé, te ní xáhaⁿ Jèsús xii dava‑gá‑güedé: —Vitna te quiní‑ndó ndɨ̀hɨ nchaa ñáyiu sá ǐo càhnu cuu yúhú Tée cùu ñaní tnáhá‑ndó nchàa‑ndo, te òré‑áⁿ cutnùní iní‑ndó sǎ ǐo càhnu cuu tucu mee Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Te núu yúhú quídé càhnu‑í Yǎ Ndiǒxí, te dɨu‑ni ducaⁿ càda cahnu ñaha‑gá xii yúhú, te ñá túú‑gǎ tɨtnɨ́ nduu te ducaⁿ càda‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Te nchòhó cue déhe‑í na càchí tnúhu‑í sá sàcú duha‑ná nduu ndècu ndɨhɨ ñaha‑í xii‑ndo. Te nchòhó nanducu ñàha‑ndo xii‑í dico vá ná nìhí ñáhá‑ndó dàtná ní xáhaⁿ‑ǐ xii ñáyiu isràél, te dɨu‑ni ducaⁿ càháⁿ‑í núú‑ndó sǎ vǎ ndácú‑ndó quɨ̌hɨ́ⁿ‑ndó nǔú quɨ̀hɨ́ⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Te duha sànu ichi ñaha tucu‑í xii‑ndo nàcuáa cada‑ndo sǎ cúú ìní tnáhá‑ndó ɨ̀ɨⁿ ɨɨⁿ‑ndo datná yúhú cúú ìní ñáhà‑í xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Te núu na cùu iní tnáhá‑ndó ɨ̀ɨⁿ ɨɨⁿ‑ndo ña, te ducaⁿ te cutnùní iní nchaa ñáyiu sá cúú‑ndó cuè tée ní chitnahá ñáhá xìi‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Te ní xáhaⁿ tě Xǐmú, àdi Pelú chi úú dɨ̀u‑dé, xii Jèsús: —Mèstrú, ¿ndèé quɨ́hɨ́ⁿ‑n‑í? —càchí‑dé xǎhaⁿ‑dě xii‑gá. Te ní xáhaⁿ Jèsús: —Vitna te vá ndácú‑n cànchicúⁿ ñáhá‑n quɨ̌hɨ́ⁿ núú quɨ̀hɨ́ⁿ‑í, dico na sàá nduu te dai sáá‑n nǔú cúndècu‑í —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Te ní xáhaⁿ tě Pèlú xii‑gá: —Mèstrú, ¿te ná cuèndá nǔu vá ndácù‑í canchicúⁿ ñáhà‑í xii‑n quɨ̌hɨ́ⁿ vitna‑i? Chi yúhú ñá túú tnàhí yùhú‑í cuěi na cùú‑í sá cuèndá‑n —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Te ní xáhaⁿ Jèsús: —¿Te ndáá sá xèhndé iní‑n sǎ cuěi na cùú‑n cuèndá‑í‑u? Te na càchí tnúhu ndáá‑í xii‑n sǎ cùmání‑gǎ cana lǐhi, te úní xito cáháⁿ‑n sǎ ñà túú xìní ñáhá‑n xìi‑í —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Te ní xáhaⁿ‑gǎ xii‑güedé: —Te ñá túú nǎ cani iní‑ndó. Quɨ̀ndáá iní‑ndó Yǎ Ndiǒxí, te quɨndáá iní‑ndó yǔhú. ");
INSERT INTO milNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Chi núú ndécú Tǎtà‑í ío nùne núú cúndècu‑o, chi núu ñáhá ñá te sa cachí tnúhu‑í xii‑ndo ni cùu. Te vitna na nùhú‑í te cada túha‑í núú cúndècu‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Te dǎtnùní quixi tucu‑í te candeca ñaha‑ǐ xii‑ndo quɨ̌hɨ́ⁿ cuèndá ɨɨⁿ‑ni xìchi cundecu‑o. ");
INSERT INTO milNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Te sa nàha‑ndo ndéé quɨ́hɨ́ⁿ‑í te sa xìní‑ndó ìchi —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Te ní xáhaⁿ tě Mǎxí xii‑gá: —Mèstrú, ñá túú xìní‑ndɨ́ ndèé quɨ́hɨ́ⁿ‑n te da ichi‑ná quiní‑ndɨ́ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Te ní xáhaⁿ Jèsús: —Yúhú cúù‑í dàtná ɨɨⁿ ichi te càháⁿ‑í tnúhu ndáá, te yúhú cada‑í te naníhí tàhú‑ndó. Te ɨɨⁿ dìi díí‑ni yúhú cada‑í te sáá‑ndó nǔú Yǎ Ndiǒxí cundecu‑ndo te núu na quɨ̀ndáá iní ñáhá‑ndó xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Te núu dìcó cútnùní ndisa iní‑ndó yòo cuu‑í‑áⁿ, ducaⁿ te cutnùní iní‑ndó yòo cuu Tátà‑í ní cùu. Dico vitna dàtná sá nǐ xiní núú‑ndó Dǔtú Ndiǒxí Yaá cúú Tǎtà‑í cada iní‑ndó, chi ní xiní‑ndó yǔhú —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Te ní xáhaⁿ tě Lìpé xii‑gá: —Mèstrú, danèhé ñáhá xìi‑ndɨ́ Dútú Ndiǒxí chi na cùu váha iní‑ndɨ́ —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Te ní xáhaⁿ Jèsús xii‑dé: —Lìpé, ¿te náa ñá túú xìní ñáhá‑n xìi‑í? Te sa ní cuu vài nduu ndecu ndɨhɨ ñaha‑í xii‑ndo, chi ñáyiu xìní ñáhá xìi‑í te xìní‑yu tnàhá Tǎtà‑í. ¿Te ná cuèndá yòhó càchí‑n sǎ dánèhé ñáhà‑í xii‑ndo Tǎtà‑í? ");
INSERT INTO milNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Náa ñá túú sàndáá iní‑ndó sǎ yǔhú ndécù‑í ndɨhɨ Tǎtà‑í? Te mee‑gǎ ndécú ndɨ̀hɨ ñaha‑gá xii‑í. Te nchaa tnúhu càháⁿ‑í núú‑ndó ñà túú càháⁿ‑í sá věxi iní méè‑í, chi Tǎtà‑í Yaá ndécú ndɨ̀hɨ ñaha xii‑í chíndèe ñaha‑gá quídè‑í chìuⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Te quɨndáá iní‑ndó sǎ yǔhú ndécù‑í ndɨhɨ Tǎtà‑í, te ducaⁿ mèe‑gá ndécú ndɨ̀hɨ ñaha‑gá xii‑í. Te núu ñá túú sàndáá iní‑ndó tnǔhu càháⁿ‑í‑a, te dandàcu iní‑ndó nchàa chiuⁿ ta quide‑í véxi, te quɨndáá iní ñáhá‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nchàa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í, te cadá‑yu chìuⁿ quide‑í te càhnu‑gá chìuⁿ cadá‑yu chi yúhú núhú‑í núú ndécú Tǎtà‑í cundecu‑í nàcuáa níhí ndéé‑gǎ‑yu cundecú‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Te nchaa sá ná càcáⁿ‑ndó te taxi‑í te núu na quɨ̀ndáá iní ñáhá‑ndó xìi‑í, te nchaa cada‑í cuèndá cutnùní iní ñáyiu sá ǐo càhnu cuu Tátà‑í Dútú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Te yúhú cada‑í nchaa sá cuìní‑ndó càcáⁿ táhú‑ndó nǔù‑í, te núu na quɨ̀ndáá iní ñáhá ndìsa‑ndo xii‑í. ");
INSERT INTO milNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Te núu nchòhó cúú ìní ñáhá‑ndó xìi‑í te tnɨɨ‑ndo nchàa tnúhu càháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Te yúhú cacáⁿ táhù‑í núú Tǎtà‑í sá téndàha‑gá Espíritú‑gá quixi cundecu ndɨhɨ‑ndo cànu ichi ñaha‑xi xii‑ndo nacuáa cundecu‑ndo, te chindee ñàha‑xi xii‑ndo nɨ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Te nchaa ñáyiu ndècu ichi cuehé ichi duha ñá túú xìní‑yu Espíritú Yǎ Ndiǒxí te ni vǎ cúú cùndecu ndɨhɨ́‑yu. Dico nchòhó sa xìní‑ndó Espíritú‑gá te ndècu ndɨhɨ ñaha‑xi xii‑ndo. Te sáá ɨɨⁿ nduu te cunuu Espíritú‑gá iní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Te yúhú vá dáñá nìhnu ñaha‑í xii‑ndo, chi quixi tucu‑í cundecu ndɨhɨ ñaha‑ǐ xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Te sácú duha‑ná nduu ndècu‑í te vá quìní ñáhá‑gǎ ñáyiu xii‑í, dico nchòhó chi quiní ñáhá‑ní‑ndó xìi‑í. Te ducaⁿ‑ni cùndecu‑ndo ichi váha chi cundecu ndɨhɨ ñaha‑ǐ xii‑ndo nɨ̀ caa nɨ quɨ́hɨ́ⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Te dàvá‑áⁿ cutnùní iní‑ndó sǎ ndécù‑í ndɨhɨ Tǎtà‑í, te ducaⁿ nchòhó cundecu ndɨhɨ ñaha‑ni‑ndo xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Te nchaa ñáyiu dàcuaha tnúhu‑í te tnɨ̀ɨ́‑yu, ñáyiu‑áⁿ quídé ndìsá‑yu sá cúú ìní ñáhǎ‑yu xii‑í. Te ducaⁿ Tǎtà‑í cúú ìní ñáhá‑gǎ xií‑yu, te ducaⁿ‑ni yǔhú cúú ìní‑í‑yu tucu, te ducaⁿ te cùtnuní iní‑yu sá ndécú ndɨ̀hɨ‑í‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Te ní cáháⁿ ɨɨⁿ tée nàni Judás dico ñá dɨ́ú tě Jùdás déhe té Xǐmú Iscàrioté ní cǎháⁿ, chi ɨngá té Jùdás ní xáhaⁿ‑dě xii‑gá: —Mèstrú, ¿nása cada‑n cuèndá cutnùní iní‑ndɨ́ sá cúndècu ndɨhɨ ñaha‑n xii‑ndɨ́, te ñáyiu ñùhu ichi cuehé ichi duha vá cúndècu ndɨhɨ́‑n‑yu‑i? —càchí‑dé xǎhaⁿ‑dě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Te ní xáhaⁿ Jèsús xii‑güedé: —Nchaa ñáyiu cùu iní ñáhá xìi‑í te tnɨ̀ɨ́‑yu tnúhu càháⁿ‑í, te ñáyiu‑áⁿ cúú ìní ñáhá Tǎtà‑í xií‑yu, te yúhú ndɨhɨ Tǎtà‑í ndécú‑ndɨ̌ ndɨhɨ́‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Te nchaa ñáyiu ñá túú cùu iní ñáhá xìi‑í te ñá túú tnɨ̀ɨ́‑yu tnúhu càháⁿ‑í. Te nchaa tnúhu ní cáháⁿ‑í ní xíndèdóho‑ndo chi Tǎtà‑í Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a ní dácáhú ìní ñáhá‑gǎ xii‑í, te ñá dɨ́ú mèe‑í ní càhu iní‑í tnúhu cáháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Duha ndùu tnúhu càháⁿ‑í núú‑ndó vìtna ndecu ndɨhɨ ñaha‑gá‑í xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dico Yá Ndiǒxí tendaha‑gǎ Espíritú‑gá quixi‑xi cada‑xi núù‑í taxi‑xi tnúhu ndee ìní xii‑ndo, te dɨu‑xi chindee ñàha‑xi xii‑ndo te danèhé ñáhá‑xí xìi‑ndo nchaa sá cúmǎní quiní‑ndó, te dɨu‑ni‑xi dandàcu iní ñáhá‑xí xìi‑ndo nchaa nacuáa ní cáháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Te yúhú chindee chìtuu ñaha‑í xii‑ndo ǐo váha cuu iní‑ndó cùndecu‑ndo datná yúhú ío váha cùu iní‑í ndécù‑í, chi sa ta cùyatni nduu núhú‑í. Te yúhú càchí tnúhu ndáá‑í sá chíndèe ñaha‑í xii‑ndo, te vá cádà‑í dàtná quídé ñǎyiu ñùhu ichi cuehé ichi duha. Te ni vǎ ndɨ̀hú iní‑ndó, te ni vǎ yùhú‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Te sa ní xíndèdóho‑ndo nǐ cáháⁿ‑í sá nùhú‑í, te quixi tucu‑í cundecu ndɨhɨ ñaha‑ǐ xii‑ndo. Te núu ndisa cùu iní ñáhá‑ndó xìi‑í ñá, te òré ní níhí‑ndó tnǔhu sá nùhú‑í núú ndécú Tǎtà‑í, te cudɨ́ɨ́ ìní‑ndó ní cùu, chi ío càhnu cuu‑gá dàcúúxí yǔhú. ");
INSERT INTO milNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Te sa ní cachí tnúhu‑í sá nùhú‑í, te na sàá òré núhú‑í núú ndécú Tǎtà‑í, te quɨndáá iní ñáhá‑ndó xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Te ñá túú‑gǎ vài tnúhu ndatnúhu ndɨhɨ ñaha‑ǐ xii‑ndo chi sa véxi yucu ñǎvǎha sá táxí tnùní ñuyíú‑a, dico vá táxí tnùní ñáhá‑xí xìi yúhú. ");
INSERT INTO milNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Te cada‑í nchaa nàcuáa ní táúchíúⁿ Tǎtà‑í cuèndá cutnùní iní nchaa ñáyiu ñuyíú‑a sá yǔhú ío cùu iní‑í‑gá. Te vitna chí ndácuɨ̌ñɨ́ ná quɨ̀hɨ́ⁿ‑ó —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Te ní xáhaⁿ tùcu‑gá xii‑güedé: —Yúhú cúù‑í dàtná yoho yàha stilé, te Tǎtà‑í cúú‑gǎ dàtná ɨɨⁿ tée xìto yoho yaha stilé‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Te nchaa ñáyiu ní sándáá iní ñáhá xìi‑í cúǔ‑yu dàtná dité nchaa yoho yàha stilé‑áⁿ. Te tée xìto yoho yaha stilé‑áⁿ xèhndé‑dé nchaa dité‑xi sá ñǎ cuìní‑gá‑xi cuuⁿ ndéhé‑xi, te ndàda ndoo‑dé nchaa dité‑xi sá cúúⁿ cuèndá cuuⁿ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Te ducaⁿ sǎtnahá‑xi cùu nchohó, chi sa ní xócuɨ̀ñɨ́ nchaa sá cuèhé sá dúhá ndècu ndɨhɨ‑ndo, chi ní sándáá iní‑ndó tnǔhu ní cáháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Te cuu ɨɨⁿnuu‑ndo cùndecu ndɨhɨ ñaha‑ndo xii‑í, te núu ducaⁿ na càda‑ndo, te cundecu ndɨhɨ ñaha‑ǐ xii‑ndo. Chi núu ɨɨⁿ yutnu vǐdí ná quéndèé dité‑xi, te dité‑xi sá nǐ quendeé‑áⁿ vǎ cúúⁿ‑gǎ sávìdí‑xi chi duuⁿ duuⁿ ní xíta‑xi. Ducaⁿ sǎtnahá‑xi cùu nchohó chi vá ndácú‑ndó càda‑ndo chiuⁿ‑í, te núu vá cúndècu ndɨhɨ ñaha‑í xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Chi yúhú cúù‑í dàtná yutnu vǐdí‑áⁿ, te nchòhó cúú‑ndó dàtná nchaa dité‑xi. Te nchaa ñáyiu cùu ɨɨⁿnuu ndɨhɨ ñaha xii‑í, te ndècu ndɨhɨ‑í‑yu, te ndàcú‑yu quìdé‑yu chìuⁿ‑í. Te núu vá cúú ɨ̀ɨⁿnuu ndɨhɨ ñahá‑yu xii‑í, te vá ndácǔ‑yu cadá‑yu chìuⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Te nchaa ñáyiu vá cúú ɨ̀ɨⁿnuu ndɨhɨ ñaha xii‑í, te yáha‑yu dàtná yǎha ɨɨⁿ dité yutnu vǐdí sá ñà túú cùuⁿ sávìdí‑xi, chi xèhndé‑güedé yìchí‑xi, te sàhmi‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Cuu ɨɨⁿnuu ndɨ̀hɨ ñaha‑ndo xii‑í, te vá nácuànaa‑ndo nacuáa ní cáháⁿ‑í. Te núu ducaⁿ na càda‑ndo, te náni cuìní‑ndó cǎcáⁿ‑ndó nǔù‑í te taxi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Te núu nchòhó ná cádá vǎha‑ndo cùndecu‑ndo, te ío cada càhnu‑ndo Tátà‑í, te ducaⁿ cùtnuní sá ndísá cùu‑ndo cue tée ní chitnahá ñáhá xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Te yúhú ío cùu iní ñáhà‑í xii‑ndo dàtná cúú ìní ñáhá Yǎ Ndiǒxí xii‑í. Te cada‑ni‑ndo mèe‑ni sá vǎha cuèndá cudɨ́ɨ́ ìní ñáhá‑gǎ‑í xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Te núu na quɨ̀ndáá iní‑ndó càda‑ndo nchaa nacuáa ní cáháⁿ‑í, te ío cuu iní ñáhà‑í xii‑ndo, chi yúhú ducaⁿ ǐo sàndáá iní‑í Tǎtà‑í quídè‑í nchaa nàcuáa ní cáháⁿ‑gá, te xíǎⁿ nǔu ío cùu iní ñáhá‑gǎ xii‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Duha càháⁿ‑í núú‑ndó cuèndá cudɨ́ɨ́ ndìsa iní‑ndó dàtná cúdɨ̌ɨ́ ìní méè‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Te duha ndùu tnúhu càháⁿ‑í cuèndá sá cúú ìní tnáhá‑ndó ɨ̀ɨⁿ ɨɨⁿ‑ndo datná cúú ìní ñáhà‑í xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Te núu ní xíhó sǎ cúú‑xí ɨ̀ɨⁿ tée ío váha tnàhá tnúhu ndɨhɨ‑o, te xíǎⁿ cutnùní iní ñáyiu sá ǐo cùu iní‑ó‑dě. ");
INSERT INTO milNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Te nchòhó cuu‑ndo cuè tée ío váha tnahá tnúhu ndɨhɨ‑í te núu na càda‑ndo nchaa nacuáa càháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Te vá cǔñaha‑gǎ‑í xii‑ndo sǎ cúú‑ndó cuè tée xìnu cuechi núù‑í, chi ni ɨ̀ɨⁿ tée xìnu cuechi ñá túú xìní‑dé ná quídé pàtróóⁿ‑dě. Te yúhú càchí‑í xii‑ndo sǎ cúú‑ndó cuè tée ío váha tnàhá tnúhu ndɨhɨ‑í, chi ní cachí tnúhu‑í nchaa nàcuáa ní cáháⁿ Tǎtà‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Te ñá dɨ́ú nchòhó ní càháⁿ ñáhá‑ndó xìi yúhú, chi yúhú ní cáháⁿ ñáhà‑í xii‑ndo. Te yúhú tauchìuⁿ‑í quɨ́hɨ́ⁿ‑ndó càda‑ndo nchaa nacuáa ní cáháⁿ‑í, chi tnúhu‑áⁿ vǎ ndɨ́hɨ́ nìhnu‑xi. Te ducaⁿ nchàa sá ná càcáⁿ‑ndó nǔú Tǎtà‑í Yǎ Ndiǒxí te taxi‑gá, te núu na quɨ̀ndáá iní ñáhá‑ndó xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Te yúhú càháⁿ‑í dóho‑ndo sǎ cúú ìní tnáhá‑ndó ɨ̀ɨⁿ ɨɨⁿ‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Te nchaa ñáyiu ndècu ichi cuehé ichi duha ñá cúú quìní ñáhǎ‑yu xii‑ndo, te sa nàha‑ndo sá dǐhna‑gá yúhú ní ngüíta‑yu ducaⁿ ñà cúú quìní ñáhǎ‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Te núu dìcó tnàhá nchòhó ndécú‑ndó ìchi cuehé ichi duha ña, te cuu iní ñáhǎ‑yu xii‑ndo dàtná cúú ìní tnáhǎ‑yu ndɨ mèé‑yu ni cùu. Te yúhú ní nanducu nìhnu ñaha‑í xii‑ndo tnùú ñáyiu ndècu ichi cuehé ichi duha, núu xíǎⁿ ío cùu úhú iní ñáhǎ‑yu xii‑ndo cuèndá sá ñà túú‑gǎ chítnàhá‑ndǒ‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Te dandàcu iní‑ndó nàcuáa ní cáháⁿ‑í sá nì ɨɨⁿ tée xìnu cuechi ñá túú cùnuu‑dé dàcúúxí pàtróóⁿ‑dě. Te yúhú cúú ǔhú iní ñáhǎ‑yu, te dɨu‑ni ducaⁿ càda ñahá‑yu xii nchòhó. Te núu dìcó ní tnɨ̀ɨ́‑yu tnúhu ní cáháⁿ‑í ñá, te dɨu‑ni ducaⁿ tnɨ̀ɨ́‑yu tnúhu cáháⁿ‑ndó nǔǔ‑yu ni cùu. ");
INSERT INTO milNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Te ducaⁿ càda ñahá‑yu xii‑ndo sǎ cuèndá‑í, chi ñá xìní‑yu Tǎtà‑í Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Te váa vá cúndècu cuéchi‑yu ni cùu, te núu ñá túú yǔhú ní cǎháⁿ‑í núǔ‑yu, te vitna vá cúú tnàhí cachí‑yu sá ñà túú cuěchi‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Chi nchaa ñáyiu cùu úhú iní ñáhá xìi‑í, te cùu úhú iní‑yu tnàhá Tǎtà‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Te váa ni ɨ̀ɨⁿ cuéchi‑yu vá cúndècu ni cuu, te núu dìcó ñá túú ní xìní‑yu nchaa sá nǐ quide‑í sá vǎ yǒo tnàhí ndàcu cada. Te cuěi ní xiní‑yu dico dai cùu úhú iní ñáhǎ‑yu xii‑í ndɨhɨ Tǎtà‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Te duha quìdé‑yu chi dacuɨtɨ́í quèe ndáá‑xi nàcuáa yòdo tnuní núú tùtú Yǎ Ndiǒxí sá dácuàhá‑yu, chi càchí‑xi sá ñà túú nǎ cuéchi‑í te cuu úhú iní ñáhǎ‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Te Espíritú Tǎtà‑í Dútú Ndiǒxí sá ndécú nǔú‑gǎ tendaha‑ǐ quixi chindee ñàha‑xi xii‑ndo, te canu ichi ñaha‑xi nàcuáa cundecu‑ndo, te Espíritú‑áⁿ cǎháⁿ ndáá‑xi cuèndá cutnùní iní nchaa ñáyiu yoo cùu‑í. ");
INSERT INTO milNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Te nchòhó tnàhá‑ndó cǎháⁿ váha‑ndo cuèndá‑í cuèndá cutnùní iní‑yu yoo cùu‑í, chi nàha‑ndo sá ndèé òré ní ngüíta‑í quídè‑í chìuⁿ Tátà‑í ní chitnahá ñáhá‑ndó xìi‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Te ní xáhaⁿ tùcu‑gá xii‑güedé: —Duha càháⁿ‑í cuèndá ná nanchòcáva iní‑ndó nǔhú‑ndó ìchi cuehé ichi duha. ");
INSERT INTO milNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chi vá dáñá‑gǎ‑güedé quɨ́hu‑ndo vèñúhu, te ni vǎ cúú‑gǎ quiní ndeé ñáhá‑güedě xii‑ndo. Te sáá ɨɨⁿ nduu te cahni ñaha‑güedě xii‑ndo, te xíǎⁿ cuu cahaⁿ‑güedě sá quídé‑güedě chìuⁿ Yá Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Te ducaⁿ càda‑güedé chi ñá túú xìní‑güedé Tǎtà‑í, te ni ñà túú xìní ñáhá‑güedě xii yúhú. ");
INSERT INTO milNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Te duha ndùu tnúhu càháⁿ‑í núú‑ndó, chi na sàá òré te ndacu iní‑ndó nchàa tnúhu sá sà ní cachí tnúhu‑í xii‑ndo nàcuáa cada ñaha‑güedě xii‑í. ’Te ñá túú ní càchí tnúhu‑í xii‑ndo nděé díhna chi ndècu ndɨhɨ ñaha‑í xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dico vitna sa ta cùyatni nduu núhú‑í núú ndécú Tǎtà‑í Yaá ní tendaha ñàha xii‑í véxi‑í ñuyíú‑a. Te ni ɨ̀ɨⁿ nchohó ñá túú xìcáⁿ tnúhú‑ndó nǔù‑í nǔu ndèé quɨ́hɨ́ⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Chi mee‑ni sǎ ndɨ̀hú iní‑ndó sǎ dúcáⁿ nǐ cáháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Te na càchí tnúhu ndáá‑í xii‑ndo sǎ vǎha‑gá sá cúú‑xí‑ndó nǔu núhú‑í, chi tendaha‑ǐ Espíritú Yǎ Ndiǒxí quixi cundecu ndɨhɨ‑ndo chìndee ñaha‑xi, chi núu vá nùhú‑í te vá quíxí Espíritú‑gá cundecu ndɨhɨ‑ndo chìndee ñaha‑xi xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Te na quìxi Espíritú‑gá te dandìxi túu‑xi iní nchaa ñáyiu ndècu ichi cuehé ichi duha sá ñà túú quìde váha‑yu. Te dacàhu iní ñáhá‑xí sǎ ndécú ɨ̀ɨⁿ ichi váha ichi ndáá. Te Espíritú‑gá‑áⁿ cada‑xi nàcuáa cutnùní iní‑yu sá Yǎ Ndiǒxí cada ndáá‑gá cuéchi‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Te ducaⁿ te cutnùní iní‑yu sá ndécú cuěchi‑yu, chi ñá túú sàndáá iní ñáhǎ‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Te ducaⁿ te cutnùní iní‑yu nàcuáa ndùu cuendá ichi váha ichi ndáá, chi yúhú núhú‑í núú ndécú Tǎtà‑í, te nchòhó vá quìní ñáhá‑gǎ‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Te ducaⁿ te cutnùní iní‑yu sá Yǎ Ndiǒxí cada ndáá‑gá cuéchi‑yu, chi sa ní cáháⁿ‑gá sá yúcú ñǎvǎha sá táxí tnùní ñuyíú‑a quɨ́hɨ́ⁿ‑xi núú ùhú núú ndàhú. ");
INSERT INTO milNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Te vài‑gá tnúhu ndècu cachí tnúhu‑í xii‑ndo, dico nchòhó chi vá cúndèe iní‑ndó cùndedóho‑ndo nchàa vitna. ");
INSERT INTO milNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Te na quìxi Espíritú Yǎ Ndiǒxí, Espíritú càháⁿ ndáá cuɨtɨ, te Espíritú‑áⁿ danèhé ñáhá‑xí nchàa tnúhu váha tnúhu ndáá. Te vá dácàhu iní ñáhá‑xí xìi‑ndo sá věxi iní méé‑xí chi dacàhu iní ñáhá‑xí nchàa sá càháⁿ Yǎ Ndiǒxí, te cachí tnúhu‑xi nchaa nàcuáa cada‑xi ndéé núú cuàháⁿ núú věxi‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Te Espíritú‑gá‑áⁿ cada càhnu ñaha‑xi xii yúhú chi ndècu ndɨhɨ‑xi tnúhu‑í, te danèhé ñáhá‑xí xìi‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Te nchaa sá ndécú ndɨ̀hɨ Tátà‑í ndécú ndɨ̀hɨ‑í tnàhá‑í, núu xíǎⁿ càchí‑í sá Espíritú‑gá danèhé ñáhá‑xí nchàa tnúhu‑í xii‑ndo. ");
INSERT INTO milNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Te ɨɨⁿ ǔú‑nǎ nduu ndècu‑í te vá quìní ñáhá‑gǎ‑ndó xìi‑í, dico núú sàcú‑ni nduu te quiní ñáhá tùcu‑ndo xii‑í, te ducaⁿ chi núhú‑í núú ndécú Tǎtà‑í —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Te sá dúcáⁿ nǐ cáháⁿ‑gá nǔu ní ngüíta ɨɨⁿ ǔú cue tée xìca cuu ndɨhɨ‑gá xǐtnàha‑güedé: —¿Nása ndùu‑tu tnúhu càháⁿ‑gá sá càchí‑gá sá ɨ̀ɨⁿ úú‑nǎ nduu ndècu‑gá te vá quìní‑gá‑ó‑gǎ, dico núú sàcú‑ni nduu te quiní tucu‑o‑gǎ‑i?, chi núhú‑gá núú ndécú Tǎtá‑gǎ —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Te xǐtnàha tucu‑güedé: —¿Nása cuáháⁿ‑tu tnúhu‑ǎⁿ sá sàcú‑ni nduu? Te ñá tècú tnùní‑ó nǎsa ndùu tnúhu càháⁿ‑gá —càchí‑güedé xǐtnàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Te Jèsús ní cutnùní iní‑gá sá cuìní‑güedé cácáⁿ tnúhú‑güedě núú‑gǎ nása ndùu tnúhu ní cáháⁿ‑gá, núu ní xáhaⁿ‑gǎ: —Cuèndá sá nǐ cachí‑í sá ɨ̀ɨⁿ úú‑nǎ nduu ndècu‑í te vá quìní ñáhá‑gǎ‑ndó xìi‑í, dico núú sàcú‑ni nduu te quiní ñáhá tùcu‑ndo xii‑í ní cachí‑í, ¿xíǎⁿ ndúcú tnǔhu núú tnáhá‑ndó‑ǎⁿ? —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Te ní xáhaⁿ tùcu‑gá: —Te na càchí tnúhu ndáá‑í xii‑ndo sǎ nchòhó ndɨ́hú víhí ìní‑ndó te ndáhyú‑ndó, dico nchaa ñáyiu ndècu ichi cuehé ichi duha chi da cudɨ́ɨ́ ìní‑yu. Dico nchòhó ñáyiu ndáhyú chi sáá nduu te nduu dɨ́ɨ́ ìní‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Chi dàtná cuìní‑ndó cùu ɨɨⁿ ñadɨhɨ́ ñaha ní tnahá nduu cacu déhe‑xi vài sani iní‑aⁿ sá quídé ǔhú ñáhá‑xí. Dico na yǎha cacu déhe‑aⁿ, te ñá túú‑gǎ ndácú ìní‑aⁿ sá nǐ quide úhú ñáhá‑xí xìi‑aⁿ chi mee‑nǎ sá cúdɨ̌ɨ́ ìní‑aⁿ déhe‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ducaⁿ sǎtnahá‑xi cùu nchohó vitna chi ndɨ̀hú iní‑ndó sǎ nùhú‑í, dico quixi tucu‑í quixi coto ñaha‑ǐ xii‑ndo, te òré‑áⁿ te cudɨ́ɨ́ ndìsa iní‑ndó, te vá yǒo ɨɨⁿ‑gá dandɨ̀hú iní ñáhá xìi‑ndo davá‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Te dàvá‑áⁿ ñà túú‑gǎ ná nducu tnǔhu‑ndo nǔù‑í. Te na càchí tnúhu ndáá‑í xii‑ndo sǎ Tǎtà‑í taxi‑gá nchaa sá ná càcáⁿ‑ndó nǔú‑gǎ nǔu na quɨ̀ndáá iní ñáhá‑ndó xìi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Te ndéé vitna vátá dúcáⁿ‑gǎ cada‑ndo càcáⁿ‑ndó. Dico cácáⁿ‑ndó nǔú‑gǎ nǔu ná cuìní‑ndó te taxi‑gá cuèndá cudɨ́ɨ́ ndìsa iní‑ndó —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Te xǎhaⁿ tùcu‑gá xii‑güedé: —Mee‑ni nǐ chidáhu ndodo‑í tnúhu ní cáháⁿ‑í núú‑ndó, dico sáá nduu te vá chídǎhu‑gá‑í tnúhu cáháⁿ‑í, chi cáháⁿ ndáá‑na‑í cuèndá Tǎtà‑í. ");
INSERT INTO milNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Te dàvá‑áⁿ cǎcáⁿ‑ndó nǔú Tǎtà‑í nǔu ná cuìní‑ndó te taxi‑gá, te núu na quɨ̀ndáá iní ñáhá‑ndó xìi yúhú Déhe‑gá. Te ñá túú‑gǎ xíní ñùhu‑xi sá yǔhú cácáⁿ‑í núú‑gǎ cuèndá‑ndó chi cácáⁿ méé‑nǎ‑ndó. ");
INSERT INTO milNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Chi mee Tǎtà‑í ío cùu iní ñáhá‑gǎ xii‑ndo cuèndá cúú ìní ñáhá‑ndó xìi‑í, te sàndáá iní‑ndó sǎ nǔú‑gǎ ní quee‑í véxi‑í. ");
INSERT INTO milNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Te yúhú ní quee‑í núú Tǎtà‑í véxi‑í ñuyíú‑a, te vitna dàndóo‑í ñuyíú‑a te núhú‑í núú ndécú‑gǎ —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Te ní xáhaⁿ cuè tée xìca cuu ndɨhɨ‑gá: —Vitna chi càháⁿ ndáá‑nǎ‑n, ñá túú‑gǎ chídǎhu‑n tnǔhu càhá‑n. ");
INSERT INTO milNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Te vitna ní xiní‑ndɨ́ sá ǐo váha cùtnuní iní‑n nchàa nacuáa cùu, te cùtnuní iní‑n nchàa nacuáa sàni iní nchaa ñáyiu. Te ñá túú xìni ñuhu‑xi nágá nducu tnǔhu‑yu núú‑n chi nchaa sa ní dátǔu‑n nǔǔ‑yu. Te xíǎⁿ nǔu sàndáá iní‑ndɨ́ sá nǔú Yǎ Ndiǒxí ní quee‑n věxi‑n —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Te ní xáhaⁿ Jèsús: —¿Te vitna sàndáá iní‑ndó‑ǎⁿ? ");
INSERT INTO milNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Vitna ní sáá nduu nǐ sáá òré sá ncháá nchòhó cuténuu‑ndo càa ɨɨⁿ caa úú cuu‑ndo, te dàndóo mee ñàha‑ndo xii‑í. Dico ñá dɨ́ú mèe dii‑í quendóo chi ndècu ndɨhɨ‑í Tǎtà‑í. ");
INSERT INTO milNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Duha càháⁿ‑í cuèndá cuu váha iní‑ndó cùndecu‑ndo, chi ñuyíú‑a cuu úhú iní ñáhǎ‑yu xii‑ndo, dico ni vǎ yùhú‑ndó chi yúhú sa ní dáquéé tɨ̌hù‑í nchaa sá cuèhé sá dúhá ìó ñuyíú‑a —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Te sátá dúcáⁿ nǐ cáháⁿ Jèsús te ní ndacoto‑gá andɨu, te ní xáhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí: —Táu, vitna ní sáá nduu càda cahnu ñaha‑n xii‑í cuèndá ducaⁿ càda cahnu ñaha‑í xii‑n. ");
INSERT INTO milNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Chi mee‑n nǐ cachí‑n sǎ táxí tnùní‑í nchaa ñáyiu ñuyíú‑a, te dàcacu nihnu‑í nchaa ñáyiu ní cachí‑n nàníhí tàhú. ");
INSERT INTO milNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Te cundecu ndɨhɨ‑ǒ‑yu nɨ caa nɨ quɨ́hɨ́ⁿ, chi sàndáá iní ñáhǎ‑yu sá ɨ́ɨ́ⁿ dìi díí‑ni yòhó cúú‑n Ndiǒxí ndisa, te ducaⁿ xìní ñáhǎ‑yu xii yúhú Jesucrìstú tée ní tendaha‑n věxi ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Te yúhú ní chiñuhu ñaha‑ǐ xii‑n ñùyíú‑a, te ní xínu chìuⁿ ní cachí‑n càda‑í. ");
INSERT INTO milNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Táu, vitna na nàsáá‑í núú‑n te cada càhnu ñaha‑n xii‑í dàtná ní xóo cada càhnu ñaha‑n xii‑í ndéé cútnàhá vátá ngǎva‑gá ñuyíú. ");
INSERT INTO milNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Te nchaa ñáyiu ní nanducu nìhnu‑n tnuú nchaa ñáyiu ndècu ichi cuehé ichi duha, ní taxi cuèndá‑n‑yu, te ní xáhaⁿ‑ǐ xií‑yu yoo cùu‑n. Te cuèndá‑n cùú‑yu, te ní taxi cuèndá‑n‑yu, te ní sándáá iní‑yu tnúhu‑n. ");
INSERT INTO milNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Te vitna ní cutnùní iní‑yu sá ncháá tnǔhu ndècu ndɨhɨ‑í dɨu‑ni mee‑n nǐ taxi‑n. ");
INSERT INTO milNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Te ní dánèhé‑í‑yu nchaa tnúhu sá nǐ dánèhé ñáhá‑n xìi‑í, te ní sándáá iní‑yu. Te ní cutnùní iní‑yu sá nǔú‑n nǐ quee‑í véxi‑í, te ní sándáá iní‑yu sá yòhó ní tendaha ñàha‑n xii‑í véxi‑í ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Te yúhú càháⁿ ndàhú‑í núú‑n cuèndá nchaa ñáyiu ní taxi cuèndá‑n. Te ñá túú càháⁿ ndàhú‑í núú‑n cuèndá ñáyiu ndècu ichi cuehé ichi duha, chi cuèndá nchaa ñáyiu ní taxi cuèndá‑n càháⁿ‑í, chi cuèndá‑n cùú‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Te nchaa sá cúú cuèndá‑í cúú‑xí cuèndá‑n, te nchaa sá cúú cuèndá‑n cùu‑xi cuendá‑í tnàhá‑í. Te xǐquide càhnu ñahá‑yu xii‑í. ");
INSERT INTO milNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Te yúhú vá cúndècu‑gá‑í ñuyíú‑a, dico mèé‑yu chi cundecu‑ní‑yu, te yúhú ndixi‑í núú ndécú‑n. Táu, yòhó ío yɨñùhu ndecu‑n, te yúhú càháⁿ ndàhú‑í núú‑n sǎ nɨ́ yùhu nɨ iní‑n còto‑n nchaa ñáyiu ní taxi cuèndá‑n, ñáyiu ní sándáá iní tnúhu‑í cuèndá sá ɨ́ɨ́ⁿ‑ní ìchi cuú‑yu cundecú‑yu dàtná ɨɨⁿ‑ni cùu nchoo. ");
INSERT INTO milNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Chi òré ndécù‑í ndɨhɨ́‑yu ñuyíú‑a ní xito‑í‑yu nàcuáa cùu iní‑n, te ni ɨ̀ɨ́ⁿ‑yu ñá túú ní xǐta nihnu, chi ɨɨⁿdìi‑ni té Jùdás ní xíta nihnu tnàhí‑dé, te ducaⁿ nǐ cuu cuèndá sá nǐ quee ndáá‑xi nàcuáa yòdo tnuní núú tùtú‑n. ");
INSERT INTO milNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Te vitna sa ndixi‑í núú ndécú‑n, dico nɨni ndècu‑gá‑í ñuyíú‑a duha càháⁿ‑í cuèndá sá cúdɨ̌ɨ́ ìní‑yu dàtná cúdɨ̌ɨ́ ìní méè‑í. ");
INSERT INTO milNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Te yúhú ní dánèhé‑í‑yu tnúhu‑n, dico nchaa ñáyiu ndècu ichi cuehé ichi duha cùu úhú iní ñáhǎ‑yu xií‑yu cuèndá sá ñà túú‑gǎ ndécǔ‑yu ichi cuèhé ichi duha‑áⁿ dàtná yúhú ñá túú ndècu‑í ichi‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Te ñá túú càchí‑í sá xócàní‑n‑yu ñuyíú‑a, dico càháⁿ ndàhú‑í núú‑n sǎ dácǎcu nìhnú‑n‑yu núú yucu ñǎvǎha. ");
INSERT INTO milNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Te yúhú ñá túú ndècu‑í ichi cuèhé ichi duha, te ducaⁿ mèé‑yu ñá túú‑gǎ ndécǔ‑yu ichi cuèhé ichi duha. ");
INSERT INTO milNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Te ío na cùndecu yɨhɨ ñuhu‑gá‑yu núú‑n dàcuahá‑yu tnúhu‑n, chi cùu‑xi ɨɨⁿ tnúhu ndáá. ");
INSERT INTO milNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Te dàtná ní tendaha ñàha‑n xii yúhú véxi‑í tnuú nchaa ñáyiu ndècu ichi cuehé ichi duha, ducaⁿ càda‑í tendaha‑ǐ‑yu quɨ́hɨ́ⁿ‑yu cáháⁿ‑yu tnúhu‑í tnuú nchaa ñáyiu ndècu ichi cuehé ichi duha. ");
INSERT INTO milNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Te yúhú ndécú yɨ̀ñuhu‑í núú‑n, te cada ñaha‑n xìi‑í nàcuáa cùu iní‑n sǎ cuèndá‑yu, te ducaⁿ te cundecu yɨñùhú‑yu núú‑n dàcuahá‑yu tnúhu‑n. ");
INSERT INTO milNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Te ñá dɨ́ú cuèndá mee‑ni ñǎyiu sa ní sándáá iní‑xi càháⁿ ndàhú‑í núú‑n, chi tnàhá cuèndá nchaa ñáyiu na quɨ̀ndáá iní ñáhá xìi‑í ndéé ìdá‑gá nǔu na cùndedóho‑yu tnúhu cáháⁿ ñáyiu na tèndaha‑í. ");
INSERT INTO milNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Te xìcáⁿ táhù‑í núú‑n sǎ ncháǎ‑yu ɨɨⁿ‑nǎ ichi na cùú‑yu, te ɨɨⁿ‑nǎ cani iní ndɨhɨ ñàhá‑yu xii‑o dàtná cúú nchòo ɨɨⁿ‑ni cuu‑o. Te ducaⁿ ɨ̀ɨⁿ‑ná cuu‑o ndɨ̀hɨ́‑yu cuèndá sá ná quɨ̀ndáá iní nchaa ñáyiu ndècu ichi cuehé ichi duha sá dɨ́ú‑n nǐ tendaha ñàha‑n xii‑í véxi‑í ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Te nchaa sá vǎha ní taxi‑n ndècu ndɨhɨ‑í ní dánèhé‑í‑yu cuèndá sá ɨ́ɨ́ⁿ‑nǎ cuú‑yu cundecú‑yu dàtná ndécú nchòo. ");
INSERT INTO milNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Te yúhú cundecu ndɨhɨ‑í‑yu, te yòhó cundecu ndɨhɨ ñaha‑n xìi yúhú cuèndá ɨɨⁿ‑nǎ cuu ndisá‑yu cundecú‑yu. Te ducaⁿ te cutnùní iní nchaa ñáyiu ndècu ichi cuehé ichi duha sá dɨ́ú mèe‑n ní tendaha ñàha‑n xii‑í véxi‑í ñuyíú‑a, te cùu iní‑n‑yu dàtná cúú ìní ñáhá‑n xìi yúhú. ");
INSERT INTO milNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Táu, mee‑n nǐ taxi cuèndá‑n‑yu, te cuìní‑í sá cúndècú‑yu núú cúndècu‑í cuèndá quiní‑yu sá quídé càhnu ñaha‑n xii‑í chi ducaⁿ‑ni cùu iní ñáhá‑n xìi yúhú ndéé cútnàhá vátá ngǎva‑gá ñuyíú. ");
INSERT INTO milNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Táu, yòhó ío yɨñùhu ndecu‑n. Te ñáyiu ndècu ichi cuehé ichi duha ñá túú xìní ñáhǎ‑yu xii‑n, dico yúhú chi xìní ñáhà‑í xii‑n, dico ñáyiu ní sándáá iní ñáhá xìi‑í sa xìní‑yu sá dɨ́ú‑n nǐ tendaha ñàha‑n xii‑í véxi‑í ñuyíú‑a. ");
INSERT INTO milNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Te sa xǎhaⁿ‑ǐ xií‑yu yoo cùu‑n, te dɨu‑ni ducaⁿ càda‑í cuèndá cuu iní tnáhǎ‑yu dàtná cúú ìní ñáhá‑n xìi‑í, te ducaⁿ cùndecu‑í ndɨhɨ́‑yu —càchí‑gá xáhaⁿ‑gǎ xii Tǎtá‑gǎ Dútú Ndiǒxí. ");
INSERT INTO milNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Te sátá dúcáⁿ nǐ cáháⁿ Jèsús, te ní quee‑gá ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá cuáháⁿ‑güedé ndàa ɨngá xio yuhu yùú Cèdrón. Te yàcáⁿ cáá ɨ̀ɨⁿ lahuertá, te xɨtɨ́ lahuèrtá‑áⁿ cuǎnguɨhu Jèsús ndɨhɨ cue tée xìca cuu ndɨhɨ‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Te té Jùdás déhe té Xǐmú Iscàrioté tée ní sáha cuèndá ñáhá xìi‑gá núú cuè tée cùu úhú iní ñáhá sa xìní‑dé lahuèrtá‑áⁿ chi tɨtnɨ́ xito ní sáháⁿ Jèsús ndɨhɨ‑güedé xíáⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Núu ndáá ichi xíáⁿ nǐ sáá té Jùdás ndɨhɨ vài sandadú, ndɨhɨ cue tée quìde cuendá veñúhu ní techìuⁿ ñaha cue dútú cúnùu, ndɨhɨ cue tée cùu fariséú. Te xǐnehe‑güedé machìtí ndɨhɨ ɨɨⁿ ǔú‑gá sá děéⁿ, te yòtnuú‑güedé lìntérná ndɨhɨ itɨ ní sáá. ");
INSERT INTO milNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Te Jèsús sa nàha‑gá nchaa nàcuáa cada ñaha‑güedě xii‑gá nǔu ní sáháⁿ tuha ñaha‑gǎ xii‑güedé, te ní xáhaⁿ‑gǎ: —¿Yoo nànducu‑ndo? —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Te ní xáhaⁿ‑güedě: —Jèsús tée ñuú Nazàrét nándùcu‑ndɨ́ —càchí‑güedé xǎhaⁿ‑güedě xii‑gá. Te ní xáhaⁿ Jèsús: —Yúhú ducaⁿ nàni‑í, te náu‑í ndécú‑á te núu yúhú nándùcu‑ndo —cachí‑gá xáhaⁿ‑gǎ xii‑güedé. Te tnàhá té Jùdás tée ní sáha cuèndá ñáhá xìi‑gá ndɨhɨ‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Te òré ní xáhaⁿ Jèsús sá dɨ́ú‑gǎ cúú těe nànducu‑güedé, te ní nacaca dùma‑güedé te ní nduá‑güedé ndéé ñuhu. ");
INSERT INTO milNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Te ní xícáⁿ tnúhú tùcu Jesús núú‑güedě yoo nànducu‑güedé. Te ní xáhaⁿ tùcu‑güedé sá Jèsús tée ñuú Nazàrét nándùcu‑güedé, ");
INSERT INTO milNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","núu ní xáhaⁿ‑nǎ Jèsús: —Sa ní cáháⁿ‑í sá dɨ́ú yǔhú ducaⁿ nàni‑í, te núu yúhú nándùcu‑ndo, te daña‑ndo nchàa cue tée iha na nùhú‑güedé —càchí‑gá xáhaⁿ‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Duha ní cuu chi ní quee ndáá‑xi nàcuáa ní cáháⁿ méé Jèsús chi ní cachí‑gá sá ncháá ñǎyiu ní sáha cuèndá ñáhá Yǎ Ndiǒxí cundecu ndɨhɨ‑gá vá cuǐta nihnú‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Te té Xǐmú, àdi Pelú chi úú dɨ̀u‑dé, néhé‑dě ɨɨⁿ machìtí, te ní tava‑dé machìtí‑áⁿ ñɨɨ‑xi te ní xehndé‑dé lóho xio cùha ɨɨⁿ tée nàni Malcú ní quéndeé duuⁿ. Te tée‑áⁿ xínú cuèchi‑dé núú dǔtú cúnùu‑gá. ");
INSERT INTO milNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Te ní xáhaⁿ Jèsús xii té Pèlú: —Nataxúha machìtí‑áⁿ nǔú ñúhú‑xí, chi dacuɨtɨ́í sǎ ndóhò‑í nàcuáa ní cachí Tǎtà‑í cunduu —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Te cue sandàdú ndɨhɨ cue tée cùnuu‑gá núú‑güedě, ndɨhɨ cue tée quìde cuendá veñúhu ní tnɨɨ‑güedé Jèsús, te ní dácútú ñàha‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Te ndèca ñaha‑güedé xii‑gá cuáháⁿ núú ndécú tě Ànás, te té Ànás‑áⁿ cúú‑dě tǎtá ñadɨ̀hɨ́ té Caìfás. Te té Caìfás‑áⁿ nǐ cuu‑dé dútú cúnùu‑gá cuíá‑ǎⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Te dɨu‑ni tée‑áⁿ nǐ xáhaⁿ‑dě xii ñáyiu isràél sá vǎha‑gá sá ɨ́ɨ́ⁿ‑ní těe na cùú‑dé sá cuèndá‑yu nchaá‑yu. ");
INSERT INTO milNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Te té Pèlú, àdi Xímú chi úú dɨ̀u‑dé, ndɨhɨ ɨngá tucu‑dé nàcuáa xìca cuu ndɨhɨ‑güedé Jèsús nchìcúⁿ ñáhá‑güedě xii‑gá cuáháⁿ. Te ɨɨⁿ tée‑áⁿ xìní tnáhá‑dě ndɨhɨ dútú cúnùu‑áⁿ nǔu nchìcúⁿ‑dé tnàhá‑dé Jèsús cuánguɨhu ndéé núú cáá vèhe tée cùnuu‑áⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Dico té Pèlú ní ndóo‑dé yuyèhe ndaa quehé, núu ní ndee tée ndɨhɨ té Pèlú‑áⁿ nǐ cáháⁿ ndɨhɨ‑dé ñaha ndèé yuyèhe, te ndèca‑dé té Pèlú cuánguɨhu. ");
INSERT INTO milNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Te ní xáhaⁿ ñàha ndéé yuyèhe‑áⁿ xii té Pèlú: —¿Náa ñá dɨ́ú yòhó tnàhá‑n xìca cuu ndɨhɨ‑n tée ndèca‑güedé cuánguɨhu‑a? —càchí‑aⁿ xǎhaⁿ‑aⁿ xìi‑dé. Te ní xáhaⁿ tě Pèlú: —Ñáhá, ñá túú těe‑ǎⁿ xícá cùu ndɨhɨ‑ú —càchí‑dé xǎhaⁿ‑dě xii‑aⁿ. ");
INSERT INTO milNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Te ío víxiⁿ quìde‑xi núu cue tée xìnu cuechi, ndɨhɨ cue tée quìde cuendá veñúhu ní dátnàhá‑güedé ñuhú, te xínutnɨ́ɨ teté‑güedé ndɨhɨ té Pèlú. ");
INSERT INTO milNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Te dútú cúnùu ní xícáⁿ tnúhú‑dě núú Jèsús nǔu nándɨ cùu cue tée xìca cuu ndɨhɨ‑gá, te nándɨ sá dánèhé ñáhá‑gǎ xii‑güedé. ");
INSERT INTO milNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Te ní xáhaⁿ‑gǎ: —Yúhú càháⁿ ndodo‑í núú nchàa ñáyiu cuěi xɨtɨ́ veñúhu càhnu sá ǐo cùnuu, te cuěi xɨtɨ́ nchaa dava‑gá veñúhu núú tàcá nchaa ñáyiu isràél ducaⁿ‑ni dànehé‑í‑yu, te ñá túú dàyuhu cáháⁿ‑í. ");
INSERT INTO milNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Núu vá càcáⁿ tnúhú‑n nǔù‑í. Cácáⁿ tnúhú nǔú nchàa ñáyiu sàcúndedóho tnúhu càháⁿ‑í, te na càháⁿ‑yu núu nása ndùu tnúhu càháⁿ‑í chi xìní‑yu —càchí‑gá xáhaⁿ‑gǎ xii‑dé. ");
INSERT INTO milNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Te sá dúcáⁿ nǐ cáháⁿ Jèsús nǔu ɨɨⁿ tée quìde cuendá veñúhu nùtnɨ́ɨ‑dé tnàhá‑dé te ní cani‑dé ɨɨⁿ déhndé nǔú‑gǎ. Te ní xáhaⁿ‑dě: —¿Ná cuèndá ducaⁿ càháⁿ‑n nǔú dǔtú cú