﻿USE sofia;
DROP TABLE IF EXISTS sofia.mihNT_vpl;
CREATE TABLE mihNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mihNT_vpl WRITE;
INSERT INTO mihNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ihya cuu tandɨhɨ ñiyɨvɨ sahnu sii ra Jesucristo, ra cu ñiyɨvɨ sii ra David ta sii ra Abraham. ");
INSERT INTO mihNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ra Abraham i cuu zutu ra Isaac. Ta ra Isaac i cuu zutu ra Jacob. Ta ra Jacob i cuu zutu ra Judá ta yañi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ra Judá i cuu zutu ra Fares ta ra Zara. Tamar i sinañi zɨhɨ ra. Ra Fares i cuu zutu ra Esrom. Ta ra Esrom i cuu zutu ra Aram. ");
INSERT INTO mihNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ra Aram i cuu zutu ra Aminadab. Ta ra Aminadab i cuu zutu ra Naasón. Ta ra Naasón i cuu zutu ra Salmón. ");
INSERT INTO mihNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ra Salmón i cuu zutu ra Booz. Ta Rahab nañi zɨhɨ ra. Ra Booz i cuu zutu ra Obed. Rut nañi zɨhɨ ra. Ta ra Obed i cuu zutu ra Isaí. ");
INSERT INTO mihNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ra Isaí i cuu zutu ra rey David. Ta ra rey David i cuu zutu ra Salomón vatyi i quihin ra sii ñazɨhɨ ra Urías. ");
INSERT INTO mihNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ra Salomón i cuu zutu ra Roboam. Ta Roboam i cuu zutu ra Abías. Ra Abías i cuu zutu ra Asa. ");
INSERT INTO mihNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ra Asa i cuu zutu ra Josafat. Ta ra Josafat i cuu zutu ra Joram. Ta ra Joram i cuu zutu ra Uzías. ");
INSERT INTO mihNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ra Uzías i cuu zutu ra Jotam. Ta ra Jotam i cuu zutu ra Acaz. Ta ra Acaz i cuu zutu ra Ezequías. ");
INSERT INTO mihNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ra Ezequías i cuu zutu ra Manasés. Ta ra Manasés i cuu zutu ra Amón. Ta ra Amón i cuu zutu ra Josías. ");
INSERT INTO mihNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ta ra Josías i cuu zutu ra Jeconías sihin yañi ra quɨvɨ i sicoo cuatyi ta i quihin ñiyɨvɨ sii ñu hebreo sindyaca ra sii tandɨhɨ ñu ndya ñuu Babilonia cua cuu ñu muzu ñiyɨvɨ indyacuan. ");
INSERT INTO mihNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yaha cuan ta zɨquɨ ra Jeconías i cuu zutu ra Salatiel. Ta ra Salatiel i cuu zutu ra Zorobabel. ");
INSERT INTO mihNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ta ra Zorobabel i cuu zutu ra Abiud. Ta ra Abiud i cuu zutu ra Eliaquim. Ta ra Eliaquim i cuu zutu ra Azor. ");
INSERT INTO mihNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ta ra Azor i cuu zutu ra Sadoc, ta ra Sadoc i cuu zutu ra Aquim. Ta ra Aquim i cuu zutu ra Eliud. ");
INSERT INTO mihNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ra Eliud i cuu zutu ra Eleazar. Ra Eleazar i cuu zutu ra Matán. Ra Matán i cuu zutu ra Jacob, ");
INSERT INTO mihNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ta ra Jacob i cuu zutu ra José yɨɨ ña María. Ta maa ña i cuu zɨhɨ ra Jesús ra sa nañi Cristo. ");
INSERT INTO mihNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ndya quɨvɨ ra Abraham ta ndya ra David i sicoo usi cumi tahan ra sahnu sii ra Jesús cuhva vasi tata ra. Ta ndya quɨvɨ ra David ta ndya quɨvɨ i sindyaca ñiyɨvɨ sii tandɨhɨ ñu hebreo ndya ñuu Babilonia i sicoo inga usi cumi tahan ra sahnu sii ra Jesús cuhva vasi tata ra. Ta i sicoo inga usi cumi tahan ra ndya ta sa yaha sahan ñu ñuu Babilonia ta ndya quɨvɨ i cacu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ihya cuu cuhva i cacu ra Jesucristo. Sa cundaa tyiño ña María zɨhɨ ra Jesús sihin minoo ra sa nañi José, zoco cumañi ca ndu‑ɨɨn ñu ta i sito ña vatyi sa ñihi ña minoo zehe sa cuenda Tatyi Ii maa ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ta ra José, ra cua cuu yɨɨ ña, i cuu ra minoo ra ndoo xaan, ta ñá cuñi ra zandoo ra sii ña minoo cuhva sa cua cahan xaan ñiyɨvɨ sii ña. I cuñi ra vatyi cua natani xehe tutu ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Zoco cuhva sa nacañi xaan iñi ra yozo caa cua zavaha ra, i quituu minoo ángel ra Ndyoo nuu ra sisi ñimahna, ta i catyi ángel cuan sihin ra: José, ñiyɨvɨ sii ra David, ma yuhun ta cuhun sii ña María sa cuu ña ñazɨhun vatyi zehe ña sa cua cacu cuu zehe Tatyi Ii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Cua cacu zehe ña. Ta cua cunañi ra Jesús vatyi cua zandasi ra cuatyi ñiyɨvɨ cuñi sii ra. Tacuan i catyi ángel. ");
INSERT INTO mihNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ta i cuu tandɨhɨ cuhva ya vatyi cua quita si tañi cuhva i catyi ra Ndyoo quɨvɨ i cahan minoo ra profeta ta i catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Minoo ñaha yoco, cua ñihi ña minoo zehe, ta rayɨɨ cua cuu zehe ña. Emanuel cua cunañi ra. Zɨvɨ Emanuel cuan cuñi si catyi si: Ra Ndyoo ndyaa sihin yo. ");
INSERT INTO mihNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ta cuhva sa ndoyo ra José i zavaha ra cuhva i catyi ángel cuan sihin ra. I quihin ra sii ña María sa cuu ña ñazɨhɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Zoco ñá quixi ra sihin ña ndya sa cacu zehe nuu ña. Ta i zacunañi ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","I cacu ra Jesús ñuu Belén nu cu si Judea quɨvɨ i cuu ra Herodes rey yucuan. Ta ñuu Jerusalén i saa zuhva ra sito xaan cahvi. Mago nañi ra. Ityi caña ñicandyi i quisi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ta i ndaca tuhun ra: ¿Ndyamaa iyo ra i cacu sa cuu ra rey cuenda ñiyɨvɨ hebreo? Ityi caña ñicandyi ndyaa ndi, ta i ndyehe ndi minoo tiñoo sa cuu cuenda ra. Ta vasi ndi vatyi cua zacahnu ndi sii ra. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","I ñihi ra rey Herodes tuhun ya, ta sica xaan iñi ra ta tacuan tucu tandɨhɨ ñiyɨvɨ ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","I cana ra Herodes sii tandɨhɨ ra zutu nahnu ta ra cu maestro cuenda ley, ta i ndaca tuhun ra sii ra ndyamaa tahan si cacu ra Cristo. ");
INSERT INTO mihNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ta i nacatyi ra cuan sihin ra: Cua cacu ra ñuu Belén nu cu si Judea vatyi tyehen i tyaa minoo ra profeta ta sa naha: ");
INSERT INTO mihNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yoho ñuu Belén nu cu si Judea, ña luhlu ca moo ta zɨquɨ tandɨhɨ inga ca ñuu nu cu si Judea. Vatyi ñuu Belén cua cacu minoo ra cua cundyaca ñaha, ta cua zacuenda ra sii ñu hebreo, ñiyɨvɨ mi. Tacuan catyi Tuhun Ndyoo nacatyi ra cuan sihin ra Herodes. ");
INSERT INTO mihNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ta zɨquɨ xehe ñi i cana ra Herodes sii ra mago cuan, ta i ndaca tuhun ra sii ra ñaa cuhva quituu tiñoo cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ta zɨquɨ i tasi ra sii ra ndya ñuu Belén, ta catyi ra: Nanducu vaha xaan ndo sii ra luhlu cuan. Ta tatu sa nañihi ndo sii ra, zacoto ndo sii, vatyi cua cuhun tuqui, ta cua zacahni sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ta sa siñi ra mago cuan sa i catyi rey cuan, i quihin ra ityi cuahan ra. Ta tiñoo sa i ndyehe ra ityi caña ñicandyi, cuahan tɨ ityi nuu ra ndya i saa tɨ ta sicuɨñɨ tɨ nu ndyaa lee cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ta sa i ndyehe ra mago vatyi i sicuɨñɨ tiñoo cuan, zɨɨ xaan i cuñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ta i quɨhvɨ ra sisi vehe, ta i ndyehe ra sii lee cuan sihin ña María zɨhɨ ra. Ta i sicuɨñɨ sɨtɨ ra, ta zacahnu ra sii ra Jesús. Ta zɨquɨ i nuña ra ndaha tyiño ra, ta i saha maa ra xuhun cuaan, ta cutu ta ndutya vixi. ");
INSERT INTO mihNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ta sa yaha ndyehe ra sii ra Jesús, ta zɨquɨ zɨɨn ityi i cua nuhu ra ndya ñuu ra vatyi i zacoto minoo ángel ra Ndyoo sii ra sisi ñimahna vatyi ma cunanuhu ra nu ndyaa ra Herodes. ");
INSERT INTO mihNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cuahan ra mago cuan ta zɨquɨ i quituu minoo ángel ra Ndyoo nuu ra José sisi ñimahna, ta i catyi si: Nduvita ta cuhun sii ra luhlu ta sii zɨhɨ ra, ta cuhun ndo ndya Egipto. Yucuan ndoo ndo ndya quɨvɨ cua catyi sihin ndo vatyi cuñi cahñi ra Herodes sii ra luhlu. ");
INSERT INTO mihNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tacuan i catyi ángel cuan ta i nduvita ra José, ta i quihin ra sii ra luhlu ta sii zɨhɨ ra. Ta zuun ñi sa cuaa cuan i quita ñu ta cuahan ñu ndya Egipto. ");
INSERT INTO mihNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","I ndoo ñu yucuan ndya i sihi ra rey Herodes. Cuhva ya i cuu si vatyi tacuan ta cua quita si cuhva i catyi minoo ra profeta nu i catyi ra cuhva i nacatyi maa ra Ndyoo: “Cua nacane sii Zehi ndya Egipto.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Quɨvɨ i sito ra Herodes vatyi sacu ndyaa ra mago sii ra, ta ñá zavaha ra cuhva i catyi ra, yaha xaan i cuxaan ra. Ta i tava ra tyiño vatyi cahñi zandaru sii tandɨhɨ ra ndyihi sa uu cuiya ta sa ndyihi ca ñuu Belén ta inga ñuu ndyaa yatyi. Tacuan i zavaha ra vatyi tañi tacuan cuu cuiya ra Jesús sica iñi ra sa cuenda cuhva i catyi ra mago cuan sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ta cuhva i sahñi ra Herodes sii ra ndyihi, i quita si cuhva i tyaa ra Jeremías, minoo ra profeta ta sa naha. Tyehen i tyaa ra: ");
INSERT INTO mihNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","I quita minoo nduzu ñihi nu cu si Ramá. Sacu xaan ñiyɨvɨ, ta sacu saa ñu. Maha Raquel sacu sa cuenda zehe ña, ta ma cutaxi ña vatyi yoñi ca si. I catyi Tuhun Ndyoo vatyi cua cuu si cuhva cuan. Ta zuun ñi cuhva cuan i quita si. ");
INSERT INTO mihNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ta sa yaha sihi ra Herodes, ta i quituu tucu minoo ángel ra Ndyoo ityi nuu ra José sisi ñimahna nu ndyaa ra Egipto, ta i catyi si sihin ra: ");
INSERT INTO mihNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nduvita ta cuhun sii ra luhlu ta sii zɨhɨ ra ta cunanuhu ndo ndya Israel vatyi sa sihi ra cuñi cahñi sii ra luhlu. ");
INSERT INTO mihNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tacuan i catyi ángel cuan, ta i nduvita ra José, ta i quihin ra sii ra luhlu ta sii zɨhɨ ra, ta i sinanuhu ñu ndya Israel. ");
INSERT INTO mihNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Zoco i ñihi ra José tuhun vatyi ndyaca ñaha ra Arquelao nu cu si Judea sa cuenda ra Herodes zutu ra, ta i yuhu xaan ra José cuhun ra yucuan. Ta i cahan tucu ángel sihin ra sisi ñimahna, ta yucuan cuenda cuahan ñu ndya nu cu si Galilea. ");
INSERT INTO mihNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ta sa saa ñu yucuan, i ndoo ñu ñuu Nazaret. Ta cuhva cuan i quita si tañi catyi minoo ra profeta vatyi i catyi ra vatyi cua catyi ñiyɨvɨ vatyi minoo ra nazareno cuu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Quɨvɨ cuan i quisi ra Juan, ra zacoo ndutya sii ñiyɨvɨ, ndya nu cu si Judea. Minoo nu ityi xaan nu yoñi maa ñiyɨvɨ iyo i saa ra, ta i nacatyi ra Tuhun Ndyoo sihin ñiyɨvɨ i saa nu ndyaa ra. ");
INSERT INTO mihNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ihya cuu cuhva i catyi ra: Zama ndo cuhva iyo ndo vatyi sa cuñi saa quɨvɨ cundyaca ñaha ra Ndyoo ihya ñuu ñiyɨvɨ. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ta ra Juan cuu ra i cahan ra Isaías tuhun quɨvɨ i tyaa ra tuhun i saha ra Ndyoo sii ra, ta i catyi ra: Cua cuɨñɨ ndo nduzu minoo ra cana saa minoo nu ityi xaan. Ta catyi ra cuan: “Tañi zanduvaha ndo minoo ityi, tacuan zanduvaha ndo añima ndo vatyi cua quisi ra ndyaca ñaha sii yo. Tañi zandundoo ndo ityi, tacuan zama ndo cuhva iyo ndo.” Tacuan i tyaa ra Isaías ta sa naha sa cuenda ra Juan, ra cua quisi cuee ca. ");
INSERT INTO mihNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ta ra Juan cuan, siñoho ra zahma ixi camello. Ta sinuhñi zinda ñɨɨ sisi ra. Ta i sasi ra minoo nuu quɨtɨ tañi tɨca, ta sihi ra tyahiñu ñuñu. ");
INSERT INTO mihNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ñiyɨvɨ ñuu Jerusalén ta tandɨhɨ yuñuu Judea ta ñu ndyaa yatyi yuu Jordán, cuahan ñu cua tyizoho ñu sa cahan ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ta sa yaha nahma ñu cuatyi ñu, ta i zacoo ndutya ra Juan sii ñu yuu Jordán cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","I ndyehe ra Juan vatyi saa cuaha xaan ra fariseo sihin ra saduceo vatyi cuñi ra coo ndutya ra, ta i catyi ra Juan sihin ra: ¡Ñiyɨvɨ quiñi xaan iyo cuu ndo tañi coo! ¿Yoo sa catyi sihin ndo vatyi cuu cacu ndo sihin cuhva sa cua tasi tuñi ra Ndyoo sii ñiyɨvɨ? ");
INSERT INTO mihNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cuñi si sa zama ndisa cuii ndo cuhva iyo ndo, ta zavaha ndo sa vaha. ");
INSERT INTO mihNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ta ma caca iñi ndo sihin añima ndo vatyi ra Abraham cuu zutu ndo, ta ma caca iñi ndo vatyi maa ra cua zacacu sii ndo. Ma zacahnu ndo sii ndo vatyi vazu sihin yuu ya, ta cuu zavaha ra Ndyoo ñiyɨvɨ sii ra Abraham sihin si. ");
INSERT INTO mihNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tañi yutu ña saha sɨtɨ cuu maa ndo vatyi ña zavaha ndo cuhva cuñi ra Ndyoo. Ta yutu sa ña saha sɨtɨ, sahndya ñiyɨvɨ sii tu. Ta sahmi ñu sii tu. Ta zuun ñi cuhva cuan cua cuhun maa ndo nu cayu ñúhu. ");
INSERT INTO mihNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ndisa zacoo ndutye sii ndo sihin ndutya tatu zama ndo cuhva iyo ndo. Zoco vasi inga ra cahnu ca ta zɨquɨ mi. Ña tahan si sii, nu sa cui muzu ra ta cuize ndisa ra, zoco zuun ñi maa ra i saha tyiño sii. Ta maa ra cua zacoo ndutya sii ndo sihin Tatyi Ii ta sihin ñúhu. ");
INSERT INTO mihNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sa ndaha ra pala ra ta cua zanduvii ra sɨtɨ trigo ra, ta cua tava zɨɨn ra zoo si. Cua zandu‑ɨɨn ra sii trigo ra, ta cua cucumi vaha ra sii si, ta cua cahmi ra zoo si sisi minoo ñúhu sa ma ndahva. Tacuan i catyi ra Juan sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tacuan ta i quita ra Jesús nu cu si Galilea, ta i quisi ra ndya yuu Jordán nu ndyaa ra Juan vatyi cuñi ra sa cua zacoo ndutya ra Juan sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ta ñá cuñi ra Juan zacoo ndutya sii ra vatyi catyi ra: Tahan si sa zacoo ndutya moo sii mi. ¿Ta ñaa cuenda catyun sa zacoo ndutye suun? ");
INSERT INTO mihNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Zoco i catyi ra Jesús sihin ra: Nacuu si cuhva catyi suhun vityi vatyi tacuan cuñi si zavaha yo tandɨhɨ cuhva ndoo, cuhva cuñi ra Ndyoo. Tacuan i catyi ra Jesús, ta zɨquɨ i ndoo ra Juan vaha. ");
INSERT INTO mihNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ta sa yaha i sicoo ndutya ra Jesús, ta i quita ra sisi ndutya cuan. Ta zuun ñi caa cuhva cuan i nuña andɨvɨ, ta i ndyehe ra Jesús Tatyi Ii ra Ndyoo. Noo si tañi noo minoo paloma zɨquɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ta tacuan ta i cahan minoo ra cahan sisi andɨvɨ ta i catyi ra: Ihya cuu zehi. Cuñi xein sii ra. Zɨɨ xaan cuñi sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ta zɨquɨ i sindyaca Tatyi Ii sii ra Jesús minoo nu ityi xaan nu yoñi maa ñiyɨvɨ iyo vatyi cua nducu coto ihñi cuihna sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ta ñá sasi ra Jesús uu xico quɨvɨ ta uu xico sa cuaa, ta zɨquɨ i sizoco ra. ");
INSERT INTO mihNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ta cuhva cuan i tuhva cuihna sii ra vatyi cua nducu coto ihñi ra sii ra, ta catyi ra: Tatu ndisa vatyi Zehe ra Ndyoo cuu suun, catyun sihin yuu sa catuu ihya vatyi nanduu si pan. ");
INSERT INTO mihNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Zoco i nacahan ra Jesús ta catyi ra: Catyi Tuhun Ndyoo vatyi ña maa sihin sa casi ñi yo cundito yo. Sihin sa sasi yo ndito coño ñuhu yo, zoco sihin sa tyaa yo yahvi tuhun cahan ra Ndyoo ta ndito añima yo sa ndisa cuii. Catyi ra Jesús sihin cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tacuan ta i sindyaca cuihna sii ra Jesús ndya ñuu Jerusalén. Ta i zandaa ra sii ra xiñi vehe ñuhu cahnu. Ta i catyi ra sihin ra Jesús: ");
INSERT INTO mihNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tatu ndisa vatyi Zehe ra Ndyoo cuu suun, ndavon ndya nu ñuhu vatyi catyi Tuhun Ndyoo: “Cua cuhva ra Ndyoo tyiño sii ángel ra vatyi zacuenda ra suun. Cua naqueen ra suun sihin ndaha ra, ta ma ñicuehe sohon sihin minoo yuu.” ");
INSERT INTO mihNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tacuan i catyi cuihna, ta i catyi ra Jesús sihin ra: Catyi tucu Tuhun Ndyoo vatyi ma nducu coto ihñi ndi sii ra Ndyoo ra ndyaca ñaha sii ndi. ");
INSERT INTO mihNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yaha cuan ta i sindyaca cuihna sii ra Jesús xiñi minoo yucu zucu xaan, ta i zañaha ra tandɨhɨ ñuu ñiyɨvɨ sii ra ta cuhva sa tyaqui xaan caa si. ");
INSERT INTO mihNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ta i catyi ra sihin ra Jesús: Ndaha mi ndyaa tandɨhɨ ya vatyi saha ra Ndyoo sa cundyaca ñehi tandɨhɨ ñuu ñiyɨvɨ ya. Ta cua cuhve tandɨhɨ si suun tatu cua cuɨñɨ sɨtun nui ta zacahnun sii. Catyi cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Zoco i catyi ra Jesús sihin ra: Cuɨñɨ siyo suun sii, cuihna vatyi catyi Tuhun Ndyoo vatyi ɨɨn ñi sii maa ra Ndyoo ra ndyaca ñaha sii ndi cua zacahnu ndi. Ta ɨɨn ñi tyiño maa ra cua zacuu ndi. Catyi ra Jesús sihin cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ta zɨquɨ i zandoo cuihna sii ra Jesús, ta i quisi tyindyee ángel sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Quɨvɨ i ñihi ra Jesús tuhun vatyi i tyihi ñiyɨvɨ sii ra Juan vehe caa, i quita ra yucuan ta cuahan ra ndya Galilea. ");
INSERT INTO mihNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Zoco ñá ndoo ra ñuu Nazaret. Cuahan ra cua cundyaa ra ñuu Capernaum. Minoo ñuu sa ndyaa yatyi ñi yuhu miñi yatyi nu cu si Zabulón ta Neftalí cuu si. ");
INSERT INTO mihNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tacuan i cuu si vatyi cua quita si cuhva i tyaa ra Isaías, minoo ra profeta ta sa naha. Tyehen i tyaa ra Isaías: ");
INSERT INTO mihNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Nu cu si Zabulón ta Neftalí, ityi cuahan yo miñi tatu sa yaha yo yuu Jordán, yucuan cuu nu cu si Galilea nu ndyaa ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu. ");
INSERT INTO mihNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ñiyɨvɨ cuan sicoo ñu nu ñaa xaan, zoco i ndyehe ñu minoo ñúhu ndisi xaan. Quɨvɨ cuan cua cuu cuii ñu, zoco i zandundisi ñúhu cuan nu ndyaa ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ndya quɨvɨ i quɨhvɨ ra Jesús Galilea, ta i quisaha nacatyi ra Tuhun Ndyoo sihin ñiyɨvɨ. Tyehen i catyi ra: Zandoo ndo cuatyi ndo, ta zama ndo cuhva iyo ndo vatyi sa cuñi saa quɨvɨ cua cundyaca ñaha ra Ndyoo ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ta i sica noo ra Jesús yuhu miñi Galilea. Ta i ndyehe ra sii uu tahan ra sihin yañi ra. Minoo ra nañi ra Simón, ta Pedro nañi tucu ra. Ta inga ra nañi ra Andrés. Cañi ra traya ra nu ndutya vatyi yucuan cuu tyiño i zacuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ta i catyi ra Jesús sihin ra: Coho ndo sihin, ta cua cuhve cuhva nducu ndo sii ñiyɨvɨ tañi cuhva nducu ndo sii tyiyaca. Tacuan i catyi ra Jesús sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ta ta sica ñi i zandoo ihno ra traya ra, ta cuahan ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ta i sica ra Jesús zuhva ca sihin ra ityi nuu ca ta i ndyehe ra sii ra Jacobo sihin ra Juan zehe ra Zebedeo. Ñoho ra minoo barco sihin zutu ra. Nazuhva ra traya ra. Ta i cana ra Jesús sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ta zuun ñi caa cuhva cuan i zandoo ra sii zutu ra sihin barco ra, ta i sindyico ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sica noo ra Jesús nacahnu Galilea. Zacuaha ra sii ñiyɨvɨ sisi vehe ñuhu tahan tahan ñuu. Ta nacatyi ra Tuhun Vaha sihin ñiyɨvɨ cuhva cua cundyaca ñaha ra Ndyoo. Ta i zanduvaha ra sii ñiyɨvɨ cuhu tandɨhɨ cuii nuu cuehe. ");
INSERT INTO mihNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","I sito ñiyɨvɨ tuhun ra Jesús nacahnu Siria. Ta i quisi ndyaca ñu sii tandɨhɨ ñu cuhu zɨɨn zɨɨn nuu cuehe a tatu iyo sa uhu sii ñu. Ta i quisi ndyaca ñu sii ñu ñoho tatyi cuihna, ta ñu cuhu cuehe meme, ta ñu xii. Ta i zanduvaha ra Jesús sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ta cuaha xaan ñiyɨvɨ sa ndyaa Galilea i sindyico ñu sii ra. Ta tacuan tucu ñiyɨvɨ ñuu Decápolis, ta ñuu Jerusalén ta nacahnu Judea ta ñiyɨvɨ ndyaa inga siyo yuu Jordán ndɨhɨ ca. ");
INSERT INTO mihNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","I ndyehe ra Jesús vatyi cuaha xaan ñiyɨvɨ, ta i ndaa ra minoo yucu, ta i sicundyaa ra yucuan. Ta i siconduu i sicundyaa ñiyɨvɨ ndyico sii ra nu ndyaa ra. ");
INSERT INTO mihNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ta i quisaha zacuaha ra Jesús sii ñu, ta tyehen catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Sa iyo sa vaha sii ñiyɨvɨ vityi tatu sa sito ñu vatyi siñi ñuhu ra Ndyoo sii ñu vatyi tahan si sii ñu sa cundyaca ñaha ra Ndyoo sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Sa iyo sa vaha sii ñiyɨvɨ cuihya iñi vityi vatyi cua zanaa ra Ndyoo tucuihya iñi sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Sa iyo sa vaha sii ñiyɨvɨ zanduluhlu sii, vatyi cuee ca cua cuhva maa ra Ndyoo sa cundyaca ñaha ñu ñuu ñiyɨvɨ ya. ");
INSERT INTO mihNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Sa iyo sa vaha sii ñiyɨvɨ cuñi xaan zavaha tandɨhɨ sa ndoo, cuhva cuñi ra Ndyoo vatyi cua tyindyee ra Ndyoo sii ñu, ta cua cuu xaan zavaha ñu sa vaha. ");
INSERT INTO mihNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Sa iyo sa vaha sii ñiyɨvɨ cundahvi iñi sii inga ñiyɨvɨ vatyi Ndyoo cua cundahvi xaan iñi ra sii maa ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Sa iyo sa vaha sii ñiyɨvɨ sa ñahñi cuatyi iyo añima vatyi cua ndyehe ñu sii maa ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Sa iyo sa vaha sii ñiyɨvɨ nducu cuhva zacoo sa taxi nu iyo cuatyi vatyi cua catyi ra Ndyoo vatyi zehe maa ra cuu sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Sa iyo sa vaha sii ñiyɨvɨ tatu zandyehe inga ñiyɨvɨ tundoho sii ñu sa cuenda sa vaha sa zavaha ñu. Ndisa vatyi sa ndyaca ñaha ra Ndyoo sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Sa iyo sa vaha sii ndo tatu quiñi xaan cahan ñiyɨvɨ sihin ndo sa cuenda mi ta tatu zavaha xaan ñu sa ndya vaha ñi sihin ndo ta tatu cahan ñu ndya vaha ñi sii ndo ta ña ndisa cuu si. ");
INSERT INTO mihNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cuzɨɨ xaan iñi ndo tatu tacuan zavaha ñu sihin ndo vatyi cahnu xaan sa vaha cua ñihi ndo andɨvɨ vatyi zuun ñi cuhva ña vaha cuan i zavaha ñiyɨvɨ sihin ra profeta quɨvɨ cumañi ca cacu maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Maa ndo cuu tañi ñɨɨ sa cuenda ñuu ñiyɨvɨ ya. Zoco tatu ña uhva ca ñɨɨ, ¿yozo caa tyindyee si? Tatu ña uhva ca si ña vaha ca si. Zavita yo sii si, ta cuañi ñiyɨvɨ zɨquɨ si. ");
INSERT INTO mihNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Maa ndo cuu tañi ñúhu sa cuenda ñuu ñiyɨvɨ ya. Tatu ndyaa minoo ñuu xiñi minoo yucu ma cuu sa cundyaa xehe si. ");
INSERT INTO mihNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ta ña tuhva ñiyɨvɨ tyaa minoo lámpara ta tyihi ñu sii si xu minoo cajón. Ña tacuan vatyi zucu tyaa ñu sii si, ta zandisi si sa cuenda tandɨhɨ ñiyɨvɨ yucu vehe. ");
INSERT INTO mihNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tacuan tucu maa ndo, zavaha ndo sa vaha ityi nuu ñiyɨvɨ, ta cua ndyehe ñu tyiño ndo, ta cua zacahnu ñu sii Zutu mañi yo, ra ndyaa andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ma caca iñi ndo vatyi yuhvi vasi zanei cuhva tyaa ñiyɨvɨ yahvi sii ley ra Ndyoo sa i tyaa ra Moisés a cuhva i tyaa ra profeta. Ña vasi zandɨhi cuhva iyo sii si cuan. Vasi ta tyei yahvi sii tandɨhɨ sa catyi tuhun cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sa ndisa catyi sihin ndo vatyi nɨɨ ñi sa iyo andɨvɨ ta ñuhu ñuu ñiyɨvɨ, ma naa nu siin cuhva iyo sii ley ra Ndyoo. Tandɨhɨ sa catyi ley sa tahan si cuu, ta cua cuu si. ");
INSERT INTO mihNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yucuan cuenda yoo ra ma zavaha minoo ley ra Ndyoo, vazu ley luhlu cuu ley cuan, ta tatu cua nacatyi tucu ra sihin ñiyɨvɨ vatyi ma zavaha ñu sii si, ra zavaha cuhva cuan cua cuu ra ra luhlu ca nu ndyaca ñaha ra Ndyoo. Zoco ra zavaha sii si ta zacuaha ra sii inga ñiyɨvɨ vatyi tahan si zavaha ñu sii si, minoo ra cahnu cua cuu ra nu ndyaca ñaha ra Ndyoo andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Vatyi catyi sihin maa ndo vatyi tatu ma zavaha ndo sa ndoo ca ta zavaha ndo tañi ra maestro cuenda ley ta ra fariseo, nu yozo cuii ca ta ma cuu quɨhvɨ ndo nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Sa siñi ndo cuhva i catyi ra Ndyoo sihin ñiyɨvɨ ta sa naha. I catyi ra: “Ma cahñi ndo sii ñiyɨvɨ. Yoo ra cua cahñi sii minoo ñiyɨvɨ, tahan si sa cutuñi ra.” ");
INSERT INTO mihNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Zoco yuhvi catyi sihin ndo tatu cuxaan ndo sihin minoo ñiyɨvɨ, tahan si sa tasi tuñi ra Ndyoo sii ndo. Ta tatu cahan cuehe ndo sii minoo ñiyɨvɨ, tahan si sa tasi tuñi ra cu tyiño sii ndo. A tatu catyi ndo vatyi laa xaan minoo ñiyɨvɨ, coto vaha ndo coto cuhun ndo andyaya. ");
INSERT INTO mihNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yucuan cuenda quɨvɨ cuhun vehe ñuhu ta ndohon ofrenda sa cua cuhvon sii ra Ndyoo, tatu nacohon iñun vatyi iyo sa zavohon sii inga ñiyɨvɨ ");
INSERT INTO mihNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","zandoon sa cua cuhvon sii ra Ndyoo yucuan. Ta cuhun xihnon ta ndacon tucahnu iñi sii ñu cuan, ta nacoo vohon sihin ñu, ta zɨquɨ cuhun ta cuhvon ofrendon sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tatu iyo ra sica cuatyi sohon, ta cuahan ra suhun nu ndyaa juez, nducun cuhva nacoo vohon sihin ra ityi cuahan ndo coto nacuhva cuenda ra suun sii ra juez. Ta ra juez cua nacuhva cuenda suun sii policía, ta cua tyihi ra cuan suun vehe caa. ");
INSERT INTO mihNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ta sa ndisa catyi suhun vatyi tatu tacuan cua cuu, ma quiton ndya tyiyahvun tandɨhɨ sa tahan si tyiyahvun. ");
INSERT INTO mihNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Sa siñi maa ndo tuhun i catyi ra Ndyoo ta sa naha vatyi ma cuu coo inga ñaha ndo ta ma cuu coo inga yɨɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Zoco yuhvi catyi sihin ndo vatyi tatu ndyehe ndo sii minoo ñaha ta cuñi ndo sii ña, sa zavaha ndo cuatyi sa cuu adulterio sihin ña sisi añima ndo cuu si cuhva cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ta tatu ndyehe ndo minoo sa ndyehe ndo ta sa cuenda si ta cuñi xaan ndo zavaha ndo sa ña vaha, ma ndyehe ca ndo sii si coto coo cuatyi ndo ta cuhun ndo andyaya. ");
INSERT INTO mihNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A tatu iyo sa tuhva ndo zavaha sihin ndaha ndo ta sihin si cuan quisaha coo cuatyi ndo, ma zavaha ca ndo sii si inga saha coto cuhun ndo andyaya. ");
INSERT INTO mihNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ta catyi tucu Tuhun Ndyoo sihin ñiyɨvɨ ta sa naha: “Yoo ra cuñi zandoo sii ñazɨhɨ, cuñi si sa nducu ra cuhva tani tutu ñu sihin ley.” ");
INSERT INTO mihNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Zoco yuhvi catyi sihin ndo vatyi tatu iyo minoo ra cua nducu ra cuhva tani tutu ra sihin ñazɨhɨ ra ta ñahñi cuatyi ña iyo sihin inga rayɨɨ, zoco cua coo cuatyi adulterio sii ña tatu zandoo yɨɨ ña sii ña ta quihin ña sii inga rayɨɨ. Ta ra cua tindaha sihin minoo ñaha zandoo yɨɨ sii, zavaha tucu maa ra cuatyi adulterio cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ta sito tucu ndo vatyi i catyi ra Ndyoo sihin ñiyɨvɨ ta sa naha vatyi tatu sa tyiñaha ñu Ndyoo, cuñi si sa zavaha ñu cuhva catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Zoco yuhvi catyi sihin ndo vatyi ma cuaha xaan cahan ndo tatu cuñi ndo sa cua sino iñi ñiyɨvɨ sa cahan ndo. Ma catyi ndo: “Sito vaha Ndyoo.” Ma cahan ndo tuhun andɨvɨ vatyi yucuan cuu nu ndyaa maa ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma cahan ndo tuhun ñuu ñiyɨvɨ vatyi yucuan cuu nu sañi saha ra. Ta nu tuhun ñuu Jerusalén ta ma cahan ndo vatyi yucuan cuu ñuu ra Ndyoo, ra rey cahnu. ");
INSERT INTO mihNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ta nu tuhun xiñi ndo ta ma catyi ndo, vatyi maa ndo ta ma cuu zanducuisi ndo a zandutoon ndo numinoo ixi xiñi ndo sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Cuenda catyi ñi ndo: “Ndisa.” A catyi ndo: “Yɨvɨ.” Ta ñahñi ca sa cua cahan ndo. Tatu ñaa ca sa tuhva ndo cahan, zañaha si vatyi ña ndisa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Sa siñi tucu ndo cuhva i tyaa ra Moisés ta sa naha nu catyi si vatyi tatu cañi ñiyɨvɨ sii ndo ta zatɨvɨ ñu minoo sɨtɨ nuu ndo cuñi tucu si sa zatɨvɨ minoo ra cu tyiño sɨtɨ nuu ñu. A tatu coco ñu minoo noho ndo, zuun ñi sihin cuhva cuan cua ndoho maa ñu, ta cua quita minoo noho ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Zoco yuhvi catyi sihin ndo: Ma zavaha ndo sa ña vaha sihin ñiyɨvɨ zavaha sa ña vaha sihin ndo. Tatu iyo ra cati minoo siyo xɨtun, cuhva ndɨhun inga siyo nacati ra. ");
INSERT INTO mihNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A tatu iyo ra tyaa cuatyi saton nuu ra cu tyiño ta ñahñi cuatyun ta cuñi ra quindyaa ra camison, cuhva ndɨhun siqueton sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A tatu yoo ra zañiñi suun sa cuizon carga ra minoo kilómetro, cuizon sii si uu kilómetro. ");
INSERT INTO mihNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Cuhvon sii yoo ra sica suun, ta tatu cua caca noo ñiyɨvɨ sa suun, ma catyun vatyi ma cuhvon. ");
INSERT INTO mihNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ta sa siñi ndo cuhva tuhva ñiyɨvɨ catyi vatyi catyi ñu vatyi nacuñi xaan yo sii ra tahan yo, ta nacuxaan xaan yo ndyehe yo sii ra xaan iñi sii yo. ");
INSERT INTO mihNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Zoco yuhvi catyi sihin ndo vatyi cuñi ndo sii ñu xaan iñi sii ndo. Vaha cahan ndo sihin ñiyɨvɨ cahan ndya vaha ñi sihin ndo. Zavaha ndo sa vaha sihin ñiyɨvɨ ña cuu ndyehe sii ndo. Ta cahan ndo sihin ra Ndyoo cuenda ñiyɨvɨ cahan cuehe sii ndo ta ñu zavaha sa ña vaha sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tatu zavaha ndo tacuan, cua cuu ndo zehe ra Ndyoo Zutu yo sa ndisa cuii, ra ndya andɨvɨ, vatyi maa ra i tyaa ñicandyi, ta zandisi si nu yucu ñiyɨvɨ ña vaha ta ñiyɨvɨ vaha. Ta zacoon ra zavi zɨquɨ ñu vaha ta zɨquɨ ñu ña vaha. ");
INSERT INTO mihNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tatu ɨɨn ñi sii ñiyɨvɨ cuñi sii ndo cuñi tucu ndo, ñahñi sa vaha zavaha ndo cuhva cuan vatyi tacuan tucu zavaha ñiyɨvɨ quiñi iyo tañi ra tava xuhun cuenda ra ndyaca ñaha. (Ta quiñi xaan iyo ra cuan cuñi maa ndo.) ");
INSERT INTO mihNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ta tatu saha ndo ndyoo nacucumi ɨɨn ñi sii ra tahan ndo, ¿ñaa sa vaha zavaha ndo cuhva cuan? Ndya ñiyɨvɨ ña sito sii ra Ndyoo ta cahan ñu sihin tahan ñu cuhva cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Cuu ndo ñiyɨvɨ ñahñi maa cuatyi. Tañi Zutu yo, ra ndyaa andɨvɨ, vatyi ñahñi maa cuatyi ra iyo caña ñi. ");
INSERT INTO mihNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ma zavaha ndo sa vaha nuu ñiyɨvɨ ñi vatyi cuñi ndo sa ndyehe ñu. Tatu tacuan zavaha ndo, ñahñi sa cua cuhva Zutu yo, ra ndyaa andɨvɨ, sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yucuan cuenda tatu tyindyee ndo sii ñu ndahvi, ma nacatyi ndo sihin tandɨhɨ ñiyɨvɨ tañi zavaha ra sahan vehe ñuhu ta nuyahvi ta zaha ra tuhun vatyi vaha xaan ra. Zavaha ra sa vaha vatyi cuñi ra sa cua zacahnu ñiyɨvɨ sii ra. Ta sa ndisa catyi sihin ndo vatyi sihin sa yucuan ñi ta sa ñihi ra sa vaha. Ñahñi ca sa cua cuhva maa ra Ndyoo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Zoco tatu zavaha maa ndo tumañi iñi sii ñiyɨvɨ ndahvi, xehe ñi zavaha ndo sii si, minoo cuhva sa ma coto nu amigo ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Xehe ñi tyindyee ndo sii ñiyɨvɨ ndahvi. Ta cua ndyehe ra Ndyoo Zutu yo cuhva zavaha ndo sa xehe ñi, ta cua cuhva maa ra sa vaha sii ndo sa cuenda si. ");
INSERT INTO mihNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ta tatu cua cahan ndo sihin ra Ndyoo, ma cuu ndo tañi ra zaha tuhun vatyi vaha xaan ra, ta ña ndisa ra vatyi tahan iñi ra cahan ra sihin ra Ndyoo nu tuu ñiyɨvɨ vatyi cuñi ra sa cua ndyehe ñu. Yucuan cuenda cua cuɨñɨ ndyaa ra sisi vehe ñuhu a ityi cahnu ta cahan ra sihin ra Ndyoo. Sa ndisa catyi sihin ndo vatyi sihin sa ndyehe ñiyɨvɨ sii ra sihin sa zavaha ra, ta sa ñihi ra sa cua ñihi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Zoco tatu cua cahan maa ndo sihin ra Ndyoo, quɨhvɨ ndo nu yoñi ndyehe, ta nacazi ndo yuvehe ta cahan ndo sihin ra Ndyoo Zutu yo sa maa ñi maa ndo. Cua ndyehe maa ra cuhva zavaha ndo sa xehe ñi, ta cua cuhva ra sa vaha sii ndo sa cuenda si. ");
INSERT INTO mihNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Cuhva cahan ndo sihin ra Ndyoo ma cahan ndo zuun ñi sa cahan ndo uu a uñi saha tañi zavaha ñiyɨvɨ ña sito sii ra Ndyoo. Sica iñi ñu vatyi cua cuɨñɨ ra Ndyoo sa cahan ñu tatu cuaha xaan cahan ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma cuu ndo tañi maa ñu vatyi sa sito ra Ndyoo Zutu yo ñaa sa siñi ñuhu sii ndo cuee ca sa caca ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yucuan cuenda cahan ndo sihin ra Ndyoo tyehen: Ndyoo Zutu ndi, ra ndyaa andɨvɨ, ii xaan cuu zɨvɨ moo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nasaa quɨvɨ cua cundyaca ñohon ihya ñuu ñiyɨvɨ. Nazavaha ñiyɨvɨ cuhva cuñi moo ihya ñuu ñiyɨvɨ tañi cuu si ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cuhvon sa siñi ñuhu sii ndi minoo minoo quɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ta zohon tucahnu iñi sii ndi sa cuenda cuatyi ndi tañi maa ndi zaha ndi tucahnu iñi sii ñiyɨvɨ zavaha sa ña vaha sihin ndi. ");
INSERT INTO mihNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma cuhvon sa nducu coto ihñi cuihna sii ndi coto zavaha ndi sa ña vaha. Vatyi moo cuu ra ndyaca ñaha, ta moo cuu ra iyo xaan tundyee iñi sii, ta tahan si zacahnu tandɨhɨ ñiyɨvɨ suun tandɨhɨ cuii tyiemvu. Ta nacuu si sa ndisa. Tacuan cahan ndo sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Vatyi tatu zaha maa ndo tucahnu iñi sii ñiyɨvɨ zavaha sa ña vaha sihin ndo, tacuan tucu cua zavaha Zutu yo ra ndyaa andɨvɨ. Cua zaha ra tucahnu iñi sii maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Zoco tatu ma zaha maa ndo tucahnu iñi sii inga ñiyɨvɨ, ma zaha tucu Zutu yo tucahnu iñi sii maa ndo, ta ma zandasi ra cuatyi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ta zɨquɨ i catyi ra Jesús sihin ñiyɨvɨ: Quɨvɨ ma casi ndo ta cahan ndo sihin ra Ndyoo, ma zanducuihya ndo iñi ndo tañi zavaha ñiyɨvɨ zaha tuhun vatyi vaha xaan ñu. Ta ma cahyi ndo ñiyaa nuu ndo tañi zavaha maa ñu. Tacuan zavaha ñu vatyi cuñi ñu sa cua ndyehe ñiyɨvɨ sii ñu ta nacoto ñu vatyi ña sasi ñu. Zoco catyi sihin ndo vatyi ñahñi cua ñihi ñu sihin ra Ndyoo vatyi yɨvɨ sa cuenda maa ra zavaha ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Zoco maa ndo tatu ñaa quɨvɨ cua coo ndyitya ndo ta cahan ndo sihin ra ndyoo, nacatya ndo nuu ndo, ta tyihi ndo xahan xiñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tacuan zavaha ndo vatyi ma coto ñiyɨvɨ vatyi ñá sasi ndo. Minoo tuhun ñi maa ra Ndyoo cua ndyehe cuhva zavaha ndo, ta cuaha sa vaha cua cuhva ra sii ndo ta cua ndyehe ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ma zacaya xaan ndo xuhun a ndaha tyiño ndo ihya ñuu ñiyɨvɨ coto tɨvɨ si a coto zatɨvɨ tiquixi sii si. Ta coto quɨhvɨ ra zuhu ta quihin ra sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Vaha ca tatu zacaya ndo ndaha tyiño ndo ndya andɨvɨ vatyi yucuan ma zatɨvɨ tiquixi sii si. Ta ma tɨvɨ si. Ta ma cuu quɨhvɨ ra zuhu ta quihin ra sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Vatyi catyi sihin ndo vatyi nu ndyaa sa cuca ndo, yucuan cuu nu ndyaa añima ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Sɨtɨ nuu ndo cuu tañi minoo sa zandisi sii ndo. Ta tacuan tucu añima ndo, tatu maa ñi sa vaha ra Ndyoo iyo añima ndo, vaha ñiyɨvɨ cuu ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Zoco tatu ña vaha sɨtɨ nuu ndo, ñahñi sa zandisi nu cuahan ndo. Ta zuun ñi cuhva cuan, tatu ñahñi sa ndisi ra Ndyoo iyo añima ndo, a tatu iyo si zoco ña tyaa ndo yahvi sii si, cuaha xaan cuatyi ndo iyo, ta sica noo ndo nu ñaa. ");
INSERT INTO mihNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ma cuu zatyiño minoo muzu sa cuenda uu tahan patrón vatyi cua cuñi ca ra sii minoo patrón ra, ta ma cuñi ca ra sii inga ra. A sii minoo ra cua tyaa ra yahvi, ta sii inga ra ma tyaa ra yahvi. Ma cuu cuñi ndo sii ra Ndyoo ta cuñi ndo sii xuhun. ");
INSERT INTO mihNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ta i catyi tucu ra Jesús: Yucuan cuenda catyi sihin ndo, ma caca xaan iñi ndo yozo caa cua ñihi ndo sa casi ndo ta sa coho ndo ñuu ñiyɨvɨ ya. Ta ma caca xaan iñi ndo yozo caa cua ñihi ndo zahma quɨhɨ ndo. Zoco nuu ra Ndyoo ñiñi ca añima ndo ta coño ñuhu ndo ta zɨquɨ sa casi ndo ta sa ndɨhvɨ ndo. Maa ra saha sa ndito ndo, ta cua cuhva ra tandɨhɨ sa siñi ñuhu sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ndyehe ndo cuhva iyo zaa sa sica noo ityi zɨquɨ. Ña tasi tɨ. Ña zatyiño tɨ. Ñahñi nu naquihin vaha tɨ tyiño zacuu tɨ, ndɨhɨ ca. Zoco sasi tɨ vatyi maa ra Ndyoo zacasi sii tɨ. Ta ñiñi xaan ca cuu maa ndo ityi nuu ra Ndyoo ta zɨquɨ zaa cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Ta yoo ndo cuu nduzucu ca ndo siin ca tatu caca xaan iñi ndo sa cuenda si? Ma cuu ca. ");
INSERT INTO mihNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Ta ñaa cuenda sica xaan iñi ndo sa cuenda zahma ndo? Ndyehe ndo cuhva sahnu ita sisi cuhu vatyi ña tavi si, ta ña cono si iza. ");
INSERT INTO mihNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Zoco catyi sihin ndo vatyi cuca xaan ra rey Salomón ta tyaqui xaan zahma ra, zoco ña tyaqui ca si ta zɨquɨ minoo ita cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ta tatu zandutyaqui xaan ra Ndyoo sii tu‑ita sa iyo vityi ta ityaan cua nduu tu nducu ta cayu tu, tyaqui xaan tucu zahma cua cuhva ra sii maa ndo. Zoco maa ndo ña sino vaha iñi ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yucuan cuenda catyi sihin ndo: Ma caca xaan iñi ndo ta catyi ndo: “¿Ñaa sa cua casi ndi? ta ¿naa sa cua coho ndi? ta ¿yozo caa ñihi ndi zahma quɨhɨ ndi?” ");
INSERT INTO mihNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vatyi sica xaan iñi ñiyɨvɨ ña sito sii ra Ndyoo sa cuenda tandɨhɨ si cuan. Zoco maa Zutu mañi yo sa sito ra vatyi siñi ñuhu tandɨhɨ si cuan sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Vaha ca nducu ndo cuhva yozo caa cua cuhva cuenda ndo sii ndo sii ra Ndyoo vatyi cundyaca ñaha ra sii ndo ta maa ñi sa vaha xaan zavaha ndo tañi zavaha maa ra, ta tacuan ta cua cuhva ra tandɨhɨ sa siñi ñuhu sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Zacuenda maa ra Ndyoo sii ndo vityi ta ityaan, ndɨhɨ ca. Yucuan cuenda ma caca xaan iñi ndo sa cuenda sa cua cuñi si sii ndo ityaan. Caca iñi ndo vityi ɨɨn ñi sa cuenda sa siñi ñuhu sii ndo vityi. ");
INSERT INTO mihNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ma cahan cuehe ndo sii ñiyɨvɨ coto catyi tucu ra Ndyoo vatyi ña vaha zavaha tucu maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Vatyi cuhva ndyehe maa ndo sii inga ñiyɨvɨ, tacuan tucu cua ndyehe ra Ndyoo sii ndo. Ta tatu tyaa ndo cuatyi sata ñiyɨvɨ, zuun ñi cuhva cuan cua tyaa ra Ndyoo cuatyi sata maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Yozo caa vatyi cuu ndyehe ndo cuatyi luhlu ñi sa iyo sii inga ñiyɨvɨ ta tañi minoo mihin luhlu ñi sa ñoho sɨtɨ nuu ñu cuu si? Ta ña ndyehe ndo cuatyi cahnu xaan sa iyo sii maa ndo, ta cuu si tañi minoo mihin cahnu sa ñoho nuu maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ta ñaa cuenda catyun sihin yañun vatyi nacuhva ra sa tavon mihin luhlu sa ñoho sɨtɨ nuu ra, ta ña tuu iñun sa ñoho minoo mihin cahnu sɨtɨ nuu moo. ");
INSERT INTO mihNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Cuhva cuan, zohon tuhun vatyi vaha xoon, ta ña ndisa. Tava xihnon mihin sa ñoho sɨtɨ nuu moo, ta zɨquɨ cua ndundisi ndyehun, ta cua cuu tavon mihin luhlu sa ñoho sɨtɨ nuu yañun. ");
INSERT INTO mihNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ta ma zañiñi ndo ta cahan ndo Tuhun Ndyoo sihin ñiyɨvɨ ña cuñi coto, coto cañi ñu sii ndo. Tañi ina cuu ñiyɨvɨ ña cuñi Tuhun Ndyoo. Ta tañi zatɨvɨ quɨnɨ sii sa vaha, tacuan tucu iyo maa ñu. Cua cahan ñu ndya vaha ñi sii Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Caca ndo sii ra Ndyoo, ta cua cuhva ra sa sica ndo. Nanducu ndo, ta cua nañihi ndo. Cati ndo yuvehe, ta cua nuña si. ");
INSERT INTO mihNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Vatyi tandɨhɨ ndoho ra sica, cua ñihi ndo. Ta tatu nanducu ndo, cua nañihi ndo. Ta tatu cati ndo yuvehe, cua nuña si. ");
INSERT INTO mihNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Maa ndo ra cu zutu sa ndyihi, tatu cua caca zehun minoo pan, ¿atu cua cuhva ndo minoo yuu sii ra? Ña tacuan. ");
INSERT INTO mihNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","A tatu cua caca ra minoo tyiyaca, ¿atu cua cuhva ndo minoo coo? ");
INSERT INTO mihNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ñiyɨvɨ quiñi cuu maa ndo, zoco sito ndo yozo caa cuhva ndo sa vaha sii zehe ndo, vaha xaan ca cua zavaha Zutu yo, ra ndyaa andɨvɨ. Cua cuhva ra sa vaha sii ñiyɨvɨ sica sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ta tatu cuñi ndo sa cua zavaha ñiyɨvɨ sa vaha sihin maa ndo, tacuan zavaha tucu maa ndo sihin maa ñu tandɨhɨ saha vatyi yucuan cuu sa catyi ley ra Moisés ta libro i tyaa ra profeta ta sa naha. ");
INSERT INTO mihNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Nducu ndo cuhva quɨhvɨ ndo yuvehe tɨhɨn vatyi quɨhɨn yuvehe ta quɨhɨn ityi sa cuahan nu cunaa ñiyɨvɨ andyaya. Ta cuaha xaan ñiyɨvɨ cuahan ityi cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Zoco tɨhɨn yuvehe ta cuɨñɨ ityi sa cuahan nu ma cuu ca ñiyɨvɨ, ta zuhva cuii ñi ñiyɨvɨ cua nañihi ityi cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Zacuenda ndo sii ndo sihin ra vatya ta catyi ra vatyi cahan ra sa cuenda ra Ndyoo. Vasi ra tañi minoo mvee ticatyi, zoco añima ra ñoho sa quiñi caa. ");
INSERT INTO mihNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Cuu nacoto ndo sii ra sa cuenda cuhva zavaha ra. Tañi yutu ña vaha, tacuan iyo ra vatyi minoo tu mihndya ma cuu cuhva tu mango. Ta minoo iñu ma cuhva tu uva. ");
INSERT INTO mihNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ta tacuan cuu si. Tandɨhɨ yutu vaha, saha tu sɨtɨ vaha. Ta tandɨhɨ yutu ña vaha, ña vaha sɨtɨ tu. ");
INSERT INTO mihNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Minoo yutu vaha, ma cuu cuhva tu sɨtɨ ña vaha. Ta minoo yutu ña vaha, ma cuu cuhva tu sɨtɨ vaha. ");
INSERT INTO mihNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ta tandɨhɨ yutu sa ña saha sɨtɨ vaha, tuhva ñiyɨvɨ cahndya sii tu, ta cayu tu. ");
INSERT INTO mihNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ta zuun ñi sihin cuhva cuan, cuu nacoto yo sii ñiyɨvɨ sihin cuhva zavaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ña tandɨhɨ ñiyɨvɨ sa catyi sihin: “Zutu mañi yuu, Zutu mañi yuu”, cuu quɨhvɨ ñu nu ndyaca ñaha ra Ndyoo andɨvɨ. Maa ñi ñiyɨvɨ zavaha cuhva cuñi ra Ndyoo Zuti, cuu quɨhvɨ ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Quɨvɨ cua tasi tuñi ra Ndyoo sii ñiyɨvɨ, cuaha xaan ñu cua catyi tyehen sihin: “Zutu mañi yuu, nduhvi i cahan ndi sihin zɨvɨ moo, ta sihin zɨvɨ moo tava ndi tatyi ña vaha, ta i zavaha ndi cuaha xaan sa ndyityi.” Cua catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Zoco yuhvi cua catyi: “Ña site sii ndo. Cuɨnɨ siyo ndo sii, ta cuahan ndo vatyi ñá zavaha ndo sa vaha sa i catyi sihin ndo.” ");
INSERT INTO mihNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tyehen catyi sihin ndo, tatu yoo ra tyizoho sa quehin ta zavaha ra sii si, cuu ra tañi minoo ra siñi tuñi vaha. Cono xaan i sitya ra ndya tahan ra minoo yuu cahnu, ta i zandaa ra vehe ra zɨquɨ yuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ta i coon xaan zavi, ta i cucono yuu. Ta ñihi xaan i ñoho tatyi, zoco ñá nduva vehe cuan vatyi i zandaa ra sii si zɨquɨ yuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Zoco ra siñi sa quehin ta ña zavaha ra sii si, cuu ra tañi minoo ra tondo xaan, ra i zandaa vehe nu ñiyɨtɨ ñi. Ñá zavaha ra cimiento si. ");
INSERT INTO mihNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ta i coon zavi. Ta i cucono yuu, ta ñihi xaan i sicaa tatyi, ta i nduva vehe cuan, ta cua naa si. ");
INSERT INTO mihNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ta nu i ndɨhɨ cahan ra Jesús, iyo xaan i cuñi ñiyɨvɨ sihin cuhva zacuaha ra ");
INSERT INTO mihNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","vatyi zacuaha ra tañi minoo ra ndyaca ñaha. Ñá zacuaha ra tañi ra maestro cuenda ley. ");
INSERT INTO mihNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cuhva i noo ra Jesús yucu cuan, cuaha xaan ñiyɨvɨ i sindyico sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ta i tuhva minoo ra cuhu cuehe tyahyu sii ra Jesús. Ta i sicuɨñɨ sɨtɨ ra nuu ra ta catyi ra: Tata, iyo cuhva suun, ta cuu zanduvohon sii tatu cuñun. ");
INSERT INTO mihNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ta i tyizo ra Jesús ndaha ra xiñi ra, ta i catyi ra: Cuñi. Sa nduvohon. Ta zuun ñi caa cuhva cuan, i quita cuehe cuan sii ra, ta ndaha nduvaha ñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ta i catyi ra Jesús sihin ra: Ndyehun vatyi ma nacatyun sihin numinoo ñiyɨvɨ. Cuhun nu ndyaa ra cu zutu, ta cuhvon ofrenda sii ra Ndyoo tañi i catyi ra Moisés cua cuhva ñiyɨvɨ tatu sa nduvaha ñu. Ta tacuan ta cua coto tandɨhɨ ñiyɨvɨ vatyi sa i nduvohon. ");
INSERT INTO mihNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","I quɨhvɨ ra Jesús ñuu Capernaum, ta minoo ra ndyaca ñaha sii minoo ziendu zandaru i tuhva sii ra ta i sica ra tumañi iñi sii ra, ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tata, cuhu xaan minoo ra luhlu, ra cu muzi. Catuu ra, ta sa cuñi xii ra, ta ndyehe xaan ra tundoho. ");
INSERT INTO mihNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ta i catyi ra Jesús sihin ra: Cua cuhin, ta cua zanduvehi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ta i nacahan ra ndyaca ñaha sii zandaru cuan, ta i catyi ra: Ña tahan si sa cuhun vehi vatyi ra cahnu xaan ca cuu moo. Tatu cua catyi moo vatyi cua nduvaha muzi, cua nduvaha ra. ");
INSERT INTO mihNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Vatyi zuun ñi iyo tucu ra ndyaca ñaha sii, ta iyo tucu zandaru ra ndyaca ñehi. Tatu catyi sihin minoo ra vatyi cuhun ra, cuhun ra. Ta tatu catyi sihin inga ra vatyi quisi ra, cua quisi ra. Ta tatu ñaa tyiño tave sii minoo muzi, zavaha ra sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tacuan i catyi ra, ta sa siñi ra Jesús cuhva cahan ra, iyo xaan i cuñi ra, ta i catyi ra sihin ñiyɨvɨ ndyico sii ra: Catyi sihin ndo vatyi tañaha ca nañihi sii minoo ra hebreo ra sino iñi sii ra Ndyoo tañi sino iñi ra ya. ");
INSERT INTO mihNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ta catyi sihin ndo vatyi cua quisi cuaha xaan ñiyɨvɨ ndya ityi caña ñicandyi ta ndya ityi cua iñi, ta cua cundyaa ñu ta casi ñu sihin ra Abraham, ta ra Isaac ta ra Jacob nu ndyaca ñaha ra Ndyoo andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Zoco ñiyɨvɨ i tahan si cuhun yucuan, ma cuu cuhun ñu. Cua tyihi ra Ndyoo sii ñu minoo nu ñaa nu cua vacu xaan ñu, ta cua casi quihñi noho ñu sa cuenda tundoho sa ndyehe ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ta zɨquɨ i catyi ra Jesús sihin ra ndyaca ñaha sii zandaru: Cuahan ndya vehun vatyi cuu si tañi cuhva sino iñun. Tacuan i catyi ra Jesús, ta zuun ñi caa cuhva cuan i nduvaha muzu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Cuahan ra Jesús ndya vehe ra Pedro, ta yucuan i ndyehe ra sii tyizo ra Pedro. Catuu ña nu sito. Cuhu ña sihin cahñi. ");
INSERT INTO mihNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","I tɨɨn ra Jesús ndaha ña, ta i quita cahñi cuan. Ta i nduvita ña, ta i quisaha zavaha ña sa casi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Sa tyizo ñicandyi, ta sa tyahan cuan i quisi ndyaca ñiyɨvɨ sii cuaha xaan ñu ñoho tatyi cuihna nu ndyaa ra Jesús. Ta i tava ra tatyi ña vaha cuan sihin minoo ñi tuhun cahan ra, ta i zanduvaha tucu ra sii tandɨhɨ ñu cuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tacuan i cuu si vatyi cua quita si cuhva i catyi ra Isaías; minoo ra profeta i cuu ra ta sa naha. Tyehen i catyi ra: “I quindyaa ra cuehe yo, ta i zanduvaha ra sii yo.” ");
INSERT INTO mihNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ta cuhva sa ndyehe ra Jesús vatyi cuaha xaan ñiyɨvɨ siconduu cuii yucu ñu sihin ra, i catyi ra vatyi cua yaha ra inga siyo miñi. ");
INSERT INTO mihNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ta i tuhva minoo ra maestro cuenda ley sii ra Jesús, ta i catyi ra sihin ra: Maestro, cuñi cundyique suun vazu ndya ndya maa cuohon. ");
INSERT INTO mihNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ta i catyi ra Jesús sihin ra: ¿Atu cundyee iñun? vatyi ñicuii ca ta iyo vehe tɨ, ta zaa iyo taca tɨ. Zoco ra i quisi ndya gloria, ñahñi maa vehe ra iyo. ");
INSERT INTO mihNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ta zɨquɨ inga ra ndyico sii ra Jesús, i catyi ra sihin ra: Tata, cua cundyique suun, zoco cuatu noo ndya nacuu xihna zuti ta zɨquɨ cua cundyique suun. ");
INSERT INTO mihNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ta i catyi ra Jesús sihin ra: Yoho cundyicon sii vityi, ta natyihi ñiyɨvɨ ña sito sii ra Ndyoo sii tahan sihi sihin ñu sisi ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tacuan ta i quɨhvɨ ra Jesús minoo barco sihin ra i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ta i quisaha caa minoo tatyi ñihi xaan ndya cuhva ndya cuñi zahvi ndutya sii barco cuan. Ta quixi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ta sahan ra sica noo sihin ra, ta i zandoyo ra sii ra, ta catyi ra sihin ra: ¡Tata, zacacun sii yo; sa cuñi cunaa yo! ");
INSERT INTO mihNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ta i nacahan ra Jesús, ta catyi ra: ¿Ñacu yuhu xaan ndo? Zuhva cuii ñi sino iñi ndo. Catyi ra. Tacuan ta i nduvita ra, ta i cahan ra sihin tatyi ta sihin ndutya, ta i cutaxi si. ");
INSERT INTO mihNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ta iyo xaan i cuñi ra ndɨhɨ sihin ra, ta catyi ra: ¿Yoo ra cuu ra ya? vatyi cuhva ndya tatyi ta cuhva ndya ndutya ta tyaa si yahvi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ta cuhva sa i saa ra Jesús inga siyo miñi cuan ndya nu cu si Gadara, i quita uu tahan ra nu ñaña, ta i tuhva ra sii ra. Ñoho tatyi cuihna sii nduu tahan ra cuan, ta xaan xaan ra ndya cuhva yoñi cuu yaha ityi cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ta i quisaha cana saa ra, ta catyi ra: ¿Ñaa sa cuñun sihin ndi, yoho Jesús zehe ra Ndyoo? ¿Atu vasi zandyehun tundoho sii ndi cumañi ca sa tahan si quɨvɨ? ");
INSERT INTO mihNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tacuan i zacahan cuihna sii ra cuan. Ta yatyi ñi yucuan sica noo cuaha xaan quɨnɨ. Sasi tɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ta i sica tatyi cuihna cuan tumañi iñi sii ra Jesús vatyi tatu cua tava ra sii si, naquɨhvɨ si sisi quɨnɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ta i catyi ra Jesús sihin si: Vaha, cuahan ndo. Ta i quita tatyi cuihna sii nduu tahan rayɨɨ cuan, ta i quɨhvɨ si sisi quɨnɨ cuan. Ta zɨquɨ tandɨhɨ quɨnɨ cuan, i sino tɨ nu iñi noo yuhu miñi, ta i sihi tandɨhɨ tɨ sisi ndutya. ");
INSERT INTO mihNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ta ra zacuenda quɨnɨ cuan, i sino ra, ta cuahan ra ndya ñuu, ta i nacatyi ra sihin ñiyɨvɨ tandɨhɨ sa i tahan ra siñoho tatyi cuihna cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ta zɨquɨ i quita tandɨhɨ ñiyɨvɨ ñuu cuan, ta cuahan ñu nu ndyaa ra Jesús vatyi cuñi ñu ndyehe ñu sii ra. Ta sa ndyehe ñu sii ra, i zañiñi ñu sii ra sa naquita ra ñuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","I quɨhvɨ ra Jesús sisi minoo barco, ta i yaha ra ta saa ra inga siyo miñi, ta i saa ra zuun ñi ñuu maa ra. ");
INSERT INTO mihNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ta i sindyaca ñiyɨvɨ sii minoo ra cuhu nu ndyaa ra Jesús. Ndyizo ra sii ra cuan sihin minoo tyuhva. Ta sa ndyehe ra Jesús cuhva sino xaan iñi tandɨhɨ ra, ta i catyi ra sihin ra cuhu cuan: Ra luhlu, ma nducuihya iñun. Sa ndasi cuatyun. ");
INSERT INTO mihNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tacuan ta zuhva ra maestro cuenda ley, i sica iñi ra: “Quiñi xaan cahan ra ya sii ra Ndyoo.” (Vatyi zaha ra Jesús tuhun vatyi Ndyoo cuu ra, cuñi ra cuan.) ");
INSERT INTO mihNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ta ra Jesús i sito ra ñaa sa sica iñi ra, ta i catyi ra sihin ra cuan: ¿Ñaa cuenda sica iñi ndo minoo cuhva ña vaha? ");
INSERT INTO mihNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ñaa sa yɨɨ ca catyi yo? ¿Atu yɨɨ ca catyi yo: “Sa ndasi cuatyun”, a yɨɨ ca catyi yo: “Nduviton ta cacon”? (Ña yɨɨ catyi yo: “Sa ndasi cuatyun.” Vatyi yɨvɨ sa ndyehe yo cuu cuhva cuan. Ma coto ñiyɨvɨ tatu ndisa a ña ndisa. Zoco cua ndyehe ñu tatu zanduvaha yo sii minoo ñiyɨvɨ sa ndisa.) ");
INSERT INTO mihNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Cua zañehi sii ndo vatyi iyo cuhva sii vii, ra i quisi ndya gloria, sa zandasi cuatyi ñiyɨvɨ ñuu ñiyɨvɨ. Ta zɨquɨ i catyi ra Jesús sihin ra xii: Nduviton. Nacuhun tyuhvon, ta cuhun ndya vehun. ");
INSERT INTO mihNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tacuan ta i nduvita ra xii cuan, ta cuahan ra ndya vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ta sa ndyehe ñiyɨvɨ cuhva cuan, i yuhu xaan ñu, ta i zacahnu xaan ñu sii ra Ndyoo vatyi i saha xaan ra cuhva sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","I quita ra Jesús yucuan, ta i ndyehe ra sii minoo ra nañi Mateo. Ndyaa ra nu zatyiyahvi ra sii ñiyɨvɨ cuenda xuhun ra ndyaca ñaha. Ta i catyi ra sihin ra: Coho sihin. Tacuan ta i nduvita ra Mateo, ta cuahan ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yaha zuhva quɨvɨ ta sahan ra Jesús sa casi ra xita vehe ra Mateo. Ta ɨɨn ñi sihin ra Jesús ta sihin ra sica noo sihin ra sasi cuaha xaan ra tava xuhun cuenda ra ndyaca ñaha ta inga ra iyo cuatyi. ");
INSERT INTO mihNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ta sa ndyehe ra fariseo cuhva cuan, i ndaca tuhun ra sii ra sica noo sihin ra Jesús ta catyi ra: ¿Ñaa cuenda sasi ra maestro ndo sihin ra tava xuhun ta sihin inga ra iyo cuatyi? ");
INSERT INTO mihNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ta i siñi ra Jesús tuhun cuan, ta i catyi ra: Ñiyɨvɨ iyo vaha, ña siñi ñuhu minoo médico sii ñu, zoco sii ñu cuhu siñi ñuhu médico. ");
INSERT INTO mihNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cuhun ndo ta cutuhva ndo cuhva catyi si nuu tutu ra Ndyoo nu catyi si tyehen: “Cuñi sa cua cundahvi iñi ndo sii ñiyɨvɨ, ta ma zañiñi xaan ndo sa cahñi ndo quɨtɨ sa cuenda cuatyi ndo.” Vatyi ña vasi cane sii ñiyɨvɨ vaha, vasi cane sii ñu iyo cuatyi vatyi cuñi sa cua zama ñu cuhva iyo ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tacuan ta ra ndyico sii ra Juan, ra zacoo ndutya sii ñiyɨvɨ, i tuhva ra sii ra Jesús, ta i ndaca tuhun ra sii ra: ¿Ñaa cuenda vatyi maa ndi ta ra fariseo tuhva xaan ndi coo ndyitya, ta ra sica noo sihin moo, ña tuhva ra? ");
INSERT INTO mihNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ta i nacahan ra Jesús ta catyi ra: ¿Atu cuu sa ma casi ñu ñoho minoo vico tindaha nɨɨ ñi sa ndyaa ra i tindaha sihin ñu? Ma cuu. Zoco cua saa quɨvɨ cua cuhun ra i tindaha, ta zɨquɨ ndisa vatyi ma casi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tacuan i catyi ra Jesús, ta zɨquɨ i cahan ra zɨquɨ inga cuhva ta catyi ra: Yoñi ñiyɨvɨ natyaa zuhva zahma saa sii zahma sahnu vatyi cua ndɨyɨ zahma saa cuan, ta cua tahndya ca zahma sahnu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ta inga cuhva, yoñi zavaha ndixi panela saa sisi quɨzɨ sahnu vatyi cua cuizo si ta ndaa si ta cua cahndi quɨzɨ sahnu cuan. Cuñi si quɨzɨ saa tatu zavaha ñiyɨvɨ ndixi panela saa vatyi ma tahvi quɨzɨ cuan, ta ma ndoyo ñuhu ndixi cuan. (I cahan ra Jesús cuhva ya vatyi ma cuu nazaca yo cuhva zacuaha maa ra sihin costumbre sahnu.) ");
INSERT INTO mihNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nɨɨ ñi sa cahan ra Jesús cuhva cuan, ta i saa minoo ra cu tyiño cuenda ñu hebreo, ta i sicuɨñɨ sɨtɨ ra nuu ra Jesús, ta catyi ra: Sa sihi minoo zehi, zoco tatu cua cuhun ndya vehi ta tyizon ndohon sii ña, cua nandoto ña. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ta i nduvita ra Jesús sihin ra sica noo sihin ra, ta cuahan ra sihin ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ta ityi cuahan ra Jesús, i tuhva minoo ñaha sii ra. Sa usi uu cuiya sa cuhun ña, cuehe sa cuu ña nɨñɨ. Ta i quisi ña ityi sata ra Jesús, ta i tɨɨn ña yuzahma ra. ");
INSERT INTO mihNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Vatyi sica iñi ña: “Vazu zahma ñi ra cua tɨin, ta nduvehi.” ");
INSERT INTO mihNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Zoco i nasico cava ra Jesús, ta i ndyehe ra sii ña, ta catyi ra: Cuzɨɨ xaan iñun, zihi. I nduvohon vatyi i sino iñun sii. Ta zuun ñi caa cuhva cuan i nduvaha ña. ");
INSERT INTO mihNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ta cuhva sa saa ra Jesús vehe ra cu tyiño cuan, i ndyehe ra vatyi sa tɨvɨ música, ta cuvaa xaan ñiyɨvɨ, ta sacu saa ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ta i catyi ra sihin ñu: Quita ndo ihya. Ñá sihi ña luhlu ya. Quixi ña. Tacuan i catyi ra, ta i sacu ndyaa ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Zoco i tava ra Jesús sii ñu, ta zɨquɨ i quɨhvɨ ra, ta i tɨɨn ra ndaha ña, ta i nduvita ña. ");
INSERT INTO mihNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ta nacahnu cuii ityi cuan i sito ñiyɨvɨ cuhva i cuu. ");
INSERT INTO mihNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ta sa quita ra Jesús yucuan, i sindyico uu tahan ra cuaa sii ra, ta cana saa ra, ta catyi ra: ¡Cundahvi iñun sii ndi Zehe ra David! ");
INSERT INTO mihNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ta sa yaha quɨhvɨ ra Jesús sisi vehe, i tuhva ra cuaa cuan sii ra. Ta i ndaca tuhun ra Jesús sii ra: ¿Atu sino iñi ndo vatyi cuu zanduvehi sii ndo? Ta i nacahan ra cuan, ta catyi ra: Sino iñi ndi, tata. ");
INSERT INTO mihNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tacuan ta i tɨɨn ra Jesús sɨtɨ nuu ra, ta i catyi ra: Nacuu si tañi cuhva sino iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tacuan i catyi ra Jesús, ta i nduvaha sɨtɨ nuu ra cuan. Ta i nacatyi ra Jesús sihin ra vatyi ma nacatyi ra sihin numinoo ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Zoco cuahan ra ta i nacatyi ra sihin tandɨhɨ ñiyɨvɨ ityi cuan cuhva i zavaha ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ta cuhva sa cua quita ra yucuan, i quisi ndyaca ñiyɨvɨ sii minoo ra ñehe sii ra Jesús. Ñoho minoo tatyi cuihna sii ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","I tava ra Jesús sii tatyi cuihna cuan, ta zɨquɨ i quisaha cahan ra ñehe cuan. Ta iyo xaan i cuñi ñiyɨvɨ, ta i catyi ñu: Tañaha ca ndyehe maa yo ñiyɨvɨ hebreo minoo sa tyehen. ");
INSERT INTO mihNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Zoco i catyi ra fariseo: Ihya ra tava tatyi cuihna sihin tundyee iñi sii ra cu nuu sii cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","I sica noo ra Jesús tahan tahan ñuu nahnu ta ñuu ndyihi. Zacuaha ra sii ñiyɨvɨ sisi vehe ñuhu tahan tahan nu cuahan ra. I nacatyi ra Tuhun Vaha sa cuenda cuhva ndyaca ñaha ra Ndyoo. Ta zanduvaha ra sii ñiyɨvɨ tandɨhɨ cuii nuu cuehe. ");
INSERT INTO mihNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ta sa ndyehe ra sii ñiyɨvɨ, i cundahvi xaan iñi ra sii ñu vatyi ndyehe xaan ñu tundoho, ta sica noo ñu ityi cuan ityi ya tañi mvee ticatyi sa yoñi zacuenda sii. ");
INSERT INTO mihNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tacuan ta i catyi ra Jesús sihin ra sica noo sihin ra: Sa ndisa quehin vatyi cahnu xaan itu, zoco yoñi cuñi zatyiño ta zaquee ra sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yucuan cuenda caca ndo sii sitoho itu vatyi natasi ra muzu cua zaquee sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","I casi ra Jesús usi uu tahan ra. Ta i saha ra tundyee iñi sii ra, ta i cuu tava ra tatyi cuihna, ta zanduvaha ra tandɨhɨ nuu cuehe ta tundoho. ");
INSERT INTO mihNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ta ihya cuu zɨvɨ sa usi uu tahan ra cuan. Xihna ca ra Simón. Pedro nañi tucu ra, ta ra Andrés yañi ra. Inga ra nañi Jacobo, ta ra Juan yañi ra. Nduu tahan ra cuu zehe ra Zebedeo. ");
INSERT INTO mihNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ta ra Felipe tucu, ta ra Bartolomé, ta ra Tomás, ta ra Mateo; ra i tava xuhun cuenda ra ndyaca ñaha cuu ra Mateo. Ta ra Jacobo zehe ra Alfeo, ta ra Lebeo. Nañi tucu ra Tadeo. ");
INSERT INTO mihNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ta inga ra nañi ra Simón. Maa ra cuu cuenda minoo ityi ra cuñi zama sii ra ndyaca ñaha. Ta inga ra nañi ra Judas Iscariote. Cuee ca ta i xico ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","I tasi ra Jesús sii sa usi uu tahan ra cuan, ta ihya cuu sa i catyi ra sihin ra: Ma cuhun ndo nu yoñi ñiyɨvɨ hebreo, ta ma quɨhvɨ ndo ñuu nu cu si Samaria. ");
INSERT INTO mihNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Zoco cuhun ndo nu yucu ñiyɨvɨ hebreo vatyi tañi mvee ticatyi sa cua naa cuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ta ityi cuahan ndo, nacatyi ndo Tuhun Ndyoo sihin ñiyɨvɨ, ta catyi ndo vatyi sa cuñi saa quɨvɨ cundyaca ñaha ra Ndyoo ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Zanduvaha ndo sii ñu cuhu. Zanandoto ndo sii ñu i sihi. Zanduvaha ndo sii ñiyɨvɨ cuhu cuehe tyahyu, ta tava ndo tatyi cuihna. Sa caha ñi ñihi maa ndo cuhva ya, ta sa caha ñi tyindyee maa ndo sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ma cuizo ndo xuhun cuenda ityi, nu xuhun cuaan, ta nu xuhun cuisi, ta nu xuhun cuatyi. ");
INSERT INTO mihNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Numinoo yɨtɨ ma cuizo ndo. Ma cuizo ndo inga camisa a zapato a minoo tutatu vatyi tahan si sa cuhva ñiyɨvɨ sa casi ra zatyiño tañi maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Tatu cua saa ndo minoo ñuu cahnu a ñuu luhlu, nanducu ndo sii minoo ra vaha, ta ndoo ndo vehe ra ndya quɨvɨ cua quita ndo ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cuhva sa saa ndo minoo vehe catyi ndo: “Nacoo sa vaha sii ra Ndyoo sihin ndo.” ");
INSERT INTO mihNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ta tatu vaha ñiyɨvɨ cuu ñu vehe cuan, nandoo si tacuan, zoco tatu yɨvɨ ñiyɨvɨ vaha cuu ñu, naquihin ndo tuhun vaha i cahan ndo sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ta tatu ma tɨɨn cuenda ñiyɨvɨ sii ndo, ta ña cuñi ñu tyizoho ñu sa cahan ndo, quita ndo vehe cuan ta ñuu cuan ta naquɨzɨ ndo saha ndo vatyi ma cuhun nu ñiyaca ñuu cuan sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sa ndisa catyi sihin ndo vatyi quɨvɨ cua tasi tuñi ra Ndyoo sii ñiyɨvɨ, cuaha ca tundoho cua ndyehe ñiyɨvɨ ñuu cuan ta zɨquɨ niyɨvɨ ñuu Sodoma ta ñuu Gomorra. ");
INSERT INTO mihNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ndyehe ndo, tañi mvee ticatyi cuu maa ndo, ta tasi sii ndo nu yucu lobo. Listo xaan cuu ndo tañi coo, zoco mazu xaan cuu iñi ndo tañi paloma. ");
INSERT INTO mihNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ta zacuenda vaha ndo sii ndo sihin ñiyɨvɨ vatyi cua cuhva cuenda ñu sii ndo sii ra cu tyiño. Ta cua cañi ñu sii ndo sisi vehe ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta cundyaca ñu sii ndo nuu ra ndyaca ñaha ta nuu ra gobierno sa cuenda mi. Ta tacuan ta cua ñihi ndo cuhva cahan ndo sa cuenda mi nuu ra cuan ta nuu ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu. ");
INSERT INTO mihNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ta cuhva sa cua cuhva cuenda ñu sii ndo sii ra cu tyiño, ma caca xaan iñi ndo ñaa sa cua cahan ndo vatyi sa zuun ñi caa cuhva cuan cua cuhva maa ra Ndyoo tuhun cua cahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Vatyi yɨvɨ maa ndo cua cahan. Tatyi Ii maa ra Ndyoo sa iyo añima ndo cua cuhva ra tuhun cua cahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Cua xico tuhun rayɨɨ zuun ñi sii yañi ra, ta cua cahñi ñiyɨvɨ sii ra. Ta cua xico tuhun zutu sa ndyihi sii zehe ra. Ta cua cuxaan zehe ñiyɨvɨ sihin zutu ñu ta sihin zɨhɨ ñu, ta cua cuhva cuenda ñu sii ñu vatyi cahñi niyɨvɨ sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tandɨhɨ ñiyɨvɨ ñuu ñiyɨvɨ cua cuxaan sihin maa ndo sa cuenda mi, zoco ra ma zaña tuhin ndya nu cua ndɨhɨ tyiemvu, yucuan ra cua cacu. ");
INSERT INTO mihNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tatu quiñi xaan zavaha ñiyɨvɨ sihin ndo minoo ñuu, cono ndo ta cuhun ndo ndya inga ñuu. Vatyi sa ndisa catyi sihin ndo vatyi tañaha ca ndɨhɨ cuhun ndo tandɨhɨ ñuu ñiyɨvɨ hebreo ta cua quisi tucu ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ña cahnu ca cuu minoo ra ndyico sii ra ta zɨquɨ ra cu nuu sii ra. Ta ña cahnu ca cuu minoo muzu ta zɨquɨ patrón ra. ");
INSERT INTO mihNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ra ndyico sii ra, nandoo ra vaha cuu ra tañi ra cu nuu sii ra. Ta nandoo ra cu muzu vaha cuu ra tañi patrón ra. Tatu mi, ra cu nuu vehe, ta catyi ñiyɨvɨ vatyi ra cu nuu sii cuihna sa nañi Beelzebú cui, cuaha ca sa cua cahan ñu sii zehi. ");
INSERT INTO mihNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yucuan cuenda ma yuhu ndo sii ñiyɨvɨ. Ñahñi tuhun xehe sa ma quita nu ndisi. Ta ñahñi sa ñoho xehe ta ma coto ñiyɨvɨ sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tandɨhɨ tuhun cahan xehi sihin ndo, nacatyi ndo sihin ñiyɨvɨ. Ta tuhun sa xehe xaan quehin sihin ndo, cana saa ndo sii si ndya xiñi vehe. ");
INSERT INTO mihNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma yuhu ndo sii ñiyɨvɨ cahñi coño ñuhu ndo vatyi ma cuu cahñi ñu añima ndo. Vaha ca cuyuhu ndo sii ra sa cuu cahñi sii ndo sa ndisa cuii ta zacuhun ra sii ndo andyaya. ");
INSERT INTO mihNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Cuyahvi uu tahan zaa ndyihi sa minoo peso. Caha xaan ndyaa tɨ, zoco ma cuu cuu numinoo tɨ ta canacava tɨ nu ñuhu tatu ma cuhva Zutu yo. ");
INSERT INTO mihNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ta ndya cuhva ndya ixi xiñi ndo, ta sito ra Ndyoo yozo tahan si. ");
INSERT INTO mihNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yucuan cuenda ma yuhu ndo. Yahvi xaan ca ndyaa maa ndo ta zɨquɨ ca cuaha xaan zaa ndyihi. ");
INSERT INTO mihNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tandɨhɨ ñiyɨvɨ sa cua catyi sihin inga ñiyɨvɨ vatyi sito ñu sii, yuhvi cua catyi tuqui sihin Zuti, ra ndyaa andɨvɨ, vatyi site sii ñu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Zoco ñiyɨvɨ cua catyi ityi nuu inga ñiyɨvɨ vatyi ña sito ñu sii, yuhvi cua catyi tuqui ityi nuu Zuti, ra ndyaa andɨvɨ, vatyi ña site sii ñu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma caca iñi ndo vatyi vasi cuhve sa coo sa taxi ñuu ñiyɨvɨ. Ña tacuan cuu si. Vasi ndyaque cuhva cahñi tahan ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Vasi zacahñi tehin rayɨɨ sihin zutu ra ta ñu zɨhɨ sihin zɨhɨ ñu. Ta cua cahñi tahan sono ñiyɨvɨ sihin tyizo ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta cua cuxaan tahan xaan ñiyɨvɨ sihin ñiyɨvɨ sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ra cuñi ca sii zutu ra a sii zɨhɨ ra ta zɨquɨ sii mi, ña tahan si cuu ra ñiyɨvɨ cuenda mi. Ta ra cuñi ca sii zehe yɨɨ ra a sii zehe zɨhɨ ra ta zɨquɨ sii mi, ña tahan si cuu ra ñiyɨvɨ cuende. ");
INSERT INTO mihNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ta ra ña cuñi cundyico sii, vazu cuu ra cuende, ña tahan si cuu ra ñiyɨvɨ cuende. ");
INSERT INTO mihNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ra sa cuñi coo vaha xaan ta zacuenda ra sii ra ñuu ñiyɨvɨ, cunaa ra, ta cunaa ndaha tyiño ra sihin ra. Zoco ra saha sa cuu sa cuenda mi, cua cundito ra tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Tatu tɨɨn cuenda ñiyɨvɨ sii maa ndo, tɨɨn cuenda ñu sii mi. Ta tatu tɨɨn cuenda ñiyɨvɨ sii mi, tɨɨn cuenda ñu sii ra i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ra tɨɨn cuenda sii minoo ra profeta vatyi vasi ra sa cuenda ra Ndyoo, zuun ñi sa vaha cua cuhva ra Ndyoo sii ra tɨɨn cuenda cuan tañi cua cuhva ra sii ra profeta cuan. Ta minoo ra tɨɨn cuenda sii minoo ra vaha vatyi vaha ra, zuun ñi sa vaha cua cuhva ra Ndyoo sii ra tañi sa cua cuhva ra sii ra vaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ta yoo ra cua cuhva, vazu minoo vaso ndutya visi ñi, sii minoo ra luhlu. Ndisa cuii cua cuhve sa vaha sii ra tatu zavaha ra cuhva cuan sa cuenda sa vatyi ndyico ra sii mi. ");
INSERT INTO mihNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sa ndɨhɨ zacuaha ra Jesús cuhva ya sii sa usi uu tahan ra i casi ra, ta zɨquɨ i quita ra yucuan ta cuahan ra zɨɨn zɨɨn ñuu ityi cuan cua zacuaha ra ta nacatyi ra Tuhun Ndyoo sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ñoho ra Juan vehe caa, ta i saa tyiño nu ndyaa ra sa cuenda cuhva zavaha ra Jesús. Yucuan cuenda i tasi ra sii uu tahan ra ndyico sii ra vatyi cua cahan ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ta i ndaca tuhun ra cuan sii ra Jesús: ¿Atu yoho cuu ra Cristo, ra cua zacacu sii ndi a cuatu ca ndi naquisi inga ra? ");
INSERT INTO mihNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ta i nacahan ra Jesús, ta i catyi ra sihin ra cuan: Cuahan ndo ta nacatyi ndo sihin ra Juan tandɨhɨ sa i ndyehe ndo ta sa siñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nacatyi ndo sihin ra cuhva nandyehe ra cuaa, ta nacaca ra coxo ta nduvaha ra tyahyu ta nacuɨñɨ ra zoho, ta cuhva nandoto ñiyɨvɨ i sihi. Ta nacatyi ndo cuhva siñi ñiyɨvɨ ndahvi Tuhun Vaha, cuhva cua cacu ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ta catyi ndo sihin ra vatyi zɨɨ xaan cua cuñi ñiyɨvɨ tatu ma zaña ñu sa sino iñi ñu sii. ");
INSERT INTO mihNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tacuan i catyi ra Jesús sihin ra ndyico sii ra Juan. Ta sa yaha cuahan ra cuan ta zɨquɨ i quisaha cahan ra Jesús sihin ñiyɨvɨ sa cuenda ra Juan, ta catyi ra: ¿Ñaa sa sindyehe ndo quɨvɨ i sahan ndo nu ityi xaan nu yoñi ñiyɨvɨ iyo? ¿Atu sahan ndo vatyi cua ndyehe ndo minoo tuñɨɨ sa zacanda tatyi? ");
INSERT INTO mihNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tatu yɨvɨ si cuan ¿ñaa sa sindyehe ndo? ¿Atu sahan ndo vatyi cua ndyehe ndo sii minoo ra ñoho zahma vaha? Ña tacuan vatyi sa sito ndo vatyi ñiyɨvɨ ñoho zahma vaha xaan, iyo ñu vehe rey. ");
INSERT INTO mihNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ñaa sa sindyehe ndo? ¿Atu sahan ndo vatyi cua ndyehe ndo sii minoo profeta? Zuumi. Ta catyi sihin ndo vatyi ñiñi xaan ca ra cuu maa ra Juan ta zɨquɨ ca tandɨhɨ ca ra profeta. ");
INSERT INTO mihNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Vatyi ra cuan cuu ra cahan si tuhun nuu tutu ra Ndyoo nu catyi si: “Yuhvi ra Ndyoo cua tasi sii minoo ra ityi nuu ca, ta cua zanduvaha ra cuhva iyo ñiyɨvɨ vatyi cua saa moo cuee ca, ta cua tyizoho ñu sa cohon.” ");
INSERT INTO mihNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sa ndisa catyi sihin ndo vatyi tandɨhɨ rayɨɨ ra cacu, yoñi inga ca ra ñiñi ca ta zɨquɨ ra Juan. Zoco ra luhlu ca, ra cuhun nu ndyaca ñaha ra Ndyoo, cahnu ca ra ta zɨquɨ ra Juan, ra zacoo ndutya sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ta ndya quɨvɨ i saa ra Juan ta ndya vityi cuahan coyo ñiyɨvɨ gloria, ñu cuñi ndisa cuii cuhun. Zoco zañihi ñu ta cua zahacanaa ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tandɨhɨ ra profeta ta ley ra Moisés ndɨhɨ ca, i cahan si sa cuenda cuhva cua cundyaca ñaha ra Ndyoo ndya cuhva ndya quɨvɨ i saa ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ta tatu cuñi ndo sino iñi ndo sa quehin, ra Juan cuu ra Elías, ra tahan si quisi. ");
INSERT INTO mihNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tatu ndyaa zoho ndo, cuɨñɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Ñaa ñi cuhva quehin sihin ñiyɨvɨ iyo vityi? ¿Tañi yoo ñi sa caa caa ñu? Caa ñu tañi sa ndyihi sa ndyaa nuyahvi, ta cana saa si sii tahan si, ta catyi si: ");
INSERT INTO mihNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tɨvɨ ndi cutu, ta ñá sata saha ndo. Ta sata ndi yaa tucuihya iñi, ta ñá sacu ndo.” ");
INSERT INTO mihNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tacuan iyo maa ndo vatyi i quisi ra Juan, ta ñá sasi vaha ra, ta ñá sihi ra vino, ta catyi ndo vatyi ñoho minoo tatyi cuihna sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ta zɨquɨ i saa mi, ra i quisi ndya gloria. Ta sasi ta sihi, ta catyi ndo vatyi tuhva xein coho ta cuahyi xein. Ta cuxaan ndo vatyi vaha ñiyɨvɨ cui sihin ra iyo cuatyi ta sihin ra tava xuhun cuenda ra ndyaca ñaha. Tacuan catyi ndo, zoco saha ra Ndyoo sa siñi tuñi maa ra sii ñiyɨvɨ sino iñi sii ra. Ta cua zañaha ñu sii maa ndo vatyi vaha sa siñi tuñi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tacuan ta zɨquɨ i quisaha cuxaan ra Jesús ta cahan ra sihin sa minoo minoo ñuu nu i zavaha xaan ra sa ndyityi vatyi ñiyɨvɨ ñuu cuan, ñá zama ñu cuhva iyo ñu. Tyehen i catyi ra Jesús: ");
INSERT INTO mihNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","¡Ndahvi yoho ñuu Corazín! ¡Ta ndahvi yoho ñuu Betsaida! Vatyi tatu i zavehi sa ndyityi ndya ñuu Tiro ta ñuu Sidón tañi sa ndyehe maa ndo, sa ndisa vatyi cua zama ñu cuhva iyo ñu, ta cua nducuihya xaan iñi ñu sa cuenda cuatyi ñu ndya cuhva ndɨhvɨ ñu zahma toon ta tyaa ñu ñiyaa xiñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Zoco quɨvɨ cua tasi tuñi ra Ndyoo sii ñiyɨvɨ, ñihi ca cua tasi tuñi ra sii maa ndo ta zɨquɨ sii ñiyɨvɨ ñuu Tiro ta ñuu Sidón cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ta yoho ñuu Capernaum, ¿atu sica iñun vatyi cua ndoon ndya gloria? Cua noon ndya andyaya vatyi tatu i zavehi sa ndyityi ndya ñuu Sodoma tañi sa ndyehe ñiyɨvɨ ñuu Capernaum, ndisa vatyi ma zanaa ra Ndyoo ñuu Sodoma cuan ta cua coo si ndya cuhva ndya vityi. ");
INSERT INTO mihNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Zoco catyi sihin ndo vatyi quɨvɨ cua tasi tuñi ra Ndyoo sii ñiyɨvɨ, ñihi ca cua tasi tuñi ra sii ndoho ra ñuu Capernaum ta zɨquɨ sii ñiyɨvɨ ñuu Sodoma. ");
INSERT INTO mihNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ta cuhva cuan i catyi ra Jesús: Zacahnu xein suun Ndyoo Zuti. Yoho ndyaca ñohon andɨvɨ ta ñuu ñiyɨvɨ. Tyixehun sa siñi tuñi suun sii ñiyɨvɨ sica iñi vatyi sito xaan ñu, ta zañohon sii si sii ñu cuu tañi sa ndyihi ñuu ñiyɨvɨ ya. ");
INSERT INTO mihNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tacuan zavohon vatyi tacuan cuñi moo. ");
INSERT INTO mihNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ta zɨquɨ i catyi tucu ra Jesús: Saha maa ra Ndyoo Zuti tandɨhɨ sa iyo sii maa ra sii mi. Ta yoñi sa sito sii. Maa ñi ra Ndyoo Zuti cuu ra sito sii. Ta maa ñi mi site sii ra Ndyoo Zuti. Yoñi inga ra sito sii ra sa ndisa cuii. Ta zañehi sii yoo ra cuñi, cuhva iyo Zuti sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ñáha ndo, tandɨhɨ ndoho ra sitatu xaan sa cuenda tyiño ndo ta sa cuenda sa vee xaan ndyizo ndo cuatyi ndo ta cua cuhve sa quitatu ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Cuhva ndo sa tyize yugo sa yozo xiñi mi xiñi ndo, ta cutuhva ndo sa cua zañehi sii ndo vatyi mi, vii xaan iye, ta zanduluhlu xein sii, ta cua nañihi ndo cuhva quitatu añima ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Vatyi ña yɨɨ maa cua cuizo ndo yugo sa cua tyize xiñi ndo, ta carga sa cua cuizo ndo sa cuenda mi, ña vee si. ");
INSERT INTO mihNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Minoo quɨvɨ quitatu ñiyɨvɨ i yaha ra Jesús mahñu itu trigo ñiyɨvɨ. Ta i sizoco ra i casi ra Jesús, ta i quisaha tohon ra zuhva yoco trigo, ta i zavii ra, ta sasi ra sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ta cuhva sa ndyehe ra fariseo cuhva zavaha ra, i catyi ra sihin ra Jesús: Ndyehe, zatyiño ra sica noo suhun, ta ña catyi ley yo sa zatyiño yo quɨvɨ quitatu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Zoco i catyi ra Jesús sihin ra: ¿Atu tañaha ca cahvi ndo cuhva i zavaha ra David ta ra ndɨhɨ sihin ra minoo quɨvɨ i sizoco xaan ra? ");
INSERT INTO mihNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","I quɨhvɨ ra sisi vehe ñuhu, ta i quihin ra pan ii. Ta i sasi ra sii si, ta ña catyi ley sa casi ra sii si ta nu ra ndɨhɨ sihin ra. Maa ñi ra cu zutu tahan si casi pan cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Atu tañaha ca cahvi ndo nu ley nu catyi si vatyi zatyiño ra cu zutu sisi vehe ñuhu quɨvɨ quitatu ñiyɨvɨ ta yɨvɨ cuatyi cuu si? ");
INSERT INTO mihNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ta catyi sihin ndo vatyi ihya iyo minoo ra cahnu ca ta zɨquɨ vehe ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tatu sa sito ndo ñaa cuñi si catyi si nu i catyi ra Ndyoo vatyi cuñi ra sa cundahvi iñi ndo sii ñiyɨvɨ ta yɨvɨ ca sa cahñi ndo quɨtɨ ta cuhva ndo nɨñɨ tɨ sa cuenda cuatyi ndo, ma tyaa ndo cuatyi sata ñiyɨvɨ sa ñahñi cuatyi iyo. ");
INSERT INTO mihNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ta ra i quisi ndya gloria cui, ta ndyaca ñaha tuqui quɨvɨ quitatu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tacuan ta cuahan ra Jesús, ta i quɨhvɨ ra vehe ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta yucuan ndyaa minoo ra na‑ityi ndaha. Ta inga ra yucu yucuan, i cuñi ra nducu ra cuhva tyaa ra cuatyi sata ra Jesús, ta yucuan cuenda i ndaca tuhun ra sii ra Jesús: ¿Atu catyi ley sa zanduvaha yo sii ñiyɨvɨ quɨvɨ quitatu yo? ");
INSERT INTO mihNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ta i nacahan ra Jesús ta catyi ra: ¿Yoo ndoho tatu iyo minoo mvee ticatyi zono ndo ta canacava tɨ sisi minoo xahva quɨvɨ quitatu ñiyɨvɨ, atu ma tava ndo sii tɨ? ");
INSERT INTO mihNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ta ¡ñiñi xaan ca cuu minoo ñiyɨvɨ ta zɨquɨ minoo mvee ticatyi! Yucuan cuenda catyi ley vatyi cuu zavaha yo sa vaha quɨvɨ quitatu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tacuan ta i catyi ra Jesús sihin ra na‑ityi ndaha cuan: Nandɨca ndohon. Ta i nandɨca ra ndaha ra, ta i nduvaha si tañi caa inga si. ");
INSERT INTO mihNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tacuan ta i quita ra fariseo, ta i quisaha sihñi tahan ra tyiño yozo caa cua cahñi ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ta sa sito ra Jesús cuhva cuan, i quita ra yucuan, ta cuaha xaan ñiyɨvɨ i sindyico sii ra. Ta i zanduvaha ra Jesús sii tandɨhɨ ñu cuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ta i saha ra tyiño sii ñiyɨvɨ i nduvaha vatyi ma nacatyi ñu yoo ra cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Cuhva cuan i natahan si cuhva i nacatyi ra Isaías, minoo ra profeta, sa cuenda ra Jesús. Ihya cuu Tuhun ra Ndyoo i tyaa ra Isaías: ");
INSERT INTO mihNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ihya ra cuu muzi; i casi sii ra; cuñi xein sii ra, ta zɨɨ xaan cuñi sihin ra. Cua cuhva xein Tatyi Ii sii ra, Ta cua nacatyi ra sihin ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu vatyi ndoo xaan zavehi. ");
INSERT INTO mihNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ma tusi tahan ra tuhun. Ta ma cana saa ñi ca ra ta cahan ra. Ta ma zacahnu ra sii ra nuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ma cahnu ndɨhɨ ra numinoo tuñɨɨ yacua, ta ma ndahva ndɨhɨ ra ñúhu sa siin ñi cayu. (Cuñi si catyi si vatyi ma quindyaa ndɨhɨ ra tatu siin ñi sino iñi ñiyɨvɨ.) Cua quindyaa ra cuhva ndyaca ñaha ñiyɨvɨ ña vaha, ta cua cundyaca ñaha ra minoo cuhva ndoo xaan. ");
INSERT INTO mihNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ta tandɨhɨ cuii ñiyɨvɨ cuu cunɨɨ xaan iñi ñu sii ra vatyi cua tyindyee ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tacuan ta i quisi ndyaca ñiyɨvɨ sii minoo ra cuaa ta ñehe ra nu ndyaa ra Jesús. Ta ñoho minoo tatyi cuihna sii ra cuan. Ta i zanduvaha ra Jesús sii ra, ta i cuu nandyehe ra ta nacahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ta iyo xaan i cuñi tandɨhɨ ñiyɨvɨ, ta i catyi ñu: ¿Atu ra ihya cuu ra cu tata ra David, ra cua zacacu sii yo? ");
INSERT INTO mihNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Zoco sa i siñi ra fariseo cuhva cahan ñiyɨvɨ, ta i catyi ra: Ra ihya tava ra tatyi cuihna maa ñi sihin tundyee iñi iyo sii ra Beelzebú, ra cu nuu sii cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ta sa sito ra Jesús cuhva sica iñi ra, ta i catyi ra: Tatu sahñi tahan xaan ñiyɨvɨ minoo ñuu, ndaha cua tɨvɨ ta naa ñuu cuan. Ta tacuan tucu minoo vehe ñiyɨvɨ, tatu sahñi tahan ñu sihin tahan ñu, yatyi xaan cua ndɨhɨ cuhva vaha yucu ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ta ma cahñi tahan ra cu nuu sii cuihna sihin inga cuihna vatyi tatu tacuan zavaha ra, yatyi xaan cua ndɨhɨ cuhva iyo sii ra. Ma tava cuihna sii cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ta tatu yuhvi tave sii cuihna sihin tundyee iñi ra Beelzebú, ¿yoo sii tundyee iñi tava ra ndyico sii maa ndo sii si? Maa ra cua zacoto sii ndo vatyi ma tava minoo cuihna sii inga cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ta yuhvi tave sii cuihna sihin tundyee iñi maa ra Ndyoo. Ta cuñi si catyi si vatyi ndisa cuii sa saa cuhva ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ta ¿yoo ra cua cuu quɨhvɨ vehe minoo ra ñihi xaan ta quihin ra ndaha tyiño ra tatu ma cuhñi xihna ra sii ra? Cuñi si sa cuhñi xihna ra sii ra ta zɨquɨ cuu quindyaa ra ndaha tyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tatu ña zatyiño ñiyɨvɨ sihin, zatɨvɨ ñu tyiñe. Ta tatu ma tyindyee ñu sii, sa nacatyi Tuhun Ndyoo sihin ñiyɨvɨ, cuñi si catyi si vatyi ña saha ñu sa coto ñiyɨvɨ tuhin. ");
INSERT INTO mihNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yucuan cuenda catyi sihin ndo vatyi cua zaha ra Ndyoo tucahnu iñi tandɨhɨ cuatyi zavaha ñiyɨvɨ ta tandɨhɨ sa quiñi cahan ñu, zoco tatu cahan ñiyɨvɨ ndya vaha ñi sii Tatyi Ii ra Ndyoo, ma zaha ra Ndyoo tucahnu iñi sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tatu quiñi cahan ñiyɨvɨ sii vii, ra i quisi ndya gloria, cua zaha ra Ndyoo tucahnu iñi sii ñu. Zoco yoo ra cahan quiñi sii Tatyi Ii, ma zaha ra Ndyoo tucahnu iñi sii ra nu ihya ñuu ñiyɨvɨ ta nu inga ñuu ñiyɨvɨ sa cua coo cuee ca. ");
INSERT INTO mihNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Minoo yutu vaha, saha tu sɨtɨ vaha. Ta minoo yutu ña vaha, saha tu sɨtɨ ña vaha. Nacoto yo ñaa yutu cuu tahan tahan tu sa cuenda sɨtɨ saha tu. ");
INSERT INTO mihNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Coo xaan cuu maa ndo! ¿Yozo caa cuu cahan ndo tuhun vaha ta ña vaha maa ndo? Yuhu ndo cahan sa situ cuii añima ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Minoo ra vaha, cahan ra tuhun vaha vatyi iyo sa vaha añima ra. Ta minoo ra ña vaha, ña vaha sa cahan ra vatyi iyo sa ña vaha añima ra. ");
INSERT INTO mihNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ta catyi sihin ndo vatyi quɨvɨ cua tyicuhva ra Ndyoo sii ñiyɨvɨ, ta cua nacatyi ñu ñaa cuenda i cahan ñu sa minoo minoo tuhun sa ña ñiñi. ");
INSERT INTO mihNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Vatyi sa cuenda tuhun cahan ndo ta cua catyi ra Ndyoo tatu vaha ndo a ña vaha ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tacuan ta zuhva ra fariseo ta ra maestro cuenda ley i catyi ra sihin ra Jesús: Maestro, cuñi ndi ndyehe ndi minoo zeña sa ndyityi. ");
INSERT INTO mihNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ta i nacahan ra Jesús, ta catyi ra sihin ra: Ñiyɨvɨ quiñi xaan iyo ta ñu ña vaha, sica ñu sa ndyehe ñu sa ndyityi, zoco ma ndyehe ca ñu inga zeña ta zɨquɨ cuhva i cuu ra Jonás, minoo ra profeta ta sa naha. ");
INSERT INTO mihNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Vatyi tañi i ñoho ra Jonás uñi quɨvɨ ta uñi sa cuaa sisi tyiyaca cahnu, tacuan tucu cua quɨhɨ ra i quisi ndya gloria uñi quɨvɨ ta uñi sa cuaa sisi ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ñiyɨvɨ ñuu Nínive cua nduvita ñu ta cua tyaa ñu cuatyi sata ñiyɨvɨ iyo vityi, ta cua catyi ñu vatyi iyo cuatyi ndo vatyi ñiyɨvɨ ñuu Nínive cuan, i zama ñu cuhva iyo ñu sa i nacatyi ra Jonás Tuhun Ndyoo sihin ñu. Ta ihya iyo minoo ra ñiñi ca ta zɨquɨ ra Jonás. ");
INSERT INTO mihNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ta tacuan tucu minoo ñaha i sindyaca ñaha ndya siyo tyañuhu, cua nandoto ña quɨvɨ cua tyicuhva ra Ndyoo sii ñiyɨvɨ, ta cua tyaa ña cuatyi sata ndo vatyi sica xaan i quisi ña quɨvɨ cuan vatyi cua tyizoho ña sa siñi tuñi sa saha ra Ndyoo sii ra Salomón. Ta ihya iyo minoo ra ñiñi ca ta zɨquɨ ra Salomón. ");
INSERT INTO mihNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tatu quita minoo tatyi ña vaha sii minoo ra, sica noo tatyi cuihna cuan nu ityi xaan, ta nanducu si nu cua quitatu si, zoco ña nañihi si nu quitatu si, ta catyi si: ");
INSERT INTO mihNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Cunuhu tuqui ndya vehi nu i quite.” Ta sa nasaa si, nañihi si sii ra i quita si cuan. Ta añima ra cuu tañi minoo vehe sa yoñi ndyaa. Tɨhvɨ ta nduvii vehe cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tacuan ta cuahan tatyi cuihna cuan ta quihin si inga usa tahan tahan si sa xaan ca ta zɨquɨ maa si. Ta cuahan tandɨhɨ si cuan cua ndɨhvɨ si añima ra cuan. Ta yaha ca cuhva cua nanduu ra cuan ta zɨquɨ sa xihna ñi. Ta tacuan tucu cua tahan ñiyɨvɨ ña vaha ya. ");
INSERT INTO mihNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Cahan ca ra Jesús sihin ñiyɨvɨ, ta i saa zɨhɨ ra ta yañi ra. I sicuyucu ñu sata vehe, ta i cuñi ñu cahan ñu sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ta i nacatyi minoo ñiyɨvɨ sihin ra Jesús: Zɨhun ta yañun, nandyaa ñu sata vehe, cuñi ñu cahan ñu suhun. ");
INSERT INTO mihNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Zoco i catyi ra Jesús sihin ra cahan sihin ra: ¿Yoo sa cuu zɨhi? ¿Ta yoo sa cuu yañi? ");
INSERT INTO mihNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tacuan i catyi ra, ta zɨquɨ i zañaha ndaha ra nu yucu ñiyɨvɨ sica noo sihin ra, ta i catyi ra: Ñu ihya cuu tañi zɨhi, ta ra ihya cuu tañi yañi. ");
INSERT INTO mihNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Vatyi yoo ñiyɨvɨ zavaha cuhva cuñi Zuti, ra ndyaa andɨvɨ, yucuan ñu cuu tañi cuhve ta yañi ta zɨhi. ");
INSERT INTO mihNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Quɨvɨ cuan i quita ra Jesús vehe, ta i sicundyaa ra yuhu miñi. ");
INSERT INTO mihNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","I titahan cuaha xaan ñiyɨvɨ nu ndyaa ra, ta yucuan cuenda i quɨhvɨ ra Jesús sisi minoo barco, ta i sicundyaa ra. Ta i ndoo tandɨhɨ ñiyɨvɨ nu ñiyɨtɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tacuan ta i zacuaha ra sii ñu zɨquɨ cuaha xaan cuhva, ta catyi ra: Cuahan minoo ra nu iyo tyiño ra vatyi cua quɨtɨ ra sɨtɨ trigo nu ñuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ta cuhva sa quɨtɨ ra sii si, zuhva si i canacoyo ityi. Ta i quisi zaa, ta sasi tɨ sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ta inga si i canacoyo nu yaxi ñoho ñuhu vatyi ñoho xaan yuu. Ta yatyi xaan i caña si vatyi yaxi xaan ñoho ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ta cuhva i ndyehe ñicandyi i naxii si vatyi ñahñi yoho si, ta i na‑ityi si. ");
INSERT INTO mihNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ta zuhva ca sɨtɨ cuan i canacoyo tɨcuɨ iñu. Ta i caña si, zoco i zahvi iñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Zoco inga tucu zuhva ca sɨtɨ cuan, i canacoyo si nu vaha ñuhu, ta vaha xaan i saha si. Iyo si saha si ziendu sɨtɨ si sa minoo ñi si. Iyo si saha si uñi xico usi. Ta iyo si saha si oco usi. ");
INSERT INTO mihNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tatu siñi ndo, ¡cuɨñɨ ndo! ");
INSERT INTO mihNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tacuan ta i tuhva ra i casi ra Jesús, ta i ndaca tuhun ra sii ra: ¿Ñaa cuenda tuhvon cahan sihin ñiyɨvɨ zɨquɨ minoo cuhva? ");
INSERT INTO mihNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ta i nacahan ra Jesús, ta catyi ra: Saha ra Ndyoo sa coto maa ndo tuhun xehe sa cuenda cuhva ndyaca ñaha maa ra. Zoco ma cuu coto inga ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ra sa cutuñi iñi zuhva, cuaha ca cua cuhva ra Ndyoo sa cutuñi iñi ra. Ta ra ña cutuñi iñi, cua quindyaa ndɨhɨ ra Ndyoo ndya sa siin cuii ñi cutuñi iñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yucuan cuenda quehin sihin ñu zɨquɨ minoo cuhva vatyi cua ndyehe ñu, zoco ma coto ñu ñaa sa ndyehe ñu. Cua cuɨñɨ ñu, zoco ma cutuñi iñi ñu. Cua cuu si tañi sa ñá siñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ta sa cuenda maa ñu cua natahan si cuhva i catyi ra Isaías. Ihya cuu cuhva i catyi ra: Ndisa cua cuɨñɨ ndo, zoco ma cutuñi iñi ndo; Cua ndyehe ndo, zoco ma nacoto ndo ñaa sa ndyehe ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Vatyi ñihi xaan iñi ndo, ta ña siñi ndo, ta ndaha titahan sɨtɨ nuu ndo; coto ndyehe ndo ta coto cuɨñɨ ndo ta coto cutuñi iñi ndo ta quisi ndo nu ndyei ta zanduvehi sii ndo. Tacuan i tyaa ra Isaías sa cuenda ñiyɨvɨ ña sino iñi cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Zoco maa ndo, zɨɨ xaan cuu sii ndo vatyi ndyehe ndo sihin sɨtɨ nuu ndo, ta siñi ndo sihin zoho ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ta sa ndisa catyi sihin ndo vatyi cuaha xaan ra profeta ta inga ñiyɨvɨ vaha, i cuñi ñu ndyehe ñu sa ndyehe maa ndo vityi, zoco ñá ndyehe ñu sii si. Ta i cuñi ñu cuɨñɨ ñu sa siñi maa ndo, ta ñá siñi ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ta zɨquɨ i catyi ra Jesús: Cuɨñɨ ndo cuhva cuñi si catyi si sa cuenda cuhva ra quɨtɨ sɨtɨ trigo nu ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ñiyɨvɨ sa siñi tuhun sa cuenda cuhva ndyaca ñaha ra Ndyoo ta ña cutuñi iñi ñu sii si cuu ñu tañi sɨtɨ sa canacoyo ityi. Ta saa cuihna, ta quindyaa ra tuhun i tasi ra Ndyoo añima ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sɨtɨ sa canacoyo tɨcuɨ yuu cuu tañi ñiyɨvɨ sa siñi Tuhun Ndyoo, ta zɨɨ xaan i cuñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Zoco ñá quɨhvɨ vaha Tuhun Ndyoo añima ñu. Ta ña naha cua sino iñi ñu. Tatu sa quisi minoo tundoho zɨquɨ ñu a cuxaan ñiyɨvɨ sihin ñu sa cuenda Tuhun Ndyoo, yatyi xaan cua zaña ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ta sɨtɨ sa canacoyo tɨcuɨ iñu cuu tañi ñiyɨvɨ sa siñi Tuhun Ndyoo, zoco sica xaan iñi ñu sa cuenda sa iyo ñuu ñiyɨvɨ ya. Ta tuhun cuca, tuhun zandavi ñaha ñi cuu si. Ta tandɨhɨ cuhva cuan, sahñi si Tuhun Ndyoo, ta ña zatyiño vaha si sihin ñiyɨvɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Zoco sɨtɨ sa canacoyo nu vaha ñuhu, cuu si tañi ñiyɨvɨ sa siñi Tuhun Ndyoo ta cutuñi iñi ñu sii si, ta vaha xaan zatyiño si sihin ñu. Iyo ñu cuu ñu tañi sɨtɨ sa saha minoo ziendu sa minoo si. Ta inga ñu cuu tañi sɨtɨ sa saha uñi xico usi. Ta inga ñu cuu tañi sɨtɨ sa saha oco usi tahan sa minoo si. ");
INSERT INTO mihNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tacuan ta zɨquɨ i cahan ra Jesús zɨquɨ inga cuhva, ta catyi ra: Cuhva ndyaca ñaha ra Ndyoo cuu si tañi minoo cuhva i tasi minoo ra sɨtɨ vaha nu ñuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Zoco cuhva sa i quixi ñiyɨvɨ, ta i quɨhvɨ minoo ra xaan iñi sii sitoho ñuhu cuan, ta i tasi ra sɨtɨ ña vaha tɨcuɨ trigo, ta cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","I sahnu trigo, ta i caña yoco si. Ta tɨcuɨ trigo i sahnu tucu yucu ña vaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tacuan ta sahan muzu i sinacatyi ra sihin sitoho ñuhu cuan: “Tata, tatu vaha sɨtɨ i tasun nu ñuhun, ¿yozo caa vatyi i caña tucu yucu ña vaha cuan?” ");
INSERT INTO mihNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ta i catyi sitoho si: “Minoo ra xaan iñi sii, i zavaha cuhva cuan.” Ta zɨquɨ i ndaca tuhun muzu ra sii ra: “¿Atu cuñun vatyi cutohon ndi yucu ña vaha cuan?” ");
INSERT INTO mihNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Zoco i catyi ra sihin ra: “Ma tohon ndo sii si coto quita ndɨhɨ trigo cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Vaha ca zandoo yo sii si, nacuahnu si ndya sa sisa si. Ta cua tasi muzu, ta cua tava xihna ra yucu ña vaha cuan ta cuhñi ra cuenda zucu si vatyi cua cayu si. Ta zɨquɨ cua naquihin ra trigo ta tyihi ra sii si nu cua cucumi vehi sii si.” ");
INSERT INTO mihNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ta zɨquɨ i cahan tucu ra Jesús zɨquɨ inga cuhva, ta catyi ra: Cuhva ndyaca ñaha ra Ndyoo cuu si tañi minoo sɨtɨ mostaza sa i tasi minoo ra nu ñuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ndisa vatyi luhlu ca maa sɨtɨ cuan ta zɨquɨ tandɨhɨ inga nuu sɨtɨ, zoco tatu sa sahnu si, nducahnu ca si ta zɨquɨ tandɨhɨ ca numa, ta nduu si tañi minoo yutu. Ta vasi zaa ta zavaha tɨ taca tɨ zoco tu. ");
INSERT INTO mihNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ta i cahan tucu ra Jesús zɨquɨ inga cuhva ya: Cuhva ndyaca ñaha ra Ndyoo cuu si tañi yusa iya sa nazaca minoo ñaha sihin uñi taha arroba yutyi pan, ta cua zanandaa yusa iya cuan sii tandɨhɨ yutyi pan cuan. (Ta tacuan tucu cuahan nducahnu ca sa ndyaca ñaha ra Ndyoo.) ");
INSERT INTO mihNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","I catyi ra Jesús tandɨhɨ ihya sihin ñiyɨvɨ zɨquɨ minoo cuhva ta zɨquɨ inga cuhva, ta ma cahan maa ra tatu ma cahan ra zɨquɨ minoo cuhva. ");
INSERT INTO mihNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tacuan i cuu si vatyi cua natahan si cuhva i tyaa minoo ra profeta. Ihya cuu sa i tyaa ra: Cua quehin zɨquɨ minoo cuhva; cua nacatyi tuhun i sicoo xehe ndya quɨvɨ i zavaha ra Ndyoo ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tacuan ta i natasi ra Jesús sii ñiyɨvɨ, ta i quɨhvɨ ra sisi vehe, ta i tuhva ra i casi ra sii ra, ta catyi ra: Nacatyun sihin ndi ñaa cuñi si catyi si sa cuenda yucu ña vaha sa sahnu tɨcuɨ trigo cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ta i nacahan ra Jesús, ta catyi ra sihin ra: Ra i tasi sɨtɨ vaha cuu ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ta ñuhu ra cuu ñuu ñiyɨvɨ. Ta sɨtɨ vaha cuu tañi ñiyɨvɨ sa cuu cuenda ra Ndyoo. Ta yucu ña vaha cuan cuu tañi ñiyɨvɨ sa cuu cuenda cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ta ra xaan iñi sii, cuu ra tasi yucu ña vaha cuan. Cuihna cuu ra cuan. Ta ra cua nacuaan ndaha tyiño cuan cuu ángel. Ta quɨvɨ cua naquihin ra trigo cuan cuu si tañi nu cua ndɨhɨ ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ta tañi cuhva i tohon ra yucu ña vaha ta i sahmi ra, tacuan tucu cua cuu si nu ndɨhɨ ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Cua tasi ra i quisi ndya gloria sii ángel ra vatyi cua tava zɨɨn ra sii tandɨhɨ ñiyɨvɨ tyiyuhu sii inga ñiyɨvɨ ta zavaha ñu sa ña vaha ta sii inga ñiyɨvɨ zavaha sa ña vaha, ndɨhɨ ca. ");
INSERT INTO mihNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Cua tyihi ángel sii ñu nu cayu ñúhu. Ta yucuan cua vacu ñu, ta cua casi quihñi noho ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ta ñiyɨvɨ zavaha sa vaha cuhva cuñi ra Ndyoo, cua ndundisi xaan ñu tañi ñicandyi nu ndyaca ñaha ra Ndyoo Zutu yo. Tatu siñi ndo sa quehin, cuɨñɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Cuhva ñihi yo sa cundyaca ñaha ra Ndyoo sii yo cuu tañi minoo sa yahvi xaan ndyaa ta ñoho xehe si sisi ñuhu. Ta i nañihi minoo ra sii si, ta natyixehe tucu ra sii si zuun ñi yucuan. Ta zɨɨ xaan i cuñi ra ta cuahan ra ta i xico ra tandɨhɨ sa iyo sii ra, ta i nazata ra ñuhu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ta cuhva ndyaca ñaha ra Ndyoo sii yo vale xaan si tañi minoo cuhva minoo ra zata ndaha tyiño ta naxico ra. Sica noo ra ta nanducu ra perla vaha xaan. ");
INSERT INTO mihNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ta quɨvɨ i nañihi ra minoo sa yahvi xaan ndyaa, cuahan ra ta i naxico ra tandɨhɨ sa iyo sii ra, ta i nazata ra perla cuan. (Ta tacuan tucu vale xaan Tuhun Ndyoo tañi perla cuan.) ");
INSERT INTO mihNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ta inga tucu cuhva, vatyi cuhva ndyaca ñaha ra Ndyoo cuu si tañi minoo taraya sa cañi ra tɨɨn tyiyaca nu tyañuhu ta ñihi ra tandɨhɨ nuu tyiyaca. ");
INSERT INTO mihNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tatu sa situ taraya ra, tava ra sii si nu ñiyɨtɨ ta yucuan cua cundyaa ra ta cua nacasi ra ñaa tyiyaca cuñi ra. Cua tyihi ra tyiyaca vaha sisi tyica, ta cua zavita ra tyiyaca ña vaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ta tacuan cua cuu si nu cua ndɨhɨ ñuu ñiyɨvɨ. Cua quisi ángel vatyi cua tava zɨɨn ra sii ñiyɨvɨ ña vaha sihin ñiyɨvɨ vaha. ");
INSERT INTO mihNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ta ñiyɨvɨ ña vaha cuan cua tyihi ra nu cayu ñúhu, ta cua vacu ñu, ta cua casi quihñi noho ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tacuan ta zɨquɨ i ndaca tuhun ra Jesús sii ra i casi ra: ¿Atu cutuñi iñi ndo tandɨhɨ cuhva ya? Ta i catyi ra: Cutuñi iñi ndi, tata. ");
INSERT INTO mihNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ta zɨquɨ i catyi ra Jesús sihin ra: Tatu cua cutuhva minoo maestro cuenda ley sa cuenda cuhva ndyaca ñaha ra Ndyoo vityi cua cuu ra tañi minoo ra xu vehe sa cumi vaha sa sahnu ta sa saa sa vaha xaan, ta cuu zañaha ra nduu tahan si. ");
INSERT INTO mihNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sa ndɨhɨ cahan ra Jesús zɨquɨ cuhva ya ta zɨquɨ i quita ra yucuan, ta cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ta i nasaa ra zuun ñi ñuu maa ra. Ta yucuan i quisaha zacuaha ra sii ñiyɨvɨ sisi vehe ñuhu. Ta iyo xaan i cuñi ñiyɨvɨ, ta catyi ñu: ¿Yozo caa ñihi ra ya cuhva sa casi xaan iñi ra? ¿Ta yozo caa ñihi ra cuhva zavaha ra sa ndyityi? ");
INSERT INTO mihNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ta zehe ra carpintero cuu sii ra. Ta ña María cuu zɨhɨ ra. Ta ra Jacobo, ta ra José, ta ra Simón, ta ra Judas cuu yañi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ta cuhva ra iyo tucu ñu ihya sihin yo. ¿Ta yozo caa vatyi sito ra tandɨhɨ cuhva ya? ");
INSERT INTO mihNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tacuan i cahan ñiyɨvɨ, ta yucuan cuenda ñá cuñi ñu tyaa ñu yahvi sii ra Jesús. Zoco i catyi ra Jesús sihin ñu: Tyaa ñiyɨvɨ yahvi sii minoo ra profeta, zoco ñiyɨvɨ ñuu ra ta ñiyɨvɨ vehe ra ña tyaa ñu yahvi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta ñá zavaha ra Jesús cuaha sa ndyityi yucuan vatyi ñá sino iñi ñiyɨvɨ sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Quɨvɨ cuan, ra Herodes ndyaca ñaha nacahnu Galilea, ta i siñi ra tuhun ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ta i catyi ra sihin muzu ra: Ra Juan Bautista cuu ra cuan. Sa nandoto ra, ta yucuan cuenda ndyityi xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tacuan i catyi ra Herodes vatyi maa ra cuu ra i tava tyiño ta i tɨɨn ra sii ra Juan, ta sihñi ra sii ra, ta cuahan ra vehe caa. I zavaha ra sii si sa cuenda ña Herodías, ñazɨhɨ ra Felipe yañi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ra Juan cuu ra i catyi sihin ra Herodes: Ña vaha sa nacuhun ñazɨhɨ yañun. ");
INSERT INTO mihNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","I cuñi ra Herodes cahñi ra sii ra Juan, zoco i yuhu ra sii ñiyɨvɨ vatyi sino iñi tandɨhɨ ñu vatyi cahan ra Juan sa cuenda ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Zoco quɨvɨ tahan si cuiya ra Herodes, i quita zehe ña Herodías vatyi cua cata saha ña nuu ñiyɨvɨ i quisi vico ra. Ta i tahan xaan iñi ra Herodes cuhva i sata saha ña. ");
INSERT INTO mihNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ta i tyiñaha ra Herodes Ndyoo, ta i catyi ra sa ndisa cuii vatyi cua cuhva ra ñaa ñi maa sa cua caca ña. ");
INSERT INTO mihNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ta sa i nacatyi zɨhɨ ña sihin ña ñaa sa cua caca ña, ta i catyi ña sihin ra Herodes: Cuhvon xiñi ra Juan Bautista sii sihin minoo nu coho. Catyi ña. ");
INSERT INTO mihNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","I nducuihya xaan iñi ra rey Herodes sa siñi ra sa cahan ña, zoco sa tyiñaha ra Ndyoo, ta sa siñi ñiyɨvɨ yucu vico cuan. Ta yucuan cuenda i tasi ra tyiño, ta catyi ra vatyi cuhva ra sii si sii ña. ");
INSERT INTO mihNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ta i catyi ra vatyi cahndya yuu ra zucu ra Juan sisi vehe caa. ");
INSERT INTO mihNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ta i quisi ndyaca ra sii si sihin minoo nu coho, ta saha ra sii ña luhlu. Ta i saha maa ña sii si sii zɨhɨ ña. ");
INSERT INTO mihNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tacuan ta i quisi ra sica noo sihin ra Juan, ta i quihin ra coño ñuhu ra Juan, ta i sityihi ra sii si sisi ñuhu. Ta zɨquɨ cuahan ra ta i nacatyi ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ta sa sito ra Jesús cuhva cuan, ta i quita ra sisi minoo barco, ta cuahan ra maa tuhun ñi ra ndya minoo nu yoñi maa ñiyɨvɨ iyo. Zoco i ñihi ñiyɨvɨ tuhun, ta i quita ñu ñuu ñu, ta i sindyico ñu sii ra ityi nu ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ta sa i quita ra Jesús barco, i ndyehe ra cuaha xaan ñiyɨvɨ. Ta i cundahvi xaan iñi ra sii ñu, ta i zanduvaha ra sii ñu cuhu sa sindyaca ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ta cuhva sa cua iñi, i quisi ra i casi ra nu ndyaa ra, ta catyi ra sihin ra: Sahiñi xaan. Ta yoñi ñiyɨvɨ iyo ihya. Catyun sihin ñiyɨvɨ nacuhun ñu. Nacuhun ñu nu iyo ñuu ta zata ñu sa casi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Zoco i catyi ra Jesús sihin ra: Ña tahan si sa cuhun ñu. Cuhva maa ndo sa casi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ta i catyi ra i casi ra Jesús sihin ra: Ñahñi maa sa cumi ndi ihya. Ohon tahan ñi pan, ta uu tahan ñi tyiyaca. ");
INSERT INTO mihNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ta i catyi ra Jesús sihin ra: Ta ndyaca ndo sii si ihya. ");
INSERT INTO mihNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tacuan ta i tava ra Jesús tyiño vatyi nacundyaa ñiyɨvɨ nu cuhu. Ta i quihin ra sihin ndaha ra sa ohon tahan pan cuan ta uu tahan tyiyaca cuan, ta i nandyehe ndaa ra. Ta i saha ra tyahvi ndyoo sii ra Ndyoo, ta zɨquɨ i sahnu ndyihi ra pan cuan, ta saha ra sii si sii ra i casi ra. Ta i zasa maa ra sii si sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ta i sasi tandɨhɨ ñiyɨvɨ. Ta ndaha xaan iñi ñu. Ta zɨquɨ i zanacutu ñu usi uu tahan tyica sihin yɨquɨ pan sa nandoo ta tyiyaca cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ta ñiyɨvɨ i sasi i cuu ohon mil rayɨɨ ta zɨɨn ñu zɨhɨ ta sa ndyihi. ");
INSERT INTO mihNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tacuan ta i catyi ra Jesús sihin ra i casi ra vatyi nandɨhvɨ ra barco ta cuyaha ra inga siyo miñi. Ta cua nandoo ra Jesús, ta cua catyi ra sihin tandɨhɨ ñiyɨvɨ vatyi cunuhu ñu ndya ñuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ta sa yaha natasi ra Jesús sii ñu, ta zɨquɨ i sahan ra minoo yucu maa tuhun ñi ra vatyi cua cahan ra sihin ra Ndyoo. Ta i cuaa, ta ndyaa ra yucuan maa tuhun ñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ta sa cuahan barco cuan mahñu miñi. Nandaa, nanoo tu zacuu ndutya vatyi ñihi xaan ñoho tatyi nu cuahan tu. ");
INSERT INTO mihNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ta ñaa ca i tuhva ra Jesús nu yucu ra. Sica ra nu ndutya. ");
INSERT INTO mihNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ta cuhva sa ndyehe ra sii ra Jesús vatyi sica ra nu ndutya, i yuhu xaan ra, ta i sacu saa ra sihin sa yuhu ra, ta catyi ra: ¡Minoo añima cuu si! ");
INSERT INTO mihNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Zoco i cahan ra Jesús, ta catyi ra: Zandyee ndo iñi ndo. Ma yuhu ndo vatyi mi cui. ");
INSERT INTO mihNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tacuan ta i catyi ra Pedro sihin ra: Tata, tatu zuun yoho cuu, catyun sihin vatyi caque nu ndutya ta sei ndya nu vasun. ");
INSERT INTO mihNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ta i catyi ra Jesús sihin ra: Ñaha. Ta zɨquɨ i quita ra Pedro barco ta i quisaha sica ra nu ndutya ndya nu vasi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Zoco cuhva sa i tuu iñi ra vatyi ñihi xaan ñoho tatyi, ta i yuhu ra. Ta i quisaha ndyee ra sisi ndutya, ta i cana saa ra, ta catyi ra: ¡Tata, zacacun sii! ");
INSERT INTO mihNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ta zuun ñi caa cuhva cuan i natɨɨn ra Jesús ndaha ra, ta i catyi ra sihin ra: ¡Siin xaan sino iñun sii! ¿Ñacu ña nɨɨ iñun? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ta i ndɨhvɨ ra Jesús ta ra Pedro sisi barco, ta i cutaxi tatyi. ");
INSERT INTO mihNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ta zɨquɨ ra ñoho barco cuan, i sicuɨñɨ sɨtɨ ra, ta i zacahnu ra sii ra Jesús, ta catyi ra: Sa ndisa cuii vatyi Zehe ra Ndyoo cuu suun. ");
INSERT INTO mihNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ta i yaha ra miñi, ta i saa ra nu cu si Genesaret. ");
INSERT INTO mihNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ta cuhva sa i nacoto ñiyɨvɨ yucuan sii ra Jesús, ta i zacoto ñu nacaa cahnu, ta i quisi ndyaca ñiyɨvɨ sii tandɨhɨ ñu cuhu ndya nu ndyaa ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ta i sica ñu tumañi iñi sii ra vatyi nacuhva ra sa tɨɨn ñu vazu yuzahma ñi ra. Ta tandɨhɨ ñiyɨvɨ i tɨɨn sii si, i nduvaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tacuan ta zɨquɨ i tuhva zuhva ra fariseo ta ra maestro cuenda ley sii ra Jesús. I quisi ra ndya ñuu Jerusalén, ta i ndaca tuhun ra sii ra Jesús: ");
INSERT INTO mihNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Ñaa cuenda ña zavaha ñiyɨvɨ sica noo suhun costumbre i zandoo ñiyɨvɨ sahnu? Vatyi ña nacatya vaha ñu ndaha ñu ta casi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tacuan i catyi ra cuan, ta zɨquɨ i ndaca tuhun ra Jesús sii ra: ¿Ta ñaa cuenda vatyi ña tyaa maa ndo yahvi sii ley ra Ndyoo vatyi cuñi ndo cundyico ndo costumbre? ");
INSERT INTO mihNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Vatyi i catyi maa ra Ndyoo: “Tyaa ndo yahvi sii zutu ndo ta sii zɨhɨ ndo”, ta “Yoo ra cahan ndya vaha ñi sihin zutu ra a sihin zɨhɨ ra, nacahñi ñiyɨvɨ sii ra.” ");
INSERT INTO mihNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Zoco catyi maa ndo vatyi cuu catyi minoo ra sihin zutu ra a sihin zɨhɨ ra: “Ma cuu tyindyei suun vatyi tandɨhɨ sa iyo sii, saha cuende sii ra Ndyoo.” ");
INSERT INTO mihNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ta yoo ra catyi cuhva cuan, ña cuñi ca si sa tyindyee ra sii zutu ra a sii zɨhɨ ra, catyi maa ndo. Ta sihin cuhva cuan tyaa siyo ndo ley maa ra Ndyoo vatyi cuñi ndo cundyico ndo sii costumbre maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Zaha ndo tuhun vatyi vaha xaan ñiyɨvɨ cuu ndo, zoco ña ndisa! Vaha xaan i cahan ra Isaías sa cuenda ndo quɨvɨ i tyaa ra ihya tuhun i saha ra Ndyoo sii ra: ");
INSERT INTO mihNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ihya ñiyɨvɨ zacahnu ñu sii, sihin yuhu ñu. Zoco ña zacahnu ñu sii, sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nahñi tuhun cuu sa zavaha ñu culto; Zacuaha ñu sii ñiyɨvɨ maa maa cuhva costumbre ñiyɨvɨ. Ta ña zavaha ñu cuhva catyi Tuhun Ndyoo sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tacuan i nacatyi ra Jesús cuhva i tyaa ra Isaías ta sa naha, ta zɨquɨ i cana ra sii ñiyɨvɨ, ta catyi ra sihin ñu: Tyizoho ndo, ta tyituñi iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yɨvɨ sa sasi ñiyɨvɨ ta yɨvɨ sa sihi ñu cuu sa zatɨvɨ añima ñu. Zoco sa quiñi sica iñi ñu ta cahan ñu cuu sa zatɨvɨ añima ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tacuan i catyi ra Jesús, ta zɨquɨ i quisi ra i casi ra, ta i catyi ra sihin ra: ¿Atu siton vatyi i cuxaan ra fariseo sihin cuhva cohon? ");
INSERT INTO mihNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Zoco i nacahan ra Jesús ta catyi ra: Tandɨhɨ yava sa ñá tasi Zuti ra ndyaa andɨvɨ, cua quita ndya yoho si. ");
INSERT INTO mihNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ma tyaa ndo yahvi sii ra fariseo. Cuu ra tañi ra cuaa ta zañaha ra ityi sii inga ra cuaa. Ta tatu zañaha minoo ra cuaa ityi sii inga ra cuaa cua canacava nduu tahan ra sisi minoo xahva. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ta zɨquɨ i catyi ra Pedro sihin ra Jesús: Nacatyun sihin ndi ñaa cuñi si catyi si cuhva i cohon cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ta i catyi ra Jesús: ¿Atu ndya maa ndo ta ña cutuñi iñi ndo? ");
INSERT INTO mihNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Atu ña cutuñi iñi ndo vatyi tandɨhɨ sa sasi ñiyɨvɨ cuahan si ndya sisi ñu ta zɨquɨ quita tucu si? ");
INSERT INTO mihNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Zoco sa quita yuhu ñiyɨvɨ, quita si añima ñu. Ta yucuan cuu sa zatɨvɨ sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vatyi añima ñu quita tandɨhɨ tuhun ña vaha sa sica iñi ñu. Quita tuhun sa cuñi ñu cahñi ñu sii inga ñiyɨvɨ, sa cuñi rayɨɨ sii inga ñaha ta yɨvɨ ñazɨhɨ ra cuu, sa quiñi zavaha ñu, sa zuhu ñiyɨvɨ, sa vatya ñiyɨvɨ, ta sa cahan ñu ndya vaha ñi sii inga ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tandɨhɨ ihya cuu sa zatɨvɨ añima ñiyɨvɨ. Zoco tatu casi ñu ta ma nacatya ñu ndaha ñu tañi catyi costumbre, yɨvɨ sa yucuan cua zatɨvɨ sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","I quita ra Jesús yucuan, ta cuahan ra ndya ñuu Tiro ta ñuu Sidón. ");
INSERT INTO mihNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ta minoo ñaha cananea sa ndyaa yucuan i ndyehe ña sii ra Jesús, ta i cana saa ña, ta catyi ña: ¡Tata, zehe ra David, cundahvi iñun sii! Ñoho minoo tatyi cuihna sii ña luhlu zehi, ta ndyehe xaan ña tundoho. Catyi ñaha cuan sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Zoco ñá nacahan ra Jesús sa cahan ña. Ta zɨquɨ i quisi ra i casi ra Jesús, ta i zañiñi ra sii ra, ta catyi ra: Catyun sihin ña vatyi nacuhun ña vatyi ndyico xaan ña sii yo ta cana saa xaan ña. ");
INSERT INTO mihNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tacuan i catyi ra, ta zɨquɨ i catyi ra Jesús sihin ña: I tasi ra Ndyoo sii mi maa ñi sa cuenda mvee ticatyi hebreo sa cua naa. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Zoco i tuhva ñaha cuan, ta i sicuɨñɨ sɨtɨ ña nuu ra Jesús, ta catyi ña: ¡Tyindyeun sii, tata! ");
INSERT INTO mihNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Zoco i catyi ra Jesús sihin ña: Natyindyee xihna que sii ñiyɨvɨ ñui vatyi ña vaha sa quindyei pan sa casi zehi ta cuhve sii si casi ina. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Zoco i catyi maa ña sihin ra: Ndisa, tata; zoco ndya cuhva ndya ina ta sasi tɨ yu pan sa canacava yumesa nu sasi sitoho tɨ. Ta tacuan tucu ii. ");
INSERT INTO mihNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tacuan i catyi ña, ta zɨquɨ i catyi ra Jesús: ¡Maha, sino xaan iñun sii! Cua cuu si cuhva cuñi moo. Ta zuun ñi cuhva cuan, ndaha nduvaha ñi zehe ña. ");
INSERT INTO mihNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","I quita ra Jesús yucuan, ta i yaha ra yuhu miñi sa nañi Galilea, ta zɨquɨ i ndaa ra minoo yucu, ta i sicundyaa ra yucuan. ");
INSERT INTO mihNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","I saa cuaha xaan ñiyɨvɨ nu ndyaa ra. Sindyaca ñu sii ñu coxo, ta ñu cuaa, ta ñu ñehe, ta ñu cumañi ndaha ta cuaha xaan inga ñu cuhu. I saqui ñu sii ñu nu ndyaa ra Jesús, ta i zanduvaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ta iyo xaan i cuñi ñiyɨvɨ vatyi i cuu nacahan ñu ñehe, ta ñu cumañi ndaha i nacundyaa ndaha ñu. Ta i cuu nacaca ñu coxo ta nandyehe ñu cuaa. Ta i quisaha zacahnu xaan ñiyɨvɨ sii ra cu Ndyoo cuenda ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tacuan ta zɨquɨ i cana ra Jesús sii ra i casi ra, ta i catyi ra sihin ra: Cundahvi xaan iñi sii ñiyɨvɨ ya vatyi sa uñi quɨvɨ ndyaa ñu ihya sihin, ta ñahñi maa sasi ñu. Ña cuñi natasi sii ñu ndya vehe ñu tatu ma casi ñu coto cuañaa ñu ityi cuhun ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tacuan ta i catyi ra i casi ra Jesús sihin ra: Zoco ¿ndya ityi cua quihin yo sa casi cuaha xaan ñiyɨvɨ ya sicuhu ya? Ta yoñi ñiyɨvɨ iyo ihya. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","I ndaca tuhun ra Jesús sii ra: ¿Yozo tahan pan cumi ndo? Ta i catyi ra cuan: Usa tahan ta uu tahan tyiyaca ndyihi. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ta zɨquɨ i catyi ra Jesús vatyi nacundyaa ñiyɨvɨ nu ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ta i quihin ra sa usa tahan pan cuan ta tyiyaca ndyihi cuan sihin ndaha ra, ta saha ra tyahvi ndyoo sii ra Ndyoo. Ta zɨquɨ i sahnu ndyihi ra sii si, ta saha ra sii ra i casi ra, ta i zasa maa ra sii si sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","I sasi tandɨhɨ ñu, ta ndaha xaan iñi ñu. Ta zɨquɨ i zacutu ñu usa tahan tyica sihin yu pan cuan ta tyiyaca sa nandoo cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ñiyɨvɨ i sasi i cuu cumi mil rayɨɨ ta zɨquɨ ñu zɨhɨ ta sa ndyihi. ");
INSERT INTO mihNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yaha cuan ta i natasi ra Jesús sii ñiyɨvɨ ndya vehe ñu, ta i ndɨhvɨ ra barco ta cuahan ra ndya nu cu si Magdala. ");
INSERT INTO mihNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","I quisi ra fariseo ta ra saduceo nu ndyaa ra Jesús vatyi cuñi ra coto ihñi ra sii ra, ta i sica ra sii ra vatyi zañaha ra minoo sa ndyityi sii ra sa quita ndya andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Zoco i nacahan ra Jesús ta catyi ra sihin ra: Sa sahiñi tuhva maa ndo catyi: “Cua cundisi vaha ityaan vatyi cuaha xaan vico.” ");
INSERT INTO mihNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ta sa ñaha ñi tatu cuaha vico, tuhva ndo catyi: “Ña vaha cua cuu quɨvɨ vityi vatyi iñi ñaa.” Zaha ndo tuhun vatyi vaha xaan ndo, zoco ña ndisa ndo. Tuhva ndo nacoto ñaa sa cua coo sa cuenda cuhva caa andɨvɨ, zoco ña nacoto ndo ñaa sa cua cuu ñuu ñiyɨvɨ sa cuenda cuhva ya vityi. ");
INSERT INTO mihNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ñiyɨvɨ ña vaha sa iyo vityi, iyo xaan cuatyi ñu, ta sica ñu sa ndyehe ñu sa ndyityi, zoco minoo ñi zeña cua ndyehe ñu tañi cuhva i cuu sii ra Jonás. Tacuan i catyi ra Jesús, ta zɨquɨ i zandoo ra sii ra cuan ta cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cuhva sa yaha ra i casi ra Jesús ndya inga siyo miñi, i naa iñi ra cuizo ra pan casi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ta zɨquɨ i catyi ra Jesús sihin ra: Ndyehe ndo. Zacuenda ndo sii ndo sihin yusa i siya sii ra fariseo ta ra saduceo. ");
INSERT INTO mihNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tacuan i catyi ra Jesús, ta i natuhun tahan ra i casi ra, ta i catyi ra: Cahan ra tacuan vatyi ñahñi pan ndyizo yo. ");
INSERT INTO mihNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","I sito ra Jesús sa natuhun ra, ta catyi ra: ¿Ñaa cuenda catyi ndo vatyi ñahñi pan ndyizo ndo? ¡Siin xaan sino iñi ndo! ");
INSERT INTO mihNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Atu tañaha ca cutuñi iñi ndo? ¿Atu ña nacohon iñi ndo sa ohon tahan pan i zase sii ohon mil rayɨɨ? ¿Ta yozo tahan ca tyica si i naquihin ndo? ");
INSERT INTO mihNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ta ¿atu ña nacohon iñi ndo sa usa tahan pan i zase sii cumi mil rayɨɨ? ¿Ta yozo tahan ca tyica si i naquihin ndo? ");
INSERT INTO mihNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ta yozo caa vatyi ña tuu iñi ndo vatyi ñá quehin sa cuenda pan cuhva i catyi vatyi nazacuenda ndo sii ndo sihin yusa i siya sii ra fariseo ta ra saduceo? ");
INSERT INTO mihNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tacuan i catyi ra Jesús, ta zɨquɨ i cutuñi iñi ra i casi ra vatyi ña cahan ra Jesús tuhun pan, zoco cahan ra sa cuenda cuhva zacuaha ra fariseo ta ra saduceo (vatyi ña vaha si). ");
INSERT INTO mihNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cuhva i saa ra Jesús ndya nu cu si Cesarea de Filipo i ndaca tuhun ra sii ra i casi ra: ¿Ñaa catyi ñiyɨvɨ yoo ra cuu vii, ra i quisi ndya gloria? ");
INSERT INTO mihNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ta i catyi ra sihin ra: Iyo ñiyɨvɨ catyi vatyi minoo ra i nandoto cuun tañi ra Juan, ra i zacoo ndutya sii ñiyɨvɨ a ra Elías a ra Jeremías a inga ra cu profeta ta sa naha cuun. ");
INSERT INTO mihNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ta zɨquɨ i catyi ra Jesús sihin ra: Ta maa ndo, ¿yoo ra cui catyi maa ndo? ");
INSERT INTO mihNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ta i catyi ra Simón Pedro: Yoho cuu ra Cristo, ra cua zacacu sii ndi. Ta zehe ra Ndyoo ndito cuu suun. ");
INSERT INTO mihNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ta i nacahan ra Jesús, ta catyi ra sihin ra: Zɨɨ xaan cuu suun, Simón, zehe ra Jonás, vatyi yoñi ñiyɨvɨ zañaha cuhva cuan suun. Maa Zuti ra ndyaa andɨvɨ i zañaha cuhva cuan suun. ");
INSERT INTO mihNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ta yuhvi catyi suhun vatyi yoho cuu ra Pedro. Ta nu yuu ya cua zandei vehe ñuhi, ta ma cuu zahacanaa tuhun sihi ta andyaya sii vehe ñuhi. ");
INSERT INTO mihNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ta yuhvi cua cuhve ndaha tɨcuɨ suun sa cuenda nu ndyaca ñaha ra Ndyoo, ta ñaa sa cua cuhñun ihya ñuu ñiyɨvɨ, cua cunuhñi tucu si ityi nuu ra Ndyoo. Ta sa cua ndasun ihya, ñuu ñiyɨvɨ, cua ndasi tucu si ityi nuu ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tacuan i catyi ra Jesús, ta zɨquɨ ñihi xaan i saha ra tyiño sii ra i casi ra vatyi ma nacatyi ra nu sihin minoo ñiyɨvɨ vatyi ra Cristo cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ta ndya cuhva cuan i zacoto ra Jesús casi xaan sii ra i casi ra yozo caa cuñi si sa cuhun ra ñuu Jerusalén. Ta ra mandoñi ta ra zutu nahnu ta ra cu maestro cuenda ley cua zandyehe xaan ra tundoho sii ra. I catyi ra Jesús sihin ra i casi ra vatyi cua cahñi ra cuan sii ra, zoco sa cu uñi quɨvɨ ta cua nandoto ra. ");
INSERT INTO mihNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ta zɨquɨ i tava zɨɨn ra Pedro sii ra, ta ñihi xaan i cahan ra sihin ra, ta catyi ra: ¡Numinoo saha, ta ma tahan si suun, tata! ¡Natyindyee ra Ndyoo suun, ta ma tohon sa tacuan! ");
INSERT INTO mihNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Zoco i nasico cava ra Jesús, ta i catyi ra sihin ra Pedro: ¡Cuɨñɨ siyon sii, cuihna! Zayanga xoon sii, vatyi ña sica iñun cuhva sica iñi ra Ndyoo. Sica iñun cuhva sica iñi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ta zɨquɨ i catyi ra Jesús sihin ra i casi ra: Tatu iyo ra cuñi cundyico sii, nazama ra cuhva iyo ra. Ta ma zacahnu ra sii ra. Ta nandyehe ra tundoho sa cuenda mi. Ta nazavaha ra cuhva zavehi. ");
INSERT INTO mihNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tatu ña cuñi ñiyɨvɨ sa cuu ñu sa cuenda Tuhun Ndyoo, cua cuu ñu, ta cua cuhun ñu andyaya, ta ma cundito ñu sihin ra Ndyoo. Zoco tatu cua cuu ñiyɨvɨ sa cuenda mi a sa cuenda Tuhun Ndyoo cua cundito ñu sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Ñaa sa ñihi ñiyɨvɨ sa zahacanaa ñu tandɨhɨ sa iyo ñuu ñiyɨvɨ ta quɨvɨ cua cuu ñu, ndaha cua naa ñi ñu? ¿Ta yozo caa cuu tyiyahvi ñiyɨvɨ ta ñihi tahvi añima ñu? ");
INSERT INTO mihNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Vatyi yuhvi, ra i quisi ndya gloria, cua quisi inga saha, ta tyaqui xaan cua cui tañi cuhva caa Zuti. Cua quisi sihin ángel, ta zɨquɨ cua tyiyahvi sii minoo minoo ñiyɨvɨ sa cuenda cuhva i zavaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sa ndisa cuii catyi sihin ndo vatyi iyo zuhva ra yucu ihya, ma cuu ra ndya cuhva ndya cua ndyehe ra vatyi ndisi tucu ra i quisi ndya gloria inga saha sihin cuhva cua cundyaca ñaha ra sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","I yaha iñu quɨvɨ, ta zɨquɨ i quihin ra Jesús sii ra Pedro ta ra Jacobo ta ra Juan yañi ra Jacobo ta cuahan ra sihin maa ñi maa ra ndya minoo yucu zucu xaan. ");
INSERT INTO mihNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ta yucuan i zama cuhva caa ra Jesús ityi nuu ra cuan. Ndisi xaan i nduu nuu ra tañi ñicandyi, ta cuisi xaan i nduu zahma ra tañi ñúhu. ");
INSERT INTO mihNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ta zuun ñi cuhva cuan, i ndyehe ra sii ra Moisés ta ra Elías. (Ra i sihi ta sa naha cuu nduu tahan ra cuan.) Natuhun ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ta zɨquɨ i catyi ra Pedro sihin ra Jesús: Tata, ¡vaha xaan yucu yo ihya! Tatu cuñun cua zavaha ndi uñi tahan vehe tyiyahva, minoo cuenda moo, ta minoo cuenda ra Moisés, ta inga si cuenda ra Elías. ");
INSERT INTO mihNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nɨɨ ñi sa cahan ra Pedro, ta i quisi minoo vico ndisi xaan si, ta ndaha tyazi si sii tandɨhɨ ra; ta sisi vico cuan i siñi ra minoo nduzu, ta catyi si: Ra ihya cuu Zehi. Cuñi xein sii ra. Zɨɨ xaan cuñi sihin ra. Cuɨñɨ ndo sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ta sa siñi ra i casi ra Jesús tuhun cuan, i sicava ndyayu ra nu ñuhu, ta i yuhu xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ta zɨquɨ i tuhva ra Jesús sii ra, ta i tyizo ra ndaha ra sii ra, ta catyi ra: Nduvita ndo. Ma yuhu ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ta cuhva sa nandyehe ra, yoñi inga ca ra ndyehe ra, maa ñi ca ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ta cuhva sa vasi noo ra yucu cuan, ñihi xaan i saha ra Jesús tyiño sii ra, ta catyi ra: Ma nacatyi ndo sa ndyehe ndo nu sihin minoo ñiyɨvɨ ndya sa yaha nandoto ra i quisi ndya gloria sisi sa i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tacuan i catyi ra Jesús, ta zɨquɨ i ndaca tuhun ra i casi ra sii ra: ¿Ñaa cuenda catyi ra maestro cuenda ley vatyi tahan si sa quisi xihna ca ra Elías? ");
INSERT INTO mihNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ta i nacahan ra Jesús, ta catyi ra: Sa ndisa vatyi xihna ca cua quisi ra Elías, ta cua zanduvaha ra tandɨhɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Zoco yuhvi catyi sihin ndo vatyi sa i quisi ra Elías, ta ñá nacoto ñiyɨvɨ sii ra. I zavaha ñu sihin ra tandɨhɨ sa cuñi maa ñu. Ta zuun ñi cuhva cuan cua ndyehe tucu ra i quisi ndya gloria tundoho zacuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tacuan i catyi ra Jesús, ta zɨquɨ cutuñi iñi ra i casi ra vatyi cahan ra Jesús tuhun ra Juan, ra i zacoo ndutya sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cuhva sa i nasaa ra nu yucu tuu xaan ñiyɨvɨ, i tuhva minoo ra sii ra Jesús, ta i sicuɨñɨ sɨtɨ ra nuu ra, ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Tata, cundahvi iñun sii ra luhlu zehi. Ñihi xaan tahan ra, ta ndyehe xaan ra tundoho. Cuaha xaan saha nduva ra nu ñoho ñúhu a sisi ndutya. ");
INSERT INTO mihNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","I quisi ndyaque sii ra sii ra sica noo suhun, zoco ñá cuu zanduvaha ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ta i nacahan ra Jesús, ta i catyi ra: ¡Ndoho cuu ñiyɨvɨ ña sino iñi, ta ña vaha ndo! Ma cundyee iñi cundyei sihin ndo naha xaan ca. Ta ndyaca ndo sii ra luhlu ña ihya. ");
INSERT INTO mihNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tacuan ta zɨquɨ i cahan ra Jesús sihin tatyi cuihna, ta i tava ra sii si sii ra luhlu, ta i nduvaha ra zuun ñi caa cuhva cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Cuee ca i cahan ra i casi ra sihin maa ñi maa ra Jesús, ta i catyi ra: ¿Ñacu ñá cuu tava maa ndi sii tatyi cuihna cuan? ");
INSERT INTO mihNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ta i catyi ra Jesús sihin ra: Ñá cuu sii ndo vatyi siin cuii ñi sino iñi ndo. Sa ndisa catyi sihin ndo vatyi tatu sino iñi ndo vazu zuhva ñi tañi cuhva caa minoo sɨtɨ mostaza, cua cuu catyi ndo sihin yucu ya: “Cuɨñɨ siyon ihya, ta cuhun inga ityi.” Ta cua cuɨñɨ siyo si. Ta ñahñi maa sa ma cuu sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Zoco nuu tatyi cuihna sa ñoho sii ra luhlu cuan, quita si maa ñi sa caca ndo sii ra Ndyoo ta coo ndyitya ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nɨɨ ñi sa ɨɨn ñi sica noo ra nu cu si Galilea, i catyi ra Jesús sihin ra: Cua xico minoo ra sii ii, yuhvi ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ta cua cahñi ñiyɨvɨ sii, ta sa cu uñi quɨvɨ cua nandoto tuqui. Ta sa catyi ra Jesús cuhva cuan, cuihya xaan i cuñi ra i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cuhva i saa ra Jesús sihin ra i casi ra ndya ñuu Capernaum, ra zatyiyahvi sii ñiyɨvɨ xuhun cuenda vehe ñuhu i sahan ra i sicahan ra sihin ra Pedro, ta i ndaca tuhun ra sii ra: ¿Atu ña tuhva ra maestro ndo tyiyahvi xuhun cuenda vehe ñuhu? ");
INSERT INTO mihNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ta i catyi ra Pedro: Tuhva ra. Ta cuhva sa quɨhvɨ ra Pedro sisi vehe i cahan xihna ra Jesús sihin maa ra, ta catyi ra: ¿Yozo caa cuñi oo, Simón? ¿Yoo sii zatyiyahvi ra rey, ra ndyaca ñaha ñuu ñiyɨvɨ ya? ¿Atu zatyiyahvi ra sii ñiyɨvɨ sii ra a sii ñiyɨvɨ inga ñuu? ");
INSERT INTO mihNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ta i nacahan ra Pedro ta catyi ra: Sii ñiyɨvɨ inga ñuu zatyiyahvi ra. Ta yɨvɨ sii ñiyɨvɨ sii ra. Ta i catyi ra Jesús sihin ra: Ndisa. Ta ñiyɨvɨ sii ra, ña tahan si tyiyahvi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Zoco ña cuñi yo sa zacuxaan yo sii ñiyɨvɨ. Yucuan cuenda cuahan ndya miñi ta cañun zuelun. Tyiyaca sa cua tɨɨn sii si sa xihna ñi, ndyehun yuhu tɨ, ta cua nañuhun minoo xuhun. Ta maa cuhva ñi tyiyahvun sa cuenda mi ta sa cuenda moo. Cuhun sihin si, ta tyiyahvun. ");
INSERT INTO mihNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Cuhva cuan i tuhva ra i casi ra Jesús sii ra, ta i ndaca tuhun ra sii ra: ¿Yoo nduhvi cuu ra ñiñi ca sa cuenda ra Ndyoo? ");
INSERT INTO mihNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tacuan i catyi ra, ta i cana ra Jesús sii minoo ra luhlu ndya nu ndyaa ra. Ta i sañi ndyaa ra sii ra mahñu nu yucu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ta i catyi ra sihin ra sica noo sihin ra: Sa ndisa catyi sihin ndo vatyi tatu ma zama ndo cuhva iyo ndo ta nduu ndo tañi sa ndyihi sa ñahñi cuatyi, ma cuu quɨhvɨ ndo nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ra ñiñi ca nu ndyaca ñaha ra Ndyoo cuu ra zanduluhlu sii ra ta nduu ra tañi minoo ra luhlu. ");
INSERT INTO mihNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ta yoo cua tɨɨn cuenda vaha sii minoo ra luhlu tañi ra ya sa cuenda mi, tɨɨn cuenda tucu ra sii mi cuhva cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yoo ra cua zañaha sii minoo ra luhlu sa sino iñi sii, tañi ra luhlu ya cuhva zavaha ra sa ña vaha ta ma cundyico ca ra sii, vaha ca tatu sa i sihñi ñiyɨvɨ zucu ra cuan sihin minoo yuu yozo vee xaan ta zavita ñu sii ra sisi tyañuhu yatyi ca. ");
INSERT INTO mihNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ndahvi ñiyɨvɨ ñuu ñiyɨvɨ vatyi tandɨhɨ tyiemvu iyo sa ña vaha sa cuñi ñu zavaha ñu! Ta tacuan cua cuu si, zoco ndahvi ñi cuu ra tyiyuhu sii ñiyɨvɨ ta zavaha ñu cuatyi. ");
INSERT INTO mihNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yucuan cuenda tatu cuñun zavohon sa ña vaha sihin ndohon a sihin sohon, cahndya ndaxun sii si ta zaviton sii si vatyi vaha ca cuhun gloria tañi minoo ra ñahñi ndaha a minoo ra coxo ta ma cuhun andyaya sihin nduu tahan ndohon ta nduu tahan sohon sisi ñuhu sa ma ndahva. ");
INSERT INTO mihNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ta tatu cuñun ndyehun sa ña vaha sihin minoo sɨtɨ nuun, tavon sii si ta zaviton sii si vatyi vaha ca cua quɨhvun gloria sihin minoo ñi sɨtɨ nuun nu ndyaca ñaha ra Ndyoo, ta ma cuhun sihin nduu tahan sɨtɨ nuun andyaya nu cayu ñúhu. ");
INSERT INTO mihNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Zaha ndo cuenda sii ndo, ta ma catyi ndo sa ma tyaa ndo yahvi vazu sii ra ndyihi vatyi catyi sihin ndo vatyi ndya gloria ta ángel zacuenda sii ra ndyihi tandɨhɨ cuii tyiemvu nandyaa ra ityi nuu ra Ndyoo Zuti, ra ndyaa gloria. ");
INSERT INTO mihNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Vatyi yuhvi, ra i quisi ndya gloria, vasi zacaqui sii ra cua naa. ");
INSERT INTO mihNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Yozo caa sica iñi ndo? Tatu iyo minoo ra, ta iyo minoo ziendu mvee ticatyi zono ra ta tatu cua naa minoo tɨ, ¿atu ma zandoo ra sii inga cumi xico sahun cumi tahan tɨ ta cuhun ra ndya yucu ta nanducu ra sii quɨtɨ sa cua naa cuan? ");
INSERT INTO mihNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ta tatu sa nañihi ra sii tɨ, sa ndisa catyi sihin ndo vatyi zɨɨ xaan ca cua cuñi ra sa cuenda tɨ ta zɨquɨ sa cuenda tandɨhɨ inga cumi xico sahun cumi tahan tɨ sa ñá cua naa. ");
INSERT INTO mihNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ta zuun ñi cuhva cuan ña cuñi Zutu yo ra ndyaa andɨvɨ sa cua naa numinoo ra luhlu tañi ra ya. ");
INSERT INTO mihNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Tatu zavaha minoo hermano sa ña vaha suhun. Cuahan ndya vehe ra ta nacahan vohon sihin ra maa tuhun ñi ra ta nacatyun sihin ra ñaa sa ña vaha i zavaha ra suhun. Tatu tyaa ra yahvi sa cohon ta ndaca ra tucahnu iñi suun hermano vaha cua cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Zoco tatu ma tyaa ra yahvi sa cohon sa xihna ñi, cuhun inga saha sihin minoo a uu tahan hermano. Tacuan ta tandɨhɨ sa cohon sihin ra ta cua catyi inga ra ndɨhɨ suhun vatyi sa ndisa cohon, cua cuu ra sa ndaa. ");
INSERT INTO mihNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ta tatu ma tyaa ra yahvi sa cahan inga hermano. Nacatyun nuu tandɨhɨ ra hermano vehe ñuhu ñaa sa ña vaha i zavaha ra suhun. Ta tatu ma tyaa ra yahvi sa cahan tandɨhɨ hermano, catyi ndo vatyi yɨvɨ ca ra sino iñi cuu ra, ta cuu ra tañi minoo ra zavaha sa ña vaha, tañi zavaha ra tava xuhun cuenda ra ndyaca ñaha vatyi sica ra cuaha ca. ");
INSERT INTO mihNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Sa ndisa catyi sihin ndo ñaa sa cua cuhñi ndo ñuu ñiyɨvɨ ya, cua cunuhñi tucu si andɨvɨ. Ta ñaa sa cua ndasi ndo ñuu ñiyɨvɨ ya, cua ndasi tucu si andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ta catyi tuqui sihin ndo vatyi tatu cua ndu‑ɨɨn uu tahan ndo ihya ñuu ñiyɨvɨ sa cuenda sa cua caca ndo, ra Ndyoo Zuti, ra ndyaa andɨvɨ, cua cuhva ra sii si sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Vatyi tatu titahan vazu uu a uñi tahan ndo sa cuenda mi, yucuan ndyei sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tacuan i catyi ra Jesús, ta zɨquɨ i tuhva ra Pedro sii ra, ta i ndaca tuhun ra sii ra: Tata, ¿yozo tahan saha cuñi si sa zehi tucahnu iñi sii minoo hermano tatu zavaha ra sa ña vaha sihin? ¿Atu zehi tucahnu iñi sii ra usa tahan saha? ");
INSERT INTO mihNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ta i catyi ra Jesús sihin ra: Ña catyi suhun vatyi usa tahan saha ñi. Catyi vatyi ndya tañi cumi ziendu cumi xico usi tahan saha a cuaha ca. ");
INSERT INTO mihNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Cuhva ndyaca ñaha ra Ndyoo cuu si tañi minoo rey, ra cuñi coto yozo tavi muzu ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ta sa quisaha tava ra cuenda sa cuenda minoo minoo ra, ta i quisi ndyaca ñu minoo ra tavi xaan sii ra. Cuaha xaan millón tavi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ñá cuu tyiyahvi ra sii ra ta yucuan cuenda i catyi rey cuan vatyi cua xico ra sii ra sihin ñazɨhɨ ra ta zehe ra, ta cua zatyiño ñu tyiño ñiyɨvɨ. Ta cua nduyahvi tandɨhɨ ndaha tyiño ra, ta tacuan ta cua nañihi rey cuan xuhun sa tavi ra cuan sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yucuan cuenda i sicuɨñɨ sɨtɨ muzu ra, ta i zacahnu ra sii ra, ta i catyi ra sihin ra: “Tata, zandyeun iñun ndyehun sii, ta cua tyiyahvi tandɨhɨ sa tavi suun.” ");
INSERT INTO mihNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tacuan ta i cundahvi iñi rey cuan sii muzu ra, ta i zaña ra sii ra, ta i zaha ra tucahnu iñi sii ra sa cuenda tandɨhɨ sa tavi ra sii ra, ta ma tyiyahvi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Zoco zuun ñi muzu cuan i quita ra, ta i nañihi ra sii inga ra cu muzu sihin ra. Tavi ra uu mil ñi sii ra. Ta i tɨɨn cuɨtɨ ra zucu ra, ta i catyi ra: “¡Tyiyahvun sa tavon sii!” ");
INSERT INTO mihNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ta inga muzu cuan i sicuɨñɨ sɨtɨ ra ityi nuu ra, ta i sica ra tumañi iñi sii ra, ta i catyi ra: “Zandyeun iñun ndyehun sii. Ta cua tyiyahvi tandɨhɨ sa tavi suun.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Zoco ñá cuñi ra cundahvi iñi sii ra. Ta cuahan ra sihin ra, i sityihi ra sii ra vehe caa ndya cua tyiyahvi ra sa tavi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ta sa ndyehe inga ra tahan ra, ra cu muzu sihin ra, cuhva i zavaha ra sihin ra ta cuihya xaan i cuñi ra, ta i sahan inga ra ta i nacatyi ra sihin rey tandɨhɨ sa i zacuu ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ta i cana rey sii ra cu muzu, ra tavi xaan sii ra, ta i catyi ra sihin ra: “¡Yoho, muzu ña vaha cuun! Yuhvi i zaha xein tucahnu iñi suun sa cuenda tandɨhɨ sa tavon sii, ta ñá tyiyahvun vatyi i sica xoon tumañi iñi sii. ");
INSERT INTO mihNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ta ¿ñaa cuenda ñá cundahvi iñun sii inga ra cu muzu suhun tañi i cundahvi iñi mi suun?” ");
INSERT INTO mihNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tacuan i catyi rey sitoho muzu cuan, ta i cuxaan xaan ra sihin ra, ta i tava ra tyiño sa cua ndoho ra ndya cua tyiyahvi ra tandɨhɨ sa tavi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tacuan i catyi ra Jesús, ta zɨquɨ i catyi ra: Ta zuun ñi cuhva cuan cua zavaha Zuti, ra ndyaa andɨvɨ, sihin maa ndo tatu ma zaha ndo tucahnu iñi sa ndisa cuii sii inga hermano tatu zavaha ra sa ña vaha suhun. ");
INSERT INTO mihNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sa yaha cahan ra Jesús cuhva cuan, ta i quita ra Galilea, ta i nasaa ra nu cu si Judea sa ndyaa siyo ityi caña ñicandyi siyo yuu Jordán. ");
INSERT INTO mihNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Cuaha xaan ñiyɨvɨ i sindyico sii ra, ta yucuan i zanduvaha ra sii ñu cuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ta i tuhva tucu ra fariseo sii ra Jesús vatyi cuñi ra nducu ra cuhva tyaa ra cuatyi sata ra. Ta i ndaca tuhun ra sii ra Jesús: ¿Atu cuu zandoo rayɨɨ sii ñazɨhɨ ra sa cuñi ñi maa ra? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ta i nacahan ra Jesús, ta catyi ra sihin ra: ¿Atu ta cahvi ca ndo Tuhun Ndyoo nu catyi si vatyi ra i zavaha ñiyɨvɨ sa xihna ñi, i zavaha ra sii minoo rayɨɨ ta sii minoo ñaha? ");
INSERT INTO mihNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yucuan cuenda cua zandoo rayɨɨ sii zutu ra ta zɨhɨ ra, ta cua ndu‑ɨɨn ra sihin ñazɨhɨ ra. Ta sa nduu tahan ñu cua nduu ñu tañi minoo ñi ñiyɨvɨ ityi nuu ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yucuan cuenda ña uu tahan ñiyɨvɨ cuu ñu, minoo ñi. Ta minoo sa zandu‑ɨɨn ra Ndyoo, ña vaha zanduzɨɨn ñiyɨvɨ sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tacuan i catyi ra Jesús ta zɨquɨ i ndaca tuhun ra fariseo sii ra: ¿Ñaa cuenda i saha ra Moisés tyiño vatyi cuu cuhva rayɨɨ minoo tutu divorcio sii ñazɨhɨ ra, ta tacuan ta cuu zandoo ra sii ña? ");
INSERT INTO mihNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ta i catyi ra Jesús sihin ra: Ndava xaan iñi ndo. Yucuan cuenda i saha ra Moisés sa zandoo ndo sii ñazɨhɨ ndo. Zoco ña tacuan i cuu si nu quisaha si. ");
INSERT INTO mihNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ta catyi sihin ndo vatyi tatu zandoo minoo rayɨɨ sii ñazɨhɨ ra ta yɨvɨ cuatyi sa quixi ña sihin inga rayɨɨ cu si ta zandoo ra sii ña ta tindaha ra sihin inga ñaha. Ra zandoo sii ñazɨhɨ sa ñahñi cuatyi cuan, zavaha ra cuatyi sa nañi adulterio. Ta tatu cua tindaha inga ra sihin minoo ñaha i zandoo yɨɨ, ra cua tindaha sihin ña, zavaha tucu maa ra cuatyi adulterio. ");
INSERT INTO mihNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tacuan i catyi ra Jesús, ta zɨquɨ i catyi ra i casi ra sihin ra: Tatu tacuan cuu si sihin rayɨɨ ta ñazɨhɨ ra, vaha ca ma tindaha yo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ta zɨquɨ i catyi ra Jesús sihin ra: Ña tandɨhɨ ñiyɨvɨ cuu cutuñi iñi cuhva ya, maa ñi ñiyɨvɨ sa tyindyee ra Ndyoo sii. ");
INSERT INTO mihNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Iyo ñiyɨvɨ ma cuu tindaha ñu vatyi tacuan ndyaa maa ñu cuhva ndya quɨvɨ i cacu ñu. Ta iyo inga ñiyɨvɨ ma cuu tindaha ñu vatyi sa sicoo cuhva zavaha ñiyɨvɨ sihin ñu. Ta iyo tucu inga ñiyɨvɨ ma tindaha ñu vatyi cuñi ñu zatyiño ñu tyiño ra Ndyoo. Tatu cuu zavaha ndo cuhva ya, zavaha ndo sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tacuan ta zɨquɨ i quisi ndyaca ñiyɨvɨ sii sa ndyihi nu ndyaa ra Jesús vatyi cua tyizo ra ndaha ra xiñi si ta cahan ra sihin ra Ndyoo. Zoco i catyi ra i casi ra Jesús sihin ñiyɨvɨ vatyi ma quisi ndyaca ñu sii sa ndyihi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Zoco i catyi ra Jesús: Ma cahan ndo. Naquisi ndyaca maa ñu sii sa ndyihi sii, vatyi tatu cuñi ñiyɨvɨ sa cua cundyaca ñaha ra Ndyoo sii ñu, cua sino iñi ñu sii, tañi sino iñi sa ndyihi ya. ");
INSERT INTO mihNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tacuan i catyi ra Jesús, ta i tyizo ra ndaha ra xiñi sa ndyihi. Ta zɨquɨ i quita ra yucuan. ");
INSERT INTO mihNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","I sahan minoo ra yoco nu ndyaa ra Jesús, ta i ndaca tuhun ra sii ra: Yoho maestro vaha xoon. ¿Yozo caa zacui ta ñihi tahvi añime? ");
INSERT INTO mihNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ta i catyi ra Jesús sihin ra: ¿Ñaa cuenda catyun vatyi vaha xein? Minoo tuhun ñi ra vaha iyo, maa ra Ndyoo. Tatu cuñun sa ñihi tahvi añimon, zavohon cuhva catyi sa usi tahan ley ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ta i catyi ra cuan sihin ra Jesús: ¿Ndya ley? Ta i catyi ra Jesús sihin ra: Ma cahñun sii ñiyɨvɨ. Ma cuzun sihin inga ñaha sa yɨvi ñazɨhun cuu. Ma zuhun. Ma cohon cuendu zɨquɨ ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tyoon yahvi sii zutun ta sii zɨhun. Ta cuñi xoon sii inga ñiyɨvɨ tañi cuñun sii moo. ");
INSERT INTO mihNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tacuan i catyi ra Jesús, ta i catyi ra yoco cuan sihin ra: Tyei yahvi sii tandɨhɨ tuhun cuan cuhva ndya ta luhli. ¿Ñaa ca sa cumañi sii? ");
INSERT INTO mihNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ta i catyi ra Jesús sihin ra: Tatu cuñun sa ma coo ca cuatyun caña ñi, cuahan, ta xicon tandɨhɨ sa iyo suun, ta cuhvon xuhun cuan sii ñiyɨvɨ ndahvi ta cua coo sa cuca suun gloria, ta quisun ta cundyicon sii. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ta sa siñi ra yoco cuhva cuan, ta i nducuihya xaan iñi ra vatyi cuca xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tacuan ta zɨquɨ i catyi ra Jesús sihin ra i casi ra: Sa ndisa cuii catyi sihin ndo vatyi yɨɨ xaan ta cua quɨhvɨ ñiyɨvɨ cuca nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ta catyi tuqui inga saha vatyi yɨɨ ca quɨhvɨ minoo ra cuca nu ndyaca ñaha ra Ndyoo ta zɨquɨ ca minoo camello yaha tɨ xuu minoo yɨcuɨ tɨcuɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ta sa siñi ra i casi ra Jesús cuhva i cahan ra, ta iyo xaan i cuñi ra, ta i catyi ra: Tatu tacuan cuu si ¿yoo ra cuu cacu? ");
INSERT INTO mihNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ta i ndyehe ra Jesús sii ra, ta catyi ra sihin ra: Tandɨhɨ sa ña cuu zavaha ñiyɨvɨ, cuu zavaha ra Ndyoo sii si. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tacuan ta i catyi ra Pedro sihin ra: Sa zandoo ndi tandɨhɨ sa sii ndi, ta ndyico ndi suun. ¿Ñaa sa cua ñihi maa ndi? ");
INSERT INTO mihNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ta i catyi ra Jesús sihin ra: Sa ndisa catyi sihin ndo vatyi ndoho ra ndyico sii, cuee ca, quɨvɨ cua cundyaa ra i quisi ndya gloria nu tyayu vaha ra sisi gloria ta cua cundyaa tucu maa ndo nu tyayu vaha. Minoo si sii minoo minoo ndo, ta cua tyicuhva ndo sii ñiyɨvɨ hebreo, tandɨhɨ sa usi uu tahan ityi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta tandɨhɨ ñiyɨvɨ sa zandoo vehe ñu a tahan ñu a zutu ñu a zɨhɨ ñu a ñuhu ñu sa cuenda mi, cua ñihi ñu minoo ziendu ca si, ta cua ñihi tahvi añima ñu, ta cua cundito ñu tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Zoco cuaha ñiyɨvɨ ñiñi vityi, yɨvɨ ca ñiyɨvɨ ñiñi cua cuu ñu. Ta ñiyɨvɨ ña ñiñi, cua nduu ñu ñiyɨvɨ ñiñi xaan. ");
INSERT INTO mihNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Cuhva ndyaca ñaha ra Ndyoo cuu si tañi minoo sitoho ñuhu. I quita ra ñaha ñi, ta cuahan ra vatyi cua nducu ra muzu sa cua tohon uva ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta sa yaha zandaa ra tyiño sihin muzu cuan vatyi cua tyiyahvi ra oco usi peso sa minoo quɨvɨ, ta zɨquɨ i tasi ra sii ra nu ndyaa tyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ta i quita tucu sitoho si cuhva caa ɨɨn sa ñaha ñi, ta i ndyehe ra vatyi yucu xaan ñiyɨvɨ nuyahvi, yucu ñi maa ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ta i catyi ra sihin ra: Cuahan tucu ndoho nu iyo tyiñe, ta cua tyiyahvi sii ndo cuhva tahan si. Ta cuahan muzu cuan cuhva catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ta i quita tucu sitoho si cuhva maa ora, ta zuun ñi cuhva cuan i zavaha tucu ra. Ta tacuan tucu caa uñi sa sahiñi. ");
INSERT INTO mihNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ta caa ohon sa sahiñi i sahan tucu ra nuyahvi, ta i nañihi ra sii inga ra ña zatyiño, ta i catyi ra sihin ra: “¿Ñacu yucu ñi maa ndo ihya ndyiyaca, ta ña zatyiño ndo?” ");
INSERT INTO mihNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ta i catyi ra cuan sihin ra: “Vatyi yoñi i saha tyiño sii ndi.” Ta zɨquɨ i catyi sitoho si: “Cuahan tucu ndoho. Cua zatyiño ndo nu iyo tyiñe. Ta cua tyiyahvi sii ndo cuhva tahan si.” ");
INSERT INTO mihNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ta tacuan i cuu si, ta sa sahiñi cuan i catyi sitoho ndaha tyiño cuan sihin ra zacuenda xuhun ra: “Cana sii ra zatyiño, ta tyiyahvun sii ra. Quisohon sihin ra i quisaha zatyiño sa sahiñi ta ndya cuhva ndya ra i quisaha sa xihna ñi.” ");
INSERT INTO mihNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tacuan ta i saa ra i quisaha zatyiño cuhva caa ohon. Ta minoo minoo ra i ñihi ra oco usi peso. ");
INSERT INTO mihNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Cuee ca i tahan si tyiyahvi ra sii ra i quisaha zatyiño sa ñaha ñi, ta i sica iñi ra cuan vatyi cua ñihi ra cuaha ca, zoco zuun ñi cuhva i ñihi maa ra, oco usi peso sa minoo minoo ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sa yaha quihin ra sii si, ta zɨquɨ i quisaha cahan ra sii ra cu patrón ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ta catyi ra: “Inga ra cuan, i saa ra ndya nu ndɨhɨ. I zatyiño ra minoo ora ñi, ta ɨɨn ñi cuhva i tyiyahvun sii ra tañi i tyiyahvun sii maa ndi, ta maa ndi ñihi xaan i zatyiño ndi ndyiyaca cuii nu ndyii.” ");
INSERT INTO mihNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Zoco i catyi sitoho si sihin minoo ra cuan: “Amigo, ñahñi sa ña vaha i zavehi suhun. ¿Atu ñá zandaa yo tyiño vatyi cua tyiyahvi oco usi peso suun? ");
INSERT INTO mihNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Quihin xuhun ya ta cuhun. Inuu ñi cua tyiyahvi sii ra i saa ta sa cuñi ndɨhɨ tyiño tañi cua tyiyahvi suun. ");
INSERT INTO mihNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Atu ñahñi cuhva iyo sii, sa zavehi cuhva cuñi sihin xuhin? ¿Atu cuxoon sa vaha ñiyɨvɨ cui?” ");
INSERT INTO mihNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ta zɨquɨ i catyi tucu ra Jesús: Zuun ñi cuhva cuan, ra saa nu ndɨhɨ, cua cuu ra ra nuu. Ta ra quisaha sa xihna ñi, cua cuu ra nu ndɨhɨ vatyi cane sii cuaha xaan ñiyɨvɨ, zoco zuhva cuii ñi cuu ñiyɨvɨ i casi. ");
INSERT INTO mihNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cuahan ra Jesús ñuu Jerusalén. Ta ityi cuahan ra i tava zɨɨn ra sii sa usi uu tahan ra i casi ra, ta i catyi ra sihin ra: ");
INSERT INTO mihNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Cuahan yo ñuu Jerusalén ya. Ta cua cuhva cuenda ñiyɨvɨ sii ra i quisi ndya gloria ndaha ra cu zutu nahnu ta ra cu maestro cuenda ley, ta cua catyi ra vatyi cua cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ta cua cuhva cuenda ra sii ra sii ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu, ta cua vacu ndyaa ñu sii ra, ta cua cañi xaan ñu sii ra, ta cua cahñi ñu sii ra nu cruz. Ta sa cu uñi quɨvɨ cua nandoto tucu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ta zɨquɨ i tuhva zɨhɨ ra Jacobo ta ra Juan sii ra Jesús. Yɨɨ ña sii ra Zebedeo. I zacahnu ña sii ra Jesús, ta i sica ña minoo tumañi iñi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ta i ndaca tuhun ra Jesús sii ña, ta i catyi ra: ¿Ñaa sa cuñun zavehi? Ta i catyi ña sihin ra: Cuhvon vatyi quɨvɨ cua cundyaca ñohon, cua cundyaa nduu tahan zehi suhun. Minoo ra siyo cuohon ta minoo ra siyo zatyun. ");
INSERT INTO mihNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Zoco i catyi ra Jesús: Ña siton ñaa sa sicon. Ta i catyi ra sihin ra Jacobo ta ra Juan: ¿Atu cundyee ndoho ndyehe ndo tundoho tañi cua ndyehe mi? Ta i catyi ra: Cundyee iñi ndi. ");
INSERT INTO mihNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ta i catyi ra Jesús sihin ra: Ndisa cuii cua ndyehi tundoho ta cua ndyehe ndoho tundoho sa cuenda mi. Zoco sa cundyaa ndo siyo cuehi, ta siyo zatyi, ña tahan si sa yuhvi cuhva. Maa ra Ndyoo Zuti cua catyi yoo ra cua ñihi ndatu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ta sa siñi inga usi tahan ra i casi ra Jesús ta i cuxaan ra sihin ra Jacobo ta ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Zoco i cana ra Jesús sii tandɨhɨ ra, ta i catyi ra sihin ra: Sa sito maa ndo cuhva ndyaca ñaha ñiyɨvɨ ñuu ñiyɨvɨ. Iyo ra cu nuu, ta zacoto ra sii tandɨhɨ ñiyɨvɨ vatyi ndyaca ñaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Zoco ña tacuan cuu si sa cuenda ndoho. Zama si cuhva. Tatu cuñi minoo ra cuu ra ra cahnu, natyindyee ra sii ra tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ta yoo ra cuñi sa cuu ra minoo ra cahnu ityi nuu ra Ndyoo, cuñi si sa nduu ra muzu sii tandɨhɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Vatyi cuhva ndya ra i quisi ndya gloria, ña vasi ra sa vatyi tyindyee ñiyɨvɨ sii ra. Vasi ra sa tyindyee ra sii ñiyɨvɨ. Ta vasi ra sa cuenda sa cua cuu ra sa cuenda ñiyɨvɨ, ta zɨquɨ cua cuu cuhun cuaha ñiyɨvɨ gloria. ");
INSERT INTO mihNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Quita ra ñuu Jericó, ta cuaha xaan ñiyɨvɨ i sindyico sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ta ityi cuahan ra ndyaa uu tahan ra cuaa yu‑ityi. Ta sa i siñi ra sa cua yaha ra Jesús, i cana saa ra, ta catyi ra: ¡Yoho Jesús, zehe ra David, cundahvi iñun sii ndi! Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Cuaha xaan ñiyɨvɨ i cuxaan, ta catyi ñu nacutaxi ra, zoco ñihi ca nduu ra cana saa ra, ta catyi ra: ¡Yoho ra ndyaca ñaha ta ñiyɨvɨ ra David cuun! ¡Cundahvi iñun sii ndi! ");
INSERT INTO mihNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tacuan ta i sicuɨñɨ ra Jesús, ta i cana ra sii ra, ta catyi ra: ¿Ñaa sa cuñi ndo sa zavehi sihin ndo? ");
INSERT INTO mihNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ta i catyi ra cuaa cuan: Maestro, cuñi xaan ndi sa nandyehe ndi. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ta i cundahvi xaan iñi ra Jesús sii ra, ta i tɨɨn ra sɨtɨ nuu ra, ta zuun ñi caa cuhva cuan i cuu nandyehe ra, ta i sindyico ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ta cuhva sa cua saa ra ñuu Jerusalén, i saa ra sa xihna ñi ndya ñuu Betfagé yatyi ñi minoo yucu sa nañi yucu Olivos, ta zɨquɨ i tasi ra Jesús sii uu tahan ra sica noo sihin ra minoo tyiño. ");
INSERT INTO mihNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","I catyi ra sihin ra: Cuahan ndo minoo ñuu sa ndyaa yatyi ñi yucuan, ta cuhva sa quɨhvɨ ndo ñuu cuan, cua nañihi ndo sii minoo burro. Nuhñi tɨ, ta nandyaa zehe tɨ sihin tɨ. Ndasi ndo sii tɨ, ta quisi ndo sihin tɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ta tatu iyo ñiyɨvɨ ndaca tuhun sii ndo ñaa cuenda ndasi ndo sii tɨ, catyi ndo: “Siñi ñuhu tɨ sii ra ndyaca ñaha sii yo.” Ta tacuan ta cua cuhva ra sii tɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ta i cuu tandɨhɨ cuhva cuan vatyi cua natahan si cuhva i catyi minoo ra profeta nu i tyaa ra tyehen: ");
INSERT INTO mihNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ndyehe ndo, vasi rey ndo. Zanduluhlu xaan ra sii ra, ta yozo ra minoo burro luhlu. ");
INSERT INTO mihNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ta cuahan ra sica noo sihin ra Jesús, ta i zavaha ra cuhva i tava ra Jesús tyiño sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","I quisi ndyaca ra sii burro cuan sihin zehe tɨ, ta i tyizo ra zahma sata tɨ, ta i sicozo ra Jesús sii tɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ta cuaha xaan ñiyɨvɨ i saqui zahma ñu ityi. Inga ñu i sahndya ndaha numa ta saqui ñu ityi nu cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ta ñu cuahan ityi nuu ra Jesús, ta ñu vasi ityi sata ra, i cana saa ñu, ta catyi ñu: ¡Cahnu xaan cuu zehe ra David! ¡Vaha xaan cuu ra vasi sa cuenda ra Ndyoo! ¡Nazacahnu yo sii ra Ndyoo! ");
INSERT INTO mihNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ta cuhva sa quɨhvɨ ra ñuu Jerusalén, i ndutɨhvɨ tandɨhɨ ñiyɨvɨ ñuu cuan, ta catyi tandɨhɨ ñu: ¿Yoo ra cuu ra ya? ");
INSERT INTO mihNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ta i catyi ñu: Ihya ra cuu ra Jesús, minoo ra cu profeta. Ra ñuu Nazaret cuu ra nu cu si Galilea. ");
INSERT INTO mihNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tacuan ta i quɨhvɨ ra Jesús nu cuu nuquehe vehe ñuhu cahnu, ta i tava ndyizo ra sii ñu xico ta ñu zata yucuan. Ta i zanduva ihno ra mesa ñiyɨvɨ nazama xuhun ñiyɨvɨ, ta tacuan tucu tyayu ñiyɨvɨ xico paloma. ");
INSERT INTO mihNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ta i catyi ra sihin ñu: Catyi Tuhun Ndyoo: “Vehe mi cuu vehe nu cahan ñiyɨvɨ sihin ra Ndyoo”; zoco maa ndo zacuu ndo vehe ra zuhu sii si. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ta i quisi ra cuaa ta ra coxo nu ndyaa ra Jesús sisi vehe ñuhu, ta i zanduvaha ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Zoco i ndyehe ra zutu nahnu ta ra maestro cuenda ley sa ndyityi i zavaha ra Jesús. Ta i siñi ra vatyi cana saa sa ndyihi sisi vehe ñuhu, ta catyi si: “Cahnu xaan cuu Zehe ra David.” Ta i cuxaan xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ta i catyi ra sihin ra Jesús: ¿Atu siñun sa cahan sa ndyihi cuan? Ta i catyi ra Jesús sihin ra: Siñi sa cahan si. ¿Atu ta cahvi ca ndo Tuhun Ndyoo nu cahan si sa cuenda cuhva ya? Catyi si: Maa ra Ndyoo saha sa cata sa ndyihi ta sa lee, ta vaha xaan cuu cuhva zacahnu si sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tacuan ta zɨquɨ i zandoo ra Jesús sii ñiyɨvɨ sisi vehe ñuhu. I quita ra ñuu Jerusalén, ta cuahan ra ndya ñuu Betania cua cuzu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Inga quɨvɨ ñaha ñi cua nanuhu tucu ra Jesús ndya ñuu Jerusalén, ta i sizoco ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ityi cuahan ra i ndyehe ra minoo yutu higuera, ta i sahan ra i sindyehe ra tatu iñi sɨtɨ tu, zoco ñá ñihi maa ra ndaha ñi. Maa maa ndaha ñi tu iñi. Ta i catyi ra Jesús sihin yutu cuan: Ma cuhva ca moo yucu vixi casi ñiyɨvɨ. Ta zuun ñi caa cuhva cuan, ndaha i na‑ityi ñi tu. ");
INSERT INTO mihNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ta cuhva sa ndyehe ra i casi ra Jesús sii tu, iyo xaan i cuñi ra ta i catyi ra sihin ra Jesús: ¡Yatyi xaan i na‑ityi yutu higuera ya! ");
INSERT INTO mihNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ta i nacahan ra Jesús, ta catyi ra sihin ra: Sa ndisa catyi sihin ndo vatyi tatu nɨɨ xaan cuu iñi ndo, ta ma caca xaan iñi ndo tatu cuu a ma cuu zavaha ndo, cua zavaha ndo cuhva i zavehi sihin yutu higuera ya. Ta ña maa ñi tacuan. Cua cuu tucu cahan ndo sihin yucu ya: “Cuɨñɨ siyon ihya, ta cua ndɨhvun sisi tyañuhun”, cua catyi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ta tandɨhɨ cuii ñaa sa cua caca ndo sii ra Ndyoo, tatu cua sino iñi ndo vatyi cua ñihi ndo sii si, cua ñihi ndisa cuii ndo sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","I quɨhvɨ ra Jesús sisi vehe ñuhu, ta i tuhva ra zutu nahnu ta ra mandoñi sii ra cuhva zacuaha ra, ta i ndaca tuhun ra sii ra: ¿Yoo sa saha tyiño suun vatyi zavohon tandɨhɨ cuhva ya? ¿Ta yoo ra catyi suhun vatyi zavohon sii si? ");
INSERT INTO mihNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ta i nacahan ra Jesús, ta catyi ra sihin ra: Cuñi tuqui nducu tuhin minoo cuhva sii maa ndo. Tatu nacatyi ndo, tacuan ta zɨquɨ cua nacatyi sihin ndo yoo ra saha cuhva sii, ta zavehi cuhva ya. ");
INSERT INTO mihNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Yoo ra i tasi sii ra Juan sa zacoo ndutya ra? ¿Atu i tasi ra Ndyoo sii ra a ñiyɨvɨ? Catyi ndo. Tacuan ta i natuhun tahan ra cuan sihin tahan ra, ta catyi ra: Tatu catyi yo vatyi i tasi ra Ndyoo sii ra Juan, cua catyi ra ya: “¿Ñaa cuenda ñá sino iñi ndo sa cahan ra?” ");
INSERT INTO mihNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Zoco ma cuu catyi yo vatyi ñiyɨvɨ i tasi sii ra Juan vatyi yuhu yo sii ñiyɨvɨ vatyi sica iñi tandɨhɨ maa ñu vatyi ra Juan cuu minoo ra profeta. ");
INSERT INTO mihNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yucuan cuenda i catyi ra sihin ra Jesús: Ña sito ndi yoo ra i tasi sii ra Juan. Ta i catyi ra Jesús sihin ra: Ta yuhvi tucu ma nacatyi tucu vii yoo ra i saha cuhva ya sii. ");
INSERT INTO mihNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","I catyi tucu ra Jesús sihin ra zutu nahnu ta sihin ra mandoñi: ¿Yozo caa sica iñi ndo sa cuenda tuhun ya? Sicoo minoo ra, ta sicoo uu tahan zehe yɨɨ ra. Ta i cahan ra sihin minoo ra, ta catyi ra: “Zehe luhli, cuahan vatyi cua tohon uva.” ");
INSERT INTO mihNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ta i catyi zehe ra: “Ma cuhin.” Zoco cuee ca i ndu‑uu iñi ra cuhva ña vaha i cahan ra sihin zutu ra, ta cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ta i sahan zutu ra i sicahan ra zuun ñi cuhva cuan sihin inga zehe ra. Ta i catyi inga zehe ra: “Cuhin, tata.” Catyi ra. Zoco ñá sahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ta vityi catyi ndo ¿ndya ra i zavaha cuhva cuñi zutu ra? Ta i catyi ra cuan sihin ra Jesús: Ra sa xihna ñi. Ta i catyi ra Jesús sihin ra: Sa ndisa catyi sihin ndo vatyi sa cuu quɨhvɨ ra tava xuhun cuenda ra ndyaca ñaha ta ñiyɨvɨ zɨɨ iñi nu ndyaca ñaha ra Ndyoo, zoco maa ndo ma cuu quɨhvɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Vatyi i quisi ra Juan, ta i zacuaha ra minoo cuhva ndoo xaan sii ndo, ta ñá sino iñi ndo sii ra, zoco ra tava xuhun cuenda ra ndyaca ñaha ta ñu zɨɨ iñi i sino iñi ñu sa cahan ra. Ta vazu ndyehe maa ndo cuhva cuan, zoco ñá zama ndo cuhva iyo ndo, ta ña sino iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Cuɨñɨ ndo inga cuhva ya. Sicoo minoo ra iyo ñuhu, ta i zavaha ra minoo sacu, ta i tasi ra yoho uva sisi si. Ta zɨquɨ i zavaha ra nu cua tava ra ndutya uva ta minoo vehe tyiyahva vatyi cua zacuenda ra sacu ra. Ta i saha noo ra sacu ra sii minoo ityi ra cua zatyiño yucuan. Ta cuahan ra nusica. ");
INSERT INTO mihNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ta saa quɨvɨ sa iyo yucu vixi cuan ta i tasi ra sii muzu ra nu ndyaa ra zatyiño yucuan vatyi cua quihin ra zuhva yucu vixi cuhva tahan si sii patrón ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Zoco ra zatyiño yucuan, i tɨɨn ra sii muzu cuan. I cañi ra sii minoo ra. Minoo ra i sahñi ra. Ta i cañi ra sihin yuu sii inga ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Inga saha i tasi tucu patrón cuan sii inga muzu ra. Cuaha ca ra i tasi ra ta zɨquɨ sa xihna ñi. Ta zuun ñi cuhva ña vaha cuan i zavaha ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ta nu ndɨhɨ tuhun, i tasi ra sii zehe ra nu ndyaa ra zatyiño cuan vatyi catyi ra: “Cua tyaa ra cuan yahvi sii zehi.” ");
INSERT INTO mihNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Zoco cuhva sa ndyehe ra zatyiño sii zehe ra, i natuhun tahan ra sihin tahan ra, ta i catyi ra: “Ihya ra cuu ra cua nañihi ndaha tyiño quɨvɨ cua cuu zutu ra. Nacahñi yo sii ra vatyi ndoo maa yo sihin sacu ya.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ta i tɨɨn ra cuan sii zehe ra, ta i tava ndyizo ra sii ra sata sacu, ta i sahñi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tacuan i catyi ra Jesús, ta zɨquɨ i ndaca tuhun ra sii ra tyizoho: ¿Yozo caa cua zavaha sitoho sacu cuan sihin ra sahñi sii zehe ra? ");
INSERT INTO mihNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ta i nacahan ra yucu yucuan, ta catyi ra: Cua zanaa ra sii ra ña vaha cuan, ta cua cuhva noo ra sacu ra sii inga ra zatyiño vaha, ra cua cuhva yucu vixi cuhva tahan si sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ta i catyi ra Jesús sihin ra: ¿Atu ta cahvi ca ndo Tuhun Ndyoo? nu catyi si tyehen: “I zavita ihno ñiyɨvɨ zandaa vehe sii yuu sa cuñi si sa cuenda sɨquɨ vehe. Ta vityi yuu cuan cuu sa ñiñi ca ta zɨquɨ tandɨhɨ sa cuenda vehe cuan vatyi tacuan catyi maa ra Ndyoo. Ta vaha xaan cuñi yo sihin cuhva ya.” ");
INSERT INTO mihNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yucuan cuenda catyi sihin ndo vatyi ma cuu cuhun ndo nu ndyaca ñaha ra Ndyoo, zoco inga ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu cua cuhun ñu vatyi vaha cuhva zavaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ta yoo ra cua nduva zɨquɨ yuu sa quehin tuhun cuan, cua tahnu cuatyi ra, zoco yoo ra cua canacava yuu cuan zɨquɨ, cua cahnu cuatyi si sii ra sehe sehe. ");
INSERT INTO mihNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ta sa siñi ra zutu nahnu ta ra fariseo cuhva cahan ra Jesús, i cutuñi iñi ra vatyi cahan ra Jesús sa cuenda maa ra. ");
INSERT INTO mihNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","I cuñi ra tɨɨn ra sii ra Jesús, zoco i yuhu ra sii ñiyɨvɨ vatyi sica iñi ñu vatyi minoo profeta cuu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","I quisaha cahan ra Jesús inga saha zɨquɨ minoo cuhva, ta i catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Cuhva ndyaca ñaha ra Ndyoo cuu si tañi minoo rey i zavaha minoo vico tindaha sa cuenda zehe ra. ");
INSERT INTO mihNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ta i tasi ra sii muzu ra vatyi cua cana ra sii ñiyɨvɨ cua quisi vico cuan, zoco ñá cuñi ñu quisi. ");
INSERT INTO mihNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Inga saha i tasi tucu ra sii inga muzu ra, ta catyi ra sihin ra: “Catyi ndo sihin ñiyɨvɨ i cane vatyi sa ndyaa listo sa casi ñu. Sa sahñi zɨndɨquɨ zone ta inga quɨtɨ xahan. Sa ndyaa listo tandɨhɨ. Naquisi maa ñu vico.” ");
INSERT INTO mihNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ta tacuan i nacatyi muzu ra, zoco ñá tyaa ñiyɨvɨ yahvi. Minoo ra cuahan ra nu iyo itu ra, ta inga ra cuahan ra nu iyo inga tyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ta inga ñiyɨvɨ i tɨɨn sii muzu rey cuan, ta i cañi xaan ra sii ra ndya cuhva ndya sahñi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ta sa siñi rey cuan cuhva cuan, i cuxaan xaan ra, ta i tasi ra sii zandaru ra vatyi cua cahñi ra sii ra sahñi sii ra cuan, ta i sahmi ra ñuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ta zɨquɨ i catyi rey cuan sihin muzu ra: “Sa ndyaa listo tandɨhɨ sa cuenda vico tindaha, zoco ñiyɨvɨ i cane, ña vaha ñu vatyi ñá tyaa ñu yahvi sa quehin, ta ña tahan si sii ñu quisi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yucuan cuenda cuahan ndo calle nahnu, ta yoo ra ndyehe ndo cana ndo sii ra naquisi ra vico tindaha.” ");
INSERT INTO mihNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ta cuahan muzu ra, ta i zatitahan ra sii tandɨhɨ ñiyɨvɨ i nañihi ra, ñiyɨvɨ vaha ta ñiyɨvɨ ña vaha, ta i sicoo cuaha xaan ñiyɨvɨ vico tindaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tacuan ta i quɨhvɨ rey cuan vatyi cua ndyehe ra sii ñiyɨvɨ i saa vico cuan, ta yucuan i ndyehe ra sii minoo ra ña ñoho zahma cuenda vico tindaha. ");
INSERT INTO mihNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ta i catyi ra sihin ra: “Amigo, ¿yozo caa i quɨhvun ta ña ñohon zahma sa cuenda vico tindaha?” Catyi ra. Zoco ñá nacahan maa ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ta zɨquɨ i catyi rey cuan sihin muzu ra: “Cuhñi ndo saha ra ta ndaha ra ta zavita ndo sii ra nu ñaa, ityi sata nu cua vacu xaan ñiyɨvɨ ndya cuhva casi quihñi noho ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Vatyi i cane sii cuaha xaan ñiyɨvɨ, zoco zuhva ñi ñu i casi ta cuu quɨhvɨ ñu.” ");
INSERT INTO mihNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tacuan ta zɨquɨ i titahan ra fariseo ta i zacasi tahan ra tyiño minoo cuhva cua zavaha ra ta cua nducu ra cuhva sihin ñaa minoo tuhun ña vaha cua cahan ra Jesús, ta cua tyaa ra cuatyi sata ra. ");
INSERT INTO mihNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ta i tasi ra fariseo sii zuhva ra ndyico sii ra sihin ra ndyico sii ra rey Herodes, ta i catyi ra sihin ra Jesús: Maestro, sito ndi vatyi ra vaha xaan cuun ta zañohon ityi ra Ndyoo sa ndisa. Ta inuu ndita ñi tyoon yahvi sa cahan ñiyɨvɨ cuca ta ñiyɨvɨ ndahvi. ");
INSERT INTO mihNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yucuan cuenda nacatyun sihin ndi, ¿yozo caa sica iñun? ¿Atu vaha tyiyahvi yo xuhun sii ra ndyaca ñaha César a ña vaha? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Zoco i tuu iñi ra Jesús vatyi ña vaha añima ra cuan. Ta i catyi ra sihin ra: ¿Ñaa cuenda nducu coto ihñi ndo sii? ndoho ra zaha tuhun vatyi vaha xaan ndo zoco ña ndisa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Zañaha ndo minoo xuhun sii. Catyi ra. Ta i quisi ndyaca ra minoo xuhun sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ta i ndaca tuhun ra Jesús sii ra: ¿Yoo sii nuu ndyaa ya? ¿Ta yoo sii zɨvɨ ndyaa ya? ");
INSERT INTO mihNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ta i catyi ra cuan. Sii ra gobierno César. Ta zɨquɨ i catyi ra Jesús sihin ra: Cuhva ndo sii ra César sa cuu sii maa ra. Ta cuhva ndo sii ra Ndyoo sa cuu sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ta sa siñi ra cuan sa cahan ra Jesús, ta iyo xaan i cuñi ra, ta i zandoo ra sii ra ta cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Zuun ñi quɨvɨ cuan sahan zuhva ra saduceo cua cahan ra sihin ra Jesús. Ra saduceo cuu ra catyi vatyi ma nandoto tucu ñiyɨvɨ i sihi. Yucuan cuenda i ndaca tuhun ra sii ra Jesús cuhva ya: ");
INSERT INTO mihNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Maestro, i catyi ra Moisés vatyi tatu sihi minoo rayɨɨ ta ndoo ndahvi ñazɨhɨ ra ta yoñi zehe ra, natindaha yañi ra sihin ñaha cuan. Ta cua coo zehe ra sihin ña sa cuenda yañi ra, ra i sihi cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sicoo usa tahan rayɨɨ sihin yañi ra. I tindaha ra nuu. Ta i sihi ra, ta yoñi zehe ra i sicoo. I zandoo ra sii ñazɨhɨ ra cuenda yañi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ta tacuan tucu i zavaha ra cu uu, ta ra cu uñi ta cuhva ndya ra cu usa. ");
INSERT INTO mihNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ta nu ndɨhɨ tuhun i sihi ndɨhɨ tucu maa ñaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yucuan cuenda cuñi ndi coto ndi, ¿yoo ra cua cuu yɨɨ ña quɨvɨ cua nandoto ñiyɨvɨ? vatyi ñazɨhɨ tandɨhɨ sa usa tahan ra i cuu sii ña. Tacuan i catyi ra cuan sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ta i nacahan ra Jesús, ta i catyi ra sihin ra: Ña sito ndo ñaa sa cahan ndo vatyi ña sito ndo ñaa sa catyi Tuhun Ndyoo. Ta ña sito ndo vatyi iyo xaan cuhva sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ñiyɨvɨ cua nandoto inga ñuu ñiyɨvɨ saa, ma tindaha ca ñu indyacuan, ta ma cuhva ca ñiyɨvɨ sii zehe ñu sa tindaha ñu. Cua nduu ñu tañi ángel ra Ndyoo sa iyo andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ta sa cuenda tuhun tatu nandoto ñiyɨvɨ a ma nandoto ñu, ¿atu ta cahvi ca ndo sa i cahan ra Ndyoo sihin ndo? nu i catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yuhvi cui Ndyoo sii ra Abraham ta sii ra Isaac ta sii ra Jacob.” Yɨvɨ Ndyoo sii ñiyɨvɨ ndaha sihi cuii cuu ra. Ndyoo cuu ra sii ñiyɨvɨ cua cundito tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tacuan i catyi ra Jesús, ta sa siñi tandɨhɨ ñiyɨvɨ, iyo xaan i cuñi ñu sihin cuhva i zacuaha ra. ");
INSERT INTO mihNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Zoco cuhva i siñi ra fariseo vatyi i zacutaxi ra Jesús sii ra saduceo, ta i titahan ra fariseo. ");
INSERT INTO mihNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ta minoo ra fariseo, ra cu minoo abogado, i ndaca tuhun ra sii ra Jesús vatyi cuñi ra nducu coto ihñi ra sii ra. Ihya cuu sa ndaca tuhun ra: ");
INSERT INTO mihNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Maestro, ¿ndya cuu ley ra Ndyoo sa ñiñi ca? ");
INSERT INTO mihNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ta i catyi ra Jesús sihin ra: Ley sa ñiñi ca sii ra Ndyoo catyi si: “Nihi xaan cuñi ndo sii Ndyoo Zutu ndo sihin añima ndo. Ɨɨn ñi sii ra caca iñi ndo; ɨɨn ñi sihin ra cahan ndo; ɨɨn ñi tyiño ra zatyiño ndo.” ");
INSERT INTO mihNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ihya cuu sa xihna ñi ley ra Ndyoo, ta ley sa ñiñi ca cuu si. ");
INSERT INTO mihNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ta sa cu uu ley, ɨɨn ñi sasi tahan si sihin ley sa xihna ñi cuan. Catyi si: “Cuñi xaan ndo sii tandɨhɨ inga ñiyɨvɨ tañi cuñi ndo sii maa ndo.” ");
INSERT INTO mihNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ñahñi inga ca ley ñiñi ca ta zɨquɨ nduu tahan ley ya. Tandɨhɨ inga ley ra Ndyoo ta tandɨhɨ sa i tyaa tandɨhɨ ra profeta, sasi tahan si sihin nduu tahan ley ya, ta tyaa si yahvi sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Cuhva sa yucu ra fariseo ɨɨn ñi yucuan i ndaca tuhun ra Jesús sii ra: ");
INSERT INTO mihNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Yozo caa sica iñi maa ndo sa cuenda ra Cristo? ¿Yoo zehe sii ra? Ta i catyi ra fariseo cuan sihin ra: Zehe ra David. ");
INSERT INTO mihNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ta zɨquɨ i catyi ra sihin ra: ¿Ñaa cuenda vatyi cuhva i cahan ra David cuhva cuñi Tatyi Ii ta i catyi ra vatyi ra ndyaca ñaha sii ra cuu ra Cristo? Ihya cuu sa i tyaa ra David: ");
INSERT INTO mihNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Cahan ra Ndyoo sihin ra ndyaca ñaha sii mi, ta catyi ra: “Cundyoon siyo cuehi ndya cuhva ndya cua saa quɨvɨ cua cuhve cuhva cua zahacanoon sii ñiyɨvɨ xaan iñi suun.” Tacuan i tyaa ra David catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tatu zuun ñi ra David catyi vatyi ra ndyaca ñaha sii ra cuu ra Cristo, ¿yozo caa cuu cuu ra Cristo zehe ra David? ");
INSERT INTO mihNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ta sa catyi ra Jesús cuhva cuan, ta yoñi i cuu nacatyi cuhva sa ndaca tuhun ra. Ta ndya quɨvɨ cuan, yoñi ca i caña iñi ndaca tuhun ñaa inga tuhun sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tacuan ta zɨquɨ i cahan ra Jesús sihin tandɨhɨ ñiyɨvɨ ta sihin ra i casi ra, ta i catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Sica iñi ra maestro cuenda ley ta ra fariseo vatyi cuu nacatyi ra tandɨhɨ cuii sa cuñi catyi ley ra Moisés. ");
INSERT INTO mihNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yucuan cuenda tandɨhɨ sa catyi ra cuan, tyaa ndo yahvi sii si, ta zavaha ndo sii si, zoco ma zavaha ndo cuhva zavaha maa ra vatyi cahan ra minoo cuhva ta zavaha ra inga si. ");
INSERT INTO mihNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Zanducuaha ca ra ley i tasi ra Ndyoo ta sa naha. Yoñi sa cuu zavaha tandɨhɨ sii. Ta nu maa ra ta ña zavaha ra tandɨhɨ si vatyi sa sito ra vatyi ma cuu. ");
INSERT INTO mihNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ta tandɨhɨ sa zavaha ra, zavaha ra sii si vatyi cuñi ra sa cua ndyehe ñiyɨvɨ. Cuaha xaan Tuhun Ndyoo tyaa ra nu tutu quehen xaan ta tyaa ra sii si yɨquɨ nuu ra ta zucu ndaha ra, ta nañi xaan yuhva tyaqui yuzahma ra. ");
INSERT INTO mihNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Cuñi xaan ra cundyaa ra tyayu vaha nu sasi ñiyɨvɨ zavaha vico. Ta cuñi xaan ra sa cundyaa ra nu ndyaa ñiyɨvɨ ñiñi sisi vehe ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ta cuñi ra vatyi tyaa xaan ñiyɨvɨ yahvi sii ra ta cuhva ñu nacumi sii ra nuyahvi ta catyi ñu maestro sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Zoco maa ndo, ma cuhva ndo sa catyi ñiyɨvɨ maestro sii ndo vatyi iyo minoo ñi ra cuu Maestro ndo, ra Cristo. Ta tandɨhɨ maa ndo, yañi ndo cuu sihin tahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ta ma catyi ndo zutu ndo sii ra iyo ihya ñuu ñiyɨvɨ vatyi iyo minoo ñi ra cu Zutu yo. Ra ndyaa andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ta ma catyi ndo vatyi minoo ndo cuu ra cu nuu, vatyi maa ñi ra Cristo cuu ra cu nuu sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ra cahnu ca nu yucu maa ndo cuu ra cua nduu muzu sii tandɨhɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ta yoo ra cua zanducahnu sii ra, cua zanduluhlu ra Ndyoo sii ra. Ta ra zanduluhlu sii, cua zanducahnu ra Ndyoo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Zoco ¡ndahvi ndoho ra maestro cuenda ley ta ra fariseo! Zaha ndo tuhun vatyi vaha xaan ndo, zoco ña ndisa vatyi nacazi ndo yuvehe gloria, ta ña cuu quɨhvɨ ñiyɨvɨ. Ñá quɨhvɨ maa ndo, ta nu ña saha ndo quɨhvɨ inga ñiyɨvɨ cuñi quɨhvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Ndahvi ndoho ra maestro cuenda ley ta ra fariseo! Zaha ndo tuhun vatyi vaha xaan ndo, zoco ña ndisa vatyi quindyaa ndo vehe ñundahvi, ñu sihi yɨɨ, ta zɨquɨ zandavi ñaha ndo vatyi vaha xaan ndo, ta naha xaan cahan ndo sihin ra Ndyoo. Sa cuenda sa zavaha ndo cuhva ya, ta ñihi xaan ca cua tasi tuñi ra Ndyoo sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Ndahvi ndoho ra maestro cuenda ley ta fariseo! Zaha ndo tuhun vatyi vaha xaan ndo, zoco ña ndisa. Nanducu ndo nacahnu ñuu ñiyɨvɨ, ta yaha ndo tyañuhu vatyi cuñi ndo nañihi ndo vazu minoo tuhun ñi ñiyɨvɨ cua zasino ndo iñi ñu cuhva sino iñi maa ndo. Ta sa nañihi ndo sii ra cuan ta zananduu ndo sii ra uu cuhva quiñi ca ta zɨquɨ maa ndo. Ta ndisa xaan cuu si vatyi cua cuhun tandɨhɨ ndo andyaya. ");
INSERT INTO mihNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Ndahvi ndoho! Ra cuaa cuu ndo, ta cuñi ndo zañaha ndo ityi sii inga ñiyɨvɨ. Catyi ndo: “Cuu tyiñaha ñiyɨvɨ Ndyoo nuu ñiyɨvɨ ta cahan ñu zɨvɨ vehe ñuhu cahnu, zoco ma zavaha ñu cuhva catyi ñu. Zoco tatu cahan ñu sa cuenda xuhun cuaan sa iyo sisi vehe ñuhu cuan, tacuan ta zɨquɨ ñiñi xaan cua zavaha ñu cuhva catyi ñu.” Catyi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ra tondo cuu ndo ta ra laa cuu ndo. ¿Atu cahnu ca cuu xuhun cuaan ta zɨquɨ vehe ñuhu sa zandu‑ii sii si? Ña tacuan. ");
INSERT INTO mihNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ta catyi ndo: “Yoo ra cua tyiñaha Ndyoo nuu ñiyɨvɨ ta cahan ra zɨvɨ altar, zoco ma zavaha ra cuhva catyi ra. Zoco tatu cahan ra tuhun sa yozo nuu altar cuhva cuan, tacuan ta zɨquɨ iyo cuatyi ra tatu ma zavaha ra cuhva catyi ra.” Catyi maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ra tondo ta ra laa cuu ndo. ¿Atu cahnu ca cuu sa yozo nuu altar cuan ta zɨquɨ altar sa zandu‑ii sii si? Ña tacuan. ");
INSERT INTO mihNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ta yoo ra tyiñaha Ndyoo nuu ñiyɨvɨ ta cahan ra zɨvɨ altar, zavaha ra sii si sa cuenda altar ta ndya sa cuenda tandɨhɨ sa yozo nuu si. ");
INSERT INTO mihNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ta yoo ra tyiñaha Ndyoo nuu ñiyɨvɨ ta cahan ra zɨvɨ vehe ñuhu, zavaha ra sii si sa cuenda vehe ñuhu ta sa cuenda ra Ndyoo, ndɨhɨ ca. ");
INSERT INTO mihNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ta ra tyiñaha Ndyoo nuu ñiyɨvɨ ta cahan ra zɨvɨ andɨvɨ, zavaha ra sii si ndya sa cuenda tyayu ra Ndyoo ta ndya sa cuenda ra Ndyoo ra ndyaa nuu si. ");
INSERT INTO mihNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Ndahvi ndoho ra maestro cuenda ley ta ra fariseo! Zaha ndo tuhun vatyi vaha xaan ndo, zoco ña ndisa vatyi cahvi ndo ndaha menta ndo ta sɨtɨ anís sihin sɨtɨ comino ta saha ndo minoo minoo sisi sa usi tahan si sii ra Ndyoo, zoco ña tyaa ndo yahvi sa ñiñi ca sa catyi ley tañi sa zavaha ndo sa ndoo ta sa cundahvi iñi ndo sii ñiyɨvɨ ta sa cunɨɨ xaan iñi ndo sii ra Ndyoo. Cuñi si sa zavaha ndo cuhva ya, ta ma zaña ndo sa cuhva tucu ndo diezmo cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ra cuaa cuu ndo, ta cuñi ndo zañaha ndo ityi sii inga ñiyɨvɨ. Zacuenda xaan ndo sii ndo ta ña zavaha ndo cuatyi ndyihi, zoco zavaha ndo cuatyi nahnu xaan sa ña tyaa ndo yahvi ley cuan. Cuu si tañi tava ndo tyiyucu ndyihi nuu calu ndo ta zɨquɨ coco ndo quɨtɨ nahnu ca sa nañi camello. ");
INSERT INTO mihNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Ndahvi ndoho ra maestro cuenda ley ta ndoho ra fariseo! Zaha ndo tuhun vatyi vaha xaan ndo, zoco ña ndisa. Nacatya xaan ndo sata coho ta sata vaso, zoco añima ndo situ cuii sa ña vaha sa zavaha ndo tañi sa zuhu ndo ta cuhva ña cuu cundyaca ñaha ndo sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ndoho ra fariseo cuaa, catyi ra Jesús, xihna ca zandundɨun ityi sisi vaso ta coho, ta zɨquɨ cua ndundɨɨ tucu ityi sata si. ");
INSERT INTO mihNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Ndahvi ndoho ra maestro cuenda ley ta ra fariseo! Zaha ndo tuhun vatyi vaha xaan ndo, zoco ña ndisa. Cuu ndo tañi ñaña sa zandutyaqui xaan ñiyɨvɨ ityi sata, zoco ityi sisi maa maa yɨquɨ ndɨyɨ ñoho ta tandɨhɨ inga nuu sa quiñi caa. ");
INSERT INTO mihNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ta tacuan iyo maa ndo. Vaha xaan ñiyɨvɨ cuu ndo cuhva caa ndo ityi nuu ñiyɨvɨ, zoco añima ndo situ cuii si sihin cuhva zandavi ñaha ndo ta tandɨhɨ inga nuu sa ña vaha sa zavaha ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Ndahvi ndoho ra maestro cuenda ley ta ra fariseo! Zaha ndo tuhun vatyi vaha xaan ndo, zoco ña ndisa vatyi tyaqui zavaha ndo ñaña ra i cuu profeta ta zandutyaqui ndo ñaña ñiyɨvɨ vaha. ");
INSERT INTO mihNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ta catyi ndo: “Tatu sa vatyi i sindito maa ndi quɨvɨ i sahñi ñiyɨvɨ sahnu sii ndi sii ra profeta, maa ndi ma ndoo ndi vaha sa cahñi ra sii ra.” ");
INSERT INTO mihNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ta sihin cuhva cahan ndo, zuun ñi maa ndo saha sa ndaa sa cuenda ndo vatyi zutu ndo sii ra i sahñi sii ra profeta. ");
INSERT INTO mihNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Zavaha ca ndo cuhva ña vaha sa i quisaha zutu ndo! ");
INSERT INTO mihNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Tañi coo cuu ndo, zehe quɨtɨ xaan! ¿Yozo caa cuu cacu ndo ta ma cuhun ndo andyaya? Ma cuu. ");
INSERT INTO mihNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yucuan cuenda cua tasi sii ra profeta ta sii ra iyo xaan sa siñi tuñi ra Ndyoo sii, ta sii ra cua zacuaha Tuhun Ndyoo sii ndo. Zoco maa ndo cua cahñi ndo sii zuhva ra ta zuhva ra cua tyaa ndo nuu cruz. Ta inga ra cua cañi ndo sisi vehe ñuhu ndo ta cua zayanga ndo sii ra ta zayuhu ndo sii ra, ta cua cono ra ndya minoo ñuu ta ndya inga ñuu. ");
INSERT INTO mihNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ta yucuan cuenda sata maa ndo cua ndoo cuatyi sa cuenda tandɨhɨ ñiyɨvɨ vaha i sahñi ñiyɨvɨ ndya ra Abel, ra ndoo xaan, ta ndya cuhva ndya ra Zacarías zehe ra Berequías, ra i sahñi ndo sisi vehe ñuhu mahñu nu ii xaan sihin altar. ");
INSERT INTO mihNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sa ndisa catyi sihin ndo vatyi cua ndoo cuatyi sa cuenda tandɨhɨ ya sata ñiyɨvɨ iyo vityi. ");
INSERT INTO mihNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Ndahvi yoho ñuu Jerusalén! Sahñi ñiyɨvɨ sii ra profeta ihya, ta ra tasi ra Ndyoo ihya, cañi ñu sii ra sihin yuu. ¡Cuaha xaan cuaha xaan saha cuñi zandu‑ɨin sii ñiyɨvɨ ñuu ya ta zacuende sii ñu tañi zacuenda minoo ndɨvɨ sii zehe tɨ sisi ndisi tɨ, zoco ña cuñi ñu! ");
INSERT INTO mihNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ndyehe ndo vityi, ndoho ñiyɨvɨ ñuu Jerusalén, vatyi vityi zandoi sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Vatyi catyi sihin ndo vatyi ma ndyehe ca ndo sii, ndya cuhva ndya quɨvɨ cua catyi ndo vatyi vaha xaan cuu ra vasi sa cuenda ra ndyaca ñaha sii yo. ");
INSERT INTO mihNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","I quita ra Jesús vehe ñuhu ta sa cuahan ra ityi ta i tuhva ra i casi ra sii ra ta i quisaha zañaha ra sii ra Jesús cuhva caa vehe ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Zoco i nacahan ra Jesús ta catyi ra sihin ra: ¿Atu ndyehe ndo tandɨhɨ ihya? Sa ndisa catyi sihin ndo vatyi numinoo yuu ya ta ma ndoo si zɨquɨ tahan si. Cua tani tandɨhɨ si. (Sihin cuhva ya zacoto ra Jesús vatyi cua zatɨvɨ ndɨhɨ ñiyɨvɨ vehe ñuhu cuan.) ");
INSERT INTO mihNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tacuan ta zɨquɨ cuahan ra yucu sa nañi Olivos. Ta sa sindyaa ra Jesús yucuan, ta i tuhva ra i casi ra sii ra, ta xehe ñi i cahan ra sihin ra, ta catyi ra: Cuñi ndi sa nacatyun sihin ndi ama cua coo cuhva cuan. ¿Ñaa zeña cua ndyehe ndi, ta cua coto ndi vatyi sa cuñi quisun ta sa cuñi naa ñuu ñiyɨvɨ? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ta i nacahan ra Jesús, ta catyi ra sihin ra: Zacuenda ndo sii ndo coto zandavi ñaha ñiyɨvɨ sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vatyi cuaha xaan ra cua quisi, ta cua catyi ra vatyi vasi ra sa cuenda mi, ta cua catyi ra: “Yuhvi cui Cristo.” Ta cua zandavi ñaha ra sii cuaha xaan ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Cua cuɨñɨ ndo tuhun vatyi cua coo cuatyi ta cahñi tahan xaan ñiyɨvɨ, zoco ma yuhu ndo. Xihna ca cua cuu tandɨhɨ cuhva cuan, cumañi ca sa saa quɨvɨ naa ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Vatyi cua cahñi tahan minoo ñuu sihin inga ñuu, ta cua coo cuatyi ñuu nahnu sihin inga ñuu nahnu. Ta cua coo tama ta cuehe ta cua coo sa taan nahnu xaan zɨɨn zɨɨn ityi. ");
INSERT INTO mihNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ta tandɨhɨ cuhva ya, nu nacaa cua quisaha ndyehe ñiyɨvɨ tundoho. ");
INSERT INTO mihNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ta zɨquɨ cua cuhva cuenda ñiyɨvɨ sii ndo sii ra ndyaca ñaha vatyi cua ndoho ndo. Ta cua cahñi ñiyɨvɨ sii zuhva ndo. Ta tandɨhɨ ñiyɨvɨ ñuu ñiyɨvɨ cua cuxaan xaan ñu ndyehe ñu sii ndo sa cuenda mi. ");
INSERT INTO mihNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ta quɨvɨ cuan, cuaha xaan ñiyɨvɨ sino iñi sii, cua ndoyo ñuhu ñu. Ta cua xico tuhun ra sii tahan ra. Ta ma cuu ca ndyehe ra sii tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Cua coo cuaha xaan ra vatya. Cua catyi ra vatyi cahan ra sa cuenda ra Ndyoo, ta cua zandavi ñaha ra sii cuaha xaan ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cuaha xaan sa quiñi cua coo ndya cuhva ndya ma cuñi ca ñiyɨvɨ sii tahan ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Zoco ra ma zaña tuhin ndya nu cua ndɨhɨ ñuu ñiyɨvɨ, cua cacu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ta Tuhun Vaha sa cuenda cuhva ndyaca ñaha ra Ndyoo, cua zacoto ñiyɨvɨ sii si nacahnu ñuu ñiyɨvɨ, ta cua cuɨñɨ tandɨhɨ ñiyɨvɨ sii si, ta zɨquɨ cua naa ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tatu ndyehe ndo minoo sa zatɨvɨ xaan ta quiñi xaan zacuu si, ta nandyaa si cuan nu ii cuhva i catyi ra profeta Daniel, cutuñi iñi ndo ndoho ra cahvi tuhun ya, ");
INSERT INTO mihNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tatu ndyehe ndo sii si cuan, nacono ñiyɨvɨ ñoho Judea, ta naquɨhvɨ xehe ñu ndya yucu. ");
INSERT INTO mihNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tatu iyo ra yozo xiñi vehe ra quɨvɨ cuan, ma cuatu ra numaa iyo ndaha tyiño cuñi ra tava ra sisi vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ta ra ñoho itu ra, ma cunuhu ra ndya vehe ra sa cua naquihin ra zahma ra. ");
INSERT INTO mihNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ta ndahvi ñu zɨhɨ sa ñoho zehe quɨvɨ cuan a tatu iyo zehe ñu sa tyaxi quɨvɨ cuan vatyi cahnu xaan tundoho cua ndyehe ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ta caca ndo sii ra Ndyoo vatyi ma tahan si cono ndo quɨvɨ vico zavi a minoo quɨvɨ quitatu ñiyɨvɨ ");
INSERT INTO mihNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","vatyi tatu tacuan tahan si, yaha xaan cuaha tundoho cua coo, minoo cuhva ta coo ca ndya cuhva ndya quɨvɨ i sino ñuu ñiyɨvɨ ta ma coo ca tundoho cahnu xaan tañi tundoho ya inga saha ndaha ñi. ");
INSERT INTO mihNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tatu ma zanduzuhva ra Ndyoo quɨvɨ tundoho cuan, yoñi ñiyɨvɨ cua cacu. Zoco cua zanduzuhva ca ra sii si sa cuenda ñiyɨvɨ i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tatu catyi minoo ra sihin ndo: “Ihya ndyaa ra Cristo” a “Yucuan ndyaa ra”, catyi ra, ma sino iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Vatyi cua nduvita cuaha xaan ra zandavi ñaha, ta cua catyi ra vatyi Cristo cuu ra, ta cua catyi ra vatyi cahan ra tuhun saha ra Ndyoo sii ra. Ta cua zavaha ra zeña nahnu ta sa ndyityi ndya cuhva ndya sii ñiyɨvɨ i casi ra Ndyoo cua zandavi ñaha ra tatu sa vatyi cuu cuhva cuan, zoco ma cuu. ");
INSERT INTO mihNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ndyehe ndo, sa nacatyi tandɨhɨ sihin ndo cuee ca sa tahan si. ");
INSERT INTO mihNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yucuan cuenda tatu catyi ñiyɨvɨ sihin ndo: “Ndyehe ndo, ndyaa ra Jesús sisi cuhu.” Catyi ñu. Zoco ma cuhun ndo cundyehe ndo. A tatu catyi ñu: “Iyo minoo nu ñoho xehe ra.” Ma sino iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Vatyi quɨvɨ cua quisi inga saha, cua ndyehe tandɨhɨ ñiyɨvɨ sii. Tañi ndyehe tandɨhɨ ñiyɨvɨ tatu yaha tasa zavi ityi caña ñicandyi ta cuhva ndya ityi cua iñi, tacuan cua cuu si quɨvɨ quisi tucu ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Vatyi nu catuu ndɨyɨ, yucuan cua titahan tyasii. ");
INSERT INTO mihNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tatu sa yaha ndyehe ñiyɨvɨ tundoho cuan ta zɨquɨ ña naha ca ta cua nduñaa ñicandyi ta ma ndyehe ca nu yoo. Cua nacoyo tiñoo, ta ndya cuhva ndya cua canda andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tacuan ta zɨquɨ cua ndyehe ñiyɨvɨ sii ra i quisi ndya gloria ityi andɨvɨ, ta cua nducuihya xaan iñi tandɨhɨ tata ñiyɨvɨ ñuu ñiyɨvɨ. Cua ndyehe ñu vatyi vasi ra nu vico, ta sihin cuaha xaan cuhva. Ta tyaqui xaan caa ra. ");
INSERT INTO mihNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ta cua tasi ra sii ángel ra ndya tandɨhɨ sa cumi tahan sɨquɨ ñuu ñiyɨvɨ, ta cua tɨvɨ ra cutu sihin minoo nduzu ñihi xaan. Ta cua zatahan ra sii tandɨhɨ ñiyɨvɨ i casi ra Ndyoo ndya nacahnu ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Vityi coto ndo minoo cuhva iyo yutu higuera ta tandɨhɨ inga yutu. Tatu cua ndyehe ndo sa cua nacoyo ndaha tu ta cua nduyutya tu, tacuan ta sa sito ndo vatyi sa cua nducahñi. ");
INSERT INTO mihNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ta tacuan tucu tatu sa ndyehe ndo vatyi sa cuu tandɨhɨ tuhun sa quehin sihin ndo ihya, tacuan ta cua coto ndo vatyi sa cua cuyatyi sa cunaa ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sa ndisa catyi sihin ndo vatyi cua cuu cuhva ya cuee ca sa cuu ñiyɨvɨ sa iyo vityi. ");
INSERT INTO mihNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yutyi andɨvɨ ta ñuhu ñuu ñiyɨvɨ cunaa si. Zoco tuhun quehin, ma naa si. ");
INSERT INTO mihNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Zoco yoñi ñiyɨvɨ sito ñaa quɨvɨ a ñaa cuhva cua cuu si. Nu ángel andɨvɨ ta ña sito ra. Maa tuhun ñi ra Ndyoo Zuti sito. ");
INSERT INTO mihNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tañi i cuu si quɨvɨ ra Noé, tacuan cua cuu tucu si quɨvɨ cua quisi tucu ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Quɨvɨ cumañi ca cuu ñiyɨvɨ sihin ndutya, sasi ñu. Sihi ñu. Tindaha ñu. Ta saha ñu sii zehe ñu tindaha ñu ndya cuhva ndya quɨvɨ i quɨhvɨ ra Noé sisi barco. ");
INSERT INTO mihNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ta zana ñi iñi ñu, ta i zanaa ndutya sii tandɨhɨ ñu. Zuun ñi cuhva cuan, cua cuu tucu si quɨvɨ cua quisi tucu ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Quɨvɨ cuan, uu tahan ra ñoho itu ra, cua quihin sii minoo ra. Ta inga ra cua nandoo. ");
INSERT INTO mihNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ta uu tahan ñuzɨhɨ ndyico ɨɨn ñi quɨvɨ cuan, cua quihin sii minoo ña. Ta inga ña cua nandoo. ");
INSERT INTO mihNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yucuan cuenda cuatu listo ndo vatyi ña sito ndo ñaa quɨvɨ cua quisi ra ndyaca ñaha sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Coto ndo cuhva ya, tatu sa i sito ra xu vehe ñaa cuhva cua quɨhvɨ ra zuhu, cua cuatu listo ra, ta ma cuhva ra sa nuña ra zuhu cuan vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yucuan cuenda cuatu listo tucu maa ndo vatyi minoo quɨvɨ sa ña sica iñi ndo, cua quisi tucu ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","¿Yoo ra cuu minoo muzu vaha, muzu sa iyo sa siñi tuñi vaha ta saha patrón ra sa cundyaca ñaha ra vehe ra ta cuhva ra sa casi inga muzu ra cuhva tahan si? ");
INSERT INTO mihNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Zɨɨ xaan cua cuñi muzu cuan tatu nasaa patrón ra ta nañihi ra sii ra zavaha ra cuhva cuan, cuhva catyi patrón ra. ");
INSERT INTO mihNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sa ndisa catyi sihin ndo vatyi cua cuhva patrón ra sa cundyaca ñaha ra tandɨhɨ sa sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Zoco tatu ña vaha muzu cuan ta sica iñi ra sihin añima ra: “Naha xaan cuahan patroin.” ");
INSERT INTO mihNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ta yucuan cuenda quisaha cañi ra sii inga muzu ta sasi cuahyi ra ta sihi xaan ra ndixi ta siñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tacuan ta zana ñi iñi ra ta cua nasaa patrón ra minoo quɨvɨ sa ña ndatu ra sii ra, minoo cuhva sa ña sito ra, ");
INSERT INTO mihNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ta cua tasi tuñi xaan patrón ra sii ra. Ta cua tahan si sii ra tañi cua tahan si sii ñiyɨvɨ zaha tuhun vatyi vaha xaan ñu, zoco ña ndisa. Ñihi xaan cua vacu saa ñu, ndya cuhva cua casi quihñi noho ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Cuhva ndyaca ñaha ra Ndyoo cuu si tañi cuhva i tahan usi tahan ñu yoco sa cuahan minoo vico tandaha. I quihin ñu lámpara ñu sa sahmi azetye, ta cuahan ñu vatyi cua zatahan ñu sii ra cua tindaha. ");
INSERT INTO mihNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ta ohon tahan ñu cuan, listo xaan ñu. Ta ohon tahan ñu, laa xaan ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ta ñu laa cuan, i quihin ñu lámpara ñu, zoco ñá quihin ñu cuaha ca azetye. ");
INSERT INTO mihNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ta ñu listo cuan, i quihin ñu lámpara ñu, ta i quihin tahan tahan ñu minoo yutyi azetye vatyi cua zacutu tucu ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ta nɨɨ ñi sa cucuee xaan ra cua tindaha, i quixi tandɨhɨ ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tacuan ta maañuu i siñi ñu cana saa ñiyɨvɨ, ta catyi ñu: “¡Sa vasi ra cua tindaha; cuahan ndo cua zatahan ndo sii ra!” ");
INSERT INTO mihNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ta i nduvita tandɨhɨ ñu, ta i zanduvaha ñu lámpara ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ta i catyi ñu laa cuan sihin ñu listo cuan: “Cuhva ndo zuhva azetye ndo sii ndi vatyi sa cuñi ndahva lámpara ndi.” ");
INSERT INTO mihNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Zoco i nacahan ñu listo cuan, ta catyi ñu: “Ma cuu, coto ma ñihi si sa cuenda tandɨhɨ yo. Vaha ca tatu cuhun ndo nu cuyahvi si ta zata ndo zuhva sa cuenda maa ndo.” Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Zoco nɨɨ ñi sa cuahan ñu sa cua zata ñu sii si, ta i saa ra cua tindaha cuan, ta ñu sa ndyaa listo i quɨhvɨ ñu sihin ra nu iyo vico tindaha, ta i nucundazi yuvehe. ");
INSERT INTO mihNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Cuee ca i nasaa inga ñu yoco cuan, ta i catyi ñu: “¡Tata, tata, nuña yuvehe!” ");
INSERT INTO mihNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Zoco i nacahan ra ta catyi ra: “Sa ndisa catyi sihin ndo vatyi ña site sii ndo.” ");
INSERT INTO mihNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ta zɨquɨ i catyi ra Jesús: Yucuan cuenda cuatu listo ndo vatyi ña sito ndo ñaa quɨvɨ a ñaa cuhva cua quisi tucu ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Cuhva ndyaca ñaha ra Ndyoo cuu si tañi minoo ra sa cuñi cuhun minoo ñuu nusica, ta i cana ra sii tandɨhɨ muzu ra, ta saha cuenda ra xuhun ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sii minoo ra saha ra tañi ohon mil, sii inga ra tañi uu mil, ta sii inga ra minoo mil ñi. Cuhva cuu sii sa minoo minoo ra sa zatyiño ra sihin si, tacuan saha ra sii si sii ra. Ta i quihin ra ityi cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tacuan ta ra i ñihi sa ohon mil cuan, cuahan ra, ta i zatyiño ra sihin si, ta i ñihi ra inga ohon mil zɨquɨ si. ");
INSERT INTO mihNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ta zuun ñi cuhva cuan, ra i ñihi uu mil, i ñihi ra inga uu mil zɨquɨ si. ");
INSERT INTO mihNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Zoco ra i ñihi minoo mil ñi, i sahan ra, ta i sitya ra minoo yavi, ta i tyixehe ra xuhun patrón ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Cuee xaan ca, i nasaa patrón, ta i tava ra cuenda sihin muzu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Xihna ca i saa ra i ñihi ohon mil cuan, ta i saha cuenda ra inga ohon mil sii patrón ra, ta i catyi ra: “Tata, i sohon ohon mil sii. Ica si ya sihin inga ohon mil i zahacanei zɨquɨ si.” ");
INSERT INTO mihNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","I catyi patrón ra sihin ra: “Vaha xaan; yoho cuu minoo muzu vaha, ta ndoo xoon. Vaha xaan i zatyiñon sihin sa zuhva ñi xuhun i zandoi suhun. Yucuan cuenda vityi cua cuhve sa cundyaca ñohon cuaha ca. Quɨhvɨ ta cuzɨɨ xaan iñun ɨɨn ñi sihin mi.” ");
INSERT INTO mihNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Cuee ca i saa muzu sa ñihi sa uu mil cuan, ta i catyi ra: “Tata, i sohon uu mil sii; ica si ya sihin inga uu mil i zahacanei zɨquɨ si.” ");
INSERT INTO mihNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","I catyi patrón ra sihin ra: “Vaha xaan; yoho cuu minoo muzu vaha, ta ndoo xoon. Vaha i zatyiñon sihin sa zuhva ñi xuhun i zandoi suhun. Yucuan cuenda vityi cua cuhve sa cundyaca ñohon cuaha ca. Quɨhvɨ ta cuzɨɨ xaan iñun ɨɨn ñi sihin mi.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tacuan ta i saa muzu sa ñihi minoo mil ñi, ta i catyi ra sihin patrón ra: “Tata, site suun vatyi minoo ra xaan cuun, ta tuhvon naquihin sa yɨvɨ suun cuu, ta nacuhun tyiño zacuu inga ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ta i yuhi suun, ta sehin ta i tyixehi xuhun sisi ñuhu. Naquihin sa suun vityi.” ");
INSERT INTO mihNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ta i nacahan patrón ra, ta catyi ra: “Yoho, minoo muzu ña vaha ta ra zusa cuun. Sa siton vatyi tuhve naquihin sa yɨvɨ sii, ta naquihin tyiño zacuu inga ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yucuan cuenda ¿ñaa cuenda ñá tyuhun xuhin banco, ta sa cua nasei ta cua naquihin sii si, zoco sa zahacanaa si zuhva?” Catyi patrón cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ta i catyi ra sihin inga ra yucu yucuan: “Quindyaa ndo xuhun sa sehi sii ra ya, ta cuhva ndo sii si sii ra sa cumi usi mil cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Vatyi ra zatyiño vaha sihin sa sehi sii ra, cua cuhve cuaha ca sii ra, ta cua coo cuaha xaan ca sii ra. Ta ra ña cuñi zatyiño sihin sa sehi sii ra, cua quindyei sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ta muzu ña vaha cuan, zavita ndo sii ra ityi sata nu ñaa xaan, nu cua vacu xaan ñiyɨvɨ ndya cuhva cua casi quihñi noho ñu.” ");
INSERT INTO mihNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Quɨvɨ cua quisi tucu ra i quisi ndya gloria sihin ángel ra, tyaqui xaan ra. Ta cua cundyaa ra tyayu nu cua cundyaca ñaha ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ta tandɨhɨ ñiyɨvɨ ñuu ñiyɨvɨ cua titahan ñu ityi nuu ra, ta cua zazɨɨn ra sii ñu tañi zazɨɨn minoo ra cu pastor sii mvee ticatyi zono ra sihin mvee zono ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mvee ticatyi zono ra cua tyaa ra siyo cuaha ra. Ta mvee zono ra cua tyaa ra sii tɨ siyo zatyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ta zɨquɨ cua catyi Rey sihin ñu ndyaa siyo cuaha ra: “Ñaha ndo, Cuñi xaan Zuti sii ndo. Cumañi ca sino ñuu ñiyɨvɨ, ta sa ndyaa listo gloria vatyi cua quɨhvɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Vatyi yuhvi i sizoque, ta saha ndo sa casi. Ityi xein, ta saha ndo sa cohi. I sica noi ta ñahñi vehi, ta i saha ndo vehe ndo cundyei. ");
INSERT INTO mihNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ñahñi zahme, ta saha ndo zahma sii. I cuhi ta sahan ndo i sindyehe ndo sii. I siñohi vehe caa, ta sahan ndo i sindyehe ndo sii.” Cua catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ta zɨquɨ cua catyi ñiyɨvɨ vaha cuan sihin ra: “Tata, ¿ama i ndyehe ndi suun sizocon ta saha ndi sa casun, a ityun ta saha ndi sa cohon? ");
INSERT INTO mihNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ta ama i ndyehe ndi suun sica noo ta saha ndi sa cundyoon vehe ndi a ndyehe ndi suun ta ñahñi zahmon, ta saha ndi zahma suun? ");
INSERT INTO mihNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ta ama i ndyehe ndi suun sa cuhun a ñohon vehe caa ta sahan ndi sa ndyehe ndi suun?” Cua catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ta cua nacahan Rey cuan ta catyi ra sihin ñu: “Sa ndisa catyi sihin ndo, tandɨhɨ sa i zavaha ndo sihin yañi, vazu ra ndyihi ca, zoco sihin mi i zavaha ndo cuhva cuan.” ");
INSERT INTO mihNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ta zɨquɨ cua catyi Rey cuan sihin ñiyɨvɨ ndyaa siyo zatyi ra: “Cuɨñɨ siyo ndo sii, ndoho ñiyɨvɨ sa cuxaan ra Ndyoo sihin. Cuquɨhɨ ndo nu cayu ñúhu nu i zavaha Ndyoo sa cuenda cuihna ta tatyi cuihna sa ndyico sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Vatyi i sizoque, ta ñá saha ndo sa casi. I cu‑ityi, ta ñá saha ndo ndutya cohi. ");
INSERT INTO mihNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","I sica noi, ta ñahñi vehi, ta ñá saha ndo vehe ndo cundyei. Ñahñi zahme, ta ñá saha ndo zahma sii. I cuhi, ta i siñohi vehe caa, ta ñá sindyehe ndo sii.” ");
INSERT INTO mihNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ta zɨquɨ cua catyi tucu ñiyɨvɨ cuan sihin Rey cuan: “Tata, ¿ama i ndyehe ndi suun sizocon a ityun a sica noo ta ñahñi vehun? ¿Ta ama i ndyehe ndi suun sa ñahñi zahmon a cuhun a ñohon vehe caa ta ñá tyindyee ndi suun?” ");
INSERT INTO mihNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ta cua nacahan Rey ta catyi ra: “Sa ndisa catyi sihin ndo vatyi tandɨhɨ sa ñá zavaha ndo sihin minoo ñiyɨvɨ luhlu ca, ñá zavaha ndo sii si sihin mi.” Cua catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ta zɨquɨ cua cuhun ñu nu cua ndoho ñu tandɨhɨ cuii tyiemvu. Zoco ñiyɨvɨ vaha, cua cuhun ñu nu cua cundito ñu tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sa yaha cahan ra Jesús tandɨhɨ tuhun ya, ta zɨquɨ i catyi ra sihin ra i casi ra: ");
INSERT INTO mihNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Sa sito ndo vatyi uu quɨvɨ ñi ca, ta cua cuu si vico zuhun, ta cua xico minoo ra sii ra i quisi ndya gloria, ta cua cahñi ñiyɨvɨ sii ra nu cruz. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ta sisi quɨvɨ cuan i titahan ra zutu nahnu sihin ra maestro cuenda ley ta ra mandoñi. Tandɨhɨ ra cuan cuu ra ra hebreo nahnu, ta i titahan ra nuquehe vehe ra Caífas ra cu zutu ya cahnu. ");
INSERT INTO mihNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ta yucuan i natuhun tahan ra yozo caa cua tɨɨn xehe ra sii ra Jesús, ta cua cahñi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Zoco i catyi ra sihin ra tahan ra: Zoco ma cuu si quɨvɨ vico vatyi cuaha xaan ñiyɨvɨ yucu, ta coto cahñi tahan ñu sihin yo. ");
INSERT INTO mihNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ñoho ra Jesús ñuu Betania vehe ra Simón, ra i cuhu cuehe tyahyu. ");
INSERT INTO mihNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ta i tuhva minoo ñaha sii ra. Ñaa ña minoo yutyi sino sihin minoo yuu yahvi xaan, ta ñoho azetye vixi. Ta i tyozo ña sii si xiñi ra Jesús cuhva sa sasi ra xita. ");
INSERT INTO mihNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ta sa ndyehe ra i casi ra Jesús cuhva zavaha ña, i cuxaan ra, ta catyi ra: ¿Ñacu zatɨvɨ ña sii si? ");
INSERT INTO mihNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Vaha ca tatu sa i xico ña sii si ta ñihi ña cuaha xuhun ta cuhva ña sii ñiyɨvɨ ndahvi. ");
INSERT INTO mihNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ta sa sito ra Jesús sa cahan ra cuan, ta zɨquɨ i catyi ra sihin ra: ¿Ñacu cuyuhu xaan ndo sihin ñaha ya? I zavaha ña minoo sa vaha sihin. ");
INSERT INTO mihNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tandɨhɨ tyiemvu cua coo ñiyɨvɨ ndahvi sihin ndo, ta cuu tyindyee ndo sii ñu tatu cuñi ndo. Zoco yuhvi ma cundyei sihin ndo tandɨhɨ tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cuhva i zavaha ña ya sa tyozo ña azetye vixi coño ñuhi cuu sa zanduvaha ña sii, sa cuenda sa cuquɨhi ñaña. ");
INSERT INTO mihNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sa ndisa catyi sihin ndo vatyi vazu ndyacamaa nacatyi ñiyɨvɨ Tuhun Ndyoo, zoco cua nacatyi ñu cuhva i zavaha ña ya sihin, ta cua nacohon iñi ñiyɨvɨ sii ña. I catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yaha cuan ta zɨquɨ minoo sa usi uu tahan ra i casi ra Jesús, ra sa nañi Judas Iscariote, cuahan ra cua cahan ra sihin ra zutu nahnu. ");
INSERT INTO mihNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ta i catyi ra sihin ra: ¿Yozo cua cuhva ndo sii, tatu cuhva cuende sii ra sii ndo? Ta i zandaa ra tyiño sa cua cuhva ra oco usi tahan xuhun cuisi. ");
INSERT INTO mihNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ta ndya quɨvɨ cuan, i quisaha nducu xaan ra Judas cuhva cua cuhva cuenda ra sii ra Jesús sii ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nu quisaha vico nu tuhva ñiyɨvɨ hebreo sasi pan ña ndaa, i tuhva ra i casi ra Jesús sii ra, ta i catyi ra sihin ra: ¿Ndyamaa cuñun vatyi cua zanduvaha ndi sa cua cuxiñun sa cuenda vico zuhun ya? ");
INSERT INTO mihNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ta i catyi ra Jesús: Cuahan ndo ndya ñuu cahnu vehe ra sa cahan yo tuhun, ta catyi ndo sihin ra: “Catyi ra Maestro, cua saa cuhva sa cua cui. Vehe moo cua cuxiñi sa cuenda vico zuhun ya sihin ra i casi.” ");
INSERT INTO mihNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ta tacuan i zavaha ra, cuhva i catyi ra Jesús sihin ra, ta i zanduvaha ra sa cuxiñi ra sa cuenda vico cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ta cuhva sa sa cuaa cuan, sa ndyaa ra Jesús mesa sihin sa usi uu tahan ra i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ta nɨɨ ñi sa sasi ra xita i catyi ra Jesús sihin ra: Sa ndisa catyi sihin ndo vatyi cua xico minoo ndo sii. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ta i nducuihya xaan iñi ra ndɨhɨ sihin ra, ta i quisaha ndaca tuhun minoo minoo ra sii ra Jesús: Tata, ¿atu yuhvi cui? ");
INSERT INTO mihNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ta i nacahan ra Jesús, ta catyi ra: Ra sa sasi sihin ɨɨn ñi coho, yucuan ra cuu ra cua xico sii. ");
INSERT INTO mihNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Cuahan ra i quisi ndya gloria cuhva catyi Tuhun Ndyoo; zoco ¡ndahvi ñi cuu ra xico sii! Vaha ca tatu sa ñá cacu ra vatyi cua ndyehe xaan ra tundoho. ");
INSERT INTO mihNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tacuan i catyi ra Jesús, ta zɨquɨ ra Judas ra sa xico sii ra i ndaca tuhun ra sii ra, ta catyi ra: Maestro, ¿atu zuun yuhvi cui? Ta i catyi ra sihin ra: Tacuan cu si, tañi catyi moo. ");
INSERT INTO mihNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ta cuhva sa cuxiñi ra, i quihin ra Jesús pan, ta i saha ra tyahvi ndyoo sii ra Ndyoo, ta zɨquɨ i sahnu ra sii si ta saha ra sii si sii ra i casi ra, ta i catyi ra: Quihin ndo sii si ta casi ndo. Ihya cuu tañi coño ñuhi. ");
INSERT INTO mihNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tacuan ta i quihin ra minoo vaso ñoho vino, ta i saha ra tyahvi ndyoo sii ra Ndyoo, ta i saha ra sii si sii ra, ta i catyi ra: Coho tandɨhɨ ndo zuhva zuhva ");
INSERT INTO mihNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","vatyi ihya cuu tañi nɨñi sa cuenda tyiño saa sa zandaa ra Ndyoo. Cua cati si, ta sa cuenda maa si, cua ndasi cuatyi cuaha xaan ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Zoco catyi sihin ndo vatyi ma coho que vino ndya quɨvɨ cua cohi sii si sihin maa ndo minoo cuhva saa nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","I sata tandɨhɨ ra minoo yaa Ndyoo, ta zɨquɨ cuahan ra ndya yucu Olivos. ");
INSERT INTO mihNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tacuan ta i catyi ra Jesús sihin ra: Sa cuaa vityi tandɨhɨ cuii ndo cua zandoo ndo sii. Ta ma cuñi ca ndo cundyico ndo sii, vatyi catyi Tuhun Ndyoo: “Cua cuu ra cu pastor, ta cua quɨtɨ cuatyi tandɨhɨ cuii mvee ticatyi zono ra.” ");
INSERT INTO mihNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Zoco sa yaha nandote ta cua cuhin yatyi ca ta zɨquɨ maa ndo ndya Galilea. ");
INSERT INTO mihNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ta zɨquɨ i catyi ra Pedro sihin ra: Vazu zandoo tandɨhɨ ca ra ya suun, zoco yuhvi cua cundyique suun. ");
INSERT INTO mihNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ta i catyi ra Jesús sihin ra: Sa ndisa catyi suhun vatyi zuun ñi sa cuaa vityi, cuee ca sa vacu saa ndɨvɨ tyahnu, cua catyun uñi tahan saha vatyi ña siton sii. ");
INSERT INTO mihNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ta i catyi ra Pedro sihin ra: Vazu cui suhun, zoco ma catyi sa ña site suun. Ta tacuan tucu i cahan tandɨhɨ ca ra i casi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tacuan ta zɨquɨ i saa ra Jesús sihin ra i casi ra ndya minoo nu yucu yutu tyaqui nu nañi si Getsemaní, ta i catyi ra sihin ra: Cundyaa ndo ihya vatyi cuehin cua quehin sihin ra Ndyoo ityi nuu ca. ");
INSERT INTO mihNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ta i quihin ra Jesús sii ra Pedro ta sii nduu tahan zehe ra Zebedeo cuahan sihin ra, ta i quisaha nducuihya xaan iñi ra, ta ndahvi xaan cuñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tacuan ta i catyi ra: Cuihya xaan cuñi añime cuhva ndya sa cuñi cui. Ndoo ndo ihya ñi, ta cundyaa tyacu ndo sihin. ");
INSERT INTO mihNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ta zɨquɨ cuahan ra Jesús zuhva ca ityi nuu, ta i sicava ndyayu ra nu ñuhu, ta i sica tahvi ra sii ra Ndyoo, ta catyi ra: Ndyoo Zuti, tatu sa vatyi cuu, cuhvon sa ma ndyehi tundoho sa cua ndyehi vityi, zoco ma cuu si cuhva cuñi mi, nacuu si cuhva cuñi moo. ");
INSERT INTO mihNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tacuan i catyi ra Jesús, ta zɨquɨ i sahan ra nu yucu ra ndɨhɨ sihin ra, ta i nañihi ra sii ra quixi ra, ta i catyi ra sihin ra Pedro: ¿Yozo caa? ¿Ñacu ñá cuu cundyaa tyacu ndo sihin numinoo ora? ");
INSERT INTO mihNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cutyacu ndo ta cahan ndo sihin ra Ndyoo coto nducu coto ihñi cuihna sii ndo. Cuñi ndo zavaha ndo sa vaha, zoco ña cuu sii ndo sa maa tuhun ñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tacuan ta i sahan tucu ra Jesús inga saha sa cua cahan ra sihin ra Ndyoo, ta i catyi ra: Ndyoo Zuti, tatu cuu sa ma ndyehi tundoho ya, vaha xaan, zoco tatu ma cuu, nacuu si cuhva cuñi moo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ta zɨquɨ i nasaa ra, ta i nañihi ra sii ra ndɨhɨ sihin ra quixi tucu ra vatyi sitatu xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ta i zandoo ra sii ra, ta cuahan ra sa cu uñi saha, ta zuun ñi tuhun cuan i cahan ra sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ta zɨquɨ i nasaa tucu ra nu yucu ra i casi ra, ta i catyi ra sihin ra: Cuzu ndo vityi, ta quitatu vaha ndo. Sa saa cuhva sa cua nacuhva ñiyɨvɨ sii ra i quisi ndya gloria sii ra iyo cuatyi. ");
INSERT INTO mihNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ta nduvita ndo. Coho yo. Sa vasi ra xico sii. ");
INSERT INTO mihNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nu cahan ca ra Jesús, ta i saa ra Judas; minoo sa usi uu tahan ra i casi ra Jesús cuu ra. Ta i quisi cuaha xaan ñiyɨvɨ sihin ra. I tasi ra zutu nahnu ta ra mandoñi sii ra, ta ñaa ra mityi ta yutu. ");
INSERT INTO mihNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ra sa xico sii ra Jesús, i saha ra minoo cuhva sii ra cuan, ta catyi ra: Ra cua cohi xɨtɨ cuan, yucuan cuu ra tɨɨn ndo. Tɨɨn vaha ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ta i saa ra Judas, ta i tuhva ra sii ra Jesús, ta i catyi ra: Nacumi suun, Maestro. Ta i sihi ra xɨtɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ta i catyi ra Jesús sihin ra: Amigo, ¿ñaa cuenda vasun? Catyi ra. Ta zɨquɨ i tɨɨn ra sii ra Jesús, ta cuahan ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ta minoo ra ndɨhɨ sihin ra Jesús, i tava ra mityi ra, ta i cañi ra sii ra cu muzu ra cu zutu ya cahnu, ta i sahndya ra zoho ra siyo cuaha. ");
INSERT INTO mihNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ta zɨquɨ i catyi ra Jesús sihin ra: Natyuhun mityun sisi veno si. Ra cahñi tahan sihin mityi, cua cuu ra sihin mityi. ");
INSERT INTO mihNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Atu sica iñun vatyi ma cuu caque sii Zuti ta vityi vityi cua tasi ra tañi usi uu ityi ángel cua zacuenda sii? ");
INSERT INTO mihNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Zoco tatu tacuan zavehi, ¿yozo caa ta natahan si cuhva catyi Tuhun Ndyoo vatyi cua tahan si sii? ");
INSERT INTO mihNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ta zɨquɨ i catyi ra Jesús sihin ñiyɨvɨ: ¿Atu vasi tɨɨn ndo sii minoo ra zuhu vatyi ñaa ndo mityi ta ndaha tyiño xaan? Tahan tahan quɨvɨ i sehin vehe ñuhu cahnu ta yucu ndo, zoco ñá tɨɨn ndo sii yucuan. ");
INSERT INTO mihNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Zoco tacuan cu si tandɨhɨ cuhva ya vatyi cua natahan tandɨhɨ cuhva i tyaa ra profeta nuu tutu ra Ndyoo. Tacuan i catyi ra Jesús, ta zɨquɨ i zandoo tandɨhɨ ra i casi ra sii ra, ta i sino ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ra i tɨɨn sii ra Jesús, i sindyaca ra sii ra ityi nuu ra Caifás. Ra Caifás cuu ra cu nuu sii tandɨhɨ ra cu zutu. Ta yucuan i titahan ra maestro cuenda ley ta ra mandoñi. ");
INSERT INTO mihNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ta i sindyico ra Pedro sica sica ñi ndya cuhva ndya saa ra nuquehe vehe ra cu zutu ya cahnu, ta yucuan i quɨhvɨ ra, ta i sicundyaa ra sihin ra policía vatyi cua ndyehe ra yozo caa cua cundaa tyiño sa cuenda ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ra cu zutu ya cahnu sihin ra mandoñi ta tandɨhɨ ra cu tyiño hebreo, i nanducu xaan ra ñiyɨvɨ cua cuhva sa ndaa sa cuenda ra Jesús vazu maa cuendu ñi cuu si vatyi cuñi ra cahñi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Zoco ñá ñihi ra cuhva sa yatyi vazu cuaha ñiyɨvɨ saha sa ndaa, vatyi ñá nacasi tahan sa cahan ra. Ndya nu ndɨhɨ tuhun i ñihi ra sii uu tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ta i catyi ra cuan: Ihya ra i catyi: “Cuu cani vehe ñuhu cahnu ra Ndyoo, ta cuu zanandei sii si sisi sa uñi quɨvɨ ñi.” ");
INSERT INTO mihNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ta zɨquɨ i nduvita ra cu zutu ya cahnu, ta i catyi ra sihin ra Jesús: ¿Ñacu ña nacohon ii caña ñi? ¿Ñaa sa cuu sa cahan ñiyɨvɨ ya zɨcun? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Zoco ñá nacahan maa ra Jesús. Tacuan ta i catyi ra cu zutu ya cahnu: Sihin zɨvɨ ra Ndyoo ndito quehin, ta catyi suhun vatyi cohon sa ndisa ta nacatyun sihin ndi tatu ra Cristo cuun, ra cu Zehe ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ta i catyi ra Jesús sihin ra: Zuun ra cui tañi catyun. Ta catyi tuqui sihin maa ndo vatyi cua ndyehe ndo sii ra i quisi ndya gloria cuhva cundyaa ra siyo cuaha ra Ndyoo ta cuhva cua quisi ra ndya andɨvɨ sisi vico. ");
INSERT INTO mihNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tacuan catyi ra Jesús, ta zɨquɨ ra cu zutu ya cahnu, cuxaan ra ta i ndata ra zuun ñi zahma maa ra, ta i catyi ra: ¿Ñaa ca sa ndaa cuñi si vityi? Sa siñi ndo sa cahan ra ndya vaha ñi sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ñaa catyi ndo vityi? Ta i nacahan tandɨhɨ ra, ta i catyi ra: Nacuu ra vatyi iyo cuatyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ta zɨquɨ i quisaha tyicu zɨɨ ra nuu ra, ta inga ra cati ra nuu ra sihin ndaha ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ta i catyi ra: Tatu ndisa vatyi ra Cristo cuun, nacoton yoo ra cañi suun. ");
INSERT INTO mihNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nɨɨ ñi sa yaha tandɨhɨ cuhva cuan, ndyaa ra Pedro nuquehe, ta i tuhva minoo muzu sii ra, ta i catyi ña sihin ra: Cutahan aan sica noon sihin ra Jesús, ra i quita Galilea. ");
INSERT INTO mihNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Zoco i catyi ra Pedro ityi nuu tandɨhɨ ñiyɨvɨ vatyi yɨvɨ ra cuu ra. I catyi ra sihin ña: Ña site ñaa tuhun cohon. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tacuan ta sa quita ra Pedro ndya yuvehe nuzama, ta i ndyehe inga muzu sii ra, ta i catyi ña sihin ñiyɨvɨ yucu yucuan: Ra ihya, ra tahan ra cuu sii ra Jesús, ra ñuu Nazaret. ");
INSERT INTO mihNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ta i tyiñaha ra Pedro ndyoo nuu ñiyɨvɨ yucu yucuan, ta i catyi ra: Ña site sii ra cohon tuhun ña. ");
INSERT INTO mihNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ta i yaha zuhva cuhva, ta i tuhva ra nandyaa yucuan sii ra Pedro, ta i catyi ra sihin ra: Ndisa cuii vatyi minoo ra tahan ra cuu tucu oo vatyi cohon tañi cahan ñiyɨvɨ nu cu si Galilea. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tacuan ta i quisaha cahan ra Pedro ndya vaha ñi, ta catyi ra: Ña site sii ra cuan. Catyi ra. Ta zuun ñi caa cuhva cuan, i sacu saa ndɨvɨ tyahnu. ");
INSERT INTO mihNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ta zɨquɨ i nacohon iñi ra Pedro cuhva i catyi ra Jesús sihin ra: “Cuee ca sa vacu saa ndɨvɨ tyahnu, cua catyun uñi saha vatyi ña siton sii.” Ta sa nacohon iñi ra Pedro cuhva cuan, i quita ra, ta i sacu xaan ra vatyi i nducuihya xaan iñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ta sa cundisi i zandoo ra tyiño, tandɨhɨ ra zutu nahnu ta ra mandoñi. Sa ndu‑ɨɨn ra minoo cuhva, cuhva cua cahñi ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ta i sihñi ra sii ra Jesús, ta i sindyaca ra sii ra nu ndyaa ra Poncio Pilato, ra cu gobernador. ");
INSERT INTO mihNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ra Judas, ra i xico sii ra Jesús, i ndyehe ra vatyi cua cahñi ra sii ra Jesús, ta zɨquɨ i ndu‑uu iñi ra cuatyi ra, ta i nacuhva ra sa oco usi tahan xuhun cuisi sii ra zutu nahnu ta ra mandoñi, ");
INSERT INTO mihNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ta i catyi ra sihin ra: Cahnu xaan cuatyi i zavehi vatyi i saha cuende sii minoo ra ñahñi cuatyi, ta vityi cua cuu ra. Zoco i nacahan ra cuan, ta catyi ra: ¿Ta ñaa sa cuenda nduhvi? ¡Ndyehe moo yozo caa zacuun vityi! ");
INSERT INTO mihNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tacuan ta i zavita ihno ra Judas xuhun cuan sisi vehe ñuhu cahnu ta cuahan ra, ta i sahñi ra sii ra. Tyihi ra minoo yoho zucu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","I nacuaan ra zutu nahnu xuhun cuan, ta catyi ra: Ma cuu tyihi yo xuhun ya sihin xuhun ofrenda vatyi xuhun sa cuenda sa cua cati nɨñɨ minoo ra cu si. ");
INSERT INTO mihNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ta zɨquɨ i ndu‑ɨɨn ra minoo cuhva, ta sihin xuhun cuan, i zata ra minoo ñuhu nañi si Nu Tava Ñiyɨvɨ Ndyahyu sa cua Zavaha Ñu Ndaha Tyiño. Ta tyaa ra cuhva vatyi ñuhu cuan cua cuu nuñaña sa cuenda ñiyɨvɨ inga ñuu tatu cua cuu ñu ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ta yucuan cuenda ndya cuhva ndya vityi nañi ñuhu cuan, Ñuhu Cuenda Nɨñɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ta cuhva cuan i natahan si cuhva i catyi ra Jeremías, minoo ra cu profeta ta sa naha. Tyehen i tyaa ra: “I naquihin ra sa usi uu tahan xuhun cuisi. Yucuan cuu yahvi i sicundyaa ra i zacuu ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ta sihin xuhun cuan i zata ra ñuhu sii ra zavaha quɨyɨ tañi i catyi maa ra Ndyoo sihin.” Tacuan i tyaa ra Jeremías sa cuenda cuhva cua tahan ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","I sindyaca ra sii ra Jesús ityi nuu ra Pilato, ra cu gobernador, ta i ndaca tuhun ra Pilato sii ra Jesús: ¿Atu yoho cuu rey cuenda ñiyɨvɨ hebreo? Ta i catyi ra Jesús: Tacuan cu si tañi catyi moo. ");
INSERT INTO mihNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tacuan ta i tyaa ra zutu nahnu ta ra mandoñi cuatyi sata ra Jesús, zoco ñá nacahan ra ndaha ñi. ");
INSERT INTO mihNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ta zɨquɨ i catyi ra Pilato: ¿Atu ña siñun sa cahan ra ya, cuhva tyaa ra cuatyi saton? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Zoco ñá nacahan ra Jesús ndaha ñi, ta iyo xaan i cuñi ra Pilato. ");
INSERT INTO mihNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ta vico cuan, tuhva ra gobernador tava sii minoo ra ñoho vehe caa, yoo ra cua catyi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ta sicoo minoo ra sa sito tandɨhɨ ñiyɨvɨ. Barrabás nañi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ta cuhva i titahan tandɨhɨ ñiyɨvɨ, i ndaca tuhun ra Pilato sii ñu: ¿Yoo ra cuñi ndo sa zañe, a sii ra Barrabás a sii ra Jesús sa nañi Cristo? ");
INSERT INTO mihNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Vatyi sa sito ra Pilato vatyi ña tahan iñi ra cu tyiño hebreo sii ra Jesús, ta yucuan cuenda i saha cuenda ra sii ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nɨɨ ñi sa ndyaa ra Pilato tyayu ra nu zandaa ra tyiño, i tasi ñazɨhɨ ra tyiño nu ndyaa ra, ta catyi ña: “Coto ñaha ñaa sa zavohon sihin ra vaha cuan vatyi i ndyehi minoo ñimahna quiñi xaan sa cuenda ra cuñi.” Tacuan catyi tutu i tyaa ña. ");
INSERT INTO mihNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Zoco i zasino ra zutu nahnu cuan ta ra mandoñi iñi ñiyɨvɨ vatyi cua caca ñu sii ra Barrabás, ta cua catyi ñu vatyi nacuu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","I cahan ra gobernador inga saha, ta catyi ra: ¿Yoo ra cuñi ndo sa cua zañe? Ta i catyi ñu: Sii ra Barrabás. ");
INSERT INTO mihNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ta zɨquɨ i ndaca tuhun ra Pilato: Ta ¿ñaa sa cua zavehi sihin ra Jesús sa nañi Cristo? Ta i nacahan tandɨhɨ ñu, ta catyi ñu: ¡Nacuu ra nu cruz! ");
INSERT INTO mihNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ta i catyi ra Pilato: ¿Ñaa cuenda? ¿Ñaa sa ña vaha i zavaha ra? Zoco i cana saa ñu ñihi ca, ta catyi ñu: ¡Nacuu ra nu cruz! ");
INSERT INTO mihNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ta zɨquɨ i ndyehe ra Pilato vatyi ñá cuu zacuu ra. I nduvaa ñi maa ñiyɨvɨ. Yucuan cuenda i quihin ra ndutya, ta i nacatya ra ndaha ra ityi nuu ñiyɨvɨ, ta catyi ra: Yɨvɨ cuatyi mi cuu ta cua cati nɨñɨ ra vaha ya. Ndyehe maa ndo cua ndoo cuatyi sata maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ta i nacahan tandɨhɨ ñiyɨvɨ, ta catyi ñu: Nacuu si cuatyi maa ndi ta cuatyi zehe ndi. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ta zɨquɨ i zaña ra Pilato sii ra Barrabás, ta i tava ra tyiño vatyi cua cañi zandaru sii ra Jesús, ta zɨquɨ i saha cuenda ra sii ra vatyi cua cuu ra nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","I sindyaca zandaru ra Pilato sii ra Jesús sisi vehe tyiño, ta i titahan tandɨhɨ inga zandaru sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","I tava ra zahma ra Jesús, ta i natyihi ra minoo zahma tixinda sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ta i zavaha ra minoo corona iñu ta tyihi ra xiñi ra Jesús, ta saha ra minoo tuyoo caxtyila cuñaa ra, ta zɨquɨ i sicuɨñɨ sɨtɨ zandaru ityi nuu ra, ta i sacu ndyaa ra sii ra, ta catyi ra: Nacumi suun, yoho ra cu rey cuenda ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","I tyicu zɨɨ zandaru sii ra Jesús, ta i naquihin ra tuyoo caxtyila cuan, ta i cañi xaan ra xiñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ta sa yaha sacu ndyaa ra sii ra, i tava ra zahma tixinda cuan, ta i natyihi ra zahma maa ra sii ra. Ta zɨquɨ i quihin ra sii ra vatyi cua cahñi ra sii ra nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ta cuhva sa cuahan ra ityi, i tahan ra sii minoo ra ñuu Cirene. Simón nañi ra. Ta i zacuizo zandaru cuan cruz ra Jesús sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ta cuahan tandɨhɨ ra nu nañi si Gólgota. Tuhun Gólgota cuan cuñi si catyi si Nu Yucu Yɨquɨ Xiñi Ndɨyɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ta cuhva sa saa ra yucuan, i saha ra vino zaca si sihin minoo sa uva xaan vatyi cua coho ra Jesús, zoco i sihi ra Jesús siin ñi ta zɨquɨ ñá cuñi ca ra coho sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ta sa yaha tyaa zandaru sii ra Jesús nu cruz ta zɨquɨ i sizɨquɨ ra vatyi cua ndyehe ra yoo ra cua zahacanaa minoo minoo zahma ra. Cuhva cuan i natahan si cuhva i tyaa minoo ra profeta sa cuenda ra Jesús nu catyi si tyehen: “I zasa ra zahme sii tahan ra, ta i sizɨquɨ ra yoo ra cua ñihi zahma cañi vii.” ");
INSERT INTO mihNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ta zɨquɨ i sicundyaa zandaru, ta i zacuenda ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ta xiñi cruz i tyaa ra minoo tutu, ta catyi si ñaa cuenda cua cuu ra, ta catyi si: “Ihya ra cuu ra Jesús, rey cuenda ñiyɨvɨ hebreo.” ");
INSERT INTO mihNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ta i sihi tucu uu tahan ra zuhu sihin ra Jesús, minoo ra siyo cuaha ra, ta inga ra siyo zatyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Cuhva sa yaha ñiyɨvɨ nu ndyaa ra Jesús, i sacu ndyaa ñu sii ra, ta zavico xiñi ñi ca ñu ");
INSERT INTO mihNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ta catyi ñu: Yoho, ra catyi vatyi cua canun vehe ñuhu ta uñi quɨvɨ ñi ta cua zanduvohon sii si, tatu sa ndisa vatyi zehe ra Ndyoo cuu suun, noon nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ta i sacu ndyaa tucu ra zutu nahnu ta ra maestro cuenda ley ta ra mandoñi sii ra, ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","I zacacu ra sii inga ñiyɨvɨ, zoco ña cuu zacacu ra sii ra. Tatu rey cuenda ñiyɨvɨ hebreo cuu ra, nanoo ra nu cruz vityi, ta cua sino iñi yo sii maa ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Sino xaan iñi ra sii ra Ndyoo, nazacacu ra Ndyoo sii ra vityi tatu sa ndisa vatyi cuñi ra Ndyoo sii ra vatyi i catyi ra vatyi Zehe ra Ndyoo cuu sii ra. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ta ndya cuhva ndya ra zuhu, ra sihi ɨɨn ñi sihin ra Jesús, ta i cahan tucu ra ndya vaha ñi sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tacuan ta i nduñaa xaan nacahnu ñuu ñiyɨvɨ ndya maa ora ta ndya cuhva ndya caa uñi sa sahiñi. ");
INSERT INTO mihNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ta cuhva caa uñi i cana saa ra Jesús minoo sa ñihi xaan, ta i catyi ra: Elí, Elí ¿lama sabactani? Cuñi si catyi si: Zutu mañi yu, Zutu mañi yu, ¿ñaa cuenda i zandoon sii? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Zuhva ñiyɨvɨ nandyaa yucuan, i siñi ñu ta catyi ñu: Ra ihya cana saa ra sii ra profeta Elías. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ta zuun ñi caa cuhva cuan, i cacono minoo ra cuan, ta i quihin ra sii minoo sa ñahma, ta i zatyii ra sii si sihin ndutya iya. I tyaa ra sii si numinoo yutu, ta i zandaa ra sii si nu ndyaa ra Jesús vatyi cua coho ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ta i catyi inga ra yucu yucuan: Cuatu noo, nandyehe yo tatu cua quisi zanoo ra Elías sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","I sacu saa ra Jesús inga saha minoo sa ñihi xaan, ta zɨquɨ i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Zuun ñi caa cuhva cuan, i ndata zava zama coco sa ndita sisi vehe ñuhu cahnu ndya zɨquɨ ta ndya xuu. I taan minoo sa ñihi xaan, ta i ndata yuu nahnu, ");
INSERT INTO mihNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ta i nuña ñaña, ta i nandoto cuaha xaan ñiyɨvɨ i sino iñi sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Sa yaha nandoto ra Jesús, ta zɨquɨ i quita maa ñu ñaña, ta saa ñu ñuu Jerusalén, ñuu ra Ndyoo, ta cuaha xaan ñiyɨvɨ i ndyehe sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ta minoo ra cu nuu sii minoo ziendu zandaru ta zandaru ra zacuenda sii ra Jesús ɨɨn ñi sihin ra cuan, i ndyehe ra cuhva i taan ta tandɨhɨ inga sa i cuu, ta i yuhu xaan ra, ta i catyi ra: Ndisa cuii ra ihya vatyi zehe Ndyoo cu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ndya zava ñi i siyucu cuaha xaan ñu zɨhɨ. Ndyehe ñu sii ra Jesús. I sindyico ñu sii ra ndya Galilea, ta i tyindyee ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Minoo ña cuan, nañi ña María Magdalena, ta inga ña cuu ña María zɨhɨ ra Jacobo ta ra José, ta inga ña cuu ñazɨhɨ ra Zebedeo. ");
INSERT INTO mihNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Minoo ra cuca sa nañi José, ra ñuu Arimatea cuu ra, ta ndyico ra sii ra Jesús. Ta sa tyahan cuan ");
INSERT INTO mihNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","i sahan ra nu ndyaa ra Pilato, ta i sica ra coño ñuhu ra Jesús. I saha ra Pilato tyiño vatyi cuu quihin ra sii si. ");
INSERT INTO mihNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ta i quihin ra José coño ñuhu ra Jesús, ta i cava noo ra minoo zahma vaha sii si, ");
INSERT INTO mihNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ta i saqui ra sii si sisi ñaña saa maa ra sa i zavaha ra sisi minoo yuu. I tyazi ra yuhu ñaña cuan sihin minoo yuu cahnu, ta cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ta cuhva cuan i siyucu ña María Magdalena ta inga ña María yatyi ñi yuñaña cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Inga quɨvɨ, quɨvɨ sa cua quitatu ñiyɨvɨ, sa ndɨhɨ zanduvaha ñu sa cuenda vico cuan, ta i sahan ra zutu nahnu ta ra fariseo nu ndyaa ra Pilato. ");
INSERT INTO mihNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ta i catyi ra sihin ra: Tata, nacohon iñi ndi vatyi nɨɨ ñi sa ndito ra vatya cuan ta i catyi ra vatyi tatu sa yaha uñi quɨvɨ cua nandoto ra sisi sa i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yucuan cuenda cuñi ndi vatyi tavon tyiño vatyi cundyaa zeyun yuhu ñaña ra ndya cuhva ndya sa yaha uñi quɨvɨ coto quisi ra tahan ra sa sa cuaa ta zuhu ra coño ñuhu ra, ta zɨquɨ cua catyi ra sihin ñiyɨvɨ vatyi i nandoto ra sisi sa i sihi ra. Tatu tacuan cua cuu, yaha ca cua sino iñi ñiyɨvɨ tuhun vatya sa cahan ra ta zɨquɨ sa xihna ñi. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ta i catyi ra Pilato sihin ra: Quihin ndo zuhva zandaru. Ta cuhun ndo ta cazi cutu vaha ndo yozo ca cuhva cuu sii ndo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tacuan ta cuahan ra, ta i tyazi cutu vaha ra ñaña cuan, ta i tyaa ra zeyu yuhu si, ta i zandoo ra sii zandaru yucuan vatyi cua zacuenda ra. ");
INSERT INTO mihNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","I yaha quɨvɨ quitatu ñiyɨvɨ hebreo. Ta quɨvɨ tumingu cuhva sa vasi cundisi i saa ña María Magdalena sihin inga ña Mariá vatyi cua ndyehe ñu ñaña cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ta zuun ñi caa cuhva cuan i taan minoo sa ñihi xaan vatyi i quita minoo ángel ra Ndyoo ndya andɨvɨ, ta i noo ra ndya nu ñuhu, ta i saa ra ndya ñaña. I tyaa siyo ra yuu sa ndazi yuñaña cuan, ta i sicundyaa ra nuu si. ");
INSERT INTO mihNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ndisi xaan ra tañi minoo tasa zavi, ta cuisi xaan zahma ra tañi caa nieve cuisi. ");
INSERT INTO mihNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Cuhva sa ndyehe zandaru sii ra, ta nɨhɨ ra sihin sa yuhu ra, ta i cuañaa ra. ");
INSERT INTO mihNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ta i catyi ángel cuan sihin ñu zɨhɨ cuan: Ma yuhu ndo. Site vatyi nanducu ndo sii ra Jesús, ra i sihi nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yoñi ca ra ihya. Sa i nandoto ra tañi i nacatyi ra. Ñaha ndo, ta ndyehe ndo nu i caa coño ñuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yatyi cuii ñi cuhun ndo, ta nacatyi ndo sihin ra i casi ra vatyi sa nandoto ra. Ta catyi ndo: “Xihna ca ra Jesús cuahan ndya Galilea ta zɨquɨ maa ndo. Yucuan cua ndyehe ndo sii ra,” catyi ndo. Ihya cuu sa tahan si nacatyi sihin ndo, catyi ángel cuan sihin ñu zɨhɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ta i yuhu xaan ñu zɨhɨ cuan, ta zɨɨ xaan i cuñi ñu, ndɨhɨ ca, ta yatyi xaan i naquihin ñu ityi cuahan ñu, ta i cacono ñu vatyi cua nacatyi ñu sihin ra i casi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ityi cuahan ñu i quituu ra Jesús ityi nuu ñu, ta i catyi ra: Nacumi sii maa ndo. Ta i tuhva ñu sii ra Jesús, ta i tɨɨn ñu saha ra, ta i zacahnu xaan ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tacuan ta i catyi ra Jesús sihin ñu: Ma yuhu ndo. Cuahan ndo ta nacatyi ndo sihin ra yañi vatyi nacuhun ra ndya Galilea, ta yucuan cua ndyehe ra sii. ");
INSERT INTO mihNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nɨɨ ñi sa cuahan ñu zɨhɨ cuan, ta zuhva zandaru, ra zacuenda ñaña cuan, cuanuhu ra ndya ñuu, ta i nacatyi ra sihin ra zutu nahnu tandɨhɨ sa i cuu. ");
INSERT INTO mihNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ta i sahan ra zutu nahnu cuan, ta i natuhun ra sihin ra mandoñi yozo caa cua zavaha ra ta i ndu‑ɨɨn ra minoo cuhva. Ta zɨquɨ i saha ra cuaha xaan xuhun sii zandaru, ");
INSERT INTO mihNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ta i catyi ra sihin ra: Catyi ndo vatyi i quisi ra tahan ra sa sa cuaa, ta i zuhu ra coño ñuhu ra nɨɨ ñi sa quixi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ta tatu cua coto ra gobernador cuhva ya, cua zasino ndi iñi ra, ta tacuan ta ñahñi cua tahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tacuan ta i quihin zandaru xuhun cuan, ta cuahan ra, ta i cahan ra cuhva i nacatyi ra cuan sihin ra. Ta sino iñi ñiyɨvɨ hebreo tuhun cuan ndya cuhva ndya vityi. ");
INSERT INTO mihNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tacuan ta cuahan sa usi ɨɨn tahan ra i casi ra Jesús ndya Galilea ndya minoo yucu sa i zacoto ra Jesús sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ta cuhva sa ndyehe ra sii ra Jesús, i zacahnu ra sii ra, zoco zuhva ra ñá sino vaha iñi sa zuun ra cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ta zɨquɨ i tuhva ra Jesús sii ra, ta i catyi ra sihin ra: Saha ra Ndyoo tandɨhɨ cuii cuhva sii sa cundyaca ñehi andɨvɨ ta nu ñuhu ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Cuahan ndo nacahnu ñuu ñiyɨvɨ, ta zacuaha ndo sii tandɨhɨ ñiyɨvɨ. Zacoo ndutya ndo sii ñu sihin zɨvɨ ra Ndyoo Zutu yo ta sihin zɨvɨ Zehe ra ta sihin zɨvɨ Tatyi Ii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tandɨhɨ sa i zacuehi sii ndo, nacatyi ndo sii si sihin ñu cua sino iñi vatyi natyaa ñu yahvi sii si. Ta coto ndo vatyi yuhvi ndyei sihin ndo tandɨhɨ cuii quɨvɨ ndya cuhva ndya cua ndɨhɨ ñuu ñiyɨvɨ. Ta nacuu si tacuan, ta nacuu si sa ndisa.");
INSERT INTO mihNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ihya cuhva quisaha Tuhun Vaha sa cuenda ra Jesucristo, ra cu zehe Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Cuhva i zatyaa ra Ndyoo sii ra Isaías tuhun ra ta tyiemvu, ta i tyaa ra Isaías cuhva i cahan ra Ndyoo sihin ra Cristo ta catyi ra: Cua tasi sii minoo ra sa xihna ñi, ta cua zacoto ra sii ñiyɨvɨ vatyi cua cuhun. Vatyi quɨvɨ cua soon ta cua tyizoho ñu sa cohon. ");
INSERT INTO mihNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Cua cana saa ra cuan sisi cuhu ta catyi ra sihin ñiyɨvɨ: “Zama ndo cuhva iyo ndo vatyi sa cua saa ra ndyaca ñaha sii yo.” ");
INSERT INTO mihNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ta i quisi ra i tasi ra Ndyoo, ra cua cana saa sisi cuhu. Sinañi ra Juan. I zacoo ndutya ra sii ñiyɨvɨ. Ta i zacuaha ra sii ñu vatyi coo ndutya ñu ta zama ñu cuhva iyo ñu, ta zɨquɨ cua zandasi ra Ndyoo cuatyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ñiyɨvɨ ñuu Jerusalén ta tandɨhɨ ñuu nu cu si Judea i sahan ñu nu ndyaa ra Juan. Ta sa yaha nahma ñu cuatyi ñu nuu ra Ndyoo, ta zɨquɨ i sicoo ndutya ñu i zacuu ra Juan yuu sa nañi río Jordán. ");
INSERT INTO mihNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ixi camello i cuu zahma ra Juan, ta i sinuhñi zinda ñɨɨ sisi ra. Ta i sasi ra minoo nuu quɨtɨ tañi tɨca ta sihi ra tyahiñu ñuñu. ");
INSERT INTO mihNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","I cahan ra sihin ñiyɨvɨ ta catyi ra: Ta cua yaha zuhva quɨvɨ ta cua quisi inga ra cahnu ca. Ña tahan si sii, nu sa cui muzu ra ta cuize ndisa ra, zoco zuun ñi maa ra i saha tyiño sii. ");
INSERT INTO mihNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Zacoo ndutye sii ndo sihin ndutya, zoco maa ra cua zacoo ndutya sii ndo sihin Tatyi Ii. Tacuan i catyi ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ta i yaha zuhva ñi quɨvɨ ta i quita ra Jesús ñuu Nazaret nu cu si Galilea, ta i saa ra yuu Jordán, ta i zacoo ndutya ra Juan sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Zuun ñi caa cuhva sa nduvita ra Jesús nu ndutya cuan ta i nandyehe ndaa ra, ta i ndyehe ra vatyi nuña ityi andɨvɨ, ta i noo xica Tatyi Ii sii maa ra tañi noo minoo paloma. ");
INSERT INTO mihNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ta i siñi ra minoo nduzu sa cahan ityi zɨquɨ, ta catyi si: Yoho cuu zehi. Ta cuñi xein suun. Zɨɨ xaan cuñi suhun. ");
INSERT INTO mihNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ta zuun ñi quɨvɨ cuan i saca Tatyi Ii sii ra Jesús, ta cuahan ra minoo cuhu cahnu. ");
INSERT INTO mihNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ta yucuan i ñoho ra uu xico quɨvɨ nu sicoo quɨtɨ cuhu. Ta i nducu ra cu nuu sii cuihna cuhva coto ihñi ra sii ra vatyi cuñi ra sa tyaa ra Jesús yahvi sii ra. Ta zɨquɨ i quisi tyindyee ángel Ndyoo sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tacuan ta zɨquɨ i tyihi ñiyɨvɨ sii ra Juan vehe caa, ta i quisi nuhu ra Jesús nu cu si Galilea, ta i zacoto ra sii ñiyɨvɨ Tuhun Vaha sa cuenda cuhva ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ta i catyi ra Jesús: Vityi sa cuñi saa quɨvɨ cua cundyaca ñaha ra Ndyoo ihya ñuu ñiyɨvɨ. Zandoo ndo cuatyi ndo, ta sino iñi ndo Tuhun Vaha. ");
INSERT INTO mihNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","I sica noo ra Jesús yumiñi Galilea, ta i ndyehe ra sii ra Simón sihin yañi ra, ra Andrés. Cañi ra traya ra nu ndutya vatyi yucuan cuu tyiño zacuu maa ra. ");
INSERT INTO mihNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ta i cana ra Jesús sii ra ta catyi ra: Coho ndo sihin, ta cua cuhve cuhva nducu ndo sii ñiyɨvɨ tañi cuhva nducu ndo sii tyiyaca. Tacuan i catyi ra Jesús sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ta ta sica ñi i zandoo ihno ra traya ra, ta cuahan ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ta i sica ra Jesús zuhva ca sihin ra ityi nuu ca, ta i ndyehe ra sii ra Jacobo sihin ra Juan yañi ra. Ta zehe ra Zebedeo cuu sii ra. Ñoho ra barco. Nazuhva ra traya ra. ");
INSERT INTO mihNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","I cana ra Jesús sii ra, ta i zandoo ra sii ra Zebedeo zutu ra sihin muzu ra sisi barco. Ta i sindyico ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","I saa ra Jesús sihin ra i cana ra ñuu Capernaum, ta quɨvɨ tuhva ñiyɨvɨ quitatu i quɨhvɨ ra Jesús vehe ñuhu. Ta i zacuaha ra sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ta iyo xaan i cuñi ñiyɨvɨ sihin cuhva i zacuaha ra vatyi ñá zacuaha ra tañi zacuaha ra maestro cuenda ley, zoco i zacuaha ra tañi sa saha ra Ndyoo sa siñi tuñi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ta sisi vehe ñuhu cuan i ñoho minoo ra, ra ñoho tatyi cuihna añima. Ta i quisaha cana saa ra. Ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","¿Ñaa sa cuñun sihin ndi? Jesús, ra ñuu Nazaret. ¿Atu vasun sa vasi zandyehun tundoho sii ndi? Site yoo ra cuun. Moo cuu ra cu zehe Ndyoo, ra ñahñi cuatyi. Tacuan i cahan ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tacuan ta xaan xaan i cahan ra Jesús sihin tatyi cuihna cuan ta catyi ra: Cazi yuhun ta ma cohon. Ta quita ndo sii ra ya. ");
INSERT INTO mihNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ta ñihi xaan i zanɨhɨ tatyi cuihna cuan sii rayɨɨ cuan, ta saa xaan i sacu saa si, ta i quita si añima ra. ");
INSERT INTO mihNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ta iyo xaan i cuñi ñiyɨvɨ, ta i nducu tuhun tahan ñu: ¿Yozo caa? Minoo cuhva saa cuu si vatyi ra ihya iyo cuhva sii ra vatyi cahan ra sihin tatyi cuihna, ta tyaa si yahvi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ta yatyi xaan i sito ñiyɨvɨ nacahnu nu cu si Galilea cuhva i zavaha ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tacuan ta zɨquɨ i quita ra vehe ñuhu ta cuahan ra Jesús sihin ra Jacobo ta ra Juan ndya vehe ra Simón ta ra Andrés. ");
INSERT INTO mihNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","I caa tyizo ra Pedro nu sito. Cuhu ña cahñi. Ta i nacatyi ñu sihin ra Jesús vatyi cuhu ña. ");
INSERT INTO mihNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","I tuhva ra nu ndyaa ña, ta i tɨɨn ra ndaha ña, ta i tyindyee ra sii ña, ta i nduvita ña. Zuun ñi caa cuhva cuan i ndyico cahñi sii ña, ta i nduvita ña. Ta i zavaha ña sa casi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Sa tyizo ñicandyi ta sa tyahan cuan i quisi ndyaca ñiyɨvɨ sii tandɨhɨ ñu cuhu, zɨɨn zɨɨn nuu cuehe, ta ñu ñoho tatyi cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ta i quisi tuu xaan ñiyɨvɨ yuvehe nu ñoho ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ta i zanduvaha ra Jesús sii cuaha xaan ñu cuhu cuaha xaan nuu cuehe, ta i tava ra sii cuaha xaan tatyi cuihna sii ñiyɨvɨ, zoco ñá saha maa ra sa cahan tatyi cuihna cuan vatyi i nacoto si sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ta inga quɨvɨ ñaa ca i nduvita ra Jesús ta sahan ra minoo cuhu, ta i quisaha cahan ra sihin ra Ndyoo Zutu ra, ra iyo andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ta ra Simón sihin ra tahan ra i sinanducu ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ta nu nañihi ra sii ra Jesús i catyi ra sihin ra: Nanducu xaan ñiyɨvɨ suun. ");
INSERT INTO mihNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Zoco i catyi ra Jesús: Coho yo tandɨhɨ inga ñuu yatyi ñi ihya vatyi indyacuan cua cahan tuqui Tuhun Ndyoo vatyi yucuan cuenda vasi. ");
INSERT INTO mihNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ta i sica noo ra tandɨhɨ nu cu si Galilea. I zacoto ra sii ñiyɨvɨ Tuhun Ndyoo tahan tahan vehe ñuhu, ta i tava ra tatyi cuihna sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Minoo saha i tuhva minoo ra nu ndyaa ra Jesús. Cuhu xaan ra sihin cuehe sa tyahyu ra. I sicuɨñɨ sɨtɨ ra, ta i catyi ra: Iyo cuhva suun, tatu cuñun cuu zanduvohon sii. ");
INSERT INTO mihNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ta i cundahvi iñi ra Jesús sii ra cuan, ta i tɨɨn ra ndaha ra ta catyi ra: Cuñi. Zanduvehi suun. ");
INSERT INTO mihNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ta zuun ñi caa cuhva cuan i quita cuehe cuan sii ra, ta ndaha nduvaha ñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ta zɨquɨ i catyi ra Jesús sihin ra vatyi cuu cunuhu ra, zoco ñihi xaan i saha ra tuhun sii ra ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ndyehun, vatyi ma nacatyun sihin ñiyɨvɨ. Cuhun nu ndyaa ra cu zutu vehe ñuhu hebreo, ta cuhvon sii ra Ndyoo sa i catyi ra Moisés sa cua cuhva ñiyɨvɨ tatu nduvaha ñu. Tacuan ta cua coto ñiyɨvɨ vatyi i nduvohon. ");
INSERT INTO mihNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tacuan ta cuahan ra i nduvaha, ta i nacatyi ra sihin tandɨhɨ ñiyɨvɨ cuhva i cuu sii ra. Ta yucuan cuenda ñá cuu ca quɨhvɨ ra Jesús inga ñuu. I sica noo ra nu yoñi ñiyɨvɨ iyo. Zoco i sahan xaan ñiyɨvɨ zɨɨn zɨɨn ñuu ndya nu ndyaa ra. ");
INSERT INTO mihNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ta i yaha zuhva quɨvɨ ta zɨquɨ i quisi nuhu ra Jesús ndya ñuu Capernaum, ta yatyi xaan i sito ñiyɨvɨ vatyi sa nasaa nuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ta ta sica cuii ñi i titahan ñiyɨvɨ cuhva ndya ñá cuu ca quɨhvɨ ñu yuvehe. Ta i zacuaha ra Jesús sii ñu Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ta i quisi minoo ityi ñiyɨvɨ ta ndyizo cumi tahan ra sii minoo ra xii. ");
INSERT INTO mihNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ta ñá cuu yaha ra yuvehe nu ñoho ra Jesús vatyi tuu xaan ñiyɨvɨ yucu. Cuu, i ndaa ra xiñi vehe, ta i nuña ra xiñi vehe, ta i zanoo ra sii ra xii sihin minoo tyuhva nu nandyaa ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","I ndyehe ra Jesús cuhva sa nɨɨ iñi tandɨhɨ ra, ta i catyi ra Jesús sihin ra xii cuan: Zandasi cuatyun, zehe luhli. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ta yucu uu tahan ra maestro cuenda ley yucuan, ta sica iñi ra sihin añima ra: ");
INSERT INTO mihNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ñacu cahan ra ya tacuan? Yoñi ra cuu zandasi cuatyi ñiyɨvɨ. Maa ñi ra Ndyoo cuu zandasi cuatyi ñiyɨvɨ.” ");
INSERT INTO mihNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ta i sito ra Jesús cuhva sica iñi ra sihin añima ra, ta i quisaha ndaca tuhun ra: ¿Ñacu sica iñi ndo tacuan sihin añima ndo? ");
INSERT INTO mihNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sica iñi ndo vatyi ña vaha quehin vatyi i catyi sihin ra ya: “Zandasi cuatyun.” Ta vityi cua zañehi sii ndo vatyi iyo cuhva sii, ta cua catyi sihin ra: “Nduviton ta nacuhun yuun, ta cunuhun.” ");
INSERT INTO mihNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Cua zañehi sii ndo vatyi iyo cuhva sii vii, vatyi ra i quisi ndya gloria cui. Ta cua zandasi cuatyi ñiyɨvɨ ñuu ñiyɨvɨ. Ta i cahan ra sihin ra xii cuan, ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Quehin suhun vatyi nduviton, ta nacuhun tyuhvon, ta cunuhun ndya vehun. ");
INSERT INTO mihNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ta yatyi xaan i nduvita ra xii cuan. I naquihin ra tyuhva ra, ta i quita ra. I ndyehe tandɨhɨ ñiyɨvɨ, ta iyo xaan i cuñi ñu, ta i catyi ñu vatyi iyo xaan cuhva sii ra Ndyoo. Ta catyi ñu: Tañaha ca ma ndyehe yo sa tyehen yozo vasi si. ");
INSERT INTO mihNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tacuan ta zɨquɨ cuahan tucu ra Jesús ityi yuhu tyañuhu. Ta i tatahan cuaha xaan ñiyɨvɨ. Ta i zacuaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ta sa cuahan tucu ra Jesús i ndyehe ra sii ra Leví, zehe ra Alfeo. I zatyiyahvi ra sii ñiyɨvɨ sa cuenda xuhun ra ndyaca ñaha. Ta i catyi ra Jesús sihin ra: Coho sihin. Ta yatyi xaan i nduvita ra Leví, ta cuahan ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ta sa i sasi ra Jesús xita vehe ra Leví, ɨɨn ñi mesa i siyucu ra sihin ra sica noo sihin ra ta sihin cuaha xaan ra zatyiyahvi sii ñiyɨvɨ sa cuenda xuhun ra ndyaca ñaha ta sihin inga ra iyo cuatyi vatyi i sindyico cuaha xaan ra iyo cuatyi sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ta i ndyehe ra maestro cuenda ley ta ra fariseo vatyi sasi ra Jesús xita sihin ra cuan, ta i catyi ra sihin ra ndɨhɨ sihin ra Jesús: ¿Ñacu sasi ra xita sihin ra zatyiyahvi sii ñiyɨvɨ ta ra iyo cuatyi? ");
INSERT INTO mihNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ta sa siñi ra Jesús sa cahan ra ta i catyi ra: Ña cuñi si médico sii ra iyo vaha, zoco sii ra cuhu cuñi si. Ña vasi sa cuenda ñiyɨvɨ sica iñi vatyi vaha xaan ñu. Vasi sa cuenda ñiyɨvɨ sito vatyi iyo cuatyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ñiyɨvɨ i sindyico sii ra Juan sihin ñiyɨvɨ i sindyico sii ra fariseo ñahñi maa sasi ra tatu sica tahvi ra sii ra Ndyoo. Ta i ndyehe inga ñiyɨvɨ. Ta i ndaca tuhun ñu sii ra Jesús ta catyi ñu: ¿Ñacu sasi ñiyɨvɨ ndyico suun xita tandɨhɨ quɨvɨ vazu sica tahvi ñu sii Ndyoo? Ta ñiyɨvɨ ndyico sii ra Juan ta ñiyɨvɨ ndyico sii ra fariseo ñahñi maa sasi ra tatu sica tahvi ra sii Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ta i cahan ra Jesús minoo cuhva sihin ñu ta catyi ra: ¿Ñacu ma casi ñiyɨvɨ xita tatu cuahan ñu minoo vico tindaha? Tatu ndyaa ra tindaha, sasi vaha tandɨhɨ ñiyɨvɨ vatyi zɨɨ cuñi ñu. Ta tacuan tucu ñiyɨvɨ ndyico sii. Zɨɨ cuñi ñu vatyi ndyei sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Zoco tatu sa cuahan ra tindaha, tacuan ta zɨquɨ ma casi ca ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ña vaha cua cutyiño ñiyɨvɨ zahma saa sa natyaa ñu minoo zahma sahnu vatyi zahma saa cuan cua ndɨyɨ si, ta zɨquɨ cua tahndya ca zahma sahnu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ta inga cuhva vatyi ma zavaha ñiyɨvɨ ndixi panela sisi quɨzɨ sahnu vatyi cua cuizo si ta ndaa si. Ta cua cahndi quɨzɨ cuan tatu sahnu si. Tatu cua zavaha ñu ndixi panela, cuñi si quɨzɨ saa. Ta tandɨhɨ cuhva zacuehi cuu sa saa. Ta ña vaha nacuzaca si sihin sa sahnu. Cuñi si sa zama ndo cuhva iyo ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Minoo saha quɨvɨ quitatu ñiyɨvɨ, cuahan ra Jesús sihin ra sica noo sihin ra, ta i yaha ra sisi itu trigo sa zavaha ñiyɨvɨ yutyi pan. Ta i quisaha tohon ra ndɨhɨ sihin ra Jesús zuhva si. ");
INSERT INTO mihNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tacuan ta i catyi ra fariseo: Ndyehe, ¿ñacu zatyiño ra ndɨhɨ suhun? Ta vityi cuu quɨvɨ quitatu ñiyɨvɨ vatyi tacuan catyi ley. ");
INSERT INTO mihNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Zoco i catyi ra Jesús sihin ra: ¿Atu ta cahvi ca ndo Tuhun Ndyoo cuhva i zavaha ra rey David minoo saha sihin amigo ra? vatyi i sizoco xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","I quɨhvɨ ra David vehe ñuhu quɨvɨ i cuu ra Abiatar ra cu zutu ya cahnu. Ta i sasi ra pan ii. Ta yucuan pan ii, maa ñi ra cu zutu cuu casi. Zoco i sasi ra David sii si. Ta i saha ra i sasi ra tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ta inga cuhva catyi tucu ra Jesús: Iyo quɨvɨ quitatu ñiyɨvɨ sa vatyi cua tyindyee si sii ñu. Ñá zavaha ra Ndyoo sii ñiyɨvɨ sa cuenda quɨvɨ cuan. I zavaha ra quɨvɨ cuan vatyi cua tyindyee si sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ta yuhvi, ra i quisi ndya gloria cui. Ta iyo cuhva sii, sa catyi ñaa sa cua zavaha ñiyɨvɨ quɨvɨ quitatu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","I quɨhvɨ tucu ra Jesús vehe ñuhu, ta yucuan ndyaa minoo ra na‑ityi ndaha. ");
INSERT INTO mihNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ndyehe ihñi ra fariseo nu ñoho ra Jesús tatu ndisa cuii cua zanduvaha ra sii ra na‑ityi ndaha cuan quɨvɨ quitatu ñiyɨvɨ vatyi cuñi ra tyaa ra cuatyi sata ra. ");
INSERT INTO mihNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ta i catyi ra Jesús sihin ra na‑ityi ndaha cuan: Ñaha mahñu ya. ");
INSERT INTO mihNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ta zɨquɨ i ndaca tuhun ra Jesús sii ra fariseo: ¿Ñaa sa cua zavaha yo quɨvɨ quitatu ñiyɨvɨ? ¿Atu vaha cua zavaha yo sa vaha a sa ña vaha? ¿Atu cua zanduvaha yo sii ñiyɨvɨ a cuhva yo sa cuu ñu? Ta ñá nacahan ra fariseo ndaha cuii ñi. ");
INSERT INTO mihNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tacuan ta i cuxaan ra Jesús sihin ra, ta i nducuihya iñi ra sihin ra vatyi ñihi xaan iñi ra. Ta i catyi ra Jesús sihin ra na‑ityi ndaha cuan: Nandɨca ndohon. Ta i nandɨca ra ndaha ra, ta zuun ñi caa cuhva cuan i nduvaha si. ");
INSERT INTO mihNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tacuan ta i quita tandɨhɨ ra fariseo nu ñoho ra Jesús, ta i natuhun tahan ra sihin minoo ityi amigo ra Herodes. Ta i quisaha nducu ra cuhva cahñi ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ta ra Jesús cuahan ra sihin ra sica noo sihin ra ndya tyañuhu, ta i sindyico cuahan xaan ñiyɨvɨ Galilea sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ta sa sito ñu vatyi tyiño vaha zavaha ra Jesús, ta i quita ñu Judea, ta ñuu Jerusalén, ta Idumea ta inga siyo yuu Jordán. Ta tandɨhɨ ñuu ndyaa yatyi sii ñuu Tiro ta ñuu Sidón, ta i quisi ndyehe ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yucuan cuenda i catyi ra Jesús sihin ra ndɨhɨ sihin ra vatyi nazaquisi ra minoo barco vatyi quɨhɨ ra Jesús, ta ma catyihi xaan ñiyɨvɨ sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sa zanduvaha ra Jesús sii cuaha xaan ñiyɨvɨ cuhu, ta yucuan cuenda i quisi tuu xaan ñiyɨvɨ cuhu vatyi cua tɨɨn ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ta sa ndyehe ñiyɨvɨ ñoho tatyi cuihna cuan sii ra Jesús sicuɨñɨ sɨtɨ ñu, ta cana saa cuihna ñoho sii ñu: ¡Yoho, zehe ra Ndyoo cuu suun! ");
INSERT INTO mihNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ta ñihi xaan i cahan ra Jesús sihin tatyi cuihna cuan vatyi ma nacatyi ca si yoo ra cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tacuan ta zɨquɨ i ndaa ra Jesús minoo yucu, ta i cana ra yoo ra cua cuizo tyiño, ta i sahan ra cuan nu ndyaa ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","I quihin ra Jesús sii usi uu tahan ra vatyi cua cutahan ra sihin ra, ta cua tasi ra Jesús sii ra, ta cua zacoto ra sii ñiyɨvɨ Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ta i saha ra Jesús cuhva sii ra vatyi cuu zanduvaha ra sii ñiyɨvɨ cuhu, ta cuu tava ra tatyi cuihna sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ihya cuu zɨvɨ sa usi uu tahan ra i casi ra Jesús: Simón, i zacunañi ra Jesús sii ra Pedro; ");
INSERT INTO mihNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ra Jacobo sihin yañi ra, ra Juan, zehe ra Zebedeo cuu sii nduu tahan ra, ta i zacunañi ra Jesús sii ra, ra xaan; ");
INSERT INTO mihNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ra Andrés, ra Felipe, ra Bartolomé, ra Mateo, ra Tomás, ra Jacobo zehe ra Alfeo; ra Tadeo, inga ra Simón, maa ra cuu cuenda minoo ityi ra cuñi zama sii ra ndyaca ñaha, ");
INSERT INTO mihNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ta ra Judas Iscariote, maa ra cuu ra cua xico sii ra Jesús cuee ca. ");
INSERT INTO mihNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tacuan cuu cuhva i cana ra Jesús sii ra i casi ra, ta zɨquɨ i quɨhvɨ ra Jesús sisi minoo vehe sihin sa usi uu tahan ra cuan, ta i quisi tucu cuaha xaan ñiyɨvɨ cuhva ña cuyatyi ca ra casi ra xita. ");
INSERT INTO mihNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ta sa sito zɨhɨ ra ta yañi ra Jesús tuhun cuan, ta cuahan ñu vatyi cua naquihin ñu sii ra vatyi cahan xaan ñiyɨvɨ, ta catyi ñu vatyi zana xiñi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ta ra maestro cuenda ley, ra i quisi ndya ñuu Jerusalén, i catyi ra: Ra ihya, ñoho ra cu nuu sii cuihna sii ra. Ta tava ra tatyi cuihna sihin tundyee iñi iyo sii ra Beelzebú, ra cu nuu sii cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tacuan ta i cana ra Jesús sii ñiyɨvɨ, ta i quisaha zacuaha ra sii ñu sihin minoo cuhva ta catyi ra: ¿Ñaa sa sica iñi ndo? ¿Atu cua tava ra cu nuu sii cuihna sii inga cuihna? ");
INSERT INTO mihNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tatu iyo minoo ñuu ta sahñi tahan xaan ñiyɨvɨ sihin inga ñiyɨvɨ sa zuun ñi ñuu cuan, yatyi xaan cua tɨvɨ ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ta tatu sahñi tahan ñiyɨvɨ sihin tahan ñu, sihin cuhva ñu, sihin yañi ñu, yatyi xaan cua tɨvɨ cuhva yucu ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ta ma cahñi tahan ra cu nuu sii cuihna sihin inga cuihna vatyi tatu tacuan zavaha ra, yatyi xaan cua ndɨhɨ cuhva iyo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ñihi xaan cuu ra cuihna, ta sa sito yo vatyi ma cuu quɨhvɨ ñiyɨvɨ vehe minoo ra ñihi xaan ta quihin ñu ndaha tyiño ra tatu ma cuhñi xihna ñu sii ra. Tatu sa nuhñi ra ñihi cuan, tacuan ta zɨquɨ cuu quɨhvɨ yoo ra cuñi ta quihin ra ndaha tyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ndisa cuii cuu si vatyi cuu zandasi ra Ndyoo tandɨhɨ cuatyi zavaha ñiyɨvɨ ta tandɨhɨ sa quiñi cahan ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Zoco tatu ndyehe ñiyɨvɨ cuhva zatyiño Tatyi Ii ra Ndyoo ta catyi ñu vatyi cuihna zatyiño, ma zandasi ra Ndyoo cuatyi ñu nu yozo cuii ca. Tandɨhɨ cuii tyiemvu cua ndoo cuatyi cuan zɨquɨ ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tacuan i catyi ra Jesús vatyi numaa zatyiño ra sihin cuhva sii Tatyi Ii ra Ndyoo, zoco i catyi ñiyɨvɨ vatyi zatyiño ra sihin cuhva iyo sii cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tacuan ta zɨquɨ i saa zɨhɨ ra Jesús sihin yañi ra, ta i tasi ñu tyiño ñu ñoho ra Jesús vatyi naquisi ra nu ndyaa ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ta ñiyɨvɨ yucu siconduu sihin ra Jesús i catyi ñu sihin ra: Saa zɨhun ta yañun. Nanducu ñu suun. Yucu ñu sata vehe. ");
INSERT INTO mihNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ta i catyi ra Jesús: ¿Yoo sa cuu zɨhi? ¿Ta yoo sa cuu yañi? ");
INSERT INTO mihNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ta zɨquɨ i nandyehe ra nu yucu ñiyɨvɨ siconduu sihin ra, ta i catyi ra: Ñu ihya cuu tañi zɨhi. Ta ra ihya cuu tañi yañi. Ta ñu ihya cuu tañi cuhve. ");
INSERT INTO mihNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Vatyi yoo ñiyɨvɨ zavaha tandɨhɨ sa catyi ra Ndyoo, yucuan cuu ñu cuñi tañi ñiyɨvɨ sii. Tacuan i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Inga saha i quisaha zacuaha ra Jesús sii ñiyɨvɨ ityi yuhu tyañuhu. Ta cuaha xaan ñiyɨvɨ i titahan nu ndyaa ra, ta i quɨhvɨ ra Jesús sisi minoo barco vatyi tuu xaan ñiyɨvɨ. Ta i sicundyaa ra. Ta tandɨhɨ ñiyɨvɨ i nandoo nuu ñiyɨtɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ta i zacuaha ra sii ñiyɨvɨ zɨquɨ minoo cuhva ta inga cuhva. Ta ihya cuu minoo cuhva i cahan ra: ");
INSERT INTO mihNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tyizoho ndo cuhva ya vatyi minoo saha sahan minoo ra cua tasi sɨtɨ trigo. ");
INSERT INTO mihNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Zuhva si i canacava si ityi nu ndava ñuhu. I quisi zaa, ta tandɨhɨ cuii si i sasi tɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Zuhva si i canacava nu yaxi ñoho ñuhu vatyi ñoho xaan yuu. Yatyi xaan i caña si vatyi ña coco caa ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tacuan ta ndyii xaan i nanduu. Ta i xii yava ndyihi cuan vatyi ñá tɨɨn yoho si. ");
INSERT INTO mihNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ta inga si i canacava si sisi iñu. Ta yatyi ca sahnu iñu cuan. Ta i zahvi iñu cuan sii si, ta ñá saha si sɨtɨ si. ");
INSERT INTO mihNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Zoco zuhva si i canacava si nu vaha ñuhu. Yucuan cuu sa sahnu vaha. Ta i saha si sɨtɨ si. Iyo si saha si ziendu sɨtɨ si sa minoo ñi si. Iyo si saha si uñi xico usi. Ta iyo si saha si oco usi. ");
INSERT INTO mihNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ta i catyi ra sihin ñu: Tatu siñi ndo, ¡cuɨñɨ ndo! ");
INSERT INTO mihNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tacuan ta zɨquɨ i nandoo zuhva ca ñiyɨvɨ sihin ra Jesús ta sihin ra i casi ra. Ta i ndaca tuhun ñu sii ra Jesús: ¿Ñaa cuñi si catyi si sa cuenda cuhva cuan? ");
INSERT INTO mihNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ta i catyi ra Jesús sihin ñu: Saha ra Ndyoo sa coto maa ndo yozo caa ndyaca ñaha maa ra. Zoco cuhva cuan maa ñi sihin cuhva quehin sihin inga ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Vatyi maa ñu, cua ndyehe ñu. Zoco ma cuu coto ñu ñaa sa ndyehe ñu. Cua tyizoho ñu. Zoco ma cutuñi iñi ñu. Vatyi tatu cua cuɨñɨ ñu, cua zama ñu cuhva iyo ñu. Ta cua zandasi ra Ndyoo cuatyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tacuan ta zɨquɨ i ndaca tuhun ra Jesús sii ñu. Ta i catyi ra: ¿Atu ña siñi ndo cuhva cuan? Tatu ña siñi ndo sii si, ¿yozo caa cua cuɨñɨ ndo inga cuhva? ");
INSERT INTO mihNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tañi ra i tasi sɨtɨ yutu cuan, tacuan iyo ra nacatyi sihin ñiyɨvɨ Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tañi sɨtɨ i canacava ityi, tacuan iyo zuhva ñiyɨvɨ. Siñi ñu sa cahan ra Ndyoo, zoco yatyi xaan quisi cuihna. Ta quihin ra tuhun sa siñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ta iyo inga ñiyɨvɨ tañi sɨtɨ sa canacava nu yaxi ñuhu. Tacuan iyo maa ñu. Siñi ñu Tuhun Ndyoo, ta cuñi xaan ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Zoco ña quɨhvɨ vaha si añima ñu. Ta ña naha cua sino iñi ñu. Tatu sa quisi minoo tundoho zɨquɨ ñu a cuxaan ñiyɨvɨ sihin ñu sa cuenda Tuhun Ndyoo, yatyi xaan cua zaña ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ta inga ñiyɨvɨ, tañi sɨtɨ sa canacava sisi iñu cuu ñu. Siñi ñu Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Zoco sica iñi ñu tuhun sa iyo ñuu ñiyɨvɨ. Ta tuhun cuca, tuhun zandavi ñaha ñi cuu si cuan. Ta cuñi xaan ñu tandɨhɨ nuu ndaha tyiño. Ta tandɨhɨ cuhva cuan zanaa si iñi ñu Tuhun Ndyoo. Ta ma zatyiño vaha si sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Zoco iyo inga ñiyɨvɨ siñi ñu Tuhun Ndyoo. Ta sino iñu ñu. Yucuan cuu ñiyɨvɨ vaha zatyiño, tañi sɨtɨ sa i canacava nu ñuhu vaha. Iyo ñiyɨvɨ vaha xaan zatyiño ñu tyiño ra Ndyoo tañi sɨtɨ i saha minoo ziendu sa minoo si. Ta inga ñu cuu tañi sɨtɨ i saha uñi xico usi ñi. Ta inga ñu cuu tañi sɨtɨ i saha oco usi ñi. ");
INSERT INTO mihNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ta i catyi tucu ra Jesús sihin ñu: Tatu cayu minoo lámpara vehe ñiyɨvɨ, ¿atu cua tyihi ñu sii si sisi tyica a xu sito? Ña tacuan. Zucu tyaa ñu sii si cuñi si vatyi tacuan ta ndundisi sisi vehe. ");
INSERT INTO mihNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta tañi lámpara tatu ñoho xehe si sisi tyica, tacuan iyo cuhva zacuehi sii ndo vityi. Zoco cua coo quɨvɨ ta cua cuɨñɨ ñiyɨvɨ nacahnu ñuu ñiyɨvɨ cuhva zacuehi ihya. ");
INSERT INTO mihNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yoo ra tyizoho, natyizoho vaha ra. ");
INSERT INTO mihNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tyizoho vaha ndo ñaa sa siñi ndo. Tatu zuhva ñi cua tyizoho ndo, zuhva ñi cua coto ndo. Tatu tyizoho vaha ndo cua coto ndo cuaha ca vatyi cua cuhva ra Ndyoo sii ra tyizoho vaha vatyi cua coto ra cuaha ca. ");
INSERT INTO mihNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sii ra sa iyo cuaha ca, cuaha ca cua cuhva ra. Ta sii ra iyo zuhva ñi, cua naquihin ndɨhɨ ra Ndyoo sii si. ");
INSERT INTO mihNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Catyi tucu ra Jesús: Ñiyɨvɨ ndyaca ñaha ra Ndyoo, nducuaha ca ñu tañi nducuaha sɨtɨ. Tasi minoo ra ndaha tyiño nu ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Quixi ra sa sa cuaa. Ta nduvita ra ñaha ñi. Ta caña sɨtɨ cuan, ta cua cuahnu maa tuhun ñi si. Ña sito ra cuan yozo caa sahnu si. ");
INSERT INTO mihNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ñuhu cuan saha tundyee iñi, ta cua cuahnu sɨtɨ cuan. Sa xihna ñi cua coo yutu tu. Ta zɨquɨ coo yoco tu. ");
INSERT INTO mihNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tatu sa sisa sɨtɨ cuan. Ta zɨquɨ cua cahndya ra sii si ta naquihin ra sii si vatyi sa saa tyiemvu si. ");
INSERT INTO mihNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ta i catyi tucu ra Jesús: ¿Ñaa sihin cuu zacasi tahan yo cuhva ndyaca ñaha ra Ndyoo? ¿Ñaa cuhva cua nacatyi sihin ndo vatyi cua cuɨñɨ ndo? ");
INSERT INTO mihNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tañi minoo sɨtɨ mostaza, tacuan iyo si. Ñahñi sɨtɨ luhlu ca sa nuu mostaza iyo nacahnu ñuu ñiyɨvɨ. Quihin minoo ra sii si, ta tasi ra sii si nu ñuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ta cuee ca cua cuahnu si. Ta cua nduu si cahnu xaan, cahnu ca ta zɨquɨ cuaha xaan inga nuu sɨtɨ sa tasi yo. Nahnu xaan zoco tu. Ta ndya cuhva ndya zaa ta cua quisi cozo tɨ zoco tu. ");
INSERT INTO mihNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tacuan i cahan ra Jesús sihin ñiyɨvɨ. Ta i sityiño ra cuaha xaan cuhva tañi cuhva ya. Tandɨhɨ ñaa sa cuu cuɨñɨ ñu, i cahan ra sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ta ma cahan maa ra tatu ma cahan ra zɨquɨ minoo cuhva. Ta cuee ca ta i nacatyi casi ra sihin ñiyɨvɨ ndyico sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Zuun ñi quɨvɨ cuan ta sa tyahan i catyi ra Jesús sihin ra i casi ra: Coho yo inga siyo miñi. ");
INSERT INTO mihNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ta i zandoo ra sii ñiyɨvɨ cuan, ta cuahan ra Jesús sihin ra i casi ra sisi barco sa ñoho ra. Ta cuahan uu a uñi tahan ca barco sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ta i quisaha minoo tatyi cahnu xaan. Ta i quisaha quɨhvɨ ndutya sisi barco cuan. Ta zuhva zuhva ñi cua cutu tu. ");
INSERT INTO mihNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ta ra Jesús quixi ra ityi zuhma barco. Ñoho minoo zahma xiñi ra. Ta i zandoyo ra i casi ra sii ra. Ta catyi ra sihin ra: Maestro, ¿ñacu ña cohon ta sa cuñi cunaa yo? ");
INSERT INTO mihNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ta i nduvita ra Jesús, ta i cahan ra sihin tatyi: ¡Taxi ñi! Ta i catyi ra sihin ndutya: ¡Ma ndyayu con! Ta taxi cuii ñi i nduu tatyi. Ta tacuan tucu ndutya. ");
INSERT INTO mihNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ta zɨquɨ i catyi ra Jesús sihin ra i casi ra: ¿Ñacu yuhu xaan ndo? ¿Ñacu ña nɨɨ iñi ndo? ");
INSERT INTO mihNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ta iyo xaan i cuñi ra i casi ra. Ta i natuhun tahan ra, ta catyi ra: ¿Ñaa ra cuu ra ya vatyi cuhva ndya tatyi ta cuhva ndya ndutya ta tyaa si yahvi sii ra? ");
INSERT INTO mihNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","I saa ra inga siyo miñi nu cu si Gadara, ");
INSERT INTO mihNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ta i quita ra Jesús barco cuan. Ta i quisi minoo ra iyo nu ñaña. Ñoho tatyi cuihna sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ndyaa maa ra nu ñaña, ta yoñi maa cuu cuhñi sii ra numaa sihin cadena. ");
INSERT INTO mihNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Cuaha xaan saha i sihñi ñiyɨvɨ saha ra ta ndaha ra sihin cadena, zoco tandɨhɨ saha sahnu ndyihi ra sii si. Ta ñá cuu zandumazu ñiyɨvɨ sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ndyiyaca ta ñiyaca ndɨhvɨ noo ra yucu ta nu ñaña. Sacu saa ra, ta sahndya ra sii ra sihin yuu. ");
INSERT INTO mihNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","I ndyehe ra sii ra Jesús sica ca. Ta i cacono ra. Ta i sicuɨñɨ sɨtɨ ra nu vasi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Saa xaan i cahan ra, ta catyi ra: ¿Ñaa sa cuñun sihin mi, Jesús? Moo cuu zehe ra Ndyoo, ra cahnu ca. Sa ndyoo ñi ma zandyehun tundoho sii. ");
INSERT INTO mihNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tacuan i catyi ra vatyi sa catyi ra Jesús: Yoho tatyi cuihna, quita sii ra ya. ");
INSERT INTO mihNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ta zɨquɨ i ndaca tuhun ra Jesús sii tatyi cuihna cuan, ta catyi ra: ¿Ñaa nañi moo? Ta i catyi si: Nañi Legión vatyi cuaha xaan ndi iyo. ");
INSERT INTO mihNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ta i cahan ndahvi xaan si sihin ra Jesús sa ma tava ra sii si ta cuhun si ndya vaha ñi. ");
INSERT INTO mihNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ta yatyi ñi yucu cuan siyucu cuaha xaan quɨnɨ. Nanducu tɨ sa casi tɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ta i quisaha cahan ndahvi tandɨhɨ tatyi cuihna cuan. Ta catyi si sihin ra Jesús: Tasun sii ndi nu yucu quɨnɨ cuan. Ta cua quɨhvɨ ndi sisi tɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","I catyi ra Jesús sihin si vatyi cuu. Ta zɨquɨ i quita tandɨhɨ tatyi cuihna cuan sii rayɨɨ cuan, ta i quɨhvɨ si sisi quɨnɨ cuan. Ta tandɨhɨ sa uu mil quɨnɨ cuan, i sino tɨ nu iñi noo yuhu miñi. Ta i sihi tandɨhɨ tɨ sisi ndutya. ");
INSERT INTO mihNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tacuan ta iyo xaan i cuñi ra zacuenda quɨnɨ cuan. I sino xaan ra. Sahan ra nacahnu sa nacatyi ra sihin ñiyɨvɨ. Ta i quisi ndyehe ñiyɨvɨ ñaa sa cuu. ");
INSERT INTO mihNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","I saa ñu nu ndyaa ra Jesús, ta i ndyehe ñu sii ra i siñoho tatyi cuihna cuan. Sa ndyaa ra taxi ñi. Ñoho ra zahma ra, ta sa nduvaha cuñi xiñi ra. Ta i yuhu xaan ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ta ra i ndyehe cuan, i nacatyi ra sihin ñiyɨvɨ cuhva i tahan ra i ñoho tatyi cuihna sii cuan ta cuhva i tahan quɨnɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ta zɨquɨ i catyi ñu sihin ra Jesús sa ndyoo ñi naquita ra ñuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tacuan ta i quɨhvɨ ra Jesús sisi barco. Ta i quisaha cahan ndyoo ra siñoho tatyi cuihna sii cuan sihin ra Jesús vatyi cuñi ra cuhun ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Zoco ñá saha ra Jesús sa cuhun ra. I catyi ra: Cuahan ndya vehun nu iyo ñiyɨvɨ suun. Ta nacatyun sihin ñu tandɨhɨ cuhva i tyindyee ra Ndyoo suun. Ta yozo caa i cundahvi iñi ra suun. ");
INSERT INTO mihNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ta cuahan ra cuan. Ta i nacatyi ra sihin tandɨhɨ ñiyɨvɨ tandɨhɨ ñuu nu cu si Decápolis tandɨhɨ sa i zavaha ra Jesús sihin ra. Ta iyo xaan i cuñi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Saa tucu ra Jesús sihin ra i casi ra inga siyo miñi. Ta cuaha xaan ñiyɨvɨ i titahan yuhu miñi nu i saa ra. ");
INSERT INTO mihNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ta i quisi minoo ra cu tyiño vehe ñuhu. Jairo nañi ra. Ta cuhva sa ndyehe ra sii ra Jesús i sicuɨñɨ sɨtɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ta i quisaha sacu ndahvi ra nuu ra Jesús ta catyi ra: Sa cuñi cuu cuii ña luhlu zehi. Coho ta tyizon ndohon sii ña. Ta cua nduvaha ña, ta ma cuu ña. ");
INSERT INTO mihNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tacuan ta cuahan ra Jesús sihin ra. Ta i sindyico tuu xaan ñiyɨvɨ sii ra. Ñihi xaan i catyihi ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ta tɨcuɨ ñiyɨvɨ cuan ñoho minoo ñaha cuhu. Sa usi uu cuiya sa cuhu ña cuehe sa cuu ña nɨñɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sa cuaha xaan tundoho ndyehe ña. Cuaha xaan médico i zacuu tata sii ña. I zanaa ña tandɨhɨ cuii sa iyo sii ña. Zoco ñá nduvaha ña. Xaan ca i nduu cuehe cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ta sa i siñi ña sa cahan ñiyɨvɨ tuhun ra Jesús, i quisi ña ityi sata ra zava mahñu ñiyɨvɨ cuan, ta i tɨɨn ña yuzahma ra. ");
INSERT INTO mihNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Vatyi i sica iñi ña: “Vazu zahma ñi ra cua tɨin, ta nduvehi.” ");
INSERT INTO mihNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ta zuun ñi caa cuhva cuan i sicuita nɨñɨ ña. Ta i sito ña vatyi sa nduvaha ña sihin tundoho sa i tahan ña. ");
INSERT INTO mihNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ta yatyi xaan i sito ra Jesús sa i quita zuhva tundyee iñi sii ra. I nandyehe ra siconduu nu yucu ñiyɨvɨ cuan. Ta i catyi ra: ¿Yoo cuu sa tɨɨn zahme? ");
INSERT INTO mihNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ta i catyi ra i casi ra sihin ra: ¿Atu ña siton vatyi tuu xaan ñiyɨvɨ cuahan suhun? ¿Ta yozo caa cuu ndaca tuhun yoo sa tɨɨn zahmon? ");
INSERT INTO mihNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ta ra Jesús i nandyehe ra siconduu nu yucu ñiyɨvɨ cuan vatyi cua ndyehe ra yoo sa i tɨɨn sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yuhu xaan ñaha cuan ndya cuhva nɨhɨ ñi ca ña vatyi sito ña ñaa sa cuu sa tahan ña. I quisi ña, ta i sicuɨñɨ sɨtɨ ña nuu ra Jesús. Ta i nacatyi ña sihin ra tandɨhɨ cuii. ");
INSERT INTO mihNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ta i catyi ra Jesús sihin ña: Zihi, i nduvohon vatyi i sino iñun sii. Cuahan vityi, ta ma caca ca iñun vatyi sa nduvohon sihin tundoho i tohon. ");
INSERT INTO mihNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ta zuun ñi caa cuhva sa cahan ra Jesús sihin ñaha cuan, ta i quisi cahan ñiyɨvɨ sihin ra cu tyiño vehe ñuhu. Ta catyi ñu: Sa sihi zehun. Ma zayanga con sii ra Maestro ya. ");
INSERT INTO mihNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ta i siñi ra Jesús sa cahan ñu. Ta i catyi ra sihin ra cu tyiño: Ma yuhun. Sino iñun. ");
INSERT INTO mihNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta ñá saha ca ra Jesús sa cuhun cuaha xaan ñiyɨvɨ sihin ra. Ra Pedro ñi sihin ra Jacobo ta ra Juan, yañi ra Jacobo, cuahan sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ta sa cua saa ra Jesús vehe ra cu tyiño cuan, i siñi ra sa cuvaa xaan ñiyɨvɨ. Sacu ñu. Ta sacu saa ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","I quɨhvɨ ra sisi vehe, ta i catyi ra: ¿Ñacu cuvaa xaan ndo ta sacu xaan ndo? Ñá sihi ña luhlu ya. Quixi ña. ");
INSERT INTO mihNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Zoco i sacu ndyaa ñiyɨvɨ sii ra. Tacuan ta i tava ra Jesús sii tandɨhɨ ñu. Ta i quihin ra zutu ña ta zɨhɨ ña luhlu cuan, ta ra i quisi sihin ra ndya nu candyaa ña luhlu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","I tɨɨn ra ndaha ña, ta i cahan ra sihin zahan maa ra: Talita, cumi. Tuhun cuan cuñi si catyi si: Ñaha luhlu, catyi suhun vatyi nduviton. Nacuɨñɨ ndyaa. ");
INSERT INTO mihNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Zuun ñi caa cuhva cuan i nduvita ña luhlu sa iyo usi uu cuiya cuan. Ta ndaha nacaca ña. Ta iyo xaan i cuñi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ñihi xaan i saha ra Jesús tyiño sii ñu sa ma nacatyi ñu nu sihin minoo ñiyɨvɨ. Ta i catyi ra vatyi cuhva ñu sa casi ña luhlu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","I quita ra Jesús ñuu cuan, ta cuahan ra ndya ñuu ra. Ta cuahan ra i casi ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ta tahan si quɨvɨ quitatu ñiyɨvɨ. I sahan ra vehe ñuhu, ta i zacuaha ra sii cuaha xaan ñiyɨvɨ. Ta iyo xaan i cuñi ñu, ta catyi ñu: ¿Ndyamaa i cutuhva ra ya tuhun ya? ¿Yozo caa i ñihi ra cuhva sa casi xaan iñi ra? ¿Yozo caa ñihi ra cuhva zavaha ra sa ndyityi? ");
INSERT INTO mihNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Atu yɨvɨ ra ya cuu ra cu carpintero, zehe ña María, ta yañi ra Jacobo, ra José, ra Judas ta ra Simón? Ta cuhva ra iyo ñu ihya sihin yo, ndɨhɨ ca. Tacuan i catyi ñu. Ta yucuan cuenda ñá tyaa ca ñu yahvi sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ta i catyi ra Jesús sihin ñu: Tyaa ñiyɨvɨ inga ñuu yahvi sii minoo ra profeta, zoco ndya ñuu ra, ndya vehe ra, nu ndyaa ñiyɨvɨ sii ra, ña tyaa ñu yahvi sii ra. Tacuan i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ta yucuan cuenda ñá zavaha ra Jesús cuaha xaan sa ndyityi tañi i zavaha ra inga ñuu. I tyizo ra ndaha ra zɨquɨ zuhva ñi ñiyɨvɨ cuhu, ta i zanduvaha ra sii ñu. Ta tacuan ñi. ");
INSERT INTO mihNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ta iyo xaan i cuñi ra vatyi ñá sino iñi ñu sii ra. Ta cuahan ra tandɨhɨ inga ñuu yucuan. Ta i zacuaha ra sii ñiyɨvɨ yucuan. ");
INSERT INTO mihNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","I cana ra Jesús sii sa usi uu tahan ra i casi ra vatyi cuñi ra sa cua tasi ra uu uu ra. Ta i saha ra cuhva sii ra, cuhva sa tava ra tatyi cuihna sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ta i catyi ra sihin ra vatyi ñahñi maa cua cuizo ra sa casi ra ityi. Minoo tuhun ñi tutatu cuñaa ra. Ta ñahñi ca sa cuizo ra nu yono ta nu xita ta nu xuhun. ");
INSERT INTO mihNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ndisa ndahvi ñi cundyaa saha ra. Minoo tuhun ñi camisa quɨhɨ ra, ta ma cuu sa uu tahan. ");
INSERT INTO mihNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ta i catyi ra Jesús sihin ra: Tatu saha ñiyɨvɨ minoo vehe cundyaa ndo, yucuan ñi ndoo ndo ndya cua cuhun ndo inga ñuu. ");
INSERT INTO mihNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tatu saa ndo minoo ñuu ta ña cuñi ñiyɨvɨ sii ndo ta ña tyizoho ñu sa cahan ndo, quita ndo ñuu cuan. Naquɨzɨ ndo saha ndo vatyi ma cuhun nu ñiyaca sii ñuu cuan sihin ndo. Tacuan ta cua coto ñiyɨvɨ vatyi i zavaha ñu sa ña vaha sihin ndo. Ñihi xaan cua coo tundoho sii ñiyɨvɨ ñuu Sodoma ta ñiyɨvɨ ñuu Gomorra quɨvɨ cua tasi tuñi ra Ndyoo sii ñiyɨvɨ, zoco ñihi xaan ca cua coo tundoho sii ñiyɨvɨ ña cuñi tɨɨn cuenda sii ndo. Tacuan i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ta zɨquɨ cuahan ra, ta i zacoto ra sii ñiyɨvɨ vatyi nazandoo ñu cuatyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ta i tava xaan ra tatyi cuihna sii ñiyɨvɨ. Ta i natyihi ra azetye sii cuaha xaan ñiyɨvɨ cuhu, ta i zanduvaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ta i sito ra rey Herodes, ra ndyaca ñaha yucuan, cuhva cuan vatyi i cahan tandɨhɨ ñiyɨvɨ tandɨhɨ sa i zavaha ra Jesús. Ta i sica iñi ra Herodes: Ra Juan, ra i zacoo ndutya cuan, cuu ra. I nandoto ra, ta yucuan cuenda ndyityi xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ta i catyi tucu inga ñiyɨvɨ: Ra Elías cuu ra. Ta inga ñiyɨvɨ i catyi: Minoo ra profeta cuu ra tañi ra profeta sicoo ta sa naha. ");
INSERT INTO mihNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ta sa siñi ra Herodes cuhva cuan, ta i catyi ra: Ra Juan cuu ra, ta i nandoto ra. Ta yuhvi i tave tyiño sii ra sahndya yuu zucu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Vatyi zuun ñi ra Herodes i tava tyiño sii ñiyɨvɨ sa tyihi sii ra Juan vehe caa. Ta i sihñi ra sii ra sihin cadena sa cuenda ña Herodías. Ta ña Herodías cuan i cuu ñazɨhɨ ra Felipe yañi ra Herodes. Zoco i quihin ra Herodes sii ña sa cuu ñazɨhɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ta ra Juan i catyi ra sihin ra Herodes: Ña vaha cua cuhun ñazɨhɨ yañun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Xaan xaan i nduu ña Herodías sihin ra Juan. Ta cuñi ña sa cahñi ña sii ra. Zoco ñá cuu ");
INSERT INTO mihNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","vatyi yuhu ra Herodes sii ra Juan vatyi sito ra vatyi ñiyɨvɨ vaha cuu ra Juan. Ta ñahñi cuatyi i zacuu ra. Ta yucuan cuenda ñá saha ra sa zavaha ña maña sii ra. Ta vazu ñá cutuñi iñi ra Herodes cuaha xaan sa cahan ra Juan, zoco i tahan iñi ra tyizoho ra sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ta ña Herodías i ñihi ña minoo cuhva quɨvɨ i nandusi cuiya ra Herodes. I saha ra sa cuxiñi tandɨhɨ ra ndyizo tyiño ra, sihin ra cu nuu sii zandaru, ta sihin tandɨhɨ ra nahnu nu cu si Galilea. ");
INSERT INTO mihNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ta i quɨhvɨ ña yoco zehe ña Herodías nu siyucu ra. Ta i sata saha maa tuhun ñi ña. Ta tahan xaan iñi ra Herodes sihin tandɨhɨ ra yucu sihin ra. Ta i catyi ra Herodes sihin ña: Caca moo ñaa sa cuñun, ta cua cuhve sii si suun. ");
INSERT INTO mihNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ta i tyiñaha ra Ndyoo ta catyi ra sa ndisa cuii vatyi cua cuhva ra ñaa sa cua caca ña vazu zava cuii ñuu ndyaca ñaha ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","I quita ña, ta i catyi ña sihin zɨhɨ ña: ¿Ñaa sa cua caque? Ta i catyi zɨhɨ ña: Cacon xiñi ra Juan, ra zacoo ndutya. ");
INSERT INTO mihNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ta ta sica cuii ñi i ndɨhvɨ ña nu ndyaa ra Herodes, ta i catyi ña: Cuñi vityi vityi ñi xiñi ra Juan, ra i zacoo ndutya sihin minoo nu coho. ");
INSERT INTO mihNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ta i nducuihya xaan iñi ra Herodes, zoco sa tyiñaha ra Ndyoo, ta sa siñi tandɨhɨ ñiyɨvɨ. Ta yucuan cuenda ñá cuñi ra catyi ra sa ma cuhva ra sa sica ña. ");
INSERT INTO mihNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Zuun ñi caa cuhva cuan i tasi ra minoo zandaru cua quihin xiñi ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sahan zandaru cuan vehe caa, ta i sahndya ra zucu ra Juan, ta i quihin ra xiñi ra. Ta i quisi ndyaca ra sii si sihin minoo nu coho, ta i saha ra sii si sii ña yoco cuan. Ta i saha maa ña sii si sii zɨhɨ ña. ");
INSERT INTO mihNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ta sa i sito ñiyɨvɨ ndyico sii ra Juan vatyi sa i sihi ra, ta i sinaquihin ñu sii coño ñuhu ra. Ta i tyihi ñu sii si si ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tacuan ta zɨquɨ i titahan tucu ra i casi ra Jesús. Ta i nacatyi ra sihin ra tandɨhɨ sa i zavaha ra ta tandɨhɨ sa i zacuaha ra sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ta i catyi ra Jesús sihin ra: Coho yo; cua quitatu yo nu yoñi maa ñiyɨvɨ iyo. Tacuan i catyi ra vatyi tuu xaan ñiyɨvɨ i quisi. Ta tuu xaan ñu ndyico sii ra. Ta nu sa casi ra xita ta ñá cuyatyi ca ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tacuan ta cuahan ra Jesús sihin ra i casi ra sihin minoo barco ndya minoo nu yoñi maa ñiyɨvɨ iyo. ");
INSERT INTO mihNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Zoco i ndyehe ñiyɨvɨ sa cuahan ra. Ta i nacoto ñu sii ra Jesús. Tandɨhɨ ñuu i quita ñu. Ta i sino ñu. Ta yatyi ca i saa ñu ta zɨquɨ maa ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","I quita ra Jesús barco cuan, ta i cundahvi xaan iñi ra sii ñu vatyi tañi mvee ticatyi sa yoñi sitoho i cuu ñu. Ta i quisaha zacuaha ra sii ñu cuaha xaan cuhva. ");
INSERT INTO mihNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ta cuhva sa cua iñi i quisi ra i casi ra nu ndyaa ra, ta i catyi ra sihin ra: Sahiñi xaan. Ta yoñi ñiyɨvɨ iyo ihya. ");
INSERT INTO mihNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Catyun sihin ñiyɨvɨ nacuhun ñu tandɨhɨ ñuu, tandɨhɨ cuadria, cua zata ñu sa casi ñu vatyi ña ndyizo ñu sa casi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ta i nacahan ra Jesús, ta catyi ra: Cuhva maa ndo sa casi ñu. Ta i catyi ra sihin ra Jesús: Ma cuu zata maa ndi oco mil pan ta cuhva ndi casi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tacuan ta i ndaca tuhun ra Jesús sii ra ta catyi ra: ¿Yozo tahan pan ndyizo ñiyɨvɨ? Cua ndyehe xihna ndo. Ta sa sito ra i catyi ra: Ohon tahan pan, ta uu tahan tyiyaca. ");
INSERT INTO mihNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ta zɨquɨ i catyi ra Jesús vatyi nacundyaa ñiyɨvɨ ɨɨn ɨɨn ityi ñu nu itya. ");
INSERT INTO mihNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ta i sicundyaa ñu ɨɨn ɨɨn ityi ñu. Ziendu ñu a uu xico usi ñu sa minoo minoo ityi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tacuan ta i quihin ra Jesús sa ohon tahan pan cuan ta uu tahan tyiyaca cuan. Ta i nandyehe ndaa ra ityi andɨvɨ, ta i nacuhva ra tyahvi ndyoo sii ra Ndyoo Zutu ra. Ta i sahnu ndyihi ra pan cuan. Ta i saha ra sii si sii ra i casi ra vatyi cua zasa ra sii si sii ñiyɨvɨ. Ta tacuan tucu sa uu tahan tyiyaca cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tandɨhɨ ñiyɨvɨ cuan i sasi, ta i ndaha xaan iñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ta i zacutu ñu usi uu tahan tyica sihin sa nandoo yuhu pan cuan ta tyiyaca cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ohon mil sa maa rayɨɨ ñi ta zɨɨn ñu zɨhɨ ta sa ndyihi sasi ñu, ndɨhɨ ca. ");
INSERT INTO mihNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tacuan ta zɨquɨ i catyi ra Jesús sihin ra i casi ra vatyi nandɨhvɨ ra barco vatyi cua yaha ra inga siyo miñi ndya ñuu Betsaida. Ta ra Jesús cua catyi ra sihin tandɨhɨ ñiyɨvɨ cuan vatyi cunuhu ñu ndya ñuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ta sa natasi ra Jesús sii ñu ndya ñuu ñu, ta i sahan ra minoo yucu vatyi cua cahan ra sihin ra Ndyoo Zutu ra, ra iyo andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ta cuhva sa i cuaa i saa barco ñoho ra i casi ra zava mahñu miñi, ta ra Jesús i nandoo maa tuhun ñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ta zɨquɨ i ndyehe ra Jesús vatyi yɨɨ xaan i zacaca ra barco vatyi ñihi xaan quiñi ndaha tatyi sii barco cuan. Ta ñaa ca cuan i tuhva ra Jesús nu yucu ra. Sica ra nu ndutya. Ta i cuñi ra Jesús yaha ra nu yucu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ta i ndyehe ra vatyi sica ra Jesús nu ndutya, ta sica iñi ra vatyi minoo añima cuu ra. Ta i sacu saa ra ");
INSERT INTO mihNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","vatyi tandɨhɨ ra i ndyehe sii ra. Ta i yuhu xaan ra. Ta i cahan ra Jesús sihin ra, ta catyi ra: Zandyee ndo iñi ndo. Yuhvi cui. Ma yuhu ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ta i quɨhvɨ ra Jesús sisi barco, ta i sicuita tatyi. Ta iyo xaan i cuñi ra i casi ra Jesús ");
INSERT INTO mihNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","vatyi tañaha ca cutuñi vaha iñi ra vatyi cahnu xaan cuu cuhva iyo sii ra Jesús vazu sa ndyehe ra sa ndyityi i zavaha ra. ");
INSERT INTO mihNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","I yaha zava ra sihin ra i casi ra nu miñi cuan. Ta i saa ra nu cu si Genesaret. Ta i sihñi ra barco cuan yuhu miñi. ");
INSERT INTO mihNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","I quita ra barco cuan, ta yatyi xaan i nacoto ñiyɨvɨ sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ta i sino xaan ñiyɨvɨ nacahnu ityi cuan, ta i quisaha quisi ndyaca ñu sii ñiyɨvɨ cuhu sihin nu sito ndya nu ndyaa ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ta tandɨhɨ nu cuahan ra vazu ñuu nahnu a ñuu ndyihi a sicuhu, i saqui ñiyɨvɨ sii ñu cuhu ityi. Ta i cahan ndyoo ñu sihin ra Jesús vatyi natɨɨn ñiyɨvɨ cuhu sii ra vazu yuzahma ra. Ta tandɨhɨ ñu i tɨɨn sii ra, i nduvaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ra maestro cuenda ley, ra i quisi ityi ñuu Jerusalén sihin ra fariseo, i tuhva ra nu nandyaa ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Sa i ndyehe ra vatyi ra i casi ra Jesús ña tuhva ra nacatya vaha ndaha ra sa sasi ra xita tañi iyo costumbre ñiyɨvɨ hebreo. Ta yucuan cuenda i cahan ra ndya vaha ñi sii ra vatyi ñá zavaha ra costumbre iyo yucuan. ");
INSERT INTO mihNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ta ra fariseo sihin tandɨhɨ ñiyɨvɨ hebreo ña zaña ñu costumbre sa ndoo vaha xaan ndaha ñu ta casi ñu xita vatyi tacuan i zacuaha ñiyɨvɨ sahnu sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ta sa nasaa ñu sa sahan ñu nuyahvi, ma casi ñu tatu ma nandaha vaha xaan ñu. Ta iyo cuaha xaan ca costumbre sii ñu. Nacatya ñu tasa, ta quɨzɨ, ta caa sa tuhva ñu cutyiño ta cuhva ndya sito ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tacuan ta i ndaca tuhun ra fariseo ta ra maestro cuenda ley ta catyi ra: ¿Ñaa cuenda ña zavaha ñiyɨvɨ ndyico suun costumbre sa i zavaha ñiyɨvɨ sahnu vatyi ña nacatya vaha ñu ndaha ñu ta casi ñu? ");
INSERT INTO mihNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ta i catyi ra Jesús sihin ra: Vaha xaan i cahan ra Isaías cuhva iyo maa ndo vatyi zaha ndo tuhun vatyi vaha xaan ndo, zoco ña ndisa. Ta tacuan i tyaa ra Isaías ta sa naha. I catyi ra vatyi i catyi maa ra Ndyoo tyehen: Ihya ñiyɨvɨ zacahnu ñu sii, sihin yuhu ñu. Zoco ña zacahnu ñu sii, sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Zacuaha ñu sii ñiyɨvɨ maa maa costumbre ñiyɨvɨ ñi. Ta ña zavaha ñu cuhva catyi Tuhun Ndyoo sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ta i catyi tucu ra Jesús sihin ra: Maa ndo i zandoo ley ra Ndyoo vatyi cua cundyico ndo costumbre ñiyɨvɨ, tañi sa nacatya xaan ndo quɨzɨ ndo ta tasa ndo ta inga cuhva sa tacuan. ");
INSERT INTO mihNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tyaa siyo xaan ndo sa catyi Tuhun Ndyoo vatyi cuñi ndo zacahnu ndo costumbre ñiyɨvɨ sahnu. ");
INSERT INTO mihNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ihya cuu cuhva i tyaa ra Moisés: “Zacahnu ndo sii zutu ndo ta sii zɨhɨ ndo.” Ta “Yoo ra cahan sa quiñi sii zɨhɨ ra a sii zutu ra, nacahñi ñiyɨvɨ sii ra.” ");
INSERT INTO mihNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Zoco maa ndo catyi vatyi cuu catyi minoo ñiyɨvɨ sihin zutu ra a sihin zɨhɨ ra: “Ma cuu tyindyei suun vatyi tandɨhɨ ndaha tyiñe corbán cuu si.” (Tuhun corbán cuan cuñi si catyi si vatyi sii ra Ndyoo cuu.) ");
INSERT INTO mihNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tatu tacuan cahan minoo ñiyɨvɨ, maa ndo catyi ndo vatyi ma cuu tyindyee ca ra sii zutu ra a sii zɨhɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tacuan cuu cuhva zanduluhlu ndo tuhun cahan ra Ndyoo vatyi cuñi ndo zanducahnu ndo costumbre ndo. Ta cuaha xaan ca cuhva sa tacuan ndyicuu ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ta i cana tucu ra Jesús sii ñiyɨvɨ ta catyi ra sihin ñu: Tyizoho tandɨhɨ ndo, ta tyituñi vaha iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yɨvɨ sa sasi ñiyɨvɨ ta yɨvɨ sa sihi ñu cuu sa zatɨvɨ añima ñu. Zoco sa quiñi sica iñi ñu cuu sa zatɨvɨ añima ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tatu siñi ndo, cuɨñɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ta sa zandoo ra Jesús sii ñiyɨvɨ cuan, ta i quɨhvɨ ra minoo vehe. Ta ra i casi ra, i ndaca tuhun ra sii ra: ¿Ñaa cuñi si catyi si cuhva cuan? ");
INSERT INTO mihNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ta i catyi ra Jesús sihin ra: ¿Atu ña siñi tucu maa ndo vatyi yɨvɨ sa sasi ñiyɨvɨ ta yɨvɨ sa sihi ñu cuu sa zatɨvɨ añima ñu? ");
INSERT INTO mihNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Vatyi yɨvɨ añima ñu quɨhvɨ si. Quɨhvɨ si sisi sɨtɨ cahnu ñu ta zɨquɨ quita si. Tacuan i catyi ra vatyi ñahñi sa ica iyo sa ma cuu casi ñiyɨvɨ. Cuu casi ñiyɨvɨ ñaa sa cuñi maa ñu. Ta yɨvɨ cuatyi cuu si. ");
INSERT INTO mihNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ta i catyi tucu ra: Sa quiñi sica iñi ñiyɨvɨ, yucuan cuu sa zatɨvɨ añima ñu. Ta yucuan cuu cuhva cua coo cuatyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Vatyi añima ñiyɨvɨ quita tandɨhɨ sa sica iñi ñu, sa quiñi zavaha ñu, sa nama minoo rayɨɨ ñazɨhɨ inga ra, a sa coo cuaha xaan ñaha ra, a sa cahñi ra sii inga ñiyɨvɨ, ");
INSERT INTO mihNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sa zuhu yo, sa cucuihna iñi yo sa cuenda ndaha tyiño inga ñiyɨvɨ, tandɨhɨ sa quiñi zavaha yo, sa zandavi ñaha yo, sa cuxi xaan iyo yo, sa cuihna iñi yo, sa vatya yo, sa cahnu xaan zaha yo sii yo ta sa ña zavaha yo sa vaha. ");
INSERT INTO mihNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tandɨhɨ cuii cuhva quiñi ya, quita si añima ñiyɨvɨ, ta zatɨvɨ si sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","I quita ra Jesús yucuan, ta cuahan ra ndya ñuu Tiro ta ñuu Sidón. I quɨhvɨ ra minoo vehe vatyi cuñi ra sa ma coto ñiyɨvɨ sa i saa ra. Zoco ñá cuu. ");
INSERT INTO mihNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yatyi xaan i sito zɨhɨ minoo ñaha luhlu sa ñoho tatyi cuihna sii. Ta i quisi ña nu ndyaa ra Jesús. Ta i sicuɨñɨ sɨtɨ ña saha ra. ");
INSERT INTO mihNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ta ñaha cuan i cacu ña ñuu Sirofenicia. Ta yɨvɨ ñiyɨvɨ hebreo cuu ña. Ta i sica ña tumañi iñi sii ra Jesús sa tava ra tatyi cuihna sa ñoho sii zehe ña. ");
INSERT INTO mihNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Zoco i cahan ra Jesús minoo cuhva sihin ña, ta i catyi ra: Natyindyee xihne sii ñiyɨvɨ ñui vatyi ña vaha quihin mi sa cua casi sa ndyihi ta cuhve casi ina sii si. ");
INSERT INTO mihNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ta i catyi maa ña: Ndisa, tata, zoco tañi ina lee cui vatyi cua casi vazu yuxita zanacoyo sa ndyihi. Yucuan cuenda tyindyeun sii, zuhva. ");
INSERT INTO mihNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tacuan ta i catyi ra Jesús: Vaha cohon. Sa cuu cuhun. Sa quita tatyi cuihna sii zehun. ");
INSERT INTO mihNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ta sa nasaa ña vehe ña, ta i ndyehe ña sii zehe ña nu sito, ta sa quita tatyi cuihna sii ña. ");
INSERT INTO mihNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","I quita ra Jesús ñuu Tiro ta cuahan ra ndya Sidón ta ndya tandɨhɨ ñuu ndyihi nu cu si Decápolis. Ta i saa ra yumiñi Galilea. ");
INSERT INTO mihNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ta i quisi ndyaca ñiyɨvɨ sii minoo ra zoho ta ñehe ra. Ta i sica ñu tumañi iñi sa cua tyizo ra Jesús ndaha ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ta i quihin ra Jesús sii ra, ta i tuhva ra sihin ra ndya zava. I zanandoo noo ra sii ñiyɨvɨ. Ta i tyihi ra Jesús nu ndaha ra nduu siyo zoho ra zoho cuan. Ta zɨquɨ i tyaa ra Jesús zɨɨ ra nu ndaha ra, ta i tɨɨn ra yaa ra ñehe cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ta i nandyehe ndaa ra Jesús ityi zɨquɨ, ta i sinoo ra, ta i catyi ra sihin tuhun maa ra: ¡Efata! Tuhun cuan, cuñi si catyi si: ¡Nanuña! ");
INSERT INTO mihNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ta zuun ñi caa cuhva cuan i nuña zoho ra. Ta ndaha nacahan vaha ra. ");
INSERT INTO mihNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ta i ndisi tucu ra Jesús nu yucu ñiyɨvɨ. Ta i catyi ra sihin ñu vatyi ma nacatyi ñu nu sihin minoo ñiyɨvɨ. Zoco sa ñihi ca catyi ra Jesús sihin ñu, cuaha ca nacatyi ñu sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ta iyo xaan i cuñi ñiyɨvɨ, ta i catyi ñu: Tandɨhɨ cuii sa vaha zavaha ra Jesús cuhva ndya nacuɨñɨ ra zoho, ta nacahan ra ñehe. ");
INSERT INTO mihNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ta quɨvɨ cuan i tuhva cuaha xaan ñiyɨvɨ. Ta ñahñi maa sa casi ñu. Ta i catyi ra Jesús sihin ra i casi ra: ");
INSERT INTO mihNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Cundahvi xaan iñi sii ñiyɨvɨ ya vatyi sa iyo uñi quɨvɨ sa yucu ñu sihin, ta ñahñi maa sa casi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tatu natasi sii ñu cunuhu ñu vehe ñu ta ma casi ñu, coto cuañaa ñu ityi cuhun ñu vatyi sica xaan i quisi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ta i catyi ra i casi ra Jesús sihin ra: ¿Ndya ityi cua quihin yo sa casi ñu ya sicuhu ya? Ta yoñi ñiyɨvɨ iyo ihya. ");
INSERT INTO mihNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ta i ndaca tuhun ra Jesús sii ra: ¿Yozo tahan pan ndyizo ndo? Ta i catyi ra: Usa tahan. ");
INSERT INTO mihNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tacuan ta i catyi ra Jesús vatyi nacundyaa ñiyɨvɨ cuan nu ñuhu. Ta i quihin ra sa usa tahan pan cuan, ta i saha ra tyahvi ndyoo sii ra Ndyoo. Ta i sahnu ndyihi ra pan cuan. Ta i saha ra sii ra i casi ra. Ta ra yucuan saha sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ta ndyizo ñiyɨvɨ cuan zuhva tyiyaca ndyihi. Ta i saha tucu ra Jesús tyahvi ndyoo sii ra Ndyoo sa cuenda tɨ. Ta i saha ra sii ra i casi ra. Ta i zasa ra sii si sii ñiyɨvɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sasi ñu, ta i ndaha xaan iñi ñu, ta zɨquɨ i zacutu ñu usa tahan tyica sihin sa nandoo cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ta sa i sasi tañi cumi mil ñiyɨvɨ ta zɨquɨ i natasi ra Jesús sii ñu ndya vehe ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ta i ndɨhvɨ ra barco sihin ra i casi ra, ta cuahan ra ndya nu cu si Dalmanuta. ");
INSERT INTO mihNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tacuan ta zɨquɨ i quisi ra fariseo, ta i quisaha natuhun tahan ra sihin ra Jesús. Cuñi ra ndyehe ra minoo sa ndyityi tañi zavaha ra Ndyoo vatyi cuñi ra coto ra atu ndisa i tasi ra Ndyoo sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ta ra Jesús i sinoo xaan ra. Ta i catyi ra: ¿Ñacu sica xaan ñiyɨvɨ sa ndyehe ñu sa ndyityi? Catyi vatyi ma zavehi minoo sa ndyityi sa ndyehe ñi maa ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ta i zandoo ra Jesús sii ra fariseo. Ta i nandɨhvɨ tucu ra barco, ta cuahan ra inga siyo miñi cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","I naa iñi ra i casi ra Jesús sa casi ra ta sa cuahan ra sihin barco cuan. Minoo ñi pan ndyizo ra. ");
INSERT INTO mihNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ta i catyi ra Jesús sihin ra: Ndyehe ndo, zacuenda ndo sii ndo sihin yusa i siya ra fariseo ta ra Herodes. ");
INSERT INTO mihNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ta i natuhun tahan ra i casi ra Jesús, ta i catyi ra: Cahan ra tacuan vatyi ñahñi pan ndyizo yo. Tacuan i sica iñi ra cuan vatyi ñá cutuñi iñi ra tuhun i cahan ra Jesús sa cuenda yusa i siya cuan. Ñá cutuñi iñi ra vatyi cahan ra Jesús minoo cuhva vatyi cua zacuenda ra sii ra sihin cuhva zacuaha ra fariseo ta ra Herodes. ");
INSERT INTO mihNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","I sito ra Jesús sa natuhun tahan ra, ta i catyi ra: ¿Ñacu sica xaan iñi ndo sa ña ndyizo ndo pan? ¿Atu ña cutuñi iñi ndo? ¿Atu tañaha ca ñihi ndo cuhva? ");
INSERT INTO mihNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Atu ña ndyehe ndo sihin sɨtɨ nuu ndo, ta ña siñi ndo sihin zoho ndo? ¿Atu ña nacohon iñi ndo? ");
INSERT INTO mihNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Quɨvɨ i sehi sa ohon tahan pan i sasi ohon mil rayɨɨ, ¿ta yozo tahan tyica si i naquihin ndo? Ta i catyi ra: Usi uu tahan. ");
INSERT INTO mihNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ta i catyi ra Jesús: Ta sa i sehi sa usa tahan pan i sasi cumi mil ñiyɨvɨ, ¿yozo tahan tyica i situ i naquihin ndo? Ta i catyi ra: Usa tahan. ");
INSERT INTO mihNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ta i catyi ra Jesús: ¿Ñacu ña cutuñi iñi ndo? ");
INSERT INTO mihNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","I saa ra Jesús ñuu Betsaida. Ta i sindyaca ñiyɨvɨ sii minoo ra cuaa nu ndyaa ra. Ta i sica xaan ñu tumañi iñi sa tyizo ra ndaha ra sii ra cuaa cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ta i tɨɨn ra Jesús ndaha ra, ta i sahan ra sihin ra ndya yuñuu. Ta i tyaa ra Jesús zɨɨ ra nuu ra cuaa cuan, ta i tyizo ra ndaha ra zɨquɨ ra. Ta i ndaca tuhun ra sii ra tatu sa cuu ndyehe ra zuhva. ");
INSERT INTO mihNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ta i ndyehe ra cuaa cuan, ta i catyi ra: Ndyehi ñiyɨvɨ. Tañi caa yutu caa ñu. Ta sica ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ta i tyizo tucu ra Jesús inga saha ndaha ra nuu ra, ta i nduvaha ra. Sa nandyehe vaha ra tandɨhɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tacuan ta i natasi ra Jesús sii ra ndya vehe ra, ta i catyi ra: Ma quɨhvun sisi ñuu. Ta ma nacatyun sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tacuan ta cuahan ra Jesús sihin ra i casi ra tandɨhɨ ñuu ndyihi nu cu si Cesarea de Filipo. Ta ityi cuahan ra i ndaca tuhun ra Jesús sii ra ta catyi ra: ¿Yoo ra cui catyi ñiyɨvɨ? ");
INSERT INTO mihNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ta i catyi ra i casi ra: Iyo ñiyɨvɨ catyi vatyi minoo ra i nandoto cuun tañi ra Juan, ra i zacoo ndutya a minoo ra profeta. Ta catyi inga ñiyɨvɨ vatyi ra Elías cuun. ");
INSERT INTO mihNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ta i ndaca tuhun ra Jesús sii ra: Ta maa ndo, ¿yoo ra cui catyi maa ndo? Ta i catyi ra Pedro: Yoho cuu ra Cristo, ra i tasi ra Ndyoo vatyi cua zacacun sii ndi. ");
INSERT INTO mihNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ta i catyi ra Jesús sihin ra vatyi ma nacatyi ra sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ta i quisaha zacuaha ra Jesús sii ra i casi ra vatyi cua ndyehe xaan ra i quisi ndya gloria tundoho. Ta ra mandoñi, ta ra zutu nahnu, ta ra maestro cuenda ley cua cuxaan xaan ra sihin ra. Ta cua cahñi ra sii ra. Ta sa cu uñi quɨvɨ, cua nandoto tucu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ta tandɨhɨ cuhva cuan casi xaan i nacatyi ra Jesús sihin ra. Tacuan ta i tava ra Pedro sii ra ndya zava, ta ñihi xaan i cahan ra Pedro sihin ra Jesús, ta catyi ra: Ña vaha cua tahan si suun cuhva sa cohon ña. ");
INSERT INTO mihNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ta i nandyehe ra Jesús nu yucu inga ra i casi ra. Ta xaan xaan i cahan ra sihin ra Pedro, ta catyi ra: Ma cahan con tacuan vatyi cohon tañi cahan cuihna. Ña sica iñun cuhva sica iñi ra Ndyoo. Sica iñun cuhva sica iñi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tacuan ta i cana ra Jesús sii ra i casi ra ta sii inga ñiyɨvɨ. Ta i catyi ra: Tatu iyo ra cuñi ra cundyico ra sii, nazama ra cuhva iyo ra. Ta ma zacahnu xaan ra sii ra. Ta nandyehe ra tundoho sa cuenda mi. Ta nazavaha ra cuhva zavehi. ");
INSERT INTO mihNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tatu ña cuñi ñiyɨvɨ sa cuu ñu sa cuenda Tuhun Ndyoo, cua cuu ñu, ta cua cuhun ñu andyaya. Ta ma cundito ñu sihin ra Ndyoo. Zoco tatu cua cuu ñiyɨvɨ sa cuenda mi a sa cuenda Tuhun Ndyoo, cua cundito ñu sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ñaa sa ñihi ñiyɨvɨ sa zahacanaa ñu tandɨhɨ sa iyo ñuu ñiyɨvɨ ta quɨvɨ cua cuu ñu ndaha cua naa ñi ñu? ");
INSERT INTO mihNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Ta yozo caa cuu tyiyahvi ñiyɨvɨ ta ñihi tahvi añima ñu? ");
INSERT INTO mihNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tatu iyo ra cahan nuu sa cuenda mi a sa cuenda Tuhun Ndyoo nuu ñiyɨvɨ iyo cuatyi ya, tacuan tucu cua cucahan nui sii ra. Vatyi yuhvi, ra i quisi ndya gloria cui, ta cua quisi tuqui sihin ángel. Ta cua ndyehe ñiyɨvɨ vatyi cahnu xaan cuu Zuti. ");
INSERT INTO mihNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ndisa cuii sa quehin sihin ndo vatyi iyo ñu yucu ihya ma cuu ñu ndya cua ndyehe ñu cuhva cundyaca ñaha ra Ndyoo vatyi iyo xaan cuhva sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sa yaha iñu quɨvɨ ta cuahan ra Jesús sihin ra Pedro, ta ra Jacobo ta ra Juan ndya minoo yucu zucu xaan. Ta yucuan i zama cuhva caa ra Jesús nu yucu ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Zahma ra xiño xaan i nduu si ta cuisi xaan si tañi nieve. Yoñi numinoo ñiyɨvɨ cuu zanducuisi zahma tañi i nducuisi zahma ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ta i ndyehe ra i casi ra Jesús sii ra Elías ta ra Moisés. Ra zacuaha Tuhun Ndyoo ta sa naha cuu nduu tahan ra cuan. I quisi ra ndya gloria. Ta i natuhun ra sihin ra Jesús yucuan. ");
INSERT INTO mihNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ta i catyi ra Pedro sihin ra Jesús: Maestro, vaha xaan yucu yo ihya. Nazavaha ndi uñi tahan vehe tyiyahva; minoo cuenda moo, ta minoo cuenda ra Moisés, ta inga si cuenda ra Elías. ");
INSERT INTO mihNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yuhu xaan tandɨhɨ uñi tahan ra i casi ra Jesús. Ta yucuan cuenda i cahan ra Pedro tacuan vatyi ñá sito ra ñaa sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ta zɨquɨ i quisi minoo vico. Ta ndaha tyazi si sii tandɨhɨ ra. Ta i cahan minoo sa cahan sisi vico cuan. Ta catyi si: Ra ihya cuu zehi. Cuñi xein sii ra. Tyaa ndo yahvi sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ta zuun ñi caa cuhva cuan i nandyehe ra i casi ra Jesús siconduu nu yucu ra. Ta ñá ndyehe ca ra sii ra Moisés ta nu ra Elías. Maa tuhun ñi ca ra Jesús nandyaa sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ta cuhva sa cua noo ra yucu cuan i catyi ra Jesús sihin ra vatyi ma nacatyi ra nu sihin minoo ñiyɨvɨ sa ndyehe ra ndya cua saa quɨvɨ cua nandoto tucu ra i quisi ndya gloria sisi sa i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ta i sicumi xehe ra tuhun cuan, zoco i nducu tuhun tahan xaan ra: ¿Yozo caa cuu nandoto ñiyɨvɨ tatu sa i sihi ñu? ");
INSERT INTO mihNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ta i ndaca tuhun ra sii ra Jesús ta catyi ra: ¿Ñacu catyi ra maestro cuenda ley vatyi xihna ca ra Elías cua quisi ta zɨquɨ ra Cristo? ");
INSERT INTO mihNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ta i catyi ra Jesús: Ndisa cuii, xihna ca ra Elías i quisi, ta i zanduvaha ra tandɨhɨ tyiño vatyi cua quisi ra Cristo. Ta ¿ñaa catyi Tuhun Ndyoo sa cuenda ra i quisi ndya gloria? Catyi si vatyi cua ndyehe xaan ra tundoho ta ma tyaa ñiyɨvɨ yahvi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yuhvi catyi sihin ndo vatyi ra Elías sa i quisi ra, ta i zavaha ñu tandɨhɨ sa cuñi maa ñu sihin ra. Tañi catyi Tuhun Ndyoo, ta tacuan i cuu si. ");
INSERT INTO mihNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ta cuee ca i ndisi tucu ra Jesús nu yucu zuhva ca ra i casi ra. Nandyaa ra cuan zava mahñu. Ta yucu cuaha xaan ñiyɨvɨ siconduu cuii ñu sii ra. Ta natuhun tahan ra maestro cuenda ley sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ta sa i nandyehe ñiyɨvɨ sii ra Jesús, iyo xaan i cuñi ñu. Ta i sino xaan ñu ta i zatahan ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tacuan ta i ndaca tuhun ra Jesús: ¿Ñaa tuhun natuhun xaan ndo? ");
INSERT INTO mihNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ta i nacahan minoo ra nandyaa yucuan. Ta i catyi ra: Maestro, vasi ndyaque minoo zehi. Ñoho tatyi cuihna sii ra. Ta ña saha si cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ta ndya vaha cuii ñi cuhva nduxaan si sii ra. Ta zanduva si sii ra nu ñuhu. Ta saa tɨñɨ yuhu ra. Ta sasi quihñi noho ra. Ta ndaha ndurutu ra. Ta yucuan cuenda cuehe xaan ra. Ta sa catyi vatyi tava ra i casun sii si. Zoco ñá cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ta i catyi ra Jesús sihin tandɨhɨ ñiyɨvɨ: Ndoho cuu ñiyɨvɨ ña sino iñi. ¿Yozo tahan ca quɨvɨ cua ndoi sihin ndo ta zɨquɨ cua sino iñi ndo? Sa naha xaan i cundyee iñi sihin ndo. Ta ndyaca ndo sii ra luhlu ña. ");
INSERT INTO mihNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","I sindyaca ra sii ra, ta i ndyehe tatyi cuihna cuan sii ra Jesús. Ta i nduxaan si sii ra luhlu cuan. Ta i nduva ra nu ñuhu. Sicotuu ra. Zañihi ra. Ta saa tɨñɨ yuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","I ndaca tuhun ra Jesús sii zutu ra luhlu cuan: ¿Sa yozo tahan cuiya sa tahan ra tacuan? Ta i catyi zutu ra: Ndya ta luhlu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ta cuaha xaan saha cañi ñuhu si sii ra nu ñuhu a si ndutya vatyi cuñi si cahñi si sii ra. Tatu cuu zanduvohon sii ra cundahvi iñun sii ndi, ta tyindyeun sii ndi. ");
INSERT INTO mihNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ta i catyi ra Jesús sihin ra: Cuu zanduvehi sii ra tatu cuu sino iñun vatyi cuu sii vatyi zavaha ra Ndyoo ñaa sa sica ñiyɨvɨ sino iñi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ta i cana saa zutu ra luhlu cuan ta catyi ra: ¡Sino iñi, ta tyindyeun sii, cuhva sino ca iñi! ");
INSERT INTO mihNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","I ndyehe ra Jesús vatyi cuaha xaan ñiyɨvɨ cua titahan, ta xaan xaan i cahan ra Jesús sihin tatyi cuihna cuan, ta catyi ra: Yoho cuihna zañehe sii ñiyɨvɨ, cuihna zazoho sii ñiyɨvɨ, yuhvi catyi vatyi quiton. Zañon sii ra luhlu ya. Ta ma ndɨhvɨ con sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","I sacu saa tatyi cuihna cuan, ta i zacuñaa si sii ra luhlu cuan, ta i quita si. Tañi ra sihi nduu ra. Ta i catyi cuaha xaan ñiyɨvɨ vatyi sa sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Zoco i tɨɨn ra Jesús ndaha ra, ta i cañihi ra sii ra, ta i nduvita ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ta zɨquɨ i quɨhvɨ ra Jesús minoo vehe, ta i ndaca tuhun xehe ra i casi ra sii ra: ¿Ñacu ñá cuu tava nduhvi tatyi cuihna cuan? ");
INSERT INTO mihNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ta i catyi ra Jesús sihin ra: Cuu zacuu ndo tatu coo ndyitya ndo ta cahan ndo sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ta i quita ra yucuan, ta i yaha ra nu cu si Galilea. Ta ñá cuñi ra Jesús sa coto numinoo ñiyɨvɨ nu cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","I zacuaha ra sii ra i casi ra, ta catyi ra sihin ra: Cua xico minoo ra sii ii, ra i quisi ndya gloria. Ta cua tɨɨn ñiyɨvɨ sii. Ta cua cahñi ñu sii. Ta sa cu uñi quɨvɨ cua nandoto tuqui. ");
INSERT INTO mihNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Zoco ñá nacoto ra sa cahan ra Jesús, ta ñá ndaca tuhun ra vatyi cahan nuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tacuan ta zɨquɨ i saa ra Jesús ñuu Capernaum. Ta sa ñoho ra minoo vehe, ta i ndaca tuhun ra Jesús sii ra i casi ra ta catyi ra: ¿Ñaa tuhun natuhun xaan ndo ityi i quisi yo? ");
INSERT INTO mihNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Zoco taxi cuii ñi i nduu ra. Ta i cucahan nuu ra vatyi i natuhun tahan ra ityi i quisi ra yoo ra cuu ra ñiñi ca sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ta i sicundyaa ra Jesús, ta i cana ra sii tandɨhɨ sa usi uu tahan ra i casi ra, ta i catyi ra: Tatu iyo minoo ra cuñi ra cuu ra ra ñiñi ca, vaha ca ma zacahnu ra sii ra. Natyindyee ra sii inga ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ta zɨquɨ i quihin ra Jesús sii minoo ra luhlu, ta i tyihi ra sii ra mahñu ñiyɨvɨ, ta i sicunumi ra sii ra, ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Tatu zavaha ñiyɨvɨ sa vaha sihin minoo ra luhlu sa cuenda mi, tañi sa zavaha ñu sa vaha sihin mi cuu si. Ta tatu zavaha ñiyɨvɨ sa vaha sihin mi, zavaha ñu sa vaha sihin Zuti. ");
INSERT INTO mihNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ta zɨquɨ i catyi ra Juan: Maestro, i ndyehe ndi minoo ra tava ra tatyi cuihna sihin zɨvɨ moo, zoco yɨvɨ ra tahan ndi cuu ra. Ta i catyi maa ndi vatyi ma zavaha ra sa tacuan. ");
INSERT INTO mihNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ta i catyi ra Jesús: Ña vaha sa ñá saha ndo. Vaha tatu cua cutyiño ra zɨvi; ma cuu tucu cahan ra sa ndya vaha ñi zɨqui. ");
INSERT INTO mihNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Vatyi tatu ma cahan ñiyɨvɨ ndya vaha ñi zɨquɨ yo, tyindyee ñu sii yo. ");
INSERT INTO mihNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tatu cuhva ñiyɨvɨ ndutya cohon ndo vatyi i tasi ra Ndyoo sii, ta ra i casi cuu maa ndo, catyi vatyi cua tyiyahvi Ndyoo sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yoo ra cua zañaha sii minoo ra luhlu tañi ra luhlu ya cuhva zavaha ra sa ña vaha ta ma cundyico ca ra sii, vaha ca tatu sa i sihñi ñiyɨvɨ zucu ra cuan sihin minoo yuu yozo vee xaan ta zavita ñu sii ra sisi tyañuhu yatyi ca. ");
INSERT INTO mihNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tatu cuñun zavohon sa ña vaha sihin ndohon, cahndya ndaxun sii si vatyi vaha ca cuhun gloria sihin minoo ñi ndohon ta ma cuhun sihin nduu tahan ndohon andyaya sisi ñuhu sa ma ndahva ");
INSERT INTO mihNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","nu ña sihi tindacu sasi sii ñiyɨvɨ ta nu cayu ñuhu tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tatu cuñun zavohon sa ña vaha sihin sohon, cahndya ndaxi tucun sii si cuan vatyi vaha ca cuhun gloria sihin ii siyo ñi sohon, ta ma cuhun sihin nduu tahan sohon andyaya sisi ñuhu sa ma ndahva ");
INSERT INTO mihNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","nu ña sihi tindacu sasi sii ñiyɨvɨ, ta nu cayu ñuhu tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ta tatu cuñun ndyehun sa ña vaha sihin sɨtɨ nuun, tavon sii si vatyi vaha ca cua quɨhvun sihin minoo ñi sɨtɨ nuun nu ndyaca ñaha ra Ndyoo, ta ma cuhun sihin nduu tahan sɨtɨ nuun andyaya ");
INSERT INTO mihNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nu ña sihi tindacu sasi sii ñiyɨvɨ, ta nu cayu ñuhu tandɨhɨ tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Zoco ñiyɨvɨ ndyico sii, cua nduvaha añima ñu tañi ñɨɨ vaha vatyi cua tahan ñu tundoho ihya ñuu ñiyɨvɨ sa cuenda mi. Ta tundoho cuan, tañi ñuhu cuu si vatyi sito xaan ñu tundoho. (Ta tacuan cua nduvaha añima ñu.) ");
INSERT INTO mihNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Vaha xaan cuu ñɨɨ, zoco ¿yozo caa cutyiño ñiyɨvɨ sii si tatu ña uhva ca si? Tañi ñɨɨ vaha cua cuu maa ndo tatu vaha cua zavaha ndo sihin inga ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","I quita ra Jesús ñuu Capernaum, ta cuahan ra nu cu si Judea inga siyo yuu Jordán. Yucuan, cuaha xaan ñiyɨvɨ i titahan nu ndyaa ra, ta inga saha i zacuaha ra sii ñu tañi cuhva sa tuhva ra. ");
INSERT INTO mihNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ta zɨquɨ i quisi ra fariseo nu ndyaa ra Jesús, ta i ndaca tuhun ra sii ra Jesús ta catyi ra: ¿Atu iyo ley sa zandoo minoo rayɨɨ sii ñazɨhɨ ra? Tacuan cahan ra vatyi cuñi ra fariseo tyaa ra cuatyi sata ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ta i ndaca tuhun ra Jesús sii ra: ¿Ñaa sa i catyi ra Moisés? ");
INSERT INTO mihNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ta i catyi ra fariseo: Saha ra Moisés cuhva sa sino minoo tutu, ta zɨquɨ cuu zandoo ra sii ña sihin ley. ");
INSERT INTO mihNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ta i catyi ra Jesús sihin ra: I saha ra Moisés ley cuan sii ndo vatyi ñihi xaan iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Zoco sa xihna ñi i zavaha ra Ndyoo tandɨhɨ sa iyo ñuu ñiyɨvɨ, ta i zavaha ra minoo rayɨɨ ta minoo ñaha. ");
INSERT INTO mihNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ta yucuan cuenda cua zandoo rayɨɨ sii zutu ra ta sii zɨhɨ ra, ta cua cu‑ɨɨn ra sihin ñazɨhɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Sa nduu tahan ñu cua nduu ñu tañi minoo ñi. Cuhva sa ndyehe ra Ndyoo sii ñu, minoo ñi ñiyɨvɨ cuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cuu, ña vaha zandoo rayɨɨ sii ñazɨhɨ ra. Nu maa ña ta ma zandoo ña sii maa ra vatyi ra Ndyoo i zandu‑ɨɨn ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ta sisi vehe i ndaca tuhun ra i casi ra Jesús sii ra ñaa tuhun cuu si cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ta i catyi ra Jesús sihin ra: Ra zandoo sii ñazɨhɨ ra ta quihin ra inga ñaha, yucuan cuu ra iyo cuatyi vatyi ña ndoo zavaha ra sihin ñazɨhɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tacuan tucu ñaha zandoo sii yɨɨ ña ta cuhun ña sihin inga rayɨɨ, iyo cuatyi ña vatyi ña ndoo zavaha ña. ");
INSERT INTO mihNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tacuan ta zɨquɨ i quisi ndyaca ñiyɨvɨ sii sa ndyihi nu ndyaa ra Jesús vatyi cua tyizo ra ndaha ra sii si ta cahan ra sihin ra Ndyoo. Ta i catyi ra i casi ra Jesús sihin ñiyɨvɨ cuan vatyi ma quisi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ta i ndyehe ra Jesús, ta i cuxaan ra ta catyi ra: Ma cahan ndo. Naquisi ndyaca maa ñu sii sa ndyihi sii, vatyi tatu cuñi ñiyɨvɨ sa cua cundyaca ñaha ra Ndyoo sii ñu, cua sino iñi ñu sii, tañi sino iñi sa ndyihi ya. ");
INSERT INTO mihNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ndisa cuii sa quehin vatyi ñiyɨvɨ ña sino iñi tañi sino iñi sa ndyihi ya, ña saha ñu sa cundyaca ñaha ra Ndyoo sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ta i quihin ra sii sa ndyihi, ta i tyizo ra ndaha ra sii minoo minoo si. Ta i catyi ra: Nacuhva ra Ndyoo sa vaha sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ta sa quita ra Jesús, ta i quisi minoo ra. Sino xaan ra, ta i sicuɨñɨ sɨtɨ ra nuu ra Jesús. Ta i ndaca tuhun ra sii ra: Maestro, vaha xaan ra cuun. ¿Ñaa sa cua zavehi, ta ñihi tahvi añime gloria? ");
INSERT INTO mihNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ta i catyi ra Jesús sihin ra: ¿Ñacu catyun vatyi vaha xaan ra cui? Minoo tuhun ñi ra vaha iyo, ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Sa siton tandɨhɨ ley ra Ndyoo: Ma cuhun minoo ñaha tatu yɨvɨ ñazɨhun cuu. Ma cahñun ñiyɨvɨ. Ma cohon cuendu sata ñiyɨvɨ. Ma zandavi ñohon sii ñiyɨvɨ. Tyoon yahvi sii zutun ta sii zɨhun. ");
INSERT INTO mihNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ta ra cuan i nacahan ra: Tacuan iyo mi ndya ta luhli. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ta i cuñi xaan ra Jesús sii ra ta catyi ra: Cumañi minoo ñi ca cuhva suun. Cuahan ta xicon tandɨhɨ sa iyo suun, ta cuhvon xuhun cuan sii ñiyɨvɨ ndahvi. Ta ma cumañi si suun nu cua soon gloria. Ta zɨquɨ quisi cundyicon sii. ");
INSERT INTO mihNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ta sa siñi ra cuan cuhva cuan ta i nducuihya xaan iñi ra ta cuahan ra vatyi cuca xaan ra (ta ñá cuñi ra sa zanaa ra xuhun ra). ");
INSERT INTO mihNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ta i nandyehe ra Jesús siconduu nu yucu ñiyɨvɨ ndyico sii ra ta catyi ra: Yɨɨ xaan ta cuu quɨhvɨ ñiyɨvɨ cuca nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ta iyo xaan i cuñi ñu sihin cuhva cahan ra Jesús. Ta i catyi tucu ra Jesús sihin ñu: Zehe luhli, yɨɨ xaan cua quɨhvɨ minoo ra iyo xaan ndaha tyiño nu ndyaca ñaha ra Ndyoo vatyi sica iñi ra vatyi cua tyindyee ndaha tyiño ra sii ra ta cua cuu quɨhvɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yɨɨ ca quɨhvɨ minoo ra cuca nu ndyaca ñaha ra Ndyoo ta zɨquɨ ca minoo camello yaha tɨ xuu minoo yɨcuɨ tɨcuɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ta sa siñi ñu cuan cuhva cuan ta iyo xaan i cuñi ñu. Ta i natuhun tahan ñu. Ta i ndaca tuhun ñu sii ra Jesús: ¿Yoo ñiyɨvɨ cua cacu ta ma cuhun ñu andyaya? ");
INSERT INTO mihNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ta i ndyehe ra Jesús sii ñu ta catyi ra: Ma cuu zavaha ñiyɨvɨ cuhva cuan, zoco Ndyoo cuu zavaha ra vatyi Ndyoo ñahñi sa yɨɨ nuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ta zɨquɨ i catyi ra Pedro: Tata, nduhvi sa zandoo ndi tandɨhɨ ndaha tyiño ndi, ta ndyico ndi suun. ");
INSERT INTO mihNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ta i catyi ra Jesús sihin ra: Ndisa cuii sa quehin sihin ndo vatyi ra zandoo vehe ra, a yañi ra, a cuhva ra, a zutu ra, a zɨhɨ ra, a ñazɨhɨ ra, a ñuhu ra sa cuenda mi ta sa cuenda Tuhun Ndyoo ");
INSERT INTO mihNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cua ñihi ra cuaha xaan ca ihya ñuu ñiyɨvɨ tañi minoo ziendu ca vehe ra, ta yañi ra, ta cuhva ra, ta zɨhɨ ra, ta zehe ra, ta ñuhu ra vazu cua tahan ra tundoho. Zoco inga ñuu ñiyɨvɨ cua cundito ra tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ta cuaha xaan ñiyɨvɨ ñiñi vityi, yɨvɨ ñiyɨvɨ ñiñi cua cuu ñu. Ta ñiyɨvɨ ña ñiñi, cua nduu ñu ñiyɨvɨ ñiñi xaan. ");
INSERT INTO mihNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tacuan ta zɨquɨ cuahan ra ityi ñuu Jerusalén. Ityi nuu iñi ra Jesús, ta ityi sata vasi ra i casi ra, ta iyo xaan cuñi ra. Ta ñiyɨvɨ ndɨhɨ sihin ra, yuhu xaan ñu. Tacuan ta i cana ra Jesús sii sa usi uu tahan ra ndya zava, ta i nacatyi ra sihin ra tandɨhɨ cuhva sa cua cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ta i catyi ra Jesús sihin ra: Ndyehe ndo vatyi sa cuahan yo ityi ñuu Jerusalén nu cua xico tuhun ñiyɨvɨ sii ra i quisi ndya gloria. Ta cua tɨɨn ra zutu nahnu ta ra maestro cuenda ley sii ra. Ta cua catyi ra cuan vatyi cua cuu ra. Ta cua cuhva ra sii ra sii ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu. ");
INSERT INTO mihNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ta cua vacu ndyaa ñu sii ra. Ta cua cañi xaan ñu sii ra. Ta cua tyicu zɨɨ ñu sii ra. Ta cua cahñi ñu sii ra. Zoco sa cu uñi quɨvɨ ta cua nandoto tucu ra sisi sa i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ta zɨquɨ i tuhva ra Jacobo ta ra Juan nu ndyaa ra Jesús. Zehe ra Zebedeo cuu sii nduu tahan ra. Ta i catyi ra: Maestro, cuñi ndi zavohon minoo tumañi iñi sa sica ndi suun. ");
INSERT INTO mihNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ta i ndaca tuhun ra Jesús sii ra ta catyi ra: ¿Ñaa sa cuñi ndo zavehi? ");
INSERT INTO mihNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ta i catyi ra: Cuhvon vatyi quɨvɨ cua cundyaca ñohon ta cua cundyaa maa ndi suhun. Minoo ndi siyo cuohon ta minoo ndi siyo zatyun. ");
INSERT INTO mihNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ta i catyi ra Jesús sihin ra: Ña sito ndo ñaa sa sica ndo. ¿Atu cundyee ndoho ndyehe ndo tundoho tañi tundoho cua ndyehe mi? ");
INSERT INTO mihNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ta i catyi ra: Cundyee iñi ndi. Ta i catyi ra Jesús sihin ra: Ndisa cuii cua ndyehi tundoho, ta cua ndyehe ndo tundoho sa cuenda mi. ");
INSERT INTO mihNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Zoco sa cundyaa ndo siyo cuehi ta siyo zatyi, ña tahan si sa yuhvi cuhva. Maa ra Ndyoo cua catyi yoo ra cua ñihi ndatu cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ta sa siñi inga sa usi tahan ra i casi ra Jesús, ta i cuxaan ra sihin ra Jacobo ta ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ta i cana ra Jesús sii ra ta catyi ra: Sa sito maa ndo cuhva ndyaca ñaha ñiyɨvɨ ñuu ñiyɨvɨ. Iyo ra cu nuu, ta zacoto ra sii tandɨhɨ ñiyɨvɨ vatyi ndyaca ñaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Zoco ña tacuan cuu si sa cuenda ndoho. Zama si cuhva. Tatu cuñi minoo ra cuu ra ra cahnu, natyindyee ra sii ra tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ta yoo ra cuñi sa cuu ra minoo ra cahnu ityi nuu ra Ndyoo, nanduu ra muzu sii tandɨhɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Vatyi cuhva ndya ra i quisi ndya gloria, ta ña vasi ra sa vatyi tyindyee ñiyɨvɨ sii ra. Vasi ra sa tyindyee ra sii ñiyɨvɨ. Tacuan iyo ra. Ta yucuan cuenda cua cuu ra sa cuenda ñiyɨvɨ, ta zɨquɨ cuu quɨhvɨ ñu gloria. ");
INSERT INTO mihNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","I saa ra Jesús ñuu Jericó, ta cuhva sa cua quita tucu ra ñuu cuan sihin ra i casi ra ta i sindyico cuaha xaan ñiyɨvɨ sii ra. Ta minoo ra cuaa, ra nañi Bartimeo, zehe ra Timeo, ndyaa ra ityi vatyi caya ra. ");
INSERT INTO mihNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ta sa sito ra vatyi ra Jesús, ra ñuu Nazaret, cua yaha ityi cuan ta i cana saa ra ta catyi ra: ¡Jesús, yoho cuu ñiyɨvɨ sii ra rey David, cundahvi iñun sii! ");
INSERT INTO mihNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Cuaha xaan ñiyɨvɨ catyi sihin ra nacutaxi ra, zoco ñihi ca nduu ra cana saa ra, ta catyi ra: ¡Yoho ñiyɨvɨ ra David, cundahvi iñun sii! ");
INSERT INTO mihNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tacuan ta i sicuɨñɨ ra Jesús ta i catyi ra: Cana ndo sii ra. Ta i cana ñu sii ra cuaa ta catyi ñu: Zanduzɨɨ iñun, ta nduviton vatyi cana ra Jesús suun. ");
INSERT INTO mihNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ta ta sica cuii ñi i nduvita ra, ta i zandoo ihno ra zahma ndisi ra. Ta i tuhva ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ta i ndaca tuhun ra Jesús sii ra: ¿Ñaa sa cuñun zavehi suhun? Ta i catyi ra cuaa cuan: Maestro, cuñi zanduvohon nui. ");
INSERT INTO mihNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","I catyi ra Jesús sihin ra: Sa cuu cuhun. Sa nduvohon vatyi i sino iñun. Ta zuun ñi caa cuhva cuan ndaha nandyehe ñi ra cuaa cuan. Ta cuahan ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ta sa saa ra yatyi ñi ñuu Jerusalén nu ndyaa ñuu Betfagé ta ñuu Betania yatyi ñi yucu sa nañi Olivos, ta i tasi ra Jesús sii uu tahan ra i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ta i catyi ra: Cuahan ndo ñuu ndyaa yatyi ñi ya sa ndoo ñi. Tatu saa ndo cua ndyehe ndo minoo burro, nuhñi tɨ, quɨtɨ ta yoñi ca maa cozo. Ndasi ndo sii tɨ, ta quisi ndo sihin tɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tatu iyo ñiyɨvɨ ndaca tuhun sii ndo ñaa sa ndyicuu ndo ta catyi ndo: “Cuñi ra cu nuu sii yo sii tɨ, ta tañi ca cua quisi nuhu tɨ.” ");
INSERT INTO mihNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ta cuahan ra, ta i nañihi ra burro cuan. Nuhñi tɨ ityi, yatyi ñi yuvehe. Ta i ndasi ra sii tɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ta i catyi ra yucu yucuan sihin ra: ¿Ñaa sa ndyicuu ndo? ¿Ñacu ndasi ndo burro ña? ");
INSERT INTO mihNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tacuan ta i nacatyi ra cuhva sa catyi ra Jesús sihin ra. Ta i saha ñiyɨvɨ sa cuhun ra sihin burro cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","I sindyaca ra sii tɨ nu ndyaa ra Jesús, ta i tyizo ra zahma ra sata tɨ, ta zɨquɨ i sicozo ra Jesús sii tɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ta cuaha xaan ñiyɨvɨ i saqui ñu zahma ñu ityi. Ta inga ca ñiyɨvɨ i sahndya ñu ndaha numa, ta i saqui ñu ityi. ");
INSERT INTO mihNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ta ñu cuahan ityi nuu ra, ta ñu vasi ityi sata ra i cana saa ñu ta catyi ñu: ¡Aleluya! ¡Nazacahnu yo sii ra Ndyoo vatyi vaha xaan cuu ra vasi sa cuenda ra Ndyoo! ");
INSERT INTO mihNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Vaha xaan cua cundyaca ñaha maa ra cuhva i sindyaca ñaha ra rey David, ra i cuu ñiyɨvɨ sii yo! ¡Aleluya! ¡Nazacahnu yo sii ra iyo ityi zɨquɨ! Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tacuan i quɨhvɨ ra Jesús ñuu Jerusalén. Ta i quɨhvɨ ra vehe ñuhu. Ta i ndyehe ra tandɨhɨ sa iyo yucuan, ta zɨquɨ cuahan ra ñuu Betania sihin sa usi uu tahan ra i casi ra vatyi sa cua iñi xaan. ");
INSERT INTO mihNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ta inga quɨvɨ i quita ra ñuu Betania. Ta i sizoco xaan ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tacuan ta i ndyehe ra minoo yutu sa nañi higuera sihin ndaha tu. Ta sahan ra i sindyehe ra tatu iñi sɨtɨ tu, zoco ñá ñihi maa ra ndaha ñi. Maa maa ndaha ñi tu iñi vatyi yɨvɨ tyiemvu iyo sɨtɨ tu cuu si. ");
INSERT INTO mihNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ta i catyi ra Jesús sihin yutu cuan: Ma coo ca sɨtun vatyi ma casi ca ñiyɨvɨ sii si ndaha cuii ñi. Ta i siñi ra i casi ra sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","I saa tucu ra Jesús ñuu Jerusalén. Ta sa i quɨhvɨ ra vehe ñuhu ta i quisaha tava ndyizo ra sii ñiyɨvɨ xico ta ñiyɨvɨ zata. Ta i zanduva ihno ra mesa nu nazama ñiyɨvɨ xuhun sii inga ñiyɨvɨ, ta tacuan tucu tyayu nu xico ñiyɨvɨ paloma. ");
INSERT INTO mihNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ñá saha ca ra sa cuizo ñiyɨvɨ ndaha tyiño sisi vehe ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ta i quisaha zacuaha ra Jesús sii ñu ta catyi ra: Catyi Tuhun Ndyoo: “Vehe mi cunañi si vehe nu cahan ñiyɨvɨ sihin ra Ndyoo. Ta sa cuenda tandɨhɨ cuii ñiyɨvɨ ñuu ñiyɨvɨ cuu si.” Zoco maa ndo zacuu ndo vehe ra zuhu sii si. ");
INSERT INTO mihNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","I siñi ra zutu nahnu ta ra maestro cuenda ley sa cahan ra. Ta i quisaha nducu ra cuhva cahñi ra sii ra. I yuhu xaan ra sii ra Jesús vatyi iyo xaan i cuñi tandɨhɨ ñiyɨvɨ sihin tandɨhɨ cuhva i zacuaha ra. ");
INSERT INTO mihNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Zoco sa tyahan cuan, i quita ra Jesús ñuu cuan ta cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ta inga quɨvɨ i yaha ra ñaha ñi, ta i ndyehe ra vatyi sa na‑ityi yutu i cahan ra Jesús sihin ndya cuhva ndya yoho tu. ");
INSERT INTO mihNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ta i nacohon iñi ra Pedro, ta catyi ra sihin ra Jesús: Ndyehe Maestro, sa i na‑ityi yutu i cohon sihin. ");
INSERT INTO mihNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ta i catyi ra Jesús: Sino iñi ndo sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Quehin sa ndisa sihin ndo vatyi yoo ra cua catyi sihin yucu ya: “Cuɨñɨ siyon ihya, ta cua ndɨhvun sisi tyañuhu.” Tatu sino iñi ra tacuan, tacuan cua cuu si sa ndisa cuii. ");
INSERT INTO mihNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tyehen catyi vii sihin ndo: Sino iñi ndo sa cua ñihi ndo tandɨhɨ sa cua caca ndo sii ra Ndyoo. Ta cua cuhva ra tandɨhɨ si sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tatu sica tahvi ndo sii ra Ndyoo ta iyo cuatyi ndo sihin inga ñiyɨvɨ, zanaa ndo iñi ndo cuatyi i zacuu ñu sihin ndo. Ta tacuan tucu ra Ndyoo Zutu yo, ra iyo andɨvɨ, cua zandasi ra cuatyi maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Zoco tatu ma zanaa ndo iñi ndo cuatyi i zavaha ñiyɨvɨ sihin ndo, tacuan tucu ra Ndyoo Zutu yo, ra iyo ityi zɨquɨ, vatyi ma zandasi ra cuatyi maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Inga saha i quisi tucu ra Jesús ñuu Jerusalén. Ta sa quɨhvɨ ra vehe ñuhu ta i quisi ra zutu nahnu sihin ra maestro cuenda ley sihin ra mandoñi nu ndyaa ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ta i ndaca tuhun ra sii ra Jesús ta catyi ra: ¿Yoo ra i tasi suun vatyi cua tava ndyizon sii ñiyɨvɨ sisi vehe ñuhu ya? ¿Yoo sa saha tuhun suun vatyi cuu zavohon tandɨhɨ cuii cuhva ya? ");
INSERT INTO mihNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ta i catyi ra Jesús sihin ra: Cua ndaca tuhin minoo cuhva sii ndo. Tatu cuu nacatyi ndo, tacuan ta cua nacatyi sihin ndo yoo sa saha cuhva sii mi. ");
INSERT INTO mihNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ta i catyi ra: ¿Yoo ra i tasi sii ra Juan sa zacoo ndutya ra? ¿Atu i tasi ra Ndyoo sii ra a ñiyɨvɨ? Nacatyi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","I quisaha natuhun tahan xehe ra, ta i catyi ra sihin tahan ra: Tatu catyi yo vatyi Ndyoo i tasi sii ra, ta zɨquɨ cua catyi ra Jesús: “¿Ñacu ñá sino iñi ndo?” ");
INSERT INTO mihNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿A catyi yo vatyi ñiyɨvɨ i tasi sii ra? Catyi ra. Zoco i yuhu ra sii ñiyɨvɨ vatyi sa sito ra vatyi tandɨhɨ cuii ñiyɨvɨ sino iñi ñu vatyi i cahan ra Juan sa cuenda ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ta yucuan cuenda i catyi ra sihin ra Jesús: Ña sito ndi. Ta i catyi ra Jesús: Tacuan tucu ii, ma nacatyi yoo ra i saha cuhva ya sii. ");
INSERT INTO mihNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tacuan ta zɨquɨ i quisaha cahan ra Jesús sihin minoo cuhva ta catyi ra: Sicoo minoo ra i tasi minoo sacu yoho uva. Ta i zavaha ra nu i tava ra ndutya uva ta minoo vehe tyiyahva vatyi cua zacuenda ra sacu ra, ta i saha noo ra sacu ra sii inga ityi ra zatyiño. Ta cuahan ra inga ñuu. ");
INSERT INTO mihNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ta i saa quɨvɨ i sicoo uva cuan. Ta i tasi sitoho si minoo muzu ra vatyi cua caca ra zuhva, cuhva sa tahan si sii patrón ra. ");
INSERT INTO mihNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ta i tɨɨn ra sii muzu ra cuan, ta i cañi xaan ra sii ra. Ta i natasi ra sii ra. Ta ñá saha ra nu zuhva uva cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ta i tasi tucu sitoho si sii inga muzu ra. Ta i cañi xaan ra sii ra sihin yuu. I tahvi ra xiñi ra. Ta quiñi xaan i zavaha ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ta zɨquɨ i tasi tucu sitoho si sii inga tucu ra. Ta i sahñi ra sii ra. Ta i tasi sitoho si cuaha ca muzu minoo minoo ra. Zuhva ra i cañi ra, ta zuhva ra i sahñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ta iyo minoo tuhun ñi zehe sitoho si, ta cuñi xaan ra sii ra. Ta nu ndɨhɨ tuhun i tasi ra sii ra vatyi sica iñi ra: “Cua tyaa ra yahvi sii zehi.” ");
INSERT INTO mihNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ta i catyi ra zatyiño cuan sihin tahan ra: “Ihya cuu ra cua nañihi ndaha tyiño quɨvɨ cua cuu zutu ra. Nacahñi yo sii ra vatyi ndoo maa yo sihin sacu ya.” ");
INSERT INTO mihNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","I tɨɨn ra sii ra. Ta i sahñi ra. Ta i tava ra coño ñuhu ra sata sacu. ");
INSERT INTO mihNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ta i ndaca tuhun ra Jesús ta catyi ra: ¿Yozo caa cua zavaha sitoho ñuhu cuan vityi? Cua cuhun ra, ta cua cahñi ra sii ra zatyiño cuan. Ta cua cuhva noo ra ñuhu cuan sii inga ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Atu tañaha ca cahvi ndo Tuhun Ndyoo? nu catyi si: I zavita ihno ñiyɨvɨ zandaa vehe sii yuu sa cuñi si cuenda sɨquɨ vehe. Ta vityi, yuu cuan cuu sa ñiñi ca ta zɨquɨ tandɨhɨ sa cuenda vehe cuan vatyi tacuan catyi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ta vaha xaan cuñi yo sihin cuhva ya. ");
INSERT INTO mihNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ta i nducu ra ndyizo tyiño cuhva tɨɨn ra sii ra Jesús vatyi i siñi ra cuhva cahan ra Jesús, cuhva iyo maa ra. Zoco i yuhu ra sii ñiyɨvɨ. Ta yucuan cuenda i zandoo ra sii ra ta cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","I tasi ñiyɨvɨ sii zuhva ra fariseo ta ra ñoho cuenda ra Herodes vatyi cua zandavi ñaha ra sii ra Jesús, ta cua nducu ra cuhva sihin ñaa minoo cuhva cua cahan ra Jesús ta zɨquɨ cua cuu tyaa ra cuatyi sata ra. ");
INSERT INTO mihNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","I quisi ra cuan ta i catyi ra: Maestro, sito ndi vatyi cohon sa ndisa, ta inuu ndita ñi tyoon yahvi sa cahan inga ñiyɨvɨ a cuca ñu a ndahvi ñu. Ndisa cuii zañohon ityi ra Ndyoo. ¿Atu vaha cua tyiyahvi yo xuhun sa sica ra gobierno César, a ña vaha? ¿Atu cua tyiyahvi ndi a ma tyiyahvi ndi? ");
INSERT INTO mihNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ta i sito ra Jesús vatyi ña vaha añima ra cuan, ta i catyi ra sihin ra: ¿Ñacu saqui xaan ndo xayu sehi? Quisi ndyaca ndo minoo xuhun vatyi ndyehi. ");
INSERT INTO mihNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ta i sindyaca ra sii si. Ta sa ndyehe ra Jesús, ta i catyi ra: ¿Yoo sii nuu ndyaa ya? ¿Ta yoo sii zɨvɨ ndyaa ya? Ta i catyi ra: Sii ra gobierno César. ");
INSERT INTO mihNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tacuan ta i catyi ra Jesús sihin ra: Cuhva ndo sii ra gobierno César sa cuu sii ra. Ta cuhva ndo sii ra Ndyoo sa cuu sii ra Ndyoo. Ta iyo xaan i cuñi ra sihin cuhva i cahan ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","I sahan tucu minoo ityi ra saduceo nu ndyaa ra Jesús. I sica iñi tandɨhɨ ra saduceo vatyi ma nandoto tucu ñiyɨvɨ, ta yucuan cuenda i ndaca tuhun ra sii ra Jesús ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Maestro, i tyaa ra Moisés minoo ley vatyi tatu sihi minoo rayɨɨ ta ndoo ndahvi ñazɨhɨ ra, ta yoñi zehe ra, natindaha yañi ra sihin ñaha cuan. Ta cua coo zehe ra sihin ña sa cuenda yañi ra, ra i sihi cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sicoo usa tahan rayɨɨ sihin yañi ra. I tindaha ra nuu, ta i sihi ra, ta yoñi zehe ra i sicoo. ");
INSERT INTO mihNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ta zɨquɨ i tindaha ra cu uu sihin ñandahvi cuan. Sihi tucu ra cuan. Ta yoñi zehe ra i sicoo. Ta tacuan tucu ra cu uñi. ");
INSERT INTO mihNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ta tacuan i tindaha tandɨhɨ sa usa tahan ra sihin ñaha cuan. Ta i sihi ra. Ta numinoo ra yoñi zehe ra i sicoo. Ta nu ndɨhɨ tuhun, i sihi tucu maa ñaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Yoo ra cua cuu yɨɨ ña quɨvɨ cua nandoto tucu ñiyɨvɨ vatyi ñazɨhɨ tandɨhɨ sa usa tahan ra i cuu sii ña? Tacuan i catyi ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ta i catyi ra Jesús sihin ra: Ña sito ndo ñaa sa cahan ndo vatyi ña sito ndo Tuhun ra Ndyoo. Ta ña sito ndo yozo caa iyo cuhva sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Quɨvɨ cua nandoto ñiyɨvɨ i sihi, ma tindaha ca ñu. Ta ma cuhva ca ñu sii zehe ñu sa tindaha ñu. Tañi ángel sa iyo andɨvɨ tacuan cua nduu ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ta tatu cuñi ndo coto ndo tatu cua nandoto tucu ñiyɨvɨ, cuñi si sa nacohon iñi ndo sa i tyaa ra Moisés nu i saha ra cuenda yozo caa i cayu minoo taca iñu. Ta i cahan ra Ndyoo sihin ra sisi tu ta catyi ra: “Yuhvi cui Ndyoo sii ra Abraham ta sii ra Isaac, ta sii ra Jacob.” ");
INSERT INTO mihNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tacuan i cahan ra Ndyoo vazu sa sihi tandɨhɨ ra cuan ta sa naha vatyi sito ra Ndyoo vatyi ndito ra cuan ta cua nandoto tucu ra. Yɨvɨ Ndyoo sii ra ndaha sihi cuii cuu Ndyoo Zutu yo. Ndyoo sii ñiyɨvɨ cua cundito tandɨhɨ tyiemvu cuu maa ra. Ta zama xaan yuhu ndo vatyi sica iñi ndo vatyi ma nandoto tucu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","I saa tucu minoo ra maestro cuenda ley, ta i siñi ra sa ndaca tuhun xaan ñiyɨvɨ sii ra Jesús, ta i sito ra vatyi vaha xaan i nacahan ra Jesús sihin ñu, ta yucuan cuenda i ndaca tuhun ra sii ra ta catyi ra: ¿Ndya cuu ley ra Ndyoo sa ñiñi ca? ");
INSERT INTO mihNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ta i catyi ra Jesús sihin ra: Ley sa ñiñi ca sii ra Ndyoo catyi si: “Ndoho ñiyɨvɨ hebreo, cuɨñɨ ndo. Ndyoo, ra ndyaca ñaha sii ndo, minoo tuhun ñi ra iyo. ");
INSERT INTO mihNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ñihi xaan cuñi ndo sii ra Ndyoo Zutu ndo sihin añima ndo. Ɨɨn ñi sii ra caca iñi ndo; ɨɨn ñi sihin ra cahan ndo; ɨɨn ñi tyiño ra zatyiño ndo. Ta tacuan cua coto ra vatyi cuñi xaan ndo sii ra.” ");
INSERT INTO mihNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ta catyi ley ra Ndyoo sa cu uu: “Cuñi xaan ndo sii tandɨhɨ inga ñiyɨvɨ tañi cuñi ndo sii maa ndo.” Ñahñi ca inga ca ley ñiñi ca ta zɨquɨ nduu tahan ley ya. ");
INSERT INTO mihNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ta i catyi ra cu maestro cuenda ley cuan sihin ra Jesús: Vaha xaan cohon, Maestro. Ndisa cuun sa cohon vatyi minoo tuhun ñi ra Ndyoo iyo. Ta yoñi inga ca Ndyoo iyo. ");
INSERT INTO mihNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ta tatu cuñi ñiyɨvɨ sii ra sihin añima ñu, ta zatyiño ñu tyiño ra ta tandɨhɨ cuhva cuan ta tatu cuñi ñu sii inga ñiyɨvɨ tañi cuñi ñu sii maa ñu, vaha xaan ca cuu si tacuan. Vaha ca tacuan ta zɨquɨ cuhva zavaha ndi, cuhva sa sahmi ndi mvee ticatyi a ñaa sa saha ndi sa zacahnu ndi sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","I sito ra Jesús vatyi vaha xaan i nacahan ra maestro cuenda ley, ta i catyi ra Jesús sihin ra: Zuhva ñi ca cumañi suun, ta cua cuu quɨhvun nu ndyaca ñaha ra Ndyoo. Catyi ra. Ta i yuhu xaan ñiyɨvɨ sa ndaca tuhun ca ñu sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","I zacuaha ra Jesús sisi vehe ñuhu ta catyi ra: Catyi ra maestro cuenda ley vatyi ra Cristo cuu ñiyɨvɨ sii ra rey David, ta ndisa cuu si cuhva cahan ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Zoco zuun ñi maa ra rey David i cahan ta sa naha i zacuu Tatyi Ii. Ta i tyaa ra cuhva cahan ra Ndyoo sihin ra Cristo. Tyehen i tyaa ra David: Cahan ra Ndyoo sihin ra ndyaca ñaha sii mi, ta catyi ra: “Cundyoon siyo cuehi ndya cuhva ndya cua saa quɨvɨ cua cuhve cuhva cua zahacanoon sii ñiyɨvɨ xaan iñi suun.” ");
INSERT INTO mihNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Ta yozo caa cuu cuu ra Cristo ñiyɨvɨ ra David tatu zuun ñi maa ra David catyi vatyi ndyaca ñaha ra Cristo sii ra? Tacuan i catyi ra Jesús, ta zɨɨ xaan i cuñi tandɨhɨ ñiyɨvɨ sa siñi ñu tuhun i cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","I zacuaha ra Jesús sii ñiyɨvɨ ta catyi ra: Zacuenda vaha ndo sii ndo. Ta ma zacuu ndo cuhva zacuu ra maestro cuenda ley. Tahan xaan iñi ra quɨhɨ ra zahma nañi vatyi cua nacoto ñiyɨvɨ sii ra vatyi ra ñiñi cuu ra. Ta cuhun ra nuyahvi vatyi cuñi xaan ra sa tyaa ñiyɨvɨ yahvi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ta cuñi xaan ra sa cundyaa ra nu ndyaa ñiyɨvɨ ñiñi sisi vehe ñuhu. Ta cuñi xaan ra sa cundyaa ra tyayu vaha nu sasi ñiyɨvɨ zacahnu vico. ");
INSERT INTO mihNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Cuaha ca cua cutuñi ra maestro cuenda ley ta zɨquɨ inga ñiyɨvɨ vatyi zuhu ra ndaha tyiño ñu ndahvi. Ta zandavi ñaha ra sii ñiyɨvɨ vatyi naha xaan sica tahvi ra sii Ndyoo vatyi cuñi ra sa cua ndyehe ñiyɨvɨ, ta cua caca iñi ñu vatyi sito xaan ra sii Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Minoo saha ndyaa ra Jesús sisi vehe ñuhu hebreo yatyi ñi nu ndyaa satu nu quɨhvɨ xuhun. Ta i ndyehe ra vatyi cuaha xaan ñiyɨvɨ tyihi xuhun. Ta ra cuca, cuaha xaan i tyihi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tacuan ta i saa minoo ñaha ndahvi. Ta i tyihi ña uu tahan xuhun ndyihi sa cuu ohon zendavu sisi satu cuan vatyi cuñi xaan ña sii ra Ndyoo, ra iyo andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ta zɨquɨ i cana ra Jesús sii ra i casi ra ta catyi ra: Ndisa cuii sa quehin. I tyihi ñandahvi cuan cuaha ca xuhun ta zɨquɨ tandɨhɨ ca ra. ");
INSERT INTO mihNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Saha maa ra sa ndoo ñi ca sii ra, zoco ñandahvi cuan, ndɨhɨ i saha ñi ca ña xuhun cuita casi ña. ");
INSERT INTO mihNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ta i quita ra Jesús vehe ñuhu cuan ta i catyi minoo ra i casi ra sihin ra: ¡Ndyehe, Maestro, tyaqui xaan i sino vehe ñuhu ya! ¡Vaha xaan yuu i sino si! ");
INSERT INTO mihNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ta i catyi ra Jesús sihin ra: Ndyehun vehe nahnu ya vatyi cua tani si, ta tandɨhɨ si cua quɨtɨ cuatyi. ");
INSERT INTO mihNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tacuan ta zɨquɨ cuahan ra yucu sa nañi Olivos, yucu sa ndyehe ñiyɨvɨ sa ndyaa ñu yuvehe ñuhu. Ta sa ndyaa ra Jesús yucuan, i ndaca tuhun xehe ra Pedro ta ra Jacobo ta ra Juan ta ra Andrés sii ra ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Cuhvon cuenda sii ndi. ¿Ñaa quɨvɨ cua cuu sa catyun? ¿Ñaa zeña cua ndyehe ndi, ta zɨquɨ cua coto ndi vatyi cua tahan si? ");
INSERT INTO mihNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ta i catyi ra Jesús: Zacuenda ndo sii ndo coto zandavi ñaha ñiyɨvɨ sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vatyi cuaha xaan ra cua quisi ta cua catyi ra: “Yuhvi cui Cristo.” Ta tacuan cua zandavi ñaha ra cuaha xaan ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ta cua cuɨñɨ ndo tuhun vatyi cua coo cuatyi ta cahñi tahan xaan ñiyɨvɨ, zoco ma yuhu ndo. Xihna ca cua cuu tandɨhɨ cuhva cuan, cumañi ca sa saa quɨvɨ naa ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cua cahñi tahan minoo ñuu sihin inga ñuu, ta cua coo cuatyi ñuu nahnu sihin inga ñuu nahnu. Cua coo cuaha xaan sa taan, ta cua coo tama, ta cua yuhu xaan ñiyɨvɨ. Ta tacuan ñi cua quisaha ndyehe ñiyɨvɨ tundoho. ");
INSERT INTO mihNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Zacuenda ndo sii ndo vatyi cua tɨɨn ñiyɨvɨ sii ndo, ta cua cuhun ndo nu yucu ra cu tyiño nahnu. Ta cua cañi ñiyɨvɨ sii ndo sisi vehe ñuhu. Ta sa cuenda mi cua tasi ra sii ndo nu ndyaa ra gobernador ta ra rey. Ta cua ñihi ndo cuhva cahan ndo tuhun mi nuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ta ma naa ñuu ñiyɨvɨ ndya cua cuɨñɨ ñiyɨvɨ nacahnu ñuu ñiyɨvɨ Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tatu cundyaca ñiyɨvɨ sii ndo nu ndyaa ra cu tyiño nahnu, ma caca iñi ndo sa cua cahan ndo. Ta ma caca xaan iñi ndo. Cahan ndo ñaa sa cahan ra Ndyoo sihin ndo cuhva cuan vatyi yɨvɨ maa ndo cua cahan. Tatyi Ii ra Ndyoo cua cahan. ");
INSERT INTO mihNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Cua xico tuhun ñiyɨvɨ sii tahan ñu, ta zɨquɨ cua cahñi ñiyɨvɨ sii ñu cuan. Ta cua xico tuhun zutu ñiyɨvɨ sii zehe ra. Cua cahñi tahan ñiyɨvɨ sihin zutu ñu ta sihin zɨhɨ ñu. Ta cua cuhva ñu sii ñu sii inga ñiyɨvɨ vatyi cahñi ñu sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Cua cuxaan tandɨhɨ ñiyɨvɨ sihin maa ndo sa cuenda mi, ta yoo ra ma cuɨñɨ siyo sii ndya nu cua ndɨhɨ ñuu ñiyɨvɨ, cua cacu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tatu ndyehe ndo minoo sa zatɨvɨ xaan ta quiñi xaan zacuu si, ta nandyaa si cuan nu ii, cuhva i catyi ra profeta Daniel, cutuñi iñi ndo ndoho ra cahvi ihya, tatu ndyehe ndo sii si cuan, nacono ñiyɨvɨ ñoho Judea, ta naquɨhvɨ xehe ñu ndya yucu. ");
INSERT INTO mihNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tatu iyo ra yozo xiñi vehe ra quɨvɨ cuan, ma cuatu ra numaa iyo ndaha tyiño cuñi ra tava ra sisi vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ta ra ñoho itu ra, ma cunuhu ra ndya vehe ra sa cua naquihin ra zahma ra. ");
INSERT INTO mihNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ta ndahvi ñu zɨhɨ sa ñoho zehe quɨvɨ cuan a tatu iyo zehe ñu sa tyaxi quɨvɨ cuan vatyi cahnu xaan tundoho cua ndyehe ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ta caca ndo sii ra Ndyoo vatyi ma tahan si cono ndo vico zavi a minoo quɨvɨ quitatu ñiyɨvɨ ");
INSERT INTO mihNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","vatyi cua coo cuaha xaan tundoho quɨvɨ cuan, cuhva ta ndyehe ca ñiyɨvɨ ndya i zavaha ra Ndyoo ñuu ñiyɨvɨ. Ta ma coo inga ca tundoho sa tacuan ndaha cuii ñi. ");
INSERT INTO mihNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tatu ma zanduzuhva ra Ndyoo quɨvɨ tundoho cuan, yoñi ñiyɨvɨ cua cacu. Zoco cua zanduzuhva ca ra sii si sa cuenda ñiyɨvɨ i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tatu catyi minoo ra sihin ndo: “Ihya ndyaa ra Cristo a yucuan ndyaa ra”, catyi ra; ma sino iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Vatyi cua nduvita cuaha xaan ra zandavi ñaha, ta cua catyi ra vatyi Cristo cuu ra, ta cua catyi ra vatyi cahan ra tuhun saha ra Ndyoo sii ra. Ta cua zavaha ra zeña nahnu ta sa ndyityi ndya cuhva ndya sii ñiyɨvɨ i casi ra Ndyoo cua zandavi ñaha ra tatu sa vatyi cuu cuhva cuan, zoco ma cuu. ");
INSERT INTO mihNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ndyehe ndo, sa nacatyi tandɨhɨ sihin ndo cuee ca sa tahan si. ");
INSERT INTO mihNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ta i catyi tucu ra Jesús: Tatu sa yaha ndyehe ñiyɨvɨ tundoho cuan ta zɨquɨ ña naha ca ta cua nduñaa ñicandyi, ta ma ndyehe ca yoo. ");
INSERT INTO mihNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Cua nacoyo tiñoo andɨvɨ ndya nu ñuhu, ta ndya cuhva ndya cua canda andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tacuan ta zɨquɨ cua ndyehe ñiyɨvɨ sii ra i quisi ndya gloria ityi andɨvɨ. Cua ndyehe ñu vatyi vasi ra nu vico ta sihin cuaha xaan cuhva. Ta tyaqui xaan caa ra. ");
INSERT INTO mihNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ta cua tasi ra sii ángel ra ndya tandɨhɨ sa cumi tahan sɨquɨ ñuu ñiyɨvɨ, ta cua zatahan ra sii tandɨhɨ ñiyɨvɨ i casi ra Ndyoo ndya nacahnu ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Vityi coto ndo minoo cuhva iyo yutu higuera ta tandɨhɨ inga yutu. Tatu cua ndyehe ndo sa cua nacoyo ndaha tu ta cua nduyutya tu, tacuan ta sa sito ndo vatyi sa cua nducahñi. ");
INSERT INTO mihNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ta tacuan tucu tatu sa ndyehe ndo vatyi sa cuu tandɨhɨ tuhun sa quehin sihin ndo ihya, tacuan ta cua coto ndo vatyi sa cua cuyatyi sa cunaa ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sa ndisa catyi sihin ndo vatyi cua cuu cuhva ya cuee ca sa cuu ñiyɨvɨ sa iyo vityi. ");
INSERT INTO mihNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yutyi andɨvɨ ta ñuhu ñuu ñiyɨvɨ cunaa si, zoco tuhun quehin, ma naa si. ");
INSERT INTO mihNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Zoco yoñi ñiyɨvɨ sito ñaa quɨvɨ a ñaa cuhva cua cuu si. Nu ángel andɨvɨ ta ña sito ra ta nu Zehe ra Ndyoo. Maa tuhun ñi ra Ndyoo Zuti sito. ");
INSERT INTO mihNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cuɨñɨ vaha ndo sa quehin; cuyucu listo ndo, ta cahan ndo sihin ra Ndyoo vatyi ña sito ndo ñaa quɨvɨ cua cuu si. ");
INSERT INTO mihNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tañi minoo cuhva sii minoo ra cua cuhun nu sica, cuee ca sa quita ra vehe ra saha ra cuenda sii muzu ra. Saha cuenda ra ɨɨn ɨɨn tyiño zacuu ra. Ta saha ra tyiño sii ra zacuenda yuvehe ra vatyi zacuenda vaha ra. Ta tañi ra cuhun nu sica cui. ");
INSERT INTO mihNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yucuan cuenda cundyaa listo ndo vatyi ña sito ndo ñaa cuhva cua quisi, tañi ña sito muzu cuan ñaa cuhva cua quisi patrón ra, a nu cuu tyahan a maa ñuu a cuhva sacu ndɨvɨ a ñaha ñi. ");
INSERT INTO mihNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Cuatu vaha ndo, coto yatyi xaan quisi ta ña ndatu listo ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Quehin cuhva ya sihin maa ndo ta sihin tandɨhɨ cuii ñiyɨvɨ: Cuyucu listo ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Cumañi uu ca quɨvɨ ta cua tahan si vico sihi mvee ticatyi, quɨvɨ sasi ñiyɨvɨ pan ña ndaa. Ta ra zutu nahnu sihin ra maestro cuenda ley nducu ra cuhva yozo caa cua tɨɨn xehe ra sii ra Jesús. Ta cua cahñi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Zoco i catyi ra: Ña vaha vityi vatyi iyo vico. Ta coto cahñi tahan ñiyɨvɨ sihin yo. ");
INSERT INTO mihNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ñoho ra Jesús ñuu Betania vehe ra Simón, ra i cuhu cuehe tyahyu. Ta cuhva sa ndyaa ra mesa ta i tuhva minoo ñaha sii ra. Ñaa ña minoo yutyi ñoho azetye vixi. Nañi si nardo, ta yahvi xaan ndyaa si. I tahvi ña yutyi, ta i tyozo ña azetye vixi cuan xiñi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ta ñiyɨvɨ yucu yucuan i cuxaan ñu sihin ña, ta i nducu tuhun tahan ñu. Ta catyi ñu: ¿Ñacu zatɨvɨ ña azetye vixi cuan? ");
INSERT INTO mihNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Vaha ca tatu sa i xico ña sii si, ta ñihi ña tañi uu mil peso ta tyindyee ña sii ñiyɨvɨ ndahvi. Ta xaan xaan i cahan ñu sihin ña. ");
INSERT INTO mihNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ta i catyi ra Jesús: Zandɨhɨ ndo tuhun sihin ña. ¿Ñacu cuyuhu xaan ndo sihin ña? Vaha xaan i zavaha ña sihin. ");
INSERT INTO mihNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tandɨhɨ tyiemvu cua coo ñiyɨvɨ ndahvi sihin ndo. Ta cua cuu zavaha ndo sa vaha sihin ñu ñaa quɨvɨ cuñi ndo, zoco yuhvi, ma cundyei sihin ndo tandɨhɨ tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","I zavaha ñaha ya minoo sa vaha. Tañaha ca cua quɨhvi si ñuhu. Zoco i tyozo ña azetye vixi coño ñuhi cuee ca sa cui ta cuhin nuñaña. ");
INSERT INTO mihNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ndisa cuii sa quehin sihin ndo vatyi vazu ndyacamaa nacatyi ñiyɨvɨ Tuhun Ndyoo sihin ñiyɨvɨ, zoco cua nacatyi ñu cuhva i zavaha ña ya sihin, ta cua nacohon iñi ñiyɨvɨ sii ña. Tacuan i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yaha cuan ta zɨquɨ minoo sa usi uu tahan ra i casi ra Jesús, ra sa nañi Judas Iscariote, cuahan ra cua cahan ra sihin ra zutu nahnu vatyi cuñi ra xico ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Zɨɨ xaan i cuñi ra zutu nahnu sihin sa i catyi ra, ta i catyi ra vatyi cua tyiyahvi ra sii ra. Ta zɨquɨ i quisaha nducu ra Judas cuhva cua cuhva cuenda ra sii ra Jesús sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Quɨvɨ i quisaha vico sa sasi ñiyɨvɨ pan ña ndaa ta i sahñi ñu mvee ticatyi vatyi tyaa ñu yahvi sii ra Ndyoo. Ta quɨvɨ cuan i ndaca tuhun ra i casi ra Jesús sii ra ta catyi ra: ¿Ndyamaa cuñun vatyi cua zanduvaha ndi nu cua cuxiñun sa cuenda vico ya? ");
INSERT INTO mihNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tacuan ta i tasi ra Jesús sii uu tahan ra ta catyi ra sihin ra: Cuahan ndo ndya ñuu cahnu. Ta yucuan cua nañihi ndo sii minoo ra; ndyizo ra minoo quɨyɨ ndutya. Cundyico ndo sii maa ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ta nu quɨhvɨ ra cahan ndo sihin sitoho vehe cuan ta catyi ndo: “Catyi ra Maestro: ¿Ndyamaa iyo cuarto nu cua casi ra xita sa cuenda vico ya sihin ra i casi ra?” ");
INSERT INTO mihNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ta cua zañaha ra minoo cuarto cahnu ndya zɨquɨ. Sa yaha nduvii si. Yucuan zanduvaha ndo sa cuxiñi yo. Tacuan i catyi ra Jesús sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ta cuahan ra cuan ta i saa ra ndya ñuu ta i nañihi ra cuarto cuan tañi cuhva i catyi ra Jesús. Ta i zanduvaha ra sa cuxiñi ra vico zuhun cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ta sa sa cuaa cuan i saa ra Jesús yucuan sihin sa usi uu tahan ra i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ta nɨɨ ñi sa sasi ra xita i catyi ra Jesús sihin ra: Sa ndisa catyi sihin ndo vatyi minoo ndoho sa sasi sihin ihya, cua xico ra sii. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ta i nducuihya xaan iñi ra ndɨhɨ sihin ra, ta i quisaha ndaca tuhun minoo minoo ra sii ra Jesús: ¿Atu yuhvi cui? ");
INSERT INTO mihNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ta i nacahan ra Jesús ta catyi ra: Minoo sa usi uu tahan ndo sa sasi sihin ɨɨn ñi coho ya cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cuahan ra i quisi ndya gloria cuhva catyi Tuhun Ndyoo, zoco ¡ndahvi ñi cuu ra xico sii! Vaha ca tatu sa ñá cacu ra vatyi cua ndyehe xaan ra tundoho. ");
INSERT INTO mihNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ta cuhva sa cuxiñi ra i quihin ra Jesús pan, ta i saha ra tyahvi ndyoo sii ra Ndyoo, ta zɨquɨ i sahnu ra sii si ta saha ra sii si sii ra i casi ra, ta i catyi ra: Quihin ndo sii si ta casi ndo. Ihya cuu tañi coño ñuhi. ");
INSERT INTO mihNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tacuan ta i quihin ra minoo vaso ñoho vino, ta i saha ra tyahvi ndyoo sii ra Ndyoo, ta i saha ra sii si sii ra, ta i sihi tandɨhɨ ra zuhva zuhva si. ");
INSERT INTO mihNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ta i catyi ra Jesús sihin ra: Ihya cuu tañi nɨñi. Cua cati si sa cuenda cuaha xaan ñiyɨvɨ. Vityi zandaa ra Ndyoo minoo tyiño saa. Cua zandasi ra cuatyi ñiyɨvɨ sihin nɨñi. ");
INSERT INTO mihNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sa ndisa catyi sihin ndo vatyi ma coho que vino ndya cua cohi sii si minoo cuhva saa nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","I sata tandɨhɨ ra minoo yaa Ndyoo, ta zɨquɨ cuahan ra ndya yucu Olivos. ");
INSERT INTO mihNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tacuan ta i catyi ra Jesús sihin ra: Sa cuaa vityi tandɨhɨ cuii ndo cua zandoo ndo sii. Ta ma cuñi ca ndo cundyico ndo sii, vatyi catyi Tuhun Ndyoo: “Cua cuu ra cu pastor, ta cua quɨtɨ cuatyi tandɨhɨ cuii mvee ticatyi zono ra.” ");
INSERT INTO mihNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Zoco sa yaha nandote ta cua cuhin yatyi ca ta zɨquɨ maa ndo ndya Galilea. ");
INSERT INTO mihNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ta zɨquɨ i catyi ra Pedro sihin ra: Vazu zandoo tandɨhɨ ca ra ya suun, zoco yuhvi cua cundyique suun. ");
INSERT INTO mihNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ta i catyi ra Jesús sihin ra: Sa ndisa catyi suhun vatyi zuun ñi sa cuaa vityi, cuee ca sa vacu saa ndɨvɨ tyahnu uu yuhu tɨ, cua catyun uñi tahan saha vatyi ña siton sii. ");
INSERT INTO mihNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ta ñihi xaan i cahan ra Pedro ta catyi ra: Vazu cui suhun, zoco ma catyi sa ña site suun. Ta tacuan tucu i cahan tandɨhɨ ca ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tacuan ta zɨquɨ i saa ra Jesús sihin ra i casi ra ndya minoo nu yucu yutu tyaqui nu nañi si Getsemaní, ta i catyi ra sihin ra: Cundyaa ndo ihya vatyi cuehin cua quehin sihin ra Ndyoo ityi nuu ca. ");
INSERT INTO mihNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ta i quihin ra Jesús sii ra Pedro ta ra Jacobo ta ra Juan cuahan sihin ra, ta i quisaha nducuihya xaan iñi ra, ta ndahvi xaan cuñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tacuan ta i catyi ra sihin ra: Cuihya xaan cuñi añime cuhva ndya sa cuñi cui. Ndoo ndo ihya ñi ta cundyaa tyacu ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ta zɨquɨ cuahan ra Jesús zuhva ca ityi nuu, ta i sicava ndyayu ra nu ñuhu, ta i sica tahvi ra sii ra Ndyoo sa ma ndyehe ra tundoho sa cua cuu sii ra tatu sa vatyi cuu cuhva cuan. ");
INSERT INTO mihNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ta cuhva sa sica tahvi ra sii ra Ndyoo i catyi ra: Ndyoo Zuti, cuu tandɨhɨ suun. Tyindyeun sii sa ma ndyehi tundoho cuan, zoco ma cuhvon tañi cuñi mi. Nacuu si tañi cuñi moo. ");
INSERT INTO mihNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tacuan i catyi ra Jesús, ta zɨquɨ i sahan ra nu yucu ra ndɨhɨ sihin ra, ta i ndyehe ra sii ra quixi ra, ta i catyi ra sihin ra Pedro: Simón, ¿a quixun? ¿Ñacu ñá cuu cundyaa tyacu ndo sihin numinoo ora? ");
INSERT INTO mihNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Cutyacu ndo ta cahan ndo sihin ra Ndyoo coto nducu coto ihñi cuihna sii ndo. Cuñi ndo zavaha ndo sa vaha, zoco ña cuu sii ndo sa maa tuhun ñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tacuan ta i sahan tucu ra Jesús inga saha sa cua cahan ra sihin ra Ndyoo, ta zuun ñi tuhun cuan i cahan ra inga saha. ");
INSERT INTO mihNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ta zɨquɨ i nasaa ra, ta i ndyehe ra sii ra ndɨhɨ sihin ra quixi tucu ra vatyi sitatu xaan ra, ta ñá ñihi ra cuhva ñaa sa cua cahan ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ta i sahan ra Jesús ta i naquita tucu ra nu yucu ra sa cu uñi saha, ta i catyi ra: ¿Atu quixi ndo? ¿Atu quitatu ndo? Vaha ñi vityi. Sa saa cuhva cua nacuhva ñiyɨvɨ sii ra i quisi ndya gloria sii ra iyo cuatyi. ");
INSERT INTO mihNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ta nduvita ndo. Coho yo. Sa vasi ra xico sii. ");
INSERT INTO mihNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nu cahan ca ra Jesús, ta i saa ra Judas; minoo sa usi uu tahan ra i casi ra Jesús cuu ra. Ta i quisi cuaha xaan ñiyɨvɨ sihin ra. Ñaa ra mityi ta yutu. I tasi ra zutu nahnu ta ra maestro cuenda ley ta ra mandoñi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ra sa xico sii ra Jesús, i saha ra minoo cuhva sii ra cuan, ta catyi ra: Ra cua cohi xɨtɨ cuan, yucuan cuu ra tɨɨn ndo. Tɨɨn vaha ndo sii ra, ta quihin ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ta i saa ra Judas, ta i tuhva ra sii ra Jesús ta catyi ra: Nacumi suun, Maestro. Ta i sihi ra xɨtɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ta zɨquɨ i tɨɨn ñiyɨvɨ cuan sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ta minoo ra ndɨhɨ sihin ra Jesús, i tava ra mityi ra, ta i cañi ra sii ra cu muzu ra cu zutu ya cahnu, ta i sahndya ra zoho ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ta zɨquɨ i catyi ra Jesús sihin ñiyɨvɨ cuan: ¿Atu vasi tɨɨn ndo sii minoo ra zuhu vatyi ñaa ndo mityi ta ndaha tyiño xaan? ");
INSERT INTO mihNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tahan tahan quɨvɨ i sehin vehe ñuhu cahnu ta i zacuehi sii ñiyɨvɨ, zoco ñá tɨɨn ndo sii yucuan. Zoco vityi zavaha ndo cuhva ña vaha ya vatyi tacuan ta cua naquita si cuhva catyi Tuhun Ndyoo sa cuende. ");
INSERT INTO mihNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ta sa yaha cahan ra Jesús cuhva cuan ta zɨquɨ i zandoo tandɨhɨ ra i casi ra sii ra ta i sino ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","I sindyico minoo ra yoco sii ra Jesús, ta ndisi ra minoo ñi zahma cahnu. Ta i tɨɨn zandaru sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Zoco i zandoo ra zahma ra ta cuahan vavihi ra ñɨɨ ndɨɨ ñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","I sindyaca ra sii ra Jesús nu titahan ra cu zutu ya cahnu sihin ra zutu nahnu ta ra mandoñi ta ra maestro cuenda ley. ");
INSERT INTO mihNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ta i sindyico ra Pedro sica sica ñi ndya cuhva ndya saa ra nuquehe vehe ra cu zutu ya cahnu, ta yucuan i quɨhvɨ ra ta i sicundyaa ra sihin ra policía yunuhu vatyi visi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ra zutu nahnu sihin tandɨhɨ inga ra cu tyiño hebreo, i oanducu xaan ra ñiyɨvɨ cua cuhva sa ndaa sa cuenda ra Jesús vatyi cuñi ra cahñi ra sii ra. Zoco ñá ñihi ra cuhva sa yatyi ");
INSERT INTO mihNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","vazu cuaha ñiyɨvɨ saha sa ndaa ta i cahan ra cuendu zɨquɨ ra Jesús, zoco ñá nacasi tahan sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ndya nu ndɨhɨ tuhun i ñihi ra sii uu tahan ra, ta i cahan ra cuendu sata ra Jesús ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","I siñi ndi catyi ra: “Cua cani vehe ñuhu cahnu ra Ndyoo sa i zavaha ñiyɨvɨ, ta sisi sa uñi quɨvɨ ñi ta cua zandei inga si sa yɨvɨ ñiyɨvɨ zavaha.” ");
INSERT INTO mihNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tacuan i catyi ra cuan, zoco zuun ñi ñá nacasi tahan cuhva i cahan ra sa cuenda ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ta zɨquɨ i nduvita ra cu zutu ya cahnu nu yucu ra cuan. Ta i ndaca tuhun ra sii ra Jesús ta catyi ra: ¿Ñacu ña cohon ndaha ñi? ¿Ñaa sa cuu sa cahan ñiyɨvɨ ya zɨcun? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Zoco ñá nacahan maa ra Jesús. Ta i ndaca tuhun tucu ra cu zutu ya cahnu sii ra inga saha ta catyi ra: ¿Atu ra Cristo cuun? ¿Atu zehe ra Ndyoo ra ii xaan cuun? ");
INSERT INTO mihNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ta i catyi ra Jesús sihin ra: Zuun ra cui, ta cua ndyehe ndo sii ra i quisi ndya gloria cuhva cundyaa ra siyo cuaha ra Ndyoo ta cuhva cua quisi ra ndya andɨvɨ sisi vico. ");
INSERT INTO mihNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tacuan i catyi ra Jesús, ta zɨquɨ ra cu zutu ya cahnu, i cuxaan ra, ta i ndata ra zuun ñi zahma maa ra, ta i catyi ra: ¿Ñaa ca sa ndaa cuñi si vityi? ");
INSERT INTO mihNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sa siñi ndo sa cahan ra ndya vaha ñi sii ra Ndyoo. ¿Ñaa catyi ndo vityi? Ta i nacahan tandɨhɨ ra ta i catyi ra vatyi nacuu ra vatyi iyo cuatyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ta zɨquɨ i quisaha tyicu zɨɨ ra nuu ra, ta i sihñi ra nuu ra, ta i cañi ra sii ra ta catyi ra sihin ra: ¡Nacoton yoo ra cañi suun! Ta i cati ra policía nuu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ta ndyaa ra Pedro nuquehe, ta i tuhva minoo muzu ra cu zutu ya cahnu cuan sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ta sa ndyehe ña vatyi ndyaa ra Pedro cuan yunuhu cuan nduvixi ra ta i ndyehe vaha ña sii ra ta catyi ña: Cutahan aan sica noon sihin ra Jesús, ra ñuu Nazaret. ");
INSERT INTO mihNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Zoco i catyi ra Pedro: Ña site sii ra cuan, ta ña site ñaa tuhun cohon. Catyi ra. Ta i sɨñɨ siyo ra zuhva, ta zɨquɨ i sacu saa minoo ndɨvɨ tyahnu. ");
INSERT INTO mihNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ta i nandyehe ña cu muzu cuan sii ra inga saha ta catyi ña sihin ra yucu yucuan: Ra tahan ra Jesús cuu minoo ra ya. ");
INSERT INTO mihNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ta i catyi tucu ra Pedro vatyi ña ndisa. Ta cuee ca i catyi tucu ra yucu cuan inga saha sihin ra Pedro: Ndisa cuii vatyi minoo ra tahan ra cuu tucu oo vatyi cohon tañi cahan ñiyɨvɨ nu cu si Galilea. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tacuan ta i cahan ra Pedro ndya vaha ñi ta i tyiñaha ra ndyoo ta catyi ra: Ña site sii ra cahan ndoho tuhun. ");
INSERT INTO mihNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ta zuun ñi caa cuhva cuan, i sacu saa ndɨvɨ tyahnu sa cu uu yuhu tɨ. Ta zɨquɨ i nacohon iñi ra Pedro cuhva i catyi ra Jesús sihin ra: “Cuee ca sa vacu saa ndɨvɨ tyahnu sa cu uu yuhu tɨ, yoho cua catyun uñi saha vatyi ña siton sii.” Ta sa nacohon iñi ra Pedro cuhva cuan, i sacu xaan ra vatyi i nducuihya xaan iñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ta sa cundisi i zandoo ra tyiño, tandɨhɨ ra zutu nahnu ta ra mandoñi ta ra maestro cuenda ley ta tandɨhɨ inga ra cu tyiño hebreo. Ta i sihñi ra sii ra Jesús, ta i sindyaca ra sii ra nu ndyaa ra Pilato (ra cu gobernador). ");
INSERT INTO mihNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ta i ndaca tuhun ra Pilato sii ra Jesús ta catyi ra: ¿Atu yoho cuu rey cuenda ñiyɨvɨ hebreo? Ta i catyi ra Jesús: Tacuan cu si tañi catyi moo. ");
INSERT INTO mihNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tacuan ta i tyaa ra zutu nahnu cuatyi sata ra Jesús cuaha xaan cuhva. ");
INSERT INTO mihNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ta zɨquɨ i ndaca tuhun ra Pilato sii ra inga saha ta catyi ra: ¿Ñacu ña cohon ndaha cuii ñi? Ta cuaha xaan cuhva tyaa ra ya cuatyi saton. ");
INSERT INTO mihNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Zoco ñá cahan ra Jesús ndaha cuii ñi. Ta iyo xaan i cuñi ra Pilato. ");
INSERT INTO mihNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ta vico cuan tuhva ra Pilato tava sii minoo ra ñoho vehe caa, yoo ra cua catyi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ta quɨvɨ cuan siñoho minoo ityi ra i sahñi tahan sihin ra cu tyiño. Minoo ra cuan nañi ra Barrabás, ta ñoho ra vatyi sahñi ra ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ta i quisi cuaha xaan ñiyɨvɨ ta i sica ñu sii ra Pilato vatyi tava ra sii minoo ra ñoho vehe caa cuhva tuhva ra zavaha tahan cuiya. ");
INSERT INTO mihNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ta i ndaca tuhun ra Pilato sii ñu: ¿Atu cuñi ndo vatyi cua tave sii ra cu rey sii maa ndo ñiyɨvɨ hebreo? ");
INSERT INTO mihNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tacuan i catyi ra Pilato vatyi sito ra vatyi i nacuhva cuenda ra zutu nahnu sii ra Jesús sii ra vatyi cucuihna xaan iñi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Zoco ñihi xaan i tyihi ra zutu nahnu tyiño sihin ñiyɨvɨ vatyi nacaca ñu sii ra Barrabás. ");
INSERT INTO mihNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ta zɨquɨ i ndaca tuhun ra Pilato inga saha ta catyi ra: ¿Ta ñaa sa cuñi ndo cua zavehi sihin ra zacunañi ndo rey sii ñiyɨvɨ hebreo? ");
INSERT INTO mihNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ta i cana saa ñu ta catyi ñu: ¡Nacuu ra nu cruz! ");
INSERT INTO mihNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ta i catyi ra Pilato sihin ñu: ¿Ñaa cuenda? ¿Ñaa sa ña vaha i zavaha ra? Zoco i cana saa ñu ñihi ca ta catyi ñu: ¡Nacuu ra nu cruz! ");
INSERT INTO mihNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","I cuñi ra Pilato coo vaha ra sihin ñiyɨvɨ, ta yucuan cuenda i tava ra sii ra Barrabás. Ta i nacuhva cuenda ra sii ra Jesús vatyi cua ndoho ra sihin cuarta ta zɨquɨ cua cuu ra nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ta i quihin zandaru sii ra Jesús, ta i sindyaca ra sii ra sisi vehe tyiño cahnu, ta i cana ra sii tandɨhɨ inga zandaru. ");
INSERT INTO mihNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ta zɨquɨ i natyihi ra minoo zahma tixinda sii ra Jesús, ta i tyihi ra minoo corona iñu xiñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ta i quisaha sacu ndyaa ra sii ra. I cana saa ra ta catyi ra: ¡Nacumi suun tata; yoho cuu rey sii ñiyɨvɨ hebreo! ");
INSERT INTO mihNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","I cañi xaan zandaru tuyoo caxtyila xiñi ra Jesús, ta i tyicu zɨɨ ra sii ra. Ta i sicuɨñɨ sɨtɨ ra nuu ra ta sacu ndyaa ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ta sa yaha sacu ndyaa ra sii ra, i tava ra zahma tixinda cuan, ta i natyihi ra zahma maa ra sii ra. Ta zɨquɨ i quihin ra sii ra vatyi cua cahñi ra sii ra nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ta cuhva sa cuahan ra ityi i tahan ra sii minoo ra ñuu Cirene. I quita ra sicuhu ta vasi ra ndya ñuu Jerusalén. Simón nañi ra. Zutu ra Alejandro sihin ra Rufo sii ra. Ta i zacuizo zandaru cuan cruz ra Jesús sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ta cuahan tandɨhɨ ra nu nañi si Gólgota. Tuhun Gólgota cuan cuñi si catyi si Nu Yucu Yɨquɨ Xiñi Ndɨyɨ. ");
INSERT INTO mihNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ta i saha ra vino zaca si sihin minoo sa nañi mirra vatyi coho ra Jesús, zoco ñá sihi ra sii si. ");
INSERT INTO mihNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ta sa yaha tyaa ra zandaru sii ra Jesús nu cruz, ta zɨquɨ i sizɨquɨ ra vatyi cua ndyehe ra yoo ra cua zahacanaa minoo minoo zahma ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Caa ɨɨn sa ñaha ñi cuu cuhva i tyaa ra sii ra Jesús nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ta xiñi cruz cuan ndyaa letra i tyaa ra ta saha cuenda si ñaa sa cuu cuatyi ra. Tyehen catyi si: “Rey cuenda ñiyɨvɨ hebreo.” ");
INSERT INTO mihNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","I sañi ra cruz sa ndyaa minoo ra zuhu nuu siyo cuaha ra Jesús, ta inga ra siyo zatyi. ");
INSERT INTO mihNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Cuhva cuan i quita si cuhva catyi Tuhun Ndyoo nu catyi si: “Cua catyi ñiyɨvɨ vatyi ra iyo cuatyi cuu ra.” ");
INSERT INTO mihNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","I yaha ñiyɨvɨ nu ndyaa ra Jesús, ta i sacu ndyaa ñu sii ra, ta zavico xiñi ñi ca ñu. Ta catyi ñu: Yoho ra catyi vatyi cua canun vehe ñuhu ta uñi quɨvɨ ñi ta cua zanduvohon sii si, ");
INSERT INTO mihNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","zacacun suun ta noon nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tacuan tucu ra zutu nahnu sihin ra maestro cuenda ley, i sacu ndyaa ra sii ra. Ta i catyi ra sihin ra tahan ra: I zacacu ra sii inga ñiyɨvɨ, zoco ña cuu zacacu ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tatu cua noo ra nu cruz, tacuan ta cua sino iñi yo vatyi ra Cristo cuu ra. Ta rey sii maa yo ñiyɨvɨ hebreo cuu ra. Catyi ra cuan. Ta tacuan tucu ndya cuhva ndya ra zuhu, ra sihi ɨɨn ñi sihin ra Jesús, ta i cahan tucu ra ndya vaha ñi sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ta cuhva maa ora i nduñaa xaan nacahnu ñuu ñiyɨvɨ ndya cuhva ndya caa uñi sa sahiñi. ");
INSERT INTO mihNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ta cuhva caa uñi cuan i cana saa ra Jesús minoo sa ñihi xaan, ta i catyi ra: Elí, Elí, ¿lama sabactani? Cuñi si catyi si: Zutu mañi yu, Zutu mañi yu, ¿ñaa cuenda i zandoon sii? ");
INSERT INTO mihNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Zuhva ñiyɨvɨ nandyaa yucuan, i siñi ñu ta catyi ñu: Tyizoho ndo; cana ra sii ra profeta Elías. ");
INSERT INTO mihNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ta zuun ñi caa cuhva cuan i cacono minoo ra, ta i quihin ra sii minoo sa ñahma, ta i zatyii ra sii si sihin ndutya iya. I tyaa ra sii si nu minoo yutu, ta i zandaa ra sii si nu ndyaa ra Jesús vatyi cua coho ra ta catyi ra: Cuatu noo, nandyehe yo tatu cua quisi zanoo ra Elías sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","I sacu saa ra Jesús inga saha minoo sa ñihi xaan, ta zɨquɨ i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Zuun ñi caa cuhva cuan, i ndata zava zahma coco sa ndita sisi vehe ñuhu cahnu ndya zɨquɨ ta ndya xuu. ");
INSERT INTO mihNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ta minoo ra cu nuu sii minoo ziendu zandaru i iñi ndyaa ra ityi nuu ra Jesús. Ta sa ndyehe ra cuhva i sacu saa ra ta cuhva i sihi ra, i catyi ra: Ndisa cuii ra ihya vatyi zehe Ndyoo cu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ndya zava ñi i siyucu cuaha xaan ñu zɨhɨ. Ndyehe ñu sii ra Jesús. Minoo ña nandyaa sihin ñu nañi ña María Magdalena. Inga ña cuu ña María zɨhɨ ra Jacobo, ra luhlu ca, ta ra José. Ta inga ña nañi ña Salomé. ");
INSERT INTO mihNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yucuan ñu cuu ñu i sindyico sii ra ta i tyindyee ñu sii ra quɨvɨ i sica noo ra nu cu si Galilea. Ta sihin inga ñu cuan i quisi ñu ndya ñuu Jerusalén sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ta sahiñi viarni i cuu si, quɨvɨ zanduvaha ñiyɨvɨ sa cua casi ñu zavuru vatyi zavuru cuu quɨvɨ tuhva ñu quitatu. ");
INSERT INTO mihNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ta i quisi ra José ra ñuu Arimatea. Minoo ra mandoñi cuu ra ta catyi ñiyɨvɨ vatyi vaha xaan ñiyɨvɨ cuu ra. Ndatu ra quɨvɨ cua tasi ra Ndyoo minoo ra cua cundyaca ñaha ñuu ñiyɨvɨ. Ñá yuhu ra, ta i sahan ra nu ndyaa ra Pilato, ta i sica ra tumañi iñi sii ra vatyi cuu quihin ra coño ñuhu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Iyo xaan i cuñi ra Pilato vatyi yatyi xaan i sihi ra Jesús. Ta i cana ra sii ra ndyaca ñaha sii zandaru, ta i ndaca tuhun ra sii ra tatu sa tañi i sihi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ta cuhva sa sito ra Pilato vatyi catyi ra cuan vatyi sa sihi ndisa cuii ra Jesús, ta zɨquɨ i saha ra Pilato sa quihin ra José coño ñuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","I zata ra José minoo zahma vaha. I zanoo ra coño ñuhu ra Jesús, ta i cava noo ra zahma cuan sii si, ta i saqui ra sii si sisi minoo ñaña sa zavaha ñiyɨvɨ sisi yuu. Ta i tyazi ra yuhu ñaña cuan sihin minoo yuu cahnu. ");
INSERT INTO mihNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","I ndyehe ña María Magdalena sihin ña María zɨhɨ ra José nu i tyihi ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","I yaha quɨvɨ quitatu ñiyɨvɨ hebreo. Ta zɨquɨ i zata ña María Magdalena ta ña María zɨhɨ ra Jacobo ta ña Salomé ndutya vixi xaan sahan vatyi cua natyihi ñu sii coño ñuhu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta ñaha cuii ñi quɨvɨ tumingu i saa ñu ndya ñaña cuan cuhva sa caña ñicandyi ñi. ");
INSERT INTO mihNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ta i natuhun tahan ñu ta catyi ñu: ¿Yoo ra cua tyaa siyo yuu sa ndazi yuñaña cuan? ");
INSERT INTO mihNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tacuan ta i ndyehe ñu vatyi yuu cahnu sa sindazi yuñaña cuan sa sɨñɨ siyo si. ");
INSERT INTO mihNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ta i quɨhvɨ ñu sisi ñaña cuan. Ta yucuan i ndyehe ñu minoo ángel. Tañi caa minoo ra yoco caa ra. Nandyee ra nu i cuu si siyo cuaha ra Jesús. Ñoho ra minoo zahma cañi. Cuisi xaan si. Ta iyo xaan i cuñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Zoco i catyi ángel cuan sihin ñu: Ma yuhu ndo. Nanducu ndo sii ra Jesús, ra ñuu Nazaret, ra i sihi nu cruz. Zoco sa i nandoto ra. Yoñi ca ra ihya. Ñaha ndo, ta ndyehe ndo nu i caa coño ñuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ta vityi cuahan ndo ta nacatyi ndo sihin ra i casi ra ta sihin ra Pedro. Tyehen catyi ndo: “Xihna ca ra Jesús cuahan ndya Galilea ta zɨquɨ maa ndo. Yucuan cua ndyehe ndo sii ra, tañi sa nacatyi ra sihin ndo.” ");
INSERT INTO mihNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tacuan ta yatyi cuii ñi i quita ñu zɨhɨ cuan ñaña cuan. I cacono ñu. Iyo xaan i cuñi ñu. Nɨhɨ tacuan ñi ca ñu. Ta ñá nacatyi maa ñu nu sihin minoo ñiyɨvɨ vatyi yuhu xaan ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ta sa yaha nandoto ra Jesús, ta ñaa ca quɨvɨ tumingu xihna cuii ca i quituu ra nuu ña María Magdalena, ñaha sa i tava ra usa tahan tatyi cuihna. ");
INSERT INTO mihNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ta cuahan ña, ta i nacatyi maa ña sihin amigo ra Jesús vatyi i nducuihya xaan iñi ra. Ta sacu xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ta sa siñi ra sa catyi ña vatyi ndito ra Jesús ta sa ndyehe ña sii ra, ñá sino iñi ra. ");
INSERT INTO mihNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tacuan ta i quituu tucu ra Jesús inga saha nuu uu tahan amigo ra ityi cuahan ra sicuhu. ");
INSERT INTO mihNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ta i sahan ra cuan, ta i nacatyi ra sihin inga ra, zoco ñá sino tucu iñi ra sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tacuan ta i quituu tucu ra Jesús nuu sa usi ɨɨn tahan ca ra i casi ra zuun ñi cuhva sa yucu ra mesa sasi ra xita. Ta i ndaca tuhun ra Jesús sii ra ñaa cuenda ña sino iñi ra sa nandoto ra vazu sa ndyehe ra tahan ra sii ra ta nacatyi ra sihin ra. Ta i catyi ra Jesús sihin ra vatyi ñihi xaan iñi ra ta ña nɨɨ maa iñi ra ndaha ñi. ");
INSERT INTO mihNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ta i catyi tucu ra Jesús sihin ra: Cuahan ndo nacahnu ñuu ñiyɨvɨ, ta zacoto ndo sii tandɨhɨ ñiyɨvɨ Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tatu sino iñi ñu ta coo ndutya ñu cua cacu ñu. Ta ñiyɨvɨ ña sino iñi, ma ñihi tahvi añima ñu gloria. ");
INSERT INTO mihNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Cua coo zeña sihin tandɨhɨ ñiyɨvɨ sino iñi sii. Tyehen cua zacuu ñu ta cua coto inga ñiyɨvɨ vatyi zacuaha ñu sa ndisa. Cua cutyiño ñu zɨvi ta cua tava ñu tatyi cuihna. Cua cuu cahan ñu zahan sa ña tuhva ñu cahan. ");
INSERT INTO mihNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tatu cua tɨɨn minoo coo sii ñu a tatu cua coho ñu minoo sa xaan, ñahñi cua tahan ñu. Ta cua tyizo ñu ndaha ñu sii ñiyɨvɨ cuhu, ta cua nduvaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ta sa ndɨhɨ cahan ra Jesús ta i ndaa xica ñi ra ityi andɨvɨ, ta i sicundyaa ra siyo cuaha ra Ndyoo Zutu yo. ");
INSERT INTO mihNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ta i quita ra i casi ra, ta i zacoto ra Tuhun Ndyoo nacahnu ñuu ñiyɨvɨ. Ta zuun ñi ra Jesús i tyindyee sii ra vatyi saha ra Jesús sa zavaha ra cuaha xaan sa ndyityi. Ta tacuan ta i sito ñiyɨvɨ vatyi sa ndisa cuu sa zacuaha ra. Ndɨhɨ si vityi.");
INSERT INTO mihNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Sa cuaha xaan ñiyɨvɨ nducu ñu cuhva tyaa ñu cuhva yozo caa i sicoo sa minoo minoo cuhva sa sino iñi yo ");
INSERT INTO mihNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tañi i nacatyi ra sica noo sihin ra Jesús ndya ta xihna ñi, nu i quisaha zatyiño ra, ta i tyindyee ra cuan sihin tyiño ra. Ta i ndyehe ra tandɨhɨ sa zavaha ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ta yuhvi tucu, i nducu cote tandɨhɨ sa nacatyi ra cuan tatu ndisa cuii. Ta yucuan cuenda cuñi tyei sii si minoo minoo si vatyi coton, yoho Teófilo. ");
INSERT INTO mihNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Cuñi sa cua coton vatyi sa ndisa cuii cuu cuhva sa zacoto ñiyɨvɨ suun. ");
INSERT INTO mihNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Quɨvɨ i sindyaca ñaha ra rey Herodes nu cu si Judea, sicoo minoo ra cu zutu cuenda vehe ñuhu hebreo, ta i sinañi ra Zacarías. Siñoho ra minoo ityi ra cu zutu sa nañi Abías. Elisabet i sinañi ñazɨhɨ ra. Ta ra Aarón i cuu ñiyɨvɨ sahnu sii ña ta sa naha. ");
INSERT INTO mihNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ndoo xaan i cuu nduu tahan ñu ityi nuu ra Ndyoo vatyi i tyaa xaan ñu yahvi ley ra, ta yoñi i cuu tyaa cuatyi sata ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Zoco yoñi maa zehe ña Elisabet i sicoo. Ta sahnu xaan nduu tahan ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ta minoo quɨvɨ sa i tahan si sii ra Zacarías sa cua zatyiño ra ityi nuu ra Ndyoo ");
INSERT INTO mihNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","tañi sicoo costumbre cuenda ra cu zutu, ta i sizɨquɨ ra ta i tahan si sii ra Zacarías sa quɨhvɨ ra sisi vehe ñuhu cahnu nu ii, cua cahmi ra cutu ityi nuu ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ta nɨɨ ñi sa sahmi ra cutu sisi vehe ñuhu ta tandɨhɨ inga ñiyɨvɨ i siyucu ñu ityi sata ta cahan ñu sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ta i quituu minoo ángel ra Ndyoo ityi nuu ra Zacarías. Nandyaa ra ityi siyo cuaha nu sahmi ra cutu. ");
INSERT INTO mihNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ta sa ndyehe ra Zacarías sii ángel cuan, iyo xaan i cuñi ra, ta i yuhu xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Zoco i catyi ángel cuan sihin ra: Ma yuhun Zacarías vatyi i siñi ra Ndyoo sa cohon, ta cua ñihi ña Elisabet ñazɨhun minoo zehe, ta cua zacunañi ndo sii ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Zɨɨ xaan cua cuñun, ta cuaha xaan ñiyɨvɨ cua cuzɨɨ iñi vatyi cua cacu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Vatyi cahnu xaan cua cuu ra nuu Ndyoo. Ma coho ra vino ta nu ndixi. Ta cua cutu cuii Tatyi Ii sii ra ndya ta ñoho ra sisi zɨhɨ ra cuee ca sa cacu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ta sa cuenda maa ra, cuaha xaan ñiyɨvɨ hebreo cua sino iñi ñu sii ra Ndyoo, ra ndyaca ñaha sii yo. ");
INSERT INTO mihNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Cua zatyiño ra tyiño ra Ndyoo vatyi cua coo xaan Tatyi Ii ra Ndyoo sihin ra, ta cuaha xaan tundyee iñi ra Ndyoo cua coo sii ra. Ta cua cuu ra tañi ra Elías, ra cahan Tuhun Ndyoo ta sa naha. Sa cuenda maa ra ta cua coo sa taxi sii ñiyɨvɨ sahnu sihin zehe ñu. Ta sa cuenda maa ra ta ñiyɨvɨ quiñi iyo cua zama ñu cuhva iyo ñu, ta cua tyaa ñu yahvi. Cua zandulisto ra sii ñiyɨvɨ, ta cua tɨɨn cuenda vaha ñu sii ra ndyaca ñaha sii yo. Tacuan i catyi ángel cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ta i nducu tuhun ra Zacarías sii ángel cuan: ¿Yozo caa cuu cote tatu sa ndisa cuii cuu cuhva ya? Vatyi sa sahnu xein, ta sahnu xaan ñazɨhi. ");
INSERT INTO mihNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ta i catyi ángel cuan sihin ra: Yuhvi nañi Gabriel. Tuhve sica tyiño ra Ndyoo. Ta tasi ra sii, sa quehin suhun, ta zacote tuhun ya suun. ");
INSERT INTO mihNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ta vityi cua nduñɨhun, ta ma cuu cohon ndya quɨvɨ cua tahan si cuhva sa catyi suhun vatyi ña sino iñun sa quehin. Ta cua cuu tandɨhɨ si tañi sa catyi suhun, catyi ángel cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ta ñiyɨvɨ i sindatu sii ra Zacarías sata vehe ñuhu, iyo xaan i cuñi ñu vatyi naha xaan i ñoho ra sisi vehe ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ta zɨquɨ i quita ra, ta ñá cuu cahan ra sihin ñu, ta i sito ñu vatyi i ndyehe ra minoo sa ndyehe ra sisi vehe ñuhu. Ta i quisaha cahan ra sihin ñu sihin zeña ñi vatyi ña cuu cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tacuan i cuu si, ta i saa quɨvɨ sa ndɨhɨ ndyizo tyiño ra Zacarías vehe ñuhu cuan. Ta i sinuhu ra ndya vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ta sa yaha cuan ta zɨquɨ i ñihi ña Elisabet minoo zehe. Ta ñá quita ña sata vehe ohon tahan yoo, ta i sica iñi ña: ");
INSERT INTO mihNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Vaha xaan cuu cuhva zavaha maa ra Ndyoo sihin vatyi vityi ma cahan cuehe ca ñiyɨvɨ sii.” ");
INSERT INTO mihNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ta sa iñu yoo sa ñoho zehe ña Elisabet, ta zɨquɨ i tasi ra Ndyoo sii ángel Gabriel ndya nu cu si Galilea ndya minoo ñuu sa nañi Nazaret ");
INSERT INTO mihNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","vatyi cua cahan ra sihin minoo ñaha yoco sa cuñi tindaha sihin minoo ra sa nañi José. Ra rey David i cuu ñiyɨvɨ sahnu sii ra ta sa naha. Ta ñaha cuan, María nañi ña. ");
INSERT INTO mihNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","I quituu ángel cuan nu ndyaa ña, ta catyi ra: Nacumi suun. Saha xaan ra Ndyoo sa vaha suun. Maa ra ndyaa suhun. ");
INSERT INTO mihNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ta cuhva sa siñi ña sa cahan ángel cuan, ta iyo xaan i cuñi ña. Ta i sica iñi ña ñaa cuenda cahan ra cuhva cuan sihin ña. ");
INSERT INTO mihNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ta i catyi tucu ángel cuan sihin ña: Ma yuhun María vatyi saha xaan ra Ndyoo sa vaha suun. ");
INSERT INTO mihNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cua coo minoo zehun. Ta Jesús cua zacunañun sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Cahnu xaan cua cuu ra, ta cua cunañi ra Zehe ra Ndyoo ra cahnu ca. Ta cua zacuu ra Ndyoo minoo rey sii ra tañi i cuu ra David, ñiyɨvɨ sii ra ta sa naha. ");
INSERT INTO mihNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ta cua cundyaca ñaha ra sii ñiyɨvɨ hebreo tandɨhɨ cuii tyiemvu. Ta ma ndɨhɨ maa sa ndyaca ñaha ra. Catyi ángel cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tacuan ta i ndaca tuhun ña María sii ángel, ta catyi ña: ¿Yozo caa cuu si cuhva ya vatyi tañaha ca coo yɨi? Catyi ña. ");
INSERT INTO mihNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ta i catyi ángel cuan sihin ña: Tatyi Ii maa ra Ndyoo cua quisi zɨcun. Ta tundyee iñi sii Zutu mañi yo cua coo suhun. Yucuan cuenda lee sa cua cacu cuan cua cunañi ra Zehe ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ta tacuan tucu ña Elisabet tyixun. Sahnu xaan ña, zoco sa ñihi tucu ña minoo zehe. Tuhva xaan ñiyɨvɨ catyi vatyi ma cuu coo zehe ña, zoco vityi sa iñu yoo sa ñoho zehe ña ");
INSERT INTO mihNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","vatyi ñahñi sa ma cuu zavaha maa ra Ndyoo. Catyi ángel sihin ña. ");
INSERT INTO mihNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ta i catyi ña María: Muzu maa ra Ndyoo cui. Nazacuu maa ra sihin cuhva catyun. Catyi ña. Tacuan ta cuahan ángel cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ta quɨvɨ cuan numi ñi i quita ña María, ta yatyi xaan cuahan ña minoo ñuu nu maa yucu ñi cuu si, nu cu si Judea. ");
INSERT INTO mihNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ta i quɨhvɨ ña vehe ra Zacarías, ta i saha ña minoo nacumi sii ña Elisabet. ");
INSERT INTO mihNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ta cuhva sa siñi ña Elisabet sa cahan ña María ta i natyoño lee sa ñoho sisi ña, ta i situ cuii Tatyi Ii sii ña. ");
INSERT INTO mihNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ta saa xaan i cahan ña, ta catyi ña: Cuaha ca sa vaha saha ra Ndyoo suun ta zɨquɨ sii tandɨhɨ inga ñuzɨhɨ. Ta saha xaan ra sa vaha sii zehun sa ñoho sisun. ");
INSERT INTO mihNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ta ñaa ña cuu vii? ta vasi zɨhɨ ra ndyaca ñaha sii; vasi cahan ña sihin. ");
INSERT INTO mihNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ta zuun ñi cuhva sa siñi tuhun cohon, ta i natyoño lee sisi sihin sa zɨɨ xaan cuñi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Zɨɨ xaan cua cuñun, vatyi i sino iñun, ta cua cuu tuhun sa cahan ra Ndyoo suhun. Catyi ña Elisabet. ");
INSERT INTO mihNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ta i quisaha catyi ña María: Zacahni sii ra Ndyoo sihin tandɨhɨ cuii añime. ");
INSERT INTO mihNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ta zɨɨ xaan cuñi vatyi zacacu ra Ndyoo sii. ");
INSERT INTO mihNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Cundahvi iñi ra Ndyoo sii mi, ñaha ndahvi. Ta vityi tandɨhɨ tyiemvu cua catyi ñiyɨvɨ sihin vatyi saha xaan ra Ndyoo sa vaha sii. ");
INSERT INTO mihNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Vatyi ra Ndyoo ra cahnu ca cuu ra. Ta cahnu xaan cuu sa zavaha ra sihin. Ii xaan cuu zɨvɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ta cua cundahvi iñi ra sii tandɨhɨ ñiyɨvɨ yuhu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Cahnu xaan cuu tyiño zavaha ra. Cua tyaa siyo ra sii ñiyɨvɨ zacahnu sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Cua zanduluhlu ra sii ñu. Ta cua zanducahnu ra sii ñiyɨvɨ ndyihi. ");
INSERT INTO mihNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ñiyɨvɨ sa cuñi xaan coto sii ra, saha xaan ra sa vaha sii ñu. Ta ñu sica iñi vatyi sa vaha ñu, ñahñi cua cuhva ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tyindyee ra sii ñiyɨvɨ hebreo, ñu cuu muzu ra. Ña naa iñi ra sii ñu, ta cundahvi iñi ra sii ñu ");
INSERT INTO mihNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","tañi i catyi ra sihin ra Abraham siin yo ta sihin zehe ra. Catyi ña María. ");
INSERT INTO mihNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ta i ndoo ña María sihin ña Elisabet uñi yoo, ta zɨquɨ i sinuhu ña ndya vehe ña. ");
INSERT INTO mihNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","I saa quɨvɨ sa cua cacu zehe ña Elisabet, ta rayɨɨ i cuu zehe ña. ");
INSERT INTO mihNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ta ñiyɨvɨ sa yucu yatyi sihin ñu ta ñiyɨvɨ sii ña i sito ñu vatyi vaha xaan sa zavaha ra Ndyoo sihin ña. Ta zɨɨ xaan i cuñi ñu ɨɨn ñi sihin ña. ");
INSERT INTO mihNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ta sa cu uña quɨvɨ sa cacu lee cuan, ta i sahan ñu sa tahndya ñɨɨ xiñi xuu ra tañi catyi costumbre. Ta i zacunañi ñu sii ra Zacarías cuhva nañi zutu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Zoco i catyi zɨhɨ ra: Ña tacuan cuu si. Juan cua cunañi ra. Catyi ña. ");
INSERT INTO mihNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ta i catyi inga ñu sihin ña: ¿Ñaa cuenda cua zacunañun Juan sii ra? Yoñi ñiyɨvɨ sii ndo sa nañi tacuan. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ta i quisaha nducu tuhun ñu sihin zeña sii zutu ra vatyi cuñi ñu coto ñu ñaa zɨvɨ cuñi ra sa cunañi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ta i sica ra minoo vitu vatyi cua tyaa ra. Ta i tyaa ra zɨvɨ ra: Juan cuu zɨvɨ ra. Tyaa ra. Ta tandɨhɨ ñiyɨvɨ yucu yucuan, iyo xaan i cuñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ta zuun ñi caa cuhva cuan i cuu nacahan ra Zacarías, ta i quisaha zacahnu ra sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ta tandɨhɨ ñiyɨvɨ sa ndyaa yatyi yucuan i yuhu xaan ñu. Ta i sito tandɨhɨ ñiyɨvɨ yucu nu cu si Judea. ");
INSERT INTO mihNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ta tandɨhɨ ñiyɨvɨ sa siñi tuhun cuan, i sica iñi ñu ta catyi ñu sihin tahan ñu: ¿Ñaa ra cua cuu lee cuan? Catyi ñu. Ta i tyindyee xaan ra Ndyoo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ta i situ cuii Tatyi Ii sii ra Zacarías zutu ra. Ta i quisaha cahan ra tuhun sa saha ra Ndyoo sii ra. Ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Cahnu xaan cuu ra Ndyoo Zutu mañi yo, ra Ndyoo cuenda maa yo hebreo vatyi i quisi ra nu ndyaa yo, ta i zacacu ra sii yo. ");
INSERT INTO mihNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ta saha ra minoo ra cahnu sii yo; ñiyɨvɨ sii ra David muzu ra Ndyoo cua cuu sii ra, ta cua zacacu ra sii yo. ");
INSERT INTO mihNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tacuan i cahan ra Ndyoo sihin ra profeta ta sa naha. ");
INSERT INTO mihNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","I catyi ra vatyi cua zacacu ra sii yo ndaha ra xaan iñi sii yo ta sii ra ña cuu ndyehe sii yo. ");
INSERT INTO mihNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ta tañi sa catyi ra Ndyoo sihin ñiyɨvɨ sahnu sii yo, cua cundahvi xaan iñi ra sii yo. Ta ma naa iñi ra tuhun sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ihya cuu tuhun i catyi ra Ndyoo sihin ra Abraham siin sahnu yo. ");
INSERT INTO mihNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","I catyi ra vatyi cua zacacu ra sii yo sii ra xaan iñi sii yo, ta ma cuyuhu yo zacahnu yo sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Vatyi maa ra zanduvaha xaan sii yo ityi nuu ra. Ta zandundoo xaan ra sii yo tandɨhɨ quɨvɨ cua coo yo ñuu ñiyɨvɨ ya. Catyi ra Zacarías. ");
INSERT INTO mihNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ta i cahan ra Zacarías sa cuenda ra Ndyoo ta catyi ra sihin lee cuan: Ta yoho zehi, cua catyi ñiyɨvɨ vatyi minoo profeta ra Ndyoo cahnu cuun. Vatyi cua cuhun ityi nuu ra ndyaca ñaha sii yo, ta cua catyun sihin ñiyɨvɨ vatyi cua quisi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ta cua zacoton sii ñiyɨvɨ vatyi cua zandasi ra Ndyoo cuatyi ñu, ta cua zacacu ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Vatyi cuñi xaan ra Ndyoo sii yo. Ta cundahvi iñi ra sii yo, ta zaquisi ra sii minoo ra cua tyindyee sii yo. Tañi minoo ñúhu ñicandyi cua cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Vatyi sihin sa zañaha ra sii ñiyɨvɨ, natava ra sii ñu iyo nu ñaa sa cuenda cuatyi ñu. Yuhu ñu vatyi iyo ñu nu ñaa, ta cua cuu cuii ñu. Zoco cua zañaha ra sii ñu yozo caa cua quɨhvɨ ñu ityi vaha. Catyi ra Zacarías. ");
INSERT INTO mihNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ta ra luhlu cuan, i sahnu ra, ta i ndundyee ra sihin Tatyi Ii. Ta i sicoo ra minoo nu ityi xaan. Ta zɨquɨ cuee ca zañaha ra sii ra sii ñiyɨvɨ hebreo, ta i quisaha cahan ra sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ta quɨvɨ cuan sicoo minoo ra ndyaca ñaha sa nañi Augusto, ta i tasi ra tyiño vatyi cua coo minoo censo sii tandɨhɨ ñiyɨvɨ ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ta quɨvɨ cuan ndyaca ñaha ra Cirenio nacahnu nu cu si Siria. ");
INSERT INTO mihNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ta tahan si cunuhu tandɨhɨ ñiyɨvɨ ñuu ñu vatyi cua cuhva ñu zɨvɨ ñu yucuan. ");
INSERT INTO mihNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yucuan cuenda i quita ra José nu cu si Galilea ñuu Nazaret, ta cuahan ra nu cu si Judea ndya ñuu Belén. Yucuan cuu ñuu nu i cacu ra rey David ta sa naha. Cuahan ra José yucuan vatyi ñiyɨvɨ sii ra David cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Cuahan ra sa cua cuhva ra zɨvɨ ra sihin ña María vatyi sa cuñi tindaha ñu. Ta sa cuñi cacu zehe ña María. ");
INSERT INTO mihNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ta nɨɨ ñi sa ndyaa ñu yucuan, ta i tahan si quɨvɨ cacu zehe ña. ");
INSERT INTO mihNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ta i zacacu ña sii zehe ña, ra nuu, ta i zucu ña zahma sii ra. Ta i saqui ña sii ra sisi minoo canua nu sasi quɨtɨ vatyi ñá ñihi ñu minoo vehe cundyaa ñu vatyi ña nuña ca vehe hotél. ");
INSERT INTO mihNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yatyi ñuu cuan yucu zuhva ra sisi cuhu vatyi zacuenda ra sii quɨtɨ zono ra sa sa cuaa. ");
INSERT INTO mihNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ta zana ñi iñi ra ta i quituu minoo ángel Ndyoo nu yucu ra. Ta sa ndisi sii Zutu mañi yo i zandundisi si nacahnu nu yucu ra, ta i yuhu xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ta i catyi ángel cuan sihin ra: Ma yuhu ndo vatyi vasi nacatyi minoo sa vaha xaan sihin ndo. Zɨɨ xaan cua cuñi tandɨhɨ ñiyɨvɨ sa cuenda si. ");
INSERT INTO mihNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Vatyi vityi i cacu minoo ra ñuu ra David. Vasi ra sa cuenda maa ndo vatyi cua zacacu ra sii ñiyɨvɨ. Ra Cristo cuu ra, ta ra ndyaca ñaha sii yo. ");
INSERT INTO mihNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ta ihya cuu cuhva cua nacoto ndo sii ra. Cua nañihi ndo sii lee cuan zucu ra zahma, ta catuu ra sisi minoo canua. ");
INSERT INTO mihNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ta zuun ñi caa cuhva cuan i saa cuaha xaan ca ángel sihin ángel cuan. Ta zacahnu ángel cuan sii ra Ndyoo, ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Cahnu xaan cuu maa ra Ndyoo ra ndyaa gloria, ta nacoo sa vaha ta sa taxi sii ñiyɨvɨ ñuu ñiyɨvɨ. Catyi ángel cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ta zɨquɨ cua nanuhu ángel cuan ndya gloria, ta i catyi ra zacuenda mvee sihin tahan ra: Coho yo Belén. Cua ndyehe yo ñaa sa cuu cuhva i zacoto ra Ndyoo sii yo. ");
INSERT INTO mihNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ta numi xaan cuahan ra, ta saa ra ñuu Belén, ta i nañihi ra sii ña María sihin ra José. Ta catuu lee cuan sisi canua. ");
INSERT INTO mihNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ta sa yaha i ndyehe ra sii lee cuan, ta i nacatyi ra cuhva i catyi ángel cuan sihin ra sa cuenda lee cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ta tandɨhɨ ñiyɨvɨ i siñi tuhun cuan iyo xaan i cuñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Zoco ña María, cuenda nacañi ñi iñi ña sa cuenda tuhun cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ta cuanuhu ra zacuenda mvee, ta zacahnu xaan ra sii ra Ndyoo sa cuenda tandɨhɨ sa i ndyehe ra ta sa i siñi ra cuhva i catyi ángel cuan sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ta sa ndu‑uña quɨvɨ lee cuan, i sahndya ñu ñɨɨ xiñi xuu ra tañi catyi costumbre ñu, ta i zacunañi ñu sii ra Jesús tañi catyi ángel cuee ca sa ñihi ña María sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ta sa yaha quɨvɨ cuhva catyi ley ra Moisés sa cuenda sa nduvaha ña ityi nuu Ndyoo, ta zɨquɨ sindyaca ñu sii ra Jesús ndya ñuu Jerusalén vatyi cua cuhva cuenda ñu sii ra sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tacuan i zavaha ñu vatyi catyi ley ra Ndyoo: “Rayɨɨ ra cacu sa xihna ñi zacuu minoo ñaha, cua cuhva cuenda ñu sii ra sii ra Ndyoo”, catyi ley. ");
INSERT INTO mihNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ta i sahan ñu, ta saha cuenda ñu uu tahan quɨtɨ tañi catyi ley maa ra Ndyoo nu catyi si tyehen: “Cuhva ndo uu tahan curuu a uu tahan paloma”, catyi ley. ");
INSERT INTO mihNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ta quɨvɨ cuan sicoo minoo ra ñuu Jerusalén sa nañi Simeón. Minoo ra ndoo xaan i cuu ra, ta i zacahnu ra sii ra Ndyoo sa ndisa cuii. Ta ndatu ra sa cua quisi ra cua zacacu sii ñiyɨvɨ hebreo. Ta ñoho Tatyi Ii ra Ndyoo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ta i zacoto Tatyi Ii sii ra vatyi ma cuu ra ndya cuhva ndya ndyehe ra sii ra cua zacacu sii ñiyɨvɨ. Cua ndyehe ra sii ra Cristo, ra cua tasi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ta i sahan ra Simeón vehe ñuhu cuhva catyi Tatyi Ii ra Ndyoo sihin ra. Ta i saa zutu ra ta zɨhɨ ra Jesús sihin maa ra vatyi cua zavaha ñu cuhva catyi ley. ");
INSERT INTO mihNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ta cuhva sa saa ñu nu ndyaa ra Simeón, ta i quihin ra sii ra Jesús i tyihi zucu ndaha ra. Ta i quisaha zacahnu ra sii ra Ndyoo ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Zutu mañi yuu, nacui vityi sihin sa taxi añime. Vatyi sa zavohon cuhva sa catyun sihin muzun. ");
INSERT INTO mihNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Vatyi sa ndyehi sihin sɨtɨ nui sii ra cua zacacu sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Sa cua zañohon sii ra sii tandɨhɨ ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ihya ra cua zanducahnu ca sii ñiyɨvɨ hebreo, ñiyɨvɨ i casun. Ta cua cuhva ra ya ñúhu sa cua zandundisi ityi sii inga ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu. Catyi ra Simeón. ");
INSERT INTO mihNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ta ra José sihin zɨhɨ ra Jesús, iyo xaan i cuñi ñu sihin cuhva cahan ra Simeón cuenda lee cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tacuan ta i cahan ra Simeón sihin ra Ndyoo sa cuenda ñu, ta zɨquɨ i catyi ra sihin ña María, zɨhɨ ra Jesús: Ndyehun vatyi lee ya cua zanduva a cua zanduvita ra sii cuaha xaan ñiyɨvɨ hebreo. Cua cuu ra tañi minoo zeña, ta cuaha xaan ñiyɨvɨ cua cuxaan sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ta uhvi xaan cua cuu añimon, María, tañi sa yaha zava minoo tyicaa añimon. Ta cuhva sa sica iñi ñiyɨvɨ sisi añima ñu, casi xaan cua quita si. Catyi ra Simeón. ");
INSERT INTO mihNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ta yucuan ndyaa tucu minoo ñaha sa cahan Tuhun Ndyoo. Nañi ña Ana. Ra Fanuel i cuu zutu ña, ñiyɨvɨ sii ra Aser. Sa sahnu xaan ña. Ndya luhlu ña ta tindaha ña, zoco usa cuiya ñi ta i sihi yɨɨ ña. ");
INSERT INTO mihNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ta quɨvɨ cuan ñandahvi i cuu ña, ta cumi xico cumi cuiya ña. Ta ñá quita ña sisi vehe ñuhu vatyi ñiyaca ta ndyiyaca i cahan ña sihin ra Ndyoo. Ta iyo saha ñá sasi ña ta cahan ña sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ta zuun ñi caa cuhva sa cahan ra Simón ta i saa tucu ña Ana nu ndyaa ra José ta ña María sihin lee. Ta i nacuhva ña tyahvi ndyoo sii ra Ndyoo cuenda ra. Ta i quisaha cahan ña cuenda ra Jesús sihin tandɨhɨ ñiyɨvɨ sa ndatu quɨvɨ cua cacu ñiyɨvɨ ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ta sa ndɨhɨ zavaha ñu tandɨhɨ sa catyi ley ra Ndyoo ta i sinanuhu ñu ndya nu cu si Galilea ndya ñuu Nazaret nu cuu ñuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ta i sahnu ra Jesús. Ta i ndundyee ca ra sihin sa siñi tuñi ra Ndyoo. Ta i tyindyee xaan ra Ndyoo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ta ra José sihin zɨhɨ ra Jesús tuhva ñu sahan ñuu Jerusalén tahan tahan cuiya sa cuenda vico zuhun. ");
INSERT INTO mihNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ta sa ndusi ra Jesús sa usi uu cuiya ra, ta i sahan ñu ñuu Jerusalén tañi tuhva tandɨhɨ ñiyɨvɨ sahan sa cuenda vico cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ta sa ndɨhɨ vico cuan ta cua nuhu ñu, zoco i ndoo ra Jesús ñuu Jerusalén, ta ñá sito ra José ta zɨhɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","I sica iñi ñu vatyi ndɨhɨ ra sihin ñu vatyi cuaha xaan ñiyɨvɨ cuahan sihin ñu. Ta sa minoo quɨvɨ sica ityi ñu, ta zɨquɨ i nanducu ñu sii ra tɨcuɨ amigo ñu ta ñiyɨvɨ sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Zoco ñá nañihi ñu sii ra. Yucuan cuenda i sinanuhu sata ñu ndya ñuu Jerusalén cua nanducu ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","I yaha uñi quɨvɨ ta zɨquɨ i nañihi ñu sii ra sisi vehe ñuhu cahnu. Ndyaa ra mahñu ra maestro. Tyizoho ra Jesús sa cahan ra ta nducu tuhun ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ta tandɨhɨ ra i siñi sa cahan ra Jesús, iyo xaan i cuñi ra sihin sa siñi tuñi sii ra Jesús ta sihin tuhun cahan ra, ndɨhɨ ca. ");
INSERT INTO mihNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ta sa ndyehe zutu ra ta zɨhɨ ra sii ra, iyo xaan i cuñi ñu. Ta i catyi zɨhɨ ra sihin ra: Zehe luhli, ¿ñaa cuenda i zavohon cuhva ya sihin ndi? Catyi ña. Zutun ta yuhvi i sica xaan iñi ndi sa cuendon, ta i nanducu xaan ndi suun. Catyi ña. ");
INSERT INTO mihNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ta i catyi ra Jesús sihin ñu: ¿Ñaa cuenda nanducu ndo sii? ¿Atu ña sito ndo vatyi cuñi si sa zatyiñe tyiño Zuti? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Zoco ñá cutuñi iñi ñu tuhun cahan ra sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ta cua nuhu ra sihin ñu ndya ñuu Nazaret, ta i tyaa ra yahvi sii ñu. Ta i nacañi iñi ña María sa cuenda cuhva i cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ta ra Jesús i sahnu ra, ta cahnu ca nduu ra, ta i nducuaha ca sa siñi tuñi sii ra. Ta zɨɨ xaan i cuñi ra Ndyoo sihin ra ta ñiyɨvɨ ndɨhɨ ca. ");
INSERT INTO mihNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ta sa sahun cuiya sa ndyaca ñaha ra Tiberio nacahnu, ta ra Poncio Pilato i cuu ra gobernador nu cu si Judea. Ta ndyaca ñaha ra Herodes nu cu si Galilea. Ta yañi ra, ra Felipe cuu ra ndyaca ñaha nu cu si Iturea sihin Traconite. Ta ra Lisanias ndyaca ñaha ra nu cu si Abilinia quɨvɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ta ra Anás sihin ra Caífas i cuu ra cu nuu sii tandɨhɨ ra cu zutu. Ta quɨvɨ cuan i cahan ra Ndyoo sihin ra Juan zehe ra Zacarías minoo nu ityi xaan nu sindyaa ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ta i sica noo ra Juan tandɨhɨ ñuu sa ndyaa yatyi ñi nu ndyaa yutya sa nañi Jordán. I nacatyi ra sihin ñiyɨvɨ vatyi nazama ñu cuhva iyo ñu ta coo ndutya ñu. Ta zɨquɨ cua zandasi ra Ndyoo cuatyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tañi catyi si nuu libro i tyaa ra Isaías, minoo ra profeta ta sa naha. Nu catyi ra tyehen: Cua cuɨñɨ ndo nduzu minoo ra cana saa minoo nu ityi xaan. Ta catyi ra cuan: “Tañi zanduvaha ndo minoo ityi, tacuan zanduvaha ndo añima ndo vatyi cua quisi ra ndyaca ñaha sii yo. Tañi zandundoo ndo ityi, tacuan nazama ndo cuhva iyo ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ta tañi zanandutu ndo tandɨhɨ xahva, ta tañi zandundaa ndo tandɨhɨ yucu ta zandundoo ndo nu yacua ityi ta zanduvaha ndo nu quiñi caa, tacuan cuñi si sa zama ndo cuhva iyo ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tacuan ta tandɨhɨ ñiyɨvɨ cua ndyehe sii Zehe ra Ndyoo, ra cua zacacu sii yo.” Tacuan i tyaa ra Isaías ta sa naha vatyi cuhva cuan cua cahan ra Juan sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tacuan i cahan ra Juan sihin ñiyɨvɨ. Ta cuhva sa siñi ñu sa cahan ra ta i catyi ñu sihin ra vatyi cuñi ñu sa zacoo ndutya ra sii ñu. Ta zɨquɨ i catyi ra sihin ñu: ¡Ñiyɨvɨ quiñi xaan iyo cuu ndo tañi coo! ¿Yoo sa nacatyi sihin ndo vatyi cuu cacu ndo sihin cuhva sa cua tasi tuñi xaan ra Ndyoo sii ñiyɨvɨ? ");
INSERT INTO mihNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Cuñi si sa zama ndisa cuii ndo cuhva iyo ndo, ta zavaha ndo sa vaha. Ta ma catyi ndo vatyi maa ra Abraham cuu zutu ndo, ta ma catyi ndo vatyi maa ra cua zacacu sii ndo. Ma zacahnu ndo sii ndo vatyi vazu sihin yuu ya ta cuu zavaha ra Ndyoo ñiyɨvɨ sii ra Abraham sihin si. ");
INSERT INTO mihNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tañi minoo yutu sa ña saha sɨtɨ cuu ndo. Vatyi ña zavaha ndo cuhva cuñi ra Ndyoo. Ta yutu sa ña saha sɨtɨ, sahndya ñiyɨvɨ sii tu. Ta sahmi ñu sii tu. Ta zuun ñi cuhva cuan cua cuhun maa ndo nu cayu ñúhu. Catyi ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ta i ndaca tuhun ñiyɨvɨ sii ra ta catyi ñu: ¿Ñaa sa cuñi si zavaha ndi? Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ta i nacatyi ra Juan sihin ñu: Ndoho ra iyo uu tahan camisa, nacuhva ndo minoo sii ra ñahñi. Ta ra iyo sa casi, nacuhva tucu ra sii ra ñahñi. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ta i saa coyo tucu zuhva ra zatyiyahvi sii ñiyɨvɨ xuhun cuenda ra ndyaca ñaha, ta i cuñi ra coo ndutya ra. Ta i ndaca tuhun ra sii ra Juan: Maestro, ¿ñaa sa cuñi si zavaha ndi? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ta i catyi ra Juan sihin ra: Ma zatyiyahvi zana ndo sii ñiyɨvɨ minoo cuhva ña catyi ley. Catyi ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tacuan ta i ndaca tuhun tucu zuhva ra zandaru sii ra Juan ta catyi ra: Ta nduhvi tucu, ¿ñaa sa cuñi si zavaha ndi? Catyi ra. Ta i catyi ra Juan sihin ra: Ma quindyaa ndo ndaha tyiño ñiyɨvɨ. Ta ma zayuhu xaan ndo sii ñiyɨvɨ. Ma tyaa ndo cuatyi sata ñu tatu ña ndisa. Ta ndoo ndo vaha ta yahvi ñi ndo. Catyi ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ta i nacañi iñi ñiyɨvɨ sa cuenda ra Juan tatu ra Cristo cuu ra a yɨvɨ vatyi ndatu ñu sa cua quisi ra Cristo. ");
INSERT INTO mihNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ta i catyi ra Juan sihin tandɨhɨ ñu: Ndisa zacoo ndutye sii ndo sihin ndutya, zoco vasi inga ra cahnu ca ta zɨquɨ mi. Ña tahan si sii, nu sa cui muzu ra ta cuize ndisa ra, zoco zuun ñi maa ra i saha tyiño sii. Ta maa ra cua zacoo ndutya sii ndo sihin Tatyi Ii ta sihin ñúhu. ");
INSERT INTO mihNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sa ndaha ra pala ra, ta cua zanduvii ra sɨtɨ trigo ra, ta cua tava zɨɨn ra zoo si. Cua zandu‑ɨɨn ra sii trigo cuan, ta cua cucumi vaha ra sii si, ta cua cahmi ra zoo si sisi minoo ñúhu sa ma ndahva ca. Tacuan i catyi ra Juan sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ta sihin cuaha xaan ca cuhva i cahan ra Juan sihin ñiyɨvɨ, ta i zayuhu ra sii ñu, ta i nacatyi ra vatyi cua quisi minoo ra cua zacacu sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","I nacatyi ra Juan sihin ra rey Herodes tandɨhɨ cuii sa ña vaha sa i zavaha ra vatyi i quihin ra sii ña Herodías, ñazɨhɨ ra Felipe yañi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Cuñi si sa zanduvaha ra Herodes cuhva iyo ra, zoco i zavaha ra minoo ca sa ña vaha ta i tyihi ra sii ra Juan vehe caa. ");
INSERT INTO mihNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cuaha xaan ñiyɨvɨ i zacoo ndutya ra Juan, ta i zacoo ndutya ra sii ra Jesús. Ta cuhva sa sicoo ndutya ra Jesús, i cahan ra sihin ra Ndyoo, ta i nuña andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ta i noo Tatyi Ii zɨquɨ ra tañi minoo paloma. Ta i siñi ñiyɨvɨ minoo nduzu sa quita andɨvɨ ta catyi si: Yoho cuu zehi, ra cuñi xein. Zɨɨ xaan cuñi suhun. Catyi nduzu cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Oco usi cuiya ra Jesús ta i quisaha zatyiño ra. Tandɨhɨ ñiyɨvɨ i sica iñi ñu vatyi zehe ra José cuu sii ra. Ta ra José, zehe ra Elí cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ta ra Elí, zehe ra Matat cuu sii ra. Ta ra Matat, zehe ra Leví cuu sii ra. Ta ra Leví, zehe ra Melqui cuu sii ra. Ta ra Melqui, zehe ra Jana cuu sii ra. Ta ra Jana, zehe ra José cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ta ra José cuan, zehe ra Matatías cuu sii ra. Ta ra Matatías, zehe ra Amós cuu sii ra. Ta ra Amós, zehe ra Nahum cuu sii ra. Ta ra Nahum, zehe ra Esli cuu sii ra. Ta ra Esli, zehe ra Nagai cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ta ra Nagai, zehe ra Maat cuu sii ra. Ta ra Maat, zehe ra Matatías cuu sii ra. Ta ra Matatías, zehe ra Semei cuu sii ra. Ta ra Semei, zehe ra José cuu sii ra. Ta ra José cuan, zehe ra Judá cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ta ra Judá, zehe ra Joana cuu sii ra. Ta ra Joana, zehe ra Resa cuu sii ra. Ta ra Resa, zehe ra Zorobabel cuu sii ra. Ta ra Zorobabel, zehe ra Salatiel cuu sii ra. Ta ra Salatiel, zehe ra Neri cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ta ra Neri, zehe ra Melqui cuu sii ra. Ta ra Melqui, zehe ra Adi cuu sii ra. Ta ra Adi, zehe ra Cosam cuu sii ra. Ta ra Cosam, zehe ra Elmodam cuu sii ra. Ta ra Elmodam, zehe ra Er cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ta ra Er, zehe ra Josué cuu sii ra. Ta ra Josué, zehe ra Eliezer cuu sii ra. Ta ra Eliezer, zehe ra Jorim cuu sii ra. Ta ra Jorim, zehe ra Matat cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ta ra Matat, zehe ra Leví cuu sii ra. Ta ra Leví, zehe ra Simeón cuu sii ra. Ta ra Simeón, zehe ra Judá cuu sii ra. Ta ra Judá, zehe ra José cuu sii ra. Ta ra José, zehe ra Jonán cuu sii ra. Ta ra Jonán, zehe ra Eliaquim cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ta ra Eliaquim, zehe ra Melea cuu sii ra. Ta ra Melea, zehe ra Mainán cuu sii ra. Ta ra Mainán, zehe ra Matata cuu sii ra. Ta ra Matata, zehe ra Natán cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ta ra Natán, zehe ra David cuu sii ra. Ta ra David, zehe ra Isaí cuu sii ra. Ta ra Isaí, zehe ra Obed cuu sii ra. Ta ra Obed, zehe ra Booz cuu sii ra. Ta ra Booz, zehe ra Salmón cuu sii ra. Ta ra Salmón, zehe ra Naasón cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ta ra Naasón, zehe ra Aminadab cuu sii ra. Ta ra Aminadab, zehe ra Aram cuu sii ra. Ta ra Aram, zehe ra Esrom cuu sii ra. Ta ra Esrom, zehe ra Fares cuu sii ra. Ta ra Fares, zehe ra Judá cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ta ra Judá, zehe ra Jacob cuu sii ra. Ta ra Jacob, zehe ra Isaac cuu sii ra. Ta ra Isaac, zehe ra Abraham cuu sii ra. Ta ra Abraham, zehe ra Taré cuu sii ra. Ta ra Taré, zehe ra Nacor cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ta ra Nacor, zehe ra Serug cuu sii ra. Ta ra Serug, zehe ra Ragau cuu sii ra. Ta ra Ragau, zehe ra Peleg cuu sii ra. Ta ra Peleg, zehe ra Heber cuu sii ra. Ta ra Heber, zehe ra Sala cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ta ra Sala, zehe ra Cainán cuu sii ra. Ta ra Cainán, zehe ra Arfaxad cuu sii ra. Ta ra Arfaxad, zehe ra Sem cuu sii ra. Ta ra Sem, zehe ra Noé cuu sii ra. Ta ra Noé, zehe ra Lamec cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ta ra Lamec, zehe ra Matusalén cuu sii ra. Ta ra Matusalén zehe ra Enoc cuu sii ra. Ta ra Enoc, zehe ra Jared cuu sii ra. Ta ra Jared, zehe ra Mahalaleel cuu sii ra. Ta ra Mahalaleel, zehe ra Cainán cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ta ra Cainán, zehe ra Enós cuu sii ra. Ta ra Enós, zehe ra Set cuu sii ra. Ta ra Set, zehe ra Adán cuu sii ra. Ta ra Adán, zehe ra Ndyoo cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ta i situ cuii Tatyi Ii Ndyoo sii ra Jesús sa yaha sicoo ndutya ra. Ta i quita ra nu cu si yuu Jordán, ta sindyaca Tatyi Ii ra Ndyoo sii ra minoo nu ityi xaan. ");
INSERT INTO mihNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yucuan i sindyaa ra uu xico quɨvɨ, ta i nducu coto ihñi cuihna sii ra. Ta sisi quɨvɨ cuan ñahñi maa i sasi ra. Ta yaha cuan, ta i sizoco xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ta i catyi cuihna sihin ra: Tatu ndisa vatyi Zehe ra Ndyoo cuu suun, catyun sihin yuu sa catuu ihya vatyi nanduu si pan. Catyi cuihna sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ta i catyi ra Jesús sihin cuihna: Catyi Tuhun Ndyoo vatyi ña maa sihin sa casi ñi yo ta cundito yo. Sihin sa sasi yo ndito coño ñuhu yo, zoco sihin sa tyaa yo yahvi tuhun cahan ra Ndyoo ta ndito añima yo sa ndisa cuii. Catyi ra Jesús sihin cuihna. ");
INSERT INTO mihNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tacuan ta i sindyaca cuihna sii ra Jesús xiñi minoo yucu zucu xaan, ta i zañaha ra tandɨhɨ cuii ñuu ñiyɨvɨ sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ta i catyi cuihna sihin ra Jesús: Ndaha mi ndyaa tandɨhɨ ya vatyi saha ra Ndyoo sa cundyaca ñehi tandɨhɨ ñuu ñiyɨvɨ ya. Ta cuu cuhve sii si sii yoo ra cuñi, ta cua cundyaca ñaha ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ta cua cuhve tandɨhɨ si suun tatu cua cuɨñɨ sɨtun nui ta zacahnun sii. Catyi cuihna sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Zoco i catyi ra Jesús sihin cuihna: Cuɨñɨ siyo suun sii, cuihna, vatyi catyi Tuhun Ndyoo vatyi ɨɨn ñi sii maa ra Ndyoo ra ndyaca ñaha sii ndi cua zacahnu ndi. Ta ɨɨn ñi tyiño maa ra cua zacuu ndi. Catyi ra Jesús sihin cuihna. ");
INSERT INTO mihNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yaha cuan ta i sindyaca cuihna sii ra Jesús ndya ñuu Jerusalén. Ta i zandaa ra sii ra xiñi vehe ñuhu cahnu. Ta i catyi ra sihin ra Jesús: Tatu ndisa vatyi Zehe ra Ndyoo cuu suun, ndavon ndya nu ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Vatyi catyi Tuhun Ndyoo: “Cua cuhva ra Ndyoo tyiño sii ángel ra vatyi zacuenda ra suun. ");
INSERT INTO mihNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Cua naqueen ra suun sihin ndaha ra ta ma ñicuehe sohon sihin minoo yuu.” Catyi cuihna sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ta i catyi ra Jesús sihin ra: Catyi Tuhun Ndyoo vatyi ma nducu coto ihñi ndi sii ra Ndyoo ra ndyaca ñaha sii ndi. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ta ñá cuu zandavi ñaha cuihna sii ra Jesús. Ta cuahan cuihna zuhva ñi quɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ta sa yaha sa nducu coto ihñi cuihna sii ra Jesús, ta zɨquɨ i quisi nanuhu ra Jesús ndyaa Galilea. Situ cuii ra sihin tundyee iñi Tatyi Ii. Ta i cahan ñiyɨvɨ tuhun ra nacahnu cuii ityi cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ta i zacuaha ra sii ñiyɨvɨ sisi vehe ñuhu tahan tahan ñuu. Ta i zacahnu tandɨhɨ ñiyɨvɨ sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tacuan ta i nasaa ra Jesús ñuu Nazaret nu i sahnu ra. Ta minoo quɨvɨ quitatu ñiyɨvɨ i quɨhvɨ ra vehe ñuhu tañi sa tuhva maa ra zavaha, ta i sicuɨñɨ ndyaa ra vatyi cua cahvi ra Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ta i saha ñu minoo libro Tuhun Ndyoo sii ra sa i tyaa ra Isaías, minoo ra profeta ta sa naha. Ta i nuña ra libro, ta i nañihi ra nu catyi si tyehen, ta i cahvi ra tuhun ya: ");
INSERT INTO mihNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ndyaa Tatyi Ii ra Ndyoo sihin, vatyi maa ra i tyaa tyiño sii, vatyi nacatyi tuhun vaha ra sihin ñiyɨvɨ ndahvi. I tasi ra sii, sa zacote sii ñu ndyaa ndaha ra ña vaha vatyi cua quita ñu. Ta zacote sii ñu cuaa vatyi cua nandyehe ñu. Ta zacote sii ñu ndyehe tundoho vatyi cua cacu ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ta zacote sii ñiyɨvɨ vatyi sa saa quɨvɨ cua cuhva xaan ra Ndyoo sa vaha sii ñu. Tacuan i cahvi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ta sa ndɨhɨ cahvi ra, ta i nacazi ra libro, ta nacuhva ra sii minoo ra zatyiño vehe ñuhu cuan. Ta i sicundyaa ra. Ta i ndyehe xaan tandɨhɨ ñiyɨvɨ yucu yucuan sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ta i quisaha catyi ra sihin ñu: Zuun ñi vityi natahan si ityi nuu maa ndo cuhva catyi tuhun ya. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ta tandɨhɨ ñiyɨvɨ yucu yucuan, vaha i cahan ñu sa cuenda ra Jesús. Ta iyo cuñi ñu sihin sa cahan ra vatyi vaha xaan si. Ta i nducu tuhun ñu sii tahan ñu: ¿Atu yɨvɨ ra ihya cuu zehe ra José? Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ta i catyi ra Jesús sihin ñu: Site cuhva sica iñi ndo. Ta tyehen cua catyi ndo sihin: “Yoho ra cu médico, xihna ca sii moo zanduvohon.” Ta cua catyi tucu ndo: “Sa siñi ndi sa zavohon ñuu Capernaum. Cuhva cuan zavaha tucun ñuu moo.” Tacuan cua catyi ndo sihin. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tacuan ta i catyi ra Jesús: Sa ndisa catyi sihin ndo vatyi minoo ra profeta, ña tyaa ñiyɨvɨ ñuu ra yahvi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ta catyi sa ndisa sihin ndo vatyi cuaha xaan ñundahvi hebreo, ñu sihi yɨɨ, i sicoo quɨvɨ i sica noo ra Elías. Ta ñá coon zavi uñi cuiya zazava. Ta sicoo xaan tama nacahnu. ");
INSERT INTO mihNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Zoco ñá tasi ra Ndyoo sii ra Elías vatyi tyindyee ra sii numinoo ñundahvi hebreo. I tasi ra Ndyoo sii ra nu ndyaa minoo ñandahvi minoo ñuu nañi Sidón nu cu si Sarepta. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ta i catyi tucu ra Jesús: Cuaha xaan ra hebreo cuhu sihin cuehe sa tyahyu ra quɨvɨ i sica noo ra Eliseo, ra cu profeta. Zoco ñá nduvaha numinoo ra hebreo, zoco i nduvaha ra Naamán, minoo ra ñuu Siria. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ta sa siñi ñiyɨvɨ ñoho vehe ñuhu tuhun cuan, i cuxaan xaan tandɨhɨ ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ta i nduvita ñu. Ta i tɨɨn ñu sii ra Jesús sindyaca ñu sii ra yuñuu nu iñi noo vatyi cua zavita ñu sii ra yucuan. ");
INSERT INTO mihNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Zoco i yaha ra Jesús mahñu ñu, ta cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ta cuahan ra Jesús ñuu Capernaum nu cu si Galilea. Ta tahan quɨvɨ quitatu ñiyɨvɨ i zacuaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ta iyo xaan i cuñi ñu sihin cuhva cahan ra vatyi cahan ra tañi minoo ra sito xaan tañi cahan ra ndyaca ñaha vatyi cahan ra sihin sa siñi tuñi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ta sisi vehe ñuhu sicoo minoo ra ñoho minoo tatyi ña vaha sii, ta saa xaan i cana saa ra ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Zañon sii ndi, yoho ra Jesús. ¿Ñaa sa cuñun sihin ndi? Catyi ra. ¿Atu vasi zanoon sii ndi? Site yoo ra cuun. Yoho cuu ra Ii, ra tasi ra Ndyoo. Tacuan i catyi ra cuan zacuu tatyi cuihna. ");
INSERT INTO mihNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ta i cahan ra Jesús sihin tatyi ña vaha cuan, ta i catyi ra: Taxi ñi, ta zañon sii ra ya. Catyi ra. Tacuan ta i zanduva tatyi cuihna sii ra cuan mahñu nu yucu ñiyɨvɨ, ta i quita si, ta ñá zañicuehe si sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ta i yuhu xaan tandɨhɨ ñiyɨvɨ i ndyehe. Ta i catyi ñu sihin tahan ñu: ¿Ñaa tuhun cuu ya? Iyo xaan cuhva ta tundyee iñi sii ra Jesús, ta cuu cahan ra sihin tatyi cuihna ta quita si. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ta nacahnu cuii yucuan i cahan xaan ñiyɨvɨ tuhun ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ta i quita ra Jesús vehe ñuhu cuan, ta i quɨhvɨ ra vehe ra Simón. Ta cuhu xaan tyizo ra Simón sihin cahñi. Ta i cahan ñu sihin ra Jesús sa cuenda ña. ");
INSERT INTO mihNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ta i saa ra Jesús nu catuu ña, ta i catyi ra sihin cuehe cuan vatyi naquita si. Ta i quita cahñi cuan sii ña. Ta zuun ñi cuhva cuan i nduvita ña, ta i zavaha ña sa casi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ta cuhva sa cua cuizo ñicandyi i quisi ndyaca ñiyɨvɨ sii tandɨhɨ ñiyɨvɨ cuhu iyo vehe ñu, ñaa ndɨhɨ cuii ca cuehe. Ta i tyizo ra Jesús ndaha ra zɨquɨ minoo minoo ñu, ta i zanduvaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ta i quita tucu tatyi cuihna sii cuaha xaan ñiyɨvɨ cuan, ta i cana saa si ta catyi si: Yoho cuu ra cu Zehe Ndyoo. Catyi si. Zoco ñá saha ra Jesús sa cahan ca si vatyi nacoto si sii ra vatyi ra zacacu sii ñiyɨvɨ cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ta sa cundisi inga quɨvɨ, ta i quita ra Jesús ñuu cuan. Cuahan ra minoo nu ityi xaan nu yoñi ñiyɨvɨ iyo. Zoco i nanducu ñiyɨvɨ sii ra, ta i saa ñu nu ñoho ra, ta cuñi ñu sa ndoo ra sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Zoco i catyi ra Jesús sihin ñu: Cuñi si sa zacote sii ñiyɨvɨ inga ñuu cuhva ndyaca ñaha ra Ndyoo vatyi yucuan cuenda i tasi ra Ndyoo sii. ");
INSERT INTO mihNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ta tacuan i sica noo ra Jesús, ta i nacatyi ra Tuhun Ndyoo tandɨhɨ vehe ñuhu nacahnu Galilea. ");
INSERT INTO mihNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Minoo saha nandyaa ra Jesús yuhu miñi sa nañi Genesaret, ta i saa coyo ñiyɨvɨ. Ta tɨhɨn xaan i siyucu ñu vatyi cuñi ñu cuɨñɨ ñu Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ta i ndyehe ra Jesús uu tahan barco yatyi ñi yumiñi. Ta sa quita coyo ra tɨɨn tyiyaca ta nacatya ra taraya ra. ");
INSERT INTO mihNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tacuan ta i quɨhvɨ ra Jesús sisi minoo barco sa cuu sii ra Simón, ta i catyi ra sihin ra vatyi nazatuhva ra zuhva ca sii tu nu cono ca. Ta zɨquɨ i sicundyaa ra Jesús sisi barco, ta i quisaha zacuaha ra sii ñiyɨvɨ yucu yumiñi cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cuhva sa ndɨhɨ cahan ra ta i catyi ra sihin ra Simón: Zacuhun barcun ndya nu cono ca ta cañi ndo taraya ndo nu ndutya vatyi cua tɨɨn ndo tyiyaca. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ta i nacahan ra Simón ta catyi ra: Maestro, sa zatyiño xaan ndi ñiyaca cuii, ta ñá ñihi maa ndi. Zoco tatu moo catyi, cua cañi tucu ndi taraya. Catyi ra Simón. ");
INSERT INTO mihNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ta sa zavaha ra cuhva cuan, ta i tɨɨn ra cuaha xaan tyiyaca, ndya cuhva i tahndya taraya ra sihin sa vee tɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ta i saha ra zeña sii ra tahan ra sa ñoho inga barco vatyi naquisi tyindyee ra sii ra. Ta i quisi ra, ta i zacutu ra nduu tahan barco cuan sihin tyiyaca cuan, ta ndya cuhva i cuñi ndyee tu. ");
INSERT INTO mihNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ta sa ndyehe ra Simón Pedro cuhva cuan, ta i sicuɨñɨ sɨtɨ ra nuu ra Jesús. Ta i quisaha catyi ra sihin ra: Zandoon sii, tata, vatyi ra iyo xaan cuatyi cui. ");
INSERT INTO mihNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Iyo xaan i cuñi ra Simón ta tandɨhɨ ra ndɨhɨ sihin ra vatyi cuaha xaan tyiyaca i tɨɨn ra. ");
INSERT INTO mihNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ta iyo xaan cuñi tucu ra Jacobo sihin ra Juan zehe ra Zebedeo. I zatyiño ra ɨɨn ñi sihin ra Simón. Ta i catyi ra Jesús sihin ra Simón: Ma iyo xaan cuñun. Ndya vityi ma tɨɨn con tyiyaca. Cua tɨun sii ñiyɨvɨ vatyi cua zacoton Tuhun Ndyoo sii ñu. Catyi ra Jesús sihin ra Simón. ");
INSERT INTO mihNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ta sa yaha zandaa ra barco ra nu ñuhu ityi, i zandoo tandɨhɨ uñi tahan ra sii tandɨhɨ ndaha tyiño ra, ta cuahan ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ta minoo quɨvɨ ndyaa ra Jesús minoo ñuu nu ndyaa minoo ra tyahyu. Ta sa ndyehe ra sii ra Jesús, sicuɨñɨ sɨtɨ ra nuu ra Jesús, ta i nacañi noo ra xiñi ra ndya nu ñuhu. Ta i sica xaan ra sii ra ta catyi ra: Tata, iyo cuhva suun; ta cuu zanduvohon sii tatu cuñun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ta i tyizo ra Jesús ndaha ra xiñi ra, ta i catyi ra: Cuñi. Sa nduvohon. Ta zuun ñi caa cuhva cuan i quita cuehe tyahyu cuan sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ta i catyi ra Jesús sihin ra: Ma nacatyun sihin numinoo ñiyɨvɨ. Zoco cuhun nu ndyaa ra cu zutu ta cuhvon ñaa ndɨhɨ sa tahan si cuhvon tañi i catyi ra Moisés, ta cua cuu si minoo sa ndaa sii ra cu zutu vatyi sa nduvohon. Catyi ra Jesús sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Zoco vazu i catyi ra Jesús sihin ra vatyi ma nacatyi ra sihin ñiyɨvɨ, zoco cuaha xaan ñiyɨvɨ i ñihi tuhun cuan. Ta cuaha xaan cuaha xaan ñiyɨvɨ i titahan vatyi cuñi ñu tyizoho ñu sa cahan ra Jesús, ta cuñi ñu sa zanduvaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Zoco i quita ra Jesús nu yucu ñu ndya minoo nu ityi xaan nu yoñi ñiyɨvɨ iyo, ta yucuan i cahan ra sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Minoo quɨvɨ zacuaha ra Jesús sii ñiyɨvɨ, ta yucu zuhva ra fariseo ta ra maestro cuenda ley hebreo. I quita ra cuan ñuu Jerusalén ta inga ñuu ndyihi nacahnu Galilea ta Judea. Ta sicoo xaan tundyee iñi ra Ndyoo sihin ra Jesús quɨvɨ cuan, ta i zanduvaha xaan ra sii ñiyɨvɨ cuhu. ");
INSERT INTO mihNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tacuan ta i saa coyo ra ndyizo sii minoo ra cuhu sihin minoo tyuhva. I nducu ra cuhva quɨhvɨ ra sisi vehe vatyi cuñi ra caqui ra sii ra nu nandyaa ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Zoco ñá ñihi ra cuhva quɨhvɨ ra vatyi tuu xaan ñiyɨvɨ. Tacuan ta i ndaa ra xiñi vehe, ta i tyaa siyo ra zuhva tyiyo, ta i zanoo ra sii ra nu nandyaa ra Jesús mahñu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ta sa ndyehe ra Jesús vatyi sino xaan iñi tandɨhɨ ra, ta i catyi ra sihin ra cuhu: Tata, sa ndasi tandɨhɨ cuatyun. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tacuan ta ra maestro cuenda ley cuan sihin ra fariseo i quisaha sica iñi ra: “¿Yoo ra cuu ra ya? Quiñi xaan cahan ra sii ra Ndyoo. Sica iñi ra vatyi cuu zandasi ra cuatyi yo, zoco minoo tuhun ñi maa ra Ndyoo cuu zandasi cuatyi yo.” ");
INSERT INTO mihNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Zoco i sito ra Jesús cuhva sica iñi ra, ta i quisaha catyi ra sihin ra: ¿Ñaa cuenda sica iñi ndo tacuan? ");
INSERT INTO mihNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","¿Ñaa sa ña yɨɨ ca catyi yo? ¿Atu yɨɨ ca catyi yo? “Sa ndasi cuatyun”, a yɨɨ ca catyi yo: “Nduviton ta cacon; sa nduvohon.” Ña yɨɨ catyi yo: “Sa ndasi cuatyun.” Vatyi yɨvɨ sa ndyehe yo cuu cuhva cuan. Ma coto ñiyɨvɨ tatu ndisa a ña ndisa. Zoco cua ndyehe ñu tatu zanduvaha yo sii minoo ñiyɨvɨ sa ndisa. Ta vityi cua zañehi sii ndo vatyi cuu zacui tandɨhɨ vatyi ra i quisi ndya gloria cui. Cuu zandasi cuatyi ñiyɨvɨ, ta cuu zanduvehi sii ra ya. Catyi ra Jesús. Ta i catyi ra sihin ra cuhu catuu yucuan: Catyi suhun, nduviton. Naquihin tyuhvon ta cunuhun ndya vehun. ");
INSERT INTO mihNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ta zuun ñi caa cuhva cuan i nduvita ra, ta i naquihin ra tyuhva ra, ta cua nuhu ra ndya vehe ra. Ta ityi cuahan ra zacahnu xaan ra sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ta iyo xaan i cuñi tandɨhɨ ñiyɨvɨ, ta i zacahnu ñu sii ra Ndyoo. Ta i yuhu xaan ñu, ta i catyi ñu: Vityi ndisa i ndyehe yo minoo sa iyo xaan caa. ");
INSERT INTO mihNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ta sa yaha cuan, ta i quita ra Jesús vehe cuan, ta cuahan ra. Ta i ndyehe ra sii minoo ra tava xuhun cuenda ra ndyaca ñaha romano. Leví nañi ra. Ta i catyi ra Jesús sihin ra: Coho sihin. ");
INSERT INTO mihNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tacuan ta i nduvita ra Leví. I zandoo ra tandɨhɨ sa sii ra, ta cuahan ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tacuan ta i zavaha ra Leví minoo vico cahnu xaan vehe ra sa cuenda ra Jesús. Ta cuaha xaan ra tava xuhun cuenda ra ndyaca ñaha sindyaa mesa sihin inga ca ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","(I sica iñi ra fariseo ta ra maestro cuenda ley hebreo vatyi ñahñi cuatyi maa ra), ta yucuan cuenda i quisaha cahan cuehe ra sihin ra sica noo sihin ra Jesús, ta catyi ra: ¿Ñaa cuenda sasi ndo ta sihi ndo sihin ra tava xuhun ta ra iyo xaan cuatyi? ");
INSERT INTO mihNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ta i catyi ra Jesús sihin ra: Ra iyo vaha, ña siñi ñuhu minoo médico sii ra. Zoco ra cuhu, siñi ñuhu médico sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ta maa ndo sica iñi ndo vatyi vaha xaan ndo; ñahñi cuatyi ndo cuñi ndo. Yucuan cuenda ña vasi tyindyei sii maa ndo. Vasi tyindyei sii ñu sito vatyi iyo cuatyi ñu vatyi cua nazama ñu cuhva iyo ñu. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tacuan ta i quisaha ndaca tuhun ra cuan sii ra Jesús ta catyi ra: Ra ndyico sii ra Juan ta sii ra fariseo, tuhva ra sahñi zoco sii ra, ta cahan ra sihin ra Ndyoo. Zoco ra sica noo sihin moo, tandɨhɨ quɨvɨ sasi ra xita ta sihi ra ndutya. ¿Ñaa cuenda? ");
INSERT INTO mihNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ta i catyi ra Jesús sihin ra: ¿Atu cuu sa ma cuhva ndo casi ñu yucu minoo vico tindaha tatu ndyaa ra i tindaha sihin ñu? Ma cuu. Cuñi ñu casi ñu vatyi zɨɨ xaan cuñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Zoco cua saa quɨvɨ cua ndɨhɨ vico. Cua cuhun ra i tindaha vatyi cua quindyaa ñiyɨvɨ sii ra. Tacuan ta zɨquɨ ma casi ra sica noo sihin ra xita. ");
INSERT INTO mihNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tacuan ta i cahan ra Jesús zɨquɨ minoo cuhva, ta i catyi ra: Yoñi ñiyɨvɨ cua cahndya minoo zahma saa ta natyaa ñu zuhva si sii minoo zahma sahnu vatyi cua ndɨyɨ zahma saa cuan, ta zɨquɨ cua tahndya ca zahma sahnu cuan. Ta ña vaha naha si ndɨhɨ ca tatu natyaa ñu zahma saa sii zahma sahnu. ");
INSERT INTO mihNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ta yoñi zavaha ndixi panela sisi quɨzɨ sahnu vatyi cua cuizo si ta ndaa si. Ta cua cahndi quɨzɨ cuan tatu sahnu si. Ta cua cati ndixi ta cua tɨvɨ quɨzɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Cuñi si quɨzɨ saa tatu zavaha ñiyɨvɨ ndixi panela, ta ma ndoyo ñuhu si. ");
INSERT INTO mihNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ta tatu sa sihi minoo ra ndixi panela sa ndaa, ma cuñi ra sa ñá ndaa vatyi catyi ra: “Vaha ca ndixi sa ndaa.” Ndixi sahnu ca cuu si cuan. (Ta tacuan iyo ñiyɨvɨ sihin costumbre ñu. Sa caan xaan ñu sii sa sahnu, ta ma cuu nazaca si sihin minoo cuhva saa.) ");
INSERT INTO mihNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Minoo quɨvɨ quitatu ñiyɨvɨ i yaha ra Jesús mahñu itu trigo ñiyɨvɨ. Ta ra sica noo sihin ra i tohon ra zuhva yoco trigo ta i zavii ra sihin ndaha ra, ta sasi ra sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tacuan ta i catyi zuhva ra fariseo sihin ra: Ña catyi ley yo sa zatyiño yo quɨvɨ quitatu ñiyɨvɨ. ¿Ñaa cuenda zatyiño ndo? ");
INSERT INTO mihNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ta i catyi ra Jesús sihin ra: ¿Atu tañaha ca cahvi ndo cuhva i zavaha ra David ta ra ndɨhɨ sihin ra minoo quɨvɨ i sizoco xaan ra? ");
INSERT INTO mihNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I quɨhvɨ ra sisi vehe ñuhu, ta i quihin ra pan ii. Ta i sasi ra sii si, ta saha ra sii ra ndɨhɨ sihin ra. Ta catyi ley vatyi maa ñi ra cu zutu tahan si casi pan cuan. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ta i catyi tucu ra Jesús sihin ra: Ra i quisi ndya gloria cui, ta ndyaca ñaha tuqui quɨvɨ quitatu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ta inga quɨvɨ quitatu ñiyɨvɨ i quɨhvɨ ra Jesús sisi vehe ñuhu ta zacuaha ra sii ñiyɨvɨ. Ta yucuan i ndyehe ra sii minoo ra na‑ityi ndaha siyo cuaha. ");
INSERT INTO mihNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ta ra maestro cuenda ley hebreo sihin ra fariseo i ndyehe xaan ra sii ra Jesús tatu cua zanduvaha ra sii ra cuan quɨvɨ quitatu ñiyɨvɨ. Tacuan ta cua cuu tyaa ra cuatyi sata ra. ");
INSERT INTO mihNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Zoco sa sito ra Jesús cuhva sica iñi ra, ta i catyi ra sihin ra na‑ityi ndaha: Nduvita. Ta cuɨñɨ ndyoon mahñu. Ta i nduvita ra, ta sicuɨñɨ ndyaa ra mahñu. ");
INSERT INTO mihNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ta zɨquɨ i nducu tuhun ra Jesús sii ra yucu yucuan ta catyi ra: Minoo ñi tuhun cua nducu tuhin sii ndo. ¿Atu catyi ley vatyi zavaha yo sa vaha a sa ña vaha quɨvɨ quitatu ñiyɨvɨ? ¿Atu zacacu yo sii ñiyɨvɨ a cahñi ndɨhɨ yo sii ñu? ");
INSERT INTO mihNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ta i ndyehe ra Jesús sii minoo minoo ra yucu yucuan. Ta i catyi ra sihin ra cuhu: Nandɨca ndohon. Ta i nandɨca ra ndaha ra, ta i nduvaha ndaha ra. ");
INSERT INTO mihNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ta zuhva ra yucu yucuan, i cuxaan xaan ra, ta i natuhun tahan ra yozo caa cua zavaha ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ta minoo quɨvɨ i ndaa ra Jesús minoo yucu vatyi cua caca tahvi ra sii ra Ndyoo. Ta i cahan ra sihin ra Ndyoo ñiyaca cuii. ");
INSERT INTO mihNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ta cuhva sa cundisi i cana ra sii tandɨhɨ ra sica noo sihin ra, ta i casi ra usi uu tahan ra vatyi cuu ra apóstol, ta cua tava ra Jesús tyiño sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ta ihya cuu zɨvɨ sa usi uu tahan ra: Ra Simón Pedro, ta yañi ra, ra Andrés. Ra Jacobo, ra Juan, ra Felipe, ta ra Bartolomé. ");
INSERT INTO mihNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ta ra Mateo, ta ra Tomás, ta ra Jacobo zehe ra Alfeo ta ra Simón Zelote. ");
INSERT INTO mihNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ta ra Judas, yañi ra Jacobo, ta ra Judas Iscariote, ra cua xico sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ta i noo ra Jesús yucu cuan sihin sa usi uu tahan ra cuan. Ta i sicuɨñɨ ndyaa ra minoo nu ndaa sihin ra sica noo sihin ra ta sihin cuaha ca ñiyɨvɨ, ñu i quita coyo nacahnu Judea ta ñuu Jerusalén ta ñuu Tiro sihin ñuu Sidón sa ndyaa yuhu tyañuhu. I saa ñu yucuan vatyi cua cuɨñɨ ñu sa cahan ra Jesús. Ta ñu cuhu, cuñi ñu sa zanduvaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ta ñiyɨvɨ ñoho tatyi ña vaha, i nduvaha tucu ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ta tandɨhɨ ñu, cuñi ñu tɨɨn ñu sii ra Jesús vatyi iyo tundyee iñi ra Ndyoo sii ra Jesús, ta i zanduvaha si sii tandɨhɨ ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tacuan ta i ndyehe ra Jesús sii ñiyɨvɨ sica noo sihin ra. Ta i catyi ra: Tandɨhɨ ndoho sa ndahvi, zɨɨ xaan cuu sii ndo vatyi tahan si sii ndo sa cundyaca ñaha ra Ndyoo sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ta tandɨhɨ ndoho sa sizoco vityi, zɨɨ xaan cuu sii ndo vatyi cua coo quɨvɨ ta ma ndyehe ca ndo zoco. Ta tandɨhɨ ndoho sa sacu xaan vityi, zɨɨ xaan cuu sii ndo vatyi cua coo quɨvɨ ñahñi ca tucuihya iñi cua coo sii ndo. Ta cua vacu ndo sihin sa zɨɨ cuñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Zɨɨ xaan cuu sii ndo tatu ña cuu ndyehe ñiyɨvɨ sii ndo, ta tatu cua tava ñu sii ndo nu yucu ñu, a tatu cahan cuehe ñu sii ndo a tatu catyi ñu vatyi ñiyɨvɨ ña vaha cuu ndo vatyi sino iñi ndo sii mi, ra i quisi ndya gloria cui. ");
INSERT INTO mihNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Zɨɨ xaan cuñi ndo quɨvɨ ndyehe ndo tundoho cuan, ta ndava ndo sihin sa zɨɨ cuñi ndo vatyi cahnu xaan sa cua cuhva ra Ndyoo sii ndo gloria. Zuun ñi cuhva ña vaha cuan i zavaha ñiyɨvɨ sahnu ta tyiemvu sihin ra profeta. ");
INSERT INTO mihNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Zoco ndahvi ndoho ra cuca vityi vatyi sa iyo sa zɨɨ sii ndo ihya ñuu ñiyɨvɨ ya. ");
INSERT INTO mihNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ta ndahvi ndoho ra sica iñi vatyi ñahñi sa cumañi sii ndo vityi vatyi cua coo quɨvɨ cua ndyehe xaan ndo zoco. Ta ndahvi ndoho tatu zɨɨ xaan cuñi ndo vityi vatyi cua coo quɨvɨ cua nducuihya xaan iñi ndo, ta cua vacu xaan ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ta ndahvi ndoho tatu catyi tandɨhɨ ñiyɨvɨ vatyi vaha xaan ndo vityi vatyi zuun ñi cuhva cuan i cahan ñiyɨvɨ sahnu sii ñu cuenda ra i catyi vatyi profeta ra Ndyoo cuu ra, ta ña ndisa ra. ");
INSERT INTO mihNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Tandɨhɨ ndoho ra siñi sa quehin, catyi sihin ndo vatyi cuñi xaan ndo sii ñu xaan iñi sii ndo. Zavaha ndo sa vaha sihin ñiyɨvɨ ña cuu ndyehe sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Cahan vaha ndo sihin ñiyɨvɨ cahan ndya vaha ñi sii ndo, ta cahan ndo sihin ra Ndyoo cuenda ñiyɨvɨ zavaha sa ña vaha sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tatu iyo ra cati ii siyo xɨtɨ ndo, cuhva ndɨhɨ ndo inga siyo nacati ra. Tatu iyo ra quindyaa siqueta ndo, cuhva ndɨhɨ ndo camisa ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Cuhva ndo ñaa ndɨhɨ sa sica ñiyɨvɨ sii ndo, ta tatu iyo ra quindyaa sa sii ndo, ma nandaca ndo sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tatu cuñi ndo sa cua zavaha ñiyɨvɨ sa vaha sihin maa ndo, tacuan zavaha tucu maa ndo sihin maa ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Tatu ɨɨn ñi sii ñiyɨvɨ cuñi xaan sii ndo cuñi ndo, ¿ñaa sa vaha zavaha ndo cuhva cuan? vatyi tacuan tucu zavaha ñiyɨvɨ quiñi xaan iyo. Cuñi xaan ñu sii ñiyɨvɨ sa cuñi sii maa ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A tatu zavaha ndo sa vaha sihin ñiyɨvɨ zavaha sa vaha sihin ndo, ¿ñaa sa vaha zavaha ndo cuhva cuan? vatyi tacuan tucu zavaha ñiyɨvɨ quiñi xaan iyo. ");
INSERT INTO mihNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A tatu saha noo ndo ndaha tyiño ndo sii ñiyɨvɨ vatyi cuñi ndo sa zaha ñu tumañi iñi sii ndo, ¿ñaa sa vaha zavaha ndo cuhva cuan? vatyi ñiyɨvɨ quiñi xaan iyo, saha noo ñu sa sii ñu ta ndatu ñu sa cua nacuhva tucu ñiyɨvɨ sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Zoco maa ndo, cuñi xaan ndo sii ñu xaan iñi sii ndo. Ta zavaha ndo sa vaha. Ta cuhva noo ndo sa sii ndo, zoco ma cuatu ndo ñaa tumañi iñi cua zavaha tucu maa ñu sii ndo. Ta tacuan ta cahnu xaan sa vaha cua ñihi ndo nu ndyaa ra Ndyoo. Ta sa ndisa cuii cua cuu ndo zehe ra Ndyoo, ra cahnu ca. Vatyi ra Ndyoo, vaha ñiyɨvɨ cuu ra sihin ñiyɨvɨ quiñi xaan iyo ta sihin ñu ña saha tyahvi ndyoo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yucuan cuenda cundahvi xaan iñi ndo sii ñiyɨvɨ tañi maa ra Ndyoo cundahvi xaan iñi ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ma cahan cuehe ndo sii ñiyɨvɨ coto catyi ra Ndyoo vatyi ña vaha zavaha tucu maa ndo. Ma catyi ndo vatyi ña vaha ñiyɨvɨ, ta ma catyi tucu ra Ndyoo vatyi ña vaha ndo. Zaha ndo tucahnu iñi sii ñiyɨvɨ, ta cua zaha ra Ndyoo tucahnu iñi sii maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cuhva maa ndo sa siñi ñuhu sii ñiyɨvɨ, ta cua cuhva tucu maa ra Ndyoo sa siñi ñuhu sii maa ndo. Tañi ñiyɨvɨ vaha tatu xico ñu ñaa sa xico ñu sii ndo, situ cuii saha ñu ndya cuhva sitya cuii ñi ca si. Tacuan tucu cua zavaha ra Ndyoo sihin ndo. Vaha xaan cua tyicuhva ra sa vaha ndya cuhva sitya cuii si, ta cua cuhva ra sii ndo. Vatyi tañi cuhva cua cuhva maa ndo sii ñiyɨvɨ, tacuan cuu cuhva cua cuhva ra Ndyoo sii maa ndo. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ta zɨquɨ i cahan ra Jesús sihin ñu sihin minoo cuhva ta catyi ra: Ma cuu zañaha minoo ra cuaa ityi sii inga ra cuaa. Cua canacava nduu tahan ra sisi xahva. ");
INSERT INTO mihNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ta cahnu ca cuu minoo ra cu maestro ta zɨquɨ ra zacuaha sihin ra, zoco tatu sa ndɨhɨ zacuaha ra, cua nduu ra tañi maestro ra. ");
INSERT INTO mihNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Ñaa cuenda ndyehun mihin luhlu cuii ñi sa ñoho sɨtɨ nuu yañun, ta ña zohon cuenda mihin cahnu sa ñoho sɨtɨ nuun? ");
INSERT INTO mihNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ta ¿ñaa cuenda catyun sihin yañun vatyi nacuhva ra sa tavon mihin luhlu sa ñoho sɨtɨ nuu ra? ta ña tuu iñun vatyi minoo mihin cahnu xaan ñoho sɨtɨ nuun. Cuhva cuan zohon tuhun vatyi vaha xoon, ta ña ndisa. Tava xihnon mihin cahnu sa ñoho sɨtɨ nuun, ta cua ndundisi ndyehun, ta cua cuu tavon mihin sa ñoho sɨtɨ nuu yañun. ");
INSERT INTO mihNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Minoo yutu vaha, ña saha tu sɨtɨ ña vaha. Ta minoo yutu ña vaha, ña saha tu sɨtɨ vaha. ");
INSERT INTO mihNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nacoto yo ñaa yutu cuu tahan tahan tu sa cuenda sɨtɨ saha tu. Vatyi minoo tu mihndya ma cuhva tu mango, ta minoo iñu ma cuhva tu yucu vixi sa nañi uva. ");
INSERT INTO mihNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ta tacuan tucu sihin ñiyɨvɨ. Minoo ra vaha, cahan ra tuhun vaha sa iyo añima ra. Ta ñiyɨvɨ ña vaha, ña vaha añima ñu, ta cahan ñu sa quiñi sa iyo añima ñu vatyi ñaa ndɨhɨ sa situ añima ñiyɨvɨ, yucuan cuu sa cahan ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Ñaa cuenda catyi ndo sihin: “Zutu mañi yuu, Zutu mañi yuu”, ta ña zavaha ndo cuhva catyi sihin ndo? ");
INSERT INTO mihNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tatu iyo ra cua quisi nu ndyei, ta siñi ra sa quehin, ta zavaha ra sii si, ihya cuu cuhva iyo ra: ");
INSERT INTO mihNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Cuu ra tañi minoo ra i zandaa vehe. Cono xaan sitya ra ndya tahan ra minoo yuu cahnu, ta i zandaa ra vehe ra zɨquɨ yuu cuan. Ta quɨvɨ i coon xaan zavi, ñihi xaan i yaha ndutya saha vehe ra, zoco ñá cuu zanduva si vehe ra vatyi ndyaa si zɨquɨ yuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Zoco ra ña siñi sa quehin, ta ña zavaha ra sii si, cuu ra tañi minoo ra ñá zavaha cimiento, ta i zandaa ra vehe ra nu ñuhu ñi. Ta ñihi xaan i yaha ndutya saha vehe ra, ta tañi tyehen ñi i nduva vehe ra, ta i ndoyo ñuhu si. ");
INSERT INTO mihNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cuhva sa ndɨhɨ cahan ra Jesús sihin ñiyɨvɨ ta cua nanuhu tucu ra inga saha ndya ñuu Capernaum. ");
INSERT INTO mihNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ta yucuan ndyaa minoo ra ndyaca ñaha sii minoo ziendu zandaru. Ta minoo muzu ra, ra sa cuñi xaan ra, cuhu xaan ra, ta cuñi cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Quɨvɨ sa sito ra cu nuu sii zandaru cuan tuhun ra Jesús, i tasi ra sii zuhva ra sahnu hebreo vatyi caca ra tumañi iñi sii ra Jesús sa quisi zanduvaha ra sii muzu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ta i saa coyo ra sahnu cuan nu ndyaa ra Jesús, ta i sica xaan ra tumañi iñi sii ra ta catyi ra: Iyo minoo ra romano. Ra cu nuu sii zandaru cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ta vaha xaan ñiyɨvɨ cuu ra sihin maa yo ñiyɨvɨ hebreo ndya cuhva ndya i tyiyahvi maa ra ta i ndaa minoo vehe ñuhu ndi. ");
INSERT INTO mihNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tacuan ta cuahan ra Jesús sihin ra sahnu cuan, zoco cumañi ca saa ra vehe ra cu nuu cuan, ta i tasi ra cuan zuhva amigo ra, ta i catyi ra sihin ra Jesús: Tata, catyi ra cu nuu cuan vatyi ma zayangon suun sa cuhun ndya vehe ra vatyi cahnu xaan ca cuu moo, ta cahan nuu ra vatyi iyo cuatyi ra. Ta yoho, ra vaha xaan cuun. ");
INSERT INTO mihNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yucuan cuenda ña cuñi ra quisi ra nu ndyoon. Zoco tatu cua catyi moo vatyi nduvaha muzu ra, cua nduvaha ra vazu ma cuhun, catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Vatyi maa ra, ra ndyaca ñaha sii zandaru cuu ra. Ta cuu catyi ra sihin minoo ra: “Cuahan”, ta cuhun ra. Ta catyi ra sihin inga ra: “Ñaha”, ta vasi ra. Ta catyi ra sihin muzu ra: “Tyehen zavohon”, ta zavaha ra sii si. Ta tacuan tucu moo, catyi ra, vatyi tatu catyun vatyi nduvaha muzu ra, cua nduvaha ra. Catyi ra cuan sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ta sa siñi ra Jesús cuhva cahan ra cuan, ta iyo xaan i cuñi ra sa cuenda ra cu nuu cuan. Ta i nasico cava ra, ta i catyi ra sihin ñiyɨvɨ ndyico sii ra: Catyi sihin ndo vatyi tañaha ca nañihi sii minoo ra hebreo ra sino iñi sii ra Ndyoo tañi sino iñi ra cuan. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ta cuanuhu ra i tasi ra cu nuu cuan, ta sa nasaa ra i ndyehe ra vatyi sa nduvaha muzu cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yaha cuan ta inga quɨvɨ cuahan ra Jesús minoo ñuu sa nañi Naín. Ta cuahan tucu ra sica noo sihin ra ta cuaha xaan ca ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ta cuhva sa cua saa ra yatyi ñi ñuu cuan, ta ndyehe ra vatyi quita cuaha xaan ñiyɨvɨ ñuu cuan. Ta ndyizo ñu minoo ndɨyɨ. Minoo tuhun ñi zehe ña iyo cuu ra i sihi cuan. Ta ñandahvi cuu maa ña. ");
INSERT INTO mihNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ta sa ndyehe ra Jesús sii ña, i cundahvi xaan iñi ra sii ña, ta i catyi ra: Ma vacun. ");
INSERT INTO mihNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ta i tuhva ra Jesús, ta i tɨɨn ra satu ñoho ndɨyɨ. Ta ra ndyizo satu cuan, i sicuɨñɨ ra. Ta i catyi ra Jesús sihin ra ñoho cuan: Ra yoco, catyi suhun vatyi nduviton. ");
INSERT INTO mihNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tacuan ta i nduvita ra cuan, ta i quisaha cahan ra. Ta i nacuhva cuenda ra Jesús sii ra sii zɨhɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ta i yuhu xaan tandɨhɨ ñiyɨvɨ i ndyehe. Ta i zacahnu xaan ñu sii ra Ndyoo, ta i catyi ñu: Ihya ra cuu minoo profeta cahnu. Ta inga ñu i catyi: Cahnu xaan sa zavaha ra Ndyoo sihin yo vityi. ");
INSERT INTO mihNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ta i sito ñiyɨvɨ nacahnu Judea ta nacahnu ityi cuan cuhva i zavaha ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ta i nacatyi ra sica noo sihin ra Juan sihin ra tandɨhɨ sa zavaha ra Jesús. Ta i cana ra Juan sii uu tahan ra sica noo sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ta i tasi ra sii ra nu ndyaa ra Jesús vatyi cua ndaca tuhun ra sii ra tatu ra Cristo cuu ra, ra cua zacacu sii ñiyɨvɨ, a tatu cuñi si sa cuatu ra ndya cua quisi inga ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ta saa ra i tasi ra Juan nu ndyaa ra Jesús, ta i catyi ra sihin ra: ¿Atu yoho cuu Cristo, ra cua zacacu sii ndi a cuatu ca ndi naquisi inga ra? ");
INSERT INTO mihNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ta zuun ñi cuhva sa yucu ra cuan, i zanduvaha ra Jesús sii cuaha xaan ñiyɨvɨ cuhu, cuaha nuu cuehe, ta ñu ñoho tatyi cuihna. Ta cuaha xaan ñiyɨvɨ cuaa i nandyehe zacuu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tacuan ta i catyi ra Jesús sihin ra i tasi ra Juan: Cuahan ndo ta nacatyi ndo sihin ra Juan tandɨhɨ sa i ndyehe ndo ta sa siñi ndo. Nacatyi ndo cuhva nandyehe ra cuaa, ta cuhva nacaca ra coxo, ta cuhva nduvaha ra tyahyu, ta cuhva nacuɨñɨ ra zoho, ta cuhva nandoto ñiyɨvɨ i sihi. Ta nacatyi ndo cuhva siñi ñiyɨvɨ ndahvi Tuhun Vaha, cuhva cua cacu ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ta catyi ndo sihin ra vatyi zɨɨ xaan cua cuñi ñiyɨvɨ tatu ma zaña ñu sa sino iñi ñu sii. Catyi ra Jesús sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ta sa yaha cuahan ra i tasi ra Juan, ta i quisaha ndaca tuhun ra Jesús sii ñiyɨvɨ, ta catyi ra: ¿Ñaa sa sindyehe ndo quɨvɨ i sahan ndo nu ityi xaan nu yoñi ñiyɨvɨ iyo? ¿Atu sahan ndo vatyi cua ndyehe ndo minoo tuñɨɨ sa canda zacuu tatyi? ");
INSERT INTO mihNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿A atu sahan ndo vatyi cua ndyehe ndo sii minoo ra ñoho zahma vaha? Zoco ña tacuan vatyi ñiyɨvɨ ñoho zahma vaha xaan, iyo ñu vehe rey. ");
INSERT INTO mihNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Atu yɨvɨ minoo ra cu profeta cuu sa sindyehe ndo? Zuun. Ta cahnu ca ra cuu ra ta zɨquɨ tandɨhɨ inga ra cahan tuhun i saha ra Ndyoo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Zuun ra cuu ra sa cahan si tuhun nuu tutu ra Ndyoo nu i tyaa ra Isaías tyehen: “Yuhvi ra Ndyoo cua tasi sii minoo ra ityi nuu ca, ta cua zanduvaha ra cuhva iyo ñiyɨvɨ vatyi cua saa moo cuee ca, ta cua tyizoho ñu sa cohon.” ");
INSERT INTO mihNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ta catyi sihin ndo vatyi tandɨhɨ rayɨɨ ra cacu, yoñi inga ca ra ñiñi ca ta zɨquɨ ra Juan. Zoco ra luhlu ca, ra cuhun nu ndyaca ñaha ra Ndyoo, cahnu ca ra ta zɨquɨ ra Juan, ra zacoo ndutya sii ñiyɨvɨ. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ta tandɨhɨ ñiyɨvɨ sa siñi sa cahan ra Jesús ta ra tava xuhun cuenda ra ndyaca ñaha, i zacahnu xaan ñu sii ra Ndyoo, ta nacoto ñu vatyi ndoo xaan sa zavaha ra Ndyoo. Sa yaha sicoo ndutya maa ñu i zacuu ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Zoco ra fariseo ta ra maestro cuenda ley hebreo ñá cuñi ra quihin ra sa saha ra Ndyoo sii ra. Yucuan cuenda ñá cuñi ra coo ndutya ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ta i catyi ra Jesús sa cuenda ra: ¿Ñaa ñi cuhva quehin sihin ñiyɨvɨ iyo vityi? ¿Tañi yoo ñi sa caa caa ñu? ");
INSERT INTO mihNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Caa ñu tañi sa ndyihi sa ndyaa nuyahvi, ta cana saa si sii tahan si, ta catyi si: “Tɨvɨ ndi cutu, ta ñá sata saha ndo. Ta sata ndi yaa tucuihya iñi, ta ñá sacu ndo.” ");
INSERT INTO mihNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tacuan iyo maa ndo vatyi ra Juan, ra i zacoo ndutya sii ñiyɨvɨ, i quisi ra ta ñá sasi vaha ra, ta ñá sihi ra vino. Ta catyi ndo vatyi ñoho minoo tatyi cuihna sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ta zɨquɨ i saa mi, ra i quisi ndya gloria. Ta sasi ta sihi. Ta catyi ndo vatyi tuhva xein coho ta cuahyi xein. Ta cuxaan ndo vatyi vaha ñiyɨvɨ cui sihin ra iyo cuatyi ta sihin ra tava xuhun cuenda ra ndyaca ñaha. ");
INSERT INTO mihNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ta catyi sihin ndo vatyi saha ra Ndyoo sa siñi tuñi maa ra sii ñiyɨvɨ sino iñi sii ra. Ta cua zañaha ñu sii maa ndo vatyi vaha sa siñi tuñi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ta i cana minoo ra fariseo sii ra Jesús sa cua casi ra xita vehe ra. Ta cuahan ra Jesús vehe ra fariseo cuan, ta sicundyaa ra mesa. ");
INSERT INTO mihNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tacuan ta minoo ñaha zɨɨ iñi ñuu cuan i sito ña vatyi ndyaa ra Jesús vehe ra fariseo cuan, ta i quisi ña sihin minoo yutyi azetye vixi. ");
INSERT INTO mihNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ta i sicuɨñɨ ndyaa ña saha ra Jesús, ta i sacu xaan ña vatyi ndu‑uu iñi ña cuatyi ña, ta i quisaha nacatya ña saha ra Jesús sihin ndutya nuu ña. Ta zɨquɨ i zana‑ityi ña saha ra sihin ixi xiñi ña. Ta sihi ña saha ra. Ta i saca ña azetye vixi cuan saha ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ta cuhva sa ndyehe ra Simón tacuan, ta i sica iñi ra: “Tatu ndisa vatyi minoo ra profeta cuu ra ya, cua nacoto ra yozo caa iyo ñaha sa tɨɨn sii ra vatyi iyo xaan cuatyi ña.” ");
INSERT INTO mihNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ta i catyi ra Jesús sihin ra Simón: Simón, iyo minoo tuhun cuñi nacatyi suhun. Ta i catyi ra Simón: Vaha, maestro. Nacatyun sihin. ");
INSERT INTO mihNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ta i catyi ra Jesús sihin ra: Sicoo minoo ra, ta uu tahan ra i sitavi sii ra. Minoo ra tavi ra ohon ziendu denario (tañi ohon mil peso cuu si). Ta inga ra tavi ra uu xico usi ñi denario (tañi ohon ziendu peso ñi). ");
INSERT INTO mihNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ta nduu tahan ra cuan, ñá cuu tyiyahvi ra sa tavi ra. Ta ra sa saha noo xuhun cuan, zaha ra tucahnu iñi sii nduu tahan ra, ta ñá tyiyahvi ca ra sii ra. Ta vityi catyun, Simón, ¿ndya ra cua cuñi ca sii ra sa saha noo cuan? Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ta i nacahan ra Simón ta catyi ra: Ra sa cuaha ca tavi cuan. Catyi ra. Tacuan ta i catyi ra Jesús: Ndisa sa cohon. ");
INSERT INTO mihNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ta zɨquɨ i nandyehe ra Jesús sii ñaha cuan, ta i catyi ra sihin ra Simón: Ndyehun sii ñaha ya. Yuhvi i quɨhvi vehun, ta ñá sohon ndutya ndoo sehi. Zoco maa ña i nacatya ña sehi sihin ndutya nuu ña, ta zana‑ityi ña sihin ixi xiñi ña. ");
INSERT INTO mihNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yoho ñá suhun xɨti. Zoco ndya cuhva ndya quɨhvi ihya ta ñá zaña maa ña sa sihi ña sehi. ");
INSERT INTO mihNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ñá tyuhun azetye xiñi. Zoco ihya ñaha i tyihi azetye vixi sehi. ");
INSERT INTO mihNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yucuan cuenda catyi suhun, Simón, vatyi vazu cuaha xaan cuatyi ña iyo, zoco sa zehi tucahnu iñi sii ña tandɨhɨ si. Yucuan cuenda cuñi xaan ña sii. Inga ñiyɨvɨ sa zuhva ñi cuatyi ñu iyo, zuhva ñi zehi tucahnu iñi sii ñu, ta zuhva ñi cuñi ñu sii. ");
INSERT INTO mihNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ta i catyi ra Jesús sihin ñaha cuan: Sa ndasi cuatyun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tacuan ta inga ra yucu mesa sihin ra, i quisaha sica iñi ra sihin añima ra: “¿Yoo ra cuu ra ya vatyi zandasi tucu ra cuatyi ñiyɨvɨ?” ");
INSERT INTO mihNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ta i catyi ra Jesús sihin ñaha cuan: Cuahan vityi, sa cacun vatyi sino iñun. Cuahan sihin sa vaha. ");
INSERT INTO mihNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yaha cuan ta cuee ca ta cuahan ra Jesús tahan tahan ñuu nahnu ta ñuu ndyihi. I cahan ra Tuhun Ndyoo nuu ñiyɨvɨ. Ta i zacoto ra sii ñu Tuhun Vaha, cuhva cuñi ra Ndyoo cundyaca ñaha ra sii ñu. Ta ndɨhɨ sa usi uu tahan ra i casi ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ta cuahan tucu ñu zɨhɨ sihin ra. Maa ñu cuu ñu i zanduvaha ra ta cuhu ñu a i ñoho tatyi cuihna sii ñu ta i tava ra. Ta cuahan ña María minoo ñaha ñuu Magdala sihin ñu. I siñoho usa tahan tatyi cuihna sii ña, ta nduvaha ña. ");
INSERT INTO mihNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ta cuahan tucu ña Juana, ñazɨhɨ ra Chuza. Minoo ra cu tyiño sa cuenda ra rey Herodes cuu maa ra. Ta cuahan ña Susana ta cuaha xaan ca ñu cuahan. Ta i tyindyee ñu sii ra Jesús sihin xuhun ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cuaha xaan ñiyɨvɨ i quita sa zɨɨn zɨɨn ñuu, ta titahan ñu vatyi cua tyizoho ñu sa cahan ra Jesús. Ta i cahan ra sihin ñu zɨquɨ minoo cuhva ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Cuahan minoo ra nu iyo tyiño ra vatyi cua quɨtɨ ra sɨtɨ trigo nu ñuhu ra. Ta cuhva sa quɨtɨ ra sii si, zuhva si canacoyo si ityi. Ta i sañi ñiyɨvɨ sii si, ta i sasi zaa sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ta zuhva sɨtɨ cuan, i canacoyo si nu yaxi ñoho ñuhu vatyi ñoho xaan yuu. Ta quɨvɨ i caña si, i na‑ityi si vatyi ña coco caa ñuhu ta i cumañi ndutya sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ta zuhva sɨtɨ cuan, i canacoyo si tɨcuɨ iñu. Ta i caña si sisi iñu, zoco i zahvi iñu sii si. Ta ñá saha si sɨtɨ si. ");
INSERT INTO mihNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ta zuhva ca sɨtɨ cuan, i canacoyo si nu vaha ñuhu, ta saha xaan si sɨtɨ si. Iyo si saha si minoo ziendu sɨtɨ si. Catyi ra Jesús. Ta sa yaha cahan ra tuhun cuan, i cana saa ra, ta i catyi ra: Tatu siñi ndo, cuɨñɨ ndo sa quehin. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tacuan ta i ndaca tuhun ra i casi ra sii ra ñaa cuñi si catyi si cuhva cahan ra sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ta i catyi ra Jesús sihin ra: Saha ra Ndyoo sa coto maa ndo tuhun xehe sa cuenda cuhva ndyaca ñaha maa ra. Zoco sihin inga ñiyɨvɨ, maa ñi sihin minoo cuhva quehin vatyi cua ndyehe ñu, zoco ma nacoto ñu ñaa sa ndyehe ñu. Cua cuɨñɨ ñu, zoco ma cutuñi iñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ihya cuu cuhva cuñi si catyi si: Sɨtɨ cuan cuu tañi Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ta tañi sa canacoyo sɨtɨ cuan ityi, tacuan iyo minoo ityi ñiyɨvɨ siñi Tuhun Ndyoo. Ta saa cuihna, ta quindyaa ra sii si sisi añima ñu coto cua sino iñi ñu ta cacu ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ta tañi sa canacoyo sɨtɨ nu ñoho xaan yuu iyo inga ityi ñiyɨvɨ sa siñi Tuhun Ndyoo. Zɨɨ xaan cuñi ñu sihin si zuhva ñi quɨvɨ, zoco ña quɨhvɨ vaha si añima ñu. Ta ña naha cua sino iñi ñu. Tatu cua quisi minoo tundoho zɨquɨ ñu a cuxaan ñiyɨvɨ sihin ñu sa cuenda Tuhun Ndyoo, yatyi xaan cua zaña ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ta inga ñiyɨvɨ cuu tañi sa canacoyo sɨtɨ nu ndyaa iñu. Siñi ñu Tuhun Ndyoo, zoco sica xaan iñi ñu inga tuhun, tuhun sa iyo ñuu ñiyɨvɨ. Sica iñi ñu tuhun sa nducuca ñu ta cuhva cua cuzɨɨ iñi ñu ñuu ñiyɨvɨ ya. Ta ma zatyiño vaha Tuhun Ndyoo sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Zoco tañi sɨtɨ canacoyo nu vaha ñuhu, tacuan iyo inga ñiyɨvɨ. Ndoo xaan iyo ñu, ta vaha xaan añima ñu. Siñi ñu Tuhun Ndyoo, ta zavaha ñu sii si. Ta cundyee xaan iñi ñu. Ta cuaha xaan sa vaha zavaha ñu cuhva catyi Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tatu tyaa ñiyɨvɨ minoo lámpara sisi vehe ñu, ma tyihi ñu sii si xu sito a inga nu xehe. Ña tacuan vatyi tyaa ñu sii si nu zucu vatyi tacuan ta ndundisi sisi vehe, ta cuu ndyehe ñiyɨvɨ quɨhvɨ sisi vehe. ");
INSERT INTO mihNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ta tañi lámpara tatu ñoho xehe si, tacuan iyo cuhva zacuehi sii ndo vityi. Zoco cua coo quɨvɨ ta cua cuɨñɨ ñiyɨvɨ nacahnu ñuu ñiyɨvɨ cuhva zacuehi ihya. ");
INSERT INTO mihNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yucuan cuenda coto vaha ndo sii ndo sihin sa siñi ndo vatyi tatu tyaa ndo yahvi sa quehin, cuaha ca cua zacuehi sii ndo. Zoco tatu ma tyizoho ndo cua quindyei ndya cuhva ndya sa zuhva ñi sa sica iñi ndo vatyi sa cutuñi iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tacuan ta i saa zɨhɨ ra ta yañi ra Jesús, zoco ñá cuu quɨhvɨ ñu nu ndyaa ra vatyi tuu xaan ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ta i zacoto ñiyɨvɨ yucu yucuan sii ra ta catyi ñu: Zɨhun ta yañun, nandyaa ñu sata vehe, ta cuñi ñu cahan ñu suhun. ");
INSERT INTO mihNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ta i nacahan ra Jesús, ta catyi ra: Ñiyɨvɨ sa cuu zɨhi ta yañi cuu ñu siñi Tuhun Ndyoo ta zavaha ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Minoo quɨvɨ i quɨhvɨ ra Jesús minoo barco sihin ra i casi ra. Ta i catyi ra sihin ra: Coho yo inga siyo miñi. Ta cuahan ra sihin barco cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ta cuhva sa cuahan ra mahñu miñi cuan, ta quixi ra Jesús. Ta sicava minoo tatyi cahnu xaan. Ta quɨhvɨ ndutya sisi barco. Ta i situ tu, ta i quisaha ndyee tu. ");
INSERT INTO mihNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ta i zandoyo ra sii ra Jesús ta catyi ra: ¡Maestro! ¡Maestro! ¡Sa cuñi cunaa yo! Catyi ra. Ta i nduvita ra Jesús, ta i cahan ra sihin tatyi ta sihin ndutya, ta i cutaxi si. ");
INSERT INTO mihNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ta i catyi ra sihin ra yucu sihin ra: ¿Ñacu ña nɨɨ iñi ndo? Catyi ra. Zoco ra cuan, yuhu xaan ra, ta iyo xaan i cuñi ra. Ta i quisaha ndaca tuhun ra sii ra tahan ra: ¿Yoo ra cuu ra ya? vatyi cuhva ndya tatyi ta cuhva ndya ndutya ta tyaa si yahvi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tacuan ta i saa ra Jesús nu cu si Gadara sa ndyaa inga siyo miñi cahnu sa nañi Galilea. ");
INSERT INTO mihNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","I quita ra Jesús barco, ta i tuhva minoo ra ñuu cuan sii ra. Sa naha xaan ñoho tatyi cuihna sii ra, ta ña ñoho ra zahma ra, ta ña ndyaa ra vehe ra. Sica noo ñi maa ra nu ñaña. ");
INSERT INTO mihNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ta tuhva tatyi ña vaha cuan tɨɨn sii ra, ta yucuan cuenda sihñi ñu cadena ndaha ra ta saha ra vatyi ma cuu cuhun ra. Zoco i sahnu ra cadena sihin fuerza sa saha tatyi ña vaha cuan sii ra, ta i zacono tatyi cuan sii ra ndya nu yoñi ñiyɨvɨ iyo. Ta cuhva sa ndyehe ra sii ra Jesús, i sicuɨñɨ sɨtɨ ra nuu ra, ta i cana saa ra, ta catyi ra: ¿Ñaa sa cuñun sihin mi, Jesús? Moo cuu zehe Ndyoo ra cahnu ca. Sa ndyoo ñi ma zandyehun tundoho sii. Tacuan i catyi ra vatyi sa catyi ra Jesús sihin tatyi cuihna vatyi naquita si sisi añima ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ta zɨquɨ i ndaca tuhun ra Jesús sii ra: ¿Ñaa nañun? Ta tatyi cuan nacahan si ta catyi si: Nañi Legión. Tacuan catyi tatyi ña vaha cuan vatyi cuaha xaan si ñoho sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ta i sica tatyi ña vaha cuan tumañi iñi sii ra Jesús sa ma zacuhun ra sii si sisi minoo xahva cono xaan nu ma cuu quita si. ");
INSERT INTO mihNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ta sica tatyi ña vaha cuan sii ra Jesús vatyi nacuhva ra sa quɨhvɨ si sisi quɨnɨ vatyi yucu xaan tɨ yucuan. Ta i saha ra Jesús sa quɨhvɨ si sisi quɨnɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ta i quita tatyi ña vaha cuan sii ra ndahvi cuan, ta i quɨhvɨ si sisi quɨnɨ cuan. Ta ñihi xaan i cacono quɨnɨ cuan nu iñi noo yuhu miñi. Ta i sihi tandɨhɨ tɨ sisi ndutya. ");
INSERT INTO mihNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ta cuhva sa ndyehe ra zacuenda quɨnɨ cuan sa tahan tɨ, i sino xaan ra, ta i nacatyi ra sihin ñiyɨvɨ sa ndyehe ra sisi cuhu ta sisi ñuu. ");
INSERT INTO mihNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ta i quita coyo ñiyɨvɨ vatyi cua ndyehe ñu ñaa sa cuu, ta i saa ñu nu ndyaa ra Jesús. Ta i ndyehe ñu sii ra sa quita tatyi cuihna cuan. Nandyee ra nuu ra Jesús. Sa ñoho ra zahma ra, ta sa nduvaha cuñi xiñi ra. Ta i yuhu xaan ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ta ñiyɨvɨ i ndyehe, i nacatyi ñu sihin inga ñu cuhva i quita tatyi ña vaha sii ra ta i nduvaha ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tacuan ta cuaha xaan ñiyɨvɨ nacahnu Gadara i catyi ñu sihin ra Jesús vatyi nacuhun ra vatyi i yuhu xaan ñu sa cuenda cuhva i zavaha ra sihin tatyi cuihna cuan. Ta i nandɨhvɨ ra Jesús sisi barco. ");
INSERT INTO mihNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ta ra sa quita tatyi cuihna cuan, i sica ra sii ra Jesús sa cuhun ra sihin ra, zoco i catyi ra Jesús sihin ra: ");
INSERT INTO mihNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Cuanuhun ndya vehun. Ta nacatyun sihin ñiyɨvɨ suun ñaa sa i zavaha ra Ndyoo suhun, cuhva sa cahnu xaan i tyindyee ra suun. Ta cuahan ra cuan, ta i nacatyi ra nacahnu ñuu ra cuhva sa cahnu xaan i zavaha ra Jesús sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ta quɨvɨ sa nasaa ra Jesús inga siyo miñi, cuaha xaan ñiyɨvɨ ndatu sii ra. Ta zɨɨ xaan cuñi ñu vatyi nasaa ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tacuan ta i saa minoo ra sa nañi Jairo. Minoo ra cu tyiño cuenda vehe ñuhu ñuu cuan cuu ra. Ta i sicuɨñɨ sɨtɨ ra nuu ra Jesús, ta i sica xaan ra tumañi iñi sii ra sa cuhun ra sihin ra ndya vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Vatyi minoo tuhun ñi zehe ra iyo. Usi uu cuiya ña, ta sa cuñi cuu ña sihin cuehe. Ta cuahan ra Jesús vehe ra cuan. Ta i sindyico cuaha xaan ñiyɨvɨ sii ra. Ñihi xaan i catyihi ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ta tɨcuɨ ñiyɨvɨ cuan ñoho minoo ñaha cuhu. Sa usi uu cuiya sa cuhu ña cuehe sa cuu ña nɨñɨ. Cuaha xaan médico i zacuu tata sii ña. I zanaa ña tandɨhɨ cuii sa iyo sii ña. Zoco ñá nduvaha ña sihin cuhva zavaha médico. ");
INSERT INTO mihNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ta i quisi ña ityi sata ra Jesús zava mahñu ñiyɨvɨ cuan, ta i tɨɨn ña yuzahma ra. Ta zuun ñi caa cuhva cuan i sicuita nɨñɨ ña. ");
INSERT INTO mihNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ta i catyi ra Jesús: ¿Yoo sa tɨɨn sii? Ta tandɨhɨ ñiyɨvɨ cuahan sihin ra catyi ñu vatyi yɨvɨ maa ñu. Ta ra Pedro ta inga ra ndɨhɨ sihin ra Jesús i catyi ra: Maestro, tuu xaan ñiyɨvɨ cuahan suhun, ta catyihi ñu suun. ¿Ta ñaa cuenda ndaca tuhun yoo sa tɨɨn suun? ");
INSERT INTO mihNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Zoco i catyi ra Jesús: Iyo minoo ñiyɨvɨ i tɨɨn sii, vatyi tuu iñi vatyi cuahan zuhva tundyee iñi sii. ");
INSERT INTO mihNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ta sa sito ñaha cuan vatyi ma cuu tyixehe ña, ta i quisaha nɨhɨ ña vatyi yuhu xaan ña. Ta i sicuɨñɨ sɨtɨ ña nuu ra Jesús. Ta ityi nuu tandɨhɨ ñiyɨvɨ i nacatyi ña sihin ra ñaa cuenda i tɨɨn ña sii ra ta yozo caa i nduvaha ña sa zuun ñi caa cuhva cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ta i catyi ra Jesús sihin ña: Zihi, i nduvohon vatyi i sino iñun sii. Cuahan sihin sa vaha. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nɨɨ ñi sa cahan ra Jesús tuhun ya, ta i quisi minoo ra iyo vehe ra Jairo cuan. Ta i catyi ra sihin ra Jairo: Sa sihi zehun. Ma zayanga con sii ra maestro ya. ");
INSERT INTO mihNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ta sa siñi ra Jesús tuhun cuan, i catyi ra: Ma yuhun. Sino iñun ta cua nduvaha ña. ");
INSERT INTO mihNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ta sa saa ra Jesús vehe ra Jairo, ñá saha ra quɨhvɨ ñiyɨvɨ, maa ñi ra Pedro ta ra Jacobo ta ra Juan ta ra Jairo, zutu ña, sihin ñazɨhɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ta i sacu xaan tandɨhɨ ñiyɨvɨ vatyi i sihi ña, zoco i catyi ra Jesús: Ma vacu ndo. Ñá sihi ña. Quixi ña. ");
INSERT INTO mihNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ta i sacu ndyaa ñu sii ra vatyi sito ñu vatyi sa sihi ña. ");
INSERT INTO mihNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tacuan ta i tɨɨn ra Jesús ndaha ña luhlu cuan, ta i catyi ra sihin ña: Ñaha luhlu, nduviton. ");
INSERT INTO mihNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ta i nandɨhvɨ añima ña, ta zuun ñi caa cuhva cuan i nduvita ña. Ta i catyi ra sihin ñu nacuhva ñu sa casi ña. ");
INSERT INTO mihNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iyo xaan i cuñi zutu ña ta zɨhɨ ña, zoco ñihi xaan i saha ra tyiño sii ñu sa ma nacatyi ñu nu sihin minoo ñiyɨvɨ cuhva i cuu. ");
INSERT INTO mihNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","I zandu‑ɨɨn ra Jesús sii sa usi uu tahan ra i casi ra, ta i saha ra tundyee iñi sii ra vatyi cua tava ra tatyi ña vaha, ta cua zanduvaha ra sii ñiyɨvɨ cuhu. ");
INSERT INTO mihNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ta i tasi ra sii ra sa cahan ra Tuhun Ndyoo, ta cua nacatyi ra sihin ñiyɨvɨ cuhva ndyaca ñaha ra Ndyoo. Ta cua zanduvaha ra sii ñiyɨvɨ cuhu. ");
INSERT INTO mihNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ta i catyi ra Jesús sihin ra: Ñahñi sa cuizo ndo ityi cuhun ndo. Ma cuñaa ndo numinoo tutatu, ta numinoo yɨtɨ, ta nu sa casi ndo. Ma cuizo ndo xuhun. Ndɨhɨ ñoho ñi ndo zahma ndo cuhun ndo, ta ma cuizo ndo inga. ");
INSERT INTO mihNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tatu saha ñiyɨvɨ minoo vehe cundyaa ndo, yucuan ndoo ndo ndya cua cuhun ndo inga ñuu. ");
INSERT INTO mihNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ta tatu saa ndo minoo ñuu ta ña cuñi ñiyɨvɨ tyizoho ñu sa cahan ndo, quita ndo ñuu cuan. Naquɨzɨ ndo saha ndo vatyi ma cuhun nu ñiyaca ñuu cuan sihin ndo. Tacuan ta cua coto ñiyɨvɨ vatyi i zavaha ñu sa ña vaha sihin ndo. Tacuan i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ta i quihin ra ityi cuahan ra tahan tahan ñuu. I nacatyi ra Tuhun Vaha sihin ñiyɨvɨ, ta nacahnu i zanduvaha ra sii ñu cuhu. ");
INSERT INTO mihNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ra Herodes i cuu ra ndyaca ñaha nacahnu Galilea. Ta i ñihi ra tuhun sa cuenda tandɨhɨ sa zavaha ra Jesús. Ta ñá ñihi vaha ra cuhva yoo ra cuu ra Jesús vatyi zuhva ñiyɨvɨ i catyi ñu vatyi ra Juan cuu ra ta i nandoto ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ta inga ñiyɨvɨ i catyi ñu vatyi ra Elías cuu ra Jesús. Ta inga ñu i catyi ñu vatyi i nandoto minoo ra profeta. ");
INSERT INTO mihNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Zoco i catyi ra Herodes: Zuun ñi mi i tava tyiño sii ra sahndya yuu zucu ra Juan. ¿Ta yoo ra cuu ra siñi xein tuhun vityi? Ta i cuñi xaan ra Herodes ndyehe ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ta i nasaa coyo ra apóstol, ta i nacatyi ra sihin ra Jesús tandɨhɨ sa i zavaha ra. Tacuan ta i quihin ra Jesús sii ra ta cuahan ra sihin maa ñi maa ra ityi ñuu Betsaida. ");
INSERT INTO mihNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Zoco i sito ñiyɨvɨ, ta sindyico tuu xaan ñu sii ra, ta i cahan vaha ra sihin ñu sa cuenda cuhva ndyaca ñaha ra Ndyoo. Ta i zanduvaha ra sii ñiyɨvɨ cuhu. ");
INSERT INTO mihNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ta sahiñi i tuhva ra i casi ra sii ra, ta i catyi ra sihin ra Jesús: Catyun sihin ñiyɨvɨ nacuhun ñu tandɨhɨ ñuu, tandɨhɨ cuadria sa ndyaa yatyi ñi cuzata ñu sa casi ñu ta cuzu ñu vatyi ñahñi maa sa iyo ihya. ");
INSERT INTO mihNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Zoco i catyi ra Jesús sihin ra: Cuhva maa ndo sa casi ñu. Ta i catyi ra sihin ra Jesús: Ñahñi maa sa cumi ndi ihya, ohon tahan ñi pan ta uu tahan ñi tyiyaca. ¿A atu sica iñun sa cuu zata ndi sa casi tandɨhɨ ñu ya? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Vatyi tañi ohon mil rayɨɨ yucu yucuan. (Ta zɨɨn ñu zɨhɨ ta sa ndyihi.) Ta i catyi ra Jesús sihin ra i casi ra: Catyi ndo sihin ñu vatyi nacundyaa ñu. Uu xico usi tahan ñu sa minoo minoo ityi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ta tacuan i sicundyaa ñu i zacuu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ta zɨquɨ i quihin ra Jesús sa ohon tahan pan ta uu tahan tyiyaca, ta i nandyehe ndaa ra ityi andɨvɨ, ta i saha ra tyahvi ndyoo sii ra Ndyoo. Ta i sahnu ndyihi ra pan ta tyiyaca cuan. Ta i nducuaha si. Ta i saha ra sii si sii ra i casi ra vatyi cua zasa ra sii si sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ta i sasi tandɨhɨ ñu, ta i ndaha xaan iñi ñu. Ta zɨquɨ i zanacutu ñu usi uu tahan tyica sihin yɨquɨ pan sa nandoo ta tyiyaca cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Minoo quɨvɨ i quita zɨɨn ra Jesús sihin ra i casi ra minoo nu taxi ñi, ta i sica tahvi ra Jesús sii ra Ndyoo. Ta yaha cuan ta zɨquɨ i ndaca tuhun ra sii ra ndɨhɨ sihin ra ta catyi ra: ¿Yoo ra cui, catyi ñiyɨvɨ? ");
INSERT INTO mihNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ta i nacahan ra ta catyi ra: Iyo ñu catyi ñu vatyi ra Juan, ra i zacoo ndutya quɨvɨ cuan cuun. Ta inga ñu catyi vatyi ra Elías cuun. Ta inga tucu ñu catyi vatyi i nandoto minoo profeta, ta zuun ra cuan cuun. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tacuan ta i ndaca tuhun ra Jesús sii tandɨhɨ ra ta catyi ra: ¿Ta yoo ra cui catyi maa ndo? Ta i nacahan ra Pedro ta catyi ra: Yoho cuu ra Cristo. Zehe ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ta i nacatyi ra Jesús sihin ra i casi ra vatyi ma nacatyi ra tuhun cuan sihin numinoo ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ta i catyi ra: Cuaha xaan tundoho cua ndyehe ra i quisi ndya gloria. Cua cuxaan ra mandoñi ta ra zutu nahnu ta ra maestro cuenda ley hebreo sihin ra. Ta cua cahñi ra cuan sii ra. Ta sa cu uñi quɨvɨ cua nandoto ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ta i catyi ra Jesús sihin tandɨhɨ ra: Tatu iyo ra cuñi ra cundyico ra sii, nazama ra cuhva iyo ra. Ta ma zacahnu ra sii ra. Ta nandyehe ra tundoho sa cuenda mi. Ta nazavaha ra cuhva zavehi. ");
INSERT INTO mihNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tatu ña cuñi ñiyɨvɨ sa cuu ñu sa cuenda Tuhun Ndyoo, cua cuu ñu. Ta cua cuhun ñu andyaya. Ta ma cundito ñu sihin ra Ndyoo. Zoco tatu cua cuu ñiyɨvɨ sa cuenda mi a sa cuenda Tuhun Ndyoo, cua cundito ñu sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Ñaa sa ñihi ñiyɨvɨ sa zahacanaa ñu tandɨhɨ sa iyo ñuu ñiyɨvɨ ta quɨvɨ cua cuu ñu ndaha cua naa ñu? ");
INSERT INTO mihNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tatu iyo ra cahan nuu sa cuenda mi a sa cuenda Tuhun Ndyoo, tacuan tucu cua cucahan nui sihin ra. Vatyi ra i quisi ndya gloria cui, ta cua quisi tuqui sihin ángel. Ta cua ndyehe ñiyɨvɨ vatyi cahnu xaan cuu Zuti. ");
INSERT INTO mihNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ta sa ndisa cuii catyi sihin ndo vatyi iyo zuhva ra yucu ihya, ma cuu ra ndya cuhva ndya cua ndyehe ra cuhva cua cundyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","I yaha tañi uña quɨvɨ sa yaha catyi ra Jesús cuhva cuan. Ta zɨquɨ i ndaa ra Jesús xiñi minoo yucu cua cahan ra sihin ra Ndyoo, ta cuahan ra Pedro ta ra Juan ta ra Jacobo sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ta cuhva sa sica tahvi ra sii ra Ndyoo, ta i zama cuhva caa nuu ra, ta i nducuisi xaan zahma ra ta xiño xaan si. ");
INSERT INTO mihNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ta i quituu uu tahan ra natuhun sihin ra. Minoo ra cuu ra ra Moisés, ta inga ra cuu ra ra Elías. (Ra i sihi ta sa naha cuu nduu tahan ra cuan.) ");
INSERT INTO mihNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ndisi xaan nu siyucu ra, ta i cahan ra tuhun yozo caa cua cuu ra Jesús ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ta ra Pedro ta ra tahan ra cuñi xaan ra cuzu ra, zoco ñá quixi ra vatyi ndyehe ra sa ndisi xaan nu nandyaa ra Jesús sihin sa uu tahan ra nandyaa sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ta cuhva sa cuahan ra yucu sihin ra Jesús, i catyi ra Pedro sihin ra Jesús: Maestro, vaha xaan yucu yo ihya. Nazavaha ndi uñi tahan vehe tyiyahva, minoo cuenda moo, ta minoo cuenda ra Moisés, ta minoo cuenda ra Elías, catyi ra. Zoco ñá sito ra Pedro ñaa tuhun cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ta cuhva sa cahan ra Pedro tacuan ta i noo minoo vico ta ndaha tyazi si sii tandɨhɨ ra. Ta i yuhu xaan ra sa quɨhvɨ ra sisi vico cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ta sisi vico cuan i siñi ra minoo nduzu sa catyi: Ra ihya cuu Zehi. Cuñi xein sii ra. Cuɨñɨ ndo sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ta sa yaha cahan nduzu cuan, tuhun cuan, ta i ndyehe ra ndɨhɨ sihin ra Jesús vatyi ña ndyaa ca inga ra cuan sihin ra Jesús. Maa tuhun ñi ca maa ra. Ta i sicumi xehe ra tandɨhɨ sa i ndyehe ra, ta sisi quɨvɨ cuan ñá nacatyi ra sihin numinoo ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ta inga quɨvɨ cuhva sa noo ra yucu cuan, cuaha xaan ñiyɨvɨ i zatahan sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ta minoo ra ñoho tɨcuɨ ñiyɨvɨ cuan i cana saa ra ta catyi ra: Maestro, sica xein tumañi iñi suun sa cua ndyehun sii zehi vatyi minoo tuhun ñi zehi iyo. ");
INSERT INTO mihNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ñoho minoo tatyi cuihna sii ra, ta ndya vaha ñi cuhva nduxaan si sii ra. Ta sacu saa ra, ta zanduva si sii ra nu ñuhu, ta saa tɨñɨ yuhu ra. Ña zaña si sii ra, ta zañicuehe si sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Sa catyi vatyi natava ra i casi moo sii si, zoco ñá cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ta i nacahan ra Jesús, ta catyi ra (sihin tandɨhɨ ñiyɨvɨ): Ndoho cuu ñiyɨvɨ ña sino iñi. ¿Yozo tahan ca quɨvɨ cua ndoi sihin ndo ta zɨquɨ cua sino iñi ndo? Ma cundyee iñi cundyei sihin ndo naha xaan ca. Sa naha xaan cundyee iñi sihin ndo. Ta ndyaca sii zehun ihya. ");
INSERT INTO mihNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ta cuhva sa vasi ra luhlu cuan, i zanduva tatyi cuihna cuan sii ra ta quiñi xaan i tahan ra. Ta xaan xaan i cahan ra Jesús sihin tatyi ña vaha cuan. Ta i zanduvaha ra sii ra luhlu cuan, ta zɨquɨ i nacuhva cuenda ra sii ra sii zutu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ta iyo xaan i cuñi tandɨhɨ ñiyɨvɨ vatyi cahnu xaan cuu tundyee iñi maa ra Ndyoo. Nɨɨ ñi sa iyo xaan cuñi tandɨhɨ ñiyɨvɨ sihin sa zavaha ra Jesús ta i quisaha catyi ra sihin ra i casi ra: ");
INSERT INTO mihNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tyizoho vaha ndo sa quehin vatyi cua xico minoo ra sii ra i quisi ndya gloria. Ta cua tɨɨn ñiyɨvɨ sii. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Zoco, ñá cutuñi iñi ra ñaa tuhun cahan ra. Ta ñá nacatyi ra Jesús sihin ra ñaa cuñi si catyi si. Ta yuhu ra ndaca tuhun ra sii ra Jesús ñaa tuhun cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tacuan ta i quisaha natuhun tahan xaan ra i casi ra Jesús sa cuenda cuhva yoo ra cuu ra ñiñi ca sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ta i sito ra Jesús ñaa sa sica iñi ra cuan sihin añima ra. Ta i quihin ra sii minoo ra luhlu, i sañi ndyaa ra sii ra ii siyo xiin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ta i catyi ra sihin ra ndɨhɨ sihin ra: Tatu zavaha ñiyɨvɨ sa vaha sihin minoo ra luhlu sa cuenda mi, tañi sihin mi zavaha ñu sa vaha cuu si. Ta tatu zavaha ñiyɨvɨ sa vaha sihin mi, zavaha ñu sa vaha sihin Zuti. Ta ra sa luhlu ca zaha maa ndo tuhun, yucuan ra cuu ra cahnu ca ityi nuu ra Ndyoo. Ta ra sa cahnu ca cuñi ndo, yucuan ra cuu ra luhlu ca ityi nuu ra Ndyoo. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tacuan ta i catyi ra Juan: Maestro, i ndyehe ndi minoo ra tava tatyi cuihna sihin zɨvɨ moo, zoco yɨvɨ ra tahan ndi cuu ra. Ta i catyi maa ndi sihin ra vatyi ma zavaha ra tacuan. ");
INSERT INTO mihNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ta i catyi ra Jesús sihin ra: Ña vaha sa ñá saha ndo. Vatyi tatu ña cahan ñiyɨvɨ ndya vaha ñi sii yo, tyindyee ñu sii yo. ");
INSERT INTO mihNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ta sa cuñi saa quɨvɨ cunanuhu ra Jesús ndya gloría, ityi i quisi ra. Yucuan cuenda cuñi ra Jesús cuhun ra ñuu Jerusalén nu cua cuu ra. Ta i quihin ra ityi cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ta i tasi ra tyiño ityi nuu ca nu cuahan ra, ta i quɨhvɨ ra i tasi ra minoo ñuu nu cu si Samaria vatyi cua nducu ra minoo nu cua quitatu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ta ñá saha ra samaritano sa cundyaa ra Jesús ñuu ra vatyi cuahan ra Jerusalén. (Ta ña cuu ndyehe ñiyɨvɨ samaritano sii ñiyɨvɨ ñuu Jerusalén.) ");
INSERT INTO mihNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ta cuhva sa sito ra Jacobo ta ra Juan vatyi ñá saha ra samaritano sa cundyaa ra ñuu ra ta i cuxaan ra ta catyi ra: Tata, ¿atu cuñun vatyi zavaha yo cuhva i zavaha ra Elías ta sa naha? Cuu caca yo sii ra Ndyoo nazaquisi ra ñúhu zɨquɨ ñiyɨvɨ Samaria, ta cua cayu tandɨhɨ ñu. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Zoco xaan xaan i cahan ra Jesús sihin ra ta catyi ra: Taxi ñi ndo. Ña cutuñi iñi ndo ñaa tyiño vasi. ");
INSERT INTO mihNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ra i quisi ndya gloria cui, ta ña vasi zanei sii ñiyɨvɨ, vasi zacaqui sii ñu. Catyi ra. Ta zɨquɨ cuahan coyo ra inga ñuu. ");
INSERT INTO mihNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ta cuhva sa cuahan ra ityi, i catyi minoo ra sihin ra Jesús: Tata, cuñi cundyique suun vazu ndya ndya maa cuohon. ");
INSERT INTO mihNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ta i catyi ra Jesús sihin ra: ¿Atu ndison? vatyi yuhvi, ñahñi sa iyo sii. Iyo vehe ñicuii, ta iyo taca zaa. Zoco ra i quisi ndya gloria ñahñi vehe ra iyo. ");
INSERT INTO mihNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tacuan ta i catyi ra Jesús sihin inga ra: Cundyicon sii. Zoco i catyi ra cuan: Tata, cuatu ndya nacuu zuti, ta zɨquɨ cua cundyique suun. ");
INSERT INTO mihNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ta i catyi ra Jesús sihin ra: Ña vaha sa ñoho xaan iñun tuhun ñiyɨvɨ suun. Natyihi ñiyɨvɨ ña sito sii ra Ndyoo sii tahan sihi sihin ñu sisi ñuhu, zoco yoho cuahan ta nacatyun sihin ñiyɨvɨ cuhva ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tacuan ta zɨquɨ i catyi inga ra sihin ra Jesús: Tata, cua cundyique suun, zoco cuhvon sa cunuhu xihne cua naquehin sihin ñiyɨvɨ sii. ");
INSERT INTO mihNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Zoco i catyi ra Jesús sihin ra: Yoo ra quisaha zatyiño ra tyiñe ta ndu‑uu iñi ra, ma cuu quɨhvɨ ra nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Sa yaha cuan ta zɨquɨ i casi ra Jesús uñi xico usi tahan ca ra. Ta i tasi ra sii ra ityi nuu ra. Uu uu ra cuahan tandɨhɨ ñuu ta tandɨhɨ ityi nu cua cuhun ra Jesús cuee ca. ");
INSERT INTO mihNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ta i catyi ra sihin ra: Tañi minoo itu cahnu xaan, tacuan iyo tyiño zavehi. Zoco ña cuaha muzu iyo. Yucuan cuenda caca ndo sii ra Ndyoo natasi ca ra muzu vatyi cua tyindyee ra sihin tyiño, ta cua nacatyi tucu ra Tuhun Ndyoo sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Cuahan ndo ta ma naa iñi ndo vatyi tañi mvee ticatyi lee cuu ndo, ta tasi sii ndo nu yucu xaan ina nduvahu. ");
INSERT INTO mihNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ta ma cuizo ndo xuhun nu sa quɨhɨ xuhun ndo a inga ndisa ndo. Zanumi ndo, ta ma cucuee xaan ndo ityi sa natuhun ndo sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ta yoo sii vehe saa ndo, sa xihna ñi catyi ndo: “Nacoo sa taxi sa saha ra Ndyoo sii ndo.” Catyi ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ta tatu ndisa vatyi iyo ñiyɨvɨ vaha vehe cuan, cua ndoo sa vaha sihin ñu. Zoco tatu yoñi ñu vaha añima, ma ndoo sa vaha sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ta minoo ñi vehe nu cua saa ndo, yucuan ndoo ndo. Casi ndo ta coho ndo ñaa sa saha maa ñu sii ndo. Vatyi minoo ra zatyiño, iyo cuhva sii ra sa ñihi ra sa casi ra. Ta ma quita ndo vehe nu ndyaa ndo ta cundyaa ndo zɨɨn zɨɨn vehe. ");
INSERT INTO mihNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ta ñaa ñi maa ñuu saa ndo, tatu vaha cahan ñu sihin ndo, casi ndo ñaa sa cua cuhva ñu sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Zanduvaha ndo sii ñiyɨvɨ cuhu ñuu cuan, ta catyi ndo sihin ñiyɨvɨ: “Sa cuñi saa cuhva cundyaca ñaha ra Ndyoo.” ");
INSERT INTO mihNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Zoco tatu quɨhvɨ ndo minoo ñuu ta ña tɨɨn cuenda ñu sii ndo, quita ndo ityi cahnu ta catyi ndo sihin ñu: ");
INSERT INTO mihNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ndya cuhva ndya ñiyaca ñuu ndo sa iñi saha ndi ta cua tava ndi sii si. Minoo zeña cuu si vatyi cua ndoo cuatyi ndo zɨquɨ ndo. Zoco coto ndo vatyi sa cuñi quisi quɨvɨ cundyaca ñaha ra Ndyoo.” Tacuan catyi ndo sihin ñu. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ta catyi tucu ra Jesús sihin ra: Ta catyi ndo vatyi quɨvɨ cua tasi tuñi ra Ndyoo sii ñiyɨvɨ, ñihi ca cua tasi tuñi ra sii ñiyɨvɨ ñuu ña tɨɨn cuenda sii ndo ta zɨquɨ ca ñiyɨvɨ ñuu Sodoma. ");
INSERT INTO mihNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Tacuan ta i catyi ra Jesús: Ndahvi ndoho ñiyɨvɨ ñuu Corazín. Ta ndahvi ndoho ñiyɨvɨ ñuu Betsaida vatyi ña zama ndo cuhva iyo ndo vazu ndyehe ndo sa ndyityi nahnu. I zanaa ra Ndyoo sii ñiyɨvɨ ñuu Tiro ta ñuu Sidón ta sa naha sa cuenda cuatyi ñu. Zoco tatu sa i ndyehe maa ñu sa ndyityi nahnu tañi sa ndyehe maa ndo, cua zandoo ndisa cuii ñu cuatyi ñu, ta cua zama ñu cuhva iyo ñu, ta cacu ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yucuan cuenda, ndoho ñiyɨvɨ ñuu Corazín ta ñiyɨvɨ ñuu Betsaida, ñihi ca cua tasi tuñi ra Ndyoo sii ndo ta zɨquɨ sii ñiyɨvɨ ñuu Tiro ta ñuu Sidón cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ta ndoho ñiyɨvɨ ñuu Capernaum, sica iñi maa ndo vatyi cua ndaa ndo ndya andɨvɨ, zoco cua noo ndo ndya andyaya vatyi ña tyaa ndo yahvi sii Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ta i catyi ra Jesús sihin sa uñi xico usi tahan ra cuan: Ñiyɨvɨ tyizoho sa cahan maa ndo, tañi tyizoho tucu ñu sa cahan mi cuu si. Ta ñiyɨvɨ ña tyaa yahvi sii maa ndo, ña tyaa tucu ñu yahvi sii mi. Ta tatu ña tyaa ñu yahvi sii mi, ña tyaa ñu yahvi sii ra i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tacuan ta cuee ca i nasaa coyo sa uñi xico usi tahan ra cuan, ta zɨɨ xaan cuñi ra, ta catyi ra sihin ra Jesús: Tata, ndya cuhva ndya tatyi cuihna ta tyaa si yahvi sa cahan ndi tatu cahan ndi zɨvun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tacuan ta i catyi ra Jesús sihin ra: I ndyehi cuhva i canacava cuihna cu nuu sa nañi Satanás ndya andɨvɨ. Tañi caa minoo tasa zavi; tacuan caa cuhva canacava ra. ");
INSERT INTO mihNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ta sehi tundyee iñi sii maa ndo, ta cuu zahacanaa ndo zɨquɨ tandɨhɨ cuhva sa iyo sii cuihna. Ta cuu cuañi ndo zɨquɨ coo ta zɨquɨ tizuhma, ta ñahñi maa sa cuu zañicuehe sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Zoco ma zɨɨ xaan cuñi ndo vatyi cuu tava ndo tatyi cuihna cuan. Zɨɨ ca cuñi ndo vatyi sa ndyaa zɨvɨ ndo nu libro ra Ndyoo andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Cuhva cuan ta zɨɨ xaan i cuñi ra Jesús zacuu Tatyi Ii, ta i catyi ra: Zacahnu xein suun Ndyoo Zuti. Yoho ndyaca ñohon andɨvɨ ta ñuu ñiyɨvɨ. Tyixehun sa siñi tuñi suun sii ñiyɨvɨ sica iñi vatyi sito xaan ñu, ta zañohon sii si sii ñu cuu tañi sa ndyihi ñuu ñiyɨvɨ ya. Tacuan zavohon vatyi tacuan cuñi moo. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ta i catyi ra Jesús sihin tandɨhɨ ra zatyiño tyiño ra: Saha maa ra Ndyoo Zuti tandɨhɨ sa iyo sii ra sii mi. Ta yoñi sa sito sii. Maa ñi ra Ndyoo Zuti cuu ra sito sii. Ta maa ñi mi sito sii ra Ndyoo Zuti. Yoñi inga ra sito sii ra sa ndisa cuii. Ta zañehi sii yoo ra cuñi, cuhva iyo Zuti sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ta zɨquɨ i nandyehe ra Jesús sii ra i casi ra, ta i catyi ra ɨɨn ñi sihin maa ra: Zɨɨ xaan cuu sii maa ndo vatyi ndyehe ndo tandɨhɨ sa ndyehe ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Vatyi catyi sihin ndo vatyi cuaha xaan rey ta ra profeta ta sa naha, i cuñi xaan ra ndyehe ra sa ndyehe maa ndo vityi, zoco ñá ndyehe ra sii si. Ta i cuñi xaan ra cuɨñɨ ra sa siñi maa ndo, ta ñá siñi ra sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tacuan ta i cahan minoo ra maestro cuenda ley hebreo. I cuñi ra nducu coto ihñi ra sii ra Jesús, ta i ndaca tuhun ra sii ra: Maestro, ¿yozo caa zavehi ta ñihi tahvi añime? ");
INSERT INTO mihNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ta i catyi ra Jesús sihin ra: ¿Ñaa sa catyi ley? ¿Ñaa sa cahvun yucuan? ");
INSERT INTO mihNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ta i nacahan ra cuan, ta catyi ra: Catyi si vatyi cuñi xaan yo sii ra Ndyoo sihin tandɨhɨ cuii añima yo, sihin sa nɨɨ iñi yo, sihin tandɨhɨ tundyee iñi sii yo, ta sihin tandɨhɨ sa siñi tuñi sii yo. Ta catyi tucu ley vatyi cuñi si sa cuñi xaan yo sii inga tahan yo tañi cuñi yo sii maa yo. Tacuan catyi si. Catyi ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ta i catyi ra Jesús sihin ra: Ndisa sa cohon. Tacuan zavohon, ta cua ñihi tahvi añimon. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Zoco ra maestro cuenda ley hebreo cuan, i cuñi ra zañaha ra vatyi vaha cuhva i ndaca tuhun ra. Yucuan cuenda i catyi tucu ra: Zoco ¿yoo ra cuu tehin? ");
INSERT INTO mihNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ta i nacahan ra Jesús ta catyi ra: I quita minoo ra ñuu Jerusalén ta cuahan ra ndya ñuu Jericó. Ta i tahan ra sii ra zuhu. Ta i zuhu ra tandɨhɨ cuii sa ndyizo ra ndya cuhva ndya zahma ra, ta i cañi xaan ra sii ra ndya cuhva sa yatyi cahñi ra sii ra. Ta zɨquɨ i zandoo ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tacuan ta i yaha minoo ra cu zutu ityi cuan. Ndyehe ra sii ra catuu ra yucuan, ta i yaha ra ndya zava. ");
INSERT INTO mihNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ta zɨquɨ i yaha tucu inga ra cuenda vehe ñuhu. Minoo ra tyindyee sii ra cu zutu cuu ra. Zoco i saa ra, ta i ndyehe ra sii ra catuu ra yucuan, ta zɨquɨ i yaha ra ndya zava. ");
INSERT INTO mihNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tacuan ta i yaha minoo ra samaritano sihin burro zono ra ityi cuan. Ta i ndyehe ra sii ra, ta i cundahvi xaan iñi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ta i noo ra burro zono ra, ta i zavaha ra tata sii ra. I tyihi ra azetye ta vino nu cahvi ra, ta i nazucu ra zahma sii ra, ta i tyizo ra sii ra sata burro zono ra. Ta i quihin ra sii ra ta i sinducu ra minoo nu cua cundyaa ra ta zacuu ca ra tata sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ta inga quɨvɨ i cuñi ra samaritano cuan cuhun ra, ta i tava ra xuhun ta saha ra sii ra xu vehe. Ta i catyi ra sihin ra: “Zacuendon sii ra ya. Ta ñaa ca sa cua zanaa ndo sihin ra, yuhvi cua nacuhve sii ndo naquisi inga saha.” Tacuan i catyi ra ta cuahan ra. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tacuan ta zɨquɨ i ndaca tuhun ra Jesús sii ra maestro cuenda ley cuan ta catyi ra: Sisi sa uñi tahan ra cuan, ¿yoo ra cuu ra tahan ra ndahvi cuan? ");
INSERT INTO mihNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ta i catyi ra maestro cuan: Ra sa cundahvi iñi sii ra. Ta i catyi ra Jesús sihin ra: Cuahan, ta zuun ñi cuhva cuan zavaha tucu moo. ");
INSERT INTO mihNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ta cuahan ra Jesús minoo ityi, ta saa ra minoo ñuu. Ta yucuan ndyaa minoo ñaha sa nañi Marta. Ta i tɨɨn cuenda ña sii ra vehe ña. ");
INSERT INTO mihNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ta iyo minoo cuhu ña Marta. Nañi ña María. Ta i sicundyaa ña saha ra Jesús ta tyizoho ña sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Zoco cuaha xaan tyiño i zavaha ña Marta sa zavaha ña sa casi ra, ta i quisi ña nu ndyaa ra Jesús ta catyi ña sihin ra: Tata ¿atu ña sica iñi oo sa zandoo cuhi sii, ta zatyiñe maa tuhun ñi? Catyun sihin ña natyindyee ña sii. ");
INSERT INTO mihNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Zoco i catyi ra Jesús sihin ña: Marta, Marta, sica xaan iñun cuaha xaan cuhva. ");
INSERT INTO mihNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Zoco iyo minoo ñi sa ñiñi xaan, ta sa i cutuñi vaha iñi ña María cuhva vaha cuan. Ta yoñi cua cuu quindyaa cuhva cuan sii ña. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ta minoo saha sa sica tahvi ra Jesús sii ra Ndyoo ta sa ndɨhɨ sica tahvi ra, ta i catyi minoo ra i casi ra sihin ra: Tata, zañohon sii ndi yozo caa caca tahvi ndi sii ra Ndyoo tañi i zañaha ra Juan sii ra i sica noo sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tacuan ta i catyi ra Jesús sihin ra: Cuhva sa cua cahan ndo sihin ra Ndyoo tyehen catyi ndo: “Ndyoo Zutu ndi ra ndyaa andɨvɨ, ii xaan cuu zɨvɨ moo. Nasaa quɨvɨ cua cundyaca ñohon ihya ñuu ñiyɨvɨ. Nazavaha ñiyɨvɨ cuhva cuñi moo ihya ñuu ñiyɨvɨ tañi cuu si ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cuhvon sa siñi ñuhu sii ndi minoo minoo quɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ta zohon tucahnu iñi sii ndi sa cuenda cuatyi ndi tañi maa ndi zaha ndi tucahnu iñi sii ñiyɨvɨ zavaha sa ña vaha sihin ndi. Ma cuhvon sa nducu coto ihñi cuihna sii ndi coto zavaha ndi sa ña vaha.” Tacuan i zacuaha ra Jesús sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ta zɨquɨ i catyi tucu ra: Tatu maañuu cua soon vehe amigun ta catyun sihin ra: “Xaa, cuhva noo uñi tahan pan sii. ");
INSERT INTO mihNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Vatyi nacaa saa ra tehin. Sica xaan i quisi ra, ta ñahñi maa sa cuhve casi ra.” ");
INSERT INTO mihNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ta ndya sisi vehe cua cahan amigun, ta cua catyi ra: “Ma zayangon sii. Sa ndazi cutu yuvehi. Ta quixi sa ndyihi zehi. Ta coto ndoyo si, ma cuu nduvite ta cuhve suun vityi.” Tacuan cua catyi ra suhun. ");
INSERT INTO mihNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ta catyi suhun vatyi vazu amigun sii ra cuan, zoco ma nduvita ra ta cuhva ra sa yatyi. Zoco tatu ndoon yucuan ta ndita ñi cacon sii ra, tacuan ta cua nduvita ra ta cuhva ra yozo tahan si cuñun. ");
INSERT INTO mihNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ta tacuan tucu maa ndo. Caca ndo sii ra Ndyoo, ta cua cuhva ra sa sica ndo. Nanducu ndo, ta cua nañihi ndo. Cati ndo yuvehe, ta cua nuña si. ");
INSERT INTO mihNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Vatyi tandɨhɨ ndoho ra sica, cua ñihi ndo. Ta tatu nanducu ndo, cua nañihi ndo. Ta tatu cati ndo yuvehe, cua nuña si. ");
INSERT INTO mihNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ndoho, ra cuu zutu sa ndyihi, tatu cua caca zehun minoo pan ¿atu cua cuhva ndo minoo yuu sii ra? Ña tacuan. A tatu caca ra minoo tyiyaca ¿atu cua cuhva ndo minoo coo? ");
INSERT INTO mihNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","A tatu cua caca ra minoo ndɨvɨ ¿atu cua cuhva ndo minoo tizuhma? Ña tacuan. ");
INSERT INTO mihNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ñiyɨvɨ quiñi xaan cuu maa ndo, zoco sito ndo yozo caa cuhva ndo sa vaha sii zehe ndo; vaha xaan ca cua zavaha ra Ndyoo, ta cua cuhva ra Tatyi Ii sii ñiyɨvɨ sica sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tava ra Jesús minoo tatyi cuihna sii minoo ra ñehe. Ta cuhva sa quita tatyi cuihna cuan ta i cuu nacahan ra ñehe. Ta iyo xaan i cuñi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Zoco zuhva ñu i catyi ñu: Tava ra ya tatyi cuihna sihin tundyee iñi ra Beelzebú, ra cu nuu sii cuihna. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ta inga ñu nducu coto ihñi ñu sii ra Jesús, ta i sica ñu sa zañaha ra minoo zeña ityi andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Zoco i sito ra Jesús cuhva sica iñi ñu, ta i catyi ra sihin ñu: Tatu sahñi tahan xaan ñiyɨvɨ minoo ñuu, ndaha cua tɨvɨ ta naa ñuu cuan. Ta tacuan tucu minoo vehe ñiyɨvɨ, tatu sahñi tahan ñu sihin tahan ñu, yatyi xaan cua ndɨhɨ cuhva vaha nu yucu ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ta ma cahñi tahan ra cu nuu sii cuihna sihin inga cuihna vatyi tatu tacuan zavaha si, yatyi xaan cua ndɨhɨ cuhva iyo sii si. Ma tava cuihna sii cuihna. Ta catyi ndo vatyi yuhvi tave sii cuihna sihin tundyee iñi sii ra cu nuu sii cuihna. ");
INSERT INTO mihNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Zoco tatu yuhvi tave sii cuihna sihin tundyee iñi ra Beelzebú, tacuan tucu zavaha ra ndyico sii maa ndo. Zoco maa ra cuan cua nacatyi sihin ndo vatyi ma tava minoo cuihna sii inga cuihna. ");
INSERT INTO mihNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ta yuhvi tave sii cuihna sihin tundyee iñi maa ra Ndyoo. Ta cuñi si catyi si vatyi ndisa cuii sa saa cuhva ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tatu minoo ra ñihi xaan zacuenda ra vehe ra sihin mityi ra, yoñi cuu quihin ndaha tyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Zoco tatu quisi inga ra ñihi ca ta zɨquɨ ra cuan ta quindyaa ra mityi ra, ma cuu ca zacacu ra sii ra. Ta cuu quihin inga ra ndaha tyiño ra ta zasa ra sii ra tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tatu ña zatyiño ñiyɨvɨ sihin, zatɨvɨ ñu tyiñe. Ta tatu ma tyindyee ñu sii, sa nacatyi Tuhun Ndyoo sihin ñiyɨvɨ, cuñi si catyi si vatyi ña saha ñu sa coto ñiyɨvɨ tuhin. ");
INSERT INTO mihNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tatu quita minoo tatyi ña vaha sii minoo ra, sica noo tatyi cuihna cuan nu ityi xaan, ta nanducu si nu cua quitatu si. Zoco ña nañihi si nu quitatu si, ta catyi si: “Cunuhu tuqui ndya vehi nu i quite”, catyi si. ");
INSERT INTO mihNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tacuan ta nasaa si añima ra cuan nu i quita si. Ta ndyehe si vatyi ndɨɨ xaan; yoñi ndyaa yucuan. ");
INSERT INTO mihNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ta zɨquɨ cuahan si, ta quihin si usa tahan ca tatyi cuihna xaan ca ta zɨquɨ maa si. Ta ndɨhvɨ tandɨhɨ tatyi cuihna cuan añima ra cuan, ta ndoo si. Ta yaha ca cuhva cua nanduu ra cuan ta zɨquɨ sa xihna ñi. ");
INSERT INTO mihNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ta nɨɨ ñi sa cahan ra Jesús cuhva cuan, ta i cana saa minoo ñaha sa ñoho tɨcuɨ ñiyɨvɨ, ta catyi ña: Zɨɨ xaan cuu sii ñaha i zacacu suun, ñaha i zacaxi suun. ");
INSERT INTO mihNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Zoco i catyi ra Jesús sihin ña: Ndison sa cohon, zoco zɨɨ xaan ca cua cuu sii ñu siñi Tuhun Ndyoo ta zavaha ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","I siconduu cuii ñiyɨvɨ nu ndyaa ra Jesús, ta i catyi ra sihin ñu: Quiñi xaan iyo ñiyɨvɨ iyo vityi. Cuñi xaan ñu ndyehe ñu minoo zeña, zoco ñahñi inga ca zeña cua ndyehe ñu ta zɨquɨ sa i cuu sa cuenda ra Jonás. ");
INSERT INTO mihNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ra Jonás i cuu ra minoo zeña sii ñiyɨvɨ ñuu Nínive, ta tacuan tucu cua cuu ra i quisi ndya gloria sihin ñiyɨvɨ sa iyo vityi. ");
INSERT INTO mihNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Quɨvɨ cua tyicuhva ra Ndyoo sii ñiyɨvɨ, cua nandoto minoo ñaha sa sindyaca ñaha sii ñiyɨvɨ ndya siyo tyañuhu ta sa naha. Ta maa ña cua tyaa cuatyi sata maa ndo vatyi sa ndisa iyo cuatyi ndo, vatyi ña tyizoho ndo sa cahan Zehe ra Ndyoo. Ta maa ña, sica xaan i sahan ña i sityizoho ña sa siñi tuñi sa saha ra Ndyoo sii ra rey Salomón. Ta vityi ndyaa inga ra cahnu ca ta zɨquɨ ra Salomón sihin ndo, ta ña tyizoho ndo sa quehin. ");
INSERT INTO mihNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ta tacuan tucu ñiyɨvɨ ñuu Nínive, cua tyaa ñu cuatyi sata ndo quɨvɨ cua zandaa ra Ndyoo tyiño cuenda ñiyɨvɨ vatyi i tyizoho ñu sa cahan ra Jonás, ta i ndu‑uu iñi ñu cuatyi ñu. Ta cahnu ca mi ta zɨquɨ ra Jonás, ta ña cuñi ndo tyizoho ndo sa quehin. ");
INSERT INTO mihNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yoñi yo cua tyaa yo minoo tyuma ta tyihi yo sii si minoo nu xehe a sisi minoo caja vatyi ñúhu cuan tahan si cozo si minoo nu zucu vatyi tacuan ta ndisi ndyehe ñiyɨvɨ quɨhvɨ sisi vehe. ");
INSERT INTO mihNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sɨtɨ nuu yo cuu tañi minoo sa zandisi sii yo ta cuu ndyehe yo nu cuahan yo. Tatu vaha sɨtɨ nuu yo, ndisi ndyehe yo nu cuahan yo. Ta tacuan tucu añima yo, tatu iyo sa ndisi sa saha ra Ndyoo añima yo, vaha ñiyɨvɨ cuu yo. Tatu ñahñi sa ndisi sa saha ra Ndyoo iyo añima minoo ñiyɨvɨ, yɨvɨ ñiyɨvɨ vaha cuu ñu. Tañi minoo ra cuaa cuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yucuan cuenda zaha ndo cuenda sii ndo tatu ndyaa sa ndisi ra Ndyoo sihin ndo a sa ñaa. ");
INSERT INTO mihNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tatu situ cuii sa ndisi ra Ndyoo añima ndo, nu siin ta ma cuu zavaha ndo sa ña vaha. Ñahñi ca sa quiñi ta sa ña vaha iyo sii ndo. Tatu sino iñi ndo, cuu si tañi minoo ñúhu cahnu zandisi sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cuhva sa ndɨhɨ cahan ra Jesús ta i cana minoo ra fariseo sii ra vatyi cua casi ra xita vehe ra. Ta cuahan ra Jesús vehe ra. Ta i sicundyaa ra mesa. ");
INSERT INTO mihNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ta i ndyehe ra fariseo cuhva zavaha ra. Ta iyo xaan i cuñi ra vatyi ña zavaha ra Jesús costumbre sa nacatya xaan ra ndaha ra tañi tuhva maa ñu zavaha cuee ca sa casi ñu xita. ");
INSERT INTO mihNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ta i catyi ra Jesús sihin ra: Ndoho ra fariseo nacatya xaan ndo sata vaso ta sata coho, zoco sisi añima maa ndo yaha xaan quiñi iyo ndo ta zuhu xaan ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tondo xaan iyo maa ndo. I zavaha ra Ndyoo sata vaso ta coño ñuhu maa ndo, zoco ¿atu sica iñi ndo vatyi ña zavaha tucu ra añima ndo? ");
INSERT INTO mihNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Cuñi si sa cuhva ndo xuhun sii ñiyɨvɨ ndahvi ta zavaha ndo sa vaha sihin ñu. Tacuan ta cua ndundɨɨ tucu añima ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ndahvi ndoho ra fariseo vatyi saha ndo diezmo sii ra Ndyoo tandɨhɨ yucu sa tasi ndo tañi menta ta ruda ta inga sa sasi ndo, zoco ña zavaha ndo sa ñiñi ca vatyi ña zavaha ndo sa ndoo sihin ñiyɨvɨ, ta ña cuñi ndo sii ra Ndyoo sa ndisa cuii. Ta yucuan cuu sa ñiñi ca, ta ma naa iñi ndo sa cuhva ndo diezmo, ndɨhɨ ca. ");
INSERT INTO mihNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ndahvi ndoho ra fariseo vatyi cuñi ndo cundyaa ndo tyayu vaha vehe ñuhu. Ta cuñi ndo sa zacahnu ñiyɨvɨ sii ndo nuyahvi. ");
INSERT INTO mihNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ndahvi ndoho ra maestro cuenda ley ta ndoho ra fariseo vatyi zaha ndo tuhun vatyi vaha xaan ndo ta ña ndisa. Cuu ndo tañi ndɨyɨ sa ñoho sisi ñaña, ta yaha ñiyɨvɨ zɨquɨ si, zoco ña sito ñu ñaa sa ñoho. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tacuan ta i nacahan minoo ra maestro cuenda ley sihin ra, ta catyi ra: Maestro, tatu cohon cuhva cuan, tyaa tucun cuatyi sata maa ndi. ");
INSERT INTO mihNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ta i catyi tucu ra Jesús sihin ra: Ndahvi tucu ndoho ra maestro cuenda ley vehe ñuhu vatyi zanducuaha ca ndo ley i tasi ra Ndyoo ta sa naha, ta ña tahan si zavaha ndo tacuan. Yoñi sa cuu zavaha tandɨhɨ si. Ta nu maa ndo ta ña zavaha ndo tandɨhɨ si vatyi sa sito ndo vatyi ma cuu. ");
INSERT INTO mihNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ndahvi ndoho vatyi zandutyaqui xaan ndo ñaña cuenda ra i cuu profeta ta sa naha, ta zuun ñi ñiyɨvɨ sahnu sii ndo ta sa naha i sahñi ñu sii ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sihin cuhva zavaha ndo zañaha ndo vatyi ndoo ndo vaha cuhva i zavaha ñiyɨvɨ sahnu sii ndo ta sa naha vatyi maa ra i sahñi sii ra profeta, ta maa ndo zandutyaqui xaan ndo ñaña ra profeta cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yucuan cuenda i catyi ra Ndyoo ta sa naha: Cua tasi sii ra cua cahan tuhun sa cua cuhve sii ra, ta cua tasi sii ra cua tave tyiño sa zatyiño ra tyiñe. Ta cua cahñi ñiyɨvɨ sii zuhva ra, ta sii inga ra cua zayanga xaan ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ta ndisa vatyi tacuan zavaha ndo. Ta cua tasi tuñi ra Ndyoo sii maa ndo sa cuenda tandɨhɨ ra profeta i sahñi ñiyɨvɨ ta sa naha ta ndya cuhva ndya vityi. ");
INSERT INTO mihNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ndya cuhva ndya ñɨñɨ ra Abel, ra i sahñi ra Caín yañi ra, ta ndya cuhva ndya nɨñɨ ra Zacarías, ra i sahñi ñiyɨvɨ sisi vehe ñuhu, ta catyi sihin ndo sa ndisa cuii vatyi cua tasi tuñi ra Ndyoo sii ñiyɨvɨ iyo vityi sa cuenda tandɨhɨ si cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ndahvi ndoho ra maestro cuenda ley vehe ñuhu vatyi i tyixehe ndo ndaha tɨcuɨ cuenda yuvehe nu quɨhvɨ ñiyɨvɨ ityi ra Ndyoo. Ñá quɨhvɨ maa ndo ityi cuan, ta inga ñiyɨvɨ sa cuñi quɨhvɨ, ña saha ndo sa quɨhvɨ ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sa ndɨhɨ cahan ra Jesús tuhun cuan, ta ra maestro cuenda ley ta ra fariseo i cuxaan xaan ra sihin ra, ta i quisaha nducu tuhun xaan ra sii ra cuaha xaan cuhva ");
INSERT INTO mihNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","vatyi nducu ra cuhva sa cahan ra Jesús minoo cuhva ña vaha. Ta zɨquɨ cua tyaa ra cuatyi sata ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Cuenda mil ñiyɨvɨ i titahan ndya cuhva catyihi tahan ñu vatyi cuaha xaan ñu. Ta sa xihna ñi i catyi ra Jesús sihin ra i casi ra: Zacuenda vaha ndo sii ndo sihin cuhva iyo ra fariseo vatyi ra zandavi ñaha cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Vatyi tandɨhɨ sa ña vaha sa zavaha ñiyɨvɨ ta tyixehe ñu sii si, cuee ca ta cua quita si nu ndisi, ta cua coto inga ñiyɨvɨ sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yucuan cuenda ñaa ndɨhɨ ca sa cahan xehe ndo sisi vehe ndo, cua coo quɨvɨ cua cuɨñɨ tandɨhɨ ñiyɨvɨ sii si. Ta vazu xehe xaan cahan ndo minoo tuhun, zoco cua coto tandɨhɨ cuii ñiyɨvɨ sii si cuee ca. ");
INSERT INTO mihNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ta catyi sihin ndoho ra cuu amigi vatyi ma yuhu ndo sii ra cuu cahñi sii coño ñuhu ñi ndo vatyi yaha cuan ta ñahñi ca sa cuu zacuu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Zoco cua catyi sihin ndo yoo sii tahan si cuyuhu ndo. Cuyuhu ndo sii ra sa cuu cahñi sii ndo sa ndisa cuii ta zacuhun ra sii ndo andyaya. ");
INSERT INTO mihNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ña yahvi ndyaa zaa. Cuu zata yo ohon tahan tɨ sa uu peso. Ta ña naa iñi ra Ndyoo sii numinoo tɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ta sito ra Ndyoo yozo tahan ixi xiñi ndo iyo. Yucuan cuenda ma yuhu ndo sii ra cahñi sii ndo vatyi yahvi xaan ca ndyaa maa ndo ta zɨquɨ ca cuaha xaan zaa. ");
INSERT INTO mihNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ta catyi sihin ndo vatyi tandɨhɨ ndo sa nacatyi ndo sihin ñiyɨvɨ vatyi sito ndo sii, yuhvi cua catyi sihin ángel ra Ndyoo ndya gloria vatyi site sii ndo. Ta ra i quisi ndya gloria cui. ");
INSERT INTO mihNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Zoco yoo ra catyi vatyi ña sito ra sii, yuhvi cua catyi ityi nuu ángel vatyi ña site sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ra i quisi ndya gloria cui, ta vazu cahan ñiyɨvɨ ndya vaha ñi sii, zoco cua zaha ra Ndyoo tucahnu iñi sii ñu. Zoco tatu cahan ñiyɨvɨ ndya vaha ñi sii Tatyi Ii ra Ndyoo, ma zaha ca ra Ndyoo tucahnu iñi sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ta cuhva cundyaca ñiyɨvɨ sii ndo sisi vehe ñuhu a nuu ra cu juez a ra cu tyiño, ma caca xaan iñi ndo ñaa sa cua cahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Vatyi zuun ñi caa cuhva cuan cua cuhva Tatyi Ii tuhun cua cahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Cuaha xaan ñiyɨvɨ i siyucu sihin ra Jesús, ta minoo ra ndɨhɨ sihin ñu i catyi ra sihin ra Jesús: Maestro, catyun sihin yañi vatyi natahvi zava ra ndaha tyiño sa zandoo zutu ndi sii ndi. ");
INSERT INTO mihNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tacuan ta i catyi ra Jesús sihin ra: Xaa, ¿yoo ra saha tyiño sii sa cui juez a cui minoo ra sa tahvi zava ndaha tyiño? ");
INSERT INTO mihNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ta i catyi ra Jesús sihin tandɨhɨ ñiyɨvɨ: Zaha vaha ndo cuenda ta ma ndyiyo iñi ndo ndaha tyiño vatyi ña siñi ñuhu sa coo cuaha xaan ndaha tyiño yo ta coo vaha yo. ");
INSERT INTO mihNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ta i cahan ra Jesús zɨquɨ minoo cuhva sihin ñiyɨvɨ, ta i catyi ra: Sicoo minoo ra cuca xaan, ta vaha xaan i cuu ndaha tyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ta i sica iñi ra sihin añima ra, ta i catyi ra: “¿Yozo caa cua zavehi? Ñahñi nu quɨhɨ tandɨhɨ ndaha tyiñe. ");
INSERT INTO mihNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Zoco tyehen cua zavehi. Cua cani yaca ndyihi, ta cua zavaha que sa nahnu ca. Ta yucuan cua quɨhɨ tandɨhɨ nɨñi. ");
INSERT INTO mihNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tacuan ta ma zatyiño que cuaha xaan cuiya. Cua quitati, ta zɨɨ xaan cua cuñi. Cua casi vehi ta coho vehi.” Tacuan i sica iñi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Zoco i catyi ra Ndyoo sihin ra: “Tondo xaan sica iñun vatyi vityi sa cuaa cua cuun. Ta ndaha tyiño sa sicumi vaha xoon, cua ndoo si sihin inga ñiyɨvɨ.” ");
INSERT INTO mihNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ta tacuan iyo ñiyɨvɨ sa zacaya xaan ndaha tyiño sa cuenda ñi maa ñu, ta ñahñi maa sa iyo sii ñu nu ndyaa ra Ndyoo. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ta i catyi ra Jesús sihin ra i casi ra: Catyi sihin ndo vatyi ma caca xaan iñi ndo yozo caa cua ñihi ndo sa casi ndo ñuu ñiyɨvɨ ya. Ta ma caca xaan iñi ndo yozo caa cua ñihi ndo zahma quɨhɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Vatyi iyo inga sa siñi ñuhu ca sii yo ta zɨquɨ sa casi yo ta sa quɨhɨ yo. ");
INSERT INTO mihNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ndyehe ndo cuhva iyo zaa. Ña tasi tɨ, ta ña naquihin tɨ tyiño zacuu tɨ, ta ña tyihi vaha tɨ ndaha tyiño tɨ. Zoco sasi tɨ vatyi maa ra Ndyoo saha sa casi tɨ. Ta ñiñi xaan ca cuu maa ndo ityi nuu ra Ndyoo ta zɨquɨ zaa cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Ta yoo ndo cuu nduzucu ca ndo siin ca tatu caca xaan iñi ndo sa cuenda si? Ma cuu ca. ");
INSERT INTO mihNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ta tatu ma cuu zavaha ndo numinoo cuhva luhlu cuan, ¿ñaa cuenda sica xaan iñi ndo sa cuenda tandɨhɨ inga cuhva? ");
INSERT INTO mihNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Zaha ndo cuenda cuhva iyo ita vatyi ña tavi si ta ña cono si iza, zoco catyi sihin ndo vatyi vazu cuca xaan i cuu ra Salomón ta tyaqui xaan zahma ra, zoco ña tyaqui ca si ta zɨquɨ minoo ita cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ta tatu zandutyaqui xaan ra Ndyoo sii tu‑ita sa iyo vityi ta ityaan cua nduu tu nducu ta cayu tu, tyaqui xaan tucu zahma cua cuhva ra sii maa ndo. Zoco maa ndo ña sino vaha iñi ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ma caca xaan iñi ndo ta nanducu ndo sa casi ndo ta sa coho ndo. Ta ma caca xaan iñi ndo tatu cua cuhva ra Ndyoo sii si a ma cuhva ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vatyi sica xaan iñi ñiyɨvɨ ña sito sii ra Ndyoo sa cuenda sa casi ñu. Zoco ma caca xaan iñi maa ndo tuhun cuan vatyi sito Zutu ndo vatyi siñi ñuhu si sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Vaha ca nducu ndo cuhva yozo caa cua cuhva cuenda ndo sii ndo sii ra Ndyoo vatyi cundyaca ñaha ra sii ndo. Ta tacuan ta cua ñihi ñdo tandɨhɨ cuii sa siñi ñuhu sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ma yuhu ndo, mvee ticatyi zone. Vazu ña cuaha ndo zoco zɨɨ xaan cuñi Zutu yo, ta cua cuhva ra quɨhvɨ ndo nu ndyaca ñaha ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xico ndo sa sii ndo ta cuhva ndo sii ñiyɨvɨ ndahvi. Tatu tacuan zavaha ndo, zacaya ndo sa vaha nu ndyaa ra Ndyoo. Ta yucuan ma ndɨhɨ sa vaha cuan vatyi ma cuu quɨhvɨ ra zuhu, ta yoñi tiquixi zatɨvɨ sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nu ndyaa sa cuca ndo, yucuan cuu nu ndyaa añima ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Cundyaa listo ndo, ta cuatu ndo quɨvɨ cua quisi inga saha. ");
INSERT INTO mihNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Cuu ndo tañi minoo muzu sa ndatu listo sii patrón ra ñaa quɨvɨ cua nasaa ra sa cuahan ra minoo vico tindaha. Ta cayu ñúhu sisi vehe vatyi tatu nasaa patrón ta cati ra yuvehe, yatyi xaan cua nuña muzu yuvehe. ");
INSERT INTO mihNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Ta cuhva cuan zɨɨ xaan cua cuñi patrón ndyehe ra sii muzu ra vatyi ndatu listo ra ñaa ñi cuhva cua nasaa ra vazu sa cuaa a vazu ñaa ca. Ta cua tyaa ra sii muzu ra yumesa ta cuhva ra sa casi ra vatyi i ndatu ra sii ra. Ta zɨɨ xaan cua cuñi muzu cuan vatyi tacuan zavaha patrón ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ta coto ndo cuhva ya vatyi tatu cua coto minoo ra xu vehe ñaa cuhva cua quɨhvɨ ra zuhu vehe ra, cua zacuenda xaan ra vehe ra. Ta ma cuzu ra. Ta ma cuhva ra sa nuña ra zuhu vehe ra ta zuhu ra ndaha tyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Zuun ñi cuhva cuan cundyaa listo tucu maa ndo vatyi zana ñi iñi ndo ta cuhva cuan cua nasaa ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tacuan ta i ndaca tuhun ra Pedro sii ra Jesús ta catyi ra: Tata, ¿Yoo sii cuenda cohon tuhun ya? ¿Atu sa cuenda sa maa ñi maa ndi a sa cuenda tandɨhɨ ñiyɨvɨ? ");
INSERT INTO mihNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tacuan ta i nacahan ra Jesús, ta i catyi ra sihin ra: Muzu sa tyizoho sa cahan patrón ra, yucuan cuu muzu vaha vatyi zacuenda ra vehe patrón ra. Ta saha ra sa casi tandɨhɨ inga muzu minoo cuhva vaha. ");
INSERT INTO mihNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ta zɨɨ xaan cua cuñi muzu cuan tatu nasaa patrón ra cuhva sa zatyiño ra ta zavaha ra tandɨhɨ sa catyi patrón ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sa ndisa catyi sihin ndo vatyi cua cuhva patrón ra sa cundyaca ñaha ra tandɨhɨ sa sii ra vatyi tyaa xaan ra yahvi sii patrón ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Zoco tatu sica iñi muzu cuan vatyi naha xaan cuahan patrón ra, ta yucuan cuenda quisaha cañi ra sii inga muzu ta sasi cuahyi ra ta sihi xaan ra ndixi ta siñi ra, ");
INSERT INTO mihNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tacuan ta zana ñi iñi ra ta cua nasaa patrón ra minoo quɨvɨ sa ña ndatu ra sii ra. Ta cua tasi tuñi xaan patrón ra sii ra. Ta cua tahan si sii ra tañi cua tahan si sii ñiyɨvɨ ña sino iñi. ");
INSERT INTO mihNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ta minoo muzu sa sito ñaa sa cuñi patrón ra zavaha ra, zoco ña ndyaa listo ra ta ña zavaha ra cuhva cuñi patrón ra, cuaha xaan tundoho cua zandyehe patrón ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ta tatu ña sito minoo muzu ñaa sa cuñi patrón ra ta ña zavaha ra sii si, tahan si sa ndoho ra. Zoco zuhva ñi cua ndoho ra vatyi ña sito ra. Ta tatu saha ra Ndyoo cuaha ca sa siñi tuñi sii minoo ra, cuaha ca sa vaha cuñi si zavaha ra. Ta tatu cuaha ca tyiño ndyizo minoo ra, cuñi si vatyi ñihi ca zatyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tañi sa zatehin minoo ñúhu ñuu ñiyɨvɨ, yucuan cuu tyiño vasi. Ta ñúhu cuan cua zanduvaha si sii ñu sino iñi sii, ta cua zanaa si sii ñu ña sino iñi. Sa quisaha cayu ñúhu cuan, zoco cumañi zacayu que sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ta cuaha xaan tundoho cua ndyehi ndya cuhva ndya cua ndɨhɨ tyiño zacui. ");
INSERT INTO mihNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sica iñi maa ndo vatyi vasi cuhve sa taxi ñuu ñiyɨvɨ, zoco ña tacuan. Vasi zacuzɨin sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ta ndya vityi ta ityi nuu ca ihya cuu cuhva cua cuu si. Tatu ohon tahan ñiyɨvɨ iyo minoo vehe, uñi tahan ñu cua cahñi tahan sihin uu tahan ñu, ta uu tahan ñu cua cahñi tahan sihin uñi tahan. ");
INSERT INTO mihNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Cua cahñi tahan zutu sa ndyihi sihin zehe ra ta zehe ra sihin zutu ra. Ta zɨhɨ ña cua cahñi tahan sihin zehe ña, ta zehe ña sihin zɨhɨ ña. Ta cua cahñi tahan tyizo ña sihin sono ña ta sono ña sihin tyizo ña. ");
INSERT INTO mihNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tacuan ta i catyi ra Jesús sihin ñiyɨvɨ yucu yucuan: Tatu ndyehe ndo vatyi iñi ñaa vityi, catyi ndo vatyi cua coon zavi. Ta ndisa ndo sa cahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ta tatu ndyehe ndo vatyi vasi tatyi ityi tyañuhu, catyi ndo vatyi sa cua ndu‑cahñi. Ta tacuan cuu si. ");
INSERT INTO mihNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ra tondo xaan cuu maa ndo. Nacoto ndo sa iyo andɨvɨ ta nu ñuhu. ¿Yozo caa vatyi ña nacoto ndo ñaa tyiemvu cuu si vityi? ");
INSERT INTO mihNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Ñaa cuenda ña cutuñi iñi ndo ñaa sa cuu sa ndoo? ");
INSERT INTO mihNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tatu iyo minoo ra cuñi ra cuatyi suhun ta cuhun sihin ra nu ndyaa ra cu tyiño, nducun cuhva nacoo vohon sihin ra cuee ca sa saa ndo nuu ra cu tyiño coto catyi ra cu tyiño vatyi cuhun vehe caa. Ta cua cuhva ra suun sii ra cu policía. Ta cua tyihi ra suun vehe caa. ");
INSERT INTO mihNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tatu tacuan cua cuu si, ma quiton ndya tyiyahvun tandɨhɨ sa tahan si tyiyahvun, (ta tacuan cua zavaha ra Ndyoo suhun andyaya tatu ma nduvohon sihin ra). ");
INSERT INTO mihNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Cuhva cuan yucu zuhva ra nacatyi sihin ra Jesús cuhva i zavaha ra Pilato sihin zuhva ra Galilea. Catyi ra nacatyi sihin ra Jesús vatyi i tava ra Pilato tyiño sa cahñi zandaru sii ra Galilea cuan nɨɨ ñi sa saha ra ofrenda sii ra Ndyoo sisi vehe ñuhu. Ta i nazaca ra nɨñɨ ra cuan sihin nɨñɨ quɨtɨ sa cuu ofrenda ra. ");
INSERT INTO mihNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ta i nacahan ra Jesús, ta catyi ra sihin ra: Sica iñi ndo vatyi cahnu xaan cuatyi ra Galilea cuan. Ta yucuan cuenda ndyehe ra tundoho ta sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Zoco catyi sihin ndo vatyi ña tacuan. Ta tatu ma zama maa ndo cuhva iyo ndo cunaa tucu maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ta sito ndo vatyi i sihi sahun uñi tahan ra quɨvɨ i nduva torre Siloé cuan zɨquɨ ra. ¿Atu sica iñi ndo vatyi cuaha ca cuatyi ra cuan ta zɨquɨ inga ra ñuu Jerusalén? ");
INSERT INTO mihNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ña tacuan. Ta tatu ma zama maa ndo cuhva iyo ndo, cunaa tucu maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tacuan ta i cahan ra Jesús zɨquɨ cuhva ya, ta catyi ra: Sicoo minoo yutu higuera sii minoo ra nu ndyaa yoho uva ra. Ta i sahan ra ta i sinanducu ra yucu vixi nuu tu, ta ñá nañihi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ta i catyi ra sihin ra zanduvii nu ndyaa ndaha tyiño ra: “Ndyehe, sa uñi cuiya quisi nanduqui yucu vixi nuu tu ya, ta ña nañihi. Cahndyon sii tu vatyi nandyaa ñi tu, ta ñahñi maa saha tu.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Zoco i nacahan inga ra, ta catyi ra sihin ra: “Tata, nandoo tu minoo ca cuiya. Cua zanduvite ñuhu saha tu ta tyihi ñuhu tyahyu. ");
INSERT INTO mihNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ta tatu cuhva tu yucu vixi, vaha, ta tatu ma cuhva tu cua cahndye sii tu.” ");
INSERT INTO mihNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Minoo quɨvɨ quitatu ñiyɨvɨ zacuaha ra Jesús sii ñiyɨvɨ sisi vehe ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ta yucuan ndyaa minoo ñaha sa ñoho minoo tatyi ña vaha. Sa sahun uñi cuiya, ña cuu ndundoo ña. ");
INSERT INTO mihNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ta i ndyehe ra Jesús sii ña. Ta i cana ra sii ña ndya nu ndyaa ra, ta i catyi ra sihin ña: Maha, sa nduvohon. ");
INSERT INTO mihNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ta i tyizo ra ndaha ra xiñi ña, ta zuun ñi caa cuhva cuan i ndundoo ña. Ta i zacahnu xaan ña sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Zoco i cuxaan xaan ra cu nuu sii vehe ñuhu cuan vatyi i zanduvaha ra Jesús sii ña quɨvɨ quitatu ñiyɨvɨ. Ta i catyi ra sihin ñiyɨvɨ yucu yucuan: Iyo iñu tahan quɨvɨ tahan si zatyiño yo. Yucuan cuenda quisi ndo quɨvɨ cuan ta nduvaha ndo ta yɨvɨ quɨvɨ sa quitatu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ta i catyi ra Jesús sihin ra: Ra ña vaha cuu ndo. ¿Atu ma ndasi ndo quɨtɨ zono ndo sa cuu zacoho ndo ndutya sii tɨ quɨvɨ quitatu ñiyɨvɨ? ");
INSERT INTO mihNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ta tacuan tucu maha ya. Zehe ra Abraham cuu sii ña, ta sa sahun uñi cuiya nuhñi ña zacuu cuehe ya. ¿Atu ña vaha sa cua ndasi ña quɨvɨ quitatu ñiyɨvɨ? Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ta sa yaha catyi ra cuhva ya, i cucahan xaan nuu ra xaan iñi sii ra. Ta zɨɨ xaan i cuñi tandɨhɨ ñiyɨvɨ sihin sa vaha xaan sa zavaha ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tacuan ta i catyi ra Jesús: ¿Yozo caa iyo sa ndyaca ñaha ra Ndyoo? ¿Ñaa sihin zacasi tehin sa ndyaca ñaha ra Ndyoo? ");
INSERT INTO mihNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Cuu si tañi minoo sɨtɨ mostaza sa i tasi minoo ra nu ñuhu ra, ta i sahnu tu. I cucahnu xaan tu ndya cuhva cua cozo zaa zoco tu. ");
INSERT INTO mihNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ta i catyi tucu ra Jesús inga saha: ¿Ñaa sihin zacasi tehin sa ndyaca ñaha ra Ndyoo? ");
INSERT INTO mihNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Cuu si tañi yusa iya sa quihin minoo ñaha ta nazaca ña sihin uñi tahan arroba yutyi pan. Yusa iya cuan cuu sa cua zanandaa sii tandɨhɨ yusa pan cuan. (Ta tacuan tucu cuahan nducahnu ca sa ndyaca ñaha ra Ndyoo.) ");
INSERT INTO mihNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tacuan ta cuahan ra Jesús tahan tahan ñuu nahnu ta ñuu ndyihi, zacuaha ra sii ñiyɨvɨ. Cuahan ra ndya Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ta minoo quɨvɨ i ndaca tuhun minoo ra sii ra: Tata, ¿atu zuhva ñi ñiyɨvɨ cua cacu? Ta i catyi ra Jesús sihin ra: ");
INSERT INTO mihNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Nducu xoon cuhva quɨhvun yuvehe tɨhɨn vatyi yɨɨ xaan cua quɨhvɨ ñiyɨvɨ nu ndyaca ñaha ra Ndyoo. Catyi suhun vatyi cuaha xaan ñiyɨvɨ cua cuñi ñu quɨhvɨ ñu, ta ma cuu. ");
INSERT INTO mihNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tañi ra xu vehe, tacuan iyo ra Ndyoo. Ta ra xu vehe cuan cua nacazi ra yuvehe ra. Ta cua cuyucu ndo sata vehe, ta cua cati ndo, ta cua catyi ndo: “Tata, tata, nuña yuvehe naquɨhvɨ ndi.” Ta cua catyi ra sihin ndo: “Ña site yoo ndoho cuu ndo.” ");
INSERT INTO mihNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tacuan ta cua catyi maa ndo: “Sasi ndi ta sihi ndi suhun, ta i zacuohon sii ndi ñuu ndi.” ");
INSERT INTO mihNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ta cua catyi ra Ndyoo sihin ndo: “Ña site yoo ndoho cuu ndo. Cuɨñɨ siyo ndo sii, vatyi ñá zavaha ndo sa vaha sa i catyi sihin ndo.” Cua catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ta cua vacu xaan ndo ndya cuhva cua casi quihñi noho ndo vatyi cua ndyehe ndo vatyi ñoho ra Abraham ta ra Isaac ta ra Jacob ta tandɨhɨ ra profeta. Ñoho tandɨhɨ ra cuan nu ndyaca ñaha ra Ndyoo, ta maa ndo cua ndoo ndo ityi sata. ");
INSERT INTO mihNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ta cua quisi ñiyɨvɨ ityi caña ñicandyi ta ityi cuahiñi ta ityi yucu ta ityi tyañuhu, ta cua cundyaa ñu nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ta iyo ñiyɨvɨ ña ñiñi vityi, ta cua nduu ñu ñiyɨvɨ ñiñi xaan yucuan. Ta ñiyɨvɨ ñiñi vityi cua nduu ñu ñiyɨvɨ ña ñiñi. ");
INSERT INTO mihNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ta zuun ñi quɨvɨ cuan i quisi zuhva ra fariseo, ta i catyi ra sihin ra Jesús: Quiton ihya ta cuhun vatyi cuñi cahñi ra rey Herodes suun. ");
INSERT INTO mihNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ta i catyi ra Jesús sihin ra: Cuahan ndo ta nacatyi ndo sihin ra ñicuii cuan vatyi yuhvi catyi vatyi tave tatyi cuihna ta zanduvehi sii ñiyɨvɨ vityi ta ityaan. Ta iza cua sei nu cuehin. ");
INSERT INTO mihNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Zoco tahan si sa caca ityi vityi ta ityaan ta iza vatyi ma cuu cuu minoo ra cahan Tuhun Ndyoo tatu ta saa ca ra ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Ndahvi yoho ñuu Jerusalén! Sahñi ñiyɨvɨ sii ra profeta ihya. Ta ra tasi ra Ndyoo ihya, cañi ñu sii ra sihin yuu. ¡Cuaha xaan cuaha xaan saha cuñi zandu‑ɨin sii ñiyɨvɨ ñuu ya ta zacuende sii ñu tañi zacuenda minoo ndɨvɨ sii zehe tɨ sisi ndisi tɨ, zoco ña cuñi ñu! ");
INSERT INTO mihNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ndyehe ndo vityi, ndoho ñiyɨvɨ ñuu Jerusalén, vatyi vityi zandoi sii ndo. Ta sa ndisa cuii catyi sihin ndo vatyi ma ndyehe ca ndo sii, ndya cuhva ndya quɨvɨ cua catyi ndo vatyi vaha xaan cuu ra vasi sa cuenda ra ndyaca ñaha sii yo. ");
INSERT INTO mihNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Minoo quɨvɨ quitatu ñiyɨvɨ i sahan ra Jesús vehe minoo ra cu nuu sii ra fariseo cua casi ra xita. Ta ndyehe xaan ra fariseo ñaa sa cua zavaha ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ta ñoho minoo ra cuhu yucuan; ndaa xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ta i catyi ra Jesús sihin ra maestro cuenda ley ta ra fariseo: ¿Atu catyi ley vatyi cuu zanduvaha yo sii ñiyɨvɨ quɨvɨ quitatu ñiyɨvɨ a ma cuu? ");
INSERT INTO mihNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tacuan ta tandɨhɨ ra cuan, taxi cuii ñi yucu ra ta ña cahan ra. Ta zɨquɨ i quihin ra Jesús sii ra cuhu cuan, ta i zanduvaha ra sii ra, ta i natasi ra sii ra sa cunuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ta zɨquɨ i catyi ra Jesús sihin ra fariseo: Tatu canacava minoo burro zono ndo a minoo zɨndɨquɨ zono ndo sisi minoo xahva quɨvɨ quitatu ñiyɨvɨ ¿atu ma tava ndo sii tɨ yatyi ñi vazu quɨvɨ quitatu ñiyɨvɨ cuu si? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tacuan ta ña cuu ca nacahan ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","I ndyehe ra Jesús cuhva i zavaha tandɨhɨ ñiyɨvɨ yucu vico cuan vatyi saa ra cuan ta i casi ra maa ñi tyayu vaha ca cundyaa ra, ta i cahan ra Jesús sihin minoo cuhva sihin ra, ta i catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Tatu cana minoo ra suun sa cuhun minoo vico tindaha, ma nanducun tyayu vaha ca cundyoon coto quisi inga ra ñiñi ca. ");
INSERT INTO mihNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ta ra i cana suun sa cuenda vico cuan cua quisi ra ta cua catyi ra suhun: “Cuhvon tyayu ya cundyaa inga ra ya.” Ta cua cucahan xaan nuun, ta cua cuhun nu ndyaa tyayu cuenda ñiyɨvɨ ña ñiñi. ");
INSERT INTO mihNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Vaha ca tatu cana ñu suun minoo vico, cuhun xihnon nu ndyaa tyayu ña ñiñi cundyoon. Ta zɨquɨ cua quisi ra i cana suun ta cua catyi ra: “Amigo, cuhun nu ndyaa tyayu vaha ca.” Cua catyi ra. Ta sihin cuhva cuan cua zacahnu ra suun nuu ñiyɨvɨ yucu suhun yumesa. ");
INSERT INTO mihNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Vatyi yoo ra zacahnu sii, cua zanduluhlu ñiyɨvɨ sii ra. Ta yoo ra zanduluhlu sii, cua zacahnu ñiyɨvɨ sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ta zɨquɨ i catyi ra Jesús sihin ra i cana sii ra sa cua casi ra: Tatu cua cuhvon minoo sa cuzama a sa cuxiñi sii ñiyɨvɨ, ma canon sii amigun a tohon a sii ñiyɨvɨ suun a sii ra cuca sa ndyaa yatyi yuvehun. Vatyi quɨvɨ nacoo tucu minoo vico vehe maa ra ta cua cana tucu ra suun. ");
INSERT INTO mihNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Zoco tatu cua zavohon minoo vico, canon sii ñu ndahvi, ñu coxo, ñu xii ta ñu cuaa. ");
INSERT INTO mihNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ta zɨɨ xaan cua cuñun. Vatyi ra yucuan ma cuu nacuhva ra sa casun, zoco cua tyiyahvi ra Ndyoo suun quɨvɨ cua nandoton sihin ñiyɨvɨ vaha. ");
INSERT INTO mihNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ta siñi minoo ra ndyaa mesa cuan sa cahan ra Jesús, ta catyi ra sihin ra: Zɨɨ xaan cua cuñi ra casi xita nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ta zɨquɨ i catyi ra Jesús sihin ra: I zavaha minoo ra minoo sa cuxiñi cahnu xaan vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ta cuhva sa cua cuhva ra sa cuxiñi ñu, i tasi ra sii muzu ra sa nacana ra sii ñu sa i cana ra vatyi sa ndyaa listo si, ta sa cuu quisi casi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Zoco tandɨhɨ ñu i catyi ñu vatyi ma cuu cuhun ñu. Ra sa xihna ñi i catyi ra: “Nacaa zate minoo ñuhu, ta cuñi sa cundyehi sii si. Catyun sihin ra vatyi nazaha ra tucahnu iñi sii, vatyi ma cuhin.” ");
INSERT INTO mihNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ta inga ra i catyi ra: “Nu zate ohon tahan yunta, ta cuehin cua ndyehi tatu vaha tɨ. Catyun sihin ra vatyi nazaha ra tucahnu iñi sii, vatyi ma cuhin.” ");
INSERT INTO mihNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ta inga tucu ra i catyi ra: “Nacaa tindehi, ta yucuan cuenda ma cuhin.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ta cua nuhu muzu cuan, ta i nacatyi ra tandɨhɨ cuhva ya sihin patrón ra. Ta i cuxaan xaan patrón ra, ta i catyi ra sihin muzu ra: “Cuahan yatyi cuii ñi tandɨhɨ ityi cahnu ta ityi ndyihi ta cuhun sii ra ndahvi ta ra coxo ta ra xii ta ra cuaa, ta quisi ndyacon sii ra ihya.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ta i zavaha muzu ra cuhva catyi ra, ta zɨquɨ i catyi ra: “Tata, sa zavehi tandɨhɨ cuhva catyun, ta nuña ca.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ta i catyi patrón ra sihin ra: “Cuahan tandɨhɨ cuii ityi, ta zañiñun sii ñiyɨvɨ vatyi naquisi ñu. Cuñi sa cua cutu cuii vehi. ");
INSERT INTO mihNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Vatyi catyi suhun vatyi numinoo ra i cane sa xihna ñi, ma cuhva que sa casi ra sihin.” ");
INSERT INTO mihNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cuaha xaan ñiyɨvɨ cuahan sihin ra Jesús. Ta i ndyehe ra sii ñu ta i catyi ra sihin ñu: ");
INSERT INTO mihNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Tandɨhɨ ndoho ra ndyico sii, tatu cuñi ca ndo sii ñiyɨvɨ sii ndo ta zɨquɨ sii mi, ma cuu cuu ndo ñiyɨvɨ sii mi. ");
INSERT INTO mihNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Vatyi yoñi ra cuu cuu ñiyɨvɨ sii mi tatu ma ndyehe ra tundoho sa cuende, ta vazu cuu ra sa cuende. ");
INSERT INTO mihNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Vatyi yoñi minoo ra tatu cua zandaa ra minoo torre ta ma cundyaa xihna ra ta tava ra cuenda tatu ñihi xuhun ra ta cundyee iñi ra zandɨhɨ ra tyiño cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Coto sa zavaha ra cimiento ta zɨquɨ ma cuu zandɨhɨ ra tyiño. Ta tandɨhɨ ñiyɨvɨ cua ndyehe sii si, ta cua vacu ndyaa xaan ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ta cua catyi ñu: “Ihya ra i quisaha zandaa ra minoo torre, ta ñá cuu zandɨhɨ ra sii si.” ");
INSERT INTO mihNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A tatu iyo minoo rey sa cuñi cahñi tahan sihin inga rey sa iyo oco mil zandaru. Rey sa xihna ñi cuan cua cundyaa xihna ra ta nacañi iñi ra tatu cuu zahacanaa ra sihin sa usi mil zandaru sa iyo sii maa ra. ");
INSERT INTO mihNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ta tatu sa sito ra vatyi ma cuu, cua tasi ra tyiño nɨɨ ñi sa ndyaa inga rey cuan nusica, ta cua caca ra sii ra vatyi nandɨhɨ ñi maa tuhun. ");
INSERT INTO mihNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ta tacuan tucu maa ndo, tatu ma cahndya iñi ndo tandɨhɨ sa cuñi xaan ndo ta tandɨhɨ sa cumi ndo, ma cuu cuu ndo ñiyɨvɨ sii mi sa ndisa cuii. ");
INSERT INTO mihNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Vaha xaan cuu ñɨɨ, zoco tatu ña uhva ca si ¿yozo caa cuu cutyiño ñiyɨvɨ sii si? ");
INSERT INTO mihNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ñahñi ca sa cuu zacuu ñu sihin si. Nu sa tyindyee si sii ñuhu ta ma cuu. Nu ndɨhɨ tuhun zavita ñu sii si. Tatu ndyaa zoho ndo, cuɨñɨ ndo tuhun ya. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ta tandɨhɨ ra tava xuhun cuenda ra ndyaca ñaha ta ra iyo cuatyi, i tuhva ra sii ra Jesús vatyi cuñi ra tyizoho ra sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ta i cahan xehe ra fariseo ta ra maestro cuenda ley sa cuenda ra Jesús, ta i catyi ra: Ra ihya, cahan ra sihin ra iyo cuatyi, ta sasi ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tacuan ta i cahan ra Jesús sihin ra zɨquɨ minoo cuhva ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Yoo ndoho, ra iyo minoo ziendu mvee ticatyi zono, tatu cua naa minoo tɨ ¿atu ma zandoo ndo tandɨhɨ tɨ sicuhu? Ta cua nanducu ndo sii sa minoo tɨ cuan ndya nañihi ndo sii tɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ta cuhva sa cua nañihi ndo sii tɨ, cua cozo zoco ndo sii tɨ, ta zɨɨ xaan cua cuñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ta tatu sa nasaa ndo vehe ndo cua cana ndo sii amigo ndo ta sii ñiyɨvɨ yucu yatyi, ta cua catyi ndo: “Cuzɨɨ xaan iñi ndo sihin, vatyi i nañihi mvee ticatyi zone quɨtɨ sa cua naa.” ");
INSERT INTO mihNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ta catyi sihin maa ndo vatyi zuun ñi cuhva cuan, zɨɨ xaan cua cuñi ángel gloria sa cuenda minoo ra cua ndu‑uu iñi cuatyi. Zɨɨ ca cua cuñi ángel sihin sa minoo ra cuan ta zɨquɨ sihin sa cumi xico sahun cumi tahan ñiyɨvɨ vaha sa ñahñi cuatyi ta ña zama ñu cuhva iyo ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ta inga tucu cuhva, tatu iyo minoo ñaha sa cumi usi tahan xuhun, ta tatu cua naa minoo xuhun ña. ¿Atu ma tyaa ña minoo candil ta natɨhvɨ ña sisi vehe ña ta nanducu ña xuhun cuan ndya cuhva ndya cua nañihi ña sii si? ");
INSERT INTO mihNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ta tatu sa nañihi ña sii si, cua cana ña sii amigo ña ta sii ñiyɨvɨ yucu yatyi, ta cua catyi ña: “Cuzɨɨ xaan iñi ndo sihin, vatyi i nañihi xuhin sa cua naa.” ");
INSERT INTO mihNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ta zuun ñi cuhva cuan catyi sihin maa ndo vatyi zɨɨ xaan cua cuñi ángel ra Ndyoo sa cuenda minoo ra cua ndu‑uu iñi cuatyi. ");
INSERT INTO mihNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tacuan ta i catyi tucu ra Jesús cuhva ya: Sicoo minoo ra, ta uu tahan zehe yɨɨ ra i sicoo. ");
INSERT INTO mihNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ta minoo saha i catyi ra luhlu ca sihin zutu ra: “Tata, cuhvon ndaha tyiño sa tahan si sii.” Ta i natahvi zutu ra ndaha tyiño sa tahan si sii minoo minoo zehe ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ta ña cuaha ñi quɨvɨ ta zɨquɨ i xico ra luhlu ca cuan tandɨhɨ cuii sa nacuhva zutu ra sii ra. Ta i zatahan ra xuhun ra, ta cuahan ra nusica. Ta yucuan i zanaa ra tandɨhɨ cuii xuhun ra sihin sa cuzɨɨ iñi ra. Ta zana xaan i sicoo ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ta sa yaha zanaa ra tandɨhɨ, ta zɨquɨ i sicoo minoo tama ñuu cuan, ta i quisaha sizoco ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tacuan ta sahan ra vehe minoo ra ñuu cuan. Ta i tasi ra cuan sii ra nu iyo quɨnɨ zono ra vatyi cua cuhva ra sa casi tɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ta i sizoco xaan ra ndya cuhva cuñi ra casi ra sa sasi quɨnɨ. Ta yoñi maa sa saha sa casi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tacuan ta i quisaha nacañi iñi ra ta i catyi ra: “Tandɨhɨ cuii muzu zuti, sasi vaha ra ndya cuhva ndoo ca sa sasi ra. Ta yuhvi, cuñi cahñi zoco sii. ");
INSERT INTO mihNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Vityi cunanuhi nu ndyaa zuti, ta tyehen cua catyi sihin ra: Tata, sicoo cuatyi nuu Ndyoo ta nuu moo. ");
INSERT INTO mihNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Zohon tuhun sa yɨvɨ ca zehun cuu sii, zoco cuhvon sa cui minoo muzun.” Tacuan i sica iñi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ta i nduvita ra, ta i quihin ra ityi cua nanuhu ra ndya vehe zutu ra. Zoco sica ca vasi ra ta sa i ndyehe zutu ra sii ra. Ta i cundahvi iñi ra sii zehe ra, ta i cacono ra cua zatahan ra sii ra. Ta i sicunumi ra sii ra, ta i sihi ra xɨtɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ta i catyi zehe ra sihin ra: “Tata, sicoo cuatyi nuu ra Ndyoo ta nuu moo. Zohon tuhun sa yɨvɨ ca zehun cuu sii.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Zoco i catyi zutu ra sihin muzu ra: “Ta ndyaca ndo zahma vaha ca, ta natyihi ndo sii ra. Ta tyihi ndo minoo xehe nundaha ra. Ta natyihi ndo zapato saha ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ta cahñi ndo minoo zɨndɨquɨ luhlu, quɨtɨ xahan ca, vatyi casi yo, ta nacuzɨɨ xaan iñi yo. ");
INSERT INTO mihNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Vatyi zehi, sa i zehi tuhun vatyi sa i sihi ra, ta vityi ndito ra. Cua naa ra ta vityi naquita ra.” Catyi zutu ra. Ta i quisaha zavaha ñu minoo vico. Ta zɨɨ xaan i cuñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ta inga zehe ra cuan, ra nuu, zatyiño ra sisi cuhu. Ta cuhva sa cua nasaa ra ndya vehe, ta siñi ra yaa ta sa sata saha ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ta i cana ra sii minoo muzu, ta i ndaca tuhun ra ñaa sa cuu. ");
INSERT INTO mihNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ta i catyi muzu sihin ra: “Nasaa yañun, ta i tava zutun tyiño sa cuu minoo zɨndɨquɨ luhlu, quɨtɨ xahan xaan, vatyi vaha ñi i nasaa yañun.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ta i cuxaan xaan ra nuu cuan, ta ñá cuñi ra quɨhvɨ sisi vehe. Yucuan cuenda i quita zutu ra, ta i cana ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Zoco i catyi ra sihin zutu ra: “Ndyehe, sa cuaha xaan cuiya zatyiñe suhun, ta ñahñi cuhva sa ñá tyei yahvi sa cohon. Zoco numinoo saha ta ñá sohon minoo mvee luhlu sii, vatyi cua zavehi minoo vico sihin amigi. ");
INSERT INTO mihNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ta sa nasaa zehun, ra i zanaa xuhun moo sihin ñu zɨhɨ zɨɨ iñi, ta yatyi xaan sahñun minoo zɨndɨquɨ cuenda ra.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tacuan ta i nacahan zutu ra, ta i catyi ra sihin ra: “Zehe luhli, ndyoon sihin tandɨhɨ cuii tyiemvu. Ta tandɨhɨ sa sii, sii tucu moo cuu. ");
INSERT INTO mihNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Zoco vityi tahan si sa zacahnu yo vico ya ta cuzɨɨ xaan iñi yo vatyi i zehi tuhun vatyi sa i sihi yañun, ta vityi ndito ra. Cua naa ra ta naquita ra.” ");
INSERT INTO mihNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tacuan ta i quisaha catyi ra Jesús sihin ra i casi ra: Sicoo minoo ra cuca, ta sicoo minoo ra zacuenda xuhun ra. Zoco i catyi inga ñiyɨvɨ sihin ra cuca cuan vatyi zatɨvɨ xaan ra zacuenda cuan xuhun ra. ");
INSERT INTO mihNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ta i cana ra cuca cuan sii ra, ta i catyi ra sihin ra: “Cuaha xaan tuhun ñihi sa cuendon. Nacuhva cuendon tandɨhɨ cuii tyiño i zacuun sii, vatyi ma zatyiño con sihin.” ");
INSERT INTO mihNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ta zɨquɨ i sica iñi ra zacuenda xuhun cuan sihin añima ra: “¿Yozo caa zacui vityi? Cuñi quindyaa patroin tyiñe, ta ñahñi tundyee iñi iyo sii, sa zatyiñe. Ta cahan xaan nui caque caridad sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Zoco site yozo caa cua zavehi vatyi vaha sa coo amigi, ta zɨquɨ tatu ñahñi tyiñe, zoco cuu cuhin vehe ra.” ");
INSERT INTO mihNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tacuan i sica iñi ra cuan, ta zɨquɨ i cana ra sii sa minoo minoo ra tavi sii patrón ra. Ta i catyi ra sihin ra i saa sa xihna ñi: “¿Yozo tavun sii patroin?” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ta i catyi ra cuan: “Tavi cumi mil litro azetye.” Catyi ra. Ta i catyi ra sihin ra: “Quihin inga tutu ya, ta tyoon uu mil ñi, ta tyoon zɨvun, ta zaviton tutu sahnu cuan.” Catyi ra. Ta tacuan i zavaha ra ta cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ta zɨquɨ i saa inga ra, ta i catyi ra sihin ra: “¿Yozo tavun sii patroin?” Ta i catyi ra cuan: “Tavi minoo mil arroba trigo.” Catyi ra. Ta i catyi ra sihin ra: “Quihin inga tutu ya, ta tyoon uña ziendu arroba ñi, ta tyoon zɨvun, ta zaviton tutu sahnu cuan.” ");
INSERT INTO mihNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tacuan ta i sito patrón ra sa ña vaha sa zavaha ra, ta iyo xaan i cuñi ra vatyi casi xaan iñi ra zavaha ra sa ña vaha. Catyi ra Jesús. Ta i catyi tucu ra sihin ra i casi ra: Casi ca iñi ñiyɨvɨ ña vaha añima ta zɨquɨ ñiyɨvɨ vaha añima. ");
INSERT INTO mihNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ta catyi sihin ndo vatyi cutyiño ndo ndaha tyiño ndo sa iyo ñuu ñiyɨvɨ ya, ta tyindyee ndo sii ñiyɨvɨ. Ta quɨvɨ cua ndɨhɨ si, cua ñihi ndo minoo nu cundyaa ndo sa ma naa ca nu ndyaa ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ra zavaha sa ndoo sihin sa zuhva ñi sa iyo sii ra, tacuan cua zavaha tucu ra vazu sihin cuaha ca. Ta ra ña zavaha sa ndoo sihin sa zuhva ñi, ma zavaha tucu ra sa ndoo sihin sa cuaha ca iyo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yucuan cuenda tatu ña zavaha ndo sa ndoo sihin sa iyo ñuu ñiyɨvɨ ya, ma cuhva ra Ndyoo sa vaha xaan sa iyo andɨvɨ sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tandɨhɨ sa iyo sii ndo, maa ra Ndyoo saha noo sii si sii ndo. Ta tatu ña zavaha ndo sa ndoo sihin si, ma cuhva maa ra sa cuu sii maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ma cuu zatyiño minoo muzu sa cuenda uu tahan patrón vatyi cua cuñi ca ra sii minoo patrón ra, ta ma cuñi ra sii inga ra. A sii minoo ra cua tyaa ra yahvi, ta sii inga ra ma tyaa ra yahvi. Ma cuu cuñi ndo sii ra Ndyoo ta cuñi ndo sii xuhun. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ta i siñi ra fariseo tandɨhɨ sa cahan ra Jesús. Ta i sacu ndyaa ra sii ra vatyi cuñi xaan ra fariseo cuan xuhun. ");
INSERT INTO mihNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ta i catyi ra Jesús sihin ra: Ityi nuu ñiyɨvɨ zaha maa ndo tuhun vatyi vaha xaan ñiyɨvɨ cuu ndo, zoco sito maa ra Ndyoo añima ndo. Ta tandɨhɨ sa zacahnu xaan ñiyɨvɨ, ña cuu ndyehe ra Ndyoo sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ley ra Ndyoo sa i tyaa ra Moisés ta tuhun i tyaa ra profeta ta sa naha, yucuan cuu sa zañaha ityi sii ndo ndya quɨvɨ i saa ra Juan. Quɨvɨ i saa ra Juan ta i quisaha nacatyi ra sihin ñiyɨvɨ cuhva ndyaca ñaha ra Ndyoo. Ta cuaha xaan ñiyɨvɨ cuñi xaan ñu cuhva cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Zoco catyi sihin ndo vatyi vazu cunaa ñuu ñiyɨvɨ a sa iyo ityi zɨquɨ, zoco ley ra Ndyoo sa i tyaa ra Moisés ma cuu naa si nu siin. ");
INSERT INTO mihNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tatu iyo minoo rayɨɨ ta zandoo ra sii ñazɨhɨ ra ta tani tutu sa tindaha ra ta tindaha ra sihin inga ñaha, zavaha ra cuan sa cuu adulterio. A tatu tindaha inga ra sihin ñaha sa zandoo yɨɨ sii, zuun ñi cuatyi cuan zavaha ra. ");
INSERT INTO mihNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","I sicoo minoo ra cuca, ta tyaqui xaan i cuu zahma ra tyacu yuhva tixinda, ta yahvi xaan ndyaa si. Ta sasi vaha xaan ra tandɨhɨ quɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ta sicoo tucu minoo ra ndahvi sa nañi Lázaro. Iñi xaan ra ityi, ta catuu ra yuvehe ra cuca cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Cuñi xaan ra casi ra vazu sa canacava yumesa ra cuca cuan. Ta i saa ina nu catuu ra ndahvi cuan, ta yuyaa tɨ nu cahvi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ta minoo quɨvɨ i sihi ra, ta i sindyaca ángel ra Ndyoo sii ra ndya nu ndyaa ra Abraham gloria. Ta i sihi tucu ra cuca cuan, ta tyihi ñu sii ra sisi ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ta cuahan añima ra andyaya, ta ndyehe xaan ra tundoho yucuan. Ta i nandyehe ndaa ra, ta sica xaan i ndyehe ra sii ra Abraham sihin ra Lázaro. ");
INSERT INTO mihNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ta i cana saa ra ñoho andyaya cuan ta catyi ra: “Tata Abraham, cundahvi iñun sii, ta tasun sii ra Lázaro nazatyii ra siin nundaha ra ta quisi zatoon ra nu yei vatyi yaha xaan cahnu tundoho ndyehi sisi ñúhu ya.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Zoco i catyi ra Abraham sihin ra: “Nacohon iñun vatyi cuaha xaan sa vaha sicoo suun quɨvɨ i sinditon ñuu ñiyɨvɨ. Ta ra Lázaro ndahvi xaan i cuu ra ñuu ñiyɨvɨ. Ta vityi iyo sa vaha sii ra, ta yoho ndyehun tundoho. ");
INSERT INTO mihNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ta inga tucu cuhva vatyi iyo minoo xahva cahnu xaan mahñu nu yucu yo. Ta vazu cuñi ra ihya cuhun ra nu ndyoon, zoco ma cuu. Ta ma cuu quisi minoo ra ñoho nu ñohon nu ndyaa ndi.” ");
INSERT INTO mihNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ta zɨquɨ i catyi ra cuca cuan: “Tata Abraham, zohon tumañi iñi sii, ta tasun sii ra Lázaro ndya vehe zuti. ");
INSERT INTO mihNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Vatyi iyo ohon tahan yañi, ta cuñi vatyi cunacatyi ra sihin ra yozo caa iye ihya nu ndyehi tundoho coto quisi tucu ra ihya.” ");
INSERT INTO mihNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tacuan ta i catyi ra Abraham sihin ra: “Iyo ley sa i tyaa ra Moisés ta iyo tuhun i tyaa ra profeta ta sa naha. Nazavaha yañun sa catyi si cuan.” ");
INSERT INTO mihNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tacuan ta i catyi ra cuca cuan: “Tata Abraham, ma tyaa ra yahvi sii si cuan. Zoco tatu cua nandoto minoo ra sa i sihi ta cuhun ra nu ndyaa ra, yucuan ndisa cua tyaa ra yahvi, ta cua zama ra cuhva iyo ra.” ");
INSERT INTO mihNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ta i catyi ra Abraham sihin ra: “Tatu ma tyaa ra yahvi sii ley i tyaa ra Moisés ta sii tuhun i tyaa ra profeta, ma sino iñi ra vazu cua nandoto minoo ñiyɨvɨ ta cahan ra sihin ra.” ");
INSERT INTO mihNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tacuan ta i catyi ra Jesús sihin ra i casi ra: Tandɨhɨ cuii tyiemvu cua coo sa quiñi caa sa zatɨvɨ sii ñiyɨvɨ, zoco ndahvi ñi cuu ra tyiyuhu sii ñiyɨvɨ ta zavaha ñu cuatyi ta tɨvɨ ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vaha ca tatu cuhñi yo minoo yuu vee xaan zucu ra ta zavita yo sii ra sisi tyañuhu coto zatɨvɨ ra sii ñu sino iñi sii Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Zaha ndo cuenda sii ndo. Tatu zavaha minoo ra tahan ndo minoo sa ña vaha suhun, catyun sihin ra ñaa sa ña vaha i zavaha ra. Ta tatu zama ra cuhva iyo ra, zohon tucahnu iñi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ta tatu usa tahan saha sa minoo quɨvɨ zavaha ra sa ña vaha suhun ta tandɨhɨ usa tahan saha catyi ra suhun: “Zohon tucahnu iñi sii.” Zohon tucahnu iñi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tacuan ta i catyi ra apóstol sihin ra Jesús: Cuhvon cuhva sii ndi ta cua sino xaan ca iñi ndi suun. ");
INSERT INTO mihNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ta i catyi ra Jesús sihin ra: Tatu sino iñi ndo sii mi siin ñi vazu tañi caa minoo sɨtɨ mostaza luhlu ñi cuu cuhva sino iñi ndo, ta cua cuu catyi ndo sihin yutu sicómoro sa nandyaa ihya vatyi cuɨñɨ siyo tu nu ndyaa tu ta cuhun tu sisi tyañuhu, ta cua tyaa tu yahvi sa cahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ta zɨquɨ i catyi ra Jesús: Yoo ndoho tatu tahvi muzu ndo ñuhu a saha ra sa casi zɨndɨquɨ zono ndo ta zɨquɨ nasaa ra vehe, ¿atu cua catyi ndo sihin ra: “Cundyaa ta casun xita”? ");
INSERT INTO mihNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tyehen cua catyi ndo sihin ra: “Zavohon sa cuxiñi, ta tyizon coho nu mesa. Ta tatu sa sasi ta zɨquɨ casi tucu moo.” Cua catyi ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Atu nacuhvon tyahvi ndyoo sii ra vatyi zavaha ra tyiño tavon sii ra? Ña tacuan vatyi tahan si zavaha ra tyiñon. ");
INSERT INTO mihNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ta tacuan tucu maa ndo. Tatu sa zavaha ndo tandɨhɨ cuii tyiño sa tava ra Ndyoo sii ndo. Catyi ndo: “Ñahñi maa sa vaha zavaha ndi. Maa ñi cuhva tahan si zavaha ndi i zavaha ndi.” Tacuan tahan si catyi ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ta cuhva sa cuahan ra Jesús ndya ñuu Jerusalén, i yaha ra nu cu si Galilea ta nu cu si Samaria. ");
INSERT INTO mihNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ta sa i saa ra minoo ñuu ta i quita usi tahan ra tyahyu ta yucu ra ndya zava. ");
INSERT INTO mihNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ta i cana saa tandɨhɨ ra, ta catyi ra: Maestro Jesús, cundahvi iñun sii ndi. ");
INSERT INTO mihNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ta sa ndyehe ra Jesús sii ra, ta i catyi ra sihin ra: Cuahan ndo cua zañaha ndo sii ndo sii ra cu zutu. Tacuan i catyi ra Jesús sihin ra cuan, ta ityi cuahan ra i nduvaha ra. ");
INSERT INTO mihNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ta minoo ra, cuhva sa ndyehe ra vatyi sa nduvaha ra, i sinanuhu sata ra. Ta ñihi xaan i cana saa ra ta i zacahnu ra sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ta i sicuɨñɨ sɨtɨ ra, ta i sicava ndyayu ra nu ñuhu nu ndyaa saha ra Jesús, ta i saha xaan ra tyahvi ndyoo sii ra. Ta minoo ra samaritano cuu ra nduvaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tacuan ta i catyi ra Jesús: ¿Atu ña usi tahan ra i nduvaha? ¿Ndyamaa cuahan ɨɨn tahan ca ra? ");
INSERT INTO mihNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Atu minoo tuhun ñi ra inga ñuu ya cuu ra i ndisi nanuhu sata sa nacuhva ra tyahvi ndyoo sii ra Ndyoo? ");
INSERT INTO mihNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ta i catyi ra Jesús sihin ra i nduvaha: Nduvita ta cuhun. I nduvohon vatyi sino iñun. ");
INSERT INTO mihNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","I ndaca tuhun ra fariseo sii ra Jesús: ¿Ama cua quisaha cundyaca ñaha ra Ndyoo ñuu ñiyɨvɨ? Ta i catyi ra Jesús sihin ra: Ma coto ndo ama cua quisaha cundyaca ñaha ra Ndyoo vatyi yɨvɨ sa cuu ndyehe yo cuu si. ");
INSERT INTO mihNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma cuu catyi ñiyɨvɨ: “Ihya ndyaa ra”, a “Ityi cuan ndyaa ra” vatyi zɨɨn cuu cuhva ndyaca ñaha ra. Sisi añima ñiyɨvɨ cuu nu ndyaca ñaha ra, añima ñiyɨvɨ sa tyaa yahvi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tacuan ta i catyi ra Jesús sihin ra i casi ra: Cua coo quɨvɨ ta cua cuñi ndo ndyehe ndo sii ra i quisi ndya gloria, zoco ma ndyehe ca ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ta cua catyi ñiyɨvɨ sihin ndo: “Ihya ndyaa ra”, a “Yucuan ndyaa ra.” Zoco ma cuhun ndo cundyehe ndo. Ta ma cundyico ndo sii ra cuan vatyi yɨvɨ yuhvi cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Vatyi quɨvɨ cua quisi inga saha, cua ndyehe tandɨhɨ ñiyɨvɨ sii. Tañi ndyehe tandɨhɨ ñiyɨvɨ tatu yaha tasa zavi nacahnu andɨvɨ, tacuan cua cuu si quɨvɨ cua quisi tucu ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Zoco xihna ca tahan si ndyehi tundoho cuaha xaan cuhva. Ta ñiyɨvɨ sa iyo vityi ma cuñi ñu sii. ");
INSERT INTO mihNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tañi i cuu si quɨvɨ ra Noé, tacuan cua cuu tucu si quɨvɨ cua quisi tucu ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Quɨvɨ ra Noé, sasi ñu. Sihi ñu. Tindaha ñu. Ta saha ñu sii zehe ñu sa tindaha ñu ndya cuhva ndya quɨvɨ i quɨhvɨ ra Noé sisi barco ta i coon zavi xaan. Ta i naa tandɨhɨ ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tacuan i cuu tucu si quɨvɨ ra Lot. Sasi ñu. Sihi ñu. Zata ñu. Naxico ñu. Tasi ra itu. Ta zavaha ra vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ta zuun ñi quɨvɨ i quita ra Lot ñuu Sodoma cuan, i coon xaan ñúhu sihin azufre ndya andɨvɨ, ta i naa tandɨhɨ cuii ñiyɨvɨ ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ta zuun ñi tacuan cua cuu si quɨvɨ cua quisi tucu ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Quɨvɨ cuan tatu ñoho minoo ndo xiñi vehe, ma noo ndo ta tava ndo ndaha tyiño ndo. A tatu ñoho ndo itu ndo ma cunuhu ndo ndya vehe ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nacohon iñi ndo cuhva i tahan si sii ñazɨhɨ ra Lot. ");
INSERT INTO mihNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yoo ra cua nducu cuhva zacacu ra sii ra, cunaa ra. Ta yoo ra cua cuhva sa cuu ra sa cuenda mi, cua cacu ndisa cuii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ta catyi sihin ndo vatyi sa cuaa cuan, uu tahan ñiyɨvɨ quixi ɨɨn ñi nu sito. Cua naquihin sii minoo ñi ta minoo cua nandoo. ");
INSERT INTO mihNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ta uu tahan ñuzɨhɨ ndyico ɨɨn ñi quɨvɨ cuan, cua naquihin sii minoo ñi ña. Ta inga ña cua nandoo. ");
INSERT INTO mihNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ta uu tahan ra ñoho itu ra, cua quihin sii minoo ra. Ta inga ra cua nandoo. ");
INSERT INTO mihNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tacuan catyi ra Jesús. Ta cuhva sa siñi ñiyɨvɨ tuhun ya, i ndaca tuhun ñu sii ra: ¿Ndyamaa cua cuhun ñiyɨvɨ cuan? Ta i catyi ra Jesús sihin ñu: Nu catuu ndɨyɨ, yucuan cua titahan tyasii. ");
INSERT INTO mihNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tacuan ta i cahan ra Jesús zɨquɨ minoo cuhva ya vatyi cuñi ra sa cua coto ñu vatyi tahan si sa caca ñiyɨvɨ tumañi iñi sii ra Ndyoo tandɨhɨ saha, ta ma zandɨhɨ yo tuhun sa caca yo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ihya cuu cuhva i catyi ra Jesús: Minoo ñuu sicoo minoo ra juez. Ta ña yuhu ra sii ra Ndyoo. Ta ña tyaa ra yahvi sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ta zuun ñi ñuu cuan sicoo minoo ñandahvi. Ta i sahan ña nu ndyaa ra juez cuan, ta catyi ña sihin ra vatyi sica ña cuatyi saha minoo ra xaan iñi sii ña. ");
INSERT INTO mihNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ta ña tyizoho ra juez cuan sa cahan ña. Ña cuñi ra zandaa ra tyiño ña. Ta sa naha xaan sica ña. Ta zɨquɨ i sica iñi ra juez: “Vazu ña yuhi sii ra Ndyoo ta ña tyei yahvi sii ñiyɨvɨ, ");
INSERT INTO mihNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","zoco zayanga xaan maha ya sii. Yucuan cuenda cua zandei tyiño ña coto quisi ca ña ta zayanga ca ña sii.” ");
INSERT INTO mihNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ta i catyi ra Jesús: Sa siñi ndo cuhva catyi ra juez, ra ña vaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ta maa ra Ndyoo ¿atu ma zacacu ra sii ñiyɨvɨ i casi ra vatyi sica ñu tumañi iñi sii ra ora ta sa cuaa? ¿Atu cuatu xaan ra ta zɨquɨ tyindyee ra sii ñu? ");
INSERT INTO mihNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Catyi sihin ndo vatyi yatyi xaan cua zacacu ra sii ñu. Zoco quɨvɨ cua quisi tucu ra i quisi ndya gloria, sito Ndyoo tatu nañihi que sii ñu sino iñi sii, sa ndisa cuii. ");
INSERT INTO mihNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tacuan ta i cahan ra Jesús zɨquɨ minoo cuhva cuenda ñiyɨvɨ zaha tuhun vatyi vaha xaan ñu ta ña cuu ndyehe ñu sii inga ñiyɨvɨ. Ta ihya cuu cuhva i catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","I quɨhvɨ uu tahan ra vehe ñuhu vatyi cua cahan ra sihin ra Ndyoo. Minoo ra cuu ra minoo ra fariseo, ta inga ra cuu minoo ra tava xuhun cuenda ra ndyaca ñaha. ");
INSERT INTO mihNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Iñi ndyaa ra fariseo, ta ihya cuhva i sica iñi ra sisi añima ra: “Zutu mañi yuu, nacuhve tyahvi ndyoo suun vatyi ña iye tañi iyo inga ñiyɨvɨ. Ña zuhi. Ña quiñi iye. Yoñi tyañi. Ta ña iye tañi ra tava xuhun ya. ");
INSERT INTO mihNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Vaha xaan tyei yahvi tuhun cohon vatyi uu saha sa minoo vitya sahñi zoque sii, ta sehi diezmo suun sihin tandɨhɨ cuii sa iyo sii.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ta ndya zava, iñi ndyaa ra tava xuhun cuenda ra ndyaca ñaha. Ta nu ña nandyehe ndaa ra andɨvɨ. Ta cati ra yɨquɨ ndyica ra vatyi ndu‑uu iñi ra cuatyi ra. Ta tyehen cahan ra sihin ra Ndyoo: “Zutu mañi yuu, cundahvi iñun sii, vatyi iyo xaan cuatyi.” Tacuan i catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ta catyi sihin ndo vatyi sii maa ra cuan i zaha ra Ndyoo tucahnu iñi ta yɨvɨ sii inga ra. Zanaa ra Ndyoo cuatyi ra tava xuhun cuan, ta cuanuhu ra ndya vehe ra. Zoco ra fariseo cuan, ñahñi tucahnu iñi ñihi ra vatyi ña vaha cuhva sica ra. Ta zɨɨn sa zacahnu xaan ra sii ra. Yucuan cuenda luhlu ñi ndyehe ra Ndyoo sii ra. Zoco tatu zanduluhlu yo sii yo, cua nducahnu yo nuu ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ta i quisi ndyaca tucu ñiyɨvɨ sii sa ndyihi vatyi cua tyizo ra Jesús ndaha ra xiñi si. Ta sa ndyehe ra i casi ra Jesús cuhva zavaha ñu, ñá saha ca ra. ");
INSERT INTO mihNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Zoco i cana ra Jesús sii ra, ta i catyi ra sihin ra: Cuhva ndo sa quisi sa ndyihi nu ndyei, ta ma catyi ndo vatyi ma cuu vatyi tañi iyo sa ndyihi tacuan iyo ñiyɨvɨ saha sa cundyaca ñaha ra Ndyoo sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ta catyi sihin ndo vatyi tatu ma cuhva ndo sii ndo sii ra Ndyoo ta sino iñi ndo sii ra tañi sino iñi sa ndyihi sii zutu si, ma cuu quɨhvɨ ndo nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tacuan ta i ndaca tuhun minoo ra ndyaca ñaha cuenda vehe ñuhu sii ra Jesús ta catyi ra: Yoho maestro vaha xoon, ¿yozo caa zacui ta ñihi tahvi añime? ");
INSERT INTO mihNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ta i catyi ra Jesús sihin ra: ¿Ñaa cuenda catyun vatyi vaha xein? Minoo tuhun ñi ra vaha iyo, maa ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Sa siton tandɨhɨ cuii ley maa ra Ndyoo cuhva catyi si: “Ma cuzun sihin inga ñaha sa yɨvɨ ñazɨhun cuu. Ma cahñun sii ñiyɨvɨ. Ma zuhun. Ma cohon cuendu zɨquɨ ñiyɨvɨ. Ta tyoon yahvi sii zutun ta sii zɨhun.” Catyi ra Jesús sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ta i catyi ra cuan: Tyei yahvi sii tandɨhɨ tuhun cuan cuhva ndya luhli. ");
INSERT INTO mihNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ta sa siñi ra Jesús cuhva catyi ra, ta i catyi ra sihin ra: Minoo ñi ca cuhva cumañi suun. Xicon tandɨhɨ sa iyo suun, ta cuhvon xuhun cuan sii ñiyɨvɨ ndahvi, ta cua coo sa cuca suun ndya gloria, ta quisun ta cundyicon sii. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ta sa siñi ra cuan cuhva catyi ra Jesús, ta i nducuihya xaan iñi ra vatyi cuca xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ta sa ndyehe ra Jesús vatyi cuihya xaan cuñi ra, ta i catyi ra sihin ra: Yɨɨ xaan cua quɨhvɨ ñiyɨvɨ cuca nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yɨɨ ca quɨhvɨ minoo ra cuca nu ndyaca ñaha ra Ndyoo ta zɨquɨ ca minoo camello yaha tɨ xuu minoo yɨcuɨ tɨcuɨ. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ta ñiyɨvɨ sa siñi cuhva catyi ra Jesús i ndaca tuhun ñu: Tatu tacuan cuu si ¿yoo ra cuu cacu? ");
INSERT INTO mihNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ta i catyi ra Jesús sihin ñu: Tandɨhɨ sa ña cuu zavaha ñiyɨvɨ, cuu zavaha ra Ndyoo sii si. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tacuan ta i catyi ra Pedro sihin ra: Sa zandoo ndi tandɨhɨ sa sii ndi, ta ndyico ndi suun. ");
INSERT INTO mihNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ta i catyi ra Jesús sihin tandɨhɨ ra: Sa ndisa catyi sihin ndo vatyi tandɨhɨ ndo sa zandoo vehe ndo a ñazɨhɨ ndo a tahan ndo a zutu ndo a zɨhɨ ndo a zehe ndo ta nducu ndo sa vaha sa cuenda nu ndyaca ñaha ra Ndyoo, ");
INSERT INTO mihNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","cuaha xaan sa vaha cua ñihi ndo ihya ñuu ñiyɨvɨ ya, ta inga ñuu ñiyɨvɨ saa cua cundito ndo tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","I cana ra Jesús sii sa usi uu tahan ra i casi ra, ta i catyi ra sihin ra: Vityi cua cuhun yo ñuu Jerusalén. Ta yucuan cua cuu tandɨhɨ sa i tyaa ra profeta ta sa naha sa cuenda ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Vatyi cua cuhva cuenda ñiyɨvɨ sii ra sii ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu, ta cua vacu ndyaa ñiyɨvɨ sii ra. Quiñi xaan cua zavaha ñu sihin ra, ta cua tyicu zɨɨ ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ta cua cañi xaan ñu sii ra, ta cua cahñi ñu sii ra. Ta sa cu uñi quɨvɨ cua nandoto tucu ra. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ta ra apóstol cuan ñá cutuñi iñi ra nusiin sa cahan ra Jesús vatyi tañaha ca cuhva ra Ndyoo sa cutuñi iñi ra sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tacuan ta sa cuñi saa ra Jesús ñuu Jericó, ta yu‑ityi ndyaa minoo ra cuaa, sica ra caridad. ");
INSERT INTO mihNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ta siñi ra cuaa vatyi yaha cuaha xaan ñiyɨvɨ, ta i ndaca tuhun ra ñaa cuenda. ");
INSERT INTO mihNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ta i catyi ñiyɨvɨ sihin ra vatyi cua yaha ra Jesús, ra ñuu Nazaret. ");
INSERT INTO mihNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ta i cana saa ra, ta catyi ra: ¡Yoho Jesús, zehe ra David, cundahvi iñun sii! Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ta ra sa cuahan coyo ityi nuu i catyi ra sihin ra vatyi nacutaxi ra. Zoco ñihi ca i cana saa ra ta catyi ra: ¡Zehe ra David, cundahvi iñun sii! ");
INSERT INTO mihNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ta i sicuɨñɨ ra Jesús yucuan, ta i catyi ra sihin ñiyɨvɨ naquisi ndyaca ñu sii ra. Ta cuhva sa saa ra cuaa nu ndyaa ra Jesús, i ndaca tuhun ra Jesús sii ra ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Ñaa sa cuñun zavehi suhun? Ta i catyi ra cuaa cuan: Cuñi xein sa nandyehi. ");
INSERT INTO mihNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ta i catyi ra Jesús sihin ra: Nandyehe. Sa nduvaha sɨtɨ nuun vatyi sino iñun sii. ");
INSERT INTO mihNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ta zuun ñi caa cuhva cuan i cuu nandyehe ra, ta i sindyico ra sii ra Jesús. Zacahnu xaan ra sii ra Ndyoo. Ta tandɨhɨ ñiyɨvɨ sa ndyehe cuhva cuan, i zacahnu xaan ñu sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","I quɨhvɨ ra Jesús ñuu Jericó, ta cua yaha ra mahñu ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ta ñuu cuan ndyaa minoo ra sa nañi Zaqueo. Cuca xaan ra. Ta ra cu nuu cuu ra sa cuenda ra tava xuhun cuenda ra ndyaca ñaha. ");
INSERT INTO mihNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Cuñi xaan ra ndyehe ra sii ra Jesús yoo ra cuu ra. Zoco ñá cuu ndyehe ra vatyi tyaha xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yucuan cuenda i cacono ra ityi nuu nu cuahan ra Jesús, ta i ndaa ra minoo nu yutu sicómoro sa nandyaa yu‑ityi nu cua yaha ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ta sa saa ra Jesús yucuan i ndyehe ndaa ra, ta i ndyehe ra sii ra. Ta i catyi ra sihin ra: Zaqueo, zanumi ta noon vatyi vityi cua ndoi vehun. ");
INSERT INTO mihNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ta i zanumi ra Zaqueo ta i noo ra. Ta zɨɨ xaan i cuñi ra, ta cuahan ra sihin ra ndya vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ta sa ndyehe ñiyɨvɨ cuhva cuan i quisaha cahan ñu ndya vaha ñi sii ra Jesús ta catyi ñu vatyi cuahan ra Jesús vehe minoo ra iyo cuatyi. ");
INSERT INTO mihNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ta sa ñoho ra vehe ra, i sicuɨñɨ ndyaa ra Zaqueo, ta i catyi ra sihin ra Jesús: Zava ndaha tyiñe cua cuhve sii ñiyɨvɨ ndahvi. Ta tatu i zandavi ñehi ta zuhi xuhun ñiyɨvɨ, cua nacuhve cumi saha sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ta i catyi ra Jesús sihin ra: Vityi sa cacun, ta ñiyɨvɨ ra Abraham cuu suun vatyi sino iñun sii ra Ndyoo tañi i sino iñi ra Abraham. ");
INSERT INTO mihNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ta yuhvi, ra i quisi ndya gloria cui, ta vasi ñuu ñiyɨvɨ vatyi cua nanduqui ta zacaqui sii ñiyɨvɨ sa cua naa. ");
INSERT INTO mihNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ta nɨɨ ñi sa siñi ñiyɨvɨ sa cahan ra Jesús, ta i quisaha cahan tucu ra inga cuhva ya vatyi sa cuñi saa ra ñuu Jerusalén, ta sica iñi ñiyɨvɨ vatyi cua quisaha cundyaca ñaha ra yucuan. ");
INSERT INTO mihNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yucuan cuenda i catyi ra Jesús: Sicoo minoo ra vaha, ta cuñi ra cuhun ra minoo ñuu nusica vatyi yucuan cua nduu ra rey ta zɨquɨ cua ndisi ra ñuu ra zoco sa cuu ra minoo rey. ");
INSERT INTO mihNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ta cumañi ca cuhun ra, i cana ra sii sa usi tahan muzu ra, ta saha ra minoo ziendu peso sii sa minoo minoo ra. Ta i catyi ra sihin ra: “Zatyiño ndo sihin xuhun ya ndya quɨvɨ cua quisi.” ");
INSERT INTO mihNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Zoco ñiyɨvɨ ñuu ra, ñá cuñi ñu sa cuu ra rey sii ñu. Ta sa cuahan ra ityi, i tasi ñu tyiño sihin zuhva ra ta catyi ñu: “Ma cuhva ndi sa cundyaca ñaha ra ya sii ndi.” ");
INSERT INTO mihNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Zoco ra cuan i nduu ra rey, ta zɨquɨ i nasaa ra ndya ñuu ra. Ta sa nasaa ra i cana ra sii muzu ra, ra i zandoo ra xuhun cuan sihin vatyi cuñi ra coto ra yozo i zahacanaa xuhun ra nɨɨ ñi sa sahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ta saa minoo muzu cuan ta catyi ra: “Tata, i zahacanei minoo mil sihin sa minoo ziendu i zandoon sii.” ");
INSERT INTO mihNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ta i catyi rey cuan sihin ra: “Vaha xaan. Minoo muzu vaha cuun. Vaha i zatyiñon sihin sa zuhva ñi xuhun i zandoi suhun. Yucuan cuenda vityi sehi sa cundyaca ñohon usi tahan ñuu.” ");
INSERT INTO mihNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tacuan ta i saa tucu inga ra sa i saha ra xuhun sii. Ta i catyi ra: “Tata, i zahacanei ohon ziendu sihin sa minoo ziendu i zandoon sii.” ");
INSERT INTO mihNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ta i catyi tucu rey cuan sihin ra: “Cuu cundyaca ñaha tucu moo; ohon tahan ñuu cua cundyaca ñohon.” ");
INSERT INTO mihNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tacuan ta i quisi inga ra, ta i catyi ra: “Tata, ica xuhun ya sa minoo ziendu cuan. I sicumi vehi sii si nuu minoo pañitu ");
INSERT INTO mihNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","vatyi yuhi suun vatyi minoo ra xaan cuun, ta tuhvon naquihin sa yɨvɨ suun cuu, ta nacuhun tyiño zacuu inga ra.” ");
INSERT INTO mihNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tacuan ta i catyi rey cuan sihin ra: “Yoho minoo muzu ña vaha cuun. Vityi sihin cuhva cohon ta cua catyi tuqui suhun vatyi siton vatyi xein ta tuhve naquihin sa yɨvɨ sii cuu, ta naquihin tyiño zacuu inga ra. ");
INSERT INTO mihNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yucuan cuenda ¿ñaa cuenda ñá tyuhun xuhin banco, ta sa cua nasei ta cua naquihin sii si, zoco sa zahacanaa si zuhva?” Catyi rey cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ta i catyi ra sihin inga ra yucu yucuan: “Quindyaa ndo xuhun sa sehi sii ra ya, ta cuhva ndo sii si sii ra sa cumi cuaha ca.” ");
INSERT INTO mihNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ta i catyi ra cuan sihin ra: “Zoco sa cumi minoo mil.” ");
INSERT INTO mihNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ta i catyi rey cuan: “Ta catyi sihin ndo vatyi ra zatyiño vaha sihin sa sehi sii ra, cua cuhve cuaha ca sii ra. Ta ra ña cuñi zatyiño sihin sa sehi sii ra, cua quindyei sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ta ñu xaan iñi sii, ñu ña cuñi sa cundyaca ñehi sii ñu, quisi ndyaca ndo sii ñu ihya, ta cahñi ndo sii ñu nui.” Catyi rey cuan i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ta sa yaha cahan ra Jesús cuhva cuan ta cuahan ra ityi nuu ca ndya ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ta cuhva sa cuñi saa ra ñuu Betfagé ta ñuu Betania yatyi ñi minoo yucu sa nañi yucu Olivos, ta i tasi ra sii uu tahan ra apóstol. ");
INSERT INTO mihNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","I catyi ra sihin ra: Cuahan ndo minoo ñuu sa ndyaa yatyi ñi yucuan, ta cuhva sa quɨhvɨ ndo ñuu cuan cua nañihi ndo sii minoo burro nuhñi tɨ. Quɨtɨ ta yoñi ca cozo. Ndasi ndo sii tɨ, ta quisi ndo sihin tɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ta tatu iyo ñiyɨvɨ ndaca tuhun sii ndo ñaa cuenda ndasi ndo sii tɨ, catyi ndo: “Vatyi siñi ñuhu tɨ sii ra ndyaca ñaha sii yo.” ");
INSERT INTO mihNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ta ra apóstol cuan, cuahan ra, ta i nañihi ra sii tɨ tañi cuhva i catyi ra Jesús sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ta cuhva sa cua ndasi ra sii tɨ i catyi sitoho tɨ sihin ra: ¿Ñaa cuenda ndasi ndo burro ña? ");
INSERT INTO mihNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ta i catyi ra cuan: Siñi ñuhu tɨ sii ra ndyaca ñaha sii yo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ta sindyaca ra sii tɨ sii ra Jesús. Ta i tyizo ra zahma ra sata tɨ, ta i tyizo ra sii ra Jesús sata tɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tacuan ta cuahan ra Jesús. Ta i saqui ñiyɨvɨ zahma ñu ityi nu cua yaha ra. ");
INSERT INTO mihNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ta cuhva sa cua cuyatyi ñu ñuu Jerusalén, saa ñu nu iñi noo yucu Olivos cuan. Ta tandɨhɨ cuii ñiyɨvɨ ndyico sii ra Jesús i quisaha cuzɨɨ xaan iñi ñu. Ta saa xaan cana saa ñu, ta zacahnu ñu sii ra Ndyoo sa cuenda sa ndyityi nahnu xaan i ndyehe ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ta i catyi ñu: ¡Nazacahnu yo sii ra cuu rey, ra vasi sa cuenda ra Ndyoo! ¡Nazacahnu xaan yo sii maa ra Ndyoo! ¡Vaha xaan, vaha xaan cuu maa ra Ndyoo! Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tacuan ta zuhva ra fariseo sa cuahan coyo sihin ñiyɨvɨ cuan i quisaha catyi ra: Maestro, zacutaxun sii ñu sica noo suhun. ");
INSERT INTO mihNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Zoco i catyi ra Jesús sihin ra: Catyi sihin ndo vatyi tatu cua cutaxi ñiyɨvɨ ya, cua cana saa yuu. ");
INSERT INTO mihNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tacuan ta sa cuñi saa ra Jesús ñuu Jerusalén, ta cuhva sa ndyehe ra ñuu cuan i sacu xaan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ta i catyi ra: Tatu sa i sito ndo ta cutuñi iñi ndo yozo caa cuu coo sa taxi sii ndo sihin ra Ndyoo, cuu nduvaha ndo. Zoco vityi sa yaha cuhva. Ta sa siñi tuñi cuan, ñoho xehe si sii ndo, ta ma cuu coto ndo sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ta cua quisi quɨvɨ, ta ra xaan iñi sii ndo cua zavaha ra minoo sacu viconduu nu yucu ndo, ta ma cuu quita ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ta ndaha cua zatɨvɨ ra ñuu ndo. Cua cuu tandɨhɨ cuii ndo. Ta ma zandoo ra numinoo yuu zɨquɨ inga si vatyi ña cuñi ndo nacoto ndo sa quisi ra Ndyoo nu ndyaa ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tacuan ta i quɨhvɨ ra Jesús nu cuu nuquehe vehe ñuhu cahnu, ta i quisaha tava ndyizo ra sii ñu xico ta ñu zata yucuan. ");
INSERT INTO mihNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ta i catyi ra sihin ñu: Catyi tutu Tuhun Ndyoo: “Vehe mi cuu vehe nu cahan ñiyɨvɨ sihin ra Ndyoo.” Zoco maa ndo zacuu ndo vehe ra zuhu sii si. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ta tahan tahan quɨvɨ i zacuaha ra Jesús sii ñiyɨvɨ sisi vehe ñuhu. Ta ra zutu nahnu, ta ra maestro cuenda ley ta ra cu tyiño ñuu cuan i nducu ra cuhva yozo caa cuu cahñi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Zoco ñá ñihi ra cuhva yozo caa cua zacuu ra vatyi i tyizoho tandɨhɨ ñiyɨvɨ tandɨhɨ sa cahan ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Minoo quɨvɨ sa quɨvɨ cuan zacuaha ra Jesús sisi vehe ñuhu cahnu, ta nacatyi ra tuhun vaha sihin ñiyɨvɨ. Ta saa coyo ra zutu nahnu ta ra maestro cuenda ley ta ra sahnu ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ta i catyi ra sihin ra Jesús: Nacatyun sihin ndi ¿yoo sa saha tyiño suun vatyi zavohon tandɨhɨ cuhva ya? ");
INSERT INTO mihNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ta i nacahan ra Jesús, ta catyi ra sihin ra: Cuñi tuqui nducu tuhin minoo tuhun sii maa ndo, ta nacatyi ndo sihin. ");
INSERT INTO mihNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Yoo ra i tasi sii ra Juan sa zacoo ndutya ra? ¿Atu i tasi ra Ndyoo sii ra a ñiyɨvɨ? Catyi ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ta i natuhun tahan ra cuan sihin tahan ra ta catyi ra: Tatu catyi yo vatyi i tasi ra Ndyoo sii ra Juan cua catyi ra ya: “¿Ñaa cuenda ñá sino iñi ndo sa cahan ra?” ");
INSERT INTO mihNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Zoco tatu catyi yo vatyi ñiyɨvɨ i tasi sii ra Juan, cua cahñi ñiyɨvɨ sii yo sihin yuu vatyi sica iñi tandɨhɨ maa ñu vatyi maa ra Ndyoo i tasi sii ra Juan ta minoo profeta i cuu ra. Catyi ra cuan sihin tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yucuan cuenda i catyi ra sihin ra Jesús vatyi ña sito ra yoo ra i tasi sii ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ta i catyi ra Jesús sihin ra: Ta ma nacatyi tucu vii yoo ra i saha cuhva ya sii. ");
INSERT INTO mihNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tacuan ta i quisaha cahan ra Jesús sihin ñiyɨvɨ zɨquɨ cuhva ya ta catyi ra: I tasi minoo ra yoho uva minoo sacu. Ta i saha noo ra sii si sii inga ra cua zatyiño ra yucuan, ta cuahan ra nusica naha xaan. ");
INSERT INTO mihNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ta saa quɨvɨ sa iyo yucu vixi cuan, ta i tasi ra sii minoo muzu nu ndyaa ra zatyiño yucuan vatyi cua quihin ra zuhva yucu vixi cuhva tahan si sii patrón ra. Zoco i cañi xaan ra sii muzu cuan. Ta ñahñi sa saha ra sii ra. Ta i natasi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ta i tasi sitoho yoho uva cuan sii inga muzu ra, ta i cañi xaan tucu ra sii ra. Ta quiñi xaan i zavaha ra sihin ra. Ta ñahñi maa i saha ra sii ra, ta i natasi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ta i tasi tucu patrón cuan inga muzu ra, sa cu uñi saha i cuu si. Ta zuun ñi cuhva cuan i zavaha ra sihin ra. I zañicuehe ra sii ra, ta tava ndyizo ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yaha cuan, ta i catyi sitoho sacu cuan: “¿Yozo caa zacui vityi? Cua tasi sii zehi. Cuñi xein sii ra, vazu tyaa ra yahvi sii maa ra vatyi zehi cuu sii ra.” ");
INSERT INTO mihNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Zoco cuhva sa ndyehe ra zatyiño yucuan sii ra, i natuhun tahan ra sihin tahan ra ta catyi ra: “Ihya ra cuu ra cua nañihi ndaha tyiño quɨvɨ cua cuu zutu ra. Nacahñi yo sii ra vatyi ndoo maa yo sihin sacu ya.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ta i tava ndyizo ra sii ra sata sacu, ta i sahñi ra sii ra. Catyi ra Jesús. Ta zɨquɨ i ndaca tuhun ra sii ñiyɨvɨ tyizoho: ¿Yozo caa cua zavaha sitoho sacu cuan sihin ra sahñi sii zehe ra? ");
INSERT INTO mihNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cua quisi ra, ta cua zanaa ra sii ra, ta cua cuhva noo ra sacu cuan sii inga ra. Catyi ra Jesús. Ta sa siñi ñiyɨvɨ tuhun cuan ta catyi ñu: Zoco ma zavaha ra Ndyoo cuhva cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ta i nandyehe ra Jesús sii ñu, ta catyi ra: Tatu tacuan sica iñi ndo ¿ñaa cuñi si catyi si cuñi maa ndo nu catyi si tyehen? “I zavita ihno ñiyɨvɨ zandaa vehe sii yuu sa cuñi si sa cuenda sɨquɨ vehe. Ta vityi yuu cuan cuu sa ñiñi ca ta zɨquɨ tandɨhɨ sa cuenda vehe cuan vatyi tacuan catyi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ta yoo ra cua nduva zɨquɨ yuu cuan cua tahnu cuatyi ra, zoco yoo ra cua canacava yuu cuan zɨquɨ, cua caxi cuatyi si sii ra ndyihi ndyihi.” ");
INSERT INTO mihNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ta ra zutu nahnu ta ra maestro cuenda ley i nducu ra cuhva zuun ñi cuhva cuan sa tɨɨn ra sii ra Jesús vatyi tuu iñi ra vatyi i cahan ra Jesús cuhva iyo maa ra. Zoco i yuhu ra sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yucuan cuenda i tasi ra sii zuhva ra cua nducu coto ihñi sii ra Jesús. Cua zaha ra cuan tuhun vatyi ra vaha cuu ra, zoco cua nducu ra cuhva ñaa minoo tuhun ña vaha cua cahan ra Jesús, ta cua ñihi ra cuhva tyaa ra cuatyi sata ra nuu ra cu gobernador. ");
INSERT INTO mihNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yucuan cuenda i catyi ra tyehen sihin ra Jesús: Maestro, sito ndi vatyi ndoo xaan cohon, ta ndoo xaan cuhva zacuohon. Ña tyaa con yahvi sii minoo ñiyɨvɨ ta zɨquɨ sii inga ñu zoco zacuohon ityi ra Ndyoo sa ndisa cuii. ");
INSERT INTO mihNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yucuan cuenda cuñi ndi coto ndi: ¿Atu vaha tyiyahvi yo xuhun sii ra ndyaca ñaha a ña vaha? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Zoco i tuu iñi ra Jesús vatyi ña vaha añima ra cuan, ta i catyi ra sihin ra: ¿Ñaa cuenda nducu coto ihñi ndo sii? ");
INSERT INTO mihNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Zañaha ndo minoo xuhun sii. ¿Yoo sii nuu ndyaa ya? ¿Ta yoo sii zɨvɨ ndyaa ya? Ta i nacahan ra cuan ta catyi ra: Sii ra gobierno César. ");
INSERT INTO mihNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ta i catyi ra Jesús sihin ra: Cuhva ndo sii ra gobierno César sa cuu sii maa ra. Ta cuhva ndo sii ra Ndyoo sa cuu sii maa ra Ndyoo. I catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ta ñá cuu maa zandavi ñaha ra cuan sii ra Jesús sihin tuhun cahan ra nuu ñiyɨvɨ. Ta iyo xaan i cuñi ra cuhva i cahan ra Jesús, ta i cutaxi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yaha cuan ta zɨquɨ i saa coyo zuhva ra saduceo nu ndyaa ra Jesús. Catyi ra saduceo cuan vatyi ma nandoto ñiyɨvɨ tatu sa sihi ñu. Ta i ndaca tuhun ra cuan sii ra Jesús cuhva ya: ");
INSERT INTO mihNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Maestro, i tyaa ra Moisés minoo ley vatyi tatu sihi minoo rayɨɨ ta ndoo ndahvi ñazɨhɨ ra ta yoñi zehe ra i sicoo, natindaha yañi ra sihin ñaha cuan. Ta cua coo zehe ra sihin ña sa cuenda yañi ra, ra i sihi cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sicoo usa tahan rayɨɨ sihin yañi ra. I tindaha ra nuu. Ta i sihi ra, ta yoñi zehe ra i sicoo. ");
INSERT INTO mihNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ta zɨquɨ i tindaha ra cu uu sihin ñandahvi cuan. Sihi tucu ra cuan. Ta yoñi zehe ra i sicoo. ");
INSERT INTO mihNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","I tindaha tucu ra cu uñi sihin ña. Ta tacuan tucu cuahan tyiño ndya i tindaha tandɨhɨ sa usa tahan ra sihin ña. Ta i sihi tandɨhɨ sa usa tahan ra, ta yoñi zehe ra i sicoo. ");
INSERT INTO mihNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ta nu ndɨhɨ tuhun i sihi ndɨhɨ tucu maa ñaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yucuan cuenda cuñi ndi coto ndi ¿yoo ra cua cuu yɨɨ ña quɨvɨ cua nandoto ñiyɨvɨ? vatyi ñazɨhɨ tandɨhɨ sa usa tahan ra i cuu sii ña. Tacuan i catyi ra cuan sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ta i catyi ra Jesús sihin ra: Ihya ñuu ñiyɨvɨ tindaha rayɨɨ ta ñu zɨhɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Zoco ñiyɨvɨ cua nandoto inga ñuu ñiyɨvɨ saa nu ndyaca ñaha ra Ndyoo, ma tindaha ca ñu indyacuan. ");
INSERT INTO mihNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ta ma cuu ca ñu vatyi sa nduu ñu tañi ángel. Ta zehe ra Ndyoo cuu sii ñu sa ndisa cuii vatyi cua nandoto ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Sa ndisa cuu si vatyi nandoto ñiyɨvɨ vatyi i zandoo ra Moisés tuhun cuan nu tutu i tyaa ra. Vatyi quɨvɨ i cahan ra Ndyoo sihin ra nu cayu taca iñu cuan zoco ñá ndɨhɨ si, i cahan ra Moisés cuhva ya sihin ra Ndyoo ta catyi ra: “Zutu mañi yuu, Ndyoo cuun sii ra Abraham ta sii ra Isaac ta sii ra Jacob.” (Tacuan i catyi ra Moisés vatyi sito ra vatyi ndito ra Abraham sihin tandɨhɨ zehe ra vazu sa sihi coño ñuhu ra.) ");
INSERT INTO mihNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Vatyi yɨvɨ Ndyoo sii ñiyɨvɨ ndaha sihi cuii cuu ra Ndyoo. Ndyoo cuu ra sii ñiyɨvɨ cua cundito tandɨhɨ cuii tyiemvu. Ta ndito añima ñiyɨvɨ sa cuenda maa ra Ndyoo. Ña sihi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tacuan ta i cahan zuhva ra maestro cuenda ley ta catyi ra: Vaha xaan tuhun cohon, Maestro. ");
INSERT INTO mihNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ta yaha cuan ta ñá caña ca iñi ra ndaca tuhun ra numinoo ca tuhun sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tacuan ta i catyi ra Jesús: Catyi ra maestro cuenda ley vatyi ra Cristo cuu ñiyɨvɨ sii ra rey David, ta ndisa cuu si cuhva cahan ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Zoco zuun ñi maa ra rey David i cahan ta sa naha tuhun i saha ra Ndyoo sii ra, ta i tyaa ra cuhva cahan ra Ndyoo sihin ra Cristo. Tyehen i tyaa ra David: Cahan ra Ndyoo sihin ra ndyaca ñaha sii mi ta catyi ra: “Cundyoon siyo cuehi ");
INSERT INTO mihNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ndya cuhva ndya cua saa quɨvɨ cua cuhve cuhva cua zahacanoon sii ñiyɨvɨ xaan iñi suun.” Tacuan i tyaa ra David. ");
INSERT INTO mihNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Ta yozo caa vatyi catyi ra maestro cuenda ley vatyi ñiyɨvɨ ra David cuu sii ra Cristo ta zuun ñi maa ra David catyi vatyi ndyaca ñaha ra Cristo sii ra? Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ta cuhva i tyizoho tandɨhɨ ñiyɨvɨ i catyi ra Jesús sihin ñiyɨvɨ sica noo sihin ra: ");
INSERT INTO mihNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Zacuenda vaha ndo sii ndo, ta ma zacuu ndo cuhva zacuu ra maestro cuenda ley. Tahan xaan iñi ra quɨhɨ ra zahma nañi vatyi cua nacoto ñiyɨvɨ sii ra vatyi ra ñiñi cuu ra. Ta cuhun ra nuyahvi vatyi cuñi xaan ra sa tyaa ñiyɨvɨ yahvi sii ra. Ta cuñi xaan ra sa cundyaa ra nu ndyaa ñiyɨvɨ ñiñi sisi vehe ñuhu. Ta cuñi xaan ra sa cundyaa ra tyayu vaha nu sasi ñiyɨvɨ zacahnu vico. ");
INSERT INTO mihNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Cuaha ca cua cutuñi ra maestro cuenda ley ta zɨquɨ inga ñiyɨvɨ vatyi zuhu ra ndaha tyiño ñundahvi. Ta zandavi ñaha ra sii ñiyɨvɨ vatyi naha xaan sica tahvi ra sii Ndyoo vatyi cuñi ra sa cua ndyehe ñiyɨvɨ ta cua catyi ñu vatyi sito xaan ra sii Ndyoo. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","I ndyehe ra Jesús vatyi tyihi ra cuca xuhun sisi minoo satu sisi vehe ñuhu cahnu. ");
INSERT INTO mihNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ta i ndyehe tucu ra sii minoo ñaha ndahvi. Tyihi ña uu tahan xuhun ndyihi sa cu ohon zendavu sisi satu cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ta i catyi ra Jesús: Ndisa cuii catyi sihin ndo vatyi i tyihi ñandahvi cuan cuaha ca xuhun ta zɨquɨ tandɨhɨ ca ra cuca. ");
INSERT INTO mihNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Saha maa ra sa nandoo ñi ca sii ra. Zoco ñandahvi cuan, ndɨhɨ i saha ñi ca ña xuhun cuita casi ña. ");
INSERT INTO mihNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tacuan ta zuhva ñu i natuhun ñu tuhun vehe ñuhu cahnu cuan. Catyi ñu vatyi tyaqui xaan yuu i sino si. Ta tyaqui xaan sa tacaa sa saha maa ñiyɨvɨ, ndɨhɨ ca. Tacuan ta i catyi ra Jesús: ");
INSERT INTO mihNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Cua coo quɨvɨ ta tandɨhɨ sa ndyehe ndo ihya cua tani si. Numinoo yuu ya ta ma ndoo si zɨquɨ tahan si. Cua nacoyo tandɨhɨ si. ");
INSERT INTO mihNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ta i ndaca tuhun ra sii ra Jesús ta catyi ra: Maestro, ¿ama cua coo cuhva cuan? ¿Ñaa zeña cua ndyehe ndi, ta zɨquɨ cua coto ndi vatyi sa cua tahan si? ");
INSERT INTO mihNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ta i catyi ra Jesús: Zacuenda ndo sii ndo coto zandavi ñaha ñiyɨvɨ sii ndo. Vatyi cuaha xaan ra cua quisi ta cua catyi ra: “Yuhvi cui Cristo, ta sa cuñi naa ñiyɨvɨ.” Cua catyi ra. Zoco ma sino iñi ndo sii ra, ta ma cundyico ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ta cua cuɨñɨ ndo tuhun vatyi cua coo cuatyi ta cahñi tahan xaan ñiyɨvɨ, zoco ma yuhu ndo. Xihna ca cua cuu tandɨhɨ cuhva cuan, cumañi ca sa saa quɨvɨ naa ñiyɨvɨ. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ta catyi tucu ra: Cua cahñi tahan minoo ñuu sihin inga ñuu, ta cua coo cuatyi ñuu nahnu sihin inga ñuu nahnu. ");
INSERT INTO mihNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ta cua coo sa taan ñihi xaan zɨɨn zɨɨn ityi. Ta cua coo cuehe tandɨhɨ ityi. Ta cua coo tama. Ta cua coo sa zayuhu xaan sii ñiyɨvɨ. Ta cua coo cuaha xaan zeña andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Zoco cumañi ca sa cuu tandɨhɨ cuhva cuan, cua cuxaan xaan ñiyɨvɨ ndyehe ñu sii ndo. Cua zayanga xaan ñu sii ndo, ta cua tɨɨn ñu sii ndo vatyi caca ñu cuatyi saha ndo sisi vehe ñuhu. Ta cua tyihi ñu sii ndo vehe caa. Ta cua cuhva maa ndo sa ndaa sa cuenda mi ityi nuu ra cu rey ta ra cu tyiño. ");
INSERT INTO mihNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ta cua cuu cahan ndo sa cuenda mi. ");
INSERT INTO mihNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Zoco zaha ndo cuenda, ta ma caca iñi ndo ñaa sa cua cahan ndo nuu ra cu tyiño cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Vatyi yuhvi cua cuhve tuhun cahan ndo, ta cua cuhve sa siñi tuñi xiñi ndo. Ta numinoo ra xaan iñi sii ndo ta ma cuu zahacanaa ra sii ndo sihin tuhun cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Zoco zuun ñi ñiyɨvɨ sii ndo cua xico tuhun sii ndo, zutu ndo ta zɨhɨ ndo, ta tahan ndo ta ra tahan ndo, ta amigo ndo. Cua cuhva ñu sii ndo sii ñu xaan iñi sii ndo. Ta cua cahñi ñu sii zuhva ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tandɨhɨ ñiyɨvɨ cua cuxaan xaan ñu ndyehe ñu sii ndo sa cuenda mi. ");
INSERT INTO mihNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Zoco ma cunaa numinoo ixi xiñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ta tatu ma ndu‑uu iñi ndo, cua cundito ndo tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ta quɨvɨ cua ndyehe ndo vatyi yucu zandaru siconduu ñuu Jerusalén ya, cua coto ndo vatyi sa cuñi saa quɨvɨ cunaa ñuu ya. ");
INSERT INTO mihNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tacuan ta ñiyɨvɨ ndyaa nacahnu Judea, nacono ñu ta naquɨhvɨ xehe ñu ndya yucu. Ta ñu yucu sisi cuhu, ma cunuhu ñu ndya ñuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Vatyi quɨvɨ cuan cua tasi tuñi ra Ndyoo sii ñiyɨvɨ ñuu ya. Ta tacuan ta cua cuu si tandɨhɨ cuhva catyi tutu ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Zoco cuaha xaan tundoho cua ndyehe ñu zɨhɨ, ñu ñoho zehe, quɨvɨ cuan a tatu iyo zehe ñu sa tyaxi quɨvɨ cuan vatyi cahnu xaan tundoho cua coo quɨvɨ cuan vatyi cua cuxaan xaan ra Ndyoo sihin ñiyɨvɨ ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Cua cahñi zandaru sii ñiyɨvɨ sihin mityi ra, ta inga ñiyɨvɨ cua tɨɨn ra ta cundyaca ra sii ñu zɨɨn zɨɨn ñuu. Ta ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu, cua cuyucu ñu ñuu Jerusalén ndya quɨvɨ cua catyi maa ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ta cuaha sa iyo cua ndyehe ñiyɨvɨ nu ñicandyi ta nu yoo ta cuhva iyo tiñoo. Ta cua yuhu xaan ñiyɨvɨ ñuu ñiyɨvɨ ya cuhva cua ndaa noo xaan tyañuhu. ");
INSERT INTO mihNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yaha xaan yaha xaan cua yuhu ñiyɨvɨ sihin sa sica xaan iñi ñu sa cuenda sa iyo sa cua cuu ñuu ñiyɨvɨ. Ta tandɨhɨ sa iyo andɨvɨ cua canda si. ");
INSERT INTO mihNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tacuan ta zɨquɨ cua ndyehe ñiyɨvɨ sii ra i quisi ndya gloria. Cua quisi tucu ra sihin vico ta sihin cuaha xaan cuhva. Ta tyaqui xaan caa ra. ");
INSERT INTO mihNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ta tatu sa quisaha cuu tandɨhɨ cuhva ya, zɨɨ xaan cuñi ndo vatyi sa yatyi cuii cua cacu ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tacuan i catyi ra Jesús, ta zɨquɨ i cahan ra zɨquɨ minoo cuhva ya ta catyi ra: Ndyehe ndo cuhva iyo yutu higuera ta tandɨhɨ inga yutu. ");
INSERT INTO mihNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tatu cua ndyehe ndo sa cua nacoyo ndaha tu ta cua nduyutya tu, tacuan ta sa sito ndo vatyi sa cua nducahñi. ");
INSERT INTO mihNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ta tacuan tucu tatu sa ndyehe ndo vatyi sa cuu tandɨhɨ tuhun sa quehin sihin ndo ihya, tacuan ta cua coto ndo vatyi sa cua cuyatyi cundyaca ñaha ra Ndyoo ñuu ñiyɨvɨ ya. ");
INSERT INTO mihNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sa ndisa catyi sihin ndo vatyi cua cuu cuhva ya cuee ca sa cuu ñiyɨvɨ sa iyo vityi. ");
INSERT INTO mihNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yutyi andɨvɨ ta ñuhu ñuu ñiyɨvɨ cunaa si. Zoco tuhun quehin ma naa si. ");
INSERT INTO mihNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Coto vaha ndo sii ndo coto ñáha zandava ndo iñi ndo sa cuenda cuatyi zavaha ndo tañi sa zavaha xaan ndo vico ta sihi xaan ndo ndixi ta sica xaan iñi ndo tuhun sa iyo ñuu ñiyɨvɨ. Tatu tacuan iyo ndo ta ña ndatu listo ndo, zana ñi iñi ndo ta cua quisi tundoho zɨquɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Vatyi tacuan cua cuu si sihin tandɨhɨ ñiyɨvɨ ñuu ñiyɨvɨ. Zana ñi iñi ñu, ta cua cuu si tañi minoo sa nacazi ra Ndyoo nu ñoho ñu, ta ma cuu ca quita ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yucuan cuenda cuatu listo ndo, ta caca xaan ndo sii ra Ndyoo tandɨhɨ quɨvɨ vatyi cua cuhva ra sa ma ndyehe ndo tundoho cahnu xaan sa cua coo. Ta caca ndo sii ra vatyi cuhva ra sa cua saa vaha ndo ityi nuu ra i quisi ndya gloria. Tacuan i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ora i zacuaha ra Jesús sii ñiyɨvɨ sisi vehe ñuhu cahnu ta sa sa cuaa tuhva ra sahan ndya yucu sa nañi Olivos. ");
INSERT INTO mihNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ta tahan ñaha ñi saa coyo ñiyɨvɨ vehe ñuhu vatyi cuñi ñu tyizoho ñu sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sa cuñi tahan si vico sihi mvee ticatyi. Quɨvɨ sasi ñiyɨvɨ pan ña ndaa. Pascua nañi vico cuan. Ta catyi maa yo vico zuhun. ");
INSERT INTO mihNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ta ra zutu nahnu sihin ra maestro cuenda ley, sa nducu ra cuhva yozo caa cuu cahñi ra sii ra Jesús, zoco yuhu ra sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tacuan ta i quɨhvɨ cuihna sii ra Judas Iscariote. Ta minoo sa usi uu tahan ra i casi ra Jesús cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ta cuahan ra cua cahan ra sihin ra zutu nahnu ta ra cu nuu sii ra zacuenda vehe ñuhu cahnu. Natuhun tahan ra yozo caa cua xico ra Judas sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ta zɨɨ xaan i cuñi ra cuan ta i zandaa ra tyiño vatyi cua cuhva ra xuhun sii ra Judas. ");
INSERT INTO mihNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ta i ndoo ra Judas vaha, ta i quisaha nducu ra cuhva yozo caa cua cuhva cuenda ra sii ra Jesús sii ra cuan cuhva sa yoñi ñiyɨvɨ yucu sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ta sa saa quɨvɨ tuhva ñu hebreo sasi pan ña ndaa, quɨvɨ sa tahan si cahñi ñu sii minoo mvee ticatyi. ");
INSERT INTO mihNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ta i tasi ra Jesús sii ra Pedro ta ra Juan sihin minoo tyiño, ta catyi ra sihin ra: Cuahan ndo cua zanduvaha ndo minoo mvee ticatyi vatyi cua cuxiñi yo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ta i ndaca tuhun ra sii ra Jesús ta catyi ra: ¿Ndyamaa cuñun sa zanduvaha ndi sa cuxiñi yo? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ta i catyi ra Jesús sihin ra: Cuahan ndo sisi ñuu. Ta yucuan cua ndyehe ndo sii minoo ra ndyizo ra minoo quɨyɨ ndutya. Cundyico ndo sii ra, ta quɨhvɨ ndo vehe nu cua quɨhvɨ maa ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ta catyi ndo sihin sitoho vehe cuan: “Catyi ra Maestro: ¿ndyamaa ndyaa cuarto nu cua cuxiñi sa cuenda vico ya sihin ra i casi?” Tacuan catyi ndo sihin ra catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ta cua zañaha ra minoo cuarto cahnu ndya zɨquɨ. Sa yaha nduvii si. Yucuan zanduvaha ndo sa cuxiñi yo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tacuan catyi ra Jesús sihin ra. Ta cuahan ra, ta i nañihi ra cuarto cuan tañi cuhva i catyi ra Jesús. Ta i zanduvaha ra sa cuxiñi ra sa cuenda vico zuhun cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ta sa saa cuhva ta i sicundyaa ra Jesús yumesa sihin sa usi uu tahan ra i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tacuan ta i catyi ra Jesús sihin ra: Cuñi xein cuxiñi sihin ndo sisi vico zuhun ya cuee ca sa ndyehi tundoho. ");
INSERT INTO mihNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ta catyi sihin ndo vatyi ma casi que inga saha sihin ndo sa cuenda vico ya ndya cua cuu si inga saha nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tacuan ta i quihin ra minoo vaso ñoho vino, ta i saha ra tyahvi ndyoo sii ra Ndyoo, ta i catyi ra: Quihin ndo vaso ya, ta coho minoo minoo ndo zuhva zuhva. ");
INSERT INTO mihNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Vatyi catyi sihin ndo vatyi ma coho que vino ndya cua cundyaca ñaha ra Ndyoo sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tacuan ta i quihin ra pan. Ta i saha ra tyahvi ndyoo sii ra Ndyoo, ta i sahnu ra sii si, ta i saha ra sii si sii ra. Ta i catyi ra: Ihya cuu tañi coño ñuhi sa cua cuhve sa cuenda maa ndo. Zavaha ndo cuhva ya vatyi nacohon iñi ndo sii. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ta sa yaha cuxiñi ra i quihin ra minoo vaso vino, ta i catyi ra: Ihya cuu tañi nɨñi. Cua cati si sa cuenda maa ndo. Vityi zandaa ra Ndyoo minoo tyiño saa. Cua zandasi ra cuatyi ñiyɨvɨ sihin nɨñi. ");
INSERT INTO mihNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Zoco vityi ra sa xico sii, ɨɨn ñi ndyaa ra mesa ya sihin. ");
INSERT INTO mihNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ta ndisa vatyi ra i quisi ndya gloria cua cuu tandɨhɨ sii ra tañi sa ndyaa cuu sii ra, zoco ¡ndahvi ñi cuu ra xico sii! Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tacuan ta i quisaha nducu tuhun tahan ra i casi ra sii ra tahan ra, ndya ra cuu ra zacuu cuhva cahan ra Jesús tuhun. ");
INSERT INTO mihNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yaha cuan ta i quisaha natuhun tahan xaan ra i casi ra Jesús sa cuenda ndya ra cuu ra ñiñi ca nu yucu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ta i catyi ra Jesús sihin ra: Ra cu rey sii ñiyɨvɨ ñuu ñiyɨvɨ ya cuñi ra vatyi zacahnu ñiyɨvɨ sii ra. Ta cuñi ra vatyi catyi ñiyɨvɨ vatyi tyindyee ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Zoco ña tacuan cua cuu si sa cuenda maa ndo. Tatu cuñi ndo cuu ndo ra cu nuu, zanduluhlu ndo sii ndo. Ta ra cuñi cundyaca ñaha sii inga ndo, cuñi si sa cuu ra muzu sii tandɨhɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ihya ñuu ñiyɨvɨ, ra ñiñi ca cuu ra ña zatyiño. Ndyaa ra yumesa ra, ta tyizo muzu ra coho nu mesa. Zoco ña tacuan zavaha mi vatyi zatyiñe tañi muzu cui sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ta maa ndo cuu ra i sindyaa sihin sisi quɨvɨ ña vaha ya nu ndyehe xein tundoho. ");
INSERT INTO mihNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yucuan cuenda cua cuhve minoo nu cua cundyaca ñaha ndo tañi cua cuhva Zuti minoo nu cua cundyaca ñehi. ");
INSERT INTO mihNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ta cua cuhve sa cua casi ndo ta cua coho ndo numesa sihin mi nu cua cundyaca ñehi. Ta cua tyicuhva ndo sii sa usi uu tahan ityi ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tacuan ta i catyi ra Jesús sihin ra Pedro: Ndyehe vohon yoho Simón vatyi cuñi ra cu nuu sii cuihna suun vatyi cuñi ra nducu coto ihñi ra suun. ");
INSERT INTO mihNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Zoco i cahan xein sihin ra Ndyoo sa cuendon vatyi ma naa sa sino iñun sii ra Ndyoo. Ta quɨvɨ cua ndu‑uu iñun cuatyun, zandundyee con iñi ra tohon. ");
INSERT INTO mihNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ta i catyi ra Simón sihin ra: Tata, sa ndyaa listi sa cuhin suhun vazu ndya vehe caa ta vazu cui suhun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ta i catyi ra Jesús sihin ra: Catyi suhun yoho Pedro vatyi cumañi ca sa vacu saa ndɨvɨ tyahnu sa cuaa vityi ta cua catyun uñi tahan saha vatyi ña siton sii. ");
INSERT INTO mihNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tacuan ta i ndaca tuhun ra Jesús sii ra i casi ra ta catyi ra: Nacohon iñi ndo quɨvɨ i tasi sii ndo sa nacatyi ndo tuhin sihin ñiyɨvɨ ta ñahñi sindyizo ndo, nu xuhun ta nu sa casi ndo ta nu inga zahma ndo. ¿Atu i cumañi si sii ndo quɨvɨ cuan? Ta i nacahan ra cuan ta catyi ra: Ñahñi i cumañi sii ndi. ");
INSERT INTO mihNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ta zɨquɨ i catyi ra Jesús sihin ra: Zoco vityi tatu iyo xuhun ndo a sa casi ndo a zahma ndo, cuizo ndo sii si. Ta tatu ñahñi mityi ndo, xico ndo minoo zahma ndo ta zata ndo minoo si. ");
INSERT INTO mihNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Vatyi catyi sihin ndo vatyi cuhva ndyaa si nu tutu ra Ndyoo sa cuenda mi, sa cuñi tahan si cuhva catyi si: “Cua tasi tuñi ñiyɨvɨ sii ra tañi ra iyo cuatyi.” Tacuan catyi si, ta cua cuu tandɨhɨ cuhva ndyaa si. ");
INSERT INTO mihNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ta i catyi ra cuan sihin ra Jesús: Tata, cumi yo uu tahan mityi. Ta i catyi ra Jesús sihin ra: Maa vatu ñi. ");
INSERT INTO mihNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","I quita ra Jesús vehe cuan ta cuahan ra ndya yucu Olivos tañi tuhva maa ra sahan. Ta cuahan tucu ra i casi ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ta cuhva sa saa ra yucuan i catyi ra sihin ra i casi ra: Caca tahvi ndo sii maa ra Ndyoo vatyi ma cuhva ra sa nducu coto ihñi cuihna sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tacuan ta cuahan ra Jesús zuhva ca maa ñi maa ra. Tañi cuhva zavita yo minoo yuu, tacuan ñi cuu cuhva cuahan ra. Ta yucuan i sicuɨñɨ sɨtɨ ra, ta i cahan ra sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ta i catyi ra sihin ra Ndyoo: Ndyoo Zuti, tatu cuhva cuñi moo cuu, cuhvon sa ma ndyehi tundoho ya. Zoco ma cuhvon tañi cuhva cuñi mi. Nacuu si tañi cuhva cuñi moo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tacuan ta i quituu minoo ángel nu ndyaa ra, ta saha ca si tundyee iñi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Cuaha xaan tundoho ndyehe ra Jesús vatyi cuihya xaan cuñi ra, ta ñihi ca sica tahvi ra sii ra Ndyoo. Ta cuaha xaan tyeen ra i quita tañi toon nɨñɨ nu ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ta sa nduvita ra sa ndɨhɨ cahan ra sihin ra Ndyoo ta sahan ra nu yucu ra ndɨhɨ sihin ra, ta nañihi ra sii ra quixi ra vatyi cuihya xaan cuñi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ta i catyi ra sihin ra: ¿Ñacu quixi xaan ndo? Nduvita ndo ta cahan ndo sihin ra Ndyoo coto nducu coto ihñi cuihna sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nu cahan ca ra Jesús ta i saa ra Judas, minoo sa usi uu tahan ra i casi ra Jesús cuu ra. Ta i saa cuaha xaan ñiyɨvɨ sihin ra. I tuhva ra Judas sii ra Jesús vatyi cua coho ra xɨtɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ta i catyi ra Jesús sihin ra: Judas, ¿atu sihin sa cohon xɨti cua nacuhva cuendon sii ra i quisi ndya gloria? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ndyehe ra yucu sihin ra Jesús cuhva sa cuu, ta ndaca tuhun ra sii ra: Tata, ¿atu cañi ndi sii ra sihin mityi? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ta minoo ra cuan i sahndya ra zoho minoo ra cu muzu ra cu zutu ya cahnu, siyo cuaha. ");
INSERT INTO mihNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Zoco i catyi ra Jesús sihin ra: Zaña ndo. Vaha ñi. Catyi ra. Ta i naquihin ra Jesús zoho ra cuan ta natyaa ra. Ta i zanduvaha ra zoho ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tacuan ta i catyi ra Jesús sihin ra zutu nahnu, ta ra cu policía cuenda vehe ñuhu ta ra mandoñi: ¿Atu vasi tɨɨn ndo sii minoo ra zuhu vatyi ñaa ndo mityi ta ndaha tyiño xaan? ");
INSERT INTO mihNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tahan tahan quɨvɨ i sehin vehe ñuhu cahnu ta yucu ndo, zoco ñá tɨɨn ndo sii yucuan. Vityi cuu cuhva ndyaca ñaha ra ña vaha, ta yucuan cuenda vityi cua tɨɨn ndo sii. ");
INSERT INTO mihNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tacuan i tɨɨn ra sii ra Jesús, ta i sindyaca ra sii ra ndya vehe ra cu nuu sii ra cu zutu. Ta i sindyico ra Pedro sii ra sica sica ñi. ");
INSERT INTO mihNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ta cuhva sa saa coyo ra yucuan i zatahan ra ñuhu nuquehe ta sicundyaa ra, ta i sicundyaa ra Pedro mahñu. ");
INSERT INTO mihNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ta cuhva sa ndyaa ra Pedro yunuhu ta i ndyehe minoo ña cu muzu sii ra, ta nacoto ña sii ra, ta catyi ña: Ra ihya, ra tahan ra cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Zoco i catyi ra Pedro: Maha, ña site sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ta i yaha zuhva cuhva, ta i ndyehe tucu inga ra sii ra Pedro, ta catyi ra: Yoho tucu, ra tahan oo cuu sii ra. Ta i catyi ra Pedro sihin ra: Yɨvɨ yuhvi, tata. ");
INSERT INTO mihNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ta i yaha tañi minoo ora, ta i catyi tucu inga ra: Ndisa cuii vatyi ra ihya cuu tucu minoo ra tahan ra vatyi zuun ñi ra Galilea cuu tucu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ta i catyi ra Pedro sihin ra: Tata, ña site ñaa tuhun cohon. Catyi ra. Ta zuun ñi caa cuhva sa cahan ra Pedro, ta i sacu saa minoo ndɨvɨ tyahnu. ");
INSERT INTO mihNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tacuan ta i nasico cava ra Jesús, ta i nandyehe ra sii ra Pedro. Ta i nacohon iñi ra Pedro cuhva sa i catyi ra Jesús sihin ra: “Cumañi ca vacu saa ndɨvɨ tyahnu, cua catyun uñi tahan saha vatyi ña siton sii.” ");
INSERT INTO mihNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ta cuhva cuan i quita ra Pedro, ta i sacu xaan ra vatyi i nducuihya xaan iñi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tacuan ta ra i sicumi sii ra Jesús i quisaha sacu ndyaa ra sii ra, ta i cañi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","I sihñi ra minoo zahma nuu ra, ta zɨquɨ i cati ra nuu ra ta catyi ra: Nacoton yoo ra i cañi suun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ta cuaha xaan inga sa quiñi i cahan ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ta cuhva sa cundisi i titahan ra mandoñi sihin ra zutu nahnu sihin ra maestro cuenda ley. Ta i quihin ra sii ra Jesús, ta sindyaca ra sii ra nu cuu junta cahnu cuenda tandɨhɨ ra ñiñi hebreo. Ta i catyi ra sihin ra: ");
INSERT INTO mihNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nacatyun sihin ndi ¿atu ra Cristo cuun, ra cua zacacu sii ndi? Ta i catyi ra Jesús sihin ra: Tatu catyi sihin ndo vatyi zuun ra cui, ma sino iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A tatu ndaca tuhin ñaa minoo cuhva sii maa ndo, ma nacahan ndo. Ta zuun ñi sa ma zaña ndo sii. ");
INSERT INTO mihNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Zoco ndya vityi cua cundyaa ra i quisi ndya gloria siyo cuaha ra Ndyoo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tacuan ta i ndaca tuhun tandɨhɨ ra sii ra Jesús ta catyi ra: ¿Zɨquɨ zehe ra Ndyoo cuu suun? Ta i catyi ra Jesús sihin ra: Zuun cui tañi catyi maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tacuan ta i catyi ra cuan sihin tahan ra: Xihna sa cahan ra. Ñahñi ca sa ndaa cuñi si vityi. Zuun ñi maa yo i siñi sa cahan ra sihin yuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","I nduvita tandɨhɨ ra xaan iñi sii ra Jesús, ta i sindyaca ra sii ra nu ndyaa ra Pilato, ra cu governador. ");
INSERT INTO mihNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ta i quisaha tyaa ra cuatyi sata ra Jesús nuu ra Pilato ta catyi ra: Ra ihya, zatɨvɨ xaan ra sii ñiyɨvɨ sihin tuhun cahan ra nuu ñu. Ta catyi ra vatyi ña vaha sa tyiyahvi ndi xuhun sii ra ndyaca ñaha. Ta catyi ra vatyi Cristo cuu ra, minoo ra cu rey. Tacuan i nacatyi tandɨhɨ ra cuan sihin ra Pilato. ");
INSERT INTO mihNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ta zɨquɨ i ndaca tuhun ra Pilato sii ra Jesús: ¿Atu yoho cuu rey cuenda ñiyɨvɨ hebreo? Ta i catyi ra Jesús: Tacuan cu si tañi catyi moo. ");
INSERT INTO mihNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tacuan ta i catyi ra Pilato sihin ra zutu nahnu ta sihin inga ñiyɨvɨ: Ñahñi cuatyi ra ya iyo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Zoco i nduxaan ca ñiyɨvɨ ta i catyi ñu: Cahnu xaan cuatyi ra ya. Cuaha xaan tizɨhɨ saha ra vatyi zacuaha ra sii ñiyɨvɨ ta zanandɨquɨ ra sii ñu ndya Galilea ta ndya ihya. ");
INSERT INTO mihNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cuhva sa siñi ra Pilato tuhun cuan ta i ndaca tuhun ra tatu ra Galilea cuu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ta sa sito ra vatyi zuun ra cuu ra, ta zɨquɨ i zacuhun ra sii ra nu ndyaa ra Herodes vatyi ra Herodes i cuu gobernador nacahnu Galilea. Ta quɨvɨ cuan ñoho ra Herodes ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ta zɨɨ xaan i cuñi ra Herodes sa ndyehe ra sii ra Jesús vatyi sa naha xaan cuñi ra ndyehe ra sii ra. Sa siñi xaan ra Herodes tuhun ra Jesús, ta cuñi ra ndyehe ra sa zavaha ra Jesús minoo sa ndyityi. ");
INSERT INTO mihNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Cuaha xaan cuhva i ndaca tuhun ra sii ra Jesús, zoco ñá nacahan maa ra Jesús sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ta yucu tucu ra zutu nahnu ta ra maestro cuenda ley cuhva cuan, ta i tyaa xaan ra cuatyi sata ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ta ra Herodes sihin zandaru ra, i sacu ndyaa ra sii ra Jesús. Ta i natyihi ra minoo zahma yahvi xaan sii ra, ta tyaqui xaan si tañi sa sityiño minoo rey, ta i natasi ra Herodes sii ra nu ndyaa ra Pilato. ");
INSERT INTO mihNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ta quɨvɨ cuan i nduu amigo ra Pilato sii ra Herodes vatyi nu quisi quɨvɨ ñá cuu ndyehe ra sii tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","I zandu‑ɨɨn ra Pilato sii ra zutu nahnu ta ra cu tyiño ta tandɨhɨ ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ta i catyi ra sihin ñu: I quisi ndyaca ndo sii ra ya sii, ta catyi ndo vatyi zatɨvɨ xaan ra sii ñiyɨvɨ. Zoco sa tyicuhve sii ra nuu ndo. Ta ñahñi cuatyi ra iyo cuhva catyi maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ta ra Herodes tucu ñá nañihi ra numinoo cuatyi ra, ta i natasi tucu ra sii ra ihya. Sa ndyehe ndo vatyi ñahñi sa zavaha ra ta cua cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yucuan cuenda cua cañi sii ra, ta cua zañe sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tacuan i catyi ra Pilato vatyi cuñi si sa zaña ra sii minoo ra ñoho vehe caa tañi iyo costumbre sa cuenda vico cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Zoco ɨɨn ñi i cana saa tandɨhɨ ñiyɨvɨ ta catyi ñu: Cahñun sii ra ya, ta zañon sii ra Barrabás. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ta ra Barrabás cuan ñoho ra vehe caa vatyi iyo cuatyi ra sa cuñi ra nduvita ra zɨquɨ ra cu tyiño. Ta i sahñi ra ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ta ra Pilato cuñi ra zaña ra sii ra Jesús, ta i cahan ra sihin ñiyɨvɨ inga saha vatyi cua zaña ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Zoco i cana saa ñu ta catyi ñu: Nacuu ra nu cruz. Nacuu ra nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ta i catyi tucu ra Pilato sihin ñu sa cu uñi saha: ¿Ñaa cuenda? ¿Ñaa sa ña vaha i zavaha ra? Ñahñi cuatyi ra i nañihi ta cua cuu ra. Yucuan cuenda cua cañi sii ra, ta cua zañe sii ra. Catyi ra Pilato. ");
INSERT INTO mihNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Zoco i cana saa xaan ñiyɨvɨ, ta i zañiñi ñu vatyi nacuu ra nu cruz. Yaha xaan i cana saa ñiyɨvɨ, ta ra zutu nahnu ndya cuhva ndya sa cuu cuhva cuñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ta i zandaa ra Pilato tyiño cuhva cuñi maa ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ta tañi cuhva cuñi ñiyɨvɨ, i zaña ra sii ra Barrabás, ra ñoho vehe caa sa cuenda sa sahñi ra ñiyɨvɨ ta nduvita ra zɨquɨ ra cu tyiño. Ta i zavaha ra sihin ra Jesús cuhva catyi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tacuan ta i quihin zandaru sii ra Jesús ta cuahan ra sihin ra. Ta i tɨɨn zandaru sii minoo ra ñuu Cirene. Simón nañi ra. I quita ra sicuhu, ta vasi ra ñuu Jerusalén. Ta i zacuizo zandaru cruz ra Jesús sii ra, ta cuahan ra sata ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ta i sindyico tucu cuaha xaan inga ñiyɨvɨ sii ra Jesús. Ta cuaha xaan ñu zɨhɨ i sacu xaan ñu vatyi cuihya xaan cuñi ñu sa cuenda ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ta i ndyehe ra Jesús sii ñu, ta i catyi ra sihin ñu: Tandɨhɨ ndoho ñu zɨhɨ ñuu Jerusalén, ma vacu ndo sa cuenda mi. Vacu ndo sa cuenda maa ndo ta sa cuenda zehe ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Vatyi cua quisi quɨvɨ cua ndyehe xaan ndo tundoho. Ta cua cahan ñiyɨvɨ sa cuenda ñu sa yoñi zehe, ta cua catyi ñu: “Zɨɨ xaan cuñi ñu yoñi zehe iyo vatyi ma yaha xaan ndyehe ñu tundoho tañi ñiyɨvɨ iyo zehe.” ");
INSERT INTO mihNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Vatyi quɨvɨ cuan, cua cuñi ñu sa nduva yucu xiñi ñu ta zahvi si sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Vatyi tatu tyehen zavaha ñu sihin mi ta ñahñi cuatyi, yaha ca cua zavaha ñu sihin maa ndo ra iyo cuatyi. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ta i quihin tucu zandaru sii uu tahan ra quiñi xaan iyo vatyi cua cahñi ra sii ra ɨɨn ñi sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ta sa saa coyo ra minoo nu nañi si Yɨquɨ Xiñi Ndɨyɨ, yucuan i tyaa ra sii ra Jesús nuu cruz. Ta i tyaa ra sii minoo ra ña vaha cuan nuu inga cruz ta sañi ndyaa ra siyo cuaha ra Jesús. Ta inga ra siyo zatyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ta cuhva sa ndyaa ra Jesús nu cruz ta i catyi ra: Ndyoo Zuti, zohon tucahnu iñi sii ra ya vatyi ña sito ra ñaa sa ndyicuu ra sihin. Tacuan i cahan ra Jesús sihin ra Ndyoo. Ta i sizɨquɨ zandaru cuan vatyi cua ndyehe ra yoo ra cua zahacanaa minoo minoo zahma ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ta yucu ñiyɨvɨ, ta ndyehe ñu. Ta ra cu tyiño sa yucu sihin ñu i sacu ndyaa ra sii ra Jesús ta catyi ra: I zacacu ra sii inga ñiyɨvɨ. Nazacacu ra sii maa ra tatu ndisa vatyi ra Cristo cuu ra, ra i casi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ta i sacu ndyaa tucu zandaru sii ra. I tuhva ra sii ra, ta saha ra vinagre coho ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ta i catyi ra: Tatu rey cuenda ñiyɨvɨ hebreo cuun, zacacun suun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ta i tyaa ra letra xiñi cruz ra sihin zahan griego, ta zahan latín ta zahan hebreo ta catyi si: “Rey ñiyɨvɨ hebreo cuu ra.” ");
INSERT INTO mihNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ta minoo ra quiñi, ra ndyaa nu cruz ii siyo ra Jesús, quiñi xaan i cahan ra sihin ra ta i catyi ra: Tatu ndisa vatyi ra Cristo cuun, zacacun sii moo ta sii maa ndi. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Zoco inga ra cuan i catyi ra sihin ra tahan ra: ¿Atu ña yuhun sii ra Ndyoo? Ta zuun ñi tundoho sa ndyehe maa ra, ndyehun vityi. ");
INSERT INTO mihNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ta maa yo tahan si ndyehe yo tundoho ya vatyi iyo cuatyi yo, zoco maa ra ya ñahñi cuatyi ra iyo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ta i catyi ra sihin ra Jesús: Jesús, nacohon iñun sii, quɨvɨ cua cundyaca ñohon. ");
INSERT INTO mihNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ta i catyi ra Jesús sihin ra: Sa ndisa catyi suhun vatyi vityi cua cundyoon sihin mi nu cuahan añima ñu sino iñi sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tacuan i catyi ra Jesús. Ta i cuu si maa ora, ta i quisaha nduñaa. Ta ñaa xaan i nduu nacahnu ñuu ñiyɨvɨ ndya caa uñi sa sahiñi. ");
INSERT INTO mihNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","I nduñaa ñicandyi. Ta zahma coco sa ndita sisi vehe ñuhu cahnu i ndata zava si. ");
INSERT INTO mihNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ta i cana saa ra Jesús minoo sa ñihi xaan ta i catyi ra: Ndyoo Zuti, ndaha moo tyei añime. Ta sa yaha cahan ra Jesús cuhva cuan ta ndaha i sihi ñi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ta sa ndyehe minoo ra cu nuu sii zandaru tandɨhɨ sa cuu, ta i zacahnu ra sii ra Ndyoo, ta catyi ra: Ndisa cuii vatyi ñahñi cuatyi ra i sicoo. ");
INSERT INTO mihNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ta tandɨhɨ ñiyɨvɨ sa i titahan yucuan vatyi cua ndyehe ñu ñaa sa cua cuu, i quita ñu ta cuahan ñu. Yaha xaan cuihya i cuñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ta tandɨhɨ amigo ra Jesús ta ñu zɨhɨ sa sindyico sii ra ndya Galilea i si‑iñi ndyaa ñu ndya zava. Ta i ndyehe ñu tandɨhɨ sa i cuu. ");
INSERT INTO mihNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Sicoo minoo ra nañi José. Vaha xaan ra, ta ndoo xaan ra. Ta i cuu ra minoo ra cu nuu cuenda ra hebreo. ");
INSERT INTO mihNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ra ñuu Arimatea cuu ra José, ta ndatu ra quɨvɨ cua cundyaca ñaha ra Ndyoo. Ta ñá ndoo ra vaha sihin sa zavaha ra hebreo ra tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ta i sahan ra José nu ndyaa ra Pilato, ta i sica ra coño ñuhu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ta i zanoo ra sii si nuu cruz. Ta i cava noo ra zahma sii si. Ta i saqui ra sii si sisi minoo ñaña nu cuu minoo yavi yuu. Minoo ñaña saa cuu si ta yoñi ca cutyiño sii si. ");
INSERT INTO mihNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ta i cuu si viarni, quɨvɨ i zanduvaha ñiyɨvɨ sa cua casi ñu zavuru vatyi zavuru cuu quɨvɨ tuhva ñu quitatu. ");
INSERT INTO mihNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ta ñu zɨhɨ sa i quisi sihin ra Jesús ndya Galilea i sindyico ñu sii ra, ta i ndyehe ñu ñaña ta cuhva catuu coño ñuhu ra Jesús sisi si. ");
INSERT INTO mihNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ta zɨquɨ cuahan ñu ta zanduvaha ñu xahan vixi (sa cua vaca ñu sii coño ñuhu ra Jesús cuee ca), ta i quitatu ñu zavuru tañi catyi ley hebreo. ");
INSERT INTO mihNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ta quɨvɨ tumingu ñaha cuii ñi i sinanuhu ñu zɨhɨ ndya ñaña ra. Ndaha ñu xahan vixi sa zanduvaha ñu. Ta i sahan tucu inga ñu zɨhɨ sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ta cuhva sa saa ñu i ndyehe ñu vatyi yuu cahnu sa sindazi yuñaña cuan sa sɨñɨ siyo si. ");
INSERT INTO mihNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","I quɨhvɨ ñu sisi ñaña cuan, zoco ña nañihi ñu coño ñuhu ra Jesús, ra ndyaca ñaha sii yo. ");
INSERT INTO mihNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ta ñá ñihi ñu cuhva ñaa sa cuu. Ta cuhva cuan i quisi uu tahan ra nu nandyaa ñu; ñoho ra zahma xiño xaan si. ");
INSERT INTO mihNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ta i yuhu xaan ñu. Ta i sicava ndyayu ñu nu ñuhu. Ta i catyi ra cuan sihin ñu: ¿Ñacu nanducu ndo sii minoo ra ndito ihya nu iyo ñiyɨvɨ i sihi? ");
INSERT INTO mihNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yoñi ca ra ihya; sa i nandoto ra. Nacohon iñi ndo cuhva i cahan ra sihin ndo quɨvɨ sa sica noo ra Galilea. ");
INSERT INTO mihNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Vatyi i catyi ra: “Tahan si sa cuhva cuenda ñu sii ra i quisi ndya gloria ndaha ra iyo cuatyi. Ta cua cahñi ra sii ra nuu cruz. Ta sa cu uñi quɨvɨ cua nandoto tucu ra.” ");
INSERT INTO mihNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","(Tacuan i catyi ángel cuan sihin ñu.) Ta i nacohon iñi ñu tuhun i cahan ra Jesús quɨvɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ta i quita ñu nuñaña, ta i sinuhu ñu. Ta i nacatyi ñu tandɨhɨ cuhva cuan sihin sa usi ɨɨn tahan ca ra i casi ra Jesús ta sihin tandɨhɨ inga ñu sino iñi. ");
INSERT INTO mihNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ta ñu nacatyi tuhun cuan sihin ra cuan cuu ña María Magdalena, ta ña Juana, ta ña María zɨhɨ ra Jacobo ta inga zuhva ca ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Zoco ñá sino iñi ra cuan sa cahan ñu vatyi sica iñi ra vatyi cahan ñi maa ñu. ");
INSERT INTO mihNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Zoco i nduvita ra Pedro, ta i cacono ra ta cuahan ra ndya ñaña. Ta i ndyehe ra sisi yavi yuu cuan. Ta i ndyehe ra vatyi zahma ñi ca ra catuu ndya zava. Ta i sinuhu ra. Ta iyo xaan i cuñi ra vatyi ñá catuu ca coño ñuhu ra Jesús sisi ñaña cuan. ");
INSERT INTO mihNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ta zuun ñi quɨvɨ cuan cuahan uu tahan ra i sica noo sihin ra Jesús ndya minoo ñuu luhlu sa nañi Emaús. Ñuu cuan ndyaa si tañi usi ɨɨn kilómetro sata ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ta cuhva sa cuahan ra, natuhun tahan ra sa cuenda tandɨhɨ sa i cuu. ");
INSERT INTO mihNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ta cuhva sa natuhun tahan ra sihin ra tahan ra, i natahan ra Jesús sii ra ta cuahan ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Zoco vazu i ndyehe ra sii ra Jesús, ñá nacoto ra yoo ra cuu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tacuan ta i catyi ra Jesús sihin ra: ¿Ñaa sa natuhun xaan ndo ityi cuahan ndo? Ta ¿ñacu nducuihya xaan iñi ndo? ");
INSERT INTO mihNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tacuan ta i nacahan minoo ra sa nañi Cleofas, ta catyi ra: ¿Yozo caa cuu si vatyi i sohon ñuu Jerusalén, ta ña siton cuhva sa i cuu ñuu cuan? ");
INSERT INTO mihNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ta i catyi ra Jesús sihin ra: ¿Ñaa sa i cuu? Catyi ra. Ta i catyi ra cuan sihin ra: Sa cuenda ra Jesús, ra ñuu Nazaret vatyi i cuu ra minoo ra profeta. Ta sihin tundyee iñi ra Ndyoo i zavaha xaan ra sa ndyityi. Vaha xaan i cuu ra nuu ra Ndyoo, ta vaha xaan i cahan ra nuu ñiyɨvɨ ndɨhɨ ca. ");
INSERT INTO mihNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Zoco ra zutu nahnu ta ra cu nuu vehe ñuhu i saha cuenda ra sii ra sii zandaru romano vatyi cahñi ra sii ra. Ta i sihi ra nuu cruz. ");
INSERT INTO mihNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ta vityi sa cuu si uñi quɨvɨ sa i cuu cuhva cuan. Ta i sica iñi maa ndi vatyi maa ra cuu ra cua zacacu sii ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ta inga tucu cuhva vatyi iyo xaan cuñi ndi sihin cuhva catyi zuhva ñu zɨhɨ vatyi ñaha cuii ñi i sahan ñu nu ndyaa ñaña ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ta ñá nañihi ñu coño ñuhu ra yucuan. Ta i quisi nacatyi ñu sihin ndi vatyi i ndyehe ñu sii uu tahan ángel. Ta catyi ángel cuan vatyi ndito ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ta sahan zuhva ra tahan ndi nu ndyaa ñaña ra. Ta i ndyehe ra vatyi sa ndisa cuu cuhva catyi ñu zɨhɨ cuan. Ta ñahñi ca coño ñuhu ra Jesús ñoho. ");
INSERT INTO mihNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tacuan i catyi ra cuan. Ta i catyi ra Jesús sihin ra: Zuhva cuii ñi cutuñi iñi ndo. Ta cuee xaan sino iñi ndo tuhun i tyaa ra profeta ta sa naha. ");
INSERT INTO mihNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Atu ña sito ndo vatyi tahan si sa ndyehe xihna ra Cristo tundoho? ta zɨquɨ cua ñihi ra tyiño sa cundyaca ñaha ra. Catyi ra Jesús sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ta zɨquɨ i quisaha nacatyi ra yozo caa cuahan tuhun nu tutu ra Ndyoo. I quisaha ra sihin tuhun i tyaa ra Moisés ta zɨquɨ sa i tyaa tandɨhɨ ra profeta. Ta i zañaha ra Jesús cuhva i cahan Tuhun Ndyoo sa cuenda maa ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ta cuhva sa saa ra ñuu nu cuahan ra, i zaha ra Jesús tuhun vatyi cua cuhun ra ityi nuu ca. ");
INSERT INTO mihNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Zoco i zañiñi inga ra cuan sii ra ta catyi ra: Ndoon sihin ndi vatyi sa cua iñi xaan. Ta i quɨhvɨ ra Jesús vatyi cua ndoo ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ta cuhva sa sacundyaa ra sihin ra mesa, i quihin ra pan. Ta saha ra tyahvi ndyoo sii ra Ndyoo. Ta i sahnu ra sii si, ta saha ra sii si sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ta cuhva cuan i nacoto ra sii ra Jesús, zoco i naa ñi ra Jesús, ta ñá ndyehe ca ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ta i catyi ra sihin ra tahan ra: ¿Ñacu ñá nacoto yo sii ra cuhva sa vasi yo sihin ra? Vatyi zɨɨ xaan i cuñi yo cuhva sa natuhun ra sihin yo ta cuhva zacuaha ra sii yo yozo caa cuahan Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tacuan i catyi ra cuan, ta zuun ñi caa cuhva cuan i nduvita ra ta i sananuhu ra ndya ñuu Jerusalén. Yucuan i nañihi ra sii sa usi ɨɨn tahan ca ra i casi ra Jesús. Ɨɨn ñi yucu ra sihin inga ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ta i catyi ra sihin ra: Ndisa vatyi i nandoto ra ndyaca ñaha sii yo, ta sa ndyehe ra Pedro sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tacuan i catyi ra, ta i nacatyi tucu ra i saa cuan cuhva i natuhun ra Jesús sihin ra ityi cuahan ra ta cuhva i nacoto ra sii ra nu i sahnu ra pan. ");
INSERT INTO mihNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ta cuhva sa natuhun tahan ra tuhun cuan, ta i quituu ra Jesús mahñu nu yucu ra, ta i catyi ra sihin ra: Nacoo xaan sa taxi añima ndo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Zoco i yuhu xaan ra cuan vatyi sica iñi ra vatyi ndyehe ra sii minoo añima. ");
INSERT INTO mihNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ta i catyi ra Jesús sihin ra: ¿Ñacu yuhu xaan ndo? Ta ¿ñacu sica xaan iñi ndo? ta yuhvi cui. ");
INSERT INTO mihNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ndyehe ndo ndehi ta sehi vatyi zuun yuhvi cui. Tɨɨn ndo sii, ta cua coto ndo vatyi yɨvɨ minoo añima cui. Ñahñi yɨquɨ ta coño ñuhu iyo sii minoo añima tañi iyo sii mi. ");
INSERT INTO mihNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ta cuhva sa ndɨhɨ cahan ra Jesús tuhun ya, i zañaha ra ndaha ra ta saha ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Zoco maa ra cuan, iyo xaan cuñi ra ta zɨɨ xaan cuñi ra ndya cuhva ndya ña cuu ca sino iñi ra sa ndyehe ra. Ta i catyi ra Jesús sihin ra: ¿Atu iyo sa casi? ");
INSERT INTO mihNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ta i saha ra zuhva tyiyaca sa tyihyo ta zuhva xita tyahiñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ta i quihin ra sii si, ta i sasi ra nuu tandɨhɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ta i catyi ra sihin ra: Tandɨhɨ sa i cuu sii, cuu sa nacatyi sihin ndo ta ndyei sihin ndo. I catyi vatyi cua cuu tandɨhɨ cuhva ndyaa nuu Tutu ra Ndyoo sa cuenda mi, tandɨhɨ sa catyi tuhun i tyaa ra Moisés, ta tuhun i tyaa ra profeta ta sa ndyaa nu libro salmos ndɨhɨ ca. ");
INSERT INTO mihNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tacuan i catyi ra Jesús sihin ra, ta i saha ra sa cutuñi iñi ra cuhva catyi si nuu tutu ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ta i catyi tucu ra Jesús sihin ra: Tacuan ndyaa si vatyi tahan si sa cui. Ta sa cu uñi quɨvɨ cua nandoto tuqui, catyi si. Vatyi ra Cristo cui, ra zacacu sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ta vityi tahan si sa cuhun ndo tandɨhɨ ñuu nacahnu ñuu ñiyɨvɨ ta nacatyi ndo sihin ñiyɨvɨ vatyi cuñi ra Ndyoo sa ndu‑uu iñi ñu cuatyi ñu ta cua zandasi ra Ndyoo cuatyi ñu. Quisaha ndo cahan ndo tuhun ya ñuu Jerusalén ya. ");
INSERT INTO mihNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ta maa ndo cuu sa ndaa tandɨhɨ tuhun ya. ");
INSERT INTO mihNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ta cua zaquisi Tatyi Ii ra Ndyoo zɨquɨ ndo tañi catyi Zuti vatyi cua cuhva ra sii ndo. Zoco ndoo ndo ñuu Jerusalén ya ndya cua quisi Tatyi Ii, ta cua ñihi ndo tundyee iñi sa cua quisi ndya andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tacuan i cahan ra Jesús sihin ra i casi ra, ta i sindyaca ra sii ra ndya ñuu Betania. Ta i zandaa ra ndaha ra, ta i nazoco ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ta cuhva sa nazoco ra sii ra ta i ndaa xica ñi ra ityi andɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ta i zacahnu xaan ra yucu yucuan sii ra Jesús. Ta i sinanuhu ra ndya ñuu Jerusalén. Ta zɨɨ xaan zɨɨ xaan i cuñi ra. ");
INSERT INTO mihNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ta ñiyaca ta ndyiyaca yucu ra vehe ñuhu cahnu yucuan. Ta zacahnu xaan ra sii ra Ndyoo. Ndɨhɨ si vityi.");
INSERT INTO mihNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Quɨvɨ i sino ñuu ñiyɨvɨ ta sa iyo Tuhun Ndyoo; maa ra, ra cu Tuhun Ndyoo, sa ndyaa ra sihin ra Ndyoo quɨvɨ cuan vatyi Ndyoo cuu tucu maa ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ndya sa xihna cuii ñi ta sa iyo ra sihin ra Ndyoo Zutu yo. ");
INSERT INTO mihNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sihin ra cuan i zavaha ra Ndyoo Zutu yo tandɨhɨ cuii sa iyo, ta ñahñi sa zavaha ra Ndyoo sa maa tuhun ñi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tandɨhɨ sa ndito ta ndito si sa cuenda ra cuan. Ta zañaha ra sii ñiyɨvɨ ñaa sa cuu sa ndisa. Tañi minoo ñúhu cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ñúhu cuan zandisi si nu ñaa. Ta ña cuu ndahva sa ñaa ya sii si. ");
INSERT INTO mihNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Sicoo minoo ra i tasi ra Ndyoo. Sinañi ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","I quisi ra vatyi cuu ra minoo sa ndaa ta cahan ra tuhun sa cuenda ra cu ñúhu cuan vatyi tacuan ta cua sino iñi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Maa ra Juan cuan, yɨvɨ ñúhu cuan cuu ra. Sa ndaa ñi i cuu ra. I tava ra Ndyoo tyiño sii ra vatyi cahan ra sa cuenda ra cu ñúhu cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Vatyi ra cu ñúhu sa ndisa cuan, sa cua saa ra, ta cua cuhva ra sa siñi tuñi vaha sii tandɨhɨ ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","I zavaha ra ñuu ñiyɨvɨ sihin ra Ndyoo Zutu yo, zoco quɨvɨ i quisi ra ñuu ñiyɨvɨ ya, ta ñá nacoto ñiyɨvɨ sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I quisi ra zuun ñi ñuu ñiyɨvɨ sa i zavaha ra, ta zuun ñi ñiyɨvɨ ra ñá naquihin vaha ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Zoco ñiyɨvɨ i naquihin vaha sii ra sa ndisa, i saha ra cuhva sii ñu sa nduu ñu zehe ra Ndyoo. Maa ñu cuu ñu sino iñi sa ndisa cuii sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ña caa ca ñu tañi caa zehe ñiyɨvɨ cuhva iyo si ñuu ñiyɨvɨ ya vatyi sa i nacacu saa ñu cuhva cuñi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ta ra cu Tuhun Ndyoo i nduu ra minoo ñiyɨvɨ, ta sindyaa ra sihin yo zuhva quɨvɨ. Saha xaan ra tumañi iñi sii ñiyɨvɨ, ta cahan ra maa ñi sa ndisa. Sa ndyehe yo vatyi cahnu xaan cuu maa ra tañi Ndyoo zutu ra. Minoo tuhun ñi ra cuu zehe Ndyoo sa ndisa, ta yucuan cuenda cuaha xaan cuhva iyo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","I cahan ra Juan sa cuenda ra, ta catyi ra: Ihya ra cuu ra i catyi vatyi vasi minoo ra cuee ca, zoco ñiñi ca ra ta zɨquɨ mi vatyi sa iyo ra ta zɨquɨ i caqui. Catyi ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sii tandɨhɨ cuii yo tyindyee xaan ra cuaha xaan cuaha xaan saha. ");
INSERT INTO mihNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sa cuenda ra Moisés ta sito yo ley ra Ndyoo, zoco sa cuenda ra Jesucristo, ta cuu ñihi yo tumañi iñi sihin ra Ndyoo, ta cuu coto yo ñaa sa cuu sa ndisa cuii. ");
INSERT INTO mihNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ta yoñi ca ndyehe sii ra Ndyoo numinoo saha. Zoco sa minoo tuhun ñi ra cuu zehe ra, cuñi xaan ra Ndyoo sii ra, ta maa ra ndyehe sii ra Ndyoo. Ta i nacatyi ra tandɨhɨ sihin yo yozo caa iyo ra Ndyoo Zutu yo. ");
INSERT INTO mihNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ra hebreo ra ñiñi ñuu Jerusalén i tasi ra sii ra cu zutu ta sii ra tyindyee sii ra cu zutu vatyi cua nducu tuhun ra sii ra Juan yoo ra cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ta i catyi casi ra Juan: Yɨvɨ ra Cristo cuu yuhvi. ");
INSERT INTO mihNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ta zɨquɨ i nducu tuhun tucu ra ta catyi ra: ¿Yoo ra cuu oo? ¿Atu ra Elías cuun? Ta i catyi ra Juan: Yɨvɨ yuhvi. Ta zɨquɨ i nducu tuhun ra inga saha sii ra Juan ta catyi ra: ¿Atu yoho cuu ra cua quisi, ra cua cahan Tuhun Ndyoo? Ta i catyi tucu ra Juan: Yɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ta zɨquɨ i catyi tucu ra cuan sihin ra: ¿Yoo ra cuu oo? Cuñi si vatyi nacatyi ndi sihin ra tasi sii ndi. ¿Ñaa sa cua catyun? ¿Yoo ra cuun? ");
INSERT INTO mihNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","I nacahan ra Juan ta catyi ra: Yuhvi cui minoo ra cana saa sisi cuhu ta catyi: “Vasi ra ndyaca ñaha sii yo. Yucuan cuenda zandundoo ndo ityi tañi i catyi ra cahan Tuhun Ndyoo”, ra Isaías. Tacuan i catyi ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ta ra i quisi cuenda ra fariseo ");
INSERT INTO mihNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","i nducu tuhun ra sii ra Juan ta catyi ra: Tatu yɨvɨ ra Cristo cuun ta yɨvɨ ra Elías ta yɨvɨ inga ra cahan Tuhun Ndyoo cuun ¿ñaa cuenda zacoo ndutyon sii ñiyɨvɨ? ");
INSERT INTO mihNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ta i catyi ra Juan: Zacoo ndutye sihin ndutya. Nu yucu maa ndo nandyaa minoo ra sa ña sito ndo yoo ra cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I sei sa xihna ñi ñuu ñiyɨvɨ ya ta zɨquɨ i saa maa ra, zoco ñiñi xaan ca ra ta zɨquɨ mi. Ta yucuan cuenda ma cuu cui nu muzu ra ta ndasi tyiendu ndisa ra. Catyi ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ta tandɨhɨ ihya, i cuu si nu nañi si Betábara. Ndyaa si cuan ityi caña ñicandyi ndya nu ndyaa yuu Jordán nu tuhva ra Juan zacoo ndutya sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ta inga quɨvɨ i ndyehe ra Juan vatyi tuhva ra Jesús sii ra, ta i catyi ra: Ndyehe ndo, ihya vasi ra cuu mvee ticatyi ra Ndyoo. Zandasi ra cuatyi sii tandɨhɨ ñiyɨvɨ ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ihya ra cuu ra quehin tuhun quɨvɨ i catyi: “Cuee ca cua quisi inga ra, zoco ñiñi xaan ca ra ta zɨquɨ mi vatyi sa iyo ra ta zɨquɨ i caqui.” ");
INSERT INTO mihNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ta ñá site yoo ra cuu ra quɨvɨ cuan, zoco cuñi sa cua coto ñiyɨvɨ hebreo sii ra, ta yucuan cuenda vasi zacoo ndutye sii ñiyɨvɨ sihin ndutya. Catyi ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ta i saha ra Juan minoo sa ndaa ta catyi ra: I ndyehi quɨvɨ i noo Tatyi Ii ndya ityi zɨquɨ tañi noo minoo paloma, ta i ndoo si sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ta ñá nacote sa xihna ñi yoo ra cuu ra Jesús, zoco ra Ndyoo Zutu yo i tava ra tyiño sii, sa zacoo ndutye sihin ndutya, ta i catyi ra: “Tatu cua ndyehun vatyi noo Tatyi Ii ta ndoo si sihin minoo ra, yucuan ra cuu ra cua zacoo ndutya sihin Tatyi Ii.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ta sa i ndyehi cuhva cuan, catyi ra Juan, ta sehi sa ndaa vatyi ihya cuu ra cuu zehe ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ta i yaha minoo quɨvɨ. Ta inga quɨvɨ ndyaa ra Juan yucuan inga saha sihin uu tahan ra cutahan sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ta sa i ndyehe ra vatyi cua yaha ra Jesús ta i catyi ra: Ica ra cu mvee ticatyi ra Ndyoo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ta sa siñi sa uu tahan ra cutahan sihin ra sa cahan ra Juan, ta i sindyico ra cuan sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ta zɨquɨ i nandyehe ra Jesús ityi sata ra, ta i ndyehe ra vatyi ndyico ra cuan sii ra, ta i catyi ra Jesús: ¿Ñaa sa nanducu ndo? Ta i catyi ra cuan: Maestro, ¿ndyamaa iyo vehun? ");
INSERT INTO mihNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ta i catyi ra Jesús: Coho ndo ta cua ndyehe ndo. Ta cuahan ra cuan sihin ra, ta i ndyehe ra nu ndyaa ra Jesús, ta i ndoo ra minoo quɨvɨ cuan sihin ra vatyi sa i cuu si tañi caa cumi sa sahiñi cuhva sa i saa ra yucuan. ");
INSERT INTO mihNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ta minoo sa uu tahan ra cuan sa i siñi ra sa catyi ra Juan ta sindyico ra sii ra Jesús, cuu ra Andrés yañi maa ra Simón Pedro. ");
INSERT INTO mihNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ta ra Andrés, ñahñi inga ca sa i zavaha ra. Sa xihna cuii ñi i sahan ra ta nanducu ra sii yañi ra, ra Simón, ta i catyi ra: Sa nañihi ndi sii ra Mesías. Catyi ra. (Tuhun Mesías cuan cuñi si catyi si Cristo a minoo ra sa cua zacacu sii ñiyɨvɨ.) ");
INSERT INTO mihNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ta zɨquɨ i sahan ra Andrés sihin ra Simón ndya nu ndyaa ra Jesús. Ta sa ndyehe ra Jesús sii ra Simón, i catyi ra: Yoho cuu ra Simón zehe ra Jonás, zoco cua cunañun Cefas. (Cuñi si catyi si Pedro a minoo yuu.) ");
INSERT INTO mihNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ta inga quɨvɨ cua cuhun ra Jesús ndya nu cu si Galilea, ta i nañihi ra sii ra Felipe ta catyi ra: Cundyicon sii. ");
INSERT INTO mihNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ta ra Felipe cuan cuu ra minoo ra ñuu Betsaida. Ɨɨn ñi ñuu maa ra sihin ñuu ra Andrés ta ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ta i sahan ra Felipe ta nanducu ra sii ra sa nañi Natanael, ta i catyi ra: Sa i ndyehe ndi sii ra i cahan ra Moisés tuhun nu i tyaa ra nu tutu. Ta i tyaa tucu ra profeta sa cuenda ra cuan. Ra Jesús cuu ra sa cahan ra cuan tuhun, ta zehe ra José cuu ra, ra ñuu Nazaret. ");
INSERT INTO mihNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ta i catyi ra Natanael: Ma cuu quita minoo sa vaha ñuu Nazaret cuan. Ta i nacahan ra Felipe ta catyi ra: Coho ta cua ndyehun. ");
INSERT INTO mihNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ta sa i ndyehe ra Jesús sii ra Natanael vasi ra, ta i catyi ra Jesús: Ica minoo ra sa cuu ñiyɨvɨ hebreo sa ndisa cuii. Ña tuhva maa ra zandavi ñaha. ");
INSERT INTO mihNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ta zɨquɨ i nducu tuhun ra Natanael ta catyi ra: ¿Yozo caa siton sii? Ta i catyi ra Jesús: I ndyehi suun cuee ca sa cana ra Felipe suun, cuhva sa ndyoon saha yutu higuera cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ta i catyi ra Natanael: Maestro, yoho cuu zehe ra Ndyoo Zutu yo. Ra ndyaca ñaha cahnu sii ñiyɨvɨ hebreo cuun. ");
INSERT INTO mihNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","I nacahan ra Jesús ta catyi ra: ¿Atu sihin sa yucuan ñi sino iñun sii vatyi catyi suhun vatyi ndyehi suun saha yutu higuera cuan? Cahnu xaan ca inga sa cua ndyehun ta zɨquɨ ca sa ihya. ");
INSERT INTO mihNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sa ndisa catyi suhun vatyi cua ndyehun vatyi cua nuña ityi zɨquɨ ityi andɨvɨ ta ángel Ndyoo cua ndaa cua noo zɨquɨ ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ta i yaha uñi quɨvɨ ta zɨquɨ sicoo minoo vico tindaha ñuu Caná nu cu si Galilea. Ta ñoho zɨhɨ ra Jesús yucuan. ");
INSERT INTO mihNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ta i cana ñiyɨvɨ sii ra Jesús sihin ra i casi ra vatyi cuhun tucu ra vico tindaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ta cuahan ra, ta nu yucu ñiyɨvɨ yucuan i ndɨhɨ vino sihi ñu, ta catyi zɨhɨ ra Jesús sihin ra: Ndɨhɨ vino. ");
INSERT INTO mihNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ta i nacahan ra Jesús ta catyi ra: Maha, ¿ñaa cuenda cohon tuhun ña sihin? Tañaha ca tahan si quɨvɨ zatyiñe. ");
INSERT INTO mihNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Zoco i catyi maa ña sihin ñu cu muzu: Zavaha ndo tandɨhɨ sa catyi maa ra. ");
INSERT INTO mihNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ta yucuan siyucu iñu tahan quɨzɨ yuu nahnu, tahan sa sityiño ñiyɨvɨ hebreo sa cuenda costumbre sa nacatya xaan ñu ndaha ñu a ñaa ca. Ta sa minoo minoo quɨzɨ cuan cuu cutahan cumi xico a minoo ziendu litro ndutya. ");
INSERT INTO mihNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ta i catyi ra Jesús sihin ñiyɨvɨ zatyiño: Zacutu ndo quɨzɨ ya sihin ndutya. Ta i zacutu cuii ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ta zɨquɨ i catyi ra Jesús: Vityi tava ndo zuhva si ta cundyaca ndo sii ra cu nuu sii vico ya. Ta tacuan i zavaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ta i sihi ra cu nuu sii vico cuan sii ndutya cuan ta sa i nduu si vino, ta ñá sito ra yozo caa sino si. Zoco i sito maa ñu cu muzu cuan vatyi maa ñu i tyihi ndutya sisi quɨzɨ cuan vatyi maa ra Jesús catyi, ta i nduu si vino. Ta ra cu nuu sii vico cuan i cana ra sii ra tindaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ta i catyi ra sihin ra: Tandɨhɨ ñiyɨvɨ tuhva ñu saha sa xihna ñi vino vaha, ta tatu sa i sihi ñiyɨvɨ cuaha vino ta zɨquɨ cua cuhva tucu ñu vino ndahvi ca coho ñiyɨvɨ. Zoco yoho i sicumi vohon vino vaha, ta vityi sohon sii si. (Tacuan i catyi ra vatyi ña sito ra vatyi maa ra Jesús zavaha vino cuan sihin ndutya.) ");
INSERT INTO mihNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ihya cuu sa xihna ñi sa ndyityi i zavaha ra Jesús ñuu Caná nu cu si Galilea, ta sihin cuhva ya zañaha ra vatyi iyo xaan cuhva sii ra, ta i sino iñi ra i casi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ta sa ndɨhɨ vico cuan, ta cuahan ra Jesús ñuu Capernaum. Ta cuahan zɨhɨ ra ta yañi ra ta ra i casi ra sihin ra. Ta yucuan i ndoo ñu zuhva quɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sa cuñi tahan si quɨvɨ coo vico zuhun cuenda ñiyɨvɨ hebreo, ta cuahan ra Jesús ndya ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ta yucuan nuquehe vehe ñuhu i ndyehe ra vatyi xico ñiyɨvɨ zɨndɨquɨ, mvee ticatyi ta paloma, ta inga ñiyɨvɨ ndyaa ñu sa nazama ñu xuhun ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ta sa ndyehe ra Jesús tacuan, i zavaha ra minoo cuarta, ta i tava ndyizo ra sii ñu sata vehe ñuhu cuan sihin mvee ticatyi ta zɨndɨquɨ. Ta sii ñiyɨvɨ nazama xuhun, i quɨtɨ cuatyi ra xuhun ñu nu ñuhu ta i zanduva ra mesa ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ta sihin ñiyɨvɨ xico paloma i catyi ra: Tava ndo sii tɨ ihya. Ma zavaha ndo minoo vehe nuyahvi sii vehe Zuti. ");
INSERT INTO mihNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ta sa i ndyehe ra i casi ra cuhva i zavaha ra, ta i nacohon iñi ra vatyi i catyi ra David quɨvɨ i tyaa ra Tuhun Ndyoo: “Cuñi zatɨvɨ si sii, vatyi zavaha ñiyɨvɨ sa ña vaha sisi vehun.” ");
INSERT INTO mihNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ta zɨquɨ i nducu tuhun ra hebreo sii ra Jesús ta catyi ra: ¿Ñaa zeña cua zañohon sii ndi ta zɨquɨ cua coto ndi vatyi ra cahnu cuun ta cuu zavohon sa tyehen? ");
INSERT INTO mihNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","I nacahan ra Jesús ta catyi ra: Cani ndo vehe ñuhu ya, ta sa cu uñi quɨvɨ ta cua zanduvehi sii si inga saha. ");
INSERT INTO mihNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tacuan ta zɨquɨ i catyi ra hebreo: Uu xico iñu cuiya i zatyiño ra zandaa vehe ñuhu ya. ¿Ta ñacu catyun vatyi cua zandoon sii si sisi sa uñi quɨvɨ ñi? ");
INSERT INTO mihNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Zoco vehe ñuhu sa cahan ra Jesús tuhun, zuun ñi coño ñuhu maa ra cuu. ");
INSERT INTO mihNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yucuan cuenda, quɨvɨ i nandoto ra Jesús ta i nacohon iñi ra i casi ra vatyi sa i catyi ra cuhva ya. Ta zɨquɨ i sino iñi ra cuhva catyi tutu Ndyoo ta tuhun cahan ra Jesús sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ta quɨvɨ sa sindyaa ra Jesús ñuu Jerusalén vico zuhun cuan ta cuaha xaan ñiyɨvɨ sino iñi sii ra vatyi ndyehe ñu cuaha xaan sa ndyityi i zavaha ra. ");
INSERT INTO mihNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Zoco ña nɨɨ iñi ra Jesús sihin ñiyɨvɨ cuan vatyi sa sito vaha ra cuhva iyo tandɨhɨ ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ta ña siñi ñuhu minoo, yoo sa cua cuhva sa ndaa sii ra vatyi zuun ñi maa ra ta sa sito ra yozo caa iyo añima ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Sicoo minoo ra fariseo nañi ra Nicodemo. Minoo ra ndyizo tyiño sihin ra hebreo cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ta i sahan ra minoo sa cuaa sa cua cahan ra sihin ra Jesús, ta catyi ra: Maestro, sito ndi vatyi maa ra Ndyoo i tava tyiño suun vatyi zacuohon sii ndi vatyi yoñi ra cuu zavaha sa ndyityi tañi zavaha moo tatu yɨvɨ ra Ndyoo tyindyee sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ta i nacatyi ra Jesús sihin ra: Sa ndisa ta sa ndisa catyi suhun vatyi tatu ma nacacu saa ñiyɨvɨ, ma cuu cundyaca ñaha ra Ndyoo sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ta i nducu tuhun ra Nicodemo ta catyi ra: ¿Zoco yozo caa cuu nacacu saa minoo ñiyɨvɨ tatu sa sahnu ra? Ma cuu nandɨhvɨ ra sisi zɨhɨ ra inga saha ta nacacu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ta i nacahan ra Jesús ta catyi ra: Sa ndisa ta sa ndisa catyi suhun, ra ma coo ndutya ta ra ma ñihi Tatyi Ii ra Ndyoo, ma cuu quɨhvɨ ra nu ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ra cacu ñiyɨvɨ, ñiyɨvɨ cuu ra. Zoco ra nacacu saa sa cuenda Tatyi Ii, sa ndito añima ra. ");
INSERT INTO mihNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ma iyo xaan cuñun vatyi catyi suhun vatyi cuñi si sa nacacu soon. Ñahñi ca cuhva. ");
INSERT INTO mihNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Caá tatyi tandɨhɨ ñi maa ityi. Siñun nduzu si, zoco ña cuu catyun ndyamaa i quisi si a ndyamaa cuahan si. Ta tacuan tucu iyo ñiyɨvɨ sa nacacu cuenda Tatyi Ii. ");
INSERT INTO mihNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tacuan i catyi ra Jesús, ta zɨquɨ i quisaha nducu tuhun tucu ra Nicodemo sii ra ta catyi ra: ¿Ta yozo caa cuu cuhva ya? ");
INSERT INTO mihNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ta i nacatyi ra Jesús sihin ra: Ta yoho minoo ra ñiñi cuun, minoo ra zacuaha sii ñiyɨvɨ hebreo, ta ña cutuñi iñun tuhun ya. ");
INSERT INTO mihNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sa ndisa ta sa ndisa catyi suhun vatyi quehin cuhva site ta cui sa ndaa cuhva sa ndyehi, zoco ña sino iñi ndo sa catyi. ");
INSERT INTO mihNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tatu quehin sihin ndo cuhva iyo ñuu ñiyɨvɨ ya ta ña sino iñi ndo, ¿yozo caa cua sino iñi ndo tatu quehin sa cuenda sa iyo ndya gloria? ");
INSERT INTO mihNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yoñi ra sa i ndaa xica ndya gloria, maa ñi maa ra sa i noo ndya gloria, ra i quisi ndya gloria, zehe ra ndyaa ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ta tañi i cañihi ra Moisés coo caa cuan sisi cuhu, tacuan tucu cua cañihi ñiyɨvɨ sii ra i quisi ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Vatyi tacuan ta tandɨhɨ ñiyɨvɨ sino iñi sii ra, ma cunaa ñu. Cua cundito ñu tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","(Cahan ca ra Jesús, ta catyi ra:) Cuñi xaan ra Ndyoo sii ñiyɨvɨ, ta i saha ra sii sa minoo tuhun ñi zehe ra vatyi tandɨhɨ ñiyɨvɨ, ñu sino iñi sii ra, ma cunaa ñu. Cua cundito ñu tandɨhɨ tyiemvu sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ñá zaquisi ra Ndyoo sii zehe ra ñuu ñiyɨvɨ ya sa cuenda sa cua tasi tuñi ra sii ñiyɨvɨ. I zaquisi ra sii ra vatyi cua zandasi ra cuatyi ñiyɨvɨ ta cua zacacu ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ñiyɨvɨ sa sino iñi sii zehe ra Ndyoo, ma tasi tuñi ra Ndyoo sii ñu, zoco ñiyɨvɨ sa ña sino iñi cua tasi tuñi ra Ndyoo sii ñu vatyi ña sino iñi ñu sii sa minoo tuhun ñi ra cu zehe Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ta ihya cuu cuenda cua tasi tuñi ra Ndyoo sii ñu vatyi i quisi ñúhu ñuu ñiyɨvɨ, zoco cuñi xaan ca ñiyɨvɨ sa ñaa, ta ña cuñi ñu sii ñúhu vatyi yaha xaan ña vaha cuu cuhva zavaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tandɨhɨ ñiyɨvɨ sa zavaha sa ña vaha, cuxaan xaan ñu ndyehe ñu ñúhu cuan, ta ña tuhva ñu sii si coto ndundisi cuhva ña vaha sa ndyicuu ñu ta cua ndoho ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Zoco ñiyɨvɨ zavaha cuhva sasi tahan sihin sa ndisa, tuhva ñu sii ñúhu, vatyi tacuan ta cua coto inga ñiyɨvɨ vatyi ra Ndyoo tyindyee sii ñu sihin cuhva vaha zavaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ta sa i yaha cahan ra Jesús ta zɨquɨ cuahan ra sihin ra i casi ra ndya nu cu si Judea, ta i ndoo ra zuhva quɨvɨ yucuan, ta i zacoo ndutya ra sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ta zuun ñi zacoo ndutya tucu ra Juan ñuu Enón yatyi ñi ñuu Salim vatyi cuaha xaan ndutya iyo yucuan. Ta cuaha xaan ñiyɨvɨ i quisi, ta sicoo ndutya ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tacuan i cuu si vatyi tañaha ca cua tyihi ñiyɨvɨ sii ra Juan vehe caa. ");
INSERT INTO mihNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tacuan ta zɨquɨ i quisaha natuhun tahan xaan ra cu tahan sihin ra Juan sihin minoo ra hebreo sa cuenda yozo caa nduvaha cuhva iyo ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ta i sahan ñiyɨvɨ nu ndyaa ra Juan ta catyi ñu sihin ra: Maestro, ra sa sindyaa suhun inga siyo yutya Jordán, ra sa cahan xoon tuhun, vityi zacoo ndutya ra, ta tandɨhɨ ñiyɨvɨ ndyico sii maa ra. ");
INSERT INTO mihNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ta i nacahan ra Juan ta catyi ra: Yoñi minoo yo ta cuu coo sa sii yo tatu yɨvɨ maa ra Ndyoo saha. ");
INSERT INTO mihNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Zuun ñi maa ndo cuu sa ndaa vatyi sa i catyi sihin ndo vatyi yɨvɨ ra Cristo cui. Minoo ra i tasi ra Ndyoo ityi nuu cui. ");
INSERT INTO mihNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Vityi cua quehin minoo cuhva, cuhva iyo minoo vico tindaha. Ra cua tindaha cuan cuu ra sa cua quihin minoo ñaha. Ta amigo ra tindaha cuan, ndyaa ra yucuan. Tyizoho ra, ta cuzɨɨ xaan cuñi ra sihin cuhva cahan ra cua tindaha. Tacuan tucu mi vityi. Zɨɨ xaan cuñi. ");
INSERT INTO mihNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ra sa cahan ndo tuhun, cuñi si nducahnu ca ra, ta yuhvi cua nduluhlu que. ");
INSERT INTO mihNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ra i quisi ndya gloria, ra cahnu ca cuu ra ta zɨquɨ tandɨhɨ inga ñiyɨvɨ. Ta ñiyɨvɨ ihya, cuenda ñuu ñiyɨvɨ ya cuu yo. Cahan yo cuhva iyo ñuu ñiyɨvɨ. Zoco ra i quisi ndya gloria ñiñi ca cuu maa ra ta zɨquɨ tandɨhɨ ca yo. ");
INSERT INTO mihNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ta saha ra sa ndaa sa cuenda sa i ndyehe ra ta sa i siñi ra, zoco yoñi sino iñi sa catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Zoco tatu iyo minoo ra sa sino iñi sa ndaa sa saha ra cuan, saha tucu maa ra sa ndaa vatyi cahan ra Ndyoo sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Vatyi ra i tasi ra Ndyoo, cahan ra Tuhun Ndyoo. Vatyi saha maa ra Ndyoo Tatyi Ii sii ra cuaha xaan. ");
INSERT INTO mihNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Cuñi xaan ra Ndyoo Zutu yo sii Zehe ra, ta tandɨhɨ cuii ñaa sa iyo, saha maa ra Ndyoo sii si sii Zehe ra. ");
INSERT INTO mihNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ñiyɨvɨ sino iñi sii Zehe ra Ndyoo, cua cundito ñu tandɨhɨ cuii tyiemvu. Zoco ñiyɨvɨ ña sino iñi, ma cundito ñu sihin ra Ndyoo. Yaha xaan cua ndoho ñu cua zacuu ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","I sito ra fariseo vatyi cuaha ca ñiyɨvɨ ndyico sii ra Jesús ta cuaha ca ñiyɨvɨ zacoo ndutya ra ta zɨquɨ ra Juan. Vazu yɨvɨ ra Jesús zacoo ndutya sii ñu. Maa ra i casi ra zacoo ndutya sii ñu. Ta sa sito ra Jesús vatyi sa sito ra fariseo cuhva cuan, ta zɨquɨ i quita ra Judea ta cua nuhu ra ndya Galilea. ");
INSERT INTO mihNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ta ityi cuhun ra, cua yaha ra nu cu si Samaria. ");
INSERT INTO mihNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yucuan cuenda saa ra minoo ñuu sa nañi Sicar. Cuenda Samaria cuu ñuu cuan, ta ndyaa si yatyi minoo ñuhu i saha ra Jacob sii ra José zehe ra ta tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yucuan iyo zoco sa nañi zoco ra Jacob. Sitatu xaan ra Jesús vatyi sica ityi ra, ta yucuan cuenda sicundyaa ra yatyi ñi yuhu zoco cuan. Ta i cuu si maa ora. ");
INSERT INTO mihNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ta ra i casi ra Jesús, cuahan ra ndya ñuu vatyi cua zata ra zuhva sa casi ra. Tacuan ta zɨquɨ i saa minoo ñaha nu ndyaa ra Jesús. Minoo ñaha samaritana cuu ña. Vasi quihin ña ndutya. Ta catyi ra Jesús sihin ña: Cuhva siin ndutya cohi. ");
INSERT INTO mihNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ta i nacahan ñaha samaritana cuan ta catyi ña: Ra hebreo cuun, ta yozo caa vatyi sicon ndutya sii, ta ñaha samaritana cui. Tacuan i catyi ña vatyi iyo tizɨhɨ ñiyɨvɨ hebreo sihin ñiyɨvɨ samaritana. ");
INSERT INTO mihNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tacuan ta zɨquɨ i nacahan ra Jesús ta catyi ra: Tatu sa vatyi siton ñaa sa saha maa ra Ndyoo ta yoo ra sica ndutya suun, cua cacon sii, ta cua cuhve ndutya sa cunditon. ");
INSERT INTO mihNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ta zɨquɨ i catyi ña sihin ra: Tata, ñahñi sa ndohon sa cua tavon ndutya ya, ta cono xaan ñoho ndutya ya. ¿Ta ndyamaa cua cuhun ndutya sa saha sa cundito ñiyɨvɨ ta cuhvon sii? ");
INSERT INTO mihNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Atu cahnu ca moo ta zɨquɨ ra Jacob ra cu ñiyɨvɨ sahnu sii ndi? Ihya ndutya i sihi maa ra ta zehe ra ta quɨtɨ zono ra, ta i zandoo ra ndutya ya sii ndi. Catyi ña. ");
INSERT INTO mihNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ta i catyi ra Jesús sihin ña: Tandɨhɨ ñiyɨvɨ sa cua coho ndutya ya, cua cu‑ityi ñu inga saha. ");
INSERT INTO mihNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Zoco ñiyɨvɨ sa cua coho ndutya sa cua cuhve, ma cu‑ityi ca ñu numinoo saha. Vatyi ndutya sa cua cuhve, cua caña si sisi añima ñu, ta cua cuhva si sa cundito añima ñu sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tacuan ta zɨquɨ i catyi ñaha cuan sihin ra: Tata, cuhvon ndutya cuan sii vatyi ma cu‑ityi que, ta ma quisi quihin que ndutya zoco ya. ");
INSERT INTO mihNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ta i catyi ra Jesús sihin ña: Cuahan cua canon sii yɨun ta quisi ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ta i nacahan ña ta catyi ña: Yoñi yɨi iyo. Ta i catyi ra Jesús sihin ña: Ndison sa cohon vatyi yoñi yɨun iyo. ");
INSERT INTO mihNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Vatyi sa sicoo ohon tahan yɨun. Ta ra sa ndyaa suhun vityi, yɨvɨ yɨun cuu sii ra cuan sa ndisa. Ndisa sa cohon vatyi yoñi yɨun iyo. ");
INSERT INTO mihNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tacuan ta i catyi ñaha cuan sihin ra: Tata, tuu iñi vatyi minoo ra cahan Tuhun Ndyoo cuun. ");
INSERT INTO mihNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","I zacahnu ñiyɨvɨ sahnu sii nduhvi samaritana sii ra Ndyoo ihya yucu ya, zoco ndoho ñiyɨvɨ hebreo catyi ndo vatyi Jerusalén cuu nu cuñi si zacahnu ñiyɨvɨ sii ra Ndyoo, catyi ña. ");
INSERT INTO mihNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ta i catyi ra Jesús sihin ña: Sino iñun sa quehin, maha, vatyi sa cua saa quɨvɨ ta cua zacahnu ndo sii ra Ndyoo Zutu yo, zoco yɨvɨ yucu ya ta yɨvɨ ndya Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ndoho samaritana ña sito ndo ñaa sa zacahnu ndo, zoco nduhvi sito ndi yoo ra zacahnu ndi. Vatyi cuhva cacu yo vasi si sa cuenda ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Zoco sa cua saa cuhva, ta vityi cuu si, ta ñiyɨvɨ sa zacahnu sii ra Ndyoo sa ndisa, cua zacahnu ñu sii ra sihin tandɨhɨ añima ñu ta sihin sa ndisa. Vatyi nanducu ra Ndyoo Zutu yo sii ñiyɨvɨ sa cua zacahnu sii ra cuhva cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ndyoo cuu ra tatyi, ta ñiyɨvɨ zacahnu sii ra, cuñi si vatyi zacahnu ñu sii ra sihin cuhva saha Tatyi Ii ra ta minoo sa ndisa. Tacuan catyi ra Jesús sihin ña. ");
INSERT INTO mihNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ta zɨquɨ i catyi ñaha cuan: Site vatyi cua quisi minoo ra sa cua zacacu sii yo, ta Cristo cua cunañi ra. Ta quɨvɨ cua quisi ra, cua nacatyi ra tandɨhɨ sihin yo, catyi ña. ");
INSERT INTO mihNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ta i catyi ra Jesús sihin ña: Zuun yuhvi cui ra cahan suhun ya. ");
INSERT INTO mihNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ta cuhva sa cahan ra Jesús ta i nasaa ra i casi ra, ta iyo xaan i cuñi ra ñaa cuenda natuhun xaan ra Jesús sihin minoo ñaha. Zoco numinoo ra, ta ñá cuñi ra nducu tuhun ñaa sa cuñi ña a ñaa tuhun cahan ra sihin ña. ");
INSERT INTO mihNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ta zɨquɨ i zandoo ñaha cuan quɨyɨ ña, ta cuahan ña ndya ñuu, ta i nacatyi ña sihin ñiyɨvɨ: ");
INSERT INTO mihNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Coho ndo cua ndyehe yo sii minoo ra nacatyi sihin tandɨhɨ cuii sa zavehi. ¿Atu yɨvɨ ra Cristo cuu ra? Catyi ña. ");
INSERT INTO mihNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tacuan ta zɨquɨ i quita ñu ñuu cuan ta cuahan ñu ndya nu ndyaa ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cuee ca sa saa ñiyɨvɨ yucuan ta i zañiñi ra i casi ra Jesús sii ra ta catyi ra: Maestro, casi zuhva. ");
INSERT INTO mihNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Zoco i catyi ra Jesús sihin ra: Iyo sa sa sasi, zoco ña sito ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tacuan ta zɨquɨ i quisaha nducu tuhun tahan ra i casi ra sii tahan ra, ta catyi ra: ¿Atu iyo minoo ñiyɨvɨ sa quisi ndyaca sa sasi ra ya? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Zoco i catyi ra Jesús sihin ra: Sa saha tundyee iñi sii, cuu sa zavehi cuhva cuñi ra tasi sii, ta sa zandɨhi tyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ma catyi ndo: “Cumañi cumi ca yoo, ta cua naquihin ñiyɨvɨ tyiño i zacuu ñu.” Vatyi yuhvi catyi: Ndyehe vaha ndo itu vatyi sa sisa si. Sa cuu zaquee ñiyɨvɨ sii si. ");
INSERT INTO mihNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ta ra sa cua naquihin, cua coo yahvi ra. Ta sa cua naquihin ra, cuu cuenda tandɨhɨ cuii tyiemvu. Ma cunaa si. Vatyi ra tasi ta ra cua naquihin cua cuzɨɨ xaan iñi nduu tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ta ihya cuu minoo sa ndisa cuhva cahan ñiyɨvɨ: “Minoo ra tasi ta inga ra naquihin.” ");
INSERT INTO mihNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tave tyiño sii ndo vatyi naquihin ndo nu ñá ndyehe ndo tundoho. Inga ra zatyiño ta vityi nañihi maa ndo sa vaha nu zatyiño ra cuan. (Tacuan i catyi ra Jesús sihin ra i casi ra.) ");
INSERT INTO mihNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ta cuaha xaan ñiyɨvɨ ñuu Samaria i sino iñi ñu sii ra Jesús sa cuenda sa i nacatyi ñaha cuan vatyi i catyi ña: “I nacatyi ra sihin tandɨhɨ cuii sa i zavehi.” ");
INSERT INTO mihNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yucuan cuenda zañiñi ñu sii ra Jesús vatyi ndoo ra sihin ñu. Ta i ndoo ra Jesús uu quɨvɨ yucuan. ");
INSERT INTO mihNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ta cuaha xaan ca ñu i sino iñi ñu sii ra Jesús sa cuenda tuhun i cahan ra sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ta zɨquɨ i catyi ñu sihin ñaha cuan: Vityi sino iñi ndi sii ra ta ña ɨɨn ñi sa cuenda tuhun i nacatyi moo, zoco vityi zuun ñi maa ndi siñi ndi sa cahan ra, ta sito ndi vatyi ndisa ra Cristo cuu ra, ra cua zacacu sii ñiyɨvɨ ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","I yaha uu quɨvɨ, ta i quita ra Jesús yucuan ta cuahan ra ndya nu cu si Galilea. ");
INSERT INTO mihNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Vatyi sa catyi maa ra vatyi minoo ra cahan Tuhun Ndyoo, ña tyaa ñiyɨvɨ yahvi sii ra ñuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ta sa i saa ra Jesús ndya Galilea, ta yucuan zɨɨ xaan i cuñi ñiyɨvɨ sihin ra vatyi sa i sahan ñu vico zuhun ñuu Jerusalén ta i ndyehe ñu tandɨhɨ sa i zavaha ra Jesús yucuan. ");
INSERT INTO mihNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tacuan ta zɨquɨ i naquita tucu ra Jesús ndya ñuu Caná sa ndyaca ñaha Galilea nu i zanduu ra vino sii ndutya quɨvɨ cuan. Ta yucuan iyo minoo ra ñuu Capernaum. Cahnu xaan tyiño ndyizo ra cuenda ra cu rey. Ta cuhu xaan zehe ra ndya ñuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ta sa sito ra cuan vatyi sa i quita ra Jesús Judea ta nasaa ra Galilea, i sahan ra nu ndyaa ra sa cua cahan ra sihin ra vatyi cuhun ra ndya vehe ra ta zanduvaha ra sii zehe ra vatyi sa cuñi cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tacuan ta i catyi ra Jesús sihin ra: Tatu ma ndyehe ndo zeña ta sa ndyityi, ma sino iñi ndo sii. ");
INSERT INTO mihNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Zoco i catyi ra ndyizo tyiño cuan sihin ra: Tata, coho vityi vityi ñi cuee ca sa cuu zehi. ");
INSERT INTO mihNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ta i catyi ra Jesús sihin ra: Cuahan ndya vehun. Sa nduvaha zehun. Tacuan ta i sino iñi ra sa catyi ra Jesús, ta i quihin ra ityi cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ta ityi cuahan ra ta i ñihi tahan muzu ra sihin ra ta catyi ra: Ñá sihi zehun. ");
INSERT INTO mihNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tacuan ta zɨquɨ i nducu tuhun ra: ¿Ñaa cuhva i quisaha nduvaha zehi? Ta i catyi muzu cuan: Icu, cuhva caa ɨɨn sa yaha ora i quita cahñi cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tacuan ta i sito ra vatyi i cuu si zuun ñi cuhva sa i catyi ra Jesús sihin ra: “Sa nduvaha zehun.” Ta i sino iñi ra cuan sii ra Jesús sihin tandɨhɨ ñiyɨvɨ sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ta ihya cuu sa cu uu sa ndyityi i zavaha ra Jesús sa quita ra Judea ta nasaa ra Galilea. ");
INSERT INTO mihNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ta sa yaha cuan ta zɨquɨ i cuu si minoo quɨvɨ sa zacahnu ñiyɨvɨ hebreo minoo vico, ta cuahan ra Jesús ndya ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ta ñuu Jerusalén iyo minoo pila sa nañi Betesda sihin zahan hebreo. Iyo ohon tahan yuvehe nu cuu quɨhvɨ ñiyɨvɨ ndya nu ndyaa si. Ndya yuñuu iyo pila cuan yatyi minoo yuhu nuzama sa nañi: Nu Quɨhvɨ Mvee Ticatyi. ");
INSERT INTO mihNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ta yatyi ñi yu pila cuan candyaa cuaha xaan ñiyɨvɨ cuhu, tañi: ñu cuaa, ta ñu coxo, ta ñu xii. Ndatu ñu sa cua canda ndutya sisi pila cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Vatyi iyo saha, noo minoo ángel ndya pila cuan ta zacanda si ndutya, ta zɨquɨ yoo ra cua quɨhvɨ si ndutya cuan sa xihna ñi, yucuan cuu ra cua nduvaha, ñaa ndɨhɨ cuii ca cuehe cuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ta yucuan ndyaa minoo ra sa oco sahun uñi cuiya sa cuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ta i ndyehe ra Jesús sii ra candyaa ra yucuan, ta i nacoto ra vatyi sa naha xaan tahan ra tacuan, ta i nducu tuhun ra sii ra: ¿Atu cuñun nduvohon? catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","I nacahan ra cuhu cuan ta catyi ra: Tata, yoñi sa cua tyihi sii sisi ndutya ya cuhva sa canda si. Tandɨhɨ saha cuñi quɨhvi, zoco quɨhvɨ inga ra sa xihna ñi. ");
INSERT INTO mihNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tacuan ta i catyi ra Jesús sihin ra: Nduviton; natuun yuun ta cacon. ");
INSERT INTO mihNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ta zuun ñi caa cuhva cuan ndaha nduvaha ñi ra, ta i natuu ra yuu ra ta quisaha sica ra. Ta quɨvɨ cuan, minoo quɨvɨ quitatu ñiyɨvɨ cuu si. ");
INSERT INTO mihNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yucuan cuenda i catyi ñiyɨvɨ hebreo sihin ra nduvaha cuan: Vityi cuu quɨvɨ quitatu yo. Ña tahan si cuizon yuun. ");
INSERT INTO mihNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ta i nacahan ra sa nduvaha cuan ta catyi ra: Ra zanduvaha sii, i catyi ra: “Nacuhun yuun ta cacon.” ");
INSERT INTO mihNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tacuan ta zɨquɨ i nducu tuhun ñiyɨvɨ sii ra sa nduvaha cuan ta catyi ñu: ¿Ta yoo ra cuu ra sa i catyi suhun vatyi nacuhun yuun ta cacon? ");
INSERT INTO mihNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Zoco ña sito ra sa nduvaha cuan yoo ra zanduvaha sii ra vatyi sa quɨhvɨ ra Jesús tɨcuɨ ñiyɨvɨ, ta cuaha xaan ñiyɨvɨ yucu yucuan. ");
INSERT INTO mihNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ta cuee ca i nañihi ra Jesús sii ra sisi vehe ñuhu, ta i catyi ra sihin ra: Ndyehe vityi vatyi sa nduvohon. Ma zavaha con cuatyi, coto quisi inga tundoho cahnu ca zɨcun. ");
INSERT INTO mihNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tacuan ta zɨquɨ cuahan ra cuan, ta i nacatyi ra sihin ñiyɨvɨ hebreo vatyi ra Jesús cuu ra i zanduvaha sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ta yucuan cuenda i cuxaan xaan ñiyɨvɨ hebreo sihin ra Jesús ta i cuñi cahñi ñu sii ra vatyi i zavaha ra cuhva cuan quɨvɨ quitatu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Zoco i catyi ra Jesús sihin ñu: Tandɨhɨ tyiemvu zatyiño ra Ndyoo Zuti, ta yuhvi zatyiño tuqui. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ta yucuan cuenda cuñi xaan ca ñiyɨvɨ hebreo sa cahñi ñu sii ra Jesús vatyi ña tyaa ra yahvi ley sa cuenda quɨvɨ quitatu ñiyɨvɨ, ta catyi tucu ra vatyi ra Ndyoo cuu Zutu ra ta zacuu ra sa ɨɨn ñi ra cuu ra sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tacuan ta zɨquɨ i catyi ra Jesús: Sa ndisa catyi sihin ndo vatyi ñahñi sa cuu zavaha ra cu Zehe ra Ndyoo sa maa ñi maa ra. Zavaha ra cuhva sa ndyehe ra vatyi zavaha Zutu ra, vatyi tandɨhɨ cuhva zavaha ra Ndyoo Zutu ra, ta tacuan tucu zavaha Zehe ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Cuñi xaan ra Ndyoo Zutu yo sii Zehe ra, ta zañaha ra sii ra tandɨhɨ cuii sa zavaha maa ra. Ta cua zañaha tucu ra inga cuhva cahnu ca sii Zehe ra, tacuan ta iyo xaan cua cuñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Vatyi tañi tuhva ra Ndyoo Zutu yo zanandoto sii ñiyɨvɨ i sihi ta saha ra sa cundito ñu, ta tacuan tucu Zehe ra, saha ra sa cundito yoo ñiyɨvɨ cuñi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ta Ndyoo Zutu yo, ña tyicuhva ra sii ñiyɨvɨ. Saha ra tandɨhɨ cuhva cuan sii Zehe ra sa tyicuhva ra sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tacuan i zavaha ra Ndyoo vatyi cuñi ra sa cua zacahnu ñiyɨvɨ sii Zehe ra tañi zacahnu ñu sii ra Ndyoo Zutu ra. Ñiyɨvɨ ña zacahnu sii Zehe ra Ndyoo, ña zacahnu tucu ñu sii Zutu ra vatyi maa ra i tasi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Sa ndisa catyi sihin ndo: Ra sa siñi sa quehin ta sino iñi ra sii ra i tasi sii, cua cundito ra tandɨhɨ cuii tyiemvu. Ma tasi tuñi ca ra Ndyoo sii ra. Ma cuu cuii añima ra, cua cundito ra tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sa ndisa catyi sihin ndo vatyi sa cua saa cuhva, ta vityi cuu si, ta iyo ñiyɨvɨ tañi sa sihi ñu sa cuenda cuatyi ñu zoco cua cuɨñɨ ñu sa cahan Zehe ra Ndyoo. Ta ñiyɨvɨ tyaa yahvi, cua cundito ñu tandɨhɨ cuii tyiemvu sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Vatyi iyo cuhva sii Ndyoo Zuti sa cuhva ra sa cundito ñiyɨvɨ tandɨhɨ cuii tyiemvu. Ta tacuan tucu i saha ra sii Zehe ra sa cuhva ra sa cundito ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ta i saha tucu ra Ndyoo cuhva sii Zehe ra vatyi zandaa ra tyiño cuenda ñiyɨvɨ vatyi ra i quisi ndya gloria cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma iyo xaan cuñi ndo vatyi quehin tuhun ya vatyi cua saa cuhva ta tandɨhɨ ñiyɨvɨ i sihi cua cuɨñɨ ñu sa cahan Zehe ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ta cua quita ñu sisi ñaña. Ñiyɨvɨ i zavaha sa vaha, cua nandoto ñu ta cua cundito ñu. Zoco ñiyɨvɨ i zavaha sa ña vaha, cua nandoto ñu ta cua ndoho ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","(Cahan ca ra Jesús ta catyi ra:) Ñahñi sa cuu zavehi sa maa ñi mi. Cuhva catyi maa ra Ndyoo sihin, ta tacuan zandei tyiño cuenda ñiyɨvɨ. Ta ndoo xaan cuu cuhva zandei tyiño vatyi ña nduqui cuhva zavehi cuhva cuñi mi, zoco zavehi cuhva cuñi ra i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tatu zuun ñi mi saha sa ndaa sa cuende, ña sito ñiyɨvɨ tatu quehin sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Zoco iyo inga ra saha sa ndaa sa cuende, ta site vatyi ndisa cuu sa ndaa sa saha ra sa cuende. ");
INSERT INTO mihNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","I tasi ndo tyiño, ta i nducu tuhun ndo sii ra Juan. Ta cuhva i catyi maa ra, sa ndisa cuu si. ");
INSERT INTO mihNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Zoco ña siñi ñuhu sa cuhva ñiyɨvɨ sa ndaa sa cuende. Zoco catyi cuhva ya vatyi cuñi sa cua cacu ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","I cuu ra Juan tañi minoo lámpara. Cayu si ta zandisi si. Ta zɨɨ xaan i cuñi ndo zuhva quɨvɨ sihin ñúhu i saha maa ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Zoco iyo minoo sa ndaa sii. Ñiñi ca si ta zɨquɨ sa ndaa sa saha ra Juan. Zuun ñi cuhva zavehi cuu sa ndaa. Ta zañaha si vatyi i tasi ra Ndyoo Zuti sii, sa ndisa. Ta maa ra cuu ra i catyi vatyi zavehi cuhva ya ta zandehi sii si. ");
INSERT INTO mihNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ta ra Ndyoo Zuti, ra i tasi sii, cahan tucu ra sa cuenda mi. Tañaha ca cuɨñɨ ndo sa cahan ra a ndyehe ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ta ñahñi tuhun ra iyo añima ndo vatyi ña sino iñi ndo sii ra i zaquisi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nanducu xaan ndo sisi tutu Tuhun Ndyoo vatyi sica iñi ndo vatyi yucuan cua nañihi ndo cuhva cacu añima ndo ta ma cuu cuii ndo. Ta zuun ñi yucuan cuu nu saha si sa ndaa sa cuende. ");
INSERT INTO mihNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Zoco ña cuñi ndo sino iñi ndo sii ta ñihi ndo sa cundito ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ña sica xaan iñi tatu tahan iñi ñiyɨvɨ sii a ña tahan iñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Zoco sa site sii ndo, ta site vatyi ña cuñi ndo sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Vasi sa cuenda ra Ndyoo Zuti, ta ña sino iñi ndo sii. Zoco tatu cua quisi inga ra sa cuenda sa zuun ñi maa ra, sii maa ra cuan cua sino iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Yozo caa cuu sino iñi ndo? Ma cuu vatyi saha ndo sa zacahnu ñiyɨvɨ sii ndo ta zacahnu ndo sii ñu. Ta sii sa minoo ñi ra cuu Ndyoo, ña nanducu ndo cuhva cuzɨɨ iñi maa ra sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma caca iñi ndo vatyi yuhvi cua tyei cuatyi sata ndo nuu ra Ndyoo Zuti. Iyo minoo ra sa tyaa cuatyi sata ndo. Zuun ñi maa ra Moisés cuu ra. Ta nɨɨ xaan iñi ndo vatyi maa ra cua zacacu sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Zoco tatu sa i sino iñi ndo sa ndisa cuhva cahan ra Moisés, ta vityi cua sino iñi ndo sii, vatyi i tyaa ra Moisés sa cuende. ");
INSERT INTO mihNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Zoco tatu ña sino iñi ndo sa i tyaa ra, zuun ñi cuhva cuan ma cuu sino iñi ndo sa quehin. (Catyi ra Jesús sihin ñiyɨvɨ hebreo cuan.) ");
INSERT INTO mihNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ta sa ndɨhɨ cahan ra Jesús tuhun cuan, ta zɨquɨ cuahan ra ndya inga siyo miñi cahnu sa nañi Galilea. Ta inga zɨvɨ si cuu Tiberias. ");
INSERT INTO mihNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ta cuaha xaan ñiyɨvɨ ndyico sii ra vatyi i ndyehe ñu sa ndyityi i zavaha ra sihin ñiyɨvɨ cuhu nu i zanduvaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ta i ndaa ra Jesús minoo yucu, ta yucuan i sicundyaa ra sihin ra i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ta sa cuñi tahan si quɨvɨ coo minoo vico cuenda ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ta nandyehe ra Jesús vatyi cuaha xaan ñiyɨvɨ ndyico sii ra, ta i catyi ra sihin ra Felipe: ¿Ndyamaa cua zata yo sa casi ñiyɨvɨ ya? ");
INSERT INTO mihNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tacuan i catyi ra vatyi cuñi ra ndyehe ra ñaa sa cua catyi ra Felipe vatyi sa sito ra Jesús ñaa sa cua zavaha ra. ");
INSERT INTO mihNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tacuan ta i catyi ra Felipe sihin ra: Vazu uñi mil peso pan, zoco ma ñihi si casi ñiyɨvɨ zuhva zuhva ñi. ");
INSERT INTO mihNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ta ra Andrés, minoo ra i casi ra Jesús cuu ra ta yañi ra Simón Pedro, ta maa ra Andrés cuan i catyi: ");
INSERT INTO mihNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Iyo minoo ra luhlu ihya; ndyizo ra ohon tahan pan ta uu tahan tyiyaca. Zoco ñahñi ñi cuu si cuan nuu sa cuaha xaan ñiyɨvɨ ya. ");
INSERT INTO mihNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tacuan ta zɨquɨ i catyi ra Jesús: Catyi ndo sihin ñiyɨvɨ vatyi nacundyaa ñu. Catyi ra. Ta iyo cuaha cuhu yucuan, ta i sicundyaa ñiyɨvɨ tañi ohon mil sa maa ñi rayɨɨ (ta zɨquɨ ca ñu zɨhɨ ta sa ndyihi). ");
INSERT INTO mihNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tacuan ta i quihin ra Jesús pan cuan, ta sa yaha saha ra tyahvi ndyoo sii ra Ndyoo ta zɨquɨ i saha ra sii si sii ra i casi ra. Ta i zasa ra cuan sii si sii ñiyɨvɨ yucu yucuan. Ta tacuan tucu i zavaha ra sihin tyiyaca cuan. I saha ra ndya cuhva ndya sa ndaha iñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ta sa ndaha iñi ñu ta catyi ra Jesús sihin ra i casi ra: Naquihin ndo sa nandoo, ta tacuan ta ñahñi si cua tɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tacuan ta i naquihin ra sii si, ta i zacutu ra usi uu tahan tyica sihin yɨquɨ pan cuan sa nandoo ta sa ndɨhɨ sasi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ta sa ndyehe ñiyɨvɨ cuan sa ndyityi i zavaha ra Jesús, i catyi ñu: Ndisa cuii vatyi ihya ra cuu ra sa ndyaa tyiño sa quisi ra ñuu ñiyɨvɨ ta cahan ra Tuhun Ndyoo. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ta i tuu iñi ra Jesús vatyi cuñi ñu quisi tɨɨn ñu sii ra ta zañiñi ñu sii ra vatyi cuu ra minoo rey, ta sa sito ra cuhva cuan i quita ra yucuan ta cuahan ra minoo yucu maa ñi maa ra. ");
INSERT INTO mihNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ta sa cuaa cuan cuahan ra i casi ra Jesús ndya yuhu miñi cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ta i quɨhvɨ ra minoo barco, ta i quisaha yaha zava ra miñi cuan vatyi cuñi ra cuhun ra ñuu Capernaum. Ta sa cuaa cuu si cuhva cuan, ta tañaha ca nasaa ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ta ñihi xaan i quisaha canda ndutya vatyi ñihi xaan ñoho tatyi. ");
INSERT INTO mihNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ta cuhva sa i yaha ra tañi minoo ohon a iñu kilómetro, tacuan ta zɨquɨ i ndyehe ra sii ra Jesús. Sica ra nu ndutya, ta tuhva ra sii barco cuan. Ta i yuhu xaan ra i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Zoco i catyi ra Jesús: Zuun yuhvi cui. Ma yuhu ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tacuan ta zɨquɨ i cuñi xaan ra i casi ra vatyi naquɨhvɨ ra Jesús sisi barco. Ta sa i quɨhvɨ ra, ta yatyi cuii ñi i saa tu nu cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Cundisi inga quɨvɨ ta i sito ñiyɨvɨ sa nandoo inga siyo miñi cuan vatyi sa cuahan ra i casi ra Jesús sihin sa minoo barco sa sindyaa yucuan, ta ña cuahan ra Jesús sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Zoco cuhva cuan ta i saa inga ca barco, yutu i quita ñuu cahnu Tiberias. I saa tu yatyi ñi nu i sasi ñiyɨvɨ pan sa yaha saha ra Jesús tyahvi ndyoo sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tacuan ta sa ndyehe ñiyɨvɨ vatyi yoñi ra Jesús yucuan ta nu ra i casi ra, tacuan ta zɨquɨ i quɨhvɨ ñu sisi barco sa i saa cuan, ta cuahan ñu ndya ñuu Capernaum cua nanducu ñu sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ta sa i saa ñiyɨvɨ inga siyo miñi cuan, i nañihi ñu sii ra Jesús ta nducu tuhun ñu: Maestro, ¿ama i soon ihya? Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ta i catyi ra Jesús sihin ñu: Sa ndisa catyi sihin ndo, nanducu ndo sii vatyi i sasi ndo, ta ndaha iñi ndo. Yɨvɨ sa cuenda vatyi i cutuñi iñi ndo sa ndyityi i zavehi. ");
INSERT INTO mihNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ma zatyiño ndo maa ñi sa cuenda ndyayu sa cua casi ndo vatyi cunaa si cuan. Vaha ca zatyiño ndo sa cuenda ndyayu sa cua coo tandɨhɨ tyiemvu, ndyayu sa cua cuhva sa cundito ndo tandɨhɨ tyiemvu. Ihya ndyayu cua cuhva ra i quisi ndya gloria vatyi maa ra Ndyoo Zutu yo saha cuhva cuan sii ra sa cuhva ra. (Tacuan i catyi ra Jesús.) ");
INSERT INTO mihNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tacuan ta i nducu tuhun ñiyɨvɨ sii ra: ¿Ñaa sa cuñi si zavaha ndi ta cua zavaha ndi tandɨhɨ cuii cuhva cuñi ra Ndyoo? Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ta i nacahan ra Jesús ta catyi ra sihin ñu: Ihya cuu sa cuñi ra Ndyoo zavaha ndo. Sino iñi ndo sii ra i tasi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tacuan ta zɨquɨ i nducu tuhun ñu sii ra: ¿Ñaa zeña cua zañohon sii ndi ta ndyehe ndi ta sino iñi ndi suun? ¿Ñaa sa cua zavohon? ");
INSERT INTO mihNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ñiyɨvɨ sahnu sii ndi ta sa naha, i sasi ñu maná sisi cuhu tañi catyi tutu ra Ndyoo: “Saha maa ra Ndyoo pan sa quisi ndya ityi zɨquɨ vatyi casi ñu.” ");
INSERT INTO mihNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tacuan ta i catyi ra Jesús sihin ñu: Sa ndisa catyi sihin ndo vatyi yɨvɨ ra Moisés saha pan sa quisi ndya ityi zɨquɨ. Ra Ndyoo Zuti cuu ra saha pan sa cuu pan sa quita ityi zɨquɨ sa ndisa cuii. ");
INSERT INTO mihNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Vatyi pan sa saha maa ra Ndyoo cuu ra i quita ndya andɨvɨ ta saha ra sa cundito ñiyɨvɨ ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tacuan ta i catyi ñiyɨvɨ sihin ra: Tata, cuhva pan cuan sii ndi tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ta i catyi ra Jesús sihin ñu: Yuhvi cui pan sa saha sa cundito ñiyɨvɨ. Ñiyɨvɨ cua sino iñi sii, ma cuzoco ca ñu ndaha ñi. Ta ma cu‑ityi ca ñu numinoo saha. ");
INSERT INTO mihNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Zoco tañi sa catyi sihin ndo vatyi vazu sa ndyehe ndo sii, zoco ña sino iñi ndo sii. ");
INSERT INTO mihNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tandɨhɨ ñiyɨvɨ sa saha ra Ndyoo Zuti sii, cua sino iñi ñu sii. Ta ñu sino iñi sii, ma tave sii ñu ityi sata. ");
INSERT INTO mihNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Vatyi ña quite ndya gloria sa zavehi cuhva cuñi mi, zoco vasi vatyi cua zavehi cuhva cuñi ra i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ta ihya cuu sa cuñi ra i tasi sii vatyi ma zacunei numinoo ñiyɨvɨ sa i saha ra sii. Zoco cua zanandote sii tandɨhɨ ñu quɨvɨ cua tyicuhva ra Ndyoo sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Cuhva cuñi ra Ndyoo Zuti cuu, tandɨhɨ ñiyɨvɨ sa ndyehe sii Zehe ra ta sino iñi ñu sii ra, cua cundito ñu tandɨhɨ tyiemvu. Ta cua zanandote sii ñu quɨvɨ cua tyicuhva ra Ndyoo sii ñiyɨvɨ. Tacuan i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ta sa ndɨhɨ cahan ra tacuan, ta zɨquɨ i quisaha natuhun xaan ra hebreo vatyi catyi ra Jesús: “Yuhvi cui pan sa i quita ndya andɨvɨ.” ");
INSERT INTO mihNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ta i catyi ñu: ¿Atu yɨvɨ ra Jesús cuu ra ya, zehe ra José? Sito yo sii zutu ra ta sii zɨhɨ ra. ¿Ñacu catyi ra vatyi ra i quita ndya andɨvɨ cuu ra? ");
INSERT INTO mihNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tacuan ta i catyi ra Jesús: Ma natuhun tahan xaan ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yoñi sa cuu sino iñi sii tatu ma tyindyee ra Ndyoo Zutu yo sii ra cuan. Ra Ndyoo i tasi sii. Ta cua zanandote sii ñiyɨvɨ cuan quɨvɨ cua tyicuhva ra Ndyoo sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sisi libro i tyaa ra profeta catyi si tyehen: “Cua zacuaha ra Ndyoo sii tandɨhɨ ñu.” Catyi si. Tacuan cu si, ta tandɨhɨ ñiyɨvɨ sa siñi ta cutuhva ñu sa zacuaha ra Ndyoo Zutu yo, cua sino iñi ñu sii. ");
INSERT INTO mihNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yoñi numinoo ñiyɨvɨ sa ndyehe sii ra Ndyoo Zutu yo. Minoo tuhun ñi ra i ndyehe cuu ra i quita ndya nu ndyaa ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sa ndisa catyi sihin ndo vatyi ra sa sino iñi sii, sa ñihi ra sa cundito ra tandɨhɨ tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yuhvi cui pan sa saha sa cundito ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","I sasi ñiyɨvɨ sahnu sii ndo maná sisi cuhu, zoco sihi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ta quehin tuhun pan sa quisi ndya andɨvɨ vatyi cua casi ñiyɨvɨ sii si, ta ma cuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ta yuhvi cui pan ndito sa i quita ndya andɨvɨ. Ta ñiyɨvɨ sa cua casi pan ya, cua cundito ñu tandɨhɨ cuii tyiemvu. Ta pan sa cua cuhve cuu coño ñuhi. Cua cuhve sii si vatyi tacuan ta cua cundito ñiyɨvɨ sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tacuan i catyi ra Jesús, ta zɨquɨ i quisaha natuhun tahan xaan ra hebreo sihin tahan ra ta catyi ra: ¿Yozo caa cuu cuhva ra ya coño ñuhu ra casi yo? ");
INSERT INTO mihNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tacuan ta i catyi ra Jesús sihin ra: Sa ndisa catyi sihin ndo vatyi tatu ma casi ndo coño ñuhu ra i quisi ndya gloria ta coho ndo nɨñɨ ra, ma cundito añima ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ñiyɨvɨ sa cua casi coño ñuhi ta coho ñu nɨñi, cua cundito añima ñu, ta cua zanandote sii ñu quɨvɨ cua tyicuhva ra Ndyoo sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Vatyi coño ñuhi cuu sa ndisa ndyayu, ta nɨñi cuu sa ndisa sa coho ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ñiyɨvɨ sa cua casi coño ñuhi ta coho ñu nɨñi, ɨɨn ñi cua cuu ñu sihin, ta ɨɨn ñi cua cui sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tañi sa tasi ra Ndyoo ndito sii ta ndite sa cuenda ra, ta zuun ñi cuhva, ñiyɨvɨ sa cua casi coño ñuhi, cua cundito añima ñu sa cuenda mi. ");
INSERT INTO mihNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ta ihya cuu pan sa i quita andɨvɨ. Ña iyo si tañi maná sa sasi ñiyɨvɨ sahnu sii ndo ta sihi ñu; vatyi ñiyɨvɨ cua casi pan sa quehin tuhun, cua cundito ñu tandɨhɨ cuii tyiemvu sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","I zacuaha ra Jesús cuhva ya nu titahan ñiyɨvɨ sisi vehe ñuhu ñuu Capernaum. ");
INSERT INTO mihNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ta sa i siñi ñiyɨvɨ ndyico sii ra Jesús cuhva cahan ra ta cuaha xaan ñu catyi ñu: Yɨɨ xaan cuhva cahan ra. Yoñi sa cuu cutuñi iñi sa cahan ra. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Zoco i tuu iñi ra Jesús cuhva natuhun tahan xaan ñu ndyico sii ra sa cuenda cuhva i cahan ra, ta i catyi ra sihin ñu: ¿Atu ña tahan iñi ndo tuhun cuan? ");
INSERT INTO mihNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Ta yozo caa tatu ndyehe ndo sii ra i quita ndya gloria nandaa tucu ra ndya nu i quita ra? ¿Ñaa sa cua caca iñi ndo? ");
INSERT INTO mihNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tatyi Ii cuu sa saha sa cundito añima ñiyɨvɨ. Ñahñi tyindyee coño ñuhu ñu. Tuhun quehin sihin ndo cuu sa cuenda añima ndo, ta saha si sa cundito añima ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Zoco iyo zuhva ndo sa ña sino iñi ndo. Tacuan catyi ra Jesús vatyi sa sito ra ndya sa xihna ñi yoo ñu cuu ñu sa ña sino iñi ta yoo ra cua xico tuhun sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ta i catyi ra: Yucuan cuenda catyi vatyi yoñi numinoo ndo ta cuu sino iñi ndo sii tatu ma cuhva ra Ndyoo Zuti cuhva cuan sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ta sa ndɨhɨ cahan ra Jesús cuhva cuan, ta cuaha ñiyɨvɨ ndyico sii ra, i zandoo ñu sii ra ta ñá sindyico ca ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tacuan ta zɨquɨ i catyi ra Jesús sihin sa usi uu tahan ra i casi ra: ¿Atu cua cuhun ndɨhɨ tucu ndoho? ");
INSERT INTO mihNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ta i nacahan ra Simón Pedro ta catyi ra: Tata, ¿Yoo sihin cuhun ndi? Moo cuu ra nacatyi sihin ndi yozo caa cua ñihi ndi sa cundito ndi tandɨhɨ tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ta sa sino iñi maa ndi ta nacoto vaha ndi vatyi yoho cuu ra Cristo, zehe ra Ndyoo ndito. ");
INSERT INTO mihNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ta i nacahan ra Jesús ta catyi ra: I casi sii ndo sa usi uu tahan ndo, ta minoo ndo cuu minoo cuihna. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","I cahan ra Jesús cuhva ya sa cuenda ra Judas Iscariote zehe ra Simón vatyi maa ra cuu ra cua xico tuhun sii ra. Ta minoo sa usi uu tahan ra i casi ra cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ta sa yaha cuhva cuan ta i sica noo ra Jesús nu cu si Galilea. Ña cuñi ca ra caca noo nu cu si Judea vatyi cuñi cahñi ra hebreo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ta sa cuñi tahan si quɨvɨ zacahnu ñiyɨvɨ hebreo minoo vico nu zavaha ñu vehe tyiyahva. ");
INSERT INTO mihNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ta i catyi yañi ra Jesús sihin ra: Quiton ihya ta cuhun ndya Judea vatyi tacuan ta cua ndyehe ñiyɨvɨ sino iñi suun ityi cuan tyiño zavohon. ");
INSERT INTO mihNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vatyi tatu cuñi minoo ra sa cua coto ñiyɨvɨ sii ra, ñahñi sa xehe zavaha ra. Tatu zavohon cuhva ya, zavohon sii si nuu tandɨhɨ ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tacuan catyi yañi ra vatyi nu yañi ra ta ñá sino iñi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tacuan ta zɨquɨ i catyi ra Jesús sihin ra: Ta saa ca quɨvi, zoco sa cuenda maa ndo ta cuu ndya vaha ñi maa quɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ma cuu cuxaan ñiyɨvɨ sihin maa ndo, zoco cuxaan xaan ñu sihin mi vatyi nacatyi sa ña vaha sa zavaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cuahan maa ndo vico. Ma cuhin vityi vatyi ta saa ca cuhva cuhin. ");
INSERT INTO mihNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tacuan i cahan ra Jesús sihin ra, ta i ndoo ra Galilea. ");
INSERT INTO mihNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ta sa cuahan yañi ra, ta zɨquɨ cuahan tucu ra Jesús, zoco ña cuahan ndisi ra. Cuahan xehe ñi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ta i nanducu ra ndyaca ñaha sii ñiyɨvɨ hebreo sii ra vico cuan, ta catyi ra: ¿Ndyamaa iyo ra cuan? ");
INSERT INTO mihNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ta natuhun tahan xaan tandɨhɨ ñiyɨvɨ sa cuenda ra. Iyo ñu catyi ñu: “Vaha ñiyɨvɨ cuu ra.” Ta inga ñu catyi: “Ña vaha ra. Zandavi ñaha xaan ra sii ñiyɨvɨ.” Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Zoco xehe ñi cahan ñiyɨvɨ sa cuenda ra vatyi yuhu ñu sii ra ndyaca ñaha hebreo. ");
INSERT INTO mihNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ta sa yaha zava vico cuan, ta zɨquɨ i quɨhvɨ ra Jesús vehe ñuhu cahnu cuenda ñu hebreo ta quisaha zacuaha ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ta iyo xaan i cuñi ra hebreo ta catyi ra: ¿Yozo caa sito xaan ra ya ta ñá sahan ra zɨcuela? ");
INSERT INTO mihNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","I nacahan ra Jesús ta catyi ra: Cuhva zacuehi, yɨvɨ sa cuenda ñi mi cuu. Cuenda ra i tasi sii cuu si. ");
INSERT INTO mihNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tatu cuñi minoo ndo zavaha ndo cuhva cuñi ra Ndyoo, cua coto ndo tatu cuhva zacuehi cuu sii ra Ndyoo a sa cuenda ñi mi. ");
INSERT INTO mihNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tatu cahan minoo ñiyɨvɨ cuhva sa sica ñi iñi maa ra, cuñi ra cuan vatyi zacahnu ñiyɨvɨ sii ra. Zoco ra cuñi vatyi zacahnu ñiyɨvɨ sii ra i zaquisi sii ra, cahan ra cuan sa ndisa ta ñahñi cuatyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","I saha ra Moisés ley sii ndo, zoco numinoo ndo ta ña cuñi ndo tyaa ndo yahvi sii si. ¿Ta ñaa cuenda cuñi ndo cahñi ndo sii? ");
INSERT INTO mihNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ta i nacahan ñiyɨvɨ ta catyi ñu: Iyo minoo tatyi ña vaha suun. Yoñi sa cuñi cahñi suun. ");
INSERT INTO mihNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","I nacahan ra Jesús ta catyi ra sihin ñu: I zavehi minoo sa ndyityi quɨvɨ quitatu yo, ta iyo xaan cuñi tandɨhɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","I saha ra Moisés minoo ley sa tahndya ñɨɨ xiñi xuu lee. Zoco yɨvɨ ra Moisés i quisaha sihin si. Zutu sahnu yo i quisaha sihin si ndya tyiemvu. Yucuan cuenda sahndya ndo ñɨɨ xiñi xuu lee vazu quɨvɨ quitatu yo cuu. ");
INSERT INTO mihNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ta tatu sa cuenda sa ma cumañi ley ra Moisés ta tahndya ñɨɨ xiñi xuu lee vazu quɨvɨ quitatu yo cuu, ¿ñaa cuenda cuxaan ndo sii vatyi ndaha zanduvehi sii minoo ra quɨvɨ quitatu yo? ");
INSERT INTO mihNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ma tyaa ndo cuatyi sata ñiyɨvɨ tatu ña sito vaha ndo ñaa sa zavaha ñu. Cuatu ndo ndya ndyehe vaha ndo ta zɨquɨ cahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tacuan ta zɨquɨ i quisaha nducu tuhun zuhva ñiyɨvɨ ñuu Jerusalén ta catyi ñu: ¿Atu yɨvɨ ra ihya cuu ra sa cuñi cahñi ñiyɨvɨ? ");
INSERT INTO mihNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Zoco ndyehe ndo yucuan, cahan ra nuu ñiyɨvɨ, ta ñahñi catyi ñu. ¿Atu sa sino iñi ra cu tyiño vatyi ra Cristo cuu ra? ");
INSERT INTO mihNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Zoco sito yo sii ra ya, ta sito yo ndyamaa i quisi ra. Ta quɨvɨ cua quisi ra Cristo, yoñi cua coto ndyamaa cua quisi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ta sito ra Jesús sa cahan ñu cuhva zacuaha ra sisi vehe ñuhu cahnu, ta saa xaan cahan ra ta catyi ra: Sito ndo sii, catyi ndo ta sito ndo ndya ityi i quisi, zoco ña vasi sa cuenda ñi mi. Iyo minoo ra tasi sii. Ra vaha xaan cuu ra, ta ña sito ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yuhvi site sii ra vatyi sa cuenda maa ra vasi, ta maa ra i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tacuan ta i cuñi ra tɨɨn ra sii ra Jesús, zoco yoñi tyihi ndaha sii ra vatyi ta saa ca cuhva cua tahan si sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Zoco cuaha ñiyɨvɨ sa yucu yucuan sino iñi ñu sii ra vatyi ra Cristo cuu ra, ta catyi ñu: Ma cuu zavaha inga ra cuaha ca sa ndyityi ta zɨquɨ ra ya. ");
INSERT INTO mihNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","I siñi ra fariseo cuhva natuhun ñiyɨvɨ sa cuenda ra Jesús. Ta ra fariseo ta ra zutu nahnu i zacuhun ra zandaru cuenda vehe ñuhu hebreo vatyi cua tɨɨn ra sii ra Jesús ta cuhun ra vehe caa. ");
INSERT INTO mihNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tacuan ta i catyi ra Jesús: Cua cundyei zuhva cuii ñi ca quɨvɨ sihin ndo, ta zɨquɨ cunanuhin ndya nu ndyaa ra i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Cua nanducu ndo sii, zoco ma nañihi ndo sii. Ta nu cuhin, ma cuu cuhun ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tacuan ta i catyi ra hebreo zuun ñi sihin ra tahan ra: ¿Ndyamaa cua cuhun ra ya ta ma nañihi yo sii ra? ¿Atu cua cuhun ra nu iyo ñiyɨvɨ sii yo ñuu griego, ta yucuan cua zacuaha ra? ");
INSERT INTO mihNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ta ñaa cuñi si catyi si sa catyi ra tyehen: “Cua nanducu ndo sii, ta ma nañihi ndo sii. Ta nu cua cundyei ma cuu cuhun ndo”? ");
INSERT INTO mihNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Quɨvɨ sa nducahnu xaan vico cuan, nandyaa ra Jesús, ta ñihi xaan cahan ra, ta catyi ra: Tatu iyo ndo ityi ndo, quisi ndo nu ndyei ta coho ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ñiyɨvɨ sa sino iñi sii, ndya añima ñu cua caña ndutya sa saha sa cundito ñiyɨvɨ tañi sa catyi Tuhun Ndyoo. Ta tañi yuu cahnu cua cuu ndutya cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Cahan ra Jesús cuhva ya sa cuenda Tatyi Ii. Vatyi sii ñiyɨvɨ sa sino iñi sii ra Jesús cua cuhva ra Ndyoo Tatyi Ii vatyi tañaha ca cuhva ra Ndyoo Tatyi Ii quɨvɨ cuan vatyi tañaha ca cunanuhu ra Jesús ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ta sa siñi ñiyɨvɨ cuhva cahan ra Jesús, iyo ñu catyi ñu: Ndisa cuii vatyi ra ihya cuu ra profeta, ra sa cua quisi cumañi ca sa quisi inga ra sa cua zacacu sii yo. ");
INSERT INTO mihNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ta inga ñu catyi ñu: Ihya cuu ra Cristo. Zoco inga tucu ñu catyi ñu: Yɨvɨ ra Galilea cua cuu ra Cristo. ");
INSERT INTO mihNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Catyi Tuhun Ndyoo vatyi ñiyɨvɨ ra rey David cua cuu sii ra Cristo. Belén cua cuu ñuu ra nu i cuu ñuu ra rey David. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ta yucuan cuenda ñá cuu ndu‑ɨɨn ñiyɨvɨ sa cuenda ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ta zuhva ñiyɨvɨ cuñi ñu quihin ñu sii ra cuhun ra vehe caa, zoco yoñi i tɨɨn sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tacuan ta zɨquɨ i nasaa ra zandaru cuenda vehe ñuhu nu yucu ra fariseo ta ra zutu nahnu, ta i nducu tuhun ra sii ra: ¿Ñacu ñá tɨɨn ndo sii ra? ");
INSERT INTO mihNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ta i nacahan ra zandaru ta catyi ra: Ta yoñi ca maa cahan tañi cahan ra cuan. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tacuan ta i catyi ra fariseo: Ndya sii maa ndo ta zandavi ñaha ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Atu sica iñi ndo vatyi sino iñi minoo ra ndyaca ñaha a minoo ra fariseo? Numinoo ndi ta ña sino iñi ndi sii ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Zoco ñiyɨvɨ sa ñahñi maa sito ta nu ley ta ña sito ñu, cua cuxaan xaan ra Ndyoo sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tacuan ta i cahan minoo ra sa nañi Nicodemo. Zuun ñi ra cuu ra sa i sahan nu ndyaa ra Jesús minoo sa cuaa. Ta minoo ra ndyaca ñaha cuu tucu ra sihin inga ra, ta i catyi ra sihin ra tahan ra: ");
INSERT INTO mihNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Catyi ley yo vatyi ma cuu catyi yo atu vaha a ña vaha sa zavaha minoo ra tatu ma tyizoho xihna yo sa cahan ra ta coto yo ñaa sa zavaha ra. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ta i nacahan minoo ra tahan ra ta catyi ra: Vazɨquɨ ra Galilea cuu tucu yoho vatyi cahan xoon tuhun ra. Nanducun sisi Tuhun Ndyoo, ta cua ndyehun vatyi yoñi minoo ra Galilea cua cuu ra minoo profeta. (Yucuan cuenda yɨvɨ ra cahan Tuhun Ndyoo cuu ra Jesús cuñi ra fariseo vatyi ra Galilea cuu ra Jesús.) ");
INSERT INTO mihNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tacuan ta cuanuhu minoo minoo ra ndya vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Sahan ra Jesús ndya yucu sa nañi Olivos. ");
INSERT INTO mihNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ta inga quɨvɨ ñaha ñi i nasaa tucu ra ndya vehe ñuhu cahnu, ta quisi tandɨhɨ ñiyɨvɨ nu ndyaa ra, ta i sicundyaa ra ta zacuaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tacuan ta ra cu maestro cuenda ley sihin ra fariseo i sindyaca ra sii minoo ñaha i nañihi ra sihin minoo ra ndya vaha ñi. Ta i tyaa ra sii ña mahñu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tacuan ta i catyi ra sihin ra Jesús: Maestro, i nañihi ndi sii ñaha ya sihin minoo ra ndya vaha ñi. ");
INSERT INTO mihNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nu ley ra Moisés catyi si vatyi cañi ñiyɨvɨ sii ña sihin yuu ndya cua cuu ña. ¿Ta yoho, yozo caa catyun? ");
INSERT INTO mihNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Catyi ra cuhva ya vatyi cuñi ra coto ra sii ra Jesús vatyi cuñi ra sa cua tyaa ra cuatyi sata ra. Zoco i nacañi noo ra Jesús xiñi ra ta quisaha tyaa ra nu ñuhu sihin nu ndaha ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ta ñá zaña ra cuan sa nducu tuhun ra sii ra, ta zɨquɨ i nandyehe ra Jesús sii ra ta catyi ra: Yoo ra ñahñi cuatyi iyo, nacañi xihna ca maa ra sii ña sihin yuu. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ta i nacañi noo tucu ra xiñi ra ta quisaha tyaa tucu ra nu ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ta sa siñi ra cuhva cuan, i quisaha quita minoo minoo ñi ra vatyi tuu iñi ra vatyi iyo tucu cuatyi maa ra. Xihna ca ra sahnu ca cuahan minoo minoo ra ta cuhva ndya ra ndyihi, ta i ndoo minoo tuhun ñi ra Jesús sihin ñaha cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ta sa nduvita ra Jesús ta yoñi ca ndyehe ra, minoo tuhun ñi ca ñaha cuan, ta i catyi ra: Maha, ñaha ra tyaa cuatyi saton. ¿Atu yoñi ca ra catyi vatyi iyo cuatyun? ");
INSERT INTO mihNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ta i catyi maa ña: Yoñi ca ra, tata. Ta i catyi ra Jesús: Ta nu mi ta ña tyei cuatyi saton. Cuahan, ta ma zavaha con cuatyi. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ta inga tucu saha i cahan ra Jesús sihin ñiyɨvɨ, ta catyi ra: Yuhvi cui ñúhu sii ñuu ñiyɨvɨ. Ñiyɨvɨ ndyico sii, ma caca noo ca ñu nu ñaa vatyi ndyaa ñúhu sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tacuan ta i catyi ra fariseo sihin ra: Zuun ñi moo saha sa ndaa sa cuendon, ta ña ndisa sa cohon. ");
INSERT INTO mihNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ta i nacahan ra Jesús, ta catyi ra sihin ra: Vazu sehi sa ndaa sa cuenda mi, zoco sa ndisa cuu si vatyi site ndya ityi i quisi ta ndya ityi cuhin. Zoco maa ndo ña sito ndo ndya ityi i quisi a ndya ityi cuhin. ");
INSERT INTO mihNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Maa ndo tyicuhva ndo cuhva iyo si ñuu ñiyɨvɨ ya. Zoco mi ña tyicuhve. ");
INSERT INTO mihNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Zoco tatu cua tyicuhve, minoo cuhva vaha xaan cua cuu si vatyi ña minoo tuhun ñi mi. Ra Ndyoo Zuti, ra i tasi sii, ndyaa ra sihin. ");
INSERT INTO mihNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sisi ley maa ndo, catyi tucu si vatyi sa ndaa sa saha uu tahan ñiyɨvɨ, ndisa cuu si. ");
INSERT INTO mihNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yuhvi cuu minoo ra saha sa ndaa sa cuende, ta ra Ndyoo Zutu yo, ra i tasi sii, saha ra sa ndaa sa cuende. ");
INSERT INTO mihNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tacuan ta i catyi ra fariseo sihin ra: ¿Ndyamaa iyo zutun? catyi ra. I nacahan ra Jesús ta catyi ra: Nu sii mi ta ña nacoto ndo ta nu sii Zuti. Tatu sa vatyi nacoto ndo sii, cua nacoto tucu ndo sii Zuti. ");
INSERT INTO mihNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ihya tuhun i cahan ra Jesús nu ndyaa satu nu tyihi ñiyɨvɨ xuhun sisi vehe ñuhu cahnu, zoco yoñi i tɨɨn sii ra sa cuhun ra vehe caa vatyi ta saa ca cuhva cua tahan si sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tacuan ta zɨquɨ i catyi tucu ra Jesús sihin ñu: Cua cuhin ta cua nanducu ndo sii. Zoco cua cuu ndo sa cuenda cuatyi ndo, ta ma cuu cuhun ndo nu cuhin. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tacuan ta i catyi ra hebreo: Vazɨquɨ zuun ñi maa ra cua cahñi sii ra vatyi catyi ra vatyi ma cuu cuhun yo nu cuhun ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ta i catyi ra Jesús sihin ra: Maa ndo cuu cuenda ihya. Yuhvi i quisi ndya andɨvɨ. Ra ñuu ñiyɨvɨ ya cuu maa ndo. Ta yuhvi, yɨvɨ ra ñuu ñiyɨvɨ ya cui. ");
INSERT INTO mihNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yucuan cuenda catyi sihin ndo vatyi cua cuu ndo sa cuenda cuatyi ndo. Tatu ña sino iñi ndo sii vatyi yuhvi cuu ra zacacu sii ndo, cua ndoo cuatyi ndo zɨquɨ ndo, ta cua cuu ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tacuan ta i catyi ñiyɨvɨ sihin ra: ¿Yoo ra cuun? Ta i catyi ra Jesús sihin ñu: Zuun ñi ra cui tañi sa nacatyi sihin ndo ndya quɨvɨ i quisaha quehin sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Iyo cuaha xaan sa cuñi catyi cuhva iyo ndo, ta cua catyi ñaa sa cuu cuatyi ndo. Ta ra i tasi sii, ñahñi sa vatya iyo sii ra. Ta ihya ñuu ñiyɨvɨ nacatyi tuhun cuhva i siñi cuhva catyi maa ra. Tacuan i catyi ra Jesús sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Zoco ñá cutuñi iñi ñiyɨvɨ vatyi cahan ra sa cuenda Ndyoo Zutu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tacuan ta zɨquɨ i catyi ra Jesús sihin ñu: Quɨvɨ cua cañihi ndo sii ra i quisi ndya gloria, ta zɨquɨ cua coto ndo vatyi yuhvi cuu ra. Ta ñahñi sa zavehi sa cuñi ñi mi, zoco tañi sa zacuaha Zuti sii ta tacuan quehin. ");
INSERT INTO mihNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ta ra i tasi sii, ndyaa ra sihin. Ña zandoo maa tuhun ra sii vatyi tandɨhɨ saha zavehi cuhva cuñi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ta sa ndɨhɨ cahan ra Jesús tuhun ya, ta cuaha xaan ñiyɨvɨ i sino iñi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tacuan ta zɨquɨ i catyi ra Jesús sihin ñiyɨvɨ hebreo, ñu sino iñi sii ra: Tatu ma zaña ndo tuhun zacuehi sii ndo, cua cuu ndo ñiyɨvɨ sino iñi sii mi sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ta cua coto ndo ñaa sa cuu sa ndisa, ta sa ndisa cuan cua ndasi si sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ta i nacahan ñiyɨvɨ ta catyi ñu: Ñiyɨvɨ sahnu sii ndi cuu sii ra Abraham. Tañaha ca cuu ndi muzu sii numinoo ñiyɨvɨ. ¿Ta ñaa cuenda catyun vatyi cua ndasi ndi? ");
INSERT INTO mihNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ta i nacatyi ra Jesús sihin ñu: Sa ndisa ta sa ndisa catyi sihin ndo. Tandɨhɨ ñiyɨvɨ zavaha cuatyi, muzu cuu ñu sii cuatyi cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ta ra cu muzu, ma ndoo ra vehe sitoho ra tandɨhɨ tyiemvu. Zoco zehe ra cuu sitoho cuan, ndoo ra yucuan tandɨhɨ tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tatu zehe ra cuu sitoho vehe cuan saha sa cacu ndo, cua cacu ndisa cuii ndo, ta ma cuu ca ndo muzu sii sa ña vaha. ");
INSERT INTO mihNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Site vatyi ñiyɨvɨ ra Abraham cuu sii ndo. Zoco cuñi ndo cahñi ndo sii vatyi ña cuñi ndo sino iñi ndo tuhun quehin sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Quehin cuhva sa ndyehi nu ndyaa Zuti. Ta maa ndo ndyicuu ndo cuhva catyi zutu maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ta i nacahan ñiyɨvɨ, ta catyi ñu sihin ra: Zutu ndi cuu sii ra Abraham. Ta i catyi ra Jesús sihin ñu: Tatu sa ndisa vatyi zutu ndo cuu sii ra Abraham, cua zavaha ndo cuhva i zavaha ra Abraham. ");
INSERT INTO mihNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Zoco vityi cuñi ndo cahñi ndo sii vatyi minoo ra cahan sa ndisa sihin ndo cui. Ta tuhun quehin sihin ndo, cuhva i siñi cuhva catyi ra Ndyoo cuu si. Ta cuhva cuñi maa ndo zavaha ndo, ña tacuan i zavaha ra Abraham. ");
INSERT INTO mihNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Zavaha ndo cuhva zavaha zutu ndo. Catyi ra Jesús. Tacuan ta i nacahan ñiyɨvɨ cuan ta catyi ñu: Ñá cacu maa ndi tacuan ñi. Iyo minoo ñi ra cuu zutu ndi, ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ta i nacatyi ra Jesús sihin ñu: Tatu sa vatyi ra Ndyoo cuu Zutu ndo sa ndisa, cua cuñi xaan ndo sii, vatyi ndya nu ndyaa ra Ndyoo i quite ta vasi. Ña vasi cuhva cuñi mi. Maa ra i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ña cutuñi iñi ndo tuhun quehin sihin ndo vatyi ña cuñi ndo tyizoho ndo tuhun quehin sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Zutu ndo cuu sii ra cu cuihna. Ta cuñi xaan ndo zavaha ndo sa ña vaha cuhva cuñi zutu ndo. Sahñi ra sii ñiyɨvɨ ndya ta xihna ñi ta ñahñi maa sa ndisa iyo sii ra. Cuhva cahan ra sa vatya, tacuan cahan ra vatyi tacuan cuhva iyo ra, vatyi ra vatya cuu ra ta zutu sa vatya cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ta sa cuenda sa vatyi quehin sa ndisa, ta yucuan cuenda ña sino iñi ndo sii. ");
INSERT INTO mihNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yoñi ndo cuu catyi ndo sa ndisa vatyi iyo cuatyi. Ta tatu quehin sa ndisa, ¿ñacu ña sino iñi ndo sii? ");
INSERT INTO mihNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ra cuu cuenda ra Ndyoo, tyizoho ra sa cahan ra Ndyoo. Ta yucuan cuenda ña tyizoho ndo sa catyi ra Ndyoo vatyi yɨvɨ zehe ra cuu sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ta i nacahan ra hebreo ta catyi ra: Sa ndisa cuii catyi ndi vatyi minoo ra samaritano cuun ta ñoho minoo cuihna suun. ");
INSERT INTO mihNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ta i catyi ra Jesús: Ñahñi cuihna ñoho sii. Tyei yahvi sii Zuti, zoco ña tyaa ndo yahvi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ta ña nducu xein sa zacahnu ñiyɨvɨ sii, zoco iyo minoo ra cuñi sa zacahnu ñiyɨvɨ sii. Ta cua tyicuhva ra sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sa ndisa ta sa ndisa catyi sihin ndo vatyi ñiyɨvɨ zavaha cuhva catyi, ma cuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ta i catyi ñiyɨvɨ hebreo: Vityi nacoto vaha ndi suun vatyi ñoho minoo cuihna suun. I sihi ra Abraham ta tandɨhɨ ra profeta ta sa naha. Ta catyun vatyi ma cuu ñiyɨvɨ tatu zavaha ñu cuhva catyun. ");
INSERT INTO mihNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Atu ñiñi ca cuu moo ta zɨquɨ ñiyɨvɨ sahnu sii ndi, ra Abraham? Zoco i sihi ra Abraham ta tandɨhɨ inga ra i cuu profeta ta tyiemvu. Ta yoho, ¿yoo ra cuun vatyi catyun vatyi ma cuu ndi tatu sino iñi ndi suun? ");
INSERT INTO mihNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ta i catyi ra Jesús: Tatu maa ñi mi catyi vatyi ra ñiñi cui, ña vale si. Zoco maa Zuti cuu ra catyi vatyi ra ñiñi cui. Ta zuun ñi ra cuan cuu ra catyi ndo vatyi Ndyoo ndo cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ta tañaha ca coto ndo sii ra, zoco yuhvi site sii ra. Ta tatu catyi vatyi ña site sii ra, cua cui minoo ra vatya tañi maa ndo. Zoco site sii ra, ta zavehi cuhva catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ñiyɨvɨ sahnu sii ndo, ra Abraham, zɨɨ xaan i cuñi ra vatyi cua tahan si quɨvɨ caqui. Ta i ndyehe ra sii si, ta zɨɨ xaan i cuñi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tacuan ta i catyi ra hebreo cuan sihin ra Jesús: Ta quita ca uu xico usi cuiyon, ta ¿yozo caa catyun vatyi sa ndyehun sii ra Abraham? ");
INSERT INTO mihNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ta i nacatyi ra Jesús sihin ra: Sa ndisa ta sa ndisa catyi sihin ndo vatyi cumañi ca cacu ra Abraham ta sa iye. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","(Ta i cuxaan xaan ra hebreo), ta i quihin ra yuu sa cua cañi ra sii ra Jesús. Zoco i quɨhvɨ xehe ra Jesús tɨcuɨ ñiyɨvɨ, ta i quita ra sisi vehe ñuhu cahnu cuan, ta cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ta sa cua yaha ra Jesús, ta i ndyehe ra sii minoo ra cuaa. Cuaa ra i cacu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ta i nducu tuhun ra i casi ra Jesús sii ra ta catyi ra: Maestro, ¿yoo sa zavaha cuatyi, zutu ra a zɨhɨ ra ya a zuun ñi maa ra? Vatyi ndyehe, cuaa ra i cacu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ta i catyi ra Jesús sihin ra: Yɨvɨ cuatyi ra, ta yɨvɨ cuenda ñiyɨvɨ sii ra. I tahan ra ya cuhva ya vatyi tacuan ta cua coto ñiyɨvɨ vatyi cuu sii ra Ndyoo zanduvaha ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ñiñi xaan cuñi si zavehi cuhva cuñi ra i tasi sii, nɨɨ ñi sa ndisi vatyi cua cuaa ta yoñi cua cuu zatyiño. ");
INSERT INTO mihNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nɨɨ ñi sa ndyei ñuu ñiyɨvɨ ya, tañi minoo ñúhu cui ñuu ñiyɨvɨ. Tacuan i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ta sa ndɨhɨ cahan ra cuhva cuan ta zɨquɨ i tyicu zɨɨ ra nu ñuhu. Ta i zavaha ra ndyahyu sihin zɨɨ ra, ta i tyaa ra sii si nuu ra cuaa cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ta i catyi ra Jesús sihin ra: Cuahan ta nacatyon sɨtɨ nuun nu ndyaa tanque Siloé. Zɨvɨ Siloé cuan cuñi si catyi si: I tasi suun. Ta i sahan ra cuan, ta i nacatya ra, ta sa nasaa ra ta sa cuu ndyehe ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ta ñiyɨvɨ sa ndyaa yatyi yuvehe ra ta ñiyɨvɨ sa tuhva ndyehe sii ra vatyi cuaa ra i catyi ñu: ¿Atu yɨvɨ ra ihya cuu ra sica xaan caridad? ");
INSERT INTO mihNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Zuhva ñu catyi ñu: Zuun ra cuu ra. Ta inga ñu catyi: Tañi caa ra caa. Zoco maa ra i catyi: Zuun yuhvi cui. ");
INSERT INTO mihNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yucuan cuenda catyi ñiyɨvɨ sihin ra: ¿Yozo caa i cuu vatyi i ndundisi ndyehun? ");
INSERT INTO mihNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ta i nacahan ra ta catyi ra: Minoo ra sa nañi Jesús i zavaha ra ndyahyu, ta i tyaa ra sii si sɨtɨ nui, ta i catyi ra sihin: “Cuahan cua nacatyon nuun nu ndyaa tanque Siloé.” Ta i sehin ta nacatye sɨtɨ nui, ta ndundisi ndyehi vityi. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tacuan ta i catyi ñiyɨvɨ sihin ra: ¿Ndyamaa iyo ra cuan? Ta i catyi maa ra: Ña site. ");
INSERT INTO mihNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","I quihin ñiyɨvɨ sii ra sa ndundisi ndyehe, ta sindyaca ñu sii ra nu yucu ra fariseo. ");
INSERT INTO mihNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ta quɨvɨ quitatu ñiyɨvɨ i cuu quɨvɨ i zavaha ra Jesús ndyahyu ta zanduvaha ra sɨtɨ nuu ra cuaa cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ta i nducu tuhun tucu ra fariseo sii ra nduvaha cuan ta catyi ra: ¿Yozo caa nduvaha sɨtɨ nuun? Ta i catyi ra: Ndyahyu i tyaa ra sɨtɨ nui, ta i nacatye, ta vityi ndundisi ndyehi. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tacuan ta zɨquɨ i catyi zuhva ra fariseo: Ra cuan, yɨvɨ cuenda ra Ndyoo cuu ra vatyi ña tyaa ra yahvi sii quɨvɨ quitatu yo. Ta inga ra fariseo catyi: Tatu ra iyo cuatyi cuu ra, ma cuu zavaha ra sa ndyityi tañi ya. Ta sa cuenda cuan, ta ñá cuu ndu‑ɨɨn ra fariseo. ");
INSERT INTO mihNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ta i catyi tucu ra sihin ra i nduvaha nuu inga saha: ¿Ñaa catyi moo cuenda ra i zanduvaha sɨtɨ nuun? Ta i catyi ra: Minoo ra profeta cuu ra. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Zoco ra ndyaca ñaha sii ñiyɨvɨ hebreo, ñá sino iñi ra sii ra vatyi cuaa ra ta zɨquɨ i ndundisi ndyehe ra ndya sa cana ra sii zutu ra ta sii zɨhɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ta i nducu tuhun ra sii ñu ta catyi ra: ¿Atu zehe maa ndo cuu sii ra ya? ¿Atu cuaa ra i cacu ra? ¿Ta yozo caa cuu vatyi ndundisi ndyehe ra vityi? ");
INSERT INTO mihNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ta i nacahan zutu ra ta catyi ra: Sito ndi vatyi zehe ndi cuu sii ra ta cuaa ra i cacu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Zoco ña sito ndi yozo caa vatyi ndyehe ra vityi a yoo sa zanduvaha sɨtɨ nuu ra. Sa iyo cuiya ra. Nducu tuhun ndo sii maa ra. Cuu cahan ra sa cuenda maa ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","I cahan zutu ra ta zɨhɨ ra cuhva cuan vatyi yuhu ñu sii ra ndyaca ñaha sii ñiyɨvɨ hebreo vatyi sa i yaha ndu‑ɨɨn ra cuan minoo cuhva ta catyi ra vatyi yoo ra catyi vatyi i quisi ra Jesús cuenda ra Ndyoo ma cuu ca cuhun ra vehe ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yucuan cuenda i catyi zutu ra ta zɨhɨ ra: “Sa iyo cuiya ra. Nducu tuhun ndo sii maa ra.” ");
INSERT INTO mihNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ta inga saha i cana ra hebreo sii ra i nduvaha, ta catyi ra: Zacahnun sii ra Ndyoo vatyi sito maa ndi vatyi ra iyo cuatyi cuu ra zanduvaha suun. ");
INSERT INTO mihNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ta i nacahan ra i nduvaha ta catyi ra: Ña site tatu ra iyo cuatyi cuu ra a yɨvɨ, zoco minoo ñi cuhva site vatyi ra cuaa i cui, ta vityi ndundisi ndyehi. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tacuan ta zɨquɨ i catyi ra sihin ra inga saha: ¿Ñaa sa zavaha ra suhun? ¿Yozo caa i zanduvaha ra sɨtɨ nuun? ");
INSERT INTO mihNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ta i catyi ra sihin ra: Sa nacatyi sihin ndo, ta ñá tyizoho ndo. ¿Ñaa cuenda cuñi ndo coto ndo inga saha? ¿Atu cuñi tucu maa ndo vatyi cundyico ndo sii ra? ");
INSERT INTO mihNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tacuan ta i cuxaan ra hebreo, ta catyi ra: Minoo ra ndyico sii ra cuun. Zoco maa ndi ndyico ndi sii ra Moisés. ");
INSERT INTO mihNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sito ndi vatyi i cahan ra Ndyoo sihin ra Moisés. Zoco inga ra cuan, ña sito ndi ndyamaa i quisi ra cuan. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tacuan ta i nacahan ra nduvaha cuan ta catyi ra: Ihya cuu minoo sa vaha xaan vatyi vazu ña sito maa ndo sii ra, zoco i zandundisi ra ndyehi. ");
INSERT INTO mihNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ta sito yo vatyi ña tyizoho ra Ndyoo sa cahan ñiyɨvɨ iyo cuatyi. Zoco tatu iyo minoo ra zacahnu sii ra Ndyoo ta zavaha ra cuhva cuñi ra, tyizoho ra Ndyoo sa cahan maa ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ta ndya ta sino ñuu ñiyɨvɨ, ta tañaha ca coto yo tatu iyo minoo ra sa cuu zandundisi nuu minoo ra cuaa ndya quɨvɨ i cacu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tatu sa yɨvɨ ra Ndyoo tasi sii ra cuan, ma cuu zacuu ra cuhva ya. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ta i nacahan ra hebreo ta catyi ra: Yoho sa cacun sisi tandɨhɨ nuu cuatyi, ta vityi cuñun zacuohon sii maa ndi. Ta i quihin ra sii ra, ta i tava ndyizo ra sii ra ityi sata. ");
INSERT INTO mihNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ta i sito ra Jesús vatyi i tava ndyizo ñiyɨvɨ sii ra i nduvaha. Ta i nañihi ra Jesús sii ra, ta catyi ra: ¿Atu sino iñun sii Zehe ra Ndyoo? ");
INSERT INTO mihNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ta i nacahan ra cuan ta catyi ra: ¿Yoo ra cuu ra cuan, tata? vatyi cuu sino iñi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ta i catyi ra Jesús sihin ra: Sa i ndyehun sii ra, ta zuun ra cuu sa natuhun suhun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ta i catyi ra cuan: Sino iñi suun; yoho ra ndyaca ñaha cuun. Ta i zacahnu ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ta i catyi ra Jesús: Vasi ñuu ñiyɨvɨ ya vatyi cua tyicuhve sii ñiyɨvɨ. Ta ñiyɨvɨ sa ña cuu ndyehe cua ndyehe ñu. Ta ñiyɨvɨ sa ndyehe vityi, cua nducuaa ñu. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ta tayucu zuhva ra fariseo yatyi ñi yucuan, ta siñi ra sa cahan ra Jesús ta catyi ra sihin ra: ¿Atu cuaa tucu nduhvi? ");
INSERT INTO mihNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ta i catyi ra Jesús sihin ra: Tatu sa vatyi cuaa ndo sa ndisa, ma coo cuatyi ndo. Zoco sa cuenda sa vatyi catyi ndo vatyi ndisi ndyehe ndo ta yucuan cuenda ndoo cuatyi ndo zɨquɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Sa ndisa ta sa ndisa catyi sihin ndo: Ra sa ma quɨhvɨ yu sacu, ndaa ra xiñi sacu ta quɨhvɨ ra; ra zuhu cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Vatyi ra quɨhvɨ yu sacu cuan, sitoho mvee ticatyi cuan cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ta ra zacuenda yuvehe cuan, nuña ra ta quɨhvɨ sitoho mvee. Sito mvee ticatyi zono ra nduzu ra, ta cana ra sii tɨ sihin zɨvɨ tɨ, ta quita ra, ta ndyico tɨ sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ta sa ndɨhɨ tava ra sii mvee ticatyi zono ra, maa ra cuahan ityi nuu tɨ. Ta ndyico tɨ sii ra vatyi nacoto tɨ nduzu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Zoco sii inga ra sa ña sito tɨ, ma cundyico tɨ. Cua cono tɨ sii ra vatyi ña nacoto tɨ nduzu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","I cahan ra Jesús sihin ñiyɨvɨ sihin minoo cuhva, zoco ñá cutuñi iñi ñu tuhun cahan ra sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tacuan ta zɨquɨ i cahan ra Jesús inga saha, ta catyi ra: Sa ndisa ta sa ndisa catyi sihin ndo vatyi yuhvi cui tañi yu sacu nu quɨhvɨ coyo mvee ticatyi. ");
INSERT INTO mihNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tandɨhɨ cuii ra i quisi cuee ca sa quisi mi, ra zuhu cuu ra cuan. Zoco ña tyizoho mvee ticatyi zone sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yuhvi cui yuvehe. Tandɨhɨ ñiyɨvɨ sa cua quɨhvɨ coyo, cua cacu ñu. Ta cua quita ñu, ta cua nandɨhvɨ ñu, ta cua nañihi ñu sa vaha. ");
INSERT INTO mihNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ra zuhu cuan, vasi ra vatyi zuhu ra ta cahñi ra. Vasi zatɨvɨ ra. Yuhvi vasi vatyi cuhve sa cundito ñiyɨvɨ tandɨhɨ tyiemvu ta coo vaha xaan ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yuhvi cuu ra zacuenda vaha sii ndo. Ta sehi sa cui sa cuenda mvee ticatyi zone. ");
INSERT INTO mihNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Zoco minoo ra sa cuu muzu, zatyiño ra ta iyo yahvi ra. Ndyehe ra vatyi vasi ina nduvahu, ta zandoo ra sii mvee ticatyi cuan vatyi yɨvɨ zono ra cuu sii tɨ. Ta tɨɨn ina nduvahu sii tɨ ta quɨtɨ cuatyi tɨ sii tɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ta sino ra cu muzu cuan vatyi muzu ñi cuu ra, ta ñahñi sa cuu cuñi maa ra sa cuenda mvee ticatyi cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Zoco yuhvi cuu ra zacuenda vaha. Nacote sii mvee ticatyi zone, ta nacoto tɨ sii. ");
INSERT INTO mihNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tañi nacoto Zuti sii ta nacoto tuqui sii ra. Ta sehi sa cui sa cuenda mvee ticatyi zone. ");
INSERT INTO mihNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ta iyo inga mvee ticatyi zone. Yoñi tɨ ihya. Cuñi si sa naquihin sii tɨ. Cua cuɨñɨ tɨ nduzi, ta cua ndu‑ɨɨn tɨ sihin inga tɨ, ta minoo ñi ra cua zacuenda sii tɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yucuan cuenda cuñi xaan Zuti sii, vatyi sehi sa cui, ta cuee ca ta cua nandoto tuqui. ");
INSERT INTO mihNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yoñi sa cuu cahñi sii tatu ma cuhve sa cui, zoco cua cuhve sa cui. Cuu cui, ta cuu nandoto tuqui. Ihya tyiño i saha ra Ndyoo Zuti sii. ");
INSERT INTO mihNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ta sa ndɨhɨ cahan ra Jesús tuhun ya, ta zɨquɨ ña cuu ca ndu‑ɨɨn ra hebreo sa cuenda sa i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ta i catyi cuaha xaan ra: Ñoho minoo cuihna sii ra cuan, ta zana xiñi ra. ¿Ñacu tyizoho ndo sa cahan ra? ");
INSERT INTO mihNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Zoco inga ra catyi: Cuhva cahan ra, yɨvɨ cuhva cahan minoo ra sa ñoho cuihna. ¿Atu cuu zandundisi cuihna nuu ñiyɨvɨ cuaa? ");
INSERT INTO mihNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Vico cahñi i cuu si, ta nducahnu minoo vico ñuu Jerusalén. Vico cuenda nu ndɨhɨ ndaa vehe ñuhu cahnu ta tyiemvu, ta nducahnu vico tahan cuiya cuenda si. ");
INSERT INTO mihNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ta i sica noo ra Jesús sisi vehe ñuhu cahnu cuan nu nañi si corredor ra Salomón. ");
INSERT INTO mihNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tacuan ta tyihi mahñu ra hebreo sii ra Jesús, ta i catyi ra: ¿Ndya ama ta cahan casun sihin ndi? Tatu ra Cristo cuun, catyi casun. ");
INSERT INTO mihNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ta i nacahan ra Jesús ta catyi ra: Sa i nacatyi sihin ndo, ta ña sino iñi ndo. Tyiño zavehi sa cuenda Zuti, yucuan saha sa ndaa cuende. ");
INSERT INTO mihNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Zoco ña sino iñi maa ndo vatyi yɨvɨ mvee ticatyi zone cuu sii ndo. Tañi sa nacatyi sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mvee ticatyi zone, siñi tɨ nduzi. Ta nacote sii tɨ, ta ndyico tɨ sii. ");
INSERT INTO mihNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ta sehi sa cundito tɨ tandɨhɨ cuii tyiemvu. Ta ma cuu ca tɨ. Ta yoñi ra cua tava sii tɨ sisi ndehi. ");
INSERT INTO mihNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ñiñi ca cuu Zuti ta zɨquɨ tandɨhɨ ca, ta i saha maa ra sii tɨ sii. Ta yoñi ra cuu tava sii tɨ sisi ndaha Zuti. ");
INSERT INTO mihNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yuhvi sihin Zuti ɨɨn ñi cuu ndi. ");
INSERT INTO mihNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tacuan ta i quihin ra hebreo yuu inga saha sa cua cañi ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ta i cahan ra Jesús inga saha, ta catyi ra: Sa cuaha xaan tyiño vaha zañehi sii ndo sa cuenda Zuti. ¿Ndya sa ña tahan iñi ndo ta cuñi ndo cañi ndo yuu sii? ");
INSERT INTO mihNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ta i nacahan ra hebreo ta catyi ra: Yɨvɨ sa cuenda minoo tyiño vaha i zavohon, zoco sa cuenda vatyi ña vaha cohon vatyi minoo ñiyɨvɨ ñi cuun, ta catyun vatyi ra Ndyoo cuun. ");
INSERT INTO mihNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ta i catyi ra Jesús sihin ra: Nuu tutu Tuhun Ndyoo ndyaa si nu i catyi ra Ndyoo vatyi ndyoo cuu tucu maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","I catyi ra Ndyoo vatyi ñiyɨvɨ sa tyizoho Tuhun ra cuu tañi Ndyoo. Ta ma cuu catyi Tuhun Ndyoo minoo sa ña ndisa. ");
INSERT INTO mihNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","I zandu‑ii ra Ndyoo Zuti sii ra i tasi ra ñuu ñiyɨvɨ. Ta maa ndo catyi ndo vatyi quehin ndya vaha ñi sii ra Ndyoo vatyi catyi vatyi Zehe ra Ndyoo cuu sii. ");
INSERT INTO mihNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tatu ña zavehi cuhva cuñi Zuti, ma sino iñi ndo sii. ");
INSERT INTO mihNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Zoco zavehi cuhva cuan, ta vazu ma sino iñi ndo sii, zoco sino iñi ndo sa cuenda sa vaha i zavehi. Tacuan ta cua cuu nacoto ndo. Ta cua nacoto vaha ca ndo vatyi ndyaa ra Ndyoo Zutu yo sihin, ta ɨɨn ñi cui sihin ra. Tacuan i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yucuan cuenda i cuñi tucu ra tɨɨn ra sii ra sa cuhun ra vehe caa. Zoco i quita ra ta cuahan ra, ta ñá cuu. ");
INSERT INTO mihNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ta cuahan tucu ra inga saha ndya inga siyo yuu Jordán ndya nu i zacoo ndutya ra Juan sii ñiyɨvɨ sa xihna ñi. Ta i ndoo ra yucuan. ");
INSERT INTO mihNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ta cuaha xaan ñiyɨvɨ cuahan coyo ndya nu ndyaa ra. Ta i catyi ñu: Ñahñi sa ndyityi i zavaha ra Juan, zoco tandɨhɨ cuii sa catyi ra cuenda ra ya, ta ndisa cuu si. ");
INSERT INTO mihNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ta cuaha xaan ñiyɨvɨ i sino iñi sii ra Jesús yucuan. ");
INSERT INTO mihNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","I cuhu minoo ra sa nañi Lázaro, cuhva ña María ta ña Marta. Betania cuu ñuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ta ña María cuhva ra Lázaro, zuun ñi ña cuu ña sa tyozo azetye vixi saha ra Jesús ta zana‑ityi ña sihin ixi xiñi ña minoo saha. ");
INSERT INTO mihNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tacuan ta zɨquɨ i zacuhun cuhva ra Lázaro tyiño nu ndyaa ra Jesús ta catyi ñu: Tata, cuhu ra sa cuñi xoon. ");
INSERT INTO mihNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ta sa i siñi ra Jesús tuhun cuan i catyi ra: Ma cahñi cuehe cuan sii ra. Zoco cua ndyehe ñiyɨvɨ vatyi cuu xaan zacuu ra Ndyoo, ta cua zacahnu xaan ñiyɨvɨ sii Zehe ra. Catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ta cuñi xaan ra Jesús sii ña Marta ta sii cuhu ña ta sii ra Lázaro. ");
INSERT INTO mihNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ta sa i sito ra vatyi cuhu ra ta i ndoo ra uu ca quɨvɨ nu ndyaa ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tacuan ta zɨquɨ i catyi ra sihin ra i casi ra: Cohon yo Judea inga saha. ");
INSERT INTO mihNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ta i catyi ra sihin ra: Maestro, nacaa cuñi ñiyɨvɨ hebreo yucuan cañi ñu yuu suun. ¿Atu cuhun yucuan inga saha? ");
INSERT INTO mihNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ta i catyi ra Jesús: Iyo usi uu ora sa minoo ndyiyaca. Ra sa sica noo ora, ma catyihi saha ra vatyi ndisi ndyehe ra ta zavaha ra sa vaha. ");
INSERT INTO mihNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Zoco tatu cua caca noo minoo ra sa sa cuaa ta zavaha ra sa ña vaha, cua catyihi saha ra vatyi cumañi ñúhu nu cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tacuan i catyi ra Jesús ta zɨquɨ i catyi ra: Quixi xaan ra Lázaro amigo yo, zoco cuhin cua zandoye sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tacuan ta catyi ra i casi ra: Tata, tatu quixi ra, cua nduvaha ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Zoco i cahan ra Jesús tuhun sa sihi ra, zoco i sica iñi ra i casi ra vatyi cahan ra tuhun sa quixi ndisa cuii ra ta quitatu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ta tacuan ta i catyi casi ra Jesús sihin ra: Sa sihi ra Lázaro. ");
INSERT INTO mihNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ta zɨɨ cuñi vatyi yoñi ndyaa yucuan. Vaha ca tacuan sa cuenda maa ndo vatyi cua sino ca iñi ndo. Coho yo nu catuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tacuan ta i cahan ra Tomás sa nañi Dídimo sihin inga ra i casi ra Jesús, ta i catyi ra: Coho tucu maa yo vatyi cuu yo ɨɨn ñi sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ta sa i saa ra Jesús yucuan, i sito ra vatyi sa ñoho ra Lázaro cumi quɨvɨ sisi ñaña. ");
INSERT INTO mihNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ñuu Betania cuan yatyi ñi ndyaa si sihin ñuu Jerusalén tañi uñi kilómetro zazava. ");
INSERT INTO mihNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ta i saa cuaha xaan ra hebreo; cua cuhva ra tundyee iñi sii ña Marta ta ña María vatyi sihi cuhva ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ta sa sito ña Marta vatyi vasi ra Jesús, cuahan ña cua zatahan ña sii ra. Zoco i ndoo ña María sisi vehe. ");
INSERT INTO mihNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tacuan ta i catyi ña Marta sihin ra Jesús: Tata, tatu sa vatyi ndyoon ihya, ma cuu cuhve. ");
INSERT INTO mihNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Zoco site vatyi tandɨhɨ cuii ñi sa cua cacon sii ra Ndyoo, maa ra Ndyoo cua cuhva sii si suun. ");
INSERT INTO mihNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ta i catyi ra Jesús sihin ña: Cua nandoto cuhvon. ");
INSERT INTO mihNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ta i catyi ña Marta sihin ra: Site vatyi cua nandoto ra quɨvɨ cua tyicuhva ra Ndyoo sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ta i catyi ra Jesús sihin ña: Yuhvi cuu ra zanandoto, ta sehi sa cundito ñiyɨvɨ. Ra sa sino iñi sii, vazu sa sihi ra, zoco cua nandoto ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ta ñiyɨvɨ ndito ta sino iñi ñu sii, ma cuu ca ñu. ¿Atu sino iñun cuhva ya? ");
INSERT INTO mihNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ta i catyi ña sihin ra: Ndisa tata. Sino iñi vatyi ra Cristo cuun, ta Zehe ra Ndyoo cuu suun. Ra sa cua quisi ñuu ñiyɨvɨ cuun. Catyi ña. ");
INSERT INTO mihNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ta sa sa ndɨhɨ cahan ña tacuan, ta zɨquɨ cuahan ña ta cana xehe ña sii ña María cuhu ña, ta catyi ña: Sa saa ra Maestro ta cana ra suun. ");
INSERT INTO mihNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ta sa i siñi ña María tuhun cuan, ta yatyi xaan i nduvita ña ta cuahan ña nu ndyaa ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ta tañaha ca cua quɨhvɨ ra Jesús sisi ñuu cuan. Ta cuhva ndyaa ñi ra nu tahan ña Marta sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ta ra hebreo, ra ndyaa sihin ña María vehe cuan, i ndyehe ra vatyi yatyi xaan i nduvita ña ta i cacono ña cuahan ña. Ta i sindyico ra sii ña vatyi catyi ra: Cuahan ña cua vacu ña nu ndyaa ñaña ra Lázaro. ");
INSERT INTO mihNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tacuan ta i saa ña María nu ndyaa ra Jesús, ta i sicuɨñɨ sɨtɨ ña nuu ra ta catyi ña: Tata, tatu sa vatyi ndyoon ihya sihin ndi ndya icuñuu ca, ma cuu cuhve. ");
INSERT INTO mihNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ta sa ndyehe ra Jesús vatyi sacu ña ta sacu tucu ra hebreo, ra ndɨhɨ sihin ña, ta i nducuihya xaan cuñi añima ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ta i catyi ra: ¿Ndyamaa i tyihi ndo sii ra? Ta i catyi maa ñu sihin ra: Coho, tata, vatyi cua ndyehun. ");
INSERT INTO mihNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ta i sacu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tacuan ta zɨquɨ i catyi ra hebreo: Ndyehe ndo cuhva cuñi xaan ra sii ra sihi cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Zoco i catyi inga ra: Ihya ra i zandundisi ndyehe ra cuaa cuan. ¿Ñacu ñá zavaha ra minoo cuhva ta ma cuu ra ya? ");
INSERT INTO mihNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","I quisi minoo sa ndahvi xaan cuñi ra Jesús inga saha sa ndyehe ra ñaña nu ñoho ra Lázaro. Minoo yavi yuu, i cuu si, ta ndazi minoo yuu yuhu si. ");
INSERT INTO mihNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","I catyi ra Jesús: Tyaa siyo ndo yuu ña. Ta i catyi ña Marta, cuhva ra i sihi cuan: Tata, sa iñi sahan ra vatyi sa cumi quɨvɨ sa sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ta i catyi ra Jesús sihin ña: Sa catyi suhun vatyi tatu cua sino iñun, cua ndyehun vatyi cahnu xaan cuu cuhva iyo sii ra Ndyoo, ta cuu zacuu ra tandɨhɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tacuan ta zɨquɨ i tyaa siyo ñu yuu nu ñoho ndɨyɨ cuan. Ta i nandyehe ndaa ra Jesús ityi zɨquɨ, ta catyi ra: Tyahvi ndyoo suun Ndyoo Zuti vatyi siñun sa quehin. ");
INSERT INTO mihNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ta site vatyi siñun sa quehin tandɨhɨ saha, zoco catyi tacuan sa cuenda ñiyɨvɨ sa yucu ihya vatyi tacuan ta cua sino iñi ñu vatyi moo i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ta sa ndɨhɨ cahan ra tacuan, ta zɨquɨ i cana saa ra ta catyi ra: Lázaro quita xiña. ");
INSERT INTO mihNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ta ra i sihi cuan, i quita ra. Zucu ra zahma. Ta nuhñi minoo zahma nuu ra. Ta i catyi ra Jesús sihin ñiyɨvɨ: Ndasi ndo sii ra, naquita ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tacuan ta zɨquɨ i sino iñi cuaha xaan ra hebreo, ra ndɨhɨ sihin ña María ta ndyehe ra cuhva i zavaha ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Zoco sahan zuhva ra nu yucu ra fariseo ta nacatyi ra cuhva i zavaha ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yucuan cuenda i titahan ra zutu nahnu sihin ra fariseo, ta catyi ra: ¿Yozo caa zacuu yo vatyi cuaha xaan sa ndyityi zavaha ra cuan? ");
INSERT INTO mihNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tatu cuhva yo sa zavaha ca ra tacuan, cua sino xaan iñi tandɨhɨ cuii ñiyɨvɨ sii ra. Ta cua quisi zandaru ñuu Roma ta cahñi ra sii yo ta zatɨvɨ ra ñuu yo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ta minoo ra nañi Caifás, maa ra cuu ra cu nuu sii tandɨhɨ cuii ra cu zutu cuiya cuan. Ta i catyi ra sihin ra: Ñahñi maa sa sito ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ña cutuñi iñi ndo vatyi vaha ca sa nacuu minoo tuhun ñi ra sa cuenda ñiyɨvɨ, ta yɨvɨ ca sa cuu tandɨhɨ cuii yo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ñá cahan ra cuan sihin sa siñi tuñi xiñi ñi maa ra. Ra cu nuu sii tandɨhɨ cuii ra cu zutu i cuu ra cuiya cuan. Ta vazu ña sito ra, zoco i cahan ra profecía vatyi cua cuu ra Jesús sa cuenda tandɨhɨ ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ta yɨvɨ sa cuenda sa maa ñi maa ñu, zoco cua zandu‑ɨɨn ra sii tandɨhɨ zehe ra Ndyoo, ñu indyacuan ta indyehe. ");
INSERT INTO mihNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ta ndya quɨvɨ cuan i zacasi tahan ra hebreo, ra ndyizo tyiño cuan, tyiño vatyi cua cahñi ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yucuan cuenda ñá sica noo ndisi ca ra Jesús nu yucu ra hebreo. I quita ra yucuan ta saa ra ñuu Efraín yatyi nu ndyaa minoo nu ndahvi xaan caa, sa catyi yo desierto. Ta yucuan i ndoo ra sihin ra i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ta sa cua tahan si quɨvɨ coo vico zuhun cuenda ñu hebreo. Ta i quita cuaha xaan ñu ñuu ñu, ta cuahan ñu ñuu Jerusalén cuee ca sa tahan si quɨvɨ coo vico vatyi cuñi ñu nduvaha ñu cuhva iyo costumbre maa ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ta yucuan i nanducu ñu sii ra Jesús, ta catyi ñu sihin tahan ñu nu ñoho ñu vehe ñuhu cahnu: ¿Ñaa sa sica iñi ndo? ¿Atu ma quisi ra vico ya? Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ra zutu nahnu sihin ra fariseo, sa i saha ra tyiño vatyi tatu yoo sa cua coto ndyamaa ndyaa ra Jesús cua zacoto ra sii ra cuan vatyi cua tɨɨn ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iñu quɨvɨ ca cuee ca sa tahan si vico zuhun cuan, i saa ra Jesús ñuu Betania nu iyo ra Lázaro, ra sa i sihi ta i zanandoto ra Jesús sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ta yucuan i zavaha ñu sa cuxiñi ra Jesús. I tyizo ña Marta coho nu mesa, ta ndyaa ra Lázaro sihin ra Jesús mesa. ");
INSERT INTO mihNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tacuan ta zɨquɨ i quihin ña María zava litro azetye vixi sa yahvi xaan ndyaa, ta i tyozo ña sii si saha ra Jesús, ta i zana‑ityi ña saha ra sihin ixi xiñi ña. Ta i situ cuii vehe cuan sihin xico vixi. ");
INSERT INTO mihNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ta i catyi minoo ra i casi ra Jesús, ra sa nañi Judas Iscariote zehe ra Simón, zuun ra cuu ra sa cua xico tuhun sii ra Jesús. Maa ra cuan i catyi: ");
INSERT INTO mihNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Ñacu ñá xico ñu azetye ya? ta cua ñihi ñu tañi cumi mil zazava ta tyindyee ñu sii ñiyɨvɨ ndahvi sihin si. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Zoco ñá catyi ra tacuan vatyi cuñi xaan ra sii ñiyɨvɨ ndahvi. I catyi ra tacuan vatyi minoo ra zuhu cuu ra, ta ndyizo ra yɨtɨ sa ñoho xuhun ra Jesús, ta quihin xehe ra xuhun cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tacuan ta i catyi ra Jesús: Ma cahan ca ndo sihin ña. Zavaha ña sii si cuee ca sa cui ta cuhin nuñaña. ");
INSERT INTO mihNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ñiyɨvɨ ndahvi cuan, cua coo ñu sihin ndo tandɨhɨ cuii tyiemvu. Zoco yuhvi ma cundyei sihin ndo tandɨhɨ tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ta sa ñihi ñiyɨvɨ hebreo tuhun vatyi ndyaa ra Jesús ñuu Betania, cuaha xaan ra saa coyo. Ña ɨɨn ñi sa cuenda ra Jesús i quisi ra, quisi ra vatyi cuñi ra ndyehe ra sii ra Lázaro, ra i zanandoto ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Zoco ra zutu nahnu i natuhun tahan ra yozo caa ta cuu cahñi ra sii ra Lázaro. ");
INSERT INTO mihNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Vatyi sa cuenda ra Lázaro, ta cuaha xaan ra hebreo zaña ra tuhun zacuaha ra cu zutu ta sino iñi ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ta inga quɨvɨ i saa cuaha xaan ñiyɨvɨ ñuu Jerusalén sa cuenda vico zuhun, ta sa i sito ñu vatyi vasi ra Jesús ");
INSERT INTO mihNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","i sahndya ñu ndaha tuticaha ta i quita coyo ñu ta cua zatahan ñu sii ra, ta cana saa ñu ta catyi ñu: ¡Cahnu xaan cuu ra vasi sa cuenda ra Ndyoo! ¡Rey, ra ndyaca ñaha sii yo cuu ra! Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ta i ñihi ra Jesús minoo burro luhlu, ta yozo ra sii tɨ tañi catyi si sisi Tuhun Ndyoo: ");
INSERT INTO mihNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ma yuhu ndo ñiyɨvɨ ñuu Sión; Ica rey ndo vasi ya; Yozo ra minoo burro luhlu. Tacuan catyi si. ");
INSERT INTO mihNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ña cutuñi iñi ra i casi ra Jesús cuhva ya sa xihna ñi, zoco ta sa cua nanuhu ra Jesús ndya gloria ta zɨquɨ i nacohon iñi ra i casi ra vatyi tacuan ndyaa si sa cuenda ra Jesús, ta i nacohon iñi ra vatyi tacuan i zavaha ñiyɨvɨ sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ta i saha ñiyɨvɨ sa ndaa, ñiyɨvɨ sa yucu sihin ra Jesús nu i cana ra sii ra Lázaro sisi ñaña ta i zanandoto ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ta yucuan cuenda cuaha xaan ñiyɨvɨ i zatahan sii ra Jesús vatyi sa sito ñu vatyi i zavaha ra sa ndyityi cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Zoco i catyi ra fariseo sihin tahan ra: Ndyehe ndo vatyi ma cuu ca zavaha yo ñaa sa cuñi yo sihin ra vatyi sa tandɨhɨ cuii ñiyɨvɨ sino iñi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ta yucu tucu zuhva ra griego, ra i saa sihin ñiyɨvɨ vico cuan sa cua zacahnu ra sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ta i tuhva ra sii ra Felipe ra ñuu Betsaida nu cu si Galilea, ta i catyi ra sihin ra: Tata, cuñi xaan ndi natuhun ndi sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ta i sahan ra Felipe, ta nacatyi ra sihin ra Andrés. Ta zɨquɨ i sahan ra Andrés sihin ra Felipe cua nacatyi ra sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ta i catyi ra Jesús sihin ra: Sa saa cuhva cua cui, ta ra i quisi ndya gloria cua cunanuhu ra ndya gloria. ");
INSERT INTO mihNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sa ndisa ta sa ndisa catyi sihin ndo vatyi minoo sɨtɨ trigo tatu ma canacava si nu ñuhu ma cuu si, zoco minoo tuhun ñi si cua coo sa tacuan. Ta tatu cua cuu si, cuaha xaan sɨtɨ si cua nanduu. ");
INSERT INTO mihNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ra sa cuñi coo vaha, cunaa ra sihin si. Ta inga ra tatu ndoo ra vaha vazu cahan ñiyɨvɨ sii ra sa cuenda Tuhun Ndyoo, cua coo vaha ra cuan ndya gloria, ta ma cuu añima ra. ");
INSERT INTO mihNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tatu iyo ndo cuñi ndo zatyiño ndo tyiñe, cundyico ndo sii. Ta nu cua cundyei, yucuan cua cundyaa tucu maa ndo. Ta tatu iyo ndo sa cua zatyiño ndo tyiñe, cua zacahnu Zuti sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ta vityi ndahvi xaan cuñi añime. ¿Ta ñaa sa cua catyi? ¿Atu cua catyi: “Zuti zacacun sii, sihin tundoho sa cua ndyehi vityi”? Ma catyi tacuan vatyi vasi ñuu ñiyɨvɨ sa cuenda sa cua ndyehi tundoho ya. ");
INSERT INTO mihNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Vaha ca nacatyi: “Zuti zanducahnun zɨvun.” Tacuan i catyi ra Jesús. Ta zɨquɨ i quisi minoo nduzu ndya andɨvɨ ta catyi si: Sa i zanducahnu mi zɨvi, ta cua zanducahni sii si inga saha. ");
INSERT INTO mihNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ta i siñi ñiyɨvɨ sa yucu yucuan nduzu cuan, ta i catyi ñu vatyi cahan zavi. Ta inga ñu i catyi ñu vatyi cahan minoo ángel ra Ndyoo sihin ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ta i nacahan ra Jesús ta catyi ra: Ña vasi nduzu ya sa cuenda mi. Vasi si sa cuenda maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ta vityi cua tasi tuñi ra Ndyoo sii ñuu ñiyɨvɨ ya. Ta ra ndyaca ñaha sii ñuu ñiyɨvɨ ya, vityi cua tava ra Ndyoo sii ra ityi sata. ");
INSERT INTO mihNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ta yuhvi tatu cua tyaa ñiyɨvɨ sii nu cruz, cuaha xaan ñiyɨvɨ cua sino iñi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ta sa i cahan ra Jesús tuhun ya, saha ra sa cua coto ñiyɨvɨ cuhva cua cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ta i nacahan ñiyɨvɨ ta catyi ñu: Sa siñi ndi vatyi catyi si nuu ley ra Ndyoo vatyi ra Cristo, tacuan ñi cua coo ra tandɨhɨ cuii tyiemvu. ¿Ta ñacu catyun vatyi cuñi si sa tyaa ñiyɨvɨ sii ra i quisi ndya gloria nu cruz? ¿Yoo ra cuu ra i quisi ndya gloria? ");
INSERT INTO mihNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tacuan ta zɨquɨ i nacatyi ra Jesús sihin ñu: Zuhva ñi ca cuhva cua coo ñúhu nu yucu ndo. Caca ndo nɨɨ ñi sa ndyaa ñúhu ya, coto quisi sa ñaa ta ma cuu ca caca ndo. Vatyi ra sica noo nu ñaa, ña sito ra ndya ityi cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nɨɨ ñi sa ndyaa ñúhu sihin ndo, sino iñi ndo sii ra. Vatyi tacuan ta cua cuu ndo zehe ñúhu. (Cua cuu ndo ñiyɨvɨ sa zama cuhva iyo.) Tacuan i catyi ra Jesús, ta cuahan ra ta i quɨhvɨ xehe ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Vazu sa cuaha xaan sa ndyityi i zavaha ra nuu ñiyɨvɨ cuan, zoco ñá sino iñi ñu sii ra ");
INSERT INTO mihNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","vatyi tacuan ta cua quita si tañi i catyi ra Isaías, minoo ra cu profeta, quɨvɨ i catyi ra tyehen: Tata ¿yoo ra sino iñi sa quehin? Ta ¿yoo sii i zañaha ra ndyaca ñaha sii yo cuhva cuu zacuu ra? ");
INSERT INTO mihNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yucuan cuenda ña cuu sino iñi ñu vatyi zuun ñi i catyi tucu ra Isaías: ");
INSERT INTO mihNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","I zanducuaa ra sɨtɨ nuu ñiyɨvɨ cuan, ta i zanduñihi ra iñi ñu. Ta tacuan ta ma ndyehe ñu sihin sɨtɨ nuu ñu, ta ma cutuñi iñi ñu sihin añima ñu ta nazama ñu cuhva iyo ñu, ta ma zanduvehi sii ñu. Catyi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","I catyi ra Isaías tuhun ya quɨvɨ i ndyehe ra vatyi cahnu xaan cuu maa ra Ndyoo ta tyaqui xaan ra. Ta i cahan ra cuenda ra. ");
INSERT INTO mihNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Zoco cuaha xaan ra cu tyiño ñuu cuan, i sino iñi ra sii ra Jesús. Zoco ñá saha ra sa ndaa vatyi yuhu ra sii ra fariseo coto tava ndyizo ra sii ra sisi vehe ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Vatyi cuñi xaan ca ra cuan sa tyaa ñiyɨvɨ yahvi sii ra, ta ña sica iñi ra tatu cua cuzɨɨ iñi ra Ndyoo sihin ra a ma cuzɨɨ iñi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","I cana saa ra Jesús ta catyi ra: Ra sa sino iñi sii, ña ɨɨn ñi sii mi sino iñi ra. Zoco sino tucu iñi ra sii ra i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ta ra sa ndyehe sii, ndyehe tucu ra sii ra i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Vasi ñuu ñiyɨvɨ ya tañi minoo ñúhu vatyi yoo ra sino iñi sii, ma ndoo ca ra nu ñaa. ");
INSERT INTO mihNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ta tatu sa siñi ñiyɨvɨ sa quehin ta ma tyaa ñu yahvi, ma tyicuhve sii ñu vatyi ña vasi tyicuhve. Vasi zacaqui sii ñiyɨvɨ ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ra sa ña cuñi sii mi caña ñi, ta ña tyaa ra yahvi tuhun quehin, sa iyo sa cua tyicuhva sii ra. Tuhun sa i quehin, yucuan cuu sa cua tyicuhva sii ra quɨvɨ cua tyicuhva ra Ndyoo sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Vatyi ña quehin sa cuenda ñi mi. Zuti, ra i tasi sii, i saha ra tyiño sii, tandɨhɨ cuii sa cuu nacatyi. ");
INSERT INTO mihNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ta site vatyi tyiño i saha ra sii, cuu cuhva cundito ñiyɨvɨ tandɨhɨ tyiemvu sihin ra. Yucuan cuenda tandɨhɨ cuii sa catyi sihin ndo, quehin cuhva saha Zuti tyiño sii. ");
INSERT INTO mihNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ta sa yatyi vico zuhun, ta sa sito ra Jesús vatyi sa cua tahan si cuhva quita ra ñuu ñiyɨvɨ ya ta cuhun ra nu ndyaa Zutu ra. I cuñi xaan ra sii ñiyɨvɨ sino iñi sii ra ihya ñuu ñiyɨvɨ ta cuhva cuñi ra sii ñu, ma ndɨhɨ maa si. ");
INSERT INTO mihNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ta cuhva sa cuxiñi ra, ta i quɨhvɨ cuihna añima ra Judas Iscariote zehe ra Simón, vatyi cua xico tuhun ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ta sa sito ra Jesús vatyi sa i saha Zutu ra tandɨhɨ cuii tyiño sii maa ra. Ta sa sito ra vatyi ndya nu ndyaa ra Ndyoo i quita ra, ta ndya indyacuan cua cunanuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ta cuhva sa cuxiñi ra i nduvita ra, ta i tava ra zahma sa ndisi ra, ta sihñi ra minoo toalla sisi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ta zɨquɨ i tyihi ra ndutya sisi minoo caa, ta quisaha nacatya ra saha ra i casi ra. Ta zana‑ityi ra saha ra sihin toalla sa nuhñi sisi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ta sa saa ra nu ndyaa ra Simón Pedro, i catyi ra Pedro sihin ra: Tata, ¿atu cua nacatyon sehi? ");
INSERT INTO mihNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ta i nacahan ra Jesús ta catyi ra: Ña cutuñi iñun sa zavehi vityi, zoco cuee ca cua cutuñi iñun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ta i catyi ra Pedro sihin ra: Numinoo saha ta ma nacatyon sehi caña ñi. Ta i catyi ra Jesús sihin ra: Tatu ma nacatye sohon, yɨvɨ ñiyɨvɨ sii cuu suun. ");
INSERT INTO mihNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ta i catyi ra Simón Pedro sihin ra: Tata, ña maa ñi sehi nacatyon, nacatya tucun ndehi ta xiñi. ");
INSERT INTO mihNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ta zɨquɨ i catyi ra Jesús sihin ra: Ra sa sityi, maa ñi saha ra cuñi si ndoo vatyi sa ndɨɨ maa ra. Ta sa ndɨɨ maa ndo, zoco ña tandɨhɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tacuan i catyi ra Jesús vatyi sa sito ra yoo ra cua xico tuhun sii ra. Yucuan cuenda i catyi ra: “Ña ndɨɨ tandɨhɨ ndo.” ");
INSERT INTO mihNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tacuan ta sa ndɨhɨ nacatya ra saha ra, ta i naquihin ra zahma ra, ta sicundyaa ra mesa. Ta zɨquɨ i nacatyi ra sihin ra: ¿Atu cutuñi iñi ndo cuhva i zavehi sihin ndo? ");
INSERT INTO mihNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Catyi maa ndo maestro cui, ta catyi ndo ra ndyaca ñaha cui, ta vaha cahan ndo vatyi zuun ra cui. ");
INSERT INTO mihNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tatu yuhvi cuu maestro ta ra ndyaca ñaha ta i nacatye saha ndo. Tacuan tucu maa ndo, tahan si nacatya ndo saha tahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Vatyi sa i sehi minoo cuhva sii ndo, ta cuñi si sa cua zavaha tucu ndo cuhva i zavehi sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sa ndisa ta sa ndisa catyi sihin ndo vatyi ña cahnu ca ra cu muzu ta zɨquɨ patrón ra. Ta cahnu ca cuu ra tava tyiño sii ñiyɨvɨ ta zɨquɨ ca ra cuahan sihin tyiño. ");
INSERT INTO mihNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tatu sito ndo tuhun ya, zɨɨ xaan cua cuñi ndo tatu zavaha ndo sii si. ");
INSERT INTO mihNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ña quehin sa cuenda tandɨhɨ ndo. Sa site yoo ndo i casi. Zoco cua cuu si cuhva catyi tutu Tuhun Ndyoo: “Ra sa sasi pan sihin, cua nduvita ra zɨqui.” ");
INSERT INTO mihNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ta vityi sa nacatyi sihin ndo cuee ca sa tahan si vatyi quɨvɨ cua tahan si ta cua sino iñi ndo vatyi yuhvi cuu ra sa nacatyi sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sa ndisa ta sa ndisa catyi sihin ndo vatyi ra naquihin vaha sii ra tasi, naquihin vaha ra sii. Ta ra naquihin vaha sii, naquihin vaha ra sii ra sa tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ta sa ndɨhɨ cahan ra Jesús tuhun cuan, ta i quisi minoo sa cuihya xaan cuñi añima ra, ta i catyi ra: Sa ndisa ta sa ndisa catyi sihin ndo vatyi iyo minoo ndo cua xico tuhun ndo sii. ");
INSERT INTO mihNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ta cuhva cuan i nandyehe ra i casi ra Jesús sii tahan ra vatyi ña sito ra yoo ra cuu ra cahan ra Jesús tuhun. ");
INSERT INTO mihNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ta minoo ra i casi ra Jesús, ra sa cuñi xaan ra, nañaa ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ta i saha ra Simón Pedro minoo zeña sii ra cuan sihin ndaha ra vatyi nanducu tuhun ra sii ra Jesús yoo ra cuu ra sa cahan ra tuhun. ");
INSERT INTO mihNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ta ra yucuan, i tuhva ca ra sii ra Jesús ta nducu tuhun ra: Tata, ¿yoo ra cuu ra sa cohon tuhun? ");
INSERT INTO mihNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ta i nacahan ra Jesús ta catyi ra: Cua zatyii pan, ta cua cuhve sii si sii minoo ra. Yucuan ra cuu ra. Ta sa zatyii ra Jesús pan cuan, ta i saha ra sii si sii ra Judas Iscariote, zehe ra Simón. ");
INSERT INTO mihNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ta sa ndɨhɨ sasi ra Judas pan cuan, i quɨhvɨ cuihna añima ra. Ta zɨquɨ i catyi ra Jesús sihin ra: Cuhva sa cua zavohon, zavohon sii si yatyi ca. ");
INSERT INTO mihNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Zoco ña sito numinoo ra ndyaa mesa sihin ra Jesús ñaa cuenda i cahan ra tacuan sihin ra Judas. ");
INSERT INTO mihNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Iyo ra i sica iñi ra vazɨquɨ i catyi ra Jesús: “Cuahan cua zaton ñaa sa cua cuñi si sii yo cuenda vico zuhun ya.” A catyi ra: “Cuhvon xuhun sii ñiyɨvɨ ndahvi.” Vatyi cumi ra Judas yɨtɨ sa ñoho xuhun ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ta sa ndɨhɨ sasi ra Judas pan cuan, ta zuun ñi caa cuhva cuan i nduvita ra ta cuahan ra. Ta sa cuaa ñi cuu si. ");
INSERT INTO mihNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ta sa yaha cuahan ra Judas ta zɨquɨ i catyi ra Jesús: Vityi sa tahan si cuhva vatyi cua coto ñiyɨvɨ vatyi iyo xaan cuhva sii ra i quisi ndya gloria ta cua zacahnu ñu sii ra, ta cua zacahnu xaan ñu sii ra Ndyoo sa cuenda ra. ");
INSERT INTO mihNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Vatyi tatu ra i quisi ndya gloria zañaha ra vatyi cahnu xaan cuu maa ra Ndyoo. Zuun ñi cuhva cuan cua zañaha ra Ndyoo vatyi cahnu xaan cuu maa ra cuan. Ta numi xaan cua nacoto vaha ndo sii si. ");
INSERT INTO mihNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ndoho zehe luhli, zuhva ñi ca cuhva cua cundyei sihin ndo. Cuee ca cua nanducu ndo sii, ta tañi sa i catyi sihin ra hebreo nacatyi sihin maa ndo vityi vatyi nu cuhin ma cuu cuhun ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Sehi minoo tyiño saa sii ndo vatyi cuñi ndo sii tahan ndo tañi cuñi mi sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ihya cuhva cua coto tandɨhɨ ñiyɨvɨ vatyi ndyico ndo sii, tatu cuñi ndo sii tahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ta i catyi ra Simón Pedro sihin ra: Tata, ¿ndyamaa cua cuhun? Ta i catyi ra Jesús sihin ra: Nu cuhin ma cuu cuhun sihin vityi, zoco cuee ca ta cua cuhun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ta i catyi tucu ra Pedro sihin ra: Tata, ¿ñaa cuenda ma cuu cuhin suhun vityi? Cuhin vazu cui sa cuendon. ");
INSERT INTO mihNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ta i nacahan ra Jesús ta catyi ra: ¿Atu cuu cuun sa cuende? Sa ndisa ta sa ndisa catyi suhun vatyi cuee ca sa vacu saa ndɨvɨ tyahnu ta cua catyun uñi tahan saha vatyi ña siton sii. ");
INSERT INTO mihNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","I catyi ra Jesús: Ma caca xaan iñi ndo. Sa sino iñi ndo sii ra Ndyoo. Sino tucu iñi ndo sii mi. ");
INSERT INTO mihNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Vehe Zuti, iyo cuaha xaan nu cuu cundyaa ndo. Tatu sa ña ndisa, ma nacatyi sihin ndo. Cuhin cua zanduvehi nu cua cundyaa ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ta tatu cuhin ta zanduvehi nu cua cundyaa ndo, cua quisi inga saha ta naquihin sii ndo vatyi cuhun ndo ta cundyaa ndo nu cua cundyei. ");
INSERT INTO mihNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Sito ndo ndyamaa cuehin, ta sito ndo ityi. ");
INSERT INTO mihNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ta i catyi ra Tomás sihin ra: Tata, ña sito ndi ndyamaa cuohon ¿ta yozo caa cuu coto ndi ityi? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ta i catyi ra Jesús sihin ra: Yuhvi cui ityi. Ta maa ñi sa ndisa cuii quehin, ta sehi cuhva cundito ñiyɨvɨ. Yoñi cuu saa nu ndyaa Zuti tatu ma sino iñi ñu sii. ");
INSERT INTO mihNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tatu sa vatyi nacoto ndo sii, nacoto tucu ndo sii Zuti. Ta ndya vityi sa nacoto ndo sii ra, ta sa ndyehe ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ta i catyi ra Felipe sihin ra: Tata, zañohon sii ra Ndyoo Zutun sii ndi. Ta sihin sa yucuan ñi ta sa vaha ñi. ");
INSERT INTO mihNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ta i catyi ra Jesús: Felipe, sa cuaha xaan quɨvɨ ndyei sihin ndo. ¿Atu ta nacoto con sii? Ra sa ndyehe sii, sa ndyehe ra sii ra Ndyoo Zuti. ¿Ta ñaa cuenda catyun vatyi zañehi sii ra Ndyoo Zuti sii ndo? ");
INSERT INTO mihNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Atu ña sino iñun vatyi ndyaa ra Ndyoo Zuti sihin ta ɨɨn ñi cui sihin ra? Ta tuhun quehin, ña quehin sa cuenda ñi mi. Quehin tuhun ra Ndyoo Zuti, ra ndyaa sihin. Ta tyiño zavehi, maa ra zavaha sii si. ");
INSERT INTO mihNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Sino iñi ndo vatyi ɨɨn ñi cui sihin ra Ndyoo Zuti ta ndyaa ra sihin. Zoco tatu ña sino iñi ndo cuhva cuan, zoco sino iñi ndo sa cuenda tyiño zavehi. ");
INSERT INTO mihNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sa ndisa ta sa ndisa catyi sihin ndo, ra sa sino iñi sii, cua zavaha ra tyiño tañi tyiño zavehi. Ta tyiño cahnu ca cua zavaha tucu ra vatyi cuehin nu ndyaa ra Ndyoo Zuti. ");
INSERT INTO mihNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ta tandɨhɨ sa cua caca ndo sii, sihin zɨvɨ mi, cua cuhve sii si. Ta tacuan ta cua zacahnu ca ñiyɨvɨ sii ra Ndyoo Zuti sa cuenda sa cua zavaha Zehe ra. ");
INSERT INTO mihNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tandɨhɨ sa cua caca ndo sii, sihin zɨvɨ mi, cua cuhve sii si sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Tatu cuñi ndo sii, zavaha ndo cuhva catyi sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ta cua caca tahvi sii ra Ndyoo Zuti ta cua zaquisi ra sii inga ra cua tyindyee sii ndo. Ta cua ndoo ra cuan sihin ndo tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tatyi Ii cuu ra, ta maa ñi sa ndisa cahan ra. Ña cuu ñihi ñiyɨvɨ ndya vaha ñi sii ra vatyi ña ndyehe ñu sii ra, ta ña nacoto ñu sii ra. Zoco sa sito maa ndo sii ra vatyi ndyaa ra sihin ndo, ta cua coo ra sisi añima ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ta ma zandoi sii ndo tacuan ñi. Cua quisi tuqui nu ndyaa ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Zuhva ñi ca cuhva, ta ma ndyehe ca ñiyɨvɨ ndya vaha ñi sii. Zoco maa ndo cua ndyehe ndo sii. Cua cundite, ta yucuan cuenda cua cundito tucu maa ndo sihin. ");
INSERT INTO mihNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ta quɨvɨ cuan, cua coto ndo vatyi ɨɨn ñi cui sihin Zuti, ta ɨɨn ñi cua cuu ndo sihin ta mi sihin maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ta ra sa cumi vaha tandɨhɨ cuii tuhun i nacatyi sihin ndo ta zavaha ra sii si, yucuan ra cuu ra sa cuñi xaan sii. Ta ra sa cuñi sii, cuñi xaan Zuti sii ra. Ta cua cuñi xein sii ra, ta cua quisi nu ndyaa ra. Tacuan i catyi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ta i catyi ra Judas, zoco yɨvɨ ra Judas Iscariote cuu ra, ta i catyi ra sihin ra: Tata, ¿ñaa cuenda cua quisun nu ndyaa maa ndi, ta ma cuhun nu ndyaa inga ñiyɨvɨ ndya vaha ñi? ");
INSERT INTO mihNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ta i nacahan ra Jesús ta catyi ra sihin ra: Tatu cuñi minoo ra sii mi sa ndisa, cua tyaa ra yahvi tuhun quehin. Ta cua cuñi xaan Zuti sii ra. Ta cua cuhun ndi nu ndyaa ra, ta cua ndoo ndi sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Zoco ra ña cuñi sii, ña tyaa ra yahvi tuhun quehin. Ta tuhun quehin ta sa siñi ndo, yɨvɨ tuhun ñi mi cuu si. Sa cuenda ra Ndyoo Zuti cuu si, ra i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ta sa nacatyi cuhva ya sihin ndo nɨɨ ñi sa ndyei sihin ndo vityi. ");
INSERT INTO mihNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ta ra sa cua tyindyee sii ndo, ra cu Tatyi Ii, cua tasi ra Ndyoo Zuti sii ra sa cuenda mi. Cua zacuaha ra sii ndo tandɨhɨ. Ta cua zanacohon ra iñi ndo tandɨhɨ sa i catyi sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ta sa coo vaha ndo sehi sii ndo. Ta sa coo vaha ndo zandoi sihin ndo. Ña sehi sii si cuhva saha ñiyɨvɨ ñuu ñiyɨvɨ ya. Ma cuhva ndo sa caca xaan iñi ndo, ta ma yuhu ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ta vityi sa siñi ndo sa catyi vatyi cuhin, ta cua quisi tuqui nu ndyaa ndo. Tatu ndisa vatyi cuñi xaan ndo sii, zɨɨ xaan cua cuñi ndo vatyi cuhin nu ndyaa ra Ndyoo Zuti vatyi cahnu ca cuu maa ra ta zɨquɨ ca mi. ");
INSERT INTO mihNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ta vityi sa nacatyi sihin ndo cuee ca sa tahan si vatyi quɨvɨ cua tahan si ta cua sino iñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ña cuaha ca tuhun cua quehin sihin ndo vatyi sa vasi ra ndyaca ñaha ñuu ñiyɨvɨ ya, ta ña ndyaca ñaha ra sii. ");
INSERT INTO mihNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Zoco sa cua nacoto ñiyɨvɨ ñuu ñiyɨvɨ vatyi cuñi xein sii ra Ndyoo Zuti, yucuan cuenda cua zavehi tyiño i tava ra sii. Ta vityi nanduvita yo ta cuhun yo. ");
INSERT INTO mihNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yuhvi cui tañi minoo yoho uva, ta Zuti cuu tañi ra zatyiño nu ndyaa tu. ");
INSERT INTO mihNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta tandɨhɨ zoco yoho uva cuan sa ñahñi yucu vixi vaha saha cua cahndya ra sii si. Ta tandɨhɨ zoco yoho sa ndyizo yucu vixi vaha, zanduvii ra sii si, ta tacuan ta cua cuhva si cuaha ca. ");
INSERT INTO mihNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ta maa ndo sa nduvii ndo sihin tuhun quehin sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ɨɨn ñi cuu ndo sihin. Tañi mi ɨɨn ñi cui sihin ndo. Tañi minoo zoco yoho, ma cuu cuhva si yucu vixi sa maa ñi maa si, tatu ña ɨɨn ñi cuu si sihin yoho sa cuu saha si. Ta tacuan tucu maa ndo; ma cuu zavaha ndo cuhva catyi sihin ndo tatu ña ɨɨn ñi cua cuu ndo sihin. ");
INSERT INTO mihNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yuhvi cui tañi yoho uva cuan, ta maa ndo cuu tañi zoco tu. Ra sa nañaa sii, nañei sii ra. Ta cuaha xaan sa vaha zavaha ra. Vatyi tatu ma tyindyei sii ndo ñahñi maa sa cuu zavaha ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ta ra sa ña nañaa sii, cua zavite sii ra tañi minoo zoco yoho. Ta cua na‑ityi zoco yoho cuan, ta cua quisi naquihin ñiyɨvɨ sii si, ta cua tyihi ra sii si nu cayu ñúhu vatyi cua cayu si. ");
INSERT INTO mihNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tatu nañaa ndo sii, ta tuhun quehin iyo vaha si sihin ndo, cua caca ndo ñaa sa cuñi ndo ta cua ñihi ndo sii si. ");
INSERT INTO mihNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Cuhva cuan zacahnu xaan si sii Zuti tatu cuaha xaan sa vaha zavaha ndo. Ta tacuan ta cua cuu ndo ñiyɨvɨ ndyico sii mi sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Cuhva cuñi xaan Zuti sii, ta tacuan cuñi sii maa ndo. Ma naa iñi ndo cuhva cuñi xein sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tatu zavaha ndo tandɨhɨ sa catyi sihin ndo, cua cuñi xein sii ndo. Tañi sa i tyaa xein yahvi tandɨhɨ sa i catyi Zuti sihin, ta cuñi xaan ra sii. ");
INSERT INTO mihNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Quehin cuhva ya sihin ndo vatyi cuzɨɨ cuñi ndo tañi sa zɨɨ cuñi mi. Ta sa zɨɨ cuñi maa ndo, ma ndɨhɨ si. ");
INSERT INTO mihNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ihya cuu tyiño sehi sii ndo vatyi cuñi xaan ndo sii minoo ndo ta sii inga ndo tañi cuñi xein sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tatu cuñi ndisa cuii yo sii inga ñiyɨvɨ, cuhva yo sa cuu yo sa cuenda ñu. Ñahñi inga ca cuhva ñihi ca cuñi yo sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Maa ndo cuu ñiyɨvɨ sa cuñi xein tatu zavaha ndo tandɨhɨ cuhva sa i catyi sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ndya vityi ma cahan que muzu sihin ndo vatyi minoo muzu ña sito ra ñaa sa zavaha patrón ra. Zoco catyi vatyi ñiyɨvɨ sa cuñi xein cuu sii maa ndo vatyi sa i nacatyi sihin ndo tandɨhɨ cuii sa i nacatyi Zuti sihin. ");
INSERT INTO mihNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ñá casi ndo sii. Yuhvi cuu ra i casi sii ndo. Ta i sehi tyiño sii ndo vatyi cuhun ndo ta zatyiño ndo tyiñe. Ta cua quita vaha tyiño ndo, ta ma cunaa si. Ta tandɨhɨ sa cua caca ndo sii Zuti sihin zɨvɨ mi cua cuhva ra sii si sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ta ihya cuu tyiño sehi sii ndo vatyi cuñi xaan ndo sii minoo ndo ta sii inga ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Tatu ña cuu ndyehe ñiyɨvɨ ña sino iñi sii ndo, sa sito ndo vatyi sa xihna ñi sii mi ña cuu ndyehe ñu ta zɨquɨ sii maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tatu ñiyɨvɨ cuenda ñuu ñiyɨvɨ ya cuu ndo, cua cuñi xaan ñiyɨvɨ ñuu ñiyɨvɨ ya sii ndo. Zoco yɨvɨ ca ñiyɨvɨ ñuu ñiyɨvɨ ya cuu ndo vatyi sa i casi sii ndo sisi ñuu ñiyɨvɨ ya. Yucuan cuenda, ña cuu ndyehe ñiyɨvɨ ndya vaha ñi sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nacohon iñi ndo vatyi sa i nacatyi sihin ndo vatyi ña cahnu ca cuu ra cu muzu ta zɨquɨ ca patrón ra. Tatu sa cuxaan ñiyɨvɨ sihin mi, cua cuxaan tucu ñu sihin maa ndo. Tatu zavaha ñu cuhva catyi, cua zavaha tucu ñu cuhva catyi maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Zoco tandɨhɨ cuii nuu sa ña vaha cua zavaha ñu sihin maa ndo sa cuenda mi vatyi ña sito ñu sii ra i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tatu sa ñá quisi quehin sihin ñu, ñahñi cuatyi ñu. Zoco vityi ñahñi cuhva cuu tyixehe ñu cuatyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ra sa ña cuu ndyehe sii, ña cuu ndyehe tucu ra sii Zuti. ");
INSERT INTO mihNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tatu sa ñahñi sa ndyityi i zavehi nu yucu ñu tañi sa yoñi zavaha, ñahñi cuatyi ñu. Zoco vityi sa i ndyehe ñu sii, ta i cuxaan ñu sihin mi ta sihin Zuti. ");
INSERT INTO mihNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tacuan cua cuu si vatyi cua tahan si cuhva catyi si sisi zuun ñi ley maa ñu nu catyi si: “Vazu ñahñi cuatyi, zoco ma cuu ndyehe ñu sii.” Catyi si. ");
INSERT INTO mihNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Zoco quɨvɨ naquisi Tatyi Ii, ra cua tasi ndya nu ndyaa ra Ndyoo Zuti, cua tyindyee ra sii ndo, ta maa ñi sa ndisa cua cahan ra. Ra cuan cua cuhva sa ndaa sa cuenda mi. ");
INSERT INTO mihNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ta maa tucu ndo cua cuhva ndo sa ndaa vatyi i sindɨhɨ ndo sihin ndya quɨvɨ i quisaha zatyiñe. ");
INSERT INTO mihNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ihya tuhun i quehin sihin ndo vatyi ma catyihi saha ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Cua tava ndyizo ñiyɨvɨ sii ndo sata vehe ñuhu. Ta cua saa cuhva vatyi yoo ra sa cua cahñi sii ndo ta cua caca iñi ra vatyi tyiño ra Ndyoo zatyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ta cua zavaha ñu cuhva ya vatyi ña sito ñu sii ra Ndyoo Zutu yo a sii mi. ");
INSERT INTO mihNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Zoco vityi sa i nacatyi cuhva ya sihin ndo vatyi quɨvɨ cua tahan si ta cua nacohon iñi ndo vatyi sa i catyi sihin ndo. Ñá catyi tuhun ya sihin ndo sa xihna ñi vatyi ndyei sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Zoco vityi cua cuhin ndya nu ndyaa ra i tasi sii. Ta yoñi ndo cua nducu tuhun ndo sii, ndyamaa cuhin. ");
INSERT INTO mihNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ta vityi sa nducuihya cuñi añima ndo vatyi sa i catyi tuhun ya sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ta catyi sa ndisa sihin ndo vatyi ñiñi xaan cuu si sa cuhin vatyi tatu ma cuhin ma quisi Tatyi Ii zɨquɨ ndo. Cua cuhin ta cua zaquisi sii ra zɨquɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ta quɨvɨ cua quisi ra, cua zacoto ra sii ñiyɨvɨ vatyi iyo cuatyi ñu. Ta cua zañaha ra vatyi iyo minoo ityi ndoo. Ta cua tasi tuñi ra Ndyoo sii ñiyɨvɨ sa ma ndu‑uu iñi cuatyi. ");
INSERT INTO mihNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Cua catyi ra sihin ñiyɨvɨ vatyi iyo cuatyi ñu vatyi ña sino iñi ñu sii. ");
INSERT INTO mihNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Cua zañaha ra sii ñu vatyi iyo minoo ityi ndoo vatyi cuhin nu ndyaa Zuti, ta ma ndyehe ca ndo sii. ");
INSERT INTO mihNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ta cua zañaha ra cuhva cua tasi tuñi ra Ndyoo vatyi cua tasi tuñi ra Ndyoo sii ra ndyaca ñaha ñuu ñiyɨvɨ ya. ");
INSERT INTO mihNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Iyo cuaha xaan ca sa cuñi catyi sihin ndo, zoco ma cutuñi iñi ndo sii si vityi. ");
INSERT INTO mihNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Zoco quɨvɨ cua quisi Tatyi Ii, cua cahan ra sa ndisa vatyi ra cahan sa ndisa cuu ra. Maa ra cuan, cua zañaha ityi sii ndo sii tandɨhɨ cuii sa ndisa. Ma cahan ra sa cuenda ñi maa ra. Tandɨhɨ sa siñi ra nu ndyaa ra Ndyoo Zutu yo, cua zacoto ra sii ndo. Ta cua zacoto ra sii ndo ñaa sa cua coo ityi nuu ca. ");
INSERT INTO mihNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Cua zacahnu ra sii mi vatyi cua quihin ra tuhun quehin sihin ra, ta cua zacoto ra sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tandɨhɨ cuii sa iyo sii Zuti ta sii mi cuu tucu si. Yucuan cuenda catyi vatyi cua quihin ra tuhun quehin sihin ra, ta cua zacoto ra sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Zuhva cuii ñi ca quɨvɨ, ta ma ndyehe ca ndo sii. Ta inga zuhva ca quɨvɨ ta cua nandyehe ndo sii, vatyi cuhin nu ndyaa Zuti. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tacuan ta i quisaha natuhun tahan ra i casi ra Jesús sihin tahan ra: ¿Ñaa tuhun cuu si sa catyi ra sihin yo? vatyi catyi ra: “Zuhva cuii ñi ca quɨvɨ ta ma ndyehe ca ndo sii, ta inga zuhva ca quɨvɨ ta cua nandyehe ndo sii vatyi cuhin nu ndyaa Zuti”. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ñaa cuñi si catyi si sa catyi ra zuhva cuii ñi ca quɨvɨ? Ña cutuñi iñi yo ñaa tuhun cahan ra. Catyi ra i casi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ta i tuu iñi ra Jesús vatyi cuñi nducu tuhun ra sii ra, ta i catyi ra sihin ra: ¿Atu nducu tuhun ndo sii tahan ndo sa cuenda tuhun i catyi vatyi zuhva ñi ca quɨvɨ ta ma ndyehe ca ndo sii ta inga zuhva ca quɨvɨ ta cua nandyehe ndo sii? ");
INSERT INTO mihNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sa ndisa ta sa ndisa catyi sihin ndo vatyi cua vacu xaan ndo ta cua coo xaan tucuihya iñi sii ndo, zoco ñiyɨvɨ ñuu ñiyɨvɨ ya, cua cuzɨɨ xaan cuñi ñu. Ta cua nducuihya xaan iñi maa ndo, zoco cuee ca ta cua nduzɨɨ xaan cuñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Quɨvɨ sa cua cacu zehe minoo ñaha, ndyaa xaan ña tundoho vatyi sa saa cuhva cacu si. Zoco tatu sa yaha cacu zehe ña, ña nacohon ca iñi ña tundoho. Sa nduzɨɨ cuñi ña vatyi i cacu minoo rayɨɨ ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ta maa ndo vityi, cuihya xaan cuñi ndo. Zoco cua ndyehi sii ndo inga saha, ta cua nduzɨɨ xaan cuñi ndo. Ta yoñi cua cuu tyaa siyo sa zɨɨ cuñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ta quɨvɨ cuan, ma nducu tuhun ca ndo sii. Sa ndisa ta sa ndisa catyi sihin ndo, tandɨhɨ sa cua caca ndo sii ra Ndyoo Zuti sihin zɨvɨ mi, cua cuhva ra sii si sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nu vityi ta tañaha ca caca ndo sihin zɨvɨ mi. Caca ndo ta cua ñihi ndo, ta tacuan ta zɨɨ xaan cua cuñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","I quehin tuhun ya sihin ndo sihin minoo cuhva. Zoco cua saa cuhva ta ma cahan que sihin ndo sihin minoo cuhva. Cua catyi casi vehi sihin ndo cuhva iyo ra Ndyoo Zuti. ");
INSERT INTO mihNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ta quɨvɨ cuan cua caca ndo sii ra Ndyoo sihin zɨvi. Ta ña catyi vatyi cua caca tahvi sii ra Ndyoo Zuti sa cuenda ndo ");
INSERT INTO mihNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","vatyi zuun ñi maa ra Ndyoo Zuti cuñi xaan ra sii ndo vatyi cuñi xaan ndo sii, ta sino iñi ndo vatyi i quisi ndya nu ndyaa ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ndya nu ndyaa ra Ndyoo Zuti i quite ta vasi ñuu ñiyɨvɨ. Ta cua zandoo tuqui ñuu ñiyɨvɨ ya ta cunanuhi nu ndyaa ra Ndyoo Zuti inga saha. ");
INSERT INTO mihNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tacuan ta i catyi ra i casi ra sihin ra: Vityi casi vaha cohon, ta ña cahan con sihin minoo cuhva. ");
INSERT INTO mihNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vityi sito ndi vatyi siton tandɨhɨ, ta ña cuñi si sa nducu tuhun numinoo ra suun (vatyi sa siton tandɨhɨ sa sica iñi ndi). Yucuan cuenda sino iñi ndi vatyi ndya nu ndyaa ra Ndyoo i quisun. ");
INSERT INTO mihNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ta i catyi ra Jesús sihin ra: ¿Atu sino iñi ndo vityi? ");
INSERT INTO mihNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Sa cua saa cuhva, ta zuun ñi vityi cuu si, ta cua quɨtɨ cuatyi ndo minoo minoo ndo ndya vehe ndo, ta cua zandoo ndo sii, maa tuhun ñi. Zoco ña maa tuhun ñi cua ndoo. Ndyaa ra Ndyoo Zuti sihin. ");
INSERT INTO mihNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","I quehin tuhun ya sihin ndo vatyi tacuan ta cua coo sa taxi añima ndo sa cuenda mi. Ñuu ñiyɨvɨ ya cua ndyehe ndo tundoho, zoco ma yuhu ndo vatyi sa i zahacanei zɨquɨ ñuu ñiyɨvɨ ya. ");
INSERT INTO mihNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","I cahan ra Jesús tuhun ya, ta zɨquɨ i nandyehe ndaa ra ityi andɨvɨ ta catyi ra: Ndyoo Zuti, sa saa cuhva. Zacahnun sii zehun ta cuhva cua cuu zacahnu zehun suun. ");
INSERT INTO mihNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","I sohon sa cundyaca ñehi zɨquɨ tandɨhɨ ñiyɨvɨ sa iyo ñuu ñiyɨvɨ, ta i sohon sa vatyi cuu cuhve sa cundito ñu tandɨhɨ cuii tyiemvu, tandɨhɨ ñu sa i sohon sii. ");
INSERT INTO mihNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ta ihya cuu cuhva cua cuu cundito ñu sihin, tatu nacoto ñu suun vatyi minoo tuhun ñi ra cuu Ndyoo sa ndisa cuii cuun. Ta sa nacoto ñu sii yuhvi ra Jesucristo, ra i tasun. ");
INSERT INTO mihNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","I zacahni suun ñuu ñiyɨvɨ ya. I zandɨhi tyiño sa i sohon sii. ");
INSERT INTO mihNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ta vityi, Ndyoo Zuti, zacahnun sii nu ndyoon sihin cuhva sa sicoo sii, quɨvɨ i sindyei suhun indyacuan cumañi ca sino ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","I zañehi sii ra i sohon sii, cuhva iyo moo. Sii moo cuu sii ra, ta i sohon sii ra sii, sisi ñuu ñiyɨvɨ ya. Ta i tyaa ra yahvi tuhun cahan moo. ");
INSERT INTO mihNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ta vityi sa sito ra vatyi tandɨhɨ cuii sa i sohon sii, cuenda moo cuu si. ");
INSERT INTO mihNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Vatyi tuhun sa i sohon sii, i zañehi sii ra ya, ta i naquihin vaha ra sii si. Ta sito ra sa ndisa cuii vatyi ndya nu ndyaa moo i quite. Ta sino iñi ra ya vatyi moo i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Sica tahvi suun sa cuenda ra ya. Ña sica tahvi cuenda tandɨhɨ ñiyɨvɨ ñuu ñiyɨvɨ zoco cuenda ñiyɨvɨ sa i sohon sii, vatyi cuenda moo cuu sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ta tandɨhɨ ñu cuu sii, sii moo cuu sii ñu. Ta ñu cuu suun cuu tucu sii mi, ndɨhɨ ca. Ta zacahnu ñu sii. ");
INSERT INTO mihNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ta vityi ma cundyaa que ñuu ñiyɨvɨ ya vatyi quisi nanuhin nu ndyaa moo. Zoco ra ya cua ndoo ra ñuu ñiyɨvɨ ya. Zuti, ra ii, zacuendon sii ñu sihin zɨvɨ moo, ñu i sohon sii, ta tacuan ta cua ndu‑ɨɨn ñu tañi maa yo. ");
INSERT INTO mihNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nɨɨ ñi sa ndyei sihin ra ya, i zacuende sii ra sihin zɨvɨ moo. I sicumi vehi sii ra ya, ta yoñi ra cua naa zoco minoo tuhun ñi ra cua naa tañi catyi Tuhun moo. ");
INSERT INTO mihNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Zoco vityi cua quisi nu ndyoon. Ta nɨɨ ñi sa ndyei ñuu ñiyɨvɨ ya nacatyi tuhun ya, ta tacuan ta cua coo sa zɨɨ sii mi sihin ra ya, ta cua cuzɨɨ xaan iñi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Sa i nacatyi Tuhun moo sihin ra, ta ña cuu ca ndyehe ñiyɨvɨ ñuu ñiyɨvɨ ya sii ra vatyi yɨvɨ ca cuenda ñuu ñiyɨvɨ ya cuu ra. Tañi mi yɨvɨ ra cuenda ñuu ñiyɨvɨ ya cui. ");
INSERT INTO mihNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ña sique suun sa tavon sii ra ñuu ñiyɨvɨ ya. Zoco sique suun sa vatyi cua zacuendon sii ra sisi sa ña vaha iyo ñuu ñiyɨvɨ ya coto ndoyo ñuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yɨvɨ ca cuenda ñuu ñiyɨvɨ ya cuu sii ra. Tañi mi yɨvɨ cuenda ñuu ñiyɨvɨ ya cui. ");
INSERT INTO mihNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Zanduvaha con cuhva iyo ra sihin tuhun ndisa sii moo. Tuhun cahan moo, tuhun ndisa cuii cuu si. ");
INSERT INTO mihNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tañi i tasun sii mi ñuu ñiyɨvɨ ya, zuun ñi tacuan tasi sii ra ya ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tyaa siye sii, sii sa ña vaha sa cuenda ra ya vatyi tacuan ta cua tyaa siyo tucu maa ra sii ra sii sa ña vaha ta cundyico ra sii, sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ña ɨɨn ñi sa cuenda ra ya sica tahvi, zoco ndya sa cuenda ñiyɨvɨ cua sino iñi sii sihin tuhun sa cua cahan ra ya. ");
INSERT INTO mihNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ta tacuan ta cua ndu‑ɨɨn tandɨhɨ ñu tañi maa yo vatyi ɨɨn ñi iyon sihin, ta ɨɨn ñi iye suhun, Ndyoo Zuti. Ta tacuan ta cua ndu‑ɨɨn tucu maa ñu sihin yo. Ta tacuan ta cua sino iñi ñiyɨvɨ ñuu ñiyɨvɨ vatyi i zaquisun sii. ");
INSERT INTO mihNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ta sa vaha xaan sa sohon sii, i sehi sii ra ya vatyi ndu‑ɨɨn ra tañi maa yo ɨɨn ñi cuu yo. ");
INSERT INTO mihNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yuhvi ta ra ya ɨɨn ñi cuu ndi tañi yoho sihin mi ɨɨn ñi cuu yo, ta nandu‑ɨɨn maa ra minoo sa ndisa cuii vatyi tacuan ta cua coto ñiyɨvɨ ñuu ñiyɨvɨ vatyi moo i tasi sii ta cuñi xoon sii ra ya tañi cuñun sii. ");
INSERT INTO mihNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ndyoo Zuti, cuñi sa vatyi ñiyɨvɨ sa i sohon sii, cua cundyaa ñu ɨɨn ñi sihin mi nu cua cundyei, ta tacuan ta cua ndyehe ñu sa vaha xaan sa i sohon sii. Vatyi i cuñi xoon sii, cumañi ca sino ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ndyoo Zuti, ra ndoo xaan, ña nacoto ñiyɨvɨ ñuu ñiyɨvɨ ya suun, zoco yuhvi site suun, ta sito ra ya vatyi moo i tasi sii. ");
INSERT INTO mihNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Sa i zacote sii ra ya cuhva iyo moo, ta cua zacote cuaha ca sii ra. Tacuan ta cuhva cuñi xoon sii, cua coo si sisi añima ra, ta cua coo tucu yuhvi sisi añima ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ta sa ndɨhɨ cahan ra Jesús tuhun ya, i quita ra sihin ra i casi ra ta cuahan ra inga siyo yuu sa nañi Cedrón ndya minoo nu iyo cuaha xaan yutu ta ita. Ta yucuan i quɨhvɨ ra sihin ra i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ta ra Judas, ra sa xico tuhun sii ra Jesús, sa sito tucu maa ra nu cuahan ra vatyi tuhva xaan ra Jesús sahan yucuan sihin ra i casi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tacuan ta sa quihin ra Judas minoo ityi zandaru ta cuaha xaan policía cuenda ra zutu nahnu ta ra fariseo, ta cuahan ra sihin lámpara ta yɨtɨ ta sihin ndaha tyiño xaan. ");
INSERT INTO mihNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ta sa sito ra Jesús tandɨhɨ tundoho sa cua tahan ra. Ta xihna ca maa ra i quita, ta i nducu tuhun ra sii ra sa vasi cuan: ¿Yoo sii nanducu ndo? ");
INSERT INTO mihNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ta i nacahan ra ta catyi ra: Sii ra Jesús, ra ñuu Nazaret. Tacuan ta i catyi ra Jesús: Zuun yuhvi cui. Catyi ra. Ta ndɨhɨ ra Judas sihin ra cuan. Maa ra cuu ra i xico sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ta zuun ñi caa cuhva sa i catyi ra Jesús sihin ra: “Zuun yuhvi cui”, ta i sica sata tandɨhɨ ra cuan, ta i nduva tandɨhɨ cuii ra nu ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tacuan ta i nducu tuhun ra Jesús sii ra inga saha: ¿Yoo sii nanducu ndo? Ta i catyi ra cuan: Sii ra Jesús, ra ñuu Nazaret. ");
INSERT INTO mihNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ta i nacahan ra Jesús ta catyi ra: Sa catyi sihin ndo vatyi zuun yuhvi cui. Tatu sii mi nanducu ndo, cuatu ndo nacuhun xihna ra ndɨhɨ sihin ya. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tacuan cua cuu si, vatyi cua quita si tañi cuhva catyi Tuhun Ndyoo vatyi catyi si: “Ra sa i sohon sii, ñá zacunei numinoo ra.” ");
INSERT INTO mihNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tacuan ta zɨquɨ i tava ra Simón Pedro mityi sa ndyizo ra. Ta i cañi ra sii ra cu muzu sii ra cu nuu sii tandɨhɨ ra cu zutu, ta i sahndya ra zoho ra siyo cuaha ra. Malco nañi ra cu muzu cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tacuan ta i catyi ra Jesús sihin ra Pedro: Natyuhun mityun sisi veno si. ¿Atu ña cuñun sa ndyehi tundoho sa saha Zuti sii? ");
INSERT INTO mihNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tacuan ta zɨquɨ minoo ityi zandaru cuan, sihin ra cu nuu sii ra ta ra cu policía cuenda ra hebreo, i tɨɨn ra sii ra Jesús, ta i sihñi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ta sa xihna ñi i sindyaca ra sii ra ndya vehe ra Anás vatyi tyizo ra Caifás cuu sii ra. Ta ra Caifás cuu ra cu nuu sii tandɨhɨ ra cu zutu cuiya cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ta ra Caifás, zuun ñi ra cuu ra sa catyi sihin ra hebreo quɨvɨ cuan vatyi vaha ca nacuu minoo ñi ra sa cuenda tandɨhɨ, ta ma cuu tandɨhɨ ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ta i sindyico ra Simón Pedro sii ra Jesús, ta tacuan tucu inga ra. Sito ra mandoñi sahnu Anás sii inga ra cuan, ta yucuan cuenda i cuu quɨhvɨ ra sihin ra Jesús ndya yuvehe ra cu nuu sii tandɨhɨ ra cu zutu. ");
INSERT INTO mihNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Zoco i ndoo ra Pedro sata nuzama. Tacuan ta zɨquɨ i quita inga ra. Sa sito ra cu nuu sii tandɨhɨ ra cu zutu sii ra cuan. I cahan ra cuan sihin ñaha zacuenda yuvehe, ta i cuu quɨhvɨ ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ta ñaha sa zacuenda yuvehe cuan, i catyi ña sihin ra Pedro: ¿Atu yɨvɨ minoo ra ndyico sii ra cuan cuun? Ta i catyi ra Pedro: Yɨvɨ ra cui. ");
INSERT INTO mihNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ta yucuan yucu muzu ta tandɨhɨ ra policía. Sa zatahan ra ñúhu vatyi visi xaan, ta yucuan ndyaa ra yunuhu. Tuhva ra Pedro ta nandyaa ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tacuan ta zɨquɨ i nducu tuhun xaan ra mandoñi sahnu, ra Anás, sii ra Jesús yoo ra ndyico sii ra, ta ñaa sa zacuaha ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ta i nacahan ra Jesús, ta catyi ra sihin ra: I quehin ityi nuu tandɨhɨ ñiyɨvɨ. I zacuehi sisi vehe ñuhu tahan ñuu ta sisi vehe ñuhu cahnu ihya nu titahan tandɨhɨ ñiyɨvɨ hebreo. Ta ñahñi maa sa nacatyi xehi. ");
INSERT INTO mihNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ñaa cuenda nducu tuhun sii? Nducu tuhun sii ñiyɨvɨ i siñi ñaa sa nacatyi sihin ñu. Sito maa ñu ñaa sa nacatyi sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ta sa ndɨhɨ cahan ra Jesús tacuan, ta minoo ra cu policía sa ndyaa yatyi ñi i cati ra sii ra Jesús sihin ndaha ra ta catyi ra: Ña tacuan tahan si cohon sihin ra mandoñi sahnu. ");
INSERT INTO mihNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ta i nacahan ra Jesús ta catyi ra: Tatu i quehin ndya vaha ñi, catyun ñaa sa ña vaha quehin. Zoco tatu vaha quehin ¿ñaa cuenda catun sii? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tacuan ta i tasi ra Anás sii ra Jesús zoco nuhñi ra ndya nu ndyaa ra Caifás, ra cu nuu sii tandɨhɨ ra cu zutu. ");
INSERT INTO mihNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ta nandyaa ra Simón Pedro yunuhu. Tacuan ta zɨquɨ i catyi ñiyɨvɨ sihin ra: ¿Atu yɨvɨ minoo ra ndyico sii ra cuan cuun? Ta i catyi ra Pedro: Yɨvɨ ra cui. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Minoo muzu ra cu zutu ya cahnu cuu ñiyɨvɨ sii ra i sahndya ra Pedro zoho, ta i catyi ra cuan sihin ra Pedro: ¿Atu yɨvun i ndyehi sihin ra cuan yucuan nu iyo cuaha xaan yutu? ");
INSERT INTO mihNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ta i catyi ra Pedro inga saha vatyi yɨvɨ. Ta zuun ñi caa cuhva cuan i sacu saa ndɨvɨ tyahnu. ");
INSERT INTO mihNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tacuan ta i sindyaca ra sii ra Jesús nu ñoho ra vehe ra Caifás ndya vehe tyiño cuenda ra gobernador. Ta nu ñaha ñi cuu si. Ta ñá quɨhvɨ ra hebreo sisi vehe tyiño vatyi yɨvɨ vehe hebreo cuu si, ta catyi ley hebreo vatyi tatu cua quɨhvɨ ra, cua nducuxi caa ra, ta ma cuu ca cuxiñi ra sisi vico zuhun. ");
INSERT INTO mihNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yucuan cuenda i quita ra Pilato ityi sata nu yucu ra cuan, ta catyi ra: ¿Ñaa cuatyi tyaa ndo sata ra ya? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ta i nacahan ra ta catyi ra: Tatu yɨvɨ ra iyo cuatyi cuu ra, ma nacuhva ndi sii ra suun. ");
INSERT INTO mihNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tacuan ta i catyi ra Pilato sihin ra: Quihin maa ndo sii ra ta tyicuhva ndo sii ra cuhva catyi ley maa ndo. Ta i catyi ra hebreo sihin ra: Ña catyi ley ndi sa cahñi ndi numinoo ñiyɨvɨ. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tacuan cua cuu si ta cuhva cua quita si cuhva catyi ra Jesús yozo caa cua cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tacuan ta zɨquɨ i nandɨhvɨ ra Pilato sisi vehe tyiño, ta i cana ra sii ra Jesús naquisi ra nu ndyaa ra, ta i catyi ra sihin ra: ¿Atu rey cuenda ñiyɨvɨ hebreo cuun? ");
INSERT INTO mihNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ta i nacahan ra Jesús ta catyi ra: ¿Atu cohon cuhva sa sica ñi iñi moo a sa iyo ñiyɨvɨ nacatyi suhun? ");
INSERT INTO mihNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ta i nacahan ra Pilato ta catyi ra: Yɨvɨ ra hebreo cui. Zuun ñi ñiyɨvɨ ñuu moo sihin ra zutu nahnu i quisi ndyaca suun sii. ¿Ñaa sa zacuun? ");
INSERT INTO mihNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ta i nacahan ra Jesús ta catyi ra: Nu ndyaca ñehi, yɨvɨ ñuu ñiyɨvɨ ya cuu si. Vatyi tatu cuñi cundyaca ñehi ihya, cua cahñi tahan ra ndyico sii, ta ma cuhva ra sii, sii ñiyɨvɨ hebreo. Zoco nu ndyaca ñehi, yɨvɨ ñuu ñiyɨvɨ ya cuu si. ");
INSERT INTO mihNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tacuan ta i catyi ra Pilato sihin ra: Vazɨquɨ minoo rey cuun. Ta i catyi ra Jesús: Zuun cui cuhva catyun. Yucuan cuenda i caqui ta vasi ñuu ñiyɨvɨ ya vatyi cua cuu cuhve sa ndaa sa cuenda sa ndisa. Ta tandɨhɨ ñiyɨvɨ zavaha sa vaha, tyaa ñu yahvi sa quehin. ");
INSERT INTO mihNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ta i catyi ra Pilato sihin ra Jesús: ¿Ñaa sa cuu sa ndisa? Ta sa catyi ra tacuan ta i quita tucu ra ndya ityi sata nu yucu ñu hebreo, ta i catyi ra sihin ñu: Ñahñi maa cuatyi ra iyo caña ñi. ");
INSERT INTO mihNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ta iyo minoo costumbre sii maa ndo sisi vico zuhun vatyi cua zañe sii minoo ra ñoho vehe caa. ¿Atu cuñi ndo vatyi zañe sii ra cu rey cuenda ñiyɨvɨ hebreo? ");
INSERT INTO mihNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ta i cana saa ñiyɨvɨ ta catyi ñu: Yɨvɨ ra ihya zañon. Zañon sii ra Barrabás. Catyi ñu. Ta ra Barrabás cuan, ra zuhu cuu ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ta yucuan cuenda i quihin ra Pilato sii ra Jesús, ta i saha ra sa cañi xaan zandaru sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ta i quihin zandaru iñu, ta zavaha ra minoo corona, ta i tyihi ra sii si xiñi ra Jesús. Ta i tyihi ra minoo zahma cañi tyacu zahma tixinda sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ta i catyi zandaru: ¡Nacumi suun yoho rey, ra ndyaca ñaha cahnu sii ñiyɨvɨ hebreo! Ta i cati ra sii ra Jesús sihin ndaha ra. Ta i sacu ndyaa ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tacuan ta zɨquɨ i quita tucu ra Pilato inga saha ityi sata, ta i catyi ra sihin ñiyɨvɨ hebreo: Ndyehe ndo, vasi ndyaque sii ra sii ndo vatyi coto ndo vatyi ñahñi maa cuatyi ra iyo sa cuenda mi. ");
INSERT INTO mihNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ta i quita ra Jesús. Ñoho corona iñu xiñi ra ta ñoho ra zahma tyacu tixinda cuan. Ta i catyi ra Pilato sihin ñu: Ica ra ya. ");
INSERT INTO mihNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ta sa ndyehe ra zutu nahnu ta ra ndɨhɨ sihin ra sii ra Jesús, ta i cana saa ra ta catyi ra: Tyoon sii ra nu cruz. Tyoon sii ra nu cruz. Zoco i catyi ra Pilato sihin ra cuan: Quihin maa ndo sii ra ta tyaa ndo sii ra nu cruz tatu cuñi ndo, zoco sa cuenda mi ñahñi maa cuatyi ra iyo caña ñi. ");
INSERT INTO mihNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ta i nacahan ra hebreo ta catyi ra: Iyo minoo ley sii maa ndi, ta catyi si vatyi tahan si sa cuu ra vatyi catyi ra vatyi Zehe ra Ndyoo cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ta sa siñi ra Pilato cuhva catyi ñu, ta i yuhu ca ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ta i nandɨhvɨ ra sisi vehe tyiño, ta i catyi ra sihin ra Jesús: ¿Ta ndyamaa i quisun? Zoco ñá cahan ra Jesús sa cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tacuan ta zɨquɨ i catyi ra Pilato sihin ra: ¿Ñacu ña cohon sa quehin? ¿Atu ña siton vatyi iyo cuhva sii, ta cuu catyi vatyi cahñi ñiyɨvɨ suun nu cruz, ta cuu zañe suun? ");
INSERT INTO mihNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ta i nacahan ra Jesús, ta catyi ra: Ñahñi maa sa cuu zavohon sihin tatu sa yɨvɨ ra Ndyoo i saha cuhva suun. Yucuan cuenda cahnu ca cuatyi ra saha cuenda sii suun. ");
INSERT INTO mihNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ta sa ndɨhɨ cahan ra Jesús tacuan, ta i nducu ra Pilato cuhva zaña ra sii ra. Zoco i quisaha cana saa ra hebreo ta catyi ra: Tatu zañon sii ra ña, yɨvɨ amigo ra César cuun. Yoo ra catyi vatyi minoo rey cuu ra, cuñi ra quindyaa ra tyiño ra César. ");
INSERT INTO mihNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ta sa siñi ra Pilato cuhva cuan, ta zɨquɨ i sindyaca ra sii ra Jesús ityi sata, ta i sicundyaa ra tyayu ra nu tuhva ra zandaa tyiño, nu nañi si Gabata sihin zahan hebreo. Ta cuñi si catyi si Nu Ndava. ");
INSERT INTO mihNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ta quɨvɨ sa zanduvaha ñiyɨvɨ cuenda vico zuhun i cuu si tañi maa ora, ta i catyi ra Pilato sihin ñiyɨvɨ hebreo: Ica rey ndo ya. ");
INSERT INTO mihNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tacuan ta zɨquɨ i cana saa ñiyɨvɨ inga saha, ta catyi ñu: ¡Quihin ndo sii ra! ¡Quihin ndo sii ra! Tyaa ndo sii ra nu cruz. Ta i catyi ra Pilato sihin ñu: ¿Atu cuñi ndo sa cahñi sii rey ndo? Ta i nacahan ra zutu nahnu, ta catyi ra: Yoñi ca inga rey ndi. Maa ñi ra César. ");
INSERT INTO mihNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ta yucuan cuenda i saha cuenda ra Pilato sii ra vatyi cahñi ra sii ra nu cruz. Ta i quihin zandaru sii ra Jesús, ta cuahan ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ta ndyizo ra Jesús cruz ra cuahan ra sihin ra ndya nu nañi si Yɨquɨ Xiñi Ndɨyɨ. Ta sihin zahan hebreo nañi si Gólgota. ");
INSERT INTO mihNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ta yucuan i tyaa ra sii ra nuu cruz sihin clavo. Ta inga uu tahan ra, minoo ra siyo cuaha ta minoo ra siyo zatyi ra Jesús, ta ra Jesús mahñu. ");
INSERT INTO mihNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ta i tyaa ra Pilato minoo zɨvɨ, ta i catyi ra vatyi cundyaa si xiñi cruz cuan ta catyi si: “Ra Jesús ñuu Nazaret, rey cuenda ñiyɨvɨ hebreo cuu ra.” ");
INSERT INTO mihNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Cuaha xaan ra hebreo i cahvi tuhun sa ndyaa xiñi cruz cuan. Vatyi nu sihi ra Jesús, yatyi ndyaa si yuhu ñuu. Ta tuhun sa ndyaa xiñi cruz cuan, ndyaa si sihin zahan hebreo, zahan griego ta zahan latín. ");
INSERT INTO mihNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ta ra zutu nahnu i catyi ra sihin ra Pilato: Ma tyoon: “Rey cuenda ñiyɨvɨ hebreo.” Tyoon vatyi maa ra catyi vatyi rey cuenda ñiyɨvɨ hebreo cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Zoco i nacahan ra Pilato: Cuhva i tyei, sa ndyaa si. ");
INSERT INTO mihNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ta sa yaha i tyaa zandaru sii ra Jesús nu cruz, ta i quihin ra zahma ra. Sa cumi tahan ra i quihin ra minoo minoo si. Ta minoo zahma cañi sa ndisi ra, i cacu si ɨɨn ñi; ñahñi nu i ndɨcuɨ ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yucuan cuenda i catyi zandaru sihin tahan ra: Ma ndata yo sii si. Nacuzɨquɨ yo, ta cua ndyehe yo yoo ra cua zahacanaa. Catyi ra. Ta cuhva ya i quita si cuhva catyi Tutu ra Ndyoo: I zasa ra zahme sii tahan ra, Ta i sizɨquɨ ra yoo ra cua ñihi zahma cañi vii. Ta tacuan i zavaha zandaru. ");
INSERT INTO mihNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ta nandyaa zɨhɨ ra Jesús yatyi ñi saha cruz nu ndyaa ra Jesús nu cruz. Ta nandyaa tucu cuhu ña ta ña María ñazɨhɨ ra Cleofas ta ña María Magdalena tucu. ");
INSERT INTO mihNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ta sa ndyehe ra Jesús vatyi yatyi nandyaa zɨhɨ ra ta minoo ra i casi ra, ra sa cuñi xaan ra, ta i catyi ra Jesús sihin zɨhɨ ra: Ndya vityi, ra ihya cua cuu zehun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ta zɨquɨ i catyi ra sihin ra i casi ra: Ta maa ña cua cuu zɨhun. Ta ndya cuhva cuan i quihin ra sii ña, ta cuahan ña vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ta sa yaha cuan, ta zɨquɨ i sito ra Jesús vatyi sa i zavaha ra tandɨhɨ ta sa i cuu tandɨhɨ cuhva catyi si nuu Tutu ra Ndyoo. Ta zɨquɨ i catyi ra: Ityi xein. ");
INSERT INTO mihNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ta yatyi ñi yucuan nandyaa minoo quɨzɨ situ cuii ndutya iya. Ta i zatyii zandaru minoo sa ñahma, ta i tyaa ra sii si minoo nuu zoco yutu sa nañi hisopo, ta i tyiñaa ra sii si yuhu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ta sa i sihi ra Jesús ndutya iya cuan, ta zɨquɨ i catyi ra: Sa ndɨhɨ tyiño. Ta i nacañi noo ra xiñi ra, ta i nacuhva cuenda ra añima ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Cumañi minoo ñi ca quɨvɨ ta cua cuu si quɨvɨ cahnu sisi vico zuhun cuenda ñiyɨvɨ hebreo. Ñá cuñi ra hebreo sa ndoo coño ñuhu cuan nu cruz quɨvɨ quitatu ñiyɨvɨ vatyi cahnu xaan quɨvɨ zacuu ñiyɨvɨ quɨvɨ cuan sa cuenda vico zuhun. Yucuan cuenda i sica ra tumañi iñi sii ra Pilato vatyi cuhva ra sa cahnu zandaru yɨquɨ ndoo ra sa ndyaa nu cruz. (Ta sa ndɨhɨ sahnu ra yɨquɨ ndoo ra cuan ta yatyi ca cua cuu ra.) Ta cua cuu tyaa siyo ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tacuan ta i saa zandaru, ta i sahnu ra yɨquɨ ndoo minoo ra ta inga tucu ra sa ndyaa inga nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Zoco sa saa ra nu ndyaa ra Jesús ta i ndyehe ra vatyi sa sihi ra, ta ñá sahnu ca ra saha ra. ");
INSERT INTO mihNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Zoco i tusi minoo zandaru minoo caa xaan xiin ra Jesús, ta i quita nɨñɨ ta ndutya. ");
INSERT INTO mihNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ta minoo ra i ndyehe, saha ra sa ndaa, ta sa ndisa cahan ra. Sito maa ra vatyi sa ndisa cuu sa cahan ra. Ta nacatyi ra sii si vatyi cua cuu sino tucu iñi maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ta cuhva cuan i cuu tandɨhɨ si vatyi cua quita si tañi catyi Tutu ra Ndyoo nu catyi si: “Ma cahnu ñiyɨvɨ numinoo yɨquɨ ra.” ");
INSERT INTO mihNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ta inga tucu nu tutu ra Ndyoo catyi si: “Cua ndyehe ñiyɨvɨ sii ra cuhva cua quɨhvɨ minoo caa xaan xiin ra.” ");
INSERT INTO mihNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ta sa yaha cuan, ta zɨquɨ i quisi ra José ra ñuu Arimatea. Sino iñi ra sii ra Jesús, zoco xehe ñi vatyi yuhu ra sii ra hebreo. Ta i sica ra tumañi iñi sii ra Pilato vatyi cuu quihin ra coño ñuhu ra Jesús. Ta i saha ra Pilato. Ta zɨquɨ i sahan ra, ta i quihin ra coño ñuhu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ta i quisi tucu ra Nicodemo, ra sa sahan sa xihna ñi nu ndyaa ra Jesús minoo sa cuaa. Ndaha ra cuaha xaan azetye vixi. Nazaca si sihin mirra ta áloe. Tañi minoo oco usi kilo si. ");
INSERT INTO mihNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tacuan ta zɨquɨ i quihin ra José ta ra Nicodemo coño ñuhu ra Jesús, ta i cava noo ra zahma sa cahyu ra azetye vixi cuan cuhva iyo costumbre ñiyɨvɨ hebreo tatu cua tyihi ñu sii minoo ñiyɨvɨ sisi ñaña. ");
INSERT INTO mihNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ta yatyi nu i sihi ra Jesús nu cruz sicoo cuaha xaan yutu tyaqui, ta yucuan sicoo minoo ñaña sa ta yoñi ca cutyiño. ");
INSERT INTO mihNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ta yucuan i tyihi ra sii ra Jesús vatyi yatyi ñi ndyaa si. Ta sa cua cuu si quɨvɨ quitatu ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ta quɨvɨ tumingu ñaa ca i saa ña María Magdalena ndya ñaña, ta i ndyehe ña vatyi sa sɨñɨ siyo yuu sa sindazi yuñaña cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tacuan ta zɨquɨ i sino xaan ña ndya nu ndyaa ra Simón Pedro ta inga ra sa cuñi xaan ra Jesús, ta i catyi ña sihin ra: Sa sitava ñiyɨvɨ coño ñuhu ra Jesús sisi ñaña cuan, ta ña sito yo ndyamaa i natyihi ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yucuan cuenda i quita ra Pedro ta inga ra ta cuahan ra ndya ñaña. ");
INSERT INTO mihNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nduu tahan ra i cacono ra, zoco ñihi xaan ca sino inga ra ta zɨquɨ ra Pedro, ta xihna ca ra cuan i saa ñaña. ");
INSERT INTO mihNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ta i ndyehe noo ra sisi ñaña, ta i ndyehe ra zahma sa i cava noo sii ra Jesús; catuu si nu ñuhu, zoco ñá quɨhvɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ta zɨquɨ i saa ra Simón Pedro, ta i quɨhvɨ ra sisi ñaña, ta i ndyehe ra zahma sa i cava noo sii ra Jesús; catuu si. ");
INSERT INTO mihNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ta zahma luhlu sa ñoho xiñi ra Jesús, ña ɨɨn ñi catuu si sihin inga zahma cuan. Nacuɨñɨ tahnu vaha si, ta catuu zɨɨn si. ");
INSERT INTO mihNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tacuan ta zɨquɨ i quɨhvɨ tucu inga ra sa saa sa xihna ñi. Ta i ndyehe ra. Ta i sino iñi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Zoco tañaha ca coto ra vatyi catyi Tuhun Ndyoo vatyi ndyaa si sa cua nandoto tucu ra Jesús sa sa i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tacuan ta i quita ra i casi ra Jesús, ta cua nuhu ra ndya vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ta i nasaa ña María ndya ñaña, ta sa nandyaa ña yuhu ñaña, ta cuihya xaan i cuñi ña, ta i sacu xaan ña. Ta cuhva sa sacu ña, ta i nandyehe noo ña sisi ñaña. ");
INSERT INTO mihNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ta i ndyehe ña uu tahan ángel sa ñoho zahma cuisi. Minoo ra ndyaa ityi nu sicaa xiñi ra Jesús, ta inga ra ityi nu i sicaa saha ra nu sicaa coño ñuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ta i catyi ángel sihin ña: Maha, ¿ñacu sacu xoon? Ta i catyi ña: Vatyi i quihin ñiyɨvɨ coño ñuhu ra Jesús, ta ña site ndyamaa i tyihi ñu sii si. ");
INSERT INTO mihNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ta sa ndɨhɨ cahan ña tacuan, ta i nasico cava ña, ta ndyehe ña sii ra Jesús nandyaa ra. Zoco ñá nacoto ña tatu zuun ra cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ta i catyi ra Jesús sihin ña: Maha, ¿ñacu sacu xoon? ¿Yoo sii nanducun? Ta ña María sica iñi ña vatyi ra zacuenda yucuan cuu ra cahan, ta i catyi ña sihin ra: Tata, tatu yoho i quihin coño ñuhu ra ya, nacatyun sihin ndyamaa i tyuhun sii si vatyi cua naquihin sii si. ");
INSERT INTO mihNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tacuan ta zɨquɨ i catyi ra Jesús sihin ña: María. Ta i nandyehe vaha ña sii ra, ta i catyi ña sihin ra: ¡Rabboni! Zahan hebreo cuu si cuan, ta cuñi si catyi si Maestro. ");
INSERT INTO mihNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ta i catyi ra Jesús sihin ña: Ma tɨun sii vatyi tañaha ca nandaa xique ndya nu ndyaa Zuti. Zoco cuahan nu ndyaa tandɨhɨ ra sa cuñi xein, ta nacatyun sihin ra vatyi cuehin nu ndyaa Zuti, ta Zutu tucu maa ndo cuu sii ra. Ta nu ndyaa Ndyoo mi, ta Ndyoo tucu maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ta zɨquɨ cuahan ña María Magdalena nu yucu ra i casi ra Jesús, ta i nacatyi ña sihin ra vatyi sa i ndyehe ña sii ra Jesús ta i cahan ra tuhun cuan sihin ña. ");
INSERT INTO mihNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tacuan ta zɨquɨ zuun ñi quɨvɨ tumingu cuan sa sahiñi i siyucu ra i casi ra Jesús ɨɨn ñi, ta ndazi cutu yuvehe vatyi yuhu ra sii ra hebreo, ta i quisi ra Jesús ta i sicuɨñɨ ndyaa ra mahñu, ta catyi ra sihin ra: Nacoo sa vaha sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ta sa yaha catyi ra tacuan, ta zɨquɨ i zañaha ra ndaha ra ta xiin ra. Ta zɨɨ xaan i cuñi ra i casi ra sa i ndyehe ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tacuan ta i catyi ra Jesús sihin ra inga saha: Nacoo sa vaha sii ndo. Tañi sa tasi Ndyoo Zuti sii, sihin tyiño ra, zuun ñi cuhva cuan cua tasi sii maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ta sa ndɨhɨ catyi ra tacuan, ta i tɨvɨ ra tatyi ra sii ra, ta catyi ra sihin ra: Naquihin ndo Tatyi Ii. ");
INSERT INTO mihNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yoo sii cuatyi cua zandasi ndo, cua ndasi si sa ndisa. Ta yoo sii cuatyi ma zandasi ndo, ma ndasi cuatyi ñu. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ta ra Tomás minoo sa usi uu tahan ra i casi ra Jesús cuu ra. Nañi tucu ra Dídimo. Ta yoñi ra ndyaa cuhva sa quisi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ta i nacatyi inga ra i casi ra Jesús sihin ra: I ndyehe ndi sii ra Jesús. Zoco i catyi ra Tomás sihin ra: Tatu ma ndyehi nu cahvi ndaha ra nu i quɨhvɨ clavo ta tyihi nu ndehi yucuan, ta tatu ma ndyehi xiin ra nu quɨhvɨ caa xaan ta tyihi ndehi yucuan, ma sino iñi. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ta yaha uña quɨvɨ, ta zɨquɨ ñoho ndazi tucu ra i casi ra Jesús, ta ndyaa ra Tomás sihin ra. Ta ndazi cutu yuvehe, zoco i quɨhvɨ ra Jesús ta i sicuɨñɨ ndyaa ra mahñu, ta i catyi ra: Nacoo sa vaha xaan sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ta zɨquɨ i catyi ra sihin ra Tomás: Zatuhvon ndohon ta tyuhun nu ndohon ndehi, ta zatuhvon ndohon ta tyuhun sisi xiin. Ta ma cuu con minoo ra ña sino iñi, zoco sino iñun. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tacuan ta i catyi ra Tomás sihin ra: Moo cuu ra ndyaca ñaha sii. Ta moo cuu Ndyoo sii. ");
INSERT INTO mihNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ta i catyi ra Jesús sihin ra: Tomás, sa i ndyehun sii, ta yucuan cuenda sino iñun. Vaha xaan ca ñiyɨvɨ ma ndyehe sii, ta sino iñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ta iyo cuaha xaan inga sa ndyityi i zavaha ra Jesús nuu ra i casi ra, ta ña ndyaa si nuu libro ya. ");
INSERT INTO mihNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Zoco i tyei zuhva si ihya vatyi cua cuu sino iñi ndo vatyi ra Jesús cuu ra Cristo, zehe ra Ndyoo. Ta sihin sa sino iñi ndo, cua ñihi ndo sa cacu añima ndo tandɨhɨ cuii tyiemvu sa cuenda maa ra. ");
INSERT INTO mihNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ta sa yaha tandɨhɨ cuhva cuan, ta zɨquɨ ihya cuu cuhva i cahan tucu ra Jesús inga saha sihin ra i casi ra yumiñi sa nañi Tiberias. ");
INSERT INTO mihNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ɨɨn ñi tayucu ra Simón Pedro sihin ra Tómas, ra nañi Dídimo, ta ra Natanael, ra ñuu Caná nu cu si Galilea, ta zehe ra Zebedeo ta inga uu tahan ra i casi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ta i catyi ra Simón Pedro sihin inga ra: Cuehin cua tɨin tyiyaca. Ta i catyi inga ra sihin ra: Cua cuhun tucu maa ndi suhun. Ta cuahan ra, ta i quɨhvɨ ra minoo barco. Zoco ñahñi maa tyiyaca i ñihi ra sa cuaa cuan. ");
INSERT INTO mihNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ta cuhva sa vasi cundisi, sicuɨñɨ ndyaa ra Jesús nu ñiyɨtɨ, zoco ñá nacoto ra vatyi ra Jesús cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ta zɨquɨ i catyi ra Jesús sihin ra: Zehe luhli, ¿atu ñahñi tyiyaca i ñihi ndo? Ta i catyi ra: Yoñi tɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ta i catyi ra Jesús sihin ra: Cañi ndo taraya ndo siyo cuaha, ta cua ñihi ndo. Ta i cañi ra sii si, ta zɨquɨ ñá cuu ca tava ra taraya ra vatyi cuaha xaan tyiyaca ñoho. ");
INSERT INTO mihNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ta ra sa cuñi xaan ra Jesús i catyi ra sihin ra Pedro: Ra Jesús cuu ra. Ta sa siñi ra Simón Pedro vatyi ra Jesús cuu ra, ta i nazucu ra zahma ra sii ra vatyi sa i tava ra sii si sa cua tɨɨn ra tyiyaca. Ta i quɨhvɨ ra nu miñi. ");
INSERT INTO mihNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ta i quisi inga ra sihin barco luhlu. Xita ra taraya sa ñoho tyiyaca vatyi ña sica ndyaa yuhu miñi tañi minoo ziendu metro ñi. ");
INSERT INTO mihNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ta sa i quita tandɨhɨ ra nu ñuhu, i ndyehe ra tuñuhu, ta yucuan catuu minoo tyiyaca ta pan tucu. ");
INSERT INTO mihNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ta i catyi ra Jesús: Quisi ndyaca ndo zuhva ca tyiyaca sa nacaa tɨɨn ndo. ");
INSERT INTO mihNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ta i sahan ra Simón Pedro ndya nu ndyaa barco, ta xita ra taraya tyiyaca nahnu cuan ndya nu ñiyɨtɨ. Ziendu uu xico usi uñi tahan tɨ ñoho, ta ñá tahndya taraya vazu cuaha xaan tɨ. ");
INSERT INTO mihNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ta i catyi ra Jesús sihin ra: Ñaha ndo vatyi curumuza ndo. Ta yoñi ra cuñi nducu tuhun sii ra Jesús yoo ra cuu ra vatyi sa sito ra vatyi ra Jesús cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ta i sahan ra Jesús, ta i quihin ra pan, ta i saha ra sii si sii ra. Ta tacuan tucu tyiyaca. ");
INSERT INTO mihNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ta ihya cuu sa cu uñi tahan saha i cahan ra Jesús sihin ra i casi ra ta sa yaha sa nandoto ra sisi sa i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ta sa yaha i curumuza ra, ta i catyi ra Jesús sihin ra Simón Pedro: Simón, zehe ra Jonás, ¿atu cuñi xaan con sii ta zɨquɨ ca inga ra ya? Ta i catyi ra Pedro sihin ra: Avi, tata, sa siton vatyi cuñi suun. Ta i catyi ra Jesús: Cuhvon sa casi mvee ticatyi lee zone. ");
INSERT INTO mihNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ta zɨquɨ i catyi ra Jesús sihin ra inga saha: Simón, zehe ra Jonás, ¿atu cuñi xoon sii? Ta i catyi ra Pedro: Avi, tata, sa siton vatyi cuñi suun. Ta i catyi ra Jesús sihin ra: Zacuenda vohon sii mvee ticatyi zone. ");
INSERT INTO mihNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ta zɨquɨ i catyi ra Jesús sihin ra sa cu uñi saha: Simón, zehe ra Jonás, ¿atu cuñun sii? Ta cuihya xaan i cuñi ra Pedro vatyi sa i nducu tuhun ra Jesús sii ra sa cu uñi tahan saha: ¿Atu cuñun sii? Ta i catyi ra sihin ra: Tata, sa sito moo tandɨhɨ cuii. Siton vatyi cuñi suun. Ta i catyi ra Jesús sihin ra: Cuhvon sa casi mvee ticatyi zone. ");
INSERT INTO mihNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sa ndisa ta sa ndisa catyi suhun vatyi quɨvɨ i culuhlun ta i cuu ndɨhvun zahmon maa tuhun ñun, ta sohon ndyamaa cuñun cuhun. Zoco quɨvɨ cua cusahnun cua zandundoon ndohon, ta inga ra cua natyihi ra zahmon suun. Ta cua cundyaca ra suun nu ña cuñun cuhun. Tacuan i catyi ra Jesús sihin ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ta sa i catyi ra Jesús tuhun cuan, i saha ra cuhva cutuñi iñi ra yozo caa cua tahan si sii ra Pedro sa cua cuu ra, ta cua zacahnu ra sii ra Ndyoo cuhva cuan. Ta sa ndɨhɨ cahan ra Jesús tacuan, ta i catyi ra sihin ra: Cundyicon sii. ");
INSERT INTO mihNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tacuan ta zɨquɨ i nandyehe sata ra Pedro, ta i ndyehe ra vatyi ndyico inga ra i casi ra Jesús, ra sa cuñi xaan ra Jesús. Zuun ra cuu ra sa nañaa sii ra Jesús minoo sa cuaa nu cua cuxiñi ra nu i nducu tuhun ra sii ra Jesús: ¿Yoo ra cua xico tuhun suun? ");
INSERT INTO mihNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ta sa ndyehe ra Pedro sii ra cuan, ta i nducu tuhun ra sii ra Jesús: Tata, ¿ta ñaa sa cua cuu sii ra ya? ");
INSERT INTO mihNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ta i catyi ra Jesús sihin ra: Tatu cuñi vatyi ndoo ra ñuu ñiyɨvɨ ndya quɨvɨ cua quisi ¿ta ñaa sa cuenda oo? Yoho cundyicon sii. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yucuan cuenda i quita tuhun ya, ta i sica iñi tandɨhɨ ñiyɨvɨ sino iñi vatyi i catyi ra Jesús vatyi ma cuu ra cuan, zoco ñá catyi ra Jesús sa ma cuu ra. I catyi ra: “Tatu cuñi vatyi ndoo ra ndya quɨvɨ cua quisi ¿ta ñaa sa cuenda oo?” ");
INSERT INTO mihNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ta zuun ñi maa ra cuu ra saha sa ndaa sa cuenda tuhun ya. Ta sito ndi vatyi ndisa cuii sa ndaa sa saha ra. ");
INSERT INTO mihNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ta iyo cuaha xaan ca sa i zavaha ra Jesús. Ta sica iñi vatyi tatu cua tyaa ñiyɨvɨ sii si minoo minoo si, ma cutahan tandɨhɨ libro nu sisi ñuu ñiyɨvɨ. Ndɨhɨ si vityi.");
INSERT INTO mihNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ta quɨvɨ cuan i tyei minoo carta suun Teófilo. Ta yucuan carta saha cuenda tandɨhɨ sa i zavaha ra Jesús ta tandɨhɨ sa zacuaha ra ndya casaha zatyiño ra cuhva ");
INSERT INTO mihNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ndya quɨvɨ i ndaa xica ñi ra ta cuahan ra gloria. Zoco cuee ca sa cuhun ra gloria ta sihin cuhva iyo sii Tatyi Ii ra Ndyoo i tahvi ra Jesús tyiño nuu sa usi ɨɨn tahan ca ra apóstol vatyi nacatyi ra tuhun ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ta zɨquɨ i sihi ra Jesús ta sa yaha i sihi ra ta zuun ñi maa ra Jesús i quituu nuu ra apóstol. Uu xico quɨvɨ i quituu ra tacuan, ta cuhva cuan i sito ñiyɨvɨ vatyi ndisa cuii i nandoto tucu ra. Ta i zacuaha ra sii ra yozo caa ndyaca ñaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ta sa ndyaa ra Jesús sihin ra i catyi ra sihin ra vatyi ma quita ra ñuu Jerusalén. Cua cuatu ra sii sa i cahan ra Ndyoo Zutu yo tuhun vatyi catyi ra Jesús sihin ra: ");
INSERT INTO mihNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Sa catyi sihin ndo vatyi ndisa cuii i zacoo ndutya ra Juan sihin ndutya, zoco ña cuaha ca quɨvɨ ta cua coo ndutya ndo sihin Tatyi Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tacuan ta quɨvɨ i titahan tucu ra Jesús sihin ra apóstol i ndaca tuhun ra cuan sii ra Jesús ta catyi ra: Tata, ¿atu sa cua cuhva tucun sa cundyaca ñaha ñiyɨvɨ hebreo tata maa ndi? ");
INSERT INTO mihNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ta i catyi ra Jesús sihin ra: Ma coto maa ndo ñaa quɨvɨ a ñaa yoo cua cundyaca ñaha tucu ñiyɨvɨ hebreo. Maa ñi maa ra Ndyoo Zutu yo tahan si coto cuhva cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Zoco cua ñihi ndo tundyee iñi sii ra Ndyoo vatyi cua noo xica Tatyi Ii sii ndo, ta cua cahan ndo sa cuenda mi ñuu Jerusalén, nacahnu Judea ta nacahnu Samaria ta nacahnu ñuu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ta sa ndɨhɨ cahan ra Jesús tacuan ta zuun ñi cuhva cuan i ndyehe ra apóstol vatyi i ndaa xica ñi ra Jesús ityi andɨvɨ, ta i tyazi minoo vico nu cuahan ra. Ta ñá ndyehe ca ra apóstol cuan sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ta zuun ñi cuhva sa ndyehe ra sa i ndaa ra ityi andɨvɨ ta nu yucu ra i quituu uu tahan ra yoco ñoho ra zahma cuisi. ");
INSERT INTO mihNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ta i catyi ra yoco cuan sihin ra: Ndoho ra ñuu Galilea, ¿ñacu ndyehe xaan ndo ityi zɨquɨ? Cuahan ra Jesús gloria, ta zuun ñi cuhva cuahan ra cua quisi tucu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tacuan ta zɨquɨ i quita ra apóstol yucu Olivos cuan. Cuahan ra ñuu Jerusalén. Yatyi ñi ndyaa yucu cuan sihin ñuu Jerusalén, tañi zava ora. ");
INSERT INTO mihNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ta sa saa ra yucuan, i quɨhvɨ ra minoo vehe toto ndya zɨquɨ vatyi yucuan ndyaa ra. Ra Pedro ta ra Juan, sihin ra Jacobo ta ra Andrés ta ra Felipe. Ra Tomás ta ra Bartolomé ta ra Mateo sihin ra Jacobo, zehe ra Alfeo. Ta ra Simón Zelote ta ra Judas yañi ra Jacobo. ");
INSERT INTO mihNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tandɨhɨ quɨvɨ i sica tahvi ra sii Ndyoo yucuan ɨɨn ñi sihin ña María zɨhɨ ra Jesús sihin inga ñu zɨhɨ ta sihin yañi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ta minoo quɨvɨ i titahan cuaha xaan ñiyɨvɨ tañi ziendu oco ñu, ta i nduvita ra Pedro (mahñu ñiyɨvɨ cuan) ta i catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ndoho yañi xaa, i cuñi si sa natahan si cuhva sa i catyi Tuhun Ndyoo nu i cahan ra David i zacuu Tatyi Ii ta saha cuenda ra sa cuenda ra Judas, ra i zañaha sii ra Jesús sii ra cua tɨɨn sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ta ra tahan yo i cuu sii ra Judas, ta zuun ñi tyiño zavaha yo i zavaha tucu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","I zata ra Judas cuan minoo ñuhu sihin xuhun i ñihi ra sihin cuatyi ra. Ta zuun ñi maa ra i cuñi cahñi sii ra. I tyihi ra minoo yoho zucu ra, zoco i canacava ra sihin nuu ra ta i ndata sisi ra ta i quita tandɨhɨ sɨtɨ ra. Ta i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Sito tandɨhɨ ñiyɨvɨ ñuu Jerusalén cuhva i tahan ra Judas. Yucuan cuenda i zacunañi ñu ñuhu cuan Acéldama sihin tuhun maa ñu. Cuñi si catyi si: Ñuhu nu i sati nɨñɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sisi libro Salmos catyi ra Ndyoo sa cuenda ra Judas: Cua ndoo ihno vehe ra. Yoñi ñiyɨvɨ cua cundyaa yucuan. Ta tyiño i sindyizo maa ra cua naquihin inga ra. Catyi si. ");
INSERT INTO mihNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ta zɨquɨ i catyi tucu ra Pedro: Yucuan cuenda cua naquihin inga ra tyiño i sindyizo ra Judas ta cua nacatyi tucu ra sihin ñiyɨvɨ vatyi ndisa sa i nandoto tucu ra Jesús. Cuñi si sii minoo ndoho ra i casaha sica sihin ra Jesús quɨvɨ i zacoo ndutya ra Juan sii ra ta cutahan ra sihin ra ndya quɨvɨ i ndaa xica ñi ra Jesús ityi andɨvɨ. ¿Yoo ndoho cuu ndo? Catyi ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tacuan ta i ñihi ra uu tahan ra. Minoo ra nañi ra José ta nañi tucu ra Barsabás. Justo xiñi zɨvɨ ra. Ta inga ra nañi ra Matías. ");
INSERT INTO mihNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tacuan ta i sica tahvi tandɨhɨ ñu sii ra Ndyoo ta i catyi ñu: Zutu mañi yuu, siton añima tandɨhɨ ñiyɨvɨ. Zañohon sii ndi yoo ra cuñi moo ");
INSERT INTO mihNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","sa naquihin ra tyiño i sindyizo ra Judas vatyi i ndoyo ñuhu ra ta cuahan ra nu tahan si sii maa ra sa cuhun ra, nu xaan. Catyi ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ta i sizɨquɨ ra zuhva cua ndyehe ra yoo ra cua zahacanaa, ta i tahan si sii ra Matías. Tacuan ta i nduu tucu ra cuan minoo apostól sihin inga sa usi ɨɨn tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","I saa quɨvɨ sa zacahnu ñiyɨvɨ hebreo minoo vico sa nañi Pentecostés, ta i titahan tandɨhɨ ñiyɨvɨ ndyico sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Yatyi xaan i quisaha quisi minoo nduzu ndya yutyi andɨvɨ. Tañi minoo tatyi cahnu, tacuan i cuu nduzu cuan, ta i situ cuii nduzu vehe nu yucu ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ta i ndyehe ñu minoo tañi caa yaa ñuhu. I quɨtɨ cuatyi si ta i sicozo si xiñi ɨɨn ɨɨn ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","I situ Tatyi Ii ra Ndyoo sii tandɨhɨ ñu, ta i quisaha cahan ñu tuhun sa ña tuhva ñu cahan. I cahan ñu sihin cuhva saha Tatyi Ii sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ta quɨvɨ cuan i siyucu cuaha xaan ñiyɨvɨ hebreo ñuu Jerusalén. Zɨɨn zɨɨn ñuu i quisi ra ta saa ra ñuu Jerusalén. Ndyico vaha ra sii costumbre maa ra. ");
INSERT INTO mihNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ta i siñi tucu maa ra cuan nduzu sa quita andɨvɨ. Yucuan cuenda i tuhva tandɨhɨ ra. Ñá cutuñi iñi ra ñaa cuenda siñi ra sa cahan ñiyɨvɨ. Vatyi tandɨhɨ cuhva cahan ñu, siñi ra hebreo cuan vatyi cahan ñu cuhva cahan ñiyɨvɨ zɨɨn zɨɨn ñuu, nu i quita ra hebreo. ");
INSERT INTO mihNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iyo xaan i cuñi ra hebreo cuan, ta i quisaha catyi ra sihin tahan ra: Tandɨhɨ ñiyɨvɨ ya, ñiyɨvɨ Galilea cuu ñu, zoco cahan ñu cuhva cahan maa yo. ");
INSERT INTO mihNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Siñi yo sa cahan ñu. Cahan ñu cuhva cahan ñiyɨvɨ ñuu nu quita maa yo, ta zɨɨn zɨɨn ñuu yo. ");
INSERT INTO mihNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ñiyɨvɨ ñuu Partia, Media, ta Elam cuu yo sihin ñiyɨvɨ ñuu Mesopotamia, Judea, Capadocia, Ponto ta Asia. ");
INSERT INTO mihNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Iyo yo cuu yo ra ñuu Frigia, Panfilia, Egipto ta Libia yatyi ñi Cirene, ta iyo yo cuu yo ra ñuu Roma ");
INSERT INTO mihNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","tata hebreo, ta inga yo ra ñuu Roma, zacuaha yo costumbre ñiyɨvɨ hebreo. Iyo yo quita ñuu Creta ta ñuu Arabia ta siñi yo sa cahan ñu tandɨhɨ cuhva cahnu xaan zavaha ra Ndyoo. Catyi ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ta iyo xaan i cuñi ra ta ñá sito ra ñaa sa cuu. Ta i natuhun tahan ra ta catyi ra: ¿Ñaa sa cuu? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Zoco inga ra i sacu ndyaa ta catyi ra: Sihi xaan ñu ya ndixi (ta siñi ñu). ");
INSERT INTO mihNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tacuan ta i nacuɨñɨ ndyaa ra Pedro sihin sa usi ɨɨn tahan ca ra apóstol ta saa xaan i cahan ra Pedro sihin ñiyɨvɨ cuan ta catyi ra: Ndoho sa ndyaa ihya nu cu si Judea ta tandɨhɨ inga ndo sa vasi ñuu Jerusalén ya, tyizoho vaha ndo ta cuɨñɨ ndo sa quehin. ");
INSERT INTO mihNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ña siñi ndi tañi sica iñi maa ndo vatyi nacaa cuu si caa ɨɨn sa ñaha ñi. ");
INSERT INTO mihNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sicoo minoo ra sinañi Joel ta tyiemvu. I cahan ra sa cuenda ra Ndyoo ta i catyi ra vatyi cua tahan si cuhva sa ndyehe ndo vityi vatyi i catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Nu cua ndɨhɨ tyiemvu cua tasi Tatyi Ii, catyi ra Ndyoo, ta cua noo ra zɨquɨ tandɨhɨ ñiyɨvɨ. Zehe ndo cua cahan ñu tuhin. Cua ndyehe ra yoco sa cua zañehi sii ra. Ta cua cahan ñimahna xiñi ra sahnu. ");
INSERT INTO mihNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ndisa, vatyi cua noo Tatyi Ii sii tandɨhɨ ñiyɨvɨ ndyico sii mi sa ndisa, ta cua cahan ñu cuhva cua quehin sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ta cua zavehi sa ndyityi ityi andɨvɨ ta nu ñuhu ñuu ñiyɨvɨ. Nɨñɨ ta ñuhu ta ñuhma. ");
INSERT INTO mihNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Cua nduñaa ñicandyi ta cua nducuaha yoo tañi nɨñɨ. Tacuan cua cuu si ta cua coo minoo quɨvɨ cahnu xaan, quɨvɨ cua tasi tuñi sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ta tandɨhɨ ra cua cahan ndahvi sihin mi, cua cacu ra. Tacuan i catyi ra Ndyoo, i catyi ra Joel. ");
INSERT INTO mihNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ta sa yaha nacatyi ra Pedro cuhva cuan ta i catyi tucu ra: Ndoho, ñiyɨvɨ hebreo tyizoho ndo tuhun ya: Ra Jesús ñuu Nazaret i sindyizo ra tyiño saha ra Ndyoo sii ra. Ta tañi sa sito ndo i saha ra Ndyoo sa zavaha ra cuaha xaan sa ndyityi ta cuaha xaan zeña nuu ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ta i sito ra Ndyoo vatyi cua cuhva ra sa tyaa ñiyɨvɨ cuatyi sata ra Jesús. Ta maa ndo i saha ndo sa cahñi ñiyɨvɨ ña sito sii ra Ndyoo sii ra nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Zoco i zanandoto ra Ndyoo sii ra Jesús, ta i tava ra sii ra nu iyo ñɨyɨvɨ i sihi vatyi ma cuu ndoo ra yucuan. ");
INSERT INTO mihNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","I cahan ra David ta tyiemvu sa cahan ra Jesús ta catyi ra: Site vatyi ndyaa ra sahnu sihin. Tandɨhɨ cuii tyiemvu iyo ra sihin. Yucuan cuenda ma cuyuhi. ");
INSERT INTO mihNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yucuan cuenda zɨɨ xaan cuñi, ta cua nacatyi sihin ndo vatyi zɨɨ cuñi. Site vatyi cua nandote sisi sa i sihi. ");
INSERT INTO mihNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ma caca xaan iñi vatyi ma zandoon sii, nu caa ndɨyɨ Ndyoo Zuti. Ta ma cuhvon sa tyahyu coño ñuhi vatyi zehe iun sii. ");
INSERT INTO mihNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sa zañohon sii yozo caa cua cundite suhun. Zɨɨ xaan cua cuñi vatyi cua cundyei suhun. Tacuan i cahan ra David cuhva i cahan ra Jesús sihin ra Ndyoo Zutu ra ta tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ta i cahan ca ra Pedro ta catyi ra: Ndoho amigos, ndoo xaan cua nacatyi sihin ndo ñaa sa i tahan ra sahnu David, ñiyɨvɨ sii yo ta tyiemvu. I sihi ra, ta i quɨhvɨ ra ñuhu. Ta ihya iyo ñaña ra ndya cuhva ndya vityi. Ta tacuan cuu cuhva sito yo vatyi yɨvɨ tuhun sa zuun ñi maa ra cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","I cahan ra David cuhva i cahan Tatyi Ii ra Ndyoo sihin ra, ta i sito ra vatyi cua zavaha ra Ndyoo tuhun i cahan ra sihin ra vatyi i catyi ra Ndyoo sihin ra: “Ityi nuu ca cua cundyaca ñaha minoo ñiyɨvɨ suun. Tañi ndyaca ñaha moo tacuan cua cundyaca ñaha maa ra.” ");
INSERT INTO mihNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","I sito ra David tyiño cuan ta tyiemvu, ta i catyi ra vatyi cua nandoto tucu ra Jesús. Yucuan cuenda i catyi ra David sa cuenda ra Cristo vatyi ma ndoo ra nu caa ndɨyɨ. Ta ma tyahyu coño ñuhu ra. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","I zanandoto ra Ndyoo sii ra Jesús ta i ndyehe tandɨhɨ ndi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ta cuahan ra Jesús gloria, ta saha ra Ndyoo cuaha xaan cuhva sii ra. Ndyaa ra ityi siyo cuaha ra Ndyoo. Ndya ta sa naha xaan ca i catyi ra Ndyoo: “Cua saa quɨvɨ cua cuhun Tatyi Ii vii ñuu ñiyɨvɨ.” Ta yucuan cuenda i tasi ra Jesús sii Tatyi Ii ihya. Tatyi Ii ra Ndyoo zavaha tandɨhɨ sa ndyehe ndo ta sa siñi ndo vityi vatyi sa i saa ra. Catyi ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ta zɨquɨ i catyi tucu ra Pedro: I saha ra David cuenda yozo caa cua tahan si sii ra Jesús ityi zɨquɨ vatyi yɨvɨ ra David i sahan gloria. Zoco i cahan ra tuhun cuhva cua tahan si sii ra Jesús ta i catyi ra: Moo cuu ra ndyaca ñaha sii mi. Ta catyi ra Ndyoo Zutu yo suhun: “Cundyoon ihya siyo cuehi. ");
INSERT INTO mihNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Iyo cuaha xaan ra cuxaan suun, zoco cua zahacanoon sii ra vatyi sehi cuhva suun.” Tacuan i catyi ra Ndyoo sihin ra Jesús, catyi ra David. ");
INSERT INTO mihNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tacuan i cahan ra Pedro sihin ñiyɨvɨ hebreo tandɨhɨ cuhva cuan, ta i catyi tucu ra: I tyaa maa ndo sii ra Jesús nu cruz, zoco i zanducahnu xaan ra Ndyoo sii ra, ta vityi ndyaca ñaha maa ra, ta zacacu ra sii ñiyɨvɨ. Yucuan cuenda tyizoho ndo ta coto ndo sa quehin. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ta sa siñi ñiyɨvɨ sa cahan ra Pedro ta i sica xaan iñi ñu, ta i catyi ñu sihin ra Pedro ta sihin tandɨhɨ inga ra apóstol: ¿Amigo, ñaa sa cuñi si zavaha ndi? Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ta i catyi ra Pedro sihin ñu: Tahan tahan ndo ndu‑uu iñi ndo cuatyi ndo ta coo ndutya ndo cuenda ra Jesucristo, ta cua zandasi ra Ndyoo cuatyi ndo. Ta cua cuhva ra Ndyoo sa noo Tatyi Ii sii ndo vatyi yucuan cuu sa cua cuhva ra Ndyoo sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Vatyi ta tyiemvu i saha ra Ndyoo tuhun ra sii ndo ta sii zehe ndo ta sii tandɨhɨ cuii ñiyɨvɨ, tandɨhɨ ñu sa cua nacana ra Ndyoo. Cua sino iñi ñu sii ra. Ta maa ra cua cundyaca ñaha sii yo. ");
INSERT INTO mihNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Cuaha xaan tuhun i cahan ra Pedro ta i saha ra sa siñi tuñi sii ñiyɨvɨ. I catyi ra sihin ñu: Zavaha ndo sa vaha nuu ra Ndyoo coto zanaa ra sii ndo sihin ñiyɨvɨ ña vaha. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ta cuaha xaan ñiyɨvɨ i sino iñi tuhun cahan ra Pedro ta i sicoo ndutya ñu. Yucuan quɨvɨ i sino iñi tañi uñi mil ñiyɨvɨ sii Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tandɨhɨ quɨvɨ i titahan ñu cuan. I zacuaha xaan ñu sihin ra apóstol. Sasi ñu pan ta sihi ñu ndutya uva vatyi nacohon iñi ñu vatyi sihi ra Jesús, sa cuenda maa ñu, ta ɨɨn ñi i sica tahvi ñu sii Ndyoo tandɨhɨ quɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Cuaha xaan sa ndyityi i zavaha ra apóstol, ta iyo xaan i cuñi ñiyɨvɨ vatyi i ndyehe ñu sa zavaha ra cuan ta yuhu ñu vatyi i ndyehe ñu yozo caa iyo ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tandɨhɨ ñiyɨvɨ sa sino iñi, ɨɨn ñi i siyucu ñu, ta i tyindyee tahan ñu sii tahan ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ta tatu cumañi xuhun i naxico ñu ñaa sa iyo sii ñu. I naxico ñu ñuhu ñu sihin ndaha tyiño ñu ta i saha ñu xuhun ñihi ñu sii inga ñiyɨvɨ sino iñi tatu cumañi si sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tandɨhɨ quɨvɨ i titahan ñu vehe ñuhu hebreo ta vehe ñiyɨvɨ ta i sasi ñu pan ta sihi ñu ndutya uva sa cuenda ra Jesús ta ɨɨn ñi i sasi ñu xita tandɨhɨ quɨvɨ. Zɨɨ xaan i cuñi ñu ta ña cuihna iñi ñu sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","I zacahnu xaan ñu sii ra Ndyoo, ta vaha xaan cahan tandɨhɨ ñiyɨvɨ sa cuenda ñu. Ta tandɨhɨ quɨvɨ i saha ra Ndyoo sa sino iñi inga ca ñiyɨvɨ Tuhun ra. ");
INSERT INTO mihNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Minoo quɨvɨ cuahan ra Pedro ta ra Juan vehe ñuhu hebreo cuhva caa uñi sa sahiñi. Yucuan cuhva tuhva ñiyɨvɨ hebreo cahan sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ta sa cua saa ra yucuan ta i quisi ndyaca ñiyɨvɨ sii minoo ra xii. Tacuan sindyaca ñu sii ra tandɨhɨ quɨvɨ ta caa ra yuvehe nañi yuvehe tyaqui vatyi caca ra caridad. ");
INSERT INTO mihNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ta sa ndyehe ra sii ra Pedro ta ra Juan sa cua quɨhvɨ ra vehe ñuhu ta i sica ra caridad sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","I ndyehe xaan ra Pedro ta ra Juan sii ra, ta zɨquɨ i catyi ra Pedro: Ndyehun sii ndi. ");
INSERT INTO mihNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ta i ndyehe ra xii cuan vatyi sica iñi ra sa cua cuhva ra xuhun sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Zoco i catyi ra Pedro: Ñahñi xuhun ndyize sa cuhve suun zoco iyo cuhva sii sa tyindyei suun vatyi iyo cuhva sii maa ra Jesucristo, ra ñuu Nazaret, sa tyindyee ra suun. Sa cuenda maa ra cuan catyi suhun: Nduviton ta cacon. Catyi ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","I tɨɨn ra Pedro ndaha siyo cuaha ra, ta i zanduvita ra sii ra. Ta zuun ñi caa cuhva cuan ndaha i nduvaha ñi saha ra. ");
INSERT INTO mihNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","I ndava ra xii cuan ta i quisaha ra sica ra. I quɨhvɨ ra si vehe ñuhu sihin ra Pedro ta ra Juan. Sica ra. Ndava ndava ñi ra, ta zacahnu xaan ra sii Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","I ndyehe tandɨhɨ ñiyɨvɨ sa sica ra, ta i zacahnu xaan ñu sii Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ta i nacoto ñu sii ra vatyi ra sica caridad yuvehe ñuhu cuu ra, ra sa tuhva sindyaa yuvehe sa nañi yuvehe tyaqui. Ta iyo xaan i cuñi ñu sihin cuhva sa tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ta ñá zaña ra cuan sii ra Pedro sihin ra Juan. Iyo xaan i cuñi ñiyɨvɨ, ta yatyi xaan i titahan ñu nu ndyaa ra corredor cuan. Nañi si corredor sii ra Salomón. ");
INSERT INTO mihNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","I ndyehe ra Pedro sa titahan ñiyɨvɨ ta i quisaha catyi ra: Iyo xaan cuñi ndo amigo vatyi ndyehe ndo sa nduvaha saha ra ya. Ndyehe xaan ndo sii ndi vatyi sica iñi ndo vatyi iyo xaan cuhva sii maa ndi a sica iñi ndo vatyi vaha xaan ñiyɨvɨ cuu ndi ta yucuan cuenda i zanacaca ndi sii ra ya. Zoco ña tacuan amigo. ");
INSERT INTO mihNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ñiyɨvɨ sahnu sii yo, ra Abraham, ra Isaac, ta ra Jacob i zacahnu ra sii Ndyoo. Ta zuun ñi maa ra Ndyoo i zacahnu sii ra Jesús, zehe ra. (I saha maa ndo sii ra Jesús sii ra ndyaca ñaha) ta i catyi maa ndo nuu ra Pilato vatyi ña vaha ra. Sa sica iñi ra Pilato sa cua zaña ra sii ra Jesús, zoco ñá saha maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ñá saha ndo sa zaña ra Pilato sii ra ta ra ii xaan cuu ra Jesús. Ra vaha xaan cuu maa ra. I sica ndo tumañi iñi sii ra Pilato sa zaña ra sii inga ra cuhva iyo costumbre sa cua zaña ra sii minoo ñiyɨvɨ quɨvɨ vico cuan. Ta yucuan cuenda i zaña ra sii inga ra cuan, ra sahñi sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Cuhva cuan i sahñi maa ndo sii ra Jesús vazu maa ra saha cuhva cundito ñiyɨvɨ sihin Ndyoo. Zoco i zanandoto tucu ra Ndyoo sii ra. Ñá ndoo ra nu iyo ndɨyɨ. Ta i ndyehe maa ndi sa yaha nandoto ra. ");
INSERT INTO mihNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sa ndyehe ndo sii ra xii ya, nacoto ndo sii ra. Sino iñi ndi vatyi iyo cuhva sii ra Jesús ta yucuan cuenda i zanduvaha ra Ndyoo saha ra. Sino iñi ndi sii ra Jesús. Yucuan cuenda i nduvaha ra ya, ta i ndyehe tandɨhɨ ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Amigo. Site vatyi ña sito ndo sa zavaha ndo sa ña vaha (sa sahñi ndo sii ra Jesús) ta tacuan tucu ra ndyaca ñaha sii ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ta tyiemvu i nacatyi ra Ndyoo sihin yo vatyi cua tahan ra Cristo tundoho. Maa ra cuu ra i casi ra Ndyoo vatyi cua zacacu ra sii yo, ta cua cuu ra vatyi tacuan i catyi ra Ndyoo sihin tandɨhɨ ra profeta. Ta tacuan i tahan si sii ra Jesús, zuun ñi cuhva i catyi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ta vityi zandoo ndo cuatyi ndo ta nanducu ndo sii Ndyoo ta cua zandasi ra cuatyi ndo ta cua nduvaha añima ndo ta zɨɨ cua cuñi ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ta cua tasi tucu ra Ndyoo sii ra Jesús inga saha vatyi maa ra cuu ra ndyizo tyiño i zacuu ra Ndyoo. Nu ndyaa ndo cua tasi tucu ra Ndyoo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Zoco vityi ndyaa ra gloria ndya quɨvɨ cua ndusaa ñuhu ñuu ñiyɨvɨ inga saha tañi i catyi ra Ndyoo. Vatyi tacuan i catyi ra Ndyoo sihin ra profeta ta sa naha. ");
INSERT INTO mihNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ta sa naha i catyi ra Moisés: “Cua tasi ra Ndyoo minoo ra cuu ñiyɨvɨ sii yo tañi i tasi ra sii mi, ta cua cahan ra Tuhun Ndyoo. Tyizoho ndo tandɨhɨ ñaa sa cua cahan ra sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tatu ma tyizoho ñiyɨvɨ sa cahan ra cuan, cua cuu ñu, ta ma cuu quɨhvɨ ñu sihin ñiyɨvɨ i casi ra Ndyoo.” Tacuan i catyi ra Moisés i catyi ra Pedro. Ta zɨquɨ i catyi tucu ra: ");
INSERT INTO mihNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ndisa vatyi tandɨhɨ ra profeta ta tyiemvu ndya quɨvɨ i quisaha cahan ra Samuel i catyi ra yozo caa cua quisi ra Jesús nu cua quisi quɨvɨ. Ta sa i tahan si cuhva catyi ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ta maa yo ñiyɨvɨ hebreo cuu ñiyɨvɨ sii ra profeta cuan, ta i saha ra Ndyoo tuhun ra sii ñiyɨvɨ sii maa yo vatyi i catyi ra Ndyoo sihin ra Abraham: “Cua cuhve ndatu sii tandɨhɨ ñiyɨvɨ ñuu ñiyɨvɨ sa cuenda minoo ñiyɨvɨ suun.” Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ta yucuan cuenda i saha ra Ndyoo tyiño sii ra Jesús, zehe ra. I tasi ra Ndyoo sii ra nu iyo maa ndo sa xihna ñi vatyi cuñi ra zavaha ra tumañi iñi sii tandɨhɨ ndo. Cuñi ra sa zandoo tandɨhɨ ndo cuatyi ndo. Tacuan i catyi ra Pedro sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ta cahan ca ra Pedro ta ra Juan sihin ñiyɨvɨ ta i quisi ra cu zutu ta ra cu nuu sii policía sa cuenda vehe ñuhu ta ra saduceo. (Ña sino iñi maa ra saduceo cuan vatyi cua nandoto ñiyɨvɨ tatu sa sihi ñu.) ");
INSERT INTO mihNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Cuxaan ra cuan vatyi zacuaha ra apóstol sii ñiyɨvɨ cuhva i nandoto tucu ra Jesús sisi sa i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","I tɨɨn ra sii ra Pedro ta ra Juan, ta i tyihi ra sii ra vehe caa sa iyo cuenda vehe ñuhu cuan. Ndya inga quɨvɨ cua cutuñi ra vatyi sa cua cuaa cuhva i tɨɨn ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Cuaha xaan ñiyɨvɨ i siñi ñu tuhun zacuaha ra Pedro ta ra Juan ta i quisaha sino iñi ñu sii ra Jesús. I sino iñi sa yatyi ñi ohon mil rayɨɨ quɨvɨ cuan ta zɨɨn ñu zɨhɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ta inga quɨvɨ i titahan tandɨhɨ ra cu zutu nahnu sihin ra mandoñi ta ra maestro cuenda ley. I titahan ra cuan ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","I quisi ra Anás, ra cu nuu sii zutu nahnu sihin ra Caifás ta sihin ra Juan ta ra Alejandro ta tandɨhɨ ñiyɨvɨ sii ra cu nuu sii zutu nahnu cuan, ndɨhɨ ca. ");
INSERT INTO mihNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","I cana ra sii ra Pedro ta ra Juan ta i quɨhvɨ ra nu yucu ra cu tyiño cuan ta i quisaha ndaca tuhun ra cuan sii ra ta catyi ra: ¿Yozo caa i zanduvaha ndo sii ra xii cuan? ¿Yoo ra i saha cuhva cuan sii ndo? Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","I tyindyee Tatyi Ii ra Ndyoo sii ra Pedro, ta i quisaha catyi ra Pedro: Ndoho ra ndyaca ñaha ta ra nahnu, ");
INSERT INTO mihNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ndaca tuhun xaan ndo sii ndi vityi sa cuenda minoo sa vaha i zavaha ndi sihin ra xii ndahvi ya. Cuñi ndo coto ndo yozo caa i nduvaha ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tatu yucuan cuñi ndo coto ndo, cua nacatyi sihin ndo ta cua coto ndo sihin tandɨhɨ ñiyɨvɨ hebreo vatyi i nduvaha ra vatyi iyo xaan cuhva sii ra Jesús, ra ñuu Nazaret. I tyaa ndo sii ra nu cruz, zoco i zanandoto ra Ndyoo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tañi minoo ra zandaa vehe sihin yuu cuu ndo ta zavita ndo yuu vaha. Tañi minoo yuu vaha xaan cuu ra Jesús, ta i tava ndo sii ra, ta ra ñiñi xaan cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Zacacu ra Jesús sii ñiyɨvɨ, ta yoñi inga ca ra nacahnu ñuu ñiyɨvɨ sa cuu zacacu sii yo ta ma cuhun yo andyaya. Tacuan i catyi ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ta i ndyehe ra cu tyiño vatyi ña yuhu ra Pedro ta ra Juan ta sito ra vatyi ñahñi zɨcuela siñoho ra (ta yɨvɨ ra tuhva cuu ra). Ta yucuan cuenda iyo xaan i cuñi ra zoco i nacoto ra vatyi ra i sica noo sihin ra Jesús cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ta i ndyehe ra cu tyiño vatyi ndyaa ra xii cuan sihin ra. Sa nduvaha ra. Ta yucuan cuenda ñá ñihi ca ra cuhva cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tacuan ta i tava ra sii tandɨhɨ uñi tahan ra sata vehe vatyi cuñi ra sa natuhun tahan xihna ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","I catyi ra: ¿Ñaa sa cuu zacuu yo sihin ra ya? Ma cuu catyi yo vatyi zavaha ra sa ña vaha vatyi i zavaha ra minoo sa ndyityi cahnu xaan ta sito vaha tandɨhɨ ñiyɨvɨ ñuu ya. ");
INSERT INTO mihNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Cua zayuhu yo sii ra ta cua catyi yo: “Ma cahan ca ndo tuhun ra Jesús.” Tacuan cua catyi yo ta ma coto cuaha ca ñiyɨvɨ cuhva i nduvaha ra xii. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tacuan ta zɨquɨ i cana ra sii ra ta i catyi ra: Ma cahan ca ndo tuhun ra Jesús, ta ma zacuaha ca ndo sii ñiyɨvɨ. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Zoco i catyi ra Pedro ta ra Juan: Nacañi xihna iñi ndo ta zɨquɨ catyi ndo ñaa sa cuu sa vaha sa cuenda ra Ndyoo. ¿Atu vaha cua tyaa ndi yahvi sa cahan maa ndo a vaha tyaa ndi yahvi sa cahan ra Ndyoo? ");
INSERT INTO mihNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Catyi ndi vatyi ma cuu sa cutaxi ndi vatyi ñiñi xaan cua nacatyi ndi sa ndyehe ndi. Cua nacatyi ndi sa siñi ndi. Tacuan i catyi ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tacuan i cuu si, ta i zayuhu ra cu tyiño sii ra inga saha, ta zɨquɨ i zaña ra sii ra vatyi ñá ñihi ra cuhva tyaa ra cuatyi sata ra coto cuxaan ñiyɨvɨ ñuu. Zacahnu xaan ñiyɨvɨ cuan sii ra Ndyoo vatyi sito ñu cuhva i nduvaha ra xii cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Vatyi sa uu xico cuiya sa ndyaa ra cuan tundoho ta i nduvaha ra. I ndyehe ñiyɨvɨ cuhva iyo ra Ndyoo vatyi i zanduvaha ra sii ra xii cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","I quita ra Pedro ta ra Juan ta cuahan ra ndya nu yucu inga ñiyɨvɨ sino iñi sii ra Jesús. I nacatyi ra sihin ñu tandɨhɨ sa i catyi ra zutu nahnu ta ra sahnu cuan sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","I tyizoho ñu sa cahan ra, ta zɨquɨ ɨɨn ñi cuhva i sica tahvi ñu sii ra Ndyoo ta catyi ñu: Zutu mañi yo, i zavohon yutyi andɨvɨ ta ñuhu ñuu ñiyɨvɨ sihin tyañuhu. Yoho i zavaha tandɨhɨ cuii sa iyo. ");
INSERT INTO mihNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ta tyiemvu i cohon sihin ra David ra i cuu muzun ta ñiyɨvɨ sahnu sii ndi. Ta i tyaa ra cuhva i cohon: Ndisa cuxaan xaan ñiyɨvɨ inga ñuu. Ta ndisa vatyi cuaha xaan cuhva sica iñi ñiyɨvɨ hebreo ta sa caha ñi cuu cuhva sica iñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Cua titahan ra cu tyiño sii ñu sihin ra cu tyiño hebreo. Cua cuñi ra cahñi tahan ra sihin ra Ndyoo ta sihin ra Cristo, ra ndyizo tyiño ra Ndyoo. Tacuan i tyaa ra David ta tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ta i cahan ca ñiyɨvɨ cuan sihin ra Ndyoo ta catyi ñu: Ihya ñuu ya ndisa cuii vatyi i titahan ra Herodes ta ra Poncio Pilato ta ra i quisi inga ñuu ta ra tata hebreo, ta i sahñi ra sii ra Jesús, ra cuu muzu iun. Ta ra Jesús cuu ra i tasun vatyi cua cuizo ra tyiñon. ");
INSERT INTO mihNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Zoco tacuan i zavaha ra cuan vatyi ta tyiemvu i tyoon cuhva yozo caa cua tahan si. ");
INSERT INTO mihNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ta vityi Zutu mañi yo, cuñi ra zayuhu ra sii ndi. Cuhvon tundyee iñi sii ndi vatyi muzun cuu sii ndi. Ma cuhvon sa cua yuhu ndi nu zuhva. Ta cuhvon sa cua zacoto maa ndi sii ñiyɨvɨ Tuhun moo. ");
INSERT INTO mihNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Zanduvohon sii ñiyɨvɨ cuhu ta zavohon sa ndyityi sa cuenda ra Jesús, ra cuu muzu iun. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ta sa ndɨhɨ sica tahvi ñu sii Ndyoo, ta i taan nu yucu ñu, ta i situ Tatyi Ii ra Ndyoo sii tandɨhɨ ñu, ta ñá yuhu ca ñu, ta i nacatyi ñu Tuhun Ndyoo sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Inuu ndita ñi i sicoo tandɨhɨ ñu sino iñi. Numinoo ra ta ñá catyi ra vatyi iyo ndaha tyiño ra vatyi inuu ndita ñi i sicoo tandɨhɨ ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Sihin cuaha xaan cuhva i nacatyi ra apóstol sihin ñiyɨvɨ cuhva i nandoto tucu ra Jesús. Ta i saha xaan ra Ndyoo tumañi iñi sii tandɨhɨ ñu sino iñi. ");
INSERT INTO mihNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ñahñi i cumañi sii tandɨhɨ ñu vatyi tatu iyo ñuhu a vehe ñu i xico ñu sii si tatu cumañi xuhun. Ta i quisi ndyaca ñu xuhun sa cuyahvi si. ");
INSERT INTO mihNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ta i saha ñu sii si sii ra apóstol, ta i saha maa ra sii ñu nu cumañi si. ");
INSERT INTO mihNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tacuan i zavaha minoo ra nañi José. I zama ra apóstol zɨvɨ ra. Bernabé i zacunañi ra sii ra vatyi i saha xaan ra tundyee iñi sii tandɨhɨ ñiyɨvɨ. Ra ñuu Chipre i cuu ra ta ñiyɨvɨ sii ra Leví, ra i sihi ta tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","I xico ra ñuhu ra, ta i quisi ndyaca ra xuhun yahvi si, ta i saha ra sii si sii ra apóstol. ");
INSERT INTO mihNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ta sicoo minoo ra nañi Ananías. Ta Safira nañi ñazɨhɨ ra. I xico tucu maa ñu minoo ñuhu ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","I tava ra Ananías zuhva xuhun sa cuu yahvi si, ta sito tucu ñazɨhɨ ra. Ta i sindyaca ra tandɨhɨ ca si, sii ra apóstol ta catyi ra: Vasi ndyaque tandɨhɨ xuhun sa cuu yahvi ñuhu i xique. ");
INSERT INTO mihNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ta i quisaha catyi ra Pedro sihin ra: Yoho Ananías, sohon sa zatɨvɨ cuihna suun vatyi zandavi ñohon sii Tatyi Ii. I tavon zuhva xuhun sa cuu yahvi ñuhu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ndisa, ñuhu moo i cuu si, ta yoñi sa catyi suhun vatyi xicon sii si. Ta ndisa vatyi yahvi ñuhu cuan cuu sii moo sa i xicon sii si. Ta ¿ñaa cuenda sica iñun cuhva ña vaha ya? Yɨvɨ sii ñiyɨvɨ zandavi ñohon. Sii ra Ndyoo zandavi ñohon. ");
INSERT INTO mihNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ta sa siñi ra Ananías tuhun cahan ra Pedro ta i nduva ra, ta i sihi ra. Ta tandɨhɨ ñiyɨvɨ i sito tuhun cuan, i yuhu xaan ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","I quɨhvɨ ra yoco ta i nazucu ra zahma sii coño ñuhu ra, ta i quihin ra sii ra, ta tyihi ra si ñuhu. ");
INSERT INTO mihNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ta i yaha tañi uñi ora ta i saa ñazɨhɨ ra. Ta coto ca ña ñaa sa tahan yɨɨ ña. ");
INSERT INTO mihNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","I quisaha ndaca tuhun ra Pedro sii ña ta catyi ra: ¿Atu ihya ñi yahvi i xico ndo ñuhu ndo? Ta i catyi tucu maa ña: Avi. Tacuan ñi i cuu yahvi si. ");
INSERT INTO mihNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","I catyi tucu ra Pedro sihin ña: Ña vaha sa zacasi tahan ndo tuhun ta zandavi ñaha ndo sii Tatyi Ii. Ndyehe, vatyi sa vasi tucu ra yoco. Ndya sehe ca i tyihi ra sii yɨun si ñuhu. Ta vityi vasi quihin tucu ra suun. ");
INSERT INTO mihNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ta ta sica cuii ñi i nduva ña saha ra Pedro ta i sihi ña. I quɨhvɨ ra yoco ta i ndyehe ra vatyi sa i sihi ña, ta i cañihi ra sii ña ta tyihi ra sii ña si ñuhu yatyi ñi nu i quɨhvɨ yɨɨ ña. ");
INSERT INTO mihNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","I sito tandɨhɨ ñiyɨvɨ sa tahan ñu ta yuhu xaan ñu, ta yuhu xaan ñiyɨvɨ sino iñi sii Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Zavaha ra apóstol cuaha xaan sa ndyityi nu yucu ñiyɨvɨ. Tandɨhɨ ñiyɨvɨ sino iñi sii ra Jesús i titahan ñu sisi vehe ñuhu hebreo minoo corredor nañi si Corredor sii ra Salomón. ");
INSERT INTO mihNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yoñi inga ñiyɨvɨ i cahan ndya vaha ñi sii ñu vatyi i sito tandɨhɨ ñiyɨvɨ vatyi vaha xaan ñiyɨvɨ cuu ñu sino iñi. ");
INSERT INTO mihNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ta vazu i yuhu ñiyɨvɨ, zoco cuaha xaan ca ñu i sino iñi sii ra Jesús. I sino iñi rayɨɨ ta tacuan tucu ñu zɨhɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ta sa cuenda tyiño ra apóstol i saqui ñiyɨvɨ sii ñiyɨvɨ cuhu ityi, nu sito a nu yuu vatyi tatu cua yaha ra Pedro vazu xiñahñu ñi ra cua nañi sii ñu ta cua nduvaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ta ñiyɨvɨ inga ñuu yatyi ñi Jerusalén i quisi ndyaca tucu ñu sii ñiyɨvɨ cuhu ta ñiyɨvɨ iyo tatyi cuihna añima, ta i nduvaha tandɨhɨ ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tacuan ta i cucuihna xaan iñi ra cu nuu sii ra cu zutu ta cuaha xaan ra saduceo sii ra apóstol. ");
INSERT INTO mihNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yucuan cuenda i tɨɨn ra sii ra, ta i tyihi ra sii ra vehe caa. ");
INSERT INTO mihNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Zoco sa cuaa cuan i quisi minoo ángel ra Ndyoo, ta i nuña ra yuvehe caa cuan ta i tava ra sii ra apóstol. Ta i catyi ra sihin ra: ");
INSERT INTO mihNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Cuahan ndo vehe ñuhu hebreo ta nacatyi ndo sihin ñiyɨvɨ yozo caa cuu nduvaha añima ñu. Catyi ángel cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","I tyaa ra apóstol yahvi sa cahan ra. Ta sa vasi cundisi i quɨhvɨ ra vehe ñuhu ta zacuaha ra sii ñiyɨvɨ. Tacuan ta i cana ra cu nuu sii ra cu zutu ta ra zutu nahnu sii tandɨhɨ ra mandoñi vatyi cua titahan ra. Ta i tasi ra tyiño ndya vehe caa vatyi cua tava ra sii ra apóstol vatyi cua quisi ra nu yucu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Zoco sa saa ra policía ndya vehe caa cuan, ta ñá nañihi ca ra sii ra apóstol ta cua nanuhu tucu ra ndya nu yucu ra cu tyiño, ta i catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","I sahan maa ndi vehe caa ta ndyehe ndi vatyi ndazi cutu yuvehe ta yucu tandɨhɨ ra zacuenda yuvehe. Zoco sa nuña ndi yuvehe cuan ta ñá nañihi ndi numinoo ñiyɨvɨ sisi si. ");
INSERT INTO mihNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ta sa siñi ra cu nuu sii policía sihin ra zutu nahnu ta ra cu nuu sii ra cuhva i nacatyi ra ta iyo xaan i cuñi ra ta sica iñi ra yozo ca caa cua cuu ra cuhva cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tacuan ta i quɨhvɨ minoo ra ta catyi ra: Ra i tyihi ndo si vehe caa cuan, vityi nandyaa ra sisi vehe ñuhu ta zacuaha ra sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tacuan ta cuahan ra cu nuu sihin policía ra, ta i tava ra sii ra apóstol. Vii ñi i tava ra sii ra coto cuxaan ñiyɨvɨ ta cañi ñu sii ra policía sihin yuu. ");
INSERT INTO mihNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","I sindyaca ra sii ra apóstol ndya nu yucu ra cu tyiño, ta i cahan ra cu nuu sii ra cu zutu sihin ra ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Sa saha maa ndi cuenda sii ndo vatyi i catyi ndi vatyi ma zacuaha ca ndo sa cuenda ra Jesús. Ta vityi ñihi ca zacuaha ndo. Nacahnu Jerusalén sito ñiyɨvɨ tuhun ya, ta tyaa ndo cuatyi sata maa ndi vatyi i sihi ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ta zɨquɨ i catyi ra Pedro ta inga ra apóstol: Ñiñi xaan ca sa tyaa ndi yahvi sii Ndyoo ta yɨvɨ sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","I tyaa xaan ñiyɨvɨ sahnu sii yo yahvi sii Ndyoo. Ta zuun ñi ra Ndyoo cuan i zanandoto ra sii ra Jesús. Ta maa ndo cuu ra i sahñi sii ra vatyi i tyaa ndo sii ra nu cruz. ");
INSERT INTO mihNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ta vityi zanducahnu xaan ca ra Ndyoo sii ra Jesús. Yucuan cuenda ndyaca ñaha ra tandɨhɨ, ta cuu cacu ñiyɨvɨ maa ñi sa cuenda maa ra ta zanduvaha ra añima yo, maa yo ñiyɨvɨ hebreo. Ta zandasi ra cuatyi yo. ");
INSERT INTO mihNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Zacuaha maa ndi tuhun ya vatyi sito ndi vatyi tuhun ndisa cuu si. Ta tacuan tucu zacuaha Tatyi Ii, ra saha ra Ndyoo sii ñiyɨvɨ tyaa yahvi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ta sa siñi ra cu tyiño sa catyi ra, ta i cuxaan xaan ra, ta i cuñi ra sa cahñi ra sii ra apóstol. ");
INSERT INTO mihNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Zoco minoo ra fariseo nañi ra Gamaliel ta i nduvita ra zava mahñu. Minoo maestro cuu ra cuenda ley ra Moisés, ta i tyaa xaan ñiyɨvɨ yahvi sii ra. I catyi ra vatyi natava ra cu tyiño sii ra apóstol. ");
INSERT INTO mihNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ta zɨquɨ i catyi ra sihin inga ra cu tyiño: Amigo, tandɨhɨ inga ndoho ra ndyizo tyiño, cuñi si zacuenda xaan yo ñaa sa zavaha yo sihin rayɨɨ ya. ");
INSERT INTO mihNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nacohon iñi ndo vatyi quɨvɨ cuan i sicoo minoo ra nañi Teudas. I sica iñi ra vatyi ñiñi xaan ra, ta cuaha xaan ra i cutahan sihin ra, tañi cumi ziendu ra. Zoco i sahñi ñiyɨvɨ sii ra Teudas ta i quɨtɨ cuatyi tandɨhɨ ra sindyico sii ra, ta i naa cuhva sa zacuu ra sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ta zɨquɨ zuun ñi quɨvɨ sa i cahvi ñiyɨvɨ sii ñiyɨvɨ ɨɨn ɨɨn vehe ñu ta i sicoo minoo ra nañi Judas, ra ñuu Galilea. I zatitahan ra sii cuaha xaan ñiyɨvɨ. Zoco zuun ñi i sihi tucu ra cuan, ta i quɨtɨ cuatyi ra sindyico sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ta vityi catyi sihin ndo vatyi nazaña yo sii rayɨɨ ya ta cuhva yo sa zavaha ra cuhva cuñi ra. Tatu zavaha ra cuhva cuñi ñiyɨvɨ ñi, cunaa tyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Zoco tatu zavaha ra cuhva cuñi ra Ndyoo, ma cuu zanaa yo sa zavaha ra. Nazaña yo sii ra coto cuxaan ra Ndyoo sihin yo. ");
INSERT INTO mihNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tacuan i catyi ra Gamaliel, ta i tyaa ra cu tyiño yahvi sa cahan ra. Tacuan ta i cana ra cu tyiño sii ra apóstol. I cañi ra sii ra, ta ñihi xaan i catyi ra sihin ra vatyi ma cahan ca ra tuhun ra Jesús, ta zɨquɨ i zaña ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","I quita ra apóstol nu yucu ra cu tyiño cuan. Zɨɨ xaan i cuñi ra vatyi saha ra Ndyoo sa ndyehe ra ticahan nuu sa cuenda ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ta tandɨhɨ quɨvɨ i zacuaha ra sii ñiyɨvɨ vehe ñiyɨvɨ ta vehe ñuhu hebreo. I zacuaha ra sii ñu vatyi sa i quisi ra Jesús ta i sihi ra sa cuenda cuatyi maa ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ta quɨvɨ cuan i nducuaha ca ñiyɨvɨ sino iñi sii ra Jesús. Tandɨhɨ ñu i cuu ñu ñu hebreo, zoco i cuu ñu ñiyɨvɨ cahan zahan griego ta ñiyɨvɨ cahan zahan hebreo. I quisaha cuxaan ñiyɨvɨ cahan griego ta catyi ñu vatyi ña ñihi ñundahvi ñu tahan ñu, ñu sihi yɨɨ, xuhun i zasa ra apóstol. ");
INSERT INTO mihNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tacuan ta i cana sa usi uu tahan ra apóstol sii tandɨhɨ ñiyɨvɨ sino iñi sii ra Jesús vatyi cua titahan ñu ta i catyi ra sihin ñu: Ña vaha sa zaña maa ndi tyiño sa zacuaha ndi sii ñiyɨvɨ Tuhun Ndyoo ta zasa ndi xuhun. ");
INSERT INTO mihNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yucuan cuenda, ndoho amigo, nducu ndo usa tahan ra tahan ndo. Ra iyo xaan Tatyi Ii ra Ndyoo añima ta ra iyo sa siñi tuñi vaha xiñi. Ta cua cuizo maa ra tyiño ya sa zasa ra xuhun. ");
INSERT INTO mihNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ta maa ndi, tandɨhɨ tyiemvu cua caca tahvi ndi sii ra Ndyoo ta cua zacuaha ndi sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tacuan, ta vaha nduu cuñi tandɨhɨ ñu sihin cuhva i cahan ra apóstol, ta i casi ñu sii ra Esteban vatyi vaha xaan sino iñi ra sii ra Jesús ta iyo xaan Tatyi Ii ra Ndyoo sihin ra. Ta i casi tucu ñu sii ra Felipe, ra Prócoro, ra Nicanor, ra Timón, ra Parmenas, ta ra Nicolás. Ra ñuu Antioquía cuu ra Nicolás. Ta quɨvɨ ta coto ca ra sii ra Jesús i tyaa xaan ra yahvi sii costumbre ñiyɨvɨ hebreo. Zoco yɨvɨ ra hebreo cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","I yaha sa usa tahan ra cuan ityi nuu ra apóstol, ta i sica tahvi ra sii ra Ndyoo, ta i tyizo ra ndaha ra sii ra vatyi cua cuizo tyiño ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","I nducahnu ca tyiño ra Ndyoo. I ndutuu xaan ñiyɨvɨ sino iñi sii ra Jesús ñuu Jerusalén ta sino iñi tucu cuaha ra cu zutu. ");
INSERT INTO mihNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","I tyindyee xaan ra Ndyoo sii ra Esteban ta i zavaha xaan ra sa ndyityi. Ta vaha xaan ñiyɨvɨ i cuu ra. Ta cuaha xaan sa ndyityi ta zeña i zavaha ra nu yucu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Zoco zuhva ra i cuxaan ra sihin ra. Minoo ityi ra nañi ra ra libre. Ñiyɨvɨ hebreo ñuu Cirene ta ñuu Alexandría cuu ra. Maa ra sihin inga ra hebreo nu cu si Cilicia ta nu cu si Asia i quisaha cahan ra sihin ra Esteban. ");
INSERT INTO mihNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Zoco i saha Tatyi Ii cuaha xaan sa siñi tuñi sii ra Esteban, ta tatu sa cahan ra Esteban ña ñihi ca inga ra cuhva cahan ra. ");
INSERT INTO mihNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yucuan cuenda i tyiyahvi inga ra cuan sii ra cua catyi: “Siñi ndi sa cahan ra Esteban ndya vaha ñi sii ra Moisés ta sii ra Ndyoo.” Ta tacuan i catyi inga ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ta yucuan cuenda i nduxaan ñiyɨvɨ. I cuxaan ra mandoñi ta ra maestro cuenda ley ra Moisés. I sahan ra nu ndyaa ra Esteban, ta i tɨɨn ra sii ra ta i sindyaca ra sii ra nu yucu ra cu tyiño. ");
INSERT INTO mihNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ta zɨquɨ i ñihi ra sii ra cu sa ndaa sii ra vatyi cua cahan ra cuendu zɨquɨ ra Esteban. I catyi ra cuan: Ihya rayɨɨ, cahan xaan ra ndya vaha ñi sii vehe ñuhu maa yo ta sii ley ra Moisés. ");
INSERT INTO mihNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sa siñi ndi vatyi catyi maa ra vatyi cua zanduva ra Jesús, ra ñuu Nazaret, vehe ñuhu ya ta cua zanaa ra costumbre i zacuaha ra Moisés. Tacuan i catyi ra cu sa ndaa cuan, ra cahan cuendu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","I ndyehe xaan tandɨhɨ ra cu tyiño sii ra Esteban ta i ndyehe ra vatyi ndisi xaan i nduu nuu ra tañi cuhva caa nuu ángel. ");
INSERT INTO mihNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ta i ndaca tuhun ra cu nuu sii zutu sii ra Esteban ta catyi ra: ¿Atu ndisa ra cuan sa cahan ra? ");
INSERT INTO mihNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tacuan ta i catyi ra Esteban sihin ra cu tyiño cuan: Amigos. Tyizoho ndo sa quehin. Ñiyɨvɨ sahnu sii yo i cuu maa ra Abraham. Ta tyiemvu i ndyehe ra sii ra Ndyoo ra cahnu. Ndyaa ra Abraham ñuu Mesopotamia quɨvɨ cuan, ta cuhun ca ra ñuu Harán ta i ndyehe ra sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","I cahan ra Ndyoo sihin ra Abraham ta catyi ra: “Quiton ñuun ta ñiyɨvɨ suun ta cua cuhun inga ñuu sa cua zañehi suun.” ");
INSERT INTO mihNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tacuan ta i quita ra Abraham ñuu Caldea ta cuahan ra cua cundyaa ra ñuu Harán. Ta sa sihi zutu ra Abraham ta i zaquisi ra Ndyoo sii ra Abraham ihya ñuu nu ndyaa ndo vityi. ");
INSERT INTO mihNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ñá saha ra Ndyoo ñuhu cuan nu zuhva si sii ra Abraham, zoco saha ra Ndyoo tuhun ra vatyi cua cuhva ra sii si sii ra, ta sii maa ra cua cuu si ta sii ñiyɨvɨ sii ra sa i sihi ra. Ta quɨvɨ cuan ta coo ca zehe ra Abraham. ");
INSERT INTO mihNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ihya cuu cuhva i cahan ra Ndyoo sihin ra: “Cua cundito ñiyɨvɨ suun inga ñuu nu iyo inga ñiyɨvɨ. Cumi ziendu cuiya cua zatyiño ñu tyiño ñiyɨvɨ ñuu cuan sihin tundoho vatyi cua cañi ñiyɨvɨ ñuu cuan sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Zoco cua tasi tuñi sii ñiyɨvɨ ñuu cuan, ta sa yaha cuhva cuan ta cua quita ñiyɨvɨ suun ñuu cuan, ta cua zacahnu ñu sii mi ihya.” ");
INSERT INTO mihNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tacuan i catyi ra Ndyoo, ta zɨquɨ i saha ra sii ra Abraham minoo costumbre sa cua tahndya ñɨɨ xiñi xuu lee. Tacuan ta cua coo minoo cuhva sii ñiyɨvɨ cuan ta cua nacohon iñi ñu vatyi saha ra Ndyoo tuhun ra sii ñu. Ta sa yaha cacu ra Isaac zehe ra Abraham ta i zavaha Abraham costumbre cuan sihin ra Isaac sa quita uña quɨvɨ ra. Ta tacuan tucu i zavaha ra Isaac sihin ra Jacob zehe ra, ta i zavaha tucu ra Jacob sii si sihin tandɨhɨ sa usi uu tahan zehe ra. Maa ra cuu ñiyɨvɨ sahnu sii yo. ");
INSERT INTO mihNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ta zuun ñi ra Esteban cuan cahan sihin ra cu tyiño cuan ta catyi ra: Ta minoo zehe ra Jacob, nañi ra José. Ta i cucuihna iñi tandɨhɨ yañi ra sii ra. Yucuan cuenda i xico ra sii ra sii ra inga ñuu. Cuahan ra ñuu Egipto, zoco ñá zandoo ra Ndyoo sii ra José. ");
INSERT INTO mihNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","I tyindyee xaan ra Ndyoo sii ra José vazu i ndyehe ra tundoho. Quɨvɨ i saa ra José nu ndyaa ra Faraón, ra cu rey ñuu Egipto, i saha ra Ndyoo sa siñi tuñi sii ra José ta i tahan iñi ra Faraón sii ra ta i saha ra Faraón tyiño sii ra José sa cuu ra gobernador sii tandɨhɨ ñuu cuan ta cuhva ndya vehe ra Faraón. ");
INSERT INTO mihNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tacuan ta i quisi minoo tama nacahnu nu cu si Egipto sihin nu cu si Caanán, ta i ndyehe xaan ñiyɨvɨ tundoho. Ñá ñihi ñiyɨvɨ sahnu sii yo sa casi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","I sito ra Jacob vatyi iyo trigo ñuu Egipto, ta i tasi ra sii zehe ra, zuun ñi ra cu ñiyɨvɨ sahnu sii yo. Yucuan cuu sa xihna ñi saha i sahan ra. ");
INSERT INTO mihNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ta sa cu uu saha i sahan ra, i zacoto ra José sii ra vatyi yañi ra cuu sii ra. Ta yucuan quɨvɨ i quisaha sito ra Faraón sii ñiyɨvɨ sii ra José. ");
INSERT INTO mihNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ta zɨquɨ i tasi ra José tyiño sii ra Jacob zutu ra vatyi quisi ra sihin tandɨhɨ ñiyɨvɨ sii ra. Ta sa tandɨhɨ ñiyɨvɨ sii ra, uñi xico sahun tahan ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ta cuahan ra Jacob ñuu Egipto. Ta yucuan i ndoo ra cuhva ndya i sihi ra, ta tacuan tucu tandɨhɨ zehe ra i sihi ra yucuan. Ñá sananuhu ca ra ñuu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ta i saa quɨvɨ sa sindyaca ñiyɨvɨ yɨquɨ ra Jacob ta yɨquɨ zehe ra ndya ñuu Siquem. Yucuan i quɨhvɨ ra ñuhu vatyi sa i nazata ra Abraham ñuhu cuan sii zehe ra Hamor. ");
INSERT INTO mihNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ta ñiyɨvɨ sii ra Abraham i nducuaha xaan ñu ñuu Egipto, ta sa cua saa quɨvɨ cua cuhva ra Ndyoo ñuhu sii ñu tañi sa i catyi ra sihin ra Abraham. ");
INSERT INTO mihNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ta i quisaha sindyaca ñaha inga rey ñuu Egipto cuan, rey ra ñá sito sii ra José. ");
INSERT INTO mihNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","I zandyehe xaan ra tundoho sii ñiyɨvɨ sahnu sii yo. Quiñi xaan cuu cuhva i zavaha ra sihin ñu vatyi i catyi ra vatyi tatu cua cacu zehe ñu cua zavita ñu sii si. Tacuan i catyi ra vatyi cuñi ra sa cuu si. ");
INSERT INTO mihNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ta zuun ñi tyiemvu cuan i cacu ra Moisés ta ndasa xaan ra nuu ra Ndyoo. I tyixehe zɨhɨ ra sii ra sisi vehe uñi yoo. ");
INSERT INTO mihNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ta minoo quɨvɨ ñá cuu ca tyixehe ña sii ra ta i tyihi ña sii ra sisi minoo tyica ta saqui ña sii ra sisi tuyoo caxtyila yuyuu. Ta yucuan nañihi zehe ra Faraón sii ra. I nduu zehe ra sii ña. Maa ña i zacuahnu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yucuan cuenda i cahvi ra Moisés tandɨhɨ cuhva i sito ñiyɨvɨ Egipto. I nducahnu xaan ra. Vaha xaan i cuu cahan ra ta cuaha sa vaha i zavaha ra. ");
INSERT INTO mihNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Zuun ñi ra Esteban cuan cahan sihin ra cu tyiño cuan ta catyi ra: Ta sa i ndusi ra Moisés uu xico cuiya ra ta i cuñi ra sa cua ndyehe ra sii ñiyɨvɨ sii ra, ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tacuan ta minoo quɨvɨ i ndyehe ra vatyi i cañi minoo ra Egipto sii minoo ra hebreo, ta cuahan ra Moisés cua tyindyee ra sii ra hebreo cuan, ta i sahñi ra sii ra Egipto. ");
INSERT INTO mihNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Sica iñi ra vatyi cua coto ñiyɨvɨ sii ra vatyi i tasi ra Ndyoo sii ra sa zacacu ra sii ñu sii ñiyɨvɨ Egipto. Zoco ñá cutuñi iñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ta inga quɨvɨ i ndyehe ra Moisés vatyi sahñi tahan uu tahan ra hebreo, ta i nducu ra Moisés cuhva sa coo vaha ra cuan ta ma cahñi tahan ca ra ta catyi ra: “Tyizoho ndo, amigo. Ña vaha cahñi tahan ndo.” ");
INSERT INTO mihNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Zoco minoo ra sahñi tahan cuan i quiñi ndaha ra sii ra Moisés ta catyi ra: “¿Yoo ra catyi suhun vatyi cundyaca ñohon sii ndi? ");
INSERT INTO mihNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Cuñun cahñun sii, tañi i sahñun sii ra Egipto icu.” ");
INSERT INTO mihNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ta sa siñi ra Moisés cuhva cuan, ta i sino ra ta cuahan ra ndya inga ñuu vatyi yuhu xaan ra. I quita ra Egipto ta cuahan ra ndya Madián. Yucuan i sicoo ñazɨhɨ ra, ta i cacu uu tahan zehe ra. ");
INSERT INTO mihNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","I yaha uu xico cuiya. Tacuan ta minoo quɨvɨ ñoho ra Moisés sisi cuhu, ta i ndyehe ra minoo taca iñu yatyi ñi yucu Sinaí. Cayu tu zoco ñá ndɨhɨ tu. Tacuan ta i quituu minoo ángel mahñu tu. ");
INSERT INTO mihNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Iyo xaan i cuñi ra Moisés sa ndyehe ra, ta i tuhva ra nu ndyaa taca iñu cuan vatyi cua ndyehe vaha ra. Ta i siñi ra vatyi cahan ra Ndyoo sihin ra ta catyi ra Ndyoo: ");
INSERT INTO mihNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yuhvi cui Ndyoo. I zacahnu ñiyɨvɨ sahnun sii. Ra Abraham, ra Isaac, ta ra Jacob i zacahnu tandɨhɨ ra sii.” Nɨhɨ tacuan ñi ca ra Moisés, ta i yuhu xaan ra sa ndyehe ca ra. ");
INSERT INTO mihNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ta zɨquɨ i catyi ra Ndyoo sihin ra: “Tavon ndison vatyi ihya nu nandyoon ñuhu ii cuu si vatyi ihya ndyei.” ");
INSERT INTO mihNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ta zɨquɨ catyi tucu ra Ndyoo: “Sa ndyehi ta site vatyi tahan xaan ñiyɨvɨ i casi tundoho nu iyo ñu ñuu Egipto cuan. Siñi sa cahan ñu ta site vatyi ña cundyee ca iñi ñu tundoho. Ta vityi noo xique vatyi cua zacaqui sii ñu. Ñaha. Coho yo ñuu Egipto.” I catyi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ta zuun ñi ra Moisés cuan cuu ra sa cahan ñiyɨvɨ sihin ta catyi ñu: “¿Yoo ra catyi suhun vatyi cuun juez sii ndi ta cundyaca ñohon sii ndi?” Catyi ñu. Ta vityi zuun ñi maa ra cuu ra i tasi ra Ndyoo vatyi cua zacacu ra sii ñiyɨvɨ cuan ta cua cundyaca ñaha ra sii ñu. Vatyi tacuan i catyi ángel sa cahan si sihin ra sisi taca iñu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","I tava ra Moisés sii ñiyɨvɨ ñuu Egipto. I zavaha ra cuaha xaan sa ndyityi ñuu Egipto ta Tyañuhu Cuaha. Ta i zavaha tucu ra sa ndyityi nu i sica noo ñiyɨvɨ cuan minoo nu yoñi ñiyɨvɨ iyo sisi sa uu xico cuiya. ");
INSERT INTO mihNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Zuun ñi maa ra Moisés cuan i catyi sihin ñiyɨvɨ hebreo: “Cua tasi ra Ndyoo sii minoo ra cua cahan Tuhun Ndyoo. Tañi i tasi ra sii mi, tacuan tucu cua quisi ra. Minoo ra hebreo cua cuu ra.” Catyi ra Moisés. ");
INSERT INTO mihNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ta maa ra Moisés cuan cuu ra i sica sihin ñiyɨvɨ sa sica noo ñu nu yoñi ñiyɨvɨ iyo. Sihin maa ra i cahan ángel cuan yucu Sinaí cuan. Yucuan i siyucu ra sihin ñiyɨvɨ sahnu sii yo, ta i ñihi ra Ley ra Ndyoo sa saha ra sii yo. ");
INSERT INTO mihNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Maa ra Esteban cuu ra cahan tandɨhɨ cuhva ya sihin ra cu tyiño ta catyi ra: Zoco ñá tyaa ñiyɨvɨ sahnu sii yo yahvi sii ra Moisés. Ñá cuñi ñu tyizoho ñu sa cahan ra. I cuñi ñu sa cunanuhu tucu ñu ndya ñuu Egipto. ");
INSERT INTO mihNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ta quɨvɨ sa ñoho ra Moisés xiñi yucu Sinaí i catyi ñu sihin ra Aarón: “Zavohon inga ndyoo sii ndi vatyi cua zañaha si sii ndi ityi. Ña sito ndi ndya ma cua naa ra Moisés, ra i tava sii ndi ñuu Egipto.” ");
INSERT INTO mihNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yucuan cuu nu i zavaha ñu minoo ndyoo. Tañi caa minoo zɨndɨquɨ luhlu caa si, ta i zacahnu ñu minoo vico cuenda si, ta sahñi ñu quɨtɨ vatyi cua zacahnu ñu vico ndyoo ñu. Ta i sica tahvi ñu sii si. Ta zɨɨ xaan i cuñi ñu sihin cuhva i zavaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yucuan cuenda i saha ra Ndyoo sa zavaha ñu cuhva cuñi maa ñu. Saha ra sa zacahnu ñu ñicandyi ta luna ta tiñoo. I zavaha ñu cuhva catyi minoo profeta ta tyiemvu. I catyi ra cuan vatyi catyi ra Ndyoo: Ndoho ñiyɨvɨ hebreo. Yɨvɨ sii mi i zacahnu ndo sa sica noo ndo sa uu xico cuiya cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","I cuñi ca ndo sii ndyoo sa yɨvɨ Ndyoo cuu sa ndisa. Nacahnu nu i sica noo ndo i sica noo tucu minoo vehe ñɨɨ sa cuenda ra Moloc. Ta inga ndyoo sindyizo ndo caa si cuhva caa tiñoo. Nañi si Renfán. Maa ndo i zavaha sii ndyoo cuan, ta maa ndo i zacahnu sii si. Ta yucuan cuenda cua tasi sii ndo sica xaan. Cua yaha ndo ñuu Babilonia. Tacuan i catyi ra Ndyoo sihin ñiyɨvɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ta i cahan ca ra Esteban sihin ñiyɨvɨ ta catyi ra: Ñiyɨvɨ sahnu sii yo, i sica noo minoo vehe ñɨɨ sihin ñu nu i sica noo ñu nu yoñi ñiyɨvɨ iyo. Ta sisi si i zacahnu ñu sii ra Ndyoo. I zañaha ra Ndyoo sii ra Moisés cuhva cua sino si, ta zuun cuhva i catyi ra Ndyoo, tacuan i sino si. ");
INSERT INTO mihNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ta quɨvɨ i sindyaca ñaha ra Josué i quisi ndyaca ñiyɨvɨ vehe cuan ihya ñuu Jerusalén, ta sahñi tahan ñu sihin ñiyɨvɨ ihya ta i tava ra Ndyoo sii ñu. Tacuan i ñihi ñiyɨvɨ sahnu sii yo ñuhu nu ndyaa yo vityi vatyi saha ra Ndyoo sa zahacanaa ñu. Ta sisi vehe ñɨɨ cuan i zacahnu ñu sii Ndyoo ndya ta quɨvɨ ra rey David. ");
INSERT INTO mihNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","I saha xaan ra Ndyoo ndatu sii ra David. Tacuan ta i sica ra David minoo tumañi iñi sii Ndyoo sa cua zandaa ra minoo vehe vaha sa cuenda Ndyoo. Zuun ñi Ndyoo ra i zacahnu ra Jacob ta tyiemvu cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ta ñá saha ra sa zandaa ra David vehe ra. Maa ra rey Salomón cuu ra i zandaa vehe ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Zoco ña ndyaa ra Ndyoo sisi vehe zavaha ñiyɨvɨ. I catyi minoo profeta: ");
INSERT INTO mihNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Catyi ra Ndyoo: Yuhvi ndyaca ñehi andɨvɨ ta ñuu ñiyɨvɨ. Ma cuu zavaha ndo minoo vehe vaha xaan ta cua cundyei sisi si vatyi ña cuñi si nu cua cundyei ta nu cua quitati. ");
INSERT INTO mihNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yuhvi cuu ra i zavaha tandɨhɨ. Catyi ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ta zɨquɨ i catyi tucu ra Esteban sihin ñiyɨvɨ cuan: Ñihi xaan iñi ndo. Inuu cuii ñi caa ndo tañi i cuu ñiyɨvɨ sahnu sii yo. Ña saha ndo sa cundyaca ñaha ra Ndyoo añima ndo. Ña tyisaha ndo sa ndisa. Sahñi tahan ndo sihin Tatyi Ii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","I cañi ñiyɨvɨ sahnu sii ndo sii tandɨhɨ cuii ra i cuu profeta. I sahñi ñu sii tandɨhɨ ra i nacatyi vatyi nu cua quisi quɨvɨ ta cua quisi minoo ra vaha xaan. Ta sa quisi ra vaha xaan cuan, ra Jesús cuu ra. Ta maa ndo i tyaa ndo cuatyi sata ra, ta i sahñi ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Maa ndo cuu ra ñihi ley Ndyoo i saha ángel sii ndo, ta ña tyaa ndo yahvi sii si. Catyi ra Esteban. ");
INSERT INTO mihNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","I siñi ra cu tyiño sa cahan ra Esteban, ta i cuxaan xaan ra sihin ra ndya cuhva sasi quihñi noho ra. ");
INSERT INTO mihNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Zoco i situ cuii Tatyi Ii sii ra Esteban. I nandyehe ndaa ra Esteban ityi zɨquɨ, ta i ndyehe ra sii ra Ndyoo cahnu, ta i ndyehe ra sii ra Jesús nandyaa ra ityi siyo cuaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ndyehe ndo, catyi ra. Ndyehi sa nuña gloria ta ndyehi sii ra i quisi ndya gloria. Nandyaa ra ityi siyo cuaha ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tacuan ta i tyazi ndaha ra cu tyiño cuan zoho ra. I cana saa xaan ra vatyi cuxaan ra. Yatyi cuii ñi i tuhva ra nu iñi ndyaa ra Esteban vatyi cuñi ra queen ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","I tava ra sii ra Esteban ndya yu ñuu vatyi cua cañi ra sii ra sihin yuu ta cua cahñi ra sii ra. I zandoo ra cu tyiño cuan zahma cahnu ndisi ra sihin minoo ra yoco nañi Saulo vatyi cua cucumi ra sii si. ");
INSERT INTO mihNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ta i cañi ra sii ra Esteban sihin yuu, ta maa ra Esteban i sica tahvi xaan ra sii ra Ndyoo ta catyi ra: Jesús yoho ndyaca ñohon sii. Nacuhun añime suhun. ");
INSERT INTO mihNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ta yucuan i sicuɨñɨ sɨtɨ ra Esteban, ta i cana saa ra: Jesús, ma tyoon cuatyi ndyicuu ra ya zɨquɨ ra. Tacuan i cahan ra Esteban ta i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Tahan xaan iñi ra Saulo sa i sahñi ñiyɨvɨ sii ra Esteban. Tacuan ta i quisi zuhva ra ndyico sii ra Jesús, ta i tyihi ra sii ra Esteban si ñuhu. Sacu ra vatyi i sihi ra Esteban. Ta zuun ñi quɨvɨ cuan i sahñi tahan ñiyɨvɨ ña sino iñi sihin ñiyɨvɨ sino iñi sii ra Jesús ñuu Jerusalén cuan. Ta i sino ñiyɨvɨ sino iñi. Zuhva ñu i sino ndya nu cu si Judea, ta inga ñu i sino ñu ndya Samaria. Zoco sa usi uu tahan ra apóstol ñá sino ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ta ra Saulo cuan i zayanga xaan ra sii ñiyɨvɨ ndyico sii ra Jesús. Cuaha xaan nu i quɨhvɨ ra vehe ñiyɨvɨ ta cañoho ra sii rayɨɨ a sii ñu zɨhɨ, ta tyihi ra sii ñu vehe caa. ");
INSERT INTO mihNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ta sa i quita ñiyɨvɨ ñuu Jerusalén cuan sa i sino ñu ta i zacoto ñu sii ñiyɨvɨ tandɨhɨ ñuu nu i yaha ñu Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ta minoo ra sa nañi Felipe i saa ra nu cu si Samaria, ta i quisaha ra nacatyi ra sihin ñiyɨvɨ tuhun ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","I titahan ñiyɨvɨ, ta vaha xaan i tyizoho tandɨhɨ ñu sa cahan ra Felipe, ta i ndyehe ñu sa ndyityi i zavaha ra. ");
INSERT INTO mihNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Vatyi i tava ra cuaha xaan tatyi cuihna sii ñiyɨvɨ. I cana saa xaan tatyi cuihna sa quita si sii ñiyɨvɨ, ta zɨquɨ i nduvaha ñu. Cuaha xaan ra xii i nduvaha ta ra coxo. ");
INSERT INTO mihNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yucuan cuenda i tahan xaan iñi tandɨhɨ ñiyɨvɨ ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Zoco minoo ra sinañi Simón, i cuu ra ra tazi ñuu cuan, ta i zandavi ñaha ra sii cuaha xaan ñiyɨvɨ ityi Samaria vatyi catyi ra vatyi ra ñiñi xaan cuu ra. Iyo xaan i cuñi tandɨhɨ ñiyɨvɨ sa cuenda maa ra quɨvɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ta tandɨhɨ ñiyɨvɨ cuca cuhva ndya ñiyɨvɨ ndahvi i tyizoho ñu sa cahan ra ta catyi ñu: Cahnu xaan cuu cuhva ra ya vatyi maa ra Ndyoo cuu ra saha cuhva cuan sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ta i tyizoho ñu sa cahan ra vatyi sa naha xaan i zandavi ñaha ra sii ñu sihin cuhva i zavaha ra. ");
INSERT INTO mihNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tacuan ta i saa ra Felipe, ta i zacuaha ra sii ñiyɨvɨ cuhva ndyaca ñaha ra Ndyoo ta cuhva cahnu xaan iyo cuhva sii ra Jesucristo. Tacuan ta i sino iñi ñu sa cahan ra Felipe. Ta i sicoo ndutya cuaha rayɨɨ ta ñu zɨhɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ta i sino tucu iñi ra Simón, ra tazi cuan, ta i sicoo ndutya ra ta ndutahan ra sihin ra Felipe. Iyo xaan i cuñi ra sihin sa ndyityi nahnu i zavaha ra Felipe. ");
INSERT INTO mihNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ta ra apóstol i ndoo ra ñuu Jerusalén ta sa siñi ra vatyi sino iñi ñiyɨvɨ ñuu Samaria sii ra Jesús ta zɨquɨ i tasi ra sii ra Pedro ta ra Juan ndya indyacuan. ");
INSERT INTO mihNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","I saa ra Pedro ta ra Juan ta i sica tahvi ra sii Ndyoo sa natasi ra Tatyi Ii ra añima ñiyɨvɨ sino iñi sii ra Jesús indyacuan. ");
INSERT INTO mihNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Vatyi i sicoo ndutya ñiyɨvɨ cuan maa ñi sa cuenda ra Jesús ta tañaha ca noo xica Tatyi Ii sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tacuan ta i tyizo ra Pedro ta ra Juan ndaha ra sii ñu ta i quɨhvɨ Tatyi Ii añima ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","I ndyehe ra Simón cuhva i tyizo ra apóstol ndaha ra sii ñiyɨvɨ cuan ta i quisi Tatyi Ii sii ñu ta i catyi ra Simón: ");
INSERT INTO mihNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Cua tyiyahvi sii ndo tatu cuhva ndo cuhva cuan sii, vatyi yoo ra cua tyize ndehi ta cua quɨhvɨ Tatyi Ii añima ra. ");
INSERT INTO mihNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tacuan i catyi ra. Ta catyi ra Pedro sihin ra: Nacunaa moo sihin xuhun vatyi sica iñun vatyi cuu zaton sa saha maa ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ma cuu zatyiño moo tyiño ya vatyi ña vaha añimon sihin ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Zañon cuhva sa quiñi xaan sica iñun ta caca tahvun sii Ndyoo sa cua zandasi ra cuatyun. ");
INSERT INTO mihNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Vatyi site yozo caa iyon. Vatyi cucuihna xaan iñun. Tañaha ca zandoon cuatyi zacuun. Ta cua zatɨvɨ si suun. ");
INSERT INTO mihNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tacuan i catyi ra Pedro, ta i catyi ra Simón sihin ra: Caca tahvi ndo sii ra Ndyoo sa cuenda mi vatyi ma tahan si sii cuhva sa catyi ndo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tacuan i cuu. Ta sa yaha zacuaha ra Pedro ta ra Juan Tuhun Ndyoo, ta i saha ra cuenda yozo caa zavaha ra Ndyoo, ta nacatyi ra sihin ñiyɨvɨ yozo caa cuu cacu ñu ta ma cuhun ñu andyaya. Nacahnu Samaria i sahan ra, ta zɨquɨ i sinanuhu ra ndya ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ta sa yaha cuhva cuan ta zɨquɨ i cahan minoo ángel ra Ndyoo sihin ra Felipe ta catyi si: Nduviton ta cuahan ityi tyañuhu ityi quita ñuu Jerusalén ya ta cuhun ndya nu cu si Gaza. Ityi cuan cuu nu yoñi maa ñiyɨvɨ iyo. ");
INSERT INTO mihNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","I nduvita ra Felipe ta cuahan ra. Ta ityi cuahan ra i ñihi tahan ra sihin minoo ra ñuu Etiopía. Ra yucuan, ica iyo ra. Ta ndyizo ra minoo tyiño cahnu sa sicumi ra tandɨhɨ xuhun ña Candace, ñaha ndyaca ñaha sii ñiyɨvɨ ñuu Etiopía cuan. Sahan ra cuan ñuu Jerusalén vatyi tuhva maa ra zacahnu sii ra Ndyoo tañi zavaha ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ñoho ra cuan sisi carreta ra sa cua nuhu ra. Ta cahvi ra tuhun i tyaa ra Isaías, minoo profeta ta tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tacuan ta i catyi Tatyi Ii sihin ra Felipe: Cuahan cua zatohon sii ra vasi sihin carreta cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ta sa tuhva ra Felipe nu vasi ra ta i siñi ra sa cahvi ra nuu libro ra Isaías, ta i ndaca tuhun ra Felipe sii ra ta catyi ra: ¿Atu cutuñi iñun sa cahvun? ");
INSERT INTO mihNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ta i catyi ra cuan sihin ra: Ña cutuñi iñi vatyi yoñi ra cuu nacatyi sihin ñaa cuñi si catyi si. Ta i cahan ra sihin ra Felipe sa ndaa ra ta cundyaa ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ihya cuu tuhun i cahvi ra cuan: Quihin ñiyɨvɨ sii mvee ticatyi ta yoco ñu ixi tɨ ta ñahñi sa cahan tɨ. Ta quihin ñu sii tɨ, ta cua cahñi ñu sii tɨ ta ñahñi sa cahan tɨ. Ta tacuan tucu maa ra, cua ndyehe ra tundoho ta ñahñi cua catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Cua vacu ndyaa xaan ñu sii ra ta ña ndoo cua zandaa ñu tyiño cuenda ra. Cua caca iñi ñiyɨvɨ zavaha ndya vaha ñi sihin ra vatyi yoñi zehe ra cua coo vatyi sahñi ñu sii ra. Yucuan cuu tuhun cahvi ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tacuan ta i catyi ra Etiopía sihin ra Felipe: Nacatyun sihin sa ndyoo ñi. ¿Yoo sii cuenda cahan ra Isaías? ¿Atu zuun ñi tuhun maa ra cahan ra? a ¿atu cahan ra sii inga ra? ");
INSERT INTO mihNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yucuan ta zuun ñi sihin tuhun cuan i quisaha ra Felipe nacatyi ra, ta i sityiño tucu ra inga Tuhun Ndyoo, nu cahan si sa cuenda ra Jesús. Ta i zacuaha ra sii ra vatyi ra Jesús cuu ra cua zacacu sii ñiyɨvɨ. Ra sa ndatu xaan ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ta sa cua yaha ra nu iyo ndutya ta i catyi ra Etiopía: Ndyehe, ihya iyo ndutya. ¿Atu cuu coo ndutye? ");
INSERT INTO mihNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ta catyi ra Felipe sihin ra: Cuu tatu sino iñun sii ra Jesús sihin tandɨhɨ cuii añimon. Ta i catyi ra cuan: Sino iñi vatyi ra Jesús, zehe ra Ndyoo Zutu yo cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tacuan ta i catyi ra Etiopía vatyi nanacuɨñɨ carreta, ta i noo nduu tahan ra. Ta i sicoo ndutya ra i zacuu ra Felipe sisi ndutya cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ta sa cua quita ra sisi ndutya, ta i quihin Tatyi Ii sii ra Felipe. Ñá ndyehe ca ra Etiopía cuan sii ra Felipe, ta zɨɨ xaan i cuñi ra Etiopía sa ñihi ra cuhva cuenda ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ta i sindyaca Tatyi Ii sii ra Felipe ndya ñuu Azoto. Yucuan sahan ra minoo minoo ñuu sa zacuaha ra sii ñiyɨvɨ sa cuenda ra Jesús ta cuhva cua cacu ñiyɨvɨ ta ma cuhun ñu andyaya. Ta cuhva cuan cuahan ra ndya cuhva ndya i saa ra Cesarea. ");
INSERT INTO mihNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ta ra Saulo tañaha ca cua zaña ra cuhva sa sahñi tahan ra sihin ñiyɨvɨ ndyico sii ra Jesús, ta ñá zaña ra sa nducu cahñi ra sii ñu. Ta yucuan cuenda sahan ra nu ndyaa ra cu nuu sii ra cu zutu. ");
INSERT INTO mihNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ta i sica ra Saulo sa tyaa ra cu nuu carta sa cuhun sihin ra ñuu Damasco ndya vehe ñuhu hebreo. Ta tacuan cua ñihi ra Saulo cuhva vatyi tatu nañihi ra sii ñiyɨvɨ ndyico sii ra Jesús ta cua cuu tɨɨn ra sii ñu cundyaca ra sii ñu vehe caa ñuu Jerusalén, tandɨhɨ ñu, ñu zɨhɨ ta rayɨɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ta i quihin ra Saulo ityi cuahan ra. Ta sa cua saa ra ñuu Damasco ta zuun ñi caa cuhva cuan i ndyehe ra minoo ñúhu cahnu xaan. I zandisi si nacahnu nu cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ta i nduva ra nu ñuhu ta i siñi ra nduzu ra Jesús sa cahan ra sihin ra ityi zɨquɨ ta catyi ra sihin ra: Saulo, Saulo. Sahñi tohon sihin mi. ");
INSERT INTO mihNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ta i catyi ra Saulo: ¿Yoo sa cahan, tata? Ta i catyi ra Jesús sihin ra: Yuhvi cui Jesús. Sahñi tohon sihin mi, zoco zuun ñi sii moo zañicuehun. ");
INSERT INTO mihNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tacuan ta i yuhu xaan ra Saulo ta catyi ra: ¿Ñaa sa cuñun zavehi? Ta i catyi ra Jesús sihin ra: Nduviton ta cuhun ndya ñuu ya, ta cua nacatyi ñiyɨvɨ suhun ñaa sa cua zavohon. ");
INSERT INTO mihNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ta ra ndɨhɨ sihin ra Saulo iyo xaan i cuñi ra ndya cuhva ñá cuu ca cahan ra vatyi i siñi ra nduzu sa cahan, zoco yoñi ñiyɨvɨ i ndyehe ra. ");
INSERT INTO mihNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","I nduvita ra Saulo, ta i nuña ra nuu ra, zoco ñá cuu ca ndyehe ra. Yucuan cuenda i tɨɨn amigo ra ndaha ra, ta i sindyaca ra sii ra ndya ñuu Damasco cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yaha uñi quɨvɨ sa ñá cuu ndyehe ra Saulo. Ñá sasi maa ra, ta nu ñá sihi ra ndutya. ");
INSERT INTO mihNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ta zuun ñi ñuu Damasco cuan iyo minoo ra nañi Ananías. I sindyico ra sii ra Jesús. Minoo saha i cahan ra Ndyoo sihin ra sisi ñimahna ta catyi ra: ¡Yoho Ananías! Ta i catyi ra Ananías: ¿Ñaa sa cuñun sihin, tata? ");
INSERT INTO mihNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ta i catyi ra Ndyoo Zutu yo sihin ra: Nduvita ta cuhun calle sa nañi ɨɨn ndoo ndita ñi. Ta sisi vehe ra Judas cua nanducun sii minoo ra ñuu Tarso. Nañi ra Saulo ta sica tahvi ra sii mi vityi. ");
INSERT INTO mihNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sa tahan tucu maa ra Saulo ñimahna ta sisi ñimahna i ndyehe ra vatyi vasun. I ndyehe ra vatyi quɨhvun ta tyizon ndohon sii ra vatyi cua nandyehe tucu ra. Tacuan i catyi ra Ndyoo sihin ra Ananías. ");
INSERT INTO mihNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ta sa siñi ra Ananías cuhva cuan ta i catyi ra: Ndyoo Zuti, sa cuaha xaan ñiyɨvɨ i nacatyi ñu sihin mi vatyi cuaha xaan sa ña vaha i zavaha ra cuan sihin ñiyɨvɨ sino iñi suun ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ta vityi vasi ra ihya ta iyo cuhva sii ra sihin ra cu nuu sii zutu nahnu vatyi cua tɨɨn ra sii tandɨhɨ ñiyɨvɨ sica tahvi suun ta tyihi ra sii ndi vehe caa. ");
INSERT INTO mihNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Zoco i catyi ra Ndyoo sihin ra Ananías: Cuahan vatyi i casi mi sii ra Saulo cuan vatyi cua cahan ra sa cuenda mi sihin ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu, ta sihin rey ñiyɨvɨ cuan ta cua zacuaha ra sii ñiyɨvɨ hebreo, ñiyɨvɨ sii ndo, ndɨhɨ ca. ");
INSERT INTO mihNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ta cua zañehi sii ra cuhva cua tahan ra tundoho sa cuenda mi. ");
INSERT INTO mihNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tacuan ta zɨquɨ cuahan ra Ananías ndya vehe nu iyo ra Saulo. I quɨhvɨ ra ta i tyizo ra ndaha ra sii ra ta i catyi ra: Amigo Saulo, ra Jesús cuu ra ndyaca ñaha sii yo. Ta i quituu ra nuu moo ityi vasun. Ta vityi i tasi ra sii mi ihya vatyi cua nandyehun inga saha ta cua quɨhvɨ Tatyi Ii añimon. ");
INSERT INTO mihNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ta zuun ñi caa cuhva cuan i quita minoo sa quita tañi caa zoo tyiyaca sɨtɨ nuu ra Saulo. Ta zɨquɨ i cuu nandyehe ra. Tacuan ta cuahan ra Saulo ta i sicoo ndutya ra (vatyi cua cundyico ra sii ra Jesús). ");
INSERT INTO mihNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ta zɨquɨ i sasi ra xita, ta i nacoo tundyee iñi sii ra. Ta i ndoo ra zuhva quɨvɨ sihin ñiyɨvɨ sino iñi sii ra Jesús ñuu Damasco. ");
INSERT INTO mihNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tacuan i cuu ta zɨquɨ i quisaha ra Saulo zacuaha ra sii ñiyɨvɨ tandɨhɨ vehe ñuhu hebreo ñuu Damasco. I nacatyi ra sihin ñu vatyi ra Jesús, zehe Ndyoo cuu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ta sa siñi ñiyɨvɨ sa cahan ra, ta iyo xaan i cuñi tandɨhɨ ñu. Ta i quisaha catyi ñu sihin tahan ñu: Zuun ñi ra ihya cuu ra sahñi tahan xaan sihin ñiyɨvɨ sino iñi sii ra Jesús ñuu Jerusalén. Ta i saa ra ihya vatyi cua tɨɨn ra sii ñiyɨvɨ sino iñi sii ra Jesús ñuu ya ta cundyaca ra sii ñu ndya nu ndyaa ra cu nuu sii zutu nahnu. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Zoco ñá zaña ra Saulo sa zacuaha ra sii ñiyɨvɨ. I zacuaha ra sii ñu vatyi ra Jesús cuu ra cu Cristo sa ndisa. Ta ñá ñihi ca ñiyɨvɨ hebreo ñuu Damasco cuhva cahan ñu inga cuhva. ");
INSERT INTO mihNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Naha zuhva ta zɨquɨ i zacasi tahan ra hebreo, ra ña sino iñi Tuhun Ndyoo, tyiño sa cua cahñi ra sii ra Saulo. ");
INSERT INTO mihNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Zoco i sito ra Saulo cuhva sa sica iñi ra cuan. Ta ñuu cuan sicoo minoo nuzama siconduu. Ñiyaca ta ndyiyaca i sicumi xaan ra hebreo cuan tandɨhɨ yuvehe si vatyi cua tɨɨn ra sii ra Saulo tatu cua yaha ra ta cua cahñi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Zoco i zacacu amigo ra Saulo sii ra minoo sa cuaa vatyi i zanoo ra sii ra nuzama cuan sisi minoo tyica cahnu, ta i sino ra Saulo. ");
INSERT INTO mihNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Cuahan ra Saulo ñuu Jerusalén. I cuñi ra sa cua ndutahan ra sihin ñiyɨvɨ sino iñi sii ra Jesús yucuan, zoco yuhu xaan ñu sii ra. Ñá sino iñi ñu sa cua cundyico ra sii ra Jesús sa ndisa cuii. ");
INSERT INTO mihNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tacuan ta i quihin ra Bernabé sii ra Saulo ta sindyaca ra sii ra ndya nu ndyaa ra apóstol ta catyi ra sihin ra: Ica ra Saulo ya i ndyehe ra sii ra Jesús ityi, ta i cahan ra Jesús sihin ra. Ta zɨquɨ vaha xaan i zacuaha ra Saulo sii ñiyɨvɨ ñuu Damasco sa cuenda ra Jesús ta ñá yuhu ra. Catyi ra Bernabé. ");
INSERT INTO mihNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tacuan ta i ndoo ra Saulo sihin ñiyɨvɨ sino iñi sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ta nacahnu ñuu Jerusalén i zacuaha ra sii ñiyɨvɨ tuhun ra Jesús. Ta i natuhun xaan ra Saulo sihin ñiyɨvɨ hebreo, ra cahan zahan griego. Ta i cuñi ra cuan sa cahñi ra sii ra Saulo (vatyi ñá sino iñi ra sa cahan ra). ");
INSERT INTO mihNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ta sa sito ra sino iñi sii ra Jesús cuhva cuan ta i sindyaca ra sii ra Saulo ndya ñuu Cesarea. Ta yucuan i tyihi ra sii ra Saulo sisi minoo barco ta natasi ra sii ra ityi ñuu ra, ñuu Tarso. ");
INSERT INTO mihNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tacuan ta i ndutaxi nu yucu ñiyɨvɨ sino iñi sii ra Jesús nacahnu nu cu si Judea ta Galilea ta Samaria. Ta ñá cuxaan inga ñiyɨvɨ sihin ñu. Ta cuaha xaan ca ñiyɨvɨ i quisaha sino iñi ñu Tuhun Ndyoo, ta i tyindyee xaan Tatyi Ii sii tandɨhɨ ñu. Ta i yuhu ñu sa ma tyaa ñu yahvi sii Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Cuahan ra Pedro nacahnu ñuu nu iyo ñiyɨvɨ sino iñi sii ra Jesús. Ta i saa ra ñuu Lida. ");
INSERT INTO mihNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yucuan i ndyehe ra sii minoo ra xii. Nañi ra Eneas. Sa uña cuiya caa ra vatyi ñá cuu caca ra. ");
INSERT INTO mihNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tacuan ta i catyi ra Pedro sihin ra: Eneas, zanduvaha ra Jesucristo suun. Nduviton ta natuun yuun. Tacuan ta i nduvita ra Eneas vatyi sa i nduvaha ra. ");
INSERT INTO mihNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tandɨhɨ ñiyɨvɨ ñuu Lida cuan sihin ñu ñuu Sarón i ndyehe ñu sa nduvaha ra Eneas. Ta i sino iñi ñu sii ra Jesús. Ta i zandoo ñu costumbre sahnu sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ta ñuu Jope cuan sicoo minoo ñaha nañi ña Tabita. Ta sihin zahan griego nañi ña Dorcas. Sino iñi ña sii ra Jesús, ta tandɨhɨ quɨvɨ i zavaha ña sa vaha, ta i tyindyee ña sii ñiyɨvɨ ndahvi. ");
INSERT INTO mihNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ta quɨvɨ cuan i quihin cuehe sii ña Dorcas, ta i sihi ña, ta i zacutyi ñiyɨvɨ sii coño ñuhu ña, ta i saqui ñu sii ña si vehe ña, sa cu uu vehe toto ndya zɨquɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ta sa ñihi ñiyɨvɨ tuhun vatyi ndyaa ra Pedro inga ñuu nañi Lida yatyi ñi ñuu Jope cuan. Ta i tasi ñu sino iñi sii uu tahan ra cua zañiñi ra sii ra sa quisi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Tacuan, ta cuahan ra Pedro sihin ra cuan. Ta sa saa ra yucuan ta i sindyaca ñu sii ra ndya nu caa ndɨyɨ sisi vehe toto cuan ndya zɨquɨ. Yucu tandɨhɨ ñu ndahvi, ñu sihi yɨɨ, sisi vehe cuan. Sacu xaan ñu. Zañaha ñu tandɨhɨ vestido, tandɨhɨ coto i zavaha ña Dorcas ta ndito ña. ");
INSERT INTO mihNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tacuan ta i tava ra Pedro sii tandɨhɨ ñu, ta i sicuɨñɨ sɨtɨ ra, ta i sica tahvi ra sii Ndyoo. Ta zɨquɨ i catyi ra sihin ñaha cuan: Nduviton maha Tabita. Tacuan ta nandyehe ña. I ndyehe ña sii ra Pedro ta nacundyaa ña. ");
INSERT INTO mihNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","I tɨɨn ra Pedro ndaha ña ta i zanacuɨñɨ ndyaa ra sii ña. Tacuan ta i cana ra sii ñu sino iñi ta sii ñu ndahvi, ñu sihi yɨɨ cuan, vatyi sa nandoto ña. ");
INSERT INTO mihNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ta i sito tandɨhɨ ñiyɨvɨ ñuu Jope. Ta cuaha xaan ñu i sino iñi sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ta i ndoo ra Pedro zuhva ca quɨvɨ ñuu cuan vehe ra nañi Simón. Ta ra Simón zatyahyu ra ñɨɨ vatyi yucuan cuu tyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ñuu Cesarea i sicoo minoo ra nañi Cornelio. Ra cu nuu i cuu ra sii minoo ziendu zandaru. Ra Italia i cuu zandaru sa ndyaca ñaha ra. ");
INSERT INTO mihNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Vaha xaan ra i cuu ra Cornelio sihin tandɨhɨ ñiyɨvɨ sii ra. I zacahnu ra sii Ndyoo, ta yuhu ra sa ma tyaa ra yahvi sii ra. I tyindyee xaan ra sii ñiyɨvɨ hebreo sihin xuhun ra. Ta i cahan ra sihin ra Ndyoo tandɨhɨ cuhva. ");
INSERT INTO mihNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Minoo saha tañi caa uñi sa sahiñi i ndyehe ra minoo ángel. I quɨhvɨ si nu ndyaa ra ta catyi si: ¡Cornelio! ");
INSERT INTO mihNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Yuhu xaan ra Cornelio ta i ndyehe xaan ra sii ángel cuan ta catyi ra: ¿Ñaa sa cuñun sihin, tata? Tacuan ta i catyi ángel cuan sihin ra: Sa siñi ra Ndyoo tandɨhɨ cuhva i cohon sihin ra. Ta zɨɨ cuñi ra vatyi tyindyee xoon sii ñiyɨvɨ ndahvi. ");
INSERT INTO mihNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ta vityi cuñi si sa tasun uu a uñi tahan muzun ndya ñuu Jope. Indyacuan iyo minoo ra nañi Simón. Ta zuun ñi nañi tucu ra Pedro. Cua canon sii ra vatyi quisi ra ihya. ");
INSERT INTO mihNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ndyaa ra vehe inga ra nañi Simón. Ra zatyahyu ñɨɨ cuu ra. Yuhu tyañuhu iyo vehe ra. Cua catyi maa ra Pedro cuan ñaa sa cua zavohon. Tacuan i catyi ángel cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ta sa cuahan ángel cuan ta i cana ra Cornelio sii uu tahan muzu ra sihin minoo zandaru ra cumi sii ra. Sino iñi zandaru cuan sii Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","I nacatyi ra Cornelio sihin ra tandɨhɨ sa ndyehe ra ta zɨquɨ i tasi ra sii ra ndya ñuu Jope. ");
INSERT INTO mihNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ta inga quɨvɨ i quihin ra ityi cuahan ra. Ta sa cua saa ra ñuu Jope tañi maa ora ta zuun ñi caa cuhva cuan i ndaa ra Pedro xiñi vehe ra vatyi cua cahan ra sihin Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Sizoco ra ta cuñi ra sa cuzama ra zoco nɨɨ ñi sa zavaha ñu sa casi ra i ndaa ra xiñi vehe. Tacuan ta i quisaha zandyehe ra Ndyoo sii ra minoo sa ndyehe ra. ");
INSERT INTO mihNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","I ndyehe ra vatyi nuña yutyi andɨvɨ ta i noo xica minoo tañi minoo zahma yuu cahnu. I noo si sihin cumi tahan sɨquɨ si. ");
INSERT INTO mihNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Sisi zahma yuu cuan ñoho tandɨhɨ cuii nuu quɨtɨ sa iyo cumi tahan saha sihin coo nahnu ta sihin zaa. ");
INSERT INTO mihNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tacuan ta i siñi ra Pedro sa cahan ra Ndyoo ta catyi ra: Nduviton Pedro ta cahñun sii tɨ ta casun. ");
INSERT INTO mihNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Zoco i catyi ra Pedro: Ma cuu tata vatyi ña tuhve casi tandɨhɨ ñaa sa ica cuenda costumbre maa ndi. ");
INSERT INTO mihNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Inga saha i catyi tucu ra Ndyoo sihin ra: Ña vaha catyi moo vatyi ica sa sehi suun. ");
INSERT INTO mihNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ta tacuan i cahan tucu ra Ndyoo sihin ra. Ta sa cu uñi saha i cahan ra tacuan ta zɨquɨ i nandaa tucu zahma cuan ityi zɨquɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ta i sica iñi ra Pedro ñaa cuhva cuu si cuan, ta zuun ñi caa cuhva cuan i saa sa uñi tahan ra i tasi ra Cornelio yuvehe. Vatyi i ndaca tuhun ra sii ñiyɨvɨ ta tacuan i nañihi ra vehe ra Simón. ");
INSERT INTO mihNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ta sa saa ra yuvehe cuan, i cana saa ra ta catyi ra: ¿Atu iyo minoo ra nañi Simón Pedro ihya? ");
INSERT INTO mihNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ta zuun ñi cuhva cuan, sica iñi ra Pedro ñaa sa ndyehe ra ta i catyi Tatyi Ii sihin ra: Nanducu uñi tahan ra suun. ");
INSERT INTO mihNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Cua noon ta cua cuhun sihin ra. Ma caca iñun vazu yɨvɨ ñiyɨvɨ hebreo cuu ra vatyi yuhvi cuu ra i tasi sii ra nu ndyoon. ");
INSERT INTO mihNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tacuan ta i noo ra Pedro nu yucu ra i tasi ra Cornelio ta catyi ra: Zuun yuhvi cui ra nanducu ndo. ¿Ñaa cuenda vasi ndo? ");
INSERT INTO mihNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ta i catyi inga ra cuan: Vasi maa ndi cuenda ra Cornelio. Minoo ra vaha xaan cuu ra. Ta cuñi xaan ra sii Ndyoo ra zacahnu ndoho ñiyɨvɨ hebreo. Sa catyi minoo ángel Ndyoo sihin ra vatyi vaha cua cana ra suun sa cuhun ndya vehe ra. Ta cua tyizoho ra ñaa sa cua nacatyun sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tacuan ta i quɨhvɨ ra cuan sisi vehe. Ta i ndoo ra sihin ra Pedro minoo ñuu. Ta inga quɨvɨ cuahan ra Pedro sihin ra ta cuahan tucu zuhva ra sino iñi sii ra Jesús, ra ñuu Jope cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ta sa cu uu quɨvɨ i saa ra ñuu Cesarea nu i ndatu ra Cornelio sii ra sihin cuaha xaan ñiyɨvɨ sii ra sihin amigo ra vatyi i cana ra Cornelio sii tandɨhɨ ra. ");
INSERT INTO mihNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ta sa saa ra Pedro vehe ra ta i quita ra Cornelio si vehe ra ta i sicuɨñɨ sɨtɨ ra nuu ra vatyi cua zacahnu ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Zoco i zanduvita ra Pedro sii ra ta catyi ra: Nduviton vatyi ñiyɨvɨ cuu mi tañi moo. ");
INSERT INTO mihNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ta zɨquɨ i quisaha natuhun ra ta i quɨhvɨ ra sisi vehe ra Cornelio. I ndyehe ra Pedro vatyi tuu xaan ñiyɨvɨ yucu. ");
INSERT INTO mihNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ta i catyi ra Pedro: Sito maa ndo vatyi ña saha costumbre maa ndi ñiyɨvɨ hebreo sa titahan ndi sihin ra sa yɨvɨ ñiyɨvɨ hebreo cuu, nu sa quɨhvɨ ndi vehe ra. Zoco i zañaha ra Ndyoo sii vatyi ña vaha cua catyi vatyi cuxi caa iyo ndo ta ña vaha cua catyi vatyi ma cuu titehin sihin ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yucuan cuenda yatyi xaan vasi sa i cana ndo sii. Ta ñá catyi sa ma cuu quisi. Ta vityi cuñi cote ¿ñaa cuenda i cana ndo sii? ");
INSERT INTO mihNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tacuan i cahan ra Pedro ta zɨquɨ i catyi ra Cornelio: Sa yaha cumi quɨvɨ ta zuun ñi tyehen cuhva i sica tahvi sii ra Ndyoo sisi vehi vatyi tacuan tuhve zacuu sa sahiñi, ta i quituu minoo ra nui. Cuisi xaan zahma ra. ");
INSERT INTO mihNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ta i catyi ra cuan sihin: “Cornelio, i siñi ra Ndyoo sa cohon sihin ra ta nacohon iñi ra tandɨhɨ sa zavohon ta cuhva tyindyeun sii ñiyɨvɨ ndahvi. ");
INSERT INTO mihNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Vityi cua tasun tyiño ndya ñuu Jope vatyi cua canon sii minoo ra sa nañi Simón Pedro. Ndyaa ra vehe minoo ra zatyahyu ñɨɨ. Nañi tucu ra cuan Simón. Yuhu tyañuhu iyo vehe ra. Naquisi maa ra ta cua zacuaha ra suun.” ");
INSERT INTO mihNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tacuan i cuu si, ta yatyi i tasi tyiño sa nanducu ñiyɨvɨ suun. Ta vaha vatyi i quisun. Ta vityi yucu yo ihya nuu ra Ndyoo, ta cuñi ndi tyizoho ndi tandɨhɨ cuii cuhva tasi ra Ndyoo suun sa zacoton sii ndi. ");
INSERT INTO mihNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tacuan ta i quisaha cahan ra Pedro ta catyi ra: Vityi cutuñi iñi vatyi inuu ñi cuñi ra Ndyoo sii tandɨhɨ cuii ñiyɨvɨ. Ñahñi sa zɨɨn iyo yo cuhva cuñi ra sii yo. ");
INSERT INTO mihNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ta tandɨhɨ ñuu cuñi ra Ndyoo sii yoo ra zavaha sa vaha, sii yoo ra yuhu ta tyaa ra yahvi sii ley ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","I cahan ra Ndyoo sihin nduhvi ñiyɨvɨ hebreo, ta nacatyi ra sihin ndi vatyi cua coo sa taxi ñi añima yo sa cuenda ra Jesucristo. Ta maa ra cuu ra ndyaca ñaha sii tandɨhɨ sa iyo. ");
INSERT INTO mihNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Sito vaha maa ndo ñaa sa sicoo ñuu ra hebreo. I quisaha si ñuu sa nañi Galilea. Xihna ca i zacoo ndutya ra Juan sii ñiyɨvɨ, ta i zacuaha ra sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ta zɨquɨ i quita ra Jesús, ra ñuu Nazaret, ta saha ra Ndyoo cuhva sii ra sa cuenda Tatyi Ii. Ta i sica noo ra Jesús, ta i zavaha ra sa vaha, ta i zanduvaha ra sii ñu ndyehe tundoho cuenda cuihna. Tacuan i zavaha ra vatyi i tyindyee ra Ndyoo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ta maa ndi cuu ra cu sa ndaa sa cuenda tandɨhɨ sa i zavaha ra Jesús nu cu si Judea ta ñuu cahnu Jerusalén. Ta i tyaa ñu sii ra nu cruz, ta i sahñi ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Zoco sa yaha uñi quɨvɨ ta i zanandoto ra Ndyoo sii ra. Ta i saha ra sa ndyehe maa ndi sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ñá quituu ra nuu tandɨhɨ ñiyɨvɨ. Maa ñi nuu maa ndi, ra i casi ra Ndyoo vatyi cua cuu ndi sa ndaa. Sasi ndi sihin ra ta sihi ndi ndutya sihin ra ta sa yaha nandoto ra sa sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ta i tasi ra sii ndi sa nacatyi ndi sihin ñiyɨvɨ. Ta sa ndaa cuu ndi vatyi vityi i saha ra Ndyoo tyiño sii ra Jesús sa cuu ra juez sii ñiyɨvɨ ndito ta sii ñiyɨvɨ i sihi. ");
INSERT INTO mihNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Sa cuenda ra Jesús i cahan tandɨhɨ ra profeta ta tyiemvu ta catyi ra vatyi tandɨhɨ ñiyɨvɨ sino iñi sii ra Jesús cua zandasi ra cuatyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ta zuun ñi cuhva sa cahan ra Pedro ta i noo Tatyi Ii sii tandɨhɨ ñu tyizoho. ");
INSERT INTO mihNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ta ra hebreo sa sino iñi Tuhun Ndyoo, ra i quisi sihin ra Pedro, iyo xaan i cuñi ra vatyi saha ra Ndyoo Tatyi Ii ra sii inga ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu. ");
INSERT INTO mihNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Vatyi siñi ra sa cahan ñu inga tuhun sa ña tuhva ñu cahan ta zacahnu ñu sii Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tacuan ta i catyi ra Pedro: Sa i saa Tatyi Ii sii ñiyɨvɨ ya cuhva i saa ra sii maa yo. Ta vityi yoñi ra cua catyi vatyi ma cuu coo ndutya ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tacuan, ta i catyi ra Pedro vatyi cua coo ndutya ñu sa cuenda ra Jesucristo. Ta sa yaha sicoo ndutya ñu ta i sica ca ñu sa ndoo ra Pedro zuhva ca quɨvɨ ñuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ra apóstol ta inga ra sino iñi Tuhun Ndyoo nu cu si Judea i ñihi ra tuhun vatyi sino iñi ñiyɨvɨ Tuhun Ndyoo. Ta yɨvɨ ñiyɨvɨ hebreo cuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ta sa naquita ra Pedro ñuu Jerusalén ta ra hebreo ra sino iñi sii ra Jesús i cahan ra sii ra Pedro vatyi ra hebreo cuan ñihi xaan ndyico ra costumbre ñiyɨvɨ hebreo ta sica iñi ra vatyi ñiñi xaan sa tahndya ñɨɨ xiñi xuu rayɨɨ ndɨhɨ ca, ta tacuan ta cua cacu añima ra, sica iñi ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ta i catyi ra: ¿Ñaa cuenda sohon vehe ñiyɨvɨ cuan ta yɨvɨ ñiyɨvɨ hebreo cuu ñu? ¿Ta ñaa cuenda sasun sihin ñu ta ña ndyico ñu costumbre maa yo? ");
INSERT INTO mihNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tacuan ta i nacatyi ra Pedro tandɨhɨ sihin ra ndya cuhva quisaha tyiño cuan ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ta sindyaa mi ñuu Jope ta zuun ñi cuhva sa sica tahvi sii ra Ndyoo ta i ndyehi minoo sa ndyehi. I noo minoo tañi minoo zahma yuu cahnu. I noo si sihin cumi tahan sɨquɨ si ndya nu ndyei. ");
INSERT INTO mihNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ta i ndyehe vehi vatyi cua ndyehi ñaa sa ñoho sisi si, ta i ndyehi vatyi ñoho tandɨhɨ nuu quɨtɨ iyo cumi tahan saha ta ñoho coo ta ñoho zaa. ");
INSERT INTO mihNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ta i siñi sa cahan ra Ndyoo ta catyi ra: “Nduviton Pedro. Cahñun sii tɨ ta casun.” ");
INSERT INTO mihNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Zoco i catyi: “Ma cuu tata vatyi tañaha ca casi sa cuxi caa.” (Ta ica casi quɨtɨ cuan sa cuenda costumbre maa yo.) ");
INSERT INTO mihNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tacuan ta zɨquɨ i cahan tucu ra Ndyoo ta catyi ra: “Ma catyun vatyi ica sa sehi suun.” ");
INSERT INTO mihNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tacuan i cuu si uñi tahan saha, ta zɨquɨ i nandaa tucu si ityi zɨquɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ta zuun ñi caa cuhva cuan i saa uñi tahan ra vehe nu ndyei. I tasi ñiyɨvɨ sii ra ndya ñuu Cesarea vatyi cua nanducu ra sii. ");
INSERT INTO mihNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ta i tasi Tatyi Ii sii sa cuhin sihin ra ta i catyi si sihin vatyi ma caca xaan iñi. Ta i sahan tucu maa ra ihya sa iñu tahan ca ra sino iñi Tuhun Ndyoo. Tandɨhɨ ndi i quɨhvɨ ndi vehe ra sa i cana sii ndi. ");
INSERT INTO mihNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ta i nacatyi maa ra sihin ndi cuhva i ndyehe ra minoo ángel sisi vehe ra. Nandyaa si ta catyi si: “Tasun sii ra cua cana sii ra Simón Pedro ndya ñuu Jope. ");
INSERT INTO mihNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ta cua nacatyi ra Pedro cuan suhun yozo caa cua cacun sihin ñiyɨvɨ suun.” Tacuan i catyi ángel cuan sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ta sa quisehi quehin sihin ñu ta i noo Tatyi Ii sii ñu tañi i noo ra sii maa yo sa xihna ñi. ");
INSERT INTO mihNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tacuan ta i nacohon iñi cuhva i catyi ra Jesús: “Ndisa i zacoo ndutya ra Juan sii ñiyɨvɨ sihin ndutya, zoco sihin Tatyi Ii cua coo ndutya maa ndo.” ");
INSERT INTO mihNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ta vityi tatu ɨɨn ñi cuhva saha tucu ra Ndyoo sii ñu inuu ñi tañi saha ra sii maa yo ra sino iñi sii ra Jesucristo, ¿ñaa cuenda ma tahan iñi yo cuhva zavaha ra Ndyoo? I catyi ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tacuan i cuu ta sa siñi ra sino iñi Tuhun Ndyoo ñuu Jerusalén cuhva cuan, ta ñá cahan ca ra, ta i zacahnu ra sii ra Ndyoo. Ta i catyi ra: Saha ra Ndyoo sa sino tucu iñi inga ñiyɨvɨ vazu yɨvɨ ñiyɨvɨ hebreo cuu ñu. Ta vityi cua zama ñu cuhva iyo ñu, ta tacuan ta cua ñihi ñu sa cundito ñu tandɨhɨ cuii tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ta sa i sahñi ñiyɨvɨ sii ra Esteban ta zɨquɨ i quisaha sicoo tundoho sii inga ñiyɨvɨ sino iñi Tuhun Ndyoo. Ta tandɨhɨ ñu i sitya cuatyi. Zuhva ñu i saa nu cu si Fenicia ta ñuu Antioquía ta inga ñu i saa minoo ñuhu sa nañi Chipre sa ndyaa mahñu tyañuhu. Ta i nacatyi maa ñu Tuhun Ndyoo maa ñi sihin ñiyɨvɨ hebreo. ");
INSERT INTO mihNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Zoco zuhva ñu sino iñi, ñiyɨvɨ ñuu Chipre ta ñuu Cirene, cuahan ñu ndya ñuu Antioquía ta i nacatyi maa ñu Tuhun Ndyoo sihin ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu. I nacatyi ñu sihin ñu tuhun ra Cristo Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","I saha xaan ra Ndyoo cuhva sii ñu, ta cuaha xaan ñiyɨvɨ i sino iñi ta i zandoo ñu costumbre sahnu sii ñu. Ta i sindyico ñu sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","I saa tyiño ya ndya nu yucu ñu sino iñi ñuu Jerusalén, ta i tasi ñu sii ra Bernabé ndya ñuu Antioquía. ");
INSERT INTO mihNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ta sa saa ra, ta i ndyehe ra vatyi ndisa i tyindyee xaan ra Ndyoo sii ñiyɨvɨ cuan. Zɨɨ xaan i cuñi ra, ta i saha ra tyiño sii ñu sa tyaa xaan ñu yahvi sii ra Jesús ta cundyico ñu sii ra sihin tandɨhɨ cuii añima ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Vaha xaan ra cuu ra Bernabé, iyo xaan Tatyi Ii sii ra, ta nɨɨ xaan iñi ra. Ta cuaha xaan ñiyɨvɨ i sino iñi sii ra Jesús sa cuenda maa ra. ");
INSERT INTO mihNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tacuan ta zɨquɨ cuahan ra Bernabé ndya ñuu Tarso vatyi cua nanducu ra sii ra Saulo. ");
INSERT INTO mihNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ta sa nañihi ra sii ra, i sindyaca ra sii ra ndya ñuu Antioquía. Ta minoo maa cuiya i sindyaa nduu tahan ra sihin ñiyɨvɨ sino iñi yucuan, ta i zacuaha ra sii cuaha xaan ñiyɨvɨ. Ta ñuu Antioquía cuan cuu ñuu sa xihna ñi nu i zacunañi ñiyɨvɨ cristiano sii ñu ndyico sii ra Cristo. ");
INSERT INTO mihNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ta quɨvɨ cuan i quita zuhva ra profeta ñuu Jerusalén ta cuahan ra ndya ñuu Antioquía. ");
INSERT INTO mihNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Minoo ra nañi ra Agabo. I nduvita ra nu yucu ra sino iñi Tuhun Ndyoo ta i cahan ra cuhva catyi Tatyi Ii sihin ra. I catyi ra vatyi cua quisi minoo tama cahnu xaan nacahnu ñuu ñiyɨvɨ. Ta tacuan i tahan si cuhva i catyi ra zuun ñi sisi quɨvɨ i sindyaca ñaha ra emperador Claudio. ");
INSERT INTO mihNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tacuan ta ñu sino iñi ñuu Antioquía i sica iñi ñu vatyi cua tasi ñu xuhun ta tyindyee ñu sii ñu sino iñi nu cu si Judea. Cua tasi tahan tahan ñu yozo cuhva sa cundyee iñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ta tacuan i zavaha ñu. I tasi ñu xuhun i zacasi tahan ñu sihin ra Bernabé ta ra Saulo ndya nu ndyaa ra ndyizo tyiño nu yucu ñu sino iñi Tuhun Ndyoo ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ta zuun ñi tyiemvu cuan i quisaha ra rey Herodes zavaha ra sa ña vaha sihin ñiyɨvɨ sino iñi Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Sahñi ñiyɨvɨ sii ra Jacobo yañi ra Juan sihin minoo mityi i zacuu ra Herodes. ");
INSERT INTO mihNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ta sa ndyehe ra Herodes vatyi tahan iñi ñiyɨvɨ hebreo sa tacuan ta zɨquɨ i tɨɨn ra sii ra Pedro. Ta i cuu si quɨvɨ vico zavaha ñiyɨvɨ hebreo sa nacohon iñi ñu quɨvɨ i quita ñu ñuu Egipto. Ta vico cuan tuhva ñu casi pan ña ndaa. ");
INSERT INTO mihNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ta i tɨɨn ra Herodes sii ra Pedro ta i tyihi ra sii ra vehe caa. Cumi ityi zandaru i sicumi sii ra. Ta cumi tahan zandaru i cuu tahan tahan ityi ra. Sa cumi tahan zandaru i sicumi sii ra tahan tahan ora. Sica iñi ra Herodes vatyi ndya sa yaha vico tacuan ta zɨquɨ cua cutuñi ra Pedro ta cua cuu ra nuu ñiyɨvɨ hebreo vatyi tacuan ta zɨɨ cua cuñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ñoho ra Pedro vehe caa ta sicumi xaan zandaru sii ra, zoco ñiyɨvɨ sino iñi Tuhun Ndyoo sica tahvi xaan ñu sii ra Ndyoo sa cuenda ra. ");
INSERT INTO mihNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tacuan ta zuun ñi sa cuaa cuan sica iñi ra Herodes vatyi inga quɨvɨ cua tasi ra sii ra Pedro cunahma ra nu yucu ñiyɨvɨ. Ta sa cuaa cuan i quixi ra Pedro tɨcuɨ uu tahan zandaru. Nuhñi ra sihin uu tahan cadena. Ta cumi inga zandaru yuvehe caa cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ta ta sica ñi i quɨhvɨ minoo ángel Ndyoo sisi vehe caa ta i ndundisi. I tɨɨn ángel cuan zoco ra Pedro vatyi cua zandoyo ra sii ra. Ta i catyi ra sihin ra: Zanumi. Nduviton. Ta ta sica ñi i ndasi cadena ndaha ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ta i catyi ángel sihin ra: Nacuhñi vaha sisun ta natyuhun zapato sohon. Ta tacuan i zavaha ra. Ta i catyi ángel sihin ra: Nazucun zahmon suun. Ta quisi ndyicon sii. ");
INSERT INTO mihNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","I sindyico ra Pedro sii ángel cuan sisi vehe caa cuan. Ña sito ra a sa ndisa zacuu ángel a ñimahna tahan ra. ");
INSERT INTO mihNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","I yaha nduu tahan ra sa xihna ñi nu cumi minoo zandaru, ta zɨquɨ i yaha ra sa cu uu nu cumi inga ra ta i saa ra minoo yuvehe cahnu. Vee xaan si. Maa caa cuu si. Ta yucuan yuvehe quita si ndya calle. I nuña ñi maa yuvehe cuan ta i quita ra. I sica ra zuhva ca ta i zandoo ángel sii ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tacuan ta zɨquɨ i sito ra Pedro sa ndisa ta i catyi ra: Vityi site vatyi ndisa cuu si. I tasi ra Ndyoo minoo ángel ta i zacacu ra sii mi si ndaha ra Herodes ta cuhva sa ña vaha sa cuñi ñiyɨvɨ hebreo zavaha ñu sihin. ");
INSERT INTO mihNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tacuan i sica iñi ra Pedro ta cuahan ra ndya vehe ña María zɨhɨ ra Juan Marcos. Yucuan siyucu cuaha xaan ñiyɨvɨ. Sica tahvi ñu sii Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","I cati ra Pedro yuvehe nuzama. Ta i quisi minoo ña cu muzu. Nañi ña Rode. ");
INSERT INTO mihNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","I nacoto ña nduzu ra Pedro sa cahan ra, ta zɨɨ xaan i cuñi ña ta nu yuvehe ñá nuña ña. Sino ña i sinacatyi ña sihin ñiyɨvɨ vatyi ndyaa ra Pedro yuvehe cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Zoco ñiyɨvɨ cuan i catyi ñu sihin ña: Zana tahan xiñun. Ta i catyi maa ña vatyi ndisa cuii vatyi maa ra cuu ra. Ta zɨquɨ i catyi ñiyɨvɨ: Ángel sa zacuenda sii ra cuu si. ");
INSERT INTO mihNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ta ra Pedro ndita ñi i cati ra yuvehe cuan. Tacuan ta i nuña ñu yuvehe ta iyo xaan i cuñi ñu sa nandyehe ñu sii ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ta saha ra Pedro zeña sii ñu sihin ndaha ra nacutaxi ñu, ta i nacatyi ra sihin ñu yozo caa i tava ra Ndyoo sii ra vehe caa. Ta catyi ra sihin ñu: Tacuan nacatyi ndo sihin ra Jacobo ta sihin inga ra sino iñi Tuhun Ndyoo, i catyi ra. Tacuan i cahan ra ta zɨquɨ cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ta sa vasi cundisi ta sica xaan iñi tandɨhɨ zandaru vatyi ña sito ra ndyamaa cuahan ra Pedro. ");
INSERT INTO mihNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","I tasi ra Herodes tyiño sa cua nanducu ra sii ra Pedro, zoco ñá nañihi ra sii ra. Tacuan ta zɨquɨ i zanahma xaan ra Herodes sii zandaru cuan. Ñá ñihi zandaru cuhva nacatyi ra. Tacuan i cuu, ta i catyi ra Herodes vatyi cua cuu tandɨhɨ zandaru cuan. Tacuan ta cuahan ra Herodes inga ñuu sa nañi Cesarea cua cundyaa ra. ");
INSERT INTO mihNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Xaan xaan cuñi ra Herodes sihin ñiyɨvɨ ñuu Tiro ta ñiyɨvɨ ñuu Sidón ta ñá cuñi ra tyindyee ra sii ñu. Ta zɨquɨ i saa ñiyɨvɨ ñuu cuan nu iyo ra ta i cahan ñu sihin ra Blasto. Minoo ra ndyizo tyiño nuu ra Herodes cuu ra. I tyiyahvi ñiyɨvɨ sii ra sa cuu ra yuhu ñu nuu ra Herodes. I sica ñiyɨvɨ cuan sa coo sa taxi ñi sihin ra Herodes ta sihin ñuu ñu vatyi tandɨhɨ sa sasi ñu quita si ñuhu nu ndyaca ñaha ra Herodes. ");
INSERT INTO mihNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ta i sata ra Herodes quɨvɨ sihin ñu. Ta sa saa quɨvɨ i ndɨhvɨ ra zahma vaha ra ta i sindyaa ra tyayu cahnu ra ta i cahan ra sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ta sa ndɨhɨ cahan ra ta tandɨhɨ cuii ñiyɨvɨ i catyi: Yɨvɨ ñiyɨvɨ cuu ra cahan ya. Ndyoo cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Zuun ñi caa cuhva cuan i quihin cuehe sii ra Herodes i zacuu minoo ángel Ndyoo vatyi tahan iñi ra Herodes sa catyi ñiyɨvɨ vatyi Ndyoo cuu maa ra. Cahnu xaan tundoho i ndyehe ra vatyi sasi tindacu sii ra ta sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tacuan i cuu ta Tuhun Ndyoo cuahan ca nducahnu ca si. Nacatyi xaan ca ñiyɨvɨ Tuhun Ndyoo sihin inga ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Sa ndɨhɨ tyiño ra Bernabé ta ra Saulo ñuu Jerusalén, ta i ndisi nanuhu ra ndya ñuu Antioquía. I quihin ra sii ra Juan Marcos ta vasi ra sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ihya cuu zɨvɨ ra profeta ta ra zacuaha Tuhun Ndyoo sii ñiyɨvɨ ñuu Antioquía. Minoo ra nañi ra Bernabé, inga ra nañi ra Simón, ra nengu cuu inga zɨvɨ ra. Inga ra nañi ra Lucio ra ñuu Cirene sihin ra Saulo ta ra Manaén. Ɨɨn ñi i sahnu ra Manaén sihin ra Herodes ra ndyaca ñaha nu cu si Galilea. ");
INSERT INTO mihNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Minoo quɨvɨ i siyucu tandɨhɨ ra cuan. Ta ñá sasi ra xita vatyi zacahnu ra sii ra Ndyoo ta zɨquɨ i catyi Tatyi Ii sihin ra: Cua tasi ndo sii ra Bernabé sihin ra Saulo nu cua zatyiño ra sa cuenda mi vatyi cua cuhve tyiño sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tacuan ta i sica tahvi ca ra cuan sii Ndyoo ta ñá sasi ra xita, ta zɨquɨ i tyizo ra ndaha ra sii ra vatyi cua cuizo tyiño ra ta i tasi ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tacuan i tava Tatyi Ii tyiño sii ra Bernabé sihin ra Saulo ta cuahan ra ndya Seleucia, ta indyacuan i quihin ra barco vatyi cua cuhun ra ndya minoo ñuhu sa ndyaa mahñu tyañuhu, nañi si Chipre. ");
INSERT INTO mihNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ta yucuan i saa ra, minoo yuhu tyañuhu nu nañi si Salamina ta i quisaha zacuaha ra Tuhun Ndyoo sii ñiyɨvɨ vehe ñuhu ñiyɨvɨ hebreo. Ta cuahan tucu ra Juan sihin ra cua tyindyee ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","I sica noo ra nacahnu ñuhu Chipre ta i saa ra ñuu Pafos. Indyacuan i tahan ra sii minoo ra nañi Barjesús. Minoo ra tazi cuu ra. Vatya xaan ra ta catyi ra vatyi cahan ra sa cuenda ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ndyaa ra cuan sihin ra Sergio Paulo, ra cu gobernador. Casi xaan iñi ra Sergio cuan. I cana ra sii ra Bernabé ta ra Saulo vatyi cuñi ra tyizoho ra Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Zoco ra tazi cuan, Elimas cuu inga zɨvɨ ra. Ñá saha ra sa tyizoho ra gobernador sa cahan ra Saulo vatyi ñá cuñi ra sa cua sino iñi ra sii ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ta ra Saulo, ta nañi tucu ra Pablo, situ xaan Tatyi Ii sii ra ta ñihi xaan i ndyehe ra sii ra ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ra zandavi ñaha cuun. Tandɨhɨ cuii sa ña vaha zavohon. Zehe cuihna cuu suun ta numinoo sa vaha ña zavohon. Ta zamon cuhva cahan ra Ndyoo sa ndisa ta nacatyun sa vatya. ");
INSERT INTO mihNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ta vityi cua tasi tuñi ra Ndyoo suun. Cua cuoon zuhva quɨvɨ, ta ma ndyehun ñuhu ñicandyi. Ta ta sica ñi i cuaa ra. Ta i nducu ra yoo ra tɨɨn ndaha ra ta cundyaca ra sii ra vatyi ña cuu ndyehe ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ta sa ndyehe ra gobernador sa tahan ra tazi cuan ta i sino iñi ra sii ra Jesús vatyi iyo xaan i cuñi ra sa ndyehe ra yozo caa iyo tuhun sa cuenda ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","I quita ra Pablo sihin ra tahan ra ñuu Pafos sihin barco ta cuahan ra ndya ñuu Perge sa iyo cuenda Panfilia. Yucuan i zandoo ra Juan sii ra ta cua nanuhu ra ndya ñuu Jerusalén. ");
INSERT INTO mihNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ta zɨquɨ i quita ra Pablo ñuu Perge ta cuahan ra minoo ñuu cahnu sa nañi Antioquía sa cuu cuenda Pisidia. Ta yucuan sahan ra vehe ñuhu ñiyɨvɨ hebreo quɨvɨ quitatu ñiyɨvɨ, ta i sicundyaa ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Sa xihna ñi i cahvi ñiyɨvɨ zuhva sa i tyaa ra Moisés ta zɨquɨ i cahvi ñu sa tyaa inga ra profeta ta tyiemvu. Tacuan i cuu ta zɨquɨ i tasi ra cu nuu sii vehe ñuhu cuan tyiño sii ra Pablo ta catyi ra: Yañi xaa, tatu iyo minoo tuhun sa cuñi ndo zacoto ndo sii ñiyɨvɨ. Cuu nacatyi ndo sihin ndi vityi. ");
INSERT INTO mihNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tacuan ta i nduvita ra Pablo ta saha ra minoo zeña sihin ndaha ra sa cua cutaxi ñiyɨvɨ ta catyi ra: Tyizoho ndo yañi xaa, ndoho ra hebreo, ta tandɨhɨ inga ndoho, ra yuhu sii ra Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ra cu Ndyoo sii maa yo ñiyɨvɨ hebreo i casi ra sii ñiyɨvɨ sahnu sii yo. Ta i tyindyee ra sii ñu, ta i nduu ñu minoo ityi ñiyɨvɨ cahnu xaan vazu i sica noo ndahvi ñu ñuu Egipto. Ta zɨquɨ sihin cuhva iyo sii maa ra i tava ra sii ñu ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","I cundyee xaan iñi ra Ndyoo sihin ñu tañi uu xico cuiya sa sica noo ñu nu yoñi maa ñiyɨvɨ iyo ta i zavaha ñu cuhva cuñi maa ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ta i zanaa ra usa tahan ityi ñiyɨvɨ nu cu si Canaán vatyi cua cuhva ra ñuhu cuan sii ñiyɨvɨ sahnu sii yo. ");
INSERT INTO mihNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ta zɨquɨ cumi ziendu uu xico usi cuiya saha ra Ndyoo sa cundyaca ñaha juez sii ñiyɨvɨ ndya quɨvɨ i naquihin ra Samuel tyiño cuan. Ta ra Samuel i cuu tucu ra minoo ra cu profeta. ");
INSERT INTO mihNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ta zɨquɨ i sica ñiyɨvɨ minoo rey, ra cua cundyaca ñaha sii ñu. Ta i saha ra Ndyoo sii ra Saúl zehe ra Cis sii ñu. Ñiyɨvɨ sii ra Benjamín i cuu sii ra. I sindyaca ñaha ra Saúl sii ñu uu xico cuiya. ");
INSERT INTO mihNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ta i tava ra Ndyoo sii ra. Ta zɨquɨ i saha ra sii ra David sa cuu ra rey, ta sa cuenda maa ra i catyi ra Ndyoo: “Site sii ra David zehe ra Isaí. Zɨɨ xaan cuñi sihin ra vatyi cua zavaha ra tandɨhɨ cuii sa cuñi.” ");
INSERT INTO mihNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ta ñiyɨvɨ sahnu sii ra Jesús i cuu sii ra David. Ta i tasi ra Ndyoo sii ra Jesús vatyi cua zacacu ra sii ñiyɨvɨ hebreo tañi sa i catyi ra Ndyoo ta tyiemvu. ");
INSERT INTO mihNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Cumañi ca saa ra Jesús ta i nacatyi xaan ra Juan sihin tandɨhɨ ñiyɨvɨ hebreo vatyi ndu‑uu iñi ñu cuatyi ñu ta coo ndutya ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ta sa cuñi ndɨhɨ tyiño ra Juan ta i catyi ra: “Ndatu ndo sii minoo ra cahnu xaan. Ta sica iñi ndo vatyi zuun ra cui. Zoco yɨvɨ ra cui. Ra i tasi ra ityi nuu cui. Ra vaha xaan ca cuu maa ra, ta ñiñi xaan ra, ta yucuan cuenda ma cuu tyindyei sii ra nu zuhva tañi sa ndasi tyiendu ndisa ra.” Tacuan i catyi ra Juan. ");
INSERT INTO mihNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ta cahan ca ra Pablo ta catyi ra: Yañi xaa, ndoho ñiyɨvɨ ra Abraham ta tandɨhɨ inga ndo, ra yuhu sii ra Ndyoo. Saha ra Ndyoo cuhva cacu ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ñiyɨvɨ ñuu Jerusalén sihin ra ndyaca ñaha sii ñu, ñá sito ñu yoo ra cuu ra Jesús vatyi zehe Ndyoo cuu sii ra, ta ñá ñihi ñu cuhva sihin tuhun i tyaa ra profeta ta tyiemvu vazu cahvi ñu sii si vehe ñuhu ñu tahan xiñi vitya. Ta zuun ñi ñiyɨvɨ cuan i tyaa cuatyi sata ra Jesús. Ta tacuan i natahan si tañi sa catyi ra profeta. ");
INSERT INTO mihNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ta vazu ñá ñihi ñiyɨvɨ cuhva sa tyaa ñu cuatyi sata ra Jesús sa ndisa cuii, zoco i sica ñu sii ra Pilato sa cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ta sa yaha zavaha ñu tandɨhɨ cuhva catyi Tuhun Ndyoo sa cuenda ra Jesús ta zɨquɨ i zanoo ñu sii ra nuu cruz ta tyihi ñu sii ra ñaña sisi minoo yavi yuu. ");
INSERT INTO mihNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Zoco i zanandoto ra Ndyoo sii ra sisi sa i sihi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ta cuaha xaan quɨvɨ i quituu ra Jesús nuu ñiyɨvɨ i quisi sihin ra ndya Galilea ta ñoho ñu ñuu Jerusalén. Ta vityi maa ñu cu ñu nacatyi sihin ñiyɨvɨ vatyi i ndyehe ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ta vityi nacatyi maa ndi minoo cuhva vaha sihin ndo vatyi tañi sa sito ndo vatyi ta tyiemvu saha ra Ndyoo cuenda sii ñiyɨvɨ sahnu sii yo yozo caa cua zavaha ra nu cuahan quɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ta vityi sito yo vatyi sa zavaha ra Ndyoo cuhva catyi ra vatyi saha ra tundyee iñi sii ra Jesús, ta i nandoto tucu ra. I tyaa ra David salmo número uu. I tyaa ra David cuhva i cahan ra Ndyoo sa cuenda ra Jesús ta catyi ra: “Zehe mi cuu suun, ta vityi cua ndyehe ñiyɨvɨ vatyi sehi sa cua nandoton.” ");
INSERT INTO mihNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Iyo inga nu catyi tucu ra Ndyoo sa cuenda ra Jesús: “Cua tyindyei suun sa ndisa, cuhva i catyi sihin ra David.” Tacuan i catyi ra Ndyoo vatyi cua zanandoto ra sii ra Jesús sisi sa i sihi ra. Ma cuhva ra Ndyoo sa tyahyu coño ñuhu ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yucuan cuenda catyi tucu inga salmo: “Ma cuhvon sa tyahyu coño ñuhu ra tyaa xaan yahvi suun.” ");
INSERT INTO mihNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Sa ndisa cuu si vatyi i zavaha ra David cuhva cuñi ra Ndyoo sa sindito ra ñuu ñiyɨvɨ, ta zɨquɨ i sihi ra ta i tyihi ñiyɨvɨ sii ra sisi ñaña ta i tyahyu coño ñuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Zoco coño ñuhu ra i zanandoto ra Ndyoo, ña tyahyu si. ");
INSERT INTO mihNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Yañi xaa, cuñi si sa coto ndo vatyi sa cuenda ra Jesús ta cua zandasi ra Ndyoo cuatyi ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ma nduvaha añima ndo vazu cumi vaha xaan ndo ley i saha ra Ndyoo sii ra Moisés. Vatyi ma nduvaha añima ndo sa tacuan ñi. Ra Jesús cua zanduvaha añima ndo tatu cua sino iñi ndo sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Zacuenda vaha ndo sii ndo coto cua tahan ndo cuhva i tyaa ra profeta ta tyiemvu. I catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ndyehe ndoho, ra ña sino iñi. Cu‑iyo xaan ndo ta cua cunaa ndo. Vatyi cua zavehi minoo cuhva. Ta iyo xaan cua cuñi ndo. Ta ma sino iñi ndo Numaa nacatyi xaan ñiyɨvɨ sito sihin ndo. Ta ihya i ndɨhɨ sa cahan ra Pablo sihin ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ta sa quita ra Pablo sihin ra tahan ra sisi vehe ñuhu hebreo cuan. Ta i sica ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu sii ra Pablo vatyi cua zacuaha tucu ra sii ñu inga quɨvɨ quitatu ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ta sa quita tandɨhɨ ñiyɨvɨ vehe ñuhu ta cuaha xaan ñiyɨvɨ hebreo ta ñiyɨvɨ tyaa xaan yahvi ley ñiyɨvɨ hebreo, i sindyico ñu sii ra Pablo ta ra Bernabé. Ta i nacatyi xaan ra Pablo ta ra Bernabé sihin ñu vatyi ma naa iñi ñu sa nacatyi ra sihin ñu ta nacañi vaha iñi ñu yozo caa zavaha xaan ra Ndyoo tumañi iñi sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ta inga vitya quɨvɨ quitatu ñiyɨvɨ i titahan sa yatyi tandɨhɨ ñiyɨvɨ ñuu cuan vatyi cua tyizoho ñu Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Zoco sa ndyehe ñiyɨvɨ hebreo, ra ña sino iñi, vatyi i titahan cuaha xaan ñiyɨvɨ ta i cucuihna iñi ra. Ta i quisaha catyi ra vatyi ña vaha sa cahan ra Pablo ta i cahan ra ndya vaha ñi sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Zoco ñá yuhu ra Pablo ta ra Bernabé ta i quisaha catyi ra sihin ñu: Cuñi si sa nacatyi ndi Tuhun Ndyoo xihna ca sihin maa ndo vatyi ñiyɨvɨ hebreo cuu ndo, zoco ña cuñi ndo tyizoho ndo. Ta cuhva zavaha ndo zañaha ndo vatyi ña cuñi ndo sa cuhun ndo gloria. Ta yucuan cuenda cua cuhun ndi nu iyo inga ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu. ");
INSERT INTO mihNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tacuan cua zavaha ndi vatyi ndya ta tyiemvu i catyi maa ra Ndyoo: “Tañi minoo ñúhu cua cuu maa ndo sii tandɨhɨ ñiyɨvɨ ñuu ñiyɨvɨ vatyi cua nacatyi ndo sihin tandɨhɨ cuii ñiyɨvɨ yozo caa cua nduvaha añima ñu.” Ta i cahan ra Ndyoo cuhva cuan sa cuenda maa ndi. ");
INSERT INTO mihNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ta sa siñi ñiyɨvɨ, ñu sa yɨvɨ ñiyɨvɨ hebreo cuu, ta zɨɨ xaan i cuñi ñu, ta i quisaha catyi ñu vatyi vaha xaan cuu Tuhun Ndyoo. Ta tandɨhɨ ñu i casi ra Ndyoo vatyi cuhun ñu gloria, i sino iñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tacuan i cuu ta i sitya Tuhun Ndyoo tandɨhɨ ñuu yucuan. ");
INSERT INTO mihNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Zoco i cahan ra hebreo, ra ña sino iñi, sihin minoo ityi ñu zɨhɨ, ñu zacahnu sii ra Ndyoo cuhva iyo costumbre maa ñu, ta i cahan tucu ra hebreo sihin ra ñiñi ñuu cuan ta i quisaha ra cuatyi cuhva ndya i tava ra sii ra Pablo ta ra Bernabé ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tacuan ta zɨquɨ i quɨzɨ ra Pablo ta ra Bernabé saha ra ta i tava ra ñiyaca ñuu cuan vatyi ma ndoo ca ra sihin ñiyɨvɨ ñuu cuan ta cuahan ra ndya minoo ñuu cahnu sa nañi Iconio. ");
INSERT INTO mihNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Zoco zɨɨ xaan i cuñi ñu sino iñi ñuu Antioquía cuan, ta i sicoo xaan Tatyi Ii sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ñoho ra Pablo ta ra Bernabé ñuu Iconio ta i quɨhvɨ ra vehe ñuhu ñiyɨvɨ hebreo. Vaha xaan i cahan ra yucuan ndya cuhva ndya i sino iñi cuaha xaan ñiyɨvɨ, ñu hebreo ta inga ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Zoco ra hebreo, ra ña sino iñi, i cahan ra ndya vaha ñi sii ra sino iñi Tuhun Ndyoo ta i zasino ra iñi ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu minoo cuhva ña vaha. ");
INSERT INTO mihNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Yucuan cuenda i ndoo ra Pablo ta ra Bernabé naha xaan indyacuan. Ñá yuhu ra ta cahan ra Tuhun Ndyoo vatyi nɨɨ cuu iñi ra sii Ndyoo. Ta i saha ra Ndyoo cuhva sii ra sa zavaha ra sa ndyityi vatyi tacuan ta cua coto ñiyɨvɨ vatyi cahan ra sa ndisa sa catyi ra vatyi cuñi xaan ra Ndyoo sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ñá ndu‑ɨɨn ñiyɨvɨ ñuu Iconio cuan. Iyo ñu sino iñi ñu sa cahan ra hebreo, ra ña sino iñi, ta iyo ñu sino iñi ñu sa cahan ra apóstol. ");
INSERT INTO mihNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tacuan ta zɨquɨ ra hebreo ta inga ra sa yɨvɨ ra hebreo cuu i ndu‑ɨɨn ra sihin ra cu tyiño vatyi cua zavaha ra ndya vaha ñi sihin ra Pablo ta ra Bernabé. Ta cua cañi ra sii ra sihin yuu ndya cua cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Zoco i ñihi ra Pablo ta ra Bernabé tuhun cuan, ta sa sito ra sii si i sino ra ta cuahan ra ndya ñuu Listra ta ndya ñuu Derbe nu cu si Licaonia ta tandɨhɨ inga ñuu iyo yucuan. ");
INSERT INTO mihNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ta i nacatyi ra sihin ñiyɨvɨ yozo caa cua zacacu ra Ndyoo sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ñuu Listra sicoo minoo ra coxo. Ñá cuu caca ra. Maa sa ndyaa ñi ra vatyi coxo ra cacu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","I tyizoho ra coxo sa cahan ra Pablo ta ndyehe ra Pablo sii ra ta nacoto ra vatyi nɨɨ cuu iñi ra ta cua nduvaha ra. ");
INSERT INTO mihNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tacuan ta ñihi xaan i cahan ra Pablo ta catyi ra: Nacuɨñɨ ndyaa vohon. Tacuan ta i nduvita ra ta i quisaha sica ra. ");
INSERT INTO mihNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ta sa ndyehe ñiyɨvɨ sa zavaha ra Pablo ta i quisaha cana saa ñu sihin zahan maa ñu, zahan ñuu Licaonia ta catyi ñu: Sa vasi uu tahan ndyoo ihya nu iyo yo. Caa ra cuhva caa maa yo. Catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ta tyiemvu sica iñi ñiyɨvɨ vatyi ra Júpiter ta ra Mercurio cuu ra cuu Ndyoo. Yucuan cuenda i catyi ñu vatyi minoo ndyoo nañi Mercurio cuu ra Pablo vatyi maa ra cuu ra cahan. Ta ra Bernabé cuu ra ndyoo sa nañi Júpiter. ");
INSERT INTO mihNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ta i sicoo minoo zutu cuenda ra Júpiter. Ta i sicumi ra vehe ñuhu yu ñuu cuan. I sindyaca ra uu tahan zɨndɨquɨ. Ta i sindyaca ra corona ita. I cuñi maa ra ta i cuñi ñiyɨvɨ sa zacahnu ñu vico nu saa ra Pablo ta ra Bernabé vatyi sica iñi ñu vatyi Ndyoo cuu ra. Ta yucuan cuenda cua cahñi ñu sii zɨndɨquɨ cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Zoco sa sito ra Pablo ta ra Bernabé tuhun cuan ta i ndata ra zahma ndisi ra vatyi ñá tahan iñi ra sa zacuu ñiyɨvɨ Ndyoo sii ra. Ta cacono ra quɨhvɨ ra ndya mahñu ñiyɨvɨ ta i cana saa ra Pablo ta catyi ra: ");
INSERT INTO mihNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Ndoho tata, ¿ñaa cuenda zavaha ndo tacuan ta ñiyɨvɨ cuu ndi tañi maa ndo? ta vasi nacatyi ndi sihin ndo vatyi zandoo ndo sa zavaha ndo cuhva ya vatyi ñahñi tyindyee si. Sino iñi ndo sii ra Ndyoo sa ndisa cuii vatyi maa ra i zavaha andɨvɨ, ñuu ñiyɨvɨ ta tyañuhu ta tandɨhɨ sa iyo. ");
INSERT INTO mihNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ndya ta tyiemvu ta ndya vityi saha ra Ndyoo sa zavaha tandɨhɨ ñiyɨvɨ cuhva cuñi maa ñu ");
INSERT INTO mihNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","vazu zañaha ra sii ñu yoo ra cuu ra vatyi zavaha ra cuaha xaan sa vaha. Saha ra sa coon zavi ta sa coo vaha itu tandɨhɨ cuiya. Saha ra sa casi yo ta sa cuzɨɨ iñi yo. Catyi ra Pablo. ");
INSERT INTO mihNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Zoco vazu i nacatyi ra Pablo tuhun cuan, yɨɨ xaan ta i ñihi ra cuhva zandumazu ra iñi ñiyɨvɨ ta ma cahñi ñu zɨndɨquɨ cuan ta ma zacahnu ñu vico sa cuenda ra. ");
INSERT INTO mihNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tacuan ta i saa minoo ityi ñiyɨvɨ hebreo, ra ña sino iñi. Ra ñuu Antioquía ta ra ñuu Iconio cuu ra. I sino iñi ñiyɨvɨ sa cahan ra ndya vaha ñi sii ra Pablo. Ta i cañi xaan ñu sii ra Pablo sihin yuu cuhva ndya sica iñi ñu vatyi sa sihi ra, ta i xita cañoho ñu sii ra i sindyaca ñu sii ra ndya zava yu ñuu. ");
INSERT INTO mihNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ta i titahan ra sino iñi Tuhun Ndyoo siconduu nu caa ra Pablo, ta i nduvita ra ta nandɨhvɨ tucu ra ñuu cuan. Ta inga quɨvɨ i quita ra yucuan sihin ra Bernabé, cua cuhun ra ñuu Derbe. ");
INSERT INTO mihNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ta sa yaha nacatyi ra Tuhun Ndyoo ñuu Derbe ta i sino iñi cuaha xaan ñiyɨvɨ, ta zɨquɨ cua nanuhu tucu ra ndya ñuu Listra, ñuu Iconio ta ñuu Antioquía. ");
INSERT INTO mihNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Indyacuan saha tucu ra tundyee iñi sii tandɨhɨ ñiyɨvɨ sino iñi Tuhun Ndyoo. Ta i catyi ra sihin ñu: Sino vaha iñi ndo sii ra Jesús, ta ma zaña ndo sii ra. Cua coo tundoho sii yo, zoco tacuan ta cua quɨhvɨ yo nu ndyaca ñaha ra Ndyoo, catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tacuan i cuu ta i tyaa tyiño ra sii uu a uñi tahan ra tahan tahan ñuu nu sino iñi ñiyɨvɨ Tuhun Ndyoo vatyi cua zacuenda ra sii ñu. Ta ñá sasi ra Pablo ta ra Bernabé xita ta i sica tahvi ra sii Ndyoo sa cuenda ra cuan. Ta zɨquɨ i catyi ra: Sa sino iñi ndo sii ra Ndyoo. Maa ra cuu ra cua cucumi vaha sii ndo. Catyi ra. ");
INSERT INTO mihNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tacuan ta zɨquɨ i yaha tucu ra nu cu si Pisidia, ta saa ra nu cu si Panfilia. ");
INSERT INTO mihNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","I nacatyi ra sihin ñiyɨvɨ Tuhun Ndyoo ñuu cahnu sa nañi Perge, ta zɨquɨ cuahan ra ndya Atalia. ");
INSERT INTO mihNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Yucuan i quɨhvɨ ra minoo barco ta cua nanuhu ra ndya ñuu Antioquía nu i quita ra sa xihna ñi. Yucuan cuu ñuu nu i sica ñiyɨvɨ tumañi iñi sii ra Ndyoo sa xihna ñi sa cua tyindyee ra sii ra Pablo ityi cuahan ra. Ta vityi ndɨhɨ tyiño ra. ");
INSERT INTO mihNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ta sa saa ra ñuu Antioquía i zatitahan ra sii ñiyɨvɨ sino iñi Tuhun Ndyoo ta i nacatyi ra sihin ñu tandɨhɨ sa i zavaha ra Ndyoo ta cuhva i tyindyee ra Ndyoo sii ra. Ta cuhva i saha ra Ndyoo sa sino iñi inga ñiyɨvɨ vazu yɨvɨ ñiyɨvɨ hebreo cuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tacuan cuu ta i ndoo ra Pablo ta ra Bernabé naha ca sihin ñiyɨvɨ sino iñi ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ta sa ndyaa ra Pablo ta ra Bernabé ñuu Antioquía sihin ñu sino iñi Tuhun Ndyoo, ta i saa minoo ityi ñiyɨvɨ, ra i quita nu cu si Judea. Ta i quisaha zacuaha ra sii ñiyɨvɨ vatyi tatu cuñi rayɨɨ sa cacu añima ra cuñi si vatyi yɨvɨ sa sino ñi iñi ra sii ra Jesús zoco cua cuhva ra sa tahndya ñɨɨ xiñi xuu ra vatyi tacuan i catyi ley ra Ndyoo ta tyiemvu cuhva i tyaa ra Moisés. ");
INSERT INTO mihNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ñihi xaan i natuhun ra Pablo ta ra Bernabé sihin ra vatyi ñá ndu‑ɨɨn ra sihin ra, cuhva cuan. Tacuan ta zɨquɨ i saha ñiyɨvɨ tyiño sii ra Pablo ta ra Bernabé ta sii zuhva ca ra cua cuhun ra ñuu Jerusalén vatyi cua natuhun ra sihin ra apóstol ta sihin ra ndyizo tyiño nu iyo ra sino iñi indyacuan. Vatyi tacuan ta cua nacoto ra yozo caa cua ndundoo tyiño cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ñiyɨvɨ sino iñi Tuhun Ndyoo ñuu Antioquía cuu ñu i tasi sii ra. Ta sa cuahan ra i yaha ra nu cu si Fenicia, ta nu cu si Samaria. Ta i nacatyi ra sihin ñiyɨvɨ yozo caa i zandoo ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu costumbre sahnu ñu. Ta vityi tyaa ñu yahvi sii Ndyoo. Ta zɨɨ xaan i cuñi tandɨhɨ ñu, sa siñi ñu tuhun cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ta sa saa ra Pablo ta ra Bernabé ñuu Jerusalén ta i ndyehe vaha ra apóstol ta ra ndyizo tyiño nu iyo ra sino iñi nu saa ra. Ta tacuan tucu i zavaha tandɨhɨ ñiyɨvɨ sino iñi Tuhun Ndyoo yucuan. Tacuan ta zɨquɨ i quisaha nacatyi ra Pablo tandɨhɨ sa zavaha ra Ndyoo tandɨhɨ ñuu nu sahan ra. ");
INSERT INTO mihNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tacuan i zavaha ra ta i nduvita uu, a uñi tahan ra. Ra fariseo cuu ra, ta sa sino iñi ra sii ra Jesús. Maa ra cuan i catyi: Cuñi si sa tahndya ñɨɨ xiñi xuu tandɨhɨ ra quɨhvɨ cuenda ra Jesús ta nacatyi yo sihin ra vatyi tyaa tucu ra yahvi sii ley i saha ra Moisés. ");
INSERT INTO mihNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tacuan ta i titahan tandɨhɨ ra apóstol sihin ra ndyizo tyiño nu iyo ñiyɨvɨ sino iñi vatyi cua nacañi iñi ra ñaa sa cuñi si sa ndisa. ");
INSERT INTO mihNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Sa naha xaan natuhun ra ta i nduvita ra Pedro ta catyi ra: Yañi xaa, sito ndo vatyi sa iyo quɨvɨ i casi ra Ndyoo sii, sihin maa ndo vatyi cua nacatyi Tuhun Ndyoo sihin ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu vatyi cua coto ñu ta cua sino iñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ta maa ra Ndyoo, sito ra añima tandɨhɨ ñiyɨvɨ, ta zañaha ra sii yo vatyi cua quihin ra sii ñu vatyi saha ra Tatyi Ii sii ñu inuu ñi tañi saha ra sii maa yo. ");
INSERT INTO mihNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ta ña catyi ra Ndyoo sihin yo vatyi ña vaha maa ñu ta vaha xaan maa yo. Zanduvaha ra añima ñu vatyi sino iñi ñu sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Vityi caca iñi yo cuhva cuñi ra Ndyoo. Ña vaha sa cua cuhva yo tundoho sii ñiyɨvɨ sino iñi sii ra ta cua catyi yo vatyi cua zavaha ñu costumbre i saha ra Moisés. Sito yo vatyi ñá cuu cundyee iñi ñiyɨvɨ sahnu sii yo sa zavaha ñu tandɨhɨ sa catyi ra Moisés, ta sito yo vatyi ñá cundyee tucu iñi maa yo zavaha yo sii si. ");
INSERT INTO mihNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ña tacuan ta nduvaha añima yo. Sito yo vatyi nduvaha añima yo vatyi iyo xaan tumañi iñi sii ra Jesús. Ta ñahñi ca cuhva nduvaha añima ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Taxi ñi i nduu tandɨhɨ ñiyɨvɨ sa siñi ñu cuhva nacatyi ra Pablo ta ra Bernabé tandɨhɨ sa i cuu ta tandɨhɨ sa ndyityi i zavaha ra Ndyoo nu sahan ra nu iyo ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu. ");
INSERT INTO mihNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ta sa ndɨhɨ cahan ra ta i cahan ra Jacobo ta catyi ra: Tyizoho ndo, yañi xaa. ");
INSERT INTO mihNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Sa saha ra Simón Pedro cuenda yozo caa i quisaha ra Ndyoo zasino ra iñi inga ñiyɨvɨ vatyi sii maa ra Ndyoo cua cuu ñu vazu yɨvɨ ñiyɨvɨ hebreo cuu ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ta zuun ñi cuhva ya cuu cuhva i cahan Tuhun Ndyoo ta tyiemvu vatyi i tyaa minoo ra profeta cuhva cahan ra Ndyoo: ");
INSERT INTO mihNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Nu vasi quɨvɨ cua quisi ra Cristo vatyi cua cuhve tyiño sii ra. Quɨvɨ i sicoo ra rey David i zacahnu ñiyɨvɨ sii sa ndisa cuii. Zoco zuhva ñi quɨvɨ ta i zaña tucu ñu sii. Cuhva i zacahnu ñu sii, ta quɨvɨ ra David cua zacahnu tucu ñiyɨvɨ hebreo sii nu vasi quɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ta sa cuenda maa ñu hebreo ta tacuan tucu cua zavaha inga ñiyɨvɨ, ñu yɨvɨ ñiyɨvɨ hebreo cuu, ta cua sino iñi ñu sii. ");
INSERT INTO mihNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tacuan i catyi ra Ndyoo vatyi sa sito ra vatyi cua zavaha ra cuhva cuan cumañi ca sino ñuu ñiyɨvɨ. Ta yucuan cuenda i catyi ra tacuan. ");
INSERT INTO mihNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Tacuan ta zɨquɨ i catyi tucu ra Jacobo sihin ñiyɨvɨ: Sica iñi vatyi vaha ca ma cuhva yo tundoho sii ñiyɨvɨ, ñu yɨvɨ ñiyɨvɨ hebreo cuu tatu sa i zandoo ñu costumbre sahnu ñu ta ndyico ñu sii Ndyoo sa ndisa cuii. ");
INSERT INTO mihNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Vaha ca tatu cua tyaa yo minoo carta sii ñu ta catyi yo sihin ñu vatyi ma casi ñu sa saha ñiyɨvɨ sii zandu ta naquihin tucu ñu. Ta cua coo minoo rayɨɨ sihin minoo ñi ñaha ta minoo ñi ñaha sihin minoo ñi rayɨɨ. Ta inga cuhva cua cahan yo sihin ñu sa ma casi ñu coño quɨtɨ tatu ña sati vaha nɨñɨ tɨ ta ma casi ca ñu nɨñɨ quɨtɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Vatyi ndya ta tyiemvu xaan iyo ra tandɨhɨ ñuu, ra cahvi ley saha ra Moisés sisi vehe ñuhu hebreo. Tahan tahan vitya cahvi ra sii si quɨvɨ quitatu ñiyɨvɨ. Tacuan i catyi ra Jacobo. ");
INSERT INTO mihNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tacuan i cuu si, ta i catyi ra apóstol ta ra ndyizo tyiño nu iyo ñiyɨvɨ sino iñi ta tandɨhɨ inga ñiyɨvɨ sino iñi Tuhun Ndyoo yucuan vatyi cua tasi ra sii a uu, a uñi tahan ra tahan ra, cua cuhun ra ndya ñuu Antioquía sihin ra Pablo ta ra Bernabé. Ta i saha ra tyiño cuan sii ra Judas. Nañi tucu ra Barsabás ta sii ra Silas. Nduu tahan ra cuu ra ndyizo tyiño cahnu nu iyo ñiyɨvɨ sino iñi. ");
INSERT INTO mihNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ihya cuu sa catyi carta i tasi ra sihin ra ndya nu iyo ñiyɨvɨ sa yɨvɨ ñiyɨvɨ hebreo cuu ñuu Antioquía ta nu cu si Siria ta Cilicia. Catyi si: “Maa ndi cuu ra apóstol ta ra ndyizo tyiño nu iyo ñiyɨvɨ sino iñi ta sihin tandɨhɨ ñu sino iñi Tuhun Ndyoo ityi ya. Saha ndi minoo ndyoo nacucumi sii maa ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ñihi ndi tuhun vatyi sahan ñiyɨvɨ ñuu ya ndya ñuu ndo, ta yɨvɨ maa ndi saha tyiño sii ñu ta i zayanga ñu sii ndo vatyi catyi ñu sihin ndo vatyi cuñi si sa cahndya ndo ñɨɨ xiñi xuu tandɨhɨ rayɨɨ ta tyaa ndo yahvi ley ra Moisés. ");
INSERT INTO mihNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Yucuan cuenda sica iñi tandɨhɨ ndi vatyi cua tasi ndi sii zuhva ra iyo ihya vatyi cua cuhun ra nu ndyaa ndo sihin ra tahan yo, ra Bernabé ta ra Pablo, ra sa cuñi xaan ndi. ");
INSERT INTO mihNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Sa cuaha xaan saha cuñi cahñi ñiyɨvɨ sii ra sa cuenda tyiño ra Jesucristo. ");
INSERT INTO mihNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tacuan cuu. Ta yucuan cuenda i tava ndi tyiño sii ra Judas ta ra Silas vatyi cuhun ra ta nacatyi ra sihin ndo tandɨhɨ sa i tyaa ndi nuu carta ya. ");
INSERT INTO mihNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Vatyi sa ndu‑ɨɨn ndi sihin Tatyi Ii ta sica iñi ndi vatyi ma zavaha ndo cuaha xaan cuhva. Ihya ñi cuu cuhva ñiñi cua zavaha ndo: ");
INSERT INTO mihNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ma casi ndo sa saha ñiyɨvɨ sii zandu ta naquihin tucu ñu. Ma casi ndo nɨñɨ quɨtɨ, ta ma casi ndo coño quɨtɨ tatu ñá sati vaha nɨñɨ tɨ. Ta minoo ñi ñaha cua coo sii minoo rayɨɨ ta minoo ñi rayɨɨ sihin minoo ñaha. Tatu cua cucumi vaha ndo cuhva ya, vaha tacuan ñi.” ");
INSERT INTO mihNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tacuan i tyaa ra cuan nuu carta ta ra ndyizo tyiño cuan i quihin ra ityi cuahan ra ndya ñuu Antioquía. Ta yucuan i zatitahan ra sii tandɨhɨ ñiyɨvɨ sino iñi Tuhun Ndyoo. Ta i saha ra carta cuan sii ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ta sa cahvi ñu sii si, zɨɨ xaan i cuñi ñu vatyi vaha xaan cuu cuhva cahan si cuñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ta ra Judas ta ra Silas i cuu cahan ra profecía, ta i quisaha cahan ra, ta i tyindyee xaan ra sii ñiyɨvɨ ta zɨɨ xaan i cuñi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ta sa yaha zuhva quɨvɨ ta cua nanuhu tucu ra. Ta i catyi ñiyɨvɨ sino iñi Tuhun Ndyoo sihin ra: Ndyoo cua tyindyee sii ndo ityi cuahan ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Zoco i cuñi ra Silas sa ndoo ra. ");
INSERT INTO mihNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Tacuan tucu ra Pablo ta ra Bernabé i ndoo ra ñuu Antioquía. Maa ra cuan sihin cuaha ca ñiyɨvɨ sito Tuhun Ndyoo, i zacuaha ra sii ñiyɨvɨ ta i nacatyi ra Tuhun Ndyoo sihin ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","I yaha zuhva ca quɨvɨ ta zɨquɨ catyi ra Pablo sihin ra Bernabé: Coho tucu yo tandɨhɨ ñuu nu i sahan yo. Cua ndyehe yo sii ra tahan yo, tandɨhɨ ñiyɨvɨ i sino iñi Tuhun Ndyoo nu i nacatyi yo sihin ñu. Cua ndyehe yo yozo caa iyo ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","I cuñi ra Bernabé sa cuhun tucu ra Juan, ra sa nañi tucu Marcos sihin ra. ");
INSERT INTO mihNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Zoco i sica iñi ra Pablo vatyi vaha ca ma quihin ra sii ra vatyi ñá ndoo ra sa sahan ra sihin ra sa xihna ñi. Quɨvɨ cuan i zandoo ra Juan Marcos sii ra Pablo ta ra Bernabé nu cu si Panfilia ta i sinuhu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ña nacasi tahan sa cahan ra Bernabé sihin ra Pablo sa cuenda tyiño cuan. I cuxaan ra zuhva. Tacuan ta zɨquɨ i cuzɨɨn tahan ra. I quihin ra Bernabé sii ra Marcos ta i quɨhvɨ ra minoo barco ta cuahan ra nu cu si Chipre. ");
INSERT INTO mihNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ta i quihin ra Pablo sii ra Silas. Ta i sica ñiyɨvɨ tumañi iñi sii Ndyoo sa tyindyee ra sii ra Pablo inga saha. Ta zɨquɨ cuahan ra. ");
INSERT INTO mihNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","I yaha ra nu cu si Siria. I yaha ra Cilicia. Ta i saha ra tundyee iñi sii ñiyɨvɨ sino iñi Tuhun Ndyoo yucuan. ");
INSERT INTO mihNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","I saa ra Pablo ta ra Silas ndya ñuu Derbe ta ñuu Listra. Yucuan i nañihi ra sii minoo ra sino iñi. Nañi ra Timoteo. Ñiyɨvɨ hebreo cuu zɨhɨ ra ta sino iñi ña sii ra Jesús. Ta zutu ra, ra cahan zahan griego cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Vaha ñiyɨvɨ cuu ra Timoteo catyi ñiyɨvɨ sino iñi Tuhun Ndyoo ñuu Listra ta ñuu Iconio. ");
INSERT INTO mihNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","I cuñi ra Pablo sa cuhun ra Timoteo sihin ra. Zoco i quihin xihna ra sii ra ta i sahndya ra ñɨɨ xiñi xuu ra coto cahan xaan ñiyɨvɨ hebreo ñuu cuan vatyi sito ñu vatyi ra griego cuu zutu ra ta ña tuhva ra zavaha costumbre maa ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tacuan ta sahan ra tahan tahan ñuu. I nacatyi ra sihin ñiyɨvɨ tuhun i nacatyi ra apóstol ta ra ndyizo tyiño nu iyo ñiyɨvɨ sino iñi ñuu Jerusalén vatyi tacuan ta cua zacuenda ñu sii ñu cuhva i tyaa ra nuu carta cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tacuan ta sicoo ca tundyee iñi sii ñiyɨvɨ sino iñi Tuhun Ndyoo, ta vaha xaan ca sino iñi ñu sii ra Ndyoo ta tandɨhɨ quɨvɨ i ndutuu ca ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ñá saha Tatyi Ii sa nacatyi ra Pablo Tuhun Ndyoo sihin ñiyɨvɨ nu cu si Asia. Yucuan cuenda i yaha ñi ra ndya nu cu si Frigia ta Galacia. ");
INSERT INTO mihNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ta i saa ra nu cu si Misia. Ndya indyacuan cua cuhun ra ndya nu cu si Bitinia sica iñi ra, zoco ñá saha tucu Tatyi Ii sa cuhun ra yucuan. ");
INSERT INTO mihNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tacuan ta i yaha ra nu cu si Misia, ta i quɨhvɨ ra ñuu Troas sa cuu cuenda Misia. Ta Troas cuan ndyaa si yuhu tyañuhu. ");
INSERT INTO mihNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yucuan i tahan ra Pablo ñimahna ta sisi ñimahna i ndyehe ra sii minoo ra nu cu si Macedonia. Ta i sica ra cuan tumañi iñi sii ra Pablo ta catyi ra: “Quisun ndya Macedonia ta tyindyeun sii ndi.” ");
INSERT INTO mihNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ta sa yaha ndyehe ra Pablo ñimahna cuan ta yuhvi ra Lucas sihin ra Pablo ta inga ra i zanumi ndi sa cuhun ndi ndya Macedonia vatyi sito ndi vatyi sa tasi ra Ndyoo sii ndi sa cua nacatyi ndi tuhun ra indyacuan. ");
INSERT INTO mihNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","I quɨhvɨ ndi barco ñuu Troas ta sa ndoo ñi cuahan ndi ndya cuhva ndya saa ndi minoo ñuhu mahñu tyañuhu. Nañi si Samotracia ta inga quɨvɨ i saa ndi ñuu Neápolis. ");
INSERT INTO mihNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ndya indyacuan i quisaha sica ndi sihin saha ndi ndya ñuu Filipos. Cahnu xaan ñuu cuan. Ñahñi inga ca ñuu ñiñi ca iyo yucuan. Ndyaca ñaha ñiyɨvɨ romana sii si. Yucuan i ndoo ndi zuhva quɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Minoo quɨvɨ quitatu ñiyɨvɨ i quita ndi sata ñuu ndya nu iyo minoo yuu vatyi yucuan tuhva ñiyɨvɨ sahan ta sica tahvi ñu sii Ndyoo. Yucuan i sindyaa ndi ta i nacatyi ndi Tuhun Ndyoo sihin ñu zɨhɨ, ñu i titahan yucuan. ");
INSERT INTO mihNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Minoo ña nañi ña Lidia. Ñuu Tiatira cuu ñuu ña. Xico ña zahma vaha, zahma yuhva tixinda, vatyi yucuan cuu tyiño ña. Zacahnu ña sii ra Ndyoo cuhva zacahnu ñiyɨvɨ hebreo sii ra. I tyizoho ña sa cahan ra Pablo, ta i nuña ra Ndyoo sa siñi tuñi sii ña, ta i sino iñi ña sa catyi ra Pablo. ");
INSERT INTO mihNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Sicoo ndutya ña sihin ñiyɨvɨ sii ña, ta zɨquɨ i catyi ña: Sa sito ndo vatyi ndisa cuii sino iñi sii ra Jesús, yucuan cuenda cuhun ndo ta cua ndoo ndo zuhva quɨvɨ vehi. Catyi ña ta i zañiñi ña sii ndi ta cuahan ndi vehe ña. ");
INSERT INTO mihNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Minoo quɨvɨ sahan ndi nu sica tahvi ñiyɨvɨ sii Ndyoo ta tahan ndi sii minoo ña yoco. Ñoho tatyi cuihna sii ña, ta cuu nacatyi ña ñaa sa cua tahan ñiyɨvɨ nu cuahan quɨvɨ. Cuhva cuan i zahacanaa ña xuhun ta ñihi sitoho ña xuhun cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","I quisaha ndyico ña sii ra Pablo ta sii maa ndi ta i cana saa ña ta catyi ña: Ra ihya zavaha ra cuhva cuñi ra Ndyoo cahnu. Ta vasi nacatyi ra sihin ndo yozo caa cua cacu añima ndo ta ma cuhun ndo andyaya. Catyi ña. ");
INSERT INTO mihNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tacuan i zavaha ña cuaha xaan quɨvɨ cuhva ndya ñá cundyee ca iñi ra Pablo, ta zɨquɨ i nandyehe sata ra ta i catyi ra sihin tatyi cuihna cuan: Yuhvi catyi vatyi quiton añima ña ya vatyi iyo tundyee iñi sii ra Jesús. Catyi ra. Ta zuun ñi caa cuhva cuan i quita tatyi cuihna añima ña. ");
INSERT INTO mihNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ta sa sito sitoho ña vatyi ma ñihi ca ra xuhun sihin ña vatyi sa i quita tatyi cuihna añima ña ta i tɨɨn ra sii ra Pablo ta ra Silas ta sindyaca ra sii ra ndya vehe tyiño. ");
INSERT INTO mihNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","I sindyaca sitoho ña sii ra nuu ra juez ta catyi ra sihin ra juez: Ra ihya zatɨvɨ tyiño ñuu yo ta ñiyɨvɨ hebreo cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Zacuaha ra costumbre sa ma cuu sino iñi yo ta ma cuu zavaha yo vatyi ñiyɨvɨ romano cuu yo. Tacuan i catyi ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tacuan ta i tyaa tandɨhɨ ñiyɨvɨ cuatyi sata ra Pablo ta ra Silas. Ta i tava ra cu tyiño tyiño sa quita zahma ra Pablo ta ra Silas. Ta i catyi ra sihin ra policía: Cañi vaha vaha ndo sii ra sihin yutu. ");
INSERT INTO mihNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ta sa yaha cañi xaan ra sii ra ta i tyihi ra sii ra vehe caa ta catyi ra sihin ra cumi vehe caa vatyi nacucumi vaha xaan ra sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ta sa ñihi ra cumi vehe caa cuan tuhun cuan ta i tyihi ra sii ra vehe nu cutu ca, ta i tyihi ra saha ra sisi vitu. ");
INSERT INTO mihNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tañi cuhva maa ñuu sata ra Pablo ta ra Silas yaa Ndyoo ta sica tahvi ra sii Ndyoo ta i tyizoho inga ra ñoho si vehe caa cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ta ta sica cuii ñi i taan minoo sa ñihi xaan. Ñihi xaan i quɨzɨ si vehe caa cuan. Ta zuun ñi caa cuhva cuan i nuña tandɨhɨ yuvehe ta i ndasi cadena sa nuhñi ra ñoho vehe caa cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","I natahvi iñi ra cumi vehe caa cuan. Ta ndyehe ra vatyi nuña tandɨhɨ yuvehe, ta sica iñi ra vatyi sa sino tandɨhɨ ra ñoho si vehe cuan. Yucuan cuenda i tava ra mityi ra ta cua cahñi ra zuun ñi sii maa ra. ");
INSERT INTO mihNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Zoco i catyi ra Pablo: Ma cahñun suun. Ñoho tandɨhɨ ndi ihya. ");
INSERT INTO mihNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","I sica ra cumi vehe caa cuan ñúhu ta i cacono ra sisi vehe cuan. Nɨhɨ tacuan ñi ca ra vatyi yuhu xaan ra. I sicuɨñɨ sɨtɨ ra nuu ra Pablo ta ra Silas. ");
INSERT INTO mihNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ta zɨquɨ i tava ra sii ra ta i ndaca tuhun ra sii ra: ¿Ñaa sa cuñi si zavehi, tata, ta cua cacu añime? ");
INSERT INTO mihNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ta i catyi ra Pablo sihin ra: Sino iñun sii ra Jesús, ta cua cacun, yoho ta tandɨhɨ ñiyɨvɨ suun. ");
INSERT INTO mihNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tacuan ta zɨquɨ i nacatyi ra Pablo Tuhun Ndyoo sihin ra ta sihin tandɨhɨ ñiyɨvɨ vehe ra. ");
INSERT INTO mihNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ta zuun ñi sa cuaa cuan i nacatya ra cumi vehe caa cuan nu ñicuehe nduu tahan ra. Ta i sicoo ndutya ra cumi vehe caa cuan sihin tandɨhɨ ñiyɨvɨ sii ra. ");
INSERT INTO mihNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tacuan ta i quihin ra sii ra Pablo ta cuahan ra sihin ra ndya vehe ra, ta saha ra sa casi ra. Ta zɨɨ xaan i cuñi ra ta ñiyɨvɨ sii ra vatyi sa sino iñi ñu sii ra Jesús. (Tacuan ta zɨquɨ i nandɨhvɨ tucu ra Pablo ta ra Silas vehe caa cuan coto cuxaan ra cu tyiño sihin ra cumi vehe caa.) ");
INSERT INTO mihNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ta inga quɨvɨ sa ñaha ñi i tasi ra juez sii ra policía ta catyi ra sihin ra cumi vehe caa: Zaña ndo sii ra cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ta tacuan i catyi ra cumi vehe caa cuan sihin ra Pablo vatyi sa cuu quita ra sihin ra Silas. ");
INSERT INTO mihNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Zoco i catyi ra Pablo: Ra ñuu Roma cuu nduhvi. Ta ñahñi cuhva iyo sii ra ihya sa cañi ra sii ndi nuu ñiyɨvɨ ta tyihi ra sii ndi vehe caa. Ta ñá saha ra sa cahan ndi ta nu sa ñá cutuñi ndi. Ta vityi cuñi ra sa cua zaña xehe ra sii ndi. Ña tacuan cuu si. Nacatyi ndo sihin ra juez vatyi naquisi tava maa ra sii ndi ta cua cuhun ndi. Tacuan i catyi ra Pablo. ");
INSERT INTO mihNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ta tacuan i nacatyi ra policía sihin ra juez. Ta i yuhu ra juez sa ñihi ra tuhun vatyi ra ñuu Roma cuu ra Pablo ta ra Silas. ");
INSERT INTO mihNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Yucuan cuenda sahan ra nu ñoho ra Pablo sihin ra Silas ta i sica ra tumañi iñi sii ra sa ma cuxaan ra, ta zɨquɨ i tava ra sii ra, ta i catyi ra sihin ra vatyi sa ndyoo ñi naquita ra ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ta sa quita ra Pablo ta ra Silas vehe caa ta cuahan ra vehe ña Lidia. Ta i ndyehe ra sii inga ñiyɨvɨ sino iñi Tuhun Ndyoo ta saha ra tundyee iñi sii ñu ta zɨquɨ i quita ra ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","I yaha ra Pablo ta ra Silas ñuu Anfípolis ta ñuu Apolonia ta cuahan ra minoo ñuu cahnu. Nañi si Tesalónica. Yucuan iyo minoo vehe ñuhu hebreo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ta tañi sa tuhva ra Pablo sahan, tacuan i sahan ra yucuan. Uñi quɨvɨ, quɨvɨ quitatu ñiyɨvɨ, i zacuaha ra sii ñiyɨvɨ cuhva catyi Tuhun Ndyoo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Tyehen i catyi ra: I catyi Tuhun Ndyoo vatyi cua ndyehe ra Cristo tundoho. Cua cuu ra, ta zɨquɨ cua nandoto tucu ra. Yuhvi catyi vatyi ra Jesús cuu ra cu Cristo vatyi tacuan i tahan si sii ra. Ta cua zacacu ra sii ñiyɨvɨ nu iyo ñu ndyehe tundoho. Tacuan i catyi ra Pablo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ta ñiyɨvɨ i tyizoho, cuaha ñu i sino iñi. Ta cuaha ca ra, ra griego cuu ra. Ta sa sino iñi ra cuhva zacuaha ñiyɨvɨ hebreo. Ta inga ñu cuu ñu ñazɨhɨ ra cuca ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tacuan ta sa ndyehe ra hebreo, ra ña sino iñi, vatyi sino xaan iñi ñiyɨvɨ ta i cucuihna iñi ra sa cuenda si. I quihin ra sii minoo ityi ra sica noo ñi, ra ña zatyiño, ta ra yucuan i zatitahan sii ñiyɨvɨ, ta i zanduvaa ra sii ñu. Sahan ra vehe ra Jasón sa nanducu ra sii ra Pablo vatyi cua cundyaca ra sii ra nu yucu tandɨhɨ ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Zoco ñá nañihi ra sii ra. Tacuan ta zɨquɨ i xita cañoho ra sii ra Jasón ta sii zuhva ca ra sino iñi nuu ra cu tyiño. Ta i cana saa ra ta catyi ra: Ra ihya zayanga sii ñiyɨvɨ nacahnu ñuu ñiyɨvɨ ta vityi vasi zayanga ra sii ñiyɨvɨ ñuu yo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","I saha ra Jasón ya sa cundyaa ra cuan vehe ra. Catyi ra ya vatyi ra Jesús cuu ra cu rey ta yɨvɨ ra César. Cuatyi cuu si sa tacuan vatyi ra César cuu rey sii maa yo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tacuan i cahan ra cuñi cuatyi cuan cuhva ndya zanduvaa xaan ra sii ñiyɨvɨ sihin ra cu tyiño. ");
INSERT INTO mihNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Zoco i saha ra Jasón ta inga ra zuhva xuhun, ta i quita ica ra. ");
INSERT INTO mihNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Zuun ñi sa cuaa cuan i zanumi ra sino iñi Tuhun Ndyoo sii ra Pablo ta ra Silas ta cuahan ra ndya ñuu Berea. Ta cuhva sa saa ra yucuan, i sahan ra vehe ñuhu hebreo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ñiyɨvɨ hebreo ñuu cuan vaha ca ñiyɨvɨ cuu ñu. Ñá zavaha ñu cuhva i zavaha ñiyɨvɨ hebreo ñuu Tesalónica. Cuñi xaan ñiyɨvɨ ñuu Berea sa tyizoho ñu Tuhun Ndyoo. Ta tandɨhɨ quɨvɨ i cahvi ñu Tuhun Ndyoo vatyi cuñi ñu coto ñu tatu ndisa sa cahan ra Pablo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Yucuan cuenda i sino iñi cuaha xaan ra hebreo, ta cuaha ñuzɨhɨ griego, ñu ñiñi. ");
INSERT INTO mihNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Zoco sa ñihi ñiyɨvɨ hebreo ñuu Tesalónica tuhun vatyi zacuaha ra Pablo Tuhun Ndyoo ñuu Berea ta zɨquɨ sahan ra cua zanduvaa ra sii ñiyɨvɨ ñuu Berea ta cua cahñi ñu sii ra Pablo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Yatyi xaan i tasi ñiyɨvɨ sino iñi Tuhun Ndyoo sii ra Pablo ndya yuhu tyañuhu. Ta i ndoo ra Silas ta ra Timoteo ñuu Berea. ");
INSERT INTO mihNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Cuahan uu tahan ñiyɨvɨ sihin ra Pablo. Sindyaca ra sii ra ndya ñuu Atenas. Ta zɨquɨ i tasi ra Pablo tyiño sihin ra sa nacatyi ra sihin ra Silas ta ra Timoteo vatyi zanumi ra ta cuhun ra nu iyo ra Pablo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","I ndatu ra Pablo ñuu Atenas ndya cua quisi ra Silas ta ra Timoteo. Ta sica xaan iñi ra Pablo vatyi ndyehe ra vatyi cuaha xaan zandu yutu iyo ñuu cuan. ");
INSERT INTO mihNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yucuan cuenda sahan ra vehe ñuhu vatyi cua natuhun ra sihin ñiyɨvɨ hebreo ta sihin inga ñiyɨvɨ sino iñi sii Ndyoo. Ta tandɨhɨ quɨvɨ i nacatyi ra sihin ñiyɨvɨ i ndyehe ra nuyahvi. ");
INSERT INTO mihNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ta zɨquɨ i natuhun tahan ñiyɨvɨ cuhva i cahan ra Pablo. Iyo ñu zacuaha ñu tuhun ra Epicúreo ta iyo ñu zacuaha ñu tuhun ñiyɨvɨ estoico. Ta zuhva ñu i catyi: ¿Ñaa tuhun cuu si sa nacatyi xaan ra ya vatyi cahan xaan ra tuhun inga ndyoo, ra ña sito yo? Tacuan i catyi ra cuan vatyi cahan ra Pablo tuhun ra Jesús ta cuhva i nandoto ra Jesús. ");
INSERT INTO mihNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tacuan ta zɨquɨ i sindyaca ñu sii ra Pablo ndya xiñi yucu Areópago nu titahan ra ndyizo tyiño ñuu cuan ta i catyi ra sihin ra Pablo: Cuñi ndi coto ndi ñaa tuhun cuu si sa zacuohon sii ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tucu xaan cuu tuhun nacatyun, ta cuñi ndi coto ndi ñaa sa cuu si. Tacuan i catyi ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Vatyi tandɨhɨ ñiyɨvɨ ñuu Atenas sihin ñiyɨvɨ inga ñuu, ñu iyo ñuu Atenas cuan, ñahñi tyiño zavaha ñu. Maa ñi sa tyizoho ñu ta sa nacatyi ñu ñaa cuhva saa iyo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tacuan i cuu ta zɨquɨ i nduvita ra Pablo mahñu nu yucu ra cuan xiñi yucu Areópago ta i catyi ra sihin ra ñuu Atenas cuan: Ndoho ra ñuu Atenas, ndyehi vatyi zacahnu xaan ndo ndyoo sii maa ndo sihin tandɨhɨ cuii añima ndo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Vatyi sehin sa ndyehi nu zacahnu ndo sii ndyoo ndo ta i ndyehi minoo altar ta ndyaa letra. Tyehen catyi si: “Cuenda ndyoo sa ña sito yo.” Zacahnu ndo sii ra vazu ña sito ndo sii ra. Ta vityi cua nacatyi sihin ndo yoo ra cuu ra. ");
INSERT INTO mihNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ndyoo, ra zavaha ñuu ñiyɨvɨ cuu ra. I zavaha ra tandɨhɨ sa iyo. Sitoho yutyi andɨvɨ ta ñuhu ñuu ñiyɨvɨ cuu sii ra. Ña iyo maa ra sisi vehe ñuhu zavaha ñiyɨvɨ. ");
INSERT INTO mihNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ña cuñi si sa cua tyindyee ñiyɨvɨ sii ra vatyi ñahñi sa cumañi sii ra vatyi zuun ñi maa ra saha tandɨhɨ sa iyo. Saha ra sa cundito yo. Saha ra sa coo tatyi yo. ");
INSERT INTO mihNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Minoo tuhun ñi ñiyɨvɨ i zavaha ra Ndyoo sa xihna ñi. Tacuan i cuu ta zɨquɨ i ndutuu ca ñiyɨvɨ ta i catyi ra Ndyoo vatyi cua coo ñiyɨvɨ nacahnu ñuu ñiyɨvɨ. I catyi maa ra ndyamaa cua coo sa zɨɨn zɨɨn tata ñiyɨvɨ ñuu ñiyɨvɨ, ta i saha ra ñaa ñuhu cua cuu sii ñu. Ta i catyi ra ñaa ñiyɨvɨ cua cundyaca ñaha sa zɨɨn zɨɨn ñuhu ta ama cua cundyaca ñaha ñu. ");
INSERT INTO mihNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tacuan i zavaha ra Ndyoo vatyi cua nanducu ñiyɨvɨ sii ra. Sica iñi ra vatyi ña yɨɨ ta cua nañihi ñu sii ra. Vatyi ña sica iyo ra sihin yo. ");
INSERT INTO mihNT_vpl V