﻿USE sofia;
DROP TABLE IF EXISTS sofia.migNT_vpl;
CREATE TABLE migNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES migNT_vpl WRITE;
INSERT INTO migNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ya̱'á kúu lista ndasa va̱i tata̱ Jesucristo, se̱'e David, se̱'e Abraham. ");
INSERT INTO migNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ni̱ sá'a‑de Isaac. Te Isaac ni̱ sá'a‑de Jacob. Te Jacob ni̱ sá'a‑de Judá jíín ñaní‑i. ");
INSERT INTO migNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Te Judá ni̱ sá'a‑de Fares jíín Zara ni̱ kaku chi̱i Tamar. Te Fares ni̱ sá'a‑de Esrom. Te Esrom ni̱ sá'a‑de Aram. ");
INSERT INTO migNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Te Aram ni̱ sá'a‑de Aminadab. Te Aminadab ni̱ sá'a‑de Naasón. Te Naasón ni̱ sá'a‑de Salmón. ");
INSERT INTO migNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Te Salmón ni̱ sá'a‑de Booz ni̱ kaku chi̱i Rahab. Te Booz ni̱ sá'a‑de Obed ni̱ kaku chi̱i Rut. Te Obed ni̱ sá'a‑de Isaí. ");
INSERT INTO migNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Te Isaí ni̱ sá'a‑de rey David. Te rey David ni̱ sá'a‑de Salomón ni̱ kaku chi̱i ña'an ní kuu ñasɨ́'ɨ́ Urías. ");
INSERT INTO migNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Te Salomón ni̱ sá'a‑de Roboam. Te Roboam ni̱ sá'a‑de Abías. Te Abías ni̱ sá'a‑de Asa. ");
INSERT INTO migNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Te Asa ni̱ sá'a‑de Josafat. Te Josafat ni̱ sá'a‑de Joram. Te Joram ni̱ sá'a‑de Uzías. ");
INSERT INTO migNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Te Uzías ni̱ sá'a‑de Jotam. Te Jotam ni̱ sá'a‑de Acaz. Te Acaz ni̱ sá'a‑de Ezequías. ");
INSERT INTO migNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Te Ezequías ni̱ sá'a‑de Manasés. Te Manasés ni̱ sá'a‑de Amón. Te Amón ni̱ sá'a‑de Josías. ");
INSERT INTO migNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Te Josías ni̱ sá'a‑de Jeconías jíín ñaní‑i, ná kua̱ngoyo fuerza‑i ñuu̱ Babilonia. ");
INSERT INTO migNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Te ni̱ kuu kɨvɨ̱ já kuángoyo fuerza‑i ñuu̱ Babilonia, te Jeconías ni̱ sá'a‑de Salatiel. Te Salatiel ni̱ sá'a‑de Zorobabel. ");
INSERT INTO migNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Te Zorobabel ni̱ sá'a‑de Abiud. Te Abiud ni̱ sá'a‑de Eliaquim. Te Eliaquim ni̱ sá'a‑de Azor. ");
INSERT INTO migNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Te Azor ni̱ sá'a‑de Sadoc. Te Sadoc ni̱ sá'a‑de Aquim. Te Aquim ni̱ sá'a‑de Eliud. ");
INSERT INTO migNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Te Eliud ni̱ sá'a‑de Eleazar. Te Eleazar ni̱ sá'a‑de Matán. Te Matán ni̱ sá'a‑de Jacob. ");
INSERT INTO migNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Te Jacob ni̱ sá'a‑de José, yii María, ña'an‑ún ni̱ skáku‑ña Jesús, I'a̱ nání Cristo. ");
INSERT INTO migNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Súan va̱i ta̱ká tata̱. Onde̱ Abraham te onde̱ David íó uxi̱ kuu̱n tatá. Te onde̱ David te onde̱ kua̱ngoyo fuerza‑i ñuu̱ Babilonia íó uxi̱ kuu̱n tatá. Te onde̱ kua̱ngoyo fuerza‑i ñuu̱ Babilonia te onde̱ ni̱ kaku Cristo, suni íó uxi̱ kuu̱n tatá. ");
INSERT INTO migNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Te kɨvɨ̱ ní kaku Jesucristo súan ni̱ i̱o. Náa̱‑ya̱, María, ja̱ á ni̱ kundaa̱ tu̱'un ja̱ tánda'a‑ñá jíín José, te onde̱ ná té ketá'a̱n‑ga̱‑ña jíín‑de, te ni̱ juku̱'un se̱'e‑ña ní sá'a Espíritu Santo. ");
INSERT INTO migNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Te José, yii‑ñá‑ún, ɨɨn cha̱a va̱'a kúu‑de. Te tú ní kuní‑de sándɨva̱'a‑de jíín‑ña, chi̱ sua kuní‑de xndóo sa̱'í‑de‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Te nini súan nákani ini̱‑de, te ni̱ chaa̱‑ni ɨɨn ndajá'a̱ máá Tatá nuu̱‑dé ni̱ ka'a̱n‑ya̱ jíín‑de jíín jáni: José, se̱'e David, ma̱ yú'ú‑ro̱ kuáka‑ró ñásɨ́'ɨ́‑ro̱ María, chi ja̱ ñú'un chi̱i‑ña jián, onde̱ nuu̱ máá Espíritu Santo va̱i. ");
INSERT INTO migNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Te skáku‑ña ɨ́ɨn se̱'e yíí. Te skúnání‑ró‑i Jesús. Chi̱ máá‑i, nama‑i ta̱ká ña̱yɨvɨ ká'i̱o kua̱chi, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Súan ni̱ kuu ta̱ká ya̱'á, náva̱'a ná skíkuu tu̱'un ni̱ ka'a̱n máá Tatá jíín cháa ni̱ jani tu̱'un‑ya̱: ");
INSERT INTO migNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Koo ɨɨn ña'an jáá. Te juku̱'un se̱'e‑ña. Te skáku‑ña ɨ́ɨn se̱'e yíí. Te kunání‑i Emmanuel (ja̱ kuní ka'a̱n: Jíín máá‑yó ndújíín Dios). Achí. ");
INSERT INTO migNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Te ni̱ nata'u̱ núu̱ José. Te ni̱ nduko̱o‑de. Te ni̱ sá'a‑de nátu̱'un ni̱ tá'ú tíñu ndajá'a̱ máá Tatá nuu̱‑dé. Te ni̱ jaka‑de ñasɨ́'ɨ́‑de. ");
INSERT INTO migNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Te tú ní kixí‑de jíín‑ña, onde̱ ni̱ kaku se̱'e yíí núú‑ña. Te ni̱ skúnání‑de‑i Jesús. ");
INSERT INTO migNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Te ni̱ kaku Jesús ini̱ ñuu̱ Belén ndañúu̱ Judea. Te kɨvɨ̱‑ún tá'ú tíñu rey Herodes. Yúan‑na te yaku̱ cha̱a ndíchí, ni̱ kikoyo‑de ichi nú kána ndika̱ndii. Te ni̱ ja̱koyo‑de ñuu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Te ni̱ kaka'a̱n‑de: Ndénu̱ kándee rey ña̱yɨvɨ judío ja̱ ní kaku. Chi ni̱ kajini̱‑ri̱ tiñu̱ú xíní‑i ja̱ ní kenda ichi núu̱ kána ndika̱ndii. Te va̱i koyo‑ri̱ ja̱ chíñú'ún‑rí‑i, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Te rey Herodes, ni̱ jini tu̱'un‑de tu̱'un‑ún. Te ni̱ yu̱'ú‑de, onde̱ jíín táká ña̱yɨvɨ ñúu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Te ni̱ na̱stútú‑de ta̱ká sutu̱ ñá'nu jíín táká cha̱a káchaa tutu̱ ini̱ ñuu̱. Te ni jika̱ tu̱'ún‑de cha̱a‑ún nú ndénu̱ káku Cristo. ");
INSERT INTO migNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Te máá cháa‑ún, ni̱ kakachi̱‑de nuu̱ rey: Ini̱ ñuu̱ Belén ndañúu̱ Judea, chi̱ nuu̱ tutú ja̱ ní chísó cháa ni̱ jani tu̱'un‑ya̱, yóso súan: ");
INSERT INTO migNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Te róó ñuu̱ Belén ndañúu̱ Judá, na̱ tú lúlí‑ga̱‑ro̱ núu̱ cháa kákuñá'nu ñuu̱ Judá, chi̱ ini̱‑ro̱ kénda ɨɨn I'a̱ tá'ú tíñu nuu̱‑yo̱. Te koto‑ya̱ ñáyɨvɨ ñúu̱‑ri̱ Israel, áchí tutu̱. ");
INSERT INTO migNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yúan‑na te Herodes, ni̱ kana sa̱'í‑de xini̱ cháa ndíchí‑ún. Te ni̱ ni'i̱n vá'a‑de tu̱'un ndé kɨvɨ̱ ní kenda tiñu̱ú xíní‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Te ni̱ tájí‑de cha̱a‑ún kája'a̱n‑de ñuu̱ Belén. Te ni̱ ka'a̱n rey: Kuángoyo‑ní yúan, te kaka̱ tu̱'ún vá'a‑ní sɨkɨ̱ súchí lúlí‑ún. Te ní ni̱ kajini̱‑ní nuu̱‑í, te kastu̱'ún‑ní nuu̱‑ná náva̱'a suni ná kíchi̱ñú'ún‑ná‑i, áchí rey. ");
INSERT INTO migNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Te súan ni̱ ka̱jini so̱'o‑de tu̱'un ni̱ ka'a̱n rey. Te kája'a̱n‑de. Te máá tíñu̱ú xíní já ní kajini̱‑de ichi núu̱ kána ndika̱ndii, yoxnúú‑tɨ́ nuu̱‑dé onde̱ ni̱ jaa̱‑tɨ̱ núu̱ kátúu súchí lúlí‑ún. Te yúan ni̱ jukuiñi̱‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Te nuu̱ ní kajini̱‑de tiñu̱ú xíní‑ún, te ni̱ ka̱kusɨɨ̱ xáa̱n iní‑de. ");
INSERT INTO migNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Te ni̱ kɨ̱vɨ koyo‑de ini̱ ve̱'e. Te ni̱ kajini̱‑de nuu̱ súchí lúlí‑ún jíín náa̱‑i María. Te ni̱ ka̱jukuiñi̱ jítɨ́‑de nuu̱‑í. Te ni̱ ka̱chiñú'ún‑de‑i. Te ni̱ ka̱juña‑de janu̱‑dé. Te ni̱ kasoko̱‑dé oro, jíín súsia ku̱tú, jíín súsia ua̱ nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Te ni̱ ka̱skóto ja̱ni‑de. Te ni̱ jini̱‑de ja̱ tú no'o̱n‑de nuu̱ Herodes. Yu̱án ɨngá ichi káno'o̱n‑de ñuu̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Te kája'a̱n‑de. Yúan‑na te ɨɨn ndajá'a̱ máá Tatá, ni̱ skóto‑ya̱ José nuu̱ kixí‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Nduko̱o, te ki'in‑ró súchí lúlí jián jíín náa̱‑i, te ki'i̱n‑ro̱ ondé ñuu̱ Egipto. Te kunchaa̱‑ro̱ yúan onde̱ kastu̱'ún‑rí nuu̱‑ro̱. Chi̱ a yani nandúkú Herodes su̱chí lúlí jián já ká'ni‑dé‑i. Achí. ");
INSERT INTO migNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Te José, ni̱ nata'u̱ núu̱‑dé. Te ni̱ nduko̱o‑de. Te ni̱ ki'in‑de su̱chí lúlí jíín náa̱‑i kája'a̱n ñúú‑de onde̱ ñuu̱ Egipto. ");
INSERT INTO migNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Te ni̱ ka̱ndee‑de yúan onde̱ ni̱ ji'i̱ Herodes. Te ni̱ skíkuu tu̱'un ni̱ ka'a̱n máá Tatá jíín cháa ni̱ jani tu̱'un‑ya̱: Onde̱ ñuu̱ Egipto ni̱ kana‑ri̱ Se̱'e‑ri̱ va̱i‑i, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yúan‑na te Herodes ja̱ ní jini̱‑de ja̱ súan ni̱ ka̱sákátá cháa ndíchí núu̱‑dé, te ni̱ kiti̱ xaa̱n iní‑de. Te ni̱ tájí‑de soldado kája'a̱n. Te ni̱ ka̱ja'ni táká su̱chí yíí lúlí úu̱ kuia̱ jíín já lúlí‑ga̱ ká'i̱o‑i ini̱ ñuu̱ Belén jíín táká ndañúu̱, nátu̱'un ni̱ ni'i̱n vá'a‑de tu̱'un kɨvɨ̱ ní ka'a̱n cha̱a ndíchí‑ún jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yu̱án ní skíkuu tu̱'un ni̱ ka'a̱n Jeremías cha̱a ni̱ jani tu̱'un Dios, chi ni̱ ka'a̱n‑de: ");
INSERT INTO migNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ini̱ ñuu̱ Ramá ni̱ jini so̱'o‑ri̱ ja̱ kánda'i̱ te kánde'e̱ kó'ó. Raquel, ndé'e̱‑ña já sé'e‑ña. Te tú kuní‑ña ndúsɨɨ̱ iní‑ña, chi ni̱ ndɨ'ɨ‑i, ni̱ ka̱naa. Achí. ");
INSERT INTO migNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Te vásá ní ji'i̱ rey Herodes. Te ɨɨn ndajá'a̱ máá Tatá, ni̱ skóto ja̱ni‑ya̱ José onde̱ nuu̱ kándee‑de ñuu̱ Egipto. ");
INSERT INTO migNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Nduko̱o, te ki'in‑ró súchí lúlí jián jíín náa̱‑i, te no'o̱n‑ro̱ ñúu̱ Israel kunchaa̱‑ro̱, chi̱ a ni̱ kaji'i̱ ja̱ kákuni̱ ka'ni súchí jián núú. Achí. ");
INSERT INTO migNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yúan‑na te ni̱ nduko̱o‑de. Te ni̱ ki'in‑de su̱chí lúlí‑ún jíín náa̱‑i. Te kua̱no'on‑dé ñuu̱ Israel. ");
INSERT INTO migNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Te ni̱ ni'i̱n‑dé tu̱'un ja̱ Arquelao tá'ú tíñu ini̱ ñuu̱ Judea, ni̱ jukuiñi̱‑de nuu̱ táa̱‑de Herodes. Te ni̱ yu̱'ú José ki'i̱n‑de yúan. Te Dios, ni̱ skóto ja̱ni‑ya̱ José. Yu̱án kuá'a̱n‑de ɨɨn ndañúu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Te ni̱ jaa̱‑de ɨɨn ñuu̱ nání Nazaret. Te yúan ni̱ kanchaa̱‑de. Te ni̱ skíkuu tu̱'un ni̱ kaka'a̱n cha̱a ni̱ ka̱jani tu̱'un Dios: Cha̱a ñuu̱ Nazaret kunání‑yá, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Te jíka kɨvɨ̱ ní chaa̱ Juan cha̱a skuánducha kándii̱‑de nuu̱ ñú'un té'é ndañúu̱ Judea. Te ni̱ jani‑de tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Te ni̱ ka'a̱n‑de: Nakani ini̱ jíná'an‑ró, chi̱ a yani koo ñuu̱ nátu̱'un andɨ́vɨ́, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Chi̱ sɨkɨ̱ cháa yá'a ni̱ ka'a̱n Isaías, cha̱a ni̱ jani tu̱'un Dios onde̱ sáá: Ɨɨn ndajá'a̱, kana jaa‑de onde̱ nuu̱ ñú'un té'é: Sátu̱'a‑ró íchi máá Jíto'o̱‑yo̱, te sándóó‑ró íchi‑yá. Achí. ");
INSERT INTO migNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Te sa'ma ní ñu̱'un Juan, ni̱ kuu ixi camello. Te ni̱ nu'ni̱ ɨɨn sánchi̱i ñii chíi‑de. Te ndeyu ní yee‑dé ni̱ kuu ndɨkuá'yú jíín ndúxi yoko̱. ");
INSERT INTO migNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yúan‑na te ña̱yɨvɨ ñúu̱ Jerusalén jíín táká ña̱yɨvɨ ñúu̱ Judea jíín táká ña̱yɨvɨ yúñúu̱ Jordán, ni̱ kenda koyo‑i nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Te ni̱ skuánducha‑dé‑i ini̱ yu̱cha Jordán. Te kánakani ndaa̱‑i kua̱chi‑i yúan. ");
INSERT INTO migNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Te ni̱ jini̱‑de ja̱ vái koyo kua'a̱ cháa fariseo jíín cháa saduceo nuu̱ skuánducha‑dé‑ún. Te ni̱ ka'a̱n‑de jíín: Se̱'e koo̱ kákuu‑ró. Ndéja̱ ní kastá'a̱n nuu̱‑ro̱ já kúnu‑ró kóto‑ró juicio ja̱ cháa̱. ");
INSERT INTO migNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Núsáá te sá'a‑ró tíñu ja̱ á ni̱ nakani ini̱‑ro̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Te ma̱ káni ini̱‑ro̱ ká'a̱n‑ro̱: Abraham kúu táa̱‑yo̱. Chi̱ ká'a̱n‑ri̱ jíín‑ró já kúu‑ni sá'a Dios ja̱ táká yuu̱ yá'a nduu se̱'e Abraham. ");
INSERT INTO migNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Te vina a kátúu tú'a hacha ja̱ xɨ́tɨ yúnu ondé yo'o. Te ta̱ká yunu já tú kúun nde'e̱ vá'a, xɨtɨ̱ te kɨ̱vɨ nuu̱ ñú'u̱n. ");
INSERT INTO migNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ko I'a̱ va̱i ichi yatá‑rí, ñá'nu‑ga̱ kúu‑ya̱ vásá rúu̱. Te tú kúñá'nu‑ri̱ kundiso‑ri̱ ndija̱n‑yá. Máá‑yá skuánducha‑yá róó jíín Espíritu Santo jíín ñú'u̱n. ");
INSERT INTO migNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Te tɨ́ɨn‑ya̱ pala chíxí'ú trigo. Te xndéché‑yá te nastútú‑yá trigo ndɨ̱vɨ ini̱ yaka̱‑ya̱. Te ka'mu‑ya̱ paja‑ún nuu̱ ñú'u̱n ja̱ má ndá'va̱ kutɨ‑gá, áchí Juan. ");
INSERT INTO migNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yúan‑na te ni̱ kenda Jesús ini̱ ñuu̱ Galilea. Te ni̱ chaa̱‑ya̱ yúcha Jordán nuu̱ Juan náva̱'a skuánducha‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ko Juan, tú ní kuní‑de, chi ni̱ ka'a̱n‑de jíín‑yá: Sua kánúú já skuánducha máá‑ní náá, naja̱ vái‑ní nuu̱‑ná núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ko ni̱ ka'a̱n Jesús jíín‑de: Vina te sá'a‑ró, chi̱ súan kánúú skíkuu‑yó táká tiñu va̱'a, áchí‑ya̱. Yúan‑na te vásá ní skuánducha‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Te nuu̱ ní kuu ni̱ janducha Jesús, te ni̱ nana‑ni‑ya̱ iní nducha. Te ni̱ nuña andɨ́vɨ́. Te ni̱ jini̱‑ya̱ Espíritu Dios júngava va̱i nátu̱'un paloma. Te ni̱ jinu̱ sɨkɨ̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Te ni̱ kenda ɨɨn tu̱'un ichi ándɨ́vɨ́ ní ka'a̱n: Ya̱'á kúu Se̱'e‑ri̱ ja̱ kúndá'ú ini̱‑ri̱‑i, te kúsɨɨ̱ iní‑ri̱ jíín‑i, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yúan‑na te ni̱ jaa̱ Jesús onde̱ nuu̱ ñú'un té'é ní sá'a Espíritu, náva̱'a koto nchaa̱ tá'an kui'na̱ jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Te uu̱ xiko ndúú, uu̱ xiko ñúú, ni̱ i̱o ndicha̱ ini̱‑ya̱. Yúan‑na te vásá ní ji'i̱‑ya̱ sóko. ");
INSERT INTO migNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Te ni̱ jaa̱ kui'na̱ ní jito nchaa̱ tá'an jíín‑yá. Te ni̱ ka'a̱n jíín‑yá: Te nú Se̱'e Dios kúu‑ró, te ka'a̱n jíín yúu̱ yá'a ná ndúu staa̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Te ni̱ ka'a̱n‑ya̱ jíín: Yóso núu̱ tutú: Nasu̱ máni máá stáa̱ kée cháa te kuchaku̱‑de, chi̱ suni kánúú tú'un ká'a̱n Dios, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yúan‑na te kui'na̱‑ún, kua'a̱n jíín‑yá máá ñúu̱ ii̱. Te yúan ni̱ kaa jíín‑yá xini̱ torre ve'e ii̱. ");
INSERT INTO migNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Te ni̱ ka'a̱n jíín‑yá: Nú Se̱'e Dios kúu‑ró, te súngava‑ró máá‑ró ondé nuu̱ ñú'un, chi̱ yóso núu̱ tutú: Tájí‑yá ndajá'a̱‑yá kii sɨkɨ̱‑ro̱, te kunu nchaa̱‑ya̱ róó náva̱'a tú stují‑ro̱ já'a̱‑ro̱ núu̱ yúu̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Te ni̱ ka'a̱n tuku Jesús jíín kuí'na̱‑ún: Suni yóso‑gá nuu̱ tutú: Ma̱ kóto nchaa̱‑ro̱ máá Tatá‑ro̱ Dios, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Te ɨnga̱ jínu ni̱ jaka kui'na̱‑ún‑ya̱ kuá'a̱n jíín‑yá xini̱ ɨ́ɨn yuku súkún xáa̱n. Te ni̱ stá'a̱n ta̱ká ñuu̱ luu nɨ́ɨ́ ñúyɨ́vɨ núu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Te ni̱ kachi̱ jíín‑yá: Ta̱ká ñuu̱ yá'a kua̱'a‑ri̱ nuu̱‑ro̱ nú jukuiñi̱ jítɨ́‑ró te chiñú'ún‑ró rúu̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yúan‑na te ni̱ kachi̱ Jesús jíín kuí'na̱‑ún: Satanás, kuxio kuá'án, chi̱ yóso núu̱ tutú: Chiñú'ún‑ró máá Tatá Dios máá‑ró, te nuu̱ máá ɨ́ɨn‑ni‑ya̱ kuátíñu‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yúan‑na te ni̱ kuxio kui'na̱‑ún kua'a̱n. Te ni̱ cha̱koyo ndajá'a̱ ándɨ́vɨ́ ní ka̱jatíñu nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Te nuu̱ ní jini tu̱'un Jesús ja̱ kándee Juan veka̱a, te kua̱no'on‑yá ñuu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Te ni̱ xndóo‑ya̱ ñúu̱ Nazaret. Te ni̱ jaa̱‑ya̱ ñúu̱ Capernaum. Te ñuu̱‑ún ncháá yani yu'u mar ma̱'ñú ñúu̱ Zabulón jíín ñúu̱ Neftalí. Te ni̱ kanchaa̱‑ya̱ yúan, ");
INSERT INTO migNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Náva̱'a ná skíkuu tu̱'un ni̱ ka'a̱n Isaías cha̱a ni̱ jani tu̱'un Dios: ");
INSERT INTO migNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ñuu̱ Zabulón jíín ñúu̱ Neftalí ichi núu̱ mar ɨnga̱ lado yu̱cha Jordán, kúu ñuu̱ Galilea ña̱yɨvɨ sɨ́ɨn nación. ");
INSERT INTO migNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Te ña̱yɨvɨ‑ún káxiu̱kú‑i ñu̱ñáa, te ni̱ kajini̱‑i ɨɨn luz ká'nu. Te ni̱ kundiji̱n nuu̱ ñáyɨvɨ kákuni̱ naa, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Onde̱ sáá ní kejá'á Jesús jáni‑ya̱ tú'un: Nakani ini̱ jíná'an‑ró, chi̱ a yani koo ñuu̱ nátu̱'un andɨ́vɨ́, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Te jíka Jesús yu'u mar Galilea kua'a̱n‑ya̱. Te ni̱ jini̱‑ya̱ núu̱ úu̱ tá'a̱n ñani̱, ɨɨn Simón ja̱ nání‑de Pedro, te ɨnga̱ Andrés ñani̱‑de. Te káskuíta ka'nu‑de ñunu‑dé ini̱ mar. Chi cha̱a kátɨɨn tiyáká kákuu‑de. ");
INSERT INTO migNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kundiki̱n ruu̱ kikoyo‑ró, te ná násá'a‑ri̱ róó cha̱a tɨɨn ña̱yɨvɨ, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yúan‑na te ni̱ ka̱xndóo‑ni‑de ñunu‑dé. Te ni̱ kandiki̱n‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Te ni̱ ja̱'a‑ya̱ yúan kua'a̱n‑ya̱. Te ni̱ jini̱‑ya̱ núu̱ úu̱‑ga̱ tá'a̱n ñani̱, Jacobo se̱'e Zebedeo, jíín ñaní‑de Juan. Te ká'i̱in‑de ini̱ barco jíín táa̱‑de Zebedeo, kánaku'ni̱‑de ñunu‑dé. Te ni̱ kana‑ya̱ xiní‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Te cha̱a‑ún, ni̱ ka̱xndóo‑ni‑de barco jíín táa̱‑de. Te ni̱ kandiki̱n‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Te ni̱ jika kuu Jesús nɨ́ɨ́ ñúu̱ Galilea, ni̱ stá'a̱n‑ya̱ tú'un ini̱ ve̱'e sinagoga máá‑de. Te jáni‑ya̱ tú'un ja̱ kóo ñuu̱ Dios. Te násáva̱'a‑ya̱ táká ña̱yɨvɨ káku'u̱ jíín táká nuu̱ ú'u̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Te ni̱ jicha̱ tu̱'un‑ya̱ kuá'a̱n nɨ́ɨ́ ñúu̱ Siria. Te nuu̱‑yá ni̱ ka̱kinchaka‑i ta̱ká ña̱yɨvɨ káku'u̱. Ña̱yɨvɨ káta'a̱n tɨnɨ̱ nuu̱ kué'e̱, jíín táká ña̱yɨvɨ káyaji ní'ni, jíín já tá'a̱n tachi̱ kíni, jíín já jí'i̱ yi̱'í, jíín já ndúyúnú, ndɨ'ɨ‑i, ni̱ nasáva̱'a‑ya̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Te kua'a̱ ñáyɨvɨ ñúu̱ Galilea, jíín ñúu̱ Decápolis jíín ñáyɨvɨ ñúu̱ Jerusalén, jíín ñúu̱ Judea, jíín ñúu̱ ɨnga̱ lado yu̱cha Jordán, ni̱ kandiki̱n‑i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Te ni̱ jini̱‑ya̱ núu̱ ñáyɨvɨ kuá'a̱. Te ni̱ kaa‑ya̱ kuá'a̱n‑ya̱ yúku. Te ni̱ jungo̱o‑ya̱. Te cha̱a káskuá'a jíín‑yá, ni̱ ja̱koyo‑de nuu̱‑yá yúan. ");
INSERT INTO migNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Te ni̱ stá'a̱n‑ya̱ tú'un yá'a nuu̱‑dé: ");
INSERT INTO migNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Xáán ndatu̱ ña̱yɨvɨ káta'a̱n ndá'ú ini̱ añú‑i, chi̱ kuu kɨ̱vɨ‑i ini̱ ñuu̱ Dios nátu̱'un andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Xáán ndatu̱ ña̱yɨvɨ kánde'e̱, chi̱ ndusɨɨ̱ iní‑i sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Xáán ndatu̱ ña̱yɨvɨ vítá ini̱, chi̱ ni'i̱n‑í nɨ́ɨ́ ñúyɨ́vɨ kúu ta'u̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Xáán ndatu̱ ña̱yɨvɨ kákuu xaa̱n iní‑i skíkuu‑i ta̱ká tiñu ndaa̱, chi̱ kuu ja̱ kákuni̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Xáán ndatu̱ ña̱yɨvɨ kákundá'ú ini̱ tá'an, chi̱ suni ni'i̱n‑í tu̱'un kundá'ú ini̱. ");
INSERT INTO migNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Xáán ndatu̱ ña̱yɨvɨ ndóo ini̱ añú‑i, chi̱ kuni̱‑i nuu̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Xáán ndatu̱ ña̱yɨvɨ kánasámani̱ tá'an, chi̱ kunání‑i se̱'e Dios. ");
INSERT INTO migNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Xáán ndatu̱ ña̱yɨvɨ kájika jínu sɨkɨ̱ já kásá'a‑i tiñu ndaa̱, chi̱ kuu kɨ̱vɨ‑i ini̱ ñuu̱ Dios nátu̱'un andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Xáán ndatu̱ máá‑ró jíná'an‑ró nú káka'a̱n ndɨva̱'a‑i jíín‑ró te káchindiki̱n‑i róó te kákaji̱‑i róó sɨkɨ̱ rúu̱ va̱sa tú kua̱chi‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sɨɨ̱ xáa̱n kóo ini̱‑ro̱, chi̱ ká'nu xaa̱n tá'u̱‑ro̱ íó onde̱ andɨ́vɨ́. Chi̱ súan ni̱ ka̱chindiki̱n‑i cha̱a ni̱ ka̱jani tu̱'un Dios ni̱ kikoyo xna'a̱n‑ga̱ vásá róó. ");
INSERT INTO migNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Máá‑ró kákuu nátu̱'un ñii̱ ñu̱yɨ́vɨ. Ko nú ñii̱‑ún ná náa xikó u'a̱, ndasa ndu'u'a̱ ɨnga̱ jínu. Tuká tiñu kutɨ, chi̱ sua kacha̱‑ro̱ kí'i̱n te kuañu̱‑i sɨkɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Máá‑ró kákuu nátu̱'un luz ñu̱yɨ́vɨ. Ɨɨn ñuu̱ kándee xini̱ yúku, ma̱ kúu kundee sa̱'í. ");
INSERT INTO migNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ni tú skuikín‑ro̱ ɨ́ɨn yitɨ te chindee‑ró kayú chi̱i nu̱ndóó, chi̱ sua kundii̱ nuu̱ candelero te stúu̱n nuu̱ já káxiu̱kú iní ve̱'e. ");
INSERT INTO migNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Súan stá'a̱n‑ro̱ luz máá‑ró núu̱ táká ña̱yɨvɨ, náva̱'a ná kuní‑i tiñu va̱'a kásá'a‑ró, te ná nákana jaa‑i máá Táa̱‑ro̱ já kánchaa̱‑ya̱ ondé andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ma̱ káni ini̱‑ro̱ jíná'an‑ró já vái‑ri̱ xnáa‑rí ley jíín cháa ni̱ ka̱jani tu̱'un Dios. Na̱ tú va̱i‑ri̱ xnáa‑rí chi̱ sua skíkuu‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Chi ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Onde̱ kɨvɨ̱ náa ándɨ́vɨ́ jíín ñúyɨ́vɨ, ni ɨɨn jota te ni ɨɨn punto ma̱ náa kútɨ núu̱ tutú ley onde̱ nú tú skíkuu ta̱ká tu̱'un ká'a̱n ley. ");
INSERT INTO migNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Te nú ɨɨn cha̱a tú jándatu̱‑de nuu̱ ɨ́ɨn tu̱'un tá'ú tíñu yá'a, va̱sa tu̱'un lúlí kúu, te nú stá'a̱n‑de nuu̱ sáva‑ga̱ ña̱yɨvɨ sá'a‑i súan, cha̱a‑ún kuu‑de nátu̱'un ɨɨn mozo lúlí iní ñuu̱ Dios nátu̱'un andɨ́vɨ́. Ko nú sua jándatu̱‑de te stá'a̱n‑de, yúan‑na te kuu‑de ɨɨn cha̱a kúñá'nu onde̱ ini̱ ñuu̱ Dios nátu̱'un andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chi̱ a ká'a̱n‑ri̱ jíín‑ró: Nú tú va̱'a‑ga̱ koo tiñu ndaa̱ kásá'a máá‑ró vásá tíñu kásá'a cha̱a káchaa tutu̱ jíín cháa fariseo, te ma̱ kɨ́vɨ kutɨ‑ro iní ñuu̱ Dios nátu̱'un andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","A ni̱ ka̱jini tu̱'un‑ró já ní ka'a̱n‑ya̱ jíín cháa aná'án: Ma̱ ká'ni‑ro ndɨ́yi, te na̱ni cha̱a nú ka'ni‑dé ndɨ̱yi, te ki'i̱n‑de nuu̱ justicia. ");
INSERT INTO migNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ko ruu̱, ká'a̱n‑ri̱ jíín‑ró: Nú ɨɨn cha̱a kití ini̱‑de nuu̱ ñaní‑de, ná kí'in‑de nuu̱ justicia. Te nú ɨɨn cha̱a ka'a̱n ndɨva̱'a‑de nuu̱ ñaní‑de, ná kí'i̱n‑de nuu̱ junta. Te nú ɨɨn cha̱a ka'a̱n‑de: Róó tasɨ̱, achi̱‑de, ná kí'i̱n‑de juicio infierno. ");
INSERT INTO migNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ko nú kándá'á‑ró já sokó‑ro̱ ní chaa̱‑ro̱ jíín núu̱ altar, te nú yúan ni̱ nuku̱'un ini̱‑ro̱ já jíto u'u̱ ñani̱‑ro̱ róó, ");
INSERT INTO migNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Te skéndo̱o‑ró já sokó‑ro̱‑ún nuu̱ altar yúan, te ki'i̱n‑ro̱ te ndumani̱‑ro̱ jíín ñaní‑ro̱ xna'a̱n‑ga̱. Yúan‑na te vásá cháa̱‑ro̱ te soko̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Yachi̱ ndatu̱'ún vá'a‑ró jíín cháa jíto u'u̱ róó nini ká'i̱in‑ró jíín‑de ichi. Chi̱ nú túu, te kua̱'a‑de róó nuu̱ juez. Te juez kua̱'a‑de róó nuu̱ policía, te kundee‑ró véka̱a. ");
INSERT INTO migNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Te ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró já má kénda kutɨ‑ro yúan, onde̱ nú tú chunáa‑ro táká centavo. ");
INSERT INTO migNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ni̱ ka̱jini tu̱'un‑ró já ní ka'a̱n‑ya̱ sáá: Ma̱ kúsɨ́kɨ ncháa̱ tá'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ko ruu̱, ká'a̱n‑ri̱ jíín‑ró, nú ndé'é ɨ́ɨn cha̱a nuu̱ ɨ́ɨn ña'an já kusú‑de jíín‑ña kuní‑de, yúan‑na te a ni̱ isɨ́kɨ ncháa̱ tá'an‑de jíín ñá'an‑ún ini̱ añú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Te nú nduchi‑ro lado vá'a‑ró kuní skɨ́vɨ róó nuu̱ íó kua̱chi, tava te skána‑ró ná kí'i̱n. Chi̱ va'a̱‑ga̱ ja̱ náa ɨ́ɨn nduchi‑ro, nasu̱ já kóo ndɨ'ɨ yikɨ kúñu‑ró kí'i̱n nuu̱ infierno. ");
INSERT INTO migNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te nú nda'a vá'a‑ró kuní skɨ́vɨ róó nuu̱ íó kua̱chi, xɨtɨ te skána‑ró ná kí'i̱n. Chi̱ va'a̱‑ga̱ ná náa ɨ́ɨn nda'a‑ro nasu̱ já kóo ndɨ'ɨ yikɨ kúñu‑ró kí'i̱n nuu̱ infierno. ");
INSERT INTO migNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Te suni onde̱ sáá ní ka'a̱n: nú ndéja̱ kuní xndóo ñasɨ́'ɨ́, te ná kuá'a tutu̱ ndúsɨ́ɨn nuu̱‑ñá. ");
INSERT INTO migNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ko ruu̱, ká'a̱n‑ri̱ jíín‑ró: nú xndóo ɨɨn cha̱a ñasɨ́'ɨ‑de, ko nasu̱ já tɨnɨ́ ini̱‑ña, yúan‑na te sá'a‑de ja̱ ísɨ́kɨ ncháa̱‑ña‑dé. Te nú ɨɨn cha̱a, nata̱nda'a‑dé jíín ñá'an‑ún, te ísɨ́kɨ ncháa̱‑de tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Te suni ni̱ jini so̱'o‑ró tú'un ni̱ ka'a̱n‑ya̱ jíín cháa aná'án: ma̱ ká'a̱n ni̱'in‑ró chi̱ skíkuu‑ró táká tu̱'un ni̱ kee yu'u‑ro núu̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ko ruu̱, ká'a̱n‑ri̱ jíín‑ró: Ma̱ ká'a̱n téyíí kútɨ‑ro, ni sɨkɨ̱ ándɨ́vɨ́, chi̱ silla Dios kúu. ");
INSERT INTO migNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni sɨkɨ̱ ñúyɨ́vɨ, chi̱ teyu̱ nuu̱ káxndíi ja'a̱‑yá kúu. Ni sɨkɨ̱ ñúu̱ Jerusalén, chi̱ ñuu̱ máá Rey ñá'nu kúu. ");
INSERT INTO migNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Te suni ma̱ ká'a̱n ni̱'in‑ró sɨkɨ́ xiní‑ro̱, chi ma̱ kúu sá'a kutɨ‑ro já ndúu kuíjín xí ndúu túún ɨɨn ixi‑ro. ");
INSERT INTO migNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ko ka'a̱n‑ro̱: Vee táa̱, túu táa̱, achi̱‑ro̱, chi̱ nú skáa‑ga̱‑ro̱ ká'a̱n‑ro̱, tu̱'un káñáá kúu. ");
INSERT INTO migNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ni̱ ka̱jini tu̱'un‑ró já ní ka'a̱n‑ya̱ jíín cháa aná'án: Nduchi jíín ndúchi, te nu̱'un jíín nú'un na̱kunáa, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ko ruu̱, ká'a̱n‑ri̱ jíín‑ró: Ma̱ kasú‑ro̱ núu̱ cháa ñáá. Chi̱ nú ndé cha̱a kuní‑de stují‑dé yikɨ núu̱‑ro̱ lado vá'a, te suni kua̱'a‑ró ɨngá lado ná stují‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Te nú ndé cha̱a kuní kana̱á jíín‑ró, te kuanchaa̱‑de sa'ma‑ro, te suni kuu kua̱'a‑ró tɨ́ka̱chí‑ró núu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Te nú ndé cha̱a skáka‑de róó ɨɨn kilómetro, te kaka‑ró úu̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Cha̱a jikán nuu̱‑ro̱, nuu̱‑dé kua̱'a‑ró. Te cha̱a kuní ki'in núu‑de nuu̱‑ro̱, ma̱ sásá'án‑ró kuá'a‑ró núu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ni̱ ka̱jini tu̱'un‑ró já ní ka'a̱n sáá: Kundá'ú ini̱‑ro̱ tá'an‑ró, te koto u'u̱‑ro̱ cháa jíto u'u̱ róó, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ko ruu̱, ká'a̱n‑ri̱ jíín‑ró: Kundá'ú ini̱‑ro̱ cháa kájito u'u̱ róó. Te ka'a̱n va̱'a‑ró jíín cháa káka'a̱n sɨkɨ̱‑ro̱. Te sá'a va̱'a‑ró jíín cháa kákiti̱ ini̱ nuu̱‑ro̱. Te kaka̱n ta'u̱‑ro̱ já'a̱ cháa ká'a̱n ndɨva̱'a jíín‑ró te káchindiki̱n róó. ");
INSERT INTO migNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Náva̱'a ná kúu‑ró sé'e máá Táa̱‑ro̱ já kánchaa̱‑ya̱ ándɨ́vɨ́, chi̱ máá‑yá já'a‑ya̱ ndíka̱ndii sɨkɨ́ ñáyɨvɨ ñáá jíín sɨkɨ́ ñáyɨvɨ vá'a. Te skúun‑ya̱ saú sɨkɨ́ ñáyɨvɨ kásá'a tiñu va̱'a jíín sɨkɨ́ ñáyɨvɨ kásá'a tiñu ñáá. ");
INSERT INTO migNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chi̱ nú mani̱‑ro̱ jíín cháa mani̱ jíín‑ró, na̱ún ní'i̱n‑ro̱. Á tú suni súan kásá'a cha̱a xíní. ");
INSERT INTO migNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te nú máni ñani̱‑ro̱ ká'a̱n luu‑ró jíín, te na̱ún sá'a‑ga̱‑ro̱ núsáá. Á tú suni súan kásá'a cha̱a sɨ́ɨn nación. ");
INSERT INTO migNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Núsáá te ná síyíja va̱'a‑ró máá‑ró jíná'an‑ró, nátu̱'un íó va̱'a máá Táa̱‑ro̱ kánchaa̱‑ya̱ ándɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Koto va̱'a‑ró máá‑ró. Ma̱ sá'a ndiji̱n‑ro̱ táká tiñu va̱'a‑ró náva̱'a nde̱'é ñáyɨvɨ núu̱‑ro̱, chi̱ nú súan te tú na̱ ta'u̱‑ro̱ kuá'a máá Táa̱‑ro̱ já kánchaa̱‑ya̱ ándɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Te nú sá'a‑ró caridad, ma̱ tɨvɨ́‑ro̱ corneta nátu̱'un cha̱a uu̱ xini̱ káxiu̱kú‑de ini̱ ve̱'e sinagoga jíín núyá'u. Chi̱ súan kásá'a‑de náva̱'a nakana jaa‑i‑de. Ko ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró já á ni̱ kani'i̱n‑dé ta'u̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ko nú sá'a‑ró caridad, ma̱ kuní nda'a vésé‑ró na̱ún sá'a nda'a vá'a‑ró, ");
INSERT INTO migNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Náva̱'a sá'a sa̱'í‑ro̱ caridad‑ún. Chi̱ máá Táa̱‑ro̱, jiní‑ya̱ já ní sá'a sa̱'í‑ro̱. Yúan‑na te ma̱'ñú táká ña̱yɨvɨ te kua̱'a‑ya̱ tá'u̱ kúu‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Te nú jikán ta'u̱‑ro̱, te ma̱ sá'a‑ró nátu̱'un cha̱a uu̱ xini̱. Chi̱ máá‑de, kákusɨɨ̱ iní‑de kaka̱n ta'u̱‑dé ini̱ ve̱'e sinagoga jíín jikí yá'ya náva̱'a ná kuní ña̱yɨvɨ núu̱‑dé. Ko ja̱ndáa̱ ká'a̱n‑rí jíín‑ró ja̱ á ni̱ kani'i̱n‑dé ya̱'u‑de. ");
INSERT INTO migNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ko róó nú jikán ta'u̱‑ro̱, ndɨ̱vɨ ini̱ ve̱'e‑ró te kasu̱‑ro̱ yúxé'é‑ró. Te kaka̱n ta'u̱‑ro̱ núu̱ máá Táa̱‑ro̱ já kánchaa̱ sa̱'í‑ya̱. Chi̱ máá Táa̱‑ro̱, jiní‑ya̱ já súan sá'a sa̱'í‑ro̱. Yúan‑na te ma̱'ñú táká ña̱yɨvɨ te kua̱'a‑ya̱ tá'u̱ kúu‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Te nú jikán ta'u̱‑ro̱, ma̱ kée xió kuiñí‑ro̱ ká'a̱n‑ro̱ nátu̱'un kásá'a cha̱a sɨ́ɨn nación, chi̱ kájani ini̱‑de ja̱ súan ná'án ká'a̱n‑de, te vásá jíni so̱'o‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Núsáá te ma̱ sá'a‑ró nátu̱'un kásá'a máá‑de. Chi̱ Táa̱‑ro̱, a jiní‑ya̱ na̱ún ndatíñu kánandɨ'ɨ‑ró ondé té cha'a̱n‑ga̱ kaka̱n‑ro̱ núu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Núsáá te sua kaka̱n ta'u̱ máá‑ró: Táa̱ máá‑ná ja̱ kánchaa̱‑ní onde̱ andɨ́vɨ́, ná nákana jaa‑ná níí jíín sɨ́'vɨ́‑ní. ");
INSERT INTO migNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Te ná kóo ñuu̱ nuu̱ tá'ú‑ní tiñu. Te ná kóo ta̱ká tiñu játa'a̱n ini̱ máá‑ní, nátu̱'un íó ini̱ andɨ́vɨ́ suni súan ná kóo ini̱ ñu̱yɨ́vɨ yá'a. ");
INSERT INTO migNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Staa̱ káyee‑ná ta̱ká kɨvɨ̱, kua̱'a‑ní nuu̱‑ná vina. ");
INSERT INTO migNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Te nátu̱'un kásá'a‑ná tu̱ká'nu ini̱‑ná nuu̱ ñáyɨvɨ kásá'a falta nuu̱‑ná, suni súan sá'a‑ní tu̱ká'nu ini̱‑ní nuu̱‑ná ja̱ sá'a‑ná falta nuu̱‑ní. ");
INSERT INTO migNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Te ma̱ skívɨ‑ní náá koto nchaa̱‑i náá, chi̱ sua nama‑ní náá nuu̱ kíni nuu̱ kuí'a̱. Chi̱ máá‑ní kúu I'a̱ tá'ú tíñu, te tɨ́ɨn‑ní fuerza, chi̱ kúñá'nu‑ní nɨ́ɨ́ káni. Súan ná kóo. Amén. Achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Chi̱ nú sá'a‑ró túká'nu ini̱ nuu̱ ñáyɨvɨ kásá'a falta jíín‑ró, te suni súan máá Táa̱‑ro̱ ondé andɨ́vɨ́ sá'a‑ya̱ túká'nu ini̱ nuu̱ falta máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ko nú tú sá'a‑ró túká'nu ini̱ nuu̱ ñáyɨvɨ kásá'a falta jíín‑ró, te suni súan máá Táa̱‑ro̱ ondé andɨ́vɨ́ ma̱ sá'a‑ya̱ túká'nu ini̱ nuu̱ falta‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ko nú ká'i̱o ndicha̱ ini̱‑ro̱, te ma̱ sá'a‑ró nátu̱'un kásá'a cha̱a uu̱ xini̱ já kájito xíí‑de. Chi̱ máá‑de kástují‑dé nuu̱‑dé náva̱'a stá'a̱n‑de máá‑de nuu̱ ñáyɨvɨ ja̱ ndichá ini̱‑de. Chi ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró já á ni̱ kani'i̱n‑dé ya̱'u‑de. ");
INSERT INTO migNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ko máá‑ró, nú ndicha̱ ini̱‑ro̱, te chi'i‑ró aceite xini̱‑ro̱ te nakɨtɨ nuu̱‑ro̱, ");
INSERT INTO migNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Náva̱'a tú stá'a̱n‑ro̱ máá‑ró núu̱ táká cha̱a ja̱ ndichá ini̱‑ro̱, chi̱ nuu̱ máá Táa̱‑ro̱ já kánchaa̱ sa̱'í‑ya̱ stá'a̱n‑ro̱ máá‑ró. Te máá Táa̱‑ro̱ já ndé'é sá'í‑ya̱, kua̱'a‑ya̱ yá'u‑ró kuni̱ ta̱ká ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ma̱ kayá‑ro̱ yají‑ro̱ iní ñu̱yɨ́vɨ yá'a, chi̱ chaa ti̱kixin te kana sɨ̱'ɨn yóó, te tɨ̱vɨ́. Te suni kuu kɨ̱vɨ ñakui̱'ná te sákuí'ná kí'i̱n jíín. ");
INSERT INTO migNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ko kaya̱‑ro̱ yají‑ro̱ ondé andɨ́vɨ́, chi̱ yúan ma̱ kúu chaa ti̱kɨxɨn te ni ma̱ kúu kana sɨ̱'ɨn yóó já stɨ́vɨ́. Te yúan ni ma̱ kúu kɨ̱vɨ ñakui̱'ná já sákuí'ná kí'i̱n jíín. ");
INSERT INTO migNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Chi̱ nuu̱ kándee yaji̱‑ro̱, yúan kúu nuu̱ kuítú iní‑ro̱ jíín. ");
INSERT INTO migNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lámpara yikɨ kúñu kúu nduchi. Te nú nduchi‑ro íó va̱'a, nɨ́ɨ́‑ni yikɨ kúñu‑ró ndíi ncháa̱. ");
INSERT INTO migNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ko nú nduchi‑ro káñáá, te nɨ́ɨ́‑ni yikɨ kúñu‑ró kándee ñu̱ñáa. Súan íó te nú luz ñáva̱'a‑ró kúu ñu'u̱n tu̱ún, na̱saa‑ga̱ ñu̱ñáa kóo núsáá. ");
INSERT INTO migNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ni ɨɨn mozo ma̱ kúu kuatíñu‑de nuu̱ úu̱ jito'o̱. Chi̱ kiti̱ ini̱‑de nuu̱ ɨ́ɨn te kumani̱‑dé jíín ɨngá, xí kuándatu̱‑de nuu̱ ɨ́ɨn te sani̱'in ini̱‑de nuu̱ ɨngá. Ma̱ kúu kuatíñu‑ró núu̱ Dios jíín núu̱ tú'un kúká. ");
INSERT INTO migNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Núsáá te ká'a̱n‑ri̱ jíín‑ró: Ma̱ nákani ini̱‑ro̱ sɨkɨ́ já kúchaku̱‑ro̱, nú ndasa kee‑ro, xí nú ndasa ko'o‑ró, ni sɨkɨ̱ yíkɨ kúñu‑ró, nú ndasa kundii kuna̱má‑ro̱. A tú kánúú‑gá vida‑ro̱ vásá já kée‑ro, te yikɨ kúñu‑ró vásá sá'ma‑ro náún. ");
INSERT INTO migNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nde̱'é‑ró tɨ́saa̱ andɨ́vɨ́ tú jítu‑tɨ̱, ni tú nástútú‑tɨ́, ni tú náchiva̱'a‑tɨ̱ iní yaka̱‑tɨ̱. Chi̱ máá Táa̱‑ro̱ ándɨ́vɨ́ skée‑yá‑tɨ̱. Á tú kánúú‑ga̱‑ro̱ vásá kɨ́tɨ‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ko ndé róó ja̱ súan nákani ini̱‑ro̱ te á kuu chísó‑ga̱‑ro̱ máá‑ró ɨ́ɨn yíkɨ́ náún. ");
INSERT INTO migNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Naja̱ kánakani ini̱‑ro̱ sɨkɨ́ sá'ma. Nde̱'é ndasa kája'nu ita̱ yuku. Tú sátiñu, ni tú táú. ");
INSERT INTO migNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ko ká'a̱n‑ri̱ jíín‑ró, ja̱ rey Salomón kɨvɨ̱ ní kuñá'nu xaa̱n‑dé, ni tú ní kúu ku'un‑de ɨɨn sa'ma súan nátu̱'un ita̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Te Dios, nú súan skúna̱má‑ya̱ itá yuku‑ún ja̱ íó vina te yuchaa̱n kayu̱ nuu̱ ñú'u̱n, naga̱ ni̱ kuu ja̱ má skúna̱má‑ya̱ róó te naja̱ tú kákandíja va̱'a‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Núsáá, te ma̱ nándɨ'ɨ ini̱‑ro̱, ndasa kee‑yo, xí ndása ku'un‑yó, achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Chi ña̱yɨvɨ sɨ́ɨn nación kándúkú táká ndatíñu jia̱n. Ko máá Táa̱‑ro̱ ondé andɨ́vɨ́, a jiní‑ya̱ já kánandɨ'ɨ‑ró táká ndatíñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ko kánúú‑gá ja̱ ndúkú ndéé‑ró kɨ́vɨ‑ró iní ñuu̱ nuu̱ tá'ú Dios tiñu. Te sá'a‑ró tíñu ndaa̱ nátu̱'un sá'a máá‑yá. Yúan‑na te kua̱'a‑ga̱‑ya̱ táká ndatíñu‑ún nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Núsáá te ma̱ nákani ini̱‑ro̱ já kúu yuchaa̱n, chi̱ yuchaa̱n te nakani ini̱‑ro̱ jíín túndó'o‑ún. Chi̱ vina kúu vina te yuchaa̱n kúu yuchaa̱n. ");
INSERT INTO migNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ma̱ náku̱xndíi‑ró sɨkɨ́ ñáyɨvɨ, náva̱'a ma̱ náku̱xndíi‑i sɨkɨ̱ máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chi̱ nátu̱'un náku̱xndíi‑ró sɨkɨ́ ñáyɨvɨ‑ún, suni súan naku̱xndíi‑i sɨkɨ̱ máá‑ró. Chi̱ jíín kú'a ja̱ káchikua̱'á‑ro̱, suni naku̱kua̱'á‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Te naja̱ ndé'é‑ró já kándee mi̱'ín ndúchi ñaní‑ro̱. A tú nákani ini̱‑ro̱ já ɨ́ɨn vitu̱ kándee nduchi máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Naja̱ ká'a̱n‑ro̱ jíín ñaní‑ro̱: Kundatu, ná táva‑rí mi̱'ín kándee nduchi‑ro, te tú nákani ini̱‑ro̱ já kándee ɨɨn vitu̱ ndúchi‑ro náún. ");
INSERT INTO migNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Cha̱a uu̱ xini̱, xna'a̱n‑ga̱ tava‑ro vitú kándee nduchi máá‑ró. Yúan‑na te kuu nde̱'é vá'a‑ró te tava‑ro mí'ín kándee nduchi ñaní‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ma̱ kuá'a‑ró ndátíñu ii̱ núu̱ tí'ina̱ jíná'an‑tɨ̱, ni ma̱ skána‑ró perla‑ro̱ núu̱ kɨnɨ jíná'an‑tɨ̱. Chi̱ nú súan te kuañu̱‑tɨ̱ sɨkɨ́, te naxíó káva‑tɨ̱ íchi núu̱‑ro̱ te chuxíní‑tɨ́ róó. ");
INSERT INTO migNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kaka̱n, te kua̱'a‑ya̱ núu̱‑ro̱. Ndúkú, te ni'i̱n‑ro̱. Ka'a̱n, te ná núña ve'e kɨ̱vɨ‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chi cha̱a jikán, te kíi nuu̱‑dé. Te cha̱a ndúkú, ní'i̱n‑dé. Te cha̱a ká'a̱n, te núña ve'e kɨ̱vɨ‑de. ");
INSERT INTO migNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ndé ɨɨn róó, nú se̱'e‑ró jikán‑i ɨɨn staa̱ núu̱‑ro̱, te kua̱'a‑ró ɨ́ɨn yuu̱ núu̱‑í náún. ");
INSERT INTO migNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Xí nú jikán‑i ɨɨn ti̱yáká te kua̱'a‑ró ɨ́ɨn koo̱ núu̱‑í náún. ");
INSERT INTO migNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Te nú róó, va̱sa cha̱a ñáá kákuu‑ró, te kájini̱‑ro̱ kuá'a‑ró ndátíñu va̱'a nuu̱ sé'e‑ró, naga̱ máá Táa̱‑ro̱ já kánchaa̱‑ya̱ ándɨ́vɨ́, ja̱ má kuá'a‑ya̱ ndátíñu va̱'a nuu̱ cháa jikán nuu̱‑yá núsáá. ");
INSERT INTO migNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Núsáá te ta̱ká tiñu ja̱ kuní‑ro̱ já sá'a ña̱yɨvɨ jíín‑ró, suni súan sá'a máá‑ró jíín‑i, chi̱ súan ká'a̱n tutu̱ ley jíín cháa ni̱ ka̱jani tu̱'un Dios. ");
INSERT INTO migNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kɨ̱vɨ koyo‑ró íchi yúxé'é túu̱, chi̱ jichá yuxé'é te ká'nu ichi já kuá'a̱n nuu̱ náa ñáyɨvɨ. Te kua'a̱‑í kɨ́vɨ koyo‑i kua'a̱n‑i ichi‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Chi̱ tuu̱ yuxé'é te lúlí‑ni ichi já kuá'a̱n nuu̱ ní'i̱n tá'u̱‑í kuchaku̱‑i. Te yaku̱‑ni‑i káni'i̱n‑í ichi‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Te koto‑ró máá‑ró núu̱ cháa kájani tu̱'un tú'ún já vái‑de nátu̱'un rɨɨ̱ jíto‑de, ko ichi iní‑de kándee yi'ɨ̱ kɨtɨ xáa̱n. ");
INSERT INTO migNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jíín tíñu kásá'a‑de te kuni̱‑ro̱‑dé. Á kuu táxín‑ró uva xini̱ nú íñú, xí kúu táxín‑ró mérkexe̱ xini̱ íñu kɨ́mɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Súan kúu, ja̱ táká yunu vá'a kúun nde'e̱ vá'a xini̱, ko yunu ñáá kúun nde'e̱ ñáá xini̱. ");
INSERT INTO migNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ɨɨn yunu vá'a ma̱ kúu kuun nde'e̱ káñáá xini̱. Te ni ɨɨn yunu káñáá, ma̱ kúu kuun nde'e̱ vá'a xini̱. ");
INSERT INTO migNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ta̱ká yunu tú kúun nde'e̱ vá'a xini̱, ná xɨtɨ́, te ná kí'i̱n nuu̱ ñú'u̱n kayu̱. ");
INSERT INTO migNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Núsáá te súan jíín ndé'e̱ kúun xini̱, te kuni̱‑ro̱ na̱ún yunu kúu. ");
INSERT INTO migNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nasu̱ ndɨ́'ɨ ña̱yɨvɨ ká'a̱n Táta̱, Táta̱, jíín‑rí, kɨ̱vɨ ini̱ ñuu̱ nátu̱'un andɨ́vɨ́. Chi̱ máni ña̱yɨvɨ skíkuu tiñu kuní máá Táa̱‑ri̱, I'a̱ kánchaa̱ andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kɨvɨ̱‑ún, te ka'a̱n kua'a̱ ñáyɨvɨ jíín‑rí: Táta̱, Táta̱, nasu̱ ní ka̱jani‑ná tu̱'un jíín sɨ́'vɨ́‑ní, te ni̱ ka̱kiñi'in‑ná tachi̱ kíni kája'a̱n ja̱ ní ka̱sá'a‑ná kua'a̱ tíñu ñá'nu jíín sɨ́'vɨ́ máá‑ní náún. Achi̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yúan‑na te ka'a̱n ni̱'in‑ri̱ jíín ñáyɨvɨ‑ún: Tú ní jiní kutɨ‑rí róó. Kuxio ki'i̱n‑ro̱, chi cha̱a kásá'a tiñu chá'án kákuu‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Te ta̱ká cha̱a jíni so̱'o tu̱'un ká'a̱n‑ri̱ yá'a te skíkuu‑de, te kuu‑de nátu̱'un ɨɨn cha̱a ndíchí. Te cha̱a‑ún, ni̱ jani‑de ɨɨn ve'e sɨkɨ̱ ɨ́ɨn kava. ");
INSERT INTO migNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Te ni̱ kuun sau̱, te ni̱ jinu̱ nducha ñú'ún, te ni̱ kee tachi̱ xáa̱n, te ni̱ ka̱kaja vé'e‑ún. Te tú ní nduá, chi̱ kándii̱ sɨkɨ̱ káva. ");
INSERT INTO migNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Te ta̱ká cha̱a jíni so̱'o tu̱'un ká'a̱n‑ri̱ yá'a, te tú skíkuu‑de, te kuu‑de nátu̱'un ɨɨn cha̱a xíní ñáá. Te cha̱a‑ún, ni̱ jani‑de ɨɨn ve'e nuu̱ ñítɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Te ni̱ kuun sau̱, te ni̱ jinu̱ nducha ñú'ún, te ni̱ kee tachi̱ xáa̱n, te ni̱ ka̱kaja vé'e‑ún. Te ni̱ ndua̱‑ni, te ni̱ naa íi̱, áchí‑ya̱ jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Te nuu̱ ní ji̱nu ni̱ ka'a̱n Jesús ta̱ká tu̱'un yá'a, te ta̱ká ña̱yɨvɨ kuá'a‑ún, ni̱ ka̱naa iní‑i kájini so̱'o‑i tu̱'un ni̱ stá'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Chi ni̱ stá'a̱n‑ya̱ núu̱‑í nátu̱'un cha̱a ndíso tíñu, nasu̱ nátu̱'un cha̱a káchaa tutu̱. ");
INSERT INTO migNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Te ni̱ nuu Jesús va̱i‑ya̱ yúku‑ún. Te ni̱ kandiki̱n kua'a̱ ñáyɨvɨ‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Te ɨɨn cha̱a té'yu̱ ndɨ̱'yi, ni̱ chaa̱‑de nuu̱‑yá. Te ni̱ chiñú'ún‑de‑ya̱, te ni̱ ka'a̱n‑de jíín‑yá: Táta̱, nú kuní‑ní, te kuu nasándoo‑ní náá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Te ni̱ skáa̱ Jesús nda'a‑yá. Te ni̱ ké'é‑yá‑de. Te ni̱ ka'a̱n‑ya̱: Kuní‑ri̱, ná ndúndoo‑ró, áchí‑ya̱. Te ndɨ̱'yi té'yu̱‑de‑ún ni̱ ndundoo‑ni. ");
INSERT INTO migNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yúan‑na te ni̱ kachi̱ Jesús jíín‑de: Ma̱ kachí kutɨ‑ro núu̱ ní ɨɨn‑i. Ko kuá'án, te stá'a̱n‑ro̱ máá‑ró núu̱ sutú. Te soko̱‑ro̱ núu̱‑dé nátu̱'un ni̱ tá'ú Moisés tiñu, náva̱'a kuni̱‑de ja̱ ní ndundoo‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Te ni̱ kɨ̱vɨ Jesús ñuu̱ Capernaum. Te ni̱ jaa̱ ɨɨn cha̱a kúu capitán nuu̱‑yá ká'a̱n nda̱'ú‑de jíín‑yá: ");
INSERT INTO migNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Táta̱, mozo‑ná kátúu‑í ve'e‑ná ni̱ kuyúnú‑i te ndó'o xaa̱n‑í, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Te ni̱ kachi̱ Jesús jíín‑de: Ki'i̱n máá‑rí te nasáva̱'a‑ri̱‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Te ni̱ ka'a̱n capitán jíín‑yá: Táta̱, nasu̱ cháa va̱'a kúu‑ná ja̱ kɨ́vɨ‑ní ini̱ ve̱'e‑ná, chi̱ ná ká'a̱n‑ni‑ní, te ná ndúva̱'a mozo‑ná. ");
INSERT INTO migNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Chi̱ máá‑ná, suni cha̱a ndíso tíñu kúu‑ná. Te ñáva̱'a‑ná soldado‑ná. Te ká'a̱n‑ná jíín ɨ́ɨn‑de: Kuá'án, te já'a̱n‑de. Te jíín ɨngá‑de: Ña'a̱n, te cháa̱‑de. Te jíín mozo‑ná: Sá'a ya̱'á, te sá'a‑i. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Te ni̱ jini so̱'o Jesús tu̱'un yá'a. Te ni̱ naa iní‑ya̱ ndé'é‑yá. Te ni̱ kachi̱‑ya̱ jíín ñáyɨvɨ káindiki̱n‑ya̱‑ún: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ ní ini̱ ñuu̱ Israel tú ní jiní‑ri̱ ni ɨɨn cha̱a kándíja súan. ");
INSERT INTO migNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Te ká'a̱n‑ri̱ jíín‑ró, ja̱ kíkoyo kua'a̱ ñáyɨvɨ íchi núu̱ kána ndika̱ndii jíín íchi núu̱ kée ndika̱ndii. Te jungo̱o‑i jíín Abraham, jíín Isaac, jíín Jacob onde̱ ini̱ ñuu̱ nátu̱'un andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ko ña̱yɨvɨ kákuu máá sé'e ñuu̱ nuu̱ tá'ú‑yá tiñu, kiñi'in‑ya̱‑í ki'i̱n‑i yata̱ ké'e nuu̱ ñáa. Te yúan nde'e̱‑i te nakaji‑í ñii yú'u‑í, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yúan‑na te ni̱ kachi̱ Jesús jíín cháa kúu capitán: Kuá'án. Nátu̱'un ni̱ kandíja‑ró, te kuni̱‑ro̱ já súan íó, áchí‑ya̱. Te mozo‑ún ni̱ nduva̱'a‑ni‑i hora‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Te ni̱ jaa̱ Jesús ve'e Pedro. Te ni̱ jini̱‑ya̱ náchi̱só‑de kátúu‑ñá yí'i ki̱ji‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Te ni̱ tɨɨn‑ya̱ ndá'a‑ñá. Te ni̱ kee ki̱ji‑ún‑ña. Te ni̱ nduko̱o‑ña. Te ni̱ jatíñu‑ña núu̱‑yá jíná'an‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Te nuu̱ ní ini, te nuu̱‑yá ni̱ cha̱koyo ja̱ kándi̱so ña̱yɨvɨ káta'a̱n tachi̱ kíni. Te jíín tú'un‑ni ká'a̱n‑ya̱, te ni̱ kiñi'in‑ya̱ tachí‑ún kája'a̱n. Te ni̱ nasáva̱'a‑ya̱ táká ña̱yɨvɨ káku'u̱. ");
INSERT INTO migNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Náva̱'a ná skíkuu tu̱'un ni̱ ka'a̱n Isaías cha̱a ni̱ jani tu̱'un Dios onde̱ sáá: Máá‑yá, ni̱ naki'in‑ya̱ kué'e̱‑yo̱, te ni̱ janchaa̱‑ya̱ já ndó'o‑yó, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Te ni̱ jini̱ Jesús ja̱ ní jíkó ndúu̱ kua'a̱ ñáyɨvɨ ká'i̱in‑i xiin‑yá. Te ni̱ tá'ú‑yá tiñu ja̱ ná já'a‑i ki'i̱n‑i ɨnga̱ lado. ");
INSERT INTO migNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Te nuu̱‑yá ni̱ jaa̱ ɨɨn cha̱a cháa tutu̱. Te ni̱ ka'a̱n‑de: Maestro, kundiki̱n‑ná níí va̱sa ndé onde̱ ki'i̱n‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Te Jesús ni̱ kachi̱‑ya̱ jíín‑de: Ta̱ká ñu̱kuii, ká'i̱o yau̱ kava káyi̱'i‑tɨ̱, jíín tɨ́saa̱ andɨ́vɨ́, ká'i̱o taka̱‑tɨ̱. Ko máá Sé'e cha̱a, túu nuu̱ kusú‑ya̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Te ɨnga̱ cha̱a skuá'a jíín‑yá, ni̱ ka'a̱n‑de jíín‑yá: Táta̱, kua̱'a‑ní tu̱'un ná kíchindu̱ji‑ná táa̱‑ná xna'a̱n‑ga̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Te ni̱ kachi̱ Jesús jíín‑de: Kundiki̱n ruu̱ ná kí'o̱n. Skéndo̱o ta̱ká ndɨ̱yi‑ún ná chíndu̱ji tá'an ndɨ̱yi jíná'an. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Te ni̱ kɨ̱vɨ‑ya̱ iní ɨɨn barco. Te cha̱a káskuá'a jíín‑yá, ni̱ kandiki̱n‑de‑ya̱ kája'a̱n‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Te nuu̱ mar ni̱ ndonda ɨɨn tachi̱ xáa̱n, te su'ma̱ ndúcha‑ún, ni̱ jasu̱ sɨkɨ̱ barco. Ko máá‑yá kixí‑ni‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Te cha̱a káskuá'a jíín‑yá, ni̱ ja̱koyo‑de nuu̱‑yá. Te ni̱ ka̱xndúko̱o‑de‑ya̱. Te káka'a̱n‑de: Táta̱, nama‑ní yóó, chi̱ naa‑yo, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Te ni̱ kachi̱‑ya̱ jíín‑de: Naja̱ káyu̱'ú‑ro̱. Tú kákandíja va̱'a‑ró náún, áchí‑ya̱. Yúan‑na te ni̱ nduko̱o‑ya̱. Te ni̱ ka'a̱n‑ya̱ núu̱ tachí xáa̱n‑ún jíín núu̱ ndúcha mar. Te ná'ín yúú‑ni ni̱ kuu. ");
INSERT INTO migNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Te ni̱ kayu̱'ú ta̱ká‑de. Te káka'a̱n‑de: Ndé cha̱a kúu cha̱a yá'a, ja̱ ondé tachi̱ jíín mar kájandatu̱ nuu̱‑dé, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Te ni̱ jaa̱‑ya̱ ɨngá lado mar ndañúu̱ Gadara. Te onde̱ ve'e añú ni̱ kenda uu̱ cha̱a káta'a̱n tachi̱ kíni. Te ni̱ cha̱koyo‑de nuu̱‑yá. Te ja̱ xáa̱n‑dé, te tú ni ɨɨn ña̱yɨvɨ jíka‑i ichi‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Te ni̱ ka̱kana jaa‑de: Na̱ún kuní‑ní jíín‑ná Jesús, Se̱'e Dios. Ni̱ chaa̱‑ní yá'a ja̱ xndó'o‑ní náá va̱sa té jaa̱‑ga̱ kɨvɨ̱ náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Te onde̱ jíká jíín máá‑de íó ɨɨn tɨku'ni̱ kɨnɨ̱ kájitu‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Te tachi̱ kíni‑ún, ni̱ kaka'a̱n nda̱'ú jíín‑yá: Nú kiñi'in‑ní náá, te tájí‑ní náá ná kɨ́vɨ koyo‑ná ini̱ tɨku'ni̱ kɨnɨ̱ ká'i̱in yúan, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Te ni̱ kachi̱‑ya̱ jíni jíná'an: Kuángoyo núsáá, áchí‑ya̱. Te ni̱ kenda kája'a̱n, te kua̱ngoyo nuu̱ tɨ́ku'ni̱ kɨnɨ̱‑ún. Te tɨku'ni̱ kɨnɨ̱‑ún ni̱ ka̱jungoyo‑tɨ̱ ɨ́ɨn yukáva onde̱ ini̱ mar. Te nuu̱ mar ni̱ kaji'i̱‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Te cha̱a kándi̱to‑tɨ̱ yúan, ni̱ ka̱jinu‑de. Te ni̱ ja̱koyo‑de onde̱ ñuu̱. Te ni̱ ka̱jani‑de ta̱ká tu̱'un jíín já ní kuu cha̱a ni̱ kata'a̱n tachi̱ kíni‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yúan‑na te ndivii ñáyɨvɨ ñúu̱‑ún, ni̱ kenda koyo‑i kuata'a̱n‑i Jesús. Te ni̱ kajini̱‑i nuu̱‑yá. Te ni̱ kaka'a̱n nda̱'ú‑i jíín‑yá ja̱ ná kúxio‑ya̱ kí'i̱n‑ya̱ ñúu̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yúan‑na te ni̱ kɨ̱vɨ‑ya̱ iní ɨɨn barco. Te ni̱ naja̱'a‑ya̱ kuá'a̱n‑ya̱ ɨngá lado mar. Te ni̱ najaa̱‑ya̱ ñúu̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Te nuu̱‑yá yúan ni̱ ka̱kinchaka‑i ɨɨn cha̱a ni̱ kuyúnú kátúu‑dé nuu̱ ɨ́ɨn ji̱to. Te ni̱ jini̱ Jesús ja̱ kákandíja‑de. Te ni̱ ka'a̱n‑ya̱ jíín cháa ni̱ kuyúnú‑ún: 'ijo, sándéé iní‑ro̱. A íó tu̱ká'nu ini̱ nuu̱ táká kua̱chi‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Te yaku̱ cha̱a káchaa tutu̱, ni̱ ka̱jani ini̱‑de: Cha̱a yá'a ká'a̱n ndɨva̱'a‑de. ");
INSERT INTO migNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Te ni̱ jini̱ Jesús ja̱ súan kájani ini̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Naja̱ kájani ñáá ini̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Te ja̱ úu̱ tu̱'un yá'a, ndéja̱ yíí‑ga̱ káa. Á ka'a̱n‑ri̱: A íó tu̱ká'nu ini̱ nuu̱ táká kua̱chi‑ró. Xí ká'a̱n‑ri̱: Nduko̱o, te kaka‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ko náva̱'a ná kuní‑ro̱ já máá Sé'e cha̱a ndíso‑ya̱ tíñu nuu̱ ñúyɨ́vɨ yá'a ja̱ sá'a‑ya̱ túká'nu ini̱ nuu̱ kuáchi, te ná ká'a̱n‑ri̱ ɨnga̱ tu̱'un jíín cháa ni̱ kuyúnú yá'a núsáá: Nduko̱o, te naki'in‑ró jíto yuu‑ro, te no'o̱n‑ro̱ vé'e‑ró, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yúan‑na te máá cháa‑ún, ni̱ nduko̱o‑ni‑de. Te kua̱no'on‑dé ve'e‑de. ");
INSERT INTO migNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Te kua'a̱ ñáyɨvɨ ká'i̱in‑ún, ni̱ kajini̱‑i ja̱ súan ni̱ sá'a‑ya̱. Te ni̱ kayu̱'ú‑i. Te ni̱ ka̱nakana jaa‑i Dios ja̱ súan ni̱ ja̱'a‑ya̱ fuerza nuu̱ ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Te Jesús, ni̱ ja̱'a‑ya̱ kuá'a̱n‑ya̱ yúan. Te ni̱ jini̱‑ya̱ núu̱ ɨ́ɨn cha̱a nání Mateo kánchaa̱‑de nuu̱ kútútú xú'ún ñúu̱. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kundiki̱n‑ro̱ rúu̱. Te ni̱ ndukuiñi̱‑de, te ni̱ ndiki̱n‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yúan‑na te ni̱ yee‑yá staa̱ iní ve̱'e‑de. Te suni kua'a̱ cháa xíní jíín cháa ká'i̱o kua̱chi, ni̱ ja̱koyo‑de. Te ni̱ ka̱yee‑dé staa̱ jíín Jesús jíín cháa káskuá'a jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Te ni̱ kajini̱ cha̱a fariseo. Te ni̱ kaka'a̱n‑de jíín cháa káskuá'a jíín‑yá: Naja̱ yée Maestro máá‑ró jíín cháa xíní jíín cháa ká'i̱o kua̱chi, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yúan‑na te ni̱ jini so̱'o Jesús. Te ni̱ ka'a̱n‑ya̱: Cha̱a ká'i̱o ndáján, tú kánandɨ'ɨ‑de cha̱a táná, chi cha̱a káku'u̱ kúu ja̱ kájinu ñú'ún yúán. ");
INSERT INTO migNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kuá'án jíná'an‑ró núsáá. Te skuá'a‑ró na̱ún tu̱'un kúu: Ná kúndá'ú ini̱ tá'an‑i kuní‑ri̱. Nasu̱ já sokó‑í nuu̱‑rí, áchí onde̱ sáá. Chi̱ tú va̱i‑ri̱ kana‑ri̱ xini̱ cháa ndaa̱, chi cha̱a ká'i̱o kua̱chi kána‑ri̱ xini̱ já ná nákani ini̱‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yúan‑na te nuu̱‑yá ni̱ ja̱koyo cha̱a káskuá'a jíín Juan. Te ni̱ kaka'a̱n‑de: Náá jíín cháa fariseo, ká'i̱o ndicha̱ ini̱‑ná. Te cha̱a káskuá'a jíín‑ní, naja̱ tú ká'i̱o ndicha̱ ini̱‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Te ni̱ ka'a̱n Jesús jíín‑de: Á kuu kondicha̱ ini̱ ña̱yɨvɨ ká'i̱in viko tánda'a, te nú nini kánchaa̱ yii jíín‑i. Ko chaa̱ ɨɨn kɨvɨ̱ já kúxio yii‑ún nuu̱‑í. Yúan‑na te kuu koo ndicha̱ ini̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tú ni ɨɨn nachu'un sa'ma jáá núu̱ sú'nu̱ tu̱'ú. Chi ja̱ ní nuku̱'un jáá‑ún ka'ncha̱‑ga̱ ja̱ tu̱'ú‑ún. Te ja̱ te̱'ndé‑ún, ví'í‑gá te'nde̱. ");
INSERT INTO migNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Te tú káchu'un ña̱yɨvɨ vino jáá iní ñii tú'ú. Chi̱ nú súan, te ndata̱ ñíi‑ún, te katɨ vino, te naa ñíi‑ún. Ko káchu'un‑i vino jáá iní ñii jáá. Yúan‑na te kendo̱o va̱'a ndendúú. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Te nini ká'a̱n‑ya̱ tú'un yá'a jíín‑de, te ɨɨn cha̱a kúñá'nu ni̱ jaa̱‑de nuu̱‑yá. Te ni̱ chiñú'ún‑de‑ya̱. Te ni̱ ka'a̱n‑de: Se̱sɨ́'ɨ́‑ná, sáá ní ji'i̱‑i. Ko ki'o̱n te xndée‑ní nda'a‑ní sɨkɨ̱‑í, te ná náchaku̱‑i. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Te ni̱ ndukuiñi̱ Jesús. Te ni̱ ndiki̱n‑ya̱‑dé, jíín cháa káskuá'a jíín‑yá kája'a̱n‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Te yúan ni̱ kenda ɨɨn ña'an kú'u̱‑ña já ní kuu uxi̱ uu̱ kuia̱ játɨ nɨñi̱‑ñá. Ni̱ jaa̱‑ña íchi yatá‑yá. Te ni̱ ké'é‑ña yúsá'ma‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Chi ni̱ ka'a̱n máá‑ña: Nú ná ké'é‑rí va̱sté sá'ma‑yá, te ka̱ku‑ri̱, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Te ni̱ xíó káva Jesús. Te ni̱ jini̱‑ya̱ núu̱‑ñá. Te ni̱ ka'a̱n‑ya̱: Sándéé iní‑ro̱, 'ija. Ni̱ kandíja‑ró te yu̱án ní ka̱ku‑ró. Achí‑ya̱. Te máá ñá'an‑ún, ni̱ nduva̱'a‑ni‑ña hora‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Te ni̱ jaa̱ Jesús ve'e cha̱a kúñá'nu‑ún. Te ni̱ jini̱‑ya̱ núu̱ cháa kátɨvɨ̱ xkuili jíín ñáyɨvɨ kuá'a̱ kákuvaa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Te ni̱ kachi̱‑ya̱ jíín‑i: Kuxio jíná'an‑ró, chi su̱chí sɨ́'ɨ́ yá'a tú ní jí'i̱‑i, chi̱ kixí‑ni‑i, áchí‑ya̱. Te ni̱ ka̱sákátá‑i nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Te ni̱ kiñi'in‑ya̱ ñáyɨvɨ kuá'a̱‑ún kua'a̱n‑i. Te ni̱ kɨ̱vɨ‑ya̱ iní ve̱'e. Te ni̱ tɨɨn‑ya̱ ndá'a súchí sɨ́'ɨ́‑ún. Te ni̱ nduko̱o‑ni‑i. ");
INSERT INTO migNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Te ni̱ jicha̱ tu̱'un‑ún kua'a̱n nɨ́ɨ́ ñúu̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Te ni̱ ja̱'a Jesús yúan, kua'a̱n‑ya̱. Te uu̱ tá'a̱n cha̱a kuáá, ni̱ ka̱ndiki̱n‑de‑ya̱, kákana kó'ó‑de xini̱‑yá: Se̱'e David, kundá'ú ini̱‑ní náá vii, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Te ni̱ najaa̱‑ya̱ vé'e. Te ni̱ cha̱koyo cha̱a kuáá‑ún nuu̱‑yá. Te ni̱ ka'a̱n Jesús jíín‑de: Á kákandíja‑ró já kúu sá'a‑ri̱, áchí‑ya̱. Kuu Táta̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yúan‑na te ni̱ xndée‑ya̱ ndá'a‑yá sɨkɨ̱ ndúchi‑dé. Te ni̱ ka'a̱n‑ya̱: Nátu̱'un ni̱ ka̱kandíja‑ró, súan ná kúu núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Te nduchi‑dé, ni̱ ka̱nanuña‑ni. Te Jesús, ni̱ ka'a̱n ni̱'in‑ya̱ jíín‑de: Nde̱'é vá'a‑ró já tú ni ɨɨn kuni tu̱'un, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ko máá‑de, ni̱ ka̱kenda‑de kája'a̱n‑de. Te ni̱ kajacha̱ xaa̱n‑dé tu̱'un‑ya̱ nɨ́ɨ́ ñúu̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Te nuu̱ ní kenda‑de kája'a̱n‑de, te ni̱ cha̱koyo ña̱yɨvɨ jíín ɨ́ɨn cha̱a ñí'ín tá'a̱n‑de tachi̱ kíni. ");
INSERT INTO migNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Te ni̱ kiñi'in‑ya̱ tachí kíni‑ún kua'a̱n. Te cha̱a ñí'ín‑ún, ni̱ naka'a̱n‑de. Te ña̱yɨvɨ kuá'a̱‑ún, ni̱ ka̱kee nuu̱‑í kánde̱'é‑i. Te ni̱ kaka'a̱n‑i: Ni tú kájini̱ kutɨ‑yo súan ini̱ ñuu̱ Israel, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ko cha̱a fariseo, ni̱ kaka'a̱n‑de: Jíín tachí kíni ñá'nu kiñi'in‑de tachi̱ kíni kája'a̱n, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Te ni̱ jika kuu Jesús ta̱ká ñuu̱ jíín táká rancho. Te suni ini̱ ve̱'e sinagoga ni̱ stá'a̱n‑ya̱ tú'un nuu̱‑í. Te ni̱ jani‑ya̱ tú'un va̱'a ndasa koo ñuu̱ nuu̱ tá'ú Dios tiñu. Te ni̱ nasáva̱'a‑ya̱ ñáyɨvɨ káku'u̱ na̱ni kue'e̱. ");
INSERT INTO migNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Te ni̱ jini̱‑ya̱ núu̱ ñáyɨvɨ‑ún. Te ni̱ kundá'ú ini̱‑ya̱‑í. Chi ni̱ kajicha̱ nu̱u‑i, te kákuxíí iní‑i nátu̱'un rɨɨ̱, kɨtɨ tú jito'o̱‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a jíín‑yá: Trigo ta'nu̱, ja̱ndáa̱ kúu ja̱ kuá'a̱ íó, ko cha̱a ka'nu̱, yaku̱‑ni‑de íó. ");
INSERT INTO migNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kaka̱n ta'u̱‑ro̱ núu̱ máá Tatá, I'a̱ xíin trigo núsáá, náva̱'a ná tájí‑yá cha̱a ka'nu̱ kikoyo‑de nuu̱ trigo‑ya̱. Achí Jesús. ");
INSERT INTO migNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yúan‑na te ni̱ kana‑ya̱ xiní ndɨ́'uxí uu̱ cha̱a káskuá'a jíín‑yá. Te ni̱ ja̱'a‑ya̱ fuerza ini̱‑de ja̱ kúndéé‑de jíín tachí kíni, náva̱'a kiñi'in‑de ki'i̱n fuera, te nasáva̱'a‑de ña̱yɨvɨ káku'u̱ ta̱ká nuu̱ kué'e̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Te ndɨ́'uxí uu̱ cha̱a apóstol súan kái̱nání‑de: Cha̱a ɨɨn kúu Simón (cha̱a‑ún, suni nání‑de Pedro) jíín ñaní‑de Andrés, te sava‑ga̱‑de: Jacobo, se̱'e Zebedeo, jíín ñaní‑de Juan, ");
INSERT INTO migNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, jíín Bartolomé; Tomás jíín Mateo, cha̱a xíní; Jacobo se̱'e Alfeo, jíín Lebeo, cha̱a ja̱ súni nání‑de Tadeo; ");
INSERT INTO migNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Te suni Simón ñuu̱ Caná, jíín Judas Iscariote, cha̱a ni̱ nastúu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Te ni̱ tájí Jesús uxi̱ uu̱ cha̱a yá'a kája'a̱n‑de. Te ni̱ tá'ú‑yá tiñu nuu̱‑dé: Ma̱ kíngoyo‑ró íchi ñáyɨvɨ sɨ́ɨn nación, ni ma̱ kɨ́vɨ koyo‑ró iní ñuu̱ Samaria. ");
INSERT INTO migNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xna'a̱n‑ga̱ ki'i̱n‑ro̱ iní ve̱'e Israel, nuu̱ rɨ́ɨ̱, kɨtɨ ní ka̱naa. ");
INSERT INTO migNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Te nú kua'a̱n‑ro̱ te kani‑ró tú'un: A yani koo ñuu̱ nátu̱'un andɨ́vɨ́, achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Te nasáva̱'a‑ró ñáyɨvɨ káku'u̱. Te sándoo‑ró já káte'yu̱. Naschakú‑ro̱ ndɨ́yi. Kiñi'in‑ró tachí kíni ki'i̱n. Chi ni̱ ni'i̱n sáni‑ró, te suni súan kua̱'a sáni‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ma̱ kúndiso‑ró xú'ún iní bolsa‑ro̱, ni oro, ni plata, ni xu̱'ún kuáchí. ");
INSERT INTO migNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni ñunu já kúu ichi, ni uu̱ su'nu̱ já kú'un‑ró, ni ndija̱n‑ro̱, ni vara. Chi cha̱a sátiñu, yúan ni'i̱n‑dé kee‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Te na̱ni ñuu̱ xí rancho nú ni̱ kɨ̱vɨ koyo‑ró, te yúan ndúkú‑ró ɨ́ɨn cha̱a va̱'a ini̱‑de ini̱ ñuu̱‑ún. Te kendo̱o‑ró yúan onde̱ kenda‑ró kí'i̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Te nuu̱ kɨ́vɨ‑ró vé'e‑ún, te ka'a̱n‑ro̱ ná sándéé iní ña̱yɨvɨ‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Te nú va̱'a ini̱ ña̱yɨvɨ‑ún, te tu̱'un ndéé ní ka'a̱n‑ro̱‑ún ná jáa̱ sɨkɨ̱‑í. Ko nú tú va̱'a ini̱‑i, te tu̱'un ndéé‑ún ná nájaa̱ nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Te nú íó ña̱yɨvɨ tú játá'ú róó, ni tú jíni ná'ín tú'un ká'a̱n‑ro̱, ná kénda koyo‑ró vé'e‑ún xí ñúu̱‑ún, te skóyo‑ró tɨ́kacha̱ iní ja'a̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ vítá‑ga̱ koo kua̱chi sɨkɨ̱ ñúu̱ Sodoma jíín ñúu̱ Gomorra kɨvɨ̱ kíi juicio, vásá sɨkɨ́ ñúu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kuni so̱'o chi̱ tájí‑rí róó ki'i̱n‑ro̱ nátu̱'un rɨɨ̱ ma̱'ñú yí'ɨ̱. Núsáá te koo ndíchí‑ró nátu̱'un koo̱, te koo vi̱tá ini̱‑ro̱ nátu̱'un paloma. ");
INSERT INTO migNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Te koto va̱'a‑ró máá‑ró núu̱ ñáyɨvɨ chi̱ nastúu‑i róó nuu̱ junta. Te ini̱ ve̱'e sinagoga‑i xndó'o‑i róó. ");
INSERT INTO migNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Te onde̱ nuu̱ gobernador jíín núu̱ rey kincha̱ka‑i róó ja̱ sɨkɨ́ rúu̱, náva̱'a kani ndaa̱‑ro̱ tú'un nuu̱‑dé jíín núu̱ cháa sɨ́ɨn nación. ");
INSERT INTO migNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ko nú ni̱ nastúu‑i róó, ma̱ nákani xaa̱n iní‑ro̱ ndasa ka'a̱n‑ro̱. Chi̱ suni máá hora‑ún te kua̱'a‑ya̱ tú'un nuu̱‑ro̱ ndasa ka'a̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Chi̱ nasu̱ máá‑ró kákuu ja̱ ká'a̱n, chi̱ Espíritu máá Táa̱‑ro̱ kúu ja̱ ká'a̱n jíín yú'u‑ro. ");
INSERT INTO migNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Te ñani̱ jíín ñaní nastúu tá'an ja̱ kúu̱, te táa̱ nastúu se̱'e. Te se̱'e‑ún ndonda sɨkɨ̱ táa̱, te ka'ni tá'an. ");
INSERT INTO migNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Te ndivii‑í, koto u'u̱‑i róó ja̱ sɨkɨ́ rúu̱. Ko cha̱a kundii̱ ni̱'in onde̱ kɨvɨ̱ jínu, cha̱a‑ún ka̱ku‑de. ");
INSERT INTO migNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ko nú káchindiki̱n‑i róó ini̱ ñuu̱ yá'a, te kunu‑ró kí'i̱n‑ro̱ ɨngá ñuu̱. Chi̱ ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ má kúyachi̱‑ro̱ káka kuu‑ró táká ñuu̱ Israel, onde̱ jaa̱ máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ɨɨn cha̱a skuá'a, nasu̱ ñá'nu‑ga̱ kúu‑de vásá maestro‑de. Ni cha̱a játíñu, nasu̱ ñá'nu‑ga̱ kúu‑de vásá jíto'o̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Cha̱a skuá'a, súan‑ni koo‑de, nátu̱'un maestro‑de, te cha̱a sátiñu, nátu̱'un jito'o̱‑de. Chi̱ nú máá cháa kúu táa̱‑ún ni̱ ka̱skúnání‑i‑de Beelzebú, naga̱ ni̱ kuu ja̱ má skúnání‑i se̱'e ja̱ íó ini̱ ve̱'e‑de núsáá. ");
INSERT INTO migNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Núsáá te ma̱ yú'ú‑ro̱‑í, chi̱ tú ni ɨɨn na̱ún yíndi'u̱, ja̱ má kénda ndiji̱n, ni tú ni ɨɨn ja̱ yísa̱'í, ja̱ má kuní‑ro̱ núu̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ja̱ ní ka'a̱n‑ri̱ jíín‑ró núñáa, kani ndiji̱n‑ro̱ tú'un. Te ja̱ ní jini tu̱'un‑ró, onde̱ xini̱ vé'e kundii̱‑ro̱ te kani‑ró tú'un. ");
INSERT INTO migNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Te ma̱ yú'ú‑ro̱ kóto‑ró ñáyɨvɨ já'ni yíkɨ kúñu‑yó, chi ma̱ kúu ka'ni‑í añú‑yo̱. Ko sua yu̱'ú‑ro̱ kóto‑ró já kúu xnáa ndúú añú‑yo̱ jíín yíkɨ kúñu‑yó núu̱ infierno. ");
INSERT INTO migNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tú kúya̱'u uu̱ tɨsaa̱ ja̱ ɨ́ɨn xu̱'ún náún. Te ni ɨɨn‑tɨ̱ tú júngava‑tɨ̱ núu̱ ñú'un, nú tú jiní máá Táa̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Chi̱ a ni̱ ka'u‑ya̱ ondé ta̱ká ixi xiní‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Núsáá te ma̱ yú'ú‑ro̱ jíná'an‑ró, chi̱ kánúú‑ga̱‑ro̱ vásá kuá'a̱ tɨ́saa̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ko nú ndé cha̱a jáni ndaa̱‑de tu̱'un‑ri̱ nuu̱ ñáyɨvɨ, suni súan nakani ndaa̱‑ri̱ tu̱'un‑de nuu̱ máá Táa̱‑ri̱ kánchaa̱‑ya̱ ándɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Te nú ndé cha̱a ské'ichi̱‑de ruu̱ nuu̱ ñáyɨvɨ, te suni súan ské'ichi̱‑ri̱‑de nuu̱ máá Táa̱‑ri̱ kánchaa̱‑ya̱ ándɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma̱ káni ini̱‑ro̱ jíná'an‑ró já vái‑ri̱ ja̱ kóo ná'ín‑ni ini̱ ñu̱yɨ́vɨ yá'a. Tú va̱i‑ri̱ ja̱ kóo súan, chi̱ sua yuchi̱ koo. ");
INSERT INTO migNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Chi va̱i‑ri̱ ja̱ skuátá'an‑ri̱ ta̱ká cha̱a jíín táa̱‑de, te se̱sɨ́'ɨ́ jíín náa̱‑i, te seja̱nú jíín náchi̱só‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Te ja̱ kóto u'u̱ cha̱a kúu ja̱ kóo ini̱ ve̱'e‑de. ");
INSERT INTO migNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nú ɨɨn cha̱a mani̱‑gá‑de jíín táa̱‑de xí jíín náa̱‑de vásá jíín‑rí, tú va̱'a cha̱a kúu‑de ja̱ kúndiki̱n‑de ruu̱. Te nú ɨɨn cha̱a mani̱‑gá‑de jíín sé'e yíí‑de, xí jíín sésɨ́'ɨ́‑de, tú va̱'a cha̱a kúu‑de ja̱ kúndiki̱n‑de ruu̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Te cha̱a tú kánda‑de jíín túndó'o kii sɨkɨ̱‑dé, te kundiki̱n‑de ruu̱ kii‑de, tú va̱'a cha̱a kúu‑de ja̱ kúndiki̱n‑de ruu̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Te cha̱a jítú iní‑de ka̱ku‑de chi̱i tu̱ndó'o kii sɨkɨ̱‑dé, te naa‑dé. Ko nú kuu̱ ɨɨn cha̱a ja̱ sɨkɨ́ rúu̱, te kuchaku̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Te ña̱yɨvɨ kuátá'ú róó jíná'an‑ró, ruu̱ kuatá'ú‑i. Te ña̱yɨvɨ kuátá'ú rúu̱, kuatá'ú‑i I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nú ndé ña̱yɨvɨ kuátá'ú ɨ́ɨn cha̱a jáni tu̱'un Dios, chi cha̱a jáni tu̱'un Dios kúu‑de, te máá‑i, ni'i̱n‑í ya̱'u cha̱a jáni tu̱'un Dios. Te nú ndé ña̱yɨvɨ kuátá'ú cháa ndaa̱, chi cha̱a ndaa̱ kúu‑de, te máá‑i, ni'i̱n‑í ya̱'u cha̱a ndaa̱. ");
INSERT INTO migNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Te nú ndé cha̱a kua̱'a‑de ɨɨn yajin ndúcha víjin ko'o ɨɨn su̱chí yá'a, chi su̱chí skuá'a kúu‑i, ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ja̱ má xnáa‑dé ya̱'u‑de. ");
INSERT INTO migNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Te súan ni̱ ji̱nu ni̱ tá'ú Jesús tiñu nuu̱ uxí uu̱ cha̱a káskuá'a jíín‑yá. Te ni̱ kenda‑ya̱ yúan kua'a̱n‑ya̱ já stá'a̱n‑ya̱, te kani‑ya̱ tú'un ini̱ ñuu̱ máá‑de jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Te kándee Juan ini̱ veka̱a. Te ni̱ jini tu̱'un‑de káka'a̱n‑i ta̱ká tiñu sá'a Jesús. Te ni̱ tájí‑de uu̱ tá'a̱n cha̱a káskuá'a jíín‑de ja̱ kaká tu̱'ún‑de‑ya̱: ");
INSERT INTO migNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Máá‑ní kúu cha̱a kii‑ún, xí kúndatu‑yó ɨngá‑de náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Te ni̱ ka'a̱n Jesús. Kuá'án te kastu̱'ún‑ró núu̱ Juan ta̱ká tu̱'un kájini so̱'o‑ró jíín tíñu kájini̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Cha̱a kuáá, kándundiji̱n nuu̱‑dé. Te cha̱a rengo, kánakaka‑de. Cha̱a té'yu̱ ndɨ̱'yi, kándundoo‑de. Te cha̱a só'ó, kánakuni so̱'o‑de. Te cha̱a ni̱ ji'i̱, kánachaku̱‑de sá'a‑ri̱. Te suni jáni‑ri̱ tu̱'un va̱'a Dios nuu̱ ñáyɨvɨ ndá'ú. ");
INSERT INTO migNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Te xáán ndatu̱ kúu cha̱a ja̱ tú náyu̱'ú‑de jíto‑de ruu̱, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Te káno'o̱n cha̱a‑ún. Te ni̱ kejá'á Jesús ká'a̱n‑ya̱ tú'un Juan nuu̱ ñáyɨvɨ‑ún: Naja̱ ní kenda‑ró ní kaja'a̱n‑ro̱ ondé nuu̱ ñú'un té'é. Ja̱ ndé'é‑ró ichá ja̱ kandá sá'a tachi̱ náún. ");
INSERT INTO migNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ko naja̱ ní kenda‑ró ní kaja'a̱n‑ro̱. Ja̱ ndé'é‑ró núu̱ ɨ́ɨn cha̱a ñú'un sa'ma ndúchá náún. Nde̱'é, cha̱a káñu̱'un sa'ma ndúchá, máni ini̱ ve̱'e rey káxiu̱kú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ko na̱ún ndé'é‑ró ní ka̱kenda‑ró. Ɨɨn cha̱a jáni tu̱'un Dios náún. Suni ká'a̱n‑ri̱ jíín‑ró, kúñá'nu‑ga̱ Juan vásá ɨ́ɨn cha̱a jáni tu̱'un Dios. ");
INSERT INTO migNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cha̱a yá'a kúu cha̱a yóso tú'un‑de nuu̱ tutú: Kuni so̱'o‑ró chi̱ tájí‑rí ndajá'a̱‑rí kuxnúú‑de jaa̱‑de. Te cha̱a‑ún sátu̱'a‑de ichi‑ro vásá jáa̱‑ro̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ iní ñu̱yɨ́vɨ yá'a tú íó ni ɨɨn cha̱a jáni tu̱'un Dios ja̱ kúñá'nu‑ga̱ máá‑de vásá Juan cha̱a skuánducha. Ko cha̱a lúlí‑ga̱ ini̱ ñuu̱ nátu̱'un andɨ́vɨ́, cha̱a‑ún kúñá'nu‑ga̱‑de vásá Juan. ");
INSERT INTO migNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Onde̱ kɨvɨ̱ ní kenda Juan cha̱a skuánducha, te onde̱ vina, te cha̱a ni̱'in nda'a, fuerza kákuni̱‑de kɨ̱vɨ‑de ini̱ ñuu̱ nátu̱'un andɨ́vɨ́, te tá'ú máá‑de tiñu yúan kákuni̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Chi̱ máá ley jíín táká cha̱a ni̱ ka̱jani tu̱'un Dios, ni̱ ka̱jani‑de tu̱'un yá'a onde̱ kɨvɨ̱ ní chaa̱ Juan. ");
INSERT INTO migNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Te nú kákuni̱‑ro̱ kuátá'ú‑ró tú'un, máá‑de kúu Elías cha̱a kii‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Cha̱a íó so̱'o kuni ná'ín, te ná kúni so̱'o‑de. ");
INSERT INTO migNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Na̱ún tu̱'un yátá skétá'an‑ri̱ jíín ñáyɨvɨ yá'a. Kákuu‑i nátu̱'un su̱chí lúlí káxiu̱kú núyá'u ja̱ súan kákana kó'ó‑i xini̱ tá'an‑i. ");
INSERT INTO migNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ni̱ ka̱xndé'e̱‑ri̱ xkuili nuu̱‑ro̱, te tú ní kájita já'á‑ró. Ni̱ kanda'i̱‑ri̱ nuu̱‑ro̱ te tú ní kándukuí'a̱ ini̱‑ro̱, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chi ni̱ kii Juan tú ní yée‑dé tú ní jí'i‑de. Te káka'a̱n‑ro̱: Tá'a̱n‑de tachi̱ kíni. ");
INSERT INTO migNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ko máá Sé'e cha̱a yée‑yá jí'i‑ya̱. Te káka'a̱n‑ro̱: Yá'a íó ɨɨn cha̱a yáji téyíí te jí'i xaa̱n‑dé vino; cha̱a jiní tá'an jíín cháa xíní jíín cháa ká'i̱o kua̱chi kúu‑de, áchí‑ro̱. Ko ɨɨn cha̱a ndíchí, máni tiñu ndíchí sá'a‑de, te súan kuni̱‑ro̱ jándáa̱ ndíchí‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yúan‑na te ni̱ kejá'á‑yá kána jíín‑yá nuu̱ táká ñuu̱ nuu̱ ní sá'a‑ya̱ kuá'a̱ tíñu ñá'nu, chi̱ tú ní nákani ini̱‑i jíná'an‑i. Te ni̱ ka'a̱n‑ya̱: ");
INSERT INTO migNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Naka̱ ndá'ú kuu róó ñuu̱ Corazín. Naka̱ ndá'ú kuu róó ñuu̱ Betsaida. Chi̱ nú ini̱ ñuu̱ Tiro jíín iní ñuu̱ Sidón ni̱ sá'a‑ri̱ tiñu ñá'nu ja̱ ní sá'a‑ri̱ nuu̱ máá‑ró núú, ɨnga̱ kɨvɨ̱ te a ni̱ ka̱nakani ini̱ ña̱yɨvɨ‑ún. Te ku'un‑i sa'ma ndáí te ku'u‑í yaa̱ núu̱‑í núú. ");
INSERT INTO migNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ko ká'a̱n‑ri̱ jíín‑ró, ja̱ vítá‑ga̱ koo kua̱chi sɨkɨ̱ ñúu̱ Tiro jíín ñúu̱ Sidón kɨvɨ̱ kíi juicio vásá sɨkɨ́ róó jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Te róó ñuu̱ Capernaum, a ni̱ kuñá'nu xaa̱n‑ro̱ náún. Ko onde̱ infierno najinu̱‑ro̱, chi̱ nú ini̱ ñuu̱ Sodoma ní sá'a‑ri̱ tiñu ñá'nu ja̱ ní sá'a‑ri̱ nuu̱‑ro̱ yá'a núú, te a ni̱ kendo̱o ñuu̱ yúan onde̱ vina núú. ");
INSERT INTO migNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ko ká'a̱n‑ri̱ jíín‑ró, ja̱ vítá‑ga̱ koo kua̱chi sɨkɨ̱ ñáyɨvɨ ñúu̱ Sodoma kɨvɨ̱ kíi juicio vásá sɨkɨ́‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Te suni kɨvɨ̱‑ún ni̱ ka'a̱n Jesús: Táa̱, Jito'o̱ andɨ́vɨ́ jíín ñúyɨ́vɨ kúu máá‑ní. Te ná kúta'u̱‑ná nuu̱‑ní ja̱ ní jasu̱‑ní ta̱ká tu̱'un yá'a nuu̱ cháa ndíchí jíín núu̱ cháa kájuku̱'un ini̱, te ni̱ stá'a̱n ndiji̱n‑ní nuu̱ cháa súchí iní jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chi̱ súan ni̱ jata'a̱n ini̱‑ní, Táa̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ta̱ká ndatíñu ni̱ ja̱'a Táa̱‑ri̱ nuu̱‑rí. Te tú ni ɨɨn‑i jiní‑i nuu̱ máá Sé'e, chi̱ máni máá Táa̱ jiní‑ya̱. Ni tú jiní ni ɨɨn‑i nuu̱ máá Táa̱, chi̱ máá Sé'e jiní‑ya̱, jíín núu̱ cháa ja̱ kuní máá Sé'e te stá'a̱n ndiji̱n‑ya̱ núu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ta̱ká róó ja̱ kásátiñu‑ró te kándi̱so‑ró já vée, ña'a̱n nuu̱‑rí jíná'an‑ró te xndéta̱tú‑ri̱ róó. ");
INSERT INTO migNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kundiso‑ró yugo‑ri̱ jíná'an‑ró, te skuá'a‑ró tú'un ká'a̱n‑ri̱ jíín‑ró, chi̱ I'a̱ ndá'ú jíín I'a̱ vi̱tá ini̱ añú kúu‑ri̱. Te ni'i̱n‑ro̱ núu̱ ndéta̱tú añú‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Chi̱ ñama̱‑ni yugo‑ri̱ te tú ve̱e carga‑ri̱ ja̱ kúndiso‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Te ɨɨn kɨvɨ̱ ndéta̱tú ni̱ ja̱'a Jesús kua'a̱n‑ya̱ ɨ́ɨn nuu̱ káa trigo. Te cha̱a káskuá'a jíín‑yá, káji'i̱‑de so̱ko. Te ni̱ ka̱kejá'á‑de kákachi‑de yoko káyee‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Te ni̱ kajini̱ cha̱a fariseo. Te ni̱ kaka'a̱n‑de jíín‑yá: Na̱ún kúu jia̱n, chi cha̱a káskuá'a jíín‑ró kásá'a‑de súan kɨvɨ̱ ndéta̱tú, te tú íó ley, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Te máá‑yá, ni̱ ka'a̱n‑ya̱ jíín‑de: Tú ní káka'u‑ró tutú ndasa ni̱ sá'a David náún. Chi̱ máá‑de jíín cháa ni̱ kaxiu̱kú jíín‑de, ni̱ kaji'i̱‑de so̱ko ɨɨn kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Te ni̱ kɨ̱vɨ‑de ini̱ ve̱'e Dios. Te ni̱ yee‑dé sta̱tilá káxiu̱kú ndijín, ja̱ tú íó ley kee‑dé, ni cha̱a ká'i̱in jíín‑de, chi̱ máá‑ni sutu̱ káyee núú. ");
INSERT INTO migNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Xí té ka'u‑ga̱‑ro̱ núu̱ tutú ley ndasa kásá'a sutu̱ ini̱ ve̱'e ii̱ kɨvɨ̱ ndéta̱tú, chi̱ tú káskíkuu máá‑de ley‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Chi̱ a ká'a̱n‑ri̱ jíín‑ró já ñá'nu‑ga̱ kúu ɨɨn cha̱a kándii̱ yá'a vásá já kúu máá vé'e ii̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ko nú a ni̱ kaju̱ku̱'un ini̱‑ro̱ tú'un yá'a: Kuní‑ga̱‑ri̱ já ná kúndá'ú ini̱ tá'an‑ró, nasu̱ já sokó‑ro̱ kɨ́tɨ núu̱‑rí, áchí, yúan‑na te ma̱ ndónda‑ró sɨkɨ́ cháa tú ká'i̱o kua̱chi núú. ");
INSERT INTO migNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Núsáá te máá Sé'e cha̱a, suni Jito'o̱ kɨvɨ̱ ndéta̱tú kúu‑ya̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Te ni̱ kenda‑ya̱ yúan. Te ni̱ jaa̱‑ya̱ iní ve̱'e sinagoga‑de jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Te yúan ni̱ i̱o ɨɨn cha̱a ni̱ ichi̱ káján ɨ́ɨn nda'a‑dé. Te ni̱ kajika̱ tu̱'ún‑de Jesús ja̱ ndúkú‑de kua̱chi sɨkɨ̱‑yá kákuni̱‑de, te ni̱ kaka'a̱n‑de: Á kuu sá'a‑yó taná kɨvɨ́ ndéta̱tú, xí túu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Te máá‑yá, ni̱ ka'a̱n‑ya̱ jíín‑de: Ndé róó ñáva̱'a‑ró ɨ́ɨn rɨɨ̱, te nú kɨtɨ‑ún jungava‑tɨ̱ iní ɨɨn tu̱nchi kɨvɨ̱ ndéta̱tú, te tú tɨɨn‑ró‑tɨ́ te natava‑ro‑tɨ́ náún. ");
INSERT INTO migNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Te xaa̱n‑gá ya'u ncháá ɨɨn cha̱a vásá ɨ́ɨn rɨɨ̱. Núsáá te íó va̱'a ja̱ vá'a sá'a‑yó kɨvɨ́ ndéta̱tú, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín cháa‑ún: Skáa̱ nda'a‑ro, áchí‑ya̱. Te ni̱ skáa̱‑de nda'a‑dé. Te ni̱ nduva̱'a ii̱‑ní nátu̱'un káa ɨnga̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ko cha̱a fariseo, ni̱ kenda‑de kája'a̱n‑de. Te ni̱ kanda̱tu̱'ún‑de ndasa ka'ni‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ko ni̱ jini̱ Jesús ja̱ súan kájani ini̱‑de. Te ni̱ kuxio‑ya̱ yúan kua'a̱n‑ya̱. Te kua'a̱ ñáyɨvɨ ní kandiki̱n‑i‑ya̱. Te ni̱ nasáva̱'a‑ya̱ ndívii‑í. ");
INSERT INTO migNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Te máá‑yá, ni̱ ka'a̱n xaa̱n‑yá jíín ñáyɨvɨ‑ún ja̱ ná tú stá'a̱n ndiji̱n‑i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Náva̱'a ná skíkuu tu̱'un ni̱ ka'a̱n Isaías, cha̱a ni̱ jani tu̱'un Dios: ");
INSERT INTO migNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yá'a íó mozo‑ri̱ ja̱ ní naka̱ji‑ri̱, áchí Dios, áchí Isaías, te mani̱‑rí jíín‑i. Te kúsɨɨ̱ iní‑ri̱ jíín‑i. Te kua̱'a‑ri̱ Espíritu‑ri̱ sɨkɨ̱‑í. Te kastu̱'ún‑i nuu̱ ñáyɨvɨ sɨ́ɨn nación ja̱ kíi juicio sɨkɨ̱ máá jíná'an. ");
INSERT INTO migNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ma̱ kútɨ́xɨ́n sé'e‑ri̱, ni ma̱ nákata̱‑i. Te ni ɨɨn ma̱ kúni tu̱'un ja̱ kána jíín‑i ini̱ ichi. ");
INSERT INTO migNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ma̱ ká'nu̱‑i ɨɨn nu̱kúá ní taxi̱n, ni ma̱ ndá'va̱‑i ɨɨn mecha kayú ñú'má, chi̱ onde̱ ná kúni̱'in tu̱'un ndaa̱ sá'a‑i. ");
INSERT INTO migNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Te kuñukuu ini̱ ña̱yɨvɨ sɨ́ɨn nación tiñu sá'a Se̱'e‑ri̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yúan‑na te nuu̱‑yá ni̱ ka̱kinchaka‑i ɨɨn cha̱a tá'a̱n tachi̱ kíni, ja̱ kuáá‑de te ñí'ín‑de. Te ni̱ nasáva̱'a‑ya̱‑dé. Te cha̱a kuáá ñí'ín‑ún, ni̱ naka'a̱n‑de te ni̱ nakuni̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Te ni̱ ka̱naa iní ta̱ká ña̱yɨvɨ‑ún kánde̱'é‑i. Te ni̱ kaka'a̱n‑i: Á se̱'e David kúu cha̱a yá'a náún, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ko cha̱a fariseo, ni̱ ka̱jini so̱'o‑de ja̱ súan ni̱ kaka'a̱n‑i. Te ni̱ kaka'a̱n‑de: Cha̱a yá'a, nú tú ndújíín‑de jíín Beelzebú, te ma̱ kúu kiñi'in‑de tachi̱ kíni ki'i̱n núú, chi̱ já kúñá'nu nuu̱ tachí kúu‑ún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ko Jesús, ni̱ jini̱‑ya̱ já súan kájani ini̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ta̱ká nación ja̱ sásɨ́ɨn máá te kánakua̱tá'an máá, naa. Te ta̱ká ñuu̱ xí vé'e ja̱ sásɨ́ɨn máá, te kánakua̱tá'an máá, ma̱ kúni̱'in. ");
INSERT INTO migNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Te nú Satanás sásɨ́ɨn máá, te kíñi'in máá já'a̱n, ndasa kuni̱'in ñuu̱ nuu̱ tá'ú tíñu máá núsáá. ");
INSERT INTO migNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Te nú ndújíín Beelzebub jíín‑rí ja̱ kíñi'in‑ri̱ tachi̱ kíni. Núsáá te se̱'e‑ró, ndé jíín kákiñi'in máá‑i tachi̱‑ún. Ja̱ yúán, máá‑i, ná náku̱xndíi‑i sɨkɨ̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ko nú jíín Espíritu Dios kíñi'in‑ri̱ tachi̱ kíni kája'a̱n, ja̱ndáa̱ kúu ja̱ núu̱‑ro̱ ní chaa̱ ñuu̱ nuu̱ tá'ú Dios tiñu núsáá. ");
INSERT INTO migNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Chi̱ ndasa kuu kɨ̱vɨ ɨɨn ña̱yɨvɨ iní ve̱'e cha̱a kándáján, te sákuí'ná‑i ndatíñu‑de, te nú tú xna'a̱n‑ga̱ ku'ni̱‑i‑de. Yúan‑na te kuu sákuí'ná‑i ndatíñu‑de. ");
INSERT INTO migNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nú ndé cha̱a tú ndújíín‑de jíín‑rí, te jíto u'u̱‑de ruu̱. Te cha̱a tú nástútú jíín‑rí, máni jachá‑de. ");
INSERT INTO migNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Súan ká'a̱n‑ri̱ jíín‑ró: Sɨkɨ̱ táká kua̱chi jíín táká tu̱'un ndɨva̱'a, sá'a‑ya̱ túká'nu ini̱. Ko tu̱'un ká'a̱n ndɨva̱'a sɨkɨ̱ Espíritu Santo, ma̱ sá'a kutɨ‑yá tu̱ká'nu ini̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Te nú ndé ɨɨn cha̱a ka'a̱n‑de sɨkɨ̱ máá Sé'e cha̱a, sá'a‑ya̱ túká'nu ini̱ nuu̱‑dé. Ko nú ndé ɨɨn cha̱a ka'a̱n‑de sɨkɨ̱ Espíritu Santo, ma̱ sá'a kutɨ‑yá tu̱ká'nu ini̱ nuu̱‑dé, ni kuia̱ yá'a, ni kuia̱ chaa̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kuu‑ró yúnu vá'a ja̱ vá'a nde'e̱, xí kúu‑ró yúnu káñáá, ja̱ ñáá nde'e̱. Chi̱ jíín ndé'e̱ te jiní‑yo̱ na̱ún yunu kúu. ");
INSERT INTO migNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Se̱'e koo̱ kákuu‑ró. Ndasa kuu ka'a̱n‑ro̱ tú'un va̱'a, te nú ña̱yɨvɨ ñáá kákuu‑ró. Chi tu̱'un ñú'un ini̱ añú cha̱a, máni tu̱'un‑ún ká'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Cha̱a va̱'a, sá'a‑de tiñu va̱'a, chi̱ íó va̱'a ini̱‑de. Te cha̱a ñáá, sá'a‑de tiñu ñáá, chi̱ káñáá ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ko ruu̱, ká'a̱n‑ri̱ jíín‑ró, ja̱ táká tu̱'un sáni káka'a̱n cha̱a, nakua̱'a‑de cuenta tu̱'un‑ún kɨvɨ̱ cháa̱ juicio. ");
INSERT INTO migNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chi̱ sɨkɨ̱ tú'un ká'a̱n‑ro̱, te kendo̱o va̱'a‑ró. Te suni sɨkɨ̱ tú'un ká'a̱n‑ro̱, te ta'nu̱ ndatu̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yúan‑na te yaku̱ cha̱a káchaa tutu̱ jíín cháa fariseo, ni̱ kaka'a̱n‑de jíín‑yá: Maestro, kákuni̱‑ná ja̱ sá'a‑ní ɨɨn tuni̱ nde̱'é‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ña̱yɨvɨ ñáá ja̱ káisɨ́kɨ ncháa̱‑i Dios, kájika̱n‑i tuni̱. Ko ma̱ kuá'a‑ri̱ nuu̱‑í, chi̱ tuni̱ Jonás, cha̱a ni̱ jani tu̱'un Dios, kúu ja̱ kuá'a‑ri̱ nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chi̱ nátu̱'un ni̱ kandee Jonás chi̱i ti̱yáká ká'nu uni̱ ndúú uni̱ ñúú, suni súan kundee Se̱'e cha̱a chi̱i ñu'un uní ndúú uni̱ ñúú. ");
INSERT INTO migNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ta̱ká cha̱a ñuu̱ Nínive, nachaku̱‑de jíín ñáyɨvɨ yá'a kɨvɨ̱ kíi juicio. Te naku̱xndíi‑de sɨkɨ̱‑í. Chi̱ máá‑de, ni̱ ka̱nakani ini̱‑de kɨvɨ̱ ní jani Jonás tu̱'un nuu̱‑dé. Te vina ví'í‑gá kúñá'nu I'a̱ kándii̱ yá'a vásá Jonás. ");
INSERT INTO migNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Te reina onde̱ ichi sur, nachaku̱‑ña jíín ñáyɨvɨ yá'a kɨvɨ̱ kíi juicio. Te naku̱xndíi‑ña sɨkɨ́‑í. Chi̱ onde̱ jíká xáa̱n ní kii‑ña ní jini so̱'o‑ña tú'un ndíchí ní ka'a̱n Salomón. Te vina ví'í‑gá kúñá'nu I'a̱ kándii̱ yá'a vásá Salomón. ");
INSERT INTO migNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nú ni̱ kenda tachi̱ kíni ini̱ ɨɨn cha̱a. Te jíka kuu nuu̱ ñú'un té'é ndúkú núu̱ júngo̱o. Te tú ní'i̱n. ");
INSERT INTO migNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yúan‑na te ká'a̱n tachi̱‑ún: Ná nó'o̱n‑ri̱ ve'e nuu̱ ní kenda‑ri̱, áchí. Te nú ni̱ najaa̱, te jiní ja̱ ɨ́ɨn ve'e sáni kúu. Te ni̱ nduluu ve'e‑ún ja̱ ní nastáa ini̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yúan‑na te ki'i̱n tachi̱‑ún, te kuaka tá'an jíín usiá‑ga̱ tachi̱ ñáá‑ga̱ vásá máá. Te kɨ́vɨ koyo te káxiu̱kú yúan. Núsáá te ví'í‑gá tá'a̱n cha̱a yúan onde̱ sandɨ̱'ɨ́‑na̱ vásá já xnáñúú núú. Te suni súan ta'a̱n ña̱yɨvɨ ñáá yá'a. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Te nini súan ká'a̱n‑ya̱ jíín ñáyɨvɨ‑ún, te ni̱ jaa̱ náa̱‑ya̱ jíín ñaní‑ya̱ ká'i̱in‑ña íchi yatá vé'e, kákuni̱‑ña ká'a̱n‑ña jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Te ni̱ kachi̱ ɨɨn cha̱a jíín‑yá: Yúan nde̱'é‑ní, ni̱ chaa̱ náa̱‑ní jíín ñaní‑ní ká'i̱in‑ña yatá vé'e, te kákuni̱‑ña ká'a̱n‑ña jíín‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Te ni̱ ka'a̱n‑ya̱ jíín cháa ni̱ ka'a̱n súan jíín‑yá: Ndéja̱ kúu náa̱‑ri̱, te ndéja̱ kákuu ñani̱‑ri̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Te ni̱ skáa̱‑ya̱ ndá'a‑yá onde̱ nuu̱ káxiu̱kú cháa káskuá'a jíín‑yá. Te ni̱ ka'a̱n‑ya̱: Yá'a nde̱'é‑ró núu̱ náa̱‑ri̱ jíín núu̱ ñaní‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chi ña̱yɨvɨ skíkuu tiñu kuní máá Táa̱‑ri̱ kánchaa̱‑ya̱ ondé andɨ́vɨ́, jia̱n kúu kua̱'a‑ri̱ kúu náa̱‑ri̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Te kɨvɨ̱‑ún ni̱ kenda Jesús ve'e‑ún te kua'a̱n‑ya̱. Te ni̱ jaa̱‑ya̱ ní jungo̱o‑ya̱ yú'u mar. ");
INSERT INTO migNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Te ni̱ kataka̱ kua'a̱ xáa̱n ñáyɨvɨ núu̱‑yá. Te ni̱ kɨ̱vɨ‑ya̱ iní ɨɨn barco. Te ni̱ jungo̱o‑ya̱. Te ta̱ká ña̱yɨvɨ‑ún ni̱ ka̱kendo̱o‑i yu'u mar. ");
INSERT INTO migNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Te ni̱ ka'a̱n‑ya̱ kuá'a̱ tú'un yátá jíín‑i: Kuni so̱'o te kuni̱‑ro̱. Ɨɨn cha̱a sáka trigo, ni̱ kenda‑de sáka‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Te sáka‑dé kua'a̱n‑de. Te ɨɨn nuni̱‑ún, ni̱ jungava yu'íchi. Te ni̱ chaa̱ tɨsaa̱ te ni̱ ka̱kókó‑tɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Te ɨnga̱ ni̱ jungava nuu̱ ñú'un yúu̱ núu̱ tú íó kua'a̱ ñú'un. Te ni̱ kana yachi̱‑ni chi̱ tú íó kókon ñu'un. ");
INSERT INTO migNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Te nuu̱ ní kana ndika̱ndii, te ni̱ kasu̱n‑ni. Te ni̱ ichi̱, chi̱ tú yo'o ní íó. ");
INSERT INTO migNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Te ɨnga̱ ni̱ jungava ma̱'ñú íñu. Te ni̱ ja'nu iñu‑ún. Te ni̱ jasu̱ nuu̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Te sava ni̱ ka̱jungava nuu̱ ñú'un vá'a. Te ni̱ kuun nuni̱, ɨɨn ja̱ ɨ́ɨn ciento, ɨnga̱ ja̱ uní xiko, te ɨnga̱ ja̱ okó uxi̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Cha̱a íó so̱'o kuni ná'ín, te ná kúni so̱'o‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yúan‑na te ni̱ cha̱koyo cha̱a káskuá'a jíín‑yá. Te ni̱ kaka'a̱n‑de jíín‑yá: Naja̱ ká'a̱n‑ní tu̱'un yátá jíín ñáyɨvɨ yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Róó, chi̱ a kuaju̱ku̱'un ini̱‑ro̱ tú'un yísa̱'í yá'a sá'a Dios, ndasa koo ñuu̱ nátu̱'un andɨ́vɨ́. Ko máá ñáyɨvɨ yá'a, ma̱ júku̱'un ini̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Chi cha̱a ja̱ á ñáva̱'a, te kii‑ga̱ nuu̱‑dé sá'a‑ya̱. Te kuñava̱'a‑de kua'a̱ xáa̱n‑gá. Ko cha̱a ja̱ ná tú ñáva̱'a, va̱sa ja̱ á ñáva̱'a‑de‑ún, te kuxio ki'i̱n. ");
INSERT INTO migNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ja̱ yúán ká'a̱n‑ri̱ tu̱'un yátá jíín‑i. Chi va̱sa kánde̱'é‑i, ko tú kájini̱‑i. Te va̱sa kájini so̱'o‑i, ko tú kájini ná'ín‑i ni tú kájuku̱'un ini̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ña̱yɨvɨ yá'a káskíkuu‑i tu̱'un ni̱ ka'a̱n Isaías: Va̱sa kájini ná'ín vá'a‑ró, ko ma̱ júku̱'un ini̱‑ro̱. Te va̱sa kánde̱'é ndɨ́'ɨ‑ró, ko ma̱ kuní‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Chi̱ xaa̱n ní ka̱kuni̱'in ini̱ ña̱yɨvɨ yá'a. Te xaa̱n ú'u̱ kájini so̱'o‑i. Te kájasu̱‑i nduchi‑í náva̱'a ma̱ kuní‑i jíín ndúchi‑í, te ma̱ kúni ná'ín‑i jíín só'o‑i, te ma̱ júku̱'un ini̱‑i, te ma̱ nájíó káva ini̱‑i, te ma̱ násáva̱'a‑ri̱‑i. Achí. ");
INSERT INTO migNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ko xáán ndatu̱ máá‑ró jíná'an‑ró, chi̱ kánde̱'é‑ró jíín ndúchi‑ro, te kájini ná'ín‑ró jíín só'o‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Chi ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró já tɨnɨ́ cha̱a kájani tu̱'un Dios jíín tɨnɨ́ cha̱a va̱'a, ni̱ kakuni̱‑de nde̱'é‑de nuu̱ já kánde̱'é máá‑ró, ko tú ní kajini̱‑de. Te suni ni̱ kakuni̱‑de kuni so̱'o‑de ja̱ kájini so̱'o máá‑ró, ko tú ní kájini so̱'o‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kuni ná'ín jíná'an‑ró tú'un yátá cháa sáka núsáá. ");
INSERT INTO migNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nú ɨɨn cha̱a jíni so̱'o‑de tu̱'un ñuu̱ Dios, te nú tú júku̱'un ini̱‑de, yúan‑na te chaa̱ kui'na̱ te kuanchaa̱‑ni tu̱'un ni̱ saka̱ iní añú‑de‑ún. Cha̱a yúan kúu nuni̱ ní jungava yu'íchi. ");
INSERT INTO migNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Te nuni̱ ní saka̱ núu̱ ñú'un yúu̱, yu̱án kúu cha̱a jíni so̱'o‑de tu̱'un, te kúsɨɨ̱‑ní ini̱‑de jíín. ");
INSERT INTO migNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ko tú nuu̱ káka yo'o iní‑de, te yaku̱‑ni kɨvɨ̱ kánda. Te nú ni̱ ndonda tu̱ndó'o sɨkɨ̱‑dé, xí nú ni̱ sándɨva̱'a‑i jíín‑de sɨkɨ̱ tú'un‑ún, te náyu̱'ú‑ni‑de. ");
INSERT INTO migNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Te nuni̱ ní saka̱ má'ñú íñu, yu̱án kúu cha̱a jíni so̱'o‑de tu̱'un. Ko kútéñu‑de jíín ndátíñu‑de. Te kuní‑de kuu kúká‑de. Te xndá'ú‑de máá‑de jíín. Ndɨ'ɨ ya̱'á jasú nuu̱ tú'un‑ún, te tú kúun nuni̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ko nuni̱ ní saka̱ núu̱ ñú'un vá'a, yu̱án kúu cha̱a jíni so̱'o‑de tu̱'un te júku̱'un ini̱‑de. Te bueno já'a‑de nuni̱, ɨɨn‑de ciento, ɨnga̱‑de uni̱ xiko, te ɨnga̱‑de oko̱ uxi̱, súan kája̱'a‑de nuni̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ió ɨnga̱ tu̱'un yátá ní ka'a̱n‑ya̱ jíín‑de; Ñuu̱ nátu̱'un andɨ́vɨ́ kúu nátu̱'un ɨɨn cha̱a ni̱ chi'i itu̱ va̱'a nuu̱ ñú'un‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ko nini kixi‑de, te ni̱ jaa̱ cha̱a jíto u'u̱ tá'an jíín‑de. Te ni̱ chi'i tuku ndɨkɨn lazo nuu̱ trigo‑de, te kua'a̱n. ");
INSERT INTO migNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ko nuu̱ ní kana yuku̱ itu̱‑ún, te kúun nuni̱, yúan‑na te suni ni̱ kana lazo. ");
INSERT INTO migNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Te ni̱ ja̱koyo mozo máá táa̱, cha̱a xíin. Te ni̱ kaka'a̱n‑i jíín‑de: Táta̱, á tú ní chí'i‑ní nuni̱ vá'a nuu̱ ñú'un‑ní yá'a. Te ndénu̱ ní ni'i̱n‑ní lazo yá'a núsáá. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Te ni̱ ka'a̱n‑de jíín mozo‑de: Ɨɨn cha̱a jíto u'u̱ ruu̱ ni̱ sá'a ya̱'á, áchí‑de. Te ni̱ kaka'a̱n mozo‑ún jíín‑de: Núsáá te kuní‑ní ja̱ ná kítu̱'un‑ná náún, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Te máá‑de ni̱ ka'a̱n‑de: Túu, chi̱ náni tú'un‑ró lazo‑ún te sanaa te tu'un‑ró trigo jíín. ");
INSERT INTO migNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ná kuá'nu máá jíná'an onde̱ kɨvɨ̱ tá'nu̱. Te kɨvɨ̱‑ún te tá'ú‑rí tiñu nuu̱ cháa ka'nu̱: Stútú xna'a̱n‑ga̱ lazo jia̱n, te sá'a‑ró nú'ni̱ náva̱'a ka'mu‑yó. Ko trigo yá'a, nastútú‑ró ná kɨ́vɨ ini̱ yaka̱‑ri̱. Achí‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ió ɨnga̱ tu̱'un yátá ní ka'a̱n‑ya̱ jíín‑de: Ñuu̱ nátu̱'un andɨ́vɨ́ kúu nátu̱'un ndɨkɨn yuá mostaza, ja̱ ní ki'in ɨɨn cha̱a te ni̱ chaa‑de nuu̱ ñú'un‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Te ja̱ndáa̱ ɨɨn ndɨkɨn lúlí‑ga̱ kúu vásá táká‑ga̱ tata̱. Ko nú ni̱ ja'nu, te kúu ká'nu‑ga̱ vásá táká‑ga̱ yua̱. Te kuu ɨɨn yunu ká'nu. Te chaa̱ tɨsaa̱ andɨ́vɨ́, te va̱tu‑ni sá'a‑tɨ̱ taká‑tɨ̱ chíi nda'a‑ún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ió ɨnga̱ tu̱'un yátá ní ka'a̱n‑ya̱ jíín‑de: Ñuu̱ nátu̱'un andɨ́vɨ́ kúu nátu̱'un yujan íá já ní ki'in ɨɨn ña'an. Te ni̱ chisa̱'í‑ña chíi uni̱ ti̱yii yúchi onde̱ ni̱ ndɨ'ɨ ni̱ kuu íá ní sá'a. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ta̱ká tu̱'un yá'a ni̱ ka'a̱n Jesús jíín ñáyɨvɨ kuá'a̱‑ún. Te nú túu tu̱'un yátá te tú ká'a̱n‑ya̱ jíín‑i, ");
INSERT INTO migNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Náva̱'a ná skíkuu tu̱'un ni̱ ka'a̱n cha̱a ni̱ jani tu̱'un Dios: Ka'a̱n‑ri̱ tu̱'un yátá, te kachi̱‑ri̱ tu̱'un yísa̱'í onde̱ kɨvɨ̱ ní jungo̱o ñu̱yɨ́vɨ, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yúan‑na te ni̱ nakuatá'ú Jesús nuu̱ ñáyɨvɨ‑ún. Te ni̱ ndɨ̱vɨ‑ya̱ iní ve̱'e. Te ni̱ ja̱koyo cha̱a káskuá'a‑ún nuu̱‑yá. Te ni̱ kaka'a̱n‑de jíín‑yá: Kani kájí‑ní tu̱'un yátá lazo nuu̱‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ja̱ sáka tatá va̱'a‑ún kúu máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Te ñu'un‑ún kúu ñu̱yɨ́vɨ. Te tata̱ va̱'a‑ún kákuu se̱'e Dios. Te lazo‑ún kákuu se̱'e kui'na̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Te cha̱a u'u̱ ja̱ ní chi'i lazo‑ún kúu kui'na̱. Te kɨvɨ̱ tá'nu̱‑ún kúu kɨvɨ̱ jínu ñu̱yɨ́vɨ. Te cha̱a ka'nu̱‑ún kákuu ndajá'a̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Te nátu̱'un kutútú lazo, te kayu̱ nuu̱ ñú'u̱n, súan kuu kɨvɨ̱ jínu ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Te máá Sé'e cha̱a, tájí‑yá ndajá'a̱‑yá ki'i̱n. Te nastútú‑yá ta̱ká ña̱yɨvɨ kásá'a kua̱chi jíín ñáyɨvɨ kásá'a tiñu ñáá. ");
INSERT INTO migNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Te taan‑yá‑i kayu̱‑i nuu̱ ñú'u̱n. Te yúan nde'e̱‑i te nakaji‑í ñii yú'u‑í jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yúan‑na te ña̱yɨvɨ vá'a‑ún, ndii ncháa̱‑i nátu̱'un ndika̱ndii, kuxiu̱kú‑i jíín máá Táa̱‑i ini̱ ñuu̱ nuu̱ tá'ú‑yá tiñu. Cha̱a íó so̱'o kuni ná'ín, ná kúni so̱'o‑de. ");
INSERT INTO migNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ñuu̱ nátu̱'un andɨ́vɨ́ kúu nátu̱'un ɨɨn janu̱ xú'ún já yísa̱'í chi̱i ɨɨn ñu'un, te ni̱ ndenda ni̱ sá'a ɨɨn cha̱a, te jasú tuku‑de sɨkɨ̱, te kúsɨɨ̱ iní‑de jíín, te kua'a̱n‑de, te xíkó ndɨ́'ɨ‑de na̱ún ñáva̱'a‑de, te jáan‑de ñu'un‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Suni ñuu̱ nátu̱'un andɨ́vɨ́ kúu nátu̱'un ɨɨn cha̱a jáan‑de te xíkó‑de ja̱ ndúkú‑de perla luu. ");
INSERT INTO migNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Te ni̱ jini̱‑de ɨɨn perla ja̱ xáa̱n yá'u. Te ni̱ kee‑de kua'a̱n‑de. Te ni̱ xi̱kó ndɨ́'ɨ‑de ta̱ká ndatíñu‑de. Te ni̱ jaan‑de perla‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Suni ñuu̱ nátu̱'un andɨ́vɨ́ kúu nátu̱'un ɨɨn ñunu já júkui̱ta ka'nu ini̱ mar. Te tɨ́ɨn tɨnɨ̱ nuu̱ tíyáká. ");
INSERT INTO migNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Te nuu̱ ní chítú ñúnu‑ún, te ni̱ ka̱natava‑dé yundúcha. Te ni̱ kaju̱ngo̱o‑de. Te ni̱ kaka̱ji‑de kɨtɨ vá'a‑ún kɨ́vɨ‑tɨ̱ iní ji̱ka. Te ni̱ ka̱skána‑de kɨtɨ ñáá‑ún kua'a̱n. ");
INSERT INTO migNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Suni súan koo kɨvɨ̱ jínu ñu̱yɨ́vɨ. Chi̱ kenda koyo ndajá'a̱‑yá. Te ka̱ji‑ya̱ ñáyɨvɨ ñáá ma̱'ñú ñáyɨvɨ vá'a. ");
INSERT INTO migNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Te taan‑yá‑i kayu̱‑i nuu̱ ñú'u̱n. Te yúan nde'e̱‑i te nakaji‑í ñii yú'u‑í. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Te ni̱ kachi̱ Jesús jíín‑de: Ni̱ kaju̱ku̱'un ini̱‑ro̱ táká tu̱'un yá'a náún, áchí‑ya̱. Te ni̱ kaka'a̱n‑de jíín‑yá: Jaa̱n Táta̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Te ni̱ kachi̱‑ya̱ jíín‑de: Ja̱ yúán íó cha̱a káchaa tutu̱ jiní‑de sa'a̱n ñuu̱ nátu̱'un andɨ́vɨ́, te máá‑de kúu nátu̱'un ɨɨn cha̱a xíin vé'e, te onde̱ ini̱ yaka̱‑de táva‑dé ndatíñu jáá jíín ndátíñu aná'án, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Te súan ni̱ ji̱nu ni̱ ka'a̱n Jesús tu̱'un yátá yá'a. Te ni̱ kenda‑ya̱ yúan kua'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Te ni̱ najaa̱‑ya̱ ñúu̱‑ya̱. Te ni̱ stá'a̱n‑ya̱ núu̱‑dé ini̱ ve̱'e sinagoga máá‑de jíná'an‑de. Te ni̱ ka̱naa iní‑de ni̱ kande̱'é‑de nuu̱‑yá. Te ni̱ kaka'a̱n‑de: Ndénu̱ ní ni'i̱n cháa yá'a tu̱'un ndíchí yá'a jíín tíñu ñá'nu sá'a‑de yá'a. ");
INSERT INTO migNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nasu̱ sé'e cha̱a carpintero kúu ya̱'á náún. Á nasu̱ María nání náa̱‑de. Te ta̱ká ñani̱‑de káinání Jacobo, José, Simón, jíín Judas. ");
INSERT INTO migNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Te tú ká'i̱in kua̱'a‑de jíín‑yó yá'a náún. Te ndénu̱ ní ni'i̱n‑dé ta̱ká tu̱'un yá'a núsáá. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Te súan ni̱ ka̱kujá'a̱ ini̱‑i jíín‑yá. Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑i: Cha̱a jáni tu̱'un Dios, máni ñuu̱‑de jíín iní ve̱'e‑de kúu ja̱ tú káka'a̱n tu̱'un jíñú'ún jíín‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Te tú ní sá'a‑ya̱ kuá'a̱ tíñu ñá'nu yúan, chi̱ tú ní kákandíja‑i. ");
INSERT INTO migNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Te suu kɨvɨ̱‑ún te Herodes cha̱a tá'ú tíñu, ni̱ jini tu̱'un‑de tu̱'un Jesús. ");
INSERT INTO migNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Te ni̱ kachi̱‑de jíín mozo‑de: Cha̱a yá'a kúu Juan ja̱ skuánducha. Ni̱ nachaku̱‑de ja̱ ní ji'i̱‑de, te ja̱ yúán sá'a‑de tiñu ñá'nu yá'a. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Chi̱ Herodes, ni̱ tɨɨn‑de Juan. Te ni̱ ju'ni̱‑de. Te ni̱ chindee‑de cha̱a veka̱a ja̱ kuáchi Herodías ñasɨ́'ɨ́ Felipe ñani̱ máá Herodes. ");
INSERT INTO migNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Te Juan, a ni̱ kana jíín‑de nuu̱ Herodes: Tú íó ley kuaka‑ró‑ña, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Te Herodes, ni̱ kuni̱‑de ka'ni‑dé Juan. Ko ni̱ yu̱'ú‑de ni̱ jito‑de ña̱yɨvɨ, chi̱ kájani ndaa̱ ini̱‑i ja̱ ɨ́ɨn cha̱a jáni tu̱'un Dios kúu Juan. ");
INSERT INTO migNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Te ɨɨn kɨvɨ̱ ní sá'a Herodes ɨɨn viko kɨvɨ́ ní kaku‑de. Te se̱sɨ́'ɨ́ Herodías ni̱ jita já'á‑i nuu̱ ñáyɨvɨ. Te ni̱ kusɨɨ̱ iní Herodes jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Te ni̱ jatu̱'un téyíí‑de ja̱ kuá'a‑de ta̱ká na̱ún kakán‑i nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Te náa̱‑i, a ni̱ jani íchí‑ña‑í, te ni̱ ka'a̱n‑i: Kua̱'a‑ní xini̱ Juan, cha̱a skuánducha‑ún nuu̱‑ná kundee nuu̱ ɨ́ɨn ko'o̱, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yúan‑na te máá rey‑ún, ni̱ kuxíí iní‑de. Ko sɨkɨ̱ já ní jatu̱'un téyíí‑de jíín sɨkɨ́ já ní ka̱jini so̱'o cha̱a káyee stáa̱ jíín‑de‑ún, te ni̱ tá'ú‑de tiñu ná kuá'a soldado nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Te ni̱ tájí‑de soldado ni̱ ja'a̱n. Te ni̱ xɨtɨ xiní Juan ini̱ veka̱a. ");
INSERT INTO migNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Te ni̱ chaa̱ xini̱‑dé kándee nuu̱ ɨ́ɨn ko'o̱. Te ni̱ ja̱'a soldado nuu̱ súchí sɨ́'ɨ́‑ún. Te máá‑i, ni̱ jancha̱ka‑i nuu̱ náa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yúan‑na te ni̱ ja̱koyo cha̱a káskuá'a jíín‑de. Te ni̱ ka̱ndañaa‑de yikɨ kúñu Juan. Te ni̱ kachi̱ndu̱ji‑de. Te ni̱ kee‑de kája'a̱n‑de. Te ni̱ kaka̱stu̱'ún‑de nuu̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Te ni̱ jini tu̱'un Jesús. Te ni̱ kuxio‑ya̱ kuá'a̱n‑ya̱ yúan ini̱ ɨɨn barco onde̱ nuu̱ ñú'un té'é kándee sɨ́ɨn‑ya̱. Te ni̱ ka̱jini tu̱'un ña̱yɨvɨ jíná'an‑i. Te onde̱ ta̱ká ñuu̱ ni̱ kandiki̱n‑i‑ya̱ kájika já'á‑i jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Te ni̱ kenda Jesús kua'a̱n‑ya̱. Te ni̱ jini̱‑ya̱ núu̱ ñáyɨvɨ kuá'a̱ xáa̱n. Te ni̱ ndukuí'a̱ ini̱‑ya̱ jíín‑i. Te ni̱ sá'a‑ya̱ taná táká ña̱yɨvɨ káku'u̱. ");
INSERT INTO migNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Te nuu̱ ní ini te ni̱ cha̱koyo cha̱a káskuá'a jíín‑yá nuu̱‑yá. Te ni̱ kaka'a̱n‑de: Yá'a chi̱ máá ñú'un té'é kúu, te a ni̱ ke̱e ndika̱ndii. Tájí‑ní‑i ná kíngoyo‑i ta̱ká ñuu̱. Te ná kuáan máá‑i staa̱ kée‑í, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Te ni̱ kachi̱ Jesús jíín‑de: Tú nɨ́nɨ kí'i̱n‑i jíná'an‑i: Kua̱'a máá‑ró já ná kée‑í, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Te máá‑de, ni̱ kaka'a̱n‑de jíín‑yá: Tú na̱ún káñava̱'a‑ná chi̱ u'u̱n‑ni sta̱tilá jíín úu̱‑ni ti̱yáká, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Te máá‑yá, ni̱ kachi̱‑ya̱ jíín‑de: Kua̱'a ná kíi nuu̱‑rí yá'a, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Te ni̱ tá'ú‑yá tiñu nuu̱ ñáyɨvɨ‑ún ni̱ kaju̱ngo̱o ta̱ká‑i nuu̱ ichá. Te ni̱ ki'in‑ya̱ ndɨ́'ú'u̱n sta̱tilá jíín úu̱ ti̱yáká‑ún. Te ni̱ ndakoto‑ya̱ íchi ándɨ́vɨ́. Te ni̱ jika̱n ta'u̱‑yá ja'a̱ státilá. Te ni̱ sákuáchí‑yá. Te ni̱ ja̱'a‑ya̱ núu̱ cháa káskuá'a jíín‑yá. Te cha̱a‑ún, ni̱ ka̱jani‑de nuu̱ ñáyɨvɨ‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Te ndivii‑í ni̱ ka̱yee. Te ni̱ kanda'a̱ chi̱i‑i. Te ni̱ ka̱nastútú‑de uxi̱ uu̱ ji̱ka staa̱ kua̱chí‑ún ja̱ ní ndendoso. ");
INSERT INTO migNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Te jínu u'u̱n mil cha̱a ni̱ ka̱yee‑ún, te sɨ́ɨn‑ga̱ kúu ñasɨ́'ɨ́ jíín súchí lúlí. ");
INSERT INTO migNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yúan‑na te ni̱ skandá‑ni Jesús cha̱a káskuá'a jíín‑yá, ni̱ kɨ̱vɨ koyo‑de ini̱ ɨɨn barco. Te ná kúxnúú‑de ki̱ngoyo‑de ɨnga̱ lado yu'u mar sá'a‑ya̱, chi̱ kuéé jachá‑ya̱ ñáyɨvɨ kuá'a̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Te ni̱ jacha̱‑ya̱ ñáyɨvɨ‑ún kája'a̱n‑i. Te ni̱ kaa sɨ́ɨn‑ya̱ kuá'a̱n‑ya̱ yúku, kuákaka̱n ta'u̱‑yá. Te ni̱ ini, te kándee máá ɨ́ɨn‑ni‑ya̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Te barko‑ún, a kándee ma̱'ñú mar. Te ká'ú xaa̱n ní ndonda su'ma̱ ndúcha sɨkɨ́‑dé, chi̱ sua ni̱ nana nuu tachi̱. ");
INSERT INTO migNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Te tɨ́kuáán‑na̱ kúu. Te ni̱ jaa̱ Jesús nuu̱‑dé, jíka já'á‑yá nuu̱ mar. ");
INSERT INTO migNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Te cha̱a káskuá'a‑ún, ja̱ ní kajini̱‑de‑ya̱, já jíka‑ya̱ núu̱ mar, te ni̱ kayu̱'ú‑de. Te káka'a̱n‑de: Añú kúu, áchí‑de. Te kákana kó'ó‑de ja̱ káyu̱'ú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yúan‑na te Jesús, ni̱ ka'a̱n‑ni‑ya̱ jíín‑de: Sándéé iní‑ro̱. Máá‑rí kúu. Ma̱ yú'ú‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yúan‑na te ni̱ ka'a̱n Pedro jíín‑yá: Táta̱, te nú máá‑ní kúu, te tá'ú‑ní tiñu ná káka‑ná nuu̱ mar yá'a jaa̱‑ná nuu̱‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Te ni̱ ka'a̱n‑ya̱: Ña'a̱n, áchí‑ya̱. Te ni̱ nuu Pedro ini̱ barco. Te ni̱ jika‑de nuu̱ ndúcha‑ún kua'a̱n‑de nuu̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ko nuu̱ ní jini̱‑de ja̱ xáa̱n kée tachi̱, te ni̱ yu̱'ú‑de. Te ni̱ kejá'á‑de sá'u‑de chi̱i nducha. Te ni̱ kana kó'ó‑de: Táta̱, nama‑ní náá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Te ni̱ skáa̱‑ni Jesús nda'a‑yá. Te ni̱ tɨɨn‑ya̱‑dé. Te ni̱ kachi̱‑ya̱ jíín‑de: Cha̱a tú kándíja va̱'a kúu‑ró. Naja̱ jáni sɨ̱kɨ́ ini̱‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Te ni̱ ndɨ̱vɨ‑ya̱ iní barko‑ún jíín‑de. Te ni̱ kuná'ín‑ni tachi̱ xáa̱n‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yúan‑na te cha̱a ká'i̱in ini̱ barko‑ún, ni̱ cha̱koyo‑de nuu̱‑yá. Te ni̱ ka̱chiñú'ún‑de‑ya̱. Te káka'a̱n‑de: Ja̱ndáa̱ ndíja máá‑ní kúu Se̱'e Dios, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Te ni̱ kaja̱'a‑ya̱ kuá'a̱n‑ya̱ ɨngá lado. Te ni̱ cha̱koyo‑ya̱ ñú'un íchí ñúu̱ Genesaret. ");
INSERT INTO migNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Te cha̱a ñuu̱‑ún, ni̱ ka̱nakuni̱‑de‑ya̱. Te ni̱ ka̱tájí‑de tu̱'un nɨ́ɨ́ ñúu̱‑ún. Te ni̱ ka̱kinchaka‑de ña̱yɨvɨ káku'u̱ nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Te ni̱ kaka'a̱n nda̱'ú‑i jíín‑yá ja̱ ná ké'é‑i va̱sté yúsá'ma‑yá. Te ta̱ká ña̱yɨvɨ ní ka̱ké'é sá'ma‑yá‑ún, ni̱ kandu̱va̱'a‑i. ");
INSERT INTO migNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yúan‑na te yaku̱ cha̱a fariseo jíín cháa káchaa tutu̱ ini̱ ñuu̱ Jerusalem, ni̱ ja̱koyo‑de nuu̱‑yá. Te ni̱ kaka'a̱n‑de jíín‑yá: ");
INSERT INTO migNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Cha̱a káskuá'a jíín‑ró, naja̱ káské'ichi̱‑de tani̱nu cha̱a aná'án. Chi̱ tú kánandá'á‑de te káyee‑dé staa̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Te máá‑yá, ni̱ ka'a̱n‑ya̱ jíín‑de: Te máá‑ró, suni naja̱ káské'ichi̱‑ro̱ tíñu ni̱ tá'ú Dios nuu̱‑ro̱ núsáá, chi ja̱ sɨkɨ́ táni̱nu máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Chi̱ ni̱ ka'a̱n Dios: Kuandatu̱ nuu̱ táa̱‑ro̱ núu̱ náa̱‑ro̱, te ndéja̱ ká'a̱n ndɨva̱'a nuu̱ táa̱ nuu̱ náa̱, ná kúu̱ nú kuu̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ko máá‑ró káka'a̱n‑ro̱: Nú íó ndatíñu ja̱ xíin ɨɨn cha̱a, te a kuu ni'i̱n tíñu ja̱ kuní táa̱‑de xí náa̱‑de, te nú xna'a̱n‑ga̱ ka'a̱n‑de: A ni̱ soko̱‑rí ndatíñu‑ún nuu̱ Dios, achi̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yúan‑na te tuká kánúú skíkuu‑de kua̱'a‑de nuu̱ táa̱‑de nuu̱ náa̱‑de, áchí‑ro̱. Te súan kástɨ́vɨ́‑ró tú'un Dios jíín táni̱nu ni̱ kajaki̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Cha̱a uu̱ xini̱ kákuu‑ró. Bueno ni̱ jani Isaías tu̱'un sɨkɨ̱‑ro̱ súan: ");
INSERT INTO migNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ña̱yɨvɨ yá'a, jíín yú'u‑í káchiñú'ún‑i ruu̱, ko jíín añú‑i chi̱ jíká‑ni kúu ini̱‑i jíto‑i ruu̱. ");
INSERT INTO migNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Te káchiñú'ún sáni‑i ruu̱, chi̱ kástá'a̱n‑i tu̱'un jáni ini̱ ɨɨn cha̱a, áchí Isaías. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Te ni̱ kana‑ya̱ xiní ñáyɨvɨ‑ún. Te ni̱ ka'a̱n‑ya̱ jíín‑i: Kuni so̱'o jíná'an‑ró, Te chu'un ini̱‑ro̱ tú'un ká'a̱n‑ri̱: ");
INSERT INTO migNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nasu̱ já kɨ́vɨ ini̱ yu'u cháa kuchá'án‑de sá'a, chi ja̱ kénda ini̱ yu'u‑dé, yu̱án kúu ja̱ kúchú'án‑de sá'a, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yúan‑na te cha̱a káskuá'a jíín‑yá, ni̱ cha̱koyo‑de nuu̱‑yá. Te ni̱ kaka'a̱n‑de: Á jiní‑ní ja̱ ní kakiti̱ ini̱ cha̱a fariseo ja̱ ní ka̱jini so̱'o‑de tu̱'un yá'a, xí túu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ko máá‑yá, ni̱ ka'a̱n‑ya̱: Ta̱ká yunu já tú ní náchu'un máá Táa̱‑ri̱ andɨ́vɨ́, te tu'un‑ri̱ ki'i̱n. ");
INSERT INTO migNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sía̱ jíná'an‑ró ná kí'i̱n‑de. Cha̱a kuáá kástá'a̱n ichi núu̱ sáva‑ga̱ cha̱a kuáá kákuu‑de. Chi̱ nú ɨɨn cha̱a kuáá stá'a̱n‑de ichi núu̱ ɨngá cha̱a kuáá, te ndendúú‑de jungoyo‑de ini̱ xa'va̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Te ni̱ ka'a̱n Pedro jíín‑yá: Kastu̱'ún kájí‑ní tu̱'un yátá yá'a nuu̱‑ná jíná'an‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Te ni̱ kachi̱ Jesús: Te suni onde̱ róó tú kájuku̱'un ini̱‑ro̱ náún. ");
INSERT INTO migNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Á tú kájuku̱'un ini̱‑ro̱ já táká ja̱ kée‑í kɨ́vɨ kua'a̱n chi̱i‑i, te ndénda‑ni kua'a̱n. ");
INSERT INTO migNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ko ja̱ kénda yu'u‑í, chi̱ onde̱ ini̱ añú‑i va̱i, te yu̱án kúu ja̱ kúchá'án‑i sá'a. ");
INSERT INTO migNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Chi̱ onde̱ ichi iní añú‑i kénda ja̱ jáni ñáá ini̱, ja̱ já'ni ndɨ́yi, ja̱ ísɨ́kɨ ncháa̱ tá'an, ja̱ kuáxán iní, ja̱ sákuí'ná, ja̱ ká'a̱n tu̱'un tú'ún, ja̱ ká'a̱n ndɨva̱'a. ");
INSERT INTO migNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ta̱ká tu̱'un yá'a kúu ja̱ kúchá'án‑i sá'a. Ko nú tú nándá'á‑i te kee‑í staa̱, tú kúchá'án‑i sá'a. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Te ni̱ kenda Jesús yúan kua'a̱n‑ya̱ íchi ndáñúu̱ Tiro jíín Sidón. ");
INSERT INTO migNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Te ɨɨn ña'an ñúu̱ Caná, ni̱ kenda‑ña ndáñúu̱ yúan. Te ni̱ kana kó'ó‑ña: Táta̱, Se̱'e David, kundá'ú ini̱‑ní náá, chi̱ se̱sɨ́'ɨ́‑ná ká'ú xaa̱n tá'a̱n‑i ɨɨn tachi̱ kíni, áchí‑ña jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ko máá‑yá, tú ní ká'a̱n kutɨ‑yá jíín‑ña. Yúan‑na te ni̱ ja̱koyo cha̱a káskuá'a jíín‑yá. Te ni̱ kaka'a̱n nda̱'ú‑de jíín‑yá: Ka'a̱n‑ní jíín‑ña ná kí'i̱n‑ña, chi̱ kána kó'ó‑ña vái‑ña íchi yatá‑yo̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Te ni̱ ka'a̱n‑ya̱: Máni nuu̱ rɨ́ɨ̱, kɨtɨ ní ka̱naa, ká'i̱in se̱'e Israel, ni̱ tájí‑yá ruu̱ va̱i‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yúan‑na te ni̱ chaa̱‑ña núu̱‑yá. Te ni̱ chiñú'ún‑ña‑yá. Te ni̱ ka'a̱n‑ña: Táta̱, chindéé chítuu‑ní náá, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Te ni̱ ka'a̱n máá‑yá: Tú íó va̱'a ja̱ kuánchaa̱‑yo̱ stáa̱ sé'e‑yó te skána‑yó núu̱ lúsu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Te ni̱ ka'a̱n‑ña: Ja̱ndáa̱ ká'a̱n‑ní, Táta̱, ko lúsu‑ún, ichi chíi mesa náchii‑tɨ́ staa̱ kua̱chí kóyo yu'u jíto'o̱‑tɨ̱ yáji‑tɨ́, áchí‑ña jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yúan‑na te ni̱ ka'a̱n Jesús: Nána̱, xaa̱n vá'a ni̱ kandíja‑ní, ná sá'a‑ná jíín‑ní nátu̱'un kuní‑ní, áchí‑ya̱. Te máá hora jia̱n ní nduva̱'a‑ni se̱sɨ́'ɨ́‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Te ni̱ ja̱'a Jesús kua'a̱n‑ya̱ yúan. Te ni̱ jaa̱‑ya̱ yú'u mar ñuu̱ Galilea. Te ni̱ kaa‑ya̱ kuá'a̱n‑ya̱ yúku‑ún. Te yúan ni̱ jungo̱o‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Te ni̱ ja̱koyo kua'a̱ ñáyɨvɨ núu̱‑yá jíín ñáyɨvɨ rengo, ja̱ kuáá, ja̱ ñí'ín, ja̱ tɨ́kú'lu, jíín sáva‑ga̱‑i ja̱ káku'u̱. Te ni̱ kajaki̱n‑i‑ún núu̱ já'a̱ Jesús. Te ni̱ nasáva̱'a‑ya̱‑í jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Te ni̱ ka̱kee nuu̱ ñáyɨvɨ‑ún kánde̱'é‑i ja̱ súan ni̱ kajini̱‑i náka'a̱n ña̱yɨvɨ ñí'ín, ndúva̱'a ña̱yɨvɨ tɨ́kú'lu, nákaka ña̱yɨvɨ rengo, ndúndiji̱n nuu̱ ñáyɨvɨ kuáá. Te ni̱ ka̱nakana jaa‑i Dios ña̱yɨvɨ Israel. ");
INSERT INTO migNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Te ni̱ kana Jesús xini̱ cháa káskuá'a jíín‑yá. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kúndá'ú ini̱‑ri̱ ña̱yɨvɨ yá'a, chi̱ a ni̱ kuu uni̱ kɨvɨ̱ káxiu̱kú‑i jíín‑rí, te tú na̱ún káji‑í. Te tú kuní‑ri̱ natájí‑rí‑i no'o̱n ndicha̱‑i, chi̱ nú súan te sava ichi te kui̱tá ii̱‑í. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yúan‑na te cha̱a káskuá'a jíín‑yá ni̱ kaka'a̱n‑de jíín‑yá: Te ndénu̱ ní'o̱n stáa̱ kuá'a̱ kée ndá'a̱ chi̱i ña̱yɨvɨ kuá'a̱ yá'a, chi̱ máni ñu'un té'é kúu yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Te ni̱ ka'a̱n Jesús jíín‑de: Na̱saa staa̱ kándi̱so‑ró, áchí‑ya̱. Te ni̱ kaka'a̱n‑de: Usia̱‑ni, te yaku̱ ti̱yáká lúlí, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yúan‑na te ni̱ tá'ú‑yá tiñu nuu̱ ñáyɨvɨ‑ún ni̱ ka̱jungo̱o‑i nuu̱ ñú'un. ");
INSERT INTO migNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Te ni̱ ki'in‑ya̱ ndɨ́'usiá staa̱ jíín cháká‑ún, te ni̱ jika̱n ta'u̱‑yá, te ni̱ sákuáchí‑yá, te ni̱ ja̱'a‑ya̱ núu̱ cháa káskuá'a jíín‑yá, te ni̱ ka̱jani‑de nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Te ni̱ ka̱yee táká‑i. Te ni̱ kanda'a̱ chi̱i‑i. Te ni̱ ka̱nastútú‑de ja̱ ní kendo̱o kuáchí‑ún, usia̱ ndo'o̱ chítú ndɨ́ɨ. ");
INSERT INTO migNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Te ña̱yɨvɨ ní ka̱yee‑ún, jínu onde̱ kuu̱n mil cha̱a, te sɨ́ɨn‑ga̱ kúu ñasɨ́'ɨ́ jíín táká su̱chí lúlí. ");
INSERT INTO migNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yúan‑na te ni̱ jacha̱‑ya̱ ñáyɨvɨ‑ún kua̱ngoyo‑i. Te ni̱ ndɨ̱vɨ‑ya̱ iní barco. Te ni̱ jaa̱‑ya̱ ndáñúu̱ Magdala. ");
INSERT INTO migNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Te ni̱ ja̱koyo cha̱a fariseo jíín cháa saduceo nuu̱‑yá, chi̱ koto nchaa̱‑de‑ya̱ kákuni̱‑de. Te ni̱ kajika̱n‑de tuni̱ ichi ándɨ́vɨ́ núu̱‑yá te kuni̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ko máá‑yá ni̱ ka'a̱n‑ya̱ jíín‑de: Nú ni̱ ini, te káka'a̱n‑ro̱: nandii ndáxín, chi̱ íó viko̱ kua̱'á ándɨ́vɨ́, áchí‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Te ja̱ñá'a̱n káka'a̱n‑ro̱: Vina te kuun sau̱, chi̱ íin ñáá viko̱ kua̱'á ándɨ́vɨ́, áchí‑ro̱. Cha̱a uu̱ xini̱ kákuu‑ró. A kájini̱‑ro̱ na̱ún kuní ka'a̱n viko̱ ándɨ́vɨ́, ko tú kájuku̱'un ini̱‑ro̱ tuní kɨvɨ̱ yá'a. ");
INSERT INTO migNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ña̱yɨvɨ ñáá yá'a ja̱ káisɨ́kɨ ncháa̱‑i Dios, kájika̱n‑i tuni̱ nuu̱‑rí. Ko ma̱ kuá'a‑ri̱ ni ɨɨn nuu̱‑í, chi̱ máni tuni̱ Jonás, cha̱a ni̱ jani tu̱'un Dios, kúu ja̱ kuá'a‑ri̱. Achí‑ya̱. Te ni̱ skéndo̱o‑ya̱‑dé jíná'an‑de. Te kua'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Te ni̱ ja̱koyo cha̱a káskuá'a‑ún ɨnga̱ lado mar. Te ni̱ ka̱naa iní‑de kundiso‑de staa̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Te ni̱ kachi̱ Jesús jíín‑de: Koto va̱'a‑ró máá‑ró núu̱ yújan íá cháa fariseo jíín cháa saduceo, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Te kándatu̱'ún máá‑de: Sɨkɨ̱ já tú kándi̱so‑yó stáa̱ ká'a̱n‑ya̱ núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Te ni̱ jini̱ Jesús ja̱ súan kándatu̱'ún‑de. Te ni̱ ka'a̱n‑ya̱: Cha̱a kákandíja yaku̱‑ni kákuu‑ró. Na̱ún kándatu̱'ún‑ró. Ja̱ tú ní kándi̱so‑ró stáa̱ náún. ");
INSERT INTO migNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Onde̱ vina tú kájuku̱'un ini̱‑ro̱ náún. Á tú kánuku̱'un ini̱‑ro̱ já ní kuu jíín ú'u̱n staa̱ jíín ú'u̱n mil cha̱a, te na̱saa ji̱ka ní ka̱nastútú‑ró‑sa̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ni ja̱ ní kuu jíín usiá staa̱‑ún jíín kúu̱n mil cha̱a, te na̱saa ndo'o̱ ní ka̱nastútú‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Te naja̱ tú kájuku̱'un ini̱‑ro̱, chi̱ tú ní ká'a̱n‑ri̱ tu̱'un sta̱tilá jíín‑ró, chi̱ sua ja̱ kóto va̱'a‑ró máá‑ró núu̱ yújan íá cháa fariseo jíín cháa saduceo. Achí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yúan‑na te ni̱ kaju̱ku̱'un ini̱‑de ja̱ tú ní ká'a̱n‑ya̱ jíín‑de ja̱ kóto‑de máá‑de nuu̱ yújan íá státilá, chi̱ sua ja̱ má kándíja‑de sa'a̱n kástá'a̱n cha̱a fariseo jíín cháa saduceo. ");
INSERT INTO migNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Te ni̱ jaa̱ Jesús ichi ndáñúu̱ Cesarea de Filipo. Te ni̱ jika̱ tu̱'ún‑yá cha̱a káskuá'a jíín‑yá: Na̱ún cha̱a kúu máá Sé'e cha̱a káka'a̱n ña̱yɨvɨ jíná'an‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Te máá‑de ni̱ kaka'a̱n‑de: Juan, cha̱a skuánducha, káka'a̱n sava‑i. Te sava‑ga̱‑i, Elías, te sava‑ga̱‑i, Jeremías, xí ɨ́ɨn cha̱a ni̱ jani tu̱'un Dios onde̱ sáá, áchí‑i. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Te máá‑yá ni̱ ka'a̱n‑ya̱ jíín‑de: Te róó, na̱ cha̱a kúu‑ri̱ káka'a̱n‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Te ni̱ ka'a̱n Simón Pedro: Máá‑ní kúu Cristo, Se̱'e Dios, I'a̱ chakú, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yúan‑na te ni̱ kachi̱ Jesús: Xáán ndatu̱‑ro̱, Simón se̱'e Jonás, chi̱ nasu̱ ɨ́ɨn cha̱a ní kástu̱'ún tú'un yá'a nuu̱‑ro̱, chi̱ sua máá Táa̱‑ri̱ I'a̱ kánchaa̱ andɨ́vɨ́ ní stá'a̱n‑ya̱ núu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ko ruu̱, suni ká'a̱n‑ri̱ jíín‑ró já máá‑ró kúu Pedro, te sɨkɨ̱ káva yá'a kundii̱ tɨku'ni̱ kándíja‑i nuu̱‑rí sá'a‑ri̱. Te ja̱ kándee infierno ma̱ kúndéé jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Te nuu̱‑ro̱ kuá'a‑ri̱ ndakáa máá ñúu̱ nátu̱'un andɨ́vɨ́. Te ta̱ká ja̱ kú'ni̱‑ro̱ iní ñu̱yɨ́vɨ yá'a, kunu'ni̱ ini̱ andɨ́vɨ́. Te ta̱ká ja̱ ndájí‑ró iní ñu̱yɨ́vɨ yá'a, ndaji̱ iní andɨ́vɨ́. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yúan‑na te ni̱ ka'a̱n xaa̱n‑yá jíín cháa káskuá'a jíín‑yá, ja̱ tú ni ɨɨn nuu̱ kachí‑de ja̱ máá‑yá kúu Jesucristo. ");
INSERT INTO migNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Te máá hora jia̱n ní kejá'á Jesús ni̱ kastu̱'ún ndáa̱‑ya̱ núu̱ cháa káskuá'a jíín‑yá ja̱ jínu ñú'ún kí'i̱n‑ya̱ ñúu̱ Jerusalem te ndo'o xaa̱n‑yá. Te cha̱a ni̱ ka̱yii jíín táká sutu̱ ñá'nu jíín cháa káchaa tutu̱, ma̱ kuátú'ún‑de‑ya̱ te ka'ni‑dé‑ya̱. Te nuu̱ uní kɨvɨ̱ te nachaku̱‑ya̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yúan‑na te Pedro, ni̱ kiñi'in sɨ́ɨn‑de‑ya̱. Te ni̱ kejá'á‑de ká'a̱n xaa̱n‑dé jíín‑yá: Ma̱ kúu Táta̱, tú kutɨ na̱ modo ja̱ tá'a̱n‑ní tu̱ndó'o yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yúan‑na te ni̱ jíó káva Jesús nuu̱ Pedro. Te ni̱ kachi̱‑ya̱ jíín‑de: Satanás, kuxio ki'i̱n‑ro̱, chi cha̱a sáká núu kúu‑ró núu̱‑rí. Chi̱ tú ká'a̱n‑ro̱ tú'un Dios, chi̱ sa tu̱'un cha̱a ká'a̱n‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yúan‑na te ni̱ ka'a̱n Jesús jíín cháa káskuá'a jíín‑yá: Na̱ni cha̱a nú kuní‑de kii‑de yata̱‑rí, ma̱ kúndá'ú ini̱‑de máá‑de, te ná kuándéé iní‑de jíín túndó'o kii sɨkɨ̱‑dé, te ná kúndiki̱n‑de ruu̱ kii‑de. ");
INSERT INTO migNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Chi cha̱a jítú iní‑de ka̱ku‑de chi̱i tu̱ndó'o kii sɨkɨ̱‑dé, naa‑dé. Te va̱sa ná kúu̱ ɨɨn cha̱a ja̱ sɨkɨ́ rúu̱, ko kuchaku̱‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Chi na̱ún ní'i̱n cháa va̱sa ná kúndéé‑de ni'i̱n‑dé nɨ́ɨ́ ñúyɨ́vɨ, te nú xnáa‑dé añú‑de. Xí na̱ jíín chúnáa cháa añú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Chi̱ máá Sé'e cha̱a, ndii‑ya̱ jíín táká ndajá'a̱‑yá. Te nduñá'nu‑ya̱ sá'a Táa̱‑ya̱. Yúan‑na te cha̱'u‑ya̱ ɨ́ɨn ɨɨn ña̱yɨvɨ nú ndasa káa tiñu ni̱ ka̱sá'a máá‑i. ");
INSERT INTO migNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Ió sava cha̱a ká'i̱in yá'a ja̱ má kúu̱ kutɨ‑dé onde̱ nú tú kuni̱‑de nuu̱ máá Sé'e cha̱a ndii‑ya̱ ñúu̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yúan‑na te nuu̱ iñú kɨvɨ̱ te ni̱ jaka‑ya̱ Pedro jíín Jacobo jíín ñaní‑de Juan, kua'a̱n sɨ́ɨn‑ya̱ jíín‑de ɨɨn yuku súkún. ");
INSERT INTO migNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Te yúan, tuku ni̱ nduu‑ya̱ núu̱‑dé. Te ni̱ nandii ncháa̱ nuu̱‑yá nátu̱'un ndika̱ndii. Te sa'ma‑yá ni̱ ka̱ndukɨyi̱ nátu̱'un ndua luz ja̱ nándii ndáxín. ");
INSERT INTO migNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Te yúan ni̱ ka̱ndenda Moisés jíín Elías, kándatu̱'ún‑de jíín‑yá, ni̱ kajini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Te ni̱ ka'a̱n Pedro: Táta̱, va̱'a‑ga̱ ná kéndo̱o‑yó yá'a. Nú kuní‑ní te sá'a‑ná uni̱ ve'e kuii. Ɨɨn kuu máá‑ní, ɨnga̱ kuu Moisés, te ɨnga̱ kuu Elías, áchí‑de jíín Jesús. ");
INSERT INTO migNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Te nini ká'a̱n‑de, te ni̱ chaa̱ ɨɨn viko̱ nu̱'ún. Te ni̱ jasu̱ nɨ́ɨ́ núu̱‑dé. Te ni̱ kenda luz chi̱i. Te ni̱ kenda ɨɨn tu̱'un ja̱ ní ka'a̱n: Ya̱'á kúu Se̱'e‑ri̱, ja̱ kúndá'ú ini̱‑ri̱‑i. Te kúsɨɨ̱ iní‑ri̱ jíín‑i. Ná kúni ná'ín‑ró tú'un ká'a̱n‑i núsáá. Achí Dios. ");
INSERT INTO migNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Te tu̱'un yá'a ni̱ ka̱jini so̱'o cha̱a káskuá'a‑ún. Te ni̱ kandua̱ ndee‑ni‑de, chi̱ ni̱ kayu̱'ú xaa̱n‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yúan‑na te ni̱ jaa̱ Jesús. Te ni̱ skandá‑ya̱‑dé. Te ni̱ ka'a̱n‑ya̱: Nduko̱o, ma̱ yú'ú‑ro̱ jíná'an‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Te ni̱ ka̱ndakoto‑de. Te tuká ni ɨɨn na̱ún ní kájini̱‑de, chi̱ máá ɨ́ɨn‑na̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Te kánuu‑de yuku‑ún. Te Jesús ni̱ ka'a̱n xaa̱n‑yá jíín‑de: Ma̱ kachí‑ro̱ núu̱ ní ɨɨn ja̱ súan ni̱ kajini̱‑ro̱, chi̱ onde̱ ná náchaku̱ máá Sé'e cha̱a ma̱'ñú ndɨ́yi, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yúan‑na te cha̱a káskuá'a jíín‑yá, ni̱ kajika̱ tu̱'ún‑de‑ya̱: Te cha̱a káchaa tutu̱, naja̱ káka'a̱n‑de ja̱ kánúú ndíi Elías xna'a̱n‑ga̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Te ni̱ ka'a̱n Jesús jíín‑de: Ja̱ndáa̱ kúu ja̱ ndíi Elías xna'a̱n‑ga̱, te nasájáá‑de ta̱ká ndatíñu. ");
INSERT INTO migNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ko ká'a̱n‑ri̱ jíín‑ró, ja̱ á ni̱ ndii Elías, te tú ní kánakuni̱‑i‑de. Te ni̱ ka̱sá'a‑i ta̱ká ja̱ ní ka̱kuu ini̱‑i jíín‑de. Te suni súan xndó'o‑i máá Sé'e cha̱a. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yúan‑na te cha̱a káskuá'a‑ún, ni̱ kaju̱ku̱'un ini̱‑de ja̱ tú'un Juan, cha̱a ni̱ skuánducha, kúu ja̱ ní ka'a̱n‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Te ni̱ naja̱koyo‑ya̱ núu̱ ñáyɨvɨ kuá'a̱‑ún. Te ni̱ chaa̱ ɨɨn cha̱a nuu̱ Jesús. Te ni̱ jukuiñi̱ jítɨ́‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Te ni̱ ka'a̱n‑de: Táta̱, kundá'ú ini̱‑ní se̱'e‑ná, chi̱ jí'i̱ yi̱'ɨ́‑i, te ndó'o xaa̱n‑í. Te tɨnɨ̱ jínu nduá‑i nuu̱ ñú'u̱n, te tɨnɨ̱ jínu nduá‑i nuu̱ ndúcha. ");
INSERT INTO migNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Te ni̱ kinchaka‑ná‑i nuu̱ cháa káskuá'a jíín‑ní, te tú kákuu sá'a‑de tana̱‑í, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Te ni̱ ka'a̱n Jesús: Ña̱yɨvɨ xáa̱n ní'in ini̱ kákuu‑ró já tú kákandíja‑ró. Na̱saa‑ga̱ kɨvɨ̱ kúnchaa̱‑ri̱ jíín‑ró. Te na̱saa‑ga̱ kɨvɨ̱ ndó'o‑ri̱ jíín‑ró. Kua̱'a‑i ná kíi‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Te Jesús, ni̱ ka'a̱n xaa̱n‑yá nuu̱ tachí kíni‑ún, te ni̱ kenda kua'a̱n ini̱ su̱chí‑ún. Te ni̱ nduva̱'a‑ni‑i máá hora‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yúan‑na te ni̱ ja̱koyo sɨ́ɨn cha̱a káskuá'a‑ún nuu̱ Jesús, te ni̱ kaka'a̱n‑de: Naja̱ tú ní kákuu kiñi'in‑ná ki'i̱n, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Te ni̱ kachi̱ Jesús jíín‑de: Sɨkɨ̱ já tú kákandíja va̱'a‑ró ní kuu yu̱án. Chi̱ ká'a̱n ndaa̱‑ri̱ jíín‑ró, ja̱ nú kákandíja‑ró, va̱sté ɨ́ɨn tí'li̱ nátu̱'un ɨɨn ndɨkɨn yuá mostaza, te kachi̱‑ro̱ kúni yuku yá'a: Kuxio yá'a te kuá'án onde̱ yúan, achi̱‑ro̱, te ki'i̱n. Te kuu sá'a‑ró táká tiñu súan. ");
INSERT INTO migNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ko ɨɨn tá'an yu̱án ni ma̱ kénda kutɨ kí'i̱n, te nú tú kaka̱n ta'u̱‑yo̱ te kondicha̱ ini̱‑yo̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Te nini ká'i̱in‑ya̱ iní ñuu̱ Galilea, te ni̱ kachi̱ Jesús jíín‑de: Máá Sé'e cha̱a natu̱u‑ya̱ núu̱ ndá'a sáva‑ga̱ cha̱a. ");
INSERT INTO migNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Te ka'ni‑dé‑ya̱. Ko nuu̱ uní kɨvɨ̱ te nachaku̱‑ya̱, áchí‑ya̱. Te máá‑de, ni̱ kandukuí'a̱ xaa̱n iní‑de. ");
INSERT INTO migNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Te ni̱ ja̱koyo‑ya̱ ñúu̱ Capernaum. Te cha̱a kájika̱n poniná, ni̱ cha̱koyo‑de nuu̱ Pedro. Te ni̱ kaka'a̱n‑de: Te Maestro máá‑ró, tú kua̱'a‑de poniná náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Te Pedro: Kuu, áchí‑de. Te ni̱ ndɨ̱vɨ‑de ini̱ ve̱'e. Te ni̱ ka'a̱n Jesús xna'a̱n‑ga̱ jíín‑de: Na̱ún kachí‑ro̱. Ta̱ká cha̱a rey ini̱ ñu̱yɨ́vɨ yá'a, ndénu̱ kájika̱n‑de poniná. Á nuu̱ sé'e‑de xí núu̱ cháa sɨ́ɨn ve'e, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Te ni̱ kachi̱ Pedro jíín‑yá: Nuu̱ cháa sɨ́ɨn ve'e kájika̱n‑de, áchí‑de. Te ni̱ kachi̱ Jesús jíín‑de: Te se̱'e‑de ká'i̱o libre‑i núsáá. ");
INSERT INTO migNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ko náva̱'a tú skití ini̱‑yo̱‑dé, te kuá'án onde̱ yu'u mar, te skɨ́vɨ‑ró gancho, te katɨɨn‑ró tíyáká kénda xna'a̱n‑ga̱. Te ndɨka̱‑ro̱ yú'u‑tɨ́. Te yúan ni'i̱n‑ro̱ ɨ́ɨn peso. Te kua̱'a‑ró núu̱‑dé ja̱ kúu ruu̱ jíín róó. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Te suni kɨvɨ̱‑ún ni̱ cha̱koyo cha̱a káskuá'a‑ún nuu̱ Jesús. Te ni̱ kaka'a̱n‑de jíín‑yá: Ndé cha̱a kúñá'nu‑ga̱ ini̱ ñuu̱ nátu̱'un andɨ́vɨ́, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Te ni̱ kana Jesús xini̱ ɨ́ɨn su̱chí lúlí. Te ni̱ jani‑ya̱‑í ma̱'ñú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Te ni̱ kachi̱‑ya̱: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ nú tú naxíó káva ini̱‑ro̱ te nduu‑ró nátu̱'un ɨɨn su̱chí lúlí, ma̱ kɨ́vɨ kutɨ‑ro iní ñuu̱ nátu̱'un andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chi̱ nú ndé cha̱a sásúchí‑de máá‑de nátu̱'un su̱chí lúlí yá'a, cha̱a‑ún kúñá'nu‑ga̱ ini̱ ñuu̱ nátu̱'un andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Te cha̱a ja̱ jíín sɨ́'vɨ́‑rí játá'ú‑de ɨɨn su̱chí lúlí nátu̱'un su̱chí yá'a, te ruu̱ játá'ú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Te nú ɨɨn su̱chí lúlí yá'a kándíja‑i ruu̱, te kɨ̱vɨ‑i kua̱chi sá'a ɨɨn cha̱a, te va'a̱‑ga̱ nú ní nú'ni̱ ɨɨn yo̱só ká'nu suku̱n cháa‑ún, te ke̱e‑de ki'i̱n‑de xuu̱ ndúcha mar núú. ");
INSERT INTO migNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Naka̱ ndá'ú ña̱yɨvɨ iní ñu̱yɨ́vɨ, chi̱ kájito nchaa̱‑de‑i kásá'a‑i kua̱chi, te jínu ñú'ún já kóo kɨvɨ̱‑ún. Ko naka̱ ndá'ú cha̱a ja̱ skɨ́vɨ‑de‑i ini̱ kua̱chi. ");
INSERT INTO migNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Núsáá te nú nda'a‑ro xí já'a̱‑ro̱ kuní skɨ́vɨ róó nuu̱ íó kua̱chi, xɨtɨ te skána‑ró ná kí'i̱n. Va'a̱‑ga̱ ja̱ kóo rengo‑ro̱ xí kóo tɨ́kú'lu‑ró kúchaku̱‑ro̱ nɨ́ɨ́ káni, nasu̱ já kóo ndendúú nda'a‑ro xí ndéndúú ja'a̱‑ro̱ kí'i̱n‑ro̱ núu̱ ñú'u̱n nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Te nú nduchi‑ro kuní skɨ́vɨ róó nuu̱ íó kua̱chi, tava te skána‑ró ná kí'i̱n. Va'a̱‑ga̱ ja̱ kúchaku̱‑ro̱ jíín ɨ́ɨn‑ni nduchi‑ro, nasu̱ já kóo ndendúú nduchi‑ro kí'i̱n‑ro̱ núu̱ ñú'u̱n infierno. ");
INSERT INTO migNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Koto‑ró máá‑ró jíná'an‑ró. Ma̱ sájá'a̱ ini̱‑ro̱ núu̱ ɨ́ɨn su̱chí lúlí yá'a. Chi̱ a ká'a̱n‑ri̱ jíín‑ró já ndájá'a̱‑í ká'i̱o andɨ́vɨ́, nene̱ kájini̱‑ya̱ núu̱ máá Táa̱‑ri̱ ja̱ kánchaa̱‑ya̱ ondé andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Chi̱ máá Sé'e cha̱a, ni̱ kii‑ya̱ já náma‑ya̱ táká ña̱yɨvɨ já á ni̱ naa. ");
INSERT INTO migNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ndasa kájani ini̱‑ro̱. Nú ɨɨn cha̱a ñáva̱'a‑de ɨɨn ciento rɨɨ̱, te skuíta‑de ɨɨn‑tɨ̱. Á tú xndóo‑de kuu̱n xíko xia'u̱n kuu̱n‑gá‑tɨ̱, te ki'i̱n‑de onde̱ yuku kína̱ndúkú‑de kɨtɨ ní sa̱na‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Te nú ni̱ nani'i̱n‑dé‑tɨ̱, ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ja̱ kúsɨɨ̱‑gá ini̱‑de jíín kɨ́tɨ‑ún vásá jíín kúu̱n xíko xia'u̱n kuu̱n‑gá kɨtɨ tú ni̱ kása̱na‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Te súan máá Táa̱‑ro̱ I'a̱ kánchaa̱ onde̱ andɨ́vɨ́, tú játa'a̱n ini̱‑ya̱ já náa ní ɨɨn tá'an su̱chí lúlí yá'a. ");
INSERT INTO migNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Núsáá te nú ñani̱‑ro̱ ní sá'a‑de kua̱chi sɨkɨ̱‑ro̱, te kuá'án, te kastu̱'ún sá'í‑ro̱ núu̱‑dé na̱ún kua̱chi ni̱ sá'a‑de. Te nú ni̱ chu'un ini̱‑de tu̱'un ká'a̱n‑ro̱ jíín‑de, yúan‑na te a ni̱ ndumani̱‑dé jíín‑ró sá'a‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ko nú tú ní chú'un ini̱‑de tu̱'un ká'a̱n‑ro̱, te kuaka uu̱ xí uní‑ga̱ ña̱yɨvɨ kí'i̱n jíín‑ró, náva̱'a jíín tú'un ká'a̱n uu̱ xí uní testigo te kundaa̱ ta̱ká tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te nú tú ní chú'un ini̱‑de tu̱'un ká'a̱n cha̱a‑ún, te kastu̱'ún‑ró núu̱ tɨ́ku'ni̱ kándíja. Te nú suni tú ní chú'un ini̱‑de tu̱'un ká'a̱n tɨku'ni̱‑ún, te sía̱‑ro̱‑dé ná kúu‑de nátu̱'un ɨɨn cha̱a sɨ́ɨn nación xí ɨ́ɨn cha̱a xíní. ");
INSERT INTO migNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ta̱ká ja̱ kú'ni̱‑ro̱ iní ñu̱yɨ́vɨ yá'a, kunu'ni̱ ini̱ andɨ́vɨ́. Te ta̱ká ja̱ ndájí‑ró iní ñu̱yɨ́vɨ yá'a, ndaji iní andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ɨnga̱ tu̱'un ká'a̱n‑ri̱ jíín‑ró, ja̱ nú uu̱ tá'a̱n‑ro̱ iní ñu̱yɨ́vɨ yá'a, koo conforme‑ro̱ sɨkɨ́ ɨ́ɨn tu̱'un ja̱ kájika̱n ta'u̱‑ro̱, te máá Táa̱‑ri̱ onde̱ andɨ́vɨ́ skíkuu‑ya̱ tú'un‑ún jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chi̱ nú ni̱ ka̱nataka̱ uu̱ xí uní ña̱yɨvɨ káchiñú'ún‑i ruu̱ jíín sɨ́'vɨ́‑rí, te yúan kánchaa̱‑ri̱ ma̱'ñú‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yúan‑na te ni̱ jaa̱ Pedro nuu̱‑yá. Te ni̱ ka'a̱n‑de jíín‑yá: Táta̱, na̱saa jínu sá'a‑ná tu̱ká'nu ini̱ nuu̱ ñaní‑ná ja̱ sá'a‑de kua̱chi nuu̱‑ná. Onde̱ usia̱ jínu náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Te ni̱ kachi̱ Jesús: Tú ká'a̱n‑ri̱ jíín‑ró já ondé usia̱ jínu, chi̱ onde̱ kuu̱n ciento kuu̱n xíko uxi̱ jínu. ");
INSERT INTO migNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ja̱ yúán máá ñúu̱ nátu̱'un andɨ́vɨ́ kúu nátu̱'un ɨɨn cha̱a kúu rey, ja̱ ní kuni̱‑de sándaa̱‑de cuenta jíín mozo‑de. ");
INSERT INTO migNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Te ni̱ kejá'á‑de násá'a‑de cuenta. Te yúan ni̱ jaa̱ ɨɨn cha̱a taú ɨɨn millón peso nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Te tú ní kúu chunáa cháa yúan. Te ni̱ tá'ú tíñu jito'o̱‑de ja̱ ná kúya̱'u‑de jíín sé'e‑de jíín ñásɨ́'ɨ́‑de jíín táká ndatíñu ñáva̱'a‑de te nakunáa xú'ún taú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yúan‑na te ni̱ jukuiñi̱ jítɨ́ mozo‑ún. Te ni̱ ka'a̱n nda̱'ú‑de jíín rey‑ún: Táta̱, kundatu‑ní, te vásá ná chúnáa ndɨ́'ɨ‑ná xu̱'ún‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Te máá jíto'o̱‑ún, ni̱ kundá'ú ini̱‑de mozo‑de. Te ni̱ sía̱‑de kua'a̱n. Te ni̱ sá'a‑de tu̱ká'nu ini̱ ja̱ taú mozo‑de‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ko mozo‑ún nuu̱ ní kenda‑de kua'a̱n‑de, te ni̱ ketá'an‑de jíín ɨ́ɨn tá'an mozo‑de ja̱ taú uxi̱ peso nuu̱‑dé. Te ni̱ katɨɨn cha̱a‑ún. Te ni̱ kɨtɨ‑dé suku̱n cháa‑ún. Te ni̱ ka'a̱n‑de: Chunáa ndɨ́'ɨ ja̱ taú‑ro̱ núu̱‑rí, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yúan‑na te tá'an mozo‑de‑ún, ni̱ jukuiñi̱ jítɨ́ núu̱‑dé. Te ni̱ ka'a̱n nda̱'ú jíín‑de: Kundatu te vásá ná chúnáa ndɨ́'ɨ‑ri̱ xu̱'ún‑ró, áchí mozo‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ko máá‑de, tú ní kuní‑de, chi ni̱ chindee‑de cha̱a‑ún veka̱a onde̱ kɨvɨ̱ ní naku̱náa já taú cháa‑ún nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Te ni̱ kajini̱ tá'an mozo‑de‑ún ja̱ ní ta'a̱n‑de. Te ni̱ ka̱kuxíí xáa̱n iní‑de. Te ni̱ cha̱koyo‑de. Te ni̱ ka̱nakani ndɨ'ɨ‑de tu̱'un nuu̱ jíto'o̱‑de ja̱ ní ta'a̱n cha̱a‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yúan‑na te jito'o̱‑ún, ni̱ kana‑de xini̱ mozo ñáá‑ún ni̱ jaa̱. Te ni̱ ka'a̱n‑de: Mozo ndɨva̱'a kúu‑ró, chi ta̱ká ja̱ taú‑ro̱‑ún ni̱ sá'a‑ri̱ tu̱ká'nu ini̱ nuu̱‑ro̱, chi ni̱ ka'a̱n nda̱'ú‑ro̱ jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Te nátu̱'un ni̱ kundá'ú ini̱‑ri̱ róó, suni súan ní kúndá'ú ini̱‑ro̱ tá'an mozo‑ro̱ núú, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yúan‑na te ni̱ kiti̱ ini̱ jito'o̱‑ún nuu̱‑dé. Te ni̱ chi'i‑de cha̱a nda'a justicia, onde̱ ni̱ nachunáa‑dé ta̱ká ja̱ taú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Suni súan sá'a máá Táa̱‑ri̱ andɨ́vɨ́ jíín‑ró te nú tú sá'a‑ró túká'nu ini̱‑ro̱ núu̱ táká ñani̱‑ro̱, onde̱ jíín iní jíín añú‑ro̱ nú na̱ún kua̱chi sá'a‑de jíín‑ró, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Te ni̱ ndɨ'ɨ ni̱ ka'a̱n Jesús ta̱ká tu̱'un yá'a. Te ni̱ kenda‑ya̱ iní ñuu̱ Galilea kua'a̱n‑ya̱. Te ni̱ jaa̱‑ya̱ yúñúu̱ Judea, ɨnga̱ lado yu̱cha Jordán. ");
INSERT INTO migNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Te kua'a̱ ñáyɨvɨ, ni̱ kandiki̱n‑i‑ya̱ kuá'a̱n‑i jíín‑yá. Te yúan ni̱ nasáva̱'a‑ya̱‑í jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yúan‑na te ni̱ ja̱koyo yaku̱ cha̱a fariseo nuu̱‑yá, ja̱ kóto nchaa̱‑de‑ya̱ kákuni̱‑de. Te ni̱ kaka'a̱n‑de: Va̱tu‑ni kuu xndóo ɨɨn cha̱a ñasɨ́'ɨ́‑de ja̱ sɨkɨ́ na̱ni kua̱chi kúu, xí túu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ko máá‑yá, ni̱ ka'a̱n‑ya̱: Á tú ní káka'u‑ró tutú ndasa ni̱ sá'a Dios cha̱a onde̱ xnáñúú, chi̱ ja̱ yíí jíín já sɨ̱'ɨ́ ní sá'a‑ya̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yúan‑na te ni̱ ka'a̱n Dios: Ja̱ yúán xndóo cha̱a táa̱‑de náa̱‑de, te kétá'an‑de jíín ñásɨ́'ɨ́‑de. Te ɨɨn‑na̱ ña̱yɨvɨ kúu ndendúú‑de. Achí Dios. ");
INSERT INTO migNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Súan kúu ja̱ ná tuká kúu uu̱, chi̱ ɨɨn‑na̱ kúu. Núsáá te ma̱ sásɨ́ɨn ɨɨn cha̱a ja̱ á ni̱ skétá'an Dios, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Te ni̱ kakachi̱‑de jíín‑yá: Te Moisés, naja̱ ní tá'ú‑de tiñu ja̱ kúva̱'a akta ndusɨ́ɨn, te ndo̱o‑ña núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Te ni̱ ka'a̱n‑ga̱‑ya̱ jíín‑de: Sɨkɨ̱ já ní'in ini̱ añú‑ro̱ jíná'an‑ró, yu̱án ní jatu̱'un Moisés ja̱ xndóo‑ró ñásɨ́'ɨ́‑ro̱. Ko onde̱ xnáñúú, tú súan ní kúu. ");
INSERT INTO migNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ko ruu̱, ká'a̱n‑ri̱ jíín‑ró, nú ndé cha̱a xndóo‑de ñasɨ́'ɨ́‑de, nasu̱ já tɨnɨ́ ini̱‑ña, te ta̱nda'a‑dé jíín ɨngá‑ña, ísɨ́kɨ ncháa̱‑de ñasɨ́'ɨ́‑de. Te cha̱a ta̱nda'a jíín ñá'an ní ndo̱o, suni ísɨ́kɨ ncháa̱‑de‑ña, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Te ni̱ kaka'a̱n cha̱a káskuá'a jíín‑yá: Nú súan íó tiñu ta̱ká cha̱a jíín ñásɨ́'ɨ́‑de, va'a̱‑ga̱ ma̱ tánda'a‑dé núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín‑de: Nasu̱ táká cha̱a juku̱'un ini̱‑de tu̱'un yá'a, chi cha̱a ni̱ ja̱'a‑ri̱ tu̱'un nuu̱‑dé, cha̱a yúan kájuku̱'un ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ió cha̱a kákuu eunuco onde̱ kɨvɨ̱ ní kaku‑de chi̱i náa̱‑de, te íó cha̱a kákuu eunuco ni̱ sá'a ɨnga̱ cha̱a jíín‑de, te íó cha̱a kákuu eunuco ni̱ ka̱sá'a máá‑de ja̱ sɨkɨ́ ñúu̱ nátu̱'un andɨ́vɨ́. Cha̱a ja̱ kúu juku̱'un ini̱‑de, ná júku̱'un ini̱‑de núsáá. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yúan‑na te ni̱ cha̱koyo ña̱yɨvɨ jíín súchí lúlí‑i, ja̱ ná cháa‑ya̱ ndá'a‑yá xini̱‑í, te ná kakán ta'u̱‑yá ja'a̱‑í. Te cha̱a káskuá'a jíín‑yá, ni̱ kaka'a̱n xaa̱n‑dé jíín ñáyɨvɨ‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Te ni̱ ka'a̱n Jesús: Sía̱ ná kíkoyo su̱chí lúlí núu̱‑rí, te ma̱ kasú‑ro̱ íchi‑í, chi̱ nátu̱'un su̱chí yá'a kákuu ja̱ kúu kɨ̱vɨ ini̱ ñuu̱ nátu̱'un andɨ́vɨ́, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Te ni̱ chaa‑ya̱ ndá'a‑yá xini̱‑í jíná'an‑i. Te ni̱ kuxio‑ni‑ya̱ yúan kua'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Te yúan ni̱ jaa̱ ɨɨn cha̱a súchí núu̱‑yá, ni̱ ka'a̱n‑de jíín‑yá: Cha̱a va̱'a kúu‑ní Maestro. Na̱ún tiñu sá'a‑ná te ni'i̱n tá'u̱‑ná kuchaku̱‑ná nɨ́ɨ́ káni. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Te ni̱ kachi̱‑ya̱ jíín‑de: Naja̱ ká'a̱n‑ro̱ cháa va̱'a jíín‑rí. Tú ni ɨɨn cha̱a va̱'a íó, chi̱ máá ɨ́ɨn‑ni Dios. Nú kuní‑ro̱ kúchaku̱‑ro̱, te skíkuu‑ró tíñu ni̱ tá'ú‑yá. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Te ni̱ kachi̱‑de jíín‑yá: Ndéja̱ kúu núsáá, áchí‑de. Te Jesús, ni̱ ka'a̱n‑ya̱: Ma̱ ká'ni‑ro ndɨ́yi, ma̱ kúsɨ́kɨ ncháa̱ tá'an‑ro, ma̱ sákuí'ná‑ró, ma̱ ká'a̱n‑ro̱ tú'un tú'ún, ");
INSERT INTO migNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kuandatu̱ nuu̱ táa̱‑ro̱ nuu̱ náa̱‑ro̱, te kundá'ú ini̱‑ro̱ tá'an‑ró nátu̱'un kúndá'ú ini̱‑ro̱ máá‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Te ni̱ kachi̱ cha̱a súchí jíín‑yá: Ta̱ká tiñu yá'a, a ni̱ skíkuu‑ná onde̱ ná lúlí‑ná. Na̱ún sá'a‑ga̱‑ná núsáá. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Te ni̱ kachi̱ Jesús jíín‑de: Nú kuní‑ro̱ kéndo̱o va̱'a‑ró, kuá'án, te xi̱kó‑ró já ñáva̱'a‑ró, te kua̱'a‑ró núu̱ ñáyɨvɨ ndá'ú. Te onde̱ andɨ́vɨ́ kóo yaji̱‑ro̱. Yúan‑na te kii‑ró kúndiki̱n‑ro̱ rúu̱ ki'o̱n, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Te cha̱a súchí‑ún ja̱ ní jini so̱'o‑de tu̱'un yá'a, te kua'a̱n‑de kúxíí iní‑de, chi̱ kua'a̱ xáa̱n ndátíñu ñáva̱'a‑de. ");
INSERT INTO migNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yúan‑na te ni̱ kachi̱ Jesús jíín cháa káskuá'a jíín‑yá: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ xáa̱n ú'u̱ kɨ́vɨ ɨɨn cha̱a kúká iní ñuu̱ nátu̱'un andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ko ruu̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ yachí‑ga̱ ja̱'a ɨɨn camello yau̱ yikɨ tɨ́kuɨ́, vásá ɨ́ɨn cha̱a kúká kɨ́vɨ‑de ini̱ ñuu̱ nuu̱ tá'ú Dios tiñu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ko cha̱a káskuá'a jíín‑yá, súan ni̱ ka̱jini so̱'o‑de tu̱'un yá'a, te ni̱ kayu̱'ú xaa̱n‑dé. Te ni̱ kaka'a̱n‑de: Ndé cha̱a ka̱ku núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Te ni̱ ndakoto Jesús nuu̱‑dé. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Jíín cháa ma̱ kúu kutɨ, ko ta̱ká‑ni tiñu ndɨ'ɨ‑ni kúu sá'a Dios, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yúan‑na te ni̱ ka'a̱n Pedro jíín‑yá: Náá, ni̱ ka̱skéndo̱o‑ná ta̱ká ndatíñu‑ná, te káindiki̱n‑ná níí va̱i‑yó. Na̱ún ní'i̱n‑ná núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Te ni̱ ka'a̱n Jesús jíín‑de: Ja̱ndáa̱ ká'a̱n máá Sé'e cha̱a jíín‑ró jíná'an‑ró, ja̱ kɨvɨ́ kúnchaa̱‑ri̱ mesa‑ri̱ te nduñá'nu‑ri̱ ini̱ ñu̱yɨ́vɨ jáá, kɨvɨ̱‑ún te kunchaa̱‑ro̱ núu̱ uxí uu̱ silla. Te sándaa̱‑ro̱ tíñu ndɨ́'uxí uu̱ tata̱ cha̱a Israel, chi̱ kándiki̱n‑ro̱ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Te cha̱a skéndo̱o ve'e‑de, xí ñaní‑de, xí kuá'a‑de, xí táa̱‑de, xí náa̱‑de, xí sé'e‑de, xí ñú'un‑dé ja̱ sɨkɨ́ rúu̱, te nani'i̱n‑dé ɨɨn ciento vuelta. Te suni ni'i̱n tá'u̱‑dé kuchaku̱‑de nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Te kua'a̱ cháa kúnúú, nduu‑de sandɨ̱'ɨ́‑na̱. Te cha̱a sandɨ̱'ɨ́‑na̱, ndunúú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Chi̱ ñuu̱ nátu̱'un andɨ́vɨ́ kúu nátu̱'un ɨɨn cha̱a kúu jito'o̱ ve'e, ja̱ ní kenda‑de ɨɨn ja̱ñá'a̱n, ndúkú‑de cha̱a sátiñu nuu̱ itú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Te ni̱ sándaa̱‑de jíín cháa kásátiñu‑ún ja̱ chá'u‑de ɨɨn peso ja̱ kɨvɨ́. Te ni̱ tájí‑de cha̱a‑ún kua̱ngoyo‑de nuu̱ itú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Te suni ni̱ kenda‑de nátu̱'un ka̱'ɨɨ̱n. Te ni̱ jini̱‑de nuu̱ sáva‑ga̱ cha̱a ká'i̱in sáni‑de nu̱yá'u. ");
INSERT INTO migNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Te ni̱ kachi̱‑de jíín cháa‑ún: Kuángoyo nuu̱ itú‑ri̱, chi cha̱'u va̱'a‑ri̱ róó, áchí‑de. Te máá cháa‑ún kua̱ngoyo‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Te ni̱ kenda tuku‑de nátu̱'un ka̱'uxi̱ uu̱ jíín ká'uni̱. Te suni súan ni̱ sá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Te a yani ka̱'u'u̱n ni̱ kenda tuku‑de. Te ni̱ ketá'an‑de jíín yakú‑ga̱ cha̱a ká'i̱in sáni. Te ni̱ kachi̱‑de jíín cháa‑ún: Naja̱ ká'i̱in kúxí‑ró yá'a nɨ́ɨ́ ncháka ncháa, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Te ni̱ kakachi̱ cha̱a‑ún jíín‑de: Kua̱chi ja̱ tú na̱ún ká'a̱n jíín‑ná ja̱ sátiñu‑ná. Te ni̱ kachi̱‑de jíín máá cháa‑ún: Kuángoyo nuu̱ itú‑ri̱, chi cha̱'u va̱'a‑ri̱ róó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Te nuu̱ ní ini kɨvɨ̱‑ún, te ni̱ kachi̱ jito'o̱ itu̱‑ún jíín mandador: Kana xini̱ cháa ká'i̱in nuu̱ tíñu te cha̱'u‑ró‑de, onde̱ cha̱a ni̱ chaa̱ sandɨ̱'ɨ́‑na̱ te onde̱ cha̱a ni̱ chaa̱ núú, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Te ni̱ chaa̱ cha̱a ni̱ ja̱koyo onde̱ ka̱'u'u̱n aíni‑ún. Te ni̱ ka̱ki'in‑de peso peso ya̱'u‑de ja̱ ɨ́ɨn ɨɨn‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Te ni̱ chaa̱ cha̱a ni̱ ja̱koyo núú yúan. Te kájani ini̱‑de ja̱ ví'í‑gá ki'in ya̱'u‑de. Ko suni ɨɨn peso ni̱ ka̱ki'in ɨɨn ɨɨn‑de jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Te ni̱ ka̱ki'in‑de ya̱'u‑de‑ún. Te ni̱ ka̱ndonda vaa̱‑de káka'a̱n‑de sɨkɨ̱ jíto'o̱ ve'e‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Cha̱a sandɨ̱'ɨ́‑na̱ yá'a ɨɨn hora‑ni ni̱ ka̱sátiñu‑de, te ɨɨn núú‑ni ni̱ cha̱'u‑ní‑de jíín‑ná ja̱ xáa̱n ní'ní te ni̱'in ni̱ ka̱sátiñu‑ná ncháka ncháa, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Te máá jíto'o̱ ni̱ kachi̱‑de jíín ɨ́ɨn‑de: Amigo, tú sá'a ndɨva̱'a‑ri̱ jíín‑ró. Nasu̱ ní sándaa̱‑yo̱ já ɨ́ɨn peso ki'in‑ró náún. ");
INSERT INTO migNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ki'in ya̱'u‑ró te no'o̱n‑ro̱, chi̱ ruu̱ kuní‑ri̱ cha̱'u‑ri̱ cha̱a sandɨ̱'ɨ́‑na̱ yá'a nátu̱'un ni̱ cha̱'u‑ri̱ róó. ");
INSERT INTO migNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tú kuu sá'a‑ri̱ ja̱ kuní‑ri̱ jíín já xíin máá‑rí náún, xí kúkuásún iní‑ro̱ já vá'a ni̱ cha̱'u‑ri̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Súan kúu ja̱ táká cha̱a núú, nduu‑de sandɨ̱'ɨ́‑na̱. Te cha̱a sandɨ̱'ɨ́‑na̱‑ún, nduu núú‑de. Chi̱ kána‑ya̱ xiní kuá'a̱ ñáyɨvɨ, ko yaku̱‑ni‑i káji‑ya̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Te ni̱ kaa Jesús kua'a̱n‑ya̱ íchi ñúu̱ Jerusalén. Te ni̱ jaka sɨ́ɨn‑ya̱ ndɨ́'uxí uu̱ cha̱a káskuá'a jíín‑yá. Te nini kája'a̱n‑ya̱ te ni̱ ka'a̱n‑ya̱ jíín‑de: ");
INSERT INTO migNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ná kuní‑ro̱, chi̱ kaa‑yó kí'i̱n‑yo̱ ñúu̱ Jerusalén. Te yúan natu̱u máá Sé'e cha̱a nuu̱ táká sutu̱ ñá'nu jíín núu̱ cháa káchaa tutu̱, te ka'ni‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Te nachi'i‑de‑ya̱ ndá'a ñáyɨvɨ sɨ́ɨn nación, náva̱'a sákátá‑i nuu̱‑yá. Te kua̱'a‑i ta'u̱‑yá. Te ka'ni‑í‑ya̱ jiká cruz. Ko nuu̱ uní kɨvɨ̱ te nachaku̱‑ya̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yúan‑na te ni̱ jaa̱ náa̱ se̱'e Zebedeo nuu̱‑yá jíín sé'e‑ña. Te ni chiñú'ún‑ña‑yá, jikán‑ña ɨ́ɨn favor nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Te máá‑yá, ni̱ ka'a̱n‑ya̱ jíín‑ña: Na̱ún kuní‑ro̱, áchí‑ya̱. Te ni kachi̱‑ña jíín‑yá: Kua̱'a‑ni xiin‑ni kuxiu̱kú ndéndúú se̱'e‑ná yá'a jíín‑ní, ɨɨn‑i ichi ndává'a‑ní, te ɨnga̱‑i ichi ndávésé‑ní, kɨvɨ̱ tá'ú‑ní tiñu ini̱ ñuu̱‑ní, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yúan‑na te ni̱ ka'a̱n Jesús: Tú kájini̱‑ro̱ na̱ún kúu ja̱ kájika̱n‑ro̱. Á kuu ndo'o ta'a̱n‑ro̱ jíín‑rí jíín túndó'o kii sɨkɨ̱‑rí, xí kúu kuanducha‑ro núu̱ ní janducha‑rí. Achí‑ya̱. Te máá‑de ni̱ kaka'a̱n‑de: Kuu sá'a‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ja̱ndáa̱ ja̱ ndó'o ta'a̱n‑ro̱ jíín‑rí jíín túndó'o kii sɨkɨ̱‑rí, te nuu̱ ní janducha‑rí, kuanducha‑ro. Ko ja̱ kúxiu̱kú‑ró íchi ndává'a‑ri̱ jíín íchi ndávésé‑rí, nasu̱ máá‑rí tá'ú tíñu ja̱ kuá'a‑ri̱ nuu̱‑ro̱, chi̱ máá Táa̱‑ri̱ jiní ndé cha̱a ni'i̱n, chi̱ a ni̱ sátu̱'a‑ya̱ já kúxiu̱kú cháa‑ún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Te uxi̱‑ga̱ cha̱a‑ún, ni̱ ka̱jini so̱'o‑de tu̱'un yá'a. Te ni̱ kakiti̱ ini̱‑de nuu̱ úu̱ ñani̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yúan‑na te Jesús, ni̱ kana‑ya̱ xiní‑dé. Te ni̱ kachi̱‑ya̱ jíín‑de: Kájini̱‑ro̱ já cháa kákuñá'nu nuu̱ ñáyɨvɨ sɨ́ɨn nación, tá'ú téyíí‑de tiñu nuu̱‑í. Te ja̱ kákuñá'nu sɨkɨ̱ máá‑de, suni kátɨ̱ɨn ni̱'in so̱'o‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ko sɨkɨ̱ róó jíná'an‑ró, na̱ tú súan koo. Chi̱ nú ndé róó kuní kuñá'nu nuu̱ tá'an‑ró, te róó kúu ja̱ kuátíñu nuu̱ tá'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Te nú ndé róó kuní kunúú, yu̱án ndúu mozo nuu̱ táká‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nátu̱'un máá Sé'e cha̱a, chi̱ tú va̱i‑ya̱ já kuátíñu ña̱yɨvɨ núu̱‑yá, chi̱ sua játíñu‑ya̱ núu̱ ñáyɨvɨ, te katañaa‑ya̱ máá‑yá kuu̱‑ya̱ já nákuaan‑ya̱ kuá'a̱ ñáyɨvɨ, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yúan‑na te ni̱ kenda koyo‑ya̱ iní ñuu̱ Jericó. Te kua'a̱ xáa̱n ñáyɨvɨ, ni̱ kandiki̱n‑i Jesús. ");
INSERT INTO migNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Te yúan káxiu̱kú úu̱ cha̱a kuáá yú'íchi‑ún. Te ni̱ ka̱jini so̱'o‑de ja̱ ní ja̱'a Jesús kua'a̱n‑ya̱, te ni̱ ka̱kana kó'ó‑de: Táta̱ Se̱'e David, kundá'ú ini̱‑ní náá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Te ña̱yɨvɨ‑ún, ni̱ kaka'a̱n xaa̱n‑í jíín‑de ja̱ ná kasú‑de yu'u‑dé. Ko máá‑de, ví'í‑gá ni̱ ka̱kana jaa‑de: Táta̱ Se̱'e David, kundá'ú ini̱‑ní náá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Te ni̱ jukuiñi̱ Jesús. Te ni̱ kana‑ya̱ xiní‑dé. Te ká'a̱n‑ya̱ jíín‑de: Na̱ún sá'a‑ri̱ jíín‑ró kákuni̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Te ni̱ kaka'a̱n‑de jíín‑yá: Táta̱, ja̱ ná ndúndiji̱n nduchi‑ná kákuni̱‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yúan‑na te Jesús ni̱ kundá'ú ini̱‑ya̱‑dé. Te ni̱ ké'é‑yá nduchi‑dé. Te ni̱ ka̱ndundiji̱n‑ni nduchi‑dé. Te ni̱ kandiki̱n‑de‑ya̱ kuá'a̱n‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Te nuu̱ ní ka̱kuyani‑ya̱ ñúu̱ Jerusalén, ni̱ ja̱koyo‑ya ñúu̱ Betfagé chi̱i yuku Olivos. Yúan‑na te ni̱ tájí Jesús uu̱ cha̱a káskuá'a jíín‑yá kua'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Te ká'a̱n‑ya̱ jíín‑de: Kua'án onde̱ ñuu̱ kánchaa̱ nuu̱‑ro̱ jián, te ni'i̱n‑ro̱ ɨ́ɨn burro nú'ni̱‑tɨ jíín ɨ́ɨn burro yɨ́kɨ́n jíín‑tɨ́. Te ndájí‑ró‑tɨ́, te kunchaka‑ró‑tɨ́ kii‑ró jíín‑tɨ́ nuu̱‑rí yá'a. ");
INSERT INTO migNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te nú ndé cha̱a ka'a̱n jíín‑ró, te kachi̱‑ro̱ kúni‑de: máá Jito'o̱‑yo̱ jínu ñú'ún‑yá‑tɨ̱, achi̱‑ro̱. Yúan‑na te sía̱‑ni‑de‑tɨ̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Te súan ni kuu ta̱ká yu̱án náva̱'a skíkuu tu̱'un ni̱ ka'a̱n cha̱a ni̱ jani tu̱'un Dios: ");
INSERT INTO migNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Kachi̱ nuu̱ sésɨ́'ɨ́ ñuu̱ Sion: Yá'a nde̱'é‑ró chi̱ Rey máá‑ró va̱i‑ya̱ núu̱‑ro̱. Vi̱tá ini̱‑ya̱. Te yóso‑yá ɨɨn burro yɨ́kɨ́n se̱'e kɨtɨ ndíso, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Te cha̱a káskuá'a‑ún kája'a̱n‑de. Te ni̱ ka̱sá'a‑de nátu̱'un ni̱ tá'ú Jesús tiñu nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Te káincha̱ka‑de burro jíín burro yɨ́kɨ́n‑ún ni̱ najaa̱‑de nuu̱‑yá. Te ni̱ ka̱chúkú‑de tɨka̱chí‑de sɨkɨ̱‑tɨ́. Te ni̱ jukoso̱‑yá‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Te ña̱yɨvɨ kuá'a̱‑ún, ni̱ kajaki̱n‑i tɨka̱chí‑i ini̱ ichi. Te sava‑ga̱‑i ni̱ kaja'nu̱‑i nda'a yúnu. Te ni̱ kajaki̱n‑i ini̱ ichi‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Te ña̱yɨvɨ kája'a̱n ichi núu̱‑yá jíín ñáyɨvɨ kándiki̱n ichi yatá‑yá, ni̱ kaka'a̱n jaa‑i: Xáán va̱'a Se̱'e David. Ná nákana jaa‑yó‑yá, chi̱ ndíso‑ya̱ tíñu máá Tatá. Xáán va̱'a I'a̱ kúu‑ya̱ ondé andɨ́vɨ́. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Te ni̱ kɨ̱vɨ‑ya̱ iní ñuu̱ Jerusalem. Te ni̱ kuvaa̱ ta̱ká ña̱yɨvɨ ñúu̱‑ún. Ndé cha̱a kúu cha̱a yá'a, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Te ni̱ kaka'a̱n ña̱yɨvɨ‑ún: Cha̱a yá'a kúu Jesús cha̱a jáni tu̱'un Dios. Te onde̱ ñuu̱ Nazaret ndañúu̱ Galilea va̱i‑de. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Te ni̱ kɨ̱vɨ Jesús ini̱ ve̱'e ii̱ Dios. Te ni̱ kiñi'in‑ya̱ ñáyɨvɨ kájaan, káxi̱kó, íin ini̱ ve̱'e ii̱‑ún, kája'a̱n. Te ni̱ skuíó káni‑ya̱ mesa cha̱a káxndáji xu̱'ún, jíín silla cha̱a káxi̱kó paloma. ");
INSERT INTO migNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Te ni̱ ka'a̱n‑ya̱ jíín‑i: A yóso núu̱ tutú: Ve'e‑ri̱, chi̱ ve'e nuu̱ kájika̱n ta'u̱‑í nání, áchí tutu̱. Ko máá‑ró, a ni̱ ka̱nasá'a‑ró yaú kava ñákui̱'ná. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yúan‑na te ña̱yɨvɨ kuáá jíín ñáyɨvɨ rengo, ni̱ ja̱koyo‑i nuu̱‑yá ini̱ ve̱'e ii̱. Te ni̱ nasáva̱'a‑ya̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ko sutu̱ ñá'nu jíín cháa káchaa tutu̱, ni̱ kajini̱‑de ta̱ká tiñu ñá'nu sá'a‑ya̱, jíín núu̱ súchí lúlí kákana jaa‑i ini̱ ve̱'e ii̱‑ún: Xáán va̱'a Se̱'e David, áchí‑i. Te ni̱ kakiti̱ ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Te ni̱ kaka'a̱n‑de jíín‑yá. Á tú jíni so̱'o‑ró já káka'a̱n su̱chí yá'a, áchí‑de. Te ni̱ ka'a̱n Jesús jíín‑de: Á té ka'u‑ga̱‑ro̱ tutú ndasa ká'a̱n: Su̱chí lúlí jíín súchí kájaxin, va̱'a kánakana jaa‑i níí, sá'a‑ní, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Te ni̱ xndóo‑ya̱‑dé. Te ni̱ kenda‑ya̱ ñúu̱ kua'a̱n‑ya̱ ondé ñuu̱ Betania. Te yúan ni̱ kendo̱o‑ya̱ ákuáa‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Te ja̱ñá'a̱n kɨvɨ̱ xía̱n‑ún kua̱no'on‑yá onde̱ ñuu̱, te jí'i̱‑ya̱ sóko. ");
INSERT INTO migNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Te ni̱ jini̱‑ya̱ núu̱ ɨ́ɨn mérkexe̱ kándii̱ yu'íchi‑ún. Te ni̱ jaa̱‑ya̱ núu̱ mérkexe̱‑ún. Te tú kutɨ na̱ún ní ni'i̱n‑yá, chi̱ máá núma‑ní íó. Te ni̱ ka'a̱n‑ya̱ jíín: Ma̱ kúun kutɨ‑gá nde'e̱ xiní‑ro̱, áchí‑ya̱. Te ni̱ ichi̱ káján‑ni mérkexe̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Te cha̱a káskuá'a jíín‑yá, ni̱ ka̱naa iní‑de ja̱ ní kajini̱‑de tiñu yá'a. Te ni̱ kaka'a̱n‑de: Ndasa ni̱ sá'a‑ya̱ já ní ichi̱ káján‑ni mérkexe̱‑ún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Te ni̱ ka'a̱n Jesús: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, nú kákandíja‑ró te tú jáni sɨ̱kɨ́ ini̱‑ro̱, nasu̱ máá ɨ́ɨn tiñu mérkexe̱ yá'a kuu sá'a‑ró, chi̱ suni kuu nú ka'a̱n‑ro̱ jíín yúku yá'a: Kuxio te jungo̱o‑ró ondé nuu̱ mar kundee‑ró, te kuu súan. ");
INSERT INTO migNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te ta̱ká ja̱ kakán ta'u̱‑ro̱, te nú kákandíja‑ró, te ni'i̱n‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Te ni̱ najaa̱‑ya̱ iní ve̱'e ii̱. Te nini stá'a̱n‑ya̱ tú'un, te sutu̱ ñá'nu jíín cháa ni̱ ka̱yii ini̱ ñuu̱, ni̱ ja̱koyo‑de nuu̱‑yá. Te ni̱ kajika̱ tu̱'ún‑de‑ya̱: Na̱ jíín tú'un sá'a‑ró tíñu yá'a. Te ndéja̱ ní ka'a̱n jíín‑ró sá'a‑ró súan. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Te ni̱ ka'a̱n Jesús: Suni ná kaká tu̱'ún‑rí róó ɨɨn tu̱'un. Te nú kuu xndíó káni‑ró, yúan‑na te kachi̱‑ri̱ nuu̱‑ro̱ na̱ jíín tú'un sá'a‑ri̱ tiñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ja̱ ní skuánducha Juan sáá, ndé onde̱ ni̱ kii tu̱'un‑ún. Onde̱ andɨ́vɨ́ xí ondé cha̱a, áchí‑ya̱ jíín‑de. Yúan‑na te ni̱ kanda̱tu̱'ún máá‑de: Nú ka'a̱n‑yo̱ já ondé andɨ́vɨ́, te kachi̱‑de kuni‑yó: Naja̱ tú ní kákandíja‑ró núu̱‑dé núsáá. ");
INSERT INTO migNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Te nú ka'a̱n‑yo̱ já ondé cha̱a, te káyu̱'ú‑yo̱ ñáyɨvɨ, chi̱ ndivii‑í kájani ini̱‑i ja̱ cháa ni̱ jani tu̱'un Dios ni̱ kuu Juan. Achí‑de jíín tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Te ni̱ kaka'a̱n‑de: Tú kájini̱‑ri̱, áchí‑de jíín Jesús. Te suni ni̱ ka'a̱n‑ya̱ jíín‑de: Ni ruu̱, tú kachi̱‑ri̱ nuu̱‑ro̱ na̱ jíín tú'un sá'a‑ri̱ ta̱ká tiñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ko ndasa kájani ini̱‑ro̱. Ɨɨn cha̱a ni̱ i̱o uu̱ se̱'e yíí‑de, te ni̱ jaa̱‑de nuu̱ ɨ́ɨn‑i. Te ni̱ kachi̱‑de jíín‑i: Hijo, kuá'án te sátiñu‑ró núu̱ itú vina, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Te ni̱ ka'a̱n‑i: Ma̱ kí'i̱n‑ná, áchí‑i. Ko ni̱ kunúu, te ni̱ nakani ini̱‑i te kua'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Te táa̱‑ún, ni̱ jaa̱‑de nuu̱ ɨngá‑i. Te suni súan ni̱ ka'a̱n‑de jíín‑i. Te ni̱ ka'a̱n‑i: Bueno, ná kí'i̱n‑ná táta̱, áchí‑i. Ko tú ní já'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ja̱ ndéndúú‑i, ndé ɨɨn‑i ni̱ skíkuu tiñu kuní táa̱‑i, áchí‑ya̱. Te ni̱ kaka'a̱n‑de: Su̱chí ɨ́ɨn, áchí‑de. Te ni̱ ka'a̱n Jesús jíín‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ja̱ cháa xíní jíín ñá'an téné, xna'a̱n‑ga̱‑ún kɨ́vɨ ini̱ ñuu̱ nuu̱ tá'ú Dios tiñu vásá róó jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chi ni̱ kii Juan, ni̱ stá'a̱n‑de ichi ndáa̱ nuu̱‑ro̱, te tú ní kákandíja‑ró tú'un ká'a̱n‑de. Ko cha̱a xíní jíín ñá'an téné, ni̱ ka̱kandíja‑ún tú'un ni̱ ka'a̱n‑de. Te máá‑ró, va̱sa ndé'é‑ró tíñu yá'a, te tú ní kánakani kutɨ iní‑ro̱ náva̱'a kandíja‑ró núu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kuni so̱'o ɨnga̱ tu̱'un yátá jíná'an‑ró. Ni̱ i̱o ɨɨn cha̱a, táa̱ ini̱ ve̱'e kúu‑de. Te ni̱ nachu'un‑de ɨɨn itu̱ uva. Te ni̱ jasu̱‑de ja̱kú, te ni̱ jacha‑de ɨɨn yau̱ nuu̱ kaxín‑de. Te ni̱ ndukani‑de ɨɨn torre, te ni̱ xndóo‑de nuu̱ cháa kásátiñu jíín. Te ni̱ kee‑de kua'a̱n jíká‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Te ni̱ chaa̱ kɨvɨ̱ ndútútú ndé'e̱ uva. Te jito'o̱ itu̱ uva, ni̱ tájí‑de mozo‑de kája'a̱n nuu̱ cháa kásátiñu ja̱ náki'in nde'e̱ uva. ");
INSERT INTO migNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ko cha̱a kásátiñu, ni̱ ka̱katɨɨn‑ún mozo‑de. Ɨɨn‑de ni̱ kastují, ɨnga̱‑de ni̱ ka̱ja'ni, te ɨnga̱‑de ni̱ kaja̱'a yuu̱ xiní‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Te máá jíto'o̱, ni̱ na̱tájí tuku‑de yaku̱‑ga̱ mozo‑de kája'a̱n, kua'a̱‑gá vásá já xnáñúú. Te suni súan ni̱ ka̱sá'a‑ún jíín mozo‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Te onde̱ sandɨ̱'ɨ́‑na̱, te ni̱ tájí‑de se̱'e yíí‑de kua'a̱n. Ná kóo ja̱ jíñú'ún núu̱ sé'e‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ko ja̱ kásátiñu‑ún, ja̱ ní kajini̱ nuu̱ sé'e máá jíto'o̱, te ni̱ kaka'a̱n: Cha̱a yá'a xíin tá'u̱. Ná chó'o̱, te ná ká'ni‑yo‑dé. Te ná ndóo ta'u̱‑dé kuu‑yó, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Te ni̱ ka̱katɨɨn‑ún máá sé'e. Te ni̱ ka̱kiñi'in‑ún‑de yata̱ itú uva. Te ni̱ ka̱ja'ni‑ún‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Te nú ni̱ chaa̱ jito'o̱ itu̱ uva. Te ndasa sá'a‑de jíín cháa kásátiñu‑ún, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Te ni̱ kaka'a̱n‑de jíín‑yá: Xnáa íi̱‑dé cha̱a ñáá‑ún. Te kua̱'a‑de itu̱ uva‑de‑ún nuu̱ ɨngá cha̱a kásátiñu. Te kɨvɨ̱ kúun nde'e̱, te nakua̱'a mozo‑de nde'e̱‑ún nuu̱‑dé. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Te ni̱ ka'a̱n Jesús jíín‑de: Té ka'u‑ga̱‑ro̱ tutú ii̱ yá'a náún. Yuu̱ já ní ka̱ské'ichi̱ cha̱a káchutá'an, yu̱án kúu máá yúu̱ ndíso fuerza jiki̱. Máá Tatá Dios ni̱ sá'a‑ya̱ súan. Te kánaa iní‑yo̱ ndé'é‑yó tíñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Núsáá te ká'a̱n‑ri̱ jíín‑ró, ñuu̱ nuu̱ tá'ú Dios tiñu kuxio nuu̱‑ro̱ jíná'an‑ró. Te kua̱'a‑ya̱ tá'u̱‑ún nuu̱ ɨngá ña̱yɨvɨ, náva̱'a kua̱'a‑i nde'e̱ vá'a. ");
INSERT INTO migNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Cha̱a ndua̱ sɨkɨ̱ yúu̱‑ún, ta'nu̱‑de. Te nú ndé sɨkɨ̱ júngava máá yúu̱‑ún, te kukuáchí sá'a. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Te sutu̱ ñá'nu jíín cháa fariseo ni̱ ka̱jini so̱'o‑de tu̱'un yátá ní ka'a̱n‑ya̱‑ún. Te ni̱ kaju̱ku̱'un ini̱‑de ja̱ sɨkɨ́ máá‑de ni̱ ka'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Te ni̱ ka̱ndúkú‑de modo tɨɨn‑de‑ya̱. Ko ni̱ kayu̱'ú‑de ni̱ ka̱jito‑de ña̱yɨvɨ, chi̱ kájani ini̱‑i ja̱ ɨ́ɨn cha̱a jáni tu̱'un Dios kúu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Te ni̱ ka'a̱n Jesús ɨnga̱ tu̱'un yátá jíín‑de jíná'an‑de: ");
INSERT INTO migNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ñuu̱ nátu̱'un andɨ́vɨ́ kúu nátu̱'un ɨɨn rey ja̱ ní sá'a‑de ɨɨn viko tánda'a já kúu se̱'e‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Te ni̱ tájí‑de mozo‑de kuaka̱na xini̱ táká ña̱yɨvɨ ní kastu̱'ún‑de nuu̱, ná kíi‑i. Ko ña̱yɨvɨ‑ún, tú ní kákuni̱‑i kii‑i. ");
INSERT INTO migNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Te ni̱ tájí tuku‑de yaku̱‑ga̱ mozo‑de kája'a̱n. Te ni̱ ka'a̱n‑de: Kachi̱ nuu̱ ñáyɨvɨ ní kana‑ri̱ xini̱‑ún: A ni̱ sátu̱'a‑ri̱ ja̱ kúxíni‑yó. Ni̱ ja'ni‑rí xndɨkɨ̱‑rí jíín kɨ́tɨ xá'án, te ndɨ'ɨ a íó tu̱'a. Ña'a̱n viko tánda'a jíná'an‑ró. Achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ko ña̱yɨvɨ‑ún, tú ní kájítú iní‑i. Te kája'a̱n‑i tiñu máá‑i, ɨɨn‑i ichi rancho‑i, te ɨnga̱‑i nuu̱ ndátíñu‑i. ");
INSERT INTO migNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Te sava‑ga̱‑i, ni̱ ka̱katɨɨn‑i mozo‑de, te ni̱ kaja̱'a‑i tuka̱ nuu̱‑dé, te ni̱ kaja'ni‑í‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Te ni̱ jini tu̱'un rey. Te ni̱ kiti̱ ini̱‑de. Te ni̱ tájí‑de soldado‑de kája'a̱n. Te ni̱ xnáa‑dé ña̱yɨvɨ ní ka̱ja'ni ndɨ́yi‑ún. Te ni̱ ja'mu‑de ñuu̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yúan‑na te ni̱ ka'a̱n rey jíín mozo‑de: Ja̱ndáa̱, ja̱ víko tánda'a, a íó tu̱'a. Ko ña̱yɨvɨ ní kana‑ri̱ xini̱‑ún, tú va̱'a ña̱yɨvɨ kákuu‑i. ");
INSERT INTO migNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Núsáá te kuá'án jíná'an‑ró ondé nuu̱ náketá'an ichi yatá ñúu̱. Te kana‑ró xiní na̱saa ña̱yɨvɨ ní'i̱n‑ro̱, ná kíi‑i nuu̱ víko tánda'a yá'a. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Te ni̱ kenda koyo mozo‑de kája'a̱n ta̱ká‑ni ichi. Te ni̱ stútú‑de na̱saa ña̱yɨvɨ ní kani'i̱n‑dé: Ɨɨn jínu‑ni ña̱yɨvɨ vá'a jíín ñáyɨvɨ ú'u̱. Te viko tánda'a‑ún ni̱ chítú ndɨ́ɨ jíín ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Te ni̱ kɨ̱vɨ rey ini̱ ve̱'e ja̱ ndé'é‑de nuu̱ ñáyɨvɨ ní kataka̱. Te ni̱ jini̱‑de nuu̱ ɨ́ɨn cha̱a ja̱ tú ñú'un‑de sa'ma víko tánda'a. ");
INSERT INTO migNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Te ni̱ kachi̱‑de jíín cháa‑ún: Amigo, ndasa ni̱ kɨ̱vɨ‑ró yá'a ja̱ ná tú ñú'un‑ró sá'ma víko tánda'a, áchí‑de. Te máá cháa‑ún, tú ní ká'a̱n kutɨ‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yúan‑na te ni̱ ka'a̱n rey jíín cháa kájatíñu‑ún: Tɨɨn‑ró te ku'ni̱‑ro̱ ndá'a‑dé ja'a̱‑dé, te kiñi'in‑ró‑de ná kí'i̱n‑de nuu̱ ñáa yata̱ ké'e. Yúan nde'e̱‑de te nakaji‑dé ñii yú'u‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Chi ni̱ kana‑ri̱ xini̱ kuá'a̱‑í, ko yaku̱‑ni‑i ni̱ ka̱ji‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yúan‑na te kája'a̱n cha̱a fariseo. Te ni̱ kanda̱tu̱'ún máá‑de nú ndasa tɨɨn yátá‑de‑ya̱ jíín tú'un ká'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Te ni̱ ka̱tájí‑de cha̱a káskuá'a jíín máá‑de jíín cháa herodiano kája'a̱n nuu̱‑yá. Te ni̱ kaka'a̱n‑de jíín‑yá: Maestro, kájini̱‑ná ja̱ ká'a̱n ndaa̱‑ní te stá'a̱n ndaa̱‑ní ichi Dios. Te tú yú'ú‑ní jíto‑ní ni ɨɨn cha̱a, chi̱ tú ndé'é‑ní ndasa jíto ta̱ká cha̱a. ");
INSERT INTO migNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Núsáá te kachi̱‑ní nuu̱‑ná jíná'an‑ná: Ndasa kachi̱‑ní, á kuu kua̱'a‑yó xú'ún yóo̱ nuu̱ César xí túu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ko Jesús, ni̱ juku̱'un ini̱‑ya̱ já xndá'ú‑de‑ya̱ kákuni̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Cha̱a uu̱ xini̱ kákuu‑ró. Naja̱ kájito nchaa̱‑ro̱ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Stá'a̱n xu̱'ún yóo̱ jián ná ndé'é‑rí. Achí‑ya̱ jíín‑de. Te ni̱ ka̱stá'a̱n‑de ɨɨn peso máá‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yúan‑na te ni̱ kachi̱‑ya̱ jíín‑de: Ndé cha̱a kúu cha̱a ncháá nuu̱ yá'a, jíín tú'un yóso yá'a, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Te ni̱ kaka'a̱n‑de jíín‑yá: César kúu, áchí‑de. Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín‑de: Kua̱'a ja̱ xíin César nuu̱ César, te ja̱ xíin Dios nuu̱ Dios núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Te nuu̱ ní ka̱jini so̱'o‑de tu̱'un yá'a, te ni̱ ka̱naa iní‑de, te ni̱ ka̱xndóo‑de‑ya̱, te kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Te suni kɨvɨ̱‑ún ni̱ ja̱koyo cha̱a saduceo nuu̱‑yá. Cha̱a‑ún káka'a̱n‑de ja̱ tú nachaku̱ kutɨ ndɨ́yi. Te ni̱ kajika̱ tu̱'ún‑de‑ya̱: ");
INSERT INTO migNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Maestro, Moisés ni̱ ka'a̱n‑de: Nú ɨɨn cha̱a kuu̱‑de, te nú tú se̱'e‑de ní íó. Te ñani̱‑de, ná náta̱nda'a jíín ñásɨ́'ɨ́‑de, te ndukani‑de tata̱ ñani̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Te jíín‑ná ni̱ ka'i̱o usia̱ ñani̱. Te cha̱a núú ni̱ ta̱nda'a‑dé. Te ni̱ ji'i̱‑de. Te tú se̱'e‑de ní íó. Te ni̱ xndóo‑de ñasɨ́'ɨ́‑de nuu̱ ñaní‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Te suni súan ni̱ ta'a̱n cha̱a uu̱, te suni súan cha̱a uni̱, onde̱ ndɨ́'usiá‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Te nuu̱ ní kaji'i̱ ndɨ́'usiá‑de, te suni ni̱ ji'i̱ máá ñá'an‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Núsáá te kɨvɨ̱ náchaku̱ ta̱ká ndɨ̱yi, te ja̱ ndɨ́'usiá‑de ndé ɨɨn‑de kuu‑ña ñásɨ́'ɨ́‑de. Chi̱ ndɨ'ɨ‑de ni̱ kancha̱ka‑de‑ña, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yúan‑na te ni̱ ka'a̱n Jesús: Máni kástɨ́vɨ́‑ró tú'un, chi̱ tú kájuku̱'un ini̱‑ro̱ jíín tutú ii̱, ni jíín fuerza Dios. ");
INSERT INTO migNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Chi̱ kɨvɨ̱ náchaku̱‑de ma̱'ñú ndɨ́yi, ni cha̱a tú ta̱nda'a‑dé jíín ñásɨ́'ɨ́, ni ña'an tú koo yii‑ñá. Chi̱ nduu‑de nátu̱'un ndajá'a̱ Dios andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Te sɨkɨ̱ ndɨ́yi ja̱ náchaku̱, á tú ní káka'u‑ró tutú ja̱ ní ka'a̱n Dios jíín‑ró: ");
INSERT INTO migNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Máá‑rí kúu Dios Abraham, Dios Isaac, Dios Jacob, áchí‑ya̱. Ko nasu̱ Dios cha̱a ni̱ kaji'i̱ kúu‑ya̱, chi̱ sua Dios cha̱a káichaku̱ kúu‑ya̱, áchí Jesús jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Te ña̱yɨvɨ‑ún, ni̱ ka̱naa iní‑i ni̱ ka̱jini so̱'o‑i tu̱'un stá'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yúan‑na te cha̱a fariseo, ni̱ ka̱jini so̱'o‑de ja̱ ní kundéé‑yá jíín cháa saduceo, te ni̱ ka̱ndutútú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Te ɨɨn máá‑de, ja̱ kúu‑de maestro ley, ni̱ jika̱ tu̱'ún‑de‑ya̱ náva̱'a koto nchaa̱‑de‑ya̱ kuní‑de: ");
INSERT INTO migNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Maestro, ndéja̱ kúu tu̱'un tá'ú tíñu kánúú xáa̱n‑gá nuu̱ tutú ley, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Te ni̱ kachi̱ Jesús jíín‑de: Kumani̱‑ro̱ jíín máá Tatá‑ro̱ Dios onde̱ jíín iní jíín añú‑ro̱, jíín nɨ́ɨ́ núu̱ jiní tuní‑ro̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ya̱'á kúu tu̱'un tá'ú tíñu kánúú xáa̱n‑gá. ");
INSERT INTO migNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Te tu̱'un uu̱ kúu suni nátu̱'un ɨnga̱‑ún: Kundá'ú ini̱‑ro̱ tá'an‑ró nátu̱'un kúndá'ú ini̱‑ro̱ máá‑ró, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Te chi̱i ndendúú tu̱'un yá'a kándee ta̱ká tutu̱ ley, jíín táká tutu̱ cha̱a ni̱ ka̱jani tu̱'un Dios, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Te nini ká'i̱in tútú cháa fariseo yúan, te Jesús ni̱ jika̱ tu̱'ún‑yá‑de: ");
INSERT INTO migNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ndasa kájani ini̱‑ro̱ já kúu Cristo. Ndé Se̱'e kúu‑ya̱, áchí‑ya̱. Te ni̱ kakachi̱‑de jíín‑yá: Se̱'e David kúu‑ya̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Te naja̱ ní sá'a Espíritu ja̱ David skúnání‑de‑ya̱ Jito'o̱‑de núsáá. Chi ni̱ ka'a̱n‑de: ");
INSERT INTO migNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Máá Tatá Dios, ni̱ ka'a̱n‑ya̱ jíín Jíto'o̱‑ri̱: Nungo̱o‑ró íchi ndává'a‑ri̱ nini ná chúkú‑rí cha̱a kájito u'u̱ róó kuu‑de teyu̱ kuxndíi ja'a̱‑ro̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Te nú Jito'o̱ ni̱ ka'a̱n David jíín‑yá, te ndasa kúu máá‑yá se̱'e‑de núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Te ni ɨɨn‑de tú ní kúu xndíó káni kutɨ‑dé tu̱'un nuu̱‑yá. Te ni tuká ní chúndéé iní ni ɨɨn‑de kaka̱ tu̱'ún‑de‑ya̱ ondé kɨvɨ̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yúan‑na te ni̱ ka'a̱n Jesús jíín ñáyɨvɨ jíín cháa káskuá'a jíín‑yá: ");
INSERT INTO migNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Cha̱a káchaa tutu̱ jíín cháa fariseo, ni̱ kaju̱ngo̱o‑de nuu̱ silla Moisés. ");
INSERT INTO migNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Núsáá te ta̱ká na̱ún tá'ú‑de tiñu nuu̱‑ro̱, yu̱án kuándatu̱‑ro̱ te sá'a‑ró. Ko ma̱ sá'a‑ró nátu̱'un kásá'a máá‑de. Chi̱ ká'a̱n‑de, ko tú káskíkuu‑de. ");
INSERT INTO migNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Chi̱ káju'ni̱‑de carga ve̱e ja̱ yíí kúndiso‑i, te káchaa‑de sɨkɨ̱‑í. Ko máá‑de jíná'an‑de, tú kákuyíí‑de ké'é‑de carga‑ún ni jíín ɨ́ɨn nda'a lúlí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Chi̱ kásá'a‑de ta̱ká tiñu‑de náva̱'a kuni̱ ña̱yɨvɨ núu̱‑dé. Chi̱ kánaskáa̱‑de nuu̱ yóso tú'un tutu̱‑de, te suni súan jíín yú'a̱ nuu̱ tɨ́ka̱chí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Te xaa̱n kákusɨɨ̱ iní‑de jíín silla jíñú'ún ondé xini̱ mesa nuu̱ íó xíni, jíín silla onde̱ xini̱ mesa ini̱ ve̱'e sinagoga. ");
INSERT INTO migNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Suni ja̱ ká'a̱n sa̱'án‑yo̱ jíín‑de nu̱yá'u, te ja̱ ká'a̱n ña̱yɨvɨ: Maestro, Maestro, jíín‑de, kákusɨɨ̱ iní‑de jíín. ");
INSERT INTO migNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ko máá‑ró jíná'an‑ró, ma̱ kúnání‑ró Maestro, chi̱ ɨɨn máá tú'ún‑ni kúu Maestro máá‑ró, kúu Cristo. Te ta̱ká róó, ñani̱ kákuu‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Te ma̱ ká'a̱n‑ro̱ já ní ɨɨn cha̱a ini̱ ñu̱yɨ́vɨ yá'a kúu Táa̱‑ro̱. Chi̱ íó ɨɨn Táa̱‑ro̱ jíná'an‑ró, te kánchaa̱‑ya̱ ondé andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni ma̱ kúnání‑ró Jíto'o̱. Chi̱ íó ɨɨn Jito'o̱‑ro̱ jíná'an‑ró, te Cristo kúu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Te cha̱a kúñá'nu‑ga̱ nuu̱‑ro̱, ná ndúu‑de mozo nuu̱‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chi cha̱a sáñá'nu máá‑de, ndusúchí‑de. Te cha̱a sásúchí máá‑de, nduñá'nu‑de. ");
INSERT INTO migNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Naka̱ ndá'ú kuu róó cha̱a káchaa tutu̱ jíín cháa fariseo. Cha̱a uu̱ xini̱ kákuu‑ró, chi̱ kájasu̱‑ro̱ ñúu̱ nátu̱'un andɨ́vɨ́ núu̱ ñáyɨvɨ. Chi̱ tú kɨ́vɨ koyo máá‑ró, ni tú kája̱'a‑ró tú'un ja̱ kɨ́vɨ koyo ña̱yɨvɨ kándúkú kɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Naka̱ ndá'ú kuu róó, cha̱a káchaa tutu̱ jíín cháa fariseo. Cha̱a uu̱ xini̱ kákuu‑ró, chi̱ kákókó‑ró vé'e ña'an kákendo̱o ndá'ú. Te kásá'a‑ró já túu kua̱chi‑ró, yu̱án kájika̱n ta'u̱ ná'án‑ró. Ja̱ yúán ví'í‑gá ta'nu̱ ndatu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Naka̱ ndá'ú kuu róó cha̱a káchaa tutu̱ jíín cháa fariseo. Cha̱a uu̱ xini̱ kákuu‑ró, chi̱ káxndéka̱va‑ró mar jíín ñú'un íchí ja̱ skándíja‑ró ɨ́ɨn cha̱a. Te nú a ni̱ kandíja‑de, te ví'í‑gá uu̱ jínu nduu‑de ɨɨn se̱'e infierno kásá'a‑ró vásá máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Naka̱ ndá'ú kuu róó cha̱a kuáá ja̱ káyo̱xnúú‑ró núu̱ ñáyɨvɨ. Chi̱ káka'a̱n‑ro̱: Nú ndé cha̱a játu̱'un téyíí‑de sɨkɨ̱ vé'e ii̱, te tú ní'i̱n tíñu, ko nú ɨɨn cha̱a játu̱'un téyíí‑de sɨkɨ̱ oro ini̱ ve̱'e ii̱‑ún, yu̱án te fuerza ná skíkuu‑de, áchí‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Cha̱a ñáá jíín cháa kuáá kákuu‑ró. Ndéja̱ ñá'nu‑ga̱ kúu, oro xí máá vé'e ii̱ ja̱ sándoo oro‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Te: Nú ndé cha̱a játu̱'un téyíí‑de sɨkɨ̱ altar, tú ní'i̱n tíñu. Ko nú ɨɨn cha̱a játu̱'un téyíí‑de sɨkɨ̱ ndátíñu ni̱ ka̱chúkú‑i nuu̱ altar, yu̱án te fuerza ná skíkuu‑de. Achí‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Cha̱a xini̱ ña̱á jíín cháa kuáá kákuu‑ró. Ndéja̱ ñá'nu‑ga̱ kúu, ndatíñu ni̱ soko̱‑í, xí máá altar ja̱ sándoo ndatíñu‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Núsáá te cha̱a játu̱'un téyíí sɨkɨ́ altar, sɨkɨ̱ máá altar játu̱'un téyíí‑de jíín sɨkɨ́ táká ndatíñu káxiu̱kú núu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Te cha̱a játu̱'un téyíí sɨkɨ́ vé'e ii̱, sɨkɨ̱ máá vé'e ii̱‑ún játu̱'un teyíí‑de jíín sɨkɨ́ I'a̱ ncháá ini̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Te cha̱a játu̱'un teyíí sɨkɨ́ ándɨ́vɨ́, játu̱'un teyíí‑de sɨkɨ̱ silla nuu̱ tá'ú Dios tiñu jíín sɨkɨ́ I'a̱ kánchaa̱ nuu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Naka̱ ndá'ú kuu róó cha̱a káchaa tutu̱ jíín cháa fariseo, cha̱a uu̱ xini̱ kákuu‑ró. Chi̱ kája̱'a‑ró ɨ́ɨn sɨkɨ̱ uxí décimo ita̱ mi̱nú jíín itá xi̱ín jíín comino nuu̱ Dios, te káxndóo‑ró tú'un kánúú xáa̱n‑gá nuu̱ ley, ndasa kii juicio, jíín ndása kundá'ú ini̱‑ya̱ yóó, jíín ndása kándíja‑yó. Ta̱ká ya̱'á kánúú sá'a‑ró núú, te suni ma̱ xndóo‑ró ɨngá‑ún núú. ");
INSERT INTO migNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Cha̱a kuáá kákuu‑ró já káyo̱xnúú‑ró núu̱ ñáyɨvɨ. Chi̱ máni kátava‑ro tíyúkún te kákókón‑ró camello. ");
INSERT INTO migNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Naka̱ ndá'ú kuu róó cha̱a káchaa tutu̱ jíín cháa fariseo. Cha̱a uu̱ xini̱ kákuu‑ró. Chi̱ kánakacha‑ró íchi yatá vaso jíín íchi yatá kó'o̱. Ko ichi iní ñú'un chítú tú'un kuí'ná jíín tú'un káñáá. ");
INSERT INTO migNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Cha̱a kuáá kákuu‑ró, fariseo. Nakacha xna'a̱n‑ga̱ ichi iní vaso jíín ichí iní ko'o̱, náva̱'a suni súan ná ndúndoo ichi yatá‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Naka̱ ndá'ú kuu róó cha̱a káchaa tutu̱ jíín cháa fariseo. Cha̱a uu̱ xini̱ kákuu‑ró, chi̱ nátu̱'un ve'e añú ja̱ kánda̱yaa kánda̱a‑ró. Te ja̱ndáa̱ ja̱ lúu káa ichi yatá, ko ichi iní ñú'un chítú yíkɨ añú jíín táká ja̱ te̱'yú. ");
INSERT INTO migNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Suni súan máá‑ró jíná'an‑ró, chi̱ ichi fuera, ja̱ndáa̱ kásá'a‑ró já cháa ndaa̱ kákuu‑ró núu̱ ñáyɨvɨ. Ko ichi iní‑ro̱ ñú'un chítú‑ró tú'un yóso yú'u jíín tú'un káñáá. ");
INSERT INTO migNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Naka̱ ndá'ú kuu róó cha̱a káchaa tutu̱ jíín cháa fariseo. Cha̱a uu̱ xini̱ kákuu‑ró, chi̱ káskuá'nu‑ró vé'e añú cha̱a ni̱ ka̱jani tu̱'un Dios. Te kásá'a luu‑ró vé'e añú ta̱ká cha̱a ndaa̱. ");
INSERT INTO migNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Te káka'a̱n‑ro̱: Nú ní ká'i̱o‑yó kɨvɨ́ ní ka'i̱o ndɨ̱yi táa̱‑yo̱, te ma̱ kɨ́vɨ nduu̱‑yo̱ jíín‑de ja̱ ká'ni‑yo cháa ni̱ ka̱jani tu̱'un Dios núú, áchí‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Te súan kájani ndaa̱‑ro̱ tú'un sɨkɨ̱ máá‑ró, chi̱ táa̱‑ro̱ ni̱ ka̱ja'ni‑dé cha̱a ni̱ ka̱jani tu̱'un‑ya̱. Te máá‑ró kákuu ndija se̱'e‑de. ");
INSERT INTO migNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Núsáá te ná náskútú‑ró kú'a ndɨ̱yi táa̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Koo̱ jíín sé'e koo̱ kákuu‑ró. Ndasa ka̱ku‑ró já tá'nu̱ ndatu̱‑ro̱ núu̱ infierno núsáá. ");
INSERT INTO migNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ja̱ yúán tájí‑rí cha̱a kani tu̱'un Dios nuu̱‑ro̱ jíín cháa ndíchí jíín cháa chaa tutu̱. Te sava‑de, ka'ni‑ro‑dé, te kata kaa‑ró‑de jika̱ cruz. Te sava‑ga̱‑de, kua̱'a‑ró yúnu xíi‑de ini̱ ve̱'e sinagoga máá‑ró, te chindiki̱n‑ro̱‑dé ndɨta'a̱n ñuu̱. ");
INSERT INTO migNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Náva̱'a koo kua̱chi sɨkɨ̱ máá‑ró já ní jatɨ nɨñi̱ ñáyɨvɨ ndáa̱ nuu̱ ñú'un yá'a, onde̱ nɨñi̱ cháa ndaa̱ Abel, te onde̱ nɨñi̱ Zacarías, se̱'e Berequías, chi ni̱ ka̱ja'ni‑ro‑dé sava ma̱'ñú altar jíín vé'e ii̱. ");
INSERT INTO migNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Ta̱ká tu̱ndó'o yá'a kii sɨkɨ̱ ñáyɨvɨ yá'a. ");
INSERT INTO migNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalén, Jerusalén, ni̱ ka̱ja'ni‑ro cháa kájani tu̱'un Dios. Te ni̱ kaja̱'a‑ró yúu̱ cháa ni̱ tájí‑yá va̱i nuu̱‑ro̱. Ió kua'a̱ vuelta ni̱ kuni̱‑ri̱ nastútú‑rí se̱'e‑ró nátu̱'un chukí ja̱ nástútú‑tɨ́ tɨrɨ̱ɨ‑tɨ̱ chíi ndiji̱n‑tɨ́, ko tú ní kákuni̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vina te ni̱ kendo̱o víchí vé'e‑ró núsáá. ");
INSERT INTO migNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chi̱ ká'a̱n‑ri̱ jíín‑ró ja̱ má kuní kutɨ‑gá‑ro̱ núu̱‑rí jíná'an‑ró, onde̱ jaa̱ ɨɨn kɨvɨ̱ ká'a̱n‑ro̱: Ná nákana jaa‑yó‑yá, chi̱ ndíso‑ya̱ tíñu máá Tatá, achi̱‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Te ni̱ kenda Jesús ini̱ ve̱'e ii̱ kua'a̱n‑ya̱. Te cha̱a káskuá'a jíín‑yá‑ún, ni̱ ja̱koyo‑de nuu̱‑yá ja̱ stá'a̱n‑de ta̱ká ve'e ja̱ ncháá tá'an jíín vé'e ii̱‑ún nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Te ni̱ ka'a̱n‑ya̱: Á kánde̱'é‑ró núu̱ vé'e yá'a. Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ja̱ má kútá'an‑ga̱ ni ɨɨn yuu̱. Chi̱ ɨɨn kɨvɨ̱ te ndɨ'ɨ stúncháa̱‑i. Achí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Te ni̱ jungo̱o‑ya̱ ondé yuku Olivos. Te ni̱ ja̱koyo cha̱a káskuá'a‑ún nuu̱‑yá. Te ni̱ kajika̱ tu̱'ún sɨ́ɨn‑de‑ya̱: Kastu̱'ún‑ní nuu̱‑ná. Ndé kɨvɨ̱ kóo ta̱ká tu̱ndó'o yá'a. Te na̱ún tuni̱ koo nuu̱ kúyani nchaa̱‑ní jíín kɨvɨ́ jínu ñu̱yɨ́vɨ, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Te ni̱ ka'a̱n Jesús: Koto‑ró máá‑ró jíná'an‑ró, náva̱'a tú xndá'ú ni ɨɨn‑de róó. ");
INSERT INTO migNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Chi̱ kikoyo kua'a̱ cháa ki'in núu sɨ́'vɨ́‑rí. Te ka'a̱n‑de: Máá‑rí kúu Cristo, achi̱‑de, te xndá'ú‑de kua'a̱ xáa̱n ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Te kuni tu̱'un‑ró káka'a̱n ja̱ íó guerra, jíín já kóo guerra. Ko ma̱ yú'ú‑ro̱, chi̱ nɨ́nɨ kóo súan. Ko té ji̱nu‑ga̱ kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chi̱ ndonda nación sɨkɨ̱ nación, te ñuu̱ sɨkɨ̱ ñúu̱. Te koo kue'e̱ xaa̱n jíín tamá. Te yá'a yúan ta̱an. ");
INSERT INTO migNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Te ta̱ká yu̱án kákuu tu̱ndó'o kéjá'á núú. ");
INSERT INTO migNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yúan‑na te nastúu‑de róó jíná'an‑ró, ja̱ kóto‑ró túndó'o. Te ka'ni‑dé róó. Te ta̱ká ña̱yɨvɨ, koto u'u̱‑i róó ja̱ sɨkɨ́ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Yúan‑na te nayu̱'ú kua'a̱‑í, te nastúu tá'an‑i, te koto u'u̱ tá'an‑i. ");
INSERT INTO migNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Te jukuiñi̱ kua'a̱ cháa kani tu̱'un tú'ún. Te xndá'ú‑de kua'a̱ ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Te ndea̱ tiñu ñáá, te yu̱án kuá'a̱‑í ma̱ kóo mani̱‑gá‑i. ");
INSERT INTO migNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ko cha̱a kúndii̱ ni̱'in onde̱ kɨvɨ̱ jínu, cha̱a‑ún ka̱ku. ");
INSERT INTO migNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Te tu̱'un va̱'a yá'a cuenta ñuu̱ nuu̱ tá'ú‑yá tiñu, kuicha̱ ini̱ nɨ́ɨ́ ñúyɨ́vɨ náva̱'a kuni̱ ndaa̱ ta̱ká ña̱yɨvɨ, yúan‑na te ji̱nu. ");
INSERT INTO migNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Núsáá te nú ni̱ kajini̱‑ro̱ já káchá'án te ni̱ tucha̱ ta̱ká ndatíñu ini̱ lugar ii̱ nátu̱'un ni̱ ka'a̱n Daniel, cha̱a ni̱ jani tu̱'un Dios onde̱ sáá, (cha̱a ká'u, ná júku̱'un ini̱‑de), ");
INSERT INTO migNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yúan‑na te ña̱yɨvɨ káxiu̱kú iní ñuu̱ Judea, kunu‑i ki̱ngoyo‑i onde̱ yuku. ");
INSERT INTO migNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Te cha̱a kándee xini̱ vé'e, ma̱ núu‑de kiñi'in‑de ndatíñu ini̱ ve̱'e‑de. ");
INSERT INTO migNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Te cha̱a kándee onde̱ rancho, ma̱ náxíó káva yátá‑de naki'in‑de tɨka̱chí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ko kɨvɨ̱‑ún naka̱ ndá'ú kuu ña'an káñu̱'un se̱'e, jíín ñá'an káskáxin. ");
INSERT INTO migNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Núsáá, te kaka̱n ta'u̱‑ro̱ náva̱'a tú kunu‑ró víko víjin ni kɨvɨ̱ ndéta̱tú ki'i̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chi̱ kɨvɨ̱‑ún koo tu̱ndó'o xaa̱n, ja̱ ná té koo‑ga̱ onde̱ kɨvɨ̱ ní jungo̱o ñu̱yɨ́vɨ, te onde̱ vina, te ni ma̱ kóo‑ga̱. ");
INSERT INTO migNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Te nú tú ní ndúkútɨ́ kɨvɨ̱‑ún núú, te ni ɨɨn ña̱yɨvɨ má káku kutɨ‑í núú. Ko ja̱ sɨkɨ́ ñáyɨvɨ ní naka̱ji‑ya̱‑ún, yu̱án ndúkútɨ́ kɨvɨ̱‑ún sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Núsáá te nú ndé cha̱a ká'a̱n jíín‑ró: Yá'a nde̱'é‑ró kánchaa̱ Cristo, xí yúan nde̱'é‑ró kánchaa̱‑ya̱, ma̱ kándíja‑ró já ká'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chi̱ kenda Cristo xndá'ú jíín cháa kani tu̱'un tú'ún. Te sá'a‑de tuni̱ jíín tíñu ñá'nu, náva̱'a xndá'ú‑de onde̱ ña̱yɨvɨ ní naka̱ji‑ya̱ nú ná kúu sá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Vina a ni̱ kastu̱'ún‑rí nuu̱‑ro̱ ondé jíín kɨvɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Núsáá te nú ka'a̱n ña̱yɨvɨ jíín‑ró: Yúan nde̱'é‑ró, onde̱ nuu̱ ñú'un té'é kánchaa̱‑ya̱, achi̱‑i, te ma̱ kénda‑ró. Xí: Jia̱n ndé'é‑ró, ichi iní ve̱'e kánchaa̱‑ya̱, achi̱‑i, te ma̱ kándíja‑ró jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Chi̱ nátu̱'un ndíi ncháa̱ ja̱ nándeyu̱ ichi núu̱ kána ndika̱ndii te jáa̱ onde̱ ichi núu̱ kée ndika̱ndii, suni súan kii máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Chi̱ nú ndénu̱ kútúu ndɨ́yi, yúan taka̱ tijii̱. ");
INSERT INTO migNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yúan‑na te nú ni̱ ndɨ'ɨ ta̱ká tu̱ndó'o kɨvɨ̱‑ún, te kutúún‑ni ndika̱ndii, te tuká nandii yóo̱. Te jungoyo tiñu̱ú xíní ichi ándɨ́vɨ́. Te ta̱ká fuerza andɨ́vɨ́ ndɨ́'ɨ ka'ya. ");
INSERT INTO migNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yúan‑na te ichi ándɨ́vɨ́ kénda tuni̱ máá Sé'e cha̱a. Te nde'e̱ ta̱ká ña̱yɨvɨ íó ini̱ ñu̱yɨ́vɨ yá'a. Te kuni̱‑i nuu̱ máá Sé'e cha̱a kii‑ya̱ jíín vikó íó andɨ́vɨ́, jíín kuá'a̱ fuerza ja̱ ndúñá'nu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Te tájí‑yá ndajá'a̱‑yá ki̱ngoyo. Te nde'e̱ jaa clarín. Te nastútú‑yá ña̱yɨvɨ ní naka̱ji‑ya̱ ndɨ́kúu̱n lado ñu̱yɨ́vɨ, onde̱ ɨɨn lado andɨ́vɨ́ te onde̱ ɨnga̱ lado. ");
INSERT INTO migNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Vina te skuá'a‑ró ndasa sá'a mérkexe̱. Nú a ni̱ nduyúcha núma, te ni̱ na̱jaa nda'a, te a kájini̱‑ro̱ já á ni̱ kuyani viko sáú. ");
INSERT INTO migNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Suni súan róó, nú a ni̱ kajini̱‑ro̱ táká tiñu yá'a, te kuni̱‑ro̱ já á yani jaa̱ kɨvɨ̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ má náa ñáyɨvɨ yá'a, onde̱ ná skíkuu ta̱ká tiñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Andɨ́vɨ́ jíín ñúyɨ́vɨ chi̱ naa, ko tu̱'un ká'a̱n‑ri̱ chi ma̱ náa. ");
INSERT INTO migNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ko kɨvɨ̱ kóo‑ún, jíín hora, tú ni ɨɨn cha̱a jiní, ni ndajá'a̱ ká'i̱o andɨ́vɨ́, tú ni ɨɨn na̱ún jiní, ni máá Sé'e‑ya̱. Chi̱ máá ɨ́ɨn‑ni máá Táa̱‑ri̱ jiní‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Chi̱ nátu̱'un ni̱ i̱o kɨvɨ̱ ní kii Noé, suni súan koo kɨvɨ̱ kíi máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chi̱ kɨvɨ̱‑ún ja̱ ná té chá'a̱n‑ga̱ kuun sau̱ xáa̱n, káyee‑í, káji'i‑i, káta̱nda'a cháa, te káta̱nda'a ñá'an. Te ni̱ jaa̱ kɨvɨ̱ já ní kɨ̱vɨ Noé ini̱ barco ká'nu. ");
INSERT INTO migNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Te tú ní kájini̱ kutɨ‑í onde̱ ni̱ chaa̱ sau̱ xáa̱n, te ni̱ xnáa ndɨ́'ɨ‑cha̱‑í. Te suni súan kii máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kɨvɨ̱‑ún te kuiñi uu̱ cha̱a onde̱ rancho. Te ɨɨn‑de naki'in‑ya̱, te ɨnga̱‑de ndo̱o. ");
INSERT INTO migNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Te uu̱ ñasɨ́'ɨ́ ndiko‑ña ɨ́ɨn‑ni yo̱só. Te ɨɨn‑ña náki'in‑ya̱, te ɨnga̱‑ña ndóo. ");
INSERT INTO migNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Núsáá te kundito‑ró, chi̱ tú kájini̱‑ro̱ na̱ kɨvɨ̱ ncháa̱ Jito'o̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ko ná júku̱'un ini̱‑ro̱ tú'un yá'a. Táa̱ ini̱ ve̱'e, nú ní jiní‑de na̱ hora kuu ja̱ kíi ñakui̱'ná, te kundito‑de núú. Te ma̱ kuá'a‑de tu̱'un ja̱ sákuí'ná vé'e‑de núú. ");
INSERT INTO migNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Núsáá te suni koo tu̱'a máá‑ró chi̱ máá kɨvɨ́ já tú na̱ún kájani ini̱‑ro̱, te nchaa̱‑ni máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ndéja̱ kúu ɨɨn mozo ndíchí já játíñu va̱'a. Chi̱ máá jíto'o̱, kani‑de mozo‑ún ná kóto‑i se̱'e‑de, náva̱'a skée‑í su̱chí‑ún hora ja̱ íó va̱'a. ");
INSERT INTO migNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Xáán ndatu̱ kuu mozo‑ún. Te nú ni̱ nchaa̱ jito'o̱‑i, te nani'i̱n‑dé mozo‑ún sá'a‑i súan. ");
INSERT INTO migNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ káni‑de mozo‑ún ja̱ kóto‑i ta̱ká ndatíñu‑de. ");
INSERT INTO migNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ko nú mozo káñáá kúu‑i te jáni ini̱‑i: Kúkuéé‑ga̱ te nchaa̱ jito'o̱‑ri̱, achi̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Te nú kejá'á‑i stují‑í tá'a̱n mozo‑i. Te kee‑í ko'o‑i jíín cháa kánaji̱ni. ");
INSERT INTO migNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Yúan‑na te nchaa̱ jito'o̱ mozo‑ún kɨvɨ̱ já tú ndátu‑i jíín hora ja̱ tú jiní‑i. ");
INSERT INTO migNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Te xɨtɨ sáva‑de‑i. Te skétá'an‑de‑i jíín cháa uu̱ xini̱ jíná'an. Te yúan kundee‑i nde'e̱‑i te nakaji‑í ñii yú'u‑í. ");
INSERT INTO migNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yúan‑na te ñuu̱ nátu̱'un andɨ́vɨ́ kúu nátu̱'un uxi̱ ña'an jáá, ja̱ ní ka̱ki'in‑ña linterna káindá'á‑ña. Te ni̱ kenda koyo‑ña kuáta'a̱n‑ña ɨ́ɨn yii víko tánda'a. ");
INSERT INTO migNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Te u'u̱n‑ña ká'i̱o ndito xini̱‑ñá, te u'u̱n‑ña káñáá xini̱‑ñá. ");
INSERT INTO migNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Te ña'an káñáá xini̱‑ún, kándá'á‑ña linterna‑ña. Ko tú káindá'á‑ña petróleo ku'un ini̱. ");
INSERT INTO migNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ko ña'an ndíto xini̱‑ún, káindá'á‑ña botella ñú'un petróleo ɨɨn ká'nu‑ni jíín táká linterna‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Te nini ni̱ kukuéé yii‑ún ja̱ cháa̱‑de, te ni̱ kakixi̱‑ni‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Te nuu̱ ní kuu sava ñúú, te ni̱ ka̱jini so̱'o‑ña ɨ́ɨn tu̱'un kána jaa: Yá'a nde̱'é‑ró, a va̱i yii. Kenda koyo kita'a̱n‑ro̱‑dé, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Yúan‑na te ta̱ká ña'an jáá‑ún, ni̱ ka̱nduko̱o‑ña. Te ni̱ ka̱sátu̱'a‑ña linterna‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Te ña'an káñáá xini̱‑ún, ni̱ kaka'a̱n‑ña jíín ñá'an ká'i̱o ndito xini̱‑ún: Kua̱'a ɨɨn tá'ú petróleo nuu̱‑rí, chi kua̱nda'va̱ linterna‑ri̱, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ko ña'an ká'i̱o ndito xini̱‑ún, ni̱ kaka'a̱n‑ña: Ma̱ kúu, chi̱ sanaa te ma̱ kánda ja̱ kúu‑ri̱ jíín já kúu‑ró. Va'a̱‑ga̱ ki'i̱n‑ro̱ núu̱ cháa xíkó te kuaan‑ró já kúu máá‑ró. Achí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Te nini kája'a̱n‑ña kájakua̱an‑ña, te ni̱ chaa̱‑ni yii‑ún. Te ña'an ká'i̱o tu̱'a‑ún, ni̱ kɨ̱vɨ koyo‑ña jíín‑de ini̱ ve̱'e viko tánda'a. Te ni̱ nakasu̱‑de yuxé'é. ");
INSERT INTO migNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Yúan‑na te ni̱ kunúu. Te ni̱ cha̱koyo tuku sava‑ga̱ ña'an jáá‑ún. Te ni̱ kaka'a̱n‑ña: Táta̱, Táta̱, kuña‑ní ve'e, ná kɨ́vɨ koyo‑ná, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ko máá‑de ni̱ ka'a̱n‑de: Ja̱ndáa̱, ká'a̱n‑ri̱ jíín‑ró, tú jiní‑ri̱ róó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kundito núsáá, chi̱ tú kájini̱‑ro̱ na̱ kɨvɨ̱, ni na̱ hora nchaa̱ máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Chi̱ ñuu̱ nátu̱'un andɨ́vɨ́ kúu nátu̱'un ɨɨn cha̱a ja̱ kénda jíká‑de ɨnga̱ ñuu̱ ki'i̱n‑de. Te ni̱ kana‑de xini̱ mozo‑de. Te ni̱ teta'a̱n‑de ndatíñu‑de nuu̱ mozo‑de‑ún jíná'an. ");
INSERT INTO migNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Te nuu̱ ɨ́ɨn‑i, ni̱ ja̱'a‑de u'u̱n mil peso. Te nuu̱ ɨngá‑i, uu̱ mil peso. Te nuu̱ ɨngá‑i, ɨɨn‑ni mil peso. Súan ni̱ teta'a̱n‑de nuu̱ ɨ́ɨn ɨɨn mozo‑de ndasa xini̱ máá‑i jíná'an‑i. Te ni̱ kee‑ni‑de kua'a̱n jíká‑de. ");
INSERT INTO migNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Te mozo ni̱ ki'in u'u̱n mil peso‑ún, ni̱ kee‑i kua'a̱n‑i jíín. Te ni̱ sátiñu‑i jíín. Te ni̱ ni'i̱n‑í u'u̱n‑ga̱ mil peso sɨkɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Suni súan ni̱ sá'a mozo ja̱ ní ki'in uu̱ mil peso‑ún. Te ni̱ ni'i̱n túku‑i uu̱‑ga̱ mil peso sɨkɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ko mozo ja̱ ní ki'in ɨɨn mil peso, ni̱ kee‑i kua'a̱n‑i. Te ni̱ jacha‑i chi̱i ñu'un. Te ni̱ chisa̱'í‑i xu̱'ún jíto'o̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Te ni̱ kuu kua'a̱ kɨvɨ́. Te ni̱ nchaa̱ jito'o̱ mozo‑ún. Te ni̱ nasándaa̱‑de cuenta jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Te ni̱ jaa̱ mozo ja̱ ní ki'in u'u̱n mil peso‑ún, ni̱ ja̱stá'a̱n‑i u'u̱n‑ga̱ mil peso. Te ni̱ ka'a̱n‑i: Táta̱, ni̱ ja̱'a‑ní u'u̱n mil peso nuu̱‑ná. Te yá'a nde̱'é‑ní, u'u̱n‑ga̱ mil peso ni̱ ni'i̱n‑ná sɨkɨ̱. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Te jito'o̱‑i, ni̱ ka'a̱n‑de jíín‑i: Ió va̱'a. Mozo skíkuu va̱'a kúu‑ró. Ni̱ skíkuu va̱'a‑ró jíín yakú‑ni ndatíñu. Ná cháa‑ri̱ kua'a̱ tíñu sɨkɨ̱‑ro̱. Ná júngo̱o‑yó, chi̱ kúsɨɨ̱ iní jito'o̱‑ro̱ jíín‑ró. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Te ni̱ jaa̱ tuku mozo ja̱ ni̱ ki'in uu̱ mil peso‑ún. Te ni̱ ka'a̱n‑i: Táta̱, ni̱ ja̱'a‑ní uu̱ mil peso nuu̱‑ná. Te yá'a nde̱'é‑ní, uu̱‑ga̱ mil peso ni̱ ni'i̱n‑ná sɨkɨ̱. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Te jito'o̱‑i, ni̱ ka'a̱n‑de jíín‑i: Ió va̱'a. Mozo skíkuu va̱'a kúu‑ró. Ni̱ skíkuu va̱'a‑ró jíín yakú‑ni ndatíñu. Ná cháa‑ri̱ kua'a̱ tíñu sɨkɨ̱‑ro̱. Ná júngo̱o‑yó, chi̱ kúsɨɨ̱ iní jito'o̱‑ro̱ jíín‑ró. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Yúan‑na te ni̱ jaa̱ mozo ja̱ ní ki'in ɨɨn mil peso‑ún, te ni̱ ka'a̱n‑i: Táta̱, a jiní‑ná níí ja̱ cháa xaa̱n iní kúu‑ní. Te já'nu̱‑ní nuu̱ tú jachá‑ní, te nástútú‑ní nuu̱ tú sáka‑ní. ");
INSERT INTO migNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Te ni̱ yu̱'ú‑ná. Te ni̱ ja'a̱n‑ná. Ni̱ chisa̱'í‑ná xu̱'ún‑ní chi̱i ñu'un. Te vina ná nákua̱'a‑ná xu̱'ún‑ní nuu̱‑ní. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Te jito'o̱‑i, ni̱ ka'a̱n‑de jíín‑i: Mozo ñáá, mozo kúxí kúu‑ró. Ni̱ jini̱‑ro̱ já já'nu̱‑ri̱ nuu̱ tú jachá‑ri̱, te nástútú‑rí nuu̱ tú sáka‑rí. ");
INSERT INTO migNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ní já'a‑ró xú'ún‑rí nuu̱ banco núú. Te nuu̱ ncháa̱‑ri̱, te naki'in‑ri̱ xu̱'ún‑rí onde̱ jíín sé'e xu̱'ún núú. Achí‑de jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yúan‑na te ni̱ kachi̱‑de jíín ɨngá mozo‑de: Núsáá te kuanchaa̱‑ro̱ mil peso jia̱n núu̱‑í. Te kua̱'a‑ró núu̱ mozo ja̱ ñáva̱'a uxi̱ mil peso‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chi ña̱yɨvɨ já á ñáva̱'a, te kii‑ga̱ nuu̱‑í, te ví'í‑gá kuñava̱'a‑i. Ko ña̱yɨvɨ já ná tú ñáva̱'a, va̱sa ja̱ á ñáva̱'a‑i‑ún, te kuxio ki'i̱n. ");
INSERT INTO migNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Te mozo ja̱ tú játíñu va̱'a‑ún, kiñi'in‑i ná kúndee‑i ñu̱ñáa yatá vé'e. Te yúan nde'e̱‑i, te nakaji‑í ñii yú'u‑í. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Te kɨvɨ̱ kíi máá Sé'e cha̱a ja̱ ndúñá'nu‑ya̱, te kikoyo ndɨ'ɨ ndajá'a̱ ndóo‑ya̱ jíín‑yá. Yúan‑na te jungo̱o‑ya̱ ɨ́ɨn nuu̱ silla tá'ú tíñu, chi̱ ñá'nu kuu‑ya̱ kúnchaa̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Te ndutútú táká ña̱yɨvɨ núu̱‑yá. Te sásɨ́ɨn‑ya̱‑í ná ɨɨn ná ɨɨn‑i jíná'an‑i, nátu̱'un ndusɨ́ɨn rɨɨ̱ jíín ndíxí'ú sá'a cha̱a ndíto‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Te kani‑ya̱ rɨ́ɨ̱‑ún ichi ndává'a‑ya̱, te ndixí'ú‑ún ichi ndávésé‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yúan‑na te máá Rey, kachi̱‑ya̱ kúni ña̱yɨvɨ ká'i̱in ichi ndává'a‑ya̱: Ichi yá'a kikoyo‑ró, chi̱ kúsɨɨ̱ iní Táa̱‑ri̱ jíín‑ró. Kɨ̱vɨ koyo‑ró ñúu̱ nuu̱ tá'ú‑ró tíñu, chi̱ a ni̱ sátu̱'a‑ya̱ ondé kɨvɨ̱ ní jungo̱o ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Chi ni̱ ji'i̱‑ri̱ so̱ko, te ni̱ kaja̱'a‑ró já ní yee‑rí. Ni̱ jichi̱‑ri̱ nducha, te ni̱ kaja̱'a‑ró já ní ji'i‑ri̱. Ni̱ jika tatú‑ri̱, te ni̱ kaja̱'a‑ró vé'e‑ró ní kanchaa̱ núu‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Víchí lɨ́ɨ‑rí, te ni̱ ka̱nachisúkun‑ro rúu̱. Ni̱ ku'u̱‑ri̱, te ni̱ kaja̱nde̱'é‑ró rúu̱. Ni̱ kandee‑ri̱ veka̱a, te ni̱ ja̱koyo‑ró núu̱‑rí. Achi̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yúan‑na te ka'a̱n ña̱yɨvɨ vá'a‑ún jíín‑yá: Táta̱, ndé kɨvɨ̱ ní kajini̱‑ná níí ja̱ ní ji'i̱‑ní so̱ko, te ni̱ kaja̱'a‑ná ja̱ ní yee‑ní, xí já ní jichi̱‑ní, te ni̱ kaja̱'a‑ná ja̱ ní ji'i‑ní vii. ");
INSERT INTO migNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Te ndé kɨvɨ̱ ní kajini̱‑ná níí ja̱ ní jika tatú‑ní, te ni̱ kaja̱'a núu‑ná ve'e‑ná nuu̱‑ní, xí já víchí lɨ́ɨ‑ní, te ni̱ ka̱nachisúkun‑ná níí. ");
INSERT INTO migNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Te ndé kɨvɨ̱ ní kajini̱‑ná níí ja̱ ní ku'u̱‑ní, xí já ní ka̱ndee‑ní veka̱a, te ni̱ kaja̱nde̱'é‑ná níí, achi̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yúan‑na te kachi̱ máá Rey‑ún kuni‑i: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ja̱ ná ni̱ ka̱sá'a‑ró súan jíín ɨ́ɨn ñani̱ lúlí‑rí yá'a, te nuu̱ rúu̱ ni̱ ka̱sá'a‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Yúan‑na te suni kachi̱‑ya̱ kúni ña̱yɨvɨ ká'i̱in ichi ndávésé‑yá‑ún: Ña̱yɨvɨ tá'nu̱ ndatu̱ kákuu‑ró. Kuxio ki̱ngoyo‑ró núu̱ kayú‑ro̱ nɨ́ɨ́ káni, nuu̱ íó tu̱'a ja̱ kúndee kui'na̱ jíín táká ndajá'a̱ máá. ");
INSERT INTO migNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Chi ni̱ ji'i̱‑ri̱ so̱ko te tú ní kája̱'a‑ró já kée‑rí. Ni̱ jichi̱‑ri̱ nducha te tú ní kája̱'a‑ró já kó'o‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ni̱ jika tatú‑ri̱ te tú ní kája̱'a‑ró vé'e‑ró kúnchaa̱ núu‑ri̱. Víchí lɨ́ɨ‑rí, te tú ní kánachisúkun‑ro rúu̱. Ni̱ ku'u̱‑ri̱, ni̱ ka̱ndee‑ri̱ veka̱a, te tú ní kája̱nde̱'é‑ró rúu̱. Achi̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yúan‑na te máá ñáyɨvɨ‑ún, suni ka'a̱n‑i jíín‑yá: Táta̱, ndé kɨvɨ̱ ní kajini̱‑ná níí ja̱ ní ji'i̱‑ní so̱ko, xí já ní jichi̱‑ní nducha, xí já ní jika tatú‑ní, xí já víchí lɨ́ɨ‑ní, xí já ní ku'u̱‑ní, xí já ní ka̱ndee‑ní veka̱a, te tú ní kájatíñu‑ná nuu̱‑ní vii. Achi̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yúan‑na te kachi̱ máá Rey jíín‑i: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ tú ní kásá'a‑ró súan jíín ɨ́ɨn ñani̱ lúlí‑rí yá'a, te ni nuu̱ rúu̱ tú ní kásá'a‑ró, achi̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Te ki̱ngoyo ña̱yɨvɨ yá'a nuu̱ ndó'o‑i nɨ́ɨ́ káni. Ko ña̱yɨvɨ ndáa̱‑ún, kɨ̱vɨ koyo‑i nuu̱ kúchaku̱‑i nɨ́ɨ́ káni, achi̱‑de. Achí Jesús. ");
INSERT INTO migNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Te nuu̱ ní ndɨ'ɨ ni̱ ka'a̱n Jesús ta̱ká tu̱'un yá'a, yúan‑na te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a jíín‑yá: ");
INSERT INTO migNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","A kájini̱‑ro̱ já úu̱‑na̱ kɨvɨ̱ te koo viko Pascua, te máá Sé'e cha̱a natu̱u‑ya̱ já kúu̱‑ya̱ jiká cruz, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yúan‑na te sutu̱ ñá'nu jíín cháa káchaa tutu̱ jíín cháa ni̱ ka̱yii ini̱ ñuu̱, ni̱ ka̱ndutútú‑de yu'u palacio máá sutú ñá'nu‑ga̱ ja̱ nání Caifás. ");
INSERT INTO migNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Te ni̱ kanda̱tu̱'ún‑de ndasa xndá'ú‑de Jesús, te katɨɨn‑de‑ya̱, te ka'ni‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Te ni̱ kaka'a̱n‑de: Ma̱ kúu sá'a‑yó máá kɨvɨ́ víko, chi̱ nú súan te ndonda vaa̱ ña̱yɨvɨ, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Te kándee Jesús ñuu̱ Betania kánchaa̱‑ya̱ iní ve̱'e Simón cha̱a té'yu̱ ndɨ̱'yi. ");
INSERT INTO migNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Te ni̱ chaa̱ ɨɨn ña'an núu̱‑yá kándá'á‑ña ɨ́ɨn tiya'a̱ ñú'un perfume ja̱ yá'u xaa̱n ncháá. Te ni̱ chi'i‑ña xiní‑yá nini yée‑yá staa̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Te cha̱a káskuá'a jíín‑yá, ni̱ kajini̱‑de yu̱án. Te ni̱ kakiti̱ ini̱‑de. Te ni̱ kaka'a̱n‑de: Naja̱ náa sáni perfume jia̱n. ");
INSERT INTO migNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Chi̱ jia̱n kúu kuya̱'u ya'u xaa̱n, te kua̱'a‑yó núu̱ ñáyɨvɨ ndá'ú núú. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Te ni̱ jini̱‑ni Jesús ja̱ súan íó. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Naja̱ kástá'a̱n‑ro̱ ñá'an yá'a. Ɨɨn tiñu va̱'a sá'a‑ña jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Chi̱ nene̱ káxiu̱kú ñáyɨvɨ ndá'ú jíín‑ró, ko ruu̱, na̱ tú nene̱ kánchaa̱‑ri̱ jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Chi ni̱ chi'i‑ña perfume yá'a yikɨ kúñu‑ri̱, náva̱'a sátu̱'a‑ña rúu̱ ja̱ yúji‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ nɨ́ɨ́ ñúyɨ́vɨ nú ná kuichá tu̱'un va̱'a yá'a, te tiñu ni̱ sá'a‑ña vína, suni koo tu̱'un náva̱'a ná núku̱'un ini̱‑i‑ña, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yúan‑na te ɨɨn tá'an ja̱ uxí uu̱‑de, nání‑de Judas Iscariote, ni̱ ja'a̱n‑de nuu̱ sutú ñá'nu jíná'an. ");
INSERT INTO migNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Te ni̱ ka'a̱n‑de jíín: Na̱ún kua̱'a‑ní nuu̱‑ná, te ná nástúu‑ná‑de nuu̱‑ní, áchí‑de. Te ni̱ kaja̱'a oko̱ uxi̱ peso nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yúan‑na te onde̱ kɨvɨ̱‑ún, ni̱ kejá'á‑de ndúkú‑de modo ndasa nastúu‑de‑ya̱ núu̱ sutú‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Te máá kɨvɨ́ kéjá'á víko kóo sta̱tilá tú yí'i yujan íá jíín, ni̱ ja̱koyo cha̱a káskuá'a‑ún nuu̱ Jesús. Te ni̱ kaka'a̱n‑de jíín‑yá: Ndénu̱ kuní‑ní ná kísátu̱'a‑ná nuu̱ kée‑ní lélú Pascua, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Te ni̱ ka'a̱n‑ya̱: Kuá'án onde̱ ñuu̱, nuu̱ ɨ́ɨn cha̱a yúan. Te kachi̱‑ro̱ kúni‑de: Achí máá Maestro, a ni̱ kuyani kɨvɨ̱‑rí. Vina te kee‑rí lélú Pascua ini̱ ve̱'e‑ró jíín cháa káskuá'a jíín‑rí. Achí‑ya̱. Achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Te cha̱a káskuá'a jíín‑yá, ni̱ skíkuu‑de tiñu ni̱ tá'ú Jesús nuu̱‑dé. Te ni̱ ka̱sátu̱'a‑de viko Pascua. ");
INSERT INTO migNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Te nuu̱ ní ini, te káyee‑yá staa̱ jíín uxí uu̱ cha̱a káskuá'a jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Te nini káyee‑yá staa̱ jíín‑de te ni̱ ka'a̱n‑ya̱: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ ɨ́ɨn róó nastúu ruu̱ vina, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Te ni̱ ka̱kukuí'a̱ xaa̱n iní‑de. Te ná ɨɨn ná ɨɨn‑de ni̱ kaka'a̱n‑de jíín‑yá: Táta̱, náá kúu náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yúan‑na te ni̱ ka'a̱n‑ya̱: Cha̱a ja̱ chíxí'ú núu̱ kó'o̱ jíín‑rí, cha̱a‑ún nastúu‑de ruu̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Chi ja̱ndáa̱ máá Sé'e cha̱a ki'i̱n‑ya̱ nátu̱'un yóso tú'un‑ya̱ núu̱ tutú. Ko naka̱ ndá'ú kuu cha̱a nastúu máá Sé'e cha̱a. Va'a̱‑ga̱ nú tú ní káku cha̱a‑ún núú, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yúan‑na te ni̱ ka'a̱n Judas ja̱ ní nastúu‑ya̱‑ún: Maestro, náá kúu náún, áchí‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ká'a̱n ndaa̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Te nini káyee‑dé, te ni̱ ki'in Jesús staa̱, te ni̱ jika̱n ta'u̱‑yá. Te ni̱ ja'ncha̱ sava‑ya̱. Te ni̱ ja̱'a‑ya̱ núu̱ cháa káskuá'a jíín‑yá. Te ni̱ ka'a̱n‑ya̱: Ki'in te kee‑ro, chi ya̱'á kúu yikɨ kúñu‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Te suni ni̱ ki'in‑ya̱ ɨ́ɨn taza. Te ni̱ jika̱n ta'u̱‑yá. Te ni̱ ja̱'a‑ya̱ núu̱‑dé jíná'an‑de. Te ni̱ ka'a̱n‑ya̱: Ko'o ta̱ká‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Chi ya̱'á kúu nɨñi̱‑rí ja̱ sá'a contrato jáá. Te játɨ ja̱ sɨkɨ́ kúa'a̱ ñáyɨvɨ náva̱'a koo tu̱ká'nu ini̱ nuu̱ táká kua̱chi‑i. ");
INSERT INTO migNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Te ká'a̱n‑ri̱ jíín‑ró, ja̱ ondé vina ma̱ kó'o‑ga̱‑ri̱ nducha ndé'e̱ uva yá'a onde̱ kɨvɨ̱ náko'o‑ri̱ ja̱ jáá jíín‑ró iní ñuu̱ nuu̱ tá'ú Táa̱‑ri̱ tiñu. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Te ni̱ ka̱jita‑ya̱ ɨ́ɨn yaa̱ ii̱. Te ni̱ kenda‑ya̱ kája'a̱n‑ya̱ ondé yuku Olivos. ");
INSERT INTO migNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de: Ndivii‑ro náyu̱'ú‑ro̱ já sɨkɨ́ rúu̱ akuáa vína. Chi̱ a yóso núu̱ tutú: Stují‑rí cha̱a ndíto rɨɨ̱, te tɨku'ni̱ rɨɨ̱‑ún, kuicha̱‑tɨ̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ko nuu̱ náchaku̱‑ri̱, te xna'a̱n‑ga̱ ruu̱ ki'i̱n‑ri̱ ñuu̱ Galilea vásá róó, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Te ni̱ ka'a̱n Pedro: Va̱sa ndɨ'ɨ‑de ná náyu̱'ú‑de, ko náá, chi ma̱ náyu̱'ú kutɨ‑ná, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Te ni̱ ka'a̱n Jesús jíín‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ ákuáa vína, onde̱ ná té kana‑ga̱ lí'li, te ma̱ kuátu̱'un‑ró rúu̱ uni̱ jínu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Te ni̱ ka'a̱n Pedro jíín‑yá: Va̱sa ná kúu̱‑ná jíín‑ní, ko ma̱ kasú‑ná yu'u‑ná ja̱ kúu níí, áchí‑de. Te suni súan ni̱ kaka'a̱n sava‑ga̱ cha̱a káskuá'a jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yúan‑na te ni̱ jaa̱ Jesús jíín‑de ndañúu̱ nání Getsemaní. Te ni̱ ka'a̱n‑yá jíín cháa káskuá'a‑ún: Yá'a‑ni jungo̱o‑ró nini ná kí'i̱n‑ri̱ onde̱ yúan kaka̱n ta'u̱‑rí, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Te ni̱ jaka‑ya̱ Pedro jíín ndéndúú se̱'e Zebedeo kua'a̱n‑de jíín‑yá. Te ni̱ kejá'á‑yá kúxíí iní‑ya̱, te ndúkuí'a̱ xaa̱n iní‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de: Xaa̱n ndúkuí'a̱ ini̱‑ri̱, chi̱ nátu̱'un a jí'i̱‑ri̱, yá'a kundatu‑ró te kundito‑ró jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Te ni̱ kanduu̱‑ya̱ ɨ́ɨn tí'lí‑na̱. Te ni̱ jukuiñi̱ jítɨ́‑yá. Te ni̱ jika̱n ta'u̱‑yá: Táa̱ máá‑ná, nú kuu te chaxio‑ní tu̱ndó'o‑ná yá'a ná kí'i̱n, ko nasu̱ já kuní máá‑ná kúu, chi ja̱ kuní máá‑ní, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Te ni̱ nchaa̱‑ya̱ núu̱ cháa káskuá'a jíín‑yá. Te ni̱ jini̱‑ya̱ já kákixi̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín Pedro: Tú kánda‑ró kúndito‑ró jíín‑rí va̱sté ɨ́ɨn hora náún. ");
INSERT INTO migNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kundito, te kaka̱n ta'u̱‑ro̱, náva̱'a ma̱ kóto nchaa̱‑ún róó. Chi̱ kuní ndija añú‑ro̱, ko yikɨ kúñu‑ró chi̱ túu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Te ni̱ ja'a̱n tuku‑ya̱ vuelta uu̱, te ni̱ jika̱n ta'u̱‑yá: Táa̱ máá‑ná, te nú ma̱ kúu kuxio tu̱ndó'o‑ná yá'a, ja̱ má kúndéé‑ná jíín, te ná kúu ja̱ kuní máá‑ní núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Te ni̱ nchaa̱‑ya̱ ɨngá jínu. Te ni̱ jini̱‑ya̱ já kákixi̱ tuku‑de, chi̱ xaa̱n káji'i̱‑de numa̱'ná. ");
INSERT INTO migNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Te ni̱ xndóo‑ya̱‑dé jíná'an‑de. Te ni̱ kee tuku‑ya̱ kuá'a̱n‑ya̱. Te ni̱ jika̱n ta'u̱‑yá ja̱ vuelta uni̱. Te suni ɨɨn‑ni tu̱'un ni̱ ka'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yúan‑na te ni̱ nchaa̱ tuku‑ya̱ núu̱ cháa káskuá'a jíín‑yá. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kusu̱ te ndeta̱tú‑ro̱‑ná. Vina te ni̱ jaa̱ hora ja̱ máá Sé'e cha̱a natu̱u‑ya̱ núu̱ ndá'a cháa ká'i̱o kua̱chi. ");
INSERT INTO migNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nduko̱o ná chó'o̱, chi cha̱a nástúu ruu̱, a ni̱ kuyani‑de va̱i‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Te nini sá súan ká'a̱n‑ya̱, te ni̱ chaa̱ Judas, ɨɨn tá'an ja̱ uxí uu̱‑ún. Te jíín‑de ni̱ ja̱koyo kua'a̱ xáa̱n ñáyɨvɨ jíín machete jíín yúnu. Chi̱ sutu̱ ñá'nu jíín cháa ni̱ ka̱yii ini̱ ñuu̱‑ún, ni̱ ka̱tájí ñáyɨvɨ‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Te cha̱a ni̱ nastúu‑ya̱‑ún, ni̱ ja̱'a‑de ɨɨn tuni̱. Te ni̱ ka'a̱n‑de: Cha̱a tiyú'ú‑rí‑ún, yu̱án kúu. Katɨɨn jíná'an‑ró. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Te ni̱ chaa̱‑ni‑de nuu̱ Jesús. Te ni̱ ka'a̱n‑de jíín‑yá: Ta̱rsíoo, Maestro, áchí‑de. Te ni̱ tiyú'ú‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Te ni̱ ka'a̱n Jesús jíín‑de: Amigo, na̱ sɨkɨ̱ vái‑ró, áchí‑ya̱. Yúan‑na te ni̱ ja̱koyo ña̱yɨvɨ‑ún. Te ni̱ ka̱katɨɨn‑ni‑i Jesús, kája'a̱n‑i jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Te ɨɨn cha̱a kándii̱ yúan jíín Jesús, ni̱ skáa̱‑de nda'a‑dé. Te ni̱ tava‑dé machete‑de. Te ni̱ stují‑dé ɨɨn mozo sutu̱ ñá'nu‑ún, ni̱ kachi‑ni‑de so̱'o. ");
INSERT INTO migNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de: Nachindee machete‑ro̱, chi ta̱ká ja̱ stáa machete, jíín machete kuu̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Xí jáni ini̱‑ro̱ já má kúu kaka̱n ta'u̱‑rí nuu̱ Táa̱‑ri̱ vina, te máá‑yá táji‑yá ví'í‑gá uxi̱ uu̱ mil ndajá'a̱ ándɨ́vɨ́ kíkoyo nuu̱‑rí náún. ");
INSERT INTO migNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ko nú súan, te ndasa skíkuu tu̱'un ká'a̱n tutu̱ ii̱ já kánúú kóo súan, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Te suni hora‑ún ni̱ ka'a̱n Jesús jíín ñáyɨvɨ kuá'a̱‑ún: Nátu̱'un sɨkɨ̱ ɨ́ɨn cha̱a kuí'ná vái koyo‑ró jíín machete jíín yúnu kátɨɨn‑ró rúu̱ náún. Ndɨta'a̱n kɨvɨ̱ ní kanchaa̱‑ri̱ jíín‑ró ní stá'a̱n‑ri̱ tu̱'un nuu̱‑ro̱ iní ve̱'e ii̱, te tú ní kákatɨɨn‑ró rúu̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Te súan kásá'a‑ró náva̱'a skíkuu tutu̱ ii̱ cháa ni̱ ka̱jani tu̱'un Dios, áchí‑ya̱. Yúan‑na te ta̱ká cha̱a káskuá'a jíín‑yá, ni̱ ka̱xndóo‑de‑ya̱. Te ni̱ ka̱jinu‑de kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Te cha̱a ni̱ ka̱katɨɨn Jesús, ni̱ jaka‑de‑ya̱ kuá'a̱n‑de jíín‑yá onde̱ ve'e Caifás, cha̱a kúu sutu̱ ñá'nu. Te yúan ká'i̱in tútú cháa káchaa tutu̱ jíín táká cha̱a ni̱ ka̱yii. ");
INSERT INTO migNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ko Pedro, jíká‑ni ndikín‑de‑ya̱ ondé ni̱ jaa̱‑de yuxé'é sutú ñá'nu‑ún. Te ni̱ kɨ̱vɨ‑de ichi iní ni̱ jungo̱o‑de jíín cháa kájatíñu yúan, náva̱'a kuni̱‑de ndasa koo. ");
INSERT INTO migNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Te ta̱ká sutu̱ ñá'nu jíín táká cha̱a ni̱ ka̱yii jíín táká cha̱a junta, ni̱ ka̱ndúkú‑de tu̱'un tú'ún sɨkɨ́ Jesús náva̱'a ka'ni‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ko tú ní káni'i̱n‑dé modo, va̱sa ni̱ cha̱koyo kua'a̱ testigo falso. Ko onde̱ sandɨ̱'ɨ́‑na̱ ni̱ cha̱koyo uu̱‑ga̱, ");
INSERT INTO migNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Te ni̱ kaka'a̱n: Cha̱a yá'a ni̱ ka'a̱n‑de: Kuu stúncháa̱‑ri̱ ve'e ii̱ Dios, te nuu̱ uní‑ni kɨvɨ̱ te nachutá'an‑ri̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Te ni̱ ndukuiñi̱ máá sutú ñá'nu. Te ni̱ jika̱ tu̱'ún‑de‑ya̱: Tú ka'a̱n kutɨ‑ro náún. Ndasa káka'a̱n cha̱a yá'a sɨkɨ̱‑ro̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ko tú ní ká'a̱n kutɨ Jesús. Te ni̱ ka'a̱n máá sutú ñá'nu: Onde̱ jíín Dios I'a̱ chakú, ká'a̱n ni̱'in‑ri̱ jíín‑ró. Kastu̱'ún te nú máá‑ró kúu Cristo, Se̱'e Dios xí túu, áchí jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Te ni̱ ka'a̱n Jesús jíín‑de: Ká'a̱n ndaa̱‑ro̱. Te ná kástu̱'ún‑rí nuu̱‑ro̱, ja̱ ɨngá kɨvɨ̱ te kuni̱‑ro̱ núu̱ máá Sé'e cha̱a kunchaa̱‑ya̱ íchi ndává'a I'a̱ ndíso fuerza. Te ndii‑ya̱ jíín vikó andɨ́vɨ́. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yúan‑na te máá sutú ñá'nu‑ga̱, ni̱ ndátá‑de sa'ma‑dé. Te ni̱ ka'a̱n‑de: Aa̱j, ká'a̱n ndɨva̱'a‑de. Na̱ún nɨ́nɨ kúni so̱'o‑yó ká'a̱n ɨnga̱ testigo núsáá. Vina a ni̱ ka̱jini so̱'o‑ró já ká'a̱n ndɨva̱'a‑de. ");
INSERT INTO migNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ndasa kájani ini̱‑ro̱, áchí‑de. Te ni̱ kaka'a̱n sava‑ga̱: Ió va̱'a ja̱ kúu̱‑de, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yúan‑na te ni̱ katɨvɨ̱ sɨ̱'vɨ́‑de nuu̱‑yá. Te ni̱ kaja̱'a‑de ji̱kí núu̱‑yá. Te sava‑de, ni̱ ka̱katu‑dé yikɨ núu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Te ni̱ kaka'a̱n‑de: Róó Cristo, kastu̱'ún ndé cha̱a ni̱ stují róó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Te kánchaa̱ Pedro yata̱ vé'e‑ún. Te ɨɨn ña'an játíñu, ni̱ jaa̱‑ña núu̱‑dé. Te ni̱ ka'a̱n‑ña: Te róó, jíín Jesús ñuu̱ Galilea jíka‑ró vii, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ko máá‑de, tú ní játu̱'un‑de jíto nuu̱ táká ña̱yɨvɨ: Tú jiní‑ná na̱ún tu̱'un ká'a̱n‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Te ni̱ kenda‑de yuxé'é‑ún kua'a̱n‑de. Te ni̱ jini̱ ɨnga̱‑ña núu̱‑dé. Te ni̱ ka'a̱n‑ña jíín ñáyɨvɨ ká'i̱in yúan: Cha̱a yá'a suni jíka kuu‑de jíín Jesús ñuu̱ Nazaret, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Te ɨnga̱ jínu tú ní játu̱'un‑de. Sa máá‑de ni̱ nduni̱'in yu'u‑dé: Tú jiní‑ri̱ cha̱a jia̱n, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Te ni̱ kunúu. Te ña̱yɨvɨ ká'i̱in yúan ni̱ ja̱koyo‑i nuu̱‑dé. Te ni̱ kaka'a̱n‑i jíín Pedro: Ja̱ndáa̱ ja̱ súni tá'an‑de kúu‑ró, chi tu̱'un ká'a̱n‑ro̱ nástúu róó, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yúan‑na te ni̱ kejá'á ní'in ká'a̱n ndɨva̱'a‑de: Tú jiní‑ri̱ cha̱a jia̱n, áchí‑de. Te ni̱ kana‑ni lí'li. ");
INSERT INTO migNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Te ni̱ nuku̱'un ini̱ Pedro tu̱'un Jesús, ja̱ ní ka'a̱n‑ya̱ jíín‑de: Onde̱ ná té kana‑ga̱ lí'li, te ma̱ kuátu̱'un‑ró rúu̱ uni̱ jínu. Te ni̱ kenda‑de kua'a̱n‑de. Te ni̱ nde'e̱ xaa̱n‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yúan‑na te ni̱ kundiji̱n. Te ta̱ká sutu̱ ñá'nu jíín cháa ni̱ ka̱yii, ni̱ ka̱skétá'an‑de tu̱'un ja̱ ká'ni‑dé Jesús. ");
INSERT INTO migNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Te ni̱ kaju'ni̱‑de‑ya̱. Te kua'a̱n‑de jíín‑yá nuu̱ Poncio Pilato, cha̱a kúu gobernador. ");
INSERT INTO migNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yúan‑na te Judas, cha̱a ni̱ nastúu‑ya̱‑ún, ni̱ jini̱‑de ja̱ ni̱ kuni̱'in sɨkɨ̱‑yá. Te ni̱ nakani ini̱‑de. Te nákua̱'a‑de oko̱ uxi̱ peso‑ún nuu̱ sutú ñá'nu jíín núu̱ cháa ni̱ ka̱yii‑ún núú. ");
INSERT INTO migNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Te ni̱ ka'a̱n‑de: Ni̱ sá'a‑ná kua̱chi. Ni̱ nastúu‑ná ɨɨn cha̱a ja̱ tú íó ni ɨɨn kua̱chi sɨkɨ̱‑dé, áchí‑de. Ko máá sutú‑ún ni̱ kaka'a̱n‑de: Na̱ún jítú iní‑ri̱. Sɨkɨ̱ máá‑ró kúu. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Te ni̱ súngoyo Judas oko̱ uxi̱ peso‑ún ini̱ ve̱'e ii̱. Te ni̱ kee‑de kua'a̱n‑de. Te ni̱ skuá'ñá‑de máá‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Te sutu̱ ñá'nu‑ún, ni̱ ka̱nastútú‑de xu̱'ún‑ún. Te ni̱ kaka'a̱n‑de: Ma̱ kúu chú'un‑yó xú'ún yá'a ini̱ janu̱ núu̱ kásoko̱‑í, chi xu̱'ún yá'u nɨñi̱ kúu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ko ni̱ kanda̱tu̱'ún‑de. Te ni̱ ka̱jaan‑de ɨɨn ndu'a̱ ñu'un kíxín jíín xú'ún‑ún, náva̱'a yúan yu̱ji ta̱ká ña̱yɨvɨ jíká. ");
INSERT INTO migNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ja̱ yúán nání ñú'un‑ún onde̱ vina: Ñu'un nɨñí. ");
INSERT INTO migNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yúan‑na te ni̱ skíkuu tu̱'un ni̱ ka'a̱n Jeremías cha̱a ni̱ jani tu̱'un Dios: Ni̱ ka̱ki'in‑i ndɨ́'okó uxi̱ peso‑ún, ya̱'u I'a̱ ni̱ kundaa̱ ya̱'u‑ya̱, chi̱ yaku̱ cha̱a Israel, ni̱ ka̱sándaa̱‑de ja̱ kúya̱'u‑ya̱, ");
INSERT INTO migNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Te ni̱ kaja̱'a‑i xu̱'ún‑ún ja̱ sɨkɨ́ ɨ́ɨn ndu'a̱ ñu'un kíxín, nátu̱'un ni̱ tá'ú máá Tatá Dios tiñu nuu̱‑rí, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Te Jesús, kándichi̱‑ya̱ núu̱ gobernador. Te gobernador‑ún ni̱ jika̱ tu̱'ún‑de‑ya̱: Máá‑ró kúu rey cha̱a judío náún, áchí‑de. Te ni̱ ka'a̱n Jesús jíín‑de: Ká'a̱n ndaa̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Te ta̱ká sutu̱ ñá'nu, ni̱ kajika̱n‑de kua̱chi sɨkɨ̱‑yá. Ko tú ní xndíó káni‑ya̱ ní ɨɨn tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yúan‑na te ni̱ ka'a̱n Pilato jíín‑yá: Te tú jíni so̱'o‑ró na̱saa kua̱chi kájika̱n cha̱a yá'a sɨkɨ̱‑ro̱ náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Te tú ní ká'a̱n kutɨ‑yá ni ɨɨn tu̱'un jíín‑de. Te ni̱ naa iní gobernador ndé'é‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Te íó costumbre gobernador ja̱ kɨvɨ́ víko yúan sía̱‑de ɨɨn preso, nú ndéja̱ kájata'a̱n ini̱ máá ñáyɨvɨ ñúu̱‑ún sía̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Te suu kɨvɨ̱‑ún íó ɨɨn cha̱a kándee preso nání‑de Barrabás, te ni̱ jicha̱ tu̱'un‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Te ni̱ ka̱ndutútú ñáyɨvɨ te ni̱ ka'a̱n Pilato jíín‑i: Ndé cha̱a kákuni̱‑ro̱ já sía̱‑ri̱ vina, á Barrabás xí Jesús, cha̱a ja̱ nání Cristo, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Chi̱ a ni̱ juku̱'un ini̱‑de ja̱ ní ka̱kukuásún iní sutu̱ ñá'nu, te yu̱án ní ka̱nastúu‑de Jesús. ");
INSERT INTO migNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Te nini kánchaa̱ Pilato ini̱ ve̱'e tíñu, te ni̱ tájí ñásɨ́'ɨ́‑de tu̱'un nuu̱‑dé: Ma̱ sá'a‑ró cuenta ja̱ kúu sɨkɨ̱ cháa va̱'a jia̱n, chi̱ kuni, xaa̱n ní siyú'ú ja̱ni ruu̱ ja̱ sɨkɨ́‑dé, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ko sutu̱ ñá'nu jíín cháa ni̱ ka̱yii‑ún, ni̱ ka̱ská'a̱n‑de ña̱yɨvɨ já ná kakán‑i Barrabás ka̱ku‑de, te Jesús ná kúu̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Te gobernador, ni̱ jika̱ tu̱'ún‑de‑i: Ja̱ úu̱ tá'a̱n‑de, te ndé ɨɨn‑de kuní‑ro̱ sía̱‑ri̱, áchí‑de. Te ni̱ kaka'a̱n‑i: Sía̱‑ní Barrabás, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Te ni̱ ka'a̱n Pilato jíín‑de: Núsáá te ndasa sá'a‑ri̱ jíín Jesús, cha̱a nání Cristo, áchí‑de. Te ni̱ kaka'a̱n ndɨ'ɨ‑i: Ná kúu̱‑de jika̱ cruz, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Te gobernador, ni̱ ka'a̱n‑de jíín‑i: Na̱ún kua̱chi ni̱ sá'a‑de núsáá, áchí‑de. Ko máá ñáyɨvɨ‑ún, ví'í‑gá ni̱ kaka'a̱n jaa‑i: Ná kúu̱‑de jika̱ cruz, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Te ni̱ jini̱ Pilato ja̱ tú kúndéé‑de jíín ñáyɨvɨ, chi̱ sasua kándonda vaa̱‑ga̱‑i. Te ni̱ ki'in‑de nducha. Te ni̱ nandá'á‑de jíto nuu̱ ñáyɨvɨ kuá'a̱‑ún. Te ni̱ ka'a̱n‑de: Tú na̱ kua̱chi máá‑rí íó ja̱ kúnchaa̱ nɨñi̱ cháa va̱'a yá'a sɨkɨ̱‑rí. Sɨkɨ̱ máá‑ró ná kúu. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Te ni̱ kaka'a̱n ta̱ká ña̱yɨvɨ: Ma̱ yú'ú‑ní, chi̱ sɨkɨ̱ máá‑ná jíín sɨkɨ́ sé'e‑ná ná kúnchaa̱ kua̱chi nɨñi̱‑dé, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yúan‑na te ni̱ sía̱‑de Barrabás kua'a̱n. Te ni̱ xndó'o‑de Jesús. Te ni̱ nakua̱'a‑de‑ya̱ já kúu̱‑ya̱ jiká cruz. ");
INSERT INTO migNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Te soldado gobernador, ni̱ ka̱jaka‑de Jesús kua'a̱n‑de jíín‑yá ini̱ ve̱'e palacio. Te ni̱ ka̱kana‑de xini̱ tá'an‑de ni̱ ka̱ndutútú‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Te ni̱ ka̱sávíchí‑de‑ya̱. Te ni̱ ka̱chu'un‑de‑ya̱ ɨ́ɨn sa'ma kuá'á tíndí'í. ");
INSERT INTO migNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Te ni̱ ka̱tɨɨn‑de ɨɨn corona iñu. Te ni̱ ka̱chu'un‑de xini̱‑yá. Te ni̱ ka̱chi'i‑de yunu ndává'a‑ya̱. Te ni̱ ka̱jukuiñi̱ jítɨ́‑de nuu̱‑yá, ni̱ ka̱sákátá‑de nuu̱‑yá: Rey judío, ta̱á ndii, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Te ni̱ katɨvɨ̱ sɨ̱'vɨ́‑de nuu̱‑yá. Te ni̱ ka̱kiñi'in‑de yunu‑ún nda'a‑yá. Te ni̱ ka̱stují‑dé xini̱‑yá jíín. ");
INSERT INTO migNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Te nuu̱ ní ndɨ'ɨ ni̱ ka̱sákátá‑de nuu̱‑yá, te ni̱ ka̱nakuanchaa̱‑de sa'ma ñú'un‑ya̱‑ún. Te ni̱ ka̱nachu'un‑de‑ya̱ sá'ma máá‑yá. Te ni̱ ka̱keñi'in‑de‑ya̱ kuíta kaa‑ya̱ jiká cruz. ");
INSERT INTO migNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Te nuu̱ ní ka̱kenda‑de, te ni̱ ka̱ketá'an‑de jíín ɨ́ɨn cha̱a ñuu̱ Cirene nání‑de Simón. Te ni̱ ka̱tetíñu‑de cha̱a‑ún ki'i̱n‑de jíín‑yá, kundiso‑de cruz‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Te ni̱ ja̱koyo‑de ɨɨn tɨnduu̱ nání Gólgota, ja̱ kuní ka'a̱n: Yikɨ xiní. ");
INSERT INTO migNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Te ni̱ kaja̱'a‑de vino jíín súsia ua̱ ja̱ kó'o‑ya̱. Ko nuu̱ ní jito nchaa̱‑ya̱, te tú ní kuní‑ya̱ kó'o‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Te nuu̱ ní ndɨ'ɨ ni̱ ka̱jata kaa‑de‑ya̱ jiká cruz, te ni̱ ka̱saka‑dé sa'ma‑yá nuu̱ tá'an‑de, te ni̱ ka̱sá'a‑de ɨɨn apuesto sɨkɨ̱. Te ni̱ skíkuu tu̱'un ká'a̱n cha̱a ni̱ jani tu̱'un Dios: Ni̱ ka̱ndátá‑i sa'ma‑rí, te sɨkɨ̱ sú'nu̱‑rí ni̱ ka̱sá'a‑i ɨɨn apuesto, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yúan‑na te ni̱ kaju̱ngo̱o‑de yúan, ni̱ kande̱'é‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Te ni̱ ka̱chaa‑de ɨɨn tu̱'un xini̱ cruz‑ya̱ já kúu kua̱chi‑ya̱: Ya̱'á kúu Jesús Rey ña̱yɨvɨ judío, áchí. ");
INSERT INTO migNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Te ni̱ ka̱jata kaa‑de uu̱ ñakui̱'ná jíín‑yá. Ɨɨn ichi ndává'a‑ya̱, te ɨnga̱ ichi ndávésé‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Te ña̱yɨvɨ kája̱'a yúan, ni̱ káskuíkó‑i xini̱‑í. Te ni̱ kaka'a̱n ndɨva̱'a‑i jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Róó ká'a̱n‑ro̱ já stúncháa̱‑ro̱ vé'e ii̱ te nuu̱ uní kɨvɨ̱ te ndukani‑ró núú, nú Se̱'e Dios kúu‑ró, núsáá te nama‑ró máá‑ró, te nuu‑ró jiká cruz vii, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Te sutu̱ ñá'nu jíín cháa káchaa tutu̱ jíín cháa fariseo jíín cháa ni̱ ka̱yii, suni súan ni̱ ka̱sákátá‑de nuu̱‑yá. Te ni̱ kaka'a̱n‑de: ");
INSERT INTO migNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Sava ña̱yɨvɨ, ni̱ nama‑de‑i, ko ma̱ kúu nama‑de máá‑de. Nú rey ña̱yɨvɨ Israel kúu‑de, te ná núu‑de jika̱ cruz vina. Yúan‑na te ná kándíja‑yó‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kándíja‑de nuu̱ Dios, te ná náma máá‑yá‑de vina te nú kuní máá‑yá, chi ni̱ ka'a̱n‑de: Máá‑rí kúu Se̱'e Dios, áchí‑de. Achí. ");
INSERT INTO migNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Te ñakui̱'ná kándi̱ta kaa jíín‑yá jika̱ cruz, suni ɨɨn‑ni tu̱'un ni̱ kaka'a̱n ndɨva̱'a jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Te nuu̱ ní kuu ka̱'uxi̱ uu̱ te ni̱ kuxkɨ'vɨ̱ nɨ́ɨ́ núu̱ ñú'un onde̱ ka̱'uni̱. ");
INSERT INTO migNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Te a yani ka̱'uni̱ aíni, ni̱ ka'a̱n jaa Jesús: Elí, Elí, lama sabactani, áchí‑ya̱. Ya̱'á kuní ka'a̱n: Dios máá‑ná, Dios máá‑ná, naja̱ ní xndóo‑ní náá. ");
INSERT INTO migNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Te sava ña̱yɨvɨ ká'i̱in yúan, ni̱ ka̱jini so̱'o‑i tu̱'un‑ún. Te ni̱ kaka'a̱n‑i: Kána cha̱a yá'a xini̱ Elías, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Te jínu ɨɨn cha̱a ni̱ jaa̱‑de. Te ni̱ ki'in‑de kachi̱, ni̱ chindaji‑de nuu̱ vinagre. Te ni̱ chaa‑de xini̱ ɨ́ɨn yunu. Te ni̱ ja̱'a‑de nuu̱‑yá ja̱ kó'o‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Te ni̱ kaka'a̱n sava‑ga̱‑i: Sía̱, nándéó nú chaa̱ Elías nama‑de cha̱a xí túu, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ko máá Jesús, ni̱ ka'a̱n jaa‑ya̱ ɨngá jínu. Te ni̱ ji'i̱‑ni‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yúan‑na te sa'ma ndíta kaa onde̱ ini̱ ve̱'e ii̱, ni̱ te'nde̱ uu̱ onde̱ nuu̱ xiní, te onde̱ nuu̱ já'a̱. Te ni̱ ta̱an ñu̱yɨ́vɨ. Te toto, ni̱ kandata̱. ");
INSERT INTO migNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Te suni ni̱ ka̱nanuña ve'e añú. Te kua'a̱ ndɨ́yi cha̱a ndoo, ja̱ á ni̱ kaji'i̱‑de, ni̱ kanachaku̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Te nuu̱ á ni̱ nachaku̱‑ya̱, te ni̱ ka̱ndenda koyo‑de ini̱ ve̱'e añú. Te ni̱ ndɨ̱vɨ koyo‑de ini̱ ñuu̱ ii̱. Te ni̱ ka̱ndenda ndiji̱n‑de nuu̱ kuá'a̱ ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Te cha̱a capitán, jíín cháa kándi̱to Jesús jíín‑de, ni̱ kajini̱‑de ja̱ ní ta̱an, jíín táká tiñu ni̱ kuu. Te ni̱ kayu̱'ú téyíí‑de. Te ni̱ kaka'a̱n‑de: Ja̱ndáa̱ ja̱ Sé'e Dios kúu cha̱a yá'a núú, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Te ká'i̱in kua'a̱ ñásɨ́'ɨ́ yúan kánde̱'é jíká‑ni‑ña. Te suu ña'an‑ún, ni̱ kandiki̱n‑ña Jesús onde̱ ñuu̱ Galilea va̱i‑ña kájatíñu‑ña núu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Te jíín ñá'an yúan ká'i̱in María ñuu̱ Magdala, jíín María náa̱ Jacobo jíín José, jíín náa̱ se̱'e Zebedeo. ");
INSERT INTO migNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Te ni̱ ini kɨvɨ̱‑ún. Te ni̱ jaa̱ ɨɨn cha̱a kúká ñúu̱ Arimatea, nání‑de José, chi̱ suni ɨɨn cha̱a ni̱ skuá'a jíín Jesús kúu‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Cha̱a yá'a, ni̱ jaa̱‑de nuu̱ Pilato. Te ni̱ jika̱n‑de yikɨ kúñu Jesús. Te ni̱ tá'ú tíñu Pilato ja̱ ná kuá'a‑i yikɨ kúñu Jesús nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Te ni̱ ki'in José ndɨ̱yi‑ún. Te ni̱ chisúkun‑dé‑ya̱ jíín ɨ́ɨn sa'ma kuítá ndóo. ");
INSERT INTO migNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Te ni̱ chindee‑de‑ya̱ iní ve̱'e añú jáá ñáva̱'a‑de, ja̱ ní jacha jika̱ ɨ́ɨn kava. Te ni̱ stúu‑dé ɨɨn yuu̱ ká'nu, ni̱ jasu̱‑de yuxé'é añú‑ún. Te kua'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Te María ñuu̱ Magdala jíín ɨngá María, káxiu̱kú‑ña yúan ichi núu̱ vé'e añú‑ún. ");
INSERT INTO migNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Te ni̱ kuu kɨvɨ̱ xía̱n. Te iku‑ún ni̱ kuu kɨvɨ̱ ní ka̱sátu̱'a‑i máá‑i. Te ta̱ká sutu̱ ñá'nu jíín cháa fariseo, ni̱ ka̱ndutútú‑de nuu̱ Pilato. ");
INSERT INTO migNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Te ni̱ kaka'a̱n‑de: Táta̱, kánuku̱'un ini̱‑ná ja̱ cháa xndá'ú ñá'án‑ún, onde̱ ná chakú‑ga̱‑de núú, te ni̱ ka'a̱n‑de: Nuu̱ uní kɨvɨ̱ te nachaku̱‑ri̱, ");
INSERT INTO migNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Núsáá, te tá'ú tíñu‑ní ná kúkútu yúyaú‑ún onde̱ ji̱nu nuu̱ uní kɨvɨ̱. Chi̱ nú túu te sanaa kíi cha̱a ni̱ ka̱skuá'a jíín‑de‑ún akuáa, te nasákuí'ná‑de ndɨ̱yi‑ún ki'i̱n‑de jíín. Yúan‑na te kachi̱‑de kuni ña̱yɨvɨ: Ni̱ nachaku̱‑ya̱ já ní ji'i̱‑ya̱, achi̱‑de. Te ká'ú‑ga̱ kuu tu̱'un xndá'ú yúan vásá já xnáñúú, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Te ni̱ ka'a̱n Pilato jíín‑de: Yá'a ká'i̱o soldado. Kuá'án jíín‑de, te sákútu máá‑ró yúyaú‑ún nú ndasa kájini̱‑ro̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Te kája'a̱n‑de. Te ni̱ ka̱sákútu‑dé ve'e añú. Te jíín sello ni̱ kajasu̱ va̱'a‑de sɨkɨ̱ yúu̱ já ndí'u̱ yuyaú‑ún. Te ká'i̱in soldado jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Te ni̱ ja̱'a kɨvɨ̱ ndéta̱tú‑ún. Te ni̱ kundiji̱n kɨvɨ̱ ɨ́ɨn semana. Te María ñuu̱ Magdala jíín ɨngá María‑u̱n, ni̱ kaja̱nde̱'é‑ña vé'e añú‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Te ɨɨn ndajá'a̱ máá Tatá Dios, ni̱ kuun‑ya̱ íchi ándɨ́vɨ́ ní chaa̱‑ya̱. Chi ni̱ ta̱an xaa̱n ní sá'a‑ya̱. Te ni̱ stúu‑yá yuu̱‑ún kua'a̱n. Te ni̱ jungo̱o‑ya̱ sɨkɨ́. ");
INSERT INTO migNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Te ndíi ncháa̱ núu̱‑yá. Te su'nu̱ ñú'un‑ya̱ káa nátu̱'un yu'a̱ volcán. ");
INSERT INTO migNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Te soldado kándi̱to yúan, ni̱ kayu̱'ú‑de, te kákɨsɨ‑i‑de ni̱ sá'a‑ya̱. Te ni̱ kaku̱ndɨ̱yí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Te ni̱ ka'a̱n ndajá'a̱ jíín ñá'an‑ún: Ma̱ yú'ú‑ro̱, chi̱ a jiní‑ri̱ ja̱ kánandúkú‑ró Jesús, I'a̱ ni̱ ji'i̱ jika̱ cruz. ");
INSERT INTO migNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Túu‑ya̱ yá'a, chi̱ a ni̱ nachaku̱‑ya̱ nátu̱'un ni̱ ka'a̱n‑ya̱. Ña'a̱n te nde̱'é‑ró núu̱ ní ka̱túu máá Jíto'o̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kuángoyo yachi̱ te kachi̱‑ro̱ núu̱ cháa ni̱ ka̱skuá'a jíín‑yá, ja̱ á ni̱ nachaku̱‑ya̱ má'ñú ndɨ́yi. Te ja̱ndáa̱ xna'a̱n‑ga̱ ki'i̱n‑ya̱ ñúu̱ Galilea vásá kí'i̱n‑ro̱. Te yúan kuni̱‑ro̱ núu̱‑yá. Achi̱‑ro̱ kúni‑de. Kástu̱'ún ndíja‑ri̱ nuu̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Te máá‑ña káyu̱'ú‑ña te kákusɨɨ̱ iní‑ña. Te ni̱ ka̱ndenda‑ña iní ve̱'e añú‑ún. Te ni̱ ka̱jinu‑ña kuákastu̱'ún‑ña núu̱ cháa káskuá'a jíín‑yá. Te nini kája'a̱n‑ña núu̱‑dé, ");
INSERT INTO migNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Te ni̱ kenda‑ni Jesús ni̱ ketá'an‑ya̱ jíín‑ña. Te ni̱ ka'a̱n‑ya̱ jíín‑ña: Ta̱á ndii, áchí‑ya̱. Te ni̱ ka̱nuu‑ña sukún já'a̱‑yá, te ni̱ ka̱chiñú'ún‑ña‑yá. ");
INSERT INTO migNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yúan‑na te ni̱ ka'a̱n Jesús jíín‑ña: Ma̱ yú'ú‑ro̱ jíná'an‑ró. Kuá'án te kastu̱'ún‑ró núu̱ ñaní‑ri̱ ja̱ ná kíngoyo‑de onde̱ ñuu̱ Galilea. Te yúan kuni̱‑de nuu̱‑rí. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Te nini kája'a̱n‑ña, te sava soldado kándi̱to ve'e añú‑ún, káno'o̱n‑de onde̱ ñuu̱. Te ni̱ kaka̱stu̱'ún‑de nuu̱ sutú ñá'nu ta̱ká tiñu ja̱ súan ni̱ i̱o. ");
INSERT INTO migNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Te ni̱ ndutútú‑de jíín cháa ni̱ ka̱yii. Te ni̱ kanda̱tu̱'ún‑de. Te ni̱ kaja̱'a‑de kua'a̱ xú'ún núu̱ soldado jíná'an. ");
INSERT INTO migNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Te ni̱ kaka'a̱n‑de: Súan ka'a̱n‑ro̱ jíná'an‑ró: Cha̱a káskuá'a jíín máá‑de, ni̱ kikoyo akuáa, te ni̱ ka̱nasákuí'ná ndɨ́yi‑ún nini kákixi̱‑ná, achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Te nú tu̱'un yá'a ná kúni so̱'o gobernador, te máá‑rí, kiská'a̱n‑ri̱‑de, náva̱'a ma̱ kóo kua̱chi sɨkɨ̱ máá‑ró. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Te soldado, ni̱ ka̱ki'in‑de xu̱'ún. Te ni̱ ka̱sá'a‑de nátu̱'un ni̱ ta'u̱ tíñu nuu̱‑dé. Te tu̱'un yá'a ni̱ jicha̱ kua'a̱n nɨ́ɨ́ ñúu̱ ña̱yɨvɨ judío onde̱ vina. ");
INSERT INTO migNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Te ndɨ́'uxí ɨɨn cha̱a káskuá'a‑ún, ni̱ kee‑de kája'a̱n‑de onde̱ ñuu̱ Galilea, onde̱ yuku núu̱ ní tá'ú tíñu Jesús nuu̱‑dé ja̱ kí'i̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Te ni̱ kajini̱‑de nuu̱‑ya, te ni̱ ka̱chiñú'ún‑de‑ya̱. Ko sava‑de tú ní kákandíja‑de. ");
INSERT INTO migNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Te ni̱ chaa̱ Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Sɨkɨ̱‑rí, a ni̱ chaa Dios ta̱ká fuerza ja̱ íó ini̱ andɨ́vɨ́ jíín iní ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Núsáá te kuá'án jíná'an‑ró. Te stá'a̱n‑ro̱ tú'un nuu̱ táká ña̱yɨvɨ, ná chú'un ini̱‑i. Te skuánducha‑ro‑í onde̱ jíín sɨ́'vɨ́ máá Táa̱‑yo̱ jíín sɨ́'vɨ́ máá Sé'e, jíín sɨ́'vɨ́ máá Espíritu Santo. ");
INSERT INTO migNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Te stá'a̱n‑ro̱ núu̱‑í ná kuándatu̱‑i ta̱ká tiñu ni̱ tá'ú‑rí nuu̱‑ro̱. Te máá‑rí kaka ndija‑ri̱ jíín‑ró nɨ́ɨ́ káni onde̱ kɨvɨ̱ ndɨ́'ɨ ñu̱yɨ́vɨ. Achí‑ya̱. Amén.");
INSERT INTO migNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yá'a kéjá'á tú'un va̱'a máá Jesucristo, Se̱'e Dios. ");
INSERT INTO migNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Te súan ni̱ chaa Isaías tutu̱, chi cha̱a jáni tu̱'un Dios ni̱ kuu‑de sáá: Kuni so̱'o‑ró, chi̱ tájí‑rí ndajá'a̱‑rí kuxnúú‑de jaa̱‑de sátu̱'a‑de ichi‑ro. ");
INSERT INTO migNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Te ndajá'a̱‑ún, kana jaa‑de onde̱ nuu̱ ñú'un té'é: Sátu̱'a‑ró íchi máá Jíto'o̱‑yo̱ te sándóó‑ró íchi‑yá, achi̱‑de, áchí Isaías. ");
INSERT INTO migNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Te Juan, ni̱ skuánducha‑dé onde̱ nuu̱ ñú'un té'é. Te ni̱ jani‑de tu̱'un jánducha jíín tú'un nakani ini̱, náva̱'a sá'a Dios tu̱ká'nu ini̱ nuu̱ kuáchi. ");
INSERT INTO migNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Te ni̱ cha̱koyo ta̱ká ña̱yɨvɨ ndáñúu̱ Judea, jíín táká ña̱yɨvɨ ñúu̱ Jerusalén. Te ni̱ skuánducha‑dé‑i ini̱ yu̱cha Jordán. Te kánakani ndaa̱‑i kua̱chi‑i yúan. ");
INSERT INTO migNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Te sa'ma ní ñu̱'un Juan ni̱ kuu ixi camello, jíín ɨ́ɨn sánchi̱i ñii nú'ni̱ chi̱i‑de. Te ni̱ yee‑dé ndɨkuá'yú jíín ndúxi yoko̱ yuku. ");
INSERT INTO migNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Te ni̱ jani‑de tu̱'un: Ichi yatá‑rí va̱i ɨɨn I'a̱ kúñá'nu‑ga̱ vásá rúu̱, ja̱ tú kúñá'nu‑ri̱ jukui̱ta ndee‑ri̱ te ndájí‑rí ñii yí'i ndija̱n‑yá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Te ruu̱, chi̱ jíín ndúcha skuánducha‑rí róó jíná'an‑ró, ko I'a̱‑ún, chi̱ jíín Espíritu Santo skuánducha‑yá róó, áchí Juan. ");
INSERT INTO migNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Te ni̱ kuu kɨvɨ̱. Te Jesús, ni̱ kenda‑ya̱ ñúu̱ Nazaret ndañúu̱ Galilea. Te ni̱ janducha‑yá ni̱ sá'a Juan ini̱ yu̱cha Jordán. ");
INSERT INTO migNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te ni̱ nana‑ni‑ya̱ iní nducha‑ún. Te ni̱ jini̱‑ya̱ já ní nuña andɨ́vɨ́. Te Espíritu ni̱ jungava sɨkɨ̱‑yá nátu̱'un paloma. ");
INSERT INTO migNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Te ichi ándɨ́vɨ́ ní kenda ɨɨn tu̱'un ni̱ ka'a̱n: Máá‑ró kúu Se̱'e‑ri̱, te kúndá'ú ini̱‑ri̱ róó. Te kúsɨɨ̱ iní‑ri̱ jíín‑ró. Achí. ");
INSERT INTO migNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yúan‑na te máá Espíritu, ni̱ chundá'á‑ni‑ya̱ kuá'a̱n‑ya̱ ondé ñu'un té'é. ");
INSERT INTO migNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Te ni̱ kanchaa̱‑ya̱ núu̱ ñú'un té'é yúan uu̱ xiko kɨvɨ̱, te vásá ní jito nchaa̱ tá'an Satanás jíín‑yá. Te ni̱ kandee‑ya̱ jíín kɨ́tɨ xáa̱n. Te máni ndajá'a̱ ándɨ́vɨ́ ní ka̱jatíñu nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yúan‑na te onde̱ ni̱ kɨ̱vɨ Juan veka̱a, te ni̱ jaa̱ Jesús ndañúu̱ Galilea, jáni‑ya̱ tú'un va̱'a Dios. ");
INSERT INTO migNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Te ni̱ kachi̱‑ya̱: A ni̱ ji̱nu kɨvɨ̱, te a yani koo ñuu̱ nuu̱ tá'ú Dios tiñu. Nakani ini̱ jíná'an‑ró, te kandíja‑ró tú'un va̱'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Te ni̱ ja̱'a‑ya̱ xíin mar Galilea kua'a̱n‑ya̱. Te ni̱ jini̱‑ya̱ núu̱ Simón jíín ñaní‑de Andrés, káskuíta ka'nu‑de ñunu‑dé ini̱ mar, chi cha̱a kátɨɨn ti̱yáká kákuu‑de. ");
INSERT INTO migNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Te ni̱ ka'a̱n Jesús jíín‑de: Kundiki̱n ruu̱ kikoyo‑ró, te ná násá'a‑ri̱ róó cha̱a tɨɨn ña̱yɨvɨ. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yúan‑na te ni̱ ka̱xndóo‑ni‑de ñunu‑dé. Te ni̱ kandiki̱n‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Te ni̱ jika‑ya̱ ɨ́ɨn tí'lí‑ga̱. Te ni̱ jini̱‑ya̱ núu̱ Jacobo jíín ñaní‑de Juan. Se̱'e Zebedeo kákuu cha̱a‑ún. Suni ká'i̱in cha̱a‑ún ini̱ barco, kánaku'ni̱‑de ñunu‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Te ni̱ kana‑ni‑ya̱ xiní‑dé. Te ni̱ ka̱skéndo̱o‑de táa̱‑de Zebedeo ini̱ barco‑ún jíín mozo‑de, te kua̱ngoyo‑de yata̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Te ni̱ kɨ̱vɨ koyo‑de ini̱ ñuu̱ Capernaum. Te ta̱ká kɨvɨ̱ ndéta̱tú ni̱ kɨ̱vɨ‑ni Jesús ini̱ ve̱'e sinagoga, te ni̱ stá'a̱n‑ya̱ tú'un. ");
INSERT INTO migNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Te ni̱ ka̱naa ini‑i kájini so̱'o‑i tu̱'un stá'a̱n‑ya̱, chi ni̱ stá'a̱n‑ya̱ nátu̱'un cha̱a ndíso tíñu, nasu̱ nátu̱'un cha̱a káchaa tutu̱. ");
INSERT INTO migNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Te ini̱ ve̱'e sinagoga‑ún kándee ɨɨn cha̱a tá'a̱n tachi̱ kíni. Te cha̱a‑ún, ni̱ kana kó'ó‑de: ");
INSERT INTO migNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Na̱ún kuní‑ní jíín‑ná jíná'an‑ná, Jesús ñuu̱ Nazaret. Va̱i‑ní xnáa‑ní náá náún. A jiní‑ná na̱ níí kúu, cha̱a íó ndoo nuu̱ Dios, áchí. ");
INSERT INTO migNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Te Jesús, ni̱ ka'a̱n xaa̱n‑yá jíín: Kasu̱ yu'u‑ro, te kenda‑ró‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Te máá tachí kíni‑ún, xaa̱n ní ja'ni yí'í cháa‑ún. Te ni̱ kana jíkó'ó. Te ni̱ kenda kua'a̱n ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Te ndivii‑í ni̱ ka̱naa iní‑i kánde̱'é‑i. Te kánda̱tu̱'ún máá‑i: Na̱ún kúu ya̱'á. Tu̱'un jáá kúu náún, chi̱ tá'ú ní'in‑de tiñu nuu̱ tachí kíni, te kájandatu̱ nuu̱‑dé, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Te ni̱ jicha̱ nu̱u‑ni tu̱'un‑ya̱ kuá'a̱n nɨ́ɨ́ táká ndañúu̱ ja̱ ní jíkó ndúu̱ yuñúu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Te ni̱ ka̱ndenda‑ni‑ya̱ iní ve̱'e sinagoga. Te ni̱ cha̱koyo‑ya̱ jíín Jacobo jíín Juan onde̱ ve'e Simón jíín Andrés. ");
INSERT INTO migNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Te náchi̱só Simón, kátúu‑ñá yí'i ki̱ji‑ña. Te ni̱ kaka'a̱n‑ni‑de jíín‑yá ndasa kuu máá‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yúan‑na te ni̱ jaa̱‑ya̱. Te ni̱ tɨɨn‑ya̱ ndá'a‑ñá. Te ni̱ ndukani‑ya̱‑ñá. Te ni̱ kee‑ni ki̱ji‑ún‑ña. Te ni̱ jatíñu‑ña núu̱‑yá jíná'an‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Te nuu̱ ní ini, ni̱ ke̱e ndika̱ndii, te ni̱ cha̱koyo cha̱a kándi̱so ña̱yɨvɨ káku'u̱, jíín ñáyɨvɨ tá'a̱n tachi̱ kíni. ");
INSERT INTO migNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Te ta̱ká ña̱yɨvɨ ñúu̱‑ún, ni̱ ka̱kutútú‑i yuxé'é yúan. ");
INSERT INTO migNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Te ni̱ nasáva̱'a‑ya̱ kuá'a̱ ñáyɨvɨ káku'u̱ tɨnɨ̱ nuu̱ kué'e̱. Te ni̱ kiñi'in‑ya̱ kuá'a̱ tachí kíni kája'a̱n. Te tú ní já'a‑ya̱ tú'un ka'a̱n tachi̱ kíni‑ún, chi̱ a kájini̱‑ún‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Te ña'a̱n xaa̱n ní nduko̱o‑ya̱, onde̱ ná íñaa‑gá. Te ni̱ kenda‑ya̱ te kua'a̱n‑ya̱ ɨ́ɨn lugar ñu'un té'é. Te yúan ni̱ jika̱n ta'u̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Te Simón jíín cháa káxiu̱kú jíín‑de, ni̱ kandiki̱n‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Te ni̱ ka̱nani'i̱n‑dé‑ya̱. Te káka'a̱n‑de jíín‑yá: Ta̱ká ña̱yɨvɨ, kánandúkú‑i níí, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Te ni̱ kachi̱‑ya̱ jíín‑de: Ná kí'o̱n sáva‑ga̱ ñuu̱ káxiu̱kú yáni, náva̱'a kani‑ri̱ tu̱'un yúan, chi ja̱ yúán ní chaa̱‑ri̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Te kua'a̱n‑ya̱. Te ni̱ jani‑ya̱ tú'un ini̱ ta̱ká ve'e sinagoga nɨ́ɨ́ ndáñúu̱ Galilea. Te ni̱ kiñi'in‑ya̱ tachí kíni kája'a̱n. ");
INSERT INTO migNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Te ɨɨn cha̱a té'yu̱ ndɨ̱'yi, ni̱ chaa̱‑de nuu̱‑yá. Te ni̱ jukuiñi̱ jítɨ́‑de nuu̱‑yá, ká'a̱n nda̱'ú‑de jíín‑yá: Nú kuní‑ní, te kuu nasándoo‑ní náá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Te Jesús, ni̱ kundá'ú ini̱‑ya̱‑dé. Te ni̱ skáa̱‑ya̱ ndá'a‑yá. Te ni̱ ké'é‑yá‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kuní‑ri̱. Ná ndúndoo‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Te máá súan‑ni ni̱ ka'a̱n‑ya̱, te ndɨ̱'yi té'yu̱ cha̱a‑ún, kua'a̱n‑ni. Te ni̱ ndundoo‑ni‑de. ");
INSERT INTO migNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yúan‑na te ni̱ ka'a̱n xaa̱n‑yá jíín‑de. Te tájí‑ni‑ya̱‑dé ki'i̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Te ká'a̱n‑ya̱ jíín‑de: Koto‑ró, ma̱ ká'a̱n kutɨ‑ro jíín ní ɨɨn‑i, chi̱ kuá'án, te stá'a̱n‑ro̱ máá‑ró núu̱ sutú. Te kundá'á‑ró ndátíñu stá'a̱n‑ro̱ núu̱‑dé, náva̱'a kuni̱‑de ja̱ ní ndundoo‑ró, nátu̱'un ni̱ tá'ú Moisés tiñu sáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ko máá‑de, ni̱ kenda‑de kua'a̱n‑de. Te ni̱ kejá'á‑de ni̱ jacha̱ xaa̱n‑dé tu̱'un. Te ni̱ kachi̱‑de ná ni̱ ta'a̱n‑de. Te tuká‑ni ní kúu kɨ̱vɨ ndiji̱n Jesús onde̱ ini̱ ñuu̱, ko ni̱ kanchaa̱ sɨ́ɨn‑ya̱ ɨ́ɨn lugar ñu'un té'é. Te yúan ni̱ kikoyo ña̱yɨvɨ táká lado nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Te ni̱ kuu yaku̱ kɨvɨ̱. Te ni̱ kɨ̱vɨ tuku‑ya̱ ñúu̱ Capernaum. Te ni̱ kenda tu̱'un ja̱ vé'e kánchaa̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Te ni̱ ka̱kutútú kuá'a̱ xáa̱n ñáyɨvɨ núu̱‑yá. Te tuká ní kánda kutɨ yúxé'é kuíñi‑i. Te ni̱ jani‑ya̱ tú'un nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yúan‑na te ni̱ chaa̱ yaku̱ cha̱a nuu̱‑yá jíín ɨ́ɨn cha̱a ni̱ kuyúnú, ja̱ kúu̱n tá'a̱n‑de kándi̱so‑de cha̱a‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Te ja̱ kuá'a̱ ñáyɨvɨ‑ún, te tú ní kúu kɨ̱vɨ‑de nuu̱‑yá jíín cháa‑ún. Te ni̱ ka̱juña‑de xini̱ vé'e nuu̱ kándee‑ya̱‑ún. Te nuu̱ ní kakaa̱n‑de yau̱‑ún, ni̱ ka̱skúun‑de ji̱to yuu núu̱ kátúu cháa ni̱ kuyúnú‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Te ni̱ jini̱ Jesús ja̱ kákandíja máá‑de. Te ni̱ ka'a̱n‑ya̱ jíín cháa ni̱ kuyúnú‑ún: Hijo, a íó tu̱ká'nu ini̱ nuu̱ táká kua̱chi‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Te yúan káxiu̱kú yakú cha̱a káchaa tutu̱. Te yu̱án, ni̱ ka̱jani ini̱: ");
INSERT INTO migNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Naja̱ ká'a̱n cha̱a yá'a súan. Núsáá te tu̱'un ndɨva̱'a ká'a̱n‑de. Ndéja̱ kúu sá'a tu̱ká'nu ini̱ nuu̱ kuáchi, chi̱ ɨɨn‑ni máá Dios, áchí. ");
INSERT INTO migNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Te ni̱ juku̱'un‑ni ini̱ Jesús ja̱ súan kájani ini̱. Te ni̱ ka'a̱n‑ya̱ jíín: Naja̱ kájani ini̱‑ro̱ súan. ");
INSERT INTO migNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Te ja̱ úu̱ tu̱'un yá'a, ndéja̱ yíí‑ga̱ káa. Á ka'a̱n‑ri̱ jíín cháa ni̱ kuyúnú yá'a: A íó tu̱ká'nu ini̱ nuu̱ táká kua̱chi‑ró; xí ká'a̱n‑ri̱ jíín‑de: Nduko̱o, te naki'in‑ró jíto yuu‑ro, te ki'i̱n‑ro̱ jíín, achi̱‑ri̱ náún. ");
INSERT INTO migNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ko náva̱'a ná kuní‑ro̱ já máá Sé'e cha̱a, ndíso‑ya̱ tíñu ini̱ ñu̱yɨ́vɨ yá'a ja̱ sá'a‑ya̱ túká'nu ini̱ nuu̱ kuáchi, te ná ká'a̱n‑ri̱ ɨnga̱ tu̱'un jíín cháa ni̱ kuyúnú yá'a núsáá: ");
INSERT INTO migNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Jíín‑ró ká'a̱n‑ri̱: Nduko̱o, te naki'in‑ró jíto yuu‑ro, te no'o̱n‑ro̱ vé'e‑ró, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Te máá cháa‑ún, ni̱ nduko̱o‑ni‑de. Te ni̱ naki'in‑de ji̱to yuu‑dé. Te ni̱ ndenda‑de kua'a̱n‑de nuu̱ ñáyɨvɨ kuá'a̱‑ún. Te ndivii‑í, ni̱ ka̱kee nuu̱‑í kánde̱'é‑i. Te ni̱ ka̱nakana jaa‑i Dios: Na̱ tú kájini̱ kutɨ‑yo súan nátu̱'un ya̱'á, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Te ni̱ kenda tuku Jesús kua'a̱n‑ya̱ ondé yu'u mar. Te ta̱ká ña̱yɨvɨ, ni̱ ja̱koyo‑i nuu̱‑yá. Te ni̱ stá'a̱n‑ya̱ tú'un nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Te ni̱ ja̱'a‑ya̱ kuá'a̱n‑ya̱. Te ni̱ jini̱‑ya̱ núu̱ Leví, se̱'e Alfeo, kánchaa̱‑de nuu̱ kútútú xú'ún ñúu̱. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kundiki̱n‑ro̱ rúu̱, áchí‑ya̱. Te ni̱ ndukuiñi̱‑de. Te ni̱ ndiki̱n‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Te Jesús, ni̱ yee‑yá staa̱ iní ve̱'e‑de. Te suni kua'a̱ cháa xíní jíín cháa ká'i̱o kua̱chi, káyee‑dé staa̱ jíín Jesús jíín cháa káskuá'a jíín‑yá, chi̱ íó kua'a̱‑dé kándiki̱n‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Te cha̱a káchaa tutu̱, jíín cháa fariseo, kánde̱'é‑de ja̱ yée‑yá staa̱ jíín cháa xíní jíín cháa ká'i̱o kua̱chi. Te ni̱ kaka'a̱n‑de jíín cháa káskuá'a jíín‑yá: Naja̱ yée‑yá jí'i‑ya̱ jíín cháa xíní jíín cháa ká'i̱o kua̱chi, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yúan‑na te ni̱ jini so̱'o Jesús. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Cha̱a ká'i̱o ndáján, tú kánandɨ'ɨ‑de cha̱a táná, chi cha̱a káku'u̱ kúu ja̱ kájinu ñú'ún. Na̱ tú va̱i‑ri̱ kana‑ri̱ xini̱ cháa ndaa̱, chi cha̱a ká'i̱o kua̱chi kána‑ri̱ xini̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Te cha̱a káskuá'a jíín Juan, jíín já káskuá'a jíín cháa fariseo, ká'i̱o ndicha̱ ini̱‑de. Te ni̱ cha̱koyo cha̱a‑ún. Te ni̱ kaka'a̱n‑de jíín‑yá: Cha̱a káskuá'a jíín Juan jíín já káskuá'a jíín cháa fariseo, naja̱ ká'i̱o ndicha̱ ini̱‑de, te cha̱a káskuá'a jíín‑ní, tú ká'i̱o ndicha̱ ini̱‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Á kuu kondicha̱ ini̱ ña̱yɨvɨ ká'i̱in viko tánda'a, te nú kánchaa̱ yii jíín‑i. Chi̱ nú nini kánchaa̱ yii jíín‑i, ma̱ kúu kondicha̱ ini̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ko chaa̱ ɨɨn kɨvɨ̱ já yíi‑ún, kuxio‑de nuu̱‑í. Te kɨvɨ̱‑ún, kuu kondicha̱ ini̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tú ni ɨɨn nachu'un sa'ma jáá núu̱ sú'nu̱ tu̱'ú. Chi̱ nú súan, te suni máá já ní nuku̱'un jáá‑ún ka'ncha̱‑ga̱ ja̱ tu̱'ú‑ún, te ja̱ te̱'ndé‑ún ví'í‑gá te'nde̱. ");
INSERT INTO migNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Te tú ni ɨɨn chu'un vino jáá iní ñii tú'ú. Chi̱ nú súan, te máá vino jáá‑ún ndátá ñíi‑ún, te katɨ vino‑ún, te ñii‑ún naa‑ní. Ko ñii jáá jíín vino jáá, kúu ja̱ kúu ku'un, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Te ɨɨn kɨvɨ̱ ndéta̱tú ni̱ ja̱'a Jesús kua'a̱n‑ya̱ ɨ́ɨn nuu̱ káa trigo. Te cha̱a káskuá'a jíín‑yá, kájika‑de kua'a̱n‑de. Te kákachi‑de yoko. ");
INSERT INTO migNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yúan‑na te cha̱a fariseo, ni̱ kaka'a̱n‑de jíín‑yá: Na̱ún kúu jia̱n. Naja̱ kásá'a‑de súan kɨvɨ̱ ndéta̱tú, chi̱ tú íó ley. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Te máá‑yá, ni̱ ka'a̱n‑yá jíín‑de: Á tú ní káka'u kutɨ‑ro tutú na̱ún ní sá'a David, kɨvɨ̱ ní kii tu̱ndó'o nuu̱‑dé. Te ni̱ ji'i̱‑de so̱ko, onde̱ jíín cháa ni̱ kaxiu̱kú jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Te ni̱ kɨ̱vɨ‑de ini̱ ve̱'e Dios. Te Abiatar ni̱ kuu máá sutú ñá'nu‑ga̱. Te ni̱ yee‑dé sta̱tilá ii̱ káxiu̱kú ndijín, ja̱ tú íó ley kee ní ɨɨn cha̱a, chi̱ máni sutu̱ káyee núú. Te suni ni̱ ja̱'a‑de nuu̱ cháa káxiu̱kú jíín‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Te suni ni̱ ka'a̱n‑ya̱ jíín‑de: Kɨvɨ̱ ndéta̱tú ni̱ jungo̱o ja̱ sɨkɨ́ cháa; nasu̱ cháa ja̱ sɨkɨ́ kɨvɨ́ ndéta̱tú. ");
INSERT INTO migNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Núsáá te máá Sé'e cha̱a, suni Jito'o̱ kɨvɨ̱ ndéta̱tú kúu‑ya̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Te ɨnga̱ jínu ni̱ ndɨ̱vɨ Jesús ini̱ ve̱'e sinagoga. Te yúan ni̱ i̱o ɨɨn cha̱a ni̱ ichi̱ káján ɨ́ɨn nda'a‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Te kánde̱'é‑de nú nasáva̱'a‑ya̱‑dé kɨvɨ̱ ndéta̱tú, náva̱'a kaka̱n‑de kua̱chi sɨkɨ̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín cháa kátí'íchi nda'a‑ún: Ichi má'ñú yá'a jukuiñi̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Te ni̱ ka'a̱n‑ya̱ jíín‑de jíná'an‑de: Ndé ley íó sɨkɨ̱ kɨvɨ́ ndéta̱tú. Á sá'a va̱'a‑yó, xí sá'a ñáá‑yo̱. Á nama‑yó ɨ́ɨn cha̱a a yani kuu̱, xí ká'ni‑yo ɨ́ɨn ndɨ̱yi, áchí‑ya̱. Te máá‑de, tú ní káka'a̱n kutɨ‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Te ndé'é‑yá nuu̱‑dé ja̱ ká'i̱in‑de xiin‑yá. Te ni̱ kiti̱ ini̱‑ya̱. Te ni̱ kukuí'a̱ ini̱‑ya̱ já ndáva iní añú‑de jíná'an‑de. Te ni̱ ka'a̱n‑ya̱ jíín cháa‑ún: Skáa̱ nda'a‑ro, áchí‑ya̱. Te ni̱ skáa̱‑de nda'a‑dé. Te nda'a‑dé‑ún, ni̱ nduva̱'a ii̱‑ní. ");
INSERT INTO migNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yúan‑na te ni̱ kenda koyo cha̱a fariseo. Te ni̱ kanda̱tu̱'ún‑ni‑de jíín cháa herodiano sɨkɨ̱‑yá, ndasa ka'ni‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Te Jesús, ni̱ kusɨ́ɨn‑ni‑ya̱ kuá'a̱n‑ya̱ ondé yu'u mar jíín cháa káskuá'a jíín‑yá. Te ña̱yɨvɨ kuá'a̱ xáa̱n ndáñúu̱ Galilea jíín ndáñúu̱ Judea, ni̱ kandiki̱n‑i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Te suni onde̱ ñuu̱ Jerusalén jíín Idumea, jíín ɨngá lado yu̱cha Jordán, jíín ndáñúu̱ Tiro jíín Sidón. Kua'a̱ xáa̱n ñáyɨvɨ, ni̱ ka̱jini tu̱'un‑i ná ñá'nu tiñu ni̱ sá'a‑ya̱. Te ni̱ cha̱koyo‑i nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a jíín‑yá ja̱ ná kótu̱'a ɨɨn barco lúlí kɨ́vɨ‑ya̱, náva̱'a tú kaxi̱n‑i‑ya̱. Chi̱ kua'a̱ xáa̱n ñáyɨvɨ‑ún íó. ");
INSERT INTO migNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Chi ni̱ nasáva̱'a‑ya̱ ñáyɨvɨ kuá'a̱. Te ta̱ká ña̱yɨvɨ káku'u̱ kue'e̱, ni̱ ka̱kandita‑i nuu̱‑yá, ja̱ ké'é‑i‑ya̱ kákuni̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Te tachi̱ kíni nú ni̱ kajini̱ nuu̱‑yá, te kájukuiñi̱ jítɨ́ núu̱‑yá. Te kákana kó'ó: Máá‑ní kúu Se̱'e Dios, áchí jíná'an. ");
INSERT INTO migNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ko máá‑yá, ni̱ ka'a̱n xaa̱n‑yá jíín já ná tú stá'a̱n ndiji̱n‑ún‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Te ni̱ kaa‑ya̱ kuá'a̱n‑ya̱ ondé yuku. Te ni̱ kana‑ya̱ xiní ndé cha̱a játa'a̱n ini̱ máá‑yá. Te ni̱ ja̱koyo‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Te ni̱ jani‑ya̱ uxí uu̱ tá'a̱n cha̱a, kuiñi‑de jíín‑yá. Te tájí‑yá‑de ki̱ngoyo‑de kani‑de tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Te kundiso‑de tiñu ja̱ násáva̱'a‑de ña̱yɨvɨ kú'u̱. Te kiñi'in‑de tachi̱ kíni ki̱ngoyo. ");
INSERT INTO migNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Te Simón, ni̱ naskúnání‑yá‑de Pedro. ");
INSERT INTO migNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Te Jacobo, se̱'e Zebedeo, jíín Juan ñani̱ Jacobo, ni̱ naskúnání‑yá ndendúú‑de Boanerges, ja̱ kuní ka'a̱n: Cha̱a nátu̱'un taja. ");
INSERT INTO migNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Te sava‑ga̱‑de nání‑de Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo se̱'e Alfeo, Tadeo, Simón ñuu̱ Caná, ");
INSERT INTO migNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","onde̱ jíín Judas Iscariote, ja̱ ní nastúu‑de‑ya̱. Yúan‑na te ni̱ kɨ̱vɨ koyo‑de ɨɨn ve'e jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Te ni̱ ndutútú tuku kua'a̱ ñáyɨvɨ. Te ni tuká ní kúu kee‑yá staa̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Te ni̱ ka̱jini tu̱'un tá'an‑ya̱. Te ni̱ ka̱kenda‑de va̱i‑de ja̱ tɨ́ɨn‑de‑ya̱. Chi ni̱ kaka'a̱n‑de: Káku'u̱‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Te ja̱ káchaa tutu̱, ni̱ kikoyo onde̱ ñuu̱ Jerusalén, ni̱ kaka'a̱n: Yí'i‑de Beelzebú. Te jíín tachí kíni ñá'nu kíñi'in‑de tachi̱ kíni kája'a̱n, áchí. ");
INSERT INTO migNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Te ni̱ kana‑ya̱ xiní jíná'an. Te ni̱ ka'a̱n‑ya̱ tú'un yátá jíín: Ndasa kuu kiñi'in Satanás‑ún Satanás kí'i̱n, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Te nú ɨɨn ñuu̱ sásɨ́ɨn máá te kánakua̱tá'an máá, te ñuu̱ yúan ma̱ kúni̱'in. ");
INSERT INTO migNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te nú ɨɨn ve'e sásɨ́ɨn máá te kánakua̱tá'an máá, te ve'e yúan ma̱ kúni̱'in. ");
INSERT INTO migNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Te nú Satanás kánakua̱tá'an máá te sásɨ́ɨn máá, ma̱ kúni̱'in, chi̱ sasua naa, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tú ni ɨɨn cha̱a kuu kɨ̱vɨ‑de ini̱ ve̱'e cha̱a kándáján te sákuí'ná‑de ndatíñu, te nú tú xna'a̱n‑ga̱ ku'ni̱‑de cha̱a ndáján‑ún. Yúan‑na te kuu sákuí'ná‑de ndatíñu cha̱a‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró já kóo tu̱ká'nu ini̱ nuu̱ táká kua̱chi kásá'a cha̱a, te suni nuu̱ tú'un ndɨva̱'a nú na̱ni ka'a̱n‑de jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ko nú ɨɨn cha̱a ká'a̱n‑de tu̱'un ndɨva̱'a sɨkɨ̱ Espíritu Santo, ma̱ kóo kutɨ túká'nu ini̱‑ya̱ núu̱‑dé, chi̱ sua kundiso‑de kua̱chi nɨ́ɨ́ káni, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Chi ni̱ kaka'a̱n‑de: Tá'a̱n‑de tachi̱ kíni, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Te ni̱ chaa̱ náa̱‑ya̱ jíín ñaní‑ya̱, te ká'i̱in‑ña yatá ké'e. Te ni̱ ka̱tájí‑ña tú'un kua'a̱n kákana‑ña xiní‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Te ña̱yɨvɨ kuá'a̱ káxiu̱kú nɨ́ɨ́ núu̱‑yá‑ún, ni̱ kaka'a̱n‑i jíín‑yá: Kuánde̱'é‑ní, chi ni̱ chaa̱ náa̱‑ní jíín ñaní‑ní ká'i̱in‑ña yatá ké'e kánandúkú‑ña níí, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Te máá‑yá, ni̱ ka'a̱n‑ya̱: Ndéja̱ kúu náa̱‑ri̱ te ndéja̱ kákuu ñani̱‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Te ndé'é‑yá nuu̱ ñáyɨvɨ káxiu̱kú nɨ́ɨ́ núu̱‑yá‑ún, te ni̱ ka'a̱n‑ya̱ jíín‑i: Kuni so̱'o‑ró, chi ya̱'á kúu náa̱‑ri̱ jíín ñaní‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chi ña̱yɨvɨ skíkuu tiñu kuní Dios, jia̱n kúu ñani̱‑ri̱, kúu kua̱'a‑ri̱, kúu náa̱‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Te yu'u mar ni̱ kejá'á tuku‑ya̱ ní stá'a̱n‑ya̱ tú'un. Te ni̱ ka̱ndutútú kuá'a̱ xáa̱n ñáyɨvɨ núu̱‑yá. Te ja̱ yúán ní kɨ̱vɨ‑ya̱ ní jungo̱o‑ya̱ iní ɨɨn barco nuu̱ mar. Te ta̱ká ña̱yɨvɨ‑ún, ni̱ ka̱kendo̱o‑i káxiu̱kú‑i nuu̱ ñú'un. ");
INSERT INTO migNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Te ni̱ stá'a̱n‑ya̱ kuá'a̱ tú'un yátá núu̱‑í. Te ni̱ ka'a̱n‑ya̱ jíín‑i: ");
INSERT INTO migNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Kuni so̱'o te kuni̱‑ro̱: Ɨɨn cha̱a sáka trigo, ni̱ kenda‑de sáka‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Te ni̱ kuu ja̱ ní kenda‑de sáka‑dé, te ɨɨn nuni̱‑ún, ni̱ jungava yu'íchi. Te ni̱ chaa̱ tɨsaa̱. Te ni̱ ka̱kókó‑tɨ́. ");
INSERT INTO migNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Te ɨnga̱, ni̱ jungava nuu̱ ñú'un yúu̱, nuu̱ tú íó kua'a̱ ñú'un. Te ni̱ kana yachi̱‑ni, chi̱ tú íó kókon ñu'un. ");
INSERT INTO migNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Te nuu̱ ní kana ndika̱ndii, te ni̱ kasu̱n‑ni. Te ni̱ ichi̱, chi̱ tú yo'o ní íó. ");
INSERT INTO migNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Te ɨnga̱, ni̱ jungava ma̱'ñú ínu. Te ni̱ ja'nu iñu‑ún. Te ni̱ jasu̱ nuu̱. Te tú ní kúun nuni̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Te sava, ni̱ ka̱jungava nuu̱ ñú'un vá'a. Te ni̱ ka̱ja'nu. Te ni̱ nako̱ko. Te ni̱ kuun nuni̱. Ɨɨn ja̱ okó uxi̱, ɨnga̱ ja̱ uní xiko, te ɨnga̱ ja̱ ɨ́ɨn ciento, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín‑de: Cha̱a íó so̱'o kuni ná'ín, te ná kúni so̱'o‑de. ");
INSERT INTO migNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Te nuu̱ ní ndo̱o máá‑na̱‑ya̱, te cha̱a ká'i̱in yani nuu̱‑yá jíín ndɨ́'uxí uu̱ cha̱a káskuá'a jíín‑yá, ni̱ kajika̱ tu̱'ún‑de‑ya̱ sɨkɨ́ tú'un yátá‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Te ni̱ ka'a̱n‑ya̱ jíín‑de: A kuaju̱ku̱'un ini̱‑ro̱ tú'un yísa̱'í yá'a, ndasa koo ñuu̱ nuu̱ tá'ú Dios tiñu. Ko jíín já sɨ́ɨn sɨkɨ̱ ká'i̱in, chi̱ máni jíín tú'un yátá ká'a̱n‑ri̱ ta̱ká tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Náva̱'a va̱sa kánde̱'é, ná ndé'é ko ma̱ chú'un ini̱. Te va̱sa kájini so̱'o, ná kúni so̱'o ko ma̱ júku̱'un ini̱. Náva̱'a ma̱ ná jíó káva ini̱, te koo tu̱ká'nu ini̱ nuu̱ táká kua̱chi, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Tú kájuku̱'un ini̱‑ro̱ tú'un yátá yá'a náún. Ndasa juku̱'un ini̱‑ro̱ sáva‑ga̱ tu̱'un yátá núsáá. ");
INSERT INTO migNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Cha̱a sáka trigo kúu cha̱a sáka tú'un. ");
INSERT INTO migNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Te nuni̱ ní ka̱jungava yu'íchi kákuu cha̱a ni̱ saka̱ tú'un ini̱‑de. Ko nú ni̱ ka̱jini so̱'o‑de, te cháa̱‑ni Satanás te jánchaa̱‑ni tu̱'un ni̱ saka̱ iní añú‑de‑ún kua'a̱n‑ni jíín. ");
INSERT INTO migNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Te nuni̱ ní saka̱ núu̱ ñú'un yúu̱, kákuu cha̱a kájini so̱'o tu̱'un, te kúsɨɨ̱ iní‑de jíín. ");
INSERT INTO migNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ko túu nuu̱ káka yo'o iní‑de. Te yaku̱‑ni kɨvɨ̱ kánda. Te nú ni̱ ndonda tu̱ndó'o sɨkɨ̱‑dé, xí nú ni̱ sándɨva̱'a‑i jíín‑de sɨkɨ̱ tú'un‑ún, te kánayu̱'ú‑ni‑de. ");
INSERT INTO migNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Te nuni̱ ní saka̱ má'ñú íñu kákuu cha̱a kájini so̱'o tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ko kákutéñu‑de jíín ndátíñu‑de. Te kákuni̱‑de kukúká‑de, te káxndá'ú‑de máá‑de jíín. Te kákutóó iní‑de sɨkɨ̱ sáva‑ga̱ ndatíñu. Ndɨ'ɨ ya̱'á sátéñu‑de te jasú nuu̱ tú'un‑ún, te tú kúun nuni̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Te nuni̱ ní saka̱ núu̱ ñú'un vá'a kákuu cha̱a kájini so̱'o tu̱'un. Te kájatá'ú‑de te kája̱'a‑de nuni̱. Ɨɨn‑de oko̱ uxi̱, ɨnga̱‑de uni̱ xiko, te ɨnga̱‑de ɨɨn ciento, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Te suni ni̱ ka'a̱n‑ya̱ jíín‑de: Á júkuiñi̱ yitɨ já kúndii̱ sa̱'í chi̱i nu̱ndóó, xí chíi ji̱to. Á tú kundii̱ nuu̱ candelero. ");
INSERT INTO migNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chi̱ tú íó ni ɨɨn tiñu yísa̱'í sáni, chi ta̱ká‑ni stá'a̱n ndiji̱n‑ya̱. Ni tú íó ni ɨɨn tu̱'un yísa̱'í sáni, chi ta̱ká‑ni va̱i ndiji̱n sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Cha̱a íó so̱'o kuni ná'ín, te ná kúni so̱'o‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Te suni ni̱ ka'a̱n‑ya̱ jíín‑de: Ná kúni so̱'o va̱'a‑ró. Chi̱ jíín kú'a ja̱ káchikua̱'á‑ro̱, suni naku̱kua̱'á‑ro̱. Te ndaa‑ga̱ sɨkɨ̱ máá‑ró já kájini so̱'o‑ró. ");
INSERT INTO migNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Chi cha̱a ja̱ á ñáva̱'a, te kii‑ga̱ nuu̱‑dé. Te cha̱a ja̱ ná tú ñáva̱'a, va̱sa ja̱ á ñáva̱'a‑de‑ún te kuxio ki'i̱n, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Te ni̱ ka'a̱n‑ga̱‑ya̱: Ñuu̱ nuu̱ tá'ú Dios tiñu kúu nátu̱'un ɨɨn cha̱a ni̱ chi'i‑de tata̱ nuu̱ ñú'un. ");
INSERT INTO migNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Te kixí‑de ñúú te ndúko̱o‑de ndúú. Te tata̱‑ún a kána te já'nu. Te máá‑de, tú jiní‑de ndasa sá'a. ");
INSERT INTO migNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Chi̱ máá ñú'un kúu ja̱ já'a nuni̱. Xna'a̱n‑ga̱ vi̱u, te vásá kána yoko. Yúan‑na te nuni̱ ndóo chíi yoko‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te nú ni̱ kuaan nuní‑ún, te skɨ́vɨ‑ni‑de jóso̱, chi̱ a ni̱ jaa̱ kɨvɨ̱ tá'nu̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Te ni̱ ka'a̱n‑ya̱: Na̱ jíín ká'a̱n‑yo̱ já ndása kuní koo ñuu̱ nuu̱ tá'ú Dios tiñu. Xí na̱ tu̱'un yátá skétá'an‑yó jíín. ");
INSERT INTO migNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kúu nátu̱'un ndɨkɨn yuá mostaza ja̱ nú ni̱ jicha̱ nuu̱ ñú'un, te yu̱án kúu ɨɨn tata̱ lúlí‑ga̱ vásá táká tata̱ íó nuu̱ ñú'un‑ún yá'a. ");
INSERT INTO migNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ko nú a ni̱ jicha̱. Te kana, te já'nu xaa̱n‑gá vásá táká‑ga̱ yua̱. Te kúná'nu nda'a. Te tɨsaa̱ íó andɨ́vɨ́ va̱tu‑ni sá'a‑tɨ́ taká‑tɨ̱ chíi katɨ‑ún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Te kua'a̱ tú'un yátá súan ni̱ ka'a̱n‑ya̱ jíín ñáyɨvɨ, ndasa ni̱ ka̱kanda máá‑i kuni so̱'o‑i. ");
INSERT INTO migNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Te nú tú tu̱'un yátá te tú ká'a̱n‑ya̱ jíín‑i. Chi̱ máni máá‑ni nuu̱ cháa káskuá'a jíín‑yá ni̱ kachi̱ ka̱jí‑yá ta̱ká tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Te ni̱ ini kɨvɨ̱‑ún. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ná kíja̱'a‑yó íchi lado‑ún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Te ni̱ ka̱xndóo‑de ña̱yɨvɨ kuá'a̱‑ún. Te súan‑ni ni̱ ka̱jaka‑de‑ya̱ iní ɨɨn barco. Te suni kua'a̱n yaku̱‑ga̱ barco lúlí jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Te ni̱ ndonda ɨɨn tachi̱ xáa̱n. Te suni ni̱ ndonda su'ma̱ mar, ni̱ kɨ̱vɨ ini̱ barco‑ún. Te barco‑ún kuní chítú ndúcha iní núú. ");
INSERT INTO migNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Te máá‑yá, kándee‑ya̱ ondé yata̱ barco‑ún, kixí‑ya̱ sɨkɨ́ ɨ́ɨn sa'ma yí'i xini̱. Te ni̱ ka̱xndúko̱o‑de‑ya̱. Te káka'a̱n‑de jíín‑yá: Maestro, á tú nákani ini̱‑ní ja̱ náa‑yo, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Te ni̱ nduko̱o‑ya̱. Te ni̱ ka'a̱n xaa̱n‑yá nuu̱ tachí‑ún. Te ni̱ ka'a̱n‑ya̱ jíín mar‑ún: Ná'ín‑ni koo‑ró, jukuiñi̱, áchí‑ya̱. Te ni̱ jukuiñi̱ tachi̱‑ún, te ná'ín yúú íi̱‑ní ni̱ kuu. ");
INSERT INTO migNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Naja̱ káyu̱'ú‑ro̱. Naja̱ tú kákandíja‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Te ni̱ kayu̱'ú xaa̱n‑dé. Te ni̱ kaka'a̱n‑de: Ndé cha̱a kúu cha̱a yá'a núsáá, ja̱ ondé tachi̱ jíín mar kájandatu̱ nuu̱‑dé, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Te ni̱ ja̱koyo‑ya̱ ɨngá lado mar ndañúu̱ Gadara. ");
INSERT INTO migNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Te ni̱ kenda‑ya̱ iní barco‑ún. Te onde̱ ve'e añú ni̱ kenda ɨɨn cha̱a tá'a̱n tachi̱ kíni, te ni̱ ketá'an‑ni‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Te ncháá‑de ma̱'ñú vé'e añú. Te tú ni ɨɨn kúndéé kú'ni̱‑de jíín cadena. ");
INSERT INTO migNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Chi̱ kua'a̱ xáa̱n jínu ni̱ nu'ni̱‑de jíín manea jíín cadena. Ko cadena‑ún, ndɨ'ɨ‑ni ni̱ ja'nu̱ sava‑de. Te manea‑ún, ndɨ'ɨ‑ni ni̱ kukuáchí ní sá'a‑de. Te tú ni ɨɨn kúndéé jíín‑de ka'nu̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Te ta̱ká kɨvɨ̱ ndúú ñúú‑ni jíka‑de yuku jíín má'ñú vé'e añú. Te kána jíín‑de, te stují‑dé máá‑de jíín yúu̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Te ni̱ jini̱‑de ja̱ á jíká‑ga̱ va̱i Jesús. Te ni̱ chaa‑de corre kua'a̱n‑de nuu̱‑yá. Te ni̱ jukuiñi̱ jítɨ́‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Te ni̱ kana kó'ó‑de: Na̱ún sá'a‑ní jíín‑ná Jesús, Se̱'e Dios, I'a̱ kúñá'nu xaa̱n. Ká'a̱n nda̱'ú‑ná jíín‑ní onde̱ jíín Dios, ma̱ xndó'o‑ní náá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chi ni̱ ka'a̱n‑ya̱: Tachi̱ kíni, kenda ki'i̱n‑ro̱ iní cha̱a yá'a, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Te ni̱ jika̱ tu̱'ún‑yá‑de: Na̱ún nání‑ró. Te máá‑de, ni̱ ka'a̱n‑de: Cha̱a kua'a̱ xáa̱n nání‑ná, chi̱ kua'a̱‑ná íó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Te ni̱ ka'a̱n nda̱'ú‑de jíín‑yá ja̱ má kíñi'in‑ya̱‑dé ñuu̱‑ún ki'i̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Te yani yuku yúan íó ɨɨn tɨku'ni̱ ká'nu kɨnɨ̱ kájitu‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Te tachi̱ kíni‑ún, ni̱ kaka'a̱n nda̱'ú jíín‑yá: Tájí‑ní náá ná kíngoyo‑ná kɨ̱vɨ‑ná ini̱ kɨnɨ̱ yúan, áchí. ");
INSERT INTO migNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Te Jesús, ni̱ ja̱'a‑ya̱ tú'un. Te ni̱ kenda tachi̱ kíni‑ún kája'a̱n. Te ni̱ kɨ̱vɨ koyo ini̱ kɨnɨ̱. Te tɨku'ni̱ kɨnɨ̱‑ún, ni̱ ka̱jungoyo‑tɨ̱ ɨ́ɨn yukáva onde̱ ini̱ mar. Te kɨnɨ̱‑ún íó nátu̱'un uu̱ mil‑tɨ̱. Te nuu̱ mar ni̱ kaji'i̱‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Te cha̱a kándi̱to‑tɨ̱ yúan, ni̱ ka̱jinu‑de. Te ni̱ kaka̱stu̱'ún‑de nuu̱ ñúu̱ jíín núu̱ rancho. Te ni̱ cha̱koyo ña̱yɨvɨ‑ún kánde̱'é‑i na̱ún ní kuu. ");
INSERT INTO migNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Te ni̱ cha̱koyo‑i nuu̱ Jesús. Te ni̱ kajini̱‑i nuu̱ cháa ni̱ ndo'o jíín tachí kíni‑ún. Te kánchaa̱‑de, ñú'un‑de sa'ma, te a ni̱ nduva̱'a xini̱‑dé. Te ni̱ kayu̱'ú‑i. ");
INSERT INTO migNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Te cha̱a ni̱ kajini̱‑ún, ni̱ kaka̱stu̱'ún‑de nuu̱ ñáyɨvɨ vái koyo ndasa ni̱ ta'a̱n cha̱a ni̱ yi̱'i tachi̱ kíni‑ún, te ndasa ni̱ kuu jíín kɨnɨ́‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Te ni̱ ka̱kejá'á‑de ni̱ kaka'a̱n‑de jíín‑yá ja̱ ná kénda‑ya̱ ñúu̱‑de ki'i̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Te ni̱ kɨ̱vɨ‑ya̱ iní barco. Te cha̱a ni̱ ta'a̱n tachi̱ kíni‑ún ká'a̱n nda̱'ú‑de jíín‑yá, ja̱ kúndee‑de jíín‑yá kuní‑de. ");
INSERT INTO migNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ko Jesús, tú ní já'a‑ya̱ tú'un, chi ni̱ ka'a̱n‑ya̱ jíín‑de: Kuáno'on vé'e‑ró núu̱ tá'an‑ró. Te kani‑ró tú'un ná ñá'nu xaa̱n tíñu ni̱ sá'a máá Jíto'o̱‑ro̱ jíín‑ró, te ndasa ni̱ kundá'ú ini̱‑ya̱ róó, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Te ni̱ kee‑de kua'a̱n‑de. Te ni̱ kejá'á‑de ni̱ jacha̱‑de tu̱'un ini̱ ñuu̱ Decápolis ná ñá'nu xaa̱n tíñu ni̱ sá'a Jesús jíín‑de. Te ndivii ñáyɨvɨ yúan, ni̱ ka̱naa iní‑i kájini tu̱'un‑i. ");
INSERT INTO migNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Te ni̱ ja̱'a tuku Jesús kua'a̱n‑ya̱ jíín barco ɨnga̱ lado. Te ni̱ ka̱ndutútú kuá'a̱ xáa̱n ñáyɨvɨ núu̱‑yá. Te máá‑yá, kándii̱‑ya̱ yú'u mar. ");
INSERT INTO migNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Te ni̱ chaa̱ ɨɨn cha̱a nání‑de Jairo kúñá'nu‑de ini̱ ve̱'e sinagoga. Te ni̱ jini̱‑de nuu̱‑yá. Te ni̱ jukuiñi̱ jítɨ́‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Te ni̱ ka'a̱n nda̱'ú téyíí‑de jíín‑yá: Se̱sɨ́'ɨ́‑ná a yani kuu̱‑i. Ki'i̱n‑yo̱ te xndée‑ní nda'a‑ní sɨkɨ̱‑í náva̱'a ná káku‑i, te nachaku̱‑i, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Te ni̱ kee‑ya̱ kuá'a̱n‑ya̱ jíín‑de. Te ni̱ kandiki̱n kua'a̱ ñáyɨvɨ kája'a̱n‑i jíín‑yá. Te ni̱ kajaxi̱n‑i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Te yúan íó ɨɨn ña'an ní kuu uxi̱ uu̱ kuia̱ ndó'o‑ña kué'e̱ játɨ nɨñi̱‑ñá. ");
INSERT INTO migNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Te xaa̱n ní ndo'o‑ña jíín ñáta̱ná. Te ni̱ janu̱‑ña táká ja̱ ñáva̱'a‑ña jíín. Te tú kutɨ ní kúu tana̱, chi̱ sasua ví'í‑gá ni̱ sá'a. ");
INSERT INTO migNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Te ni̱ jini tu̱'un‑ña tú'un Jesús. Te ni̱ jaa̱‑ña íchi yatá‑yá ma̱'ñú ñáyɨvɨ kuá'a̱‑ún. Te ni̱ ké'é‑ña sá'ma‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Chi ni̱ ka'a̱n‑ña: Nú ná ké'é‑rí va̱sté sá'ma‑yá, te ka̱ku‑ri̱. Achí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Te onde̱ nuu̱ kána nɨñi̱‑ñá‑ún, ni̱ ichi̱‑ni. Te ni̱ jini̱‑ña já ondé ini̱ yikɨ kúñu‑ña ní nduva̱'a tu̱ndó'o tá'a̱n‑ña‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Te Jesús, ni̱ jini̱‑ni ini̱ máá‑yá ja̱ ní kenda fuerza‑ya̱ kuá'a̱n. Te ni̱ jíó káva‑ya̱ núu̱ ñáyɨvɨ kuá'a̱. Te ni̱ ka'a̱n‑ya̱: Ndéja̱ ní ké'é sá'ma‑rí, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Te cha̱a káskuá'a jíín‑yá, ni̱ kaka'a̱n‑de: Ndé'é‑ní ja̱ ñáyɨvɨ kuá'a̱ yá'a kájaxi̱n‑i níí, te áchí‑ní: Ndéja̱ ní ké'é rúu̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Te máá‑yá, yá'a yúan ndé'é‑yá náva̱'a kuni̱‑ya̱ ndéja̱ ní sá'a. ");
INSERT INTO migNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yúan‑na te ña'an‑ún, yú'ú‑ña te kɨ́sɨ‑i‑ña, chi̱ a jiní‑ña ndasa ni̱ ta'a̱n‑ña. Te ni̱ chaa̱‑ña. Te ni̱ jukuiñi̱ jítɨ́‑ña núu̱‑yá. Te ni̱ kachi̱ ndaa̱‑ña táká tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Te máá‑yá, ni̱ ka'a̱n‑ya̱ jíín‑ña: Hija, ni̱ kandíja‑ró te yu̱án ní ka̱ku‑ró. Ma̱ yú'ú‑ro̱, chi ni̱ nduva̱'a‑ró túndó'o tá'a̱n‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Te sá súan ká'a̱n‑ya̱, te ni̱ cha̱koyo ña̱yɨvɨ ká'i̱in ve'e cha̱a kúñá'nu ini̱ ve̱'e sinagoga, te ni̱ kaka'a̱n‑i jíín‑de: A ni̱ ji'i̱ se̱sɨ́'ɨ́‑ní. Naja̱ stá'a̱n‑ga̱‑ní Maestro, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Te Jesús, ni̱ jini so̱'o‑ya̱ tú'un yá'a ja̱ súan ni̱ kaka'a̱n‑i jíín cháa kúñá'nu ini̱ ve̱'e sinagoga. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ma̱ yú'ú‑ro̱. Kandíja te ni̱ kuu‑ni, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Te tú ní já'a‑ya̱ tú'un kundiki̱n ni ɨɨn yata̱‑yá, chi̱ máá‑ni Pedro jíín Jacobo jíín ñaní‑de Juan. ");
INSERT INTO migNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Te ni̱ cha̱koyo‑ya̱ vé'e cha̱a kúñá'nu ini̱ ve̱'e sinagoga. Te ni̱ jini̱‑ya̱ já kúvaa̱, kánde'e̱, kákana jíkó'ó xáa̱n kákuu. ");
INSERT INTO migNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Te ni̱ kɨ̱vɨ‑ya̱. Te ni̱ ka'a̱n‑ya̱: Naja̱ kákuvaa̱‑ro̱ kánde'e̱‑ro̱. Te su̱chí sɨ́'ɨ́ yá'a, tú ní jí'i̱‑i, chi̱ kixí‑ni‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Te ni̱ ka̱sákátá ñáyɨvɨ‑ún nuu̱‑yá. Ko máá‑yá, ni̱ kiñi'in ndɨ'ɨ‑ya̱‑í kája'a̱n‑i yata̱ ké'e. Te ni̱ ki'in‑ya̱ máá‑ni táa̱ náa̱ su̱chí sɨ́'ɨ́‑ún, jíín cháa ká'i̱in jíín‑yá, te ni̱ kɨ̱vɨ‑ya̱ núu̱ kátúu súchí sɨ́'ɨ́‑ún kua'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Te ni̱ tɨɨn‑ya̱ ndá'a súchí sɨ́'ɨ́‑ún. Te ni̱ ka'a̱n‑ya̱ jíín‑i: Talita cumi, ja̱ kuní ka'a̱n: Súchi̱, jíín‑ró ká'a̱n‑ri̱, nduko̱o, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Te ni̱ nduko̱o‑ni su̱chí sɨ́'ɨ́‑ún. Te ni̱ jika‑i, chi̱ a íó‑i uxi̱ uu̱ kuia̱. Te ni̱ ka̱naa iní‑de kánde̱'é‑de, te xaa̱n káyu̱'ú‑de. ");
INSERT INTO migNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Te Jesús, ni̱ ka'a̱n xaa̱n‑yá jíín‑de ja̱ tú ni ɨɨn kuni tu̱'un. Te ni̱ ka'a̱n‑ya̱ jíín‑de ja̱ ná kuá'a‑de ja̱ kée‑í. ");
INSERT INTO migNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Te ni̱ kenda‑ya̱ yúan. Te ni̱ najaa̱‑ya̱ ñúu̱‑ya̱. Te cha̱a káskuá'a jíín‑yá, ni̱ kandiki̱n‑de‑ya̱ kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Te máá kɨvɨ́ ndéta̱tú ni̱ stá'a̱n‑ya̱ tú'un ini̱ ve̱'e sinagoga. Te kua'a̱ ñáyɨvɨ, ni̱ ka̱naa iní‑i kájini ná'ín‑i. Te káka'a̱n‑i: Ndé ni̱ ni'i̱n cháa yá'a tu̱'un yá'a. Te na̱ún kuní ka'a̱n tu̱'un ndíchí ní ni'i̱n‑dé‑ún. Te na̱ún sɨkɨ̱ kúu tiñu ñá'nu ja̱ sá'a‑de jíín ndá'a‑dé‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nasu̱ yá'á kúu cha̱a tújí yúnu. Te nasu̱ sé'e María, ñani̱ Jacobo jíín José jíín Judas jíín Simón kúu‑de náún. Á tú ká'i̱in kua̱'a‑de jíín‑yó yá'a, áchí‑i. Te súan ni̱ ka̱kujá'a̱ ini̱‑i jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑i: Cha̱a jáni tu̱'un Dios, máni ñuu̱‑de jíín tá'an‑de jíín iní ve̱'e‑de kúu ja̱ tú káka'a̱n tu̱'un jíñú'ún jíín‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Te tú ní kúu sá'a‑ya̱ ní ɨɨn tiñu ñá'nu yúan. Chi̱ yaku̱‑ni ña̱yɨvɨ káku'u̱ ni̱ nasáva̱'a‑ya̱, já ní xndée‑ya̱ ndá'a‑yá sɨkɨ̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Te náa iní‑ya̱ ndé'é‑yá ja̱ tú kákandíja máá‑i. Te ni̱ jíkó núu‑ya̱ nɨ́ɨ́ ñúu̱ yani. Te ni̱ stá'a̱n‑ya̱ tú'un. ");
INSERT INTO migNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Te ni̱ kana‑ya̱ xiní uxí uu̱ cha̱a káskuá'a jíín‑yá. Te tájí‑yá ndɨ́'úu̱ ndɨ́'úu̱‑de ki̱ngoyo‑de. Te ni̱ ja̱'a‑ya̱ fuerza ini̱‑de ja̱ kúndéé‑de jíín tachí kíni. ");
INSERT INTO migNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Te ni̱ tá'ú‑yá tiñu nuu̱‑dé ja̱ tú kutɨ na̱ún kúndiso‑de kuu‑de ichi. Ni ñunu, ni sta̱tilá, ni xu̱'ún kúnu'ni̱ sánchi̱i‑de. Chi̱ máá vara‑ni kundá'á‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ko kɨ'vɨ‑de ndija̱n. Te tú ku'un‑de uu̱ su'nu̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Te suni ni̱ ka'a̱n‑ya̱ jíín‑de: Na̱ni ve'e kúu nú ni̱ kɨ̱vɨ‑ró, te kendo̱o‑ró iní ve̱'e‑ún onde̱ nú ni̱ kenda‑ró yúan kua'a̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te ta̱ká ñuu̱ tú kájatá'ú róó yúan, ni tú káchu'un ini̱ tu̱'un ká'a̱n‑ro̱, onde̱ nú ni̱ kenda‑ró yúan te skóyo‑ró tɨ́kacha̱ iní ja'a̱‑ro̱, te súan kani ndaa̱‑ro̱ tú'un nuu̱‑í. Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ja̱ vítá‑ga̱ koo kua̱chi sɨkɨ̱ ñúu̱ Sodoma jíín ñúu̱ Gomorra kɨvɨ̱ kíi juicio, vásá sɨkɨ́ ñúu̱‑ún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Te ni̱ kenda koyo‑de. Te ni̱ ka̱jani‑de tu̱'un ja̱ táká ña̱yɨvɨ ná nákani ini̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Te suni kua'a̱ tachí kíni ni̱ ka̱kiñi'in‑de kája'a̱n. Te jíín aceite ni̱ ka̱chi'i‑de ña̱yɨvɨ káku'u̱, te ni̱ ka̱nasáva̱'a‑de‑i. ");
INSERT INTO migNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Te rey Herodes, ni̱ jini tu̱'un‑de tu̱'un Jesús, chi̱ sɨ́'vɨ́‑yá ni̱ jicha̱ nu̱u ndiji̱n kua'a̱n. Te ni̱ ka'a̱n‑de: Ja̱n jaa̱n, Juan ja̱ ní skuánducha‑ún, ni̱ nachaku̱ ma̱'ñú ndɨ́yi. Ja̱ yúán sátiñu tiñu ñá'nu xaa̱n iní núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ko sava‑i ni̱ kaka'a̱n‑i: Elías kúu‑de. Te sava‑ga̱‑i ni̱ kaka'a̱n tuku‑i: Ɨɨn cha̱a jáni tu̱'un Dios kúu‑de, nátu̱'un cha̱a ni̱ ka̱jani tu̱'un‑ya̱ ondé sáá, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Te ni̱ jini tu̱'un Herodes. Te ni̱ ka'a̱n‑de: Yu̱án kúu Juan ja̱ ní janchaa̱‑ri̱ xini̱, te ni̱ nachaku̱ núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Chi̱ suni máá Herodes, a ni̱ tájí‑de cha̱a ni̱ jatɨ̱ɨn Juan. Te ni̱ ju'ni̱‑de cha̱a. Te ni̱ chindee‑de cha̱a veka̱a ja̱ kuáchi Herodías, ñasɨ́'ɨ́ Felipe ñani̱ máá Herodes. Chi ni̱ janchaa̱‑de‑ña kúu tuku‑ña ñásɨ́'ɨ́‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Te Juan, a ni̱ kana jíín‑de nuu̱ Herodes: Tú íó ley kuaka‑ró ñásɨ́'ɨ́ ñani̱‑ro̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ko ña'an, Herodías‑ún, ni̱ jito yu'u‑ñá Juan, chi̱ ka'ni‑ñá‑de kuní‑ña núú. Ko tú ní kúu sá'a‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Chi̱ Herodes, ni̱ yu̱'ú‑de ni̱ jito‑de Juan, chi̱ jiní Herodes ja̱ cháa ndaa̱ cha̱a ndoo kúu Juan. Te ni̱ ndi̱to va̱'a‑de cha̱a. Te jíni ná'ín‑de ja̱ ká'a̱n Juan, te náa iní‑de ndé'é‑de. Te ni̱ i̱o ini̱ ni̱ i̱o añú‑de ni̱ jini ná'ín‑de tu̱'un ká'a̱n Juan. ");
INSERT INTO migNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Te ɨɨn kɨvɨ̱ ní kusɨɨ̱ iní Herodes. Te ni̱ sá'a‑de ɨɨn viko kɨvɨ́ ní kaku‑de. Te ni̱ sá'a‑de ɨɨn ja̱ kúxíni cha̱a kákuñá'nu jíín‑de, jíín cháa kákuu general, jíín cháa kákuñá'nu ñuu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Te ni̱ kɨ̱vɨ se̱sɨ́'ɨ́ máá Herodías jíta já'á‑i. Te Herodes jíín táká cha̱a káyee stáa̱ jíín‑de, ni̱ ka̱kusɨɨ̱ iní‑de ni̱ sá'a‑i. Te rey‑ún, ni̱ ka'a̱n‑de jíín súchí sɨ́'ɨ́‑ún: Kaka̱n na̱ún kuní‑ro̱ núu̱‑rí te ná kuá'a‑ri̱ nuu̱‑ro̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Te ni̱ jatu̱'un téyíí‑de: Ta̱ká na̱ún kuní‑ro̱ kakán‑ro̱ núu̱‑rí te ná kuá'a‑ri̱ nuu̱‑ro̱, va̱sa onde̱ sava ñuu̱ ja̱ tɨ́ɨn‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Te ni̱ kenda‑i kua'a̱n‑i. Te ni̱ ka'a̱n‑i jíín náa̱‑i: Na̱ún kakán‑ná nuu̱‑dé, áchí‑i. Te ni̱ ka'a̱n‑ña jíín‑i: Xini̱ Juan ja̱ skuánducha‑ún kaka̱n‑ro̱, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yúan‑na te máá‑i, ni̱ ndɨ̱vɨ‑ni‑i nuu̱ rey. Te ni̱ jika̱n‑i: Vina nchaa te kuní‑ná kua̱'a‑ní xini̱ Juan ja̱ skuánducha‑ún nuu̱‑ná kundee nuu̱ ɨ́ɨn ko'o̱, áchí‑i jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Te rey‑ún, ni̱ kuxíí xáa̱n iní‑de. Ko sɨkɨ̱ já ní jatu̱'un téyíí‑de, jíín sɨkɨ́ já ní ka̱jini so̱'o cha̱a káyee stáa̱ jíín‑de, te tú ní kuní‑de sásá'án‑de kua̱'a‑de nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Te rey‑ún, ni̱ tájí‑ni‑de ɨɨn soldado ndíto yuxé'é‑ún kua'a̱n kuaki̱'in xini̱ Juan. ");
INSERT INTO migNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Te soldado‑ún, ni̱ ja'a̱n. Te ni̱ janchaa̱ xini̱ Juan ini̱ veka̱a. Te ni̱ chaa̱ jíín xiní‑ún kándee nuu̱ ɨ́ɨn ko'o̱. Te ni̱ ja̱'a nuu̱ súchí sɨ́'ɨ́‑ún. Te su̱chí‑ún, ni̱ ja̱'a‑i nuu̱ náa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Te ni̱ ka̱jini tu̱'un cha̱a káskuá'a jíín Juan. Te ni̱ ja̱koyo‑de, ni̱ ka̱ndañaa‑de yikɨ kúñu‑ún. Te ni̱ ka̱chindee‑de ini̱ ve̱'e añú. ");
INSERT INTO migNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Te cha̱a apóstol, ni̱ ka̱ndutútú‑de nuu̱ Jesús. Te ni̱ ka̱nakani‑de tu̱'un ta̱ká tiñu ni̱ ka̱sá'a‑de, jíín tú'un ni̱ ka̱stá'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Te máá‑yá, ni̱ ka'a̱n‑ya̱ jíín‑de: Ña'a̱n sɨ́ɨn ɨɨn lugar ñu'un té'é, te ndeta̱tú‑ro̱ ɨ́ɨn tí'lí, áchí‑ya̱. Chi̱ kua'a̱n va̱i kua'a̱ ñáyɨvɨ kákuu‑i. Te ni tú ní kánuña‑ya̱ já kée‑yá staa̱. ");
INSERT INTO migNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Te kája'a̱n‑ya̱ iní ɨɨn barco onde̱ nuu̱ íó sɨ́ɨn ñu'un té'é. ");
INSERT INTO migNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Te ni̱ kajini̱ ña̱yɨvɨ já kája'a̱n‑ya̱. Te ni̱ ka̱nakuni̱‑i‑ya̱. Te onde̱ ta̱ká ñuu̱ ni̱ ka̱jinu‑i ni̱ ka̱kutútú‑i yúan. Te ni̱ ja̱koyo‑i xna'a̱n‑ga̱ vásá máá‑yá. Te ni̱ ka̱kutútú‑i nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Te ni̱ kenda Jesús. Te ni̱ jini̱‑ya̱ ñáyɨvɨ kuá'a̱ xáa̱n‑ún. Te ni̱ kundá'ú ini̱‑ya̱‑í, chi̱ nátu̱'un rɨɨ̱ tú jito'o̱ súan ká'i̱in‑i. Te ni̱ stá'a̱n‑ya̱ kuá'a̱ tú'un nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Te sáá chi̱ a kua̱'ini, te cha̱a káskuá'a jíín‑yá, ni̱ jaa̱‑de nuu̱‑yá. Te ni̱ kaka'a̱n‑de: Yá'a chi̱ máá ñú'un té'é kúu, te a kua̱'ini. ");
INSERT INTO migNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Núsáá te tájí‑ní‑i ná kíngoyo‑i ta̱ká rancho jíín táká ñuu̱ yani yá'a, te ná kuáan máá‑i staa̱ kée‑í, chi̱ tú na̱ún kée‑í, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Te máá‑yá, ni̱ ka'a̱n‑ya̱: Kua̱'a máá‑ró já kée‑í, áchí‑ya̱ jíín‑de. Te ni̱ kaka'a̱n‑de jíín‑yá: Ki̱ngoyo‑ná te kuaan‑ná uu̱ ciento peso staa̱ te kua̱'a‑ná kee‑í náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Na̱saa staa̱ kándi̱so‑ró. Kuánde̱'é, áchí‑ya̱. Te nuu̱ ní kajini̱‑de, te ni̱ kaka'a̱n‑de: U'u̱n sta̱tilá te uu̱ ti̱yáká íó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yúan‑na te ni̱ tá'ú‑yá tiñu nuu̱ ñáyɨvɨ‑ún ja̱ ná júngo̱o sɨ́ɨn ɨɨn nuu ɨ́ɨn nuu‑í sɨkɨ̱ ichá kuíi. ");
INSERT INTO migNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Te ni̱ kaju̱ngo̱o yuku̱n‑i, ɨɨn ciento, ɨɨn ciento‑i, jíín úu̱ xiko uxi̱, uu̱ xiko uxi̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Te ni̱ ki'in‑ya̱ ndɨ́'ú'u̱n sta̱tilá‑ún jíín úu̱ ti̱yáká‑ún. Te ni̱ ndakoto‑ya̱ íchi ándɨ́vɨ́. Te ni̱ jika̱n ta'u̱‑yá ja'a̱ státilá. Te ni̱ sákuáchí‑yá sta̱tilá‑ún. Te ni̱ ja̱'a‑ya̱ núu̱ cháa káskuá'a jíín‑yá ni̱ ka̱jani‑de nuu̱‑í. Te ni̱ saka‑yá ndɨ́'úu̱ ti̱yáká‑ún nuu̱ táká‑i. ");
INSERT INTO migNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Te ndivii ñáyɨvɨ‑ún, ni̱ ka̱yee‑í. Te ni̱ kanda'a̱ chi̱i‑i. ");
INSERT INTO migNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Te ni̱ ka̱nastútú‑de ja̱ ní kendo̱o kuáchí, onde̱ uxi̱ uu̱ ji̱ka chítú ndɨ́ɨ kúu, onde̱ jíín tíyáká. ");
INSERT INTO migNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Te cha̱a ni̱ ka̱yee‑ún jínu onde̱ u'u̱n mil‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yúan‑na te ni̱ skandá‑ni Jesús cha̱a káskuá'a jíín‑yá, ni̱ kɨ̱vɨ koyo‑de ini̱ barco. Te ná kúxnúú‑de nuu̱‑yá ki̱ngoyo‑de ɨnga̱ lado yu'u mar nuu̱ ñúu̱ Betsaida. Chi̱ kuéé jachá‑ya̱ ñáyɨvɨ kuá'a̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Te ni̱ nakuatá'ú‑yá nuu̱ ñáyɨvɨ‑ún kua̱ngoyo‑i. Te ni̱ kee‑ya̱ kuá'a̱n‑ya̱ ondé yuku kuákaka̱n ta'u̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Te ni̱ ini, te barco‑ún a kándee onde̱ ma̱'ñú mar. Te máá ɨ́ɨn‑na̱‑ya̱ ní ndo̱o‑ya̱ núu̱ ñú'íchí. ");
INSERT INTO migNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Te ni̱ jini̱‑ya̱ já ní kakui̱tá‑de káskáka‑de barco‑ún, chi̱ sua ni̱ nana nuu tachi̱. Te tɨ́kuáán‑na̱ kúu, te ni̱ chaa̱‑ya̱ núu̱‑dé jíka já'á‑yá nuu̱ mar. Te a ja̱'a‑ya̱ núu̱‑dé ki'i̱n‑ya̱ núú. ");
INSERT INTO migNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Te ni̱ kajini̱‑de‑ya̱ já jíka‑ya̱ núu̱ mar. Te ni̱ ka̱jani ini̱‑de ja̱ añú kúu. Te ni̱ ka̱kana kó'ó‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Chi̱ ndɨ'ɨ‑de, ni̱ kajini̱‑de nuu̱‑yá. Te ni̱ kayu̱'ú‑de. Yúan‑na te ni̱ ka'a̱n‑ni‑ya̱ jíín‑de: Ndéé sá'a‑ró iní‑ro̱. Máá‑rí kúu. Ma̱ yú'ú‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Te ni̱ kaa‑ya̱ ní kɨ̱vɨ‑ya̱ jíín‑de ini̱ barco‑ún. Te ni̱ jukuiñi̱ tachi̱. Te máá‑de, ni̱ ka̱naa xáa̱n iní‑de kánde̱'é‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Chi̱ ni tú ní kájuku̱'un ini̱‑de ja̱ ní kuu jíín státilá‑ún, chi̱ ndava iní añú‑de. ");
INSERT INTO migNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Te ni̱ kaja̱'a‑ya̱ vái‑ya̱ ɨngá lado. Te ni̱ cha̱koyo‑ya̱ ñú'íchí ñúu̱ Genesaret. Te yundúcha‑ún ni̱ ka̱jukuiñi̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Te nuu̱ ní kenda koyo‑ya̱ iní barco, te ña̱yɨvɨ yúan, ni̱ ka̱nakuni̱‑ni‑i Jesús. ");
INSERT INTO migNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Te ni̱ kajicha̱ nu̱u‑i ta̱ká ndañúu̱ yúan. Te ni̱ ka̱kejá'á‑i ni̱ ka̱skuíndíso‑i ña̱yɨvɨ káku'u̱ jíín jíto yuu, onde̱ nuu̱ ní ka̱jini tu̱'un‑i kándee‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Te ndéni ni̱ kuu nú ni̱ kɨ̱vɨ‑ya̱, á ñuu̱ lúlí, á ñuu̱ ká'nu, á rancho, te kájani‑i ña̱yɨvɨ káku'u̱‑ún ini̱ ichi. Te káka'a̱n nda̱'ú‑i jíín‑yá va̱sté yúsá'ma‑yá ná ké'é‑i. Te ta̱ká ña̱yɨvɨ ní ka̱ké'é sá'ma‑yá‑ún, ni̱ kandu̱va̱'a‑i. ");
INSERT INTO migNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Te cha̱a fariseo jíín yakú cha̱a káchaa tutu̱, ni̱ kikoyo‑de ichi ñúu̱ Jerusalén. Te ni̱ ka̱kutútú‑de nuu̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Te cha̱a‑ún, ni̱ kajini̱‑de ja̱ sáva cha̱a káskuá'a jíín‑yá káyee‑dé staa̱ jíín ndá'a chá'án‑de, kua̱chi ja̱ tú ní ka̱nandá'á‑de. Te ni̱ ka̱ndonda sɨkɨ̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Chi cha̱a fariseo jíín táká cha̱a judío, nú tú nandá'á ná'án‑de, tú káyee‑dé staa̱. Chi̱ káñava̱'a‑de tani̱nu aná'án. ");
INSERT INTO migNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Te nú ni̱ ka̱najíó káva‑de ja̱ ní kaja'a̱n‑de nu̱yá'u, te nú tú nasándoo‑de máá‑de, tú káyee‑dé. Te íó kua'a̱‑gá tani̱nu káñava̱'a‑de te káchiñú'ún‑de, nátu̱'un ndúndoo vaso, tɨndo'o̱, ko'o̱ káa, jíín jíto.) ");
INSERT INTO migNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","te cha̱a fariseo jíín cháa káchaa tutu̱, ni̱ kajika̱ tu̱'ún‑de‑ya̱. Te cha̱a káskuá'a jíín‑ró, naja̱ tú káchiñú'ún‑de tani̱nu cha̱a aná'án. Naja̱ káyee‑dé staa̱ jíín ndá'a chá'án‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Cha̱a uu̱ xini̱ kákuu‑ró. Bueno ni̱ jani Isaías tu̱'un sɨkɨ̱‑ro̱, chi̱ súan ni̱ chaa máá‑de tu̱'un sáá: Ña̱yɨvɨ yá'a jíín yú'u‑í káchiñú'ún‑i ruu̱, ko jíín añú‑i chi̱ jíká‑ni kákuu ini̱‑i jíto‑i ruu̱. ");
INSERT INTO migNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Te káchiñú'ún sáni‑i ruu̱, chi̱ kástá'a̱n‑i tu̱'un jáni ini̱ ɨɨn cha̱a, áchí Isaías. ");
INSERT INTO migNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Chi ni̱ ka̱sía̱‑ro̱ tíñu ni̱ tá'ú Dios nuu̱‑ro̱, te káchiñú'ún‑ró táni̱nu ni̱ kajaki̱n cha̱a, ja̱ ndúndoo tɨndo'o̱ jíín vaso. Te káñava̱'a‑ró kuá'a̱‑gá tani̱nu súan, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Te suni ni̱ ka'a̱n‑ya̱: Bueno‑ni kástɨ́vɨ́‑ró tú'un tá'ú tíñu Dios náva̱'a chiñú'ún‑ró táni̱nu ni̱ kajaki̱n máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chi̱ Moisés, ni̱ ka'a̱n‑de: Kuandatu̱‑ro̱ núu̱ táa̱‑ro̱ núu̱ náa̱‑ro̱. Chi̱ nú ndéja̱ ká'a̱n ndɨva̱'a jíín táa̱ jíín náa̱, ná kúu̱ nú kuu̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ko máá‑ró káka'a̱n‑ro̱: Nú íó ndatíñu ja̱ xíin ɨ́ɨn cha̱a. Te a kuu ni'i̱n tíñu ja̱ kuní táa̱‑de xí náa̱‑de, ko nú xna'a̱n‑ga̱ ka'a̱n‑de ja̱ Corbán kúu (ja̱ kuní ka'a̱n, a ni̱ soko̱‑rí nuu̱ Dios), ");
INSERT INTO migNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","yúan‑na te tuká jínu ñú'ún kútɨ sá'a‑de ja̱ kuní táa̱‑de xí já kuní náa̱‑de, áchí‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Te súan kástɨ́vɨ́‑ró tú'un Dios jíín táni̱nu ni̱ kajaki̱n‑ro̱. Te kua'a̱‑gá tiñu súan kásá'a‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Te ni̱ kana tuku‑ya̱ xiní ñáyɨvɨ kuá'a̱‑ún. Te ni̱ ka'a̱n‑ya̱ jíín‑i: Ndɨ'ɨ‑ró ná kúni so̱'o‑ró tú'un ká'a̱n‑ri̱, te chu'un ini̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ta̱ká ndatíñu íó ichi fuera cha̱a, nú ni̱ kɨ̱vɨ ini̱ yu'u‑dé, ma̱ kúchá'án‑de sá'a. Chi ja̱ kénda ini̱ yu'u‑dé, yu̱án kúu ja̱ kúchá'án‑de sá'a. ");
INSERT INTO migNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Cha̱a íó so̱'o kuni ná'ín, te ná kúni so̱'o‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Te nuu̱ ní kusɨ́ɨn‑ya̱ núu̱ ñáyɨvɨ kuá'a̱‑ún, te ni̱ ndɨ̱vɨ‑ya̱ iní ve̱'e. Te cha̱a káskuá'a jíín‑yá, ni̱ kajika̱ tu̱'ún‑de‑ya̱ sɨkɨ́ tú'un yátá‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Suni tú kájuku̱'un ini̱ máá‑ró náún. Á tú kájini̱‑ro̱ já táká ja̱ kɨ́vɨ ini̱ cha̱a, ma̱ kúu kuchá'án‑de sá'a, ");
INSERT INTO migNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","chi̱ tú kɨ́vɨ ini̱ añú‑de, chi̱ toko‑dé kɨ́vɨ, te ndénda‑ni kua'a̱n, áchí‑ya̱. Súan ni̱ stá'a̱n‑ya̱ já íó ndoo ta̱ká ndeyu. ");
INSERT INTO migNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Te ni̱ ka'a̱n‑ga̱‑ya̱: Ja̱ kénda ichi iní ña̱yɨvɨ, yu̱án kúu ja̱ kúchá'án‑i sá'a. ");
INSERT INTO migNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chi̱ onde̱ ichi iní añú kénda ja̱ jáni ñáá ini̱, ja̱ ísɨ́kɨ ncháa̱ tá'a̱n, ja̱ kuáxán iní, ja̱ já'ni ndɨ́yi, ");
INSERT INTO migNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ja̱ sákuí'ná, ja̱ tóó iní, ja̱ ñáá, ja̱ xndá'ú ñá'án, ja̱ tuká kúka nuu̱, ja̱ ndákoto xaa̱n, ja̱ ká'a̱n sɨkɨ̱ tá'an, ja̱ sávixi̱ máá, ja̱ xiní ñáá. ");
INSERT INTO migNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ta̱ká tu̱'un ñáá yá'a, máni ichi iní añú kénda te kúchá'án‑i sá'a, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Te ni̱ ndukuiñi̱‑ya̱ yúan. Te kua'a̱n‑ya̱ ondé raya ñuu̱ Tiro jíín ñúu̱ Sidón. Te ni̱ kɨ̱vɨ‑ya̱ ɨ́ɨn ve'e. Te kuní‑ya̱ já tú ni ɨɨn kuni tu̱'un. Ko tú ní kúu kundee sá'í‑ya̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chi̱ ɨɨn ña'an íó ɨɨn se̱sɨ́'ɨ́‑ña tá'a̱n‑i tachi̱ kíni. Te ni̱ jini tu̱'un‑ña tú'un‑ya̱. Te ni̱ chaa̱‑ni‑ña. Te ni̱ jukuiñi̱ jítɨ́‑ña núu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Te ña'an‑ún, ña'an griega kúu‑ña. Te onde̱ ñuu̱ Sirofenicia va̱i tata̱‑ña. Te ni̱ ka'a̱n nda̱'ú‑ña jíín‑yá ja̱ ná kíñi'in‑ya̱ tachí kíni tá'a̱n se̱sɨ́'ɨ́‑ña‑ún ki'i̱n. ");
INSERT INTO migNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑ña: Sía̱, ná ndá'a̱ xna'a̱n‑ga̱ chi̱i ta̱ká su̱chí yá'a, chi̱ tú íó va̱'a ja̱ kuánchaa̱‑yo̱ stáa̱‑í te skána‑yó núu̱ lúsu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Te ni̱ ka'a̱n‑ña: Ja̱ndáa̱ ká'a̱n‑ní Táta̱, ko lúsu‑ún ichi chíi mesa náchii‑tɨ́ staa̱ kua̱chí kóyo yu'u‑í yáji‑tɨ́, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín‑ña: Kuá'án núsáá, chi tu̱'un va̱'a kúu ja̱ ní ka'a̱n‑ro̱ yá'a. Te tachi̱ kíni‑ún, a ni̱ kenda kua'a̱n ini̱ se̱sɨ́'ɨ́‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Te ni̱ kee‑ña kuáno'on‑ñá ve'e‑ña. Te ni̱ jini̱‑ña já kátúu sésɨ́'ɨ́‑ña núu̱ jíto. Te a ni̱ kenda tachi̱ kíni‑ún kua'a̱n. ");
INSERT INTO migNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Te ni̱ kenda tuku‑ya̱ ondé raya ñuu̱ Tiro, ni̱ kii‑ya̱ íchi Sidón. Te ni̱ jaa̱‑ya̱ mar Galilea. Te ni̱ ja'ncha̱ sava‑ya̱ raya ñuu̱ Decápolis va̱i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Te ni̱ ka̱kinchaka‑i ɨɨn cha̱a só'ó kástété núu̱‑yá. Te ni̱ kaka'a̱n nda̱'ú‑i jíín‑yá ja̱ ná xndée‑ya̱ ndá'a‑yá sɨkɨ̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Te ni̱ kiñi'in sɨ́ɨn‑ya̱‑dé nuu̱ ñáyɨvɨ kuá'a̱‑ún. Te ni̱ chindee‑ya̱ ndá'a‑yá so̱'o‑de. Te ni̱ tɨvɨ̱ sɨ̱'vɨ́‑yá. Te ni̱ ké'é‑yá yáa‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Te ni̱ ndakoto‑ya̱ íchi ándɨ́vɨ́. Te ni̱ jaka̱ nu̱u ini̱‑ya̱. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Efata, áchí‑ya̱. Ja̱ kuní ka'a̱n: Nanuña. ");
INSERT INTO migNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Te ni̱ nanuña so̱'o‑de. Te ni̱ nduvi̱tá yáa‑dé. Te ni̱ kuu‑ni ni̱ naka'a̱n kájí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Te ni̱ ka'a̱n xaa̱n‑yá jíín ñáyɨvɨ‑ún ja̱ tú ni ɨɨn nuu̱ kachí‑i. Te va̱sa ni̱'in ni̱ ka'a̱n xaa̱n‑yá jíín‑i, ko ví'í‑gá ni̱ kajacha̱‑i tu̱'un‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Te ni̱ ka̱naa xáa̱n iní‑i kánde̱'é‑i. Te ni̱ kaka'a̱n‑i: Bueno sá'a‑ya̱ táká tiñu; chi cha̱a só'ó nákuni so̱'o‑de, te cha̱a ñí'ín náka'a̱n‑de sá'a‑ya̱, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Te kɨvɨ̱‑ún, ni̱ i̱o kua'a̱ xáa̱n ñáyɨvɨ, te tú na̱ún káji‑í. Te ni̱ kana Jesús xini̱ cháa káskuá'a jíín‑yá. Te ni̱ ka'a̱n‑ya̱ jíín‑de: ");
INSERT INTO migNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Kúndá'ú ini̱‑ri̱ ña̱yɨvɨ kuá'a̱ yá'a, chi̱ a ni̱ kuu uni̱ kɨvɨ̱ káxiu̱kú‑i jíín‑rí, te tú na̱ún káji‑í. ");
INSERT INTO migNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Te nú natájí‑rí‑i no'o̱n ndicha̱‑i ve'e‑i, te sava ichi te kui̱tá ii̱‑í, chi̱ íó sava‑i jíká vái koyo‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Te cha̱a káskuá'a jíín‑yá, ni̱ kaka'a̱n‑de jíín‑yá: Te ndéchi kíi staa̱ kée ndá'a̱ chi̱i ña̱yɨvɨ yá'a, chi̱ máni ñu'un té'é kúu yá'a. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Te ni̱ jika̱ tu̱'ún‑yá‑de: Na̱saa staa̱ kándi̱so‑ró. Achí‑ya̱. Te ni̱ kaka'a̱n‑de: Usia̱‑ni sta̱tilá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yúan‑na te ni̱ tá'ú‑yá tiñu nuu̱ ñáyɨvɨ kuá'a̱‑ún ja̱ ná júngo̱o‑i nuu̱ ñú'un. Te ni̱ ki'in‑ya̱ ndɨ́'usiá sta̱tilá‑ún. Te ni̱ jika̱n ta'u̱‑yá. Te ni̱ sákuáchí‑yá. Te ni̱ ja̱'a‑ya̱ núu̱ cháa káskuá'a jíín‑yá, ja̱ ná káni‑de nuu̱ ñáyɨvɨ kuá'a̱‑ún. Te ni̱ ka̱jani‑de nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Te suni kándi̱so‑de yaku̱ ti̱yáká lúlí. Te ni̱ jika̱n ta'u̱‑yá ja'a̱‑tɨ́. Te ni̱ tá'ú‑yá tiñu ja̱ súni ná káni‑de nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Te ni̱ ka̱yee‑í. Te ni̱ kanda'a̱ chi̱i‑i. Te ni̱ kendo̱o‑ga̱. Te ni̱ ka̱nastútú‑de usia̱ ndo'o̱ já ní kendo̱o kuáchí. ");
INSERT INTO migNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Te ña̱yɨvɨ ní ka̱yee‑ún íó nátu̱'un kuu̱n mil‑i. Te ni̱ jacha̱‑ya̱‑í kua'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yúan‑na te ni̱ kɨ̱vɨ‑ni‑ya̱ iní barco jíín cháa káskuá'a jíín‑yá. Te ni̱ chaa̱‑ya̱ ndáñúu̱ Dalmanuta. ");
INSERT INTO migNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Te yúan ni̱ cha̱koyo cha̱a fariseo. Te ni̱ ka̱kejá'á‑de káxndichí‑de‑ya̱ kájika̱n‑de tuni̱ ichi ándɨ́vɨ́ núu̱‑yá chi̱ koto nchaa̱‑de‑ya̱ kákuni̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Te ni̱ jaka̱ nu̱u ini̱‑ya̱. Te ni̱ ka'a̱n‑ya̱: Naja̱ kájika̱n ña̱yɨvɨ yá'a tuni̱ nuu̱‑rí. Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ma̱ kuá'a‑ri̱ ni ɨɨn tuni̱ nuu̱ ñáyɨvɨ yá'a. ");
INSERT INTO migNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Te ni̱ skéndo̱o‑ya̱‑dé jíná'an‑de. Te ni̱ ndɨ̱vɨ tuku‑ya̱ iní barco, te kua'a̱n‑ya̱ ɨngá lado. ");
INSERT INTO migNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Te cha̱a káskuá'a jíín‑yá, ni̱ ka̱naa iní‑de kundiso‑de staa̱. Chi̱ ɨɨn‑ni sta̱tilá kándi̱so‑de ini̱ barco. ");
INSERT INTO migNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Te ni̱ ka'a̱n xaa̱n‑yá jíín‑de: Koto va̱'a‑ró máá‑ró núu̱ yújan íá cháa fariseo jíín núu̱ yújan íá Herodes, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Te kándatu̱'ún máá‑de: Sɨkɨ̱ já tú kándi̱so‑yó stáa̱ núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Te ni̱ jini̱ Jesús. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Naja̱ kándatu̱'ún‑ró. Ja̱ tú kándi̱so‑ró stáa̱ náún. Á tú kájini̱‑ro̱. Á cha'a̱n‑ga̱ juku̱'un ini̱‑ro̱. Sáni ndava iní añú‑ro̱ náún. ");
INSERT INTO migNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ká'i̱o so̱'o‑ró, te á tú kájini so̱'o‑ró. Ká'i̱o nduchi‑ro, te á tú kánde̱'é‑ró, te á tú kánuku̱'un ini̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Te na̱saa ji̱ka chítú ndɨ́ɨ státilá ni̱ kendo̱o kuáchí ní ka̱nastútú‑ró kɨvɨ́ ní sákuáchí‑rí u'u̱n sta̱tilá ni̱ ka̱yee ú'u̱n mil cha̱a, áchí‑ya̱. Te ni̱ kaka'a̱n‑de: Uxi̱ uu̱‑ni, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Te ni̱ ka'a̱n tuku‑ya̱: Te na̱saa ndo'o̱ chítú ndɨ́ɨ státilá ni̱ kendo̱o kuáchí ní ka̱nastútú‑ró kɨvɨ́ ní sákuáchí‑rí usia̱ sta̱tilá ni̱ ka̱yee kúu̱n mil ña̱yɨvɨ, áchí‑ya̱. Te ni̱ kaka'a̱n‑de: Usia̱‑ni, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín‑de: Te onde̱ vina tú kájuku̱'un ini̱‑ro̱ náún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Te ni̱ jaa̱‑ya̱ ñúu̱ Betsaida. Te ni̱ ka̱kinchaka‑i ɨɨn cha̱a kuáá núu̱‑yá. Te ni̱ kaka'a̱n nda̱'ú‑i jíín‑yá ja̱ ná ké'é‑yá‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yúan‑na te ni̱ tɨɨn‑ya̱ ndá'a cháa kuáá‑ún. Te ni̱ kiñi'in‑ya̱‑dé ñuu̱‑ún. Te ni̱ tɨvɨ̱ sɨ̱'vɨ́‑yá nduchi‑dé. Te ni̱ xndée‑ya̱ ndá'a‑yá sɨkɨ̱‑dé. Te ni̱ jika̱ tu̱'ún‑yá‑de: Á jiní‑ro̱ yakú, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Te máá‑de, ni̱ ndakoto‑de. Te ni̱ ka'a̱n‑de: Jiní‑ná ta̱ká cha̱a. Ko nátu̱'un yunu jiní‑ná‑de kájika‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yúan‑na te ni̱ chaa tuku‑ya̱ ndá'a‑yá sɨkɨ̱ ndúchi‑dé. Te ni̱ ndakoto va̱'a‑de. Te ni̱ nduva̱'a ii̱‑dé. Te onde̱ jíká te ni̱ jini̱ kájí‑de ndivii. ");
INSERT INTO migNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Te ni̱ na̱tájí‑yá‑de kua̱no'on‑dé ve'e‑de. Te ni̱ ka'a̱n‑ya̱: Ma̱ kɨ́vɨ‑ró iní ñuu̱. Te ni ɨɨn nuu̱ cháa ñuu̱‑ún ma̱ kachí‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Te ni̱ kenda Jesús jíín cháa káskuá'a jíín‑yá kua'a̱n‑ya̱ jíín‑de ichi táká ñuu̱ ndañúu̱ Cesarea de Filipo. Te ichi‑ún ni̱ jika̱ tu̱'ún‑yá‑de: Te ruu̱, na̱ cha̱a kúu‑ri̱ káka'a̱n ña̱yɨvɨ, áchí‑ya̱ jíín cháa káskuá'a jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Te ni̱ kaka̱stu̱'ún‑de nuu̱‑yá: Juan ja̱ skuánducha, káka'a̱n‑i. Te sava‑i: Elías. Te sava‑ga̱‑i: Ɨɨn cha̱a ni̱ jani tu̱'un Dios onde̱ sáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín‑de: Te róó, na̱ cha̱a kúu‑ri̱ káka'a̱n máá‑ró, áchí‑ya̱. Te ni̱ ka'a̱n Pedro: Máá‑ní kúu Cristo, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Te ni̱ ka'a̱n xaa̱n‑yá jíín‑de jíná'an‑de ja̱ tú ni ɨɨn nuu̱ kachí‑de tu̱'un‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Te ni̱ kejá'á‑yá ni̱ stá'a̱n‑ya̱ núu̱‑dé ja̱ jínu ñú'ún ndó'o xaa̱n máá Sé'e cha̱a. Te cha̱a ni̱ ka̱yii jíín táká sutu̱ ñá'nu jíín cháa káchaa tutu̱ ma̱ kuátú'ún‑de‑ya̱, chi̱ ka'ni‑dé‑ya̱. Te nuu̱ uní kɨvɨ̱ te nachaku̱‑ya̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Te kájí ní ka'a̱n‑ya̱ tú'un yá'a. Yúan‑na te Pedro, ni̱ tɨɨn‑de‑ya̱. Te ni̱ kejá'á‑de ká'a̱n xaa̱n‑dé nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Te máá‑yá, ni̱ jíó káva‑ya̱. Te ni̱ ndakoto‑ya̱ núu̱ cháa káskuá'a jíín‑yá. Te ni̱ ka'a̱n xaa̱n‑yá nuu̱ Pedro: Satanás, kuxio ki'i̱n‑ro̱, chi̱ tú júku̱'un ini̱‑ro̱ tú'un Dios, chi̱ sa tu̱'un cha̱a júku̱'un ini̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Te ni̱ kana‑ya̱ xiní ñáyɨvɨ kuá'a̱‑ún jíín cháa káskuá'a jíín‑yá. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Na̱ni cha̱a nú kuní‑de kii‑de yata̱‑rí, te ma̱ chíñú'ún‑de máá‑de, te ná kuándéé iní‑de jíín túndó'o kii sɨkɨ̱‑dé, te ná kúndiki̱n‑de ruu̱ kii‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chi cha̱a jítú iní‑de ka̱ku‑de chi̱i tu̱ndó'o kii sɨkɨ̱‑dé, naa‑dé. Te va̱sa ná kúu̱ ɨɨn cha̱a ja̱ sɨkɨ́ rúu̱ jíín sɨkɨ́ tú'un va̱'a‑ri̱, ko ka̱ku‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Chi na̱ún ní'i̱n cháa va̱sa ná kúndéé‑de ni'i̱n‑dé nɨ́ɨ́ ñúyɨ́vɨ, te nú xnáa‑dé añú‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Xí na̱ún chúnáa cháa añú‑de. ");
INSERT INTO migNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Chi̱ nú ndé cha̱a kúka nuu̱ iní‑de nuu̱‑rí jíín núu̱ tú'un ká'a̱n‑ri̱ ma̱'nú ñáyɨvɨ yá'a ja̱ kái̱sɨ́kɨ ncháa̱‑i Dios jíín má'ñú cháa kásá'a kua̱chi, te suni súan kuka nuu̱ iní máá Sé'e cha̱a nuu̱‑dé, kɨvɨ̱ ndíi‑ya̱ jíín táká ndajá'a̱ ndóo‑ya̱. Te kɨvɨ̱‑ún ndúñá'nu‑ya̱ sá'a Táa̱‑ya̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Te suni ni̱ ka'a̱n‑ya̱ jíín‑de jíná'an‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Ió sava cha̱a ká'i̱in yá'a ja̱ má kúu̱ kutɨ‑dé onde̱ nú tú kuni̱‑de ñuu̱ nuu̱ tá'ú Dios tiñu, ndasa kii jíín fuerza, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yúan‑na te nuu̱ iñú kɨvɨ̱ te ni̱ jaka Jesús Pedro jíín Jacobo jíín Juan, te máni máá‑ni‑de ni̱ kiñi'in sɨ́ɨn‑ya̱‑dé kua'a̱n‑ya̱ jíín‑de ɨɨn yuku súkún. Te yúan, tuku ni̱ nduu‑ya̱ núu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Te sa'ma‑yá ni̱ ka̱nandii ncháa̱, kɨyi̱ xaa̱n, nátu̱'un yu'a̱ volcán. Te tú íó ni ɨɨn ja̱ súan kuu nakacha kɨyi̱ ini̱ ñu̱yɨ́vɨ yá'a. ");
INSERT INTO migNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Te ni̱ ka̱ndenda Elías jíín Moisés ni̱ kajini̱‑de. Te ni̱ kanda̱tu̱'ún cháa‑ún jíín Jesús. ");
INSERT INTO migNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yúan‑na te ni̱ ka'a̱n Pedro: Maestro, va̱'a‑ga̱ ná kéndo̱o‑yó yá'a, te sá'a‑ná uni̱ ve'e kuii. Ɨɨn kuu máá‑ní, ɨnga̱ kuu Moisés, te ɨnga̱ kuu Elías, áchí‑de jíín Jesús. ");
INSERT INTO migNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Chi̱ tú ní jiní‑de ndasa ka'a̱n‑de, chi̱ káyu̱'ú xáa̱n‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Te ni̱ chaa̱ ɨɨn viko̱ nu̱'ún. Te ni̱ jasu̱ nɨ́ɨ́ núu̱‑dé. Te nuu̱ vikó nu̱'ún‑ún ni̱ kenda ɨɨn tu̱'un ja̱ ní ka'a̱n: Ya̱'á kúu Se̱'e‑ri̱ ja̱ kúndá'ú ini̱‑ri̱, te kuni ná'ín‑ró tú'un ká'a̱n‑ya̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Te ni̱ ka̱ndakoto‑ni‑de. Te tuká ni ɨɨn na̱ún ní kájini̱‑de, chi̱ máá ɨ́ɨn‑na̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Te kánuu‑de yuku‑ún, te ni̱ ka'a̱n xaa̱n‑yá jíín‑de ja̱ tú ni ɨɨn nuu̱ kachí‑de ja̱ súan ni̱ kajini̱‑de‑ún, chi̱ onde̱ ná náchaku̱ máá Sé'e cha̱a ma̱'ñú ndɨ́yi. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Te ni̱ kañu̱'un ini̱ máá‑de tu̱'un‑ún. Te kájika̱ tu̱'ún tá'an‑de na̱ún tu̱'un kúu: Ja̱ náchaku̱ ma̱'ñú ndɨ́yi. ");
INSERT INTO migNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Te ni̱ kajika̱ tu̱'ún‑de‑ya̱: Te cha̱a káchaa tutu̱ naja̱ káka'a̱n‑de ja̱ kánúú ndíi Elías xna'a̱n‑ga̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ja̱ndáa̱ kúu ja̱ ndíi Elías xna'a̱n‑ga̱, te nasájáá‑de ta̱ká ndatíñu. Te suni yóso tú'un nuu̱ tutú ja̱ ndó'o xaa̱n máá Sé'e cha̱a te sájá'a̱ ini̱‑i nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","A ká'a̱n‑ri̱ jíín‑ró ja̱ Elías, a ni̱ kii‑de. Te ni̱ ka̱sá'a‑i ta̱ká ja̱ ní ka̱kuu ini̱‑i jíín‑de, nátu̱'un yóso tú'un‑de nuu̱ tutú, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Te ni̱ nchaa̱‑ya̱ núu̱ sáva‑ga̱ cha̱a káskuá'a jíín‑yá. Te ni̱ jini̱‑ya̱ ñáyɨvɨ kuá'a̱ xáa̱n, ni̱ ka̱jíkó ndúu̱‑i nɨ́ɨ́ núu̱‑dé. Te cha̱a káchaa tutu̱ kástátá'an jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yúan‑na te ta̱ká ña̱yɨvɨ‑ún, ni̱ kajini̱‑ni‑i nuu̱‑yá. Te ni̱ ka̱naa iní‑i kánde̱'é‑i nuu̱‑yá. Te ni̱ katau̱‑i kua'a̱n‑i nuu̱‑yá. Te ni̱ kaka'a̱n‑i jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Te ni̱ jika̱ tu̱'ún‑yá‑i: Na̱ sɨkɨ̱ kástátá'an‑ró jíín‑de jíná'an‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yúan‑na te ni̱ ka'a̱n ɨɨn cha̱a ma̱'ñú ñáyɨvɨ kuá'a̱‑ún: Maestro, va̱i nchaka‑ná se̱'e‑ná nuu̱‑ní, chi̱ tá'a̱n‑i ɨɨn tachi̱ ñí'ín. ");
INSERT INTO migNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Te tachi̱‑ún, ndéni kúu te nú ni̱ tɨɨn‑ni‑i, te já'ni yí'í‑ni‑i. Te sjáa‑ni ti'iñu̱ yu'u‑í. Te skɨ́'ñi nu̱'un‑i. Te kua̱'ichi̱‑i sá'a. Te ni̱ ka'a̱n‑ná jíín cháa káskuá'a jíín‑ní ja̱ ná kíñi'in‑de ki'i̱n. Te tú ní kákuu sá'a‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Te ni̱ ka'a̱n‑ya̱ jíín‑i: Ña̱yɨvɨ xáa̱n ní'in ini̱ kákuu‑ró. Na̱saa‑ga̱ kɨvɨ kúnchaa̱‑ri̱ jíín‑ró. Te na̱saa‑ga̱ kɨvɨ̱ ndó'o‑ri̱ jíín‑ró. Kua̱'a‑i ná kíi‑i nuu̱‑rí núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Te ni̱ kaja̱'a‑de‑i nuu̱‑yá. Te ni̱ jini̱‑i‑ya̱. Te tachi̱‑ún, ni̱ ja'ni yí'í xáa̱n‑ní‑i. Te ni̱ ndua̱‑i nuu̱ ñú'un. Te ni̱ tuu‑í. Te ni̱ jaa ti'iñu̱ yu'u‑í. ");
INSERT INTO migNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Te Jesús, ni̱ jika̱ tu̱'ún‑yá táa̱‑i: Na̱saa kɨvɨ̱ ní kuu tá'a̱n‑i tachi̱ yá'a, áchí‑ya̱. Te ni̱ ka'a̱n‑de: Onde̱ lúlí‑i. ");
INSERT INTO migNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Te tondó tɨnɨ̱ jínu ni̱ kuu chíndee‑i nuu̱ ñú'u̱n jíín núu̱ ndúcha, ja̱ ká'ni‑í kuní. Ko nú kuu sá'a‑ní, kundá'ú ini̱‑ní náá. Te chindéé chítuu‑ní náá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Te ni̱ ka'a̱n Jesús jíín‑de: Te nú kándíja‑ró, chi cha̱a kándíja te kuu ta̱ká ja̱ kuní‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yúan‑na te máá táa̱ su̱chí‑ún, ni̱ ka'a̱n jaa‑ni‑de: Kándíja‑ná, ko chindéé chítuu‑ní náá chi̱ tú kándíja va̱'a va̱'a‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Te ni̱ jini̱ Jesús ja̱ ní katau̱ ña̱yɨvɨ kuá'a̱‑ún kua'a̱n‑i nuu̱‑yá. Te ni̱ ka'a̱n xaa̱n‑yá jíín tachí kíni‑ún: Tachi̱ ñí'ín só'ó, ruu̱ tá'ú‑rí tiñu nuu̱‑ro̱. Kenda‑ró iní‑i, te ma̱ ndɨ́vɨ‑ga̱‑ro̱ iní‑i, áchí‑ya̱ jíín. ");
INSERT INTO migNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yúan‑na te tachi̱‑ún, ni̱ kana kó'ó. Te tɨnɨ̱ jínu ni̱ ja'ni yí'í xáa̱n‑gá‑i. Te ni̱ kenda kua'a̱n. Te máá súchí‑ún, ni̱ kundɨ̱yi‑ni‑i. Te ni̱ kaka'a̱n tɨnɨ̱ ña̱yɨvɨ: A ni̱ ji'i̱‑i, áchí. ");
INSERT INTO migNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Te Jesús, ni̱ tɨɨn‑ya̱ ndá'a‑í, te ni̱ ndukani‑ya̱‑í. Te ni̱ ndukuiñi̱‑i. ");
INSERT INTO migNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Te nuu̱ ní kɨ̱vɨ Jesús ini̱ ve̱'e, te cha̱a káskuá'a jíín‑yá, ni̱ kajika̱ tu̱'ún sɨ́ɨn‑de‑ya̱: Naja̱ tú ní kákuu kiñi'in‑ná tachi̱‑ún ki'i̱n, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ɨɨn tá'an yu̱án, ni ma̱ kénda kutɨ kí'i̱n, te nú tú kaka̱n ta'u̱‑yo̱ te kondicha̱ ini̱‑yo̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Te ni̱ ka̱kenda‑ya̱ yúan. Te ni̱ kaja̱'a‑ya̱ kuá'a̱n‑ya̱ íchi ndáñúu̱ Galilea. Te tú ní kuní‑ya̱ já kúni tu̱'un ni ɨɨn. ");
INSERT INTO migNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Te ni̱ stá'a̱n‑ya̱ núu̱ cháa káskuá'a jíín‑yá: Ña̱yɨvɨ yá'a nastúu‑i máá Sé'e cha̱a nuu̱ ndá'a sáva‑ga̱ cha̱a. Te cha̱a‑ún, ka'ni‑dé‑ya̱. Ko nú ni̱ ji'i̱‑ya̱, te nuu̱ uní kɨvɨ̱ te nachaku̱‑ya̱, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Te máá‑de, tú ní kájuku̱'un ini̱‑de tu̱'un yá'a. Te ni̱ kayu̱'ú‑de kaka̱ tu̱'ún‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Te ni̱ jaa̱‑ya̱ ñúu̱ Capernaum. Te nuu̱ ní kɨ̱vɨ‑ya̱ iní ve̱'e, te ni̱ jika̱ tu̱'ún‑yá‑de: Na̱ún tu̱'un ni̱ kanda̱tu̱'ún‑ró íchi‑ún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Te máá‑de, tú ní káka'a̱n kutɨ‑dé. Chi̱ ichi‑ún ni̱ ka̱státá'an‑de ndé cha̱a kuu ñá'nu‑ga̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yúan‑na te ni̱ jungo̱o‑ya̱. Te ni̱ kana‑ya̱ xiní ndɨ́'uxí uu̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Nú ndé cha̱a kuní‑de kunúú‑de, te nduu‑de sandɨ̱'ɨ́‑na̱ nuu̱ táká tá'an‑de. Te kuatíñu‑de nuu̱ tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Te ni̱ tɨɨn‑ya̱ ɨ́ɨn su̱chí lúlí. Te ni̱ jani‑ya̱‑í ma̱'ñú‑de. Te ni̱ junu nchaa̱‑ya̱‑í. Te ni̱ ka'a̱n‑ya̱ jíín‑de: ");
INSERT INTO migNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Cha̱a ja̱ jíín sɨ́'vɨ́‑rí kuatá'ú‑de ɨɨn su̱chí lúlí nátu̱'un su̱chí yá'a, te ruu̱ kuatá'ú‑de. Te cha̱a kuatá'ú rúu̱, nasu̱ rúu̱, chi̱ I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱ kuatá'ú‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Te ni̱ ka'a̱n Juan jíín‑yá: Maestro, ni̱ kajini̱‑ná ɨɨn cha̱a ja̱ jíín sɨ́'vɨ́‑ní ni̱ kiñi'in‑de tachi̱ kíni kája'a̱n. Te tú ndikín‑de yóó. Te ni̱ kajasu̱‑ná nuu̱‑dé. Chi̱ tú ndikín‑de yóó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Ma̱ kasú‑ro̱ núu̱‑dé, chi̱ ɨɨn cha̱a ja̱ jíín sɨ́'vɨ́‑rí sá'a‑de tiñu ñá'nu, ma̱ kúu naka'a̱n‑de sɨkɨ̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Chi cha̱a tú ká'a̱n sɨkɨ̱‑yo̱, ndújíín‑de jíín‑yó. ");
INSERT INTO migNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Te nú ndé cha̱a kua̱'a‑de ɨɨn yajin ndúcha kó'o‑ró jíín sɨ́'vɨ́‑rí, te nú súan ná sá'a‑de chi̱ kándujíín‑ró jíín Cristo, ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ja̱ má xnáa‑dé ya̱'u‑de. ");
INSERT INTO migNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Te nú ɨɨn su̱chí lúlí yá'a kándíja‑i ruu̱ te kɨ̱vɨ‑i kua̱chi sá'a ɨɨn cha̱a, te va'a̱‑ga̱ nú ní nú'ni̱ ɨɨn yo̱só ká'nu suku̱n‑dé, te kenda‑de ki'i̱n‑de nuu̱ ndúcha mar núú. ");
INSERT INTO migNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Te nú nda'a‑ro kuní skɨ́vɨ róó nuu̱ íó kua̱chi, xɨtɨ ná kí'i̱n. Va'a̱‑ga̱ ja̱ kúchaku̱ tɨ́kú'lu‑ró, nasu̱ já kóo ndendúú nda'a‑ro kí'i̱n‑ro̱ núu̱ infierno, nuu̱ kayú ñu'u̱n ja̱ má ndá'va̱ kutɨ. ");
INSERT INTO migNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Te yúan, ni tɨ̱ndákú‑de ma̱ kúu̱‑tɨ̱. Te ni ñu'u̱n‑ún ma̱ ndá'va̱ kutɨ. ");
INSERT INTO migNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Te nú ja'a̱‑ro̱ kuní skɨ́vɨ róó nuu̱ íó kua̱chi, xɨtɨ ná kí'i̱n. Va'a̱‑ga̱ ja̱ kúchaku̱ tɨ́kú'lu‑ró, nasu̱ já kóo ndendúú ja'a̱‑ro̱ kí'i̱n‑ro̱ núu̱ infierno, nuu̱ kayú ñu'u̱n ja̱ má ndá'va̱ kutɨ. ");
INSERT INTO migNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Te yúan, ni tɨ̱ndákú‑de ma̱ kúu̱‑tɨ̱. Te ni ñu'u̱n‑ún ma̱ ndá'va̱ kutɨ. ");
INSERT INTO migNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te nú nduchi‑ro kuní skɨ́vɨ róó nuu̱ íó kua̱chi, tava ná kí'i̱n. Va'a̱‑ga̱ kɨ́vɨ‑ró ñúu̱ nuu̱ tá'ú Dios tiñu jíín ɨ́ɨn‑ni nduchi‑ro, nasu̱ já kóo ndendúú nduchi‑ro kí'i̱n‑ro̱ núu̱ infierno. ");
INSERT INTO migNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Te yúan, ni tɨ̱ndákú‑de ma̱ kúu̱‑tɨ̱. Te ni ñu'u̱n‑ún ma̱ ndá'va̱ kutɨ. ");
INSERT INTO migNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Chi ta̱ká cha̱a kuu u'a̱‑de sá'a ñu'u̱n. Te ta̱ká ku̱ñu ni̱ soko̱, kuu u'a̱ sá'a ñii̱. ");
INSERT INTO migNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Va̱'a íó ñii̱. Ko nú ñii̱‑ún ná náa xikó u'a̱, ndasa ndu'u'a̱ sá'a‑ró núsáá. Ná kúñava̱'a‑ró ñíi̱ iní máá‑ró. Te ma̱ kána̱á‑ro̱ jíín tá'an‑ró, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Te ni̱ kenda‑ya̱ yúan, te ni̱ chaa̱‑ya̱ ondé raya ñuu̱ Judea jíín ɨngá lado yata̱ yúcha Jordán. Te ni̱ kutútú tuku ña̱yɨvɨ kuá'a̱ núu̱‑yá. Te ni̱ stá'a̱n tuku‑ya̱ tú'un nuu̱‑í, nátu̱'un sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Te ni̱ ja̱koyo cha̱a fariseo nuu̱‑yá ja̱ kóto nchaa̱‑de‑ya̱. Te ni̱ kajika̱ tu̱'ún‑de‑ya̱: Á íó ley ja̱ skéndo̱o ɨɨn cha̱a ñasɨ́'ɨ́‑de, xí túu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Te máá‑yá, ni̱ ka'a̱n‑ya̱ jíín‑de: Na̱ún tiñu ni̱ tá'ú Moisés nuu̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yúan‑na te ni̱ kaka'a̱n‑de: Moisés, ni̱ jatu̱'un‑de ja̱ kúva̱'a acta ndusɨ́ɨn, te ndo̱o‑ña, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Sɨkɨ já ní'in ini̱ añú‑ro̱ jíná'an‑ró, yu̱án súan ni̱ tá'ú‑de tiñu yá'a nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ko onde̱ xnáñúú kɨvɨ́ ní jungo̱o ñu̱yɨ́vɨ, chi ja̱ yíí jíín já sɨ̱'ɨ́ ní sá'a Dios. ");
INSERT INTO migNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ja̱ yúán kúu ja̱ skéndo̱o cha̱a táa̱‑de náa̱‑de, te ketá'an‑de jíín ñásɨ́'ɨ́‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Te ja̱ ní kuu uu̱ tá'a̱n, ɨɨn‑na̱ kúu. Na̱ tuká kúu uu̱, chi̱ ɨɨn‑na̱ kúu. ");
INSERT INTO migNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Núsáá te ja̱ á ni̱ skétá'an Dios, ma̱ ndúsɨ́ɨn kutɨ sá'a ɨɨn ña̱yɨvɨ, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Te onde̱ ve'e te cha̱a káskuá'a jíín‑yá, ni̱ kajika̱ tu̱'ún tuku‑de‑ya̱ sɨkɨ́ tú'un‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Nú ndé cha̱a skéndo̱o‑de ñasɨ́'ɨ́‑de te ta̱nda'a‑dé jíín ɨngá ña'an, te ísɨ́kɨ ncháa̱‑de ñasɨ́'ɨ́‑de nú súan. ");
INSERT INTO migNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Te nú máá ñásɨ́'ɨ́‑ún xndóo‑ña yíi‑ñá te ta̱nda'a‑ñá jíín ɨngá‑de, te tu̱'un ísɨ́kɨ ncháa̱ sá'a‑ña. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Te ni̱ cha̱koyo sava ña̱yɨvɨ núu̱‑yá jíín súchí lúlí ja̱ ké'é‑yá‑i. Te cha̱a káskuá'a jíín‑yá, ni̱ kaka'a̱n xaa̱n‑dé nuu̱ ñáyɨvɨ vái koyo jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Te ni̱ jini̱ Jesús. Te ni̱ kiti̱ ini̱‑ya̱. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Sía̱, ná kíkoyo su̱chí lúlí núu̱‑rí, te ma̱ kasú‑ro̱ íchi‑í, chi̱ tá'an súan kákuu ja̱ xíín ñúu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Nú ɨɨn cha̱a tú játú'ún‑de ñuu̱ nuu̱ tá'ú Dios tiñu nátu̱'un játú'ún ɨ́ɨn su̱chí lúlí, ma̱ kɨ́vɨ kutɨ‑dé yúan, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Te ni̱ junu nchaa̱‑ya̱‑í. Te ni̱ xndée‑ya̱ ndá'a‑yá xini̱‑í jíná'an‑i. Te ni̱ jika̱n ta'u̱‑yá ja'a̱‑í. ");
INSERT INTO migNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yúan‑na te ni̱ ki'in‑ya̱ íchi kuá'a̱n‑ya̱. Te jínu ɨɨn cha̱a súchí ni̱ chaa̱‑de. Te ni̱ jukuiñi̱ jítɨ́‑de nuu̱‑yá. Te ni̱ jika̱ tu̱'ún‑de‑ya̱: Cha̱a va̱'a kúu‑ní Maestro. Ndasa sá'a‑ná te ni'i̱n tá'u̱‑ná kuchaku̱‑ná nɨ́ɨ́ káni, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Naja̱ ká'a̱n‑ro̱ cháa va̱'a jíín‑rí. Tú ni ɨɨn cha̱a va̱'a íó chi̱ máá ɨ́ɨn‑ni Dios. ");
INSERT INTO migNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A jiní‑ro̱ tú'un ni̱ tá'ú tíñu‑ya̱ núu̱‑ro̱: Ma̱ kúsɨ́kɨ ncháa̱ tá'an‑ró, ma̱ ká'ni‑ro ndɨ́yi, ma̱ sákuí'ná‑ró, ma̱ ká'a̱n‑ro̱ tú'un tú'ún, ma̱ kuánchaa̱‑ro̱ ndátíñu tá'an‑ró; kuandatu̱ nuu̱ táa̱‑ro̱ núu̱ náa̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Te máá‑de, ni̱ ka'a̱n‑de jíín‑yá: Ta̱ká tiñu yá'a a ni̱ skíkuu‑ná onde̱ ná lúlí‑ná, Maestro, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yúan‑na te ni̱ ndakoto Jesús nuu̱‑dé. Te ni̱ kumani̱‑yá jíín‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ɨɨn‑na̱ tiñu kúmani̱ sá'a‑ró núsáá. Kuá'án, te xi̱kó ndɨ́'ɨ‑ró já ñáva̱'a‑ró, te kua̱'a‑ró núu̱ ñáyɨvɨ ndá'ú. Te onde̱ andɨ́vɨ́ kóo yaji̱‑ro̱. Yúan‑na te kii‑ró, kundiki̱n‑ro̱ rúu̱ ki'o̱n, te kua̱ndéé iní‑ro̱ jíín túndó'o kii sɨkɨ̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Te máá cháa súchí‑ún, ni̱ kuxíí iní‑de ja̱ súan ni̱ ka'a̱n‑ya̱. Te ni̱ kee‑de kua'a̱n‑de. Te ndúkuí'a̱ ini̱‑de. Chi̱ kua'a̱ xáa̱n ndátíñu ñáva̱'a‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yúan‑na te Jesús, ni̱ ndakoto‑ya̱ nɨ́ɨ́ xíin‑yá. Te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a jíín‑yá: Xaa̱n ú'u̱ kɨ̱vɨ ɨɨn cha̱a kúká iní ñuu̱ nuu̱ tá'ú Dios tiñu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yúan‑na te cha̱a káskuá'a jíín‑yá, kánaa iní‑de kájini so̱'o‑de tu̱'un ni̱ ka'a̱n‑ya̱‑ún. Ko ni̱ ka'a̱n tuku Jesús jíín‑de: Hijo, cha̱a ja̱ xáa̱n káchiñú'ún‑de xu̱'ún, xaa̱n ú'u̱ kɨ̱vɨ‑de ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yachi̱‑ga̱ ja̱'a ɨɨn camello yau̱ yikɨ tɨ́kuɨ́, vásá ɨ́ɨn cha̱a ku̱ká kɨ́vɨ‑de ñuu̱ nuu̱ tá'ú Dios tiñu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Te máá‑de, ví'í‑gá kánaa iní‑de, kájani ini̱‑de: Ndé cha̱a ka̱ku núsáá. ");
INSERT INTO migNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yúan‑na te Jesús, ni̱ ndakoto‑ya̱ núu̱‑dé. Te ni̱ ka'a̱n‑ya̱: Jíín cháa ma̱ kúu kutɨ, ko tú súan kúu jíín Dios. Chi ta̱ká‑ni tiñu ndɨ'ɨ‑ni kúu sá'a Dios, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yúan‑na te Pedro, ni̱ ka'a̱n‑de jíín‑yá: Náá, ni̱ ka̱skéndo̱o‑ná ta̱ká ndatíñu‑ná. Te ni̱ kandiki̱n‑ná níí va̱i‑yó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Te ni̱ ka'a̱n Jesús: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Nú ɨɨn cha̱a ni̱ skéndo̱o‑de ve'e‑de, xí ñaní‑de, xí kuá'a‑de, xí táa̱‑de, xí náa̱‑de, xí ñásɨ́'ɨ́‑de, xí sé'e‑de, xí tá'u̱‑dé, ja̱ sɨkɨ́ rúu̱ jíín sɨkɨ́ tú'un va̱'a ká'a̱n‑ri̱, ");
INSERT INTO migNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","te nani'i̱n‑dé ɨɨn ciento vuelta vina kúu ve'e, kúu ñani̱, kúu kua̱'a, kúu náa̱, kúu se̱'e, kúu ta'u̱. Ko chindiki̱n‑i‑de. Ko onde̱ ɨnga̱ vida chaa̱, yúan‑na te kuchaku̱‑de nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Te kua'a̱ cháa kúnúú, nduu‑de sandɨ̱'ɨ́‑na̱. Te cha̱a sandɨ̱'ɨ́‑na̱, ndunúú‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Te ká'i̱in‑de ichi ní ka̱kaa‑de kája'a̱n‑de ñuu̱ Jerusalén. Te Jesús, yóxnúú‑yá nuu̱‑dé. Te ni̱ ka̱naa iní‑de kájini so̱'o‑de. Te ña̱yɨvɨ káindiki̱n‑ya̱‑ún káyu̱'ú‑i. Yúan‑na te ni̱ kana sɨ́ɨn tuku‑ya̱ xiní ndɨ́'uxí uu̱ cha̱a‑ún. Te ni̱ kastu̱'ún‑yá nuu̱‑dé ta̱ká tu̱'un kii sɨkɨ̱‑yá: ");
INSERT INTO migNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ná kuní‑ro̱: Kaa‑yó kí'i̱n‑yo̱ ñúu̱ Jerusalén. Te yúan natu̱u máá Sé'e cha̱a nuu̱ táká sutu̱ ñá'nu, jíín núu̱ cháa káchaa tutu̱. Te ndonda‑de sɨkɨ̱‑yá kuu̱‑ya̱. Te nachi'i‑de‑ya̱ ndá'a cháa sɨ́ɨn nación. ");
INSERT INTO migNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Te cha̱a‑ún, sákátá‑de nuu̱‑yá. Te kua̱'a‑de ta'u̱‑yá. Te tɨvɨ̱ sɨ̱'vɨ́‑de nuu̱‑yá. Te ka'ni‑dé‑ya̱. Ko nuu̱ uní kɨvɨ̱ te nachaku̱‑ya̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yúan‑na te Jacobo jíín Juan, se̱'e Zebedeo, ni̱ ja̱koyo‑de nuu̱‑yá. Te ni̱ kaka'a̱n‑de jíín‑yá: Maestro, kákuni̱‑ná ja̱ sá'a‑ní ɨɨn ja̱ kakán‑ná nuu̱‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Te máá‑yá, ni̱ ka'a̱n‑ya̱ jíín‑de: Ndasa kákuni̱‑ro̱ já sá'a‑ri̱ jíín‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Te ni̱ kaka'a̱n‑de jíín‑yá: Kua̱'a‑ní xiin‑ní kuxiu̱kú‑ná jíín‑ní, ɨɨn‑ná ichi ndává'a‑ní, te ɨnga̱‑ná ichi ndávésé‑ní, kɨvɨ̱ ndúñá'nu‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yúan‑na te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Tú kájini̱‑ro̱ na̱ún kúu ja̱ kájika̱n‑ro̱. Á kuu ndo'o ta'a̱n‑ro̱ jíín‑rí jíín túndó'o kii sɨkɨ̱‑rí, xí kúu kuanducha‑ro núu̱ ní janducha‑rí, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Te máá‑de, ni̱ kaka'a̱n‑de: Kuu sá'a‑ná, áchí‑de. Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Ja̱ndáa̱, ja̱ ndó'o ta'a̱n‑ro̱ jíín‑rí jíín túndó'o kii sɨkɨ̱‑rí, te nuu̱ ní janducha‑rí, kuanducha‑ro, ");
INSERT INTO migNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ko ja̱ kúxiu̱kú‑ró íchi ndává'a‑ri̱ jíín íchi ndávésé‑rí, nasu̱ máá‑rí tá'ú tíñu ja̱ kuá'a‑ri̱ nuu̱‑ro̱, chi̱ íó tu̱'a ja̱ kúu ɨɨn cha̱a, te cha̱a‑ún ni'i̱n, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Te uxi̱‑ga̱ cha̱a‑ún, ni̱ ka̱jini so̱'o‑de tu̱'un yá'a. Te ni̱ kakiti̱ ini̱‑de nuu̱ Jacobo jíín núu̱ Juan. ");
INSERT INTO migNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Te Jesús, ni̱ kana‑ya̱ xiní‑dé. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kájini̱‑ro̱ já táká cha̱a kájito‑de nátu̱'un cha̱a kákuñá'nu nuu̱ ñáyɨvɨ, te kátá'ú téyíí‑de tiñu nuu̱‑í. Te ja̱ kákuñá'nu sɨkɨ̱ máá‑de, suni kátɨ̱ɨn ni̱'in so̱'o‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ko sɨkɨ̱ róó jíná'an‑ró, na̱ tú súan koo: Chi̱ nú ndé róó kuní kuñá'nu nuu̱ tá'an‑ró, te róó kúu ja̱ kuátíñu nuu̱ tá'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Te nú ndé róó kuní kunúú, yu̱án ndúu mozo nuu̱ táká‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Chi̱ máá Sé'e cha̱a na̱ tú va̱i‑ya̱ já kuátíñu ña̱yɨvɨ núu̱‑yá, chi̱ sua játíñu‑ya̱ núu̱ ñáyɨvɨ te kua̱'a‑ya̱ máá‑yá kuu̱‑ya̱ já nákuaan‑ya̱ kuá'a̱ ñáyɨvɨ, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yúan‑na te ni̱ ja̱koyo‑ya̱ ñúu̱ Jericó. Te yúan ni̱ ndenda‑ya̱ jíín cháa káskuá'a jíín‑yá jíín ñáyɨvɨ kuá'a̱ xáa̱n. Te Bartimeo cha̱a kuáá, se̱'e Timeo, kánchaa̱‑de yu'íchi, jikán‑de caridad. ");
INSERT INTO migNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Te ni̱ jini tu̱'un‑de ja̱ Jesús ñuu̱ Nazaret kúu‑ya̱. Te ni̱ kejá'á‑de kána kó'ó‑de: Jesús, Se̱'e David, kundá'ú ini̱‑ní náá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Te kua'a̱‑í, ni̱ kaka'a̱n xaa̱n‑í nuu̱‑dé, ja̱ ná kasú‑de yu'u‑dé. Ko máá‑de, ví'í‑gá ni̱ kana kó'ó‑de: Táta̱ Se̱'e David, kundá'ú ini̱‑ní náá vii̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yúan‑na te Jesús, ni̱ jukuiñi̱‑ya̱. Te ni̱ ka'a̱n‑ya̱: Kana xini̱‑dé ná kíi‑de, áchí‑ya̱. Te ni̱ ka̱kana‑i cha̱a kuáá‑ún: Ma̱ ndúkuí'a̱ ini̱‑ro̱. Ndukuiñi̱ ná chó'o̱, chi̱ kána‑ya̱ róó, áchí‑i jíín cháa‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yúan‑na te máá cháa‑ún, ni̱ skána‑de tɨka̱chí‑de. Te ni̱ ndukuiñi̱‑de. Te ni̱ jaa̱‑de nuu̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Na̱ún sá'a‑ri̱ jíín‑ró kuní‑ro̱, áchí‑ya̱. Te cha̱a kuáá‑ún, ni̱ ka'a̱n‑de jíín‑yá: Maestro, ja̱ ná ndúndiji̱n nduchi‑ná kuní‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Kuá'án núsáá. Ja̱ kándíja‑ró ní nama róó, áchí‑ya̱. Te ni̱ ndundiji̱n‑ni nduchi‑dé. Te ni̱ ndiki̱n‑de Jesús kua'a̱n‑de ichi‑ún jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Te ni̱ ka̱kuyani‑ya̱ ñúu̱ Jerusalén, ñuu̱ Betfagé, jíín ñúu̱ Betania, chi̱i yuku Olivos. Te ni̱ tájí‑yá uu̱ cha̱a káskuá'a jíín‑yá kua'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Te ká'a̱n‑ya̱ jíín‑de: Kuá'án ñuu̱ kánchaa̱ nuu̱‑ro̱ jián. Te nuu̱ kɨ́vɨ‑ni‑ró yúan, te ni'i̱n‑ro̱ ɨ́ɨn burro nú'ni̱‑tɨ̱, ja̱ ní ɨɨn cha̱a té koso‑gá‑de‑tɨ̱. Te ndájí‑ró‑tɨ́, te kii‑ró jíín‑tɨ́. ");
INSERT INTO migNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te nú ndé cha̱a ká'a̱n jíín‑ró: Naja̱ sá'a‑ró súan, achi̱‑de. Te kachi̱‑ro̱ kúni‑de: Máá Jíto'o̱‑yo̱ jínu ñú'ún‑yá‑tɨ̱, achi̱‑ro̱. Yúan‑na te tájí‑ni‑de‑tɨ̱ kíi‑ró jíín‑tɨ́, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Te ni̱ kaja'a̱n‑de. Te ni̱ kani'i̱n‑dé burro‑ún nú'ni̱‑tɨ̱ yúxé'é íchi yatá ké'e, nuu̱ náketá'an uu̱ ichi. Te ni̱ ka̱ndájí‑de‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Te sava ja̱ ká'i̱in yúan, ni̱ kaka'a̱n jíín‑de: Na̱ún kásá'a‑ró sá burro jia̱n kándájí‑ró, áchí. ");
INSERT INTO migNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yúan‑na te máá‑de, ni̱ kaka'a̱n‑de jíín‑ún, nátu̱'un ni̱ tá'ú Jesús tiñu nuu̱‑dé. Te vásá ní ka̱sía̱‑ún‑de va̱i‑de. ");
INSERT INTO migNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Te ni̱ chaa̱‑de jíín burro‑ún nuu̱ Jesús. Te ni̱ ka̱xndée‑de tɨka̱chí‑de sɨkɨ̱‑tɨ́. Te ni̱ jukoso̱‑yá‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Te kua'a̱‑dé, ni̱ kajaki̱n‑de tɨka̱chí‑de ini̱ ichi, te sava‑ga̱‑de, ni̱ kaja'nu̱‑de numa yúnu. Te ni̱ kajaki̱n‑de ini̱ ichi‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Te ña̱yɨvɨ kája'a̱n ichi núu̱‑yá, jíín ñáyɨvɨ kándiki̱n ichi yatá‑yá, káka'a̱n jaa‑i: Xáán va̱'a I'a̱ kúu‑ya̱. Ná nákana jaa‑yó‑yá, chi̱ ndíso‑ya̱ tíñu máá Tatá Dios. ");
INSERT INTO migNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Te kákusɨɨ̱ iní‑yo̱, chi̱ táa̱‑yo̱ David, a yani tá'ú‑de tiñu nuu̱‑yo̱. Xáán va̱'a I'a̱ kúu‑ya̱ ondé andɨ́vɨ́, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Te ni̱ kɨ̱vɨ Jesús ini̱ ñuu̱ Jerusalén, jíín iní ve̱'e ii̱. Te ni̱ ndakoto‑ya̱ núu̱ táká ndatíñu íin nɨ́ɨ́ yúan. Te nuu̱ ní ini, te ni̱ kenda‑ya̱ kuá'a̱n‑ya̱ ñúu̱ Betania jíín máá uxí uu̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Te kɨvɨ̱ xía̱n‑ún, ni̱ ka̱kenda‑ya̱ kuá'a̱n‑ya̱ iní ñuu̱ Betania. Te ni̱ chaa̱ so̱ko chi̱i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Te onde̱ jíká ní jini̱‑ya̱ ɨ́ɨn mérkexe̱ ja̱ íó numa ndá'a. Te ni̱ kandita‑ya̱ kuá'a̱n‑ya̱, jáni ini̱‑ya̱ já ní'i̱n‑yá ja̱ kée‑yá núú. Te nuu̱ ní jaa̱‑ya̱ núu̱ mérkexe̱‑ún, tú kutɨ na̱ún ní ní'i̱n‑yá, chi̱ máá núma‑ní íó. Chi̱ nasu̱ kɨvɨ́ kúun nde'e̱ kúu. ");
INSERT INTO migNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yúan‑na te Jesús, ni̱ ka'a̱n‑ya̱: Ni ɨɨn tuká na̱ún kée kútɨ ndé'e̱ xiní‑ro̱ nɨ́ɨ́ káni, áchí‑ya̱ jíín mérkexe̱‑ún. Te cha̱a káskuá'a jíín‑yá, ni̱ ka̱jini so̱'o‑de ja̱ súan ni̱ ka'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Te ni̱ ja̱koyo‑ya̱ ñúu̱ Jerusalén. Te ni̱ kɨ̱vɨ Jesús ini̱ ve̱'e ii̱. Te ni̱ kiñi'in‑ya̱ ñáyɨvɨ kájaan káxi̱kó íin‑i ini̱ ve̱'e ii̱‑ún kája'a̱n‑i. Te ni̱ skuíó káni‑ya̱ mesa cha̱a káxndái xu̱'ún, jíín silla cha̱a káxi̱kó paloma. ");
INSERT INTO migNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Te tú ní já'a‑ya̱ tú'un ja̱'a ni ɨɨn‑i jíín kɨ́yi ini̱ ve̱'e ii̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Te ni̱ stá'a̱n‑ya̱ tú'un nuu̱‑í: Á tú yóso núu̱ tutú ja̱ vé'e‑ri̱, ve'e nuu̱ kájika̱n ta'u̱ táká ña̱yɨvɨ nání. Ko máá‑ró, a ni̱ ka̱nasá'a‑ró yaú kava ñákui̱'ná, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Te cha̱a káchaa tutu̱ jíín sutú ñá'nu, ni̱ ka̱jini so̱'o‑de tu̱'un‑ún. Te kándúkú‑de modo ndasa ka'ni‑dé‑ya̱. Ko káyu̱'ú‑de‑ya̱, chi ta̱ká ña̱yɨvɨ kánaa iní‑i kájini so̱'o‑i tu̱'un stá'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Te nuu̱ kuá'ini, te ni̱ kenda Jesús ini̱ ñuu̱‑ún, kua'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Te ja̱ñá'a̱n ɨnga̱ kɨvɨ̱, ni̱ kana̱ja̱'a‑ya̱ kuá'a̱n‑ya̱. Te ni̱ kajini̱‑ya̱ mérkexe̱‑ún ja̱ á ni̱ ichi̱ onde̱ yo'o. ");
INSERT INTO migNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yúan‑na te ni̱ nuku̱'un ini̱ Pedro. Te ni̱ ka'a̱n‑de jíín‑yá: Maestro, nde̱'é‑ní mérkexe̱‑ún ja̱ ní ka'a̱n ndɨva̱'a‑ní jíín. Te vina a ni̱ ichi̱ ii̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Kandíja nuu̱ Dios, ");
INSERT INTO migNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","chi ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Nú ndé cha̱a ka'a̱n‑de jíín yúku yá'a: Kuxio, te jungo̱o‑ró ondé nuu̱ mar, te nú tú kani sɨ̱kɨ́ ini̱‑de, chi̱ sua kándíja‑de ja̱ súan kuu ja̱ ní ka'a̱n‑de‑ún, te ja̱ ní jika̱n‑de‑ún, ni'i̱n‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ja̱ yúán ká'a̱n‑ri̱ jíín‑ró: Ta̱ká ja̱ jikán‑ro̱, te kaka̱n ta'u̱‑ro̱ jíín, te ná kándíja‑ró já ní'i̱n‑ro̱, te ni'i̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Te nú kájika̱n ta'u̱‑ro̱, te kuña ká'nu ini̱‑ro̱ núu̱ ndé ɨɨn cha̱a jíto u'u̱ róó, náva̱'a máá Táa̱‑ro̱ kánchaa̱‑ya̱ ondé andɨ́vɨ́, suni kuña ká'nu ini̱‑ya̱ núu̱ kuáchi‑ró. ");
INSERT INTO migNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Chi̱ nú tú kuña ká'nu ini̱‑ro̱, suni súan máá Táa̱‑ro̱ kánchaa̱‑ya̱ ondé andɨ́vɨ́, ma̱ kúña ká'nu ini̱‑ya̱ núu̱ kuáchi‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Te ni̱ naja̱koyo tuku‑ya̱ ñúu̱ Jerusalén. Te jíka kuu‑ya̱ iní ve̱'e ii̱. Te sutu̱ ñá'nu, jíín cháa káchaa tutu̱, jíín cháa ni̱ ka̱yii, ni̱ cha̱koyo‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Te ni̱ kaka'a̱n‑de jíín‑yá: Na̱ jíín tú'un sá'a‑ró tíñu yá'a. Te ndéja̱ ní ka'a̱n jíín‑ró sá'a‑ró tíñu yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Ná kaká tu̱'ún‑rí róó ɨɨn tu̱'un, te kachi̱‑ro̱ núu̱‑rí. Yúan‑na te ná kachí‑ri̱ nuu̱‑ro̱ na̱ jíín tú'un sá'a‑ri̱ tiñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ja̱ ní skuánducha Juan sáá, á onde̱ andɨ́vɨ́ ní kii tu̱'un, xí cháa ni̱ tá'ú tíñu. Kastu̱'ún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yúan‑na te ni̱ kanda̱tu̱'ún máá‑de: Nú ka'a̱n‑yo̱: Ja̱ ondé andɨ́vɨ́. Te kachi̱‑de kuni‑yó: Naja̱ tú ní kákandíja‑ró núu̱‑dé núsáá. ");
INSERT INTO migNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te nú ka'a̱n‑yo̱ já cháa ni̱ tá'ú tíñu. Te káyu̱'ú‑yo̱ ñáyɨvɨ, chi̱ ndivii‑í kájani ndaa̱ ini̱‑i ja̱ cháa ni̱ jani tu̱'un Dios ni̱ kuu Juan, áchí‑de jíín tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ja̱ yúán ní kaka'a̱n‑de: Tú kájini̱‑ri̱, áchí‑de jíín Jesús. Yúan‑na te ni̱ ka'a̱n Jesús: Suni ruu̱, tú kachi̱‑ri̱ nuu̱‑ro̱ na̱ jíín tú'un sá'a‑ri̱ tiñu yá'a núsáá, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Te ni̱ kejá'á‑yá ni̱ ka'a̱n‑ya̱ tú'un yátá jíín‑de jíná'an‑de: Ɨɨn cha̱a, ni̱ nachu'un‑de ɨɨn itu̱ uva. Te ni̱ jasu̱‑de ja̱kú. Te ni̱ jacha‑de ɨɨn yau̱ nuu̱ kaxín‑de. Te ni̱ ndukani‑de ɨɨn torre. Te ni̱ xndóo‑de nuu̱ cháa kásátiñu jíín. Te ni̱ kee‑de kua'a̱n jíká‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Te ɨɨn kɨvɨ̱ te ni̱ tájí‑de ɨɨn mozo‑de va̱i nuu̱ já kásátiñu jíín uva‑ún, ja̱ vái naki'in‑de nde'e̱ itú uva nuu̱ já ní ka̱sátiñu‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ko máá‑ún, ni̱ ka̱katɨɨn‑ún mozo‑de. Te ni̱ ka̱stují‑dé. Te ni̱ ka̱kiñi'in‑ún‑de. kua̱no'on sáni‑ni‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Te máá jíto'o̱, ni̱ na̱tájí tuku‑de ɨnga̱ mozo‑de va̱i nuu̱ já kásátiñu‑ún. Te ni̱ ka̱stují‑ún xiní mozo‑de. Te ni̱ ka̱sákátá nuu̱‑dé. Te ni̱ ka̱kiñi'in‑ún‑de kua̱no'on‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Te máá jíto'o̱ uva, ni̱ na̱tájí tuku‑de ɨnga̱ cha̱a va̱i. Te ni̱ ka̱ja'ni‑ún‑de jíín kuá'a̱‑gá‑de. Te sava‑de ni̱ ka̱stují. Te sava‑de ni̱ ka̱ja'ni. ");
INSERT INTO migNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ko máá jíto'o̱, íó ɨɨn se̱'e‑de ja̱ kúndá'ú ini̱‑de. Te onde̱ sandɨ̱'ɨ́‑na̱ ni̱ tájí‑de se̱'e‑de va̱i nuu̱ cháa kásátiñu. Te ni̱ ka'a̱n‑de: Ná kóo jíñú'ún yúán núu̱ sé'e‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ko máá já kásátiñu‑ún, ni̱ kanda̱tu̱'ún: Cha̱a yá'a xíin tá'u̱. Ná chó'o̱, ná ká'ni‑yo‑dé, te ná ndóo ta'u̱‑dé kuu‑yó, áchí. ");
INSERT INTO migNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Te ni̱ ka̱katɨɨn‑ún sé'e‑de. Te ni̱ ka̱ja'ni‑ún‑i. Te ni̱ ka̱skána ndɨ̱yi‑ún yatá itú uva. ");
INSERT INTO migNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ndasa sá'a jito'o̱ itu̱ uva‑ún núsáá. Chaa̱‑de, te xnáa‑dé ja̱ ní ka̱sátiñu‑ún. Te kua̱'a‑de itu̱ uva‑ún nuu̱ sáva‑ga̱ cha̱a, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ni tutu̱ ii̱ yá'a té ka'u‑ga̱‑ro̱ náún. Yuu̱ já ní ka̱ské'ichi̱ cha̱a káchutá'an, ya̱'á kúu máá yúu̱ ndíso fuerza jiki̱. ");
INSERT INTO migNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Máá Tatá Dios, ni̱ sá'a‑ya̱ súan. Te kánaa iní‑yo̱ ndé'é‑yó tíñu yá'a, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Te kándúkú‑de modo tɨɨn‑de‑ya̱. Chi ni̱ kaju̱ku̱'un ini̱‑de ja̱ sɨkɨ́ máá‑de kúu tu̱'un yátá ní ka'a̱n‑ya̱‑ún. Ko ni̱ kayu̱'ú‑de ni̱ ka̱jito‑de ña̱yɨvɨ. Te ni̱ ka̱xndóo‑de‑ya̱, te kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Te ni̱ ka̱tájí‑de sava cha̱a fariseo jíín cha̱a herodiano kája'a̱n‑de nuu̱‑yá, náva̱'a tɨɨn yátá‑de‑ya̱ jíín yakú tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Te ni̱ cha̱koyo‑de. Te ni̱ kaka'a̱n‑de jíín‑yá: Maestro, kájini̱‑ná ja̱ ká'a̱n ndaa̱‑ní. Te tú yú'ú‑ní jito‑ní ni ɨɨn cha̱a, chi̱ tú ndé'é‑ní ndasa jíto ta̱ká cha̱a, chi̱ sua stá'a̱n ndaa̱‑ní ichi Dios. Á kuu kua̱'a‑yó xú'ún yóo̱ nuu̱ César, xí túu. Á kua̱'a‑yó, xí ma̱ kuá'a‑yó, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yúan‑na te máá‑yá, a ni̱ juku̱'un ini̱‑ya̱ já xndá'ú‑de‑ya̱ kákuni̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Naja̱ kájito nchaa̱‑ro̱ rúu̱. Kua̱'a xu̱'ún jián ná kíi nde̱'é‑rí, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Te máá‑de, ni̱ kaja̱'a‑de xu̱'ún‑ún nuu̱‑yá. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ndé cha̱a kúu cha̱a ncháá nuu̱ yá'a, jíín tú'un yóso yá'a, áchí‑ya̱. Te ni̱ kaka'a̱n‑de jíín‑yá: César kúu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Kua̱'a ja̱ xíin César nuu̱ César, te ja̱ xíin Dios nuu̱ Dios, áchí‑ya̱. Te ni̱ ka̱naa xáa̱n iní‑de ni̱ ka̱jini so̱'o‑de tu̱'un ni̱ ka'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yúan‑na te ni̱ cha̱koyo cha̱a saduceo nuu̱‑yá. Te cha̱a‑ún, káka'a̱n‑de ja̱ tú nachaku̱ kutɨ ndɨ́yi. Te ni̱ kajika̱ tu̱'ún‑de‑ya̱: ");
INSERT INTO migNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Maestro. Moisés, ni̱ chaa‑de tutu̱ ni̱ ndo̱o jíín‑yó, nú ñani̱ ɨɨn cha̱a kuu̱‑de, te ndo̱o ñasɨ́'ɨ́‑de, te nú tú se̱'e‑de ní íó, te ñani̱‑de naki'in ñasɨ́'ɨ́‑de, te nandaki̱n‑de tata̱ ñani̱‑de, áchí tutu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Te ni̱ ka'i̱o usia̱ ñani̱. Te cha̱a núú, ni̱ ta̱nda'a‑dé. Yúan‑na te ni̱ ji'i̱‑de. Te tú ní xndóo‑de tata̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Te cha̱a uu̱, ni̱ naki'in‑de‑ña. Te ni̱ ji'i̱‑de. Te ni cha̱a‑ún, tú ní xndóo‑de tata̱‑de. Te cha̱a uni̱, suni súan. ");
INSERT INTO migNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Te ndɨ́'usiá‑de, ni̱ kancha̱ka‑de‑ña. Te tú ni ɨɨn‑de ní xndóo‑de tata̱. Te onde̱ sandɨ̱'ɨ́‑na̱ te ni̱ ji'i̱ máá ñá'an‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Núsáá te kɨvɨ̱ náchaku̱ ta̱ká ndɨ̱yi, ja̱ náchaku̱ máá ñaní jíná'an‑de, te ndé ɨɨn‑de kuu‑ña ñásɨ́'ɨ́‑de, chi̱ ndɨ́'usiá‑de, ni̱ kancha̱ka‑de‑ña, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yúan‑na te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Tú kájuku̱'un ini̱‑ro̱ jíín tutú ii̱, ni jíín fuerza Dios. Yu̱án ní ka̱stɨ́vɨ́‑ró tú'un. ");
INSERT INTO migNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chi̱ kɨvɨ̱ náchaku̱‑de ma̱'ñú ndɨ́yi, ni tuká ta̱nda'a kútɨ‑dé, ni ma̱ náta̱nda'a máá‑ña. Chi̱ nduu‑de nátu̱'un ndajá'a̱ ká'i̱o andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Te sɨkɨ̱ ndɨ́yi ja̱ náchaku̱, á té ka'u‑ga̱‑ro̱ tutú Moisés, ndasa ni̱ ka'a̱n Dios jíín‑de ma̱'ñú yukú: Máá‑rí kúu Dios Abraham, Dios Isaac, Dios Jacob, áchí‑ya̱ jíín Moisés. ");
INSERT INTO migNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ko nasu̱ Dios cha̱a ni̱ kaji'i̱ kúu‑ya̱, chi̱ sua Dios cha̱a káichaku̱ kúu‑ya̱. Xaa̱n kástɨ́vɨ́‑ró tú'un núsáá, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Te ɨɨn cha̱a cháa tutu̱ ni̱ jini so̱'o‑de kástátá'an‑de, ni̱ jaa̱‑de. Te ni̱ jini̱‑de ja̱ vá'a ni̱ nachísó‑yá tu̱'un nuu̱‑dé. Te ni̱ jika̱ tu̱'ún‑de‑ya̱: Ndé tu̱'un kánúú xáa̱n‑gá nuu̱ táká tu̱'un ni̱ tá'ú‑yá tiñu sáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Te ni̱ ka'a̱n Jesús jíín‑de: Ya̱'á kúu tu̱'un kánúú xáa̱n‑gá nuu̱ táká‑ga̱: Kuni so̱'o Israel, máá Tatá‑yo̱ Dios, máá ɨ́ɨn‑ni‑ya̱ íó. ");
INSERT INTO migNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Núsáá te kumani̱‑ro̱ jíín máá Tatá‑ro̱ Dios onde̱ jíín iní jíín añú‑ro̱, jíín nɨ́ɨ́ núu̱ jiní tuní‑ro̱, jíín nɨ́ɨ́ fuerza‑ro̱. Ya̱'á kúu tu̱'un tá'ú tíñu kánúú xáa̱n‑gá. ");
INSERT INTO migNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Te tu̱'un uu̱ kúu suni nátu̱'un ɨnga̱‑ún: Kundá'ú ini̱‑ro̱ tá'an‑ró nátu̱'un kúndá'ú ini̱‑ro̱ máá‑ró. Tuká ɨnga̱ tu̱'un tá'ú tíñu kánúú‑ga̱ íó, chi ya̱'á‑na̱, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yúan‑na te cha̱a cháa tutu̱, ni̱ ka'a̱n‑de jíín‑yá: Ja̱ndáa̱ Maestro, va̱'a ká'a̱n‑ní, chi̱ Dios ɨɨn‑ni‑ya̱ íó, te tuká ɨnga̱ Dios íó. ");
INSERT INTO migNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Te kumani̱‑yo̱ jíín‑yá onde̱ jíín iní jíín añú‑yo̱, jíín nɨ́ɨ́ núu̱ jiní tuní‑yo̱, jíín nɨ́ɨ́ fuerza‑yo̱, te kundá'ú ini̱‑yo̱ tá'an‑yó nátu̱'un kúndá'ú ini̱‑yo̱ máá‑yó, kánúú xáa̱n‑gá ya̱'á vásá já ká'mu‑yó kɨ́tɨ jíín táká kɨtɨ ká'ni‑yo núu̱‑yá, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yúan‑na te ni̱ jini̱ Jesús ja̱ vá'a xaa̱n ní xndíó káni‑de tu̱'un. Te ni̱ ka'a̱n‑ya̱ jíín‑de: A yani kuu kɨ̱vɨ‑ró ñúu̱ nuu̱ tá'ú Dios tiñu, áchí‑ya̱. Te ni ɨɨn‑de, tuká ní chúndéé iní‑de kaka̱ tu̱'ún‑de‑ya̱: ");
INSERT INTO migNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Te ni̱ stá'a̱n Jesús ini̱ ve̱'e ii̱. Te ni̱ ka'a̱n‑ya̱: Naja̱ káka'a̱n cha̱a káchaa tutu̱ ja̱ Cristo kúu Se̱'e David. ");
INSERT INTO migNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Chi̱ suni máá David, ni̱ ka'a̱n‑de ni̱ sá'a Espíritu Santo jíín‑de: Máá Tatá Dios ni̱ ka'a̱n‑ya̱ jíín Jíto'o̱‑ri̱: Nungo̱o‑ró íchi ndává'a‑ri̱, te ná chúkú‑rí cha̱a kájito u'u̱ róó, kuu‑de teyu̱ kuxndíi ja'a̱‑ro̱, áchí Dios. Achí David. ");
INSERT INTO migNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Chi̱ suni máá David, Jito'o̱, ni̱ ka'a̱n‑de jíín‑yá. Te ndasa kuu máá‑yá se̱'e‑de núsáá, áchí‑ya̱. Te ta̱ká ña̱yɨvɨ ndá'ú, ni̱ ka'i̱o ini̱ ni̱ ka'i̱o añú‑i ni̱ ka̱jini ná'ín‑i ja̱ ká'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Te ni̱ stá'a̱n‑ya̱ tú'un. Te ni̱ ka'a̱n‑ya̱ jíín‑i: Koto‑ró máá‑ró núu̱ cháa káchaa tutu̱. Chi̱ kákuni̱‑de kaka‑de jíín sú'nu̱ káni. Te kákuni̱‑de ja̱ ká'a̱n sa̱'án‑yo̱ jíín‑de nu̱yá'u. ");
INSERT INTO migNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Te silla onde̱ xini̱ mesa ini̱ ve̱'e sinagoga, jíín silla xini̱ mesa nuu̱ íó xíni kákuni̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Te cha̱a yá'a kákókó‑de ve'e ña'an kéndo̱o ndá'ú, te kásá'a‑de ja̱ túu kua̱chi‑de, yu̱án kájika̱n ta'u̱ ná'án‑de. Cha̱a yá'a ví'í‑gá ta'nu̱ ndatu̱‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Te kánchaa̱ Jesús ichi núu̱ janú nuu̱ kásoko̱‑í xu̱'ún. Te ndé'é‑yá ndasa káchu'un kua'a̱ ñáyɨvɨ xú'ún iní janu̱‑ún. Te kua'a̱ cháa kúká, ni̱ ka̱chu'un téyíí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Te ni̱ chaa̱ ɨɨn ña'an ní kendo̱o ndá'ú. Te ni̱ chindee‑ña úu̱ xu̱'ún yɨ́kɨ́ náa, ja̱ kúu ɨɨn centavo. ");
INSERT INTO migNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yúan‑na te ni̱ kana‑ya̱ xiní cháa káskuá'a jíín‑yá. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ ñá'an ní kendo̱o ndá'ú yá'a, ni̱ chu'un‑ga̱‑ña vásá táká ña̱yɨvɨ ní ka̱chu'un ini̱ janu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chi ta̱ká‑i, ni̱ ka̱chu'un‑i ja̱ ní ndendoso sɨkɨ́‑í. Ko ña'an yá'a, va̱sa kúndá'ú‑ña, ko ni̱ chu'un ndɨ'ɨ‑ña já ñáva̱'a‑ña, onde̱ jíín táká ja̱ kúchaku̱‑ña, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Te ni̱ ndenda‑ya̱ iní ve̱'e ii̱. Te ɨɨn cha̱a skuá'a jíín‑yá, ni̱ ka'a̱n‑de jíín‑yá: Maestro, nde̱'é‑ní ná xaa̱n lúu yuu̱ te luu ve'e íó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Á ndé'é‑ró núu̱ táká ve'e ná'nu yá'a. Ma̱ kútá'an‑ga̱ ni ɨɨn yuu̱, chi̱ ɨɨn kɨvɨ̱ te ndɨ'ɨ ndua̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Te ni̱ jungo̱o‑ya̱ ondé yuku Olivos, ichi núu̱ vé'e ii̱. Te Pedro, Jacobo, Juan, jíín Andrés, ni̱ kajika̱ tu̱'ún sɨ́ɨn‑de‑ya̱: ");
INSERT INTO migNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Kastu̱'ún‑ní nuu̱‑ná. Ndé kɨvɨ̱ kóo ta̱ká tiñu yá'a. Te na̱ún tuni̱ koo nuu̱ kúyani chaa̱ ta̱ká tiñu yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Te Jesús, ni̱ kejá'á‑yá ká'a̱n‑ya̱ jíín‑de: Koto‑ró máá‑ró jíná'an‑ró, náva̱'a tú xndá'ú ni ɨɨn‑de róó. ");
INSERT INTO migNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Chi̱ kikoyo kua'a̱ cháa ki'in núu‑de sɨ́'vɨ́‑rí, te ka'a̱n‑de: Máá‑rí kúu Cristo, achi̱‑de. Te xndá'ú‑de kua'a̱ xáa̱n ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Te nú ni̱ ka̱jini tu̱'un‑ró káka'a̱n ja̱ íó guerra xí já kóo guerra, te ma̱ yú'ú‑ro̱. Chi̱ kánúú kóo súan. Ko té ji̱nu‑ga̱ kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chi̱ ndonda nación sɨkɨ̱ nación, te ñuu̱ sɨkɨ̱ ñúu̱. Te yá'a yúan ta̱an, te nɨ̱'ɨn, te koo tama̱, te nɨ̱'ɨn ña̱yɨvɨ. Ya̱'á kákuu tu̱ndó'o kéjá'á núú. ");
INSERT INTO migNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Te koto‑ró máá‑ró, chi̱ nastúu‑de róó nuu̱ junta. Te ini̱ ve̱'e sinagoga xndó'o‑de róó. Te onde̱ nuu̱ gobernador jíín núu̱ rey kana‑de xini̱‑ro̱ já sɨkɨ́ rúu̱. Te kani ndaa̱‑ro̱ tú'un nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Te jínu ñú'ún já xná'a̱n‑ga̱ kuicha̱ tu̱'un va̱'a‑ri̱ nuu̱ táká ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Te nú kincha̱ka‑de róó, ja̱ nástúu‑de róó, ma̱ nákani tu̱'a ini̱‑ro̱ ndasa ka'a̱n‑ro̱ jíín‑de. Chi ja̱ kuá'a‑ya̱ núu̱‑ro̱ hora jia̱n, yu̱án ká'a̱n‑ro̱. Chi̱ nasu̱ máá‑ró ká'a̱n, chi̱ Espíritu Santo ka'a̱n, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Te ñani̱ jíín ñaní nastúu tá'an ja̱ ná kúu̱. Te táa̱ jíín sé'e, te se̱'e‑ún ndonda sɨkɨ̱ táa̱, te ka'ni tá'an. ");
INSERT INTO migNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Te ta̱ká ña̱yɨvɨ, koto u'u̱‑i róó ja̱ sɨkɨ́ rúu̱. Ko cha̱a kundii̱ ni̱'in onde̱ kɨvɨ̱ jínu, cha̱a‑ún ka̱ku, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ko nú ni̱ kajini̱‑ro̱ já káchá'án te ni̱ tucha̱ ta̱ká ndatíñu nuu̱ má kúu kutɨ kóo súan núú, nátu̱'un ni̱ ka'a̱n Daniel cha̱a ni̱ jani tu̱'un Dios (cha̱a ká'u, ná júku̱'un ini̱‑de), yúan‑na te ña̱yɨvɨ káxiu̱kú iní ñuu̱ Judea, ná kúnu‑i ki̱ngoyo‑i onde̱ yuku. ");
INSERT INTO migNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Te cha̱a kándee xini̱ vé'e, ma̱ núu‑de ndɨ̱vɨ‑de ini̱ ve̱'e ki'in‑de ndatíñu‑de. ");
INSERT INTO migNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Te cha̱a kándee onde̱ rancho, ma̱ náxíó káva yátá‑de náki'in‑de tɨka̱chí‑de ichi yatá‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ko kɨvɨ̱‑ún naka̱ ndá'ú kuu ja̱ káñu̱'un se̱'e, jíín já káskáxin‑í. ");
INSERT INTO migNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ná kakán ta'u̱‑ro̱ núsáá, náva̱'a tú kunu‑ró máá víko víjin ki'i̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chi̱ kɨvɨ̱‑ún koo tu̱ndó'o, ja̱ té tuká koo onde̱ kɨvɨ̱ ní sá'a Dios ñu̱yɨ́vɨ, te onde̱ vina, te ni ma̱ kóo‑ga̱. ");
INSERT INTO migNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Te nú máá Tatá Dios, tú ní náxndɨ́yi‑ya̱ kɨvɨ́‑ún núú, ni ɨɨn cha̱a ma̱ káku kutɨ‑dé núú. Ko ja̱ sɨkɨ́ cháa ni̱ naka̱ji‑ya̱, yu̱án ní na̱xndɨ́yi‑ya̱ kɨvɨ́‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Núsáá te nú ndé cha̱a ká'a̱n jíín‑ró: Yá'a nde̱'é‑ró kánchaa̱ Cristo, xí: Yúan nde̱'é‑ró kánchaa̱‑ya̱, ma̱ kándíja‑ró já ká'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chi̱ kenda Cristo xndá'ú, jíín cháa kani tu̱'un tú'ún. Te sá'a‑de tuni̱ tiñu ñá'nu xaa̱n, náva̱'a xndá'ú‑de onde̱ cha̱a ni̱ naka̱ji‑ya̱, te nú ná kúu sá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Koto‑ró máá‑ró, chi̱ a ni̱ kachi̱ ndɨ'ɨ‑ri̱ nuu̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Te kɨvɨ̱ ndɨ́'ɨ koo tu̱ndó'o‑ún, kutúún ndika̱ndii, te yoo̱ ma̱ ndíi‑gá. ");
INSERT INTO migNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Te tiñu̱ú xíní, jungoyo‑tɨ̱ íchi ándɨ́vɨ́ kíi‑tɨ̱. Te ta̱ká fuerza andɨ́vɨ́, ndɨ'ɨ ka'ya. ");
INSERT INTO migNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yúan‑na te kuni̱ ña̱yɨvɨ núu̱ máá Sé'e cha̱a kii‑ya̱ íchi ándɨ́vɨ́ núu̱ vikó nu̱'ún jíín kuá'a̱ fuerza ja̱ ndúñá'nu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yúan‑na te tájí‑yá ndajá'a̱‑yá ki̱ngoyo. Te nastútú‑yá ña̱yɨvɨ ní naka̱ji‑ya̱ ndɨ́kúu̱n lado ñu̱yɨ́vɨ, onde̱ nuu̱ ndɨ́'ɨ ñu'un, te onde̱ nuu̱ ndɨ́'ɨ andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Vina te skuá'a‑ró ndasa sá'a yunu mérkexe̱. Nú a ni̱ nduyúcha núma, te ni̱ na̱jaa nda'a, te a kájini̱‑ro̱ já á ni̱ kuyani viko sáú. ");
INSERT INTO migNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Suni súan róó, nú a ni̱ kajini̱‑ro̱ kuákuu ta̱ká tiñu yá'a, te kuni̱‑ro̱ já á yani jaa̱ kɨvɨ̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ja̱ má náa ñáyɨvɨ yá'a, onde̱ ná skíkuu ta̱ká tiñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Andɨ́vɨ́ jíín ñúyɨ́vɨ chi̱ naa, ko tu̱'un ká'a̱n‑ri̱ chi ma̱ náa. ");
INSERT INTO migNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ko kɨvɨ̱ kóo‑ún, jíín hora, tú ni ɨɨn cha̱a jiní, ni ndajá'a̱ ká'i̱o andɨ́vɨ́, ni máá Sé'e‑ya̱, chi̱ máá ɨ́ɨn‑ni máá Táa̱‑yo̱ Dios jiní‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Koto‑ró máá‑ró, te kundito‑ró, te kaka̱n ta'u̱‑ro̱. Chi̱ tú kájini̱‑ro̱ na̱ kɨvɨ̱ kóo. ");
INSERT INTO migNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Chi̱ nátu̱'un ɨɨn cha̱a kua'a̱n jíká‑de. Te ni̱ xndóo‑de ve'e‑de. Te ni̱ ja̱'a‑de tu̱'un nuu̱ mozo‑de, ná tiñu sá'a ɨɨn ɨɨn‑de. Te cha̱a ndíto yuxé'é, ni̱ ta'u̱ tíñu nuu̱‑dé, ná kúndito‑de. ");
INSERT INTO migNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Núsáá te kundito‑ró, chi̱ tú kájini̱‑ro̱ na̱ hora nchaa̱ jito'o̱ ve'e‑ún, á aíni, á ñúú, á kána lí'li, á ja̱ñá'a̱n. ");
INSERT INTO migNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chi̱ sánaa iní‑ro̱ te nchaa̱‑ni‑ya̱. Te ni'i̱n‑yá róó kákixi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Te ta̱ká tu̱'un ká'a̱n‑ri̱ jíín‑ró yá'a, suni ká'a̱n‑ri̱ jíín ndívii‑í jíná'an‑i. Kundito jíná'an‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Te uu̱‑ga̱ kɨvɨ̱ te vásá ní kuu Pascua jíín víko kóo sta̱tilá tú yí'i yujan íá. Te sutu̱ ñá'nu jíín cháa káchaa tutu̱, ni̱ ka̱ndúkú‑de modo ndasa xndá'ú‑de‑ya̱ te tɨɨn‑de‑ya̱. Te ka'ni‑dé‑ya̱ kákuni̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Te ni̱ kaka'a̱n‑de: Ma̱ kúu sá'a‑yó máá kɨvɨ́ víko, chi̱ nú súan te ndonda vaa̱ ña̱yɨvɨ, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Te kándee‑ya̱ ñúu̱ Betania, kánchaa̱‑ya̱ núu̱ mesa ve'e Simón cha̱a té'yu̱ ndɨ̱'yi. Te ni̱ chaa̱ ɨɨn ña'an, kándá'á‑ña ɨ́ɨn tiya'a̱ ñú'un perfume máá nían ita̱ nardo kúu. Te ncháá ya'u téyíí. Te ni̱ tá'ú‑ña tíya'a̱‑ún. Te ni̱ chu'un‑ña xiní‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Te sava, ni̱ kakiti̱ ini̱. Te ni̱ kaka'a̱n: Naja̱ náa perfume jia̱n. ");
INSERT INTO migNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chi̱ kuu kuya̱'u ví'í‑gá uni̱ ciento peso, te kua̱'a‑yó núu̱ ñáyɨvɨ ndá'ú núú, áchí. Te ni̱ kaka'a̱n vaa̱ sɨkɨ̱‑ñá. ");
INSERT INTO migNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ko Jesús, ni̱ ka'a̱n‑ya̱: Sía̱‑ña. Naja̱ kástá'a̱n‑ro̱‑ñá. Tiñu va̱'a sá'a‑ña jíín‑rí, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Chi̱ nene̱ káxiu̱kú ñáyɨvɨ ndá'ú jíín‑ró. Te nú kákuni̱‑ro̱ te kuu sá'a va̱'a‑ró jíín‑i. Ko ruu̱, na̱ tú nene̱ kánchaa̱‑ri̱ jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ya̱'á‑ni ni̱ kuu ni̱ sá'a‑ña. Chi̱ a ni̱ chi'i tu̱'a‑ña perfume yikɨ kúñu‑ri̱ kɨvɨ̱ yúji‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ nɨ́ɨ́ ñúyɨ́vɨ nú ná kui̱cha tu̱'un va̱'a yá'a, te tiñu ni̱ sá'a‑ña yá'a, suni koo tu̱'un náva̱'a ná núku̱'un ini̱‑i‑ña, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yúan‑na te Judas Iscariote, ɨɨn ja̱ uxí uu̱ yúan, kua'a̱n‑de nuu̱ sutú ñá'nu ja̱ nástúu‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Te súan ni̱ ka̱jini so̱'o sutu̱‑ún. Te ni̱ ka̱kusɨɨ̱ iní. Te ni̱ ka̱keyu'u já kuá'a xu̱'ún núu̱‑dé. Te ná ndúkú‑de modo ndasa nastúu‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Te máá kɨvɨ́ kéjá'á víko kóo sta̱tilá tú yí'i yujan íá, suni máá kɨvɨ́ kásoko̱‑dé lélú Pascua, te cha̱a káskuá'a‑ún, ni̱ kaka'a̱n‑de jíín‑yá: Ndénu̱ kuní‑ní ná kísátu̱'a‑ná nuu̱ kée‑ní lélú Pascua, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Te ni̱ tájí‑yá uu̱ cha̱a káskuá'a jíín‑yá kua'a̱n‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kuá'án onde̱ ñuu̱. Te yúan ketá'an‑ró jíín ɨ́ɨn cha̱a ndíso ɨɨn kɨ̱yi nducha. Te kundiki̱n‑ro̱‑dé ki'i̱n‑ro̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Te nuu̱ ndɨ́vɨ‑de, yúan ka'a̱n‑ro̱ jíín máá jíto'o̱ ve'e‑ún: Achí máá Maestro: Ndénu̱ íó ɨɨn ve'e kua̱'a núu‑ní nuu̱ kée‑ná lélú Pascua jíín cháa káskuá'a jíín‑ná, achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Te máá‑de, ná stá'a̱n‑de ɨɨn cuarto ká'nu onde̱ xini̱ vé'e nuu̱‑ro̱, yúan a íó tu̱'a. Te yúan sátu̱'a‑ró ndasa kuu‑yó, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Te kája'a̱n cha̱a káskuá'a jíín‑yá. Te ni̱ ja̱koyo‑de ñuu̱‑ún. Te ni̱ kani'i̱n‑dé nátu̱'un ni̱ ka'a̱n‑ya̱ jíín‑de. Te ni̱ ka̱sátu̱'a‑de ndasa kuxíni‑de lélú Pascua. ");
INSERT INTO migNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Te ni̱ ini. Te kua'a̱n‑ya̱ jíín máá uxí uu̱ cha̱a‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Te káxiu̱kú‑de nuu̱ mesa káyee‑dé staa̱. Te ni̱ ka'a̱n Jesús: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ ɨ́ɨn róó, ja̱ yée jíín‑rí, nastúu‑ró rúu̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yúan‑na te ni̱ ka̱kuxíí iní‑de. Te ni̱ kajika̱ tu̱'ún ná ɨɨn ná ɨɨn‑de‑ya̱: Ja̱ náá náún, ja̱ náá náún, ká'a̱n ɨɨn‑de, ká'a̱n ɨnga̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ɨɨn ja̱ uxí uu̱ ja̱ chíxí'ú núu̱ kó'o̱ jíín‑rí kúu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chi ja̱ndáa̱ máá Sé'e cha̱a ki'i̱n‑ya̱ nátu̱'un yóso tú'un‑ya̱ núu̱ tutú. Ko naka̱ ndá'ú kúu cha̱a nastúu máá Sé'e cha̱a. Va̱'a‑ga̱ nú tú ní káku cha̱a‑ún núú, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Te káyee‑dé. Te ni̱ ki'in Jesús staa̱. Te ni̱ jika̱n ta'u̱‑yá. Te ni̱ sákuáchí‑yá. Te ni̱ ja̱'a‑ya̱ núu̱‑dé. Te ni̱ ka'a̱n‑ya̱: Kee jíná'an‑ró. Ya̱'á kúu yikɨ kúñu‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Te ni̱ ki'in‑ya̱ ɨ́ɨn taza. Te ni̱ jika̱n ta'u̱‑yá. Te ni̱ ja̱'a‑ya̱ núu̱‑dé. Te ndɨ'ɨ‑de, ni̱ ka̱ji'i‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ya̱'á kúu nɨñi̱‑rí ja̱ sá'a contrato jáá. Te ja̱ sɨkɨ́ ñáyɨvɨ kuá'a̱ te ni̱ jatɨ. ");
INSERT INTO migNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Te ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Ma̱ kó'o‑ga̱‑ri̱ nducha ndé'e̱ uva, onde̱ kɨvɨ̱ náko'o‑ri̱ ja̱ jáá iní ñuu̱ nuu̱ tá'ú Dios tiñu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Te ni̱ ka̱jita‑ya̱ ɨ́ɨn yaa̱ ii̱. Te ni̱ kenda‑ya̱ kája'a̱n‑ya̱ ondé yuku Olivos. ");
INSERT INTO migNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yúan‑na te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Ndivii‑ro, nayu̱'ú‑ro̱ já sɨkɨ́ rúu̱ akuáa vína. Chi̱ a yóso núu̱ tutú: Stují‑rí cha̱a ndíto rɨɨ̱, te máá rɨ́ɨ̱‑ún, kuicha̱‑tɨ̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ko nuu̱ náchaku̱‑ri̱, te xna'a̱n‑ga̱ ruu̱ ki'i̱n‑ri̱ ñuu̱ Galilea vásá róó, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ko Pedro, ni̱ ka'a̱n‑de jíín‑yá: Va̱sa ndivii‑dé ná náyu̱'ú‑de, ko náá chi̱ túu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, chi̱ róó, akuáa vína, onde̱ ná té kana‑ga̱ lí'li uu̱ jínu, te ma̱ kuátu̱'un‑ró rúu̱ uni̱ jínu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ko máá‑de, téyíí ní ka'a̱n‑de: Va̱sa ná kúu̱‑ná jíín‑ní, ko ma̱ kasú‑ná yu'u‑ná ja̱ kúu níí, áchí‑de. Te suni súan ni̱ kaka'a̱n ndɨ'ɨ‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Te ni̱ ja̱koyo‑ya̱ ɨ́ɨn nuu̱ nání Getsemaní. Te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a jíín‑yá: Yá'a‑ni jungo̱o‑ró nini ná kakán ta'u̱‑rí, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Te ni̱ jaka‑ya̱ Pedro jíín Jacobo jíín Juan kája'a̱n‑de jíín‑yá. Te ni̱ kejá'á‑yá yú'ú‑ya̱, te ndúkuí'a̱ ini̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Xaa̱n ndúkuí'a̱ ini̱‑ri̱, chi̱ a yani kuu̱‑ri̱. Yá'a kundatu‑ró, te kundito‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Te ni̱ kanduu̱‑ya̱ ɨ́ɨn tí'lí. Te ni̱ jukuiñi̱ jítɨ́‑yá nuu̱ ñú'un. Te ni̱ jika̱n ta'u̱‑yá, te nú kuu ka̱ku‑ya̱ hora‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Te ni̱ ka'a̱n‑ya̱: Abba, Táa̱. Ta̱ká tiñu kúu sá'a máá‑ní. Chaxio‑ní tu̱ndó'o‑ná yá'a ná kí'i̱n. Ko nasu̱ já kuní máá‑ná, chi ja̱ kuní máá‑ní ná kúu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Te ni̱ nchaa̱‑ya̱. Te ni̱ jini̱‑ya̱ já kákixi̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín Pedro: Simón, kixí‑ro̱ náún. Á tú kánda‑ró kúndito‑ró va̱sté ɨ́ɨn hora. ");
INSERT INTO migNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kundito, te kaka̱n ta'u̱‑ro̱, náva̱'a ma̱ kóto nchaa̱‑ún róó. Chi̱ kuní ndija añú‑ro̱, ko yikɨ kúñu‑ró chi̱ túu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Te kua'a̱n tuku‑ya̱. Te ni̱ jika̱n ta'u̱‑yá. Suni ɨɨn‑ni tu̱'un ni̱ ka'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Te ni̱ nchaa̱‑ya̱. Te ni̱ jini̱ tuku‑ya̱‑dé kákixi̱‑de, chi̱ xaa̱n káji'i̱‑de numa̱'ná. Te tú kútuní ndasa xndíó káni‑de tu̱'un nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Te ni̱ nchaa̱‑ya̱ vuelta uni̱. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kusu̱ te ndeta̱tú‑ro̱‑ná. A ni̱ kuu. Vina te ni̱ jaa̱ hora ja̱ máá Sé'e cha̱a natu̱u‑ya̱ núu̱ ndá'a cháa ká'i̱o kua̱chi. ");
INSERT INTO migNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nduko̱o, ná chó'o̱. Chi ja̱ nástúu ruu̱, a ni̱ kuyani va̱i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Te súan ká'a̱n‑ya̱, te ni̱ chaa̱‑ni Judas, ɨɨn ja̱ uxí uu̱‑ún. Te ɨɨn nuu já káchindéé tá'an jíín‑de, jíín machete jíín yúnu vái koyo jíín‑de. Chi̱ sutu̱ ñá'nu jíín cháa káchaa tutu̱ jíín cháa ni̱ ka̱yii, ni̱ ka̱tájí cháa‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Te cha̱a ni̱ nastúu‑ya̱‑ún, ni̱ ja̱'a‑de ɨɨn tuni̱, te ni̱ ka'a̱n‑de: Cha̱a tíyú'ú‑rí‑ún, yu̱án kúu. Katɨɨn jíná'an‑ró, te kunchaka‑ró kí'i̱n‑ro̱ jíín, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yúan‑na te ni̱ chaa̱‑de. Te ni̱ kandita‑ni‑de nuu̱‑yá. Te ni̱ ka'a̱n‑de jíín‑yá: Maestro, Maestro, áchí‑de. Te ni̱ tiyú'ú‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Te cha̱a va̱i koyo jíín Judas‑ún, ni̱ ka̱katɨɨn‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Te ɨɨn cha̱a kándii̱ yúan, ni̱ stáa‑de machete‑de. Te ni̱ kachi‑de so̱'o mozo máá sutú ñá'nu‑ga̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Te ni̱ ka'a̱n Jesús jíín‑de jíná'an‑de: Nátu̱'un sɨkɨ̱ ɨ́ɨn cha̱a kuí'ná vái koyo‑ró jíín machete jíín yúnu kátɨɨn‑ró rúu̱ náún. ");
INSERT INTO migNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ndɨta'a̱n kɨvɨ̱ ní ka̱ndee‑ri̱ jíín‑ró iní ve̱'e ii̱, ni̱ stá'a̱n‑ri̱ tu̱'un, te tú ní kákatɨɨn‑ró rúu̱. Ko súan kásá'a‑ró náva̱'a ná skíkuu tutu̱ ii̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yúan‑na te cha̱a káskuá'a jíín‑yá, ni̱ ka̱skéndo̱o‑de‑ya̱. Te ni̱ ka̱jinu ndɨ'ɨ‑de kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Te ɨɨn su̱chí, ndikín‑i‑ya̱ kuá'a̱n‑i jíín‑yá. Te ndíi‑i ɨɨn sa'ma kuítá, chi̱ víchí lɨ́ɨ‑í. Te ni̱ ka̱katɨɨn‑de‑i. ");
INSERT INTO migNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ko máá‑i, ni̱ xndóo‑i sa'ma kuítá‑ún. Te ni̱ jinu víchí lɨ́ɨ‑í kua'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Te ni̱ ka̱kinchaka‑de Jesús nuu̱ máá sutú ñá'nu‑ga̱. Te ta̱ká sutu̱ ñá'nu jíín cháa ni̱ ka̱yii jíín cháa káchaa tutu̱, ni̱ ka̱ndutútú‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Te Pedro, jíká ndikín‑de‑ya̱ ondé ini̱ yuxé'é máá sutú ñá'nu‑ga̱‑ún. Te ni̱ jungo̱o‑de jíín cháa kájatíñu‑ún, ndúvixi̱‑de ñu'u̱n. ");
INSERT INTO migNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Te ta̱ká sutu̱ ñá'nu jíín táká cha̱a junta, ni̱ ka̱ndúkú‑de ɨɨn tu̱'un sɨkɨ̱ Jesús, ja̱ ká'ni‑dé‑ya̱ kákuni̱‑de. Ko tú ní káni'i̱n‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Chi̱ kua'a̱‑dé, ni̱ ka̱sátú'ún‑de sɨkɨ̱‑yá. Ko tu̱'un ni̱ kaka'a̱n‑de‑ún, tú ní kétá'an. ");
INSERT INTO migNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yúan‑na te ni̱ ka̱ndukuiñi̱ sava‑de, ni̱ ka̱sátú'ún‑de sɨkɨ̱‑yá: ");
INSERT INTO migNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Máá‑ná, ni̱ kajini̱‑ná ká'a̱n‑de: Ruu̱, stúncháa̱‑ri̱ ve'e ii̱ yá'a ja̱ ní ka̱sáva̱'a nda'a. Te nuu̱ uní kɨvɨ̱ te ndukani‑ri̱ ɨnga̱ ja̱ tú nɨ́nɨ jíín ndá'a, áchí‑de, áchí jíná'an. ");
INSERT INTO migNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ko ni súan tú ní kétá'an tu̱'un ni̱ kaka'a̱n. ");
INSERT INTO migNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yúan‑na te máá sutú ñá'nu‑ga‑ún, ni̱ ndukuiñi̱‑de kándii̱‑de ma̱'ñú. Te ni̱ jika̱ tu̱'ún‑de Jesús: Tú ka'a̱n kutɨ‑ro náún. Ndasa káka'a̱n cha̱a yá'a sɨkɨ̱‑ro̱, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Te máá‑yá, tú ní ká'a̱n kutɨ‑yá. Te máá sutú ñá'nu‑ga̱‑ún, ni̱ jika̱ tu̱'ún tuku de‑ya̱: Máá‑ró kúu Cristo, Se̱'e máá I'a̱ ii̱ náún, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Máá‑rí kúu. Te kuni̱‑ro̱ máá Sé'e cha̱a kunchaa̱‑ya̱ íchi ndává'a Dios nuu̱ íó fuerza‑ya̱. Te ndii‑ya̱ íchi ándɨ́vɨ́ jíín vikó nu̱'ún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yúan‑na te máá sutú ñá'nu‑ga̱‑ún, ni̱ ndátá‑ni‑de sa'ma‑dé. Te ni̱ ka'a̱n‑de: Na̱ún nɨ́nɨ kúni so̱'o‑yó ká'a̱n ɨnga̱‑de núsáá. ");
INSERT INTO migNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ni̱ kajini̱‑ro̱ ná ndɨva̱'a ká'a̱n‑de. Ndasa kájani ini̱‑ro̱. Achí sutu̱ ñá'nu‑ga̱‑ún. Te ta̱ká cha̱a‑ún, ni̱ ka̱naku̱xndíi‑de‑ya̱ ná kúu̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Te sava‑de, ni̱ katɨvɨ̱ sɨ̱'vɨ́‑de nuu̱‑yá. Te ni̱ kajasu̱‑de nuu̱‑yá. Te ni̱ kaja̱'a‑de ji̱kí núu̱‑yá. Te káka'a̱n‑de jíín‑yá: Kani tu̱'un, áchí‑de. Te cha̱a kájatíñu‑ún, ni̱ ka̱stují‑dé‑ya̱ jíín jíkí. ");
INSERT INTO migNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Te ichi chíi yuxé'é yúan kándii̱ Pedro. Te ɨɨn ña'an játíñu nuu̱ máá sutú ñá'nu‑ga̱‑ún, ni̱ chaa̱‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Te ni̱ jini̱‑ña núu̱ Pedro kándii̱‑de ndúvixi̱‑de. Te ni̱ ndakoto‑ña núu̱‑dé. Te ni̱ ka'a̱n‑ña: Te róó, jíín Jesús ñuu̱ Nazaret jíka‑ró vii, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ko máá‑de, tú ní játu̱'un‑de. Tú jiní‑ná, ni tú júku̱'un ini̱‑ná na̱ún ká'a̱n‑ní, áchí‑de jíín‑ña. Te ni̱ kenda‑de yuxé'é yatá vé'e‑ún. Te ni̱ kana‑ni lí'li. ");
INSERT INTO migNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Te ña'an játíñu‑ún, ni̱ jini̱‑ña núu̱‑dé ɨnga̱ jínu. Te ni̱ ka'a̱n‑ña jíín cháa ká'i̱in yúan. Cha̱a yá'a suni tá'an‑de, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ko máá‑de, tú ní játu̱'un tuku‑de. Te ni̱ kunúu tuku. Te cha̱a ká'i̱in‑ún, ni̱ kaka'a̱n tuku‑de jíín Pedro: Ja̱ndáa̱ ja̱ súni tá'an‑de kúu‑ró, chi cha̱a galileo kúu‑ró. Te tu̱'un ká'a̱n‑ro̱ súan kuní koo, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ko máá‑de, ni̱'in ni̱ ka'a̱n ndɨva̱'a‑de: Tú jiní‑ri̱ cha̱a yá'a ja̱ káka'a̱n‑ro̱ tú'un‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yúan‑na te ni̱ kana‑ni lí'li vuelta uu̱. Te Pedro, ni̱ nuku̱'un ini̱‑de ta̱ká tu̱'un ni̱ ka'a̱n Jesús jíín‑de núú: Onde̱ ná té kana‑ga̱ lí'li uu̱ jínu, te ma̱ kuátu̱'un‑ró rúu̱ uni̱ jínu, áchí‑ya̱ sáá. Te ni̱ nakani ini̱‑de sɨkɨ̱ tú'un‑ún. Te ni̱ nde'e̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Te ja̱ñá'a̱n‑ún, te ta̱ká sutu̱ ñá'nu, jíín cháa ni̱ ka̱yii, jíín cháa káchaa tutu̱, jíín ndívii cháa junta, ni̱ ka̱skétá'an‑ni‑de tu̱'un. Te ni̱ kaju'ni̱‑de Jesús kua'a̱n‑de jíín‑yá. Te ni̱ kaja̱'a‑de‑ya̱ núu̱ Pilato. ");
INSERT INTO migNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Te Pilato, ni̱ jika̱ tu̱'ún‑de‑ya̱: Máá‑ró kúu Rey cha̱a judío náún, áchí‑de. Te ni̱ ka'a̱n‑ya̱: Ká'a̱n ndaa̱‑ro̱, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Te sutu̱ ñá'nu‑ún, ni̱'in ni̱ kajika̱n‑de kua̱chi sɨkɨ̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Te Pilato, ni̱ jika̱ tu̱'ún tuku‑de‑ya̱: Tú ka'a̱n kutɨ‑ro náún. Nde̱'é, ná kua'a̱ kuáchi kájika̱n‑de sɨkɨ̱‑ro̱, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ko Jesús, tuká ní ká'a̱n kutɨ‑yá. Te ni̱ naa iní Pilato ndé'é‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Te íó costumbre Pilato ja̱ kɨvɨ́ víko‑ún sía̱‑de ɨɨn cha̱a yí'i veka̱a, na̱ni cha̱a kákuu ini̱ ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Te ni̱ i̱o ɨɨn cha̱a nání‑de Barrabás, kándee‑de veka̱a jíín tá'an‑de ja̱ ní ka̱ndonda‑de, ni̱ ka̱ja'ni‑dé ndɨ̱yi. ");
INSERT INTO migNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Te ni̱ cha̱koyo kua'a̱ ñáyɨvɨ. Te ni̱ kaka'a̱n‑i jíín Pilato ná sá'a‑de nátu̱'un íó costumbre‑de. ");
INSERT INTO migNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Te ni̱ ka'a̱n Pilato jíín‑i: Kákuni̱‑ro̱ já sía̱‑ri̱ Rey cha̱a judío náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Chi̱ a ni̱ jini̱‑de ja̱ ní ka̱kukuásún iní sutu̱ ñá'nu‑ún, te yu̱án ní kaja̱'a‑ún‑yá nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Chi̱ sutu̱ ñá'nu‑ún, ni̱ ka̱ská'a̱n‑de ña̱yɨvɨ kuá'a̱‑ún ja̱ Pilato va̱'a‑ga̱ ná sía̱‑de Barrabás ki'i̱n. ");
INSERT INTO migNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Te ni̱ ka'a̱n tuku Pilato: Ndasa kákuni̱‑ro̱ já sá'a‑ri̱ jíín cháa káskúnání‑ró Rey judío núsáá, áchí‑de jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Te máá‑i, ni̱ ka̱kana jaa tuku‑i: Kata kaa‑ní cha̱a jia̱n jiká cruz, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ko Pilato, ni̱ ka'a̱n‑de jíín‑i: Na̱ún kua̱chi ni̱ sá'a‑de, áchí‑de. Te máá‑i, ví'í‑gá ni̱ ka̱kana jaa‑i: Kata kaa‑ní‑de ná kúu̱‑de, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Te Pilato, kuní‑de ja̱ ná kúsɨɨ̱ iní ña̱yɨvɨ‑ún. Te ni̱ sía̱‑de Barrabás kua'a̱n. Yúan‑na te ni̱ xndó'o‑de‑ya̱. Te ni̱ ja̱'a‑de‑ya̱ kuíta kaa‑ya̱ já ná kúu̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yúan‑na te soldado, ni̱ ka̱ki'in‑de‑ya̱ kuá'a̱n‑de jíín‑yá ini̱ ve̱'e palacio. Te ni̱ ka̱kana xini̱ tá'an‑de ni̱ ka̱ndutútú‑de. ");
INSERT INTO migNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Te ni̱ ka̱chu'un‑de‑ya̱ ɨ́ɨn sa'ma kuá'á tíndí'í. Te ni̱ ka̱tɨɨn‑de ɨɨn corona iñu. Te ni̱ ka̱chu'un‑de xini̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yúan‑na te ni̱ kaka'a̱n‑de jíín‑yá: Rey judío, ta̱á ndii, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Te ni̱ ka̱kuun‑de yunu xiní‑yá. Te ni̱ katɨvɨ̱ sɨ̱'vɨ́‑de nuu̱‑yá. Te ni̱ ka̱jukuiñi̱ jítɨ́‑de nuu̱‑yá, te ni̱ ka̱chiñú'ún‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Te nuu̱ ní ndɨ'ɨ ni̱ ka̱sákátá‑de nuu̱‑yá, te ni̱ ka̱tava‑dé sa'ma kuá'á tíndí'í ñú'un‑ya̱‑ún. Te ni̱ ka̱nachu'un‑de‑ya̱ sá'ma máá‑yá, te ni̱ ka̱keni'in‑de‑ya̱ káta kaa‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Te ɨɨn cha̱a nání‑de Simón ñuu̱ Cirene (táa̱ Alejandro jíín Rufo kúu‑de), ni̱ ja̱'a‑de va̱i‑de ichi rancho. Te ni̱ ka̱tetíñu‑de cha̱a‑ún ki'i̱n‑de jíín‑de kundiso‑de cruz‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Te kája'a̱n‑de jíín‑yá onde̱ nuu̱ nání Gólgota, ja̱ kuní ka'a̱n: yikɨ xiní. ");
INSERT INTO migNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Te ni̱ ka̱sáká núu‑de vino jíín súsia ua̱. Te ni̱ kaja̱'a‑de nuu̱‑yá ko'o‑ya̱. Ko máá‑yá, tú ní játá'ú‑yá ko'o‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Te ni̱ ka̱jata kaa‑de‑ya̱ jiká cruz. Te ni̱ ka̱saka‑dé sa'ma‑yá nuu̱ tá'an‑de. Te ni̱ ka̱sá'a‑de apuesto sɨkɨ̱, ndasa ni'i̱n, ɨ́ɨn ɨɨn‑de. ");
INSERT INTO migNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Te ka̱'ɨɨ̱n ni̱ ka̱jata kaa‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Te nuu̱ tutú kua̱chi sɨkɨ̱‑yá yóso: Ya̱'á kúu Rey cha̱a judío, áchí. ");
INSERT INTO migNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Te ni̱ ka̱jata kaa‑de uu̱ ñakui̱'ná jíín‑yá, ɨɨn ichi ndává'a‑ya̱, te ɨnga̱ ichi ndávésé‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Te ni̱ skikuu tu̱'un ká'a̱n tutu̱ ii̱: Onde̱ jíín cháa kánda̱ñáá ní ka̱skétá'an‑de‑ya̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Te ña̱yɨvɨ kája̱'a yúan, ni̱ ka̱skuíkó‑i xini̱‑í. Te ni̱ kaka'a̱n ndɨva̱'a‑i jíín‑yá: Ja̱n jaa̱n. Róó, ká'a̱n‑ro̱ já stúncháa̱‑ro̱ vé'e ii̱ Dios, te nuu̱ uní kɨvɨ̱ te ndukani‑ró núú. ");
INSERT INTO migNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Vina te nama‑ró máá‑ró, te nuu‑ró jiká cruz núsáá vii, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Te suni súan ni̱ ka̱sákátá sutú ñá'nu‑ún nuu̱‑yá. Te kándatu̱'ún jíín cháa káchaa tutu̱: Sava ña̱yɨvɨ á ni̱ kuu ni̱ nama‑de, ko ma̱ kúu nama‑de máá‑de. ");
INSERT INTO migNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cristo, Rey cha̱a Israel, ná núu‑de jika̱ cruz vina, te ná kuní‑yo̱, te ná kándíja‑yó, áchí. Te cha̱a kándi̱ta kaa jíín‑yá‑ún, suni súan ni̱ kaka'a̱n ndɨva̱'a‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Te nuu̱ ní kuu ka̱xiuu̱, te ni̱ kuxkɨ́'vɨ̱ nɨ́ɨ́ núu̱ ñú'un onde̱ ka̱'uni̱. ");
INSERT INTO migNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Te nuu̱ ní kuu ka̱'uni̱, te ni̱ ka'a̱n jaa Jesús: Eloi, Eloi, lama sabactani, achí‑ya̱. Ja̱ kuní ka'a̱n: Dios máá‑ná, Dios máá‑ná, naja̱ ní xndóo‑ní náá. ");
INSERT INTO migNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Te sava cha̱a ká'i̱in yúan, ni̱ ka̱jini so̱'o‑de. Te ni̱ kaka'a̱n‑de: Nde̱'é, chi̱ kána‑de xini̱ Elías, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Te jínu ɨɨn cha̱a ni̱ jaa̱‑de, te ni̱ chíndájí‑de kachi̱ núu̱ vinagre. Te ni̱ chaa‑de xini̱ ɨ́ɨn yunu. Te ni̱ ja̱'a‑de nuu̱‑yá ja̱ kó'o‑ya̱. Te ni̱ ka'a̱n‑de: Ná ndé'ó nú chaa̱ Elías xnúu‑de cha̱a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ko máá Jesús, ni̱ ka'a̱n jaa‑ya̱. Te ni̱ ji'i̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yúan‑na te sa'ma ndíta kaa ini̱ ve̱'e ii̱, ni̱ te'nde̱ uu̱ onde̱ nuu̱ xiní te onde̱ nuu̱ já'a̱. ");
INSERT INTO migNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Te ɨɨn cha̱a capitán kándii̱‑de nuu̱‑yá. Te ni̱ jini̱‑de ja̱ ní kana jaa‑ya̱ ní ji'i̱‑ya̱. Te ni̱ ka'a̱n‑de: Ja̱ndáa̱ ja̱ Sé'e Dios kúu cha̱a yá'a núú, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Te suni ká'i̱in sava ñasɨ́'ɨ́ kánde̱'é jíká‑ña. Te yúan ká'i̱in María ñuu̱ Magdala, jíín Salomé, jíín María náa̱ José jíín Jacobo súchí. ");
INSERT INTO migNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Chi̱ onde̱ ná kándee‑ya̱ ñúu̱ Galilea, te ña'an‑ún, ni̱ kandiki̱n‑ña‑yá. Te ni̱ ka̱jatíñu‑ña núu̱‑yá. Te suni íó kua'a̱‑gá‑ña, ni̱ kaja'a̱n‑ña jíín‑yá ñuu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Te ni̱ ini kɨvɨ̱‑ún. Te kásátu̱'a‑de, chi̱ yuchaa̱n kúu kɨvɨ̱ ndéta̱tú. ");
INSERT INTO migNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Te José ñuu̱ Arimatea, cha̱a kúñá'nu nuu̱ junta kúu‑de, te suni ñúkuu ini̱‑de ja̱ kúu ñuu̱ nuu̱ tá'ú Dios tiñu, ni̱ chaa̱‑de. Te ni̱ chundéé iní‑de ni̱ kɨ̱vɨ‑de nuu̱ Pilato. Te ni̱ jika̱n‑de yikɨ kúñu Jesús. ");
INSERT INTO migNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Te Pilato, tú kándíja‑de ja̱ á ni̱ ji'i̱‑ya̱. Te ni̱ kana‑de xini̱ capitán. Te ni̱ jika̱ tu̱'ún‑de cha̱a‑ún nú a ni̱ ji'i̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yúan‑na te ni̱ kundaa̱ ini̱‑de ja̱ ní ka'a̱n capitán‑ún jíín‑de. Te ni̱ ja̱'a‑de yikɨ kúñu‑ya̱ núu̱ José. ");
INSERT INTO migNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Te José, ni̱ jaan‑de ɨɨn sa'ma kuítá. Te ni̱ xnúu‑de‑ya̱. Te ni̱ chisukun‑dé‑ya̱ sá'ma‑ún. Te ni̱ chindee‑de‑ya̱ iní ve̱'e añú ja̱ ní jacha chi̱i ɨɨn kava. Te ni̱ stúu‑dé ɨɨn yuu̱ ní jasu̱‑de yuvé'e añú‑ún. ");
INSERT INTO migNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Te María ñuu̱ Magdala, jíín María náa̱ José, ni̱ kajini̱‑ña núu̱ ní jaki̱n‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Te ni̱ ini kɨvɨ̱ ndéta̱tú‑ún. Te María ñuu̱ Magdala, jíín María náa̱ Jacobo, jíín Salomé, ni̱ ka̱jaan‑ña jí'o vixi̱ kichi̱'i‑ña‑yá. ");
INSERT INTO migNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Te ja̱ñá'a̱n kɨvɨ̱ ɨ́ɨn semana, ja̱ á ni̱ kana ndika̱ndii, ni̱ ja̱koyo‑ña núu̱ vé'e añú. ");
INSERT INTO migNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Te káka'a̱n máá‑ña: Ndénu̱ ní'i̱n‑yo̱ ɨ́ɨn cha̱a chaxio yuu̱ yúvé'e añú, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Te ni̱ ka̱ndakoto‑ña. Te ni̱ kajini̱‑ña já á ni̱ kuxio yuu̱‑ún kua'a̱n. Te ká'nu xaa̱n. ");
INSERT INTO migNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Te ni̱ kɨ̱vɨ koyo‑ña iní ve̱'e añú‑ún. Te ni̱ kajini̱‑ña ɨ́ɨn cha̱a súchí, ñú'un káni‑dé ɨɨn sa'ma kuíjín, kánchaa̱‑de ichi ndává'a. Te ni̱ kayu̱'ú‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Te cha̱a‑ún, ni̱ ka'a̱n‑de jíín‑ña: Ma̱ yú'ú‑ro̱. Kánandúkú‑ró Jesús ñuu̱ Nazaret I'a̱ ni̱ ji'i̱ jika̱ cruz. Túu‑ya̱ yá'a, chi̱ a ni̱ nachaku̱‑ya̱. Yá'a nde̱'é‑ró nú ní kajaki̱n‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kuángoyo núsáá, te kachi̱‑ro̱ núu̱ cháa káskuá'a jíín‑yá, jíín núu̱ Pedro, ja̱ xná'a̱n‑ga̱‑ya̱ kí'i̱n ñuu̱ Galilea vásá kí'i̱n‑ro̱. Yúan kuni̱‑ro̱ núu̱‑yá, nátu̱'un ni̱ ka'a̱n‑ya̱ jíín‑ró sáá, áchí‑de jíín‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Te máá‑ña, kájinu‑ña ní ndenda‑ña vé'e añú. Chi̱ káyu̱'ú‑ña, te kákɨsɨ‑i‑ña. Te tú ni ɨɨn nuu̱ ní kákachi̱‑ña, chi̱ káyu̱'ú‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Te Jesús, a ni̱ nachaku̱‑ya̱ máá jáñá'a̱n kɨvɨ̱ ɨ́ɨn semana. Te xnáñúú‑gá ni̱ ndenda ndiji̱n‑ya̱ núu̱ María ñuu̱ Magdala. Ña'an‑ún, ni̱ yi̱'i usia̱ tachi̱ kíni‑ña. Te ni̱ kiñi'in‑ya̱ kuá'a̱n. ");
INSERT INTO migNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Te ni̱ kee‑ña kuá'a̱n‑ña. Te ni̱ kachi̱‑ña núu̱ cháa ni̱ ka̱jika jíín‑yá, chi̱ kándukuí'a̱ ini̱‑de te kánde'e̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Te súan ni̱ ka̱jini tu̱'un‑de ja̱ chakú‑ya̱ ní jini̱ ña'an‑ún nuu̱‑yá. Ko tú ní kákandíja‑de tu̱'un ká'a̱n‑ña. ");
INSERT INTO migNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Te ni̱ kuee̱‑ga̱. Te ɨnga̱ modo ni̱ nastá'a̱n ndiji̱n‑ya̱ máá‑yá nuu̱ úu̱‑de kájika‑de kua'a̱n‑de ichi rancho‑de. ");
INSERT INTO migNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Te cha̱a‑ún, ni̱ kaja'a̱n‑de. Te ni̱ kastu̱'ún‑de nuu̱ sáva‑ga̱. Ko ni tú ní kákandíja ja̱ káka'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yúan‑na te vásá ní nastá'a̱n ndiji̱n‑ya̱ máá‑yá nuu̱ máá uxí ɨɨn‑de, káxiu̱kú‑de káyee‑dé staa̱. Te ni̱ kana jíín‑yá nuu̱‑dé, chi̱ ndava iní añú‑de, te tú ní kákandíja‑de tu̱'un ni̱ kaka'a̱n ja̱ ní kajini̱ nuu̱‑yá ja̱ ní nachaku̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kuá'án jíná'an‑ró nɨ́ɨ́ ñúyɨ́vɨ, te kani‑ró tú'un va̱'a‑ri̱ nuu̱ táká ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Cha̱a kándíja te kuanducha‑dé, ka̱ku‑de. Ko cha̱a tú kándíja, ta'nu̱ ndatu̱‑de. ");
INSERT INTO migNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Te cha̱a kákandíja, sá'a‑de tuni̱ yá'a: Jíín sɨ́'vɨ́‑rí kiñi'in‑de tachi̱ kíni ki̱ngoyo. Te ka'a̱n‑de ɨnga̱ yu'u jáá. ");
INSERT INTO migNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kuanchaa̱‑de koo̱, te nú ni̱ ji'i‑de veneno, te ma̱ sá'a daño jíín‑de. Te xndée‑de nda'a‑dé sɨkɨ̱ ñáyɨvɨ kú'u̱, te nduva̱'a‑i, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yúan‑na te nuu̱ ní ndɨ'ɨ ni̱ ka'a̱n máá Jíto'o̱‑yo̱ jíín‑de jíná'an‑de, te ni̱ ndaa‑ya̱ kuáno'on‑yá andɨ́vɨ́. Te ni̱ nungo̱o‑ya̱ íchi ndává'a Dios. ");
INSERT INTO migNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Te máá‑de, kája'a̱n‑de. Te ni̱ ka̱jani‑de tu̱'un‑ya̱ táká lado. Te máá Jito'o̱‑yo̱, ni̱ chindéé ní chituu‑ya̱‑dé. Te jíín tuní ni̱ ka̱sá'a‑de‑ún ni̱ stá'a̱n‑ya̱ já íó ndaa̱ ta̱ká tu̱'un yá'a. Amén.");
INSERT INTO migNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kua'a̱ cháa ni̱ ka̱chaa‑de tu̱'un ná ta̱ká tiñu ni̱ sá'a Jesús ni̱ kajini̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Te cha̱a ni̱ kajini̱ nuu̱‑yá ná onde̱ kɨvɨ̱ ní kejá'á‑yá, ni̱ ka̱jani‑de tu̱'un‑ya̱. Te ni̱ kaka̱stu̱'ún‑de nuu̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Te náá, a ni̱ nandúkú víi‑ná ta̱ká tu̱'un‑ya̱, ná onde̱ kɨvɨ̱ ní kejá'á. Te jáni ini̱‑ná ja̱ súni íó va̱'a chaa kájí‑ná tu̱'un yá'a nuu̱‑ní, Teófilo máni̱, ");
INSERT INTO migNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","náva̱'a ná kuní‑ní ja̱ íó ndaa̱ ta̱ká tu̱'un ni̱ skuá'a‑ní. ");
INSERT INTO migNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Te kɨvɨ̱ ní kuu Herodes rey ñuu̱ Judea, ni̱ i̱o ɨɨn sutu̱ nání‑de Zacarías ja̱ ní chindéé tá'an‑de jíín Abías. Te ñasɨ́'ɨ́‑de nání‑ña Elisabet. Te onde̱ chi̱i Aarón va̱i tata̱‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Te cha̱a ndaa̱ ni̱ ka̱kuu ndendúú‑de nuu̱ Dios. Te ñúkúún ní ka̱skíkuu‑de ta̱ká tu̱'un jíín tíñu tá'ú‑yá nuu̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Te tú se̱'e‑de ní íó, chi̱ Elisabet, ña'an numá kúu‑ña, te vina, a ni̱ ka̱yii‑de. ");
INSERT INTO migNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yúan‑na te ni̱ jaa̱ kɨvɨ̱ ní ka̱teta'a̱n‑i nuu̱ Zacarías jíku‑de jíín tíñu ja̱ kúu‑de sutu̱ nuu̱ Dios, ");
INSERT INTO migNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","nátu̱'un ni̱ ka̱sá'a máá sutú. Te ja̱ yúán ni kɨ̱vɨ‑de ini̱ ve̱'e ii̱ máá Jíto'o̱‑yo̱. Te ní ja'mu‑de su̱sia ku̱tú. ");
INSERT INTO migNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Te nini já'mu‑de su̱sia ku̱tú, te ichi yatá vé'e ii̱, kájika̱n ta'u̱ ñáyɨvɨ kuá'a̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Te ni̱ kenda ɨɨn ndajá'a̱ máá Jito'o̱‑yo̱ núu̱‑dé, kándii̱‑ya̱ íchi ndává'a altar nuu̱ já'mu‑de su̱sia ku̱tú. ");
INSERT INTO migNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Te ni̱ jini̱ Zacarías nuu̱‑yá, te ni̱ yu̱'ú‑de, te ni̱ kɨsɨ‑i‑de. ");
INSERT INTO migNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ko máá ndájá'a̱‑ún, ni̱ ka'a̱n‑ya̱ jíín‑de: Zacarías, ma̱ yú'ú‑ro̱, chi ja̱ ní jika̱n ta'u̱‑ro̱ a ni̱ jini so̱'o Dios. Te ñasɨ́'ɨ́‑ro̱ Elisabet, skáku‑ña ɨ́ɨn se̱'e yíí, te skúnání‑ró‑i Juan. ");
INSERT INTO migNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Te kusɨɨ̱ xáa̱n iní‑ro̱. Te kusɨɨ̱ iní kua'a̱ ñáyɨvɨ jíín‑i kɨvɨ̱ káku‑i. ");
INSERT INTO migNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Te kuu‑i ɨɨn cha̱a kúñá'nu nuu̱ Dios. Te ma̱ kó'o‑i vino, ni ndɨxɨ̱. Te kukútú Espíritu Santo ini̱‑i, va̱sa ñú'un‑ga̱‑i chi̱i náa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Te kua'a̱ cháa Israel ndíó káva ini̱‑de nuu̱ Dios sá'a‑i. ");
INSERT INTO migNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Te kuxnúú‑i jíín modo jíín fuerza Elías nuu̱ I'a̱ kii. Te ta̱ká táa̱, ndundá'ú ini̱‑de se̱'e‑de, te cha̱a ni̱'in ini̱, nakuandatu̱‑de tu̱'un ndíchí ká'a̱n cha̱a ndaa̱, sá'a‑i. Te sátu̱'a‑i ña̱yɨvɨ kóo tu̱'a ja̱ cháa̱ máá Jito'o̱‑yo̱. Achí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Te ni̱ ka'a̱n Zacarías jíín ndájá'a̱‑ún: Ndasa kuni̱‑ná te nú ja̱ndáa̱ kúu, chi cha̱a ni̱ yii kúu‑ná, te ñasɨ́'ɨ́‑ná, suni a ni̱ yii‑ña, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Te ni̱ ka'a̱n ndajá'a̱‑yá: Máá‑rí kúu Gabriel, ja̱ kándii̱‑ri̱ nuu̱ Dios. Te ni̱ tájí‑yá ruu̱, va̱i ka'a̱n‑ri̱ jíín‑ró, te kachi̱‑ri̱ tu̱'un va̱'a yá'a nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Vina te kuñí'ín‑ro̱, te ma̱ kúu ka'a̱n‑ro̱ ondé kɨvɨ̱ skíkuu tu̱'un yá'a, chi̱ tú ní kándíja‑ró tú'un ni̱ ka'a̱n‑ri̱, te tu̱'un skíkuu ná'ín kúu, ná jáa̱ kɨvɨ̱, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Te ña̱yɨvɨ‑ún, káinda̱tu‑i Zacarías. Te kájani ini̱‑i na̱ún tá'a̱n‑de ja̱ ní kuná'án kándee‑de ini̱ ve̱'e ii̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yúan‑na te ni̱ ndenda‑de, te tuká ní kúu ka'a̱n‑de jíín‑i. Te ni̱ kaju̱ku̱'un ini̱‑i ja̱ iní ve̱'e ii̱‑ún ni̱ jini̱‑de ɨɨn ja̱ Dios ni̱ skóto‑ya̱‑dé. Te máá seña‑na̱ ni̱ sá'a‑de nuu̱‑í, chi̱ a ni̱ kuñí'ín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Te nuu̱ ní ji̱nu tiñu ndíso‑de, te kua̱no'on‑dé ve'e‑de. ");
INSERT INTO migNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yúan‑na te ni̱ kuu yaku̱ kɨvɨ̱. Te ñasɨ́'ɨ́‑de Elisabet, ni̱ ni'i̱n sé'e‑ña. Te ni̱ chisa̱'í‑ña máá‑ña ú'u̱n yoo̱. Te ni̱ ka'a̱n‑ña: ");
INSERT INTO migNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Súan ni̱ sá'a máá Jito'o̱‑yo̱ jíín‑rí ja̱ ní jini̱‑ya̱ núu̱‑rí. Te vina tuká kúka nuu̱‑rí nuu̱ táká ña̱yɨvɨ. Achí‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Te nuu̱ iñú yoo̱, te ni̱ tájí Dios ndajá'a̱ Gabriel, ni̱ ja'a̱n‑ya̱ ɨ́ɨn ñuu̱ nání Nazaret, ndañúu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ni̱ ja'a̱n‑ya̱ núu̱ ɨ́ɨn ña'an jáá, já á yani ta̱nda'a‑ñá jíín ɨ́ɨn cha̱a nání José. Te onde̱ chi̱i David va̱i tata̱‑de. Te ña'an jáá‑ún nání‑ña María. ");
INSERT INTO migNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Te ni̱ jaa̱ ndajá'a̱‑yá nuu̱ kánchaa̱‑ña yúan. Te ni̱ ka'a̱n‑ya̱ jíín‑ña: Ta̱á ndii, ta'u̱‑ro̱ kúu, chi̱ máá Jito'o̱‑yo̱ jíka‑ya̱ jíín‑ró. Te xáán ndatu̱ kéndo̱o‑ró vásá táká ña'an. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Te máá‑ña, ni̱ jini̱‑ña núu̱‑yá. Te ni̱ kuñáá ini̱‑ña já súan ni̱ ka'a̱n‑ya̱. Te jáni ini̱‑ña na̱ún tu̱'un kúu ja̱ ní ka'a̱n‑ya̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yúan‑na te ni̱ ka'a̱n ndajá'a̱‑yá jíín‑ña: María, ma̱ yú'ú‑ro̱, chi ni̱ kusɨɨ̱ iní Dios jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vina te juku̱'un se̱'e‑ró, te skáku‑ró ɨ́ɨn se̱'e yíí. Te skúnání‑ró‑i Jesús. ");
INSERT INTO migNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kuñá'nu su̱chí‑ún. Te kunání‑i Se̱'e I'a̱ kúñá'nu xaa̱n. Te máá Tatá Dios kua̱'a‑ya̱ mesa táa̱‑i David nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Te tá'ú‑i tiñu ini̱ ve̱'e Jacob nɨ́ɨ́ káni. Te kɨvɨ̱ tá'ú‑i tiñu‑ún, ma̱ ndɨ́'ɨ kutɨ. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Yúan‑na te ni̱ ka'a̱n María jíín ndájá'a̱‑yá: Ndasa koo Táta̱, chi̱ tú yii‑ná íó, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Te ni̱ kachi̱ ndajá'a̱‑yá jíín‑ña: Máá Espíritu Santo kii sɨkɨ̱‑ro̱, te fuerza máá I'a̱ kúñá'nu xaa̱n sá'a katɨ sɨkɨ́‑ro̱. Yu̱án máá súchí íi̱ káku‑ún, kunání‑i Se̱'e Dios. ");
INSERT INTO migNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Te kástu̱'ún‑rí nuu̱‑ro̱, já tá'an‑ró Elisabet, suni a ni̱ ni'i̱n sé'e‑ña vína va̱sa a ni̱ yii‑ña. Te vina íó iñu̱ yoo̱ já tuká nání‑ña ñá'an numá. ");
INSERT INTO migNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Chi ta̱ká ja̱ kuní Dios, te kuu sá'a‑ya̱, áchí ndajá'a̱‑yá ");
INSERT INTO migNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","yúan‑na te ni̱ ka'a̱n María: Kuu, chi̱ játíñu‑ná nuu̱ máá Tatá Dios, te súan ná kóo nátu̱'un ni̱ ka'a̱n‑ní núsáá, áchí‑ña. Te máá ndájá'a̱‑ún, kua'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Te ni̱ kuu kɨvɨ̱. Te ni̱ ndukuiñi̱ María, ni̱ kaa‑ña ɨ́ɨn yuku kuá'a̱n‑ña, ni̱ jaa̱‑ña ɨ́ɨn ñuu̱ nání Judá. ");
INSERT INTO migNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Te ni̱ kɨ̱vɨ‑ña iní ve̱'e Zacarías. Te ni̱ ka'a̱n‑ña jíín Elisabet. ");
INSERT INTO migNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Te nuu̱ ní jini so̱'o Elisabet tu̱'un ni̱ ka'a̱n María jíín‑ña, te su̱chí lúlí‑ún ni̱ tuñu‑ni‑i chi̱i‑ña. Te ni̱ chítú ndɨ́ɨ Elisabet jíín Espíritu Santo. ");
INSERT INTO migNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Te ni̱ ka'a̱n jaa‑ña: Xáán ndatu̱ kúu‑ró núu̱ táká ña'an. Te suni xáán ndatu̱ kúu su̱chí ñú'un chi̱i‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Te na̱ún ña'an kúu ruu̱ ja̱ ní chaa̱ náa̱ máá Jito'o̱‑ri̱ nuu̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Chi ja̱ ní jini so̱'o‑ri̱ tu̱'un ni̱ ka'a̱n‑ro̱ jíín‑rí, te su̱chí ñú'un chi̱i‑ri̱ yá'a, ni̱ tuñu‑ni‑i ja̱ kúsɨɨ̱ iní‑i. ");
INSERT INTO migNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Xáán ndatu̱ kúu ña'an ní kandíja‑ún, chi ta̱ká tu̱'un ni̱ keyu'u máá Tatá Dios, skíkuu ná'ín jíín‑ña, áchí Elisabet. ");
INSERT INTO migNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Yúan‑na te ni̱ ka'a̱n María: Kúu ini̱‑ri̱ ja̱ ná ndúñá'nu máá Tatá Dios. ");
INSERT INTO migNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Te kúsɨɨ̱ iní‑ri̱ jíín Dios ja̱ náma‑ya̱ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Chi ni̱ jini̱‑ya̱ já kúka nuu̱ iní ña'an játíñu nuu̱‑yá núú. Ko onde̱ vina te ka'a̱n ta̱ká ña̱yɨvɨ jíín‑rí ja̱ xáán ndatu̱‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Chi̱ I'a̱ tɨ́ɨn ndɨ'ɨ fuerza, ni̱ sá'a‑ya̱ tíñu ñá'nu jíín‑rí, te sɨ́'vɨ́ íi̱ ñáva̱'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Te nɨ́ɨ́ káni kúndá'ú ini̱‑ya̱ táká ña̱yɨvɨ kájandatu̱ nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ni̱ sá'a‑ya̱ tíñu ñá'nu jíín ndá'a‑yá. Te ni̱ skúnu‑ya̱ cháa vixi̱ kája'a̱n‑de, onde̱ jíín táká ja̱ kájani sáni ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Te ni̱ chaxio‑ya̱ cháa kákuñá'nu nuu̱ mesa‑de. Ko cha̱a kákundá'ú, ni̱ nasáñá'nu‑ya̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Te nuu̱ cháa káji'i̱ so̱ko, ni̱ ja̱'a‑ya̱ já kée vá'a‑de. Ko cha̱a kúká, ni̱ kiñi'in sáni‑ya̱‑dé kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Te ni̱ chindéé ní chituu‑ya̱ mozo‑ya̱ ñáyɨvɨ Israel, chi̱ núku̱'un ini̱‑ya̱ já ní kundá'ú ini̱‑ya̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chi ni̱ ka'a̱n‑ya̱ jíín ndɨ́yi táa̱‑yo̱ jíná'an‑de, ja̱ nɨ́ɨ́ káni kundá'ú ini̱‑ya̱ Abraham jíín táká tata̱‑de, áchí María. ");
INSERT INTO migNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Te ni̱ kanchaa̱ María jíín‑ña nátu̱'un uni̱ yoo̱. Yúan‑na te kua̱no'on‑ñá ve'e‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Te Elisabet ni̱ jaa̱ kɨvɨ̱ skáku‑ña sé'e‑ña. Te ni̱ skáku‑ña ɨ́ɨn se̱'e yíí. ");
INSERT INTO migNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Te ni̱ ka̱jini tu̱'un tá'an‑ña jíín ñáyɨvɨ káxiu̱kú yáni, ja̱ Dios xaa̱n ní kundá'ú ini̱‑ya̱‑ñá. Te kákusɨɨ̱ iní‑i jíín‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yúan‑na te nuu̱ uná kɨvɨ̱, te ni̱ cha̱koyo‑de ja̱ xɨtɨ́ ndúu̱ su̱chí yɨ́kɨ́n‑ún. Te skúnání‑de‑i sɨ́'vɨ́ táa̱‑i Zacarías núú. ");
INSERT INTO migNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ko ni̱ ka'a̱n náa̱‑i: Ma̱ kúu, chi̱ Juan kunání‑i, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Te ni̱ kaka'a̱n‑de jíín‑ña: Naja̱. Te tú ni ɨɨn tá'an‑ró nání súan, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yúan‑na te jíín seña kájika̱ tu̱'ún‑de táa̱‑i ndasa kuní‑de kunání‑i. ");
INSERT INTO migNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Te ni̱ jika̱n máá‑de ɨɨn tutu̱. Te yúan ni̱ chaa‑de: Juan kunání‑i, áchí. Te ta̱ká ña̱yɨvɨ‑ún ni̱ ka̱naa iní kánde̱'é‑i. ");
INSERT INTO migNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Te ni̱ nanuña‑ni yu'u‑dé. Te ni̱ nduvi̱tá‑ni yáa‑dé. Te ni̱ naka'a̱n‑ni‑de ni̱ nakana jaa‑de Dios. ");
INSERT INTO migNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Te ta̱ká ña̱yɨvɨ kákuu tá'an‑de, ni̱ kayu̱'ú‑i. Te ni̱ jicha̱ ta̱ká tu̱'un yá'a kua'a̱n nɨ́ɨ́ yúku ndáñúu̱ Judea. ");
INSERT INTO migNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Te ta̱ká ja̱ ní ka̱jini so̱'o tu̱'un‑ún, ni̱ kañu̱'un‑ni ini̱ máá. Te káka'a̱n: Ndasa koo su̱chí yá'a núsáá, chi̱ máá Tatá Dios ndíto‑ya̱‑í, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yúan‑na te táa̱‑i Zacarías, ni̱ chítú ndɨ́ɨ‑dé jíín Espíritu Santo. Te ni̱ jani‑de tu̱'un: ");
INSERT INTO migNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ná nákana jaa‑yó máá Tatá Dios ña̱yɨvɨ Israel, chi ni̱ kinde̱'é‑yá ña̱yɨvɨ‑yá. Te ni̱ nama‑ya̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Te onde̱ ini̱ ve̱'e mozo‑ya̱ David, ni̱ jani‑ya̱ ɨ́ɨn cha̱a kúñá'nu nama yóó. ");
INSERT INTO migNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nátu̱'un ni̱ kaka'a̱n cha̱a ndoo ni̱ ka̱jani tu̱'un‑ya̱ ní kikoyo‑de onde̱ xnáñúú, ");
INSERT INTO migNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ja̱ náma‑ya̱ yóó ini̱ nda'a cháa kájito u'u̱ yóó jíín núu̱ já kákiti̱ ini̱ kájito yóó. ");
INSERT INTO migNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Chi̱ kúndá'ú ini̱‑ya̱ táa̱‑yo̱. Te núku̱'un ini̱‑ya̱ tú'un ii̱ ní keyu'u‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tu̱'un‑ún ni̱ chísó tú'un téyíí‑yá nuu̱ Abraham, ja̱ kuá'a‑ya̱ núu̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ja̱ náma‑ya̱ yóó nuu̱ cháa kájito u'u̱ yóó. Te ma̱ yú'ú‑ga̱‑yo̱, kuatíñu‑yó núu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Jíín tíñu ndoo jíín tíñu ndaa̱ ta̱ká kɨvɨ̱ kúchaku̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Te róó su̱chí lúlí, kunání‑ró cháa jáni tu̱'un I'a̱ kúñá'nu xaa̱n, chi̱ kuxnúú‑ró kí'i̱n‑ro̱ íchi núu̱ máá Jito'o̱‑yo̱ náva̱'a sátu̱'a‑ró íchi‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Te kastu̱'ún‑ró núu̱ ñáyɨvɨ máá‑yá ja̱ náma‑ya̱‑í, jíín já kóo tu̱ká'nu ini̱ nuu̱ táká kua̱chi‑i. ");
INSERT INTO migNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chi̱ xaa̱n kúndá'ú ini̱ Dios yóó. Ja̱ yúán kúndiji̱n nuu̱‑yo̱ sá'a I'a̱ ñá'nu. ");
INSERT INTO migNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Náva̱'a kundiji̱n nuu̱ já ká'i̱in ñu̱ñáa jíín núu̱ já kákuni̱ naa. Yúan‑na te kuu kaka‑yó íchi vá'a, jíín íchi túu tu̱ndó'o, sá'a‑ya̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Te su̱chí lúlí‑ún, ni̱ ja'nu ndéé‑i, te ni̱ yija ini̱‑i. Te ni̱ kanchaa̱‑i onde̱ nuu̱ ñú'un té'é ondé kɨvɨ̱ ní stá'a̱n ndiji̱n‑i máá‑i nuu̱ ñáyɨvɨ Israel. ");
INSERT INTO migNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Te ni̱ kuu yaku̱ kɨvɨ̱. Te Augusto César, ni̱ jacha̱‑de tu̱'un ja̱ táká ña̱yɨvɨ ndútútú xiní‑í jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ya̱'á kúu ja̱ ní ndutútú núú xiní‑í. Te Cirenio ni̱ kuu‑de gobernador ñuu̱ Siria. ");
INSERT INTO migNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Te ta̱ká ña̱yɨvɨ‑ún, kája'a̱n‑i ndɨta'a̱n ñuu̱‑i ja̱ nákua̱'a‑i xini̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Te ja̱ yúán ní kenda José ini̱ ñuu̱ Nazaret, ndañúu̱ Galilea. Te ni̱ kaa‑de kua'a̱n‑de ñuu̱ Judea. Te ni̱ kɨ̱vɨ‑de ñuu̱ David ja̱ nání Belén. Chi̱ tá'an ini̱ ve̱'e David kúu‑de. ");
INSERT INTO migNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Náva̱'a nakua̱'a‑de xini̱‑dé jíín ñásɨ́'ɨ́‑de María, chi̱ a yani ta̱nda'a‑ñá jíín‑de, te ñú'un se̱'e‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Te nini ká'i̱in‑de yúan, te ni̱ ji̱nu kɨvɨ̱ skáku‑ña‑í. ");
INSERT INTO migNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Te ni̱ skáku‑ña sé'e yíí núú‑ña. Te ni̱ chisúkun‑ñá‑i, te ni̱ jaki̱n‑ña‑í ini̱ nu̱ndóó kɨ́tɨ, chi̱ tuká núña mesón. ");
INSERT INTO migNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Te suni ñuu̱ yúan íó cha̱a kándi̱to ñúú‑de rɨɨ̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Te yúan ni̱ kii ɨɨn ndajá'a̱ máá Tatá Dios nuu̱‑dé. Te káyu̱'ú xaa̱n‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Te ni̱ ka'a̱n máá ndájá'a̱‑yá jíín‑de: Ma̱ yú'ú‑ro̱ jíná'an‑ró, chi va̱i‑ri̱ kástu̱'ún‑rí ɨɨn tu̱'un va̱'a nuu̱‑ro̱, te kusɨɨ̱ iní ta̱ká ña̱yɨvɨ sá'a. ");
INSERT INTO migNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Chi̱ vina onde̱ ini̱ ñuu̱ David ni̱ kaku ɨɨn I'a̱ nama róó. Cristo máá Jito'o̱‑yo̱ kúu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Te kuni̱‑ro̱ já súan íó, chi̱ nani'i̱n‑ro̱ súchí yɨ́kɨ́n‑ún yísúkun‑í sa'ma te kátúu‑í ini̱ ɨɨn nu̱ndóó kɨ́tɨ. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Te sanaa‑ní te ni̱ kenda ɨɨn tɨku'ni̱ andɨ́vɨ́, ká'i̱in kua'a̱‑yá jíín ndájá'a̱‑yá‑ún, kánakana jaa‑ya̱ Dios, te káka'a̱n‑ya̱: ");
INSERT INTO migNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ná nákana jaa‑yó Dios onde̱ andɨ́vɨ́. Te ná ndúndéé iní ta̱ká ña̱yɨvɨ iní ñu̱yɨ́vɨ yá'a, sá'a Dios ja̱ kúsɨɨ̱ iní‑ya̱ jíín‑i, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yúan‑na te ndajá'a̱‑yá‑ún, ni̱ xndóo‑ya̱‑dé te káno'o̱n‑ya̱ ándɨ́vɨ́. Te máá cháa ndíto‑tɨ̱, káka'a̱n‑de: Ná kí'o̱n ondé Belén te kuni̱‑yo̱ na̱ún ní kuu. Chi̱ súan ni̱ kastu̱'ún máá Tatá Dios nuu̱‑yo̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Te yachi̱ kája'a̱n‑de. Te ni̱ kajini̱‑de nuu̱ María jíín José, jíín núu̱ súchí yɨ́kɨ́n‑ún kátúu‑í ini̱ nu̱ndóó kɨ́tɨ. ");
INSERT INTO migNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Te súan ni̱ kajini̱‑de nuu̱‑í. Te ni̱ kajacha̱‑de tu̱'un ndasa ni̱ kajini̱‑de sɨkɨ̱ súchí yɨ́kɨ́n‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Te ni̱ ka̱naa iní ta̱ká ña̱yɨvɨ ní ka̱jini so̱'o‑i tu̱'un káka'a̱n cha̱a kándi̱to rɨɨ̱. ");
INSERT INTO migNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ko María ni̱ chiva̱'a‑ña táká tu̱'un yá'a. Te náxndáa̱‑ña tú'un‑ún ini̱ añú‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Te ni̱ ka̱naxíó káva cha̱a kándi̱to rɨɨ̱, káno'o̱n‑de, kánakana jaa‑de Dios. Chi̱ ni̱ ka̱jini̱‑de ja̱ íó ndaa̱ ta̱ká tu̱'un ni̱ ka̱jini so̱'o‑de, nátu̱'un ni̱ ka'a̱n ndajá'a̱‑yá jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Te ni̱ kuu una̱ kɨvɨ̱. Te ni̱ xɨtɨ̱ ndúu̱ su̱chí yɨ́kɨ́n‑ún. Te ni̱ ka̱skúnání‑de‑i Jesús, chi̱ sɨ́'vɨ́‑ún ni̱ ka'a̱n ndajá'a̱‑yá ná té júku̱'un‑ga̱‑i núú. ");
INSERT INTO migNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yúan‑na te ni̱ ji̱nu kɨvɨ̱ ndúndoo‑ña, nátu̱'un ká'a̱n ley Moisés. Te ni̱ kaja̱ncha̱ka‑de‑i ñuu̱ Jerusalén náva̱'a stá'a̱n‑de‑i nuu̱ máá Tatá Dios. ");
INSERT INTO migNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Chi̱ yóso núu̱ tutú máá Tatá Dios: Ta̱ká su̱chí yíí káku núú, su̱chí‑ún, ná kúña ii̱‑í nuu̱ máá Tatá Dios, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Te suni soko̱‑dé uu̱ lɨ́'vɨ, xí úu̱ paloma, nátu̱'un ká'a̱n ley máá Tatá Dios. ");
INSERT INTO migNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Te yúan íó ɨɨn cha̱a ñuu̱ Jerusalén, nání‑de Simeón. Te cha̱a ndaa̱, cha̱a ndoo kúu‑de, te ñúkuu ini̱‑de chaa̱ I'a̱ ka'a̱n tu̱'un ndéé jíín ñáyɨvɨ Israel. Te Espíritu Santo jíka‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Chi̱ a ni̱ kastu̱'ún Espíritu Santo nuu̱‑dé ja̱ má kúu̱ kutɨ‑dé te nú tú kuni̱‑de nuu̱ Cristo máá Tatá Dios xna'a̱n‑ga̱. ");
INSERT INTO migNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Te ni̱ chaa̱‑de ini̱ ve̱'e ii̱, ni̱ sá'a Espíritu Santo. Yúan‑na te táa̱ su̱chí lúlí Jesús, ni̱ ka̱skɨ́vɨ‑de‑i ini̱ ve̱'e ii̱, ja̱ sá'a‑de jíín‑i nátu̱'un ká'a̱n ley. ");
INSERT INTO migNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Te Simeón, ni̱ junu nchaa̱‑de‑i. Te ni̱ nakana jaa‑de Dios. Te ni̱ ka'a̱n‑de: ");
INSERT INTO migNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ai̱ Táta̱, sía̱‑ní mozo‑ní ná kí'i̱n‑de, nátu̱'un ni̱ ka'a̱n‑ní, chi̱ ni̱ kuva̱'a ini̱‑ná vina. ");
INSERT INTO migNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chi ni̱ jini̱ jíín núu̱‑ná ja̱ náma‑ní yóó. ");
INSERT INTO migNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Chi yu̱án ní sátu̱'a‑ní jíto nuu̱ táká ña̱yɨvɨ, ");
INSERT INTO migNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","náva̱'a ná kúndiji̱n nuu̱ ñáyɨvɨ sɨ́ɨn nación, te nduñá'nu ña̱yɨvɨ máá‑ní Israel, sá'a‑ní. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Te José jíín náa̱‑i, kánaa iní‑de kájini so̱'o‑de tu̱'un‑i ndasa ká'a̱n cha̱a‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Te ni̱ jika̱n ta'u̱ Simeón ja'a̱‑dé jíná'an‑de. Te ni̱ ka'a̱n‑de jíín náa̱‑i María: Su̱chí yá'a va̱i‑i ja̱ nduá te ndonda kua'a̱ ñáyɨvɨ Israel sá'a‑i. Te státá'an ña̱yɨvɨ já sɨkɨ́‑í. ");
INSERT INTO migNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Náva̱'a ná kénda ndiji̱n ndasa kájani ini̱ kua'a̱ ñáyɨvɨ. Te ɨɨn yuchi̱ kui̱so ini̱ añú‑ro̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Te suni kándee Ana yúan, ña'an jáni tu̱'un Dios kúu‑ña, se̱'e Fanuel tata̱ Aser kúu‑ña. Te a ni̱ yii‑ña chi̱ onde̱ ná jáá‑ña te ni̱ kanchaa̱‑ña jíín yíi‑ñá usia̱ kuia̱. ");
INSERT INTO migNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Te ni̱ kendo̱o ndá'ú‑ña ondé ni̱ ji̱nu‑ña kúu̱n xíko kuu̱n kuiá‑ña. Te tú kúxio‑ña iní ve̱'e ii̱, chi̱ sua játíñu‑ña ndúú ñúú. Te ndicha̱ ini̱‑ña. Te jikán ta'u̱‑ñá. ");
INSERT INTO migNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Te suni hora‑ún ni̱ chaa̱‑ña, ni̱ nakana jaa‑ña Dios. Te ni̱ ka'a̱n‑ña tú'un su̱chí yɨ́kɨ́n‑ún nuu̱ táká ña̱yɨvɨ káñukuu ini̱‑i kenda ɨɨn cha̱a nama‑de ñuu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Te ni̱ kuu ni̱ skíkuu‑de ta̱ká tiñu ká'a̱n ley máá Tatá Dios. Te káno'o̱n‑de ñuu̱‑de Nazaret ndañúu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Te su̱chí lúlí‑ún, ni̱ ja'nu ndéé‑i, te ni̱ yija‑i, te ni̱ kundíchí xáa̱n‑í, te ni̱ kusɨɨ̱ iní Dios jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Te ndɨta'a̱n kuia̱ kája'a̱n táa̱‑i ñuu̱ Jerusalén, ja̱ ndé'é‑de viko Pascua yúan. ");
INSERT INTO migNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Te nuu̱ ní kuu uxi̱ uu̱ kuia̱‑i, te ni̱ ka̱kaa táa̱‑i kája'a̱n‑de ñuu̱ Jerusalén, nátu̱'un kásá'a máá‑de kɨvɨ̱ víko‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Te ni̱ ji̱nu kɨvɨ̱ víko‑ún, te káno'o̱n‑de. Te su̱chí lúlí Jesús ni̱ kendo̱o‑i ini̱ ñuu̱ Jerusalén, ni tú ní kájini̱ táa̱‑i náa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Te kájani ini̱‑de ja̱ ndé kándee nduu̱‑i ma̱'ñú ñáyɨvɨ káno'o̱n ichi‑ún. Te ni̱ ka̱jika‑de ɨɨn kɨvɨ̱ ncháka, te vásá ní ka̱nandúkú‑de‑i ma̱'ñú táká tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ko tú ní kánani'i̱n‑dé‑i, te ni̱ ka̱naxíó káva‑de káno'o̱n‑de ñuu̱ Jerusalén, kua̱nandúkú‑de‑i. ");
INSERT INTO migNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Te onde̱ nuu̱ uní kɨvɨ̱ te vásá ní ka̱nani'i̱n‑dé‑i ini̱ ve̱'e ii̱, kánchaa̱‑i ma̱'ñú cháa kákuu maestro, jíni ná'ín‑i, te xndichí‑i‑de. ");
INSERT INTO migNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Te ta̱ká ja̱ kájini so̱'o tu̱'un ká'a̱n‑i‑ún, ni̱ ka̱naa iní kánde̱'é núu̱‑í ja̱ bueno ndito xini̱‑í, te va̱'a xndíó káni‑i tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Te nuu̱ ní kajini̱‑de nuu̱‑í, te ni̱ ka̱naa iní‑de kánde̱'é‑de. Te ni̱ ka'a̱n náa̱‑i jíín‑i: Hijo, naja̱ sá'a‑ró súan jíín‑rí, chi̱ táa̱‑ro̱ jíín rúu̱, kánandúkú xáa̱n‑rí róó te kándukuí'a̱ ini̱‑ri̱, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yúan‑na te ni̱ kachi̱‑i jíín‑ña: Na̱ún ní kuu, náa̱. Naja̱ kánandúkú‑ní náá. Tú kájini̱‑ní ja̱ jínu ñú'ún kúkuu‑ná jíín tíñu Táa̱‑ná náún. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ko máá‑ña, tú ní kájuku̱'un ini̱‑ña tú'un ni̱ ka'a̱n‑i jíín‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Te ni̱ nuu‑i kua̱no'on‑í jíín‑de jíná'an‑de. Te ni̱ najaa̱‑i ñuu̱ Nazaret, jándatu̱‑i nuu̱‑dé. Te náa̱‑i ni̱ chiva̱'a va̱'a‑ña táká tu̱'un yá'a ini̱ añú‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Te Jesús, ni̱ ja'nu‑ga̱‑i, te ni̱ kundíchí‑ga̱‑i. Te Dios jíín táká ña̱yɨvɨ, ni̱ ka̱kusɨɨ̱‑gá ini̱ jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Te nuu̱ xiá'u̱n kuia̱ ja̱ tá'ú tíñu cha̱a Tiberio César, te Poncio Pilato kúu‑de gobernador ñuu̱ Judea. Te Herodes tá'ú‑de tiñu ñuu̱ Galilea. Te ñani̱‑de Felipe tá'ú tíñu ñuu̱ Iturea ndañúu̱ Traconite. Te Lisanias tá'ú tíñu‑de ñuu̱ Abilinia. ");
INSERT INTO migNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Te sutu̱ ñá'nu kákuu Anás jíín Caifás, te ni̱ chaa̱ tu̱'un máá Tatá Dios nuu̱ Juan, se̱'e Zacarías kánchaa̱‑de nuu̱ ñú'un té'é. ");
INSERT INTO migNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Te ni̱ kii‑de ni̱ jíkó núu‑de nɨ́ɨ́ ñúu̱ Jordán. Te jáni‑de tu̱'un jánducha, jíín tú'un nakani ini̱ náva̱'a sá'a Dios tu̱ká'nu ini̱ nuu̱ kuáchi. ");
INSERT INTO migNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Te súan ni̱ chaa Isaías tutu̱, chi cha̱a jáni tu̱'un Dios ni̱ kuu‑de sáá: Ɨɨn ndajá'a̱, kana jaa‑de onde̱ nuu̱ ñú'un té'é: Sátu̱'a‑ró íchi máá Jito'o̱‑yo̱, te sándóó‑ró íchi‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ta̱ká yi'ndɨ̱ nachítú. Te nuu ta̱ká yuku jíín tɨ́nduu̱. Te ndundóó íchi yákuá. Te ichi ndáí ndulɨɨ. ");
INSERT INTO migNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Te ta̱ká ña̱yɨvɨ, kuni̱‑i ja̱ Dios nama‑ya̱‑í. Achí. ");
INSERT INTO migNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Te ni̱ kenda koyo kua'a̱ ñáyɨvɨ núu̱‑dé ja̱ skuánducha‑dé‑i. Te ni̱ ka'a̱n‑de jíín‑i: Se̱'e koo̱ kákuu‑ró. Ndéja̱ ní kastu̱'ún núu̱‑ro̱ já kúnu‑ró kóto‑ró juicio chaa̱. ");
INSERT INTO migNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Núsáá te sá'a‑ró tíñu sɨkɨ̱ já á ni̱ nakani ini̱‑ro̱‑ún. Te ma̱ kéjá'á‑ró káni ini̱‑ro̱: Abraham kúu táa̱‑ri̱, achí‑ro̱. Chi̱ ká'a̱n‑ri̱ jíín‑ró ja̱ kúu‑ni sá'a Dios ja̱ táká yuu̱ yá'a nduu se̱'e Abraham. ");
INSERT INTO migNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Te vina a kátúu tú'a hacha ja̱ xɨ́tɨ yúnu ondé yo'o. Te ta̱ká yunu já tú kúun nde'e̱ vá'a xini̱, xɨtɨ̱ te kɨ̱vɨ nuu̱ ñú'u̱n. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Te ña̱yɨvɨ kuá'a̱‑ún, ni̱ kajika̱ tu̱'ún‑i‑de: Te ndasa sá'a‑ná núsáá, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Te ni̱ ka'a̱n‑de: Ja̱ ñáva̱'a uu̱ su'nu̱, ná kuá'a nuu̱ já tú ñáva̱'a kutɨ. Te ja̱ ñáva̱'a ja̱ kée, suni súan ná sá'a, áchí‑de jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Te suni ni̱ cha̱koyo yaku̱ cha̱a xíní já kuánducha‑dé. Te ni̱ kaka'a̱n‑de jíín Juan: Maestro, te náá, na̱ún sá'a‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Te ni̱ ka'a̱n‑de jíín: Ma̱ skáa‑ró kakán‑ro̱ ndasa ni̱ ta'u̱ tíñu nuu̱‑ro̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Te suni yaku̱ soldado, ni̱ kajika̱ tu̱'ún yúan‑de: Te náá, ndasa sá'a‑ná jíná'an‑ná, áchí. Te ni̱ ka'a̱n‑de jíín: Ma̱ kuánchaa̱‑ro̱ ndátíñu tá'an‑ró, ni ma̱ sátú'ún‑ró, te koo sɨɨ̱‑ní ini̱‑ro̱ jíín yá'u‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Te kájani ini̱ ta̱ká cha̱a sɨkɨ̱ Juan ja̱ sánaa te kúu‑de Cristo xí túu, chi ña̱yɨvɨ‑ún, káinda̱tu‑i chaa̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Te ni̱ ka'a̱n Juan: Ruu̱, chi̱ jíín ndúcha skuánducha ndíja‑ri̱ róó. Ko va̱i ɨɨn I'a̱ kúñá'nu‑ga̱ vásá rúu̱, ja̱ tú kúñá'nu‑ri̱ ndájí‑rí ñii yí'i ndija̱n‑yá. Máá‑yá, chi̱ jíín Espíritu Santo skuánducha‑yá róó jíín ñú'u̱n. ");
INSERT INTO migNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Te tɨ́ɨn‑ya̱ pala chíxí'ú trigo. Te nasándoo va̱'a‑ya̱ era‑ya̱. Te nastútú‑yá trigo ndɨ̱vɨ ini̱ yaka̱‑ya̱. Te ka'mu‑ya̱ paja nuu̱ ñú'u̱n ja̱ má ndá'va̱ kutɨ‑gá. ");
INSERT INTO migNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Te kua'a̱‑gá tu̱'un ni̱ ka'a̱n xaa̱n‑dé nuu̱ ñáyɨvɨ‑ún. Chi̱ súan ni̱ jani‑de tu̱'un va̱'a‑ya̱ núu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Te suni ni̱ ka'a̱n xaa̱n‑dé nuu̱ Herodes, cha̱a tá'ú tíñu‑ún. Chi cha̱a‑ún, ni̱ jaka‑de Herodías, ñasɨ́'ɨ́ ñani̱‑de Felipe. Te kua'a̱‑gá tiñu ñáá súan ni̱ sá'a Herodes. ");
INSERT INTO migNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Te ja̱ ví'í‑gá ni̱ sá'a‑de kúu ja̱ ní chindee‑de Juan veka̱a. ");
INSERT INTO migNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Te nuu̱ ní ndɨ'ɨ ni̱ ka̱janducha ñáyɨvɨ, te suni ni̱ janducha Jesús. Te nini jikán ta'u̱‑yá, te ni̱ nuña‑ni andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Te nátu̱'un forma paloma ni̱ jungava Espíritu Santo sɨkɨ̱‑yá. Te ichi ándɨ́vɨ́ ní kenda ɨɨn tu̱'un ni̱ ka'a̱n: Máá‑ró kúu Se̱'e‑ri̱ te kúndá'ú ini̱‑ri̱ róó. Te kúsɨɨ̱ iní‑ri̱ jíín‑ró. Achí. ");
INSERT INTO migNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Te ná ni̱ kejá'á Jesús stá'a̱n‑ya̱ tú'un, íó‑ya̱ okó uxi̱ kuia̱. Te kájani ini̱ ña̱yɨvɨ já sé'e José kúu‑ya̱. Te táa̱ José ni̱ kuu Elí, ");
INSERT INTO migNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ja̱ kúu se̱'e Matat, se̱'e Leví, se̱'e Melqui, se̱'e Jana, se̱'e José, ");
INSERT INTO migNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ja̱ kúu se̱'e Matatías, se̱'e Amós, se̱'e Nahum, se̱'e Esli, se̱'e Nagai, ");
INSERT INTO migNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ja̱ kúu se̱'e Maat, se̱'e Matatías, se̱'e Semei, se̱'e José, se̱'e Judá, ");
INSERT INTO migNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ja̱ kúu se̱'e Joana, se̱'e Resa, se̱'e Zorobabel, se̱'e Salatiel, se̱'e Neri, ");
INSERT INTO migNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ja̱ kúu se̱'e Melqui, se̱'e Adi, se̱'e Cosam, se̱'e Elmodam, se̱'e Er, ");
INSERT INTO migNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ja̱ kúu se̱'e Josué, se̱'e Eliezer, se̱'e Jorim, se̱'e Matat, ");
INSERT INTO migNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ja̱ kúu se̱'e Leví, se̱'e Simeón, se̱'e Judá, se̱'e José, se̱'e Jonán, se̱'e Eliaquim, ");
INSERT INTO migNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ja̱ kúu se̱'e Melea, se̱'e Mainán, se̱'e Matata, se̱'e Natán, ");
INSERT INTO migNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ja̱ kúu se̱'e David, se̱'e Isaí, se̱'e Obed, se̱'e Booz, se̱'e Salmón, se̱'e Naasón, ");
INSERT INTO migNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ja̱ kúu se̱'e Aminadab, se̱'e Aram, se̱'e Esrom, se̱'e Fares, se̱'e Judá, ");
INSERT INTO migNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ja̱ kúu se̱'e Jacob, se̱'e Isaac, se̱'e Abraham, se̱'e Taré, se̱'e Nacor, ");
INSERT INTO migNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ja̱ kúu se̱'e Serug, se̱'e Ragau, se̱'e Peleg, se̱'e Heber, se̱'e Sala, ");
INSERT INTO migNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ja̱ kúu se̱'e Cainán, se̱'e Arfaxad, se̱'e Sem, se̱'e Noé, se̱'e Lamec, ");
INSERT INTO migNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ja̱ kúu se̱'e Matusalén, se̱'e Enoc, se̱'e Jared, se̱'e Mahalaleel, se̱'e Cainán, ");
INSERT INTO migNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ja̱ kúu se̱'e Enós, se̱'e Set, se̱'e Adán, se̱'e Dios. ");
INSERT INTO migNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Te Jesús, ni̱ chítú ndɨ́ɨ‑yá jíín Espíritu Santo. Te ni̱ ndenda‑ya̱ yúcha Jordán kua'a̱n‑ya̱. Te ni̱ jaa̱‑ya̱ ondé nuu̱ ñú'un té'é ní sá'a Espíritu Santo. ");
INSERT INTO migNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Te yúan ni̱ kanchaa̱‑ya̱ úu̱ xiko kɨvɨ̱. Te ni̱ jito nchaa̱ tá'an kui'na̱ jíín‑yá. Te ta̱ká kɨvɨ̱‑ún, tú ní yée kútɨ‑yá, chi̱ onde̱ ni̱ ja̱'a kɨvɨ̱, te vásá ni̱ ji'i̱‑ya̱ sóko. ");
INSERT INTO migNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yúan‑na te ni̱ kachi̱ kui'na̱‑ún jíín‑yá: Nú Se̱'e Dios kúu‑ró, ka'a̱n jíín yúu̱ yá'a ná ndúu staa̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Te Jesús ni̱ ka'a̱n‑ya̱ jíín: Yóso núu̱ tutú: Nasu̱ máni máá stáa̱ kée cháa te kuchaku̱‑de, chi̱ sua jíín tú'un Dios, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Te ni̱ jaka kui'na̱‑ún‑ya̱ kuá'a̱n jíín‑yá xini̱ ɨ́ɨn yuku súkún. Te ɨɨn núnúu‑ni te ni̱ stá'a̱n‑ni ta̱ká ñuu̱ nɨ́ɨ́ ñúyɨ́vɨ núu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Te ni̱ kachi̱ kui'na̱‑ún jíín‑yá: Kua̱'a‑ri̱ ta̱ká ñuu̱ luu yá'a nuu̱‑ro̱ te tá'ú tíñu‑ró núu̱. Chi̱ máá‑rí tɨ́ɨn ndɨ'ɨ, te ndé nuu̱ kuní‑ri̱, te kuu kua̱'a‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Núsáá te nú chiñú'ún‑ró rúu̱, te kua̱'a‑ri̱ ta̱ká ñuu̱ yá'a nuu̱‑ro̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Te ni̱ ka'a̱n Jesús: Satanás, kuxio kuá'án, chi̱ yóso núu̱ tutú: Chiñú'ún‑ró máá Tatá Dios máá‑ró, te nuu̱ máá ɨ́ɨn‑ni‑ya̱ kuátíñu‑ró, áchí. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Te kua'a̱n tuku jíín‑yá ñuu̱ Jerusalén. Te yúan ni̱ kaa jíín‑yá xini̱ torre ve'e ii̱. Te ni̱ ka'a̱n jíín‑yá: Te nú Se̱'e Dios kúu‑ró, te súngava‑ró máá‑ró yá'a te onde̱ nuu̱ ñú'un, ");
INSERT INTO migNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","chi̱ yóso núu̱ tutú: Tájí‑yá ndajá'a̱‑yá kii te koto‑ya̱ róó. ");
INSERT INTO migNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kunu nchaa̱‑ya̱ róó náva̱'a tú stují‑ro̱ já'a̱‑ro̱ núu̱ yúu̱, áchí. Achí kui'na̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Te ni̱ ka'a̱n Jesús: A yóso núu̱ tutú: Ma̱ kóto nchaa̱‑ro̱ máá Tatá‑ro̱ Dios, áchí‑ya̱ jíín kuí'na̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Te ni̱ ndɨ'ɨ ni̱ jito nchaa̱ kui'na̱‑ún‑ya̱. Te ni̱ kuxio núu‑ni kua'a̱n. ");
INSERT INTO migNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Te jíín fuerza Espíritu kua̱no'on Jesús ñuu̱ Galilea. Te ni̱ jicha̱ tu̱'un‑ya̱ nɨ́ɨ́ ndáñúu̱ yani yúan. ");
INSERT INTO migNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Te ni̱ stá'a̱n‑ya̱ tú'un ini̱ ve̱'e sinagoga ña̱yɨvɨ yúan. Te ni̱ ka̱nakana jaa ndɨ'ɨ‑i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Te ni̱ jaa̱‑ya̱ ñúu̱ Nazaret, nuu̱ ní ja'nu‑ya̱. Te ni̱ kɨ̱vɨ‑ya̱ iní ve̱'e sinagoga nátu̱'un sá'a‑ya̱ táká kɨvɨ̱ ndéta̱tú. Te ni̱ ndukuiñi̱‑ya̱ ní ka'u‑ya̱ ɨ́ɨn tutu̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Te yúan íó tutu̱ Isaías cha̱a ni̱ jani tu̱'un Dios onde̱ sáá. Te ni̱ kaja̱'a‑de nuu̱ Jesús. Te ni̱ janu̱‑ya̱ tutú‑ún. Te ni̱ jini̱‑ya̱ ɨ́ɨn nuu̱ yóso, te ni̱ ka'u‑ya̱: ");
INSERT INTO migNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu máá Tatá Dios jíka‑ya̱ jíín‑rí, chi ni̱ teta'a̱n‑ya̱ rúu̱ náva̱'a kani‑ri̱ tu̱'un va̱'a nuu̱ ñáyɨvɨ ndá'ú. Te ni̱ tájí‑yá ruu̱ va̱i‑ri̱ náva̱'a sá'a‑ri̱ tana̱ ñáyɨvɨ kákukuí'a̱ ini̱, te kastu̱'ún‑rí nuu̱ ñáyɨvɨ káindasu̱ koo libre‑i. Te ta̱ká ña̱yɨvɨ kuáá, ndundiji̱n nuu̱‑í, te nama‑ri̱ ña̱yɨvɨ ní katuji̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Te náva̱'a kani‑ri̱ tu̱'un sɨkɨ̱ kuiá játa'a̱n ini̱ máá Tatá Dios, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Te ni̱ na̱tuu‑yá tutu̱‑ún. Te ni̱ nakua̱'a‑ya̱ núu̱ cháa játíñu. Te ni̱ nungo̱o‑ya̱. Te ta̱ká cha̱a ká'i̱in ini̱ ve̱'e sinagoga, kánde̱'é vá'a‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín‑de: Vina a ni̱ ka̱jini so̱'o‑ró já ní skíkuu tu̱'un ká'a̱n tutu̱ ii̱ yá'a, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Te ndivii‑dé ni̱ kaka'a̱n va̱'a‑de tu̱'un‑ya̱. Te kánaa iní‑de kánde̱'é‑de nuu̱‑yá ja̱ lúu ká'a̱n‑ya̱. Te ni̱ kaka'a̱n‑de: Á nasu̱ sé'e José kúu cha̱a yá'a. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Jáni ini̱‑ri̱ ja̱ sánaa te ka'a̱n‑ro̱ tú'un yátá yá'a jíín‑rí: Cha̱a táná, sá'a tana̱ máá‑ró, te ta̱ká tiñu ni̱ ka̱jini tu̱'un‑ri̱ ni̱ sá'a‑ró ñúu̱ Capernaum, suni súan ná sá'a‑ró ñúu̱‑ro̱ yá'a vii̱, achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Te ni̱ ka'a̱n‑ga̱‑ya̱: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ ñáyɨvɨ máá ñúu̱ cha̱a jáni tu̱'un Dios, máá‑i kúu ja̱ tú kájatá'ú‑i‑de. ");
INSERT INTO migNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ ní i̱o kua'a̱ ñá'an ní kendo̱o ndá'ú ñuu̱ Israel kɨvɨ̱ ní chaku̱ Elías, te kɨvɨ̱‑ún ni̱ ndasu̱ andɨ́vɨ́ uní kuia̱ iñu̱ yoo̱. Te ni̱ i̱o ɨɨn tama̱ xáa̱n nɨ́ɨ́‑ni ñuu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ko tú ní tájí‑yá Elías ki'i̱n‑de nuu̱ ní ɨɨn ña'an‑ún, chi̱ máá‑ni onde̱ ñuu̱ Sarepta ndañúu̱ Sidón ni̱ ja'a̱n‑de nuu̱ ɨ́ɨn ña'an ní kendo̱o ndá'ú. ");
INSERT INTO migNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Te ini̱ ñuu̱ Israel, suni ni̱ i̱o kua'a̱ cháa ni̱ kate'yu̱ ndɨ̱'yi, kɨvɨ̱ ní chaku̱ Eliseo, cha̱a ni̱ jani tu̱'un Dios. Ko tú ni ɨɨn cha̱a‑ún ní ndúndoo, chi̱ máá‑ni Naamán, cha̱a ñuu̱ Siria. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yúan‑na te ta̱ká cha̱a ká'i̱in ini̱ ve̱'e sinagoga, ni̱ kakiti̱ ini̱‑de ja̱ ní ka̱jini so̱'o‑de tu̱'un ká'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Te ni̱ ka̱ndonda‑de sɨkɨ̱‑yá ni̱ ka̱kiñi'in‑de‑ya̱ yatá ñúu̱‑ún, te kua'a̱n‑de jíín‑yá xini̱ yúku núu̱ kándii̱ ñuu̱‑de. Te yúan súngava‑de‑ya̱ kákuni̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ko máá‑yá, ni̱ ja̱'a‑ya̱ má'ñú‑de, te kua'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Te ni̱ najinu̱‑ya̱ ñúu̱ Capernaum, ndañúu̱ Galilea. Te ni̱ stá'a̱n‑ya̱ tú'un nuu̱‑dé jíná'an‑de ndɨta'a̱n kɨvɨ̱ ndéta̱tú. ");
INSERT INTO migNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Te ni̱ ka̱naa iní‑de kájini so̱'o‑de tu̱'un stá'a̱n‑ya̱, chi̱ ni̱ stá'a̱n‑ya̱ nátu̱'un ɨɨn cha̱a ndíso tíñu. ");
INSERT INTO migNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Te ini̱ ve̱'e sinagoga kándee ɨɨn cha̱a tá'a̱n tachi̱ kíni. Te cha̱a‑ún, ni̱ kana kó'ó‑de: ");
INSERT INTO migNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Kuxio‑ní Táta̱, chi̱ tú káyi̱tá'an‑ná jíín‑ní, Jesús ñuu̱ Nazaret. Va̱i‑ní xnáa‑ní náá náún. A jiní‑ná na̱ níí kúu, cha̱a ndoo nuu̱ Dios. Achí. ");
INSERT INTO migNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Te Jesús, ni̱ ka'a̱n xaa̱n‑yá jíín: Kasu̱ yu'u‑ro te kenda‑ró‑de, áchí‑ya̱. Yúan‑na te ni̱ ndua̱‑ni cha̱a‑ún ma̱'ñú ñáyɨvɨ, ni̱ sá'a tachi̱ kíni‑ún. Te ni̱ kenda kua'a̱n ini̱‑de. Te tú na̱ún ní sá'a jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Te ndivii‑í, ni̱ kayu̱'ú‑i. Te kándatu̱'ún‑i: Na̱ún tu̱'un kúu ya̱'á. Chi̱ ndíso tíñu‑de ja̱ tá'ú ní'in‑de tiñu nuu̱ tachí kíni te kénda koyo, káka'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Te tu̱'un‑ya̱ ní jicha̱ nu̱u kua'a̱n ta̱ká lado ndañúu̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yuán‑na te ni̱ ndukuiñi̱ Jesús, ni̱ kenda‑ya̱ iní ve̱'e sinagoga. Te ni̱ kɨ̱vɨ‑ya̱ vé'e Simón. Te náchi̱só Simón, yí'i xaa̱n kíji‑ña. Te ni kaka'a̱n nda̱'ú‑de jíín‑yá ndasa kuu‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Te ni̱ kandita‑ya̱ núu̱‑ñá, te ni̱ ka'a̱n xaa̱n‑yá nuu̱ kíji‑ún. Te ni̱ kee‑ni ki̱ji‑ún‑ña. Te ni̱ nduko̱o‑ni‑ña. Te ni̱ jatíñu‑ña núu̱‑yá jíná'an‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Te kuake̱e ndika̱ndii, te ta̱ká ja̱ káñava̱'a ña̱yɨvɨ káku'u̱ tɨnɨ̱ nuu̱ kué'e̱, ni̱ ka̱kinchaka‑i nuu̱‑yá. Te ni̱ xndée‑ya̱ ndá'a‑yá sɨkɨ̱ ɨ́ɨn ɨɨn‑i te ni̱ nasáva̱'a‑ya̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Te suni ini̱ kua'a̱ ñáyɨvɨ ní ka̱kenda tachi̱ kíni. Te ni̱ ka̱kana kó'ó: Máá‑ní kúu Se̱'e Dios, áchí. Ko ni̱ ka'a̱n xaa̱n‑yá jíín. Te tú ní já'a‑ya̱ tú'un ka'a̱n. Chi̱ a kájini̱ ja̱ máá‑yá kúu Cristo. ");
INSERT INTO migNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Te ni̱ kundiji̱n. Te ni̱ kenda‑ya̱ kuá'a̱n‑ya̱ ɨ́ɨn nuu̱ ñú'un té'é. Te ña̱yɨvɨ kánandúkú‑i‑ya̱, ni̱ ja̱koyo‑i nuu̱‑yá. Te kásténdatu‑i‑ya̱ náva̱'a tú kuxio‑ya̱ núu̱‑í núú. ");
INSERT INTO migNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ko máá‑yá ni̱ ka'a̱n‑ya̱ jíín‑i: Jínu ñú'ún já súni nuu̱ sáva‑ga̱ ñuu̱ kani‑ri̱ tu̱'un va̱'a ñuu̱ nuu̱ tá'ú Dios tiñu. Chi yu̱án ní tájí‑yá ruu̱ va̱i‑ri̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Te jáni‑ya̱ tú'un ini̱ ve̱'e sinagoga ñuu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Te ni̱ kuu ja̱ kándee Jesús yu'u mar Genesaret. Te ña̱yɨvɨ, ni̱ kajaxi̱n‑i‑ya̱ já ndúkú‑i kuni so̱'o‑i tu̱'un Dios. ");
INSERT INTO migNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Te ni̱ jini̱‑ya̱ úu̱ barco ká'i̱in yani yu'u mar. Te cha̱a kátɨɨn ti̱yáká, a ni̱ ka̱kenda‑de ini̱ barco. Te kánakacha‑de ñunu‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Te ni̱ kɨ̱vɨ‑ya̱ iní barco Simón. Te ni̱ ka'a̱n‑ya̱ jíín‑de ja̱ ná skáka‑de ɨɨn tí'li̱ kuxio nuu̱ ñú'un. Te ni̱ jungo̱o‑ya̱. Te onde̱ ini̱ barco ni̱ stá'a̱n‑ya̱ tú'un nuu̱ ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Te nuu̱ ní ji̱nu ni̱ ka'a̱n‑ya̱, te ni̱ kachi̱‑ya̱ jíín Simón: Ná chó'o̱ núu̱ kúnú ndúcha, te skuíta ka'nu‑ró ñúnu‑ro, te tɨɨn‑ró tíyáká, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Te ni̱ ka'a̱n Simón: Maestro, nɨ́ɨ́ niñú ni̱ ka̱sátiñu‑ná, ko tú ni ɨɨn ní kátɨɨn kutɨ‑ná. Ko ja̱ ká'a̱n máá‑ní kúu, te ná skuíta ka'nu‑ná ñunu‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Te ni̱ sá'a‑de súan. Te ni̱ jasu̱‑de ti̱yáká kuá'a̱ xáa̱n iní ñunu‑dé. Te ñunu‑dé ndúkú té'nde̱ núú. ");
INSERT INTO migNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Te ni̱ ka̱sá'a‑de seña nuu̱ tá'an‑de, ká'i̱in ini̱ ɨnga̱ barco, ná kíi chindéé tá'an jíín‑de. Te ni̱ cha̱koyo‑de. Te ni̱ ka̱schítú ndɨ́ɨ‑dé‑tɨ̱ iní ndendúú barco ja̱ kuní ke̱e barco‑ún chi̱i nducha núú. ");
INSERT INTO migNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Te Simón Pedro, ni̱ jini̱‑de ja̱ súan ni̱ kuu. Te ni̱ jukuiñi̱ jítɨ́‑de nuu̱ Jesús, te ni̱ ka'a̱n‑de: Kuxio‑ní Táta̱, chi cha̱a íó kua̱chi kúu‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chi̱ máá‑de jíín táká ja̱ ní ka̱chindéé tá'an jíín‑de‑ún, ni̱ ka̱naa iní‑de kánde̱'é‑de ja̱ ní katɨɨn‑de ti̱yáká‑ún, ");
INSERT INTO migNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","te suni súan Jacobo jíín Juan, ndendúú se̱'e Zebedeo, chi cha̱a káchindéé tá'an jíín Simón kákuu‑de. Te ni̱ kachi̱ Jesús jíín Simón: Ma̱ yú'ú‑ro̱. Onde̱ vina te tɨɨn‑ró cháa. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yúan‑na te nuu̱ ní ka̱ndenda barco nuu̱ ñú'un íchí, te ni̱ ka̱xndóo ndɨ'ɨ‑de ndatíñu‑de. Te ni̱ kandiki̱n‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Te Jesús, kándee‑ya̱ ɨ́ɨn ñuu̱. Te ni̱ jaa̱ ɨɨn cha̱a nuu̱‑yá, té'yu̱ ndɨ̱'yi‑de. Te cha̱a‑ún, ni̱ jini̱‑de nuu̱ Jesús. Te ni̱ jukuiñi̱ jítɨ́‑de. Te ni̱ ka'a̱n nda̱'ú‑de jíín‑yá: Táta̱, nú kuní‑ní te kuu nasándoo‑ní náá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yúan‑na te ni̱ skáa̱‑ya̱ ndá'a‑yá. Te ni̱ ké'é‑yá‑de. Te ni̱ ka'a̱n‑ya̱: Kuní‑ri̱, ná ndúndoo‑ró, áchí‑ya̱. Te ndɨ̱'yi té'yu̱‑ún, ni̱ kuxio‑ni kua'a̱n. ");
INSERT INTO migNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Te ni̱ ka'a̱n xaa̱n‑yá jíín‑de: Ma̱ kachí kutɨ‑ro núu̱ ní ɨɨn. Chi̱ kuá'án, te stá'a̱n‑ro̱ máá‑ró núu̱ sutú. Te kundá'á‑ró ndátíñu stá'a̱n‑ro̱ núu̱‑dé, náva̱'a kuni̱‑de ja̱ ní ndundoo‑ró, nátu̱'un ni̱ tá'ú Moisés tiñu sáá. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ko tu̱'un‑ya̱‑ún, ni̱ jicha̱‑ga̱ kua'a̱n. Te ni̱ kataka̱ kua'a̱ xáa̱n ñáyɨvɨ já kúni ná'ín‑i, te nduva̱'a‑i ta̱ká kue'e̱ káta'a̱n‑i kákuni̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Te máá‑yá, ni̱ kusɨ́ɨn‑ya̱ kuá'a̱n‑ya̱ ondé ñu'un té'é. Te yúan ni̱ jika̱n ta'u̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Te ɨɨn kɨvɨ̱ kándee Jesús stá'a̱n‑ya̱ tú'un. Te cha̱a fariseo jíín maestro ley, káxiu̱kú‑de yúan. Te cha̱a‑ún, ni̱ kikoyo‑de ichi táká ñuu̱ Galilea ndañúu̱ Judea jíín ñúu̱ Jerusalén. Te fuerza máá Tatá Dios kándee jíín‑yá náva̱'a nasáva̱'a‑ya̱ ñáyɨvɨ kú'u̱. ");
INSERT INTO migNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Te ni̱ chaa̱ yaku̱ cha̱a, te nuu̱ ɨ́ɨn ji̱to yuu kándi̱so‑de ɨɨn cha̱a ni̱ kuyúnú. Te kándúkú‑de skɨ́vɨ‑de cha̱a‑ún nuu̱ kándee‑ya̱, te kani‑de cha̱a‑ún nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Te ja̱ kuá'a̱ ñáyɨvɨ, te tú ní káni'i̱n‑dé ndénu̱ skɨ́vɨ‑de cha̱a‑ún. Yúan‑na te ni̱ ka̱kaa‑de xini̱ vé'e. Te yúan ni̱ ka̱xndónda‑de teja, te ni̱ ka̱skúun‑de cha̱a‑ún nuu̱ Jesús sava ma̱'ñú jíín jíto yuu. ");
INSERT INTO migNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Te ni̱ jini̱‑ya̱ já kákandíja cha̱a‑ún. Te ni̱ ka'a̱n‑ya̱ jíín cháa ni̱ kuyúnú‑ún: Súchi̱, a íó tu̱ká'nu ini̱ nuu̱ táká kua̱chi‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yúan‑na te cha̱a káchaa tutu̱ jíín cháa fariseo, ni̱ kejá'á‑de kájani ini̱‑de: Ndé cha̱a kúu ya̱'á ja̱ ká'a̱n tu̱'un ndɨva̱'a. Ndéja̱ kúu sá'a tu̱ká'nu ini̱ nuu̱ kuáchi, chi̱ ɨɨn‑ni máá Dios, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yúan‑na te Jesús, a ni̱ jini̱‑ya̱ já súan kájani ini̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Na̱ún kájani ini̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ja̱ úu̱ tu̱'un yá'a ndéja̱ yíí‑ga̱ káa. Á ka'a̱n‑ri̱: A íó tu̱ká'nu ini̱ nuu̱ táká kua̱chi‑ró, xí ká'a̱n‑ri̱: Nduko̱o, te kaka‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ko náva̱'a ná kuní‑ro̱ já máá Sé'e cha̱a ndíso‑ya̱ tíñu nuu̱ ñúyɨ́vɨ yá'a ja̱ sá'a‑ya̱ túká'nu ini̱ nuu̱ kuáchi, te ná ká'a̱n‑ri̱ ɨnga̱ tu̱'un jíín cháa ni̱ kuyúnú yá'a núsáá: Jíín‑ró ká'a̱n‑ri̱, nduko̱o, te naki'in‑ró jíto yuu‑ro, te no'o̱n‑ro̱ vé'e‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Te ni̱ nduko̱o‑ni cha̱a‑ún jíto nuu̱ ñáyɨvɨ‑ún. Te ni̱ naki'in‑de ji̱to nuu̱ ní ka̱túu‑dé‑ún. Te kua̱no'on‑dé ve'e‑de, nákana jaa‑de Dios. ");
INSERT INTO migNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Te ta̱ká ña̱yɨvɨ‑ún, ni̱ ka̱naa iní‑i kánde̱'é‑i. Te ni̱ kayu̱'ú xaa̱n‑í. Te ni̱ ka̱nakana jaa‑i Dios: Vina te ni̱ ka̱jini̱‑yo̱ tíñu ñá'nu xaa̱n yá'a, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yu̱án‑na, te ni̱ kenda Jesús kua'a̱n‑ya̱. Te ni̱ jini̱‑ya̱ núu̱ ɨ́ɨn cha̱a xíní, nání‑de Leví, kánchaa̱‑de nuu̱ kútútú xú'ún ñúu̱. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kundiki̱n‑ro̱ rúu̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Te ni̱ xndóo‑de ta̱ká ndatíñu‑de. Te ni̱ ndukuiñi̱‑de. Te ni̱ ndiki̱n‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Te ni̱ sá'a Leví ɨɨn gasto ká'nu ini̱ ve̱'e‑de, te ni̱ i̱o kua'a̱ tá'an‑de, cha̱a xíní jíín sáva‑ga̱‑de. Te cha̱a‑ún, káyee‑dé staa̱ jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Te cha̱a káchaa tutu̱ jíín cháa fariseo, ni̱ kaka'a̱n‑de sɨkɨ̱ cháa káskuá'a jíín‑yá: Naja̱ káyee‑ro káji'i‑ró jíín cháa xíní jíín cháa ká'i̱o kua̱chi, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Te ni̱ ka'a̱n Jesús, cha̱a ká'i̱o ndáján, tú kánandɨ'ɨ‑de cha̱a táná, chi cha̱a káku'u̱ kúu ja̱ kájinu ñú'ún. ");
INSERT INTO migNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na̱ tú va̱i‑ri̱ kana‑ri̱ xini̱ cháa ndaa̱. Chi cha̱a ká'i̱o kua̱chi, kána‑ri̱ xini̱ ná nákani ini̱‑de, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yúan‑na te ni̱ kaka'a̱n‑de jíín‑yá: Cha̱a káskuá'a jíín Juan, tɨnɨ̱ jínu ká'i̱o ndicha̱ ini̱‑de te kájika̱n ta'u̱‑dé. Te suni súan kásá'a cha̱a káskuá'a jíín cháa fariseo. Ko cha̱a káskuá'a jíín máá‑ní, naja̱ máni káyee‑dé káji'i‑de. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Á kuu sá'a‑ró já kóndicha̱ ini̱ ña̱yɨvɨ ká'i̱in viko tánda'a, te nú kánchaa̱ yii jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ko chaa̱ ɨɨn kɨvɨ̱ já kuxio yii núu̱‑í. Te kɨvɨ̱‑ún, kuu kondicha̱ ini̱‑i. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Te ni̱ ka'a̱n‑ya̱ ɨ́ɨn tu̱'un yátá jíín‑de: Tú ni ɨɨn náchu'un sa'ma jáá núu̱ sú'nu̱ tu̱'ú. Te nú súan, suni máá já jáá‑ún ka'ncha̱‑ga̱, chi̱ nuu̱ sú'nu̱ tu̱'ú ma̱ kúu nuku̱'un sa'ma jáá. ");
INSERT INTO migNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Te tú ni ɨɨn chu'un vino jáá iní ñii tú'ú, chi̱ nú súan, te máá vino jáá‑ún ndátá ñíi‑ún, te vino‑ún katɨ, te ñii‑ún naa. ");
INSERT INTO migNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ko vino jáá jíín ñíi jáá, kúu ja̱ kúu ku'un ini̱. Te kendo̱o va̱'a ndendúú. ");
INSERT INTO migNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Te tú ni ɨɨn‑i íó, ja̱ á ni̱ ji'i‑i ja̱ tu̱'ú, te kuní tuku‑i ko'o‑i ja̱ jáá, chi: Ja̱ ni̱ kutú'ú kúu ja̱ vá'a‑ga̱, áchí‑i. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Te kɨvɨ̱ ndéta̱tú nuu̱ semana uni̱, te ni̱ ja̱'a Jesús kua'a̱n‑ya̱ ɨ́ɨn nuu̱ káa trigo. Te cha̱a káskuá'a jíín‑yá ni̱ ka̱kachi‑de yoko trigo, ni̱ ka̱kɨɨn‑dé ini̱ nda'a‑dé, te káyee‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Te sava cha̱a fariseo ni̱ kaka'a̱n‑de jíín‑yá: Naja̱ kásá'a‑ró jián, chi̱ tú íó ley sá'a‑ró súan kɨvɨ̱ ndéta̱tú, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Te ni̱ ka'a̱n Jesús: Á tú ní káka'u kutɨ‑ro tutú na̱ún ní sá'a David. Chi̱ máá‑de jíín cháa ni̱ kaxiu̱kú jíín‑de, ni̱ kaji'i̱‑de so̱ko ɨɨn kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Te ni̱ kɨ̱vɨ‑de ini̱ ve̱'e Dios, te ni̱ ki'in‑de sta̱tilá káxiu̱kú ndijín, ni̱ yee‑dé. Te suni ni̱ ja̱'a‑de nuu̱ cháa káxiu̱kú jíín‑de‑ún ni̱ ka̱yee. Te tú íó ley kee ní ɨɨn cha̱a sta̱tilá‑ún, chi̱ máni sutu̱ káyee núú. Achí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Te ni̱ ka'a̱n‑ga̱‑ya̱ jíín‑de: Máá Sé'e cha̱a, suni Jito'o̱ kɨvɨ̱ ndéta̱tú kúu‑ya̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Te ɨnga̱ kɨvɨ̱ ndéta̱tú, suni ni̱ kɨvɨ̱‑ya̱ iní ve̱'e sinagoga, te ni̱ stá'a̱n‑ya̱ tú'un. Te yúan kándee ɨɨn cha̱a ni̱ ichi̱ káján ndá'a vá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Te cha̱a fariseo jíín cháa káchaa tutu̱, kájito yu'u‑dé Jesús nú sá'a‑ya̱ taná kɨvɨ́ ndéta̱tú, náva̱'a kaka̱n‑de kua̱chi sɨkɨ̱‑yá kuní‑de. ");
INSERT INTO migNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ko máá‑yá, a ni̱ jini̱‑ya̱ tú'un kájani ini̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín cháa kátí'íchi nda'a‑ún: Ndukuiñi̱, te ichi má'ñú yá'a kundii̱‑ro̱, áchí‑ya̱. Te máá cháa‑ún, ni̱ ndukuiñi̱‑de, te ni̱ jukuiñi̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de jíná'an‑de: Ná kaká tu̱'ún‑rí róó ɨɨn tu̱'un. Ndé ley íó sɨkɨ̱ kɨvɨ́ ndéta̱tú. Á sá'a va̱'a‑yó, xí sá'a ñáá‑yo̱. Á nama‑yó ɨ́ɨn cha̱a ndúkú kúu̱, xí ká'ni‑yo ɨ́ɨn ndɨ̱yi. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Te ndé'é‑yá nuu̱ táká ja̱ káxiu̱kú xíin‑yá‑ún. Te ni̱ ka'a̱n‑ya̱ jíín cháa kú'u̱: Skáa̱ nda'a‑ro, áchí‑ya̱. Te ni̱ sá'a‑de súan. Te nda'a‑dé‑ún, ni̱ nduva̱'a ii̱‑ní. ");
INSERT INTO migNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Te máá‑ún, ni̱ kakiti̱ xaa̱n iní, te kándatu̱'ún ndasa sá'a jíín Jesús. ");
INSERT INTO migNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Te ni̱ kuu kɨvɨ̱. Te ni̱ kenda Jesús kua̱kaka̱n ta'u̱‑yá onde̱ yuku. Te nɨ́ɨ́ niñú ni̱ jika̱n ta'u̱‑yá nuu̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Te nuu̱ ní kundiji̱n, te ni̱ kana‑ya̱ xiní cháa káskuá'a jíín‑yá. Te ni̱ naka̱ji‑ya̱ uxí uu̱ tá'a̱n‑de. Te cha̱a‑ún, ni̱ skúnání‑yá‑de apóstol. ");
INSERT INTO migNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Te Simón, ni̱ naskúnání‑yá‑de Pedro, jíín ñaní‑de, Andrés, Jacobo, Juan, Felipe, Bartolomé. ");
INSERT INTO migNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo jíín Tomás, Jacobo se̱'e Alfeo, jíín Simón cha̱a nání Zelote, ");
INSERT INTO migNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ñani̱ Jacobo, jíín Judas Iscariote ja̱ ní nastúu‑de Jesús. ");
INSERT INTO migNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Te ni̱ nuu‑ya̱ jíín‑de jíná'an‑de. Te ni̱ jukuiñi̱‑ya̱ ɨ́ɨn ndu'a̱. Te kua'a̱ xáa̱n cháa káskuá'a jíín‑yá jíín kuá'a̱ ñáyɨvɨ ñúu̱ Judea jíín ñáyɨvɨ ñúu̱ Jerusalén, jíín ñáyɨvɨ yú'u mar ñuu̱ Tiro jíín ñúu̱ Sidón, ni̱ kikoyo‑i ja̱ kúni ná'ín‑i tu̱'un ka'a̱n‑ya̱, te suni ja̱ ná ndúva̱'a‑i kue'e̱ káta'a̱n‑i kuní‑i. ");
INSERT INTO migNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Te ta̱ká ña̱yɨvɨ kándo'o jíín tachí kíni, ni̱ kandu̱va̱'a ndɨ'ɨ‑i ni̱ sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Te ndivii ñáyɨvɨ kuá'a̱‑ún, ni̱ ka̱ndúkú ndéé‑i ké'é‑i‑ya̱. Chi̱ íó fuerza ini̱‑ya̱. Te ni̱ nasáva̱'a‑ya̱ ta̱ká‑i. ");
INSERT INTO migNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Te ni̱ ndakoto‑ya̱ núu̱ cháa káskuá'a jíín‑yá. Te ni̱ ka'a̱n‑ya̱: Xáán ndatu̱ róó, cha̱a káta'a̱n ndá'ú, chi̱ kuu kɨ̱vɨ‑ró ñúu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Xáán ndatu̱ róó ja̱ káji'i̱‑ro̱ sóko vina, chi̱ nda'a̱ chi̱i‑ró. Xáán ndatu̱ róó ja̱ kánde'e̱‑ro̱ vína, chi̱ kuaku̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Xáán ndatu̱ róó jíná'an‑ró nú kákiti̱ ini̱ cha̱a kájito‑de róó, jíín nú kákuxio‑de nuu̱‑ro̱ kí'i̱n‑de, jíín nú káka'a̱n tásɨ́‑de sɨkɨ̱‑ro̱, jíín nú káské'ichi̱‑de róó nátu̱'un cha̱a ñáá, ja̱ sɨkɨ́ máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sɨɨ̱ ná kóo ini̱‑ro̱ kɨvɨ̱‑ún, te kusɨɨ̱ xáa̱n iní‑ro̱, chi̱ ká'nu xaa̱n kóo ta'u̱‑ro̱ ondé andɨ́vɨ́. Chi̱ súan ni̱ ka̱sá'a táa̱‑de jíín cháa ni̱ ka̱jani tu̱'un Dios onde̱ sáá. ");
INSERT INTO migNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ko naka̱ ndá'ú kúu róó, cha̱a kúká, chi̱ vina‑ni ká'i̱o sɨɨ̱ iní‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Naka̱ ndá'ú kúu róó ja̱ ká'i̱in tɨɨ chi̱i‑ró vína, chi̱ kuu̱‑ro̱ sóko. Naka̱ ndá'ú kúu róó ja̱ vína kájaku̱‑ro̱, chi̱ ndukuí'a̱ ini̱‑ro̱ te nde'e̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Naka̱ ndá'ú kúu róó nú vina ká'a̱n jíñú'ún táká cha̱a jíín‑ró. Chi̱ súan ni̱ ka̱sá'a táa̱‑de jíín cháa ni̱ ka̱jani tu̱'un xndá'ú onde̱ sáá. ");
INSERT INTO migNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ko ká'a̱n‑ri̱ jíín róó ja̱ kájini so̱'o: Kundá'ú ini̱‑ro̱ cháa kájito u'u̱ róó, te sá'a va̱'a‑ró jíín cháa kákiti̱ ini̱ nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Te ka'a̱n va̱'a‑ró jíín cháa káka'a̱n ndɨva̱'a jíín‑ró. Te kaka̱n ta'u̱‑ro̱ já'a̱ cháa kásá'a tu̱'un tú'ún sɨkɨ́‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Te nú ndé cha̱a stují ɨ́ɨn yikɨ núu̱‑ro̱, suni kua̱'a‑ró tú'un ná stují‑dé ɨnga̱. Te nú ndé cha̱a jánchaa̱‑de tɨka̱chí‑ró, ni su'nu̱‑ro̱ ma̱ sásá'án‑ró ná kí'i̱n‑de jíín. ");
INSERT INTO migNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Na̱ni cha̱a jikán nuu̱‑ro̱, te kua̱'a‑ró núu̱‑dé. Te cha̱a kí'in ndatíñu‑ró, ma̱ nándaka̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Te nátu̱'un kuní‑ro̱ sá'a ña̱yɨvɨ jíín‑ró, suni súan sá'a máá‑ró jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Chi̱ nú mani̱‑ro̱ jíín cháa mani̱ jíín máá‑ró, ndé cha̱a nakuatá'ú núu̱‑ro̱ núsáá. Chi cha̱a ká'i̱o kua̱chi, suni mani̱‑dé jíín cháa mani̱ jíín máá‑de. ");
INSERT INTO migNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Te nú sá'a va̱'a‑ró jíín cháa kásá'a va̱'a jíín máá‑ró, ndé cha̱a nakuatá'ú núu̱‑ro̱, chi cha̱a ká'i̱o kua̱chi, suni súan kásá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Chi̱ nú kua̱'a núu‑ró núu̱ cháa ja̱ ñúkuu ini̱‑ro̱ kuá'a‑de nuu̱‑ro̱, ndé cha̱a nakuatá'ú núu̱‑ro̱, chi cha̱a ká'i̱o kua̱chi, suni já'a núu‑de nuu̱ sáva‑ga̱ cha̱a ká'i̱o kua̱chi, náva̱'a nani'i̱n‑gá‑de. ");
INSERT INTO migNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Núsáá te kundá'ú ini̱‑ro̱ cháa kájito u'u̱ róó, te sá'a va̱'a‑ró jíín‑de. Te kua̱'a núu‑ró núu̱‑dé. Te ma̱ kúñukuu ini̱‑ro̱ na̱ún kuá'a‑de nuu̱‑ro̱. Te ká'nu koo ta'u̱‑ro̱, te kuu‑ró sé'e Dios andɨ́vɨ́. Chi̱ máá‑yá, va̱'a ini̱‑ya̱ jíín cháa já'a̱ ini̱ jíín cháa ndɨva̱'a. ");
INSERT INTO migNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Núsáá te kundá'ú ini̱‑ro̱ ñáyɨvɨ nátu̱'un máá Táa̱‑ro̱ já súni kundá'ú ini̱‑ya̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ma̱ ndónda‑ró sɨkɨ́ ñáyɨvɨ, náva̱'a ma̱ ndónda‑i sɨkɨ̱ máá‑ró. Ma̱ náku̱xndíi‑ró sɨkɨ́‑í, náva̱'a ma̱ náku̱xndíi‑i sɨkɨ̱ máá‑ró. Sá'a tu̱ká'nu ini̱‑ro̱ núu̱‑í, náva̱'a ná sá'a‑i tu̱ká'nu ini̱‑i nuu̱ máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kua̱'a nuu̱‑í te suni súan kua̱'a‑i nuu̱‑ro̱. Chikua̱'á va̱'a‑i, sáni̱'in‑i, kaja‑í, te onde̱ jichá chu'un‑i kua̱'a‑i nuu̱‑ro̱. Chi̱ suni jíín kú'a ni̱ chikua̱'á‑ro̱‑ún, suni naku̱kua̱'á‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Te ni̱ ka'a̱n‑ya̱ ɨ́ɨn tu̱'un yátá jíín‑i: Cha̱a kuáá á kuu stá'a̱n‑de ichi núu̱ ɨngá cha̱a kuáá. Á tú jungava ndendúú‑de ini̱ xa'va̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ɨɨn cha̱a skuá'a, nasu̱ ñá'nu‑ga̱ kúu‑de vásá maestro‑de. Ko ta̱ká cha̱a káskuá'a, nú a ni̱ kutu̱'a va̱'a‑de, te koo‑de nátu̱'un maestro‑de. ");
INSERT INTO migNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Naja̱ ndé'é‑ró já kándee mi̱'ín ndúchi ñaní‑ro̱, te tú nákani ini̱‑ro̱ já ɨ́ɨn vitu̱ kándee nduchi máá‑ró náún. ");
INSERT INTO migNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Naja̱ ká'a̱n‑ro̱ jíín ñaní‑ro̱: Ñáni̱, kundatu ná táva‑rí mi̱'ín kándee nduchi‑ro, te tú nákani ini̱‑ro̱ já kándee ɨɨn vitu̱ ndúchi‑ro náún. Cha̱a uu̱ xini̱, xna'a̱n‑ga̱ tava‑ro vitú kándee nduchi máá‑ró. Yúan‑na te kuu nde̱'é vá'a‑ró já táva‑ro mí'ín kándee nduchi ñaní‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Chi̱ xini̱ yúnu vá'a tú kúun nde'e̱ káñáá. Te ni xini̱ yúnu káñáá tú kúun nde'e̱ vá'a. ");
INSERT INTO migNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chi̱ ndɨta'a̱n yunu, jíín ndé'e̱ te jiní‑yo̱ na̱ún yunu kúu, chi̱ tú táxín‑yó mérkexe̱ xini̱ nú íñú, ni tú táxín‑yó uva xini̱ zarza. ");
INSERT INTO migNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Cha̱a va̱'a, sá'a‑de tiñu va̱'a, chi̱ íó va̱'a ini̱‑de. Te cha̱a ñáá, sá'a‑de tiñu ñáá, chi̱ káñáá ini̱‑de. Chi tu̱'un ñú'un ini̱ añú cha̱a, tu̱'un‑ún ká'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Naja̱ káka'a̱n‑ro̱ jíín‑rí: Táta̱, Táta̱, te tú káskíkuu‑ró tíñu ká'a̱n‑ri̱ jíín‑ró núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ta̱ká ña̱yɨvɨ vái nuu̱‑rí, te jíni so̱'o tu̱'un ká'a̱n‑ri̱, te skíkuu, ná stá'a̱n‑ri̱ nuu̱‑ro̱ na̱ jíín kétá'an. ");
INSERT INTO migNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kúu nátu̱'un ɨɨn cha̱a ja̱ jáni‑de ve'e‑de, te ni̱ jacha kúnú‑de. Te ni̱ jani‑de ja'a̱ sɨkɨ́ káva. Te nuu̱ ní chaa̱ ɨɨn nducha ñú'ún xáa̱n, te yu̱cha‑ún ni̱ kuni̱ stúncháa̱ ve'e‑ún núú. Ko tú ní kandá kutɨ, chi̱ sɨkɨ̱ káva kandii̱. ");
INSERT INTO migNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ko ña̱yɨvɨ jíni so̱'o, te tú skíkuu, yu̱án kúu nátu̱'un ɨɨn cha̱a ni̱ jani‑de ve'e‑de nuu̱ ñú'un, te tú yíndu̱ji ja'a̱. Te ɨɨn nducha ñú'ún ní kani ve'e‑ún, te ni̱ stúncháa̱‑ni. Te ni̱ naa íi̱‑ní ve'e‑ún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Te ni̱ ji̱nu ni̱ ka'a̱n‑ya̱ ní ka̱jini ná'ín ñáyɨvɨ‑ún. Yúan‑na te ni̱ kɨ̱vɨ‑ya̱ kuá'a̱n‑ya̱ ñúu̱ Capernaum. ");
INSERT INTO migNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Te ɨɨn cha̱a kúu capitán, íó ɨɨn mozo‑de ja̱ maní‑dé jíín. Te mozo‑ún, kú'u̱‑i te a yani kuu̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Te cha̱a capitán yúan, ni̱ jini‑de tu̱'un Jesús. Te ni̱ tájí‑de yaku̱ cha̱a judío ñá'nu, kua'a̱n nuu̱‑yá, ka'a̱n nda̱'ú jíín‑yá ja̱ ná kíi‑ya̱ te nama‑ya̱ mozo‑de. ");
INSERT INTO migNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Te ni̱ ja̱koyo cha̱a‑ún nuu̱ Jesús. Te ni̱ kaka'a̱n nda̱'ú‑de jíín‑yá: Kánúú sá'a‑ní ja̱ ká'a̱n‑de, ");
INSERT INTO migNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","chi̱ mani̱‑dé jíín ñúu̱‑ná. Te ni̱ jani‑de ɨɨn ve'e sinagoga kuu‑ná jíná'an‑ná. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Te kua'a̱n Jesús jíín‑de. Te nuu̱ ní ka̱kuyani‑ya̱ vé'e‑ún, te ni̱ tájí capitán yaku̱ amigo‑de, kua'a̱n nuu̱‑yá. Te ni̱ ka'a̱n‑de jíín‑yá: Táta̱, tú kuní‑ná sátéñu‑ná níí ja̱ kɨ́vɨ‑ní ini̱ ve̱'e‑ná. ");
INSERT INTO migNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ja̱ yúán tú ní kuní‑ná kii‑ná nuu̱‑ní núú, ko máni ka'a̱n‑ní, te ná ndúva̱'a mozo‑ná. ");
INSERT INTO migNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Chi̱ máá‑ná, suni cha̱a ndíso tíñu kúu‑ná. Te tá'ú‑ná tiñu nuu̱ soldado‑ná. Te ká'a̱n‑ná jíín ɨ́ɨn‑de: Kuá'án, te já'a̱n‑de. Te jíín ɨngá‑de: Ña'a̱n, te cháa̱‑de. Te jíín mozo‑ná: Sá'a ya̱'á, te sá'a‑i. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tu̱'un yá'a ni̱ jini so̱'o Jesús. Te ni̱ naa iní‑ya̱ ní nde̱'é‑yá nuu̱‑dé. Te ni̱ xíó káva‑ya̱. Te ni̱ ka'a̱n‑ya̱ jíín ñáyɨvɨ kuá'a̱ kándiki̱n yata̱‑yá: Ndaa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ ní ini̱ ñuu̱ Israel tú súan ní jiní‑ri̱ cha̱a kándíja, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Te cha̱a ni̱ tájí‑de nuu̱‑yá núú, ni̱ naja̱koyo‑de ve'e. Te ni̱ jini̱‑de ja̱ á ni̱ nduva̱'a mozo‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yúan‑na te ni̱ kuu kɨvɨ̱. Te ni̱ kɨ̱vɨ Jesús kua'a̱n‑ya̱ ñúu̱ Naín. Te kua'a̱ cháa skuá'a jíín‑yá, jíín ñáyɨvɨ kuá'a̱, kája'a̱n‑i jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Te ni̱ kuyani‑ya̱ yúñúu̱‑ún. Te kákiñi'in ña̱yɨvɨ‑ún ɨɨn su̱chí yíí ní ji'i̱‑i, ja̱ máá ɨ́ɨn‑i nuu̱ náa̱‑i núú. Te ña'an viuda kúu‑ña. Te suni kua'a̱ ñáyɨvɨ ñúu̱‑ún ká'i̱in jíín‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Te ni̱ jini̱ máá Jito'o̱‑yo̱ núu̱‑ñá. Te ni̱ kundá'ú ini̱‑ya̱‑ñá. Te ni̱ kachi̱‑ya̱ jíín‑ña: Ma̱ ndé'e̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Te ni̱ kandita‑ya̱. Te ni̱ tɨɨn‑ya̱ camilla ndɨ̱yi‑ún. Te ni̱ ka̱jukuiñi̱ cha̱a kándi̱so‑ún. Te ni̱ ka'a̱n‑ya̱: Súchi̱, jíín‑ró ká'a̱n‑ri̱, nduko̱o, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yúan‑na te ni̱ nduko̱o su̱chí já á ni̱ ji'i̱‑ún. Te ni̱ kejá'á‑i náka'a̱n‑i. Te Jesús, ni̱ nakua̱'a‑ya̱‑í nuu̱ náa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Te ndivii ñáyɨvɨ, ni̱ kayu̱'ú‑i. Te kánakana jaa‑i Dios. Te sava‑i káka'a̱n‑i: Ni̱ chaa̱ ɨɨn cha̱a jáni tu̱'un Dios nuu̱‑yo̱, te kúñá'nu‑de. Te sava‑ga̱‑i káka'a̱n‑i: Máá Dios, ni̱ chaa̱‑ya̱ núu̱‑yo̱. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Te tu̱'un‑ya̱‑ún ni̱ jicha̱ kua'a̱n nɨ́ɨ́ ñúu̱ Judea jíín nɨ́ɨ́ ñúu̱ yani yúan. ");
INSERT INTO migNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Te cha̱a káskuá'a jíín Juan, ni̱ kaka̱stu̱'ún núu̱‑dé ndasa íó ta̱ká tiñu. Yúan‑na te ni̱ kana Juan xini̱ úu̱ cha̱a káskuá'a jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Te ni̱ tájí‑de kua'a̱n nuu̱ Jesús, náva̱'a kaka̱ tu̱'ún‑de‑ya̱: Máá‑ní kúu cha̱a kii‑ún, xí kúndatu‑yó ɨngá‑de náún, achi̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Te ni̱ ja̱koyo cha̱a‑ún nuu̱‑yá. Te ni̱ kaka'a̱n‑de jíín‑yá: Juan, cha̱a skuánducha, ni̱ tájí‑de náá va̱i koyo‑ná nuu̱‑ní va̱i kaka̱ tu̱'ún‑ná níí: Á máá‑ní kúu cha̱a kii‑ún xí kúndatu‑yó ɨngá‑de náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Te suni máá hora‑ún ni̱ nasáva̱'a‑ya̱ kuá'a̱ ñáyɨvɨ káku'u̱, jíín já káte'yu̱, jíín já káta'a̱n tachi̱ kíni. Te suni kua'a̱ cháa kuáá, ni̱ ndundiji̱n nuu̱‑dé ni̱ sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Te ni̱ ka'a̱n Jesús: Kuá'án, te kastu̱'ún‑ró núu̱ Juan na̱ún ní kajini̱‑ro̱, jíín tú'un ni̱ ka̱jini so̱'o‑ró. Cha̱a kuáá, kándundiji̱n nuu̱‑dé. Te cha̱a rengo kánakaka‑de. Te cha̱a té'yu̱ ndɨ̱'yi kándundoo‑de. Te cha̱a só'ó kánakuni so̱'o‑de. Te cha̱a ni̱ ji'i̱ kánachaku̱‑de sá'a‑ri̱. Te suni jáni‑ri̱ tu̱'un va̱'a Dios nuu̱ ñáyɨvɨ ndá'ú. ");
INSERT INTO migNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Te xáán ndatu̱ koo cha̱a ja̱ má náyu̱'ú‑de koto‑de ruu̱. Achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Te cha̱a ni̱ tájí Juan ni̱ kenda‑de káno'o̱n‑de. Te Jesús, ni̱ kejá'á‑yá ká'a̱n‑ya̱ tú'un Juan jíín ñáyɨvɨ: Naja̱ ní kenda‑ró kája'a̱n‑ro̱ ondé ñu'un té'é. Ja̱ ndé'é‑ró ɨ́ɨn icha̱ ja̱ kandá sá'a tachi̱ náún. ");
INSERT INTO migNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ko naja̱ ní kenda‑ró kája'a̱n‑ro̱. Ja̱ ndé'é‑ró núu̱ ɨ́ɨn cha̱a ñú'un sa'ma ndúchá náún. Ko ná kástu̱'ún‑rí, cha̱a káñu̱'un sa'ma lúu te ncháá va̱'a‑de ja̱ kákusɨɨ̱ iní‑de, máni ini̱ ve̱'e rey káxiu̱kú‑de. ");
INSERT INTO migNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ko naja̱ ní kenda‑ró kája'a̱n‑ro̱. Ja̱ ndé'é‑ró núu̱ ɨ́ɨn cha̱a jáni tu̱'un Dios náún. Te suni ká'a̱n‑ri̱ jíín‑ró: Kúñá'nu xaa̱n‑gá‑de vásá ɨ́ɨn cha̱a jáni tu̱'un Dios. ");
INSERT INTO migNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Cha̱a yá'a kúu cha̱a yóso tú'un‑de nuu̱ tutú: Kuni so̱'o‑ró chi̱ tájí‑rí ndajá'a̱‑rí kuxnúú‑de jaa̱‑de, te cha̱a‑ún sátu̱'a‑de ichi‑ro vásá jáa̱‑ro̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Chi̱ a ká'a̱n‑ri̱ jíín‑ró ja iní ñu̱yɨ́vɨ yá'a tú íó ni ɨɨn cha̱a jáni tu̱'un Dios ja̱ kúñá'nu‑ga̱ máá‑de vásá Juan cha̱a skuánducha. Ko máá cháa lúlí‑ga̱ ini̱ ñuu̱ ñátu̱'un andɨ́vɨ́, cha̱a‑ún kúñá'nu‑ga̱‑de vásá Juan. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Te cha̱a xíní jíín táká ña̱yɨvɨ‑ún, kájini so̱'o tu̱'un ká'a̱n‑ya̱, te ni̱ ka̱jatá'ú‑i tu̱'un Dios. Te ni̱ ka̱janducha‑í nuu̱ Juan. ");
INSERT INTO migNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ko cha̱a fariseo jíín cháa maestro ley, ni̱ ka̱ské'ichi̱‑de tu̱'un kuní Dios ja̱ sá'a‑de, kua̱chi ja̱ tú ní kájanducha‑dé nuu̱ Juan. ");
INSERT INTO migNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Te ni̱ kachi̱ máá Jíto'o̱‑yo̱: Na̱ún tu̱'un yátá skétá'an‑ri̱ jíín ñáyɨvɨ yá'a núsáá, te na̱ún ní ka̱ndaku‑i. ");
INSERT INTO migNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kákuu‑i nátu̱'un su̱chí lúlí káxiu̱kú núyá'u, ja̱ kákana kó'ó‑i xini̱ tá'an‑i: Ni̱ ka̱xndé'e̱‑ri̱ xkuili nuu̱‑ro̱, te tú ní kájita já'á‑ró: Ni̱ kanda'i̱‑ri̱ nuu̱‑ro̱, te tú ní kánde'e̱‑ro̱, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Chi ni̱ kii Juan cha̱a skuánducha. Tú ní yée‑dé staa̱, tú ní jí'i‑de vino, te káka'a̱n‑ro̱: Tá'a̱n‑de tachi̱ kíni. ");
INSERT INTO migNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ko máá Sé'e cha̱a yée‑yá, jí'i‑ya̱. Te káka'a̱n‑ro̱: Yá'a íó ɨɨn cha̱a yáji téyíí, te jí'i xaa̱n‑dé vino, cha̱a jiní tá'an jíín cháa xíní jíín cháa ká'i̱o kua̱chi kúu‑de. Achí‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ko ɨɨn cha̱a ndíchí, máni tiñu ndíchí sá'a‑de. Te súan kuni̱‑ro̱ jándáa̱ ndíchí‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Te ɨɨn cha̱a fariseo, ni̱ ka'a̱n nda̱'ú‑de jíín Jesús kee‑yá staa̱ jíín‑de. Te ni̱ kɨ̱vɨ‑ya̱ iní ve̱'e‑de, te ni̱ jungo̱o‑ya̱ já kée‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Te ɨɨn ña'an íó kua̱chi, kánchaa̱‑ña ñúu̱ yúan. Te ni̱ jini̱‑ña já kánchaa̱ Jesús ve'e ɨɨn cha̱a fariseo. Te ni̱ chaa̱‑ña jíín ɨ́ɨn tiya'a̱ perfume. ");
INSERT INTO migNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Te kánchaa̱‑ña núu̱ já'a̱‑yá ichi yatá‑yá. Te ndé'e̱‑ña, te ni̱ xndáji‑ña já'a̱‑yá jíín ndúcha núu̱‑ñá. Te ni̱ na̱sí'ichí‑ña já'a̱‑yá jíín íxi xiní‑ñá. Te ni̱ tiyú'ú‑ña já'a̱‑yá, te ni̱ ji'i‑ñá perfume ja'a̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Te fariseo, cha̱a ni̱ kana xini̱‑yá‑ún, súan ni̱ jini̱‑de, te ni̱ jani ini̱ máá‑de: Nú cha̱a jáni tu̱'un Dios kúu cha̱a yá'a, te kuni̱‑de ndé ña'an kúu ña'an yá'a núú. Chi̱ ña'an yá'a, ja̱ ké'é‑ña‑dé, ña'an íó kua̱chi kúu‑ña, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yúan‑na te ni̱ ka'a̱n Jesús: Simón, ka'a̱n‑ri̱ ɨɨn tu̱'un jíín‑ró kuní‑ri̱, áchí‑ya̱ jíín‑de. Te máá‑de, ni̱ ka'a̱n‑de: Ka'a̱n‑ní, Maestro, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Te ni̱ ka'a̱n Jesús: Ɨɨn cha̱a já'a núu xu̱'ún, ni̱ i̱o uu̱ cha̱a taú nuu̱‑dé. Ɨɨn cha̱a, ni̱ tau̱ u'u̱n ciento peso. Te ɨnga̱ cha̱a ni̱ tau̱ uu̱ xiko uxi̱ peso nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Te tú na̱ jíín káñava̱'a cha̱a‑ún ja̱ náku̱náa. Te ni̱ sá'a‑de tu̱ká'nu ini̱ nuu̱ ndéndúú cha̱a‑ún. Ka'a̱n, ndé ɨɨn cha̱a‑ún kúmani̱‑gá jíín‑de núsáá. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Te ni̱ ka'a̱n Simón: Jáni ini̱‑ná ja̱ cháa ni̱ sá'a‑ga̱‑de tu̱ká'nu ini̱ nuu̱‑ún, áchí‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ja̱ndáa̱ ká'a̱n‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Te ni̱ xíó kóto‑ya̱ íchi núu̱ ñá'an‑ún. Te ni̱ ka'a̱n‑ya̱ jíín Simón: Jiní‑ro̱ ñá'an yá'a náún. Ni̱ kɨ̱vɨ‑ri̱ ini̱ ve̱'e‑ró, te tú ní já'a‑ró ndúcha já ndúndoo ja'a̱‑rí. Ko ña'an yá'a, ni̱ xndáji‑ña já'a̱‑rí jíín ndúcha núu̱‑ñá. Te ni̱ na̱sí'ichí‑ña jíín íxi xiní‑ñá. ");
INSERT INTO migNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tú ní tíyú'ú‑ró rúu̱. Ko ña'an yá'a, onde̱ ni̱ kɨ̱vɨ‑ri̱ ini̱ ve̱'e‑ró, tú júkuiñi̱‑ña já tíyú'ú‑ña já'a̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tú ní jí'i‑ro aceite xini̱‑rí. Ko ña'an yá'a ni̱ ji'i‑ñá perfume ja'a̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Núsáá te ká'a̱n‑ri̱ jíín‑ró, ja̱ á ni̱ sá'a‑ri̱ tu̱ká'nu ini̱ nuu̱ táká kua̱chi‑ña va̱sa íó kua'a̱, chi ni̱ kumani̱ xáa̱n‑ñá jíín‑rí. Ko nú sá'a‑ri̱ tu̱ká'nu ini̱ nuu̱ ɨ́ɨn cha̱a íó yaku̱‑ni kua̱chi‑de, te yaku̱‑ni kumani̱‑dé jíín‑rí, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Te ni̱ ka'a̱n‑ya̱ jíín‑ña: A ni̱ sá'a‑ri̱ tu̱ká'nu ini̱ nuu̱ táká kua̱chi‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Te cha̱a káyee stáa̱ jíín‑yá, ni̱ ka̱kejá'á‑de kájani ini̱ máá‑de: Ndé cha̱a kúu cha̱a yá'a, ja̱ sá'a‑de tu̱ká'nu ini̱ nuu̱ kuáchi, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Te ni̱ ka'a̱n‑ya̱ jíín ñá'an‑ún: Ni̱ kandíja‑ró, te yu̱án ní nama‑ri̱ róó. Kuá'án, te ma̱ yú'ú‑ga̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yúan‑na te kúkuéé‑ga̱, te ni̱ jika kuu‑ya̱ táká ñuu̱ jíín rancho. Te jáni‑ya̱ tú'un va̱'a te kástu̱'ún‑yá ndasa koo máá ñúu̱ nuu̱ tá'ú Dios tiñu. Te máá uxí uu̱ apóstol, kája'a̱n‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Te suni íó yaku̱ ña'an já á ni̱ kata'a̱n‑ña tachí kíni jíín kué'e̱, ja̱ á ni̱ nasáva̱'a‑ya̱‑ñá. Te ña'an‑ún, suni kája'a̱n‑ña jíín‑yá. Te ɨɨn‑ña kúu María ñuu̱ Magdala. Te ini̱ ña'an yúan ni̱ kiñi'in‑ya̱ usiá tachi̱ kíni kája'a̱n onde̱ sáá. ");
INSERT INTO migNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Te sava‑ga̱‑ña káinání‑ña Juana, ñasɨ́'ɨ́ cha̱a nání Chuza, cha̱a ndíso tiñu Herodes, jíín Susana, jíín kuá'a̱‑gá ña'an. Te kájatíñu‑ña núu̱‑yá jíná'an‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Te ni̱ ka̱kutútú kuá'a̱ xáa̱n ñáyɨvɨ. Te ña̱yɨvɨ káxiu̱kú táká ñuu̱‑ún, ni̱ ja̱koyo‑i nuu̱‑yá. Te ni̱ ka'a̱n‑ya̱ ɨ́ɨn tu̱'un yátá jíín‑i: ");
INSERT INTO migNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ɨɨn cha̱a sáka trigo, ni̱ kenda‑de sáka‑dé trigo‑de. Te jachá‑de, te ɨɨn nuni̱ ní jungava yu'íchi te ni̱ jañu̱‑i sɨkɨ̱. Te tɨsaa̱ andɨ́vɨ́ ní ka̱kókó‑tɨ́. ");
INSERT INTO migNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Te ɨnga̱ ni̱ jungava sɨkɨ̱ yúu̱. Te ni̱ kana. Ko ni̱ ichi̱, chi̱ tú kajin. ");
INSERT INTO migNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Te ɨnga̱ ni̱ jungava ma̱'ñú íñu. Te ɨɨn núú‑ni ni̱ ka̱kana iñu jíín. Te ni̱ kajasu̱ nuu̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Te sava ni̱ ka̱jungava nuu̱ ñú'un vá'a. Te nuu̱ ní ka̱kana, te ja̱ ɨ́ɨn, te ni̱ ja̱'a ciento nuni̱. Achí‑ya̱. Yúan‑na te ká'a̱n jaa‑ya̱: Cha̱a íó so̱'o, kuni ná'ín‑de, te ná kúni so̱'o‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Te cha̱a káskuá'a jíín‑yá, ni̱ kajika̱ tu̱'ún‑de‑ya̱ na̱ún kuní ka'a̱n tu̱'un yátá‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Te ni̱ ka'a̱n‑ya̱: Róó, chi̱ a kuaju̱ku̱'un ini̱‑ro̱ tú'un yísa̱'í yá'a sá'a Dios, ndasa koo ñuu̱ nuu̱ tá'ú Dios tiñu. Ko ká'a̱n‑ri̱ tu̱'un yátá jíín sáva‑ga̱‑i náva̱'a va̱sa ndé'é‑i, ko ma̱ kuní‑i, te va̱sa jíni so̱'o‑i, ko ma̱ júku̱'un ini̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tu̱'un yátá yá'a kuní ka'a̱n: Tata̱‑ún kúu tu̱'un Dios. ");
INSERT INTO migNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tata̱ ni̱ ka̱jungava yu'íchi‑ún kákuu cha̱a kájini so̱'o tu̱'un. Te cháa̱‑ni kui'na̱ te jánchaa̱ tu̱'un‑ún ini̱ añú‑de náva̱'a tú kandíja‑de te ka̱ku‑de. ");
INSERT INTO migNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Te ja̱ ní ka̱jungava sɨkɨ̱ yúu̱‑ún kákuu cha̱a kájini so̱'o‑de tu̱'un. Te kúsɨɨ̱ iní‑de jíín. Ko túu nuu̱ káka yo'o iní‑de. Te yaku̱‑ni kɨvɨ̱ kákandíja‑de. Te nú ndónda tu̱ndó'o sɨkɨ̱‑dé te kánayu̱'ú‑de. ");
INSERT INTO migNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Te ja̱ ní ka̱jungava ma̱'ñú íñu kákuu cha̱a kájini so̱'o‑de. Ko nú kua'a̱n‑de, te kákutéñu‑de jíín ndátíñu‑de, chi̱ kákuni̱‑de kukúká‑de náva̱'a koo sɨɨ̱ iní‑de. Yu̱án náa tú'un ini̱‑de. Te tú yíja va̱'a nuni̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ko ja̱ ní ka̱jungava nuu̱ ñú'un vá'a kákuu cha̱a kándee añú va̱'a añú ndaa̱ ini̱‑de. Te tu̱'un ni̱ ka̱jini so̱'o‑de‑ún, ñú'un ni̱'in ini̱‑de. Te kája̱'a‑de nuni̱ táká kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tú ni ɨɨn ña̱yɨvɨ chí'i‑i ñu'u̱n xini̱ yítɨ te jasú‑i kɨ̱sɨ sɨkɨ̱, ni tú jáni‑i chi̱i ji̱to. Chi̱ sua kundii̱ nuu̱ ɨ́ɨn candelero, náva̱'a tuu̱n ndua ñú'u̱n nuu̱ ñáyɨvɨ kɨ́vɨ koyo. ");
INSERT INTO migNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chi̱ tú íó ni ɨɨn tiñu yísa̱'í sáni, chi̱ stá'a̱n ndiji̱n‑ya̱ táká‑ni. Ni tú íó ni ɨɨn tu̱'un yísa̱'í sáni, chi va̱i ndiji̱n ta̱ká‑ni sá'a‑ya̱, te kuni̱‑yo̱ núu̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Núsáá te ná kúni so̱'o va̱'a‑ró, chi cha̱a ñáva̱'a, te kii‑ga̱ nuu̱‑dé, te cha̱a tú ñáva̱'a, va̱sa jáni ini̱‑de ja̱ á ñáva̱'a‑de te kuxio ki'i̱n, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yúan‑na te ni̱ jaa̱ náa̱‑ya̱ jíín ñaní‑ya̱ núu̱‑yá. Te tú ní kúu kɨ̱vɨ koyo‑ña núu̱‑yá sɨkɨ̱ já kuá'a̱ ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Te ni̱ kaka̱stu̱'ún ñáyɨvɨ‑ún nuu̱‑yá: Náa̱‑ní jíín ñaní‑ní ká'i̱in‑ña yatá vé'e, te ka'a̱n‑ña jíín‑ní kákuni̱‑ña, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yúan‑na te ni̱ ka'a̱n‑ya̱: Náa̱‑ri̱ jíín ñaní‑ri̱ kákuu ña̱yɨvɨ kájini so̱'o tu̱'un Dios, te káskíkuu‑i, áchí‑ya̱ jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Te ɨɨn kɨvɨ̱, ni̱ kɨ̱vɨ‑ya̱ iní ɨɨn barco jíín cháa káskuá'a jíín‑yá. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ná kíja̱'a‑yó ɨngá lado mar. Te ni̱ ka̱skáka‑ya̱ barco kája'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ko nini káskáka‑de barco, te ni̱ kixi̱‑ya̱. Te ni̱ ndonda ɨɨn tachi̱ xáa̱n núu̱ mar. Te ndúkú chítú ndúcha iní barco, te a yani koo tu̱ndó'o núú. ");
INSERT INTO migNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Te ni̱ ja̱koyo‑de nuu̱‑yá. Te ni̱ ka̱xndúko̱o‑de‑ya̱. Maestro, Maestro, vina te naa‑yo, áchí‑de. Te ni̱ nata'u̱ núu̱‑yá. Te ni̱ ka'a̱n xaa̱n‑yá nuu̱ tachí‑ún jíín núu̱ mar. Te ni̱ kuná'ín‑ni. Te ná'ín yúú íi̱‑ní ni̱ kuu. ");
INSERT INTO migNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Naja̱ tú kákandíja‑ró. Te káyu̱'ú‑de, te kánaa iní‑de kánde̱'é‑de. Te káka'a̱n jíín tá'an máá‑de: Ndé cha̱a kúu cha̱a yá'a, ja̱ ondé nuu̱ tachí jíín núu̱ ndúcha tá'ú‑de tiñu te kájandatu̱ nuu̱‑dé, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Te ni̱ ja̱koyo‑de ñuu̱ Gadara, ja̱ kánchaa̱ ichi núu̱ ñúu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Te nuu̱ ní jaa̱‑ya̱ núu̱ ñú'un íchí, te ɨɨn cha̱a ñuu̱‑ún ni̱ kita'a̱n‑de‑ya̱. Te tá'a̱n‑de kua'a̱ tachí kíni. Te ni̱ kuu kua'a̱ kuiá ja̱ tú ñú'un kutɨ‑dé sa'ma, ni tú ncháá‑de ɨɨn ve'e, chi ma̱'ñú vé'e añú ncháá‑de. ");
INSERT INTO migNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Te cha̱a‑ún, ni̱ jini̱‑de nuu̱ Jesús. Te ni̱ jukuiñi̱ jítɨ́‑de nuu̱‑yá. Te ni̱ kana jaa‑de: Na̱ún sá'a‑ní jíín‑ná Jesús, Se̱'e Dios, I'a̱ kúñá'nu xaa̱n. Ká'a̱n nda̱'ú‑ná jíín‑ní ma̱ xndó'o‑ní náá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Te ni̱ tá'ú‑yá tiñu nuu̱ tachí kíni‑ún ná kénda ki'i̱n ini̱ cha̱a‑ún, chi ni̱ kuu kua'a̱ kuiá xndó'o cha̱a‑ún. Te ni̱ kaju'ni̱‑i cha̱a‑ún jíín cadena jíín manea ka̱a. Ko ndɨ'ɨ ni̱ kukuáchí sá'a‑de. Te kénda‑de já'a̱n‑ni‑de onde̱ ñu'un té'é sá'a tachi̱ kíni‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Te Jesús, ni̱ jika̱ tu̱'ún‑yá‑de: Na̱ún nání‑ró, áchí‑ya̱. Te ni̱ ka'a̱n‑de jíín‑yá: Ja̱ kuá'a̱ xáa̱n nání‑ná, áchí, chi̱ yí'i kua'a̱ xáa̱n tachí kíni ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Te ni̱ kaka'a̱n nda̱'ú tachi̱‑ún jíín‑yá ja̱ ná tú tájí‑yá ki'i̱n ini̱ tu̱nchi kúnú. ");
INSERT INTO migNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Te yuku yúan íó ɨɨn tɨku'ni̱ kɨnɨ̱ kájitu‑tɨ̱. Te yúan ni̱ kaka'a̱n nda̱'ú jíín‑yá ja̱ ná kuá'a‑ya̱ tú'un kɨ̱vɨ koyo ini̱‑tɨ̱. Te ni̱ ja̱'a‑ya̱ tú'un kája'a̱n. ");
INSERT INTO migNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Te ni̱ kenda tachi̱ kíni‑ún ini̱ cha̱a‑ún kája'a̱n. Te ni̱ kɨ̱vɨ koyo ini̱ kɨnɨ̱. Te tɨku'ni̱ kɨnɨ̱‑ún ni̱ ka̱jungoyo‑tɨ̱ yúkáva‑ún onde̱ ini̱ mar. Te nuu̱ mar ni̱ kaji'i̱‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Te cha̱a kándi̱to‑tɨ̱, ni̱ kajini̱‑de ja̱ súan ni̱ kuu. Te ni̱ ka̱jinu‑de kája'a̱n‑de. Te ni̱ kaka̱stu̱'ún‑de nuu̱ ñáyɨvɨ ñúu̱‑ún jíín táká rancho. ");
INSERT INTO migNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Te ni̱ kenda koyo ña̱yɨvɨ‑ún ja̱ ndé'é‑i na̱ún ní kuu. Te ni̱ ja̱koyo‑i nuu̱ Jesús. Te ni̱ kajini̱‑i nuu̱ cháa ni̱ kenda tachi̱ kíni‑ún, kánchaa̱‑de nuu̱ já'a̱ Jesús, ñú'un‑de sa'ma, te a ni̱ nduva̱'a xini̱‑dé. Te ni̱ kayu̱'ú‑i. ");
INSERT INTO migNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Te cha̱a ni̱ kajini̱, ni̱ ka̱jani‑de tu̱'un nuu̱ ñáyɨvɨ‑ún, ndasa ni̱ nduva̱'a cha̱a ni̱ ta'a̱n tachi̱ kíni. ");
INSERT INTO migNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yúan‑na te ta̱ká ña̱yɨvɨ ñúu̱ Gadara, ni̱ kaka'a̱n nda̱'ú‑i jíín‑yá ja̱ ná kúxio‑ya̱ kí'i̱n‑ya̱, chi̱ xaa̱n káyu̱'ú‑i. Te máá‑yá, ni̱ ndɨ̱vɨ‑ya̱ iní barco. Te ni̱ na̱xíó káva‑ya̱ kuá'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Te cha̱a ni̱ ka̱kenda tachi̱‑ún, ni̱ ka'a̱n nda̱'ú‑de ja̱ kuéni ki'i̱n‑de jíín‑yá. Ko Jesús, ni̱ tájí‑yá‑de kua'a̱n‑de: ");
INSERT INTO migNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Kuáno'on vé'e‑ró, te kani‑ró tú'un ná ñá'nu xaa̱n tíñu ni̱ sá'a Dios jíín‑ró, áchí‑ya̱ jíín‑de. Te máá cháa‑ún ni̱ kee‑de kua'a̱n‑de. Te ni̱ jani‑de tu̱'un nɨ́ɨ́ ñúu̱ yúan ná ñá'nu xaa̱n tíñu ni̱ sá'a Jesús jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yúan‑na te ni̱ najaa̱‑ya̱. Te ña̱yɨvɨ‑ún ni̱ kaka'a̱n va̱'a‑i jíín‑yá, chi̱ ndivii‑í káinda̱tu‑i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Te ɨɨn cha̱a kúñá'nu ini̱ ve̱'e sinagoga nání‑de Jairo, ni̱ chaa̱‑de. Te ni̱ jukuiñi̱ jítɨ́‑de nuu̱ já'a̱ Jesús. Te ni̱ ka'a̱n nda̱'ú‑de jíín‑yá ja̱ ná kɨ́vɨ‑ya̱ iní ve̱'e‑de. ");
INSERT INTO migNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Chi̱ íó ɨɨn se̱sɨ́'ɨ́‑de ja̱ máá ɨ́ɨn‑i nuu̱‑dé, nátu̱'un uxi̱ uu̱ kuia̱‑i. Te su̱chí‑ún ndúkú‑i kuu̱‑i. Te ni̱ kee Jesús kua'a̱n‑ya̱. Te kua'a̱ ñáyɨvɨ ní kajaxi̱n‑i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Te ɨɨn ñasɨ́'ɨ́ ni̱ kuu uxi̱ uu̱ kuia̱ játɨ nɨñi̱‑ñá. Te ña'an‑ún ni̱ janu̱‑ña táká ndatíñu‑ña ní kuu cha̱a táná. Te tú ní ndúva̱'a‑ña sá'a ni ɨɨn‑de. ");
INSERT INTO migNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Te ni̱ jaa̱‑ña íchi yatá‑yá. Te ni̱ ké'é‑ña yú'u sá'ma‑yá. Te ni̱ ichi̱‑ni nuu̱ játɨ nɨñi̱‑ñá‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yúan‑na te ni̱ ka'a̱n Jesús: Ndéja̱ ní ké'é rúu̱, áchí‑ya̱. Te ndivii‑dé tú ní kája̱'a‑de tu̱'un. Te Pedro jíín cháa ká'i̱in jíín‑de yúan, ni̱ kaka'a̱n‑de: Maestro, ña̱yɨvɨ kuá'a̱ yá'a kájaxi̱n‑i níí, te a ká'a̱n‑ní: Ndéja̱ ní ké'é rúu̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ko ni̱ ka'a̱n Jesús: Ndaa̱ ja̱ ɨ́ɨn ña̱yɨvɨ ní ké'é rúu̱, chi ni̱ jini̱‑ri̱ ja̱ ní kenda fuerza ini̱‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yúan‑na te ña'an‑ún, ni̱ jini̱‑ña já tú ní kúu chisa̱'í‑ña máá‑ña, te ni̱ chaa̱‑ña kɨ́sɨ‑i‑ña. Te ni̱ jukuiñi̱ jítɨ́‑ña núu̱ Jesús, te jíto nuu̱ táká ña̱yɨvɨ, ni̱ jani ndaa̱‑ña tú'un naja̱ ní ké'é‑ña‑yá, te ndasa ni̱ nduva̱'a‑ni‑ña ní sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Te máá‑yá ni̱ ka'a̱n‑ya̱ jíín‑ña: Ni̱ kandíja‑ró, te yu̱án ní ka̱ku‑ró. Kuá'án, te ma̱ yú'ú‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Te nini ká'a̱n‑ya̱ súan, te ni̱ chaa̱ ɨɨn mozo cha̱a kúñá'nu ini̱ ve̱'e sinagoga‑ún, ni̱ kachi̱ nuu̱‑dé: A ni̱ ji'i̱ se̱sɨ́'ɨ́‑ro̱. Ma̱ sátéñu‑ga̱‑ro̱ Maestro, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Te ni̱ jini so̱'o Jesús ja̱ ní ka'a̱n mozo‑ún. Te ni̱ kachi̱‑ya̱ jíín cháa‑ún: Ma̱ yú'ú‑ro̱: Kandíja‑ni, te ná káku se̱sɨ́'ɨ́‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Te ni̱ kɨ̱vɨ‑ya̱ iní ve̱'e. Te tú ní já'a‑ya̱ tú'un kɨ̱vɨ ni ɨɨn jíín‑yá, chi̱ máá‑ni Pedro jíín Jacobo, jíín Juan, jíín táa̱ náa̱ su̱chí sɨ́'ɨ́‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Te kánde'e̱ ndivii ñáyɨvɨ te kándukuí'a̱ ini̱‑i. Te ni̱ kachi̱‑ya̱: Ma̱ ndé'e̱‑ro̱ jíná'an‑ró. Tú ní jí'i̱‑i, chi̱ kixí‑ni‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Te ni̱ ka̱sákátá‑i nuu̱‑yá, chi ni̱ kajini̱‑i ja̱ á ni̱ ji'i̱ su̱chí‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ko máá‑yá, ni̱ tɨɨn‑ya̱ ndá'a‑í. Te ni̱ ka'a̱n jaa‑ya̱: Súchi̱, nduko̱o, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yúan‑na te ni̱ nachaku̱‑i. Te ni̱ nduko̱o‑ni‑i. Te ni̱ tá'ú‑yá tiñu ja̱ ná kuá'a‑de staa̱ kée‑í. ");
INSERT INTO migNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Te táa̱‑i náa̱‑i, ni̱ ka̱kee nuu̱‑dé kánde̱'é‑de. Ko ni̱ tá'ú‑yá tiñu nuu̱‑dé ja̱ tú ni ɨɨn nuu̱ kachí‑de ja̱ súan ni̱ kuu. ");
INSERT INTO migNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Te ni̱ na̱stútú‑yá ndɨ́'uxí uu̱ cha̱a‑ún. Te ni̱ ja̱'a‑ya̱ fuerza ini̱‑de ja̱ kúndéé‑de jíín táká tachi̱ kíni jíín já kuánchaa̱‑de ta̱ká kue'e̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Te ni̱ tájí‑yá‑de kája'a̱n‑de ja̱ ná káni‑de tu̱'un ndasa koo ñuu̱ nuu̱ tá'ú Dios tiñu, te ná násáva̱'a‑de ña̱yɨvɨ káku'u̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ma̱ kúndiso kutɨ‑ro já kúu ichi, ni vara, ni ñunu, ni staa̱, ni xu̱'ún, ni ma̱ kúndiso‑ró úu̱ su'nu̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Te na̱ni ve'e kúu nú ni̱ kɨ̱vɨ‑ró, te kendo̱o‑ró yúan. Te yúan kenda‑ró kí'i̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Te nú ndé nuu̱ tú kákuni̱‑i kuatá'ú‑i róó, te nú ni̱ kenda‑ró ñúu̱ yúan, te skóyo‑ró tɨ́kacha̱ iní ja'a̱‑ro̱. Te súan kani ndaa̱‑ro̱ tú'un nuu̱‑í jíná'an‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Te ni̱ kenda‑de kája'a̱n‑de, ni̱ ka̱jíkó ndúu̱‑de ta̱ká ñuu̱, ni̱ ka̱jani‑de tu̱'un. Te ta̱ká lado ni̱ kana̱sáva̱'a‑de ña̱yɨvɨ káku'u̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Te Herodes, cha̱a tá'ú tíñu, ni̱ jini tu̱'un‑de ta̱ká tiñu ni̱ sá'a‑ya̱, te kúñáá ini̱‑de, chi̱ káka'a̱n sava‑i: Juan, cha̱a ni̱ ji'i̱, ni̱ nachaku̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Te sava tuku‑i: Ni̱ ndenda Elías. Te sava‑ga̱ tuku‑i: Ɨɨn cha̱a ni̱ jani tu̱'un Dios onde̱ sáá a ni̱ nachaku̱‑de. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Te ni̱ kachi̱ Herodes: Ni̱ janchaa̱‑ri̱ xini̱ Juan. Te ndé cha̱a kúu cha̱a yá'a núsáá, chi̱ jíni tu̱'un‑ri̱ ja̱ sá'a‑de tiñu yá'a, áchí‑de. Te ni̱ kuni̱‑de nde̱'é‑de nuu̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Te ni̱ nchaa̱ cha̱a káskuá'a‑ún. Te ni̱ ka̱nakani‑de tu̱'un nuu̱‑yá ta̱ká tiñu ni̱ ka̱sá'a‑de. Te ni̱ ki'in‑ya̱‑dé, te kua'a̱n sɨ́ɨn‑ya̱ jíín‑de ɨɨn nuu̱ ñú'un té'é, ñúu̱ nání Betsaida. ");
INSERT INTO migNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Te ni̱ kajini̱ ña̱yɨvɨ‑ún. Te ni̱ kandiki̱n‑i‑ya̱, kája'a̱n‑i jíín‑yá. Te ni̱ jatá'ú‑yá‑i, te ni̱ jani‑ya̱ tú'un ndasa koo ñuu̱ nuu̱ tá'ú Dios tiñu. Te ni̱ nasáva̱'a‑ya̱ táká ña̱yɨvɨ káku'u̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Te a kua̱'ini. Te ni̱ ncha̱koyo ndɨ́'uxí uu̱‑de nuu̱‑yá. Te ni̱ kaka'a̱n‑de jíín‑yá: Tájí‑ní ña̱yɨvɨ kuá'a̱ yá'a ná kíngoyo‑i ta̱ká ñuu̱ jíín táká rancho yani yá'a, te ndúkú‑i ndénu̱ ndo̱o‑i te ni'i̱n‑í staa̱ kée‑í, chi̱ yá'a nuu̱ ñú'un té'é ká'i̱in‑yó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Te ni̱ kachi̱‑ya̱ jíín‑de: Kua̱'a máá‑ró já ná kée‑í, áchí‑ya̱. Te ni̱ kaka'a̱n‑de: Tú na̱ún káñava̱'a‑ná, chi̱ u'u̱n‑ni sta̱tilá jíín úu̱‑ni ti̱yáká. Te nú túu kikua̱an‑ná staa̱ kée táká ña̱yɨvɨ yá'a, te ma̱ kánda, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chi̱ íó nátu̱'un u'u̱n mil cha̱a. Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a‑ún: Ka'a̱n jíín ñáyɨvɨ ná júngo̱o ɨɨn nuu ɨ́ɨn nuu‑í nátu̱'un uu̱ xiko uxi̱, uu̱ xiko uxi̱ ja̱ ɨ́ɨn ɨɨn, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Te súan ni̱ ka̱sá'a‑de, ni̱ ka̱súngo̱o ndɨ'ɨ‑de‑i. ");
INSERT INTO migNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Te ni̱ ki'in‑ya̱ ndɨ́'ú'u̱n sta̱tilá jíín úu̱ ti̱yáká‑ún. Te ni̱ ndakoto‑ya̱ íchi ándɨ́vɨ́ te ni̱ jika̱n ta'u̱‑yá ja'a̱ státilá. Te ni̱ sákuáchí‑yá sta̱tilá‑ún. Te ni̱ ja̱'a‑ya̱ núu̱ cháa káskuá'a jíín‑yá ni̱ ka̱jani‑de nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Te ndivii‑í ni̱ ka̱yee‑í. Te ni̱ kanda'a̱ chi̱i‑i. Te ni̱ ka̱nastútú‑de uxi̱ uu̱ ji̱ka staa̱ kua̱chí já ní ndendoso. ");
INSERT INTO migNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Te ɨɨn kɨvɨ̱ jikán ta'u̱ máá ɨ́ɨn‑ni Jesús, chi̱ máá‑ni cha̱a káskuá'a‑ún ká'i̱in‑de jíín‑yá. Te ni̱ jika̱ tu̱'ún‑yá‑de: Te ruu̱, na̱ cha̱a kúu‑ri̱, káka'a̱n ña̱yɨvɨ, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Te ni̱ kaka'a̱n‑de: Juan, cha̱a skuánducha, káka'a̱n‑i. Te sava‑i: Elías. Te sava‑ga̱‑i: Ɨɨn cha̱a ni̱ jani tu̱'un Dios onde̱ aná'án, ni̱ nachaku̱‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Te róó, na̱ cha̱a kúu‑ri̱ káka'a̱n máá‑ró, áchí‑ya̱. Yúan‑na te Simón Pedro, ni̱ ka'a̱n‑de: Máá‑ní kúu Cristo Se̱'e Dios, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yúan‑na te ni̱ ka'a̱n xaa̱n‑yá jíín‑de, te ni̱ tá'ú‑yá tiñu nuu̱‑dé ja̱ tú ni ɨɨn nuu̱ kachí‑de tu̱'un yá'a. ");
INSERT INTO migNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Te ni̱ ka'a̱n‑ya̱: Jínu ñú'ún ndó'o xaa̱n máá Sé'e cha̱a, te cha̱a ni̱ ka̱yii jíín táká sutu̱ ñá'nu jíín cháa káchaa tutu̱, ma̱ kuátú'ún‑de‑ya̱, chi̱ ka'ni‑dé‑ya̱. Te nuu̱ uní kɨvɨ̱ te nachaku̱‑ya̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Te ni̱ ka'a̱n‑ya̱ jíín ndɨ́'ɨ‑de: Na̱ni cha̱a nú kuní‑de kii‑de yata̱‑rí, te ma̱ chíñú'ún‑de máá‑de te ná kuándéé iní‑de jíín túndó'o kii sɨkɨ̱‑dé ta̱ká kɨvɨ̱, te ná kúndiki̱n‑de ruu̱ kii‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chi cha̱a jítú iní‑de ka̱ku‑de chi̱i tu̱ndó'o kii sɨkɨ̱‑dé, naa‑dé. Te va̱sa ná kúu̱ ɨɨn cha̱a ja̱ sɨkɨ́ rúu̱, ko ka̱ku‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Chi na̱ún ní'i̱n cháa, va̱sa ná kúndéé‑de ni'i̱n‑dé nɨ́ɨ́ ñúyɨ́vɨ, te nú xnáa‑dé máá‑de, xí síjíta‑de añú‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chi̱ nú ndé cha̱a kúka nuu̱ iní‑de nuu̱‑rí jíín núu̱ tú'un ká'a̱n‑ri̱, suni súan kuka nuu̱ iní máá Sé'e cha̱a nuu̱ cháa‑ún kɨvɨ̱ ndíi‑ya̱. Te kɨvɨ̱‑ún ñá'nu koto luu‑ya̱ jíín Táa̱‑ya̱, te suni jíín táká ndajá'a̱ ndóo‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Te ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ íó sava cha̱a ká'i̱in yá'a ja̱ má kúu̱ kutɨ‑dé onde̱ nú tú kuni̱‑de ñuu̱ nuu̱ tá'ú Dios tiñu. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yúan‑na te nátu̱'un nuu̱ uná kɨvɨ̱ já ní ka'a̱n‑ya̱ tú'un yá'a, te ni̱ jaka‑ya̱ Pedro, jíín Juan, jíín Jacobo, ni̱ kaa‑ya̱ kuá'a̱n‑ya̱ jíín‑de ɨɨn yuku, kuákaka̱n ta'u̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Te nini jikán ta'u̱‑yá, te nuu̱‑yá, tuku ni̱ nduu. Te sa'ma‑yá ní nduu kɨyi̱ xaa̱n. Te ni̱ ka̱nandii ncháa̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Te yúan ni̱ kanda̱tu̱'ún úu̱ cha̱a jíín‑yá. Te cha̱a‑ún kákuu Moisés jíín Elías. ");
INSERT INTO migNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Te kándii ncháa̱ cha̱a‑ún. Te ni̱ kaka'a̱n‑de tu̱'un ja̱ á yani skíkuu‑ya̱ tíñu‑ya̱ te kuu̱‑ya̱ ñúu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Te Pedro jíín cháa ká'i̱in jíín‑de‑ún káji'i̱ xaa̱n‑dé numa̱'ná te kákixi̱‑de. Te nuu̱ ní ka̱nata'u̱ núu̱‑dé, te ni̱ kajini̱‑de ja̱ ndíi ncháa̱ Jesús, jíín úu̱ cha̱a ká'i̱in jíín‑yá‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Te nuu̱ ní ka̱kuxio cha̱a‑ún nuu̱ Jesús, te ni̱ ka'a̱n Pedro jíín‑yá: Maestro, va̱'a‑ga̱ ná kéndo̱o‑yó yá'a. Te ná sá'a‑ná uni̱ ve'e kuii, ɨɨn kuu máá‑ní, ɨnga̱ kuu Moisés, te ɨnga̱ kuu Elías, áchí‑de. Te tú jiní‑de na̱ún tu̱'un ni̱ ka'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Te nini ká'a̱n‑de, Te ni̱ chaa̱ ɨɨn viko̱ nu̱'ún ní jasu̱ nɨ́ɨ́ núu̱‑dé jíná'an‑de. Te ni̱ kayu̱'ú xaa̱n‑dé ja̱ ní kɨ̱vɨ koyo‑de chi̱i viko̱ nu̱'ún‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Te chi̱i viko̱ nu̱'ún yúan, ni̱ kenda ɨɨn tu̱'un ja̱ ní ka'a̱n: Ya̱'á kúu Se̱'e‑ri̱, ja̱ kúndá'ú ini̱‑ri̱‑i, te kuni ná'ín‑ró tú'un ká'a̱n‑ya̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Yúan‑na te ni̱ jukuiñi̱ tu̱'un‑ún. Te máá ɨ́ɨn‑na̱ Jesús kándii̱‑ya̱ núu̱‑dé. Te máá‑de tú ní káka'a̱n kutɨ‑dé. Te nɨ́ɨ́‑ni kɨvɨ̱‑ún tú ni ɨɨn nuu̱ ní kákachi̱‑de ja̱ súan ni̱ kajini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Te ɨnga̱ kɨvɨ̱ xía̱n‑ún, ni̱ ka̱nuu‑ya̱ yúku‑ún. Te ɨɨn ña̱yɨvɨ kuá'a̱, ni̱ kenda‑i ni̱ ka̱jata'a̱n‑i Jesús. ");
INSERT INTO migNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Te nuu̱ ñáyɨvɨ kuá'a̱‑ún ni̱ kenda ɨɨn cha̱a ni̱ kana jaa‑de: Maestro, jikán ta'u̱‑ná nuu̱‑ní ja̱ ndé'é‑ní se̱'e‑ná, chi̱ máá ɨ́ɨn‑i ñáva̱'a‑ná. ");
INSERT INTO migNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chi̱ ɨɨn tachi̱ kíni tɨ́ɨn‑ni‑i. Te sanaa‑ní te kána kó'ó‑i sá'a, te já'ni yí'í‑ni‑i. Te sjáa‑ni ti'iñu̱ yu'u‑í. Te xaa̱n stují‑í. Te xaa̱n ú'u̱ kénda. ");
INSERT INTO migNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Te ni̱ ka'a̱n nda̱'ú‑ná jíín cháa káskuá'a jíín‑ní yá'a ja̱ ná kíñi'in‑de ki'i̱n. Te tú ní kákuu sá'a‑de, áchí‑de jíín Jesús. ");
INSERT INTO migNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Te ni̱ ka'a̱n Jesús: Ña̱yɨvɨ xáa̱n ní'in ini̱ kákuu‑ró já tú kákandíja‑ró. Na̱saa‑ga̱ kɨvɨ̱ kúnchaa̱‑ri̱ jíín‑ró te ndo'o‑ri̱ jíín‑ró. Kua̱'a se̱'e‑ró ná kíi‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Te nini ni̱ kandita‑i nuu̱‑yá, te tachi̱ kíni ni̱ stúncháa̱‑ni‑i. Te ni̱ ja'ni yí'í xáa̱n‑ní‑i. Ko máá Jesús ni̱ ka'a̱n xaa̱n‑yá nuu̱ tachí kíni‑ún. Te ni̱ nasáva̱'a‑ya̱ súchí‑ún. Te ni̱ nakua̱'a‑ya̱‑í nuu̱ táa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Te ndivii ñáyɨvɨ ní ka̱naa iní‑i kánde̱'é‑i ndasa ñá'nu káa Dios. Te ni̱ ka̱kee nuu̱‑í kánde̱'é‑i ta̱ká tiñu ni̱ sá'a Jesús. Te ni̱ ka'a̱n Jesús jíín cháa káskuá'a jíín‑yá: ");
INSERT INTO migNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Chu'un tu̱'un yá'a ini̱‑ro̱ jíná'an‑ró. Chi̱ máá Sé'e cha̱a natu̱u‑ya̱ iní nda'a cháa ká'i̱o kua̱chi, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ko máá‑de, tú ní kájuku̱'un ini̱‑de tu̱'un yá'a. Chi ni̱ ka'a̱n sa̱'í‑ya̱ tú'un yá'a náva̱'a ma̱ júku̱'un ini̱‑de. Te ni̱ kayu̱'ú‑de kaka̱ tu̱'ún‑de‑ya̱ sɨkɨ́ tú'un‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yúan‑na te ni̱ ka̱státá'an‑de nú ndé cha̱a kúñá'nu‑ga̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ko Jesús, ni̱ jini̱‑ya̱ já súan kájani ini̱‑de. Te ni̱ ki'in‑ya̱ ɨ́ɨn su̱chí lúlí. Te ni̱ jani‑ya̱‑í xiin‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Cha̱a ja̱ jíín sɨ́'vɨ́‑rí játá'ú‑de su̱chí yá'a, te ruu̱ játá'ú‑de. Te cha̱a játá'ú rúu̱, játá'ú‑de i̱'a̱ ni̱ tájí rúu̱ va̱i‑ri̱. Te cha̱a súchí‑ga̱ ma̱'ñú róó jíná'an‑ró, cha̱a‑ún kúñá'nu‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yúan‑na te ni̱ ka'a̱n Juan: Maestro, ni̱ kajini̱‑ná ɨɨn cha̱a ja̱ jíín sɨ́'vɨ́‑ní kíñi'in‑de tachi̱ kíni kája'a̱n, te ni̱ kajasu̱‑ná nuu̱‑dé, chi̱ tú ndikín‑de yóó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ko ni̱ ka'a̱n Jesús jíín‑de: Ma̱ kasú‑ro̱ núu̱‑dé jíná'an‑ró, chi cha̱a tú jíto u'u̱ yóó, jíín yóó ndújíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Te ni̱ kuyani jaa̱ kɨvɨ̱ nó'o̱n máá‑yá onde̱ andɨ́vɨ́. Te ni̱ chaa téyíí iní‑ya̱ já kí'i̱n‑ya̱ ñúu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Te ni̱ tájí‑yá cha̱a kua'a̱n jíín tú'un káyo̱xnúú‑de nuu̱‑yá. Te cha̱a‑ún kája'a̱n‑de. Te ni̱ kɨ̱vɨ‑de ɨɨn ñuu̱ Samaria náva̱'a sátu̱'a‑de te vásá jáa̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ko ña̱yɨvɨ yúan tú ní kájatá'ú‑i‑ya̱, chi ni̱ kajini̱‑i ja̱ íchi ñúu̱ Jerusalén ki'i̱n‑ya̱ núú. ");
INSERT INTO migNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Te Jacobo jíín Juan, cha̱a káskuá'a jíín‑yá, ni̱ kajini̱‑de yu̱án. Te ni̱ kaka'a̱n‑de: Táta̱, á tú kuní‑ní ná tá'ú tíñu‑yó kíi ñu'u̱n ichi ándɨ́vɨ́ te ná xndɨ́'ɨ ña̱yɨvɨ yá'a, nátu̱'un ni̱ sá'a Elías. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yúan‑na te ni̱ jíó káva Jesús nuu̱‑dé. Te ni̱ ka'a̱n xaa̱n‑yá jíín‑de: Tú kájini̱‑ro̱ ndasa káa ini̱‑ro̱, ");
INSERT INTO migNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","chi̱ máá Sé'e cha̱a, tú va̱i‑ya̱ já xnáa‑yá añú ña̱yɨvɨ, chi̱ sua nama‑ya̱‑í, áchí‑ya̱. Te kája'a̱n‑ya̱ ɨngá ñuu̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Te kájika‑ya̱ kuá'a̱n‑ya̱. Te ɨɨn cha̱a ni̱ ka'a̱n‑de jíín‑yá ichi‑ún: Táta̱, kundiki̱n‑ná níí va̱sa ndé onde̱ ki'i̱n‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Te ni̱ kachi̱ Jesús jíín‑de: Ta̱ká ñu̱kuii, ká'i̱o yau̱ kava káyi̱'i‑tɨ̱, te suni tɨsaa̱ andɨ́vɨ́ ká'i̱o taka̱‑tɨ̱. Ko máá Sé'e cha̱a, tú nuu̱ kusú‑ya̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Te ni̱ ka'a̱n‑ya̱ jíín ɨngá‑de: Kundiki̱n ruu̱ ná kí'o̱n, áchí‑ya̱. Te máá cháa‑ún ni̱ kachi̱‑de: Táta̱, kua̱'a‑ní tu̱'un ná kíchindu̱ji‑ná táa̱‑ná xna'a̱n‑ga̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Te ni̱ ka'a̱n Jesús jíín‑de: Skéndo̱o ta̱ká ndɨ̱yi‑ún ná chíndu̱ji tá'an ndɨ̱yi jíná'an. Te róó kuá'án te kani‑ró tú'un ta̱ká lado, ndasa koo ñuu̱ nuu̱ tá'ú Dios tiñu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yúan‑na te suni ni̱ ka'a̱n ɨnga̱‑de: Táta̱, kundiki̱n‑ná níí, ko kua̱'a‑ní tu̱'un ná kíka'a̱n‑ná xna'a̱n‑ga̱ jíín já ká'i̱o ve'e‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Ɨɨn cha̱a nú jítu‑de jíín latú‑de, te ndé'é‑de ichi yatá‑dé, tú va̱'a cha̱a kúu‑de ja̱ kɨ́vɨ‑de ini̱ ñuu̱ nuu̱ tá'ú Dios tiñu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yúan‑na te onde̱ ni̱ kuu ta̱ká tiñu yá'a, te máá Jíto'o̱‑yo̱ ní jani‑ya̱ uní xiko uxi̱‑ga̱‑de. Te cha̱a‑ún, ni̱ tájí‑yá uu̱ uu̱‑de káyoxnúú‑de nuu̱‑yá kua'a̱n‑de ta̱ká ñuu̱ jíín lugar nuu̱ á jáni ini̱ máá‑yá ja̱ kí'i̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Trigo ta'nu̱, ja̱ndáa̱ kúu ja̱ kuá'a̱, ko cha̱a ka'nu̱ yaku̱‑ni‑de íó. Núsáá, te kaka̱n ta'u̱‑ro̱ núu̱ máá Tatá xíin trigo, ná tájí‑yá cha̱a ka'nu̱ kikoyo‑de nuu̱ trigo‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kuá'án jíná'an‑ró. Ná kástu̱'ún‑rí nuu̱‑ro̱, chi̱ tájí‑rí róó ki'i̱n‑ro̱ nátu̱'un lélú má'ñú yí'ɨ̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Te ma̱ kúndiso‑ró bolsa, ni ñunu, ni ndija̱n‑ro̱. Te nú ndéja̱ ní ketá'an‑ró jíín íchi, te ma̱ ndátu̱'ún‑ró jíín. ");
INSERT INTO migNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Te na̱ni ve'e nú kɨ̱vɨ‑ró, te xna'a̱n‑ga̱ ka'a̱n‑ro̱: Ná sándéé iní ve̱'e yá'a, achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Te nú ini̱ ve̱'e yúan íó ɨɨn cha̱a va̱'a ini̱, te tu̱'un ndéé ní ka'a̱n‑ro̱‑ún ná jáa̱ sɨkɨ̱‑dé. Te nú tú kánchaa̱ ɨɨn cha̱a va̱'a ini̱, te tu̱'un ndéé‑ún najaa̱‑ni nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Te suni ve'e yúan kendo̱o‑ró, te kee‑ro, ko'o‑ró na̱ún kája̱'a‑i nuu̱‑ro̱. Chi cha̱a sátiñu, ni'i̱n‑dé kee‑dé. Ma̱ káka‑ró ndɨ́ta'a̱n ve'e. ");
INSERT INTO migNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Te na̱ni ñuu̱ nú ni̱ kɨ̱vɨ koyo‑ró, te nú kuatá'ú‑i róó, yúan te kaji‑ro jíná'an‑ró na̱ún kájani‑i nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Te nasáva̱'a‑ró ñáyɨvɨ káku'u̱ káxiu̱kú‑i ñuu̱ yúan. Te kachi̱‑ro̱ kúni‑i: Nuu̱‑ro̱ jíná'an‑ró, a yani koo ñuu̱ nuu̱ tá'ú Dios tiñu, achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ko na̱ni ñuu̱ nú ni̱ kɨ̱vɨ koyo‑ró, te nú tú ní kájatá'ú‑i róó, te kenda koyo‑ró iní ichi‑í yúan, te ka'a̱n‑ro̱: ");
INSERT INTO migNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Onde̱ tɨkacha̱ ñú'un íó ñuu̱‑ro̱ yá'a ni̱ tɨ̱ɨn ini̱ ja'a̱‑rí jíná'an‑ri̱, ná náskóyo‑ri̱ ja̱ kúu sɨkɨ̱ máá‑ró. Te kuni̱‑ro̱, ja̱ á yani koo ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Te ká'a̱n‑ri̱ jíín‑ró, kɨvɨ̱‑ún te koo‑ga̱ tu̱ká'nu ini̱ ya̱ núu̱ ñáyɨvɨ ñúu̱ Sodoma, vásá núu̱ ñúu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Naka̱ ndá'ú kuu róó ñuu̱ Corazín, te naka̱ ndá'ú kuu róó ñuu̱ Betsaida. Chi̱ nú ini̱ ñuu̱ Tiro jíín iní ñuu̱ Sidón ní sá'a‑ri̱ tiñu ñá'nu ja̱ ní sá'a‑ri̱ nuu̱ máá‑ró yá'a núú, te ɨnga̱ kɨvɨ̱ te a ni̱ ka̱nakani ini̱ ña̱yɨvɨ‑ún núú, te ku'un‑i sa'ma ndáí te ku'u‑í yaa̱ núu̱‑í núú. ");
INSERT INTO migNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Núsáá te kɨvɨ̱ kíi juicio te koo‑ga̱ tu̱ká'nu ini̱‑ya̱ núu̱ ñúu̱ Tiro jíín núu̱ ñúu̱ Sidón vásá núu̱ máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Te róó, ñuu̱ Capernaum, a ni̱ kuñá'nu xaa̱n‑ro̱ jiní‑ro̱ náún, ko onde̱ infierno najinu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Cha̱a jíni so̱'o tu̱'un ká'a̱n máá‑ró, nuu̱‑rí jíni so̱'o‑de. Te cha̱a sájá'a̱ ini̱ nuu̱‑ro̱, nuu̱‑rí sájá'a̱ ini̱‑de. Te cha̱a sájá'a̱ ini̱ nuu̱‑rí, sájá'a̱ ini̱‑de nuu̱ I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Te ni̱ naja̱koyo uni̱ xiko uxi̱ cha̱a‑ún kákusɨɨ̱ iní‑de, te káka'a̱n‑de: Táta̱, onde̱ tachi̱ kíni kájandatu̱ nuu̱‑ná ja̱ jíín sɨ́'vɨ́‑ní vidáa̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Te Jesús, ni̱ ka'a̱n‑ya̱ jíín‑de: Ni̱ jini̱‑ri̱ nuu̱ Satanás ni̱ jungava ichi ándɨ́vɨ́, nátu̱'un ɨɨn taja. ");
INSERT INTO migNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Vina te kua̱'a‑ri̱ fuerza nuu̱‑ro̱ náva̱'a kuañu̱‑ro̱ sɨkɨ́ kóo̱ jíín sɨkɨ́ kúrsiuku̱, jíín sɨkɨ́ táká fuerza máá já jíto u'u̱ yóó. Te tú na̱ún sá'a kutɨ jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ko ma̱ kúsɨɨ̱ iní‑ro̱ jíín tíñu yá'a ja̱ kájandatu̱ tachi̱ núu̱‑ro̱, chi̱ sua ná kúsɨɨ̱ iní‑ro̱ já á káyo̱so sɨ́'vɨ́‑ró ondé andɨ́vɨ́. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Te suni hora‑ún ni̱ kusɨɨ̱ iní Jesús, onde̱ jíín Espíritu Santo, te ni̱ ka'a̱n‑ya̱: Ná kúta'u̱‑ná nuu̱‑ní Táa̱, Jito'o̱ andɨ́vɨ́ jíín ñúyɨvɨ kúu máá‑ní, ja̱ ní jasu̱‑ní ta̱ká tu̱'un yá'a nuu̱ cháa ndíchí jíín núu̱ cháa kájuku̱'un ini̱. Te ni̱ stá'a̱n ndiji̱n‑ní nuu̱ cháa súchí iní jíná'an‑de. Chi̱ súan ni̱ jata'a̱n ini̱‑ní Táa̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ta̱ká ndatíñu ni̱ ja̱'a Táa̱‑ri̱ ini̱ nda'a‑rí. Te tú ni ɨɨn jiní nuu̱ máá Sé'e, chi̱ máni máá Táa̱ jiní‑ya̱. Ni tú jiní ni ɨɨn nuu̱ máá Táa̱, chi̱ máá Sé'e jiní, jíín na̱ni cha̱a ja̱ kuní máá Sé'e te stá'a̱n ndiji̱n‑ya̱ núu̱‑dé. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Te sɨ́ɨn ni̱ jíó káva máá Jesús nuu̱ cháa káskuá'a jíín‑yá. Te ni̱ ka'a̱n‑ya̱: Xáán ndatu̱ cha̱a kuni̱ tiñu ja̱ ní kajini̱ máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Chi̱ ká'a̱n‑ri̱ jíín‑ró ja̱ kuá'a̱ cháa kájani tu̱'un Dios jíín cháa kákuu rey, ni̱ kakuni̱‑de nde̱'é‑de nuu̱ já kánde̱'é máá‑ró, ko tú ní kájini̱‑de, te kuni so̱'o‑de ja̱ ní kájini so̱'o‑ró kuní‑de núú, ko tú ní kájini so̱'o‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Te yúan kánchaa̱ ɨɨn maestro ley, te ni̱ ndukuiñi̱‑de chi̱ koto nchaa̱‑de‑ya̱ kuní‑de: Maestro, na̱ún sá'a‑ná náva̱'a ni'i̱n tá'u̱‑ná kuchaku̱‑ná nɨ́ɨ́ káni, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Te ni̱ ka'a̱n máá Jesús jíín‑de: Ndasa yóso núu̱ tutú ley. Ndasa ká'a̱n ká'u‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Te máá cháa‑ún ni̱ ka'a̱n‑de: Kumani̱‑ro̱ jíín máá Tatá‑ro̱ Dios onde̱ jíín iní jíín añú‑ro̱ jíín nɨ́ɨ́ fuerza‑ro̱ jíín nɨ́ɨ́ núu̱ jiní tuní‑ro̱, te kundá'ú ini̱‑ro̱ tá'an‑ró nátu̱'un kúndá'ú ini̱‑ro̱ máá‑ró, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Te ni̱ kachi̱ Jesús jíín‑de: Va̱'a ni̱ ka'a̱n‑ro̱. Sá'a súan, te ni'i̱n tá'u̱‑ro̱ kúchaku̱‑ro̱ núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ko máá cháa‑ún, kuní‑de ja̱ kée ndaa̱‑de jíín tú'un ká'a̱n‑de, te ni̱ jika̱ tu̱'ún‑de Jesús: Te ndéja̱ kúu tá'an‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Te máá Jesús ni̱ ka'a̱n‑ya̱: Ɨɨn cha̱a ni̱ kenda‑de ñuu̱ Jerusalén. Te ni̱ kuun‑de kua'a̱n‑de ñuu̱ Jericó. Te ichi‑ún ni̱ kenda ñakui̱'ná núu̱‑dé, te ni̱ ka̱janchaa̱ ndatíñu‑de, te ni̱ ka̱stují‑dé. Te ni̱ kee kája'a̱n, ni̱ ndo̱o cha̱a‑ún kátúu‑dé. Te a yani kuu̱‑de núú. ");
INSERT INTO migNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Te ni̱ kuu ja̱ íchi‑ún ni̱ kuun ɨɨn sutu̱ va̱i‑de. Te ni̱ jini̱‑de nuu̱ cháa‑ún. Te ni̱ sío‑ni‑de kua'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Suni súan ɨɨn cha̱a levita, ni̱ kuyani‑de lugar yúan. Te ni̱ jini̱‑de nuu̱ cháa‑ún. Te ni̱ sío‑ni‑de kua'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ko ɨɨn cha̱a ñuu̱ Samaria, jíka‑de kua'a̱n‑de ichi‑ún, ni̱ kuyani‑de nuu̱ kátúu cháa‑ún. Te ni̱ jini̱‑de. Te ni̱ kundá'ú ini̱‑de cha̱a‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Te ni̱ jaa̱‑de. Te ni̱ chu'un‑de aceite jíín alcohol nuu̱ ní tuji̱ cháa‑ún. Te ni̱ ju'ni̱‑de nuu̱. Te ni̱ skáa‑de cha̱a‑ún sɨkɨ̱ caballo‑de. Te kua'a̱n‑de jíín‑de onde̱ mesón. Te ni̱ jito‑de cha̱a. ");
INSERT INTO migNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Te ɨnga̱ kɨvɨ̱ xía̱n‑ún ni̱ kenda‑de kua'a̱n‑de. Te ni̱ tava‑dé uu̱ peso ni̱ ja̱'a‑de nuu̱ cháa xíin mesón. Te ni̱ ka'a̱n‑de: Koto‑ní‑de. Jíín táká‑ga̱ ja̱ kanú‑ní jíín‑de, te nuu̱ ncháa̱‑ná, te nachunáa‑ná nuu̱‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Núsáá te ja̱ uní tá'a̱n cha̱a‑ún, te ndé ɨɨn‑de ni̱ kuu tá'an cha̱a ni̱ kenda ñákui̱'ná nuu̱‑ún, jáni ini̱‑ro̱, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Te ni̱ ka'a̱n máá cháa‑ún: Cha̱a ni̱ kundá'ú ini̱‑de‑ún, áchí‑de. Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de: Kuá'án núsáá, te suni súan sá'a máá‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Te jíka‑ya̱ kuá'a̱n‑ya̱ íchi. Te ni̱ kɨ̱vɨ‑ya̱ ɨ́ɨn ñuu̱. Te ɨɨn ñasɨ́'ɨ́, nání‑ña Marta, ni̱ kana‑ña xiní‑yá ni̱ kɨ̱vɨ‑ya̱ iní ve̱'e‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Te ña'an yá'a, íó ɨɨn ku'u̱‑ña nání María. Te María‑ún, ni̱ jungo̱o‑ña núu̱ já'a̱ Jesús, jíni ná'ín‑ña tú'un ká'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ko Marta kútéñu‑ña já tɨnɨ́ tiñu sá'a‑ña. Te ni̱ jaa̱‑ña núu̱‑yá, te ni̱ kachi̱‑ña: Táta̱, tú ndé'é‑ní ja̱ kú'u̱‑ná ni̱ xndóo‑i náá játíñu máá ɨ́ɨn‑ná. Núsáá te ka'a̱n‑ní jíín‑i ná chíndéé tá'an‑i jíín‑ná. Achí‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ko ni̱ ka'a̱n Jesús: Marta, Marta, xaa̱n jítú iní‑ro̱ sátiñu‑ró, te ja̱ kuá'a̱ tíñu sá'a‑ró, te ni̱ ndukuí'a̱ ini̱‑ro̱ jíín. ");
INSERT INTO migNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ko íó ɨɨn‑ni tiñu kánúú xáa̱n. Te María, ni̱ naka̱ji‑i tiñu kánúú‑ún. Te ni ɨɨn, ma̱ kúu kuanchaa̱ nuu̱‑í. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Te ni̱ kuu ja̱ jikán ta'u̱‑yá kánchaa̱‑ya̱ ɨ́ɨn lugar. Te nuu̱ ní ndɨ'ɨ ni̱ ka'a̱n‑ya̱, te ɨɨn cha̱a káskuá'a jíín‑yá, ni̱ ka'a̱n‑de jíín‑yá: Táta̱, stá'a̱n‑ní nuu̱‑ná ndasa kaka̱n ta'u̱‑ná jíná'an‑ná, nátu̱'un ni̱ stá'a̱n Juan nuu̱ cháa káskuá'a jíín‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Te ni̱ kachi̱‑ya̱ jíín‑de: Nú kájika̱n ta'u̱‑ro̱, te sua ka'a̱n‑ro̱: Táa̱ máá‑ná ja̱ kánchaa̱‑ní onde̱ andɨ́vɨ́, ná nákana jaa‑ná níí jíín sɨ́'vɨ́‑ní. Te ná kóo ñuu̱ nuu̱ tá'ú‑ní tiñu. Te ná kóo ta̱ká tiñu játa'a̱n ini̱ máá‑ní, nátu̱'un íó ini̱ andɨ́vɨ́ suni súan ná kóo ini̱ ñu̱yɨ́vɨ yá'a. ");
INSERT INTO migNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Staa̱ káyee‑ná ta̱ká kɨvɨ̱ kuá'a‑ní nuu̱‑ná vina. ");
INSERT INTO migNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Te sá'a‑ní tu̱ká'nu ini̱‑ní nuu̱ táká kua̱chi‑ná, chi̱ suni máá‑ná kásá'a‑ná tu̱ká'nu ini̱‑ná nuu̱ ñáyɨvɨ kásá'a‑i falta nuu̱‑ná. Te ma̱ skɨ́vɨ‑ní náá koto nchaa̱‑i náá chi̱ sua nama‑ní náá nuu̱ kíni nuu̱ kuí'a̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Te ni̱ ka'a̱n‑ga̱‑ya̱ jíín‑de: Ndé róó íó ɨɨn amigo‑ro̱ te nú ki'i̱n‑ro̱ núu̱‑dé sava ñúú te kachi̱‑ro̱ kúni‑de: Amigo, kua̱'a núu uni̱ staa̱ núu̱‑rí, ");
INSERT INTO migNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","chi̱ ɨɨn amigo‑ri̱ ni̱ chaa̱‑de ve'e‑ri̱ ja̱ jíka‑de viaje. Te tú na̱ún kuá'a‑ri̱ nuu̱‑dé kee‑dé. Achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Te cha̱a kándee ichi iní ve̱'e ka'a̱n‑de: Ma̱ stá'a̱n‑ro̱ rúu̱, chi̱ a ndasú yuxé'é‑rí, te se̱'e‑ri̱ kákixi̱‑i jíín‑rí. Te ma̱ kúu nduko̱o‑ri̱ te kua̱'a‑ri̱ nuu̱‑ro̱. Achi̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ká'a̱n‑ri̱ jíín‑ró, va̱sa ma̱ ndúko̱o‑de kua̱'a‑de nuu̱‑ro̱ já kúu‑de amigo‑ro̱, ko ja̱ xáa̱n stá'a̱n‑ro̱‑dé te yu̱án ndúko̱o‑de te kua̱'a‑de ta̱ká ja̱ jínu ñú'ún‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Te ká'a̱n‑ri̱ jíín‑ro̱ jíná'an‑ró: Kaka̱n, te kua̱'a‑ya̱ núu̱‑ro̱. Ndúkú, te ni'i̱n‑ro̱. Ka'a̱n, te ná núña ve'e kɨ̱vɨ‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chi cha̱a jikán, te kíi nuu̱‑dé. Te cha̱a ndúkú, te ní'i̱n‑dé. Te cha̱a ká'a̱n, te núña ve'e kɨ̱vɨ‑de. ");
INSERT INTO migNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Te ndé ɨɨn róó ɨɨn táa̱ ini̱ ve̱'e kúu‑ró. Te nú se̱'e‑ró jikán‑i staa̱ núu̱‑ro̱, te kua̱'a‑ró ɨ́ɨn yuu̱ núu̱‑í náún. Xí nú jikán‑i ɨɨn ti̱yáká, te lugar ja̱ kuá'a‑ró tíyáká, te kua̱'a‑ró ɨ́ɨn koo̱ nuu̱‑í náún. ");
INSERT INTO migNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Xí nú jikán‑i ɨɨn ndɨvɨ̱ núu̱‑ro̱, te kua̱'a‑ró ɨ́ɨn kúrsiuku̱ nuu̱‑í náún. ");
INSERT INTO migNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Te nú róó va̱sa cha̱a ñáá kákuu‑ró, te kájini̱‑ro̱ kuá'a‑ró ndátíñu va̱'a nuu̱ sé'e‑ró, naga̱ ni̱ kuu máá Táa̱‑ro̱ I'a̱ kánchaa̱ andɨ́vɨ́ já má kuá'a‑ya̱ Espíritu Santo nuu̱ cháa jikán núsáá. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Te kíñi'in‑ya̱ ɨ́ɨn tachi̱ ñí'ín. Te nuu̱ ní kenda tachi̱‑ún kua'a̱n, te cha̱a ñí'ín‑ún ni̱ naka'a̱n‑de. Te ta̱ká ña̱yɨvɨ ká'i̱in yúan ni̱ ka̱kee nuu̱‑í kánde̱'é‑i. ");
INSERT INTO migNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ko sava ña̱yɨvɨ‑ún ni̱ kaka'a̱n‑i: Jíín Beelzebú, cha̱a kúñá'nu nuu̱ táká tachi̱, kíñi'in‑de tachi̱ kája'a̱n, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Te sava‑ga̱‑i kájito nchaa̱‑i‑ya̱. Te ni̱ kajika̱n‑i ɨɨn tuni̱ ichi ándɨ́vɨ́ núu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ko máá Jesús ni̱ jini̱‑ya̱ já súan kájani ini̱‑i. Te ni̱ ka'a̱n‑ya̱ jíín‑i: Te nú ɨɨn ñuu̱ sásɨ́ɨn máá, te kánakua̱tá'an máá, te ñuu̱ yúan ma̱ kúni̱'in. Te nú ɨɨn ve'e sásɨ́ɨn máá te kánakua̱tá'an máá, te ve'e yúan ma̱ kúni̱'in. ");
INSERT INTO migNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Te nú Satanás suni sásɨ́ɨn máá, ndasa kuni̱'in ñuu̱ nuu̱ tá'ú tíñu máá núsáá. Chi̱ káka'a̱n máá‑ró ja̱ jíín Beelzebú kíñi'in‑ri̱ tachi̱‑ún kája'a̱n. ");
INSERT INTO migNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Te nú ndújíín Beelzebú jíín‑rí ja̱ kíñi'in‑ri̱ tachi̱ kíni. Núsáá te se̱'e‑ró, ndé jíín kákiñi'in máá‑i tachi̱‑ún. Ja̱ yúán máá‑i, ná nákuxndíi‑i sɨkɨ̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ko nú jíín xiní ndá'a Dios kíñi'in‑ri̱ tachi̱ kíni kája'a̱n, ja̱ndáa̱ kúu ja̱ núu̱‑ro̱ ní chaa̱ ñuu̱ nuu̱ tá'ú Dios tiñu núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nú ɨɨn cha̱a kándáján, te jíín machete ndíto‑de yujé'é‑de, yúan‑na te ká'i̱in va̱'a ta̱ká ndatíñu‑de. ");
INSERT INTO migNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ko nú jaa̱ ɨnga̱ cha̱a ni̱'in‑ga̱ vásá máá‑de, yúan‑na te kundéé cháa‑ún jíín‑de, te kuanchaa̱ ndɨ'ɨ‑ni machete‑de nuu̱‑dé ja̱ ndíto‑de jíín. Te kiñi'in ndɨ'ɨ ndatíñu‑de. ");
INSERT INTO migNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nú ndé cha̱a tú ndújíín‑de jíín‑rí, núsáá te jíto u'u̱‑de ruu̱. Te cha̱a tú nástútú jíín‑rí, jachá‑de. ");
INSERT INTO migNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nú ni̱ kenda ɨɨn tachi̱ kíni ini̱ ɨɨn cha̱a te jíka kuu nuu̱ ñú'un té'é, ndúkú núu̱ júngo̱o te tú ní'i̱n, yúan‑na te ka'a̱n: Ná nó'o̱n‑ri̱ ve'e nuu̱ ní kenda‑ri̱, achi̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Te nú ni̱ nchaa̱ te jiní ja̱ vé'e luu kúu, chi ni̱ ndundoo, ");
INSERT INTO migNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","yúan‑na te ki'i̱n tachi̱‑ún, te kuaka tá'an jíín usiá‑ga̱ tachi̱ ñáá‑ga̱ káa vásá máá. Te kɨ̱vɨ koyo, te kuxiu̱kú yúan. Núsáá te ví'í‑gá tá'a̱n cha̱a yúan onde̱ sandɨ̱'ɨ́‑na̱ vásá já xnáñúú núú, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Te ni̱ kuu ja̱ ká'a̱n‑ya̱ tú'un yá'a. Te ɨɨn ña'an kándee ma̱'ñú ñáyɨvɨ kuá'a̱‑ún, ni̱ kana jaa‑ña xiní‑yá: Xáán ndatu̱ ña'an ní skáku níí, te ni̱ skáxin‑ña níí, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Te ni̱ ka'a̱n‑ya̱: Sua ndatu̱‑ga̱ kúu ña̱yɨvɨ kájini so̱'o tu̱'un Dios, te káchu'un ini̱‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Te ni̱ kataka̱ ña̱yɨvɨ núu̱‑yá, te ni̱ ka'a̱n‑ya̱: Ña̱yɨvɨ ñáá yá'a, kájika̱n‑i tuni̱, ko ma̱ kuá'a‑ri̱ nuu̱‑í, chi̱ tuni̱ Jonás kúu ja̱ kíi nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Chi̱ nátu̱'un Jonás, ni̱ kuu‑de ɨɨn tuni̱ nuu̱ cháa ñuu̱ Nínive, suni súan máá Sé'e cha̱a kuu‑ya̱ ɨ́ɨn tuni̱ nuu̱ ñáyɨvɨ yá'a jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Te reina onde̱ ichi sur, nachaku̱‑ña jíín ñáyɨvɨ yá'a kɨvɨ̱ kíi juicio. Te naku̱xndíi‑ña sɨkɨ́‑í. Chi̱ onde̱ jíká xáa̱n ní kii‑ña ní jini so̱'o‑ña tú'un ndíchí ní ka'a̱n Salomón. Te vina ví'í‑gá kúñá'nu I'a̱ kándii̱ yá'a vásá Salomón. ");
INSERT INTO migNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ta̱ká cha̱a ñuu̱ Nínive nachaku̱‑de jíín ñáyɨvɨ yá'a kɨvɨ̱ kíi juicio, te naku̱xndíi‑de sɨkɨ̱‑í. Chi̱ máá‑de ni̱ ka̱nakani ini̱‑de kɨvɨ̱ ní jani Jonás tu̱'un nuu̱‑dé. Te vina ví'í‑gá kúñá'nu I'a̱ kándii̱ yá'a vásá Jonás. ");
INSERT INTO migNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tú ni ɨɨn cha̱a, nú ni̱ chi'i‑de ñu'u̱n xini̱ yítɨ, te chisa̱'í‑de yitɨ‑ún chi̱i nu̱ndóó. Chi̱ sua kani‑de nuu̱ candelero, náva̱'a ná kuní ña̱yɨvɨ kɨ́vɨ koyo ini̱ ve̱'e, nuu̱ máá luz. ");
INSERT INTO migNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lámpara yikɨ kúñu kúu nduchi‑yo. Te nú nduchi‑ro íó va̱'a, nɨ́ɨ́‑ni yikɨ kúñu‑ró ndíi ncháa̱. Ko nú nduchi‑ro káñáá, te nɨ́ɨ́‑ni yikɨ kúñu‑ró kándee ñu̱ñáa. ");
INSERT INTO migNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Koto ñúkúún‑ró máá‑ró núsáá, chi̱ luz kándee ini̱‑ro̱ sanaa te ñu'u̱n tu̱ún kúu. ");
INSERT INTO migNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nú nɨ́ɨ́ yíkɨ kúñu‑ró ndíi ncháa̱, ni tú íó ɨɨn tí'li̱ nuu̱ túún, nɨ́ɨ́ nándii ncháa̱ núsáá, nátu̱'un ɨɨn lámpara ja̱ xú'ún kayú. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Te nini ká'a̱n‑ya̱, te ni̱ ka'a̱n nda̱'ú‑ni ɨɨn cha̱a fariseo jíín‑yá ja̱ kée‑yá staa̱ jíín‑de. Te ni̱ kɨ̱vɨ Jesús ini̱ ve̱'e cha̱a‑ún. Te ni̱ jungo̱o‑ya̱ kée‑yá staa̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Te cha̱a‑ún, ni̱ jini̱‑de nuu̱‑yá. Te ni̱ naa iní‑de ndé'é‑de ja̱ tú ní nándá'á‑yá te yée‑yá staa̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Te máá Jíto'o̱‑yo̱ ní ka'a̱n‑ya̱ jíín‑de: Ja̱ndáa̱ kúu, chi̱ róó, cha̱a fariseo, kánakacha‑ró íchi yatá tɨ́ndo'o̱ jíín íchi yatá kó'o̱. Ko ichi iní‑ro̱, chi ni̱ ka̱chítú ndɨ́ɨ‑ro jíín tú'un kuí'ná jíín tú'un ñáá. ");
INSERT INTO migNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Cha̱a káñáá jíná'an‑ró. I'a̱ ni̱ sá'a ichi yatá, á tú suni ní sá'a‑ya̱ íchi iní. ");
INSERT INTO migNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ko ta̱ká ja̱ kéndo̱o sobra nuu̱‑ro̱, te kája̱'a‑ró kúu caridad, te kájani ini̱‑ro̱ já táká tiñu kásá'a‑ró íó ndoo ja̱ súan. ");
INSERT INTO migNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Naka̱ ndá'ú kuu róó cha̱a fariseo, chi̱ kája̱'a‑ró ɨ́ɨn sɨkɨ̱ uxí ita̱ mi̱nú jíín ruda jíín táká yua̱, nuu̱ Dios, te tú kásá'a kutɨ‑ro tíñu ndaa̱, ni tú mani̱‑ro̱ jíín‑yá. Ní kásá'a‑ró ndéndúú tiñu yá'a te ma̱ xndóo‑ró ɨngá tiñu‑ún núú. ");
INSERT INTO migNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Naka̱ ndá'ú kuu róó cha̱a fariseo, chi̱ xaa̱n kákuni̱‑ro̱ silla onde̱ xini̱ mesa ini̱ ve̱'e sinagoga. Te ka'a̱n sa̱'án ña̱yɨvɨ jíín‑ró núyá'u kákuni̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Naka̱ ndá'ú kuu róó cha̱a káchaa tutu̱ jíín cháa fariseo, chi cha̱a uu̱ xini̱ kákuu‑ró. Nátu̱'un ve'e añú ja̱ tú ndiji̱n kándee, súan ká'i̱o‑ró, te cha̱a kájika kuu, tú jiní‑de ja̱ jañú‑de sɨkɨ̱, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Te ɨɨn cha̱a kúu maestro ley, ni̱ ka'a̱n‑de: Maestro, nuu̱ ní ka'a̱n‑ní tu̱'un yá'a, suni ni̱ ka'a̱n‑ní sɨkɨ̱ máá‑ná jíná'an‑ná, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Te ni̱ ka'a̱n‑ya̱: Naka̱ ndá'ú kuu róó cha̱a maestro ley jíná'an‑ró, chi̱ káchaa‑ró carga ve̱e sɨkɨ̱ táká cha̱a ja̱ tú kákuu kundiso‑de. Ko máá‑ró, ni tú káké'é‑ró carga‑ún va̱sté jíín ɨ́ɨn nda'a lúlí‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Naka̱ ndá'ú kuu róó jíná'an‑ró. Chi̱ kásá'a‑ró vé'e añú cha̱a ni̱ ka̱jani tu̱'un Dios. Te ni̱ ka̱ja'ni táa̱‑ro̱‑dé jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Súan kúu ja̱ káka'a̱n ndaa̱‑ro̱ já kájata'a̱n ini̱‑ro̱ tíñu ni̱ ka̱sá'a táa̱‑ro̱. Chi ja̱ndáa̱ kúu ja̱ ní ka̱ja'ni‑dé cha̱a‑ún. Te máá‑ró, ni̱ ka̱sá'a‑ró vé'e añú ndɨ̱yi‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ja̱ yúán súni ni̱ ka'a̱n Dios ɨɨn tu̱'un ndíchí: Tájí‑rí cha̱a kani tu̱'un‑ri̱ jíín cháa apóstol ki'i̱n nuu̱‑í jíná'an‑i. Te sava‑de ka'ni‑í te sava‑ga̱‑de chindiki̱n‑i, áchí Dios, ");
INSERT INTO migNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","náva̱'a sɨkɨ̱ ñáyɨvɨ yá'a ná kóo kua̱chi cuenta ja̱ ní jatɨ nɨñi̱ táká cha̱a ni̱ ka̱jani tu̱'un‑ri̱ onde̱ kɨvɨ̱ ní jungo̱o ñu̱yɨ́vɨ, ");
INSERT INTO migNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","onde̱ nɨñi̱ Abel, te onde̱ nɨñi̱ Zacarías, cha̱a ni̱ ji'i̱ sava ma̱'ñú altar jíín vé'e ii̱. Súan ká'a̱n‑ri̱ jíín‑ró, ja̱ sɨkɨ́ ñáyɨvɨ yá'a kuu kua̱chi‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Naka̱ ndá'ú kuu róó maestro ley, chi ni̱ ka̱janchaa̱‑ro̱ ndákáa kɨ̱vɨ‑i ini̱ tu̱'un ndíchí núú, te ni̱ kajasu̱‑ro̱ núu̱ cháa kákuni̱ skuá'a. Ko ni máá‑ró suni tú ní káskuá'a‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Te nini ká'a̱n‑ya̱ tú'un yá'a, te cha̱a káchaa tutu̱ jíín cháa fariseo, ni̱ katau̱ xaa̱n‑dé nuu̱‑yá. Te ni̱ ka̱státá'an‑de jíín‑yá ja̱ ná ká'a̱n‑ga̱‑ya̱ kuá'a tú'un. ");
INSERT INTO migNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Chi̱ kájito yu'u‑dé‑ya̱, ja̱ sánaa te ni'i̱n‑dé yaku̱ tu̱'un ká'a̱n‑ya̱, náva̱'a kaka̱n‑de kua̱chi sɨkɨ̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nini súan kúu, te ni̱ ka̱kutútú kuá'a̱ xáa̱n ñáyɨvɨ, ja̱ kájañu̱ tá'an‑i. Te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a jíín‑yá: Koto va̱'a‑ró máá‑ró núu̱ yújan íá cháa fariseo, chi yu̱án kúu tu̱'un yóso yú'u. ");
INSERT INTO migNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chi̱ tú ni ɨɨn na̱ún yíndi'u̱ ja̱ má kénda ndiji̱n. Ni tú ni ɨɨn ja̱ yísa̱'í ja̱ má kuní‑yo̱ núu̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Núsáá, ta̱ká tu̱'un ni̱ ka'a̱n‑ro̱ ñúñáa, onde̱ nuu̱ íó ndiji̱n ná kúni so̱'o‑i. Te tu̱'un ni̱ ka'a̱n ya̱á‑ro̱ ní ka̱jini so̱'o‑i ká'i̱in‑i ini̱ ve̱'e, te onde̱ xini̱ vé'e ná kóo jaa tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ko amigo, ká'a̱n‑ri̱ jíín‑ró jíná'an‑ró: Ma̱ yú'ú‑ro̱ kóto‑ró ñáyɨvɨ já'ni yíkɨ kúñu‑yó, chi̱ nú ni̱ ndɨ'ɨ ni̱ ka̱ja'ni‑í, te tuká ɨnga̱ na̱ún kúu sá'a‑ga̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ko ná stá'a̱n‑ri̱ nuu̱‑ro̱ ndé ja̱ yú'ú‑ro̱ kóto‑ró. Ió ɨɨn ja̱ nú a ni̱ ja'ni‑í róó te íó poder yu̱án chíndee róó nuu̱ infierno. Yu̱án yú'ú‑ro̱ kóto‑ró núsáá. Yu̱án kástu̱'ún‑rí nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tú kúya̱'u u'u̱n tɨsaa̱ ja̱ úu̱ xu̱'ún náún. Te tú ni ɨɨn‑tɨ̱ náa iní Dios. ");
INSERT INTO migNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Chi̱ a ni̱ ka'u‑ya̱ ondé ta̱ká ixi xiní‑ro̱. Núsáá te ma̱ yú'ú‑ro̱ jíná'an‑ró, chi̱ kánúú‑ga̱‑ro̱ vásá kuá'a̱ tɨ́saa̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Te ká'a̱n‑ri̱ jíín‑ró: Nú ndé cha̱a kani ndaa̱‑de tu̱'un‑ri̱ nuu̱ ñáyɨvɨ, suni súan máá Sé'e cha̱a nakani ndaa̱‑ya̱ tú'un‑de nuu̱ ndájá'a̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ko nú ndé cha̱a ské'ichi̱‑de ruu̱ nuu̱ ñáyɨvɨ, suni súan ské'ichi̱‑ri̱‑de nuu̱ táká ndajá'a̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Te nú ndé cha̱a ka'a̱n ndɨva̱'a‑de sɨkɨ̱ máá Sé'e cha̱a, koo tu̱ká'nu ini̱‑ya̱ núu̱‑dé. Ko nú ndé cha̱a ka'a̱n ndɨva̱'a‑de sɨkɨ̱ Espíritu Santo, ma̱ kóo tu̱ká'nu ini̱ nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Te nú ni̱ kaja̱ncha̱ka‑i róó ini̱ ve̱'e sinagoga nuu̱ cháa kákuñá'nu jíín núu̱ cháa tá'ú tíñu, ma̱ nákani xaa̱n iní‑ro̱ ndasa xndíó káni‑ró tú'un, xí ndasa ka'a̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chi̱ máá Espíritu Santo stá'a̱n‑ya̱ núu̱‑ro̱ ndasa kanúú tú'un ka'a̱n‑ro̱ hora‑ún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yúan‑na te ɨɨn cha̱a kándee‑de nuu̱ ñáyɨvɨ kuá'a̱‑ún, ni̱ ka'a̱n‑de jíín‑yá: Maestro, ka'a̱n‑ní jíín ñaní‑ná ná ká'ncha̱ sava‑de ta'u̱‑ná jíín‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ko máá‑yá ni̱ ka'a̱n‑ya̱ jíín‑de: Utale̱, ndéja̱ ní jani ruu̱ ja̱ kúu‑ri̱ cha̱a sándaa̱ xí cháa ka'ncha̱ sava ta'u̱ já kúu róó jíná'an‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Koto va̱'a‑ró máá‑ró, te ma̱ kútóó iní‑ro̱, chi va̱sa kua'a̱ xáa̱n ndátíñu ñáva̱'a ɨɨn cha̱a, ko nasu̱ já jíín yúán te kuchaku̱ jíñú'ún‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yúan‑na te ni̱ ka'a̱n‑ya̱ ɨ́ɨn tu̱'un yátá jíín‑i: Ni̱ i̱o ɨɨn cha̱a kúká. Te ni̱ ndea̱ xaa̱n nuní‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Te cha̱a‑ún, nákani ini̱‑de: Ndasa sá'a‑ri̱, chi̱ tuká núña yaka̱‑ri̱ nataan‑gá‑ri̱ nɨñi‑rí, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Te ni̱ kachi̱‑de: Sua ná sá'a‑ri̱. Ná kanú‑ri̱ yaka̱‑ri̱. Te nakani‑ri̱ ja̱ ká'nu‑ga̱. Te yúan nataan ndɨ́'ɨ‑ri̱ nɨñi‑rí jíín táká‑ga̱ ndatíñu‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yúan‑na te kachi̱‑ri̱ jíín iní jíín añú‑ri̱: Vina te kua'a̱ xáa̱n ndátíñu ñáva̱'a‑ró já kánda kua'a̱ kuiá. Ná ndéta̱tú‑ro̱ te kaji‑ro kó'o‑ró, te ná kúsɨɨ̱ iní‑ro̱ núsáá, áchí‑de jíín máá‑de. ");
INSERT INTO migNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ko ni̱ kachi̱ Dios jíín‑de: Cha̱a ñáá kúu‑ró. Akuáa vína te kuu̱‑ro̱. Te ndatíñu ni̱ sátu̱'a‑ró‑ún, ndé cha̱a kuu. Achi̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Súan íó sɨkɨ̱ cháa ja̱ sákúká‑de máá‑de, ko tú kúká‑de nuu̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a jíín‑yá: Núsáá te ká'a̱n‑ri̱ jíín‑ró, ma̱ nákani ini̱‑ro̱ sɨkɨ́ já kúchaku̱‑ro̱, nú ndasa kee‑ro, ni sɨkɨ̱ yíkɨ kúñu‑ró, nú ndasa kundii kuna̱má‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Á tú kánúú‑gá vida‑ro̱ vásá já kée‑ro, te yikɨ kúñu‑ró vásá sá'ma‑ro náún. ");
INSERT INTO migNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nde̱'é‑ró tɨ́ka̱ká, tú jítu‑tɨ̱, ni tú nástútú‑tɨ́, ni tú náchiva̱'a‑tɨ̱ iní yaka̱‑tɨ̱, chi̱ máá Dios skée‑yá‑tɨ̱. Á tú kánúú‑ga̱‑ro̱ vásá kɨ́tɨ‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ko ndé róó ja̱ súan nákani ini̱‑ro̱ te á kuu chísó‑ga̱‑ro̱ máá‑ró ɨ́ɨn yíkɨ́. ");
INSERT INTO migNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Te nú ma̱ kúu sá'a‑ró va̱sté ɨ́ɨn tiñu lúlí‑ga̱ súan, te naja̱ kánakani ini̱‑ro̱ jíín sáva‑ga̱‑ún núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nde̱'é ndasa kája'nu ita̱ yuku. Tú sátiñu, ni tú táú. Ko ká'a̱n‑ri̱ jíín‑ró ja̱ rey Salomón kɨvɨ̱ ní kuñá'nu xaa̱n‑dé ni tú ní kúu ku'un‑de sa'ma súan nátu̱'un ita̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Te Dios, nú súan skúna̱má‑ya̱ itá yuku‑ún ja̱ íó vina te yuchaa̱n kayu̱ nuu̱ ñú'u̱n, naga̱ ni̱ kuu ja̱ má skúna̱má‑ya̱ róó. Te naja̱ tú kákandíja va̱'a‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Te ma̱ kuítú iní‑ro̱ ndasa kee‑ro, xí ndása ko'o‑ró ni ma̱ nákani xaa̱n iní‑ro̱ núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Chi ta̱ká ndatíñu yá'a kájítú iní ña̱yɨvɨ ñúyɨ́vɨ jíín. Ko máá Táa̱‑ro̱ a jiní‑ya̱ já kánandɨ'ɨ‑ró táká ndatíñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ko kuítú iní‑ro̱ kɨ́vɨ‑ró iní ñuu̱ nuu̱ tá'ú Dios tiñu. Yúan‑na te kua̱'a‑ga̱‑ya̱ táká ndatíñu‑ún nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ma̱ yú'ú‑ro̱ jíná'an‑ró, chi va̱sa tɨku'ni̱ lúlí kákuu‑ró, ko máá Táa̱‑ro̱ ándɨ́vɨ́, a ni̱ kusɨɨ̱ iní‑ya̱ já núu̱‑ro̱ kuá'a‑ya̱ ñúu̱ nuu̱ tá'ú‑yá tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xi̱kó táká ndatíñu‑ró, te sá'a‑ró caridad. Ndúkú‑ró bolsa ja̱ má kútú'ú kuátíñu‑ró. Te suni taan‑ro yají‑ro̱ ondé andɨ́vɨ́ nuu̱ tú naa. Chi̱ yúan ma̱ kúu kɨ̱vɨ ñakui̱'ná, ni ma̱ kúu chaa ti̱kixin te stɨ́vɨ́‑tɨ́. ");
INSERT INTO migNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Chi nuu̱ kándee yaji̱‑ro̱, yúan kúu nuu̱ kuítú iní‑ro̱ jíín. ");
INSERT INTO migNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ku'ni̱ ni̱'in chi̱i‑ró jíná'an‑ró, te lámpara máá‑ró, ná kóo tu̱'a‑ni ñu'u̱n ini̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Te máá‑ró jíná'an‑ró ná kóo tu̱'a‑ró nátu̱'un mozo káinda̱tu‑i jito'o̱‑i ja̱ ncháa̱‑de kua'a̱n‑de viko tánda'a, náva̱'a nú ni̱ nchaa̱‑de te ka'a̱n‑de, te kuña‑ni‑i ve'e jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Xáán ndatu̱ kuu mozo‑ún te nú ni̱ nchaa̱ jito'o̱‑i nuu̱‑í, te jiní‑de ja̱ kándi̱to‑i. Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ja̱ kú'ni̱‑de chi̱i‑de, te nuu̱ mesa súngo̱o‑de mozo‑de te kani‑de ko'o̱‑í jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Te va̱sa ná cháa̱‑de ñúú, xí va̱sa ná ncháa̱‑de ja̱'a ñu̱u, te nú suni súan kuní‑de sá'a mozo‑ún ja̱ kándi̱to‑i, ndatu̱ xaa̱n kéndo̱o mozo‑ún jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ko ná júku̱'un ini̱‑ro̱ tú'un yá'a. Táa̱ ini̱ ve̱'e, nú ní jiní‑de na̱ hora kúu ja̱ kíi ñakui̱'ná te kundito‑de núú, te ma̱ kuá'a‑de tu̱'un sákuí'ná vé'e‑de núú. ");
INSERT INTO migNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Te róó suni súan koo tu̱'a‑ró, chi̱ máá kɨvɨ́ já tú na̱ún kájani ini̱‑ro̱, te nchaa̱‑ni máá Sé'e cha̱a, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yúan‑na te Pedro, ni̱ jika̱ tu̱'ún‑de‑ya̱: Táta̱, máá‑ni nuu̱ náá jíná'an‑ná ká'a̱n‑ní tu̱'un yá'a náún, xí súni ká'a̱n‑ní nuu̱ táká‑ga̱ cha̱a yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Te ni̱ ka'a̱n máá Jíto'o̱‑yo̱: Ndéja̱ kúu ɨɨn mozo ndito xini̱ já skíkuu va̱'a, chi̱ máá jíto'o̱, kani‑de mozo‑ún ná kóto‑i se̱'e‑de náva̱'a skée‑í su̱chí‑ún máá hora ja̱ xíin tíñu. ");
INSERT INTO migNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Xáán ndatu̱ kuu mozo‑ún, te nú ni̱ nchaa̱ jito'o̱‑i te nani'i̱n‑dé‑i sá'a‑i súan. ");
INSERT INTO migNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ja̱ndáa̱ ká'a̱n‑ri̱, ja̱ káni‑de mozo‑ún ja̱ kóto‑i ta̱ká ndatíñu‑de. ");
INSERT INTO migNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ko nú mozo‑ún jáni ini̱‑i: Kúkuéé‑ga̱ te nchaa̱ jito'o̱‑ri̱, achi̱ máá‑i. Te kejá'á‑i stují‑í mozo máá‑i jíín ñá'an kájatíñu nuu̱‑í. Te kee‑í te ko'o‑i, te naji̱ni‑i. ");
INSERT INTO migNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Te mozo‑ún, nú ni̱ nchaa̱ jito'o̱‑i kɨvɨ̱ já tú ndátu‑i jíín hora ja̱ tú jiní‑i, te xndó'o‑de‑i, te kiñi'in‑de‑i onde̱ jíín cháa tú káskíkuu va̱'a. ");
INSERT INTO migNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Chi̱ nú ndé mozo a jiní‑i tiñu ndasa játa'a̱n ini̱ jito'o̱‑i, te nú tú ní sátu̱'a‑i, ni tú ní skíkuu‑i tiñu kuní máá‑de, ndo'o xaa̱n‑í yunu xíi. ");
INSERT INTO migNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ko nú ndé mozo tú jiní‑i tiñu ndasa játa'a̱n ini̱ jito'o̱‑i, te nú sá'a‑i tiñu ñáá ja̱ xndó'o‑de‑i núú, yúan‑na te yaku̱‑ni yunu xíi ndo'o‑i. Chi̱ nú kua̱'a‑ya̱ kuá'a̱ ndátíñu nuu̱ ɨ́ɨn cha̱a, te nandaka̱n kua'a̱‑yá nuu̱‑dé. Te suni súan nú kua'a̱ ndátíñu kátatu̱‑i ɨɨn cha̱a, ví'í‑gá nandaka̱n‑i nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ni̱ kii‑ri̱ ja̱ chíndee‑ri̱ ñu'u̱n ini̱ ñu̱yɨ́vɨ yá'a. Te xaa̱n kuní‑ri̱ ja̱ ná kóo. ");
INSERT INTO migNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Te íó ɨɨn tu̱ndó'o ja̱ kuánducha‑rí jíín, ko xaa̱n ndukuí'a̱ ini̱‑ri̱ onde̱ ná skíkuu‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kájani ini̱‑ro̱ já ní chaa̱‑ri̱ ja̱ kóo ná'ín‑ni ini̱ ñu̱yɨ́vɨ náún. Ká'a̱n‑ri̱ jíín‑ró ja̱ ná túu, chi̱ sua ndonda sɨkɨ̱ tá'an. ");
INSERT INTO migNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chi̱ ɨɨn‑ni ve'e koo u'u̱n ña̱yɨvɨ, te sásɨ́ɨn máá jíná'an. Uni̱ ndonda sɨkɨ̱ úu̱, te uu̱ ndonda sɨkɨ̱ uní. ");
INSERT INTO migNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Chi̱ ndonda sɨkɨ̱ tá'an, táa̱ sɨkɨ̱ sé'e‑de, te se̱'e sɨkɨ̱ táa̱‑i. Náa̱ sɨkɨ̱ sésɨ́'ɨ́‑ña, te se̱sɨ́'ɨ́ sɨkɨ̱ náa̱‑i. Náchi̱só sɨkɨ̱ séja̱nú‑ña, te seja̱nú sɨkɨ́ náchi̱só‑i. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Te suni ni̱ ka'a̱n‑ya̱ jíín ñáyɨvɨ kuá'a̱‑ún: Nú ni̱ kajini̱‑ro̱ nána viko̱ íchi nú kée ndika̱ndii, te káka'a̱n‑ro̱: Kuun sau̱, áchí‑ro̱, te kúu súan. ");
INSERT INTO migNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te nú ni̱ nana nuu tachi̱, te káka'a̱n‑ro̱: Nandii, áchí‑ro̱, te súan kúu. ");
INSERT INTO migNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Cha̱a uu̱ xini̱ kákuu‑ró. A kájini̱‑ro̱ na̱ún kuní ka'a̱n tuni̱ ini̱ ñu̱yɨ́vɨ jíín ándɨ́vɨ́, te naja̱ tú kánakuni̱‑ro̱ kɨvɨ́ yá'a núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Te naja̱ tú kátava máá‑ró cuenta ndé ja̱ kúu tiñu va̱'a núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ko nú kua'a̱n‑ro̱ núu̱ juez jíín cháa jíto u'u̱ róó, te yachi̱ ná ndátu̱'ún vá'a‑ró jíín‑de nini ká'i̱in‑ró íchi jíín‑de. Chi̱ nú túu, te kua̱'a‑de róó nuu̱ juez, te juez kua̱'a‑de róó nuu̱ policía, te policía chindee‑de róó veka̱a. ");
INSERT INTO migNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Te ká'a̱n‑ri̱ jíín‑ró, ja̱ má kénda kutɨ‑ro yúan onde̱ nú tú chunáa‑ro táká centavo, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Te suni kɨvɨ̱‑ún ká'i̱in yaku̱ cha̱a jíín‑yá yúan. Te ni̱ ka̱jani‑de tu̱'un nuu̱‑yá ndasa ni̱ kata'a̱n cha̱a ñuu̱ Galilea. Chi̱ Pilato, ni̱ sáká núu‑de nɨñi̱ cháa‑ún jíín nɨñí kɨ́tɨ já kásoko̱‑í nuu̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Te ni̱ ka'a̱n Jesús: Cha̱a ñuu̱ Galilea yúan, ja̱ súan kándo'o‑de tu̱ndó'o‑ún, te á ni̱ i̱o xaa̱n kuáchi‑de vásá táká‑ga̱ cha̱a ñuu̱ Galilea, kájani ini̱‑ro̱ náún. ");
INSERT INTO migNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ná kástu̱'ún‑rí nuu̱‑ro̱ já túu, chi̱ suni súan naa‑ro jíná'an‑ró nú tú nakani ini̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Te suni xia'u̱n uni̱ cha̱a ja̱ sɨkɨ́ máá‑de ni̱ ndua̱ torre ñuu̱ Siloé te ni̱ kaji'i̱‑de, á ni̱ ka̱sá'a‑de kua̱chi xaa̱n‑gá vásá táká‑ga̱ cha̱a káxiu̱kú ñúu̱ Jerusalén, kájani ini̱‑ro̱ náún. ");
INSERT INTO migNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ná kástu̱'ún‑rí nuu̱‑ro̱ já túu. Chi̱ suni súan naa‑ro jíná'an‑ró nú tú nakani ini̱‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Te ni̱ ka'a̱n‑ya̱ tú'un yátá yá'a: Ɨɨn cha̱a ñáva̱'a‑de ɨɨn mérkexe̱ ja̱ ní nachu'un‑de ma̱'ñú itú uva‑de. Te ni̱ jaa̱‑de ndúkú‑de nde'e̱ xiní. Te tú ní ní'i̱n kútɨ‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Te ni̱ kachi̱‑de jíín mozo ndíto itu̱ uva‑ún: Vina te a íó uni̱ kuia̱ kíndúkú‑rí nde'e̱ xiní mérkexe̱ yá'a, te tú ní'i̱n kútɨ‑rí. Xɨtɨ ná kí'i̱n. Naja̱ kándii̱ satéñu nuu̱ ñú'un yá'a. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yúan‑na te ni̱ ka'a̱n máá mozo: Táta̱, skéndo̱o‑ní, ná kúndii̱ va̱sté ɨngá kuia̱ yá'a, onde̱ ná sáyúchí‑ná ja'a̱ te chu'un‑ná ja̱'an te nándéó. ");
INSERT INTO migNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Te nú ni̱ ja̱'a nde'e̱, te íó va̱'a. Te nú túu, te vásá xɨ́tɨ‑ní áchí‑i. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Te ɨɨn kɨvɨ̱ ndéta̱tú ni̱ stá'a̱n‑ya̱ tú'un ini̱ ɨɨn ve'e sinagoga. ");
INSERT INTO migNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Te ni̱ kenda ɨɨn ña'an tá'a̱n‑ña ɨ́ɨn tachi̱ kíni ja̱ ní kuu xia'u̱n uni̱ kuia̱ kú'u̱‑ña. Te ni̱ ka̱í‑ña, jíka tɨ́'ɨ́‑ña, chi̱ tú kúu kutɨ ndúko̱o tuun‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Te ni̱ jini̱ Jesús nuu̱‑ñá. Te ni̱ kana‑ya̱ xiní‑ñá. Te ni̱ kachi̱‑ya̱ jíín‑ña: Nána̱, vina te a ni̱ nduva̱'a‑ní ja̱ kú'u̱‑ní, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Te ni̱ chaa‑ya̱ ndá'a‑yá sɨkɨ̱‑ñá. Te ni̱ ndúko̱o tuun‑ni‑ña, te ni̱ na̱kana jaa‑ña Dios. ");
INSERT INTO migNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Te cha̱a kúñá'nu ini̱ ve̱'e sinagoga, ni̱ kiti̱ ini̱‑de nuu̱ Jesús ja̱ ní nasáva̱'a‑ya̱‑ñá kɨvɨ̱ ndéta̱tú. Te ni̱ ka'a̱n‑de jíín ñáyɨvɨ kuá'a̱‑ún: Iñu̱ kɨvɨ̱ íó sátiñu‑ró, te kɨvɨ̱‑ún cha̱koyo‑ró kúu tana̱‑ro̱. Ko kɨvɨ̱ ndéta̱tú yá'a, chi ma̱ kúu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yúan‑na te ni̱ ka'a̱n máá Jíto'o̱‑yo̱ jíín‑de; Cha̱a uu̱ xini̱ kákuu‑ró. Ja̱ kúu kɨvɨ̱ ndéta̱tú te tú kándájí‑ró xndɨkɨ̱‑ro̱ xí burro‑ró núu̱ káyee‑tɨ́‑ún, te tú káskó'o‑ró‑tɨ́ nducha náún. ");
INSERT INTO migNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Te se̱sɨ́'ɨ́ Abraham yá'a, nú'ni̱‑ña xiá'u̱n uni̱ kuia̱ ni̱ sá'a kui'na̱. Te tú íó va̱'a ndájí‑rí‑ña kɨvɨ́ ndéta̱tú náún, áchi‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Te súan ni̱ ka'a̱n‑ya̱ tú'un yá'a. Te ni̱ ka̱kuka nuu̱ táká cha̱a kájito u'u̱‑ya̱‑ún. Ko ta̱ká ña̱yɨvɨ, ni̱ ka̱kusɨɨ̱ iní‑i jíín táká tiñu ñá'nu ni̱ sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Te ni̱ ka'a̱n‑ya̱: Ndasa kuní koo ñuu̱ nuu̱ tá'ú Dios tiñu. Te na̱ jíín skétá'an‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kúu nátu̱'un ndɨkɨn yuá mostaza ja̱ ní ki'in ɨɨn cha̱a te ni̱ chaa‑de nuu̱ itú‑de. Te ni̱ ja'nu. Te ni̱ kuu ɨɨn yunu ká'nu. Te tɨsaa̱ andɨ́vɨ́ ni̱ ka̱sá'a‑tɨ̱ taká‑tɨ̱ chíi nda'a‑ún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Te ni̱ ka'a̱n tuku‑ya̱: Na̱ún tu̱'un yátá skétá'an‑ri̱ jíín ñúu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kúu nátu̱'un yujan íá já ní ki'in ɨɨn ña'an. Te ni̱ chisa̱'í‑ña chíi uni̱ ti̱yii yúchi onde̱ ni̱ ndɨ'ɨ ni̱ kuu íá ní sá'a. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Te nini kua'a̱n‑ya̱ íchi ñúu̱ Jerusalén, te ni̱ jika kuu‑ya̱ táká ñuu̱ jíín táká rancho, ni̱ stá'a̱n‑ya̱ tú'un. ");
INSERT INTO migNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Te ni̱ ka'a̱n ɨɨn cha̱a jíín‑yá: Táta̱, yaku̱‑ni cha̱a ka̱ku‑de náún, áchí‑de. Te ni̱ kachi̱‑ya̱ jíín‑de: ");
INSERT INTO migNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ndúkú ndéé téyíí‑ró kɨ́vɨ koyo‑ró íchi yúxé'é túu̱, chi̱ ká'a̱n‑ri̱ jíín‑ró ja̱ kuá'a̱ ñáyɨvɨ ndúkú ndéé‑i kɨ́vɨ‑i, ko ma̱ kúu kɨ̱vɨ koyo‑i. ");
INSERT INTO migNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Chi̱ táa̱ ini̱ ve̱'e, ndukuiñi̱‑de, te kasu̱‑de yuxé'é. Te ichi yatá vé'e kuiñi‑ró. Te skáján‑ró vitú yúxé'é te ka'a̱n‑ro̱: Táta̱, táta̱, kuña‑ní ve'e, ná kɨ́vɨ koyo‑ná, achi̱‑ro̱. Te kachi̱‑de kuni‑ró: Aa̱, tú jiní‑ri̱ ná ñuu̱ va̱ikoyo‑ró, achi̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yúan‑na te kejá'á‑ró ká'a̱n‑ro̱ jíín‑de: Ni̱ ka̱yee‑ná staa̱ jíín‑ní, te ini̱ ya̱'ya ñuu̱‑ná ni̱ stá'a̱n‑ní tu̱'un nuu̱‑ná, achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Te máá‑de kachi̱‑de kuni‑ró: Achí‑ri̱ jíín‑ró ja̱ tú jiní‑ri̱ róó ndé ñuu̱ va̱ikoyo‑ró. Kuxio jíná'an‑ró chi ña̱yɨvɨ kásá'a tiñu ñáá kákuu‑ró. Achi̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Te yúan nde'e̱‑ro̱, te nakaji‑ro ñíi yú'u‑ro kuíñi‑ró. Te kuni̱‑ro̱ núu̱ Abraham jíín núu̱ Isaac jíín núu̱ Jacob jíín núu̱ táká‑ga̱ cha̱a ni̱ ka̱jani tu̱'un Dios kuiñi‑de ini̱ ve̱'e Dios. Te róó kuxio‑ró sásɨ́ɨn‑ya̱ róó. ");
INSERT INTO migNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Te kikoyo‑i ichi núu̱ kána ndika̱ndii jíín íchi núu̱ kée ndika̱ndii, ichi norte jíín íchi sur, te jungo̱o‑i ini̱ ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kuni so̱'o va̱'a‑ró: Sava cha̱a sandɨ̱'ɨ́‑na̱, ndunúú‑de. Te sava cha̱a kúnúú, nduu‑de sandɨ̱'ɨ́‑na̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Te kɨvɨ̱‑ún ni̱ ja̱koyo yaku̱ tá'an cha̱a fariseo, te ká'a̱n‑de jíín‑yá: Kuxio‑ní yá'a te kenda‑ní ki'i̱n‑ní, chi cha̱a Herodes ka'ni‑dé níí kuní‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Te ni̱ kachi̱‑ya̱ jíín‑de: Kuá'án, te kastu̱'ún‑ró núu̱ máá ñúkuii jia̱n: Vina chi̱ kíñi'in‑ri̱ tachi̱ kíni kája'a̱n. Te sá'a‑ri̱ tana̱ vína jíín yúchaa̱n. Te onde̱ nuu̱ uní kɨvɨ̱ te síjínu‑ri̱ tiñu‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ko kánúú xáa̱n já vína jíín yúchaa̱n jíín ísá te kaka‑ri̱ ki'i̱n‑ri̱, chi ma̱ kúu ja̱ ɨ́ɨn cha̱a jáni tu̱'un kenda‑de yata̱ ñúu̱ Jerusalén, te kuu̱‑de. Achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalén, Jerusalén, ni̱ ka̱ja'ni‑ro cháa kájani tu̱'un Dios, te ni̱ kaja̱'a‑ró yúu̱ xiní cháa ni̱ tájí‑yá va̱i nuu̱‑ro̱. Ió kua'a̱ vuelta ni̱ kuni̱‑ri̱ nastútú‑rí se̱'e‑ró, nátu̱'un chukí ja̱ nástútú‑tɨ́ tɨrɨ̱ɨ‑tɨ̱ chíi ndiji̱n‑tɨ́, ko tú ní kákuni̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vina te kéndo̱o víchí vé'e‑ró núsáá. Ko ká'a̱n‑ri̱ jíín‑ró já má kuní kutɨ‑gá‑ro̱ núu̱‑rí jíná'an‑ró onde̱ jaa̱ ɨɨn kɨvɨ̱ ká'a̱n‑ro̱: Ná nákana jaa‑yó‑yá chi̱ ndíso‑ya̱ tíñu máá Tatá Dios, achi̱‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Te ɨɨn kɨvɨ̱ ndéta̱tú ni̱ kɨ̱vɨ‑ya̱ iní ve̱'e ɨɨn cha̱a kúñá'nu nuu cháa fariseo jíná'an‑de ja̱ kée‑yá staa̱ jíín‑de. Te kájito yu'u‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Te ni̱ kenda ɨɨn cha̱a kú'u̱‑de kue'e̱ kuiñi, kándii̱‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Te ni̱ ka'a̱n Jesús jíín cháa kákuu maestro ley jíín cháa fariseo: Á kuu sá'a‑ri̱ tana̱ kɨvɨ́ ndéta̱tú xí túu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ko máá‑de, tú ní káka'a̱n kutɨ‑dé. Yúan‑na te ni̱ ki'in‑ya̱ cháa ñú'un kuiñi‑ún. Te ni̱ nasáva̱'a‑ya̱‑dé. Te ni̱ natájí‑yá‑de kua̱no'on‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Te ni̱ ka'a̱n‑ya̱ jíín‑ún: Te nú burro máá‑ró xí xndɨkɨ̱‑ro̱ júngava‑tɨ̱ iní ɨɨn sókó, te tú natava‑ro‑tɨ́ va̱sa kɨvɨ̱ ndéta̱tú kúu náún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Te tú ní kákuu xndíó káni‑de ni ɨɨn tu̱'un nuu̱‑yá ja̱ súan ni̱ ka'a̱n‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Te ni̱ jini̱‑ya̱ já kándúkú‑de jungo̱o jíñú'ún‑de silla xini̱ mesa. Te ni̱ ka'a̱n‑ya̱ ɨ́ɨn tu̱'un yátá jíín cháa ni̱ kataka̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Nú ni̱ kana ɨɨn cha̱a xini̱‑ro̱ já kí'i̱n‑ro̱ ɨ́ɨn viko tánda'a, te ma̱ júngo̱o jíñú'ún‑ró silla xini̱ mesa. Chi̱ nú súan, sanaa te a ni̱ kana‑de xini̱ ɨ́ɨn cha̱a kúñá'nu‑ga̱ vásá róó. ");
INSERT INTO migNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Te chaa̱ cha̱a ni̱ kana xini̱‑ro̱‑ún jíín‑de. Te ka'a̱n‑de jíín‑ró: Kuxio, ná kúnchaa̱ cha̱a yá'a jia̱n. Yúan‑na te kúka nuu̱‑ro̱ kí'i̱n‑ro̱ ondé sandɨ̱'ɨ́‑na̱ kunchaa̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ko nú ni̱ kana ɨɨn cha̱a xini̱‑ro̱, kuá'án te jungo̱o‑ró ondé sandɨ̱'ɨ́‑na̱. Chi̱ nú jaa̱ cha̱a ni̱ kana róó yúan te kachi̱‑de kuni‑ró: Amigo, nuu̱ silla jíñú'ún yá'a jungo̱o‑ró, achi̱‑de. Yúan‑na te nduñá'nu‑ró jíto nuu̱ cháa káxiu̱kú ká'nu jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Chi ta̱ká cha̱a sáñá'nu‑de máá‑de, ndusúchí‑de. Te ta̱ká cha̱a sásúchí‑de máá‑de, nduñá'nu‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Te suni ni̱ ka'a̱n‑ya̱ jíín cháa ni̱ kana xini̱‑yá‑ún: Nú sá'a‑ró sámá xí xíni, ma̱ kána‑ró xiní cháa kákuu amigo‑ro̱, ni xini̱ ñaní‑ro̱, ni xini̱ tá'an‑ró, ni xini̱ cháa kúká. Chi̱ nú súan te suni máá‑de nakana‑de xini̱‑ro̱. Te ni̱ kuu ja̱ ní nani'i̱n‑ro̱ tá'u̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ko nú sá'a‑ró gasto, te kana‑ró xiní cháa ndá'ú, cha̱a tɨ́kú'lu, cha̱a tá'nú, jíín xiní cháa kuáá. ");
INSERT INTO migNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Te xáán ndatu̱ kendo̱o‑ró nú súan, chi̱ tú na̱ún nákua̱'a‑de nuu̱‑ro̱. Ko ni'i̱n‑ro̱ yá'u‑ró kɨvɨ́ náchaku̱ ta̱ká cha̱a ndaa̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Te ɨɨn cha̱a yée stáa̱ jíín‑yá, ni̱ jini so̱'o‑de tu̱'un yá'a. Te ni̱ kachi̱‑de jíín‑yá: Xáán ndatu̱ kuu cha̱a ja̱ kée‑dé staa̱ onde̱ ini̱ ñuu̱ nuu̱ tá'ú Dios tiñu. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yúan‑na te ni̱ kachi̱‑ya̱ jíín‑de: Ɨɨn cha̱a ni̱ sá'a‑de ɨɨn xíni ká'nu, te ni̱ kana‑de xini̱ kuá'a ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Te nuu̱ ní jaa̱ hora ja̱ kúxíni‑de‑ún, te ni̱ tájí‑de mozo‑de kua̱kachi̱ nuu̱ já kée stáa̱ xíni‑ún: Ña'a̱n‑ní jíná'an‑ní. Chi̱ a ni̱ ndɨ'ɨ íó tu̱'a. Achí. ");
INSERT INTO migNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Te ɨɨn‑ni ni̱ ka̱sájá'a̱ ini̱ ndɨ'ɨ‑de. Te cha̱a ɨɨn ni̱ kachi̱‑de jíín mozo. Ni̱ jaan‑ri̱ ɨɨn ñu'un te kánúú kínde̱'é‑rí. Te ná kúña ká'nu ini̱‑de nuu̱‑rí, chi̱ ma̱ jáa̱‑ri̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Te ni̱ ka'a̱n ɨnga̱‑de: Ni̱ jaan‑ri̱ u'u̱n yunta xndɨkɨ̱ te kikoto nchaa̱‑ri̱‑tɨ̱. Ná kúña ká'nu ini̱‑de nuu̱‑rí, chi ma̱ jáa̱‑ri̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Te ni̱ ka'a̱n tuku ɨnga̱‑de: Sáá ní ta̱nda'a‑rí. Te ja̱ yúán má kúu jaa̱‑ri̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Te kua̱no'on mozo‑ún ni̱ kastu̱'ún‑de nuu̱ jíto'o̱‑de. Yúan‑na te máá táa̱ ini̱ ve̱'e‑ún, ni̱ kiti̱ ini̱‑de. Te ni̱ kachi̱‑de jíín mozo‑de: Kuá'án yachi̱ nɨ́ɨ́ núyá'u jíín táká ya̱'ya, te kana‑ró xiní cháa ndá'ú, cha̱a tɨ́kú'lu, cha̱a tá'nú, jíín cháa kuáá, ná kíkoyo‑de. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Te ni̱ kachi̱ mozo‑ún: Táta̱, a ni̱ kuu nátu̱'un ká'a̱n‑ní ko núña‑ga̱ lugar. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Te jito'o̱‑ún ni̱ ka'a̱n‑de jíín mozo‑de: Kuá'án ta̱ká ichi jíín táká rancho te stétuu‑ró ñáyɨvɨ‑ún ná kíi‑i yá'a, náva̱'a ná chítú iní ve̱'e‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chi̱ ká'a̱n‑ri̱ jíín‑ró já ní ɨɨn cha̱a ni̱ jaka̱na‑ró‑ún, ma̱ kúxíni kutɨ‑dé ve'e‑ri̱, áchí‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Te kája'a̱n kua'a̱ xáa̱n ñáyɨvɨ jíín Jesús. Te ni̱ ka'a̱n‑ya̱ jíín‑i: ");
INSERT INTO migNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Nú ndé cha̱a kii‑de nuu̱‑rí, te nú chíñú'ún‑de táa̱‑de, náa̱‑de, ñasɨ́'ɨ́‑de, se̱'e‑de, ñani̱‑de, kua̱'a‑de, xí ondé jíín máá‑de, ma̱ kúu kuu‑de cha̱a skuá'a jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Te cha̱a tú ndóyo‑de jíín túndó'o kii sɨkɨ̱‑dé, te kundiki̱n‑de ruu̱ kii‑de, ma̱ kúu kuu‑de cha̱a skuá'a jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Chi̱ nú ndé róó kuní‑ro̱ káni‑ró ɨ́ɨn ve'e, á tú xna'a̱n‑ga̱ jungo̱o‑ró te tava‑ro cuenta na̱saa kuu gasto, te kuni̱‑ro̱ nú va̱tu‑ni kanda‑ró jínu xí túu. ");
INSERT INTO migNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Chi̱ nú túu, te nú a ni̱ jani‑ró já'a̱, te ma̱ kánda xu̱'ún‑ró síjínu‑ró. Yúan‑na te ta̱ká ña̱yɨvɨ kájini̱ nuu̱ vé'e tɨ́kú'lu‑ró‑ún, sákátá‑i nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Te ka'a̱n‑i: Cha̱a yá'a, ni̱ kejá'á‑de jáni‑de ɨɨn ve'e, te tú ní kánda‑de síjínu‑de, achi̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Xí nú ndé rey kuní‑de ki'i̱n‑de kua̱tá'an‑de jíín ɨngá rey, á tú xna'a̱n‑ga̱ jungo̱o‑de te nakani ini̱‑de te nú va̱tu‑ni kuu jíín uxí mil soldado kua̱tá'an‑de jíín ɨngá rey ja̱ vái sɨkɨ̱‑dé jíín okó mil soldado. ");
INSERT INTO migNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chi̱ nú túu, te nini jíká‑ga̱ va̱i ɨnga̱ rey, te tájí‑de ɨɨn cha̱a ki'i̱n ka'a̱n nda̱'ú jíín‑de ja̱ ná júkuiñi̱. ");
INSERT INTO migNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Te suni súan nú ndé róó tú síjíta‑ró táká ndatíñu ñáva̱'a‑ró, ma̱ kúu kuu‑ró cháa skuá'a jíín‑rí núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Va̱'a íó ñii̱, ko nú onde̱ ñii̱‑ún ná náa xikó, te ndasa ndu'u'a̱ núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma̱ kuátíñu kutɨ, ni ja̱ kúu nuu̱ ñú'un já ndúu ja̱'an, chi̱ kacha̱‑de ki'i̱n. Cha̱a íó so̱'o kuni ná'ín, ná kúni so̱'o‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Te ta̱ká cha̱a xíní jíín cháa ká'i̱o kua̱chi, ni̱ ja̱koyo‑de nuu̱ Jesús náva̱'a kuni so̱'o‑de tu̱'un ká'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Te cha̱a fariseo jíín cháa káchaa tutu̱, ni̱ kaka'a̱n‑de: Cha̱a yá'a, játá'ú‑de cha̱a ká'i̱o kua̱chi te yée‑dé staa̱ jíín cháa‑ún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Te máá Jesús, ni̱ ka'a̱n‑ya̱ tú'un yátá yá'a jíín‑de: ");
INSERT INTO migNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ndé ɨɨn róó nú ñáva̱'a‑ró ɨ́ɨn ciento rɨɨ́, te skuíta‑ró ɨ́ɨn‑tɨ̱, á tú skéndo̱o‑ró kúu̱n xíko xia'u̱n kuu̱n‑gá‑tɨ̱ ondé nuu̱ ñú'un té'é, te kina̱ndúkú‑ró kɨ́tɨ ní naa‑ún onde̱ nani'i̱n‑ro̱‑tɨ́ xí túu. ");
INSERT INTO migNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Te nú ni̱ nani'i̱n‑ro̱‑tɨ́, kúsɨɨ̱ iní‑ro̱ xndée‑ró‑tɨ́ nuu̱ chó'o̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Te nú ni̱ najaa̱‑ro̱ vé'e te nastútú‑ró cháa kákuu amigo‑ro̱ jíín tá'an‑ró, te kachi̱‑ro̱ kúni cha̱a‑ún: Ná kúsɨɨ̱ iní‑yo̱ chi̱ ni̱ nani'i̱n‑rí rɨɨ̱‑ri̱‑ri̱ kɨtɨ á ni̱ naa núú. Achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ká'a̱n‑ri̱ jíín‑ró, ja̱ súan kusɨɨ̱‑gá ini̱‑ya̱ ondé andɨ́vɨ́ jíín ɨ́ɨn cha̱a íó kua̱chi nú nakani ini̱‑de, vásá jíín kúu̱n xíko xia'u̱n kuu̱n‑gá cha̱a va̱'a ja̱ tú kájinu ñú'ún‑de tu̱'un nakani ini̱. ");
INSERT INTO migNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Xí nú ɨɨn ñasɨ́'ɨ́ ñáva̱'a‑ña uxí peso, te skuíta‑ña ɨ́ɨn peso, á tú chi'i‑ña yítɨ te nastáa‑ña vé'e, te nandúkú víi‑ñá onde̱ nani'i̱n‑ñá. ");
INSERT INTO migNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Te nú ni̱ nani'i̱n‑ñá, te kána‑ña xiní tá'an‑ña jíín amiga‑ña, te kachi̱‑ña kúni‑i: Ná kúsɨɨ̱ iní‑yo̱, chi ni̱ nani'i̱n‑rí peso‑ri̱ ja̱ ní skuíta‑ri̱‑ún núú. Achí‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ká'a̱n‑ri̱ jíín‑ró, ja̱ súan kúsɨɨ̱‑gá ini̱ ta̱ká ndajá'a̱ Dios jíín ɨ́ɨn cha̱a íó kua̱chi nú nakani ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Te ni̱ ka'a̱n‑ga̱‑ya̱: Ɨɨn cha̱a ni̱ i̱o uu̱ se̱'e yíí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Te su̱chí súchí‑ún ni̱ ka'a̱n‑i jíín táa̱‑i: Táa̱, kua̱'a‑ní sava ñu'un núu̱‑ná ja̱ kúu ta'u̱‑ná, áchí‑i. Te ni̱ teta'a̱n‑de ta'u̱‑í nuu̱ ndéndúú‑i. ");
INSERT INTO migNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Te ni̱ kuu yaku̱ kɨvɨ̱, te su̱chí súchí‑ún ni̱ stútú ndɨ́'ɨ‑i ndatíñu‑i. Te ni̱ kee‑i kua'a̱n jíká‑i ɨnga̱ ñuu̱. Te yúan ni̱ xnáa‑í ta'u̱‑í, chi ni̱ janu̱ ndɨva̱'a‑i. ");
INSERT INTO migNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Súan ni̱ ndɨ'ɨ ni̱ janu̱ sáni‑i, te vásá ní chaa̱ ɨɨn tama̱ xáa̱n iní ñuu̱‑ún, te ni̱ kejá'á nándɨ'ɨ‑i. ");
INSERT INTO migNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Te ni̱ kee‑i kua'a̱n‑i, te ni̱ jaa̱‑i nuu̱ ɨ́ɨn cha̱a ñuu̱‑ún. Te cha̱a‑ún ni̱ tájí‑de‑i kua'a̱n‑i onde̱ rancho‑de ja̱ yúan koto‑i kɨnɨ̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Te kuní‑i taan tɨ́ɨ́‑i chi̱i‑i jíín tíxi̱ko káyee kɨnɨ́‑ún. Chi̱ tú kutɨ ní ɨɨn na̱ún ní já'a nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yúan‑na te ni̱ jini̱ máá‑i. Te ni̱ ka'a̱n‑i: Ta̱ká mozo íó ini̱ ve̱'e táa̱‑ri̱, íó kua'a̱ stáa̱ káyee‑dé. Te ruu̱ jí'i̱‑ri̱ so̱ko yá'a. ");
INSERT INTO migNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ná ndúkuiñi̱‑ri̱ te ná nó'o̱n‑ri̱ nuu̱ táa̱‑ri̱. Te kachi̱‑ri̱ kuni‑de: Táa̱, a ni̱ sá'a‑ná kua̱chi nuu̱ Dios andɨ́vɨ́ jíín núu̱ máá‑ní. ");
INSERT INTO migNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tuká va̱'a cha̱a kúu‑ná ja̱ kúnání‑ná se̱'e‑ní. Ko kua̱'a‑ní tu̱'un kuu‑ná nátu̱'un ɨɨn mozo‑ní. Achi̱‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Te ni̱ ndukuiñi̱‑i, te ni̱ kee‑i kua̱no'on‑í nuu̱ táa̱‑i. Te nini jíká‑gá va̱i‑i, te ni̱ jini̱ táa̱‑i nuu̱‑í. Te ni̱ kundá'ú ini̱‑de‑i. Te jínu‑de ni̱ jaa̱‑de. Te ni̱ nuu‑de suku̱n‑í, te ni̱ titú‑de‑i. ");
INSERT INTO migNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yúan‑na te ni̱ ka'a̱n‑i jíín‑de: Táa̱, a ni̱ sá'a‑ná kua̱chi nuu̱ Dios andɨ́vɨ́ jíín núu̱ máá‑ní. Tuká va̱'a cha̱a kúu‑ná ja̱ kúnání‑ná se̱'e‑ní. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ko máá táa̱‑i, ni̱ ka'a̱n‑de jíín mozo‑de: Kuáki̱'in ɨɨn su'nu̱ vá'a‑ga te chu'un‑ró‑i. Te chu'un‑ró ɨ́ɨn xe'e ndá'a‑í. Te chi'i‑ró ndiján já'a̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Te suni kiki̱'in‑ró chélu xá'án. Te ka'ni‑ro‑tɨ́ ná kée‑yo. Chi̱ sá'a‑yó víko. ");
INSERT INTO migNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Chi se̱'e yíí‑rí yá'a a ni̱ ji'i̱‑i núú, te ni̱ nachaku̱‑i. A ni̱ naa‑í núú, te ni̱ ndenda‑i, áchí‑de. Te ni̱ ka̱kejá'á‑de sá'a‑de viko. ");
INSERT INTO migNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Te se̱'e yíí ñá'nu‑de, kándee‑i onde̱ rancho. Su̱chí‑ún va̱i ndii‑i. Te ni̱ nduyani‑i yata̱ vé'e. Te ni̱ jini so̱'o‑i tɨvɨ́ música te kájita já'á ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Te ni̱ kana‑i xini̱ ɨ́ɨn mozo. Te ni̱ jika̱ tu̱'ún‑i mozo‑ún nú na̱ún viko íó. ");
INSERT INTO migNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Te ni̱ kachi̱ mozo‑ún nuu̱‑í: Ni̱ nchaa̱ ñani̱‑ro̱ te táa̱‑ro̱, ni̱ ja'ni‑dé chelu xá'án, chi ni̱ ndenda va̱'a se̱'e yíí‑de, áchí mozo. ");
INSERT INTO migNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yúan‑na te ni̱ kiti̱ ini̱‑i, te tú ní kuní‑i ndɨ̱vɨ‑i, ko ni̱ kenda táa̱‑i. Te ni̱ ka'a̱n nda̱'ú‑de jíín‑i ná ndɨ́vɨ‑i. ");
INSERT INTO migNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ko máá‑i ni̱ ka'a̱n‑i: Ió kua'a̱ kuiá játíñu‑ná nuu̱‑ní, ni tú sáni̱'in kutɨ iní‑ná tiñu tá'ú‑ní. Te tú ní já'a‑ní va̱sté ɨ́ɨn lítú núu̱‑ná kee sɨ́ɨ̱‑ná jíín amigo‑na, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ko ni̱ nchaa̱ se̱'e‑ní yá'a. Te va̱sa ni̱ xnáa ndɨ́'ɨ‑i ndatíñu‑ní jíín ñá'an téné, te ni̱ ja'ni‑ní chelu xá'án kée‑í, áchí‑i jíín táa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yúan‑na te ni̱ kachi̱‑de jíín‑i: Hijo, róó chi̱ nene̱ ncháá‑ro̱ jíín‑rí. Te ta̱ká ndatíñu máá‑rí suni ndatíñu máá‑ró kúu. ");
INSERT INTO migNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ko jínu ñú'ún sá'a‑yó víko te kusɨɨ̱ iní‑yo̱. Chi̱ ñani̱‑ro̱ yá'a, a ni̱ ji'i̱‑i núú, te ni̱ nachaku̱‑i. A ni̱ naa‑í núú, te ni̱ ndenda‑i, áchí‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Te suni ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a jíín‑yá: Ɨɨn cha̱a kúká, ni̱ ñava̱'a‑de ɨɨn mandador. Te cha̱a kúká‑ún ni̱ jini tu̱'un‑de ja̱ stɨ́vɨ́ mandador ndatíñu‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Te ni̱ kana‑de xini̱ cháa‑ún. Te ni̱ ka'a̱n‑de jíín‑de: Na̱ún tu̱'un kúu ja̱ jíni tu̱'un‑ri̱ sɨkɨ̱‑ro̱. Nakua̱'a cuenta tiñu ndíso‑ró, chi ma̱ kúu‑ga̱‑ro̱ mandador nuu̱‑rí. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yúan‑na te cha̱a mandador, ni̱ ka'a̱n máá‑de: Ndasa sá'a‑ri̱. Chi̱ jito'o̱‑ri̱ jánchaa̱‑de tiñu mandador nuu̱‑rí. Nú kacha‑ri̱ ñu'un, ma̱ kánda‑ri̱. Nú kaka̱n‑ri̱ caridad, xaa̱n kúka nuu̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A jiní‑ri̱ ndasa sá'a‑ri̱ náva̱'a kɨvɨ̱ kuánchaa̱‑de tiñu ndíso‑ri̱, te koo ña̱yɨvɨ maní jíín‑rí, te kuu kɨ̱vɨ‑ri̱ ini̱ ve̱'e‑i. ");
INSERT INTO migNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Te ni̱ kana‑de xini̱ ná ɨɨn cha̱a káitau̱ nuu̱ jíto'o̱‑de. Te ni̱ kachi̱‑de jíín cháa‑ún: Na̱saa taú‑ro̱ núu̱ jíto'o̱‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Te máá cháa‑ún, ni̱ kachi̱‑de: Uni̱ mil litro aceite, áchí‑de. Te ni̱ kachi̱ mandador jíín‑de: Ki'in lista‑ro̱. Te jungo̱o yachi̱‑ro̱. Te chaa‑ró úu̱ mil‑na̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yúan‑na te ni̱ ka'a̱n‑de jíín ɨngá cha̱a: Te róó, na̱saa taú‑ro̱, áchí‑de. Te cha̱a‑ún, ni̱ kachi̱‑de: Ɨɨn ciento ve'e trigo, áchí‑de. Te máá‑de ni̱ kachi̱‑de jíín cháa‑ún: Ki'in lista‑ro̱, te nachaa‑ró kúu̱n xíko‑ni, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Te jito'o̱‑ún, ni̱ ka'a̱n‑de jíín cháa mandador xndá'ú ja̱ bueno ndíchí ní sá'a‑de. Chi ta̱ká se̱'e kuia̱ yá'a, ndíchí‑ga̱ máá‑i nuu̱ ñáyɨvɨ íó vina, vásá táká se̱'e luz. ");
INSERT INTO migNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Te máá‑rí, ká'a̱n‑ri̱ jíín‑ró: Jíín xú'ún xndá'ú, ná sá'a‑ró amigo‑ro̱ náva̱'a nú ni̱ ndɨ'ɨ xu̱'ún‑ró, te naki'in‑i róó kunchaa̱‑ro̱ iní ve̱'e‑i nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Chi cha̱a skíkuu va̱'a ɨɨn tiñu va̱sa lúlí‑ni, suni skíkuu va̱'a‑de jíín tíñu ándéé. Te cha̱a ja̱ xndá'ú‑de jíín ɨ́ɨn tiñu va̱sa lúlí‑ni, suni xndá'ú‑de jíín tíñu ándéé. ");
INSERT INTO migNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Chi̱ nú sɨkɨ̱ xú'ún xndá'ú tú ní káskíkuu va̱'a‑ró, ndé cha̱a kua̱'a tiñu ndaa̱ nuu̱‑ro̱ núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te nú tú ní káskíkuu va̱'a‑ró jíín ndátíñu sava‑ga̱ cha̱a, ndéja̱ kuá'a ndatíñu máá‑ró núu̱‑ro̱ núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ni ɨɨn mozo ma̱ kúu kuatíñu‑de nuu̱ úu̱ jito'o̱. Chi̱ kiti̱ ini̱‑de nuu̱ ɨ́ɨn, te kumani̱‑dé jíín ɨngá, xí kuándatu̱‑de nuu̱ ɨ́ɨn te sáni̱'in ini̱‑de nuu̱ ɨnga. Ma̱ kúu kuatíñu‑ró núu̱ Dios jíín núu̱ xú'ún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Te cha̱a fariseo ká'i̱in‑de yúan, cha̱a tóó iní kákuu‑de. Te ni̱ ka̱jini so̱'o‑de ta̱ká tu̱'un ká'a̱n‑ya̱. Te ni̱ ka̱sákátá‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Máá‑ró kákuni̱‑ro̱ já ná káni ini̱ ña̱yɨvɨ já cháa ndaa̱ kákuu‑ró. Ko Dios, a jiní‑ya̱ ndasa káa ichi iní añú‑ro̱. Chi̱ tiñu kájani ini̱ ña̱yɨvɨ já tíñu ñá'nu kúu‑ún, te nuu̱ Dios tiñu chá'án kúu. ");
INSERT INTO migNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Máá ley jíín cháa kájani tu̱'un Dios, ni̱ kuu‑ga̱ onde̱ kɨvɨ̱ ní kii Juan. Yúan‑na te ni̱ kejá'á tú'un va̱'a ñuu̱ nuu̱ tá'ú Dios tiñu. Te ña̱yɨvɨ, jíín fuerza kɨ́vɨ koyo‑i yúan. ");
INSERT INTO migNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ko yachi̱‑ga̱ naa ándɨ́vɨ́ jíín ñúyɨ́vɨ, vásá já náa ɨ́ɨn punto nuu̱ tutú ley. ");
INSERT INTO migNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nú ndé cha̱a skéndo̱o‑de ñasɨ́'ɨ́‑de te ta̱nda'a‑dé jíín ɨngá ña'an, yu̱án ísɨ́kɨ ncháa̱‑de‑ña. Te cha̱a tánda'a jíín ñá'an ní ndo̱o‑ún, suni ísɨ́kɨ ncháa̱‑de tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ni̱ i̱o ɨɨn cha̱a kúká, ni̱ ñu̱'un‑de sa'ma kuá'á tíndí'í jíín sá'ma tɨ́ndu̱'á vá'a. Te ndɨta'a̱n kɨvɨ̱ ní sá'a‑de ndeyu ní ka̱yee vá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Te suni ni̱ i̱o ɨɨn cha̱a ndá'ú nání‑de Lázaro, ni̱ jika̱n‑de caridad. Kátúu‑dé yuxé'é cháa kúká‑ún. Te nɨ́ɨ́‑de ni̱ kana ndɨ̱'yi. ");
INSERT INTO migNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Te kuní‑de kee ndá'a̱ chi̱i‑de jíín yúxi stáa̱ kóyo chi̱i mesa cha̱a kúká‑ún. Te jákoyo ti'ina̱ te kána yuu‑tɨ̱ núu̱ ndɨ́'yi‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Te ni̱ ji'i̱ cha̱a jikán caridad‑ún. Te ndajá'a̱ ándɨ́vɨ́, ni̱ jaka‑ya̱‑dé kua̱no'on‑yá jíín‑de nuu̱ Abraham. Te suni ni̱ ji'i̱ cha̱a kúká‑ún, te ni̱ yu̱ji‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Te cha̱a kúká‑ún, ndó'o xaa̱n‑dé kándee‑de infierno. Te ni̱ ndakoto‑de. Te onde̱ jíká ní jini̱‑de nuu̱ Abraham, te kánchaa̱ Lázaro jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yúan‑na te máá cháa‑ún, ni̱ kana kó'ó‑de: Táta̱ Abraham, kundá'ú ini̱‑ní náá, te tájí‑ní Lázaro ná kíchi̱ndaji‑de xini̱ ndá'a‑dé nuu̱ ndúcha, te ná xndáji‑de yáa‑ná. Chi̱ xaa̱n jatú‑ná kayú‑ná nuu̱ yáá ñú'u̱n yá'a. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Te ni̱ kachi̱ Abraham jíín‑de: Hijo, a núku̱'un ini̱‑ro̱ já ní i̱o kúká‑ró ná ni̱ chaku̱‑ro̱, te Lázaro, sua ndá'ú ni̱ ta'a̱n‑de, ko vina, a ni̱ ndundéé iní‑de yá'a, te róó ndó'o‑ró jián. ");
INSERT INTO migNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Te suni ni̱ sá'a Dios ɨɨn xa'va̱ kúnú xáa̱n, kándee ma̱'ñú róó jíín rúu̱. Te cha̱a ká'i̱in yá'a, va̱sa kákuni̱‑de ja̱'a‑de jaa̱‑de jia̱n, ko ma̱ kúu, ni ma̱ kúu ja̱'a máá‑ró kíi‑ró yá'a. Achí Abraham. ");
INSERT INTO migNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yúan‑na te ni̱ ka'a̱n, cha̱a kúká‑ún: Táa̱, jikán ta'u̱‑ná nuu̱‑ní, tájí‑ní‑de ki'i̱n‑de ve'e táa̱‑ná núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Chi̱ íó u'u̱n‑ga̱ ñani̱‑ná, te ná káni ndaa̱‑de tu̱'un nuu̱‑í, náva̱'a ma̱ kíkoyo‑i nuu̱ ndó'o‑ná yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Te ni̱ kachi̱ Abraham jíín‑de: A káñava̱'a‑i tutu̱ ni̱ chaa Moisés jíín tutú ni̱ ka̱chaa cha̱a ni̱ jani tu̱'un Dios onde̱ sáá. Yúan ná kúni so̱'o‑i, áchí Abraham. ");
INSERT INTO migNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yúan‑na te máá‑de ni̱ kachi̱‑de: Túu, táta̱ Abraham, chi̱ nú ɨɨn cha̱a ni̱ ji'i̱ ki'i̱n nuu̱‑í, yúan‑na te nakani ini̱‑i jíná'an‑i, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ko ni̱ kachi̱ Abraham jíín‑de: Nú tú chú'un ini̱‑i tu̱'un ni̱ jani Moisés jíín cháa ni̱ ka̱jani tu̱'un Dios, suni ma̱ kándíja kutɨ‑í nú nachaku̱ ɨɨn ndɨ̱yi ki'i̱n nuu̱‑í, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Te ni̱ kachi̱‑ya̱ jíín cháa káskuá'a jíín‑yá: Tú modo te nú tú koto nchaa̱‑i ña̱yɨvɨ. Ko naka̱ ndá'ú kuu cha̱a skɨ́vɨ ña̱yɨvɨ‑ún nuu̱ kuáchi. ");
INSERT INTO migNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Va̱'a‑ga̱ nú ní nú'ni̱ ɨɨn yo̱só sukún‑dé te kenda‑de ki'i̱n‑de nuu̱ ndúcha mar, nasu̱ já skɨ́vɨ‑de ɨɨn su̱chí lúlí yá'a nuu̱ kuáchi. ");
INSERT INTO migNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Koto va̱'a‑ró máá‑ró: Nú ñani̱‑ro̱ sá'a‑de kua̱chi sɨkɨ̱‑ro̱, kana jíín núu̱‑dé. Te nú ni̱ nakani ini̱‑de, te sá'a‑ró túká'nu ini̱‑ro̱ núu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Te nú usia̱ jínu ja̱ ɨ́ɨn kɨvɨ̱ ní sá'a‑de kua̱chi sɨkɨ̱‑ro̱, te nú usia̱ jínu nakani ini̱‑de te ka'a̱n‑de jíín‑ró: Sá'a tu̱ká'nu ini̱‑ro̱ núu̱‑rí, achi̱‑de, yúan‑na te ná sá'a‑ró túká'nu ini̱‑ro̱ núu̱‑dé. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Te ni̱ kaka'a̱n cha̱a kákuu apóstol jíín máá Jíto'o̱‑yo̱: Sá'a‑ní ja̱ vá'a‑ga̱ ná kándíja‑ná núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Te ni̱ kachi̱ máá Jíto'o̱‑yo̱ jíín‑de: Nú kákandíja‑ró va̱sté ɨ́ɨn tí'li̱ nátu̱'un ɨɨn ndɨkɨn yuá mostaza núú, te ka'a̱n‑ro̱ jíín núyu̱'ndú yá'a: Tu'un máá‑ró onde̱ jíín yó'o‑ro, te nachu'un‑ró máá‑ró ondé nuu̱ mar, achi̱‑ro̱. Te kuandatu̱ nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ndé ɨɨn róó, ñáva̱'a‑ró ɨ́ɨn mozo jítu‑de jíín xndɨkɨ̱ xí skáji‑dé rɨɨ̱. Te najaa̱‑de ve'e ja̱ ní ja'a̱n‑de yuku. Te kachi̱‑ni‑ró kúni‑de: Ña'a̱n te nungo̱o‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Á tú xna'a̱n‑ga̱ ka'a̱n‑ro̱ jíín‑de: Sá'a ndeyu ná kúxíni‑ri̱. Naku'ni̱ va̱'a chi̱i‑ró, te kani‑ró kó'o̱‑rí. Te onde̱ nú ni̱ ndɨ'ɨ ni̱ yee‑rí staa̱, yúan‑na te vásá kée máá‑ró kó'o‑ró, achi̱‑ro̱ xí túu. ");
INSERT INTO migNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Te á nakuatá'ú‑ró núu̱ mozo‑ún ja̱ ní skíkuu‑i tiñu ni̱ tá'ú‑ró núu̱‑í. Jáni ini̱‑ri̱ ja̱ túu. ");
INSERT INTO migNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Suni súan máá‑ró jíná'an‑ró, nú ni̱ ka̱skíkuu‑ró tíñu ni̱ tá'ú‑yá nuu̱‑ro̱, te ka'a̱n‑ro̱: Tú va̱'a mozo kákuu‑ná, chi̱ máni tiñu ja̱ taú‑ná sá'a‑ná, kúu ja̱ á ni̱ ka̱sá'a‑ná, achi̱‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Te jíka Jesús kua'a̱n‑ya̱ ñúu̱ Jerusalén. Te ichi iní ñuu̱ Samaria jíín iní ñuu̱ Galilea ni̱ ja̱'a‑ya̱ kuá'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Te nuu̱ ní kɨ̱vɨ‑ya̱ iní ɨɨn ñuu̱ yúan, te uxi̱ cha̱a té'yu̱ ndɨ̱'yi ni̱ ka̱ketá'an‑de jíín‑yá. Te cha̱a‑ún onde̱ jíká ní ka̱jukuiñi̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Te ni̱ ka̱kana jaa‑de: Maestro, Jesús, kundá'ú ini̱‑ní náá víi̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Te ni̱ jini̱ Jesús nuu̱‑dé, te ni̱ kachi̱‑ya̱ jíín‑de: Kuá'án jíná'an‑ró te stá'a̱n‑ro̱ máá‑ró núu̱ sutú, áchí‑ya̱. Te nini kája'a̱n‑de, te ni̱ ka̱ndundoo‑ni‑de. ");
INSERT INTO migNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yúan‑na te ɨɨn‑de, ni̱ jini̱‑de ja̱ ní nduva̱'a‑de. Te ni̱ na̱xíó káva‑de kua'a̱n‑de. Te nákana jaa‑de Dios. ");
INSERT INTO migNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Te ni̱ jukuiñi̱ jítɨ́‑de nuu̱ já'a̱ Jesús. Te ni̱ nakuatá'ú‑de nuu̱‑yá. Te cha̱a‑ún, cha̱a ñuu̱ Samaria kúu‑de. ");
INSERT INTO migNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Te ni̱ ka'a̱n Jesús jíín‑de: Nasu̱ uxí tá'a̱n‑ro̱ ní ka̱ndundoo náún. Te ɨɨ̱n‑ga̱‑de, ndénu̱ ká'i̱in‑de núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tú íó ɨnga̱‑de ja̱ cháa̱‑de te nakana jaa‑de Dios, xí sá cha̱a sɨ́ɨn ñuu̱ yá'a náún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Te ni̱ kachi̱ tuku‑ya̱ jíín‑de: Ndukuiñi̱, te no'o̱n‑ro̱ vé'e‑ró. Ni̱ kandíja‑ró te yu̱án ní nduva̱'a‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Te cha̱a fariseo, ni̱ kajika̱ tu̱'ún‑de‑ya̱: Ndé kɨvɨ̱ cháa̱ ñuu̱ nuu̱ tá'ú Dios tiñu. Achí‑de. Te ni̱ kachi̱‑ya̱ jíín‑de: Ñuu̱ nuu̱ tá'ú Dios tiñu, ma̱ cháa̱ ndiji̱n, ");
INSERT INTO migNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ni ma̱ kúu ka'a̱n‑i: Nde̱'é yá'a, ni̱ chaa̱, xí ndé'é yúan, ni̱ jaa̱, chi̱ ñuu̱ nuu̱ tá'ú Dios tiñu, a íó ma̱'ñú máá‑ró jíná'an‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a jíín‑yá: Chaa̱ tiempo ja̱ kákuni̱‑ro̱ ndé'é‑ró ɨ́ɨn kɨvɨ̱ kénda máá Sé'e cha̱a, ko ma̱ kuní‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Te kachi̱‑i kuni‑ró: Nde̱'é yá'a kánchaa̱‑ya̱, xí nde̱'é yúan kánchaa̱‑ya̱, achi̱‑i. Te ma̱ kí'i̱n‑ro̱ jíín‑i, ni ma̱ kúndiki̱n‑ro̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Chi̱ nátu̱'un ndíi ncháa̱ ja̱ nándeyu̱ onde̱ ɨɨn lado andɨ́vɨ́ te jáa̱ onde̱ ɨnga̱ lado andɨ́vɨ́, suni súan kuu kɨvɨ̱ kíi máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ko jínu ñú'ún já xná'a̱n‑ga̱ ndo'o xaa̱n‑yá, te ña̱yɨvɨ yá'a ské'ichi̱‑i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Chi̱ nátu̱'un ni̱ kuu kɨvɨ̱ ní kii Noé, suni súan kuu kɨvɨ̱ kíi máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Káyee‑í, káji'i‑i, káta̱nda'a cháa, káta̱nda'a ñá'an, te ni̱ jaa̱ kɨvɨ̱ já ní kɨ̱vɨ Noé ini̱ barco ká'nu‑de. Te ni̱ chaa̱ sau̱ xáa̱n. Te ni̱ xnáa ndɨ́'ɨ‑cha̱‑í jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Suni súan ni̱ kuu kɨvɨ̱ Lot. Káyee‑í káji'i‑i, kájaan‑i káxi̱kó‑i, káchi'i‑i itu̱, kájani‑i ve'e, ");
INSERT INTO migNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","onde̱ ni̱ jaa̱ kɨvɨ̱ ní kenda Lot ini̱ ñuu̱ Sodoma kua'a̱n‑de. Te ni̱ kuun ñu'u̱n jíín azufre ichi ándɨ́vɨ́. Te ni̱ naa ndɨ́'ɨ ña̱yɨvɨ‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Suni súan kuu kɨvɨ̱ kíi máá Sé'e cha̱a kistá'a̱n ndiji̱n‑ya̱ máá‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Te kɨvɨ̱‑ún, te cha̱a kándee xini̱ vé'e‑de, ma̱ núu‑de naki'in‑de ndatíñu‑de ja̱ ní ndo̱o ini̱ ve̱'e. Te cha̱a kándee onde̱ rancho, ma̱ náxíó káva‑de no'o̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ma̱ náa iní‑ro̱ ndasa ni̱ ta'a̱n ñasɨ́'ɨ́ Lot. ");
INSERT INTO migNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Chi cha̱a jítú iní‑de ka̱ku‑de chi̱i tu̱ndó'o kii sɨkɨ̱‑dé, naa‑dé. Ko cha̱a kuu̱ ja̱ sɨkɨ́ rúu̱, ka̱ku‑de. ");
INSERT INTO migNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A ká'a̱n‑ri̱ jíín‑ró ja̱ ákuáa‑ún kunda̱a uu̱‑i nuu̱ jíto. Te ɨɨn‑i naki'in‑ya̱, te ndo̱o ɨnga̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Uu̱ ñasɨ́'ɨ́ ndiko ká'nu‑ña. Te ɨɨn‑ña náki'in‑ya̱, te ndo̱o ɨnga̱‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Uu̱ cha̱a kuiñi‑de rancho. Te ɨɨn‑de naki'in‑ya̱, te ɨnga̱‑de xndóo‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Te ni̱ kaka'a̱n‑de jíín‑yá: Ndénu̱ kúu Táta̱, áchí‑de. Te ni̱ kachi̱‑ya̱ jíín‑de: Nuu̱ kútúu ndɨ́yi, yúan taka̱ tijii̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Te ni̱ ka'a̱n‑ya̱ ɨ́ɨn tu̱'un yátá jíín‑de ja̱ nené kaka̱n ta'u̱‑dé te ma̱ kuítá‑de jíín. ");
INSERT INTO migNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Te ni̱ kachi̱‑ya̱: Ni̱ i̱o ɨɨn juez ini̱ ɨɨn ñuu̱. Te ni tú ní yú'ú‑de nuu̱ Dios, ni tú ní jíto‑de nuu̱ ní ɨɨn cha̱a. ");
INSERT INTO migNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Te suni ni̱ i̱o ɨɨn ña'an ní kendo̱o ndá'ú‑ña ñúu̱ yúan. Te ña'an‑ún, ni̱ ja'a̱n ni̱ ja'a̱n‑ña núu̱‑dé. Te ni̱ ka'a̱n‑ña jíín‑de: Sá'a‑ní justicia ja̱ ní sá'a ña̱yɨvɨ jíín‑ná jíto u'u̱‑i náá. Achí‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ko máá juez‑ún, kua'a̱ kɨvɨ́ tú ní kuní‑de sá'a‑de. Yúan‑na te ni̱ nakani ini̱ máá‑de: Va̱sa tú yú'ú‑ri̱ jíto‑ri̱ Dios ni tú jíto‑ri̱ nuu̱ ní ɨɨn cha̱a, ");
INSERT INTO migNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ko ja̱ ñá'an viuda yá'a, xaa̱n stá'a̱n‑ña rúu̱. Te yu̱án ná sá'a‑ri̱ justicia jíín‑ña. Chi̱ nú tú, te kunɨ́nɨ íi̱ iní‑ri̱ sá'a‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Te ni̱ kachi̱ máá Jíto'o̱‑yo̱: Kuni ná'ín‑ró jíná'an‑ró ndasa ni̱ ka'a̱n juez káñáá‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Te Dios tú sá'a‑ya̱ justicia jíín ñáyɨvɨ ní naka̱ji‑ya̱ náún, ja̱ ndúú ñúú‑ni káka'a̱n nda̱'ú‑i jíín‑yá, va̱sa kuéé sándaa̱‑ya̱ já'a̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A ká'a̱n‑ri̱ jíín‑ró ja̱ yachí nama‑ya̱‑í jíná'an‑i. Ko kɨvɨ̱ cháa̱ máá Sé'e cha̱a, á ni'i̱n‑yá ña̱yɨvɨ kákandíja nuu̱‑yá ini̱ ñu̱yɨ́vɨ yá'a xí túu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Te suni ni̱ ka'a̱n‑ya̱ tú'un yátá yá'a jíín yakú cha̱a ká'i̱in yúan, chi̱ kájani ini̱‑de ja̱ cháa ndaa̱ kákuu máá‑de te kásájá'a̱ ini̱‑de nuu̱ sáva‑ga̱ ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Uu̱ tá'a̱n cha̱a ni̱ ka̱kaa‑de kája'a̱n‑de ve'e ii̱, ja̱ kakán ta'u̱‑dé. Ɨɨn‑de kúu cha̱a fariseo, te ɨnga̱‑de kúu cha̱a xíní. ");
INSERT INTO migNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Te cha̱a fariseo, ni̱ kandii̱‑de, te ni̱ jika̱n ta'u̱‑dé tu̱'un yá'a: Táta̱ Dios, ná kúta'u̱‑ná nuu̱‑ní chi̱ tú káa‑ná nátu̱'un káa sava‑ga̱ cha̱a, cha̱a kuí'ná, cha̱a ñáá, cha̱a ísɨ́kɨ ncháa̱ tá'an kákuu‑de, ni tú káa‑ná nátu̱'un káa cha̱a xíní yá'a. ");
INSERT INTO migNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Uu̱ jínu ja̱ semana íó ndicha̱ ini̱‑ná. Te já'a‑ná ɨɨn ja̱ uxí sɨkɨ̱ táká ndatíñu ñáva̱'a‑ná nuu̱‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ko cha̱a xíní‑ún, ni̱ kandii̱ jíká‑ni‑de, ni tú ní kuní‑de ndukani‑de nuu̱‑dé, chi ni̱ kani‑de ji̱kí jiká‑dé ja̱ kúkuí'a̱ ini̱‑de. Te ni̱ ka'a̱n‑de: Táta̱ Dios, kundá'ú ini̱‑ní náá, chi cha̱a íó kua̱chi kúu‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ká'a̱n‑ri̱ jíín‑ró já cháa ndá'ú yá'a, ni̱ nuu‑de kua̱no'on‑dé ve'e‑de, te ni̱ janchaa̱‑ya̱ kuáchi‑de, ko ɨngá cha̱a‑ún, chi̱ túu. Chi ta̱ká cha̱a sáñá'nu‑de máá‑de ndusúchí‑de. Te ta̱ká cha̱a sásúchí‑de máá‑de, nduñá'nu‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Te ni̱ cha̱koyo ña̱yɨvɨ jíín sé'e lúlí‑i nuu̱ Jesús ja̱ ná ké'é‑yá‑i. Te cha̱a káskuá'a jíín‑yá, ni̱ kajini̱‑de ja̱ súan íó, te ni̱ kaka'a̱n xaa̱n‑dé nuu̱ ñáyɨvɨ‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ko máá Jesús, ni̱ kana‑ya̱ xiní‑dé. Te ni̱ ka'a̱n‑ya̱: Sía̱ ná kíkoyo su̱chí lúlí núu̱‑rí. Te ma̱ kasú‑ro̱ íchi‑í, chi̱ nátu̱'un su̱chí yá'á kákuu ja̱ kúu kɨ̱vɨ ini̱ ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Nú ɨɨn cha̱a tú játú'ún‑de ñuu̱ nuu̱ tá'ú Dios tiñu nátu̱'un játú'ún ɨ́ɨn su̱chí lúlí, ma̱ kɨ́vɨ kutɨ‑dé yúan, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Te ɨɨn cha̱a kúñá'nu, ni̱ jika̱ tu̱'ún‑de‑ya̱: Cha̱a va̱'a kúu‑ní Maestro. Na̱ún sá'a‑ná te ni'i̱n tá'u̱‑ná kuchaku̱‑ná nɨ́ɨ́ káni. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Te ni̱ ka'a̱n Jesús jíín‑de: Naja̱ ká'a̱n‑ro̱ cháa va̱'a jíín‑rí. Tú ni ɨɨn cha̱a va̱'a íó, chi̱ máá ɨ́ɨn‑ni Dios. ");
INSERT INTO migNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A jiní‑ro̱ tú'un ni̱ tá'ú tíñu‑ya̱ núu̱‑ro̱: Ma̱ ká'ni‑ro ndɨ́yi, ma̱ kúsɨ́kɨ ncháa̱ tá'an‑ró, ma̱ sákuí'ná‑ró, ma̱ ká'a̱n‑ro̱ tú'un tú'ún, kuandatu̱ nuu̱ táa̱‑ro̱, nuu̱ náa̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Te máá‑de ni̱ kachi̱‑de: Ta̱ká tiñu yá'a a ni̱ skíkuu‑ná onde̱ ná lúlí‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Te Jesús, ni̱ jini so̱'o‑ya̱ tú'un yá'a. Te ni̱ kachi̱‑ya̱ jíín‑de: Ɨɨn‑na̱ tiñu kúmani̱ sá'a‑ró. Xi̱kó ndɨ́'ɨ ja̱ ñáva̱'a‑ró, te kua̱'a‑ró núu̱ ñáyɨvɨ ndá'ú. Te onde̱ andɨ́vɨ́ kóo yaji̱‑ro̱. Yúan‑na te kii‑ró kúndiki̱n‑ro̱ rúu̱ ki'o̱n. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yúan‑na te máá cháa‑ún, ni̱ jini so̱'o‑de ja̱ súan ni̱ ka'a̱n‑ya̱. Te ni̱ kuxíí xáa̱n iní‑de, chi̱ kúká xáa̱n‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Te ndé'é Jesús ja̱ súan ni̱ kuxíí xáa̱n iní‑de, te ni̱ kachi̱‑ya̱: Xaa̱n ú'u̱ kɨ̱vɨ ɨɨn cha̱a kúká iní ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yachi̱‑ga̱ kɨ̱vɨ ɨɨn camello yau̱ yɨkɨ tɨ́kuɨ́ vásá ɨ́ɨn cha̱a kúká kɨ́vɨ‑de ini̱ ñuu̱ nuu̱ tá'ú Dios tiñu. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Te ña̱yɨvɨ, ni̱ ka̱jini so̱'o‑i tu̱'un ni̱ ka'a̱n‑ya̱‑ún, ni̱ kaka'a̱n‑i: Te ndé cha̱a ka̱ku núsáá, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ió tiñu ja̱ má kúu sá'a ni ɨɨn cha̱a. Ko Dios, chi̱ kúu sá'a‑ya̱ táká‑ni. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yúan‑na te ni̱ ka'a̱n Pedro jíín‑yá: Náá, ni̱ ka̱skéndo̱o‑ná ta̱ká ndatíñu‑ná te káindiki̱n‑ná níí va̱i‑yó. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Te máá‑yá ni̱ kachi̱‑ya̱ jíín‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, nú ɨɨn cha̱a ni̱ skéndo̱o‑de ve'e‑de, xí táa̱‑de, xí ñaní‑de, xí ñásɨ́'ɨ́‑de, xí sé'e‑de ja̱ sɨkɨ́ ñúu̱ nuu̱ tá'ú Dios tiñu, ");
INSERT INTO migNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","te nani'i̱n kuá'a̱‑gá‑de vina. Te onde̱ ɨnga̱ vida chaa̱, te kuchaku̱‑de nɨ́ɨ́ káni. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Te Jesús, ni̱ ki'in‑ya̱ ndɨ́'uxí uu̱‑de, te ni̱ ka'a̱n‑ya̱ jíín‑de: Vina chi̱ kaa‑yó kí'i̱n‑yo̱ ñúu̱ Jerusalén. Te yúan skíkuu ta̱ká tu̱'un ni̱ chaa cha̱a ni̱ ka̱jani tu̱'un Dios onde̱ sáá sɨkɨ́ máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chi̱ natu̱u‑ya̱ núu̱ ñáyɨvɨ sɨ́ɨn nación. Te sákátá‑i nuu̱‑yá. Te sá'a ndɨva̱'a‑i jíín‑yá. Te tɨvɨ̱ sɨ̱'vɨ́‑i nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yúan‑na te nú ni̱ ndɨ'ɨ ni̱ ka̱xndó'o‑i‑ya̱, te ka'ni‑í‑ya̱. Ko nuu̱ uní kɨvɨ̱ te nachaku̱‑ya̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ko máá‑de, tú ní kájuku̱'un kutɨ iní‑de tu̱'un yá'a. Te tu̱'un‑ún ni̱ ka'a̱n sa̱'í‑ya̱. Yu̱án tú ní kájuku̱'un ini̱‑de ja̱ ní ka'a̱n‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Te ni̱ kuyani‑ya̱ kuá'a̱n‑ya̱ ñúu̱ Jericó. Te ɨɨn cha̱a kuáá, kánchaa̱‑de yu'íchi jikán‑de caridad. ");
INSERT INTO migNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Te cha̱a kuáá‑ún, ni̱ jini so̱'o‑de kája̱'a ña̱yɨvɨ kája'a̱n‑i. Te ni̱ jika̱ tu̱'ún‑de na̱ún kúu yu̱án. ");
INSERT INTO migNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Te ni̱ kakachi̱‑i nuu̱‑dé ja̱ Jesús, ñuu̱ Nazaret, ni̱ ja̱'a‑ya̱ kuá'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yúan‑na te ni̱ kana kó'ó‑de: Jesús, Se̱'e David, kundá'ú ini̱‑ní náá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Te ña̱yɨvɨ kája'a̱n ichi núu̱‑yá, ni̱ kaka'a̱n‑i jíín‑de ja̱ ná kasú‑de yu'u‑dé. Ko máá‑de ví'í‑gá ni̱ kana kó'ó‑de: Se̱'e David, kundá'ú ini̱‑ní náá víi̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yúan‑na te ni̱ jukuiñi̱ Jesús. Te ni̱ tá'ú‑yá tiñu ná kíi‑de nuu̱‑yá. Te ni̱ jaa̱‑de. Te ni̱ jika̱ tu̱'ún‑yá‑de: ");
INSERT INTO migNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Na̱ún sá'a‑ri̱ jíín‑ró kuní‑ro̱, áchí‑ya̱. Te cha̱a‑ún ni̱ ka'a̱n‑de: Táta̱, ja̱ ná ndúndiji̱n nduchi‑ná kuní‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Te ni̱ kachi̱ Jesús jíín‑de: Kuá'án, chi ni̱ kandíja‑ró te yu̱án ní nduva̱'a‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Te ni̱ ndundiji̱n‑ni nduchi‑dé. Te ni̱ ndiki̱n‑de‑ya̱, nákana jaa‑de Dios. Te ta̱ká ña̱yɨvɨ‑ún, ni̱ kajini̱‑i nuu̱‑dé. Te ni̱ ka̱nakana jaa‑i Dios. ");
INSERT INTO migNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Te ni̱ kɨ̱vɨ Jesús ini̱ ñuu̱ Jericó, ni̱ ja̱'a‑ni‑ya̱ kuá'a̱n‑ya̱ núú. ");
INSERT INTO migNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Te yúan ni̱ kenda‑ni ɨɨn cha̱a kúká, nání‑de Zaqueo. Te cha̱a‑ún kúñá'nu‑de nuu̱ táká cha̱a xíní. ");
INSERT INTO migNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Te ndúkú ndéé‑de nde̱'é‑de nuu̱ Jesús nú ndé cha̱a kúu‑ya̱. Ko tú ní kúu, chi̱ kua'a̱ ñáyɨvɨ ní kajasu̱‑i‑ya̱, te vina lɨkɨ̱‑ni‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Te jínu‑de ni̱ ja̱kuxnúú‑de. Te ni̱ kaa‑de xini̱ ɨ́ɨn nuyu̱'ndú náva̱'a kuni̱‑de nuu̱‑yá. Chi̱ yúan ja̱'a‑ya̱ kí'i̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Te ni̱ jaa̱ Jesús yúan. Te ni̱ ndakoto‑ya̱ núu̱‑dé. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Zaqueo, yachi̱ nuu‑ró chi̱ vina jínu ñú'ún já kéndo̱o‑ri̱ ve'e‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yúan‑na te yachi̱ ni̱ nuu‑de. Te kúsɨɨ̱ xáa̱n iní‑de ni̱ jaka‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Te ña̱yɨvɨ‑ún, ni̱ kajini̱‑i ja̱ súan ni̱ kuu. Te ni̱ kaka'a̱n sóó‑i: A kua'a̱n‑tu‑ya̱ kéndo̱o‑ya̱ jíín ɨ́ɨn cha̱a íó kua̱chi, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yúan‑na te Zaqueo ni̱ jukuiñi̱‑de. Te ni̱ kachi̱‑de jíín máá Jíto'o̱‑yo̱: Táta̱, sava ndatíñu‑ná, ná kuá'a‑ná nuu̱ ñáyɨvɨ ndá'ú. Te nú nuu̱ ɨ́ɨn cha̱a ni̱ janchaa̱‑ná ndatíñu‑de, te ná nákua̱'a‑ná kuu̱n já súan nuu̱‑dé. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Te ni̱ kachi̱ Jesús jíín‑de: Vina te ini̱ ve̱'e yá'a ni̱ ka̱ku ɨɨn cha̱a núsáá, chi̱ máá, suni se̱'e Abraham kúu. ");
INSERT INTO migNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Chi̱ máá Sé'e cha̱a va̱i nándúkú‑yá te nama‑ya̱ já á ni̱ naa. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Te ni̱ ka̱jini so̱'o ña̱yɨvɨ‑ún ta̱ká tu̱'un yá'a. Te Jesús ni̱ ka'a̱n‑ga̱‑ya̱ ɨ́ɨn tu̱'un yátá, chi̱ a ni̱ kuyani‑ya̱ ñúu̱ Jerusalén, te kájani ini̱‑i ja̱ vítan ñú'ni koo ndiji̱n ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ja̱ yúán ní ka'a̱n‑ya̱: Ɨɨn cha̱a kúñá'nu, ni̱ kenda‑de kua'a̱n jíká‑de ɨnga̱ ñuu̱ náva̱'a ni'i̱n‑dé fuerza ja̱ tɨ́ɨn‑de ñuu̱, te chaa̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Te ni̱ kana‑de xini̱ uxí tá'a̱n mozo‑de, te ni̱ ja̱'a‑de ciento ciento peso nuu̱ ɨ́ɨn ɨɨn‑i. Te ni̱ ka'a̱n‑de jíín‑i: Sátiñu jíná'an‑ró nini ki'i̱n‑ri̱ te nchaa̱‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ko kájito u'u̱ ña̱yɨvɨ ñúu̱‑ún‑de, te ni̱ ka̱tájí ɨ́ɨn comisión kua̱kasu̱ nuu̱‑dé: Tú játa'a̱n ini̱‑yo̱ já tá'ú cháa yúan tiñu nuu̱‑yo̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Te ni̱ kuu ja̱ ní ni'i̱n‑dé fuerza ja̱ tɨ́ɨn‑de ñuu̱, te ni̱ nchaa̱‑de. Te ni̱ tá'ú‑de tiñu ná kíi mozo ja̱ ní ja̱'a‑de xu̱'ún núu̱‑ún, náva̱'a ná kuní‑de ndasa ni̱ ka̱sátiñu ɨɨn ɨɨn‑i. ");
INSERT INTO migNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Te mozo ɨɨn ni̱ jaa̱ nuu̱‑dé. Te ni̱ ka'a̱n‑i: Táta̱, ni̱ ja̱'a‑ní ciento peso nuu̱‑ná, te ni̱ ni'i̱n‑ná mil peso sɨkɨ̱, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Te máá‑de ni̱ kachi̱‑de jíín mozo: Ió va̱'a chi̱ mozo va̱'a kúu‑ró. Ni̱ skíkuu va̱'a‑ró jíín yakú ndatíñu‑ri̱. Vina te tá'ú‑ró tíñu nuu̱ uxí ñuu̱ tɨ́ɨn‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Te ni̱ chaa̱ ɨnga̱ mozo te ni̱ ka'a̱n: Táta̱, ni̱ ja̱'a‑ní ciento peso nuu̱‑ná, te ni̱ ni'i̱n‑ná u'u̱n ciento peso sɨkɨ̱, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Te suni ni̱ ka'a̱n‑de jíín mozo‑ún: Róó, suni tá'ú‑ró tíñu nuu̱ ú'u̱n ñuu̱ tɨ́ɨn‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Te ni̱ chaa̱ ɨnga̱ mozo. Te ni̱ ka'a̱n: Táta̱, yá'a íó ciento peso‑ní, chi ni̱ chiva̱'a‑ná ini̱ ɨɨn pañito. ");
INSERT INTO migNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Chi ni̱ yu̱'ú‑ná ni̱ jito‑ná níí ja̱ cháa xaa̱n iní kúu‑ní, te náki'in‑ní ja̱ tú jáitúu‑ní, te já'nu̱‑ní ja̱ tú jachá‑ní, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yúan‑na te ni̱ kachi̱‑de jíín‑i: Mozo káñáá kúu‑ró, te jíín tú'un ni̱ kenda yu'u‑ro jián, náku̱xndíi‑ri̱ sɨkɨ̱‑ro̱. Chi̱ a jiní‑ro̱ já cháa xaa̱n iní kúu‑ri̱, ja̱ náki'in‑ri̱ ja̱ tú jáitúu‑rí, te já'nu̱‑ri̱ ja̱ tú jachá‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Núsáá, naja̱ tú ní já'a‑ró xú'ún‑rí no'o̱n banco núú. Te nuu̱ ncháa̱‑ri̱ te nandaka̱n‑ri̱ xu̱'ún‑rí onde̱ jíín sé'e xu̱'ún núú. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yúan‑na te ni̱ kachi̱‑de jíín sáva‑ga̱ ña̱yɨvɨ ká'i̱in yani nuu̱‑dé: Kuanchaa̱ ciento peso jia̱n núu̱‑í, te kua̱'a‑ró núu̱ mozo ñáva̱'a mil peso, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Te máá ñáyɨvɨ, ni̱ kaka'a̱n jíín‑de: Táta̱, a ñáva̱'a‑i mil peso xáa̱n, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Te ni̱ ka'a̱n tuku máá cháa kúñá'nu: A ká'a̱n‑ri̱ jíín‑ró, cha̱a ja̱ á ñáva̱'a, te kii‑ga̱ nuu̱‑dé, te cha̱a ja̱ tú ñáva̱'a, va̱sa ja̱ á ñáva̱'a‑de‑ún, te kuxio ki'i̱n. ");
INSERT INTO migNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Te suni cha̱a kájito u'u̱ ruu̱, ja̱ tú ní kákuni̱‑de ja̱ tá'ú‑rí tiñu nuu̱‑dé, kuáki̱'in‑de ná kíkoyo‑de nuu̱‑rí yá'a. Te ka'ni‑ro‑dé jíná'an‑de. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Te ni̱ ndɨ'ɨ ni̱ ka'a̱n‑ya̱ tú'un yá'a. Te ni̱ ja̱kuxnúú‑yá kua̱kaa‑ya̱ núu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Te nuu̱ ní kuyani‑ya̱ ñúu̱ Betfagé jíín ñúu̱ Betania, ni̱ jaa̱‑ya̱ ɨ́ɨn yuku nání yúku Olivos. Te ni̱ tájí‑yá uu̱ cha̱a káskuá'a jíín‑yá kája'a̱n‑de: ");
INSERT INTO migNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Kuá'án rancho kándee lado jia̱n. Te nuu̱ kɨ́vɨ‑ni‑ró yúan, te ni'i̱n‑ro̱ ɨ́ɨn burro nú'ni̱‑tɨ̱, ja̱ ní ɨɨn cha̱a té koso‑gá‑de‑tɨ̱. Te ndájí‑ró‑tɨ́. Te kii‑ró jíín‑tɨ́. ");
INSERT INTO migNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te nú ndé cha̱a ká'a̱n jíín‑ró, naja̱ kándájí‑ró‑tɨ́, achi̱‑de, te ka'a̱n‑ro̱ jíín‑de: Máá Jíto'o̱‑yo̱ jínu ñú'ún‑yá‑tɨ̱, achi̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Te kája'a̱n cha̱a ni̱ tájí‑yá‑ún te ni̱ kani'i̱n‑dé‑tɨ̱ nátu̱'un ni̱ ka'a̱n‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Te nini kándájí‑de burro‑ún te ni̱ kaka'a̱n jito'o̱‑tɨ̱ jíín‑de: Naja̱ kándájí‑ró burro‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Te máá‑de, ni̱ kaka'a̱n‑de: Chi̱ máá Jíto'o̱‑yo̱ jínu ñú'ún‑yá‑tɨ̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Te ni̱ cha̱koyo‑de jíín‑tɨ́ nuu̱ Jesús. Te ni̱ ka̱xndée‑de tɨka̱chí‑de sɨkɨ̱ burro‑ún. Te ni̱ ka̱skáa‑de Jesús sɨkɨ̱‑tɨ́ yóso‑yá‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Te nini jíka‑ya̱ kuá'a̱n‑ya̱, te ni̱ kajaki̱n‑de tɨka̱chí‑de ini̱ ichi. ");
INSERT INTO migNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Te nini kákuyani‑ya̱ ñúu̱ Jerusalén ja̱ kákuun‑ya̱ yúku Olivos, te ta̱ká cha̱a káskuá'a jíín‑yá, kánakana jaa‑de Dios sɨkɨ̱ táká tiñu ñá'nu ja̱ ní kajini̱‑de ni̱ sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Te káka'a̱n‑de: Ná nákana jaa‑yó Rey yá'a chi̱ ndíso‑ya̱ tíñu máá Tatá Dios. Chi̱ vindaa̱ vinené íó onde̱ andɨ́vɨ́, te suni luu ñá'nu káa yúan. Achí. ");
INSERT INTO migNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yúan‑na te sava cha̱a fariseo ká'i̱in ma̱'ñú ñáyɨvɨ kuá'a̱‑ún, ni̱ kaka'a̱n‑de jíín‑yá: Maestro, kana jíín‑ní nuu̱ cháa káskuá'a jíín‑ní, ná kasú‑de yu'u‑dé, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Te máá Jesús ni̱ ka'a̱n‑ya̱: A ká'a̱n‑ri̱ jíín‑ró ja̱ nú cha̱a yá'a ná kasú‑de yu'u‑dé, te súan kana kó'ó táká yuu̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Te ni̱ kuyani‑ya̱. Te ni̱ jini̱‑ya̱ núu̱ ñúu̱‑ún. Te ni̱ nde'e̱‑ya̱ sɨkɨ́ ñúu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Te ni̱ ka'a̱n‑ya̱: Aa̱, xáán va̱'a nú ní jiní máá‑ró ndasa va̱i tu̱'un vindaa̱ vinené núú. Ko vina chi̱ a yísa̱'í te ma̱ kuní‑ro̱ núu̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chi̱ jaa̱ kɨvɨ̱, ja̱ cháa kájito u'u̱ róó kuíkó ndúu̱ nɨ́nɨ‑dé róó. Te ta̱ká lado kasu̱‑de róó. Te nataan ní'in‑de róó. ");
INSERT INTO migNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Te stúncháa̱‑de róó nuu̱ ñú'un onde̱ jíín sé'e‑ró já káxiu̱kú‑i ini̱‑ro̱. Te ma̱ skéndo̱o‑de yuu̱ kóso tá'an sɨkɨ̱ yúu̱, chi̱ tú ní jiní‑ro̱ já ní kii‑ya̱ núu̱‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Te ni̱ kɨ̱vɨ Jesús ini̱ ve̱'e ii̱. Te ni̱ kejá'á‑yá kíñi'in‑ya̱ ñáyɨvɨ kájaan káxi̱kó íin‑i ini̱ ve̱'e ii̱‑ún kája'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Te ni̱ ka'a̱n‑ya̱ jíín‑i: Á tú yóso núu̱ tutú: Ve'e‑ri̱, chi̱ ve'e nuu̱ kájika̱n ta'u̱ kúu, ko máá‑ró, a ni̱ ka̱nasá'a‑ró yaú kava ñákui̱'ná, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Te ndɨta'a̱n kɨvɨ̱ stá'a̱n‑ya̱ tú'un ini̱ ve̱'e ii̱. Ko sutu̱ ñá'nu jíín cháa káchaa tutu̱ jíín cháa kákuñá'nu ini̱ ñuu̱‑ún, ni̱ ka̱ndúkú‑de modo ndasa ka'ni‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ko tú ní kákuu ndasa sá'a‑de jíín‑yá, chi̱ ndivii ñáyɨvɨ, ni̱ ka̱kee nuu̱‑í ká'i̱in‑i kájini ná'ín‑i tu̱'un ká'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Te ɨɨn kɨvɨ̱ jián stá'a̱n‑ya̱ tú'un nuu̱ ñáyɨvɨ iní ve̱'e ii̱, te jáni‑ya̱ tú'un va̱'a. Te sutu̱ ñá'nu jíín cháa káchaa tutu̱ jíín cháa ni̱ ka̱yii, ni̱ ja̱koyo‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Te ni̱ kajika̱ tu̱'ún‑de‑ya̱: Kastu̱'ún, na̱ jíín tú'un sá'a‑ró tíñu yá'a. Te ndéja̱ ní ka'a̱n jíín‑ró sá'a‑ró súan, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de: Suni ná kaká tu̱'ún‑rí róó ɨɨn tu̱'un: Kastu̱'ún, ");
INSERT INTO migNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ja̱ ní skuánducha Juan sáá, á onde̱ andɨ́vɨ́ ní kii tu̱'un, xí cháa ni̱ tá'ú tíñu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yúan‑na te ni̱ kanda̱tu̱'ún máá‑de: Nú ka'a̱n‑yo̱ já ondé andɨ́vɨ́, te kachi̱‑de kuni‑yó: Naja̱ tú ní kákandíja‑ró núu̱‑dé núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Te nú ka'a̱n‑yo̱ já cháa ni̱ tá'ú tíñu, te ndivii ñáyɨvɨ kuá'a‑i yuu̱ xiní‑yo̱. Chi̱ kájani ndija ini̱‑i ja̱ cháa ni̱ jani tu̱'un Dios ni̱ kuu Juan, áchí‑de jíín tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Te ni̱ kaka'a̱n‑de ja̱ tú kájini̱‑de ndénu̱ ní kii tu̱'un‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de: Suni ruu̱ tú kachi̱‑ri̱ nuu̱‑ro̱ na̱ jíín tú'un sá'a‑ri̱ tiñu yá'a, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Te ni̱ kejá'á‑yá ni̱ ka'a̱n‑ya̱ tú'un yátá yá'a jíín ñáyɨvɨ‑ún: Ɨɨn cha̱a ni̱ nachu'un‑de ɨɨn itu̱ uva. Te ni̱ xndóo‑de nuu̱ cháa kásátiñu jíín. Te ni̱ kee‑de kua'a̱n jíká‑de ja̱ ná'án xáa̱n. ");
INSERT INTO migNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Te ɨɨn kɨvɨ̱ ni̱ tájí‑de ɨɨn mozo‑de kua'a̱n nuu̱ cháa kásátiñu jíín uva ja̱ ná nákua̱'a‑de nde'e̱ uva nuu̱ mozo‑ún núú. Ko cha̱a kásátiñu‑ún, ni̱ kastují‑dé mozo. Te ni̱ ka̱kiñi'in‑de‑i kua̱no'on sáni‑ni‑i. ");
INSERT INTO migNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Te jito'o̱‑ún, ni̱ na̱tájí tuku‑de ɨnga̱ mozo‑de. Ko máá cháa kásátiñu‑ún, suni ni̱ ka̱stují‑dé mozo‑ún, te ni̱ ka̱sákátá‑de jíín‑i te ni̱ ka̱kiñi'in‑de‑i kua̱no'on sáni‑ni‑i. ");
INSERT INTO migNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Te jito'o̱ uva‑ún ni̱ na̱tájí tuku‑de mozo uni̱‑de kua'a̱n. Ko máá cháa kásátiñu‑ún, suni ni̱ ka̱stují‑dé mozo‑ún. Te ni̱ ka̱skúnu‑de‑i. ");
INSERT INTO migNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yúan‑na te ni̱ ka'a̱n máá jíto'o̱ itu̱ uva: Ndasa sá'a‑ri̱. Ná tájí‑rí se̱'e‑ri̱ ja̱ kúndá'ú ini̱‑ri̱‑i. Sanaa te koo ja̱ jíñú'ún‑de nuu̱ sé'e‑ri̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ko máá cháa kásátiñu‑ún, ni̱ kajini̱‑de nuu̱‑í. Te ni̱ kanda̱tu̱'ún máá‑de: Su̱chí yá'a xíin tá'u̱. Ná chó'o̱, ná ká'ni‑yo‑í náva̱'a ná ndóo ta'u̱‑í kuu‑yó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Te ni̱ ka̱kiñi'in‑de‑i ichi yatá itú uva. Te ni̱ ka̱ja'ni‑dé‑i. Te ndasa sá'a máá jíto'o̱ itu̱ uva jíín‑de núsáá. ");
INSERT INTO migNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chaa̱‑de, te xnáa‑dé cha̱a kásátiñu‑ún. Te kua̱'a‑de itu̱ uva nuu̱ ɨngá cha̱a. Achí‑ya̱. Te ña̱yɨvɨ‑ún ja̱ ní ka̱jini so̱'o‑i tu̱'un yá'a, te ni̱ kaka'a̱n‑i: Ma̱ kúu kutɨ súan, Táta̱. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ko máá‑yá ni̱ nde̱'é‑yá nuu̱‑í te ni̱ ka'a̱n‑ya̱: Núsáá te na̱ún kuní ka'a̱n tu̱'un yóso yá'a: Yuu̱ ní ka̱ské'ichi̱ cha̱a káchutá'an, ya̱'á kúu máá yúu̱ ndíso fuerza jiki̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ta̱ká‑i ja̱ nduá sɨkɨ̱ yúu̱‑ún, te ta'nu̱. Ko nú ndé sɨkɨ̱ júngava máá yúu̱‑ún, te kukuáchí‑i sá'a. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yúan‑na te sutu̱ ñá'nu‑ún jíín cháa káchaa tutu̱ ni̱ ka̱ndúkú‑de modo tɨɨn‑de‑ya̱ máá hora‑ún. Chi ni̱ kaju̱ku̱'un ini̱‑de ja̱ sɨkɨ́ máá‑de kúu tu̱'un yátá ní ka'a̱n‑ya̱‑ún. Ko ni̱ kayu̱'ú‑de ni̱ ka̱jito‑de ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Te ndé'é ndé'é‑de ichi‑yá. Te ni̱ ka̱tájí‑de sava cha̱a ja̱ kóto yu'u‑dé‑ya̱. Te cha̱a‑ún, káka'a̱n‑de ja̱ cháa ndaa̱ kákuu‑de, náva̱'a tɨɨn yátá‑de‑ya̱ sɨkɨ́ tú'un ká'a̱n‑ya̱, te nastúu‑de‑ya̱ núu̱ fuerza gobernador, cha̱a tá'ú tíñu yúan, kákuni̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Te cha̱a‑ún, ni̱ kajika̱ tu̱'ún‑de‑ya̱: Maestro, kájini̱‑ná ja̱ ká'a̱n va̱'a‑ní te stá'a̱n ndaa̱‑ní tu̱'un. Te tú ndé'é‑ní ndasa jíto ta̱ká ña̱yɨvɨ, chi̱ sua stá'a̱n ndaa̱‑ní ichi Dios. ");
INSERT INTO migNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Á kuu kua̱'a‑yó xú'ún yóo̱ nuu̱ César xí túu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ko máá‑yá, ni̱ jini̱‑ya̱ já xndá'ú‑de‑ya̱ kákuni̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Naja̱ kájito nchaa̱‑ro̱ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Stá'a̱n xu̱'ún jián ná ndé'é‑rí. Ndé cha̱a kúu cha̱a ncháá nuu̱ yá'a, jíín tú'un yóso yá'a. Achí‑ya̱. Te ni̱ kaka'a̱n‑de: César kúu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín‑de: Kua̱'a ja̱ xíin César nuu̱ César, te ja̱ xíin Dios nuu̱ Dios núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Te tú ní kákuu tɨɨn yátá‑de‑ya̱ jíín tú'un yá'a jíto nuu̱ ñáyɨvɨ. Te ni̱ ka̱naa iní‑de ni̱ ka̱jini so̱'o‑de tu̱'un ni̱ ka'a̱n‑ya̱ jíín‑de. Te tú ní káka'a̱n kutɨ‑gá‑de. ");
INSERT INTO migNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yúan‑na te ni̱ ja̱koyo yaku̱ cha̱a saduceo. Te cha̱a‑ún, káka'a̱n‑de ja̱ tú nachaku̱ kutɨ ndɨ́yi. Te ni̱ kajika̱ tu̱'ún‑de‑ya̱: ");
INSERT INTO migNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Maestro, Moisés ni̱ chaa‑de tutu̱ ni̱ ndo̱o jíín‑yó: Nú ñani̱ ɨɨn cha̱a kuu̱‑de, te íó ñasɨ́'ɨ́‑de, te nú tú se̱'e‑de ní íó. Yúan‑na te ñani̱‑de ná náki'in ñasɨ́'ɨ́‑de, te nandaki̱n‑de tata̱ ñani̱‑de, áchí tutu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bueno, ni̱ ka'i̱o usia̱ ñani̱. Te cha̱a núú, ni̱ ta̱nda'a‑dé. Te ni̱ ji'i̱‑de. Te tú kutɨ sé'e‑de ní íó. ");
INSERT INTO migNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Te cha̱a uu̱, ni̱ naki'in‑de‑ña. Te ni̱ ji'i̱‑de. Te tú kutɨ sé'e‑de ní íó. ");
INSERT INTO migNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Te cha̱a uni̱ ni̱ naki'in‑de‑ña. Te ni̱ ji'i̱ tuku‑de. Te ndɨ́'usiá‑de suni súan. Te ni̱ kaji'i̱‑de. Te tú kutɨ ní ɨɨn se̱'e ní káxndóo‑de. ");
INSERT INTO migNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Te onde̱ sandɨ̱'ɨ́‑na̱ te suni ni̱ ji'i̱ máá ñá'an‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Te kɨvɨ̱ náchaku̱ ta̱ká ndɨ̱yi, ndé ɨɨn‑de kuu‑ña ñásɨ́'ɨ́‑de núsáá. Chi̱ ndɨ́'usiá‑de ni̱ kancha̱ka‑de‑ña, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yúan‑na te ni̱ kachi̱ Jesús jíín‑de: Se̱'e ña̱yɨvɨ yá'a, chi̱ káta̱nda'a‑í jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ko íó ña̱yɨvɨ já jáni ini̱ Dios ja̱ ñáyɨvɨ vá'a kúu‑i. Te ña̱yɨvɨ‑ún nachaku̱‑i ma̱'ñú ndɨ́yi, te kɨ̱vɨ‑i ɨnga̱ vida. Te tú ta̱nda'a kútɨ‑í jíná'an‑i yúan. ");
INSERT INTO migNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ni ma̱ kúu̱ kutɨ‑gá‑i. Chi̱ ɨɨn núú‑ni kákuu‑i jíín ndájá'a̱ ándɨ́vɨ́, te suni se̱'e Dios kákuu‑i, chi̱ a ni̱ nachaku̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Te sɨkɨ̱ ndɨ́yi ja̱ náchaku̱, suni ɨɨn‑ni tu̱'un ni̱ stá'a̱n Moisés nuu̱ yóso tú'un cuenta yuku̱. Chi ni̱ skúnání‑de‑ya̱ Dios Abraham, Dios Isaac, jíín Dios Jacob. ");
INSERT INTO migNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Chi̱ Dios, nasu̱ Dios ña̱yɨvɨ ní kaji'i̱ kúu‑ya̱, chi̱ sua Dios ña̱yɨvɨ káichaku̱ kúu‑ya̱. Chi̱ nuu̱ máá‑yá káichaku̱ ta̱ká ña̱yɨvɨ. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Te yaku̱ cha̱a káchaa tutu̱, ni̱ kaka'a̱n‑de: Va̱'a‑ni ni̱ ka'a̱n‑ní Maestro, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Te tuká ní kátava iní‑de ja̱ kaká tu̱'ún‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Naja̱ káka'a̱n‑de ja̱ Cristo kúu Se̱'e David. ");
INSERT INTO migNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Chi̱ máá David ni̱ ka'a̱n‑de nuu̱ tutú Salmo: Máá Tatá Dios ni̱ ka'a̱n‑ya̱ jíín Jíto'o̱‑ri̱: Nungo̱o‑ró íchi ndává'a‑ri̱, ");
INSERT INTO migNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","te ná chúkú‑rí ña̱yɨvɨ kájito u'u̱ róó kuu‑i teyu̱ kuxndíi ja'a̱‑ro̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Te máá David: Jito'o̱ ni̱ ka'a̱n‑de jíín‑yá: Te ndasa kúu‑ya̱ sé'e‑de núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Te kánchaa̱‑ya̱ má'ñú táká ña̱yɨvɨ. Te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a jíín‑yá: ");
INSERT INTO migNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Koto‑ró máá‑ró núu̱ cháa káchaa tutu̱, chi̱ kákuni̱‑de kaka‑de jíín sú'nu̱ káni. Te kákuni̱‑de ja̱ ká'a̱n sa̱'án‑yo̱ jíín‑de nu̱yá'u. Te silla jíñú'ún ondé xini̱ mesa ini̱ ve̱'e sinagoga, jíín silla xini̱ mesa nuu̱ íó xíni kákuni̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Te suni cha̱a yá'a kákókó‑de ve'e ña'an kéndo̱o ndá'ú. Te kándúkú‑de modo sáni, ja̱ kájika̱n ta'u̱ ná'án‑de. Cha̱a yá'a, ví'í‑gá ta'nu̱ ndatu̱‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Te ni̱ ndakoto‑ya̱, te ni̱ jini̱‑ya̱ núu̱ ñáyɨvɨ kúká káchu'un‑i xu̱'ún iní janu̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Te ni̱ jini̱‑ya̱ núu̱ ɨ́ɨn ña'an viuda ja̱ ní kendo̱o ndá'ú íi̱‑ñá, te ni̱ chu'un‑ña úu̱ xu̱'ún yɨ́kɨ́n náa iní janu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Te ni̱ ka'a̱n‑ya̱: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ ñá'an ní kendo̱o ndá'ú yá'a, ni̱ chu'un‑ga̱‑ña vásá táká‑ga̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chi ta̱ká‑i, ni̱ ka̱chu'un‑i ja̱ ní ndendoso sɨkɨ́‑í ni̱ kasoko̱‑í nuu̱ Dios. Ko ña'an yá'a, va̱sa kúndá'ú‑ña ko ni̱ chu'un ndɨ'ɨ‑ña já kúchaku̱‑ña jíín, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Te sava‑de káka'a̱n‑de tu̱'un ve'e ii̱, ndasa ni̱ nduluu jíín yúu̱ lúu jíín ofrenda. Te ni̱ ka'a̱n‑ya̱: ");
INSERT INTO migNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ta̱ká ndatíñu ja̱ kánde̱'é‑ró yá'a, chaa̱ ɨɨn kɨvɨ̱ já má kútá'an‑ga̱ ni ɨɨn yuu̱, chi̱ ndɨ'ɨ ndua̱ sá'a‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yúan‑na te ni̱ kajika̱ tu̱'ún‑de‑ya̱: Maestro, ndé kɨvɨ̱ kóo ta̱ká tiñu yá'a. Te na̱ún tuni̱ koo nuu̱ kúyani chaa̱ ta̱ká tiñu yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín‑de: Koto‑ró máá‑ró jíná'an‑ró náva̱'a tú xndá'ú ni ɨɨn‑i róó. Chi̱ kikoyo kua'a̱ ñáyɨvɨ kí'in núu sɨ́'vɨ́‑rí, te ka'a̱n‑i: Máá‑rí kúu I'a̱‑ún. A ni̱ chaa̱ kɨvɨ̱‑ún, achi̱‑i. Ko ma̱ kí'i̱n‑ro̱ jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Te nú ni̱ ka̱jini tu̱'un‑ró já íó guerra te kája̱tá'an ña̱yɨvɨ, te ma̱ yú'ú‑ro̱, chi̱ kánúú já xná'a̱n‑ga̱ koo ta̱ká tiñu yá'a. Ko ma̱ ndɨ́'ɨ yachi̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín‑de: Ndonda nación sɨkɨ̱ nación te ñuu̱ sɨkɨ̱ ñúu̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Te ta̱an xaa̱n. Te yá'a yúan koo tama̱ jíín kué'e̱ xaa̱n. Te koo tuni̱ ñá'nu ichi ándɨ́vɨ́, te yu̱'ú ña̱yɨvɨ jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ko onde̱ té chá'a̱n‑ga̱ koo ta̱ká tiñu yá'a, te chindiki̱n‑i róó te katɨɨn‑i róó. Te nastúu‑i róó ini̱ ve̱'e sinagoga jíín iní veka̱a, kincha̱ka‑i róó nuu̱ rey jíín núu̱ gobernador ja̱ sɨkɨ́ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Te koo súan náva̱'a kani ndaa̱‑ro̱ tú'un. ");
INSERT INTO migNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Núsáá te ná kúndaa̱ ini̱‑ro̱ já má nákani ini̱‑ro̱ ndasa xndíó káni‑ró tú'un nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chi̱ ruu̱, kua̱'a‑ri̱ ɨɨn yu'u jíín tú'un ndíchí núu̱‑ro̱, náva̱'a cha̱a kájito u'u̱ róó, ma̱ kúu ka'a̱n‑de sɨkɨ̱‑ro̱ ni ma̱ kúu kundéé‑de jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Te suni táa̱‑ro̱, ñani̱‑ro̱, tá'an‑ró, jíín ñáyɨvɨ kájini̱ tá'an‑ró jíín, nastúu‑i róó. Te kuu̱ sava‑ró sá'a‑i. ");
INSERT INTO migNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Te ta̱ká ña̱yɨvɨ, koto u'u̱‑i róó ja̱ sɨkɨ́ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ko ni ɨɨn ixi xiní‑ro̱ ma̱ náa kútɨ. ");
INSERT INTO migNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Te nú kua̱ndéé iní‑ro̱ te kuchaku̱ añú‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ko nú ni̱ kajini̱‑ro̱ já ní ka̱jíkó ndúu̱ soldado yata̱ ñúu̱ Jerusalén, yúan‑na te juku̱'un ini̱‑ro̱ já á yani naa ñúu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yúan‑na te ña̱yɨvɨ káxiu̱kú iní ñuu̱ Judea, kunu‑i ki̱ngoyo‑i onde̱ yuku. Te ña̱yɨvɨ ká'i̱in ma̱'ñú ñúu̱‑ún, kuxio‑i ki'i̱n‑i. Te ña̱yɨvɨ ká'i̱in onde̱ rancho, ma̱ ndɨ́vɨ‑i ini̱ ñuu̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chi̱ kɨvɨ̱ yúan kuu kɨvɨ̱ náni'i̱n tá'an Dios jíín‑i, náva̱'a náskíkuu ta̱ká tu̱'un yóso núu̱ tutú. ");
INSERT INTO migNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ko kɨvɨ̱‑ún, naka̱ ndá'ú kuu ña'an káñu̱'un se̱'e jíín ñá'an káskáxin‑í, chi̱ kii tu̱ndó'o xaa̱n sɨkɨ́ ñúyɨ́vɨ. Te kiti̱ ini̱ Dios jíín ñáyɨvɨ yá'a. ");
INSERT INTO migNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Te kuu̱‑i jíín machete. Te ki̱ngoyo‑i preso onde̱ ta̱ká nación. Te ña̱yɨvɨ sɨ́ɨn nación, kuañu̱‑i sɨkɨ̱ ñúu̱ Jerusalén onde̱ ji̱nu kɨvɨ̱ ñáyɨvɨ sɨ́ɨn nación. ");
INSERT INTO migNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yúan‑na te koo tuni̱ nuu̱ ndíka̱ndii jíín núu̱ yóo̱ jíín núu̱ tíñu̱ú xíní. Te kii tu̱ndó'o sɨkɨ̱ táká ña̱yɨvɨ ñúyɨ́vɨ yá'a. Te yu̱'ú ña̱yɨvɨ já nɨ́'ɨn mar jíín sú'ma̱ mar. ");
INSERT INTO migNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Te kuu̱ xáan sáva cha̱a ja̱ káyu̱'ú‑de, chi̱ káinda̱tu‑de chaa̱ tu̱ndó'o yá'a sɨkɨ̱ nɨ́ɨ́ ñúyɨ́vɨ. Te ta̱ká fuerza andɨ́vɨ́, ndɨ'ɨ ka'ya. ");
INSERT INTO migNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yúan‑na te kuni̱‑i nuu̱ máá Sé'e cha̱a kii‑ya̱ núu̱ ɨ́ɨn viko̱ nu̱'ún, jíín fuerza ja̱ ndúñá'nu xaa̱n‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Te nú a ni̱ kejá'á táká tiñu yá'a, yúan‑na te ndukani‑ró xiní‑ro̱ te ndakoto‑ró, chi̱ a yani nama‑ya̱ róó, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Te suni ni̱ ka'a̱n‑ya̱ ɨ́ɨn tu̱'un yátá jíín‑de: Nde̱'é yúnu mérkexe̱, jíín táká‑ga̱ yunu. ");
INSERT INTO migNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nú ni̱ kajini̱‑ro̱ já ní kejá'á nájaa numa yúnu‑ún, yúan‑na te kájuku̱'un ini̱‑ro̱ já á yani nchaa̱ viko sáú. ");
INSERT INTO migNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Suni súan máá‑ró, nú ni̱ kajini̱‑ro̱ kuákuu ta̱ká tiñu yá'a, yúan‑na te kuni̱‑ro̱ já á yani koo ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ja̱ má náa ñáyɨvɨ yá'a onde̱ nú tú skíkuu ta̱ká tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Andɨ́vɨ́ jíín ñúyɨ́vɨ chi̱ naa, ko tu̱'un ká'a̱n‑ri̱ chi ma̱ náa. ");
INSERT INTO migNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Koto‑ró máá‑ró náva̱'a ma̱ kutéñu añú‑ro̱ jíín já kée ndásɨ́‑ró xí já kóo náji̱ni‑ró. Te ma̱ kútéñu‑ró jíín ndátíñu kuchaku̱‑ro̱, chi̱ sanaa te chaa̱‑ni kɨvɨ̱‑ún sɨkɨ̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chi̱ nátu̱'un ɨɨn xeyu̱, súan jinu̱ sɨkɨ̱ táká ña̱yɨvɨ káxiu̱kú nɨ́ɨ́ ñúyɨ́vɨ yá'a. ");
INSERT INTO migNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Núsáá te kundito‑ró táká kɨvɨ̱, te kaka̱n ta'u̱‑ro̱ náva̱'a kuu ka̱ku‑ró núu̱ táká tu̱ndó'o ja̱ kíi‑ún, te kundii̱‑ro̱ núu̱ máá Sé'e cha̱a. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Te ndɨta'a̱n kɨvɨ̱ ní stá'a̱n‑ya̱ tú'un ini̱ ve̱'e ii̱. Te ndɨta'a̱n akuáa ní kenda‑ya̱ kuá'a̱n‑ya̱ ondé yuku Olivos. Te yúan ni̱ ndo̱o‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Te ta̱ká ña̱yɨvɨ, ña'a̱n chákoyo‑i nuu̱‑yá ini̱ ve̱'e ii̱, náva̱'a kuni so̱'o‑i tu̱'un ká'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yúan‑na te ni̱ kuyani viko kóo sta̱tilá tú yí'i yujan íá, ja̱ nání víko Pascua. ");
INSERT INTO migNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Te ta̱ká sutu̱ ñá'nu jíín táká cha̱a káchaa tutu̱, ni̱ ka̱ndúkú sá'í‑de modo ndasa ka'ni‑dé‑ya̱, chi ni̱ kayu̱'ú‑de ni̱ ka̱jito‑de ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Te ni̱ kɨ̱vɨ Satanás ini̱ Judas, cha̱a nání Iscariote, ɨɨn tá'an ja̱ uxí uu̱‑ún kúu‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Te cha̱a‑ún, ni̱ kee‑de kua'a̱n‑de. Te ni̱ ndatu̱'ún‑de jíín sutú ñá'nu jíín cháa kákuu jefe nú ndasa nastúu‑de Jesús. ");
INSERT INTO migNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Te máá cháa‑ún ni̱ ka̱kusɨɨ̱ iní‑de. Te ni̱ ka̱kee yu'u‑dé ja̱ kuá'a‑de xu̱'ún núu̱ Judas. ");
INSERT INTO migNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Te ni̱ jatu̱'un Judas. Te ni̱ ndúkú‑de modo ndasa nastúu‑de‑ya̱ núu̱ sutú jíná'an náva̱'a tú kuvaa̱ ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Te ni̱ jaa̱ viko kóo sta̱tilá tú yí'i yujan íá. Te máá kɨvɨ́‑ún jínu ñú'ún ká'ni‑í lélú Pascua. ");
INSERT INTO migNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Te ni̱ tájí‑yá Pedro jíín Juan kua'a̱n‑de, te ni̱ ka'a̱n‑ya̱ jíín‑de: Kuá'án te sátu̱'a‑ró núu̱ kée‑yo lélú Pascua, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Te ni̱ kaka'a̱n‑de jíín‑yá: Ndénu̱ kuní‑ní sátu̱'a‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Te ni̱ kachi̱‑ya̱ jíín‑de: Kuni so̱'o, nú a ni̱ jaa̱‑ro̱ iní ñuu̱‑ún, te ketá'an‑ró jíín ɨ́ɨn cha̱a ndíso ɨɨn kɨ̱yi nducha. Kundiki̱n‑ro̱‑dé ki'i̱n‑ro̱ jíín‑de onde̱ ini̱ ve̱'e nuu̱ ndɨ́vɨ‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Te ka'a̱n‑ro̱ jíín jíto'o̱ ve'e‑ún: Achí máá Maestro jíín‑ní: Ndénu̱ íó ɨɨn ve'e kua̱'a núu‑ní nuu̱ kée‑ná lélú Pascua jíín cháa káskuá'a jíín‑ná, achi̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yúan‑na te jito'o̱‑ún stá'a̱n‑de ɨɨn cuarto ká'nu onde̱ xini̱ vé'e nuu̱‑ro̱, ja̱ á núña. Te yúan sátu̱'a‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Te kája'a̱n‑de. Te ni̱ kani'i̱n‑dé nátu̱'un ni̱ ka'a̱n‑ya̱ jíín‑de. Te ni̱ ka̱sátu̱'a‑de ndasa kuxíni‑de lélú Pascua. ");
INSERT INTO migNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Te ni̱ jaa̱ hora‑ún, te ni̱ jungo̱o‑ya̱ núu̱ mesa. Te suni ni̱ kaju̱ngo̱o apóstol‑ya̱ jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Te ni̱ kachi̱‑ya̱ jíín‑de: Xaa̱n kúu ini̱‑ri̱ kee‑rí lélú Pascua yá'a jíín‑ró jíná'an‑ró ja̱ té ndo'o‑ga̱‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chi̱ kástu̱'ún‑rí nuu̱‑ro̱, ja̱ má kée kútɨ‑gá‑ri̱ Pascua yá'a, onde̱ nú tú skíkuu máá iní ñuu̱ nuu̱ tá'ú Dios tiñu. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Te ni̱ ki'in‑ya̱ ɨ́ɨn taza. Te ni̱ jika̱n ta'u̱‑yá, te ni̱ ka'a̱n‑ya̱: Ki'in ya̱'á. Te saka‑ro núu̱ tá'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chi̱ ká'a̱n‑ri̱ jíín‑ró já ondé vina ma̱ kó'o kutɨ‑gá‑ri̱ nducha ndé'e̱ uva, onde̱ nú tú koo ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Te ni̱ ki'in‑ya̱ stáa̱. Te ni̱ jika̱n ta'u̱‑yá. Te ni̱ sákuáchí‑yá. Te ni̱ ja̱'a‑ya̱ núu̱‑dé jíná'an‑de. Te ni̱ ka'a̱n‑ya̱: Ya̱'á kúu yikɨ kúñu‑ri̱ ja̱ ní jatañaa‑ri̱ ja̱ sɨkɨ́ róó jíná'an‑ró. Ya̱'á sá'a‑ró já núku̱'un ini̱‑ro̱ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Suni súan ni̱ sá'a‑ya̱ jíín taza, nuu̱ ní ndɨ'ɨ ni̱ kuxíni‑ya̱. Te ni̱ ka'a̱n‑ya̱: Taza yá'a kúu nɨñi̱‑rí ja̱ sá'a contrato jáá. Te ni̱ jatɨ ja̱ sɨkɨ́ róó jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ko nde̱'é‑ró já cháa nastúu ruu̱, kánchaa̱‑de jíín‑rí nuu̱ mesa yá'a. ");
INSERT INTO migNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chi ja̱ndáa̱, máá Sé'e cha̱a ki'i̱n‑ya̱ íchi já ní sándaa̱ Dios. Ko naka̱ ndá'ú kuu cha̱a nástúu I'a̱‑ún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yúan‑na te cha̱a káskuá'a jíín‑yá, ni̱ ka̱kejá'á‑de kájika̱ tu̱'ún tá'an máá‑de, nú ndé ɨɨn‑de kúu cha̱a sá'a tiñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Te ni̱ ka̱kejá'á‑de kástátá'an máá‑de nú ndé ɨɨn‑de kúñá'nu‑ga̱ nuu̱ tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yúan‑na te máá‑yá ni̱ ka'a̱n‑ya̱ jíín‑de: Ta̱ká rey, chi̱ nuu̱ táká ña̱yɨvɨ kátá'ú téyíí‑de tiñu. Te cha̱a kákuñá'nu nuu̱ máá‑i, cha̱a kásá'a va̱'a káskúnání‑i‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ko sɨkɨ̱ róó jíná'an‑ró na̱ tú súan koo. Ndé róó ja̱ kúñá'nu‑ga̱, ná ndúu‑ró nátu̱'un cha̱a súchí‑ga̱. Te ndé róó ja̱ kúñá'nu‑ga̱‑ro̱, ná ndúu‑ró nátu̱'un cha̱a játíñu nuu̱ tá'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Te ndéja̱ kúñá'nu‑ga̱ íó, á cha̱a yée stáa̱ núu̱ mesa, xí cháa játíñu. Nasu̱ cháa ja̱ yée stáa̱ núu̱ mesa náún. Te ruu̱, nátu̱'un cha̱a játíñu kúu‑ri̱ nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ko máá‑ró jíná'an‑ró, ni̱ ka'i̱in‑ró jíín‑rí va̱sa kájito nchaa̱‑i ruu̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Te nátu̱'un ni̱ ja̱'a Táa̱‑ri̱ ɨɨn ñuu̱ ja̱ tá'ú‑rí tiñu nuu̱, suni súan kua̱'a‑ri̱ nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Náva̱'a kee‑ro kó'o‑ró núu̱ mesa jíín‑rí ini̱ ñuu̱ nuu̱ tá'ú‑rí tiñu. Te jungo̱o‑ró núu̱ silla. Te sándaa̱‑ro̱ tíñu ndɨ́'uxí uu̱ tata̱ Israel. ");
INSERT INTO migNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Te suni ni̱ ka'a̱n máá Jíto'o̱‑yo̱: Simón, Simón, kuni so̱'o‑ró, chi ni̱ jika̱n Satanás róó jíná'an‑ró ja̱ síjin‑ún róó nátu̱'un trigo. ");
INSERT INTO migNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ko ni̱ jika̱n ta'u̱‑rí ja̱ kúu róó náva̱'a ma̱ náyu̱'ú‑ro̱. Te máá‑ró, nú a ni̱ naxíó káva ini̱‑ro̱, te ná síyíja‑ró táká ñani̱‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Te ni̱ ka'a̱n‑de jíín‑yá: Táta̱, a kándii̱ tu̱'a‑ná ja̱ kí'i̱n‑ná jíín‑ní va̱sá veka̱a te kuu̱‑yo̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Te ni̱ ka'a̱n‑ya̱: Pedro, áchí‑ri̱ jíín‑ró, ja̱ ondé ná té kana‑ga̱ lí'li vina te uni̱ jínu ka'a̱n‑ro̱ já tú jiní kutɨ‑ro rúu̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yúan‑na te ni̱ jika̱ tu̱'ún‑yá‑de: Ná ni̱ tájí‑rí róó ni̱ kaja'a̱n‑ro̱ já tú ní kándi̱so‑ró ñúnu, ni bolsa, ni tú ní káyi̱'i‑ró ndiján, á ni̱ kumani̱ ɨ́ɨn ndatíñu nuu̱‑ro̱ náún, áchí‑ya̱. Te ni̱ kaka'a̱n‑de: Tú ni ɨɨn, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ko vina, cha̱a ñáva̱'a ñunu, ná náki'in‑de. Te suni súan jíín bolsa. Te cha̱a ja̱ tú na̱ún ñáva̱'a‑de, ná xíkó‑de tɨka̱chí‑de te ná kuáan‑de ɨɨn machete. ");
INSERT INTO migNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Chi̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ kánúú skíkuu‑ri̱ tu̱'un yá'a ja̱ yóso núu̱ tutú: Te onde̱ jíín cháa ñáá ni̱ skétá'an‑de‑ya̱, áchí. Chi ta̱ká tu̱'un‑ri̱ ja̱ yóso ná skíkuu ná'ín, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yúan‑na te ni̱ kaka'a̱n‑de: Táta̱, yá'a íó uu̱ machete, áchí‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Suu jia̱n‑ni, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Te ni̱ kenda‑ya̱. Te ni̱ kee‑ya̱ kuá'a̱n‑ya̱ ondé yuku Olivos nátu̱'un sá'a sá'a‑ya̱. Te cha̱a káskuá'a jíín‑yá, suni kája'a̱n‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Te nuu̱ ní jaa̱‑ya̱ yúan, te ni̱ kachi̱‑ya̱ jíín‑de: Kaka̱n ta'u̱ jíná'an‑ró náva̱'a tú koto nchaa̱‑i róó, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Te ni̱ kuxio‑ya̱ núu̱‑dé kua'a̱n‑ya̱ nátu̱'un ɨɨn nuu̱ skánda yuu̱. Te ni̱ jukuiñi̱ jítɨ́‑yá. Te ni̱ jika̱n ta'u̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Táa̱, nú játa'a̱n ini̱‑ní te chaxio‑ní tu̱ndó'o‑ná yá'a ná kí'i̱n, ko nasu̱ já kuní máá‑ná, chi ja̱ kuní máá‑ní ná kúu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Te ni̱ kenda ɨɨn ndajá'a̱ ándɨ́vɨ́ ní jaa̱ nuu̱‑yá. Te ni̱ ka'a̱n ɨɨn tu̱'un ndéé iní jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Te ni̱ ndukuí'a̱ xaa̱n iní‑ya̱. Te ni̱ ndúkú ndéé téyíí‑ga̱‑ya̱ ní jika̱n ta'u̱‑yá. Te ni̱ kana tañi̱‑yá ja̱ ní to̱o onde̱ nuu̱ ñú'un nátu̱'un yúyú ná'nu nɨñi̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Te nuu̱ ní ndukuiñi̱‑ya̱ já ní ndɨ'ɨ ni̱ jika̱n ta'u̱‑yá, te ni̱ najaa̱‑ya̱ núu̱ cháa káskuá'a jíín‑yá. Te ni̱ jini̱‑ya̱ já kákixi̱‑de, chi̱ kándukuí'a̱ ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Te ni̱ kachi̱‑ya̱ jíín‑de: Naja̱ kákixi̱‑ro̱. Nduko̱o, te kaka̱n ta'u̱‑ro̱ náva̱'a tú koto nchaa̱‑i róó, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Te nini sásúan ká'a̱n‑ya̱, te ni̱ ja̱koyo kua'a̱ ñáyɨvɨ. Te ɨɨn cha̱a nání Judas, ɨɨn tá'an ja̱ uxí uu̱‑ún, yóxnúú‑de nuu̱ ñáyɨvɨ‑ún ni̱ jaa̱‑de. Te ni̱ kandita‑de nuu̱ Jesús ja̱ tíyú'ú‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de: Judas, tiyú'ú‑ró rúu̱ te súan nastúu‑ró máá Sé'e cha̱a náún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Te cha̱a ká'i̱in jíín Jesús, ni̱ kajini̱‑de ndasa kua̱kuu. Te ni̱ kaka'a̱n‑de jíín‑yá. Táta̱, stují‑yo̱‑dé jíín machete xí túu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Te ɨɨn máá cháa‑ún, ni̱ stují‑ní‑de ɨɨn mozo máá sutú ñá'nu‑ga̱. Te ni̱ kachi‑de so̱'o lado vá'a. ");
INSERT INTO migNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yúan‑na te ni̱ ka'a̱n Jesús: Sía̱, áchí‑ya̱. Te ni̱ ké'é‑yá so̱'o mozo‑ún, te ni̱ nasáva̱'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Te ni̱ ka'a̱n Jesús jíín sutú ñá'nu‑ún jíín cháa kákuu jefe ini̱ ve̱'e ii̱ jíín cháa ni̱ ka̱yii, ja̱ ní cha̱koyo‑de sɨkɨ̱‑yá: Nátu̱'un sɨkɨ̱ ɨ́ɨn cha̱a kuí'ná vái koyo‑ró jíín machete jíín yúnu náún. ");
INSERT INTO migNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ndɨta'a̱n kɨvɨ̱ ní ka̱ndee‑ri̱ jíín‑ró iní ve̱'e ii̱ te tú ní kákatɨɨn‑ró rúu̱. Ko ya̱'á kúu hora máá‑ró jíín fuerza ñu̱ñáa. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Te ni̱ ka̱katɨɨn‑de‑ya̱ kuá'a̱n‑de jíín‑yá. Te ni̱ kaskɨ́vɨ‑de‑ya̱ iní ve̱'e sutu̱ ñá'nu‑ga̱. Te Pedro, jíká‑ni ndikín‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Te sava ña̱yɨvɨ, ni̱ ka̱nastá'a̱n‑i ɨɨn ñu'u̱n yata̱ vé'e‑ún. Te ni̱ ka̱nakuíkó ndúu̱‑i káxiu̱kú‑i. Te Pedro, suni ni̱ jungo̱o‑de jíín ñáyɨvɨ‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Te ɨɨn ña'an játíñu ini̱ ve̱'e‑ún, ni̱ jini̱‑ña núu̱‑dé ja̱ kánchaa̱‑de yuñú'u̱n yúan. Te ni̱ nde̱'é vá'a‑ña núu̱‑dé. Te ni̱ ka'a̱n‑ña: Te cha̱a yá'a, suni jíka‑de jíín cháa‑ún vii, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yúan‑na te máá‑de, tú ní játu̱'un‑de: Nána̱, na̱ tú jiní‑ná cha̱a‑ún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Te ni̱ kunúu ɨɨn tí'lí‑ga̱. Te ni̱ jini̱ tuku ɨnga̱‑de nuu̱ Pedro te ni̱ ka'a̱n‑de: Te róó, suni tá'an‑de kúu‑ró vii, áchí. Te ni̱ ka'a̱n Pedro: Hombre, nasu̱ú kúu‑ri̱, achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Te nátu̱'un ɨɨn hora‑ga̱ te ni̱ kachi̱ ɨnga̱‑de: Ja̱ndáa̱ ja̱ cháa yá'a, suni jíka‑de jíín cháa‑ún, chi cha̱a ñuu̱ Galilea kúu‑de, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Te ni̱ ka'a̱n Pedro: Hombre, tú jiní kutɨ‑rí na̱ún tu̱'un ká'a̱n‑ro̱, áchí‑de. Te nini súan ká'a̱n‑de, te ni̱ kana‑ni lí'li. ");
INSERT INTO migNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yúan‑na te ni̱ xíó kóto máá Jíto'o̱‑yo̱. Te ni̱ nde̱'é‑yá nuu̱ Pedro. Te ni̱ nuku̱'un ini̱‑de tu̱'un ni̱ ka'a̱n máá Jíto'o̱‑yo̱ jíín‑de: Onde̱ ná té kana‑ga̱ lí'li, te ma̱ kuátu̱'un‑ró rúu̱ uni̱ jínu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Te ni̱ kenda Pedro kua'a̱n‑de. Te ni̱ nde'e̱ xaa̱n‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Te ta̱ká cha̱a kándi̱to Jesús, ni̱ ka̱sákátá‑de nuu̱‑yá. Te ni̱ ka̱stují‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Te ni̱ kajasu̱‑de nuu̱‑yá. Te ni̱ ka̱stují‑dé nuu̱‑yá. Te ni̱ kajika̱ tu̱'ún‑de‑ya̱: Kastu̱'ún, ndé cha̱a ni̱ stují róó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Te íó kua'a̱‑gá tu̱'un ni̱ kaka'a̱n‑de sɨkɨ̱‑yá ja̱ ní ka̱sá'a ndɨva̱'a‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Te nuu̱ ní kundiji̱n, te ni̱ ka̱nataka̱ cha̱a ni̱ ka̱yii, jíín sutú ñá'nu jíín cháa káchaa tutu̱, ni̱ kaja̱ncha̱ka‑de‑ya̱ núu̱ junta máá‑de. ");
INSERT INTO migNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Te ni̱ kaka'a̱n‑de: Máá‑ró kúu máá Cristo, náún. Kachi̱ nuu̱‑rí, áchí‑de. Te ni̱ kachi̱‑ya̱ jíín‑de: Va̱sa ná kachí‑ri̱ nuu̱‑ro̱, te ni ma̱ kándíja kutɨ‑ro. ");
INSERT INTO migNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Te suni nú ruu̱ xndichí‑ri̱ róó, te ma̱ xndíó káni‑ró tú'un nuu̱‑rí. Te ni ma̱ sía̱‑ro̱ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ko onde̱ vina te máá Sé'e cha̱a kunchaa̱‑ya̱ íchi ndává'a nuu̱ íó fuerza Dios, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Te ndɨ'ɨ‑de, ni̱ kajika̱ tu̱'ún‑de‑ya̱: Núsáá te máá‑ró kúu Se̱'e Dios náún, áchí‑de. Te ni̱ kachi̱‑ya̱ jíín‑de: Máá‑ró káka'a̱n ja̱ rúu̱ kúu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yúan‑na te ni̱ kaka'a̱n‑de: Na̱ún nɨ́nɨ kúni so̱'o‑ga̱‑yo̱ ká'a̱n ɨnga̱ cha̱a núsáá, chi̱ jíín yú'u máá‑de ni̱ ka̱jini so̱'o‑yó vína, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yúan‑na te ni̱ ka̱ndonda ndɨ'ɨ‑de ni̱ kaja̱nchaka‑de‑ya̱ núu̱ Pilato. ");
INSERT INTO migNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Te ni̱ kejá'á‑de kásátú'ún‑de sɨkɨ̱‑yá: Cha̱a yá'a ni̱ kani'i̱n‑ná‑de ja̱ sáká núu‑de xini̱ ñáyɨvɨ ñúu̱‑yo̱. Te tú já'a‑de tu̱'un kua̱'a‑yó xú'ún yóo̱ nuu̱ César. Te ká'a̱n‑de ja̱ máá‑de kúu Cristo Rey, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yúan‑na te Pilato, ni̱ jika̱ tu̱'ún‑de‑ya̱: Máá‑ró kúu Rey ña̱yɨvɨ judío náún, áchí‑de. Te máá‑yá ni̱ ka'a̱n‑ya̱: Ká'a̱n ndaa̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Te ni̱ kachi̱ Pilato jíín táká sutu̱ ñá'nu jíín ñáyɨvɨ kuá'a̱‑ún: Tú ni ɨɨn kua̱chi ní'i̱n‑rí sɨkɨ̱ cháa yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ko máá cháa‑ún, ví'í‑gá ni̱ kaka'a̱n‑de: Xaa̱n kúvaa̱ ña̱yɨvɨ sá'a‑de jíín tú'un stá'a̱n‑de nɨ́ɨ́ ñúu̱ Judea, ni̱ kejá'á‑de onde̱ ñuu̱ Galilea te ni̱ kenda‑de onde̱ yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Yúan‑na te Pilato, ja̱ ní jini so̱'o‑de ja̱ Galilea káka'a̱n, te ni̱ jika̱ tu̱'ún‑de nú cha̱a ñuu̱ Galilea kúu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Te nuu̱ ní juku̱'un ini̱‑de ja̱ ndá'a Herodes yí'i ñuu̱‑ya̱, te ni̱ tájí‑de‑ya̱ kuá'a̱n‑ya̱ núu̱ Herodes chi̱ kɨvɨ̱‑ún suni kándee Herodes ini̱ ñuu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Te nuu̱ ní jini̱ Herodes nuu̱ Jesús, ni̱ kusɨɨ̱ xáa̱n iní‑de, chi̱ íó kua'a̱ kɨvɨ́ kuní‑de nde̱'é‑de nuu̱‑yá, chi ni̱ jini tu̱'un‑de kua'a̱ tú'un sɨkɨ̱‑yá. Te ñúkuu ini̱‑de ja̱ sá'a‑ya̱ ɨ́ɨn tuni̱ nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Te xaa̱n ní xndichí‑de‑ya̱. Ko tú ni ɨɨn tu̱'un ní xndíó káni‑ya̱ núu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Te ta̱ká sutu̱ ñá'nu jíín táká cha̱a káchaa tutu̱, ká'i̱in‑de yúan, kásátú'ún téyíí‑ga̱‑de sɨkɨ̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yúan‑na te Herodes jíín soldado‑de, ni̱ kasándɨva̱'a‑de jíín‑yá. Te ni̱ ka̱sákátá‑de nuu̱‑yá. Te ni̱ chu'un‑de‑ya̱ ɨ́ɨn sa'ma tɨ́ndu̱'á. Te ni̱ na̱tájí tuku‑de‑ya̱ kuáno'on‑yá nuu̱ Pilato. ");
INSERT INTO migNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Te suni máá kɨvɨ́‑ún, ni̱ ka̱nakuni̱ mani̱ tá'an Herodes jíín Pilato, chi̱ aná'án chi̱ kájito u'u̱ tá'an‑de núú. ");
INSERT INTO migNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yúan‑na te ni̱ kana Pilato xini̱ táká sutu̱ ñá'nu, jíín táká cha̱a kákuu jefe jíín táká ña̱yɨvɨ. Te ni̱ ka̱ndutútú‑i. ");
INSERT INTO migNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Te ni̱ ka'a̱n‑de jíín‑i: Ni̱ ka̱kinchaka‑ró cháa yá'a nuu̱‑rí, ja̱ sáká núu‑de xini̱ ñáyɨvɨ, áchí‑ro̱. Te vina a ni̱ xndichí‑ri̱‑de jíto nuu̱ máá‑ró. Te tú ni ɨɨn kua̱chi ní ní'i̱n‑rí sɨkɨ̱‑dé nátu̱'un kásátú'ún‑ró, ");
INSERT INTO migNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","te ni Herodes, chi ni̱ tájí‑rí‑de ni̱ ja'a̱n‑de yúan. Te tú ni ɨɨn kua̱chi ní sá'a‑de ja̱ ká'ni‑yo‑dé. ");
INSERT INTO migNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Núsáá te ná xndó'o‑ri̱‑de te sía̱‑ri̱‑de ki'i̱n‑de. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Chi̱ ndɨta'a̱n viko‑ún kánúú já sía̱‑de ɨɨn preso. ");
INSERT INTO migNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ko ta̱ká ña̱yɨvɨ kuá'a̱‑ún, ɨɨn núú‑ni ni̱ ka̱kana jaa‑i: Ka'ni‑ní cha̱a yá'a. Te sía̱‑ní Barrabás ná kí'i̱n‑de, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Te Barrabás, kándee‑de veka̱a kua̱chi ja̱ ní xndónda‑de‑i ni̱ ka̱nakua̱tá'an máá‑i, te ni̱ ja'ni‑dé ɨɨn ndɨ̱yi. ");
INSERT INTO migNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Te ni̱ ka'a̱n tuku Pilato jíín‑i, chi̱ sía̱‑de Jesús kuní‑de núú. ");
INSERT INTO migNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ko máá‑i ni̱ kakana jaa tuku‑i: Ka'ni‑ní‑de jika̱ cruz, kata kaa‑ní‑de, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Te ni̱ ka'a̱n tuku‑de jíín‑i vuelta uni̱: Te na̱ún kua̱chi ni̱ sá'a cha̱a yá'a vii. Tú ní'i̱n kútɨ‑rí ni ɨɨn kua̱chi sɨkɨ̱‑dé ja̱ kúu̱‑de. Núsáá te xndó'o‑ri̱‑de, te sía̱‑ri̱‑de ki'i̱n‑de. Achí Pilato. ");
INSERT INTO migNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ko ɨɨn jínu‑ni ni̱ ka̱kana jaa ña̱yɨvɨ‑ún, ni̱ kajika̱n‑i ja̱ ná kúu̱‑ya̱ jiká cruz. Te máá‑i jíín táká sutu̱ ñá'nu, ni̱ ka̱kana jaa téyíí‑i. Te yu̱án ní kundéé‑i jíín Pilato. ");
INSERT INTO migNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yúan‑na te Pilato, ni̱ sándaa̱‑de ja̱ ná kúu ja̱ ní kajika̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Te ni̱ sía̱ Pilato cha̱a ni̱ ka̱ndee veka̱a sɨkɨ̱ já ní xndónda‑de‑i ni̱ ka̱nakua̱tá'an máá‑i te ni̱ ja'ni‑dé ndɨ̱yi. Chi̱ súan ni̱ kajika̱n ña̱yɨvɨ‑ún. Te ni̱ nakua̱'a‑de Jesús nuu̱‑í ja̱ ná sá'a‑i ndasa kákuu ini̱ máá‑i jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Te ni̱ ka̱kiñi'in‑i‑ya̱. Te ni̱ ka̱katɨɨn‑i ɨɨn cha̱a nání Simón ñuu̱ Cirene ja̱ vái‑de ichi rancho. Te ni̱ ka̱chaa‑i cruz sɨkɨ̱‑dé. Te ndíso‑de kua'a̱n‑de yata̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Te kua'a̱ ñáyɨvɨ jíín ñá'an, ni̱ kandiki̱n‑i yata̱‑yá. Te ña'an‑ún, kánde'e̱‑ña te kákana jíkó'ó‑ña já'a̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ko máá Jesús, ni̱ xíó kóto‑ya̱ núu̱‑ñá. Te ni̱ ka'a̱n‑ya̱ jíín‑ña: Se̱'e ñuu̱ Jerusalén, ma̱ ndé'e̱‑ro̱ já'a̱‑rí. Nde'e̱ ja'a̱ máá‑ró jíín já'a̱ sé'e‑ró jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Te kuni so̱'o‑ró, chi̱ chaa̱ kɨvɨ̱ já ká'a̱n‑i: Xáán ndatu̱ ña'an numá, jíín já tú ní skáku se̱'e, jíín já tú ní skáxin‑í, achi̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yúan‑na te ka'a̱n ña̱yɨvɨ jíín táká yuku: Ndua̱ sɨkɨ̱‑rí jíná'an‑ri̱. Te suni jíín táká tɨnduu̱: Kasu̱ sɨkɨ̱‑rí jíná'an‑ri̱, achi̱‑i. ");
INSERT INTO migNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chi̱ nú jíín yúnu yí'í kásá'a‑de tiñu yá'a, te ndasa sá'a‑de jíín yúnu íchí núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Te suni ni̱ i̱o uu̱ cha̱a ká'i̱o kua̱chi kája'a̱n‑de jíín‑yá ja̱ kúu̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Te ni̱ ja̱koyo‑i jíín‑yá tɨnduu̱ nání yíkɨ xiní, te yúan ni̱ ka̱jata kaa‑i‑ya̱ jiká cruz. Te suni ni̱ ka̱jata kaa‑i ndendúú cha̱a ká'i̱o kua̱chi‑ún, ɨɨn‑de ichi ndává'a‑ya̱, te ɨnga̱‑de ichi ndávésé‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Te ni̱ ka'a̱n Jesús: Táa̱, sá'a‑ní tu̱ká'nu ini̱‑ní nuu̱‑í, chi̱ tú kájini̱‑i na̱ún kásá'a‑i, áchí‑ya̱. Te ni̱ ka̱ndátá‑i sa'ma‑yá, ni̱ ka̱sá'a‑i ɨɨn apuesto sɨkɨ̱. ");
INSERT INTO migNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Te ña̱yɨvɨ ká'i̱in yúan kánde̱'é‑i nuu̱‑yá. Te cha̱a kákuñá'nu, suni ni̱ ka̱sákátá‑de nuu̱‑yá. Te ni̱ kaka'a̱n‑de: Sava ña̱yɨvɨ á ni̱ kuu ni̱ nama‑de. Ná náma‑de máá‑de, te nú Cristo I'a̱ ni̱ ka̱ji Dios kúu‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Te soldado, suni ni̱ ka̱sákátá‑de nuu̱‑yá. Te ni̱ ka̱kandita‑de nuu̱‑yá. Te kája̱'a‑de vinagre ko'o‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Te ni̱ kaka'a̱n‑de jíín‑yá: Nú máá‑ró kúu rey ña̱yɨvɨ judío, te ná náma‑ró máá‑ró, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Te suni ni̱ i̱o ɨɨn tutu̱ yoso sɨkɨ̱‑yá jíín yú'u griego, jíín latín, jíín hebreo: Ya̱'á kúu Rey ña̱yɨvɨ judío, áchí. ");
INSERT INTO migNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Te ɨɨn máá cháa íó kua̱chi‑ún ja̱ ndíta kaa‑de, ni̱ ka'a̱n ndɨva̱'a‑de jíín‑yá: Nú máá‑ró kúu Cristo, te ná náma‑ró máá‑ró te suni nama‑ró rúu̱ jíná'an‑ri̱ núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ko ɨnga̱‑de, ni̱ ka'a̱n xaa̱n‑dé nuu̱ tá'an‑de: Tú íó ja̱ jíñú'ún‑ró núu̱ Dios náún, chi̱ ɨɨn núú‑ni tá'nu̱ ndatu̱‑ro̱ jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Chi̱ máá‑yó, ja̱ndáa̱ va̱tu‑ni ndó'o‑yó yá'a, chi̱ súan kúta'u̱‑yo̱ táká tiñu ni̱ sá'a‑yó, Ko I'a̱ yá'a, tú ni ɨɨn kua̱chi ní sá'a‑ya̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Te ni̱ ka'a̱n‑de jíín Jesús: Nuku̱'un ini̱‑ní náá nú ni̱ najaa̱‑ní ini̱ ñuu̱ nuu̱ tá'ú‑ní tiñu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ vína te kunchaa̱‑ro̱ jíín‑rí nuu̱ jardín andɨ́vɨ́, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Te nuu̱ ní kuu nátu̱'un ka̱xiuu̱, te ni̱ kuxkɨ́'vɨ̱ nɨ́ɨ́ núu̱ ñú'un onde̱ ka̱'uni̱. ");
INSERT INTO migNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Te ni̱ kutúún ndika̱ndii. Te sa'ma ndíta kaa ini̱ ve̱'e ii̱, ni̱ ndata̱ sáva sava. ");
INSERT INTO migNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yúan‑na te ni̱ ka'a̱n jaa Jesús: Táa̱, ini̱ nda'a‑ní nákua̱'a‑ná añú‑ná, áchí‑ya̱. Te súan ni̱ ka'a̱n‑ya̱, te ni̱ ji'i̱‑ni‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Te cha̱a capitán, nuu̱ ní jini̱‑de ja̱ súan ni̱ kuu, te ni̱ nakana jaa‑de Dios: Ndaa̱ ndija ja̱ cháa yá'a ɨɨn cha̱a ndaa̱ ni̱ kuu‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Te ndivii ñáyɨvɨ ká'i̱in yúan, ni̱ kajini̱‑i ja̱ súan ni̱ kuu. Te ni̱ ka̱naxíó káva‑i kákani‑i ji̱kí jiká‑í kája'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ko ta̱ká cha̱a kájini̱ tá'an jíín‑yá, jíín táká ña'an kándiki̱n‑ña‑yá onde̱ ñuu̱ Galilea, ká'i̱in jíká‑ña kánde̱'é‑ña táká tiñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Te ni̱ i̱o ɨɨn cha̱a nání José, cha̱a vá'a cha̱a ndaa̱ kúu‑de. Te suni ɨɨn cha̱a junta kúu‑de. ");
INSERT INTO migNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ko tú ní játa'a̱n ini̱‑de tu̱'un ni̱ kanda̱tu̱'ún junta‑ún ni tiñu ni̱ ka̱sándaa̱‑ún. Te ñuu̱ Arimatea ini̱ ñuu̱ Judea ncháá‑de. Te ñúkuu ini̱‑de koo ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Cha̱a yá'a, ni̱ jaa̱‑de nuu̱ Pilato. Te ni̱ jika̱n‑de yikɨ kúñu Jesús. ");
INSERT INTO migNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Te ni̱ janchaa̱‑de‑ya̱. Te ni̱ chisúkun‑dé‑ya̱ jíín ɨ́ɨn sa'ma kuítá. Te ni̱ chindee‑de‑ya̱ iní ve̱'e añú ja̱ ní jacha jika̱ ɨ́ɨn kava nuu̱ tú kundu̱ji‑ga̱ ni ɨɨn ndɨyi. ");
INSERT INTO migNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Te kɨvɨ̱ xía̱n‑ún koo viko Pascua. Te a yani kundiji̱n kɨvɨ̱ ndéta̱tú. ");
INSERT INTO migNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Te ña'an ní kikoyo jíín‑yá onde̱ ñuu̱ Galilea, káindiki̱n‑ña̱ José kua'a̱n‑ña jíín‑de. Te ni̱ kajini̱‑ña yaú kava‑ún nuu̱ ní yu̱ji yikɨ kúñu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Te ni̱ ka̱naxíó káva‑ña káno'o̱n‑ña. Te ni̱ ka̱sátu̱'a‑ña jí'o jíín perfume, te ni̱ kandéta̱tú‑ña kɨvɨ́ ndéta̱tú‑ún, nátu̱'un ni̱ tá'ú tíñu ley. ");
INSERT INTO migNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Te tɨ́kuáán‑na̱ kɨvɨ̱ ɨ́ɨn semana ni̱ ja̱koyo‑ña yaú kava‑ún, kái̱ndá'á‑ña táká ji̱'o ni̱ kasátu̱'a‑ña. Te suni kája'a̱n sava‑ga̱ ña'an jíín‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Te ni̱ kajini̱‑ña já ní kuxio yuu̱ ndí'u̱ yu'u yaú kava‑ún kua'a̱n. ");
INSERT INTO migNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Te ni̱ kɨ̱vɨ koyo‑ña. Te tú ní kájini̱‑ña yíkɨ kúñu máá Jíto'o̱‑yo̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Te nini kákuñáá ini̱‑ña já súan ni̱ kajini̱‑ña, te uu̱ cha̱a káñu̱'un sa'ma kuíjín kándii ncháa̱, ni̱ ka̱jukuiñi̱‑ni‑de xiin‑ñá. ");
INSERT INTO migNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Te ni̱ kayu̱'ú‑ña. Te ni̱ kaja̱xin‑ña núu̱‑ñá nuu̱ ñú'un. Te ni̱ kaka'a̱n cha̱a‑ún jíín‑ña: Naja̱ sá ma̱'ñú ndɨ́yi kánandúkú‑ró I'a̱ chakú. ");
INSERT INTO migNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Túu‑ya̱ yá'a, chi̱ a ni̱ nachaku̱‑ya̱. Á tú ná'án‑ró ndasa ni̱ ka'a̱n‑ya̱ jíín‑ró ná ni̱ ka̱ndee‑ga̱‑ya̱ ondé ñuu̱ Galilea núú. ");
INSERT INTO migNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Chi ni̱ ka'a̱n‑ya̱: Jínu ñú'ún já máá Sé'e cha̱a natu̱u‑ya̱ núu̱ ndá'a cháa ká'i̱o kua̱chi, te kuu̱‑ya̱ jiká cruz, te nachaku̱‑ya̱ kɨvɨ́ uní. Achí. ");
INSERT INTO migNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yúan‑na te ni̱ kanu̱ku̱'un ini̱‑ña tú'un ni̱ ka'a̱n‑ya̱ jíín‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Te ni̱ kenda‑ña yaú kava‑ún káno'o̱n‑ña. Te ni̱ kaka̱stu̱'ún‑ña tú'un yá'a nuu̱ ndɨ́'uxí ɨɨn‑de jíín táká nuu̱ sáva‑ga̱‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Te ña'an kákastu̱'ún tú'un yá'a nuu̱ apóstol kákuu María ñuu̱ Magdala, jíín Juana, jíín ɨngá María náa̱ Jacobo, jíín sáva‑ga̱‑ña. ");
INSERT INTO migNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ko máá apóstol, kájani ini̱‑de ja̱ tú'un tá'a̱n tachi̱ káka'a̱n‑ña. Te tú ní kákandíja‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Te ni̱ ndukuiñi̱‑ni Pedro. Te ni̱ jinu‑de kua'a̱n‑de onde̱ yau̱ kava‑ún. Te ni̱ jukui̱ta ndee‑de. Te ni̱ jini̱‑de ja̱ sá'ma kuítá‑ún kánda̱a‑na̱ máá. Te ni̱ kee‑de kua̱no'on‑dé ve'e‑de jáni ini̱‑de na̱ún ní kuu. ");
INSERT INTO migNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Te suu kɨvɨ̱‑ún, te kája'a̱n uu̱‑de ichi ɨ́ɨn ñuu̱ nání Emaús ja̱ ncháá nátu̱'un uxi̱ kilómetro yósáva jíín ñúu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Te kándatu̱'ún máá‑de ta̱ká tiñu yá'a ja̱ ní kuu‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Te nini kándatu̱'ún‑de te kájika̱ tu̱'ún tá'an máá‑de. Te máá Jesús, ni̱ jaa̱‑ya̱ yatá‑dé. Te kájika ta̱í‑ya̱ kuá'a̱n‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ko nátu̱'un ndasú nduchi‑dé náva̱'a ma̱ nákuni̱‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Na̱ún tu̱'un kándatu̱'ún‑ró yá'a nini kájika‑ró. Te naja̱ kándukuí'a̱ ini̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Te ɨɨn‑de ja̱ nání‑de Cleofas, ni̱ ka'a̱n‑de jíín‑yá: Á sá ní chaa̱‑ní ini̱ ñuu̱ Jerusalén, te máá ɨ́ɨn‑ni níí tú jiní‑ní ta̱ká tiñu ja̱ ní kuu ini̱ ñuu̱‑ún kɨvɨ̱ yá'a náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Te ni̱ jika̱ tu̱'ún‑yá‑de: Te na̱ún ní i̱o, áchí‑ya̱. Te máá‑de ni̱ kaka'a̱n‑de jíín‑yá: Aa̱, ja̱ ní ta'a̱n Jesús ñuu̱ Nazaret, cha̱a ni̱ jani tu̱'un Dios te ni̱ sá'a‑de tiñu ñá'nu. Te jíín fuerza ni̱ jani‑de tu̱'un jíto nuu̱ Dios jíín núu̱ táká ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Te sutu̱ ñá'nu jíín cháa kákuñá'nu nuu̱‑yo̱, ni̱ ka̱nastúu yu̱án‑de. Te ni̱ ka̱naku̱xndíi sɨkɨ̱‑dé ja̱ ná kúu̱‑de. Te ni̱ ka̱ja'ni‑ún‑de jika̱ cruz. ");
INSERT INTO migNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ko máá‑ná jíná'an‑ná, ni̱ ka̱ñukuu iní‑ná ja̱ máá‑de kúu cha̱a ja̱ náma ñuu̱ Israel núú. Te ni̱ ndɨ'ɨ ta̱ká tiñu yá'a, te vina ni̱ kuu uni̱ kɨvɨ̱ já ní kuu ta̱ká tiñu‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ko sava ñasɨ́'ɨ́ íó jíín‑ná jíná'an‑ná, suni ni̱ ka̱síyú'ú‑ña‑ná, chi ja̱ñá'a̱n xaa̱n ní ja̱ngoyo‑ña yaú kava‑ún. ");
INSERT INTO migNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Te tú ní kánani'i̱n‑ñá yikɨ kúñu‑de. Te ni̱ cha̱koyo‑ña te áchí‑ña já ní kajini̱‑ña já ní kenda koyo ndajá'a̱ ándɨ́vɨ́ núu̱‑ñá. Te ni̱ kaka'a̱n ndajá'a̱‑ún jíín‑ña já chakú‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Te ni̱ kaja'a̱n sava tá'an‑ná onde̱ yau̱ kava‑ún. Te ni̱ kajini̱‑de nátu̱'un ni̱ kaka'a̱n ña'an‑ún. Ko tú ní kájini̱ kutɨ‑dé nuu̱ máá cháa‑ún. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín‑de: Cha̱a xíní ñáá kákuu‑ró. Xaa̱n úun ini̱ añú‑ro̱ já kándíja‑ró táká tu̱'un ni̱ kaka'a̱n cha̱a ni̱ ka̱jani tu̱'un Dios. ");
INSERT INTO migNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Á tú kánúú já ndó'o Cristo tu̱ndó'o yá'a te vásá ndɨ́vɨ‑ya̱ núu̱ ndúñá'nu‑ya̱ náún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Te ni̱ kejá'á‑yá onde̱ tu̱'un Moisés jíín tú'un cha̱a ni̱ ka̱jani tu̱'un Dios, te ni̱ jani kájí‑yá ta̱ká tu̱'un tutu̱ ii̱ núu̱‑dé ja̱ ká'a̱n tu̱'un máá‑yá. ");
INSERT INTO migNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Te ni̱ ka̱kuyani‑de rancho nuu̱ kája'a̱n‑de‑ún. Te máá‑yá ni̱ sá'a‑ya̱ nátu̱'un ki'i̱n jíká‑ga̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ko máá‑de ni̱ ka̱stétuu‑de‑ya̱, ni̱ kaka'a̱n‑de jíín‑yá: Kendo̱o‑ní jíín‑ná, chi̱ a kua̱'ini te kua̱kuxkɨ́'vɨ̱, áchí‑de. Yúan‑na te ni̱ kɨ̱vɨ‑ya̱ já kéndo̱o‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Te nuu̱ ní ka̱jungo̱o‑de ja̱ kée‑dé staa̱, te ni̱ ki'in‑ya̱ stáa̱‑ún, te ni̱ jika̱n ta'u̱‑yá. Te ni̱ ja'ncha̱ sava‑ya̱. Te ni̱ ja̱'a‑ya̱ núu̱‑dé jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yúan‑na te nátu̱'un ni̱ ka̱nanuña nduchi‑dé. Te ni̱ ka̱nakuni̱‑de‑ya̱. Ko ii̱‑ní ni̱ kuxio‑ni‑ya̱ kuá'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Yúan‑na te ni̱ kaka'a̱n máá‑de: Ja̱ndáa̱ ja̱ ní tá'u'u̱ ini̱ añú‑yo̱ ja̱ níni jáni‑ya̱ tú'un nuu̱‑yo̱ íchi‑ún nuu̱ ní juña‑ya̱ tutú ii̱ núu̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Te suni hora‑ún ni̱ ka̱ndukuiñi̱‑de. Te kua̱no'on‑dé ichi ñúu̱ Jerusalén. Te yúan ni̱ ka̱naketá'an‑de jíín uxí ɨɨn‑ga̱ cha̱a‑ún ká'i̱in tútú‑de jíín sáva‑ga̱ tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Te ni̱ kaka'a̱n‑de: Ja̱ndáa̱ ja̱kútɨ a ni̱ nachaku̱ máá Jíto'o̱‑yo̱. Te a ni̱ ndenda ndiji̱n‑ya̱ núu̱ Simón. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yúan‑na te ndendúú cha̱a‑ún, ni̱ kaka̱stu̱'ún‑de ndasa ni̱ ka̱ketá'an‑de jíín‑yá ichi‑ún. Te ndasa ni̱ ka̱nakuni̱‑de nuu̱‑yá nuu̱ ní ja'ncha̱ sava‑ya̱ stáa̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Te nini kándatu̱'ún‑de tu̱'un yá'a, te ni̱ jukuiñi̱‑ni máá‑yá sava ma̱'ñú‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ma̱ kúkuí'a̱ ini̱‑ro̱ jíná'an‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ko máá‑de, ni̱ kayu̱'ú‑de. Te ni̱ ka̱ndakoto i̱o‑de. Te kájani ini̱‑de ja̱ ɨ́ɨn añú kúu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ko máá‑yá ni̱ kachi̱‑ya̱ jíín‑de: Naja̱ káyu̱'ú‑ro̱. Naja̱ súan kájani ini̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nde̱'é ndá'a‑rí jíín já'a̱‑rí, te kuni̱‑ro̱ já máá‑rí kúu. Tɨɨn ruu̱ te kuni̱‑ro̱, chi̱ ɨɨn añú tú ñáva̱'a ku̱ñu ni yikɨ nátu̱'un kánde̱'é‑ró já ñáva̱'a máá‑rí. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Te ni̱ kuu ni̱ ka'a̱n‑ya̱ tú'un yá'a. Te ni̱ stá'a̱n‑ya̱ ndá'a‑yá ja'a̱‑yá nuu̱‑dé jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Te va̱sa kákusɨɨ̱ xáa̱n iní‑de, ko tú ní kákandíja va̱'a‑de. Te yu̱án ní ka'a̱n‑ya̱ jíín‑de: Ió ja̱ kée‑rí yá'a xí túu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yúan‑na te ni̱ kaja̱'a‑de ɨɨn ti̱yáká táú núu̱‑yá, jíín ɨ́ɨn yoko̱ ja̱ ñú'un ndu̱xi. ");
INSERT INTO migNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Te ni̱ ki'in‑ya̱ ní yee‑yá nuu̱‑dé jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ya̱'á kúu ta̱ká tu̱'un ni̱ ka'a̱n‑ri̱ jíín‑ró ná ni̱ kanchaa̱‑ri̱ jíín‑ró sáá, ja̱ kánúú skíkuu ta̱ká tu̱'un‑ri̱ ja̱ yóso núu̱ tutú ley Moisés, jíín núu̱ tutú cha̱a ni̱ ka̱jani tu̱'un Dios jíín núu̱ tutú Salmo. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Te ni̱ juña‑ya̱ já jiní tuní‑de jíná'an‑de, náva̱'a kuu juku̱'un ini̱‑de tu̱'un ká'a̱n tutu̱ ii̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Te ni̱ kachi̱‑ya̱ jíín‑de: Súan yóso núu̱ tutú ja̱ ndó'o Cristo, te nuu̱ uní kɨvɨ̱ te nachaku̱‑ya̱ má'ñú ndɨ́yi. ");
INSERT INTO migNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Te jíín sɨ́'vɨ́‑yá ná kuichá tu̱'un nuu̱ táká ña̱yɨvɨ já ná nákani ini̱‑i, náva̱'a koo tu̱ká'nu ini̱‑ya̱ núu̱ táká kua̱chi‑i. Te kejá'á tú'un yá'a onde̱ ñuu̱ Jerusalén ki'i̱n. ");
INSERT INTO migNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Máá‑ró kákuu cha̱a kani ndaa̱ tu̱'un yá'a. ");
INSERT INTO migNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Te vina tájí‑rí ja̱ ní keyu'u Táa̱‑ri̱. Te kii sɨkɨ̱‑ro̱ jíná'an‑ró. Ko kendo̱o‑ró iní ñuu̱ Jerusalén onde̱ ná kú'un‑ró fuerza ja̱ kíi onde̱ andɨ́vɨ́, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yúan‑na te ni̱ kiñi'in‑ya̱‑dé kua'a̱n‑ya̱ jíín‑de onde̱ ñuu̱ Betania. Te yúan ni̱ kañaa‑ya̱ ndá'a‑yá. Te ni̱ jika̱n ta'u̱‑yá ja'a̱‑dé jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Te nini jikán ta'u̱‑yá ja'a̱‑dé, te ni̱ kuxio‑ni‑ya̱ núu̱‑dé, ni̱ ndaa‑ni‑ya̱ kuá'a̱n‑ya̱ ondé andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Te máá‑de, ni̱ ka̱chiñú'ún‑de‑ya̱. Yúan‑na te ni̱ ka̱naxíó káva‑de káno'o̱n‑de ñuu̱ Jerusalén kákusɨɨ̱ xáa̱n iní‑de. ");
INSERT INTO migNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Te nene̱ ni̱ ka'i̱in‑de ini̱ ve̱'e ii̱ kájika̱n ta'u̱‑dé te kánakana jaa‑de Dios. Amén.");
INSERT INTO migNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Onde̱ xnáñúú ní kuu Tu̱'un. Te Tu̱'un‑ún, ni̱ kanchaa̱‑ya̱ jíín Dios. Te máá Tú'un‑ún ni̱ kuu Dios. ");
INSERT INTO migNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Máá‑yá ni̱ kanchaa̱‑ya̱ ondé xnáñúú jíín Dios. ");
INSERT INTO migNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Te onde̱ jíín máá‑yá ni̱ sá'a Dios ta̱ká ndatíñu. Te nú tú ní sá'a máá‑yá, te ma̱ kúva̱'a ni ɨɨn ndatíñu yá'a núú. ");
INSERT INTO migNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Te ini̱ máá‑yá ñú'un vida te yu̱án kúu ɨɨn luz ja̱ stúu̱n nuu̱ táká ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Te máá luz, xndíi ncháa̱ nuu̱ ñúñáa. Te ñu̱ñáa‑ún, tú ní kúndéé ndá'va̱. ");
INSERT INTO migNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Te ni̱ tájí Dios ɨɨn cha̱a nání Juan. ");
INSERT INTO migNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Cha̱a yá'a, ni̱ kii‑de ja̱ káni ndaa̱‑de tu̱'un máá luz, náva̱'a kándíja ta̱ká ña̱yɨvɨ sá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nasu̱ máá‑de ní kúu luz. Ko ni̱ kii‑de náva̱'a kani ndaa̱‑de tu̱'un máá luz. ");
INSERT INTO migNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Máá‑yá kúu luz ndija ja̱ stúu̱n nuu̱ táká ña̱yɨvɨ, te onde̱ sáá ní kii‑ya̱ iní ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Te ni̱ ncha̱a‑ya̱ iní ñu̱yɨ́vɨ, ko va̱sa jíín máá‑yá ni̱ kuva̱'a ñu̱yɨ́vɨ, te tú ní nákuni̱ ña̱yɨvɨ núu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ni̱ kii‑ya̱ núu̱ já xíin máá‑yá, te ña̱yɨvɨ máá‑yá‑ún, tú ní kájatá'ú‑i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ko sava ña̱yɨvɨ, ni̱ ka̱kandíja‑i‑ya̱ jíín sɨ́'vɨ́‑yá, te ni̱ kaja̱tá'ú‑i‑ya̱. Te nuu̱ máá‑i ni̱ ja̱'a‑ya̱ tú'un ja̱ ndúu‑i se̱'e Dios. ");
INSERT INTO migNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Te máá‑i, tú ní kákaku‑i cuenta nɨñi̱, te ni yikɨ kúñu, ni cha̱a, tú ní kásá'a, chi̱ sua máá Dios ni̱ sá'a. ");
INSERT INTO migNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Te máá tú'un‑ún, ni̱ nduu‑ya̱ ɨ́ɨn yikɨ kúñu. Te ni̱ ncha̱a‑ya̱ jíín‑yó. Te ñú'un chítú‑yá jíín tú'un luu, jíín tú'un ndaa̱ Dios. Te ni̱ kajini̱‑yo̱ já lúu ni̱ nduñá'nu‑ya̱. Chi̱ nátu̱'un luu kúñá'nu máá tú'ún‑ni Se̱'e Táa̱‑yo̱ Dios, suni súan‑ni káa máá‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan, ni̱ jani ndaa̱‑de tu̱'un‑ya̱: I'a̱ yá'a kúu ja̱ ní ka'a̱n‑ri̱: I'a̱ ja̱ váji ichi yatá‑rí ñá'nu‑ga̱ kúu‑ya̱ vásá rúu̱, chi̱ onde̱ ná té kaku‑ga̱‑ri̱, te a íó‑ya̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Te ja̱ ñú'un chítú máá‑yá, onde̱ yúan ni̱ kani'i̱n táká‑yo̱, chi̱ bueno ni̱ ja̱'a‑ya̱ tú'un luu ini̱‑ya̱ núu̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés, ni̱ ja̱'a‑de ley nuu̱‑yo̱. Ko Jesucristo, ni̱ ja̱'a‑ya̱ tú'un luu ini̱‑ya̱ jíín tú'un ndaa̱ nuu̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tú ní jiní kutɨ ní ɨɨn ña̱yɨvɨ núu̱ Dios. Ió ɨɨn máá tú'ún‑ni Se̱'e‑ya̱ já kánchaa̱ jíín‑yá, te máá Sé'e‑ya̱‑ún, ni̱ jani‑ya̱ tú'un Dios nuu̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Te judío, ni̱ ka̱tájí‑ún sutú jíín cháa levita ni̱ kikoyo ichi ñúu̱ Jerusalén. Te ni̱ ka̱jika̱ tu̱'ún‑ún Juan: Te róó ndé cha̱a kúu‑ró, áchí. Te ya̱'á kúu tu̱'un ni̱ jani ndaa̱ Juan, ");
INSERT INTO migNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","te tú ní jasú‑de yu'u‑dé. Chi ni̱ ka'a̱n ndaa̱‑de: Nasu̱ú Cristo kúu‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Te ni̱ kajika̱ tu̱'ún‑ún‑de: Núsáá te Elías kúu‑ró náún, áchí. Te ni̱ ka'a̱n Juan: Nasu̱ú rúu̱ kúu, áchí‑de. Te ni̱ kajika̱ tu̱'ún tuku‑ún‑de: Máá cháa jáni tu̱'un Dios kúu‑ró núsáá, áchí. Túu, áchí Juan. ");
INSERT INTO migNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Te ni̱ kaka'a̱n tuku jíín‑de: Te ndé cha̱a kúu‑ró núsáá. Ka'a̱n náva̱'a nakani‑ri̱ tu̱'un nuu̱ cháa ni̱ ka̱tájí rúu̱ va̱i‑ri̱. Ná ká'a̱n máá‑ró ndé cha̱a kúu‑ró víi̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Te ni̱ ka'a̱n Juan: Máá‑rí kúu ɨɨn ndajá'a̱ kána jaa onde̱ nuu̱ ñú'un té'é: Ná sándóó‑ró íchi máá Jíto'o̱‑yo̱, nátu̱'un ni̱ ka'a̱n Isaías, cha̱a ni̱ jani tu̱'un Dios onde̱ sáá. ");
INSERT INTO migNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Te ja̱ ní kikoyo‑ún, fariseo ni̱ ka̱tájí‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Te ni̱ kajika̱ tu̱'ún Juan: Te naja̱ skuánducha‑ro te nú nasu̱ Cristo ni Elías ni máá cháa jáni tu̱'un Dios kúu‑ró núsáá, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Te ni̱ ka'a̱n Juan jíín: Ruu̱, chi̱ jíín ndúcha skuánducha‑rí. Ko ma̱'ñú máá‑ró kánchaa̱ ɨɨn I'a̱ ja̱ tú kájini̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I'a̱ yá'a va̱i ichi yatá‑rí. Te tú kúñá'nu‑ri̱ ndájí‑rí ñii yí'i ndija̱n‑yá, chi̱ ñá'nu‑ga̱ kúu‑ya̱ vásá rúu̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Súan ni̱ i̱o ini̱ ñuu̱ Betábara, onde̱ ɨnga̱ lado Jordán, nuu̱ ní skuánducha Juan. ");
INSERT INTO migNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Te kɨvɨ̱ xía̱n‑ún ni̱ jini̱ Juan nuu̱ Jesús ja̱ vái‑ya̱ núu̱‑dé. Te ni̱ ka'a̱n‑de: Yúan va̱i Lélú Dios, I'a̱ kuánchaa̱ kua̱chi ña̱yɨvɨ ñúyɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","I'a̱ yá'a kúu ja̱ ní ka'a̱n‑ri̱: Ichi yatá‑rí va̱i ɨɨn I'a̱ ñá'nu‑ga̱ kúu vásá rúu̱. Chi̱ onde̱ ná té kaku‑ga̱‑ri̱ te íó‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Te tú ní nákuni̱‑ri̱‑ya̱. Ko náva̱'a kenda ndiji̱n‑ya̱ núu̱ ñáyɨvɨ Israel, yu̱án ní kii‑ri̱ skuánducha‑rí jíín ndúcha. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Te ni̱ jani ndaa̱ Juan tu̱'un: Ni̱ jini̱‑ri̱ Espíritu ja̱ ní kuun ichi ándɨ́vɨ́ nátu̱'un paloma. Te ni̱ jungo̱o sɨkɨ̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Te tú ní nákuni̱‑ri̱‑ya̱, ko máá Dios, I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱ ja̱ skuánducha‑rí jíín ndúcha, máá‑yá ni̱ ka'a̱n jíín‑rí: Nú kuni̱‑ro̱ já kúun Espíritu sɨkɨ̱ ɨ́ɨn cha̱a te jungo̱o sɨkɨ̱‑dé, te máá cháa‑ún kuu I'a̱ skuánducha jíín Espíritu Santo, áchí Dios. ");
INSERT INTO migNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Te a ni̱ jini̱‑ri̱‑ya̱. Te jáni ndaa̱‑ri̱ tu̱'un ja̱ I'a̱ yá'a kúu máá Sé'e Dios, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Te kɨvɨ̱ xía̱n‑ún kánchaa̱ tuku Juan jíín úu̱ cha̱a skuá'a jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Te ni̱ jini̱‑de nuu̱ Jesús ja̱ jíka kuu‑ya̱ yúan. Te ni̱ ka'a̱n‑de: Yúan nde̱'é‑ró máá Lélú Dios, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Te ndendúú cha̱a skuá'a‑ún, ni̱ ka̱jini so̱'o‑de tu̱'un ni̱ ka'a̱n Juan. Te ni̱ ka̱indiki̱n‑de Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Te ni̱ xíó kóto Jesús. Te ni̱ jini̱‑ya̱ já káindiki̱n‑de yata̱‑yá. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Na̱ún kánandúkú‑ró, áchí‑ya̱. Te ni̱ kaka'a̱n‑de jíín‑yá: Rabí (ja̱ kuní ka'a̱n: Maestro), ndénu̱ ncháá‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ña'a̱n te kuni̱‑ro̱, áchí‑ya̱. Te ni̱ ja̱koyo‑de te ni̱ kajini̱‑de nuu̱ ncháá‑ya̱. Te ni̱ ka̱kendo̱o‑de jíín‑yá kɨvɨ̱‑ún, chi̱ a íó nátu̱'un ka̱kuu̱n áíni. ");
INSERT INTO migNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Te ndendúú cha̱a‑ún, ni̱ ka̱jini so̱'o‑de tu̱'un ni̱ ka'a̱n Juan. Te ni̱ ka̱indiki̱n‑de‑ya̱. Te ɨɨn‑de kúu Andrés, ñani̱ Simón Pedro kúu‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Cha̱a yá'a, ni̱ nani'i̱n‑ní‑de ñani̱‑de Simón. Te ni̱ ka'a̱n‑de jíín: Ni̱ ka̱ketá'an‑ri̱ jíín Mesías (ja̱ kuní ka'a̱n: Cristo), áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Te ncháka‑de cha̱a ni̱ chaa̱‑de jíín núu̱ Jesús. Te ni̱ nde̱'é Jesús nuu̱‑dé. Te ni̱ ka'a̱n‑ya̱: Máá‑ró kúu Simón, se̱'e Jonás. Vina te kunání‑ró Cefas (ja̱ kuní ka'a̱n: ɨɨn kava). Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Te ɨnga̱ kɨvɨ̱ xía̱n‑ún kuní Jesús ki'i̱n‑ya̱ ñúu̱ Galilea. Te ni̱ ni'i̱n tá'an‑ya̱ jíín Felipe. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kundiki̱n‑ro̱ rúu̱ ki'o̱n, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Te Felipe kúu cha̱a ñuu̱ Betsaida, ñuu̱ Andrés jíín Pedro. ");
INSERT INTO migNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Te ni̱ ni'i̱n tá'an Felipe jíín Natanael. Te ni̱ ka'a̱n‑de jíín: A ni̱ ka̱ketá'an‑ri̱ jíín Jesús ñuu̱ Nazaret. Se̱'e José kúu‑ya̱. Te máá‑yá kúu I'a̱ yóso tú'un‑ya̱ núu̱ tutú ley Moisés jíín núu̱ tutú ni̱ ka̱chaa cha̱a ni̱ ka̱jani tu̱'un Dios onde̱ sáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Te ni̱ ka'a̱n Natanael jíín‑de: Á íó ja̱ vá'a onde̱ ini̱ ñuu̱ Nazaret, áchí‑de. Te ni̱ ka'a̱n Felipe jíín‑de: Ña'a̱n te kuni̱‑ro̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Te ni̱ jini̱ Jesús ja̱ vái Natanael. Te ni̱ ka'a̱n‑ya̱ tú'un‑de: Yá'a va̱i ɨɨn cha̱a Israel ndaa̱, chi̱ tú xndá'ú kutɨ‑dé, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Te ni̱ ka'a̱n Natanael jíín‑yá: Ndasa jiní‑ní náá, áchí‑de. Te ni̱ ka'a̱n Jesús: Ni̱ jini̱‑ri̱ róó onde̱ ná té kana‑ga̱ Felipe xini̱‑ro̱, ná ni̱ ka̱ndee‑ró chíi yunu mérkexe̱, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Te ni̱ ka'a̱n Natanael: Maestro, máá‑ní kúu Se̱'e Dios, máá‑ní kúu Rey nuu̱ ñáyɨvɨ Israel, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Te ni̱ ka'a̱n Jesús: Ni̱ ka'a̱n‑ri̱ jíín‑ró já ní jini̱‑ri̱ róó chi̱i yunu mérkexe̱. Ja̱ yúán kándíja‑ró náún. Tiñu ñá'nu‑ga̱ kuni̱‑ro̱ vásá yá'á, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Te ni̱ ka'a̱n‑ga̱‑ya̱ jíín‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Vina te kuni̱‑ro̱ já núña andɨ́vɨ́, te ndajá'a̱ Dios, kándaa kánuu sɨkɨ̱ máá Sé'e cha̱a, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Te kɨvɨ̱ uní ni̱ kuu ɨɨn viko tánda'a iní ñuu̱ Caná ndañúu̱ Galilea. Te yúan kánchaa̱ náa̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Te suni ni̱ ka̱kana‑i xini̱ Jesús jíín cháa káskuá'a jíín‑yá, ni̱ kaja'a̱n‑ya̱ víko‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Te a ni̱ ndɨ'ɨ vino. Te náa̱ Jesús ni̱ ka'a̱n‑ña jíín‑yá: Tú kutɨ‑gá vino káñava̱'a‑i, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Te ni̱ ka'a̱n Jesús jíín‑ña: Nána̱, naja̱ stétuu‑ní‑ná, chi̱ té jaa̱‑ga̱ hora‑ná, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Te ni̱ ka'a̱n náa̱‑ya̱ jíín súchí kájatíñu‑ún: Sá'a ndéja̱ ká'a̱n‑ya̱ jíín‑ró. Achí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Te yúan íó iñu̱ tinaja yuu̱. Te kuu ku'un uu̱ xí uní kɨ̱yi ja̱ ɨ́ɨn ɨɨn. Chi cha̱a judío, súan ndoo ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Te ni̱ ka'a̱n Jesús jíín‑i: Skútú‑ró tinaja yá'a nducha. Te ni̱ ka̱skútú‑i onde̱ yu'u. ");
INSERT INTO migNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Te ni̱ ka'a̱n‑ya̱ jíín‑i: Vina te tava‑ro te kincha̱ka‑ró núu̱ mayordomo, áchí‑ya̱. Te ni̱ kaja̱ncha̱ka‑i nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Te mayordomo, ni̱ jito nchaa̱‑de nducha já ní nduu vino, te tú ní jiní‑de ndénu̱ ní kii. Ko mozo ni̱ ka̱tava ndúcha‑ún a kájini̱‑i. Yúan‑na te ni̱ kana‑de xini̱ máá yíi. ");
INSERT INTO migNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Te ni̱ ka'a̱n‑de jíín: Ta̱ká cha̱a kája̱'a‑de vino va̱'a xna'a̱n‑ga̱ te nú a ni̱ ka̱ji'i vatu̱ máá‑i, yúan‑na te já'a‑de ja̱ tú íó va̱'a. Ko máá‑ró ni̱ chiva̱'a‑ró vino va̱'a yá'a onde̱ vina. ");
INSERT INTO migNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ya̱'á kúu tuni̱ xnáñúú ní sá'a Jesús ini̱ ñuu̱ Caná ndañúu̱ Galilea. Te ni̱ kajini̱‑i ja̱ lúu ñá'nu‑ya̱. Te cha̱a káskuá'a jíín‑yá, ni̱ ka̱kandíja‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Te ni̱ kuu yu̱án. Te máá‑yá jíín náa̱‑ya̱ jíín ñaní‑ya̱ jíín cháa káskuá'a jíín‑yá, ni̱ ka̱nuu‑ya̱ ñúu̱ Capernaum. Te ni̱ kaxiu̱kú‑yá yúan yaku̱‑ni kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Te ni̱ kuyani viko Pascua ña̱yɨvɨ judío. Te ni̱ kaa Jesús kua'a̱n‑ya̱ ñúu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Te ni̱ jini̱‑ya̱ ñáyɨvɨ káxi̱kó xndɨkɨ̱ jíín rɨ́ɨ̱ jíín paloma, jíín ñáyɨvɨ káxndáji xu̱'ún, káxiu̱kú‑i ini̱ ve̱'e ii̱. ");
INSERT INTO migNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Te ni̱ sá'a‑ya̱ ɨ́ɨn cuarta ñii. Te ni̱ skúnu‑ya̱ táká‑i ini̱ ve̱'e ii̱ onde̱ jíín rɨ́ɨ̱ jíín xndɨkɨ̱‑í. Te ni̱ jacha̱‑ya̱ xú'ún ñáyɨvɨ káxndáji. Te ni̱ skuíó káni‑ya̱ táká mesa‑i. ");
INSERT INTO migNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Te ni̱ ka'a̱n‑ya̱ jíín ñáyɨvɨ káxi̱kó paloma: Chaxio kɨtɨ yá'a. Ve'e Táa̱‑ri̱, ma̱ násá'a‑ró núyá'u. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yúan‑na te cha̱a káskuá'a jíín‑yá, ni̱ ka̱nuku̱'un ini̱‑de tu̱'un yóso núu̱ tutú: Ná kuítú xáa̱n iní‑ri̱ ve'e‑ró, onde kui̱tá‑ri̱ jíín, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Te ni̱ kaka'a̱n cha̱a judío: Na̱ tuni̱ stá'a̱n‑ro̱ núu̱‑rí ja̱ ní sá'a‑ró súan, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Te ni̱ ka'a̱n Jesús: Stúncháa̱‑ro̱ vé'e ii̱ yá'a, te nuu̱ uní‑ni kɨvɨ̱ te ndukani‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yúan‑na te ni̱ kaka'a̱n cha̱a judío: Nuu̱ úu̱ xiko iñu̱ kuia̱ te ni̱ ji̱nu ve'e ii̱ yá'a. Te róó nuu̱ uní‑ni kɨvɨ̱ te ndukani‑ró náún. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ko máá‑yá, chi̱ kuní ka'a̱n‑ya̱ já yíkɨ kúñu‑ya̱ kúu nátu̱'un ve'e ii̱. ");
INSERT INTO migNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ja̱ yúán, nuu̱ ní nachaku̱‑ya̱ já ní ji'i̱‑ya̱, te cha̱a káskuá'a jíín‑yá, ni̱ kanu̱ku̱'un ini̱‑de ja̱ ní ka'a̱n‑ya̱ tú'un yá'a. Te ni̱ ka̱kandíja‑de tutu̱ ii̱ jíín tú'un ni̱ ka'a̱n Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Te máá kɨvɨ́ víko Pascua kánchaa̱‑ya̱ ñúu̱ Jerusalén. Te kua'a̱ ñáyɨvɨ ní ka̱kandíja‑i‑ya̱, chi ni̱ kajini̱‑i ta̱ká tuni̱ ni̱ sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ko Jesús, tú ní játú'ún‑yá‑i, chi̱ a jiní‑ya̱ táká‑i. ");
INSERT INTO migNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Te tú ní jínu ñú'ún‑yá ja̱ ká'a̱n ni ɨɨn cha̱a tu̱'un ña̱yɨvɨ jíín‑yá, chi̱ a jiní‑ya̱ ndasa káa ini̱‑i jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Te ni̱ i̱o ɨɨn tá'an cha̱a fariseo nání‑de Nicodemo. Te kúñá'nu‑de nuu̱ ñáyɨvɨ judío. ");
INSERT INTO migNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cha̱a yá'a ni̱ chaa̱‑de nuu̱ Jesús ɨɨn akuáa. Te ni̱ ka'a̱n‑de jíín‑yá: Maestro, a kájini̱‑ná ja̱ ɨ́ɨn maestro kúu‑ní te va̱i‑ní onde̱ nuu̱ Dios, chi̱ nú tú chindéé chítuu Dios ɨɨn cha̱a, te ma̱ kúu sá'a‑de ta̱ká tuni̱ ja̱ sá'a máá‑ní núú, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Te ni̱ ka'a̱n Jesús: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró ja̱ nú tú nakaku jáá ɨ́ɨn cha̱a, te ma̱ kúu kuni̱‑de ñuu̱ nuu̱ tá'ú Dios tiñu, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Te ni̱ ka'a̱n Nicodemo jíín‑yá: Ndasa kuu nakaku ɨɨn cha̱a nú a ni̱ yii‑de. Á kuu ndɨ̱vɨ‑de chi̱i náa̱‑de te nakaku tuku‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Te ni̱ ka'a̱n tuku Jesús: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, nú tú kaku ɨɨn cha̱a jíín ndúcha jíín Espíritu, te ma̱ kúu kɨ̱vɨ‑de ini̱ ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ja̱ ní kaku cuenta ku̱ñu, ku̱ñu kúu. Te ja̱ ní kaku cuenta Espíritu, se̱'e Espíritu kúu. ");
INSERT INTO migNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ma̱ nánaa iní‑ro̱ tú'un ká'a̱n‑ri̱ jíín‑ró: Jínu ñú'ún já nákaku jáá‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kée tachi̱ ndénu̱ kuní máá, te jíni so̱'o‑ró já káyu, ko tú jiní‑ro̱ ndénu̱ vái ni ndénu̱ kí'i̱n. Súan kúu ta̱ká ña̱yɨvɨ já káku cuenta Espíritu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Te ni̱ ka'a̱n Nicodemo: Ndasa kuu yu̱án núsáá, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Te ni̱ ka'a̱n Jesús: Máá‑ró kúu ɨɨn maestro Israel te tú júku̱'un ini̱‑ro̱ jíín tú'un yá'a náún. ");
INSERT INTO migNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Ká'a̱n‑ri̱ tu̱'un ja̱ júku̱'un ini̱‑ri̱. Te jáni ndaa̱‑ri̱ tu̱'un tiñu ni̱ jini̱‑ri̱. Ko tú játú'ún‑ró tú'un ndaa̱ ká'a̱n‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","A ni̱ ka'a̱n‑ri̱ tu̱'un ñu̱yɨ́vɨ jíín‑ró te tú kándíja‑ró. Ndasa kandíja‑ró nú ka'a̱n‑ri̱ tu̱'un andɨ́vɨ́ jíín‑ró núsáá. ");
INSERT INTO migNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Máá Sé'e cha̱a kánchaa̱‑ya̱ ándɨ́vɨ́. Te ni̱ kuun‑ya̱ íchi ándɨ́vɨ́. Te máá ɨ́ɨn‑ni‑ya̱ ní ndaa‑ya̱ ándɨ́vɨ́, tuká ɨnga̱ cha̱a ní sá'a. ");
INSERT INTO migNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Chi̱ nátu̱'un ni̱ jata kaa Moisés koo̱ núu̱ ñú'un té'é, jínu ñú'ún já súni súan kuita kaa máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Náva̱'a ma̱ náa táká ña̱yɨvɨ kákandíja‑i‑ya̱, chi̱ sua kuchaku̱‑i nɨ́ɨ́ káni, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Chi̱ Dios, xaa̱n ní kundá'ú ini̱‑ya̱ ñáyɨvɨ ñúyɨ́vɨ. Ja̱ yúán ní tájí‑yá Se̱'e‑ya̱ ní kii‑i, va̱sa máá tú'ún‑ni‑i ni̱ i̱o, náva̱'a ma̱ náa táká ña̱yɨvɨ kákandíja‑i‑ya̱, chi̱ sua kuchaku̱‑i nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chi̱ tú ní tájí Dios Se̱'e‑ya̱ núu̱ ñúyɨ́vɨ já tá'nu̱ ndatu̱ ña̱yɨvɨ, chi̱ sua ja̱ ná káku ña̱yɨvɨ sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nú kandíja ɨɨn ña̱yɨvɨ núu̱‑yá, te ma̱ tá'nu̱ ndatu̱‑i. Ko ña̱yɨvɨ tú kándíja, ta'nu̱ ndatu̱ ná'ín‑i, kua̱chi ja̱ tú kándíja‑i nuu̱ máá ɨ́ɨn‑ni Se̱'e Dios. ");
INSERT INTO migNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A ni̱ chaa̱ máá luz ini̱ ñu̱yɨ́vɨ. Ko ña̱yɨvɨ‑ún, ni̱ ka̱kumani̱‑gá‑i jíín ñúñáa vásá jíín luz, chi̱ tiñu kásá'a‑i kákuu tiñu ñáá. Ja̱ yúán te ta'nu̱ ndatu̱ ná'ín‑i. ");
INSERT INTO migNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chi ta̱ká ña̱yɨvɨ já sá'a tiñu ñáá, jíto u'u̱‑i nuu̱ íó luz. Te tú kíi‑i nuu̱ íó luz, náva̱'a tú ndenda ndiji̱n tiñu sá'a‑i. ");
INSERT INTO migNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ko ña̱yɨvɨ já sátiñu ndaa̱, va̱i‑i nuu̱ íó luz, náva̱'a kenda ndiji̱n ja̱ jíín Dios ni̱ sá'a‑i tiñu máá‑i. ");
INSERT INTO migNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yo̱án‑na te Jesús jíín cháa káskuá'a jíín‑yá, kája'a̱n‑ya̱ ñúu̱ Judea. Te yúan ni̱ kanchaa̱‑ya̱ jíín‑de. Te ni̱ skuánducha‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Te suni ni̱ skuánducha Juan ini̱ ñuu̱ Enón yani ñuu̱ Salim, chi ni̱ i̱o kua'a̱ ndúcha yúan. Te ni̱ kikoyo ña̱yɨvɨ núu̱‑dé, te ni̱ skuánducha‑dé‑i. ");
INSERT INTO migNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chi̱ té kɨ̱vɨ‑ga̱ Juan veka̱a. ");
INSERT INTO migNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Te cha̱a káskuá'a jíín Juan, ni̱ ka̱státá'an‑de jíín cháa judío sɨkɨ̱ modo ndoo ini̱. ");
INSERT INTO migNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Te ni̱ cha̱koyo‑de nuu̱ Juan. Te ni̱ kaka'a̱n‑de: Maestro, cha̱a ni̱ kanchaa̱ jíín‑ní ɨnga̱ lado yu̱cha Jordán ja̱ ní ka'a̱n ndaa̱‑ní tu̱'un‑de, vina te skuánducha máá‑de, te ndivii ñáyɨvɨ kája'a̱n‑i nuu̱‑dé, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Te ni̱ ka'a̱n Juan: Ni ɨɨn cha̱a ma̱ ní'i̱n kútɨ‑dé ni ɨɨn modo, te nú tú kii onde̱ andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Máá‑ró ni̱ kajini̱ ndaa̱‑ro̱ já ní ka'a̱n‑ri̱: Nasu̱ rúu̱ kúu Cristo, chi̱ sua ni̱ tájí‑yá ruu̱ yóxnúú‑rí nuu̱‑yá va̱i‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cha̱a ncháka ñasɨ́'ɨ́ kúu yii. Te amigo yii‑ún ká'i̱in xiin‑dé te kájini so̱'o tu̱'un ká'a̱n‑de. Te kákusɨɨ̱ xáa̱n iní‑i, nú a ni̱ ka̱jini so̱'o‑i ká'a̱n yii‑ún. Súan kúu ja̱ kúsɨɨ̱ xáa̱n iní‑ri̱ vina. ");
INSERT INTO migNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jínu ñú'ún já ndúñá'nu‑ga̱ máá‑yá te ndúsúchí‑ga̱ máá‑rí, áchí Juan. ");
INSERT INTO migNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","I'a̱ va̱i onde̱ nuu̱ súkún, ñá'nu‑ga̱ kúu‑ya̱ vásá táká‑i. Te cha̱a ni̱ kaku ini̱ ñu̱yɨ́vɨ yá'a, se̱'e ñu̱yɨ́vɨ kúu‑de. Te tu̱'un ñu̱yɨ́vɨ ká'a̱n‑de. I'a̱ va̱i ichi ándɨ́vɨ́, ñá'nu‑ga̱ kúu‑ya̱ vásá táká cha̱a. ");
INSERT INTO migNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Te jáni ndaa̱‑ya̱ tú'un ja̱ ní jini̱‑ya̱ jíín já ní jini so̱'o‑ya̱. Ko ni ɨɨn ña̱yɨvɨ tú játá'ú‑i tu̱'un ká'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ko ña̱yɨvɨ játá'ú tú'un ndaa̱ ká'a̱n‑ya̱, suni máá‑i ká'a̱n‑ndaa̱‑i ja̱ íó ndaa̱ tu̱'un ká'a̱n Dios. ");
INSERT INTO migNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Chi̱ I'a̱ ni̱ tájí Dios va̱i, tu̱'un Dios ká'a̱n‑ya̱. Chi̱ Dios, tú kuí'a̱‑ni já'a‑ya̱ Espíritu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Máá Táa̱, kúndá'ú ini̱‑ya̱ Sé'e‑ya̱, te ni̱ ja̱'a‑ya̱ táká ndatíñu nda'a Sé'e‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ña̱yɨvɨ já kándíja nuu̱ máá Sé'e‑ya̱, kuchaku̱‑i nɨ́ɨ́ káni. Te ña̱yɨvɨ já tú kándíja nuu̱ Sé'e‑ya̱, ma̱ kúchaku̱‑i chi̱ sua ví'í‑gá kiti̱ ini̱ Dios nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Te cha̱a fariseo, ni̱ ka̱jini tu̱'un‑de tu̱'un Jesús, ja̱ íó kua'a̱‑gá cha̱a káskuá'a jíín máá‑yá vásá jíín Juan jíín já skuánducha‑yá kua'a̱‑gá ña̱yɨvɨ vásá Juan. Te ni̱ jini̱ Jesús tu̱'un‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ko tú ní skuánducha Jesús, chi̱ sua cha̱a káskuá'a jíín‑yá, káskuánducha máá‑de. ");
INSERT INTO migNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Te ni̱ kenda‑ya̱ ñúu̱ Judea. Te kua'a̱n tuku‑ya̱ ñúu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Te jínu ñú'ún já já'a‑ya̱ kí'i̱n‑ya̱ ñúu̱ Samaria. ");
INSERT INTO migNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yúan‑na te ni̱ jaa̱‑ya̱ ɨ́ɨn ñuu̱ nání Sicar ini̱ ñuu̱ Samaria, yani ndu'a̱ Jacob ja̱ ní ja̱'a‑de nuu̱ sé'e‑de José. ");
INSERT INTO migNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Te yúan íó sókó Jacob. Te Jesús, ni̱ jungo̱o‑ya̱ xíin sókó‑ún, chi ni̱ kui̱tá‑ya̱ íchi kuá'a̱n‑ya̱. Te nátu̱'un ka̱xiuu̱ kúu. ");
INSERT INTO migNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Te ni̱ chaa̱ ɨɨn ña'an ñuu̱ Samaria, va̱i tava‑ñá nducha. Te ni̱ ka'a̱n Jesús jíín‑ña: Kua̱'a nducha ná kó'o‑ná. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Chi cha̱a káskuá'a jíín‑yá, a kája'a̱n‑de onde̱ ñuu̱ kuakua̱an‑de ja̱ kée‑dé. ");
INSERT INTO migNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Te ña'an ñúu̱ Samaria, ni̱ ka'a̱n‑ña jíín‑yá: Naja̱ jikán‑ní nducha núu̱‑ná ko'o‑ní, chi cha̱a judío kúu‑ní, te ña'an ñúu̱ Samaria kúu‑ná, áchí‑ña. Chi ña̱yɨvɨ judío, tú kɨ́vɨ nduu̱‑i jíín ñáyɨvɨ ñúu̱ Samaria. ");
INSERT INTO migNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Te ni̱ ka'a̱n Jesús: Nú ní jiní‑ní na̱ún kúu ja̱ kuá'a Dios nuu̱‑ní, te jíín I'a̱ ja̱ ká'a̱n jíín‑ní: Kua̱'a‑ní nducha ná kó'o‑ná, yúan‑na te kaka̱n‑ní nuu̱‑yá te kua̱'a‑ya̱ ndúcha chakú ko'o‑ní núú, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Te ni̱ ka'a̱n ña'an‑ún jíín‑yá: Táta̱, xaa̱n kúnú sókó yá'a te tú na̱ jíín táva‑ní nducha. Núsáá te ndénu̱ ní'i̱n‑ní nducha chakú. ");
INSERT INTO migNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Chi̱ sókó yá'a ni̱ ja̱'a táa̱‑yo̱ Jacob nuu̱‑yo̱. Te yá'a ni̱ ji'i máá‑de nducha, jíín sé'e‑de, jíín kɨ́tɨ‑dé. Te ñá'nu‑ga̱ máá‑ní vásá máá‑de náún. Achí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Te ni̱ ka'a̱n Jesús: Nú ndé cha̱a ko'o nducha yá'a, kuchi̱ tuku‑de. ");
INSERT INTO migNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ko cha̱a ko'o nducha já kuá'a‑ná nuu̱‑dé, ma̱ kuchí kutɨ‑gá‑de, chi̱ nducha já kuá'a‑ná‑ún, koo ɨɨn sókó iní‑de ja̱ kána nducha kúchaku̱‑de nɨ́ɨ́ káni sá'a, áchí‑ya̱ jíín‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Te ni̱ ka'a̱n ña'an‑ún jíín‑yá: Táta̱, kua̱'a‑ní nducha‑ún ko'o‑ná, náva̱'a tuká kuchi̱ kutɨ‑ná, ni tuká kitava‑ná‑cha̱ yá'a, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Te ni̱ ka'a̱n Jesús jíín‑ña: Kuáka̱na‑ní xini̱ yíi‑ní te chaa̱‑ní, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Te ni̱ ka'a̱n ña'an‑ún: Tú yii‑ná íó, áchí‑ña. Te ni̱ ka'a̱n Jesús jíín‑ña: Va̱'a‑ni ká'a̱n‑ní, tú yii‑ná íó, ");
INSERT INTO migNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","chi ni̱ i̱o u'u̱n yii‑ní. Te cha̱a ncháka‑ní vina, nasu̱ yíi máá‑ní kúu‑de. Ya̱'á kúu ja̱ ní ka'a̱n ndaa̱‑ní, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Te ni̱ ka'a̱n ña'an‑ún jíín‑yá: Táta̱, ɨɨn cha̱a jáni tu̱'un Dios kúu‑ní jáni ini̱‑ná. ");
INSERT INTO migNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ndɨ̱yi táa̱‑yo̱, yuku yá'a ni̱ ka̱chiñú'ún‑de Dios. Te máá‑ní káka'a̱n‑ní ja̱ ñúu̱ Jerusalén kúu nuu̱ kánúú chíñú'ún‑yó, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Te ni̱ ka'a̱n Jesús jíín‑ña: Nána̱, ná kándíja‑ní tu̱'un ká'a̱n‑ná chi chaa̱ ɨɨn kɨvɨ̱, ja̱ ní yuku yá'a, ni ñuu̱ Jerusalén, tú chiñú'ún‑ní máá Táa̱‑yo̱ Dios súan. ");
INSERT INTO migNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Níí, tú kájini̱‑ní na̱ún kúu ja̱ káchiñú'ún‑ní. Ko máá‑ná, kájini̱‑ná I'a̱ káchiñú'ún‑ná. Chi̱ onde̱ nuu̱ ñáyɨvɨ judío va̱i tu̱'un nama yóó. ");
INSERT INTO migNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Te chaa̱ ɨɨn kɨvɨ̱ já ñáyɨvɨ káchiñú'ún ndáa̱, chiñú'ún ndíja‑i Táa̱‑yo̱ Dios jíín iní jíín añú‑i. Chi̱ Táa̱‑yo̱, ndúkú‑yá ña̱yɨvɨ já súan chiñú'ún‑i‑ya̱ kuní‑ya̱. Te a ni̱ chaa̱ kɨvɨ̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios kúu Espíritu. Te ña̱yɨvɨ kuní chiñú'ún, kánúú já chíñú'ún ndíja‑i‑ya̱ jíín iní jíín añú‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Te ni̱ ka'a̱n ña'an‑ún jíín‑yá: Jiní‑ná ja̱ kíi Mesías, ja̱ nání Cristo. Te nú ni̱ chaa̱ máá‑yá, te stá'a̱n‑ya̱ táká tu̱'un nuu̱‑yo̱. Achí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Te ni̱ ka'a̱n Jesús jíín‑ña: Máá‑ná kúu I'a̱‑ún ja̱ ká'a̱n‑ná jíín‑ní, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Te nini sá súan ká'a̱n‑ya̱, te ni̱ cha̱koyo cha̱a káskuá'a jíín‑yá. Te ni̱ ka̱naa iní‑de kánde̱'é‑de ja̱ ndátu̱'ún‑yá jíín ɨ́ɨn ña'an. Ko tú ni ɨɨn‑de ní ka'a̱n: Na̱ún jiká tu̱'ún‑ní‑ña, xí: Na̱ún tu̱'un ndátu̱'ún‑ní jíín‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yúan‑na te ña'an‑ún, ni̱ skéndo̱o‑ña kɨ́yi‑ña te kua'a̱n‑ña ondé ñuu̱. Te ni̱ ka'a̱n‑ña jíín ñáyɨvɨ yúan: ");
INSERT INTO migNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Ña'a̱n jíná'an‑ró te kuni̱‑ro̱ ɨ́ɨn cha̱a. Cha̱a‑ún ni̱ kachi̱‑de nuu̱‑rí ta̱ká na̱ún tiñu ni̱ sá'a‑ri̱. Sánaa te máá‑de kúu Cristo, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yúan‑na te ni̱ kenda koyo‑i ñuu̱‑ún. Te ni̱ cha̱koyo‑i nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Te cha̱a káskuá'a jíín‑yá, ni̱ ka̱stétuu‑de‑ya̱: Maestro, kee‑ní staa̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ió ndeyu kée‑rí ja̱ tú kájini̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yúan‑na te cha̱a káskuá'a jíín‑yá, ni̱ kajika̱ tu̱'ún tá'an‑de: Ɨɨn cha̱a ni̱ kinchaka ja̱ ní yee‑yá náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Te ni̱ ka'a̱n Jesús jíín‑de: Ndeyu‑rí kúu ja̱ sá'a‑ri̱ tiñu kuní I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱ jíín já skíkuu‑ri̱ tiñu‑ya̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Á tú káka'a̱n‑ro̱: Ió kuu̱n yóo̱ onde̱ kɨvɨ̱ tá'nu̱ trigo. Vina te ká'a̱n‑ri̱ jíín‑ró: Ndukani nuu̱‑ro̱ te nde̱'é‑ró nɨ́ɨ́ ndú'a̱‑ún, chi̱ a ni̱ kuaan já tá'nu̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Te cha̱a já'nu̱, a kí'in‑de ya̱'u‑de te nástútú‑de nuni̱ já kúchaku̱ nɨ́ɨ́ káni, náva̱'a cha̱a sáka jíín cháa já'nu̱, ɨɨn ká'nu‑ni kusɨɨ̱ iní‑de. ");
INSERT INTO migNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chi̱ súan kúu ja̱ ká'a̱n ndaa̱ tu̱'un: Ɨɨn cha̱a sáka, te ɨnga̱‑de já'nu̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Te a ni̱ tájí‑rí róó ki̱ka'nu̱‑ro̱ núu̱ tú ní kásátiñu‑ró. Sava‑ga̱ cha̱a ni̱ ka̱sátiñu, te máá‑ró, a ni̱ kɨ̱vɨ koyo‑ró núu̱ tíñu‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Te ña̱yɨvɨ ñúu̱ Samaria ini̱ ñuu̱ yúan, ni̱ ka̱jini so̱'o‑i tu̱'un ni̱ ka'a̱n ña'an‑ún. Te kua'a̱‑í, ni̱ ka̱kandíja‑i‑ya̱. Chi ni̱ ka'a̱n ndaa̱‑ña: Ni̱ kachi̱‑de nuu̱‑rí ta̱ká na̱ún tiñu ni̱ sá'a‑ri̱, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yúan‑na te ni̱ cha̱koyo ña̱yɨvɨ ñúu̱ Samaria nuu̱‑yá. Te ni̱ kaka'a̱n nda̱'ú‑i jíín‑yá ja̱ ná kéndo̱o‑ya̱ yúan. Te ni̱ kendo̱o‑ya̱ yúan uu̱ kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Te kua'a̱‑gá‑i ni̱ ka̱kandíja‑i‑ya̱ sɨkɨ́ tú'un ká'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Te ni̱ kaka'a̱n‑i jíín ñá'an‑ún: Tuká nɨ́nɨ tú'un máá‑ró te kandíja‑ri̱‑ya̱, chi̱ a ni̱ ka̱jini so̱'o máá‑rí tu̱'un ká'a̱n‑ya̱. Te kájini̱‑ri̱ ja̱ I'a̱ yá'a kúu ndija I'a̱ nama ñu̱yɨ́vɨ, chi̱ Cristo kúu‑ya̱. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Te nuu̱ úu̱ kɨvɨ̱‑ún ni̱ kenda‑ya̱ yúan te kua'a̱n‑ya̱ ñúu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Chi̱ máá Jesús, ni̱ ka'a̱n ndaa̱‑ya̱ já ɨ́ɨn cha̱a jáni tu̱'un Dios, tú ká'i̱o ja̱ jíñú'ún ñáyɨvɨ ñúu̱ máá‑de jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Te ni̱ jaa̱‑ya̱ ñúu̱ Galilea. Te ña̱yɨvɨ Galilea, ni̱ ka̱jatá'ú‑i‑ya̱, chi ni̱ kajini̱‑i ta̱ká tiñu ni̱ sá'a‑ya̱ ondé ñuu̱ Jerusalén kɨvɨ̱ ní i̱o viko yúan. Chi̱ máá‑i, suni ni̱ kaja'a̱n‑i viko‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yúan‑na te ni̱ kee tuku Jesús kua'a̱n‑ya̱ ɨngá jínu onde̱ ñuu̱ Caná ndañúu̱ Galilea nuu̱ ní i̱o nducha já ní nduu vino ni̱ sá'a‑ya̱. Te ini̱ ñuu̱ Capernaum ni̱ i̱o ɨɨn cha̱a játíñu nuu̱ rey te kú'u̱ se̱'e‑de. ");
INSERT INTO migNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Cha̱a yúan, ni̱ jini tu̱'un‑de ja̱ ní kenda Jesús ñuu̱ Judea va̱i‑ya̱ ñúu̱ Galilea. Te ni̱ ja'a̱n‑de nuu̱‑yá. Te ni̱ ka'a̱n nda̱'ú‑de jíín‑yá ja̱ ná núu‑ya̱ kí'i̱n‑ya̱ te nasáva̱'a‑ya̱ sé'e‑de, chi̱ a yani kuu̱‑i. ");
INSERT INTO migNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Te ni̱ ka'a̱n Jesús jíín‑de: Aa̱, te nú tú kuni̱‑ro̱ tuní jíín tíñu ñá'nu, ma̱ kándíja kutɨ‑ro, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Te cha̱a játíñu nuu̱ rey, ni̱ ka'a̱n‑de jíín‑yá: Táta̱, nuu‑ní ki'o̱n vína chi̱ nú ná kúkuéé‑ní te kuu̱‑i, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Te ni̱ ka'a̱n Jesús jíín‑de: Kuá'án, chi̱ chakú se̱'e‑ró, áchí‑ya̱. Te cha̱a‑ún, ni̱ kandíja‑de tu̱'un ni̱ ka'a̱n Jesús. Te ni̱ kee‑de kua'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Te nini núu‑de kua̱no'on‑dé, te ni̱ kenda koyo mozo‑de, ni̱ kajana̱ta'a̱n‑de, te ni̱ kaka̱stu̱'ún núu̱‑dé: Ni̱ nduva̱'a se̱'e‑ní, áchí jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Te máá‑de ni̱ jika̱ tu̱'ún‑de na̱ hora ni̱ kejá'á ndúva̱'a‑i. Te ni̱ kaka'a̱n jíín‑de: Iku ka̱'ɨɨn ni̱ kee ki̱ji‑i, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Te máá táa̱‑i, ni̱ juku̱'un ini̱‑de ja̱ hora‑ún kúu hora ni̱ ka'a̱n Jesús jíín‑de: Chakú se̱'e‑ró. Te ni̱ kandíja‑de jíín nɨ́ɨ́ vé'e‑de. ");
INSERT INTO migNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ya̱'á kúu tuni̱ uu̱ ja̱ ní sá'a Jesús ná ni̱ ndii‑ya̱ ñúu̱ Judea onde̱ ñuu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yuán‑na te ni̱ i̱o viko ñáyɨvɨ judío. Te ni̱ kaa Jesús kua'a̱n‑ya̱ ñúu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Te ñuu̱ Jerusalén íó ɨɨn pila nducha máá yatá yúxé'é rɨ́ɨ̱. Te nuu̱ yú'u hebreo nání Betesda. Te sókó‑ún ñáva̱'a u'u̱n portal. ");
INSERT INTO migNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Te ini̱ portal yúan kánda̱a kuá'a̱ ñáyɨvɨ káku'u̱, ja̱ kuáá, ja̱ rengo, ja̱ tí'íchi. Te káinda̱tu‑i kanda̱ nducha‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Chi̱ íó kɨvɨ̱ já núu ɨɨn ndajá'a̱‑yá ini̱ pila‑ún. Te skandá‑ya̱ ndúcha. Te cha̱a kɨ̱vɨ xnáñúú iní pila, nú a ni̱ skandá‑ya̱ ndúcha, te nduva̱'a‑de na̱ni kue'e̱ tá'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Te yúan kátúu ɨ́ɨn cha̱a ja̱ ní kuu oko̱ xia'u̱n uni̱ kuia̱ kú'u̱‑de. ");
INSERT INTO migNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Te ni̱ jini̱ Jesús ja̱ kátúu cháa yá'a. Te ni̱ juku̱'un ini̱‑ya̱ já ní kuu kua'a̱ kuiá kú'u̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kuní‑ro̱ ndúva̱'a‑ró náún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Te ni̱ ka'a̱n cha̱a kú'u̱‑ún jíín‑yá: Táta̱, tú ní'i̱n‑ná ni ɨɨn cha̱a skɨ́vɨ náá ini̱ pila, nú a ni̱ kanda̱ nducha. Chi̱ nini va̱i‑ná te kɨ́vɨ‑ni ɨnga̱‑de te vásá cháa̱‑ná. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Te ni̱ ka'a̱n Jesús jíín‑de: Nduko̱o, te naki'in‑ró jíto yuu‑ro te ki'i̱n‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Te cha̱a‑ún ni̱ nduva̱'a‑ni‑de. Te ni̱ ki'in‑de ji̱to yuu‑dé te kua'a̱n‑de. Te máá kɨvɨ́ ndéta̱tú kúu kɨvɨ̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yúan‑na te ni̱ kaka'a̱n cha̱a judío jíín cháa ni̱ nduva̱'a‑ún: Kɨvɨ̱ ndéta̱tú kúu. Tú íó ley ja̱ kúndiso‑ró jíto yuu‑ro, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Te ni̱ ka'a̱n‑de jíín cháa judío: Cha̱a ni̱ nasáva̱'a ruu̱, máá‑de ni̱ ka'a̱n‑de jíín‑rí: Ki'in ji̱to yuu‑ro, te ki'i̱n‑ro̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yúan‑na te ni̱ kajika̱ tu̱'ún‑ún‑de: Ndé cha̱a ni̱ ka'a̱n jíín‑ró: Ki'in ji̱to yuu‑ro te ki'i̱n‑ro̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Te cha̱a ni̱ nduva̱'a‑ún, tú ní jiní‑de ndé cha̱a kúu. Chi̱ Jesús, a ni̱ kuxio‑ni‑ya̱ kuá'a̱n‑ya̱ núu̱ ñáyɨvɨ ká'i̱in yúan. ");
INSERT INTO migNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kúkuéé‑ga̱, te ni̱ ketá'an Jesús jíín‑de ini̱ ve̱'e ii̱. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Vina te ni̱ nduva̱'a‑ró. Ma̱ sá'a‑ga̱‑ro̱ kuáchi. Chi̱ nú túu, te kii ɨɨn tu̱ndó'o xaa̱n‑gá sɨkɨ̱‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Te máá‑de kua'a̱n‑de. Te ni̱ kastu̱'ún‑de nuu̱ táká ña̱yɨvɨ judío ja̱ Jesús kúu I'a̱ ni̱ nasáva̱'a‑ya̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Te ni̱ sá'a Jesús tiñu yá'a kɨvɨ̱ ndéta̱tú. Te cha̱a judío, ja̱ yúán ní ka̱chindiki̱n‑de‑ya̱. Te kándúkú‑de modo ndasa ka'ni‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Te ni̱ ka'a̱n Jesús jíín‑de: Máá Táa̱‑ri̱ sátiñu‑ni‑ya̱ vína te suni ruu̱ sátiñu‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ja̱ yúán cháa judío, ví'í‑gá ni̱ ka̱ndúkú‑de modo ka'ni‑dé‑ya̱. Chi̱ nasu̱ máá ɨ́ɨn kɨvɨ̱ ndéta̱tú ní stɨ́vɨ́‑yá, chi̱ suni ni̱ ka'a̱n‑ya̱ já Táa̱‑ya̱ kúu Dios. Te ɨɨn núú‑ni sá'a‑ya̱ máá‑yá jíín Dios. ");
INSERT INTO migNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Te ni̱ ka'a̱n Jesús: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró jíná'an‑ró: Máá Sé'e, ma̱ kúu sá'a kutɨ‑yá ja̱ máá‑yá, chi̱ máni ja̱ ní jini̱‑ya̱ sá'a Táa̱‑ya̱. Chi ta̱ká ja̱ sá'a máá‑yá, suni súan sá'a máá Sé'e‑ya̱ ɨɨn núú‑ni jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Chi̱ máá Táa̱, kúndá'ú ini̱‑ya̱ Sé'e‑ya̱. Te stá'a̱n‑ya̱ núu̱‑í ta̱ká tiñu sá'a‑ya̱. Te ñá'nu‑ga̱ tiñu stá'a̱n‑ya̱ vásá yá'á, náva̱'a naa iní‑ro̱ ndé'é‑ró jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Chi̱ nátu̱'un máá Táa̱, ndúkani‑ya̱ ndɨ́yi te náschakú‑ya̱‑í, suni súan máá Sé'e, náschakú‑ya̱ ndéja̱ kuní máá‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Chi̱ máá Táa̱, tú náku̱xndíi‑ya̱ sɨkɨ́ ní ɨɨn ña̱yɨvɨ, chi ni̱ ja̱'a‑ya̱ tú'un ja̱ náku̱xndíi máá Sé'e‑ya̱ sɨkɨ́ táká ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Náva̱'a kuandatu̱ ndivii ñáyɨvɨ núu̱ Sé'e nátu̱'un kájandatu̱‑i nuu̱ máá Táa̱. Te ja̱ tú jándatu̱ nuu̱ Sé'e, suni tú jándatu̱ nuu̱ máá Táa̱ ja̱ ní tájí‑yá Sé'e‑ya̱ vái. ");
INSERT INTO migNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Nú ɨɨn ña̱yɨvɨ chu'un ini̱‑i tu̱'un ká'a̱n‑ri̱, te kandíja‑i nuu̱ I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱, ña̱yɨvɨ‑ún kuchaku̱‑i nɨ́ɨ́ káni, te ma̱ tá'nu̱ ndatu̱‑i ja̱ kúu̱‑i, chi̱ sua kuchaku̱‑i nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Chaa̱ hora, te vina a kúu, ja̱ táká ndɨ̱yi kuni so̱'o‑i tu̱'un kana jaa máá Sé'e Dios. Te ja̱ kúni so̱'o, nachaku̱ jíná'an. ");
INSERT INTO migNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Chi̱ nátu̱'un máá Táa̱ ñú'un vida ini̱ máá‑yá, suni súan ni̱ ja̱'a‑ya̱ núu̱ Sé'e‑ya̱ já ñú'un vida ini̱ máá‑i. ");
INSERT INTO migNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Te suni ni̱ ja̱'a Dios tu̱'un ja̱ náku̱xndíi Se̱'e sɨkɨ̱ ñáyɨvɨ, chi̱ suni Se̱'e cha̱a kúu‑i. ");
INSERT INTO migNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma̱ náa iní‑ro̱ já ká'a̱n‑ri̱ tu̱'un yá'a jíín‑ró. Chi̱ chaa̱ ɨɨn kɨvɨ̱ já táká ndɨ̱yi ká'i̱in ini̱ ve̱'e añú, kuni so̱'o‑i tu̱'un kana jaa‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Te ta̱ká ña̱yɨvɨ ní ka̱sá'a tiñu va̱'a, kenda‑i te kuchaku̱‑i nɨ́ɨ́ káni. Te ña̱yɨvɨ ní ka̱sá'a tiñu ñáá, suni nachaku̱‑i ko ta'nu̱ ndatu̱‑i. ");
INSERT INTO migNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ma̱ kúu kutɨ sá'a máá‑rí ja̱ máá‑rí. Nátu̱'un jíni so̱'o‑ri̱, súan sándaa̱‑ri̱. Te modo ndaa̱ sándaa̱‑ri̱, chi̱ tú sá'a‑ri̱ ja̱ kuní máá‑rí, chi ja̱ kuní máá Táa̱‑ri̱ I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱ sá'a‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Te nú ruu̱ ká'a̱n‑ri̱ tu̱'un máá‑rí, te tú íó ndaa̱ tu̱'un ká'a̱n‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ɨnga̱ kúu ja̱ jáni ndaa̱ tu̱'un‑ri̱. Te jiní‑ri̱ ja̱ tú'un ndaa̱ kúu ja̱ ká'a̱n‑ya̱ tú'un‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Máá‑ró ni̱ ka̱tájí‑ró cháa ni̱ kaja'a̱n nuu̱ Juan. Te máá‑de ni̱ jani ndaa̱‑de máá tú'un ndaa̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Va̱sa tú játá'ú‑rí tu̱'un‑ri̱ ká'a̱n ni ɨɨn cha̱a, ko tu̱'un yá'a ká'a̱n‑ri̱ náva̱'a ka̱ku‑ró jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Máá‑de ni̱ kuu lámpara ja̱ kayú te stúu̱n. Te máá‑ró, yaku̱‑ni kɨvɨ̱ ní ka̱jata'a̱n ini̱‑ro̱ núu̱ luz máá‑de. ");
INSERT INTO migNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ko ñá'nu‑ga̱ kúu ja̱ jáni ndaa̱ tu̱'un‑ri̱ vásá já ní ka'a̱n Juan. Chi̱ Táa̱‑ri̱, ni̱ ja̱'a‑ya̱ tíñu nuu̱‑rí ja̱ ná sá'a‑ri̱. Te suu tiñu sá'a‑ri̱‑ún kúu ja̱ kájani ndaa̱ tu̱'un ja̱ Táa̱‑ri̱, ni̱ tájí‑yá ruu̱ va̱i‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Te máá Táa̱‑ri̱ ja̱ ní tájí‑yá ruu̱ va̱i‑ri̱, máá‑yá ni̱ ka'a̱n ndaa̱‑ya̱ tú'un‑ri̱. Te tú ní kájini so̱'o kutɨ‑ro tú'un ká'a̱n‑ya̱, ni tú ní kájini̱‑ro̱ ndasa káa‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Te ni tú ncháá ni̱'in tu̱'un‑ya̱ iní‑ro̱. Chi̱ tú kákandíja‑ró I'a̱ ni̱ tájí‑yá va̱i. ");
INSERT INTO migNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kánaka̱ji va̱'a‑ró tutú ii̱, chi̱ kájani ini̱‑ro̱ já tú'un yóso yúan kúu ja̱ kúchaku̱‑ro̱ nɨ́ɨ́ káni sá'a, ko máá tutú‑ún kúu ja̱ ká'a̱n ndaa̱ tu̱'un máá‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Te tú kákuni̱‑ro̱ kíkoyo‑ró núu̱ máá‑rí náva̱'a kuchaku̱‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Tú játá'ú‑rí ja̱ sáñá'nu ña̱yɨvɨ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Te a jiní‑ri̱ róó ja̱ tú kúmani̱‑ro̱ jíín Dios onde̱ jíín iní jíín añú‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ruu̱ va̱i‑ri̱ jíín sɨ́'vɨ́ Táa̱‑ri̱, te tú kájatá'ú‑ró rúu̱. Te nú ɨnga̱ cha̱a chaa̱‑de jíín sɨ́'vɨ́ máá‑de, sa cha̱a‑ún yachi̱ kuatá'ú‑ró‑de. ");
INSERT INTO migNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ndasa kuu kandíja‑ró, chi̱ kásáñá'nu‑ró tá'an‑ró, te tú kándúkú‑ró já ndúñá'nu‑ró sá'a Dios, ja̱ máá ɨ́ɨn‑ni‑ya̱ íó. ");
INSERT INTO migNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma̱ nákani ini̱‑ro̱ já kakán‑ri̱ kua̱chi sɨkɨ̱‑ro̱ núu̱ Táa̱‑ri̱. A káñukuu ini̱‑ro̱ núu̱ Moisés. Te máá‑de, jikán‑de kua̱chi sɨkɨ̱‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Chi̱ nú ní kákandíja‑ró núu̱ Moisés, suni ní kándíja‑ró rúu̱ núú, chi tu̱'un máá‑rí ni̱ chaa‑de. ");
INSERT INTO migNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Te nú tú kákandíja‑ró tutú ni̱ chaa‑de‑ún, te ndasa kandíja‑ró tú'un ká'a̱n‑ri̱ núsáá. Achí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Te ni̱ kuu ta̱ká tiñu yá'a. Te ni̱ kee tuku Jesús kua'a̱n‑ya̱ ɨngá lado mar Galilea, ja̱ kúu mar Tiberias. ");
INSERT INTO migNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Te kua'a̱ xáa̱n ñáyɨvɨ ní kandiki̱n‑i‑ya̱, chi ni̱ kajini̱‑i ta̱ká tuni̱ ni̱ sá'a‑ya̱ jíín ñáyɨvɨ káku'u̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Te ni̱ kaa Jesús ɨɨn yuku. Te ni̱ jungo̱o‑ya̱ yúan jíín cháa káskuá'a jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Te a ni̱ kuyani viko Pascua, viko ñáyɨvɨ judío. ");
INSERT INTO migNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Te ni̱ ndakoto Jesús. Te ni̱ jini̱‑ya̱ já vái koyo kua'a̱ xáa̱n ñáyɨvɨ. Te ni̱ ka'a̱n‑ya̱ jíín Felipe: Ndénu̱ kuáan‑yó stáa̱ kée ñáyɨvɨ yá'a, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ko súan ni̱ ka'a̱n‑ya̱ já jíto nchaa̱‑ya̱‑dé, chi̱ a ni̱ jini̱‑ya̱ ndasa kúu ja̱ sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Te ni̱ ka'a̱n Felipe jíín‑yá: Ma̱ kánda uu̱ ciento peso staa̱ náva̱'a kee‑í tí'li̱ tí'li̱ jíná'an‑i, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Te Andrés, ñani̱ Simón Pedro, ɨɨn cha̱a skuá'a jíín‑yá, ni̱ ka'a̱n‑de: ");
INSERT INTO migNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Ió ɨɨn su̱chí yá'a te ndíso‑i u'u̱n sta̱tilá cebada jíín úu̱ ti̱yáká lúlí. Ko na̱saa‑na̱ kúu‑ún, chi̱ kua'a̱ xáa̱n ñáyɨvɨ, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yúan‑na te ni̱ ka'a̱n Jesús: Súngo̱o‑ró ñáyɨvɨ, áchí‑ya̱. Te yúan íó kua'a̱ ichá. Te nátu̱'un u'u̱n mil cha̱a ni̱ kaju̱ngo̱o‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Te ni̱ ki'in Jesús sta̱tilá‑ún. Te ni̱ jika̱n ta'u̱‑yá. Te ni̱ saka‑yá nuu̱ cháa káskuá'a jíín‑yá. Te máá‑de ni̱ ja̱'a‑de nuu̱ ñáyɨvɨ káxiu̱kú‑ún. Suni súan ni̱ kaja̱'a‑de ti̱yáká‑ún. Te ni̱ ka̱yee‑í na̱saa kákuu ini̱ máá‑i. ");
INSERT INTO migNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Te nuu̱ ní kanda'a̱ chi̱i‑i, te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a‑ún: Nastútú‑ró táká pedazo ja̱ ní ndendoso, náva̱'a tú naa kútɨ, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Te ja̱ á ni̱ ka̱yee ñáyɨvɨ‑ún, te ni̱ ka̱nastútú‑de pedazo ja̱ ní ndendoso sɨkɨ́ ndɨ́'ú'u̱n sta̱tilá cebada‑ún. Te ni̱ kútú‑ni uxi̱ uu̱ ji̱ka. ");
INSERT INTO migNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Te ña̱yɨvɨ‑ún ni̱ kajini̱‑i tuni̱ ni̱ sá'a Jesús, te ni̱ kaka'a̱n‑i: Ja̱ndáa̱ ndija ja̱ cháa yá'a kúu I'a̱ kani tu̱'un Dios ja̱ kíi ini̱ ñu̱yɨ́vɨ. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Te ni̱ jini̱ Jesús ja̱ vái koyo‑i ja̱ kátɨɨn‑i‑ya̱, kuu‑ya̱ rey máá‑i. Te ni̱ kuxio tuku máá ɨ́ɨn‑ni‑ya̱ kuá'a̱n‑ya̱ yúku‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Te nuu̱ ní ini, te cha̱a káskuá'a jíín‑yá, ni̱ ka̱nuu‑de onde̱ mar. ");
INSERT INTO migNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Te ni̱ kɨ̱vɨ koyo‑de ini̱ ɨɨn barco. Te kája'a̱n‑de ɨnga̱ lado mar onde̱ ñuu̱ Capernaum. Te ni̱ kuñaa. Te té nchaa̱‑ga̱ Jesús nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Te ni̱ kee ɨɨn tachi̱ xáa̱n. Te ndónda nducha mar sá'a. ");
INSERT INTO migNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Te ni̱ ka̱jika‑de jíín barco nátu̱'un u'u̱n xí iñú kilómetro. Te ni̱ kajini̱‑de Jesús ja̱ jíka‑ya̱ núu̱ mar. Te ni̱ kuyani‑ya̱ núu̱ barco‑ún. Te ni̱ kayu̱'ú‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Te máá‑yá ni̱ ka'a̱n‑ya̱ jíín‑de: Máá‑rí kúu. Ma̱ yú'ú‑ro̱ jíná'an‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Te kákusɨɨ̱ iní‑de ja̱ ná kɨ́vɨ‑ya̱ iní barco. Yúan‑na te ni̱ jaa̱‑ni barco nuu̱ ñú'un núu̱ kuángoyo‑de‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Te kɨvɨ̱ xía̱n‑ún, te ká'i̱in ta̱ká ña̱yɨvɨ ɨngá lado mar. Te ni̱ kajini̱‑i ja̱ máá ɨ́ɨn‑ni barco íó yúan. Te suni ni̱ kajini̱‑i ja̱ tú ní kɨ́vɨ Jesús ini̱ barco jíín cháa káskuá'a jíín‑yá, chi̱ sua máni máá‑ni cha̱a káskuá'a‑ún, ni̱ kaja'a̱n máá‑ni‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ko sava‑ga̱ barco lúlí, onde̱ ñuu̱ Tiberias ni̱ ja̱koyo yani lugar nuu̱ ní ka̱yee‑í staa̱ já ní jika̱n ta'u̱ máá Jíto'o̱‑yo̱ núú. ");
INSERT INTO migNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Te ni̱ kajini̱ ña̱yɨvɨ já Jesús jíín cháa káskuá'a jíín‑yá, tú káxiu̱kú‑yá yúan. Te ni̱ kɨ̱vɨ koyo máá‑i ini̱ barco lúlí‑ún, te kája'a̱n‑i ñuu̱ Capernaum kuana̱ndúkú‑i Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Te ni̱ ka̱nani'i̱n‑í‑ya̱ ondé ɨnga̱ lado mar. Te ni̱ kaka'a̱n‑i jíín‑yá: Maestro, na̱ hora ni̱ chaa̱‑ní yá'a, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Te ni̱ ka'a̱n Jesús: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ kánandúkú‑ró rúu̱, nasu̱ já ní kajini̱‑ro̱ táká tuni̱ ni̱ sá'a‑ri̱, chi̱ sua ja̱ ní ka̱yee‑ro stáa̱ te ni̱ kanda'a̱ chi̱i‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ma̱ sátiñu‑ró já ní'i̱n‑ro̱ ndéyu já náa, chi̱ sua ja̱ ná kúchaku̱‑ro̱ nɨ́ɨ́ káni sá'a. Máá Sé'e cha̱a kua̱'a‑ya̱ ndéyu‑ún nuu̱‑ro̱, chi ni̱ jatu̱'un Táa̱‑yo̱ Dios ja̱ sá'a‑ya̱ súan. Achí‑ya̱ jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Te ni̱ kaka'a̱n‑i jíín‑yá: Ndasa sá'a‑ná náva̱'a sá'a‑ná tiñu kuní Dios, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Te ni̱ ka'a̱n Jesús: Tiñu kuní Dios kúu ja̱ kándíja‑ró núu̱ I'a̱ ni̱ tájí‑yá va̱i, áchí‑ya̱ jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yúan‑na te ni̱ kaka'a̱n‑i: Núsáá te na̱ún tuni̱ sá'a‑ní náva̱'a kuni̱‑ná te kandíja‑ná níí. Na̱ún tiñu sá'a‑ní. ");
INSERT INTO migNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ndɨ̱yi táa̱‑yo̱, ni̱ ka̱yee‑dé staa̱ ándɨ́vɨ́ ondé nuu̱ ñú'un té'é nátu̱'un yóso núu̱ tutú: Onde̱ andɨ́vɨ́ ní ja̱'a‑ya̱ stáa̱ ní ka̱yee‑dé, áchí‑i jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Te ni̱ ka'a̱n Jesús: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Nasu̱ Moisés ní já'a staa̱ ondé andɨ́vɨ́ núu̱‑ro̱ jíná'an‑ró. Ko Táa̱‑ri̱, chi̱ onde̱ andɨ́vɨ́ já'a ndija‑ya̱ Stáa̱ núu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chi̱ Staa̱ Dios kúu I'a̱ ni̱ kuun ichi ándɨ́vɨ́. Te já'a‑ya̱ já kúchaku̱ ña̱yɨvɨ ñúyɨ́vɨ. Achí‑ya̱ jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Te ni̱ kaka'a̱n‑i jíín‑yá: Táta̱, nene̱ kua̱'a‑ní staa̱ jián kée‑ná, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Te ni̱ ka'a̱n Jesús: Máá‑rí kúu máá Stáa̱ já kúchaku̱‑ro̱ sá'a. Ndéja̱ kíi nuu̱‑rí, ma̱ kúu̱ kutɨ sóko. Te ndéja̱ kándíja ruu̱, ma̱ kuchí kutɨ ndúcha. ");
INSERT INTO migNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ko a ni̱ ka'a̱n‑ri̱ jíín‑ró, ja̱ tú kákandíja‑ró rúu̱, va̱sa ni̱ kajini̱‑ro̱ núu̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta̱ká ja̱ já'a máá Táa̱‑ri̱ nuu̱‑rí, chaa̱ nuu̱‑rí. Te ndéja̱ cháa̱ nuu̱‑rí ma̱ kíñi'in kutɨ‑rí ki'i̱n. ");
INSERT INTO migNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ni̱ kuun‑ri̱ ichi ándɨ́vɨ́ náva̱'a sá'a‑ri̱ ja̱ kuní I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱, nasu̱ já sá'a‑ri̱ ja̱ kuní máá‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Te máá Táa̱‑ri̱ kúu I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱. Te tú kuní‑ya̱ já náa ní ɨɨn ña̱yɨvɨ ní ja̱'a‑ya̱ núu̱‑rí, chi̱ sua ja̱ ná náschakú‑ri̱‑i kɨvɨ̱ jínu ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Te ya̱'á kúu ja̱ kuní I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱. Ta̱ká ña̱yɨvɨ já jiní nuu̱ Sé'e‑ya̱ te kandíja‑i nuu̱‑yá, kuchaku̱‑i nɨ́ɨ́ káni. Te máá‑rí naschakú‑ri̱‑i kɨvɨ̱ jínu ñu̱yɨ́vɨ. Achí‑ya̱ jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yúan‑na te ni̱ kaka'a̱n cha̱a judío sɨkɨ̱‑yá. Chi ni̱ ka'a̱n‑ya̱: Máá‑rí kúu Staa̱ ní kuun ichi ándɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Te ni̱ kaka'a̱n‑de: Á nasu̱ cháa yá'a kúu Jesús, se̱'e José. Te a kájini̱‑yo̱ táa̱‑de jíín náa̱‑de. Te naja̱ ká'a̱n‑de: Ichi ándɨ́vɨ́ ní kuun‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Te ni̱ ka'a̱n Jesús: Ma̱ ká'a̱n sóó‑ró jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Máá Táa̱‑ri̱, ni̱ tájí‑yá ruu̱ va̱i‑ri̱. Te ma̱ kúu kii ni ɨɨn ña̱yɨvɨ núu̱‑rí nú tú kinchaka máá‑yá‑i. Yúan‑na te naschakú‑ri̱‑i kɨvɨ̱ jínu ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yóso núu̱ tutú cha̱a ni̱ ka̱jani tu̱'un Dios: Ndɨta̱ká‑de kutu̱'a‑de sá'a Dios, áchí. Núsáá te ta̱ká ña̱yɨvɨ jíni so̱'o tu̱'un ká'a̱n máá Táa̱‑ri̱, te tu̱'a‑i jíín, ña̱yɨvɨ‑ún kíi‑i nuu̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ni ɨɨn ña̱yɨvɨ, tú ní jiní kutɨ núu̱ máá Táa̱‑ri̱. Máá I'a̱ va̱i onde̱ nuu̱ Dios, máá ɨ́ɨn‑ni‑ya̱ kúu ja̱ á ni̱ jini̱‑ya̱ núu̱ máá Táa̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró jíná'an‑ró: Nú ɨɨn ña̱yɨvɨ kándíja‑i ruu̱, kuchaku̱‑i nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Máá‑rí kúu Staa̱ já kúchaku̱‑ro̱ sá'a. ");
INSERT INTO migNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ndɨ̱yi táa̱‑ro̱, ni̱ kayee‑dé staa̱ ándɨ́vɨ́ ondé nuu̱ ñú'un té'é te a ni̱ kaji'i̱‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ko ya̱'á kúu Staa̱ já vái ichi ándɨ́vɨ́ náva̱'a nú ndé ña̱yɨvɨ kée, te ma̱ kúu̱‑i. ");
INSERT INTO migNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Máá‑rí kúu Staa̱ chakú ja̱ vái ichi ándɨ́vɨ́. Te nú ndé ña̱yɨvɨ kée Staa̱ yá'a, kuchaku̱‑i nɨ́ɨ́ káni. Te Staa̱ já kuá'a‑ri̱‑ún, kúu ku̱ñu‑ri̱. Te kua̱'a‑ri̱ ku̱ñu‑ri̱ náva̱'a kuchaku̱ ñu̱yɨ́vɨ. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yúan‑na te cha̱a judío, ni̱ ka̱státá'an máá‑de: Cha̱a yá'a, ndasa kuu kua̱'a‑de ku̱ñu‑de kee‑yo, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Te ni̱ ka'a̱n Jesús jíín‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, nú tú kee‑ro kúñu máá Sé'e cha̱a, te nú tú ko'o‑ró nɨñɨ́‑yá, te ma̱ kúchaku̱‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Chi̱ cha̱a kee kúñu‑ri̱ te ko'o nɨñi̱‑rí, kuchaku̱‑de nɨ́ɨ́ káni. Te máá‑rí naschakú‑ri̱‑de kɨvɨ̱ jínu ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chi ku̱ñu‑ri̱ kúu ndija ndeyu. Te nɨñi̱‑rí kúu ndija nducha. ");
INSERT INTO migNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Cha̱a yée kúñu‑ri̱ te jí'i nɨñi̱‑rí, nene̱ kunchaa̱‑de jíín‑rí, te ruu̱ jíín máá‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Máá Táa̱‑ri̱ chakú‑ya̱. Te ni̱ tájí‑yá ruu̱ va̱i‑ri̱. Te máá‑rí chakú‑ri̱ sá'a Táa̱‑ri̱. Suni súan nú ndé cha̱a kee rúu̱, suni kuchaku̱‑de sá'a‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ya̱'á kúu Staa̱ vái ichi ándɨ́vɨ́. Ndɨ̱yi táa̱‑ro̱ sɨ́ɨn staa̱ ándɨ́vɨ́ ní ka̱yee‑dé, te a ni̱ kaji'i̱‑de. Ko nú ndé cha̱a kee Stáa̱ yá'a, kuchaku̱‑de nɨ́ɨ́ káni, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ta̱ká tu̱'un yúan ni̱ ka'a̱n Jesús ini̱ ve̱'e sinagoga, nini stá'a̱n‑ya̱ i̱ní ñúu̱ Capernaum. ");
INSERT INTO migNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Te kua'a̱ cháa káskuá'a jíín‑yá, ni̱ kajini so̱'o‑de. Te ni̱ kaka'a̱n‑de: Xaa̱n yíí káa tu̱'un yá'a. Ndé cha̱a kúu juku̱'un ini̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Te Jesús ni̱ jini̱‑ni‑ya̱ já súan ni̱ kaka'a̱n cha̱a káskuá'a jíín‑yá. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kánayu̱'ú‑ro̱ sá'a tu̱'un yá'a náún. ");
INSERT INTO migNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Te ndasa sá'a‑ró nú kuni̱‑ro̱ máá Sé'e cha̱a, ndaa‑ya̱ núu̱ ní kanchaa̱ núú‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jíín máá Espíritu kúu ja̱ kúchaku̱‑yo̱ sá'a. Te yikɨ kúñu tú kutɨ ní'i̱n tíñu. Tu̱'un ni̱ ka'a̱n‑ri̱ jíín‑ró jíná'an‑ró kákuu cuenta Espíritu jíín já kúchaku̱‑yo̱ sá'a. ");
INSERT INTO migNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ko sava‑ró, tú kákandíja‑ró, áchí‑ya̱. Chi̱ Jesús, onde̱ xnáñúú ní jini̱‑ya̱ ndéja̱ kúu ja̱ tú kandíja, te ndéja̱ kúu ja̱ nástúu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Te ni̱ ka'a̱n‑ga̱‑ya̱: Ja̱ yúán ní ka'a̱n‑ri̱ jíín‑ró ja̱ ní ɨɨn ña̱yɨvɨ ma̱ kúu kii‑i nuu̱‑rí, nú tú ní játu̱'un máá Táa̱‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yúan‑na te kua'a̱ cháa káskuá'a jíín‑yá, ni̱ ka̱nakaka yátá‑de, te tuká‑ni ní kájika‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Te ni̱ ka'a̱n Jesús jíín máá ndɨ́'uxí uu̱ cha̱a‑ún: Te róó suni ki̱ngoyo‑ró kákuni̱‑ro̱ náún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Te ni̱ ka'a̱n Simón Pedro: Táta̱, ndé nuu̱ kíngoyo‑ná, chi̱ máá‑ní kúu I'a̱ jáni tu̱'un ndasa kuchaku̱‑ná nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Te kájini̱‑ná te kákandíja‑ná ja̱ máá‑ní kúu Cristo, Se̱'e Dios, I'a̱ chakú, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Te ni̱ ka'a̱n Jesús jíín‑de: Tú ní káji‑ri̱ ndɨ́'uxí uu̱‑ro̱ náún. Te ɨɨn‑ró kúu kui'na̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Te súan ni̱ ka'a̱n‑ya̱ sɨkɨ́ Judas Iscariote, se̱'e Simón. Chi cha̱a yá'a, nastúu‑de‑ya̱. Te ɨɨn tá'an ja̱ uxí uu̱‑ún kúu‑de. ");
INSERT INTO migNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Te ni̱ kuu ta̱ká tiñu yá'a. Te jíka kuu Jesús ñuu̱ Galilea. Te tú kuní‑ya̱ káka kuu‑ya̱ ñúu̱ Judea, chi cha̱a judío kándúkú‑de modo ka'ni‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Te a ni̱ kuyani viko vé'e enramada, ja̱ kúu ɨɨn viko ñáyɨvɨ judío. ");
INSERT INTO migNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Te ni̱ kaka'a̱n ñani̱‑ya̱ jíín‑yá: Kenda‑ró yá'a te ki'i̱n‑ro̱ ñúu̱ Judea va'a̱‑ga̱, náva̱'a cha̱a káskuá'a jíín‑ró ná kuní‑de ná tiñu sá'a‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nú kuní ɨɨn cha̱a ja̱ kuichá tu̱'un‑de, naja̱ sá'a sa̱'í‑de tiñu. Te nú tiñu yá'a sá'a‑ró, te stá'a̱n ndiji̱n‑ro̱ máá‑ró núu̱ ñáyɨvɨ núsáá, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Chi̱ ni ñani̱‑ya̱, tú kájatú'ún‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de: Té chá'a̱n‑ga̱ jaa̱ kɨvɨ̱‑rí. Ko kɨvɨ̱ máá‑ró, chi̱ a ni̱ chaa̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ma̱ kúu koto u'u̱ ña̱yɨvɨ róó, ko jíto u'u̱‑i ruu̱, chi̱ ká'a̱n‑ri̱ tu̱'un ndaa̱ máá ñáyɨvɨ ja̱ máni tíñu ñáá kásá'a‑i. ");
INSERT INTO migNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kaa máá‑ró kuángoyo‑ró víko‑ún. Máá‑rí chi ma̱ kí'i̱n‑ri̱ viko‑ún vina, chi̱ té jaa̱‑ga̱ kɨvɨ̱‑rí. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Te ni̱ ka'a̱n‑ya̱ tú'un yá'a jíín‑de. Te ni̱ kendo̱o‑ni‑ya̱ ñúu̱ Galilea. ");
INSERT INTO migNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Te ni̱ kaa ñani̱‑ya̱ kája'a̱n. Yúan‑na te suni ni̱ kaa máá‑yá kuá'a̱n‑ya̱ víko‑ún, ko tú ní stá'a̱n ndiji̱n‑ya̱ máá‑yá, chi̱ sa̱'í‑ni ni̱ ja'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Te cha̱a judío, kánandúkú‑de‑ya̱ víko‑ún. Te káka'a̱n‑de: Ndénu̱ kándee cha̱a‑ún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Te xaa̱n ní kuvaa̱ tu̱'un‑ya̱ núu̱ ñáyɨvɨ‑ún, chi̱ sava‑i ni̱ kaka'a̱n‑i: Cha̱a va̱'a kúu‑de. Te sava‑ga̱‑i ni̱ kaka'a̱n‑i: Túu, chi̱ xndá'ú‑de ña̱yɨvɨ, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ko ni ɨɨn‑i tú ní káka'a̱n ndiji̱n‑i tu̱'un‑ya̱, chi̱ káyu̱'ú‑i cha̱a judío. ");
INSERT INTO migNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Te sava viko, ni̱ kaa Jesús kua'a̱n‑ya̱ vé'e ii̱, te ni̱ stá'a̱n‑ya̱ tú'un. ");
INSERT INTO migNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Te ni̱ ka̱naa iní cha̱a judío kánde̱'é‑de: Ndasa jiní cha̱a yá'a letra, chi̱ tú ní skuá'a‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yúan‑na te ni̱ ka'a̱n Jesús: Tu̱'un stá'a̱n‑ri̱ nasu̱ máá‑rí xíin, chi tu̱'un I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱ kúu. ");
INSERT INTO migNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɨɨn cha̱a, nú kuní‑de sá'a‑de tiñu kuní Dios, cha̱a‑ún, juku̱'un ini̱‑de tu̱'un stá'a̱n‑ri̱, nú onde̱ nuu̱ Dios va̱i, xí já ní kiñi'in máá‑rí kúu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Cha̱a ká'a̱n tu̱'un máá‑de, ndúkú‑de ja̱ ndúñá'nu máá‑de. Ko nú ɨɨn cha̱a ndúkú‑de ja̱ ndúñá'nu cha̱a ni̱ tájí‑de va̱i‑de, cha̱a yá'a kúu cha̱a ndaa̱, te tú na̱ún tu̱'un ñáá íó ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés, ni̱ ja̱'a‑de ley nuu̱‑ro̱ jíná'an‑ró xí túu. Ko tú ni ɨɨn‑ró káskíkuu ley‑ún. Naja̱ kákuni̱‑ro̱ ká'ni‑ro rúu̱. Achí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Te ni̱ kaka'a̱n ña̱yɨvɨ kuá'a̱‑ún: Tá'a̱n‑ro̱ tachí. Ndéja̱ kuní ka'ni róó. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Te ni̱ ka'a̱n Jesús jíín‑i: Ni̱ sá'a‑ri̱ ɨɨn tiñu, te ndivii‑ro ní ka̱naa iní‑ro̱ kánde̱'é‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ja̱ndáa̱, Moisés ni̱ ja̱'a‑de ley xɨtɨ̱ ndúu̱‑ro̱ jíná'an‑ró. Ko nasu̱ já ní kuu ini̱ Moisés, chi̱ ja̱ ní kuu ini̱ ndɨ̱yi táa̱‑ro̱ kúu. Te kɨvɨ̱ ndéta̱tú káxɨtɨ̱ ndúu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Te nú káxɨtɨ̱ ndúu̱‑ro̱ máá kɨvɨ́ ndéta̱tú, náva̱'a skíkuu ley Moisés, te naja̱ kákiti̱ ini̱‑ro̱ núu̱‑rí ja̱ ní násáva̱'a ii̱‑rí ɨɨn cha̱a kɨvɨ̱ ndéta̱tú núsáá. ");
INSERT INTO migNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ma̱ kóso nínu‑ni tu̱'un ká'a̱n‑ro̱, chi̱ sua ná nándúkú víi‑ro tú'un ndaa̱. Achí‑ya̱ jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yúan‑na te ni̱ kaka'a̱n sava ña̱yɨvɨ ñúu̱ Jerusalén: Nasu̱ cháa yá'a kúu ja̱ kánandúkú‑de ka'ni‑dé náún. ");
INSERT INTO migNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Te yá'a nde̱'é‑ró ká'a̱n ndiji̱n‑de. Te tú na̱ún tu̱'un káka'a̱n jíín‑de. Sanaa te ni̱ kundaa̱ ini̱ cha̱a kákuñá'nu ja̱ cháa yá'a kúu Cristo. ");
INSERT INTO migNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ko cha̱a yá'a, a kájini̱‑yo̱‑dé, jíín ndé ñuu̱ va̱i‑de: Ko ja̱ cháa̱ Cristo, ni ɨɨn‑yó, ma̱ kuní‑yo̱ ndéchi kíi‑ya̱. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yúan‑na te ni̱ ka'a̱n jaa Jesús ini̱ ve̱'e ii̱, hora stá'a̱n‑ya̱ tú'un: A kájini̱‑ro̱ rúu̱, te kájini̱‑ro̱ ndé ñuu̱ va̱i‑ri̱. Tú va̱i‑ri̱ ja̱ sɨkɨ́ máá‑rí, ko ɨɨn I'a̱ ndaa̱ ni̱ tájí rúu̱ va̱i‑ri̱. Te tú kájini̱‑ro̱ I'a̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ko máá‑rí, chi̱ jiní‑ri̱‑ya̱, te onde̱ nuu̱ máá‑yá va̱i‑ri̱, chi ni̱ tájí‑yá ruu̱ va̱i‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yúan‑na te ni̱ ka̱ndúkú ndéé‑de ja̱ kátɨɨn‑de‑ya̱. Ko tú ni ɨɨn‑de ní kénda'a‑dé‑ya̱, chi̱ té jaa̱‑ga̱ hora‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Te ni̱ ka̱kandíja kua'a̱ ñáyɨvɨ tú'un ni̱ ka'a̱n‑ya̱. Te ni̱ kaka'a̱n‑i: Nú ná cháa̱ máá Cristo, te sá'a‑ga̱‑ya̱ tuní vásá já sá'a cha̱a yá'a náún, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Te cha̱a fariseo, ni̱ kajini so̱'o‑de ja̱ ñáyɨvɨ kuá'a̱‑ún súan káka'a̱n‑i tu̱'un‑ya̱. Te sutu̱ ñá'nu jíín cháa fariseo, ni̱ ka̱tájí‑de policía ja̱ kátɨɨn‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Te ni̱ ka'a̱n Jesús: Yaku̱‑na̱ kɨvɨ̱ kúnchaa̱‑ri̱ jíín‑ró jíná'an‑ró. Te no'o̱n‑ri̱ nuu̱ I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Te nandúkú‑ró rúu̱. Te ma̱ náni'i̱n‑ro̱ rúu̱. Te ma̱ kúu jaa̱ koyo‑ró núu̱ kúnchaa̱‑ri̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yúan‑na te ni̱ kaka'a̱n cha̱a judío: Te ndénu̱ kí'i̱n cha̱a yá'a ja̱ má náni'i̱n‑yo̱‑dé. Xí kí'i̱n‑de nuu̱ ñáyɨvɨ‑yo já ní kajicha̱ nu̱u ini̱ ñuu̱ Grecia, te stá'a̱n‑de tu̱'un nuu̱ ñáyɨvɨ ñúu̱ Grecia‑ún náún. ");
INSERT INTO migNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Na̱ún tu̱'un kúu ja̱ ní ka'a̱n‑de yá'a: Nandúkú‑ró rúu̱, te ma̱ náni'i̱n‑ro̱ rúu̱, te ma̱ kúu jaa̱ koyo‑ró núu̱ kúnchaa̱‑ri̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Te kɨvɨ̱ jínu viko‑ún, ja̱ kúu kɨvɨ̱ kúká'nu viko, te ni̱ ndukuiñi̱ Jesús. Te ni̱ ka'a̱n jaa‑ya̱: Nú ndé ɨɨn ña̱yɨvɨ jichí nducha, te ná kíi‑i nuu̱‑rí te ko'o‑i‑cha̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nú ɨɨn ña̱yɨvɨ kándíja‑i ruu̱, yu̱cha nducha chakú kaka ini̱‑i, nátu̱'un ká'a̱n tutu̱ ii̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Súan ni̱ ka'a̱n‑ya̱ tú'un Espíritu ja̱ ní'i̱n ñáyɨvɨ kákandíja‑i‑ya̱. Ko té chaa̱‑ga̱ Espíritu Santo. Chi̱ té chá'a̱n‑ga̱ nduñá'nu luu Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Te sava ña̱yɨvɨ kuá'a̱‑ún, ni̱ ka̱jini so̱'o‑i tu̱'un yá'a. Te ni̱ kaka'a̱n‑i: Ja̱ndáa̱ ja̱ máá cháa jáni tu̱'un Dios kúu cha̱a yá'a, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Te sava‑ga̱‑i ni̱ kaka'a̱n‑i: Cha̱a yá'a kúu Cristo. Ko sava‑ga̱‑i ni̱ kaka'a̱n‑tu‑i: Onde̱ ñuu̱ Galilea kii Cristo náún. ");
INSERT INTO migNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Á tú ká'a̱n tutu̱ ii̱, ja̱ kíi Cristo onde̱ tata̱ David onde̱ ñuu̱ Belén nuu̱ ní ncha̱a máá David, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yúan‑na te ni̱ ka̱státá'an ña̱yɨvɨ já sɨkɨ́‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Te sava‑i, katɨɨn‑i‑ya̱ kákuni̱‑i. Ko tú ni ɨɨn‑i ní kénda'a‑í‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Te policía‑ún, káno'o̱n nuu̱ sutú ñá'nu jíín núu̱ cháa fariseo. Te máá‑ún, ni̱ kaka'a̱n jíín policía: Naja̱ tú ní cháa̱‑de jíín‑ró, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Te ni̱ kaka'a̱n policía‑ún: Tú kutɨ ní ɨɨn cha̱a ká'a̱n nátu̱'un ká'a̱n cha̱a yúan, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Te ni̱ ka'a̱n cha̱a fariseo jíín‑de: Te suni ni̱ xndá'ú‑de róó jíná'an‑ró náún. ");
INSERT INTO migNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","A ni̱ kandíja ɨɨn cha̱a kuñá'nu xí ɨ́ɨn cha̱a fariseo nuu̱‑dé náún. ");
INSERT INTO migNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aa̱, ña̱yɨvɨ yúkú yá'a ja̱ ná tú kájini̱ kutɨ‑í ley, ná tají‑i, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Te Nicodemo, cha̱a ni̱ kii nuu̱‑yá akuáa‑ún, suni ɨɨn cha̱a fariseo kúu‑de. Te ni̱ ka'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Na̱ún áchí ley. Kuu naku̱xndíi‑yó sɨkɨ́ ɨ́ɨn cha̱a, te nú tú xna'a̱n‑ga̱ kuni so̱'o‑yó tú'un ká'a̱n‑de, jíín nú tú ndúkú víi‑yo na̱ún tiñu sá'a‑de náún. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Te ni̱ kaka'a̱n: Te róó, suni onde̱ ñuu̱ Galilea va̱i‑ró náún. Nandúkú vá'a te kuni̱‑ro̱ já ondé ñuu̱ Galilea tú kénda kutɨ ní ɨɨn cha̱a jáni tu̱'un Dios. Achí. ");
INSERT INTO migNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Te kua̱no'on‑dé ná ve'e ná ve'e‑de. ");
INSERT INTO migNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Te ni̱ kee Jesús kua'a̱n‑ya̱ yúku Olivos. ");
INSERT INTO migNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Te ja̱ kuákundiji̱n te ni̱ chaa̱ tuku‑ya̱ vé'e ii̱. Te ndivii ñáyɨvɨ ní cha̱koyo‑i nuu̱‑yá. Te ni̱ jungo̱o‑ya̱, te ni̱ stá'a̱n‑ya̱ tú'un nuu̱‑í jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yúan‑na te cha̱a fariseo jíín cháa káchaa tutu̱, ni̱ ka̱kinchaka‑de ɨɨn ña'an ísɨ́kɨ ncháa̱ tá'an. Te ni̱ jani‑de‑ña má'ñú‑i. ");
INSERT INTO migNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Te ni̱ kaka'a̱n‑de jíín‑yá: Maestro, ni̱ kani'i̱n‑ná ña'an yá'a máá núu̱ tíñu ísɨ́kɨ ncháa̱‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Te nuu̱ ley ni̱ tá'ú Moisés tiñu nuu̱‑yo̱ já kuá'a‑yó yúu̱ xiní ñá'an kásá'a súan. Te máá‑ní, ndasa kachi̱‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ko ni̱ kaka'a̱n‑de tu̱'un yá'a ja̱ kájito nchaa̱‑de‑ya̱, náva̱'a kuu kaka̱n‑de kua̱chi sɨkɨ̱‑yá. Ko Jesús, ni̱ ja̱xin‑ya̱ máá‑yá. Te ni̱ chaa‑ya̱ núu̱ ñú'un jíín xiní ndá'a‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Te kájika̱ tu̱'ún kájika̱ tu̱'ún‑de‑ya̱. Te ni̱ ndukani‑ya̱ máá‑yá. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Te nú ndé ɨɨn máá‑ró tú íó kua̱chi, te róó kúu ja̱ xná'a̱n‑ga̱ kua̱'a yuu̱ xiní‑ñá núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Te ni̱ nakua̱xin‑ya̱ máá‑yá. Te ni̱ chaa tuku‑ya̱ núu̱ ñú'un. ");
INSERT INTO migNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Te ni̱ ka̱jini so̱'o‑de ja̱ súan ni̱ ka'a̱n‑ya̱. Te ni̱ ka̱nakani u'u̱ ini̱‑de. Te ɨɨn‑ni‑de ɨɨn‑ni‑de ni̱ kenda koyo‑de kája'a̱n‑de. Ni̱ kejá'á ondé cha̱a ñá'nu‑ga̱ te onde̱ ni̱ ndɨ'ɨ‑na̱. Te ni̱ kendo̱o máá ɨ́ɨn‑na̱ Jesús jíín ñá'an kándii̱ ma̱'ñú‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Te Jesús, ni̱ ndukani‑ya̱ máá‑yá. Te tuká ni ɨɨn‑de ní jiní‑ya̱, chi̱ máá‑na̱ ñasɨ́'ɨ́‑ún. Te ni̱ ka'a̱n‑ya̱ jíín‑ña: Súchi̱, ndéchi kája'a̱n cha̱a kájika̱n kua̱chi sɨkɨ̱‑ro̱. Tuká ni ɨɨn‑de sáni̱'in róó náún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Te ni̱ ka'a̱n‑ña: Ni ɨɨn‑de Táta̱, áchí‑ña. Yúan‑na te ni̱ ka'a̱n Jesús jíín‑ña: Ni ruu̱, tú sáni̱'in‑ri̱ kua̱chi‑ró: Kuá'án, te ma̱ sá'a‑ga̱‑ro̱ kuáchi, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Te ɨnga̱ jínu ni̱ ka'a̱n tuku Jesús jíín ñáyɨvɨ: Máá‑rí kúu luz ja̱ stúu̱n ini̱ ñu̱yɨ́vɨ. Ndé ña̱yɨvɨ kúndiki̱n ruu̱, te tú kaka‑i ñu̱ñáa, chi̱ sua kuñava̱'a‑i luz ja̱ kúchaku̱‑i sá'a. ");
INSERT INTO migNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yúan‑na te cha̱a fariseo ni̱ kaka'a̱n‑de jíín‑yá. Róó ká'a̱n‑ro̱ tú'un máá‑ró. Tú íó ndaa̱ tu̱'un ká'a̱n‑ro̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Te ni̱ ka'a̱n Jesús: Va̱sa ká'a̱n‑ri̱ tu̱'un máá‑rí, ko íó ndaa̱ tu̱'un ká'a̱n‑ri̱, chi̱ jiní‑ri̱ ndénu̱ vái‑ri̱, te ndénu̱ kí'i̱n‑ri̱. Ko róó, ni tú kájini̱‑ro̱ ndénu̱ vái‑ri̱, ni ndénu̱ kí'i̱n‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Máá‑ró, cuenta cha̱a jíto nchaa̱‑ro̱ ndasa íó. Ko ruu̱, tú jíto nchaa̱‑ri̱ ndasa káa ni ɨɨn ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Te nú ndúkú‑rí ndasa káa, te kénda ndaa̱ tu̱'un sá'a‑ri̱, chi̱ tú sá'a máá ɨ́ɨn‑ri̱, chi̱ onde̱ jíín máá Táa̱‑ri̱, I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Te yóso núu̱ tutú ley máá‑ró, ja̱ nú ka'a̱n uu̱ testigo, te íó ndaa̱ tu̱'un‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ruu̱, ká'a̱n ndaa̱‑ri̱ tu̱'un‑ri̱. Te suni máá Táa̱‑ri̱, I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱, kúu ɨnga̱ testigo‑ri̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Te ni̱ kaka'a̱n‑de jíín‑yá: Ndénu̱ kánchaa̱ Táa̱‑ro̱, áchí‑de. Te ni̱ ka'a̱n Jesús: Tú kájini̱‑ro̱ rúu̱ ni Táa̱‑ri̱. Te nú ní kájini̱‑ro̱ rúu̱, suni kuni̱‑ro̱ Táa̱‑ri̱ núú, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tu̱'un yá'a ni̱ ka'a̱n Jesús nuu̱ kásoko̱‑í xu̱'ún nini sta'a̱n‑ya̱ iní ve̱'e ii̱. Te tú ni ɨɨn‑i ní tɨ́ɨn‑i‑ya̱, chi̱ té cha'a̱n‑ga̱ jaa̱ hora‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Te ni̱ ka'a̱n tuku Jesús jíín‑de: Ruu̱, chi̱ ki'i̱n‑ri̱. Te nandúkú‑ró rúu̱ ko ndíso‑ró kuáchi‑ró kúu̱‑ro̱, te ma̱ kúu jaa̱ koyo‑ró núu̱ kí'i̱n‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yúan‑na te ni̱ kaka'a̱n cha̱a judío: Naja̱ ká'a̱n‑de: Ma̱ kúu jaa̱ koyo‑ró núu̱ kí'i̱n‑ri̱. Á ka'ni‑dé máá‑de ja̱ súan. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Máá‑ró íchi véé vái koyo‑ró, te ruu̱ chi̱ onde̱ nuu̱ súkún vái‑ri̱. Máá‑ró kákuu cha̱a ñu̱yɨ́vɨ yá'a, ko ruu̱ nasu̱ cháa ñu̱yɨ́vɨ yá'a kúu‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ja̱ yúán ní ka'a̱n‑ri̱ jíín‑ró, ja̱ ndíso‑ró kuáchi‑ró kúu̱‑ro̱. Chi̱ nú tú kákandíja‑ró já máá‑rí kúu I'a̱, te kundiso ná'ín‑ró kuáchi‑ró kúu̱‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Te ni̱ kaka'a̱n‑de jíín‑yá: Te róó, ndé cha̱a kúu‑ró, áchí‑de. Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de: Máá‑rí kúu ja̱ ní ka'a̱n‑ri̱ jíín‑ró ondé xnáñúú. ");
INSERT INTO migNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Te sɨkɨ̱ máá‑ró íó kua'a̱‑gá tu̱'un ka'a̱n‑ri̱, jíín já kána jíín‑rí nuu̱‑ro̱. Ko I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱ kúu I'a̱ ndaa̱. Te tu̱'un ká'a̱n‑ri̱ nuu̱ ñúyɨ́vɨ yá'a kúu tu̱'un ni̱ jini so̱'o‑ri̱ ni̱ ka'a̱n máá‑yá. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ko tú ní kájuku̱'un ini̱‑de ja̱ ká'a̱n‑ya̱ tú'un máá Táa̱‑yo̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yúan‑na te ni̱ ka'a̱n Jesús: Onde̱ nú ni̱ ka̱jata kaa‑ró máá Sé'e cha̱a, yúan‑na te kuni̱‑ro̱ já máá‑rí kúu, te tú na̱ún sá'a‑ri̱ ja̱ máá‑rí, chi̱ ká'a̱n‑ri̱ tu̱'un ni̱ stá'a̱n máá Táa̱‑ri̱ nuu̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Chi̱ I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱ kánchaa̱‑ya̱ jíín‑rí. Tú xndóo‑ya̱ rúu̱, chi̱ sá'a ná'ín‑rí tiñu játa'a̱n ini̱ máá‑yá. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Te ja̱ ní ka'a̱n‑ya̱ tú'un yá'a, te kua'a̱ xáa̱n‑dé ni̱ ka̱kandíja‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Te ni̱ ka'a̱n Jesús jíín cháa judío ja̱ kákandíja‑ún: Te nú kendo̱o ni̱'in‑ró jíín tú'un‑ri̱, te kuu‑ró cháa skuá'a ndija jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Te juku̱'un ini̱‑ro̱ jíín tú'un ndaa̱, te koo libre‑ro̱ sá'a tu̱'un ndaa̱‑ún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Te ni̱ kaka'a̱n‑de jíín‑yá: Tata̱ Abraham kákuu‑ri̱, te tú kájatíñu kutɨ‑rí nuu̱ ní ɨɨn ña̱yɨvɨ. Naja̱ ká'a̱n‑ro̱: Koo libre‑ro̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Te ni̱ ka'a̱n Jesús jíín‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ táká cha̱a sá'a kua̱chi, máni mozo kua̱chi kúu‑de. ");
INSERT INTO migNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Te ɨɨn mozo, tú kéndo̱o‑de ini̱ ve̱'e nɨ́ɨ́ káni, ko se̱'e, chi̱ kéndo̱o‑i ini̱ ve̱'e nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Núsáá te nú koo libre‑ro̱ sá'a máá Sé'e, te a ni̱ ka̱kuu libre ndija‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A jiní‑ri̱ ja̱ ɨ́ɨn tata̱ Abraham kákuu‑ró, ko ka'ni‑ro rúu̱ kákuni̱‑ro̱, chi̱ tú káchu'un ini̱‑ro̱ tú'un ká'a̱n‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ruu̱ ká'a̱n‑ri̱ tu̱'un ni̱ jini̱‑ri̱ nuu̱ Táa̱‑ri̱. Te suni máá‑ró kásá'a‑ró tíñu ni̱ ka̱jini so̱'o‑ró núu̱ táa̱ máá‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Te ni̱ kaka'a̱n‑de: Táa̱‑ri̱ kúu Abraham, áchí‑de. Te ni̱ ka'a̱n Jesús: Te nú se̱'e Abraham kákuu‑ró núú, te tiñu ni̱ sá'a Abraham suni sá'a máá‑ró núú. ");
INSERT INTO migNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ni̱ jini so̱'o‑ri̱ tu̱'un ndaa̱ nuu̱ Dios, te ni̱ ka'a̱n‑ri̱ tu̱'un‑ún jíín‑ró. Ko máá‑ró, kákuni̱‑ro̱ ká'ni‑ro rúu̱. Ko nasu̱ tíñu súan ní sá'a Abraham. ");
INSERT INTO migNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Máá‑ró kásá'a‑ró tíñu máá táa̱‑ro̱, áchí‑ya̱ jíín‑de. Yúan‑na te ni̱ kaka'a̱n‑de: Máá‑rí, tú ní kákaku téné‑rí. Ió ɨɨn‑ni táa̱‑ri̱. Dios kúu‑ya̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Te ni̱ ka'a̱n Jesús: Te nú táa̱‑ro̱ kúu Dios, te kumani̱ ndíja‑ró jíín‑rí núú. Chi̱ onde̱ nuu̱ Dios ni̱ kenda‑ri̱. Na̱ tú va̱i‑ri̱ ja̱ máá‑rí, chi̱ máá‑yá ni̱ tájí‑yá ruu̱ va̱i‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Naja̱ tú kájuku̱'un ini̱‑ro̱ tú'un ká'a̱n‑ri̱ núsáá. Kua̱chi ja̱ tú kákanda‑ró kúni so̱'o‑ró tú'un‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Máá‑ró kákuu se̱'e táa̱‑ro̱ kuí'na̱. Te skíkuu‑ró tíñu kuní táa̱‑ro̱ kákuni̱‑ro̱. Máá‑de, ni̱ ja'ni‑dé ndɨ̱yi onde̱ xnáñúú. Te tú ní kándii̱ ni̱'in‑de jíín tú'un ndaa̱, chi̱ tú kutɨ ní ɨɨn tu̱'un ndaa̱ ñú'un ini̱‑de. Te nú ká'a̱n‑de tu̱'un xndá'ú, tu̱'un máá‑de ká'a̱n‑de, chi ja̱ xndá'ú ñáá kúu‑de. Te onde̱ chi̱i máá‑de káku ta̱ká tu̱'un tú'ún. ");
INSERT INTO migNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ko ruu̱, ká'a̱n‑ri̱ tu̱'un ndaa̱. Te ja̱ yúán tú kákandíja‑ró rúu̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ndé ɨɨn róó ndini'in kua̱chi sɨkɨ̱‑rí núsáá. Te nú ká'a̱n ndaa̱‑ri̱, naja̱ tú kákandíja‑ró rúu̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ña̱yɨvɨ kákuu se̱'e Dios, káchu'un ini̱‑i tu̱'un Dios. Ja̱ yúán tú káchu'un ini̱ máá‑ró, chi̱ nasu̱ sé'e Dios kákuu‑ró, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yúan‑na te ni̱ kaka'a̱n cha̱a judío: Ndaa̱ káka'a̱n‑ri̱ ja̱ cháa ñuu̱ Samaria kúu‑ró, te tá'a̱n‑ro̱ tachí, áchí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Te ni̱ ka'a̱n Jesús: Tú tá'a̱n‑ri̱ tachi̱, chi̱ sua jándatu̱‑ri̱ nuu̱ Táa̱‑ri̱. Te máá‑ró tú káka'a̱n jíñú'ún‑ró jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Te tú ndúkú‑rí ja̱ ndúñá'nu‑ri̱. Dios kúu I'a̱ sá'a, te ndé'é‑yá ndasa káa. ");
INSERT INTO migNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Nú ndé ña̱yɨvɨ skíkuu tu̱'un ká'a̱n‑ri̱, ma̱ kúu̱ kutɨ‑í. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Te cha̱a judío, ni̱ kaka'a̱n‑de: Vina te ni̱ kajini̱‑ri̱ ja̱ tá'a̱n‑ro̱ tachí. Abraham jíín cháa kájani tu̱'un Dios, ni̱ kaji'i̱‑de. Te róó áchí‑ro̱: Ja̱ skíkuu tu̱'un ká'a̱n‑ri̱, ma̱ kúu̱ kutɨ. ");
INSERT INTO migNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ni̱ ji'i̱ táa̱‑yo̱ Abraham. Te ñá'nu‑ga̱ kúu‑ró vásá máá‑de náún. Te suni ni̱ kaji'i̱ cha̱a ni̱ jani tu̱'un onde̱ sáá, te ndé cha̱a sá'a‑ró máá‑ró núsáá. Achí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Te ni̱ ka'a̱n Jesús: Te nú ruu̱ sáñá'nu‑ri̱ máá‑rí, te nduñá'nu sáni‑ri̱ núú. Máá Táa̱‑ri̱ kúu I'a̱ sáñá'nu ruu̱. Te máá‑ró káka'a̱n‑ro̱ já I'a̱‑ún kúu Dios máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Te tú kájini̱ kutɨ‑ro núu̱‑yá. Ko ruu̱, chi̱ jiní‑ri̱ nuu̱‑yá. Nú ká'a̱n‑ri̱ jíín‑ró já tú jiní‑ri̱‑ya̱, te kuu‑ri̱ cha̱a xndá'ú ñáá nátu̱'un máá‑ró jíná'an‑ró núú. Ko jiní ndija‑ri̱‑ya̱. Te skíkuu‑ri̱ tu̱'un ká'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Táa̱‑ro̱ Abraham, ni̱ kusɨɨ̱ iní‑de kuni̱‑de kɨvɨ̱ cháa̱‑ri̱. Te a ni̱ jini̱‑de. Te a ni̱ kusɨɨ̱ iní‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yúan‑na te ni̱ kaka'a̱n cha̱a judío jíín‑yá: Aa̱, ni té koo‑ga̱‑ro̱ úu̱ xiko uxi̱ kuia̱, te a ni̱ jini̱‑ro̱ núu̱ Abraham náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Te ni̱ ka'a̱n Jesús jíín‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: A íó‑ri̱ onde̱ ná té kaku‑ga̱ Abraham, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yúan‑na te ni̱ ka̱ki'in‑de yuu̱ já kuá'a‑de‑ya̱. Ko máá Jesús ni̱ sa̱'í‑ni‑ya̱. Te ni̱ kenda‑ya̱ iní ve̱'e ii̱. Te ni̱ ja̱'a‑ya̱ sáva ma̱'ñú‑de, te kua'a̱n‑ni‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Te nini kua'a̱n‑ya̱, te ni̱ jini̱‑ya̱ núu̱ ɨ́ɨn cha̱a kuáá ondé kɨvɨ̱ ní kaku‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Te cha̱a káskuá'a jíín‑yá, ni̱ kajika̱ tu̱'ún‑de‑ya̱: Maestro, naja̱ ní kaku kuáá cháa yá'a. Kua̱chi máá‑de xí kuáchi táa̱‑de kúu náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Te ni̱ ka'a̱n Jesús: Nasu̱ kuáchi máá‑de, ni nasu̱ kuáchi táa̱‑de kúu. Chi̱ sua ja̱ ná sátiñu ndiji̱n Dios jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kánúú sá'a‑ri̱ tiñu I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱, nini íó ndúú. Chi̱ nú ná kuáa, te ma̱ kúu sátiñu‑yó. ");
INSERT INTO migNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nini kándee‑ri̱ ini̱ ñu̱yɨ́vɨ, te luz ñu̱yɨ́vɨ kúu‑ri̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Súan ni̱ ka'a̱n‑ya̱. Te ni̱ tɨvɨ̱ sɨ̱'vɨ́‑yá nuu̱ ñú'un. Te ni̱ sá'a‑ya̱ ndé'yu̱ jíín tɨ́sɨ̱'vɨ́‑yá‑ún. Te ni̱ ji'i‑yá nde'yu̱‑ún sɨkɨ̱ ndúchi cháa kuáá‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kuá'án, te nakɨtɨ nuu̱‑ro̱ iní pila Siloé (ja̱ kuní ka'a̱n, ndajá'a̱). Te ni̱ kee‑de kua'a̱n‑de. Te ni̱ nakɨtɨ nuu̱‑dé, te ni̱ ndundiji̱n‑ni nuu̱‑dé va̱i ndii‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yúan‑na te ta̱ká tá'an‑de, jíín táká ja̱ á ni̱ kajini̱ ja̱ cháa kuáá kúu‑de núú, ni̱ kajika̱ tu̱'ún tá'an: Á nasu̱ cháa yá'a kúu ja̱ ncháá‑ni te jikán caridad núú, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Te sava ni̱ kaka'a̱n: Suu‑de kúu, áchí. Te sava tuku ni̱ kaka'a̱n: Súan jíto‑de nátu̱'un cha̱a‑ún, áchí. Ko máá‑de ni̱ ka'a̱n‑de: Máá‑rí kúu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yúan‑na te ni̱ kajika̱ tu̱'ún‑ún‑de: Ndasa ni̱ nanuña nduchi‑ro núsáá, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Te ni̱ ka'a̱n‑de: Ɨɨn cha̱a nání Jesús, ni̱ sá'a‑de nde'yu̱. Te ni̱ ji'i‑dé nduchi‑rí. Te ni̱ ka'a̱n‑de jíín‑rí: Kuá'án nuu̱ pila Siloé, te nakɨtɨ nuu̱‑ro̱, áchí‑de. Te ni̱ ja'a̱n‑ri̱, te ni̱ nakɨtɨ nuu̱‑rí, te ni̱ ndundiji̱n‑ni nuu̱‑rí, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yúan‑na te ni̱ kaka'a̱n jíín‑de: Ndénu̱ kándee cha̱a‑ún, áchí. Te ni̱ ka'a̱n‑de: Na̱ kútuní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Yúan‑na te ni̱ kaja̱ncha̱ka cha̱a ni̱ ka̱kuáá‑ún nuu̱ fariseo. ");
INSERT INTO migNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Te kɨvɨ̱ ndéta̱tú kúu kɨvɨ̱ ní sá'a Jesús nde'yu̱‑ún ja̱ ní nakuña‑ya̱ ndúchi‑dé. ");
INSERT INTO migNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Te fariseo, suni ni̱ kajika̱ tu̱'ún ndasa ni̱ ndundiji̱n nuu̱‑dé. Te ni̱ ka'a̱n‑de jíín: Ni̱ ji'i‑dé nde'yu̱ sɨkɨ̱ ndúchi‑rí, te ní nakɨtɨ nuu̱‑rí, te ni̱ ndundiji̱n‑ni nuu̱‑rí, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yúan‑na te sava fariseo ni̱ kaka'a̱n: Cha̱a‑ún, nasu̱ ondé nuu̱ Dios va̱i‑de, chi̱ tú chíñú'ún‑de kɨvɨ̱ ndéta̱tú, áchí. Ko ni̱ kaka'a̱n sava‑ga̱: Nú ɨɨn cha̱a íó kua̱chi kúu‑de, te ndasa kuu sá'a‑de ta̱ká tuni̱ yá'a, áchí. Te ni̱ ka̱státá'an máá jíná'an. ");
INSERT INTO migNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Te ni̱ kaka'a̱n tuku jíín cháa kuáá‑ún: Róó, na̱ún kachí‑ro̱ sɨkɨ́ cháa ni̱ nakuña nduchi‑ro núsáá, áchí. Te máá‑de ni̱ ka'a̱n‑de: Ɨɨn cha̱a jáni tu̱'un Dios kúu‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ko tú ní kákandíja judío ja̱ á ni̱ ndundiji̱n nuu̱‑dé ni ja̱ ní kuu‑de cháa kuáá núú. Te ni̱ ka̱kana xini̱ táa̱ náa̱ cha̱a ja̱ ní ndundiji̱n nuu̱. ");
INSERT INTO migNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Te ni̱ kajika̱ tu̱'ún‑ún‑de: Ya̱'á kúu se̱'e‑ró, ja̱ ní kaku kuáá káka'a̱n‑ro̱ náún. Núsáá te ndasa ni̱ ndundiji̱n nduchi‑dé vina, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Te ni̱ kaka'a̱n táa̱‑de: Kájini̱‑ri̱ ja̱ cháa yá'a kúu se̱'e‑ri̱, ja̱ ní kaku kuáá núú. ");
INSERT INTO migNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ko tú kajini̱‑ri̱ ndasa ni̱ ndundiji̱n nuu̱‑dé vina. Ni tú kájini̱‑ri̱ ndé cha̱a ni̱ nakuña nduchi‑dé. Kaka̱ tu̱'ún máá‑ró‑de, chi cha̱a ñá'nu kúu‑de, te ná kástu̱'ún máá‑de ja̱ máá‑de. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Súan ni̱ kaka'a̱n táa̱‑de, chi̱ káyu̱'ú‑de kájito‑de judío. Chi̱ judío, a ni̱ ka̱sándaa̱ ja̱ nú ndé ña̱yɨvɨ ká'a̱n ndaa̱ ja̱ máá‑yá kúu Cristo, te kiñi'in‑i ki'i̱n‑i yata̱ vé'e sinagoga. ");
INSERT INTO migNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ja̱ yúán ní kaka'a̱n táa̱‑de: A ñá'nu‑de, kaka̱ tu̱'ún máá‑ró‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yúan‑na te ɨnga̱ jínu ni̱ ka̱kana xini̱ cháa ni̱ ka̱kuáá‑ún. Te ni̱ kaka'a̱n jíín‑de: Ná nákana jaa‑ró Dios, chi cha̱a yúan a kájini̱‑yo̱ já cháa íó kua̱chi kúu‑de, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yúan‑na te máá‑de ni̱ ka'a̱n‑de: Nú íó kua̱chi‑de xí na̱ún, tú jiní‑ri̱. Ko íó ɨɨn ja̱ jiní‑ri̱. Chi cha̱a kuáá ní kuu‑ri̱ núú, te vina ni̱ ndundiji̱n nuu̱‑rí. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Te ni̱ kajika̱ tu̱'ún tuku‑de: Ndasa ni̱ sá'a‑de jíín‑ró. Ndasa ni̱ nakuña‑de nduchi‑ro núsáá vii. Achí. ");
INSERT INTO migNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Te ni̱ ka'a̱n‑de jíín: A ni̱ kuu ni̱ kastu̱'ún‑rí nuu̱‑ro̱ te tú káchu'un ini̱‑ro̱. Naja̱ kákuni̱‑ro̱ kúni so̱'o‑ró ɨngá jínu. Suni skuá'a‑ró jíín‑de kákuni̱‑ro̱ náún. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Te ni̱ kakiti̱ ini̱ nuu̱‑dé. Te ni̱ kaka'a̱n jíín‑de: Máá‑ró skuá'a‑ró jíín‑de. Ko ruu̱, chi̱ káskuá'a‑rí tu̱'un Moisés. ");
INSERT INTO migNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kájini̱‑ri̱ ja̱ ní ka'a̱n Dios jíín Moisés. Ko cha̱a jia̱n, tú kájini̱‑ri̱ ndénu̱ vái‑de, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Te ni̱ ka'a̱n máá cháa‑un: Náa iní‑ri̱ ja̱ súan káka'a̱n‑ro̱, chi va̱sa ni̱ nakuña‑de nduchi‑rí te tú kájini̱‑ro̱ ndénu̱ vái‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Te a kájini̱‑ro̱ já Dios tú jíni so̱'o‑ya̱ ká'a̱n ña̱yɨvɨ íó kua̱chi. Ko nú ndé ɨɨn ña̱yɨvɨ chíñú'ún‑i Dios te sá'a‑i ja̱ kuní‑ya̱, nuu̱ ñáyɨvɨ‑ún jíni so̱'o‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Onde̱ nɨ́ɨ́ vái‑yó na̱ tú ní kájini so̱'o kutɨ‑yo já ɨ́ɨn cha̱a nakuña‑de nduchi ɨngá cha̱a ni̱ kaku kuáá. ");
INSERT INTO migNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Te cha̱a yúan, nú tú va̱i‑de onde̱ nuu̱ Dios, te ma̱ kúu kutɨ sá'a‑de núú. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Te ni̱ kaka'a̱n judío: Róó, chi̱ íó kua̱chi‑ró ondé kɨvɨ̱ ní kaku‑ró, te stá'a̱n‑ro̱ tú'un nuu̱ máá‑rí náún, áchí jíín‑de. Te ni̱ ka̱keñi'in‑de kua'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Te ni̱ jini tu̱'un Jesús ja̱ ní ka̱keñi'in‑de kua'a̱n‑de, te ni̱ nani'i̱n‑yá‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Á kándíja‑ró Sé'e Dios, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Te ni̱ ka'a̱n‑de: Ndé cha̱a kúu‑de náva̱'a kandíja‑ná‑de vii, táta̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Te ni̱ ka'a̱n Jesús jíín‑de: A ni̱ jini̱‑ro̱ núu̱‑yá. Te cha̱a ká'a̱n jíín‑ró, máá‑yá kúu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Te ni̱ ka'a̱n‑de: Kándíja‑ná Táta̱, áchí‑de, te ni̱ chiñú'ún‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Te ni̱ ka'a̱n Jesús: Va̱i‑ri̱ ini̱ ñu̱yɨ́vɨ yá'a ja̱ náku̱xndíi‑ri̱ sɨkɨ̱ ñáyɨvɨ. Náva̱'a ta̱ká ja̱ kákuáá, te ndundiji̱n nuu̱, te ta̱ká ja̱ ndijín nuu̱, te kukuáá. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Te ká'i̱in sava fariseo jíín‑yá. Te ni̱ ka̱jini so̱'o tu̱'un yá'a. Te ni̱ kaka'a̱n jíín‑yá: Suni cha̱a kuáá kákuu‑ri̱ náún, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Te ni̱ ka'a̱n Jesús jíín: Nú cha̱a kuáá kákuu‑ró, te ma̱ kóo kua̱chi‑ró núú. Ko vina chi ni̱ kaka'a̱n‑ro̱, kájini̱‑ri̱, áchí‑ro̱, te ja̱ yúán kéndo̱o kua̱chi‑ró jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Nú ndé cha̱a tú kɨ́vɨ‑de ichi yújákú rɨ́ɨ̱, chi̱ sasua káa‑de kɨ̱vɨ‑de ɨnga̱ lado, cha̱a‑ún kúu nato̱ó jíín ñákui̱'ná. ");
INSERT INTO migNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ko cha̱a kɨ̱vɨ ichi yúxé'é, cha̱a‑ún kúu cha̱a ndíto rɨɨ̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Te cha̱a ndíto yuxé'é, júña‑de yuxé'é já kɨ́vɨ cha̱a‑ún. Te rɨɨ̱‑ún, kájini so̱'o‑tɨ̱ já ká'a̱n‑de. Te kána‑de xini̱ rɨ́ɨ̱ máá‑de jíín sɨ́'vɨ́‑tɨ́, te kíñi'in‑de‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Te nú ni̱ kiñi'in‑de ta̱ká rɨɨ̱ máá‑de, te yóxnúú‑de nuu̱‑tɨ́. Te máá rɨ́ɨ̱‑ún káindiki̱n‑tɨ̱‑dé, chi̱ kánakuni̱‑tɨ̱ ká'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ko ma̱ kúndiki̱n‑tɨ̱ yatá ɨ́ɨn cha̱a jíká, chi̱ sua kunu‑tɨ̱ kóto‑tɨ̱‑dé, chi̱ tú kájini̱‑tɨ̱ modo ká'a̱n cha̱a jíká‑ún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ni̱ ka'a̱n Jesús tu̱'un yátá yá'a jíín‑de. Ko tú ní kájuku̱'un ini̱‑de jíín tú'un ni̱ ka'a̱n‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Te ni̱ ka'a̱n tuku Jesús jíín‑de: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró jíná'an‑ró: Máá‑rí kúu nátu̱'un yujákú rɨ́ɨ̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ta̱ká cha̱a ni̱ kikoyo xna'a̱n‑ga̱ vásá ní chaa̱‑ri̱, ñato̱ó jíín ñákui̱'ná kákuu‑de, ko tú ní kájandatu̱ rɨɨ̱‑ún modo ni̱ kaka'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Máá‑rí kúu nátu̱'un máá yúxé'é. Nú ndé ña̱yɨvɨ kɨ́vɨ ichi‑rí, ka̱ku‑i. Te kɨ̱vɨ‑i te ndenda‑i, te ni'i̱n‑í icha̱ kee‑í. ");
INSERT INTO migNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ɨɨn ñakui̱'ná, máni ja̱ sákuí'ná‑de, te ka'ni‑dé, te xnáa‑dé va̱i‑de. Ko ruu̱, chi va̱i‑ri̱ ja̱ ná kúchaku̱‑i, te suni kuchaku̱ jíñú'ún‑i. ");
INSERT INTO migNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Máá‑rí kúu I'a̱ ndíto va̱'a rɨɨ̱. Nú ndé cha̱a ndíto va̱'a‑de rɨɨ̱, cha̱a‑ún koto‑de‑tɨ̱ va̱sa kuu̱‑de jíín‑tɨ́. ");
INSERT INTO migNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ko ɨɨn cha̱a kí'in ya̱'u, tú ndíto va̱'a‑de rɨɨ̱, chi̱ nasu̱ rɨ́ɨ̱ máá‑de kákuu‑tɨ̱. Te nú ni̱ jini̱‑de ja̱ vái yi'ɨ̱, te xndóo‑de rɨɨ̱ ka̱tɨɨn‑ún‑tɨ́, te skuní i̱o rɨɨ̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Te cha̱a ki̱'in ya̱'u‑ún, jínu‑de, chi̱ máni cha̱a ki̱'in ya̱'u kúu‑de, te tú kúndá'ú ini̱‑de rɨɨ̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Máá‑rí kúu I'a̱ ndíto va̱'a rɨɨ̱. Te jiní‑ri̱ nuu̱ táká rɨɨ̱‑ri̱. Te máá‑tɨ́, kájini̱‑tɨ̱ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nátu̱'un máá Táa̱‑ri̱ jiní‑ya̱ rúu̱, te máá‑rí jiní‑ri̱ nuu̱ Táa̱‑ri̱. Te cháa ini̱‑ri̱ kuu̱‑ri̱ ja̱ rɨ́ɨ̱‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Suni ñáva̱'a‑ri̱ yaku̱‑ga̱ rɨɨ̱. Ko sɨ́ɨn sɨ́ɨn ja̱kú ká'i̱in‑tɨ̱. Te jínu ñú'ún já kíki̱'in‑ri̱ kɨtɨ‑ún, te kuni so̱'o‑tɨ̱ tú'un ká'a̱n‑ri̱. Te koo ɨɨn‑ni tɨku'ni̱‑tɨ̱. Te ɨɨn‑ni ja̱ kóto‑tɨ̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Kúndá'ú ini̱ Táa̱‑ri̱ ruu̱, chi̱ cháa ini̱‑ri̱ kuu̱‑ri̱ náva̱'a naschakú‑ri̱ máá‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni ɨɨn ma̱ kúu ka'ni rúu̱, chi̱ máá‑rí kúu ja̱ já'a tu̱'un kuu̱‑ri̱. Nú kuní‑ri̱, te kuu kuu̱‑ri̱, te nú kuní‑ri̱, te kuu nachaku̱‑ri̱, chi̱ súan íó fuerza‑ri̱. Tiñu yá'a ni̱ tá'ú máá Táa̱‑ri̱ nuu̱‑rí. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Te judío ni̱ ka̱státá'an tuku sɨkɨ̱ tú'un yá'a. ");
INSERT INTO migNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Te kua'a̱, ní kaka'a̱n: Tá'a̱n‑de tachi̱ kíni, te kátachi̱‑dé. Naja̱ kájini so̱'o‑ró tú'un ká'a̱n‑de, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Te sava‑ga̱ ni̱ kaka'a̱n: Nasu̱ tú'un cha̱a kátachi̱ ká'a̱n‑de. Kuu nakuña ɨɨn tachi̱ kíni nduchi cháa kuáa náún. Achí. ");
INSERT INTO migNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Te ni̱ kuu kɨvɨ̱ víko já ndúndoo ndatíñu ini̱ ñuu̱ Jerusalén. Te tiempo viko víjin kúu. ");
INSERT INTO migNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Te Jesús, kua'a̱n‑ya̱, va̱i‑ya̱ iní ve̱'e ii̱, ini̱ portal Salomón. ");
INSERT INTO migNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Te cha̱a judio, ni̱ kandutíyúu̱‑de nuu̱‑yá. Te ni̱ kaka'a̱n‑de jíín‑yá: Na̱saa kɨvɨ̱ sténdatu‑ró iní‑ri̱. Te nú máá‑ró kúu Cristo, kachi̱ kájí núu̱‑rí jíná'an‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Te ni̱ ka'a̱n Jesús jíín‑de: A ni̱ kastu̱'ún‑rí nuu̱‑ro̱ te tú kákandíja‑ró. Ta̱ká tiñu ja̱ sá'a‑ri̱ jíín sɨ́'vɨ́ Táa̱‑ri̱, yu̱án kúu ja̱ káka'a̱n ndaa̱ tu̱'un‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tú kákandíja‑ró, chi̱ nasu̱ rɨ́ɨ̱ máá‑rí kákuu‑ró, nátu̱'un ni̱ ka'a̱n‑ri̱ jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Rɨɨ̱‑ri̱, chi̱ kájandatu̱‑tɨ̱ tú'un ká'a̱n‑ri̱. Te máá‑rí jiní‑ri̱‑tɨ̱ jíná'an‑tɨ̱, te kái̱ndiki̱n‑tɨ̱ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Te kuchaku̱‑tɨ̱ nɨ́ɨ́ káni sá'a‑ri̱. Te ma̱ náa kútɨ‑tɨ́. Te ni ɨɨn ña̱yɨvɨ ma̱ kúu kuanchaa̱‑i‑tɨ̱ ndá'a‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Máá Táa̱‑ri̱ ni̱ ja̱'a‑ya̱‑tɨ́ nuu̱‑rí. Te ñá'nu‑ga̱ kúu‑ya̱ vásá táká ña̱yɨvɨ. Te tú ni ɨɨn ña̱yɨvɨ kúu kuanchaa̱‑i‑tɨ̱ ndá'a Táa̱‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Máá‑rí jíín Táa̱‑ri̱, ɨɨn‑ni kákuu‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yúan‑na te cha̱a judío, ni̱ kaki'in tuku‑de yuu̱ já kuá'a‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Te ni̱ ka'a̱n Jesús jíín‑de: Ni̱ stá'a̱n‑ri̱ kua'a̱ tíñu va̱'a nuu̱‑ro̱ cuenta Táa̱‑ri̱. Kua̱chi ndé ɨɨn tiñu‑ún kúu ja̱ kuá'a‑ró yúu̱ rúu̱ núsáá. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Te ni̱ kaka'a̱n cha̱a judío: Nasu̱ sɨkɨ́ tíñu va̱'a kúu ja̱ kuá'a‑yó yúu̱ róó, chi kua̱chi ja̱ ká'a̱n ndɨva̱'a‑ró. Chi̱ róó, cha̱a kúu‑ró. Te sá'a‑ró já Dios kúu‑ró. Achí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Te ni̱ ka'a̱n Jesús: Á nasu̱ yóso tú'un núu̱ ley máá‑ró: Ni̱ ka'a̱n‑ri̱ ja̱ súni Dios kákuu‑ró, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chi ni̱ tájí Dios tu̱'un‑ya̱ kuá'a̱n nuu̱ sáva cha̱a. Te ni̱ skúnání‑yá‑de Dios. Te ma̱ kúu ské'ichi̱‑yo̱ tutú ii̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Núsáá te naja̱ káka'a̱n máá‑ró já tú'un ndɨva̱'a kúu ja̱ ní ka'a̱n‑ri̱ ja̱ Sé'e Dios kúu‑ri̱. Chi̱ máá Táa̱‑ri̱ ni̱ teta'a̱n ndoo‑ya̱ rúu̱, te ni̱ tájí‑yá ruu̱ va̱i‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Te nú tú sá'a‑ri̱ tiñu Táa̱‑ri̱, ma̱ kándíja‑ró rúu̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ko nú sá'a‑ri̱, va̱sa tú kándíja‑ró rúu̱, ko ná kándíja‑ró tíñu‑ún náva̱'a kuni̱‑ro̱ te kandíja‑ró já máá Táa̱‑ri̱ kánchaa̱‑ya̱ jíín‑rí, te máá‑rí jíín máá Táa̱‑ri̱, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yúan‑na te ɨnga̱ jínu kándúkú ndéé‑de katɨɨn‑de‑ya̱. Ko ni̱ kuxio‑ya̱ núu̱‑dé kua'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Te ni̱ naxíó káva Jesús kua'a̱n‑ya̱ ɨngá lado yu̱cha Jordán, nuu̱ ní skuánducha núú Juan. Te ni̱ kanchaa̱‑ya̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Te ni̱ kikoyo kua'a̱ xáa̱n ñáyɨvɨ núu̱‑yá. Te ni̱ kaka'a̱n‑i: Juan, ja̱ndáa̱ tú ní sá'a‑de ni ɨɨn tuni̱. Ko íó ndaa̱ ta̱ká tu̱'un ni̱ ka'a̱n‑de cuenta cha̱a yá'a. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Te kua'a̱ xáa̱n‑í ni̱ ka̱kandíja‑i‑ya̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Te kú'u̱ ɨɨn cha̱a nání Lázaro ñuu̱ Betania, nuu̱ kúu ñuu̱ María jíín kú'u̱‑ña Marta. ");
INSERT INTO migNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Te María‑ún kúu ja̱ ní chi'i aceite máá Jíto'o̱‑yo̱, te ni̱ nasi'ichí‑ña já'a̱‑yá jíín íxi xiní‑ñá. Te cha̱a kú'u̱‑ún kúu kua̱'a‑ña Lázaro. ");
INSERT INTO migNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Te kua̱'a‑de‑ún, ni̱ ka̱tájí‑ña tú'un kua'a̱n nuu̱‑yá: Táta̱, kuni so̱'o‑ní, cha̱a ja̱ maní‑ní jíín, kú'u̱‑de, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Te ni̱ jini so̱'o Jesús. Te ni̱ ka'a̱n‑ya̱: Kue'e̱ yá'a, nasu̱ kué'e̱ kuu̱‑de kúu. Chi̱ sua sá'a ja̱ ná nákana jaa‑i Dios, náva̱'a nduñá'nu Se̱'e Dios sá'a máá kué'e̱‑ún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Te kúmani̱ Jesús jíín Marta jíín kú'u̱‑ña jíín Lázaro. ");
INSERT INTO migNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Te nuu̱ ní jini tu̱'un‑ya̱ já kú'u̱‑de, te ni̱ kendo̱o‑ya̱ yúan uu̱ kɨvɨ̱ núu̱ kánchaa̱‑ya̱‑un. ");
INSERT INTO migNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yu̱án‑na, te ni̱ ka'a̱n‑ya̱ jíín cháa káskuá'a jíín‑yá: Ná kí'o̱n ñúu̱ Judea ɨnga̱ jínu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Te cha̱a káskuá'a‑ún ni̱ kaka'a̱n‑de jíín‑yá: Maestro, vina a kándúkú ndéé cháa judío kua̱'a‑de yuu̱ níí. Te ɨnga̱ jínu ki'i̱n‑ní yúan náún. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Te ni̱ ka'a̱n Jesús: Á tú íó uxi̱ uu̱ hora ɨɨn ncháka. Cha̱a ja̱ jíka ndúú, tú skáchi'i‑de ja'a̱‑dé, chi̱ kúndiji̱n nuu̱‑dé ñu̱yɨ́vɨ yá'a. ");
INSERT INTO migNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ko cha̱a jíka akuáa, skáchi'i‑de ja'a̱‑dé, chi̱ tú kúndiji̱n nuu̱‑dé, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Súan ni̱ ka'a̱n‑ya̱. Te vásá ní ka'a̱n tuku‑ya̱ jíín‑de: Amigo‑yo̱ Lázaro kixí‑de. Ki'i̱n‑ri̱ ja̱ xndúko̱o‑ri̱‑de nuu̱ kixí‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yúan‑na te ni̱ kaka'a̱n cha̱a káskuá'a jíín‑yá: Táta̱, nú kixí‑de te nduva̱'a‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ko súan ni̱ ka'a̱n Jesús ja̱ á ni̱ ji'i̱‑de. Te máá‑de ni̱ ka̱jani ini̱‑de ja̱ kixí ndija‑de. ");
INSERT INTO migNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yúan‑na te ni̱ ka'a̱n kájí Jesús jíín‑de: A ni̱ ji'i̱ Lázaro, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Te kúsɨɨ̱ iní‑ri̱ ja̱ róó jíná'an‑ró, ja̱ tú ní kánchaa̱‑ri̱ yúan, náva̱'a kandíja‑ró. Ko vina ná kí'o̱n núu̱‑dé. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yúan‑na te Tomás, cha̱a nání Dídimo, ni̱ ka'a̱n‑de jíín tá'an‑de, cha̱a káskuá'a: Suni ná kí'i̱n‑yo̱ náva̱'a ná kúu̱ ta'a̱n‑yo̱ jíín‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Te ni̱ chaa̱ Jesús, te ni̱ jini̱‑ya̱ já ní kuu kuu̱n kɨvɨ́ já á ni̱ yu̱ji Lázaro. ");
INSERT INTO migNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Te ñuu̱ Betania kánchaa̱ yani jíín ñúu̱ Jerusalén, nátu̱'un uni̱ kilómetro suu súan‑ni kúu. ");
INSERT INTO migNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Te kua'a̱ ñáyɨvɨ judío, ni̱ kikoyo‑i nuu̱ Marta jíín núu̱ María, ja̱ káka'a̱n‑i tu̱'un ndéé iní jíín‑ña já kuá'a‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Yúan‑na te ni̱ jini tu̱'un Marta ja̱ vái Jesús. Te ni̱ kenda‑ña kuáta'a̱n‑ña‑yá. Ko María, ni̱ kendo̱o‑ña iní ve̱'e. ");
INSERT INTO migNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Te ni̱ ka'a̱n Marta jíín Jesús: Táta̱, nú ní kánchaa̱‑ní yá'a te ma̱ kúu̱ kua̱'a‑ná núú. ");
INSERT INTO migNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Te suni vina jiní‑ná ja̱ táká ja̱ jikán‑ní nuu̱ Dios, te kua̱'a‑ya̱ núu̱‑ní, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Te ni̱ ka'a̱n Jesús jíín‑ña: Nachaku̱ kua̱'a‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Te ni̱ ka'a̱n Marta jíín‑yá: A jiní‑ná ja̱ náchaku̱‑de kɨvɨ̱ náchaku̱ ta̱ká ndɨ̱yi onde̱ ná jínu ñu̱yɨ́vɨ, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Te ni̱ ka'a̱n Jesús: Máá‑rí kúu I'a̱ sá'a ja̱ náchaku̱ jíín já kúchaku̱ nɨ́ɨ́ káni. Ja̱ kándíja ruu̱, va̱sa a ni̱ ji'i̱, ko nachaku̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Te nú ndé ña̱yɨvɨ chakú‑i te kándíja‑i ruu̱, ma̱ kúu̱ kutɨ‑í. Á kándíja‑ró tú'un yá'a xí túu. Achí‑ya̱ jíín‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Te ni̱ ka'a̱n‑ña jíín‑yá: Jaa̱n Táta̱. A ni̱ kandíja‑ná ja̱ máá‑ní kúu Cristo, Se̱'e Dios, ja̱ kíi ini̱ ñu̱yɨ́vɨ, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Te súan ni̱ ka'a̱n‑ña. Te ni̱ kee‑ña kuá'a̱n‑ña. Te ni̱ kana sa̱'í‑ña xiní kú'u̱‑ña María: Máá Maestro, a ni̱ chaa̱‑ya̱, te kána‑ya̱ xiní‑ro̱, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Te María, ja̱ ní jini so̱'o‑ña, ni̱ ndukuiñi̱ yachi̱‑ña, te kua'a̱n‑ña núu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ko Jesús, té jaa̱‑ga̱‑ya̱ ondé ñuu̱, chi ni̱ ndo̱o‑ni‑ya̱ kánchaa̱‑ya̱ núu̱ ní jata'a̱n Marta‑ún‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Te káxiu̱kú ñáyɨvɨ judío ini̱ ve̱'e jíín María, káka'a̱n‑i tu̱'un ndéé iní jíín‑ña. Te ni̱ kajini̱‑i ja̱ ní ndukuiñi̱ yachi̱‑ña kuá'a̱n‑ña. Te ni̱ ka̱indiki̱n‑i‑ña, chi ni̱ kaka'a̱n‑i: Onde̱ yuvé'e añú kuánde'e̱‑ña yúan. ");
INSERT INTO migNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ko ni̱ jaa̱ María nuu̱ kánchaa̱ Jesús. Te ni̱ jini̱‑ña núu̱‑yá. Te ni̱ jukuiñi̱ jítɨ́‑ña núu̱ já'a̱‑yá. Te ni̱ ka'a̱n‑ña jíín‑yá: Táta̱, nú ní kánchaa̱‑ní yá'a, te ma̱ kúu̱ kua̱'a‑ná núú, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yúan‑na te ni̱ jini̱ Jesús ja̱ ndé'e̱‑ña jíín já kánde'e̱ ña̱yɨvɨ judío va̱i koyo jíín‑ña. Te ni̱ jaka̱ nu̱u ini̱‑ya̱. Te ni̱ ndukuí'a̱ ini̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Te ni̱ ka'a̱n‑ya̱: Ndénu̱ ní chindee‑ró‑de, áchí‑ya̱. Te ni̱ kaka'a̱n‑ña jíín‑yá: Ña'a̱n‑ní te kuni̱‑ní, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Te ni̱ nde'e̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yúan‑na te ni̱ kaka'a̱n ña̱yɨvɨ judío: Nde̱'é ná xáa̱n ní kundá'ú ini̱‑de cha̱a‑ún, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ko ni̱ kaka'a̱n sava‑i: Bueno ni̱ nakuña cha̱a yá'a nduchi chaa kuáa. Á tú ní kuu sá'a‑de ja̱ má kúu̱ Lázaro núú, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Te ni̱ ndukuí'a̱ tuku ini̱ Jesús. Te ni̱ chaa̱‑ya̱ yúvé'e añú‑ún. Te ɨɨn yau̱ kava kúu. Te jika̱ yú'u yaú‑ún ndasú ɨɨn yuu̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Te ni̱ ka'a̱n Jesús: Chaxio yuu̱ jián jíná'an‑ró, áchí‑ya̱. Te Marta, kua̱'a cha̱a ni̱ ji'i̱‑ún, ni̱ ka'a̱n‑ña jíín‑yá: Táta̱, a já'a̱n xi̱ko‑de, chi̱ a ni̱ kuu kuu̱n kɨvɨ́ yíndu̱ji‑de, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Te ni̱ ka'a̱n Jesús jíín‑ña: Nasu̱ ní ka'a̱n‑ri̱ jíín‑ró ja̱ nú kándíja‑ró te kuni̱‑ro̱ já ndúñá'nu Dios náún, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yúan‑na te ni̱ ka̱chaxio‑i yuu̱ núu̱ kándee ndɨ̱yi‑ún. Te Jesús, ni̱ ndakoto‑ni‑ya̱ íchi ándɨ́vɨ́. Te ni̱ ka'a̱n‑ya̱: Táta̱, ná kúta'u̱‑ná nuu̱‑ní ja̱ jíni so̱'o‑ní tu̱'un ká'a̱n‑ná. ");
INSERT INTO migNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Te jiní‑ná ja̱ jíni so̱'o ná'ín‑ní tu̱'un ká'a̱n‑ná, ko ká'i̱in kua'a̱ ñáyɨvɨ yá'a. Ja̱ yúán súan ni̱ ka'a̱n‑ná náva̱'a ná kándíja‑i ja̱ máá‑ní ni̱ tájí‑ní náá va̱i‑ná, Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Te súan ni̱ ka'a̱n‑ya̱. Te ni̱ ka'a̱n jaa‑ya̱: Lázaro, ña'a̱n tíkenda, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Te cha̱a ja̱ á ni̱ ji'i̱, ni̱ kenda‑de, te yísúkun ndá'a‑dé sɨ̱'ɨn‑de jíín sá'ma cinta. Te nuu̱‑dé yísúkun ɨ́ɨn sa'ma. Te ni̱ ka'a̱n Jesús jíín‑i: Ndájí‑de, te sía̱‑ro̱‑dé ná kí'i̱n‑de, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yúan‑na te kua'a̱ ñáyɨvɨ judío ja̱ ní kikoyo nuu̱ María‑ún, ni̱ ka̱kandíja‑i‑ya̱. Chi ni̱ kajini̱‑i tiñu ni̱ sá'a Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ko sava‑i ni̱ kaja'a̱n‑i nuu̱ cháa fariseo. Te ni̱ kaka̱stu̱'ún‑i ndasa ni̱ sá'a Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yúan‑na te sutu̱ ñá'nu jíín cháa fariseo, ni̱ ka̱kutútú‑de. Te ni̱ kanda̱tu̱'ún‑de: Ndasa sá'a‑yó, chi cha̱a yá'a xaa̱n sá'a‑de tuni̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Chi̱ nú sía̱‑yo̱‑dé, te ndivii ñáyɨvɨ kándíja‑i. Te cha̱koyo cha̱a ñuu̱ Roma, te xnáa‑dé ñuu̱‑yo̱ ondé jíín ñáyɨvɨ‑yo, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Te ɨɨn tá'an‑de nání‑de Caifás, cha̱a‑ún kúu‑de máá sutú ñá'nu‑ga̱ kuia̱‑ún, ni̱ ka'a̱n‑de jíín: Róó tú kájini̱ kutɨ‑ro. ");
INSERT INTO migNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ni tú kájuku̱'un ini̱‑ro̱ já kánúú kúu̱ ɨɨn cha̱a ja̱ sɨkɨ́ ñáyɨvɨ, nasu̱ já náa ndívii ñáyɨvɨ jíná'an‑i, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ko tu̱'un yá'a, na̱ tú ní ka'a̱n‑de ja̱ máá‑de. Chi ja̱ kúu‑de máá sutú ñá'nu‑ga̱ kuia̱‑ún, te ni̱ jani‑de tu̱'un ja̱ kúu̱ Jesús ja̱ sɨkɨ́ ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Te nasu̱ máá ɨ́ɨn ja̱ ñáyɨvɨ yúan, chi̱ suni ja̱ nástútú‑yá se̱'e Dios ja̱ ní kajicha̱ nu̱u‑i jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yúan‑na te onde̱ kɨvɨ̱‑ún ni̱ kanda̱tu̱'ún‑de ja̱ ká'ni‑dé‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yúan‑na te tuká ní jíka ndiji̱n Jesús nuu̱ cháa judío, chi ni̱ kenda‑ya̱ yúan kua'a̱n‑ya̱ ɨ́ɨn ñuu̱ nání Efraín nuu̱ íó yani ñu'un té'é. Te ni̱ kendo̱o‑ya̱ yúan jíín cháa káskuá'a jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Te a ni̱ kuyani viko Pascua ña̱yɨvɨ judío. Te kua'a̱‑í ni̱ ka̱kaa‑i kua'a̱n‑i ñuu̱ Jerusalén, náva̱'a sándoo‑i máá‑i xna'a̱n‑ga̱ vásá kéjá'á víko Pascua. ");
INSERT INTO migNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Te kánandúkú‑i Jesús. Te kájika̱ tu̱'ún tá'an‑i ini̱ ve̱'e ii̱: Ndasa jáni ini̱‑ro̱. Chaa̱‑de viko yá'a xí túu. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Te sutu̱ ñá'nu jíín cháa fariseo, ni̱ ka̱tá'ú‑de tiñu ja̱ nú ndé ɨɨn‑i jiní‑i ndénu̱ kándee‑ya̱, ná kástu̱'ún‑i náva̱'a tɨɨn‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Te iñu̱ kɨvɨ̱ já té kejá'á‑ga̱ viko Pascua, te ni̱ chaa̱ Jesús ñuu̱ Betania nuu̱ kánchaa̱ Lázaro cha̱a ni̱ ji'i̱ te ni̱ nachaku̱‑de ja̱ ní kuu‑de ndɨ̱yi núú. ");
INSERT INTO migNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Te ni̱ kaja̱'a‑de ndeyu ní kuxíni‑ya̱ yúan. Te Marta ni̱ jani‑ña kó'o̱. Te Lázaro kúu ɨɨn cha̱a yée stáa̱ jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Yúan‑na te ni̱ ki'in María ɨɨn libra perfume ita̱ nardo ja̱ ncháá ya'u. Te ni̱ ji'i‑ñá ja'a̱ Jesús, te ni̱ nasi'ichí‑ña já'a̱‑yá jíín íxi‑ñá. Te nɨ́ɨ́ iní ve̱'e‑ún, ni̱ jicha̱ xiko̱ perfume. ");
INSERT INTO migNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Te ɨɨn cha̱a skuá'a jíín‑yá, nání‑de Judas Iscariote, se̱'e Simón, te kuu‑de cha̱a nastúu‑de‑ya̱. Te ni̱ ka'a̱n‑de: ");
INSERT INTO migNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Naja̱ tú ní kúya̱'u perfume yá'a ja̱ uní ciento peso, te kua̱'a‑yó núu̱ ñáyɨvɨ ndá'ú núú. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Súan ni̱ ka'a̱n‑de, nasu̱ já kúndá'ú ini̱‑de ña̱yɨvɨ ndá'ú, chi̱ sua cha̱a kuí'ná ní kuu‑de. Te ni̱ kuu‑de tesorero, te jánchaa̱‑de ja̱ kájaki̱n‑i‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yúan‑na te ni̱ ka'a̱n Jesús: Sía̱‑ña, chi̱ sɨkɨ̱ kɨvɨ́ yúji‑ri̱ kúu ja̱ chíva̱'a‑ña yá'á. ");
INSERT INTO migNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chi̱ nene̱ káxiu̱kú ñáyɨvɨ ndá'ú jíín‑ró, ko ruu̱, na̱ tú nene̱ kánchaa̱‑ri̱ jíín‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yúan‑na te kua'a̱ ñáyɨvɨ judío, ni̱ kajini tu̱'un‑i ja̱ kánchaa̱‑ya̱ yúan. Te ni̱ cha̱koyo‑i. Ko nasu̱ máá ɨ́ɨn Jesús va̱i nde̱'é‑i, chi̱ suni nde̱'é‑i nuu̱ Lázaro kákuni̱‑i. Chi̱ a ni̱ ji'i̱‑de te ni̱ nachaku̱‑de. ");
INSERT INTO migNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ko sutu̱ ñá'nu, ni̱ kanda̱tu̱'ún‑de ja̱ súni ka'ni‑dé Lázaro. ");
INSERT INTO migNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Chi̱ kua'a̱ ñáyɨvɨ judío, ni̱ kenda‑i kája'a̱n‑i, te kákandíja‑i nuu̱ Jesús ja̱ sɨkɨ́ Lázaro. ");
INSERT INTO migNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Te ɨnga̱ kɨvɨ̱ xía̱n, ni̱ cha̱koyo kua'a̱ ñáyɨvɨ víko‑ún. Te ni̱ ka̱jini tu̱'un‑i ja̱ vái Jesús ñuu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Te ni̱ ka̱ki'in‑i numa yukú ñuu̱. Te ni̱ kenda koyo‑i kua̱ta'a̱n‑i‑ya̱. Te ni̱ ka̱kana jaa‑i: Xáán va̱'a I'a̱ kúu‑ya̱. Ná nákana jaa‑yó‑yá chi̱ ndíso‑ya̱ tíñu máá Tatá Dios. Máá Rey ña̱yɨvɨ Israel kúu‑ya̱. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Te ni̱ ni'i̱n Jesús ɨɨn burro jáá. Te ni̱ jungo̱o‑ya̱ sɨkɨ́‑tɨ́ nátu̱'un ká'a̱n tutu̱: ");
INSERT INTO migNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Se̱sɨ́'ɨ́ ñuu̱ Sion, ma̱ yú'ú‑ro̱. Yá'a nde̱'é‑ró vái Rey máá‑ró, yóso‑yá ɨɨn burro jáá, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Onde̱ xnáñúú te tú ní kájuku̱'un ini̱ cha̱a káskuá'a jíín‑yá jíín tíñu yá'a. Ko onde̱ ná ni̱ nduñá'nu Jesús, yúan‑na te vásá ní kanu̱ku̱'un ini̱‑de tu̱'un yóso sɨkɨ́ máá‑yá, jíín já ní kásá'a‑de tiñu yá'a jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Te ña̱yɨvɨ ká'i̱in jíín‑yá, ni̱ kaka'a̱n ndaa̱‑i ndasa ni̱ kana‑ya̱ xiní Lázaro yuvé'e añú, te ndasa ni̱ nachaku̱‑de ja̱ á ni̱ ji'i̱‑de. ");
INSERT INTO migNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ja̱ yúán ní kenda koyo kua'a̱‑gá‑i, ni̱ ka̱jata'a̱n‑ya̱. Chi̱ ni̱ ka̱jini tu̱'un‑i ja̱ ní sá'a‑ya̱ tuní yá'a. ");
INSERT INTO migNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ko cha̱a fariseo ni̱ kaka'a̱n máá‑de: Vina te a kájini̱‑yo̱ já má kúu kasu̱ kutɨ‑ro. Yúan nde̱'é‑ró, ja̱ ndívii ñáyɨvɨ kája'a̱n‑i yata̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Te suni yaku̱ ña̱yɨvɨ ñúu̱ Grecia ni̱ ka̱kaa‑i kua̱chiñú'ún‑i kɨvɨ̱ víko‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ña̱yɨvɨ‑ún, ni̱ ja̱koyo‑i nuu̱ Felipe cha̱a ñuu̱ Betsaida ndañúu̱ Galilea. Te ni̱ kaka'a̱n nda̱'ú‑i jíín‑de: Táta̱, nde̱'é‑ná nuu̱ Jesús kákuni̱‑ná, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Te ni̱ ja'a̱n Felipe, ni̱ kastu̱'ún‑de nuu̱ Andrés. Yúan‑na te Andrés jíín Felipe ndendúú ni̱ kaka̱stu̱'ún‑de nuu̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Te ni̱ ka'a̱n Jesús jíín‑de: A ni̱ jaa̱ hora ja̱ ndúñá'nu máá Sé'e cha̱a. ");
INSERT INTO migNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ ɨ́ɨn nuni̱ trigo nú tú jungava nuu̱ ñú'un te kuu̱, te máá ɨ́ɨn‑ni kendo̱o. Ko nú kuu̱, te kua'a̱ xáa̱n nuní nándea̱. ");
INSERT INTO migNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nú ndé cha̱a kúndá'ú ini̱‑de máá‑de, te naa‑dé. Ko nú ndé cha̱a tú chíñú'ún‑de máá‑de ini̱ ñu̱yɨ́vɨ yá'a, te kuchaku̱‑de nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nú ndé ɨɨn cha̱a kuní kuatíñu nuu̱‑rí, ná kúndiki̱n‑de ruu̱. Te nuu̱ kúnchaa̱‑ri̱ yúan kunchaa̱ cha̱a játíñu nuu̱‑rí‑ún. Te nú ndé ɨɨn‑de játíñu‑de nuu̱‑rí, te koo ja̱ jíñú'ún Táa̱‑ri̱ nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Te vina ndúkuí'a̱ ini̱‑ri̱. Te á ka'a̱n‑ri̱: Táa̱, nama‑ní náá nuu̱ túndó'o hora yá'a, achi̱‑ri̱ xí túu. Ma̱ kúu, chi ja̱ sɨkɨ́ hora yá'a kúu ja̱ vái‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Táa̱, ná nákana jaa‑i níí sá'a‑ní, áchí‑ya̱ jíín Dios. Yúan‑na te ichi ándɨ́vɨ́ ní kenda ɨɨn tu̱'un: A ni̱ ka̱nakana jaa‑i ruu̱ ni̱ sá'a‑ri̱. Te nakana jaa‑i ruu̱ ɨnga̱ jínu sá'a‑ri̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Te ña̱yɨvɨ ká'i̱in yúan, ni̱ ka̱jini so̱'o‑i te ni̱ kaka'a̱n‑i ja̱ tája kúu. Te sava‑ga̱‑i, ni̱ kaka'a̱n‑i: Ni̱ ka'a̱n ɨɨn ndajá'a̱ Dios jíín‑de, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Te ni̱ ka'a̱n Jesús: Tú va̱i tu̱'un yá'a ja̱ sɨkɨ́ rúu̱, chi̱ sua ja̱ máá‑ró jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vina kúu ja̱ ndúni̱'in kua̱chi sɨkɨ̱ ñúyɨ́vɨ yá'a. Vina kúu ja̱ kénda ja̱ kúñá'nu ini̱ ñu̱yɨ́vɨ yá'a ki'i̱n. ");
INSERT INTO migNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Te ruu̱, nú a ni̱ ndi̱ta kaa‑ri̱ ini̱ ñu̱yɨ́vɨ te kana‑ri̱ xini̱ ndívii ñáyɨvɨ kíkoyo‑i nuu̱‑rí, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tu̱'un yá'a ni̱ ka'a̱n‑ya̱ já stá'a̱n‑ya̱ ndasa kuu̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Te ni̱ kaka'a̱n ña̱yɨvɨ‑ún jíín‑yá: Kájini̱‑ná ja̱ kéndo̱o Cristo nɨ́ɨ́ káni, áchí tutu̱ ley. Te naja̱ ká'a̱n‑ní ja̱ jínu ñú'ún kuíta kaa máá Sé'e cha̱a núsáá. Te ndéja̱ kúu máá Sé'e cha̱a‑ún. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yúan‑na te ni̱ ka'a̱n Jesús: Yaku̱‑na̱ kɨvɨ̱ kúnchaa̱ máá luz jíín‑ró jíná'an‑ró. Kaka nini íó ndiji̱n náva̱'a tú kuñaa núu̱‑ro̱. Chi cha̱a jíka ñu̱ñáa, na̱ tú jiní‑de ndénu̱ kí'i̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kandíja nuu̱ máá luz nini kánchaa̱‑ya̱ jíín‑ró, náva̱'a ná ndúu‑ró sé'e luz, áchí‑ya̱ jíín‑i. Súan ni̱ ka'a̱n Jesús. Te ni̱ kee‑ya̱ kuá'a̱n‑ya̱. Te ni̱ sa̱'í‑ni‑ya̱ núu̱‑í jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ko va̱sa ni̱ sá'a‑ya̱ kuá'a̱ tuní nuu̱‑í, ko tú ní kákandíja‑i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Náva̱'a skíkuu tu̱'un ni̱ ka'a̱n Isaías cha̱a ni̱ jani tu̱'un Dios ja̱ ní ka'a̱n‑de onde̱ sáá: Táta̱, ndéja̱ ní kandíja tu̱'un ni̱ ka'a̱n‑yo̱. Te ndéja̱ ní jini̱ nuu̱ fuerza máá Jíto'o̱‑yo̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ja̱ yúán tú ní kúu kandíja‑i jíná'an‑i, chi ni̱ ka'a̱n tuku Isaías: ");
INSERT INTO migNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ni̱ sákuáá‑ya̱ ndúchi‑í, te ni̱ kundava iní añú‑i ni̱ sá'a‑ya̱, náva̱'a ma̱ kuní‑i jíín ndúchi‑í, ni ma̱ júku̱'un ini̱ añú‑i, ni ma̱ nájíó káva ini̱‑i, ja̱ sá'a‑ri̱ tana̱‑í, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tu̱'un yá'a ni̱ ka'a̱n Isaías, chi ni̱ jini̱‑de ndasa kúñá'nu luu‑ya̱. Te ni̱ ka'a̱n‑de tu̱'un‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ko va̱sa súan ni̱ i̱o, te kua'a̱ cháa tá'ú tíñu, ni̱ ka̱kandíja‑de nuu̱‑yá. Ko ja̱ káyu̱'ú‑de fariseo te tú ní kákastu̱'ún‑de. Chi̱ nú súan, te skúnu‑ún‑de kenda‑de ini̱ ve̱'e sinagoga, jáni ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Chi̱ kúsɨɨ̱‑gá ini̱‑de ja̱ ndúñá'nu‑de sá'a ña̱yɨvɨ vásá já ndúñá'nu‑de sá'a Dios. ");
INSERT INTO migNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Te ni̱ ka'a̱n jaa Jesús: Ña̱yɨvɨ kándíja ruu̱, nasu̱ máá ɨ́ɨn ruu̱ kándíja‑i, chi̱ nuu̱ I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱ kándíja‑i. ");
INSERT INTO migNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Te ña̱yɨvɨ ndé'é núu̱‑rí, suni ndé'é‑i nuu̱ I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Va̱i‑ri̱ ja̱ kúu‑ri̱ ɨɨn luz ini̱ ñu̱yɨ́vɨ, náva̱'a nú ta̱ká ña̱yɨvɨ kándíja‑i ruu̱, ma̱ kúnchaa̱‑i ñu̱ñáa. ");
INSERT INTO migNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nú ɨɨn ña̱yɨvɨ jíni so̱'o‑i tu̱'un ká'a̱n‑ri̱, te tú skíkuu‑i, tú naku̱xndíi‑ri̱ sɨkɨ̱‑í, chi̱ tú va̱i‑ri̱ ja̱ náku̱xndíi‑ri̱ sɨkɨ̱ ñúyɨ́vɨ, chi̱ sua ja̱ náma‑ri̱ ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Te ña̱yɨvɨ ské'ichi̱ ruu̱, te tú játú'ún‑i tu̱'un ká'a̱n‑ri̱, íó ja̱ náku̱xndíi sɨkɨ̱‑í. Tu̱'un ni̱ ka'a̱n‑ri̱ kúu ja̱ náku̱xndíi sɨkɨ̱‑í onde̱ kɨvɨ̱ jínu ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chi̱ tú ká'a̱n‑ri̱ ja̱ máá‑rí, chi̱ Táa̱‑ri̱ I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱, máá‑yá ni̱ tá'ú‑yá tiñu nuu̱‑rí. Ndasa kachi̱‑ri̱ te ndasa ka'a̱n‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Te a jiní‑ri̱ ja̱ tíñu tá'ú‑yá kúu ja̱ kúchaku̱‑i nɨ́ɨ́ káni sá'a. Núsáá te tu̱'un ká'a̱n‑ri̱, máni tu̱'un ni̱ ka'a̱n Táa̱‑ri̱ jíín‑rí kúu, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Onde̱ ná té koo‑ga̱ viko Pascua, te a ni̱ jini̱ Jesús ja̱ ní jaa̱ hora kenda‑ya̱ ñúyɨ́vɨ yá'a no'o̱n‑ya̱ núu̱ Táa̱‑ya̱. Ko kúndá'ú ini̱‑ya̱ ñáyɨvɨ‑yá ká'i̱o ini̱ ñúyɨ́vɨ, te onde̱ sandɨ̱'ɨ́‑na̱ ni̱ kundá'ú ini̱‑ya̱‑í. ");
INSERT INTO migNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Te ni̱ ndɨ'ɨ ni̱ ka̱kuxíni‑ya̱. Te vina a ni̱ ka'a̱n kui'na̱ jíín iní añú Judas, se̱'e Simón Iscariote, ja̱ nástúu‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Te a jiní Jesús ja̱ máá Táa̱‑ya̱, a ni̱ ja̱'a‑ya̱ táká ndatíñu ini̱ nda'a‑yá, te suni jiní‑ya̱ já ní kenda‑ya̱ núu̱ Dios va̱i‑ya̱. Te suni nuu̱ Dios no'o̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Te ni̱ ndukuiñi̱‑ya̱ já ní kuxíni‑ya̱. Te ni̱ chaxio‑ya̱ sá'ma‑yá. Te ni̱ ki'in‑ya̱ ɨ́ɨn sa'ma vítá. Te ni̱ ju'ni̱‑ya̱ chíi‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Te ni̱ chu'un‑ya̱ ndúcha iní ɨɨn tɨja'a̱n, te ni̱ kejá'á‑yá nákacha‑ya̱ já'a̱ cháa káskuá'a. Te nási'ichí‑ya̱ jíín sá'ma vítá já nú'ni̱ chi̱i‑ya̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Te ni̱ jaa̱‑ya̱ núu̱ Simón Pedro. Te ni̱ ka'a̱n Pedro jíín‑yá: Táta̱, níí, nakacha‑ní ja'a̱‑ná náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Te ni̱ ka'a̱n Jesús: Tú júku̱'un ini̱‑ro̱ já sá'a‑ri̱ vina, ko kúkuéé‑ga̱ te juku̱'un ini̱‑ro̱, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Te Pedro ni̱ ka'a̱n‑de jíín‑yá: Ma̱ nákacha kutɨ‑ní ja'a̱‑ná, áchí‑de. Te ni̱ ka'a̱n Jesús jíín‑de: Nú tú nakacha‑ri̱ ja'a̱‑ro̱ te ma̱ kúu kundii̱‑ro̱ jíín‑rí, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Te ni̱ ka'a̱n Simón Pedro jíín‑yá: Táta̱, nasu̱ máá ɨ́ɨn ja'a̱‑ná, chi̱ suni nda'a‑ná jíín xiní‑ná núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Te ni̱ ka'a̱n Jesús jíín‑de: Cha̱a ja̱ á ni̱ ndundoo, máni jínu ñú'ún já ndúndoo máá já'a̱‑ní‑de, te a ni̱ ndundoo ndɨ'ɨ‑ni‑de. Te máá‑ró, a ni̱ ka̱ndundoo‑ró ko nasu̱ táká‑ro̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Chi̱ a ni̱ jini̱‑ya̱ ndéja̱ kúu ja̱ nástúu‑ya̱. Ja̱ yúán ní ka'a̱n‑ya̱: Nasu̱ táká‑ro̱ ká'i̱o ndoo. ");
INSERT INTO migNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Te ni̱ kuu ni̱ nakacha‑ya̱ já'a̱‑dé jíná'an‑de, te ni̱ naki'in‑ya̱ sá'ma‑yá. Te ni̱ nungo̱o tuku‑ya̱. Te ni̱ ka'a̱n‑ya̱: Á kájini̱‑ro̱ já ní sá'a‑ri̱ jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Káka'a̱n‑ro̱ já Maestro jíín Jíto'o̱‑ro̱ kúu‑ri̱, te káka'a̱n ndaa̱‑ro̱. Chi̱ suu máá‑rí kúu. ");
INSERT INTO migNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Te nú ruu̱, va̱sa Jito'o̱‑ro̱ jíín Maestro kúu‑ri̱, nú nakacha‑ri̱ ja'a̱‑ro̱, suni súan kánúú nákacha ja'a̱ tá'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Chi̱ tiñu yá'a ni̱ stá'a̱n‑ri̱ nuu̱‑ro̱ náva̱'a suni sá'a máá‑ró jíín tá'an‑ró nátu̱'un ni̱ sá'a‑ri̱ jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Ɨɨn mozo na̱ tú kúñá'nu‑ga̱‑de nuu̱ jíto'o̱‑de, ni ɨɨn apóstol, na̱ tú kúñá'nu‑ga̱‑de nuu̱ cháa ni̱ tájí‑de kua'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nú kájuku̱'un ini̱‑ro̱ jíín tú'un yá'a, te xáán ndatu̱ koo‑ró nú sá'a‑ró súan. ");
INSERT INTO migNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Na̱ tú ká'a̱n‑ri̱ sɨkɨ̱ táká‑ro̱. A jiní‑ri̱ ndéja̱ ní ka̱ji‑ri̱. Ko ná skíkuu tu̱'un ká'a̱n tutu̱ ii̱: Cha̱a ni̱ yee stáa̱ jíín‑rí, ni̱ jañu̱‑de ruu̱ jíín xúsɨ́'yi‑dé, áchí tutu̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Onde̱ vina kástu̱'ún‑rí ta̱ká tiñu nuu̱‑ro̱ ondé jíín tiempo, náva̱'a nú ni̱ kuu, te kandíja‑ró já máá‑rí kúu I'a̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Nú ɨɨn ña̱yɨvɨ kuátú'ún‑i ɨɨn cha̱a ni̱ tájí‑rí kua'a̱n, te játú'ún‑i ruu̱. Te ña̱yɨvɨ játú'ún rúu̱, suni játú'ún‑i I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱, áchí‑ya̱ jíín‑de jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Te ja̱ á ni̱ ka'a̱n Jesús tu̱'un yá'a, te ni̱ ndukuí'a̱ ini̱‑ya̱. Te ni̱ ka'a̱n ndaa̱‑ya̱: Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró jíná'an‑ró ja̱ ɨ́ɨn róó, nastúu‑ró rúu̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yúan‑na te cha̱a káskuá'a jíín‑yá, ni̱ ka̱ndakoto‑de nuu̱ tá'an‑de, kájani ini̱‑de ndé cha̱a kúu ja̱ ní ka'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Te ɨɨn máá cháa káskuá'a‑ún ja̱ maní‑yá jíín‑de, ndítuu‑de jika̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Te ni̱ sá'a Simón Pedro ɨɨn seña nuu̱ cháa‑ún, náva̱'a ná kaká tu̱'ún‑de‑ya̱ ndé cha̱a kúu ja̱ ní ka'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yúan‑na te máá‑de ja̱ ndítuu‑de jika̱ Jesús, ni̱ ka'a̱n‑de jíín‑yá: Táta̱, ndé cha̱a kúu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Te ni̱ ka'a̱n Jesús: Ná chíndaji‑ri̱ staa̱ te kua̱'a‑ri̱ nuu̱ ɨ́ɨn cha̱a, te cha̱a‑ún kúu, áchí‑ya̱. Te ni̱ chindaji‑ya̱ stáa̱. Te ni̱ ja̱'a‑ya̱ núu̱ Judas Iscariote se̱'e Simón. ");
INSERT INTO migNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Te ni̱ yee stáa̱‑ún. Te ni̱ kɨ̱vɨ‑ni Satanás ini̱. Yúan‑na te ni̱ ka'a̱n Jesús jíín: Tiñu sá'a‑ró, ná sá'a yachi̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ko ni ɨɨn cha̱a káyee stáa̱ jíín‑yá‑ún, tú ní kájuku̱'un ini̱‑de na̱ún tu̱'un kúu ja̱ ní ka'a̱n‑ya̱ jíín. ");
INSERT INTO migNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Chi̱ sava‑de, ni̱ kajani ini̱‑de ja̱ ní ka'a̱n Jesús jíín: Kuaan‑ró na̱ún kájinu ñú'ún‑yó já kúu viko. Xí já kuá'a yaku̱ na̱ jíín núu̱ cháa ndá'ú. Chi̱ Judas tɨ́ɨn janu̱ xú'ún. ");
INSERT INTO migNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Te ja̱ ní yee stáa̱‑ún, te ni̱ kenda‑ni kua'a̱n. Te a ni̱ kuaa. ");
INSERT INTO migNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yúan‑na te ja̱ kuá'a̱n, te ni̱ ka'a̱n Jesús: Vina te a ni̱ nduñá'nu máá Sé'e cha̱a. Te suni ni̱ nduñá'nu Dios ni̱ sá'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Te nú nduñá'nu Dios sá'a‑ya̱, suni sáni nduñá'nu máá‑yá sá'a Dios, te nduñá'nu‑ni‑ya̱ vítan ñú'ni. ");
INSERT INTO migNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Súchi̱, yaku̱‑na̱ kɨvɨ̱ kúnchaa̱‑ri̱ jíín‑ró. Te nandúkú‑ró rúu̱, te nátu̱'un ni̱ ka'a̱n‑ri̱ jíín cháa judío, onde̱ nuu̱ kí'i̱n‑ri̱, ma̱ kúu jaa̱ koyo‑ró jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ɨɨn tiñu jáá tá'ú‑rí nuu̱‑ro̱ jíná'an‑ró: Ja̱ ná kúndá'ú ini̱‑ro̱ táká tá'an‑ró. Nátu̱'un kúndá'ú ini̱‑ri̱ róó, suni súan kundá'ú ini̱‑ro̱ tá'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Te nú kundá'ú ini̱‑ro̱ táká tá'an‑ró, yúan‑na te kuni̱ ta̱ká ña̱yɨvɨ já máá‑ró kákuu cha̱a ni̱ ka̱skuá'a jíín‑rí, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Te ni̱ ka'a̱n Simón Pedro jíín‑yá: Táta̱, ndénu̱ kí'i̱n‑ní, áchí‑de. Te ni̱ ka'a̱n Jesús jíín‑de: Nuu̱ kí'i̱n‑ri̱‑ún, ma̱ kúu kundiki̱n‑ro̱ rúu̱ vina. Ko kúkuéé‑ga̱ te kundiki̱n‑ro̱ rúu̱ jaa̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Te ni̱ ka'a̱n Pedro jíín‑yá: Táta̱, naja̱ má kúu kundiki̱n‑ná níí vina. Tú yú'ú‑ná kuu̱‑ná ja̱ níí. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Te ni̱ ka'a̱n Jesús jíín‑de: Kuu̱‑ro̱ já rúu̱ náún. Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Onde̱ ná té kana‑ga̱ lí'li, te ma̱ kuátu̱'un‑ró rúu̱ uni̱ jínu. ");
INSERT INTO migNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ma̱ kúñáá ini̱ añú‑ro̱. A kákandíja‑ró Dios, suni ná kándíja‑ró rúu̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Chi̱ íó kua'a̱ vé'e ini̱ ve̱'e Táa̱‑ri̱. Te nú tú súan íó, a ni̱ kastu̱'ún‑rí nuu̱‑ro̱ núú. Ki'i̱n‑ri̱ ki̱sátu̱'a‑ri̱ ve'e kuxiu̱kú‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Te nú kua'a̱n‑ri̱ sátu̱'a‑ri̱ ve'e kuxiu̱kú‑ró, te nchaa̱‑ri̱ kinastútú‑rí róó ki'o̱n. Náva̱'a nuu̱ kúnchaa̱ máá‑rí‑ún, suni yúan kuxiu̱kú‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Te a kájini̱‑ro̱ ndénu̱ kí'i̱n‑ri̱. Te kájini̱‑ro̱ íchi, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Te ni̱ ka'a̱n Tomás jíín‑yá: Táta̱, tú kájini̱‑ná ndénu̱ kí'i̱n‑ní. Te ndasa kuni̱‑ná ichi núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Te ni̱ ka'a̱n Jesús jíín‑de: Máá‑rí kúu máá íchi, jíín tú'un ndaa̱, jíín tú'un kuchaku̱. Ma̱ kúu jaa̱ ni ɨɨn‑i nuu̱ Táa̱‑ri̱ te nú túu ruu̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Te nú ní kájini̱‑ro̱ rúu̱, te suni a ni̱ kajini̱‑ro̱ Táa̱‑ri̱ núú. Te onde̱ vina a kájini̱‑ro̱‑yá, te a ni̱ kande̱'é‑ró núu̱‑yá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Te ni̱ ka'a̱n Felipe jíín‑yá: Táta̱, stá'a̱n‑ní máá Táa̱‑yo̱ núu̱‑ná, te ná kúva̱'a ini̱‑ná jíná'an‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Te ni̱ ka'a̱n Jesús jíín‑de: Felipe, kua'a̱ kɨvɨ́ ní kuu jíka‑ri̱ jíín‑ró. Té chá'a̱n‑ga̱ kuni̱‑ro̱ rúu̱ náún. Cha̱a ni̱ jini̱ ruu̱, nuu̱ máá Táa̱‑yo̱ ní jini̱‑de. Naja̱ ká'a̱n‑ro̱: Stá'a̱n‑ní máá Táa̱‑ro̱ núu̱‑ná. ");
INSERT INTO migNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Á tú kándíja‑ró já máá‑rí kánchaa̱‑ri̱ jíín máá Táa̱‑yo̱, te máá Táa̱‑yo̱ Dios kánchaa̱‑ya̱ jíín‑rí. Ta̱ká tu̱'un ká'a̱n‑ri̱ jíín‑ró, nasu̱ já kúu ini̱ máá‑rí ká'a̱n‑ri̱. Chi̱ máá Táa̱‑yo̱ kánchaa̱‑ya̱ jíín‑rí, te máá‑yá sá'a tiñu‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kandíja ruu̱ ja̱ kánchaa̱‑ri̱ jíín máá Táa̱‑yo̱, te máá Táa̱‑yo̱ jíín máá‑rí: Te nú tú súan, te kandíja ruu̱ cuenta máá tíñu sá'a‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Nú ndé cha̱a kándíja ruu̱, tiñu ja̱ sá'a‑ri̱ yá'a suni sá'a‑de. Te ñá'nu‑ga̱ tiñu sá'a máá‑de vásá yá'á, chi̱ no'o̱n‑ri̱ nuu̱ máá Táa̱‑yo̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Te ta̱ká na̱ún ja̱ kakán‑ro̱ núu̱ máá Táa̱‑yo̱ jíín sɨ́'vɨ́‑rí, yu̱án sá'a‑ri̱, náva̱'a nduñá'nu máá Táa̱‑yo̱ já sɨkɨ́ máá Sé'e‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Te nú na̱ún kakán‑ro̱ jíín sɨ́'vɨ́‑rí, te skíkuu‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Te nú mani̱‑ro̱ jíín‑rí, te kuandatu̱‑ro̱ tíñu tá'ú‑rí nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Te kaka̱n ta'u̱‑rí nuu̱ máá Táa̱‑yo̱ Dios. Te kua̱'a‑ya̱ ɨngá I'a̱ chindéé chítuu róó jíná'an‑ró, náva̱'a kunchaa̱‑ya̱ jíín‑ró nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Máá Espíritu ndaa̱ kúu I'a̱‑ún. Te ña̱yɨvɨ, ma̱ kúu kuatá'ú‑i‑ya̱, chi̱ tú kánde̱'é‑i nuu̱‑yá ni tú kájini̱‑i‑ya̱. Ko máá‑ró, chi̱ kájini̱‑ro̱‑yá, chi̱ ncháá‑ya̱ jíín‑ró, te ku'un‑ya̱ iní‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma̱ skéndo̱o ndá'ú‑ri̱ róó, chi̱ nchaa̱‑ri̱ nuu̱‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ɨɨn tí'lí‑na̱ te ma̱ kuní‑ga̱ ñu̱yɨ́vɨ núu̱‑rí. Ko máá‑ró chi̱ kuni̱‑ro̱ rúu̱, chi̱ chakú‑ri̱. Te ja̱ yúán suni kuchaku̱ máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Te kɨvɨ̱‑ún kuni̱‑ro̱ já kánchaa̱‑ri̱ jíín máá Táa̱‑ri̱, te máá‑ró jíín rúu̱, te máá‑rí jíín máá‑ró jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nú ndé cha̱a ñú'un ini̱‑de tiñu ni̱ tá'ú‑rí, te skíkuu‑de, cha̱a‑ún kúu ja̱ maní jíín‑rí. Te nú mani̱‑dé jíín‑rí, suni kumani̱ máá Táa̱‑ri̱ jíín‑de. Te máá‑rí, kumani̱‑rí jíín‑de te stá'a̱n ndiji̱n‑ri̱ máá‑rí nuu̱‑dé, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Te ni̱ ka'a̱n Judas jíín‑yá (ko nasu̱ú Iscariote): Táta̱, naja̱ stá'a̱n ndiji̱n‑ní máá‑ní nuu̱‑ná jíná'an‑ná, te nuu̱ ñáyɨvɨ chi̱ túu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Te ni̱ ka'a̱n Jesús jíín‑de: Nú ndé cha̱a mani̱‑dé jíín‑rí, te skíkuu‑de tu̱'un ká'a̱n‑ri̱, yúan‑na te kumani̱ máá Táa̱‑ri̱ jíín‑de. Te cha̱koyo‑ri̱ nuu̱‑dé. Te kuxiu̱kú‑rí jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Te cha̱a tú mani̱ jíín‑rí, tú skíkuu‑de tu̱'un ká'a̱n‑ri̱. Te tu̱'un ni̱ ka̱jini so̱'o‑ró, nasu̱ tú'un máá‑rí kúu, chi tu̱'un máá Táa̱‑yo̱ I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱ kúu. ");
INSERT INTO migNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tu̱'un yá'a ká'a̱n‑ri̱ jíín‑ró, nini kánchaa̱‑ri̱ jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ko máá Táa̱‑yo̱ Dios, tájí‑yá máá I'a̱ chindéé chítuu róó kii‑ya̱ jíín sɨ́'vɨ́‑rí. Te máá I'a̱‑ún kúu Espíritu Santo. Máá‑yá, stá'a̱n‑ya̱ táká tu̱'un nuu̱‑ro̱, te xndáku‑ya̱ núu̱‑ro̱ táká tu̱'un ni̱ ka'a̱n‑ri̱ jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Skéndo̱o‑ri̱ tu̱'un ndéé iní jíín‑ró, tu̱'un ndéé iní máá‑rí kua̱'a‑ri̱ nuu̱‑ro̱. Nasu̱ cuenta ñu̱yɨ́vɨ, chi̱ máá‑rí kua̱'a‑ri̱ nuu̱‑ro̱. Ma̱ kúkuí'a̱ ini̱ añú‑ro̱, te ni ma̱ yú'ú‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","A ni̱ ka̱jini so̱'o‑ró já ní ka'a̱n‑ri̱ jíín‑ró: Ki'i̱n‑ri̱ te nchaa̱‑ri̱ nuu̱‑ro̱, áchí‑ri̱. Nú ni̱ kumani̱‑ro̱ jíín‑rí, te kusɨɨ̱ ndíja ini̱‑ro̱ núú, chi ni̱ ka'a̱n‑ri̱ jíín‑ró já nó'o̱n‑ri̱ nuu̱ máá Táa̱‑yo̱ Dios. Chi̱ ñá'nu‑ga̱ kúu máá Táa̱‑yo̱ vásá rúu̱. ");
INSERT INTO migNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Vina a ni̱ kastu̱'ún‑rí nuu̱‑ro̱ ondé jíín tiempo, náva̱'a nú a ni̱ kuu, te kandíja‑ró jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma̱ ká'a̱n kua'a̱‑gá‑ri̱ jíín‑ró, chi va̱i ja̱ kúñá'nu ini̱ ñu̱yɨ́vɨ yá'a. Te tú ndújíín jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ko va̱i máá, náva̱'a kuni̱ ñu̱yɨ́vɨ ja̱ maní‑rí jíín máá Táa̱‑yo̱ Dios, te nátu̱'un ni̱ tá'ú máá Táa̱‑yo̱ Dios tiñu nuu̱‑rí, suni súan sá'a‑ri̱. Ndukuiñi̱ ná chó'o̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Máá‑rí kúu máá yó'o uva ndija. Te máá Táa̱‑ri̱ kúu I'a̱ jítu ja'a̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta̱ká nda'a já ndítɨ̱ɨn ruu̱ te tú já'a nde'e̱, jánchaa̱‑ya̱. Te ta̱ká nda'a já já'a nde'e̱, násándoo‑ya̱ náva̱'a kua̱'a‑ga̱ nde'e̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Te máá‑ró a ni̱ ka̱ndundoo‑ró jíín tú'un ni̱ ka'a̱n‑ri̱ jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ná kúxiu̱kú‑ró jíín‑rí, te máá‑rí jíín máá‑ró. Ɨɨn nda'a uva, ma̱ kúu kua̱'a máá ndé'e̱, te nú tú kutɨ̱ɨn jika̱ máá yó'o. Te suni súan róó, te nú tú kuxiu̱kú‑ró jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Máá‑rí kúu yo'o‑ún, te máá‑ró kákuu nda'a‑rí. Cha̱a ja̱ kánchaa̱ jíín‑rí, te máá‑rí jíín máá‑de, cha̱a‑ún já'a kua'a̱ ndé'e̱. Chi̱ nú túu ruu̱, te ma̱ kúu kutɨ sá'a ni ɨɨn‑ró jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Cha̱a ja̱ tú kánchaa̱ jíín‑rí, kenda‑de ki'i̱n‑de, sá'a‑ya̱. Te ichi̱ nátu̱'un ɨɨn nda'a sáni, ja̱ nástútú‑i, te taan‑í nuu̱ ñú'u̱n, te kayu̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nú káxiu̱kú‑ró jíín‑rí te tu̱'un ká'a̱n‑ri̱ ñú'un ini̱‑ro̱. Yúan‑na te kaka̱n na̱ún kákuni̱‑ro̱, te kua̱'a‑ri̱ nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nú kája̱'a‑ró kuá'a̱ ndé'e̱, yúan‑na te nduñá'nu Táa̱‑ri̱ sá'a, te súan kuu‑ró cháa káskuá'a jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nátu̱'un máá Táa̱‑yo̱ kúndá'ú ini̱‑ya̱ rúu̱, suni súan kúndá'ú ini̱‑ri̱ róó jíná'an‑ró. Núsáá te kukuu‑ga̱‑ro̱ jíín tú'un kúndá'ú ini̱‑ri̱ róó. ");
INSERT INTO migNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nú skíkuu‑ró tíñu ni̱ tá'ú‑rí nuu̱‑ro̱, te nene̱ kundá'ú ini̱‑ri̱ róó. Nátu̱'un máá‑rí ni̱ skíkuu‑ri̱ tiñu ni̱ tá'ú Táa̱‑ri̱ nuu̱‑rí, te nene̱ kúndá'ú ini̱‑ya̱ rúu̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Tu̱'un yá'a ká'a̱n‑ri̱ jíín‑ró, náva̱'a ná kúkútu‑ro jíín tú'un kúsɨɨ̱ iní máá‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ya̱'á kúu tiñu tá'ú‑rí: Ja̱ ná kúndá'ú ini̱‑ro̱ tá'an‑ró, nátu̱'un kúndá'ú ini̱‑ri̱ róó jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nú ɨɨn cha̱a kuu̱‑de ja'a̱ amigo‑de, tuká ɨnga̱ modo ja̱ kúndá'ú‑ga̱ ini̱‑i‑de nátu̱'un ni̱ sá'a cha̱a‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Máá‑ró kákuu amigo‑ri̱ nú skíkuu‑ró táká tiñu tá'ú‑rí nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tuká skúnání‑rí róó mozo. Chi̱ ɨɨn mozo, tú jiní‑de na̱ún sá'a jito'o̱‑de. Chi̱ sua skúnání‑rí róó amigo‑ri̱, chi̱ a ni̱ kastu̱'ún‑rí nuu̱‑ro̱ táká tu̱'un ni̱ jini so̱'o‑ri̱ onde̱ nuu̱ máá Táa̱‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tú ní káka̱ji‑ró rúu̱. Chi̱ sua ni̱ ka̱ji‑ri̱ róó, te ni̱ jani‑ri̱ róó ja̱ kíngoyo‑ró te kua̱'a‑ró ndé'e̱. Te ma̱ náa ndé'e̱‑ro̱. Te ta̱ká ja̱ kakán‑ro̱ núu̱ máá Táa̱‑yo̱ Dios jíín sɨ́'vɨ́‑rí, kua̱'a‑ya̱ núu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tiñu yá'a tá'ú‑rí nuu̱‑ro̱: Ja̱ ná kúndá'ú ini̱‑ro̱ tá'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Te nú kiti̱ ini̱ ta̱ká ña̱yɨvɨ núu̱‑ro̱ jíná'an‑ró, te ma̱ náa iní‑ro̱ já súni ni̱ kiti̱ ini̱‑i nuu̱ máá‑rí xna'a̱n‑ga̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Te nú cha̱a ñu̱yɨ́vɨ ní kákuu‑ró, te kumani̱ ñáyɨvɨ jíín róó nátu̱'un jíín tá'an máá‑i núú. Ko nasu̱ cháa ñu̱yɨ́vɨ kákuu‑ró, chi̱ sua ni̱ ka̱ji‑ri̱ róó ini̱ ñu̱yɨ́vɨ. Ja̱ yúán kákiti̱ ini̱ ña̱yɨvɨ núu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ma̱ náa iní‑ro̱ tú'un ni̱ ka'a̱n‑ri̱ jíín‑ró: Ɨɨn mozo, tú kúñá'nu‑ga̱‑de nuu̱ jíto'o̱‑de. Nú ni̱ ka̱chindiki̱n‑i ruu̱ suni súan chindiki̱n‑i róó. Nú ni̱ skíkuu‑i tu̱'un ni̱ ka'a̱n‑ri̱, suni skíkuu‑i tu̱'un ka'a̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ko ta̱ká tiñu yá'a sá'a‑de jíín‑ró ja̱ sɨkɨ́ sɨ́'vɨ́‑rí, chi̱ tú kájini̱‑i I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nú tú ní kíi‑ri̱, ni nú tú ní ká'a̱n‑ri̱ jíín‑i, ma̱ kóo kua̱chi‑i núú. Ko vina ma̱ kúu ka̱ku‑i nuu̱ kuáchi‑i. ");
INSERT INTO migNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ña̱yɨvɨ kájito u'u̱ ruu̱, suni kájito u'u̱‑i máá Táa̱‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nú tú ní sá'a‑ri̱ tiñu nuu̱‑í ja̱ ní ɨɨn cha̱a tú ní sá'a, te ma̱ kóo kua̱chi‑i núú. Ko vina a ni̱ kajini̱‑i tiñu‑ún, te kájito u'u̱‑i ruu̱ jíín máá Táa̱‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ko súan kásá'a‑i náva̱'a skíkuu tu̱'un yóso núu̱ tutú ley máá‑i: Ja̱ tú na̱ kua̱chi‑ri̱, te ni̱ ka̱jito u'u̱‑i ruu̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ko onde̱ nuu̱ máá Táa̱‑yo̱ tájí‑rí máá I'a̱ chindéé chítuu róó. Máá Espíritu ndaa̱ kúu‑ya̱, te onde̱ chi̱i máá Táa̱‑yo̱ Dios kénda‑ya̱. Te nú a ni̱ chaa̱‑ya̱, te kani ndaa̱‑ya̱ tú'un‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Te suni máá‑ró kani ndaa̱‑ro̱ tú'un, chi̱ ká'i̱in‑ró jíín‑rí onde̱ kɨvɨ̱ ní kejá'á‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Tu̱'un yá'a ni̱ ka'a̱n‑ri̱ jíín‑ró náva̱'a tú nayu̱'ú‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Te ské'ichi̱‑i róó ini̱ ve̱'e sinagoga ki̱ngoyo‑ró. Te jaa̱ hora ja̱ nú ɨɨn cha̱a ka'ni‑dé róó, te kani ini̱‑de ja̱ bueno ni̱ sá'a‑de nuu̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Te tiñu yá'a sá'a‑i jíín‑ró, chi̱ tú kájini̱‑i nuu̱ máá Táa̱‑yo̱ Dios, te ni nuu̱ máá‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ko ni̱ ka'a̱n‑ri̱ tu̱'un yá'a jíín‑ró náva̱'a nú a ni̱ jaa̱ hora, te nuku̱'un ini̱‑ro̱ já súan ni̱ ka'a̱n‑ri̱ jíín‑ró. Te tú ní ká'a̱n‑ri̱ tu̱'un yá'a jíín‑ró ondé kɨvɨ̱ ní kejá'á‑rí, chi̱ jíka‑ri̱ jíín‑ró jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Te vina, chi̱ no'o̱n‑ri̱ nuu̱ I'a̱ ni̱ tájí rúu̱ va̱i‑ri̱. Te ni̱ ɨɨn róó, na̱ tú kaka̱ tu̱'ún‑ró rúu̱: Ndénu̱ kí'i̱n‑ní. ");
INSERT INTO migNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Te vina a ni̱ kuxíí iní‑ro̱ chi̱ súan ni̱ ka'a̱n‑ri̱ jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ko ká'a̱n ndaa̱‑ri̱ jíín‑ró: Ja̱ sɨkɨ́ róó kúu ja̱ kánúú kí'i̱n‑ri̱. Chi̱ nú tú ki'i̱n‑ri̱, te I'a̱ chindéé chítuu róó, ma̱ cháa̱‑ya̱ núu̱‑ro̱ jíná'an‑ró. Nú ki'i̱n‑ri̱, te tájí‑rí‑ya̱ kíi‑ya̱ núu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Te nú a ni̱ chaa̱‑ya̱ te stá'a̱n‑ya̱ núu̱‑í ja̱ ndíso máá‑i kua̱chi, jíín já kúu tiñu ndaa̱, jíín ndasa náku̱xndíi‑ya̱‑í. ");
INSERT INTO migNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Máá kuáchi‑ún kúu ja̱ tú kákandíja‑i ruu̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Te máá tíñu ndaa̱‑ún kúu ja̱ nó'o̱n‑ri̱ nuu̱ máá Táa̱‑yo̱ Dios, te ma̱ kuní‑ga̱‑ro̱ núu̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Te tu̱'un náku̱xndíi‑ún kúu ja̱ á ni̱ jáku̱xndíi‑ya̱ sɨkɨ́ máá já kúñá'nu ini̱ ñu̱yɨ́vɨ yá'a. ");
INSERT INTO migNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ió kua'a̱‑gá tu̱'un ka'a̱n‑ri̱ jíín‑ró, ko ma̱ kánda‑ró jíín vína. ");
INSERT INTO migNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Te nú ni̱ chaa̱ máá Espíritu ndaa̱, máá‑yá stá'a̱n‑ya̱ táká tu̱'un ndaa̱ nuu̱‑ro̱. Chi̱ tú ka'a̱n‑ya̱ já kuní máá‑yá, chi̱ ka'a̱n‑ya̱ táká ja̱ jíni so̱'o‑ya̱. Te stá'a̱n‑ya̱ táká tiñu chaa̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Te nduñá'nu‑ri̱ sá'a‑ya̱, chi̱ ki'in‑ya̱ tú'un xíin máá‑rí, te stá'a̱n‑ya̱ núu̱‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ta̱ká ja̱ xíin máá Táa̱‑yo̱, suni máá‑rí xíin. Ja̱ yúán ní ka'a̱n‑ri̱ ja̱ kí'in‑ya̱ já xíin máá‑rí te stá'a̱n‑ya̱ núu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ɨɨn tí'lí‑na̱, te ma̱ kuní‑ga̱‑ro̱ núu̱‑rí. Te suni ɨɨn tí'lí‑ga̱, te nakuni̱ tuku‑ró núu̱‑rí, chi̱ no'o̱n‑ri̱ nuu̱ máá Táa̱‑yo̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yúan‑na te sava cha̱a káskuá'a jíín‑yá ni̱ kaka'a̱n‑de jíín tá'an‑de: Na̱ún kúu tu̱'un ni̱ ka'a̱n‑ya̱ jíín‑yó: Ɨɨn tí'lí‑na̱ te ma̱ kuní‑ga̱‑ro̱ núu̱‑rí, te suni ɨɨn tí'lí‑ga̱, te nakuni̱ tuku‑ró núu̱‑rí, chi̱ no'o̱n‑ri̱ nuu̱ Táa̱‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Te ni̱ kaka'a̱n‑ga̱‑de: Na̱ún tu̱'un kúu ja̱ ní ka'a̱n‑ya̱ jíín‑yó: Ɨɨn tí'lí‑na̱. Tú kájuku̱'un ini̱‑yo̱ já ká'a̱n‑ya̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Te ni̱ jini̱ Jesús ja̱ kaká tu̱'ún‑de‑ya̱ kákuni̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Á kájika̱ tu̱'ún tá'an‑ró já ní ka'a̱n‑ri̱ tu̱'un yá'a jíín‑ró: Ɨɨn tí'lí‑na̱, te ma̱ kuní‑ga̱‑ro̱ núu̱‑rí, te suni ɨɨn tí'lí‑ga̱, te nakuni̱ tuku‑ró núu̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró: Nde'e̱‑ro̱ te ndukuí'a̱ ini̱‑ro̱, ko kusɨɨ̱ iní ña̱yɨvɨ ñúyɨ́vɨ. Te kukuí'a̱ ini̱‑ro̱, ko va̱sa kákukuí'a̱ ini̱‑ro̱, te ndusɨɨ̱ iní‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ɨɨn ñasɨ́'ɨ́, nú já'ncha̱ chi̱i‑ña, te kúkuí'a̱ ini̱‑ña, chi̱ kuaku̱yani skáku‑ña. Te nú a ni̱ skáku‑ña ɨ́ɨn su̱chí lúlí, tuká ná'án‑ña túndó'o ni̱ ta'a̱n‑ña, chi̱ kúsɨɨ̱ iní‑ña já ní kaku ɨɨn cha̱a ini̱ ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Suni súan máá‑ró, kákukuí'a̱ ndija ini̱‑ro̱ vína. Ko ɨnga̱ kɨvɨ̱ te nakuni̱‑ri̱ nuu̱‑ro̱ te kusɨɨ̱ iní‑ro̱. Te ma̱ ndúkuí'a̱‑ga̱ ini̱‑ro̱ jíná'an‑ró sá'a ni ɨɨn ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Te kɨvɨ̱‑ún tú na̱ún kaká tu̱'ún‑ró rúu̱. Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, nú na̱ún kakán‑ro̱ núu̱ máá Táa̱‑yo̱ jíín sɨ́'vɨ́‑rí, te kua̱'a‑ya̱ núu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Onde̱ vina te tú na̱ún ní kájika̱n kutɨ‑ro jíín sɨ́'vɨ́‑rí. Kaka̱n, te ni'i̱n‑ro̱, náva̱'a kusɨɨ̱ vá'a ini̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Tu̱'un yá'a ká'a̱n yátá‑rí jíín‑ró. Ko ɨɨn kɨvɨ̱ te ma̱ ká'a̱n yátá‑gá‑ri̱ jíín‑ró, chi̱ sua kastu̱'ún kájí‑rí ta̱ká tu̱'un máá Táa̱‑yo̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Te kɨvɨ̱‑ún, kaka̱n‑ro̱ jíín sɨ́'vɨ́‑rí. Te tú ká'a̱n‑ri̱ jíín‑ró já kakán ta'u̱‑rí nuu̱ máá Táa̱‑yo̱ já sɨkɨ́ róó. ");
INSERT INTO migNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Chi̱ máá Táa̱‑yo̱, kúndá'ú ini̱‑ya̱ róó. Chi̱ máá‑ró ni̱ ka̱kumani̱‑ro̱ jíín‑rí, te ni̱ ka̱kandíja‑ró já ondé nuu̱ Dios va̱i‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ni̱ kenda‑ri̱ onde̱ nuu̱ máá Táa̱‑yo̱, te ni̱ chaa̱‑ri̱ ini̱ ñu̱yɨ́vɨ. Vina te kenda tuku‑ri̱ ini̱ ñu̱yɨ́vɨ te no'o̱n‑ri̱ nuu̱ máá Táa̱‑yo̱ Dios. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Te ni̱ kaka'a̱n cha̱a káskuá'a jíín‑yá: Vina te ká'a̱n kájí‑ní. Tú ká'a̱n‑ní ni ɨɨn tu̱'un yátá. ");
INSERT INTO migNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vina te kájuku̱'un ini̱‑ná ja̱ jiní‑ní ta̱ká tu̱'un, te tú jínu ñú'ún‑ní ja̱ kaká tu̱'ún‑i níí. Ja̱ yúán kákandíja‑ná ja̱ ní kenda ndija‑ní onde̱ nuu̱ Dios va̱i‑ní. Achí‑de jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Te ni̱ ka'a̱n Jesús jíín‑de: Vina te kákandíja‑ró náún. ");
INSERT INTO migNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kuni so̱'o‑ró, chi va̱i ɨɨn hora, te a ni̱ chaa̱, ja̱ kuichá nu̱u‑ró kíngoyo‑ró vé'e‑ró. Te skéndo̱o‑ró rúu̱ máá ɨ́ɨn‑ri̱. Ko ma̱ kúnchaa̱ máá ɨ́ɨn‑ri̱, chi̱ máá Táa̱‑yo̱ Dios kánchaa̱‑ya̱ jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tu̱'un yá'a ká'a̱n‑ri̱ jíín‑ró náva̱'a koo ndéé iní‑ro̱ sá'a‑ri̱. Ini̱ ñu̱yɨ́vɨ, chi̱ koto‑ró túndó'o. Ko kava téyíí‑ró, chi̱ a ni̱ kundéé‑rí jíín ñúyɨ́vɨ, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tu̱'un yá'a ni̱ ka'a̱n Jesús. Te ni̱ ndakoto‑ya̱ íchi ándɨ́vɨ́. Te ni̱ ka'a̱n‑ya̱: Táa̱, a ni̱ chaa̱ máá hora. Sáñá'nu‑ní Se̱'e‑ní, náva̱'a suni Se̱'e‑ní sáñá'nu‑i níí. ");
INSERT INTO migNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Chi ni̱ ja̱'a‑ní fuerza nuu̱ máá Sé'e sɨkɨ̱ táká cha̱a, náva̱'a nuu̱ táká cha̱a ni̱ ja̱'a‑ní nuu̱‑í, kua̱'a‑i ja̱ kúchaku̱‑de nɨ́ɨ́ káni. ");
INSERT INTO migNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Te tu̱'un kuchaku̱ nɨ́ɨ́ káni kúu ja̱ ná kuní‑de níí ja̱ máá ɨ́ɨn ndija‑ni Dios kúu‑ní onde̱ jíín Jesucristo I'a̱ ni̱ tájí‑ní va̱i. ");
INSERT INTO migNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Máá‑ná, ni̱ sáñá'nu‑ná níí ini̱ ñu̱yɨ́vɨ. A ni̱ síjínu‑ná tiñu ni̱ tá'ú‑ní nuu̱‑ná. ");
INSERT INTO migNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Te vina Táa̱, sáñá'nu‑ní náá, ná kuní jíín núu̱ máá‑ní, nátu̱'un ni̱ kuñá'nu‑ná jíín‑ní onde̱ ná té jungo̱o‑ga̱ ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ni̱ stá'a̱n ndiji̱n‑ná níí jíín sɨ́'vɨ́‑ní nuu̱ táká cha̱a ni̱ ja̱'a‑ní nuu̱‑ná ini̱ ñu̱yɨ́vɨ. Máá‑ní ni̱ xíin‑dé núú. Te ni̱ ja̱'a‑ní‑de nuu̱‑ná. Te ni̱ ka̱skíkuu‑de tu̱'un‑ní. ");
INSERT INTO migNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Vina te a kájini̱‑de ja̱ ondé nuu̱ máá‑ní va̱i ta̱ká tu̱'un ni̱ ja̱'a‑ní nuu̱‑ná. ");
INSERT INTO migNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Chi tu̱'un ni̱ ja̱'a‑ní nuu̱‑ná, ni̱ ja̱'a‑ná nuu̱ máá‑de jíná'an‑de. Te ni̱ ka̱jatá'ú‑de tu̱'un‑ún. Te a ni̱ kajini̱ ndaa̱‑de ja̱ ní kenda‑ná onde̱ nuu̱‑ní. Te ni̱ ka̱kandíja‑de ja̱ ní tájí‑ní náá va̱i‑ná. ");
INSERT INTO migNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Te jikán ta'u̱‑ná ja'a̱ máá‑de. Tú jikán ta'u̱‑ná ja'a̱ ñúyɨ́vɨ, chi̱ sua jikán ta'u̱‑ná ja'a̱ cháa ni̱ ja̱'a‑ní nuu̱‑ná, chi̱ máá‑ní xíin‑dé. ");
INSERT INTO migNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Te ta̱ká ndatíñu‑ná kúu ndatíñu máá‑ní. Te ta̱ká ndatíñu máá‑ní kúu ndatíñu máá‑ná. Te ni̱ nduñá'nu‑ná ni̱ sá'a ndatíñu‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Te tuká kánchaa̱‑ná ini̱ ñu̱yɨ́vɨ. Ko máá‑de chi̱ káxiu̱kú‑de ini̱ ñu̱yɨ́vɨ, te máá‑ná nájaa̱‑ná nuu̱‑ní. Táa̱, máá‑ní kúu I'a̱ ndoo, te jíín sɨ́'vɨ́‑ní koto‑ní ta̱ká cha̱a ni̱ ja̱'a‑ní nuu̱‑ná, náva̱'a ɨɨn‑ni ná kúu‑de nátu̱'un kákuu máá‑yó. ");
INSERT INTO migNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ná ni̱ kanchaa̱‑ná jíín‑de ini̱ ñu̱yɨ́vɨ, te ni̱ ndi̱to‑ná‑de jíín sɨ́'vɨ́‑ní ja̱ ní ja̱'a‑ní nuu̱‑ná. Ni̱ ndi̱to‑ná‑de te tú ní náa ní ɨɨn‑de, chi̱ máá‑ni se̱'e kui'na̱ ní naa, náva̱'a skíkuu tutu̱ ii̱. ");
INSERT INTO migNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Te vina najaa̱‑ná nuu̱‑ní. Te ká'a̱n‑ná tu̱'un yá'a ini̱ ñu̱yɨ́vɨ náva̱'a ná kúsɨɨ̱ vá'a ini̱‑de jíín tú'un kúsɨɨ̱ iní máá‑ná. ");
INSERT INTO migNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ni̱ kastu̱'ún‑ná tu̱'un‑ní nuu̱‑dé. Te ni̱ kakiti̱ ini̱ ña̱yɨvɨ núu̱‑dé, chi̱ nasu̱ sé'e ñu̱yɨ́vɨ kákuu‑de nátu̱'un máá‑ná nasu̱ sé'e ñu̱yɨ́vɨ kúu‑ná. ");
INSERT INTO migNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na̱ tú jikán ta'u̱‑ná ja̱ cháxio‑ní‑de ini̱ ñu̱yɨ́vɨ, chi̱ sua koto‑ní‑de nuu̱ kíni nuu̱ kuí'a̱. ");
INSERT INTO migNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nasu̱ tá'an ñu̱yɨ́vɨ kákuu‑de. Nátu̱'un máá‑ná nasu̱ tá'an ñu̱yɨ́vɨ kúu‑ná. ");
INSERT INTO migNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nasándoo‑ní‑de jíín tú'un ndaa̱. Tu̱'un máá‑ní kúu máá tú'un ndaa̱. ");
INSERT INTO migNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nátu̱'un ni̱ tájí‑ní náá va̱i‑ná ini̱ ñu̱yɨ́vɨ, suni súan tájí‑ná‑de ki'i̱n‑de ini̱ ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Te ja̱ sɨkɨ́ máá‑de kúu ja̱ sándoo‑ná máá‑ná, náva̱'a koo ndoo máá‑de jíín tú'un ndaa̱. ");
INSERT INTO migNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Tú jikán ta'u̱‑ná ja'a̱ máá ɨ́ɨn cha̱a yá'a jíná'an‑de, chi̱ suni ja'a̱ táká ña̱yɨvɨ já ná kándíja‑i náá sá'a tu̱'un kani‑de jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Náva̱'a ta̱ká‑i ná kúu‑i ɨɨn‑ni, nátu̱'un kánchaa̱‑ní jíín‑ná, Táa̱, te máá‑ná jíín máá‑ní. Te suni súan ná kúu‑i ɨɨn‑ni jíín‑yó kuní‑ná, náva̱'a ná kándíja ñu̱yɨ́vɨ já máá‑ní ni̱ tájí‑ní náá va̱i‑ná. ");
INSERT INTO migNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A ni̱ sáñá'nu‑ná máá‑de nátu̱'un ni̱ sáñá'nu‑ní náá, náva̱'a ɨɨn‑ni ná kúu‑de nátu̱'un ɨɨn‑ni kákuu‑yó. ");
INSERT INTO migNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Te nátu̱'un máá‑ná jíín máá‑de, te máá‑ní jíín máá‑ná, suni súan kuní‑ná ja̱ ná síyíja‑ní‑de náva̱'a ɨɨn‑ni ná kúu‑de, te náva̱'a kuni̱ ña̱yɨvɨ já ní tájí‑ní náá va̱i‑ná, jíín já kúndá'ú ini̱‑ní‑de nátu̱'un kúndá'ú ini̱‑ní náá. ");
INSERT INTO migNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Táa̱, ta̱ká cha̱a ni̱ ja̱'a‑ní nuu̱‑ná‑ún, kuní‑ná ja̱ núu̱ kúnchaa̱ máá‑ná suni yúan ná kúxiu̱kú máá‑de jíín‑ná, náva̱'a ná kuní‑de ndasa ndúñá'nu‑ná sá'a‑ní. Chi̱ kúndá'ú ini̱‑ní náá onde̱ ná té jukuiñi̱‑ga̱ ñu̱yɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Táa̱, máá‑ní kúu I'a̱ ndaa̱, ko tú kájini̱ ta̱ká ña̱yɨvɨ núu̱‑ní. Ko máá‑ná chi̱ jiní‑ná nuu̱‑ní. Te cha̱a yá'a, kájini̱‑de ja̱ ní tájí‑ní náá va̱i‑ná. ");
INSERT INTO migNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Te máá‑ná, a ni̱ stá'a̱n‑ná níí jíín sɨ́'vɨ́‑ní nuu̱‑dé. Te stá'a̱n‑ga̱‑ná nuu̱‑dé, náva̱'a ná kúndá'ú ini̱‑de tá'an‑de nátu̱'un kúndá'ú ini̱‑ní náá, te suni náva̱'a kunchaa̱‑ná jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Te ni̱ kuu, ni̱ ka'a̱n Jesús tu̱'un yá'a. Te ni̱ kenda‑ya̱ jíín cháa káskuá'a jíín yá kua'a̱n‑ya̱ yatá yúcha Cedrón, nuu̱ íó ɨɨn jardín. Te yúan ni̱ kɨ̱vɨ‑ya̱ jíín cháa káskuá'a jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Te Judas ja̱ ní nastúu‑ya̱‑ún, suni jiní‑de lugar yúan, chi̱ íó kua'a̱ vuelta ni̱ ketá'an Jesús yúan jíín cháa káskuá'a jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Te ni̱ jaka Judas ɨɨn nuu soldado jíín yakú ndajá'a̱ sutú ñá'nu jíín cháa fariseo, te ni̱ ja̱koyo‑de yúan jíín linterna jíín ñú'u̱n yitɨ jíín machete. ");
INSERT INTO migNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yúan‑na te Jesús, ja̱ á ni̱ jini̱‑ya̱ táká tu̱ndó'o va̱i sɨkɨ̱‑yá, ni̱ kenda‑ya̱ íchi núu̱‑dé. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ndé cha̱a kánandúkú‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Te ni̱ kaka'a̱n‑de jíín‑yá: Jesús ñuu̱ Nazaret kánandúkú‑rí, áchí‑de. Te ni̱ ka'a̱n Jesús: Máá‑rí kúu, áchí‑ya̱ jíín‑de. Te Judas, cha̱a ni̱ nastúu‑ya̱‑ún, suni kándii̱‑de jíín cháa‑ún jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Te ja̱ súan ni̱ ka'a̱n‑ya̱, máá‑rí kúu, te ni̱ ka̱nakaka yátá‑de. Te ni̱ kandua̱‑ni‑de nuu̱ ñú'un. ");
INSERT INTO migNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Te ni̱ jika̱ tu̱'ún tuku‑ya̱‑dé: Ndé cha̱a kánandúkú‑ró, áchí‑ya̱. Te ni̱ kaka'a̱n‑de: Jesús ñuu̱ Nazaret, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Te ni̱ ka'a̱n Jesús: A ni̱ ka'a̱n‑ri̱ jíín‑ró ja̱ máá‑rí kúu. Te nú ruu̱ kánandúkú‑ró, te sía̱ cha̱a yá'a ná kíngoyo‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Súan ni̱ kuu náva̱'a ná skíkuu tu̱'un ja̱ ní ka'a̱n‑ya̱: Tú ní xnáa‑ná ni ɨɨn cha̱a ni̱ ja̱'a‑ní nuu̱‑ná, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yúan‑na te Simón Pedro, ja̱ ñáva̱'a‑de ɨɨn machete, ni̱ tava‑dé. Te ni̱ stují‑ni‑de mozo máá sutú ñá'nu‑ga̱. Te ni̱ kachi‑de so̱'o lado vá'a. Te mozo‑ún, nání Malco. ");
INSERT INTO migNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Te ni̱ ka'a̱n Jesús jíín Pedro: Nachiva̱'a machete‑ro̱ iní cubierta. Chi tu̱ndó'o yá'a ja̱ ní ja̱'a Táa̱‑ri̱ nuu̱‑rí, tú kánúú já ndó'o‑ri̱ náún. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yúan‑na te soldado, jíín cháa kuñá'nu, jíín ndájá'a̱ cháa judío, ni̱ ka̱katɨɨn‑de Jesús, te ni̱ kaju'ni̱‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Te xna'a̱n‑ga̱ ni̱ kaja̱ncha̱ka‑de‑ya̱ núu̱ Anás. Chi̱ táchi̱só Caifás ni̱ kuu‑de. Te Caifás, ni̱ kuu‑de máá sutú ñá'nu‑ga̱ kuia̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Te Caifás kúu máá cháa ni̱ ja̱'a consejo nuu̱ cháa judío, ja̱ jínu ñú'ún já kúu̱ ɨɨn cha̱a ja'a̱ ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Te Simón Pedro, ndikín‑de Jesús kua'a̱n‑de jíín‑yá, jíín ɨngá cha̱a skuá'a. Te cha̱a‑ún, jiní sutu̱ ñá'nu nuu̱‑dé. Te ni̱ kɨ̱vɨ‑de ini̱ Palacio jíín Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ko Pedro, ni̱ kandii̱‑ni‑de ichi yúxé'é yatá vé'e. Te máá cháa skuá'a ja̱ jiní sutu̱ ñá'nu‑ga̱ nuu̱‑dé, ni̱ kenda‑de, te ni̱ ka'a̱n‑de jíín ñá'an ndíto yuxé'é. Te ni̱ skɨ́vɨ‑de Pedro ini̱ ve̱'e palacio. ");
INSERT INTO migNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yúan‑na te ña'an ndíto yuxé'é‑ún, ni̱ ka'a̱n‑ña jíín Pedro: Te róó suni ɨɨn cha̱a skuá'a jíín cháa yá'a kúu‑ró vii, áchí‑ña. Te ni̱ ka'a̱n‑de: Nasu̱ náá kúu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Te mozo‑ún jíín policía, ni̱ ka̱nastá'a̱n‑de ñu'u̱n, chi̱ sá'a vi̱jin. Te ká'i̱in‑de kánduvixi̱‑de. Te Pedro, suni kándii̱‑de yúan, ndúvixi̱‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Te sutu̱ ñá'nu‑ga̱, ni̱ xndichí‑de Jesús sɨkɨ̱ cháa káskuá'a jíín‑yá jíín sɨkɨ́ tú'un stá'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Te ni̱ ka'a̱n Jesús: A ni̱ ka'a̱n ndiji̱n‑ri̱ ini̱ ñu̱yívɨ. Nene̱ ni̱ stá'a̱n‑ri̱ tu̱'un ini̱ ve̱'e sinagoga jíín iní ve̱'e ii̱, nuu̱ ndútútú ndɨ́'ɨ ña̱yɨvɨ judío, te tú ni ɨɨn tu̱'un ní ká'a̱n sa̱'í‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Naja̱ jiká tu̱'ún‑ró rúu̱. Kaka̱ tu̱'ún ñáyɨvɨ ní ka̱jini so̱'o tu̱'un ni̱ ka'a̱n‑ri̱ nú na̱ún ní ka'a̱n‑ri̱, chi̱ máá‑i káiná'án‑i tu̱'un ni̱ ka'a̱n‑ri̱ jíín‑i, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Te ja̱ súan ni̱ ka'a̱n Jesús, te ɨɨn mozo kándii̱ yúan, ni̱ ja̱'a‑ni ɨɨn ji̱kí núu̱ Jesús. Te ni̱ ka'a̱n jíín‑yá: Súan ká'a̱n‑ro̱ jíín sutú ñá'nu náún, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Te ni̱ ka'a̱n Jesús jíín: Nú ni̱ ka'a̱n ndɨva̱'a‑ri̱, te kastu̱'ún na̱ún kúu tu̱'un ñáá ní ka'a̱n‑ri̱‑ún. Ko nú tu̱'un va̱'a ni̱ ka'a̱n‑ri̱, te naja̱ stují‑ro̱ rúu̱ núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Te Anás ni̱ tájí‑de‑ya̱ nú'ni̱‑ya̱ kuá'a̱n‑ya̱ núu̱ Caifás ja̱ kúu máá sutú ñá'nu‑ga̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Te kándii̱ Simón Pedro ndúvixi̱‑de. Te ni̱ kaka'a̱n jíín‑de: Nasu̱ cháa skuá'a jíín‑de kúu‑ró náún, áchí. Te máá‑de, tú ní játu̱'un‑de: Nasu̱ rúu̱ kúu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Te ɨɨn mozo sutu̱ ñá'nu‑ga̱, tá'an ja̱ ní xɨtɨ Pedro so̱'o‑ún, ni̱ ka'a̱n jíín‑de: Nasu̱ ní jini̱‑ri̱ róó jíín‑de ini̱ jardín náún, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Te Pedro, tú ní játu̱'un tuku‑de. Te ni̱ kana‑ni lí'li. ");
INSERT INTO migNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yúan‑na te ni̱ ka̱ndenda‑de jíín Jesús ini̱ ve̱'e Caifás kája'a̱n‑de jíín‑yá onde̱ ini̱ ve̱'e palacio. Te ja̱ñá'a̱n kúu. Te ña̱yɨvɨ judío, tú ní kɨ́vɨ koyo‑i ini̱ ve̱'e palacio, chi̱ tú kákuni̱‑i kuchá'án‑i. Chi̱ nú súan te ma̱ kúu kee‑í lélú Pascua. ");
INSERT INTO migNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yúan‑na te ni̱ kenda Pilato nuu̱ ñáyɨvɨ ká'i̱in yata̱ vé'e. Te ni̱ ka'a̱n‑de: Na̱ún kua̱chi kájika̱n‑ro̱ sɨkɨ́ cháa yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Te ni̱ kaka'a̱n‑i: Cha̱a yá'a, nú tú kúu‑de cha̱a ñáá, ma̱ kínchaka‑ná‑de nuu̱‑ní núú, áchí‑i jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Te ni̱ ka'a̱n Pilato jíín‑i: Ki'in máá‑ró‑de, te sándaa̱‑ro̱ sɨkɨ́‑dé nátu̱'un ká'a̱n ley máá‑ró, áchí‑de. Te ña̱yɨvɨ judío ni̱ kaka'a̱n‑i jíín‑de: Ja̱ náá jíná'an‑ná, tú íó ley ja̱ ká'ni‑ná ni ɨɨn ña̱yɨvɨ, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Súan ni̱ kaka'a̱n‑i náva̱'a skíkuu tu̱'un ni̱ ka'a̱n Jesús, ja̱ ní kastu̱'ún‑yá na̱ún modo kuu̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Te ni̱ ndɨ̱vɨ Pilato ini̱ ve̱'e palacio. Te ni̱ kana‑de xini̱ Jesús ni̱ kɨ̱vɨ‑ya̱. Te ni̱ ka'a̱n‑de jíín‑yá: Máá‑ró kúu Rey ña̱yɨvɨ judío náún, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Te ni̱ ka'a̱n Jesús jíín‑de: Á súan jáni ini̱ máá‑ró, xí súan ni̱ kastu̱'ún sáva‑ga̱ cha̱a nuu̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Te ni̱ ka'a̱n Pilato: Cha̱a judío kúu‑ri̱ náún. Ña̱yɨvɨ máá‑ró jíín sutú ñá'nu, ni̱ kana̱kua̱'a róó nuu̱‑rí. Na̱ún ní sá'a‑ró núsáá. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Te ni̱ ka'a̱n Jesús: Nasu̱ ñúyɨ́vɨ yá'a kúu nuu̱ tá'ú‑rí tiñu. Nú ini̱ ñu̱yɨ́vɨ yá'a kúu nuu̱ tá'ú‑rí tiñu, yúan‑na te cha̱a kájatíñu nuu̱‑rí, kua̱tá'an‑de ja'a̱‑rí náva̱'a tú natu̱u‑ri̱ nuu̱ ñáyɨvɨ judío núú. Ko nasu̱ ñúyɨ́vɨ yá'a kúu nuu̱ tá'ú‑rí tiñu vina. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yúan‑na te ni̱ ka'a̱n Pilato jíín‑yá: Te ɨɨn rey kúu‑ró ja̱ súan, áchí‑de. Te ni̱ ka'a̱n Jesús: Máá‑ró ká'a̱n ja̱ rúu̱ kúu rey. Kánúú káni‑ri̱ tu̱'un ndaa̱. Ja̱ yúán ní kaku‑ri̱. Te ja̱ yúán vái‑ri̱ ini̱ ñu̱yɨ́vɨ. Ta̱ká ña̱yɨvɨ ká'i̱in jíín tú'un ndaa̱, ña̱yɨvɨ‑ún jíni ná'ín‑i tu̱'un ká'a̱n‑ri̱. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Te ni̱ ka'a̱n Pilato jíín‑yá: Na̱ún kúu tu̱'un ndaa̱, áchí‑de. Te ja̱ ní ka'a̱n‑de tu̱'un yá'a, te ni̱ kenda tuku‑de nuu̱ ñáyɨvɨ judío. Te ni̱ ka'a̱n‑de jíín‑i: Tú kutɨ ní ɨɨn kua̱chi ni'i̱n‑rí sɨkɨ̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ko íó costumbre máá‑ró já víko Pascua te nuu̱‑ro̱ sía̱‑ri̱ ɨɨn cha̱a índee veka̱a. Te kákuni̱‑ro̱ já sía̱‑ri̱ rey ña̱yɨvɨ judío nuu̱‑ro̱ xí túu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yúan‑na te ndivii‑í ni̱ ka̱kana jaa‑i ɨnga̱ jínu: Ma̱ sía̱‑ní cha̱a yá'a, chi̱ sua ná sía̱‑ní Barrabás, áchí‑i. Te cha̱a kuí'ná ní kuu Barrabás. ");
INSERT INTO migNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yúan‑na te Pilato, ni̱ ki'in‑de Jesús. Te ni̱ xndó'o‑de‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Te soldado, ni̱ ka̱tɨɨn‑de ɨɨn corona iñu. Te ni̱ kachu'un‑de xini̱‑yá. Te ni̱ ka̱chu'un‑de‑ya̱ ɨ́ɨn sa'ma kuá'á tíndí'í. ");
INSERT INTO migNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Te ni̱ ka̱kandita‑de nuu̱‑yá. Te ni̱ kaka'a̱n‑de jíín‑yá: Rey judío, ta̱á ndii, áchí‑de. Te kája̱'a‑de ji̱kí núu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Yúan‑na te ni̱ kenda Pilato ɨnga̱ jínu. Te ni̱ ka'a̱n‑de jíín ñáyɨvɨ: Yá'a nde̱'é‑ró va̱i‑ri̱ jíín‑de yata̱ vé'e, náva̱'a ná kuní‑ro̱ já tú ni ɨɨn kua̱chi ní'i̱n‑rí sɨkɨ̱‑dé, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Te ni̱ kenda Jesús yata̱ vé'e, ñú'un‑ya̱ corona iñu jíín sá'ma kuá'á tíndí'í. Te ni̱ ka'a̱n Pilato jíín‑i: Yá'a nde̱'é‑ró cháa yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Te sutu̱ ñá'nu jíín cháa kájatíñu, ni̱ kajini̱‑de nuu̱‑yá. Te ni̱ kaka'a̱n jaa‑de: Kata kaa‑ní‑de jika̱ cruz, ná kúu̱‑de, áchí‑de. Te ni̱ ka'a̱n Pilato jíín‑de: Katɨɨn máá‑ró‑de te ka'ni‑ro‑dé, chi̱ ruu̱, tú ní'i̱n‑rí ni ɨɨn kua̱chi sɨkɨ̱‑dé, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Te ni̱ kaka'a̱n judío: Máá‑ná káñava̱'a‑ná ley. Te sɨkɨ̱ ley‑ún kuu̱‑de, chi̱ áchí‑de ja̱ Sé'e Dios kúu‑de, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Te ja̱ ní jini so̱'o Pilato tu̱'un yá'a, te ví'í‑gá yú'ú‑de. ");
INSERT INTO migNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Te ni̱ ndɨ̱vɨ tuku‑de ɨnga̱ jínu ini̱ ve̱'e palacio. Te ni̱ jika̱ tu̱'ún‑de Jesús: Ndé onde̱ va̱i‑ró, áchí‑de. Ko Jesús, tú ní ká'a̱n kutɨ‑yá jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yúan‑na te ni̱ ka'a̱n Pilato jíín‑yá: Tú ka'a̱n‑ro̱ jíín‑rí náún. Á tú jiní‑ro̱ já ndíso‑ri̱ tiñu ja̱ ká'ni‑rí róó jika̱ cruz, te suni ndíso‑ri̱ tiñu ja̱ sía̱‑ri̱ róó ki'i̱n‑ro̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Te ni̱ ka'a̱n Jesús: Nú tú ní kíi tu̱'un onde̱ andɨ́vɨ́, te ma̱ kúu ndonda‑ró sɨkɨ́‑rí. Ja̱ yúán cháa ni̱ nakua̱'a ruu̱ nuu̱‑ro̱, kua̱chi xaa̱n‑gá ndíso‑de. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Te onde̱ hora yúan ndúkú ndéé Pilato sía̱‑de‑ya̱. Ko ña̱yɨvɨ judío, ni̱ kaka'a̱n jaa‑i: Nú sía̱‑ní cha̱a yá'a, te nasu̱ amigo César kúu‑ní. Chi̱ nú ɨɨn cha̱a sá'a‑de ja̱ máá‑de kúu rey, cha̱a‑ún ká'a̱n‑de sɨkɨ̱ César. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Te Pilato, ja̱ ní jini so̱'o‑de tu̱'un yá'a, ni̱ kiñi'in‑de Jesús yata̱ vé'e. Te ni̱ jungo̱o‑de ini̱ ve̱'e tíñu nuu̱ nání pavimento. (Te nuu̱ yú'u hebreo nání Gabata.) ");
INSERT INTO migNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Te máá kɨvɨ́ sátu̱'a ja̱ kóo viko Pascua kúu, nátu̱'un ka̱'iñu̱. Te ni̱ ka'a̱n‑de jíín ñáyɨvɨ judío: Yá'a nde̱'é‑ró núu̱ rey máá‑ró jíná'an‑ró, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Te ni̱ kaka'a̱n jaa‑i: Ándale, chaxio‑ní‑de, te ka'ni‑ní‑de jika̱ cruz, áchí‑i. Te ni̱ ka'a̱n Pilato jíín‑i: Ja̱ ká'ni‑rí rey máá‑ró náún, áchí‑de. Te ni̱ kaka'a̱n sutu̱ ñá'nu: Tuká ɨnga̱ rey káñava̱'a‑ná, chi̱ máá‑ni César, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yúan‑na te ni̱ nakua̱'a‑de‑ya̱ núu̱‑í ja̱ ná kúu̱‑ya̱ jiká cruz. Te ni̱ ka̱katɨɨn‑i Jesús, te kua'a̱n‑i jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Te máá‑yá, ndíso‑ya̱ cruz‑ya̱. Te ni̱ kenda‑ya̱ yúan, kua'a̱n‑ya̱ ɨ́ɨn nuu̱ nání yíkɨ xiní. Te nuu̱ yú'u hebreo nání Gólgota. ");
INSERT INTO migNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yúan ni̱ ka̱jata kaa‑i‑ya̱ jiká cruz. Te suni ni̱ ka̱jata kaa‑i uu̱ cha̱a jíín‑yá, ɨɨn ɨɨn‑de lado xiin‑yá. Te máá Jesús ni̱ ndi̱ta kaa‑ya̱ má'ñú. ");
INSERT INTO migNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Te suni ni̱ chaa Pilato ɨɨn tutu̱. Te ni̱ chitɨ̱ɨn‑de xini̱ cruz. Te súan ni̱ ka'a̱n: Jesús ñuu̱ Nazaret, Rey ña̱yɨvɨ judío, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Te kua'a̱ ñáyɨvɨ judío, ni̱ ka̱ka'u‑i tu̱'un yá'a. Chi̱ nuu̱ ní ndi̱ta kaa Jesús, máá yáni yuñúu̱ kúu. Te yóso tú'un‑ún jíín yú'u hebreo, jíín yú'u griego, jíín yú'u latín. ");
INSERT INTO migNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Te sutu̱ ñá'nu judío, ni̱ kaka'a̱n‑de jíín Pilato: Ma̱ cháa‑ní: Rey ña̱yɨvɨ judío. Chi̱ sua chaa‑ní ja̱ ní ka'a̱n‑de: Rey kúu‑ri̱ nuu̱ ñáyɨvɨ judío, achi̱‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Te ni̱ ka'a̱n Pilato: Ma̱ násama‑ri̱ ja̱ á ni̱ chaa‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Te soldado, nuu̱ ní ka̱jata kaa‑de Jesús jika̱ cruz, te ni̱ ka̱ki'in‑de sa'ma‑yá. Te ni̱ ka̱ndátá‑de kuu̱n pedazo, ɨɨn ɨɨn kuu soldado‑ún. Te suni ni̱ ka̱ki'in‑de tɨka̱chí‑yá. Ko tɨka̱chí‑ún tú ní kíku, chi̱ ni̱ kunu nɨ́ɨ́ ondé xini̱ te onde̱ nuu̱ já'a̱. ");
INSERT INTO migNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Te ni̱ kaka'a̱n máá‑de: Ma̱ ndátá‑yó, chi̱ ná sá'a‑yó ɨ́ɨn apuesto sɨkɨ̱. Te ná ndéó ndé ɨɨn‑yó ní'i̱n, áchí‑de. Súan ni̱ ka̱sá'a soldado, náva̱'a skíkuu tu̱'un ká'a̱n tutu̱ ii̱: Ni̱ kaja'ncha̱ sava‑de sa'ma‑ná, ni̱ ka̱kuu máá‑de. Te sɨkɨ̱ tɨ́ka̱chí‑ná ni̱ ka̱sá'a‑de apuesto. Achí. ");
INSERT INTO migNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Te xiin cruz Jesús ká'i̱in náa̱‑ya̱, jíín kú'u̱‑ña María, ñasɨ́'ɨ́ Cleofas, jíín María ñuu̱ Magdala. ");
INSERT INTO migNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Te ni̱ jini̱ Jesús nuu̱ náa̱‑ya̱ jíín núu̱ cháa skuá'a ja̱ maní‑yá jíín‑de. Te kándii̱ yani‑de. Te ni̱ ka'a̱n‑ya̱ jíín náa̱‑ya̱: Náa̱, jia̱n ndé'é‑ní kándii̱ se̱'e‑ní, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yúan‑na te ni̱ ka'a̱n‑ya̱ jíín cháa skuá'a‑ún: Jia̱n ndé'é‑ró kándii̱ náa̱‑ro̱, áchí‑ya̱. Te onde̱ sáá‑ni ni̱ kana‑de‑ña kuá'a̱n‑ña jíín‑de ve'e‑de. ");
INSERT INTO migNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yu̱án‑na te ni̱ jini̱ Jesús ja̱ á ni̱ ji̱nu ta̱ká tiñu. Te ni̱ ka'a̱n‑ya̱: Jichí‑ri̱ nducha, áchí‑ya̱. Súan ni̱ ka'a̱n‑ya̱ náva̱'a skíkuu tu̱'un ká'a̱n tutu̱ ii̱. ");
INSERT INTO migNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Te yúan ni̱ i̱o ɨɨn tɨndo'o̱ ñú'un chítú vinagre. Te ni̱ chindaji‑de kachi̱ núu̱ vinagre‑ún. Te ni̱ chaa‑de xini̱ ɨ́ɨn yunu. Te ni̱ ka̱chaa‑de yu'u‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Te Jesús ni̱ ji'i‑ya̱ vinagre‑ún. Te ni̱ ka'a̱n‑ya̱: A ni̱ ji̱nu, áchí‑ya̱. Te ni̱ ka̱í‑ni xini̱‑yá. Te ni̱ ji'i̱‑ni‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Te kɨvɨ̱ sátu̱'a kúu, te cha̱a judío, tú kákuni̱‑de ja̱ kuíta koyo ndɨ̱yi‑ún jika̱ cruz kɨvɨ̱ ndéta̱tú. Chi̱ va̱i kɨvɨ̱ ndéta̱tú, te ɨɨn kɨvɨ̱ kánúú xáa̱n kúu. Te ni̱ kajika̱n‑de nuu̱ Pilato ja̱ ná tá'nu̱ sɨ̱'ɨn‑i, te ná kúxio‑i jika̱ cruz. ");
INSERT INTO migNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Te ni̱ cha̱koyo soldado. Te ni̱ kaja'nu̱‑de sɨ̱'ɨn cha̱a ɨɨn, te suni súan ɨnga̱ cha̱a ja̱ ndíta kaa jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ko nuu̱ ní cha̱koyo‑de nuu̱ Jesús, ni̱ kajini̱‑de ja̱ á ni̱ ji'i̱‑ya̱. Te tú ní kája'nu̱‑de sɨ̱'ɨn‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ko ɨɨn soldado, ni̱ kaa̱n‑de xiin‑yá jíín punta machete, te ni̱ kenda‑ni nɨñi̱ jíín ndúcha. ");
INSERT INTO migNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Te ɨɨn cha̱a ni̱ jini̱‑ún, jáni‑de tu̱'un. Te tu̱'un ká'a̱n‑de‑ún, íó ndaa̱. Te máá‑de, suni jiní‑de ja̱ tú'un ndaa̱ ká'a̱n‑de, náva̱'a kandíja tuku máá‑ró jíná'an‑ró sá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Chi̱ súan ni̱ kuu, náva̱'a skíkuu tu̱'un ká'a̱n tutu̱ ii̱: Ma̱ ká'nu̱‑ro̱ ní ɨɨn yikɨ‑yá, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Te suni ɨnga̱ tu̱'un ká'a̱n tutu̱ ii̱: Nde̱'é‑de nuu̱ I'a̱ ni̱ kakaa̱n‑de, áchí. ");
INSERT INTO migNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yu̱án‑na, te íó ɨɨn cha̱a nání José ñuu̱ Arimatea, cha̱a‑ún skuá'a sa̱'í‑de jíín Jesús, chi̱ yú'ú‑de ña̱yɨvɨ judío. Te ni̱ ka'a̱n nda̱'ú‑de jíín Pilato nú kuu kuanchaa̱‑de yikɨ kúñu Jesús. Te Pilato ni̱ jatu̱'un. Yúan‑na te ni̱ jaa̱‑de. Te ni̱ xnúu‑de yikɨ kúñu Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Te Nicodemo, cha̱a ni̱ ja'a̱n nuu̱ Jesús akuáa‑ún núú, suni ni̱ jaa̱‑de ndíso‑de su̱sia ua̱ jíín jí'o áloe, nátu̱'un kuu̱n arroba. ");
INSERT INTO migNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Te ni̱ ka̱ki'in‑de yikɨ kúñu Jesús. Te ni̱ ka̱chisúkun‑dé jíín sá'ma kuítá jíín jí'o, nátu̱'un kásá'a máá ñáyɨvɨ judío ja̱ káchiyu̱ji‑i añú. ");
INSERT INTO migNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Te nuu̱ ní ji'i̱‑ya̱ jiká cruz, yúan ni̱ i̱o ɨɨn jardín. Te nuu̱ jardín íó ɨɨn ve'e añú jáá núu̱ té yu̱ji‑ga̱ ni ɨɨn añú. ");
INSERT INTO migNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yúan ni̱ ka̱chindee‑de Jesús, chi̱ ve'e añú‑ún kánchaa̱ yani. Te a yani kejá'á kɨvɨ́ sátu̱'a judío ja̱ kóo viko Pascua. ");
INSERT INTO migNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Te ja̱ñá'a̱n kɨvɨ̱ ɨ́ɨn semana‑ún, ni̱ jaa̱ María ñuu̱ Magdala ve'e añú‑ún ja̱ íñaa‑gá. Te ni̱ jini̱‑ña já ní kuxio yuu̱ já ndí'u̱ yuvé'e añú‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yúan‑na te ni̱ jinu‑ña ní jaa̱‑ña núu̱ Simón Pedro jíín núu̱ ɨngá cha̱a skuá'a‑ún ja̱ ní kumani̱ Jesús jíín. Te ni̱ ka'a̱n‑ña jíín‑de: Ni̱ ka̱tava‑dé Jito'o̱‑yo̱ iní ve̱'e añú. Te tú kájini̱‑yo̱ ndénu̱ ní ja̱chindee‑de‑ya̱, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Te ni̱ kenda Pedro jíín ɨngá cha̱a skuá'a‑ún, te ni̱ ja̱koyo‑de ve'e añú. ");
INSERT INTO migNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Te ni̱ ka̱jinu ta̱í ndendúú‑de. Ko ɨnga̱ cha̱a skuá'a‑ún, ni̱ jinu yachi̱‑ga̱‑de vásá Pedro. Te xna'a̱n‑ga̱‑de ni̱ jaa̱ ve'e añú. ");
INSERT INTO migNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Te ni̱ jito nuu‑de. Te ni̱ jini̱‑de sa'ma kuítá kánda̱a máá‑na̱ ini̱ kava. Ko tú ní kɨ́vɨ‑de. ");
INSERT INTO migNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Te ni̱ jaa̱ tuku Simón Pedro ja̱ ndikín‑de kua'a̱n‑de. Te ni̱ kɨ̱vɨ‑de ini̱ ve̱'e añú‑ún. Te ni̱ jini̱‑de sa'ma kuítá‑ún kánda̱a máá‑na̱. ");
INSERT INTO migNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Te pañito ni̱ yi̱súkun xiní Jesús, tú kátúu jíín sá'ma kuítá‑ún chi ni̱ naka̱ita'nu̱ te kátúu sɨ́ɨn. ");
INSERT INTO migNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yúan‑na te suni ɨnga̱ cha̱a skuá'a‑ún, cha̱a ni̱ jaa̱ xna'a̱n‑ga̱ ve'e añú, ni̱ kɨ̱vɨ‑de. Te ni̱ jini̱‑de. Te ni̱ kandíja‑de. ");
INSERT INTO migNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Chi̱ té chá'a̱n‑ga̱ juku̱'un ini̱‑de tu̱'un ka'a̱n tutu̱ ii̱, ja̱ jínu ñú'ún náchaku̱‑ya̱ nú a ni̱ ji'i̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Te cha̱a káskuá'a‑ún, ni̱ kano'o̱n‑de nuu̱ tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ko María, kándii̱‑ña ndé'e̱‑ña yatá vé'e añú‑ún. Te nini ndé'e̱‑ña, te ni̱ jito nuu‑ña ní nde̱'é‑ña iní ve̱'e añú. ");
INSERT INTO migNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Te ni̱ jini̱‑ña já káxiu̱kú úu̱ ndajá'a̱ ándɨ́vɨ́, káñu̱'un‑ya̱ sá'ma kuíjín, ɨɨn‑ya̱ íchi xiní, te ɨnga̱‑ya̱ íchi núu̱ já'a̱ núu̱ ní ka̱túu yíkɨ kúñu Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Te ni̱ kaka'a̱n‑ya̱ jíín‑ña: Nána̱, naja̱ ndé'e̱‑ní. Te ni̱ ka'a̱n‑ña jíín‑yá: Ni̱ ka̱janchaa̱‑de Jito'o̱‑ná, te tú jiní‑ná ndénu̱ ní jancha̱ka‑de‑ya̱, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Te súan ni̱ ka'a̱n‑ña, te ni̱ xíó kóto‑ña. Te ni̱ jini̱‑ña núu̱ Jesús kándii̱‑ya̱ yúan. Ko tú ní nákuni̱‑ña já Jesús kúu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Te ni̱ ka'a̱n Jesús jíín‑ña: Súchi̱, naja̱ ndé'e̱‑ro̱. Ndéja̱ nándúkú‑ró, áchí‑ya̱. Te máá‑ña, jáni ini̱‑ña já cháa ndíto nuu̱ itú kúu‑ya̱. Te ni̱ ka'a̱n‑ña jíín‑yá: Táta̱, te nú máá‑ní ni̱ chaxio‑ní‑ya̱, te kastu̱'ún‑ní ndé ni̱ chindee‑ní‑ya̱, te ná kína̱ki̱'in‑ná‑ya̱, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Te ni̱ ka'a̱n Jesús jíín‑ña: María, áchí‑ya̱. Te ni̱ naxíó kóto‑ña. Te ni̱ ka'a̱n‑ña jíín‑yá: Raboni, áchí‑ña, ja̱ kuní ka'a̱n, Maestro. ");
INSERT INTO migNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Te ni̱ ka'a̱n Jesús jíín‑ña: Ma̱ ké'é‑ró rúu̱, chi̱ té ndaa‑ga̱‑ri̱ nuu̱ máá Táa̱‑yo̱ Dios. Kuá'án nuu̱ ñaní‑ri̱, te kachi̱‑ro̱ núu̱‑dé ja̱ ndáa‑ri̱ no'o̱n‑ri̱ nuu̱ máá Táa̱‑ri̱, máá Táa̱ máá‑ró, te nuu̱ Dios máá‑rí, Dios máá‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Te kua'a̱n María ñuu̱ Magdala, ni̱ kastu̱'ún‑ña núu̱ cháa káskuá'a‑ún ja̱ ní jini̱‑ña núu̱ Jíto'o̱‑yo̱ jíín já ní ka'a̱n‑ya̱ tú'un yá'a jíín‑ña. ");
INSERT INTO migNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Te ni̱ ini máá kɨvɨ́ ɨ́ɨn semana‑ún, te ká'i̱in tútú cháa káskuá'a‑ún ini̱ ɨɨn ve'e. Te ndí'u̱ yuxé'é chi̱ káyu̱'ú‑de kájito‑de ña̱yɨvɨ judío. Te ni̱ chaa̱ Jesús ni̱ jukuiñi̱‑ya̱ má'ñú‑de, te ni̱ ka'a̱n‑ya̱ jíín‑de: Ma̱ kúkuí'a̱ ini̱‑ro̱ jíná'an‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Te súan ni̱ ka'a̱n‑ya̱. Te ni̱ stá'a̱n‑ya̱ ndá'a‑yá jíín xíin‑yá. Te cha̱a káskuá'a‑ún, ni̱ ka̱kusɨɨ̱ iní‑de ja̱ ní kajini̱‑de nuu̱ máá Jíto'o̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yúan‑na te ni̱ ka'a̱n tuku Jesús: Ma̱ kúkuí'a̱ ini̱‑ro̱. Nátu̱'un ni̱ tájí máá Táa̱‑yo̱ Dios ruu̱ va̱i‑ri̱, suni súan tájí‑rí róó ki̱ngoyo‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tu̱'un yá'a ni̱ ka'a̱n‑ya̱, te ni̱ tɨvɨ̱ tachi̱‑yá nuu̱‑dé jíná'an‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Ki'in Espíritu Santo jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nú sá'a‑ró túká'nu ini̱ nuu̱ kuáchi ɨɨn ña̱yɨvɨ, te koo tu̱ká'nu ini̱ nuu̱ kuáchi‑i. Te nú kendo̱o kua̱chi sɨkɨ̱ ɨ́ɨn ña̱yɨvɨ sá'a‑ró, te kendo̱o. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ko Tomás ja̱ nání‑de Dídimo, ɨɨn tá'an ja̱ uxí uu̱‑ún kúu‑de, tú kánchaa̱‑de jíín cháa‑ún jíná'an‑de, ná ni̱ chaa̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Te sava‑ga̱ cha̱a káskuá'a, ni̱ kaka'a̱n‑de jíín Tomás: Ni̱ kajini̱‑ri̱ nuu̱ máá Jíto'o̱‑yo̱, áchí‑de. Te ni̱ ka'a̱n Tomás: Nú tú kuni̱‑ri̱ nuu̱ ní tuji̱ ndá'a‑yá ni̱ sá'a ndu̱yu ka̱a, te nú tú chindee‑ri̱ xini̱ ndá'a‑rí nuu̱ ní i̱ndee ndu̱yu ka̱a, te nú tú chindee‑ri̱ nda'a‑rí xiin‑yá, te ma̱ kándíja kutɨ‑rí, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Te ni̱ kuu ɨɨn semana. Te ɨnga̱ jínu ká'i̱in tútú cháa káskuá'a‑ún ini̱ ve̱'e. Te kándee Tomás jíín‑de. Te ni̱ chaa̱ tuku Jesús va̱sa ndí'u̱ yuxé'é. Te ni̱ jukuiñi̱‑ya̱ má'ñú‑de. Te ni̱ ka'a̱n‑ya̱: Ma̱ kúkuí'a̱ ini̱‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Te ni̱ ka'a̱n‑ni‑ya̱ jíín Tomás: Chindee xini̱ ndá'a‑ro yá'a, te kuni̱‑ro̱ ndá'a‑rí. Te skáa̱ nda'a‑ro, te chindee‑ró xíin‑rí. Te ma̱ káni sɨ̱kɨ́ ini̱‑ro̱, chi̱ sua ná kándíja‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Yúan‑na te ni̱ ka'a̱n Tomás jíín‑yá: Ai̱ Táta̱, Jito'o̱ máá‑ná, te Dios máá‑ná kúu‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Te ni̱ ka'a̱n Jesús jíín‑de: Ni̱ jini̱‑ro̱ rúu̱, Tomás, te yu̱án ní kandíja‑ró: Xáán ndatu̱ ña̱yɨvɨ já kákandíja va̱sa tú ní kájini̱‑i nuu̱‑rí, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Te suni ni̱ sá'a Jesús kua'a̱‑gá tuni̱ nuu̱ cháa káskuá'a jíín‑yá, ja̱ tú yóso núu̱ tutú yá'a. ");
INSERT INTO migNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ko tuni̱ yá'a yóso náva̱'a kandíja‑ró já Jesús kúu Cristo máá Sé'e Dios. Chi̱ nú kandíja‑ró‑yá, te kuchaku̱‑ro̱ nɨ́ɨ́ káni jíín sɨ́'vɨ́‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Te kukuéé‑ga̱ te Jesús, ni̱ nastá'a̱n ndiji̱n tuku‑ya̱ máá‑yá nuu̱ cháa káskuá'a jíín‑yá ja̱ káxiu̱kú‑de nuu̱ mar Tiberias. Te modo yá'a ni̱ stá'a̱n ndiji̱n‑ya̱ máá‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ká'i̱in tútú Simón Pedro, jíín Tomás, ja̱ nání Dídimo, jíín Natanael, cha̱a ñuu̱ Caná ndañúu̱ Galilea, jíín táká se̱'e Zebedeo, jíín úu̱‑ga̱ cha̱a káskuá'a jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Te ni̱ ka'a̱n Simón jíín‑de: Ná kítɨ̱ɨn‑ri̱ ti̱yáká, áchí‑de. Te ni̱ kaka'a̱n‑de jíín‑de. Suni ná kíngoyo‑ri̱ jíín‑ró, áchí‑de. Te kua̱ngoyo‑de, te ni̱ kɨ̱vɨ koyo‑de ɨɨn barco. Ko tú ní kátɨɨn kutɨ‑dé‑tɨ̱ ákuáa‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Te ja̱ kuáku̱ndiji̱n, te ni̱ jukuiñi̱ Jesús yu'u mar. Ko cha̱a káskuá'a‑ún, tú ní kánakuni̱‑de ja̱ Jesús kúu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yúan‑na te ni̱ ka'a̱n Jesús jíín‑de: Súchi̱, á káñava̱'a‑ró ɨ́ɨn ti̱yáká kée‑rí, áchí‑ya̱. Te ni̱ kaka'a̱n‑de jíín‑yá: Tú kutɨ, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Skuíta ka'nu ñunu‑ro íchi lado vá'a barco, te ni'i̱n‑ro̱‑tɨ́, áchí‑ya̱. Yúan‑na te ni̱ ka̱skuíta ka'nu‑de ñunu. Te tuká ní kúu kutɨ nátava‑dé ñunu, ja̱ kuá'a̱ xáa̱n cháká ní ni'i̱n‑dé. ");
INSERT INTO migNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yúan‑na te cha̱a skuá'a ja̱ maní Jesús jíín, ni̱ ka'a̱n‑de jíín Pedro: Máá Jíto'o̱‑yo̱ kúu, áchí‑de. Te ja̱ ní jini so̱'o‑de ja̱ máá Jíto'o‑yo̱ kúu, te ni̱ nachu'un‑de sa'ma‑dé, chi̱ víchí lɨ́ɨ‑dé núú. Te ni̱ ndava‑ni‑de kua'a̱n‑de nuu̱ mar. ");
INSERT INTO migNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Te sava‑ga̱ cha̱a káskuá'a‑ún, va̱i koyo‑de jíín barco jíín ñúnu ñú'un chítú tíyáká. Chi̱ tú jíká ká'i̱in‑de jíín ñú'un íchí, chi̱ yani nátu̱'un uu̱ ciento yɨ́kɨ́. ");
INSERT INTO migNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Te ja̱ ní ka̱nuu‑de nuu̱ ñú'un, te ni̱ kajini̱‑de ja̱ nduxiá tɨkua̱ñu'u̱n. Te íxndée ɨɨn cháká núu̱ ñú'u̱n‑ún, jíín stáa̱. ");
INSERT INTO migNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Te ni̱ ka'a̱n Jesús jíín‑de jíná'an‑de: Kuáki̱'in ti̱yáká já ní ka̱tɨɨn‑ró vína ná kíi, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Te ni̱ kɨ̱vɨ Simón Pedro ini̱ barco. Te ni̱ stáa‑de ñunu cháká ní chaa̱‑de jíín yú'u mar. Te ñú'un chítú cháká ná'nu, ɨɨn ciento uu̱ xiko uxi̱ uni̱. Te va̱sa súan kua'a̱‑tɨ́ ni̱ ñu̱'un, ko tú ní té'nde̱ ñunu‑ún. ");
INSERT INTO migNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Te ni̱ ka'a̱n Jesús jíín‑de: Ña'a̱n jíná'an‑ró te kasi̱ ini̱‑ro̱, áchí‑ya̱. Te ni ɨɨn cha̱a káskuá'a‑ún, tú ní chúndéé iní‑de ja̱ kaká tu̱'ún‑de‑ya̱: Róó, ndé cha̱a kúu‑ró. Chi̱ a kájini̱‑de ja̱ máá Jíto'o̱‑yo̱ kúu‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Te ni̱ chaa̱ Jesús. Te ni̱ ki'in‑ya̱ stáa̱‑ún. Te ni̱ ja̱'a‑ya̱ núu̱‑dé. Te suni súan ni̱ ja̱'a‑ya̱ tíyáká‑ún nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ya̱'á ní kuu vuelta uni̱ ja̱ ní nastá'a̱n ndiji̱n Jesús máá‑yá nuu̱ cháa káskuá'a jíín‑yá, ja̱ á ni̱ nachaku̱‑ya̱ já ní ji'i̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Te nuu̱ ní ndɨ'ɨ ni̱ kajasi̱ ini̱‑de, te ni̱ ka'a̱n Jesús jíín Simón Pedro: Simón, se̱'e Jonás, kúndá'ú‑ga̱ ini̱‑ro̱ rúu̱ vásá yá'á xí túu, áchí‑ya̱. Te ni̱ ka'a̱n‑de jíín‑yá: Jaa̱n, Táta̱, máá‑ní jiní ja̱ maní‑ná jíín‑ní, áchí‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Skée‑ro lélú‑rí núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Te ni̱ ka'a̱n tuku‑ya̱ vuelta uu̱ jíín‑de: Simón, se̱'e Jonás, kúndá'ú ini̱‑ro̱ rúu̱ náún, áchí‑ya̱. Te ni̱ ka'a̱n‑de jíín‑yá: Jaa̱n Táta̱, máá‑ní jiní ja̱ maní‑ná jíín‑ní, áchí‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Skée‑ro rɨ́ɨ̱‑ri̱ núsáá, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Te ni̱ ka'a̱n tuku‑ya̱ vuelta uni̱ jíín‑de: Simón, se̱'e Jonás, mani̱‑ro̱ jíín‑rí náún, áchí‑ya̱. Te ni̱ kuxíí iní Pedro ja̱ vuelta uni̱ ni̱ ka'a̱n‑ya̱ jíín‑de: Mani̱‑ro̱ jíín‑rí náún. Te ni̱ ka'a̱n‑de jíín‑yá: Táta̱, máá‑ní jiní ta̱ká tu̱'un. Máá‑ní jiní ja̱ maní‑ná jíín‑ní, áchí‑de. Te ni̱ ka'a̱n‑ya̱: Skée‑ro rɨ́ɨ̱‑ri̱ núsáá. ");
INSERT INTO migNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ja̱ndáa̱ ká'a̱n‑ri̱ jíín‑ró, ja̱ ondé ná súchí‑ró núú, te ni̱ naku'ni̱ máá‑ró chíi‑ró. Te ni̱ jika‑ró ndénu̱ ní kuu ini̱‑ro̱. Ko nú ná yíi‑ró, te skáa‑ro̱ ndá'a‑ro. Te ɨnga̱ cha̱a, nachi'i‑de chi̱i‑ró, te kunchaka‑de róó ki'i̱n‑ro̱ jíín‑de va̱sa tú kuní‑ro̱. Achí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tu̱'un yá'a ni̱ ka'a̱n‑ya̱ náva̱'a ná júku̱'un ini̱‑de ndé modo kuu̱‑de ja̱ ndúñá'nu Dios sá'a‑de. Yúan‑na te ni̱ ka'a̱n‑ya̱: Kundiki̱n ruu̱ ná kí'o̱n, áchí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Te ni̱ xíó kóto Pedro. Te ni̱ jini̱‑de cha̱a skuá'a ja̱ maní Jesús jíín, ja̱ ndikín‑de va̱i‑de, cha̱a ni̱ ndituu jika̱ Jesús ná ni̱ ka̱kuxíni‑ya̱, ja̱ ní jika̱ tu̱'ún‑de‑ya̱: Táta̱, ndé cha̱a kúu ja̱ nástúu níí. ");
INSERT INTO migNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Te ni̱ jini̱ Pedro nuu̱ cháa‑ún. Te ni̱ ka'a̱n‑de jíín Jesús: Táta̱, te cha̱a yá'a, na̱ún sá'a‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Te ni̱ ka'a̱n Jesús jíín‑de: Nú kuní‑ri̱ ja̱ kéndo̱o‑de onde̱ kɨvɨ̱ ncháa̱‑ri̱, naun jítú iní‑ro̱. Kundiki̱n ruu̱ ná kí'o̱n. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Te ni̱ jicha̱ tu̱'un yá'a nuu̱ táká ñani̱‑yo̱, ja̱ cháa skuá'a‑ún ma̱ kúu̱‑de. Ko tú ní ká'a̱n Jesús ja̱ má kúu̱‑de, chi̱ sua ni̱ ka'a̱n‑ya̱: Nú kuní‑ri̱ ja̱ kéndo̱o‑de onde̱ kɨvɨ̱ ncháa̱‑ri̱, te naun jítú iní‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Cha̱a ni̱ skuá'a‑ún kúu cha̱a yá'a, te jáni ndaa̱‑de tu̱'un ta̱ká tiñu yá'a. Te suni ni̱ chaa‑de ta̱ká tu̱'un yá'a. Te kájini̱‑yo̱ já tú'un jáni‑de ká'a̱n ndaa̱. ");
INSERT INTO migNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Suni íó kua'a̱ xáa̱n‑gá tiñu ni̱ sá'a Jesús. Te nú chaa‑yó ná ɨɨn ná ɨɨn, te ma̱ kánda nɨ́ɨ́ ñúyɨ́vɨ já kú'un tutu̱ koso tú'un‑ún núú, jáni ini̱‑ri̱. Amén.");
INSERT INTO migNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, táta̱ máni̱. Nuu̱ tutú ja̱ ní chaa núú‑ná ni̱ kastu̱'ún‑ná ta̱ká tiñu ni̱ sá'a Jesús, jíín táká tu̱'un ni̱ stá'a̱n‑ya̱ ondé kɨvɨ̱ ní kejá'á‑yá, ");
INSERT INTO migNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","te onde̱ kɨvɨ̱ ní tá'ú‑yá tiñu jíín Espíritu Santo nuu̱ táká apóstol, cha̱a ni̱ ka̱ji‑ya̱. Te suni kɨvɨ̱‑ún ni̱ ndaa‑ya̱ kuá'a̱n‑ya̱ ándɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Te nuu̱ ní ji̱nu ni̱ ndo'o‑ya̱, te jíín kuá'a̱ tuní íó ndaa̱ ni̱ ndenda‑ya̱ chakú‑ya̱ núu̱ cháa‑ún jíná'an‑de. Te uu̱ xiko kɨvɨ̱ ní stá'a̱n‑ya̱ máá‑yá nuu̱‑dé. Te ni̱ ka'a̱n‑ya̱ jíín‑de tu̱'un ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ká'i̱in tútú‑de. Te ni̱ tá'ú‑yá tiñu nuu̱‑dé ja̱ má kúxio‑de ini̱ ñuu̱ Jerusalén, chi ná kúndatu‑de chaa̱ I'a̱ ni̱ keyu'u máá Táa̱‑yo̱ Dios. Te ni̱ ka'a̱n‑ya̱ jíín‑de: A ni̱ ka̱jini so̱'o‑ró já súan ni̱ ka'a̱n‑ri̱ jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Chi̱ Juan, ja̱ndáa̱ ja̱ jíín ndúcha ní skuánducha‑dé‑i. Ko róó jíná'an‑ró, yaku̱‑na̱ kɨvɨ̱ te kuanducha‑ro jíín Espíritu Santo, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Te cha̱a ni̱ ka̱kutútú núu̱‑yá, ni̱ kajika̱ tu̱'ún‑de‑ya̱: Táta̱, te vina natá'ú tíñu cha̱a Israel ini̱ ñuu̱ máá‑de sá'a‑ní xí túu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Te ni̱ kachi̱‑ya̱: Ma̱ kúu kuni̱‑ro̱ kɨvɨ́ xí kuiá ja̱ ní teta'a̱n máá Táa̱‑yo̱ jíín tú'un ndíso‑ya̱ tíñu. ");
INSERT INTO migNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ko nú a ni̱ chaa̱ Espíritu Santo sɨkɨ̱‑ro̱, yúan‑na te ni'i̱n‑ro̱ fuerza‑ya̱, te kani ndaa̱‑ro̱ tú'un‑ri̱ nɨ́ɨ́ iní ñuu̱ Jerusalén, nɨ́ɨ́ iní ñuu̱ Judea, jíín ñúu̱ Samaria, jíín ondé nuu̱ ndɨ́'ɨ ñu̱yɨ́vɨ. Achí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Te ni̱ ndɨ'ɨ ni̱ ka'a̱n‑ya̱ táká tu̱'un yá'a. Te nini kánde̱'é‑de, te ni̱ ndaa‑ya̱ kuá'a̱n‑ya̱. Te ni̱ chaa̱ ɨɨn viko̱ nu̱'ún ní jasu̱ nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Te nini ká'i̱in‑de kándakoto‑de ichi ándɨ́vɨ́ núu̱ ndáa‑ya̱ kuá'a̱n‑ya̱, te ni̱ chaa̱‑ni uu̱ tá'a̱n cha̱a káñu̱'un sa'ma kuíjín, ni̱ ka̱jukuiñi̱ xiin‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Te ni̱ kaka'a̱n cha̱a‑ún jíín‑de: Róó cha̱a ñuu̱ Galilea, naja̱ kándakoto‑ró íchi ándɨ́vɨ́. Jesús yá'a, ja̱ ní xndóo‑ya̱ róó te kua'a̱n‑ya̱ íchi ándɨ́vɨ́, suni súan ndii‑ya̱ nátu̱'un ni̱ kajini̱‑ro̱ kuáno'on‑yá andɨ́vɨ́. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yúan‑na te ni̱ ka̱nuu‑de yuku Olivar káno'o̱n‑de ñuu̱ Jerusalén. Te onde̱ yuku‑ún, te onde̱ ñuu̱, jíká nátu̱'un kájika cha̱a judío ɨɨn kɨvɨ̱ ndéta̱tú. ");
INSERT INTO migNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Te ni̱ najaa̱ koyo‑de ini̱ ñuu̱. Te ni̱ ka̱kaa‑de xini̱ ɨ́ɨn ve'e nuu̱ káxiu̱kú Pedro, Juan, Jacobo, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo se̱'e Alfeo, Simón Zelote jíín Judas ñani̱ Jacobo. ");
INSERT INTO migNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ta̱ká cha̱a yá'a, ɨɨn núú‑ni ká'i̱in‑de kájika̱n ta'u̱‑dé, jíín sáva ñasɨ́'ɨ́, jíín María náa̱ Jesús, jíín táká ñani̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Te ɨɨn kɨvɨ̱ ní jukuiñi̱ Pedro nuu̱ táká ñani̱‑ún. Te ká'i̱in nátu̱'un ciento oko̱ ña̱yɨvɨ. Te ni̱ ka'a̱n‑de: ");
INSERT INTO migNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ñáni̱ jíná'an‑ró, ni̱ skíkuu nɨ́nɨ tú'un ká'a̱n tutu̱ ii̱ já ní ka'a̱n Espíritu Santo onde̱ sáá jíín yú'u David tu̱'un Judas, cha̱a ni̱ yoxnúú núu̱ já ní ka̱katɨɨn Jesús. ");
INSERT INTO migNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Te suu cha̱a‑ún, ni̱ yoso̱‑dé jíín‑yó. Te ni̱ chindéé tá'an‑de jíín‑yó sɨkɨ́ tú'un yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Cha̱a yúan, ni̱ jaan‑de ɨɨn ñu'un jíín xú'ún ní ni'i̱n‑dé sɨkɨ̱ tíñu ñáá ni̱ sá'a‑de. Te onde̱ súkún te ni̱ kanangava‑de, te ni̱ ndata̱ sáva chi̱i‑de. Te ni̱ ndɨ'ɨ jitɨ‑de ni̱ jicha̱. ");
INSERT INTO migNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Te ni̱ jicha̱ tu̱'un yá'a nuu̱ táká ña̱yɨvɨ káxiu̱kú ñúu̱ Jerusalén. Te yu̱án ní ka̱skúnání‑i ñu'un‑ún nuu̱ yú'u máá‑i Acéldama, ja̱ kuní ka'a̱n: Ñu'un nɨñí. ");
INSERT INTO migNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Chi̱ súan yóso núu̱ tutú Salmo: Ve'e‑de, ná kúu ɨɨn ve'e sáni. Te ma̱ kúnchaa̱ ni ɨɨn‑i ini̱ ve̱'e‑ún. Te suni ká'a̱n: Tiñu ndíso‑de, ná kúndiso ɨnga̱ cha̱a. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Núsáá te jínu ñú'ún já káji‑yó ɨ́ɨn cha̱a ma̱'ñú táká cha̱a ja̱ á ká'i̱in jíín‑yó táká kɨvɨ̱ ní jika máá Jíto'o̱‑yo̱ Jesús jíín‑yó, ");
INSERT INTO migNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","te onde̱ kɨvɨ̱ ní skuánducha Juan, te onde̱ kɨvɨ̱ ní xndóo‑ya̱ yóó te ni̱ ndaa‑ya̱ kuá'a̱n‑ya̱ ándɨ́vɨ́. Te cha̱a ka̱ji‑yó, ná kúu‑de testigo jíín‑yó já á ni̱ nachaku̱‑ya̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Te ni̱ ka̱jani‑de uu̱ tá'a̱n cha̱a: José, ja̱ nání‑de Barsabás te Justo kúu ɨnga̱ sɨ́'vɨ́‑de, jíín Matías. ");
INSERT INTO migNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Te ni̱ kajika̱n ta'u̱‑dé: Táta̱, máá‑ní chi̱ jiní‑ní ndasa káa ini̱ añú ta̱ká ña̱yɨvɨ. Núsáá te ja̱ úu̱ tá'a̱n cha̱a yá'a, stá'a̱n‑ní ndé ɨɨn‑de ni̱ ka̱ji‑ní, ");
INSERT INTO migNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","náva̱'a kundiso‑de tiñu apóstol. Chi̱ Judas, ni̱ sá'a‑de kua̱chi, te ni̱ kenda‑de kua'a̱n‑de lugar máá‑de. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Yúan‑na te ni̱ ka̱sá'a‑de sortear. Te ni̱ jungava‑ni sɨkɨ̱ Matías. Te ni̱ nukoso̱‑dé jíín uxí ɨɨn‑ga̱ apóstol. ");
INSERT INTO migNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Te máá kɨvɨ́ Pentecostés ni̱ ka'i̱in tútú ɨ́ɨn núú‑ni‑de. ");
INSERT INTO migNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Te sánaa‑ní te ni̱ chaa̱ ɨɨn ndusu̱ ichi ándɨ́vɨ́ nátu̱'un nɨ́'ɨn ɨɨn tachi̱ xáa̱n, te ni̱ skútú iní ve̱'e nuu̱ káxiu̱kú‑de. ");
INSERT INTO migNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Te ni̱ kajini̱‑de ja̱ ní jicha̱ nátu̱'un yáá ñú'u̱n. Te ni̱ jungo̱o sɨkɨ̱ ná ɨɨn ná ɨɨn‑de. ");
INSERT INTO migNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Te ndɨ'ɨ‑de, ni̱ kukútu jíín Espíritu Santo. Te ni̱ kaka'a̱n‑de sɨ́ɨn sɨ́ɨn yu'u, ndasa ni̱ stá'a̱n máá Espíritu nuu̱‑dé ka'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Te ñuu̱ Jerusalén, káxiu̱kú ñáyɨvɨ judío onde̱ ta̱ká ñuu̱ nɨ́ɨ́ ñúyɨ́vɨ. Te káchiñú'ún‑i Dios. ");
INSERT INTO migNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Te ja̱ súan ni̱ nɨ̱'ɨn, te ni̱ kataka̱ ña̱yɨvɨ kuá'a̱. Te ni̱ kuñáá ini̱‑i, chi̱ ná ɨɨn ná ɨɨn‑i, ni̱ ka̱jini so̱'o‑i káka'a̱n‑de yu'u máá‑i. ");
INSERT INTO migNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Te ni̱ ka̱naa iní‑i kánde̱'é‑i. Te ni̱ kaka'a̱n‑i: Nasu̱ cháa ñuu̱ Galilea kákuu ta̱ká cha̱a káka'a̱n yá'a náún. ");
INSERT INTO migNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ndasa kúu núsáá. Chi̱ ná ɨɨn ná ɨɨn‑yó, kájini so̱'o‑yó káka'a̱n‑de yu'u ní ka̱kaku‑yó jíín. ");
INSERT INTO migNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Chi cha̱a onde̱ ñuu̱ Parto jíín ñúu̱ Media jíín ñúu̱ Elam kákuu‑yó. Te sava‑yó, va̱i‑yó ondé ñuu̱ Mesopotamia, jíín ñúu̱ Judea, jíín ñúu̱ Capadocia, jíín ñúu̱ Ponto, jíín ñúu̱ Asia. ");
INSERT INTO migNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Suni onde̱ ñuu̱ Frigia jíín ñúu̱ Panfilia, jíín ñúu̱ Egipto jíín ndáñúu̱ África ja̱ kánchaa̱ ɨnga̱ lado ñuu̱ Cirene va̱i koyo‑yó. Te sava‑ga̱‑yo̱ ondé ñuu̱ Roma jíká vái‑yó. Te suni íó sava cha̱a ni̱ naki'in sé'é judío. ");
INSERT INTO migNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Suni cha̱a ñuu̱ Creta jíín cháa ñuu̱ Arabia kákuu‑yó. Te kájini so̱'o‑yó já jíín yú'u máá‑yó káka'a̱n‑de ta̱ká tiñu ñá'nu sá'a Dios. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Te ta̱ká‑i, cuenta kánaa íi̱ iní‑i kánde̱'é‑i. Te káka'a̱n‑i jíín tá'an‑i: Na̱ún tu̱'un kúu ya̱'á núsáá, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ko sava‑i káka'a̱n kátá‑i: Kánaji̱ni‑de, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yúan‑na te ni̱ ndukuiñi̱ Pedro jíín uxí ɨɨn‑ga̱‑de. Te ni̱ ka'a̱n jaa‑de jíín‑i: Níí, cha̱a judío, jíín táká níí cha̱a káxiu̱kú iní ñuu̱ Jerusalén, tiñu yá'a ná kuní ndɨ'ɨ‑ní jíná'an‑ní. Te kuni ná'ín‑ní tu̱'un ná ká'a̱n‑ná jíín‑ní. ");
INSERT INTO migNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Chi cha̱a yá'a, tú kánaji̱ni‑de nátu̱'un kájani ini̱‑ní, chi̱ sáá ká'ɨɨ̱n ja̱ñá'a̱n kúu. ");
INSERT INTO migNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ko ya̱'á kúu tu̱'un ni̱ ka'a̱n Joel cha̱a ni̱ jani tu̱'un Dios onde̱ sáá: ");
INSERT INTO migNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Achí Dios: Kɨvɨ̱ sándɨ̱'ɨ́‑na̱ te kacha̱ nu̱u‑ri̱ Espíritu‑ri̱ sɨkɨ̱ táká ña̱yɨvɨ. Te se̱'e yíí‑ro̱ jíín sé'e sɨ́'ɨ́‑ro̱, kani‑i tu̱'un‑ri̱. Te cha̱a súchí jíná'an‑de jíín cháa ñá'nu, skóto ja̱ni‑de. ");
INSERT INTO migNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Te ja̱ndáa̱ ja̱ kɨvɨ́‑ún te kacha̱ nu̱u‑ri̱ Espíritu‑ri̱ sɨkɨ̱ mozo‑ri̱, kúu cha̱a kúu ña'an. Te kani‑i tu̱'un‑ri̱ jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Te sá'a‑ri̱ tiñu ñá'nu onde̱ andɨ́vɨ́. Te sá'a‑ri̱ tuni̱ nuu̱ ñúyɨ́vɨ. Te koo nɨñi̱ jíín ñú'u̱n jíín yokó ñu'ma̱. ");
INSERT INTO migNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Te ndika̱ndii, nduu túún. Te yoo̱, nduu nɨñi̱. Te vásá jáa̱ kɨvɨ̱ máá Jíto'o̱‑yo̱. Kɨvɨ̱ ká'nu, kɨvɨ̱ stá'a̱n ndiji̱n‑ya̱ máá‑yá kuu‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Te ta̱ká ña̱yɨvɨ ká'a̱n nda̱'ú jíín máá Jíto'o̱‑yo̱ ondé jíín sɨ́'vɨ́‑yá, ka̱ku‑i, achí Joel. ");
INSERT INTO migNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Níí cha̱a ñuu̱ Israel, kuni so̱'o‑ní tu̱'un yá'a jíná'an‑ní: Máá Jesús ñuu̱ Nazaret, I'a̱ va̱'a ni̱ kuu‑ya̱ núu̱ Dios. Te nuu̱ máá‑ní ni̱ sá'a‑ya̱ tíñu ñá'nu jíín kuá'a̱ tuní. Te ni̱ ka̱kee nuu̱‑ní ni̱ ka̱nde̱'é‑ní ja̱ súan ni̱ sá'a‑ya̱ ondé jíín Dios. Te suni súan kájini̱ ta̱ká‑ní. ");
INSERT INTO migNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ko níí, ni̱ ka̱nachi'i‑ní‑ya̱ ndá'a cháa ñáá. Te ni̱ ka̱ja'ni‑dé‑ya̱ jiká cruz. Te jíín tiempo, a ni̱ jini̱ Dios ja̱ súan sá'a‑ní núú, chi̱ súan ni̱ teta'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ko ni̱ nachaku̱‑ya̱ ní sá'a Dios. Te ni̱ janchaa̱‑ya̱ fuerza kue'e̱ kuu̱‑yo̱, chi̱ tú ní kúu kendo̱o‑ga̱ Jesús ini̱ nda'a kué'e̱ kuu̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chi̱ David, ni̱ ka'a̱n‑de tu̱'un‑ya̱: Ni̱ jini̱‑ri̱ nuu̱ máá Jíto'o̱‑ri̱, ja̱ nené kánchaa̱‑ya̱ jíín‑rí. Chi̱ kánchaa̱‑ya̱ íchi ndává'a‑ri̱, náva̱'a ma̱ yú'ú‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ja̱ yúán ní kusɨɨ̱ iní añú‑ri̱. Te ni̱ nakana jaa‑ri̱‑ya̱. Te suni ndeta̱tú yikɨ kúñu‑ri̱, te kuñukuu ini̱‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Chi ma̱ skéndo̱o‑ní añú‑ná ini̱ lugar ndɨ̱yi, ni ma̱ kuá'a‑ní tu̱'un te'yu̱ Se̱'e‑ní, I'a̱ ii̱. ");
INSERT INTO migNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ni̱ stá'a̱n‑ní nuu̱‑ná ndasa ni'i̱n‑ná ichi kúchaku̱‑ná. Te kɨvɨ̱ kúnchaa̱‑ná jíín‑ní te kusɨɨ̱ xáa̱n iní‑ná sá'a. Achí David. ");
INSERT INTO migNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ñáni̱ jíná'an‑ní, ná kachí ka̱jí‑ná nuu̱‑ní tu̱'un David tatá ñúu̱‑yo̱. Chi ni̱ ji'i̱‑de. Te ni̱ yu̱ji‑de. Te ve'e añú‑de kánchaa̱ jíín‑yó ondé vina. ");
INSERT INTO migNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Chi cha̱a ni̱ jani tu̱'un Dios ni̱ kuu‑de. Te ni̱ jini̱‑de ja̱ ní ka'a̱n téyíí‑yá jíín‑de ja̱ núu̱‑dé, cuenta chi̱i tata̱‑de, nukuiñi̱ Cristo kunchaa̱‑ya̱ mesa‑de tá'ú‑yá tiñu. ");
INSERT INTO migNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Te ya̱'á ní jini̱‑de jíín tiempo, ni̱ kastu̱'ún‑de ja̱ náchaku̱ Cristo, chi̱ añú‑ya̱, tú ní kéndo̱o ini̱ lugar ndɨ̱yi. Te ni yikɨ kúñu‑ya̱, tú ní té'yu̱. ");
INSERT INTO migNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Te Jesús, ni̱ nachaku̱‑ya̱ ní sá'a Dios. Te kájini̱‑yo̱ já chakú‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Te ni̱ ndaa‑ya̱ kuá'a̱n‑ya̱ íchi ndává'a Dios. Te nátu̱'un ni̱ keyu'u máá Táa̱‑yo̱, te onde̱ nuu̱ máá‑yá, ni̱ ni'i̱n Jesús Espíritu Santo. Te ni̱ jacha̱ nu̱u‑ya̱ nátu̱'un kánde̱'é‑ní te kájini so̱'o‑ní vina. ");
INSERT INTO migNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Chi̱ David, tú ní ndáa‑de andɨ́vɨ́. Ko ni̱ ka'a̱n‑de: Máá Tatá Dios, ni̱ ka'a̱n‑ya̱ jíín Jíto'o̱‑ri̱: Nungo̱o‑ró íchi ndává'a‑ri̱, ");
INSERT INTO migNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","te ná chúkú‑rí cha̱a kájito u'u̱ róó, kuu‑de teyu̱ kúxndíi ja'a̱‑ro̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Te ná kuní ndaa̱ ndivii ñáyɨvɨ Israel ja̱ Dios, ni̱ jani‑ya̱ máá Jesús ja̱ ná kúu‑ya̱ Jíto'o̱‑yo̱ va̱sa ni̱ ka̱ja'ni‑ní máá‑yá jika̱ cruz, te suni máá‑yá kúu Cristo. Achí Pedro jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Te súan ni̱ ka̱jini so̱'o‑i tu̱'un yá'a. Te ni̱ ka̱nata'u'u̱ ini̱ añú‑i. Te ni̱ kaka'a̱n‑i jíín Pedro jíín sáva‑ga̱ apóstol: Ñáni̱ jíná'an‑ní, ndasa sá'a‑ná jíná'an‑ná núsáá, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Te ni̱ kachi̱ Pedro jíín‑i: Nakani ini̱‑ní jíná'an‑ní, te kuanducha‑ní jíín sɨ́'vɨ́ máá Jesucristo náva̱'a koo tu̱ká'nu ini̱ nuu̱ kuáchi‑ní. Te kua̱'a‑ya̱ Espíritu Santo‑ya̱ núu̱‑ní. ");
INSERT INTO migNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Chi̱ nuu̱ máá‑ní jíín núu̱ sé'e‑ní, súan ni̱ keyu'u‑yá. Te suni súan ni̱ ka'a̱n‑ya̱ núu̱ táká ña̱yɨvɨ káxiu̱kú jíká, nuu̱ násaa‑i ja̱ máá Tatá‑yo̱ Dios kana‑ya̱ xiní‑í ná kí'i̱n‑i nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Te Pedro, jíín kuá'a̱‑gá tu̱'un súan, ni̱ ka'a̱n ndaa̱‑de. Te ni̱ ka'a̱n ni̱'in‑de jíín‑i: Ná ndúkú ndéé‑ní ka̱ku‑ní ma̱'ñú táká ña̱yɨvɨ ñáá yá'a, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Te ni̱ ka̱jatú'ún sáva‑i tu̱'un ni̱ ka'a̱n‑de. Te ni̱ ka̱janducha‑í. Te kɨvɨ̱‑ún ni̱ ndea̱‑ga̱‑i nátu̱'un uni̱ mil ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Te ni̱ ka'i̱in ni̱'in‑i sɨkɨ̱ tú'un kástá'a̱n apóstol, ni̱ kanda̱tu̱'ún ɨ́ɨn núú‑de, ni̱ ka̱sákuáchí‑de staa̱. Te ni̱ kajika̱n ta'u̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Te ndɨ'ɨ ña̱yɨvɨ, ni̱ kayu̱'ú‑i. Te cha̱a apóstol, ni̱ ka̱sá'a‑de kua'a̱ tíñu ñá'nu jíín tuní. ");
INSERT INTO migNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Te ta̱ká ña̱yɨvɨ kákandíja, káxiu̱kú tútú‑i. Te káñava̱'a ká'nu‑i ta̱ká ndatíñu‑i. ");
INSERT INTO migNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Te ni̱ kaxi̱kó‑i ta̱ká ndatíñu‑i, jíín táká ve'e‑i. Te ni̱ ka̱saka‑í xu̱'ún núu̱ tá'an‑i, ndasa jínu ñú'ún ɨ́ɨn ɨɨn‑i jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Te ndɨta'a̱n kɨvɨ̱ kája'a̱n tútú‑i ve'e ii̱. Te kásákuáchí‑i staa̱ ndɨ́ta'a̱n ve'e‑i. Te luu, sɨɨ̱ ní ka'i̱o ini̱ añú‑i káyee‑í staa̱. ");
INSERT INTO migNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Te kánakana jaa‑i Dios. Te sava‑ga̱ ña̱yɨvɨ ñúu̱‑ún, ni̱ kaka'a̱n jíñú'ún jíín‑i. Te ndɨta'a̱n kɨvɨ̱ ní kaka̱ku sava‑ga̱ ña̱yɨvɨ ní sá'a máá Jíto'o̱‑yo̱. Te ni̱ ka̱ndujíín‑i jíín tɨ́ku'ni̱ kándíja‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ɨɨn kɨvɨ̱ te ni̱ ka̱kaa Pedro jíín Juan, kája'a̱n‑de ini̱ ve̱'e ii̱. Chi̱ máá hora ka̱'uni̱ aíni kúu, te jikán ta'u̱‑í yúan. ");
INSERT INTO migNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Te kákinchaka‑i ɨɨn cha̱a rengo onde̱ kɨvɨ̱ ní kaku‑de. Te cha̱a‑ún, ncháá‑de ndɨta'a̱n kɨvɨ̱ yúxé'é vé'e ii̱ nuu̱ nání hermosa, jikán‑de caridad nuu̱ táká ña̱yɨvɨ kɨ́vɨ koyo ini̱ ve'e ii̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Te cha̱a‑ún, ni̱ jini̱‑de nuu̱ Pedro jíín Juan, ja̱ kuákɨ̱vɨ‑de ini̱ ve̱'e ii̱. Te ni̱ ka'a̱n nda̱'ú‑de jíín‑de ja̱ ná kuá'a‑de ɨɨn caridad. ");
INSERT INTO migNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Te Pedro jíín Juan, ni̱ kande̱'é vá'a‑de nuu̱ cháa‑ún. Te ni̱ kaka'a̱n‑de jíín‑de: Yá'a nde̱'é‑ró núu̱‑rí, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Te máá cháa‑ún, ndátu tu̱'a‑de, jáni ini̱‑de ni'i̱n‑dé yaku̱ na̱ jíín núu̱ Pedro jíín Juan. ");
INSERT INTO migNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Te ni̱ kachi̱ Pedro: Tú ñáva̱'a‑ri̱ plata ni oro. Ko ja̱ ñáva̱'a‑ri̱, yu̱án kuá'a‑ri̱ nuu̱‑ro̱. Jíín sɨ́'vɨ́ máá Jesucristo ñuu̱ Nazaret ndukuiñi̱ te kaka‑ró, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Te ni̱ tɨɨn‑de ndavá'a cha̱a‑ún. Te ni̱ xndúkuiñi̱‑de cha̱a. Te ja'a̱‑dé jíín sukún já'a̱‑dé, ni̱ kandu̱va̱'a‑ni. ");
INSERT INTO migNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Te ɨɨn ni̱ kanda‑ni‑de. Te ni̱ ndukuiñi̱‑de. Te ni̱ jika‑de. Te ni̱ kɨ̱vɨ‑de jíín Pedro jíín Juan ini̱ ve̱'e ii̱, jíka‑de, kánda‑de, te nákana jaa‑de Dios. ");
INSERT INTO migNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Te ni̱ kajini̱ ta̱ká ña̱yɨvɨ núu̱‑dé ja̱ nákaka‑de te nákana jaa‑de Dios. ");
INSERT INTO migNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Te ni̱ nakuni̱‑i nuu̱‑dé ja̱ máá cháa jikán caridad yuxé'é vé'e ii̱ ja̱ nání hermosa kúu‑de. Te ni̱ ka̱kee nuu̱‑í kánde̱'é‑i. Te ni̱ kayu̱'ú‑i, chi̱ kájini̱‑i ja̱ súan ni̱ ta'a̱n cha̱a‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Te cha̱a ni̱ nduva̱'a‑ún, nini tɨ́ɨn‑de Pedro jíín Juan, te ni̱ kataka̱‑ni ña̱yɨvɨ núu̱‑dé ini̱ corredor ja̱ nání Salomón. Te ni̱ ka̱kee nuu̱‑í kánde̱'é‑i. ");
INSERT INTO migNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Te ni̱ jini̱ Pedro ja̱ súan kúu. Te ni̱ ka'a̱n‑de jíín ñáyɨvɨ‑ún: Cha̱a ñuu̱ Israel, naja̱ kánaa iní‑ní kánde̱'é‑ní tiñu yá'a. Naja̱ kánde̱'é‑ní nuu̱‑ná. Kájani ini̱‑ní ja̱ cháa va̱'a kákuu‑ná xí íó fuerza ini̱‑ná náva̱'a nakaka cha̱a yá'a sá'a‑ná náún. ");
INSERT INTO migNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Máá Dios Abraham, jíín Isaac, jíín Jacobo, máá Dios, Táa̱‑yo̱, ni̱ nduñá'nu Se̱'e‑ya̱ Jesús ni̱ sá'a‑ya̱, te ni̱ ka̱nastúu‑ní Jesús, te ni̱ ka̱naku̱xndíi‑ní I'a̱‑ún jíto nuu̱ Pilato, va̱sa sía̱ cha̱a‑ún‑ya̱ kuní‑de núú. ");
INSERT INTO migNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ko máá‑ní, ni̱ ka̱ské'ichi̱‑ní I'a̱ ii̱, I'a̱ ndoo. Te ni̱ kajika̱n‑ní ɨɨn cha̱a já'ni ndɨ́yi sía̱ Pilato. ");
INSERT INTO migNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Te ni̱ ka̱ja'ni‑ní máá Jíto'o̱, I'a̱ náschakú yóó. Ko Dios, ni̱ naschakú‑ya̱ Jesús onde̱ ma̱'ñú ndɨ́yi. Te máá‑ná kákuu‑ná testigo ja̱ súan íó. ");
INSERT INTO migNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Te a kájini̱‑ní cha̱a yá'a te kánakuni̱‑ní‑de. Te ni̱ kandíja‑de Jesús jíín sɨ́'vɨ́‑yá, te ja̱ yúán ní nasáva̱'a‑ya̱‑dé. Chi̱ kándíja‑de‑ya̱, te yu̱án ní nduva̱'a ii̱ cháa yá'a nátu̱'un kájini̱ máá‑ní. ");
INSERT INTO migNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ko vina ñáni̱, a jiní‑ná chi̱ sɨkɨ̱ já tú ní kájuku̱'un ini̱‑ní kúu ja̱ ní ka̱sá'a‑ní súan, te suni súan ni̱ ka̱sá'a cha̱a kátá'ú tíñu nuu̱‑ní. ");
INSERT INTO migNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Te jíín kɨvɨ́, ni̱ ka̱jani cha̱a tu̱'un onde̱ sáá ní sá'a Dios, ndasa koo tiñu, jíín ndása ndo'o Cristo. Te vina a ni̱ skíkuu‑ya̱ súan. ");
INSERT INTO migNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Te ná náxíó káva ini̱‑ní, te ná nákani ini̱‑ní jíná'an‑ní núsáá, náva̱'a ná ndá'va̱ ta̱ká kua̱chi‑ní, te chaa̱ kɨvɨ̱ já ndúsɨɨ̱ iní‑ní sá'a máá Jíto'o̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Náva̱'a tájí Dios Jesucristo kii‑ya̱, nátu̱'un ni̱ sándaa̱‑ya̱ já kúu níí onde̱ sáá. ");
INSERT INTO migNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ko jínu ñú'ún já kéndo̱o‑ya̱ ondé andɨ́vɨ́, onde̱ kɨvɨ̱ ndújáá táká ndatíñu, nátu̱'un ni̱ kaka'a̱n cha̱a ndoo ni̱ ka̱jani tu̱'un onde̱ aná'án ní sá'a Dios. ");
INSERT INTO migNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Chi̱ Moisés, ni̱ ka'a̱n‑de jíín táa̱‑yo̱: Máá Tatá‑ro̱ Dios, kua̱'a‑ya̱ ɨ́ɨn cha̱a nátu̱'un ruu̱, te kani‑de tu̱'un nuu̱‑ro̱. Te kenda‑de ma̱'ñú táká ñani̱‑ro̱ nátu̱'un ni̱ kenda‑ri̱. Te ná chú'un ini̱‑ro̱ tú'un ka'a̱n cha̱a‑ún nú na̱ún ndɨ'ɨ tu̱'un ka'a̱n‑de jíín‑ró. ");
INSERT INTO migNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Te nú ndé cha̱a tú kuní‑de chu'un ini̱‑de tu̱'un ka'a̱n cha̱a kani tu̱'un‑ún, te naa íi̱‑dé ma̱'ñú táká‑ga̱ ña̱yɨvɨ, áchí Moisés. ");
INSERT INTO migNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Te ta̱ká cha̱a ni̱ ka̱jani tu̱'un, onde̱ kɨvɨ̱ ní kii Samuel te nɨ́ɨ́‑gá onde̱ vina, suni ni̱ ka̱jani‑de tu̱'un ja̱ kíi kɨvɨ̱ yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Máá‑ní kákuu se̱'e cha̱a ni̱ ka̱jani tu̱'un‑ya̱ jíín sé'e sɨkɨ̱ contrato ni̱ sándaa̱ Dios jíín táa̱‑yo̱. Te ni̱ ka'a̱n‑ya̱ jíín Abraham: Onde̱ chi̱i tata̱‑ro̱ kénda ja̱ kéndo̱o ndatu̱ ta̱ká se̱'e ñu̱yɨ́vɨ sá'a, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Te Dios, ni̱ naschakú‑ya̱ Sé'e‑ya̱. Te ni̱ tájí‑yá Se̱'e‑ya̱, te ni̱ kii‑ya̱ nuu̱ máá‑ní xna'a̱n‑ga̱, náva̱'a chaxio‑ya̱‑ní nuu̱ táká kua̱chi‑ní. Yúan‑na te kendo̱o ndatu̱‑ní. ");
INSERT INTO migNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Te nini káka'a̱n‑de jíín ñáyɨvɨ‑ún, te sutu̱, jíín já kúñá'nu ini̱ ve̱'e ii̱, jíín saduceo, ni̱ cha̱koyo‑ún nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Te kákiti̱ xaa̱n iní ja̱ kástá'a̱n apóstol nuu̱ ñáyɨvɨ, ja̱ kájani‑de tu̱'un Jesús ja̱ á ni̱ nachaku̱‑ya̱ má'ñú ndɨ́yi. ");
INSERT INTO migNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Te ni̱ ka̱katɨɨn‑ún‑de. Te ni̱ ka̱chindee‑de ini̱ veka̱a onde̱ kɨvɨ̱ xía̱n‑ún, chi̱ a ni̱ ini. ");
INSERT INTO migNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ko kua'a̱ xáa̱n ñáyɨvɨ ní ka̱jini so̱'o‑i tu̱'un ni̱ kaka'a̱n cha̱a apóstol. Te ni̱ ka̱kandíja‑i. Te ni̱ ji̱nu nátu̱'un u'u̱n mil cha̱a. ");
INSERT INTO migNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Te kɨvɨ̱ xía̱n‑ún, te cha̱a kákuñá'nu nuu̱ máá‑i, jíín cháa ni̱ ka̱yii, jíín cháa káchaa tutu̱, ni̱ ka̱ndutútú‑de ini̱ ñuu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Te suni ni̱ ka̱ndutútú‑de jíín máá sutú ñá'nu‑ga̱ Anás, jíín Caifás, jíín Juan, jíín Alejandro, jíín táká‑ga̱ ja̱ kákuu tá'an sutu̱ ñá'nu‑ga̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Te ni̱ ka̱jani‑ún‑de ma̱'ñú. Te ni̱ kajika̱ tu̱'ún‑de: Na̱ jíín fuerza, xí na̱ jíín sɨ́'vɨ́ kásá'a‑ró tíñu yá'a, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yúan‑na te Pedro, chi ni̱ kútú‑de jíín Espíritu Santo, te ni̱ kachi̱‑de jíín cháa‑ún: Níí cha̱a kákuñá'nu ini̱ ñuu̱, jíín níí cha̱a ni̱ ka̱yii nuu̱ ñúu̱ Israel: ");
INSERT INTO migNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Vina te nú xndichí‑ní náá sɨkɨ̱ ɨ́ɨn tiñu va̱'a ni̱ ka̱sá'a‑ná jíín ɨ́ɨn cha̱a kú'u̱ yá'a nú ndasa ni̱ nduva̱'a‑de, ");
INSERT INTO migNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","núsáá te máá‑ní jíín táká ña̱yɨvɨ ñúu̱ Israel, ná júku̱'un ini̱‑ní ja̱ jíín sɨ́'vɨ́ máá Jesucristo ñuu̱ Nazaret ni̱ nduva̱'a cha̱a kándii̱ nuu̱‑ní yá'a. Te suu I'a̱‑ún ni̱ ka̱ja'ni‑ní‑ya̱ jiká cruz. Ko ni̱ nachaku̱‑ya̱ má'ñú ndɨ́yi ni̱ sá'a Dios. ");
INSERT INTO migNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","I'a̱ yá'a kúu yuu̱ já ní ka̱ské'ichi̱ níí, cha̱a káchutá'an ve'e. Te yuu̱‑ún, máá yúu̱ ndíso fuerza jiki̱ kúu vina. ");
INSERT INTO migNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Te tuká ɨnga̱ cha̱a nama yóó, chi̱ túu ɨnga̱ sɨ́'vɨ́ nání ni ɨɨn cha̱a íó ini̱ ñu̱yɨ́vɨ yá'a ja̱ kúu nama ta̱ká ña̱yɨvɨ jíná'an‑i. Achí Pedro. ");
INSERT INTO migNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Yúan‑na te ni̱ kajini̱ ja̱ tú káyu̱'ú Pedro jíín Juan káka'a̱n‑de. Te a kájini̱ ja̱ tú tu̱'a va̱'a‑de, chi̱ tú ní kájika‑de escuela. Te ni̱ ka̱naa iní kánde̱'é núu̱‑dé. Te ni̱ kaju̱ku̱'un ini̱ ja̱ ní ka̱jika‑de jíín Jesús. ");
INSERT INTO migNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Te kánde̱'é núu̱ cháa ni̱ nduva̱'a‑ún, kándichi̱‑de jíín Pedro jíín Juan. Te tú ní kákuu kutɨ xndíó káni ni ɨɨn tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ko ni̱ ka̱tá'ú tíñu nuu̱‑dé ja̱ ná kénda koyo‑de ichi yatá municipio nini ná ndátu̱'ún máá jíná'an. ");
INSERT INTO migNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Te ni̱ kaka'a̱n: Ndasa sá'a‑yó jíín cháa yá'a núsáá. Chi ja̱ndáa̱ kúu ja̱ ní jicha̱ tu̱'un kua'a̱n nuu̱ táká ña̱yɨvɨ ñúu̱ Jerusalén ja̱ súan ni̱ kasá'a‑de ɨɨn tiñu ñá'nu. Te ma̱ kúu ka'a̱n‑yo̱ já tú íó ndaa̱. ");
INSERT INTO migNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ko náva̱'a ma̱ kuichá‑ga̱ tu̱'un yá'a ki'i̱n nuu̱ táká ña̱yɨvɨ, te ná ká'a̱n xaa̱n‑yo̱ núu̱‑dé ja̱ má kachí kutɨ‑gá‑de tu̱'un cha̱a‑ún nuu̱ ní ɨɨn ña̱yɨvɨ, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Te ni̱ ka̱nakana xini̱‑dé. Te ni̱ ka̱tá'ú tíñu nuu̱‑dé ja̱ má ká'a̱n‑ga̱‑de te ma̱ stá'a̱n‑ga̱‑de ni ɨɨn tu̱'un jíín sɨ́'vɨ́ Jesús. ");
INSERT INTO migNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Yúan‑na te ni̱ kaka'a̱n Pedro jíín Juan: Tava máá‑ní cuenta te nú játa'a̱n ini̱ Dios ja̱ kuándatu̱‑ná nuu̱‑ní xna'a̱n‑ga̱ vásá núu̱ máá‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Chi̱ nɨ́nɨ káni‑ná tu̱'un ja̱ ní kajini̱‑ná jíín já ní ka̱jini so̱'o‑ná. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yúan‑na te cha̱a junta, ni̱ kaka'a̱n xaa̱n núu̱ Pedro jíín Juan, te ni̱ sía̱‑de kua'a̱n‑de, chi̱ tú ní káni'i̱n kútɨ modo xndó'o Pedro jíín Juan, chi̱ káyu̱'ú kájito ña̱yɨvɨ, chi ta̱ká‑i, kánakana jaa‑i Dios sɨkɨ̱ já ní kuu‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Chi cha̱a ni̱ nduva̱'a jíín tíñu ñá'nu‑ún, ví'í‑gá uu̱ xiko kuia̱ íó‑de. ");
INSERT INTO migNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Te ni̱ kaka̱ku‑de kája'a̱n‑de. Te ni̱ naja̱koyo‑de nuu̱ tá'an‑de. Te ni̱ ka̱nakani‑de ta̱ká tu̱'un ni̱ kaka'a̱n sutu̱ ñá'nu jíín cháa ni̱ ka̱yii nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Te súan ni̱ ka̱jini so̱'o‑i tu̱'un kánakani‑de. Te ɨɨn jínu‑ni ni̱ kaka'a̱n jaa‑i jíín Dios: Táta̱, máá‑ní kúu Dios ni̱ sá'a andɨ́vɨ́, ñu̱yɨ́vɨ, mar, jíín táká‑ga̱ ndatíñu. ");
INSERT INTO migNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Te jíín Espíritu Santo ni̱ ka'a̱n‑ní jíín yú'u táa̱‑yo̱ David, ja̱ ní kuu‑de mozo‑ní. Chi ni̱ ka'a̱n‑de: Naja̱ kákiti̱ ini̱ ña̱yɨvɨ, te naja̱ kánakani sáni ini̱‑i. ");
INSERT INTO migNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ni̱ kataka̱ cha̱a kákuu rey ñu̱yɨ́vɨ jíná'an‑de. Te cha̱a kákuñá'nu‑ún, ni̱ ka̱kutútú‑de. Te ɨɨn‑na̱ ni̱ ka̱ndonda‑de sɨkɨ̱ máá Tatá Dios jíín sɨkɨ́ Cristo‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Chi̱ Herodes jíín Poncio Pilato jíín cháa sɨ́ɨn nación jíín ñáyɨvɨ ñúu̱ Israel, ni̱ ka̱kutútú ndíja‑de ini̱ ñuu̱ yá'a, ni̱ ka̱ndonda‑de sɨkɨ̱ Sé'e ii̱‑ní Jesús, I'a̱ ni̱ jani‑ní, ");
INSERT INTO migNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","náva̱'a sá'a‑de ta̱ká tiñu ni̱ teta'a̱n máá‑ní, jíín já ní kundaa̱ ini̱‑ní onde̱ sáá. ");
INSERT INTO migNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Te vina, Táta̱, nde̱'é‑ní ndasa káka'a̱n xaa̱n‑dé nuu̱‑ná jíná'an‑ná. Te kua̱'a‑ní fuerza nuu̱ mozo‑ní ja̱ ná chúndéé iní‑ná kani‑ná tu̱'un máá‑ní. ");
INSERT INTO migNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Te skáa̱‑ní nda'a‑ní náva̱'a sá'a‑ní tana̱, jíín tuní, jíín tíñu ñá'nu. Te ta̱ká yu̱án ná kúu jíín sɨ́'vɨ́ máá Sé'e ii̱‑ní Jesús. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Te súan ni̱ kajika̱n ta'u̱‑í. Te nuu̱ ká'i̱in tútú‑i‑ún, ni̱ ta̱an. Te ndɨ'ɨ‑i, ni̱ ka̱kútú‑i jíín Espíritu Santo. Te ni̱ ka̱chundéé iní‑i kájani‑i tu̱'un Dios. ");
INSERT INTO migNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Te ña̱yɨvɨ kuá'a̱ kákandíja, chi̱ jíín iní jíín añú‑i ni̱ ka̱nduu ɨɨn núú‑i. Te tú ni ɨɨn‑i ní káka'a̱n‑i ja̱ máá‑i xíin ɨ́ɨn ndatíñu. Chi ta̱ká ndatíñu, ni̱ kaña̱va̱'a ká'nu‑i. ");
INSERT INTO migNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Te téyíí xáa̱n kájani ndaa̱ apóstol tu̱'un ndasa ni̱ kajini̱‑de ja̱ ní nachaku̱ Jito'o̱‑yo̱ Jesús. Te bueno ni̱ kuu tu̱'un luu Dios ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Te tú kutɨ na̱ún nándɨ'ɨ ni ɨɨn‑de, chi ta̱ká cha̱a káxíin ñú'un, xí vé'e, ni̱ kaxi̱kó‑de, te ni̱ ka̱kinchaka‑de xu̱'ún, ");
INSERT INTO migNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","te ni̱ ka̱chúkú‑de xu̱'ún‑ún nuu̱ já'a̱ cháa apóstol. Te cha̱a apóstol ni̱ ka̱saka‑dé nuu̱ ɨ́ɨn ɨɨn tá'an‑de ndasa kájinu ñú'ún máá‑i. ");
INSERT INTO migNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Te José, tata̱ Leví, ncháá‑de ñuu̱ Chipre, íó ɨnga̱ sɨ́'vɨ́‑de kájatíñu apóstol, nání‑de Bernabé, ja̱ kuní ka'a̱n, se̱'e tu̱'un ndéé iní. ");
INSERT INTO migNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ni̱ xi̱kó‑de ɨɨn ñu'un‑dé. Te ni̱ kinchaka‑de xu̱'ún. Te ni̱ chúkú‑de xu̱'ún‑ún nuu̱ já'a̱ cháa apóstol. ");
INSERT INTO migNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ko ɨɨn cha̱a nání Ananías jíín ñásɨ́'ɨ́‑de Safira, ni̱ kaxi̱kó‑de ɨɨn ñu'un. ");
INSERT INTO migNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Te ni̱ janchaa̱‑de sava xu̱'ún. Te suni jiní ñasɨ́'ɨ́‑de ja̱ súan ni̱ sá'a‑de. Te ni̱ kinchaka‑de yaku̱‑ni. Te ni̱ chúkú‑de nuu̱ já'a̱ cháa apóstol. ");
INSERT INTO migNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Te ni̱ ka'a̱n Pedro: Ananías, naja̱ ní kɨ̱vɨ Satanás ini̱ añú‑ro̱ já xndá'ú‑ro̱ Espíritu Santo núú. Chi ni̱ janchaa̱‑ro̱ sáva xu̱'ún ñú'un ní kaxi̱kó‑ró. ");
INSERT INTO migNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ná té xi̱kó‑ga̱‑ro̱, á nasu̱ máá‑ró xíin núú. Te nuu̱ ní xi̱kó‑ró, á nasu̱ iní nda'a máá‑ró ñú'un núú. Naja̱ ní nakani ini̱‑ro̱ sá'a‑ró súan. Ko nasu̱ cháa xndá'ú‑ro̱, chi̱ Dios, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Te súan ni̱ jini so̱'o Ananías ta̱ká tu̱'un yá'a, te ni̱ ndua̱‑ni‑de. Te ni̱ ji'i̱‑ni‑de. Te ta̱ká ña̱yɨvɨ ní ka̱jini so̱'o tu̱'un‑ún, ni̱ kayu̱'ú xaa̱n‑í. ");
INSERT INTO migNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Te ni̱ ka̱ndukuiñi̱ cha̱a súchí. Te ni̱ ka̱xndánuu‑de ndɨ̱yi‑ún, te ni̱ ka̱kiñi'in‑de‑i yata̱ vé'e. Te ni̱ ka̱chiyu̱ji‑de‑i. ");
INSERT INTO migNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Te ni̱ kunúu, nátu̱'un uni̱ hora. Te ni̱ jaa̱ ñasɨ́'ɨ́‑de ni̱ kɨ̱vɨ‑ña vé'e‑ún. Te na̱ún jiní máá‑ña ja̱ súan ni̱ kuu. ");
INSERT INTO migNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Te Pedro, ni̱ jika̱ tu̱'ún‑de‑ña: Kastu̱'ún núu̱‑rí. Ni̱ xi̱kó‑ró ñú'un‑ún ɨɨn tanto súan xí túu. Achí‑de. Te ni̱ kachi̱‑ña: Jaa̱n, ɨɨn súan ni̱ kaxi̱kó‑ná, áchí‑ña. ");
INSERT INTO migNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Te Pedro, ni̱ ka'a̱n‑de jíín‑ña: Naja̱ ní skétá'an‑ró tú'un ja̱ kóto nchaa̱‑ro̱ Espíritu máá Tatá Dios. Kuni so̱'o, yuxé'é yá'a ká'ma va̱i koyo cha̱a ni̱ kachi̱ndu̱ji yii‑ro. Te suni súan kiñi'in‑de róó ki'i̱n‑ro̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Te ni̱ ndua̱‑ni‑ña núu̱ já'a̱ Pedro. Te ni̱ ji'i̱‑ni‑ña. Te ni̱ ndɨ̱vɨ koyo cha̱a súchí‑ún. Te ni̱ kajini̱‑de ja̱ á ni̱ ji'i̱‑ña. Te ni̱ ka̱kiñi'in‑de‑ña, te ni̱ ka̱chindu̱ji‑de‑ña xíin yíi‑ñá. ");
INSERT INTO migNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Te ndivii tɨ́ku'ni̱ kándíja jíín táká ña̱yɨvɨ ní ka̱jini tu̱'un tiñu yá'a, ni̱ kayu̱'ú xaa̱n‑í. ");
INSERT INTO migNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Te cha̱a apóstol, ni̱ ka̱sá'a‑de kua'a̱ tíñu ñá'nu jíín tuní jíto nuu̱ ñáyɨvɨ. Te ɨɨn ká'nu‑ni kándutútú‑de ini̱ corredor Salomón. ");
INSERT INTO migNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ko tú ní chúndéé iní ni ɨɨn‑i ketá'an‑i jíín‑de. Ko ña̱yɨvɨ, ví'í‑gá ni̱ ka̱jatú'ún‑i‑de. ");
INSERT INTO migNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Te ña̱yɨvɨ ní ka̱kandíja nuu̱ máá Jíto'o̱‑yo̱, ví'í‑gá ni̱ ndea̱‑i, kúu cha̱a kúu ña'an, kua'a̱ xáa̱n‑í. ");
INSERT INTO migNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Te ni̱ ka̱kincha̱ka‑de kua'a̱ ñáyɨvɨ káku'u̱. Te ni̱ kajaki̱n‑de‑i ini̱ ya̱'ya kánda̱a‑i nuu̱ jíto jíín núu̱ yúu, náva̱'a nú va̱i Pedro sanaa jinu̱ va̱sté máá kátɨ‑dé sɨkɨ̱‑í. ");
INSERT INTO migNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Te suni ta̱ká ña̱yɨvɨ ñúu̱ yani‑ún, ni̱ kataka̱ kua'a̱‑í ini̱ ñuu̱ Jerusalén, ni̱ ka̱kinchaka‑i ja̱ káku'u̱ jíín já káta'a̱n tachi̱ kíni. Te ndɨ'ɨ‑ún, ni̱ kandu̱va̱'a jíná'an. ");
INSERT INTO migNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yúan‑na te ni̱ ka̱kukuásún iní sutu̱ ñá'nu jíín sáva tá'an ja̱ káchíñú'ún sɨkɨ́ saduceo, te ni̱ ka̱ndonda. ");
INSERT INTO migNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Te ni̱ ka̱katɨɨn‑ún cháa apóstol. Te ni̱ ka̱taan‑dé ini̱ veka̱a ñuu̱. ");
INSERT INTO migNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ko ndajá'a̱ máá Tatá Dios, akuáa ní juña‑ya̱ yúxé'é véka̱a‑ún. Te ni̱ kiñi'in ya̱‑dé jíná'an‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: ");
INSERT INTO migNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Kuá'án, te kuiñi‑ró iní ve̱'e ii̱. Te yúan kani‑ró táká tu̱'un nuu̱ ñáyɨvɨ ndasa kuchaku̱‑i vida jáá yá'a. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Te ni̱ ka̱jini so̱'o‑de tu̱'un yá'a. Te nuu̱ ní kundiji̱n, te ni̱ kɨ̱vɨ koyo‑de ini̱ ve̱'e ii̱. Te ni̱ ka̱stá'a̱n‑de tu̱'un nuu̱ ñáyɨvɨ. Te nini kástá'a̱n‑de, te ni̱ cha̱koyo sutu̱ ñá'nu jíín tá'an‑de. Te ni̱ na̱stútú‑de cha̱a junta jíín cháa ni̱ ka̱yii ini̱ ñuu̱ Israel. Te ni̱ tájí‑de ndajá'a̱ kuáki̱'in‑de cha̱a‑ún ini̱ veka̱a. ");
INSERT INTO migNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ko nuu̱ ní ja̱koyo cha̱a kákuu ndajá'a̱‑ún veka̱a, te tú ní káni'i̱n‑dé apóstol. Te ni̱ kanaxíó káva‑de. Te ni̱ kaka̱stu̱'ún‑de tu̱'un yá'a: ");
INSERT INTO migNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ja̱ndáa̱ kúu ja̱ ní kajini̱‑ná ndasú va̱'a veka̱a. Te ká'i̱in cha̱a kándi̱to‑ún ichi yúxé'é. Ko nuu̱ ní ka̱juña‑ná, te tú kutɨ na̱ún cha̱a ní kájini̱‑ná nuu̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Te cha̱a kúñá'nu ini̱ ve̱'e ii̱ jíín sutú ñá'nu, nuu̱ ní ka̱jini so̱'o‑de tu̱'un yá'a, ni̱ ka̱kejá'á‑de káyu̱'ú‑de ja̱ má júkuiñi̱ tu̱'un‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ko ni̱ jaa̱ ɨɨn ña̱yɨvɨ. Te ni̱ kastu̱'ún‑i: Ña'a̱n‑ní, te nde̱'é‑ní. Cha̱a ni̱ ka̱taan‑ní veka̱a, ká'i̱in‑de ini̱ ve̱'e ii̱. Te kástá'a̱n‑de tu̱'un nuu̱ ñáyɨvɨ. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yúan‑na te ni̱ kaja'a̱n cha̱a kúñá'nu‑ún jíín ndájá'a̱. Te ñúkúún vái‑de jíín apóstol, chi̱ káyu̱'ú‑de kájito‑de ña̱yɨvɨ já kuá'a‑i yuu̱ xiní‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Te nuu̱ ní jaa̱‑de jíín apóstol, te ni̱ jani‑de cha̱a‑ún ini̱ municipio. Te sutu̱ ñá'nu, ni̱ xndichí‑ún: ");
INSERT INTO migNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Á tú ní kástu̱'ún‑rí nuu̱‑ro̱ já má stá'a̱n‑ga̱‑ro̱ tú'un cha̱a jia̱n. Ko vina chi̱ nɨ́ɨ́ ñúu̱ Jerusalén ni̱ xndeá‑ro̱ sá'a̱n‑ro̱. Te kákuni̱‑ro̱ cháa‑ró nɨñí cháa jia̱n sɨkɨ́‑rí jíná'an‑ri̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ko Pedro jíín apóstol, ni̱ kaka'a̱n‑de: Nɨ́nɨ kuándatu̱‑ná nuu̱ Dios vásá núu̱ táká cha̱a. ");
INSERT INTO migNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Máá Dios ndɨ̱yi táa̱‑yo̱, ni̱ naschakú‑ya̱ Jesús, I'a̱ ni̱ ka̱ja'ni máá‑ní ja̱ ní ka̱jata kaa‑ní‑ya̱ jiká cruz. ");
INSERT INTO migNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","I'a̱ yá'a ni̱ nduñá'nu‑ya̱ kánchaa̱‑ya̱ íchi ndává'a Dios. Te ni̱ nduu‑ya̱ I'a̱ tá'ú tíñu jíín I'a̱ nama yóó, náva̱'a nakani ini̱ ña̱yɨvɨ ñúu̱ Israel te koo tu̱ká'nu ini̱‑ya̱ núu̱ táká kua̱chi‑i. ");
INSERT INTO migNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Te máá‑ná jíín Espíritu Santo, kákuu‑ná testigo máá‑yá nuu̱ táká tu̱'un yá'a. Chi̱ já'a Dios Espíritu‑ya̱ núu̱ táká ña̱yɨvɨ kájandatu̱ nuu̱‑yá. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Te máá‑ún, súan ni̱ ka̱jini so̱'o tu̱'un yá'a. Te ni̱ kakiti̱ xaa̱n iní. Te ka'ni‑ún‑de kákuni̱ núú. ");
INSERT INTO migNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ko íó ɨɨn maestro ley, nání‑de Gamaliel. Te kúu‑de cha̱a fariseo. Te ta̱ká ña̱yɨvɨ, kájatú'ún‑i‑de. Te ni̱ ndukuiñi̱‑de nuu̱ junta. Te ni̱ tá'ú‑de tiñu ná kúxio núu cha̱a apóstol. ");
INSERT INTO migNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Te ni̱ ka'a̱n‑de jíín: Róó cha̱a ñuu̱ Israel, kani va̱'a ini̱‑ro̱ te nú na̱ún kákuni̱ ro̱ sá'a‑ró jíín cháa yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Chi̱ onde̱ sáá ní ndonda Teudas, te áchí‑de ja̱ cháa téyíí kúu‑de. Te ni̱ kataka̱‑i nuu̱‑dé nátu̱'un kuu̱n ciento cha̱a. Te ni̱ ji'i̱‑de ni̱ sá'a sava‑ga̱ cha̱a. Te ta̱ká ja̱ ní ka̱jandatu̱ tu̱'un ni̱ ka'a̱n‑de, ni̱ kajicha̱ nu̱u kája'a̱n sáni. ");
INSERT INTO migNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yúan‑na te kɨvɨ̱ ní ndutútú xiní, te ni̱ ndonda Judas cha̱a ñuu̱ Galilea. Te ni̱ jaka‑de kua'a̱ ñáyɨvɨ kuángoyo yata̱‑dé. Te suni ni̱ naa cháa‑ún. Te ta̱ká ña̱yɨvɨ ní ka̱jandatu̱ nuu̱‑dé, ni̱ kajicha̱ nu̱u‑i kája'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Te vina ná kuá'a‑ri̱ consejo róó: Ma̱ ké'é‑ga̱‑ro̱ cháa yá'a. Sía̱‑de ná kí'i̱n‑de. Chi̱ nú onde̱ chi̱i ña̱yɨvɨ vái tu̱'un yá'a xí tíñu yá'a, te naa íi̱. ");
INSERT INTO migNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ko nú onde̱ nuu̱ Dios va̱i, ma̱ kúu kasu̱‑ro̱. Chi̱ sánaa te natu̱u ja̱ jíín Dios kájatá'an‑ró. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Te ni̱ ka̱jatú'ún tú'un ni̱ ka'a̱n Gamaliel. Te ni̱ ka̱kana xini̱ cháa apóstol. Te ni̱ kaskúun yunu xíi suku̱n‑dé. Te ni̱ ka'a̱n xaa̱n núu̱‑dé ja̱ má ká'a̱n‑ga̱‑de tu̱'un jíín sɨ́'vɨ́ Jesús. Te ni̱ ka̱sía̱‑de kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Te máá apóstol, nuu̱ junta ni̱ kenda koyo‑de kája'a̱n‑de, kákusɨɨ̱ iní‑de ja̱ ní jatu̱'un‑ya̱ kándo'o‑de sɨkɨ̱ sɨ́'vɨ́‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Te ini̱ ve̱'e ii̱ jíín táká ve'e, tú ní kájukuiñi̱‑de ja̱ kástá'a̱n‑de te kájani‑de tu̱'un Jesucristo. ");
INSERT INTO migNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Te ni̱ ndea̱ kua'a̱ cháa káskuá'a. Te ɨɨn kɨvɨ̱, te cha̱a ñuu̱ Grecia, ni̱ kaka'a̱n sóó‑de sɨkɨ̱ cháa hebreo, chi̱ tú ní téta'a̱n ɨɨn núú‑de staa̱ kée ñá'an viuda hora ja̱ sáka‑dé ndɨta'a̱n kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yúan‑na te máá uxí uu̱ apóstol, ni̱ ka̱nastútú‑de ta̱ká cha̱a káskuá'a, te ni̱ kaka'a̱n‑de: Ma̱ kúu jukuiñi̱ máá‑rí ja̱ kájani‑ri̱ tu̱'un Dios, te kuatíñu‑ri̱ nuu̱ mesa. ");
INSERT INTO migNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Núsáá te róó ñáni̱, ka̱ji‑ró usiá tá'an máá‑ró, cha̱a va̱'a, cha̱a ndíchí, cha̱a káñu̱'un chítú Espíritu Santo ná kúu‑de. Te ná cháa‑yó tíñu yá'a sɨkɨ̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Te ruu̱ jíná'an‑ri̱, kukuu‑ri̱ jíín já kakán ta'u̱‑rí, te kani‑ri̱ tu̱'un yá'a. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Te tu̱'un ni̱ ka'a̱n‑de, ni̱ ka̱jata'a̱n ini̱ ña̱yɨvɨ kuá'a̱‑ún. Te ni̱ kaka̱ji‑i Esteban, cha̱a kándíja va̱'a kúu‑de. Te ñú'un chítú‑de Espíritu Santo, jíín Felipe, jíín Prócoro, jíín Nicanor, jíín Timón, jíín Parmenas, jíín Nicolás, cha̱a ni̱ naki'in sé'é judío ñuu̱ Antioquía. ");
INSERT INTO migNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ta̱ká cha̱a yá'a, ni̱ ka̱jani‑i nuu̱ cháa apóstol. Te ni̱ kajika̱n ta'u̱‑dé te ni̱ ka̱xndée‑de nda'a‑dé xini̱ cháa‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Te tu̱'un Dios ni̱ jika kua'a̱n. Te cha̱a káskuá'a, ni̱ kandea̱ xaa̱n‑dé ini̱ ñuu̱ Jerusalén. Te suni kua'a̱ sutú ni̱ ka̱jatú'ún, te ni̱ ka̱kandíja. ");
INSERT INTO migNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Te Esteban, ni̱ chítú ndɨ́ɨ‑de jíín fuerza, te ñúkúún ní sá'a‑de tiñu ñá'nu xaa̱n jíín tuní nuu̱ táká ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Te ini̱ ve̱'e sinagoga ni̱ ka̱ndonda yaku̱ cha̱a, cha̱a libertino, jíín cháa ñuu̱ Cirene, jíín cháa ñuu̱ Alejandría, jíín cháa ñuu̱ Cilicia, jíín Asia, ni̱ kastátá'an jíín Esteban. ");
INSERT INTO migNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ko tú ní kákundéé jíín‑de, chi̱ ndíchí‑de, te suni ni̱ ka'a̱n‑de jíín fuerza máá Espíritu. ");
INSERT INTO migNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yúan‑na te ni̱ ka̱ská'a̱n yaku̱ cha̱a ja̱ ní kaka'a̱n: Ni̱ ka̱jini so̱'o‑ná ká'a̱n ndɨva̱'a Esteban sɨkɨ̱ Moisés jíín sɨkɨ́ Dios, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Te súan ni̱ ka̱ská'a̱n‑ún ñáyɨvɨ, jíín cháa ni̱ ka̱yii, jíín cháa káchaa tutu̱. Te ni̱ kajinu̱ yu̱án sɨkɨ́‑dé, te ni̱ ka̱katɨɨn‑ún‑de kua̱ngoyo jíín‑de onde̱ nuu̱ junta. ");
INSERT INTO migNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Te ni̱ ka̱jani testigo falso ja̱ ní kaka'a̱n: Cha̱a yá'a, ndɨta'a̱n kɨvɨ̱ ká'a̱n ndɨva̱'a‑de sɨkɨ̱ vé'e ii̱ yá'a jíín sɨkɨ́ ley. ");
INSERT INTO migNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Chi ni̱ ka̱jini so̱'o‑ná ká'a̱n‑de ja̱ Jesús, cha̱a ñuu̱ Nazaret, kanu̱‑de ve'e ii̱ yá'a, te nasama‑de tani̱nu ni̱ xndóo Moisés nuu̱‑yo̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yúan‑na te ta̱ká ja̱ káxiu̱kú iní municipio, ni̱ ka̱ndakoto nuu̱‑dé, te ni̱ kajini̱ ja̱ jíto nuu̱‑dé nátu̱'un nuu̱ ɨ́ɨn ndajá'a̱ ándɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Te máá sutú ñá'nu‑ga̱, ni̱ ka'a̱n jíín‑de: Súan kúu náún, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Te máá‑de, ni̱ ka'a̱n‑de: Táta̱, ñáni̱, kuni so̱'o‑ní tu̱'un yá'a jíná'an‑ní. Máá Dios, I'a̱ ñá'nu, I'a̱ luu, ni̱ kenda‑ya̱ núu̱ táa̱‑yo̱ Abraham ná ni̱ kanchaa̱‑de ini̱ ñuu̱ Mesopotamia, onde̱ ná té ki'i̱n‑ga̱‑de kunchaa̱‑de ini̱ ñuu̱ Harán núú. ");
INSERT INTO migNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Te ni̱ ka'a̱n‑ya̱ jíín‑de: Kenda ini̱ ñuu̱‑ro̱ jíín má'ñú tá'an‑ró, te ki'i̱n‑ro̱ kúnchaa̱‑ro̱ iní ñuu̱ ja̱ stá'a̱n‑ri̱ nuu̱‑ro̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yúan‑na te ni̱ kenda‑de ini̱ ñuu̱ Caldea. Te ni̱ kanchaa̱‑de ini̱ ñuu̱ Harán. Te yúan ni̱ ji'i̱ táa̱‑de. Te ni̱ sá'a Dios ja̱ ní chaa̱‑de ñuu̱ yá'a nuu̱ káxiu̱kú‑ní vina. ");
INSERT INTO migNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Te tú ní já'a‑ya̱ ñú'un‑ún kuu ta'u̱‑dé, ni va̱sté ɨ́ɨn tí'li̱. Ko ni̱ keyu'u‑yá ja̱ kuá'a‑ya̱ ñú'un‑ún nuu̱‑dé onde̱ jíín núu̱ táká tata̱ kii nuu̱‑dé, va̱sa tú ní íó se̱'e‑de sáá. ");
INSERT INTO migNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Te súan ni̱ ka'a̱n Dios jíín‑de: Tata̱‑de kuxiu̱kú jíká‑i ɨnga̱ ñuu̱. Te kuu̱n ciento kuia̱ kuatíñu sáni‑de‑i te xndó'o‑de‑i. ");
INSERT INTO migNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Te ni̱ ka'a̱n Dios: Ko máá‑rí, ndonda‑ri̱ sɨkɨ̱ ñúu̱ nuu̱ kúu‑i mozo‑ún. Te onde̱ nú ni̱ kuu‑ún, te kenda koyo‑i te chiñú'ún‑i ruu̱ ichi yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Te ni̱ sá'a‑ya̱ contrato jíín‑de jíín tuní ja̱ xɨtɨ́ ndúu̱‑de. Te se̱'e Abraham ni̱ kuu Isaac. Te ni̱ xɨtɨ ndúu̱‑de‑i nuu̱ uná kɨvɨ̱‑í. Te se̱'e Isaac ni̱ kuu Jacob, te se̱'e Jacob ni̱ kuu ndɨ́'uxí uu̱ máá tatá ñúu̱. ");
INSERT INTO migNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Te ta̱ká tatá ñúu̱‑ún, ni̱ ka̱kukuásún iní‑de. Te ni̱ kaxi̱kó‑de José kua'a̱n‑i onde̱ ñuu̱ Egipto, Ko Dios ni̱ jika‑ya̱ jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Te ni̱ nama‑ya̱‑í nuu̱ táká tu̱ndó'o ni̱ ta'a̱n‑i. Te ni̱ kundíchí‑i. Te Faraón, cha̱a kúu rey ñuu̱ Egipto, ni̱ kusɨɨ̱ iní‑de jíín‑i ni̱ sá'a‑ya̱. Te ni̱ chaa‑de gobernador sɨkɨ̱ José. Te José, ni̱ tá'ú‑de tiñu nuu̱ ñúu̱ Egipto jíín núu̱ vé'e Faraón. ");
INSERT INTO migNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Te ni̱ kii ɨɨn tama̱ xáa̱n nɨ́ɨ́ ñúu̱ Egipto jíín nɨ́ɨ́ ñúu̱ Canaán. Ɨɨn tu̱ndó'o xaa̱n ní kuu‑ún. Te ndɨ̱yi táa̱‑yo̱, tú ní káni'i̱n‑dé ja̱ kée‑dé jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Te ni̱ jini tu̱'un Jacob ja̱ íó trigo onde̱ ñuu̱ Egipto. Te ni̱ tájí‑de táa̱‑yo̱ ní kaja'a̱n‑de vuelta ɨɨn. ");
INSERT INTO migNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Te ja̱ vuelta uu̱, ni̱ ka̱nakuni̱ ñani̱ José nuu̱‑dé ja̱ máá‑de kúu. Te suni ni̱ stá'a̱n José ñani̱‑de nuu̱ Faraón. ");
INSERT INTO migNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Te José, ni̱ tájí‑de cha̱a kája'a̱n ja̱ ní kana‑de xini̱ táa̱‑de Jacob kii‑de jíín táká tá'an‑de. Ió uni̱ xiko xia'u̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Súan ni̱ kuun Jacob kua'a̱n‑de onde̱ ñuu̱ Egipto. Te yúan ni̱ ji'i̱‑de jíín táká tatá ñúu̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Te cha̱a‑ún, ni̱ ka̱naja̱'a‑de káno'o̱n‑de onde̱ ñuu̱ Siquem. Te ni̱ kayu̱ji‑de ini̱ ve̱'e añú ja̱ jíín plata ni̱ jaan Abraham nuu̱ sé'e Hamor ñuu̱ Siquem. ");
INSERT INTO migNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ko ni̱ kuyani kɨvɨ̱ ní keyu'u Dios nuu̱ Abraham. Te ña̱yɨvɨ‑ún, ni̱ ndea̱‑i. Te ni̱ kukua'a̱‑í ini̱ ñuu̱ Egipto. ");
INSERT INTO migNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Te ni̱ kuu kuia̱. Te ni̱ nukuiñi̱ ɨnga̱ rey ini̱ ñuu̱ Egipto ja̱ tú játú'ún‑de tu̱'un José. ");
INSERT INTO migNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Te rey‑ún, ni̱ xndá'ú‑de ña̱yɨvɨ ñúu̱‑yo̱, ni̱ sándɨva̱'a‑de jíín táa̱‑yo̱, ja̱ fuerza ná skána‑de se̱'e‑de kuu̱‑i. ");
INSERT INTO migNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Te kuia̱‑ún ni̱ kaku Moisés. Te ni̱ kusɨɨ̱ iní Dios jíín‑i. Te uni̱ yoo̱ ní ja'nu‑i ini̱ ve̱'e táa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Te náa̱‑i, ni̱ skána‑ña‑í. Te ni̱ naki'in se̱sɨ́'ɨ́ Faraón‑ún‑i. Te ni̱ skuá'nu‑ña‑í nátu̱'un se̱'e máá‑ña. ");
INSERT INTO migNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Te ni̱ kutu̱'a Moisés ta̱ká tu̱'un ndíchí ñúu̱ Egipto. Te ñá'nu xaa̱n ní kuu‑de jíín táká tu̱'un ká'a̱n‑de jíín táká tiñu sá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Te nuu̱ úu̱ xiko kuia̱‑de, te ni̱ kusɨɨ̱ iní‑de kinde̱'é‑de ta̱ká ñani̱‑de ja̱ kákuu se̱'e Israel. ");
INSERT INTO migNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Te ni̱ jini̱‑de nuu̱ ɨ́ɨn cha̱a Egipto ja̱ sándɨva̱'a jíín ɨ́ɨn cha̱a Israel. Te ni̱ stují‑dé cha̱a Egipto‑ún, te súan ni̱ nama‑de ñani̱ nda̱'ú‑de. ");
INSERT INTO migNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ko máá‑de, jáni ini̱‑de ja̱ júku̱'un ini̱ ta̱ká ñani̱‑de ja̱ Dios ni̱ tájí‑yá‑de ja̱ náma‑de ñani̱‑de núú. Ko máá ñaní‑de, tú ní kájuku̱'un kutɨ iní. ");
INSERT INTO migNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Te ɨnga̱ kɨvɨ̱ xía̱n‑ún, suni ni̱ jini̱‑de nuu̱ úu̱ cha̱a kája̱tá'an. Te ni̱ jaa̱‑de. Te ni̱ ka'a̱n‑de jíín já ná júkuiñi̱: Súchi̱, naja̱ kásá'a ndɨva̱'a‑ró jíín tá'an‑ró. Chi̱ ñani̱‑ro̱ kánakuni̱ tá'an‑ró. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ko máá cháa já'a ta'u̱ tá'an‑ún, ni̱ chujíkí‑de Moisés. Te ni̱ ka'a̱n‑de: Ndéja̱ ní jani róó ja̱ kúñá'nu‑ró te sándaa̱‑ro̱ tíñu‑ri̱ jíná'an‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Te suni kuní‑ro̱ ká'ni‑ro rúu̱ nátu̱'un ni̱ ja'ni‑ro cháa ñuu̱ Egipto iku náún. Achí‑de jíín Moisés. ");
INSERT INTO migNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Te tu̱'un yá'a ni̱ jini so̱'o Moisés. Te ni̱ jinu‑de kua'a̱n‑de. Te jíká ní ncha̱a‑de onde̱ ñuu̱ Madián. Te yúan ni̱ skáku ñasɨ́'ɨ́‑de uu̱ se̱'e yíí. ");
INSERT INTO migNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Te ni̱ ji̱nu tuku uu̱ xiko kuia̱. Yúan‑na te ɨɨn ndajá'a̱ ándɨ́vɨ́, ni̱ kenda‑ya̱ núu̱‑dé onde̱ nuu̱ ñú'un té'é yúku Sinaí, ma̱'ñú ɨ́ɨn yuku̱ kayú yáá ñú'u̱n ni̱ kenda‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Yúan‑na te Moisés, ndé'é‑de, te náa iní‑de ja̱ ní jini̱‑de ñu'u̱n‑ún. Te ni̱ kandita‑de náva̱'a kuni̱‑de nuu̱. Te ni̱ ka'a̱n máá Tatá‑yo̱ Dios jíín‑de: ");
INSERT INTO migNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Máá‑rí kúu Dios ndɨ̱yi táa̱‑ro̱, Dios Abraham, Dios Isaac, Dios Jacob, áchí‑ya̱. Ko Moisés, kɨ́sɨ‑i‑de, te tú ní chúndéé iní‑de nde̱'é‑de nuu̱. ");
INSERT INTO migNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Te máá Tatá Dios, ni̱ kachi̱‑ya̱ jíín‑de: Kiñi'in ndija̱n‑ro̱ já'a̱‑ro̱. Chi̱ nuu̱ kándii̱‑ro̱ jián, ñu'un íi̱ kúu. ");
INSERT INTO migNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","A ni̱ jini̱‑ri̱ ja̱ sé'e‑ri̱ ká'i̱in‑i ini̱ ñuu̱ Egipto, xaa̱n kándo'o‑i. Te suni jíni so̱'o‑ri̱ ja̱ kánde'e̱ nda̱'ú‑i. Te ni̱ kuun‑ri̱ va̱i‑ri̱ ja̱ náma‑ri̱‑i jíná'an‑i. Te vina, ña'a̱n yá'a núsáá. Te ná tájí‑rí róó ki'i̱n‑ro̱ ondé ñuu̱ Egipto. Achí‑ya̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Núsáá te Moisés yá'a, va̱sa a ni̱ ka̱ské'ichi̱‑i‑de te va̱sa ni̱ kaka'a̱n‑i: Ndéja̱ ní jani róó ja̱ kúñá'nu‑ró sɨkɨ́‑rí, te sándaa̱‑ro̱ tíñu‑ri̱, ni̱ achi̱‑i jíín‑de. Ko Dios, ni̱ tájí‑yá‑de kua'a̱n‑de ja̱ tá'ú‑de tiñu nuu̱‑í te nama‑de‑i. Te ndajá'a̱‑yá ja̱ ní kenda nuu̱‑dé nuu̱ yukú‑ún, suni ni̱ chindéé ní chituu‑ya̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Te cha̱a yá'a, ni̱ ndiñi'in‑de‑i jíná'an‑i ini̱ ñuu̱ yúan, te ni̱ sá'a‑de kua'a̱ tíñu ñá'nu, jíín táká tuni̱ ini̱ ñuu̱ Egipto, jíín núu̱ mar kuá'á, jíín núu̱ ñú'un té'é, uu̱ xiko kuia̱. ");
INSERT INTO migNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Cha̱a yá'a kúu Moisés ja̱ ní ka'a̱n jíín táká se̱'e Israel: Ma̱'ñú táká ñani̱‑ro̱, nukuiñi̱ ɨɨn cha̱a kani tu̱'un máá Tatá‑ro̱ Dios sá'a‑ya̱ nátu̱'un ruu̱. Te nuu̱ cháa‑ún kuni ná'ín‑ró tú'un ka'a̱n‑de. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Cha̱a‑ún kúu cha̱a ni̱ kandee jíín tɨ́ku'ni̱ ndɨ̱yi táa̱‑yo̱ ondé nuu̱ ñú'un té'é. Te ni̱ ka'a̱n ɨɨn ndajá'a̱‑ya̱ jíín‑de xini̱ yúku Sinaí, te ni̱ ni'i̱n‑dé tu̱'un ndasa kuchaku̱‑yo̱. Te ni̱ jani‑de tu̱'un‑ún nuu̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ko ndɨ̱yi táa̱‑yo̱, tú ní kákuni̱‑de kuandatu̱‑de nuu̱ cháa‑ún, chi̱ sasua ni̱ ka̱ské'ichi̱‑de cha̱a. Te ni̱ ka̱kusɨ́ɨn ini̱‑de, no'o̱n‑de ñuu̱ Egipto kákuni̱‑de núú. ");
INSERT INTO migNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Te ni̱ kaka'a̱n‑de jíín Aarón: Sáva̱'a tɨnɨ̱‑ro̱ I'a̱ ná kúxnúú núu̱‑yo̱. Chi cha̱a Moisés, ja̱ ní kiñi'in‑de yóó ini̱ ñuu̱ Egipto va̱i‑yó, tú kájini̱‑yo̱ na̱ún ní ta'a̱n‑de. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yúan‑na te ni̱ ka̱sá'a‑de ɨɨn chelu. Te nuu̱ ndosó‑ún ni̱ kasoko̱‑dé kɨtɨ. Te ni̱ ka̱kusɨɨ̱ iní‑de jíín tíñu ni̱ ka̱sá'a‑de jíín ndá'a‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Te Dios, ni̱ kuxio‑ya̱ núu̱‑dé kua'a̱n‑ya̱. Te ni̱ xndóo‑ya̱‑dé ná kuátíñu‑de nuu̱ tíñu̱ú xíní ándɨ́vɨ́, nátu̱'un yóso núu̱ tutú cha̱a ni̱ ka̱jani tu̱'un Dios onde̱ sáá: Róó ña̱yɨvɨ Israel, a ni̱ ka̱ja'ni‑ro kɨ́tɨ núu̱‑rí uu̱ xiko kuia̱ nuu̱ ñú'un té'é náún. ");
INSERT INTO migNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Túu, chi̱ sasua ni̱ ka̱jani‑ró vé'e kuii ndosó Moloc jíín tíñu̱ú xíní máá Renfán, ndoso̱ ja̱ ní ka̱sá'a máá‑ró já chíñú'ún‑ró. Ja̱ yúán ná sjá'a‑ri̱ róó ki'i̱n‑ro̱ ondé yata̱ ñúu̱ Babilonia, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ndɨ̱yi táa̱‑yo̱, onde̱ ñu'un té'é ní ka̱ñava̱'a‑de ve'e ñii Dios, nátu̱'un ni̱ tá'ú Dios tiñu nuu̱ Moisés ja̱ súan sá'a‑de ve'e‑ún, nátu̱'un muestra ni̱ jini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Sáá chi̱ jíín fuerza Dios ni̱ ka̱skúnu ndɨ̱yi táa̱‑yo̱ ñáyɨvɨ sɨ́ɨn nación ja̱ ní katɨ̱ɨn máá‑i ñuu̱ yá'a. Yúan‑na te jíín Josué ni̱ kɨ̱vɨ koyo‑de ini̱ lugar máá‑i, ni̱ ka̱kinchaka‑de ve'e ñii‑ún ni̱ kendo̱o yá'a onde̱ kɨvɨ̱ David. ");
INSERT INTO migNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Te David, ni̱ kusɨɨ̱ iní Dios jíín‑de. Te ni̱ jika̱n‑de ja̱ ná sáva̱'a‑de ɨɨn ve'e kuu Dios Jacob. ");
INSERT INTO migNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ko Salomón, ni̱ sá'a‑de ɨɨn ve'e máá‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ko I'a̱ ñá'nu‑ún, tú ncháá‑ya̱ iní ve̱'e kásá'a cha̱a, nátu̱'un ni̱ ka'a̱n cha̱a jáni tu̱'un‑ya̱ ondé sáá: ");
INSERT INTO migNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Andɨ́vɨ́ kúu silla kánchaa̱‑ri̱, te tá'ú‑rí tiñu. Ñu̱yɨ́vɨ kúu teyu̱ nuu̱ káxndíi ja'a̱‑rí. Ndasa koo ve'e kani‑ró kúnchaa̱‑ri̱ núsáá. Xí ndénu̱ kúu nuu̱ ndéta̱tú‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Á tú ní sá'a ndɨ'ɨ‑ri̱ ndatíñu yá'a, áchí máá Tatá Dios. ");
INSERT INTO migNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Xaa̱n kákujá'a̱ ini̱‑ní. Tú kákandíja ini̱ añú‑ní te xaa̱n só'ó‑ní. Chi̱ nene̱ kájasu̱‑ní nuu̱ Espíritu Santo, nátu̱'un ni̱ ka̱sá'a ndɨ̱yi táa̱‑ní onde̱ aná'án. ");
INSERT INTO migNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ió ɨɨn cha̱a ni̱ ka̱jani tu̱'un‑ya̱ ondé sáá ja̱ tú ní káchindiki̱n táa̱‑ní‑de náún. Chi̱ táa̱‑ní, a ni̱ ka̱ja'ni‑dé cha̱a kájani tu̱'un ja̱ kíi máá I'a̱ ndaa̱ núú. Te I'a̱‑ún, a ni̱ kanastúu‑ní‑ya̱ te ni̱ ka̱ja'ni‑ní‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ko máá‑ní, tú ní káskíkuu‑ní, va̱sa ndajá'a̱ máá‑yá, ni̱ ka̱jani‑ya̱ ley nuu̱‑ní. Achí Esteban. ");
INSERT INTO migNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ta̱ká tu̱'un yá'a ni̱ ka̱jini so̱'o. Te ni̱ ka̱ta'u'u̱ ini̱. Te kánakaji ñíi yú'u kájito Esteban. ");
INSERT INTO migNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ko máá Esteban, ni̱ kútú‑de Espíritu Santo. Te ni̱ ndakoto‑de ichi ándɨ́vɨ́. Te ni̱ jini̱‑de ja̱ ndíi ncháa̱ nuu̱ kánchaa̱ Dios. Te Jesús, kándii̱‑ya̱ íchi ndává'a Dios. ");
INSERT INTO migNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Te ni̱ ka'a̱n‑de: Vina te ndé'é‑rí ja̱ núña andɨ́vɨ́. Te ndé'é‑rí nuu̱ máá Sé'e cha̱a kándii̱‑ya̱ íchi ndává'a Dios. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Yúan‑na te ni̱ ka̱kana kó'ó. Te ni̱ kajasu̱ so̱'o. Te ɨɨn jínu‑ni ni̱ ka̱ndonda vaa̱ sɨkɨ̱ Esteban. ");
INSERT INTO migNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Te ni̱ ka̱kiñi'in Esteban kua'a̱n jíín‑de onde̱ yu'u ñúu̱. Te ni̱ ka̱skána tɨka̱chí. Te ni̱ kaja̱'a yuu̱ xiní‑dé. Te ña̱yɨvɨ kánde̱'é, ni̱ ka̱chúkú‑i tɨka̱chí‑ún nuu̱ já'a̱ ɨ́ɨn cha̱a súchí nání Saulo. ");
INSERT INTO migNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Te nini kájoto̱ yuu̱ xiní Esteban, te ni̱ ka'a̱n nda̱'ú Esteban jíín máá Jíto'o̱‑yo̱: Táta̱ Jesús, naki'in‑ní añú‑ná vina, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Te ni̱ jukuiñi̱ jítɨ́‑de. Te ni̱ ka'a̱n jaa‑de: Táta̱, ma̱ chí'i‑ní cuenta kua̱chi yá'a sɨkɨ̱‑í jíná'an‑i, áchí‑de. Súan ni̱ ka'a̱n‑de tu̱'un yá'a, te ni̱ ji'i̱‑ni‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Te Saulo, ni̱ jatú'ún‑de ja̱ ní ji'i̱ Esteban. Te kɨvɨ̱‑ún ni̱ kejá'á káchindiki̱n xaa̱n‑í tɨku'ni̱ kándíja ini̱ ñuu̱ Jerusalén. Te tɨku'ni̱‑ún, ni̱ kajicha̱ nu̱u‑i kája'a̱n‑i nɨ́ɨ́ ndáñúu̱ Judea jíín ndáñúu̱ Samaria. Ko cha̱a apóstol chi̱ túu. ");
INSERT INTO migNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Te cha̱a káchiñú'ún Dios, ni̱ kajachi̱ndu̱ji‑de Esteban. Te ni̱ kande'e̱ xaa̱n‑dé ja̱ ní naa Esteban. ");
INSERT INTO migNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ko Saulo, chi̱ xnáa‑dé tɨku'ni̱ kándíja kuní‑de. Te kɨ́vɨ‑de ndɨta'a̱n ve'e. Te ñú'un‑de cha̱a, ña'an, táan‑dé‑i veka̱a. ");
INSERT INTO migNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Te ta̱ká ña̱yɨvɨ ní kajicha̱ nu̱u‑ún, kája'a̱n‑i ta̱ká ñuu̱ kájani‑i tu̱'un Dios. ");
INSERT INTO migNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Te Felipe, ni̱ kuun‑de kua'a̱n‑de ñuu̱ Samaria. Te yúan ni̱ jani‑de tu̱'un Cristo nuu̱ ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Te ta̱ká ña̱yɨvɨ‑ún, ni̱ ka̱chu'un ini̱‑i ta̱ká tu̱'un ja̱ ní ka'a̱n Felipe jíín‑i. Te ni̱ ka̱jini so̱'o‑i, te ni̱ kajini̱‑i ta̱ká tuni̱ ni̱ sá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Chi̱ ini̱ kua'a̱ ñáyɨvɨ ní kiñi'in‑de tachi̱ kíni. Te ni̱ kenda‑ún kákana kó'ó kája'a̱n. Te tɨnɨ̱ cha̱a ni̱ kuyúnú jíín cháa rengo, ni̱ kandu̱va̱'a‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Te ni̱ ka̱kusɨɨ̱ xáa̱n iní ña̱yɨvɨ ñúu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Te ini̱ ñuu̱‑ún ni̱ i̱o ɨɨn cha̱a nání Simón. Te cha̱a‑ún, cha̱a ña̱vá'a kúu‑de. Te xaa̱n kánaa iní ña̱yɨvɨ ñúu̱ Samaria kánde̱'é‑i. Te ni̱ ka'a̱n‑de ja̱ ɨ́ɨn cha̱a ñá'nu xaa̱n kúu máá‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Te ña̱yɨvɨ, xaa̱n vá'a káchu'un ini̱‑i tu̱'un ká'a̱n‑de onde̱ su̱chí lúlí te onde̱ cha̱a ñá'nu. Te ni̱ kaka'a̱n‑i: Cha̱a yá'a xaa̱n yí'i fuerza Dios ñá'nu ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Te káchu'un ini̱‑i tu̱'un ká'a̱n‑de, chi̱ xaa̱n káni kɨvɨ́ ní sá'a‑de tiñu ña̱vá'a nuu̱‑í, ni̱ ka̱naa iní‑i kánde̱'é‑i. ");
INSERT INTO migNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ko nuu̱‑í ni̱ jani Felipe tu̱'un va̱'a ñuu̱ nuu̱ tá'ú Dios tiñu, jíín tú'un sɨ́'vɨ́ Jesucristo. Yúan‑na te ni̱ ka̱kandíja‑i. Te ni̱ ka̱janducha‑í kúu cha̱a kúu ña'an. ");
INSERT INTO migNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Te máá Simón, suni ni̱ kandíja‑de, ni̱ janducha‑dé. Te ni̱ jika kuu‑de jíín Felipe, ndé'é‑de ja̱ sá'a Felipe ta̱ká tuni̱ jíín táká tiñu ñá'nu. Te ni̱ kee nuu̱‑dé kándii̱‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Te cha̱a apóstol ká'i̱in‑de ini̱ ñuu̱ Jerusalén, ni̱ ka̱jini tu̱'un‑de ja̱ ñáyɨvɨ ñúu̱ Samaria, ni̱ ka̱jatá'ú‑i tu̱'un Dios. Te ni̱ ka̱tájí‑de Pedro jíín Juan kája'a̱n‑de yúan. ");
INSERT INTO migNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Te ni̱ ja̱koyo cha̱a‑ún. Te ni̱ kajika̱n ta'u̱‑dé ja'a̱ ñáyɨvɨ‑ún, náva̱'a ná ní'i̱n‑í Espíritu Santo jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Chi̱ té cha'a̱n‑ga̱ kii‑ya̱ sɨkɨ́ ní ɨɨn‑i. Chi̱ máni ni̱ ka̱janducha‑í jíín sɨ́'vɨ́ Jesús. ");
INSERT INTO migNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yúan‑na te ni̱ ka̱chaa‑de nda'a‑dé xini̱‑í jíná'an‑i te ni̱ chaa̱ Espíritu Santo sɨkɨ̱‑í. ");
INSERT INTO migNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Te ni̱ jini̱ Simón ja̱ súan káchaa apóstol nda'a‑dé xini̱ ñáyɨvɨ‑ún, te já'a‑ya̱ Espíritu Santo nuu̱‑í. Te kua̱'a‑de xu̱'ún núu̱ apóstol kuní‑de núú. ");
INSERT INTO migNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Te ni̱ ka'a̱n‑de: Suni kuní‑ná ja̱ kuá'a‑ní fuerza yá'a nuu̱‑ná náva̱'a na̱ni ña̱yɨvɨ xndée‑ná nda'a‑ná xini̱‑í, te chaa̱ Espíritu Santo sɨkɨ̱‑í, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Yúan‑na te ni̱ kachi̱ Pedro jíín‑de: Xu̱'ún‑ró ná náa jíín‑ró, chi̱ jáni ini̱‑ro̱ já jíín xú'ún kúu kuaan‑ró tá'u̱ já'a Dios. ");
INSERT INTO migNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tú cuenta‑ro̱ ni tú ta'u̱‑ro̱ já kúndii̱‑ro̱ sɨkɨ́ tíñu yá'a, chi̱ tú íó ndaa̱ ini̱ añú‑ro̱ núu̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Núsáá te nakani ini̱‑ro̱ sɨkɨ́ kuáchi‑ró yá'a. Te nandaka̱n ta'u̱‑ro̱ núu̱ Dios, sanaa te sá'a‑ya̱ túká'nu ini̱‑ya̱ núu̱ kuáchi ñú'un ini̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Chi̱ jiní‑ri̱ ja̱ xáa̱n kújá'a̱ ini̱‑ro̱ núu̱‑yá. Te máni kua̱chi tɨ́ɨn róó. Achí Pedro jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Yúan‑na te ni̱ ka'a̱n Simón jíín‑de: Kaka̱n ta'u̱ máá‑ró já'a̱‑rí nuu̱ máá Jíto'o̱‑yo̱ náva̱'a ni ɨɨn tu̱'un ká'a̱n‑ro̱ jián ma̱ kíi sɨkɨ̱‑rí, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Te máá‑de, ni̱ kaka'a̱n ndaa̱‑de. Te ni̱ ka̱jani‑de tu̱'un Dios. Te ni̱ ka̱naxíó káva‑de káno'o̱n‑de ñuu̱ Jerusalén. Te kua'a̱‑gá ndañúu̱ Samaria kájani‑de tu̱'un va̱'a. ");
INSERT INTO migNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Te ɨɨn ndajá'a̱ máá Tatá Dios, ni̱ ka'a̱n‑ya̱ jíín Felipe: Ndukuiñi̱ te ki'i̱n‑ro̱ íchi sur, ichi já kénda ini̱ ñuu̱ Jerusalén, ja̱ kúun kua'a̱n onde̱ ñuu̱ Gaza. Achí‑ya̱. Te yúan chi̱ ñu'un té'é kúu. ");
INSERT INTO migNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Yúan‑na te ni̱ ndukuiñi̱ Felipe kua'a̱n‑de. Te ni̱ kenda‑ni ɨɨn cha̱a eunuco etíope. Te cha̱a‑ún játíñu‑de nuu̱ reina etíope, nání‑ña Candace. Te ɨɨn gobernador kúu‑de. Te suni ndíto‑de yaka̱ xu̱'ún‑ña. Te ni̱ kii‑de ñuu̱ Jerusalén, ni̱ kichiñú'ún‑de Dios. ");
INSERT INTO migNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Te kua̱no'on‑dé kánchaa̱‑de nuu̱ carreta‑de. Te ká'u‑de tutu̱ ni̱ chaa Isaías cha̱a ni̱ jani tu̱'un Dios onde̱ sáá. ");
INSERT INTO migNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Te máá Espíritu ni̱ ka'a̱n‑ya̱ jíín Felipe: Kuá'án te kita'a̱n‑ro̱ carreta‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Te Felipe, ni̱ kundéé‑de ni̱ jaa̱‑de. Te ni̱ jini so̱'o‑de ká'u cha̱a‑ún tutu̱ ja̱ ní chaa Isaías onde̱ sáá. Te ni̱ jika̱ tu̱'ún‑de cha̱a‑ún: Á júku̱'un ini̱‑ní na̱ún ká'u‑ní xí túu. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Te máá eunuco, ni̱ ka'a̱n‑de jíín Felipe: Te ndasa juku̱'un ini̱‑ná te nú tú stá'a̱n ɨɨn cha̱a nuu̱‑ná, áchí‑de. Te ni̱ ka'a̱n nda̱'ú‑de ja̱ ná káa Felipe nuu̱ carreta‑de te kunchaa̱‑de jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Te nuu̱ ká'u‑de tutu̱ ii̱‑ún ni̱ ka'a̱n tu̱'un yá'a: Nátu̱'un ɨɨn rɨɨ̱ ja̱ kuá'a̱n‑tɨ̱ kúu̱‑tɨ̱, súan ni̱ ja'a̱n‑ya̱. Te nátu̱'un ɨɨn lélú sété tú ndé'e̱‑tɨ̱, suni súan tú ní ká'a̱n kutɨ‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Te hora ni̱ kuka nuu̱‑yá, tú ní sándaa̱ va̱'a‑i jíín‑yá. Ndasa koo tu̱'un tata̱‑ya̱, chi ni̱ ji'i̱‑ya̱ iní ñu̱yɨ́vɨ yá'a. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yúan‑na te cha̱a eunuco‑ún, ni̱ ka'a̱n‑de: Cha̱a ni̱ jani tu̱'un yá'a, ndé sɨkɨ̱ cháa ká'a̱n‑de. Sɨkɨ̱ máá‑de xí sɨkɨ́ ɨngá cha̱a, áchí‑de jíín Felipe. ");
INSERT INTO migNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yúan‑na te Felipe, ni̱ kejá'á‑de ká'a̱n‑de. Te jíín tú'un ká'a̱n tutu̱ ii̱‑ún ni̱ jani‑de tu̱'un va̱'a Jesús nuu̱ cháa‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Te nini kája'a̱n‑de ichi‑ún, te ni̱ ja̱koyo‑de ɨɨn nuu̱ ñú'un nducha. Te ni̱ ka'a̱n cha̱a eunuco: Yá'a ñú'un nducha. Á tú kuu kuanducha‑ná, xí ndéja̱ jasú. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Te ni̱ kachi̱ Felipe: Nú kándíja‑ní onde̱ jíín iní jíín añú‑ní, te kuu, áchí‑de. Te ni̱ ka'a̱n eunuco: Kándíja‑ná ja̱ Jesucristo kúu máá Sé'e Dios, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Te ni̱ tá'ú‑de tiñu ni̱ jukuiñi̱ carreta. Te ni̱ ka̱nuu ndendúú‑de kája'a̱n‑de nuu̱ ñú'un nducha yúan. Te ni̱ skuánducha Felipe cha̱a eunuco. ");
INSERT INTO migNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Te nuu̱ ní ka̱nana‑de ini̱ nducha, te Espíritu máá Tatá Dios, ni̱ chaxio‑ni‑ya̱ Felipe kua'a̱n‑de. Te cha̱a eunuco, tuká ní jiní‑de nuu̱ Felipe. Te ni̱ ki'in‑de ichi kuáno'on‑dé. Te kúsɨɨ̱ iní‑de. ");
INSERT INTO migNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ko Felipe, ni̱ ndenda‑de onde̱ ñuu̱ Azoto. Te nini já'a‑de kua'a̱n‑de, te jáni‑de tu̱'un va̱'a‑ya̱ táká ñuu̱. Te vásá ní jaa̱‑de ñuu̱ Cesarea. ");
INSERT INTO migNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Te Saulo, nákata̱‑de ja̱ ndónda‑de ka'ni‑dé ta̱ká cha̱a káskuá'a tu̱'un máá Jíto'o̱‑yo̱. Te ni̱ jaa̱‑de nuu̱ sutú kúñá'nu‑ga̱. ");
INSERT INTO migNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Te ni̱ jika̱n‑de tutu̱ nuu̱ cháa‑ún ja̱ kí'i̱n‑de ta̱ká ve'e sinagoga ñuu̱ Damasco, náva̱'a katɨɨn‑de sava cha̱a xí ñá'an já ká'i̱in sɨkɨ̱ tú'un‑ya̱. Te ku'ni̱‑de ña̱yɨvɨ‑ún kunchaka‑de‑i kii‑de jíín‑i ñuu̱ Jerusalén kuní‑de. ");
INSERT INTO migNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Te ni̱ ki'in‑de ichi kuá'a̱n‑de. Te ni̱ kuyani‑de ñuu̱ Damasco. Te sánaa‑ní te ni̱ ndii ncháa̱‑ni nɨ́ɨ́ núu̱‑dé onde̱ andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Te ni̱ ndua̱‑ni‑de nuu̱ ñú'un. Te ni̱ jini so̱'o‑de ká'a̱n ɨɨn tu̱'un jíín‑de: Saulo, Saulo, naja̱ chíndiki̱n‑ro̱ rúu̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Te máá‑de, ni̱ ka'a̱n‑de: Ndé cha̱a kúu‑ní vii, Táta̱, áchí‑de. Te ni̱ kachi̱‑ya̱ jíín‑de: Máá‑rí kúu Jesús ja̱ chíndiki̱n‑ro̱ rúu̱. Xaa̱n yíí kúu ja̱ kuañú yátá‑ró punta garrocha. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Te máá‑de, kɨ́sɨ‑i‑de, chi̱ yú'ú‑de. Te ni̱ ka'a̱n‑de: Táta̱, na̱ún sá'a‑ná kuní‑ní, áchí‑de. Te máá Jíto'o̱‑yo̱, ni̱ kachi̱‑ya̱ jíín‑de: Nduko̱o, te kɨ̱vɨ‑ró iní ñuu̱. Te yúan ni'i̱n‑ro̱ tú'un ndasa sá'a‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Te cha̱a kája'a̱n jíín Saulo, ni̱ ka̱jukuiñi̱‑de kákee nuu̱‑dé kánde̱'é‑de. Chi ni̱ ka̱jini so̱'o ndija‑de nɨ́'ɨn, ko tú ní kájini̱‑de nuu̱ ní ɨɨn cha̱a ká'a̱n. ");
INSERT INTO migNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Yúan‑na te ni̱ nduko̱o Saulo nuu̱ ñú'un. Te ni̱ ndakoto‑de. Ko tú ni ɨɨn nuu̱ ní jiní‑de. Te kátɨ̱ɨn cha̱a‑ún nda'a‑dé kája'a̱n‑de jíín‑de. Te ni̱ ka̱skɨ́vɨ‑de Saulo ini̱ ñuu̱ Damasco. ");
INSERT INTO migNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Te yúan ni̱ kanchaa̱‑de uni̱ kɨvɨ̱. Te tú ní kúu kutɨ ndé'é‑de, ni tú ní yée‑dé staa̱, ni tú ní jí'i‑de nducha. ");
INSERT INTO migNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Te ni̱ i̱o ɨɨn cha̱a skuá'a tu̱'un‑ya̱ ñúu̱ Damasco nání‑de Ananías, te jíín jáni ni̱ ka'a̱n máá Jíto'o̱‑yo̱ jíín‑de: Ananías, áchí‑ya̱. Te máá‑de, ni̱ ka'a̱n‑de jíín‑yá: Táta̱, yá'a kánchaa̱‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Te ni̱ ka'a̱n máá Jíto'o̱‑yo̱ jíín‑de: Ndukuiñi̱ te ki'i̱n‑ro̱ íchi yá'ya ja̱ nání derecha. Te ini̱ ve̱'e Judas ná ndúkú‑ró ɨ́ɨn cha̱a nání Saulo ñuu̱ Tarso, chi ja̱ndáa̱ jikán ta'u̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Te skóto ja̱ni‑de ja̱ ɨ́ɨn cha̱a nání Ananías, kɨ́vɨ‑de te cháa nda'a xiní‑dé, náva̱'a ndundiji̱n nduchi‑dé. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yúan‑na te ni̱ ka'a̱n Ananías: Táta̱, a ni̱ jini tu̱'un‑ná sɨkɨ̱ cháa yúan ja̱ xáa̱n sá'a ndɨva̱'a‑de jíín ñáyɨvɨ ndóo‑ní ini̱ ñuu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Te vina ni̱ chaa̱‑de yá'a ndíso‑de tiñu sutu̱ ñá'nu, náva̱'a katɨɨn‑de ta̱ká ña̱yɨvɨ káchiñú'ún‑i níí, te taan‑dé‑i veka̱a. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Te máá Jíto'o̱‑yo̱, ni̱ ka'a̱n‑ya̱ jíín‑de: Kuá'án, chi cha̱a ni̱ ka̱ji máá‑rí kúu cha̱a jia̱n, náva̱'a ná káni‑de tu̱'un‑ri̱ ki'i̱n‑de nɨ́ɨ́ núu̱ ñáyɨvɨ sɨ́ɨn nación, nɨ́ɨ́ núu̱ rey, jíín nɨ́ɨ́ núu̱ táká ña̱yɨvɨ ñúu̱ Israel. ");
INSERT INTO migNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Chi̱ stá'a̱n‑ri̱ nuu̱‑dé ja̱ kánúú ndó'o‑de kua'a̱ xáa̱n túndó'o sɨkɨ̱ sɨ́'vɨ́‑rí. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yúan‑na te kua'a̱n Ananías. Te ni̱ kɨ̱vɨ‑de ini̱ ve̱'e‑ún. Te ni̱ xndée‑de nda'a‑dé xini̱ Saulo. Te ni̱ ka'a̱n‑de: Ñáni̱, Saulo. Máá Jíto'o̱‑yo̱ Jesús, I'a̱ ni̱ kenda nuu̱‑ro̱ íchi vái‑ró, ni̱ tájí‑yá ruu̱ va̱i‑ri̱ nuu̱‑ro̱ náva̱'a ná ndúndiji̱n nduchi‑ro, te ná kútú‑ró Espíritu Santo. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Te ni̱ ko̱yo‑ni nátu̱'un soo̱ yúndúchi‑dé. Te ni̱ ndundiji̱n nduchi‑dé. Te ni̱ ndukuiñi̱‑de. Te ni̱ janducha‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Yúan‑na te ni̱ nakee‑dé staa̱. Te ni̱ nani'i̱n iní‑de. Te ni̱ kendo̱o Saulo yaku̱ kɨvɨ̱ jíín cháa káskuá'a ja̱ káxiu̱kú‑de ini̱ ñuu̱ Damasco. ");
INSERT INTO migNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Te ni̱ kejá'á‑ni‑de jáni‑de tu̱'un Jesucristo ini̱ ve̱'e sinagoga, áchí‑de ja̱ I'a̱ yá'a kúu‑ya̱ Sé'e Dios. ");
INSERT INTO migNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Te ta̱ká ña̱yɨvɨ ní ka̱jini so̱'o tu̱'un ká'a̱n‑de, ni̱ ka̱kee nuu̱‑í kánde̱'é‑i. Te ni̱ kaka'a̱n‑i: Á nasu̱ cháa yá'a xaa̱n sá'a ndɨva̱'a‑de jíín táká ña̱yɨvɨ kándaku ñi'in sɨ́'vɨ́‑yá yá'a núú. Te ja̱ yúán ní chaa̱‑de yá'a, ku'ni̱‑de preso no'o̱n‑de jíín‑i nuu̱ sutú ñá'nu núú. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ko Saulo, ví'í‑gá ni̱ ndúkú ndéé‑de ni̱ sáká núu‑de xini̱ cháa judío káxiu̱kú iní ñuu̱ Damasco, ká'a̱n téyíí‑de ja̱ Jesús kúu Cristo. ");
INSERT INTO migNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Te ni̱ kuu‑ga̱ kɨvɨ̱. Te cha̱a judío, ni̱ ka̱natɨɨn tu̱'un tá'an‑de ja̱ ká'ni‑dé Saulo. ");
INSERT INTO migNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ko Saulo, ni̱ ni'i̱n‑dé tu̱'un ja̱ súan ni̱ kanda̱tu̱'ún cháa‑ún. Te máá cháa judío ndúú ñúú‑ni kájito yu'u‑dé ichi núu̱ kénda yuxé'é ñúu̱ ja̱ ká'ni‑dé Saulo núú. ");
INSERT INTO migNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Yúan‑na te cha̱a káskuá'a jíín‑de, ni̱ ka̱ki'in‑de Saulo akuáa. Te ini̱ ɨɨn ji̱ka ni̱ ka̱skúun‑de cha̱a jika̱ ɨ́ɨn nama̱ ñúu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Te nuu̱ ní najaa̱‑de ñuu̱ Jerusalén, te kuní‑de naketá'an‑de jíín cháa káskuá'a‑ún. Ko máá cháa‑ún, ni̱ kayu̱'ú‑de ni̱ ka̱jito‑de Saulo, chi̱ tú ní kákandíja‑de ja̱ cháa skuá'a kúu Saulo. ");
INSERT INTO migNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ko Bernabé, ni̱ jaka‑de kua'a̱n jíín‑de nuu̱ cháa kákuu apóstol. Te ni̱ jani‑de tu̱'un nuu̱ cháa‑ún ndasa ni̱ jini̱ Saulo nuu̱ máá Jíto'o̱‑yo̱ íchi kuá'a̱n‑de, te ni̱ ka'a̱n‑ya̱ jíín‑de, jíín ndasa ni̱ chundéé iní Saulo ni̱ ka'a̱n téyíí‑de tu̱'un Jesús ini̱ ñuu̱ Damasco. ");
INSERT INTO migNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Te ndénda‑de ndɨ́vɨ‑de ñuu̱ Jerusalén jíín cháa kákandíja yúan. ");
INSERT INTO migNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Te ni̱ jani téyíí‑de tu̱'un máá Jíto'o̱‑yo̱. Te ni̱ státá'an‑de jíín cháa judío ñuu̱ Grecia. Ko máá cháa‑ún, kákuni̱‑de ka'ni‑dé Saulo. ");
INSERT INTO migNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Te ni̱ ka̱jini tu̱'un ta̱ká ñani̱. Te ni̱ ka̱chu'un íchí‑de Saulo onde ñuu̱ Cesarea. Te yúan ni̱ ka̱tájí‑de Saulo kua̱no'on‑dé onde̱ ñuu̱ Tarso. ");
INSERT INTO migNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Te tɨku'ni̱ kákandíja nɨ́ɨ́ iní ñuu̱ Judea, jíín ñúu̱ Galilea, jíín ñúu̱ Samaria, tuká ní káchindiki̱n‑de‑i. Te ni̱ ja'nu‑ga̱‑i jíín tú'un. Te ni̱ ka̱chiñú'ún‑i máá Jíto'o̱‑yo̱. Te ni̱ ka̱ndundéé iní‑i ni̱ sá'a Espíritu Santo. Te ni̱ ndea̱‑ga̱‑i. ");
INSERT INTO migNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Te Pedro, jíka kuu‑de nuu̱‑í ta̱ká lado. Te suni ni̱ ja'a̱n‑de nuu̱ ñáyɨvɨ ndóo ini̱ ñuu̱ Lida. ");
INSERT INTO migNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Te yúan ni̱ jini̱‑de nuu̱ ɨ́ɨn cha̱a nání Eneas, ja̱ ní kuu una̱ kuia̱ káa‑de ji̱to, chi ni̱ kuyúnú‑de. ");
INSERT INTO migNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Te ni̱ kachi̱ Pedro jíín‑de: Eneas, Jesucristo ná násáva̱'a‑ya̱ róó. Nduko̱o, te natuu‑ro jíto‑ró. Achí‑de. Te ni̱ nduko̱o‑ni cha̱a‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Te ni̱ kajini̱ ta̱ká ña̱yɨvɨ káxiu̱kú ñúu̱ Lida jíín ñúu̱ Sarón. Te ni̱ ka̱naxíó káva ini̱‑i nuu̱ máá Jíto'o̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Te suni ni̱ i̱o ɨɨn ña'an skuá'a ini̱ ñuu̱ Jope, nání‑ña Tabita, ja̱ kuní ka'a̱n nuu̱ yú'u griego, Dorcas. Ña'an yá'a, xaa̱n ní sá'a‑ña tíñu va̱'a jíín caridad. ");
INSERT INTO migNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Te kɨvɨ̱‑ún ni̱ ku'u̱‑ña. Te ni̱ ji'i̱‑ña. Te ni̱ ndɨ'ɨ ni̱ nasándoo‑de ña'an‑ún. Te ni̱ kajaki̱n‑de‑ña ɨ́ɨn ini̱ ve̱'e. ");
INSERT INTO migNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Te ñuu̱ Lida, yani kánchaa̱ jíín ñúu̱ Jope. Te cha̱a káskuá'a‑ún, ni̱ ka̱jini tu̱'un‑de ja̱ kánchaa̱ Pedro yúan. Te ni̱ ka̱tájí‑de uu̱ cha̱a kua̱ka'a̱n nda̱'ú jíín Pedro: Ma̱ kúkuéé‑ní te chaa̱‑ní nuu̱‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Yúan‑na te ni̱ ndukuiñi̱ Pedro kua'a̱n‑de jíín‑de. Te nuu̱ ní jaa̱‑de, ni̱ ka̱jaka‑de Pedro kua'a̱n‑de jíín‑de ini̱ ve̱'e‑ún. Te yúan, ta̱ká ña'an viuda, ni̱ ka̱jíkó ndúu̱‑ña‑dé kánde'e̱‑ña. Te kástá'a̱n‑ña táká su'nu̱ jíín táká tɨka̱chí ní sá'a Dorcas ná ni̱ kanchaa̱‑ña jíín‑ña jíná'an‑ña núú. ");
INSERT INTO migNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Yúan‑na te Pedro, ni̱ jacha̱ ndɨ'ɨ‑de ña̱yɨvɨ‑ún kája'a̱n‑i yata̱ vé'e. Te ni̱ jukuiñi̱ jítɨ́‑de. Te ni̱ jika̱n ta'u̱‑dé. Te ni̱ naxíó kóto‑de ichi núu̱ kátúu ndɨ́yi‑ún. Te ni̱ ka'a̱n‑de: Tabita, nduko̱o, áchí‑de. Te máá‑ña, ni̱ ndakoto‑ni‑ña. Te ni̱ jini̱‑ña núu̱ Pedro. Te ni̱ nduko̱o‑ni‑ña. ");
INSERT INTO migNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Te máá‑de, ni̱ tɨɨn‑de nda'a‑ñá. Te ni̱ xndúkuiñi̱‑de‑ña. Yúan‑na te ni̱ kana‑de xini̱ ñáyɨvɨ ndóo jíín viuda. Te ni̱ stá'a̱n‑de‑ña já á chakú‑ña. ");
INSERT INTO migNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Te tiñu yá'a ni̱ jicha̱ tu̱'un nɨ́ɨ́ ñúu̱ Jope kua'a̱n. Te kua'a̱ ñáyɨvɨ, ni̱ ka̱kandíja‑i nuu̱ máá Jíto'o̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Te Pedro, kua'a̱ kɨvɨ́ ní kendo̱o‑de ini̱ ñuu̱ Jope, kánchaa̱‑de ve'e ɨɨn cha̱a curtidor nání Simón. ");
INSERT INTO migNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Te ini̱ ñuu̱ Cesarea ni̱ i̱o ɨɨn cha̱a nání Cornelio, ni̱ kuu‑de capitán, ni̱ tɨ̱ɨn‑de soldado nání Italiana. ");
INSERT INTO migNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cha̱a chíñú'ún vá'a Dios kúu‑de onde̱ jíín nɨ́ɨ́ vé'e‑de. Te bueno sá'a‑de caridad nuu̱ táká ña̱yɨvɨ. Te nene̱ jikán ta'u̱‑de nuu̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Te cha̱a yá'a, ni̱ skóto‑ya̱‑dé nátu̱'un ka̱'uni̱ aíni. Te ni̱ jini̱‑de nuu̱ ɨ́ɨn ndajá'a̱ máá Dios ni̱ kɨ̱vɨ‑ya̱ núu̱ kánchaa̱‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Cornelio, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Te máá‑de, ni̱ ndakoto‑de nuu̱‑yá. Te yú'ú‑de. Te ni̱ ka'a̱n‑de: Na̱ún kuní‑ní Táta̱, áchí‑de. Te ni̱ kachi̱‑ya̱ jíín‑de: A ni̱ jini̱ Dios ndasa jikán ta'u̱‑ro̱ jíín já sá'a‑ró caridad. ");
INSERT INTO migNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Vina te tájí‑ró úu̱ cha̱a ná kí'i̱n‑de ñuu̱ Jope. Te kana‑ró xiní Simón ná kíi‑de, te cha̱a‑ún, nání‑de Pedro. ");
INSERT INTO migNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ncháá núu‑de ve'e ɨɨn cha̱a nání Simón curtidor, ja̱ ncháá ve'e‑de yani yundúcha mar. Te máá‑de kastu̱'ún núu̱‑ro̱ ndéja̱ kánúú sá'a‑ró. Achí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Te ndajá'a̱ ní ka'a̱n jíín Cornelio, a kua'a̱n‑ya̱. Te ni̱ kana‑de xini̱ úu̱ mozo‑de jíín xiní ɨ́ɨn soldado ja̱ játíñu kútu núu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Te onde̱ ni̱ ndɨ'ɨ ni̱ nakani‑de ta̱ká tu̱'un nuu̱ mozo‑ún, te ni̱ tájí‑de mozo kája'a̱n onde̱ ñuu̱ Jope. ");
INSERT INTO migNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Te ɨnga̱ kɨvɨ̱ xía̱n‑ún, kájika‑i kája'a̱n‑i. Te ni̱ ka̱kuyani‑i ñuu̱‑ún. Te Pedro, ná ka̱'uxi̱ uu̱ ni̱ kaa‑de xini̱ vé'e ja̱ kakán ta'u̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Te ni̱ chaa̱ so̱ko chi̱i‑de. Te ni̱ kuni̱‑de kee‑dé staa̱. Ko nini kásátu̱'a‑ña‑ún, te ni̱ skóto‑ya̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Te ni̱ jini̱‑de núña andɨ́vɨ́. Te ɨɨn bulto nátu̱'un ɨɨn sa'ma kuítá já nú'ni̱ ndɨ́kúu̱n punta, ni̱ kuun va̱i nuu̱ ñú'un ní skóto‑ya̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Te ini̱‑ún káñu̱'un ta̱ká kɨtɨ kúu̱n ndá'a íó nuu̱ ñú'un yá'a, jíín kóo̱, jíín táká tɨsaa̱ andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Te ni̱ jini so̱'o‑de ɨɨn tu̱'un ni̱ ka'a̱n: Pedro, ndukuiñi̱, te ka'ni‑ro, te kee‑ro, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ko Pedro, ni̱ ka'a̱n‑de: Ma̱ kúu Táta̱, chi̱ té kee‑gá‑ná ku̱ñu chá'án ni ja̱ tú íó ndoo, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Te ni̱ ka'a̱n tuku jíín‑de vuelta uu̱: Ja̱ ní sándoo Dios, ma̱ skúnání‑ró kúñu chá'án, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Te tu̱'un yá'a ni̱ kii uni̱ vuelta nuu̱‑dé. Te sa'ma kuítá‑ún, ni̱ ndaa kua̱no'on ándɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Te nini kánchaa̱ Pedro jáni ini̱‑de na̱ún kúu ja̱ ní jini̱‑de‑ún, te ni̱ ja̱koyo mozo ni̱ tájí Cornelio kua'a̱n, kájika̱ tu̱'ún‑i ve'e Simón onde̱ ni̱ ja̱koyo‑i yuxé'é cháa‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Te ni̱ kaka'a̱n jaa‑i. Te ni̱ kajika̱ tu̱'ún‑i nú yúan ncháá ɨɨn cha̱a nání Simón, te íó ɨnga̱ sɨ́'vɨ́‑de nání‑de Pedro. ");
INSERT INTO migNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Te nini kánchaa̱ Pedro nákani ini̱‑de nú na̱ún kúu ja̱ ní jini̱‑de‑ún, te ni̱ ka'a̱n máá Espíritu jíín‑de: Ni̱ chaa̱ uni̱ mozo kánandúkú‑i róó. ");
INSERT INTO migNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ndukuiñi̱, te nuu‑ró. Te ma̱ yú'ú‑ro̱ kí'i̱n‑ro̱ jíín‑i. Chi̱ máá‑rí, ni̱ tájí‑rí‑i va̱i‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Yúan‑na te Pedro, ni̱ nuu‑de nuu̱ mozo ni̱ tájí Cornelio. Te ni̱ ka'a̱n‑de: Amigo, máá‑rí kúu cha̱a kánandúkú‑ró. Ndé sɨkɨ̱ kúu ja̱ vái koyo‑ró núu̱‑rí núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Te máá mozo‑ún, ni̱ kaka'a̱n‑i: Cornelio, cha̱a capitán, cha̱a ndaa̱, cha̱a chíñú'ún vá'a Dios kúu‑de. Te suni ta̱ká ña̱yɨvɨ judío káka'a̱n‑i ja̱ cháa va̱'a kúu‑de. Ni̱ ka'a̱n ɨɨn ndajá'a̱ ndóo‑ya̱ jíín‑de ja̱ ná kána‑de xini̱‑ní kii‑ní ki'o̱n vé'e‑de. Te ná kúni ná'ín‑de tu̱'un ka'a̱n‑ní jíín‑de. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Yúan‑na te ni̱ skɨ́vɨ‑de mozo‑ún ini̱ ve̱'e. Te ni̱ ka̱kendo̱o‑i yu̱an. Te ɨnga̱ kɨvɨ̱ xía̱n‑ún, ni̱ nduko̱o‑de. Te ni̱ kee‑de kája'a̱n‑de. Te suni kája'a̱n yaku̱ ñani̱ ñuu̱ Jope jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Te ɨnga̱ kɨvɨ̱ ní ja̱koyo‑de ñuu̱ Cesarea. Te Cornelio, ndátu‑de cha̱a jíná'an‑de, chi ni̱ stútú‑de tá'an‑de jíín amigo va̱'a‑de. ");
INSERT INTO migNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Te nini kɨ́vɨ Pedro ini̱ ve̱'e, te ni̱ kenda Cornelio ka'a̱n‑de jíín Pedro. Te ni̱ jukuiñi̱ jítɨ́‑de nuu̱ já'a̱ Pedro. Te ni̱ chiñú'ún‑de cha̱a. ");
INSERT INTO migNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ko Pedro, ni̱ xndúkuiñi̱‑de Cornelio. Te ni̱ ka'a̱n‑de: Ndukuiñi̱, chi̱ ruu̱, suni cha̱a kúu‑ri̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Te kándatu̱'ún‑de. Te ni̱ kɨ̱vɨ koyo‑de. Te ni̱ jini̱ Pedro ja̱ ní ka̱kutútú kuá'a̱ ñáyɨvɨ káxiu̱kú‑i ini̱ ve̱'e. ");
INSERT INTO migNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Te ni̱ ka'a̱n Pedro jíín ñáyɨvɨ‑ún: A kájini̱‑ní ja̱ tú íó ley ja̱ ɨ́ɨn cha̱a judío, ketá'an‑de xí sá'a‑de ɨɨn visita nuu̱ ɨ́ɨn cha̱a tú kúu judío. Ko Dios, ni̱ stá'a̱n‑ya̱ núu̱‑ná ja̱ tú ni ɨɨn ña̱yɨvɨ chá'án, ña̱yɨvɨ kíni íó. ");
INSERT INTO migNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ja̱ yúán, te nuu̱ ní kana‑ní xini̱‑ná, te vai̱‑ná, tú ní sájá'a̱ ini̱‑ná. Ja̱ yúán jiká tu̱'ún‑ná níí: Na̱ sɨkɨ̱ kúu ja̱ ní kana‑ní náá, áchí Pedro. ");
INSERT INTO migNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Yúan‑na te ni̱ ka'a̱n Cornelio: Vina íó kuu̱n kɨvɨ́ nátu̱'un máá hora yá'a íó ndicha̱ ini̱‑ná. Te ka̱'uni̱ aíni kúu jikán ta'u̱‑ná ini̱ ve̱'e‑ná. Te ni̱ chaa̱ ɨɨn ndajá'a̱‑yá nuu̱‑ná. Te ndíi ncháa̱ sa'ma ñú'un‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Te ni̱ ka'a̱n‑ya̱ jíín‑ná: Cornelio, a ni̱ jini̱ Dios ndasa jika̱n ta'u̱‑ro̱ jíín já sá'a‑ró caridad. ");
INSERT INTO migNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Núsáá te tájí‑ró mozo ná kí'i̱n ñuu̱ Jope. Te kana‑ró xiní ɨ́ɨn cha̱a kúu Simón ja̱ nání‑de Pedro, ná kíi‑de nuu̱‑ro̱. Te cha̱a‑ún, ncháá‑de ve'e ɨɨn cha̱a nání Simón curtidor. Te máá yú'u mar ncháá ve'e‑de. Te chaa̱ cha̱a‑ún, te kastu̱'ún‑de nuu̱‑ro̱, áchí‑ya̱ jíín‑ná. ");
INSERT INTO migNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Súan ni̱ kuu. Te ni̱ tájí‑ná mozo kujaa̱ kana níí. Te va̱'a ni̱ sá'a‑ní ja̱ ní chaa̱‑ní. Te vina, ta̱ká‑ná, ká'i̱in tútú‑ná yá'a nuu̱ Dios, náva̱'a kuni so̱'o‑ná tu̱'un ka'a̱n‑ní, ndasa ni̱ tá'ú Dios tiñu nuu̱‑ní. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Yúan‑na te ni̱ ka'a̱n Pedro: Vina te ni̱ jini̱ ndaa̱‑ná ja̱ Dios tú ncháá nuu̱‑yá ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Chi na̱ni ña̱yɨvɨ, nú káchiñú'ún‑i‑ya̱ te kásátiñu va̱'a‑i nuu̱‑yá, te kúsɨɨ̱ iní‑ya̱ jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ni̱ ka'a̱n‑ya̱ jíín táká se̱'e Israel, ni̱ kastu̱'ún‑yá nuu̱‑í ja̱ máá Jesucristo já'a‑ya̱ tú'un ndéé iní‑i. Te I'a̱ yá'a kúu Jito'o̱ ta̱ká‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Máá‑ní, a kájini tu̱'un‑ní tu̱'un Jesucristo. Chi ni̱ jani Juan tu̱'un jánducha, yúan‑na te ni̱ kejá'á tú'un‑ya̱ ondé ñuu̱ Galilea, te ni̱ jicha̱ nu̱u nɨ́ɨ́ ñúu̱ Judea, ");
INSERT INTO migNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ndasa ni̱ ja̱'a Dios Espíritu Santo jíín fuerza nuu̱‑yá. Te ndasa ni̱ jika kuu ya̱ ní sá'a‑ya̱ tíñu va̱'a, te ni̱ nasáva̱'a‑ya̱ táká ña̱yɨvɨ tá'a̱n tachi̱ kíni. Chi̱ Dios, ni̱ chindéé ní chituu‑ya̱ Jesús ñuu̱ Nazaret. ");
INSERT INTO migNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Te máá‑ná, ni̱ kajini̱‑ná ta̱ká tiñu ni̱ sá'a‑ya̱ iní ñuu̱ Judea, jíín iní ñuu̱ Jerusalén. Te ni̱ ka̱ja'ni‑í‑ya̱, ni̱ ka̱jata kaa‑i‑ya̱ jiká ɨ́ɨn cruz. ");
INSERT INTO migNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ko I'a̱ yá'a, ni̱ nachaku̱‑ya̱ ní sá'a Dios kɨvɨ̱ uní. Te ni̱ ndenda ndiji̱n‑ya̱ ní sá'a Dios. ");
INSERT INTO migNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ko tú ní ndénda ndiji̱n‑ya̱ núu̱ táká ña̱yɨvɨ, chi̱ máni nuu̱ cháa ja̱ á ni̱ ka̱ji Dios ja̱ kúu‑de testigo. Te testigo‑ún kákuu‑ná, chi ni̱ ka̱yee‑ná staa̱ ni̱ ka̱ji'i‑ná nducha jíín‑yá, nuu̱ ní nachaku̱‑ya̱ má'ñú ndɨ́yi. ");
INSERT INTO migNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Te ni̱ tá'ú‑yá tiñu nuu̱‑ná jíná'an‑ná ja̱ ná káni‑ná tu̱'un‑ya̱ núu̱ táká ña̱yɨvɨ. Te ka'a̱n ndaa̱‑ná ja̱ ní jani Dios máá‑yá kuu‑ya̱ juez nuu̱ ñáyɨvɨ káichaku̱ jíín núu̱ ñáyɨvɨ ní kaji'i̱. ");
INSERT INTO migNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Chi tu̱'un I'a̱ yá'a ni̱ kaka'a̱n ndaa̱ ta̱ká cha̱a ni̱ ka̱jani tu̱'un Dios onde̱ sáá. Ja̱ táká ña̱yɨvɨ kándíja nuu̱‑yá, jíín sɨ́'vɨ́‑yá koo tu̱ká'nu ini̱ nuu̱ taká kua̱chi‑i. Achí Pedro. ");
INSERT INTO migNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Te nini ká'a̱n Pedro ta̱ká tu̱'un yá'a, te ni̱ chaa̱‑ni Espíritu Santo sɨkɨ̱ táká ña̱yɨvɨ kájini so̱'o tu̱'un ká'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Te cha̱a kákandíja, ja̱ ní ja̱koyo jíín Pedro, ja̱ kákuu‑de cha̱a ni̱ kaxɨtɨ̱ ndúu̱, ni̱ ka̱naa iní‑de kánde̱'é‑de ja̱ súni ni̱ chaa̱ Espíritu Santo sɨkɨ̱ ñáyɨvɨ sɨ́ɨn nación. ");
INSERT INTO migNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Chi ni̱ ka̱jini so̱'o‑de káka'a̱n ña̱yɨvɨ‑ún sɨ́ɨn yu'u, te kánakana jaa‑i Dios. ");
INSERT INTO migNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Yúan‑na te ni̱ ka'a̱n Pedro: Ndéja̱ jasú kii nducha, náva̱'a ná kuánducha ñáyɨvɨ yá'a, chi ni̱ chaa̱ Espíritu Santo sɨkɨ̱ máá‑i nátu̱'un sɨkɨ̱ máá‑yó, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Te ni̱ tá'ú‑de tiñu nuu̱‑í jíná'an‑i ja̱ ná kuánducha‑í jíín sɨ́'vɨ́ máá Jíto'o̱‑yo̱ Jesús. Yúan‑na te ni̱ kaka'a̱n nda̱'ú‑i jíín‑de ja̱ ná kéndo̱o‑de jíín‑i yaku̱ kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Te cha̱a apóstol jíín táká ñani̱ ká'i̱in nɨ́ɨ́ ñúu̱ Judea, ni̱ ka̱jini tu̱'un‑de ja̱ ñáyɨvɨ sɨ́ɨn nación, suni ni̱ ka̱jatá'ú‑i tu̱'un Dios. ");
INSERT INTO migNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Te ni̱ ndaa Pedro kua̱no'on‑dé ñuu̱ Jerusalén. Te sava cha̱a ni̱ kaxɨtɨ̱ ndúu̱, ni̱ kaka'a̱n sɨkɨ̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Te ni̱ kaka'a̱n‑de: Naja̱ ní kɨ̱vɨ‑ró iní ve̱'e cha̱a tú ní káxɨtɨ̱ ndúu̱, te ni̱ yee‑ro stáa̱ jíín‑de, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Yúan‑na te ni̱ kejá'á Pedro ni̱ jani kájí‑de tu̱'un nuu̱ cháa‑ún: ");
INSERT INTO migNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ni̱ kanchaa̱‑ri̱ ñuu̱ Jope. Te nini jikán ta'u̱‑rí, te ni̱ skóto‑ya̱ rúu̱. Te ni̱ jini̱‑ri̱ ɨɨn bulto nátu̱'un ɨɨn sa'ma kuítá já nú'ni̱ ndɨ́kúu̱n punta. Te ni̱ kuun va̱i onde̱ nuu̱‑rí ichi ándɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Te ni̱ nde̱'é‑rí. Te ni̱ jini̱‑ri̱ ja̱ iní‑ún káñu̱'un kɨtɨ kúu̱n ndá'a kájika nuu̱ ñú'un yá'a, jíín kɨ́tɨ xáa̱n, jíín kóo̱, jíín tɨ́saa̱ andɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Te ni̱ jini so̱'o‑ri̱ ɨɨn tu̱'un ni̱ ka'a̱n jíín‑rí: Pedro, ndukuiñi̱, ka'ni‑ro te kee‑ro. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Te ni̱ ka'a̱n‑ri̱: Ma̱ kúu Táta̱, chi̱ té kee‑gá‑ná ku̱ñu chá'án ni ku̱ñu ja̱ tú íó ndoo. ");
INSERT INTO migNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ko tu̱'un‑ún ni̱ ka'a̱n tuku jíín‑rí onde̱ andɨ́vɨ́: Ja̱ ní sándoo Dios ma̱ skúnání‑ró kúñu chá'án. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Te suni súan ni̱ ka'a̱n uni̱ vuelta. Yúan‑na te ni̱ ndaa bulto‑ún kua̱no'on íchi ándɨ́vɨ́. ");
INSERT INTO migNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Yúan‑na te suni hora‑ún ni̱ ja̱koyo uni̱ mozo kánandúkú‑i ruu̱. Te onde̱ ñuu̱ Cesarea ni̱ ta'u̱ tíñu nuu̱‑í va̱i‑i. Te ni̱ ja̱koyo‑i ve'e‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Te máá Espíritu, ni̱ ka'a̱n‑ya̱ jíín‑rí ja̱ má yú'ú‑ri̱ ki'i̱n‑ri̱ jíín‑i. Te suni ni̱ kaja'a̱n iñu̱ ñani̱ yá'a jíín‑rí. Te ni̱ kɨ̱vɨ koyo‑ri̱ ini̱ ve̱'e ɨɨn cha̱a. ");
INSERT INTO migNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Te cha̱a‑ún, ni̱ jani‑de tu̱'un nuu̱‑rí, ná ni̱ jini̱‑de ɨɨn ndajá'a̱ ándɨ́vɨ́ kándii̱‑ya̱ iní ve̱'e‑de. Te ni̱ ka'a̱n‑ya̱ jíín‑de: Tájí‑ró mozo ná kí'i̱n ñuu̱ Jope te kana‑ró xiní Simón, cha̱a nání Pedro, ná kíi‑de. ");
INSERT INTO migNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Te cha̱a‑ún, kani‑de tu̱'un nuu̱‑ro̱ ndasa ka̱ku‑ró ondé jíín nɨ́ɨ́ vé'e‑ró, áchí‑de jíín‑rí. ");
INSERT INTO migNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Te nuu̱ ní kejá'á‑rí ká'a̱n‑ri̱, te ni̱ chaa̱ Espíritu Santo sɨkɨ̱‑í jíná'an‑i suni nátu̱'un ni̱ chaa̱‑ya̱ sɨkɨ́‑yo̱ já xnáñúú. ");
INSERT INTO migNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Yúan‑na te ni̱ nuku̱'un ini̱‑ri̱ tu̱'un ni̱ ka'a̱n máá Jíto'o̱‑yo̱: Ja̱ndáa̱ jíín ndúcha skuánducha Juan. Ko róó, chi̱ jíín Espíritu Santo kuanducha‑ro jíná'an‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Te nú suni ni̱ ja̱'a Dios Espíritu‑ya̱ núu̱ máá‑i nátu̱'un ni̱ ja̱'a‑ya̱ núu̱ máá‑yó, ja̱ kákandíja‑yó núu̱ máá Jíto'o̱‑yo̱ Jesucristo, te ndé cha̱a kúu ruu̱ ja̱ kasú‑ri̱ nuu̱ Dios núsáá. Achí Pedro. ");
INSERT INTO migNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Súan ni̱ ka̱jini so̱'o‑de tu̱'un yá'a, te tuká ní káka'a̱n‑de. Te ni̱ ka̱nakana jaa‑de Dios: Suni ni̱ ja̱'a Dios tu̱'un ja̱ ná nákani ini̱ ña̱yɨvɨ sɨ́ɨn nación náva̱'a kuchaku̱‑i nɨ́ɨ́ káni núsáá, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Te kɨvɨ̱ ní ka̱ja'ni‑dé Esteban, ni̱ kejá'á ní ka̱chindiki̱n‑de‑i. Te ña̱yɨvɨ ní kajicha̱ nu̱u kája'a̱n ni̱ ja̱koyo‑i onde̱ ñuu̱ Fenicia, jíín ñúu̱ Chipre, jíín iní ñuu̱ Antioquía. Te tú ni ɨɨn nuu̱ ñáyɨvɨ ní kájani‑i tu̱'un, chi̱ máni nuu̱ ñáyɨvɨ judío ni̱ ka̱jani‑i tu̱'un‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ko ni̱ i̱o yaku̱ cha̱a ñuu̱ Chipre jíín cháa ñuu̱ Cirene jíín ñáyɨvɨ ní kajicha̱‑ún. Te cha̱a‑ún, ni̱ ja̱koyo‑de ñuu̱ Antioquía. Te ni̱ kaka'a̱n‑de jíín ñayɨvɨ ñúu̱ Grecia, ni̱ ka̱jani‑de tu̱'un va̱'a máá Jíto'o̱‑yo̱ Jesús nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Te máá Jíto'o̱‑yo̱, ni̱ chindéé ní chituu‑ya̱‑dé. Te ni̱ ka̱kandíja kua'a̱ ñáyɨvɨ, te ni̱ ka̱naxíó káva ini̱‑i nuu̱ máá Jíto'o̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Te ni̱ jicha̱ tu̱'un yá'a. Te ni̱ jini tu̱'un tɨku'ni̱ kándíja ini̱ ñuu̱ Jerusalén. Te ni̱ ka̱tájí‑i Bernabé kua'a̱n‑de onde̱ ñuu̱ Antioquía. ");
INSERT INTO migNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Te Bernabé, nuu̱ ní jaa̱‑de yúan, te ni̱ jini̱‑de ja̱ lúu kua'a̱n tu̱'un Dios. Te ni̱ kusɨɨ̱ iní‑de. Te ni̱ ka'a̱n ni̱'in‑de jíín táká ña̱yɨvɨ‑ún ja̱ jíín iní jíín añú‑i ná skíkuu va̱'a‑i tu̱'un máá Jíto'o̱‑yo̱, te ma̱ náyu̱'ú‑i. ");
INSERT INTO migNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Chi̱ Bernabé, cha̱a va̱'a kúu‑de. Te ni̱ kútú‑de Espíritu Santo. Te kándíja va̱'a‑de. Te ni̱ ka̱kandíja kua'a̱ ñáyɨvɨ núu̱ máá Jíto'o̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Yúan‑na te ni̱ kenda Bernabé kua'a̱n‑de onde̱ ñuu̱ Tarso, kuana̱ndúkú‑de Saulo. Te ni̱ nani'i̱n‑dé cha̱a‑ún. Te ncháka‑de cha̱a ni̱ chaa̱‑de ñuu̱ Antioquía jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Te nɨ́ɨ́‑ni ɨɨn kuia̱ ni̱ kanda̱tu̱'ún‑de yúan jíín tɨ́ku'ni̱ kándíja. Te ni̱ ka̱stá'a̱n‑de tu̱'un nuu̱ kuá'a̱ ñáyɨvɨ. Te cha̱a káskuá'a‑ún, ni̱ na̱kunání‑de cristiano xnáñúú‑gá ini̱ ñuu̱ Antioquía. ");
INSERT INTO migNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Te cha̱a kájani tu̱'un Dios, suni kɨvɨ̱‑ún ni̱ kenda koyo‑de ñuu̱ Jerusalén kája'a̱n‑de onde̱ ñuu̱ Antioquía. ");
INSERT INTO migNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Te ni̱ ndukuiñi̱ ɨɨn tá'an‑de nání‑de Ágabo. Te ni̱ kastu̱'ún‑de, ni̱ sá'a Espíritu, ja̱ kíi ɨɨn tama̱ xáa̱n nɨ́ɨ́ ñúyɨ́vɨ. Te tama̱‑ún, ni̱ kii kɨvɨ̱ ní tá'ú Claudio tiñu. ");
INSERT INTO migNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Yúan‑na te ni̱ kanda̱tu̱'ún cháa káskuá'a‑ún ja̱ chúndá'á‑de yaku̱ na̱ jíín kí'i̱n nuu̱ ñaní‑de káxiu̱kú iní ñuu̱ Judea, ndasa kákanda ɨɨn ɨɨn‑de kua̱'a‑de. ");
INSERT INTO migNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Te súan ni̱ ka̱sá'a‑de. Te ni̱ ka̱tájí‑de kua'a̱n nuu̱ cháa kákuu nuu̱, ni̱ ka̱jancha̱ka Bernabé jíín Saulo. ");
INSERT INTO migNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Te suni kuia̱‑ún ni̱ ka̱tɨɨn rey Herodes sava ña̱yɨvɨ tɨ́ku'ni̱ kándíja. Te ni̱ sá'a ndɨva̱'a‑de jíín‑i. ");
INSERT INTO migNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Te jíín machete ni̱ ja'ni‑dé Jacobo, ñani̱ Juan. ");
INSERT INTO migNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Te ni̱ jini̱‑de ja̱ súan ni̱ ka̱kusɨɨ̱ iní cha̱a judío ni̱ sá'a‑de. Te suni ni̱ ka̱tɨɨn‑de Pedro. Máá kɨvɨ́‑ún ni̱ kuu viko státilá ja̱ tú yí'i yujan íá. ");
INSERT INTO migNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Te nuu̱ ní tɨɨn‑de Pedro, te ni̱ chindee‑de cha̱a veka̱a. Te ni̱ jani‑de xia'u̱n ɨɨn soldado kándi̱to‑ún‑de, chi̱ kuní‑de kiñi'in‑de cha̱a stá'a̱n‑de nuu̱ ñáyɨvɨ nú ná já'a viko Pascua. ");
INSERT INTO migNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Súan ni̱ kuu ja̱ kándee Pedro ini̱ veka̱a. Ko tɨku'ni̱ kándíja, ni̱'in ni̱ kajika̱n ta'u̱‑í ja'a̱ Pedro nuu̱ Dios. ");
INSERT INTO migNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Te jáni ini̱ Herodes ja̱ kíñi'in‑de cha̱a nuu̱ ñáyɨvɨ‑ún núú. Te suni akuáa‑ún kixí Pedro iní veka̱a ma̱'ñú úu̱ soldado, nú'ni̱‑de jíín úu̱ cadena. Te suni ká'i̱in soldado yuxé'é kándi̱to‑ún véka̱a. ");
INSERT INTO migNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Te sanaa‑ní te ni̱ jaa̱ ɨɨn ndajá'a̱ máá Tatá Dios. Te ni̱ ndii ncháa̱ ini̱ veka̱a. Te ni̱ skákɨ̱'vɨ‑ya̱ Pedro, ni̱ xndúko̱o‑ya̱‑dé. Te ni̱ ka'a̱n‑ya̱: Yachi̱ nduko̱o‑ró, áchí‑ya̱. Te cadena nú'ni̱ nda'a‑dé‑ún, ni̱ jungava‑ni kua'a̱n. ");
INSERT INTO migNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Te ni̱ kachi̱ ndajá'a̱‑yá jíín‑de: Nachi'i chi̱i‑ró te nachi'i ndija̱n‑ro̱, áchí‑ya̱. Te súan ni̱ sá'a‑de. Te ni̱ kachi̱ tuku ndajá'a̱‑yá jíín‑de: Kundii tɨka̱chí‑ró te kundiki̱n‑ro̱ rúu̱ ki'o̱n, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Te ni̱ kenda‑ya̱. Te ndikín‑de‑ya̱ kuá'a̱n‑de jíín‑yá. Te na̱ún jiní máá‑de ja̱ jándáa̱ kúu ja̱ ní sá'a ndajá'a̱‑yá jíín‑de, chi̱ jáni ini̱‑de ɨɨn ja̱ni kúu ja̱ ní skóto‑i‑de. ");
INSERT INTO migNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Te ni̱ kaja̱'a‑de nuu̱ ká'i̱in yuku̱n ɨɨn jíín yukún uu̱ soldado ja̱ kándi̱to‑ún‑de. Te ni̱ ja̱koyo‑de yuxé'é káa ja̱ jíto ichi yúñúu̱. Te yuxé'é‑ún, ni̱ nuña ii̱‑ní máá. Te ni̱ kenda koyo‑de. Te ni̱ kaja̱'a‑de ɨɨn ya̱'ya kája'a̱n‑de. Yúan‑na te ni̱ kuxio‑ni ndajá'a̱‑yá nuu̱‑dé kua'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Te Pedro, ni̱ ndukájí iní‑de, te ni̱ ka'a̱n máá‑de: Vina te ni̱ jini̱ ndaa̱‑ri̱ ja̱ ní tájí máá Tatá Dios ndajá'a̱‑yá ni̱ kii, te ni̱ nama‑ya̱ rúu̱ ini̱ nda'a Herodes jíín núu̱ táká ña̱yɨvɨ judío ja̱ ká'ni‑í ruu̱ kákuni̱‑i, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Te nuu̱ ní jini̱‑de ja̱ ní ka̱ku ndija‑de, te ni̱ kee‑de kua'a̱n‑de ve'e María náa̱ Juan, cha̱a nání Marcos. Te yúan ni̱ kanataka̱ kua'a̱ ñáyɨvɨ kájika̱n ta'u̱‑í. ");
INSERT INTO migNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Te ni̱ ka'a̱n Pedro ichi yúxé'é yatá ké'e. Te kua'a̱n ɨɨn su̱chí sɨ́'ɨ́ nání‑i Rode ja̱ kúña‑i yuxé'é núú. ");
INSERT INTO migNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Te su̱chí‑ún, ni̱ nakuni̱‑i tachi̱ Pedro. Te ja̱ kúsɨɨ̱ iní‑i tú ní júña‑i yuxé'é‑ún, chi̱ jínu‑i ni̱ ndɨ̱vɨ‑i ini̱ ve̱'e. Te ni̱ kastu̱'ún‑i ja̱ kándii̱ Pedro ichi yatá yúxé'é. ");
INSERT INTO migNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Te ni̱ kaka'a̱n jíín‑i: Aa̱, kátachi̱‑ro̱, áchí. Ko máá‑i, ni̱'in ká'a̱n‑i ja̱ máá‑de kúu. Yúan‑na te ni̱ kaka'a̱n: Añú‑de kúu núsáá, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ko Pedro, ví'í‑gá kána‑de. Yúan‑na te ni̱ ka̱juña‑i. Te ni̱ kajini̱‑i nuu̱‑dé. Te ni̱ ka̱ndakoto i̱o‑i. ");
INSERT INTO migNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ko máá‑de, ni̱ sá'a‑de seña jíín ndá'a‑dé ja̱ ná kasú‑i yu'u‑í. Te ni̱ kastu̱'ún‑de ndasa ni̱ kiñi'in máá Jíto'o̱‑yo̱‑dé ini̱ veka̱a. Te ni̱ ka'a̱n‑de: Kastu̱'ún táká tu̱'un yá'a nuu̱ Jacobo jíín núu̱ táká ñani̱‑yo̱, áchí‑de. Te ni̱ kenda‑de kua'a̱n‑de ɨnga̱ lugar. ");
INSERT INTO migNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Te nuu̱ ní kundiji̱n xia̱n‑ún, te ni̱ ka̱kuvaa̱ téyíí soldado ja̱ tú ndénda Pedro. ");
INSERT INTO migNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ko Herodes, nándúkú‑de Pedro. Ko tú ní náni'i̱n‑dé cha̱a. Te nuu̱ ní xndichí‑de soldado jíná'an, te ni̱ tá'ú‑de tiñu ja̱ ná kíngoyo kuu̱. Yúan‑na te ni̱ kenda‑de ini̱ ñuu̱ Judea ni̱ kuun‑de kua'a̱n‑de ñuu̱ Cesarea. Te ni̱ kendo̱o‑de yúan. ");
INSERT INTO migNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Te ni̱ kiti̱ xaa̱n iní Herodes ni̱ jito‑de ña̱yɨvɨ ñúu̱ Tiro jíín ñáyɨvɨ ñúu̱ Sidón. Ko ña̱yɨvɨ‑ún, ni̱ katau̱‑i va̱i‑i nuu̱‑dé. Te ni̱ ka̱kundéé‑i ni̱ ka̱ská'a̱n‑i Blasto cha̱a kúñá'nu játíñu nuu̱ rey. Te ni̱ kajika̱n‑i paz. Chi ta̱ká máá‑i, káñi'i̱n‑í ja̱ káyee‑í onde̱ ñu'un Herodes. ");
INSERT INTO migNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Te ni̱ teta'a̱n Herodes ɨɨn kɨvɨ̱. Te ni̱ nuku̱'un‑de sa'ma rey máá‑de. Te ni̱ nungo̱o‑de mesa tá'ú‑de tiñu. Te ni̱ ka'a̱n‑de ɨɨn tu̱'un nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Te ña̱yɨvɨ‑ún, ni̱ kaka'a̱n jaa‑i: Tu̱'un Dios kúu ya̱'á vii, nasu̱ tú'un cha̱a kúu. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Te ɨɨn ndajá'a̱ máá Tatá Dios, ni̱ stují‑ni‑ya̱‑dé te ni̱ ka̱yaji tɨ́ndákú‑de, te ni̱ ji'i̱‑ni‑de, chi ni̱ sávixi̱‑ni‑de máá‑de, lugar ja̱ nákana jaa‑de Dios. ");
INSERT INTO migNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Te tu̱'un máá Tatá Dios, ví'í‑gá ni̱ ndea̱, te ví'í‑gá ni̱ jicha̱ nu̱u kua'a̱n. ");
INSERT INTO migNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Te Bernabé jíín Saulo, ni̱ ka̱skíkuu‑de tiñu ni̱ kaja'a̱n‑de ini̱ ñuu̱ Jerusalén. Te ni̱ ka̱naxíó káva‑de káno'o̱n‑de. Te ni̱ jaka‑de Juan cha̱a nání Marcos kua'a̱n‑de jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Te ini̱ tɨku'ni̱ kándíja ini̱ ñuu̱ Antioquía ni̱ ka'i̱o cha̱a jáni tu̱'un Dios jíín cháa kástá'a̱n tu̱'un‑ya̱. Te káinání‑de Bernabé, Simón ja̱ nání Niger, Lucio ñuu̱ Cirene, jíín Manaén cha̱a ni̱ ja'nu jíín Herodes gobernador, jíín Saulo. ");
INSERT INTO migNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Te nini káchiñú'ún cháa yá'a nuu̱ máá Jíto'o̱‑yo̱ te kásá'a ndicha̱‑de ini̱‑de, te ni̱ ka'a̱n máá Espíritu Santo: Vina te kuní‑ri̱ ja̱ sásɨ́ɨn‑ró Bernabé jíín Saulo ná kí'i̱n‑de ɨɨn tiñu, chi ja̱ yúán ní teta'a̱n‑ri̱‑de jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yúan‑na te ndicha̱ ini̱‑de ni̱ kajika̱n ta'u̱‑dé. Te ni̱ ka̱xndée‑de nda'a‑dé xini̱ cháa‑ún. Te ni̱ ka̱tájí‑de cha̱a kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Te máá‑de, kua'a̱n‑de ni̱ sá'a Espíritu Santo, ni̱ kuun‑de kája'a̱n‑de ñuu̱ Seleucia. Te yúan ni̱ kɨ̱vɨ koyo‑de barco te kua'a̱n‑de onde̱ isla Chipre. ");
INSERT INTO migNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Te ni̱ ja̱koyo‑de ñuu̱ Salamina. Te ni̱ ka̱jani‑de tu̱'un Dios ini̱ ve̱'e sinagoga cha̱a judío. Te jíka Juan jíín‑de, játíñu nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Te ni̱ kaja̱'a‑de ini̱ nɨ́ɨ́ isla‑ún. Te ni̱ ja̱koyo‑de ñuu̱ Pafos. Te yúan ni̱ kajini̱‑de nuu̱ ɨ́ɨn cha̱a ña̱vá'a nání Barjesús. Cha̱a judío kúu‑de, te jáni‑de tu̱'un tú'ún. ");
INSERT INTO migNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Te cha̱a‑ún, ni̱ sátiñu‑de nuu̱ gobernador Sergio Paulo. Te gobernador, cha̱a ndíchí kúu‑de. Te ni̱ kana‑de xini̱ Bernabé jíín Saulo, ja̱ kúni ná'ín‑de tu̱'un Dios kuní‑de. ");
INSERT INTO migNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ko Elimas, cha̱a ña̱vá'a‑ún (chi̱ súan kuní ka'a̱n sɨ́'vɨ́‑de), jasú‑de nuu̱ Saulo jíín núu̱ Bernabé, chi̱ ndúkú ndéé‑de sáká núu‑de náva̱'a ma̱ kándíja gobernador. ");
INSERT INTO migNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Yúan‑na te Saulo, ja̱ súni nání‑de Pablo, ni̱ kútú‑de Espíritu Santo. Te ni̱ nde̱'é‑de nuu̱ cháa‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Te ni̱ ka'a̱n‑de: Cha̱a sá'a tiñu chá'án xndá'ú ñá'án kúu‑ró. Se̱'e kui'na̱ já jíto u'u̱ ta̱ká tiñu ndaa̱ kúu‑ró. Naja̱ máni sáyo'o̱‑ro̱ íchi ndóó máá Jíto'o̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Te máá Jíto'o̱‑yo̱, xndó'o‑ya̱ róó vina. Te kukuáá‑ro̱, ma̱ kuní‑ga̱‑ro̱ ndíka̱ndii yakú kɨvɨ̱. Achí Pablo. Te ni̱ kuñaa‑ní nuu̱‑dé. Te kíndá'á kí'in íú‑de jíku‑de, ndúkú‑de ndéja̱ tɨ́ɨn nda'a‑dé skáka‑de. ");
INSERT INTO migNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Yúan‑na te gobernador, ni̱ jini̱‑de ja̱ súan ni̱ kuu, te ni̱ kandíja‑de. Te náa‑ná ini̱‑de jíni so̱'o‑de tu̱'un máá Jíto'o̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Yúan‑na te Pablo jíín tá'an‑de‑ún, ni̱ kenda koyo‑de ñuu̱ Pafos. Te jíín barco ni̱ ja̱koyo‑de ndañúu̱ Perge ñuu̱ Panfilia. Te yúan ni̱ kusɨ́ɨn Juan kua̱no'on‑dé ñuu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Te máá‑de, ni̱ kaja̱'a‑de ñuu̱ Perge kája'a̱n‑de. Te ni̱ ja̱koyo‑de ñuu̱ Antioquía ndañúu̱ Pisidia. Te ni̱ kɨ̱vɨ koyo‑de ini̱ ve̱'e sinagoga ɨɨn kɨvɨ̱ ndéta̱tú. Te ni̱ ka̱jungo̱o‑de. ");
INSERT INTO migNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Te nuu̱ ní kuu ni̱ ka'u tutu̱ ley jíín tutú cha̱a ni̱ ka̱jani tu̱'un Dios onde̱ sáá, yúan‑na te cha̱a kákuñá'nu ini̱ ve̱'e sinagoga, ni̱ ka̱kana‑de xini̱ cháa‑ún: Ñáni̱ jíná'an‑ní, nú káñava̱'a‑ní yaku̱ tu̱'un kani‑ní nuu̱ táká ña̱yɨvɨ yá'a, te ka'a̱n ndéé‑ní jíín‑i, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Yúan‑na te ni̱ ndukuiñi̱ Pablo, ni̱ sá'a‑de seña jíín ndá'a‑dé ja̱ ná kúná'ín ñáyɨvɨ‑ún, te ni̱ ka'a̱n‑de: Róó cha̱a ñuu̱ Israel, róó cha̱a káchiñú'ún Dios, kuni ná'ín jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Máá Dios ña̱yɨvɨ Israel, ni̱ ka̱ji‑ya̱ táa̱‑yo̱ jíná'an‑de. Te nini káxiu̱kú tatú‑de ini̱ ñuu̱ Egipto ni̱ ka̱kuu jíñú'ún‑ga̱‑de ni̱ sá'a‑ya̱. Yúan‑na te jíín fuerza máá‑yá ni̱ kiñi'in‑ya̱‑í ini̱ ñuu̱‑ún kája'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Yúan‑na te ni̱ ndi̱to‑ya̱‑í onde̱ nuu̱ ñú'un té'é nátu̱'un uu̱ xiko kuia̱. ");
INSERT INTO migNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Te ni̱ xnáa‑yá usia̱ nación ini̱ ñuu̱ Canaán. Te ni̱ saka‑yá ñu'un ñúu̱‑ún nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Te ni̱ kuu‑ga̱ kɨvɨ̱ nátu̱'un kuu̱n ciento uu̱ xiko uxi̱ kuia̱. Te ni̱ ja̱'a‑ya̱ cháa ni̱ ka̱kuu juez nuu̱‑í onde̱ kɨvɨ̱ ní kenda Samuel cha̱a ni̱ jani tu̱'un‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Yúan‑na te ni̱ kajika̱n‑i ɨɨn rey. Te Dios, ni̱ ja̱'a‑ya̱ Saúl nuu̱‑í ni̱ tá'ú‑de tiñu uu̱ xiko kuia̱. Te Saúl, tata̱ Benjamín, se̱'e Cis ni̱ kuu‑de. ");
INSERT INTO migNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Te ni̱ kuxio Saúl. Te ni̱ nakani‑ya̱ David ni̱ kuu‑de rey nuu̱‑í. Te ni̱ ka'a̱n ndaa̱‑ya̱ tú'un‑de: A ni̱ jini̱‑ri̱ David se̱'e Isaí ja̱ ɨ́ɨn cha̱a jándatu̱ va̱'a nuu̱‑rí kúu‑de. Te skíkuu‑de ta̱ká tiñu játa'a̱n ini̱‑ri̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Te Dios, chi̱i tata̱ yá'a ni̱ jani‑ya̱ Jesús ja̱ náma‑ya̱ ñáyɨvɨ Israel nátu̱'un ni̱ keyu'u‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Te ná té chá'a̱n‑ga̱ kii‑ya̱ te ni̱ jani Juan tu̱'un jánducha jíín tú'un nakani ini̱ nuu̱ táká ña̱yɨvɨ Israel. ");
INSERT INTO migNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Te nuu̱ á yani xndɨ́'ɨ Juan tiñu sá'a‑de, te ni̱ ka'a̱n‑de: Ndé cha̱a kúu‑ri̱ kájani ini̱‑ro̱. Nasu̱ I'a̱‑ún kúu‑ri̱, ko kuni so̱'o va̱'a‑ró: Ichi yatá‑rí va̱i ɨɨn I'a̱ ja̱ tú kúñá'nu‑ri̱ ndájí‑rí ñii yí'i ndija̱n‑yá. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ñáni̱ jíná'an‑ró, ta̱ká róó tata̱ Abraham jíín róó ja̱ kájandatu̱ nuu̱ Dios, nuu̱ máá‑ró ní tájí‑yá tu̱'un yá'a va̱i ja̱ náma‑ya̱ róó. ");
INSERT INTO migNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Chi ta̱ká ña̱yɨvɨ ñúu̱ Jerusalén jíín táká cha̱a kákuñá'nu nuu̱‑í, tú ní kánakuni̱‑i nuu̱‑yá. Te ni̱ ka̱ndonda‑i sɨkɨ̱‑yá. Te súan ni̱ ka̱skíkuu‑i tu̱'un ni̱ kaka'a̱n cha̱a ni̱ ka̱jani tu̱'un Dios onde̱ sáá, va̱sa a ni̱ ka̱jini ná'ín‑i tu̱'un‑ún ndɨta'a̱n kɨvɨ̱ ndéta̱tú. ");
INSERT INTO migNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Va̱sa tú ní káni'i̱n‑í ni ɨɨn kua̱chi sɨkɨ̱‑yá ja̱ kúu̱‑ya̱, ko ni̱ kaka'a̱n ni̱'in‑i jíín Pilato ja̱ ná kúu̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Te nuu̱ ní skíkuu ta̱ká tu̱'un yóso sɨkɨ́‑yá nuu̱ tutú, te ni̱ ka̱xnúu‑i‑ya̱ jiká cruz. Te ni̱ ka̱chindee‑i‑ya̱ iní ɨɨn ve'e añú. ");
INSERT INTO migNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ko ni̱ nachaku̱‑ya̱ má'ñú ndɨ́yi ni̱ sá'a Dios. ");
INSERT INTO migNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Te kua'a̱ kɨvɨ́ ní ndenda ndiji̱n‑ya̱ núu̱ ñáyɨvɨ ní ka̱kaa kája'a̱n jíín‑yá onde̱ ñuu̱ Galilea te onde̱ ñuu̱ Jerusalén. Te ña̱yɨvɨ‑ún kákuu ja̱ kájani ndaa̱ tu̱'un‑ya̱ núu̱ sáva‑ga̱‑i. ");
INSERT INTO migNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Te ruu̱, kájani‑ri̱ tu̱'un va̱'a yá'a nuu̱‑ro̱ já súan ni̱ keyu'u‑yá nuu̱ táa̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Te tu̱'un‑ún ni̱ skíkuu Dios jíín máá‑yó ja̱ kákuu‑yó sé'e‑de. Chi ni̱ naschakú‑ya̱ Jesús. Chi súan ká'a̱n Salmo uu̱: Se̱'e‑ri̱ kúu‑ró, te ruu̱ kúu Táa̱‑ro̱ vína, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Te ni̱ naschakú‑ya̱ Jesús ma̱'ñú ndɨ́yi náva̱'a ma̱ té'yu̱ kutɨ‑yá, te ni̱ ka'a̱n Dios: Skíkuu ná'ín‑rí jíín táká tu̱'un va̱'a ni̱ keyu'u‑rí nuu̱ David, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ja̱ yúán súni súan ká'a̱n ɨnga̱ tutu̱: Té'yu̱ Se̱'e ii̱‑ní, chi ma̱ kuá'a‑ní tu̱'un, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Chi̱ David, ni̱ jatíñu‑de nuu̱ Dios, ni̱ sá'a‑de ja̱ kuní máá‑yá. Te ni̱ jínu kuia̱‑de, te ni̱ ji'i̱‑de. Te ni̱ yu̱ji‑de ma̱'ñú táa̱‑de. Te ni̱ te'yu̱ ndija‑de. ");
INSERT INTO migNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ko I'a̱ ni̱ naschakú Dios, tú ní té'yu̱ kutɨ‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ñáni̱ jíná'an‑ró, ná kástu̱'ún‑rí nuu̱‑ro̱, já I'a̱ yá'a ni̱ kastu̱'ún‑yá nuu̱‑ro̱ já sá'a‑ya̱ túká'nu ini̱‑ya̱ núu̱ táká kua̱chi‑ró. ");
INSERT INTO migNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Chi̱ nú ndé cha̱a kándíja‑de nuu̱ I'a̱ yá'a, te nda'va̱‑ya̱ táká kua̱chi‑de ja̱ tú ní kúu nda'va̱ máá‑de jíín ley Moisés. ");
INSERT INTO migNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Koto va̱'a‑ró máá‑ró jíná'an‑ró, náva̱'a ma̱ kíi sɨkɨ̱‑ro̱ táká tu̱'un yóso núu̱ tutú cha̱a ni̱ ka̱jani tu̱'un Dios, súan: ");
INSERT INTO migNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ta̱ká róó ña̱yɨvɨ kásákátá, ná ndé'é vá'a‑ró, te ná kée nuu̱‑ro̱ ndé'é‑ró, te kuu̱‑ro̱. Chi ma̱'ñú máá‑ró sá'a‑ri̱ ɨɨn tiñu ja̱ má kándíja kutɨ‑ro va̱sa ná káni sava‑ga̱ ña̱yɨvɨ tú'un‑ún nuu̱‑ro̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Te ni̱ ndenda koyo‑de ini̱ ve̱'e sinagoga cha̱a judío. Te ña̱yɨvɨ sɨ́ɨn nación, ni̱ kaka'a̱n nda̱'ú‑i jíín‑de ja̱ ɨngá kɨvɨ̱ ndéta̱tú kani tuku‑de tu̱'un yá'a nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Te ni̱ jicha̱ ña̱yɨvɨ‑ún kája'a̱n‑i. Te ña̱yɨvɨ judío jíín ñáyɨvɨ ní na̱ki'in sé'é judío ja̱ káchiñú'ún‑i nuu̱ Dios, tɨnɨ̱‑i ni̱ kandiki̱n‑i Pablo jíín Bernabé kája'a̱n‑i jíín‑de. Te ni̱ kanda̱tu̱'ún‑de jíín‑i káka'a̱n‑de jíín‑i ja̱ ná kúndii̱ ni̱'in‑i jíín tú'un luu Dios. ");
INSERT INTO migNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Te kɨvɨ̱ ndéta̱tú ɨnga̱ semana, nátu̱'un ndivii ñáyɨvɨ ñúu̱‑ún, ni̱ ka̱kutútú‑i ja̱ kúni ná'ín‑i tu̱'un Dios. ");
INSERT INTO migNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ko cha̱a judío, ni̱ kajini̱‑de nuu̱ ñáyɨvɨ kuá'a̱‑ún, te ni̱ ka̱kukuásún iní‑de. Te ni̱ kaka'a̱n‑de sɨkɨ̱ tú'un ni̱ ka'a̱n Pablo, te ni̱ kaka'a̱n ndɨva̱'a‑de. Achí‑de ja̱ tú íó ndaa̱ tu̱'un‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Yúan‑na te Pablo jíín Bernabé ni̱ kaka'a̱n ni̱'in‑de: Kánúú já xná'a̱n‑ga̱ nuu̱ máá‑ró káni‑ri̱ tu̱'un Dios. Ko a ni̱ ka̱sájá'a̱ ini̱‑ro̱ núu̱, te kua̱chi máá‑ró kúu ja̱ má ní'i̱n‑ro̱ tú'un kuchaku̱‑ro̱ nɨ́ɨ́ káni. Vina te chaxio‑ri̱ máá‑rí kika̱stu̱'ún‑rí nuu̱ ñáyɨvɨ sɨ́ɨn nación. ");
INSERT INTO migNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Chi ni̱ tá'ú máá Jíto'o̱‑yo̱ tíñu nuu̱‑rí jíná'an‑ri̱ súan: Ni̱ jani‑ri̱ róó ja̱ stúu̱n‑ro̱ núu̱ ñáyɨvɨ sɨ́ɨn nación, te kani‑ró tú'un nuu̱ ñáyɨvɨ nɨ́ɨ́ ñúyɨ́vɨ ja̱ náma‑ri̱‑i jíná'an‑i, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Te ña̱yɨvɨ sɨ́ɨn nación‑ún, ni̱ ka̱jini so̱'o‑i tu̱'un yá'a. Te ni̱ ka̱kusɨɨ̱ xáa̱n iní‑i. Te ni̱ ka̱nakana jaa‑i tu̱'un máá Jíto'o̱‑yo̱. Te ta̱ká ña̱yɨvɨ ní teta'a̱n Dios ja̱ ná kúchaku̱‑i nɨ́ɨ́ káni, ni̱ ka̱kandíja‑i. ");
INSERT INTO migNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Te tu̱'un máá Jíto'o̱‑yo̱, ni̱ jicha̱ nu̱u kua'a̱n nɨ́ɨ́ táká ndañúu̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Te ini̱ ñuu̱‑ún káxiu̱kú ñá'an ndáa̱ ja̱ kájandatu̱‑ña núu̱ Dios. Ko cha̱a judío, ni̱ ka̱ská'a̱n‑de‑ña jíín cháa kákuñá'nu jia̱n. Te ni̱ ka̱chindiki̱n‑ña Pablo jíín Bernabé, te ni̱ ka̱skúnu‑ña‑dé kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Te máá‑de, ni̱ ka̱skóyo‑de tɨkacha̱ ñú'un iní ja'a̱‑dé sɨkɨ̱ máá‑i. Te ni̱ ja̱koyo‑de ñuu̱ Iconio. ");
INSERT INTO migNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Te cha̱a káskuá'a‑ún, ni̱ ka̱kútú‑de Espíritu Santo. Te kákusɨɨ̱ xáa̱n iní‑de. ");
INSERT INTO migNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Te ñuu̱ Iconio ni̱ kɨ̱vɨ koyo‑de ini̱ ve̱'e sinagoga cha̱a judio. Te ni̱ jani téyíí‑de tu̱'un. Te ni̱ ka̱kandíja kua'a̱ ñáyɨvɨ judío. Te suni súan ni̱ ka̱kandíja kua'a̱ ñáyɨvɨ ñúu̱ Grecia. ");
INSERT INTO migNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ko cha̱a judío ja̱ tú ní kákandíja, jíín tú'un tú'ún ni̱ ka̱ská'a̱n téyíí‑de ña̱yɨvɨ sɨ́ɨn nación. Yu̱án ní kaka'a̱n nchaa̱‑i táká ñani̱. ");
INSERT INTO migNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Te ni̱ ka̱kendo̱o‑de yúan kua'a̱ kɨvɨ́. Te jíín máá Jíto'o̱‑yo̱, ni̱ chundéé iní‑de, ni̱ kaka'a̱n ni̱'in‑de tu̱'un. Te máá‑yá, ni̱ stá'a̱n‑ya̱ já íó ndaa̱ tu̱'un va̱'a, chi̱ ñúkúún ní ja̱'a‑ya̱ tú'un luu íó ini̱ máá‑yá, ja̱ ní ka̱sá'a‑de tuni̱ jíín tíñu ñá'nu. ");
INSERT INTO migNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Te ña̱yɨvɨ ñúu̱‑ún, ni̱ ka̱sásɨ́ɨn‑i máá‑i sava‑i ni̱ ka̱ndujíín‑i jíín cháa judío, te sava‑ga̱‑i ni̱ ka̱ndujíín‑i jíín cháa apóstol. ");
INSERT INTO migNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Te ña̱yɨvɨ judío jíín ñáyɨvɨ sɨ́ɨn nación, ɨɨn ká'nu ni̱ kándonda‑i jíín cháa kákuñá'nu nuu̱‑í náva̱'a kua̱'a‑i tuka̱ nuu̱ apóstol, te kua̱'a‑i yuu̱ xiní‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Te ni̱ kaju̱ku̱'un ini̱‑de. Te ni̱ ka̱jinu‑de kája'a̱n‑de onde̱ ñuu̱ Listra jíín ñúu̱ Derbe, ndañúu̱ Licaonia, jíín táká ñuu̱ ká'i̱o yani yúan. ");
INSERT INTO migNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Te yúan ni̱ ka̱jani‑de tu̱'un va̱'a‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Te yúan kánchaa̱ ɨɨn cha̱a ñuu̱ Listra ja̱ tú íó fuerza ja'a̱‑dé. Te káa rengo‑de onde̱ kɨvɨ̱ ní kaku‑de, ja̱ té cha'a̱n‑ga̱ kaka kutɨ‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Cha̱a yá'a, ni̱ jini so̱'o‑de ká'a̱n Pablo. Te ni̱ nde̱'é Pablo nuu̱ cháa‑ún. Te ni̱ jini̱‑de ja̱ kándíja va̱'a cha̱a‑ún ja̱ ndúva̱'a‑de. ");
INSERT INTO migNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Te ni̱ ka'a̱n jaa‑de jíín cháa‑ún: Ndukuiñi̱ te kundii̱‑ro̱, áchí‑de. Te ni̱ kanda‑ni‑de, te ni̱ jika kuu‑de. ");
INSERT INTO migNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Te ni̱ kajini̱ ña̱yɨvɨ‑ún tiñu ni̱ sá'a Pablo. Te ni̱ kaka'a̱n jaa‑i jíín yú'u máá ñúu̱ Licaonia: Ni̱ kuun I'a̱, ni̱ cha̱koyo nuu̱‑yo̱, kájika kuu nátu̱'un cha̱a vidáa̱, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Te Bernabé, ni̱ ka̱skúnání‑i‑de i'a̱ Júpiter. Te Pablo ni̱ káskúnání‑i‑de i'a̱ Mercurio, chi̱ Pablo kúu cha̱a jáni tu̱'un. ");
INSERT INTO migNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Te yuñúu̱‑ún kánchaa̱ viñu̱'un Júpiter. Te máá sutú viñu̱'un‑ún, ni̱ kenda‑de va̱i nchaka‑de xndɨkɨ̱ jíín itá onde̱ yuxé'é ñúu̱. Te máá‑de jíín ñáyɨvɨ, ka'ni‑dé xndɨkɨ̱ te soko̱‑dé‑tɨ̱ núu̱ Bernabé jíín Pablo kákuni̱‑de núú. ");
INSERT INTO migNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Te Bernabé jíín Pablo, cha̱a kákuu apóstol, ni̱ ka̱jini tu̱'un‑de tu̱'un‑ún. Te ni̱ ka̱ndátá‑de su'nu̱‑dé. Te ni̱ ke̱ndava‑de ni̱ kɨ̱vɨ koyo‑de ma̱'ñú ñáyɨvɨ kuá'a̱‑ún. Te ni̱ ka̱kana kó'ó‑de: ");
INSERT INTO migNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Hombre, naja̱ kásá'a‑ró súan. Chi̱ ruu̱, suni cha̱a kákuu‑ri̱ nátu̱'un máá‑ró. Te kákastu̱'ún‑rí nuu̱‑ro̱, ma̱ sá'a‑ga̱‑ro̱ tíñu sáni yá'a, chi̱ sua ná chíñú'ún‑ró máá Dios, I'a̱ chakú, I'a̱ ni̱ sá'a andɨ́vɨ́ jíín ñúyɨ́vɨ jíín ndúcha mar jíín táká‑ga̱ ndatíñu nɨ́ɨ́ ká'nu. ");
INSERT INTO migNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Te onde̱ aná'án ní ja̱'a‑ya̱ tú'un ja̱ sá'a ta̱ká ña̱yɨvɨ tíñu kákuni̱ máá‑i. ");
INSERT INTO migNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ko stá'a̱n ndaa̱‑ya̱ já íó‑ya̱, chi̱ sá'a‑ya̱ tíñu va̱'a nuu̱‑yo̱. Skúun‑ya̱ saú íchi ándɨ́vɨ́. Te bueno kée itu̱‑yo̱ sá'a‑ya̱. Te já'a‑ya̱ stáa̱ kée‑yo. Te kákusɨɨ̱ iní‑yo̱ sá'a‑ya̱. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Te va̱sa súan ni̱ kaka'a̱n‑de, ko xaa̱n ú'u̱ ni̱ kajasu̱‑de nuu̱ ñáyɨvɨ‑ún náva̱'a tú soko̱‑í kɨtɨ‑ún nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Yúan‑na te ni̱ cha̱koyo yaku̱ cha̱a judío ñuu̱ Antioquía jíín ñúu̱ Iconio. Te ni̱ ka̱ská'a̱n ña̱yɨvɨ kuá'a̱‑ún. Te ni̱ kaja̱'a‑i yuu̱ xiní Pablo. Te ni̱ ka̱skána‑i‑de yuñúu̱‑ún, ni̱ ka̱jani ini̱‑i ja̱ ní ji'i̱‑de. ");
INSERT INTO migNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ko ni̱ ka̱jíkó ndúu̱ cha̱a káskuá'a‑ún nuu̱‑dé. Te ni̱ nduko̱o‑de. Te ni̱ ndɨ̱vɨ‑de ini̱ ñuu̱. Ko ɨnga̱ kɨvɨ̱ te ni̱ ki'in‑de ichi kuá'a̱n‑de jíín Bernabé onde̱ ñuu̱ Derbe. ");
INSERT INTO migNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Te ini̱ ñuu̱‑ún ni̱ ka̱jani‑de tu̱'un va̱'a. Te ni̱ skándíja‑de kua'a̱ ñáyɨvɨ. Te káno'o̱n tuku‑de ñuu̱ Listra jíín ñúu̱ Iconio jíín ñúu̱ Antioquía. ");
INSERT INTO migNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Te ni̱ ka̱yija‑ga̱ ini̱ cha̱a káskuá'a yúan ni̱ ka̱sá'a‑de. Te ni̱ kaka'a̱n ni̱'in‑de jíín cháa‑ún ja̱ ná kúkuu‑ga̱‑de kandíja va̱'a‑de. Te káka'a̱n‑de ja̱ nɨ́nɨ kíi kua'a̱ túndó'o sɨkɨ̱‑yo̱ te vásá kɨ́vɨ‑yó iní ñuu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Te ni̱ ka̱jani‑de cha̱a kákuu nuu̱ ná kóto ndɨta'a̱n tɨku'ni̱ kákandíja. Te ni̱ kajika̱n ta'u̱ ndichá‑de ja'a̱ cháa‑ún nuu̱ máá Jíto'o̱‑yo̱, chi̱ nuu̱ máá‑yá kákandíja‑de. ");
INSERT INTO migNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Te ni̱ kaja̱'a‑de ichi ñúu̱ Pisidia kua'a̱n‑de. Te ni̱ naja̱koyo‑de ñuu̱ Panfilia. ");
INSERT INTO migNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Te ni̱ ka̱jani‑de tu̱'un ini̱ ñuu̱ Perge. Te ni̱ nuu‑de ni̱ ja̱koyo‑de ñuu̱ Atalia. ");
INSERT INTO migNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Te yúan ni̱ kenda‑de. Te jíín barco kája'a̱n‑de ñuu̱ Antioquía nuu̱ ondé xnáñúú ní kájika̱n ta'u̱ ñáyɨvɨ núu̱ Dios ja'a̱‑dé ja̱ ná chíndéé chítuu‑ya̱‑dé jíín tíñu ja̱ á ni̱ ka̱síjínu‑de. ");
INSERT INTO migNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Te nuu̱ ní naja̱koyo‑de yúan, te ni̱ na̱stútú‑de tɨku'ni̱ kándíja. Te ni̱ ka̱jani‑de tu̱'un ná ñá'nu tiñu ni̱ sá'a Dios jíín‑de, chi̱ bueno ni̱ ja̱'a‑ya̱ tú'un ja̱ ná kándíja ña̱yɨvɨ sɨ́ɨn nación jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Te ni̱ ka̱kendo̱o‑de yúan kua'a̱ kɨvɨ́ jíín cháa káskuá'a‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yúan‑na te ichi ñúu̱ Judea ni̱ kikoyo yaku̱ chaa, te ni̱ kastá'a̱n‑de nuu̱ táká ñani̱: Nú tú xɨtɨ̱ ndúu̱‑ro̱ nátu̱'un ká'a̱n ley Moisés, te ma̱ káku kutɨ‑ro, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Te yu̱án ní kuvaa̱. Te Pablo jíín Bernabé, ni̱ ka̱státá'an téyíí‑de jíín cháa‑ún. Te ni̱ kundaa̱ tu̱'un ja̱ kíngoyo Pablo jíín Bernabé jíín sáva‑ga̱ cha̱a ñuu̱ Jerusalén. Te yúan ndatu̱'ún‑de jíín cháa apóstol jíín cháa kákuu nuu̱ sɨkɨ́ tú'un yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Yúan‑na te tɨku'ni̱ kándíja‑ún, ni̱ ka̱nakuatá'ú‑i nuu̱‑dé. Te ni̱ kaja̱'a‑de kája'a̱n‑de ichi ñúu̱ Fenicia jíín íchi ñúu̱ Samaria, kájani‑de tu̱'un ndasa ni̱ ka̱kandíja ña̱yɨvɨ sɨ́ɨn nación. Te xaa̱n ní ka̱kusɨɨ̱ iní ta̱ká ñani̱. ");
INSERT INTO migNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Te ni̱ ja̱koyo‑de ini̱ ñuu̱ Jerusalén. Te tɨku'ni̱ kándíja yúan, jíín cháa apóstol, jíín cháa kákuu nuu̱, ni̱ ka̱jatá'ú‑de cha̱a. Te ni̱ ka̱jani‑de ta̱ká tu̱'un ndasa ni̱ sá'a Dios jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ko sava cha̱a fariseo ja̱ kákandíja, ni̱ ndukuiñi̱. Te ni̱ kaka'a̱n: Jínu ñú'ún já xɨtɨ́ ndúu̱‑i te tá'ú‑yó tíñu nuu̱‑í ja̱ ná kuándatu̱‑i nuu̱ ley Moisés, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Te ni̱ ka̱ndutútú táká cha̱a apóstol jíín táká cha̱a kákuu nuu̱ náva̱'a ndatu̱'ún‑de, te sándaa̱‑de sɨkɨ̱ tú'un yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Te nuu̱ ní ji̱nu ni̱ ka̱státá'an téyíí‑de, te ni̱ ndukuiñi̱ Pedro, te ni̱ ka'a̱n‑de: Ñáni̱, a kájini̱ va̱'a máá‑ró já ondé sáá ní ka̱ji Dios ruu̱ náva̱'a kani‑ri̱ tu̱'un va̱'a‑ya̱ núu̱ ñáyɨvɨ sɨ́ɨn nación te kandíj‑i jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Te Dios ja̱ jiní‑ya̱ iní añú‑i, ni̱ stá'a̱n‑ya̱ já ní jatá'ú‑yá‑i, chi ni̱ ja̱'a‑ya̱ Espíritu Santo nuu̱‑í jíná'an‑i nátu̱'un ni̱ ja̱'a‑ya̱ núu̱ máá‑yó. ");
INSERT INTO migNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Te tú ní sásɨ́ɨn‑ya̱ yóó jíín‑i, chi̱ suni ni̱ ka̱kandíja‑i te ni̱ sándoo‑ya̱ añú‑i. ");
INSERT INTO migNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Te vina naja̱ kájito nchaa̱‑ro̱ Dios núsáá, chi̱ káxndée‑ró ɨ́ɨn yugo xini̱ cháa káskuá'a yá'a, te ni ndɨ̱yi táa̱‑yo̱ jíná'an‑de te ni máá‑yó, tú ní kákanda‑yó kúndiso‑yó. ");
INSERT INTO migNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Chi̱ kákandíja‑yó já Jíto'o̱‑yo̱ Jesús kúndá'ú ini̱‑ya̱ yóó, te yu̱án náma‑ya̱ yóó. Te suni súan nama‑ya̱ máá‑i. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Yúan‑na te cha̱a kua'a̱‑ún, ni̱ ka̱kuná'ín‑de. Te ni̱ ka̱jini ná'ín‑de tu̱'un káka'a̱n Pablo jíín Bernabé ná ta̱ká tiñu ñá'nu jíín táká tuni̱ ni̱ sá'a Dios jíín‑de ja̱ ní ka̱sá'a máá‑de nuu̱ ñáyɨvɨ sɨ́ɨn nación. ");
INSERT INTO migNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Te nuu̱ ní ka̱kuná'ín‑de, te ni̱ chísó Jacobo tu̱'un: Ñáni̱ jíná'an‑ró, kuni so̱'o tu̱'un ná ká'a̱n‑ri̱: ");
INSERT INTO migNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón, ni̱ jani‑de tu̱'un ja̱ ondé xnáñúú ní ja̱'a Dios tu̱'un nuu̱ ñáyɨvɨ sɨ́ɨn nación ja̱ ná kúndiso‑i sɨ́'vɨ́‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Te tu̱'un yá'a, ɨɨn núú‑ni káka'a̱n jíín táká cha̱a ni̱ ka̱jani tu̱'un Dios onde̱ sáá nátu̱'un yóso tú'un‑de nuu̱ tutú: ");
INSERT INTO migNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Te vásá ncháa̱‑ri̱ nasáva̱'a‑ri̱ ve'e David ja̱ ní ndua̱. Te nachutá'an‑ri̱ ja̱ ní tanu̱, te ndukani jáá‑rí kundii̱, ");
INSERT INTO migNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","náva̱'a ta̱ká‑ga̱ cha̱a jíín táká ña̱yɨvɨ sɨ́ɨn nación ja̱ kúnání‑i jíín sɨ́'vɨ́‑rí, ná nándúkú‑i máá Tatá Dios, áchí máá I'a̱ sá'a ta̱ká tiñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Te onde̱ kɨvɨ̱ ní jungo̱o ñu̱yɨ́vɨ stá'a̱n‑ya̱ tíñu yá'a nuu̱ ñáyɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ja̱ yúán jáni ini̱‑ri̱ ja̱ ná tú kasu̱‑yo̱ núu̱ ñáyɨvɨ sɨ́ɨn nación ja̱ kánaxíó káva ini̱‑i nuu̱ Dios, ");
INSERT INTO migNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","chi̱ sua ná cháa‑yó carta ki'i̱n nuu̱‑í ja̱ ná kúnu‑i koto‑i ndatíñu ja̱ kúchá'án sá'a ndoso̱, te ma̱ káka téné‑i, te ma̱ kée‑í nɨñi̱, ni ku̱ñu kɨtɨ ní kuá'ñá. ");
INSERT INTO migNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Chi̱ onde̱ aná'án ká'i̱o cha̱a jáni tu̱'un Moisés ndɨta'a̱n kɨvɨ̱ ndéta̱tú ini̱ ve̱'e sinagoga ndɨta'a̱n ñuu̱. Achí Jacobo. ");
INSERT INTO migNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yúan‑na te ni̱ ka̱kundaa̱ ini̱ cha̱a apóstol, jíín cháa kákuu nuu̱, jíín ndívii tɨ́ku'ni̱ kándíja. Te ni̱ kaka̱ji máá‑de sava cha̱a ki̱ngoyo jíín Pablo jíín Bernabé onde̱ ñuu̱ Antioquía. Te cha̱a ni̱ kaka̱ji‑de‑ún, kákuu Judas ja̱ nání‑de ɨnga̱ sɨ́'vɨ́ Barsabás, jíín Silas. Te kákuñá'nu‑de nuu̱ táká ñani̱. ");
INSERT INTO migNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Te cha̱a‑ún, ndíso‑de carta yá'a: Máá‑rí kákuu cha̱a apóstol, jíín táká cha̱a kákuu nuu̱, jíín táká ñani̱‑yo̱. Te káchaa‑ri̱ tu̱'un yá'a nuu̱ róó, ñáni̱, ña̱yɨvɨ sɨ́ɨn nación ja̱ káxiu̱kú‑ró iní ñuu̱ Antioquía jíín ñúu̱ Siria jíín ñúu̱ Cilicia. Sándéé iní‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ni̱ ka̱jini tu̱'un‑ri̱ ja̱ ní kenda koyo sava cha̱a yá'a, te kásáká núu‑de ini̱‑ro̱ jíín tú'un káka'a̱n‑de. Te ni̱ ka̱kuxíí iní‑ro̱. Chi̱ kátá'ú‑de tiñu ja̱ xɨtɨ́ ndúu̱‑ro̱, jíín já kuándatu̱‑ro̱ núu̱ ley, kuní‑de. Ko ruu̱, tú ní kátájí‑rí cha̱a‑ún jaa̱‑de nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Te ni̱ ka̱sándaa̱‑ri̱, chi̱ ɨɨn‑na̱ ni̱ naketá'an ini̱‑ri̱. Te ni̱ kaka̱ji‑ri̱ cha̱a tájí‑rí jaa̱ nuu̱‑ro̱ jíín ñaní‑yo̱ Bernabé jíín Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Cha̱a yá'a, a kájatañaa‑de máá‑de nuu̱ túndó'o, va̱sa ná kúu̱‑de ja̱ sɨkɨ́ Jíto'o̱‑yo̱ Jesucristo. ");
INSERT INTO migNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Núsáá te tájí‑rí Judas jíín Silas jaa̱‑de nuu̱‑ro̱. Te cha̱a‑ún, suni ɨɨn‑ni tu̱'un kastu̱'ún‑de nuu̱‑ro̱ jíná'an‑ró. ");
INSERT INTO migNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Chi̱ máá‑rí jíín Espíritu Santo, kájani ini̱‑ri̱ ja̱ má xndée‑ri̱ ni ɨɨn tiñu ve̱e sɨkɨ̱‑ro̱, chi̱ máá‑ni tiñu kánúú yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ma̱ káji‑gá‑ro̱ ndátíñu ja̱ á ni̱ soko̱ núu̱ ndosó, ni nɨñi̱, ni kɨtɨ kuá'ñá, te ma̱ káka téné‑ró. Nú ndɨ'ɨ ta̱ká ya̱'á xnáa‑ro, te bueno skíkuu‑ró nú súan. A ni̱ ka'a̱n‑yo̱ núsáá. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Yúan‑na te cha̱a kája'a̱n‑ún, ni̱ ka̱kuun‑de kua'a̱n‑de ñuu̱ Antioquía. Te ni̱ ka̱stútú‑de ña̱yɨvɨ kuá'a̱. Te ni̱ kaja̱'a‑de carta‑ún nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Te ni̱ ka̱ka'u‑i carta‑ún. Te ni̱ ka̱kusɨɨ̱ iní‑i jíín tú'un ndéé iní ja̱ ndíso carta‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Te Judas jíín Silas, suni cha̱a kájani tu̱'un Dios kákuu‑de. Te jíín kuá'a̱ tú'un ni̱ kaka'a̱n ni̱'in‑de jíín táká ñani̱‑ún. Te ni̱ ka̱yija‑ga̱ ini̱‑i ni̱ ka̱sá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Te ni̱ ka̱kendo̱o‑de yúan kua'a̱ kɨvɨ́. Yúan‑na te ñani̱ yúan, ni̱ ka̱nachu'un íchí‑i‑de káno'o̱n‑de nuu̱ apóstol. Te ni̱ kuná'ín‑ni tu̱'un‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ko Silas, ni̱ jata'a̱n ini̱‑de ja̱ kéndo̱o‑de yúan. ");
INSERT INTO migNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Te Pablo jíín Bernabé, ni̱ ka̱kendo̱o‑de ini̱ ñuu̱ Antioquía. Te jíín sáva‑ga̱ cha̱a ni̱ ka̱stá'a̱n‑de tu̱'un ni̱ ka̱jani‑de tu̱'un máá Jíto'o̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Te ni̱ kuu‑ga̱ kɨvɨ̱. Te ni̱ kachi̱ Pablo jíín Bernabé: Vina te kinde̱'é‑yó táká ñani̱‑yo̱ ndɨ́ta'a̱n ñuu̱ ja̱ ní ka̱jani‑yó tú'un máá Jíto'o‑yo̱ núu̱‑í, ná ndéó ndasa kákuu‑i. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Te Bernabé, kuní‑de ja̱ kúnchaka‑de Juan, cha̱a nání Marcos. ");
INSERT INTO migNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ko tú ní játa'a̱n ini̱ Pablo ja̱ kí'i̱n cha̱a‑ún jíín‑de, chi̱ onde̱ ñuu̱ Panfilia ni̱ kusɨ́ɨn Juan nuu̱ Pablo jíín Bernabé, te tú ní kuní‑de kukuu‑de jíín‑de jíín tíñu. ");
INSERT INTO migNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Te ni̱ ka̱státá'an téyíí‑de sɨkɨ̱ Juan. Te ni̱ ka̱kusɨ́ɨn‑de. Te Bernabé, ni̱ jaka‑de Marcos, kua'a̱n jíín‑de jíín barco onde̱ ñuu̱ Chipre. ");
INSERT INTO migNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Te Pablo, ni̱ ka̱ji‑de Silas, kua'a̱n jíín‑de. Te ni̱ ka̱nakuatá'ú táká ñani̱ nuu̱‑dé. Te ni̱ kajika̱n ta'u̱‑í ja'a̱ Pablo ja̱ ná chíndéé chítuu‑ya̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Te ni̱ jika kuu‑de nɨ́ɨ́ ñúu̱ Siria jíín nɨ́ɨ́ ñúu̱ Cilicia. Te tɨku'ni̱ kákandíja yúan, ni̱ ka̱yija‑ga̱ ini̱‑i ni̱ sá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Yúan‑na te vásá ní jaa̱ Pablo ñuu̱ Derbe jíín ñúu̱ Listra. Yúan íó ɨɨn cha̱a súchí skuá'a nání Timoteo. Se̱'e yíí ɨɨn ña'an judía kúu‑i. Te ña'an kándíja va̱'a kúu máá‑ña. Ko táa̱‑i kúu cha̱a ñuu̱ Grecia. ");
INSERT INTO migNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Te ta̱ká ñani̱ ini̱ ñuu̱ Listra jíín iní ñuu̱ Iconio, ni̱ kaka'a̱n‑de ja̱ cháa va̱'a kúu‑i. ");
INSERT INTO migNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Te Pablo, kuní‑de kunchaka‑de cha̱a súchí yá'a ki'i̱n‑i jíín‑de. Te ni̱ jaka‑de‑i. Te ni̱ xɨtɨ ndúu̱‑de‑i kua̱chi ja̱ ká'i̱in cha̱a judío yúan, chi̱ ndɨ'ɨ‑de, a kájini̱‑de ja̱ cháa ñuu̱ Grecia kúu táa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Te kája'a̱n‑de ta̱ká ñuu̱. Te ni̱ ka̱stá'a̱n‑de tu̱'un ni̱ ka̱tá'ú tíñu cha̱a apóstol jíín cháa kákuu nuu̱ iní ñuu̱ Jerusalén. Te ni̱ kaka'a̱n‑de ja̱ ná kuándatu̱‑i tu̱'un‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Te tɨku'ni̱ kákandíja, ni̱ ka̱yija‑ga̱ ini̱‑i. Te ni̱ ndea̱ kua'a̱‑gá‑i ndɨta'a̱n kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Te ni̱ kaja̱'a‑de ichi ñúu̱ Frigia ndañúu̱ Galacia kua'a̱n‑de. Te ni̱ jasu̱ Espíritu Santo nuu̱‑dé ja̱ má káni‑de tu̱'un ini̱ ñuu̱ Asia. ");
INSERT INTO migNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Te ni̱ ja̱koyo‑de ñuu̱ Misia. Te kákuni̱‑de ki̱ngoyo‑de ichi ñúu̱ Bitinia. Ko máá Espíritu, tú ní já'a‑ya̱ tú'un ki'i̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Te ni̱ kaja̱'a‑de ichi xíin ñúu̱ Misia, ni̱ ka̱kuun‑de ñuu̱ Troas kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Te ɨɨn akuáa ní skóto‑ya̱ Pablo. Te ni̱ jini̱‑de nuu̱ ɨ́ɨn cha̱a ñuu̱ Macedonia kándii̱ nuu̱‑dé ká'a̱n nda̱'ú jíín‑de: Ña'a̱n‑ní ñuu̱ Macedonia yá'a te chindéé chítuu‑ní náá, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Te súan ni̱ jini̱‑de ja̱ni‑ún, te ni̱ ndúkú ndéé‑rí kája'a̱n‑ni‑ri̱ ñuu̱ Macedonia, chi̱ kájini̱ kájí‑ri̱ ja̱ máá Dios ni̱ kana‑ya̱ xiní‑rí ja̱ kástu̱'ún‑rí tu̱'un va̱'a‑ya̱ núu̱ ñáyɨvɨ yúan. ");
INSERT INTO migNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Te ni̱ kenda koyo‑ri̱ ini̱ ñuu̱ Troas. Te jíín barco ní jío‑ni va̱i koyo‑ri̱ ñuu̱ Samotracia. Te ɨnga̱ kɨvɨ̱ xía̱n ni̱ ja̱koyo‑ri̱ ñuu̱ Neápolis. ");
INSERT INTO migNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Te yúan ni̱ kenda koyo‑ri̱. Te ni̱ jaa̱‑ri̱ ñuu̱ Filipos ja̱ tɨ́ɨn xini̱ ñúu̱ Macedonia, te chi̱i ñuu̱ Roma kándee. Te yúan ni̱ ka̱kendo̱o‑ri̱ yaku̱ kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Te ɨɨn kɨvɨ̱ ndéta̱tú ni̱ kenda koyo‑ri̱ ñuu̱‑ún, ni̱ jaa̱‑ri̱ xiin ɨ́ɨn yu̱cha. Te kájani̱ ini̱‑ri̱ ja̱ yúan íó ɨɨn lugar kájika̱n ta'u̱‑í. Te ni̱ ka̱jungo̱o‑ri̱. Te ni̱ kaka'a̱n‑ri̱ jíín táká ña'an ní ka̱nataka̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Te ɨɨn ña'an nání Lidia xíkó‑ña sá'ma ndí'í iní ñuu̱ Tiatira. Te jándatu̱ va̱'a‑ña núu̱ Dios. Te ni̱ jini so̱'o‑ña tú'un káka'a̱n‑ri̱. Te máá Jíto'o̱‑yo̱, ni̱ juña‑ya̱ añú‑ña náva̱'a kuni ná'ín‑ña tú'un ká'a̱n Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Te nuu̱ ní janducha‑ñá onde̱ jíín nɨ́ɨ́ sé'e‑ña, te ni̱ ka'a̱n nda̱'ú‑ña jíín‑rí: Nú kájani ini̱‑ní ja̱ kándíja va̱'a‑ná nuu̱ máá Jíto'o̱‑yo̱, te kɨ̱vɨ‑ní ini̱ ve̱'e‑ná kendo̱o‑ní, áchí‑ña. Te ni̱ stétuu‑ña rúu̱. ");
INSERT INTO migNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Te ni̱ kee‑ri̱ kája'a̱n‑ri̱ nuu̱ kájika̱n ta'u̱‑í yúan. Te ɨɨn su̱chí sɨ́'ɨ́ ndíso‑i tu̱'un ña̱vá'a, ni̱ ketá'an‑i jíín‑rí. Te su̱chí‑ún, ní'i̱n‑í kua'a̱ xú'ún kúu patrón‑i jíná'an, ja̱ kástu̱'ún‑i nuu̱ ñáyɨvɨ ndasa íó. ");
INSERT INTO migNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Te su̱chí‑ún, ndikín‑i va̱i yata̱ Pablo jíín rúu̱ kána kó'ó‑i: Cha̱a yá'a kájatíñu‑de nuu̱ Dios onde̱ andɨ́vɨ́, te kákastu̱'ún‑de nuu̱‑ro̱ ndasa ka̱ku‑ró jíná'an‑ró, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Te kua'a̱ kɨvɨ́ ní ka'a̱n‑i súan. Te ni̱ kukuí'a̱ ini̱ Pablo. Te ni̱ xíó kóto‑de nuu̱‑í. Te ni̱ ka'a̱n‑de jíín tachí‑ún: Jíín sɨ́'vɨ́ máá Jesucristo tá'ú‑rí tiñu nuu̱‑ro̱ já kénda‑ró iní‑i ki'i̱n‑ro̱, áchí‑de. Te ni̱ kenda‑ni kua'a̱n suni máá hora‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Te ni̱ kajini̱ patrón‑i ja̱ má ní'i̱n‑gá xu̱'ún. Te ni̱ ka̱katɨɨn Pablo jíín Silas kua'a̱n jíín‑de onde̱ municipio nuu̱ justicia. ");
INSERT INTO migNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Te ni̱ ka̱jani‑ún‑de nuu̱ justicia. Te ni̱ kaka'a̱n: Cha̱a yá'a kákuu cha̱a judío, te kásáká núu‑de ini̱ ñuu̱‑yo̱. ");
INSERT INTO migNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Te kájaki̱n‑de ɨnga̱ costumbre ja̱ tú íó ley kuandatu̱‑yo̱ ni ma̱ sá'a‑yó, chi cha̱a ñuu̱ Roma kákuu‑yó. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Te suni ni̱ ka̱ndonda ña̱yɨvɨ kuá'a̱ sɨkɨ́‑dé. Te cha̱a justicia, ni̱ ka̱janchaa̱ sa'ma‑dé. Te ni̱ ka̱tá'ú tíñu ná ndó'o xaa̱n‑dé yunu xíi. ");
INSERT INTO migNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Te nuu̱ ní ndɨ'ɨ ni̱ ka̱stují‑ún‑de ja̱ ní kaja̱'a xaa̱n yúnu xíi‑de, te ni̱ ka̱skɨ́vɨ‑de veka̱a. Te ni̱ ka̱tá'ú tíñu nuu̱ cháa ndíto veka̱a ja̱ ná kóto va̱'a cha̱a‑ún‑de jíná'an‑de. ");
INSERT INTO migNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Te cha̱a ndíto veka̱a‑ún, nuu̱ ní ta'u̱ tíñu yá'a nuu̱‑dé, te ni̱ skɨ́vɨ‑de Pablo jíín Silas kája'a̱n‑de veka̱a onde̱ ichi iní‑ga̱. Te nú'ni̱ ja'a̱‑dé jíín manea. ");
INSERT INTO migNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ko nuu̱ ní kuu sava ñúú, te kájika̱n ta'u̱ Pablo jíín Silas, kájita‑de yaa̱ ii̱ núu̱ Dios. Te ña̱yɨvɨ ká'i̱in veka̱a jíín‑de, ni̱ ka̱jini ná'ín‑i. ");
INSERT INTO migNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Te sanaa‑ní te ni̱ ta̱an xaa̱n. Te onde̱ nuu̱ káyindu̱ji ja'a̱ véka̱a‑ún ni̱ kakanda̱. Te ni̱ ka̱nuña‑ni ta̱ká yuxé'é véka̱a‑ún. Te cadena ja̱ káinu'ni̱ ta̱ká ña̱yɨvɨ‑ún, ni̱ kandaji̱‑ní. ");
INSERT INTO migNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Te ni̱ nata'u̱ núu̱ cháa ndíto veka̱a. Te ni̱ jini̱‑de ja̱ kánu̱ña yuxé'é véka̱a‑ún. Te ni̱ tava‑dé machete ja̱ ká'ni‑dé máá‑de núú, chi̱ jáni ini̱‑de ja̱ ní ka̱jinu ña̱yɨvɨ ká'i̱in veka̱a‑ún kája'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ko Pablo, ni̱ kana jaa‑de: Ma̱ stují‑ro̱ máá‑ró, chi̱ yá'a ká'i̱in ndɨ'ɨ‑ri̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Yúan‑na te máá cháa ndíto veka̱a, ni̱ kana‑de ñu'u̱n ni̱ chaa̱. Te kɨ́sɨ‑i‑de ni̱ kɨ̱vɨ‑de ini̱ veka̱a. Te ni̱ jukuiñi̱ jítɨ́‑de nuu̱ já'a̱ Pablo jíín Silas. ");
INSERT INTO migNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Te ni̱ kiñi'in‑de Pablo jíín Silas ichi fuera. Te ni̱ ka'a̱n‑de jíín‑de: Táta̱, na̱ún sá'a‑ná náva̱'a ka̱ku‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Te ni̱ kaka'a̱n‑de jíín cháa‑ún: Kandíja nuu̱ máá Jíto'o̱‑yo̱ Jesucristo te ka̱ku‑ró ondé jíín nɨ́ɨ́ vé'e‑ró, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Te ni̱ ka̱jani‑de tu̱'un máá Jíto'o̱‑yo̱ núu̱ cháa‑ún jíín núu̱ táká ña̱yɨvɨ ká'i̱in ini̱ ve̱'e‑de. ");
INSERT INTO migNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Te cha̱a ndíto veka̱a, suni máá ákuáa‑ún ni̱ kiñi'in‑de Pablo jíín Silas. Te ni̱ nakacha‑de nuu̱ ní katuji̱ cháa‑ún ni̱ sá'a yunu xíi. Te vásá ní janducha‑dé onde̱ jíín tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Te ni̱ jaka‑de cha̱a kua'a̱n‑de jíín‑de onde̱ ve'e‑de. Te ni̱ ja̱'a‑de staa̱ ní ka̱yee‑dé. Te ni̱ kusɨɨ̱ iní‑de ja̱ ní ka̱kandíja‑de nuu̱ Dios jíín nɨ́ɨ́ vé'e‑de. ");
INSERT INTO migNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Te nuu̱ ní kundiji̱n, te justicia ni̱ ka̱tájí policía kája'a̱n. Te ni̱ kaka'a̱n: Sía̱ cha̱a jia̱n ná kíngoyo‑de, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Te cha̱a ndíto veka̱a, ni̱ kastu̱'ún‑de tu̱'un yá'a nuu̱ Pablo: Cha̱a justicia, ni̱ ka̱tájí‑de tu̱'un va̱i ja̱ kénda koyo‑ní ki'i̱n‑ní. Núsáá te kenda koyo‑ní te kuá'án‑ní, ma̱ yú'ú‑ní. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ko ni̱ kachi̱ Pablo jíín‑de: Ni̱ kajini̱ kua'a̱ ñáyɨvɨ já ní kaja̱'a‑de yunu xíi ruu̱ va̱sa tú na̱ kua̱chi‑ri̱. Te ni̱ ka̱skɨ́vɨ‑de ruu̱ ini̱ veka̱a yá'a va̱sa cha̱a ñuu̱ Roma kákuu‑ri̱. Te vina kiñi'in sa̱'í‑de ruu̱ kuní‑de náún. Ma̱ kúu kutɨ. Ná kíkoyo máá‑de kiñi'in‑de ruu̱ jíná'an‑ri̱. Achí Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Te policia, ni̱ ka̱naxíó káva‑de ni̱ kastu̱'ún‑de ta̱ká tu̱'un yá'a nuu̱ justicia. Te ni̱ kayu̱'ú xaa̱n, chi ni̱ ka̱jini so̱'o ja̱ cháa ñuu̱ Roma kákuu Pablo jíín Silas. ");
INSERT INTO migNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Te ni̱ ja̱koyo justicia‑ún. Te ni̱ kaka'a̱n nda̱'ú jíín‑de. Te ni̱ ka̱kiñi'in‑de veka̱a. Te ni̱ kaka'a̱n nda̱'ú jíín‑de ná kúxio‑de ki̱ngoyo‑de ini̱ ñuu̱‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Yúan‑na te ni̱ kenda koyo‑de veka̱a. Te ni̱ ndɨ̱vɨ‑de ve'e Lidia. Te ni̱ kaja̱nde̱'é‑de ta̱ká ñani̱. Te ni̱ kaka'a̱n‑de tu̱'un ndéé iní jíín‑i. Te ni̱ kee‑de kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Te Pablo jíín Silas, ni̱ kaja̱'a‑de ñuu̱ Anfípolis jíín ñúu̱ Apolonia kája'a̱n‑de. Te ni̱ ja̱koyo‑de ñuu̱ Tesalónica nuu̱ íó ɨɨn ve'e sinagoga cha̱a judío. ");
INSERT INTO migNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Te Pablo, nátu̱'un sá'a sá'a‑de ni̱ kɨ̱vɨ‑de nuu̱ cháa‑ún uni̱ kɨvɨ̱ ndéta̱tú. Te ndɨta'a̱n semana ni̱ ka̱státá'an‑de jíín cháa‑ún sɨkɨ̱ tutú ii̱. ");
INSERT INTO migNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Te ni̱ jani‑de tu̱'un nuu̱‑í, ni̱ stá'a̱n‑de ja̱ kánúú ndó'o Cristo te nachaku̱‑ya̱ nú ni̱ ji'i̱‑ya̱. Te ni̱ ka'a̱n‑de: Jesús, I'a̱ jáni‑ri̱ tu̱'un yá'a, máá‑yá kúu Cristo, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Te sava ña̱yɨvɨ, ni̱ ka̱kandíja‑i. Te suni súan kua'a̱ cháa ñuu̱ Grecia ja̱ káchiñú'ún‑de Dios, jíín kuá'a̱ ñá'an ñá'nu, ni̱ ka̱ndujíín‑de jíín Pablo jíín Silas. ");
INSERT INTO migNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yúan‑na te cha̱a judío ja̱ tú kákandíja, ni̱ kakiti̱ xaa̱n iní. Te ni̱ ka̱stútú sáva cha̱a ñáá, cha̱a kúxí, kua'a̱n jíín. Te ni̱ kutútú kuá'a̱ ñáyɨvɨ ní ka̱ndonda‑i ini̱ ñuu̱‑ún. Te ni̱ ja̱koyo‑i ve'e Jasón kánandúkú‑i Pablo jíín Silas ja̱ kíñi'in‑i‑de nuu̱ ñáyɨvɨ‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ko tú ní kánani'i̱n‑í‑de. Te ni̱ ka̱ñu'un‑i Jasón jíín sáva‑ga̱ ñani̱ ni̱ ja̱koyo‑i jíín‑de onde̱ nuu̱ justicia ñuu̱‑ún. Te ni̱ ka̱kana jaa‑i: Cha̱a yá'a ja̱ kásáká núu‑de ini̱ ñu̱yɨ́vɨ, suni ni̱ cha̱koyo‑de yá'a, ");
INSERT INTO migNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","te Jasón, ni̱ ja̱'a núu‑de ve'e‑de ncháá cha̱a‑ún. Te ta̱ká máá‑de, tú kájandatu̱‑de nuu̱ ley César. Chi̱ sua káka'a̱n‑de ja̱ íó ɨnga̱ rey nání Jesús, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Te ña̱yɨvɨ jíín cháa kákuu justicia, ni̱ ka̱jini so̱'o‑i tu̱'un yá'a. Te ni̱ ka̱kuvaa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ko ni̱ kajika̱n‑i xu̱'ún núu̱ Jasón jíín núu̱ sáva‑ga̱‑de. Te onde̱ ni̱ kajini̱‑i nuu̱ xú'ún te vásá ní ka̱sía̱‑i‑de kája'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Yúan‑na te ñani̱‑ún, ni̱ ka̱skáka ñúú‑ni‑de Pablo jíín Silas kája'a̱n‑de onde̱ ñuu̱ Berea. Te nuu̱ ní ja̱koyo‑de yúan, te ni̱ kɨ̱vɨ koyo‑de ini̱ ve̱'e sinagoga cha̱a judío. ");
INSERT INTO migNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Te cha̱a judío yúan, ndito‑ga̱ xini̱‑dé vásá cháa judío ñuu̱ Tesalónica, chi̱ bueno ni̱ ka̱kusɨɨ̱ iní‑de jíín tú'un. Te ndɨta'a̱n kɨvɨ̱ kánandúkú víi‑dé ini̱ tutu̱ ii̱ nú ndaa̱ ká'a̱n xí túu. ");
INSERT INTO migNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Súan ni̱ kuu. Te ni̱ ka̱kandíja kua'a̱‑í, jíín kuá'a̱ ñá'an ñá'nu ñuu̱ Grecia, te suni súan kua'a̱ cháa. ");
INSERT INTO migNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ko cha̱a judío ñuu̱ Tesalónica, ni̱ ka̱jini tu̱'un‑de ja̱ súni onde̱ ñuu̱ Berea ni̱ jicha̱ tu̱'un Dios ni̱ sá'a Pablo. Te ni̱ kee‑de kája'a̱n‑de. Te suni yúan ni̱ ka̱xndónda‑de ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Yúan‑na te ñani̱ yúan, ni̱ ka̱tájí‑ni‑de Pablo kua'a̱n‑de onde̱ yu'u mar. Te Silas jíín Timoteo, ni̱ ka̱kendo̱o‑de ini̱ ñuu̱ Berea. ");
INSERT INTO migNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Te ña̱yɨvɨ ní ka̱chu'un íchí Pablo, kua'a̱n‑i jíín‑de onde̱ ñuu̱ Atenas. Te ni̱ natá'ú‑de tiñu nuu̱‑í ja̱ yachí jaa̱ Silas jíín Timoteo nuu̱‑dé. Te ni̱ kee‑i va̱i ndikoyo‑i. ");
INSERT INTO migNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Te nini ndátu Pablo cha̱a‑ún ini̱ ñuu̱ Atenas, te ni̱ jini̱‑de ja̱ ñáyɨvɨ ñúu̱‑ún xaa̱n káchiñú'ún‑i ndoso̱. Te ni̱ kukuí'a̱ ini̱‑de. ");
INSERT INTO migNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Te ini̱ ve̱'e sinagoga ni̱ státá'an‑de jíín cháa judío jíín cháa káchiñú'ún Dios. Te suni ndɨta'a̱n kɨvɨ̱ státá'an‑de jíín ñáyɨvɨ ká'i̱in nu̱yá'u. ");
INSERT INTO migNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Te sava cha̱a ndíchí káskuá'a sɨkɨ̱ epicúreos jíín sɨkɨ́ estoicos, ni̱ ka̱státá'an jíín‑de. Te sava ni̱ kaka'a̱n: Na̱ún tu̱'un ká'a̱n cha̱a tɨ́lakuá yá'a, áchí. Te sava‑ga̱‑i: Cha̱a jáni tu̱'un i'a̱ jáá kúu‑de, áchí‑i. Chi ni̱ jani‑de tu̱'un Jesús ja̱ ní nachaku̱‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Te ni̱ ka̱jaka‑ún‑de va̱i jíín‑de onde̱ municipio Areópago te káka'a̱n: Á kuu kachi̱‑ro̱ núu̱‑rí na̱ún tu̱'un jáá kúu ja̱ stá'a̱n‑ro̱‑ún, ");
INSERT INTO migNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","chi̱ stá'a̱n‑ro̱ tú'un jáá núu̱‑rí. Te ná júku̱'un ini̱‑ri̱ na̱ún kúu‑ún kákuni̱‑ri̱. Achí jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Chi ta̱ká cha̱a ñuu̱ Atenas jíín táká cha̱a jíká káxiu̱kú núu‑de yúan, tuká ndé ɨnga̱ tiñu kásá'a‑de, chi̱ máni ká'a̱n‑de xí jíni so̱'o‑de ɨɨn tu̱'un jáá. ");
INSERT INTO migNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Te Pablo, kándii̱‑de ini̱ municipio Areópago‑ún. Te ni̱ ka'a̱n‑de: Cha̱a ñuu̱ Atenas jíná'an‑ró, jiní va̱'a‑ri̱ ja̱ bueno káchiñú'ún‑ró i'a̱ máá‑ró. ");
INSERT INTO migNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Chi ni̱ jika kuu‑ri̱ ni̱ jande̱'é‑rí ini̱ viñu̱'un‑ró. Te ni̱ jini̱‑ri̱ nuu̱ ɨ́ɨn altar nuu̱ yóso tú'un yá'a: Nuu̱ i'a̱ ja̱ ná tú jiní‑yo̱, áchí. Te máá I'a̱‑ún, ja̱ káchiñú'ún‑ró‑yá va̱sa tú kájini̱‑ro̱‑yá, I'a̱‑ún kúu Dios ja̱ jáni‑ri̱ tu̱'un‑ya̱ núu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Máá Dios, I'a̱ ni̱ sá'a ñu̱yɨ́vɨ jíín táká‑ga̱ ndatíñu, máá‑yá kúu Jito'o̱ andɨ́vɨ́ jíín ñúyɨ́vɨ. Te tú ncháá‑ya̱ iní ve̱'e ii̱ já kúva̱'a sá'a nda'a. ");
INSERT INTO migNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Te tú nándɨ'ɨ‑ya̱ ní ɨɨn ndatíñu ni ña̱yɨvɨ kuátíñu nuu̱‑yá, chi̱ máá‑yá, já'a‑ya̱ tú'un ja̱ káichaku̱ ña̱yɨvɨ jíín já stáa‑i tachi̱ jíín já ní'i̱n‑í ndatíñu. ");
INSERT INTO migNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Te chi̱i ɨɨn‑ni tata̱ ni̱ sá'a‑ya̱ táká ña̱yɨvɨ náva̱'a kuxiu̱kú‑i nɨ́ɨ́ ñúyɨ́vɨ. Te ni̱ jani‑ya̱ kɨvɨ́ kúchaku̱ ɨɨn ɨɨn‑i jíín lugar kuxiu̱kú‑i jíná'an‑i. ");
INSERT INTO migNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Náva̱'a ná nándúkú‑i Dios, te nú súan skáka nda'a‑í te ni'i̱n‑í‑ya̱, chi̱ tú jíká ncháá‑ya̱ jíín ɨ́ɨn ɨɨn‑yó. ");
INSERT INTO migNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Chi̱ jíín máá‑yá, káichaku̱‑yo̱, kákanda‑yó, te ñú'un vida‑yo̱. Nátu̱'un sava cha̱a kátava yáa̱‑ro̱, ni̱ kaka'a̱n‑de: Chi̱ suni onde̱ tata̱ máá‑yá kákuu ta̱ká‑yo̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nú tata̱ Dios kákuu‑yó núsáá, te ma̱ kúu kani ini̱‑yo̱ já Dios kúu oro xí plata xí yúu̱. Chi̱ máni kájani ini̱‑i ja̱ súan jíto‑ya̱, te súan kánatava máá‑i‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Te va̱sa tú ní sá'a‑ya̱ cuenta ja̱ tú ní kájuku̱'un ini̱ ña̱yɨvɨ ondé sáá, ko vina kána‑ya̱ xiní táká ña̱yɨvɨ nɨ́ɨ́ ñúyɨ́vɨ ná nákani ini̱‑i. ");
INSERT INTO migNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Te a ni̱ teta'a̱n‑ya̱ ɨ́ɨn kɨvɨ̱ já náku̱xndíi ndaa̱‑ya̱ sɨkɨ́ ñúyɨ́vɨ, sá'a Dios jíín máá I'a̱ ni̱ jani‑ya̱‑ún. Te ni̱ stá'a̱n ndiji̱n Dios ja̱ súan kuu, chi ni̱ naschakú‑ya̱ I'a̱‑ún ma̱'ñú ndɨ́yi. Achí Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Te súan ni̱ ka̱jini so̱'o‑i tu̱'un ja̱ náchaku̱ ndɨ̱yi, te sava‑i, ni̱ ka̱sákátá‑i nuu̱‑dé. Te sava‑ga̱‑i, ni̱ kaka'a̱n‑i: Kákuni̱‑ná kuni so̱'o‑ná ɨnga̱ jínu sɨkɨ̱ tú'un ká'a̱n‑ní yá'a, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Te máá Pablo, ni̱ kenda‑de ma̱'ñú ñáyɨvɨ‑ún kua'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ko yaku̱ ña̱yɨvɨ, ni̱ ka̱kandíja‑i. Te ni̱ ka̱ndujíín‑i jíín Pablo. Te ɨɨn‑i kúu Dionisio cha̱a Areópago, te ɨnga̱‑i kúu ɨɨn ña'an nání‑ña Dámaris, jíín sáva‑ga̱‑i. ");
INSERT INTO migNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Yúan‑na te ni̱ kenda Pablo ini̱ ñuu̱ Atenas, te kua'a̱n‑de onde̱ ñuu̱ Corinto. ");
INSERT INTO migNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Te yúan ni̱ jini̱‑de nuu̱ ɨ́ɨn cha̱a judío nání Aquila, cha̱a ñuu̱ Ponto kúu‑de, ja̱ sá yakú‑ni kɨvɨ̱ ní chaa̱‑de jíín ñásɨ́'ɨ́‑de Priscila, ja̱ ní kuxio‑de ini̱ ñuu̱ Italia. (Chi̱ Claudio, ni̱ tá'ú‑de tiñu ja̱ ná kénda koyo ta̱ká ña̱yɨvɨ judío ini̱ ñuu̱ Roma.) Te ni̱ jaa̱ Pablo nuu̱ cháa‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Te suni tiñu sá'a cha̱a‑ún sá'a Pablo. Te ni̱ kendo̱o‑de yúan. Te ni̱ sátiñu‑de, chi̱ tiñu kásá'a‑de‑ún kúu ja̱ kájani‑de ve'e sa'ma nátu̱'un ñii. ");
INSERT INTO migNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Te ndɨta'a̱n kɨvɨ̱ ndéta̱tú ni̱ jani‑de tu̱'un ini̱ ve̱'e sinagoga. Te ni̱ ndúkú ndéé‑de ni̱ skándíja‑de ña̱yɨvɨ judío jíín ñáyɨvɨ ñúu̱ Grecia. ");
INSERT INTO migNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Te Silas jíín Timoteo, ni̱ kikoyo‑de ichi ñúu̱ Macedonia. Te Pablo, a jáni téyíí‑de tu̱'un, te jáni ndaa̱‑de tu̱'un nuu̱ ñáyɨvɨ judío ja̱ Jesús kúu‑ya̱ Cristo. ");
INSERT INTO migNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ko ña̱yɨvɨ‑ún, ni̱ kaka'a̱n ndɨva̱'a‑i sɨkɨ̱‑dé. Te máá‑de, ni̱ kaja‑dé sa'ma‑dé. Te ni̱ kachi̱‑de jíín‑i: Kua̱chi máá‑ró kúu núsáá, chi̱ ruu̱, tú kua̱chi‑ri̱. Vina te ki'i̱n‑ri̱ nuu̱ ñáyɨvɨ sɨ́ɨn nación. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Te ni̱ kenda‑de yúan. Te ni̱ kɨ̱vɨ‑de ve'e ɨɨn cha̱a nání Justo. Te cha̱a‑ún, chíñú'ún‑de Dios. Te ve'e cha̱a‑ún kándii̱ yani jíín vé'e sinagoga. ");
INSERT INTO migNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Te Crispo, cha̱a kúñá'nu ini̱ ve̱'e sinagoga, ni̱ kandíja‑de nuu̱ máá Jíto'o̱‑yo̱ ondé jíín nɨ́ɨ́ vé'e‑de. Te kua'a̱ ñáyɨvɨ ñúu̱ Corinto, ni̱ ka̱jini ná'ín‑i. Te ni̱ ka̱kandíja‑i. Te ni̱ ka̱janducha‑í. ");
INSERT INTO migNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Te máá Jíto'o̱‑yo̱, jíín jáni ni̱ ka'a̱n‑ya̱ jíín Pablo ɨɨn akuáa: Ma̱ yú'ú‑ro̱ ni ma̱ kasú‑ro̱ yú'u‑ro, chi̱ kukuu‑ró ká'a̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Chi̱ jíka‑ri̱ jíín‑ró, te ma̱ sándɨva̱'a ni ɨɨn cha̱a jíín‑ró. Chi̱ ñáva̱'a‑ri̱ kua'a̱ ñáyɨvɨ iní ñuu̱ yá'a, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Te ni̱ kendo̱o‑de yúan ɨɨn kuia̱ yósáva, te stá'a̱n‑de tu̱'un Dios nuu̱‑í. ");
INSERT INTO migNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Te Galión kúu gobernador ini̱ ñuu̱ Acaya. Te ña̱yɨvɨ judío, ɨɨn ká'nu‑ni ni̱ ka̱ndonda‑i sɨkɨ̱ Pablo. Te ni̱ ka̱jaka‑i‑de kua'a̱n‑i jíín‑de onde̱ ini̱ municipio. ");
INSERT INTO migNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Te ni̱ kaka'a̱n‑i: Cha̱a yá'a, xaa̱n ská'a̱n‑de ta̱ká ña̱yɨvɨ já ná chíñú'ún‑i Dios te ma̱ kuándatu̱‑ga̱‑i tu̱'un ká'a̱n ley, kuní‑de. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Te kejá'á Pablo ka'a̱n‑de núú, ko ni̱ ka'a̱n‑ni Galión jíín ñáyɨvɨ judío: Ña̱yɨvɨ judío jíná'an‑ró, nú sɨkɨ̱ ɨ́ɨn tu̱'un ni̱'in ini̱ kúu, xí ɨ́ɨn kua̱chi xaa̱n kúu, te va̱tu‑ni ná kúni ná'ín‑rí tu̱'un ka'a̱n‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ko nú sɨkɨ̱ tú'un‑ni kúu, xí sɨkɨ́ na̱ni sɨ́'vɨ́, xí sɨkɨ́ ley máá‑ró, yúan‑na te ná sándaa̱ máá‑ró núsáá. Chi̱ ruu̱, tú kuní‑ri̱ skɨ́vɨ nduu̱‑ri̱ ja̱ sándaa̱‑ri̱ tu̱'un súan. ");
INSERT INTO migNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Te ni̱ skúnu‑de‑i kája'a̱n‑i fuera municipio. ");
INSERT INTO migNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yúan‑na te ni̱ ka̱katɨɨn‑i Sóstenes, cha̱a kúñá'nu ini̱ ve̱'e sinagoga. Te ni̱ kaja̱'a‑i‑de yuxé'é municipio. Te Galión, tú ní sá'a‑de cuenta. ");
INSERT INTO migNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ko Pablo, ni̱ kuu kua'a̱ kɨvɨ́ kánchaa̱‑de yúan. Te ni̱ nakuatá'ú‑de nuu̱ táká ñani̱ yúan. Te kua'a̱n‑de jíín barco onde̱ ñuu̱ Siria. Te Priscila jíín Aquila kája'a̱n jíín‑de. Te ni̱ jaa̱‑de ñuu̱ Cencrea. Te ni̱ se̱té‑de xini̱‑dé sɨkɨ̱ ɨ́ɨn tu̱'un ni̱ keyu'u‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Te ni̱ jaa̱‑de ñuu̱ Éfeso, te ni̱ skéndo̱o‑de cha̱a‑ún yúan. Ko Pablo, ni̱ kɨ̱vɨ‑ni‑de ini̱ ve̱'e sinagoga kástátá'an‑de jíín ñáyɨvɨ judío. ");
INSERT INTO migNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Te ni̱ kaka'a̱n nda̱'ú‑i jíín‑de ja̱ ná kéndo̱o‑de yaku̱‑ga̱ kɨvɨ̱ jíín‑i. Ko Pablo, tú ní játu̱'un‑de. ");
INSERT INTO migNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Chi ni̱ nakuatá'ú‑de nuu̱‑í. Te ni̱ ka'a̱n‑de: Kánúú já kí'i̱n ná'ín‑rí ñuu̱ Jerusalén, sá'a‑ri̱ kɨvɨ̱ íi̱. Ko nú kuní Dios, te nchaa̱ tuku‑ri̱ nuu̱‑ro̱. Achí‑de. Te ni̱ kenda‑de ñuu̱ Éfeso kua'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Te ni̱ jaa̱‑de jíín barco onde̱ ñuu̱ Cesarea. Te ni̱ kaa‑de ñuu̱ Jerusalén. Te nuu̱ ní ndɨ'ɨ ni̱ ka'a̱n‑de jíín tɨ́ku'ni̱ kándíja yúan, te ni̱ nuu‑de ni̱ najaa̱‑de ñuu̱ Antioquía. ");
INSERT INTO migNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Te ni̱ kendo̱o‑de yúan yaku̱ kɨvɨ̱. Te vásá ní kenda‑de kua'a̱n‑de, ni̱ jika kuu‑de nɨ́ɨ́ ndáñúu̱ Galacia jíín ndáñúu̱ Frigia. Te ni̱ ka̱yija‑ga̱ ini̱ ña̱yɨvɨ káskuá'a‑ún ni̱ sá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Te ñuu̱ Éfeso ni̱ chaa̱ ɨɨn cha̱a judío nání Apolos, cha̱a ñuu̱ Alejandría kúu‑de. Te va̱'a ká'a̱n‑de chi̱ ndíchí xáa̱n‑dé tutu̱ ii̱. ");
INSERT INTO migNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Te cha̱a‑ún, a ni̱ kutu̱'a‑de jíín tú'un máá Jíto'o̱‑yo̱. Te jítú iní‑de tú kuítá‑de ká'a̱n‑de ja̱ stá'a̱n‑de tu̱'un máá Jíto'o̱‑yo̱, va̱sa máni tu̱'un ja̱ ní skuánducha Juan jiní‑de ká'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Te ni̱ chundéé iní‑de ká'a̱n kájí‑de ini̱ ve̱'e sinagoga. Te ni̱ ka̱jini so̱'o Priscila jíín Aquila tu̱'un ká'a̱n‑de. Te ni̱ ka̱jaka‑de cha̱a kua'a̱n‑de jíín‑de. Te ni̱ ka̱jani kájí‑ga̱‑de tu̱'un Dios nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Te kuní Apolos ja̱ kí'i̱n‑de onde̱ ñuu̱ Acaya. Te ta̱ká ñani̱‑ún, ni̱ kaka'a̱n ndéé jíín‑de. Te ni̱ ka̱chaa tutu̱ kua'a̱n nuu̱ cháa káskuá'a yúan ja̱ ná kuátá'ú‑de cha̱a. Te nuu̱ ní jaa̱‑de yúan, te va̱'a ni̱ chindéé ní chituu‑de ña̱yɨvɨ kákandíja tu̱'un luu máá‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Te ma̱'ñú táká ña̱yɨvɨ ní státá'an‑de jíín cháa judío. Te ni̱ stá'a̱n‑de ja̱ Jesús kúu‑ya̱ Cristo, nátu̱'un ká'a̱n tutu̱ ii̱. ");
INSERT INTO migNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Te nini kándee Apolos ini̱ ñuu̱ Corinto, te ni̱ ja̱'a Pablo va̱i‑de ñuu̱ ichi nínu‑ga̱, te ni̱ nchaa̱‑de ñuu̱ Éfeso. Te yúan ni̱ jini̱‑de nuu̱ sáva ña̱yɨvɨ káskuá'a. ");
INSERT INTO migNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Te ni̱ jika̱ tu̱'ún‑de‑i: A ni̱ kani'i̱n‑ro̱ Espíritu Santo ja̱ ní ka̱kandíja‑ró xí té chá'a̱n‑ga̱, áchí‑de. Te máá‑i, ni̱ kaka'a̱n‑i jíín Pablo: Té kuni tu̱'un‑ga̱‑ná ja̱ íó Espíritu Santo, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Yúan‑na te ni̱ kachi̱ Pablo: Na̱ sɨkɨ̱ ní ka̱janducha‑ro núsáá, áchí‑de. Te ni̱ kaka'a̱n‑i: Sɨkɨ̱ tú'un ni̱ skuánducha Juan, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Te ni̱ ka'a̱n Pablo: Ni̱ skuánducha Juan jíín tú'un ja̱ ná nákani ini̱‑i, te áchí‑de jíín ñáyɨvɨ já ná kándíja‑i nuu̱ I'a̱ va̱i ichi yatá‑dé, kúu Cristo Jesús. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Te nuu̱ ní ka̱jini so̱'o‑i tu̱'un yá'a, te ni̱ ka̱janducha‑ní‑i jíín sɨ́'vɨ́ máá Jíto'o̱‑yo̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Te Pablo, ni̱ chaa‑de nda'a‑dé sɨkɨ̱‑í. Te ni̱ chaa̱‑ni Espíritu Santo sɨkɨ̱‑í jíná'an‑i. Te ni̱ kaka'a̱n‑i sɨ́ɨn sɨ́ɨn yu'u. Te ni̱ ka̱jani‑i tu̱'un‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Te ni̱ i̱o nátu̱'un uxi̱ uu̱ tá'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Te ni̱ kɨ̱vɨ Pablo ini̱ ve̱'e sinagoga. Te ni̱ chundéé iní‑de, ni̱ ka'a̱n vatu̱ máá‑de nuu̱ uní yoo̱, ndátu̱'ún‑de te skándíja‑de ña̱yɨvɨ sɨkɨ́ ñúu̱ nuu̱ tá'ú Dios tiñu. ");
INSERT INTO migNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Yúan‑na te sava‑i, ni̱ ka̱kujá'a̱ ini̱‑i te tú ní kákandíja‑i. Te ni kaka'a̱n ndɨva̱'a‑i sɨkɨ̱ íchi Dios nuu̱ táká ña̱yɨvɨ kánataka̱. Te ni̱ kuxio‑ni Pablo núu̱ ñáyɨvɨ‑ún. Te kája'a̱n cha̱a káskuá'a‑ún jíín‑de. Te ndɨta'a̱n kɨvɨ̱ ní ndatu̱'ún‑de jíín cháa‑ún ini̱ escuela ɨɨn cha̱a nání Tiranno. ");
INSERT INTO migNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Te uu̱ kuia̱ ni̱ sá'a‑de súan. Te ta̱ká ña̱yɨvɨ káxiu̱kú ñúu̱ Asia, kúu ña̱yɨvɨ judío te kúu ña̱yɨvɨ ñuu̱ Grecia, ni̱ ka̱jini so̱'o‑i tu̱'un máá Jíto'o̱‑yo̱ Jesús. ");
INSERT INTO migNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Te ni̱ sá'a Dios tɨnɨ̱ tiñu ñá'nu xaa̱n jíín ndá'a Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Te ni̱ ka̱kinchaka pañito‑de xí sá'ma‑dé nuu̱ ñáyɨvɨ káku'u̱. Te ni̱ ka̱xndée sɨkɨ̱‑í. Te ni̱ kandu̱va̱'a‑ni‑i kue'e̱ káta'a̱n‑i. Te tachi̱ kíni, ni̱ ka̱kenda ini̱‑i kája'a̱n. ");
INSERT INTO migNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Te sava cha̱a judio, ni̱ ka̱jika kuu‑de káskúnu‑de tachi̱ kíni. Te kákuni̱‑de kuatíñu‑de sɨ́'vɨ́ máá Jíto'o̱‑yo̱ Jesús ja̱ kíñi'in‑de tachi̱ kíni iní ña̱yɨvɨ. Te súan ni̱ kaka'a̱n‑de: Ká'a̱n ni̱'in‑ri̱ jíín‑ró jíín sɨ́'vɨ́ Jesús ja̱ jáni Pablo tu̱'un‑ya̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Te ɨɨn cha̱a judío nání‑de Esceva, kúu‑de sutu̱ ñá'nu, te ni̱ i̱o usia̱ se̱'e yíí‑de ja̱ kásá'a tiñu yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ko ni̱ ka'a̱n‑ni tachi̱ kíni‑ún: A jiní‑ri̱ máá Jesús. Te suni a jiní‑ri̱ Pablo. Ko róó, ndé cha̱a kákuu‑ró. Achí jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Te cha̱a tá'a̱n tachi̱ kíni‑ún, ni̱ kundéé‑de, ni̱ ke̱ndava‑de sɨkɨ̱ usiá cha̱a‑ún. Te ni̱ ka̱jinu víchí lɨ́ɨ‑dé ni̱ kenda koyo‑de ini̱ ve̱'e‑ún chi ni̱ katuji̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Te tu̱'un yá'a ni̱ jicha̱ kua'a̱n nɨ́ɨ́ núu̱ ñáyɨvɨ káxiu̱kú iní ñuu̱ Éfeso, kúu ña̱yɨvɨ judío jíín ñáyɨvɨ ñúu̱ Grecia, ni̱ ka̱jini tu̱'un‑i. Te ni̱ kayu̱'ú xaa̱n‑í. Te ni̱ ka̱nakana jaa‑i máá Jíto'o̱‑yo̱ Jesús jíín sɨ́'vɨ́‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Te kua'a̱ ñáyɨvɨ já ní ka̱kandíja, ni̱ ja̱koyo‑i nuu̱ Pablo, ni̱ ka̱nakani ndaa̱‑i kua̱chi‑i jíín tíñu ñáá ni̱ ka̱sá'a‑i. ");
INSERT INTO migNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Te kua'a̱ cháa ja̱ ní ka̱sá'a tiñu ña̱vá'a, ni̱ ja̱koyo‑de kándá'á‑de tutu̱‑de. Te ni̱ ka̱ja'mu‑de tutu̱‑ún jíto nuu̱ táká ña̱yɨvɨ. Te ni̱ ka̱tava‑dé cuenta na̱saa ncháá tutu̱ ni̱ kayu̱‑ún. Te ni̱ kajini̱‑de ja̱ úu̱ xiko uxi̱ mil peso kúu. ");
INSERT INTO migNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Súan ni̱ ndea̱ téyíí tú'un máá Jíto'o̱‑yo̱. Te ni̱ jicha̱ nu̱u kua'a̱n. ");
INSERT INTO migNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Te nuu̱ ní ndɨ'ɨ ta̱ká tiñu yá'a, te ni̱ chaa ini̱ Pablo ja̱ kí'i̱n‑de ñuu̱ Macedonia jíín ñúu̱ Acaya te vásá nájaa̱‑de ñuu̱ Jerusalén. Te ni̱ ka'a̱n‑de: Nú ni̱ ja'a̱n‑ri̱ yúan, yúan‑na te kánúú kí'i̱n‑ri̱ ñuu̱ Roma, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Te ni̱ tájí‑de uu̱ cha̱a káchindéé tá'an jíín‑de kája'a̱n ñuu̱ Macedonia, kákuu Timoteo jíín Erasto. Te ni̱ kanchaa̱ máá‑de ñuu̱ Asia yaku̱‑ga̱ kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Te suu kɨvɨ̱‑ún ni̱ ka̱ndonda xaa̱n ñáyɨvɨ sɨkɨ́ íchi‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Chi ni̱ i̱o ɨɨn cha̱a platero nání Demetrio. Te máá‑de jíín cháa kásátiñu ta'a̱n jíín‑de, xaa̱n ní kani'i̱n‑dé xu̱'ún, chi̱ jíín plata kásá'a‑de ve'e lúlí i'a̱ Diana. ");
INSERT INTO migNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Te cha̱a‑ún, ni̱ ka̱stútú‑de tá'an‑de ja̱ kásá'a suni tiñu‑ún jíín‑de. Te ni̱ ka'a̱n‑de: A kájini̱‑ro̱ já sɨkɨ́ tíñu kásá'a‑yó yá'a káni'i̱n téyíí‑ró xú'ún. ");
INSERT INTO migNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Te kájini̱‑ro̱ te suni kájini tu̱'un‑ró já cháa Pablo yúan, nasu̱ máá ɨ́ɨn ñuu̱ Éfeso chi̱ nɨ́ɨ́‑ni ñuu̱ Asia sásɨ́ɨn‑de ña̱yɨvɨ jíín tú'un ská'a̱n‑de‑i. Chi̱ ká'a̱n‑de ja̱ násu̱ Dios kákuu i'a̱ kásá'a nda'a. ");
INSERT INTO migNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Te yú'ú‑ri̱ ja̱ káni ini̱ ña̱yɨvɨ já tíñu sáni kúu tiñu kásá'a‑yó. Te sanaa te ji̱ta viñu̱'un i'a̱ ñá'nu Diana, te suni sájá'a̱ ini̱‑i nuu̱ Diana luu va̱sa ndivii ñáyɨvɨ ñúu̱ Asia jíín nɨ́ɨ́ ñúyɨ́vɨ káchiñú'ún‑i nuu̱‑yá vina. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Súan ni̱ ka̱jini so̱'o‑de tu̱'un yá'a, te ni̱ kakiti̱ xaa̱n iní‑de. Te ni̱ ka̱kana jíín‑de: Kúñá'nu téyíí Diana i'a̱ ñuu̱ Éfeso, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Te ña̱yɨvɨ ñúu̱‑ún, ni̱ ka̱kuvaa̱‑i. Te ɨɨn ká'nu‑ni ni̱ ka̱ndonda‑i kája'a̱n‑i onde̱ ini̱ teatro káñu'un‑i Gayo jíín Aristarco, cha̱a ñuu̱ Macedonia ja̱ kájika ta'a̱n‑de jíín Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Te kuní Pablo kɨ̱vɨ‑de nuu̱ ká'i̱in tútú ñáyɨvɨ‑ún. Ko ña̱yɨvɨ káskuá'a‑ún, tú ní kája̱'a‑i tu̱'un ki'i̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Te suni sava cha̱a kákuñá'nu ini̱ ñuu̱ Asia, ja̱ kákuu amigo‑de, ni̱ ka̱tájí tú'un kua'a̱n nuu̱‑dé káka'a̱n nda̱'ú jíín‑de ja̱ má kí'i̱n‑de ini̱ teatro. ");
INSERT INTO migNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Te sava ña̱yɨvɨ, ni̱ ka̱kana jaa‑i ɨɨn tu̱'un, te sava‑ga̱‑i ɨnga̱ tu̱'un, chi̱ junta‑ún, ni̱ kasaka̱ nu̱u‑i. Te kua'a̱‑gá‑i, tú kájini̱ kutɨ‑í na̱ sɨkɨ̱ kúu ja̱ ní kataka̱‑i. ");
INSERT INTO migNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Te sava cha̱a judío, ni̱ ka̱chundá'á‑de Alejandro, ni̱ ka̱kiñi'in‑de cha̱a ma̱'ñú ñáyɨvɨ kuá'a̱‑ún. Yúan‑na te Alejandro, sá'a‑de seña jíín ndá'a‑dé ja̱ ná kúná'ín‑i, chi̱ ka'a̱n‑de ja'a̱ judío jíín ñáyɨvɨ kuá'a̱‑ún kuní‑de. ");
INSERT INTO migNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ko ni̱ ka̱nakuni̱‑i‑de ja̱ cháa judío kúu‑de, te yu̱án ní ka̱kana kó'ó‑i nátu̱'un uu̱ hora: Kúñá'nu téyíí Diana i'a̱ ñuu̱ Éfeso, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Yúan‑na te ni̱ ka̱kuná'ín ñáyɨvɨ ní sá'a cha̱a kúu secretario ñuu̱‑ún. Te ni̱ ka'a̱n‑de: Róó ña̱yɨvɨ ñúu̱ Éfeso, a kájini̱ ta̱ká ña̱yɨvɨ já ñúu̱ Éfeso xaa̱n káchiñú'ún‑i i'a̱ Diana jíín ndosó ja̱ ní tájí Júpiter, ni̱ kuun va̱i. ");
INSERT INTO migNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Te tu̱'un yá'a, ta̱ká kájatú'ún‑i. Núsáá te va̱'a‑ga̱ ná kasú‑ro̱ yú'u‑ro te ma̱ sá'a yachi̱‑ro̱ ní ɨɨn tiñu ja̱ tú ní kátava‑ro cuenta. ");
INSERT INTO migNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Chi ni̱ ka̱kinchaka‑ró cháa yá'a onde̱ yá'a va̱sa tú ní kásá'a‑de ni ɨɨn kua̱chi ni tú ní káka'a̱n ndɨva̱'a‑de ni ɨɨn tu̱'un sɨkɨ̱ í'a̱ máá‑yó. ");
INSERT INTO migNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Te Demetrio jíín táká cha̱a kásátiñu ta'a̱n jíín‑de, nú kájaki̱n‑de kua̱chi sɨkɨ̱ ɨ́ɨn cha̱a, íó juzgado ná kí'i̱n‑de. Te íó gobernador, yúan ná kakán‑de kua̱chi sɨkɨ̱ tá'an‑de. ");
INSERT INTO migNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Te nú íó ɨnga̱ tu̱'un kákuni̱‑ro̱, te kuu sándaa̱‑ro̱ ondé nuu̱ ɨ́ɨn junta legal. ");
INSERT INTO migNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Chi̱ yú'ú‑ri̱ ja̱ cháa‑de kua̱chi sɨkɨ̱‑yo̱, kachi̱‑de ja̱ kánakua̱tá'an máá‑yó, chi ma̱ ní'i̱n‑yo̱ tú'un ka'a̱n‑yo̱ naja̱ ní ka̱nataka̱‑yo̱ vína. Achí‑de. Te ni̱ ndɨ'ɨ ni̱ ka'a̱n secretario tu̱'un yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Te ni̱ jacha̱‑de ña̱yɨvɨ‑ún kája'a̱n‑i. ");
INSERT INTO migNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Yúan‑na te ni̱ jukuiñi̱ tɨxɨ̱n‑ún. Te ni̱ kana Pablo xini̱ cháa káskuá'a. Te ni̱ ka'a̱n‑de jíín cháa‑ún ja̱ má yú'ú‑de. Te ni̱ ka̱nanuu tá'an‑de. Te kua'a̱n‑de ñuu̱ Macedonia. ");
INSERT INTO migNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Te ni̱ jika kuu‑de nɨ́ɨ́ táká ndañúu̱‑ún. Te ni̱ ka'a̱n‑de kua'a̱ tú'un ndéé iní jíín táká ña̱yɨvɨ. Te ni̱ jaa̱‑de ñuu̱ Grecia. ");
INSERT INTO migNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Te ni̱ kanchaa̱‑de yúan uni̱ yoo̱. Te a yani ki'i̱n‑de jíín barco onde̱ ñuu̱ Siria núú. Ko cha̱a judío, ni̱ ka̱natɨɨn tu̱'un tá'an ja̱ ndónda sɨkɨ̱‑dé. Ja̱ yúán ní nakani ini̱‑de te ñu'íchí ní ja'a̱n‑de ñuu̱ Macedonia. ");
INSERT INTO migNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Te ni̱ ka'i̱o sava cha̱a ni̱ kaja'a̱n jíín Pablo onde̱ ñuu̱ Asia. Te káinání‑de Sópater ñuu̱ Berea, Aristarco jíín Segundo onde̱ ñuu̱ Tesalónica, Gayo ñuu̱ Derbe, Timoteo, Tíquico jíín Trófimo onde̱ ñuu̱ Asia. ");
INSERT INTO migNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Cha̱a yá'a, ni̱ ka̱yoxnúú‑de. Te ka̱inda̱tu‑de ruu̱ jíná'an‑ri̱ onde̱ ñuu̱ Troas. ");
INSERT INTO migNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Te ruu̱ jíná'an‑ri̱, nuu̱ ní ja̱'a viko státilá tú yí'i yujan íá, te jíín barco ni̱ kenda koyo‑ri̱ ñuu̱ Filipos. Te nuu̱ ú'u̱n kɨvɨ̱ ní ka̱naketá'an‑ri̱ jíín‑de onde̱ ñuu̱ Troas. Te ñuu̱ yúan ni̱ kaxiu̱kú‑rí ɨɨn semana. ");
INSERT INTO migNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Te máá kɨvɨ́ ɨ́ɨn semana, ni̱ ka̱ndutútú cháa káskuá'a‑ún ja̱ sákuáchí‑de sta̱tilá. Te ni̱ stá'a̱n Pablo tu̱'un nuu̱ cháa‑ún, chi̱ kenda‑de kɨvɨ̱ xía̱n‑ún. Te káni ní ka'a̱n‑de onde̱ sava ñúú. ");
INSERT INTO migNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Te ni̱ i̱o kua'a̱ lámpara ini̱ ve̱'e súkún núu̱ ní ká'i̱in tútú‑de yúan. ");
INSERT INTO migNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Te ɨɨn cha̱a súchí nání‑i Eutico, kánchaa̱‑i máá yú'u ventana. Te nini ni̱ kuná'án ká'a̱n Pablo, jí'i̱ xaa̱n‑í numa̱'ná. Te ni̱ kixi̱‑ni‑i. Te ni̱ jungava‑ni‑i onde̱ piso uni̱ te onde̱ nuu̱ ñú'un. Te a ni̱ ji'i̱‑i ni̱ ka̱ndukani‑de‑i. ");
INSERT INTO migNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Yúan‑na te ni̱ nuu Pablo. Te ni̱ jito nuu‑de nuu̱‑í. Te ni̱ junu nchaa̱‑de‑i. Te ni̱ ka'a̱n‑de: Ma̱ yú'ú‑ro̱ jíná'an‑ró, chi̱ chakú‑i, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Te ni̱ ndaa‑de. Te ni̱ sákuáchí‑de sta̱tilá. Te ni̱ yee‑dé. Te ni̱ ka'a̱n ná'án‑ga̱‑de onde̱ kua̱kundiji̱n. Yúan‑na te ni̱ kee‑de kua'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Te káno'o̱n ña̱yɨvɨ jíín súchí‑ún chakú‑i. Te kákusɨɨ̱ xáa̱n iní‑i. ");
INSERT INTO migNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Te ruu̱, ni̱ ka̱koyo‑ri̱ ini̱ barco te kája'a̱n‑ri̱ jíín ondé ñuu̱ Asón, yúan naketá'an‑ri̱ jíín Pablo. Chi̱ súan ni̱ sándaa̱‑de ja̱ kí'i̱n‑de ñu'un íchí te jaa̱‑de yúan. ");
INSERT INTO migNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Te ni̱ ka̱nani'i̱n tá'an‑ri̱ jíín‑de ini̱ ñuu̱ Asón. Te ni̱ kaa‑de barco. Te kua'a̱n‑de jíín‑rí ñuu̱ Mitilene. ");
INSERT INTO migNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Yúan ni̱ ka̱kenda‑ri̱ jíín barco. Te ɨnga̱ kɨvɨ̱ ní ja̱koyo‑ri̱ ñuu̱ Quío, te ɨnga̱ kɨvɨ̱ ní ja̱koyo‑ri̱ ñuu̱ Samos. Te ni̱ ka̱kendo̱o‑ri̱ ñuu̱ Trogilio. Te ɨnga̱ kɨvɨ̱ ní ja̱koyo‑ri̱ ñuu̱ Mileto. ");
INSERT INTO migNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Chi̱ jáni ini̱ Pablo ja̱ já'a‑ni‑de ki'i̱n‑de ñuu̱ Éfeso náva̱'a ma̱ kúkuéé‑de ñuu̱ Asia te naa tiempo núú. Chi̱ jítú iní‑de jaa̱ yachi̱‑de ñuu̱ Jerusalén máá kɨvɨ́ Pentecostés nú ná kúni̱'in‑de. ");
INSERT INTO migNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Te kánchaa̱‑de ñuu̱ Mileto. Te ni̱ tájí‑de tu̱'un kua'a̱n onde̱ ñuu̱ Éfeso ni̱ kana‑de xini̱ cháa kákuu nuu̱ iní tɨku'ni̱ kándíja. ");
INSERT INTO migNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Te nuu̱ ní cha̱koyo cha̱a‑ún nuu̱‑dé, te ni̱ kachi̱‑de: Máá‑ró kájini̱ va̱'a‑ró ndasa ni̱ ji̱ku‑ri̱ jíín‑ró ondé kɨvɨ̱ ní chaa̱ núú‑rí ñuu̱ Asia. ");
INSERT INTO migNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Te tú ní sávixi̱‑ri̱ máá‑rí kɨvɨ̱ ní jatíñu‑ri̱ nuu̱ máá Jíto'o̱‑yo̱. Te íó hora ni̱ nde'e̱‑ri̱. Te kua̱chi ña̱yɨvɨ judío, ja̱ ní ka̱natɨɨn tu̱'un tá'an‑i te ni̱ kii tu̱ndó'o sɨkɨ̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Te tú ní yú'ú‑ri̱ kani‑ri̱ tu̱'un nuu̱‑ro̱ já kuátíñu va̱'a‑ró, ni tú ní yú'ú‑ri̱ stá'a̱n‑ri̱ tu̱'un nuu̱‑ro̱, va̱sa nu̱yá'u xí iní ve̱'e‑ró. ");
INSERT INTO migNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Te ni̱ jani ndaa̱‑ri̱ tu̱'un nuu̱ ñáyɨvɨ judío jíín núu̱ ñáyɨvɨ sɨ́ɨn nación ja̱ ná nákani ini̱‑i kuandatu̱‑i nuu̱ Dios. Te ná kándíja‑i nuu̱ máá Jíto'o̱‑yo̱ Jesucristo. ");
INSERT INTO migNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Te vina cháa téyíí iní‑ri̱ te ja̱ yúán ñú'un íchí‑rí ki'i̱n‑ri̱ ñuu̱ Jerusalén. Ko tú jiní‑ri̱ na̱ún ta'a̱n‑ri̱ yúan. ");
INSERT INTO migNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ko ndɨta'a̱n ñuu̱ já'a̱n‑ri̱ chi̱ ká'a̱n Espíritu Santo jíín‑rí ja̱ chíndee‑i ruu̱ veka̱a te kii tu̱ndó'o sɨkɨ̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Te ni tú sá'a‑ri̱ cuenta va̱sa ná ká'ni‑í ruu̱, chi ja̱ ná síjínu‑ri̱ tiñu ni̱ ja̱'a máá Jíto'o̱‑yo̱ Jesús nuu̱‑rí kúu ja̱ kánúú jáni ini̱‑ri̱, jíín súni ja̱ kúsɨɨ̱ iní‑ri̱ kani‑ri̱ tu̱'un va̱'a tu̱'un luu Dios. ");
INSERT INTO migNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Te ma̱'ñú táká róó ja̱ á ni̱ jika kuu‑ri̱ ni̱ jani‑ri̱ tu̱'un ndasa koo ñuu̱ nuu̱ tá'ú Dios tiñu, te vina a jiní‑ri̱ ja̱ ní ɨɨn‑ró ma̱ kuní kutɨ‑gá‑ro̱ núu̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ja̱ yúán kástu̱'ún kájí‑rí nuu̱‑ro̱ jíná'an‑ró vína, ja̱ tú tau̱ ya̱'u‑ri̱ nɨñi̱‑ró. ");
INSERT INTO migNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Chi̱ tú ní yú'ú‑ri̱ kani‑ri̱ ndivii tú'un Dios nuu̱‑ro̱. ");
INSERT INTO migNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Núsáá te koto va̱'a‑ró máá‑ró jíín nɨ́ɨ́ tɨ́ku'ni̱, chi̱ Espíritu Santo ni̱ jani‑ya̱ róó ja̱ kúndito‑ró‑i te skée‑ro tɨ́ku'ni̱ máá Jíto'o̱‑yo̱, chi ni̱ nakuaan‑ya̱‑í jíín nɨñí‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Chi̱ jiní‑ri̱ ja̱ nú ná kí'i̱n‑ri̱, te kɨ̱vɨ koyo yi'ɨ̱ kɨtɨ xáa̱n má'ñú‑ró te ma̱ kúndá'ú ini̱‑tɨ̱ tɨ́ku'ni̱. ");
INSERT INTO migNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Te suni onde̱ nuu̱ tá'an máá‑ró kénda sava‑de ka'a̱n‑de tu̱'un tú'ún náva̱'a xndá'ú‑de ña̱yɨvɨ káskuá'a ki'i̱n‑i jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Koo ndito ini̱‑ro̱ jíná'an‑ró núsáá. Te ma̱ náa iní‑ro̱ já uní kuia̱ ndúú ñúú‑ni tú ní júkuiñi̱‑ri̱ ja̱ kána jíín‑rí nuu̱ ɨ́ɨn ɨɨn‑ró va̱sa ni̱ nde'e̱‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Te vina ñáni̱, jikán ta'u̱‑rí nuu̱ Dios ja'a̱ máá‑ró ja̱ ná kuá'a‑ya̱ tú'un luu‑ya̱ núu̱‑ro̱. Chi tu̱'un‑ún kuu skuá'nu róó te ni'i̱n‑ro̱ tá'u̱ jíín táká‑ga̱ ña̱yɨvɨ ní sásɨ́ɨn‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Tú ní ndío ini̱‑ri̱ ni plata ni oro ni sa'ma ɨ́ɨn ña̱yɨvɨ. ");
INSERT INTO migNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","A kájini̱ va̱'a‑ró já ndéndúú nda'a‑rí yá'a, ni̱ ndúkú táká ja̱ jínu ñú'ún‑rí jíín cháa káxiu̱kú jíín‑rí yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Te modo ni̱ stá'a̱n ndɨ'ɨ‑ri̱ nuu̱‑ro̱ já kánúú sátiñu‑yó súan, náva̱'a chindéé tá'an‑yó jíín táká cha̱a vi̱tá káku'u̱. Te ma̱ náa iní‑ro̱ tú'un máá Jíto'o̱‑yo̱ Jesús, chi̱ súan ni̱ ka'a̱n‑ya̱: Luu‑ga̱ ja̱ kuá'a‑yó ɨ́ɨn ndatíñu nasu̱ já ní'i̱n‑yo̱. Achí‑ya̱. Achí Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Te nuu̱ ní ndɨ'ɨ ni̱ ka'a̱n‑de ta̱ká tu̱'un yá'a, te ni̱ jukuiñi̱ jítɨ́‑de. Te ni̱ jika̱n ta'u̱‑dé jíín táká cha̱a‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Yúan‑na te xaa̱n ní kande'e̱ ta̱ká‑de. Te ni̱ ka̱kanuu‑de Pablo, te ni̱ ka̱titú‑de cha̱a. ");
INSERT INTO migNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Chi̱ kákukuí'a̱ xaa̱n iní‑de jíín tú'un ni̱ ka'a̱n Pablo ja̱ má kuní‑ga̱‑de nuu̱‑dé. Te kája'a̱n‑de jíín‑de onde̱ nuu̱ íó barco. ");
INSERT INTO migNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Yúan‑na te ni̱ ka̱kusɨ́ɨn‑ri̱ jíín‑de. Te ni̱ ka̱ki'in ndóó‑ni‑ri̱ ichi jíín barco onde̱ ni̱ chaa̱‑ri̱ ñuu̱ Cos. Te ɨnga̱ kɨvɨ̱ ní ja̱koyo‑ri̱ ñuu̱ Rodas. Te yúan ni̱ kenda‑ri̱ te ni̱ ja̱koyo‑ri̱ ñuu̱ Pátara. ");
INSERT INTO migNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Te ni̱ kani'i̱n‑rí ɨɨn barco ja̱ kí'i̱n ñuu̱ Fenicia. Te ni̱ ka̱kaa‑ri̱ nuu̱ te kája'a̱n‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Te nuu̱ ní kajini̱‑ri̱ nuu̱ ñúu̱ Chipre, te ni̱ ka̱skéndo̱o‑ri̱ ñuu̱‑ún ichi ndávésé‑rí. Te ni̱ ka̱jika‑ri̱ kája'a̱n‑ri̱ jíín barco onde̱ ñuu̱ Siria. Te ni̱ ja̱koyo‑ri̱ ñuu̱ Tiro, chi̱ yúan skéndo̱o barco‑ún carga. ");
INSERT INTO migNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Te ni̱ ka̱kendo̱o‑ri̱ yúan ɨɨn semana, chi ni̱ kani'i̱n tá'an‑ri̱ jíín ñáyɨvɨ káskuá'a. Te ni̱ kaka'a̱n‑i jíín Pablo ni̱ sá'a Espíritu ja̱ má kí'i̱n‑de ñuu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ko nuu̱ ní ja̱'a kɨvɨ̱‑ún, te ni̱ kenda koyo‑ri̱. Te ta̱ká‑i jíín ñásɨ́'ɨ́‑i jíín sé'e‑i, ni̱ kaja̱chu'un íchí‑i ruu̱ onde̱ yata̱ ñúu̱‑ún. Te ni̱ ka̱jukuiñi̱ jítɨ́‑rí jíín‑i yu'u mar. Te ni̱ kajika̱n ta'u̱‑rí. ");
INSERT INTO migNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Te ni̱ ka̱nanuu tá'an‑ri̱ yúan. Te ni̱ ka̱kaa‑ri̱ nuu̱ barco kája'a̱n‑ri̱. Te ni̱ ka̱naxíó káva‑i káno'o̱n‑i ve'e‑i. ");
INSERT INTO migNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Te ruu̱ jíná'an‑ri̱, ni̱ kenda koyo‑ri̱ ñuu̱ Tiro ni̱ ka̱jika‑ri̱ jíín barco. Te ni̱ ja̱koyo‑ri̱ ñuu̱ Tolemaida. Te yúan ni̱ kaka'a̱n‑ri̱ jíín táká ñani̱. Te ni̱ ka̱kendo̱o‑ri̱ jíín‑de ɨɨn kɨvɨ̱. ");
INSERT INTO migNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Te ɨnga̱ kɨvɨ̱‑ún ni̱ kenda Pablo jíín táká‑ga̱‑ri̱ ja̱ ká'i̱in‑ri̱ jíín‑de. Te ni̱ cha̱koyo‑ri̱ ñuu̱ Cesarea. Te ni̱ kɨ̱vɨ koyo‑ri̱ ini̱ ve̱'e ɨɨn cha̱a jáni tu̱'un nání‑de Felipe. Cha̱a‑ún kúu ɨɨn cha̱a ndɨ́'usiá. Te ni̱ ka̱kendo̱o‑ri̱ jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Te cha̱a‑ún, íó kuu̱n sésɨ́'ɨ́ súchí‑de kájani‑i tu̱'un Dios. ");
INSERT INTO migNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Te ni̱ kaxiu̱kú‑rí yúan kua'a̱ kɨvɨ́. Te ichi ñúu̱ Judea ni̱ kii ɨɨn cha̱a jáni tu̱'un Dios, nání‑de Ágabo. ");
INSERT INTO migNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Te ni̱ chaa̱‑de nuu̱‑rí. Te ni̱ ki'in‑de sánchi̱i Pablo. Te ni̱ ju'ni̱‑de nda'a jíín sɨ́'ɨn Pablo. Te ni̱ ka'a̱n‑de: Súan ká'a̱n Espíritu Santo: Ña̱yɨvɨ judío, súan ku'ni̱‑i cha̱a xíin sánchi̱i yá'a, te nú ná jáa̱‑de ñuu̱ Jerusalén. Te nastúu‑i‑de nuu̱ ñáyɨvɨ sɨ́ɨn nación. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tu̱'un‑ún ni̱ ka̱jini so̱'o‑ri̱. Te ruu̱ jíín cháa ká'i̱in yúan, ni̱ kaka'a̱n nda̱'ú‑ri̱ jíín Pablo ja̱ má káa‑de ki'i̱n‑de ñuu̱ Jerusalén. ");
INSERT INTO migNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Yúan‑na te ni̱ ka'a̱n Pablo: Naja̱ kánda'i̱‑ro̱ te ndúkuí'a̱ ini̱ añú‑ri̱ kásá'a‑ró. Chi̱ ruu̱, a íó tu̱'a‑ri̱ ja̱ násu̱ máá ɨ́ɨn ja̱ kúnu'ni̱‑ri̱ ini̱ ñuu̱ Jerusalén, chi̱ suni ja̱ kúu̱‑ri̱ yúan ja̱ sɨkɨ́ sɨ́'vɨ́ máá Jíto'o̱‑yo̱ Jesús, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Te tú ní kúu ská'a̱n‑ri̱‑de. Te ni̱ ka̱sía̱‑ni‑ri̱‑de. Te ni̱ kaka'a̱n‑ri̱: Ná kóo ndasa játa'a̱n ini̱ máá Jíto'o̱‑yo̱, áchí‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Yúan‑na te vásá ní ka̱sátu̱'a‑ri̱ ta̱ká ndatíñu‑ri̱. Te ni̱ ka̱kaa‑ri̱ ñuu̱ Jerusalén kája'a̱n‑ri̱. ");
INSERT INTO migNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Te suni kája'a̱n yaku̱ cha̱a káskuá'a ini̱ ñuu̱ Cesarea jíín‑rí, ncháka‑de ɨɨn cha̱a ñuu̱ Chipre nání‑de Mnasón. Cha̱a ni̱ skuá'a aná'án kúu‑de. Te ni̱ ka̱kendo̱o‑ri̱ ve'e cha̱a‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Te nuu̱ ní ja̱koyo‑ri̱ ñuu̱ Jerusalén, te ñani̱‑yo̱‑ún, ni̱ ka̱kusɨɨ̱ xáa̱n iní‑de ni̱ ka̱jatá'ú‑de ruu̱. ");
INSERT INTO migNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Te ɨnga̱ kɨvɨ̱ xía̱n‑ún ni̱ kɨ̱vɨ Pablo jíín‑rí jíná'an‑ri̱ ini̱ ve̱'e Jacobo. Te yúan ni̱ ka̱kutútú táká cha̱a kákuu nuu̱. ");
INSERT INTO migNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Te Pablo ni̱ sá'a‑de saludar cha̱a‑ún. Yúan‑na te ni̱ jani‑de tu̱'un ta̱ká tiñu ni̱ sá'a Dios jíín ñáyɨvɨ sɨ́ɨn nación nini játíñu‑de nuu̱‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Te ni̱ ka̱jini so̱'o‑de tu̱'un yá'a. Te ni̱ ka̱nakana jaa‑de Dios. Te ni̱ kaka'a̱n‑de jíín Pablo: Ñáni̱, vina te ni̱ jini̱‑ro̱ ná kua'a̱ mil ña̱yɨvɨ judío ni̱ ka̱kandíja‑i. Te nene̱ kájandatu̱ ni̱'in‑i nuu̱ ley. ");
INSERT INTO migNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ko ni̱ ka̱jini tu̱'un‑de ja̱ stá'a̱n‑ro̱ núu̱ táká cha̱a judío káxiu̱kú iní ñuu̱ ña̱yɨvɨ sɨ́ɨn nación ja̱ má kuándatu̱‑ga̱‑de nuu̱ Moisés, ni ma̱ xɨtɨ́ ndúu̱‑ga̱ se̱'e‑de, ni ma̱ kuándatu̱‑de tani̱nu aná'án. ");
INSERT INTO migNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ndasa kuu núsáá, chi̱ kuni tu̱'un ña̱yɨvɨ já ní chaa̱‑ro̱, te taka̱ kua'a̱ ndíja‑i. ");
INSERT INTO migNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Sá'a ja̱ káka'a̱n‑ri̱ jíín‑ró yá'a núsáá: A ká'i̱o kuu̱n cháa yá'a ja̱ á ni̱ ka̱keyu'u‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kuaka cha̱a yá'a ná kí'i̱n‑de jíín‑ró. Te nasándoo‑ró máá‑ró jíín‑de. Te kua̱'a‑ró xú'ún núu̱‑dé náva̱'a ná sété‑de xini̱‑dé. Yúan‑na te juku̱'un ini̱ ta̱ká ña̱yɨvɨ‑ún ja̱ tú kutɨ‑gá na̱ún íó ja̱ ní kanda̱tu̱'ún‑i sɨkɨ̱‑ro̱, chi̱ kundaa̱ ini̱‑i ja̱ súni jándatu̱ máá‑ró núu̱ ley. ");
INSERT INTO migNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ko ña̱yɨvɨ sɨ́ɨn nación ja̱ kákandíja‑ún, a ni̱ ka̱chaa‑ri̱ carta kua'a̱n nuu̱‑í ja̱ má kuándatu̱‑i ni ɨɨn tu̱'un yúan. Te ma̱ kée‑í ku̱ñu ja̱ ní soko̱ núu̱ ndosó, ni nɨñi̱, ni kɨtɨ kuá'ñá. Te ma̱ káka téné‑i. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Yúan‑na te Pablo, ni̱ jaka‑de cha̱a‑ún. Te ɨnga̱ kɨvɨ̱ xía̱n‑ún, ni̱ nasándoo‑de máá‑de jíín‑de. Te ni̱ kɨ̱vɨ‑de ini̱ ve̱'e ii̱ ja̱ kástu̱'ún‑de nuu̱‑í na̱ kɨvɨ̱ jínu kándundoo‑de te soko̱‑dé kɨtɨ núu̱‑yá sɨkɨ̱ ɨ́ɨn ɨɨn‑de núú. ");
INSERT INTO migNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Te kákuu‑de ja̱ síjínu‑de ndɨ́'usiá kɨvɨ̱‑ún núú. Ko sava judío ñuu̱ Asia, ni̱ kajini̱ nuu̱ Pablo kándee‑de ini̱ ve̱'e ii̱. Te ni̱ ka̱ská'a̱n ndɨ'ɨ ña̱yɨvɨ yúan. Te ni̱ ka̱katɨɨn Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Te ni̱ ka̱kana jaa: Cha̱a Israel, kua̱'a núu nda'a jíná'an‑ró, chi cha̱a yá'a jíka kuu‑de ta̱ká ñuu̱, stá'a̱n‑de nuu̱ táká cha̱a te ká'a̱n‑de sɨkɨ̱ ñáyɨvɨ‑yo, jíín sɨkɨ́ ley, jíín sɨkɨ́ lugar yá'a. Te suni a ni̱ skɨ́vɨ‑de sava cha̱a sɨ́ɨn nación ini̱ ve̱'e ii̱ yá'a te ni̱ sáchá'án‑de ve'e ii̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Chi̱ onde̱ ná kándee Pablo iní ñuu̱‑ún ni̱ kajini̱ judío ja̱ kándee‑de jíín Trófimo, cha̱a ñuu̱ Éfeso. Te ni̱ ka̱jani ini̱ ja̱ ní skɨ́vɨ Pablo cha̱a‑ún ini̱ ve̱'e ii̱. ");
INSERT INTO migNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Te nɨ́ɨ́‑ni ñuu̱‑ún ni̱ ka̱ndonda‑i. Te ni̱ kataka̱‑i. Te ni̱ ka̱katɨɨn‑i Pablo. Te ni̱ ka̱stáa‑i‑de ni̱ kenda‑de yata̱ vé'e ii̱‑ún. Te ni̱ ka̱nakasu̱‑ni‑i yuxé'é. ");
INSERT INTO migNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Te kája'ni‑í Pablo núú. Ko ni̱ ja'a̱n tu̱'un yá'a nuu̱ general cha̱a tɨ́ɨn soldado ja̱ nɨ́ɨ́ ñúu̱ Jerusalén ni̱ ka̱ndonda‑i kákuvaa̱‑i. ");
INSERT INTO migNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Te cha̱a general, ni̱ jaka‑de soldado jíín capitán. Te kájinu‑de kája'a̱n‑de onde̱ nuu̱ ká'i̱in ña̱yɨvɨ kuá'a̱‑ún. Te ni̱ kajini̱ ña̱yɨvɨ já ní ja̱koyo general jíín soldado, te ni̱ ka̱jukuiñi̱‑i ja̱ kája̱'a‑i Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Yúan‑na te ni̱ jaa̱ general te ni̱ tɨɨn‑de Pablo. Te ni̱ tá'ú‑de tiñu ni̱ ja̱kunu'ni̱ Pablo jíín úu̱ cadena. Yúan‑na te ni̱ jika̱ tu̱'ún ndé cha̱a kúu‑de te na̱ún ní sá'a‑de. ");
INSERT INTO migNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Te ña̱yɨvɨ kuá'a̱‑ún, sava‑i ni̱ ka̱kana‑i ɨɨn tu̱'un te sava‑ga̱‑i ɨnga̱. Te tú ní kúndaa̱ ini̱‑de na̱ún sɨkɨ̱ kúu ja̱ súan kákuvaa̱‑i. Te ni̱ tá'ú‑de tiñu kua'a̱n Pablo cuartel. ");
INSERT INTO migNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Te nuu̱ ní jaa̱ Pablo escalera ve'e‑ún, te soldado ni̱ kandi̱so Pablo, chi̱ xaa̱n ní ka̱ndonda ña̱yɨvɨ kuá'a̱. ");
INSERT INTO migNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Chi̱ kua'a̱ ñáyɨvɨ vái koyo‑i ichi yatá soldado, te kákana jaa‑i: Ka'ni‑ní cha̱a jia̱n, áchí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Te káskɨ́vɨ‑de Pablo ini̱ veka̱a, te ni̱ ka'a̱n Pablo jíín general: Á kuu ka'a̱n‑ná ɨɨn tu̱'un jíín‑ní, áchí‑de. Te ni̱ kachi̱ general jíín‑de: Jiní‑ro̱ ká'a̱n‑ro̱ yú'u ñúu̱ Grecia náún. ");
INSERT INTO migNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nasu̱ róó kúu máá cháa ñuu̱ Egipto ja̱ íku ñuu̱ ni̱ xndónda‑ró‑i ni̱ ka̱nakua̱tá'an máá‑i, te suni ni̱ kiñi'in‑ró kúu̱n mil cha̱a kuí'ná kája'a̱n‑de jíín‑ró ondé nuu̱ ñú'un té'é náún. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Yúan‑na te ni̱ kachi̱ Pablo: Máá‑ná kúu ndija cha̱a judío, te ɨɨn se̱'e ñuu̱ Tarso, ɨɨn ñuu̱ ká'nu ndañúu̱ Cilicia. Te ká'a̱n nda̱'ú‑ná jíín‑ní kua̱'a‑ní tu̱'un ná ká'a̱n‑ná jíín ñáyɨvɨ yá'a. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Te general, ni̱ ja̱'a‑de tu̱'un. Te ni̱ jukuiñi̱ Pablo nuu̱ escalera. Te ni̱ sá'a‑de señal jíín ndá'a‑dé nuu̱ ñáyɨvɨ‑ún. Te ná'ín yúú‑ni ni̱ ka̱kuu‑i. Yúan‑na te jíín yú'u hebreo ni̱ ka'a̱n‑de: ");
INSERT INTO migNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ñáni̱ jíná'an‑ní, jíín táká níí cha̱a kákuu táa̱, kuni so̱'o‑ní tu̱'un ká'a̱n‑ná ja'a̱ máá‑ná jíín‑ní vina, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Te ni̱ ka̱jini so̱'o‑i ja̱ ká'a̱n Pablo tu̱'un jíín yú'u hebreo, te ví'í‑gá ni̱ ka̱kuná'ín‑i. Te ni̱ ka'a̱n Pablo: ");
INSERT INTO migNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Máá‑ná kúu cha̱a judío, ni̱ kaku ndija‑ná ini̱ ñuu̱ Tarso ndañúu̱ Cilicia. Ko ni̱ ja'nu‑ná ini̱ ñuu̱ yá'a. Te escuela Gamaliel ni̱ kutu̱'a va̱'a‑ná ni̱ stá'a̱n‑de tu̱'un ni̱'in ley ñuu̱‑yo̱ núu̱‑ná. Te káchiñú'ún vá'a‑ná nuu̱ Dios nátu̱'un kásá'a máá‑ní vina. ");
INSERT INTO migNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Te ni̱ chindiki̱n‑ná ña̱yɨvɨ kákandíja tu̱'un yá'a onde̱ ná ndɨ'ɨ‑i kuu̱. Te kúu cha̱a kúu ña'an, ni̱ ka̱tɨɨn‑ná‑i ni̱ chindee‑ná‑i veka̱a. ");
INSERT INTO migNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Te sutu̱ ñá'nu jíín táká cha̱a kákuu nuu̱, ni̱ kajini̱‑de ja̱ súan ni̱ sá'a‑ná. Te suni cha̱a‑ún, ni̱ ka̱chaa‑de tutu̱ nuu̱ táká ñani̱. Te ni̱ kaja̱'a‑de tutu̱‑ún nuu̱‑ná ni̱ ja'a̱n‑ná onde̱ ñuu̱ Damasco ja̱ kuáku'ni̱‑ná ña̱yɨvɨ káxiu̱kú yúan. Te kinanchaka‑ná‑i onde̱ ñuu̱ Jerusalén te ndo'o‑i yá'a núú. ");
INSERT INTO migNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Te ni̱ ki'in‑ná ichi kua'a̱n‑ná. Te ni̱ kuyani‑ná yuñúu̱ Damasco nátu̱'un ka̱xiuu̱ kúu. Te ni̱ ndii ncháa̱‑ni nuu̱‑ná ni̱ jinu̱ ɨɨn ndua ndíi ní kii ichi ándɨ́vɨ. ");
INSERT INTO migNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Te ni̱ ndua̱‑ni‑ná nuu̱ ñú'un. Te ni̱ jini so̱'o‑ná ká'a̱n ɨɨn tu̱'un jíín‑ná: Saulo, Saulo, naja̱ chíndiki̱n‑ro̱ rúu̱, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Yúan‑na te ni̱ ka'a̱n‑ná: Ndé cha̱a kúu‑ní vii, Táta̱, áchí‑ná. Te ni̱ ka'a̱n‑ya̱ jíín‑ná: Máá‑rí kúu Jesús ñuu̱ Nazaret ja̱ chíndiki̱n‑ro̱ rúu̱, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Te cha̱a kája'a̱n jíín‑ná, ni̱ kajini̱ ndija‑de ndua ndíi‑ún, te ni̱ kayu̱'ú‑de, ko tú ní kájini so̱'o‑de tu̱'un ni̱ ka'a̱n‑ya̱ jíín‑ná. ");
INSERT INTO migNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Yúan‑na te ni̱ ka'a̱n‑ná: Táta̱, te na̱ún sá'a‑ná, áchí‑ná. Te ni̱ kachi̱ máá Jíto'o̱‑ná jíín‑ná: Nduko̱o te ki'i̱n‑ro̱ ñúu̱ Damasco. Te yúan ta'u̱ tíñu nuu̱‑ro̱ ndasa sá'a‑ró, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Te tú ní jiní‑ná nuu̱ ní ɨɨn, chi̱ ndíi ncháa̱ ndua ndíi‑ún. Te cha̱a kája'a̱n jíín‑ná, kátɨ̱ɨn‑na̱‑de nda'a‑ná kua'a̱n‑ná jíín‑de onde̱ ñuu̱ Damasco. ");
INSERT INTO migNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Te yúan kánchaa̱ ɨɨn cha̱a nání Ananías. Te ta̱ká ña̱yɨvɨ judío yúan káka'a̱n ja̱ cháa va̱'a kúu Ananías, chi va̱'a jándatu̱‑de nuu̱ ley. ");
INSERT INTO migNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Te ni̱ jaa̱ cha̱a‑ún te ni̱ kandita‑de nuu̱‑ná. Te ni̱ ka'a̱n‑de jíín‑ná: Ñáni̱ Saulo, ná ndúndiji̱n nuu̱‑ro̱, áchí‑de. Te ni̱ jini̱‑ni‑ná nuu̱‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Te ni̱ kachi̱‑de: Máá Dios ndɨ̱yi táa̱‑yo̱, ni̱ jani‑ya̱ róó vina ja̱ ná júku̱'un ini̱‑ro̱ tú'un kuní‑ya̱. Te kuni̱‑ro̱ núu̱ máá I'a̱ ndaa̱, te kuni so̱'o‑ró tú'un ka'a̱n‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Te kuu‑ró testigo máá‑yá nuu̱ ndívii ñáyɨvɨ táká ja̱ ní jini̱‑ro̱ jíín já ní jini so̱'o‑ró. ");
INSERT INTO migNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ma̱ kúu uun ini̱‑ro̱ vína núsáá. Ndukuiñi̱ te kuanducha‑ro. Te kaka̱n ta'u̱‑ro̱ núu̱‑yá. Achí‑de jíín‑ná. ");
INSERT INTO migNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Te ni̱ naxíó káva‑ná ni̱ nchaa̱‑ná ñuu̱ Jerusalén. Te jikán ta'u̱‑ná ini̱ ve̱'e ii̱, te ni̱ skóto‑ya̱ náá. ");
INSERT INTO migNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Te ni̱ jini̱‑ná nuu̱‑yá ni̱ ka'a̱n‑ya̱ jíín‑ná: Ndúkú ndéé‑ró te kenda yachi̱‑ro̱ iní ñuu̱ Jerusalén yá'a, chi ma̱ kuátú'ún‑i tu̱'un‑ri̱ jáni ndaa̱‑ro̱ núu̱‑í, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Te ni̱ ka'a̱n‑ná jíín‑yá: Táta̱, a kájini̱‑i ja̱ ní kɨ̱vɨ‑ná ndɨ́ta'a̱n ve'e sinagoga ni̱ jatɨ̱ɨn‑ná ta̱ká ña̱yɨvɨ kákandíja nuu̱‑ní. Te ni̱ stují‑ná‑i ni̱ taan‑ná‑i veka̱a. ");
INSERT INTO migNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Te kɨvɨ̱ ní jicha̱ nɨñi̱ Esteban, cha̱a ni̱ jani ndaa̱ tu̱'un‑ní, suni kándii̱‑ná yúan sáá. Te ni̱ jatú'ún‑ná ja̱ ní ji'i̱‑de. Te ni̱ ndi̱to‑ná sa'ma cháa ni̱ ka̱ja'ni Esteban. Achí‑ná jíín‑yá. ");
INSERT INTO migNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Te ni̱ kachi̱‑ya̱ jíín‑ná: Kuá'án, chi̱ tájí máá‑rí róó ki'i̱n jíká‑ró ondé nuu̱ ñáyɨvɨ sɨ́ɨn nación, áchí‑ya̱ jíín‑ná. Achí Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Te a ni̱ ka̱jini ná'ín‑i onde̱ ni̱ ka'a̱n‑de tu̱'un yá'a. Yúan‑na te ni̱ ka̱kuvaa̱‑i. Te ni̱ kaka'a̱n jaa‑i: Ná kúxio cha̱a jia̱n ná kúu̱‑de. Tú va̱'a cha̱a kúu‑de ja̱ kúchaku̱‑ga̱‑de ñu̱yɨ́vɨ yá'a. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Te súan kákana kó'ó‑i. Te ni̱ ka̱skée‑i tɨka̱chí‑i kája'a̱n. Te ni̱ ka̱skánda‑i tɨkacha̱ ñú'un. ");
INSERT INTO migNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Te ni̱ tá'ú tíñu general ná kɨ́vɨ Pablo ini̱ cuartel. Te ni̱ ka'a̱n‑de ja̱ ná xndichí soldado Pablo onde̱ jíín cuarta náva̱'a kutuní ini̱ general na̱ sɨkɨ̱ ní ka̱ndonda ña̱yɨvɨ‑ún sɨkɨ̱ Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Te ni̱ kaju'ni̱‑de Pablo jíín yó'o ñíi. Te ni̱ ka'a̱n Pablo jíín cháa kúu capitán ja̱ kándii̱‑de yúan: Á íó ley kua̱'a‑ní cuarta ɨɨn cha̱a ñuu̱ Roma ja̱ té chá'a̱n‑ga̱ ndúkú víi‑ní kua̱chi‑de, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Te ni̱ jini so̱'o capitán tu̱'un yá'a, te ni̱ kee kua'a̱n. Te ni̱ ka'a̱n jíín general: Ndasa sá'a‑ní, chi cha̱a ñuu̱ Roma kúu cha̱a yá'a, áchí. ");
INSERT INTO migNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Yúan‑na te ni̱ jaa̱ general nuu̱ Pablo. Te ni̱ jika̱ tu̱'ún‑de: Kachi̱ nú suu cha̱a ñuu̱ Roma kúu‑ró, áchí. Te ni̱ ka'a̱n Pablo: Jaa̱n, suu máá‑ná kúu, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Te ni̱ ka'a̱n general: Ruu̱, chi ni̱ ja̱'a‑ri̱ kua'a̱ xú'ún, te ni̱ kaja̱'a‑de tu̱'un kuu‑ri̱ ɨɨn cha̱a ñuu̱ yúan, áchí. Te ni̱ ka'a̱n Pablo: Ko náá, chi̱ túu. Chi̱ ini̱ ñuu̱‑ún ni̱ kaku‑ná, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Yúan‑na te ja̱ kákuni̱ xndó'o‑de, ni̱ ka̱kuxio‑ni kája'a̱n. Te suni onde̱ general ni̱ yu̱'ú, chi ni̱ juku̱'un ini̱‑de ja̱ ní ju'ni̱‑de Pablo. Te ɨɨn cha̱a ñuu̱ Roma kúu Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Te ɨnga̱ kɨvɨ̱ xía̱n‑ún, kuní‑de kundaa̱ va̱'a ini̱‑de na̱ sɨkɨ̱ kúu ja̱ ní ka̱ndonda cha̱a judío sɨkɨ̱ Pablo. Te ni̱ ndájí‑de cadena nú'ni̱ Pablo. Te ni̱ tá'ú‑de tiñu ni̱ taka̱ ta̱ká sutu̱ ñá'nu jíín táká cha̱a junta. Te ni̱ kiñi'in‑de Pablo. Te ni̱ jani‑de nuu̱ cháa ni̱ ka̱ndutútú. ");
INSERT INTO migNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Yúan‑na te ni̱ ndakoto Pablo nuu̱ junta. Te ni̱ ka'a̱n‑de: Ñáni̱ jíná'an‑ní. Máá‑ná chi̱ a jiní va̱'a ini̱‑ná ja̱ ní jandatu̱ va̱'a‑ná nuu̱ Dios onde̱ vina. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Yúan‑na te máá sutú ñá'nu‑ga̱ nání Ananías, ni̱ tá'ú tíñu nuu̱ cháa ká'i̱in yani nuu̱‑dé‑ún ja̱ ná kuá'a‑ún ɨɨn ji̱kí máá yú'u‑dé. ");
INSERT INTO migNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Te ni̱ ka'a̱n Pablo jíín sutú ñá'nu‑ún: Xáán ndoo ka'a̱n‑ro̱. Dios stují‑yá róó. Chi̱ kánchaa̱‑ro̱ já sándaa̱‑ro̱ tíñu‑ri̱ nátu̱'un ká'a̱n ley. Chi va̱sa tú íó ley te tá'ú‑ró tíñu ja̱ stují‑dé ruu̱ náún. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Te ni̱ kaka'a̱n cha̱a ká'i̱in nuu̱‑dé‑ún: Naja̱ ká'a̱n ndɨva̱'a‑ró jíín sutú ñá'nu Dios, áchí jíín‑de. ");
INSERT INTO migNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Te ni̱ ka'a̱n Pablo: Tú ní jiní‑ná ja̱ sutú ñá'nu kúu‑de ñáni̱, chi̱ yóso núu̱ tutú: Ma̱ ká'a̱n ndɨva̱'a‑ró sɨkɨ́ cháa kúñá'nu ini̱ ñuu̱‑ro̱. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ko nuu̱ ní jini̱ Pablo ja̱ sáva‑de kákuu‑de saduceo te sava‑ga̱‑de kákuu‑de fariseo, te ni̱ ka'a̱n jaa‑de nuu̱ junta: Ñáni̱ jíná'an‑ní, máá‑ná kúu cha̱a fariseo, se̱'e fariseo. Chi̱ ñúkuu ini̱‑ná ja̱ náchaku̱ ta̱ká ndɨ̱yi, te ja̱ yúán xndichí‑ní náá. Achí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Te ja̱ súan ni̱ ka'a̱n‑de, te ni̱ ka̱kana̱á cha̱a fariseo jíín cháa saduceo. Te cha̱a junta, sɨ́ɨn sɨ́ɨn tu̱'un ni̱ kaka'a̱n‑de. ");
INSERT INTO migNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Chi̱ káka'a̱n cha̱a saduceo ja̱ má náchaku̱ ndɨ̱yi, ni tú ká'i̱o ndajá'a̱‑yá, ni tachi̱. Ko cha̱a fariseo, kájatú'ún‑de ndenúní tu̱'un‑ún. ");
INSERT INTO migNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Te xaa̱n ní kuvaa̱. Te sava cha̱a káchaa tutu̱ ja̱ kákuu tá'an cha̱a fariseo, ni̱ ka̱ndukuiñi̱. Te ni̱ kaka'a̱n ni̱'in: Tú ni ɨɨn kua̱chi káni'i̱n‑rí sɨkɨ̱ cháa yá'a. Sanaa te ni̱ ka'a̱n ndija ɨɨn añú xí ɨ́ɨn ndajá'a̱‑yá jíín‑de. Ma̱ sáni̱'in ini̱‑yo̱ núu̱ Dios núsáá. Achí. ");
INSERT INTO migNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Te xaa̱n ní ka̱kana̱á‑i. Te general, yú'ú‑de ja̱ ndátá ñáa̱‑i Pablo. Te ni̱ tá'ú‑de tiñu ja̱ ná kɨ́vɨ soldado te kañaa ni̱nu Pablo sava ma̱'ñú‑i, te ná kɨ́vɨ‑de ini̱ cuartel. ");
INSERT INTO migNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Te akuáa‑ún ni̱ chaa̱‑ni máá Jíto'o̱‑yo̱ núu̱‑dé te ni̱ ka'a̱n‑ya̱ jíín‑de: Pablo, ma̱ ndúkuí'a̱ ini̱‑ro̱, chi̱ nátu̱'un ni̱ jani ndaa̱‑ro̱ tú'un‑ri̱ ini̱ ñuu̱ Jerusalén, suni súan kánúú kíka̱ni‑ró tú'un‑ri̱ onde̱ ini̱ ñuu̱ Roma, áchí‑ya̱. ");
INSERT INTO migNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Te nuu̱ ní kundiji̱n, ni̱ ka̱kutútú sáva ña̱yɨvɨ judío. Te ni̱ ka̱natɨɨn tu̱'un tá'an‑i. Te ni̱ kaka'a̱n téyíí‑i ja̱ má kée kútɨ‑í staa̱ ni ma̱ kó'o kutɨ‑í nducha onde̱ nú tú ka'ni‑í Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Te ví'í‑gá uu̱ xiko judío ni̱ kaka'a̱n téyíí‑i tu̱'un yá'a. ");
INSERT INTO migNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Te ni̱ kaja'a̱n‑i nuu̱ sutú ñá'nu jíín núu̱ cháa kákuu nuu̱, te ni̱ kaka'a̱n‑i jíín cháa‑ún: Máá‑ná, ni̱ kaka'a̱n téyíí‑ná ja̱ má kée kútɨ‑ná onde̱ nú tú ka'ni‑ná Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Núsáá te máá‑ní jíná'an‑ní jíín táká junta, kuáka'a̱n‑ní jíín general ná kíñi'in‑de Pablo chaa̱‑de nuu̱‑ní yá'a, chi̱ kákuni̱‑ní xndichí va̱'a‑ga̱‑ní‑de, achi‑ní. Te ná kótu̱'a máá‑ná ka'ni‑ná‑de onde̱ té chaa̱‑ga̱‑de yá'a. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ko ɨɨn se̱'e yíí kua̱'a Pablo, ni̱ jini so̱'o‑i ja̱ súan ni̱ ka̱natɨɨn tu̱'un tá'an. Te ni̱ ja'a̱n‑i ni̱ kɨ̱vɨ‑i ini̱ cuartel. Te ni̱ kastu̱'ún‑i nuu̱ Pablo. ");
INSERT INTO migNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Te ni̱ kana Pablo xini̱ ɨ́ɨn cha̱a kúu capitán. Te ni̱ ka'a̱n‑de: Kunchaka su̱chí yá'a ki'i̱n‑ro̱ jíín‑i nuu̱ general, chi̱ íó ɨɨn tu̱'un kastu̱'ún‑i nuu̱‑dé, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Te capitán, ni̱ jaka‑de‑i kua'a̱n‑de jíín‑i nuu̱ general. Te ni̱ ka'a̱n‑de: Pablo cha̱a yíndi'u̱ veka̱a, ni̱ ka'a̱n nda̱'ú‑de jíín‑ná ja̱ kínchaka‑ná su̱chí yá'a nuu̱‑ní, chi̱ íó ɨɨn tu̱'un ka'a̱n‑i jíín‑ní, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Te ni̱ tɨɨn general nda'a‑í. Te ni̱ kuxio‑de jíín‑i. Te ni̱ jika̱ tu̱'ún sá'í‑de‑i: Na̱ún tu̱'un ka'a̱n‑ro̱ jíín‑rí kuní‑ro̱, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Te ni̱ ka'a̱n‑i: Cha̱a judío ni̱ ka̱skétá'an‑de tu̱'un ja̱ yúchaa̱n ka'a̱n nda̱'ú‑de jíín‑ní kiñi'in‑ní Pablo nuu̱ táká cha̱a junta, chi̱ xndichí va̱'a‑de Pablo sɨkɨ̱ tíñu kákuni̱‑de, achi̱‑de. ");
INSERT INTO migNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ko ma̱ kándíja‑ní, chi̱ ví'í‑gá uu̱ xiko‑de káindatu̱ sa̱'í‑de. Te káka'a̱n téyíí‑de ja̱ má kée‑dé staa̱ ni ma̱ kó'o‑de nducha onde̱ nú tú ka'ni‑dé Pablo, áchí‑de. Te vina a káinda̱tu tu̱'a‑de onde̱ ná kuátu̱'un‑ní. Achí‑i. ");
INSERT INTO migNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Te ni̱ tá'ú tíñu general nuu̱‑í, ja̱ tú ni ɨɨn nuu̱ kachí‑i ja̱ súan ni̱ kastu̱'ún‑i nuu̱‑dé. Te ni̱ tájí‑de‑i kua̱no'on‑í. ");
INSERT INTO migNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Yúan‑na te ni̱ kana‑de xini̱ úu̱ capitán. Te ni̱ ka'a̱n‑de: Sátu̱'a‑ró úu̱ ciento soldado, jíín uní xiko uxi̱ soldado koso caballo, jíín úu̱ ciento soldado kátɨ̱ɨn lanza, náva̱'a ki̱ngoyo‑ró jíín‑de onde̱ ñuu̱ Cesarea ka̱'ɨɨ̱n akuáa vína. ");
INSERT INTO migNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Te suni ná sátu̱'a‑de caballo koso Pablo. Te koto va̱'a‑de Pablo ki̱ngoyo‑de onde̱ nuu̱ Félix cha̱a kúu gobernador, áchí‑de. ");
INSERT INTO migNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Te ni̱ chaa‑de ɨɨn carta ja̱ ní ka'a̱n tu̱'un yá'a: ");
INSERT INTO migNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Máá‑ná kúu Claudio Lisias. Te cháa‑ná carta yá'a nuu̱ níí Félix, gobernador ñá'nu. Ta̱ ni táa̱. ");
INSERT INTO migNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ña̱yɨvɨ judío, ni̱ ka̱tɨɨn‑i ɨɨn cha̱a yá'a. Te a yani ka'ni‑í‑de núú, ko ni̱ nama‑ná‑de jíín soldado chi ni̱ jini̱‑ná ja̱ cháa ñuu̱ Roma kúu‑de. ");
INSERT INTO migNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Te kuní‑ná kundaa̱ ini̱‑