﻿USE sofia;
DROP TABLE IF EXISTS sofia.mif_vpl;
CREATE TABLE mif_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mif_vpl WRITE;
INSERT INTO mif_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","*Yesu *Kəriste na, ara səkway ŋga Bay *Davit. Davit e may, a yawa daa səkway ŋga *Abəraham. Ndəhay daa səkway ŋga Yesu Kəriste he na, a zley ta Abəraham. ");
INSERT INTO mif_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abəraham a na, aŋga papaŋ ŋga *Izak. Izak may, papaŋ ŋga Jakwap. Jakwap, papaŋ ŋga ata Juda ta məlmaha hay. ");
INSERT INTO mif_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda, papaŋ ŋga ata Fares ta Zerah ma yatərwa ta ŋgwas aŋga mezəley Tamar. Fares, papaŋ ŋga Esraŋw. Esraŋw, papaŋ ŋga Aram. ");
INSERT INTO mif_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram, papaŋ ŋga Aminadap. Aminadap, papaŋ ŋga Naasaŋw. Naasaŋw, papaŋ ŋga Salmaŋ. ");
INSERT INTO mif_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmaŋ, papaŋ ŋga Bəwaz ma yarawa ta ŋgwas aŋga *Rahap. Bəwaz, papaŋ ŋga Awbet ma yarawa ta ŋgwas aŋga Rut. Awbet, papaŋ ŋga Jese. ");
INSERT INTO mif_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese, papaŋ ŋga Bay Davit. Davit e na, aŋga papaŋ ŋga Salamaŋw. Mamaha ta key ŋgwas ŋga Uri la. ");
INSERT INTO mif_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","*Salamaŋw, papaŋ ŋga Rabəwam. Rabəwam, papaŋ ŋga Abiyah. Abiyah, papaŋ ŋga Asaf. ");
INSERT INTO mif_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf, papaŋ ŋga Jawzafat. Jawzafat, papaŋ ŋga Jəwaram. Jəwaram, papaŋ ŋga Awziyas. ");
INSERT INTO mif_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Awziyas, papaŋ ŋga Jəwatam. Jəwatam, papaŋ ŋga Akaz. Akaz, papaŋ ŋga Ezekiyas. ");
INSERT INTO mif_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiyas, papaŋ ŋga Manase. Manase, papaŋ ŋga Amaŋw. Amaŋw, papaŋ ŋga Jawziyas. ");
INSERT INTO mif_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jawziyas, papaŋ ŋga ata Yekwaniya ta məlmaha hay, a yatərwa daa masa ndəhay daa hwayak ŋga *Babilaŋw ma həlmata *Israyel hay aa hwayak ata. ");
INSERT INTO mif_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Fa dəɓa ha masa ata ma həlmata la a Babilaŋw a na, Yekwaniya a yawa Salatiyel. Salatiyel, papaŋ ŋga Zarubaabel. ");
INSERT INTO mif_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zarubaabel, papaŋ ŋga Abiyut. Abiyut, papaŋ ŋga Eliyakim. Eliyakim, papaŋ ŋga Azawr. ");
INSERT INTO mif_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azawr, papaŋ ŋga Sadakw. Sadakw, papaŋ ŋga Akim. Akim, papaŋ ŋga Eliyut. ");
INSERT INTO mif_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyut, papaŋ ŋga Eliyazar. Eliyazar, papaŋ ŋga Mataŋ. Mataŋ, papaŋ ŋga Jakwap. ");
INSERT INTO mif_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","*Jakwap, papaŋ ŋga *Jawzef, zel ŋga *Mari ma yarawa Yesu ma zəlmara Kəriste, anda meləvey, ndaw masa Bay *Gazlavay ma wala ŋga ləhdata ndəhay. ");
INSERT INTO mif_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Anda keɗe, dəga fa Abəraham haa kasl fa Davit na, dedeŋ ŋga dedeŋ hay kuraw a ray a məfaɗ. Dəga fa Davit e may haa kasl ta pas masa ata ma həlmata Israyel hay a Babilaŋw na, dedeŋ ŋga dedeŋ hay kuraw a ray a məfaɗ. Yaw, dəga ta pas a ŋgene kasl fa mayawa ŋga Kəriste na, dedeŋ ŋga dedeŋ hay kuraw a ray a məfaɗ saya. ");
INSERT INTO mif_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ehe cəndamara mey da ray mayawa ŋga Yesu *Kəriste. *Mari mamaha na, ara kwakwa ŋga *Jawzef. Daa masa Jawzef ta la Mari a way aŋga daa ba araŋ na, Mari ta key hwaɗ sem ta gədaŋ ŋga *Mesəfney ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jawzef, maŋgasl ŋga Mari na, ara ndaw maaya ta leŋgesl. Daa masa aa ma cənda Mari ta key ta hwaɗ sem na, a wuɗey a par hwaray fa dey ŋga ndəhay ba. Da ray ŋgene, a wulkey ŋga mbəkda kwakwa aŋga, ama a wuɗey ŋga mbəkda na, kwa ndaw a səra mey a ba. ");
INSERT INTO mif_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Daa masa Jawzef fa wulkey da ray mey a na, *maslaŋ ŋga Bay Gazlavay da vaɗ ta’, a sawa a ray a, aa guzlar daa mesəfney, a ləvar: «Jawzef, səkway ŋga *Davit, ka da zlurey ŋga la kwakwa akah Mari ba, maja a key ta hwaɗ ŋgene na, ara ta gədaŋ ŋga Mesəfney ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A yawa bəzey mezəle la, ka da par mezəley Yesu, maja a da ləhdata ndəhay aŋga hay daa mebərey ata hay.» ");
INSERT INTO mif_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Cek aha keɗe cəpa ta key la anda Gazlavay maa guzlwa zleezle ta mey *ndaw ma təla mey aŋga, ma ləvey: ");
INSERT INTO mif_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Nəka taw! dam-saɓara a key ta hwaɗ la manjar zel, a da yawa bəzey mezəle. A da zəlmara Emanəwel», anda meləvey, Gazlavay aa ta aləkwa. ");
INSERT INTO mif_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jawzef a sləkɗey daa ɗar, fa dəɓa ha a ka anda maslaŋ ŋga Bay Gazlavay ma ləvar heyey. Leŋ! a la kwakwa aŋga Mari a way, ");
INSERT INTO mif_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ama ta cəmam cew e daa ba, haa kasl mayawa ŋga bəzey a. Jawzef a par mezəley Yesu. ");
INSERT INTO mif_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu a yawa da Betəlehem daa hwayak ŋga *Jude, daa masa *Herawt aŋga bay ŋga hwayak a. Fa dəɓa ŋga mayawa aŋga, ndəhay ma səra mey da ray wurzla hay a samawa ta da wurza aa berney ŋga *Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Aa cəfɗamara, a ləvam: «Bəzey masa ata ma yamərwa ma da key bay ŋga *Jəwif hay heyey na, aŋga dama? Ya ta hətmərwa wurzla aŋga la ma bawa ta da wurza. Anda keɗe, ya samawa na, amba ya ragadamar.» ");
INSERT INTO mif_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bay Herawt ma cənda mey a keɗe na, rav aŋga a jəvey ga, asaya, ndəhay daa berney ŋga Jeruzelem tabiya rav a jəvtar may. ");
INSERT INTO mif_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ta’, a zəltərwa *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, ta ndəhay maa sərkada *kwakwas ŋga Mawiz, aa cəfɗata, a ləvtar: «*Kəriste, ndaw masa Gazlavay ma wala ŋga key bay na, a da yawa dama?» ");
INSERT INTO mif_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","A mbəɗdamara, a ləvmar: «A da yawa da Betəlehem daa hwayak ŋga Jude. Ya sərmara maja *ndaw ma təla mey ŋga Gazlavay ta wuzleley la da ray a zleezle, a ləvey: ");
INSERT INTO mif_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Akwar, ndəhay da Betəlehem daa hwayak ŋga Jude na, slala akwar aa mahura da wuzlah slala hay mahura hay da Jude, maja ara da slala ha ŋgene yah ma da bawa bay ma da nəkey dey fa ndəhay aɗaw hay Israyel hay.”» ");
INSERT INTO mif_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Fa dəɓa ha, Bay Herawt a zəltərwa ndəhay ma səra mey da ray wurzla hay heyey ta mayal a, amba aa cəfɗata wurzla ha a bawa na, ta pas wura. ");
INSERT INTO mif_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ta’, a slərdata a Betəlehem, a ləvtar: «Diyam a Betəlehem, səpmara bəzey a ta dək-vaw. Da masa akwar ma hətmərwa la na, ka samawa, ka wuzdamiwa, amba ya daw, ya ragadar may.» ");
INSERT INTO mif_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ndəhay a ma cəndamara mey ŋga bay a cay na, ta’, a diyam. Masa ata daa cəveɗ na, a hətmar wurzla masa ma bawa ta da wurza heyey fa daw fa mey ata. Wurzla ha fa daw fa mey fa mey, a wusey kasl aa slam masa bəzey mecəhe aŋga da hwaɗ a heyey na, deŋ! a lecey a ray way a. ");
INSERT INTO mif_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Masa ata ma hətmar wurzla malacakaya heyey na, aa səmam ga, ara mey ba. ");
INSERT INTO mif_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","A wusam aa slam aha, ta’, a mbəzam aa way a, a hətfamar bəzey a ta mamaha *Mari. A həlmamara, a ragadamar. Cay, ta’, a pəskamata gabal ata hay, a vəlmar cek hay ma həɗkam ba. A vəlmar ɓərey meweɗey pəlŋgeɗ pəlŋgeɗ ta matəway ŋga wudez mezey maaya, leŋ slalak mezey maaya mezəley «*mir». ");
INSERT INTO mif_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Fa dəɓa ha, mesəfney a katar. Daa mesəfney a na, Gazlavay a kətata ŋga diyam ta fa Bay Herawt saba. Maja ŋgene, ta’, a lam cəveɗ mekele ŋga vəhey aa hwayak ata. ");
INSERT INTO mif_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Daa masa ndəhay ma səra mey da ray wurzla hay heyey ma diyam sem na, ta’, *maslaŋ ŋga Bay Gazlavay a wuzar vaw a *Jawzef daa mesəfney, a ləvar: «Sləkɗey, la bəzey, hwam ta mamaha aa hwayak ŋga *Ejip. Njamawa feteɗe, haa kasl pas masa yah ma da ləvkwar ŋga vəhwa, maja Bay *Herawt a da səpa bəzey a amba a kəɗa vagay.» ");
INSERT INTO mif_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Masa Jawzef ma cənda mey a keɗe la na, pərta! a sləkɗey, leŋ! a la bəzey a, a səhwam ta mamaŋ ŋga bəzey a dasi tavaɗ a ŋgene a Ejip. ");
INSERT INTO mif_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A njamawa feteɗe haa kasl meməcey ŋga Bay Herawt. Cek aha ta key la anda Gazlavay maa guzley ta mey *ndaw ma təla mey aŋga zleezle, ma ləvey: «Ya ta zələrwa bəzey aɗaw daa hwayak ŋga Ejip la.» ");
INSERT INTO mif_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bay *Herawt ma səra ndəhay ma səra mey da ray wurzla hay heyey ta fəcmara sem na, mevel a car ga! Ta’, a slərey ndəhay aŋga hay ŋga kəɗmata bəza hay mezəle da Betəlehem ta bəza hay masa gweegwe ta slala ha tabiya vagay. A wuɗey ŋga kəɗey vagay na, bəza hay masa ma yamawa təlam haa kasl fa bəza hay mevey cew. A kəɗta bəza hay mecəhe hay a anda ŋgene na, maja aŋga ma səra mevey ŋga wurzla ma bawa masa aŋga ma cənda da mey ndəhay ma səra mey da ray wurzla hay heyey. ");
INSERT INTO mif_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mekəɗey bəza hay a vagay ŋgene na, ta key la anda Jeremey, ndaw ma təla mey ŋga Gazlavay, maa guzley zleezle, a ləvey: ");
INSERT INTO mif_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«A cəndamara fa wudam ta gədaŋ da slala Rama, matəway ta mewudey sləw a! a ndəvey ba. Ara Rasel ma təway bəz aŋga hay. Mevel aŋga a dəkey ba, maja bəz aŋga hay a ta məcam sem.» ");
INSERT INTO mif_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Fa dəɓa ŋga meməcey ŋga Bay *Herawt heyey na, ta’, *maslaŋ ŋga Bay Gazlavay a wuzar vaw a *Jawzef daa mesəfney daa hwayak ŋga *Ejip heyey, ");
INSERT INTO mif_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a ləvar: «Sləkɗey, la bəzey, vəham ta mamaha aa hwayak ŋga *Israyel, maja ndəhay ma səpmara bəzey a ŋga kəɗey vagay heyey na, ta məcam sem dəɓa.» ");
INSERT INTO mif_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Cay, Jawzef pərta! a sləkɗey, leŋ! a la bəzey, ta’, a vəham ta mamaŋ ŋga bəzey a, aa hwayak ŋga Israyel. ");
INSERT INTO mif_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","A da cənda na, Arkelawas fa zəma bay ŋga papaha Herawt daa hwayak ŋga *Jude. Da ray ŋgene, mandərzay a kar, a zlurey ŋga njey daa hwayak a. Ta’, mesəfney a kar a Jawzef saya. Daa mesəfney a na, Gazlavay a kəta ŋga daw aa hwayak ŋga *Galile. ");
INSERT INTO mif_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Anda keɗe, a daw a njey aa hwayak a, da slala *Nezeret. Menjey aŋga da slala ha ŋgene na, ta key la, anda ndəhay ma təla mey ŋga Gazlavay, ma kadamara zleezle, ma ləvam: «A da zəlmara bəzey a na, ndaw Nezeret.» ");
INSERT INTO mif_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Fa dəɓa ha, ndaw daha mezəley *Jaŋ-Baptis, a wuzwa vaw da wuzlah-ley daa hwayak ŋga *Jude, fa wuzey mey, ");
INSERT INTO mif_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","a ləvey: «Mbəɗdamara menjey akwar, səpmara Gazlavay ta mevel pal, maja gweegwe cay, bay ŋga Gazlavay a wuzwa.» ");
INSERT INTO mif_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","*Jaŋ a na, ara ndaw masa *Izay, *ndaw ma təla mey ŋga Gazlavay zleezle, maa guzley da ray a, a ləvey: «Ndaw fa wudey da wuzlah-ley, a ləvey: Ɗiymar cəveɗ ŋgada Bay Mahura, ɗiymara cəveɗ e maaya maaya dər e.» ");
INSERT INTO mif_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zana fa vaw ŋga Jaŋ a na, macakaya ta eŋgwec ŋga slagwama. Vaw aŋga majəwkaya ta huteɗ. A zəmey na, ayakw ta amam da ley. ");
INSERT INTO mif_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ndəhay daa berney ŋga *Jeruzelem ta daa hwayak ŋga Jude tabiya, leŋ daa hwayak hay mekele mekele gweegwe ta wayam ŋga Jurdeŋ tabiya a diyam a fa Jaŋ a, ");
INSERT INTO mif_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","a wuzdamara mebərey ata hay. Jaŋ ta’, a katar *baptem daa wayam a. ");
INSERT INTO mif_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Da wuzlah ndəhay ma diyam fa Jaŋ a amba a katar baptem na, *Fariza hay ta *Saduse hay ga daha. A da hətatar na, fa samawa a fa vəɗa, ta’, aa guzltar, a ləvtar: «Hey! akwar bəza hay ŋga kucesl hay! Ma ləvkwar ka ləham la daa banay masa Gazlavay ma da handərwa a ray akwar na, wa? ");
INSERT INTO mif_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kam cek maaya, amba ndəhay a sərmara akwar ta mbəɗdamara menjey akwar sem, akwar fa səpmara Gazlavay ta mevel pal. ");
INSERT INTO mif_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ka da wulkam daa mevel akwar, ka ləvam: “Papa ala na, ara *Abəraham, maja ŋgene, Gazlavay a da sərfandar dey-ceceh.” Ka da ləvam kəne ba, maja ya fa ləvkwar fara fara, Gazlavay a gwa ŋga tərdata aŋgwa hay keɗe ŋga səkway ŋga Abəraham may. ");
INSERT INTO mif_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Zlamba maŋgakaya cay ŋga ŋgəmey wudez hay ta slaslalay a cəpa. Wudez ma yey babəza maaya ba na, a ŋgəmamara, a pamar awaw fa vəɗa. ");
INSERT INTO mif_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yah na, ya kakwar baptem ta yam, ŋga wuzwa fara fara akwar ta mbəɗdamara menjey akwar cay. Ama ndaw ma fənya fa sawa. Aŋga na, kwa ya wusa ŋga cəkwra tarak da salay aŋga ba. Ndaw a na, a kakwar baptem la ta *Mesəfney ŋga Gazlavay leŋ ta awaw. ");
INSERT INTO mif_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aŋga da gədak ta vəley mekəfey daw da har, amba a wunka bəz-daw ta cekwesl e. Bəz-daw na, a da həla a wudeɗ. Ama cekwesl e na, a da gəɗar awaw a ray a, awaw masa ma məcey ba ŋga sərmataw.» ");
INSERT INTO mif_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Fa dəɓa ha, Yesu a sawa daa hwayak ŋga *Galile, a daw aa wayam ŋga Jurdeŋ fa *Jaŋ, amba Jaŋ a kar *baptem. ");
INSERT INTO mif_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ama Jaŋ a wuɗey ŋga kar baptem e ba, a ləvar: «Am! Anja ma da daw fa kah, amba ka kaya baptem na, yah jak, ba diya? Kaa, ka fa sawa fa yah jak na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu a mbəɗdara, a ləvar: «Ama wure keɗe na, təɓa ŋga kaya baptem, amba ya kakwa sləra ŋga Gazlavay masa aa maa cəfɗa tabiya ŋga key.» Ta’, Jaŋ a, a təɓa ŋga kar baptem e. ");
INSERT INTO mif_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Masa Yesu ma hətey baptem cay fa bawa daa yam na, wure ŋgene, slam da vaɗ bəɗaŋ! a wurey. A da nəkey dey na, *Mesəfney ŋga Gazlavay fa pawa salay da vaɗ, anda makurgwadakw. Cəkwam! a njey a ray a. ");
INSERT INTO mif_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Asaya, ɗay fa cənwa da gazlavay da vaɗ, a ləvey: «Keɗe he, ara Bəzey aɗaw, masa yah ma wuɗa kalah. Ya faa səmey ga da ray a.» ");
INSERT INTO mif_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Fa dəɓa ha, *Mesəfney ŋga Gazlavay a handa Yesu a wuzlah-ley amba *Sataŋ, bay-malula, a jada ŋga bata. ");
INSERT INTO mif_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kwa Yesu ta zəmey cek daa ba, ɗar kwakwar məfaɗ, taa vaɗ, taa pas. Fa dəɓa ha, may a car dəɓa. ");
INSERT INTO mif_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ta’, bay-malula a daw a cakay a ŋga bata, aa guzlar, a ləvar: «Da kah Bəzey ŋga Gazlavay na, tərdata aŋgwa hay keɗe ŋga ɗaf taw!» ");
INSERT INTO mif_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu a mbəɗdara, a ləvar: «Mawuzlalakaya daa ɗerewel ŋga Gazlavay, a ləvey: “Ndaw na, a njey ta cek mezəmey daada ba, ama ta mey cəpa masa ma bawa da mey Gazlavay.”» ");
INSERT INTO mif_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Cay, bay-malula ha ta’, a handa a *Jeruzelem, berney ŋga Gazlavay. A təpda aa ray ŋga *Way-mekey-kwakwas ŋga Gazlavay, ");
INSERT INTO mif_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","a ləvar: «Da kah Bəzey ŋga Gazlavay na, jəvey a hwayak, maja Mey ŋga Gazlavay mawuzlalakaya a ləvey: “Gazlavay a da ka amba a slərwa maslaŋ aŋga hay, a sləwmaka la a har ata amba salay akah a gurzey fa aŋgwa ba.”» ");
INSERT INTO mif_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu a mbəɗdara, a ləvar: «Mey ŋga Gazlavay mawuzlalakaya a ləvey saya: “Ka da jada Bay Gazlavay akah ba.”» ");
INSERT INTO mif_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Fa dəɓa ha, bay-malula ha, a handa saya, a təpda aa ray ŋga aŋgwa maazəma, a wuzdara hwayak hay da bəla cəpa ta zleley hay cəpa da hwaɗ a, aa guzlar, ");
INSERT INTO mif_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","a ləvar: «Da kah ma ragadaya la, kah ma dərya daŋgay la na, hwayak hay a ta zleley hay cəpa da hwaɗ a keɗe na, ya vəldatakawa la.» ");
INSERT INTO mif_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ta’, Yesu a mbəɗdara, a ləvar: «Sataŋ, hway la feɗe! Mbəkdaya maja Mey ŋga Gazlavay mawuzlalakaya a ləvey: “Ka da ragadar na, si ŋgada Bay Gazlavay akah gway. Dərar daŋgay ŋgada Bay Gazlavay pal taava aŋga.”» ");
INSERT INTO mif_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Daa ŋgene, bay-malula ha, mbak! a mbəkda Yesu. Ta’, maslaŋ hay ŋga Bay Gazlavay da vaɗ a samawa a cakay a, a jənmara, a vəlmar cek mezəmey. ");
INSERT INTO mif_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Menjey nekəɗey na, ta’, a kərzamara *Jaŋ-Baptis, a mbəzdamara aa fərsəne. Masa Yesu ma cənda ata ma kərzamara Jaŋ-Baptis sem na, a sləkɗey, a vəhey aa hwayak ŋga *Galile. ");
INSERT INTO mif_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ta njey da slala *Nezeret daa ba, ama a daw a njey a Kapernayum. Kapernayum na, ara slala da mey dəhwa ŋga Galile, masa daa hwayak ŋga səkway ŋga Zabulaŋw ta ŋga Naftali. ");
INSERT INTO mif_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Anda keɗe, cek aha ta key la anda *Izay, *ndaw ma təla mey ŋga Gazlavay, maa guzley zleezle, ma ləvey: ");
INSERT INTO mif_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ndəhay daa hwayak ŋga səkway ŋga Zabulaŋw ta ŋga Naftali, hwayak hay masa gweegwe ta dəhwa ŋga Galile, ta dey laŋgar ŋga wayam ŋga Jurdeŋ, hwayak ŋga Galile masa ndəhay Jəwif hay ba hay ma njam da hwaɗ a, ");
INSERT INTO mif_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ndəhay a, ata daa ləvaŋ, ama a hətmar meweɗey mahura la. Ata masa anda ndəhay maməctakaya, ama slam a weɗey la a ray ata.» ");
INSERT INTO mif_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Masa Yesu ma daw a Kapernayum a na, ara daa ŋgene, aŋga ma zlar mewuzey mey, a ləvey: «Mbəɗdamara menjey akwar da bəla, maja gweegwe cay, Gazlavay a wuzdərwa bay aŋga.» ");
INSERT INTO mif_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pas pal daha, Yesu fa pəkey da mey dəhwa ŋga *Galile. Ta’, a hətey məlmaŋ hay cew daha, ara ndəhay ma kərza ewet. Ata *Simaŋw masa ma zəlmara *Piyer ta məlmaha *Andəre, fa kərzam ewet ta *tabaw daa dəhwa ha. ");
INSERT INTO mif_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu ta’, a zəltərwa, a ləvtar: «Samawa asi aɗaw. Akwar na, ndəhay ma kərza ewet, ama dəga wure keɗe ya da tərdakwar ŋga ndəhay ma zəlwa ndəhay aa cəveɗ ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wure ŋgene, mbak! a mbəkdamata tabaw ata hay, ta’, a diyam asi Yesu. ");
INSERT INTO mif_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu a ŋgəchey nekəɗey fa mey na, a hətey məlmaŋ hay cew mekele saya, ara ata *Jak ta məlmaha *Jaŋ, bəza hay ŋga Zebede. Ata manjatakaya daa kwambiwal ta papa ata Zebede, fa ɗiymata tabaw ata hay. Yesu ta’, a zəlta ata Jak ta Jaŋ ŋga diyam asiya. ");
INSERT INTO mif_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wure ŋgene, mbak! a mbəkdamara kwambiwal leŋ papa ata, ta’, a diyam asi Yesu. ");
INSERT INTO mif_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu fa pəkta slala hay cəpa daa hwayak ŋga *Galile, faa sərkadata ndəhay daa way-mewuzey-mey hay ŋga Gazlavay, fa wuzey *Mey-maaya-mawiya da ray *mewey ŋga Bay Gazlavay da ray ndəhay, fa mbəley ndəhay daa macay hay wura wura cəpa leŋ ndəhay maahəlɓatakaya hay tabiya. ");
INSERT INTO mif_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ndəhay tabiya daa hwayak ŋga Siri a cəndamara mey da ray a. Anda keɗe, a handamar ndəhay ga daa macay hay mekele mekele, siya hay masa vaw fa catar kalah, siya hay masa malula da ray, siya hay masa ta cek da ray fa ɓərzlam, leŋ masa maahəlɓatakaya hay. Ta’, Yesu a mbəldata. ");
INSERT INTO mif_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ndəhay ga fa diyam asiya. Ndəhay a na, a samawa daa hwayak ŋga Galile, daa hwayak mezəley Berney-Hay-Kuraw, daa berney ŋga *Jeruzelem, daa hwayak ŋga *Jude, leŋ daa hwayak ta dey laŋgar ŋga wayam ŋga Jurdeŋ. ");
INSERT INTO mif_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Masa Yesu ma hətatar ndəhay ga fa diyam asiya na, ta’, a təpey a aŋgwa, cəkwam! a njey ta njey. Gula aŋga hay a diyam, a kusam a cakay a. ");
INSERT INTO mif_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yesu a zlar ŋgaa sərkadata, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Maaya ŋga Gazlavay aa da ray ndəhay ma ləvam mbalay Gazlavay, ba na, ata cek hay ŋga tede. Maaya ŋga Gazlavay aa da ray ata na, maja ata ma təɓmara amba Gazlavay a wey da ray ata fara fara. ");
INSERT INTO mif_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Maaya ŋga Gazlavay aa da ray ndəhay masa ta matəway daa dey, maja ata na, ara Gazlavay ma da dəktar mevel. ");
INSERT INTO mif_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Maaya ŋga Gazlavay aa da ray ndəhay meekweɗ-mey, maja ata na, a da hətam slam menjey anda Gazlavay ma ləvtar a da vəldatara. ");
INSERT INTO mif_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Maaya ŋga Gazlavay aa da ray ndəhay ma wuɗam ŋga key cek ma mbafar a Gazlavay ta mevel ata cəpa, maja ata na, Gazlavay a, a pata la aa wiya. ");
INSERT INTO mif_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Maaya ŋga Gazlavay aa da ray ndəhay ma səram dey-ceceh fa ndəhay, maja ata na, Gazlavay a sərfatar dey-ceceh la may. ");
INSERT INTO mif_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Maaya ŋga Gazlavay aa da ray ndəhay ma səpmara mey ŋga Gazlavay ta mevel pal, maja ata na, a hətmar Gazlavay la ta dey ata. ");
INSERT INTO mif_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Maaya ŋga Gazlavay aa da ray ndəhay ma cəmtar ɗay ŋga ndəhay, maja ata na, Gazlavay a da zəlta bəz aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Maaya ŋga Gazlavay aa da ray ndəhay masa ndəhay ma sərdamata banay maja ata ma kam cek ma mbafar a Gazlavay. Maaya ŋga Gazlavay aa da ray ata na, maja Bay Gazlavay fa wey da ray ata. ");
INSERT INTO mif_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Da ndəhay fa cəɗmakwar, fa sərdamakwar banay, asaya, fa mbərzlam a ray akwar maja akwar ndəhay aɗaw hay na, maaya ŋga Gazlavay aa da ray akwar. ");
INSERT INTO mif_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ta sərdamata banay ta ndəhay ma təla mey ŋga Gazlavay zleezle la, ba diya? Yaw, da anda keɗe na, maaməlkam, njam ta meesəmey ga ara mey ba, maja ara Gazlavay ma da pəlkwara mawurɓay ŋga sləra akwar maaya maaya da vaɗ.» ");
INSERT INTO mif_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesu a ləvtar a gula aŋga hay saya: «Da bəla keɗe, akwar na, anda manda. Da mecərey ŋga manda ha daa saba na, ka da sərmara ara manda na, kwara? Da mecərey ŋga manda ha daa saba na, aŋga maaya saba, a kwiydamara aa papalah saw, ndəhay a hərpamara. ");
INSERT INTO mif_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Asaya, akwar na, ndəhay ma waɗa bəla. Da berney aa daa ray ŋga aŋgwa na, a ɓey fa dey ŋga ndəhay la daw? ");
INSERT INTO mif_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yaw, ndaw a gəɗey awaw aa petərla, a pa asi maŋgayak ba, si a pa aa slam mepey petərla amba a waɗatar dey ŋgada ndəhay daa way a tabiya. ");
INSERT INTO mif_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Anda keɗe, si ka waɗam fa dey ŋga ndəhay tabiya, amba a hətmar sləra akwar maaya, a həslmar ray a Papakw akwar Bay Gazlavay da vaɗ.» ");
INSERT INTO mif_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«*Kwakwas ŋga Mawiz ta meesərkedey ŋga ndəhay ma təla mey ŋga Gazlavay na, ka wulkam, ya sawa ŋga nəsa daw? Ara kəne ba. Ama ya sawa na, amba ya wuzdakwara mabara ŋga mey da ray a. ");
INSERT INTO mif_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya fa ləvkwar fara fara, kwakwas ŋga Mawiz a, kwa kuset kəɗey, fa daa zəɗey daa ba səlak, haa kasl slam da vaɗ ta slam da hwayak ma ndəvam. Kwakwas ŋga Mawiz fa daa zəɗey daa ba, haa kasl ta pas masa sləra ŋga kwakwas a ma ndəvey cay cəpa. ");
INSERT INTO mif_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Anda keɗe, da ndaw ta zləɓey mey la, kwa kuset kəɗey daa kwakwas a, asaya, da taa sərkadata ndəhay la ŋga kamara anda aa ma zləɓa ha na, ndaw aha a da tərey ndaw mecəhe da wuzlah ndəhay masa Gazlavay ma wey da ray ata. Ama da ndaw ta nar ray la ŋgada kwakwas a cəpa, asaya, da taa sərkadata ndəhay la ŋga kamara kəne na, ndaw aha a da tərey mahura da wuzlah ndəhay masa Gazlavay ma wey da ray ata. ");
INSERT INTO mif_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ya fa ləvkwar fara fara, akwar fa da ndəkwam a wuzlah ndəhay masa Gazlavay ma wey da ray ata na, daa ba, si ka kam cek ma mbafar a Gazlavay ma fəna *Fariza hay leŋ ndəhay maa sərkada kwakwas ŋga Mawiz.» ");
INSERT INTO mif_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesu aa sərkadata gula aŋga hay da cakay a heyey saya, a ləvtar: «Akwar ma cəndamara mey ŋga Gazlavay maa guzldatara ŋgada dede aləkwa hay zleezle la, ba diya? Mey a, a ləvey: “Ka da kəɗey ndaw vagay ba. Kwa waawa ma kəɗey ndaw vagay na, a kamar sariya la.” ");
INSERT INTO mif_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama yah na, ya fa ləvkwar saya, kwa waawa ma cey mevel a ray məlmaha na, Gazlavay a kar sariya la. Kwa waawa ma ləvar a məlmaha: “Kah manjar leŋgesl” na, a handamara ndaw a la fa mey ŋga ndəhay mahura hay ma sla yawa ŋga Israyel hay. Asaya, kwa waawa ma ləvar a məlmaha: “Kah marəzlkaya” na, ŋgene, mak ŋga mbəzda aa vəgeɗ ŋga awaw magaza. ");
INSERT INTO mif_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Yaw, da ka fa daw aa *Way-mekey-kwakwas ŋga Gazlavay amba ka vəlar cek a Gazlavay, daa ŋgene, ka sərfada, məlmakw fa cey mevel da ray akah na, ");
INSERT INTO mif_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ŋgene, mbəkda cek akah ha a cakay slam-mefəkey cek ŋgada Gazlavay a, daw fa məlmakw a, cəmamawa ɗay ta aŋga la ɗagay, wara ka vəhwa, ka vəlda cek akah ŋgada Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Da ndaw a wudka, fa handaka aa sariya na, wusey vaw, ɗiymara mey akwar ta ndaw aha daa cəveɗ. Da daa ba na, a da vəldaka a har ndaw ma ka sariya. Ndaw ma ka sariya ha, a da vəldaka a har sewje hay. Sewje hay may, a da kəzlamaka aa fərsəne. ");
INSERT INTO mif_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ya fa ləvka fara fara, ka fa da bawa daa fərsəne he daa ba səlak, si kah ma pəla dəvaz a la tabiya ndav.» ");
INSERT INTO mif_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Akwar ma cəndamara mey ŋga Gazlavay maa guzlda la, a ləvey: “Ka da ley vaw saw da palah ba.” ");
INSERT INTO mif_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama yah na, ya fa ləvkwar saya, kwa waawa maa həmey ŋgwas ŋga ndaw daa mevel aŋga ŋga ney ta aŋga na, ŋgene anda ndaw aha ta lam vaw sem ta ŋgwas aha. ");
INSERT INTO mif_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Da dey akah ŋga zəmay fa həldaka ŋga key cek hay maaya ba na, wuzlka dey a, hazakada dəreŋ ta kah. Ŋgama mezəvey ŋga vaw akah pal meezəɗey da ray vaw akah tabiya ma da kəzley aa vəgeɗ ŋga awaw magaza. ");
INSERT INTO mif_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Asaya, da har akah ŋga zəmay fa həldaka ŋga key cek maaya ba na, ɗəsla har a, hazakada dəreŋ ta kah. Ŋgama mezəvey ŋga vaw akah pal meezəɗey da ray vaw akah tabiya ma da mbəzey aa vəgeɗ ŋga awaw magaza.» ");
INSERT INTO mif_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Mey mekele daha saya, a ləvey: “Kwa waawa ma ɓəla ŋgwas aŋga na, si a vəlar ɗerewel ŋga wuzda aŋga ma ɓəla sem.” ");
INSERT INTO mif_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama yah na, ya fa ləvkwar saya: Ndaw a da ɓəla ŋgwas aŋga ba, si da ŋgwas aha ta ley vaw la da palah kwa. Da ndaw a ɓəla, fa dəɓa ha ŋgwas aha a ley zel mekele na, a key ŋgene, a tərda ŋgwas aha ŋga ŋgwas meley-vaw saw da palah. Asaya, ndaw ma la ŋgwas masa zel e ma ɓəla ŋgene na, aŋga anda ndaw ma ley vaw saw da palah may.» ");
INSERT INTO mif_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Asaya, akwar ma cəndamara mey ŋga Gazlavay maa guzldatara ŋgada dede aləkwa hay la, a ləvey: “Ka da mbaɗam ŋga tede ba. Da akwar ma mbaɗam sem na, si ka kamara cek aha fara fara ta mezəley ŋga Bay Gazlavay.” ");
INSERT INTO mif_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama yah na, ya fa ləvkwar, kwa ka da mbaɗam ba səlak, kwa ta slam da vaɗ ka da mbaɗam ba, maja ara slam-menjey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kwa ta slam da hwayak ka da mbaɗam ba, maja ara slam-mepey-salay ŋga Gazlavay. Kwa ta *Jeruzelem ka da mbaɗam ba, maja ara berney ŋga Gazlavay Mawaca-waca. ");
INSERT INTO mif_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Asaya, kwa ta ray akwar hay ka da mbaɗam ba, maja ka gwamara ŋga tərdamara kwa eŋgwec ŋga ray akwar matara pal ŋga mabara ba. ");
INSERT INTO mif_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Da mey a ara aŋga na, ləvam: “Ahaw, ara aŋga!” Da ara aŋga ba na, ləvam: “Kay, ara aŋga ba!” Da ka ləvam mey wal na, ŋgene mey a, a bawa ta fa *Sataŋ, bay-malula.» ");
INSERT INTO mif_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Akwar ma cəndamara mey ŋga Gazlavay maa guzley la daa slam mekele, a ləvey: “Da ndaw a wuzlkakawa dey na, wuzlkara ŋga aŋga may. Da ndaw a pəlŋgwakawa sler na, pəlŋgwara ŋga aŋga may.” ");
INSERT INTO mif_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama yah na, ya fa ləvkwar, akwar na, ka da pəlam cəhwal ba. Da ndaw a kəɗka a cakay baazlam ŋga zəmay na, mbəɗdara dey ŋga gula saya. ");
INSERT INTO mif_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Da ndaw a wudka amba a təɓa ɗeŋ-kece akah na, gərda ŋga təɓa dawura akah saya. ");
INSERT INTO mif_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Da ndaw a təkaka ɗay ŋga ley cek dadakw kəlemeeter pal na, handara a key kəlemeeter cew. ");
INSERT INTO mif_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Da ndaw aa cəfɗafaka cek na, vəlar. Asaya, da ndaw a dedəɗey cek na, kwa ka daa zləka ba.» ");
INSERT INTO mif_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Akwar ma cəndamara mey ŋga Gazlavay maa guzley la daa slam mekele, a ləvey: “Wuɗa jam akah, masa-gəra akah na, ka da pey dey a ray a ba.” ");
INSERT INTO mif_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama yah na, ya fa ləvkwar: wuɗmata masa-gəra akwar hay, dəram daŋgay a Gazlavay amba a pəstar mey a ndəhay ma sərdamakwar banay. ");
INSERT INTO mif_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Anda keɗe, a da wuzwa akwar na, bəza hay ŋga Papaŋ Bay Gazlavay da vaɗ, maja aŋga na, fa waɗarawa pas a ray ndəhay maaya ta maaya ba hay, asaya, fa parawa var ŋgada ndəhay ma namar ray ta ŋgada ndəhay ma namar ray ba tabiya. ");
INSERT INTO mif_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Da ka wuɗam ndəhay ma wuɗmakwar daada gway na, Gazlavay a da pəlkwara mawurɓay ŋga sləra akwar na, maja me? Kwa ma cakala budaw hay na, fa kamara kəne may, ba diya? ");
INSERT INTO mif_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Da ka cam har ŋgada səkway akwar hay gway na, ka ta kam sləra maaya ma fəna maamandaw la daw? Kwa ndəhay ma sərmara Bay Gazlavay ba na, fa kamara kəne may, ba diya? ");
INSERT INTO mif_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Papakw akwar Bay Gazlavay da vaɗ, aŋga maaya kalah, a wuɗta ndəhay tabiya. Təram ndəhay maaya kalah anda aŋga.» ");
INSERT INTO mif_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu aa sərkadata gula aŋga hay da cakay a heyey saya, a ləvtar: «Wam vaw fa sləra masa akwar ma kamara ŋgada Gazlavay. Ka da kamara ta mezlepey fa mey ŋga ndəhay ba. Maja da ka kamara amba a hətmakwar na, Papakw akwar masa da vaɗ na, fa da pəlkwara mawurɓay ŋga sləra akwar a daa ba. ");
INSERT INTO mif_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Yaw, da ka vəlam dala a ndəhay masa-viya hay na, ka da wudam ta wudey anda ndəhay masa ta neneh cew ba. Ata na, fa kamara kəne daa *way-mewuzey-mey ŋga Gazlavay leŋ daa mepəkey ata hay, amba ndəhay aa həmdamata. Ya fa ləvkwar fara fara, meehəmey a ŋgene na, ara mawurɓay ŋga sləra ata. ");
INSERT INTO mif_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ama kah, da ka fa vəley dala a masa-viya hay na, vəlda ta mayal a, amba ndəhay a sərmara ba. ");
INSERT INTO mif_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Anda keɗe, Papakw Bay Gazlavay, ma hətar cek masa kah ma vəlda na, ara aŋga ma da pəlkawa mawurɓay akah.» ");
INSERT INTO mif_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Yaw, da akwar fa dəram daŋgay na, ka da kamara anda ndəhay masa ta neneh cew ba. Ata na, a wuɗam melecey ŋga dərey daŋgay daa *way-mewuzey-mey ŋga Gazlavay leŋ da mey-cəveɗ hay amba ndəhay tabiya a hətmatar. Ya fa ləvkwar fara fara, taa həmdamata cay, meehəmey a ŋgene na, ara mawurɓay ata. ");
INSERT INTO mif_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ama kah, da masa ka fa da dərey daŋgay na, daw a ver akah, gərca mey-slam, dərar daŋgay a Papakw Bay Gazlavay feteɗe, daa slam masa ndəhay da hwaɗ a daa ba. Anda keɗe, Papakw Bay Gazlavay, ma hətar sləra masa kah ma ka ta meɓey ŋgene na, ara aŋga ma da pəlkawa mawurɓay ŋga sləra akah. ");
INSERT INTO mif_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Da akwar fa dəram daŋgay na, ka da ɗulam mey ga anda ma ta kuley hay ba. Ata a wulkam na, Bay Gazlavay a cəndatara mey ata meɗuley ga ŋgene la. ");
INSERT INTO mif_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ka da kam anda ata ba, maja Papakw akwar Bay Gazlavay na, ta səra cek masa akwar ma daa cəfɗafamara sem. ");
INSERT INTO mif_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Da akwar fa dəram daŋgay na, ləvam: “Papa ala Bay Gazlavay da vaɗ, anja ndəhay tabiya ŋga namaka ray maja kah na, Bay Gazlavay pal. ");
INSERT INTO mif_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Anja bay akah ŋga wuzwa. Ka amba ya namaka ray da bəla keɗe anda ata ma namaka ray da vaɗ. ");
INSERT INTO mif_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Vəlndar cek mezəmey ŋga wusndar tasana. ");
INSERT INTO mif_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mbəkdandara mebərey ala anda ala ma mbəkdamatara mebərey ŋga ndəhay ma kamandar cek maaya ba. ");
INSERT INTO mif_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jəɗndar amba cek a batandar ŋga key mebərey ba. Badandərwa dasi har ŋga bay-malula.” Ahaw, ara kah Bay Gazlavay ta gədaŋ, ma wey da ray cek hay tabiya. Ara kah masa ndəhay ma həslmaka ray ŋga sərmataw. Amen. ");
INSERT INTO mif_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Sərmara, da akwar fa mbəkdamatara mebərey ŋga ndəhay ma kamakwar mebərey na, ŋgene, Papakw akwar masa da vaɗ a mbəkdakwara mebərey akwar la may. ");
INSERT INTO mif_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama da ka mbəkdamatara mebərey ŋga ndəhay ba na, ŋgene, Bay Gazlavay Papakw akwar a mbəkdakwara mebərey akwar daa ba may.» ");
INSERT INTO mif_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesu a ləvtar saya: «Masa akwar fa kam *daliyam na, ka da ndərɓam dey anda ndəhay masa ta neneh cew ma kamara ba. Ata na, a ndərɓam dey amba ndəhay tabiya a sərmara ata fa kam daliyam. Ya fa ləvkwar fara fara, taa həmdamata cay, meehəmey a ŋgene na, ara mawurɓay ŋga sləra ata. ");
INSERT INTO mif_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ama kah, da masa ka fa key daliyam na, pəra dey akah, njəra ray akah, ");
INSERT INTO mif_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","amba ndəhay a sərmara ka fa key daliyam ba. Ama, ma səra na, si Papakw Bay Gazlavay, ma hətar sləra masa kah ma ka ta meɓey ŋgene, a pəlkawa mawurɓay ŋga sləra akah la.» ");
INSERT INTO mif_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Ka da səpam ŋga ɓəcey zleley da bəla keɗe ba, maja kwa mətal, da daa ba, maaca a gwa ŋga zəma. Kwa mayal hay a gwamara ŋga slənmara way ŋga lalamara. ");
INSERT INTO mif_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ama səpam ŋga ɓəcey na, zleley masa da vaɗ, maja feteɗe na, mətal, da daa ba, maaca a gwa ŋga zəma ba. Kwa mayal hay a gwamara ŋga mbəzam feteɗe, ŋga lalamara ba. ");
INSERT INTO mif_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ya ləvey anda keɗe maja daa slam masa zleley akah aa da hwaɗ a na, mevel akah may aa feteɗe.» ");
INSERT INTO mif_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Bəz ŋga dey na, aŋga anda petərla ŋgada vaw tabiya. Da bəz ŋga dey akah aŋga maaya maaya na, ŋgene vaw akah cəpa aa daa slam-meweɗey. ");
INSERT INTO mif_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ama, da bəz ŋga dey akah maaya ba na, ŋgene, vaw akah cəpa aa daa ləvaŋ. Da meweɗey da ray akah fara fara daa ba na, ŋgene, kah daa ləvaŋ ɓək-ɓek.» ");
INSERT INTO mif_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yesu a ləvtar saya: «Ndaw pal a gwa ŋga key madərlam ŋga bay hay cew ba. Da ta key la kəne na, a da wuɗa bay laŋgar ma fəna bay laŋgar, da daa ba, a da nar ray ŋgada bay laŋgar, a rəsa bay laŋgar. Ka gwamara ŋga səpmara Gazlavay leŋ zleley cewete daa slam a ba. ");
INSERT INTO mif_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Maja ŋgene, ya fa ləvkwar fara fara, daa menjey akwar na, ray akwar a da həɓey da ray cek mezəmey ta cek mesey ba. Asaya, ray akwar a da həɓey da ray zana ŋga kəzley fa vaw akwar ba. Yaw, cek mezəmey na, a fəna heter akwar daw? Asaya, zana na, a fəna vaw akwar daw? ");
INSERT INTO mif_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","«Wulkam da ray ɗiyaŋ hay taw: fa sləkam daa ba, fa ŋgəmam daw daa ba, fa ɓəcam kwa meeme a wudeɗ daa ba, ama Papakw akwar Bay Gazlavay da vaɗ fa vəltar cek mezəmey cəŋga. Kaa akwar na, ka fənmata ɗiyaŋ hay, ba daw? ");
INSERT INTO mif_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ndaw da wuzlah akwar ma gwa ŋga pey kwa ɗar pal a ray ɗar aŋga da bəla ta mewulkey aŋga na, wa? ");
INSERT INTO mif_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Kaa, ka wulkam ga da ray zana na, maja me? Nəkmara meefekwey hay da ley cey! Aa fakwam na, kwara? A kam sləra ba, a cam zana ba, ");
INSERT INTO mif_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ama ya fa ləvkwar, kwa Bay *Salamaŋw zleezle ta zleley ga ta gwa ŋga kəzley zana ma mbey anda meefekwey pal na, daa ba. ");
INSERT INTO mif_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gazlavay a ka amba kusaf aa fekwey tasana, ama mandaw na, kusaf a, a wewurey. Da Gazlavay fa key cek maaya ŋgada kusaf masa awaw ma da wawura anda keɗe na, Gazlavay a nəkfakwar dey ma fəna kusaf a ŋgene daa ba daw? Akwar masa ma pamara Gazlavay ŋga ndaw akwar fara fara ba ŋgene, sərmara Gazlavay a kəzlakwar zana la ma fəna meefekwey hay a. ");
INSERT INTO mif_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Da ray ŋgene, ka da wulkam ga ba. Da ka ləvam: “Ya da zəmam me? Ya da sam me? Ya da kəzlam fa vaw me?” na, ka da wulkam kəne ba, ");
INSERT INTO mif_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","maja ma səpam cek hay a ŋgene na, ara ndəhay ma sərmara Gazlavay ba. Asaya, cek hay masa akwar ma wuɗam cəpa ha na, Papakw akwar da vaɗ ta səra sem. ");
INSERT INTO mif_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Səpam teeseɗ na, Gazlavay ŋga wey da ray akwar, asaya, kam cek anda aŋga ma wuɗey. Fa dəɓa ha, Bay Gazlavay a vəldakwara cek hay siya la cəpa. ");
INSERT INTO mif_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ya fa ləvkwar dəɓa, ka da wulkam ga fa cek ma da key mandaw ba, maja mewulkey ŋga mandaw na, aŋga wal. Mewulkey fa ɗar pal na, a wusa ŋgada ɗar a.» ");
INSERT INTO mif_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesu aa guzltar saya, a ləvtar: «Ka da wulkam daa mevel akwar, ka ləvam, “Anja manaŋ ŋgaa zəɗey maja mebərey aŋga” na, kəne ba, maja Bay Gazlavay a daa zəɗdakwar maja mebərey akwar kəne may. ");
INSERT INTO mif_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ya fa ləvkwar, Bay Gazlavay a daa zəɗdakwar daa sariya anda akwar ma wuɗam manaŋ na, ŋgaa zəɗey ŋgene may. Asaya, a da ɗəsla mey da ray akwar anda akwar ma ɗəslmara mey da ray ndəhay mekele may. ");
INSERT INTO mif_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","«Ka nəkey dey fa guzer daa dey ŋga məlmakw, ama hwadam mahura masa daa dey akah na, ka wulkey da ray a ba na, maja me? ");
INSERT INTO mif_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ka gwa ŋga ləvar ŋgada məlmakw, “Ɗagay, ya lakawa guzer daa dey akah la”, anja hwadam mahura daa dey akah daha gway na, kwara? ");
INSERT INTO mif_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kah, ndaw masa ta neneh cew! La hwadam daa dey akah la ɗagay, amba ka hətar dey njəɗ-njeɗ ŋga ley guzer daa dey ŋga məlmakw.» ");
INSERT INTO mif_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Cek hay maaya masa ŋgada Gazlavay na, ka da vəldamatara ŋgada gədey hay ba, maja a da tatərmawa a ray akwar. Asaya, ka da kəzlamata bersle akwar hay maaya asi salay ŋga vetem hay ba, maja a da mbərzlamata ta salay.» ");
INSERT INTO mif_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Cacəfɗam cek fa Bay Gazlavay, a vəldakwara la. Səpam cek fa Gazlavay, ka hətam la. Zəlam fa mey-mbew, a wurkwara la, ");
INSERT INTO mif_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","maja kwa waawa maa cəfɗafar cek na, a vəlar la. Kwa waawa ma səpey cek fa vəɗa na, a hətey la. Kwa waawa ma zəley fa mey-mbew na, a wurara la. ");
INSERT INTO mif_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Da bəzey akah aa cəfɗafaka makala na, ka vəlar aŋgwa la daw? ");
INSERT INTO mif_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Asaya, da aa cəfɗafaka ewet na, ka vəlar zezekw la daw? ");
INSERT INTO mif_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Akwar ndəhay malamba hay ma!, ka sərmara ŋga vəley cek maaya ŋgada bəz akwar hay. Da kəne na, kaa wara Papakw akwar Bay Gazlavay da vaɗ a vəltar cek maaya ŋgada ndəhay masa maa cəfɗafamara ba na, kwara? ");
INSERT INTO mif_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Anda keɗe, kamatar cek maaya a ndəhay anda akwar ma wuɗam a kamakwara kəne may. Keɗe he ara mey masa *kwakwas ŋga Mawiz leŋ ndəhay ma təla mey ŋga Gazlavay maa sərkadamara.» ");
INSERT INTO mif_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Səpam ŋga mbəzey na, ta daa mey-mbew meeŋgəlez e, maja mey-mbew maabaŋ a na, ara cəveɗ meezəɗey ndaw. Ma daw taa cəveɗ e na, aŋga ta banay daa ba. Ndəhay ga fa diyam ta da hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ama mey-mbew ŋga cəveɗ ma hendey ndaw aa heter mawiya na, ara mey-mbew meeŋgəlez e. Ma daw ta hwaɗ a na, aŋga ta banay. Ndəhay ma hətam ŋga daw ta da hwaɗ a na, ga daa ba.» ");
INSERT INTO mif_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Wam vaw fa ndəhay ma pamata ray ata ŋga ndəhay ma təla mey ŋga Gazlavay. A da samawa fa akwar na, ta meney ray zəkwaɓ zəkwaɓ anda təɓaŋ hay, ama a da kam həma na, anda gədey-ley hay. ");
INSERT INTO mif_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka da sərmata na, ta fa sləra ata hay maaya ba. Nəka, ndaw a gwa ŋga ŋgəley maŋgwara fa hatak-daw la daw? Da daa ba, ndaw a gwa ŋga ŋgəley gudav fa manjaraf la daw? ");
INSERT INTO mif_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Wudez maɗaɗakaya guɗaf! guɗaf! na, a yey babəza maaya maaya may. Wudez masa fa ɓetey ta ɓetey na, a yey babəza maaya ba may. ");
INSERT INTO mif_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Anda keɗe, wudez makuɗfafar a na, a yey babəza maaya ba na, daa ba. Yaw, wudez masa fa ɓetey ta ɓetey may, a yey babəza maaya na, daa ba. ");
INSERT INTO mif_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Wudez ma yey babəza maaya ba na, a ɗəslmara, a pamar awaw fa vəɗa. ");
INSERT INTO mif_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ara anda keɗe, ka da sərmata ndəhay ma pamata ray ata ŋga ndəhay ma təla mey ŋga Gazlavay na, ta fa sləra ata hay maaya ba may.» ");
INSERT INTO mif_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Sərmara ndəhay ma zəlmaya “Bay Mahura, Bay Mahura” na, fa da mbəzam cəpa a wuzlah ndəhay masa Gazlavay ma wey da ray ata na, daa ba. Ama ma da mbəzam na, si ndəhay ma kam cek ma mbafar a Papay Bay Gazlavay da vaɗ gway. ");
INSERT INTO mif_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ta pas masa yah ma da katar sariya a ndəhay tabiya na, ndəhay ga a ləvmaya la: “Bay Mahura, Bay Mahura, mey ŋga Gazlavay masa ala ma wuzdamara na, ara ta mezəley akah. Malula hay masa ala ma ɓəlmata da ray ndəhay ga na, ara ta mezəley akah. Asaya, maazla hay ga masa ala ma kamata na, ara ta mezəley akah, ba diya?” ");
INSERT INTO mif_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Anda keɗe, ya daa guzltar ta’ a mey, ya ləvtar: “Kwa ya sərkwar ba səlak! Diyam dəreŋ ta yah, akwar ndəhay ma kam cek hay malamba.”» ");
INSERT INTO mif_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Yaw, kwa waawa ma cənda mey aɗaw keɗe, ma ka cek anda mey a la na, aŋga anda ndaw masa ta leŋgesl, ma ləma way aŋga da ray pəraɗ. ");
INSERT INTO mif_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ta piya, bərgadaŋ a kawa a ray way a, var a pey, wayam a ley. Ama way a, a bəzley ba, maja salay ŋga way a mapakaya da ray pəraɗ. ");
INSERT INTO mif_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ama kwa waawa ma cənda mey aɗaw keɗe, ma ka cek anda mey a daa ba na, aŋga anda ndaw manjar leŋgesl, ma ləma way aŋga da ray mawurɓay. ");
INSERT INTO mif_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ta piya, bərgadaŋ a kawa a ray way a, var a pey, wayam a ley. Way a kərep! a bəzley, kwa dey laŋgar ma mbəkey daa ba.» ");
INSERT INTO mif_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Fa dəɓa ha Yesu ma ndəvda ŋgaa sərkadata ndəhay cay da ray mey hay a ŋgene na, ndəhay a, a rəzlam da ray meesərkedey aŋga ha, ");
INSERT INTO mif_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","maja aa sərkadata ndəhay anda ndəhay ata hay maa sərkada *kwakwas ŋga Mawiz ba, ama aa sərkadata na, ta gədaŋ masa Gazlavay ma vəldara. ");
INSERT INTO mif_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Fa dəɓa ha, Yesu a bərŋgawa da aŋgwa heyey, ndəhay ga fa səpmar wurzay. ");
INSERT INTO mif_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ndaw-maasəkula daha a ŋgəchey a cakay a, a regedey fa mey aŋga, a ləvar: «Bay aɗaw, da ka wuɗey na, ka gwa ŋga pərya daa maasəkula aɗaw keɗe.» ");
INSERT INTO mif_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu tal! a təlda har aŋga, a gəsfar, a ləvar: «Ya wuɗey amba maasəkula akah a pərey. Tərey ndaw mapərkaya dəɓa!» Wure wure ŋgene, ndaw-maasəkula heyey saɗ! a səɗey. ");
INSERT INTO mif_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ta’, Yesu a ləvar: «Pey leŋgesl, ka da wuzda cek masa yah ma kakawa keɗe kwa a ndaw ba. Ama daw fa *ndaw ma ka kwakwas ŋga Gazlavay, amba a nəkaka. Fa dəɓa ha, vəlar cek a Gazlavay anda *kwakwas ŋga Mawiz ma ləvey, ŋga wuzey a ndəhay, maasəkula fa vaw akah daa saba.» ");
INSERT INTO mif_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu fa daw a Kapernayum. Masa aŋga fa daw na, ndaw Rawma daha, aŋga mahura ŋga sewje hay temere, a ŋgəchey a cakay a. A kar ambahw amba Yesu a jəna, ");
INSERT INTO mif_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","a ləvar: «Bay aɗaw, madərlam aɗaw, aŋga manakaya da way daa macay. Maahəlɓakaya, fa sərey banay kalah.» ");
INSERT INTO mif_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu a mbəɗdara, a ləvar: «Ya fa daw, ya mbəlda la.» ");
INSERT INTO mif_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ama mahura ŋga sewje hay heyey a ləvar: «Bay aɗaw, kwa ya ta wusa amba ka mbəzey a way aɗaw na, daa ba. Gweguzley mey pal gway na, madərlam aɗaw a, a mbəley la. ");
INSERT INTO mif_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ya ləvka anda keɗe maja yah na, sewje hay mahura da ray aɗaw daha, asaya, yah mahura da ray sewje hay mekele may. Da ya ləvar ŋgada sewje laŋgar “daw”, a daw. Da ya ləvar ŋgada ndaw laŋgar “sawa”, a sawa. Da ya ləvar ŋgada beke aɗaw “ka sləra keɗe”, a ka.» ");
INSERT INTO mif_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Masa Yesu ma cənda mey a keɗe la na, a mbafar ara mey ba, ta’, aa guzltar ŋgada ndəhay ma diyam asiya, a ləvey: «Ya fa ləvkwar fara fara, kwa ya ta hətey ndaw ma paya ŋga ndaw aŋga fara fara anda ndaw keɗe daa ba səlak, kwa da wuzlah səkway aɗaw hay *Israyel hay, ya ta hətey daa ba. ");
INSERT INTO mif_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ya fa ləvkwar: Ta pas masa Gazlavay ma da wuzdərwa bay aŋga na, ndəhay ga a samawa la daa slam hay tabiya da bəla, ŋga key gwagway da vaɗ ta ata *Abəraham, *Izak leŋ *Jakwap. ");
INSERT INTO mif_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama ndəhay masa ma yamawa da wuzlah səkway ŋga ndəhay ŋga Gazlavay na, a da kəzlamata aa ambaw aa ləvaŋ. Feteɗe na, a da təwam, a daa pəɗam sler.» ");
INSERT INTO mif_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ta’, Yesu aa guzlar a mahura ŋga sewje hay heyey, a ləvar: «Daw a way dəɓa. Anja cek masa kah ma wuɗey keɗe na, ŋga key, anda kah ma təɓa mey aɗaw keɗe.» Wure wure ŋgene madərlam aŋga heyey mbal! a mbəley. ");
INSERT INTO mif_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Cay, ta’, Yesu a daw a way *Piyer. A hətfar mamaŋ ŋga ŋgwas ŋga Piyer e, vaw fa car, manakaya, awaw fa vaw ga. ");
INSERT INTO mif_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu ta’, a gəsfar fa har. Da ray ŋgene, awaw fa vaw heyey daa saba. Ŋgwas aha pərta! a lecey, ta’, a vəlar cek mezəmey a Yesu a. ");
INSERT INTO mif_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Taa kwaɗ a ŋgene, a handamawa ndəhay ga ta malula hay da ray. Yesu aa guzltar mey pal, ta’, malula hay da ray ndəhay a, a bam. Asaya, a mbəldata ndəhay masa-macay hay tabiya. ");
INSERT INTO mif_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Cek aha ta key la anda *Izay, *ndaw ma təla mey ŋga Gazlavay maa guzley zleezle, ma ləvey: «Ara aŋga ta ray aŋga ma jənndakwar daa bəle aləkwa, asaya, ara aŋga ma mbəldandakwar daa macay aləkwa hay tabiya.» ");
INSERT INTO mif_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Masa Yesu ma nəkta ndəhay ga fa zlərmar ray na, ta’, a ləvtar a gula aŋga hay amba a zləŋgam a dey laŋgar ŋga dəhwa ŋga *Galile. ");
INSERT INTO mif_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Daa ŋgene, *ndaw maa sərkada kwakwas ŋga Mawiz daha a ŋgəchey a cakay a, aa guzlar, a ləvar: «Bay aɗaw, kwa aa slam wura wura masa kah ma da daw na, ya daw la asi akah.» ");
INSERT INTO mif_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu a mbəɗdara, a ləvar: «Mbiga hay, ata ta vəgeɗ ata hay, ɗiyaŋ hay, ata ta way ata hay. Ama yah, *Bəz ŋga Ndaw na, kwa slam ŋga ney nekəɗey amba ya məskey vaw da hwaɗ a na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ndaw mekele da wuzlah ndəhay ŋga Yesu heyey, a sawa, a ləvar: «Bay aɗaw, vəlya cəveɗ amba ya daw ya jəhərwa papay la ɗagay.» ");
INSERT INTO mif_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu a mbəɗdara, a ləvar: «Sawa asi aɗaw, mbəkdata ndəhay maməctakaya ŋga jəhmata ndəhay ata hay maməctakaya.» ");
INSERT INTO mif_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Cay, Yesu kula! a mbəzey aa kwambiwal, gula aŋga hay ta’, a diyam bama. ");
INSERT INTO mif_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Daa masa kwambiwal a fa daw na, wure ŋgene memeɗ mahura aa bərey a ray yam, mendərey nekəɗey vaŋgwala ŋga yam a sərta kwambiwal a. Daa ŋgene, Yesu na, manakaya daa ɗar. ");
INSERT INTO mif_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ta’, gula aŋga hay, a ŋgəcham a cakay a, a sləkɗadamara, a ləvmar: «Bay Mahura, sləkɗey, ləhdandakwar! Aləkwa fa da məckwa.» ");
INSERT INTO mif_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu a mbəɗdatara, a ləvtar: «Ka zluram na, maja me? Akwar fa padamara Gazlavay ŋga ndaw akwar fara fara daa ba daw?» Pərta! a sləkɗey, ta’, aa bəctar ŋgada memeɗ ta yam heyey. Memeɗ deŋ! a lecey, yam a wusey saba. ");
INSERT INTO mif_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Da ray ŋgene, ndəhay a rəzlam, a ləvam da wuzlah ata: «Ndaw a keɗe na, ara na, wa? Masa kwa memeɗ ta yam a cənmar mey keɗe na!» ");
INSERT INTO mif_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Daa masa Yesu ma wusey la a dey laŋgar ŋga dəhwa ŋga *Galile heyey, masa daa hwayak ŋga ndəhay Gederen hay na, ndəhay cew daha ta malula da ray fa bamawa daa cəvay hay mavavərkwatakaya daa aŋgwa, a cam ray ta Yesu. Ndəhay a, fa zlazləɓam ndəhay ara mey ba, kwa ndaw ma gwa ŋga daw taa cəveɗ e ŋgene daa ba. ");
INSERT INTO mif_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ndəhay a, a wudam ta gədaŋ, a ləvmar a Yesu: «Kah, Bəzey ŋga Gazlavay, ka wuɗey fa ala na, me? Ka sawa ŋga sərdandar banay dəga pas ŋga sariya araŋ daw?» ");
INSERT INTO mif_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Da feteɗe na, ŋgaɓa ŋga vetem hay ga daha da mecəkwer gweegwe ta ata. ");
INSERT INTO mif_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Malula hay da ray ndəhay kaa heyey a bərkwamara Yesu, aa cəfɗamara, a ləvmar: «Da ka da ɓəlndar na, vəlndar cəveɗ amba ya diyam ya mbəzam aa vetem hay katay.» ");
INSERT INTO mif_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ta’, Yesu a ləvtar: «Diyam, mbəzam.» Da ray ŋgene, a bam da ray ndəhay keɗe heyey, a diyam a mbəzam a ray vetem hay a. Ta’, vetem hay a cəpa, a hwam ta gədaŋ ŋgadaa heeleŋ, a tataram, a kwiyam saf! aa yam, aa zəɗam kuɗap! feteɗe. ");
INSERT INTO mif_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mecəkwer hay ŋga vetem hay kaa heyey takw! a həlmara mahway a slala, a kadamatara mey a leŋ mey da ray ndəhay ta malula da ray heyey cəpa ŋgada ndəhay da slala ha. ");
INSERT INTO mif_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Da ray ŋgene, ndəhay tabiya da slala ha a bamawa, a cadamara ray ta Yesu. Ta’, a bərkwamara ŋga daw la daa hwayak ata ha. ");
INSERT INTO mif_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Fa dəɓa ha, Yesu a təpey aa kwambiwal, a vəhey a dey laŋgar ŋga dəhwa, a daw a slala aŋga. ");
INSERT INTO mif_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ta’, a handamar ndaw maahəlɓakaya daha, manakaya da ray ɓeɓele. Masa Yesu ma nəka ndəhay a, fa təɓmara aŋga ta gədaŋ ŋga mbəlda ndaw ata na, ta’, a ləvar a ndaw maahəlɓakaya heyey: «Dəka mevel, bəz aɗaw! Mebərey da ray akah daa saba.» ");
INSERT INTO mif_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Feteɗe na, ndəhay maa sərkada kwakwas ŋga *Mawiz daha, a wulkam daa ray ata, a ləvam: «Ndaw a keɗe, a pa ray aŋga ŋga Gazlavay na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu a səra mewulkey ata. Da ray ŋgene, aa cəfɗata, a ləvtar: «Ka wulkam maaya ba anda keɗe na, maja me? ");
INSERT INTO mif_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ya gwa ya ləvey: “Mebərey akah daa saba” da daa ba, ya gwa ya ləvey: “Sləkɗey, daw ta salay akah.” Dasi mey hay cewete keɗe na, masa ta banay ŋga ləvey ŋgada yah na, wura? ");
INSERT INTO mif_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yaw, ya wuɗey ka sərmara, yah *Bəz ŋga Ndaw, yah ta gədaŋ ŋga mbəkey mebərey ŋga ndəhay da bəla keɗe. Wure keɗe, ka hətmar cek ma da key la.» Anda keɗe, Yesu, ta’, a ləvar a ndaw maahəlɓakaya heyey: «Sləkɗey, la ɓeɓele akah, daw a way!» ");
INSERT INTO mif_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ndaw aha pərta! a sləkɗey, ta’, a daw a way. ");
INSERT INTO mif_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Daa masa ndəhay makustakaya ma hətmar cek aha mekey na, a zluram, a rəzlam. A həlmamara Gazlavay maja aŋga ma vəlar gədaŋ mahura anda keɗe a ndaw-magədaŋ. ");
INSERT INTO mif_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu a sləkɗey daa slam aha, a daw. Masa aŋga fa daw na, a hətar ndaw daha mezəley *Matiye. Aŋga manjakaya fa key sləra daa slam mecekeley budaw. Ta’, Yesu aa guzlar, a ləvar: «Sawa, səpya.» Da ray ŋgene, Matiye pərta! a sləkɗey, ta’, a daw asiya. ");
INSERT INTO mif_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Fa dəɓa ha nekəɗey, Yesu a daw ŋga zəmey ɗaf da way Matiye he. Daa way a, ata Yesu ta gula aŋga hay a zəmamara ɗaf a na, ta ndəhay ma cakala budaw ga leŋ ta ndəhay ma zləɓa *kwakwas ŋga Mawiz. ");
INSERT INTO mif_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Masa *Fariza hay ma hətmatar fa zəmam ɗaf bama ta ndəhay a na, ta’, a ləvmatar a *gula hay ŋga Yesu: «Bay akwar a zəmam ɗaf ta ndəhay ma cakala budaw leŋ ta ndəhay ta mebərey hay na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ma cənda mey a na, ta’, aa guzltar, a ləvtar: «Ndəhay masa wurwer na, mey ata ta ndaw ma vəlda slalak daa ba. Ama ma wuɗey mey ŋga ndaw ma vəlda slalak na, si ndəhay masa-macay hay gway. ");
INSERT INTO mif_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ehe, sərmara mey ŋga Gazlavay mawuzlalakaya daa ɗerewel aŋga, a ləvey: “Ya wuɗey na, ndəhay a səram dey-ceceh fa ndəhay, ba na, a hərmaya gənaw hay ba.” Yaw, ndəhay ma wulkam ata ndəhay maaya fa mey ŋga Gazlavay na, Gazlavay ta slərdiwa ŋga zəlta daa ba, ama a slərdiwa na, ŋga zəley ndəhay ta mebərey.» ");
INSERT INTO mif_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Fa dəɓa ha, gula hay ŋga *Jaŋ-Baptis a ŋgəcham a cakay Yesu, aa cəfɗamara, a ləvmar: «Ala ta ndəhay *Fariza hay na, ala fa kam *daliyam , ama gula akah hay na, a kam daliyam ba səlak na, maja me?» ");
INSERT INTO mif_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu a mbəɗdatara ta mey-meŋgey, a ləvey: «Da ndaw a zəlwa ndəhay aa mekey məlak ŋga kwakwa ŋga zəmey cek na, ndəhay a, aa səmam da cakay zel-kwakwa ha daa ba daw? Ta pas ŋgene a kam daliyam ba. Ama pas a, a sawa la masa ata ma da kərzamara zel-kwakwa ha na, a kam daliyam la dəɓa. ");
INSERT INTO mif_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Yaw, ndaw a gwa ŋga ɗəpa zana magurma ta zana mawiya daw? A key ba, maja zana mawiya maɗəpkaya na, a nəsa zana magurma ha la, zana magurma ha a da ŋgərey a dey a. ");
INSERT INTO mif_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","«Asaya, ndaw a gwa a zlərey wuzam meedeɗek e aa kwene-kwene magurma ba. Da a zləra a hwaɗ a na, wuzam a, a məsley, a ŋgəra kwene-kwene he la. Anda keɗe, wuzam a leŋ kwene-kwene he a nəsam la cewete. Da ŋga key maaya na, si ndaw a zləra wuzam meedeɗek e na, aa kwene-kwene mawiya. Anda keɗe, wuzam a, aa daha, kwene-kwene may aa daha, cewete a nəsam ba.» ");
INSERT INTO mif_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Daa masa Yesu faa guzltar anda ŋgene na, ndaw mahura daa *way-mewuzey-mey ŋga Gazlavay a sawa fa aŋga, ta’, a regedey fa mey aŋga, a ləvar: «Dam aɗaw ta məcey sem wure wure keɗe. Ama ya fa kaka ambahw, sawa, pa har akah a ray a amba a hətar mesəfney aŋga aa slam a cəŋga.» ");
INSERT INTO mif_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Da ray ŋgene, Yesu a lecey, a diyam asiya ta gula aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ŋgwas daha, mambaz fa mbəɗwa da hwaɗ dəga mevey kuraw a ray a cew. Daa masa Yesu fa daw na, ŋgwas aha a ŋgəchey a cakay a ta fa dəɓa, ta’, a gəsfar har fa mey ŋga zana ŋga Yesu a. ");
INSERT INTO mif_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A ka anda keɗe maja aŋga fa wulkey daa mevel aŋga, a ləvey: «Da ya gwa ŋga gəsfar har kwa fa zana aŋga na, ya mbəley la.» ");
INSERT INTO mif_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu pəla! a mbəɗey dey fa dəɓa, a nəka ŋgwas aha, ta’, a ləvar: «Dəka mevel, dam aɗaw! Ka ta mbəley cay maja kah ma paya ŋga ndaw akah fara fara.» Wure wure ŋgene, ŋgwas aha ta mbəley cay. ");
INSERT INTO mif_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Fa dəɓa ha, Yesu a wuswa a way ndaw mahura heyey. A hətfatar ndəhay ma fa sləlam, asaya ndəhay makustakaya fa mbəɗam haya! haya! ");
INSERT INTO mif_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ta’, a ləvtar a ndəhay a: «Hwam la feɗe! Dam aha ta məcey daa ba, ama a key a ney aa ɗar.» Ndəhay a, aa saŋgəram da ray a. ");
INSERT INTO mif_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Daa masa ndəhay a ma bamawa sem aa ambaw na, Yesu a mbəzey a way a, ta’, a kərza dam aha fa har. Dam a pərta! a sləkɗey. ");
INSERT INTO mif_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mey da ray dam aha, a cəney aa wura aa wura tabiya daa hwayak a. ");
INSERT INTO mif_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Masa Yesu ma sləkɗey da way ndaw mahura heyey la na, wulaf hay cew daha, a səpmar wurzay ta mewudey, a ləvam: «Sərfandar dey-ceceh, may taw, Bəzey ŋga *Davit!» ");
INSERT INTO mif_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu a wusey a way na, wulaf hay cew heyey, a mbəzam asiya. Ta’, Yesu aa cəfɗata, a ləvtar: «Ka wulkam na, ya gwa ŋga wurkwara dey akwar daw?» A mbəɗdamara, a ləvmar: «Ahaw, Bay Mahura.» ");
INSERT INTO mif_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Da ray ŋgene, aŋga gas! gas! a gəsfatar har fa dey ŋga wulaf hay a, ta’, a ləvtar: «Dey akwar ŋga wuram anda akwar ma təɓmara ya gwa ŋga wurkwara.» ");
INSERT INTO mif_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Dey ata wur! wur! a wuram. Yesu a kətata, a ləvtar: «Jəkam sləmay maaya maaya, ndaw a da cənda cek masa ma key ta akwar keɗe ba.» ");
INSERT INTO mif_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama ndəhay cew kaa heyey, a mbəkdamara slam aha nekəɗey na, ta’, a kadamara mey da ray Yesu a ndəhay daa hwayak a tabiya. ");
INSERT INTO mif_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Masa ndəhay Yesu ma wurtara dey heyey fa bamawa da way a la na, ta’, a handamar ndaw daha ma gwa ŋgaa guzley ba, maja aŋga ta malula da ray. ");
INSERT INTO mif_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ta’, Yesu a ɓəla malula da ray ndaw a, ndaw aha aa guzley dəɓa. Da ray ŋgene, ndəhay tabiya feteɗe a rəzlam, a ləvam: «Dəga ŋga menjey aləkwa, ya ta hətkwa cek ma key anda keɗe daa hwayak ŋga *Israyel keɗe daa ba.» ");
INSERT INTO mif_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ama ndəhay *Fariza hay na, aa guzlam, a ləvam: «Ara bay ŋga mesəfney maaya ba hay ma vəlar gədaŋ ŋga ɓəley malula da ray ndəhay.» ");
INSERT INTO mif_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu fa pəkta berney hay ta slala hay masa gweegwe ta dəhwa ŋga *Galile. Feteɗe faa sərkadata ndəhay daa way ata hay mewuzey mey ŋga Gazlavay, fa wuzey *Mey-maaya-mawiya da ray *mewey ŋga Bay Gazlavay da ray ndəhay, asaya, fa mbəley ndəhay daa macay hay wura wura cəpa leŋ ndəhay maahəlɓatakaya tabiya. ");
INSERT INTO mif_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Masa Yesu ma hətatar ndəhay makustakaya na, dey-ceceh a kar maja a gəram, gədaŋ ata daa saba, ata anda təɓaŋ hay manjar mecəkwer. ");
INSERT INTO mif_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Maja ŋgene ta’, a ŋgatar mey a gula aŋga hay, a ləvtar: «Cek ta key la ga da ley , ama ndəhay pəreh ŋga kamərwa ŋgada way. ");
INSERT INTO mif_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Anda keɗe, kamar ambahw a bay ŋga ley a, ŋga slərwa ndəhay mekele saya a dey a ŋga kawa cek hay da ley a.» ");
INSERT INTO mif_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Fa dəɓa ha, Yesu ta’, a zəlta gula aŋga hay kuraw a ray a cew amba a slərdata ŋga key sləra aŋga. A vəltar gədaŋ ŋga ɓəley malula hay da ray ndəhay, asaya, ŋga mbəley ndəhay daa macay hay wura wura cəpa, leŋ ndəhay maahəlɓatakaya tabiya. ");
INSERT INTO mif_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ndəhay meslərey kuraw a ray a cew e na, ara *Simaŋw, ndaw masa ma zəlmara *Piyer ta məlmaha *Andəre, *Jak ta məlmaha *Jaŋ, ata cewete bəza hay ŋga Zebede, ");
INSERT INTO mif_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","*Fəlep, *Bartelemey, *Tuma, *Matiye, *ndaw ma cakala budaw, Jak, bəzey ŋga Alfe, Taade, ");
INSERT INTO mif_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simaŋw, ndaw da wuzlah ndəhay ma wuɗam ŋga ləhdamata ndəhay ata hay dasi har ŋga masa-gəra ata hay, leŋ Juda Iskariyawt, ndaw ma vəlda Yesu a har masa-gəra aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Yesu a slərdata gula aŋga hay kuraw a ray a cew heyey, a kətata, a ləvtar: «Diyam fa ndəhay *Israyel hay. Ata maazəɗtakaya anda təɓaŋ hay maa zəɗam. Ama a slala ndəhay masa *Jəwif hay ba hay na, ka da diyam ba. Ka da diyam a slala *Samari hay ba may. ");
INSERT INTO mif_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Da akwar fa diyam daa cəveɗ na, wuzdamatara a ndəhay, ləvmatar, “Gweegwe cay, bay ŋga Gazlavay a wuzwa.” ");
INSERT INTO mif_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mbəldamata masa-macay hay, sləkɗadamatərwa ndəhay maməctakaya, pərmata maasəkula hay, ɓəlmata malula hay da ray ndəhay. Gədaŋ a na, ya vəldakwara ŋga maaya. Yaw, akwar may, kamatara ŋga maaya. ");
INSERT INTO mif_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Da akwar fa diyam na, ka da lam dala a har ba. ");
INSERT INTO mif_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ka da diyam ta gabal da har ba, kwa ta zana hay cew ba. Ka da diyam kwa ta tarak ba, kwa ta zlanday ba. Maja ndaw ma ka sləra na, si a hətey cek mezəmey maja sləra aŋga. ");
INSERT INTO mif_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Da akwar ma wusam la aa berney, da daa ba, a slala na, səpam ndaw masa ma wuɗey ŋga təɓkwar. Njam da way aŋga haa kasl pas masa akwar ma da diyam. ");
INSERT INTO mif_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Da akwar fa mbəzam a way ndaw na, ka camatar har, ka ləvmatar: “Maaya ŋga Gazlavay ŋga sawa a ray akwar.” ");
INSERT INTO mif_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Da ndəhay da way a ta təɓmakwar la na, cacəfɗamara Gazlavay amba maaya aŋga a njey a ray ata. Ama da ta təɓmakwar daa ba na, cacəfɗamara Gazlavay amba a la maaya aŋga ha la da ray ata. ");
INSERT INTO mif_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Da way, da daa ba, da slala masa ndəhay da hwaɗ a, a gəmam ŋga təɓmakwar ba, asaya, a gəmam ŋga cəndamara mey akwar ba na, raramatara lagwada fa salay akwar hay , bam la da way a, da daa ba, da slala ha. ");
INSERT INTO mif_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ya fa ləvkwar fara fara, ta pas ŋga sariya na, Gazlavay a da sərdata banay ta ndəhay daa berney a ŋgene ma fəna ŋga ndəhay daa berney ŋga *Sadawm ta ŋga *Gwamar .» ");
INSERT INTO mif_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesu a patar leŋgesl, a ləvtar: «Jəkam sləmay, ya fa slərdakwar anda təɓaŋ hay ŋgada wuzlah gədey-ley hay. Anda keɗe, wam vaw fa ndəhay anda zezekw hay ma wam vaw fa ray ata. Təram ndəhay meekweɗ-mey anda makurgwadakw hay. ");
INSERT INTO mif_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wam vaw, maja a kərzamakwar la, a handamakwar la fa mey ŋga ndəhay ma ka sariya. Asaya, a sləɗmakwar la daa way ata hay mewuzey mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","A ɗaɗamakwar la fa mey ŋga ndəhay mahura hay leŋ fa mey ŋga bay hay maja akwar ndəhay aɗaw hay. Gazlavay a pəskatar mey la ŋga handamakwar amba ka kam sede da ray aɗaw fa mey ata leŋ fa mey ŋga ndəhay masa *Jəwif hay ba hay. ");
INSERT INTO mif_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Da ta handamakwar la aa sariya na, ka da həɓam ray da ray mey masa akwar ma daa guzldamara ba, maja mey masa akwar ma daa guzldamara ŋgene na, a bawa la daa masa akwar faa guzlam. ");
INSERT INTO mif_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yaw, mey a, a da bawa ta fa akwar ba, ama ara Mesəfney ŋga Papakw akwar Bay Gazlavay ma da balakwara mey a. ");
INSERT INTO mif_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Ndəhay a vəldamata məlma ata hay la ŋga kəɗey vagay. Papaŋ hay may, a vəldamata bəz ata hay la kəne. Bəza hay a kam həma la a ray papa ata hay ta mama ata hay, amba ndəhay a kəɗmata vagay. ");
INSERT INTO mif_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ndəhay cəpa a da ŋgəldamakwar ba maja yah. Ama ndaw ma ɓəsa banay a la haa kasl mendəvey a na, Gazlavay a ləhda la. ");
INSERT INTO mif_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Da fa sərdamakwar banay da slala na, diyam a slala mekele. Ya fa ləvkwar fara fara, ta pas masa yah, *Bəz ŋga Ndaw, ma da vəhwa na, akwar ma ndəvdamara sləra akwar da slala hay tabiya ŋga *Israyel daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Ndaw maa sərkey na, a səra cek a fəna ndaw maa sərkada ba. Ndaw ma ka sləra na, mahura da ray bay aŋga ba. ");
INSERT INTO mif_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ndaw maa sərkey na, a da tərey anda ndaw maa sərkada ha gway. Ndaw ma ka sləra na, a da tərey anda bay ŋga sləra ha gway. Yaw, akwar na, anda ndəhay da way aɗaw, da ta zəlmaya “*Beyelzebul ” sem na, ŋgene he, akwar ndəhay da way aɗaw, a da cəɗmakwar ma fəna.» ");
INSERT INTO mif_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Da ray ŋgene, ka da zluram ta ndəhay ba. Cek tabiya masa ndəhay ma ɓadamara, a wuzwa la a palah, cek hay masa ndəhay ma sərmara ba na, a sərmara la. ");
INSERT INTO mif_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mey masa yah ma wuzdakwara ta mayal a keɗe na, wuzdamərwa a palah. Yaw, mey aɗaw masa akwar ma cəndamara ta mey-meesəkey keɗe na, təpam aa ray ŋga aŋgwa, wudmara ta gədaŋ a ndəhay tabiya. ");
INSERT INTO mif_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ka da zluram ta ndəhay ma da kəɗmakwar vagay ba, maja a da kəɗam na, vaw akwar daada gway, ama a gwamara a ray mesəfney akwar ba. Zluram na, si ta Gazlavay gway. Aŋga na, a gwa ŋga kəzla vaw akwar ta mesəfney akwar aa vəgeɗ ŋga awaw magaza. ");
INSERT INTO mif_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ɗiyaŋ mecəhe mecəhe cew na, a gwa ŋga həɗkedey dala pal daada, ba daw? Ama kwa ɗiyaŋ mecəhe pal fa da kəzlwa a hwayak ŋgaa zəɗey na, daa ba, si Papakw akwar Bay Gazlavay ma vəlda cəveɗ ŋgaa zəɗda. ");
INSERT INTO mif_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Akwar may, kwa eŋgwec ŋga ray akwar hay na, masləftakaya pal pal tabiya. ");
INSERT INTO mif_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yaw, maja ŋgene, ka da zluram ba. Akwar na, Gazlavay a wuɗkwar a fəna ɗiyaŋ hay mecəhe mecəhe ga ŋgene, ba daw? ");
INSERT INTO mif_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Kwa waawa ma ləvey fa mey ŋga ndəhay, aŋga ndaw aɗaw na, ŋgene, yah, ya da ləvey fa mey ŋga Papay da vaɗ, aŋga, ndaw aɗaw may. ");
INSERT INTO mif_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama ndaw ma ləvey fa mey ŋga ndəhay, a sərya ba na, ŋgene, ya da ləvey fa mey ŋga Papay da vaɗ, ya səra ndaw a ba may.» ");
INSERT INTO mif_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesu a patar leŋgesl saya, a ləvtar: «Ka da wulkam ya sawa ŋga handawa zazay a bəla na, kəne ba. Fara fara, ya sawa na, ŋga handawa zazay ba, ama ya handawa vəram. ");
INSERT INTO mif_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ya sawa na, amba ya wunkatar ɗay ŋga bəz-mezəle ta papaha, ŋga dam-maŋgusa ta mamaha, leŋ ŋga ŋgwas ta mamaŋ ŋga zel e. ");
INSERT INTO mif_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kwa da way ndaw pal na, ndəhay siya hay a da təram masa-gəra ŋga siya hay. ");
INSERT INTO mif_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Kwa waawa ma wuɗa papaha ta mamaha kalah a fəna aŋga ma wuɗya na, ta wusa ŋga njey ta yah daa ba. Asaya, kwa waawa ma wuɗta bəz aŋga hay ta dam aŋga hay kalah a fəna aŋga ma wuɗya na, ta wusa ŋga njey ta yah daa ba. ");
INSERT INTO mif_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kwa waawa ma ɓəsa banay ma da sawa a ray a maja yah daa ba na, ta wusa ŋga njey ta yah daa ba. Asaya, kwa waawa ma səpya daa ba na, aŋga ta wusa ŋga njey ta yah daa ba may. ");
INSERT INTO mif_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yaw, kwa waawa ma wuɗey ŋga ləhda heter aŋga na, aa zəɗda la. Ama ndaw ma vəlda heter aŋga maja yah na, a hətar la aa slam a.» ");
INSERT INTO mif_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Kwa waawa ma təɓkwar la ta meesəmey na, a key a təɓey ŋgene na, yah. Ndaw ma təɓya na, a key a təɓey ŋgene na, ndaw ma slərdiwa. ");
INSERT INTO mif_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yaw, kwa waawa ma təɓa *ndaw ma təla mey ŋga Gazlavay ta meesəmey, maja a səra, aŋga ndaw ma təla mey ŋga Gazlavay na, a hətey mawurɓay ŋga sləra aŋga la anda ŋga ndaw ma təla mey ŋga Gazlavay. Yaw, kwa waawa ma təɓa ndaw maja a səra, ara ndaw maaya fa mey ŋga Gazlavay na, a hətey mawurɓay ŋga sləra aŋga la anda ŋga ndaw maaya ha may. ");
INSERT INTO mif_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kwa waawa ma vəlar yam makəslkaya ŋgada ndaw pal da wuzlah akwar, masa ma pa ray aŋga ŋga mecəhe, maja a səra, aŋga gula aɗaw na, ya fa ləvkwar fara fara, a hətey mawurɓay ŋga sləra aŋga la.» ");
INSERT INTO mif_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Masa Yesu ma kətata ndəhay aŋga hay meslərey kuraw a ray a cew heyey cay na, pərta! a sləkɗey, a daw ŋga wuzey *Mey-maaya-mawiya ŋgada ndəhay da slala hay feteɗe. ");
INSERT INTO mif_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","*Jaŋ-Baptis, aŋga daa fərsəne. Daa masa aŋga daa fərsəne he na, a cənda mey da ray sləra ŋga Yesu *Kəriste. Ta’, a slərey gula aŋga hay siya fa Yesu a ");
INSERT INTO mif_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ŋgaa cəfɗamara, a ləvmar: «Kah na, Kəriste, ndaw ma da sawa ŋga ləhdata ndəhay heyey daw? Da daa ba, ya səkwam ndaw mekele ma da sawa daw?» ");
INSERT INTO mif_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu a mbəɗdatara, a ləvtar: «Diyam, kadamara cek masa akwar ma cəndamara ta sləmay akwar, ta masa akwar ma hətmar ta dey akwar keɗe a Jaŋ-Baptis. ");
INSERT INTO mif_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ləvmar na, wulaf hay fa hətmar dey dəɓa, jegwer hay fa diyam maaya maaya ta salay ata, maasəkula hay ta səɗam sem, madagazlam hay fa cənam sləmay, ndəhay maməctakaya fa sləkɗamawa daa meməcey, ndəhay masa-viya hay fa cəndamara Mey-maaya-mawiya dəɓa. ");
INSERT INTO mif_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ndaw ma mbəkda mey aɗaw ba maja sləra masa yah ma ka na, maaya ŋga Gazlavay aa da ray a.» ");
INSERT INTO mif_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Masa gula hay ŋga *Jaŋ-Baptis ta diyam sem na, Yesu aa guzltar mey da ray Jaŋ-Baptis a, a ndəhay, a ləvtar: «Akwar ma diyam a wuzlah-ley na, ŋga nəkwa me? Ka nəkmawa na, guzer masa memeɗ ma wusa daw? Ara aŋga ba, ba diya? ");
INSERT INTO mif_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kaa, akwar ma diyam ŋga nəkwa na, me? Ka nəkmawa na, ndaw masa ma pey zana maaya fa vaw daw? Anja ndəhay masa ma pam zana maaya fa vaw na, ata da way bay hay, ba diya? ");
INSERT INTO mif_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Wuzdamiwa, ka diyam ŋga nəkmawa na, wa? Ka nəkmawa na, *ndaw ma təla mey ŋga Gazlavay, ba diya? Ya fa ləvkwar, fara fara ara aŋga. Ama a fəna ndaw ma təla mey ŋga Gazlavay la saya, ");
INSERT INTO mif_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","maja *Jaŋ a na, ara ndaw masa mey ŋga Gazlavay mawuzlalakaya maa guzley da ray a, a ləvey: “Bay Gazlavay a ləvar a Bəzey aŋga: Ehe, ya fa slərey maslaŋ-cəveɗ aɗaw fa mey akah, amba a ɗiykawa cəveɗ akah.”» ");
INSERT INTO mif_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yesu aa guzley saya, a ləvey: «Ya fa ləvkwar fara fara, da wuzlah ndəhay da bəla na, kwa ndaw ma fəna Jaŋ-Baptis na, daa ba. Ama ndaw mecəhe da wuzlah ndəhay masa Gazlavay fa wey da ray ata na, ndaw aha a fəna Jaŋ-Baptis. ");
INSERT INTO mif_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dəga ta pas masa Jaŋ-Baptis ma zlar ŋga wuzey mey ŋga Gazlavay haa wure keɗe na, ndəhay malamba masa-həma hay fa kəɗam vaw ŋga təkmara Bay Gazlavay ŋga wey da ray ndəhay. A wuɗam ŋga wamara bəla aa slam a ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwakwas ŋga *Mawiz ta ndəhay ma təla mey hay tabiya taa guzlam la da ray Gazlavay ma wey da ray ndəhay. Aa guzlam anda keɗe haa kasl pas masa Jaŋ ma wuswa. ");
INSERT INTO mif_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Da ka təɓmara mey aɗaw na, ya fa ləvkwar, *Eli, ndaw masa ndəhay ma təla mey hay maa guzlam zleezle da ray a ma da vəhwa heyey na, ara Jaŋ-Baptis a. ");
INSERT INTO mif_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Da ndaw, aŋga ta sləmay na, ŋga cənda mey a maaya maaya. ");
INSERT INTO mif_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Səkway ŋga ndəhay masa wure keɗe kaa na, ya da wata na, ta me? Yaw, ya da wata na, ta bəza hay masa manjatakaya da slala fa kam wasa ta mandala ata hay, a wuɗkam ɗay da wuzlah ata, a ləvam: ");
INSERT INTO mif_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ala ta famakwar sləlam la, ama ka ta gərvam daa ba. Ala ta zlamakwar walay vagay la, ama akwar ta təwam daa ba may.” ");
INSERT INTO mif_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yaa guzlkwar anda keɗe na, maja Jaŋ ta sawa la ŋga wuzkwar mey. A key *daliyam, asaya, a sey wuzam ba. Kaa ndəhay a ləvam: “Aŋga ta malula da ray.” ");
INSERT INTO mif_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yah, *Bəz ŋga Ndaw, ya sawa, ya fa zəmey cek, ya fa sey cek anda ndəhay mekele. Ama ndəhay a ləvam: “Nəkmara, ndaw a keɗe, a wulkey si ŋga zəmey cek ta ŋga sey wuzam ŋgada hwaɗ aŋga gway. Asaya, aŋga na, ara jam ŋga ndəhay ma cakala budaw ta ŋga ndəhay ma zləɓa kwakwas ŋga Mawiz.” Ama yah na, ya fa ləvkwar ndəhay a da sərmara leŋgesl ŋga Gazlavay aŋga maaya na, ta fa sləra maaya masa ndəhay ta leŋgesl ŋga Gazlavay ma kamara.» ");
INSERT INTO mif_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Fa dəɓa ha, Yesu a mbəɗtar ray ŋgada ndəhay da slala hay masa aa ma key maazla hay ga da hwaɗ a. A mbəɗtar ray na, maja ndəhay da slala hay a, ta mbəɗdamara menjey ata daa ba. ");
INSERT INTO mif_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","A ləvtar: «Haya! ndəhay da slala Kwaraziŋ, banay a sawa la a ray akwar. Haya! ndəhay da slala Betsayda, banay a sawa la a ray akwar. Da ndəhay daa berney ŋga Tir ta ŋga Sidaŋw ta hətmatar maazla hay a la na, anja ta mbəɗdamara menjey ata sem dəga zleezle, anja ta kəzlam zana ŋga sak meefərey vaw sem fa vaw, asaya, ta pətkwalam sem daa bebəɗes ŋga wuzwa na, ata ta mbəɗdamara menjey ata da bəla cay. ");
INSERT INTO mif_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Da ray ŋgene, ya fa kadakwara, ta pas masa Gazlavay ma da ka sariya da ray bəla na, Gazlavay a da sərdakwar banay ma fəna ŋga ndəhay daa berney ŋga Tir ta ŋga Sidaŋw. ");
INSERT INTO mif_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Akwar ndəhay da Kapernayum may, ka wulkam na, Gazlavay a ŋgəlkwar la a vaɗ daw? Ara kəne ba. A da kəzlakwar aa slam ŋga ndəhay maməctakaya. Ya ta key maazla hay la da wuzlah akwar. Da ndəhay daa berney ŋga *Sadawm ta hətmatar maazla hay a keɗe la na, anja berney ata ta pəlhey daa ba, anja aŋga daha haa wure keɗe. ");
INSERT INTO mif_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Da ray ŋgene, ya fa kadakwara, ta pas masa Gazlavay ma da ka sariya da ray bəla na, Gazlavay a da sərdakwar banay ma fəna ŋga ndəhay daa berney ŋga Sadawm.» ");
INSERT INTO mif_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Daa ŋgene, Yesu aa guzley, a ləvey: «Waa Papay Bay Gazlavay, ndaw ma wa slam da vaɗ ta da hwayak, ya fa kaka suse, maja ka ta wuzdərwa maaya akah la a ndəhay ma səra cek ba anda bəza hay mecəhe hay. Ama ŋgada ndəhay masa ta leŋgesl ma səra cek na, ka ta ɓada maaya ha sem fa ata. ");
INSERT INTO mif_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ahaw, Papay, maja ta mbafaka sem ŋga ka kəne.» ");
INSERT INTO mif_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ta’, Yesu aa guzltar a gula aŋga hay, a ləvey: «Papay ta vəldatiwa cek hay tabiya sem asi har aɗaw. Kwa ndaw pal ma sərya, yah, *Bəz ŋga Ndaw na, daa ba, si Papay. Asaya, kwa ndaw pal ma səra Papay daa ba may, si yah, Bəzey aŋga, leŋ ndəhay masa yah ma wuɗey ŋga wuzdatara.» ");
INSERT INTO mif_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Akwar ndəhay masa fa gəram ŋga səpey mey hay mekele mekele ŋga *ndəhay maa sərkada kwakwas ŋga Mawiz ŋgene, samawa fa yah, akwar fa da gəram daa saba. ");
INSERT INTO mif_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Cəndamara mey aɗaw, samawa, sasərkam fa yah, maja yah ndaw meekweɗ-mey, ka da məskam vaw ta zazay. ");
INSERT INTO mif_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Meesərkey aɗaw na, aŋga ta banay ŋga cəney ba, kwa sləra masa yah ma da ləvkwar ŋga key na, aa ta gəra daa ba.» ");
INSERT INTO mif_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pas pal daha, ara ta *pas meməskey-vaw, ata Yesu ta gula aŋga hay a diyam taa ley ŋga cek anda daw . May fa catar a gula aŋga hay a. Da ray ŋgene, ta’, a həɓam cek hay a heyey, aa mbəɗmara. ");
INSERT INTO mif_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Daa masa ndəhay *Fariza hay ma hətmatar gula aŋga hay fa həɓam cek aha na, ta’, aa guzlmar a Yesu, a ləvmar: «Haya! Nəkta gula akah hay fa kam sləra ta pas meməskey-vaw, ara cek matəkakaya daa *kwakwas ŋga Mawiz.» ");
INSERT INTO mif_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu a mbəɗdatara, a ləvtar: «Akwar ta jaŋgamara daa ɗerewel ŋga Gazlavay cek masa *Davit ma ka zleezle na, daa ba daw? Ta pas laŋgar daha, ata Davit ta ndəhay aŋga hay, may fa catar, ama cek mezəmey fa ata daa ba. ");
INSERT INTO mif_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Maja ŋgene Davit e a mbəzey aa way ŋga Gazlavay, aŋga ta ndəhay aŋga hay, ta’, a zəmamara peŋ masa mavəldakaya ŋgada Gazlavay. Kwa kwakwas aləkwa ta pəskatar mey ŋga zəmamara daa ba, anja ŋga zəmamara na, si ndəhay ma ka kwakwas ŋga Gazlavay gway. ");
INSERT INTO mif_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Asaya, ka ta jaŋgamara mey ŋga kwakwas ŋga Mawiz la, ta pas meməskey-vaw na, ndəhay ma ka kwakwas a fa kam sləra daa *Way-mekey-kwakwas ŋga Gazlavay. Anda keɗe, ata fa zləɓmara kwakwas ŋga pas meməskey-vaw, ama ara mebərey ba. ");
INSERT INTO mif_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ehe, ya fa ləvkwar, cek mahura ma fəna Way-mekey-kwakwas ŋga Gazlavay na, aŋga feɗe da wuzlah akwar. ");
INSERT INTO mif_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ɗerewel ŋga Gazlavay zleezle a ləvey: “Ya wuɗey na, ndəhay a səram dey-ceceh fa ndəhay, ba na, a hərmaya gənaw hay ba.” Ama ka ta cəndamara mabara ŋga mey a fara fara daa ba. Anja da ka ta cəndamara la na, ka gwamara ŋga mbəɗmatar ray ŋgada ndəhay masa manjar mebərey keɗe ba. ");
INSERT INTO mif_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yaw, ma wey da ray pas meməskey-vaw na, ara yah, *Bəz ŋga Ndaw.» ");
INSERT INTO mif_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Fa dəɓa ha, Yesu pərta! a sləkɗey, a daw a mbəzey aa *way-mewuzey-mey ŋga Gazlavay da slala ha. ");
INSERT INTO mif_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ndaw feteɗe daha, har maməckaya. Ndəhay *Fariza hay daa way-mewuzey-mey a, aa cəfɗamara Yesu, a ləvmar: «Kwakwas aləkwa ta vəley cəveɗ la ŋga mbəley ndaw ta *pas meməskey-vaw daw?» Aa cəfɗamara anda ŋgene na, amba aa dəɗfamar mey. ");
INSERT INTO mif_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu a mbəɗdatara, a ləvtar: «Da ndaw da wuzlah akwar, aŋga ta təɓaŋ pal, da təɓaŋ a, a kəzley aa vəgeɗ ta pas meməskey-vaw na, ndaw aha, a badərwa daa vəgeɗ e daa ba daw? ");
INSERT INTO mif_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yaw, ya fa ləvkwar fara fara, ndaw a fəna təɓaŋ ta maaya. Kaa wara kwakwas aləkwa a vəley cəveɗ ŋga jəney ndaw ta pas meməskey-vaw ba na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Cay, ta’, Yesu a ləvar a ndaw masa har maməckaya heyey: «Təldərwa har a.» Tal! a təldara har a. Ta’, a ɗiyey anda har laŋgar. ");
INSERT INTO mif_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Da ray ŋgene, ndəhay Fariza hay a, a bamawa aa ambaw, a kusam, a cəmdamara ɗay ata ŋga kəɗey Yesu vagay. ");
INSERT INTO mif_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Daa masa Yesu ma səra dabaray ata la na, pərta! a sləkɗey daa slam aha, ndal! a daw. Ndəhay ga fa diyam asiya. Ta’, a mbəldata masa-macay hay cəpa da wuzlah ata. ");
INSERT INTO mif_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ama a katar mey, a ləvtar: «Kwa ka da wuzdamara mey da ray aɗaw a ndəhay ba.» ");
INSERT INTO mif_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yesu maa guzley anda keɗe na, mey a, ta key la anda *Izay, *ndaw ma təla mey ŋga Gazlavay zleezle, ma ləvey: ");
INSERT INTO mif_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Gazlavay a ləvey: Keɗe ara ndaw ma ka sləra aɗaw masa yah ma wala, yah ma wuɗa kalah, yah faa səmey ga da ray a. Ya slərey Mesəfney aɗaw la a ray a, amba a wuzdatara a ndəhay masa Jəwif hay ba, ya da katar sariya a ndəhay ta cəveɗ e. ");
INSERT INTO mif_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kwa fa da tərey vaw ta ndaw daa ba, kwa fa da wudey ta wudey daa ba. Kwa fa da key baazlam da wuzlah ndəhay daa ba. ");
INSERT INTO mif_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Fa da ŋgərfa panay masa fa da həɓey na, daa ba. Asaya, kwa fa da məca petərla masa fa da məcey na, daa ba, maja ara ndaw mesərey dey-ceceh fa masa-bəle hay. A ka sləra aŋga ha la haa ta pas masa aa ma da ka sariya fara fara da ray ndəhay cəpa. ");
INSERT INTO mif_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ndəhay tabiya a da pamara ŋga ndaw ata fara fara.» ");
INSERT INTO mif_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ta’, a handamawa ndaw-wulaf daha ma gwa ŋgaa guzley ba, maja aŋga ta malula da ray. Yesu ta’, a mbəlda, a gwa ŋgaa guzley, a gwa ŋga hətar dey maaya maaya dəɓa. ");
INSERT INTO mif_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ndəhay tabiya feteɗe a rəzlam, a ləvam da ray Yesu: «Da ara Bəzey ŋga *Davit heyey kwa?» ");
INSERT INTO mif_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ama ndəhay *Fariza hay ma cəndamara mey a keɗe na, a ləvam: «Ndaw keɗe fa ɓəley malula da ray ndəhay ta maazla ŋga *Beyelzebul, bay ŋga mesəfney maaya ba hay.» ");
INSERT INTO mif_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu a səra mewulkey ata, a ləvtar: «Da ndəhay daa hwayak pal a kam vəram da wuzlah ata na, hwayak a ŋgene a nəsey la. Asaya, ndəhay da slala hay, da daa ba, ndəhay da way ndaw pal, da ta cəmam ɗay da wuzlah ata daa ba na, slala ha a nəsey la, da daa ba, way ŋga ndaw aha a nəsey la may. ");
INSERT INTO mif_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Da ndəhay ŋga *Sataŋ fa kəɗam vaw da wuzlah ata na, ŋgene he, ara Sataŋ a, mekəɗey vaw ta vaw aŋga. Kaa wara a da cəmtar ray ŋga wey da ray ata na, kwara dəɓa wura? ");
INSERT INTO mif_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Da ka ləvam ya ɓəla malula ta gədaŋ ŋga Beyelzebul, bay ŋga mesəfney maaya ba hay na, kaa gula akwar hay na, a ɓəlam malula ta gədaŋ ŋga wa? Da ray ŋgene, gula akwar hay na, a wuzdamakwara la, mey akwar ŋgene, ara aŋga ba. ");
INSERT INTO mif_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Fara fara, ya fa ɓəley malula ta gədaŋ ŋga *Mesəfney ŋga Gazlavay. A wuɗey ŋga ləvey, Gazlavay fa wey da ray akwar cay. ");
INSERT INTO mif_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Yaw, kwa ndaw-mayal ma gwa ŋga mbəzey a way ndaw masa-gədaŋ amba a lalatərwa cek aŋga hay meedey aŋga na, daa ba. Si ndaw-mayal a, a key gədaŋ teeseɗ, a jəwa ndaw masa-gədaŋ a ɗagay. Fa dəɓa ha, a gwa a həltərwa cek hay da way a. ");
INSERT INTO mif_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Da ndaw ta njey ta yah daa ba na, ŋgene ndaw a ara masa-gəra aɗaw. Asaya, da ndəhay a jənmaya ŋga ɓəcwa ray ŋga ndəhay ŋgada fa Gazlavay ba na, a key ŋgene, aa waɗamatar ray. ");
INSERT INTO mif_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Maja ŋgene, ya fa ləvkwar, da ndaw ta key cek maaya ba sem, kwa a cəɗa Gazlavay na, Gazlavay a gwa a mbəkdara mebərey aŋga cəpa. Asaya, a gwa a mbəkdara mey hay maaya ba tabiya masa aŋga maa guzlda da ray Gazlavay a. Ama da ndaw a cəɗa Mesəfney ŋga Gazlavay na, Gazlavay fa da mbəkdara mebərey aŋga daa ba səlak. ");
INSERT INTO mif_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kwa anja ndaw aha aa guzley mey maaya ba da ray aɗaw, yah, *Bəz ŋga Ndaw na, Gazlavay a gwa a mbəkdara mebərey aŋga. Ama ndaw maa guzley mey maaya ba da ray Mesəfney ŋga Gazlavay na, Gazlavay fa da mbəkdara mebərey a daa ba, kwa wure keɗe, kwa ta vara ta vara, fa da mbəkdara daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Da wudez, aŋga maaya na, a yey babəza maaya may. Da wudez, aŋga maaya ba na, a yey babəza maaya ba may. A da sərmara wudez keɗe maaya ta maaya ba na, fa babəza ha. ");
INSERT INTO mif_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hey! Akwar bəza hay ŋga kucesl hay, akwar ndəhay maaya ba, kaa wara ka daa guzlam mey maaya na, kwara? Maja mey masa ndaw maa guzlda na, fa wuzdərwa cek masa maɓadakaya daa mevel aŋga. ");
INSERT INTO mif_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Anda keɗe, ndaw maaya na, fa wuzdərwa cek maaya daa mevel aŋga. Ndaw malamba may, fa wuzdərwa cek malamba daa mevel aŋga. ");
INSERT INTO mif_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ya fa ləvkwar, ta pas masa Bay Gazlavay ma da ka sariya na, kwa waawa a kadara mey aŋga la a Bay Gazlavay da ray mey hay maaya ba masa aa maa guzldata cəpa. ");
INSERT INTO mif_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Anda keɗe, da mey masa kah maa guzlda aa maaya ba na, Gazlavay a mbəɗka ray la. Yaw, da mey a maaya na, ŋgene Gazlavay a paka la ŋga ndaw maaya fa mey aŋga.» ");
INSERT INTO mif_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Fa dəɓa ha, ndəhay siya da wuzlah *ndəhay maa sərkada kwakwas ŋga Mawiz leŋ *Fariza hay siya aa guzlmar a Yesu, a ləvmar: «Bay ala, ya wuɗam ka kandar maazla ma wuzdərwa gədaŋ ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu a mbəɗdatara, a ləvtar: «Akwar ndəhay masa wure keɗe na, malamba hay, akwar ma mbəkdamara Bay Gazlavay sem! Ka wuɗam ŋga hətam maazla ma wuzdərwa gədaŋ ŋga Gazlavay fara daw? Kwa akwar fa da hətam maazla ha daa ba, si maazla anda ma key ta *Jawnas, *ndaw ma təla mey ŋga Gazlavay zleezle. ");
INSERT INTO mif_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Anda Jawnas ma key ɗar maakar taa vaɗ, taa pas da hwaɗ ewet mahura heyey na, ara anda ŋgene may, yah, *Bəz ŋga Ndaw, ma da key ɗar maakar taa vaɗ, taa pas da vəgeɗ. ");
INSERT INTO mif_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ta pas sariya masa Gazlavay ma da ka na, ndəhay daa berney ŋga Niniwe heyey na, a lacamawa la ŋga mbəɗmakwar ray, akwar ndəhay wure keɗe, maja daa masa ata ma cəndamara mey ŋga Gazlavay masa Jawnas ma wuzdatara na, ta mbəɗdamara menjey ata sem. Nəkmara, da wuzlah akwar feɗe, ndaw ma fəna Jawnas daha, ama akwar ta mbəɗdamara menjey akwar daa ba. ");
INSERT INTO mif_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Asaya, ta pas sariya masa Gazlavay ma da ka na, ŋgwas ma key bay daa hwayak ŋga Saba zleezle heyey a lacawa la ŋga mbəɗkwar ray, akwar ndəhay wure keɗe, maja aŋga na, a sawa da dəreŋ ŋga cəney mey da ray leŋgesl maaya ŋga Bay *Salamaŋw. Nəkmara, da wuzlah akwar feɗe, ndaw ma fəna Bay Salamaŋw daha, ama akwar ta təɓmara mey aŋga daa ba.» ");
INSERT INTO mif_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Da masa malula ta bey sem da ray ndaw na, a daw a pəkey da ley saw, a səpey slam ŋga məskey vaw. Ama da ta hətey slam daa ba na, ");
INSERT INTO mif_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","a wulkey, a ləvey: “Ŋgama, ya vəhey aa slam aɗaw masa yah ma bawa da hwaɗ a heyey.” A vəhey a ray ndaw aha aa slam aŋga heyey, a hətfar slam aha maɗiykaya maaya maaya, kwa meeme da hwaɗ a daa ba. ");
INSERT INTO mif_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Da ray ŋgene, malula ha a daw, a ŋgəlwa malula hay mekele maasala ma fənmara ta həma ŋga key cek maaya ba. A samawa a ray ndaw a heyey. Anda keɗe, ndaw aha a da sərey banay ma fəna masa ŋgeeme. Ara anda keɗe, cek aha a da key ta ndəhay masa maaya ba wure keɗe.» ");
INSERT INTO mif_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Daa masa Yesu faa guzltar a ndəhay na, ata mamaha ta məlmaha hay malacatakaya daa ambaw, a wuɗam ŋgaa guzlmar. ");
INSERT INTO mif_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ndaw daha a ləvar a Yesu: «Mamakw ta məlmakw hay ata malacatakaya daa ambaw. A wuɗam ŋgaa guzlmaka.» ");
INSERT INTO mif_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu a mbəɗdara, a ləvar: «Mamay na, wa? Məlma aɗaw hay na, wa hay wa?» ");
INSERT INTO mif_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Fa dəɓa ha Yesu, ta’, a wuzey har ŋgada fa gula aŋga hay, a ləvey: «Mamay ta məlma aɗaw hay na, ara ndəhay keɗe, ");
INSERT INTO mif_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","maja məlma aɗaw, dam-mama aɗaw, da daa ba, mamay na, ara ndaw ma key cek anda Papay da vaɗ ma wuɗey.» ");
INSERT INTO mif_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ta pas a ŋgene, Yesu a bey da way, a daw a njey a mey dəhwa ŋga *Galile ŋgaa sərkadata ndəhay. ");
INSERT INTO mif_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ndəhay ga a kusam a cakay a. Maja ŋgene, ta’, Yesu a təpey aa kwambiwal, a njey a hwaɗ a amba aa guzltar. Kwambiwal a, aa da ray yam, ama ndəhay a na, malacatakaya da mey dəhwa ha. ");
INSERT INTO mif_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Aa guzltar da ray cek hay ga ta mey-meŋgey, a ləvtar: «Ndaw mehəvey daha, a daw ŋgaa kwecey hulfaɗ a ley aŋga. ");
INSERT INTO mif_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Daa masa aŋga faa kwacada hulfaɗ a na, hulfaɗ laŋgar a kəzley aa cəveɗ. Fa dəɓa ha, ɗiyaŋ hay a samawa, a ndamara. ");
INSERT INTO mif_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yaw, hulfaɗ laŋgar a kəzley aa slam masa pəraɗ, hwiyak da ray a ga daa ba. Hulfaɗ a, a pəcey fiyaw, maja hwiyak da ray a ga daa ba. ");
INSERT INTO mif_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ama menjey nekəɗey, da masa pas fa tey na, a ɓata. Fa dəɓa ha, a kweley, maja slaslalay a daa vəgeɗ ga daa ba. ");
INSERT INTO mif_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hulfaɗ laŋgar a kəzley a wuzlah hatak. Hatak a, a gəley, aa njərɗa hulfaɗ mapəckaya ha. ");
INSERT INTO mif_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ama hulfaɗ laŋgar na, a kəzley aa slam masa maaya, a gəley, a yey babəza ga, wurzay pal, a gwa a yey babəza temere, laŋgar kwakwar maakwaw, laŋgar may, kwakwar maakar.» ");
INSERT INTO mif_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu aa guzltar saya, a ləvtar: «Da ndaw, aŋga ta sləmay na, ŋga cənda mey a maaya maaya.» ");
INSERT INTO mif_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Fa dəɓa ha, *gula hay ŋga Yesu a ŋgəcham a cakay a, aa cəfɗamara, a ləvmar: «Kaa guzltar ŋgada ndəhay a ta mey-meŋgey hay na, maja me?» ");
INSERT INTO mif_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A mbəɗdatara, a ləvtar: «Yaa guzltar ta mey hay meŋgey na, maja akwar na, Gazlavay ta vəlkwar cəveɗ la ŋga sərey mey hay maɓadatakaya da ray mewey aŋga da ray ndəhay. Ama ndəhay a keɗe na, Gazlavay ta vəltar cəveɗ ŋga sərey mey a daa ba. ");
INSERT INTO mif_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Anda keɗe, da ndaw a wuɗey ŋga səra mey ŋga Gazlavay na, Gazlavay a jəna ŋga səra mey a la a dey a. Da ndaw a wuɗey ŋga səra mey ŋga Gazlavay ba na, kwa mey a masa nekəɗey daa mevel aŋga na, Gazlavay a badərwa la tabiya. ");
INSERT INTO mif_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yaw, yaa guzltar ta mey-meŋgey na, maja ata fa nəkam dey, ama a hətmar dey ba, fa jəkam sləmay, ama a cəndamara ba. ");
INSERT INTO mif_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Anda keɗe, cek aha ta key la ŋgada ata, anda mey masa Gazlavay maa guzlda zleezle ta mey ndaw ma təla mey aŋga *Izay, ma ləvey: “Akwar fa jəkam sləmay maaya maaya, ama ka cəndamara ba. Akwar fa nəkam dey maaya maaya, ama ka hətmar dey ba. ");
INSERT INTO mif_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Maja ndəhay a, a gəmam ŋga cənam mey ba, a dəzlmata sləmay ata hay, a ɗəpmata dey ata hay. A kamara kəne amba a hətmar dey ba, a jəkam sləmay ba, a təɓmara mey a, aa mevel ata ba. Da ray ŋgene, fa da mbəɗdamara menjey ata amba ya mbəldata na, daa ba.” ");
INSERT INTO mif_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Ama akwar, gula aɗaw hay na, maaya ŋga Gazlavay aa da ray akwar, maja akwar fa hətmar dey, asaya, akwar fa jəkam sləmay. ");
INSERT INTO mif_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ya fa ləvkwar fara fara, ndəhay ma təla mey hay ga zleezle ta ndəhay siya ga masa maaya fa mey ŋga Gazlavay ta wuɗam la ŋga hətmar cek masa akwar ma hətmar keɗe, ama ta hətmar daa ba. Ta wuɗam la ŋga cəndamara cek masa akwar ma cəndamara keɗe, ama ta cəndamara daa ba.» ");
INSERT INTO mif_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Ehe, cəndamara mabara ŋga mey-meŋgey ta ndaw maa kwecey hulfaɗ heyey dəɓa. ");
INSERT INTO mif_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ndəhay siya hay a cəndamara mey da ray *mewey ŋga Gazlavay da ray ndəhay, ama a cəndamara mabara ŋga mey a ba. Bay-malula a sawa, a la mey maaya daa mevel ata la. Ŋgada ata na, mey a, aŋga anda hulfaɗ ma kəzley aa cəveɗ. ");
INSERT INTO mif_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ndəhay siya hay saya ma cəndamara mey ŋga Gazlavay la na, a təɓmara fiyaw fiyaw ta meesəmey. Ŋgada ata na, mey a aŋga anda hulfaɗ ma kəzley aa slam masa pəraɗ. ");
INSERT INTO mif_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ama ndəhay a, a təɓmara mey ŋga Gazlavay ŋga ɗar nekəɗey gway. Ta pas masa banay mekele mekele ma da sawa a ray ata maja mey a na, ndəhay a, a da mbəkdamara mey ŋga Gazlavay a fiyaw fiyaw. Ata na, anda hulfaɗ ma pəcwa daa slam masa pəraɗ, slaslalay daa vəgeɗ ga daa ba. ");
INSERT INTO mif_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ndəhay mekele a cəndamara mey ŋga Gazlavay, a təɓmara, ama mey a, aa zəɗey maja ata fa wulkam kalah da ray menjey maaya da bəla, asaya, maja a wuɗam zleley kalah. Ŋgada ata na, mey a, aŋga anda hulfaɗ masa ma kəzley a wuzlah hatak, manjanjərɗakaya daa hatak a. Ata anda cek ma yey babəza ba. ");
INSERT INTO mif_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ndəhay mekele saya, a jəkam sləmay fa mey ŋga Gazlavay, a təɓmara. Da ray ŋgene, fara fara a kadamara sləra ta aŋga. Ata anda hulfaɗ ma pəcwa daa slam maaya. Anda keɗe, mey a, a yey daa mevel ata anda hulfaɗ ma pəcwa ma yey ga, babəza fa vəɗa a key temere, mekele a key kwakwar maakwaw, da daa ba, kwakwar maakar.» ");
INSERT INTO mif_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Fa dəɓa ha, Yesu aa guzltar ta mey-meŋgey mekele a ndəhay makustakaya heyey, a ləvtar: «*Mewey ŋga Bay Gazlavay da ray ndəhay na, ya gwa ŋga wa na, ta me? Ehe, ya ŋgakwar mey da ray a: Ndaw daha a sləkey hulfaɗ maaya a ley aŋga. ");
INSERT INTO mif_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ta tavaɗ masa ndəhay fa nam na, masa-gəra aŋga, a sawa, a sləkey zlərav aa ley a, ta’, a daw. ");
INSERT INTO mif_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Menjey nekəɗey, daw heyey a pəcwa. Zlərav a, a pəcwa may. A gəlam daa slam a, a pamawa ray . ");
INSERT INTO mif_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Anda keɗe, ndəhay ma ka sləra ŋga bay ŋga ley a, ta’, a samawa, a ləvmar a bay ata: “Waa Bay ala, ka sləkey aa ley akah na, hulfaɗ maaya, ba diya? Kaa zlərav na, a sawa dama?” ");
INSERT INTO mif_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A mbəɗdatara, a ləvtar: “Ara masa-gəra aɗaw ma ka sləra ha.” Ta’, ndəhay ma ka sləra aŋga hay a, a ləvmar: “Anda keɗe na, ka wuɗey ya diyam, ya məɗmata daw?” ");
INSERT INTO mif_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A mbəɗdatara, a ləvtar: “Kay, a njey, maja da akwar fa məɗmata na, ka da məɗam daw maaya asiya may. ");
INSERT INTO mif_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mbəkdamata ŋga kam daa slam a haa kasl kiya mekey daw. Ta kiya ha ŋgene, ya da ləvtar ŋgada ndəhay ma da kamərwa daw a, ŋga ŋgəmamara zlərav a la ɗagay, ŋga jəwmata maaɗay a, ŋga pamatar awaw fa vəɗa. Ama daw maaya na, a kamərwa, a handamərwa a wudeɗ.”» ");
INSERT INTO mif_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Fa dəɓa ha, Yesu aa guzltar ta mey-meŋgey mekele saya a ndəhay feteɗe heyey, a ləvtar: «*Mewey ŋga Bay Gazlavay da ray ndəhay na, aŋga anda babəza ŋga bazlawar, masa ndaw ma la, ma rəɓa aa ley aŋga. ");
INSERT INTO mif_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Aŋga mecəhe da wuzlah hulfaɗ hay siya, ama a pəcwa, a gəley mahura da ray cek hay siya, a tərey ŋga wudez, ɗiyaŋ hay a samawa, a ɗiyam way fa mey-har hay a.» ");
INSERT INTO mif_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu aa guzltar ta mey-meŋgey mekele saya, a ləvtar: «Mewey ŋga Bay Gazlavay da ray ndəhay na, aŋga anda cek ma həsla makala masa ŋgwas ma həley kuset kəɗey, ma jahaɗa ta hapa ŋga makala ga, amba a həslərwa tabiya.» ");
INSERT INTO mif_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu a wuzdatara mey hay cəpa ŋgada ndəhay na, ta mey-meŋgey. Kwa taa guzltar ta mey mekele daa ba. ");
INSERT INTO mif_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A ka kəne na, amba a key anda *ndaw ma təla mey ŋga Gazlavay maa guzley zleezle, ma ləvey: «Ya daa guzltar a ndəhay ta mey-meŋgey, Ya da wuzdatara cek hay masa zleezle maɓadatakaya dəga Gazlavay ma ləma bəla.» ");
INSERT INTO mif_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Fa dəɓa ha, Yesu ta’, a mbəkdata ndəhay heyey, a vəhey a way. Gula aŋga hay ta’, a samawa a cakay a, aa cəfɗamara, a ləvmar: «Wuzdandara mabara ŋga mey-meŋgey ta zlərav da ley heyey cey.» ");
INSERT INTO mif_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ta’, a mbəɗdatara, a ləvtar: «Ndaw ma sləka daw masa maaya na, ara yah, *Bəz ŋga Ndaw. ");
INSERT INTO mif_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ley na, ara bəla. Hulfaɗ masa maaya na, ara ndəhay ma təɓmara amba Gazlavay a wey da ray ata. Zlərav na, ara ndəhay ma namar ray a bay-malula. ");
INSERT INTO mif_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Masa-gəra ma sləka zlərav na, ara *Sataŋ, bay-malula. Kiya mekey daw na, ara pas ŋga mendəvey ŋga bəla. Ndəhay ma da kamərwa daw na, ara maslaŋ hay ŋga Gazlavay da vaɗ. ");
INSERT INTO mif_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Anda ata ma ŋgəmamara zlərav ŋga tekwerey na, ta pas mendəvey ŋga bəla na, a da key kəne may ta ndəhay ma namar ray a bay-malula. ");
INSERT INTO mif_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Anda keɗe, yah, Bəz ŋga Ndaw, ya slərdata maslaŋ aɗaw hay da vaɗ la ŋga badamata ndəhay ma təknamata ndəhay ŋga key mebərey leŋ ndəhay ma kam cek malamba da wuzlah ndəhay masa Gazlavay ma wey da ray ata. ");
INSERT INTO mif_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A da kəzlamata aa awaw mendəvey ba. Feteɗe na, a təwam la, aa pəɗam sler la. ");
INSERT INTO mif_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ama ŋgada ndəhay ma namar ray a Bay Gazlavay na, a njam la ta Papa ata, Bay Gazlavay, da vaɗ, a waɗam la anda pas. Da ndaw, aŋga ta sləmay na, ŋga cənda mey a maaya maaya.» ");
INSERT INTO mif_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu aa guzltar ta mey-meŋgey mekele saya, a ləvtar: «*Mewey ŋga Bay Gazlavay da ray ndəhay na, aa letek ta zleley maɓadakaya daa ley. Ndaw a daw, a hətar, a ɓada ma fəna saya. Aa səmey ga da ray a. Maja ŋgene, a daw, a həɗkadata cek aŋga hay tabiya amba a həɗka ley a. ");
INSERT INTO mif_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Asaya, mewey ŋga Gazlavay da ray ndəhay na, aa letek ta ndaw ma ka filaw, ma səpey bersle maaya membey ŋga həɗkey. ");
INSERT INTO mif_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Da ta hətey bersle maaya membey ma həɗkey ba la na, a daw, a həɗkadata cek aŋga hay tabiya amba a həɗka bersle he.» ");
INSERT INTO mif_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Asaya, *mewey ŋga Gazlavay da ray ndəhay na, aa letek ta *tabaw ma kərzawa ewet hay daa dəhwa, a kusmawa səkway ŋga ewet hay mekele mekele ga. ");
INSERT INTO mif_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Masa tabaw a ta rəhey cay ta ewet e na, ta’, a badamərwa a mey dəhwa. A njam ta njey, a walamata səkway ŋga ewet hay masa maaya, a pamata aa gabal, ama səkway ŋga ewet hay masa maaya ba na, a kəzlamata. ");
INSERT INTO mif_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Ta pas mendəvey ŋga bəla na, maslaŋ hay ŋga Gazlavay da vaɗ, a samawa la ŋga wunkey ndəhay ma namar ray a Gazlavay ta ndəhay masa ta mebərey. Ndəhay masa ta mebərey na, a kəzlamata aa awaw mendəvey ba. Feteɗe na, a təwam la, asaya, aa pəɗam sler la. Sariya ŋga Gazlavay ma da key na, ara anda keɗe.» ");
INSERT INTO mif_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu aa cəfɗata gula aŋga hay, a ləvtar: «Akwar ta sərmara mabara ŋga mey hay meŋgey keɗe la daw?» A mbəɗdamara, a ləvmar: «Ahaw, ala ta sərmara la.» ");
INSERT INTO mif_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Da ray ŋgene, Yesu a ŋgatar mey mekele saya, a ləvtar: «Kwa waawa da wuzlah *ndəhay maa sərkada kwakwas ŋga Mawiz ma təɓa amba Gazlavay a wey da ray a na, aŋga anda bay ŋga way ma badərwa zleley aŋga mawiya ta magurma ŋga jəney ndəhay.» ");
INSERT INTO mif_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Masa Yesu maa guzltar a ndəhay ta mey hay meŋgey cay na, ta’, a sləkɗey feteɗe, ");
INSERT INTO mif_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","a daw a *Nezeret, slala masa aa ma gəley da hwaɗ a. Feteɗe aa sərkadata ndəhay daa *way-mewuzey-mey ŋga Gazlavay. Ndəhay tabiya daa way a, a rəzlam, a ləvam: «Haya! Ma vəldara leŋgesl a ndaw a keɗe ŋga sərey cek hay anda keɗe na, wa? A hətərwa leŋgesl ŋga sərey cek hay a keɗe na, dama? ");
INSERT INTO mif_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aŋga na, bəzey ŋga ndaw ma sla hwadam, ba diya? Mamaha na, *Mari, ba diya? Ata *Jak, *Jawzef, *Simaŋw leŋ Jud na, məlmaha hay ba diya? ");
INSERT INTO mif_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Dam-mamaha hay tabiya, ata da wuzlah aləkwa feɗe, ba diya? Kaa a hətərwa leŋgesl keɗe ta gədaŋ keɗe na, dama?» ");
INSERT INTO mif_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ara maja mewulkey ata ŋgene, ata ma təɓmara mey ŋga Yesu ba. Da ray ŋgene, Yesu aa guzltar, a ləvtar: «*Ndaw ma təla mey ŋga Gazlavay na, ndəhay a təɓmara mey aŋga kwa dama dama, ama ma təɓmara ba na, si ndəhay daa hwayak aŋga, ndəhay daa səkway aŋga.» ");
INSERT INTO mif_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yesu a key maazla hay feteɗe nekəɗey gway maja ata ma təɓmara mey aŋga ba. ");
INSERT INTO mif_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Daa ŋgene, *Herawt, bay daa hwayak ŋga *Galile, a cənda mey da ray Yesu. ");
INSERT INTO mif_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Da ray ŋgene, aa guzltar a madərlam aŋga hay, a ləvtar: «Ndaw aha na, ara *Jaŋ-Baptis. A sləkɗawa daa meməcey. Ara maja ŋgene, aŋga ta gədaŋ ŋga key maazla hay.» ");
INSERT INTO mif_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herawt aa guzley anda keɗe na, maja ara aŋga ta ray aŋga ma kəɗa Jaŋ-Baptis a vagay. Ehe mey da ray Jaŋ-Baptis a: Herawt a la Herawdiyat, ŋgwas ŋga məlmaha *Fəlep ŋga ŋgwas aŋga, daa masa Fəlep aa ta dey ɗagay. Maja ŋgene, *Jaŋ a ləvar a Herawt: «Kah ma la ŋgwas ŋga məlmakw ŋgene na, ara cek matəkakaya daa kwakwas aləkwa.» Da ray ŋgene, Herawt a ləvtar a sewje aŋga hay ŋga kərzamara Jaŋ a. Ta’, sewje aŋga hay a, a kərzamara, a jəwmara, a kəzlamara aa fərsəne. ");
INSERT INTO mif_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herawt a wuɗey ŋga kəɗa Jaŋ a vagay, ama a zlurey ta ndəhay *Jəwif hay maja a wulkam na, Jaŋ a ara *ndaw ma təla mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yaw, ta pas gwagway ŋga mesərfedey ɗar ŋga mayawa ŋga Herawt na, dam ŋga Herawdiyat a gərvey fa mey ŋga ndəhay mazəltakaya aa gwagway a. Megərvey a, a mbafar kalah a Herawt. ");
INSERT INTO mif_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ta’, a mbeɗey fa mey ŋga ndəhay, a ləvar a dam aha: «Kwa meeme masa kah maa cəfɗafaya na, ya vəldakawa la.» ");
INSERT INTO mif_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A mbəɗdara a Herawt, a ləvar: «Vəldiwa ray ŋga Jaŋ-Baptis aa vəley wure keɗe feɗe.» A ləvar anda ŋgene na, maja mamaha ma balar mey. ");
INSERT INTO mif_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Masa Bay Herawt ma cənda mey a keɗe na, mevel a təɗar. A gwa ŋga mbəɗda mey aŋga ha saba, maja ta mbeɗey sem fa mey ŋga ndəhay mazəltakaya heyey. Da ray ŋgene, ta’, a vəley cəveɗ ŋga vəlda ray ŋga Jaŋ-Baptis ŋgada dam aha. ");
INSERT INTO mif_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ta’, a slərey ndaw aa fərsəne. Ndaw aha a ɗəslərwa ray ŋga Jaŋ-Baptis, ");
INSERT INTO mif_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","a parawa aa vəley, a handərwa, a vəldara a dam a heyey. Ta’, dam aha a handara a mamaha. ");
INSERT INTO mif_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Fa dəɓa ha, gula hay ŋga Jaŋ-Baptis a, a diyam a lamara vagay a, a pəshamara aa cəvay. Ta’, a diyam, a wuzdamara mey a, a Yesu. ");
INSERT INTO mif_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Daa masa Yesu ma cənda mey da ray meməcey ŋga *Jaŋ-Baptis la na, pərta! a sləkɗey, ta’, a daw ta kwambiwal amba a wusey taava aŋga aa slam masa ndəhay da hwaɗ a daa ba. Masa ndəhay da slala hay ma cəndamara aŋga sem na, a diyam ta mey dəhwa ha ta salay, a səpmar wurzay. ");
INSERT INTO mif_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aŋga ma wusey cay na, ta’, a bərŋgawa daa kwambiwal a, a hətfatar ndəhay makustakaya ga feteɗe. A sərfatar dey-ceceh, ta’, a mbəldata masa-macay hay da wuzlah ata. ");
INSERT INTO mif_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ta pas ŋgaa kwaɗ na, *gula hay ŋga Yesu a ŋgəcham fa vəɗa, a ləvmar: «Wure keɗe hakwaɗ cay, aləkwa da wuzlah-ley. Ŋgama na, ka mbəɗtar mey a ndəhay a ŋga diyam a slala hay, amba a həɗkam cek mezəmey.» ");
INSERT INTO mif_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu a mbəɗdatara, a ləvtar: «Ndəhay a na, si a diyam a slala hay daw? Akwar, ray akwar na, vəlmatar cek mezəmey a.» ");
INSERT INTO mif_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ama a mbəɗdamara, a ləvmar: «Kwa cek mezəmey fa ala daa ba, si peŋ zlam ta ewet cew daada gway.» ");
INSERT INTO mif_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu a mbəɗdatara, a ləvtar: «Handamərwa feɗe.» ");
INSERT INTO mif_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Fa dəɓa ha, Yesu a ləvtar ŋgada ndəhay tabiya ŋga njam a hwayak. Aŋga hal! a həlta peŋ zlam ta ewet cew heyey, a baŋgaɗa dey a vaɗ, a kar suse a Gazlavay. Fa dəɓa ha, a papəsa peŋ e, ta’, a vəldatara a gula aŋga hay amba a wunkamatara a ndəhay makustakaya heyey. ");
INSERT INTO mif_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kwa waawa a zəmey haa a rəhey. Gula aŋga hay ta’, a cakalamara siya ŋga peŋ e. Membəkey na, a rəhey gadakar kuraw a ray a cew. ");
INSERT INTO mif_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ndəhay ma zəmam peŋ e na, ata ga ara mey ba, a fəna ndəhay gabal zlam, ŋgusay ta bəza hay manjar ŋga sləfam. ");
INSERT INTO mif_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Masa ndəhay a ma zəmam cek cay na, wure wure ŋgene Yesu ta’, a təktar ɗay a gula aŋga hay ŋga təpam aa kwambiwal amba ata na, a zləŋgam teeseɗ a dey laŋgar ŋga dəhwa ŋga *Galile. Yesu na, a njey fa dəɓa ɗagay amba a mbəɗtar mey a ndəhay makustakaya heyey ŋga diyam a way. ");
INSERT INTO mif_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Masa ta mbəɗtar mey a ndəhay a cay na, ta’, a təpey aa ray ŋga aŋgwa ŋga dərwa daŋgay. Haa tavaɗ, aŋga pal taava aŋga da aŋgwa ha cəŋga. ");
INSERT INTO mif_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kwambiwal masa gula aŋga hay da hwaɗ a heyey, aŋga da wuzlah yam, aŋga dəreŋ ta rav-zazay, vaŋgwala ŋga yam fa zakada kwambiwal a maja memeɗ fa key ga ŋgada ray ata. ");
INSERT INTO mif_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Fa dəɓa ha, gweegwe slam ŋgaa pərek na, Yesu ta’, a daw ta salay da ray yam ŋgada fa ata. ");
INSERT INTO mif_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Masa gula aŋga hay a ma hətmar fa daw da ray yam na, a zluram ga, aa wasam pər-par! Aa guzlam da wuzlah ata, a ləvam: «Ara mamayam!» Ta’, a wudam ta gədaŋ maja mandərzay fa katar. ");
INSERT INTO mif_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ama, wure ŋgene, Yesu aa guzltar, a ləvtar: «Dəkmara mevel! Ara yah, ka da zluram ba!» ");
INSERT INTO mif_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","*Piyer a mbəɗdara, a ləvar: «Bay aɗaw, da ara kah fara fara na, vəlya cəveɗ amba ya daw da ray yam ŋgada fa kah taw.» ");
INSERT INTO mif_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ta’, Yesu a ləvar a Piyer: «Sawa!» Piyer a bərŋgawa daa kwambiwal, a daw da ray yam ta salay ŋgada fa Yesu. ");
INSERT INTO mif_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama, masa aa ma nəka memeɗ fa key ta gədaŋ na, mandərzay a kar. A zlar ŋga mbəzey asi yam, ta’, a wudey, a ləvey: «Bay mahura, ləhdaya!» ");
INSERT INTO mif_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Wure wure ŋgene, Yesu tal! a təley har, a kərza fa har, a ləvar: «Ka wulkey cew cew na, maja me? Kah, ndaw masa ma paya ŋga ndaw akah fara fara ba ŋgene.» ");
INSERT INTO mif_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Fa dəɓa ha, ta’, a təpam cewete aa kwambiwal a. Wure wure ŋgene, memeɗ e, deŋ! a lecey, a key saba. ");
INSERT INTO mif_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Gula hay ŋga Yesu masa daa kwambiwal, a ragadam fa mey aŋga, a ləvmar: «Fara fara, kah na, Bəzey ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Masa ata Yesu ta gula aŋga hay ma təŋgam la a dey laŋgar ŋga dəhwa ŋga *Galile heyey na, a wusam aa hwayak daha mezəley Genezeret. ");
INSERT INTO mif_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ndəhay daa slam aha na, a sərmara ara Yesu. Ta’, a kadamatara mey a, a ndəhay da slala hay mekele mekele daa hwayak a. Daa masa ata ma cəndamara mey a cay na, ta’, a handamar masa-macay hay. ");
INSERT INTO mif_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","A bərkwamara amba masa-macay hay a, a gəsam har kwa fa mey ŋga zana aŋga gway. Ndəhay ma gəsfamar har cəpa na, ta mbəlam sem. ");
INSERT INTO mif_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fa dəɓa ha, *Fariza hay ta *ndəhay maa sərkada kwakwas ŋga Mawiz a samawa da *Jeruzelem fa Yesu, a ləvmar: ");
INSERT INTO mif_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Gula akah hay a zləɓmara kwakwas ŋga papaŋ ŋga papa aləkwa hay zleezle na, maja me? A da zəmam ɗaf na, a pərmara har anda kwakwas aləkwa ma ləvey ba na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu a mbəɗdatara, a ləvtar: «Akwar na, ka zləɓmara *mewey hay ŋga Gazlavay ta mesəpey kwakwas akwar hay na, maja me? ");
INSERT INTO mif_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gazlavay a ləvey: “Natar ray ŋgada ata papakw ta mamakw.” Asaya, “Ndaw ma cəɗa papaha, da daa ba, ma cəɗa mamaha na, si a kəɗmara ndaw aha vagay.” ");
INSERT INTO mif_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama akwar na, akwar faa sərkadam ndəhay, ka ləvam ndaw a gwa ŋga ləvar a papaha, da daa ba, a mamaha: “Cek masa yah ma da vəldakawa ŋga jənka heyey na, ya vəldakawa daa saba, maja yah ma vəldara sem a Gazlavay.” ");
INSERT INTO mif_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ŋgene na, ndaw aha a nar ray a papaha, da daa ba, a mamaha ha saba, ba diya? Ara anda ŋgene, akwar fa nəsmara mey ŋga Gazlavay, ta mesəpey kwakwas akwar. ");
INSERT INTO mif_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Akwar na, ndəhay masa ta neneh cew! *Izay, *ndaw ma təla mey ŋga Gazlavay zleezle maa guzley da ray akwar na, anja fara. Izay a, a ləvey: ");
INSERT INTO mif_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Gazlavay a ləvey: Ndəhay keɗe fa həslmaya ray ta mey ŋga tede, ama mevel ata na, aa dəreŋ ta yah. ");
INSERT INTO mif_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ata fa həlmamaya, ama mehəlmey a, ta tərey sem ŋga cek ŋga tede, maja kwakwas masa ata maa sərkadamara ŋgene na, ara kwakwas ŋga ndaw-magədaŋ daada gway.”» ");
INSERT INTO mif_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Fa dəɓa ha, Yesu a zəltərwa ndəhay makustakaya ta’, aa guzltar, a ləvtar: «Jəkam sləmay, cəndamara mey keɗe maaya maaya: ");
INSERT INTO mif_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Cek masa ndaw ma ndəkwda a mey, ma zəma na, a kar mebərey ba, ama ma kar mebərey na, si mey ma bawa da mey aŋga.» ");
INSERT INTO mif_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ta’, *gula hay ŋga Yesu a ŋgəcham a cakay a, a ləvmar: «Ka fa səra mey masa kah maa guzlda keɗe na, fa catar mevel a *Fariza hay, ba diya?» ");
INSERT INTO mif_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu a mbəɗdatara, a ləvtar: «Kwa wudez wura wura masa Papay da vaɗ, ma rəva ba na, a məɗmara la. ");
INSERT INTO mif_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mbəkdamata! Ata na, wulaf hay ma ɗaɗam wulaf hay anda ata. Da ndaw-wulaf a ɗeɗey wulaf cəla ta zlanday na, ata cewete a təɗam la aa vəgeɗ, ba diya?» ");
INSERT INTO mif_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Fa dəɓa ha, *Piyer ta’, aa guzlar, a ləvar: «Wuzdandara mabara ŋga mey a keɗe cey.» ");
INSERT INTO mif_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu a ləvey: «Akwar gula aɗaw hay kwa na, ka cəndamara mey a keɗe ba saya na, gway daw? ");
INSERT INTO mif_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Cek masa ndaw ma ndəkwda a mey, ma zəma na, a daw ŋgada hwaɗ ŋga ndaw aha. Fa dəɓa ha, a bawa a palah. Ka ta sərmara daa ba cəŋga daw? ");
INSERT INTO mif_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama mey masa ndaw maa guzlda ta mey aŋga na, a sawa dəga daa mevel aŋga. Ŋgene, a kar mebərey a ndaw aha. ");
INSERT INTO mif_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mewulkey maaya ba a bawa na, daa mevel ŋga ndaw. Ara mewulkey a ma həlda ndaw ŋga kəɗey ndaw vagay, ŋga ley vaw saw da palah, ŋga key cek malamba saw kəne, ŋga leley, ŋga mbərzley a ray ndaw, leŋ ŋga key mbaɗa fa ndəhay. ");
INSERT INTO mif_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ara səkway ŋga cek hay malamba anda keɗe ma kar mebərey a ndaw. Ama, da ndaw a zəma cek ta har manjar ŋga pərey na, ara mebərey ba.» ");
INSERT INTO mif_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Fa dəɓa ha, Yesu pərta! a sləkɗey daa slam aha, tal! a diyam ta gula aŋga hay aa hwayak mekele masa berney ŋga Tir ta berney ŋga Sidaŋw da hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ŋgwas daa hwayak a daha, aŋga dam Kana. A sawa fa Yesu, a kar ambahw, a wudey, a ləvar: «Waa Bay mahura, Bəzey ŋga *Davit! Dam aɗaw daha, aŋga ta malula da ray, fa sərda banay kalah. Sərfaya dey-ceceh may taw!» ");
INSERT INTO mif_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu taa guzlar kwa mey pal daa ba. Gula aŋga hay a ŋgəcham a cakay a, a ləvmar: «Mbəɗar mey a ŋgwas a keɗe, maja fa səpndakwar wurzay ta mewudey.» ");
INSERT INTO mif_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu a mbəɗdatara, a ləvtar: «Gazlavay a slərdiwa na, fa ndəhay *Israyel hay gway. Ata na, maazəɗtakaya anda təɓaŋ hay manjar mecəkwer.» ");
INSERT INTO mif_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ama, ŋgwas a heyey a daw, a regedey fa mey aŋga, a ləvar: «Waa Bay mahura, jənya may taw!» ");
INSERT INTO mif_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu a mbəɗdara, a ləvar: «Mevəley ɗaf ŋga bəza hay ŋgada gədey hay na, maaya daw?» ");
INSERT INTO mif_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ŋgwas a heyey a ləvar: «Ahaw, Bay aɗaw, kaa gədey hay na, a zəmam meepəsey ŋga ɗaf ma kəzley daa slam masa bay ata hay ma zəmam ɗaf cəŋga, ba diya?» ");
INSERT INTO mif_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Da ray ŋgene, Yesu a mbəɗdara, a ləvar: «Maaya kwakwa! Kah ma paya la ŋga ndaw akah fara fara. Cek aha ŋga key anda kah ma wuɗey.» Daa ŋgene, dam aŋga heyey a mbəley. ");
INSERT INTO mif_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Fa dəɓa ha, Yesu a sləkɗey daa slam aha, a daw ta mey dəhwa ŋga *Galile. Ta’, a təpey aa ray ŋga aŋgwa, cəkwam! a njey feteɗe. ");
INSERT INTO mif_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ndəhay makustakaya ga, a samawa fa vəɗa, a handamawa ndəhay jegwer hay, ndəhay wulaf hay, ndəhay maahəlɓatakaya hay, madagazlam hay leŋ ndəhay ta macay hay mekele mekele ga. A njadamata fa mey ŋga Yesu. Ta’, a mbəldata. ");
INSERT INTO mif_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ndəhay makustakaya heyey a rəzlam maja ata ma hətmatar madagazlam hay heyey faa guzlam dəɓa, ndəhay maahəlɓatakaya hay heyey ta mbəlam cay, ndəhay jegwer hay heyey fa diyam ta salay ata hay, wulaf hay may fa hətmar dey dəɓa. Ta’, a həlmamara Bay Gazlavay ŋga *Israyel hay. ");
INSERT INTO mif_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu ta’, a zəltərwa gula aŋga hay, a ləvtar: «Dey-ceceh fa kaya fa ndəhay makustakaya keɗe, maja aŋga kaa ɗar maakar ata da cakay aɗaw, wure keɗe cek mezəmey da har ata daa saba. Ya wuɗey ŋga mbəkdata ŋga diyam a way ta may ba, maja da a da hətam gədaŋ daa cəveɗ ŋga wusey a way ata hay ba kwa.» ");
INSERT INTO mif_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Gula aŋga hay a mbəɗdamara, a ləvmar: «Kaa aləkwa da wuzlah-ley keɗe na, ya da hətmawa cek mezəmey ŋga rəhdata ndəhay tabiya makustakaya keɗe na, dama?» ");
INSERT INTO mif_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu aa cəfɗata, a ləvtar: «Da har akwar feɗe kaa na, peŋ we?» A mbəɗdamara, a ləvmar: «Da har ala na, peŋ maasala ta ewet mecəhe mecəhe nekəɗey gway.» ");
INSERT INTO mif_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu a ləvtar a ndəhay makustakaya heyey ŋga njam a hwayak. ");
INSERT INTO mif_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aŋga ta’, a həla peŋ maasala ta ewet hay heyey, a kar suse a Gazlavay, a papəsa, ta’, a vəldatara a gula aŋga hay. Gula aŋga hay a, a wunkamatara a ndəhay makustakaya ha. ");
INSERT INTO mif_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kwa waawa ta hətey cek mezəmey la, haa a rəhey. Ta’, gula aŋga hay a cakalamara siya mambəkakaya. Macakalakaya ha a rəhey gadakar mahura mahura maasala. ");
INSERT INTO mif_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yaw, ndəhay ma zəmamara peŋ ta ewet e na, ndəhay gabal məfaɗ, ŋgusay ta bəza hay manjar ŋga sləfam. ");
INSERT INTO mif_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Fa dəɓa ha, Yesu a mbəkdata ndəhay makustakaya ha ŋga diyam a way ata hay. Ta’, a təpey aa kwambiwal, a diyam aa hwayak mezəley Magadaŋ. ");
INSERT INTO mif_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fa dəɓa ha, *Fariza hay ta ndəhay *Saduse hay a ŋgəcham a cakay Yesu ŋga jadamara, aa cəfɗamara amba a key maazla ŋga wuzda gədaŋ aŋga a sawa ta fa Bay Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu a mbəɗdatara, a ləvtar: «Masa pas fa kəzley, gazlavay fa key magaza na, ka ləvam mandaw na, gazlavay ŋga var a key daa ba. ");
INSERT INTO mif_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Asaya, pərek pərek da masa pas fa bawa, fa cey na, ka ləvam tasana na, var a pey la. Anda keɗe, da akwar fa nəkam dey a gazlavay na, ka sərmara cek ma da key tasana ta cek ma da key mandaw. Kaa sləra masa yah ma ka na, ka sərmara mabara ha ba na, kwara? ");
INSERT INTO mif_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Akwar ndəhay masa wure keɗe na, malamba hay, akwar ma mbəkdamara Bay Gazlavay sem! Ka wuɗam ŋga hətam maazla ma wuzdərwa gədaŋ ŋga Gazlavay fara daw? Kwa akwar fa da hətam maazla ha daa ba, si maazla anda ma key ta *Jawnas zleezle.» Fa dəɓa ha, Yesu ta’, a mbəkdata, a daw. ");
INSERT INTO mif_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Daa masa ata Yesu ta gula aŋga hay ma təŋgam sem a dey laŋgar ŋga dəhwa na, gula aŋga hay a ta sərfadamara ŋga handawa peŋ daa ba. ");
INSERT INTO mif_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ta’, Yesu aa guzltar, a ləvtar: «Wam vaw fa cek ma həsla peŋ ŋga *Fariza hay leŋ ŋga *Saduse hay!» ");
INSERT INTO mif_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Da ray ŋgene, gula aŋga hay aa guzlam da wuzlah ata, a ləvam: «Aa guzley anda keɗe maja aləkwa ma sakurwa ta peŋ daa ba daw?» ");
INSERT INTO mif_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu na, ta səra mey masa ata maa guzldamara da wuzlah ata sem. Da ray ŋgene, aa cəfɗata, a ləvtar: «Akwar ndəhay masa ma pamara Gazlavay ŋga ndaw akwar fara fara ba ŋgene, ka wulkam da ray peŋ masa akwar ma handamawa daa ba na, maja me? ");
INSERT INTO mif_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Haa wure keɗe akwar na, ka cəndamara mey a ba cəŋga daw? Sərfadamara peŋ zlam masa yah ma wunkatara ŋgada ndəhay gabal zlam heyey. Mambəkakaya na, a rəhey gadakar we? ");
INSERT INTO mif_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Asaya, sərfadamara peŋ maasala masa yah ma wunkatara ŋgada ndəhay gabal məfaɗ heyey. Mambəkakaya na, a rəhey gadakar mahura mahura we? ");
INSERT INTO mif_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yaw, daa masa yah maa guzlkwar: “Wam vaw fa cek ma həsla peŋ masa fa Fariza hay leŋ fa Saduse hay” na, yaa guzley na, da ray peŋ ba. Kaa ka cəndamara ba na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Anda keɗe, *gula hay ŋga Yesu heyey a sərmara, Yesu aa guzltar na, da ray cek ma həsla peŋ fara fara ba, ama a ŋgatar mey da ray meesərkedey ŋga Fariza hay ta ŋga Saduse hay. ");
INSERT INTO mif_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu a wusey aa slam masa gweegwe ta slala Sezere-Fəlep. Aa cəfɗata gula aŋga hay, a ləvtar: «Ndəhay a padamaya, yah, *Bəz ŋga Ndaw na, ŋga wa?» ");
INSERT INTO mif_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","A mbəɗdamara, a ləvmar: «Ndəhay siya a ləvam kah na, *Jaŋ-Baptis, mekele hay a ləvam, kah na, *Eli, *ndaw ma təla mey ŋga Gazlavay zleezle. Ndəhay mekele hay saya a ləvam, kah na, Jeremey, da daa ba, ndaw mekele dasi ndəhay ma təla mey ŋga Gazlavay zleezle.» ");
INSERT INTO mif_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ta’, Yesu aa cəfɗata saya, a ləvtar: «Kaa akwar may, ka ləvam yah na, wa?» ");
INSERT INTO mif_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","*Simaŋw *Piyer a mbəɗdara, a ləvar: «Kah na, *Kəriste, Bəzey ŋga Gazlavay, ndaw masa aŋga daha ta dey ŋga sərmataw.» ");
INSERT INTO mif_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu aa guzlar, a ləvar: «Simaŋw, bəzey ŋga *Jawnas, maaya ŋga Gazlavay aa da ray kah, maja mey masa kah maa guzlda keɗe na, ara ndaw-magədaŋ ma wuzdakawa ba, ama ara Papay da vaɗ ma wuzdakawa. ");
INSERT INTO mif_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yaw, yah may, ya fa ləvka, kah na, mezəley akah Piyer anda meləvey “pəraɗ.” Ya da pa *mecəmey-ray ŋga ndəhay aɗaw hay da ray pəraɗ a. Kwa meməcey na, fa da gwa ŋgaa zəɗda daa ba. ");
INSERT INTO mif_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ya da vəlka gədaŋ ŋga wurey cəveɗ ŋgada ndəhay amba a təram ndəhay ŋga Gazlavay. Mey masa kah ma da jəwa da bəla na, aŋga majəwkaya da gazlavay da vaɗ may. Asaya, mey masa kah ma da pəska da bəla na, aŋga mapəskakaya da gazlavay da vaɗ may.» ");
INSERT INTO mif_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesu ta’, a kətata gula aŋga hay, a katar mey, a ləvtar: «Fara fara yah na, Kəriste, ama ka da wuzdamara a ndəhay ba.» ");
INSERT INTO mif_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dəga ta pas masa *Piyer ma wuzda Yesu ara *Kəriste heyey na, Yesu a wuztar mey ŋgada gula aŋga hay, a ləvtar: «Si ya daw a *Jeruzelem. Mahura hay ŋga *Jəwif hay, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, leŋ *ndəhay maa sərkada kwakwas ŋga Mawiz na, a sərdamaya banay la feteɗe, a kəɗmaya la vagay. Ama ŋga ɗar maakar a na, ya sləkɗawa la daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piyer ta’, a zəla Yesu ta cakay, a mbəɗar ray, a ləvar: «Kay! Bay mahura, Gazlavay ŋga ka kəne ba! Anja səkway ŋga cek anda ŋgene na, ŋga hətfaka ba səlak!» ");
INSERT INTO mif_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ama Yesu pəla! a mbəɗey dey ŋgada fa Piyer, a ləvar: «Hway la da cakay aɗaw, kah, *Sataŋ. Kah na, ka fa səpey ŋga zlaŋgaɗadaya daa cəveɗ aɗaw daw? Maja mewulkey akah ŋgene na, ara mewulkey ŋga Gazlavay ba, ama ara mewulkey ŋga ndaw-magədaŋ gway.» ");
INSERT INTO mif_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ta’, Yesu aa guzltar a gula aŋga hay, a ləvtar: «Da ndaw a wuɗey ŋga səpya na, si a mbəkda mewulkey fa ray aŋga, a səpya ta mevel pal, si a ɓəsa banay ma da sawa a ray aŋga maja yah, anda yah ma da məcey fa hwadam mazlaŋgalakaya. ");
INSERT INTO mif_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sərmara, kwa waawa ma wuɗey ŋga ləhda heter aŋga na, a key aa zəɗda, ama ndaw maa zəɗda heter aŋga maja yah na, a hətar la aa slam a. ");
INSERT INTO mif_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Da ndaw a hətey cek hay tabiya masa aŋga ma wuɗey da bəla keɗe, ama taa zəɗda heter aŋga sem na, cek hay a tabiya ŋgene, ta ləhdamara ndaw a la daw? Yaw, ndaw a gwa ŋga mbəɗa heter aŋga na, ta me? ");
INSERT INTO mif_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sərmara, yah, *Bəz ŋga Ndaw na, ya da sawa ta gədaŋ ŋga Papay leŋ ta maslaŋ aŋga hay da vaɗ. Ya da pəla mawurɓay kwa ŋga waawa cəpa, təɗe fa sləra masa ndaw a ma ka. ");
INSERT INTO mif_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ya fa ləvkwar fara fara, ndəhay siya da wuzlah akwar feɗe, fa da məcam daa ba haa ata ma hətmaya ta dey ata la ɗagay, masa yah, Bəz ŋga Ndaw, ya fa zəma bay aɗaw.» ");
INSERT INTO mif_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ɗar maakwaw fa dəɓa ha na, Yesu ta’, a zəlta ata *Piyer, *Jak, leŋ *Jaŋ, məlmaŋ ŋga Jak a, a ŋgəlta aa ray ŋga aŋgwa maazəma, a njam feteɗe taava ata. ");
INSERT INTO mif_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yesu a, pəla! a mbəɗey fa dey ata, dey aŋga a weɗey anda pas, zana aŋga mabara ndəɗ-ndeɗ. ");
INSERT INTO mif_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Wure wure ŋgene, ata *Mawiz ta *Eli a wuzmatar vaw a gula aŋga hay heyey . Gula hay a, a hətmatar fa kam maɗay ta Yesu a. ");
INSERT INTO mif_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Da ray ŋgene, Piyer aa guzlar a Yesu, a ləvar: «Waa Bay Mahura, maaya na, ya njakwa feɗe. Da ka wuɗey na, amba ya kərcey slam hay maakar, pal ŋgada kah, pal ŋgada Mawiz, pal ŋgada Eli.» ");
INSERT INTO mif_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Daa masa faa guzley araŋ na, mekwtene meweɗey ndəɗ-ndeɗ! a sawa, sərat! a sərtata. A cənam ɗay maa guzlwa daa mekwtene he, a ləvey: «Keɗe he ara Bəzey aɗaw masa yah ma wuɗa kalah. Ara bəzey masa ya faa səmey ga da ray a. Jəkfamar sləmay!» ");
INSERT INTO mif_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Masa *gula hay ŋga Yesu ma cəndamara la na, a zluram ga, ta’, a təɗam ta mey ta mey, daŋgay dar! a hwayak. ");
INSERT INTO mif_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Wure ŋgene, Yesu a ŋgəchawa a cakay ata, a wusta ta har, a ləvtar: «Sləkɗam, ka da zluram ba.» ");
INSERT INTO mif_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A baŋgaɗamara dey na, a hətam ndaw mekele saba, si Yesu taava aŋga gway. ");
INSERT INTO mif_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Masa ata fa bərŋgamawa da aŋgwa ha na, Yesu a kətata, a ləvtar: «Ka da wuzdamara cek masa akwar ma hətmar keɗe a ndaw ba, haa kasl pas masa yah, *Bəz ŋga Ndaw, ma da sləkɗawa daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ta’, gula hay ŋga Yesu aa cəfɗamara, a ləvmar: «Ndəhay maa sərkada kwakwas ŋga Mawiz a ləvam si Eli a sawa la teeseɗ da ray *Kəriste na, maja me?» ");
INSERT INTO mif_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu a mbəɗdatara, a ləvtar: «Ahaw, fara fara si Eli a sawa ŋga ɗiyta cek hay cəpa maaya maaya. ");
INSERT INTO mif_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama, yah na, ya fa ləvkwar, Eli ta sawa cay. Ndəhay ta hətmar la, ama ta sərmara daa ba, ta kamar cek maaya ba la anda mevel ata ma wuɗey. Ara kəne may, ndəhay a ma da sərdamaya banay, yah, Bəz ŋga Ndaw.» ");
INSERT INTO mif_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Anda keɗe, gula hay ŋga Yesu ta sərmara sem Yesu aa guzltar na, da ray *Jaŋ-Baptis. ");
INSERT INTO mif_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Masa ata Yesu ta gula aŋga hay maakar heyey ma wusam la a cakay ndəhay makustakaya na, ta’, ndaw daha a ŋgəchawa a cakay Yesu, a regedey fa mey aŋga, ");
INSERT INTO mif_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","a kar ambahw, a ləvar: «Bay Mahura, bəzey aɗaw aŋga ta cek da ray, fa ɓərzlada, fa sərda banay. Da cek aha ta zlar ŋga ɓərzlada la na, ta pas laŋgar a təɗda aa awaw, da daa ba, aa yam. Sərfar dey-ceceh may taw! ");
INSERT INTO mif_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ya ta handa la fa gula akah hay, ama ta gwamara ŋga mbəldamara daa ba.» ");
INSERT INTO mif_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu ta’, aa guzley, a ləvey: «Hey! Akwar ndəhay marəzltakaya masa ma pamaya ŋga ndaw akwar fara fara ba keɗe. Ya da njey ta akwar na, haa ta vara? Ya da ɓəskwar na, haa ta vara? Handamiwa bəzey a feɗe!» ");
INSERT INTO mif_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Masa ata ma handamərwa bəzey a la na, Yesu ta’, aa bəcar a cek da ray bəzey a. Ta’, cek aha a bey. Wure ŋgene, bəzey a, a mbəley. ");
INSERT INTO mif_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Masa ata Yesu ta gula aŋga hay ata taava ata na, ta’, gula aŋga hay a, a ŋgəcham a cakay a, aa cəfɗamara, a ləvmar: «Ala ta gwamara ŋga badamara cek da ray bəzey a daa ba na, maja me?» ");
INSERT INTO mif_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu a mbəɗdatara, a ləvtar: «Maja akwar fa təɓmara mey ŋga Gazlavay fara fara daa ba. Ya fa ləvkwar fara fara, da akwar fa təɓmara mey ŋga Gazlavay kwa kuset kəɗey həma babəza ŋga bazlawar na, ŋgene, ka gwamara ŋga ləvmar a aŋgwa mahura keɗe, sləkɗey la feɗe, daw ŋgada fataɗay na, aŋgwa ha a sləkɗey la. Anda keɗe, cek masa ta gəra ŋga key fa akwar na, daa ba.  ");
INSERT INTO mif_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ama ŋga bey cek anda keɗe da ray ndaw na, si ta medərey-daŋgay a Bay Gazlavay leŋ ta mekey *daliyam.» ");
INSERT INTO mif_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ta pas laŋgar daha, ata Yesu ta gula aŋga hay a vəhmawa a *Galile, ata tabiya daa slam a. Yesu ta’, aa guzltar, a ləvtar: «A da kərzamaya yah, *Bəz ŋga Ndaw, a da vəldamaya a har ndəhay. ");
INSERT INTO mif_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ndəhay a, a da kəɗmaya vagay. Ŋga ɗar maakar a na, ya sləkɗawa la daa meməcey.» Mey a keɗe a təɗtar mevel a gula aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ata Yesu ta gula aŋga hay a diyam a Kapernayum. Ata ma wusam la na, ndəhay ma cakala budaw ŋga *Way-mekey-kwakwas ŋga Gazlavay ata feteɗe. Ta’, ndəhay a, a ŋgəcham a cakay *Piyer aa cəfɗamara, a ləvmar: «Bay akwar na, a pəley budaw ŋga Way-mekey-kwakwas ŋga Gazlavay ba daw?» ");
INSERT INTO mif_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyer a mbəɗdatara, a ləvtar: «’A, ’a, fa pəley.» Daa masa Piyer fa mbəzey a way masa Yesu aa da hwaɗ a na, Yesu aa guzlar teeseɗ, a ləvar: «Simaŋw Piyer, ya wuɗey ŋgaa cəfɗaka, ma pəlam budaw a bay hay da bəla keɗe na, wa hay wa? Ara bəza hay ŋga bay hay a daw? Da daa ba, ara zəgdaw hay daw?» ");
INSERT INTO mif_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyer a mbəɗdara, a ləvar: «Ara zəgdaw hay.» Yesu a ləvey: «Anda keɗe na, bəza hay ŋga bay a pəlam budaw ba. ");
INSERT INTO mif_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ama ŋgama ya pəlkwa budaw a, amba mevel a catar ba. Anda keɗe, daw aa dəhwa ŋga *Galile, kəzla tetəlem akah a hwaɗ a. Ewet masa kah ma da lawa teeseɗ na, ka wura mey ŋga ewet e, ka hətfey ɓərey ŋga dala mak ŋga pəlndakwara budaw a la. Larawa amba ka pəlndakwara budaw aləkwa cew e.» ");
INSERT INTO mif_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Daa ŋgene, *gula hay ŋga Yesu a ŋgəcham a cakay a, aa cəfɗamara, a ləvmar: «Da wuzlah ndəhay masa Gazlavay fa wey da ray ata na, mahura na, wa?» ");
INSERT INTO mif_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu ta’, a zəlwa bəzey mecəhe, a lacada a wuzlah ata. ");
INSERT INTO mif_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ta’, aa guzltar, a ləvtar: «Ya fa ləvkwar fara fara, da akwar ta mbəɗam amba ka təram anda bəza hay mecəhe daa ba na, ŋgene, akwar fa da njam a wuzlah ndəhay masa Gazlavay fa wey da ray ata na, daa ba səlak. ");
INSERT INTO mif_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ndaw ma pa ray aŋga ŋga mecəhe anda bəzey mecəhe keɗe na, ara aŋga ma da key mahura da wuzlah ndəhay masa Gazlavay fa wey da ray ata. ");
INSERT INTO mif_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kwa waawa ma təɓey bəzey anda bəzey mecəhe keɗe maja a wuɗya na, a key ŋgene, a təɓey yah, ray aɗaw.» ");
INSERT INTO mif_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Asaya, kwa waawa ma betey ndaw pal dasi ndəhay ma təɓa mey aɗaw hay keɗe ŋga key mebərey na, ŋgada aŋga na, ŋgama ata ma jəwmar aŋgwa mahura a ɗay, ma kəzlamara aa bəlay gway. ");
INSERT INTO mif_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kay! Banay daha fa ndəhay da bəla keɗe, maja cek hay ga fa təknamata ndəhay ŋga key mebərey. Ahaw fara, cek hay a, a da batamata ŋga key mebərey mandaw mandaw. Ama banay a sawa la a ray ndaw ma həldata ndəhay ŋga key mebərey a. ");
INSERT INTO mif_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Da har akah, da daa ba, salay akah, fa həldaka ŋga key mebərey na, ɗəsla har a, da daa ba, salay a, hazakada dəreŋ ta kah. Ŋgama kah ma hətey heter mendəvey ba ta salay pal, da daa ba, ta har pal da ray kah ma da mbəzey aa awaw mendəvey ba ta har akah hay cewete, da daa ba, ta salay akah hay cewete. ");
INSERT INTO mif_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Da dey akah fa həldaka ŋga key mebərey na, wuzlka dey a, hazakada dəreŋ ta kah. Ŋgama kah ma hətey heter mendəvey ba ta dey pal, da ray kah ma da mbəzey aa vəgeɗ ŋga awaw magaza ta dey akah hay cewete. ");
INSERT INTO mif_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Pam leŋgesl, kwa ka da rəsam ndaw pal letek da wuzlah ndəhay ma pamata ray ata ŋga mecəhe anda bəza hay ba. Fara fara, ya fa ləvkwar maslaŋ ata hay da vaɗ fa lacafamatar a ray da cakay Papay da vaɗ mandaw mandaw.  ");
INSERT INTO mif_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Maja yah *Bəz ŋga Ndaw, ya sawa na, ŋga ləhdata ndəhay masa maazəɗtakaya.» ");
INSERT INTO mif_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Da ndaw aa ta təɓaŋ hay temere, da pal da wuzlah ata taa zəɗey sem na, ndaw aha a da key na, kwara? A mbəkdata təɓaŋ hay kwakwar zlam-letek a ray a zlam-letek da aŋgwa, a daw a səpərwa pal masa meezəɗey a ŋgene daa ba daw? ");
INSERT INTO mif_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ya fa ləvkwar fara fara, da masa ta hətərwa la na, aa səmey la ga da ray təɓaŋ a pal ŋgene, ma fəna da ray kwakwar zlam-letek a ray a zlam-letek masa taa zəɗam daa ba heyey. ");
INSERT INTO mif_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ara kəne, Papakw akwar masa da vaɗ may, a wuɗey kwa ndaw pal letek da wuzlah ndəhay ma təɓa mey aŋga hay aa zəɗey ba.» ");
INSERT INTO mif_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesu aa guzltar a gula aŋga hay, a ləvtar: «Da məlmakw ta kaka cek maaya ba la na, daw fa vəɗa, kadara mebərey aŋga ha, akwar taa cew e. Da ta cəndakawa mey akah la na, ŋgene ara cek maaya, kah ma ɗiya məlmakw a sem. ");
INSERT INTO mif_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ama da a cəndakawa mey akah ba na, ŋgəley ndaw pal, da daa ba, ndəhay cew asi akah. Ka ka anda keɗe na, anda ɗerewel ŋga Gazlavay ma ləvey: “Kwa cek wura wura maaya ba masa ndaw ma ka, ŋga sərey mey da ray a fara fara na, maaya na, ndəhay cew, da daa ba, maakar a nəkmara mey a, a kam sede da ray mey a.” ");
INSERT INTO mif_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Da a cəndakwara ba cəŋga na, kada mey a, a ndəhay daa *mecəmey-ray ŋga ndəhay aɗaw hay. Da a cəntar mey a ndəhay daa mecəmey-ray a ba cəŋga na, pa məlmakw a ŋga ndaw ma səra Gazlavay ba, da daa ba, pa ŋga *ndaw ma cakala budaw.» ");
INSERT INTO mif_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Ya fa ləvkwar fara fara, kwa mey wura wura masa akwar ma da jəwmara da bəla na, aŋga majəwkaya da gazlavay da vaɗ may. Asaya, kwa mey wura wura masa akwar ma da pəskamara da bəla na, aŋga mapəskakaya da gazlavay da vaɗ may. ");
INSERT INTO mif_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Ya fa ləvkwar saya: da ndəhay cew da bəla keɗe, a cəmam ɗay ŋgaa cəfɗey kwa meeme daa medərey-daŋgay na, Papay da vaɗ a vəltar la. ");
INSERT INTO mif_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Maja da ndəhay cew, da daa ba, maakar ta cəmam la ta mezəley aɗaw na, yah da wuzlah ata.» ");
INSERT INTO mif_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Fa dəɓa ha, *Piyer ta’, a ŋgəchey fa Yesu, a ləvar: «Bay Mahura, da məlma aɗaw fa kaya cek maaya ba mandaw mandaw na, ya da mbəkdara mebərey aŋga na, dey we? Haa dey maasala daw?» ");
INSERT INTO mif_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu a mbəɗdara, a ləvar: «Kay! dey maasala daada ba, ama dey kwakwar maasala haa dey maasala ha. ");
INSERT INTO mif_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Maja ŋgene, ya wuɗey ŋga ŋgakwar mey amba ka sərmara Gazlavay a wey da ray ndəhay na, kwara. Bay daha a wuɗey ŋgaa cəfɗa dəvaz aŋga fa ndəhay ma ka sləra aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Masa aŋga fa zlar ŋgaa cəfɗa dəvaz a na, a handamar ndaw pal masa ta dala aŋga da ray a ga a sləfey ba. ");
INSERT INTO mif_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Cek aŋga ŋga pəla daa ba. Anda keɗe, bay a, a pəskatar mey a gula aŋga hay ŋga həɗkadamara ndaw aha, ta ŋgwas aŋga, ta bəz aŋga hay leŋ cek aŋga hay cəpa ŋga pəley dəvaz a. ");
INSERT INTO mif_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ta’, ndaw a heyey, a pətkweley fa mey ŋga bay aŋga ha, a ləvar: “Ambahw, bay aɗaw, vəlya ɗar nekəɗey, cay na, ya pəlkawa cəpa.” ");
INSERT INTO mif_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bay heyey dey-ceceh a kar fa ndaw aha. Anda keɗe, a mbəkda dəvaz aŋga da ray ndaw aha heyey cəpa, ta’, a mbəkda ŋga daw. ");
INSERT INTO mif_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Masa ndaw aha fa bawa na, a cam ray ta ndaw mekele masa ata ma kam sləra bama. Dəvaz aŋga fa ndaw aha daha may, dəvaz a, kuset kəɗey gway. Kaw! a kərza ndaw aha kasl! asi ɗay. Ta’, a ləvar: “Pəlyawa dala aɗaw.” ");
INSERT INTO mif_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ndaw masa ata ma kam sləra bama heyey, ta’, a pətkweley fa mey aŋga, a dərar daŋgay, a ləvar: “Ambahw, vəlya ɗar nekəɗey, cay na, ya pəlkawa.” ");
INSERT INTO mif_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ama ndaw kaa heyey a təɓa ba. Ta’, a handa, a kəzla aa fərsəne, haa aŋga ma pəlra dəvaz aŋga ha. ");
INSERT INTO mif_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mandala aŋga hay siya ma hətmar na, a rəzlam, mevel a catar ga. Ta’, a diyam a wuzdamara mey a cəpa a bay ata heyey. ");
INSERT INTO mif_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Da ray ŋgene, bay a heyey a zəlrawa ndaw aha, a ləvar: “Kah na, ndaw malamba. Ya ta mbəkdakawa dəvaz masa da ray kah sem cəpa maja kah ma dərya daŋgay. ");
INSERT INTO mif_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kaa kah na, ka sərfar dey-ceceh fa mandala akah anda yah ma sərfaka dey-ceceh ba na, kwara?” ");
INSERT INTO mif_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mevel a car a bay heyey, ta’, a vəlda a har ndəhay ŋga sərdamara banay, haa aa ma pəlra dəvaz aŋga ha cəpa.» ");
INSERT INTO mif_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Cay, Yesu ta’, a patar leŋgesl, a ləvtar: «Yaw, ara anda ŋgene, da ndaw da wuzlah akwar a mbəkdara mebərey ŋga məlmaha ta mevel pal ba na, Papay da vaɗ, fa da mbəkdara mebərey aŋga daa ba kəne may.» ");
INSERT INTO mif_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Masa Yesu ma ndəvda mey aŋga cay na, ta’, a bey daa hwayak ŋga *Galile, a daw aa hwayak ŋga *Jude da dey laŋgar ŋga wayam ŋga Jurdeŋ. ");
INSERT INTO mif_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ndəhay ga, a səpmar wurzay. Feteɗe, ta’, a mbəldata masa-macay hay da wuzlah ata. ");
INSERT INTO mif_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","*Fariza hay a diyam a cakay a, amba a jadamara. Aa cəfɗamara, a ləvmar: «Kwakwas aləkwa a vəley cəveɗ a ndaw ŋga ɓəla ŋgwas aŋga, kwa fa mey wura wura daw?» ");
INSERT INTO mif_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu a mbəɗdatara, a ləvtar: «Mawuzlalakaya daa ɗerewel ŋga Gazlavay a ləvey: “Daa mezley ŋga bəla, Gazlavay a ləmwa na, zel ta ŋgwas.” Ka ta jaŋgamara mey a daa ba daw? ");
INSERT INTO mif_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Gazlavay a ləvey saya: “Maja ŋgene, ndaw-mezəle a mbəkda papaha ta mamaha, amba a cəmam ta ŋgwas aŋga. Ata cewete, a təram anda ndaw pal.” ");
INSERT INTO mif_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Anda keɗe, ata ndəhay cew saba, ama ata anda ndaw pal. Yaw, cek masa Gazlavay ma cəma sem anda keɗe na, ndaw a da wunka ba.» ");
INSERT INTO mif_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fariza hay a, aa cəfɗamara Yesu a saya, a ləvmar: «*Mawiz ta wuzleley mewey la ma ləvey, da ndaw a wuɗey ŋga ɓəla ŋgwas aŋga na, si a wuzlalar ɗerewel ŋga wuzda aŋga ma ɓəla sem. Kaa a wuzlala mey a anda keɗe na, maja me?» ");
INSERT INTO mif_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu a mbəɗdatara, a ləvtar: «Mawiz a vəlkwar cəveɗ ŋga ɓəley ŋgwas akwar hay na, maja mevel akwar maaya ba. Ama daa mezley ŋga bəla na, cek aha ta key kəne na, daa ba. ");
INSERT INTO mif_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya fa ləvkwar fara fara, kwa waawa ma ɓəla ŋgwas aŋga, ŋgwas aha ta ley vaw saw da palah daa ba, a ley ŋgwas mekele, a key ŋgene na, a ley vaw saw da palah.» ");
INSERT INTO mif_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Gula aŋga hay, a ləvmar: «Da ŋga ɓəley ŋgwas si anda keɗe na, ŋgama, ndaw a njey manjar ŋgwas.» ");
INSERT INTO mif_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu a mbəɗdatara, a ləvtar: «Ndəhay cəpa a təɓmara mey a ŋga key kəne ba. Ma gwa ŋga təɓmara na, si ndəhay masa Gazlavay ma vəltar gədaŋ ŋga təɓmara mey a. ");
INSERT INTO mif_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sərmara, cek hay mekele mekele daha ma təkta ndəhay ŋga ley ŋgwas. Ndəhay siya maja vaw a latar ba dəga ŋga mayawa ata, siya maja ata maaŋgwaɗatakaya, siya hay may a njam manjar ŋgwas, maja a wuɗam ŋga key sləra ŋgada Bay Gazlavay gway. Da ndaw ma gwa ŋga təɓa mey masa yah ma kada da ray meley ŋgwas keɗe daha na, ŋga təɓa.» ");
INSERT INTO mif_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Fa dəɓa ha, ndəhay a handamata bəza hay fa Yesu, amba a patar har a ray, a pəstar mey, a dərey daŋgay maja ata. Ama gula aŋga hay, a kamatar mey a ndəhay a. ");
INSERT INTO mif_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Da ray ŋgene, Yesu aa guzltar a gula aŋga hay a, a ləvtar: «Mbəkdamatərwa bəza hay ŋga samawa fa yah! Ka da təkmata ba, maja Gazlavay fa wey da ray ndəhay masa anda bəza hay a.» ");
INSERT INTO mif_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ta’, a patar har a ray, a pəstar mey. Fa dəɓa ha, ndal! madaw aŋga. ");
INSERT INTO mif_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ta pas laŋgar daha, bəz-gula daha a ŋgəchey a cakay Yesu, aa cəfɗa, a ləvar: «Bay aɗaw, ya da key maaya amba ya hətey heter mendəvey ba na, me?» ");
INSERT INTO mif_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu a mbəɗdara, a ləvar: «Kaa cəfɗaya da ray mekey cek maaya na, maja me? Ara Gazlavay pal taava aŋga, ndaw maaya. Da ka wuɗey ŋga hətey heter mendəvey ba na, si ka nar ray a *mewey hay ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Gula ha aa cəfɗa Yesu, a ləvar: «Ya ney ray na, a mewey hay wura?» Yesu a mbəɗdara, a ləvar: «Ka da kəɗey ndaw vagay ba, ka da ley vaw saw da palah ba, ka da leley ba, ka da mbərzley a ray ndaw ba. ");
INSERT INTO mif_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Natar ray ŋgada ata papakw ta mamakw, asaya, wuɗa meseembew akah anda kah ma wuɗa ray akah.» ");
INSERT INTO mif_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bəz-gula ha, a ləvar: «Mewey hay a cəpa keɗe, ya ta zləɓta daa ba səlak, ma mbəkya ŋga key na, wura dəɓa wura?» ");
INSERT INTO mif_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu a ləvar a bəz-gula ha: «Da ka wuɗey ŋga tərey ndaw maaya kalah na, daw, həɗkadata cek akah hay tabiya, wunkatara dala ha a masa-viya hay. Da ka ta ka la anda keɗe na, ka da hətey zleley fa Gazlavay da vaɗ. Masa kah ma vəldatara dala ha cay a masa-viya hay na, sawa, səpya.» ");
INSERT INTO mif_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Masa bəz-gula ha ma cənda mey a anda keɗe na, ta’, a daw, aŋga ta meesəmey daa ba, maja aa ta zleley ga, a wuɗey ŋga vəldatara a ndəhay ba. ");
INSERT INTO mif_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Da ray ŋgene, Yesu aa guzltar a gula aŋga hay, a ləvtar: «Ya fa ləvkwar fara fara, aŋga ta banay ga ŋgada ndaw masa-zleley amba a təɓa Gazlavay ŋga wey da ray a. ");
INSERT INTO mif_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Asaya, ya fa ləvkwar, aŋga ta banay ŋgada slagwama ŋga mbəzey taa vəgeɗ ŋga baatal. Ama, aŋga ta banay ga ma fəna saya ŋgada ndaw masa-zleley ŋga təɓa Gazlavay ŋga wey da ray a.» ");
INSERT INTO mif_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Masa gula aŋga hay ma cəndamara mey a keɗe na, a rəzlam ga, a ləvam: «Kay! Da anda keɗe na, ma da ləhey daa mebərey na, wa?» ");
INSERT INTO mif_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Da ray ŋgene, Yesu a nəkta, a ləvtar: «Meləhey daa mebərey na, ara cek masa ndaw-magədaŋ ma gwa ŋga ka ba, ama Gazlavay na, a gwa ŋga kata cek hay tabiya.» ");
INSERT INTO mif_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ta’, *Piyer aa guzlar a Yesu a, a ləvar: «Yaw, ala na, ya ta mbəkdamatərwa cek ala hay sem cəpa, amba ya səpmaka. Kaa ya da hətam fa salay ala na, me?» ");
INSERT INTO mif_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu a mbəɗdatara, a ləvtar: «Ya fa ləvkwar fara fara, ta pas masa cek hay cəpa ma da təram mawiya na, yah, *Bəz ŋga Ndaw, ya da njey aa slam-menjey aɗaw mawaɗakaya ŋga wey da ray ndəhay. Akwar, kuraw a ray a cew masa ma səpmaya keɗe na, ka da njam aa slam-menjey ŋga bay hay amba ka kamatar sariya ŋgada səkway hay kuraw a ray a cew ŋga *Israyel. ");
INSERT INTO mif_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Da ndaw a mbəkdərwa way aŋga, da daa ba, a mbəkdatərwa məlmaha hay, dam-mamaha hay, mamaha, papaha, bəz aŋga hay, da daa ba, a mbəkdatərwa ley aŋga hay, amba a səpya na, ndaw aha a hətey cek hay a la ma fəna masa aŋga ma mbəkdatərwa ŋgene a key dey temere. Asaya, a hətey heter mendəvey ba la may. ");
INSERT INTO mif_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yaw, ndəhay ga ma təɓmara mey aɗaw ŋgeeme, a da vəham fa dəɓa. Asaya, ndəhay ga masa fa dəɓa, a da diyam fa mey.» ");
INSERT INTO mif_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ta’, Yesu aa guzltar a gula aŋga hay, a ləvtar: «Ya gwa ŋga wa cek masa ndəhay ma da hətam ta pas masa Gazlavay ma da wuzdərwa mewey aŋga da ray ndəhay na, ta me? Ehe, ya ŋgakwar mey da ray a. Bay ŋga ley daha, a bawa taa pərek e ŋga səpey ndəhay ŋga key sləra da ley aŋga. ");
INSERT INTO mif_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A kam maɗay ta ndəhay ma ka sləra. Fa mevərndey na, a da vəltar dala təɗe ŋga sləra ŋga ndaw mevərndey da ley. Ta’, a ləvtar ŋga diyam a ley aŋga ha dəɓa. ");
INSERT INTO mif_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pas təɗe mehəley maaca na, a bawa da way saya, a da nəkey dey na, a ray ndəhay mekele hay manjatakaya ŋga maaya daa slam aha. ");
INSERT INTO mif_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ta’, a ləvtar: “Diyam ta kam sləra da ley aɗaw katay may, amba ya pəlkwar dala təɗe fa sləra akwar a.” ");
INSERT INTO mif_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ta’, ndəhay a, a diyam aa sləra ha. Bay ŋga ley kaa heyey a bawa ta wuzlah-pas, a həley ndəhay mekele. Asaya, a bawa ta pas ŋgaa kwaɗ, a həley ndəhay mekele saya. ");
INSERT INTO mif_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pas gweegwe a kəzley na, a bawa, a hətey ndəhay manjatakaya daa slam aha saya, a ləvtar: “Ka vərndam ŋga maaya anda keɗe na, maja me?” ");
INSERT INTO mif_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","A mbəɗdamara, a ləvmar: “Ya vərndam ŋga maaya na, maja ndaw ma həlndar aa sləra daa ba.” Anda keɗe, a ləvtar: “Yaw, diyam a ley aɗaw, ta kam sləra may.” ");
INSERT INTO mif_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Masa pas ta kəzley cay na, ta’, a zəlrawa *bay-ray ŋga sləra aŋga, a ləvar: “Zəltərwa ndəhay ma ka sləra, pəltara dala ata. Ka zlar ta fa ndəhay ma samawa madagway-dakw haa kasl fa ndəhay ma samawa ŋgeeme.” ");
INSERT INTO mif_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ndəhay madagway-dakw heyey a diyam fa bay-ray ŋga sləra heyey dəɓa, a təɓmara dala ata, kwa waawa a hətey dala təɗe ŋga sləra ŋga ndaw mevərndey da ley. ");
INSERT INTO mif_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ndəhay ŋgeeme heyey a diyam may, a wulkam na, a da hətam ma fəna ŋga ndəhay madagway-dakw hay heyey. Ama, a hətam na, dala təɗe ŋga sləra ŋga ndaw mevərndey da ley cəŋga gway. ");
INSERT INTO mif_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Masa fa təɓmara dala ha na, faa ŋguram mey da ray bay ŋga ley a, ");
INSERT INTO mif_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","a ləvam: “Ndəhay ma samawa madagway-dakw keɗe, a kam sləra ɓərey pal gway, ama ka vəltar dala letek ta ala ma kam sləra hipas daa pas mecey na, kwara?” ");
INSERT INTO mif_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ta’, bay ŋga ley a, aa guzley ŋgada ndaw pal da wuzlah ata, a ləvar: “Jam aɗaw, ya ta bataka daa ba səlak, maja ya kakwa maɗay na, da ray dala təɗe ŋga mevərndey ŋga sləra ŋga ndaw pal da ley, ba diya? ");
INSERT INTO mif_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Təɓa dala akah masa anda aləkwa ma kakwa maɗay, daw. Ya wuɗey ŋga vəlar dala həma ŋga akah a ndaw ma sawa aa sləra fa dəɓa keɗe. ");
INSERT INTO mif_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Fa kah na, ya gwa ŋga key cek ta zleley aɗaw anda yah ma wuɗey ba daw? Səleŋ fa kaka maja yah ndaw maaya daw?”» ");
INSERT INTO mif_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ta’, Yesu aa guzltar saya, a ləvtar: «Ara anda keɗe, ndəhay madagway-dakw, a da təram ndəhay ŋgeeme, asaya, ndəhay ŋgeeme a da təram ndəhay madagway-dakw.» ");
INSERT INTO mif_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ata Yesu fa diyam a *Jeruzelem. Daa masa ata daa cəveɗ na, ta’, Yesu a ŋgəlta gula aŋga hay kuraw a ray a cew ta cakay, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ehe, wure keɗe aləkwa fa nakwa a Jeruzelem. Feteɗe na, a da vəldamaya, yah *Bəz ŋga Ndaw, a har *bay-ray hay ŋga ndəhay ma ka kwakwas ta *ndəhay maa sərkada kwakwas ŋga Mawiz. A da kamaya sariya ŋga kəɗey vagay. ");
INSERT INTO mif_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Asaya, a da vəldamaya a har ndəhay masa *Jəwif hay ba, amba aa saŋgəram a ray aɗaw, a sləɗmaya ta laway, a dərmaya fa hwadam mazlaŋgalakaya, ya məcey la. Ŋga ɗar maakar a na, ya sləkɗawa la daa meməcey a.» ");
INSERT INTO mif_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Fa dəɓa ha, ŋgwas ŋga Zebede ta bəz aŋga hay a ŋgəcham fa Yesu. Ŋgwas aha a regedey fa mey aŋga, aa cəfɗa ŋga jəna. ");
INSERT INTO mif_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu ta’, aa cəfɗa, a ləvar: «Ka wuɗey na, me?» Ŋgwas aha, aa mbəɗdara, a ləvar: «Ya wuɗey na, ka ləvya dəga wure keɗe, daa masa ka fa zəma bay akah na, ka da njadata bəz aɗaw hay cew keɗe, pal ta har-zəmay akah, laŋgar ta har-gula akah.» ");
INSERT INTO mif_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu aa guzltar a bəza hay ŋga ŋgwas a heyey, a ləvtar: «Ka sərmara cek masa akwar maa cəfɗam ba. Ka gwamara ŋga səram banay la anda yah ma da səra daw ?» Ta’, a mbəɗdamara, a ləvmar: «Ahaw, ya gwamara.» ");
INSERT INTO mif_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu a ləvtar: «Ahaw, ka səram banay la anda yah ma da səra. Ama ŋga njey ta har-zəmay aɗaw, da daa ba, ta har-gula aɗaw na, ara yah ma da ɗəsla mey a ŋgene ba. Ara Papay ma ɗiyta slam hay a ŋgene ŋgada ndəhay masa aa ma walata.» ");
INSERT INTO mif_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Fa dəɓa ha, masa gula aŋga hay siya kuraw ma cəndamara mey a na, a cam mevel a ray məlmaŋ hay cew heyey. ");
INSERT INTO mif_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Da ray ŋgene, Yesu a zəlta tabiya, a ləvtar: «Ka sərmara da wuzlah ndəhay da bəla keɗe na, bay hay daha. Bay hay a na, fa wam da ray ndəhay ta gədaŋ, asaya, mahura hay mekele fa wam da ray ndəhay ta cəveɗ e ba. ");
INSERT INTO mif_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama da wuzlah akwar na, a da key kəne ba. Yaw, da ndaw da wuzlah akwar a wuɗey ŋga key mahura na, si a tərey ndaw ma ka sləra akwar. ");
INSERT INTO mif_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Asaya, da ndaw da wuzlah akwar a wuɗey ŋga key *bay-ray na, si a tərey anda beke akwar. ");
INSERT INTO mif_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Anda keɗe, kwa yah, *Bəz ŋga Ndaw, ya sawa a bəla na, amba ndəhay a kamaya sləra ba. Ama ya sawa a bəla na, amba ya katar sləra a ndəhay, ya vəlda heter aɗaw ŋga ləhey ndəhay ga daa mebərey.» ");
INSERT INTO mif_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Masa ata Yesu ta gula aŋga hay fa bam da Jerikwaw na, ndəhay ga fa səpmatar wurzay. ");
INSERT INTO mif_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ndəhay wulaf hay cew daha manjatakaya da mey-cəveɗ. A cəndamara na, Yesu fa daw ta ŋgene. Ta’, a wudam, a ləvam: «Bay Mahura, Bəzey ŋga *Davit, ambahw sərfandar dey-ceceh may taw!» ");
INSERT INTO mif_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ndəhay ga heyey a kamatar mey, a ləvmatar ŋga njam teete. Ama wulaf hay a, a wudam ta gədaŋ ta gədaŋ cəŋga, a ləvam: «Bay Mahura, Bəzey ŋga Davit, ambahw sərfandar dey-ceceh may taw!» ");
INSERT INTO mif_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu ta’, a lecey, a zəltərwa, aa cəfɗata, a ləvtar: «Ka wuɗam ya kakwar na, me?» ");
INSERT INTO mif_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ta’, wulaf hay a, a mbəɗdamara, a ləvmar: «Bay Mahura, ya wuɗam ka wurndara dey ala.» ");
INSERT INTO mif_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Wulaf hay a, a kamar dey-ceceh a Yesu. Aŋga gas! gas! a gəsfatar har fa dey ata. Wure wure ŋgene, dey ata ha, wur! wur! a wuram, a hətmar dey maaya maaya dəɓa. Fa dəɓa ha, ta’, a diyam asiya. ");
INSERT INTO mif_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ata Yesu ta gula aŋga hay fa diyam aa berney ŋga *Jeruzelem. Masa ata gweegwe ta berney a na, a wusam gweegwe ta slala daha mezəley Betfaje da rav Aŋgwa ŋga *Awliviye. Yesu ta’, a slərey gula aŋga hay cew teeseɗ ŋgada slala ha, ");
INSERT INTO mif_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a ləvtar: «Diyam a slala fa mey akwar katay, ka da hətfam madi-zəŋgwaw majəwkaya ta babəza da cakay a. Pəskamərwa, handamatiwa cewete. ");
INSERT INTO mif_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Da ndaw a təkakwar ŋga pəska na, ləvmar: “Bay Mahura a wuɗey.” Ŋgene na, ndaw aha, a mbəkdakwar la ŋga pəska wure ŋgene.» ");
INSERT INTO mif_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yaw, cek aha ta key la amba a key anda Gazlavay maa guzlwa zleezle ta mey *ndaw ma təla mey aŋga ma ləvey: ");
INSERT INTO mif_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Ləvmatar a ndəhay daa berney ŋga *Siyaŋw: nəkam dey, bay akwar fa sawa fa akwar. Ara ndaw meekweɗ-mey, aa da ray madi-zəŋgwaw, aa da ray babəza ŋga madi-zəŋgwaw aha.» ");
INSERT INTO mif_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Da ray ŋgene, gula aŋga hay cew heyey a diyam, a kamara anda Yesu ma ləvtar ha. ");
INSERT INTO mif_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","A handamar madi-zəŋgwaw ta babəza ha dəɓa. Gula aŋga hay a, a ciymata zana ata hay a ray zəŋgwaw hay a. Yesu ta’, a njey a ray a. ");
INSERT INTO mif_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ndəhay ga malacatakaya daa cəveɗ ŋga cey ray ta Yesu, a ciyam zana ata hay aa cəveɗ ŋga həslmar ray. Siya hay da wuzlah ata, a bəzlham mey-har ŋga wudez hay, a pamata aa cəveɗ e may. ");
INSERT INTO mif_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ndəhay fa diyam fa mey aŋga, leŋ fa dəɓa aŋga, ata tabiya fa wudam, a ləvam: «*Hawzana! Həlmakwa Bəzey ŋga *Davit! Anja Bay Gazlavay ŋga pəsar mey a ndaw masa aa ma slərdərwa ta mezəley aŋga. Həlmakwa Bay Gazlavay da vaɗ!» ");
INSERT INTO mif_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Masa Yesu a fa mbəzey aa berney ŋga Jeruzelem na, ndəhay daa berney a, a mbəɗam haya! haya! aa cəfɗam vaw da wuzlah ata, a ləvam: «Keɗe he na, ara wa?» ");
INSERT INTO mif_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ndəhay ga ma diyam ta Yesu heyey, a mbəɗdamatara, a ləvmatar: «Ara ndaw ma təla mey ŋga Gazlavay, mezəley Yesu, ndaw *Nezeret daa hwayak ŋga *Galile.» ");
INSERT INTO mif_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Fa dəɓa ha, Yesu a mbəzey aa papalah ŋga *Way-mekey-kwakwas ŋga Gazlavay. Feteɗe na, ndəhay fa kam luma. Maja ŋgene, ta’, a ɓəlta ndəhay tabiya ma həɗkadam cek hay leŋ ndəhay ma həɗkam cek hay. A bəzlta slam hay ŋga ndəhay ma mbəɗa dala ta jaŋga hay ŋga ndəhay ma həɗkadam makurgwadakw hay. ");
INSERT INTO mif_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ta’, a ləvtar: «Mawuzlalakaya daa ɗerewel ŋga Gazlavay, Gazlavay a ləvey: “Way aɗaw na, ara way amba ndəhay a dərmaya daŋgay da hwaɗ a.” Ama akwar na, ka tərdamara way a keɗe ŋga slam ŋga mayal hay!» ");
INSERT INTO mif_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ndəhay wulaf hay ta ndəhay jegwer hay a ŋgəcham fa Yesu daa Way-mekey-kwakwas a. Ta’, a mbəldata. ");
INSERT INTO mif_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ndəhay mahura hay da ray ndəhay ma ka kwakwas ŋga Gazlavay leŋ *ndəhay maa sərkada kwakwas ŋga Mawiz, a hətmatar maazla hay masa Yesu ma ka. Asaya, a hətmatar bəza hay daa Way-mekey-kwakwas ŋga Gazlavay a, fa wudam, a ləvam: «*Hawzana! Həlmakwa Bəzey ŋga *Davit!» Da ray ŋgene, mevel a catar. ");
INSERT INTO mif_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ta’, a ləvmar a Yesu: «Ka fa cənda mey masa ata maa guzlam keɗe daw?» Yesu a mbəɗdatara, a ləvtar: «Ahaw, ya fa cənda. Mawuzlalakaya daa ɗerewel ŋga Gazlavay, a ləvey: “Bay Gazlavay, ka taa sərkadata bəza hay mecəhe hay ta bəza hay da mey ɗəwa la ŋga həlmamaka.” Ka ta jaŋgamara mey a daa ba daw?» ");
INSERT INTO mif_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Fa dəɓa ha, Yesu a mbəkdata, a bawa daa berney ŋga *Jeruzelem e, a daw a slala Betani. A ney feteɗe dasi tavaɗ a ŋgene. ");
INSERT INTO mif_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pepərek e, ta slam ŋgaa pərek na, Yesu a vəhwa aa berney ŋga *Jeruzelem, may fa car. ");
INSERT INTO mif_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Daa masa aŋga fa daw na, a hətey wudez daha da mey-cəveɗ, a yey babəza anda gudav. Ta’, a daw a cakay wudez e, ama a hətfey fa wudez e na, si gwaslaf a gway, babəza fa vəɗa daa ba. Da ray ŋgene, Yesu a nəsa wudez e, a ləvey: «Kuse! Ka yey babəza saba ŋga sərmataw.» Wure wure ŋgene, wudez e, a kweley. ");
INSERT INTO mif_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Daa ŋgene, gula aŋga hay, ata da siya. Masa ata ma hətmar wudez e ma kweley anda ŋgene na, a rəzlam, a ləvmar a Yesu: «Wudez e, a kweley fiyaw fiyaw na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu a mbəɗdatara, a ləvtar: «Ya fa ləvkwar fara fara, da akwar fa pamara Gazlavay ŋga ndaw akwar fara fara, asaya, da akwar fa wulkam cew cew daa ba na, ka gwamara ŋga key cek anda yah ma ka ŋgada wudez keɗe daada ba, ama ka gwamara kwa ŋga ləvar ŋgada aŋgwa mahura keɗe: “Sləkɗey la feɗe, kəzley aa bəlay” na, a key la kəne. ");
INSERT INTO mif_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Da akwar fa pamara Gazlavay ŋga ndaw akwar fara fara na, cek masa akwar maa cəfɗamara daa medərey-daŋgay na, a vəldakwara la cəpa.» ");
INSERT INTO mif_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Fa dəɓa ha, Yesu a mbəzey aa papalah ŋga *Way-mekey-kwakwas ŋga Gazlavay. Aa sərkadata ndəhay feteɗe. Masa aŋga faa sərkadata ndəhay a na, ta’, *bay-ray hay da ray ndəhay ma ka kwakwas ŋga Gazlavay leŋ mahura hay ŋga *Jəwif hay a ŋgəcham a cakay a, aa cəfɗamara, a ləvmar: «Ma ləvka ŋga kata cek hay a keɗe na, wa? Asaya, ma vəlka cəveɗ ŋga kata na, wa?» ");
INSERT INTO mif_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu, ta’, a mbəɗdatara, a ləvtar: «Yaw, yah may, amba yaa cəfɗakwar mey pal. Da akwar ta mbəɗdamiwa mey a la na, yah may, ya kadakwara ndaw ma vəldiwa cəveɗ ŋga kata cek hay a keɗe la. ");
INSERT INTO mif_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kaa ma slərdərwa *Jaŋ-Baptis ŋga katar *baptem a ndəhay na, wa? Gazlavay daw, ndəhay daw?» Da ray ŋgene, ndəhay mahura hay a ta bay-ray hay a, a slam yawa da wuzlah ata, a ləvam: «Ya da mbəɗdakwa aa mey aŋga ha na, kwara? Da ya ləvkwa: “Ara Gazlavay ma slərdərwa” na, a da mbəɗdandakwara, a ləvey: “Kaa ka təɓmara mey ŋga Jaŋ-Baptis a ba na, maja me?” ");
INSERT INTO mif_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ama da ya ləvkwa: “Ara ndəhay ma slərdamərwa” na, ya zlurakwa ta ndəhay maja ndəhay tabiya fa wulkam Jaŋ-Baptis na, ara *ndaw ma təla mey ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Da ray ŋgene, ta’, a mbəɗdamara a Yesu, a ləvmar: «Ya sərmara ba.» Yesu, ta’, a mbəɗdatara, a ləvtar: «Yaw, da anda keɗe na, ya fa da kadakwara ndaw ma vəlya cəveɗ ŋga kata cek hay a keɗe, daa ba may.» ");
INSERT INTO mif_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu aa guzltar a ndəhay daa *Way-mekey-kwakwas ŋga Gazlavay heyey saya, a ləvtar: «Ya wuɗey ya ŋgakwar mey amba ka wulkam da ray a. «Ndaw daha, aŋga ta bəza hay cew. A ləvar ŋgada bəzey mahura: “Bəz aɗaw, tasana daw ta kawa sləra da ley.” ");
INSERT INTO mif_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Bəzey a, a mbəɗdara, a ləvar: “Ya fa da daw daa ba.” Ama menjey nekəɗey na, a mbəɗda leŋgesl aŋga, ta’, a daw ŋga kawa sləra ha. ");
INSERT INTO mif_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Papaha, ta’, a ləvar ŋgada bəzey mecəhe saya, kəne may. Bəzey a, a mbəɗdara, a ləvar: “Aya, papay.” Ama fa dəɓa ha, bəzey a, ta daw ŋga kawa sləra heyey daa saba. ");
INSERT INTO mif_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kaa dasi bəza hay cew keɗe, ma ka cek masa papa ata ma wuɗey la na, wura?» Ndəhay a, a mbəɗdamara, a ləvmar: «Ara bəzey mahura.» Yesu a mbəɗdatara ŋgada ndəhay a dəɓa, a ləvtar: «Ahaw, kəne, ama ya fa ləvkwar fara fara, ndəhay maaya ba hay anda ndəhay ma cakala budaw ta ŋgwas-barlaw hay, a mbəzam la teeseɗ da ray akwar a wuzlah ndəhay masa Gazlavay ma wey da ray ata. ");
INSERT INTO mif_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","*Jaŋ-Baptis ta sawa la ŋga wuzkwar cəveɗ masa dər e, ama akwar ta təɓmara mey aŋga daa ba. Ndəhay ma cakala budaw ta ŋgwas-barlaw hay, ata na, ta təɓmara mey aŋga la. Kwa masa akwar ma hətmar ata ma mbəkdamara mekey mebərey na, akwar ta mbəɗdamara menjey akwar ŋga təɓey mey ŋga Jaŋ-Baptis a daa ba cəŋga.» ");
INSERT INTO mif_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu aa guzltar a ndəhay saya, a ləvtar: «Jəkam sləmay fa mey-meŋgey mekele. Ndaw daha, a key jerne ŋga wudez ma yey babəza mezəmey. Ta’, a zləɓa jerne he ray a zlar. Daa jerne he na, a ɗiyey slam ŋga ɗəcey babəza ŋga wudez e, a ləmey way magəlkaya maazəma ŋgada ndaw ma jəɗa jerne he. A vəlda jerne he a har ndəhay ŋga kam sləra da hwaɗ a. Fa dəɓa ha, ta’, a daw aa slam dəreŋ. ");
INSERT INTO mif_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Masa kiya meŋgəley babəza ŋga wudez daa jerne he ta wuswa cay na, bay ŋga ley a, a slərey gula aŋga hay ŋga təɓwa babəza ŋga wudez e maala ŋga aŋga. ");
INSERT INTO mif_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Masa gula hay a ma wusam cay fa ndəhay ma ka sləra daa jerne kaa heyey na, ndəhay ma ka sləra hay a, kaw! kaw! a kərzamata. Gula laŋgar, a sləɗmara, laŋgar may, a kəɗmara vagay, asaya, ta’, aa zakamara gula laŋgar ta aŋgwa vagay. ");
INSERT INTO mif_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Fa dəɓa ha, bay ŋga jerne kaa heyey a slərey gula hay ga ma fəna ŋgeeme heyey. Ndəhay ma ka sləra daa jerne kaa heyey, a kəɗmata kəne cəŋga. ");
INSERT INTO mif_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Fa dəɓa ha, ta’, a slərey bəzey aŋga, a wulkey, a ləvey: “A namar ray la a bəzey da hwaɗ aɗaw.” ");
INSERT INTO mif_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ama daa masa ndəhay ma ka sləra daa jerne kaa heyey ma hətmar bəzey aŋga ha fa sawa na, ta’, a slam yawa da wuzlah ata, a ləvam: “Katay ara bəzey ma da wa jerne keɗe fa dəɓa ŋga papaha. Nakwa ta kəɗkwa vagay, amba ya wakwa jerne he keɗe.” ");
INSERT INTO mif_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Anda keɗe, a kərzamara, a ɗaɗamara a dəɓa jerne he, ta’, a kəɗmara vagay.» ");
INSERT INTO mif_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu aa guzltar saya, a ləvtar: «Kaa wara bay ŋga jerne he ma da sawa na, a da kadata ndəhay a na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","A mbəɗdamara, a ləvmar: «Bay ŋga jerne he, a da kəɗta ndəhay lamba hay a vagay, kwa fa da sərfatar dey-ceceh daa ba. Fa dəɓa ha, a da vəlda jerne he a har ndəhay mekele. Ndəhay a, a da vəlmar babəza ŋga wudez e ta kiya meŋgəley babəza ha.» ");
INSERT INTO mif_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu ta’, aa guzltar, a ləvtar: «Akwar ta jaŋgamara mey mawuzlalakaya daa ɗerewel ŋga Gazlavay daa ba səlak daw? Mey masa ma ləvey: “Aŋgwa meləmey way masa ndəhay ma ləma way ma kəzlamara ta cakay na, aŋgwa ha na, ta tərey sem ŋga aŋgwa maaya meləmey way ma fənta siya hay jak. Ŋgene na, ara Bay Gazlavay ma ka cek aha, ara cek maaya fa dey aləkwa.”» ");
INSERT INTO mif_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Fa dəɓa ha, Yesu aa guzltar saya, a ləvey: «Da ndaw a təɗey a ray aŋgwa aha na, ndaw aha a da ŋgərfey. Asaya da aŋgwa aha a kəzley a ray ndaw na, a ɗəga ndaw aha la kwəɗ-kwaɗ anda bebəɗes. Ara maja keɗe, ya fa ləvkwar, akwar na, Bay Gazlavay fa da vəlkwar cəveɗ ŋga njey da wuzlah ndəhay aŋga hay daa ba. A da vəley cəveɗ na, si ŋgada ndəhay masa sləra ata ma mbafar.» ");
INSERT INTO mif_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Masa *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta *Fariza hay ma cəndamara mey-meŋgey masa Yesu maa guzlda ha na, a sərmara Yesu aa guzley na, da ray ata. ");
INSERT INTO mif_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Da ray ŋgene, a səpam cəveɗ amba a kərzamara. Ama a zluram ta ndəhay feteɗe maja ndəhay a, a wulkam Yesu na, ara *ndaw ma təla mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu aa guzltar ŋgada ndəhay daa *Way-mekey-kwakwas ŋga Gazlavay heyey ta mey-meŋgey hay saya, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Ya gwa ŋga wa *mewey ŋga Bay Gazlavay da ray ndəhay na, ta me? Yaw, bay daha, a key gwagway ta pas bəzey aŋga ma lawa kwakwa. ");
INSERT INTO mif_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A slərdata madərlam aŋga hay ŋga zəlwa ndəhay masa mazəltakaya ŋgadaa gwagway a. Ama ndəhay mazəltakaya ha, a gəmam ŋga samawa ba. ");
INSERT INTO mif_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","«Fa dəɓa ha, a slərey madərlam aŋga hay mekele saya, a ləvtar: “Diyam ta ləvmatar a ndəhay masa mazəltakaya na, ŋga samawa aa gwagway a. Yah ma hərta sla hay ta ɗahway cay, cek hay tabiya maɗiytakaya cay, ŋga samawa ŋga zəmey ɗaf ŋga gwagway a dəɓa.” ");
INSERT INTO mif_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ama ndəhay mazəltakaya ha, a pam leŋgesl fa mezəley a ba. A diyam ŋga key cek ata hay mekele. Ndaw laŋgar a daw a ley, ndaw laŋgar a daw a kawa filaw. ");
INSERT INTO mif_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Siya hay may, a kərzamata madərlam hay ŋga bay kaa heyey, a sərdamata banay, a kəɗmata vagay. ");
INSERT INTO mif_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Masa bay kaa heyey ma cənda na, mevel a car, a slərey sewje aŋga hay ŋga kəɗey ndəhay ma kəɗmata madərlam aŋga hay heyey vagay. Fa dəɓa ha, sewje hay a, a wawurmara berney ata. ");
INSERT INTO mif_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","«Cay, ta’, a ləvtar ŋgada madərlam aŋga hay siya: “Cek hay tabiya ŋga gwagway maɗiytakaya cay, ama ndəhay mazəltakaya na, ata təɗe ŋga samawa aa gwagway a saba. ");
INSERT INTO mif_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Anda keɗe, diyam aa cəveɗ mahura hay, zəlmawa kwa waawa masa akwar ma hətam amba a samawa, a zəmam ɗaf ŋga gwagway a.” ");
INSERT INTO mif_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ta’, madərlam aŋga hay kaa heyey, a diyam aa cəveɗ mahura hay, a zəlmawa ndəhay masa ata ma hətam, ndəhay maaya ta maaya ba hay cəpa, haa way masa ata ma kam gwagway da hwaɗ a kaa heyey a rəhey. ");
INSERT INTO mif_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Bay kaa heyey a daw, a mbəzey aa way ŋga gwagway ŋga nəktərwa ndəhay ma zəmam ɗaf ŋga gwagway a. A da nəkey dey na, a ray ndaw daha da wuzlah ata, zana ŋga gwagway fa vaw daa ba. ");
INSERT INTO mif_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aa guzlar a ndaw a, a ləvar: “Jam aɗaw, zana ŋga gwagway fa vaw akah daa ba kaa na, ka mbəzwa aa way a, ta wura?” Kwa ndaw aha, ta mbəɗdara daa ba. ");
INSERT INTO mif_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ta’, bay kaa heyey aa guzltar a ma ka sləra aŋga hay, a ləvtar: “Jəwmara salay ta har ŋga ndaw ŋgene, hazakadamara aa ambaw, aa ləvaŋ. Feteɗe na, a da təway, asaya, a daa pəɗey sler.”» ");
INSERT INTO mif_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu ta’, aa guzltar a ndəhay a saya, a ləvey: «Ahaw, ndəhay ga mazəltakaya, ama mawalatakaya na, ndəhay nekəɗey gway.» ");
INSERT INTO mif_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Fa dəɓa ha, ndəhay *Fariza hay, a kusam ta cakay ŋga səpey dabaray, amba a kərzamara Yesu fa mey masa aŋga ma daa guzlda. ");
INSERT INTO mif_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ta’, a sləram gula ata hay siya, ta ndəhay ŋga Bay *Herawt fa Yesu ŋgaa cəfɗamara. A ləvmar: «Bay ala, ya sərmara kah na, ndaw ma mbərzley ba, ka faa sərkadata ndəhay ŋga njam anda Gazlavay ma wuɗey fara fara, ka zlurey ta ndaw ba, asaya, ka nəkta ndəhay cəpa letek fa mey akah. ");
INSERT INTO mif_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Anda keɗe, ya wuɗam ŋgaa cəfɗamaka, kwakwas aləkwa na, a vəley cəveɗ ŋga pəley budaw a bay mahura *Sezere daw? A vəley cəveɗ ba daw? Wuzdandara mewulkey akah da ray mey a keɗe cey.» ");
INSERT INTO mif_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ama Yesu ta səra mewulkey ata maaya ba ŋgene sem. Ta’, a ləvtar: «Akwar ndəhay masa ta neneh cew, ka wuɗam ŋga jadamaya na, maja me? ");
INSERT INTO mif_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wuzmaya dala masa akwar ma pəlam budaw a ta aŋga.» Ta’, ndəhay kaa heyey a wuzmar dala ha pal. ");
INSERT INTO mif_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu a nəka dala ha, ta’, aa cəfɗata saya, a ləvtar: «Fa dala ha keɗe na, ara dey ŋga wa? Ara mezəley ŋga wa?» ");
INSERT INTO mif_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","A mbəɗdamara, a ləvmar: «Ara ŋga Sezere, bay mahura ŋga *Rawm.» Da ray ŋgene, Yesu a ləvtar: «Anda keɗe, cek masa ŋga Sezere na, vəldamara a Sezere he. Cek masa ŋga Gazlavay na, vəldamara a Gazlavay a.» ");
INSERT INTO mif_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Masa ata ma cəndamara Yesu ma mbəɗdatara anda ŋgene la na, a rəzlam ga da ray mey a. Mbak! a mbəkdamara, ta’, a diyam. ");
INSERT INTO mif_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta pas a ŋgene, ndəhay *Saduse hay a ŋgəcham a cakay Yesu. Saduse hay na, ara ndəhay ma wulkam, ma ləvam da ndaw ta məcey sem na, fa da sləkɗawa daa meməcey daa ba. Ta’, aa cəfɗamara Yesu, a ləvmar: ");
INSERT INTO mif_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Bay ala, mawuzlalakaya daa *kwakwas ŋga Mawiz a ləvey: “Da ndaw a məcey ta hətey bəzey daa ba na, si məlmaha a la ŋgwas-vagay a, amba a yamawa bəza hay ŋgada məlmaha maməckaya ha.” ");
INSERT INTO mif_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yaw, məlmaŋ hay maasala da wuzlah ala daha, ata ŋgaa maŋ, ŋgaa paŋ. Məlma ata mahura leŋ! a ley ŋgwas, pam! a məcey, kwa ta hətey bəzey daa ba. Da ray ŋgene, a mbəkdara ŋgwas aŋga a məlmaha laŋgar. ");
INSERT INTO mif_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Cek aha, a key letek ta mambaray a, a key letek ta məlma ata ŋga dey maakar a haa kasl fa məlma ata ŋga dey maasala ha. ");
INSERT INTO mif_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Fa dəɓa ha ata ma məcam la cəpa ata na, ŋgwas aha pam! a məcey may. ");
INSERT INTO mif_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Anda keɗe, ta pas masa ndəhay maməctakaya ma da sləkɗamawa na, ŋgwas aha a da key na, ŋgwas ŋga wa dasi ata? Maja ata cəpa ta lamara la ŋga ŋgwas ata.» ");
INSERT INTO mif_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu a mbəɗdatara a ləvtar: «Akwar faa zəɗdamara ray akwar maja ka sərmara mey ŋga Gazlavay ba, asaya, maja ka sərmara gədaŋ aŋga ba. ");
INSERT INTO mif_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ya fa ləvkwar fara fara, ta pas masləkɗawa ŋga ndəhay daa meməcey na, zel hay fa da lam ŋgusay daa saba, ŋgusay fa da njam ta zel hay daa saba may, ama ndəhay, a da njam anda maslaŋ hay ŋga Gazlavay da vaɗ. ");
INSERT INTO mif_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Akwar ma jaŋgamara mey masa Gazlavay maa guzldakwara da ray masləkɗawa ŋga ndəhay daa meməcey na, daa ba daw? Gazlavay a ləvey: ");
INSERT INTO mif_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yah, Gazlavay masa *Abəraham, *Izak, leŋ *Jakwap ma namar ray.”» Yesu aa guzley saya, a ləvey: «Gazlavay na, ara Gazlavay ŋga ndəhay ta dey, ba na, ŋga ndəhay maməctakaya ba.» ");
INSERT INTO mif_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ndəhay tabiya ma cəndamara mey a keɗe na, a rəzlam da ray meesərkedey ŋga Yesu a. ");
INSERT INTO mif_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Masa *Fariza hay ma nəkmara Yesu ta kusta *Saduse hay sem ta mey na, ta’, a kusam, a ŋgəcham a cakay Yesu. ");
INSERT INTO mif_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","*Ndaw maa sərkada kwakwas ŋga Mawiz da wuzlah ata daha, aa cəfɗa Yesu amba a jada, a ləvar: ");
INSERT INTO mif_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Bay aɗaw, *mewey ŋga Gazlavay mahura ma fənta siya hay na, wura?» ");
INSERT INTO mif_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu a mbəɗdara, a ləvar: «“Si ka wuɗa Bay Gazlavay akah, ta mevel akah cəpa, ta mesəfney akah cəpa, asaya, ta leŋgesl akah cəpa.” ");
INSERT INTO mif_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Keɗe he ara mewey ŋga Gazlavay mahura ma fənta siya hay. ");
INSERT INTO mif_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Asaya, mewey ŋga dey cew e ma səpa keɗe daha saya. Mewey a, ata letek. Mewey a, a ləvey: “Si ka wuɗa meseembew akah anda kah ma wuɗa ray akah.” ");
INSERT INTO mif_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yaw, *kwakwas ŋga Mawiz tabiya ta meesərkedey ŋga ndəhay ma təla mey ŋga Gazlavay zleezle macəmtakaya tabiya na, daa mewey hay a cew keɗe.» ");
INSERT INTO mif_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Daa masa *Fariza hay makustakaya na, Yesu aa cəfɗata may, ");
INSERT INTO mif_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","a ləvtar: «*Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay na, ka wulkam da ray a na, kwara? Aŋga, səkway ŋga wa?» A mbəɗdamara, a ləvmar: «Aŋga na, səkway ŋga Bay *Davit.» ");
INSERT INTO mif_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu a ləvtar: «Ta gədaŋ ŋga *Mesəfney ŋga Gazlavay na, Davit ta zəla Kəriste he la, “Bay Mahura.” Kaa a zəla anda keɗe saya na, kwara? Davit e, ta ləvey la: ");
INSERT INTO mif_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Bay Gazlavay a ləvar a Bay aɗaw Mahura: Sawa, njey a har-zəmay aɗaw amba ya wakwa da ray ndəhay haa ta pas masa yah ma da pata masa-gəra akah hay asi salay akah.” ");
INSERT INTO mif_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yaw, da Davit a zəla Kəriste “Bay Mahura” na, kaa wara Kəriste he ara bəzey da hwaɗ Davit saya na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kwa ndaw pal da wuzlah ata ta gwa ŋga mbəɗdara kwa mey pal daa ba. Dəga ta pas ŋgene, kwa waawa a zlurey ŋgaa cəfɗafar mey. ");
INSERT INTO mif_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu aa guzltar ŋgada ndəhay makustakaya ta ŋgada gula aŋga hay daa *Way-mekey-kwakwas ŋga Gazlavay heyey saya, ");
INSERT INTO mif_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","a ləvtar: «*Ndəhay maa sərkada kwakwas ŋga Mawiz leŋ ndəhay *Fariza hay na, mapatakaya aa slam a ŋga Mawiz ŋgaa sərkedey kwakwas aŋga. ");
INSERT INTO mif_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Si ka təɓmara mey ata, asaya, ka kamara cek masa ata maa sərkadamakwara ha. Ama cek masa ata ma kamara na, ka da kamara ba, maja ata ta ray ata na, fa kamara cek anda ata maa sərkadamakwara ha, daa ba. ");
INSERT INTO mif_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","A bamawa kwakwas hay maadakw a maadakw a masa ndəhay ma gwamara ŋga səpa ba. A təkmatar ɗay a ndəhay ŋga səpmara kwakwas hay a, ama ata na, a gəmam ŋga jənmata ndəhay ŋga səpey kwakwas hay a kwa nekəɗey ba. ");
INSERT INTO mif_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","A kamata sləra ata hay tabiya na, amba ndəhay a hətmatar aa həmdamata gway. Anda keɗe, a wuzlalam mey masa daa ɗerewel ŋga Gazlavay, a təfmara aa ambal anda laya, a ləwmara fa daŋgay, da daa ba, fa har. A təfmata mahura mahura ma fəna ŋga ndəhay siya hay. Asaya, zana hay masa ata ma pamata fa vaw na, a cam gagəmay maazəma maazəma fa mey a, ma fəna ŋga ndəhay mekele. ");
INSERT INTO mif_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","«Da ta zəlmata la aa gwagway na, a wuɗam menjey aa slam maaya ŋga ndəhay mahura hay. Asaya, daa *way-mewuzey-mey ŋga Gazlavay na, a wuɗam menjey aa slam maaya fa mey. ");
INSERT INTO mif_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","A wuɗam ndəhay a camatar har ta meney ray fa mey ŋga ndəhay makustakaya, asaya, a wuɗam ndəhay a zəlmata bay. ");
INSERT INTO mif_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Ama akwar na, ka da təɓmara amba a zəlmakwar bay ba, maja akwar tabiya na, məlmaŋ hay. Ŋgada akwar, ndaw ma səra cek na, aŋga pal. ");
INSERT INTO mif_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Asaya, ka da zəlam ndaw da bəla keɗe Papaŋ ba, maja Papakw akwar na, aŋga pal masa da vaɗ. ");
INSERT INTO mif_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ka da təɓmara amba a zəlmakwar Bay Mahura ba, maja Bay akwar Mahura na, ara *Kəriste pal taava aŋga. ");
INSERT INTO mif_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","«Ndaw mahura da wuzlah akwar na, ara ndaw ma kakwar sləra. ");
INSERT INTO mif_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kwa waawa ma pa ray aŋga ŋga ndaw mahura na, Gazlavay a da pa ŋga mecəhe. Kwa waawa ma nada ray aŋga na, Gazlavay a da pa ŋga mahura.» ");
INSERT INTO mif_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Banay a sawa la a ray akwar, akwar *ndəhay maa sərkada kwakwas ŋga Mawiz ta *Fariza hay. Akwar na, ndəhay masa ta neneh cew. Akwar fa təkmata ndəhay ŋga mbəzey a wuzlah ndəhay masa Gazlavay fa wey da ray ata. Akwar ta ray akwar, ta mbəzam daa ba, asaya, ka ta təkmata ndəhay ma wuɗam ŋga mbəzam sem.  ");
INSERT INTO mif_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Banay a sawa la a ray akwar, akwar ndəhay maa sərkada kwakwas ŋga Mawiz ta Fariza hay. Akwar na, ndəhay masa ta neneh cew. Akwar fa təɓmatara cek hay ŋga ŋgwas-vagay hay tabiya, asaya, akwar faa guzlam ga daa medərey-daŋgay amba ndəhay aa zaramakwar. Maja ŋgene Gazlavay a sərdakwar banay la ma fəna ndəhay siya. ");
INSERT INTO mif_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Banay a sawa la a ray akwar, akwar ndəhay maa sərkada kwakwas ŋga Mawiz ta Fariza hay. Akwar na, ndəhay masa ta neneh cew. Akwar fa pəkam aa wura aa wura cəpa amba ka hətam kwa ndaw pal letek ŋga səpey kwakwas akwar ni, ama da akwar ma hətam la na, ka tərdamara ndaw a, ŋga ndaw ŋga awaw magaza ma fənkwar haa dey cew. ");
INSERT INTO mif_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Banay a sawa la a ray akwar, akwar ndəhay ma wuzmatar cəveɗ ŋgada ndəhay, ama akwar na, wulaf hay. Ka ləvam: “Kwa waawa ma mbeɗey ŋga key cek ta *Way-mekey-kwakwas ŋga Gazlavay na, ara ŋga tede, ama kwa waawa ma mbeɗey ŋga key cek ta ɓərey magaza meweɗey pəlŋgeɗ pəlŋgeɗ daa Way-mekey-kwakwas a na, si cəma a ka cek aha anda aa ma ləvey.” ");
INSERT INTO mif_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Akwar na, ndəhay manjar-leŋgesl, asaya, akwar wulaf hay! Way-mekey-kwakwas ŋga Gazlavay ta ɓərey magaza na, mahura dasi ata na, wura? Way-mekey-kwakwas ŋga Gazlavay na, aŋga mahura da ray ɓərey magaza, maja ara Way a ma tərda ɓərey magaza aha ŋga cek maaya ŋgada Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Akwar fa ləvam saya: “Kwa waawa ma mbeɗey ŋga key cek ta slam-mefəkey cek ŋgada Gazlavay na, *membeɗey a, ara ŋga tede. Ama kwa waawa ma mbeɗey ŋga key cek ta cek mavəldakaya ŋgada Gazlavay masa mapakaya da ray slam aha na, si a ka cek aha anda aa ma ləvey.” ");
INSERT INTO mif_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Akwar na, wulaf hay! Cek mahura na, cek mevəley a Gazlavay daw? Da daa ba, slam-mefəkey cek a Gazlavay ma tərda cek aha maaya fa Gazlavay daw? ");
INSERT INTO mif_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Anda keɗe, kwa waawa ma mbeɗey ta slam-mefəkey cek ŋgada Gazlavay na, a key ŋgene, a mbeɗey ta slam aha leŋ ta cek da ray a tabiya. ");
INSERT INTO mif_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kwa waawa ma mbeɗey ta Way-mekey-kwakwas ŋga Gazlavay na, a key ŋgene, a mbeɗey ta Way a leŋ ta Gazlavay manjakaya daa Way a. ");
INSERT INTO mif_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kwa waawa ma mbeɗey ta slam da vaɗ na, a key ŋgene, a mbeɗey ta slam-menjey ŋga Gazlavay leŋ ta Gazlavay a manjakaya da ray a. ");
INSERT INTO mif_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Banay a sawa la a ray akwar, akwar ndəhay maa sərkada kwakwas ŋga Mawiz ta Fariza hay. Akwar na, ndəhay masa ta neneh cew. Akwar fa wunkamata cek akwar hay tabiya slam kuraw, ka vəldamara slam pal a Gazlavay, kwa cek hay mecəhe mecəhe ma cərda lar na, akwar fa wunkamara kəne may. Ama ŋga səpey mewey hay maaya na, ka sərfadamara ba. Anda meləvey mekey cek ta cəveɗ e, mesərey dey-ceceh, asaya, menjey mandaw mandaw daa cəveɗ ŋga Gazlavay. Sasəkar jak, cek hay a ŋgene na, ara cek hay maaya ŋga key. Ka da mbəkdamara ŋga key cek hay siya hay ba may. ");
INSERT INTO mif_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Akwar fa wuzmatar cəveɗ ŋgada ndəhay, ama akwar na, wulaf hay. Akwar fa jajərmara cek akwar mesey maja jajəway mecəhe da hwaɗ a, anja ŋgene, akwar fa ndam slagwama a hwaɗ daa yam maajərkaya heyey cəŋga gway. ");
INSERT INTO mif_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Banay a sawa la a ray akwar, akwar ndəhay maa sərkada kwakwas ŋga Mawiz ta Fariza hay. Akwar na, ndəhay masa ta neneh cew. Akwar fa pərmata dəɓa ŋga vəley akwar hay mesey cek ta vəley akwar hay ŋga ɗaf, anja ŋgene, ta da hwaɗ a na, vəley hay a madakalatakaya tep! tep! ta cek hay ŋga mayal akwar hay leŋ ta cek hay maaya ba masa akwar ma wuɗam kalah daa mevel akwar. ");
INSERT INTO mif_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Akwar Fariza hay na, wulaf hay! Pəram teeseɗ na, hwaɗ a ɗagay, anda keɗe, dəɓa ha na, a pərey la. ");
INSERT INTO mif_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Banay a sawa la a ray akwar, akwar ndəhay maa sərkada kwakwas ŋga Mawiz ta Fariza hay. Akwar na, ndəhay masa ta neneh cew. Akwar na, anda cəvay hay makulɓatakaya mabara ma mbam. Ama ta da hwaɗ a na, mazakaya, asaya, marəhtakaya ta tetesl hay. ");
INSERT INTO mif_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Akwar na, kəne may. Fa dey ŋga ndəhay na, akwar anda ndəhay maaya. Anja daa mevel akwar na, cek hay malamba hay ga, akwar ndəhay masa ta neneh cew. ");
INSERT INTO mif_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Banay a sawa la a ray akwar, akwar *ndəhay maa sərkada kwakwas ŋga Mawiz ta *Fariza hay. Akwar na, ndəhay masa ta neneh cew. Akwar fa ləmamata cəvay hay ŋga ndəhay ma təla mey ŋga Gazlavay ma kəɗmata vagay zleezle ŋga mbey, akwar fa kam banjay fa cəvay hay ŋga ndəhay ma ka cek ta cəveɗ e zleezle. ");
INSERT INTO mif_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Asaya, akwar fa ləvam: “Daa masa papaŋ ŋga papa ala hay, ata ta dey, da daa ŋgene ala daha na, anja ala fa da cəmam ta ata ŋga kəɗey ndəhay ma təla mey ŋga Gazlavay a vagay na, daa ba.” ");
INSERT INTO mif_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Anda keɗe, akwar, ta ray akwar, fa wuzdamara, akwar na, bəza hay ŋga ndəhay ma kəɗmata ndəhay ma təla mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yaw, maaya na, ka ndəvdamara sləra ŋga papaŋ ŋga papakw akwar hay zleezle la gway. ");
INSERT INTO mif_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Akwar zezekw hay, səkway ŋga kucesl hay! Akwar fa da ləham fa awaw magaza na, daa ba! ");
INSERT INTO mif_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Maja ŋgene, jəkam sləmay! Yah na, ya da slərkwar ndəhay ma təla mey ŋga Gazlavay, ndəhay ta leŋgesl ma səra cek, leŋ ndəhay ma daa sərkadamakwara mey ŋga Gazlavay. Da wuzlah ndəhay a na, siya hay ka da kəɗmata vagay, siya hay ka da dərmata fa hwadam mazlaŋgalakaya, siya hay ka da sləɗmata daa way akwar hay mewuzey mey ŋga Gazlavay, siya hay may ka da səpmatar wurzay aa berney hay mekele mekele amba ka sərdamata banay. ");
INSERT INTO mif_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Maja ŋgene, mambaz ŋga ndəhay ma ka cek ta cəveɗ e cəpa masa ndəhay ma kəɗmata vagay na, a hufkwar la. A kəɗam teeseɗ na, Abel. Asaya, ta kəɗam ndəhay mekele mekele la haa kasl fa Zakari, bəzey ŋga Baraki, masa akwar ma kəɗmara daa walaŋ ŋga slam-mefəkey cek ŋgada Gazlavay ta *Way ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ya fa ləvkwar fara fara, mambaz ŋga ndəhay a ŋgene, a huftar la a ray ndəhay masa wure keɗe.» ");
INSERT INTO mif_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Fa dəɓa ha, Yesu a ləvey: «Haya! Akwar ndəhay da *Jeruzelem, akwar ndəhay da Jeruzelem, Gazlavay a slərkwar ndəhay ma təla mey aŋga hay na, ka kəɗmata vagay! Asaya, a slərkwar maslaŋ aŋga hay na, kaa zakamata ta aŋgwa! Ama mandaw mandaw ya wuɗey amba ya ɓəckwar tabiya akwar anda gwagwar ma ɓəcta bəz aŋga hay asi kərpasl, ama ka wuɗam ba. ");
INSERT INTO mif_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Cəndamara, Gazlavay a da la har aŋga da ray akwar, Way-mekey-kwakwas akwar a da tərey yideŋ. ");
INSERT INTO mif_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yah fa ləvkwar dəga wure keɗe, akwar fa da hətmaya fa dey daa saba haa ta pas masa akwar ma da ləvam: “Anja Bay Gazlavay ŋga pəsar mey ŋgada ndaw masa aa ma slərdərwa ta mezəley aŋga.”» ");
INSERT INTO mif_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu a bawa daa *Way-mekey-kwakwas ŋga Gazlavay. Masa aŋga fa daw na, gula aŋga hay a ŋgəcham a cakay a amba a wuzdamara Way-mekey-kwakwas ŋga Gazlavay a, aŋga maləmkaya na, kwara. ");
INSERT INTO mif_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ta’, Yesu aa guzltar, a ləvtar: «Akwar fa hətmar way a keɗe cəpa, ba diya? Ya fa ləvkwar fara fara, way a keɗe na, a bəzlmara la, kwa aŋgwa pal fa da mbəkey da ray cəla daa ba.» ");
INSERT INTO mif_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Fa dəɓa ha, Yesu a daw aa Aŋgwa ŋga *Awliviye, cəkwam! a njey feteɗe. Gula aŋga hay ta’, a ŋgəcham a cakay a, ata taava ata, aa cəfɗamara, a ləvmar: «Wuzdandara cey, cek aha a da key na, ta vara? Yaw, ya da sərmara gweegwe cay ka vəhwa, asaya, gweegwe cay bəla a ndəvey na, fa me?» ");
INSERT INTO mif_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu a mbəɗdatara, a ləvtar: «Wam vaw fa ndəhay ma da fəcmakwar. ");
INSERT INTO mif_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ya ləvkwar anda keɗe, maja ndəhay ga a samawa la ta mezəley aɗaw, kwa waawa a da ləvey aŋga na, *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay. Anda keɗe, a fəcam ndəhay la ga. ");
INSERT INTO mif_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ka da cənam vəram hay gweegwe ta akwar leŋ mey da ray vəram hay masa dəreŋ ta akwar. Ta ŋgene he cəpa na, ka da zluram ba, maja si cek hay a ŋgene a kam la teeseɗ ɗagay. Ama ara mendəvey ŋga bəla ba araŋ. ");
INSERT INTO mif_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hwayak laŋgar a da key vəram ta hwayak laŋgar, bay laŋgar a da key həma a ray bay laŋgar. Daa hwayak hay mekele mekele, may a key la, asaya, hwiyak a wusey la. ");
INSERT INTO mif_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Cek hay a tabiya a da kam na, anda hwaɗ ma zlar ŋga car ŋgada ŋgwas ma da yey. ");
INSERT INTO mif_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Daa ŋgene, a da vəldamakwar a har ndəhay ŋga sərdamakwar banay, a kəɗmakwar la vagay. Ndəhay tabiya da bəla a da ŋgəldamakwar ba, maja yah. ");
INSERT INTO mif_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Anda keɗe, ndəhay ga a da mbəkdamara ŋga təɓey mey aɗaw. A da ŋgəlam vaw ba da wuzlah ata, asaya, siya hay a da vəldamata siya hay asi har ŋga ndəhay ŋga sərdamata banay. ");
INSERT INTO mif_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ndəhay ga a samawa la, a da mbərzlam, a ləvam ata na, ndəhay ma təla mey ŋga Gazlavay. Ndəhay a ŋgene, a da nəsam ndəhay ga. ");
INSERT INTO mif_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ndəhay a da kam cek hay malamba ma fəna ma fəna, maja ŋgene ndəhay ga fa da wuɗam vaw ta maaya daa saba. ");
INSERT INTO mif_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama ndaw ma ɓəsa banay a la haa mendəvey a na, Gazlavay a ləhda la. ");
INSERT INTO mif_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Si a wuzdamara *Mey-maaya-mawiya da ray *mewey ŋga Bay Gazlavay da ray ndəhay a ndəhay tabiya da bəla la ɗagay, amba ndəhay tabiya a cəndamara mey da ray aɗaw. Fa dəɓa ha, bəla a ndəvey dəɓa.» ");
INSERT INTO mif_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Cay na, ka da hətmar ndaw malamba ma nəsa cek, ara ndaw masa Gazlavay ma wuɗey ŋga hətar fa dey ba. Ka da hətmar ndaw aha manjakaya daa *Way-mekey-kwakwas ŋga Gazlavay. Ndaw a na, *Daniyel, *ndaw ma təla mey ŋga Gazlavay ta wuzleley mey la zleezle da ray a. (Akwar masa ma jaŋgamara mey a keɗe na, si ka pam leŋgesl fa mey a.) ");
INSERT INTO mif_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Daa ɗar hay a ŋgene na, si ndəhay daa hwayak ŋga *Jude a hwam ŋga ɓawa a aŋgwa. ");
INSERT INTO mif_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kwa ndaw masa fa məskey vaw daa ambaw na, fa da mbəzey a way ŋga lawa cek aŋga hay daa ba. ");
INSERT INTO mif_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kwa ndaw aŋga da ley na, a da vəhwa a way ŋga ley zana ba. ");
INSERT INTO mif_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Daa ɗar hay a ŋgene, banay a sawa la a ray ŋgusay ta hwaɗ ta a ray ŋgusay masa ta bəza hay da har. ");
INSERT INTO mif_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dəram daŋgay a Gazlavay amba banay a, a sawa ta piya ba, kwa ta *pas meməskey-vaw ba may, ");
INSERT INTO mif_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","maja daa ɗar hay a ŋgene na, banay a sawa la ga a ray ndəhay. Dəga mezley ŋga bəla haa wure keɗe ndaw ta sərey banay anda ŋgene daa ba araŋ. Asaya, banay fa da sawa ma fəna ŋgene daa saba. ");
INSERT INTO mif_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Da Gazlavay ta ŋgəwa siya ŋga ɗar ŋga banay a daa ba na, anja kwa ndaw pal fa da mbəkey ta dey daa ba. Ama a ŋgəwa siya ŋga ɗar a na, maja ndəhay masa aŋga ma walata ŋga ndəhay aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Da ray ŋgene, da ndaw a ləvkwar: “*Kəriste, aŋga keɗe”, da daa ba “aŋga katay” na, ka da təɓmara mey aŋga ba. ");
INSERT INTO mif_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ya ləvkwar anda keɗe na, maja ndəhay ma pamara ray ata ŋga Kəriste, asaya, ndəhay ma pamara ray ata ŋga ndəhay ma təla mey hay ŋga Gazlavay na, a samawa la. A kam maazla hay ma rəzla ndaw la ŋga wuzdərwa gədaŋ ata amba a təknam ndəhay. Da a gwamara na, a təknam kwa ndəhay masa Gazlavay ma walata sem ŋga ndəhay aŋga hay may. ");
INSERT INTO mif_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jəkam sləmay, cəndamara maaya maaya, fa cek hay a keɗe ma da kam na, ya ta pakwar leŋgesl cay.» ");
INSERT INTO mif_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Da ndaw aa guzlkwar, a ləvkwar: “*Kəriste aŋga katay da wuzlah-ley” na, ka da diyam ba. Da a ləvkwar saya “aŋga maɓakaya feɗe” na, ka da təɓmara mey ŋga ndaw a ba. ");
INSERT INTO mif_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yah, *Bəz ŋga Ndaw, ya da vəhwa na, anda var ma zəmey ma weɗey dəga da wurza haa kasl a mey-aŋgwa. ");
INSERT INTO mif_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Daa slam masa cek maməckaya daha na, kwakucah hay makustakaya feteɗe . ");
INSERT INTO mif_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Fa dəɓa ŋga banay a masa daa ɗar hay a ŋgene na, wure ŋgene pas a təɓzley la, kiya fa da weɗey daa saba, wurzla hay a kəzlamawa la da vaɗ a hwayak, cek hay cəpa da gazlavay da vaɗ, a wusam la. ");
INSERT INTO mif_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Daa ŋgene, yah, Bəz ŋga Ndaw, ya da wuzwa vaw da gazlavay da vaɗ. Anda keɗe, ndəhay da bəla cəpa a da wudam ta matəway. A da hətmaya, yah, Bəz ŋga Ndaw, ya fa sawa da ray mekwtene ta gədaŋ mahura leŋ ta meweɗey ŋga Bay Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ɗay ŋga taalam mahura a cənwa la, yah, Bəz ŋga Ndaw, ya da slərdatərwa maslaŋ hay ŋga Bay Gazlavay da vaɗ amba a diyam aa slam hay tabiya da bəla, a kusmatərwa ndəhay masa Gazlavay ma walata ŋga ndəhay aŋga hay.» ");
INSERT INTO mif_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Jəkam sləmay maaya maaya fa mey masa yah ma da wakwara ta gudav. Da masa ka hətmar gudav fa ɗeɗey, gwaslaf a guɗaf! guɗaf! na, ka sərmara kiya madaw a ley gweegwe cay. ");
INSERT INTO mif_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aŋga letek kəne, da ka hətmatar cek hay a tabiya fa kam anda yah ma ləvkwar keɗe na, ŋgene sərmara, Yah, *Bəz ŋga Ndaw, gweegwe cay ya vəhwa. ");
INSERT INTO mif_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ya fa ləvkwar fara fara, cek hay a keɗe tabiya a da kam na, ndəhay masa wure keɗe ta məcam tabiya daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Slam da vaɗ ta slam da hwayak a ndəvey la, ama mey aɗaw na, fa da ndəvey daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Fara fara, cek hay a keɗe tabiya a da kam na, ndaw ma səra kwa ɗar a, kwa ler e, daa ba. Kwa maslaŋ hay ma njam da cakay Bay Gazlavay da vaɗ a sərmara ba, kwa Yah, Bəzey aŋga, ya səra ba, ama si Papay, pal taava aŋga, ma səra ɗar a. ");
INSERT INTO mif_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ta pas masa yah, *Bəz ŋga Ndaw ma da vəhwa na, a da key anda cek ma key daa masa Nəwe aŋga da bəla. ");
INSERT INTO mif_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Daa masa Bay Gazlavay ta paslata cek hay da bəla ta yam daa ba araŋ, haa a wusey kasl fa ɗar masa Nəwe ma mbəzey aa kwambiwal na, ndəhay fa zəmam cek, fa sam cek, fa lam ŋgusay, asaya, fa vəldamata dam ata hay a way zel. ");
INSERT INTO mif_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ama daa ŋgene na, kwa ndəhay ta sərmara masa cek fa da hətfatar na, daa ba, haa yam a sawa aa zəɗdata cəpa. Yah, Bəz ŋga Ndaw ma da vəhwa na, a da key kəne. ");
INSERT INTO mif_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Daa ŋgene, da ndəhay cew fa kam sləra da ley na, ya da ŋgəla pal, ya da mbəkda laŋgar. ");
INSERT INTO mif_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Da ŋgusay cew fa kəram fa lavar pal na, ya da ŋgəla pal, ya da mbəkda laŋgar. ");
INSERT INTO mif_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Anda keɗe, wam vaw, ka da nam ba, maja ka sərmara pas ŋga Bay akwar Mahura ma da vəhwa ba. ");
INSERT INTO mif_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jəkam sləmay maaya maaya, da bay ŋga way a səra ɗar masa ndaw-mayal ma da daw a way aŋga ŋga leley ta tavaɗ na, a ney aa ɗar dasi tavaɗ a ŋgene la daw? Fa da ney daa ba səlak, fa da mbəkda ndaw-mayal ŋga sləna way aŋga daa ba. ");
INSERT INTO mif_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Maja ŋgene, akwar may, wam vaw maaya maaya, maja yah, Bəz ŋga Ndaw, ya da vəhwa na, kwa ka sərmara ɗar a ba.» ");
INSERT INTO mif_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Ndaw ma ka sləra maaya ta leŋgesl na, wura? Ndaw ma ka sləra maaya ta leŋgesl na, ara ndaw masa bay aŋga ma vəldata ma ka sləra hay cəpa asi har aŋga amba a vəltar cek mezəmey daa masa may fa catar. ");
INSERT INTO mif_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Da masa bay aŋga ha, a sawa a hətfar aŋga fa ka sləra ha na, ndaw ma ka sləra ha aa səmey la. ");
INSERT INTO mif_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ya fa ləvkwar fara fara, bay aŋga ha, a da vəldara zleley aŋga hay cəpa a har aŋga amba a nəkfar dey. ");
INSERT INTO mif_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama da ndaw ma ka sləra ha aŋga maaya ba na, a da ley mewulkey wal, a ləvey: “Bay aɗaw aha, fa da vəhwa gweegwe daa ba.” ");
INSERT INTO mif_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Anda keɗe, ndaw ma ka sləra ha, a zlar ŋga kəɗta mandala aŋga hay masa ata ma kam sləra bama. A da zəmey cek, a da sey wuzam ta ndəhay ma wam mandaw mandaw. ");
INSERT INTO mif_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Yaw, bay aŋga ha na, a da vəhwa ta pas masa ndaw ma ka sləra fa wulkey da ray a daa ba, asaya, kwa fa da səra ler e daa ba. ");
INSERT INTO mif_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bay aŋga ha, a da ɓəla da way aŋga, a da sərda banay anda ndəhay masa ta neneh cew ma da səram banay ta pas mendəvey ŋga bəla, feteɗe a da təway, asaya, a daa pəɗey sler.» ");
INSERT INTO mif_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu a ŋgatar mey a gula aŋga hay, a ləvtar: «Ya gwa ŋga wa pas masa yah ma da vəhwa ŋga wey da ray ndəhay na, ta me? Yaw, ya gwa ŋga wa ta saɓara hay kuraw daha ma diyam ta pas meley kwakwa. A diyam ŋga cawa ray ta zel ŋga dam a ta tavaɗ, ta petərla ata hay da har. ");
INSERT INTO mif_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Saɓara hay zlam da wuzlah ata na, manjar leŋgesl hay. Siya hay zlam na, ata ta leŋgesl. ");
INSERT INTO mif_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Saɓara hay manjar leŋgesl hay heyey na, a lamata petərla ata hay, ama ta lam mal a har ŋga zlərey aa petərla ata hay a saya na, daa ba gway. ");
INSERT INTO mif_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ama saɓara hay zlam masa ta leŋgesl heyey na, a lamata petərla ata hay, asaya, a zləram mal aa kwalaba hay. ");
INSERT INTO mif_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Zel ŋga dam aha ta wuswa fiyaw daa ba. Anda keɗe, saɓara hay heyey a gəram ŋga səkwmara haa ɗar a katar, a nam. ");
INSERT INTO mif_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Ta wuzlah-tavaɗ na, ɗay a cənwa ta gədaŋ, a ləvey: “Zel ŋga dam ta wuswa cay, diyam ta cadamərwa ray.” ");
INSERT INTO mif_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Da ray ŋgene, saɓara hay kaa heyey a sləkɗam daa ɗar, a ɗiymata petərla ata hay. ");
INSERT INTO mif_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Saɓara hay manjar leŋgesl hay heyey na, a ləvmatar a saɓara hay masa ta leŋgesl hay: “Ambahw, vəlmandar mal may taw. Petərla ala hay fa məcam maja mal daa saba.” ");
INSERT INTO mif_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Saɓara hay a, a mbəɗdamatara, a ləvmatar: “Kay! ya vəldamara ba, maja mal ala fa da wusndakwar aləkwa cəpa daa ba. Diyam ta həɗkamawa fa ndəhay ma həɗkada mal.” ");
INSERT INTO mif_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","«Masa ata ma diyam sem ŋga səpwa mal heyey na, zel ŋga dam heyey, a wuswa dəɓa. Saɓara hay siya zlam masa maɗiytakaya vaw heyey na, a mbəzam bama ŋga key gwagway. Ta’, a gərcamara mey-slam. ");
INSERT INTO mif_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Fa dəɓa ha, saɓara hay zlam manjar leŋgesl heyey, a wusmawa, a ləvam: “Bay ala, Bay ala, wurndara mey-mbew may taw!” ");
INSERT INTO mif_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ama zel ŋga dam heyey, a mbəɗdatara, a ləvtar: “Ya fa ləvkwar fara fara, ya sərkwar ba.”» ");
INSERT INTO mif_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yaw, Yesu aa guzltar saya, a ləvtar: «Anda keɗe, wam vaw, maja yah, *Bəz ŋga Ndaw, ma da vəhwa na, ka sərmara kwa ɗar a ba, kwa ler e ba.» ");
INSERT INTO mif_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu aa guzltar mey-meŋgey saya, a ləvtar: «Ma da vəhwa aɗaw a bəla na, aŋga letek anda ndaw masa-zleley ma daw a məlak. Masa fa da daw na, a zəlta ndəhay ma ka sləra aŋga hay, a vəldatara zleley aŋga amba a nəkfamar dey. ");
INSERT INTO mif_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A vəlar gabal temere zlam a ndaw pal, a vəlar gabal temere cew a ndaw laŋgar, a vəlar gabal temere pal a ndaw laŋgar saya. A vəldatara na, təɗe ta gədaŋ ŋga ndaw a, ŋga ndaw a. Fa dəɓa ha, ta’, a daw a məlak. ");
INSERT INTO mif_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ndaw masa ma hətey gabal temere zlam heyey na, a daw wure wure ŋgene, a kada filaw ta dala ha. A hətey gabal temere zlam mekele a dey a. ");
INSERT INTO mif_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ndaw masa ma hətey gabal temere cew heyey na, a ka kəne may. A hətey gabal temere cew a dey a. ");
INSERT INTO mif_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama ndaw masa ma hətey gabal temere pal na, a daw ta’, a zləɗey vəgeɗ, a ɓada dala ŋga bay aŋga ha a hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Menjey ga fa dəɓa ha, bay ŋga ndəhay ma ka sləra ha, a vəhwa da məlak a, ta’, aa cəfɗata da ray dala ha heyey. ");
INSERT INTO mif_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ndaw masa ma hətey gabal temere zlam heyey, a ŋgəchey a cakay a, ta gabal temere zlam mekele da dey a, ta’, a ləvar: “Bay aɗaw, kah ta vəlya gabal temere zlam la. Nəka, yah ma hətey gabal temere zlam mekele la a dey a.” ");
INSERT INTO mif_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bay aŋga, a mbəɗdara, a ləvar: “Maaya, kah ndaw ma ka sləra maaya ta cəveɗ e. Kah ma key sləra ta cəveɗ e la ta cek mecəhe. Ya da vəldatakawa cek aɗaw hay maaya ga asi har akah. Sawa, njakwa cew e, sasəmkwa.” ");
INSERT INTO mif_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Ndaw masa ma hətey gabal temere cew, a ŋgəchey a cakay a may, ta’, a ləvar: “Bay aɗaw, ka ta vəlya gabal temere cew la, nəka, ya ta hətey gabal temere cew mekele la a dey a.” ");
INSERT INTO mif_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bay aŋga ha, a ləvar: “Maaya, kah ndaw ma ka sləra maaya ta cəveɗ e. Ka ta key sləra la ta cəveɗ e ta cek mecəhe. Ya da vəldatakawa cek aɗaw hay maaya ga asi har akah. Sawa, njakwa cew e, sasəmkwa.” ");
INSERT INTO mif_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Fa dəɓa ha, ndaw masa ma hətey gabal temere pal heyey, a ŋgəchey a cakay a, ta’, a ləvar: “Bay aɗaw, ya səra, kah ndaw ma sərey dey-ceceh fa ndaw ba, ka ŋgəmey daw daa slam masa kah ma sləka ba, asaya, ka kawa cek da ley daa slam masa kah ma rəva ba. ");
INSERT INTO mif_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ya ta zlurey la ta kah, anda keɗe, ta’, ya daw ya ɓada dala akah aa vəgeɗ. Dala ha aŋga keɗe, ehe təɓa cek akah.” ");
INSERT INTO mif_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Bay aŋga ha, a mbəɗdara, a ləvar: “Kah ndaw ma ka sləra maaya ba, masa-mayaɗ! Ka səra yah ndaw ma ŋgəmey daw daa slam masa yah ma sləka ba, asaya, ya kawa cek da ley daa slam masa yah ma rəva ba, ");
INSERT INTO mif_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","anda keɗe, ka gwa ka vəlda dala aɗaw a har ndəhay amba daa mavəhwa aɗaw keɗe na, a vəhdamiwa dala ha ta yam a, ba daw?” ");
INSERT INTO mif_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","«Da ray ŋgene, ndaw masa-zleley a, a ləvtar a ndəhay ma ka sləra aŋga hay mekele: “Təɓmara gabal temere he, vəldamara a ndaw masa ma hətey gabal temere zlam a dey a heyey. ");
INSERT INTO mif_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sərmara, ndaw masa cek aŋga daha, a da vəlmar a dey a, ama ndaw masa cek aŋga kuset kəɗey na, a da təɓmara kwa masa kuset kəɗey a ŋgene. ");
INSERT INTO mif_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ndaw ma ka sləra keɗe na, aŋga ndaw masa mayaɗ ŋga tede, hazakadamara aa ambaw, aa ləvaŋ. Feteɗe, a da təway, asaya, a daa pəɗey sler.”» ");
INSERT INTO mif_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesu aa guzltar a gula aŋga hay saya a ləvtar: «Masa yah, *Bəz ŋga Ndaw, ma da vəhwa daa meweɗey aɗaw na, ya da samawa ta maslaŋ hay ŋga Gazlavay tabiya da vaɗ. Ya da njey aa slam aɗaw menjey maaya ŋga key sariya. ");
INSERT INTO mif_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Səkway hay tabiya da bəla, a da kusam fa mey aɗaw. Ya da ŋgəwta ndəhay maaya ta maaya ba hay wal wal anda ndaw-mecəkwer ma ŋgəwey təɓaŋ hay ta ɗahway. ");
INSERT INTO mif_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ya da pata ndəhay maaya ta har-zəmay, ndəhay maaya ba ta har-gula. ");
INSERT INTO mif_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Fa dəɓa ha, yah bay, ya da ləvtar a ndəhay ta har-zəmay: “Akwar ndəhay masa Papay ma pəskwar mey, slam maɗiykaya ŋgada akwar daha dəga mezley ŋga bəla, samawa, njakwa bama ta Gazlavay ŋga sərmataw, ");
INSERT INTO mif_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","maja may ta caya la, akwar ta vəlmaya cek mezəmey la, yam ta kaya la, akwar ta vəlmaya yam ŋga sey la, ya ta daw la fa akwar anda ndaw-məlak, akwar ta təɓmaya la a way akwar hay, ");
INSERT INTO mif_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","zana fa vaw aɗaw daa ba, akwar ta vəlmaya zana la. Vaw ta caya la, akwar ta samawa la ŋga nəkmaya. Yah daa fərsəne, akwar ta samawa la ŋga nəkmaya.” ");
INSERT INTO mif_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Da ray ŋgene, ndəhay maaya heyey, a da mbəɗdamiwa, a ləvmaya: “Bay mahura, ya hətmaka may fa caka, ta’, ya vəlmaka cek mezəmey na, ŋga vara? Ya hətmaka yam fa kaka, ta’, ya vəlmaka yam ŋga sey na, ŋga vara? ");
INSERT INTO mif_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ya hətmaka kah ndaw-məlak, ta’, ya təɓmaka a way ala hay na, ŋga vara? Da daa ba, ya hətmaka zana fa vaw daa ba, ta’, ya vəlmaka zana na, ŋga vara? ");
INSERT INTO mif_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Asaya, ya hətmaka vaw fa caka, da daa ba, kah daa fərsəne, ta’, ya nəkmakawa na, ŋga vara?” ");
INSERT INTO mif_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","«Yah, bay, ya da mbəɗdatara, ya ləvtar: “Ya fa ləvkwar fara fara, cek hay tabiya masa akwar ma kamara ŋgada kwa waawa, kwa ŋgada ndəhay mecəhe hay dasi ndəhay aɗaw hay keɗe, ka kamara ŋgene na, ŋgada yah may.” ");
INSERT INTO mif_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Fa dəɓa ha, ya daa guzltar a ndəhay ta har-gula, ya ləvtar: “Akwar masa Bay Gazlavay ta nəskwar sem, ŋgəcham la da cakay aɗaw. Diyam aa awaw mendəvey ba maɗiykaya ŋgada bay-malula ta maslaŋ aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Maja may ta caya la, ama akwar ta vəlmaya cek mezəmey daa ba. Yam ta kaya la, ama akwar ta vəlmaya yam ŋga sey daa ba. ");
INSERT INTO mif_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ya ta daw la fa akwar anda ndaw-məlak, ama akwar ta təɓmaya a way akwar hay daa ba. Zana fa vaw aɗaw daa ba, ama akwar ta vəlmaya zana daa ba. Vaw ta caya la, asaya, yah daa fərsəne, ama akwar ta samawa ŋga nəkmaya daa ba.” ");
INSERT INTO mif_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Da ray ŋgene, a da mbəɗdamiwa, a ləvmaya: “Bay mahura, ya hətmaka may fa caka, da daa ba, yam fa kaka na, ŋga vara? Ya hətmaka kah ndaw-məlak, da daa ba, zana fa vaw akah daa ba na, ŋga vara? Asaya, ya hətmaka vaw fa caka, da daa ba, kah daa fərsəne masa ala ta jənmaka daa ba na, ŋga vara?” ");
INSERT INTO mif_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Da ray ŋgene, ya da mbəɗdatara, ya ləvtar: “Ya fa ləvkwar fara fara, cek hay masa akwar ma gəmam ŋga kamara ŋgada kwa waawa, kwa ŋgada ndəhay mecəhe hay dasi ndəhay aɗaw hay keɗe ba na, ka gəmam ŋga kamara ba ŋgene na, ara ŋgada yah may.” ");
INSERT INTO mif_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","«Yaw, ndəhay maaya ba hay anda ŋgene na, a da səram banay ŋga sərmataw, ama ndəhay masa maaya fa Gazlavay na, a da hətam heter mendəvey ba.» ");
INSERT INTO mif_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Masa Yesu ma ndəvda meesərkedey hay a keɗe tabiya cay na, ta’, aa guzltar a gula aŋga hay, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ka sərmara, mendərey ɗar cew ŋga wusey fa gwagway ŋga *Pak, ba diya? Ta pas a ŋgene, a da kərzamaya yah, *Bəz ŋga Ndaw, a da dərmaya fa hwadam mazlaŋgalakaya.» ");
INSERT INTO mif_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ta pas a ŋgene, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta mahura hay ŋga *Jəwif hay a kusam a way Kayif, *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay cəpa. ");
INSERT INTO mif_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","A slam yawa da wuzlah ata amba a kərzamara Yesu ta mayal a ŋga kəɗey vagay. ");
INSERT INTO mif_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aa guzlam, a ləvam: «Ya gwakwa ŋga kərzakwa daa gwagway keɗe ba, maja ndəhay a da yam mey.» ");
INSERT INTO mif_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Daa ŋgene, Yesu aa da Betani da way *Simaŋw, ndaw masa aa ma mbəlda daa maasəkula. ");
INSERT INTO mif_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Masa Yesu a, fa zəmey ɗaf na, ŋgwas daha a ŋgəchey a cakay a ta kwalaba ŋga aŋgwa maavərkwakaya mezəley «*albaatəra». Kwalaba ha marəhkaya ta ɓərdey mezey maaya ma həɗkey ba. Ta’, a mbəɗdara ɓərdey a fa ray ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Masa *gula hay ŋga Yesu ma hətmar na, a cam mevel, a ləvam da wuzlah ata: «A nəsa ɓərdey a keɗe ŋga tede na, maja me? ");
INSERT INTO mif_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Anja a həɗkada na, a gwa ŋga hətey dala ga. Fa dəɓa ha a wunkatara dala ha a masa-viya hay, ba daw?» ");
INSERT INTO mif_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu a səra mewulkey ata ha, ta’, aa guzltar, a ləvtar: «Ka həɓmar ray a ŋgwas aha na, maja me? Sləra masa aŋga ma kayawa keɗe na, aŋga maaya, ");
INSERT INTO mif_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","maja ndəhay masa-viya hay na, mandaw mandaw akwar bama. Ama yah na, akwar fa da hətmaya ŋga njey mandaw mandaw ta akwar daa ba. ");
INSERT INTO mif_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ŋgwas aha, a mbəɗda ɓərdey fa vaw aɗaw na, a key ŋgene, a ɗiyawa vaw aɗaw ŋgadaa cəvay. ");
INSERT INTO mif_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ya fa ləvkwar fara fara, kwa daa wura daa wura da bəla tabiya, ndəhay ma da wuzdamara *Mey-maaya-mawiya na, a kadamara cek masa ŋgwas a ma ka keɗe la may, amba ndəhay a sərfadamara ŋgwas aha.» ");
INSERT INTO mif_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Fa dəɓa ha, ndaw pal da wuzlah *gula hay ŋga Yesu kuraw a ray a cew mezəley Juda Iskariyawt, a daw fa *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ta’, aa guzltar, a ləvtar: «Da ya ta vəldakwara Yesu a har akwar la na, ka da vəlmaya me?» Ta’, a məslmar ɓərey hay kwakwar maakar ŋga dala, a vəldamara. ");
INSERT INTO mif_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Dəga ta pas a ŋgene, Juda a daw a səpey cəveɗ amba a kərzatara Yesu, a vəldatara. ");
INSERT INTO mif_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ta ɗar ŋgeeme ŋga *gwagway ŋga peŋ manjar cek ma həsla da hwaɗ a na, *gula hay ŋga Yesu, a ŋgəcham a cakay a, a ləvmar: «Ka wuɗey ya diyam, ya ɗiymərwa slam amba ya zəmkwa ɗaf ŋga gwagway ŋga *Pak na, dama?» ");
INSERT INTO mif_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu a mbəɗdatara, a ləvtar: «Diyam aa berney ŋga *Jeruzelem fa ndaw daha. Ka ləvmar na, “Bay ala a ləvey: Ɗar aɗaw gweegwe cay a wuswa. Ya wuɗey ŋga key gwagway ŋga Pak ta gula aɗaw hay na, da way akah.”» ");
INSERT INTO mif_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gula hay ŋga Yesu heyey a kamara anda Yesu ma ləvtar. Anda keɗe, a ɗiymara cek ŋga gwagway ŋga Pak a dəɓa. ");
INSERT INTO mif_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Taa kwaɗ a ŋgene, Yesu a njam ta gula aŋga hay kuraw a ray a cew ŋga zəmey ɗaf ŋga gwagway a. ");
INSERT INTO mif_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Daa masa ata fa zəmamara ɗaf a na, Yesu aa guzltar, a ləvtar: «Ya fa ləvkwar fara fara, ndaw pal da wuzlah akwar a vəldaya la a har ndəhay ŋga kəɗmaya vagay.» ");
INSERT INTO mif_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mey a keɗe a məctar vaw kwa ara mey ba a gula aŋga hay a. Da ray ŋgene, aa cəfɗamara Yesu pal pal, a ləvam: «Bay Mahura, ara yah ma da vəldaka ba, ba diya?» ");
INSERT INTO mif_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu a mbəɗdatara, a ləvtar: «Ma da vəldaya a har ndəhay ŋga kəɗmaya vagay na, ara ndaw masa aləkwa fa zəmkwa ɗaf bama daa slam a keɗe. ");
INSERT INTO mif_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ahaw, yah, *Bəz ŋga Ndaw na, ya məcey la anda mey mawuzlalakaya daa ɗerewel ŋga Gazlavay ma ləvey. Ama banay a sawa la a ray ndaw ma da vəldaya a har ndəhay ŋga kəɗmaya vagay a. Ŋgada ndaw aha na, ŋgama ta yamərwa daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Juda, ndaw ma da vəlda Yesu a har ndəhay ŋga kəɗmara vagay heyey aa cəfɗa Yesu may, a ləvar: «Bay aɗaw, ara yah ma da vəldaka daw?» Yesu a mbəɗdara, a ləvar: «Ka fa kada ta mey akah ŋgene na, kwariya?» ");
INSERT INTO mif_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Masa ata fa zəmam ɗaf ŋga gwagway a na, Yesu leŋ! a ley peŋ. A kar suse a Gazlavay, a wunka, ta’, a vəldatara a gula aŋga hay, a ləvtar: «Ehe, təɓmara, zəmamara. Keɗe he, ara vaw aɗaw.» ");
INSERT INTO mif_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Fa dəɓa ha, leŋ! a ley vəley ta cek mesey da hwaɗ a, a kar suse a Gazlavay saya. Ta’, a vəldatara, a ləvtar: «Ehe, samara akwar cəpa. ");
INSERT INTO mif_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Keɗe he, ara mambaz aɗaw. Ta fa mambaz a, Gazlavay a jəwey mey mawiya ta ndəhay aŋga hay. Mambaz a, a da mbəɗwa maja ndəhay ga amba Gazlavay a mbəkdatara mebərey ata hay. ");
INSERT INTO mif_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ya fa ləvkwar, dəga wure keɗe ya fa da sey yam ŋga babəza ŋga wudez maɗəckaya anda keɗe daa saba səlak. Ya da sey na, si cek mawiya mekele ta pas masa aləkwa bama daa slam masa Papay fa wey da ray ndəhay da vaɗ.» ");
INSERT INTO mif_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ta’, a zlam walay ŋga gwagway daa *Pəsam hay. Fa dəɓa ha, a sləkɗam, a diyam aa Aŋgwa ŋga *Awliviye. ");
INSERT INTO mif_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu aa guzltar a gula aŋga hay, a ləvtar: «Dasi tavaɗ keɗe akwar cəpa ka da mbəkdamaya anda mawuzlalakaya daa ɗerewel ŋga Gazlavay, ma ləvey: “Ya kəɗa ndaw-mecəkwer la vagay. Təɓaŋ hay masa ma səkəram daa slam a may, aa kwacam ray la pal pal.” ");
INSERT INTO mif_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama da yah ta sləkɗawa cay daa meməcey na, ya daw la teeseɗ da ray akwar aa hwayak ŋga *Galile. Ka da hətfamaya feteɗe.» ");
INSERT INTO mif_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","*Piyer a mbəɗdara, a ləvar: «Kwa ndəhay cəpa a mbəkdamaka, ama yah na, ya fa da mbəkdaka daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu a mbəɗdara, a ləvar: «Ya fa ləvka fara fara, dasi tavaɗ keɗe, wuskwaa gwagwalak a da cey ɗay na, ka ta ləvey cay dey maakar, ka sərya ba, ka sərya ba.» ");
INSERT INTO mif_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ama Piyer a mbəɗdara, a ləvar: «Kwa da fa da kəɗmaka vagay na, ŋga kəɗmandakwar cew e, ya fa da ləvey ya sərka ba na, daa ba səlak.» Gula hay ŋga Yesu siya a ləvam kəne may. ");
INSERT INTO mif_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Fa dəɓa ha, Yesu a wusam ta gula aŋga hay aa slam daha mezəley Gecemene. Ta’, aa guzltar a gula aŋga hay, a ləvtar: «Njam feɗe, yah na, ya daw la fataɗay ŋga dərwa daŋgay a Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ta’, a ŋgəlta ata *Piyer ta bəza hay ŋga Zebede cewete. Wure ŋgene, mevel aŋga a ɗəsley, aa ləkey maja banay ma da sawa a ray a. ");
INSERT INTO mif_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Anda keɗe, aa guzltar, a ləvtar: «Mewulkey fa da kəɗya vagay. Njam feɗe, zazəkakwa, ka da nam ba.» ");
INSERT INTO mif_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ta’, a ŋgəchey nekəɗey fa mey, a ney ta hwaɗ ta hwaɗ, ray dar! a hwayak, a dərey daŋgay, a ləvey: «Papay, da a key ta key na, ŋgəchada banay ma da sawa a ray aɗaw keɗe la. Ta kəne he cəpa na, key anda kah ma wuɗey, ba na, anda yah ma wuɗey ba.» ");
INSERT INTO mif_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cay, ta’, a vəhwa fa gula aŋga hay maakar heyey, a hətfatar manatakaya daa ɗar. Aa guzlar a Piyer, a ləvar: «Haya! Ka gwamara ŋgaa zəkam ta yah kwa ler pal ba gway daw? ");
INSERT INTO mif_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Zazəkam, ka da nam ba, dəram daŋgay a Gazlavay ŋga jənkwar amba cek a batakwar ŋga key mebərey ba. Mevel akwar na, a wuɗey ŋga key cek maaya, ama vaw akwar na, aŋga ta bəle.» ");
INSERT INTO mif_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu a ŋgəchey ŋga dey cew saya, ta’, a dərey daŋgay, a ləvey: «Papay, da ka wuɗey ŋga ŋgəchada banay a keɗe dəreŋ ta yah ba, si a sawa a ray aɗaw cəma na, ka anda kah ma wuɗey.» ");
INSERT INTO mif_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Fa dəɓa ha, a vəhwa fa gula aŋga hay maakar heyey saya, a hətfatar manatakaya cəŋga maja ɗar fa latar mey kalah. ");
INSERT INTO mif_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Anda keɗe, Yesu ta’, a mbəkdata, a ŋgəchey saya, a dərey daŋgay ŋga dey maakar, aa guzley mey letek anda aa ma dərey daŋgay ŋga dey cew heyey. ");
INSERT INTO mif_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Fa dəɓa ha ta’, a vəhwa fa gula aŋga hay heyey saya, a ləvtar: «Haa wure keɗe, akwar fa nam, fa məskam vaw cəŋga daw? Ehe ɗar a ta wuswa cay amba a vəldamaya, yah, *Bəz ŋga Ndaw, a har ndəhay ta mebərey. ");
INSERT INTO mif_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nəkmara ndaw ma da vəldaya a har ndəhay ŋga kəɗey vagay fa sawa katay. Lacam, nakwa ta cadakwa ray.» ");
INSERT INTO mif_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Masa Yesu ta ndəvda meeguzley daa ba araŋ na, Juda, ndaw pal dasi gula aŋga hay kuraw a ray a cew heyey, a wuswa. Juda ha a samawa na, ta ndəhay ga ta dəlaw hay da cakay, ta zlanday hay da har. Ma slərdamatərwa ndəhay a na, ara bay-ray hay ŋga ndəhay ma ka kwakwas ta mahura hay ŋga Jəwif hay. ");
INSERT INTO mif_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Juda, ndaw masa ma da vəlda Yesu a har ndəhay, ta wuswa fa Yesu daa ba araŋ na, aa guzltar a ndəhay a, a ləvtar: «Ndaw masa yah ma da car har anda mandala aɗaw fara fara na, ara aŋga, kərzamara.» ");
INSERT INTO mif_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Masa Juda ma wusey la gweegwe ta Yesu na, wure wure ŋgene, a ŋgəchey a cakay a, a ləvar: «Bay aɗaw, zay daw?» Ta’, a car har anda aa ma ləvey heyey. ");
INSERT INTO mif_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu a mbəɗdara, a ləvar: «Jam aɗaw, ka sləra masa kah ma wuɗey ŋga ka.» Anda keɗe, ndəhay ma samawa ta ata Juda heyey a ŋgəcham fa Yesu a, ta’, a kərzamara. ");
INSERT INTO mif_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ndaw pal da wuzlah gula aŋga hay masa da cakay a, a məɗərwa dəlaw aŋga, a ŋgəma, cərah! a cərha sləmay ŋga madərlam ŋga ndaw mahura da ray ndəhay ma ka kwakwas. ");
INSERT INTO mif_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Maja ŋgene, Yesu aa guzlar, a ləvar: «Mada dəlaw akah aa way a maja ndəhay ma kəɗam vaw ta dəlaw na, ara dəlaw a ma da kəɗta vagay. ");
INSERT INTO mif_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ka səra, da ya wuɗey na, ya gwa ŋgaa cəfɗa Papay ŋga slərya maslaŋ aŋga hay ga a fəna gabal kuraw a ray a cew ŋga jənya, ba daw? ");
INSERT INTO mif_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ama da ya ka kəne na, mey ŋga Gazlavay mawuzlalakaya a da key fara fara na, kwara dəɓa wura? Maja mey a mawuzlalakaya, a ləvey si cek aha a key kəne.» ");
INSERT INTO mif_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Fa dəɓa ha, Yesu aa guzltar a ndəhay makustakaya feteɗe, a ləvtar: «Ka samawa ŋga kərzamaya ta dəlaw, ta zlanday faa har faa har anda yah ndaw-mayal na, maja me? Mandaw mandaw yah manjakaya daa *Way-mekey-kwakwas ŋga Gazlavay, ya faa sərkadata ndəhay, ama ka ta kərzamaya daa ba. ");
INSERT INTO mif_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ama daa mey ŋga Gazlavay mawuzlalakaya na, ndəhay ma təla mey ŋga Gazlavay taa guzlam la da ray cek ma da key da ray aɗaw. Ara maja ŋgene si cek aha a key cəpa.» Fa dəɓa ha, gula aŋga hay cəpa a zluram, a mbəkdamara Yesu, a hwam. ");
INSERT INTO mif_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ndəhay ma kərzamara Yesu heyey, ta’, a handamara a way Kayif, *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay. *Ndəhay maa sərkada kwakwas ŋga Mawiz ta mahura hay ŋga *Jəwif hay makustakaya feteɗe. ");
INSERT INTO mif_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","*Piyer na, fa səpa Yesu ta meedəreŋ e. A daw haa a mbəzey a palah-way ŋga ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay heyey. Ta’, a njam ta ndəhay ma jəɗa way a, amba a nəka cek masa ata ma da kamar a Yesu. ");
INSERT INTO mif_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","*Bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta ndəhay mahura hay mekele masa ma sla yawa ŋga Jəwif hay tabiya, a səpam dabaray ŋga mbərzlafamar a ray Yesu amba a kəɗmara vagay. ");
INSERT INTO mif_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kwa ndəhay ga ta mbərzlafamar la a ray Yesu, ama ta ŋgene he cəpa, ta hətam mey təɗe ŋga kəɗmara vagay daa ba. Fa dəɓa ha na, ndəhay cew daha a samawa fa mey ata, a mbərzlafamar a ray a, a ləvam: ");
INSERT INTO mif_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Ndaw keɗe a ləvey: “Ya gwa ŋga bəzla *Way-mekey-kwakwas ŋga Gazlavay, ɗar maakar na, ya ləma la aa slam a.”» ");
INSERT INTO mif_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","*Ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay a sləkɗey, aa guzlar a Yesu, a ləvar: «Ka mbəɗdatara a ndəhay maa guzlam da ray akah kaa ba gway daw?» ");
INSERT INTO mif_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ama Yesu manjakaya teete. Ta’, ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay heyey a ləvar saya: «Ya faa cəfɗaka ta mezəley ŋga Gazlavay masa aa ta dey, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay heyey na, ara kah daw? Wuzdiwa! Kah na, Bəzey ŋga Gazlavay daw? Mbeɗey amba ka kadiwa fara fara.» ");
INSERT INTO mif_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu a mbəɗdara, a ləvar: «Ka fa kada ta mey akah ŋgene na, kwariya? Ama ya fa ləvkwar, dəga wure keɗe, ka da hətmaya yah, *Bəz ŋga Ndaw, manjakaya ta har-zəmay ŋga Bay Gazlavay Mawaca-waca. Asaya, ka hətmaya la ya fa sawa da ray mekwtene da vaɗ.» ");
INSERT INTO mif_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Maja ŋgene, ndaw mahura ha ŋgar! ŋgar! a ŋgərta zana aŋga hay, aa guzley, a ləvey: «’As! ’As! Ta pa ray aŋga sem ŋga Gazlavay, akwar ta cəndamara la, ba diya? Wure keɗe, kwa ya səpkwa ndaw ŋgaa guzlndakwar da ray a saba. ");
INSERT INTO mif_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kaa wure keɗe, ka wulkam kwara?» Ndəhay da cakay a, a mbəɗdamara, a ləvmar: «Aŋga ta key mebərey sem, si mekəɗey aŋga vagay.» ");
INSERT INTO mif_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ndəhay siya a cərmar meesleɓ aa dey, a dəvmar mekəɗey, siya hay may, a vəlmar matapa-har , ");
INSERT INTO mif_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","a ləvmar: «Da kah *Kəriste na, səra ma kəɗka keɗe na, wa? Wuzdandara cey!» ");
INSERT INTO mif_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Daa ŋgene, *Piyer manjakaya da palah-way ŋga ndaw mahura ma ka kwakwas ŋga Gazlavay heyey. Dam ma ka sləra feteɗe daha, a ŋgəchawa a cakay a, a ləvar: «Kah na, gula ŋga Yesu, ndaw *Galile may, ba diya?» ");
INSERT INTO mif_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ama Piyer a cada mey fa mey ŋga ndəhay tabiya, a ləvey: «Kay! Ya səra mey masa kah ma wuɗey ŋgaa guzley ba!» ");
INSERT INTO mif_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Fa dəɓa ha, ta’, a daw fa mey-mbew ŋga way a. Dam ma ka sləra mekele daha saya, a hətar Piyer, ta’, aa guzltar a ndəhay feteɗe, a ləvtar: «Ndaw keɗe ara ndaw ŋga Yesu, ndaw *Nezeret.» ");
INSERT INTO mif_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyer a cada mey saya, a ləvey: «Ya fa mbeɗey, fara fara, ya səra ndaw a ba.» ");
INSERT INTO mif_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Fa dəɓa ha nekəɗey saya, ndəhay masa feteɗe a ŋgəcham a cakay Piyer, a ləvmar: «Fara fara kah na, kah ndaw da wuzlah ndəhay aŋga hay maja meeguzley akah kaa na, anda ndaw daa hwayak aŋga.» ");
INSERT INTO mif_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Da ray ŋgene, Piyer ta’, a ləvtar: «Ya fa mbeɗey, fara fara ya səra ndaw a ba. Da ya mbərzley na, Gazlavay ŋga mbəɗya ray!» Wure wure ŋgene, gwagwalak ta’, a cey ɗay. ");
INSERT INTO mif_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Piyer a sərfada mey masa Yesu maa guzlar zleezle heyey dəɓa. Mey a, a ləvey: «Wuskwaa gwagwalak a da cey ɗay na, ka ta ləvey cay dey maakar ka sərya ba, ka sərya ba.» Piyer ta’, a bawa aa ambaw, a təway ga, a zəley marava. ");
INSERT INTO mif_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pərek pərek, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay tabiya, leŋ mahura hay ŋga *Jəwif hay a slam yawa daa slam a ŋga kəɗey Yesu vagay. ");
INSERT INTO mif_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","A jəwmara, a handamara fa Pilat, ndaw Rawma ma wa hwayak ata. ");
INSERT INTO mif_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Juda, ndaw ma vəlda Yesu asi har ŋga masa-gəra aŋga hay heyey, a cənda fa da kəɗmara Yesu vagay na, a zəley marava. Da ray ŋgene, a handatara ɓərey hay kwakwar maakar ŋga dala heyey a *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta mahura hay ŋga *Jəwif hay. ");
INSERT INTO mif_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A ləvtar: «Ya ta key mebərey la maja yah ma vəlda ndaw masa ta zay da mey ŋga kəɗey vagay.» Ama ndəhay a, a mbəɗdamara, a ləvmar: «Ŋgene na, ara mey akah ba na! Ma hətfandar me?» ");
INSERT INTO mif_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Da ray ŋgene, aa kwacada dala heyey aa *Way-mekey-kwakwas ŋga Gazlavay. Ta’, a daw a ləwa ray aŋga, pam! a məcey. ");
INSERT INTO mif_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","*Bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay heyey, a gəɗmamara dala ha. Aa guzlam, a ləvam: «Kwakwas aləkwa, a vəlndakwar cəveɗ amba dala keɗe, a cəmey ta zleley mavəldakaya ŋga key sləra daa Way-mekey-kwakwas ŋga Gazlavay ba, maja ara dala ŋga mekəɗey ndaw vagay.» ");
INSERT INTO mif_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","A slam yawa da wuzlah ata da ray dala ha. Ta’, a həɗkam ley ŋga ndaw meləmey maŋgayak daha ta dala ha. A tərdamara ley a ŋga cəvay ŋga məlak hay ma məcam feteɗe. ");
INSERT INTO mif_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ara maja ata ma həɗkamara ley a ŋgene ta dala ŋga ray ŋga ndaw na, haa wure keɗe, ndəhay fa zəlmara ley a: «ley ŋga mambaz.» ");
INSERT INTO mif_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Cek aha, ta key la anda Jeremey, *ndaw ma təla mey ŋga Gazlavay maa guzley zleezle, a ləvey: «A lam ɓərey hay kwakwar maakar ŋga dala masa ndəhay da wuzlah ndəhay *Israyel hay ma pamara təɗe fa ray ŋga ndaw. ");
INSERT INTO mif_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","A vəldamara dala ha ŋga həɗkey ley ŋga ndaw meləmey maŋgayak anda Bay Gazlavay ma ləvya.» ");
INSERT INTO mif_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","A lacadamara Yesu fa mey ŋga Bay Pilat. Bay a, aa cəfɗa, a ləvar: «Kah na, bay ŋga *Jəwif hay fara daw?» Yesu a mbəɗdara, a ləvar: «Anda kah ma ləvey.» ");
INSERT INTO mif_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Daa masa *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay leŋ mahura hay ŋga Jəwif hay heyey faa dəɗfamar mey na, kwa Yesu ta mbəɗdatara daa ba. ");
INSERT INTO mif_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Da ray ŋgene, Pilat aa guzlar, a ləvar: «Ka fa cənda mey hay maaya ba cəpa masa ata maa guzldamara da ray akah keɗe, ba diya?» ");
INSERT INTO mif_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kwa Yesu a mbəɗdara ba səlak. Anda keɗe, Bay Pilat a rəzley ga maja. ");
INSERT INTO mif_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Fa mevey a, fa mevey a, ta gwagway ŋga *Pak na, bay daa hwayak a, fa pəskey ndaw pal daa fərsəne. A pəskey na, ndaw masa ndəhay makustakaya ma wuɗam. ");
INSERT INTO mif_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Daa ŋgene, ndaw daa fərsəne daha, ndəhay tabiya a sərmara ara ndaw maaya ba. Mezəley ŋga ndaw a na, Yesu Barabas. ");
INSERT INTO mif_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilat aa cəfɗata ndəhay makustakaya, a ləvtar: «Ka wuɗam ya pəskakwar na, Yesu Barabas daw, da daa ba, Yesu, ndaw masa ata ma zəlmara *Kəriste heyey daw?» ");
INSERT INTO mif_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilat a səra a handamərwa Yesu fa mey aŋga na, maja səleŋ fa katar da ray Yesu a. ");
INSERT INTO mif_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Daa masa Bay Pilat manjakaya daa slam mekey sariya na, ŋgwas aŋga, a slərwa fa aŋga, a ləvar: «Ka da kar cek a ndaw ŋgene ba, maja ara ndaw masa ta zay da mey. Ya səra maja dasi tavaɗ keɗe, mesəfney ta kaya la ta ndaw aha. Mesəfney a, ta laya mey la.» ");
INSERT INTO mif_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","*Bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay leŋ mahura hay ŋga Jəwif hay heyey, a həldamata ndəhay makustakaya heyey ŋgaa cəfɗamara Bay Pilat amba a pəskatara Barabas, ama Yesu na, a kəɗmara vagay. ");
INSERT INTO mif_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bay Pilat aa cəfɗata saya, a ləvtar: «Dasi ndəhay cew keɗe na, ka wuɗam ya pəskakwar na, wa?» Ndəhay makustakaya ha, a mbəɗdamara, a ləvmar: «Barabas! Barabas!» ");
INSERT INTO mif_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat aa cəfɗata saya, a ləvtar: «Kaa Yesu ndaw ma zəlmara Kəriste na, ya da kada na, kwara?» Ndəhay tabiya a mbəɗdamara, a ləvmar: «Dəra fa hwadam mazlaŋgalakaya!» ");
INSERT INTO mif_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat aa cəfɗata, a ləvtar: «Cek maaya ba masa aŋga ma key na, wura?» Ama a wudam ta gədaŋ ta gədaŋ saya, a ləvam: «Dəra fa hwadam mazlaŋgalakaya!» ");
INSERT INTO mif_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Masa Pilat ma nəka kwa a gwa ŋga key meeme da ray mey a ba, asaya, masa aŋga ma nəka ndəhay fa kam baazlam ta gədaŋ, ta gədaŋ na, ta’, a kawa yam, a pəra har aŋga fa mey ŋga ndəhay makustakaya, a ləvtar: «Da akwar ta kəɗmara ndaw keɗe la vagay na, mey aɗaw da hwaɗ a daa ba. Ara mey akwar!» ");
INSERT INTO mif_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ndəhay makustakaya tabiya a mbəɗdamara, a ləvmar: «Anja ndaw a ŋga məcey. Mey a ŋga sawa a ray ala ta bəz ala hay tabiya!» ");
INSERT INTO mif_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Anda keɗe, ta’, Pilat a pəskatara Barabas daa fərsəne. Ama Yesu na, Pilat a ləvtar a sewje hay ŋga sləɗmara ta laway, ta’, a vəldatara amba a dərmara fa hwadam mazlaŋgalakaya. ");
INSERT INTO mif_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Fa dəɓa ha, sewje hay ŋga Bay Pilat, a handamara Yesu a palah-way ŋga Bay aha. Ta’, a zəlmatərwa sewje hay siya feteɗe tabiya a cakay a. ");
INSERT INTO mif_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","A cəkwmata zana aŋga hay fa vaw, ta’, a kəzlmar zana ŋga bay hay magaza. ");
INSERT INTO mif_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ta’, a cam hatak, a paɗamar ray ta aŋga anda gursaw ŋga bay. Fa dəɓa ha, a vəlmar daŋgwar ŋga bay hay a har-zəmay. A ragadam fa mey aŋga, aa saŋgəram a ray a, a ləvam: «Zay daw, bay ŋga *Jəwif hay?» ");
INSERT INTO mif_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Fa dəɓa ha, a təfmar meesleɓ fa vaw, ta’, a təɓmara daŋgwar heyey, a kəɗmara aa ray ta aŋga. ");
INSERT INTO mif_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Masa ata maa saŋgəram cay a ray a na, a cəkwmara zana magaza heyey fa vaw, a kəzlmar zana aŋga hay. Ta’, a badamara daa berney a, a handamara ŋga dərey fa hwadam. ");
INSERT INTO mif_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Masa sewje hay a, fa handamara Yesu na, a cam ray ta ndaw daa berney ŋga Siren daha, mezəley *Simaŋw. A təkmar ɗay a Simaŋw heyey ŋga la hwadam mazlaŋgalakaya ŋga Yesu a. ");
INSERT INTO mif_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","A wusam aa slam mezəley Gwalgwata, anda meləvey, «slam anda tetesl ŋga ray ŋga ndaw.» ");
INSERT INTO mif_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Feteɗe, a vəlmar wuzam majahaɗakaya ta slalak meeɗəwek e. Yesu aa cəka, ama a gəmey ŋga sa ba. ");
INSERT INTO mif_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ta’, a dərmara fa hwadam mazlaŋgalakaya heyey. Fa dəɓa ha, a kəɗam caca ŋga wunkey zana aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ta’, a njam feteɗe ŋga jəɗmara. ");
INSERT INTO mif_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A wuzlalam mey fa hwadam, a sləpmara ta da ray Yesu fa hwadam mazlaŋgalakaya. Ara mey masa ata ma kəɗmara vagay maja. Mey a, a ləvey: «Ndaw keɗe na, ara Yesu, bay ŋga *Jəwif hay.» ");
INSERT INTO mif_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Daa slam masa ata ma dərmara Yesu a na, ta dəram mayal hay cew la a cakay a, pal ta har-zəmay, laŋgar ta har-gula. ");
INSERT INTO mif_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ndəhay ma diyam taa slam a ŋgene, aa saŋgəram a ray a, a wusam ray, a cəɗmara, ");
INSERT INTO mif_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","a ləvmar: «Kah na, ndaw ma wuɗey ŋga bəzla *Way-mekey-kwakwas ŋga Gazlavay amba ka ləma mekele daa ɗar maakar heyey, ba diya? Da kah Bəzey ŋga Gazlavay na, bərŋgawa fa hwadam a ŋgene a hwayak, ləhda ray akah, dəɓa taw!» ");
INSERT INTO mif_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Asaya, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta *ndəhay maa sərkada kwakwas ŋga Mawiz leŋ mahura hay ŋga Jəwif hay aa saŋgərfamar, a ləvam: ");
INSERT INTO mif_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«A ləhdata ndəhay siya hay na, kaa ray aŋga na, a gwa ŋga ləhda, ba daw? Da aŋga Bay ŋga *Israyel hay na, anja ŋga bərŋgawa fa hwadam a wure keɗe dəɓa taw! Da ta bərŋgawa sem na, ŋgene, ya təɓkwa mey aŋga. ");
INSERT INTO mif_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A pa Gazlavay ŋga ndaw aŋga fara fara, asaya, taa guzley la, a ləvey: “Yah na, Bəzey ŋga Gazlavay.” Yaw, da Gazlavay fa wuɗa na, ŋga ləhda wure keɗe dəɓa taw!» ");
INSERT INTO mif_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mayal hay cew masa madərtakaya da cakay a heyey na, a cəɗmara kəne may. ");
INSERT INTO mif_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ta wuzlah-pas, ləvaŋ a key daa hwayak cəpa. Ləvaŋ a, a njey haa ɓərey maakar ŋga pas ŋgaa kwaɗ. ");
INSERT INTO mif_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ta ɓərey maakar a na, Yesu a wudey ta gədaŋ, a ləvey ta mey ata: «Eli, Eli, lema sabaktani?» Anda meləvey: «Gazlavay aɗaw, Gazlavay aɗaw, ka mbəkdaya na, maja me?» ");
INSERT INTO mif_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ndəhay siya feteɗe, a cəndamara mewudey ŋga Yesu a na, a ləvam: «Nəka, aŋga fa zəla *Eli, *ndaw ma təla mey ŋga Gazlavay zleezle!» ");
INSERT INTO mif_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ndaw pal da wuzlah ata, ta’, a hway ŋga jəhwɓey cek anda gagəmay aa yam ŋga babəza ŋga wudez meekwerek e, ta’, a pa fa mey ŋga zlanday. A təldara a Yesu a amba a sasəɓa. ");
INSERT INTO mif_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ama ndəhay mekele a ləvam: «Səkwakwa, amba ya nəkakwa da wara cay Eli a, a sawa ŋga ləhda kwa.» ");
INSERT INTO mif_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu a wudey ta gədaŋ saya, pam! a məcey. ");
INSERT INTO mif_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Daa *Way ŋga Gazlavay na, zana ma gərca *Slam masa Gazlavay aa da hwaɗ a daha. Masa Yesu ma məcey la na, zana ha, a ŋgərey cew dəga da vaɗ kasl a hwayak. Hwiyak a wusey, bəler hay a bəzlam, ");
INSERT INTO mif_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","cəvay hay a wuram, ndəhay ŋga Gazlavay maməctakaya ga, a sləkɗamawa daa meməcey. ");
INSERT INTO mif_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","A bamawa daa cəvay. Fa dəɓa ŋga masləkɗawa ŋga Yesu na, ndəhay a, a diyam aa berney ŋga *Jeruzelem, berney ŋga Gazlavay. Feteɗe, ndəhay ga a hətmatar. ");
INSERT INTO mif_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mahura ŋga sewje hay ŋga Rawma hay ta sewje aŋga hay ma jəɗmara Yesu heyey, a hətmar hwiyak ma wusey ta cek hay mekele ma kam heyey na, a zluram ga, a ləvam: «Fara fara ndaw keɗe na, ara Bəzey ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ŋgusay ga feteɗe daha, ata fa nəkam dey da dəreŋ, da dəreŋ. Ŋgusay a ta səpmar wurzay ŋga Yesu la dəga da *Galile fa jənmara. ");
INSERT INTO mif_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Da wuzlah ŋgusay a na, *Mari da Magdala, Mari mamaŋ ŋga ata *Jak ta *Jawzef, leŋ mamaŋ ŋga bəza hay ŋga Zebede. ");
INSERT INTO mif_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ta pas ŋgaa kwaɗ a ŋgene, ndaw masa-zleley da slala Arimate daha, mezəley *Jawzef, aŋga may, ara *ndaw ma təɓa mey ŋga Yesu. A wusey a *Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ta’, a daw a hətfar Bay Pilat, aa cəfɗa vagay ŋga Yesu. Da ray ŋgene, Bay Pilat a, a pəskatar mey a sewje aŋga hay ŋga vəldamara vagay a, a Jawzef e. ");
INSERT INTO mif_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","A la vagay a, a zləŋga ta zana mawiya mezləŋgey vagay. ");
INSERT INTO mif_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A handa vagay a, aa cəvay mawiya masa aŋga maa vərkwa daa aŋgwa daa ɗar hay a ŋgene. Fa dəɓa ha, a gədbalawa beeler mahura gazl! fa mey ŋga cəvay a, ta’, a daw. ");
INSERT INTO mif_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ata *Mari da Magdala ta Mari laŋgar daha, manjatakaya feteɗe, dey pəla! a mey cəvay a. ");
INSERT INTO mif_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pepərek e, anda meləvey ta *pas meməskey-vaw, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta *Fariza hay a kusam, a diyam a way Bay Pilat, ");
INSERT INTO mif_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","a ləvmar: «Bay Mahura, ala fa sərfadamara daa masa ndaw membərzley keɗe aŋga ta dey na, taa guzley la, a ləvey: “Fa dəɓa ŋga ɗar maakar na, ya sləkɗawa la daa meməcey.” ");
INSERT INTO mif_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Anda keɗe, pəskatar mey a sewje akah hay amba a jəɗmara cəvay a haa ɗar maakar, daa ba na, gula aŋga hay a da samawa ŋga lalamara vagay a. Fa dəɓa ha, a da mbərzlam, a da ləvam: “Yesu ta sləkɗawa sem daa meməcey.” Membərzley ata ŋgene na, a da fəna membərzley ŋga ndaw aha masa ŋgeeme heyey.» ");
INSERT INTO mif_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat ta’, a mbəɗdatara a ndəhay a, a ləvtar: «Ehe, ŋgəlmata sewje hay keɗe, diyam jəɗmara cəvay a maaya maaya anda akwar ma wuɗam.» ");
INSERT INTO mif_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ta’, a diyam ŋga jəɗmara cəvay a maaya maaya. Anda keɗe, a slərɓamara mey ŋga cəvay a maaya maaya. Fa dəɓa ha, a pam sewje hay ŋga jəɗmara. ");
INSERT INTO mif_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Fa dəɓa ŋga *pas meməskey-vaw, ta pas luma ŋga Gudal, *Mari da Magdala ta Mari laŋgar daha a diyam ta slam bəŋ-beŋ ŋga nəkmərwa cəvay ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wure wure ŋgene hwiyak a wusey gəɗ-geɗ ta gədaŋ. Daa ŋgene maslaŋ ŋga Gazlavay da vaɗ a pawa salay, a gədbala beeler mahura da mey cəvay heyey, a njey a ray a. ");
INSERT INTO mif_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Maslaŋ a, dey aŋga a weɗey anda var ma zəmey, zana fa vaw aŋga a weɗey mabara ndəɗ-ndeɗ anda gagəmay. ");
INSERT INTO mif_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sewje hay ma jəɗa cəvay heyey ma hətmar cek aha na, a zluram ga, aa wasam pər-par! a təɗam a hwayak, ata anda ndəhay maməctakaya. ");
INSERT INTO mif_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ta’, maslaŋ ŋga Gazlavay heyey aa guzltar a ŋgusay a, a ləvtar: «Akwar na, ka da zluram ba, ya səra ka səpam na, Yesu, ndaw masa ata ma dərmara fa hwadam mazlaŋgalakaya heyey. ");
INSERT INTO mif_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aŋga feɗe daa saba, ta sləkɗawa sem daa meməcey anda aŋga maa guzley heyey. Samawa nəkmara slam masa ata ma pamara vagay aŋga ha a hwaɗ a tiya! ");
INSERT INTO mif_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Cay na, diyam fiyaw fiyaw, ləvmatar a gula aŋga hay: “Yesu ta sləkɗawa sem daa meməcey. Aŋga sem teeseɗ fa mey akwar ŋgada *Galile, ka da hətfamar feteɗe.” Mey aɗaw ŋgada akwar na, ara keɗe.» ");
INSERT INTO mif_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ŋgusay a, a mbəkdamərwa cəvay a, a hwam fiyaw fiyaw ŋga kadamatara mey a, a gula aŋga hay heyey. Daa ŋgene mandərzay fa katar, ama faa səmam ga. ");
INSERT INTO mif_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ta’, Yesu heyey a daw a cadata ray, a catar har. Masa ŋgusay a ma hətmar Yesu la na, a ŋgəcham a cakay a, a ragadamar, a kərzamara fa salay. ");
INSERT INTO mif_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ta’, Yesu aa guzltar, a ləvtar: «Ka zluram ba, diyam ta wuzdamatara a məlma aɗaw hay siya na, ŋga diyam a Galile. A da hətmaya feteɗe.» ");
INSERT INTO mif_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Daa masa ŋgusay heyey ata daa cəveɗ araŋ na, sewje hay siya da wuzlah sewje hay ma jəɗa cəvay heyey, a vəham aa berney. A kadamatara cek ma key cəpa da mey cəvay heyey ŋgada *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","*Bay-ray hay ŋga ndəhay ma ka kwakwas kaa heyey, ta’, a kusam ta mahura hay ŋga *Jəwif hay, a slam yawa da wuzlah ata. Ta’, a vəlmatar dala ga ŋgada sewje hay a, ");
INSERT INTO mif_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","a kətmata, a ləvmatar: «Diyam, wuzdamara a ndəhay, ləvmatar: “Gula hay ŋga Yesu a, ta samawa sem ta tavaɗ, ta lalamara vagay a sem daa masa ala manatakaya daa ɗar.” ");
INSERT INTO mif_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Da bay ŋga hwayak ta cənda la na, ya səpam cəveɗ la ŋga wuzdamara mey a maaya maaya amba a təɓa. Anda keɗe, kwa mey fa da hətfakwar daa ba.» ");
INSERT INTO mif_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ta’, sewje hay heyey dəɓa, a təɓmara dala ha, a diyam a kamara anda ata ma kətmata heyey. Ara maja ŋgene haa wure keɗe fa kadamara mey a da wuzlah Jəwif hay cəŋga. ");
INSERT INTO mif_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Gula hay ŋga Yesu kuraw a ray a letek a diyam a *Galile, a təpam aa ray ŋga aŋgwa masa Yesu ma ləvtar ŋga diyam a hwaɗ a heyey. ");
INSERT INTO mif_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Daa masa gula hay a ma hətmar Yesu la na, ta’, a ragadamar. Ama siya hay da wuzlah ata na, ta sərmara ara Yesu fara fara na, daa ba. ");
INSERT INTO mif_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu ta’, a ŋgəchey a cakay ata, a ləvtar: «Gazlavay ta vəldiwa gədaŋ sem ŋga wa slam da vaɗ ta slam da hwayak cəpa. ");
INSERT INTO mif_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Maja ŋgene, diyam fa səkway hay da bəla cəpa, tərdamata ŋga ndəhay aɗaw hay. Kamatar *baptem ta mezəley ŋga Papay, ta mezəley aɗaw, yah Bəzey aŋga, leŋ ta mezəley ŋga Mesəfney aŋga. ");
INSERT INTO mif_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Asaya, sasərkadamata amba a təɓmara mey hay tabiya masa yah maa sərkadakwara. Yaw, sərmara, yah na, yah ta akwar mandaw mandaw haa mendəvey ŋga bəla.» ");
INSERT INTO mif_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Keɗe ara mezley ŋga *Mey-maaya-mawiya da ray *Yesu *Kəriste, Bəzey ŋga *Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","*Mey-maaya-mawiya ha a zley anda *Izay, *ndaw ma təla mey ŋga Gazlavay zleezle, ma wuzlala daa ɗerewel aŋga, a ləvey: «Gazlavay a ləvar a Bəzey aŋga, “Ehe, ya fa slərey maslaŋ-cəveɗ aɗaw fa mey akah, ŋga ɗiya cəveɗ akah. ");
INSERT INTO mif_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ndaw fa wudey da wuzlah-ley, a ləvey: Ɗiymar cəveɗ ŋgada Bay Mahura, ɗiymara cəveɗ e maaya maaya dər e.”» ");
INSERT INTO mif_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ndaw ma təla mey a na, ara *Jaŋ-Baptis. Anda keɗe, ta daw la a wuzlah-ley. Feteɗe ta katar *baptem la a ndəhay, ta wuzey mey ŋga Gazlavay la, a ləvey: «Mbəɗdamara menjey akwar, səpmara Gazlavay ta mevel pal, hətam baptem, amba Gazlavay a mbəkdakwara mebərey akwar.» ");
INSERT INTO mif_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ndəhay ga daa berney ŋga *Jeruzelem leŋ da slala hay mekele mekele masa daa hwayak ŋga *Jude a diyam fa *Jaŋ a, a wuzdamara mebərey ata hay. Jaŋ ta’, a katar baptem daa wayam ŋga Jurdeŋ. ");
INSERT INTO mif_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jaŋ a pey fa vaw na, zana ŋga eŋgwec ŋga slagwama , vaw majəwkaya ta huteɗ. A zəmey na, ayakw ta amam da ley. ");
INSERT INTO mif_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Fa wuztar mey ŋga Gazlavay a ndəhay, a ləvey: «Fa dəɓa aɗaw na, ndaw ma fənya a sawa la. Ya wusa ŋga regedey fa mey aŋga amba ya pəska zeweɗ ŋga tarak aŋga ba. ");
INSERT INTO mif_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yah na, ya kakwar baptem ta yam, ama ndaw aha na, a da kakwar baptem ta *Mesəfney ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Daa masa *Jaŋ-Baptis fa wuzey mey ŋga Gazlavay ta masa aŋga fa katar *baptem a ndəhay na, Yesu a sləkɗawa da slala *Nezeret, daa hwayak ŋga *Galile. A wusey fa *Jaŋ daa wayam ŋga Jurdeŋ heyey. Jaŋ ta’, a kar baptem daa wayam a. ");
INSERT INTO mif_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Masa Yesu fa bawa daa yam a na, wure ŋgene a hətar slam da vaɗ fa wurey, *Mesəfney ŋga Gazlavay a pawa salay a ray a anda makurgwadakw. ");
INSERT INTO mif_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A cənda ɗay maa guzlwa da vaɗ, ma ləvey: «Kah na, Bəzey aɗaw masa yah ma wuɗa kalah. Ya faa səmey ga da ray akah.» ");
INSERT INTO mif_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wure wure ŋgene, Mesəfney ŋga Gazlavay, ta’, a təkar ɗay a Yesu ŋga daw a wuzlah-ley. ");
INSERT INTO mif_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A njey feteɗe ɗar kwakwar məfaɗ, aŋga manjakaya da wuzlah cek ŋga ley hay. Feteɗe, *Sataŋ, bay-malula, a wuɗey ŋga bata, ama ta gwa daa ba. Fa dəɓa ha, maslaŋ hay ŋga Bay Gazlavay da vaɗ a samawa ŋga jənmara. ");
INSERT INTO mif_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pas pal daha, Bay *Herawt a slərey sewje aŋga hay ŋga kərzawa *Jaŋ-Baptis. A kərzamərwa, a jəwmara, a kəzlamara aa fərsəne. Masa ata ma kəzlamara Jaŋ-Baptis a la aa fərsəne na, Yesu ta’, a daw aa hwayak ŋga Galile. Aŋga fa pəkey feteɗe, fa wuzda Mey-maaya-mawiya ŋga Gazlavay a ndəhay, ");
INSERT INTO mif_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","a ləvtar: «Ɗar masa Bay Gazlavay ma wala ta wuswa cay. Anda meləvey, gweegwe cay, Gazlavay a wuzdərwa bay aŋga. Anda keɗe, mbəɗdamara menjey akwar, təɓmara *Mey-maaya-mawiya ŋga Gazlavay!» ");
INSERT INTO mif_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu fa daw da mey dəhwa ŋga *Galile . A da nəkey dey na, a ray ndəhay cew ma kərza ewet daha, ara ata Simaŋw ta məlmaha Andəre. Ata fa kərzam ewet ta tabaw daa dəhwa ha. ");
INSERT INTO mif_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ta’, Yesu a ŋgəchey a cakay ata, a ləvtar: «Samawa asi aɗaw. Akwar na, ndəhay ma kərza ewet, ama dəga wure keɗe ya da tərdakwar ŋga ndəhay ma zəlwa ndəhay aa cəveɗ ŋga Bay Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wure ŋgene, ata *Simaŋw ta *Andəre mbak! a mbəkdamata *tabaw ata hay, ta’, a diyam asi Yesu. ");
INSERT INTO mif_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu a ŋgəchey daa slam aha ŋgene nekəɗey na, a hətatar ata *Jak ta məlmaha *Jaŋ, bəza hay ŋga Zebede. Ata daa kwambiwal ata, fa ɗiymata tabaw ata hay. ");
INSERT INTO mif_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Wure ŋgene, Yesu a zəltərwa. Bəza hay a, a mbəkdamara papa ata Zebede manjakaya daa kwambiwal a ta ndəhay ma kam sləra ta ata. Ta’, ata Jak ta Jaŋ a diyam asi Yesu. ");
INSERT INTO mif_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Fa dəɓa ha, ata Yesu ta gula aŋga hay a diyam a slala Kapernayum. Ta *pas meməskey-vaw, Yesu a daw aa *way-mewuzey-mey ŋga Gazlavay feteɗe. Aa sərkadata ndəhay, a wuztar mey ŋga Gazlavay daa way a. ");
INSERT INTO mif_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ndəhay a, a rəzlam da ray meesərkedey aŋga ha, maja aŋga faa sərkadata ndəhay anda *ndəhay maa sərkada kwakwas ŋga Mawiz ba, ama aa sərkadata ta gədaŋ masa Gazlavay ma vəldara. ");
INSERT INTO mif_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Wure wure ŋgene, ndaw ta malula da ray daha, a mbəzey aa way-mewuzey-mey ŋga Gazlavay a, a wudey ta gədaŋ, a ləvey: ");
INSERT INTO mif_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Yesu, ndaw *Nezeret, walay akah ta ala malula hay me? Ka sawa ŋgaa zəɗdandar daw? Ya səra fara fara, kah na, ndaw ŋga Gazlavay, masa aa ma slərdərwa ŋga key sləra aŋga.» ");
INSERT INTO mif_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu a babəcar a malula da ray ndaw aha, a ləvar: «Njey teete. Bey da ray ndaw keɗe.» ");
INSERT INTO mif_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Malula da ray ndaw a heyey, aa wasada ta gədaŋ, a wudey, ta’, a bey da ray ndaw aha. ");
INSERT INTO mif_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ndəhay makustakaya daa way a cəpa, a rəzlam, aa cəfɗam vaw da wuzlah ata, a ləvam: «Haya! Ara cek e me? Ara meesərkey mawiya daw? Ndaw a, aa ta gədaŋ, kwa aa guzltar a malula hay da ray ndəhay na, malula hay a, a cənmar mey.» ");
INSERT INTO mif_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wure wure ŋgene, sləmay ŋga Yesu fa zəley kwa daa wura daa wura cəpa daa hwayak ŋga *Galile a. ");
INSERT INTO mif_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ta’, Yesu a bey daa *way-mewuzey-mey ŋga Gazlavay da Kapernayum heyey, wure ŋgene, a daw a way ata *Simaŋw ta *Andəre. Ata *Jak ta *Jaŋ a ləgdamara . ");
INSERT INTO mif_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mamaŋ ŋga ŋgwas ŋga Simaŋw, vaw fa car, manakaya, awaw fa vaw ga. Masa Yesu ma wusey la a way a na, wure ŋgene, a kadamara macay ŋga ŋgwas kaa heyey a Yesu. ");
INSERT INTO mif_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu a mbəzey fa ŋgwas aha, a kərza fa har, a sləkɗada. Awaw fa vaw heyey daa saba. Ŋgwas aha, ta’, a vəltar cek mezəmey. ");
INSERT INTO mif_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Masa hakwaɗ ma key la na, ndəhay a handamawa masa-macay hay ga fa Yesu, asaya, a handamawa ndəhay ga masa ta malula da ray. ");
INSERT INTO mif_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ndəhay tabiya da slala ha, a kusam fa mey-mbew ŋga way ŋga ata Simaŋw ta Andəre heyey. ");
INSERT INTO mif_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu a mbəley ndəhay ga daa macay hay mekele mekele. Asaya, a ɓəley malula da ray ndəhay ga. A mbəkdata malula hay a ŋgaa guzlam ba, maja malula hay a, a sərmara Yesu na, ara Bəzey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pepərek e, Yesu a wuley taa pərek e, a daw aa slam masa ndəhay da hwaɗ a daa ba, aŋga fa dərar daŋgay a Gazlavay feteɗe. ");
INSERT INTO mif_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Masa ata *Simaŋw ta mandala aŋga hay ta sləkɗam cay daa ɗar na, a hətmar Yesu saba, ta’, a diyam a səpmara. ");
INSERT INTO mif_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Masa ata ma hətfamar la na, ta’, a ləvmar: «Ndəhay tabiya fa səpmaka.» ");
INSERT INTO mif_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ama Yesu a ləvtar: «Ahaw, ya səra, ama nakwa la a slala hay mekele mekele masa gweegwe ta slala ha keɗe amba ya wuzey mey ŋga Gazlavay da slala hay a may, maja ma handiwa feɗe na, ara sləra ha keɗe.» ");
INSERT INTO mif_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Da ray ŋgene, Yesu a daw a slala hay cəpa masa daa hwayak ŋga *Galile. A wuzey mey ŋga Gazlavay daa way-mewuzey-mey hay ŋga Gazlavay mekele mekele feteɗe, a ɓəley malula hay da ray ndəhay saya. ");
INSERT INTO mif_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yaw, ndaw-maasəkula daha a sawa fa Yesu. Ta’, a regedey fa mey aŋga, a kar ambahw, a ləvar: «Da ka wuɗey na, ka gwa ŋga pərya daa maasəkula aɗaw keɗe.» ");
INSERT INTO mif_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu, a sərfar dey-ceceh, tal! a təlda har aŋga, a gəsfar, a ləvar: «Ya wuɗey amba maasəkula akah a pərey. Tərey ndaw mapərkaya dəɓa!» ");
INSERT INTO mif_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wure wure ŋgene, maasəkula fa ndaw a heyey daa saba. Ndaw aha ta səɗey cay. ");
INSERT INTO mif_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu a ləvar ŋga daw a way, ama masa aŋga ma da ləvar ŋga daw a way na, ta’, a kəta la ɗagay, ");
INSERT INTO mif_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","a ləvar: «Pey leŋgesl, ka da wuzda cek masa yah ma kakawa keɗe kwa a ndaw ba. Ama daw fa *ndaw ma ka kwakwas ŋga Gazlavay, amba a nəkaka. Fa dəɓa ha, vəlar cek a Gazlavay anda *kwakwas ŋga Mawiz ma ləvey, ŋga wuzey a ndəhay, maasəkula fa vaw akah daa saba.» ");
INSERT INTO mif_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ama, ndaw aha ta təɓa mekətey ŋga Yesu a daa ba, ta’, a daw, a wuzdatara cek masa Yesu ma kara heyey ŋgada ndəhay daa hwayak a cəpa. Masa aŋga ma wuzda mey a, a ndəhay ga la na, maja ŋgene, Yesu a gwa ŋga mbəzey aa berney meedey ndəhay saba, maja ndəhay a da kusmawa a cakay a ga kalah. Anda keɗe, Yesu a daw a njey da wuzlah-ley. Ndəhay kwa daa wura daa wura cəpa fa diyam fa vəɗa cəŋga. ");
INSERT INTO mif_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Masa Yesu ma lawa da wuzlah-ley heyey na, ɗar nekəɗey fa dəɓa ha, ta’, a vəhwa a Kapernayum. Ndəhay a cəndamara masa aŋga da way na, ");
INSERT INTO mif_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","a kusmawa ga aa way masa aŋga da hwaɗ a, slam ŋga njey daa way a daa ba, asaya, kwa slam ŋga njey fa mey-mbew ŋga way a daa ba. Feteɗe, Yesu fa wuztar mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ndəhay daha, ta’, a samawa fa aŋga. A samawa na, a handamawa ndaw maahəlɓakaya, ndəhay məfaɗ da wuzlah ata ma lamərwa ndaw aha manakaya da ray ɓeɓele. ");
INSERT INTO mif_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","A hətam slam ŋga handamara fa mey ŋga Yesu ba, maja ndəhay ga kalah. Da ray ŋgene, ta’, a təpam aa ray ŋga way a, a wuram slam dər e ta Yesu manjakaya. Ta’, a ndəkwdamara ndaw maahəlɓakaya heyey taa slam masa ata ma wurmara ha. A təldamara aa way a na, ndaw aha manakaya da ray gegədeɗ aŋga. ");
INSERT INTO mif_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Masa Yesu ma nəka ndəhay a, fa təɓmara aŋga ta gədaŋ ŋga mbəlda ndaw ata na, ta’, a ləvar a ndaw maahəlɓakaya heyey: «Bəz aɗaw, mebərey da ray akah daa saba.» ");
INSERT INTO mif_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","*Ndəhay maa sərkada kwakwas ŋga Mawiz nekəɗey daha feteɗe. Ta’, a wulkam daa ray ata, a ləvam: ");
INSERT INTO mif_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ndaw kaa aa guzley anda keɗe na, maja me? A pa ray aŋga ŋga Gazlavay na, kwara! Ma gwa ŋga mbəkda mebərey ŋga ndaw na, wa? Si Gazlavay pal taava aŋga.» ");
INSERT INTO mif_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wure ŋgene Yesu a səra mewulkey ata. Ta’, aa cəfɗata, a ləvtar: «Ka wulkam daa ray akwar anda keɗe na, maja me? ");
INSERT INTO mif_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ya gwa ya ləvey: “Mebərey akah daa saba” da daa ba, ya gwa ya ləvey: “Sləkɗey, la gegədeɗ akah, daw ta salay akah.” Dasi mey hay cewete keɗe na, masa ta banay ŋga ləvey ŋgada yah na, wura? ");
INSERT INTO mif_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yaw, ya wuɗey ka sərmara yah, *Bəz ŋga Ndaw, yah ta gədaŋ ŋga mbəkey mebərey ŋga ndəhay da bəla.» Anda keɗe, Yesu, ta’, a ləvar a ndaw maahəlɓakaya heyey: ");
INSERT INTO mif_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Ehe, ya fa ləvka: “Sləkɗey, la gegədeɗ akah, daw a way.”» ");
INSERT INTO mif_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wure ŋgene, ndaw aha a lecey fa dey ŋga ndəhay tabiya, ta’, a la gegədeɗ aŋga, a bey da wuzlah ndəhay a, a daw. Da ray ŋgene, ndəhay makustakaya heyey a rəzlam, a həlmamara Gazlavay, a ləvam: «Dəga ŋga menjey aləkwa, aləkwa ta hətkwa cek anda keɗe na, daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu a sləkɗey da slala ha, a daw ŋgada mey dəhwa ŋga *Galile saya. Ndəhay ga a samawa fa aŋga, ta’, Yesu aa sərkadata ta mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Fa dəɓa ha, Yesu a sləkɗey daa slam aha, a daw a pəkey. Masa aŋga fa pəkey na, a hətar *Levi, bəzey ŋga Alfe, aŋga manjakaya fa key sləra daa slam mecekeley budaw. (*Jəwif hay fa rəsmata ndəhay daa səkway ata masa ma cakala budaw ŋga ndəhay Rawma.) Yesu a ləvar: «Sawa, səpya.» Da ray ŋgene, Levi pərta! a sləkɗey, a daw asiya. ");
INSERT INTO mif_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Fa dəɓa ha nekəɗey, Yesu a daw ŋga zəmey ɗaf da way Levi a. Daa way a, ata Yesu ta gula aŋga hay a zəmamara ɗaf a na, ta ndəhay ma cakala budaw ga leŋ ta ndəhay ma zləɓa *kwakwas ŋga Mawiz. A zəmam ɗaf bama na, maja ndəhay ma zləɓa kwakwas ŋga Mawiz a ga fa səpmar wurzay ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ndəhay maa sərkada kwakwas ŋga Mawiz masa da wuzlah *Fariza hay a hətmar Yesu fa zəmam ɗaf ta ndəhay ma zləɓa kwakwas ŋga Mawiz leŋ ta ndəhay ma cakala budaw. Da ray ŋgene, ndəhay maa sərkada kwakwas ŋga Mawiz a, a ləvmatar a *gula hay ŋga Yesu: «Haya! Yesu a zəmam ɗaf ta ndəhay ma cakala budaw leŋ ta ndəhay ma zləɓa kwakwas ŋga Mawiz na, kwara!» ");
INSERT INTO mif_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu ma cənda mey a la na, ta’, aa guzltar, a ləvtar: «Ndəhay masa wurwer na, mey ata ta ndaw ma vəlda slalak daa ba. Ama ma wuɗey mey ŋga ndaw ma vəlda slalak na, si ndəhay masa-macay hay gway. Yaw, ndəhay ma wulkam ata ndəhay maaya fa mey ŋga Gazlavay na, Gazlavay ta slərdiwa ŋga zəlta daa ba, ama a slərdiwa na, ŋga zəley ndəhay masa ta mebərey.» ");
INSERT INTO mif_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ta pas laŋgar daha, gula hay ŋga *Jaŋ-Baptis leŋ *Fariza hay fa kam *daliyam. Ndəhay mekele, ta’, a samawa, aa cəfɗamara Yesu, a ləvmar: «Gula hay ŋga Jaŋ-Baptis leŋ ndəhay ma səpam cəveɗ ŋga Fariza hay fa kam daliyam, ama gula akah hay na, a kam daliyam ba na, maja me?» ");
INSERT INTO mif_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu a mbəɗdatara ta mey-meŋgey, a ləvey: «Da ndaw a zəlwa ndəhay aa mekey məlak ŋga kwakwa ŋga zəmey cek na, a kam daliyam ta pas ŋgene daw? A kam daliyam ba səlak maja zel-kwakwa, aŋga da wuzlah ata. Ta pas masa zel-kwakwa aa manjakaya ta ata na, a kam daliyam ba. ");
INSERT INTO mif_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ama pas a, a sawa la masa ndəhay ma da kərzamara zel-kwakwa ha, a hətmar da wuzlah ata saba. Ta pas a ŋgene na, a kam daliyam la. ");
INSERT INTO mif_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Yaw, ndaw a ɗəpa zana mawiya ta zana magurma ba, maja zana mawiya maɗəpkaya na, a nəsa zana magurma ha la, zana ha a ŋgərey la a dey a. ");
INSERT INTO mif_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Asaya, ndaw a gwa ŋga zlərey wuzam meedeɗek e aa kwene-kwene magurma ba. Da a zləra a hwaɗ a na, wuzam a, a məsley, a ŋgəra kwene-kwene he la. Anda keɗe, wuzam a leŋ kwene-kwene he a nəsam la cewete. Maaya na, si ndaw a zləra wuzam meedeɗek e na, aa kwene-kwene mawiya.» ");
INSERT INTO mif_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ta *pas meməskey-vaw daha, Yesu a diyam ta gula aŋga hay, ata fa diyam taa ley ŋga cek anda daw. Masa ata fa diyam na, gula aŋga hay a həɓam cek aha ŋgaa mbəɗey. ");
INSERT INTO mif_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Da ray ŋgene, ndəhay *Fariza hay aa cəfɗamara Yesu, a ləvmar: «Nəkta gula akah hay fa kam sləra ta pas meməskey-vaw. Ata fa kam cek matəkakaya daa *kwakwas ŋga Mawiz ta pas meməskey-vaw na, maja me?» ");
INSERT INTO mif_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu a mbəɗdatara, a ləvtar: «Akwar ta jaŋgamara daa ɗerewel ŋga Gazlavay cek masa *Davit ma ka zleezle na, daa ba səlak daw? Yaw, ta pas laŋgar daha, Davit ta ndəhay aŋga hay, ata daa banay maja may fa catar, ama cek mezəmey fa ata daa ba. ");
INSERT INTO mif_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Maja ŋgene Davit e, daa masa Abiyatar, aŋga *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay, a mbəzey aa way ŋga Gazlavay, a la peŋ masa mavəldakaya ŋgada Gazlavay, a zəma. Kwakwas ŋga Mawiz a vəley cəveɗ a ndəhay tabiya ŋga zəmey peŋ e ba, si ndəhay ma ka kwakwas gway. Ama Davit ta zəma peŋ e la, ta vəltar la ŋgada ndəhay aŋga hay may.» ");
INSERT INTO mif_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu ta’, aa guzltar saya, a ləvtar: «Gazlavay a pa pas meməskey-vaw na, ŋga key maaya ŋgada ndəhay. Gazlavay a ləmta ndəhay na, amba pas meməskey-vaw a sərdata banay ba. ");
INSERT INTO mif_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Anda keɗe, yah, *Bəz ŋga Ndaw, yah na, ndaw ma wey kwa da ray pas meməskey-vaw.» ");
INSERT INTO mif_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Fa dəɓa ha, Yesu, ta’, a vəhey aa *way-mewuzey-mey ŋga Gazlavay saya. Feteɗe na, ndaw har maməckaya daha. ");
INSERT INTO mif_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","*Fariza hay a wuɗam aa dəɗfamar mey a ray Yesu. Da ray ŋgene, a jəɗmara da a da mbəlda ndaw aha ta *pas meməskey-vaw kwa. ");
INSERT INTO mif_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu a ləvar a ndaw masa har maməckaya heyey: «Lecey feɗe, fa mey ŋga ndəhay tabiya.» ");
INSERT INTO mif_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Fa dəɓa ha, ta’, aa cəfɗata ndəhay heyey, a ləvtar: «Kwakwas aləkwa a ləvey na, kwara? Ta pas meməskey-vaw na, aləkwa ta cəveɗ ŋga key maaya a ndaw daw, da daa ba, ŋga key maaya ba daw? Aləkwa ta cəveɗ ŋga ləhey ndaw daa meməcey daw, da daa ba, ŋga kəɗey ndaw vagay daw?» Ama ndəhay a, a gəmam ŋga mbəɗdamara ba. ");
INSERT INTO mif_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu a nəkta tabiya ta dey magaza. Mevel a car ga maja mevel ata maaya ba. Ta’, a ləvar a ndaw aha heyey: «Təldərwa har a.» Tal! a təldara har a. Har a, ta’, a ɗiyey aa slam a. ");
INSERT INTO mif_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Masa Fariza hay ma hətmar har ŋga ndaw aha ta ɗiyey sem na, a bam daa way-mewuzey-mey ŋga Gazlavay heyey. Wure wure ŋgene, a kusam ta ndəhay ŋga Bay *Herawt, a cəmdamara ɗay ata ŋga kəɗey Yesu vagay. ");
INSERT INTO mif_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ata Yesu ta gula aŋga hay, a mbəkdamata ndəhay daa *way-mewuzey-mey ŋga Gazlavay heyey, a diyam a mey dəhwa ŋga *Galile. Ndəhay ga a diyam asi Yesu a. Ndəhay ma diyam asiya na, a samawa daa hwayak ŋga Galile, ");
INSERT INTO mif_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","daa berney ŋga *Jeruzelem, daa hwayak ŋga *Jude, daa hwayak ŋga Idume, daa hwayak masa ta dey laŋgar ŋga wayam ŋga Jurdeŋ, asaya, daa hwayak hay gweegwe ta berney ŋga Tir leŋ ta berney ŋga Sidaŋw. Ndəhay a, a samawa ga na, maja ata fa cəndamara sləra masa Yesu ma ka. ");
INSERT INTO mif_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ta’, Yesu aa cəfɗata gula aŋga hay ŋga səpmar kwambiwal amba da ndəhay makustakaya ha fa ŋgacamara kalah na, a gwa a təpey aa kwambiwal a. ");
INSERT INTO mif_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ndəhay masa macay hay cəpa fa wusam vaw ŋgada fa Yesu amba a gəsfamar, maja aŋga fa mbəley ndəhay ga. ");
INSERT INTO mif_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ndəhay ta malula da ray daha a hətmar Yesu na, a təɗam asi salay aŋga, a wudam, a ləvam: «Kah, Bəzey ŋga Gazlavay!» ");
INSERT INTO mif_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ama Yesu a kətata, a katar mey ta gədaŋ, a ləvtar a da wuzdamara aŋga na, wa ba. ");
INSERT INTO mif_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Fa dəɓa ha, masa Yesu fa da təpey a aŋgwa na, a zəlta ndəhay masa aŋga ma wuɗey. Ta’, ndəhay a, a diyam fa vəɗa. ");
INSERT INTO mif_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A weley ndəhay kuraw a ray a cew ŋga tərey ndəhay aŋga hay meslərey. A walata na, amba a pəkam bama mandaw mandaw, amba a slərdata ŋga wuzey mey ŋga Gazlavay, ");
INSERT INTO mif_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","asaya, amba a vəltar gədaŋ ŋga ɓəley malula hay da ray ndəhay. ");
INSERT INTO mif_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ndəhay mawalatakaya kuraw a ray a cew e na, ara *Simaŋw ndaw masa Yesu ma par mezəley *Piyer, ");
INSERT INTO mif_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ata *Jak ta məlmaha *Jaŋ, bəza hay ŋga Zebede masa Yesu ma patar mezəley Bawanerges, anda meləvey, «ndəhay ma kam baazlam anda var maa bəcey», ");
INSERT INTO mif_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","*Andəre, *Fəlep, *Bartelemey, *Matiye, *Tuma, Jak bəzey ŋga Alfe, Taade, Simaŋw, ndaw da wuzlah ndəhay ma wuɗam ŋga ləhdamata ndəhay ata hay dasi har ŋga masa-gəra ata hay, ");
INSERT INTO mif_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","leŋ Juda Iskariyawt, ndaw ma vəlda Yesu a har masa-gəra aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Masa Yesu ma walata ndəhay aŋga hay meslərey cay na, ta’, a bərŋgawa da aŋgwa ha, a daw a way. Ndəhay ga a diyam fa aŋga saya. Ata Yesu ta gula aŋga hay kwa ta hətam har ŋga zəmey ɗaf daa ba, maja ndəhay makustakaya ga kalah. ");
INSERT INTO mif_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Masa mamaha ta məlmaha hay ma cəndamara ndəhay makustakaya kalah da cakay a na, ta’, a samawa amba a ŋgəlmara maja ndəhay a, a wulkam, a ləvam: «Malula fa kar a Yesu!» ");
INSERT INTO mif_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","*Ndəhay maa sərkada kwakwas ŋga Mawiz ma samawa da *Jeruzelem, aa guzlam da ray a, a ləvam: «*Beyelzebul, bay ŋga mesəfney maaya ba hay da ray aŋga daha. Ara aŋga ma vəlar gədaŋ ŋga ɓəley malula da ray ndəhay.» ");
INSERT INTO mif_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Maja ndəhay maa guzlam anda ŋgene na, Yesu, ta’, a zəltərwa, a ŋgatar mey, a ləvtar: «*Sataŋ, bay-malula, a gwa a ɓəla malula da ray ndəhay daw? A gwa ba səlak. ");
INSERT INTO mif_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Anda meləvey, da ndəhay daa hwayak pal a kam vəram da wuzlah ata na, hwayak a ŋgene a pəlhey la. ");
INSERT INTO mif_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Asaya, da ndəhay da way pal a kəɗam vaw da wuzlah ata na, way a ŋgene a pəlhey la. ");
INSERT INTO mif_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Anda keɗe, da Sataŋ, bay-malula, a kəɗta ndəhay aŋga hay na, a key ŋgene, a kəɗey ray aŋga, aŋga fa da key bay ata daa saba. ");
INSERT INTO mif_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yaw, kwa ndaw-mayal ma gwa ŋga mbəzey a way ndaw masa-gədaŋ amba a lalatərwa cek aŋga hay meedey aŋga na, daa ba. Si ndaw-mayal a, a key gədaŋ teeseɗ, a jəwa ndaw masa-gədaŋ a ɗagay. Fa dəɓa ha, a gwa a həltərwa cek hay da way a.» ");
INSERT INTO mif_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yesu a ləvtar saya: «Ya fa ləvkwar fara fara, Bay Gazlavay a gwa a mbəkdata mebərey tabiya masa ndəhay ma kamara. Asaya, a gwa a mbəkdata mey hay maaya ba tabiya masa ndəhay maa guzlam da ray a. ");
INSERT INTO mif_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ama, kwa waawa maa guzley mey maaya ba da ray *Mesəfney ŋga Gazlavay na, Gazlavay fa da mbəkdara mebərey ŋga ndaw aha daa ba. Yaw, ndaw ma cəɗa Mesəfney ŋga Gazlavay na, mebərey aŋga a da njey ŋga sərmataw.» ");
INSERT INTO mif_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu a ləvey anda ŋgene na, maja ata faa guzlam, a ləvam: «Malula fa kar a Yesu.» ");
INSERT INTO mif_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ata mamaŋ ŋga Yesu ta məlmaha hay a wusmawa aa way masa Yesu aa da hwaɗ a, a lacam aa ambahw, a sləram ndaw ŋga zələrwa Yesu. ");
INSERT INTO mif_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ndəhay makustakaya ga da cakay a manjatakaya, a ləvmar: «Haya, ata mamakw ta məlmakw hay faa cəfɗamaka daa ambahw.» ");
INSERT INTO mif_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu a mbəɗdatara, a ləvtar: «Mamay na, wa? Məlma aɗaw hay na, wa hay wa?» ");
INSERT INTO mif_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ta’, a nəkfata ndəhay manjatakaya ma zlərmar ray heyey, a ləvtar: «Mamay ta məlma aɗaw hay na, ara ndəhay keɗe, ");
INSERT INTO mif_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","maja məlma aɗaw, dam-mama aɗaw, da daa ba, mamay na, ara ndaw ma key cek masa Gazlavay ma wuɗey.» ");
INSERT INTO mif_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Fa dəɓa ha, Yesu a daw a mey dəhwa ŋga *Galile saya, aa sərkadata ndəhay feteɗe. Ndəhay ga a diyam a cakay a, maja ŋgene, Yesu a təpey aa kwambiwal, a njey a hwaɗ a. Kwambiwal a, aa da ray yam, ama ndəhay na, ata da mey dəhwa ha. ");
INSERT INTO mif_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Daa meesərkey aŋga na, a kadatar cek hay ga ta mey-meŋgey. Daa meesərkey aŋga ha na, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Jəkam sləmay! Ndaw mehəvey daha, a daw ŋgaa kwecey hulfaɗ a ley aŋga. ");
INSERT INTO mif_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Masa aŋga faa kwacada hulfaɗ a ley a na, hulfaɗ laŋgar a kəzley aa cəveɗ. Fa dəɓa ha, ɗiyaŋ hay a samawa, a ndamara. ");
INSERT INTO mif_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hulfaɗ laŋgar, a kəzley aa slam masa pəraɗ, hwiyak da ray a ga daa ba. Hulfaɗ a, a pəcey fiyaw, maja hwiyak da ray a ga daa ba. ");
INSERT INTO mif_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ama menjey nekəɗey, da masa pas fa tey na, a ɓata. Fa dəɓa ha, a kweley, maja slaslalay a daa vəgeɗ ga daa ba. ");
INSERT INTO mif_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hulfaɗ laŋgar a kəzley a wuzlah hatak. Hatak a, a gəley, aa njərɗa hulfaɗ mapəckaya ha. Da ray ŋgene, hulfaɗ mapəckaya ha a gwa a gəley ŋga yey ba. ");
INSERT INTO mif_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ama, hulfaɗ laŋgar a kəzley aa slam masa maaya, a pəcey, a gəley, a yey ga. Hulfaɗ mapəckaya pal babəza fa vəɗa a key kwakwar maakar, laŋgar kwakwar maakwaw, da daa ba, temere.» ");
INSERT INTO mif_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ta’, Yesu a ləvey: «Da ndaw, aŋga ta sləmay na, ŋga cənda mey a maaya maaya.» ");
INSERT INTO mif_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Masa Yesu ma ŋgəchey sem da cakay ndəhay ga heyey na, gula aŋga hay kuraw a ray a cew ta ndəhay mekele da cakay a, aa cəfɗamara da ray mey-meŋgey hay masa aŋga maa guzldatara heyey. ");
INSERT INTO mif_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu a mbəɗdatara, a ləvtar: «Akwar na, Gazlavay ta vəlkwar cəveɗ la ŋga sərey mey da ray mewey aŋga da ray ndəhay. Mey a na, maɓadakaya fa dey ŋga ndəhay siya. A cəndamara mey a anda mey-meŋgey gway. ");
INSERT INTO mif_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Anda keɗe, “Ndəhay a, fa nəkam dey maaya maaya, ama a hətmar dey ba, asaya, fa jəkam sləmay maaya maaya, ama a cəndamara ba, da daa ba na, a mbəɗam dey la ŋgada fa Gazlavay, amba Gazlavay a mbəkdatara mebərey ata.”» ");
INSERT INTO mif_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ta’, Yesu a ləvtar: «Ka sərmara mabara ŋga mey-meŋgey da ray meekwecey hulfaɗ keɗe ba daw? Kaa, ka sərmara mabara ŋga mey-meŋgey hay siya na, kwara? ");
INSERT INTO mif_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ndaw maa kwecey hulfaɗ a ley na, aŋga anda ndaw ma wuzey mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ndəhay siya, ata anda cəveɗ masa hulfaɗ ma kəzley a hwaɗ a. A cəndamara mey ŋga Gazlavay, ama *Sataŋ, bay-malula, a sawa, a la mey a la daa mevel ata. ");
INSERT INTO mif_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ndəhay siya may, ata anda slam masa pəraɗ masa hulfaɗ ma kəzley a hwaɗ a. A cəndamara mey ŋga Gazlavay, a təɓmara fiyaw ta meesəmey. ");
INSERT INTO mif_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ama ndəhay a, a təɓmara mey ŋga Gazlavay ŋga ɗar nekəɗey anda hulfaɗ ma pəcwa masa ta slaslalay daa vəgeɗ ga daa ba. Ta pas masa banay mekele mekele ma da sawa a ray ata maja mey a na, a da mbəkdamara mey ŋga Gazlavay fiyaw fiyaw. ");
INSERT INTO mif_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ndəhay mekele a təɓmara mey ŋga Gazlavay anda hulfaɗ ma kəzley a wuzlah hatak. A təɓmara mey ŋga Gazlavay, ");
INSERT INTO mif_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ama mey a, aa zəɗey anda hulfaɗ mapəckaya maa njərɗey daa hatak maja ata fa wulkam kalah da ray menjey maaya da bəla, maja a wuɗam zleley kalah, asaya maja a səpam cek hay mekele mekele. Da ray ŋgene, ndəhay a taa zəɗdamara mey ŋga Gazlavay daa mevel ata sem. Ata anda cek ma yey babəza ba, maja mewulkey ata ha ŋgene. ");
INSERT INTO mif_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ndəhay mekele saya, a təɓmara mey ŋga Gazlavay anda hulfaɗ ma pəcwa daa slam maaya. A cəndamara mey a, a təɓmara, a kadamara sləra ta aŋga. Anda keɗe, mey a, a yey daa mevel ata anda hulfaɗ ma pəcwa ma yey ga, babəza fa vəɗa a key kwakwar maakar, mekele a key kwakwar maakwaw, da daa ba, temere.» ");
INSERT INTO mif_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ta’, Yesu a ləvtar: «Ndaw a gwa a pa petərla magəɗkaya asi maŋgayak daw? Da daa ba, asi harŋgawaw daw? Kəne ba. Si a pa na, aa slam mepey petərla masa ma gwa ma waɗa slam da way. ");
INSERT INTO mif_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Cek hay tabiya masa maɓadatakaya na, a wuzwa la a palah, a da hətmar fa dey. Anda meləvey, cek masa daa ləvaŋ na, a wuzwa la aa slam mawaɗakaya amba ndəhay tabiya a hətmar. ");
INSERT INTO mif_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Da ndaw, aŋga ta sləmay na, ŋga cənda mey a maaya maaya.» ");
INSERT INTO mif_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu a ləvtar saya: «Pam leŋgesl fa mey masa akwar ma cəndamara keɗe. Anda akwar ma təɓmara mey ŋga Gazlavay na, Gazlavay a wakwara maaya aŋga la kəne, fara fara, a da wakwara ma fəna. ");
INSERT INTO mif_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Da ndaw a təɓa mey ŋga Gazlavay na, Gazlavay a jəna la ŋga təɓa mey a ma fəna ma fəna. Da ndaw a təɓa mey ŋga Gazlavay ba na, kwa mey a masa nekəɗey daa mevel aŋga na, Gazlavay a badərwa la tabiya.» ");
INSERT INTO mif_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu a kadatara saya, a ləvey: «*Mewey ŋga Bay Gazlavay da ray ndəhay na, ya gwa ŋga wa na, ta me? Ehe, ya ŋgakwar mey da ray a. «Ndaw a sləkey cek a ley. ");
INSERT INTO mif_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cek a, a pəcwa. Taa vaɗ, taa pas cek aha fa gəley. Kwa ndaw a, aa daa ɗar, kwa aa ta dey, cek aha fa gəley cəŋga, ama ndaw aha a səra cek aha a gəley na, kwara ba. ");
INSERT INTO mif_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Cek aha, a pəcwa na, taava aŋga, ara hwiyak ma vəlar gədaŋ ŋga pəcərwa. Ŋgeeme cek aha, a bawa anda kwakwas. Fa dəɓa ha, a gəley. A təlwa ray, a nəhey. ");
INSERT INTO mif_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Da cek aha ta nəhey cay na, ndaw aha a ŋgəma maja kiya mekey cek da ley ta wuswa cay.» ");
INSERT INTO mif_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu a kadatara saya, a ləvey: «Ya da wakwa *mewey ŋga Gazlavay da ray ndəhay na, ta me? Ya da wuzdakwara mewey ŋga Gazlavay kaa na, ta mey-meŋgey wura? ");
INSERT INTO mif_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yaw, ya da wakwa mewey ŋga Gazlavay da ray ndəhay na, ta babəza ŋga bazlawar masa ndaw ma rəɓa aa ley aŋga. Aŋga kuset kəɗey dasi babəza ŋga cek hay tabiya da bəla. ");
INSERT INTO mif_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ama da marəɓkaya cay na, a pəcwa, a gəley mahura a fənta cek hay mekele tabiya ma yey babəza mezəmey. A pey har hay mahura mahura, kwa ɗiyaŋ hay a gwamara a ɗiyam way da hwaɗ a.» ");
INSERT INTO mif_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yaw, Yesu a wuzdatara mey ŋga Gazlavay na, ta mey-meŋgey hay anda keɗe. Aa sərkadatar mey ŋga Gazlavay a ndəhay təɗe ta gədaŋ ata amba a cəndamara. ");
INSERT INTO mif_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aa sərkadata na, si ta mey-meŋgey hay gway. Ama da masa ata ta gula aŋga hay daada na, a wuzdatara mabara ŋga mey a maaya maaya. ");
INSERT INTO mif_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Taa kwaɗ aha ŋgene, masa Yesu manjakaya daa kwambiwal heyey na, ta’, a ləvtar a gula aŋga hay: «Təŋgkwa a dey laŋgar ŋga dəhwa.» ");
INSERT INTO mif_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Da ray ŋgene, a mbəkdamata ndəhay makustakaya da mey dəhwa ha, gula hay a, a təŋgdamara Yesu ta kwambiwal masa aa manjakaya da hwaɗ a heyey. Kwambiwal hay mekele malacatakaya da cakay a daha. ");
INSERT INTO mif_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ta’, bərgadaŋ a zlar mekey bew! bew!, a cawaslada yam aa kwambiwal a, haa kwambiwal a, a rəhey. ");
INSERT INTO mif_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu, aŋga fa dəɓa ŋga kwambiwal a, aa daa ɗar, ray mabəckaya fa cek. Gula aŋga hay a sləkɗadamara, a ləvmar: «Bay Mahura, aləkwa fa da məckwa keɗe na, a kaka da ray ba gway daw?» ");
INSERT INTO mif_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu ta’, a sləkɗey, a babəcar a bərgadaŋ, a ləvar: «Ka key saba!» A ləvar a yam a: «Ka wusey saba!» Wure wure ŋgene, bərgadaŋ a, a key saba, yam a, a wusey saba. Memeɗ te’ te’, a key saba. ");
INSERT INTO mif_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ta’, Yesu a ləvtar a gula aŋga hay: «Ka zluram na, maja me? Akwar fa pamaya ŋga ndaw akwar fara fara daa ba daw?» ");
INSERT INTO mif_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Da ray ŋgene, gula aŋga hay a, a zluram ga, aa guzlam da wuzlah ata, a ləvam: «Ndaw a keɗe na, ara na, wa? Masa kwa memeɗ ta yam a cənmar mey keɗe na!» ");
INSERT INTO mif_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Masa Yesu ma lacada bərgadaŋ a la na, a wusam ta gula aŋga hay a dey laŋgar ŋga dəhwa ha, masa daa hwayak ŋga ndəhay Gəraza hay. ");
INSERT INTO mif_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu, ta’, a bərŋgawa daa kwambiwal, wure ŋgene, ndaw daha a bawa daa aŋgwa masa cəvay hay da hwaɗ a, a sawa a cada ray ta aŋga. Ndaw aha, aa ta malula da ray. ");
INSERT INTO mif_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A njey da wuzlah cəvay hay a. Ndaw a gwa a jəwa, kwa ta calalaw ba. ");
INSERT INTO mif_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A jəwmata salay aŋga hay ta har aŋga hay ta calalaw dey weewe, ama a ɗəslta calalaw hay a. Ndaw ma fəna ta gədaŋ daa ba. ");
INSERT INTO mif_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mandaw mandaw, taa vaɗ, taa pas, fa pəkey daa cəvay hay, fa pəkey da aŋgwa. Daa mepəkey aŋga ha na, fa wudey ta gədaŋ, fa pəɗka vaw aŋga ta aŋgwa. ");
INSERT INTO mif_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Masa ndaw aha ma hətar Yesu da dəreŋ na, a hway ŋgada fa vəɗa, a regedey fa mey aŋga. ");
INSERT INTO mif_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesu a ləvar: «Malula, bey da ray ndaw keɗe!» Ama ndaw a, a wudey ta gədaŋ, a ləvey: «Yesu, Bəzey ŋga Gazlavay da vaɗ, ka wuɗey fa yah me? Ya fa kaka ambahw, ta mezəley ŋga Bay Gazlavay, ka da sərdaya banay ba.» ");
INSERT INTO mif_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu aa cəfɗa, a ləvar: «Mezəley akah na, me?» Ndaw aha a mbəɗdara, a ləvar: «Mezəley aɗaw na, “ga,” maja ala malula hay ga.» ");
INSERT INTO mif_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Malula hay da ray ndaw aha a bərkwamara Yesu, amba Yesu a, a ɓəlta daa hwayak a ba. ");
INSERT INTO mif_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Daa slam aha ŋgene, ŋgaɓa ŋga vetem hay ga daha da mecəkwer, fa səpam cek mezəmey da rav-aŋgwa. ");
INSERT INTO mif_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Malula hay da ray ndaw heyey a bərkwamara Yesu, aa cəfɗamara, a ləvmar: «Vəlndar cəveɗ amba ya mbəzam a ray vetem hay katay, may taw.» ");
INSERT INTO mif_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu, ta’, a vəltar cəveɗ. Da ray ŋgene, malula hay a, a bam da ray ndaw aha, a diyam a mbəzam a ray vetem hay a. Vetem hay feteɗe na, a key gweegwe gabal cew. Vetem hay a, a hwam ta gədaŋ ŋgadaa heeleŋ, a tataram, a kwiyam saf! aa dəhwa, a ɓaɓətam cəpa. ");
INSERT INTO mif_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Masa mecəkwer hay ŋga vetem hay kaa heyey ma hətmatar vetem hay a ta ɓaɓətam sem na, a hwam, a diyam, a wuzdamatara a ndəhay da slala ha leŋ a ndəhay gweegwe ta slala ha. Da ray ŋgene, ndəhay a, a samawa ŋga nəkey cek ma key feteɗe he. ");
INSERT INTO mif_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ndəhay a wusmawa a cakay Yesu, a hətfamar ndaw masa Yesu ma ɓəlta malula hay ga da ray a heyey. Ndaw aha manjakaya feteɗe ta zana fa vaw, a səra leŋgesl dəɓa. Da ray ŋgene, ndəhay ma samawa heyey, mandərzay a katar. ");
INSERT INTO mif_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ndəhay feteɗe ma hətmar cek ma key da ray ndaw ta malula da ray, leŋ da ray vetem hay a na, a kadamatara a ndəhay siya ma samawa. ");
INSERT INTO mif_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ta’, ndəhay a, a bərkwamara Yesu ŋga daw daa hwayak ata la. ");
INSERT INTO mif_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Masa Yesu fa təpey aa kwambiwal ŋga daw na, ndaw masa aa ma ɓəlra malula hay da ray aŋga heyey, a bərkwa Yesu amba a vəlar cəveɗ ŋga diyam cew e. ");
INSERT INTO mif_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu a vəlar cəveɗ a ndaw aha ba, ama a ləvar: «Vəhey a way, kadatara a ndəhay akah hay cek mahura masa Bay Gazlavay ma kakawa tabiya, kadatara masa aŋga ma sərey dey-ceceh da ray akah keɗe.» ");
INSERT INTO mif_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ta’, ndaw aha, a daw, a wuzda cek masa Yesu ma ka tabiya da ray a heyey a ndəhay daa hwayak daha mezəley Berney-Hay-Kuraw. Ndəhay cəpa masa ma cəndamara mey a na, a rəzlam. ");
INSERT INTO mif_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu a vəhwa ta kwambiwal da dey laŋgar ŋga dəhwa ŋga *Galile heyey. Ndəhay makustakaya da cakay a ga da mey dəhwa ha. ");
INSERT INTO mif_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ndaw daha mezəley Jayirus, ara ndaw pal da wuzlah *bay-ray hay daa *way-mewuzey-mey ŋga Gazlavay feteɗe. A sawa a cakay ata, a hətar Yesu, ta’, a təɗey asi salay aŋga, ");
INSERT INTO mif_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aa cəfɗa ta matəway daa dey, a ləvar: «Dam aɗaw fa da məcey. Ambahw, sawa, pa har akah a ray a amba a mbəley, a njey ta dey, may taw.» ");
INSERT INTO mif_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ta’, Yesu a diyam cew e. Ndəhay makustakaya ga fa diyam asiya, fa ŋgacamara. ");
INSERT INTO mif_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Da wuzlah ata na, ŋgwas daha, mambaz fa mbəɗwa da hwaɗ dəga mevey kuraw a ray a cew. ");
INSERT INTO mif_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ta sərda banay la ga. Ta daw la fa dakwter hay ga, ta ndəvda zleley aŋga sem tabiya, ama kwa ta key ŋgama daa ba, macay a, fa lar mey ta gədaŋ cəŋga. ");
INSERT INTO mif_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ŋgwas aha fa cənda Yesu fa mbəley ndəhay, maja ŋgene, a sawa a wuzlah ndəhay makustakaya heyey ta fa dəɓa ŋga Yesu. Ta’, a gəsfar har fa zana aŋga. ");
INSERT INTO mif_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","A ka anda keɗe maja aŋga fa wulkey daa mevel aŋga: «Da ya gwa ŋga gəsfar har kwa fa zana aŋga na, ya mbəley la.» ");
INSERT INTO mif_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Masa ŋgwas aha ma gəsfar har fa zana aŋga la na, wure wure ŋgene mambaz aŋga heyey taŋ! a ɗəsley mey. A səra aŋga ta mbəley sem. ");
INSERT INTO mif_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wure ŋgene Yesu a səra gədaŋ ta bey la daa vaw aŋga. Maja ŋgene, a mbəɗwa dey fa dəɓa, a ləvtar a ndəhay ga heyey: «Megəsey har fa zana aɗaw na, wa?» ");
INSERT INTO mif_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Gula aŋga hay a mbəɗdamara, a ləvmar: «Ka fa nəkta ndəhay fa ŋgacamaka ta dey wura wura tabiya kaa na, kaa cəfɗandar “Magəsfaya har wa” na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ama Yesu fa nəkey dey ta cakay cəŋga, amba a hətar ndaw ma gəsfar har a. ");
INSERT INTO mif_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ŋgwas aha mandərzay fa kar ga, faa wesey, a səra Yesu ta mbəlda sem. Da ray ŋgene, a sawa, a təɗey asi salay ŋga Yesu, a wuzdara mabara ŋga mey a. ");
INSERT INTO mif_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu a ləvar: «Dam aɗaw, ka ta mbəley cay maja kah ma paya ŋga ndaw akah fara fara. Daw ta zazay, macay akah daa saba.» ");
INSERT INTO mif_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Masa Yesu faa guzlar ŋgada ŋgwas aha araŋ na, ndəhay a samawa ta meslərey da way Jayirus, bay-ray ŋga way-mewuzey-mey ŋga Gazlavay heyey, a ləvmar ŋgada Jayirus a: «Dam akah heyey, ta məcey sem. Ka gərda vaw ta Bay Mahura keme seme?» ");
INSERT INTO mif_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ama Yesu kwa ta jəkey sləmay fa mey ata daa ba, a ləvar a Jayirus: «Mevel akah a da təɗey ba. Paya ŋga ndaw akah fara fara gway na, cay.» ");
INSERT INTO mif_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yaw, kwa Yesu ta vəley cəveɗ ŋgada ndaw ŋga daw asiya daa ba, si a ŋgəley na, *Piyer, *Jak, leŋ *Jaŋ, məlmaŋ ŋga Jak. ");
INSERT INTO mif_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","A wusam a way Jayirus heyey, a hətfamatar ndəhay makustakaya. Ndəhay a, leŋgesl ata ta mbəɗey sem, fa təwam, fa wudam ta gədaŋ. ");
INSERT INTO mif_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu a mbəzey a way a, a ləvtar: «Leŋgesl akwar a mbəɗey, akwar fa təwam na, maja me? Bəzey a, ta məcey daa ba, ama a key a ney aa ɗar.» ");
INSERT INTO mif_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ndəhay a, aa saŋgəram a ray a. Yesu a badatərwa cəpa aa ambaw. A ŋgəlta ata papaŋ ŋga dam aha ta mamaŋ ŋga dam aha leŋ gula aŋga hay maakar heyey. A mbəzam aa way masa dam aha manakaya da hwaɗ a heyey. ");
INSERT INTO mif_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu ta’, a kərza dam aha fa har, a ləvar: «Talita kum!,» anda meləvey, «Dam aɗaw, ya fa ləvka, lecey.» ");
INSERT INTO mif_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dam keɗe deŋ! a lecey, ta’, a daw. (Mevey ŋga dam aha kuraw a ray a cew.) Wure ŋgene, ata masa daa way a na, a rəzlam ga. ");
INSERT INTO mif_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ama Yesu a kətata, a ləvtar: «Cek masa ma key keɗe na, ka da kadamara ŋgada ndaw ba.» A ləvtar saya: «Vəlmar cek ŋga zəmey.» ");
INSERT INTO mif_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu a sləkɗey da slala ata Jayirus heyey, a daw a *Nezeret, slala masa aa ma gəley da hwaɗ a. Gula aŋga hay a diyam asiya. ");
INSERT INTO mif_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ta *pas meməskey-vaw na, Yesu a daw aa *way-mewuzey-mey ŋga Gazlavay feteɗe, aa sərkadata ndəhay. Ndəhay ga a jəkam sləmay fa mey aŋga. A rəzlam, a ləvam: «Aa sərkadərwa mey ŋga Gazlavay tabiya keɗe na, dama? A hətərwa leŋgesl ŋga sərey cek hay a keɗe na, dama? Ma vəldara gədaŋ ŋga key maazla anda keɗe na, wa? ");
INSERT INTO mif_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aŋga na, ndaw ma sla hwadam, ba diya? Aŋga bəzey ŋga *Mari, ba diya? Aŋga məlmaŋ ŋga *Jak, ŋga Jawz, ŋga Jud, leŋ ŋga *Simaŋw, ba diya? Dam-mamaha hay ata da wuzlah aləkwa feɗe, ba diya?» Ara maja ŋgene, ndəhay feteɗe ma gəmam ŋga təɓmara mey ŋga Yesu ba. ");
INSERT INTO mif_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Maja mewulkey ata ŋgene, Yesu aa guzltar ta mey-meŋgey, a ləvtar: «*Ndaw ma təla mey ŋga Gazlavay na, ndəhay a təɓmara mey aŋga kwa dama dama, ama ma təɓmara ba na, si ndəhay daa hwayak aŋga, ndəhay daa səkway aŋga, asaya, ndəhay da way ata.» ");
INSERT INTO mif_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu a gwa mekey maazla da wuzlah ata ba, si a pey har a ray ndəhay masa-macay hay nekəɗey gway, a mbəldata. ");
INSERT INTO mif_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Da ray ŋgene, Yesu a rəzley da ray ata maja ata ma təɓmara mey aŋga ba. Ta’, Yesu a daw a slala hay mekele daa hwayak a, aa sərkadata ndəhay. ");
INSERT INTO mif_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Fa dəɓa ha, Yesu a zəltərwa gula aŋga hay kuraw a ray a cew, amba a slərdata cew cew aa slam hay mekele mekele. Da ray ŋgene, a vəltar gədaŋ ŋga ɓəley malula hay da ray ndəhay. ");
INSERT INTO mif_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ta’, a kətata, a ləvtar: «Diyam, ama ka da lam cek a har ba. Ka da lam cek mezəmey ba, ka da lam gabal ba, ka da lam dala aa jiba ba, lam a har na, si daŋgwar gway. ");
INSERT INTO mif_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yaw, pamata tarak akwar hay a salay, ka diyam na, si ta zana akwar hay masa fa vaw gway. Ka da lam zana cew cew ba.» ");
INSERT INTO mif_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yesu a kətata saya, a ləvtar: «Da akwar ta wusam la aa slam na, njam da way ndəhay ma təɓmakwar haa kasl pas masa akwar ma da diyam aa slam mekele. ");
INSERT INTO mif_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Da ndəhay daa slam aha a təɓmakwar ba, a jəkam sləmay fa mey akwar ba na, mbəkdamata ndəhay a. Raramatara lagwada fa salay akwar hay amba ka wuzdamatara ata ndəhay masa ta mebərey.» ");
INSERT INTO mif_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gula hay ŋga Yesu heyey a diyam, a wuzdamara mey ŋga Gazlavay a ndəhay. A ləvmatar: «Si ka mbəɗdamara menjey akwar, ka səpmara Gazlavay ta mevel pal.» ");
INSERT INTO mif_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Asaya, a ɓəlam malula hay ga da ray ndəhay, a takwaɗamatar mal fa ndəhay masa-macay hay ga, a mbəldamata. ");
INSERT INTO mif_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bay *Herawt fa cənda mey da ray Yesu maja ndəhay faa guzlam ga da ray a. Ndəhay siya a ləvam: «Ara *Jaŋ-Baptis ma sləkɗawa daa meməcey. Maja ŋgene, aŋga ta gədaŋ ŋga key maazla.» ");
INSERT INTO mif_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mekele hay a ləvam: «Ara *Eli .» Mekele hay saya a ləvam: «Ara ndaw anda ndəhay ma təla mey ŋga Gazlavay zleezle.» ");
INSERT INTO mif_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Masa Herawt ma cənda mey hay a keɗe la na, a ləvey: «Ara Jaŋ-Baptis! Ya ta ɗəslra ray aŋga sem, ama ta sləkɗawa sem daa meməcey!» ");
INSERT INTO mif_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herawt aa guzley anda keɗe na, maja ara aŋga ta ray aŋga ma kəɗa Jaŋ-Baptis a vagay. Ehe mey da ray Jaŋ-Baptis a: Herawt a la Herawdiyat, ŋgwas ŋga məlmaha *Fəlep ŋga ŋgwas aŋga, daa masa Fəlep aa ta dey ɗagay. Maja ŋgene, *Jaŋ a ləvar a Herawt: «Kah ma la ŋgwas ŋga məlmakw ŋgene na, ara cek matəkakaya daa kwakwas aləkwa.» Da ray ŋgene, Herawt a ləvtar a sewje aŋga hay ŋga kərzamara Jaŋ-Baptis a. Ta’, sewje aŋga hay a, a kərzamara, a jəwmara, a kəzlamara aa fərsəne. ");
INSERT INTO mif_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Masa Herawdiyat ma cənda mey ŋga Jaŋ-Baptis keɗe la na, mevel a car, a wuɗey ŋga kəɗa vagay, ama a gwa ba maja Herawt a təɓa ba. ");
INSERT INTO mif_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herawt na, fa zlurey ŋga kəɗa Jaŋ-Baptis a vagay, fa nəkfar dey maja a səra Jaŋ-Baptis ara ndaw ma key cek ta cəveɗ e, ara ndaw ma jəkey sləmay fa Gazlavay. Masa aŋga ma cənda mey masa Jaŋ-Baptis maa guzlda la na, ray aŋga a həɓey ga. Ama Herawt a wuɗey ŋga jəkfar sləmay cəŋga. ");
INSERT INTO mif_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yaw, ɗar masa Herawdiyat ma hətey cəveɗ amba a kəɗmara Jaŋ-Baptis na, ta wuswa cay. Ara pas ŋga gwagway masa Herawt ma sərfada ɗar aŋga ŋga mayawa. Herawt ta zəlwa ndəhay la ga ŋga zəmey ɗaf. A zəlwa gula aŋga hay, bay hay ŋga sewje hay, leŋ mahura hay daa hwayak ŋga *Galile. ");
INSERT INTO mif_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Daa masa ndəhay fa kamara gwagway a na, dam ŋga Herawdiyat a ndəkwey a wuzlah ata, a gərvey. Megərvey a, a mbafar a Herawt ta ŋgada ndəhay mazəltakaya heyey. Ta’, Herawt a ləvar a saɓara ha: «Cacəfɗafaya cek masa kah ma wuɗey amba ya vəldakawa.» ");
INSERT INTO mif_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herawt ta’, a mbeɗey, a ləvey: «Ta Gazlavay tabiya, cek masa kah maa cəfɗafaya na, ya vəldakawa la, kwa ŋga wunkey hwayak aɗaw cew e, ya wunkakwa la.» ");
INSERT INTO mif_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ta’, saɓara ha, a bawa, a daw a ləvar a mamaha: «Ya daa cəfɗafar na, me?» ");
INSERT INTO mif_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mamaha a mbəɗdara, a ləvar: «Cacəfɗafar ray ŋga Jaŋ-Baptis.» Saɓara ha, a wusey vaw, a vəhey fa bay a, a ləvar: «Ya wuɗey ka vəldiwa ray ŋga Jaŋ-Baptis wure keɗe aa vəley.» ");
INSERT INTO mif_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Da ray ŋgene, Herawt aa ta meesəmey daa saba. Ama a gwa ŋga mbəɗda mey aŋga ha saba, maja ta mbeɗey sem fa mey ŋga ndəhay mazəltakaya heyey. ");
INSERT INTO mif_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Anda keɗe, ta’, a slərey sewje wure wure ŋgene ŋga handərwa ray ŋga Jaŋ-Baptis. Ta’, sewje he a daw aa fərsəne, a ɗəslərwa ray ŋga Jaŋ-Baptis a. ");
INSERT INTO mif_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","A parawa aa vəley, a handərwa, a vəldara a saɓara heyey, ta’, saɓara ha a handara a mamaha. ");
INSERT INTO mif_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Masa gula hay ŋga Jaŋ ma cəndamara ta kəɗmara Jaŋ sem na, a diyam a lamara vagay a, a pəshamara aa cəvay. ");
INSERT INTO mif_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Gula hay kuraw a ray a cew masa Yesu ma slərdata cew cew ŋga wuzey mey ŋga Gazlavay heyey a vəhmawa, a kusam a cakay Yesu a, a kadamara cek hay masa ata ma kamərwa, ta masa ata maa sərkadamatərwa a ndəhay. ");
INSERT INTO mif_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ta’, Yesu a ləvtar: «Nakwa aa slam masa ndaw da hwaɗ a daa ba, amba ya njakwa taava aləkwa, amba ka gwamara ka məskam vaw.» A ləvtar anda keɗe na, maja mandaw mandaw ndəhay ga fa samawa, fa vəham, mekele hay fa samawa saya, kwa ata Yesu ta gula aŋga hay a, a hətam har ŋga zəmey ɗaf ba. ");
INSERT INTO mif_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Da ray ŋgene, a təpam aa kwambiwal, a diyam aa slam masa ndaw da hwaɗ a daa ba, amba a njam taava ata. ");
INSERT INTO mif_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Masa ata fa diyam na, ndəhay ga ta hətmatar la, ta sərmara slam masa ata ma diyam a hwaɗ a sem. Da ray ŋgene, ndəhay da slala hay tabiya daa hwayak a, a hwam ta salay, aa slam masa ata ma sərmara ata Yesu ta gula aŋga hay ma da diyam a hwaɗ a. A wusam aa slam aha teeseɗ da ray ata Yesu ta gula aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Masa Yesu ma wusey la aa slam mebərŋgey na, a bərŋgawa daa kwambiwal a, a hətatar ndəhay makustakaya ga. Dey-ceceh a kar, maja a nəkta ndəhay a, ata anda təɓaŋ hay masa manjar mecəkwer. Ta’, aa sərkadata ndəhay a da ray cek hay mekele mekele ga. ");
INSERT INTO mif_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mamba pas a kəzley, *gula hay ŋga Yesu a ŋgəcham fa vəɗa, a ləvmar: «Wure keɗe hakwaɗ cay, aləkwa da wuzlah-ley. ");
INSERT INTO mif_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ləvtar a ndəhay keɗe ŋga diyam a wuzlah-way, da daa ba, a slala hay ta cakay, amba a həɗkamawa cek mezəmey.» ");
INSERT INTO mif_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ama Yesu a mbəɗdatara, a ləvtar: «Akwar ta ray akwar, vəlmatar cek mezəmey a ndəhay a!» A ləvmar: «Ka wuɗey ya diyam ŋga həɗkawa cek mezəmey ta dala ga kalah amba ya vəldamatara a ndəhay keɗe daw?» ");
INSERT INTO mif_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Da ray ŋgene, Yesu aa cəfɗata, a ləvtar: «Da har ndəhay makustakaya feɗe na, peŋ we? Diyam, nəkmərwa.» Masa ata ma nəkmərwa la na, a ləvmar: «Ya hətmawa na, peŋ zlam ta ewet cew.» ");
INSERT INTO mif_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ta’, Yesu a ləvtar a gula aŋga hay ŋga njadamata ndəhay njakw! njakw! a ray kwakwas meendəɓek e. ");
INSERT INTO mif_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Da ray ŋgene, ndəhay a, a njam ta njey. Daa slam pal na, ndəhay temere, temere, daa ba, ndəhay kwakwar zlam, kwakwar zlam. ");
INSERT INTO mif_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu hal! a həlta peŋ zlam ta ewet hay cew heyey, ta’, a baŋgaɗa dey a vaɗ, a kar suse a Gazlavay. Fa dəɓa ha, ta’, a papəsa peŋ e, a vəldatara a gula aŋga hay amba a wunkamatara a ndəhay heyey. Asaya, Yesu a papəsta ewet hay cew heyey, a vəldatara a gula aŋga hay amba a wunkamatara a ndəhay a. ");
INSERT INTO mif_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kwa waawa a zəmey haa a rəhey. ");
INSERT INTO mif_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ta’, gula aŋga hay a cakalamara peŋ ta ewet masa ndəhay ma mbəkdamara. A cakalamara aa gadakar hay. Macakalakaya ha a rəhey gadakar kuraw a ray a cew. ");
INSERT INTO mif_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ndəhay ma zəmam peŋ e na, zel hay a key gabal zlam . ");
INSERT INTO mif_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Masa ndəhay ma zəmam cek cay na, wure ŋgene, Yesu ta’, a təktar ɗay a gula aŋga hay ŋga təpam aa kwambiwal amba ata na, a zləŋgam teeseɗ a dey laŋgar ŋga dəhwa ha gweegwe ta slala Betsayda. Yesu na, a njey fa dəɓa ɗagay amba a mbəɗtar mey a ndəhay makustakaya heyey ŋga diyam a way. ");
INSERT INTO mif_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Fa dəɓa ha masa ata ma wunkam la na, ta’, a daw aa aŋgwa ŋga dərey daŋgay a Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Masa tavaɗ ta key sem na, *gula hay ŋga Yesu ata da wuzlah dəhwa daa kwambiwal. Ama Yesu na, aŋga pal taava aŋga da aŋgwa heyey. ");
INSERT INTO mif_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A nəkta gula aŋga hay na, fa səram banay ga ŋga təŋgey dəhwa ha, maja memeɗ fa key ga ŋgada ray ata. Fa dəɓa ha, gweegwe slam ŋgaa pərek na, Yesu ta’, a daw ta salay da ray yam ŋgada fa ata. Aa ma ŋgəchey la gweegwe ta kwambiwal a na, a wuɗey ŋga mbəkdata fa dəɓa. ");
INSERT INTO mif_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ama ata ma hətmar Yesu fa daw da ray yam a na, a wulkam ara mamayam. Ta’, a wudam, ");
INSERT INTO mif_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","maja ata cəpa fa hətmar aŋga fa daw da ray yam a, anda keɗe, a zluram ga. Ama wure ŋgene, Yesu a ləvtar: «Dəkmara mevel! Ara yah, ka da zluram ba!» ");
INSERT INTO mif_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesu, ta’, a təpey aa kwambiwal fa gula aŋga hay a. Masa aa ma təpey la aa kwambiwal a na, memeɗ a key saba. Da ray ŋgene, gula aŋga hay a, a rəzlam ga, ");
INSERT INTO mif_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","maja kwa ata ma hətmar maazla masa Yesu ma ka ta peŋ heyey na, daa ŋgene ta gwamara ŋga sərmara gədaŋ ŋga Yesu a daa ba, maja ray ata maŋgərɗakaya. ");
INSERT INTO mif_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Masa ata Yesu ta gula aŋga hay ma təŋgam la a dey laŋgar ŋga dəhwa heyey na, a wusam aa hwayak daha mezəley Genezeret. A jəwmara kwambiwal a mey dəhwa ha feteɗe. ");
INSERT INTO mif_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","A bərŋgamawa daa kwambiwal a, wure ŋgene ndəhay a sərmara ara Yesu ma bərŋgawa. ");
INSERT INTO mif_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A hwam a slala hay mekele mekele cəpa ŋga wuzey a ndəhay siya Yesu ta sawa la. Da ray ŋgene, a handamatərwa masa-macay hay manatakaya fa gegədeɗ aa slam masa Yesu aa da hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aa slam masa Yesu ma daw, kwa a slala hay, kwa aa berney hay, kwa a wuzlah-ley na, ndəhay ga fa handamawa masa-macay hay aa slam masa ndəhay makustakaya da hwaɗ a. A bərkwamara amba masa-macay hay a gəsam har kwa fa mey ŋga zana aŋga gway. Ndəhay ma gəsfamar har cəpa na, ta mbəlam sem. ");
INSERT INTO mif_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","*Fariza hay ta ndəhay siya da wuzlah *ndəhay maa sərkada kwakwas ŋga Mawiz a samawa da *Jeruzelem, a kusam a cakay Yesu. ");
INSERT INTO mif_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","A hətmatar *gula hay ŋga Yesu siya fa zəmam ɗaf ta har manjar ŋga pərey. Anda meləvey, gula hay a ta kamara anda kwakwas ata ma ləvey na, daa ba. ");
INSERT INTO mif_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yaw, Fariza hay a ta ndəhay *Jəwif hay mekele tabiya fa kamara kwakwas a. A da zəmam ɗaf na, si a pərmara har maaya maaya la. ");
INSERT INTO mif_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Da ta vəhmawa daa luma cay, fa da zəmam ɗaf na, si a pəram la ɗagay. A nam ray a cek hay mekele mekele anda kwakwas ata ma ləvey. Anda meləvey, a pərmata vəley hay, kwakulam hay, leŋ maŋgayak hay amba a təram ndəhay mazləɓtakaya ba. ");
INSERT INTO mif_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Da ray ŋgene, Fariza hay ta ndəhay maa sərkada kwakwas ŋga Mawiz heyey, aa cəfɗamara Yesu a, a ləvmar: «Gula akah hay a kam cek hay anda kwakwas ŋga papaŋ ŋga papa aləkwa hay ma wuzdamandakwara ba na, maja me? Ata fa zəmam ɗaf ta har manjar ŋga pərey.» ");
INSERT INTO mif_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu a mbəɗdatara, a ləvtar: «Akwar ndəhay masa ta neneh cew! Zleezle *Izay, *ndaw ma təla mey ŋga Gazlavay maa guzley da ray akwar na, anja fara. A wuzlala daa ɗerewel ŋga Gazlavay, a ləvey: “Gazlavay a ləvey: Ndəhay keɗe fa həslmaya ray ta mey ŋga tede, ama mevel ata na, aa dəreŋ ta yah. ");
INSERT INTO mif_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ata fa həlmamaya, ama mehəlmey a, ta tərey sem ŋga cek ŋga tede, maja kwakwas masa ata maa sərkadamara ŋgene na, ara kwakwas ŋga ndaw-magədaŋ daada gway.”» ");
INSERT INTO mif_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu a ləvtar saya: «Akwar, Fariza hay ta ndəhay maa sərkada kwakwas ŋga Mawiz, ka mbəkdamara *mewey hay ŋga Gazlavay, ama ka kam kwakwas ma sawa ta fa ndəhay.» ");
INSERT INTO mif_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ta’, Yesu aa guzltar saya: «Haya! Mewey hay ŋga Gazlavay na, ka wuɗam saba, ka mbəkdamara amba ka səpam kwakwas akwar jak daw? ");
INSERT INTO mif_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yaw, Mawiz a ləvey: “Natar ray ŋgada ata papakw ta mamakw.” Mawiz a ləvey saya: “Ndaw ma cəɗa papaha, da daa ba, mamaha na, si a kəɗmara ndaw aha vagay.” ");
INSERT INTO mif_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ama akwar na, akwar faa sərkadam ndəhay, ka ləvam, ndaw a gwa ŋga ləvar a papaha, da daa ba, a mamaha: “Cek masa yah ma da vəldakawa ŋga jənka heyey na, ya vəldakawa daa saba, maja cek aha na, Kwarbaŋ.” (“Kwarbaŋ” a wuɗey ŋga ləvey “cek mavəldakaya ŋgada Gazlavay.”) ");
INSERT INTO mif_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Da ray ŋgene, ka ləvmatar a ndəhay ŋga jənmata papa ata hay ta mama ata hay saba. ");
INSERT INTO mif_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Anda keɗe, akwar fa nəsmara mey ŋga Gazlavay ta meesərkedey akwar, maja ka pamara kwakwas akwar ŋga mahura da ray mey ŋga Gazlavay. Asaya, akwar fa kam cek hay mekele mekele maaya ba letek anda cek aha keɗe.» ");
INSERT INTO mif_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ta’, Yesu a zəlta ndəhay makustakaya tabiya saya, a ləvtar: «Jəkfamaya sləmay, akwar tabiya, cəndamara mey keɗe. ");
INSERT INTO mif_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Cek masa ndaw ma zəma na, a gwa ŋga kar mebərey a ndaw aha ba, ama si mewulkey masa ma bawa daa mevel aŋga.  ");
INSERT INTO mif_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wure keɗe anja akwar ta sləmay na, cəndamara mey a keɗe maaya maaya.» ");
INSERT INTO mif_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Fa dəɓa ha, Yesu a mbəkdata ndəhay makustakaya heyey, a mbəzey aa way. Gula aŋga hay ta’, aa cəfɗamara da ray mey-meŋgey masa aa ma kada ha. ");
INSERT INTO mif_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu ta’, a ləvtar: «Akwar may, haa wure keɗe, ka cəndamara ba cəŋga daw? Ya wuɗey ka sərmara fara fara cek mezəmey ma mbəzey a hwaɗ ndaw na, a gwa ŋga kar mebərey a ndaw aha ba, ");
INSERT INTO mif_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","maja cek aha a mbəzey aa mevel aŋga ba, ama a mbəzey aa zakwataf aŋga, fa dəɓa ha, a bawa a palah.» Anda keɗe, Yesu fa wuzda cek hay mezəmey cəpa na, ndaw a gwa a zəma, a kar mebərey ba. ");
INSERT INTO mif_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesu aa guzltar saya, a ləvey: «Cek ma kar mebərey a ndaw na, ara mewulkey ma bawa daa mevel aŋga. ");
INSERT INTO mif_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ahaw, ara daa mevel ŋga ndaw-magədaŋ mewulkey maaya ba ma bawa. Mewulkey a, a həlda ndaw ŋga key cek hay malamba, anda meleley, mekəɗey ndaw vagay, ");
INSERT INTO mif_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","meley-vaw saw da palah, mekey dey fa cek ŋga ndəhay, mekey cek ta maagway, membərzley, mekey cek ma ka hwaray, mekey səleŋ, mekey mbaɗa fa ndəhay, mezlepey, leŋ mepey leŋgesl ba. ");
INSERT INTO mif_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yaw, cek hay maaya ba tabiya keɗe na, a bamawa daa mevel ŋga ndaw, a kamar mebərey a ndaw a.» ");
INSERT INTO mif_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ta’, Yesu a sləkɗey daa slam a ŋgene, a daw aa hwayak mekele gweegwe ta berney ŋga Tir. A mbəzey aa way. A wuɗey amba ndaw a səra aŋga feteɗe ba, ama a gwa ŋga ɓey ba. ");
INSERT INTO mif_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Feteɗe, ŋgwas daha aŋga dam *Jəwif ba, a yawa da Fenisi daa hwayak ŋga Siri. Dam aŋga daha, aŋga ta malula da ray. Masa aa ma cənda mey da ray Yesu na, wure ŋgene, a daw fa vəɗa, a təɗey fa mey aŋga. Ta’, a kar ambahw a Yesu, a ləvar: «Ɓəla malula da ray dam aɗaw keɗe may taw.» ");
INSERT INTO mif_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ama Yesu aa guzlar ta mey-meŋgey, a ləvar: «Mbəkdata bəza hay ŋga rəham ɗagay, maja mevəley ɗaf ŋga bəza hay ŋgada gədey hay na, maaya ba.» ");
INSERT INTO mif_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ŋgwas aha a mbəɗdara, a ləvar: «Ahaw, Bay aɗaw. Ama kwa gədey hay daa slam masa ndəhay fa zəmam ɗaf na, ata fa zəmam meepəsey ŋga ɗaf masa bəza hay ma kəzlamata a hwayak may, ba diya?» ");
INSERT INTO mif_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Da ray ŋgene, Yesu a ləvar: «Kah ma mbəɗdərwa mey a la maaya. Maja ŋgene, malula ta bey sem da ray dam akah, ka gwa ŋga daw a way.» ");
INSERT INTO mif_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Anda keɗe, ŋgwas aha, a daw a way, a hətfar dam aŋga manakaya da ray harŋgawaw ta meesəmey, malula ta bey sem da ray aŋga. ");
INSERT INTO mif_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ta’, Yesu a sləkɗey daa slam masa gweegwe ta berney ŋga Tir heyey. A daw ta daa berney ŋga Sidaŋw, a vəhwa ta mey dəhwa ŋga *Galile gweegwe ta hwayak ŋga Berney-Hay-Kuraw. ");
INSERT INTO mif_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ndəhay a handamawa ndaw daha madagazlam, maada. A bərkwamara Yesu amba a par har a ray ŋga wurara sləmay aŋga ta ŋga tərda neneh aŋga dadakw saba. ");
INSERT INTO mif_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Anda keɗe, Yesu ta’, a ŋgəla ndaw aha aa slam masa dəreŋ ta ndəhay makustakaya. A pata bəz-mey-har aŋga hay aa sləmay ŋga ndaw aha. Ta’, a təfey meesleɓ fa bəz-mey-har aŋga, a wusa neneh ŋga ndaw aha ta bəz-mey-har a. ");
INSERT INTO mif_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ta’, Yesu a baŋgaɗa dey a vaɗ, a səfney ta gədaŋ, a ləvar a ndaw aha: «Efata» anda meləvey, «Wurey!» ");
INSERT INTO mif_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wure ŋgene, sləmay ŋga ndaw aha ta’, a wurey. Neneh aŋga, dadakw saba. ");
INSERT INTO mif_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu a kətata tabiya, a ləvtar: «Ka da wuzdamara a ndaw ba.» Ama kwa Yesu a təkta ŋga wuzda mey a na, ata ta wuzdamara sem cəŋga. ");
INSERT INTO mif_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ndəhay a rəzlam ga, a ləvam: «A key cek hay cəpa maaya. Kwa sləmay ŋga ndaw madagazlam na, a wura. Kwa neneh ŋga ndaw maada na, a tərda dadakw saba.» ");
INSERT INTO mif_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Daa ɗar hay a ŋgene masa Yesu fa pəkey daa hwayak ŋga Berney-Hay-Kuraw heyey na, ndəhay ga a samawa, a kusam a cakay a saya. Cek fa ata ŋga zəmey daa ba. Yesu a zəltərwa gula aŋga hay, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Dey-ceceh fa kaya fa ndəhay makustakaya keɗe, maja aŋga kaa ɗar maakar ata da cakay aɗaw. Wure keɗe cek mezəmey da har ata daa saba. ");
INSERT INTO mif_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Da ya mbəkdata ŋga diyam a way ata hay ta may na, fa da hətam gədaŋ daa cəveɗ daa ba, maja ndəhay siya hay da wuzlah ata, a samawa da dəreŋ.» ");
INSERT INTO mif_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Gula aŋga hay a mbəɗdamara, a ləvmar: «Aləkwa daa wuzlah-ley keɗe na, ya da hətkurwa peŋ ŋga rəhey ndəhay tabiya keɗe na, dama?» ");
INSERT INTO mif_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu aa cəfɗata, a ləvey: «Da har akwar feɗe kaa na, peŋ we?» A ləvam: «Da feɗe na, peŋ maasala daha.» ");
INSERT INTO mif_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ta’, Yesu a ləvtar a ndəhay makustakaya heyey ŋga njam a hwayak. Fa dəɓa ha, ta’, a həla peŋ maasala heyey, a kar suse a Gazlavay. A papəsa, a vəldatara a gula aŋga hay amba a wunkamatara a ndəhay a. Ta’, a wunkamatara. ");
INSERT INTO mif_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Da har ata, ewet mecəhe mecəhe nekəɗey daha saya. Yesu a kar suse a Gazlavay. Ta’, a ləvtar a gula aŋga hay ŋga wunkamatara saya. ");
INSERT INTO mif_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kwa waawa ta hətey cek mezəmey la, haa a rəhey. Ta’, gula aŋga hay a cakalamara siya ma mbəkdakaya. Macakalakaya ha a rəhey gadakar mahura mahura maasala. ");
INSERT INTO mif_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ndəhay ma zəmam cek feteɗe he na, a fəna ndəhay gabal məfaɗ. Fa dəɓa ha, Yesu a ləvtar a ndəhay a ŋga vəham a way ata hay dəɓa. ");
INSERT INTO mif_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Wure wure ŋgene, a təpam ta gula aŋga hay aa kwambiwal, a diyam aa hwayak ŋga Dalmanuta. ");
INSERT INTO mif_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fa dəɓa ha, *Fariza hay a wusmawa fa Yesu, a zlamar mekey yawa ta aŋga. A wuɗam a jadamara. Da ray ŋgene, aa cəfɗamara amba a key maazla ŋga wuzda gədaŋ aŋga a sawa ta fa Bay Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu a səfney ta gədaŋ, a gərey maja a təɓmara mey aŋga ba, ta’, a ləvtar: «Ndəhay masa wure keɗe aa cəfɗam maazla ŋga wuzdərwa ara Gazlavay ma slərdiwa na, maja me? Ya fa ləvkwar fara fara, ya fa da key maazla ha daa ba.» ");
INSERT INTO mif_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ta’, Yesu a mbəkdata Fariza hay a, a daw a mbəzey aa kwambiwal ŋga təŋgey a dey laŋgar ŋga dəhwa ŋga *Galile. ");
INSERT INTO mif_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Daa kwambiwal a na, *gula hay ŋga Yesu ata ta peŋ pal gway. A sərfadamara ŋga handawa peŋ a dey a saba. ");
INSERT INTO mif_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ta’, Yesu a kətata, a ləvtar: «Wam vaw fa cek ma həsla peŋ ŋga *Fariza hay, leŋ fa cek ma həsla peŋ ŋga Bay *Herawt.» ");
INSERT INTO mif_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gula aŋga hay a wulkam, aa guzlam da wuzlah ata, a ləvam: «Aa guzley anda keɗe na, maja aləkwa ma sakurwa ta peŋ daa ba daw?» ");
INSERT INTO mif_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu a səra cek masa ata maa guzlam da wuzlah ata. Da ray ŋgene, aa cəfɗata, a ləvtar: «Ka wulkam da ray peŋ masa akwar ma handamawa daa ba na, maja me? Haa wure keɗe akwar na, ka cəndamara mey a ba cəŋga daw? Akwar na, ray maŋgərɗakaya. ");
INSERT INTO mif_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Akwar fa nəkam dey, ama ka hətmar dey ba daw? Akwar fa jəkam sləmay, ama ka cənam sləmay ba daw? Daa masa yah ma wunkata peŋ zlam ŋgada ndəhay gabal zlam heyey na, mambəkakaya na, a rəhey gadakar we? Akwar fa sərfadamara, ba diya?» A mbəɗdamara, a ləvmar: «Gadakar hay kuraw a ray a cew.» ");
INSERT INTO mif_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu a ləvtar saya: «Daa masa yah ma wunkatara peŋ maasala ŋgada ndəhay gabal məfaɗ heyey na, ka rəham gadakar mahura hay ta peŋ mambəkakaya na, we?» A mbəɗdamara, a ləvmar: «Gadakar mahura mahura maasala.» ");
INSERT INTO mif_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ta’, Yesu a ləvtar: «Ka sərfadamara cek masa yah ma ka, ama haa wure keɗe ka cəndamara mey masa yah maa guzlda da ray cek ma həsla peŋ keɗe ba cəŋga daw?» ");
INSERT INTO mif_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ta’, Yesu ta gula aŋga hay a wusam a Betsayda. Feteɗe a handamawa ndaw-wulaf fa vəɗa, a kamar ambahw ŋga gəsfar har fa ndaw aha amba dey aŋga a wurey. ");
INSERT INTO mif_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Da ray ŋgene, Yesu ta’, a kərza ndaw aha fa har, a ɗaɗa dəreŋ ta slala ha. Ta’, a kar meesleɓ fa dey ŋga ndaw aha, a par har fa dey, aa cəfɗa, a ləvar: «Ka fa hətar dey dəɓa daw?» ");
INSERT INTO mif_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ndaw-wulaf a, a baŋgaɗa dey, a ləvey: «Ya fa hətatar ndəhay, ama ata anda wudez hay ma diyam.» ");
INSERT INTO mif_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ta’, Yesu a gəsfar har fa dey saya. Ndaw aha, dey aŋga a wurey, a hətatar cek hay maaya maaya dəɓa. ");
INSERT INTO mif_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu aa guzlar ŋga daw a way, a kəta, a ləvar: «Ka da daw ta Betsayda keɗe ba, daw a way ɗagay.» ");
INSERT INTO mif_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Fa dəɓa ha, ata Yesu ta gula aŋga hay a diyam a slala hay masa gweegwe ta slala mahura mezəley Sezere-Fəlep. Masa ata fa diyam daa cəveɗ na, Yesu aa cəfɗata, a ləvey: «Yah na, ndəhay a padamaya na, ŋga wa?» ");
INSERT INTO mif_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A mbəɗdamara, a ləvmar: «Ndəhay siya a ləvam kah na, *Jaŋ-Baptis. Mekele hay a ləvam kah na, *Eli, *ndaw ma təla mey ŋga Gazlavay zleezle. Mekele hay saya a ləvam kah na, ndaw pal dasi ndəhay ma təla mey ŋga Gazlavay zleezle.» ");
INSERT INTO mif_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ta’, aa cəfɗata saya, a ləvtar: «Kaa akwar may, ka ləvam yah na, wa?» Piyer a mbəɗdara, a ləvar: «Kah na, *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay.» ");
INSERT INTO mif_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ta’, a kətata gula aŋga hay, a katar mey, a ləvtar: «Ka da wuzdamara mey a keɗe a ndaw ba.» ");
INSERT INTO mif_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu, ta’, aa sərkadata gula aŋga hay, a ləvtar: «Si yah, *Bəz ŋga Ndaw, ya sərey banay la ga ɗagay. Mahura hay ŋga *Jəwif hay, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, leŋ *ndəhay maa sərkada kwakwas ŋga Mawiz a rəsmaya la, fa da təɓmara ara Gazlavay ma slərdiwa na, daa ba. A da kəɗmaya vagay, ŋga ɗar maakar a na, ya sləkɗawa la daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A wuzdatara mey a keɗe, ɓa’ a palah ta ɓada daa ba. Da ray ŋgene, *Piyer ta’, a zəla ta cakay, a mbəɗar ray. ");
INSERT INTO mif_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu pəla! a mbəɗey dey, a nəkta gula aŋga hay siya. Ta’, a kar mey a Piyer, a ləvar: «Hway la da cakay aɗaw, kah, *Sataŋ. Maja mewulkey akah ŋgene na, ara mewulkey ŋga Gazlavay ba, ama ara mewulkey ŋga ndaw-magədaŋ gway.» ");
INSERT INTO mif_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ta’, a zəlta ndəhay makustakaya ŋga ŋgəchamawa a cakay ata ta gula aŋga hay. A ləvtar: «Da ndaw a wuɗey ŋga səpya na, si a mbəkda mewulkey da ray ray aŋga, a səpya ta mevel pal, si a ɓəsa banay ma da sawa a ray a maja yah, anda yah ma da məcey fa hwadam mazlaŋgalakaya. ");
INSERT INTO mif_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sərmara, kwa waawa ma wuɗey ŋga ləhda heter aŋga na, a key ŋgene, aa zəɗda. Ama kwa waawa maa zəɗda heter aŋga maja aŋga fa səpya, asaya, maja aŋga fa wuzey *Mey-maaya-mawiya a ndəhay na, a key ŋgene, a ləhda heter aŋga ha. ");
INSERT INTO mif_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Da ndaw a hətey cek hay tabiya masa aŋga ma wuɗey da bəla keɗe, ama taa zəɗda heter aŋga sem na, cek hay a tabiya ŋgene, ta ləhdamara ndaw a la daw? ");
INSERT INTO mif_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yaw, ndaw a gwa ŋga mbəɗa heter aŋga ta cek ba. ");
INSERT INTO mif_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kwa waawa ma paya hwaray, da daa ba, ma key hwaray ŋga təɓa mey aɗaw fa mey ŋga ndəhay da bəla wure keɗe masa ma mbəkdamara Bay Gazlavay sem ta masa ma kam mebərey keɗe na, yah, Bəz ŋga Ndaw, ya par hwaray la ta pas masa yah ma da vəhwa ta gədaŋ ŋga Papay leŋ ta maslaŋ aŋga hay.» ");
INSERT INTO mif_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu aa guzltar saya, a ləvtar: «Ya fa ləvkwar fara fara, ndəhay siya da wuzlah akwar feɗe, fa da məcam daa ba, si ata ma hətmar Bay Gazlavay fa wey ta gədaŋ aŋga la ɗagay.» ");
INSERT INTO mif_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ɗar maakwaw fa dəɓa ha na, Yesu ta’, a zəlta ata *Piyer, *Jak, leŋ *Jaŋ, a ŋgəlta aa ray ŋga aŋgwa maazəma daa slam aha, a njam taava ata feteɗe. Yesu pəla! a mbəɗey fa dey ata. ");
INSERT INTO mif_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Zana aŋga a tərey mabara, a weɗey ndəɗ-ndeɗ. Meweɗey ŋga zana ha ŋgene na, kwa ndaw da bəla keɗe ma gwa ŋga pəra zana ha ŋga weɗey kəne daa ba. ");
INSERT INTO mif_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wure wure ŋgene, gula aŋga hay maakar heyey, a hətmatar ata *Eli ta *Mawiz, ndəhay ŋga Gazlavay zleezle, faa guzlam ta Yesu. ");
INSERT INTO mif_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Da ray ŋgene, Piyer aa guzlar a Yesu, a ləvar: «Bay ala, maaya na, ya njakwa feɗe. Ya da kərcam slam hay maakar, pal ŋgada kah, pal ŋgada Mawiz, pal ŋgada Eli.» ");
INSERT INTO mif_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyer aa guzley anda keɗe na, maja mandərzay fa katar kalah, a səra mey masa aa maa guzlda ba. ");
INSERT INTO mif_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ta’, mekwtene a sərtata. Daa mekwtene he na, a cənam ɗay ma ləvey: «Keɗe he ara Bəzey aɗaw masa yah ma wuɗa kalah. Jəkfamar sləmay!» ");
INSERT INTO mif_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wure wure ŋgene, *gula hay ŋga Yesu a, a nəkam dey ta cakay, ama a hətmatar ndəhay a saba, si a hətam na, Yesu pal taava aŋga da cakay ata. ");
INSERT INTO mif_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Masa ata fa bərŋgamawa da aŋgwa ha na, Yesu a kətata, a ləvtar: «Cek masa akwar ma hətmərwa keɗe na, ka da wuzdamara a ndaw ba səlak, haa kasl pas masa yah, *Bəz ŋga Ndaw, ma da sləkɗawa daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Gula hay ŋga Yesu a, a təɓmara mekətey a keɗe, ama aa cəfɗam vaw da wuzlah ata, a ləvam: «Masləkɗawa daa meməcey na, mey a, a wuɗey ŋga ləvey na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ta’, aa cəfɗamara Yesu, a ləvmar: «Ndəhay maa sərkada kwakwas ŋga Mawiz, a ləvam si Eli a sawa la teeseɗ da ray *Kəriste na, maja me?» ");
INSERT INTO mif_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu a mbəɗdatara, a ləvtar: «Ahaw, fara fara Eli a sawa la teeseɗ ŋga ɗiyta cek hay cəpa maaya maaya. Mawuzlalakaya daa ɗerewel ŋga Gazlavay, a ləvey, Bəz ŋga Ndaw, a sərey banay la ga, ndəhay a rəsmara la. Akwar fa sərfadamara mey a keɗe daw? ");
INSERT INTO mif_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yaw, ya fa ləvkwar Eli na, ta sawa cay. Anda ɗerewel ŋga Gazlavay ma ləvey da ray a zleezle na, ndəhay ta kamar cek maaya ba la anda ata ma wuɗam.» ");
INSERT INTO mif_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ata Yesu ta ata *Piyer, *Jak, leŋ *Jaŋ a ŋgəcham gweegwe ta *gula hay ŋga Yesu siya zlam-letek. Feteɗe a hətam ndəhay ga da cakay gula hay a. *Ndəhay maa sərkada kwakwas ŋga Mawiz daha feteɗe, fa kam yawa ta gula hay zlam-letek e. ");
INSERT INTO mif_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Masa ndəhay heyey ma hətmar Yesu la na, wure ŋgene ata cəpa a rəzlam, a wusam vaw ŋgada fa aŋga amba a camar har. ");
INSERT INTO mif_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu aa cəfɗata gula aŋga hay feteɗe, a ləvtar: «Ka kam yawa ta ndəhay keɗe na, da ray me?» ");
INSERT INTO mif_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ndaw pal da wuzlah ndəhay makustakaya heyey aa guzlar, a ləvar: «Bay aɗaw, ya ta handakawa bəzey aɗaw la. Aŋga ta cek da ray, fa təka ŋgaa guzley. ");
INSERT INTO mif_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kwa daa wura daa wura masa cek aha ta zlar la na, a təɗda a hwayak, maŋgwafakw a bawa da mey, aa pəɗey sler, vaw aŋga a mberey. Ya ta cacəfɗata gula akah hay la amba a badamara cek aha na, ama ta gwamara daa ba.» ");
INSERT INTO mif_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ta’, Yesu a mbəɗdatara a ndəhay a, a ləvtar: «Akwar səkway ŋga ndəhay ma pamaya ŋga ndaw akwar fara fara ba keɗe. Ya da njey ta akwar na, haa ta vara? Ya da ɓəskwar na, haa ta vara? Yaw, handamiwa bəzey a.» ");
INSERT INTO mif_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ta’, a handamara bəzey a fa Yesu. Masa bəzey a ma hətar Yesu na, wure ŋgene, cek aha aa wasada. Ta’, bəzey a, a təɗey a hwayak, a pətkweley da hwayak, maŋgwafakw a bawa da mey. ");
INSERT INTO mif_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ta’, Yesu aa cəfɗa papaŋ ŋga bəzey a, a ləvar: «Cek aha a zlar anda keɗe na, dəga ŋga vara?» Papaha a mbəɗdara, a ləvar: «A zlar dəga daa bəzey. ");
INSERT INTO mif_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ta pas mekele cek aha, a təɗda aa awaw, da daa ba, a təɗda aa yam amba a kəɗa vagay. Da ka gwa ŋga ɓəla cek da ray bəzey a na, ambahw, sərfandar dey-ceceh, jənndar may taw!» ");
INSERT INTO mif_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu a mbəɗdara, a ləvar: «Ka ləvey da ya gwa ŋga ɓəla na, maja me? Ya gwa ya key cek hay cəpa ŋgada ndaw ma paya ŋga ndaw aŋga fara fara.» ");
INSERT INTO mif_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wure ŋgene, papaŋ ŋga bəzey a, a wudey, a ləvey: «Ya fa paka ŋga ndaw aɗaw fara fara, ama aŋga ta banay ŋgada yah, si ka jənya ŋga paka ŋga ndaw aɗaw ma fəna.» ");
INSERT INTO mif_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Masa Yesu ma nəkta ndəhay ga fa hwamawa ŋga nəkey cek masa aa ma ka na, a babəcar a cek da ray bəzey a heyey, a ləvar: «Kah, cek ma təka bəzey keɗe ŋgaa guzley, ma təka ŋga jəkey sləmay, ya fa ləvka, bey, daw! Ka da vəhwa a ray a saba!» ");
INSERT INTO mif_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ta’, cek aha, a zlar saya, a wudey ta gədaŋ. Aa wasada bəzey a ta gədaŋ, a təɗda a hwayak. Cek aha, a bey da ray bəzey a. Ndəhay ga da cakay a, a ləvam: «Bəzey a ta məcey sem.» Aa guzlam anda keɗe na, maja bəzey a, ta ɓərzley sem. ");
INSERT INTO mif_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ama Yesu a kərza fa har, a sləkɗada. Ta’, bəzey a, a lecey. ");
INSERT INTO mif_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu ta’, a daw a way. Masa ata taava ata ta gula aŋga hay da way na, gula aŋga hay a, aa cəfɗamara, a ləvmar: «Ala ta gwamara ŋga badamara cek da ray bəzey a daa ba na, maja me?» ");
INSERT INTO mif_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu a mbəɗdatara, a ləvtar: «Ŋga bey cek anda keɗe da ray ndaw na, si ta medərey-daŋgay a Bay Gazlavay gway.» ");
INSERT INTO mif_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ata Yesu ta gula aŋga hay a sləkɗam daa slam aha ŋgene, a diyam taa hwayak ŋga *Galile a Kapernayum. Yesu a wuɗey ndəhay a sərmara a lawa dama ba, ");
INSERT INTO mif_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","maja aŋga faa sərkadata gula aŋga hay. Daa meesərkey a na, a ləvtar: «A da kərzamaya, yah, *Bəz ŋga Ndaw. A da vəldamaya a har ndəhay. Ndəhay a, a da kəɗmaya vagay, ama ŋga ɗar maakar a na, ya sləkɗawa la daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ama gula aŋga hay ta cəndamara mey masa Yesu maa guzldatara ŋgene daa ba. Asaya, a zluram ŋgaa cəfɗamara mey a. ");
INSERT INTO mif_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ata Yesu ta gula aŋga hay a wusam a Kapernayum, a mbəzam a way. Masa ata da way a na, Yesu aa cəfɗata, a ləvtar: «Ŋga fene, ka kam yawa daa cəveɗ na, da ray me?» ");
INSERT INTO mif_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ama a njam teete, maja daa masa ata daa cəveɗ na, ta kam yawa la da wuzlah ata, a ləvam: «Mahura dasi aləkwa na, wa?» ");
INSERT INTO mif_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu, ta’, a njey ta njey, a zəlta gula aŋga hay kuraw a ray a cew, a ləvtar: «Da ndaw a wuɗey a key mahura da ray ndəhay na, si a pa ray aŋga ŋga mecəhe, a jənta ndəhay tabiya.» ");
INSERT INTO mif_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A ley bəzey mecəhe, a lacada a wuzlah ata. A kərza bəzey a fa har, ta’, a ləvtar a gula aŋga hay: ");
INSERT INTO mif_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Nəkmara bəzey masa yah ma kərza keɗe. Yaw, kwa waawa ma təɓey bəzey anda bəzey mecəhe keɗe maja a wuɗya na, ndaw aha a key ŋgene, a təɓey yah, ray aɗaw. Asaya, kwa waawa ma təɓya na, a təɓey ŋgene, yah pal taava aɗaw ba, ama a key a təɓey Bay Gazlavay ndaw ma slərdiwa may.» ");
INSERT INTO mif_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","*Jaŋ aa guzlar a Yesu, a ləvar: «Bay ala, ala ta hətam ndaw daha la fa ɓəley malula da ray ndəhay ta mezəley akah. Ya wuɗam ŋga təkmara maja ara ndaw da wuzlah aləkwa ba.» ");
INSERT INTO mif_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu a mbəɗdatara, a ləvtar: «Ka da təkmara ba, maja da ndaw a gwa mekey maazla maaya ta gədaŋ ma sawa ta mezəley aɗaw na, ndaw aha fa daa guzley mey maaya ba da ray aɗaw na, daa ba. ");
INSERT INTO mif_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Anda keɗe, ndaw masa aŋga masa-gəra aləkwa ba na, ara jam aləkwa. ");
INSERT INTO mif_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yaw, ya fa ləvkwar fara fara, ndaw ma jənkwar ta cek nekəɗey, kwa a vəlkwar yam ŋga sey maja akwar ndəhay aɗaw hay na, Bay Gazlavay a pəlra mawurɓay aŋga la.» ");
INSERT INTO mif_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Kwa waawa ma betey ndaw pal dasi ndəhay ma təɓa mey aɗaw hay keɗe ŋga key mebərey na, ŋgada aŋga na, ŋgama ata ma jəwmar aŋgwa mahura a ɗay, ma kəzlamara aa bəlay. ");
INSERT INTO mif_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Anja da har akah, fa həldaka ŋga key mebərey na, ɗəsla har a. Ŋgama kah ma hətey heter mendəvey ba ta har pal, da ray kah ma da mbəzey aa awaw mendəvey ba masa daa vəgeɗ ŋga awaw magaza ta har akah hay cewete.  ");
INSERT INTO mif_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Feteɗe, “mətal ma zəmey ndaw fa da ndəvey daa ba, awaw fa da məcey daa ba.” ");
INSERT INTO mif_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Da salay akah, fa həldaka ŋga key mebərey na, ɗəsla salay a. Ŋgama kah ma hətey heter mendəvey ba ta salay pal, da ray kah ma da mbəzey aa vəgeɗ ŋga awaw magaza ta salay akah hay cewete.  ");
INSERT INTO mif_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Feteɗe, “mətal ma zəmey ndaw fa da ndəvey daa ba, awaw fa da məcey daa ba.” ");
INSERT INTO mif_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Da dey akah, fa həldaka ŋga key mebərey na, wuzlka dey a. Ŋgama kah ma mbəzey ta dey pal aa slam masa Gazlavay ma wey da ray ndəhay aŋga hay da vaɗ, da ray kah ma da mbəzey aa vəgeɗ ŋga awaw magaza ta dey akah hay cewete. ");
INSERT INTO mif_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Feteɗe, “mətal ma zəmey ndaw fa da ndəvey daa ba, awaw fa da məcey daa ba.” ");
INSERT INTO mif_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Sərmara, Gazlavay a jada ndaw aŋga maaya, da daa ba, maaya ba na, ta awaw leŋ ta manda . ");
INSERT INTO mif_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Manda na, ara cek maaya. Ama da manda ha a cərey saba na, ya da kadakwa amba a cərey saya na, kwara? Akwar na, kam maaya a ndəhay anda manda ma cərda cek. Njam ta zazay da wuzlah akwar, ka da təram vaw ba.» ");
INSERT INTO mif_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu a sləkɗey da slala Kapernayum, a daw aa hwayak ŋga *Jude da dey laŋgar ŋga wayam ŋga Jurdeŋ. Ndəhay a kusam ga a cakay a saya. Aa faa sərkadata anda aa ma ka mandaw mandaw. ");
INSERT INTO mif_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","*Fariza hay a diyam fa vəɗa, amba a jadamara. Aa cəfɗamara, a ləvmar: «Kwakwas aləkwa a vəley cəveɗ a ndaw ŋga ɓəla ŋgwas aŋga daw?» ");
INSERT INTO mif_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu a mbəɗdatara, a ləvtar: «*Mawiz a ləvkwar ŋga key na, kwariya?» ");
INSERT INTO mif_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Fariza hay a, a ləvmar: «Mawiz a ləvey da ndaw a wuɗey ŋga ɓəla ŋgwas aŋga na, si a wuzlalar ɗerewel ŋga ɓəla ŋgwas aŋga ha ɗagay, fa dəɓa ha, a ɓəla.» ");
INSERT INTO mif_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu a ləvtar: «Sərmara, Mawiz a wuzlala *mewey a ŋgene na, maja mevel akwar maaya ba, ka gəmam ŋga təɓmara mey ŋga Gazlavay ba. ");
INSERT INTO mif_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Daa mezley ŋga bəla, “Gazlavay a ləmwa na, zel ta ŋgwas”, ba diya? ");
INSERT INTO mif_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Maja ŋgene, ndaw-mezəle a mbəkda papaha ta mamaha, amba a cəmam ta ŋgwas aŋga. ");
INSERT INTO mif_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ata cewete, a təram anda ndaw pal.” Anda keɗe, ata ndəhay cew saba, ama ata anda ndaw pal. ");
INSERT INTO mif_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yaw, cek masa Gazlavay ma cəma sem anda keɗe na, ndaw a da wunka ba.» ");
INSERT INTO mif_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Fa dəɓa ha, masa ata Yesu ta gula aŋga hay ma vəham cay a way na, gula aŋga hay aa cəfɗamara saya da ray meɓəley ŋgwas. ");
INSERT INTO mif_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu a ləvtar: «Kwa waawa ma ɓəla ŋgwas aŋga, fa dəɓa ha, a ley mekele na, ndaw aha a key ŋgene, a ley vaw saw da palah, a key a kar cek maaya ba ŋgada ŋgwas aŋga mahura. ");
INSERT INTO mif_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ŋgada ŋgusay may, da ŋgwas a mbəkda zel e, a daw asi ndaw mekele na, ŋgwas aha a key ŋgene, a ley vaw saw da palah.» ");
INSERT INTO mif_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ndəhay a handamata bəza hay fa Yesu amba a patar har a ray, a pəstar mey. Ama gula aŋga hay a kamatar mey a ndəhay a. ");
INSERT INTO mif_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Masa Yesu ma nəka cek masa gula aŋga hay ma kamara ha na, a mbafar ba, ta’, aa guzltar, a ləvtar: «Mbəkdamatərwa bəza hay ŋga samawa fa yah! Ka da təkmata ba, maja Gazlavay fa wey da ray ndəhay masa anda bəza hay a. ");
INSERT INTO mif_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ya fa ləvkwar fara fara, da ndaw fa təɓa Bay Gazlavay ŋga wey da ray a anda bəzey mecəhe ma təɓa daa ba na, ndaw aha fa da mbəzey a wuzlah ndəhay masa Gazlavay ma wey da ray ata na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ta’, a lata bəza hay a, a har aŋga, a patar har a ray, a pəstar mey. ");
INSERT INTO mif_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Masa Yesu fa da daw aa slam mekele na, gula daha a hawa fa aŋga, a regedey fa mey aŋga, ta’, a ləvar: «Bay aɗaw, ndaw masa maaya, ya da key amba ya hətey heter mendəvey ba na, me?» ");
INSERT INTO mif_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu, ta’, a ləvar: «Ka zəlya ndaw maaya na, maja me? Ndaw maaya na, Gazlavay pal taava aŋga. ");
INSERT INTO mif_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yaw, ka səra *mewey hay ŋga Gazlavay, ba diya? Ara mey ma ləvey: “Ka da kəɗey ndaw vagay ba, ka da ley vaw saw da palah ba, ka da leley ba, ka da mbərzley a ray ndaw ba, ka da təkney cek ŋga ndaw ba, natar ray ŋgada ata papakw ta mamakw.”» ");
INSERT INTO mif_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ndaw a, a mbəɗdara, a ləvar: «Bay aɗaw, dəga yah daa zariya aɗaw, ya ta zləɓta mewey hay a ŋgene daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu a nəka ndaw aha, a wuɗa, ta’, a ləvar: «Cek pal ma mbəkaka daha ŋga key. Anda keɗe, daw, həɗkadata cek akah hay tabiya, wunkatara dala ha a masa-viya hay. Da ka ta ka la kəne na, ka da hətey zleley fa Gazlavay da vaɗ. Masa kah ma vəldatara dala ha cay a masa-viya hay na, sawa, səpya.» ");
INSERT INTO mif_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Masa ndaw a ma cənda mey a keɗe la na, a ndərɓa dey, a daw, aŋga ta meesəmey daa ba, maja aŋga ta zleley ga, a wuɗey a vəlda a ndəhay mekele ba. ");
INSERT INTO mif_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu a nəkta gula aŋga hay da cakay a, ta’, a ləvtar: «Aŋga ta banay ga ŋgada ndəhay masa-zleley amba a təɓmara Gazlavay ŋga wey da ray ata.» ");
INSERT INTO mif_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Gula aŋga hay a rəzlam ga da ray mey a. Ama Yesu a ləvtar saya: «Bəz aɗaw hay, aŋga ta banay ŋgada ndaw amba a təɓa Bay Gazlavay ŋga wey da ray a . ");
INSERT INTO mif_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ahaw, aŋga ta banay ŋgada slagwama ŋga mbəzey taa vəgeɗ ŋga baatal. Ama aŋga ta banay ga ma fəna saya ŋgada ndaw masa-zleley ŋga təɓa Bay Gazlavay ŋga wey da ray a.» ");
INSERT INTO mif_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Gula aŋga hay a rəzlam ta gədaŋ ta gədaŋ, aa cəfɗam vaw da wuzlah ata, a ləvam: «Da anda keɗe na, ma da ləhey daa mebərey na, wa?» ");
INSERT INTO mif_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Da ray ŋgene, Yesu a nəkta, a ləvtar: «Meləhey daa mebərey na, ara cek masa ndaw-magədaŋ ma gwa ŋga ka ba. Ama Gazlavay a gwa ŋga ləhda ndaw maja aŋga na, a gwa a kata cek hay tabiya.» ");
INSERT INTO mif_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","*Piyer a ləvar a Yesu: «Yaw, ala na, ya ta mbəkdamatərwa cek ala hay sem cəpa, amba ya səpmaka.» ");
INSERT INTO mif_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu a mbəɗdara, a ləvar: «Ya fa ləvkwar fara fara, da ndaw a mbəkdərwa way aŋga, da daa ba, a mbəkdatərwa məlmaha hay, dam-mamaha hay, mamaha, papaha, bəz aŋga hay, da daa ba, a mbəkdatərwa ley aŋga hay, amba a səpya, asaya amba a wuzey *Mey-maaya-mawiya na, ");
INSERT INTO mif_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ndaw aha, daa masa aŋga da bəla na, a hətey cek hay a la ma fəna, a key dey temere a ray cek hay masa aŋga ma mbəkdatərwa ha. Anda meləvey, a da hətey way hay, məlmaŋ hay, dam-mamaŋ hay, mamaŋ hay, bəza hay, ta ley hay mekele mekele saya. Asaya, ndəhay a sərdamara banay la ga maja mey aɗaw. Fa dəɓa ŋga mendəvey ŋga bəla na, a hətey heter mendəvey ba la saya. ");
INSERT INTO mif_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yaw, ndəhay ga ma təɓmara mey aɗaw ŋgeeme, a da vəham fa dəɓa. Asaya, ndəhay masa fa dəɓa, a da diyam fa mey.» ");
INSERT INTO mif_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ata Yesu ta ndəhay mekele, ata daa cəveɗ ma daw a *Jeruzelem. Yesu fa daw fa mey ŋga gula aŋga hay. Gula aŋga hay a, ray ata fa həɓey maja a sərmara Yesu a da sərey banay da Jeruzelem, ama aŋga fa daw a Jeruzelem e cəŋga. Asaya, ndəhay mekele masa ma səpmatar wurzay na, fa diyam ta mandərzay daa dey. Yesu a ŋgəlta gula aŋga hay kuraw a ray a cew saya ta cakay, aa guzltar da ray cek masa ma da hətfar. ");
INSERT INTO mif_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A ləvtar: «Ehe, aləkwa fa nakwa a Jeruzelem. Feteɗe na, yah, *Bəz ŋga Ndaw, a da vəldamaya a har *bay-ray hay ŋga ndəhay ma ka kwakwas ta *ndəhay maa sərkada kwakwas ŋga Mawiz. A da kamaya sariya ŋga kəɗey vagay, a da vəldamaya a har ndəhay ma təɓa mey ŋga Gazlavay ba. ");
INSERT INTO mif_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ndəhay a na, aa saŋgəram la a ray aɗaw, a təfmaya meesleɓ la aa dey, a sləɗmaya la ta laway. Fa dəɓa ha, a kəɗmaya la vagay. Ŋga ɗar maakar a na, ya sləkɗawa la daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Fa dəɓa ha, *gula hay ŋga Yesu masa bəza hay ŋga Zebede, ata *Jak ta *Jaŋ, a samawa fa Yesu, a ləvmar: «Bay ala, ya wuɗam ka kandar cek masa ala ma daa cəfɗamaka.» ");
INSERT INTO mif_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu a mbəɗdatara, a ləvtar: «Ka wuɗam ya kakwar na, me?» ");
INSERT INTO mif_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","A mbəɗdamara, a ləvmar: «Ya wuɗam ta pas masa kah ma da zəma bay akah na, pəskandar mey amba ndaw pal a njey ta har-zəmay akah, ndaw laŋgar a njey ta har-gula akah.» ");
INSERT INTO mif_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Maja ŋgene, Yesu a ləvtar: «Ka sərmara cek masa akwar maa cəfɗam ba. Ka gwamara ŋga səram banay la anda yah ma da səra daw? Da daa ba, ka gwamara ŋga ɓəsmara banay la anda yah ma da ɓəsa daw?» ");
INSERT INTO mif_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","A mbəɗdamara, a ləvmar: «Ahaw, ya gwamara.» Yesu a ləvtar: «Ahaw, ka səram banay la anda yah ma da səra. Ka ɓəsmara banay la anda yah ma da ɓəsa. ");
INSERT INTO mif_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ama ŋga njey ta har-zəmay aɗaw, da daa ba, ta har-gula aɗaw na, ara yah ma da ɗəsla mey a ŋgene ba. Ara Gazlavay ma da ɗiyta slam hay a ŋgene ŋgada ndəhay masa aa ma walata.» ");
INSERT INTO mif_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Fa dəɓa ha, masa gula aŋga hay siya kuraw ma cəndamara mey a na, a cam mevel a ray ata Jak ta Jaŋ. ");
INSERT INTO mif_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Da ray ŋgene, Yesu a zəlta tabiya, a ləvtar: «Ka sərmara da wuzlah ndəhay da bəla keɗe na, bay hay daha. Bay hay a na, fa wam da ray ndəhay ta gədaŋ, asaya, mahura hay mekele fa wam da ray ndəhay ta cəveɗ e ba. ");
INSERT INTO mif_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ama da wuzlah akwar na, a da key kəne ba. Yaw, da ndaw da wuzlah akwar a wuɗey ŋga key mahura na, si a tərey ndaw ma ka sləra akwar. ");
INSERT INTO mif_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Asaya, da ndaw da wuzlah akwar a wuɗey ŋga key *bay-ray na, si a tərey anda beke ŋga ndəhay cəpa. ");
INSERT INTO mif_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Maja, yah, *Bəz ŋga Ndaw, ya sawa a bəla na, amba ndəhay a kamaya sləra ba. Ama ya sawa na, amba ya katar sləra a ndəhay, ya vəlda heter aɗaw ŋga ləhey ndəhay ga daa mebərey.» ");
INSERT INTO mif_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ata Yesu ta gula aŋga hay a wusam a Jerikwaw, a mbəzam a slala ha. Fa dəɓa ha, masa Yesu fa bam da slala ha ta gula aŋga hay leŋ ndəhay ga heyey na, ndaw-wulaf daha mezəley Bartime, ara bəzey ŋga ndaw mezəley Time. Ndaw-wulaf a na, manjakaya feteɗe, fa rəkey da mey-cəveɗ. ");
INSERT INTO mif_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Masa aŋga ma cənda ara Yesu, ndaw *Nezeret, ma daw taa cəveɗ e na, a wudey, a ləvey: «Yesu, *Bəzey ŋga Davit, ambahw sərfaya dey-ceceh, may taw!» ");
INSERT INTO mif_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ndəhay ga heyey a kamar mey, a ləvmar ŋga njey teete, ama ndaw-wulaf a, a wudey ta gədaŋ cəŋga, a ləvey: «Bəzey ŋga Davit, ambahw sərfaya dey-ceceh, may taw!» ");
INSERT INTO mif_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu ta’, a lecey, a ləvtar a ndəhay da cakay a: «Zəlmərwa ndaw aha.» Ta’, ndəhay a, a zəlmərwa, a ləvmar: «Dəka mevel, lecey, Yesu fa zəlka.» ");
INSERT INTO mif_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Anda keɗe, aa zakada gwedeere aŋga, pərta! a lecey, a daw fa Yesu. ");
INSERT INTO mif_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ta’, Yesu aa cəfɗa, a ləvar: «Ka wuɗey ya kaka na, me?» Ndaw-wulaf a, a mbəɗdara, a ləvar: «Bay aɗaw, ya wuɗey ka wuryawa dey aɗaw amba ya hətar dey cəŋga.» ");
INSERT INTO mif_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu a ləvar: «Dey akah ta wurey cay, maja kah ma paya ŋga ndaw akah fara fara. Wure keɗe, daw.» Wure wure ŋgene, dey aŋga ta’, a wurey, a hətar dey dəɓa. Ta’, a səpa Yesu daa madaw aŋga. ");
INSERT INTO mif_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ata Yesu ta gula aŋga hay fa diyam aa berney ŋga *Jeruzelem. Masa ata gweegwe ta berney a na, a wusam gweegwe ta slala Betfaje leŋ ta slala Betani da rav Aŋgwa ŋga *Awliviye. Ta’, Yesu, a slərey gula aŋga hay cew teeseɗ ŋgada slala ha. ");
INSERT INTO mif_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","A ləvtar: «Diyam a slala fa mey akwar katay. Da akwar ma wusam la a slala ha na, ka hətfam bəz-zəŋgwaw majəwkaya la feteɗe masa kwa ndaw ta təpey a ray a daa ba araŋ. Pəskamərwa, handamərwa feɗe. ");
INSERT INTO mif_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Da ndaw aa cəfɗakwar, a ləvey ka pəskamara zəŋgwaw a ŋga key me na, ka mbəɗdamara, ka ləvmar: “Bay Mahura a wuɗey. A da vəhdakawa wure keɗe.”» ");
INSERT INTO mif_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Da ray ŋgene, a diyam, a hətfamar bəz-zəŋgwaw a, majəwkaya da mey-cəveɗ gweegwe ta mey-mbew. A pəskamərwa. ");
INSERT INTO mif_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ndəhay nekəɗey da wuzlah ndəhay feteɗe daha aa cəfɗamata, a ləvmatar: «Ka pəskamara zəŋgwaw a na, keme?» ");
INSERT INTO mif_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","A mbəɗdamatara, a ləvmatar: «Bay Mahura a wuɗey. A da vəhdakwara wure keɗe.» Ta’, ndəhay a, a mbəkdamata ŋga diyam ta zəŋgwaw a. ");
INSERT INTO mif_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","A handamərwa zəŋgwaw a heyey a Yesu. A ciymata zana ata hay a ray zəŋgwaw a. Ta’, Yesu a təpey a ray a. ");
INSERT INTO mif_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ndəhay ga malacatakaya daa cəveɗ ŋga cey ray ta Yesu, a ciyam zana ata hay aa cəveɗ e ŋga həslmar ray. Ndəhay mekele a diyam a bəzlhamawa mey-har ŋga wudez hay da ley, a pamata aa cəveɗ e may. ");
INSERT INTO mif_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ndəhay fa diyam fa mey aŋga, ndəhay mekele hay fa diyam fa dəɓa aŋga. Ata tabiya fa wudam, a ləvam: «*Hawzana! Həlmakwa Bay Gazlavay! Anja Bay Gazlavay ŋga pəsar mey a ndaw masa aa ma slərdərwa ta mezəley aŋga. ");
INSERT INTO mif_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Anja Bay Gazlavay ŋga pəsar mey a bay ma da wey aa slam a ŋga Bay *Davit, papaŋ ŋga papa aləkwa zleezle. Həlmakwa Bay Gazlavay da vaɗ!» ");
INSERT INTO mif_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ta’, Yesu a mbəzey aa berney ŋga Jeruzelem. A daw aa *Way-mekey-kwakwas ŋga Gazlavay. A saŋgalata cek hay cəpa da hwaɗ a. Ta’, a diyam ta gula aŋga hay kuraw a ray a cew a Betani maja gweegwe tavaɗ cay. ");
INSERT INTO mif_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pepərek e, ata Yesu ta gula aŋga hay a sləkɗam da Betani heyey. Daa ŋgene, may fa car a Yesu. ");
INSERT INTO mif_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Masa ata fa diyam daa cəveɗ na, Yesu a hətey wudez da dəreŋ, wudez e maɗaɗakaya. Ta’, a daw a cakay a amba a nəka da babəza fa wudez e daha kwa. Ama, a hətfey fa wudez e na, si gwaslaf gway, babəza fa vəɗa daa ba, maja ara kiya meyey babəza ba. ");
INSERT INTO mif_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Da ray ŋgene, Yesu a nəsa wudez e, a ləvey: «Anja wudez keɗe ŋga yey babəza saba ŋga sərmataw.» Masa aŋga maa guzley anda keɗe na, gula aŋga hay ta cəndamara mey a la. ");
INSERT INTO mif_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ata Yesu ta gula aŋga hay, a wusmawa a *Jeruzelem. Yesu a mbəzey aa papalah ŋga *Way-mekey-kwakwas ŋga Gazlavay. Feteɗe na, ndəhay fa kam luma. Maja ŋgene, ta’, a ɓəlta ndəhay ma həɗkadam cek hay leŋ ndəhay ma həɗkam cek hay. A bəzlta slam hay ŋga ndəhay ma mbəɗa dala ta jaŋga hay ŋga ndəhay ma həɗkadam makurgwadakw hay. ");
INSERT INTO mif_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Asaya, Yesu a vəley cəveɗ kwa ŋgada waawa ŋga daw ta cek hay wura wura taa papalah ŋga Way-mekey-kwakwas ŋga Gazlavay a ba. ");
INSERT INTO mif_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Da ray ŋgene, a sasərkadata ndəhay, a ləvey: «Mawuzlalakaya daa ɗerewel ŋga Gazlavay, Gazlavay a ləvey: “Way aɗaw na, ara way amba ndəhay da bəla tabiya a dərmaya daŋgay da hwaɗ a.” Ama akwar na, ka tərdamara way a keɗe ŋga slam ŋga mayal hay!» ");
INSERT INTO mif_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Masa *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta *ndəhay maa sərkada kwakwas ŋga Mawiz ma cəndamara mey masa Yesu ma kada keɗe na, a səpam cəveɗ ŋga kəɗmara vagay maja ata fa zluram ta aŋga. A zluram na, maja ndəhay ga fa rəzlam da ray mey masa aŋga maa sərkadatara. ");
INSERT INTO mif_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Masa tavaɗ ta key cay na, ta’, Yesu a bamawa ta gula aŋga hay daa berney ŋga Jeruzelem e. ");
INSERT INTO mif_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pepərek e, masa ata Yesu ta gula aŋga hay fa diyam taa cəveɗ ma daw a *Jeruzelem na, a hətmar wudez manjar babəza heyey ta kweley sem haa kasl fa slaslalay a. ");
INSERT INTO mif_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","*Piyer a sərfada masa Yesu ma nəsa wudez e heyey, ta’, a ləvar a Yesu: «Bay Mahura, nəka wudez masa kah ma ləvey ŋga yey babəza saba heyey na, ta kweley sem.» ");
INSERT INTO mif_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Da ray ŋgene, Yesu a ləvtar: «Pamara Gazlavay ŋga ndaw akwar fara fara mandaw mandaw. ");
INSERT INTO mif_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ya fa ləvkwar fara fara, ndaw a gwa a ləvar a aŋgwa mahura: “Sləkɗey la feɗe, kəzley aa bəlay.” Da ndaw aha aŋga ta mewulkey cew cew daa ba, asaya, da aŋga fa wulkey fara fara daa mevel aŋga Gazlavay a da kara cek masa aŋga maa cəfɗa na, Gazlavay a kara la. ");
INSERT INTO mif_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Maja ŋgene, ya fa ləvkwar, da akwar fa dəram daŋgay a Gazlavay ŋgaa cəfɗey cek, asaya, da akwar fa wulkam daa mevel akwar Gazlavay a vəldakwara cek aha la na, Gazlavay a vəldakwara cek aha la, kwa kaa cəfɗam meeme daa medərey-daŋgay akwar. ");
INSERT INTO mif_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yaw, da akwar fa dəram daŋgay a Gazlavay, mevel akwar fa cey a ray ndaw na, mbəkdamara mebərey ŋga ndaw aha, amba Papakw akwar masa da vaɗ a mbəkdakwara mebərey akwar may.  ");
INSERT INTO mif_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ama da ka mbəkdamatara mebərey ŋga ndəhay ba na, Papakw akwar masa da vaɗ a mbəkdakwara mebərey akwar daa ba may.» ");
INSERT INTO mif_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ata Yesu ta gula aŋga hay a vəhmawa a *Jeruzelem saya. Masa Yesu fa pəkey daa *Way-mekey-kwakwas ŋga Gazlavay na, *bay-ray hay ŋga ndəhay ma ka kwakwas, ta *ndəhay maa sərkada kwakwas ŋga Mawiz, leŋ mahura hay ŋga *Jəwif hay a diyam fa aŋga. ");
INSERT INTO mif_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aa cəfɗamara, a ləvmar: «Ma ləvka ŋga kata cek hay a keɗe na, wa? Ma vəlka cəveɗ ŋga kata na, wa?» ");
INSERT INTO mif_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ta’, Yesu a mbəɗdatara, a ləvtar: «Amba yaa cəfɗakwar mey pal. Da akwar ta mbəɗdamiwa mey a la na, ya kadakwara ndaw ma vəldiwa cəveɗ ŋga kata cek hay a keɗe la may. ");
INSERT INTO mif_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yaw, ma slərdərwa *Jaŋ-Baptis ŋga katar *baptem a ndəhay na, wa? Gazlavay daw, da daa ba, ndəhay daw? Mbəɗdamiwa cey!» ");
INSERT INTO mif_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Da ray ŋgene, ndəhay a, a slam yawa da wuzlah ata, a ləvam: «Ya da mbəɗdakwa aa mey aŋga ha na, kwara? Da ya ləvkwa: “Ara Gazlavay ma slərdərwa” na, a da mbəɗdandakwara, a ləvey: “Kaa ka təɓmara mey ŋga Jaŋ-Baptis a ba na, maja me?” ");
INSERT INTO mif_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ama da ya ləvkwa: “Ara ndəhay ma slərdamərwa” na, ndəhay makustakaya da cakay aləkwa fa da təɓmara daa ba.» Yaw, mahura hay a na, fa zluram ta ndəhay, maja ata cəpa a wulkam Jaŋ-Baptis ara *ndaw ma təla mey ŋga Gazlavay fara fara. ");
INSERT INTO mif_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Da ray ŋgene, a mbəɗdamara a Yesu, a ləvmar: «Ya sərmara ba.» Ta’, Yesu a mbəɗdatara, a ləvtar: «Yaw, da anda keɗe na, ya fa da kadakwara ndaw ma vəlya cəveɗ ŋga kata cek hay a keɗe na, daa ba may.» ");
INSERT INTO mif_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Fa dəɓa ha, Yesu a ŋgatar mey, a ləvtar: «Ndaw daha a key jerne ŋga wudez mezəmey. Ta’, a zləɓa jerne he tabiya. A ɗiyey slam ŋga ɗəcey babəza ŋga wudez e. A ləmey way magəlkaya maazəma ŋgada ndaw ma jəɗa jerne he. Fa dəɓa ha, a həley ndəhay aa jerne aŋga ha ŋga key sləra da hwaɗ a. Ta’, a daw aa slam dəreŋ. ");
INSERT INTO mif_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Masa kiya meŋgəley babəza ŋga wudez e ta wuswa cay na, a slərey gula aŋga pal da wuzlah madərlam aŋga hay aa jerne he amba a təɓra babəza maala ŋga aŋga. ");
INSERT INTO mif_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ama ndəhay ma ka sləra daa jerne he a kərzamara madərlam a, a sləɗmara, a ɓəlmara a way, ta har ɓa’ kəne. ");
INSERT INTO mif_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ta’, bay ŋga jerne he, a slərey madərlam aŋga mekele fa ata. Ndəhay a, ta’, a slənmar ray, a cəɗmara. Ta’, a ɓəlmara. ");
INSERT INTO mif_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Fa dəɓa ha, bay ŋga jerne he, a slərey madərlam aŋga mekele saya. Ndəhay a, a kəɗmara vagay. Anda keɗe, a slərey madərlam aŋga hay mekele mekele, ama ndəhay a, a sləɗmata siya hay, asaya, a kəɗmata siya hay vagay. ");
INSERT INTO mif_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ndaw pal mambəkakaya ŋga slərey na, ara bəzey aŋga mawuɗkaya kalah. A slərey ŋga madagway-dakw na, bəzey aŋga ha. A wulkey daa ray aŋga, a ləvey: “Fara fara a namar ray la a bəzey aɗaw.” ");
INSERT INTO mif_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ama, masa bəzey a fa daw gweegwe ta jerne he na, ndəhay ma ka sləra ha a hətmar, aa guzlam da wuzlah ata, a ləvam: “Ehe, ndaw ma sawa katay na, ara bəzey ma da wa jerne he. Nakwa, kəɗkwa vagay, amba jerne he a njey ŋgada aləkwa.” ");
INSERT INTO mif_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Da ray ŋgene, a diyam, kaw! a kərzamara bəzey a, a kəɗmara vagay, ɓa! a kəzlamara vagay a, a dəɓa jerne he.» ");
INSERT INTO mif_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu aa cəfɗata, a ləvey: «Akwar na, ka wulkam bay ŋga jerne he, a da key na, kwara? Ehe, ya fa ləvkwar, bay ŋga jerne he, a sawa la, a kəɗta ndəhay ma ka sləra ha la vagay, a vəlda jerne he la, a har ndəhay mekele. ");
INSERT INTO mif_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Akwar ta jaŋgamara mey ŋga Gazlavay la, ba diya? Mey masa ma ləvey: “Aŋgwa meləmey way masa ndəhay ma ləma way ma kəzlamara ta cakay na, aŋgwa ha na, ta tərey sem ŋga aŋgwa maaya meləmey way ma fənta siya hay jak. ");
INSERT INTO mif_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ŋgene na, ara Bay Gazlavay ma ka cek aha, ara cek maaya fa dey aləkwa.”» ");
INSERT INTO mif_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mahura hay ŋga *Jəwif hay a heyey a səpam cəveɗ ŋga kərzamara Yesu, maja a sərmara Yesu aa guzley mey-meŋgey na, da ray ata. Ama ata fa zluram ta ndəhay feteɗe. Da ray ŋgene, mahura hay a, a mbəkdamara, ta’, a diyam. ");
INSERT INTO mif_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Fa dəɓa ha, mahura ŋga *Jəwif hay a sləram *Fariza hay ta ndəhay ŋga Bay *Herawt fa Yesu. A wuɗam a jadamara amba aa guzley mey maaya ba. ");
INSERT INTO mif_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","A diyam, a ləvmar: «Bay ala, ya sərmara kah na, ndaw ma mbərzley ba. Masa kah faa guzley na, ka zlurey ta ndaw ba, asaya, ka nəkta ndəhay cəpa letek fa mey akah. Ka faa sərkadata ndəhay ŋga njam anda Gazlavay ma wuɗey fara fara. Yaw, kwakwas aləkwa a vəley cəveɗ ŋga pəley budaw a bay mahura *Sezere daw? Maaya na, ya pəlmara budaw a daw, ya pəlmara ba daw?» ");
INSERT INTO mif_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ama Yesu a səra, ndəhay a, aa guzlam ta neneh cew. Ta’, a ləvtar: «Ka wuɗam ŋga jadamaya na, maja me? Lamaya dala ha pal amba ya nəka.» ");
INSERT INTO mif_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ta’, a lamar dala ha. Yesu aa cəfɗata, a ləvtar: «Fa dala ha keɗe na, ara dey ŋga wa? Ara mezəley ŋga wa?» A mbəɗdamara, a ləvmar: «Ara ŋga Sezere, bay mahura ŋga Rawm.» ");
INSERT INTO mif_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ta’, Yesu a ləvtar: «Cek masa ŋga Sezere na, vəldamara a Sezere he. Cek masa ŋga Gazlavay na, vəldamara a Gazlavay a.» Anda keɗe, ndəhay a, a rəzlam ga da ray mey ŋga Yesu a. ");
INSERT INTO mif_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ndəhay *Saduse hay na, ara ndəhay ma wulkam, ma ləvam da ndaw ta məcey sem na, fa da sləkɗawa daa meməcey daa ba. Ndəhay da wuzlah Saduse hay a, a diyam fa Yesu, aa cəfɗamara, a ləvmar: ");
INSERT INTO mif_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Bay ala, zleezle *Mawiz ta wuzlalandakwar kwakwas la, a ləvey: “Da ndaw məlmaha ta məcey sem na, da ŋgwas ŋga ndaw ma məcey a, ta yawa bəza hay daa ba na, si məlmaha a la ŋgwas-vagay a, amba a yamawa bəza hay ŋgada məlmaha maməckaya ha.” ");
INSERT INTO mif_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yaw, məlmaŋ hay maasala daha, ata ŋgaa maŋ, ŋgaa paŋ. Məlma ata mahura, leŋ! a ley ŋgwas. Fa dəɓa ha, ndaw aha pam! a məcey ta hətey bəzey daa ba. ");
INSERT INTO mif_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Da ray ŋgene, mambaray a, leŋ! a la ŋgwas-vagay a, aŋga pam! a məcey saya ta hətey bəzey daa ba may. Fa dəɓa ha, məlma ata mamaakar a, a la ŋgwas-vagay a, ama pam! a məcey ta hətey bəzey ta ŋgwas aha daa ba cəŋga. ");
INSERT INTO mif_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Anda keɗe, ata maasala ata cəpa, ta lamara ŋgwas aha la, ta məcam sem cəpa, ta mbəkam bəza hay daa ba. Fa dəɓa ha ata ma məcam la cəpa ata na, ŋgwas aha pam! a məcey may. ");
INSERT INTO mif_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Anda keɗe, ta pas masləkɗawa ŋga ndəhay daa meməcey na, ŋgwas aha, a da key na, ŋgwas ŋga wa? Maja ata maasala ata cəpa ta lamara la ŋga ŋgwas ata.» ");
INSERT INTO mif_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu a mbəɗdatara, a ləvtar: «Akwar faa zəɗdamara ray akwar anda keɗe na, maja me? Ara maja ka sərmara mey ŋga Gazlavay ba ta maja ka sərmara gədaŋ aŋga ba. ");
INSERT INTO mif_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yaw, daa masləkɗawa ŋga ndəhay daa meməcey na, zel hay fa da lam ŋgusay daa saba, ŋgusay fa da njam ta zel hay daa saba, ama a da njam anda maslaŋ hay ŋga Gazlavay da vaɗ. ");
INSERT INTO mif_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ya wuɗey yaa sərkadakwar da ray masləkɗawa ŋga ndəhay daa meməcey. Ka ta jaŋgamara daa ɗerewel masa Mawiz ma wuzlala la, ba diya? Ɗerewel e na, aa guzley da ray kusaf masa awaw megəɗey da ray a. Feteɗe na, Gazlavay a ləvar a Mawiz: “Yah, Gazlavay masa *Abəraham, *Izak, leŋ *Jakwap ma namar ray.”» ");
INSERT INTO mif_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yesu aa guzley saya, a ləvey: «Gazlavay na, ara Gazlavay ŋga ndəhay ta dey, ba na, ara Gazlavay ŋga ndəhay maməctakaya ba. Akwar Saduse hay, ka ta zləɓmara mey a sem kalah!» ");
INSERT INTO mif_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Masa ndəhay *Saduse hay heyey fa kam yawa ta Yesu na, ndaw da wuzlah *ndəhay maa sərkada kwakwas ŋga Mawiz daha, a wusey a cakay ata, a cənda yawa ata ha. A nəka na, Yesu ta mbəɗdatara mey a maaya maaya la. Da ray ŋgene, aa cəfɗa Yesu, a ləvar: «*Mewey mahura ma fənta siya hay na, wura?» ");
INSERT INTO mif_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Yesu a mbəɗdara, a ləvar: «Mewey mahura ma fənta siya hay a na, ara mey ma ləvey: “Jəkam sləmay, akwar ndəhay *Israyel hay, Bay Gazlavay masa aləkwa ma nakwar ray na, aŋga pal, Bay aləkwa mahura. Wuɗmara Gazlavay, Bay akwar, ta mevel akwar cəpa, ta mesəfney akwar cəpa, ta leŋgesl akwar cəpa, ta gədaŋ akwar cəpa.” Mewey masa mahura na, ara mey keɗe. ");
INSERT INTO mif_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yaw, *mewey mahura ŋga dey cew e daha saya, mewey a, a ləvey: “Wuɗa meseembew akah anda kah ma wuɗa ray akah.” Mewey hay masa ma fənmata cew hay keɗe na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ndaw maa sərkada kwakwas heyey a ləvar: «Mey akah maaya, Bay aɗaw! Mey masa kah maa guzlda keɗe na, ara mey fara fara. Gazlavay, aŋga pal taava aŋga, Gazlavay mekele daa ba. ");
INSERT INTO mif_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Si ndaw a wuɗa Gazlavay ta mevel aŋga cəpa, ta leŋgesl aŋga cəpa, ta gədaŋ aŋga cəpa. Asaya, si a wuɗa meseembew aŋga anda aŋga ma wuɗa ray aŋga. Ndaw ma səpta mewey hay a keɗe na, a mbafar a Gazlavay a fəna mevəley cek hay ta mehərey cek hay ŋgada aŋga.» ");
INSERT INTO mif_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Masa Yesu ma nəka ndaw aha ta mbəɗdara mey a la ta leŋgesl maaya na, ta’, a ləvar: «Mewulkey akah ŋgene maaya, gweegwe ka təɓa amba Gazlavay a wey da ray akah.» Fa dəɓa ha, kwa waawa ta gəmey ŋgaa cəfɗey mey fa Yesu a daa saba, maja a zluram fa mey aŋga masa aŋga ma da mbəɗdatara. ");
INSERT INTO mif_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Masa Yesu faa sərkadata ndəhay daa *Way-mekey-kwakwas ŋga Gazlavay na, ta’, aa cəfɗata, a ləvey: «*Ndəhay maa sərkada kwakwas ŋga Mawiz a ləvam *Kəriste *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay na, ara bəzey da hwaɗ Bay *Davit na, kwara? ");
INSERT INTO mif_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ta fa gədaŋ ŋga *Mesəfney ŋga Gazlavay na, Davit ta ləvey la: “Bay Gazlavay a ləvar a Bay aɗaw Mahura: Sawa, njey ta har-zəmay aɗaw amba ya wakwa da ray ndəhay haa ta pas masa yah ma da pata masa-gəra akah hay asi salay akah.” ");
INSERT INTO mif_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davit ta ray aŋga, a zəla Kəriste “Bay Mahura” na, kaa wara Kəriste he ara bəzey da hwaɗ Davit saya na, kwara?» Ndəhay ga fa jəkam sləmay fa meesərkey ŋga Yesu ta meesəmey. ");
INSERT INTO mif_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Daa meesərkey a na, Yesu a ləvtar a ndəhay makustakaya ha: «Wam vaw fa *ndəhay maa sərkada kwakwas ŋga Mawiz. A wuɗam mepəkey ta dawura hay fa vaw ŋga zlepey. A wuɗam ndəhay a camatar har ta meney ray fa mey ŋga ndəhay tabiya. ");
INSERT INTO mif_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Daa *way-mewuzey-mey ŋga Gazlavay na, a səpam slam-menjey fa mey ŋga ndəhay amba ndəhay tabiya a hətmatar. Ta pas gwagway na, a səpam slam-menjey maaya. ");
INSERT INTO mif_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Asaya, fa təɓmatara cek hay ŋga ŋgwas-vagay hay tabiya. A njam daa medərey-daŋgay ga, aa guzlam ga amba ndəhay a ləvam ata maaya. Ya fa ləvkwar, ata na, Gazlavay a sərdata banay la, ma fəna ŋga ndəhay mekele!» ");
INSERT INTO mif_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ta’, Yesu a daw, a njey a cakay slam mecekeley dala daa *Way-mekey-kwakwas ŋga Gazlavay. Aŋga fa nəkta ndəhay feteɗe ma pamara dala aa cek mecekeley dala. Ndəhay masa-zleley hay fa vəlam dala ga. ");
INSERT INTO mif_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ŋgwas-vagay masa-viya daha, a sawa, a kwiyey sisey sisey cew aa cek aha may. Dala aŋga ha, mekele daa ba. ");
INSERT INTO mif_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Da ray ŋgene, Yesu a zəlta gula aŋga hay, a ləvtar: «Ya fa ləvkwar fara fara, ŋgwas-vagay masa-viya keɗe na, ta pey dala la aa cek mecekeley dala ma fəna ŋga ndəhay cəpa. ");
INSERT INTO mif_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ya ləvkwar anda keɗe na, maja ndəhay siya hay, a vəlam dala nekəɗey daa dey zleley ata hay da way ga. Ama ŋgwas-vagay keɗe, ta mərga aŋga cəpa, a vəlda zleley aŋga tabiya, masa aŋga ma da həɗkey cek mezəmey ta aŋga.» ");
INSERT INTO mif_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Daa masa Yesu fa bawa daa *Way-mekey-kwakwas ŋga Gazlavay na, gula aŋga pal aa cəfɗa, a ləvar: «Bay aɗaw, nəka Way-mekey-kwakwas ŋga Gazlavay keɗe cey! Səkway ŋga way wura, maləmkaya maaya ta aŋgwa ma mbey anda keɗe!» ");
INSERT INTO mif_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu a mbəɗdara, a ləvar: «Ka fa hətar way a maləmkaya maaya masa mahura keɗe, ba diya? Way a cəpa na, a bəzlmara la, kwa aŋgwa pal fa da mbəkey da ray cəla daa ba.» ");
INSERT INTO mif_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Fa dəɓa ha, Yesu a daw aa Aŋgwa ŋga *Awliviye, cəkwam! a njey dey pəla! ŋgada fa *Way-mekey-kwakwas ŋga Gazlavay heyey. Ata *Piyer, *Jak, *Jaŋ, leŋ *Andəre, ata taava ata da cakay Yesu a. Ta’, aa cəfɗamara, a ləvmar: ");
INSERT INTO mif_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Wuzdandara cey, cek aha a da key na, ta vara? Ya da sərmara ɗar a ta wuswa cay na, fa me?» ");
INSERT INTO mif_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ta’, Yesu a kətata, a ləvtar: «Wam vaw fa ndəhay ma da fəcmakwar. ");
INSERT INTO mif_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sərmara, ndəhay ga a samawa la ta mezəley aɗaw, kwa waawa a da ləvey aŋga na, *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay. A təknam ndəhay la ga. ");
INSERT INTO mif_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ta pas masa akwar ma da cənam vəram hay gweegwe ta akwar, asaya, ta pas masa akwar ma da cənam labara ŋga vəram hay masa da dəreŋ na, ka da zluram ba, maja si cek hay a ŋgene, a kam la teeseɗ ɗagay. Ama ara mendəvey ŋga bəla ba araŋ. ");
INSERT INTO mif_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Hwayak laŋgar a da key vəram ta hwayak laŋgar, bay laŋgar a da key həma a ray bay laŋgar. Daa hwayak hay mekele mekele, hwiyak a wusey la. May a key la da bəla. Cek hay a na, a kam la anda hwaɗ ma zlar ŋga car ŋgada ŋgwas ma da yey, anda meləvey, ara mendəvey ŋga bəla ba araŋ, ama ara mezley a.» ");
INSERT INTO mif_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yesu a ləvtar saya: «Ama akwar na, wam vaw! Ndəhay a handamakwar la fa mey ŋga ndəhay ma ka sariya, a sləɗmakwar la daa *way-mewuzey-mey ŋga Gazlavay. A handamakwar la fa mey ŋga ndəhay mahura hay leŋ fa mey ŋga bay hay, maja akwar ndəhay aɗaw hay. Anda keɗe, ka da kam sede da ray aɗaw fa mey ata. ");
INSERT INTO mif_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yaw, ŋgeeme na, si ndəhay ma təɓa mey aɗaw a wuzdamara *Mey-maaya-mawiya da ray aɗaw a ndəhay da bəla cəpa la ɗagay, wara cay bəla a ndəvey. ");
INSERT INTO mif_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pas masa ata ma da kərzamakwar ŋga hendey aa sariya na, ka da zluram da ray mey masa akwar ma daa guzlam ba. Ama, gwaguzlam mey masa Gazlavay ma da vəldakwara ta pas a ŋgene, maja mey a na, a da sawa ta fa akwar ba, ama ta fa *Mesəfney ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ndaw a da vəlda məlmaha amba a kəɗmara vagay. Papaŋ hay a kamara la kəne ŋgada bəza ata hay may. Bəza hay a mbəɗmatar dəɓa la a papa ata hay leŋ a mama ata hay, a vəldamata a ndəhay amba a kəɗmata vagay may. ");
INSERT INTO mif_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ndəhay tabiya a da ŋgəldamakwar ba, maja yah. Ama ndaw ma ɓəsa banay a haa mendəvey a na, Gazlavay a ləhda la.» ");
INSERT INTO mif_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu aa guzley saya, a ləvey: «Da ɗar a ta wuswa cay na, ka hətmar ndaw malamba ma nəsa cek la. Ara ndaw masa Gazlavay ma wuɗey ŋga hətar fa dey ba. Ndaw aha, a da njey na, aa slam aŋga menjey ba. (Akwar masa ma jaŋgamara mey a keɗe na, si ka pam leŋgesl fa mey a.) Ta pas ŋgene, si ndəhay daa hwayak ŋga *Jude a hwam ŋga ɓawa a aŋgwa. ");
INSERT INTO mif_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kwa ndaw masa fa məskey vaw daa ambaw na, fa da mbəzey a way ŋga lawa cek daa ba. ");
INSERT INTO mif_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kwa ndaw aŋga da ley na, fa da vəhwa a way ŋga ley zana daa ba. ");
INSERT INTO mif_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Daa ɗar hay a ŋgene, banay a sawa la a ray ŋgusay ta hwaɗ ta a ray ŋgusay masa ta bəza hay da har. ");
INSERT INTO mif_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dəram daŋgay a Gazlavay, cacəfɗamara amba cek hay a, a wusmawa ta piya ba . ");
INSERT INTO mif_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Daa ɗar hay a ŋgene, banay a sawa la ga a ray ndəhay. Dəga Gazlavay ma ləma bəla haa wure keɗe ndaw ta sərey banay anda ŋgene daa ba araŋ. Asaya, banay fa da sawa ma fəna ŋgene daa saba. ");
INSERT INTO mif_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Da Bay Gazlavay ta ŋgəwa siya ŋga ɗar ŋga banay a daa ba na, anja kwa ndaw pal fa da mbəkey ta dey daa ba. Ama a ŋgəwa siya ŋga ɗar a na, maja ndəhay masa aŋga ma walata ŋgada aŋga. ");
INSERT INTO mif_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Da ray ŋgene, da ndaw a ləvkwar: “*Kəriste, aŋga keɗe”, da daa ba “Nəkmara, aŋga katay” na, ka da təɓmara mey aŋga ba. ");
INSERT INTO mif_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ya ləvkwar anda keɗe na, maja ndəhay ma pamara ray ata ŋga Kəriste, asaya, ndəhay ma pamara ray ata ŋga ndəhay ma təla mey hay ŋga Gazlavay na, a samawa la. A kam maazla hay la ŋga wuzdərwa gədaŋ ata amba a təknam ndəhay. Da a gwamara na, a təknam kwa ndəhay masa Gazlavay ma walata sem ŋga ndəhay aŋga hay may. ");
INSERT INTO mif_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Akwar na, wam vaw, maja ya ta pakwar leŋgesl cay da ray cek hay a cəpa.» ");
INSERT INTO mif_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesu a ləvey saya: «Ama daa ɗar hay a ŋgene, fa dəɓa ŋga mesərey banay ŋga ndəhay na, pas a təɓzley la, kiya fa da weɗey daa saba, ");
INSERT INTO mif_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","wurzla hay a kəzlmawa la da vaɗ a hwayak, cek hay cəpa da gazlavay da vaɗ a wusam la. ");
INSERT INTO mif_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Fa dəɓa ha, ndəhay a da hətmaya, yah, *Bəz ŋga Ndaw, fa sawa daa mekwtene ta gədaŋ mahura leŋ ta meweɗey ŋga Bay Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yaw, Gazlavay a da slərdatərwa maslaŋ aŋga hay amba a diyam aa slam hay tabiya da bəla, a kusmatərwa ndəhay masa aŋga ma walata ŋga ndəhay aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Jəkam sləmay maaya maaya fa mey masa yah ma da wakwara ta gudav. Da masa ka hətmar gudav fa ɗeɗey, gwaslaf a guɗaf! guɗaf! na, ka sərmara kiya madaw a ley gweegwe cay. ");
INSERT INTO mif_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aŋga letek kəne, da ka hətmatar cek hay a fa kam anda yah ma ləvkwar keɗe na, ŋgene sərmara Yah, *Bəz ŋga Ndaw, gweegwe cay ya vəhwa. ");
INSERT INTO mif_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ya fa ləvkwar fara fara, cek hay a keɗe tabiya a da kam na, ndəhay masa wure keɗe ta məcam tabiya daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Slam da vaɗ ta slam da bəla a ndəvey la, ama mey aɗaw na, fa da ndəvey daa ba səlak. ");
INSERT INTO mif_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Fara fara, cek hay keɗe tabiya a da kam na, ndaw ma səra kwa ɗar a, kwa ler e, daa ba. Kwa maslaŋ hay ma njam da cakay Bay Gazlavay da vaɗ a sərmara ba, kwa Yah, Bəzey aŋga, ya səra ba, ama si Papay, pal taava aŋga, ma səra ɗar a. ");
INSERT INTO mif_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Wam vaw! Ka da nam ba, maja ka sərmara ɗar a, a da wuswa ta vara ba. ");
INSERT INTO mif_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ya da vəhwa a bəla na, anda ndaw ma daw a məlak. Ndaw aha, a da mbəkda way aŋga na, a mbəɗtar mey a ma ka sləra aŋga hay, a vəltar sləra pal pal. A ləvar a ndaw ma jəɗa mey-slam ŋga way a: “Njey ta dey, ka da ney ba.” ");
INSERT INTO mif_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","«Yaw, anda keɗe, wam vaw, ka da nam ba, maja ka sərmara ɗar masa bay ŋga way ma da vəhwa ba. Da taa kwaɗ, da ta wuzlah-tavaɗ, da gwagwalak fa cey ɗay, da taa pərek na, ka sərmara ba. ");
INSERT INTO mif_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Da ya vəhwa dərfafay na, ya wuɗey ya hətfakwar daa ɗar ba. ");
INSERT INTO mif_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mey masa yah ma ləvkwar keɗe na, ara ŋgada ndəhay tabiya: Ka da nam ba.» ");
INSERT INTO mif_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ma lawa ɗar cew ŋga wusey fa gwagway ŋga *Pak ta *gwagway ŋga peŋ manjar cek ma həsla da hwaɗ a. *Bay-ray hay ŋga ndəhay ma ka kwakwas ta *ndəhay maa sərkada kwakwas ŋga Mawiz a səpam cəveɗ ŋga kərzey Yesu ta mayal a, amba a kəɗmara vagay. ");
INSERT INTO mif_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","A da kərzamara ta mayal a na, maja mahura hay a, a ləvam: «Ya gwakwa ŋga kərzakwa daa gwagway keɗe ba, maja ndəhay a da yam mey.» ");
INSERT INTO mif_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu aa da Betani, fa zəmey ɗaf da way *Simaŋw, ndaw masa aa ma mbəlda daa maasəkula heyey. Masa aŋga fa zəmey ɗaf na, ŋgwas daha, a mbəzey fa ata ta kwalaba da har, kwalaba ha ŋga aŋgwa maavərkwakaya mezəley «*albaatəra». Kwalaba ha na, marəhkaya ta ɓərdey mezey maaya masa ma həɗkey ba, mezəley «*nar». A wura mey ŋga kwalaba ha, a mbəɗda ɓərdey a, fa ray ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ndəhay mekele feteɗe a cam mevel a ray ŋgwas aha. Aa guzlam da wuzlah ata, a ləvam: «A nəsa ɓərdey a keɗe na, maja me? ");
INSERT INTO mif_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Anja a həɗkada na, a gwa ŋga hətey dala ga, həma dala ŋga ndaw ma key sləra ŋga mevey pal, ba daw? Da ray membəɗey ɓərdey a, a ray ndaw na, ŋgama a wunkatara dala ha a masa-viya hay, ba daw?» A mbəɗmar ray ga ŋgada ŋgwas aha. ");
INSERT INTO mif_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ama Yesu a ləvtar: «Mbəkdamara! Ka mbəɗmar ray na, maja me? Cek masa aa ma ka ŋgada yah keɗe na, ara cek maaya. ");
INSERT INTO mif_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Masa-viya hay na, akwar mandaw mandaw bama. Ta pas wura wura masa akwar ma wuɗam na, ka gwamara ŋga jənmata. Ama yah na, akwar fa da hətmaya ŋga njey ta akwar mandaw mandaw daa ba. ");
INSERT INTO mif_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ŋgwas aha ta key cek masa aa ma gwa ŋga ka la. Kwa ya ta məcey daa ba araŋ kaa na, ta mbəɗda ɓərdey cay fa ray aɗaw ŋga ɗiya vaw aɗaw ŋgadaa cəvay. ");
INSERT INTO mif_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ya fa ləvkwar fara fara, kwa daa wura daa wura da bəla tabiya na, ndəhay ma da wuzdamara *Mey-maaya-mawiya ŋga Gazlavay, a kadamara cek masa ŋgwas aha ma ka keɗe la may, amba ndəhay a sərfadamara ŋgwas aha.» ");
INSERT INTO mif_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Juda Iskariyawt, gula pal da wuzlah *gula hay ŋga Yesu kuraw a ray a cew, a daw fa *bay-ray hay ŋga ndəhay ma ka kwakwas. A ləvtar a wuɗey ŋga vəldatara Yesu a har ata. ");
INSERT INTO mif_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ata ma cəndamara mey a keɗe la na, aa səmam ga. A ləvmar da ta vəldatara Yesu la na, a vəlmar dala. Anda keɗe, Juda ha, a daw a səpey cəveɗ amba a vəldatara Yesu. ");
INSERT INTO mif_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ara ɗar ŋgeeme ŋga *gwagway ŋga peŋ manjar cek ma həsla da hwaɗ a. Ta pas a ŋgene, *Jəwif hay a həram bəz-təɓaŋ hay ŋga gwagway ŋga *Pak. Gula hay ŋga Yesu a diyam fa vəɗa, a ləvmar: «Ka wuɗey ya diyam, ya ɗiymərwa slam amba ya zəmkwa ɗaf ŋga gwagway ŋga Pak na, dama?» ");
INSERT INTO mif_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Da ray ŋgene, Yesu a zəley gula aŋga hay cew, a slərdata, a ləvtar: «Diyam aa berney ŋga *Jeruzelem. Feteɗe na, ka da cam ray ta ndaw fa daw ta yam daa kwakulam. Diyam asiya. ");
INSERT INTO mif_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aa way masa aa ma da mbəzey na, ləvmar a bay ŋga way a: “Bay ala a ləvey: Way mapakaya ŋgada yah amba ya zəmam ɗaf ŋga gwagway ŋga Pak ta gula aɗaw hay na, aa daa wura?” ");
INSERT INTO mif_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Fa dəɓa ha, a wuzkwar way mahura da ray way la. Way a maɗiykaya maaya maaya, cek hay cəpa ŋga gwagway da hwaɗ a daha. Ka da ɗiymandakwara cek mezəmey amba ya zəmkwa ɗaf ŋga gwagway a feteɗe.» ");
INSERT INTO mif_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Gula aŋga hay cew heyey, a mbəkdamata, a diyam aa berney a. Feteɗe, a hətfamatar cek hay tabiya anda Yesu ma ləvtar heyey. Ta’, a ɗiymata cek hay ŋga gwagway ŋga Pak a. ");
INSERT INTO mif_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Taa kwaɗ a ŋgene na, Yesu a wusam ta gula aŋga hay kuraw a ray a cew aa slam mezəmey ɗaf ŋga gwagway a. ");
INSERT INTO mif_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Masa ata fa zəmamara ɗaf a na, Yesu aa guzltar, a ləvey: «Ya fa ləvkwar fara fara, ndaw pal da wuzlah akwar, masa fa zəmey ɗaf ta yah wure keɗe, a vəldaya la a har ndəhay ŋga kəɗmaya vagay.» ");
INSERT INTO mif_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mey a keɗe a məctar vaw a gula aŋga hay a, aa cəfɗamara Yesu pal pal, a ləvam: «Ara yah ma da vəldaka ba, ba diya?» ");
INSERT INTO mif_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu a mbəɗdatara, a ləvtar: «Ara ndaw pal da wuzlah akwar, gula aɗaw hay kuraw a ray a cew. Ara ndaw masa aləkwa fa zəmkwa ɗaf bama daa slam a keɗe. ");
INSERT INTO mif_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Fara fara, si yah, *Bəz ŋga Ndaw, ya məcey anda mey mawuzlalakaya daa ɗerewel ŋga Gazlavay ma ləvey. Ama banay a sawa la a ray ndaw ma da vəldaya a har ndəhay ŋga kəɗmaya vagay a. Ŋgada ndaw aha na, ŋgama ta yamərwa daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Masa ata fa zəmam ɗaf ŋga gwagway a na, Yesu leŋ! a ley peŋ. A kar suse a Gazlavay, a wunka, ta’, a vəldatara a gula aŋga hay, a ləvtar: «Ehe, təɓmara. Keɗe he, ara vaw aɗaw.» ");
INSERT INTO mif_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Fa dəɓa ha, leŋ! a ley vəley ta cek mesey da hwaɗ a, a kar suse a Gazlavay saya, ta’, a vəldatara a gula aŋga hay. Gula aŋga hay cəpa ta’, a samara. ");
INSERT INTO mif_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu a ləvtar: «Keɗe na, ara mambaz aɗaw. Mambaz a, a da mbəɗwa maja ndəhay ga. Ta fa mambaz a, Gazlavay a jəwey mey mawiya ta ndəhay aŋga hay. ");
INSERT INTO mif_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ya fa ləvkwar fara fara, kwa ya fa da sey yam ŋga babəza ŋga wudez maɗəckaya daa saba səlak. Ya da sey na, si cek mawiya mekele daa slam masa Gazlavay fa wey da ray ndəhay da vaɗ.» ");
INSERT INTO mif_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ta’, a zlam walay ŋga gwagway daa *Pəsam hay. Fa dəɓa ha, a sləkɗam, a diyam aa Aŋgwa ŋga *Awliviye. ");
INSERT INTO mif_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu a ləvtar a gula aŋga hay: «Akwar cəpa ka da mbəkdamaya daa masa fa da kərzamaya ŋga kəɗey vagay anda mawuzlalakaya daa ɗerewel ŋga Gazlavay ma ləvey: “Ya kəɗa ndaw-mecəkwer la vagay. Təɓaŋ aŋga hay a kwakwacam ray la pal pal.” ");
INSERT INTO mif_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ama da yah ta sləkɗawa cay daa meməcey na, ya daw la teeseɗ da ray akwar aa hwayak ŋga *Galile. Ka da hətfamaya feteɗe.» ");
INSERT INTO mif_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","*Piyer a ləvar: «Kwa ndəhay cəpa a mbəkdamaka, ama yah na, ya fa da mbəkdaka daa ba.» ");
INSERT INTO mif_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu a mbəɗdara, a ləvar: «Ya fa ləvka fara fara, dasi tavaɗ keɗe, wuskwaa gwagwalak a da cey ɗay ŋga dey cew na, ka ta ləvey cay dey maakar, ka sərya ba, ka sərya ba.» ");
INSERT INTO mif_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ama Piyer a mbəɗdara ta gədaŋ, a ləvar: «Kay! Kwa da fa da kəɗmaka vagay na, ŋga kəɗmandakwar cew e, ya fa da ləvey ya sərka ba na, daa ba səlak.» Gula hay ŋga Yesu siya a ləvam kəne may. ");
INSERT INTO mif_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ata Yesu ta gula aŋga hay a wusam aa slam daha mezəley Gecemene. A ləvtar: «Njam feɗe, yah na, ya daw la ŋga dərwa daŋgay a Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ta’, a ŋgəlta ata *Piyer, *Jak, leŋ *Jaŋ, a diyam bama. Daa ŋgene, mandərzay a kar a Yesu, mevel aŋga a təɗey, maja banay ma da sawa a ray a. ");
INSERT INTO mif_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ta’, a ləvtar a gula aŋga hay maakar heyey: «Mewulkey fa da kəɗya vagay. Njam feɗe, ka da nam ba.» ");
INSERT INTO mif_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ta’, Yesu a ŋgəchey nekəɗey fa mey, a regedey a hwayak, a dərey daŋgay a Gazlavay. Aa cəfɗa Gazlavay amba da Gazlavay a təɓa na, banay masa aŋga ma da səra na, a wusfar ba. ");
INSERT INTO mif_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A ləvey: «Papay, Papay, cek hay cəpa ka gwa ŋga kata. Ləhdaya daa banay a keɗe. Ta kəne he cəpa na, key anda kah ma wuɗey, ba na, anda yah ma wuɗey ba.» ");
INSERT INTO mif_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ta’, a vəhwa fa gula aŋga hay maakar heyey, a hətfatar manatakaya daa ɗar. A ləvar a *Simaŋw Piyer: «Simaŋw, ka fa ney daw? Ka ta gwa ŋga zezəkey nekəɗey, kwa ler pal daa ba gway daw? ");
INSERT INTO mif_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Zazəkam, ka da nam ba, dəram daŋgay a Gazlavay ŋga jənkwar amba cek a batakwar ŋga key mebərey ba. Mevel akwar a wuɗey ŋga key cek maaya, ama vaw akwar na, aŋga ta bəle.» ");
INSERT INTO mif_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ta’, Yesu a ŋgəchey saya, a dərey daŋgay a Gazlavay anda ŋgeeme heyey saya. ");
INSERT INTO mif_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Fa dəɓa ha, a vəhwa fa gula aŋga hay maakar heyey saya, a hətfatar manatakaya cəŋga maja ɗar fa latar mey kalah. Masa Yesu ma hətfatar manatakaya na, a sləkɗam, a sərmara ata ma daa guzlmar ŋgada Yesu ba. ");
INSERT INTO mif_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ta’, Yesu a mbəkdata, a daw ŋga dərey daŋgay a Gazlavay ŋga dey maakar. Cay, a vəhwa fa gula aŋga hay heyey, a ləvtar: «Haa wure keɗe akwar fa nam, fa məskam vaw cəŋga daw? Cay dəɓa. Pas a ta wuswa cay, amba a vəldamaya, yah, *Bəz ŋga Ndaw, a har ndəhay ta mebərey. ");
INSERT INTO mif_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lacam! Nəkmara, ndaw ma da vəldaya a har ndəhay ŋga kəɗey vagay fa sawa katay. Nakwa la, ta cadakwa ray.» ");
INSERT INTO mif_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Masa Yesu faa guzley na, wure ŋgene, Juda, ndaw pal dasi gula aŋga hay kuraw a ray a cew heyey, fa sawa fa vəɗa. Juda ha a samawa na, ta ndəhay ga ta dəlaw hay da cakay, ta zlanday hay da har. Ma slərdamatərwa ndəhay a na, ara bay-ray hay da ray ndəhay ma ka kwakwas, ta ndəhay maa sərkada kwakwas ŋga Mawiz, leŋ mahura hay ŋga Jəwif hay. ");
INSERT INTO mif_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Juda, ndaw masa ma da vəlda Yesu a har ndəhay, ta wuswa fa Yesu daa ba araŋ na, aa guzltar a ndəhay a, a ləvtar: «Ndaw masa yah ma da car har anda mandala aɗaw fara fara na, ara aŋga. Kərzamara, handamara, jəɗmara maaya maaya.» ");
INSERT INTO mif_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Masa Juda ma wusey cay gweegwe a cakay Yesu na, a ŋgəchey fa vəɗa, a ləvar: «Bay aɗaw!» Ta’, a car har anda aa ma ləvey heyey. ");
INSERT INTO mif_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ndəhay ma samawa ta ata Juda heyey, ta’, a kərzamara Yesu. ");
INSERT INTO mif_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ama ndaw pal da wuzlah gula aŋga hay feteɗe, a məɗərwa dəlaw aŋga, a ŋgəma, cərah! a cərha sləmay ŋga madərlam ŋga ndaw mahura da ray ndəhay ma ka kwakwas. ");
INSERT INTO mif_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ta’, Yesu a ləvtar: «Ka samawa ŋga kərzamaya ta dəlaw, ta zlanday faa har faa har anda yah ndaw-mayal na, maja me? ");
INSERT INTO mif_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mandaw mandaw yah da wuzlah akwar, ya faa sərkadata ndəhay daa *Way-mekey-kwakwas ŋga Gazlavay, ama ka ta kərzamaya daa ba. Cek hay a, a da kam wure keɗe na, amba a key anda ɗerewel ŋga Gazlavay zleezle ma ləvey da ray cek ma da key da ray aɗaw.» ");
INSERT INTO mif_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Fa dəɓa ha, gula aŋga hay cəpa a zluram, a mbəkdamara Yesu, a hwam. ");
INSERT INTO mif_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bəz-gula daha fa səpar wurzay ŋga Yesu. Aŋga feteɗe ta gwedeere masləlhakaya fa vaw. Ndəhay ma kərzamara Yesu heyey, a kərzamara bəz-gula ha may. ");
INSERT INTO mif_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ama, ta’, a pərsley da har ata, a mbəkda gwedeere aŋga, a hway vaw ɓa’ kəne. ");
INSERT INTO mif_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ndəhay ma kərzamara Yesu heyey, a handamara a way *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay. *Bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, ta mahura hay ŋga *Jəwif hay, leŋ *ndəhay maa sərkada kwakwas ŋga Mawiz ata makustakaya feteɗe. ");
INSERT INTO mif_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","*Piyer na, fa səpa Yesu ta meedəreŋ e. A mbəzey a palah-way ŋga ndaw mahura da ray ndəhay ma ka kwakwas heyey. Feteɗe, a njam ta ndəhay ma jəɗa way a, aŋga fa sətey awaw. ");
INSERT INTO mif_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta ndəhay mahura hay mekele masa ma sla yawa ŋga Jəwif hay tabiya, ata na, a səpam cek malamba masa Yesu ma ka amba a kamar sariya, a kəɗmara vagay. Ama ta hətam daa ba. ");
INSERT INTO mif_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ndəhay ga a samawa ŋga mbərzley a ray Yesu. Ama ata na, taa guzlam mey letek daa ba. ");
INSERT INTO mif_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Da ray ŋgene, ndəhay mekele da wuzlah ata, a sləkɗam ta meyey-mey, a mbərzlam, a ləvam: ");
INSERT INTO mif_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Ya cəndamara ndaw aha a ləvey: “Ya bəzla *Way-mekey-kwakwas ŋga Gazlavay masa ndəhay ma ləmamara keɗe la, ya ləma la mekele ɗar maakar masa kwa har ŋga ndaw fa da gəsfar ŋga ləmey way a daa ba.”» ");
INSERT INTO mif_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ama kwa ta membərzley ata ha keɗe na, aa guzlam mey wal wal cəŋga. ");
INSERT INTO mif_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Da ray ŋgene, ndaw mahura da ray ndəhay ma ka kwakwas heyey a lecey fa mey ŋga ndəhay cəpa, ta’, aa cəfɗa Yesu, a ləvar: «Ka mbəɗdatara a ndəhay maa guzlam da ray akah keɗe ba gway daw?» ");
INSERT INTO mif_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ama Yesu manjakaya teete, kwa ta mbəɗdatara daa ba. Da ray ŋgene, ndaw mahura heyey aa cəfɗa Yesu saya, a ləvar: «Kah na, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay heyey daw? Gazlavay masa ala ma həlmamara na, kah na, Bəzey aŋga daw?» ");
INSERT INTO mif_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu a mbəɗdara, a ləvar: «Ahaw, ara yah. Akwar, ka da hətmaya, yah, *Bəz ŋga Ndaw, manjakaya ta har-zəmay ŋga Bay Gazlavay Mawaca-waca. Asaya, ka hətmaya la, ya fa sawa daa mekwtene da vaɗ.» ");
INSERT INTO mif_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Maja ŋgene, ndaw mahura heyey, ŋgar! ŋgar! a ŋgərta zana aŋga hay. Mevel a car ga maja Yesu ma ləvar a sawa ta fa Bay Gazlavay. Ta’, ndaw mahura ha, a ləvtar a ndəhay ma sla yawa makustakaya heyey: «Wure keɗe, kwa ya səpkwa ndaw ŋgaa guzlndakwar da ray a saba. Ta pa ray aŋga sem ŋga Gazlavay, akwar ta cəndamara la, ba diya? Wure keɗe ka wulkam da ray a na, kwara?» Ndəhay cəpa a ləvam aŋga ta mebərey, si mekəɗey aŋga vagay. ");
INSERT INTO mif_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ndəhay siya da wuzlah ata a cəram meesleɓ a ray Yesu a. A ɗəpmara dey aŋga ta zana, a dəvmar mekəɗey, a ləvmar: «Səra ma kəɗka keɗe na, wa? Wuzdandara cey!» Fa dəɓa ha, ta’, a vəldamara a har ndəhay ma jəɗmara heyey, ndəhay ma jəɗmara ha a vəlmar matapa-har. ");
INSERT INTO mif_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","*Piyer, aŋga da palah-way ŋga ndaw mahura ma ka sariya heyey, saɓara dasi dəmay ma ka sləra da way ndaw mahura ha, a sawa, ");
INSERT INTO mif_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","a hətar Piyer fa sətey awaw. A saŋgala Piyer heyey, a ləvar: «Kah may, gula ŋga Yesu, ndaw *Nezeret keɗe, ba diya?» ");
INSERT INTO mif_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ama Piyer a cada mey, a ləvey: «Kay! Ya səra cek masa kah ma wuɗey ŋgaa guzley ba!» A daw fa mey-slam ŋga way heyey. Ta’, gwagwalak a cey ɗay. ");
INSERT INTO mif_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ta’, saɓara heyey, a hətar Piyer saya, a ləvtar a ndəhay makustakaya feteɗe: «Ndaw keɗe aŋga da wuzlah ndəhay ŋga Yesu a!» ");
INSERT INTO mif_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ama Piyer a cada mey saya. Menjey nekəɗey, ndəhay feteɗe heyey a ləvmar a Piyer saya: «Fara fara, kah ndaw da wuzlah ndəhay ŋga Yesu, maja kah na, ndaw *Galile.» ");
INSERT INTO mif_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Da ray ŋgene, Piyer ta’, a ləvtar: «Ya fa mbeɗey, fara fara, ya səra ndaw masa akwar maa guzlam da ray a keɗe ba səlak! Da ya mbərzley na, Gazlavay ŋga mbəɗya ray!» ");
INSERT INTO mif_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wure wure ŋgene, gwagwalak a cey ɗay ŋga dey cew. Piyer a sərfada mey masa Yesu ma ləvar zleezle heyey: «Wuskwaa gwagwalak a da cey ɗay ŋga dey cew na, ka ta ləvey cay dey maakar, ka sərya ba, ka sərya ba.» Masa Piyer ma sərfada mey a la na, pat! a bawa ta matəway. ");
INSERT INTO mif_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pərek pərek, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, mahura hay ŋga *Jəwif hay, *ndəhay maa sərkada kwakwas ŋga Mawiz, leŋ ndəhay mahura hay mekele ma sla yawa ŋga Jəwif hay, a kusam amba a slam yawa da ray Yesu. Fa dəɓa ha, a jəwmara Yesu, a handamara fa Pilat, bay feteɗe. ");
INSERT INTO mif_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bay Pilat a, aa cəfɗa Yesu, a ləvar: «Kah na, bay ŋga Jəwif hay fara daw?» Yesu a mbəɗdara, a ləvar: «Anda kah ma ləvey.» ");
INSERT INTO mif_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","*Bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay heyey a dadəɗfamar mey hay mekele mekele a ray Yesu. ");
INSERT INTO mif_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Da ray ŋgene, Pilat aa cəfɗa saya, a ləvar: «Ka mbəɗdatara a ndəhay maa guzlam da ray kah keɗe ba gway daw? Ka fa cənda mey hay cəpa masa ata maa guzldamara da ray akah keɗe, ba diya?» ");
INSERT INTO mif_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ama Yesu a mbəɗdara ba səlak. Anda keɗe, Pilat a rəzley ga maja. ");
INSERT INTO mif_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Fa mevey a, fa mevey a, ta gwagway ŋga *Pak na, Bay Pilat fa pəskey ndaw pal daa fərsəne. A pəskey na, ndaw masa ndəhay makustakaya maa cəfɗafamara. ");
INSERT INTO mif_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yaw, ndaw daha mezəley Barabas. Aŋga daa fərsəne maja aŋga da wuzlah ndəhay masa ma namatar ray a ndəhay ma wa hwayak ba. Daa mekəɗey-vaw daha na, ata Barabas a ta kəɗam ndaw la vagay. ");
INSERT INTO mif_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ndəhay makustakaya ha a diyam aa ambaw Bay Pilat, ŋgaa cəfɗamərwa amba a pəskatar ndaw pal daa fərsəne anda aŋga ma katara fa mevey a, fa mevey a. ");
INSERT INTO mif_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat a mbəɗdatara, a ləvtar: «Ka wuɗam na, ya pəskakwar bay ŋga *Jəwif hay daw?» ");
INSERT INTO mif_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","A ləvey anda keɗe na, maja a səra *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay heyey a handamərwa Yesu na, maja səleŋ fa katar da ray a. ");
INSERT INTO mif_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ama bay-ray hay a, a həldamata ndəhay makustakaya heyey ŋgaa cəfɗamara Bay Pilat amba a pəskatara Barabas jak. ");
INSERT INTO mif_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat aa cəfɗata saya, a ləvtar: «Ndaw masa akwar ma zəlmara “Bay ŋga Jəwif hay” na, ka wuɗam ya kada na, kwara?» ");
INSERT INTO mif_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A wudam ta gədaŋ, a ləvmar: «Dəra fa hwadam mazlaŋgalakaya! Dəra fa hwadam mazlaŋgalakaya!» ");
INSERT INTO mif_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat aa cəfɗata, a ləvtar: «Cek maaya ba masa aŋga ma key na, wura?» Ama a wudam ta gədaŋ ta gədaŋ saya, a ləvam: «Dəra fa hwadam mazlaŋgalakaya! Dəra fa hwadam mazlaŋgalakaya!» ");
INSERT INTO mif_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat a wuɗey amba aa səmdata ndəhay makustakaya heyey. Anda keɗe, ta’, a pəskatara Barabas daa fərsəne. A ləvtar a sewje hay ŋga sləɗmara Yesu ta laway. Fa dəɓa ha, a vəldatara amba a dərmara fa hwadam mazlaŋgalakaya. ");
INSERT INTO mif_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sewje hay a handamara Yesu a palah-way ŋga Bay Pilat. Ta’, a zəlmatərwa sewje hay siya feteɗe tabiya. ");
INSERT INTO mif_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","A kəzlmar zana magaza ŋga bay hay fa vaw. A cam hatak, a paɗamar ray anda gursaw ŋga bay. ");
INSERT INTO mif_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ta’, a camar har, a ləvmar: «Zay daw, bay ŋga *Jəwif hay?» ");
INSERT INTO mif_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A kəɗmara ta zlanday a wuzlah-ray, a təfmar meesleɓ fa vaw. A ragadam fa mey aŋga. ");
INSERT INTO mif_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Fa dəɓa ha, masa ata maa saŋgəram cay a ray a na, a cəkwmara zana magaza heyey fa vaw, a kəzlmar zana aŋga hay. Ta’, a badamara daa berney a, a handamara ŋga dərey fa hwadam. ");
INSERT INTO mif_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ndaw daa berney ŋga Siren daha, mezəley *Simaŋw, aŋga papaŋ ŋga ata Alekzandəre ta Rufus. A sawa da ley, aŋga fa daw ta ŋgene. Masa sewje hay heyey, fa handamara Yesu na, a təkmar ɗay a Simaŋw heyey ŋga la hwadam mazlaŋgalakaya ŋga Yesu a. ");
INSERT INTO mif_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","A handamara Yesu aa slam mezəley ta mey ata Gwalgwata, anda meləvey, «slam anda tetesl ŋga ray ŋga ndaw.» ");
INSERT INTO mif_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","A wuɗam ŋga vəlmar wuzam majahaɗakaya ta slalak mezəley «*mir», ama Yesu a gəmey ŋga sa ba . ");
INSERT INTO mif_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ta’, a dərmara fa hwadam mazlaŋgalakaya. Fa dəɓa ha, a kəɗam caca ŋga wunkey zana aŋga hay amba a sərmara kwa waawa a da hətey na, zana wura. ");
INSERT INTO mif_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A dərmara Yesu fa hwadam na, taa pərek, pas təɗe mehəley maaca. ");
INSERT INTO mif_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mey masa ata ma kəɗmara vagay maja ha na, mawuzlalakaya fa hwadam, a ləvey: «Ara bay ŋga *Jəwif hay.» ");
INSERT INTO mif_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Daa slam masa ata ma dərmara Yesu a na, ta dəram mayal hay cew la a cakay a, pal ta har-zəmay, laŋgar ta har-gula.  ");
INSERT INTO mif_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Cek aha ta key la anda mawuzlalakaya daa ɗerewel ŋga Gazlavay zleezle ma ləvey: «Ndəhay a da sləfmara a dey ndəhay malamba.» ");
INSERT INTO mif_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ndəhay ma diyam taa slam a ŋgene aa saŋgəram a ray a, a wusam ray, a cəɗmara, a ləvmar: «Hey! Kah na, ndaw ma wuɗey ŋga bəzla *Way-mekey-kwakwas ŋga Gazlavay amba ka ləma mekele daa ɗar maakar heyey, ba diya? ");
INSERT INTO mif_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bərŋgawa fa hwadam a ŋgene a hwayak, ləhda ray akah dəɓa taw!» ");
INSERT INTO mif_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Asaya, *bay-ray hay ŋga *ndəhay ma ka kwakwas ŋga Gazlavay ta *ndəhay maa sərkada *kwakwas ŋga Mawiz aa saŋgəram da ray a, a ləvam da wuzlah ata: «A ləhdata ndəhay siya hay na, kaa ray aŋga na, a gwa ŋga ləhda, ba daw? ");
INSERT INTO mif_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ndaw keɗe, da aŋga ndaw masa Gazlavay ma wala ŋga key Bay ŋga *Israyel hay na, ŋga bərŋgawa fa hwadam a wure keɗe dəɓa taw. Da ya nəkakwa ta bərŋgawa sem na, ŋgene, ya təɓkwa mey aŋga la.» Ndəhay madərtakaya da cakay Yesu heyey na, a cəɗmara may. ");
INSERT INTO mif_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ta wuzlah-pas, ləvaŋ a key daa hwayak cəpa. Ləvaŋ a, a njey haa ɓərey maakar ŋga pas ŋgaa kwaɗ. ");
INSERT INTO mif_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ta ɓərey maakar a na, Yesu a wudey ta gədaŋ, a ləvey ta mey ata: «Elawi, Elawi, lema sabaktani?» Anda meləvey: «Gazlavay aɗaw, Gazlavay aɗaw, ka mbəkdaya na, maja me?» ");
INSERT INTO mif_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ndəhay siya feteɗe, a cəndamara mewudey ŋga Yesu a na, a ləvam: «Jəkam sləmay, aŋga fa zəla *Eli, *ndaw ma təla mey ŋga Gazlavay zleezle!» ");
INSERT INTO mif_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ndaw pal da wuzlah ata, ta’, a hway ŋga jəhwɓey cek anda gagəmay aa yam ŋga babəza ŋga wudez meekwerek e, ta’, a pa fa mey ŋga zlanday. A təldara a Yesu a amba a sasəɓa. Ndaw a, a ləvey: «Səkwakwa, amba ya nəkakwa da wara cay Eli a, a sawa ŋga bərŋgadərwa la kwa.» ");
INSERT INTO mif_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ama Yesu a wudey ta gədaŋ, pam! a məcey. ");
INSERT INTO mif_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Daa *Way ŋga Gazlavay na, zana ma gərca *Slam masa Gazlavay aa da hwaɗ a daha. Masa Yesu ma məcey la na, zana ha, a ŋgərey cew dəga da vaɗ kasl a hwayak. ");
INSERT INTO mif_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mahura ŋga sewje hay ŋga Rawma hay manjakaya fa mey ŋga Yesu, masa aŋga ma hətar Yesu ma məcey meedey aŋga na, bay ŋga sewje hay a, aa guzley, a ləvey: «Fara fara ndaw keɗe na, ara Bəzey ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ŋgusay feteɗe daha may, ata fa nəkam dey ta meedəreŋ e. Da wuzlah ata na, *Mari da Magdala, Salawme, leŋ Mari mamaŋ ŋga ata Jawz ta *Jak, bəz-gula. ");
INSERT INTO mif_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","0Ŋgusay a ta pəkam la ta ata Yesu daa masa aŋga daa *Galile, ta kamar sləra la. Da cakay hwadam mezleŋgeley Yesu a na, ŋgusay ga mekele daha may. Ŋgusay a na, ta diyam la ta Yesu a *Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ta pas ŋgene na, ara ɗar masa ndəhay ma ɗiyam vaw ŋga *pas meməskey-vaw. Ta pas ŋgaa kwaɗ a ŋgene, meməskey-vaw ŋga *Jəwif hay a, a zley. ");
INSERT INTO mif_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ndaw da slala Arimate daha, mezəley *Jawzef, aŋga, ndaw da wuzlah ndəhay mahura ma sla yawa ŋga Jəwif hay. Ndəhay ga fa namar ray. Aŋga may, fa səkwa mewey ŋga Bay Gazlavay. Ndaw aha na, a kərza mevel, a daw fa Bay Pilat amba aa cəfɗa ŋga vəlar cəveɗ ŋga la vagay ŋga Yesu amba a jəha. ");
INSERT INTO mif_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat a rəzley ga maja Yesu ta məcey sem fiyaw fiyaw gway. Da ray ŋgene, a zələrwa mahura ŋga sewje hay, aa cəfɗa da Yesu a məcey na, menjey ga kwa. ");
INSERT INTO mif_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Masa Pilat maa cəfɗa mahura ŋga sewje hay heyey la na, ta’, a vəlar cəveɗ a Jawzef ŋga la vagay a. ");
INSERT INTO mif_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jawzef, ta’, a həɗkey zana maaya mabara. A bərŋgadərwa vagay a da ray hwadam mazlaŋgalakaya heyey a hwayak. Ta’, a zləŋga ta zana ha, a handa aa cəvay. Cəvay a, maavərkwakaya daa aŋgwa anda bədam. Ta’, a gədbalawa beeler mahura, gazl! a mey cəvay a. ");
INSERT INTO mif_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ata *Mari da Magdala, ta Mari, mamaŋ ŋga Jawz heyey, ata feteɗe, fa nəkam dey aa cəvay masa ata ma pamara vagay ŋga Yesu a hwaɗ a heyey. ");
INSERT INTO mif_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Fa dəɓa ŋga *pas meməskey-vaw na, *Mari da Magdala, Mari mamaŋ ŋga *Jak, leŋ Salawme, a həɗkam ɓərdey hay ma zam maaya amba a diyam a wucmərwa fa vagay ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pərek pərek ta luma ŋga Gudal, masa pas fa bawa na, ŋgusay a, a diyam a mey cəvay ŋga Yesu a. ");
INSERT INTO mif_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ata daa cəveɗ na, aa guzlam da wuzlah ata, a ləvam: «Ma da gədbalandakwara beeler mahura da mey cəvay a na, wa?» ");
INSERT INTO mif_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","A da nəkam dey na, a hətmar beeler heyey, magədbalakaya ta cakay. ");
INSERT INTO mif_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Masa ata fa mbəzam aa cəvay a na, a hətam gula manjakaya ta har-zəmay. Aŋga ta zana mahura mabara fa vaw. Anda keɗe, mandərzay a katar a ŋgusay a. ");
INSERT INTO mif_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ama gula ha a ləvtar: «Ka zluram ba! Ka səpam na, Yesu, ndaw *Nezeret, masa ata ma dərmara fa hwadam mazlaŋgalakaya heyey daw? Ta sləkɗawa sem daa meməcey, aŋga feɗe daa saba. Nəkmara slam masa ata ma pamara a hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wure keɗe na, diyam, ləvmatar ŋgada ata *Piyer ta *gula hay ŋga Yesu mekele na, Yesu aŋga sem teeseɗ a *Galile fa mey akwar. Ka da hətfamar feteɗe anda aa ma ləvkwar.» ");
INSERT INTO mif_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","A bamawa, a hwam, a mbəkdamara cəvay a, ata faa wasam maja mandərzay fa katar, leŋgesl ata ta mbəɗey sem. Ta kadamara kwa ŋgada waawa daa ba, maja ata fa zluram ga.  ");
INSERT INTO mif_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pərek pərek ta pas luma ŋga Gudal, Yesu a sləkɗawa daa meməcey. Masa ta sləkɗawa cay na, ŋgeeme a wuzar vaw a *Mari da Magdala, ŋgwas masa aa ma ɓəley malula maasala da ray a heyey. ");
INSERT INTO mif_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ta’, ŋgwas aha, a daw, a kadatara a ndəhay masa ma pəkam ta Yesu zleezle. A hətfatar ata daa matəway. ");
INSERT INTO mif_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ŋgwas aha, a ləvtar: «Yesu aa ta dey! Yah ma hətar la.» Ama masa ata ma cəndamara mey masa ŋgwas a ma kada na, a təɓmara mey a ba. ");
INSERT INTO mif_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Fa dəɓa ha, Yesu a wuztar vaw ŋgada gula aŋga hay cew ma diyam ta daa cəveɗ ma bawa da *Jeruzelem. A wuztar vaw a na, wal ta masa aŋga ma wuzar vaw ŋgada *Mari da Magdala heyey. ");
INSERT INTO mif_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Gula hay a, a vəhmawa, a kadamatara a *gula hay ŋga Yesu siya. Gula hay a, a təɓmara mey ata ha ba saya na, gway.  ");
INSERT INTO mif_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Fa dəɓa ha, masa gula aŋga hay kuraw a ray a letek fa zəmam ɗaf na, Yesu a wuztar vaw. A mbəɗtar ray maja a təɓmara mey da ray a ba, a ləvtar: «Ya ta sləkɗawa sem daa meməcey, ama ndəhay ma hətmaya ta dey ata na, ka təɓmara mey ata ba na, kwara? Anda keɗe, akwar na, ndəhay masa ray maŋgərɗakaya.» ");
INSERT INTO mif_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ta’, a ləvtar saya: «Diyam aa hwayak hay cəpa, wuzdamatara *Mey-maaya-mawiya a ndəhay tabiya. ");
INSERT INTO mif_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ndaw ma təɓa mey a la, ta ma hətey *baptem la na, a ləhey la daa mebərey. Ama ndaw ma təɓa mey a daa ba na, sariya a kərza la. ");
INSERT INTO mif_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Gazlavay a vəltar gədaŋ ŋga key maazla hay la a ndəhay ma təɓmara Mey-maaya-mawiya ha. Anda meləvey, a da ɓəlam malula da ray ndəhay ta mezəley aɗaw. A daa guzlam mey hay mekele mekele masa ata ma sərmara ba. ");
INSERT INTO mif_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kwa a kərzam zezekw ta har, kwa a ləgwmata ta slalak ma kəɗey ndaw vagay na, cek fa da katar daa ba. A da pam har a ray masa-macay hay. Anda keɗe, masa-macay hay a, a mbəlam la.»  ");
INSERT INTO mif_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Masa Bay Mahura Yesu ma kadatara cek hay la cəpa a gula aŋga hay na, ta’, Gazlavay a la a vaɗ. Feteɗe, aŋga manjakaya ta har-zəmay ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Gula aŋga hay, ta’, a diyam aa wura aa wura cəpa, a wuzdamara *Mey-maaya-mawiya a ndəhay. Yesu, Bay Mahura, fa jənta daa sləra ata ha. Ndəhay a sərmara mey ŋga *gula hay ŋga Yesu ara mey fara fara na, maja aŋga fa vəltar gədaŋ ŋga key maazla hay. ");
INSERT INTO mif_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Waa *Teyewfil, Ndəhay ga ta kəɗam vaw la ŋga wuzleley da ray cek hay ma kam da wuzlah ala. ");
INSERT INTO mif_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","A wuzlalam na, mey masa ala ma cəndamərwa fa ndəhay masa ma hətmərwa ta dey ata dəga ŋga mezley ŋga sləra ŋga *Yesu. Ndəhay a, ara ndəhay ma wuzdamara mey ŋga *Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ya taa cəfɗey ndəhay la ta dək-vaw da ray cek hay tabiya ma key dəga ŋga mezley ŋga sləra ŋga Yesu a. Yah may, a mbafaya ŋga wuzlalatakawa cek hay a ŋgada kah Teyewfil, ndaw mahura. ");
INSERT INTO mif_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ya wuzlalakawa amba ka səra mey masa ata maa sərkadamakawa na, ara mey fara fara. ");
INSERT INTO mif_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Daa masa *Herawt aŋga bay daa hwayak ŋga *Jude na, *ndaw ma ka kwakwas ŋga Gazlavay daha mezəley *Zakari. Aŋga da wuzlah ndəhay ma ka kwakwas ŋga Gazlavay masa ata ma zəlmata ndəhay ŋga Abiyah. Ŋgwas ŋga Zakari a, mezəley Elizabet, aŋga səkway ŋga *Araŋw, *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay zleezle. ");
INSERT INTO mif_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakari a, ata cewete ta ŋgwas aŋga, ndəhay maaya fa mey ŋga Gazlavay, fa təɓmara *mewey ŋga Bay Gazlavay maaya maaya, asaya, fa namar ray a kwakwas ŋga Gazlavay ta cəveɗ e. ");
INSERT INTO mif_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ama bəzey ata daa ba, maja Elizabet a yey ba. Ata cewete maraw hay. ");
INSERT INTO mif_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pas pal daha, Zakari fa key sləra ŋgada Gazlavay daa *Way-mekey-kwakwas ŋga Gazlavay maja sləra ha ta pas ŋgene a ray ata ta ndəhay ŋga Abiyah heyey. ");
INSERT INTO mif_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aŋga fa key sləra feteɗe maja ta kəɗam caca la amba a walamara anda kwakwas ata ma ləvey. Sləra aŋga ha na, ara ŋga mbəzey aa *Slam masa Gazlavay aa da hwaɗ a daa *Way ŋga Gazlavay amba aa wurey cek mezey maaya ŋgada Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Daa ŋgene, ndəhay tabiya makustakaya daa ambaw fa dəram daŋgay. ");
INSERT INTO mif_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ta’, *maslaŋ ŋga Bay Gazlavay da vaɗ a wuzar vaw a Zakari. A lecey ta har-zəmay da cakay slam-meewurey cek mezey maaya ŋgada Gazlavay heyey. ");
INSERT INTO mif_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Masa Zakari ma hətar na, leŋgesl aŋga a mbəɗey, a zlurey. ");
INSERT INTO mif_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ama maslaŋ ŋga Gazlavay a, a ləvar: «Ka zlurey ba, Zakari, maja Bay Gazlavay ta cənda medərey-daŋgay akah la. Elizabet, ŋgwas akah, a yaka bəzey mezəle la, ka da zəla bəzey a, *Jaŋ. ");
INSERT INTO mif_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kaa səmey la ga. Ndəhay ga aa səmam la fa mayawa aŋga ha may, ");
INSERT INTO mif_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","maja a da key ndaw ma ka sləra mahura ŋga Gazlavay. Fa da sey wuzam daa ba, kwa fa da sey cek maməslkaya daa ba səlak. *Mesəfney ŋga Gazlavay a sawa la a ray a, dəga aŋga da hwaɗ mamaha. ");
INSERT INTO mif_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A da jənta ndəhay *Israyel hay ga amba a vəhmawa fa Bay Gazlavay ata. ");
INSERT INTO mif_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A da daw fa mey ŋga Bay Gazlavay ŋga ɗiyra cəveɗ. Aŋga ta gədaŋ leŋ ta mesəfney ŋga Gazlavay da ray a anda *Eli, *ndaw ma təla mey ŋga Gazlavay zleezle. A da cəmtar ɗay ŋgada papaŋ hay ta bəz ata hay. A da tərdata ndəhay makəwtakaya ŋga ndəhay ma wulkam maaya anda ndəhay ma kam cek ta cəveɗ e. Anda keɗe, a da ɗiyta ndəhay ŋga təɓey Bay Mahura ma da sawa.» ");
INSERT INTO mif_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ama Zakari aa cəfɗa maslaŋ ŋga Gazlavay heyey, a ləvar: «Ya da səra masa cek aha a key la fara fara na, fa me? Maja wure keɗe na, yah maraw, ŋgwas aɗaw may, madaŋgwas.» ");
INSERT INTO mif_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maslaŋ ŋga Gazlavay a, a mbəɗdara, a ləvar: «Ara yah, Gabəriyel, yah masa ma lecey fa mey ŋga Gazlavay ŋga kar sləra. Ara aŋga ma slərdiwa amba ya wuzdakawa mey maaya keɗe. ");
INSERT INTO mif_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mey aɗaw masa yah ma kadakawa keɗe na, a key la fara fara ta pas masa Gazlavay ma wuɗey anda yah ma ləvka, ama kah ta təɓa daa ba. Da ray ŋgene, wure keɗe, ka da tərey madagazlam, ka fa da gwa ŋgaa guzley daa ba, haa kasl cek aha ma key la.» ");
INSERT INTO mif_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Daa masa Zakari a lawa daa Slam maaya daa *Way ŋga Gazlavay heyey na, ndəhay makustakaya daa ambaw heyey fa səkwmara, a rəzlam maja ta njawa sem ga kalah daa slam aha. ");
INSERT INTO mif_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zakari a bawa aa ambaw, a gwa ŋgaa guzltar saba. Da ray ŋgene, ndəhay a, a sərmara Gazlavay ta wuzar cek la daa slam aha. A gwa aa guzley ba, aa guzltar na, si ta har gway. ");
INSERT INTO mif_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Masa Zakari ta ndəvda sləra aŋga cay na, ta’, a daw a way. ");
INSERT INTO mif_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Fa dəɓa ha, Elizabet, ŋgwas aŋga, a key hwaɗ. Kiya zlam aa manjakaya da way da way, a ɓada hwaɗ a. Aa guzley daa ray aŋga, a ləvey: ");
INSERT INTO mif_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Nəka, cek masa Bay Gazlavay ma kayawa. A wuɗey ŋga ɓəlyawa hwaray daa dey aɗaw fa dey ŋga ndəhay.» ");
INSERT INTO mif_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Masa Elizabet aa ta hwaɗ kiya maakwaw na, Gazlavay a slərwa maslaŋ aŋga, Gabəriyel, a *Nezeret daa hwayak ŋga *Galile, ");
INSERT INTO mif_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","fa dam-saɓara, kwakwa ŋga ndaw mezəley *Jawzef. Jawzef e na, ara səkway ŋga Bay *Davit zleezle. Mezəley ŋga saɓara ha, *Mari. ");
INSERT INTO mif_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maslaŋ ŋga Gazlavay heyey kula! a mbəzey fa vəɗa, a car har, a ləvar: «Ya caka har, Mari. Bay Gazlavay a wuɗka kalah. Bay Gazlavay aa ta kah.» ");
INSERT INTO mif_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari ma cənda mey a na, mey a, a həɓar ray. A wulkey daa ray aŋga, a ləvey: «Mecey-har a, keɗe na, a wuɗey ŋga ləvey na, kwara?» ");
INSERT INTO mif_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ta’, maslaŋ ŋga Gazlavay a, a ləvar: «Ka da zlurey ba Mari, maja ara Gazlavay ma pəska mey. ");
INSERT INTO mif_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ka da key hwaɗ, ka da yawa bəzey mezəle, ka da zəla bəzey a, Yesu. ");
INSERT INTO mif_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A da key ndaw mahura, asaya, aŋga Bəzey ŋga Bay Gazlavay da vaɗ. Bay Gazlavay a da tərda ŋga bay aa slam a ŋga Bay Davit, ndaw daa səkway aŋga zleezle. ");
INSERT INTO mif_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A da wa səkway ŋga *Israyel ŋga sərmataw. Bay aŋga fa da ndəvey daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari aa guzlar a maslaŋ ŋga Gazlavay heyey, a ləvar: «Cek aha, a da key na, kwara? Maja ya səra zel ba.» ");
INSERT INTO mif_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maslaŋ a, a mbəɗdara, a ləvar: «Mesəfney ŋga Bay Gazlavay da vaɗ a sawa la a ray akah ta gədaŋ aŋga, a bərɗaka la anda meezeɗ. Da ray ŋgene, bəzey a ma da yawa na, ara bəzey masa mapakaya wal ŋgada Gazlavay. Ndəhay a da zəlmara Bəzey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nəka, Elizabet, səkway akah, kwa aŋga madaŋgwas na, aŋga ta hwaɗ wure keɗe may. A da yawa bəzey mezəle. Ndəhay a ləvam aŋga dərlay, ama wure keɗe aa ta hwaɗ kiya maakwaw, ");
INSERT INTO mif_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","maja cek masa ta banay fa Gazlavay na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Fa dəɓa ha, Mari a ləvar: «Yah ndaw ma ka sləra ŋga Bay Gazlavay. Cek aha ŋga key anda kah ma ləvey.» Ta’, maslaŋ ŋga Gazlavay a, a mbəkda, a daw. ");
INSERT INTO mif_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Daa ɗar a ŋgene, *Mari a sləkɗey, a wusey vaw, a daw a slala daa aŋgwa ŋga *Jude. ");
INSERT INTO mif_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A wusey a slala ha, kula! a mbəzey a way *Zakari, ta’, a car har a Elizabet. ");
INSERT INTO mif_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Daa masa Elizabet ma cənda mecey-har ŋga Mari na, bəzey da hwaɗ Elizabet a, a wusey. Wure ŋgene, *Mesəfney ŋga Gazlavay a sawa a ray Elizabet. ");
INSERT INTO mif_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Da ray ŋgene, aa guzley ta gədaŋ, a ləvar a Mari: «Maaya ŋga Gazlavay aa da ray akah, a fəna da ray ŋgusay siya tabiya. Asaya, maaya ŋga Gazlavay aa da ray bəzey masa kah ma da yarawa! ");
INSERT INTO mif_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yah na, wa may wa, amba mamaŋ ŋga Bay aɗaw Mahura a sawa a way aɗaw anda keɗe na! ");
INSERT INTO mif_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ya səra kah mamaŋ ŋga Bay aɗaw Mahura na, maja, daa masa yah ma cənda ɗay akah, kah ma caya har na, bəzey da hwaɗ aɗaw a wusey ta meesəmey. ");
INSERT INTO mif_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Maaya ŋga Gazlavay aa da ray akah, maja ka ta təɓa mey aŋga la da ray cek ma da key fara fara.» ");
INSERT INTO mif_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Fa dəɓa ha *Mari a ləvey: «Ya fa həlma Bay Gazlavay ta mevel aɗaw cəpa. ");
INSERT INTO mif_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ya faa səmey maja Gazlavay, ndaw ma ləhdaya, ");
INSERT INTO mif_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kwa yah, ndaw mahura fa mey ŋga ndəhay ba na, aŋga fa nəkfaya dey, yah, ndaw ma ka sləra aŋga. Fara fara, dəga wure keɗe, ndəhay ma da yamawa tabiya, a daa guzlam da ray aɗaw, a ləvam: “Maaya ŋga Gazlavay aa da ray aŋga”. ");
INSERT INTO mif_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","A da ləvam anda keɗe maja Bay Gazlavay Mawaca-waca, ta kaya cek maaya la. Aŋga na, Bay Gazlavay pal. ");
INSERT INTO mif_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A katar maaya la mandaw mandaw ŋgada ndəhay ma namar ray. ");
INSERT INTO mif_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Aa ta gədaŋ ŋga key sləra mahura, aa waɗatar ray ŋga ndəhay ma zlapam. ");
INSERT INTO mif_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A badata bay hay ma wamata ndəhay ta gədaŋ daa bay, a pata ndəhay masa ma namar ray ŋga mahura. ");
INSERT INTO mif_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ndəhay masa may fa catar na, a rəhdata ta cek mezəmey, masa-zleley hay na, a vəhdata ta har ɓa’ kəne. ");
INSERT INTO mif_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ta jənndakwar la, aləkwa ndəhay *Israyel hay, ma ka sləra aŋga hay, anda aa ma ləvtar zleezle a papaŋ ŋga papa aləkwa hay. ");
INSERT INTO mif_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","A ləvtar na, a da key maaya ŋgada *Abəraham ta ŋgada ndəhay ma yamawa daa səkway aŋga hay ŋga sərmataw.» ");
INSERT INTO mif_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari a njey da way Elizabet a key gweegwe kiya maakar. Fa dəɓa ha, ta’, a vəhwa a way aŋga. ");
INSERT INTO mif_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kiya ŋga Elizabet ta wuswa cay ŋga yey. A yawa bəzey mezəle. ");
INSERT INTO mif_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Meseembew aŋga hay ta səkway aŋga hay ma cəndamara masa Bay Gazlavay ta kar maaya la na, aa səmam ta ata Elizabet e. ");
INSERT INTO mif_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Masa bəzey a, ma key luma pal cay na, meseembew aŋga hay ta səkway aŋga hay heyey a samawa aa kwakwas ŋga *mesley mandawal ŋga bəzey a ta ŋga pey mezəley. A wuɗam a pamar mezəley *Zakari, mezəley ŋga papaha. ");
INSERT INTO mif_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ama mamaha, a ləvtar: «Kəne ba, mezəley aŋga na, *Jaŋ.» ");
INSERT INTO mif_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","A mbəɗdamara, a ləvmar: «Ka zəla anda keɗe na, kwara? Ndaw mezəley daa səkway akwar anda keɗe daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ta’, aa cəfɗamara Zakari, papaha, ta har, amba a sərmara a wuɗey ŋga zəla bəzey a me. ");
INSERT INTO mif_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakari a, ta’, aa cəfɗey hwadam kəslparah a ŋga wuzleley mezəley a. A wuzlala: «Mezəley aŋga, Jaŋ.» Ndəhay tabiya a rəzlam fa mezəley a. ");
INSERT INTO mif_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wure wure ŋgene, Zakari a zlar meeguzley dəɓa, aŋga madagazlam saba. Ta’, a həlma Gazlavay ta gədaŋ. ");
INSERT INTO mif_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Meseembew aŋga hay tabiya mandərzay a katar. Ndəhay daa aŋgwa daa hwayak ŋga *Jude he tabiya, fa kadamara mey a. ");
INSERT INTO mif_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ndəhay tabiya ma cəndamara mey a, a wulkam daa ray ata, a ləvam: «Bəzey a keɗe na, a da tərey na, me?» A ləvam anda keɗe maja maaya ŋga Bay Gazlavay aa da ray a fara fara. ");
INSERT INTO mif_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Fa dəɓa ha, *Mesəfney ŋga Gazlavay a sawa a ray *Zakari, papaŋ ŋga bəzey heyey. A zlar ŋga wuzey mey anda *ndaw ma təla mey ŋga Gazlavay, a ləvey: ");
INSERT INTO mif_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Həlmakwa Bay Gazlavay, Gazlavay aləkwa *Israyel hay, maja aŋga ta jənta ndəhay aŋga hay la, amba a ləhdata. ");
INSERT INTO mif_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Aa ta slərndakwar ndaw masa-gədaŋ la, ŋga ləhdandakwar daa mebərey. Ndaw aha, aŋga daa səkway ŋga Bay Davit, ndaw ma ka sləra aŋga zleezle. ");
INSERT INTO mif_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Bay Gazlavay taa guzlndakwar la dəga zleezle ta mey ndəhay ma təla mey aŋga hay. ");
INSERT INTO mif_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ta ləvndakwar la, a da ləhdandakwar dasi har ŋga masa-gəra aləkwa hay, leŋ dasi har ŋga ndəhay ma wuɗam ŋga hətmandakwar fa dey ba. ");
INSERT INTO mif_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A wuzdərwa mewuɗey-vaw aŋga la, fa papaŋ ŋga papa aləkwa hay, A sərfada *mejəwey-mey aŋga la ta aləkwa. ");
INSERT INTO mif_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Daa mejəwey-mey a na, Gazlavay taa guzlar la a *Abəraham papaŋ ŋga papa aləkwa zleezle, a ləvar, ");
INSERT INTO mif_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","a ləhdandakwar la dasi har ŋga masa-gəra aləkwa hay, amba ya kakwa sləra ŋgada Gazlavay ta mandərzay ba, ");
INSERT INTO mif_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","amba ya tərkwa ndəhay maaya fa Gazlavay, ndəhay ma ka sləra ta cəveɗ e, haa kasl fa meməcey aləkwa. ");
INSERT INTO mif_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Bəz aɗaw, kah may, ka da tərey ndaw ma təla mey ŋga Bay Gazlavay da vaɗ maja ka da daw fa mey ŋga Bay Gazlavay ŋga ɗiyra cəveɗ. ");
INSERT INTO mif_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ka da wuzdatara a ndəhay ŋga Gazlavay na, Gazlavay a, a da ləhdata maja a da mbəkdatara mebərey ata. ");
INSERT INTO mif_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","A da ləhdata na, maja aŋga na, maaya kalah, asaya, a sərey dey-ceceh kalah fa ndəhay. Fa slərndakwar meweɗey da vaɗ anda pas, ");
INSERT INTO mif_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","amba a waɗatar dey a ndəhay ma njam daa ləvaŋ masa fa da məcam, asaya, amba ya hətkwa ŋga njey ta zazay.» ");
INSERT INTO mif_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bəzey a heyey, fa gəley, fa gəley, leŋgesl fa səkwa. Fa dəɓa ha, a daw a wuzlah-ley, aa manjakaya feteɗe, kasl pas masa aŋga ma zlar ŋga wuzey mey ŋga Gazlavay fa mey ŋga ndəhay Israyel hay. ");
INSERT INTO mif_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Daa masa ata ma yamərwa *Jaŋ-Baptis la na, Agustus, bay mahura da ray bay hay daa hwayak hay ŋga *Rawm, a ləvtar a mahura hay amba a sləfmata ndəhay daa hwayak aŋga hay tabiya. ");
INSERT INTO mif_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ŋgene, ara mesləfey ndəhay ŋgeeme. Mesləfey ndəhay a ŋgene na, a key daa masa Kiriniyus fa wata ndəhay daa hwayak ŋga Siri. ");
INSERT INTO mif_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ndəhay tabiya a diyam ŋga sləfwa vaw a. Kwa waawa na, a daw aa hwayak aŋga, masa papaha ma yawa da hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","*Jawzef may, a sləkɗey da *Nezeret daa hwayak ŋga *Galile, a sləkɗam ta kwakwa aŋga *Mari, a diyam a Betəlehem daa hwayak ŋga *Jude ŋga sləfwa vaw. A diyam a Betəlehem na, maja Bay *Davit zleezle a yawa da hwaɗ a. Jawzef na, aŋga səkway ŋga Davit. Mari, kwakwa aŋga ha na, aa ta hwaɗ. ");
INSERT INTO mif_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ata ma wusam la a Betəlehem na, kiya ŋga Mari ta wuswa cay ŋga yey. ");
INSERT INTO mif_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mari a yawa bəzey mezəle, mahura aŋga. Ta’, a mbəza ta zana, a nada aa cek masa gənaw hay ma zəmam cek da hwaɗ a maja daa way meney ŋga məlak hay na, slam ŋgada ata daa ba. ");
INSERT INTO mif_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Daa hwayak a ŋgene, mecəkwer hay daha, manatakaya ta tavaɗ da ley. Fa jəɗam gənaw ata hay. ");
INSERT INTO mif_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","*Maslaŋ ŋga Bay Gazlavay da vaɗ ta’, a wuztar vaw. Meweɗey ŋga Bay Gazlavay a sawa a ray ata. Mecəkwer hay a, a zluram ga, aa wasam pər-par! ");
INSERT INTO mif_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ama maslaŋ a heyey, a ləvtar: «Ka zluram ba, maja ya sawa na, ya handakwar mey maaya masa ma da vəltar meesəmey ga a ndəhay tabiya. ");
INSERT INTO mif_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dasi tavaɗ keɗe, da Betəlehem, slala masa Bay *Davit ma yawa zleezle da hwaɗ a, ndaw masa ma da ləhdata ndəhay ta yawa la maja akwar. Ara *Kəriste, Bay Mahura. ");
INSERT INTO mif_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yaw, amba ya wuzdakwara cek ŋga sərey mey a fara fara, ka da hətfamar bəzey-gevew mambəzkaya ta zana, manadakaya daa cek masa gənaw hay ma zəmam cek da hwaɗ a.» ");
INSERT INTO mif_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wure wure ŋgene, maslaŋ hay ŋga Gazlavay mekele a samawa ga, a tulakamara maslaŋ ŋga Gazlavay heyey. A həlmamara Gazlavay ta walay. A ləvam: ");
INSERT INTO mif_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Anja ndəhay ŋga həlmamara Gazlavay da vaɗ, asaya, anja Gazlavay ŋga vəltar zazay a ndəhay masa aa ma wuɗta da bəla.» ");
INSERT INTO mif_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Fa dəɓa ha, maslaŋ hay ŋga Gazlavay heyey a vəham a vaɗ. Ta’, mecəkwer hay a, a slam yawa da wuzlah ata, a ləvam: «Bay Gazlavay ma wuzdandakwara cek keɗe na, nakwa la a Betəlehem, amba ya nəkakurwa cek masa ma key feteɗe.» ");
INSERT INTO mif_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A sləkɗam, a diyam ta mewusey-vaw. A hətfamatar ata *Mari ta *Jawzef, leŋ bəzey-gevew manakaya daa cek masa gənaw hay ma zəmam cek da hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ata ma hətfamatar la na, a kadamatara cek masa maslaŋ ŋga Gazlavay ma wuzdatara da ray bəzey a heyey. ");
INSERT INTO mif_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ndəhay tabiya ma cəndamara mey masa mecəkwer hay a ma kadamatara na, a rəzlam. ");
INSERT INTO mif_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ama ŋga Mari na, a pa mey a, aa mevel aŋga. Mandaw mandaw fa wulkey da ray a. ");
INSERT INTO mif_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Fa dəɓa ha, mecəkwer hay heyey a vəham fa gənaw ata hay. A həslmar ray a Gazlavay maja aa mahura da ray ndəhay. A həlmamara da ray cek hay tabiya masa ata ma cəndamərwa, ta masa ata ma hətmərwa feteɗe, maja cek hay tabiya ta kam la anda maslaŋ ŋga Gazlavay ma wuzdatara heyey. ");
INSERT INTO mif_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Fa dəɓa ha luma pal, ɗar ta wuswa cay ŋga sley mandawal ŋga bəzey a, ta pas ŋgene a pamar mezəley Yesu, mezəley masa maslaŋ ŋga Gazlavay da vaɗ ma wuzdara a mamaha daa masa ta key hwaɗ daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Fa dəɓa ŋga *mesley mandawal ŋga bəzey a, pas ta wuswa cay amba *Jawzef ta *Mari a kam kwakwas ŋga tərey maaya fa Gazlavay anda kwakwas ŋga Mawiz ma ləvey maja mawuda. Da ray ŋgene, ata Jawzef ta Mari a diyam aa berney ŋga Jeruzelem. Asaya, a handamara bəzey ata ŋga wuzey a Bay Gazlavay, ");
INSERT INTO mif_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","maja mawuzlalakaya daa *mewey ŋga Bay Gazlavay, a ləvey: «Bəza hay mezəle tabiya ma yamawa ŋgeeme na, ma pam wal ŋgada Bay Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","A diyam amba a vəlam cek a Bay Gazlavay. A vəlam na, magwada-gwada hay cew, da daa ba, makurgwadakw hay cew, anda kwakwas ŋga Gazlavay ma ləvey. ");
INSERT INTO mif_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ndaw da *Jeruzelem e daha, mezəley Simeyaŋw. Ndaw aha, ara ndaw maaya, fa səpa cəveɗ ŋga Gazlavay ta mevel pal, aa fa səkwa ndaw masa ma da sawa ŋga ləhdata *Israyel hay. *Mesəfney ŋga Gazlavay aa da ray a. ");
INSERT INTO mif_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mesəfney a, ta ləvar la: «Ka da məcey na, si ka hətar *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay la.» ");
INSERT INTO mif_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Fa dəɓa ha, Mesəfney ŋga Gazlavay heyey, a handa aa *Way-mekey-kwakwas ŋga Gazlavay. Ta pas ŋgene, ata *Jawzef ta *Mari ta handamara Yesu, bəzey ata heyey la, aa way a, amba a kam kwakwas da ray a anda *kwakwas ŋga Mawiz ma ləvey. ");
INSERT INTO mif_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyaŋw a hətar bəzey a, ta’, a humbta a har, a kar suse a Gazlavay, a ləvey: ");
INSERT INTO mif_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Wure keɗe, Bay Gazlavay, mey masa kah ma ləvya na, ta key cay. Anda keɗe, ka gwa ŋga mbəkdaya, yah, ndaw ma ka sləra akah, ŋga məcey ta zazay. ");
INSERT INTO mif_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Maja yah, ta dey aɗaw, ya ta hətar ndaw ma da ləhdata ndəhay daa mebərey cay. ");
INSERT INTO mif_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ka wala ndaw aha na, ŋgada ndəhay tabiya. ");
INSERT INTO mif_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Aŋga anda slam-meweɗey ŋgada ndəhay da bəla tabiya. Ndəhay a da həlmamata ndəhay akah hay Israyel, maja ndaw aha keɗe.» ");
INSERT INTO mif_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ata papaŋ ŋga Yesu ta mamaha a rəzlam da ray mey masa Simeyaŋw maa guzley da ray bəzey a. ");
INSERT INTO mif_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ta’, Simeyaŋw a pəstar mey. Fa dəɓa ha, a ləvar a Mari, mamaŋ ŋga Yesu: «Gazlavay a wala bəzey keɗe amba ndəhay Israyel ga a təɗam aa mebərey, siya hay may, a mbəkdamara mekey mebərey, a səpmara Gazlavay ta cəveɗ e. Aŋga, ndaw ma wuzdatara a ndəhay ara Gazlavay ma wuɗey ŋga ləhdata ndəhay daa mebərey, ama ndəhay ga a da ŋgəldamara ba. ");
INSERT INTO mif_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","A wuzdərwa mewulkey ŋga ndəhay ga maɓadakaya la amba ndəhay tabiya a sərmara. Kah, mamaha na, mevel akah a tərkesley la anda ndaw ma ŋgəmka ta dəlaw.» ");
INSERT INTO mif_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Daa *Way-mekey-kwakwas ŋga Gazlavay heyey, ŋgwas ma təla mey ŋga Gazlavay daha, mezəley An. Aŋga, dam ŋga Fanəwel, səkway ŋga Aser. Aa madaŋgwas cay. Daa saɓara aŋga, a ley zel, a njam mevey maasala. ");
INSERT INTO mif_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Fa dəɓa ŋga zel e ma məcey la, ŋgwas a, a njey taava aŋga, ŋgwas-vagay. Mevey aŋga, kwakwar daaŋgafaɗ a ray a məfaɗ. Aa daa Way-mekey-kwakwas ŋga Gazlavay a mandaw mandaw, fa kar sləra a Gazlavay taa vaɗ, taa pas, fa key *daliyam, fa dərey daŋgay. ");
INSERT INTO mif_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Masa Simeyaŋw ma pəstar mey cay na, wure wure ŋgene, An a ŋgəchey a cakay ata, a kar suse a Gazlavay. Fa dəɓa ha, aa guzley da ray bəzey a ŋgada ndəhay tabiya da *Jeruzelem masa fa səkwmara amba Gazlavay a ləhdata. ");
INSERT INTO mif_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Masa ata *Jawzef ta *Mari ma ndəvdamərwa mekey kwakwas a tabiya cay anda kwakwas ŋga Bay Gazlavay ma ləvey na, a vəhmawa a slala ata, *Nezeret, da *Galile. ");
INSERT INTO mif_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bəzey a, fa gəley, fa gəley, fa hətey gədaŋ, leŋgesl fa səkwa. Mepəsey-mey ŋga Gazlavay aa da ray a. ");
INSERT INTO mif_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Fa mevey a, fa mevey a, ata *Jawzef, papaŋ ŋga Yesu, ta *Mari, mamaha a diyam a *Jeruzelem ŋga kawa gwagway ŋga *Pak. ");
INSERT INTO mif_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Masa Yesu, aŋga ta mevey kuraw a ray a cew na, ta’, a ŋgəlmara, a diyam bama aa gwagway a, anda kwakwas ata ma ləvey. ");
INSERT INTO mif_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Masa gwagway a daa saba na, a vəhmawa a way, ama Yesu, bəzey ata na, ta njawa sem fa dəɓa da Jeruzelem e. Ata papaha, ta mamaha, ta sərmara daa ba. ");
INSERT INTO mif_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A wulkam na, Yesu aa daa cəveɗ ta ndəhay siya ma diyam ta ata. A kam daa cəveɗ ɗar pal, ta’, a səpmara da wuzlah səkway ata hay, ta da wuzlah jam ata hay. ");
INSERT INTO mif_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ama ta hətmar daa ba. Da ray ŋgene, a vəham a Jeruzelem ŋga səpmərwa. ");
INSERT INTO mif_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ŋga ɗar maakar a na, a hətfamar daa *Way-mekey-kwakwas ŋga Gazlavay. Aŋga manjakaya da wuzlah *ndəhay maa sərkada *kwakwas ŋga Mawiz, aŋga fa jəkfatar sləmay, faa cəfɗafatar mey. ");
INSERT INTO mif_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ndəhay tabiya ma jəkfamar sləmay, a rəzlam maja leŋgesl aŋga, asaya, maja mey hay maaya masa aŋga ma mbəɗdatara. ");
INSERT INTO mif_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ata papaha ta mamaha ma hətmar la na, a rəzlam ga da ray a. Mamaha a ləvar: «Bəz aɗaw, ka kandar anda keɗe na, maja me? Ala ta papakw fa səpmaka, mevel ala ta ɗəsley sem.» ");
INSERT INTO mif_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A mbəɗdatara, a ləvtar: «Ka səpmaya maja me? Si ya njey daa way ŋga Papay na, ka sərmara ba daw?» ");
INSERT INTO mif_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ama a sərmara mey a, a wuɗey ŋga ləvey kwara ba. ");
INSERT INTO mif_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ta’, Yesu a samawa bama a slala *Nezeret heyey dəɓa. A cəntar mey. Ama mamaha na, fa wulkadata cek hay a keɗe tabiya daa mevel aŋga. ");
INSERT INTO mif_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu fa gəley, fa gəley. Leŋgesl fa səkwa. Aŋga maaya fa Gazlavay leŋ fa ndəhay. ");
INSERT INTO mif_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Masa *Jaŋ-Baptis ma da zla sləra aŋga na, Bay Tiber, ta key mevey kuraw a ray a zlam cay daa bay da ray bay hay daa hwayak hay ŋga *Rawm. *Pawns Pilat aŋga bay daa hwayak ŋga *Jude. *Herawt, aa bay daa hwayak ŋga *Galile. Məlmaha *Fəlep, aŋga bay da Iture ta da Tərakwanit. Lizaniyas aa bay daa hwayak ŋga Abileŋ. ");
INSERT INTO mif_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ata Han ta Kayif, ata mahura hay da ray ndəhay ma ka kwakwas ŋga Gazlavay. Daa ŋgene, Jaŋ-Baptis, bəzey ŋga *Zakari, aa da wuzlah-ley. Ta’, Gazlavay a wuzdara mey aŋga. ");
INSERT INTO mif_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Da ray ŋgene, *Jaŋ a, a pəkta slam hay tabiya masa gweegwe ta wayam ŋga Jurdeŋ. A wuztar mey ŋga Gazlavay a ndəhay, a ləvtar: «Mbəɗdamara menjey akwar, səpmara Gazlavay ta mevel pal, hətam *baptem, amba Gazlavay a mbəkdakwara mebərey akwar.» ");
INSERT INTO mif_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Cek aha ta key la anda *Izay, *ndaw ma təla mey ŋga Gazlavay zleezle, ma wuzlala daa ɗerewel ŋga Gazlavay, a ləvey: «Ndaw fa wudey da wuzlah-ley, a ləvey: Ɗiymar cəveɗ ŋgada Bay Mahura, ɗiymara cəveɗ e maaya maaya dər e. ");
INSERT INTO mif_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pəshamata lapatam hay cəpa. Rarakadamata aŋgwa hay, leŋ ɗaŋgwalay hay cəpa. Ɗiymata cəveɗ hay magəjvaɗatakaya ŋga təram dər e, saɓalamata cəveɗ maaya ba hay. ");
INSERT INTO mif_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Anda keɗe, ndəhay tabiya a hətmar Gazlavay la, ndaw ma da ləhdandakwar daa mebərey.» ");
INSERT INTO mif_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Daa masa ndəhay ga fa samawa fa Jaŋ-Baptis, amba a katar baptem na, Jaŋ-Baptis a, a ləvtar: «Hey! akwar bəza hay ŋga kucesl hay! Ma ləvkwar ka ləham la daa banay masa Gazlavay ma da handərwa a ray akwar na, wa? ");
INSERT INTO mif_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kam cek maaya, amba ndəhay a sərmara akwar ta mbəɗdamara menjey akwar sem, akwar fa səpmara Gazlavay ta mevel pal. Ka da wulkam daa mevel akwar, ka ləvam: “Papa aləkwa na, ara *Abəraham, maja ŋgene, Gazlavay a da sərfandakwar dey-ceceh.” Ka da ləvam kəne ba, maja ya fa ləvkwar fara fara, Gazlavay a gwa ŋga tərdata aŋgwa hay keɗe ŋga səkway ŋga Abəraham may. ");
INSERT INTO mif_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wure keɗe, zlamba maŋgakaya cay ŋga ŋgəmey wudez hay ta slaslalay a cəpa. Kwa wudez wura wura ma yey babəza maaya ba na, a da ŋgəmamara, a pamar awaw fa vəɗa.» ");
INSERT INTO mif_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ta’, ndəhay makustakaya aa cəfɗamara, a ləvmar: «Kaa, ya da kam na, kwara?» ");
INSERT INTO mif_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A mbəɗdatara, a ləvtar: «Ndaw masa zana aŋga hay cew daha na, ŋga vəlar pal a ndaw masa zana aŋga daa ba. Asaya, ndaw masa cek mezəmey daha na, ŋga wunkamara ta ndəhay masa cek mezəmey daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ndəhay ma cakala budaw a samawa ŋga key baptem may, aa cəfɗamara Jaŋ, a ləvam: «Bay ala, kaa ala na, ya da kam kwara?» ");
INSERT INTO mif_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A mbəɗdatara, a ləvtar: «Ka daa cəfɗam dala ŋga budaw ma fəna masa ŋgwamna maa cəfɗa ba.» ");
INSERT INTO mif_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sewje hay may, a samawa, aa cəfɗamara kəne, a ləvam: «Kaa, ala na, ya da kam kwara?» A mbəɗdatara, a ləvtar: «Ka da təɓam dala ŋga ndaw ta gədaŋ ba. Ka daa dəɗfamatar mey a ray ndəhay ba. Sasəmam da ray dala masa ata ma vəldamakwara fa mawurɓay ŋga sləra akwar gway.» ");
INSERT INTO mif_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ndəhay na, fa səkwmara cek maaya ma da key. Da ray ŋgene, kwa waawa da wuzlah ata fa wulkey daa ray aŋga, da Jaŋ a na, ara *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay heyey kwa. ");
INSERT INTO mif_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Anda keɗe, Jaŋ a ləvtar a ndəhay tabiya: «Yah na, ya kakwar baptem ta yam daada gway, ama ndaw mekele ma fənya a sawa la. Kwa ya wusa ŋga pəska zeweɗ ŋga tarak aŋga ba. Aŋga na, a da kakwar baptem ta *Mesəfney ŋga Gazlavay leŋ ta awaw. ");
INSERT INTO mif_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aŋga da gədak ta vəley mekəfey daw da har ŋga wunkey bəz-daw ta cekwesl e. Bəz-daw na, a da həla a wudeɗ aŋga. Ama cekwesl e na, a da par awaw fa vəɗa, awaw masa ma məcey ba ŋga sərmataw.» ");
INSERT INTO mif_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Anda keɗe, Jaŋ a vəltar gədaŋ a ndəhay ta mey hay mekele mekele saya, a wuztar *Mey-maaya-mawiya. ");
INSERT INTO mif_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ama Jaŋ a mbəɗar ray a Bay Herawt maja aa ma la Herawdiyat, ŋgwas ŋga məlmaha, ŋga ŋgwas aŋga, asaya, maja aa ma key cek hay mekele mekele maaya ba. ");
INSERT INTO mif_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Da ray ŋgene, Bay Herawt heyey a key cek maaya ba ma fəna saya, a kəzla Jaŋ aa fərsəne. ");
INSERT INTO mif_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Masa *Jaŋ-Baptis fa katar *baptem ŋgada ndəhay tabiya heyey na, Yesu a sawa amba a hətey baptem may. Ta’, Jaŋ-Baptis a kar baptem e. Fa dəɓa ha, Yesu a dərey daŋgay. Masa aa fa dərey daŋgay na, slam da vaɗ bəɗaŋ! a wurey. ");
INSERT INTO mif_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","*Mesəfney ŋga Gazlavay a pawa salay a ray a, a nəkey anda makurgwadakw. Ɗay a cənwa da vaɗ, a ləvey: «Kah na, Bəzey aɗaw masa yah ma wuɗa kalah. Ya faa səmey ga da ray akah.» ");
INSERT INTO mif_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Masa Yesu ma da zlar sləra aŋga na, aŋga ta mevey kwakwar maakar. Ndəhay a wulkam Yesu na, ara bəzey ŋga *Jawzef. Jawzef na, bəzey ŋga Heley, ");
INSERT INTO mif_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heley na, bəzey ŋga Matat, Matat na, bəzey ŋga Levi, Levi na, bəzey ŋga Melki, Melki na, bəzey ŋga Janay, Janay na, bəzey ŋga Jawzef, ");
INSERT INTO mif_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jawzef na, bəzey ŋga Matatiyas, Matatiyas na, bəzey ŋga Amus, Amus na, bəzey ŋga Nahum, Nahum na, bəzey ŋga Esəli, Esəli na, bəzey ŋga Nagay, ");
INSERT INTO mif_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay na, bəzey ŋga Mat, Mat na, bəzey ŋga Matatiyas, Matatiyas na, bəzey ŋga Semeyiŋ, Semeyiŋ na, bəzey ŋga Jawzek, Jawzek na, bəzey ŋga Jawda, ");
INSERT INTO mif_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jawda na, bəzey ŋga Jəwanaŋ, Jəwanaŋ na, bəzey ŋga Reza, Reza na, bəzey ŋga Zarubaabel, Zarubaabel na, bəzey ŋga Salatiyel, Salatiyel na, bəzey ŋga Neri, ");
INSERT INTO mif_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri na, bəzey ŋga Melki, Melki na, bəzey ŋga Adi, Adi na, bəzey ŋga Kwazam, Kwazam na, bəzey ŋga Elmadam, Elmadam na, bəzey ŋga Er, ");
INSERT INTO mif_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er na, bəzey ŋga Yesu, Yesu na, bəzey ŋga Eliyezer, Eliyezer na, bəzey ŋga Jəwarim, Jəwarim na, bəzey ŋga Matat, Matat na, bəzey ŋga Levi, ");
INSERT INTO mif_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","*Levi na, bəzey ŋga Simeyaŋw, Simeyaŋw na, bəzey ŋga Juda, Juda na, bəzey ŋga Jawzef, Jawzef na, bəzey ŋga Jawnam, Jawnam na, bəzey ŋga Eliyakim, ");
INSERT INTO mif_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim na, bəzey ŋga Meleya, Meleya na, bəzey ŋga Mena, Mena na, bəzey ŋga Matata, Matata na, bəzey ŋga Nataŋ, Nataŋ na, bəzey ŋga Davit, ");
INSERT INTO mif_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","*Davit na, bəzey ŋga Jese, Jese na, bəzey ŋga Awbet, Awbet na, bəzey ŋga Bəwaz, Bəwaz na, bəzey ŋga Sala, Sala na, bəzey ŋga Naasaŋw, ");
INSERT INTO mif_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasaŋw na, bəzey ŋga Aminadap, Aminadap na, bəzey ŋga Adəmiŋ, Adəmiŋ na, bəzey ŋga Arni, Arni na, bəzey ŋga Esraŋw, Esraŋw na, bəzey ŋga Fares, Fares na, bəzey ŋga Juda, ");
INSERT INTO mif_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda na, bəzey ŋga *Jakwap, Jakwap na, bəzey ŋga Izak, Izak na, bəzey ŋga Abəraham, Abəraham na, bəzey ŋga Tara, Tara na, bəzey ŋga Nahwar, ");
INSERT INTO mif_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahwar na, bəzey ŋga Seruk, Seruk na, bəzey ŋga Ragaw, Ragaw na, bəzey ŋga Pelek, Pelek na, bəzey ŋga Eber, Eber na, bəzey ŋga Sala, ");
INSERT INTO mif_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala na, bəzey ŋga Kaynam, Kaynam na, bəzey ŋga Arfazat, Arfazat na, bəzey ŋga Sem, Sem na, bəzey ŋga Nəwe, Nəwe na, bəzey ŋga Lemek, ");
INSERT INTO mif_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek na, bəzey ŋga Matuzala, Matuzala na, bəzey ŋga Henakw, Henakw na, bəzey ŋga Jaret, Jaret na, bəzey ŋga Meleliyel, Meleliyel na, bəzey ŋga Kaynam, ");
INSERT INTO mif_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam na, bəzey ŋga Enaws, Enaws na, bəzey ŋga Set, Set na, bəzey ŋga Adam, Adam a na, bəzey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Fa dəɓa ha masa *Jaŋ-Baptis ma kar *baptem la a Yesu na, Yesu a vəhwa daa wayam ŋga Jurdeŋ heyey. *Mesəfney ŋga Gazlavay aa da ray a, ta’, a handa a wuzlah-ley. ");
INSERT INTO mif_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Aa manjakaya feteɗe ɗar kwakwar məfaɗ. Bay-malula a sawa a cakay a, a jada ŋga bata amba a key cek maaya ba. Daa masa Yesu aa da wuzlah-ley a na, aŋga fa zəmey cek daa ba. Fa dəɓa ha, may a car dəɓa. ");
INSERT INTO mif_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ta’, bay-malula heyey aa guzlar, a ləvar: «Da kah Bəzey ŋga Gazlavay na, tərda aŋgwa keɗe ŋga ɗaf taw!» ");
INSERT INTO mif_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu a mbəɗdara, a ləvar: «Mawuzlalakaya daa ɗerewel ŋga Gazlavay, a ləvey: “Ndaw na, a njey ta cek mezəmey daada ba.”» ");
INSERT INTO mif_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Fa dəɓa ha, bay-malula heyey a təpda aa slam magəlkaya a vaɗ, wure ŋgene ta’, a wuzdara hwayak hay masa bay hay ma wamata da bəla cəpa. ");
INSERT INTO mif_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ta’, a ləvar: «Ya vəldakawa gədaŋ ŋga wey da ray hwayak hay a keɗe, ta zleley hay da hwaɗ a cəpa. Maja cek hay a keɗe cəpa mavəldatakaya a har aɗaw, ya gwa ŋga vəldata kwa ŋgada waawa masa yah ma wuɗey. ");
INSERT INTO mif_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Anda keɗe, da kah ma regedey fa mey aɗaw la na, cek hay a cəpa ya vəldatakawa la.» ");
INSERT INTO mif_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu a mbəɗdara, a ləvar: «Mawuzlalakaya daa ɗerewel ŋga Gazlavay, a ləvey: “Ka da ragadar na, si ŋgada Bay Gazlavay akah gway. Dərar daŋgay ŋgada Bay Gazlavay pal taava aŋga.”» ");
INSERT INTO mif_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Asaya, bay-malula a handa aa berney ŋga *Jeruzelem, a təpda aa ray ŋga *Way-mekey-kwakwas ŋga Gazlavay, ta’, a ləvar: «Da kah Bəzey ŋga Gazlavay na, jəvey daa ray ŋga way keɗe a hwayak, ");
INSERT INTO mif_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","maja mawuzlalakaya daa ɗerewel ŋga Gazlavay, a ləvey: “Gazlavay a ləvtar la a maslaŋ aŋga hay ŋga jəɗmaka.” ");
INSERT INTO mif_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mawuzlalakaya saya, a ləvey: “A sləwmaka la a har ata amba salay akah a gurzey fa aŋgwa ba.”» ");
INSERT INTO mif_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu a mbəɗdara, a ləvar: «Mawuzlalakaya daa ɗerewel ŋga Gazlavay, a ləvey: “Ka da jada Bay Gazlavay akah ba.”» ");
INSERT INTO mif_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Masa bay-malula ta hətey mey ŋga jada Yesu daa saba na, ta’, a daw, a mbəkda ŋga pas mekele. ");
INSERT INTO mif_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu a vəhwa aa hwayak ŋga *Galile, ta gədaŋ ŋga *Mesəfney ŋga Gazlavay da ray a. Daa hwayak a cəpa, ndəhay a zlamar ŋgaa guzley da ray a. ");
INSERT INTO mif_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesu fa wuzey mey ŋga Gazlavay daa way-mewuzey-mey hay ŋga Gazlavay. Ndəhay tabiya faa həmdamara. ");
INSERT INTO mif_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ta’, Yesu a daw a *Nezeret, slala masa aa ma gəley da hwaɗ a. Ta *pas meməskey-vaw, a mbəzey aa *way-mewuzey-mey ŋga Gazlavay anda aa ma daw maamandaw. A lecey, a daw fa mey ŋga ndəhay amba a jeŋgey ɗerewel ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ta’, a vəlmar ɗerewel mapaɗakaya, masa *Izay, *ndaw ma təla mey ŋga Gazlavay, ma wuzlala zleezle. A pəska ɗerewel e, a hətfey slam mawuzlalakaya ma ləvey: ");
INSERT INTO mif_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Mesəfney ŋga Bay Gazlavay aa da ray aɗaw, Bay Gazlavay ta walaya la amba ya wuzdatara *Mey-maaya-mawiya ŋgada masa-viya hay. A slərdiwa amba ya ləvtar a ndəhay majəwtakaya dasi har ŋga bay-malula na, Gazlavay ta pəskata sem. A slərdiwa ŋga wurey dey ŋga wulaf hay, ŋga ləhey ndəhay dasi har ŋga masa-gəra ata hay. ");
INSERT INTO mif_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","A slərdiwa amba ya ləvtar ɗar masa Bay Gazlavay ma da wuzdərwa maaya aŋga a ray ndəhay na, ta wuswa cay.» ");
INSERT INTO mif_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Fa dəɓa ha, paɗ! paɗ! a paɗa ɗerewel e heyey, ta’, a vəldara a ndaw ma ka sləra daa way a. A njey fa mey ata ŋga wuzey mey a. Ndəhay cəpa daa way a, fa nəkmara. ");
INSERT INTO mif_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesu a zlar ŋgaa guzltar dəɓa, a ləvey: «Mey mawuzlalakaya masa tasana akwar ma cəndamara keɗe na, mey a ta key cay wure keɗe ŋgada akwar.» ");
INSERT INTO mif_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ndəhay cəpa a ləvam da wuzlah ata: «Mey masa aləkwa ma cəndakwa fa Yesu keɗe na, maaya.» A rəzlam da ray mey aŋga hay maaya masa aŋga maa guzldata, ta’, a ləvam: «Haya, ara na, bəzey ŋga *Jawzef, ba diya?» ");
INSERT INTO mif_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Da ray ŋgene, Yesu a ləvtar: «Fara fara ka daa guzlam mey-meŋgey da ray aɗaw, ka ləvam: “Ndaw ma səra ray ŋga slalak, mbəlda ray akah!” Anda meləvey ka da ləvam: “Ala ma cəndamara sləra akah hay masa kah ma kata da Kapernayum la cəpa. Yaw, ka kəne da slala akah feɗe may.”» ");
INSERT INTO mif_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ta’, Yesu aa guzltar saya, a ləvey: «Ya fa ləvkwar fara fara, kwa ndaw ma təla mey ŋga Gazlavay wura wura na, fa təɓmara maaya maaya daa hwayak masa aa ma yawa da hwaɗ a na, daa ba. ");
INSERT INTO mif_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Wulkam da ray *Eli, ndaw ma təla mey ŋga Gazlavay zleezle. Daa masa aŋga da bəla na, mevey maakar ta kiya maakwaw, var ta pawa daa ba. May mahura ta key la daa hwayak ŋga *Israyel cəpa. Ya fa ləvkwar fara fara, daa ŋgene, ŋgwas-vagay hay ga daha daa hwayak a, ");
INSERT INTO mif_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ama Gazlavay ta slərda Eli fa ŋgwas-vagay hay daa hwayak ŋga Israyel ŋga jənta daa ba səlak. A slərda na, si fa ŋgwas-vagay masa *Jəwif ba ma njey da slala Sarəpta daa hwayak ŋga Sidaŋw. ");
INSERT INTO mif_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Asaya, wulkam da ray Elize, ndaw ma təla mey ŋga Gazlavay zleezle. Daa masa aŋga da bəla na, maasəkula hay ga daa hwayak ŋga Israyel daha, ama kwa ta pərey ndaw pal dasi ata ŋga mbəley daa maasəkula ha daa ba. A pərey na, si Naamaŋ, ndaw Siri gway.» ");
INSERT INTO mif_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Masa ndəhay daa way-mewuzey-mey ŋga Gazlavay heyey ma cəndamara mey a na, ata tabiya, mevel a catar ga da ray Yesu. ");
INSERT INTO mif_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ta’, a lacam, a ɗaɗamara, a badamara da wuzlah-way. A handamara aa mey-zeleŋ, amba a təvdamara ŋgada hwayak. ");
INSERT INTO mif_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ama Yesu pat! a bey la da wuzlah ata, ndal! madaw aŋga. ");
INSERT INTO mif_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Fa dəɓa ha, Yesu a daw a Kapernayum daa hwayak ŋga *Galile. Feteɗe faa sərkadata ndəhay daa *way-mewuzey-mey ŋga Gazlavay ta *pas meməskey-vaw. ");
INSERT INTO mif_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ndəhay a, a rəzlam da ray meesərkedey aŋga ha, maja aa guzley na, ta gədaŋ masa Gazlavay ma vəldara. ");
INSERT INTO mif_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Daa way-mewuzey-mey a ŋgene, ndaw daha, aa ta malula da ray. A zlar mewudey ta gədaŋ, a ləvey: ");
INSERT INTO mif_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Haya, Yesu, ndaw *Nezeret, walay akah ta ala malula hay me? Ka sawa ŋgaa zəɗdandar daw? Ya səra fara fara, kah na, ndaw ŋga Gazlavay, masa aa ma slərdərwa ŋga key sləra aŋga.» ");
INSERT INTO mif_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu aa bəcar a malula da ray ndaw aha, a ləvar: «Njey teete. Bey da ray ndaw keɗe.» Malula da ray ndaw a heyey dac! a təɗda ndaw a, a hwayak fa mey ŋga ndəhay tabiya, a bey da ray ndaw aha, kwa ta kar cek daa ba. ");
INSERT INTO mif_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ndəhay cəpa feteɗe heyey a rəzlam, aa guzlam da wuzlah ata, a ləvam: «Haya! mey keɗe na, ara səkway ŋga mey wura, masa ndaw aha a təktar ɗay a malula hay ŋga bam da ray ndəhay keɗe na!» ");
INSERT INTO mif_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Da ray ŋgene, sləmay ŋga Yesu fa zəley kwa daa wura daa wura cəpa daa hwayak a. ");
INSERT INTO mif_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu a bey daa *way-mewuzey-mey ŋga Gazlavay, a daw a way *Simaŋw. Mamaŋ ŋga ŋgwas ŋga Simaŋw a, vaw fa car, awaw fa vaw ga. Da ray ŋgene, aa cəfɗamara Yesu ŋga mbəlda. ");
INSERT INTO mif_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A daw a gəɓey a ray a, ta’, aa bəcey amba macay a, a mbəkda ŋgwas aha. Macay a, mbak! a mbəkda, awaw fa vaw heyey daa saba. Wure ŋgene, ŋgwas aha pərta! a lecey, ta’, a vəltar cek mezəmey. ");
INSERT INTO mif_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Fa dəɓa ha pas ma kəzley la na, ndəhay tabiya da slala ha masa ndəhay ta macay hay da way ata hay daha, kwa macay hay wura wura, a handamatərwa fa Yesu. A patar har pal pal tabiya a ray, a mbəldata. ");
INSERT INTO mif_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Malula hay ga a bam da ray masa-macay hay a, a wudam, a ləvam: «Kah Bəzey ŋga Gazlavay.» Ama Yesu aa bəctar a malula hay a, a təkta ŋgaa guzley maja a sərmara aŋga *Kəriste. ");
INSERT INTO mif_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Slam ma wurey la na, Yesu a bey da wuzlah-way, a daw aa slam masa ndəhay da hwaɗ a daa ba. Ndəhay ga fa səpmara, ta’, a hətmar. Masa ata ma hətmar la na, a wuɗam amba Yesu a njey ta ata, a mbəkdata ba. ");
INSERT INTO mif_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ama Yesu a ləvtar: «Si ya daw a slala hay mekele may ŋga wuzey *Mey-maaya-mawiya da ray mewey ŋga Bay Gazlavay da ray ndəhay, maja Bay Gazlavay a slərdiwa na, ŋga key sləra ha kəne.» ");
INSERT INTO mif_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ta’, Yesu a daw a pəkta slala hay a, a wuzey mey ŋga Gazlavay daa way-mewuzey-mey hay ŋga Gazlavay mekele mekele daa hwayak ŋga *Jude. ");
INSERT INTO mif_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pas laŋgar daha, Yesu, aŋga da mey dəhwa ŋga Genezeret. Ndəhay ga makustakaya, fa njanjərɗam vaw ŋgada cakay a, maja a wuɗam a cəndamara mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kwambiwal hay cew daha da mey dəhwa ha. Ndəhay ma kərza ewet, ata da hwaɗ a daa saba, fa pərmata *tabaw ata hay. Yesu a hətatar kwambiwal hay a. ");
INSERT INTO mif_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ta’, a təpey aa kwambiwal ŋga ndaw mezəley *Simaŋw. Aa cəfɗa Simaŋw ha ŋga ŋgəchada kwambiwal a nekəɗey ŋgada wuzlah yam. Masa Simaŋw ma ŋgəchada kwambiwal a la na, Yesu ta’, a njey ta njey a hwaɗ a, fa wuzdatara mey ŋga Gazlavay a ndəhay da mey dəhwa ha. ");
INSERT INTO mif_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Fa dəɓa ha masa aŋga ma wuzdatara mey ŋga Gazlavay la na, a ləvar a Simaŋw: «Ŋgəchada kwambiwal akah aa slam masa yam da hwaɗ a seleleŋ. Feteɗe, akwar ta mandala akah hay, kəzlamata tabaw akwar hay aa yam a, ka hətam ewet la.» ");
INSERT INTO mif_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simaŋw a mbəɗdara, a ləvar: «Bay ala, tavaɗ tavaɗ keɗe, ala ta gəram la daa ewet e, ama kwa ya ta hətam daa ba səlak. Yaw, da ara kah ma ləvya na, ya kəzlamata tabaw hay a, aa yam a cəŋga.» ");
INSERT INTO mif_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ta’, a kəzlamata tabaw ata hay aa yam, wure ŋgene, a kərzamawa ewet ga daa yam a. Tabaw hay a, a zlamar ŋga ŋgərey maja ewet ga kalah. ");
INSERT INTO mif_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Anda keɗe, a gəvcamatərwa mandala ata hay daa kwambiwal mekele ŋga jənmata. Mandala ata hay a, a samawa, a rəhdamata kwambiwal hay cewete ta ewet, haa kwambiwal hay a, a wuɗam ŋga ndəkwam asi yam. ");
INSERT INTO mif_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Ata Simaŋw *Piyer ta mandala aŋga hay tabiya, mandərzay a katar maja ewet ga masa ata ma kərzamara ha. Masa Simaŋw aha ma hətar maazla keɗe na, a regedey fa mey ŋga Yesu, a ləvar: «Bay Mahura, maaya na, ya ŋgəchey la da cakay akah, maja yah na, ndaw ta mebərey.» ");
INSERT INTO mif_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ata *Jak ta *Jaŋ, bəza hay ŋga Zebede, ma kam sləra bama ta ata Simaŋw, mandərzay a katar may. Da ray ŋgene, Yesu a ləvar a Simaŋw: «Ka zlurey ba, dəga tasana ka da zəlwa ndəhay aa cəveɗ ŋga Bay Gazlavay anda kah ma kərzey ewet keɗe.» ");
INSERT INTO mif_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ta’, a ŋgəchadamata kwambiwal ata hay a rav-zazay, mbak! a mbəkdamata cek ata hay tabiya, a diyam asi Yesu. ");
INSERT INTO mif_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Fa dəɓa ha, Yesu aa da slala laŋgar daha. Ndaw daha maasəkula fa vaw zlap zlap. Ndaw aha a hətar Yesu na, ta’, a daw a regedey fa mey aŋga. A kar ambahw, a ləvar: «Bay aɗaw, da ka wuɗey na, ka gwa ŋga pərya daa maasəkula aɗaw keɗe.» ");
INSERT INTO mif_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu tal! a təlda har aŋga, a gəsfar, a ləvar: «Ya wuɗey amba maasəkula akah a pərey. Tərey ndaw mapərkaya dəɓa!» Wure wure ŋgene, maasəkula fa ndaw aha daa saba. ");
INSERT INTO mif_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ta’, Yesu a kəta, a ləvar: «Ka da wuzda cek masa yah ma kakawa keɗe kwa a ndaw ba. Ama daw fa *ndaw ma ka kwakwas ŋga Gazlavay, amba a nəkaka. Fa dəɓa ha, vəlar cek a Gazlavay anda *kwakwas ŋga Mawiz ma ləvey, ŋga wuzey a ndəhay, maasəkula fa vaw akah daa saba.» ");
INSERT INTO mif_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ama ndəhay na, fa kadamara mey da ray Yesu ta gədaŋ ta gədaŋ cəŋga. Da ray ŋgene, ndəhay ga a samawa fa vəɗa, a kusam, amba a jəkam sləmay fa mey masa aa maa guzley, asaya, amba a mbəldata masa-macay hay. ");
INSERT INTO mif_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kwa ndəhay fa samawa ga na, Yesu a njey da cakay ata mandaw mandaw ba, ama a bey la da wuzlah ata, a daw aa slam masa ndəhay da hwaɗ a daa ba, amba a dərey daŋgay a Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pas pal daha, Yesu faa sərkadata ndəhay. *Fariza hay ta *ndəhay maa sərkada kwakwas ŋga Mawiz manjatakaya feteɗe may. A samawa da slala hay mekele mekele da *Galile ta da *Jude, leŋ daa berney ŋga *Jeruzelem. Bay Gazlavay a vəlar gədaŋ a Yesu ŋga mbəldata masa-macay hay. ");
INSERT INTO mif_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ndəhay daha, a samawa, a handamawa ndaw maahəlɓakaya manakaya da ray ɓeɓele. A səpam cəveɗ amba a mbəzdamara aa way masa Yesu aa da hwaɗ a, amba a pamara fa mey aŋga, ");
INSERT INTO mif_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ama a hətam cəveɗ ba maja ndəhay ga kalah. Anda keɗe, a təpam aa ray ŋga way a, a wuram slam daa ray ŋga way a, a təldamara ndaw maahəlɓakaya kaa heyey da ray ɓeɓele aŋga ha ta laza, a wuzlah ndəhay makustakaya ga fa mey ŋga Yesu daa way a. ");
INSERT INTO mif_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Masa Yesu ma nəka ndəhay a, fa təɓmara aŋga ta gədaŋ ŋga mbəlda ndaw ata na, ta’, a ləvar a ndaw maahəlɓakaya heyey: «Jam aɗaw, ya fa ləvka mebərey da ray akah daa saba.» ");
INSERT INTO mif_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ndəhay maa sərkada kwakwas ŋga Mawiz ta Fariza hay heyey a cəndamara mey keɗe na, a wulkam daa ray ata, a ləvam: «Ara səkway ŋga ndaw wura ma pa ray aŋga ŋga Gazlavay keɗe, na! Ma gwa ma mbəkda mebərey ŋga ndaw na, wa? Si Gazlavay pal taava aŋga ma gwa ma mbəkda mebərey ŋga ndaw, ba diya?» ");
INSERT INTO mif_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ama Yesu ta səra mewulkey ata sem, aa cəfɗata, a ləvtar: «Ka wulkam anda keɗe, maja me? ");
INSERT INTO mif_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ya gwa ya ləvar: “Mebərey akah daa saba”, da daa ba, ya gwa ya ləvar: “Sləkɗey, daw ta salay akah.” Dasi mey hay cewete keɗe na, masa ta banay ŋga ləvey ŋgada yah na, wura? ");
INSERT INTO mif_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yaw, ya wuɗey amba ka sərmara yah, *Bəz ŋga Ndaw, yah ta gədaŋ ŋga mbəkey mebərey ŋga ndəhay da bəla.» Anda keɗe, Yesu ta’, a ləvar a ndaw maahəlɓakaya heyey: «Ehe, ya fa ləvka: “Sləkɗey, la ɓeɓele akah, daw a way.”» ");
INSERT INTO mif_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wure wure ŋgene, ndaw aha a sləkɗey, a lecey fa dey ata tabiya, a la ɓeɓele aŋga heyey, ta’, a daw a way ta mehəlmey Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ndəhay tabiya feteɗe a rəzlam. A həlmamara Gazlavay ta meney ray. A ləvam: «Cek masa ŋga menjey aləkwa, ya ta hətkwa daa ba na, ya ta hətkwar la tasana dəɓa.» ");
INSERT INTO mif_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Fa dəɓa ha masa Yesu ma ka maazla keɗe la, a bawa daa way a, a daw, a da nəkey dey na, a ray *ndaw ma cakala budaw mezəley *Levi. Aŋga manjakaya fa key sləra daa slam mecekeley budaw. Ta’, Yesu aa guzlar, a ləvar: «Sawa, səpya.» ");
INSERT INTO mif_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Da ray ŋgene, Levi a, pərta! a sləkɗey, a mbəkdata cek aŋga hay tabiya, a daw asiya. ");
INSERT INTO mif_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Fa dəɓa ha nekəɗey, Levi a kar gwagway mahura ŋgada Yesu da way aŋga. Ndəhay ma cakala budaw ta ndəhay mekele makustakaya ga feteɗe, a zəmamara ɗaf ŋga gwagway a bama. ");
INSERT INTO mif_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","*Fariza hay ta *ndəhay maa sərkada kwakwas ŋga Mawiz da wuzlah ata, aa ŋguram mey, a ləvmatar a *gula hay ŋga Yesu: «Ka zəmam ɗaf ta ndəhay ma cakala budaw leŋ ta ndəhay ma zləɓa kwakwas ŋga Mawiz na, kwara?» ");
INSERT INTO mif_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu a mbəɗdatara, a ləvtar: «Ndəhay masa ata wurwer na, mey ata ta ndaw ma vəlda slalak daa ba. Ama ma wuɗey mey ŋga ndaw ma vəlda slalak na, si ndəhay masa-macay hay gway. ");
INSERT INTO mif_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yaw, ndəhay ma wulkam ata ndəhay maaya fa mey ŋga Gazlavay na, Gazlavay ta slərdiwa ŋga zəlta daa ba, ama a slərdiwa na, ŋga zəley ndəhay masa ta mebərey amba a mbəɗdamara menjey ata, a səpmara Gazlavay ta mevel pal.» ");
INSERT INTO mif_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","*Fariza hay heyey a ləvmar a Yesu: «Gula hay ŋga *Jaŋ-Baptis ta pas laŋgar fa kam *daliyam, fa dəram daŋgay, asaya, gula ala hay fa kamara kəne may. Ama gula akah hay na, a zəmam cek, a sam cek mandaw mandaw na, maja me?» ");
INSERT INTO mif_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu a mbəɗdatara ta mey-meŋgey, a ləvey: «Da ndaw a zəlwa ndəhay aa mekey məlak ŋga kwakwa ŋga zəmey cek na, ndəhay a, a gwamara a kam daliyam daa masa zel-kwakwa ha aa da cakay ata daw? A kam daliyam ba səlak. ");
INSERT INTO mif_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama pas a, a sawa la, masa ata ma da kərzamara zel-kwakwa ha. Daa ŋgene dəɓa na, a kam daliyam la.» ");
INSERT INTO mif_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Fa dəɓa ha Yesu a ŋgatara mey a saya ta zana, a ləvey: «Kwa ndaw ma ŋgərey zana mawiya ŋga ɗəpey zana magurma na, daa ba. Da a ka kəne na, ta nəsa zana mawiya sem, zana ha fa da cəmam ta magurma daa ba. ");
INSERT INTO mif_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Asaya, ndaw a gwa ŋga zlərey wuzam meedeɗek e aa kwene-kwene magurma ba. Da a zləra a hwaɗ a na, wuzam a, a məsley, a ŋgəra kwene-kwene he la. Wuzam a, a mbəɗey la, asaya, kwene-kwene he a nəsey la. ");
INSERT INTO mif_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Si ka zləra wuzam meedeɗek e aa kwene-kwene mawiya. ");
INSERT INTO mif_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Da ndaw fa sey wuzam maməslkaya na, a wuɗey ŋga sey meedeɗek e saba, maja a wulkey wuzam maməslkaya na, a fəna meedeɗek e.» ");
INSERT INTO mif_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ta *pas meməskey-vaw daha, ata Yesu ta gula aŋga hay a diyam taa ley ŋga cek anda daw . Gula aŋga hay heyey a həɓam cek aha, a babərmara, aa mbəɗmara. ");
INSERT INTO mif_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Maja ŋgene, ndəhay da wuzlah *Fariza hay a ləvmatar: «Akwar fa kam cek matəkakaya daa *kwakwas ŋga Mawiz ta pas meməskey-vaw na, maja me?» ");
INSERT INTO mif_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu a mbəɗdatara, a ləvtar: «Akwar ta jaŋgamara daa ɗerewel ŋga Gazlavay cek masa *Davit ma ka zleezle na, daa ba daw? Ta pas laŋgar daha, ata Davit ta ndəhay aŋga hay, may fa catar, ama cek mezəmey fa ata daa ba. ");
INSERT INTO mif_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Maja ŋgene Davit e a mbəzey aa way ŋga Gazlavay, a təɓwa peŋ masa mavəldakaya ŋgada Gazlavay, ta’ a zəmey, asaya, a vəltar a ndəhay aŋga hay may. Ama, peŋ e na, kwakwas ŋga Mawiz a vəley cəveɗ a ndəhay tabiya ŋga zəmamara ba, si ndəhay ma ka kwakwas ŋga Gazlavay gway.» ");
INSERT INTO mif_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu aa guzltar saya, a ləvtar: «Ma wey da ray pas meməskey-vaw na, ara yah, *Bəz ŋga Ndaw.» ");
INSERT INTO mif_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ta *pas meməskey-vaw daha saya, Yesu a daw aa *way-mewuzey-mey ŋga Gazlavay. Ta’, aa sərkadata ndəhay daa way a. Ndaw daha feteɗe, har-zəmay maməckaya. ");
INSERT INTO mif_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","*Ndəhay maa sərkada kwakwas ŋga Mawiz ta *Fariza hay, ata feteɗe may. Fa jəɗmara Yesu da a da mbəley ndaw ta pas meməskey-vaw kwa. A jəɗmara anda keɗe na, amba a hətam mey ŋga kərza Yesu. ");
INSERT INTO mif_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ama Yesu a səra mewulkey ata. Da ray ŋgene, aa guzlar a ndaw masa har maməckaya heyey, a ləvar: «Sləkɗey, lecey fa mey ŋga ndəhay tabiya.» Ndaw aha, ta’, a sləkɗey, a lecey. ");
INSERT INTO mif_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Fa dəɓa ha, Yesu aa guzltar a ndəhay ma jəɗmara heyey, a ləvtar: «Yaw, ya wuɗey yaa cəfɗakwar, kwakwas aləkwa a ləvey na, kwara? Ta pas meməskey-vaw na, aləkwa ta cəveɗ ŋga key maaya a ndaw daw, da daa ba, ŋga key maaya ba daw? Aləkwa ta cəveɗ ŋga ləhey ndaw daa meməcey daw, da daa ba, ŋga mbəkey ndaw ŋga məcey daw?» ");
INSERT INTO mif_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ta’, Yesu a nəkta tabiya pal pal ɗagay, fa dəɓa ha, aa guzlar a ndaw heyey, a ləvar: «Təldərwa har a.» Tal! a təldara har a. Har a, ta’, a ɗiyey aa slam a. ");
INSERT INTO mif_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ama Fariza hay ta ndəhay maa sərkada kwakwas ŋga Mawiz heyey na, mevel a catar ga. A zlamar mesley yawa da wuzlah ata, a ləvam: «Ya da kadakwa ndaw Yesu kaa na, kwara?» ");
INSERT INTO mif_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Daa ɗar hay a ŋgene, Yesu a daw a aŋgwa ŋga dərwa daŋgay. Feteɗe tavaɗ tavaɗ aŋga fa dərey daŋgay a Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Masa slam ma wurey cay na, ta’, a zəlta gula aŋga hay a cakay a. A weley ndəhay kuraw a ray a cew da wuzlah ata, a pata ŋga ndəhay aŋga hay meslərey. ");
INSERT INTO mif_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","A pey ŋga ndəhay meslərey a na, *Simaŋw, ndaw masa aa ma par mezəley *Piyer heyey, ta məlmaha *Andəre, *Jak, *Jaŋ, *Fəlep, *Bartelemey, ");
INSERT INTO mif_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","*Matiye, *Tuma, Jak bəzey ŋga Alfe, Simaŋw, ndaw da wuzlah ndəhay ma wuɗam ŋga ləhdamata ndəhay ata hay dasi har ŋga masa-gəra ata hay, ");
INSERT INTO mif_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jud bəzey ŋga Jak, ta Juda Iskariyawt ndaw ma vəlda Yesu a har masa-gəra aŋga hay. ");
INSERT INTO mif_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Fa dəɓa ha, Yesu a pawa salay daa aŋgwa ta ndəhay aŋga hay meslərey. A lacam aa papalah aa slam masa ndəhay aŋga hay siya hay ga da hwaɗ a. Ndəhay mekele ga feteɗe daha a samawa daa hwayak ŋga *Jude. Kwa daa berney ŋga *Jeruzelem ta samawa la may. Asaya, ndəhay siya a samawa daa berney ŋga Tir ta ŋga Sidaŋw, berney hay masa da mey-bəlay. ");
INSERT INTO mif_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ndəhay a ŋgene a samawa ŋga cəney mey ŋga Yesu, asaya, a samawa amba Yesu a mbəldata daa macay ata hay. Da wuzlah ndəhay a ŋgene na, ndəhay ta malula da ray daha fa səram banay. Yesu ta’, a ɓəlta malula da ray ndəhay a. ");
INSERT INTO mif_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ndəhay tabiya a səpam cəveɗ ŋga gəsey fa Yesu maja gədaŋ daa vaw aŋga fa bawa ŋga mbəldata ndəhay tabiya. ");
INSERT INTO mif_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Masa Yesu ma mbəldata masa-macay hay cay na, a mbəɗey dey ŋgada fa ndəhay aŋga hay, a ləvtar: «Akwar masa-viya hay, maaya ŋga Gazlavay aa da ray akwar maja Bay Gazlavay fa wey da ray akwar fara fara. ");
INSERT INTO mif_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Akwar masa may fa cakwar wure keɗe, maaya ŋga Gazlavay aa da ray akwar maja Gazlavay a rəhdakwar la. Akwar masa fa təwam wure keɗe, maaya ŋga Gazlavay aa da ray akwar maja kaa saŋgəram la. ");
INSERT INTO mif_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Da ndəhay fa rəsmakwar, fa mbəɗmakwar dəɓa, fa cəɗmakwar, asaya, faa guzlam mey hay maaya ba a ray akwar, maja akwar gula aɗaw hay, yah, *Bəz ŋga Ndaw na, maaya ŋga Gazlavay aa da ray akwar. ");
INSERT INTO mif_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Da masa ndəhay a fa kamakwar anda keɗe na, sasəmam, jəvam ta meeməlkey maja Gazlavay a pəlkwara mawurɓay akwar la maaya maaya da gazlavay da vaɗ. Papaŋ ŋga papa ata hay a sərdamata banay ta ndəhay ma təla mey ŋga Gazlavay zleezle na, kəne. ");
INSERT INTO mif_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ama akwar masa-zleley hay na, banay a sawa la a ray akwar maja akwar ta zəmamara wiya akwar cay wure keɗe. ");
INSERT INTO mif_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Akwar masa ma rəham sem wure keɗe, banay a sawa la a ray akwar, maja may a cakwar la. Akwar masa faa saŋgəram wure keɗe, ka da njam daa banay, ka təwam la. ");
INSERT INTO mif_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","«Akwar masa ndəhay faa həmdamakwar wure keɗe, banay a sawa la a ray akwar. Ara anda keɗe papaŋ ŋga papa ata hay zleezle maa həmdamata ndəhay ma təla mey ta membərzley.» ");
INSERT INTO mif_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesu a ləvtar saya: «Wure keɗe ya fa ləvkwar, akwar ndəhay masa ma jəkam sləmay fa mey aɗaw: Wuɗmata masa-gəra akwar hay, kamatar maaya a ndəhay masa ma ŋgəldamakwar ba, ");
INSERT INTO mif_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","pəsmatar mey a ndəhay masa ma nəsmakwar, dəram daŋgay maja ndəhay ma sərdamakwar banay. ");
INSERT INTO mif_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Da ndaw a kəɗka a cakay baazlam na, mbəɗdara cakay laŋgar saya. Da ndaw a lakawa dawura akah na, mbəkda ŋga la, vəldara ɗeŋ-kece saya. ");
INSERT INTO mif_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kwa waawa maa cəfɗafaka cek na, vəlar. Da ndaw ta ley cek la fa kah na, ka daa cəfɗa həz-hez ba. ");
INSERT INTO mif_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Wure keɗe, kamatar cek maaya a ndəhay, anda akwar ma wuɗam ŋga kamakwara maaya kəne may. ");
INSERT INTO mif_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Da ka wuɗam ndəhay ma wuɗmakwar daada gway na, ka wulkam Gazlavay a kakwar maaya la maja daw? Maja kwa ndəhay masa ta mebərey na, fa wuɗmata ndəhay masa ma wuɗmata kəne. ");
INSERT INTO mif_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Da ka kam cek maaya ŋgada ndəhay masa ma kamakwar maaya gway na, ka wulkam Gazlavay a kakwar maaya la maja daw? Maja kwa ndəhay masa ta mebərey na, fa kamara kəne may. ");
INSERT INTO mif_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yaw, da ka vəlam cek hay a ndəhay masa ka wulkam wara a vəhdamakwara gway na, Gazlavay a vəlkwar cek maaya la maja daw? Maja kwa ndəhay masa ta mebərey na, fa vəlmatar cek hay a ndəhay masa wara a vəhdamatara kəne. ");
INSERT INTO mif_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ama akwar na, wuɗmata masa-gəra akwar hay, kamatar maaya, vəlmatar cek a ndəhay masa ma gwamara ŋga vəhdamakwara ba. Da akwar fa kamara anda keɗe na, Bay Gazlavay da vaɗ a pəlkwara mawurɓay akwar la ga, a tərdakwar la ŋga bəz aŋga hay, maja aŋga na, fa sərey dey-ceceh fa ndəhay masa ma kam suse ba, leŋ fa ndəhay malamba hay. ");
INSERT INTO mif_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kam maaya a ndəhay anda Papa aləkwa Bay Gazlavay ma key maaya a ndəhay.» ");
INSERT INTO mif_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesu aa guzltar saya, a ləvtar: «Ka da wulkam daa mevel akwar, ka ləvam,“Anja manaŋ ŋgaa zəɗey maja mebərey aŋga na” kəne ba, maja Bay Gazlavay a daa zəɗdakwar maja mebərey akwar kəne may. Ka da mbəɗmatar ray a ndəhay ba, anda keɗe Bay Gazlavay a mbəɗkwar ray daa ba may. Mbəkdamatara mebərey ŋga ndəhay, Gazlavay a mbəkdakwara mebərey akwar la kəne may. ");
INSERT INTO mif_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vəlam cek a ndəhay, Gazlavay a vəlkwar la kəne. A da kwiykwar ga aa gabal akwar mahura, a rəɗkwara, aa jəkakwara haa a rəhey, siya mbak. Bay Gazlavay a da wakwara cek ta daram masa akwar ma wamatara a ndəhay mekele may.» ");
INSERT INTO mif_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Fa dəɓa ha, Yesu aa guzltar ta mey-meŋgey saya, a ləvtar: «Ndaw-wulaf a gwa ŋga ɗaɗa ndaw-wulaf cəla daw? Da ndaw-wulaf a ɗaɗa wulaf cəla na, ata cewete a təɗam la aa vəgeɗ. ");
INSERT INTO mif_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yaw, ndaw maa sərkey na, a səra cek a fəna ndaw maa sərkada ba. Ama da ndaw a taa sərkey la maaya maaya na, aŋga anda ndaw maa sərkada ha gway.» ");
INSERT INTO mif_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ta’, Yesu a ŋgey mey mekele saya, a ləvey: «Ka nəkey dey fa guzer daa dey ŋga məlmakw, ama hwadam mahura masa daa dey akah na, ka wulkey da ray a ba na, kwara? ");
INSERT INTO mif_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ka gwa ŋga ləvar ŋgada məlmakw, “Məlma aɗaw, ɗagay ya lakawa guzer daa dey akah la”. Anja kah na, hwadam mahura daa dey akah daha, ama ka hətar ba na, kwara? Kah, ndaw masa ta neneh cew! La hwadam daa dey akah la ɗagay, amba ka hətar dey njəɗ-njeɗ ŋga ley guzer daa dey ŋga məlmakw.» ");
INSERT INTO mif_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesu a ləvtar saya: «Fara fara, wudez masa maaya na, a yey babəza maaya ba na, daa ba. Yaw, wudez masa fa ɓetey ta ɓetey na, a yey babəza maaya na, daa ba may. ");
INSERT INTO mif_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kwa wudez wura wura a da sərey na, fa babəza ha. Anda keɗe, ka gwa ŋga ŋgəley səkeɗ fa manjaraf ba. Ka gwa ŋga ŋgəley gudav fa bəz-tak ba. ");
INSERT INTO mif_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ndaw maaya na, fa wuzdərwa cek masa maaya daa mevel aŋga maaya. Ndaw malamba may, fa wuzdərwa cek maaya ba daa mevel aŋga maaya ba. Fara fara, mey masa ndaw maa guzlda na, fa wuzdərwa cek masa maɓadakaya daa mevel aŋga.» ");
INSERT INTO mif_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesu a ləvtar: «Ka zəlmaya “Bay Mahura, Bay Mahura” ama ka kamara cek anda yah ma ləvkwar ba na, maja me? ");
INSERT INTO mif_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wure keɗe amba ya wuzdakwara kwa waawa ma sawa fa yah, ma jəkey sləmay fa mey aɗaw, ma ka cek anda mey a la na, ");
INSERT INTO mif_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ya wa ndaw aha ta ndaw ma wuɗey ŋga ləmey way, ma zləɗa salay ŋga way a maaya maaya kasl fa pəraɗ. A pa salay a, a ray a. Pas masa var ta pawa la, wayam a lawa, a zləra way a, ama a gwa ŋga bəzla ba maja salay ŋga way a mapakaya maaya da ray pəraɗ. ");
INSERT INTO mif_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ama ndaw ma cənda mey aɗaw, ma ka cek anda mey a daa ba na, ya wa ta ndaw ma pey salay ŋga way manjar ŋga zləɗey. Pas masa var ta pawa la, wayam a lawa, a zləra way a, way a kərep! a bəzley cəpa.» ");
INSERT INTO mif_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Masa Yesu ma wuzdatara mey aŋga cay tabiya a ndəhay na, ta’, a daw a Kapernayum. ");
INSERT INTO mif_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Feteɗe, ndaw Rawma daha, aŋga mahura ŋga sewje hay temere. Ndaw a ŋgene, a wuɗa madərlam aŋga daha kalah. Ama madərlam a, vaw fa car ga, fa da məcey. ");
INSERT INTO mif_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Masa ndaw a ma cənda mey da ray Yesu na, ta’, a slərey ndəhay mahura hay ŋga *Jəwif hay da slala ha ŋgene fa Yesu ŋgaa cəfɗamərwa ŋga sawa amba a mbəlda madərlam aŋga ha. ");
INSERT INTO mif_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ndəhay mahura hay a, a wusam fa Yesu, a kamar ambahw, a ləvmar: «Maaya na, ka jəna mahura ŋga sewje hay a. Ara ndaw maaya ŋga jəney, maja a wuɗndakwar aləkwa Jəwif hay kalah, ara aŋga ma ləmndakwara *way-mewuzey-mey ŋga Gazlavay feɗe.» ");
INSERT INTO mif_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Masa Yesu ma cənda mey a la na, ta’, a diyam bama. A wusam gweegwe ta way ŋga mahura ŋga sewje hay heyey na, mahura ŋga sewje hay a, a slərey jam aŋga hay fa Yesu ŋga ləvmar: «Mahura ŋga sewje hay a ləvey: “Bay aɗaw, ka da gərwa vaw ŋga sawa saba, maja ya wusa amba ka mbəzey a way aɗaw ba. ");
INSERT INTO mif_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Maja ŋgene, ya nəka na, ya wusa ŋga wusey fa mey akah ba. Ama, da ka ta ləvey mey pal la na, madərlam aɗaw a mbəley la. ");
INSERT INTO mif_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ya ləvka anda keɗe maja yah na, sewje hay mahura da ray aɗaw daha, asaya, yah mahura da ray sewje hay mekele may. Da ya ləvar ŋgada sewje laŋgar “daw”, a daw. Da ya ləvar ŋgada ndaw laŋgar “sawa”, a sawa. Da ya ləvar ŋgada beke aɗaw “ka sləra keɗe”, a ka.» ");
INSERT INTO mif_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Masa Yesu ma cənda mey a keɗe la na, a mbafar ara mey ba. A mbəɗey dey fa dəɓa ŋgada fa ndəhay ma diyam asiya, a ləvtar: «Ya fa ləvkwar, fara fara kwa ya ta hətey ndaw ma paya ŋga ndaw aŋga fara fara anda ndaw keɗe daa ba səlak, kwa da wuzlah səkway aɗaw hay *Israyel hay, ya ta hətey daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ndəhay masa mahura ŋga sewje hay ma slərdata heyey na, a vəhmawa a way, a hətfamar madərlam a, vaw fa car daa saba. ");
INSERT INTO mif_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Fa dəɓa ha, Yesu a diyam ta gula aŋga hay leŋ ta ndəhay mekele mekele ga a slala Nayiŋ. ");
INSERT INTO mif_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Masa gweegwe fa da mbəzam a slala ha na, a cam ray ta ndəhay fa lamawa vagay ŋga bəzey ŋgadaa cəvay. Ara bəzey ŋga ŋgwas-vagay daha. Bəzey aŋga ha pal ŋgene. Ndəhay ga da slala ha fa diyam asi vagay a. ");
INSERT INTO mif_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Masa Bay Mahura ma hətar ŋgwas aha na, a kar dey-ceceh, a ləvar: «Dəka mevel, ka təway ba!» ");
INSERT INTO mif_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aŋga ma ləvar la anda keɗe na, ta’, a ŋgəchey, a gəsfar har fa ɓeɓele masa vagay da ray a heyey. Ta’, ndəhay ma lamara vagay kaa, a lacam. Yesu aa guzlar a vagay a, a ləvar: «Bəz-gula, ya fa ləvka: “Sləkɗey!”» ");
INSERT INTO mif_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Vagay kaa, ta’, a sləkɗey, a njey ta njey, a zlar meeguzley. Yesu a ləvar a mamaha: «Ehe, bəzey akah!» ");
INSERT INTO mif_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ndəhay tabiya a rəzlam, a zluram, a həlmamara Gazlavay, a ləvam: «Tasana, ndaw mahura ma təla mey ŋga Gazlavay ta sawa la a wuzlah aləkwa.» A ləvam saya: «Gazlavay ta sawa la ŋga jəney ndəhay aŋga hay.» ");
INSERT INTO mif_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ndəhay daa hwayak ŋga *Jude tabiya ta daa hwayak hay masa ta cakay tabiya ta cəndamara cek masa Yesu ma ka keɗe la. ");
INSERT INTO mif_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Daa masa *Jaŋ-Baptis aŋga daa fərsəne na, gula aŋga hay aa guzlmar da ray cek hay tabiya masa Yesu ma kata. Ta’, Jaŋ-Baptis a zəlwa gula aŋga hay cew, ");
INSERT INTO mif_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a slərdata fa Bay Mahura amba aa cəfɗamara, a ləvmar: «Kah na, *Kəriste, ndaw ma da sawa ŋga ləhdata ndəhay heyey daw? Da daa ba, ya səkwam ndaw mekele ma da sawa daw?» ");
INSERT INTO mif_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ta’, a diyam. Masa ata ma wusam fa Yesu la na, a ləvmar: «Jaŋ-Baptis a slərdandərwa ŋgaa cəfɗaka, a ləvey: “Kah na, Kəriste, ndaw ma da sawa ŋga ləhdata ndəhay heyey daw? Da daa ba, ya səkwam ndaw mekele ma da sawa daw?”» ");
INSERT INTO mif_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ta pas ŋgene, Yesu fa mbəley masa-macay hay ga, kwa cek mecey wura wura cəpa, fa ɓəley malula hay da ray ndəhay ga, asaya, fa wurey dey ŋga wulaf hay ga. ");
INSERT INTO mif_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Fa dəɓa ha, a mbəɗdatara a ndəhay masa *Jaŋ ma slərdata heyey, a ləvtar: «Diyam, kadamara cek masa akwar ma hətmar ta dey akwar, ta akwar ma cəndamara ta sləmay akwar a Jaŋ-Baptis a. Ləvmar na, wulaf hay fa hətmar dey dəɓa, jegwer hay fa diyam maaya maaya ta salay ata, maasəkula hay ta səɗam sem, madagazlam hay fa cənam sləmay, ndəhay maməctakaya fa sləkɗamawa daa meməcey, ndəhay masa-viya hay fa cəndamara Mey-maaya-mawiya dəɓa. ");
INSERT INTO mif_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ndaw ma mbəkda metəɓey-mey aɗaw ba maja sləra masa yah ma ka na, maaya ŋga Gazlavay aa da ray a.» ");
INSERT INTO mif_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ndəhay masa *Jaŋ-Baptis ma slərdata heyey ma diyam la na, Yesu a zlar maa guzltar da ray Jaŋ-Baptis a, a ndəhay ga da cakay a, a ləvtar: «Akwar ma diyam a wuzlah-ley na, ŋga nəkwa me? Ka nəkmawa na, guzer masa memeɗ ma wusa daw? Ara aŋga ba, ba diya? ");
INSERT INTO mif_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kaa, akwar ma diyam ŋga nəkwa na, me? Ka nəkmawa na, ndaw masa ma pey zana maaya fa vaw daw? Anja ndəhay masa ma pam zana maaya fa vaw na, ara ndəhay ma njam daa wiya da way bay hay, ba diya? ");
INSERT INTO mif_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wuzdamiwa, ka diyam ŋga nəkwa na, wa? Ka nəkmawa na, *ndaw ma təla mey ŋga Gazlavay, ba diya? Ya fa ləvkwar, fara fara ara aŋga. Ama a fəna ndaw ma təla mey ŋga Gazlavay la saya, ");
INSERT INTO mif_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","maja *Jaŋ a na, ara ndaw masa mey ŋga Gazlavay mawuzlalakaya maa guzley da ray a, a ləvey: “Bay Gazlavay a ləvar a Bəzey aŋga: Ehe, ya fa slərey maslaŋ-cəveɗ aɗaw fa mey akah, amba a ɗiykawa cəveɗ akah.”» ");
INSERT INTO mif_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu a ləvtar saya: «Ya fa ləvkwar fara fara, da wuzlah ndəhay da bəla na, kwa ndaw ma fəna Jaŋ-Baptis daa ba. Ama ndaw mecəhe da wuzlah ndəhay masa Bay Gazlavay fa wey da ray ata na, ndaw aha a fəna Jaŋ-Baptis. ");
INSERT INTO mif_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","«Ndəhay cəpa feteɗe ma cəndamara mey ŋga Jaŋ na, ta təɓmara mey a la, a sərmara Gazlavay fa key cek ta cəveɗ e. Kwa ma cakala budaw hay ta təɓmara la may. Ndəhay a ŋgene ta təɓmara la amba Jaŋ-Baptis a katar *baptem. ");
INSERT INTO mif_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ama *Fariza hay ta *ndəhay maa sərkada kwakwas ŋga Mawiz ta təɓmara cek masa Gazlavay ma wuɗey ŋgada ata na, daa ba, maja a wuɗam Jaŋ-Baptis a katar baptem ba.» ");
INSERT INTO mif_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu aa guzltar mey mekele saya, a ləvtar: «Ya da wa səkway ŋga ndəhay masa wure keɗe kaa na, ta me? Ata anda me? ");
INSERT INTO mif_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ata anda bəza hay masa manjatakaya fa yam mey da wuzlah ata, a ləvam: “Ala ta famakwar sləlam la, ama akwar ta gərvam daa ba. Ala ta zlamakwar walay vagay la, ama akwar ta təwam daa ba.” ");
INSERT INTO mif_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ya ləvkwar anda keɗe na, maja Jaŋ-Baptis ta sawa la ŋga wuzkwar mey. A zəmey ɗaf anda ndəhay mekele ba, a sey wuzam ba, ama ka ləvam: “Aŋga ta malula da ray.” ");
INSERT INTO mif_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yah, *Bəz ŋga Ndaw, ya sawa, ya fa zəmey cek, ya fa sey cek anda ndəhay mekele. Ama ka ləvam: “Nəkmara, ndaw a keɗe, a wulkey si ŋga zəmey cek ta ŋga sey wuzam ŋgada hwaɗ aŋga gway. Asaya, aŋga na, ara jam ŋga ndəhay ma cakala budaw ta ŋga ndəhay ma zləɓa kwakwas ŋga Mawiz.” ");
INSERT INTO mif_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ama yah na, ya fa ləvkwar, ndəhay a da sərmara leŋgesl ŋga Gazlavay, aŋga maaya na, ta fa ndəhay aŋga hay tabiya ma təɓmara leŋgesl e.» ");
INSERT INTO mif_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ndaw Fariza daha, a zəla Yesu a way aŋga ŋga zəmey ɗaf. Yesu a daw a way ndaw aha, ta’, a njam ŋga zəmey ɗaf. ");
INSERT INTO mif_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Da slala ha ŋgene ŋgwas daha, aa fa key mebərey kalah. A cənda masa Yesu fa zəmey ɗaf da way ndaw Fariza ha na, ta’, a daw ta kwalaba marəhkaya ta ɓərdey da har a way ndaw aha. Kwalaba ha ŋga aŋgwa maavərkwakaya mezəley «*albaatəra». ");
INSERT INTO mif_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","A regedey gweegwe ta salay ŋga Yesu. A təway haa matəway a, a gəcey fa salay ŋga Yesu, a takwaɗa salay a ta eŋgwec ŋga ray aŋga, a kərza salay a, a səmɗa, ta’, a mbəɗdara ɓərdey heyey fa vəɗa. ");
INSERT INTO mif_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ndaw Fariza ma zəla Yesu ŋga zəmey ɗaf heyey, ma hətar ŋgwas aha fa takwaɗa salay ŋga Yesu na, a wulkey daa ray aŋga, a ləvey: «Da ndaw keɗe fara fara ara *ndaw ma təla mey ŋga Gazlavay na, anja a səra ŋgwas ma gəsfar fa salay keɗe na, ara ŋgwas ta mebərey kalah.» ");
INSERT INTO mif_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Da ray ŋgene, Yesu aa guzlar a ndaw Fariza ha, a ləvar: «*Simaŋw, ya wuɗey ŋgaa guzlka mey pal.» Simaŋw a mbəɗdara, a ləvar: «Gweguzley taw, Bay aɗaw.» ");
INSERT INTO mif_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu a ləvar: «Ndəhay cew daha, a lam dəvaz fa ndaw. Ndaw pal a ley gabal temere zlam. Ndaw laŋgar a ley gabal kwakwar zlam . ");
INSERT INTO mif_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ama ata cewete ta gwamara ŋga pəlmara dəvaz a daa ba. Anda keɗe, ndaw ma vəldatara dəvaz a heyey, a mbəkdatara dəvaz a. Yaw, dasi ata cewete keɗe na, ma da wuɗa ndaw ma mbəkdatara dəvaz a kalah na, wa?» ");
INSERT INTO mif_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simaŋw a mbəɗdara, a ləvar: «Ya wulkey ma da wuɗa kalah na, ndaw masa aa ma mbəkdara dəvaz ga da ray a heyey.» Ta’, Yesu a ləvar: «Ahaw fara, ka taa guzley la, ara aŋga.» ");
INSERT INTO mif_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Fa dəɓa ha, ta’, a mbəɗey dey fa ŋgwas kaa heyey, a ləvar a Simaŋw: «Ka fa hətar ŋgwas keɗe, ba diya? Ya sawa na, a way akah, ama ka ta vəlya yam ŋga pərey salay daa ba. Aŋga na, ta pəryawa salay la ta matəway, ta takwaɗayawa la ta eŋgwec ŋga ray aŋga. ");
INSERT INTO mif_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ya sawa a way akah, ka ta təɓya maaya maaya daa ba, ama aŋga na, dəga aŋga ma mbəzwa a way akah keɗe haa wure keɗe ta mbəkda ŋga səmɗayawa salay daa ba. ");
INSERT INTO mif_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ka ta takwaɗaya mal fa ray daa ba, ama aŋga ta mbəɗya ɓərdey la fa salay aɗaw. ");
INSERT INTO mif_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Da ray ŋgene, ya fa ləvka masa aŋga ma wuɗya keɗe na, fa wuzdərwa kwa aŋga ta mebərey ga kalah na, mebərey a daa saba. Ama ndaw ma wulkey aŋga ta mebərey ga daa ba, amba Bay Gazlavay a mbəkdara mebərey a na, ŋgene ara ndaw ma wuɗa Gazlavay nekəɗey gway.» ");
INSERT INTO mif_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Fa dəɓa ha, Yesu a ləvar a ŋgwas heyey: «Mebərey akah daa saba.» ");
INSERT INTO mif_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ndəhay masa manjatakaya ŋga zəmey ɗaf bama heyey, aa guzlam da wuzlah ata, a ləvam: «Keɗe na, ara wa masa ma gwa ŋga mbəkey mebərey ŋga ndaw keɗe na!» ");
INSERT INTO mif_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ama Yesu a ləvar a ŋgwas a heyey: «Bay Gazlavay ta ləhdaka cay daa mebərey, maja kah ma paya ŋga ndaw akah fara fara. Daw ta zazay.» ");
INSERT INTO mif_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Fa dəɓa ha, Yesu a daw aa berney hay leŋ a slala hay ŋga wuzey *Mey-maaya-mawiya da ray mewey ŋga Gazlavay da ray ndəhay. Ndəhay masa ma pəkam ta Yesu na, ara gula aŋga hay kuraw a ray a cew ");
INSERT INTO mif_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ta ŋgusay masa aŋga ma ɓəley malula da ray ata, ta masa aŋga ma mbəldata daa macay. Ŋgusay a na, ara *Mari da Magdala, ŋgwas masa Yesu ma ɓəley malula maasala da ray a heyey, ");
INSERT INTO mif_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zaan, ŋgwas ŋga Kuza ndaw ma nəkey dey fa zleley ŋga Bay *Herawt, leŋ Suzan, ta ŋgusay mekele mekele. Ŋgusay a na, a jənmata ata Yesu ta gula aŋga hay kuraw a ray a cew ta zleley ata hay. ");
INSERT INTO mif_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Daa berney hay mekele mekele ndəhay fa samawa fa Yesu. Masa ndəhay ga ata da cakay a na, Yesu ta’, aa guzltar ta mey-meŋgey, a ləvey: ");
INSERT INTO mif_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ndaw mehəvey daha, a daw ŋgaa kwecey hulfaɗ a ley aŋga. Daa masa aŋga faa kwacada hulfaɗ a na, hulfaɗ laŋgar a kəzley aa cəveɗ. Ndəhay a diyam ta ray a. Ɗiyaŋ hay a ndamara. ");
INSERT INTO mif_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Siya a kəzley aa slam masa pəraɗ, a pəcwa nekəɗey na, a kweley maja yam daa slam aha daa ba. ");
INSERT INTO mif_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Siya a kəzley a wuzlah hatak. A pəcwa da wuzlah hatak a. Hatak a njanjərɗa, a təka ŋga gəley. ");
INSERT INTO mif_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ama siya a kəzley aa slam maaya, a pəcwa, a gəley, a yey babəza ga, a key temere.» Yesu a ləvtar ta gədaŋ: «Da ndaw, aŋga ta sləmay na, ŋga cənda mey a maaya maaya.» ");
INSERT INTO mif_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Gula hay ŋga Yesu aa cəfɗamara amba a sərmara mabara ŋga mey-meŋgey keɗe. ");
INSERT INTO mif_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu a mbəɗdatara, a ləvtar: «Gazlavay ta vəlkwar cəveɗ la ŋga sərey mey hay maɓadatakaya da ray mewey aŋga da ray ndəhay. Ama ndəhay siya hay na, ya wuzdatara ta mey-meŋgey. Anda keɗe, “Fa nəkam dey, ama a hətmar dey ba. Fa jəkam sləmay, ama a cəndamara ba.” ");
INSERT INTO mif_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Ehe, ya wuzdakwara mabara ŋga mey-meŋgey a. Hulfaɗ na, ara mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ndəhay siya ata anda mey-cəveɗ masa hulfaɗ ma kəzley a hwaɗ a. Ndəhay a fa jəkam sləmay fa mey ŋga Gazlavay, ama bay-malula a sawa, a la mey a la daa mevel ata, amba a təkta ŋga təɓmara mey a maja Gazlavay a da ləhdata. ");
INSERT INTO mif_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ndəhay mekele ata anda slam masa pəraɗ. A cəndamara mey ŋga Gazlavay, a təɓmara ta meesəmey. Ama a hway slaslalay ba. A təɓmara ŋga menjey nekəɗey gway. Anda keɗe, ta pas masa cek maaya ba fa batata na, a mbəkdamara mey a. ");
INSERT INTO mif_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Hulfaɗ ma kəzley a wuzlah hatak na, aŋga anda ndəhay mekele ma cəndamara mey ŋga Gazlavay ama a mbəkdamara mey a daa walaŋ maja mewulkey ata aa da ray cek hay mekele mekele, ta da ray zleley leŋ da ray menjey daa wiya da bəla. Anda keɗe, sləra masa ata ma kamara na, aŋga anda daw, babəza fa vəɗa daa ba, səfteker. ");
INSERT INTO mif_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hulfaɗ ma kəzley aa slam maaya na, aŋga anda ndəhay siya ma jəkam sləmay, ma təɓmara mey a aa mevel ata maaya maaya, a kam cek anda Gazlavay ma wuɗey. A təɓmara mey a, a mbəkdamara ba. Anda keɗe, mey a, a yey daa mevel ata anda hulfaɗ ma pəcwa ma yey ga.» ");
INSERT INTO mif_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu a ləvtar saya: «Da ndaw ta gəɗey awaw la aa petərla na, a ɗəpa ta maŋgayak ba, a pa asi harŋgawaw ba. Ama a pa aa slam mepey petərla ŋga waɗa slam daa way a, amba ndəhay ma mbəzam a hwaɗ a na, a hətmar dey. ");
INSERT INTO mif_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Cek hay tabiya maɓadakaya, a wuzwa la a palah. Cek masa ndəhay ma sərmara ba na, a sərmara la, asaya, a wuzwa la aa slam-meweɗey. ");
INSERT INTO mif_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pam leŋgesl amba ka jəkam sləmay maaya maaya. Da ndaw ta təɓa mey ŋga Gazlavay la na, Gazlavay a jəna la ŋga təɓa mey a ma fəna ma fəna. Da ndaw ta təɓa mey ŋga Gazlavay daa ba na, kwa mey a nekəɗey masa aŋga ma wulkey daa mevel aŋga daha na, Gazlavay a badərwa la tabiya.» ");
INSERT INTO mif_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Fa dəɓa ha, ata mamaŋ ŋga Yesu ta məlmaha hay a diyam fa Yesu, ama ta gwamara ŋga wusey a cakay a daa ba, maja ndəhay ga kalah. ");
INSERT INTO mif_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ndəhay feteɗe aa guzlmar a Yesu, a ləvmar: «Ata mamakw ta məlmakw hay malacatakaya daa ambaw, a samawa fa akah, faa cəfɗamaka.» ");
INSERT INTO mif_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ama Yesu a mbəɗdatara, a ləvtar a ndəhay tabiya: «Mamay ta məlma aɗaw hay na, ara ndəhay masa ma jəkam sləmay fa mey ŋga Gazlavay, ma kam cek anda mey a ma ləvey.» ");
INSERT INTO mif_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ta pas laŋgar daha, Yesu a təpam ta gula aŋga hay, aa kwambiwal, a ləvtar: «Təŋgkwa a dey laŋgar ŋga dəhwa.» Ta’, a diyam. ");
INSERT INTO mif_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Daa masa ata fa təŋgam na, Yesu aa daa ɗar. Wure ŋgene, bərgadaŋ a zlar mekey da ray yam. Kwambiwal heyey, a rəhey ta yam, ndəhay da hwaɗ a fa daa zəɗam. ");
INSERT INTO mif_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Da ray ŋgene, gula aŋga hay, a ŋgəcham a cakay a, a sləkɗadamara, a ləvmar: «Bay Mahura! Bay Mahura! Aləkwa fa da məckwa!» Yesu ta’, a sləkɗey, aa bəcey ta gədaŋ, a təka bərgadaŋ ta yam ma wusey heyey. Bərgadaŋ heyey a key saba, yam a wusey saba. ");
INSERT INTO mif_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu aa guzltar a gula aŋga hay a, a ləvtar: «Ka pamaya ŋga ndaw akwar fara fara ba na, maja me?» Ama gula aŋga hay a, a zluram, a rəzlam, aa guzlam da wuzlah ata, a ləvam: «Ndaw a kaa na, ara wa? Masa aa guzlar kwa ŋgada bərgadaŋ, kwa ŋgada yam, a cənar mey keɗe na!» ");
INSERT INTO mif_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ata Yesu ta gula aŋga hay a wusam aa hwayak ŋga ndəhay Gəraza hay ta dey laŋgar ŋga dəhwa, dey ta’ ŋgada *Galile. ");
INSERT INTO mif_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ata ma wusam la na, Yesu a pawa salay daa kwambiwal a. Ndaw daa berney feteɗe daha a sawa a cada ray. Ndaw aha, aa ta malula da ray. Menjey ga, ta kəzley zana fa vaw daa ba. A njey na, da way ba, ama daa cəvay hay. ");
INSERT INTO mif_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Daa masa aŋga ma hətar Yesu na, a zlar mewudey, a təɗey asi salay aŋga, aa guzlar ta gədaŋ, a ləvar: «Yesu, Bəzey ŋga Gazlavay da vaɗ, ka wuɗey fa yah na, me? Ambahw, ka da sərdaya banay ba!» ");
INSERT INTO mif_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Aa guzley anda keɗe, maja Yesu ma ləvar a malula ha ŋga bey da ray aŋga. Malula ha fa kar mandaw mandaw. Ndəhay aŋga hay a jəwmata har ta salay hay ta calalaw amba a njey da way, ama ndaw a, a key gədaŋ, a ɗəsla calalaw a. Malula ha fa hwada a ley. ");
INSERT INTO mif_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ta’, Yesu aa cəfɗa, a ləvar: «Mezəley akah na, me?» A mbəɗdara, a ləvar: «Mezəley aɗaw na, “ga”.» A ləvey anda keɗe maja malula hay ga da ray a daha. ");
INSERT INTO mif_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Malula hay heyey na, a kamar ambahw a Yesu amba a ɓəlta aa vəgeɗ meseleleŋ e ba. ");
INSERT INTO mif_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Daa slam aha ŋgene, ŋgaɓa ŋga vetem hay ga daha da mecəkwer da aŋgwa. Malula hay da ray ndaw heyey a bərkwamara Yesu ŋga vəltar cəveɗ amba a mbəzam a ray vetem hay a. Yesu ta’, a vəltar cəveɗ. ");
INSERT INTO mif_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ta’, malula hay a, a bam da ray ndaw aha, a diyam a mbəzam a ray vetem hay a. Wure ŋgene, vetem hay a tabiya a bam ray, a hwam ta gədaŋ ŋgadaa heeleŋ, a tataram, a kwiyam saf! aa yam, a ɓaɓətam cəpa. ");
INSERT INTO mif_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Masa mecəkwer hay ŋga vetem hay kaa heyey ma hətmar cek ma key la anda keɗe na, a hwam a wuzdamara mey a, a ndəhay daa berney a, leŋ a ndəhay da slala hay masa ta cakay. ");
INSERT INTO mif_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ndəhay a, a samawa ŋga nəkey cek mekey feteɗe he. A wusmawa a cakay Yesu na, a hətfamar ndaw masa Yesu ma ɓəlta malula hay da ray aŋga heyey. Ndaw aha manjakaya da cakay Yesu, aŋga ta zana fa vaw. A səra leŋgesl dəɓa. Ndəhay ma samawa ŋga nəkey cek ma key heyey na, mandərzay a katar. ");
INSERT INTO mif_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ndəhay feteɗe ma hətmar Yesu ma ɓəlta malula hay da ray ndaw heyey, a kadamatara a ndəhay ma samawa ŋga nəkey cek ma key heyey. ");
INSERT INTO mif_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Anda keɗe, ndəhay tabiya daa hwayak ŋga Gəraza hay a ləvmar a Yesu ŋga daw la daa hwayak ata, maja fa zluram ga. Da ray ŋgene, Yesu a təpey aa kwambiwal ŋga daw. ");
INSERT INTO mif_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ndaw masa Yesu ma ɓəlta malula hay da ray aŋga heyey, a kar ambahw a Yesu ŋga vəlar cəveɗ amba a diyam cew e. Ama Yesu ta vəlar cəveɗ ŋga diyam cew e daa ba, a vəhda, a ləvar: ");
INSERT INTO mif_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Daw a way akah, ta kadatara cek mahura masa Gazlavay ma kakawa keɗe tabiya a ndəhay.» Ta’, ndaw aha a daw, a wuzda mey da ray cek masa Yesu ma ka tabiya da ray a heyey ŋgada ndəhay daa berney a tabiya. ");
INSERT INTO mif_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ndəhay ga fa səkwmara Yesu da dey laŋgar ŋga dəhwa ŋga *Galile. Aŋga ma vəhwa la na, ndəhay a təɓmara ta meesəmey. ");
INSERT INTO mif_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ndaw daha mezəley Jayirus. Aŋga *bay-ray ŋga *way-mewuzey-mey ŋga Gazlavay feteɗe. A wusey fa Yesu, a təɗey asi salay aŋga. A kar ambahw ŋga daw a way aŋga, ");
INSERT INTO mif_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","maja dam aŋga daha, aŋga pal, mekele daa ba, vaw fa car, fa da məcey. Dam aha, mamba mevey kuraw a ray a cew. Masa Yesu fa daw a way Jayirus a na, ndəhay fa ŋgacamara ta keɗe ta keɗe. ");
INSERT INTO mif_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Da wuzlah ndəhay a ŋgene, ŋgwas daha mambaz fa mbəɗwa da hwaɗ, dəga mevey kuraw a ray a cew. Ta ndəvda zleley aŋga sem cəpa fa dakwter hay, ama kwa ndaw ma gwa a ray macay a daa ba. ");
INSERT INTO mif_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ŋgwas aha a ŋgəchey ŋgada fa Yesu ta fa dəɓa, a gəsfar har fa mey ŋga zana aŋga. Wure wure ŋgene, mambaz aŋga heyey taŋ! a ɗəsley mey. ");
INSERT INTO mif_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu aa cəfɗata ndəhay, a ləvey: «Ma gəsfaya na, wa?» Kwa waawa a ləvey: «Ara yah ba, ara yah ba.» Ta’, *Piyer a ləvar: «Bay aɗaw, ray akah tabiya mazlərkaya ta ndəhay fa ŋgacamaka kaa na, ka ləvey ma gəsfaya wa na, kwara?» ");
INSERT INTO mif_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesu a mbəɗdara, a ləvar: «Ndaw ta gəsfaya la, maja ya səra gədaŋ daa vaw aɗaw ta bey la.» ");
INSERT INTO mif_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ŋgwas aha, a nəka na, Yesu ta səra sem, a gwa a ɓada ray aŋga saba. Ta’, a daw fa Yesu, aa faa wesey maja fa zlurey. A təɗey asi salay aŋga. Ta’, a kada fa mey ŋga ndəhay tabiya a gəsfar har fa zana ŋga Yesu na, maja me, asaya, a kada Yesu a mbəlda wure wure ŋgene na, kwara. ");
INSERT INTO mif_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Fa dəɓa ha, Yesu a ləvar: «Dam aɗaw, ka ta mbəley cay maja kah ma paya ŋga ndaw akah fara fara. Daw ta zazay.» ");
INSERT INTO mif_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Masa Yesu faa guzlar ŋgada ŋgwas aha araŋ na, ndaw a sawa ta meslərey da way Jayirus, bay-ray ŋga way-mewuzey-mey ŋga Gazlavay heyey, a ləvar: «Dam akah heyey, ta məcey sem. Ka da gərda vaw ta Bay Mahura saba.» ");
INSERT INTO mif_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ama Yesu ma cənda mey a na, a ləvar a Jayirus: «Mevel akah a da təɗey ba. Paya ŋga ndaw akah fara fara gway na, dam akah a mbəley la.» ");
INSERT INTO mif_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Masa Yesu ma wusey la a way Jayirus na, kwa a vəley cəveɗ a ndaw ŋga mbəzey asiya ba, si ma mbəzam asiya na, ata Piyer, *Jaŋ, *Jak, leŋ papaŋ ŋga dam aha ta mamaha gway. ");
INSERT INTO mif_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ndəhay tabiya feteɗe fa təwam, fa wudam maja dam aha. Ama Yesu a ləvtar: «Ka təwam ba. Dam aha ta məcey daa ba, ama a key a ney aa ɗar.» ");
INSERT INTO mif_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ndəhay a, aa saŋgəram a ray Yesu maja a sərmara dam aha ta məcey sem. ");
INSERT INTO mif_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu a ŋgəchey fa dam aha heyey, ta’, a kərza fa har, aa guzlar ta gədaŋ, a ləvar: «Bəzey, sləkɗey!» ");
INSERT INTO mif_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mesəfney aŋga a vəhwa aa slam a, ta’, a sləkɗey wure ŋgene. Yesu a ləvtar ŋga vəlmar cek mezəmey. ");
INSERT INTO mif_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Papaŋ ŋga dam aha ta mamaha a rəzlam ga, ama Yesu a kətata, a ləvtar: «Cek masa ma key keɗe na, ka da kadamara ŋgada ndaw ba.» ");
INSERT INTO mif_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu a kusta gula aŋga hay kuraw a ray a cew, a vəltar gədaŋ ŋga key maazla amba a ɓəlam malula hay wura wura tabiya da ray ndəhay, asaya, amba a mbəlam masa-macay hay. ");
INSERT INTO mif_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aŋga ma vəltar gədaŋ la na, ta’, a slərdata ŋga wuzey mey da ray mewey ŋga Gazlavay da ray ndəhay, asaya, ŋga mbəley masa-macay hay. ");
INSERT INTO mif_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ta’, a ləvtar: «Diyam, ama daa madaw akwar na, ka da lam cek a har ba, ka da lam zlanday ba, ka da lam gabal ba, ka da lam cek mezəmey ba, ka da lam dala ba. Ndaw a da ley zana cew ba. ");
INSERT INTO mif_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kwa daa slam wura wura ndaw ma təɓkwar la a way aŋga na, njam a way a ŋgene kasl pas masa akwar ma da diyam. ");
INSERT INTO mif_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kwa daa slam wura wura ndəhay ma təɓmakwar daa ba na, raramatara lagwada fa salay akwar hay amba ka wuzdamatara ata ndəhay ta mebərey, diyam la da slala ha.» ");
INSERT INTO mif_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ta’, gula aŋga hay heyey a pəkam da slala hay mekele mekele daa hwayak ŋga *Galile, a wuzam *Mey-maaya-mawiya, a mbəlam masa-macay hay, kwa daa wura daa wura cəpa. ");
INSERT INTO mif_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","*Herawt, ndaw ma wa hwayak ŋga *Galile ŋgene, a cənda mey da ray ata Yesu ta gula aŋga hay. Mey a, a həɓar ray maja ndəhay faa guzlam mey hay mekele mekele. Ndəhay a ləvam: «Ndaw aha na, ara *Jaŋ-Baptis ma sləkɗawa daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Siya hay a ləvam: «Ara *Eli ma wuzwa vaw.» Mekele hay a ləvam: «Ara ndaw pal dasi ndəhay ma təla mey ŋga Gazlavay zleezle ma sləkɗawa daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ama Herawt a ləvey: «Jaŋ-Baptis na, ya ta ɗəslra ray sem. Kaa ndaw masa yah ma cənda mey da ray a keɗe na, ara wa dəɓa wa?» Da ray ŋgene, a səpey cəveɗ ŋga hətar Yesu. ");
INSERT INTO mif_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Fa dəɓa ha, ndəhay meslərey ŋga Yesu kuraw a ray a cew heyey a vəhmawa fa Yesu, a kadamara cek hay tabiya masa ata ma kamərwa daa mepəkey ata. Yesu ta’, a ŋgəlta taava ata, a diyam aa slam gweegwe ta slala Betsayda. ");
INSERT INTO mif_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ama ndəhay ga ma cəndamara ata sem na, a diyam asi ata. Yesu a təɓta ta meesəmey. A wuztar mey da ray mewey ŋga Gazlavay da ray ndəhay, asaya, a mbəldata masa-macay hay. ");
INSERT INTO mif_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yaw, mamba pas a kəzley na, gula aŋga hay kuraw a ray a cew heyey a ŋgəcham a cakay a, a ləvmar: «Ləvtar a ndəhay keɗe ŋga diyam a wuzlah-way, da daa ba, a slala hay ta cakay, amba a səpam slam-meney ta cek mezəmey, maja aləkwa da wuzlah-ley.» ");
INSERT INTO mif_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ama Yesu a ləvtar: «Akwar ta ray akwar, vəlmatar cek mezəmey!» Gula hay a, a mbəɗdamara, a ləvmar: «Da har ala na, peŋ zlam ta ewet cew gway. Da ka wuɗey amba ndəhay tabiya keɗe a zəmam cek na, si ya diyam ya həɗkamawa kwa.» ");
INSERT INTO mif_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Da wuzlah ndəhay a ŋgene, zel hay a key gabal zlam. Yesu a ləvtar a gula aŋga hay a: «Njadamata njakw! njakw! kwakwar zlam, kwakwar zlam.» ");
INSERT INTO mif_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Gula aŋga hay ta’, a njadamata tabiya anda Yesu ma ləvtar. ");
INSERT INTO mif_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Fa dəɓa ha, Yesu hal! a həlta peŋ zlam ta ewet cew heyey, ta’, a baŋgaɗa dey a vaɗ, a kar suse a Gazlavay maja cek mezəmey a. Ta’, a papəsa, a vəldatara a gula aŋga hay amba a wunkamatara a ndəhay a. ");
INSERT INTO mif_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kwa waawa a zəmey haa a rəhey. Ta’, gula aŋga hay a cakalamara siya ŋga cek hay a ma mbəkey. Macakalakaya ha, gadakar kuraw a ray a cew. ");
INSERT INTO mif_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ta pas laŋgar daha, Yesu fa dərey daŋgay pal taava aŋga. Gula aŋga hay ata da cakay a. Ta’, Yesu aa cəfɗata, a ləvtar: «Yah na, ndəhay a padamaya na, ŋga wa?» ");
INSERT INTO mif_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Gula aŋga hay a, a mbəɗdamara, a ləvmar: «Ndəhay siya a ləvam kah na, *Jaŋ-Baptis. Mekele hay a ləvam kah na, *Eli, *ndaw ma təla mey ŋga Gazlavay zleezle. Mekele hay saya a ləvam kah na, ndaw pal dasi ndəhay ma təla mey ŋga Gazlavay zleezle ma sləkɗawa daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ta’, Yesu aa cəfɗata saya, a ləvtar: «Kaa akwar may, ka ləvam yah na, wa?» *Piyer a mbəɗdara, a ləvar: «Kah na, *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay.» ");
INSERT INTO mif_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu a kətata gula aŋga hay, a katar mey, a ləvtar: «Ka da wuzdamara mey a keɗe a ndaw ba.» ");
INSERT INTO mif_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A ləvtar saya: «Si yah, *Bəz ŋga Ndaw, ya sərey banay la ga ɗagay. Mahura hay ŋga *Jəwif hay, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, leŋ *ndəhay maa sərkada kwakwas ŋga Mawiz, a rəsmaya la, fa da təɓmara ara Gazlavay ma slərdiwa na, daa ba. A da kəɗmaya vagay. Ama ŋga ɗar maakar a na, ya sləkɗawa la daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ta’, Yesu a ləvtar a ndəhay tabiya: «Da ndaw a wuɗey ŋga səpya na, si a mbəkda mewulkey da ray ray aŋga, a səpya ta mevel pal, si a ɓəsa banay ma da sawa a ray aŋga mandaw mandaw maja yah, anda yah ma da məcey fa hwadam mazlaŋgalakaya. ");
INSERT INTO mif_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sərmara, kwa waawa ma wuɗey ŋga ləhda heter aŋga na, a key ŋgene, aa zəɗda. Ama kwa waawa maa zəɗda heter aŋga maja yah na, a key ŋgene, a ləhda heter aŋga ha. ");
INSERT INTO mif_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Da ndaw a hətey cek hay tabiya masa aŋga ma wuɗey da bəla keɗe, ama aa zəɗda heter aŋga, da daa ba, a nəsa ray aŋga na, mehətey cek hay a tabiya ŋgene, a jəna la daw? ");
INSERT INTO mif_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kwa waawa ma paya hwaray fa mey ŋga ndəhay, da daa ba, ma key hwaray ŋga təɓa mey aɗaw na, ŋgene, ta pas masa yah, *Bəz ŋga Ndaw, yah ma da vəhwa ta meweɗey aɗaw , ta gədaŋ mahura ŋga Papay, leŋ ta gədaŋ ŋga maslaŋ aŋga hay da vaɗ na, ya par hwaray la fa mey ŋga Bay Gazlavay may. ");
INSERT INTO mif_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ya fa ləvkwar fara fara, ndəhay siya da wuzlah akwar feɗe, fa da məcam daa ba, si ata ma hətmar mewey ŋga Bay Gazlavay la ɗagay.» ");
INSERT INTO mif_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Fa dəɓa ha luma pal na, Yesu, ta’, a ŋgəlta ata *Piyer, *Jaŋ, leŋ *Jak. A təpam a aŋgwa amba Yesu a dərwa daŋgay feteɗe. ");
INSERT INTO mif_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Masa aŋga fa dərey daŋgay na, dey aŋga pəla! a mbəɗey, zana aŋga a weɗey mabara ndəɗ-ndeɗ. ");
INSERT INTO mif_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Wure wure ŋgene, ndəhay daha cew faa guzlam ta Yesu a. Ara ata *Mawiz ta *Eli. ");
INSERT INTO mif_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","A wuzmawa vaw daa meweɗey ŋga Gazlavay da vaɗ. Ata faa guzlam ta ata Yesu da ray sləra aŋga masa aŋga ma da ndəvda ta fa meməcey aŋga da *Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ata Piyer ta gula hay cew heyey manatakaya cəkw-cakw daa ɗar. Ama a sləkɗam daa ɗar, a hətmar meweɗey ŋga Yesu ta ndəhay cew heyey. ");
INSERT INTO mif_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Daa masa ndəhay a fa diyam la da cakay Yesu na, Piyer aa guzlar a Yesu, a ləvar: «Bay ala, maaya na, ya njakwa feɗe, amba ya kərcam slam hay maakar, pal ŋgada kah, pal ŋgada Mawiz, pal ŋgada Eli.» Ama Piyer a səra mey masa aŋga maa guzlda ba. ");
INSERT INTO mif_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Masa Piyer faa guzley na, mekwtene a sawa, a sərtata. Mekwtene ma sərtata la na, gula aŋga hay heyey a zluram. ");
INSERT INTO mif_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Daa mekwtene he na, ɗay a cənwa, a ləvey: «Keɗe he ara Bəzey aɗaw, masa yah ma wala, jəkfamar sləmay.» ");
INSERT INTO mif_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Fa dəɓa ŋga ɗay ma cənwa ha na, *gula hay ŋga Yesu a da nəkam dey na, mbak! Yesu pal taava aŋga. Gula hay ŋga Yesu a, a njam teete, kwa cek masa ata ma hətmar na, ta kadamara ŋgada ndəhay daa ba. ");
INSERT INTO mif_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pepərek e, ata Yesu ta gula aŋga hay maakar heyey a pamawa salay da aŋgwa heyey, ndəhay ga a diyam ŋga cadamərwa ray ta Yesu a. ");
INSERT INTO mif_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Da wuzlah ndəhay a ŋgene, ndaw daha a zlar mewudey, a ləvar a Yesu: «Bay aɗaw, ya kaka ambahw. Nəka bəzey aɗaw keɗe, aŋga pal, mekele daa ba, jəna cey. ");
INSERT INTO mif_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Aŋga ta cek da ray, ta zlar la na, a wudey, a gucey, maŋgwafakw a bawa da mey. A sərda banay kalah, a mbəkda gweegwe ba. ");
INSERT INTO mif_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ya ta katar ambahw la a gula akah hay amba a badamara cek da ray bəzey a, ama ta gwamara daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu aa guzley, a ləvey: «Hey! Akwar ndəhay marəzltakaya masa ma pamaya ŋga ndaw akwar fara fara ba keɗe. Ya da njey ta akwar na, haa ta vara? Ya da ɓəskwar na, haa ta vara?» Ta’, a ləvar a ndaw aha: «Handiwa bəzey akah ha feɗe.» ");
INSERT INTO mif_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Masa bəzey a gweegwe a wusey a cakay Yesu na, cek da ray a cəkw! a la bəzey a, ɓa! a kəzla a hwayak, a gucey. Ama Yesu aa bəcar a cek da ray bəzey a, ta’, a mbəley. Yesu a ləvar a papaha: «Ehe, bəzey akah.» ");
INSERT INTO mif_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ndəhay tabiya a rəzlam, a ləvam: «Fara fara Gazlavay na, aa ta gədaŋ.» Daa masa ndəhay tabiya fa rəzlam da ray cek hay tabiya masa Yesu ma kata na, a ləvtar a gula aŋga hay: ");
INSERT INTO mif_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Wure keɗe jəkam sləmay maaya maaya, pamara mey keɗe aa ray: A da kərzamaya, yah, *Bəz ŋga Ndaw, a da vəldamaya a har ndəhay.» ");
INSERT INTO mif_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ama gula aŋga hay ta cəndamara mey masa Yesu maa guzldatara ŋgene daa ba. Mabara ŋga mey a maɓadakaya fa ata, a gwamara ŋga cəndamara ba ɗagay. A zluram ŋgaa cəfɗamara Yesu da ray mey a. ");
INSERT INTO mif_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gula hay ŋga Yesu a kam yawa da wuzlah ata, a wuɗam amba a sərmara mahura dasi ata na, wa. ");
INSERT INTO mif_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ama Yesu a səra mewulkey ata. Ta’, a ley bəzey mecəhe deŋ! a lacada a cakay a, ");
INSERT INTO mif_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","a ləvtar: «Kwa waawa ma təɓa bəzey mecəhe keɗe la maja a wuɗya na, a key ŋgene na, a təɓey yah, ray aɗaw. Asaya, kwa waawa ma təɓya la, a təɓey ŋgene na, Bay Gazlavay, ndaw ma slərdiwa may. Ndaw masa mecəhe da wuzlah akwar tabiya na, mahura na, aŋga.» ");
INSERT INTO mif_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ta’, *Jaŋ a mbəɗdara a Yesu, a ləvar: «Bay ala, ala ta hətam ndaw daha la fa ɓəley malula da ray ndəhay ta mezəley akah. Ya wuɗam ŋga təkmara maja ara ndaw da wuzlah aləkwa ba.» ");
INSERT INTO mif_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ama Yesu a mbəɗdara, a ləvar: «Ka da təkmara ba. Ndaw masa-gəra akwar ba na, ara jam akwar.» ");
INSERT INTO mif_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Masa gweegwe cay Gazlavay a la Yesu fa vəɗa a vaɗ na, Yesu a kərza mevel ŋga daw aa berney ŋga *Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ta’, a slərey ndəhay teeseɗ fa mey. A diyam a slala daha daa hwayak ŋga *Samari ŋga ɗiymar slam-meney. ");
INSERT INTO mif_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ama ndəhay daa slala ha, a gəmam ŋga təɓmata ba, maja a sərmara Yesu a wuɗey ŋga daw a Jeruzelem . ");
INSERT INTO mif_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Masa gula aŋga hay ata *Jak ta *Jaŋ ma nəkmara ndəhay daa slala ha a gəmam ŋga təɓmata ba na, ta’, a ləvmar: «Bay Mahura, ka wuɗey yaa cəfɗamawa awaw ŋga pawa salay da vaɗ ŋga zəma slala ha keɗe tabiya daw?» ");
INSERT INTO mif_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu pəla! a mbəɗey dey ŋgada fa ata, ta’, a mbəɗtar ray, a katar mey. A ləvtar: «Ma həldakwar ŋgaa guzley anda keɗe na, mesəfney wura? Yah, *Bəz ŋga Ndaw, ya sawa na, ŋgaa zəɗey ndəhay ba, ama ŋga ləhdata.» ");
INSERT INTO mif_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ta’, a diyam aa slala mekele. ");
INSERT INTO mif_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ata fa diyam daa cəveɗ, ndaw daha a ləvar a Yesu: «Kwa aa slam wura wura masa kah ma da daw na, ya daw la asi akah.» ");
INSERT INTO mif_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu a mbəɗdara, a ləvar: «Mbiga hay, ata ta vəgeɗ ata hay, ɗiyaŋ hay, ata ta way ata hay. Ama yah, *Bəz ŋga Ndaw na, kwa slam ŋga ney nekəɗey amba ya məskey vaw da hwaɗ a na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A ləvar a ndaw laŋgar: «Sawa asi aɗaw.» Ama ndaw aha a ləvar: «Bay aɗaw, vəlya cəveɗ amba ya daw ya jəhərwa papay la ɗagay.» ");
INSERT INTO mif_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu a mbəɗdara, a ləvar: «Mbəkdata ndəhay maməctakaya ŋga jəhmata ndəhay ata hay maməctakaya. Kah na, daw ta wuzey mey da ray mewey ŋga Gazlavay da ray ndəhay.» ");
INSERT INTO mif_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ndaw laŋgar daha saya a ləvar: «Yah na, ya daw la asi kah Bay aɗaw, ama vəlya cəveɗ amba ya da catərwa har a ndəhay da way ala hay la ɗagay.» ");
INSERT INTO mif_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu a mbəɗdara, a ləvar: «Ndaw masa fa həvey ta sla hay, a mbəɗey dey fa dəɓa na, aŋga letek ta ndaw ma wuɗey ŋga daw taa cəveɗ aɗaw, ama a nəkey dey fa dəɓa aa cəveɗ aŋga magurma. Ndaw anda ŋgene na, a gwa mekey sləra ŋga Bay Gazlavay ba səlak.» ");
INSERT INTO mif_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Fa dəɓa ha, Bay Mahura a weley gula hay mekele kwakwar maasala a ray a cew, amba a slərdata tabiya cew cew teeseɗ fa mey aŋga aa berney hay cəpa ta a slala hay tabiya masa aŋga ta ray aŋga ma da daw a hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A ŋgatar mey, a ləvtar: «Cek ta key la ga da ley, ama ndəhay ŋga kamərwa a way na, pəreh. Anda keɗe, kamar ambahw a bay ŋga ley a, ŋga slərwa ndəhay mekele saya a dey a ŋga kawa cek hay da ley a. ");
INSERT INTO mif_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yaw, anda keɗe diyam, ya slərdakwar anda bəz-təɓaŋ hay ŋgada wuzlah gədey-ley hay. ");
INSERT INTO mif_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ka da lam dala ba, ka da lam gabal ba, kwa ka da lam tarak hay ba. Ka da lacam daa cəveɗ ŋga cey har a ndəhay ba. ");
INSERT INTO mif_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Da ka mbəzam a way ndaw ŋga njey, teeseɗ na, ləvam: “Anja way keɗe ŋga njey daa zazay.” ");
INSERT INTO mif_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Da ndaw ma wuɗey zazay ŋga njey da way aŋga daha na, mepəsey-mey akwar a, a wusfar la. Da ndaw ma wuɗey zazay da way a daa ba na, mepəsey-mey akwar a, a vəhwa la fa akwar. ");
INSERT INTO mif_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Da ndəhay da way a ta təɓmakwar la, njam da way a ŋgene, zəmam cek, sam cek, masa ndəhay a ma vəldamakwara, maja ndaw ma ka sləra na, aa təɗe ŋga hətey mawurɓay ŋga sləra aŋga. Ka da səpmata fa way a fa way a ba. ");
INSERT INTO mif_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Masa akwar ma wusam la aa berney wura wura, da ndəhay feteɗe a təɓmakwar na, cek masa ndəhay a ma da vəldamakwara, zəmamara. ");
INSERT INTO mif_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mbəldamata masa-macay hay daa berney a, ləvmatar a ndəhay daa berney a: “Bay Gazlavay ta wuswa la gweegwe ta akwar ŋga wey da ray akwar.” ");
INSERT INTO mif_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama da ka wusam aa berney wura wura masa ndəhay a gəmam ŋga təɓmakwar ba na, diyam aa slam masa ndəhay ga da hwaɗ a, ləvam: ");
INSERT INTO mif_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Kwa lagwada daa berney akwar fa salay ala, ya raramakwara amba ya wuzdamakwara akwar ta kam cek maaya ba la. Asaya, si ka sərmara Bay Gazlavay ta wuswa la gweegwe ta akwar ŋga wey da ray akwar!”» ");
INSERT INTO mif_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yaw, Yesu aa guzltar saya, a ləvey: «Ya fa ləvkwar fara fara, ta pas ŋga sariya na, Gazlavay a da sərdata banay ta ndəhay daa berney a ŋgene ma fəna ŋga ndəhay daa berney ŋga *Sadawm.» ");
INSERT INTO mif_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Haya! ndəhay da slala Kwaraziŋ, banay a sawa la a ray akwar. Haya! ndəhay da slala Betsayda, banay a sawa la a ray akwar. Ya ta key maazla hay la da wuzlah akwar. Da ndəhay daa berney ŋga Tir ta ŋga Sidaŋw ta hətmatar maazla hay a la na, anja ta mbəɗdamara menjey ata sem dəga zleezle, anja ta kəzlam zana ŋga sak meefərey vaw sem fa vaw, asaya, anja ta pətkwalam sem daa bebəɗes ŋga wuzwa na, ata ta mbəɗdamara menjey ata da bəla cay. ");
INSERT INTO mif_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Da ray ŋgene, ta pas masa Gazlavay ma da ka sariya da ray bəla na, Gazlavay a da sərdakwar banay ma fəna ŋga ndəhay daa berney ŋga Tir ta ŋga Sidaŋw. ");
INSERT INTO mif_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Akwar, ndəhay da Kapernayum may, ka wulkam na, Gazlavay a ŋgəlkwar la a vaɗ daw? Ara kəne ba. Sasəkar jak, a da kəzlakwar aa slam ŋga ndəhay maməctakaya.» ");
INSERT INTO mif_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu a ləvtar a gula aŋga hay: «Ndaw masa fa cənkwar mey na, a key ŋgene, a cənya mey may. Ndaw masa ma təɓa mey akwar ba na, a key a təɓey mey aɗaw ba may. Asaya, ndaw ma rəsya na, a key ŋgene a rəsa ndaw ma slərdiwa.» ");
INSERT INTO mif_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ndəhay meslərey hay kwakwar maasala a ray a cew heyey, a vəhmawa ta meesəmey ga, a ləvmar a Yesu: «Bay Mahura, daa masa ala faa guzlam ta mezəley akah na, kwa malula hay may a cənmandar mey.» ");
INSERT INTO mif_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu a mbəɗdatara, a ləvtar: «Yah, ya ta hətar *Sataŋ la fa təɗwa anda mezəmey ŋga var ma kawa da vaɗ ŋgada hwayak. ");
INSERT INTO mif_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yaw, jəkam sləmay, ya ta vəlkwar gədaŋ la ŋga pey salay a ray zezekw hay ta arac hay, asaya, ya ta vəlkwar gədaŋ la ŋga fəna gədaŋ ŋga masa-gəra hay ŋga Bay Gazlavay tabiya. Kwa cek fa da hətfakwar daa ba. ");
INSERT INTO mif_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ama ka da sasəsam maja malula hay ma cənmakwar mey ba. Sasəsam na, maja mezəley akwar hay mawuzlalatakaya da gazlavay da vaɗ.» ");
INSERT INTO mif_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wure wure ŋgene, *Mesəfney ŋga Gazlavay a vəlar meesəmey a Yesu. Ta’, Yesu a həlma Gazlavay, a ləvey: «Waa Papay Bay Gazlavay, ndaw ma wa slam da vaɗ ta da hwayak, ya fa kaka suse, maja ka ta wuzdərwa maaya akah la a ndəhay ma səra cek ba anda bəza hay mecəhe hay. Ama ŋgada ndəhay masa ta leŋgesl ma səra cek na, ka ta ɓada maaya ha sem fa ata. Ahaw Papay, maja ta mbafaka sem ŋga ka kəne.» ");
INSERT INTO mif_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ta’, a ləvtar a ndəhay: «Papay ta vəldatiwa cek hay tabiya sem asi har aɗaw. Kwa ndaw pal ma sərya, yah, *Bəz ŋga Ndaw na, daa ba, si Papay. Asaya, kwa ndaw pal ma səra Papay daa ba may, si yah, Bəz aŋga, leŋ ndəhay masa yah ma wuɗey ŋga wuzdatara.» ");
INSERT INTO mif_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Fa dəɓa ha, ta’, a mbəɗey dey ŋgada fa gula aŋga hay, a ləvtar ŋgada ata taava ata: «Maaya ŋga Gazlavay aa da ray akwar maja akwar ma hətmar cek masa Gazlavay ma ka keɗe ta dey akwar. ");
INSERT INTO mif_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ama ya fa ləvkwar, ndəhay ma təla mey ŋga Gazlavay zleezle ta bay hay ga, ta wuɗam la ŋga hətmar cek masa akwar ma hətmar keɗe, ama ta hətmar daa ba. Ta wuɗam la ŋga cəndamara cek masa akwar ma cəndamara keɗe, ama ta cəndamara daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Feteɗe na, *ndaw maa sərkada kwakwas ŋga Mawiz daha, a wuɗey ŋga jada Yesu. Ta’, a sləkɗey, aa cəfɗa, a ləvar: «Bay aɗaw, ya da key amba ya hətey heter mendəvey ba na, me?» ");
INSERT INTO mif_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu a mbəɗdara, a ləvar: «Mawuzlalakaya daa kwakwas aləkwa na, kwariya? Masa kah ma jaŋga na, ka cənda na, kwara?» ");
INSERT INTO mif_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ndaw aha, a mbəɗdara a Yesu, a ləvar: «Mey a, a ləvey: “Si ka wuɗa Bay Gazlavay akah ta mevel akah cəpa, ta mesəfney akah cəpa, ta gədaŋ akah cəpa, ta leŋgesl akah cəpa. Si ka wuɗa meseembew akah anda kah ma wuɗa ray akah.”» ");
INSERT INTO mif_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu a mbəɗdara, a ləvar: «Yawa, ka ta mbəɗdiwa la maaya kalah. Daw ta ka kəne, ka hətey heter mendəvey ba la.» ");
INSERT INTO mif_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ama ndaw aha a wuɗey amba a ɓəla hwaray daa dey aŋga. Da ray ŋgene, aa cəfɗa Yesu saya, a ləvar: «Meseembew aɗaw na, wa?» ");
INSERT INTO mif_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu aa guzlar saya, a ləvar: «Ndaw *Jəwif daha a sləkɗey da *Jeruzelem, a daw a Jerikwaw. A da daw na, a har mayal hay. Mayal hay a, a kərzamara, a kəɗmara, a mbəkdamara həɗek həɗek ŋga məcey. ");
INSERT INTO mif_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Fa dəɓa ha, *ndaw ma ka kwakwas ŋga Gazlavay daha, a daw taa cəveɗ e ŋgene. A hətar ndaw masa mayal hay ma kəɗmara heyey. Ta’, a zleŋgeɗey, a daw dəreŋ ta aŋga. ");
INSERT INTO mif_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Fa dəɓa ha, ndaw ma ka kwakwas ŋga Gazlavay mekele daha masa da wuzlah ndəhay ŋga *Levi, a daw taa slam aha ŋgene may. A hətar ndaw masa mayal hay ma kəɗmara heyey na, ta’, a zleŋgeɗey a daw dəreŋ ta aŋga, anda ndaw ŋgeeme heyey saya na, gway. ");
INSERT INTO mif_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ama, ndaw-məlak daha, ara ndaw *Samari, fa daw taa cəveɗ e ŋgene may. A wusey a cakay ndaw masa mayal hay ma kəɗmara keɗe na, a nəka na, a kar dey-ceceh. ");
INSERT INTO mif_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ta’, a ŋgəchey a cakay a, a kar mal ta slalak fa mbəlek e, a mbəzra. Fa dəɓa ha, a la a ray zəŋgwaw aŋga, ta’, a handa aa way meney ŋga məlak hay, a nəkfar dey. ");
INSERT INTO mif_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pepərek e, masa fa da daw aa mepəkey aŋga na, ta’ a vəlar dala a bay ŋga way a, a ləvar: “Nəkfayawa dey fa ndaw keɗe. Pas masa ya ta vəhwa cay daa mepəkey aɗaw na, yah ta ray aɗaw, ya pəlkawa cek tabiya masa ka maa zəɗda maja aŋga fa dəɓa aɗaw la.”» ");
INSERT INTO mif_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Masa Yesu ma ndəvda mey-meŋgey keɗe cay na, ta’, aa cəfɗa *ndaw maa sərkada kwakwas ŋga Mawiz heyey, a ləvar: «Da wuzlah ndəhay maakar keɗe na, meseembew ŋga ndaw masa mayal hay ma kəɗmara kaa na, wa?» ");
INSERT INTO mif_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","*Ndaw maa sərkada kwakwas ŋga Mawiz a, a mbəɗdara, a ləvar: «Meseembew aŋga na, ara ndaw masa ma sərfar dey-ceceh.» Ta’, Yesu a ləvar: «Daw, ta ka kəne.» ");
INSERT INTO mif_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ata Yesu ta gula aŋga hay fa diyam daa cəveɗ. Masa ata ma wusam la a slala daha na, feteɗe, ŋgwas daha mezəley Marta, a ŋgəla Yesu a way aŋga. ");
INSERT INTO mif_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Dam-mamaha daha, mezəley *Mari, cəkwam! a njey a cakay Bay Mahura, fa jəkey sləmay fa mey aŋga masa aa ma kada. ");
INSERT INTO mif_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta fa key sləra hay mekele mekele ga daa hejek. Ta’, a sawa fa Yesu, a ləvar: «Bay Mahura, dam-mama aɗaw a mbəkdatiwa sləra hay tabiya a ray aɗaw anda keɗe na, a mbafaka gway daw? Ləvar ŋga sawa ŋga jənya.» ");
INSERT INTO mif_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesu a mbəɗdara, a ləvar: «Marta, Marta, ka fa həɓa ray akah maja ka fa key cek hay mekele mekele ga. ");
INSERT INTO mif_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ama cek pal mahura ŋga key daha. Ara cek masa Mari ma ka keɗe. Ndaw ma gwa ŋga təka daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ta pas laŋgar daha, Yesu fa dərey daŋgay daa slam daha. Masa aa ma ndəvda cay na, ndaw pal dasi gula aŋga hay, aa cəfɗa, a ləvar: «Bay Mahura, sasərkadandar medərey daŋgay anda *Jaŋ maa sərkadata gula aŋga hay cey.» ");
INSERT INTO mif_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu a ləvtar: «Da akwar fa dəram daŋgay na, ləvam: Papaŋ Bay Gazlavay, anja ndəhay tabiya ŋga namaka ray maja kah na, Bay Gazlavay pal. Maaya na, ka wa bəla tabiya. ");
INSERT INTO mif_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Vəlndar cek mezəmey ŋga wusndar fa ɗar a, fa ɗar a. ");
INSERT INTO mif_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mbəkdandara mebərey ala, maja ala may, ala fa mbəkdamatara mebərey ŋga ndəhay ma kamandar cek maaya ba. Jəɗndar amba cek a batandar ŋga key mebərey ba.» ");
INSERT INTO mif_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu aa guzltar mey-meŋgey da ray medərey-daŋgay a gula aŋga hay, a ləvtar: «Da ndaw da wuzlah akwar, jam aŋga daha na, a daw fa aŋga ta wuzlah-tavaɗ amba aa cəfɗa, a ləvar: “Jam aɗaw, vəlya peŋ maakar yaa dəɗey cey, ");
INSERT INTO mif_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","maja mandala aɗaw ta sawa la da pəkey ta way aɗaw, ama cek mezəmey amba ya vəlar daa ba.” ");
INSERT INTO mif_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jam aŋga ha a mbəɗdara da way da way, a ləvar: “Ka sərdaya banay ba. Ya ta gərca mey-mbew cay, ala manatakaya ta bəz aɗaw hay. Ya gwa ya sləkɗey amba ya vəlka peŋ ba.”» ");
INSERT INTO mif_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yesu a ləvey saya: «Ya fa ləvkwar kwa ndaw aha, a wuɗey ŋga sləkɗey ba na, a sləkɗey la. A da sləkɗey na, maja ata jam ba, ama maja da ta vəlar daa ba na, jam aŋga ha a daa cəfɗa dey ga, hwaray fa da kar daa ba. Anda keɗe, a vəlar cek tabiya masa jam aŋga ha ma wuɗey la. ");
INSERT INTO mif_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Yah na, ya fa ləvkwar: Cacəfɗam cek fa Bay Gazlavay, a vəldakwara la. Səpam cek fa Gazlavay, ka hətam la. Zəlam fa mey-mbew, a wurkwara la, ");
INSERT INTO mif_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","maja kwa waawa maa cəfɗafar cek na, a vəlar la. Kwa waawa ma səpey cek fa vəɗa na, a hətey la. Kwa waawa ma zəley fa mey-mbew na, a wurara la. ");
INSERT INTO mif_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Akwar papaŋ ŋga bəza hay, da bəzey akah aa cəfɗafaka ewet na, ka vəlar zezekw la daw? ");
INSERT INTO mif_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yaw, da aa cəfɗafaka slesleɗ na, ka vəlar arac la daw? ");
INSERT INTO mif_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Akwar ndəhay malamba hay ma!, ka sərmara ŋga vəley cek maaya ŋgada bəz akwar hay. Da kəne na, kaa wara Papakw akwar Bay Gazlavay da vaɗ a vəltar Mesəfney aŋga ŋgada ndəhay masa maa cəfɗafamara ba na, kwara?» ");
INSERT INTO mif_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pas pal daha Yesu a ɓəley malula da ray ndaw ma gwa meeguzley ba daha. Masa aŋga ma ɓəla malula ha cay na, ndaw a, aa guzley dəɓa. Ndəhay tabiya feteɗe a rəzlam. ");
INSERT INTO mif_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ama ndəhay siya da wuzlah ata a ləvam: «Ara *Beyelzebul, bay ŋga mesəfney maaya ba hay ma vəlar gədaŋ ŋga ɓəley malula da ray ndəhay.» ");
INSERT INTO mif_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Siya hay a səpam cəveɗ ŋga jadamara, a ləvmar ŋga key maazla ŋga wuzda gədaŋ aŋga a sawa ta fa Bay Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ama Yesu a səra mewulkey ata, ta’, a ləvtar: «Da ndəhay daa hwayak pal a kam vəram da wuzlah ata na, hwayak a ŋgene a nəsey la. Daa vəram a ŋgene, way hay a bəzlam la. ");
INSERT INTO mif_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Da gula hay ŋga *Sataŋ, a kam vəram da wuzlah ata na, kaa wara Sataŋ a, a da cəmtar ray ŋga wey da ray ata na, kwara dəɓa wura? Yaw, ya ləvkwar anda keɗe na, maja ka ləvam ya ɓəley malula da ray ndəhay ta gədaŋ ŋga Beyelzebul. ");
INSERT INTO mif_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Da kəne na, kaa gula akwar hay a ɓəlam malula ta gədaŋ ŋga wa? Ka ləvam ta gədaŋ ŋga Gazlavay, ba diya? Da ray ŋgene, gula akwar hay a, a wuzdamakwara la mey akwar ŋgene ara aŋga ba. ");
INSERT INTO mif_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Fara fara, ya ɓəley malula da ray ndəhay na, ara ta gədaŋ ŋga Gazlavay. A wuɗey ŋga ləvey, Gazlavay fa wey da ray akwar cay.» ");
INSERT INTO mif_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yesu a ŋgey mey saya, a ləvey: «Da ndaw masa-gədaŋ fa jəɗa zleley aŋga ta cek ma ka vəram na, zleley aŋga ha mapakaya maaya maaya, cek a wusfar ba. ");
INSERT INTO mif_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ama da ndaw mekele ma fəna ta gədaŋ a sawa, a kərza ndaw aha, a pərslara cek mekey vəram aŋga hay tabiya masa aŋga ma jəɗa zleley aŋga ta aŋga. A həlra zleley aŋga tabiya, a wunkatara a ndəhay aŋga hay. ");
INSERT INTO mif_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Yaw, da ndaw aa ta yah daa ba na, ŋgene ndaw a ara masa-gəra aɗaw. Asaya, da ndaw a gəmey ŋga jənya ŋga ɓəcwa ndəhay aa cəveɗ aɗaw ba na, a key ŋgene, aa waɗatar ray.» ");
INSERT INTO mif_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesu aa guzley saya, a ləvey: «Da masa malula ta bey sem da ray ndaw na, a daw a pəkey da ley saw, a səpey slam ŋga məskey vaw. Da ta hətey daa ba na, a ləvey: “Ŋgama ya vəhey aa slam aɗaw masa yah ma bawa da hwaɗ a heyey.” ");
INSERT INTO mif_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ta’, a vəhey a ray ndaw aha aa slam aŋga heyey, a hətfar slam aha maɗiykaya maaya maaya. ");
INSERT INTO mif_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Da ray ŋgene, malula ha a daw a ŋgəlwa malula hay mekele maasala ma fənmara ta həma. A samawa a ray ndaw a heyey. Anda keɗe, ndaw aha a da sərey banay ma fəna masa ŋgeeme.» ");
INSERT INTO mif_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Masa Yesu ma kada mey keɗe la na, ŋgwas daha da wuzlah ndəhay makustakaya kaa heyey, aa guzlar a Yesu, a ləvar: «Maaya ŋga Gazlavay aa da ray ŋgwas masa kah ma yawa da hwaɗ aŋga, kah ma sa ɗəwa aŋga!» ");
INSERT INTO mif_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu a ləvar: «Ahaw, ama maaya ŋga Gazlavay ŋga sawa jak na, a ray ndəhay ma jəkam sləmay fa mey ŋga Gazlavay, ma kadamara sləra ta mey a.» ");
INSERT INTO mif_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ndəhay ga fa kusmawa ma fəna ma fəna a cakay Yesu. Yesu a zlar ŋgaa guzley, a ləvey: «Ndəhay masa wure keɗe kaa na, maaya ba hay. Aa cəfɗam maazla masa da gazlavay da vaɗ ma wuzda ara Gazlavay ma slərdiwa. Ama a hətmar maazla ha daa ba, si maazla anda ma key ta *Jawnas, *ndaw ma təla mey ŋga Gazlavay zleezle. ");
INSERT INTO mif_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Anda Gazlavay ma ka maazla ta Jawnas zleezle ŋgada ndəhay daa berney ŋga Niniwe, ara kəne may ta yah, *Bəz ŋga Ndaw, ma da tərey ŋga maazla ŋgada ndəhay masa wure keɗe. ");
INSERT INTO mif_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Yaw, ta pas sariya masa Gazlavay ma da ka na, ŋgwas ma key bay daa hwayak ŋga Saba zleezle, a lacawa ray la ŋga mbəɗkwar ray, akwar ndəhay masa wure keɗe, maja aŋga na, a sawa da dəreŋ ŋga cəney mey maaya ŋga Bay *Salamaŋw, ndaw ta leŋgesl. Nəkmara, da wuzlah akwar feɗe, ndaw ma fəna Bay Salamaŋw daha! ");
INSERT INTO mif_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ta pas sariya na, ndəhay daa berney ŋga Niniwe heyey, a lacamawa ray la ŋga mbəɗmakwar ray, akwar ndəhay masa wure keɗe, maja daa masa ata ma cəndamara mey ŋga Gazlavay masa Jawnas ma wuzdatara na, ta mbəɗdamara menjey ata sem. Nəkmara, da wuzlah akwar feɗe, ndaw ma fəna Jawnas daha!» ");
INSERT INTO mif_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesu aa guzltar ta mey-meŋgey: «Da ndaw ta gəɗey awaw la aa petərla ŋga weɗey slam na, a ɗəpa ba. Ama a pa aa slam mepey petərla ŋga waɗa slam daa way a, amba ndəhay ma mbəzam a hwaɗ a na, a hətmar dey. ");
INSERT INTO mif_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Bəz ŋga dey akah na, fa waɗa vaw akah anda petərla ma waɗa slam. Da bəz ŋga dey akah aŋga maaya maaya na, kah daa slam-meweɗey. Ama da dey akah aa maaya ba na, ŋgene, kah daa ləvaŋ. ");
INSERT INTO mif_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Anda keɗe, wey vaw anja slam-meweɗey daa kah ŋgene na, ŋga tərey ŋga ləvaŋ ba. ");
INSERT INTO mif_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ama da vaw akah cəpa aa daa slam-meweɗey, ləvaŋ da hwaɗ a kwa kuset kəɗey daa ba na, ŋgene, vaw akah a da weɗey anda petərla ma waɗa slam.» ");
INSERT INTO mif_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Masa Yesu ma ndəvda meeguzley cay na, ndaw Fariza daha a zəla a way aŋga ŋga zəmey ɗaf. Ta’, a diyam, a mbəzam a way a, a njam ŋga zəmey ɗaf. ");
INSERT INTO mif_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ndaw Fariza heyey a rəzley, maja Yesu ta pəra har ŋga zəmey ɗaf anda kwakwas ŋga *Fariza hay a ma ləvey na, daa ba. ");
INSERT INTO mif_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bay Mahura a ləvar: «Akwar Fariza hay, akwar fa pərmara dəɓa ŋga vəley ŋga ɗaf ta vəley ŋga yam akwar hay maaya maaya ŋga səpey kwakwas akwar, ama mevel akwar na, marəhkaya ta mewulkey ŋga leley, ta ŋga key maagway. ");
INSERT INTO mif_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Akwar ndəhay marəzltakaya hay! Gazlavay ma karawa dəɓa ŋga cek hay a na, ta karawa hwaɗ a daa ba daw? ");
INSERT INTO mif_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ama da ka wuɗam mevel akwar ŋga tərey maaya fa mey ŋga Gazlavay, maaya na, ka vəlmatar cek masa daa vəley akwar hay a masa-viya hay. ");
INSERT INTO mif_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Banay a sawa la a ray akwar, akwar Fariza hay. Akwar fa wunkamata cek akwar hay tabiya slam kuraw, akwar fa vəldamara slam pal a Gazlavay, kwa cek hay mecəhe mecəhe ma cərda lar, ta gwaslaf ŋga lar mekele mekele daa jerne akwar hay na, akwar fa wunkamara kəne may. Ama ka sərfadamara ŋga key cek maaya ta cəveɗ e a ndəhay ba. Asaya, ka wuɗmara Gazlavay ba. Sasəkar jak, cek hay a ŋgene na, ara cek hay maaya ŋga key. Ka da mbəkdamara ŋga key cek hay siya hay ba may. ");
INSERT INTO mif_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Banay a sawa la a ray akwar, akwar Fariza hay, maja daa *way-mewuzey-mey ŋga Gazlavay na, ka wuɗam menjey aa slam maaya masa fa mey. Ka wuɗam ndəhay a camakwar har ta meney ray fa mey ŋga ndəhay makustakaya ga. ");
INSERT INTO mif_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Banay a sawa la a ray akwar, akwar Fariza hay, maja akwar anda cəvay hay ma hətey ba masa ma katar hezey a ndəhay ma diyam ta ray a, kwa a sərmara ba.» ");
INSERT INTO mif_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ndaw pal da wuzlah *ndəhay maa sərkada kwakwas ŋga Mawiz a mbəɗdara, a ləvar: «Waa bay ala, kaa guzley anda keɗe na, a key ka cəɗndar ala ndəhay maa sərkada kwakwas may.» ");
INSERT INTO mif_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu a mbəɗdara, a ləvar: «Akwar ndəhay maa sərkada kwakwas ŋga Mawiz may, banay a sawa la a ray akwar, maja akwar fa bamawa kwakwas hay maadakw a maadakw a masa ndəhay a gwamara ŋga səpmara ba. Ama ka gəmam ŋga jənmata ŋga səpey kwakwas hay a, kwa nekəɗey ba. ");
INSERT INTO mif_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Banay a sawa la a ray akwar, akwar masa ma ləmamata cəvay hay ŋga ndəhay ma təla mey ŋga Gazlavay zleezle ŋga mbey, anja ara papaŋ ŋga papakw akwar hay ma kəɗmata jak. ");
INSERT INTO mif_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Anda keɗe, akwar fa wuzdamara a ndəhay sləra ŋga papaŋ ŋga papakw akwar hay ŋgene na, a mbafakwar. Ata na, ta kəɗmata ndəhay ma təla mey ŋga Gazlavay zleezle sem, akwar kwa ka ləmamata cəvay ata hay maaya maaya. ");
INSERT INTO mif_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Maja ŋgene, Bay Gazlavay ma səra cek tabiya, a ləvey: “Ya da slərwa ndəhay ma təla mey aɗaw, ta ndəhay meslərey. A da sərdamata banay ta siya hay da wuzlah ata, siya hay may, a da kəɗmata vagay.” ");
INSERT INTO mif_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Da ray ŋgene, mambaz ŋga ndəhay ma təla mey ŋga Gazlavay tabiya masa ma məcam dəga ŋga mezley ŋga bəla na, a hufey la a ray ndəhay masa wure keɗe. ");
INSERT INTO mif_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","A kəɗam teeseɗ na, *Abel. Asaya, ta kəɗam ndəhay mekele mekele la haa kasl fa *Zakari masa ata ma kəɗmara daa walaŋ ŋga slam-mefəkey cek ŋgada Gazlavay ta *Way ŋga Gazlavay. Fara fara, ya fa ləvkwar, Gazlavay a katar sariya la a ndəhay masa wure keɗe maja ata. ");
INSERT INTO mif_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Akwar ndəhay maa sərkada kwakwas ŋga Mawiz, banay a sawa la a ray akwar maja akwar ta ɓadamara mey ŋga Gazlavay sem fa ndəhay anda ndaw ma ɓey lekəle ŋga mey-slam.» ");
INSERT INTO mif_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Masa Yesu ma bawa la da way ndaw Fariza heyey na, ndəhay maa sərkada kwakwas ŋga Mawiz ta Fariza hay, mevel a catar ga. Ta’, aa cəfɗamara da ray mey hay mekele mekele, ");
INSERT INTO mif_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","amba da ta hətam mey maaya ba la na, a dadəɗfamar mey. ");
INSERT INTO mif_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Daa masa Yesu fa kam yawa ta *Fariza hay leŋ ta *ndəhay maa sərkada kwakwas ŋga Mawiz heyey na, ndəhay ga ta kusam la, a key gabal weewe, kwa slam ŋga lecey daa ba. Yesu aa guzltar a gula aŋga hay ɗagay, a ləvtar: «Wam vaw fa cek ma həsla peŋ ŋga Fariza hay. Anda meləvey, wam vaw fa Fariza hay, ndəhay masa ta neneh cew. ");
INSERT INTO mif_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Cek tabiya masa ndəhay ma ɓadamara, a wuzwa la a palah, cek hay masa ndəhay ma sərmara ba na, a sərmara la. ");
INSERT INTO mif_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Maja ŋgene, cek tabiya masa akwar ma kadamara ta tavaɗ daa ləvaŋ na, ndəhay tabiya a cəndamara la taa pas. Mey tabiya masa akwar maa səkdamara taa səkey da ver na, a wuzdamara la ta gədaŋ daa slam metəley mey.» ");
INSERT INTO mif_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesu a ləvtar: «Ya fa ləvkwar, jam aɗaw hay, ka da zluram ta ndəhay ma da kəɗmakwar vagay ba, maja a da kəɗam na, vaw akwar daada gway. Fa dəɓa ha, fa da gwamara ŋga kamakwar cek mekele daa saba. ");
INSERT INTO mif_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Amba ya wuzdakwara ndaw masa akwar ma da zluram ta aŋga. Zluram na, ta Gazlavay gway, maja ta kəɗkwar vagay la na, fa dəɓa ha, a gwa ŋga kəzlakwar aa vəgeɗ ŋga awaw magaza saya. Fara fara, ya fa ləvkwar, zluram ta aŋga. ");
INSERT INTO mif_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Ɗiyaŋ mecəhe mecəhe zlam na, a gwa ŋga həɗkedey dala cew daada, ba daw? Ama Gazlavay a sərta ɗiyaŋ hay a pal pal tabiya. ");
INSERT INTO mif_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Akwar may, kwa eŋgwec ŋga ray akwar hay na, masləftakaya pal pal tabiya. Ka da zluram ba! Akwar na, Gazlavay a wuɗkwar a fəna ɗiyaŋ hay mecəhe mecəhe ga ŋgene, ba daw?» ");
INSERT INTO mif_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesu a ləvtar saya: «Ehe, ya fa ləvkwar saya, kwa waawa ma ləvey fa mey ŋga ndəhay, aŋga ndaw aɗaw na, ŋgene, yah, *Bəz ŋga Ndaw, ya da ləvey fa mey ŋga maslaŋ hay ŋga Gazlavay da vaɗ ta pas sariya, aŋga ndaw aɗaw may. ");
INSERT INTO mif_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama ndaw ma ləvey fa mey ŋga ndəhay a sərya ba na, yah, Bəz ŋga Ndaw, ya da ləvey fa mey ŋga maslaŋ hay ŋga Gazlavay ta pas sariya, ya səra ba may. ");
INSERT INTO mif_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Kwa waawa maa guzley mey maaya ba da ray aɗaw, yah, Bəz ŋga Ndaw na, Gazlavay a mbəkdara mebərey aŋga la. Ama ndaw ma cəɗa *Mesəfney ŋga Gazlavay na, Gazlavay fa da mbəkdara mebərey aŋga daa ba səlak. ");
INSERT INTO mif_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Da a handamakwar aa *way-mewuzey-mey ŋga Gazlavay ŋga key sariya, da daa ba, fa mey ŋga ndəhay mahura hay ta bay hay amba a kamakwar sariya na, ka da zluram ba, ray akwar a da həɓey da ray mey masa akwar ma da mbəɗdamatara ŋga ləhey ray akwar ba. ");
INSERT INTO mif_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mey masa akwar ma da mbəɗdamatara na, Mesəfney ŋga Gazlavay a wuzdakwara la ta pas ŋgene.» ");
INSERT INTO mif_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ndaw pal da wuzlah ndəhay ga da cakay Yesu heyey a ləvar: «Bay aɗaw, ləvar a məlma aɗaw mahura ŋga wunkandara zleley ŋga papa ala ma mbəkdandara cey!» ");
INSERT INTO mif_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu a mbəɗdara, a ləvar: «Jam aɗaw, ma paya ŋga ɗəsley mey da wuzlah akwar ta ŋga wunkakwara zleley akwar na, wa?» ");
INSERT INTO mif_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Fa dəɓa ha, aa guzltar a ndəhay tabiya, a ləvtar: «Wam vaw, ka da səpam ŋga key zleley ta har akwar ba. Kwa ndaw, aŋga ta zleley ga na, heter aŋga fa da njey maja zleley a na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ta’, aa guzltar mey-meŋgey, a ləvtar: «Ndaw daha, aŋga ta zleley ga. Ley aŋga hay ta kam cek la maaya maaya. ");
INSERT INTO mif_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Anda keɗe, ndaw aha, a wulkey, a ləvey: “Slam ŋga pata cek aɗaw hay daa saba. Ya da key na, kwara?” ");
INSERT INTO mif_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Fa dəɓa ha, a ləvey: “Aha! Ya səra cek masa yah ma da ka. Ŋgama ya həɓta wudeɗ aɗaw hay cəpa, ya ləmta mahura mahura, ya ɓəcta daw aɗaw ta zleley aɗaw hay tabiya a hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Fa dəɓa ha, ya da ləvey: Zleley aɗaw fa da ndəvey daa ba, a key mevey weewe la. Ya da məskey vaw, ya da zəmey cek, ya da sey cek, ya da njey daa wiya.” ");
INSERT INTO mif_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«Ama Gazlavay a ləvar a ndaw aha: “Kah na, ndaw marəzlkaya, dasi tavaɗ keɗe, ya da la mesəfney akah. Zleley masa kah ma ɓəca ŋgene na, ŋgada wa?”» ");
INSERT INTO mif_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Da ray ŋgene, Yesu a wuzdatara mey a, a ndəhay da cakay a heyey, a ləvtar: «Ndəhay masa ma ɓəcam zleley da bəla keɗe ŋgada ata ray ata na, a key ŋgene, a kam cek ma mbafar a Gazlavay ba. Ata letek ta ndaw a keɗe.» ");
INSERT INTO mif_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Fa dəɓa ha, Yesu aa guzltar a gula aŋga hay, a ləvtar: «Maja ŋgene, ya fa ləvkwar fara fara, daa menjey akwar na, ray akwar a da həɓey da ray cek mezəmey ta cek mesey ba. Asaya, ray akwar a da həɓey da ray zana ŋga kəzley fa vaw akwar ba. ");
INSERT INTO mif_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ya ləvkwar anda keɗe na, maja cek mezəmey a fəna heter akwar ba, zana may, a fəna vaw akwar ba. ");
INSERT INTO mif_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","«Yaw, wulkam da ray ɗiyaŋ hay cey! Fa sləkam daa ba, fa ŋgəmam daw daa ba, kwa wudeɗ ata hay daa ba, ama Gazlavay fa vəltar cek mezəmey cəŋga. Akwar na, ka fənmata ɗiyaŋ hay ba daw? ");
INSERT INTO mif_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Da wuzlah akwar ndaw ma gwa ŋga pey kwa ɗar pal a ray ɗar aŋga da bəla ta mewulkey aŋga na, wa? ");
INSERT INTO mif_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Da ka gwamara mekey cek mecəhe ba na, ka həɓam ray da ray cek hay mekele na, maja me? ");
INSERT INTO mif_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Nəkmara meefekwey hay da ley cey! Aa fakwam na, kwara? A kam sləra ba, a cam zana ba, ama ya fa ləvkwar, kwa Bay *Salamaŋw zleezle ta zleley ga ta gwa ŋga kəzley zana ma mbey anda meefekwey pal na, daa ba. ");
INSERT INTO mif_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gazlavay a ka amba kusaf aa fekwey tasana, ama mandaw na, kusaf a, a wewurey. Da Gazlavay fa key cek maaya ŋgada kusaf masa awaw ma da wawura anda keɗe na, Gazlavay a nəkfakwar dey ma fəna kusaf a ŋgene daa ba daw? Akwar masa ma pamara Gazlavay ŋga ndaw akwar fara fara ba ŋgene, sərmara Gazlavay a kəzlkwar zana la ma fəna meefekwey hay a. ");
INSERT INTO mif_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Anda keɗe, ray akwar a da həɓey mandaw mandaw da ray cek mezəmey ta da ray cek mesey ba. Ka da zluram maja cek hay a ba. ");
INSERT INTO mif_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ma həɓam ray maja cek hay a ŋgene na, ndəhay da bəla keɗe masa ma sərmara Gazlavay ba. Ama akwar na, Papakw akwar, Bay Gazlavay, a səra cek masa akwar ma wuɗam. ");
INSERT INTO mif_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Anda keɗe, səpam na, Gazlavay ŋga wey da ray akwar. Fa dəɓa ha, Bay Gazlavay a vəldakwara cek hay siya la may.» ");
INSERT INTO mif_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yesu a ləvtar a gula aŋga hay: «Akwar na, ga daa ba anda təɓaŋ hay masa ŋguyer kəɗey, ama ka da zluram ba, maja ta mbafar la a Papakw akwar amba a vəlkwar cek hay maaya masa aŋga ma ɗiytara ŋgada ndəhay masa aŋga fa wey da ray ata. ");
INSERT INTO mif_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Həɗkadamata cek akwar hay, wunkamatara dala ha a masa-viya hay. Səpam ŋga ɓəcey zleley na, aa slam masa menjey ŋga sərmataw da vaɗ. Feteɗe zleley akwar a fa da ndəvey daa ba. Anda keɗe, mayal hay a gwamara ŋga lalamara daa ba, kwa maaca a gwa ŋga nəsa ba. ");
INSERT INTO mif_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sərmara, daa slam masa zleley akwar aa da hwaɗ a na, mevel akwar may aa feteɗe.» ");
INSERT INTO mif_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesu a ləvtar: «Njam vaw maɗiykaya mandaw mandaw ŋga key sləra ŋgada Gazlavay. Ka da məcmata petərla akwar hay ba, ");
INSERT INTO mif_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","anda ndəhay ma ka sləra ma səkwmara bay ŋga way ma lawa daa gwagway ŋga kwakwa ta tavaɗ. A səkwmara amba a wurmara mey-mbew fiyaw da masa ta vəhwa cay, fa zəley fa mey-mbew. ");
INSERT INTO mif_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Da bay ŋga way a sawa, a hətfatar ata ta dey na, meesəmey daha ŋgada ndəhay ma ka sləra hay a. Ya fa ləvkwar fara fara, bay ŋga way a, a pa zana ŋga sləra fa vaw, a zəltərwa, a njadata, a vəltar cek mezəmey. ");
INSERT INTO mif_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kwa a vəhwa ta wuzlah-tavaɗ, kwa ta slam ŋgaa pərek, a hətfatar ata ta dey na, meesəmey daha ŋgada ndəhay a. ");
INSERT INTO mif_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Jəkam sləmay maaya maaya, da bay ŋga way a səra ɗar masa ndaw-mayal ma da daw a way aŋga na, a mbəkda ndaw-mayal a ŋga sləna way aŋga ha la daw? ");
INSERT INTO mif_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yaw, akwar may, wam vaw maaya maaya maja yah, *Bəz ŋga Ndaw, ya da vəhwa na, kwa ka sərmara ɗar a ba.» ");
INSERT INTO mif_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","*Piyer aa cəfɗa Yesu, a ləvar: «Bay Mahura, kaa guzley ta mey-meŋgey keɗe na, ŋgada ala daw, ŋgada ndəhay tabiya daw?» ");
INSERT INTO mif_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bay Mahura a mbəɗdara, a ləvar: «Ndaw ma ka sləra maaya ta leŋgesl na, wura? Ndaw ma ka sləra maaya ta leŋgesl na, ara ndaw masa bay aŋga ma da pa ŋga mahura da ray ma ka sləra aŋga hay cəpa, amba a vəltar cek mezəmey daa masa may fa catar. ");
INSERT INTO mif_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Da masa bay aŋga ha a sawa a hətfar aŋga fa ka sləra ha na, ndaw ma ka sləra ha aa səmey la. ");
INSERT INTO mif_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ya fa ləvkwar fara fara, bay aŋga ha, a da vəldara zleley aŋga hay cəpa a har aŋga amba a nəkfar dey. ");
INSERT INTO mif_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ama ndaw ma ka sləra masa ma ley mewulkey aŋga wal na, a ləvey: “Bay aɗaw fa da vəhwa gweegwe daa ba.” Ta’, a kəɗta ndəhay ma ka sləra hay mezəle hay ta maŋgusa hay. A zəmey cek, a sey wuzam, a wey. ");
INSERT INTO mif_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Fa dəɓa ha, bay aŋga ha na, a da vəhwa ta pas masa ndaw ma ka sləra ha fa wulkey da ray a daa ba, asaya, kwa fa da səra ler e daa ba. Bay aŋga ha a da ɓəla da way aŋga, a da sərda banay anda aŋga ma da sərdata banay ta ndəhay ma təɓa mey ŋga Gazlavay ba.» ");
INSERT INTO mif_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Yesu a ləvar saya: «Ndaw ma ka sləra masa ma səra cek masa bay aŋga ma wuɗey, ama a wey vaw fa sləra aŋga ba, asaya, a key cek masa aŋga ma ləvar ba na, ndaw aha, a hətey mekəɗey ga la. ");
INSERT INTO mif_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Da ndaw ma ka sləra laŋgar a səra cek masa bay aŋga ma wuɗey ba, ama ta key cek maaya ba la təɗe ŋga kəɗey na, a da hətey mekəɗey nekəɗey gway. Ndaw masa Gazlavay ta vəlar cek la ga a har aŋga na, a daa cəfɗafar ga kəne may. Ndaw masa Gazlavay ta vəlar sləra mahura la ŋga key na, a daa cəfɗafar ŋga ka sləra ha maaya maaya ma fəna.» ");
INSERT INTO mif_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesu a ləvtar a gula aŋga hay: «Ya sawa na, ŋga pey awaw fa bəla keɗe. Ya wuɗey na, awaw a, a gəɗey dəga wure keɗe. ");
INSERT INTO mif_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Si a sərdamaya banay ga kasl fa meməcey . Ray aɗaw fa həɓey kasl pas masa banay a ma da ndəvey. ");
INSERT INTO mif_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ka wulkam ya sawa na, ya handawa zazay a bəla daw? Kay! Kəne ba. Ya fa ləvkwar, ya sawa ŋga wunkey ndəhay. ");
INSERT INTO mif_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dəga wure keɗe, ndəhay zlam da way, a wunkam la, maakar a cəmam la a ray cew, cew a cəmam la a ray maakar. ");
INSERT INTO mif_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yaw, bay ŋga way a wuɗkam ɗay la ta bəzey aŋga, bəzey a wuɗkam ɗay la ta papaha, ŋgwas a wuɗkam ɗay la ta dam aŋga, dam a wuɗkam ɗay la ta mamaha, mamaŋ ŋga bəzey a wuɗkam ɗay la ta ŋgwas ŋga bəzey aŋga, ŋgwas ŋga bəzey a wuɗkam ɗay la ta mamaŋ ŋga zel e.» ");
INSERT INTO mif_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu a ləvtar a ndəhay ga da cakay a: «Anja ka hətmar gazlavay ŋga var fa lawa ta mey-aŋgwa , wure ŋgene ka ləvam: “Var fa sawa.” Fa dəɓa ha, var a, a pey fara. ");
INSERT INTO mif_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Da ka hətmar memeɗ fa kawa ta dey ŋga Məzam na, ka ləvam: “Mawurɓay a key la.” Fa dəɓa ha, mawurɓay a, a key fara. ");
INSERT INTO mif_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Akwar ndəhay masa ta neneh cew, ka gwamara ŋga wunkamara cek ma key da bəla ta cek ma key da gazlavay da vaɗ, ama ka sərmara cek ma key wure keɗe ba na, maja me?» ");
INSERT INTO mif_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yesu a ləvtar saya: «Akwar ta ray akwar ka sərmara cek masa maaya ŋga key ba na, kwara? ");
INSERT INTO mif_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Da ndaw a wudka, akwar fa diyam cew e aa sariya na, ɗiymara mey a dəga daa cəveɗ. Da daa ba na, a da handaka fa ndaw ma ka sariya, ndaw ma ka sariya ha a da vəldaka a har sewje hay. Sewje hay may, a da kəzlamaka aa fərsəne. ");
INSERT INTO mif_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ya fa ləvka, ka fa da bawa daa fərsəne he daa ba səlak, si kah ma pəla dəvaz a la tabiya ndav.» ");
INSERT INTO mif_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Daa ŋgene, ndəhay feteɗe daha, aa guzlmar a Yesu, a ləvmar: «Bay Pilat ta kəɗey ndəhay *Galile la vagay daa masa ata fa həram gənaw hay ŋgada Gazlavay. A cəma mambaz ata ta mambaz ŋga gənaw hay a.» ");
INSERT INTO mif_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu a mbəɗdatara, a ləvtar: «Ka wulkam mebərey ŋga ndəhay Galile hay a ŋgene a fəna ŋga Galile hay siya, maja ata ma məcam anda ŋgene daw? ");
INSERT INTO mif_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ya fa ləvkwar a fəna ba səlak! Ama da akwar ta mbəɗdamara menjey akwar daa ba na, akwar cəpa ka daa zəɗam kəne may. ");
INSERT INTO mif_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yaw, wulkam da ray ndəhay kuraw a ray a daaŋgafaɗ masa way magəlkaya maazəma da slala Siləwe ma bəzlwa a ray ata heyey. Ka wulkam na, a fənmata ndəhay siya da *Jeruzelem ta mebərey daw? ");
INSERT INTO mif_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ya fa ləvkwar a fənmata ba səlak! Ama da akwar ta mbəɗdamara menjey akwar daa ba na, akwar cəpa ka daa zəɗam kəne.» ");
INSERT INTO mif_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu ta’, a ŋgatar mey, a ləvtar: «Ndaw daha a rəvey wudez aa ley aŋga. Fa dəɓa ha, a sawa amba a ŋgəley babəza ŋga wudez e, ama wudez e, ta yey babəza daa ba. ");
INSERT INTO mif_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bay ŋga wudez e, a ləvar a ndaw ma jəɗa ley aŋga ha: “Nəka wudez keɗe, mevey maakar ya fa sawa amba ya ŋgəley babəza fa vəɗa, ama babəza fa vəɗa daa ba. Ɗəsla wudez e, maja fa təka slam ŋga maaya.” ");
INSERT INTO mif_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ama ndaw ma jəɗa ley a, a mbəɗdara, a ləvar: “Bay aɗaw, mbəkda ta ləmla keɗe ɗagay, amba ya gudha si-wurza, ya həlar gəraŋ asiya. ");
INSERT INTO mif_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Da səfeɗ na, a yey la kwa. Da ta yey daa ba cəŋga na, ka ɗəsla.”» ");
INSERT INTO mif_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ta *pas meməskey-vaw daha, Yesu faa sərkadata ndəhay daa *way-mewuzey-mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ŋgwas daha, aa ta malula da ray mevey kuraw a ray a daaŋgafaɗ. Malula ha ta hurma sem. A gwa ŋga lecey der e ba. ");
INSERT INTO mif_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Masa Yesu ma hətar ŋgwas aha na, ta’, a zəla, a ləvar: «Mamay, malula masa ma hurmaka ŋgene na, daa saba.» ");
INSERT INTO mif_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ta’, a par har a ray. Wure wure ŋgene, ŋgwas aha deŋ! a lecey. A həlma Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ama *bay-ray ŋga way-mewuzey-mey a, mevel a car maja Yesu ma mbəley ndaw ta pas meməskey-vaw ŋgene. Da ray ŋgene, aa guzltar a ndəhay makustakaya daa way a, a ləvtar: «Ɗar maakwaw daha ŋga key sləra, da ka wuɗam membəley na, samawa ta pas hay a ŋgene, ama ka da samawa ta pas meməskey-vaw ba!» ");
INSERT INTO mif_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bay Mahura a mbəɗdara a ndaw a, a ləvar: «Akwar, ndəhay masa ta neneh cew! Ta pas meməskey-vaw na, akwar fa pəskamata sla akwar hay ta zəŋgwaw akwar hay da gezleŋ, ka handamata ŋga samawa yam, ba diya? ");
INSERT INTO mif_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yaw, ŋgwas daa səkway ŋga *Abəraham keɗe, aŋga majəwkaya da har *Sataŋ, bay-malula, mevey kuraw a ray a daaŋgafaɗ. Aŋga na, ya pəska ta pas meməskey-vaw ba na, maja me?» ");
INSERT INTO mif_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Masa Yesu ma mbəɗdatara anda keɗe la na, hwaray a katar a masa-gəra aŋga hay tabiya. Ama ndəhay makustakaya na, aa səmam da ray sləra hay mekele mekele maaya masa Yesu ma kata. ");
INSERT INTO mif_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Fa dəɓa ha, Yesu aa guzltar, a ləvtar: «Mewey ŋga Bay Gazlavay da ray ndəhay na, aŋga anda me? Ya da wa na, ta me? ");
INSERT INTO mif_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ya wa ta babəza ŋga bazlawar masa ndaw ma la, ma rəɓa aa ley aŋga. Babəza ŋga bazlawar aha, ta’, a pəcwa, a gəley mahura. Ɗiyaŋ hay a ɗiyam way fa mey-har hay a.» ");
INSERT INTO mif_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu a ləvtar saya: «Ya da wa mewey ŋga Bay Gazlavay da ray ndəhay na, ta me? ");
INSERT INTO mif_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ya wa ta cek ma həsla makala masa ŋgwas ma həley kuset kəɗey, ma jahaɗa ta hapa ŋga makala ga, amba a həslərwa tabiya.» ");
INSERT INTO mif_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu fa daw ŋgada *Jeruzelem, a daw taa berney hay leŋ ta slala hay, faa sərkadata ndəhay. ");
INSERT INTO mif_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Daa ŋgene ndaw daha, aa cəfɗa, a ləvar: «Bay Mahura, Gazlavay a da ləhey daa mebərey na, ndəhay nekəɗey gway daw?» Ta’, Yesu aa guzltar a ndəhay feteɗe, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Kam gədaŋ amba ka mbəzam taa mey-mbew meeŋgəlez e aa slam masa Bay Gazlavay fa wey da ray ndəhay. Ya fa ləvkwar, ndəhay ga a jadamara la, amba a mbəzam, ama fa da gwamara daa ba. ");
INSERT INTO mif_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","«Yaw, pas pal bay ŋga slam aha a da sləkɗey ŋga gərca mey-mbew. Ŋgene, ka da lacam aa ambaw, ka da zəlam fa mey-mbew, ka ləvam: “Bay ala, wurndara mey-mbew may taw!” Ama a da mbəɗdakwara, a ləvkwar: “Ya sərkwar ba! Ka samawa na, dama?” ");
INSERT INTO mif_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Fa dəɓa ha, ka da zlamar ŋgaa guzlmar, ka ləvam: “Aləkwa ta zəmkwa cek la bama, aləkwa ta sakwa cek la bama, ka taa sərkadandar la daa cəveɗ ala hay mepəkey.” ");
INSERT INTO mif_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A da ləvkwar saya: “Ya sərkwar ba! Ka samawa na, dama? Akwar ndəhay tabiya masa ma ka cek maaya ba hay, ŋgəcham la da cakay aɗaw.” ");
INSERT INTO mif_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ta pas masa akwar ma da hətmatar ata *Abəraham, *Izak, *Jakwap, leŋ ndəhay ma təla mey ŋga Gazlavay zleezle tabiya, manjatakaya da cakay Bay Gazlavay na, ŋgene, ka da təwam, ka daa pəɗam sler maja akwar mambəkdatakaya daa ambaw. ");
INSERT INTO mif_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ta pas masa Gazlavay ma da wuzdərwa bay aŋga na, ndəhay daa səkway hay mekele mekele a samawa la daa slam hay tabiya da bəla, ŋga key gwagway da vaɗ. ");
INSERT INTO mif_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yaw, da wuzlah ndəhay madagway-dakw na, siya a da təram ndəhay ŋgeeme, asaya, da wuzlah ndəhay ŋgeeme na, siya a da təram ŋga madagway-dakw.» ");
INSERT INTO mif_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ta pas ŋgene, ndəhay da wuzlah *Fariza hay daha a ŋgəchamawa fa Yesu amba a wuzmar mey, a ləvmar: «Daw la feɗe aa slam mekele maja Bay *Herawt a wuɗey ŋga kəɗka vagay.» ");
INSERT INTO mif_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu a mbəɗdatara, a ləvtar: «Diyam ləvmar a mbiga ha: “Ehe, ya fa ɓəley malula hay da ray ndəhay, ya fa mbəley masa-macay hay, tasana, mandaw, ŋga ɗar maakar a ya da ndəvda sləra aɗaw.” ");
INSERT INTO mif_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Anda meləvey si ya ley cəveɗ, ya daw tasana, mandaw, mandaw laŋgar saya, maja ndəhay a gwamara ŋga kəɗmara *ndaw ma təla mey ŋga Gazlavay dəreŋ ta *Jeruzelem ba səlak.» ");
INSERT INTO mif_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Fa dəɓa ha, Yesu a ləvey: «Haya! Akwar ndəhay da Jeruzelem , akwar ndəhay da Jeruzelem, Gazlavay a slərkwar ndəhay ma təla mey aŋga hay na, ka kəɗmata vagay. Asaya, a slərkwar maslaŋ aŋga hay na, kaa zakamata ta aŋgwa. Ama mandaw mandaw ya wuɗey amba ya ɓəckwar tabiya akwar anda gwagwar ma ɓəcta bəz aŋga hay asi kərpasl, ama ka wuɗam ba. ");
INSERT INTO mif_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Cəndamara, Gazlavay a da la har aŋga da ray akwar, Way-mekey-kwakwas akwar a da tərey yideŋ. Yah fa ləvkwar, akwar fa da hətmaya fa dey daa saba haa ta pas masa akwar ma da ləvam: “Anja Bay Gazlavay ŋga pəsar mey ŋgada ndaw masa aa ma slərdərwa ta mezəley aŋga.”» ");
INSERT INTO mif_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ta *pas meməskey-vaw, Yesu ta’, a daw a way ndaw pal da wuzlah mahura hay ŋga *Fariza hay ŋga zəmey ɗaf. Ndəhay manjatakaya feteɗe, fa saŋgalamara Yesu ta dək-vaw da ray cek masa aa ma da ka. ");
INSERT INTO mif_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ndaw da wuzlah ata daha, mambakaya ta mbey. Ndaw a malacakaya fa mey aŋga. ");
INSERT INTO mif_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu ta’, aa guzltar ŋgada *ndəhay maa sərkada kwakwas ŋga Mawiz ta ŋgada Fariza hay, a ləvtar: «Kwakwas aləkwa a ləvey na, kwara? Membəley ndaw masa-macay ta pas meməskey-vaw na, maaya daw, maaya ba daw?» ");
INSERT INTO mif_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ama ndəhay a, a gəmam ŋga mbəɗdamara ba. Ta’, Yesu a gəsfar har fa ndaw masa-macay heyey, mbal! a mbəlda, ta’, a mbəkda ŋga daw. ");
INSERT INTO mif_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Fa dəɓa ha, aa cəfɗata, a ləvtar: «Da ndaw da wuzlah akwar aŋga ta bəzey, da daa ba, aŋga ta sla, yaw, da bəzey a, da daa ba, sla ha a təɗey aa ɓəlndaw na, ndaw aha a badərwa fiyaw fiyaw, kwa ta pas meməskey-vaw, daa ba daw?» ");
INSERT INTO mif_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kwa ndəhay a, ta gwamara ŋga mbəɗdamara aa mey ŋga Yesu a daa ba. ");
INSERT INTO mif_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu fa nəkta ndəhay ma samawa ŋga zəmey ɗaf da way ndaw Fariza heyey. A səpam slam-menjey na, si ŋga ndəhay mahura hay. Maja ŋgene, Yesu a ŋgatar mey, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Da ndaw a zəlkwar ŋga zəmey ɗaf ŋga gwagway ŋga meley kwakwa na, ka da səpey ŋga njey aa slam ŋga ndaw mahura ba. Da kaa təɗe ta zəlwa ndaw mahura da ray akah la aa gwagway a kwa. ");
INSERT INTO mif_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Anda keɗe, bay ŋga way a, a sawa, a da ləvka: “Mbəkda slam keɗe a ndaw keɗe.” Maja ŋgene, ka da mbəkda slam aha, ka da njey fa dəɓa ta hwaray a. ");
INSERT INTO mif_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ama da ta zəlmaka la ŋga zəmey ɗaf ŋga gwagway na, daw ta njey fa dəɓa, amba bay ŋga way a, a sawa, a ləvka: “Jam aɗaw, sawa aa slam ŋga ndəhay mahura hay keɗe.” Anda keɗe, a həslka ray fa mey ŋga ndəhay tabiya daa gwagway a. ");
INSERT INTO mif_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yaw, fara fara kwa waawa ma pa ray aŋga ŋga mahura na, Gazlavay a da pa ŋga mecəhe, asaya, ndaw masa ma nada ray aŋga na, Gazlavay a da pa ŋga mahura.» ");
INSERT INTO mif_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu ta’, aa guzlar a ndaw ma zəla ŋga zəmey ɗaf heyey, a ləvar: «Da ka key gwagway na, ka da zəltərwa jam akah hay ba. Asaya, ka da zəltərwa məlmakw hay ba, ka da zəltərwa səkway akah hay ba, kwa meseembew akah hay masa-zleley hay ka da zəltərwa ba. Ka da zəltərwa ba maja ata may, a da zəlmaka kəne. A da pəlmakawa cek masa kah ma vəldatara la. ");
INSERT INTO mif_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ama da ka key gwagway na, zəlwa masa-viya hay, ndəhay masa maahəlɓatakaya hay, ndəhay jegwer hay, leŋ wulaf hay. ");
INSERT INTO mif_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Da ka zəlwa ndəhay anda keɗe hay ŋga zəmey ɗaf na, maaya ŋga Gazlavay a sawa la a ray akah maja ndəhay a na, a gwamara ŋga vəhdamakawa cek aha ba. Ama Bay Gazlavay a da vəhdakawa ta pas masa ndəhay masa maaya fa mey ŋga Gazlavay, ma da sləkɗamawa daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Masa ndaw pal da wuzlah ndəhay ma zəmam ɗaf ta ata Yesu heyey ma cənda mey a la na, ta’, a ləvar a Yesu: «Meesəmey daha ŋgada ndaw ma da zəmey ɗaf ŋga gwagway daa bay ŋga Gazlavay da vaɗ.» ");
INSERT INTO mif_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ta’, Yesu a mbəɗdara ta mey-meŋgey, a ləvar: «Ndaw daha a key gwagway, ta’, a zəlwa ndəhay ga. ");
INSERT INTO mif_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pas təɗe ŋga zəmey cek na, a slərey madərlam aŋga fa ndəhay a ŋga ləvtar: “Samawa, maja cek tabiya maɗiykaya cay!” ");
INSERT INTO mif_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ama ata tabiya a kam ambahw pal pal. Ndaw ŋgeeme a ləvar a madərlam a: “Ambahw, mbəkdaya maja ya ta həɗkey ley la, ya daw ya da nəkərwa.” ");
INSERT INTO mif_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ndaw laŋgar a ləvar: “Ambahw, mbəkdaya maja ya ta həɗkawa sla hay kuraw la ŋga key sləra, ya daw la ya jadatərwa!” ");
INSERT INTO mif_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mekele a ləvar saya: “Ya gwa ya daw ba maja ya ta kwakwa da ver.” ");
INSERT INTO mif_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Madərlam a, a vəhey a cakay bay aŋga, a kadara mey masa ndəhay a ma ləvmar keɗe. Bay ŋga way a, mevel a car, a ləvar a madərlam aŋga: “Daw fiyaw aa slam masa ndəhay da hwaɗ a daha ta aa walaŋ-way hay. Ŋgəlwa masa-viya hay, ndəhay masa maahəlɓatakaya hay, masa wulaf hay, leŋ ndəhay jegwer hay.” ");
INSERT INTO mif_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Fa dəɓa ha nekəɗey, madərlam a, a vəhwa, a ləvar: “Bay aɗaw, ya ta zəlwa ndəhay la anda kah ma ləvey, ama slam daa way a daha cəŋga.” ");
INSERT INTO mif_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ta’, bay a, a ləvar a madərlam a: “Daw a mey-cəveɗ daa zlərɗay-aŋgwa hay, təktərwa ɗay a ndəhay ŋga samawa amba way aɗaw a rəhey. ");
INSERT INTO mif_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya fa ləvkwar, kwa ndaw pal dasi ndəhay masa yah ma zəltərwa ŋgeeme heyey, fa da zəmey ɗaf ŋga gwagway aɗaw keɗe daa saba səlak!”» ");
INSERT INTO mif_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Fa dəɓa ha, Yesu fa diyam ta ndəhay ga daa cəveɗ. Yesu pəla! a mbəɗwa dey ŋgada fa ata, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Da ndaw a wuɗey ŋga key gula aɗaw na, si a wuɗya a fəna papaha ta mamaha, ŋgwas aŋga ta bəz aŋga hay, məlmaha hay ta dam-mamaha hay, kwa heter aŋga. Da daa ba na, a gwa ŋga key gula aɗaw ba. ");
INSERT INTO mif_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kwa waawa ma ɓəsa banay ma da sawa a ray a maja aŋga ma səpya daa ba na, fa da gwa ŋga key gula aɗaw daa ba. ");
INSERT INTO mif_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Da ndaw da wuzlah akwar a wuɗey a ləmey way mahura, teeseɗ na, si a wulkey la ɗagay, way a, a key dala we. Fa dəɓa ha, a nəka da dala aŋga a wusa ŋga kara sləra aŋga ha tabiya la kwa. ");
INSERT INTO mif_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Da dala a wusa ba, ama da a zlar ma pa salay a cəŋga na, a gwa ŋga ndəvda sləra ŋga way a daa ba. Ŋgene, ndəhay tabiya masa ma hətmar way a, a daa saŋgərfamar, ");
INSERT INTO mif_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","a ləvam: “Ndaw keɗe a zlar meləmey way, ama a gwa ŋga ndəvda ba!” ");
INSERT INTO mif_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Yaw, da bay a wuɗey ŋga key vəram ta bay mekele, si a wulkey da ray ndəhay aŋga hay gabal kuraw ɗagay. A wulkey da a gwa ma kəɗmata ndəhay ŋga bay laŋgar ma sawa ta ndəhay aŋga hay gabal kwakwar cew ŋgene la kwa. ");
INSERT INTO mif_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Da a wulkey fa da gwamara daa ba na, a slərey maslaŋ aŋga hay fa bay laŋgar heyey amba a njam ta zazay, daa masa bay a, a lawa dəreŋ ɗagay.» ");
INSERT INTO mif_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu a wuzdatara: «Anda keɗe, da kwa waawa da wuzlah akwar ta mbəkdərwa zleley aŋga leŋ ndəhay aŋga hay daa ba na, a gwa ŋga key gula aɗaw ba.» ");
INSERT INTO mif_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesu a ləvtar: «Manda na, ara cek maaya. Ama da manda ha a cərey saba na, ya da kadakwa amba a cərey saya na, kwara? ");
INSERT INTO mif_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Manda ha aŋga maaya saba. Kwa ŋga kwiyey aa ley, kwa ŋga kwiyey anda gəraŋ, maaya saba. A da həlmara, a kwiydamara aa papalah saw. Da ndaw aŋga ta sləmay na, ŋga cənda mey a maaya maaya.» ");
INSERT INTO mif_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ta pas laŋgar daha, ndəhay ma cakala budaw ta ndəhay ma zləɓa *kwakwas ŋga Mawiz, a ŋgəcham tabiya fa Yesu amba a jəkfamar sləmay. ");
INSERT INTO mif_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","*Fariza hay ta ndəhay maa sərkada kwakwas ŋga Mawiz aa ŋguram mey da wuzlah ata, a ləvam: «Ndaw keɗe a təɓta ndəhay ma zləɓa kwakwas ŋga Mawiz, asaya, a zəmam ɗaf bama na, kwara?» ");
INSERT INTO mif_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Anda keɗe, Yesu ta’, aa guzltar ta mey-meŋgey, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Da ndaw da wuzlah akwar, aŋga ta təɓaŋ hay temere, da pal taa zəɗey sem na, ndaw aha, a mbəkdata təɓaŋ hay kwakwar zlam-letek a ray a zlam-letek da wuzlah-ley, a daw a səpərwa pal meezəɗey a, haa aŋga ma hətərwa daa ba daw? ");
INSERT INTO mif_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Masa aŋga ma hətərwa la na, aa səmey ga. A cəpərwa təɓaŋ aŋga ha fa pepesl , ");
INSERT INTO mif_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","a sawa a way. Masa aŋga ma wuswa la na, a zəltərwa jam aŋga hay ta meseembew aŋga hay, a ləvtar: “Samawa, sasəmkwa bama maja təɓaŋ aɗaw taa zəɗey la, ya ta hətərwa cay.” ");
INSERT INTO mif_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","«Ya fa ləvkwar aŋga letek kəne, da gazlavay da vaɗ na, meesəmey daha da ray ndaw pal ta mebərey ma mbəɗda menjey aŋga. Meesəmey a, a fəna meesəmey da ray ndəhay kwakwar zlam-letek a ray a zlam-letek masa menjey ata maaya, ma wuɗam ŋga mbəɗey menjey ata ba.» ");
INSERT INTO mif_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu aa guzltar ta mey-meŋgey saya, a ləvtar: «Yaw, dala ŋga ŋgwas daha sisey sisey kuraw, ama pal zazaɗ! aa zəɗey. Ta’, a gəɗey awaw aa petərla, a faca way, a səpa ta dək-vaw kasl aa ma hətar dala ha. ");
INSERT INTO mif_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Masa aŋga ma hətar la na, a zəltərwa jam aŋga hay ta meseembew aŋga hay, a ləvtar: “Samawa, sasəmkwa bama maja dala aɗaw taa zəɗey la, ya ta hətar cay.” ");
INSERT INTO mif_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yaw, ya fa ləvkwar ara letek kəne da wuzlah maslaŋ hay ŋga Bay Gazlavay da vaɗ na, meesəmey daha maja ndaw pal ta mebərey ma mbəɗda menjey aŋga.» ");
INSERT INTO mif_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu aa guzltar ta mey-meŋgey saya, a ləvtar: «Ndaw daha, bəz aŋga hay cew. ");
INSERT INTO mif_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Masa matabəwa a ləvar a papaha: “Papay, wure keɗe, wunkandara cek akah hay masa ala ma da wamara fa dəɓa akah. Yaw, masa ŋgada yah na, vəldiwa.” Ta’, papa ata ha a wunkatara. ");
INSERT INTO mif_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Fa dəɓa ha ɗar nekəɗey na, bəzey matabəwa ha, ta’, a həɗkadata cek hay maala ŋga aŋga tabiya. A daw ta dala ha aa hwayak dəreŋ. Daa hwayak a ŋgene, a zlar ŋga key cek hay malamba, maja ŋgene, aa kwacada dala aŋga heyey tabiya. ");
INSERT INTO mif_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Masa aŋga ma ndəvda dala aŋga sem tabiya na, may mahura a key daa hwayak a, a hətey cek ŋga zəmey saba. ");
INSERT INTO mif_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ta’, a daw a key sləra da way ndaw feteɗe daha. Ndaw aha a slərda a ley ŋga jəɗey vetem hay amba a vəltar cek mezəmey. ");
INSERT INTO mif_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Bəzey a, a wuɗey ŋga zəmey babəza ŋga wudez masa vetem hay ma zəmamara, ama ndaw ma vəlar cəveɗ daa ba. ");
INSERT INTO mif_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","A zlar mewulkey da ray cek masa aa ma ka, a ləvey: “Ndəhay ma ka sləra ŋga papay fa zəmam cek, fa rəham, fa mbəkdamara siya, ama yah na, may fa kəɗya feɗe! ");
INSERT INTO mif_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ŋgama ya mbəkda hwayak keɗe, ya daw fa papay, ya ləvar: Papay, ya ta key mebərey la fa mey ŋga Gazlavay, ta fa mey akah. ");
INSERT INTO mif_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Wure keɗe, ya wusa amba ka zəlya bəzey akah saba. Nəkya anda ndaw ma ka sləra akah gway.” ");
INSERT INTO mif_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ta’, a sləkɗawa, a sawa fa papaha. «Ama masa a lawa dəreŋ ta way ŋga papaha ɗagay na, papaha a hətar, a kar dey-ceceh. A hway a da cadərwa ray, slaslap! a slasləpa. ");
INSERT INTO mif_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ta’, bəz aŋga ha a ləvar: “Papay, ya ta key mebərey la fa mey ŋga Gazlavay, ta fa mey akah. Wure keɗe, ya wusa amba ka zəlya bəzey akah saba.” ");
INSERT INTO mif_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ama, papaha a ləvtar a ma ka sləra aŋga hay: “Wusmawa vaw, lamawa zana maaya, kəzlamara fa vaw ŋga bəzey aɗaw keɗe. Lamawa daŋgwa ŋga bəz-mey-har, pamara a har. Lamawa tarak, ndəkwdamara a salay. ");
INSERT INTO mif_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ɗaɗamərwa bəz-sla maaɓəlkaya masa aləkwa ma rəfkwa ŋgene. Hərmara, kakwa gwagway, sasəmkwa, ");
INSERT INTO mif_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","maja bəzey aɗaw keɗe aŋga anda bəzey maməckaya, ama ta sləkɗawa sem, aŋga anda bəzey maazəɗkaya, ama yah ta hətar sem.” Ta’, ma ka sləra aŋga hay a kamara anda bay ata ma ləvtar. Anda keɗe, ndəhay a zlamar mekey gwagway ta meesəmey. ");
INSERT INTO mif_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Daa masa ata fa kamara gwagway a na, bəzey mahura a lawa da ley. Masa aŋga fa sawa da ley na, a cənda baazlam ta gaaŋgaŋ ŋga megərvey. ");
INSERT INTO mif_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ta’, a zəley ndaw ma ka sləra ŋga papaha pal, aa cəfɗa, a ləvar: “Mekey da way a, me?” ");
INSERT INTO mif_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ndaw ma ka sləra ha, a mbəɗdara, a ləvar: “Məlmakw ta sawa cay, papakw ta həra bəz-sla masa aləkwa ma rəfkwa heyey sem, maja məlmakw a ta vəhwa sem, aa daha zay.” ");
INSERT INTO mif_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Bəzey mahura heyey a key mevel, a gəmey ŋga mbəzey a way saba. Ama, papaha, ta’, a daw fa aŋga, a bərkwa ŋga mbəzey a way. ");
INSERT INTO mif_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ama bəzey a, a mbəɗdara a papaha, a ləvar: “Papay, jəkey sləmay: mevey weewe ya fa kaka sləra, ya fa təɓkawa mey akah mandaw mandaw, ama ka ta vəlya kwa bəz-ɗakw pal ŋga key gwagway ta mandala aɗaw hay daa ba. ");
INSERT INTO mif_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ama bəzey akah keɗe a vəhwa, ta ndəvdatərwa cek akah hay sem tabiya ŋga mesəpey ŋgwas-barlaw hay, ama ŋgada aŋga na, ka hərara bəz-sla masa aləkwa ma rəfkwa heyey jak!” ");
INSERT INTO mif_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Papaha a ləvar: “Bəz aɗaw, kah na, mandaw mandaw aləkwa cew e, cek tabiya masa yah ma wa na, ara ŋga akah. ");
INSERT INTO mif_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Si ya kakwa gwagway ta meesəmey, maja məlmakw keɗe, aŋga na, anda bəzey maməckaya, ama ta sləkɗawa sem, aŋga anda bəzey maazəɗkaya, ama yah ma hətar sem!”» ");
INSERT INTO mif_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ta pas laŋgar daha, Yesu a ŋgatar mey a gula aŋga hay, a ləvtar: «Ndaw daha aa ta zleley ga. Gula aŋga mahura ma jəɗra zleley a daha. Ndaw daha a sawa, a ləvar a ndaw masa-zleley a: “Gula akah faa kwacadakawa zleley akah la.” ");
INSERT INTO mif_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bay ŋga gula heyey ta’, a zələrwa, a ləvar: “Ya ta cəney mey maaya ba la da ray akah. Wuzdiwa sləra masa kah ma ka tabiya, maja wure keɗe ka fa da key gula aɗaw daa saba!” ");
INSERT INTO mif_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Gula aŋga kaa heyey a wulkey daa ray aŋga, a ləvey: “Ya da key kwara? Bay aɗaw a da badaya daa sləra aŋga. Gədaŋ aɗaw ŋga həvey daa ba. Ŋga rəkey na, hwaray a kaya la. ");
INSERT INTO mif_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aha! Wure keɗe ya səra cek masa yah ma da ka! Ŋgama ya kərzey jam hay. Anda keɗe, ta pas masa ta badaya sem daa sləra aŋga na, jam aɗaw hay a, a ŋgəlmaya a way ata hay.” ");
INSERT INTO mif_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Masa aa ma wulkey la anda keɗe na, ta’, a zəltərwa ndəhay masa ma lam dəvaz ŋga bay aŋga pal pal tabiya. A ləvar a ndaw ŋgeeme: “Dəvaz ŋga bay aɗaw da har kah na, we?” ");
INSERT INTO mif_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ndaw aha a mbəɗdara, a ləvar: “Mal gwajakwaɗ temere.” A ləvar: “Larawa ɗerewel ŋga dəvaz akah fiyaw, njey, wuzlala fa vəɗa kwakwar zlam.” ");
INSERT INTO mif_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ta’, aa cəfɗa ndaw laŋgar saya, a ləvar: “Dəvaz ŋga bay aɗaw da har akah na, we?” Ndaw aha a mbəɗdara, a ləvar: “Daw sak temere.” A ləvar a ndaw aha: “Larawa ɗerewel ŋga dəvaz akah fiyaw, wuzlala fa vəɗa kwakwar daaŋgafaɗ.” ");
INSERT INTO mif_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kwa gula ha a key cek ta cəveɗ e ba na, ndaw masa-zleley a, aa həmda maja a ka sləra aha ta dabaray. Fara fara, ndəhay da bəla keɗe a kam cek ta dabaray da wuzlah ata ma fəna ndəhay ŋga Bay Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu a ləvey saya: «Ya fa ləvkwar, zleley da bəla keɗe na, kərzadamara jam. Anda keɗe, da zleley a ta ndəvey sem na, ka da hətam slam menjey maaya ma ndəvey ba da vaɗ. ");
INSERT INTO mif_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ndaw masa ma key sləra maaya ta cek mecəhe na, a key sləra maaya ta cek mahura la may. Ndaw ma key sləra ta cəveɗ e ba ta cek mecəhe na, a key sləra ta cəveɗ e ba ta cek mahura la may. ");
INSERT INTO mif_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Da ray ŋgene, da ka kam sləra maaya ba ta zleley masa ma vəldamakwara a har akwar da bəla keɗe na, kaa wara zleley masa fara fara na, ma da vəldakwara na, wa? ");
INSERT INTO mif_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ama da wure keɗe ka kam cek hay maaya ba ta zleley masa ndaw ma vəldakwara da bəla keɗe na, fa dəɓa ha, Gazlavay a vəlkwar zleley la amba ka wamara daw? ");
INSERT INTO mif_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Ndaw ma gwa ŋga key sləra ŋgada bay hay cew daa ba, maja a da wuɗa bay laŋgar a fəna bay laŋgar, da daa ba, a da nar ray a bay laŋgar, a rəsa bay laŋgar. Ka gwamara ŋga səpmara Gazlavay leŋ zleley cewete daa slam a ba.» ");
INSERT INTO mif_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Masa *Fariza hay ma cəndamara mey a keɗe na, aa saŋgəram a ray Yesu maja a wuɗam dala kalah. ");
INSERT INTO mif_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ta’, Yesu a ləvtar: «Akwar fa kam cek maaya fa dey ŋga ndəhay, amba a ləvam akwar ndəhay maaya hay. Ama Gazlavay na, a səra mevel akwar. Cek masa ndəhay a nəkmara mahura fa mey ata na, ara cek ŋga tede fa mey ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yesu a ləvtar: «Kwakwas ŋga *Mawiz ta ndəhay ma təla mey ŋga Gazlavay fa wuzdamara mey ŋga Gazlavay haa kasl *Jaŋ-Baptis. Dəga daa ŋgene, ndəhay fa cəndamara *Mey-maaya-mawiya da ray *mewey ŋga Gazlavay da ray ndəhay. Kwa waawa fa key gədaŋ amba a mbəzey a wuzlah ndəhay masa Gazlavay ma da wey da ray ata fara fara. ");
INSERT INTO mif_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","«Slam da vaɗ ta slam da hwayak, aŋga ta gəra amba a ndəvey, ama cek mecəhe mawuzlalakaya daa mey ŋga kwakwas ŋga Mawiz keɗe ŋgaa vəsey na, aŋga ta gəra ma fəna saya. ");
INSERT INTO mif_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Yaw, kwa waawa ma ɓəla ŋgwas aŋga, a lawa mekele na, a key ŋgene, a ley vaw saw da palah. Asaya, kwa waawa ma la ŋgwas masa zel e ma ɓəla sem na, a key ŋgene, a ley vaw saw da palah may.» ");
INSERT INTO mif_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu aa guzltar ta mey-meŋgey saya, a ləvtar: «Ndaw daha, aŋga ta zleley ga, a pey zana fa vaw na, maaya masa ndaw ma gwa ŋga həɗka ba. Aa daa wiya mandaw mandaw, fa zəmey cek maaya. ");
INSERT INTO mif_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ndaw mekele daha, aŋga masa-viya, mezəley aŋga Lazar, mbəlek fa vaw njaɓa-njaɓa. Manakaya fa mey-mbew ŋga ndaw masa-zleley kaa heyey. ");
INSERT INTO mif_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aa fa wuɗey ŋga gəɗmey meepəsey ŋga ɗaf da hwayak daa slam mezəmey ɗaf ŋga ndaw masa-zleley heyey, ama ndaw ma vəlar daa ba. Asaya, gədey hay fa samawa, fa ndəfɗamara mbəlek fa vaw aŋga. ");
INSERT INTO mif_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Fa dəɓa ha nekəɗey, ndaw masa-viya heyey, pam! a məcey. Maslaŋ hay ŋga Gazlavay da vaɗ ta’, a samawa, leŋ! a lamara a vaɗ a cakay *Abəraham. Ndaw masa-zleley heyey, pam! a məcey may. Ndəhay ta’, a jəhmara. ");
INSERT INTO mif_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ndaw masa-zleley kaa fa sərey banay ga da wuzlah ndəhay maməctakaya. A da baŋgaɗa dey a vaɗ na, a hətar Abəraham manjakaya dəreŋ, Lazar manjakaya da cakay a. ");
INSERT INTO mif_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Da ray ŋgene, a wudey, a təlar mey, a ləvar: “Papay Abəraham, sərfaya dey-ceceh, slərdərwa Lazar amba a jəhwɓa bəz-mey-har aŋga aa yam na, a gəciwa fa neneh aɗaw, maja ya fa sərey banay kalah daa awaw keɗe.” ");
INSERT INTO mif_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Ama Abəraham a mbəɗdara, a ləvar: “Bəz aɗaw, wulkada, daa masa kah da bəla, ka ta hətey zleley la ga, daa ŋgene, Lazar fa sərey banay. Wure keɗe, feɗe, ala fa dəkmar mevel, ama kah, ka fa sərey banay may. ");
INSERT INTO mif_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Asaya, daa walaŋ ala ta akwar na, vəgeɗ seleleŋ daha, cəveɗ ŋga daw daa ba. Da ray ŋgene, da ndəhay feɗe a wuɗam ŋga diyam feteɗe na, a gwamara ŋga diyam ba. Asaya, da ndəhay feteɗe a wuɗam ŋga samawa feɗe na, a gwamara ba may.” ");
INSERT INTO mif_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Ndaw masa-zleley kaa heyey a ləvar a Abəraham: “Na, ya kaka ambahw papay Abəraham, slərda Lazar a way papay. ");
INSERT INTO mif_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Məlma aɗaw hay zlam daha, ŋga daw ŋga wuztar, amba a samawa aa slam ŋga banay keɗe saba.” ");
INSERT INTO mif_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abəraham a mbəɗdara, a ləvar: “Məlmakw hay na, si a jəkam sləmay fa mey ŋga *Mawiz leŋ fa mey ŋga ndəhay ma təla mey ŋga Gazlavay.” ");
INSERT INTO mif_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«Ndaw aha a ləvar: “Kəne ba, papay Abəraham. Maaya na, si ndaw ma sləkɗey daa meməcey, a daw fa ata, ŋgene, a mbəɗdamara menjey ata la.” ");
INSERT INTO mif_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Ama Abəraham a ləvar: “Da a jəkam sləmay fa mey ŋga Mawiz ba, asaya, da a cəndamara mey ŋga ndəhay ma təla mey ŋga Gazlavay zleezle ba na, ŋgene kwa mey ŋga ndaw ma sləkɗey daa meməcey na, fa da təɓmara daa ba may.”» ");
INSERT INTO mif_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu a ləvtar a gula aŋga hay: «Fara fara ndəhay ma həldamata ndəhay mandaw mandaw ŋga key mebərey na, daha. Ama banay a sawa la a ray ndaw masa ma həldata ndəhay ŋga key mebərey. ");
INSERT INTO mif_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ŋgada aŋga na, ŋgama ata ma jəwmar aŋgwa mahura a ɗay, a kəzlamara aa bəlay, da ray masa aŋga ma da həlda ndaw pal da wuzlah ndəhay ma təɓa mey aɗaw hay keɗe ŋga key mebərey. ");
INSERT INTO mif_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wam vaw maaya maaya fa ray akwar! «Da məlmakw ta key mebərey la na, kəta. Da ta mbəɗda leŋgesl aŋga ha la na, mbəkdara mebərey aŋga ha. ");
INSERT INTO mif_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kwa da a kaka mebərey dey maasala fa pas pal na, ama da fa vəhwa fa kah dey maasala ha, a ləvka: “Ambahw, ara mebərey aɗaw, ambahw, ara mebərey aɗaw,” na, mbəkdara mebərey aŋga ha.» ");
INSERT INTO mif_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ndəhay meslərey ŋga Yesu a ləvmar a Bay Mahura: «Vəlndar gədaŋ saya amba ya təɓmara mey akah ma fəna ma fəna.» ");
INSERT INTO mif_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bay Mahura a ləvtar: «Da akwar fa təɓmara mey ŋga Gazlavay kwa kuset kəɗey həma babəza ŋga bazlawar na, ŋgene ka gwamara ŋga ləvmar a wudez mahura keɗe, “Məɗey la feɗe, daw ta kəzley aa bəlay” na, a cənkwar mey la.» ");
INSERT INTO mif_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu a ləvey: «Da ndaw da wuzlah akwar gula aŋga fa həvar da ley, da daa ba, fa səkərar ɗahway, fa dəɓa ha, a sawa da ley na, bay aŋga a ləvar la ŋga sawa fiyaw fiyaw, amba a zəmey cek daw? Fa da ləvar kəne daa ba! ");
INSERT INTO mif_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sasəkar jak, a da ləvar: “Mbəɗdata zana akah hay amba ka ɗiyawa cek aɗaw mezəmey, həlyawa cek mezəmey ta cek mesey. Fa dəɓa ha, ka zəma ŋga kah may, ka sa ŋga kah may.” ");
INSERT INTO mif_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Da gula ha a kara cek anda bay aŋga ha ma ləvar na, a kar suse la daw? ");
INSERT INTO mif_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Akwar kwa kəne, da ka kamara sləra tabiya masa Gazlavay ma ləvkwar na, si ka ləvam: “Ala na, gula hay ŋga tede gway, ya kam sləra masa Gazlavay ma ləvndar ŋga key gway.”» ");
INSERT INTO mif_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu fa daw a *Jeruzelem, a daw taa kwakway ŋga hwayak ŋga *Samari ta hwayak ŋga *Galile. ");
INSERT INTO mif_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","A wusey gweegwe ta slala daha na, maasəkula hay kuraw a samawa ŋgada fa vəɗa. A lacam dəreŋ ta aŋga. ");
INSERT INTO mif_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","A wudam, a ləvam: «Yesu, Bay Mahura, sərfandar dey-ceceh!» ");
INSERT INTO mif_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Masa Yesu ma hətatar na, a ləvtar: «Diyam, wuzdamatara vaw akwar a ndəhay ma ka kwakwas ŋga Gazlavay.» Masa ata fa diyam, a nəkmara na, vaw ata ta səɗey sem. ");
INSERT INTO mif_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ndaw pal da wuzlah ata daha aŋga ma hətar vaw aŋga ta səɗey sem na, a mbəɗwa dey, a vəhwa fa Yesu, a həlma Gazlavay ta gədaŋ. ");
INSERT INTO mif_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A wuswa, a regedey fa mey ŋga Yesu, a kar suse. Ndaw aha ŋgene ara ndaw Samari. ");
INSERT INTO mif_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu ta’, aa cəfɗata ndəhay da cakay aŋga, a ləvtar: «Maasəkula hay ma səɗam na, kuraw ba diya? Kaa si ndaw pal ma vəhwa feɗe, siya hay na, ata dama? ");
INSERT INTO mif_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ndaw ma wulkawa ŋga vəhwa amba a həlma Gazlavay daa ba, si ndaw-məlak keɗe gway daw?» ");
INSERT INTO mif_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Fa dəɓa ha, Yesu a ləvar a ndaw aha: «Sləkɗey, daw, ka ta ləhey cay maja kah ma paya ŋga ndaw akah fara fara.» ");
INSERT INTO mif_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fa dəɓa ha, *Fariza hay aa cəfɗamara Yesu, a ləvmar: «Gazlavay a da wuzdərwa aŋga bay na, ta vara?» Yesu a mbəɗdatara, a ləvtar: «Gazlavay ma da wuzdərwa aŋga bay na, ara cek masa ndaw ma gwa ŋga hətar ta dey ba. ");
INSERT INTO mif_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ndaw a gwa a ləvey “Ehe, a keɗe,” da daa ba “A katay,” na, a gwa a ləvey kəne ba. Sərmara, mewey ŋga Bay Gazlavay aa da wuzlah akwar wure keɗe. ");
INSERT INTO mif_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ta’, a ləvtar a gula aŋga hay: «Pas a, a sawa la masa akwar ma da wuɗam ŋga hətmaya yah, *Bəz ŋga Ndaw, fa dey kwa ɗar pal, ama ka hətmaya daa ba. ");
INSERT INTO mif_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","A da ləvmakwar: “Aŋga feɗe,” da daa ba “Aŋga fataɗay,” ama ka da diyam ba. Ka da hwam aa slam aha ba. ");
INSERT INTO mif_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Anda ndəhay ma hətmar var ma zəmey ma waɗa slam da vaɗ ta slam da hwayak tabiya na, yah, Bəz ŋga Ndaw ya da vəhwa na, kəne. ");
INSERT INTO mif_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama teeseɗ na, si ya sərey banay la ga ɗagay. Asaya, ndəhay da bəla wure keɗe a rəsmaya la. ");
INSERT INTO mif_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ta pas masa yah, Bəz ŋga Ndaw ma da vəhwa na, a da key anda cek ma key daa masa Nəwe aŋga da bəla. ");
INSERT INTO mif_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Daa ŋgene, ndəhay fa zəmam cek, fa sam cek, fa lam ŋgusay, fa vəldamata dam ata hay a way zel, haa kasl pas masa Nəwe ma mbəzey la aa kwambiwal mahura. Fa dəɓa ha, var a pawa ga, a rəhda slam da bəla, aa zəɗdata ndəhay cəpa. ");
INSERT INTO mif_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Asaya, pas a, a da key anda cek ma key daa masa *Lut aŋga da bəla. Daa ŋgene, ndəhay fa zəmam cek, fa sam cek, fa həɗkam cek, fa həɗkadamara cek ata hay, fa sləkam, fa ləmam way. ");
INSERT INTO mif_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ama daa masa Lut ma bawa daa berney ŋga *Sadawm la na, awaw təs! təs! a kəzlwa da gazlavay da vaɗ ta cek ma təɓey awaw, a paslata tabiya. ");
INSERT INTO mif_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","A da key kəne ta pas masa yah, Bəz ŋga Ndaw, ma da wuzwa vaw. ");
INSERT INTO mif_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Ta pas a ŋgene, ndaw masa manjakaya daa ambaw, masa cek aŋga hay a lamawa ta da way na, a da mbəzey ŋga latərwa ba. Da ndaw aŋga da ley na, a da vəhwa a way ba. ");
INSERT INTO mif_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sərfadamara cek ma key ta ŋgwas ŋga Lut! ");
INSERT INTO mif_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kwa waawa ma wuɗey ŋga ləhda heter aŋga na, a key ŋgene, aa zəɗda. Kwa waawa maa zəɗda heter aŋga na, a key ŋgene, a ɓada. ");
INSERT INTO mif_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ya fa ləvkwar, dasi tavaɗ ŋgene, da ndəhay cew manatakaya daa slam a na, a da ŋgəlam pal, a da mbəkdamara laŋgar. ");
INSERT INTO mif_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Da ŋgusay cew fa kəram fa lavar pal na, a da ŋgəlam pal, a da mbəkdamara laŋgar.  ");
INSERT INTO mif_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Da ndəhay cew fa həvam da ley na, a da ŋgəlam pal, a da mbəkdamara laŋgar.» ");
INSERT INTO mif_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Gula aŋga hay aa cəfɗamara, a ləvmar: «A da key dama, Bay Mahura?» A mbəɗdatara, a ləvtar: «Daa slam masa cek maməckaya daha na, kwakucah hay makustakaya feteɗe.» ");
INSERT INTO mif_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Fa dəɓa ha, Yesu a ŋgatar mey a gula aŋga hay amba a wuzdatara si a dəram daŋgay mandaw mandaw, a da gəram ba səlak. ");
INSERT INTO mif_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A ləvtar: «Ndaw ma ka sariya daa berney daha, a zlurey ta Gazlavay ba, a cəney mey ŋga ndaw ba. ");
INSERT INTO mif_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ŋgwas-vagay daa berney a daha, fa daw fa vəɗa mandaw mandaw, a ləvar: “Wunkandar ta masa-gəra aɗaw.” ");
INSERT INTO mif_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ŋgwas a fa daw mandaw mandaw, ama ndaw aha a gəmey ŋga wunkata ba menjey ga. Fa dəɓa ha, ndaw aha, a wulkey daa mevel aŋga, a ləvey: “Kwa ya fa zlurey ta Gazlavay daa ba, asaya, kwa ya cəney mey ŋga ndaw ba na, ");
INSERT INTO mif_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ama maja ŋgwas-vagay keɗe, fa gərdaya, ŋgama ya kara sariya aŋga, ba na, a da həɓya ray mandaw mandaw.”» ");
INSERT INTO mif_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Fa dəɓa ha, Bay Mahura aa guzley saya, a ləvey: «Wulkam da ray mey ŋga ndaw ma ka sariya maaya ba maa guzley keɗe. ");
INSERT INTO mif_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Da ndaw maaya ba keɗe ta jəna ŋgwas keɗe la na, kaa wara Gazlavay na, a jənta ndəhay aŋga hay mawalatakaya masa fa dərmar daŋgay taa vaɗ, taa pas daa ba daw? A zəney vaw ŋga jənta la daw? ");
INSERT INTO mif_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yaw, ya fa ləvkwar, a jənta la fiyaw fiyaw. Ama daa masa yah, *Bəz ŋga Ndaw, fa vəhwa a bəla na, ya hətfey ndəhay ma təɓmara mey aɗaw da bəla la daw?» ");
INSERT INTO mif_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ndəhay siya fa wulkam, ata na, maaya fa mey ŋga Gazlavay. A nəkmata ndəhay mekele anda ndəhay ta mebərey. Da ray ŋgene, Yesu aa guzley mey-meŋgey da ray ata, ");
INSERT INTO mif_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","a ləvey: «Ndəhay cew daha, a diyam ŋga dərmawa daŋgay daa *Way-mekey-kwakwas ŋga Gazlavay. Ndaw pal, ara ndaw Fariza, ndaw laŋgar, ara *ndaw ma cakala budaw. ");
INSERT INTO mif_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Masa ata daa Way-mekey-kwakwas ŋga Gazlavay a na, ndaw Fariza kaa heyey deŋ! a lecey, a dərey daŋgay da hwaɗ da hwaɗ, a ləvey: “Waa Bay Gazlavay, ya fa kaka suse, maja yah anda ndəhay mekele ba. Ata na, mayal hay, ata ndəhay ma kam cek maaya ba hay mekele mekele, ata ndəhay ma lam vaw saw da palah. Asaya, ya fa kaka suse, maja yah anda ndaw ma cakala budaw keɗe ba. ");
INSERT INTO mif_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Fa luma pal na, ya fa key *daliyam dey cew. Daa cek tabiya masa yah ma hətey na, ya fa wunka slam kuraw, ya fa la slam pal, ya fa vəldakawa.” ");
INSERT INTO mif_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ama ndaw ma cakala budaw keɗe a lecey dəreŋ, a wuɗey ŋga baŋgaɗa dey a vaɗ ba, ta’, a kəɗa rav maja mebərey aŋga, a ləvey: “Bay Gazlavay, sərfaya dey-ceceh. Yah ndaw ta mebərey!”» ");
INSERT INTO mif_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ta’, Yesu aa guzltar saya, a ləvey: «Ya fa ləvkwar, ndaw ma cakala budaw a, a daw a way na, Gazlavay ta pa sem ŋga ndaw maaya fa mey aŋga. Ama ndaw Fariza heyey na, Gazlavay ta pa ŋga ndaw maaya fa mey aŋga daa ba. Sərmara, kwa waawa ma gəlda ray aŋga na, Gazlavay a da pa ŋga mecəhe, ama ndaw masa ma nada ray aŋga na, Gazlavay a da pa ŋga mahura.» ");
INSERT INTO mif_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ndəhay a handamata bəzey ata hay fa Yesu, kwa masa da dəɓa hay amba a patar har a ray, a pəstar mey. Masa gula aŋga hay ma hətmatar na, a kamatar mey a ndəhay a. ");
INSERT INTO mif_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ama Yesu a ləvtar a ndəhay masa ta bəza hay a, ŋga ŋgəchadamatərwa. Ta’, a ləvtar a gula aŋga hay: «Mbəkdamatərwa bəza hay ŋga samawa fa yah! Ka da təkmata ba, maja Gazlavay fa wey da ray ndəhay masa anda bəza hay. ");
INSERT INTO mif_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ya fa ləvkwar fara fara, si ka təɓa Bay Gazlavay ŋga wey da ray akah anda bəzey mecəhe ma təɓa, da daa ba na, ka fa da mbəzey a wuzlah ndəhay masa Gazlavay ma wey da ray ata na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ndaw mahura ŋga *Jəwif hay daha, aa cəfɗa Yesu, a ləvar: «Bay aɗaw, ndaw masa maaya, ya da key amba ya hətey heter mendəvey ba na, me?» ");
INSERT INTO mif_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu a mbəɗdara, a ləvar: «Ka zəlya ndaw maaya na, maja me? Ndaw maaya na, Gazlavay pal taava aŋga. ");
INSERT INTO mif_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yaw, ka sərta mewey hay ŋga Gazlavay, ba diya? Ara mey hay masa ma ləvam: “Ka da ley vaw saw da palah ba, ka da kəɗey ndaw vagay ba, ka da leley ba, ka mbərzley a ray ndaw ba, natar ray ŋgada ata papakw ta mamakw.”» ");
INSERT INTO mif_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ndaw aha, a mbəɗdara a Yesu, a ləvar: «Dəga yah daa zariya aɗaw na, ya ta zləɓta mewey hay a ŋgene daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Masa Yesu ma cənda mey aŋga la na, ta’, a ləvar: «Cek pal ma mbəkaka daha ŋga key saya. Həɗkadata cek akah hay tabiya, wunkatara dala ha a masa-viya hay. Da ka ta ka la anda keɗe na, ka da hətey zleley fa Gazlavay da vaɗ. Masa kah ma vəldatara dala ha cay a masa-viya hay na, sawa, səpya.» ");
INSERT INTO mif_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Masa ndaw aha ma cənda mey ŋga Yesu a la na, aŋga ta meesəmey daa ba, maja zleley aŋga ga kalah. ");
INSERT INTO mif_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Masa Yesu ma hətar ndaw aha aŋga ta meesəmey daa ba na, ta’, aa guzley, a ləvey: «Aŋga ta banay ga ŋgada ndəhay masa-zleley amba a təɓmara Gazlavay ŋga wey da ray ata. ");
INSERT INTO mif_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ahaw, aŋga ta banay ŋgada slagwama ŋga mbəzey taa vəgeɗ ŋga baatal. Ama aŋga ta banay ga ma fəna saya ŋgada ndaw masa-zleley ŋga təɓa Bay Gazlavay ŋga wey da ray a.» ");
INSERT INTO mif_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ndəhay ma cəndamara mey a na, a ləvam: «Da anda keɗe na, ma da ləhey daa mebərey na, wa?» ");
INSERT INTO mif_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu a mbəɗdatara, a ləvtar: «Cek masa ta banay fa ndəhay na, aŋga ta banay fa Gazlavay ba.» ");
INSERT INTO mif_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","*Piyer a ləvar: «Ehe wure keɗe, ala ta mbəkdamatərwa cek ala hay sem, amba ya səpmaka.» ");
INSERT INTO mif_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu aa guzltar, a ləvtar: «Ya fa ləvkwar fara fara, da ndaw a mbəkdərwa way aŋga ta ndəhay da way aŋga cəpa, anda meləvey ŋgwas aŋga, məlmaha hay, papaha ta mamaha, leŋ bəz aŋga hay, amba Bay Gazlavay a wey da ray a na, ");
INSERT INTO mif_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","daa masa aŋga da bəla keɗe, a hətey cek hay la ga ma fəna. Asaya, fa dəɓa ŋga mendəvey ŋga bəla na, a hətey heter mendəvey ba la.» ");
INSERT INTO mif_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Fa dəɓa ha, Yesu a ŋgəlta gula aŋga hay kuraw a ray a cew, a ləvtar: «Jəkam sləmay, ehe, wure keɗe aləkwa fa nakwa a *Jeruzelem. Cek hay tabiya masa ndəhay ma təla mey ŋga Gazlavay zleezle ma wuzlalamara da ray aɗaw, yah, *Bəz ŋga Ndaw na, a da key. ");
INSERT INTO mif_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Anda meləvey, a da vəldamaya a har ndəhay masa *Jəwif hay ba, a daa saŋgəram a ray aɗaw, a da cəɗmaya, a da təfmaya meesleɓ aa dey, ");
INSERT INTO mif_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","a da sləɗmaya ta laway. Fa dəɓa ha, a da kəɗmaya vagay. Ŋga ɗar maakar a, ya sləkɗawa la daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ama gula aŋga hay, kwa ta cəndamara mey a daa ba, maja mey a maɓadakaya fa ata. Anda keɗe, a sərmara cek masa Yesu ma wuɗey ŋga ləvey ba. ");
INSERT INTO mif_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu a wusey gweegwe ta Jerikwaw. Feteɗe, ndaw-wulaf daha manjakaya da mey-cəveɗ fa rəkey. ");
INSERT INTO mif_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Masa aa ma cənda ndəhay ga fa yam mey, fa diyam taa cəveɗ e na, ta’, aa cəfɗata ndəhay a, a ləvtar: «Mekey me?» ");
INSERT INTO mif_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","A ləvmar: «Yesu ndaw *Nezeret, fa sawa ta keɗe.» ");
INSERT INTO mif_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aa ma cənda la anda keɗe na, a zlar mewudey, a ləvey: «Yesu, Bəzey ŋga *Davit, ambahw sərfaya dey-ceceh!» ");
INSERT INTO mif_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ndəhay ma diyam fa mey, a kamar mey, a ləvmar ŋga njey teete. Ama ndaw-wulaf a, a wudey ta gədaŋ cəŋga, a ləvey: «Bəzey ŋga Davit, ambahw sərfaya dey-ceceh!» ");
INSERT INTO mif_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu ta’, a lecey, a ləvtar a ndəhay da cakay aŋga ŋga ŋgəlmərwa ndaw-wulaf a. Masa wulaf a, ma wusey a cakay a na, Yesu, ta’, aa cəfɗa, a ləvar: ");
INSERT INTO mif_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ka wuɗey ya kaka na, me?» Wulaf a, a mbəɗdara, a ləvar: «Bay mahura, ya wuɗey ka wuryawa dey aɗaw amba ya hətar dey cəŋga.» ");
INSERT INTO mif_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu a ləvar: «Dey akah ŋga wurey. Ka ta mbəley cay maja kah ma paya ŋga ndaw akah fara fara.» ");
INSERT INTO mif_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wure wure ŋgene, dey aŋga ta’, a wurey, a hətar dey dəɓa. Ta’, a daw asi Yesu, a həlma Gazlavay. Masa ndəhay tabiya ma hətmar cek a na, a həlmamara Gazlavay may. ");
INSERT INTO mif_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Fa dəɓa ha, Yesu a wusey a slala Jerikwaw. A daw ta da slala ha. ");
INSERT INTO mif_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Feteɗe ndaw daha mezəley Zase. Aŋga bay ŋga ndəhay ma cakala budaw, aŋga ndaw ta zleley ga. ");
INSERT INTO mif_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Fa səpey cəveɗ amba a hətar Yesu, ama a gwa ŋga hətar ba, maja aŋga medekwele, ndəhay ga fa təhmar dey. ");
INSERT INTO mif_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ta’, a hway fa mey, a daw a təpey a ray bazlawar da mey-cəveɗ masa Yesu ma da daw ta hwaɗ a amba a hətar Yesu a. ");
INSERT INTO mif_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Masa Yesu ma wusey la aa slam aha na, a baŋgaɗa dey, a ləvar: «Zase, wuswa vaw, pawa salay, tasana ya da ney da way akah.» ");
INSERT INTO mif_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Maja ŋgene, Zase a wuswa vaw, a pawa salay, a təɓa Yesu ta meesəmey. ");
INSERT INTO mif_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ama ndəhay ma hətmar na, aa ŋguram mey, a ləvam: «Haya! Ndaw aha keɗe a da daw ŋga ney a way ndaw ta mebərey na, kwara!» ");
INSERT INTO mif_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zase ta’, a lecey fa mey ŋga Bay Mahura, a ləvar: «Nəka, Bay Mahura, wure keɗe ya da wunka cek aɗaw hay slam cew, ya da vəlda slam pal a masa-viya hay. Ŋgada ndəhay masa yah ma təktar ɗay ŋga pəley dala ŋga budaw ma fəna na, ya da vəhdatara dala ha həma həma ŋgene dey məfaɗ.» ");
INSERT INTO mif_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu a ləvar: «Tasana Gazlavay ta ləhdata ndəhay da way keɗe cay daa mebərey, maja kah Zase, kah ndaw ma pa Gazlavay ŋga ndaw akah fara fara anda papaŋ ŋga papa aləkwa *Abəraham zleezle may. ");
INSERT INTO mif_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Fara fara yah, *Bəz ŋga Ndaw, ya sawa na, ŋga səpey ndəhay maazəɗtakaya ta ŋga ləhdata.» ");
INSERT INTO mif_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ndəhay ga fa jəkfamar sləmay fa Yesu, a wulkam Gazlavay a da wuzdərwa aŋga bay wure wure ŋgene, maja aŋga gweegwe ta *Jeruzelem. Da ray ŋgene, Yesu aa guzltar ta mey-meŋgey saya, ");
INSERT INTO mif_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","a ləvey: «Ndaw daha, ata ŋga way ata ta bay. Aa fa da daw aa hwayak dəreŋ, amba a pamərwa aa bay. Fa dəɓa ha, a vəhwa aa hwayak aŋga. ");
INSERT INTO mif_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Masa aa fa da daw na, ta’, a zəltərwa madərlam aŋga hay kuraw, a vəltar dala gabal temere temere. Ta’, a ləvtar: “Mbəɗam har ta dala keɗe, kasl pas masa yah ma da vəhwa.” Fa dəɓa ha, ta’, a daw. ");
INSERT INTO mif_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«Ama ndəhay daa hwayak aŋga, a wuɗmara ba. Da ray ŋgene, a sləram ndəhay fa dəɓa aŋga, a ləvam: “Ya wuɗam ndaw keɗe ŋga key bay ala ba.” ");
INSERT INTO mif_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Ta ŋgene he cəpa, ta pamərwa sem aa bay cəŋga. Ndaw a, ta’ a vəhwa aa hwayak aŋga. Masa aŋga ma vəhwa cay na, ta’, a zəltərwa madərlam aŋga hay masa aa ma vəltar dala heyey amba a səra dala masa ata ma hətam a ray a. ");
INSERT INTO mif_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«Madərlam ŋgeeme, a sawa fa mey aŋga, a ləvar: “Bay aɗaw, ya ta hətwa gabal temere temere kuraw la ta dala masa kah ma vəldiwa heyey.” ");
INSERT INTO mif_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«Bay a, a ləvar: “Maaya, ara mey ba. Kah, madərlam maaya. Maja ka ta key sləra ta cəveɗ e la ta cek mecəhe. Anda keɗe, ya paka ŋga wey da ray berney hay kuraw.” ");
INSERT INTO mif_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Madərlam ŋga dey cew e, ta’, a sawa, a ləvar: “Bay aɗaw, ya ta hətwa gabal temere temere zlam la ta dala masa kah ma vəldiwa heyey.” ");
INSERT INTO mif_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Bay a, a ləvar a ndaw aha: “Kah na, ya paka ŋga wey da ray berney hay zlam.” ");
INSERT INTO mif_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Ta’, madərlam mekele a sawa fa aŋga saya, a ləvar: “Bay aɗaw, təɓa dala akah. Ya ta ɓada la mahərzlakakaya daa bərtete, ");
INSERT INTO mif_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","maja ya fa zlurey ta akah. Kah na, ndaw ma sərey dey-ceceh fa ndaw ba, ka ley cek daa slam masa kah ma pa ba. Ka ŋgəmey daw daa slam masa kah ma sləka ba.” ");
INSERT INTO mif_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Bay a, a ləvar: “Kah, madərlam maaya ba. Mey akah masa kah maa guzlda keɗe na, ya da kaka sariya maja. Da ka sərya, yah, ya sərey dey-ceceh fa ndaw ba, ya ley cek daa slam masa yah ma pa ba, ya ŋgəmey daw daa slam masa yah ma sləka ba na, ");
INSERT INTO mif_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","anja ka vəlda dala ha a har ndaw amba daa mavəhwa aɗaw keɗe, ya təɓərwa dala ha ta yam a ba daw?” ");
INSERT INTO mif_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«Ta’, bay a, a ləvtar a ndəhay da cakay aŋga: “Təɓmara dala da har aŋga, vəldamara a ndaw masa ma hətey gabal temere temere kuraw heyey.” ");
INSERT INTO mif_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ndəhay a, a ləvmar: “Bay ala, ŋga aŋga gabal temere temere kuraw daha cay, ba diya?” ");
INSERT INTO mif_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Bay a, a ləvtar: “Ya fa ləvkwar, ndaw masa cek aŋga daha, a da vəlmar a dey a. Ama ndaw masa cek aŋga kuset kəɗey na, a da təɓmara cek aha kuset kəɗey a ŋgene. ");
INSERT INTO mif_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yaw, masa-gəra aɗaw hay masa ma wuɗam ya key bay ata ba heyey na, kərzamatərwa, handamatərwa, kəɗmata vagay fa mey aɗaw feɗe.”» ");
INSERT INTO mif_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Fa dəɓa ha, Yesu maa guzley la na, ta’, a daw ŋgadaa berney ŋga *Jeruzelem, ndəhay ga fa səpmar wurzay. ");
INSERT INTO mif_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","A wusey a Aŋgwa ŋga *Awliviye, gweegwe ta slala Betfaje leŋ ta slala Betani. Masa aŋga ma wusey la feteɗe na, ta’, a slərey gula aŋga hay cew teeseɗ ŋgada slala ha, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Diyam a slala fa mey aləkwa katay. Da akwar ta wusam a slala ha la na, ka hətfam bəz-zəŋgwaw majəwkaya la feteɗe, masa kwa ndaw ta təpey a ray a daa ba araŋ. Pəskamərwa, handamərwa feɗe. ");
INSERT INTO mif_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Da ndaw aa cəfɗakwar, a ləvey: “Ka pəskamara ka me?” na, ka mbəɗdamara, ka ləvmar: “Bay Mahura a wuɗey.”» ");
INSERT INTO mif_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Gula hay cew heyey, ta’, a diyam, a hətfamar cek aha anda Yesu ma ləvtar. ");
INSERT INTO mif_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Masa ata fa pəskamara bəz-zəŋgwaw a na, ndəhay ŋga zəŋgwaw a, a ləvmatar: «Ka pəskamara bəz-zəŋgwaw a, keme?» ");
INSERT INTO mif_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A mbəɗdamatara, a ləvmatar: «Bay Mahura a wuɗey.» ");
INSERT INTO mif_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ta’, a handamərwa fa Yesu, a ciyam zana ata hay a ray a. A təpdamara Yesu a ray bəz-zəŋgwaw a. ");
INSERT INTO mif_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Masa aŋga fa daw na, ndəhay a həslmar ray, a ciyam zana ata hay aa cəveɗ amba a daw ta ray a. ");
INSERT INTO mif_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Daa ŋgene, Yesu aŋga gweegwe ta berney ŋga Jeruzelem. Masa aŋga fa daw taa cəveɗ ma bərŋgawa daa Aŋgwa ŋga Awliviye na, ndəhay aŋga hay tabiya feteɗe faa səmam, a zlamar ŋga həlmamara Gazlavay ta gədaŋ maja maazla hay tabiya masa ata ma hətmar. ");
INSERT INTO mif_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","A ləvam: «Anja Bay Gazlavay ŋga pəsar mey a Bay masa aa ma slərdərwa ta mezəley aŋga. Anja Bay Gazlavay a, ŋga handərwa zazay aŋga a wuzlah ndəhay. Anja ndəhay ŋga həlmamara Gazlavay da vaɗ!» ");
INSERT INTO mif_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","*Fariza hay da wuzlah ndəhay a daha, a ləvmar a Yesu: «Bay, ləvtar a ndəhay akah hay ŋga njam teete.» ");
INSERT INTO mif_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu, ta’, a mbəɗdatara, a ləvtar: «Ya fa ləvkwar, da ta njam teete la na, kwa aŋgwa hay a wudam la.» ");
INSERT INTO mif_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Masa Yesu ma wusey la gweegwe ta berney ŋga *Jeruzelem na, a nəka berney a, ta’, a təway maja cek ma da hətfatar ndəhay da hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","A ləvey: «Akwar ndəhay da Jeruzelem, ya wuɗey anja tasana keɗe na, ka sərmara cek ma da njadakwar daa zazay ta Gazlavay. Ama wure keɗe, cek aha ta ɓey sem fa dey akwar, ka gwamara ŋga hətmar saba. ");
INSERT INTO mif_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pas a, a sawa la, masa masa-gəra akwar hay ma da zlərmakwar ray ta cek hay ŋga vəram. A gərcamakwar la aa berney a, kwa akwar fa da gwamara ŋga bawa daa saba. ");
INSERT INTO mif_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","A da bəzlmara berney akwar cəpa. Kwa fa da mbəkam aŋgwa pal da ray cəla daa ba. Akwar ta bəz akwar hay na, a da kəɗmakwar cəpa vagay, maja akwar ta pam leŋgesl fa pas masa Gazlavay ma sawa ŋga ləhdakwar na, daa ba!» ");
INSERT INTO mif_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Fa dəɓa ha, Yesu a mbəzey aa *Way-mekey-kwakwas ŋga Gazlavay. Feteɗe na, ndəhay daha fa kam luma. A ɓəlta ndəhay ma həɗkadam cek hay a, ");
INSERT INTO mif_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","a ləvtar: «Mawuzlalakaya daa ɗerewel ŋga Gazlavay, Gazlavay a ləvey: “Way aɗaw na, ara way amba ndəhay a dərmaya daŋgay da hwaɗ a.” Ama akwar na, ka tərdamara way a keɗe ŋga slam ŋga mayal hay!» ");
INSERT INTO mif_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mandaw mandaw Yesu faa sərkadata ndəhay daa Way-mekey-kwakwas ŋga Gazlavay. *Bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, ta *ndəhay maa sərkada kwakwas ŋga Mawiz, leŋ mahura hay ŋga *Jəwif hay, fa səpam cəveɗ ŋga kəɗmara vagay. ");
INSERT INTO mif_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ama ta hətam cəveɗ ŋga kərzamara daa ba, maja ndəhay tabiya fa jəkfamar sləmay maaya maaya. ");
INSERT INTO mif_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ta pas laŋgar daha, Yesu faa sərkadata ndəhay daa *Way-mekey-kwakwas ŋga Gazlavay, fa wuztar *Mey-maaya-mawiya. *Bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, ta *ndəhay maa sərkada kwakwas ŋga Mawiz, leŋ mahura hay mekele ŋga *Jəwif hay, a samawa fa aŋga. ");
INSERT INTO mif_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Aa cəfɗamara, a ləvmar: «Wuzdandara, ma ləvka ŋga kata cek hay a keɗe na, wa? Asaya, ma vəlka cəveɗ ŋga kata na, wa?» ");
INSERT INTO mif_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu a mbəɗdatara, a ləvtar: «Yah may, amba yaa cəfɗakwar mey pal. Wuzdamiwa cey. ");
INSERT INTO mif_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ma slərdərwa *Jaŋ-Baptis ŋga katar *baptem a ndəhay na, wa? Gazlavay daw, da daa ba, ndəhay daw?» ");
INSERT INTO mif_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ta’, ndəhay a, a slam yawa da wuzlah ata, a ləvam: «Ya da mbəɗdakwa aa mey aŋga ha na, kwara? Da ya ləvkwa: “Ara Gazlavay, ma slərdərwa,” na, a da mbəɗdandakwara, a ləvey: “Kaa ka təɓmara mey ŋga Jaŋ-Baptis a ba na, maja me?” ");
INSERT INTO mif_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ama, da ya ləvkwa: “Ara ndəhay ma slərdamərwa” na, ndəhay tabiya a daa zakamandakwar ta aŋgwa amba a kəɗmandakwar vagay, maja a wulkam Jaŋ-Baptis a, ara *ndaw ma təla mey ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Da ray ŋgene, a mbəɗdamara, a ləvmar: «Ya sərmara ba.» ");
INSERT INTO mif_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ta’, Yesu a mbəɗdatara, a ləvtar: «Yaw, da anda keɗe na, ya fa da kadakwara ndaw ma vəlya cəveɗ ŋga kata cek hay a keɗe na, daa ba may.» ");
INSERT INTO mif_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Fa dəɓa ha, Yesu, ta’, aa guzltar a ndəhay ta mey-meŋgey, a ləvtar: «Ndaw daha a key jerne ŋga wudez hay mezəmey. Ta’, a vəlda jerne he a har ndəhay ŋga kam sləra da hwaɗ a. Cay, ta’, a daw aa slam dəreŋ, a njawa ga feteɗe. ");
INSERT INTO mif_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","A wa təɗe aa kiya meŋgəley babəza ŋga wudez hay a na, ta’, a slərey gula aŋga pal fa ndəhay ma ka sləra daa jerne he, amba a təɓar babəza ŋga wudez hay a maala ŋga aŋga may. Gula ha, ta’, a daw, a wusey aa jerne he. Ama ndəhay a, a kəɗmərwa, a ɓəlmərwa ta har ɓa’ kəne. ");
INSERT INTO mif_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Fa dəɓa ha, bay ŋga jerne he, a slərey gula aŋga mekele saya. Aŋga may, a kəɗmərwa anda ndaw ŋgeeme heyey cəŋga, a cəɗmərwa, ta’, a ɓəlmərwa ta har ɓa’ kəne. ");
INSERT INTO mif_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Bay a, ta’, a slərey gula aŋga mekele ŋga dey maakar saya. Aŋga na, a kəɗmara haa a kamar mbəlek fa vaw, aa zakadamara a palah. ");
INSERT INTO mif_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Da ray ŋgene, bay ŋga jerne he, a wulkey, a ləvey: “Wure keɗe, ya da key na, kwara? Ŋgama ya slərey bəzey da hwaɗ aɗaw masa yah ma wuɗa kalah keɗe, da a cənmar mey la kwa.” Ta’ a slərda. ");
INSERT INTO mif_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ama masa ndəhay ma kam sləra daa jerne heyey, ma hətmar bəzey a fa sawa na, aa guzlam da wuzlah ata, a ləvam: “Nəkmara, ndaw ma sawa katay, ara bəzey ma da wa jerne keɗe fa dəɓa ŋga papaha. Da ta wuswa la na, ya kəɗkwa vagay, amba jerne he a njey ŋgada aləkwa.” ");
INSERT INTO mif_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Masa aŋga ma wuswa la na, ta’ aa zakadamara daa jerne he a palah, a kəɗmara vagay.» Yesu aa cəfɗata ndəhay feteɗe, a ləvey: «Wure keɗe, ka wulkam bay ŋga jerne he a da kadata ndəhay a na, kwara? ");
INSERT INTO mif_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yaw, ya fa ləvkwar bay ŋga jerne he, a da sawa ŋga kəɗta ndəhay a cəpa vagay, a da vəlda jerne he a har ndəhay mekele.» Masa ndəhay a ma cəndamara mey a keɗe na, a ləvam: «Anja Gazlavay ŋga ka kəne ba!» ");
INSERT INTO mif_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu a nəkta, a ləvey: «Da ka wuɗam cek aha ŋga key kəne ba na, mey ŋga Gazlavay mawuzlalakaya ma ləvey: “Aŋgwa meləmey way masa ndəhay ma ləma way ma kəzlamara ta cakay na, anja ara aŋgwa maaya, ma fənta siya hay jak.” Mey a keɗe na, a wuɗey ŋga ləvey me? ");
INSERT INTO mif_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yaw, kwa waawa ta təɗey la a ray aŋgwa ha na, a ŋgərfey. Da aŋgwa ha ta kəzley la a ray ndaw na, a ɗəga kwəɗ-kwaɗ.» ");
INSERT INTO mif_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","*Ndəhay maa sərkada kwakwas ŋga Mawiz, ta *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, a sərmara Yesu aa guzley mey-meŋgey keɗe da ray ata. A wuɗam ŋga kərzamara Yesu ta pas a ŋgene, ama a zluram ta ndəhay. ");
INSERT INTO mif_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Da ray ŋgene, a zlamar ŋga jəɗmara. Ta’, a walam ndəhay, a slərdamata fa Yesu amba a jəɗam mey da mey aŋga. Ndəhay a, a pamata ray ata hay anda ndəhay maaya. A wuɗam ŋga cənam mey maaya ba fa aŋga, amba a kərzamara, a handamara fa ndəhay ŋga ŋgwamna amba a kamar sariya. ");
INSERT INTO mif_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aa cəfɗamara, a ləvmar: «Bay ala, ya sərmara mey masa kah maa guzlda, ta cek masa kah maa sərkadandara na, ara mey fara fara. Ka nəkta ndəhay cəpa letek fa mey akah. Ka faa sərkadata ndəhay ŋga njam anda Gazlavay ma wuɗey fara fara. ");
INSERT INTO mif_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Anda keɗe, ya wuɗam ŋgaa cəfɗamaka, kwakwas aləkwa na, a vəley cəveɗ ŋga pəley budaw a bay mahura *Sezere daw? A vəley cəveɗ ba daw?» ");
INSERT INTO mif_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ama Yesu a səra wewer ata, ta’, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Wuzmaya dala ha pal cey.» Masa ata ma wuzmar dala ha la na, aa cəfɗata, a ləvtar: «Fa dala ha keɗe, ara dey ŋga wa? Ara mezəley ŋga wa?» A mbəɗdamara, a ləvmar: «Ara ŋga Sezere, bay mahura ŋga *Rawm.» ");
INSERT INTO mif_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ta’, Yesu a ləvtar: «Anda keɗe, cek masa ŋga Sezere na, vəldamara a Sezere he. Cek masa ŋga Gazlavay na, vəldamara a Gazlavay a.» ");
INSERT INTO mif_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","A jəɗam mey da mey aŋga fa dey ŋga ndəhay tabiya, ama ta hətam mey da hwaɗ aŋga ŋga kərza daa ba. Sasəkar mey masa Yesu ma mbəɗdatara na, a rəzlam ga da ray a jak, a njam teete. ");
INSERT INTO mif_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Fa dəɓa ha, ndəhay *Saduse hay a ŋgəcham a cakay Yesu. Ndəhay a ŋgene ara ndəhay ma wulkam, ma ləvam da ndaw ta məcey sem na, fa da sləkɗawa daa meməcey daa ba. Aa cəfɗamara Yesu, a ləvmar: ");
INSERT INTO mif_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Bay ala, zleezle *Mawiz ta wuzlalandakwar kwakwas la, a ləvey: “Da ndaw məlmaha ta məcey sem na, da ŋgwas ŋga ndaw ma məcey a, ta yawa bəza hay daa ba na, si məlmaha a la ŋgwas-vagay a, amba a yamawa bəza hay ŋgada məlmaha maməckaya ha.” ");
INSERT INTO mif_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yaw, məlmaŋ hay maasala daha, ata ŋgaa maŋ, ŋgaa paŋ. Məlma ata mahura, leŋ! a ley ŋgwas. Fa dəɓa ha, ndaw aha pam! a məcey, ta hətey bəzey daa ba. ");
INSERT INTO mif_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mambaray a, leŋ! a la ŋgwas-vagay a, aa pam! a məcey, ta hətey bəzey daa ba may. ");
INSERT INTO mif_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ma səpa ŋga maakar a, leŋ! a la ŋgwas-vagay a saya, a məcey, ta hətey bəzey daa ba cəŋga. Anda keɗe, ata maasala ata tabiya, ta lamara ŋgwas aha la, a məcam, ta hətam bəzey ta ŋgwas aha daa ba. ");
INSERT INTO mif_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Fa dəɓa ha masa ta məcam sem na, ŋgwas aha pam! a məcey may. ");
INSERT INTO mif_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Anda keɗe, ta pas masa ndəhay maməctakaya ma da sləkɗamawa na, ŋgwas aha a da key na, ŋgwas ŋga wa? Maja ata maasala ata cəpa, ta lamara la ŋga ŋgwas ata.» ");
INSERT INTO mif_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu a mbəɗdatara, a ləvtar: «Da bəla keɗe, zel fa ley ŋgwas, ŋgwas fa ley zel. ");
INSERT INTO mif_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ama fa dəɓa ŋga meməcey, zel hay ta ŋgusay masa Gazlavay ma nəkta maaya ŋga sləkɗamawa daa meməcey amba a njam da cakay aŋga na, ŋgene zel a ley ŋgwas daa saba, ŋgwas a ley zel daa saba. ");
INSERT INTO mif_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Daa masa ata da cakay Gazlavay na, ata anda maslaŋ aŋga hay da vaɗ, fa da məcam daa saba. Ta təram sem bəza hay ŋga Gazlavay maja ta sləkɗamawa sem daa meməcey. ");
INSERT INTO mif_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kwa Mawiz zleezle na, ta wuzleley mey la ŋga wuzey, ndəhay a sləkɗamawa la daa meməcey. Yaw, daa masa aŋga maa guzley da ray awaw megəɗey da ray kusaf na, a zəla Bay Gazlavay, “Gazlavay masa *Abəraham, *Izak, leŋ *Jakwap ma namar ray.”» ");
INSERT INTO mif_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yesu aa guzley saya, a ləvey: «Fa Gazlavay na, ndəhay maməctakaya ta ndəhay ta dey na, ata cəpa ta dey, maja Bay Gazlavay, ara Gazlavay ŋga ndəhay ta dey, ba na, ara Gazlavay ŋga ndəhay maməctakaya ba.» ");
INSERT INTO mif_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Siya hay da wuzlah ndəhay maa sərkada kwakwas ŋga Mawiz a ləvam: «Bay ala, ka taa guzley la maaya.» ");
INSERT INTO mif_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Da ray ŋgene ndəhay a zluram ŋgaa cəfɗafamar mey mekele. ");
INSERT INTO mif_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu aa cəfɗata ndəhay feteɗe, a ləvey: «Ndəhay a ləvam *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay na, ara bəzey da hwaɗ Bay *Davit na, kwara? ");
INSERT INTO mif_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Maja Davit ta ray aŋga, a wuzlala daa ɗerewel ŋga *Pəsam, a ləvey: “Bay Gazlavay a ləvar a Bay aɗaw Mahura: Sawa, njey a har-zəmay aɗaw amba ya wakwa da ray ndəhay ");
INSERT INTO mif_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","haa ta pas masa yah ma da pata masa-gəra akah hay asi salay akah.” ");
INSERT INTO mif_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yaw, da Davit a zəla Kəriste “Bay Mahura” na, kaa wara Kəriste he ara bəzey da hwaɗ Davit saya na, kwara?» ");
INSERT INTO mif_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesu a patar leŋgesl a gula aŋga hay fa mey ŋga ndəhay tabiya da cakay a, fa jəkfamar sləmay. Aa guzltar a gula aŋga hay a, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Wam vaw fa *ndəhay maa sərkada kwakwas ŋga Mawiz. A wuɗam mepəkey ta dawura hay fa vaw ŋga zlepey. A wuɗam ndəhay a camatar har ta meney ray fa mey ŋga ndəhay. Daa *way-mewuzey-mey ŋga Gazlavay na, a səpam slam-menjey fa mey ŋga ndəhay amba ndəhay tabiya a hətmatar. Ta pas gwagway na, a səpam slam-menjey maaya. ");
INSERT INTO mif_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Asaya, fa təɓmatara cek hay ŋga ŋgwas-vagay hay tabiya, ama da ata fa dəram daŋgay na, a njam daa medərey-daŋgay a ga, amba ndəhay a ləvam ata maaya. Ya fa ləvkwar, Gazlavay a sərdata banay la, ma fəna ŋga ndəhay mekele!» ");
INSERT INTO mif_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu aŋga daa *Way-mekey-kwakwas ŋga Gazlavay. A nəkey dey ta cakay, a hətatar ndəhay masa-zleley hay, fa kwiyam dala aa cek mecekeley dala. ");
INSERT INTO mif_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A hətey ŋgwas-vagay masa-viya daha, fa kwiyey sisey sisey cew aa cek aha may. ");
INSERT INTO mif_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Da ray ŋgene, Yesu a ləvey: «Ya fa ləvkwar fara fara, ŋgwas-vagay masa-viya keɗe, ta vəley dala la ma fəna ŋga ndəhay siya tabiya. ");
INSERT INTO mif_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ya ləvkwar anda keɗe na, maja ndəhay siya, a vəlam dala nekəɗey daa dey zleley ata hay da way ga. Ama ŋgwas-vagay keɗe, ta mərga aŋga ha cəpa, a vəlda zleley aŋga tabiya, masa aŋga ma da həɗkey cek mezəmey ta aŋga.» ");
INSERT INTO mif_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ndəhay siya aa guzlam da ray *Way-mekey-kwakwas ŋga Gazlavay, a ləvam: «Way keɗe, maɗiykaya ta aŋgwa ma mbey kalah, ta cek hay maaya ma həɗkam ba masa ndəhay ma vəldamata a Gazlavay.» Yesu a ləvtar: ");
INSERT INTO mif_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Pas a, a sawa la, cek hay masa akwar ma hətmatar keɗe na, a da bəzlam cəpa, kwa aŋgwa pal fa da mbəkey da ray cəla daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Aa cəfɗamara, a ləvmar: «Bay ala, cek aha a da key na, ta vara? Ya da sərmara ɗar a ta wuswa cay na, fa me?» ");
INSERT INTO mif_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu a mbəɗdatara, a ləvtar: «Wam vaw, ka da vəlmatar cəveɗ a ndəhay ŋga fəcmakwar ba. Ya ləvkwar anda keɗe, maja ndəhay ga a samawa la, ta mezəley aɗaw, a da ləvam ara Gazlavay ma walata ŋga ləhey ndəhay daa banay. Asaya, a ləvam pas masa Gazlavay ma da ləhdata ndəhay ta wuswa cay. Ka da diyam asi ndəhay a ŋgene ba! ");
INSERT INTO mif_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ta pas masa akwar ma da cənam labara ŋga vəram hay, ta labara ŋga ndəhay ma cakalam mey ta bay ata hay na, ka da zluram ba, maja si cek hay keɗe a kam la teeseɗ ɗagay. Ama ara mendəvey ŋga bəla wure wure ŋgene ba.» ");
INSERT INTO mif_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Fa dəɓa ha, aa guzley saya, a ləvey: «Hwayak laŋgar a da key vəram ta hwayak laŋgar, bay laŋgar a da key həma a ray bay laŋgar. ");
INSERT INTO mif_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hwiyak a wusey la ga. May a key la daa hwayak hay mekele mekele, asaya, macay hay a kəɗam ndəhay la ga. Cek hay ma zlurey ndaw a kam la, asaya, cek hay ma rəzley ndaw a wuzmawa la da gazlavay da vaɗ. ");
INSERT INTO mif_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Ama wuskwaa cek hay a, a da kam na, a kərzamakwar la, a sərdamakwar banay la, a vəldamakwar la amba a kamakwar sariya daa *way-mewuzey-mey ŋga Gazlavay hay. A ndəkwdamakwar la aa fərsəne, a handamakwar la fa mey ŋga bay hay, ta fa mey ŋga mahura hay ŋga hwayak hay, maja yah. ");
INSERT INTO mif_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ka da səram banay a ŋgene na, amba ka hətam cəveɗ ŋga key sede da ray aɗaw. ");
INSERT INTO mif_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Da ray ŋgene, sərmara maaya maaya ka da zluram da ray mey masa akwar ma daa guzlam ba, ");
INSERT INTO mif_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","maja ya vəlkwar leŋgesl la ŋgaa guzley mey maaya. Anda keɗe, kwa masa-gəra akwar hay, fa da gwamara ŋga təɗdamakwar daa ba. ");
INSERT INTO mif_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kwa papakw akwar hay, kwa mamakw akwar hay, kwa məlmakw akwar hay, kwa səkway akwar hay, kwa jam akwar hay, a wudmakwar la a way bay. Ndəhay siya da wuzlah akwar na, a kəɗmata la vagay. ");
INSERT INTO mif_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ndəhay tabiya a da ŋgəldamakwar ba, maja yah. ");
INSERT INTO mif_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama, kwa eŋgwec ŋga ray akwar pal fa daa zəɗey daa ba. ");
INSERT INTO mif_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ɓəsmara banay a, anda keɗe, ka hətam heter mendəvey ba la.» ");
INSERT INTO mif_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesu aa guzltar a gula aŋga hay saya, a ləvtar: «Da ka hətmatar sewje hay ta zlərmara berney ŋga *Jeruzelem sem ŋga key vəram na, daa ŋgene, sərmara berney a gweegwe cay a pəlhey. ");
INSERT INTO mif_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Anda keɗe, si ndəhay daa hwayak ŋga *Jude a hwam ŋga ɓawa a aŋgwa, si ndəhay da Jeruzelem a bam, asaya, ndəhay da slala ta cakay a da mbəzam aa berney a saba. ");
INSERT INTO mif_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Daa ŋgene, Bay Gazlavay a da sərdata banay ta ndəhay daa hwayak a, amba cek hay tabiya mawuzlalakaya daa ɗerewel ŋga Gazlavay dəga zleezle na, a kam fara fara. ");
INSERT INTO mif_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Daa ɗar hay a ŋgene, banay a sawa la a ray ŋgusay ta hwaɗ ta a ray ŋgusay masa ta bəza hay da har, maja banay mahura a sawa la aa hwayak a. Fara fara, Bay Gazlavay a cey mevel la a ray ndəhay daa hwayak a. ");
INSERT INTO mif_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Masa-gəra hay a da kəɗmata ndəhay siya vagay ta dəlaw, siya, a da tərdamata ŋga beke hay, a da handamata aa hwayak hay mekele mekele da bəla. Anda keɗe, ndəhay masa *Jəwif hay ba, a da wam da ray Jeruzelem, a da sərdamata banay haa kasl pas masa mewey ata ha ma ndəvey.» ");
INSERT INTO mif_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesu aa guzley saya, a ləvey: «Daa ŋgene, ndəhay a da zluram, a wulkam cek maaya ba a key la maja pas fa mbəɗey, kiya fa mbəɗey, wurzla hay fa mbəɗam. Da bəla na, səkway hay tabiya mandərzay a da katar maja membey mey ŋga yam ta vaŋgwala ŋga yam daa bəlay. ");
INSERT INTO mif_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ndəhay a da wulkam kalah fa cek hay ma da kam da bəla, anda keɗe mandərzay a da kəɗta vagay maja cek hay cəpa da gazlavay da vaɗ, a wusam la. ");
INSERT INTO mif_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Fa dəɓa ha, a da hətmaya yah, *Bəz ŋga Ndaw, ya fa sawa daa mekwtene ta gədaŋ mahura, ta meweɗey ŋga Bay Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ama da cek hay a keɗe fa zlamar mekey na, akwar na, lacam maaya maaya, baŋgaɗamata dey akwar hay, maja yah, ndaw ma da ləhdakwar daa banay, gweegwe cay ya wuswa.» ");
INSERT INTO mif_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Fa dəɓa ha, Yesu a ŋgatar mey a gula aŋga hay, a ləvtar: «Nəkmara gudav keɗe ta wudez hay siya. ");
INSERT INTO mif_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Da masa akwar fa hətmatar gwaslaf hay a fa zlamar ŋga ɗeɗey na, ka sərmara kiya madaw a ley gweegwe cay. ");
INSERT INTO mif_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aŋga letek kəne, da ka hətmatar cek hay a fa kam anda yah ma ləvkwar kaa na, ka sərmara gweegwe cay, Gazlavay a wuzdərwa bay aŋga. ");
INSERT INTO mif_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ya fa ləvkwar fara fara, cek hay a keɗe tabiya, a da kam na, ndəhay masa wure keɗe ta məcam tabiya daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Slam da vaɗ ta slam da hwayak a ndəvey la, ama mey aɗaw na, fa da ndəvey daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Wam vaw fa menjey akwar. Wam vaw, ka da mbəkdamara ray akwar ŋga sey cek haa ka wam ba leŋ ŋga səpey cek mezəmey ta cek mesey kalah ba, asaya, ka da mbəkdamara ray akwar ŋga wulkey kalah da ray menjey da bəla ba. Ray akwar a da həɓey fa cek hay a keɗe ba, maja pas masa yah ma da vəhwa na, kwa ka sərmara ɗar a ba, ya da hətfakwar dərfafay, ");
INSERT INTO mif_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","anda ndaw ma kərzey cek ta gadaŋ. Ta pas ŋgene, ya da katar sariya a ndəhay da bəla tabiya. ");
INSERT INTO mif_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ya fa ləvkwar, wam vaw, dəram daŋgay mandaw mandaw, amba ka hətam gədaŋ ŋga ləhey fa cek hay ma da kam tabiya, asaya, ŋga lecey fa mey aɗaw, yah, *Bəz ŋga Ndaw, ta mandərzay ba.» ");
INSERT INTO mif_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mandaw mandaw Yesu a vərndey daa *Way-mekey-kwakwas ŋga Gazlavay, fa wuzey mey. Ama taa kwaɗ na, a daw a nawa daa aŋgwa ŋga *Awliviye. ");
INSERT INTO mif_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mandaw mandaw taa pərek na, ndəhay ga a diyam fa vəɗa aa Way-mekey-kwakwas ŋga Gazlavay, amba a jəkam sləmay fa mey aŋga. ");
INSERT INTO mif_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gwagway ŋga peŋ manjar cek ma həsla da hwaɗ a mezəley gwagway ŋga *Pak, gweegwe cay. ");
INSERT INTO mif_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","*Bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, ta *ndəhay maa sərkada kwakwas ŋga Mawiz, a səpam cəveɗ amba a kəɗmara Yesu vagay, ama a zluram ta zagaba. ");
INSERT INTO mif_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Fa dəɓa ha, *Sataŋ kula! a mbəzey aa mevel ŋga Juda, ndaw mezəley Iskariyawt. Ara gula pal da wuzlah gula hay kuraw a ray a cew ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Juda ta’, a daw a kamawa maɗay ta *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay leŋ ta mahura hay ŋga ndəhay ma jəɗa *Way-mekey-kwakwas ŋga Gazlavay amba a vəldatara Yesu. ");
INSERT INTO mif_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bay-ray hay ta mahura hay a, aa səmam ga. A ləvmar da ta vəldatara Yesu la na, a vəlmar dala. ");
INSERT INTO mif_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Juda a təɓa ŋga vəldatara. A daw a səpey cəveɗ, amba a vəldatara Yesu, kwa ndəhay a sərmara ba. ");
INSERT INTO mif_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gwagway ŋga peŋ manjar cek ma həsla da hwaɗ a, ta wuswa cay. Pas a ŋgene ara pas ma hərey bəz-təɓaŋ hay ŋga key gwagway ŋga *Pak. ");
INSERT INTO mif_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Da ray ŋgene, Yesu a slərdata ata *Piyer ta *Jaŋ, a ləvtar: «Diyam ta ɗiymandakwar slam ta cek mezəmey amba ya zəmkwa ɗaf ŋga gwagway ŋga Pak!» ");
INSERT INTO mif_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ata Piyer ta Jaŋ aa cəfɗamara, a ləvmar: «Ka wuɗey ya diyam ŋga ɗiywa slam aha na, dama?» ");
INSERT INTO mif_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A mbəɗdatara, a ləvtar: «Ehe, jəkam sləmay. Diyam aa berney ŋga *Jeruzelem. Masa akwar fa da mbəzam aa berney a na, ka cam ray la ta ndaw daha fa daw ta yam daa kwakulam. Diyam asiya. Aa way masa aŋga ma da mbəzey na, ");
INSERT INTO mif_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ləvmar a bay ŋga way a: “Bay ala a ləvey: Way masa yah ma da zəmam ɗaf ŋga gwagway ŋga Pak ta gula aɗaw hay na, aa daa wura?” ");
INSERT INTO mif_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Fa dəɓa ha, a wuzkwar way mahura da ray way la. Daa way a na, cek hay tabiya daha ŋga key gwagway a. Ka da ɗiymandakwara cek mezəmey amba ya zəmkwa ɗaf ŋga gwagway a feteɗe.» ");
INSERT INTO mif_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Fa dəɓa ha, a diyam, a hətfamatar cek hay tabiya anda Yesu ma ləvtar heyey. Ta’, a ɗiymata cek hay ŋga gwagway ŋga Pak a. ");
INSERT INTO mif_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Masa pas təɗe ŋga zəmey ɗaf ŋga gwagway ŋga *Pak heyey na, ta’, Yesu a diyam aa way heyey, a njam ta ndəhay aŋga hay meslərey ŋga zəmey ɗaf. ");
INSERT INTO mif_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesu a ləvtar: «Ya ta wuɗey la fara fara ŋga zəmey ɗaf ŋga gwagway ŋga Pak keɗe ta akwar, wara a sərdamaya banay. ");
INSERT INTO mif_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ya fa ləvkwar, kwa ya fa da zəmey ɗaf ŋga gwagway ŋga Pak a daa saba, si ta pas masa Bay Gazlavay ma da wey da ray ndəhay tabiya da vaɗ. Ta pas ŋgene, mabara ŋga mey da ray gwagway ŋga Pak a, a wuzwa la fara fara.» ");
INSERT INTO mif_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Fa dəɓa ha, Yesu leŋ! a la vəley ta cek mesey da hwaɗ a, ta’, a kar suse a Bay Gazlavay, a ləvtar: «Təɓmara cek keɗe, samara akwar cəpa. ");
INSERT INTO mif_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ya fa ləvkwar fara fara, dəga wure keɗe, ya fa da sey cek aha ta akwar daa saba haa kasl pas masa Gazlavay ma da wuzdərwa bay aŋga fara fara.» ");
INSERT INTO mif_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Fa dəɓa ha, leŋ! a ley peŋ, a kar suse a Bay Gazlavay, ta’, a wunka, a vəldatara, a ləvtar: «Keɗe he na, ara vaw aɗaw mavəldakaya ŋgada akwar. Kamara anda keɗe amba ka sərfadamaya.» ");
INSERT INTO mif_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ata ma zəmamara ɗaf cay na, ta’, a vəldatara vəley ta cek mesey da hwaɗ a heyey saya, a ləvtar: «Keɗe he na, ara mambaz aɗaw. Mambaz a, a da mbəɗwa maja akwar. Ta fa mambaz a, Gazlavay a jəwey mey mawiya ta ndəhay aŋga hay. ");
INSERT INTO mif_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ama nəka, ndaw masa ma daa zəɗdaya na, aŋga fa zəmey ɗaf feɗe ta yah. ");
INSERT INTO mif_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Fara fara, si yah, *Bəz ŋga Ndaw, ya məcey anda Gazlavay ma wuɗey, ama banay a sawa la a ray ndaw masa ma daa zəɗdaya!» ");
INSERT INTO mif_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aa cəfɗam vaw da wuzlah ata, a ləvam: «Ma da ka cek aha keɗe na, ara wa?» ");
INSERT INTO mif_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Fa dəɓa ha nekəɗey, *gula hay ŋga Yesu a kam yawa ga da wuzlah ata, a wuɗam amba a sərmara mahura da wuzlah ata na, wa. ");
INSERT INTO mif_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu a ləvtar: «Bay hay da bəla keɗe fa wam da ray ndəhay ta gədaŋ. Ata na, a wuɗam ndəhay ata hay aa həmdamata, a zəlmata bay hay ma ka sləra maaya. ");
INSERT INTO mif_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ama ŋga akwar na, kəne ba. Ndaw masa mahura da wuzlah akwar na, si a tərey anda matabəwa akwar. Ndaw masa ma wakwar na, si a tərey ndaw ma kakwar sləra. ");
INSERT INTO mif_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Da wuzlah ndaw ma həlrawa ɗaf ta ndaw ma zəma na, mahura na, wa? Mahura na, ara ndaw ma zəma, ba diya? Ama yah na, yah da wuzlah akwar, anda ndaw ma kakwar sləra. ");
INSERT INTO mif_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Akwar na, ndəhay masa dasi aɗaw mandaw mandaw daa masa ya fa sərey banay, akwar ta mbəkdamaya daa ba. ");
INSERT INTO mif_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yah may, ya vəlkwar gədaŋ amba ka wam da ray ndəhay anda Papay ma vəlya gədaŋ ŋga wey da ray ndəhay. ");
INSERT INTO mif_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Da ray ŋgene, pas masa yah ma da wey da ray ndəhay na, akwar may, ka da njam aa slam maaya da cakay aɗaw, ya da zəmkwa cek, ya da sakwa cek bama. Ka da njam aa slam-menjey ŋga bay hay, amba ka kamatar sariya ŋgada səkway ŋga *Israyel hay kuraw a ray a cew.» ");
INSERT INTO mif_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu a ləvar a *Simaŋw *Piyer: «Simaŋw, Simaŋw, jəkey sləmay, *Sataŋ ta hətey cəveɗ la amba a kəfkwar anda ndaw ma kəfey daw ŋga wunkey bəz-daw ta cekwesl e. ");
INSERT INTO mif_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama ya ta dərar daŋgay la a Gazlavay maja kah, amba ka mbəkda ŋga təɓa mey aɗaw ba. Pas masa ka ta vəhwa sem a fa yah cəŋga na, vəltar gədaŋ a məlmakw hay may.» ");
INSERT INTO mif_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyer a ləvar: «Bay Mahura, kwa a handamaka aa fərsəne na, ya səpka la, amba ya njakwa cew e, asaya, kwa a kəɗmaka vagay na, ya məckwa la cew e.» ");
INSERT INTO mif_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu a mbəɗdara, a ləvar: «Ya fa ləvka, Piyer, tasana wuskwaa gwagwalak a da cey ɗay na, ka ta ləvey cay dey maakar, ka sərya ba, ka sərya ba.» ");
INSERT INTO mif_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Fa dəɓa ha, Yesu a ləvtar a gula aŋga hay: «Ta pas masa yah ma slərdakwar, dala da har daa ba, gabal daa ba, tarak daa ba heyey na, ka ta huram cek daa slam aha la daw?» A mbəɗdamara, a ləvmar: «Ya ta huram cek daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A ləvtar: «Ama wure keɗe na, ndaw masa dala aŋga daha, ŋga la a har, ndaw masa gabal aŋga daha, ŋga la. Ndaw masa dəlaw aŋga daa ba, ŋga həɗkada zana aŋga, ŋga həɗkawa dəlaw dəɓa. ");
INSERT INTO mif_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Daa ɗerewel ŋga Gazlavay, mey mawuzlalakaya da ray aɗaw a ləvey: “Aŋga masləfkaya da wuzlah ndəhay ma kəɗa ndəhay vagay!” Fara fara, si cek a kaya la anda mey mawuzlalakaya da ray aɗaw a cəma.» ");
INSERT INTO mif_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Gula aŋga hay a ləvmar: «Bay Mahura, dəlaw hay cew keɗe daha.» A mbəɗdatara, a ləvtar: «Mey a keɗe mak.» ");
INSERT INTO mif_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Fa dəɓa ha, Yesu ta’, a bey daa berney ŋga *Jeruzelem, a daw ŋgadaa Aŋgwa ŋga *Awliviye anda aŋga ma daw mandaw mandaw taa kwaɗ. Gula aŋga hay ta’, a diyam asiya. ");
INSERT INTO mif_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aŋga ma wusey la feteɗe na, ta’, aa guzltar a gula aŋga hay, a ləvtar: «Dəram daŋgay a Gazlavay ŋga jənkwar amba cek a batakwar ŋga key mebərey ba.» ");
INSERT INTO mif_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Fa dəɓa ha, ta’, a daw ta cakay, dəreŋ nekəɗey. Da ndaw aa zekey aŋgwa na, a wusey aa slam aha. Ta’, a regedey, a dərey daŋgay, ");
INSERT INTO mif_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","a ləvey: «Papay, da ka wuɗey na, ka gwa ka ŋgəchada banay keɗe dəreŋ ta yah. Ta kəne he cəpa na, ka da ka anda yah ma wuɗey ba, ama ka anda kah ma wuɗey.»  ");
INSERT INTO mif_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Daa slam aha ŋgene, *maslaŋ ŋga Bay Gazlavay da vaɗ, ta’, a pawa salay ŋga vəlar gədaŋ. ");
INSERT INTO mif_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Fa dəɓa ha, Yesu a dərey daŋgay ta gədaŋ aŋga cəpa maja mevel aŋga fa təɗey kalah. Mawurɓay fa vaw aŋga fa vavawa, fa gəcey anda mambaz ma gəcey a hwayak. ");
INSERT INTO mif_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Aŋga ma dərey daŋgay cay na, ta’, a sləkɗey, a vəhwa fa gula aŋga hay. A hətfatar na, ata cəkw-cakw daa ɗar maja ta wulkam la ga, a gəram. ");
INSERT INTO mif_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A ləvtar: «Ka nam maja me? Sləkɗam, dəram daŋgay a Gazlavay ŋga jənkwar amba cek a batakwar ŋga key mebərey ba.» ");
INSERT INTO mif_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Masa Yesu ta ndəvda meeguzley daa ba araŋ na, ndəhay ga fa samawa ta ata Juda, ndaw pal dasi gula aŋga hay kuraw a ray a cew heyey. Juda ha, aa fa mey ata. A ŋgəchey fa Yesu amba a car har anda mandala aŋga fara fara. ");
INSERT INTO mif_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ama Yesu a ləvar: «Juda, ka caya har amba kaa zəɗdaya, yah, *Bəz ŋga Ndaw daw?» ");
INSERT INTO mif_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Masa ndəhay ŋga Yesu ma hətmar cek aha na, aa cəfɗamara Yesu, a ləvmar: «Bay Mahura, ka wuɗey ya kəɗmata ndəhay a ta dəlaw hay daw?» ");
INSERT INTO mif_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ndaw pal da wuzlah ata, a ŋgəma madərlam ŋga *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay ta dəlaw, cərah! a cərha sləmay ta dey ŋga zəmay. ");
INSERT INTO mif_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ama Yesu a ləvey: «Cay, mak! Mbəkdamata ŋga wam ŋga ata.» A gəsfar har fa sləmay ŋga ndaw aha, sləmay a, ta’, a kəfey aa slam a. ");
INSERT INTO mif_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Fa dəɓa ha, ta’, aa guzltar ŋgada *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, ta ŋgada mahura hay ŋga ndəhay ma jəɗa *Way-mekey-kwakwas ŋga Gazlavay, leŋ ŋgada mahura hay ŋga *Jəwif hay masa ma samawa ŋga kərzamara, a ləvtar: «Ka samawa ŋga kərzamaya ta dəlaw, ta zlanday faa har faa har anda yah ndaw-mayal na, maja me? ");
INSERT INTO mif_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mandaw mandaw yah da wuzlah akwar daa Way-mekey-kwakwas ŋga Gazlavay, akwar ta səpmaya ŋga kərzey daa ba. Ama pas a keɗe ara pas akwar, amba ka kam cek anda akwar ma wuɗam da ray aɗaw, asaya, ara pas ŋga *Sataŋ, bay ŋga ləvaŋ, ma da ka sləra aŋga da ray aɗaw.» ");
INSERT INTO mif_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Masa ata ma kərzamara Yesu cay na, ta’, a handamara a way *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay. *Piyer fa səpta ta meedəreŋ e. ");
INSERT INTO mif_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Da way ndaw mahura da ray ndəhay ma ka kwakwas a na, awaw magəɗkaya da palah-way daha. Piyer a daw cəkwam! a njey a cakay ndəhay manjatakaya da mey awaw a. ");
INSERT INTO mif_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dam ma ka sləra da way a daha, a hətar Piyer manjakaya da mey awaw a. Ta’, a nəkfa, a ləvey: «Ndaw keɗe na, ara gula ŋga Yesu.» ");
INSERT INTO mif_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ama Piyer ma cənda anda keɗe na, a cada mey, a ləvey: «Kay! ŋgwas keɗe, ya səra ndaw a ba.» ");
INSERT INTO mif_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Menjey nekəɗey, ndaw mekele a hətar Piyer saya, a ləvar: «Kah na, ndaw pal dasi gula aŋga hay.» Ama Piyer a mbəɗdara a ndaw aha, a ləvar: «Kay! yah dasi ata ba.» ");
INSERT INTO mif_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Fa dəɓa ha, menjey zəɓat a saya na, ndaw mekele aa guzley ta gədaŋ, a ləvey: «Fara fara, ndaw keɗe na, ara gula aŋga, maja aŋga ndaw *Galile.» ");
INSERT INTO mif_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ama Piyer a mbəɗdara, a ləvar: «Ndaw keɗe! ya səra mey masa kah ma wuɗey ŋga ləvey keɗe ba.» Wure wure ŋgene, masa ta ndəvda maa guzley daa ba araŋ na, gwagwalak a cey ɗay. ");
INSERT INTO mif_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bay Mahura Yesu pəla! a mbəɗey dey fa Piyer, a nəkfa. Piyer a sərfada mey masa Bay Mahura ma ləvar: «Wuskwaa gwagwalak a da cey ɗay tasana na, ka ta ləvey cay dey maakar ka sərya ba, ka sərya ba.» ");
INSERT INTO mif_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piyer ta’, a bawa aa ambaw, a təway ga, a zəley marava. ");
INSERT INTO mif_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Ndəhay ma jəɗmara Yesu a, aa saŋgərfamar. A sərtamara dey aŋga ta zana, a kəɗmara, ta’, aa cəfɗamara, a ləvmar: «Səra ma kəɗka keɗe na, wa? Wuzdandara cey!» ");
INSERT INTO mif_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aa guzlmar mey hay mekele mekele, a cəɗmara. ");
INSERT INTO mif_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Fa dəɓa ha, slam ma wurey cay na, mahura hay ŋga *Jəwif hay, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, leŋ *ndəhay maa sərkada kwakwas ŋga Mawiz, a kusam. A ləvmatar a ndəhay ma jəɗmara Yesu ŋga handamərwa Yesu a fa mey ata, ŋga key sariya. Ta’, a handamərwa Yesu a, fa mey ata. ");
INSERT INTO mif_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ndəhay mahura hay heyey ta’, aa cəfɗamara, a ləvmar: «Da kah *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay heyey na, kadandara.» Yesu a mbəɗdatara, a ləvtar: «Kwa ya kadakwara yah Kəriste na, akwar fa da təɓmara daa ba. ");
INSERT INTO mif_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Da yaa cəfɗakwar mey pal na, akwar fa da mbəɗdamiwa daa ba. ");
INSERT INTO mif_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Dəga wure keɗe, yah, *Bəz ŋga Ndaw, ya da njey ta har-zəmay ŋga Bay Gazlavay Mawaca-waca.» ");
INSERT INTO mif_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ata tabiya a ləvmar: «Kaa kah na, Bəzey ŋga Gazlavay dəɓa daw?» A mbəɗdatara, a ləvtar: «Ahaw, anda akwar ma ləvam, yah, Bəzey ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Da ray ŋgene, aa guzlam, a ləvam: «Aləkwa ta ray aləkwa, ta cəndakwa cay da mey aŋga, ya səpkwa ndaw ŋgaa guzlndakwar da ray a na, keme seme!» ");
INSERT INTO mif_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mahura ŋga *Jəwif hay makustakaya heyey tabiya, a sləkɗam, a handamara Yesu fa mey ŋga Bay Pilat. ");
INSERT INTO mif_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Feteɗe, a zlamar ŋga mbərzlafamar, a ləvam: «Ya hətfamar ndaw keɗe fa nəsa hwayak ala, fa həldata ndəhay ŋga vəldamara budaw a bay Rawma ba! A ləvey aŋga *Kəriste, bay mahura.» ");
INSERT INTO mif_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat aa cəfɗa Yesu, a ləvar: «Kah na, bay ŋga Jəwif hay fara daw?» Yesu a mbəɗdara, a ləvar: «Anda kah ma ləvey.» ");
INSERT INTO mif_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilat aa guzltar a *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay leŋ a ndəhay makustakaya feteɗe, a ləvtar: «Ya ta hətey mebərey fa ndaw keɗe təɗe ŋga kərza daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ama ndəhay a, a mbərzlam cəŋga, a ləvam: «Fa caradata ndəhay daa hwayak ŋga ndəhay Jəwif hay tabiya ŋga key cek maaya ba ta fa mewuzey mey aŋga hay mekele mekele. A zlarawa da *Galile, haa a wuswa feɗe.» ");
INSERT INTO mif_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ama masa Pilat ma cənda Yesu a sawa da *Galile na, ta’, aa cəfɗata ndəhay da cakay a, a ləvtar: «Ndaw keɗe ara ndaw Galile fara daw?» ");
INSERT INTO mif_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Masa Pilat ma cənda Yesu a sawa da Galile, hwayak masa *Herawt ma wa na, ta’, a slərdara a Bay Herawt, maja daa ɗar a ŋgene Bay Herawt a, aŋga da *Jeruzelem feteɗe may. ");
INSERT INTO mif_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Masa Bay Herawt a ma hətar Yesu na, aa səmey ga maja dəga zleezle, aŋga fa wuɗey ŋga hətar, maja aŋga fa cəney mey da ray a. A wulkey daa mevel aŋga na, da Yesu a key maazla meedey aŋga la kwa. ");
INSERT INTO mif_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Bay Herawt a, aa cəfɗafar mey hay mekele mekele, ama kwa Yesu a mbəɗdara ba. ");
INSERT INTO mif_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","*Bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, ta *ndəhay maa sərkada kwakwas ŋga Mawiz ata feteɗe. A dadəɗfamar mey masa maadakw a. ");
INSERT INTO mif_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bay Herawt a, ta sewje aŋga hay aa saŋgərfamar, a cəɗmara. Ta’, a pamar zana maaya membey fa vaw, a vəhdamara fa Bay Pilat saya. ");
INSERT INTO mif_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Daa ba na, ata Bay Herawt ta Bay Pilat a cəmam ba, ama mezley dəga ta pas ŋgene ata jam. ");
INSERT INTO mif_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Masa Bay *Herawt ma vəhda Yesu sem fa Pilat saya na, ta’, Pilat a kusta *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, ta mahura hay ŋga *Jəwif hay, leŋ zagaba, ");
INSERT INTO mif_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a ləvtar: «Akwar ta handamərwa ndaw keɗe la fa yah, ka ləvam fa nəsa hwayak ala. Ama ya taa cəfɗa la meedey akwar, kwa ya ta hətey mebərey anda akwar ma ləvam na, daa ba. ");
INSERT INTO mif_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Bay Herawt may, ta hətey mebərey a daa ba kəne. Ta’, a vəhdərwa fa aləkwa cəŋga. Fara fara ndaw keɗe ta key mebərey təɗe ŋgaa zəɗey heter aŋga na, daa ba. ");
INSERT INTO mif_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yaw, ya sləɗa gway na, ya mbəkda.»  ");
INSERT INTO mif_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Fa mevey a, fa mevey a, gweegwe gwagway ŋga *Pak na, Pilat a pəskatar ndaw pal daa fərsəne ŋgada ndəhay daa hwayak a. ");
INSERT INTO mif_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ama ndəhay tabiya feteɗe a zlamar mewudey ta gədaŋ, a ləvam: «Kəɗndara ndaw keɗe vagay! Pəskandar Barabas!» ");
INSERT INTO mif_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","A kəzlamara Barabas aa fərsəne na, maja aŋga ma həldata ndəhay ŋga kam baazlam a ray bay ŋga berney a ta aŋga ma kəɗey ndaw vagay. ");
INSERT INTO mif_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat ta’, aa guzltar ŋgada zagaba saya maja a wuɗey ŋga mbəkda Yesu. ");
INSERT INTO mif_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ama ndəhay a, a wudam ta gədaŋ, a ləvam: «Dəra fa hwadam mazlaŋgalakaya! Dəra fa hwadam mazlaŋgalakaya!» ");
INSERT INTO mif_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilat ta’, aa guzley ŋga dey maakar, a ləvtar: «Cek maaya ba masa aŋga ma key na, wura? Maja kwa ya ta hətey mebərey fa aŋga təɗe ŋgaa zəɗey mesəfney aŋga na, daa ba. Ya da sləɗa gway na, ya mbəkda.» ");
INSERT INTO mif_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ama a wudam ta gədaŋ, aa cəfɗamara, a ləvam: «Ya wuɗam Yesu na, ka dəra fa hwadam mazlaŋgalakaya.» Mewudey ata ha a fənar ray a Pilat. ");
INSERT INTO mif_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ta’, a təɓa ŋga key anda ata maa cəfɗamara. ");
INSERT INTO mif_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A pəskatara ndaw masa ata ma wuɗam ŋga pəskey heyey. Ndaw a na, a kəzlamara aa fərsəne, maja aŋga ma həldata ndəhay ŋga key baazlam a ray bay ŋga berney a ta aŋga ma kəɗey ndaw vagay heyey. Ta’, a vəldatara Yesu amba a kamar cek anda ata ma wuɗam. ");
INSERT INTO mif_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Daa masa fa handamara Yesu ŋga dərey na, a cadamara ray ta *Simaŋw, ndaw da Siren fa sawa da ley. Sewje hay kaw! a kərzamara Simaŋw a, a pamara hwadam mazlaŋgalakaya heyey a ray aŋga, a handa fa dəɓa ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ndəhay ga fa diyam asiya, asaya, ŋgusay fa diyam asiya ta matəway. ");
INSERT INTO mif_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ama Yesu pəla! a mbəɗwa dey fa ŋgusay a, a ləvtar: «Ŋgusay da *Jeruzelem, ka təwam maja yah ba, ama təwam maja ray akwar, ta maja bəz akwar hay! ");
INSERT INTO mif_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Maja pas ŋga banay a sawa la masa ndəhay a da ləvam: “Meesəmey daha ŋgada ŋgusay dərlay hay, masa ta yam bəza hay daa ba, masa ta vəlam ɗəwa a bəza hay daa ba səlak!” ");
INSERT INTO mif_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ndəhay a da zlamar ŋgaa guzley ŋgada aŋgwa hay, a ləvam: “Bəzlmawa a ray ala!” ta ŋgadaa heeleŋ hay, “Pəshamandar!” ");
INSERT INTO mif_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Da fa gəɗmar awaw fa hwadam meendəɓek e ŋgaa wurey na, kaa wara hwadam makwalakaya na, a gəɗmara kəlmeɗek! daa ba daw?» ");
INSERT INTO mif_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ta’, a handamawa ndəhay mekele cew, ndəhay a, ara mayal hay, amba a kəɗmata ta ata Yesu daa slam a vagay. ");
INSERT INTO mif_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","A wusam aa slam masa ata ma zəlmara «tetesl ŋga ray.» Ta’, a dərmara Yesu aa slam aha, leŋ mayal hay cew heyey. Mayal hay a na, a dərmata fa hwadam mekele hay a cakay Yesu, pal ta har-zəmay, laŋgar ta har-gula. ");
INSERT INTO mif_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu a ləvey: «Papay, mbəkdatara mebərey ŋga ndəhay keɗe maja a sərmara cek masa ata ma kamara ba.» Ndəhay ma dərmara Yesu a, a kəɗam caca amba a wunkamara zana aŋga hay da wuzlah ata. ");
INSERT INTO mif_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ndəhay tabiya malacatakaya feteɗe, fa nəkmara cek mekey. Mahura hay ŋga *Jəwif hay aa saŋgərfamar, a ləvam: «Aŋga ta ləhey ndəhay la daa meməcey. Da masa aŋga *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay na, ŋga ləhda ray aŋga taw!» ");
INSERT INTO mif_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sewje hay, aa saŋgərfamar may. A ŋgəcham a cakay a, a vəlmar wuzam maakwiyaŋ a, a ləvmar: ");
INSERT INTO mif_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Da kah, bay ŋga Jəwif hay na, ləhda ray akah, ta har akah taw!» ");
INSERT INTO mif_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A wuzlalam mey, a sləpmara fa hwadam masa ata mazlaŋgalamara fa vəɗa heyey, a ləvam: «Ndaw keɗe, ara bay ŋga Jəwif hay.» ");
INSERT INTO mif_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ndaw pal da wuzlah mayal hay cew madərtakaya da cakay Yesu heyey na, a cəɗa Yesu, a ləvey: «Kah na, Kəriste, ba diya? Ləhda ray akah dəɓa taw, amba ka ləhdandar may!» ");
INSERT INTO mif_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ama ndaw-mayal laŋgar a kar mey, a ləvar: «Kah madərkaya anda aŋga. Ka zlurey ta Gazlavay ba daw? ");
INSERT INTO mif_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aləkwa na, sariya aləkwa təɗe fa sləra aləkwa maaya ba. Ama aŋga na, kwa ta key mebərey daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ta’, aa guzley saya, a ləvey: «Yesu, pas masa kah ma da vəhwa ŋga zəma bay akah na, sərfadaya may.» ");
INSERT INTO mif_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu a mbəɗdara, a ləvar: «Ya fa ləvka fara fara, mezley dəga tasana, ya da njakwa cew e daa slam maaya da vaɗ.» ");
INSERT INTO mif_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ta pas ŋgene, mamba wuzlah-pas na, pas sərat! a sərtey. Ləvaŋ a key daa hwayak tabiya haa ɓərey maakar ŋgaa kwaɗ. Daa *Way ŋga Gazlavay zana ma gərca *Slam masa Gazlavay aa da hwaɗ a na, a ŋgərey pəɗak! cew da wuzlah. ");
INSERT INTO mif_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu a wudey ta gədaŋ, a ləvey: «Papay, ya mbəkdakawa mesəfney aɗaw a har akah.» Masa aŋga maa guzley la anda keɗe na, pam! a məcey. ");
INSERT INTO mif_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mahura ŋga sewje hay ŋga Rawma hay, ma hətar cek aha ma key anda ŋgene na, a həlma Gazlavay, a ləvey: «Fara fara ndaw keɗe, ara ndaw maaya!» ");
INSERT INTO mif_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ndəhay tabiya makustakaya feteɗe ŋga nəkey dey fa cek ma key daa slam aha na, ta hətmar cek aha la, ata tabiya a vəhmawa a way ata hay ta mekəɗey rav. ");
INSERT INTO mif_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jam ŋga Yesu hay tabiya, ta ŋgusay ma samawa asiya dəga da *Galile, malacatakaya dəreŋ, fa nəkam dey fa cek ma key tabiya. ");
INSERT INTO mif_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ndaw daha mezəley *Jawzef. Ara ndaw da slala Arimate daa hwayak ŋga *Jəwif hay. Ndaw aha aa maaya fa mey ŋga Gazlavay. Fa səkwa mewey ŋga Bay Gazlavay. Ara ndaw da wuzlah ndəhay mahura hay ma sla yawa ŋga Jəwif hay. Ama ta pas masa ndəhay a ma kamar sariya a Yesu amba a kəɗmara vagay na, Jawzef e, ta təɓa mewulkey ata daa ba, ta təɓa sləra ata masa ata ma kamara na, daa ba. ");
INSERT INTO mif_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Masa Yesu ma məcey la na, Jawzef e a daw fa Bay Pilat, aa cəfɗarawa ŋga vəldara vagay ŋga Yesu amba a jəha. Ta’, Bay Pilat a vəlar cəveɗ ŋga jəha. ");
INSERT INTO mif_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Anda keɗe, Jawzef e, a padərwa salay ta vagay a fa hwadam mazlaŋgalakaya heyey. A mbəza ta maslaga, a handa aa cəvay maavərkwakaya daa pəraɗ. Cəvay a ŋgene, kwa ta pam vagay mekele a hwaɗ a daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ta pas ŋgene na, luma ŋga Gajava. Gweegwe pas a kəzley amba *pas meməskey-vaw a zley. ");
INSERT INTO mif_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ŋgusay masa ma ləgdamərwa Yesu dəga da *Galile heyey, ta’, a diyam bama ta ata Jawzef heyey. A wuzaɗam dey aa cəvay a, a nəkmara a pamara vagay ŋga Yesu na, kwara. ");
INSERT INTO mif_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Fa dəɓa ha, a vəham a way ata hay, a wam vaw ta cek hay mezey maaya leŋ mal ŋga tekweɗey fa vagay ŋga Yesu. Ta pas meməskey-vaw, ŋgusay a, a məskam vaw anda *kwakwas ŋga Mawiz ma ləvey. ");
INSERT INTO mif_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Fa dəɓa ŋga *pas meməskey-vaw, pərek pərek ta pas luma ŋga Gudal, ŋgusay ma wam vaw ta cek hay mezey maaya heyey a lamata cek hay a, a diyam a mey cəvay ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","A hətfamar beeler mahura da mey cəvay a, magədbalakaya ta cakay. ");
INSERT INTO mif_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","A mbəzam aa cəvay a, ama ta hətfamar vagay ŋga Bay Mahura Yesu daa ba. ");
INSERT INTO mif_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Daa ŋgene, ray ata a həɓey. Ta’, ndəhay cew daha a wuzmatar vaw. Zana ŋga ndəhay a, a waɗam mabara ndəɗ-ndeɗ. ");
INSERT INTO mif_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ŋgusay a, mandərzay a katar, a jəkwdamara ray a hwayak. Ndəhay a, a ləvmatar: «Ka səpmara ndaw masa ta dey da wuzlah ndəhay maməctakaya na, kwara? ");
INSERT INTO mif_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Aŋga feɗe daa saba, ta sləkɗawa sem daa meməcey. Sərfadamara mey masa aŋga maa guzldakwara da *Galile heyey, a ləvkwar: ");
INSERT INTO mif_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Si a vəldamaya, yah, *Bəz ŋga Ndaw, a har ndəhay ta mebərey amba a dərmaya fa hwadam mazlaŋgalakaya. Ŋga ɗar maakar a, ya sləkɗawa daa meməcey.”» ");
INSERT INTO mif_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Da ray ŋgene, a sərfadamara mey ŋga Yesu maa guzltar heyey. ");
INSERT INTO mif_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ta’, a sləkɗam da mey cəvay a, a diyam, a kadamatara cek hay ma kam tabiya a *gula hay ŋga Yesu kuraw a ray a letek, leŋ ŋgada gula aŋga hay siya. ");
INSERT INTO mif_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ŋgusay a na, ara ata *Mari da Magdala, Zaan, leŋ Mari mamaŋ ŋga *Jak ta ŋgusay mekele ma ləgdamata. Ara ata ma wuzdamara mey a, a ndəhay meslərey ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama ndəhay meslərey ŋga Yesu a, a wulkam mey masa ŋgusay ma kadamara keɗe na, ara mey saw kəne. A təɓmara ba. ");
INSERT INTO mif_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ta ŋgene he cəpa, *Piyer pərta! a lecey, a hway a mey cəvay a cəŋga. A wusey, ta’, a gəɓey, a wuzeɗey dey aa cəvay a, ama kwa ta hətey cek mekele daa ba, si maslaga. Ta’, a vəhwa a way aŋga, ray a həɓar da ray cek masa aa ma hətərwa. ");
INSERT INTO mif_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ta pas a ŋgene masa Yesu ma sləkɗawa daa meməcey na, gula aŋga hay cew fa diyam ŋgada slala mezəley Emayus. Slala ha na, a key kəlemeeter kuraw a ray a letek ta *Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ata faa guzlam da ray cek masa ma key cəpa daa ɗar hay a ŋgene. ");
INSERT INTO mif_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Masa ata faa guzlam, fa kam yawa da wuzlah ata na, Yesu a kərzata daa cəveɗ, ta’, a diyam bama. ");
INSERT INTO mif_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ata fa hətmar maaya maaya, ama cek ma təkta ŋga sərmara ara Yesu na, daha. ");
INSERT INTO mif_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Vaw ata tabiya maməckaya. Yesu aa cəfɗata, a ləvtar: «Masa akwar fa samawa keɗe na, ka kam maɗay na, da ray me?» Ta’, a lacam. ");
INSERT INTO mif_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ndaw dasi ata pal, mezəley Kəliyawpas, a ləvar: «Ndaw aɗaw, kah, ndaw-məlak da Jeruzelem keɗe daw? Ka ta cənda mey masa ma key daa ɗar hay a keɗe daa ba daw?» ");
INSERT INTO mif_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ta’, aa cəfɗata, a ləvtar: «Mekey ara mey a?» A mbəɗdamara, a ləvmar: «Mey ma key da ray Yesu, ndaw Nezeret. Ara *ndaw ma təla mey ŋga Gazlavay mahura. Aŋga ta gədaŋ daa sləra aŋga, daa meeguzley maaya fa mey ŋga Gazlavay leŋ fa mey ŋga ndəhay tabiya. ");
INSERT INTO mif_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ama *bay-ray hay ŋga ndəhay aləkwa hay ma ka kwakwas ŋga Gazlavay leŋ mahura aləkwa hay ta handamara la fa Rawma hay, a kamar sariya, a dərmara fa hwadam mazlaŋgalakaya ŋga məcey. ");
INSERT INTO mif_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ala na, ya wulkam ara aŋga ma da ləhdandakwar aləkwa *Israyel hay daa banay. Ama ta ŋgene he cəpa, tasana kaa ɗar maakar aŋga ma məcey . ");
INSERT INTO mif_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Ŋgusay da wuzlah ala hay daha, ŋga fene taa pərek, ta diyam la a mey cəvay aŋga, ama ta hətmərwa vagay aŋga daa ba. A vəhmawa, a ləvmandar: “Maslaŋ hay ŋga Gazlavay da vaɗ a wuzmandar vaw, a ləvmandar: Yesu ta sləkɗawa sem daa meməcey, aŋga ta dey.” Mey ŋga ŋgusay a ma cəndamərwa keɗe na, a həɓndar ray. ");
INSERT INTO mif_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ndəhay da wuzlah ala siya ta diyam la a mey cəvay a may. A hətmərwa cek aha anda ŋgusay ma kadamandara heyey. Ama Yesu na, ta hətmərwa daa ba.» ");
INSERT INTO mif_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Da ray ŋgene, Yesu a ləvtar: «Haya, akwar ndəhay manjar leŋgesl. Akwar ndəhay ma wusam vaw ŋga təɓa mey ŋga ndəhay ma təla mey ŋga Gazlavay ma wuzdamara zleezle tabiya ba. ");
INSERT INTO mif_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Si *Kəriste a sərey banay la ɗagay, fa dəɓa ha, a daw a vaɗ a njey aa slam aŋga meweɗey na, ka sərmara ba daw?» ");
INSERT INTO mif_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ta’, Yesu a wuzdatara mey masa maa guzley da ray a daa ɗerewel ŋga Gazlavay tabiya. A zlar ma wuzdatara ta fa ɗerewel hay ŋga *Mawiz, fa dəɓa ha, a wuzdatara mey daa ɗerewel hay ŋga ndəhay ma təla mey ŋga Gazlavay tabiya. ");
INSERT INTO mif_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Masa ata ma wusam gweegwe ta slala masa gula aŋga hay cew ma wuɗam ŋga daw a hwaɗ a heyey na, Yesu a key anda a mbəkdata, a daw fa mey. ");
INSERT INTO mif_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ama a kamar ambahw, a ləvmar: «Njakwa feɗe bama maja pas fa da kəzley, gweegwe tavaɗ cay.» Aŋga ta’, a vəhwa, a diyam, a mbəzam aa way. ");
INSERT INTO mif_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Fa dəɓa ha, a njam bama ŋga zəmey ɗaf. Yesu leŋ! a ley peŋ, a kar suse a Gazlavay, ta’, a wunka, a vəldatara. ");
INSERT INTO mif_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Cek ma təkta ŋga sərmara heyey na, daa saba, a sərmara ara Yesu dəɓa. Ama wure wure ŋgene, a hətmar da cakay ata ha saba. ");
INSERT INTO mif_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Da ray ŋgene, aa guzlam da wuzlah ata, a ləvam: «Daa masa aləkwa daa cəveɗ, aŋga fa wuzdandakwara mey daa ɗerewel ŋga Gazlavay heyey na, mevel aləkwa fa kəsley anda lanja, ba diya?» ");
INSERT INTO mif_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wure ŋgene, a sləkɗam a vəham a Jeruzelem. A hətfamatar *gula hay ŋga Yesu kuraw a ray a letek heyey makustakaya ta ndəhay ata hay. ");
INSERT INTO mif_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ndəhay makustakaya heyey aa guzlmatar a gula hay cew heyey teeseɗ, a ləvmatar: «Fara fara Bay Mahura ta sləkɗawa sem daa meməcey! Ta wuzar vaw la a *Simaŋw!» ");
INSERT INTO mif_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Gula hay cew heyey ta’, a kadamatara cek tabiya masa ma key daa cəveɗ ŋga Emayus heyey, asaya, a wuzdamatara a sərmara ara Yesu na, daa masa aŋga fa wunka peŋ. ");
INSERT INTO mif_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ama gula hay cew heyey, ta ndəvdamara ŋgaa guzley daa ba araŋ na, Yesu a daw a wuzlah ata, a ləvtar: «Anja Gazlavay ŋga njadakwar daa zazay.» ");
INSERT INTO mif_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mandərzay a katar, a zluram, aa wasam maja a wulkam ara mamayam. ");
INSERT INTO mif_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ama Yesu a ləvtar: «Ka zluram na, maja me? Akwar ta mewulkey cew cew, maja me? ");
INSERT INTO mif_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nəkmata har aɗaw hay, ta salay aɗaw hay. Fara fara ara yah! Tatəmamaya, nəkmaya maaya maaya amba ka sərmara fara fara ara yah. Maja mamayam na, aŋga ta aslaw ŋga vaw ta tetesl anda akwar ma hətmaya keɗe na, daa ba, ba diya?» ");
INSERT INTO mif_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Daa masa aŋga faa guzltar anda keɗe na, a wuzdatara har aŋga hay, ta salay aŋga hay. ");
INSERT INTO mif_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","A təɓmara mey a, maaya maaya ba araŋ maja ata daa meesəmey ga. Ray ata fa həɓey, Yesu ta’, aa cəfɗata, a ləvtar: «Cek mezəmey da har akwar feɗe daha daw?» ");
INSERT INTO mif_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ta’, a vəlmar ewet mafəkakaya. ");
INSERT INTO mif_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Leŋ! a la, ta’, a zəma fa mey ata. ");
INSERT INTO mif_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Fa dəɓa ha, a ləvtar: «Daa masa aləkwa bama heyey na, ya ta ləvkwar la, mey tabiya masa mawuzlalakaya daa ɗerewel ŋga *kwakwas ŋga Mawiz, ta daa ɗerewel ŋga ndəhay ma təla mey ŋga Gazlavay, leŋ daa *Pəsam hay na, si mey a tabiya, a key cəma.» ");
INSERT INTO mif_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ta’, a wurtara leŋgesl, amba a sərmara mabara ŋga mey daa ɗerewel ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Fa dəɓa ha, a ləvtar: «Mawuzlalakaya zleezle, a ləvey: “Si *Kəriste a sərey banay, a məcey, ŋga ɗar maakar a, a sləkɗawa daa meməcey. ");
INSERT INTO mif_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Si a wuzdamara mey da ray membəɗey menjey, ta da ray membəkey mebərey, ŋgada ndəhay da bəla tabiya ta mezəley ŋga Kəriste. A da zlamara da *Jeruzelem.” ");
INSERT INTO mif_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ara akwar ma da wuzdamatara cek hay masa akwar ma hətmatar keɗe a ndəhay. ");
INSERT INTO mif_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yah, ya da slərdakwara Mesəfney masa Papay ma ləvey a da vəldakwara heyey. Ama si ka njam daa berney ŋga Jeruzelem ɗagay, kasl pas masa Gazlavay ma da vəlkwar gədaŋ ma sawa da vaɗ.» ");
INSERT INTO mif_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Fa dəɓa ha, Yesu ta’, a badata gula aŋga hay daa berney a, a diyam gweegwe ta Betani. Feteɗe, ta’, a baŋgaɗa har, a pəstar mey. ");
INSERT INTO mif_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Daa masa aa fa pəstar mey na, ta’, a mbəkdata, Bay Gazlavay a la a vaɗ. ");
INSERT INTO mif_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Gula aŋga hay a, a ragadam ŋga həlmamara. Ta’, a vəhmawa a *Jeruzelem ta meesəmey ga. ");
INSERT INTO mif_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mandaw mandaw ata daa *Way-mekey-kwakwas ŋga Gazlavay, fa həlmamara Gazlavay. ");
INSERT INTO mif_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Masa *Gazlavay ta ləma bəla daa ba araŋ na, ndaw ma zəlmara Mey ŋga Gazlavay aa daha cay. Mey a manjakaya ta Gazlavay . Mey a na, ara Gazlavay a ray aŋga. ");
INSERT INTO mif_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Masa Gazlavay ta zlar ŋga ləmtərwa cek hay tabiya daa ba araŋ na, Mey a manjakaya ta Gazlavay. ");
INSERT INTO mif_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gazlavay a katərwa cek hay tabiya ta fa ndaw aha. Kwa Gazlavay ta key cek manjar aŋga na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ara aŋga ma vəltar heter a cek hay tabiya. Aŋga fa waɗatar dey a ndəhay amba a njam aa slam-meweɗey, a sərmara cek masa fara fara. ");
INSERT INTO mif_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Aŋga na, slam-meweɗey, aŋga fa weɗey daa ləvaŋ. Ləvaŋ a, ta gwa ŋga sərta daa ba səlak. ");
INSERT INTO mif_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Zleezle, ndaw daha mezəley *Jaŋ . Gazlavay ta slərdərwa la fa ndəhay. ");
INSERT INTO mif_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","A sawa ŋga wuzdatara a ndəhay mey da ray slam-meweɗey a, amba kwa waawa a təɓa mey aŋga da ray slam-meweɗey a. ");
INSERT INTO mif_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Fara fara, Jaŋ na, ara slam-meweɗey a ba. Ama a sawa na, amba a wuzey mey da ray a gway. ");
INSERT INTO mif_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ndaw ma zəlmara Mey ŋga Gazlavay heyey na, ara slam-meweɗey fara fara. Masa aŋga ma sawa a bəla na, a waɗatar dey ŋga ndəhay tabiya. ");
INSERT INTO mif_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ndaw ma zəlmara Mey heyey ta sawa la a bəla. Gazlavay a ləma bəla na, ta fa aŋga. Ama ndəhay da bəla ta sərmara ara aŋga na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aŋga ta sawa la aa hwayak aŋga, ama ndəhay daa hwayak aŋga ha ta təɓmara daa ba. ");
INSERT INTO mif_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama ŋgada ndəhay ma təɓmara ta masa ma pamara ŋga ndaw ata fara fara na, ta vəltar gədaŋ la ŋga tərey bəza hay ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","A təram bəza hay ŋga Gazlavay na, anda bəzey ma yawa da hwaɗ ŋgwas ba, asaya, anda mewulkey ŋga ndaw-magədaŋ ma wuɗey ŋga yey bəzey ba. Ama a təram bəza hay ŋga Gazlavay na, maja ara Gazlavay a, ray aŋga ma wuɗey amba a təram bəz aŋga hay. ");
INSERT INTO mif_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yaw, Mey aha, ta tərey la ŋga ndaw-magədaŋ, ndaw a ta njey la da wuzlah ala. Maaya aŋga a ndəvey ba, ta wuzdərwa mey masa fara fara la da ray Gazlavay. Ala ta hətmar gədaŋ aŋga la. Gədaŋ a na, ara gədaŋ ŋga Bəzey-menduleŋ masa Papaha ma vəldara. ");
INSERT INTO mif_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Daa masa Jaŋ ma hətar na, a wuzey mey da ray a saya, a wudey ta gədaŋ, a ləvey: «Keɗe ara ndaw masa yah maa guzley zleezle da ray a heyey, ya ləvey: “Ndaw a sawa la fa dəɓa aɗaw. Aŋga na, a fənya ta gədaŋ, maja daa masa ya ta yawa daa ba araŋ na, ndaw aha aa daha cay.”» ");
INSERT INTO mif_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ndaw aha, aa maaya kalah. Maaya aŋga a ndəvey ba. Maaya aŋga ha aa da ray aləkwa tabiya. Maja ŋgene, aa fa pəsndakwar mey kalah ma fəna ma fəna. ");
INSERT INTO mif_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gazlavay a vəldandakwara *mewey aŋga na, ta har *Mawiz. Ama maaya aŋga ta mey masa fara fara da ray a na, a sawa ta fa *Yesu *Kəriste. ");
INSERT INTO mif_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kwa ndaw pal ta hətar Gazlavay ta dey aŋga daa ba səlak. Ama Bəzey-menduleŋ masa aa letek ta Gazlavay, manjakaya ta Papaha Bay Gazlavay na, ta wuzdandakwara Gazlavay a la. ");
INSERT INTO mif_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Pas pal daha, mahura hay ŋga *Jəwif hay da *Jeruzelem a sləram ndəhay ma ka kwakwas ŋga Gazlavay ta ndəhay *Levi hay ta fa Jaŋ. A sləram ŋgaa cəfɗamərwa, aŋga na, wa? Jaŋ ta ɓey mey ta ɓey daa ba. Ta zlurey ŋga mbəɗdatara daa ba, a wuzdatara, a ləvtar: «Kəriste, ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay na, ara yah ba.» ");
INSERT INTO mif_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aa cəfɗamara saya, a ləvmar: «Kaa kah na, wa? Kah na, *Eli daw?» A mbəɗdatara, a ləvtar: «Kay! yah na, Eli ba.» Aa cəfɗamara saya, a ləvmar: «Kah na, *ndaw ma təla mey ŋga Gazlavay masa ala fa səkwmara heyey daw?» Jaŋ a mbəɗdatara, a ləvtar: «Kay! yah na, ndaw a ba.» ");
INSERT INTO mif_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ta’, aa cəfɗamara saya, a ləvmar: «Kaa kah na, wa dəɓa wa? Wuzdandara amba ya diyam, ya kadamatara ŋgada ndəhay ma slərdamandərwa. Ka pada ray akah na, ŋga wa?» ");
INSERT INTO mif_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","*Jaŋ a mbəɗdatara, a ləvtar: «Yah na, “ndaw ma wudey da wuzlah-ley, ma ləvey: Bay aləkwa mahura fa sawa, ɗiymara cəveɗ aŋga dər e.” Mey a keɗe na, ara anda Izay, ndaw ma təla mey ŋga Gazlavay maa guzley zleezle da ray aɗaw.» ");
INSERT INTO mif_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Da wuzlah ndəhay ma slərdamata fa Jaŋ heyey na, *Fariza hay daha may. ");
INSERT INTO mif_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Aa cəfɗamara, a ləvmar: «Da kah, *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay ba, da kah, Eli ba, asaya, da kah ndaw ma təla mey ŋga Gazlavay heyey ba na, kaa ka katar *baptem a ndəhay na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jaŋ a mbəɗdatara, a ləvtar: «Yah na, ya kakwar baptem ta yam, ama ndaw da wuzlah akwar daha, masa ka sərmara ba. ");
INSERT INTO mif_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aŋga na, a da sawa fa dəɓa aɗaw, kwa ya fa da wusa ŋga pəska zeweɗ ŋga tarak aŋga daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mey a keɗe tabiya, a key da slala Betani masa da dey laŋgar ŋga dəhwa ŋga Jurdeŋ, slam masa Jaŋ ma katar baptem a ndəhay da hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pepərek e, *Jaŋ a hətar Yesu fa sawa ŋgada fa vəɗa, ta’, aa guzley, a ləvey: «Nəkmara, Bəz-təɓaŋ ŋga Gazlavay , ma da la mebərey ŋga ndəhay da bəla. ");
INSERT INTO mif_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ara ndaw masa yah maa guzley zleezle da ray a heyey, ya ləvey: “Ndaw a sawa la fa dəɓa aɗaw. Aŋga na, a fənya ta gədaŋ, maja daa masa ya ta yawa daa ba araŋ na, ndaw aha aa daha cay.” ");
INSERT INTO mif_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Zleezle na, yah ta ray aɗaw, ya səra ara wa ba. Ama ya sawa ŋga wuzdatara ndaw aha a *Israyel hay ta *baptem masa yah ma ka ta yam.» ");
INSERT INTO mif_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jaŋ a wuzey mey da ray ndaw aha, a ləvey: «Yah ma hətar *Mesəfney ŋga Gazlavay la ta dey aɗaw fa pawa salay da gazlavay da vaɗ anda makurgwadakw, a njey a ray a. ");
INSERT INTO mif_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Daa masa yah ma hətar na, kwa ya ta səra daa ba araŋ, ama Bay Gazlavay ma slərdiwa ŋga katar baptem a ndəhay ta yam ta wuzdiwa la, a ləvya: “Ndaw masa kah ma da hətar Mesəfney aɗaw ma da pawa salay a ray a na, ara aŋga ma da katar baptem a ndəhay ta Mesəfney aɗaw.” ");
INSERT INTO mif_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Fara fara, yah, Jaŋ, ya ta hətar la ta dey aɗaw. Ya gwa ŋga key sede da ray a, ya ləvey ndaw aha ara Bəzey ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pepərek e, ata *Jaŋ-Baptis ta gula aŋga hay cew, ata daa slam mekey *baptem heyey saya. ");
INSERT INTO mif_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Masa *Jaŋ ma hətar Yesu fa daw na, a ləvtar: «Nəkmara, kataɗay na, *Bəz-təɓaŋ ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Gula hay ŋga Jaŋ heyey a cəndamara mey a na, ta’, a diyam asi Yesu. ");
INSERT INTO mif_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu a mbəɗey dey fa dəɓa na, a hətatar gula hay ŋga Jaŋ heyey fa səpmar wurzay, ta’, aa cəfɗata, a ləvtar: «Ka səpam fa yah na, me?» A mbəɗdamara, a ləvmar: «Raabi, slam akah menjey na, dama?» (Raabi na, anda meləvey ndaw maa sərkadata ndəhay.) ");
INSERT INTO mif_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","A mbəɗdatara, a ləvtar: «Samawa taw, ka hətmar la.» Da ray ŋgene, a diyam, a sərmara slam aŋga menjey heyey, a njam bama feteɗe haa pas a kəzley. (Daa masa ata ma cam ray ta Yesu na, gweegwe pas ŋgaa kwaɗ.) ");
INSERT INTO mif_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ndaw pal dasi ndəhay cew masa ma cəndamara mey ŋga Jaŋ-Baptis ma diyam asi Yesu heyey na, ara *Andəre, məlmaŋ ŋga *Simaŋw *Piyer. ");
INSERT INTO mif_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ata ma mbəkdamara Yesu la na, Andəre a cam ray teeseɗ na, ta məlmaha Simaŋw. A ləvar: «Ya ta hətmar *Kəriste la.» (Kəriste anda meləvey *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay.) ");
INSERT INTO mif_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ta’, a handa Simaŋw fa Yesu. Yesu a nəka Simaŋw na, ta’, a ləvar: «Kah na, Simaŋw, bəzey ŋga Jaŋ, ama dəga wure keɗe, a da zəlmaka Sefas.» (Yaw, Sefas na, a wuɗey ŋga ləvey «Pəraɗ» .) ");
INSERT INTO mif_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pepərek e, Yesu a wuɗey ŋga daw aa hwayak ŋga *Galile. A daw a hətfar *Fəlep, ta’, a ləvar: «Sawa, səpya.» ");
INSERT INTO mif_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Fəlep ara ndaw daa berney ŋga Betsayda, berney masa ata *Andəre ta *Piyer ma njam da hwaɗ a.) ");
INSERT INTO mif_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fa dəɓa ha, Fəlep a cam ray ta Nataniyel, a ləvar: «Sərfada zleezle na, *Mawiz ta wuzleley la daa ɗerewel ŋga kwakwas aŋga da ray ndaw ma da sawa, ba diya? Asaya, ndəhay ma təla mey ŋga Gazlavay ta wuzlalam la da ray a may, ba diya? Ala ta hətmar ndaw aha la. Ara Yesu, bəzey ŋga *Jawzef. Ndaw aha, a sawa da *Nezeret.» ");
INSERT INTO mif_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyel a mbəɗdara, a ləvar: «Cek maaya a gwa a bawa da Nezeret may daw?» Fəlep a mbəɗdara, a ləvar: «Sawa taw, ka hətar la.» ");
INSERT INTO mif_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Masa Yesu ma hətar Nataniyel fa sawa fa vəɗa na, aa guzley da ray a, a ləvey: «Nəka, ndaw keɗe na, ara ndaw *Israyel fara fara. Mevel aŋga maaya, a mbərzley ba.» ");
INSERT INTO mif_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyel aa cəfɗa, a ləvar: «Ka sərya fa me?» Yesu a mbəɗdara, a ləvar: «Dəga Fəlep ta zəlkawa daa ba araŋ na, ya ta hətka sem dasi wudez.» ");
INSERT INTO mif_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyel a mbəɗdara dəɓa, a ləvar: «Bay aɗaw, kah na, Bəzey ŋga Gazlavay, kah bay ŋga Israyel hay!» ");
INSERT INTO mif_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu a mbəɗdara, a ləvar: «Ka təɓa mey aɗaw maja yah ma ləvka yah ma hətka la dasi wudez heyey daw? Yaw, ka hətey maazla hay ma fəna ŋgene la saya.» ");
INSERT INTO mif_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ta’, Yesu aa guzley saya, a ləvey: «Ya fa ləvkwar fara fara, ka da hətmar slam da vaɗ mawurkaya. Maslaŋ hay ŋga Gazlavay fa təpam a vaɗ, fa bərŋgamawa a hwayak, maja yah, Bəz ŋga Ndaw.» ");
INSERT INTO mif_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Fa dəɓa ha ɗar cew na, gwagway ŋga meley kwakwa da Kana daa hwayak ŋga *Galile daha. Mamaŋ ŋga Yesu, aŋga feteɗe daa gwagway a. ");
INSERT INTO mif_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ta zəlmata ata Yesu ta gula aŋga hay la aa gwagway a may. ");
INSERT INTO mif_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yaw, masa gwagway a ta ndəvey daa ba araŋ na, wuzam daa saba. Mamaŋ ŋga Yesu, ta’, aa guzlar a Yesu, a ləvar: «Wuzam daa saba kaa na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu a mbəɗdara, a ləvar: «Mamay, walay aləkwa da hwaɗ a me? Pas masa yah ma da wuzda vaw aɗaw ŋgada ndəhay, yah na, wa na, ta wuswa daa ba araŋ.» ");
INSERT INTO mif_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ta’, mamaŋ ŋga Yesu aa guzltar ŋgada ma ka sləra hay daa gwagway a, a ləvtar: «Cek masa aŋga ma da ləvkwar tabiya ŋga key na, kamara.» ");
INSERT INTO mif_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Feteɗe gəzla hay daha maakwaw, gəzla pal na, a key liter temere. Ara gəzla hay masa *Jəwif hay ma pam yam a hwaɗ a ŋga pərey har ta ŋga pərey cek ata hay anda kwakwas ata ma ləvey. ");
INSERT INTO mif_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu aa guzltar ŋgada ma ka sləra hay heyey, a ləvtar: «Rəhdamata gəzla hay keɗe ta yam.» Ta’, ma ka sləra hay a, a rəhdamata pece pece. ");
INSERT INTO mif_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Fa dəɓa ha, Yesu aa guzltar, a ləvtar: «Wure keɗe kam yam a nekəɗey, handamara ŋgada bay-ray ŋga sləra ŋga gwagway a.» Ta’, a kamar, a handamar. ");
INSERT INTO mif_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bay-ray a, aa cəkda yam a, ama ta tərey sem ŋga wuzam. A səra wuzam a, a sawa ta wura ba. Ama ndəhay ma ka sləra hay heyey na, a sərmara. Bay-ray ŋga sləra ŋga gwagway a, ta’, a zələrwa zel-kwakwa ha, ");
INSERT INTO mif_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aa guzlar, a ləvar: «Kwa waawa ma key gwagway ŋga meley kwakwa na, a vəltar teeseɗ a ndəhay mazəltakaya na, wuzam mecərey kalah. Fa dəɓa ha, da masa ndəhay mazəltakaya ha ta sam wuzam la ga na, a vəltar masa ma cərey pəreh, ba diya? Ama ŋga kah na, wuzam masa ma cərey kalah na, ka ɓada haa wure keɗe daw?» ");
INSERT INTO mif_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu a ka maazla aŋga ŋgeeme keɗe na, da Kana daa hwayak ŋga Galile. Ta fa maazla ha keɗe a wuzdərwa gədaŋ aŋga. Da ray ŋgene, gula aŋga hay a pamara ŋga ndaw ata fara fara. ");
INSERT INTO mif_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Fa dəɓa ha, ta’, a sləkɗam, a diyam a Kapernayum ta ata mamaha, məlmaha hay, leŋ gula aŋga hay. A njamawa feteɗe ɗar nekəɗey. ");
INSERT INTO mif_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Gwagway ŋga *Jəwif hay masa ata ma zəlmara *Pak gweegwe cay. Ta’, Yesu a sləkɗey, a daw a *Jeruzelem ŋga kawa gwagway a. ");
INSERT INTO mif_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Masa aŋga ma wusey la na, a mbəzey aa *Way-mekey-kwakwas ŋga Gazlavay. Feteɗe, a hətfey ndəhay ma ka filaw ŋga sla hay, ŋga təɓaŋ hay leŋ ŋga makurgwadakw hay. Asaya, a hətfey ndəhay manjatakaya daa slam ata hay membəɗey dala. ");
INSERT INTO mif_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ta’, a cəmey laza ŋga key laway, a ɓəltərwa ndəhay ma ka filaw tabiya ta təɓaŋ ata hay, leŋ sla ata hay daa Way-mekey-kwakwas ŋga Gazlavay a palah. A bəzlta taabal hay ŋga ndəhay ma mbəɗam dala heyey. Dala kwakwac! kwakwac! aa kwecey. ");
INSERT INTO mif_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aa guzltar ŋgada ndəhay ma həɗkadam makurgwadakw hay, a ləvtar: «Badamata cek hay a keɗe la tabiya feɗe! Ka da tərdamara way ŋga Papay, Bay Gazlavay, ŋga way ma ka filaw ba.» ");
INSERT INTO mif_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Daa masa *gula hay ŋga Yesu ma hətmar cek masa Yesu ma ka na, a sərfadamara mey mawuzlalakaya daa ɗerewel ŋga Gazlavay ma ləvey: «Bay Gazlavay, way akah na, ya wuɗa kalah, haa ya vəlda ray aɗaw maja way a.» ");
INSERT INTO mif_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mahura hay daa Way-mekey-kwakwas ŋga Gazlavay, aa guzlmar a Yesu, a ləvmar: «Key maazla ŋga wuzdandara kah ta cəveɗ ŋga kata cek hay a keɗe.» ");
INSERT INTO mif_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu a mbəɗdatara, a ləvtar: «Bəzlmara Way-mekey-kwakwas ŋga Gazlavay keɗe, ɗar maakar ya ləma la aa slam a.» ");
INSERT INTO mif_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ta’, ndəhay a, a mbəɗdamara, a ləvmar: «Haya! Mevey kwakwar məfaɗ a ray a maakwaw, fa ləmamara way a keɗe. Ama kah, ka ləvey ka ləma la aa slam a ɗar maakar na, kwara!» ");
INSERT INTO mif_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yaw, Yesu maa guzley da ray Way-mekey-kwakwas ŋga Gazlavay na, a key a ŋgey mey da ray ray aŋga. ");
INSERT INTO mif_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Masa Yesu ma sləkɗawa la daa meməcey na, gula aŋga hay a sərfadamara mey da ray Way-mekey-kwakwas masa Yesu maa guzlda heyey. Da ray ŋgene, a təɓmara mey daa ɗerewel ŋga Gazlavay mawuzlalakaya zleezle, asaya, a təɓmara mey masa Yesu maa guzlda. ");
INSERT INTO mif_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Masa Yesu aa da *Jeruzelem ŋga key gwagway ŋga *Pak heyey na, ta key maazla hay la feteɗe. Ndəhay ga a təɓmara mey aŋga maja ata ma hətmar maazla hay masa aa ma kata. ");
INSERT INTO mif_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ama ta ŋgene he cəpa, Yesu ta pata ŋga ndəhay aŋga hay fara fara na, daa ba, maja a səra mewulkey ŋga ndəhay a tabiya. ");
INSERT INTO mif_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Asaya, a wuɗey kwa ndaw a kadar mey da ray ndəhay ba, maja a səra cek daa mevel ŋga ndaw-magədaŋ. ");
INSERT INTO mif_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ndaw daha, mezəley Nikwedem. Ara ndaw Fariza masa da wuzlah mahura hay ŋga *Jəwif hay. ");
INSERT INTO mif_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dasi tavaɗ pal daha, ndaw aha a daw a hətfar Yesu, aa guzlar, a ləvar: «Bay aɗaw, ya sərmara ara Gazlavay ma slərdakawa ŋgaa sərkadata ndəhay. Ya sərmara, ma gwa ŋga key maazla hay anda kah ma kata keɗe na, si ndaw ma sawa ta fa Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu a mbəɗdara, a ləvar: «Ehe, ya fa ləvka fara fara, da ndaw ta yawa ŋga dey cew daa ba na, aa da wuzlah ndəhay masa Gazlavay fa wey da ray ata na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikwedem aa cəfɗa saya, a ləvar: «Ndaw ta key mahura cay na, a gwa ŋga yawa ŋga dey cew saya daw? A gwa ŋga vəhey a hwaɗ mamaha ŋga yawa ŋga dey cew daw?» ");
INSERT INTO mif_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu a mbəɗdara, a ləvar: «Fara fara, ya fa ləvka saya, da ndaw ta yawa ta fa yam, leŋ ta fa *Mesəfney ŋga Gazlavay daa ba na, aa da wuzlah ndəhay masa Gazlavay fa wey da ray ata na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ndaw ma yawa da hwaɗ ndaw-magədaŋ na, ara ndaw gway, ama ndaw ma yawa ta fa Mesəfney ŋga Gazlavay na, Mesəfney ŋga Gazlavay a, aa da ray a. ");
INSERT INTO mif_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ya ta ləvka la, si akwar ndəhay tabiya ka yamawa ŋga dey cew. Yaw, ka da rəzley da ray mey a ba. ");
INSERT INTO mif_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wulkey da ray memeɗ mekey cey. Kwa daa wura daa wura na, fa key anda aa ma wuɗey. Ka fa cənda meebərey a, ama ka səra a sawa dama ba, ka səra a daw ama ba. Ndaw ma yawa ta fa Mesəfney ŋga Gazlavay na, aa kəne may.» ");
INSERT INTO mif_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ta’, Nikwedem a mbəɗdara, a ləvar: «Cek aha a da key na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu a mbəɗdara, a ləvar: «Kah, ndaw mahura maa sərkadata ndəhay da *Israyel, ba diya? Kaa ka səra cek aha ba, kwara? ");
INSERT INTO mif_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yaw, ya fa ləvka fara fara, yaa guzlam na, da ray cek masa ala ma sərmara. Ya wuzam mey na, da ray cek masa ala ma hətmar ta dey ala. Ama akwar na, ka wuɗam ŋga təɓmara mey ala ha ba. ");
INSERT INTO mif_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nəka, da ya faa guzlkwar da ray cek hay ma kam da bəla keɗe na, ka gəmam ŋga təɓmara mey aɗaw ba. Kaa wara yaa guzlkwar da ray cek hay masa da gazlavay da vaɗ na, ka da təɓmara kwara? ");
INSERT INTO mif_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kwa ndaw pal da bəla ta təpey a gazlavay a vaɗ na, daa ba. Si yah, *Bəz ŋga Ndaw ma bərŋgawa da vaɗ a. ");
INSERT INTO mif_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Zleezle masa *Mawiz aa da wuzlah-ley na, ta vəɗey zezekw ŋga ɓərey magaza la. A jəwa fa hwadam, ta’, a baŋgaɗa a vaɗ. Yah, Bəz ŋga Ndaw, a da dərmaya fa hwadam, a da baŋgaɗamaya a vaɗ anda ŋgene may, ");
INSERT INTO mif_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","amba kwa waawa ma paya ŋga ndaw aŋga fara fara na, a hətey heter mendəvey ba.» ");
INSERT INTO mif_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yaw, Gazlavay a wuɗta ndəhay da bəla kalah, haa a slərdərwa Bəzey aŋga menduleŋ amba kwa waawa ma pa ŋga ndaw aŋga fara fara na, aa zəɗey ba, ama a hətey heter mendəvey ba. ");
INSERT INTO mif_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gazlavay a slərdərwa Bəzey aŋga a bəla na, ŋga katar sariya a ndəhay ŋgaa zəɗam ba, ama ŋga ləham daa mebərey ta fa aŋga. ");
INSERT INTO mif_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ndaw ma təɓa mey ŋga Bəzey aŋga na, Gazlavay fa da kar sariya amba aa zəɗey na, daa ba. Ama ndaw ma təɓa mey aŋga ba na, Gazlavay ta kar sariya cay la, maja aa ma pa Bəzey-menduleŋ ŋga Gazlavay ŋga ndaw aŋga fara fara ba. ");
INSERT INTO mif_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ahaw, Gazlavay ta slərdərwa Meweɗey aŋga la a bəla, ama ndəhay a wuɗam meweɗey a ba. A wuɗam na, ləvaŋ jak, maja ata fa kam cek hay malamba. Yaw, Gazlavay a da katar sariya ŋgaa zəɗdata na, maja. ");
INSERT INTO mif_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kwa waawa ma key cek malamba na, a key a rəsa meweɗey a, kwa fa da daw aa meweɗey a daa ba. A zlurey maja cek hay malamba masa aŋga ma kata ha, a da wuzmawa. ");
INSERT INTO mif_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ama ndaw masa fa key cek hay maaya na, a mbəzey aa meweɗey a la, amba ndəhay a hətmatar cek hay maaya masa aŋga ma kata na, ara cek hay masa Gazlavay ma wuɗey. ");
INSERT INTO mif_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Fa dəɓa ha, ata Yesu ta gula aŋga hay a sləkɗam da *Jeruzelem, a diyam aa slam mekele daa hwayak ŋga *Jude he, a njam feteɗe ta gula aŋga hay a, a katar *baptem a ndəhay. ");
INSERT INTO mif_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","*Jaŋ-Baptis may, fa katar baptem a ndəhay. A katar baptem a na, da Enaŋw gweegwe ta slala mezəley Salim, maja yam ga feteɗe daha. Ndəhay fa diyam fa ata, fa kamatar baptem. ");
INSERT INTO mif_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Daa ŋgene, ta kərzamara Jaŋ-Baptis aa fərsəne daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Gula hay ŋga Jaŋ-Baptis siya fa kam yawa ta ndaw *Jəwif daha da ray mepərey ta mepərey cek hay ŋga tərey maaya fa mey ŋga Gazlavay anda kwakwas ŋga Jəwif hay ma ləvey. ");
INSERT INTO mif_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Gula hay ŋga Jaŋ-Baptis heyey a diyam fa *Jaŋ a, a ləvmar: «Bay ala, ka fa sərfada ndaw masa akwar cew e da dey laŋgar ŋga wayam ŋga Jurdeŋ heyey, ba diya? Nəka, ndəhay ga fa diyam la ŋgada fa vəɗa, aa fa katar baptem kaa na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jaŋ-Baptis e, a mbəɗdatara, a ləvtar: «Ma gwa ŋga key cek anda ŋgene na, si ndaw masa Gazlavay ma vəlar gədaŋ. ");
INSERT INTO mif_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Akwar ray akwar ta cəndamara la ta sləmay akwar, yah ma ləvkwar: “Yah na, *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay ba. Ama yah na, ndaw masa Gazlavay ma slərdərwa teeseɗ da ray a ŋga ɗiyey cəveɗ aŋga.” ");
INSERT INTO mif_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Akwar fa sərmara, da ndaw a ley ŋgwas na, ŋgwas aha ara ŋgada ndaw aha. Ama gula-maŋgasl manjakaya da cakay a ŋga jəna, a cənda ɗay aŋga na, aa səmey. Ara anda keɗe, wure keɗe yah daa meesəmey masa fara fara. ");
INSERT INTO mif_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Anja sləmay ŋga ndaw aha ŋga zəley ma fəna ŋga yah.» ");
INSERT INTO mif_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ndaw ma sawa ta da gazlavay da vaɗ na, a fənta ndəhay tabiya. Ndaw masa da bəla na, ara ndaw-magədaŋ gway. Anda keɗe, aa guzley na, si da ray cek hay masa ma kam da bəla gway. Ndaw ma sawa ta da gazlavay da vaɗ na, a fənta ndəhay tabiya. ");
INSERT INTO mif_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Anda keɗe, aa guzley da ray cek masa aŋga ma hətar ta dey aŋga, ta masa aŋga ma cənda ta sləmay aŋga, ama ndəhay a təɓmara mey aŋga ha ba cəŋga. ");
INSERT INTO mif_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ndaw masa ma təɓa mey aŋga ha la na, a key a wuzdatara a ndəhay na, Gazlavay ara ndaw ma mbərzley ba fara fara. ");
INSERT INTO mif_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ndaw masa Gazlavay ma slərdərwa na, aa guzley mey hay ŋga Gazlavay, maja Gazlavay ta vəlda Mesəfney aŋga tabiya sem a ray a. ");
INSERT INTO mif_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Gazlavay Papaŋ, a wuɗa Bəzey aŋga, ta vəlar gədaŋ la amba a wey da ray cek hay cəpa. ");
INSERT INTO mif_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kwa waawa ma pa Bəzey a ŋga ndaw aŋga fara fara na, a hətey heter mendəvey ba la. Ama kwa waawa ma təɓra mey aŋga ba na, fa da hətey heter mendəvey ba daa ba. Anda keɗe, Gazlavay fa cey mevel da ray a mandaw mandaw. ");
INSERT INTO mif_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Ndəhay *Fariza hay a cəndamara na, *gula hay ŋga Yesu ga, a fəna ŋga *Jaŋ-Baptis, asaya, Yesu fa katar *baptem a ndəhay ga, a fəna Jaŋ-Baptis a. (Fara fara na, Yesu, ta ray aŋga ta key baptem kwa ŋgada ndaw pal daa ba. Ama ara gula aŋga hay ma kamara gway.) Masa Yesu ma cənda mey masa Fariza hay maa guzldamara heyey na, a sləkɗey daa hwayak ŋga *Jude, a vəhey a *Galile. ");
INSERT INTO mif_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ŋga wusey a Galile he na, si a daw ta da *Samari. ");
INSERT INTO mif_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Daa madaw aŋga ha na, a wusey aa hwayak ŋga Samari, a slala Sikar gweegwe ta ley daha. Ara ley masa *Jakwap ma vəldara zleezle ŋgada bəzey aŋga *Jawzef. ");
INSERT INTO mif_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ɓəlndaw ŋga Jakwap a feteɗe daha. Yesu a gərey ŋga madaw. Ta’, a məskey vaw da mey ɓəlndaw a. Ara gweegwe da wuzlah-pas. ");
INSERT INTO mif_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Wure ŋgene, ŋgwas Samari daha, a daw ŋga təɗkawa yam daa ɓəlndaw a. Ta’, Yesu a ləvar: «Vəlya yam ŋga sey cey.» ");
INSERT INTO mif_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Daa ŋgene, gula hay ŋga Yesu ata sem a slala ŋga həɗkawa cek mezəmey. ");
INSERT INTO mif_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ŋgwas Samari kaa, a mbəɗdara a Yesu, a ləvar: «Kah na, ndaw *Jəwif, ba diya? Kaa, kaa cəfɗey yam ŋga sey fa yah, ŋgwas Samari na, kwara?» (Ŋgwas aha aa guzley anda keɗe na, maja ndəhay Jəwif hay a zləram ta ndəhay Samari hay ba səlak.) ");
INSERT INTO mif_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu a mbəɗdara, a ləvar: «Da ka səra maaya masa Gazlavay ma ka ŋgada ndaw, asaya, da ka sərya, yah, ndaw maa cəfɗafaka yam ŋga sey keɗe na, anja ara kah ma daa cəfɗafaya yam jak. Anda keɗe, ya da vəlka yam masa ma vəley heter mendəvey ba.» ");
INSERT INTO mif_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ŋgwas a, a ləvar: «Papay aɗaw, cek metəɗkey yam fa kah daa ba, asaya, ɓəlndaw a, aa seleleŋ. Kaa ka da hətərwa yam ma vəley heter mendəvey ba ha na, dama? ");
INSERT INTO mif_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ɓəlndaw a keɗe na, ara papaŋ ŋga papa ala Jakwap ma zləɗndara. Aŋga ta bəz aŋga hay leŋ gənaw aŋga hay ta sam yam a la may. Kaa kah na, ka fəna Jakwap daw?» ");
INSERT INTO mif_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu a ləvar: «Kwa waawa ma sey yam a keɗe, yam a kar la cəŋga. ");
INSERT INTO mif_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ama ndaw ma da sey yam masa yah ma da vəldara na, kwa yam fa da kar daa saba səlak. Yam a, a da njey daa aŋga, a ndəvey ba, asaya, a da vəlar heter mendəvey ba.» ");
INSERT INTO mif_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ŋgwas a, a mbəɗdara, a ləvar: «Papay aɗaw, vəlya yam a may taw, amba yam a kaya saba, asaya, amba ya sawa ŋga təɗkey yam feɗe saba na!» ");
INSERT INTO mif_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu aa guzlar, a ləvar: «Daw, zələrwa zel akah, samawa feɗe.» ");
INSERT INTO mif_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ŋgwas a, a mbəɗdara, a ləvar: «Yah na, zel aɗaw daa ba.» Yesu a ləvar: «Kah maa guzley la, ara aŋga. Ahaw, zel akah daa ba, ");
INSERT INTO mif_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","maja ka ta ley zel hay la zlam, asaya, ndaw masa akwar cew e wure keɗe na, ara zel akah ba fara. Ka taa guzley la ara aŋga.» ");
INSERT INTO mif_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ŋgwas a, a ləvar: «Papay aɗaw, ya nəkaka keɗe na, kah, *ndaw ma təla mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Papaŋ ŋga papa ala hay a dəram daŋgay ŋgada Gazlavay na, daa aŋgwa keɗe. Ama akwar Jəwif hay, ka ləvam slam medərey-daŋgay ŋgada Gazlavay na, si da *Jeruzelem gway.» ");
INSERT INTO mif_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu a mbəɗdara, a ləvar: «Kwakwa, jəkfaya sləmay. Pas a, a wuswa la masa ndəhay a da dərmar daŋgay a Papay, Bay Gazlavay, kwa daa wura daa wura. Fa da diyam ŋga dərwa daŋgay daa aŋgwa keɗe ta da Jeruzelem daada na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Akwar Samari hay, akwar fa dəram daŋgay, ama ka sərmara ndaw masa akwar ma dərmar daŋgay a ba. Ala Jəwif hay na, ya sərmara ndaw masa ala ma dərmar daŋgay, maja ndaw ma da ləhdata ndəhay na, a bawa daa səkway ala Jəwif hay. ");
INSERT INTO mif_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pas a fa sawa, ta wuswa cay, masa ndəhay ma nam ray a Bay Gazlavay Papaŋ fara fara na, a namar ray la ta mevel pal ta fa gədaŋ ŋga Mesəfney aŋga. Bay Gazlavay Papaŋ a wuɗta ndəhay ma namar ray anda ŋgene. ");
INSERT INTO mif_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gazlavay na, ara Mesəfney, ndaw a gwa ŋga hətar ta dey ba. Anda keɗe, ndəhay ma namar ray na, si a namar ray ta mevel pal, ta fa gədaŋ ŋga Mesəfney aŋga.» ");
INSERT INTO mif_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ŋgwas a, a mbəɗdara, a ləvar: «Ya səra *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay na, a sawa la. Da masa ta sawa cay na, a wuzdandara cek hay tabiya maaya maaya la.» ");
INSERT INTO mif_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu a mbəɗdara, a ləvar: «Kəriste he na, ara yah, ndaw masa maa guzlka keɗe.» ");
INSERT INTO mif_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Daa masa Yesu faa guzlam ta ŋgwas Samari keɗe heyey na, gula aŋga hay a vəhmawa, a rəzlam ga maja aa faa guzley ta ŋgwas. Ama kwa ndaw pal taa cəfɗa ŋgwas aha: «Ka wuɗey fa ndaw a me?» na, daa ba. Asaya, kwa ndaw pal taa cəfɗa Yesu: «Kaa guzlam ta ŋgwas aha maja me?» na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ŋgwas aha, mbak! a mbəkda kwakulam aŋga da mey yam a, ta’, a vəhey a slala. A daw a ləvtar a ndəhay: ");
INSERT INTO mif_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Samawa ta nəkmara ndaw katay cey, aa guzlya da ray cek masa yah ma kata tabiya! Da ara Kəriste, ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay heyey kwa!» ");
INSERT INTO mif_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ndəhay a, a bamawa daa berney a, ta’, a diyam ŋgada fa Yesu a. ");
INSERT INTO mif_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Masa ŋgwas aha ta vəhey sem a slala heyey na, gula hay ŋga Yesu aa guzlmar a Yesu a, a ləvmar: «Bay ala, zəmey cek dəɓa.» ");
INSERT INTO mif_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yesu a mbəɗdatara, a ləvtar: «Cek aɗaw mezəmey daha masa akwar ma sərmara ba.» ");
INSERT INTO mif_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Gula aŋga hay aa cəfɗam vaw da wuzlah ata, a ləvam: «Haya! Ndaw mekele ta handar cek ŋga zəmey la daw?» ");
INSERT INTO mif_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu a mbəɗdatara saya, a ləvtar: «Cek aɗaw mezəmey na, ara mekey cek ma mbafar a ndaw ma slərdiwa, asaya, ara ŋga ndəvda sləra masa aa ma vəldiwa ŋga key. ");
INSERT INTO mif_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ka wulkam, ka ləvam: “Wure keɗe mendərey kiya məfaɗ ŋga kawa cek da ley.” Yah na, ya fa ləvkwar, nəkam dey, cek da ley ta key cay, mendərey ŋga kawa. ");
INSERT INTO mif_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ndaw ma karawa cek da ley a na, ta hətey mawurɓay ŋga sləra aŋga cay. Da ray ŋgene, ndaw ma sləka cek aha ta ndaw ma karawa cek aha da ley aa səmam daa slam a. Ara kəne may, ŋgada ndaw ma zəlwa ndəhay ŋga hətey heter mendəvey ba. ");
INSERT INTO mif_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mey a daha a ləvey: “Ndaw a sləka daw, ama ma da karawa a way na, ndaw mekele.” Mey a keɗe ara aŋga fara. ");
INSERT INTO mif_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ya ta slərdakwar la ŋga kawa cek da ley masa akwar ma həvmara ba. Ma həvmara na, ndəhay mekele, ama ara akwar ma da zəmam wiya da ray cek ata ha.» ");
INSERT INTO mif_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ndəhay Samari hay ga da slala ha, a pamara Yesu ŋga ndaw ata fara fara maja ŋgwas aha ma ləvtar: «Ndaw aha aa guzlya da ray cek hay masa yah ma kata tabiya.» ");
INSERT INTO mif_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Maja ŋgene, ata ma wusmawa fa Yesu heyey na, a kamar ambahw ŋga njey ta ata. Yesu, ta’, a njey ta ata ɗar cew, aŋga faa sərkadata. ");
INSERT INTO mif_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Masa ata ma cəndamara mey aŋga ha la na, ndəhay ga mekele saya a təɓmara mey a. ");
INSERT INTO mif_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ta’, aa guzlmar a ŋgwas a, a ləvmar: «Ya pamara ŋga ndaw ala fara fara na, ara maja kah ma ləvndar heyey daada ba, ama maja ala ma cəndamara mey aŋga ta sləmay ala. Wure keɗe, ya ta sərmara cay, fara fara ara aŋga ndaw ma da ləhdata ndəhay da bəla.» ");
INSERT INTO mif_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu ma key la ɗar cew da *Samari na, ta’, a daw aa hwayak ŋga *Galile heyey dəɓa. ");
INSERT INTO mif_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu ta ray aŋga taa guzley la, a ləvey: «*Ndaw ma təla mey ŋga Gazlavay na, ndəhay daa hwayak aŋga a rəsmara.» ");
INSERT INTO mif_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ama masa Yesu ma wusey la a Galile na, ndəhay feteɗe, a təɓmara maaya maaya, maja ata ma hətmar maazla hay masa aŋga ma kata la tabiya daa masa ata ma diyam aa gwagway ŋga *Pak da *Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu ta’, a daw a Kana saya, daa hwayak ŋga Galile he, a slala masa aa ma tərda yam ŋga wuzam heyey. Feteɗe, ndaw mahura ŋga ŋgwamna daha, bəzey aŋga vaw fa car. Bəzey a, a lawa da Kapernayum. ");
INSERT INTO mif_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Masa ndaw aha ma cənda Yesu ta sləkɗey sem da *Jude ŋgada Galile na, aŋga may, ta’, a sləkɗey a daw fa Yesu a, a kar ambahw amba a diyam cew e, ŋga mbəldərwa bəzey aŋga da Kapernayum, maja bəzey aŋga ha fa da məcey. ");
INSERT INTO mif_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu a ləvar: «Akwar siya hay, da ka ta hətam maazla hay ma rəzla ndaw daa ba na, anja akwar fa da təɓmara mey aɗaw daa ba, ba diya?» ");
INSERT INTO mif_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ndaw mahura ŋga ŋgwamna heyey a mbəɗdara, a ləvar: «Bay aɗaw, nakwa la fiyaw fiyaw maja bəzey aɗaw a fa ɓərzley.» ");
INSERT INTO mif_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu a mbəɗdara, a ləvar: «Daw a way, bəzey akah a mbəley la.» Ndaw aha, a təɓa mey ŋga Yesu heyey, ta’, a daw. ");
INSERT INTO mif_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Masa aŋga fa daw ŋgada way na, ndəhay ma ka sləra aŋga hay a cadamara ray daa cəveɗ, a ləvmar: «Bəzey akah ta mbəley cay.» ");
INSERT INTO mif_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ndaw aha aa cəfɗata, a ləvtar: «Bəzey a, a key ŋgama ha na, dəga ŋga vara?» A mbəɗdamara, a ləvmar: «A kar ŋgama, awaw fa vaw daa saba na, dəga ŋgaa kwana ta ɓərey pal ŋgaa pas.» ");
INSERT INTO mif_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Anda keɗe, ndaw aha, a səra bəzey aŋga a key ŋgama na, daa masa Yesu maa guzlar, ma ləvar: «Bəzey akah a mbəley la» heyey. Da ray ŋgene, aŋga ta ndəhay da way aŋga tabiya a pamara Yesu ŋga ndaw ata fara fara. ");
INSERT INTO mif_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Keɗe he, ara maazla ŋga dey cew e masa Yesu ma ka daa masa aŋga ma sləkɗey da Jude ŋgada Galile. ");
INSERT INTO mif_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Fa dəɓa ha, *Jəwif hay a kam gwagway da *Jeruzelem. Yesu, ta’, a daw aa gwagway a may. ");
INSERT INTO mif_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Daa berney ŋga Jeruzelem e, gweegwe ta mey-mbew mahura membəzey aa berney a, mezəley Slam-membəzey ŋga təɓaŋ hay, wurak ŋga yam daha. Wurak a na, a zəlmara ta mey *Hebəre «Betzata». Ray a mazlərkaya ta balak hay zlam. ");
INSERT INTO mif_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Dasi balak hay a na, masa-bəle hay ga manatakaya: wulaf hay daha, jegwer hay daha, maahəlɓatakaya hay daha. Ata manjatakaya fa səkwmara amba yam a wusey, ");
INSERT INTO mif_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","maja *maslaŋ ŋga Bay Gazlavay fa pawa salay aa wurak aha, fa wusa yam a. Ndaw ma mbəzey teeseɗ aa yam ma wusey a na, a mbəley kwa daa macay wura wura cəpa. ");
INSERT INTO mif_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Feteɗe, ndaw daha aŋga maahəlɓakaya dəga mevey kwakwar maakar a ray a daaŋgafaɗ. ");
INSERT INTO mif_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Masa Yesu ma hətar ndaw aha manakaya na, a səra aŋga maahəlɓakaya menjey ga. Ta’, aa cəfɗa, a ləvar: «Ka wuɗey ŋga mbəley daw?» ");
INSERT INTO mif_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ndaw aha a mbəɗdara, a ləvar: «Bay aɗaw, masa yam fa wusey daa wurak na, kwa ndaw ŋga mbəzdaya aa yam a daa ba. Da ya ləvey, ya daw may na, ndaw mekele ta mbəzey sem teeseɗ da ray aɗaw.» ");
INSERT INTO mif_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu aa guzlar, a ləvar: «Sləkɗey, la gegədeɗ akah, daw ta salay akah.» ");
INSERT INTO mif_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wure wure ŋgene, ndaw aha ta mbəley sem, ta’, a la gegədeɗ aŋga, a daw. Yesu a mbəlda ndaw a na, ta pas meməskey-vaw. ");
INSERT INTO mif_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Masa mahura hay ŋga Jəwif hay ma hətmar ndaw aha fa la gegədeɗ aŋga na, aa guzlmar, a ləvmar: «Tasana na, *pas meməskey-vaw, ba diya? Kaa kwakwas aləkwa a vəlka cəveɗ ŋga la gegədeɗ akah gway daw?» ");
INSERT INTO mif_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A mbəɗdatara, a ləvtar: «Ndaw ma mbəldaya na, a ləvya “La gegədeɗ akah, daw ta salay akah.”» ");
INSERT INTO mif_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mahura hay ŋga Jəwif hay aa cəfɗamara saya, a ləvmar: «Ara ndaw a wura, ma ləvka “la gegədeɗ akah, daw” keɗe na!» ");
INSERT INTO mif_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ama ndaw aha na, a səra ndaw masa ma mbəlda ha saba, maja Yesu taa zəɗfar sem da wuzlah ndəhay ga feteɗe. ");
INSERT INTO mif_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Fa dəɓa ha, Yesu a cam ray ta ndaw aha daa *Way-mekey-kwakwas ŋga Gazlavay, ta’, a ləvar: «Nəka, wure keɗe, ka ta mbəley cay. Ka da key mebərey saba, daa ba na, banay mahura ma fəna keɗe, a hətfaka la.» ");
INSERT INTO mif_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ndaw aha ta’, a daw fa mahura hay ŋga Jəwif hay heyey, a ləvtar: «Ara Yesu ma mbəldaya.» ");
INSERT INTO mif_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Da ray ŋgene, a zlamar ŋga cekeley mey fa Yesu, maja aa ma mbəlda ndaw aha ta pas meməskey-vaw. ");
INSERT INTO mif_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu ta’, aa guzltar, a ləvtar: «Papay Bay Gazlavay fa key sləra mandaw mandaw, yah may, ya key sləra mandaw mandaw anda aŋga.» ");
INSERT INTO mif_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mahura hay ŋga Jəwif hay heyey a səpam dabaray ta gədaŋ ta gədaŋ ŋga kəɗmara Yesu vagay maja aa maa guzltar a. Ma catar mevel na, mey da ray pas meməskey-vaw daada saba, ama maja aa ma zəla Gazlavay Papaha. Ŋgene, a key a pa ray aŋga ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu aa guzltar a mahura hay ŋga *Jəwif hay ma cakalafamar mey heyey, a ləvtar: «Ya fa ləvkwar fara fara, yah Bəzey ŋga Gazlavay, ya gwa ŋga key cek taava aɗaw ba. Ya nəkey dey na, fa cek masa Papay ma ka, fa dəɓa ha, ya ka anda aŋga. ");
INSERT INTO mif_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Fara fara, Papay na, a wuɗya, yah Bəzey aŋga, asaya, aa fa wuzdatiwa cek hay tabiya masa aŋga ray aŋga ma kata. A da wuzya cek hay ga ma rəzlam ndaw ma fəna masa akwar ma hətmar keɗe. Ka rəzlam la ga maja. ");
INSERT INTO mif_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yaw, Papay fa sləkɗadatərwa ndəhay daa meməcey, fa vəltar heter. Yah, Bəzey aŋga may, ya da vəltar heter a ndəhay masa yah ma wuɗey ŋga vəldatara. ");
INSERT INTO mif_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yaw, ma da katar sariya a ndəhay na, ara Papay ba, ama ara yah, maja ta vəlya cəveɗ la ŋga katar sariya a ndəhay, ");
INSERT INTO mif_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","amba ndəhay a namaya ray anda ata ma namar ray a Papay. Da ndaw a naya ray, yah, Bəzey aŋga ba na, fa da nar ray a Papay, ndaw ma slərdiwa daa ba may. ");
INSERT INTO mif_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Ya fa ləvkwar fara fara, da ndaw fa jəkey sləmay fa mey aɗaw, asaya, da ndaw fa təɓa mey ŋga Papay, ndaw ma slərdiwa na, ndaw aha ta hətey heter mendəvey ba cay. Sariya ŋgaa zəɗda daa ba, ama ta sləkɗawa sem daa meməcey. ");
INSERT INTO mif_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ya fa ləvkwar fara fara, pas a, a sawa la, ta wuswa cay, masa ndəhay maməctakaya a da cəndamara ɗay aɗaw, yah, Bəzey ŋga Gazlavay. Ndəhay ma cəndamara, ma təɓmara mey aɗaw na, a da njam ta dey. ");
INSERT INTO mif_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Papay aa ta gədaŋ ŋga vəley heter. Anda keɗe, ta vəldiwa gədaŋ a la ŋgada yah, Bəzey aŋga may, amba ya vəltar heter a ndəhay. ");
INSERT INTO mif_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Asaya, ta vəlya cəveɗ la ŋga katar sariya a ndəhay, maja yah, *Bəz ŋga Ndaw. ");
INSERT INTO mif_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Pas a, a wuswa la masa ndəhay da vəgeɗ a da cəndamara ɗay aɗaw, asaya, a da bamawa daa cəvay ata hay. Ka da rəzlam fa cek hay a ŋgene ba. Anda keɗe, ndəhay manjar mebərey na, a da sləkɗamawa daa meməcey, a da hətam heter mendəvey ba, ama ndəhay ta mebərey na, yah, Bəzey ŋga Gazlavay, ya da katar sariya ŋgaa zəɗdata. ");
INSERT INTO mif_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Yah na, ya gwa ŋga key cek taava aɗaw ba, ama si ta gədaŋ ŋga Gazlavay. Da ya fa key sariya a ndaw na, ya ka anda Gazlavay ma ləvya. Sariya masa yah ma da ka na, aa fara fara, maja ya ka ta cəveɗ e anda Gazlavay, ndaw ma slərdiwa, ma ləvya ŋga ka.» ");
INSERT INTO mif_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yesu aa guzley saya, a ləvey: «Da ya key sede da ray aɗaw na, kaa wara ndəhay a da sərmara mey masa yah maa guzlda, ara mey fara fara na, kwara? ");
INSERT INTO mif_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ama ara ndaw mekele ma key sede da ray aɗaw. Ya səra, sede masa aa ma ka da ray aɗaw a na, aa fara fara. ");
INSERT INTO mif_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Akwar na, ka ta sləram ndəhay fa *Jaŋ-Baptis la. Aŋga taa guzlkwar la da ray mey masa fara fara. ");
INSERT INTO mif_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ama yah na, walay aɗaw ta ndaw amba a key sede da ray aɗaw na, daa ba. Yaa guzlkwar da ray Jaŋ-Baptis na, ya wuɗey amba ka təɓmara Gazlavay a ləhdakwar daa mebərey. ");
INSERT INTO mif_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jaŋ-Baptis a na, aŋga anda petərla magəɗkaya ŋga waɗa slam kweɗek! kweɗek! Pas pal daha akwar taa səmam la daa meweɗey aŋga ha. ");
INSERT INTO mif_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Cek ma fəna mey masa Jaŋ-Baptis maa guzley da ray aɗaw na, daha. Cek aha na, ara sləra masa Papay ma vəldiwa ŋga key. Sləra masa yah ma ka ha na, fa wuzda fara fara ara Papay ma slərdiwa. ");
INSERT INTO mif_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Papay, ndaw ma slərdiwa may, aŋga ray aŋga taa guzley la da ray aɗaw, yah, Bəzey aŋga. Ama akwar ma cəndamara ɗay aŋga daa ba, akwar ma hətmar ta dey akwar daa ba may. ");
INSERT INTO mif_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Akwar fa rəsmara mey aŋga, maja akwar fa təɓmara mey aɗaw, yah, Bəzey aŋga masa aŋga ma slərdiwa na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Akwar faa sərkam mey ŋga Gazlavay maaya maaya amba ka hətam heter mendəvey ba ta fa vəɗa. Ahaw, fara fara mey ŋga Gazlavay a na, aa guzley da ray aɗaw. ");
INSERT INTO mif_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ama ŋga hətey heter mendəvey ba ha na, ka wuɗam ŋga samawa fa yah ba. ");
INSERT INTO mif_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Yah na, ya fa səpey amba ndəhay aa həmdamaya daa ba. ");
INSERT INTO mif_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ama akwar na, ya səra mewulkey akwar. Akwar fa wuɗmara Gazlavay daa ba. ");
INSERT INTO mif_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yah na, ara Papay Bay Gazlavay ma slərdiwa, ka gəmam ŋga təɓmaya ba. Ama da ndaw mekele a sawa saw ŋga ray aŋga gway na, ka təɓmara jak. ");
INSERT INTO mif_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ka wuɗam amba ndəhay aa həmdamakwar. Ama ka wuɗam amba Gazlavay masa fara fara aa həmdakwar ba jak. Kaa wara ka da təɓmara mey aɗaw na, kwara? ");
INSERT INTO mif_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Ka wulkam ara yah ma da wudkwar fa mey ŋga Gazlavay daw? Ara yah ba, ara *Mawiz ma da wudkwar, ndaw masa akwar ma wulkam a ləhdakwar la. ");
INSERT INTO mif_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Da fara fara akwar ta təɓmara mey ŋga Mawiz la na, ka təɓmara mey aɗaw la may, maja Mawiz a, a wuzleley na, da ray aɗaw. ");
INSERT INTO mif_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Da ka təɓmara mey ŋga Mawiz ma wuzlala da ray aɗaw a ba na, kaa wara ka da təɓmara mey aɗaw na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Fa dəɓa ha, Yesu a sləkɗey, a zləŋgey a dey laŋgar ŋga dəhwa ŋga *Galile. A zəlmara dəhwa ha saya, dəhwa ŋga Tiberiyat. ");
INSERT INTO mif_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ndəhay ga fa səpmar wurzay, maja ata ma hətam maazla hay masa Yesu ma kata ŋga mbəley masa-macay hay. ");
INSERT INTO mif_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ata Yesu ta gula aŋga hay, ta’, a təpam aa ray ŋga aŋgwa, a njam feteɗe. ");
INSERT INTO mif_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Daa ŋgene, gwagway ŋga *Jəwif hay mezəley *Pak gweegwe cay. ");
INSERT INTO mif_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu a baŋgaɗa dey na, a hətey ndəhay ga fa samawa ŋgada fa vəɗa. Ta’, aa cəfɗa *Fəlep, a ləvar: «Ya da həɗkakurwa cek mezəmey ŋgada ndəhay tabiya keɗe na, dama?» ");
INSERT INTO mif_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu aa guzlar anda ŋgene na, a key a jada Fəlep maja aŋga na, ta səra cek masa aa ma da ka sem. ");
INSERT INTO mif_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Fəlep a mbəɗdara, a ləvar: «Kwa gabal temere cew na, fa da wusa ŋga həɗkawa cek mezəmey amba kwa waawa a hətey nekəɗey nekəɗey na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gula mekele da wuzlah gula aŋga hay mezəley *Andəre, masa məlmaŋ ŋga *Simaŋw *Piyer, aa guzlar, a ləvar: ");
INSERT INTO mif_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Bəz-gula feɗe daha, aŋga ta peŋ zlam leŋ ewet cew. Kaa ŋgada ndəhay ga keɗe na, a da wusey wa?» ");
INSERT INTO mif_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu aa guzltar a gula aŋga hay, a ləvtar: «Ləvmatar a ndəhay ŋga njam a hwayak.» Daa slam a ŋgene kwakwas mapəckaya daha, ta’, a njam feteɗe. Zel hay daa slam aha, a key gabal zlam. ");
INSERT INTO mif_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu hal! a həlta peŋ hay a, a kar suse a Gazlavay, fa dəɓa ha, a wunkatara a ndəhay a. A həla ewet, a ka kəne saya. A zəmamara, a rəham, siya mbak! ");
INSERT INTO mif_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Masa ata ma rəham cay na, Yesu aa guzltar a gula aŋga hay, a ləvtar: «Cakalamara siya masa mambəkakaya, kwa kuset keɗe a da nəsey ŋga tede ba.» ");
INSERT INTO mif_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Gula hay ŋga Yesu a cakalamara siya ŋga peŋ zlam masa ata ma zəmamara heyey na, a rəhey gadakar kuraw a ray a cew. ");
INSERT INTO mif_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Masa ndəhay ma hətmar maazla masa Yesu ma ka na, aa guzlam, a ləvam: «Fara fara, ndaw keɗe ara *ndaw ma təla mey ŋga Gazlavay masa ma ləvam zleezle a da sawa a bəla heyey.» ");
INSERT INTO mif_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ama Yesu a səra a da samawa ŋga pamara aa bay ŋga gədaŋ. Maja ŋgene, a mbəkdata, a təpey ŋgada aŋgwa saya, a njey taava aŋga feteɗe. ");
INSERT INTO mif_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Taa kwaɗ a ŋgene, *gula hay ŋga Yesu a bərŋgamawa daa aŋgwa ŋgada mey dəhwa. ");
INSERT INTO mif_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ta’, a təpam aa kwambiwal, a diyam a Kapernayum a dey laŋgar ŋga dəhwa ha. Tavaɗ a kərzata daa masa ata fa təŋgam. Ama Yesu ta wusey a cakay ata daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Memeɗ fa key ga. Yam fa cewesley. ");
INSERT INTO mif_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Masa gula hay ŋga Yesu a, fa diyam ta kwambiwal, a key kəlemeeter zlam da daa ba maakwaw na, a hətmar Yesu gweegwe ta ata, fa daw ta salay da ray yam a. Da ray ŋgene, mandərzay a katar. ");
INSERT INTO mif_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ama Yesu aa guzltar, a ləvtar: «Ara yah, ka da zluram ba!» ");
INSERT INTO mif_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Da ray ŋgene, a wuɗam ŋga lamara aa kwambiwal a, ama wure wure ŋgene, kwambiwal a ta wusey sem a rav-zazay aa slam masa ata ma diyam aha. ");
INSERT INTO mif_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pepərek e, ndəhay ga ma lamawa ta dey laŋgar ŋga dəhwa heyey, a nəkmara na, ara kwambiwal pal daa slam aha daada. Asaya, a sərmara Yesu ta təpey aa kwambiwal a ta gula aŋga hay daa ba, ama ara gula aŋga hay taava ata ma təpam aa kwambiwal a ŋga təŋgey a dey laŋgar ŋga dəhwa. ");
INSERT INTO mif_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ama fa dəɓa ha, kwambiwal hay mekele a samawa da Tiberiyat, aa slam masa ndəhay ga ma zəmam peŋ masa Bay Mahura ma kar suse a Gazlavay maja heyey. ");
INSERT INTO mif_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yaw, ndəhay ga heyey, a nəkmara na, ata Yesu ta gula aŋga hay, ata feteɗe daa saba. Da ray ŋgene, a təpam kwambiwal hay ma samawa da Tiberiyat heyey, a diyam ŋgada Kapernayum, a səpmara Yesu. ");
INSERT INTO mif_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ndəhay ga heyey a təŋgam ta kwambiwal hay a hətfamar Yesu aa ta dey laŋgar ŋga dəhwa. Ta’, aa cəfɗamara, a ləvmar: «Bay ala, ka sawa feɗe kaa na, kwara? Ka wuswa ŋga vara?» ");
INSERT INTO mif_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu a mbəɗdatara, a ləvtar: «Ya fa ləvkwar fara fara, ka səpmaya na, maja akwar ma hətam maazla masa yah ma ka ba. Ama ka səpmaya na, maja akwar ma zəmam cek haa ka rəham. ");
INSERT INTO mif_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ka da səpam ŋga hətey ɗaf ma da nəsey da bəla keɗe ba. Ama səpam ŋga hətey ɗaf mevəley heter mendəvey ba. Ɗaf mevəley heter mendəvey ba ha na, ara yah, *Bəz ŋga Ndaw ma da vəldakwara, maja Papay, Bay Gazlavay, ta wuzda la ara aŋga ma vəldiwa gədaŋ a.» ");
INSERT INTO mif_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ndəhay a, aa cəfɗamara Yesu saya, a ləvmar: «Bay ala, kaa ya da kam sləra ma mbafar a Gazlavay na, wura?» ");
INSERT INTO mif_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu a mbəɗdatara, a ləvtar: «Sləra ma mbafar a Gazlavay na, ara mepey ndaw masa aŋga ma slərdərwa ŋga ndaw aŋga fara fara.» ");
INSERT INTO mif_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aa guzlmar a Yesu, a ləvmar: «Kandar maazla masa ala ma da hətmar ta dey ala, amba ya sərmara ara Gazlavay ma slərdakawa, asaya, ya pamaka ŋga ndaw ala fara fara. Kaa ka da kandar maazla ha na, wura? ");
INSERT INTO mif_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Zleezle, papaŋ ŋga papa aləkwa hay ta zəmam cek mezəley “man” la da wuzlah-ley. Mawuzlalakaya daa ɗerewel ŋga Gazlavay, a ləvey: “Ta vəltar cek mezəmey la ma kwiywa ta da vaɗ.”» ");
INSERT INTO mif_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu a mbəɗdatara, a ləvtar: «Ya fa ləvkwar fara fara, ma vəlkwar cek mezəmey ma kwiywa ta da vaɗ na, ara *Mawiz ba, ama ara Gazlavay Papay ma vəlkwar cek mezəmey masa fara fara ma kwiywa ta da vaɗ. ");
INSERT INTO mif_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ahaw, cek mezəmey masa Gazlavay ma vəldakwara na, ara ndaw ma pawa salay ta da vaɗ. Ara aŋga ma da vəltar heter mendəvey ba a ndəhay da bəla.» ");
INSERT INTO mif_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","A mbəɗdamara a Yesu dəɓa, a ləvmar: «Bay ala, na vəlndar cek mezəmey a ŋgene mandaw mandaw taw!» ");
INSERT INTO mif_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu a mbəɗdatara saya, a ləvtar: «Yah na, ɗaf mevəley heter mendəvey ba. Da ndaw ta sawa la asi aɗaw na, may fa da car daa saba, asaya, da ndaw ma paya la ŋga ndaw aŋga fara fara na, yam fa da kar daa saba may. ");
INSERT INTO mif_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ya taa guzlkwar la, ya ləvkwar: “Akwar ma hətmaya la ta dey akwar, ama ka təɓmara mey aɗaw ba cəŋga.” ");
INSERT INTO mif_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ndəhay tabiya masa Papay ma vəldatiwa na, a samawa la asi aɗaw. Ndaw ma sawa asi aɗaw na, ya fa da ɓəla daa ba, ");
INSERT INTO mif_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","maja ya pawa salay da vaɗ na, ŋga key cek anda yah ma wuɗey ba, ama ŋga key cek anda Gazlavay, ndaw ma slərdiwa, ma wuɗey. ");
INSERT INTO mif_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Gazlavay, ndaw ma slərdiwa, a wuɗey ndəhay masa aa ma vəldatiwa na, yaa zəɗey kwa pal da wuzlah ata ba. Ama ya da sləkɗadatərwa daa meməcey ta pas masa bəla ma da ndəvey. ");
INSERT INTO mif_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Cek ma mbafar a Papay na, anja ndəhay tabiya ma sərmaya, yah, Bəzey aŋga, ta ma pamaya ŋga ndaw ata fara fara na, ŋga hətam heter mendəvey ba. Ya da sləkɗadatərwa daa meməcey ta pas masa bəla ma da ndəvey.» ");
INSERT INTO mif_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Masa Yesu ma ləvey «Yah na, ɗaf ma pawa salay ta da vaɗ» heyey na, *Jəwif hay aa ŋguram mey da ray a, ");
INSERT INTO mif_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","a ləvam: «Aŋga na, Yesu, bəzey ŋga *Jawzef, ba diya? Aləkwa fa sərmatakwa ata papaha ta mamaha kaa gway na! Kaa aa guzley, a ləvey aŋga ɗaf ma pawa salay ta da vaɗ na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu a mbəɗdatara, a ləvtar: «Mbəkdamara meeŋgurey-mey. ");
INSERT INTO mif_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kwa ndaw ma gwa ŋga sawa asi aɗaw ta gədaŋ aŋga na, daa ba. Si Papay, ndaw ma slərdiwa, ma handərwa. Yaw, ya da sləkɗadərwa daa meməcey ta pas masa bəla ma da ndəvey. ");
INSERT INTO mif_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ndəhay ma təla mey ŋga Gazlavay ta wuzlalam la, a ləvam: “Ara Gazlavay ma daa sərkadata ndəhay tabiya.” Yaw, kwa waawa ma jəkey sləmay fa Papay, ma təɓa meesərkedey aŋga na, a sawa la asi aɗaw. ");
INSERT INTO mif_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Sərmara na, kwa ndaw pal ma hətar Papay daa ba, si yah, ndaw ma sawa ta fa aŋga gway. ");
INSERT INTO mif_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ya fa ləvkwar fara fara, ndaw ma paya ŋga ndaw aŋga fara fara la na, ta hətey heter mendəvey ba cay. ");
INSERT INTO mif_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yah na, ɗaf mevəley heter mendəvey ba. ");
INSERT INTO mif_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Zleezle papaŋ ŋga papakw akwar hay ta zəmam cek mezəmey la da wuzlah-ley, ama ta ŋgene he cəpa ta məcam sem cəŋga. ");
INSERT INTO mif_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ama ndaw ma zəma ɗaf ma pawa salay ta da vaɗ na, fa da məcey daa ba. ");
INSERT INTO mif_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yah na, ɗaf mevəley heter mendəvey ba ma pawa salay ta da vaɗ. Da ndaw ma zəmey ɗaf a la na, a da njey ŋga sərmataw. Ɗaf masa yah ma da vəldakwara ha na, ara aslaw ŋga vaw aɗaw. Ya vəlda amba ndəhay da bəla a hətam heter mendəvey ba.» ");
INSERT INTO mif_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jəwif hay a kam yawa ta gədaŋ da ray mey a keɗe, aa cəfɗam vaw da wuzlah ata, a ləvam: «Ndaw aha keɗe a da vəldandakwara aslaw ŋga vaw aŋga ŋga zəmey na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Da ray ŋgene, Yesu aa guzltar, a ləvtar: «Ya fa ləvkwar fara fara, da akwar ma zəmam aslaw ŋga vaw aɗaw daa ba, asaya, da akwar ma sam mambaz aɗaw, yah, Bəz ŋga Ndaw, daa ba na, ŋgene, akwar fa da hətam heter mendəvey ba daa ba. ");
INSERT INTO mif_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ndaw masa fa zəmey aslaw ŋga vaw aɗaw ta masa fa sey mambaz aɗaw na, ta hətey heter mendəvey ba cay. Yaw, ya da sləkɗadərwa daa meməcey ta pas masa bəla ma da ndəvey. ");
INSERT INTO mif_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Maja aslaw ŋga vaw aɗaw na, ara cek mezəmey masa fara fara, asaya, mambaz aɗaw na, ara cek mesey masa fara fara. ");
INSERT INTO mif_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ndaw ma zəmey aslaw ŋga vaw aɗaw ta ma sey mambaz aɗaw na, a da njey macəmkaya ta yah, yah may, ya da njey macəmkaya ta aŋga. ");
INSERT INTO mif_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Papay, ndaw ma slərdiwa, aa ta dey, ya njey dasi har aŋga. Anda keɗe, ndaw masa fa zəmey aslaw ŋga vaw aɗaw na, a da njey dasi har aɗaw may. ");
INSERT INTO mif_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yah na, ɗaf ma pawa salay ta da vaɗ. Ɗaf a ara anda cek mezəmey masa papaŋ ŋga papakw akwar hay ma zəmamara zleezle ba, maja ta zəmamara cek aha la, ta məcam sem cəŋga. Ama ndaw ma zəma ɗaf masa yah ma da vəldara keɗe na, a da njey ta dey ŋga sərmataw.» ");
INSERT INTO mif_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Keɗe he, ara meesərkedey ŋga Yesu daa *way-mewuzey-mey ŋga Gazlavay da Kapernayum. ");
INSERT INTO mif_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Masa ndəhay a ma cəndamara mey ŋga Yesu la na, ndəhay ga da wuzlah ata masa ma diyam asiya heyey a ləvam: «Mey aŋga ha keɗe na, aa ta banay ŋga cəney. Ma da gwa ŋga jəkfar sləmay na, wa?» ");
INSERT INTO mif_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ama Yesu ta səra sem ndəhay a faa ŋguram mey da ray mey aŋga ha. Ta’, aa guzltar, a ləvtar: «Mey aɗaw a keɗe na, fa həɓkwar ray daw? ");
INSERT INTO mif_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yaw, kaa da wara akwar ma da hətmaya, yah, *Bəz ŋga Ndaw, fa təpey aa slam masa yah ma pawa salay da hwaɗ a na, ka da ləvam kwara? ");
INSERT INTO mif_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ara *Mesəfney ŋga Gazlavay ma vəltar heter a ndəhay. Ndaw-magədaŋ taava aŋga na, a gwa ŋga njey ta gədaŋ aŋga daada ba. Mey masa yah maa guzldakwara keɗe na, a sawa ta fa Mesəfney ŋga Gazlavay, a vəltar heter a ndəhay. ");
INSERT INTO mif_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ama ndəhay siya da wuzlah akwar, a təɓmara mey aɗaw a ba.» Dəga zleezle, Yesu a sərta ndəhay masa ma da təɓmara mey aŋga ba, asaya, a səra ndaw ma da vəlda a har masa-gəra aŋga hay ŋga kəɗey vagay. ");
INSERT INTO mif_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesu aa guzltar saya, a ləvtar: «Ara maja ŋgene, yah ma ləvkwar kwa ndaw ma gwa ŋga sawa asi aɗaw ta gədaŋ aŋga na, daa ba, si Papay ma vəlar cəveɗ ŋga sawa gway.» ");
INSERT INTO mif_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Dəga aŋga maa guzley ŋgene na, ndəhay ga dasi ndəhay ma diyam asi Yesu a, a mbəkdamara, a diyam asiya saba. ");
INSERT INTO mif_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu, ta’, aa guzltar a gula aŋga hay kuraw a ray a cew, a ləvtar: «Kaa akwar may, ka wuɗam ŋga diyam na, gway daw?» ");
INSERT INTO mif_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","*Simaŋw *Piyer a mbəɗdara, a ləvar: «Bay ala, ya diyam na, fa wa dəɓa wa? Mey akah na, a vəley heter mendəvey ba a ndəhay, ba diya? ");
INSERT INTO mif_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wure keɗe, ala ta sərmara cay, ya təɓmara, kah na, ndaw ŋga Gazlavay masa aa ma slərdərwa ŋga key sləra aŋga.» ");
INSERT INTO mif_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu a mbəɗdatara, a ləvtar: «Ma walakwar, akwar kuraw a ray a cew keɗe na, ara yah, ba diya? Ama ndaw pal da wuzlah akwar daha na, aŋga gula ŋga *Sataŋ, bay-malula.» ");
INSERT INTO mif_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu aa guzley na, da ray Juda, bəzey ŋga Simaŋw Iskariyawt. Juda ha na, kwa aŋga da wuzlah gula aŋga hay kuraw a ray a cew heyey na, ara aŋga ma da vəlda Yesu a har masa-gəra aŋga hay ŋga kəɗey vagay. ");
INSERT INTO mif_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Fa dəɓa ha, Yesu a pəkey daa hwayak ŋga *Galile. A wuɗey ŋga daw ŋga pəkey daa hwayak ŋga *Jude ba, maja mahura hay ŋga *Jəwif hay feteɗe fa səpmara ŋga kəɗey vagay. ");
INSERT INTO mif_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Daa ŋgene *gwagway ŋga Way-mekərcey gweegwe cay. ");
INSERT INTO mif_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ta’, məlmaha hay aa guzlmar, a ləvmar: «Sləkɗey la da Galile feɗe, daw aa hwayak ŋga Jude amba ndəhay ma səpmaka a hətmar sləra masa kah ma ka ta dey ata. ");
INSERT INTO mif_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Maja kwa waawa, da a wuɗey ndəhay tabiya ŋga sərmara na, a ɓey cek masa aa ma ka fa dey ŋga ndəhay ba. Ka fa key maazla hay mekele mekele anda keɗe, kata fa mey ŋga ndəhay tabiya amba a sərmaka.» ");
INSERT INTO mif_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kwa məlmaŋ ŋga Yesu hay a ta ray ata na, fa pamara Yesu a ŋga ndaw ata fara fara daa ba. ");
INSERT INTO mif_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu a mbəɗdatara, a ləvtar: «Pas masa maaya ŋgada yah na, ta wuswa daa ba araŋ, ama ŋgada akwar na, kwa pas wura wura na, aŋga maaya. ");
INSERT INTO mif_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Akwar na, ndəhay da bəla fa da hətam cəveɗ ŋga rəsmakwar daa ba, ama yah na, fa rəsmaya, maja ya fa wuzdatərwa cek hay malamba masa ata ma kamata. ");
INSERT INTO mif_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Akwar na, diyam aa gwagway a. Yah na, ya fa da daw daa ba, maja pas aɗaw ta wuswa daa ba araŋ.» ");
INSERT INTO mif_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Fa dəɓa ha masa Yesu maa guzley la anda keɗe na, ta’, a njey da Galile he cəŋga. ");
INSERT INTO mif_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Masa məlmaŋ ŋga Yesu hay ata sem la aa gwagway heyey na, Yesu ta’, a daw aa gwagway a may, ama a səhwey ta səhwey, kwa ndaw ma hətar daa ba. ");
INSERT INTO mif_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mahura hay ŋga *Jəwif hay a səpmara daa gwagway a, a ləvam: «Ndaw a heyey aa dama?» ");
INSERT INTO mif_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ndəhay ga daa gwagway a faa səkam mey da ray Yesu a, siya hay a ləvam: «Ara ndaw maaya.» Ndəhay siya may, a ləvam: «Kay! Ara ndaw maaya ba, fa betey ndəhay.» ");
INSERT INTO mif_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kwa ndaw ta gwa ŋgaa guzley da ray Yesu fa mey ŋga ndəhay daa ba, maja a zluram ta mahura hay ŋga Jəwif hay. ");
INSERT INTO mif_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Masa gwagway a heyey ta key cay ɗar məfaɗ na, Yesu ta’, a daw aa *Way-mekey-kwakwas ŋga Gazlavay, aa sərkadata ndəhay. ");
INSERT INTO mif_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mahura hay ŋga Jəwif hay ma cəndamara mey ŋga Yesu a na, a rəzlam, a ləvam: «Haya! Ndaw a kaa meeme, taa sərkey ŋga sərey mey ŋga Gazlavay daa ba, ama a sərta mey hay a maaya maaya na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu a mbəɗdatara, a ləvtar: «Mey masa yah maa sərkadatara a ndəhay keɗe na, ara mey aɗaw ba, ama ara mey ŋga Gazlavay, ndaw ma slərdiwa. ");
INSERT INTO mif_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mey masa yah maa sərkadatara a ndəhay, da ara mey ŋga Gazlavay, da daa ba, da ara mey aɗaw na, ndaw ma wuɗey ŋga key cek ma mbafar a Gazlavay na, a səra la. ");
INSERT INTO mif_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ndaw maa sərkadata ndəhay ta gədaŋ aŋga gway na, a key ŋgene, a səpey amba ndəhay aa həmdamara. Ama ndaw maa sərkadata ndəhay amba ndəhay aa həmdamara ndaw ma slərdərwa na, ŋgene ara ndaw maaya ma mbərzley ba. ");
INSERT INTO mif_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Zleezle *Mawiz ta wuzkwar kwakwas hay la ŋga səpey, ba diya? Ama kwa ndaw pal da wuzlah akwar ta səpa kwakwas a ta cəveɗ e daa ba. Kaa ka səpmaya ŋga kəɗey vagay na, maja me?» ");
INSERT INTO mif_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ndəhay a mbəɗdamara, a ləvmar: «Kah na, ta malula da ray. Ma wuɗey ŋga kəɗka vagay na, wa?» ");
INSERT INTO mif_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu a mbəɗdatara, a ləvtar: «Pas pal daha, ya ta mbəley ndaw la ta *pas meməskey-vaw. Akwar ta rəzlam la ga maja. ");
INSERT INTO mif_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Wulkam cey, Mawiz ta wuzkwar kwakwas la ŋga *mesley mandawal. Kwakwas ŋga mesley mandawal a, a zley na, fa Mawiz ba, ama dəga fa papaŋ ŋga papakw akwar hay zleezle. Kwa ta pas meməskey-vaw na, akwar fa slam mandawal ŋga bəza hay. ");
INSERT INTO mif_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Akwar fa slam mandawal ŋga bəzey kwa ta pas meməskey-vaw amba kwakwas ŋga Mawiz a zləɓey ba. Kaa ka cam mevel a ray aɗaw maja yah ma mbəley ndaw ta pas meməskey-vaw na, kwara? ");
INSERT INTO mif_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ka da wulkam da ray ndaw, ka ləvam aŋga maaya, da daa ba, aŋga maaya ba maja akwar ma hətmar ta dey gway na, kəne ba. Ama wulkam maaya maaya da ray cek masa ndaw aha ma ka amba kaa guzlam fara fara ta cəveɗ e.» ");
INSERT INTO mif_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ndəhay siya da *Jeruzelem aa guzlam da wuzlah ata, a ləvam: «Keɗe na, ara ndaw masa ata ma səpmara ŋga kəɗey vagay heyey, ba diya? ");
INSERT INTO mif_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nəkmara, aŋga faa guzley fa mey ŋga ndəhay. Kaa aa guzlmar saba kwara? Mahura aləkwa hay ta sərmara la fara fara ara *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay heyey fara daw? ");
INSERT INTO mif_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yaw, Kəriste ma da sawa na, ya sərkwa slam masa aŋga ma sawa da hwaɗ a ba. Ama ndaw keɗe na, ya sərkwa slam masa aŋga ma sawa, ba diya?» ");
INSERT INTO mif_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Daa masa Yesu faa sərkadata ndəhay daa *Way-mekey-kwakwas ŋga Gazlavay na, aa guzley ta gədaŋ, a ləvey: «Akwar na, ka sərmaya fara daw? Asaya, ka sərmara slam masa yah ma sawa da hwaɗ a fara fara daw? Ya sawa na, ŋga ray aɗaw ba, ama ara ndaw ma slərdiwa. Ndaw a, aa maaya fara fara. Akwar na, ka sərmara ndaw aha ba. ");
INSERT INTO mif_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yah na, ya səra ndaw aha, maja ya sawa da cakay a, asaya, ara aŋga ma slərdiwa.» ");
INSERT INTO mif_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","A səpam cəveɗ amba a kərzamara Yesu, ama kwa ndaw pal ta pafar har daa ba, maja pas aŋga ta wuswa daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ta ŋgene he cəpa, ndəhay ga fa təɓmara mey aŋga cəŋga. Aa guzlam, a ləvam: «*Ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay ma da sawa na, a key maazla hay ma fəna ŋga ndaw keɗe la daw?» ");
INSERT INTO mif_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mey masa ndəhay maa səkdamara da ray Yesu heyey na, *Fariza hay ta cəndamara sem. Da ray ŋgene, Fariza hay a, ta *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay, a sləram ndəhay ma jəɗa *Way-mekey-kwakwas ŋga Gazlavay ŋga kərzamərwa Yesu. ");
INSERT INTO mif_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu ta’, aa guzley, a ləvey: «Ya da njey da cakay akwar da bəla keɗe na, nekəɗey gway. Fa dəɓa ha, ya da daw a cakay ndaw ma slərdiwa. ");
INSERT INTO mif_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ka səpmaya la, ama akwar fa da hətmaya daa saba, maja ka gwamara ŋga diyam aa slam masa yah ma da daw a hwaɗ a ba.» ");
INSERT INTO mif_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mahura hay ŋga *Jəwif hay aa cəfɗam vaw da wuzlah ata, a ləvam: «A da daw na, ta’, ama may ama, amba ya hətkwar saba na! A da daw fa ndəhay aləkwa hay Jəwif hay ma njam da wuzlah Gərek hay daw? A daa sərkadatərwa Gərek hay daw? ");
INSERT INTO mif_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Aa guzley, a ləvey: “Ka səpmaya la, ama akwar fa da hətmaya daa saba, maja ka gwamara ŋga diyam aa slam masa yah ma da daw a hwaɗ a ba.” Mey a keɗe na, a wuɗey ŋga ləvey me?» ");
INSERT INTO mif_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ɗar ŋga madagway-dakw ŋga *gwagway ŋga Way-mekərcey na, ara ɗar mahura ma fənta ɗar hay siya ŋga gwagway a. Ta pas ŋgene, Yesu a lecey ta lecey fa mey ŋga ndəhay, aa guzley ta gədaŋ, a ləvey: «Da ndaw yam fa kar na, ŋga sawa fa yah ŋga sey. ");
INSERT INTO mif_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yaw, mawuzlalakaya daa ɗerewel ŋga Gazlavay, a ləvey: “Ndaw ma paya ŋga ndaw aŋga fara fara la na, yam ma vəley heter mendəvey ba fa vavawa daa mevel aŋga”.» ");
INSERT INTO mif_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu maa guzley anda keɗe na, da ray *Mesəfney ŋga Gazlavay. Ndəhay masa ma pamara Yesu ŋga ndaw ata fara fara na, a hətam Mesəfney aha la. Daa ŋgene, Yesu ta vəldərwa Mesəfney a, a bəla daa ba araŋ, maja Yesu ta təpey a vaɗ ŋga njey aa slam aŋga meweɗey daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Masa ndəhay ma cəndamara mey ŋga Yesu la na, ndəhay siya da wuzlah ata aa guzlam, a ləvam: «Fara fara, ndaw keɗe ara *ndaw ma təla mey ŋga Gazlavay ma da sawa heyey.» ");
INSERT INTO mif_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ndəhay siya a ləvam: «Ara *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay.» Mekele hay saya a ləvam: «Kəriste he a da sawa na, daa hwayak ŋga *Galile daw? ");
INSERT INTO mif_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mawuzlalakaya daa ɗerewel ŋga Gazlavay a ləvey: “Kəriste, ndaw masa Gazlavay ma wala na, a da bawa daa səkway ŋga Bay *Davit, a da yawa da Betəlehem, slala masa Bay Davit e ma yawa zleezle da hwaɗ a.”» ");
INSERT INTO mif_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Anda keɗe, ndəhay a, a wuɗkam ɗay da wuzlah ata maja Yesu. ");
INSERT INTO mif_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ndəhay siya da wuzlah ata a wuɗam ŋga kərzamara Yesu, ama kwa ndaw pal ta pafar har daa ba. ");
INSERT INTO mif_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Masa ndəhay ma jəɗa *Way-mekey-kwakwas ŋga Gazlavay ma vəhmawa la na, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta *Fariza hay aa cəfɗamata, a ləvmatar: «Akwar ma kərzamərwa daa saba maja me?» ");
INSERT INTO mif_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ndəhay ma jəɗa Way-mekey-kwakwas heyey a mbəɗdamatara, a ləvmatar: «Ŋga menjey ala, ya ta hətam ndaw maa guzley maaya anda aŋga daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariza hay aa guzlmatar saya, a ləvmatar: «Yaw, akwar may ta fəckwar sem aa cəveɗ aŋga ŋgene may daw? ");
INSERT INTO mif_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ala Fariza hay na, ala fa təɓmara mey ŋga ndaw aha daa ba. Kwa ndaw mahura ŋga *Jəwif hay pal fa təɓa mey ŋga ndaw aha daa ba may. ");
INSERT INTO mif_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ndəhay ma təɓmara mey aŋga ŋgene na, ara ndəhay ma sərmara *kwakwas ŋga Mawiz ba, ara ndəhay masa Gazlavay ta nəsta sem.» ");
INSERT INTO mif_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikwedem, masa ma daw fa Yesu zleezle heyey na, aŋga da wuzlah Fariza hay a. Ta’, a mbəɗdatara, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Kwakwas aləkwa a vəley cəveɗ ŋga kərzey ndaw anda keɗe ba. Si ya jəkfakwar sləmay, ya sərkwa cek masa aa ma ka la ɗagay.» ");
INSERT INTO mif_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Fariza hay siya a mbəɗdamara, a ləvmar: «Kah may, kah ndaw *Galile daw? Jaŋga ɗerewel ŋga Gazlavay amba ka səra kwa *ndaw ma təla mey ŋga Gazlavay pal masa ndaw Galile na, daa ba.»  ");
INSERT INTO mif_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Fa dəɓa ha, aa waɗam ray, kwa waawa a daw a way aŋga. ");
INSERT INTO mif_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Masa *Fariza hay maa waɗam ray cay na, ta’, Yesu a daw aa Aŋgwa ŋga *Awliviye. ");
INSERT INTO mif_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pepərek e, slam bəŋ-beŋ na, ta’, a vəhwa aa *Way-mekey-kwakwas ŋga Gazlavay. Ndəhay ga a ŋgəcham a cakay a, ta’, a njey, aa sərkadata. ");
INSERT INTO mif_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","*Ndəhay maa sərkada kwakwas ŋga Mawiz ta Fariza hay a handamawa ŋgwas daha fa mey ŋga Yesu a. Ŋgwas aha a kərzamərwa fa ley vaw saw da palah. Deŋ! a lacadamara ŋgwas aha a wuzlah ndəhay tabiya, ");
INSERT INTO mif_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","aa guzlmar a Yesu, a ləvmar: «Bay ala, ehe, ŋgwas keɗe, ya kərzamərwa fa ley vaw saw da palah. ");
INSERT INTO mif_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kwakwas ŋga Mawiz a ləvey kwa ŋgwas wura wura ma ley vaw saw da palah anda keɗe na, si meezekey aŋga ta aŋgwa vagay. Kaa kah na, ka wulkey kwara?» ");
INSERT INTO mif_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Aa guzlmar a Yesu anda keɗe na, a wuɗam a ŋgamar gadaŋ amba a hətam dabaray ŋga dadəɗfamar mey. Ama Yesu ta’, aa cəɗkwey, a təhwey cek ta har fa hwiyak. ");
INSERT INTO mif_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ndəhay kaa heyey na, faa guzlmar cəŋga, faa guzlmar cəŋga. Ta’, Yesu a, a lecey, aa guzltar, a ləvtar: «Da ndaw pal dasi akwar ŋgene manjar mebərey daha na, ŋga ley aŋgwa ha ŋga hazaka teeseɗ cey.» ");
INSERT INTO mif_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Fa dəɓa ha, Yesu ta’, aa cəɗkwey saya, a təhwey cek fa hwiyak saya. ");
INSERT INTO mif_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Masa ndəhay ma handamərwa ŋgwas heyey ma cəndamara Yesu maa guzley anda keɗe la na, a səhwam pal pal, ndəhay mahura hay teeseɗ, mendərey Yesu taava aŋga, ŋgwas a malacakaya fa mey aŋga. ");
INSERT INTO mif_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu ta’, a lecey, aa guzlar a ŋgwas a, a ləvar: «Kwakwa, ndəhay ma handamakawa heyey na, ata ama dəɓa ama? Ndaw pal da wuzlah ata ta hazakaka la daw?» ");
INSERT INTO mif_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ŋgwas aha a mbəɗdara, a ləvar: «Daa ba, bay aɗaw.» Yesu a ləvar: «Yah may, ya fa da hazakaka daa ba. Daw, ama dəga tasana ka da key mebərey saba.» ");
INSERT INTO mif_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu aa guzltar a ndəhay makustakaya daa Way-mekey-kwakwas heyey saya, a ləvtar: «Ma waɗa slam da bəla na, ara Yah. Ndaw ma səpya na, fa da pəkey daa ləvaŋ daa saba, ama a da njey daa slam-meweɗey masa ma vəley heter mendəvey ba.» ");
INSERT INTO mif_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","*Fariza hay aa guzlmar, a ləvmar: «Ka faa guzley da ray akah ta mey akah. Maja ŋgene, mey masa kah maa guzlda ha na, ara mey fara fara ba.» ");
INSERT INTO mif_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu a mbəɗdatara, a ləvtar: «Kwa ya faa guzley da ray aɗaw ta mey aɗaw na, ama mey masa yah maa guzlda ha, ara mey fara fara. Ara mey fara fara na, maja ya səra slam masa yah ma sawa da hwaɗ a, asaya, ya səra slam masa yah ma da daw a hwaɗ a may. Ama akwar na, ka sərmara slam masa yah ma sawa da hwaɗ a ba, ka sərmara slam masa yah ma da daw a hwaɗ a ba may. ");
INSERT INTO mif_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Akwar na, ka wulkam da ray ndaw, ka ləvam ndaw keɗe aŋga maaya, da daa ba, aŋga maaya ba, maja akwar ma hətmar ta dey daada gway. Mewulkey akwar ŋgene, ara mewulkey ŋga ndaw-magədaŋ. Ama yah na, yaa guzley da ray ndaw ba. ");
INSERT INTO mif_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yaw, da ya taa guzley la da ray ndaw na, a key ŋgene, yaa guzley fara fara, maja ara yah taava aɗaw maa guzley da ray ndaw aha ba, ama ala ta Papay, ndaw ma slərdiwa. ");
INSERT INTO mif_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mawuzlalakaya daa kwakwas akwar, a ləvey, da ndəhay cew taa guzlam la letek da ray cek na, ara mey fara fara, ba diya? ");
INSERT INTO mif_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yah na, ya faa guzley da ray aɗaw ta mey aɗaw. Papay, ndaw ma slərdiwa faa guzley da ray aɗaw may.» ");
INSERT INTO mif_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Fariza hay aa cəfɗamara, a ləvmar: «Papakw a na, aa dama?» Yesu a mbəɗdatara, a ləvtar: «Akwar na, ka sərmaya ba, ka sərmara Papay ba may. Da ka sərmaya na, anja ka sərmara Papay la may.» ");
INSERT INTO mif_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu aa guzlda mey a keɗe na, aŋga manjakaya gweegwe ta slam mecekeley dala daa *Way-mekey-kwakwas ŋga Gazlavay. Aa faa sərkadata ndəhay daa Way a, ama kwa ta kərzamara daa ba, maja pas aŋga ta wuswa daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu aa guzltar saya, a ləvtar: «Yah na, ya da daw. Fa dəɓa ha, ka səpmaya la, ama akwar fa da hətmaya daa saba. Anda keɗe, ka da məcam ta mebərey da ray. Aa slam masa yah ma da daw na, akwar fa da gwamara ŋga diyam a hwaɗ a daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mahura hay ŋga *Jəwif hay aa guzlam da wuzlah ata, a ləvam: «Ndaw aha aa guzley, a ləvey, aa slam masa aŋga ma da daw na, ya gwakwa ŋga nakwa ba. A ləvey anda keɗe na, a da kəɗa ray aŋga vagay kwa!» ");
INSERT INTO mif_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu a mbəɗdatara, a ləvtar: «Akwar na, ndəhay da ray hwayak keɗe. Ama yah na, ya sawa da gazlavay da vaɗ. Akwar na, ndəhay ŋga bəla keɗe, ama yah na, ndaw ŋga bəla keɗe ba. ");
INSERT INTO mif_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Maja ŋgene, ya ta ləvkwar la: “Ka da məcam ta mebərey da ray.” Da ka təɓmara “Yah na, ara Yah” ba na, fara fara, ka da məcam ta mebərey da ray.» ");
INSERT INTO mif_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Aa cəfɗamara Yesu, a ləvmar: «Kah na, wa?» Yesu a mbəɗdatara, a ləvtar: «Yah na, ndaw masa yah ma wuzdakwara dəga zleezle heyey. ");
INSERT INTO mif_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mey hay ga da ray akwar daha amba yaa guzley da ray a. Anda keɗe, ya da mbəɗkwar ray maja mebərey akwar. Fara fara, mey masa yah ma kada a ndəhay na, ara mey masa yah ma cəndərwa fa ndaw ma slərdiwa. Aŋga na, ndaw maa guzley mey fara fara.» ");
INSERT INTO mif_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesu maa guzley anda keɗe na, da ray Papaha, Bay Gazlavay. Ama ndəhay a, a cəndamara ba. ");
INSERT INTO mif_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Maja ŋgene, Yesu aa guzltar saya, a ləvtar: «Da masa akwar ma baŋgaɗamaya, yah, *Bəz ŋga Ndaw cay fa hwadam mazlaŋgalakaya na, daa ŋgene, ka sərmara la “Yah na, ara Yah.” Asaya, ka sərmara la, yah na, ya gwa ŋga key cek taava aɗaw ba, ama ya kedey na, mey masa Papay maa sərkadiwa. ");
INSERT INTO mif_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ndaw ma slərdiwa na, aŋga ta yah, ta mbəkdaya taava aɗaw daa ba. Ya fa key cek mandaw mandaw ma mbafar.» ");
INSERT INTO mif_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Masa Yesu maa guzley la anda ŋgene na, ndəhay ga a təɓmara mey aŋga. ");
INSERT INTO mif_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu aa guzltar ŋgada *Jəwif hay masa ma təɓmara mey aŋga dəɓa, a ləvtar: «Da akwar ta təɓmara mey aɗaw la, ka mbəkdamara ba na, ŋgene akwar gula aɗaw hay fara fara. ");
INSERT INTO mif_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Anda keɗe, ka sərmara mey masa fara fara la, mey a, a da pəskakurwa daa beke.» ");
INSERT INTO mif_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","A mbəɗdamara, a ləvmar: «Ala na, ndəhay daa səkway ŋga *Abəraham, kwa ndaw pal dasi ala masa beke na, daa ba səlak! Kaa ka ləvndar mey a, a da pəskandar daa beke na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu a mbəɗdatara, a ləvtar: «Ya fa ləvkwar fara fara, kwa waawa ma key mebərey na, aŋga beke maja mebərey fa wa. ");
INSERT INTO mif_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nəka, beke na, a sləfmara a wuzlah ndəhay masa da way bay aŋga ba, ama bəzey ŋga ndaw ŋga way a na, a sləfmara a wuzlah ndəhay da way a. ");
INSERT INTO mif_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Anda keɗe, da ara yah, Bəzey ŋga Gazlavay, ma pəskakwar daa beke na, ka da njam akwar beke hay saba fara fara. ");
INSERT INTO mif_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ahaw, ya səra akwar na, ndəhay daa səkway ŋga Abəraham. Ama akwar fa səpmaya ŋga kəɗey vagay, maja mey aɗaw ta mbəzkwar aa mevel daa ba. ");
INSERT INTO mif_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yah na, ya kedey mey masa Papay ma wuzdiwa. Akwar na, ka kam cek masa papakw akwar ma kadakwara.» ");
INSERT INTO mif_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","A mbəɗdamara saya, a ləvmar: «Ala na, ndəhay daa səkway ŋga Abəraham.» Yesu a ləvtar: «Da akwar ndəhay daa səkway ŋga Abəraham na, anja ka kam cek anda aŋga ma ka la. ");
INSERT INTO mif_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ama wure keɗe, akwar fa səpmaya ŋga kəɗey vagay, yah, ndaw masa ma wuzdakwara mey masa yah ma cəndərwa ta sləmay aɗaw fa Gazlavay. Ya fa ləvkwar, Abəraham na, ta key cek anda akwar ma kamara kaa na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Akwar na, akwar fa kam cek anda papakw akwar ma ka.» A mbəɗdamara a Yesu, a ləvmar: «Ala na, bəza hay ŋga ndaw mekele ba, Papa ala na, pal, ara Bay Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu a mbəɗdatara, a ləvtar: «Da Gazlavay ara Papakw akwar na, anja ka wuɗmaya la, maja ya sawa da cakay a, asaya, yah feɗe maja aŋga. Ya sawa na, ŋga ray aɗaw ba, ama ara aŋga ma slərdiwa. ");
INSERT INTO mif_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kaa ka cəndamara mey aɗaw ba na, maja me? Ara maja akwar ma gəmam ŋga jəkam sləmay fa mey aɗaw ba. ");
INSERT INTO mif_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Anda keɗe, papakw akwar na, *Sataŋ, bay-malula. Ka kam cek hay cəpa na, masa ma mbafar a papakw akwar a gway. Dəga daa mezley ŋga bəla na, papakw akwar, bay-malula ha, fa kəɗta ndəhay vagay. Asaya, a njey daa cəveɗ masa fara fara ba səlak, maja mey masa fara fara fa bawa da mey aŋga daa ba. Membərzley na, aa da mey aŋga, maja ara ndaw membərzley. Membərzley tabiya na, a sawa ta fa vəɗa. ");
INSERT INTO mif_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yah na, ya faa guzlkwar mey masa fara fara. Da ray ŋgene, ka təɓmara mey aɗaw ba cəŋga. ");
INSERT INTO mif_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ndaw pal da wuzlah akwar ma gwa ŋga ləvya ya ta key mebərey la na, wa? Kaa da ya faa guzlkwar mey masa fara fara na, ka təɓmara ba, maja me? ");
INSERT INTO mif_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ndaw ma ləvey Gazlavay ara Papaha na, a jəkfar sləmay fa Gazlavay a. Ama akwar na, bəza hay ŋga Gazlavay ba. Ara maja ŋgene, akwar ma jəkam sləmay fa mey aŋga ba may.» ");
INSERT INTO mif_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","*Jəwif hay a mbəɗdamara a Yesu, a ləvmar: «Ala maa guzlmaka, ya ləvam kah, ndaw *Samari ŋga tede, kah ta malula da ray heyey na, ara aŋga fara.» ");
INSERT INTO mif_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu a mbəɗdatara, a ləvtar: «Kay, malula da ray aɗaw daa ba, ama a key ya həslar ray a Papay. Akwar na, ka gəmam ŋga həslmaya ray ba. ");
INSERT INTO mif_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kaazla yah ta ray aɗaw, ya fa wuɗey ndaw ŋga həslya ray daa ba, ama ndaw pal daha, a həslya ray la, ara aŋga ma da ɗəsla mey a. ");
INSERT INTO mif_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ya fa ləvkwar fara fara, ndaw ma cənya mey na, fa da məcey daa ba ŋga sərmataw.» ");
INSERT INTO mif_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jəwif hay heyey a mbəɗdamara, a ləvmar: «Wure keɗe, ya ta sərmara cay, kah na, ta malula da ray fara, maja *Abəraham ta məcey sem, ndəhay ma təla mey ŋga Gazlavay ta məcam sem may. Kaa kah na, ka ləvey: “Ndaw ma cənya mey na, fa da məcey daa ba ŋga sərmataw” na, kwara? ");
INSERT INTO mif_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abəraham, papaŋ ŋga papa ala hay ma!, ta məcey sem. Kaa kah na, ka fəna Abəraham a daw? Asaya, ndəhay ma təla mey ŋga Gazlavay may ta məcam sem. Kaa ka pa ray akah na, ŋga wa may wa?» ");
INSERT INTO mif_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu a mbəɗdatara, a ləvtar: «Da ya fa həsley ray na, mehəsley-ray aɗaw a, ara cek ŋga tede. Ma həslya ray na, ara Papay, ndaw masa akwar ma ləvam: “Ara Gazlavay ala” heyey. ");
INSERT INTO mif_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ama ka sərmara ndaw a ba, si yah pal ma səra. Da ya ləvey ya səra ba na, ŋgene yah, ndaw membərzley anda akwar. Ama yah na, ya səra ndaw aha, asaya, ya fa jəkfar sləmay, ya fa təɓa mey aŋga. ");
INSERT INTO mif_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abəraham, papaŋ ŋga papakw akwar, taa səmey la ga maja a wulkey a hətar masawa aɗaw la a bəla. Ahaw, ta hətar la, taa səmey la maja.» ");
INSERT INTO mif_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Da ray ŋgene, Jəwif hay aa guzlmar, a ləvmar: «Mevey akah a wusa kwakwar zlam ba kaa gway na, ka hətərwa Abəraham a na, dama?» ");
INSERT INTO mif_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu a mbəɗdatara, a ləvtar: «Ya fa ləvkwar fara fara, dəga Abəraham ta yawa daa ba araŋ na, “Yah na, ara Yah.”» ");
INSERT INTO mif_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Da ray ŋgene, mahura hay ŋga Jəwif hay aa kwalam aŋgwa ŋgaa zekey Yesu a vagay. Ama Yesu ta’, a ɓey, a bawa la daa *Way-mekey-kwakwas ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pas pal daha, Yesu fa pəkey daa berney ŋga *Jeruzelem. Feteɗe, a hətey ndaw daha. Ndaw aha, aŋga wulaf dəga ŋga mayawa aŋga. ");
INSERT INTO mif_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Gula hay ŋga Yesu aa cəfɗamara Yesu a, a ləvmar: «Bay ala, ndaw keɗe a yawa, aŋga wulaf na, maja me? Ara maja mebərey aŋga daw? Da daa ba, maja mebərey ŋga ata papaha ta mamaha daw?» ");
INSERT INTO mif_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu a mbəɗdatara, a ləvtar: «Ara maja mebərey aŋga ba, asaya, ara maja mebərey ŋga ata papaha ta mamaha ba may. Ndaw aha, aŋga wulaf na, ara amba Gazlavay a ka sləra aŋga da ray a. ");
INSERT INTO mif_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pas, aa daha ɗagay kaa na, maaya na, ya kakwa sləra ŋga ndaw ma slərdiwa, ba na, ya da hətkwa har saba, maja tavaɗ fa da key, kwa ndaw fa da gwa ŋga ka sləra ha daa saba. ");
INSERT INTO mif_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Daa masa yah da bəla keɗe na, ara yah ma waɗa bəla ha.» ");
INSERT INTO mif_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Fa dəɓa ha, aŋga maa guzley la anda keɗe na, tef! a təfey meesleɓ a hwayak, ta’, a ɗey hahay ta meesleɓ e, a kwarara fa dey ŋga ndaw-wulaf heyey, ");
INSERT INTO mif_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","a ləvar: «Daw ta pərarawa dey daa wurak ŋga yam ŋga Siləwe.» (Siləwe he a wuɗey ŋga ləvey «ndaw-meslərey.») Ta’, ndaw-wulaf heyey a daw a pərarawa dey daa wurak a, a vəhwa na, a hətar dey dəɓa. ");
INSERT INTO mif_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Meseembew aŋga hay ta ndəhay ma hətmar maamandaw fa rəkey heyey na, a hətmar aŋga fa hətar dey dəɓa, a ləvam: «Keɗe na, ara ndaw ma rəkey maamandaw feɗe heyey, ba diya?» ");
INSERT INTO mif_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ndəhay siya a ləvam: «Ahaw, ara aŋga.» Siya hay may a ləvam: «Ara aŋga ba, ara ndaw ma lawa cəla.» Ndaw a, a ləvtar: «Ahaw, ara yah, ndaw-wulaf heyey.» ");
INSERT INTO mif_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ta’, ndəhay a, aa cəfɗamara, a ləvmar: «Kaa, dey akah a wurey kwara?» ");
INSERT INTO mif_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ndaw a, a mbəɗdatara, a ləvtar: «Ndaw mezəley Yesu daha, ta’, a ɗey hahay, a kwarayawa fa dey aɗaw, fa dəɓa ha, a ləvya ŋga daw ŋga pərarawa dey daa wurak ŋga yam ŋga Siləwe. Da ray ŋgene, ta’, ya daw. Masa yah ma pərarawa cay na, ya hətar dey dəɓa.» ");
INSERT INTO mif_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ndəhay a, aa cəfɗamara, a ləvam: «Ndaw aha, aŋga dama?» A ləvtar: «Ya səra ba.» ");
INSERT INTO mif_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ta’, a handamara ndaw masa Yesu ma wurara dey heyey fa *Fariza hay, ");
INSERT INTO mif_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","maja Yesu a ɗey hahay, a wurara dey ŋga ndaw a na, ta *pas meməskey-vaw. ");
INSERT INTO mif_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fa dəɓa ha, Fariza hay a, aa cəfɗamara ndaw aha saya, a ləvmar: «Haa ka hətar dey anda keɗe na, ndaw aha, a kada na, kwara?» A ləvtar: «A kwarayawa hahay fa dey. Ta’, ya pəra dey a, cay, ta’, ya hətar dey dəɓa.» ");
INSERT INTO mif_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ndəhay siya da wuzlah Fariza hay a, a kam yawa da wuzlah ata. Siya hay a ləvam: «Ndaw ma key cek anda keɗe na, ara Gazlavay ma slərdərwa ba, maja a key sləra ta pas meməskey-vaw, ara cek masa kwakwas aləkwa ma təka sem, ba diya?» Siya hay a ləvam saya: «Ndaw ta mebərey da ray na, a gwa ŋga key maazla anda keɗe daw?» Anda keɗe, a kam yawa ga haa a wuɗkam ɗay da wuzlah ata. ");
INSERT INTO mif_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Fa dəɓa ha, ta’, aa cəfɗamara ndaw masa Yesu ma wurara dey heyey saya, a ləvmar: «Kaa kah may, ka da ləvey da ray ndaw ma wurkawa dey keɗe na, kwara?» A mbəɗdatara, a ləvtar: «Yah na, ya ləvey ara *ndaw ma təla mey ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","Ndaw aha a yawa aŋga wulaf, ama wure keɗe dey aŋga ta wurey sem na, mahura hay ŋga *Jəwif hay a təɓmara mey a ba, si ata maa cəfɗamata ata papaha ta mamaha la ɗagay. Ta’, a zəlmatərwa, a ləvmatar: «Keɗe na, ara bəzey akwar daw? A yawa na, fara fara aŋga wulaf daw? Yaw, kaa wure keɗe aŋga fa hətar dey na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A mbəɗdamatara, a ləvmatar: «Fara fara, ya sərmara ara bəzey ala, a yawa na, aŋga wulaf. ");
INSERT INTO mif_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ama ya sərmara cek ma key ta aŋga ba, asaya, ya sərmara ndaw ma wurara dey keɗe ba may. Cacəfɗamara aŋga ray aŋga, ara bəzey saya daw? A gwa ŋga wuzdakwara.» ");
INSERT INTO mif_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ata papaha ta mamaha aa guzlam anda keɗe na, maja fa zluram ta mahura hay ŋga Jəwif hay masa da wuzlah Fariza hay heyey. Mahura hay a, ta cəmam ɗay ata sem, a ləvam kwa waawa ma pa Yesu la ŋga *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay na, ŋgene a badamara ndaw aha daa *way-mewuzey-mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ara maja ŋgene, ata papaha ta mamaha heyey maa guzlam, ma ləvam: «Ara bəzey saba, cacəfɗamara taw!» ");
INSERT INTO mif_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Fariza hay a, a zəlmərwa ndaw masa Yesu ma wurara dey heyey saya, a ləvmar: «Wuzdandara fara fara ta mezəley ŋga Gazlavay, maja ala na, ya sərmara ndaw ma wurkawa dey keɗe, ara ndaw ta mebərey.» ");
INSERT INTO mif_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A mbəɗdatara, a ləvtar: «Ayəwa, da aa ta mebərey, da aa ta mebərey daa ba na, ya səra ba. Ama yah ma sərey na, cek pal. Zleezle na, yah wulaf, ama wure keɗe, dey aɗaw ta wurey cay, ya fa hətar dey dəɓa.» ");
INSERT INTO mif_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ndəhay a, a ləvmar saya: «Kaa ndaw aha na, a kaka me? A wurkawa dey a na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A mbəɗdatara, a ləvtar: «Yah ma wuzdakwara cay, ama ka wuɗam ŋga jəkfamaya sləmay ba. Kaa ka wuɗam ya wuzdakwara saya na, kwara? Ayəwa, da ka wuɗam ŋga key gula aŋga hay may kwa?» ");
INSERT INTO mif_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Da ray ŋgene, a cəɗmara ndaw aha, a ləvam: «Hey! Gula aŋga na, kah! Ala na, gula hay ŋga *Mawiz. ");
INSERT INTO mif_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ala na, ya sərmara Gazlavay taa guzlar la a Mawiz, ama ndaw keɗe na, ya sərmara a sawa dama, ba.» ");
INSERT INTO mif_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ndaw a, a mbəɗdatara, a ləvtar: «Aayaa! Akwar ta rəzlmaya sem, maja ka sərmara ndaw a, a sawa na, dama ba. Kaa, aŋga na, ta wuryawa dey aɗaw sem! ");
INSERT INTO mif_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ya sərkwa ndəhay ta mebərey na, Gazlavay a jəkfatar sləmay ba. Ama da ndaw a nar ray a Gazlavay, a kar cek anda aa ma wuɗey na, ŋgene, a jəkfar sləmay la. ");
INSERT INTO mif_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dəga ŋga menjey aləkwa na, ya ta cənkwa ndaw ma wurey dey ŋga ndaw ma yawa, aŋga wulaf la daw? ");
INSERT INTO mif_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Da ndaw aha, ara Gazlavay ma slərdərwa ba na, a gwa ŋga key cek anda keɗe ba.» ");
INSERT INTO mif_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","A mbəɗdamara, a ləvmar: «Kah na, ndaw ta mebərey fara fara dəga ŋga mayawa akah, kaa ka wuɗey ŋgaa sərkadandar cek may daw?» Da ray ŋgene, ta’, a badamara daa way-mewuzey-mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu a cənda na, ta badamara ndaw masa aŋga ma wurara dey heyey sem. Ta’, a daw a hətfar, a ləvar: «Kah ma pa *Bəz ŋga Ndaw la ŋga ndaw akah fara fara daw?» ");
INSERT INTO mif_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ndaw a, a mbəɗdara, a ləvar: «Bəz ŋga Ndaw na, ara wa, Bay Mahura? Wuzdiwa cey, amba ya pa ŋga ndaw aɗaw fara fara na!» ");
INSERT INTO mif_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu a ləvar: «Ka fa hətar ndaw aha ta dey akah, ara yah, ndaw maa guzlka keɗe!» ");
INSERT INTO mif_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ndaw aha, a ləvar: «Ya paka ŋga ndaw aɗaw fara fara, Bay Mahura!» Ta’, ndaw aha a regedey fa mey aŋga. ");
INSERT INTO mif_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu aa guzley ta mey-meŋgey dəɓa, a ləvey: «Ya sawa a bəla keɗe ŋga wuzdatara a ndəhay na, wulaf hay a da hətmar dey, ndəhay ma hətmar dey may, a da təram wulaf hay.» ");
INSERT INTO mif_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ndəhay *Fariza hay siya masa da cakay a, a cəndamara Yesu maa guzley anda keɗe na, ta’, aa cəfɗamara, a ləvmar: «Kaa, ala na, wulaf hay may daw?» ");
INSERT INTO mif_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu a mbəɗdatara, ləvtar: «Da akwar ndəhay wulaf hay na, ŋgene fara fara akwar ta mebərey daa ba. Ama wure keɗe, ka ləvam akwar fa hətmar dey, maja ŋgene, ka da njam ta mebərey da ray.» ");
INSERT INTO mif_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu aa guzltar saya, a ləvtar: «Ya fa ləvkwar fara fara, ndaw ma mbəzey a gezleŋ təɓaŋ hay taa mey-mbew ba, ama a mbəzey ta ray-way na, ndaw a ŋgene ara ndaw-mayal ma sla ɗay ŋga ndaw. ");
INSERT INTO mif_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ama ndaw ma mbəzey a gezleŋ təɓaŋ hay taa mey-mbew na, ndaw a ŋgene ara mecəkwer ŋga təɓaŋ hay a. ");
INSERT INTO mif_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ndaw ma jəɗta təɓaŋ hay ta tavaɗ a wurara mey-mbew ŋgada mecəkwer e, asaya, təɓaŋ aŋga hay, a cəndamara ɗay aŋga. A zəlta təɓaŋ hay a pal pal ta mezəley ata, a badatərwa a palah. ");
INSERT INTO mif_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Masa ta badatərwa cəpa cay na, mecəkwer e, a kəzley fa mey ata, təɓaŋ hay a, a səpmar wurzay maja a sərmara ɗay aŋga. ");
INSERT INTO mif_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Anda keɗe, da ara ndaw mekele na, təɓaŋ hay a fa da səpmara daa ba səlak, ama a da hwam ta ndaw aha maja a sərmara ɗay aŋga ba.» ");
INSERT INTO mif_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu aa guzltar ta mey-meŋgey anda keɗe, ama ndəhay a cəndamara mabara ŋga mey a ba. ");
INSERT INTO mif_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu aa guzley saya, a ləvey: «Ya fa ləvkwar fara fara, yah na, mey-slam ŋga təɓaŋ hay. ");
INSERT INTO mif_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ndəhay tabiya ma samawa teeseɗ da ray aɗaw ma mbəzam a gezleŋ təɓaŋ hay a na, ara mayal hay ma bəzla ndəhay. Ama təɓaŋ hay a, ta cənmatar mey daa ba. ");
INSERT INTO mif_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yah na, mey-slam. Da ndaw a mbəzwa ta fa yah na, ya ləhda. Ndaw a, a gwa a mbəzey, a bawa ta mandərzay ba. Asaya a gwa ŋga hətey cek mezəmey. ");
INSERT INTO mif_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ndaw-mayal a sawa na, ŋga leley, ŋga kəɗey ndaw vagay, asaya, ŋgaa zəɗey ndaw. Ama yah na, ya ta sawa la a bəla amba ndəhay a hətam heter mendəvey ba ma fəna ma fəna. ");
INSERT INTO mif_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Yah na, ndaw-mecəkwer maaya. Ndaw-mecəkwer maaya na, a vəlda ray aŋga maja təɓaŋ aŋga hay. ");
INSERT INTO mif_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ndaw ma səkərey maja dala daada gway na, ara ndaw-mecəkwer fara fara ba. Təɓaŋ hay masa aŋga ma səkərata na, ara ŋga aŋga hay ba. Da ndaw aha a hətar gədey-ley fa sawa ŋgada fa təɓaŋ hay a na, a hway, a mbəkdata. Anda keɗe, gədey-ley a kərzey təɓaŋ hay a, siya hay, a kwakwacam ray. ");
INSERT INTO mif_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ndaw ma səkərey maja dala, ma hway, ma mbəkdata təɓaŋ hay na, aa fa wulkey fa təɓaŋ hay a daa ba. ");
INSERT INTO mif_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Yah na, ndaw-mecəkwer maaya. Ya sərta təɓaŋ aɗaw hay, təɓaŋ aɗaw hay may a sərmaya, ");
INSERT INTO mif_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","anda Papay ma sərya, yah may, ya səra Papay. Ya vəlda ray aɗaw maja təɓaŋ aɗaw hay. ");
INSERT INTO mif_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Səkway ŋga təɓaŋ aɗaw hay mekele daha , ama ata da wuzlah təɓaŋ hay keɗe daa ba. Si ya handatərwa a wuzlah keɗe hay may, amba a cəndamara ɗay aɗaw. A da cəmam ta təɓaŋ hay a keɗe, a da njam daa slam a, dasi har ŋga ndaw-mecəkwer pal. ");
INSERT INTO mif_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Papay fa wuɗya maja ya da vəlda ray aɗaw ŋga məcey, amba fa dəɓa ha, ya sləkɗawa daa meməcey. ");
INSERT INTO mif_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kwa ndaw ma gwa ŋgaa zəɗda ray aɗaw na, daa ba, si yah ma təɓa ŋga vəlda ray aɗaw ŋga məcey. Ya gwa ŋga vəlda ray aɗaw ŋga məcey, asaya, ya gwa ŋga hətar aa slam a. Keɗe na, ara cek masa Papay ma ləvya ŋga key.» ");
INSERT INTO mif_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Masa Yesu maa guzley la anda keɗe na, *Jəwif hay a kam yawa da wuzlah ata saya. ");
INSERT INTO mif_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ndəhay ga da wuzlah ata a ləvam: «Aŋga ta cek da ray, aŋga malula. Ka jəkam sləmay fa mey aŋga na, maja me?» ");
INSERT INTO mif_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ndəhay siya a ləvam: «Ndaw ta cek da ray na, aa guzley anda keɗe ba. Malula na, a gwa ŋga wurey dey ŋga ndaw-wulaf daw?» ");
INSERT INTO mif_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Fa mevey a, fa mevey a, *Jəwif hay fa kam gwagway ŋga sərfedey mewurey *Way-mekey-kwakwas ŋga Gazlavay da *Jeruzelem. Daa ŋgene, gwagway a ta wuswa cay saya. Ara ta kiya memeɗ. ");
INSERT INTO mif_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu fa pəkey dasi balak masa ata ma zəlmara Balak ŋga *Salamaŋw daa Way-mekey-kwakwas ŋga Gazlavay a. ");
INSERT INTO mif_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Feteɗe, Jəwif hay a zlərmar ray, a ləvmar: «Ka fa həɓndar ray kalah kaa na, haa ta vara? Da kah *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay heyey na, kadandara la fara fara gway taw!» ");
INSERT INTO mif_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu a mbəɗdatara, a ləvtar: «Ya ta kadakwara cay, ama akwar ma təɓmara daa ba. Maazla hay tabiya masa yah ma kata na, ara ta gədaŋ ŋga Papay. Maazla hay a fa wuzda mey da ray aɗaw. ");
INSERT INTO mif_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ama akwar na, ka təɓmara ba maja akwar da wuzlah ndəhay aɗaw hay ba. ");
INSERT INTO mif_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ndəhay aɗaw hay a na, ata anda təɓaŋ hay, a sərmara ɗay aɗaw, ya sərta pal pal. Da ya fa daw na, ata fa səpmaya wurzay. ");
INSERT INTO mif_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ya da vəltar heter mendəvey ba, fa daa zəɗam daa ba ŋga sərmataw. Kwa ndaw ma da gwa ŋga pərslata dasi har aɗaw na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Papay, ndaw ma vəldatiwa na, a fənta cek hay tabiya. Anda keɗe, kwa ndaw fa da gwa ŋga pərslata dasi har ŋga Papay na, daa ba may. ");
INSERT INTO mif_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ala ta Papay na, sləra ala letek.» ");
INSERT INTO mif_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jəwif hay aa kwalam aŋgwa saya amba aa zakamara Yesu vagay. ");
INSERT INTO mif_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ama Yesu a mbəɗdatara, a ləvtar: «Ya ta key maazla hay maaya la ga fa mey akwar ta gədaŋ ŋga Papay. Kaa ka daa zakamaya ta aŋgwa vagay na, maja maazla wura?» ");
INSERT INTO mif_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jəwif hay a, a mbəɗdamara, a ləvmar: «Ya ta wuɗam ŋgaa zakamaka ta aŋgwa vagay maja maazla maaya masa kah ma ka na, daa ba. Ama ya wuɗam ŋgaa zakamaka na, maja kah ma cəɗa Gazlavay. Asaya, kah na, ndaw-magədaŋ ŋga tede gway na, kaa ka pa ray akah ŋga Gazlavay na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu a mbəɗdatara, a ləvtar: «Daa kwakwas akwar mawuzlalakaya, Gazlavay a ləvey: “Akwar na, gazlavay hay.” ");
INSERT INTO mif_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ya fa sərkwa mey mawuzlalakaya daa ɗerewel ŋga Gazlavay na, meevəsey aŋga daa ba, ba diya? Daa ɗerewel ŋga Gazlavay a zəlam gazlavay hay na, ndəhay masa Gazlavay maa guzltar. ");
INSERT INTO mif_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yah na, Papay ta walaya la, ta slərdiwa la a bəla. Ya ta ləvey la, yah na, Bəzey ŋga Gazlavay, ama ka ləvam a key ya cəɗa Gazlavay a. Kaa, kaa guzlam anda keɗe na, kwara? ");
INSERT INTO mif_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Da ya fa kata sləra hay masa Papay ma vəldatiwa daa ba na, ŋgene akwar fa da təɓmara mey aɗaw daa ba. ");
INSERT INTO mif_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama da ya fa kata, ka təɓmara ba cəŋga na, təɓmara mey aɗaw maja maazla hay masa yah ma kata tarah taw, amba ka sərmara maaya maaya Papay aa ta yah, yah may, yah ta Papay.» ");
INSERT INTO mif_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mahura hay ŋga Jəwif hay a səpam cəveɗ ŋga kərzamara Yesu saya. Ama Yesu ta ləhfatar sem. ");
INSERT INTO mif_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu ta’, a zləŋgey a dey-wayam ŋga Jurdeŋ saya, aa slam masa *Jaŋ-Baptis ma zlar ŋga katar *baptem a ndəhay da hwaɗ a heyey. Ta’, a njey feteɗe ɗar ga. ");
INSERT INTO mif_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ndəhay ga a samawa a cakay a, aa guzlam da ray a, a ləvam: «Jaŋ-Baptis na, ta key maazla kwa dey pal daa ba, ama mey masa aa maa guzlda da ray ndaw aha keɗe na, ara mey fara fara, membərzley da hwaɗ a daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Anda keɗe, ndəhay ga feteɗe a pamara Yesu ŋga ndaw ata fara fara. ");
INSERT INTO mif_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ndaw da slala Betani daha mezəley Lazar. Dam-mamaha hay cew daha, ara ata Marta ta *Mari. Mari a na, ara ŋgwas masa ma wucar ɓərdey fa salay ŋga Bay Mahura Yesu, ma takwaɗa ta eŋgwec ŋga ray aŋga heyey. Pas pal daha, vaw a car a Lazar. ");
INSERT INTO mif_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Dam-mamaha hay a, ta’, a sləram ndaw fa Yesu ŋga ləvmar: «Bay aɗaw, jam akah masa kah ma wuɗa kalah heyey na, aa maaya daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu ma cənda mey a la na, ta’, a ləvtar a gula aŋga hay: «Macay ŋga Lazar a na, fa da kəɗa daa ba. Ama a key amba a wuzdərwa gədaŋ ŋga Bay Gazlavay, asaya, amba ndəhay a həslmaya ray, yah, Bəzey aŋga.» ");
INSERT INTO mif_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu na, a wuɗta ata Marta ta Mari leŋ Lazar a kalah. ");
INSERT INTO mif_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ama, masa aa ma cənda Lazar aa daa macay na, ta ŋgene he cəpa, aa manjakaya daa slam aha cəŋga haa ɗar cew. ");
INSERT INTO mif_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Fa dəɓa ha, ta’, a ləvtar a gula aŋga hay: «Vəhkwa aa hwayak ŋga *Jude.» ");
INSERT INTO mif_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Gula aŋga hay a, a mbəɗdamara, a ləvmar: «Kay! Bay ala, daa ɗar hay a keɗe na, *Jəwif hay siya feteɗe fa səpmaka ŋgaa zekey ta aŋgwa vagay, ba diya? Kaa ka wuɗey ya vəhkwa a Jude saya na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu a ləvtar: «Daa mevərndey pal na, ɓərey kuraw a ray a cew, ba diya? Fara fara, da ndaw a pəkey taa pas na, a hətar dey maaya maaya, a təɗey ba, maja slam fa weɗey. ");
INSERT INTO mif_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yaw, da ndaw a pəkey ta tavaɗ na, a təɗey maja ləvaŋ.» ");
INSERT INTO mif_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Masa aŋga maa guzley anda keɗe na, ta’, a ləvtar saya: «Jam aləkwa Lazar ta ney sem aa ɗar, ama ya daw la ŋga sləkɗadərwa.» ");
INSERT INTO mif_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Gula aŋga hay a, a mbəɗdamara, a ləvmar: «Bay ala, da a key a ney aa ɗar na, a sləkɗey la.» ");
INSERT INTO mif_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Fara fara, Yesu a wuɗey ŋga ləvtar na, Lazar ta məcey sem, ama gula aŋga hay a, a cəndamara na, anda ara ɗar fara gway. ");
INSERT INTO mif_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ta’, Yesu a kadatara mabara ŋga mey a dəɓa, a ləvtar: «Lazar ta məcey sem. ");
INSERT INTO mif_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ya faa səmey maja yah ma daw fa Lazar a daa ba araŋ. Wure keɗe amba ka təɓmara mey aɗaw na, nakwa la fa vəɗa.» ");
INSERT INTO mif_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Anda keɗe, *Tuma masa ata ma zəlmara Didim a ləvtar a gula hay siya: «Nakwa la, aləkwa may, amba ya məckurwa bama ta Bay aləkwa.» ");
INSERT INTO mif_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Masa Yesu ma wusey cay a Betani heyey na, a cənda Lazar ta key ɗar məfaɗ cay daa cəvay. ");
INSERT INTO mif_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Ndəhay *Jəwif hay ga ta samawa la da *Jeruzelem aa vagay a, maja slala Betani ta Jeruzelem na, ata gweegwe, a key kəlemeeter maakar gway. A samawa ŋga camatar har ŋgada ata Marta ta *Mari maja vagay ŋga məlma ata ha. ");
INSERT INTO mif_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Masa Marta ma cənda Yesu fa sawa na, ta’, a hway ŋga cadərwa ray. Mari na, manjakaya da way. ");
INSERT INTO mif_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta a ləvar a Yesu a: «Bay Mahura, da kah ma sawa la fiyaw na, anja məlma aɗaw fa da məcey daa ba. ");
INSERT INTO mif_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ta ŋgene he cəpa, ya səra, kwa wure keɗe cek masa kah maa cəfɗey fa Gazlavay na, a vəldakawa la.» ");
INSERT INTO mif_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ta’, Yesu a mbəɗdara, a ləvar: «Məlmakw a na, a sləkɗawa la daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta a ləvar: «Ahaw, ya səra na, a sləkɗawa la ta pas mendəvey ŋga bəla, masa ndəhay tabiya ma da sləkɗamawa daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ta’, Yesu a mbəɗdara, a ləvar: «Yah, ray aɗaw na, ya sləkɗadatərwa ndəhay daa meməcey, asaya, ya vəltar heter mendəvey ba. Ndaw ma paya ŋga ndaw aŋga fara fara na, kwa a məcey na, a sləkɗawa la daa meməcey a. ");
INSERT INTO mif_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Asaya, ndaw ma hətey heter mendəvey ba ha maja aa ma paya ŋga ndaw aŋga fara fara na, fa da məcey daa ba ŋga sərmataw. Ka wulkey da ray mey a keɗe na, kwara? Ka təɓa mey a, aa mevel akah daw?» ");
INSERT INTO mif_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta a mbəɗdara, a ləvar: «Ahaw, Bay Mahura, ya təɓa. Ya səra kah na, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay. Kah na, Bəzey ŋga Gazlavay, ndaw masa aa ma ləvey a sawa la a bəla heyey.» ");
INSERT INTO mif_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Masa Marta maa guzley la anda keɗe na, ta’, a vəhey a way. Aa səkar mey a *Mari, a ləvar: «Bay Mahura ta sawa la, faa cəfɗaka.» ");
INSERT INTO mif_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari a cənda na, ta’, a sləkɗey wure ŋgene, a daw fa Yesu, ");
INSERT INTO mif_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","maja Yesu a na, ta wusey a slala ha daa ba araŋ, ama aŋga daa slam masa Marta ma cadərwa ray heyey cəŋga. ");
INSERT INTO mif_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","*Jəwif hay ma samawa ŋga camar har a Mari heyey, a nəkmara na, Mari ta sləkɗawa sem da way, a bawa fiyaw. A wulkam na, Mari a, a daw a mey cəvay ŋga təwawa. Ta’, a səpmar wurzay. ");
INSERT INTO mif_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mari a wusey aa slam masa Yesu aa da hwaɗ a. Aŋga ma hətar Yesu a na, ta’, a təɗey asi salay aŋga, a ləvar: «Bay Mahura, da kah ma sawa la fiyaw na, anja məlma aɗaw fa da məcey daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu a nəka na, ata Mari ta Jəwif hay da cakay a heyey, fa təwam. Da ray ŋgene, mevel ŋga Yesu a kuɗferey, ");
INSERT INTO mif_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","aa cəfɗata, a ləvtar: «Ka jəhmara vagay a na, dama?» A mbəɗdamara, a ləvmar: «Bay Mahura, sawa, nəka taw!» ");
INSERT INTO mif_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu ta’, a təway. ");
INSERT INTO mif_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jəwif hay a, aa guzlam da wuzlah ata, a ləvam: «Nəkmara cey, fa təway, a wuɗa Lazar a kalah!» ");
INSERT INTO mif_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ama siya hay da wuzlah ata a ləvam: «Aŋga ma wurara dey ŋga ndaw-wulaf heyey na, kaa a gwa ŋga təka meməcey ŋga Lazar a ba daw?» ");
INSERT INTO mif_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Fa dəɓa ha, mevel ŋga Yesu a kuɗferey saya, ta’, a daw a mey cəvay heyey. Cəvay a na, ara vəgeɗ maavərkwakaya daa aŋgwa mahura, beeler da mey a. ");
INSERT INTO mif_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu a ləvtar: «Gədbalamara beeler da mey a.» Marta, dam-mamaŋ ŋga ndaw maməckaya ha, a mbəɗdara a Yesu, a ləvar: «Bay Mahura, a da zafandakwar, maja ta key ɗar məfaɗ cay daa cəvay.» ");
INSERT INTO mif_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu a mbəɗdara, a ləvar: «Ya ta ləvka daa ba daw? Da kah ma təɓa mey aɗaw la na, ka hətar gədaŋ ŋga Gazlavay la.» ");
INSERT INTO mif_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Fa dəɓa ha, ta’, a gədbalamara beeler heyey dəɓa. Yesu a baŋgaɗa dey a vaɗ, a ləvey: «Papay, ya kaka suse maja kah ma jəkfaya sləmay. ");
INSERT INTO mif_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ya səra ka fa jəkfaya sləmay mandaw mandaw, ama yaa guzley anda keɗe na, amba ndəhay da cakay aɗaw keɗe a təɓmara ara kah ma slərdiwa a bəla.» ");
INSERT INTO mif_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Masa Yesu maa guzley la anda keɗe na, ta’, a wudey ta gədaŋ, a ləvey: «Lazar, bawa!» ");
INSERT INTO mif_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lazar ndaw maməckaya heyey pat! a bawa, har ta salay majəwtakaya ta maslaga, yaw, dey aŋga may masərtakaya ta zana. Yesu a ləvtar a ndəhay: «Pəskamara, mbəkdamara ŋga daw.» ");
INSERT INTO mif_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","*Jəwif hay tabiya ma samawa ŋga camar har a *Mari heyey ta hətmar maazla masa Yesu ma ka la. Siya hay da wuzlah ata a pamara Yesu ŋga ndaw ata fara fara. ");
INSERT INTO mif_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ama ndəhay siya na, a diyam fa *Fariza hay, a kadamatara cek masa Yesu ma ka. ");
INSERT INTO mif_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Masa ata ma cəndamara cay na, ta’, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta Fariza hay a zəlmatərwa mahura hay masa ma sla yawa ŋga Jəwif hay ŋga kusey da ray mey a, a ləvmatar: «Ndaw a fa key maazla kalah kaa na, ya da kakwa na, kwara? ");
INSERT INTO mif_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Da mbak! ya mbəkdakwa ŋga key maazla hay anda keɗe na, ŋgene ndəhay tabiya a da təɓmara mey aŋga. Anda keɗe, mahura hay ŋga *Rawm a da samawa, a da pəlhamara Way-mekey-kwakwas aləkwa, asaya, a da paslamata ndəhay aləkwa hay.» ");
INSERT INTO mif_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ndaw pal da wuzlah ata daha mezəley Kayif. Ara *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay ta mevey a ŋgene. Ta’, aa guzltar, a ləvtar: «Akwar kaa na, kwa ka səram cek ba. ");
INSERT INTO mif_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Cəndamara, maaya na, ndaw pal a məcey maja aləkwa tabiya, da ray Rawma hay ma da samawa ŋga paslamandakwar tabiya daa hwayak aləkwa.» ");
INSERT INTO mif_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mey masa Kayif maa guzldatara ŋgene na, ara mewulkey aŋga ba. Ama maja ta mevey a ŋgene, aŋga mahura ŋga ndəhay ma ka kwakwas ŋga Gazlavay na, Gazlavay ta vəlar gədaŋ la ŋgaa guzley da ray cek ma da key: si Yesu a məcey maja Jəwif hay tabiya. ");
INSERT INTO mif_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yesu a məcey na, maja Jəwif hay daada ba, ama a məcey amba a cəmtar ray ŋga bəza hay ŋga Gazlavay masa maakwacatakaya ray da bəla cəpa ndav. ");
INSERT INTO mif_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Dəga ta pas ŋgene, a jəwmara mey ata ŋga kəɗey Yesu vagay. ");
INSERT INTO mif_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ara maja ŋgene, Yesu a mbəkda mepəkey da wuzlah Jəwif hay. Ta’, a daw aa slala feteɗe daha mezəley Efərayim gweegwe ta wuzlah-ley. A njam feteɗe ta gula aŋga hay. ");
INSERT INTO mif_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Daa ŋgene gwagway ŋga Jəwif hay mezəley «*Pak» gweegwe cay a wuswa. Ndəhay ga da slala hay mekele mekele a diyam a *Jeruzelem. A diyam na, dəga gwagway a araŋ amba a ɗiyam vaw, ŋga tərey maaya fa mey ŋga Gazlavay ŋga key gwagway a. ");
INSERT INTO mif_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ndəhay a, a səpmara Yesu. Masa ata daa *Way-mekey-kwakwas ŋga Gazlavay na, aa guzlam da wuzlah ata, a ləvam: «Ndaw aha, a sawa la aa gwagway a daw? A sawa daa ba daw? Ka wulkam na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aa guzlam anda keɗe na, maja bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta Fariza hay taa guzlmatar la, a ləvam: «Kwa waawa ma səra slam masa Yesu aa da hwaɗ a na, ŋga kada amba ma daw ma kərzarawa.» ");
INSERT INTO mif_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mendərey ɗar maakwaw ŋga key gwagway ŋga *Pak. Daa ŋgene, Yesu a sləkɗey, a daw a Betani. Betani na, ara slala ŋga Lazar, ndaw masa Yesu ma sləkɗadərwa daa meməcey heyey. ");
INSERT INTO mif_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Masa aŋga ma wusey la feteɗe na, ta’, a tamar ɗaf. Marta a həlra ɗaf a. Lazar aa da wuzlah ndəhay masa Yesu ma zəmamara ɗaf a bama. ");
INSERT INTO mif_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","*Mari a lawa reta ŋga liter ŋga ɓərdey mezəley «*nar», ɓərdey a, a həɗkey ba. Ta’, a mbəɗdara fa salay ŋga Yesu. Fa dəɓa ha, Mari a, a takwaɗa ta eŋgwec ŋga ray aŋga. Slam daa way a cəpa a zey ɓərdey a. ");
INSERT INTO mif_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Da ray ŋgene, gula pal da wuzlah *gula hay ŋga Yesu mezəley Juda Iskariyawt, ndaw ma da vəlda Yesu a har masa-gəra aŋga hay heyey, aa guzley, a ləvey: ");
INSERT INTO mif_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Anja a vəldandakwara ɓərdey a na, ya həɗkadakwa dala ga , ya vəldakwa dala ha ŋgada masa-viya hay, ba daw?» ");
INSERT INTO mif_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Aa maa guzley anda ŋgene na, ta wulkey ta masa-viya hay fara fara daa ba, ama a wuɗey ŋga lala dala ha maja aŋga ndaw-mayal. Ara aŋga ma kərza dala ŋga ata Yesu ta gula aŋga hay, fa dəɓa ha, a lala dala ha ŋgada aŋga. ");
INSERT INTO mif_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Maja ŋgene, Yesu aa guzlar, a ləvar: «Mbəkda ŋgwas aha cey! A key kaa na, a ɗiya vaw aɗaw ŋgadaa cəvay cay. ");
INSERT INTO mif_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Masa-viya hay na, akwar mandaw mandaw bama, ama yah na, ya fa da njey da wuzlah akwar ŋga mandaw mandaw daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","*Jəwif hay ga a cəndamara na, Yesu sem a Betani. Da ray ŋgene, ta’, a diyam a Betani a. A diyam na, maja Yesu daada ba, ama a wuɗam ŋga hətmərwa Lazar, ndaw masa Yesu ma sləkɗadərwa daa meməcey heyey, fa dey. ");
INSERT INTO mif_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Daa ŋgene, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay a jəwam mey da wuzlah ata ŋga kəɗey Lazar vagay may. ");
INSERT INTO mif_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","A jəwmara mey a na, maja ndəhay Jəwif hay ga fa təɓmara mey ata daa saba. Ama a təɓam na, mey ŋga Yesu dəɓa, maja aa ma sləkɗadərwa Lazar a daa meməcey. ");
INSERT INTO mif_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pepərek e, ndəhay ga ma diyam ŋga key gwagway ŋga *Pak da *Jeruzelem heyey, a cəndamara na, Yesu fa sawa a Jeruzelem e. ");
INSERT INTO mif_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Maja ŋgene, a ɗəslmawa mey-har hay ŋga wudez hay anda gendew, a diyam ŋga cadamərwa ray ta Yesu a. A wudam ta gədaŋ, a ləvam: «*Hawzana! Həlmakwa Bay Gazlavay! Anja Bay Gazlavay ŋga pəsar mey a Bay ŋga *Israyel hay, ndaw masa aa ma slərdərwa ta mezəley aŋga.» ");
INSERT INTO mif_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Feteɗe, Yesu a hətey bəz-zəŋgwaw daha, ta’, a təpey a ray a. Ara anda mawuzlalakaya daa ɗerewel ŋga Gazlavay zleezle, ma ləvey: ");
INSERT INTO mif_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Ndəhay daa berney ŋga *Siyaŋw, ka da zluram ba. Nəkmara, bay akwar fa sawa da ray bəz-zəŋgwaw.» ");
INSERT INTO mif_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Daa ŋgene, gula aŋga hay a cəndamara cek ma key da wuzlah ata ba. Ama, masa Yesu ma təpey la a vaɗ ŋga njey aa slam-meweɗey na, a sərfadamara anja mey ŋga Gazlavay maa guzley la da ray a, asaya, ndəhay ta kamar cek la a Yesu anda mey a maa guzley. ");
INSERT INTO mif_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ndəhay tabiya masa da cakay Yesu daa masa aa ma zəla Lazar daa cəvay, ta aa ma sləkɗadərwa daa meməcey heyey na, fa kadamara mey a ŋgada ndəhay siya. ");
INSERT INTO mif_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Maja ŋgene, ndəhay ga ma cəndamara mey a na, a samawa ŋga cadamara ray ta Yesu. A samawa na, maja ata ma cəndamara aŋga ma ka maazla ha. ");
INSERT INTO mif_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","*Fariza hay aa guzlam da wuzlah ata, a ləvam: «Ndaw a keɗe na, ya gwakwa a ray a ba! Ehe, nəkmara, ndəhay tabiya fa səpmar wurzay cəŋga!» ");
INSERT INTO mif_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ndəhay ma diyam a *Jeruzelem ŋga həlmey Bay Gazlavay daa gwagway ŋga *Pak na, Gərek hay da wuzlah ata daha may. ");
INSERT INTO mif_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Gərek hay a, a diyam a cakay *Fəlep, ndaw ma sawa da Betsayda daa hwayak ŋga *Galile. Ta’, aa guzlmar, a ləvmar: «Bay ala, ya wuɗam ŋga cey ray ta Yesu.» ");
INSERT INTO mif_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fəlep a sləkɗey, a daw aa guzlar a *Andəre. Fa dəɓa ha, ta’, a diyam cewete, aa guzlmar a Yesu. ");
INSERT INTO mif_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu a mbəɗdatara, a ləvtar: «Pas a ta wuswa cay amba Gazlavay a wuzdərwa gədaŋ aɗaw, yah, *Bəz ŋga Ndaw. ");
INSERT INTO mif_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ya fa ləvkwar fara fara, da hulfaɗ ŋga daw a kəzley a hwayak, ta pəshey daa ba na, a da njey salalay a kəne. Ama da ta pəshey sem aa hwiyak na, a pəcwa, a gəley, a key ray mahura. ");
INSERT INTO mif_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Anda keɗe, kwa waawa ma wuɗa heter aŋga na, a key ŋgene, aa zəɗda. Ama kwa waawa ma wuɗa heter aŋga ba da bəla keɗe na, a key ŋgene, a ɓada ŋga hətey heter mendəvey ba. ");
INSERT INTO mif_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kwa waawa ma wuɗey ŋga kaya sləra na, si a səpya. Aa slam masa yah ma da daw na, ndaw ma ka sləra aɗaw a sawa la asi aɗaw. Papay a da həslar ray ŋgada ndaw ma ka sləra aɗaw a.» ");
INSERT INTO mif_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Wure keɗe, ray aɗaw fa həɓey. Ya daa guzley na, ya ləvey me? Ya fa da ləvey, Papay, ləhdaya daa banay ma da sawa a ray aɗaw wure keɗe na, daa ba, maja ya sawa a bəla na, ŋga ɓəsa banay a keɗe. ");
INSERT INTO mif_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Papay, wuzdərwa gədaŋ akah amba ndəhay a həslmaka ray.» Maja ŋgene, ɗay a cənwa da gazlavay da vaɗ, a ləvey: «Yah ta wuzdərwa gədaŋ aɗaw cay, ama ya wuzdərwa la saya.» ");
INSERT INTO mif_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ndəhay makustakaya feteɗe ma cəndamara ɗay a na, aa guzlam, a ləvam: «Ara var maa bəcey.» Ndəhay siya a ləvam: «Ara maslaŋ ŋga Gazlavay da vaɗ maa guzlar.» ");
INSERT INTO mif_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ama Yesu aa guzltar, a ləvtar: «Ɗay a, aa guzlwa na, ŋgada yah ba, ama ŋgada akwar. ");
INSERT INTO mif_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Wure keɗe, pas a ta wuswa cay amba Gazlavay a katar sariya a ndəhay da bəla. Wure keɗe, pas a ta wuswa cay ŋga ɓəley bay-malula, ndaw ma wa bəla keɗe. ");
INSERT INTO mif_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ama yah, da ta baŋgaɗamaya cay fa hwadam mazlaŋgalakaya a vaɗ ŋga məcey na, ya da ŋgəlta ndəhay tabiya a cakay aɗaw.» ");
INSERT INTO mif_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu aa guzley anda keɗe na, a wuɗey a wuzda a da məcey na, kwara. ");
INSERT INTO mif_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Zagaba tabiya a mbəɗdamara, a ləvmar: «Ya ta jaŋgamara la daa ɗerewel ŋga kwakwas ala, a ləvey *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay na, a da njey ŋga sərmataw, ba diya? Kaa kah, ka ləvey a da baŋgaɗamara *Bəz ŋga Ndaw a vaɗ na, kwara? Bəz ŋga Ndaw a na, ara wa?» ");
INSERT INTO mif_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu a mbəɗdatara, a ləvtar: «Meweɗey aa da cakay akwar, a da njey nekəɗey gway. Daa masa meweɗey a, aa da cakay akwar keɗe na, pəkam da hwaɗ a, amba ləvaŋ a hətfakwar saba. Da ndaw fa pəkey daa ləvaŋ na, a səra slam masa aa ma da daw a hwaɗ a ba. ");
INSERT INTO mif_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Daa masa meweɗey a, aa da cakay akwar keɗe na, si ka təɓmara aa mevel akwar, amba ka təram ŋga ndəhay ŋga meweɗey.» Masa Yesu maa guzltar la anda keɗe na, ta’, a ŋgəchey dəreŋ ta ata, a ɓey. ");
INSERT INTO mif_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu ta key maazla hay la ga fa mey ŋga *Jəwif hay, ama ta ŋgene he cəpa, Jəwif hay a ta pamara Yesu ŋga ndaw ata fara fara daa ba cəŋga. ");
INSERT INTO mif_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Anda keɗe, mey masa *Izay, *ndaw ma təla mey ŋga Gazlavay, maa guzley zleezle da ray Yesu heyey na, ta key la. Izay a, a ləvey: «Bay Gazlavay, ma təɓa mey akah masa ala ma kadamara na, wa? Bay Gazlavay, ka wuzdərwa gədaŋ akah na, ŋgada wa hay wa?» ");
INSERT INTO mif_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yaw, Jəwif hay a ta gwamara ŋga təɓmara mey ŋga Yesu a daa ba. Ara anda Izay a maa guzley zleezle saya, a ləvey: ");
INSERT INTO mif_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Gazlavay ta wulfatara dey ata sem amba a hətmar dey saba. Ta rəzlta sem amba a sərmara leŋgesl saba. Anda keɗe, fa da mbəɗam dey ŋgada fa Gazlavay amba ya mbəldata na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Izay ma ləvey anda keɗe na, maja aa ma hətar gədaŋ ŋga Yesu, ta’, aa guzley da ray Yesu a. ");
INSERT INTO mif_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ta ŋgene he cəpa na, mahura hay ŋga Jəwif hay ga ta pamara Yesu la ŋga ndaw ata fara fara cəŋga, ama a wuzdamərwa a palah ba. A zluram ta *Fariza hay maja a da badamata daa *way-mewuzey-mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Anda keɗe, a wuɗam na, ndəhay ŋgaa həmdamata da ray Gazlavay ma daa həmdata jak. ");
INSERT INTO mif_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu aa guzley ta gədaŋ, a ləvey: «Ndaw ma paya ŋga ndaw aŋga fara fara na, a key ŋgene, a pey yah taava aɗaw ba, ama a pa ndaw ma slərdiwa ŋga ndaw aŋga fara fara may. ");
INSERT INTO mif_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yaw, ndaw ma hətya la na, ta hətar ndaw ma slərdiwa sem may. ");
INSERT INTO mif_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yah na, ndaw ma waɗa bəla. Ya ta sawa la amba kwa waawa ma paya ŋga ndaw aŋga fara fara na, a njey daa ləvaŋ saba. ");
INSERT INTO mif_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Da ndaw a cənda mey aɗaw, a pafar leŋgesl ba na, ŋgene ara yah ma da kar sariya ŋgaa zəɗda ba. Maja yah na, yah ma sawa a bəla ŋga katar sariya a ndəhay ŋgaa zəɗam daa ba. Ama ya sawa na, amba ndəhay da bəla a ləham daa mebərey. ");
INSERT INTO mif_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ndaw ma wuɗya ba, asaya, ndaw ma təɓa mey aɗaw ba na, cek ma da kar sariya na, daha: ara mey aɗaw ma da kərza ta sariya ta pas mendəvey ŋga bəla. ");
INSERT INTO mif_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mey masa yah ma kada na, ara mey aɗaw ba, ama ara Papay, ndaw ma slərdiwa, ma balayawa mey a amba yaa guzlda, ya wuzda a ndəhay. ");
INSERT INTO mif_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ahaw, ya səra na, mey aŋga a da vəlkwar heter mendəvey ba. Anda keɗe, mey masa yah ma kada na, ya kada anda Papay ma ləvya.» ");
INSERT INTO mif_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Masa gwagway ŋga *Pak anda mandaw na, Yesu a səra pas ŋga meməcey aŋga ta wuswa cay, a da mbəkda bəla keɗe, a da vəhey ŋgada fa Papaha. Yesu na, ta wuɗta ndəhay aŋga hay da bəla sem. Ta pas ŋgene aa fa wuzda na, a wuɗta kalah cəŋga. ");
INSERT INTO mif_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Taa kwaɗ a ŋgene, Yesu a zəmam ɗaf ta gula aŋga hay. Anja *Sataŋ, bay-malula, ta bata Juda, bəzey ŋga *Simaŋw Iskariyawt cay, amba Juda ha a vəlda Yesu a har masa-gəra aŋga hay. ");
INSERT INTO mif_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu na, fa səra Gazlavay Papaŋ ta vəldara gədaŋ sem ŋga wey da ray cek hay cəpa. A səra aŋga na, a sawa ta fa Gazlavay. Asaya, a səra pas pal a da vəhey fa Gazlavay a, a vaɗ. ");
INSERT INTO mif_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Da ray ŋgene, Yesu ta’, a mbəkda mezəmey ɗaf, a sləkɗey a cəkwa zana masa mahura fa vaw, ta’, a jəwey zana mekele aa laɓay. ");
INSERT INTO mif_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Cay, a kawa yam aa taasa, a pərtara salay ŋga gula aŋga hay, a takwaɗatara yam a ta zana majəwkaya daa laɓay heyey. ");
INSERT INTO mif_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesu a wusey ta’! fa Simaŋw *Piyer na, Simaŋw Piyer e, a ləvar: «Bay Mahura, kah ta ray akah, amba ka pəryawa salay daw?» ");
INSERT INTO mif_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu a mbəɗdara, a ləvar: «Cek masa yah ma ka keɗe na, ka səra mey da ray a wure keɗe ba araŋ. Ama ŋgada fa mey nekəɗey na, ka səra mey da ray a la.» ");
INSERT INTO mif_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyer a mbəɗdara saya, a ləvar: «Kay! Kah ta ray akah, ka pəryawa salay ba!» Yesu a ləvar: «Da ya ta pərkawa salay daa ba na, kwa ka fa da hətey cek fa yah daa ba may.» ");
INSERT INTO mif_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simaŋw Piyer a mbəɗdara, a ləvar: «Bay Mahura, da anda keɗe na, ka da pərya na, salay daada ba, ama pərtiwa har hay ta ray cəpa may.» ");
INSERT INTO mif_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu a ləvar saya: «Da ndaw ma pərey sem na, a wuɗey ŋga pərey vaw tabiya saba, si salay gway, maja dəlay fa vəɗa daa saba, ba diya? Akwar gula aɗaw hay na, akwar tabiya mapərtakaya ama si ndaw pal manda-pərey.» ");
INSERT INTO mif_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu maa guzley anda keɗe na, a səra ndaw ma da vəlda a har masa-gəra aŋga hay. Ara maja ŋgene, aŋga ma ləvey: «Akwar cəpa mapərtakaya ba.» ");
INSERT INTO mif_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Masa Yesu ma pərtara salay cay na, ta’, a kəzla zana aŋga mahura heyey fa vaw, a vəhey aa slam aŋga mezəmey ɗaf. Ta’, aa guzltar a gula aŋga hay a, a ləvtar: «Akwar ta sərmara cek masa yah ma kakwara keɗe la daw? ");
INSERT INTO mif_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nəka, akwar fa zəlmaya “Bay Mahura”, asaya, “ndaw maa sərkadakwar”. Ahaw, akwar maa guzlam la ara aŋga fara, yah na, ndaw maa sərkadakwar, asaya, yah Bay akwar Mahura. ");
INSERT INTO mif_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Anda keɗe, da yah Bay akwar Mahura, asaya, da yah ndaw maa sərkadakwar ma pərkwara salay na, si akwar may ka pəram salay ŋga ndaw a, ŋga ndaw a da wuzlah akwar may. ");
INSERT INTO mif_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yah ma ka anda keɗe na, amba ka kamara kəne may. ");
INSERT INTO mif_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ya fa ləvkwar fara fara, ndaw ma ka sləra ŋga ndaw na, a fəna bay ŋga sləra ha ba səlak, asaya, ndaw-meslərey na, a fəna ndaw ma slərda ba səlak. ");
INSERT INTO mif_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Wure keɗe akwar ma sərmara cay, da akwar fa kamara anda keɗe na, maaya ŋga Gazlavay a sawa la a ray akwar. ");
INSERT INTO mif_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Yah maa guzley anda keɗe na, da ray akwar cəpa ba. Ahaw, ndəhay masa yah ma walata na, ya səra mewulkey ata tabiya. Ama maaya na, mey mawuzlalakaya daa ɗerewel ŋga Gazlavay zleezle a key fara. Mey a, a ləvey: “Ndaw masa yah ma zəmam ɗaf cew e daa vəley pal ta tərey sem ŋga masa-gəra aɗaw.” ");
INSERT INTO mif_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ya kadakwara mey a la teeseɗ dəga wure keɗe amba da cek aha ma da key ŋgene ta wuswa cay na, ka sərmara “Yah na, ara Yah”. ");
INSERT INTO mif_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ya fa ləvkwar fara fara, ndaw ma təɓa ndaw masa yah ma slərda na, a key ŋgene, a təɓey na, yah, ray aɗaw. Yaw, da ndaw ta təɓya la na, a key ŋgene, a təɓey ndaw ma slərdiwa.» ");
INSERT INTO mif_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Masa Yesu maa guzley la anda keɗe na, ray aŋga a həɓey, a ləvey: «Ya fa ləvkwar fara fara, ndaw pal da wuzlah akwar a vəldaya la a har masa-gəra aɗaw hay ŋga kəɗmaya vagay.» ");
INSERT INTO mif_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Gula hay ŋga Yesu a nəkam vaw aa dey aa dey, ama kwa ta sərmara ndaw masa Yesu maa guzley da ray a na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Gula pal dasi ata manjakaya da cakay Yesu a, gula ha ara gula masa Yesu ma wuɗa kalah. ");
INSERT INTO mif_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","*Simaŋw *Piyer a kəɓcar dey a gula ha amba gula ha aa cəfɗa Yesu aa guzley na, da ray wa. ");
INSERT INTO mif_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ta’, gula ha a gənsley ŋgada fa Yesu, aa cəfɗa, a ləvar: «Bay Mahura, ma da vəldaka a har masa-gəra akah hay na, wa?» ");
INSERT INTO mif_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu a mbəɗdara, a ləvar: «Amba ya cey ɗaf, ya key lar fa vəɗa, ya təldara a ndaw. Ndaw a ŋgene na, ara ndaw ma da vəldaya a har masa-gəra aɗaw hay.» Yesu a cey ɗaf dəɓa, a key lar fa vəɗa, ta’, a təldara a Juda, bəzey ŋga Simaŋw Iskariyawt. ");
INSERT INTO mif_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Dəga daa masa Juda ha ma təɓa ɗaf da har Yesu a ŋgene na, wure wure ŋgene *Sataŋ, bay-malula, a mbəzey aa mevel ŋga Juda ha. Cay, Yesu ta’, aa guzlar dəɓa, a ləvar: «Cek masa kah ma wuɗey ŋga ka na, ka la fiyaw gway taw!» ");
INSERT INTO mif_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kwa ndaw pal dasi gula hay a ma səra Yesu aa guzlar anda ŋgene maja me na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gula hay siya a wulkam na, Yesu a wuɗey ŋga slərda Juda ha ŋga həɗkawa cek hay ŋga gwagway, da daa ba, aa cəfɗa ŋga vəltar cek a masa-viya hay maja ara aŋga ma kərza dala ata. ");
INSERT INTO mif_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Masa Juda ma təɓa ɗaf da har Yesu heyey la na, ta’, a bawa fiyaw aa ambaw. Daa ŋgene, tavaɗ ta key cay. ");
INSERT INTO mif_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Masa Juda ma bawa sem aa ambaw heyey na, Yesu aa guzley a ləvey: «Dəga wure keɗe, gədaŋ aɗaw, yah, *Bəz ŋga Ndaw, fa wuzwa amba ndəhay a həslmaya ray. Asaya, yah, Bəz ŋga Ndaw, ya fa wuzda gədaŋ ŋga Gazlavay amba ndəhay a həslmar ray. ");
INSERT INTO mif_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Maja ya fa wuzda gədaŋ ŋga Gazlavay a ndəhay na, Gazlavay a da wuzda gədaŋ aɗaw a ndəhay may. Gweegwe cay a wuzdərwa gədaŋ a. ");
INSERT INTO mif_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bəz aɗaw hay, ya fa da njey ta akwar ga daa saba. Ka da səpmaya, ama ya ləvkwar anda yah ma ləvtar a mahura hay ŋga *Jəwif hay heyey: Aa slam masa yah ma da daw na, akwar fa da gwamara ŋga diyam a hwaɗ a daa ba. ");
INSERT INTO mif_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ehe, ya vəlkwar *mewey mawiya: Wuɗam vaw. Maaya na, ka wuɗam vaw anda yah ma wuɗkwar keɗe. ");
INSERT INTO mif_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Da masa akwar fa wuɗam vaw na, ndəhay tabiya a sərmara la akwar gula aɗaw hay.» ");
INSERT INTO mif_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","*Simaŋw *Piyer aa cəfɗa Yesu, a ləvar: «Bay Mahura, ka da daw na, ama?» Yesu a mbəɗdara, a ləvar: «Aa slam masa yah ma da daw keɗe na, ka gwa ŋga səpya wure keɗe ba araŋ, ama ka səpya la fa dəɓa ha.» ");
INSERT INTO mif_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyer a ləvar: «Bay Mahura, ya gwa ŋga səpka wure keɗe ba na, maja me? Si ya məcey maja akah.» ");
INSERT INTO mif_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu a mbəɗdara, a ləvar: «Kah na, ka gwa ŋga məcey maja yah fara daw? Ya fa ləvka fara fara, wuskwaa gwagwalak a da cey ɗay na, ka ta ləvey cay dey maakar, ka sərya ba, ka sərya ba.» ");
INSERT INTO mif_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu aa guzltar a gula aŋga hay, a ləvtar: «Ka daa ləkam saba. Pamara Gazlavay ŋga ndaw akwar fara fara, asaya, pamaya ŋga ndaw akwar fara fara may. ");
INSERT INTO mif_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Fa Papay Bay Gazlavay da vaɗ na, slam hay ŋga njey suha daha. Ara maja ŋgene, yah maa guzlkwar, ya ləvkwar: “Ya da daw ŋga ɗiykwar slam da vaɗ.” ");
INSERT INTO mif_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Masa yah ma daw cay ŋga ɗiykwara slam aha na, ya vəhwa la ŋga ŋgəlkwar amba ka njam aa slam masa yah ma da njey a hwaɗ a may. ");
INSERT INTO mif_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Slam masa yah ma da daw a hwaɗ a na, ka sərmara cəveɗ e.» ");
INSERT INTO mif_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","*Tuma aa cəfɗa, a ləvar: «Bay Mahura, slam masa kah ma da daw a hwaɗ a na, ya sərmara ba. Kaa wara ya da sərmara cəveɗ e na, kwara?» ");
INSERT INTO mif_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu a mbəɗdara, a ləvar: «Yah na, cəveɗ ma handata ndəhay ŋgada fa Gazlavay. Yah na, ndaw ma wuzda mey fara fara da ray Gazlavay. Asaya, yah na, ndaw ma vəltar heter mendəvey ba a ndəhay. Da ndaw a wuɗey ŋga daw fa Papay na, si a sawa ta fa yah. ");
INSERT INTO mif_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Da ka sərmaya na, ka sərmara Papay la may. Dəga tasana, ka sərmara Papay a, akwar ta hətmar la ta dey akwar.» ");
INSERT INTO mif_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","*Fəlep a ləvar: «Bay Mahura, wuzdandara Papakw a na, cay gway taw!» ");
INSERT INTO mif_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu a mbəɗdara, a ləvar: «Dəga zleezle aləkwa bama kaa na, ka sərya ba cəŋga daw, Fəlep? Ndaw ma hətya la na, a key ŋgene, a hətey Papay a gway. Kaa ka ləvya wuzdandara Papay a na, maja me dəɓa me? ");
INSERT INTO mif_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yah ta Papay, asaya, Papay aa ta yah na, ka səra ba daw? Mey cəpa masa yah maa guzldakwara tabiya keɗe na, a sawa ta fa yah ba. Ama ara Papay masa aa ta yah heyey ma ka sləra aŋga. ");
INSERT INTO mif_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Təɓmara mey aɗaw masa yah ma ləvkwar, yah ta Papay, Papay may aa ta yah. Da ka təɓmara maja yah maa guzlkwar keɗe ba na, təɓmara maja maazla hay masa yah ma kata tarah taw! ");
INSERT INTO mif_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ya fa ləvkwar fara fara, ndaw ma paya ŋga ndaw aŋga fara fara na, a kata maazla hay masa yah ma kata la may. A da key maazla hay mahura ma fəna, maja yah na, ya da vəhey a cakay Papay a vaɗ. ");
INSERT INTO mif_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Cek hay tabiya masa akwar maa cəfɗamara ŋga key ta mezəley aɗaw na, ya kakwara la amba yah, Bəz ŋga Ndaw, ya wuzdatara gədaŋ ŋga Papay a ndəhay amba a həslmar ray. ");
INSERT INTO mif_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yaw, da akwar faa cəfɗafamaya cek ŋga key ta mezəley aɗaw na, ya kakwara cek aha la.» ");
INSERT INTO mif_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu aa guzltar a gula aŋga hay saya, a ləvtar: «Da akwar fa wuɗmaya na, si ka namar ray a *mewey aɗaw. ");
INSERT INTO mif_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ya dərar daŋgay la a Papay amba a slərkwar ndaw mekele ŋga jənkwar. Ndaw a, a da njey ta akwar ŋga sərmataw. ");
INSERT INTO mif_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ara Mesəfney ma wuzda mey masa fara fara da ray Gazlavay. Ndəhay da bəla a gwamara ŋga təɓmara daa ba, maja a hətmar ta dey ata daa ba, asaya, a sərmara ba. Ama akwar na, ka sərmara, maja aŋga da wuzlah akwar, asaya, aa daa akwar. ");
INSERT INTO mif_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Ya fa da mbəkdakwar taava akwar anda matawak hay na, daa ba. Ya vəhwa la a wuzlah akwar. ");
INSERT INTO mif_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Menjey nekəɗey feɗe, ndəhay da bəla keɗe fa da hətmaya daa saba. Ama akwar na, ka hətmaya la maja yah ta dey. Akwar may, ka da njam ta dey anda yah. ");
INSERT INTO mif_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Da pas a ta wuswa cay na, ka sərmara la, Papay aa ta yah, akwar ta yah, yah may, yah ta akwar. ");
INSERT INTO mif_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Ndaw ma təɓa mewey aɗaw, asaya, ma nar ray na, ndaw a ŋgene a wuɗya. Nəka, Papay na, a wuɗa ndaw ma wuɗya. Yah may, ya wuɗa ndaw masa ma wuɗya, ya wuzar vaw ŋgada aŋga.» ");
INSERT INTO mif_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ta’, Jud aa cəfɗa, a ləvar: «Bay Mahura, ka da wuzey vaw na, ŋgada ala gway, ama ŋgada ndəhay da bəla cəpa ba na, maja me?» Maa cəfɗa ha na, ara Jud mekele, ba na, ara Juda Iskariyawt ba. ");
INSERT INTO mif_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu a mbəɗdara, a ləvar: «Ndaw ma wuɗya na, a cənya mey la may. Anda keɗe, Papay a wuɗa la may. Ala ta Papay ya da diyam fa ndaw aha, ya da njam daa slam a. ");
INSERT INTO mif_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ndaw ma wuɗya ba na, a cənya mey daa ba may. Mey masa yah maa guzlda keɗe na, ara mey aɗaw ba, ama ara mey ŋga Papay, ndaw ma slərdiwa. ");
INSERT INTO mif_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Ya fa kadakwara cek hay a tabiya, daa masa yah da wuzlah akwar keɗe ɗagay. ");
INSERT INTO mif_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Cay na, Papay a slərkwar Mesəfney aŋga la ta mezəley aɗaw. Ara Mesəfney a ma da jənkwar. A daa sərkadakwara cek hay tabiya. Asaya, a da sərfadakwara mey hay cəpa masa yah ma kadakwara. ");
INSERT INTO mif_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Ya mbəkdakwar daa zazay, njam ta zazay aɗaw. Zazay aɗaw a na, aŋga wal ta zazay ŋga ndəhay da bəla. Anda keɗe, ka daa ləkam ba, ka da zluram ba. ");
INSERT INTO mif_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Akwar ma cəndamara la, yah ma ləvey: “Ya daw la fa Papay, fa dəɓa ha, ya vəhwa la fa akwar, ba diya?” Da ka wuɗmaya na, ŋgene, kaa səmam la da ray yah ma da daw fa Papay a, maja Papay na, aa mahura da ray aɗaw. ");
INSERT INTO mif_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ya kadakwara mey a la teeseɗ dəga wure keɗe amba da cek aha ma da key ŋgene ta wuswa cay na, ka təɓmara mey aɗaw ma fəna. ");
INSERT INTO mif_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kwa ya fa daa guzlkwar ga daa saba, maja bay-malula, ndaw ma wa bəla keɗe, fa sawa. Ama kwa fa da gwa ŋga kaya cek daa ba səlak. ");
INSERT INTO mif_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ama a sawa na, amba ndəhay da bəla a sərmara ya fa wuɗa Papay, asaya, ya fa kata cek hay tabiya anda aŋga ma ləvya ŋga kata. Yaw, lacam! Nakwa la!» ");
INSERT INTO mif_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu aa guzltar a gula aŋga hay, a ləvtar: «Yah na, wudez masa fara fara ma yey babəza maaya. Bay ŋga wudez e na, ara Papay. ");
INSERT INTO mif_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mey-har aɗaw hay cəpa masa ma yam babəza ba na, Papay a ɗəslta. Ama masa ma yam babəza na, aa kəlhata amba a yam babəza ma fəna. ");
INSERT INTO mif_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mey masa yah ma wuzdakwara keɗe na, ta pərkwara mevel akwar sem. ");
INSERT INTO mif_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Njam macəmkaya ta yah anda yah manjakaya macəmkaya ta akwar. Mey-har ŋga wudez maɗəslkaya sem na, a gwa ŋga yey babəza saya daw? Aŋga letek kəne, da akwar macəmkaya ta yah daa ba na, ka da təram cek ŋga tede. ");
INSERT INTO mif_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Yah na, wudez. Akwar na, mey-har hay a. Da ndaw macəmkaya ta yah, yah may macəmkaya ta ndaw aha na, menjey ŋga ndaw aha a key la maaya fa mey ŋga Gazlavay. Maja da akwar macəmkaya ta yah daa ba na, akwar fa da gwamara ŋga key kwa meeme daa ba səlak. ");
INSERT INTO mif_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Da ndaw aa macəmkaya ta yah daa ba na, a da hazakadamara ndaw aha ta cakay anda mey-har hay ŋga wudez maɗəsltakaya ma hazakadamara ta cakay, fa dəɓa ha, a kweley. A kusmamara, a pam awaw fa vəɗa ŋga wewurey. ");
INSERT INTO mif_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Da akwar macəmkaya ta yah, asaya, da akwar fa təɓmara mey aɗaw mandaw mandaw na, cacəfɗam kwa cek wura wura, ka hətam la. ");
INSERT INTO mif_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Da akwar fa kam maaya mandaw mandaw na, ndəhay a sərmara la akwar gula aɗaw hay. Anda keɗe, ndəhay a da həlmamara Papay maja. ");
INSERT INTO mif_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ya fa wuɗkwar anda Papay ma wuɗya may. Njam daa mewuɗey-vaw aɗaw. ");
INSERT INTO mif_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Da akwar fa namar ray a mewey aɗaw na, ka njam la daa mewuɗey-vaw aɗaw. Ara anda yah ma nar ray a mewey ŋga Papay, yah manjakaya daa mewuɗey-vaw aŋga may. ");
INSERT INTO mif_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Yaa guzlkwar anda keɗe na, amba kaa səmam anda yah maa səmey keɗe may, asaya, amba ka njam daa meesəmey masa fara fara. ");
INSERT INTO mif_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ehe, ya kadakwara mewey aɗaw: Wuɗam vaw anda yah ma wuɗkwar keɗe. ");
INSERT INTO mif_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ndaw ma vəlda heter aŋga ŋga məcey maja jam aŋga hay na, ŋgene ara mewuɗey-vaw mahura. ");
INSERT INTO mif_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Da akwar fa kamara cek masa yah ma ləvkwar ŋga key na, ŋgene akwar jam aɗaw hay. ");
INSERT INTO mif_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ya fa da zəlkwar ndəhay ma ka sləra aɗaw hay daa saba maja ndaw ma ka sləra na, a səra cek masa bay aŋga ma key tabiya ba. Ama ya zəlkwar jam aɗaw hay, maja cek tabiya masa yah ma cəndərwa fa Papay na, ya ta wuzdakwara cay. ");
INSERT INTO mif_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ma walamaya ŋga key bay akwar na, ara akwar ba. Sasəkar jak, ara yah ma walakwar. Ya walakwar na, amba ka diyam, ka kamara sləra aɗaw, sləra ha a da njey ŋga sərmataw. Anda keɗe, Papay a da vəldakwara cek masa akwar maa cəfɗafamara ta mezəley aɗaw. ");
INSERT INTO mif_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Cek masa yah ma wuɗey fa akwar na, wuɗam vaw.» ");
INSERT INTO mif_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu aa guzltar a gula aŋga hay saya, a ləvtar: «Da ndəhay da bəla fa rəsmakwar na, sərmara a rəsam teeseɗ na, yah. ");
INSERT INTO mif_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Da akwar anda ndəhay da bəla keɗe na, anja a wuɗmakwar la maja akwar ndəhay ata hay. Ama akwar na, ndəhay ata hay ba, maja ara yah ma walakwar wal da wuzlah ata. Ata ma rəsmakwar na, maja. ");
INSERT INTO mif_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sərfadamara mey masa yah maa guzlkwar heyey: “Ndaw ma ka sləra ŋga ndaw na, a fəna bay ŋga sləra ha ba.” Da ta sərdamaya banay la na, a sərdamakwar banay la kəne may. Yaw, da ta cənmaya mey la na, a cənmakwar mey la may. ");
INSERT INTO mif_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","A da sərdamakwar banay a na, maja yah. A kamara anda keɗe na, maja a sərmara ndaw ma slərdiwa a bəla ba. ");
INSERT INTO mif_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Da yah ma sawa a bəla ŋga wuzdatara mey ŋga Gazlavay daa ba na, anja mebərey da ray ata ŋga kərzata daa ba. Ama wure keɗe masa yah ma sawa a bəla ŋga wuzdatara mey ŋga Gazlavay sem keɗe na, ata ta mey ŋgaa guzley ŋga ləhdata daa mebərey ata daa ba. ");
INSERT INTO mif_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ndaw ma rəsya na, a key ŋgene, a rəsa Papay may. ");
INSERT INTO mif_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yah ma key maazla hay masa ndaw ma gwa ŋga kata ba la da wuzlah ata. Anja da daa ba na, mebərey da ray ata daa ba. Ama wure keɗe masa ata ma hətmatar maazla hay a ta dey ata la kaa na, a rəsmandar ta Papay cəŋga gway. ");
INSERT INTO mif_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ama cek aha, a key anda mawuzlalakaya daa kwakwas ata, ma ləvey: “A rəsmaya ŋga tede gway.”» ");
INSERT INTO mif_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Yesu aa guzltar a gula aŋga hay saya, a ləvtar: «Sərmara, ndaw ma da jənkwar a sawa la. A da sawa ta fa Papay. Masa yah ma daw cay a cakay Papay na, ya slərdakwara la. Ndaw aha na, ara *Mesəfney ŋga Gazlavay, a da wuzdatara cəveɗ masa fara fara a ndəhay. A da key sede da ray aɗaw. ");
INSERT INTO mif_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Akwar may, ka da kam sede da ray aɗaw, maja dəga yah ma zla sləra aɗaw na, aləkwa bama haa wure keɗe. ");
INSERT INTO mif_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Yah ma ləvkwar anda keɗe na, amba kwa da fa sərdamakwar banay na, ka təɓmara mey aɗaw cəŋga, ka mbəkdamara ba. ");
INSERT INTO mif_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","A da ɓəlmakwar daa way-mewuzey-mey hay ŋga Gazlavay. Asaya pas a, a wuswa la masa ndəhay ma da kəɗmakwar vagay na, a wulkam a key ŋgene, a kamar cek maaya ŋgada Gazlavay. ");
INSERT INTO mif_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A da kam cek maaya ba anda keɗe na, maja ta sərmara Papay daa ba, asaya, maja ta sərmaya daa ba may. ");
INSERT INTO mif_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ama ya wuzdakwara anda keɗe na, amba da pas a ta wuswa cay, fa kamakwar anda keɗe na, ka sərfadamara yah ma wuzdakwara cay la.» Yesu aa guzltar saya, a ləvtar: «Dəga yah ma zla sləra aɗaw, yah ma wuzdakwara mey a daa ba na, maja yah daha da cakay akwar ɗagay. ");
INSERT INTO mif_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Wure keɗe, ya da daw a cakay ndaw ma slərdiwa, kwa ndaw pal dasi akwar ma daa cəfɗaya: “Ka daw ama?” na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ama akwar ta mewulkey kalah maja yah ma ləvkwar anda keɗe he. ");
INSERT INTO mif_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yaw, ya faa guzlkwar mey masa fara fara, aŋga maaya ŋgada akwar amba ya vəhey fa Papay a vaɗ. Fara fara, da ya ta vəhey daa ba na, *Mesəfney ŋga Gazlavay, ndaw ma da jənkwar heyey, fa da sawa daa ba. Ama da ya ta vəhey la na, ya slərdakwara la. ");
INSERT INTO mif_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Da ta wuswa cay na, a da wuzdatara a ndəhay da bəla mey masa fara fara amba a sərmara mebərey ata, amba a sərmara cəveɗ masa maaya, asaya, amba a sərmara sariya masa Gazlavay ma da ka. ");
INSERT INTO mif_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","A da sərmara mebərey ata na, maja ata ma pamaya ŋga ndaw ata fara fara ba. ");
INSERT INTO mif_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","A da sərmara cəveɗ masa maaya na, maja ya fa da vəhey ŋgada fa Papay, akwar fa da hətmaya daa saba. ");
INSERT INTO mif_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A da sərmara sariya masa Gazlavay ma ka na, maja Gazlavay ta kar sariya cay a bay-malula, ndaw ma wa bəla keɗe. ");
INSERT INTO mif_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Ya fa wuɗey ŋgaa guzlkwar da ray cek hay ga, ama wure keɗe na, aŋga ta banay amba ka cəndamara. ");
INSERT INTO mif_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Da masa Mesəfney ma wuzda mey masa fara fara da ray Gazlavay heyey ta wuswa cay na, a da wuzdakwara mey masa fara fara da ray cek hay tabiya. Mey masa aa ma daa guzlda na, a sawa ta fa gədaŋ aŋga ba. Ama a daa guzley mey masa aŋga ma cəndərwa da vaɗ. A da wuzdakwara cek ma da key ŋgada fa mey. ");
INSERT INTO mif_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mesəfney a na, a da wuzdərwa gədaŋ aɗaw amba ndəhay a həslmaya ray maja cek hay tabiya aa ma wuzdakwara na, a cəndərwa fa yah. ");
INSERT INTO mif_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Cek hay tabiya masa Papay ma wata na, yah ma wata may. Ara maja ŋgene, yah maa guzlkwar, ya ləvey cek hay tabiya masa Mesəfney a ma wuzdakwara na, a cəndərwa fa yah.» ");
INSERT INTO mif_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu aa guzltar a gula aŋga hay saya, a ləvtar: «Menjey nekəɗey feɗe, akwar fa da hətmaya fa dey daa saba. Fa dəɓa ha nekəɗey na, ka hətmaya la saya.» ");
INSERT INTO mif_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Maja ŋgene, gula aŋga hay siya aa guzlam da wuzlah ata, a ləvam: «Aa guzlndakwar, a ləvey: “Menjey nekəɗey feɗe, ka hətmaya fa dey daa saba. Fa dəɓa ha nekəɗey na, ka hətmaya la saya.” Yaw, a ləvey saya: “Ya da daw fa Papay a vaɗ.” Mey hay a keɗe na, a wuɗey ŋga ləvey me? ");
INSERT INTO mif_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","A ləvey: “Menjey nekəɗey” na, a wuɗey ŋga ləvey me? Mey a, a cəney ba.» ");
INSERT INTO mif_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu a səra gula aŋga hay fa wuɗam ŋgaa cəfɗamara. Anda keɗe, ta’, aa guzltar, a ləvtar: «Ya taa guzlkwar la, ya ləvkwar: “Menjey nekəɗey feɗe, akwar fa da hətmaya fa dey daa ba. Fa dəɓa ha nekəɗey na, ka hətmaya la saya.” Kaa cəfɗam vaw da wuzlah akwar na, ŋga sərey mey a keɗe daw? ");
INSERT INTO mif_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ya fa ləvkwar fara fara, cay na, ka təwam la, kaa huram la da wuzlah akwar, ama ndəhay da bəla siya na, aa səmam la. Ka laləkam la, ama fa dəɓa ha, kaa səmam la. ");
INSERT INTO mif_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","«Wulkam da ray ŋgwas ta hwaɗ taw! Da masa fa da yey na, hwaɗ a, a sərda banay. Ama da bəzey ta yawa cay na, a sərfada banay a saba, aa səmey maja aa ma hətey bəzey mawiya. ");
INSERT INTO mif_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Wure keɗe akwar may, daa mewulkey, ama ya hətkwar la saya. Anda keɗe, ka daa səmam, kwa ndaw ma da təkakwar ŋgaa səmey a daa ba səlak. ");
INSERT INTO mif_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ta pas a ŋgene, ka sərmata cek hay cəpa la, akwar fa daa cəfɗafamaya ŋga sərey cek daa saba. Yaw, ya fa ləvkwar fara fara, da kaa cəfɗam kwa meeme fa Papay ta mezəley aɗaw na, Papay a, a vəldakwara la. ");
INSERT INTO mif_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Haa wure keɗe, ka taa cəfɗam cek ta mezəley aɗaw daa ba araŋ. Anda keɗe, cacəfɗam cek, ka hətam la amba ka njam daa meesəmey masa fara fara.» ");
INSERT INTO mif_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesu aa guzltar a gula aŋga hay saya, a ləvtar: «Yah maa guzlkwar tabiya na, ta mey-meŋgey. Yaw, pas a, a wuswa la masa yah ma daa guzlkwar ta mey-meŋgey saba, ya da kadakwara mabara ŋga mey da ray Papay. ");
INSERT INTO mif_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ta pas ŋgene na, ka daa cəfɗam cek fa Papay ta mezəley aɗaw. Ka da wulkam ara yah ma daa cəfɗakwara Papay kwa? Kay, kəne ba, ama ara akwar ta ray akwar ma daa cəfɗamara, ");
INSERT INTO mif_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","maja Papay a ta ray aŋga a wuɗkwar. A wuɗkwar na, maja akwar ma wuɗmaya, asaya, maja akwar ma təɓmara ya sawa na, da fa aŋga. ");
INSERT INTO mif_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ya sawa a bəla keɗe na, da cakay Papay. Wure keɗe, ya da mbəkda bəla ha, ya da vəhey ŋgada fa Papay a.» ");
INSERT INTO mif_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Gula aŋga hay a mbəɗdamara, a ləvmar: «Nəka, wure keɗe, ka fa wuzdərwa mey a maaya maaya, ka faa guzley ta mey-meŋgey daa saba. ");
INSERT INTO mif_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Wure keɗe, ala fa sərmara, kah na, ka sərta cek hay tabiya. Cek masa ndaw ma wuɗey ŋgaa cəfɗaka na, ka ta səra sem. Maja ŋgene, ya təɓmara, kah na, ka sawa da fa Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu a mbəɗdatara, a ləvtar: «Wure keɗe na, akwar ma təɓmara la, ya sawa da fa Gazlavay dəɓa daw? ");
INSERT INTO mif_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yaw, pas a, a sawa la, ta wuswa cay, masa akwar tabiya ka daa kwacam ray pal pal, kwa waawa a da daw a way aŋga, ka da mbəkdamaya taava aɗaw. Ama fara fara, yah taava aɗaw ba, maja Papay aa ta yah. ");
INSERT INTO mif_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yah maa guzlkwar mey tabiya keɗe na, amba akwar masa macəmkaya ta yah keɗe, ka njam daa zazay. Ka səram banay la da bəla keɗe, ama kam gədaŋ. Yah na, ya ta fəna bəla ha sem ta gədaŋ.» ");
INSERT INTO mif_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Fa dəɓa ha, Yesu maa guzltar cay a gula aŋga hay heyey na, ta’, a baŋgaɗa dey a vaɗ, a dərey daŋgay a Gazlavay, a ləvey: «Papay, pas masa yah ma da sərey banay na, ta wuswa cay. Wuzdərwa gədaŋ aɗaw, yah Bəzey akah, a ndəhay, amba yah may, ya wuzdərwa gədaŋ akah a ndəhay. ");
INSERT INTO mif_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ka ta vəlya gədaŋ la ŋga wey da ray ndəhay tabiya da bəla. Anda keɗe, ya da vəltar heter mendəvey ba ŋgada ndəhay masa kah ma vəldatiwa asi har aɗaw. ");
INSERT INTO mif_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Heter mendəvey ba ha na, ara amba ndəhay a sərmaka, kah na, Gazlavay pal masa fara fara, asaya, ara amba a sərmaya, yah Yesu *Kəriste masa kah ma slərdərwa. ");
INSERT INTO mif_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Masa yah da bəla keɗe na, ya ta wuzdatara gədaŋ akah cay a ndəhay. Asaya, yah ma ndəvda sləra masa kah ma vəldiwa ŋga key cay cəpa. ");
INSERT INTO mif_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Wure keɗe, Papay Bay Gazlavay, vəhdaya fa mey akah, həslya ray saya, anda kah ma həslya ray daa masa yah da cakay akah dəga bəla ta zlar ŋga ləmey daa ba araŋ heyey. ");
INSERT INTO mif_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Yah ma wuzdaka la a ndəhay masa kah ma walata da bəla ŋga njam asi har aɗaw, amba a sərmaka. Ahaw, ndəhay a na, ara ŋga akah hay, ama kah ma vəldatiwa la asi har aɗaw, anda keɗe, fa cənmaka mey. ");
INSERT INTO mif_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Wure keɗe, a sərmara cek hay tabiya masa ŋga yah na, a samawa ta fa kah. ");
INSERT INTO mif_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","A sərmara na, maja mey masa kah ma wuzdiwa na, yah ma wuzdatara la, ta cəndamara la. A sərmara fara fara ya sawa da fa kah, asaya, ta təɓmara la ara kah ma slərdiwa. ");
INSERT INTO mif_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Ya dərey daŋgay na, maja ndəhay a, ba na, maja ndəhay da bəla cəpa ba. Ahaw, ya dərey daŋgay maja ndəhay masa kah ma vəldatiwa asi har aɗaw. Ata na, ndəhay akah hay. ");
INSERT INTO mif_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yaw, ndəhay aɗaw hay tabiya na, ara ndəhay akah hay. Asaya, ndəhay akah hay tabiya na, ara ndəhay aɗaw hay. Ya fa wuzda gədaŋ aɗaw ta fa ndəhay masa kah ma vəldatiwa ha. ");
INSERT INTO mif_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Menjey nekəɗey feɗe, ya da mbəkda bəla. Ata na, ata da bəla keɗe mandaw mandaw. Ya da vəhey ŋgada fa kah. Papay Bay Gazlavay pal, nəkfatar dey ta gədaŋ akah, gədaŋ masa kah ma vəldiwa heyey. Anda keɗe, a da njam macəmkaya pal anda aləkwa cew e macəmkaya pal. ");
INSERT INTO mif_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Daa masa ala bama heyey na, ya ta nəkfatar dey la ta gədaŋ masa kah ma vəldiwa. Yah ma nəkfatar dey la, kwa ndaw pal taa zəɗey daa ba, si ndaw masa ma daa zəɗey cəŋga, anda mey ŋga Gazlavay mawuzlalakaya zleezle ma ləvey heyey. ");
INSERT INTO mif_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Papay, wure keɗe, ya fa da vəhey fa kah. Yaa cəfɗaka anda keɗe daa masa yah da bəla keɗe amba ndəhay a, aa səmam anda yah maa səmey, a njam daa meesəmey masa fara fara. ");
INSERT INTO mif_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yah na, yah ma wuzdatara mey akah la a ndəhay aɗaw hay, ama ndəhay siya da bəla fa rəsmata, maja ata na, ara ndəhay ŋga bəla saba. Yah may, yah ndaw ŋga bəla ba. ");
INSERT INTO mif_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Papay, ya taa cəfɗaka amba ka badata da bəla keɗe la na, daa ba, ama yaa cəfɗaka na, amba ka nəkfatar dey maja bay-malula a da katar cek maaya ba. ");
INSERT INTO mif_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ata na, ara ndəhay ŋga bəla keɗe ba anda yah ndaw ŋga bəla keɗe ba may. ");
INSERT INTO mif_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mey akah na, ara mey masa fara fara. Tərdata ndəhay a ŋga ndəhay akah hay ta fa mey akah masa fara fara ha. ");
INSERT INTO mif_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ehe, ya fa slərdata fa ndəhay da bəla anda kah ma slərdiwa may. ");
INSERT INTO mif_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yah na, ya vəldakawa heter aɗaw maja ata, amba ata may, a təram ndəhay akah hay fara fara ta fa mey akah masa fara fara keɗe. ");
INSERT INTO mif_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Ya dərey daŋgay na, maja ndəhay aɗaw hay keɗe daada ba, ama ya dərey daŋgay maja ndəhay ma da pamaya ŋga ndaw ata fara fara ta fa mey masa ata ma da wuzdamatara. ");
INSERT INTO mif_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Anda keɗe, maaya na, ndəhay a njam macəmkaya pal anda kah Papay, kah ta yah, yah may, yah ta kah. Maaya na, a njam ta aləkwa, amba ndəhay siya da bəla a sərmara ara kah ma slərdiwa. ");
INSERT INTO mif_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yah ma vəldatara gədaŋ masa kah ma vəldiwa heyey cay amba a njam macəmkaya pal anda yah ta kah macəmkaya pal may. ");
INSERT INTO mif_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yah macəmkaya ta ata anda kah macəmkaya ta yah. Anda keɗe, a da njam macəmkaya pal maaya maaya ma fəna, amba ndəhay siya da bəla a sərmara ara kah ma slərdiwa a bəla, asaya, amba a sərmara ka fa wuɗta anda kah ma wuɗya. ");
INSERT INTO mif_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Papay, ahaw, kah ma vəldatiwa ndəhay a la. Aa slam da vaɗ masa yah ma da njey a hwaɗ a na, ya wuɗey anja ya njam bama ta ata. Anda keɗe, a hətmar gədaŋ masa kah ma vəldiwa heyey la, aa səmam da ray a. Vəldiwa gədaŋ a, maja ka fa wuɗya dəga bəla ta ləmey daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Papay, ndaw ma ka cek ta cəveɗ e, ndəhay siya ga da bəla na, ta sərmaka daa ba araŋ. Yah na, ya ta sərka cay, asaya, ndəhay aɗaw hay ta sərmara cay ara kah ma slərdiwa a bəla. ");
INSERT INTO mif_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Papay, ya ta wuzdaka la a ndəhay aɗaw hay a, amba a sərmaka. Ya wuzdaka la amba a sərmaka cəŋga, amba a wuɗam vaw anda kah ma wuɗya kalah keɗe, asaya, amba ya njey macəmkaya ta ata.» ");
INSERT INTO mif_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Masa Yesu ma dərey daŋgay cay na, ta’, a diyam ta gula aŋga hay a dey laŋgar ŋga wayam ŋga Sedəraŋw. Feteɗe na, jerne daha. A mbəzam ta gula aŋga hay a, aa jerne he. ");
INSERT INTO mif_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yaw, Juda, ndaw ma da vəlda Yesu a har masa-gəra aŋga hay heyey, a səra slam aha, maja Yesu ta diyam la dey weewe a hwaɗ a ta gula aŋga hay a. ");
INSERT INTO mif_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Juda a ŋgəley sewje hay ga, asaya, a ŋgəley ndəhay ma jəɗa *Way-mekey-kwakwas ŋga Gazlavay. Ara *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta *Fariza hay ma slərdamata. Ta’, a diyam aa jerne he dəɓa. Ata cəpa ta cek hay ŋga vəram, ta petərla hay, leŋ awaw mandəvɗatakaya fa har fa har. ");
INSERT INTO mif_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu na, ta səra cek ma da hətfar sem. Da ray ŋgene, a ŋgəchey ŋgada fa ata, aa cəfɗata, a ləvtar: «Ka səpam na, wa?» ");
INSERT INTO mif_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","A mbəɗdamara, a ləvmar: «Ya səpam Yesu ndaw *Nezeret.» Ta’, a ləvtar: «Yesu a na, ara yah.» Juda, ndaw ma da vəlda Yesu a heyey, aa da wuzlah ata. ");
INSERT INTO mif_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Masa Yesu a maa guzley, ma ləvey: «Yesu a na, ara yah» heyey na, a zluram. Da ray ŋgene, a ŋgəcham ta dəɓa ta dəɓa, a təɗam zlambəla’-la’-la’ a hwayak. ");
INSERT INTO mif_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ta’, Yesu aa cəfɗata saya, a ləvtar: «Ka səpam na, wa?» A mbəɗdamara, a ləvmar: «Ya səpam Yesu ndaw Nezeret.» ");
INSERT INTO mif_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu a ləvtar: «Yah ma ləvkwar la Yesu a na, ara yah. Da ka səpam yah na, mbəkdamata ndəhay siya keɗe ŋga diyam!» ");
INSERT INTO mif_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A key anda keɗe na, amba mey ŋga Yesu daa medərey-daŋgay aŋga heyey a key. Mey a, a ləvey: «Kwa ya taa zəɗey ndaw pal dasi ndəhay masa kah ma vəldatiwa heyey na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","*Simaŋw *Piyer na, aŋga ta dəlaw da har. Ta’, a məɗərwa daa way a, a ŋgəma madərlam ŋga *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay kaa heyey, cərah! a cərhara sləmay ta dey ŋga zəmay. A zəlmara ndaw masa Simaŋw ma cərhara sləmay a na, Malkus. ");
INSERT INTO mif_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ama ta’, Yesu aa guzlar a Piyer, a ləvar: «Mada dəlaw akah aa way a. Ka wulkey banay masa Papay ma wuɗey ya səra na, ŋga wusfaya ba daw?» ");
INSERT INTO mif_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sewje hay ga ta *bay-ray ata leŋ ndəhay ma jəɗa *Way-mekey-kwakwas ŋga Gazlavay masa mahura hay ŋga *Jəwif hay ma slərdamata heyey na, a kərzamara Yesu dəɓa, a jəwmara. ");
INSERT INTO mif_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","A handamara teeseɗ na, a way Han . Han aha na, ara mesey ŋga Kayif. Kayif e may, ara ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay ta mevey a ŋgene. ");
INSERT INTO mif_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Daa ŋgene na, Kayif a taa guzltar la ŋgada mahura hay ŋga Jəwif hay, a ləvtar: «Maaya na, ndaw pal a məcey, da ray aləkwa Jəwif hay tabiya ma da paslakwa.» ");
INSERT INTO mif_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ata *Simaŋw *Piyer ta gula ŋga Yesu laŋgar daha a səpmar wurzay ŋga Yesu a. *Ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay a, a səra gula ŋga Yesu laŋgar a. Da ray ŋgene, ta’, gula ha a mbəzam ta Yesu a, a way ndaw mahura ha. ");
INSERT INTO mif_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ama Piyer na, aŋga ta daa ambaw, gweegwe fa mey-mbew. Gula laŋgar masa ndaw mahura ha ma səra heyey na, ta’, a bawa aa ambaw, aa cəfɗa dam ma jəɗa mey-mbew e ŋga mbəzdərwa Piyer. Ta’, Piyer a mbəzey. ");
INSERT INTO mif_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dam ma jəɗa mey-mbew e aa cəfɗa Piyer, a ləvar: «Hey! kah na, ndaw pal dasi gula hay ŋga ndaw aha may, ba diya?» Piyer a mbəɗdara, a ləvar: «Kay! Yah na, gula aŋga ba.» ");
INSERT INTO mif_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ndəhay ma ka sləra feteɗe leŋ ndəhay ma jəɗa *Way-mekey-kwakwas ŋga Gazlavay heyey ta gəɗam awaw la, fa sətmara maja memeɗ fa key. Piyer heyey aa da cakay ata, fa sətey awaw a may. ");
INSERT INTO mif_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","*Ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay aa cəfɗa Yesu da ray gula aŋga hay ta da ray mey masa aa maa sərkadatara a ndəhay. ");
INSERT INTO mif_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu a mbəɗdara, a ləvar: «Ya taa guzley la fa mey ŋga ndəhay tabiya, ya taa sərkedey ndəhay la mandaw mandaw daa *way-mewuzey-mey ŋga Gazlavay ta daa *Way-mekey-kwakwas ŋga Gazlavay masa *Jəwif hay ma cəmam tabiya a hwaɗ a. Yah ma ɓey mey ta ɓey daa ba səlak. ");
INSERT INTO mif_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kaa, kaa cəfɗaya na, maja me? Daw fa ndəhay ma cəndamara mey aɗaw, cacəfɗata, ata na, a sərmara mey masa yah ma wuzdatara ha maaya maaya.» ");
INSERT INTO mif_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Daa masa Yesu faa guzley anda keɗe na, ndaw pal dasi ndəhay ma jəɗa Way-mekey-kwakwas feteɗe, a sləŋgar matapa-har a Yesu. Ta’, aa guzlar, a ləvar: «A mbəɗam mey ŋgada *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay na, kəne daw?» ");
INSERT INTO mif_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu a mbəɗdara, a ləvar: «Da yah maa guzley mey maaya ba la na, wuzdiwa taw. Yaw, da yah maa guzley mey maaya la na, anja ka kəɗya fa me?» ");
INSERT INTO mif_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Fa dəɓa ha, Han a ləvtar a ndəhay heyey ŋga handamara fa Kayif, ndaw mahura da ray ndəhay ma ka kwakwas ŋga Jəwif hay ta mevey a ŋgene. Yesu a, majəwkaya cəŋga. ");
INSERT INTO mif_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Masa *Simaŋw *Piyer fa sətey awaw feteɗe heyey na, ndəhay feteɗe he, aa cəfɗamara, a ləvmar: «Kah na, gula pal da wuzlah gula hay ŋga ndaw aha may, ba diya?» Ama Piyer a cada mey, a ləvey: «Kay! yah na, gula aŋga ba.» ");
INSERT INTO mif_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Feteɗe, ndaw ma ka sləra ŋga *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay daha. Ndaw aha ara səkway ŋga ndaw masa Piyer ma cərhara sləmay heyey. Ndaw aha, aa guzlar a Piyer, a ləvar: «Kah na, yah ma hətkwar la ta ata ndaw aha daa jerne, ba diya?» ");
INSERT INTO mif_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piyer a cada mey cəŋga. Daa ŋgene, gwagwalak ta’, a cey ɗay. ");
INSERT INTO mif_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pərek pərek, a badamara Yesu da way Kayif, a handamara a way Pilat, Bay Rawma. Ama mahura hay ŋga *Jəwif hay na, a mbəzam a way a ba, maja a wuɗam ŋga zləɓmara kwakwas ata ba, anda keɗe amba a gwamara ŋga zəmey ɗaf ŋga gwagway ŋga *Pak. ");
INSERT INTO mif_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Maja ŋgene, Bay Pilat, a bawa aa ambaw, a hətfatar. Ta’, aa cəfɗata, a ləvtar: «Ka kərzamərwa ndaw a keɗe na, a kawa me?» ");
INSERT INTO mif_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","A mbəɗdamara, a ləvmar: «Da ta key cek malamba daa ba na, anja ya handamərwa fa kah la daw?» ");
INSERT INTO mif_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bay Pilat a mbəɗdatara, a ləvtar: «Akwar ta ray akwar, ŋgəlmara ndaw a, ɗəslmara sariya aŋga anda kwakwas akwar ma ləvey.» Mahura hay ŋga Jəwif hay a mbəɗdamara, a ləvmar: «Ala na, ta cəveɗ ŋga kəɗey ndaw vagay daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Cek aha, a key anda keɗe na, amba Yesu a məcey fa hwadam mazlaŋgalakaya anda aa ma ləvey a da məcey heyey. ");
INSERT INTO mif_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bay Pilat a mbəzey ta ray ŋgada way, a zəla Yesu. Ta’, aa cəfɗa, a ləvar: «Kah na, bay ŋga Jəwif hay daw?» ");
INSERT INTO mif_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu a mbəɗdara, a ləvar: «Kaa guzley anda keɗe na, ara mewulkey akah daw, da daa ba, ara ndəhay ma kadamakawa daw?» ");
INSERT INTO mif_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bay Pilat a mbəɗdara, a ləvar: «Yah na, ndaw Jəwif daw? Ara səkway akah hay ta *bay-ray hay ŋga ndəhay ma ka kwakwas akwar hay ma handamakawa fa yah keɗe. Kaa ka key maaya ba na, me?» ");
INSERT INTO mif_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu a mbəɗdara, a ləvar: «Ya wey da ray ndəhay na, da bəla keɗe ba. Da yah bay da bəla keɗe na, anja gula aɗaw hay a kəɗam vaw la amba mahura hay ŋga Jəwif hay a kərzamaya ba. Ama wure keɗe, ya fa wey da ray ndəhay da bəla keɗe daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Da ray ŋgene, Bay Pilat aa cəfɗa, a ləvar: «Kaa kah na, bay dəɓa daw?» Yesu a mbəɗdara, a ləvar: «Anda kah ma ləvey, yah bay. Ya yawa, ya sawa a bəla na, ŋga wuzdatara mey masa fara fara a ndəhay. Kwa waawa ma səpey cəveɗ masa fara fara na, ara ndaw ma jəkey sləmay fa mey aɗaw.» ");
INSERT INTO mif_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bay Pilat a mbəɗdara, a ləvar: «Mey masa fara fara na, mey wura?» Masa Bay Pilat maa guzley la anda keɗe na, ta’, a bawa aa ambaw saya fa mey ŋga Jəwif hay. A ləvtar: «Yah na, yah ma hətey cek təɗe ŋga kəɗey ndaw keɗe vagay na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yaw, anda kwakwas akwar ma wuɗey na, si ya pəskakwar ndaw pal daa fərsəne ta gwagway ŋga *Pak. Anda keɗe, ka wuɗam na, ya pəskakwar bay ŋga *Jəwif hay daw?» ");
INSERT INTO mif_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","A wudam, a ləvam: «Kay! ka mbəkda ndaw keɗe ba. Ama pəskandar na, Barabas.» Barabas a na, ara ndaw-mayal ma sla ɗay ŋga ndaw. ");
INSERT INTO mif_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ta’, Bay Pilat a ləvtar a sewje hay ŋga sləɗmara Yesu ta laway. ");
INSERT INTO mif_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sewje hay a cam hatak, a paɗamar ray anda gursaw ŋga bay. Asaya, a kəzlmar zana magaza ŋga bay hay fa vaw. ");
INSERT INTO mif_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ta’, a ŋgəcham a cakay a, a sasaŋgəram a ray a, a ləvmar: «Zay daw, bay ŋga Jəwif hay?» Fa dəɓa ha, kaŋ! kaŋ! a vəlmar matapa-har. ");
INSERT INTO mif_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ta’, Bay Pilat a bawa aa ambaw saya, aa guzltar a Jəwif hay, a ləvtar: «Ɗagay, jəkam sləmay! Ya da badakwara ndaw aha aa ambaw amba ka sərmara kwa ya ta hətey cek maaya ba masa aŋga ma ka na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu ta’, a bawa aa ambaw dəɓa. Aŋga ta gursaw ŋga hatak heyey da ray, leŋ zana magaza heyey fa vaw. Pilat aa guzltar, a ləvtar: «Ehe ndaw aha!» ");
INSERT INTO mif_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ama masa *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta ndəhay ata hay ma hətmar na, a wudam ta gədaŋ, a ləvam: «Dəra fa hwadam mazlaŋgalakaya! Dəra fa hwadam mazlaŋgalakaya!» Pilat aa guzltar saya, a ləvtar: «Ehe, ŋgəlmara ndaw aha, dərmara ta har akwar fa hwadam mazlaŋgalakaya ha, maja yah na, kwa yah ma hətey cek maaya ba masa aŋga ma ka na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jəwif hay a mbəɗdamara, a ləvmar: «Kwakwas ala daha, anda kwakwas a ma ləvey na, si mekəɗey ndaw aha keɗe vagay maja taa guzley la, a ləvey aŋga Bəzey ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Masa Bay Pilat ma cənda aŋga ma ləvey aŋga Bəzey ŋga Gazlavay na, mandərzay a kar ta gədaŋ ta gədaŋ. ");
INSERT INTO mif_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","A mbəzey a way saya, ta’, aa cəfɗa Yesu a, a ləvar: «Kah na, ka sawa dama?» Ama kwa Yesu ta mbəɗdara daa ba. ");
INSERT INTO mif_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Da ray ŋgene, Bay Pilat aa guzlar, a ləvar: «Kaa guzley ba keɗe na, ŋgada yah, ba diya? Ka səra, yah na, ya gwa ŋga mbəkdaka, da daa ba, ya gwa ŋga dərka fa hwadam mazlaŋgalakaya, ba diya?» ");
INSERT INTO mif_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu a mbəɗdara, a ləvar: «Ka gwa ŋga wey da ray aɗaw ba, si Bay Gazlavay ma vəlka cəveɗ. Anda keɗe, ndaw ma vəldaya asi har akah keɗe ta key mebərey sem ma fənka.» ");
INSERT INTO mif_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Masa Bay Pilat ma cənda mey a keɗe na, a səpey cəveɗ amba a mbəkda Yesu. Ama Jəwif hay a, a wudam ta gədaŋ, a ləvam: «Da kah ma mbəkda ndaw keɗe sem na, ŋgene, kah jam ŋga bay mahura *Sezere saba. Kwa waawa ma pa ray aŋga ŋga bay na, ara masa-gəra ŋga bay mahura Sezere, ba diya?» ");
INSERT INTO mif_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Masa Bay Pilat ma cənda mey a keɗe saya na, ta’, a badərwa Yesu aa ambaw saya. A njey a ray jaŋga aŋga mekey sariya mapakaya da ray slam macacəlkaya ta aŋgwa mezəley ta mey *Hebəre «Gabata». ");
INSERT INTO mif_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ara ta pas meɗiyey vaw ŋga key gwagway ŋga Pak. Ta wuzlah-pas na, Bay Pilat a ləvtar a Jəwif hay a: «Ehe bay akwar.» ");
INSERT INTO mif_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ama a wudam ta gədaŋ, a ləvam: «Kəɗa vagay! Kəɗa vagay! Dəra fa hwadam mazlaŋgalakaya.» Bay Pilat a mbəɗdatara, a ləvtar: «Bay akwar gway na, ka wuɗam ya dərkwara fa hwadam mazlaŋgalakaya gway daw?» *Bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay a mbəɗdamara, a ləvmar: «Bay ala mahura mekele na, daa ba, si bay Sezere gway.» ");
INSERT INTO mif_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Anda keɗe, Bay Pilat a vəldatara Yesu amba a dərmara fa hwadam mazlaŋgalakaya. Ta’, a kərzamara Yesu dəɓa. ");
INSERT INTO mif_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","A badamərwa Yesu daa berney. Daa masa fa badamərwa ha na, Yesu fa la hwadam mazlaŋgalakaya masa ata ma da dərmara fa vəɗa. A handamara ŋgadaa slam mezəley ta mey *Hebəre «Gwalgwata», anda meləvey, «slam anda tetesl ŋga ray ŋga ndaw.» ");
INSERT INTO mif_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Feteɗe, sewje hay ta’, a dərmara Yesu fa hwadam mazlaŋgalakaya ha. A dəram ndəhay cew saya a cakay a, pal ta har-zəmay, laŋgar ta har-gula, Yesu na, aa da wuzlah. ");
INSERT INTO mif_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bay Pilat ta’, a ləvtar a ndəhay ŋga wuzlalam mey ma ləvey: «Yesu ndaw *Nezeret, bay ŋga *Jəwif hay.» Asaya, a ləvtar ŋga sləpmara fa hwadam masa Yesu mazlaŋgalakaya fa vəɗa heyey. ");
INSERT INTO mif_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jəwif hay ga ta jaŋgamara mey mawuzlalakaya ha la maja slam masa ata ma dərmara Yesu a na, aŋga gweegwe ta berney a. Asaya, ndəhay ga ta jaŋgamara mey a la maja mey a mawuzlalakaya na, ta mey Hebəre ta mey Leteŋ leŋ ta mey Gərek . ");
INSERT INTO mif_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Maja ŋgene, *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Jəwif hay aa guzlmar, a ləvmar: «Ka da mbəkda mey a mawuzlalakaya “Bay ŋga Jəwif hay” anda ŋgene ba. Ama mbəɗda, wuzlala: “Ndaw aha ta ləvey la: Yah na, yah bay ŋga Jəwif hay”.» ");
INSERT INTO mif_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bay Pilat a mbəɗdatara, a ləvtar: «Cek masa yah ma wuzlala sem na, a da njey mawuzlalakaya anda ŋgene.» ");
INSERT INTO mif_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Masa sewje hay ma dərmara Yesu fa hwadam mazlaŋgalakaya cay na, ta’, a həlmata zana aŋga hay, a wunkamara slam məfaɗ, fa sewje he fa sewje he. Mambəkakaya zana aŋga maazəma masa mezəvey a daa ba dəga da vaɗ haa kasl a hwayak. ");
INSERT INTO mif_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sewje hay a, aa guzlam da wuzlah ata a ləvam: «Ya da ŋgərkwa zana ha ta ŋgərey ba, ama kəɗkwa caca amba ndaw pal a la.» Cek aha a key anda mey ŋga Gazlavay mawuzlalakaya zleezle ma ləvey: «Ta wunkamara zana aɗaw hay sem da wuzlah ata, zana maazəma na, a kəɗam caca amba ndaw pal a la.» Yaw, keɗe he ara cek masa sewje hay ma kamara. ");
INSERT INTO mif_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ata mamaŋ ŋga Yesu, ta dam-mamaha, ta *Mari ŋgwas ŋga Kəlawpas, leŋ Mari da Magdala, malacatakaya da cakay hwadam mazlaŋgalakaya masa ata ma dərmara Yesu fa vəɗa heyey. ");
INSERT INTO mif_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu a nəka mamaha. Gula aŋga masa aa ma wuɗa kalah heyey may, aa da cakay mamaha ha. Ta’, Yesu aa guzlar a mamaha, a ləvar: «Mamay, ŋgene na, bəzey akah.» ");
INSERT INTO mif_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ta’, aa guzlar a gula aŋga ha, a ləvar: «Ŋgene na, mamakw.» Dəga ta pas a ŋgene gula ŋga Yesu a ta’, a ŋgəla Mari a way aŋga. ");
INSERT INTO mif_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Daa ŋgene, Yesu a səra ta ndəvda sləra aŋga cay. Ta’, aa guzley, a ləvey: «Yam fa kaya.» Aa guzley anda keɗe na, amba mey mawuzlalakaya daa ɗerewel ŋga Gazlavay zleezle heyey na, a key. ");
INSERT INTO mif_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Feteɗe, kwakulam daha marəhkaya ta yam ŋga babəza ŋga wudez meekwerek e. Sewje hay a jəhwɓam cek anda gagəmay aa yam a heyey, a tərvaɗamara fa mey ŋga zlanday, a təldamara a mey Yesu. ");
INSERT INTO mif_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu maa səɓa yam ŋga babəza ŋga wudez meekwerek e heyey cay na, ta’, aa guzley, a ləvey: «Sləra aɗaw tabiya, ta ndəvey cay.» Fa dəɓa ha, a jəkwda ray, pam! a məcey. ");
INSERT INTO mif_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yesu a məcey na, ta pas masa *Jəwif hay fa ɗiyam vaw ŋgadaa *pas meməskey-vaw. Ta pas a ŋgene, mahura hay ŋga Jəwif hay a wuɗam vagay hay a njam fa hwadam mazlaŋgalakaya hay heyey saba, asaya, maja pas meməskey-vaw a ŋgene a fənta pas hay meməskey-vaw siya. Da ray ŋgene, ta’, aa cəfɗamara Bay Pilat ŋga ŋgərfey salay hay ŋga ndəhay fa hwadam mazlaŋgalakaya, asaya, ŋga padamatərwa salay da ray hwadam hay a. ");
INSERT INTO mif_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Anda keɗe, sewje hay a ŋgərfamara salay hay ŋga ndaw ŋgeeme ta ŋga ndaw ŋga dey cew e masa madərtakaya da cakay Yesu heyey dəɓa. ");
INSERT INTO mif_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","A wusam ŋga ŋgərfamara salay hay ŋga Yesu may na, a hətfamar ta məcey sem. Anda keɗe, kwa ta ŋgərfamara salay aŋga hay daa saba. ");
INSERT INTO mif_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ama sewje pal da wuzlah ata, ta’, a sləka ta zəwet aa cakay. Wure ŋgene, mambaz ta yam a mbəɗwa. ");
INSERT INTO mif_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ndaw ma kada mey a keɗe na, ta hətar la ta dey aŋga . Mey masa aa ma kada na, ara mey fara fara. Yaw, aŋga na, a səra ara mey fara fara. Anda keɗe, a kada mey a na, amba akwar may, ka təɓmara mey a. ");
INSERT INTO mif_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Cek hay a tabiya ma kam keɗe na, anda mey ŋga Gazlavay mawuzlalakaya zleezle, ma ləvey: «Kwa fa da ŋgərfamar tetesl pal daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Asaya, mey ŋga Gazlavay mawuzlalakaya mekele daha, a ləvey: «A hətmar ndaw masa ata ma sləkmara la.» ");
INSERT INTO mif_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Fa dəɓa ha, ndaw da slala Arimate daha, mezəley *Jawzef. Ta’, a daw fa Bay Pilat ŋgaa cəfɗarawa vagay ŋga Yesu amba a jəha. Jawzef e na, ara ndaw ma təɓa mey ŋga Yesu, ama ta wuzda vaw aŋga daa ba maja a zlurey ta mahura hay ŋga *Jəwif hay. Bay Pilat ta vəlar cəveɗ la. Aŋga ta’, a daw a la vagay a. ");
INSERT INTO mif_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikwedem, ndaw masa ma hətfar Yesu a ta tavaɗ heyey, ta’, a diyam cew e ta Jawzef ŋga jəhey vagay a. Nikwedem ta ley mal mezey maaya ŋga cek mezəley «*mir» majahaɗakaya ta cek mezəley «aləwes» la a har, a fəna kəlew kwakwar maakar. ");
INSERT INTO mif_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ata cewete ta’, a lamara vagay ŋga Yesu a, a zləŋgmara ta maslaga, a takwaɗamar mal heyey anda Jəwif hay ma kamara daa masa ata fa da zləŋgam vagay. ");
INSERT INTO mif_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Daa slam masa ata ma dərmara Yesu a na, jerne daha. Daa jerne he cəvay mawiya daha, kwa ta pam vagay a hwaɗ a daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","A jəhmara Yesu aa cəvay a na, maja ara hakwaɗ, *pas meməskey-vaw gweegwe cay, asaya, maja cəvay a gweegwe feteɗe. ");
INSERT INTO mif_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Taa pərek ta luma ŋga Gudal, slam beŋ! beŋ! *Mari da Magdala, a daw ŋga nəkərwa cəvay ŋga Yesu. A wusey a mey cəvay a, a da nəkey dey na, beeler mahura ma gərca mey ŋga cəvay a maŋgəchadakaya ta cakay. ");
INSERT INTO mif_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Anda keɗe, takw! a həla mahway ŋgada fa ata *Simaŋw *Piyer ta gula laŋgar masa Yesu ma wuɗa kalah heyey. Ta’, aa guzltar, a ləvtar: «Ta lamara vagay ŋga Bay Mahura Yesu sem daa cəvay, ya sərmara a pamara aa wura ba.» ");
INSERT INTO mif_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Da ray ŋgene, ata Piyer ta gula laŋgar heyey, a sləkɗam, a diyam a mey cəvay a. ");
INSERT INTO mif_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ata cewete, a hwam ta hway, ama gula laŋgar heyey a hway a fəna Piyer, a wusey teeseɗ a mey cəvay a. ");
INSERT INTO mif_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ta’, a wuzeɗey dey aa cəvay a, a hətey da hwaɗ a na, maslaga hay makwiydatakaya, ama ta mbəzey aa cəvay a daa ba. ");
INSERT INTO mif_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simaŋw Piyer a wusey fa dəɓa aŋga, ta’, a mbəzey aa cəvay a. A hətatar maslaga hay makwiydatakaya, ");
INSERT INTO mif_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","asaya, a hətar zana masa ata ma sləwɗamara ray ŋga Yesu ta aŋga heyey. Zana ha na, macəmkaya ta maslaga hay heyey ba, ama mapaɗakaya wal ta cakay. ");
INSERT INTO mif_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Gula laŋgar ma wusey teeseɗ heyey, a mbəzey aa cəvay a may, a hətatar cek hay a, anda keɗe, a təɓa ma sləkɗawa ŋga Yesu daa meməcey. ");
INSERT INTO mif_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ama *gula hay ŋga Yesu ta cəndamara mey ŋga Gazlavay masa ma ləvey Yesu a da sləkɗawa daa meməcey na, daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Fa dəɓa ha, ta’, gula hay cew heyey a vəham a way ata hay. ");
INSERT INTO mif_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Daa ŋgene, *Mari da Magdala ta’, a vəhey a mey cəvay a. Deŋ! a lecey a mey cəvay a, fa təway. Masa aŋga fa təway a na, ta’, a wuzeɗey dey aa cəvay a. ");
INSERT INTO mif_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","A da nəkey dey na, a ray maslaŋ hay ŋga Gazlavay cew ta zana hay mabara fa vaw. Ata manjatakaya cəma daa slam masa ata ma pamara vagay ŋga Yesu heyey, pal manjakaya daa slam-ray, pal daa slam-salay. ");
INSERT INTO mif_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Maslaŋ hay ŋga Gazlavay heyey aa cəfɗamara, a ləvmar: «Kwakwa, ka təway me?» A mbəɗdatara, a ləvtar: «Ta lamara vagay ŋga Bay aɗaw Mahura sem, ya səra a pamara aa wura ba.» ");
INSERT INTO mif_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Masa ŋgwas aha maa guzley la anda keɗe, a da mbəɗey dey na, a ray Yesu malacakaya feteɗe, ama kwa ta səra ara aŋga na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu a, aa cəfɗa, a ləvar: «Kwakwa, ka təway me? Ka səpey na, wa?» Ŋgwas aha, a wulkey na, ara ndaw ma jəɗa jerne he, ta’, aa guzlar, a ləvar: «Papay aɗaw, da ara kah ma la na, wuzdiwa slam masa kah ma pa amba ya larawa aa slam a taw?» ");
INSERT INTO mif_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu ta’, a zəla, a ləvar: «Mari!» Masa Mari ma cənda mezəley aŋga la na, pəla! a mbəɗey dey ŋgada fa Yesu, ta’, aa guzlar ta mey *Hebəre, a ləvar: «Rabuni,» anda meləvey «bay aɗaw». ");
INSERT INTO mif_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu aa guzlar, a ləvar: «Mbəkdaya, ka da zəndaya vaw ba, maja ya ta təpey fa Papay a vaɗ daa ba araŋ. Ama kah na, daw ta ləvtar a məlma aɗaw hay, ya təpey la fa Papay masa aŋga Papakw akwar may, fa Gazlavay masa aŋga Gazlavay akwar may.» ");
INSERT INTO mif_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ta’, Mari da Magdala a daw fa *gula hay ŋga Yesu dəɓa, a kadatara, a ləvtar: «Ya ta hətar Bay Mahura Yesu la.» Asaya, Mari a kadatara mey masa Yesu a ma ləvar. ");
INSERT INTO mif_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Taa kwaɗ ta luma ŋga Gudal a ŋgene, *gula hay ŋga Yesu makustakaya daa way daha. Ta gərcamata mey-slam hay sem ta lekəle maja ata fa zluram ta mahura hay ŋga *Jəwif hay. Ta’, Yesu a daw a lecey a wuzlah ata, a ləvtar: «Anja Gazlavay ŋga njadakwar daa zazay.» ");
INSERT INTO mif_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Masa aŋga ma ləvtar la anda keɗe na, ta’, a wuzdatara har aŋga hay ta cakay aŋga. Gula hay ŋga Yesu a, taa səmam la ga maja ata ma hətmar Bay Mahura ha. ");
INSERT INTO mif_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu aa guzltar saya, a ləvtar: «Anja Gazlavay ŋga njadakwar daa zazay. Anda Papay, Bay Gazlavay, ma slərdiwa a bəla na, yah may, ya slərdakwar ŋga key sləra aɗaw.» ");
INSERT INTO mif_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Masa aŋga maa guzltar anda keɗe la na, ta’, a səfney a ray ata, a ləvtar: «Təɓam *Mesəfney ŋga Gazlavay a ray akwar. ");
INSERT INTO mif_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Da ka mbəkdamara mebərey ŋga ndaw na, Gazlavay a mbəkdara la may. Ama da akwar ma mbəkdamara mebərey ŋga ndaw daa ba na, Gazlavay fa da mbəkdara daa ba may.» ");
INSERT INTO mif_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yaw, daa masa Yesu ma wuztar vaw a gula aŋga hay na, *Tuma, masa ata ma zəlmara Didim , gula pal dasi gula aŋga hay kuraw a ray a cew, aŋga da wuzlah ata daa ba. ");
INSERT INTO mif_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Masa Tuma ma sawa la a wuzlah ata na, a ləvmar: «Ala ta hətmar Bay Mahura la.» Ama Tuma a mbəɗdatara, a ləvtar: «Da yah ma hətar vevek ŋga mbəlek fa har ŋga medərey heyey daa ba, da yah ma pa bəz-mey-har aɗaw aa vevek ŋga mbəlek e daa ba, asaya, da yah ma pa har aɗaw aa cakay aŋga daa ba na, ŋgene, ya fa da təɓa Yesu ta sləkɗawa sem daa meməcey na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Luma pal fa dəɓa ha na, *gula hay ŋga Yesu a kusam aa way heyey saya. Tuma aŋga da wuzlah ata dəɓa. Mey-slam hay magərcatakaya ta lekəle, ama Yesu ta’ a sawa, a lecey a wuzlah ata, a ləvtar: «Anja Gazlavay ŋga njadakwar daa zazay.» ");
INSERT INTO mif_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Fa dəɓa ha, Yesu a ləvar a Tuma: «Təldərwa bəz-mey-har akah feɗe, nəkta har aɗaw hay. Asaya, təldərwa har akah, pa aa cakay aɗaw. Mbəkda mekey yawa, təɓa ya ta sləkɗawa sem daa meməcey.» ");
INSERT INTO mif_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tuma a mbəɗdara, a ləvar: «Kah na, Bay aɗaw Mahura, kah na, Gazlavay aɗaw!» ");
INSERT INTO mif_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu a ləvar: «Kah ma təɓa mey a keɗe na, maja kah ma hətya ta dey akah, ba diya? Maaya ŋga Gazlavay aa da ray ndəhay ma təɓmara ya ta sləkɗawa sem daa meməcey, masa kwa ta hətmaya ta dey ata daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu ta key maazla hay la ga mekele mekele meedey gula aŋga hay, ama maazla hay a tabiya mawuzlalatakaya daa ɗerewel keɗe daa ba. ");
INSERT INTO mif_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mey hay tabiya masa mawuzlalatakaya daa ɗerewel keɗe na, ara amba ka təɓmara, Yesu na, ara Bəzey ŋga Gazlavay, ara *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay. Anda keɗe, da akwar fa təɓmara mey aŋga na, ka da hətam heter mendəvey ba ta fa aŋga. ");
INSERT INTO mif_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Fa dəɓa ha ɗar nekəɗey na, Yesu a wuztar vaw a gula aŋga hay saya. A wuztar vaw na, da mey dəhwa ŋga Tiberiyat. Ehe, mey da ray Yesu ma wuztar vaw a gula aŋga hay a. ");
INSERT INTO mif_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ata *Simaŋw *Piyer, *Tuma masa ata ma zəlmara Didim, Nataniyel ndaw da Kana daa hwayak ŋga *Galile, ta bəza hay ŋga Zebede, leŋ *gula hay ŋga Yesu cew mekele, ata tabiya daa slam a. ");
INSERT INTO mif_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simaŋw Piyer a ləvtar: «Ya daw la aa ewet.» Ndəhay siya keɗe heyey a mbəɗdamara, a ləvmar: «Ala may, ya diyam asi akah.» Da ray ŋgene, ta’, a diyam, a təpam aa kwambiwal. Tavaɗ tavaɗ ata daa ewet e, ama kwa ta kərzam daa ba. ");
INSERT INTO mif_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Taa pərek masa pas fa bawa na, Yesu a daw, a njey a mey dəhwa ha. Ama gula aŋga hay ta sərmara ara aŋga na, daa ba. ");
INSERT INTO mif_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ta’, Yesu aa guzltar, a ləvtar: «Bəz aɗaw hay, akwar ma kərzam ewet e la daw?» A mbəɗdamara, a ləvmar: «Ala ma kərzam daa ba.» ");
INSERT INTO mif_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu a ləvtar saya: «Lamara *tabaw akwar, kəzlamara ta dey ŋga zəmay, ka kərzamawa la.» Da ray ŋgene, a kəzlamara tabaw ata anda Yesu ma ləvtar. A hətam ewet ga da hwaɗ a. A gwamara ŋga ɗaɗamərwa tabaw a, aa kwambiwal saba, maja ewet ga kalah da hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ta’, gula masa Yesu ma wuɗa kalah heyey a ləvar a Piyer: «Ara Bay Mahura!» Masa Simaŋw Piyer ma cənda ara Bay Mahura na, ta’, a kəzla zana fa vaw maja ta cəkwa zana sem amba a kərzey ewet. Ta’, a jəvey daa kwambiwal gəv! aa yam, a daw ŋgada fa Yesu. ");
INSERT INTO mif_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yaw, gula hay ŋga Yesu siya na, ata gweegwe cay a rav-zazay, mendərey a wusa meeter temere saba. A diyam ta kwambiwal. Daa ŋgene, fa ɗaɗamara tabaw ata marəhkaya ta ewet ga da hwaɗ a heyey. ");
INSERT INTO mif_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","A bərŋgamawa daa kwambiwal. Masa ata ma bərŋgamawa cay na, a hətam zay-awaw ta ewet da ray a leŋ peŋ. ");
INSERT INTO mif_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu aa guzltar, a ləvtar: «Həlmawa ewet masa akwar ma kərzamərwa ŋgene nekəɗey.» ");
INSERT INTO mif_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simaŋw Piyer a təpey aa kwambiwal a, ta’, a ɗaɗarawa tabaw a marəhkaya kaf! ta ewet hay ga mahura hay da hwaɗ a heyey. Ewet hay a tabiya temere ta kwakwar zlam a ray a maakar. Tabaw a marəhkaya kaf!, ama kwa ta ŋgərey daa ba. ");
INSERT INTO mif_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu a ləvtar: «Samawa, zəmam cek.» Yaw, kwa gula pal da wuzlah ata ta key gədaŋ ŋgaa cəfɗa kah na, wa na, daa ba gway, maja a sərmara fara fara ara Bay Mahura. ");
INSERT INTO mif_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu a ŋgəchey, a la peŋ heyey, a wunkatara a gula aŋga hay, asaya, a la ewet da ray zay-awaw, a vəldatara. ");
INSERT INTO mif_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Dəga ŋga masləkɗawa ŋga Yesu daa meməcey na, ta pas ŋgene, ara ŋga dey maakar a masa aŋga ma wuztar vaw a gula aŋga hay. ");
INSERT INTO mif_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Masa ata ma ndəvdamara mezəmey cek cay na, Yesu aa cəfɗa *Simaŋw *Piyer, a ləvar: «Simaŋw, bəzey ŋga *Jaŋ, ka wuɗya a fənta ndəhay keɗe daw?» Piyer a mbəɗdara, a ləvar: «Ahaw, Bay Mahura, ka fa səra ya wuɗka.» Yesu a ləvar: «Nəkfatar dey fa ndəhay aɗaw hay, anda ndaw ma nəkfatar dey fa bəz-təɓaŋ aŋga hay.» ");
INSERT INTO mif_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ta’, Yesu a ləvar ŋga dey cew saya: «Simaŋw, bəzey ŋga Jaŋ, ka wuɗya daw?» Piyer a mbəɗdara, a ləvar: «Ahaw, Bay Mahura, ka fa səra ya wuɗka.» Yesu a ləvar: «Key mecəkwer ŋga ndəhay aɗaw hay anda ndaw ma səkərey təɓaŋ aŋga hay.» ");
INSERT INTO mif_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ta’, Yesu a ləvar ŋga dey maakar: «Simaŋw, bəzey ŋga Jaŋ, ka wuɗya daw?» Piyer na, ray aŋga ta həɓey sem maja Yesu maa cəfɗa ŋga dey maakar, a ləvar: «Ka wuɗya daw, ka wuɗya daw?» Ta’, a mbəɗdara, a ləvar: «Bay Mahura, kah na, ka sərta cek hay cəpa, ka fa səra ya wuɗka.» Yesu a ləvar: «Nəkfatar dey fa ndəhay aɗaw hay anda ndaw ma nəkfatar dey fa təɓaŋ aŋga hay. ");
INSERT INTO mif_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yaw, ya fa ləvka fara fara, daa masa kah daa gula akah na, ma ɗiya vaw akah ŋgada pəkey na, kah ta ray akah. Ka fa daw kwa aa wura aa wura. Ama da kah ta key maraw cay na, ka da baŋgaɗata har akah hay amba ndaw mekele a ɗiykawa vaw akah. A da handaka kwa aa slam masa kah ma wuɗey ŋga daw ba.» ");
INSERT INTO mif_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ta mey a keɗe na, Yesu a wuɗey ŋga wuzda səkway ŋga meməcey ŋga Piyer. Piyer a da həlma Gazlavay ta fa meməcey aŋga ha. Fa dəɓa ha, Yesu a ləvar a Piyer: «Sawa, səpya.» ");
INSERT INTO mif_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","*Piyer a mbəɗey dey fa dəɓa, a da nəkey dey na, a ray gula masa Yesu ma wuɗa kalah heyey. Gula ha fa səptar wurzay. Ara gula masa ma gənsley ŋgada fa Yesu daa masa ata fa zəmam ɗaf, maa cəfɗa, ma ləvey: «Bay Mahura ma da vəldaka a har masa-gəra akah hay na, wa?» heyey. ");
INSERT INTO mif_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piyer ma hətar la na, ta’, aa cəfɗa Yesu, a ləvar: «Bay Mahura, kaa ma da hətfar a gula keɗe na, me?» ");
INSERT INTO mif_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu a mbəɗdara, a ləvar: «Da ya wuɗey a njey ta dey da bəla keɗe haa kasl mavəhwa aɗaw na, mey akah da hwaɗ a me? Kah na, sawa, səpya.» ");
INSERT INTO mif_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mey a, a cəney fa ndəhay ŋga Yesu siya na, anda gula ha fa da məcey daa saba. Fara fara Yesu ta ləvar a Piyer, gula ha fa da məcey daa saba na, daa ba. Ama a ləvar na, «Da ya wuɗey a njey ta dey da bəla keɗe haa kasl mavəhwa aɗaw na, mey akah da hwaɗ a me?» ");
INSERT INTO mif_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yaw, gula ha na, ara ndaw ma hətatərwa cek hay a keɗe ta dey aŋga, ara aŋga ma wuzdatara a ndəhay, asaya, ara aŋga ma wuzlalatərwa aa ɗerewel keɗe may. Ala na, ya sərmara mey hay a keɗe ara mey hay masa fara fara. ");
INSERT INTO mif_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu ta key cek hay la mekele mekele ga. Anja da cek hay a mawuzlalatakaya cəpa pal pal fa ɗerewel na, ya wulkey slam da bəla keɗe ŋga pata ɗerewel hay a daa ba. ");
INSERT INTO mif_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Waa *Teyewfil, Daa ɗerewel aɗaw ŋgeeme na, ya ta wuzlalaka mey da ray Yesu la. Daa ɗerewel e ya ta wuzlalatakawa cek hay tabiya masa Yesu ma kata la, leŋ mey masa aŋga maa sərkadatara a ndəhay, dəga ta pas masa aŋga ma zla sləra aŋga da bəla ");
INSERT INTO mif_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","haa kasl pas masa *Gazlavay ma la a vaɗ. Masa *Yesu aŋga da bəla na, aŋga ta weley ndəhay aŋga hay meslərey la. Fa dəɓa ha, Yesu a, a məcey, ta’, a sləkɗawa daa meməcey, a wuztar vaw a ndəhay aŋga hay. Fa dəɓa ŋga masləkɗawa aŋga daa meməcey na, ɗar kwakwar məfaɗ, aŋga fa wuztar vaw maaya maaya ta fa cek hay mekele mekele, amba ndəhay meslərey a, a sərmara fara fara aŋga ta dey. Asaya, aa guzltar da ray mewey ŋga Gazlavay da ray ndəhay. A kətata da ray cek hay masa ata ma da kamara na, ta gədaŋ ma sawa ta fa *Mesəfney ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ta pas laŋgar daha na, Yesu fa zəmam ɗaf daa slam a ta ndəhay aŋga hay meslərey. Ta’, a kətata, a ləvey: «Papay a ləvey a vəlkwar cek la. Ya ta kadakwara cay, ba diya? Njam daa berney ŋga *Jeruzelem feɗe, səkwmara cek aha. ");
INSERT INTO mif_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","*Jaŋ a katar *baptem a ndəhay na, ta yam, ama daa ɗar hay nekəɗey feɗe, ka hətam baptem la ta Mesəfney ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ndəhay meslərey ŋga Yesu a makustakaya da cakay a, aa cəfɗamara, a ləvmar: «Bay Mahura, ka da ɗiya hwayak ŋga *Israyel amba ka wey da ray a na, wure keɗe daw?» ");
INSERT INTO mif_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu a mbəɗdatara, a ləvtar: «Akwar na, mey akwar da hwaɗ a me? Ara Papay ma pa pas a, ara aŋga pal ma wa ɗar a. ");
INSERT INTO mif_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama ta pas masa *Mesəfney ŋga Gazlavay ma da pawa salay a ray akwar na, ka hətam gədaŋ la. Fa dəɓa ha, ka da kam sede da ray aɗaw. Ka da kam sede teeseɗ na, fa mey ŋga ndəhay da *Jeruzelem, fa dəɓa ha, fa mey ŋga ndəhay da *Jude ta fa mey ŋga ndəhay da *Samari, leŋ fa mey ŋga ndəhay da bəla tabiya.» ");
INSERT INTO mif_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Fa dəɓa ha Yesu ma ndəvda mey hay keɗe la na, Gazlavay ta’, a la a vaɗ, ndəhay da cakay a fa nəkmara, mekwtene sərat! a sərta, a hətmar Yesu a saba. ");
INSERT INTO mif_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ata fa nəkam dey a vaɗ aa slam masa Gazlavay ma la Yesu a cəŋga. Wure wure ŋgene, ndəhay cew daha malacatakaya da wuzlah ata, ta zana mabara fa vaw, ");
INSERT INTO mif_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","a ləvmatar: «Akwar, ndəhay *Galile hay, akwar malacatakaya, fa nəkam dey ŋgada vaɗ ŋgada vaɗ na, maja me? Yesu masa Bay Gazlavay ma la da wuzlah akwar a vaɗ keɗe na, a vəhwa la, anda akwar ma hətmar aŋga ma daw ŋgada vaɗ keɗe.» ");
INSERT INTO mif_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Fa dəɓa ha, ndəhay meslərey ŋga Yesu a bərŋgamawa daa Aŋgwa ŋga *Awliviye. A vəhmawa a *Jeruzelem, aŋgwa ha dəreŋ daa ba, a key kəlemeeter pal gway. ");
INSERT INTO mif_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Masa ata ma wusmawa la a Jeruzelem na, ta’, a təpam aa way da ray way, aa slam masa ata ma kusam mandaw mandaw da hwaɗ a. Ndəhay meslərey a na, ara *Piyer, *Jaŋ, *Jak, *Andəre, *Fəlep, *Tuma, *Bartelemey, *Matiye, Jak bəzey ŋga Alfe, *Simaŋw, ndaw da wuzlah ndəhay ma wuɗam ŋga ləhdamata ndəhay ata hay dasi har ŋga masa-gəra ata hay, leŋ Jud bəzey ŋga Jak. ");
INSERT INTO mif_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ata tabiya fa kusam mandaw mandaw ŋga dərey daŋgay a Gazlavay ta mevel pal. A kusam na, ta ŋgusay mekele mekele, ta *Mari, mamaŋ ŋga Yesu, leŋ ta məlmaŋ ŋga Yesu hay. ");
INSERT INTO mif_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Daa ɗar hay a ŋgene, ndəhay ma təɓa mey ŋga Yesu makustakaya daa slam a, a key temere ta kwakwar cew. Ta’, Piyer a lecey a wuzlah ata, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","«Məlma aɗaw hay, Juda aŋga zleezle na, da wuzlah aləkwa, aləkwa masa Yesu ma walandakwar amba ya kakwa sləra ŋgada Bay Gazlavay. Ama ara aŋga ma wuzdatara cəveɗ a ndəhay ŋga kərzey Yesu. Zleezle na, Bay *Davit taa guzley la ta gədaŋ ŋga *Mesəfney ŋga Gazlavay da ray cek masa Juda ma da ka. Yaw, mey daa ɗerewel ŋga Gazlavay a ŋgene ta key la fara fara anda mawuzlalakaya.» ");
INSERT INTO mif_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Juda heyey, ta hətey dala la maja cek malamba masa aŋga ma ka ha. Ta dala ha na, a həɗkada ley. Da ley aŋga ha, a təɗey, hwaɗ pəcakw! a pəckwey, tanday zaɗ! a palah, pam! a məcey. ");
INSERT INTO mif_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ndəhay da Jeruzelem tabiya ta cəndamara mey a la. Da ray ŋgene, a zəlmara ley a ta mey ata «Hakəldama,» anda meləvey, ley ŋga mambaz. ");
INSERT INTO mif_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Piyer a ləvey saya: «Mawuzlalakaya daa ɗerewel ŋga *Pəsam hay, a ləvey: “Anja way aŋga, ŋga tərey yideŋ, ndaw ŋga njey a hwaɗ a ba.” Yaw, mawuzlalakaya saya, a ləvey: “Si ndaw mekele a la sləra aŋga.” ");
INSERT INTO mif_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","«Da ray ŋgene, maaya na, ndaw mekele a sawa asi aləkwa amba a key sede da ray masləkɗawa ŋga Bay Mahura Yesu. Si ya walakwa ndaw masa ala ma pəkam la bama ta ata Yesu aa wura aa wura. Ndaw masa aləkwa ma da walakwa na, si ndaw aha aŋga ta ala dəga ta pas masa *Jaŋ-Baptis ma kar *baptem a Yesu haa kasl pas masa Gazlavay ma la Yesu a da wuzlah aləkwa a vaɗ.» ");
INSERT INTO mif_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Fa dəɓa ha masa ata ma cəndamara mey ŋga Piyer la na, a lam ndəhay cew. Ara ata *Jawzef, masa ndəhay ma zəlmara Barsabas, mehəlmey Justus, leŋ Matiyas. ");
INSERT INTO mif_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ta’, a dəram daŋgay a Bay Gazlavay, a ləvam: «Bay Gazlavay, ka sərta mevel ŋga ndəhay tabiya, wuzndar ndaw pal dasi ndəhay cew keɗe masa kah ma wuɗey ");
INSERT INTO mif_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ŋga key *ndaw-meslərey ŋga Yesu aa slam a ŋga Juda. Juda na, ta mbəkda sləra ha sem ŋga daw aa slam masa aŋga ma wuɗey.» ");
INSERT INTO mif_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ta’, a wuzlalamata mezəley ata cewete ŋga weley ndaw pal dasi ata. Ma da bawa na, mezəley ŋga Matiyas. Da ray ŋgene, a pamara Matiyas a dey ndəhay meslərey kuraw a ray a pal heyey. ");
INSERT INTO mif_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Masa pas ŋga gwagway ŋga *Pantekwat ta wuswa cay, ndəhay ma təɓa mey ŋga Yesu tabiya makustakaya daa slam a. ");
INSERT INTO mif_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Wure wure ŋgene, a cəndamara cek ma kawa ta da vaɗ anda memeɗ maa bərey. Cek aha a rəhda way masa ata manjatakaya da hwaɗ a heyey. ");
INSERT INTO mif_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","A hətam cek anda neneh hay ŋga awaw ma gəɗey. Neneh hay a, a wunkam, a njam a ray ata pal pal tabiya. ");
INSERT INTO mif_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ata tabiya marəhtakaya ta *Mesəfney ŋga Gazlavay. A zlamar meeguzley ta mey hay mekele mekele masa ata ma sərmara ba, anda Mesəfney a ma vəldatara ŋgaa guzley. ");
INSERT INTO mif_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yaw, da *Jeruzelem e na, *Jəwif hay masa ma səpam cəveɗ ŋga Gazlavay ta mevel pal feteɗe daha. A samawa daa hwayak hay da bəla tabiya. ");
INSERT INTO mif_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ata ma cəndamara cek maa bərey heyey la na, a kusmawa ga. Ata tabiya a rəzlam maja kwa waawa fa cənda mey aŋga fa ndəhay ma təɓa mey ŋga Yesu a, ata faa guzlam ta mey hay a. ");
INSERT INTO mif_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","A rəzlam, a wulkam, aa cəfɗam vaw da wuzlah ata, a ləvam: «Ndəhay maa guzlam mey keɗe, ata tabiya ndəhay daa hwayak ŋga *Galile, ba diya? ");
INSERT INTO mif_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kaa kwa waawa fa cənda mey aŋga fa ndəhay a faa guzlam na, kwara? ");
INSERT INTO mif_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","«Aləkwa feɗe na, ndəhay ma samawa daa hwayak ŋga Parte, daa hwayak ŋga Medi ta daa hwayak ŋga Elam, daa hwayak ŋga Mezapawtami, daa hwayak ŋga *Jude, daa hwayak ŋga Kapadəwas, daa hwayak ŋga Paŋw, daa hwayak ŋga Azi, ");
INSERT INTO mif_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","daa hwayak ŋga Fərizi, daa hwayak ŋga Pamfili, daa hwayak ŋga *Ejip, leŋ daa hwayak ŋga Libi masa gweegwe ta berney ŋga Siren. Asaya, da wuzlah aləkwa na, ndəhay ma samawa da *Rawm daha, ");
INSERT INTO mif_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ndəhay ma samawa da Kəret daha, ta ndəhay Arap hay daha may. Da wuzlah aləkwa, siya hay ara ndəhay daa səkway ŋga Jəwif hay, ta siya hay ma mbəzam ŋga səpey kwakwas ŋga Jəwif hay. Ama aləkwa tabiya, ya fa cəndakwa ata faa guzlam ta mey hay mekele mekele masa daa hwayak aləkwa da ray sləra mahura masa Gazlavay ma ka!» ");
INSERT INTO mif_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Anda keɗe na, ata tabiya a rəzlam, a sərmara ŋga key kwara ba, aa guzlam da wuzlah ata, a ləvam: «Cek aha keɗe a wuɗey ŋga ləvey kwara?» ");
INSERT INTO mif_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ama ndəhay siya hay, aa saŋgəram a ray ndəhay ma təɓa mey ŋga Yesu kaa heyey, a ləvam: «Ata tabiya mawatakaya ta wuzam.» ");
INSERT INTO mif_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Da ray ŋgene, *Piyer ta’, a lacam ta ndəhay meslərey kuraw a ray a pal heyey, aa guzley ta gədaŋ fa mey ŋga ndəhay makustakaya heyey, a ləvtar: «Akwar ndəhay *Jəwif hay daa hwayak ŋga *Jude, leŋ akwar ndəhay tabiya ma samawa daa hwayak hay mekele mekele a *Jeruzelem, jəkam sləmay maaya maaya fa mey masa yah ma da wuzdakwara keɗe amba ka sərmara mabara ŋga mey a. ");
INSERT INTO mif_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ndəhay keɗe fa wam anda akwar ma ləvam na, daa ba, maja aŋga kaa na, pas ŋgaa pərek, pas ma həla maaca ɗagay. ");
INSERT INTO mif_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ama wure keɗe cek aha keɗe a key na, anda Jəwel, *ndaw ma təla mey ŋga Gazlavay zleezle, ma ləvey: ");
INSERT INTO mif_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Gazlavay a ləvey, Ta pas masa bəla gweegwe cay a ndəvey na, ya vəltar Mesəfney aɗaw la a ndəhay tabiya. Da ray ŋgene, bəz akwar hay mezəle ta dam akwar hay, a təram la ŋga ndəhay ma təla mey aɗaw hay. Gula akwar hay na, ya da wuztar cek hay mawiya masa Yah ma da kata. Maraw hay da wuzlah akwar may, mesəfney a katar la amba ya wuztar cek hay. ");
INSERT INTO mif_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ahaw, daa ɗar hay a ŋgene, ya vəltar Mesəfney aɗaw la a ndəhay ma ka sləra aɗaw hay, mezəle hay ta maŋgusa hay tabiya, a da təram *ndəhay ma təla mey aɗaw hay. ");
INSERT INTO mif_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ya key maazla hay la da gazlavay da vaɗ, ya key cek hay ma rəzla ndaw la da ray hwayak. Mambaz, ta awaw, leŋ kakas a bamawa la. ");
INSERT INTO mif_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Pas fa da weɗey daa saba, kiya a da mbəɗey magaza anda mambaz. Fa dəɓa ha, Bay Mahura a vəhwa la amba a key sariya da bəla. Ta pas a ŋgene, ndəhay a hətmar gədaŋ aŋga la, a da sərmara pas a ara pas mahura ma fəna siya hay. ");
INSERT INTO mif_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Anda keɗe, kwa waawa maa cəfɗa Bay Mahura ŋga ləhda na, Bay Mahura a ləhda la.”» ");
INSERT INTO mif_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piyer a ləvey saya: «Akwar, *Israyel hay, jəkfamaya sləmay fa mey aɗaw keɗe. Yesu ndaw *Nezeret na, Gazlavay ta wuzdakwara la aŋga na, wa. Ka sərmara fara fara maja Gazlavay ta key maazla hay la mahura ma rəzla ndaw ta har aŋga da wuzlah akwar. Maazla hay a na, fa wuzdakwara gədaŋ ŋga Gazlavay aa ta Yesu a. ");
INSERT INTO mif_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ndaw aha, Gazlavay ta vəlda la a har akwar anda aa ma wuɗey. Dəga zleezle Gazlavay ta səra cek masa akwar ma da kamara sem. Cek aha na, ara akwar ma vəldamara Yesu a har ndəhay ma səra Gazlavay ba, amba a kəɗmara vagay fa hwadam mazlaŋgalakaya heyey. Akwar ta kəɗmara la, ");
INSERT INTO mif_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ama Gazlavay ta sləkɗadərwa sem, a badərwa daa banay ŋga meməcey maja gədaŋ ŋga meməcey a gwa a ray a ba. ");
INSERT INTO mif_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ehe, zleezle Bay *Davit maa guzley da ray Yesu, a ləvey: “Ya fa hətar Bay Mahura mandaw mandaw fa mey aɗaw, aŋga manjakaya ta har-zəmay aɗaw amba ya zlurey ba. ");
INSERT INTO mif_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Da ray ŋgene, mevel aɗaw faa səmey, ya zley walay ta meesəmey. Kwa ya məcey la na, ya fa səkwa cek masa Gazlavay ma da kayawa, ");
INSERT INTO mif_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ya da njey ta zazay maja ya səra kah, Bay Gazlavay, ka mbəkda mesəfney aɗaw aa slam ŋga ndəhay maməctakaya daa ba, kwa ka fa da mbəkda vaw aɗaw, yah, ndaw ma ka sləra akah, ŋga zey daa cəvay daa ba may. ");
INSERT INTO mif_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ka ta wuzdiwa cəveɗ ŋga hətey heter mendəvey ba la, Ya daa səmey ga, maja kah manjakaya ta yah.”» ");
INSERT INTO mif_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piyer a ləvtar saya: «Məlma aɗaw hay Jəwif hay, ya gwa yaa guzlkwar mey masa fara fara da ray Davit e, Davit masa papaŋ ŋga papa aləkwa zleezle. Ya fa ləvkwar aŋga ta məcey sem, ta pəshamara sem aa cəvay. Cəvay aŋga ha, haa kasl tasana, aa daha feɗe. ");
INSERT INTO mif_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Aŋga na, ndaw ma təla mey ŋga Gazlavay, a səra Gazlavay ta jəwey mey la ta aŋga, a ləvar: “Fa dəɓa akah, ya da pey ndaw pal daa səkway akah ŋga key bay anda kah.” ");
INSERT INTO mif_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Da ray ŋgene, Davit a səra cek masa Gazlavay ma da ka ŋgada fa mey. A səra *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay na, Gazlavay a sləkɗadərwa la daa meməcey. Davit e, aa guzley da ray masləkɗawa ŋga *Kəriste daa meməcey a, a ləvey Gazlavay ta mbəkda ndaw aha da wuzlah ndəhay maməctakaya daa ba, vaw aŋga ta zey daa cəvay daa ba. ");
INSERT INTO mif_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu keɗe na, Gazlavay ta sləkɗadərwa sem daa meməcey, ala tabiya fa kam sede da ray a. ");
INSERT INTO mif_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Gazlavay ta la sem a vaɗ, a pa aa slam maaya a har-zəmay aŋga. Gazlavay Papaŋ, ta’, a vəlar Mesəfney aŋga masa aŋga ma ləvar a da vəldara. Ta’, Yesu a slərdandakwara Mesəfney a, a ray aləkwa. Ara Mesəfney a ma vəlndakwar gədaŋ ŋga key cek masa akwar ma hətmar ta masa akwar ma cəndamara wure keɗe. ");
INSERT INTO mif_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ya sərkwa Davit ta ray aŋga ta təpey a vaɗ na, daa ba. Ama aa guzley da ray Kəriste zleezle, a ləvey: “Bay Gazlavay a ləvar a Bay aɗaw Mahura: Sawa, njey ta har-zəmay aɗaw ");
INSERT INTO mif_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","haa kasl pas masa yah ma da pata masa-gəra akah hay asi salay akah.”» ");
INSERT INTO mif_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Piyer a ləvtar saya: «Si Israyel hay tabiya a sərmara fara fara, ndaw masa Gazlavay ma pa ŋga Bay Mahura ta ŋga ndaw masa ma da ləhdata ndəhay na, ara Yesu, ndaw masa akwar ma dərmara fa hwadam mazlaŋgalakaya heyey.» ");
INSERT INTO mif_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ndəhay makustakaya heyey, a cəndamara mey a keɗe na, mevel a təɗtar ga. A ləvmar ŋgada Piyer ta ŋgada ndəhay meslərey siya hay: «Kaa ya da kam na, kwara, məlma ala hay?» ");
INSERT INTO mif_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyer a mbəɗdatara, a ləvtar: «Mbəɗdamara menjey akwar, səpmara Gazlavay ta mevel pal. Cacəfɗam *baptem ta mezəley ŋga Yesu Kəriste, amba Gazlavay a mbəkdakwara mebərey akwar. Anda keɗe, Gazlavay a vəlkwar Mesəfney aŋga la. ");
INSERT INTO mif_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gazlavay a ləvey, a vəldatara Mesəfney aŋga la a ndəhay. A ləvey a da vəldakwara ŋgada akwar, ŋgada bəz akwar hay, ta ŋgada ndəhay masa dəreŋ, ndəhay tabiya masa Gazlavay, Bay aləkwa, ma da zəlta.» ");
INSERT INTO mif_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ta’, Piyer aa guzltar mey mekele mekele saya amba a təɓmara mey aŋga ŋga vəltar gədaŋ. A ləvtar: «Wuɗkam ta ndəhay malamba da bəla wure keɗe, amba Bay Gazlavay a ləhdakwar daa sariya ma da kərzata.» ");
INSERT INTO mif_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ndəhay ga da wuzlah ndəhay a ŋgene, a təɓmara mey ŋga Piyer, ta’, a hətam baptem. Ta pas ŋgene, ndəhay a key gabal maakar ma samawa a dey ndəhay ma təɓa mey ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mandaw mandaw ndəhay ma təɓa mey ŋga Yesu fa jəkam sləmay fa meesərkedey ŋga ndəhay aŋga hay meslərey ta mevel pal, a njam macəmkaya pal anda məlmaŋ hay, fa wunam peŋ ŋga sərfedey meməcey ŋga Yesu, fa dəram daŋgay a Gazlavay daa slam a. ");
INSERT INTO mif_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ndəhay meslərey hay a fa kam maazla hay mekele mekele ŋga wuzdərwa gədaŋ ŋga Bay Gazlavay aa ta ata. Ndəhay tabiya a rəzlam da ray maazla hay a, a namar ray a Bay Gazlavay maja. ");
INSERT INTO mif_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ndəhay ma təɓa mey ŋga Yesu na, macəmkaya ɗay letek, a wunkamara zleley ata hay da wuzlah ata. ");
INSERT INTO mif_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Anda meləvey, a həɗkadamata ley ata hay ta cek ata hay, a wunkamara dala ha da wuzlah ata tabiya. Kwa waawa a hətey cek masa təɗe ŋga wusa. ");
INSERT INTO mif_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mandaw mandaw fa kusam aa *Way-mekey-kwakwas ŋga Gazlavay ta mevel pal. Da way ata hay na, a zəmam ɗaf daa slam a ta meesəmey, ta mevel maaya. ");
INSERT INTO mif_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ata fa həlmamara Gazlavay. Ndəhay tabiya aa həmdamata. Mandaw mandaw Bay Mahura fa zəlwa ndəhay mekele mekele masa ma ləham sem daa mebərey ŋgadaa dey ata. ");
INSERT INTO mif_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ta pas laŋgar daha, ata *Piyer ta *Jaŋ fa diyam aa *Way-mekey-kwakwas ŋga Gazlavay ŋga dərwa daŋgay. Ara ta pas ŋgaa kwaɗ, pas təɗe medərey-daŋgay ŋga *Jəwif hay. ");
INSERT INTO mif_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Gweegwe ta mey-mbew ŋga Way-mekey-kwakwas a, mey-mbew ma zəlmara «Mey-mbew Membey,» ndaw daha manjakaya feteɗe. Ndaw aha, maahəlɓakaya dəga ŋga mayawa aŋga. Mandaw mandaw ndəhay fa handamərwa, a njadamara feteɗe, amba a rəkey dala fa ndəhay ma mbəzam aa Way-mekey-kwakwas a. ");
INSERT INTO mif_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ta pas ŋgene, ndaw aha a hətatar ata Piyer ta Jaŋ fa diyam aa Way-mekey-kwakwas a. Ta’, aa cəfɗafatar dala. ");
INSERT INTO mif_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ata Piyer ta Jaŋ a nəkfamara, Piyer a ləvar: «Nəkfandar.» ");
INSERT INTO mif_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ndaw aha a nəkfata maaya maaya, a wulkey daa ray aŋga, a ləvey: «A da vəlmaya cek.» ");
INSERT INTO mif_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ama Piyer a ləvar: «Dala da har aɗaw na, daa ba səlak, ama cek masa da har aɗaw na, ya vəldakawa la. Ta gədaŋ ŋga Yesu *Kəriste, ndaw *Nezeret, ya fa ləvka, sləkɗey, daw ta salay akah.» ");
INSERT INTO mif_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ta’, Piyer a kərza fa har-zəmay, a sləkɗada. Wure wure ŋgene, salay ŋga ndaw aha, ta jerey cay. ");
INSERT INTO mif_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ta’, a lecey, a jəvey, a zlar madaw. A mbəzam aa Way-mekey-kwakwas ŋga Gazlavay ta ata Piyer ta Jaŋ heyey. Aŋga fa daw, fa jəvey, fa həlma Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ndəhay masa daa Way-mekey-kwakwas a tabiya a hətmar aŋga fa daw, fa həlma Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","A sərmara ara ndaw masa salay maahəlɓakaya ma njey fa Mey-mbew Membey ŋga rəkey heyey. Ata tabiya a rəzlam ga da ray cek ma key ta aŋga, a sərmara cek masa ata ma da kam ba. ");
INSERT INTO mif_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ata *Piyer ta *Jaŋ leŋ ndaw masa salay maahəlɓakaya heyey, ata dasi balak ŋga *Way-mekey-kwakwas ŋga Gazlavay mezəley «Balak ŋga *Salamaŋw.» Ndaw aha, a gəmey ŋga mbəkdata ata Piyer ta Jaŋ ba. Ndəhay tabiya feteɗe a hwamawa ŋgada fa ata, maja a rəzlam ga da ray ndaw masa salay maahəlɓakaya heyey. ");
INSERT INTO mif_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Masa Piyer ma hətatar ndəhay fa samawa na, a ləvtar: «Akwar ndəhay *Israyel hay, ka rəzlam anda keɗe na, maja me? Ka nəkfamandar me? Ka wulkam ndaw keɗe salay aŋga a jerey ŋga daw kaa na, ara ta gədaŋ ala daw, da daa ba, maja ala ma kam cek maaya ta cəveɗ e fa mey ŋga Gazlavay daw? Kay, kəne ba! ");
INSERT INTO mif_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ara Gazlavay ma mbəlda ndaw aha, Gazlavay masa *Abəraham, *Izak, leŋ *Jakwap, papaŋ ŋga papa aləkwa hay zleezle, ma namar ray. Ara Gazlavay ma wuzdandakwara aŋga fa həslar ray a Yesu, ndaw ma ka sləra aŋga. Akwar ta ray akwar, ka ta vəldamara Yesu a la a har mahura hay, kwa Pilat a wuɗey ŋga mbəkda, ama akwar ta təɓmara daa ba. ");
INSERT INTO mif_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yesu na, ara ndaw pal masa maaya ma sawa ta fa Gazlavay. Ama akwar ka wuɗmara ba, ka ləvmar a Pilat na, ŋga pəskakwar ndaw ma kəɗa ndaw vagay jak. ");
INSERT INTO mif_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Anda keɗe, ndaw ma vəltar heter a ndəhay jak na, akwar ta kəɗmara sem, ama Gazlavay ta sləkɗadərwa sem daa meməcey. Ala ta ray ala fa kam sede da ray masləkɗawa aŋga ha. ");
INSERT INTO mif_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ndaw masa akwar ma hətmar da cakay aɗaw keɗe na, ka sərmara. Salay aŋga a jerey na, ara ta gədaŋ ŋga Yesu, maja ala ma pamara Yesu a ŋga ndaw ala fara fara. Maja ala fa pamara Yesu ŋga ndaw ala fara fara na, mbal! a mbəley maaya maaya anda akwar tabiya ma hətmar ta dey akwar keɗe. ");
INSERT INTO mif_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Ama wure keɗe, məlma aɗaw hay, ya səra cek masa akwar ta mahura akwar hay ma kamara a Yesu na, a key ka sərmara ba. ");
INSERT INTO mif_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Cek aha ma key keɗe na, Gazlavay ta wuzda la ta mey ndəhay ma təla mey aŋga hay zleezle, a ləvey, si cəma *Kəriste masa aŋga ma da slərdərwa na, a sərey banay. ");
INSERT INTO mif_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Maja ŋgene, ya fa ləvkwar: mbəɗdamara menjey akwar, mbəɗmawa dey ŋgada fa Bay Gazlavay, amba a mbəkdakwara mebərey akwar. ");
INSERT INTO mif_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Anda keɗe, Gazlavay a məskadakwar vaw la. A slərkwar Kəriste la, anda meləvey, Yesu, ndaw masa aa ma wala ŋga ləhdakwar dəga zleezle heyey. ");
INSERT INTO mif_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wure keɗe si Yesu a njawa da gazlavay da vaɗ ɗagay, haa kasl pas masa Gazlavay ma da ɗiyta cek hay tabiya mawiya anda aŋga ma ləvey zleezle. Gazlavay taa guzley la da ray mey a ta mey ndəhay ma təla mey aŋga hay. ");
INSERT INTO mif_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ara anda keɗe *Mawiz maa guzley zleezle, a ləvey: “Bay Gazlavay masa akwar ma namar ray, a da slərkwar *ndaw ma təla mey anda yah. Ndaw a na, ara ndaw daa səkway akwar anda yah may. Mey tabiya masa aŋga ma daa guzldakwara na, jəkam sləmay fa vəɗa. ");
INSERT INTO mif_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kwa waawa ma cənar mey a ndaw a ba na, Gazlavay a bada la da wuzlah ndəhay aŋga hay, ŋgaa zəɗey.” ");
INSERT INTO mif_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«Yaw, fara fara, ndəhay ma təla mey ŋga Gazlavay ga, dəga fa *Samiyel ta ndəhay ma təla mey ŋga Gazlavay mekele mekele fa dəɓa aŋga, ata tabiya ta wuzdamara mey da ray cek hay masa ma kam wure keɗe la. ");
INSERT INTO mif_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Məlma aɗaw hay, Gazlavay maa guzley ta mey ndəhay ma təla mey aŋga hay keɗe na, ara ŋgada akwar. Gazlavay a jəwam mey ta papa aləkwa hay zleezle, a ləvar a Abəraham: “Ya pəstar mey la a ndəhay da bəla tabiya ta fa səkway akah.” *Mejəwey-mey a keɗe na, ara ŋgada akwar may. ");
INSERT INTO mif_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Anda keɗe, Gazlavay ta wuzdakwara Yesu, ndaw ma ka sləra aŋga la. A slərdərwa na, ŋgada akwar ɗagay. A slərdərwa amba a kakwar maaya, ŋga mbəɗdakwara menjey akwar maaya ba ŋgene.» ");
INSERT INTO mif_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Masa ata *Piyer ta *Jaŋ faa guzlmatar a ndəhay makustakaya heyey na, ndəhay ma ka kwakwas ŋga Gazlavay, ta *bay-ray ŋga ndəhay ma jəɗa Way-mekey-kwakwas, leŋ ndəhay *Saduse hay, a samawa a cakay ata. ");
INSERT INTO mif_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mevel fa catar maja ata Piyer ta Jaŋ faa sərkadamata ndəhay, a ləvmatar ndəhay maməctakaya a da sləkɗamawa daa meməcey maja Yesu ta sləkɗawa sem daa meməcey. ");
INSERT INTO mif_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mahura hay heyey, ta’, a kərzamata ata Piyer ta Jaŋ a, a handamata, a gərcamata aa fərsəne. Ama ta kamatar sariya ta pas ŋgene daa ba, maja pas daa saba. ");
INSERT INTO mif_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ta ŋgene he cəpa, ndəhay ga da wuzlah ndəhay makustakaya ma cəndamara mey ŋga Piyer heyey ta təɓmara mey ŋga Yesu la cəŋga. Anda keɗe, ndəhay ma təɓa mey ŋga Yesu ta səkam la a dey a, a key gabal zlam. ");
INSERT INTO mif_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pepərek e, bay-ray hay ŋga *Jəwif hay, ta mahura hay ŋga Jəwif hay, leŋ *ndəhay maa sərkada kwakwas ŋga Mawiz, a kusam feteɗe da *Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Da wuzlah ndəhay makustakaya ha na, ara ata Han, *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay, Kayif, Jaŋ, Alekzandəre leŋ ndəhay siya tabiya da way Han. ");
INSERT INTO mif_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ta’, a handamatərwa ata Piyer ta Jaŋ heyey, a lacadamata fa mey ata, ndaw masa ma hətar salay aŋga heyey aa da cakay ata. A cacəfɗamata ata Piyer ta Jaŋ, a ləvmatar: «Ka mbəldamara ndaw masa salay maahəlɓakaya keɗe na, ta gədaŋ wura? Ma vəldakwara gədaŋ ŋga key maazla keɗe na, wa?» ");
INSERT INTO mif_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Piyer, marəhkaya ta *Mesəfney ŋga Gazlavay, ta’, a mbəɗdatara, a ləvtar: «Akwar, bay-ray hay ta mahura ala hay, ");
INSERT INTO mif_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kaa cəfɗamandar tasana maja ala ma kam cek maaya ŋgada ndaw maahəlɓakaya keɗe, daw? Kaa cəfɗamandar, ndaw aha a hətar salay aŋga na, kwara, ba diya? ");
INSERT INTO mif_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yaw, akwar cəpa ta ndəhay *Israyel hay tabiya, si ka sərmara ndaw malacakaya fa mey akwar keɗe na, a hətar salay aŋga ta gədaŋ ŋga Yesu *Kəriste, ndaw *Nezeret. Ara aŋga masa akwar ma dərmara fa hwadam mazlaŋgalakaya ŋga məcey, ama Gazlavay ta sləkɗadərwa sem daa meməcey. ");
INSERT INTO mif_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mawuzlalakaya daa ɗerewel ŋga Gazlavay da ray Yesu, a ləvey: “Aŋgwa masa akwar, ndəhay ma ləma way, ma kəzlamara ta cakay na, anja ara aŋgwa maaya, ma fənta siya hay jak.” ");
INSERT INTO mif_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ahaw, ya fa ləvkwar, Gazlavay a ləhdata ndəhay daa mebərey na, si ta fa Yesu gway. Ndaw mekele da bəla keɗe masa Gazlavay ma vəlar gədaŋ ŋga ləhey ndəhay daa mebərey na, daa ba səlak.» ");
INSERT INTO mif_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mahura hay ma sla yawa ŋga Jəwif hay feteɗe heyey na, a nəkmara na, ata Piyer ta Jaŋ fa zluram daa ba səlak. A rəzlam ga, maja a sərmara, ata Piyer ta Jaŋ, ara ndəhay anda siya hay gway, ta jaŋgam daa ba. A sərfadamara ata Piyer ta Jaŋ ta pəkam la ta ata Yesu. ");
INSERT INTO mif_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Masa mahura hay ma sla yawa ha ma hətmar ndaw masa ma hətar salay aŋga heyey malacakaya da cakay ata Piyer ta Jaŋ na, kwa ta gwamara ŋga mbəɗdamatara daa saba. ");
INSERT INTO mif_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Da ray ŋgene, mahura hay a, a badamatərwa la daa way a, a zlamar mesley yawa da wuzlah ata. ");
INSERT INTO mif_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","A ləvam: «Ya da kadamatakwa ndəhay keɗe na, kwara? Maja ndəhay da Jeruzelem tabiya a sərmara fara fara Gazlavay ta key maazla mahura la ta fa ata. Ya gwakwa ya rəskwa maazla ha keɗe ba. ");
INSERT INTO mif_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ama amba mey keɗe a daw fa mey fa mey saba, asaya amba ndəhay mekele a cəndamara ba na, si ya təktakwa ndəhay cew keɗe. Ya təktakwa a da wuzdamara mey da ray Yesu a ndəhay saba səlak.» ");
INSERT INTO mif_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ta’, a zəlmata saya, a təkmata ŋgaa sərkedey ndəhay da ray mey ŋga Yesu, asaya, a təkmata kwa ŋga key maɗay ŋga maaya ta ndəhay da ray Yesu. ");
INSERT INTO mif_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ama ata Piyer ta Jaŋ a mbəɗdamatara, a ləvmatar: «Akwar ta ray akwar, nəkmara mey keɗe cey. Maaya fa mey ŋga Gazlavay na, ya təɓam mey akwar da ray mey ŋga Gazlavay daw? ");
INSERT INTO mif_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ala na, si cəma yaa guzlam da ray cek hay masa ala ma hətmar ta dey ala ta masa ala ma cəndamara ta sləmay ala.» ");
INSERT INTO mif_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Mahura hay ma sla yawa ŋga Jəwif hay kaa heyey ta hətam mey ŋga sərdamata banay daa ba, maja ndəhay tabiya fa həlmamara Gazlavay maja maazla ha. Ndaw masa ma hətar salay aŋga ta maazla heyey, mevey aŋga a fəna kwakwar məfaɗ. Maja mahura hay a ta hətam mey da ray ata daa ba na, a kamatar mey ta gədaŋ saya, ta’ a mbəkdamata. ");
INSERT INTO mif_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Fa dəɓa ha, mahura hay ma sla yawa ŋga *Jəwif hay heyey ma mbəkdamata ata *Piyer ta *Jaŋ la na, ta’, a vəham fa ndəhay ata hay. A kadamatara mey masa *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ta mahura hay ŋga Jəwif hay kaa heyey ma ləvmatar. ");
INSERT INTO mif_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ndəhay ata hay a, a jəkfamatar sləmay. Ata tabiya ta’, a dəram daŋgay ŋgada Gazlavay ta mevel pal, a ləvam: «Bay Gazlavay, Mawaca-waca, ara kah ma ləma slam da vaɗ ta cek hay da hwaɗ a, ara kah ma ləma slam da hwayak ta cek hay da hwaɗ a, ara kah ma ka bəlay ta cek hay da hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ara kah maa guzley zleezle ta mey ndaw akah, *Davit, papaŋ ŋga papa ala. Ka wuzdara ta fa Mesəfney akah amba a ləvey: “Ndəhay masa Jəwif hay ba fa yam mey na, maja me? A slam yawa ŋga tede ŋga nəsey Bay Gazlavay na, maja me? ");
INSERT INTO mif_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bay hay da bəla keɗe fa cakalam mey, mahura hay fa kusam ŋga key vəram ta Bay Gazlavay leŋ ta ndaw masa aŋga ma wala.” ");
INSERT INTO mif_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ahaw, cek aha ta key la anda keɗe. Fara fara, Bay *Herawt ta *Pawns Pilat ta ndəhay masa Jəwif hay ba, ta *Israyel hay, ata tabiya ta kusam la daa berney a keɗe, da ray Yesu, ndaw ma ka sləra akah masa kah ma wala ŋga ləhdata ndəhay. ");
INSERT INTO mif_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ata ma kamata cek hay tabiya keɗe na, a kamara anda kah Bay Gazlavay ma wuɗey ŋga ka ta gədaŋ akah dəga zleezle. ");
INSERT INTO mif_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wure keɗe, Bay Gazlavay, nəka, ata fa kamandar mey ta gədaŋ. Vəlndar gədaŋ ŋgada ala, ndəhay ma ka sləra akah hay, ŋga wuzey mey akah ta mandərzay daa dey ba səlak. ");
INSERT INTO mif_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Wuzdərwa gədaŋ akah! Mbəldata masa-macay hay, key maazla hay ŋga wuzwa gədaŋ akah aa ta ala, ta gədaŋ ŋga Yesu, ndaw ma ka sləra akah.» ");
INSERT INTO mif_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ata ma ndəvdamara medərey-daŋgay la na, slam masa ata ma kusam da hwaɗ a, a wusey gəɗ-geɗ. Ata tabiya marəhtakaya ta *Mesəfney ŋga Gazlavay, a wuzdamara mey ŋga Gazlavay ta mandərzay daa dey saba. ");
INSERT INTO mif_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ndəhay ma təɓa mey ŋga Yesu tabiya a njam mewulkey ata letek, mevel ata macəmkaya pal. Ndaw masa ma ləvey: «Zleley aɗaw na, yah pal ma wa» na, daa ba. Ama a wunkamara zleley ata hay da wuzlah ata. ");
INSERT INTO mif_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ndəhay meslərey ŋga Yesu a kam sede da ray masləkɗawa ŋga Bay Mahura Yesu daa meməcey na, ta gədaŋ ŋga Gazlavay. Ata tabiya, Bay Gazlavay ta pəstar mey la ga. ");
INSERT INTO mif_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Da wuzlah ata na, kwa ndaw ma hurey cek mezəmey daa ba. Ndaw masa ley aŋga daha, da daa ba, way aŋga daha na, a həɗkada. A handərwa dala ha ");
INSERT INTO mif_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a har ndəhay meslərey a. Ndəhay meslərey a, a wunkamatara dala ha ŋgada ndəhay masa daa *mecəmey-ray ŋga ndəhay ŋga Yesu. A vəldamara dala ha ŋgada ndaw a ndaw a təɗe ŋga wusa. ");
INSERT INTO mif_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ndaw da wuzlah ndəhay ŋga Yesu a daha, mezəley *Jawzef. Aŋga ndaw daa səkway ŋga *Levi, a yawa da Sipəre. Ndəhay meslərey a, a zəlmara na, *Barnabas, anda meləvey «ndaw ma vəltar gədaŋ a ndəhay.» ");
INSERT INTO mif_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ley aŋga daha. A həɗkada ley a. Fa dəɓa ha, a handərwa dala ha, a vəldatara a ndəhay meslərey hay. ");
INSERT INTO mif_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ndaw daha mezəley *Ananiyas ta ŋgwas aŋga Safira, a cəmdamara ɗay ata letek. Ta’, Ananiyas a həɗkada ley ata. ");
INSERT INTO mif_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","A wunka dala ha cew, ta’, a ɓada siya. Siya may, a handatara a ndəhay meslərey heyey, a vəldatara anda ara dala ŋga ley ata ha cəpa. Ŋgwas aŋga a səra cek masa zel e ma ka. ");
INSERT INTO mif_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ama *Piyer a ləvar: «Ananiyas, ka mbəkda *Sataŋ amba a mbəzey aa mevel akah na, maja me? Ka ta ɓadərwa siya ŋga dala ŋga ley akah ha sem. Anda keɗe, ka ta mbərzla *Mesəfney ŋga Gazlavay sem. ");
INSERT INTO mif_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Daa masa kah ma həɗkada daa ba na, kah ma wa, ba diya? Kwa kah ma həɗkada la keɗe, kah ma wa dala ha. Ka wulkey daa ray akah ŋga key cek keɗe na, maja me? Ka mbərzley kaa na, ndəhay ba, ama ka mbərzley Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Masa Ananiyas ma cənda mey a la anda keɗe na, a təɗey, pam! a məcey. Mandərzay a katar kwa ara mey ba, a ndəhay ma cəndamara mey a. ");
INSERT INTO mif_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ta’, gula hay a samawa, a mbəzmara vagay a, a badamərwa, a diyam a pəshamara aa cəvay. ");
INSERT INTO mif_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ler maakar fa dəɓa ha na, ŋgwas aŋga, a wuswa. Ama a səra cek masa ma key ta zel e ba. ");
INSERT INTO mif_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piyer aa cəfɗa, a ləvar: «Kadiwa, ka həɗkadamara ley akwar na, dala ha keɗe tar daw?» A mbəɗdara, a ləvar: «Ahaw, ya həɗkadamara kəne.» ");
INSERT INTO mif_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Anda keɗe, ta’, Piyer a ləvar: «Ka cəmdamara ɗay akwar ta zel akah, ŋga jedey Mesəfney ŋga Gazlavay na, maja me? Ehe, gula hay ma pəshamara zel akah, ata fa mey-slam. A da pəshamaka kəne may.» ");
INSERT INTO mif_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wure wure ŋgene, ŋgwas aha a təɗey fa mey aŋga, pam! a məcey. Gula hay keɗe heyey a mbəzmawa, a hətfamara ta məcey sem. Ta’, a lamara, a handamara, a pəshamara a cakay zel e. ");
INSERT INTO mif_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Fa dəɓa ha, mandərzay a katar ga ara mey ba ŋgada ndəhay daa Egəliz tabiya ta ŋgada ndəhay ma cəndamara mey a. ");
INSERT INTO mif_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ndəhay meslərey ŋga Yesu fa kam maazla hay ga da wuzlah ndəhay ŋga wuzdərwa gədaŋ ŋga Gazlavay. Fa ɗar a, fa ɗar a, ndəhay ma təɓa mey ŋga Yesu tabiya fa diyam aa *Way-mekey-kwakwas ŋga Gazlavay, fa kusam feteɗe ta mevel pal dasi Balak ŋga *Salamaŋw heyey. ");
INSERT INTO mif_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ndəhay siya ma təɓmara mey ŋga Yesu fara fara ba na, a wuɗam ŋga kusey ta ata ba, maja a zluram, ama ndəhay tabiya faa həmdamata ndəhay ma təɓa mey ŋga Yesu a cəŋga. ");
INSERT INTO mif_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mandaw mandaw ndəhay fa samawa a dey a, a dey a, zel hay, ŋgusay, fa təɓmara mey ŋga Bay Mahura, a cəmam a dey ndəhay ŋga Yesu heyey. ");
INSERT INTO mif_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Maja ndəhay meslərey ŋga Yesu a fa kam maazla hay ta gədaŋ ŋga Gazlavay na, ndəhay a handamawa masa-macay hay a mey-cəveɗ. A handamatərwa feteɗe, a nadamata a ray ɓeɓele hay, da daa ba, a ray gegədeɗ hay, amba da masa *Piyer fa daw taa cəveɗ e ŋgene na, meezeɗ aŋga a wusey a ray siya hay, a mbəlam. ");
INSERT INTO mif_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ndəhay ga a samawa da slala hay mekele mekele masa gweegwe ta berney ŋga *Jeruzelem, a handamawa masa-macay hay, ta ndəhay masa ta malula da ray. Ndəhay a tabiya ta mbəlam sem. ");
INSERT INTO mif_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yaw, *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay ta ndəhay da cakay a, anda meləvey ndəhay masa da wuzlah *Saduse hay, səleŋ a katar ga ta ndəhay meslərey ŋga Yesu heyey. A slam yawa amba a sərdamata banay. ");
INSERT INTO mif_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ta’, a kərzamata meedey ndəhay tabiya, a handamata aa fərsəne. ");
INSERT INTO mif_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ama dasi tavaɗ ŋgene, maslaŋ ŋga Gazlavay a pawa salay da vaɗ, a wura mey-slam ŋga fərsəne he, a badatərwa ndəhay meslərey heyey, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Diyam aa *Way-mekey-kwakwas ŋga Gazlavay, wuzdamatara mey hay tabiya da ray heter mawiya a ndəhay.» ");
INSERT INTO mif_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ndəhay meslərey heyey a cənmar mey a maslaŋ a. Slam bəŋ-beŋ na, ta’, a diyam, a mbəzam aa Way-mekey-kwakwas ŋga Gazlavay heyey, a zlamar ŋgaa sərkadamata ndəhay. Daa ŋgene, ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay ta ndəhay da cakay a, a kusmatərwa bay-ray hay ŋga Jəwif hay tabiya ŋga sley yawa. Ta’, a sləram ndəhay ŋga ŋgəlmatərwa ndəhay meslərey ŋga Yesu kaa heyey daa fərsəne. ");
INSERT INTO mif_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ndəhay heyey a wusam aa fərsəne he na, ta hətfamatar ndəhay meslərey ŋga Yesu daa ba. Ta’, a vəhmawa, a kadamatara a ndəhay mahura hay ma sla yawa kaa heyey, ");
INSERT INTO mif_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","a ləvmatar: «Ala ta hətfamatar daa ba. Ya wusam na, mey-slam magərcakaya maaya maaya, ndəhay ma jəɗmata ata fa mey-slam a, ama ya wurmara mey-slam a, ya mbəzam aa way a na, ndəhay a, ata da hwaɗ a daa saba.» ");
INSERT INTO mif_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","*Bay-ray ŋga ndəhay ma jəɗa Way-mekey-kwakwas ŋga Gazlavay, ta *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay kaa heyey a cəndamara na, mey a, a həɓtar ray, a sərmara cek ma key ta ndəhay meslərey kaa heyey ba. ");
INSERT INTO mif_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ndaw daha, ta’, a sawa, a ləvtar: «Ehe, jəkam sləmay, ndəhay masa akwar ma ndəkwdamata aa fərsəne heyey na, ata daa Way-mekey-kwakwas ŋga Gazlavay, faa sərkadamata ndəhay.» ");
INSERT INTO mif_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ta’, bay ŋga ndəhay ma jəɗa Way-mekey-kwakwas ŋga Gazlavay ta sewje aŋga hay a diyam, a ŋgəlmatərwa ndəhay meslərey heyey. Sewje hay a, ta kamatar mey ta gədaŋ daa ba, maja a zluram ndəhay a daa zakamata ta aŋgwa. ");
INSERT INTO mif_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Fa dəɓa ha masa sewje hay a ma ŋgəlmatərwa la na, ta’, a lacadamata fa mey ŋga mahura hay ma sla yawa ha. *Ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay heyey aa cəfɗata, ");
INSERT INTO mif_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","a ləvtar: «Ala ta təkmakwar sem ŋga wuzey mey a ndəhay da ray ndaw aha, ama akwar fa kamara cəŋga. Fara fara, akwar ta wuzdamara mey a sem a ndəhay tabiya da *Jeruzelem. Asaya, ka wuɗam ndəhay tabiya a wulkam na, ara ala ma kəɗmara ndaw aha, ba diya?» ");
INSERT INTO mif_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","*Piyer ta ndəhay meslərey siya a mbəɗdamara, a ləvmar: «Si cəma ya cənmar mey a Gazlavay da ray ala ma da cənmatar mey a ndəhay. ");
INSERT INTO mif_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Akwar ta kəɗmara Yesu la vagay fa hwadam mazlaŋgalakaya. Ama Gazlavay ŋga papaŋ ŋga papa aləkwa hay ta sləkɗadərwa sem daa meməcey. ");
INSERT INTO mif_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yesu a na, ara ndaw masa Gazlavay ma la a vaɗ a har-zəmay aŋga. A pa ŋga ndaw mahura, Bay ma ləhdata ndəhay. A ka kəne amba a wurey cəveɗ ŋgada ndəhay *Israyel hay ŋga mbəɗdamara menjey ata, ŋga səpam Gazlavay ta mevel pal, amba Gazlavay a mbəkdatara mebərey ata. ");
INSERT INTO mif_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ala na, ya fa kam sede da ray cek hay a keɗe. *Mesəfney ŋga Gazlavay fa key sede da ray a kəne may, Mesəfney masa Gazlavay ma vəldatara a ndəhay ma cənmar mey.» ");
INSERT INTO mif_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ndəhay mahura hay ma sla yawa heyey a cəndamara na, mevel a catar ga ara mey ba, a wuɗam ŋga kəɗmata vagay. ");
INSERT INTO mif_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ama ndaw Fariza pal da wuzlah ata daha, mezəley aŋga Gamaliyel. Aŋga ndaw mahura maa sərkada *kwakwas ŋga Mawiz, ndəhay tabiya faa həmdamara. Ta’, a lecey da wuzlah mahura hay ma sla yawa kaa heyey, a ləvtar a ndəhay ŋga badamatərwa ndəhay meslərey ŋga Yesu a ɗagay. ");
INSERT INTO mif_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Fa dəɓa ha a ləvtar a mahura hay ma sla yawa ha: «Akwar Israyel hay, wam vaw da ray cek masa akwar ma da kamatara a ndəhay keɗe. ");
INSERT INTO mif_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sərfadamara, zleezle ndaw mezəley Tewdas ta sawa la, a ləvey: “Yah, ndaw mahura.” Ndəhay ga, a key temere məfaɗ ma səpmara. Ama ndəhay mekele hay ta kəɗmara sem vagay. Ndəhay ma səpmara tabiya heyey, taa kwacam ray sem, mey a daa saba. ");
INSERT INTO mif_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Fa dəɓa aŋga, ndaw daha mezəley Juda, ndaw *Galile. Aŋga ta sawa la daa ɗar hay masa ndəhay fa sləfam vaw. Aŋga ha na, ta həldata ndəhay la ŋga səpmara, ndəhay ga ta diyam la asiya. Fa dəɓa ha, ta’, a kəɗmara vagay saya, ndəhay ma diyam asiya heyey taa kwacam ray sem may. ");
INSERT INTO mif_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Da ray ŋgene, ya fa ləvkwar: ka da həɓam ray maja ndəhay a keɗe saba, mbəkdamata ŋga diyam. Mewulkey ata ta sləra ata ha, da a sawa ta fa gədaŋ ŋga ndaw-magədaŋ na, a ndəvey la. ");
INSERT INTO mif_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ama da mewulkey ata ta sləra ata ha a sawa ta fa gədaŋ ŋga Gazlavay na, ŋgene ka gwamara ŋgaa zəɗdamara daa ba. Wam vaw, ka da kəɗam vaw ta Gazlavay ba.» Mahura hay ma sla yawa heyey, ta’, a təɓmara mey aŋga. ");
INSERT INTO mif_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","A zəlmatərwa ndəhay meslərey heyey. A sləɗmata, a ləvmatar: «Ka da wuzam mey da ray Yesu saba.» Ta’, a mbəkdamata. ");
INSERT INTO mif_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ndəhay meslərey a, a sləkdam, a mbəkdamata ndəhay ma sla yawa heyey, ta’, a diyam ta meesəmey maja Gazlavay ta nəkta la, ata təɗe ŋga sərey banay maja Yesu. ");
INSERT INTO mif_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mandaw mandaw ata fa diyam aa Way-mekey-kwakwas ŋga Gazlavay leŋ a way ndəhay mekele mekele. Ata faa sərkadamatara *Mey-maaya-mawiya da ray Yesu a ndəhay feteɗe, kwa a mbəkdamara ba. Ata fa wuzdamatara Yesu na, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay. ");
INSERT INTO mif_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Daa ŋgene, ndəhay ma təɓa mey ŋga Yesu fa səkmawa, a dey a, a dey a. Da wuzlah ata na, *Jəwif hay maa guzlam mey Gərek daha. A yam mey ta Jəwif hay mekele daa hwayak a ŋgene, a ləvam: «Ŋgwas-vagay hay masa da wuzlah ala, fa hətam cek mezəmey masa ata ma wunkamatara mandaw mandaw na, daa ba.» ");
INSERT INTO mif_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Da ray ŋgene, ndəhay meslərey kuraw a ray a cew heyey, ta’, a kusmata ndəhay ma təɓa mey ŋga Yesu tabiya, a ləvmatar: «Ala na, ya mbəkdamara mewuzey mey ŋga Gazlavay, amba ya wunkam ɗaf na, a zlərda ba. ");
INSERT INTO mif_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Məlma ala hay, maaya na, ka walam *ndəhay maasala da wuzlah akwar, masa ndəhay faa həmdamata, masa marəhtakaya ta *Mesəfney ŋga Gazlavay, ndəhay masa ta leŋgesl, amba ya vəldamatara sləra ha asi har ata. ");
INSERT INTO mif_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ala na, ya vəldamara ray ala ŋga dərey daŋgay a Gazlavay, ta ŋga wuzey mey aŋga.» ");
INSERT INTO mif_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mey a keɗe a mbafatar a ndəhay tabiya. Ta’, a walam Etiyen, ndaw ma təɓa mey ŋga Yesu maaya maaya, marəhkaya ta Mesəfney ŋga Gazlavay, leŋ *Fəlep, Pərakwar, Nikanawr, Timaŋw, Parmanas, asaya, Nikwala, ndaw Antiyaws masa ma mbəkda kwakwas aŋga zleezle ŋga səpey kwakwas ŋga Jəwif hay. ");
INSERT INTO mif_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ta’, a handamatərwa ndəhay maasala ha fa ndəhay meslərey heyey. Ndəhay meslərey a, ta’, a dəram daŋgay, a pamatar har a ray, amba a kamara sləra ata ta gədaŋ ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Yaw, mey ŋga Gazlavay fa daw fa mey fa mey. Da *Jeruzelem ndəhay ma təɓa mey ŋga Yesu fa səkmawa a dey a, a dey a. Ndəhay ga ma ka kwakwas ŋga Gazlavay a təɓmara mey ŋga Yesu may. ");
INSERT INTO mif_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiyen na, Bay Gazlavay ta pəsar mey la ga, a vəlar gədaŋ aŋga. Da ray ŋgene, aŋga fa key maazla hay ga ma rəzley ndaw da wuzlah ndəhay. ");
INSERT INTO mif_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ama ndəhay siya hay a zlamar ŋga cakalafamar mey. Ara *Jəwif hay ma samawa daa berney ŋga Siren leŋ daa berney ŋga Alekzandəri. Ata da wuzlah ndəhay ma kusam daa *way-mewuzey-mey ŋga Gazlavay masa ata ma zəlmara «Way ŋga ndəhay ma bamawa daa beke.» Mekele hay ma cakalafamar mey na, a samawa daa hwayak ŋga Silisi leŋ daa hwayak ŋga Azi. A zlamar ŋga key yawa ta Etiyen e. ");
INSERT INTO mif_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ama ta gwamara a ray a daa ba, maja aa guzltar ta leŋgesl masa *Mesəfney ŋga Gazlavay ma vəldara. ");
INSERT INTO mif_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Da ray ŋgene, a diyam, a vəlmatar dala a ndəhay amba a mbərzlam a ray Etiyen e, a ləvam: «Ya cəndamara na, ndaw keɗe fa cəɗa *Mawiz, fa cəɗa Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","A həldamata ndəhay cəpa, ta mahura hay ŋga Jəwif hay, leŋ ndəhay maa sərkada kwakwas ŋga Mawiz. Ta’, a diyam, a kərzamara Etiyen, a handamara fa mahura hay ma sla yawa ŋga Jəwif hay. ");
INSERT INTO mif_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ta’, a ŋgəlmawa ndəhay membərzley, amba a ləvam: «Mandaw mandaw, ndaw keɗe faa guzley mey maaya ba da ray *Way-mekey-kwakwas ŋga Gazlavay ta da ray kwakwas ŋga Mawiz. ");
INSERT INTO mif_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ya cəndamara, a ləvey: “Yesu, ndaw *Nezeret, a bəzla Way aləkwa mekey kwakwas ŋga Gazlavay la, a mbəɗdata kwakwas masa Mawiz maa sərkadandakwara la mekele.”» ");
INSERT INTO mif_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ndəhay tabiya manjatakaya daa way mesley yawa feteɗe a nəkmara Etiyen ndəzl a, dey aŋga fa weɗey anda dey ŋga maslaŋ ŋga Gazlavay da vaɗ. ");
INSERT INTO mif_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","*Ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay aa cəfɗa Etiyen, a ləvar: «Mey masa ata ma kadamara keɗe na, fara fara daw?» ");
INSERT INTO mif_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyen a mbəɗdara, a ləvey: «Məlma aɗaw hay, ta papay hay, jəkfamaya sləmay. Gazlavay masa manjakaya daa slam ma weɗey na, ta wuzar vaw la a *Abəraham, papaŋ ŋga papa aləkwa, daa masa aŋga daa hwayak ŋga Mezapawtami, ta yiŋgey aa berney ŋga *Haraŋ daa ba araŋ. ");
INSERT INTO mif_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Gazlavay a ləvar: “Bey daa hwayak akah, mbəkdata səkway akah hay, daw aa hwayak masa yah ma da wuzdakawa.” ");
INSERT INTO mif_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Da ray ŋgene, Abəraham a sləkɗey daa hwayak ŋga ndəhay *Kalde, a daw a njey aa berney ŋga Haraŋ. Fa dəɓa ŋga meməcey ŋga papaha, Gazlavay, ta’, a ləvar ŋga yiŋgey da Haraŋ a ŋgadaa hwayak mekele. Maja ŋgene, a sawa aa hwayak ŋga Kana, masa aləkwa *Jəwif hay da hwaɗ a wure keɗe. ");
INSERT INTO mif_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ta’, a njey aa hwayak a, ama daa ŋgene, Gazlavay ta vəldara hwayak a ŋgada Abəraham daa ba araŋ, kwa slam nekəɗey ŋga pey salay daa hwayak a ŋgene ta hətey ŋgada aŋga daa ba araŋ. Daa ŋgene, Abəraham bəzey aŋga daa ba araŋ, ama Gazlavay ta ləvar la, a da vəldara hwayak a ŋgene amba a wey da ray a, asaya amba bəza hay ŋga bəz aŋga hay a wamara fa dəɓa aŋga. ");
INSERT INTO mif_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Gazlavay a ləvar saya: “Bəza hay ŋga bəz akah hay a da njam daa hwayak ŋga ndəhay mekele. Ndəhay a, a da wamata, a da kam beke ŋga ndəhay a, a da sərdamata banay haa mevey temere məfaɗ. ");
INSERT INTO mif_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ama fa dəɓa ha ya da katar sariya a ndəhay ma kadamata beke he, wara bəza hay a, a bamawa daa hwayak a, a vəhmawa, a ragadamaya la daa slam aha keɗe.” ");
INSERT INTO mif_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ta’, Bay Gazlavay a jəwam mey ta Abəraham. *Mejəwey-mey aha na, ara ta fa *mesley mandawal. Anda keɗe, Abəraham a yawa *Izak. Fa dəɓa ha luma pal na, a slara mandawal. Izak a slara ŋga bəzey aŋga, *Jakwap kəne. Jakwap may, a slatara ŋga bəz aŋga hay kuraw a ray a cew kəne. Ma yamatərwa səkway aləkwa hay kuraw a ray a cew keɗe na, ara bəza hay ŋga Jakwap. ");
INSERT INTO mif_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Papaŋ ŋga papa aləkwa hay a, masa bəza hay kuraw a ray a cew ŋga Jakwap heyey, səleŋ a katar da ray *Jawzef, məlma ata. Ta’, a həɗkadamara ŋga key beke daa hwayak ŋga *Ejip. Ama Gazlavay aa ta aŋga, ");
INSERT INTO mif_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","fa jəɗa, a ləhda daa banay aŋga hay tabiya. *Farawaŋ, bay daa hwayak ŋga Ejip, a wulkey maaya da ray Jawzef maja Gazlavay ta vəlar leŋgesl la. Farawaŋ, ta’, a pa Jawzef ŋga ndaw mahura daa hwayak aŋga, ta da way aŋga tabiya. ");
INSERT INTO mif_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Fa dəɓa ha, may ta key la ga daa hwayak ŋga Ejip ta daa hwayak ŋga Kana tabiya. Banay ga da ray ndəhay a daha. Papaŋ ŋga papa aləkwa hay, bəza hay ŋga Jakwap heyey, a hətam cek mezəmey saba. ");
INSERT INTO mif_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ama Jakwap ma cənda cek mezəmey daha da Ejip na, ta’, a slərdata bəz aŋga hay. Ŋgene ara meslərey ŋgeeme. ");
INSERT INTO mif_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A diyam ŋga dey cew na, Jawzef ta’, a wuztar vaw a məlmaha hay. Da ray ŋgene, Farawaŋ, a sərta səkway ŋga Jawzef hay. ");
INSERT INTO mif_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Fa dəɓa ha, Jawzef ta’, a slərey məlmaha hay ŋga ŋgəlmərwa papaha Jakwap ta ndəhay da way aŋga tabiya ŋga samawa, amba a njam bama. Ndəhay a tabiya ata kwakwar maasala a ray a zlam. ");
INSERT INTO mif_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ta’, Jakwap a daw a njey a Ejip. A məcwa feteɗe. Bəz aŋga hay may, masa papaŋ ŋga papa aləkwa hay tabiya, a məcam feteɗe. ");
INSERT INTO mif_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Fa dəɓa ha, a handamata vagay ata hay aa hwayak ŋga Sikem, amba a pəshamatərwa feteɗe aa cəvay ŋga Abəraham. Cəvay a na, ara cəvay masa Abəraham ma həɗka fa bəza hay ŋga Hamawr da Sikem e zleezle, a vəltar dala anda ata ma wuɗam. ");
INSERT INTO mif_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Pas masa Gazlavay ma da ka cek anda aŋga ma ləvar a Abəraham zleezle na, gweegwe cay. Anda keɗe, ndəhay *Israyel hay masa daa beke daa hwayak ŋga Ejip heyey fa yam a dey a, a dey a. Ata ga feteɗe. ");
INSERT INTO mif_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ta’, a pam bay mekele da Ejip, bay a, a səra Jawzef ba. ");
INSERT INTO mif_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Bay a ŋgene, ta key wewer sem da ray səkway aləkwa hay Israyel hay, a sərdata banay ta papaŋ ŋga papa aləkwa hay heyey. A təktar ɗay a ndəhay Israyel hay a, ŋga kəzlamata bəz ata hay gevew saw, amba a məcam. ");
INSERT INTO mif_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«Daa ɗar a ŋgene, a yamərwa *Mawiz, aŋga bəzey membey, ma mbafar a Gazlavay. A gəley da way papaha kiya maakar. ");
INSERT INTO mif_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Fa dəɓa ha, a badamərwa, a kəzlamara, ama dam ŋga Bay Farawaŋ leŋ! a la. Ta’, a gəla anda bəzey da hwaɗ aŋga. ");
INSERT INTO mif_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Da ray ŋgene, Mawiz aa sərkey cek hay tabiya masa ndəhay da Ejip ma sərmara. Mawiz a tərey ndaw masa ta gədaŋ, ta fa mey masa aa ma wuzda, asaya ta fa sləra masa aa ma ka. ");
INSERT INTO mif_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Masa Mawiz ma key mevey kwakwar məfaɗ cay na, a jəwey vaw ŋga daw ŋga nəktərwa məlmaha hay Israyel hay. ");
INSERT INTO mif_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Masa aŋga ma wusey la na, a hətar ndaw Ejip fa kəɗa ndaw ata. Ta’, a daw a jəna ndaw ata ha, a kəɗey vaw aa slam a ŋga aŋga, a kəɗa ndaw Ejip kaa heyey vagay. ");
INSERT INTO mif_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mawiz a wulkey na, məlmaha hay Israyel hay a sərmara ara ta fa aŋga Gazlavay ma da badatərwa da Ejip, ama ata na, a sərmara ba. ");
INSERT INTO mif_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","«Pepərek e saya, Mawiz a hətfatar Israyel hay cew fa kəɗam vaw. A wuɗey ŋga wunkata amba a njam daa zazay, a ləvtar: “Haya, ndəhay keɗe, akwar na, məlmaŋ hay, ba diya? Kaa ka kəɗam vaw na, kwara?” ");
INSERT INTO mif_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ama ndaw masa ma cakala mey na, a dəkda Mawiz, a ləvar: “Ma paka ŋga bay ŋga kandar sariya na, wa? ");
INSERT INTO mif_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ka wuɗey ka kəɗya vagay anda kah ma kəɗa ndaw Ejip ŋgaa kwana heyey daw?” ");
INSERT INTO mif_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mawiz a cənda ndaw kaa maa guzlar anda keɗe na, mandərzay a kar, ta’, a hway aa hwayak ŋga Madiyaŋ. Manjakaya daa hwayak a na, aŋga ndaw-məlak. A yawa bəza hay mezəle hay cew feteɗe. ");
INSERT INTO mif_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Fa dəɓa ha mevey kwakwar məfaɗ saya, Mawiz aa da wuzlah-ley, gweegwe ta aŋgwa ŋga Sinay. Maslaŋ ŋga Gazlavay a pawa salay da vaɗ, a wuzar vaw daa awaw, da wuzlah gwaslaf. ");
INSERT INTO mif_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mawiz a hətar na, a rəzley. Masa aŋga fa ŋgəchey a cakay a amba a nəka maaya maaya na, a cənda ɗay ŋga Bay Gazlavay maa guzlwa da hwaɗ a, a ləvar: ");
INSERT INTO mif_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yah, Gazlavay masa papaŋ ŋga papakw akwar hay ma ragadamar. Ahaw yah, Gazlavay masa Abəraham, Izak, leŋ Jakwap ma namar ray.” Mawiz a zlurey, aa wesey, a wuɗey ŋga nəka saba. ");
INSERT INTO mif_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bay Gazlavay a ləvar: “Cəkwta tarak da salay la, maja slam masa kah malacakaya da hwaɗ a keɗe na, slam aha ara slam masa Gazlavay aa da hwaɗ a. ");
INSERT INTO mif_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Fara fara, ya fa hətar banay ŋga ndəhay aɗaw hay da Ejip, ya fa cənda matəway ata. Da ray ŋgene, ya pawa salay na, amba ya ləhdata daa beke. Wure keɗe na, daw, ya slərdaka a Ejip.” ");
INSERT INTO mif_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Yaw, Mawiz aha ara ndaw masa zleezle Israyel hay a ma wuɗmara ba, ma ləvmar: “Ma paka ŋga bay ŋga kandar sariya na, wa?” heyey. Ama Mawiz a na, ara ndaw masa Gazlavay ma pa ŋga bay amba a ləhdata Israyel hay daa beke. Gazlavay a pa ŋga bay ŋga ləhdata na, ta fa maslaŋ ma wuzar vaw da wuzlah gwaslaf heyey. ");
INSERT INTO mif_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ara Mawiz ma badatərwa Israyel hay da Ejip ta maazla hay masa aŋga ma kata maja Gazlavay aa ta aŋga. A kata maazla hay a na, daa hwayak ŋga Ejip, da mey Bəlay Magaza, leŋ da wuzlah-ley haa a key mevey kwakwar məfaɗ. ");
INSERT INTO mif_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ara Mawiz a saya ma ləvtar a Israyel hay: “Gazlavay a slərkwar *ndaw ma təla mey la mekele daa səkway akwar anda aŋga ma slərdiwa keɗe may.” ");
INSERT INTO mif_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Daa masa Jəwif hay makustakaya da wuzlah-ley heyey na, ara Mawiz a, ma handa mey ŋgada papaŋ ŋga papa aləkwa hay, mey masa maslaŋ ŋga Gazlavay da vaɗ maa guzlar daa aŋgwa ŋga Sinay. Asaya, ara aŋga ma təɓərwa *mewey ŋga Gazlavay ma vəley heter a ndəhay, amba a wuzdandakwara. ");
INSERT INTO mif_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Ama papaŋ ŋga papa aləkwa hay a, a wuɗam ŋga cənmar mey a Mawiz a ba, a təɓmara mey aŋga ba, a wuɗam ŋga vəham a Ejip e cəŋga. ");
INSERT INTO mif_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Da ray ŋgene, a ləvmar a *Araŋw, “Kandakwar kuley hay ŋga jənndakwar daa mepəkey aləkwa hay. Mawiz ma badandakurwa da Ejip kaa na, ya sərkwa cek ma kar ba.” ");
INSERT INTO mif_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ta’, a vəɗam cek anda bəz-sla, a ragadamar, a tamara anda kuley ata, a kam gwagway ta meesəmey maja cek aha masa ata ma kamara ta har ata. ");
INSERT INTO mif_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ama Gazlavay pəla! a mbəɗfatar dəɓa, a mbəkdata ŋga ragadam a wurzla hay da vaɗ anda mawuzlalakaya daa ɗerewel ŋga ndəhay ma təla mey ŋga Gazlavay zleezle. Daa ɗerewel e, Gazlavay a ləvey: “Akwar ndəhay Israyel hay, daa masa akwar ma njam mevey kwakwar məfaɗ da wuzlah-ley na, akwar ta hərmaya gənaw hay la daw? Akwar ta vəlmaya cek hay la daw? ");
INSERT INTO mif_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Daa ba səlak! Ama ka tam na, kuley hay mekele mekele. Akwar ta lamara kuley mezəley Malakw la ta way a, a har. Asaya, akwar ta lamara kuley maləmkaya anda wurzla mezəley Refan la. Maja akwar ma ləmamata kuley hay a keɗe, ka ragadamatar na, ya handakwar la kəleŋ ma fəna hwayak ŋga Babilaŋw saya.”» ");
INSERT INTO mif_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Etiyen a ləvtar saya: «Papaŋ ŋga papa aləkwa hay ta kərcam way la zleezle da wuzlah-ley ŋga pey *akwatay ŋga mejəwey-mey ŋga Gazlavay a hwaɗ a, a pəkam ta aŋga. Ara Gazlavay ma wuzdara a Mawiz, a da kərca way aha na, kwara. Fa dəɓa ha, Mawiz ta kərca la anda Gazlavay ma wuzdara ha. ");
INSERT INTO mif_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Papaŋ ŋga papa aləkwa hay ta pəkam la ta Way-mekərcey aha, haa kasl Jesəwe ma key bay-ray ata. Ta pas masa Jesəwe ma key bay-ray ata na, Gazlavay a ɓəlta ndəhay masa Jəwif hay ba daa hwayak keɗe fa mey fa mey, amba Jəwif hay a wamara hwayak a. Way-mekərcey ŋga Gazlavay ta ambal a na, aa daha haa kasl pas masa *Davit ma zəma bay aŋga. ");
INSERT INTO mif_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davit ta hətey maaya ŋga Gazlavay la, aa cəfɗa Gazlavay ŋga vəlar cəveɗ amba a ləmar way mawiya ŋgada Gazlavay masa Jakwap ma ragadar. ");
INSERT INTO mif_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ama, fa dəɓa ha, ara Bay *Salamaŋw ma ləmra way mawiya ha ŋgada Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Ama Bay Gazlavay da vaɗ a njey daa way masa ndəhay ma ləmamara ta har ata ba. Anda *ndaw ma təla mey ŋga Gazlavay zleezle ma ləvey: ");
INSERT INTO mif_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Bay Gazlavay a ləvey: Slam da vaɗ na, ara slam ŋga bay aɗaw, slam da hwayak may, ara slam-mepey-salay aɗaw. Ka ləmamaya na, way wura? Slam aɗaw meməskey-vaw na, wura? ");
INSERT INTO mif_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ara yah ma kata slam hay tabiya, ba diya?”» ");
INSERT INTO mif_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiyen a ləvtar saya: «Akwar ndəhay ray maŋgərɗakaya hay! Akwar fa wuɗmara Gazlavay ta mevel akwar pal daa ba, ka cənmar mey ba səlak! Mandaw mandaw, ka wuɗam *Mesəfney ŋga Gazlavay a key sləra daa akwar ba. Akwar na, anda papakw akwar hay zleezle. ");
INSERT INTO mif_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","*Ndaw ma təla mey ŋga Gazlavay, masa papaŋ ŋga papakw akwar hay ta sərdamara banay daa ba na, daha daw? Ndəhay ma wuzdamara mey da ray ndaw pal masa maaya ma da sawa na, ara papakw akwar hay a ma kəɗmata vagay, ba diya? Wure keɗe, akwar may, ka taa dəɗfamar mey la a ndaw masa maaya ha keɗe, ka ta kəɗmara sem vagay. ");
INSERT INTO mif_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Akwar na, Gazlavay ta slərdakwara kwakwas aŋga la ta har maslaŋ aŋga hay da vaɗ. Ama akwar ta səpmara kwakwas a daa ba.» ");
INSERT INTO mif_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ndəhay ma ka sariya heyey, mevel a catar a ray Etiyen ara mey ba. A zam har maja mevel ta catar la ga da ray mey masa Etiyen ma kada. ");
INSERT INTO mif_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ama Etiyen, marəhkaya ta *Mesəfney ŋga Gazlavay, a nəkey dey a vaɗ, a hətar meweɗey ŋga Gazlavay, a hətar Yesu malacakaya ta har-zəmay ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ta’, a ləvey: «Ehe, slam da vaɗ mawurkaya, ya fa hətar *Bəz ŋga Ndaw malacakaya ta har-zəmay ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Masa ata ma cəndamara Etiyen ma ləvey anda keɗe la na, a wudam ta gədaŋ, a dəzlmata sləmay ata hay ta har. Ata tabiya a cəmam a ray a, ");
INSERT INTO mif_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","a ɗaɗamara, a badamara la daa berney, aa zakamara ta aŋgwa. Masa ata fa daa zakamara na, a mbəkdamatərwa jəbe ata hay fa ndaw mezəley *Sawl. ");
INSERT INTO mif_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Daa masa ata faa zakamara na, Etiyen e a dərey daŋgay a Gazlavay, a ləvey: «Bay Mahura Yesu, təɓa mesəfney aɗaw.» ");
INSERT INTO mif_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ta’, a regedey, a wudey ta gədaŋ, a ləvey: «Bay Gazlavay, mbəkdatara mebərey ata ha keɗe.» Aŋga ma ləvey anda keɗe la na, pam! a məcey. ");
INSERT INTO mif_vpl VALUES ("AC8_1a","074_8_1a","ACT","8","1a","1a","Meməcey ŋga Etiyen e, a mbafar a Sawl. ");
INSERT INTO mif_vpl VALUES ("AC8_1b","074_8_1b","ACT","8","1b","3","Ta’, ndəhay ma səpa cəveɗ ŋga Gazlavay ta mevel pal a lamara vagay ŋga Etiyen, a pəshamara aa cəvay. A təwam ga maja meməcey aŋga ha. Ta pas a ŋgene, banay mahura a sawa a ray ndəhay ma təɓa mey ŋga Yesu da *Jeruzelem. *Sawl a, a səpey cəveɗ ŋga nəsta ndəhay a. A daw a səpta ndəhay mezəle hay, ta ŋgusay fa way a, fa way a. A kərzata, a handata aa fərsəne. Daa ŋgene, ndəhay ŋga Yesu siya aa kwacam ray pal pal aa slam hay mekele mekele daa hwayak ŋga *Jude leŋ daa hwayak ŋga *Samari. Ndəhay daa *mecəmey-ray ŋga ndəhay ŋga Yesu masa mambəkakaya da Jeruzelem na, si ndəhay meslərey gway. ");
INSERT INTO mif_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ndəhay maa kwacam ray heyey, fa pəkam kwa aa wura aa wura, fa wuzam *Mey-maaya-mawiya. ");
INSERT INTO mif_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ŋga *Fəlep na, ta’, a daw aa berney mahura daa hwayak ŋga *Samari. Masa aŋga ma wusey la feteɗe na, a wuztar mey a ndəhay daa berney a da ray *Kəriste, *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay. ");
INSERT INTO mif_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ndəhay daa berney a, a diyam, a kusam amba a cəndamara mey aŋga, a nəkmara maazla hay masa aŋga ma kata. Maja ŋgene, a jəkam sləmay maaya maaya fa mey masa Fəlep ma kadatara. ");
INSERT INTO mif_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Malula a bey da ray ndəhay ga ta mewudey ta gədaŋ, ndəhay masa maahəlɓatakaya ta jegwer hay a hətmatar salay ata hay aa slam a. ");
INSERT INTO mif_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Da ray ŋgene, ndəhay daa berney a aa səmam ga, ara mey ba. ");
INSERT INTO mif_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Daa berney a ŋgene, ndaw daha mezəley *Simaŋw. Masa Fəlep ta daw aa berney a daa ba araŋ na, Simaŋw fa key maazla hay ga, ama maazla hay a na, a sawa ta fa Gazlavay ba. Ta rəzley ndəhay ga la da Samari ta maazla hay a. A pa ray aŋga ŋga ndaw mahura. ");
INSERT INTO mif_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Maja ŋgene, ndəhay tabiya, bəza hay ta mahura hay daa hwayak a na, a təɓmara mey aŋga. Aa guzlam da ray a, a ləvam: «Aŋga na, ara ndaw ta gədaŋ masa ma zəlmara “gədaŋ mahura ŋga Gazlavay.”» ");
INSERT INTO mif_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ndəhay feteɗe a təɓmara mey ŋga Simaŋw a maaya maaya maja ta njey la ga da wuzlah ata, ta rəzlta la ta maazla hay mekele mekele masa aa ma kata. ");
INSERT INTO mif_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ama ta pas ŋgene, Fəlep a sawa, a wuztar *Mey-maaya-mawiya da ray Yesu Kəriste, ta da ray mewey ŋga Gazlavay da ray ndəhay. Ndəhay masa ma təɓmara mey ŋga Fəlep e, ta hətam *baptem la, kwa zel hay kwa ŋgusay. ");
INSERT INTO mif_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simaŋw, ndaw ma key maazla heyey, ta’, a təɓa mey a may. Fa dəɓa ha, a hətey baptem, ta’ a daw asi Fəlep, a mbəkda saba. A rəzley maja aa ma hətatar maazla hay mahura masa Fəlep ma kata ta gədaŋ ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Fa dəɓa ha, ndəhay meslərey ŋga Yesu da *Jeruzelem a cəndamara na, ndəhay da Samari ma təɓmara mey ŋga Gazlavay la. Ta’, a slərmatar ata *Piyer ta *Jaŋ. ");
INSERT INTO mif_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Masa ata Piyer ta Jaŋ ma wusam la feteɗe na, ta’, a dəram daŋgay a Gazlavay maja ndəhay a. Aa cəfɗamara amba Mesəfney aŋga a sawa a ray ata. ");
INSERT INTO mif_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","A dəram daŋgay a Gazlavay da ray ndəhay a na, maja *Mesəfney ŋga Gazlavay ta sawa kwa a ray ndaw pal dasi ata daa ba araŋ. Cek masa ata ma hətam na, ara baptem ta mezəley ŋga Yesu Bay Mahura gway. ");
INSERT INTO mif_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Da ray ŋgene, ata Piyer ta Jaŋ a pamatar har a ray. Ta’, ndəhay a, a hətam Mesəfney ŋga Gazlavay dəɓa. ");
INSERT INTO mif_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Masa Simaŋw ma hətatar ndəhay ma hətam Mesəfney ŋga Gazlavay maja ndəhay meslərey a ma pamatar har a ray heyey na, ta’, a vəltar dala ŋgada ata Piyer ta Jaŋ heyey, ");
INSERT INTO mif_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","a ləvtar: «Vəlmaya gədaŋ a may, amba da ya ta pey har la a ray kwa waawa na, ndaw a hətey Mesəfney ŋga Gazlavay may.» ");
INSERT INTO mif_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ama Piyer a mbəɗdara, a ləvar: «Anja Gazlavay ŋga zəɗdaka ta dala akah ha cəpa, maja gədaŋ masa Gazlavay ma vəlda a ndəhay aŋga hay na, ka fa wulkey ka gwa ŋga həɗka ta dala. ");
INSERT INTO mif_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wure keɗe mey akah daa sləra ŋga Gazlavay keɗe daa ba, maja mevel akah ta mewulkey akah maaya ba fa mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mbəkda mekey mebərey, cacəfɗey ambahw fa Gazlavay maja mebərey akah. Da Gazlavay a mbəkdakawa mewulkey maaya ba daa mevel akah la kwa. ");
INSERT INTO mif_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ya nəka mevel akah na, matara. Kah ndaw masa səleŋ, kah beke ŋga mebərey.» ");
INSERT INTO mif_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ta’, Simaŋw heyey a mbəɗdatara ŋgada ata Piyer ta Jaŋ heyey, a ləvtar: «Ambahw, akwar ta ray akwar, dərmar daŋgay a Gazlavay maja yah, amba mey masa akwar ma ləvam keɗe na, a hətfaya ba.» ");
INSERT INTO mif_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Masa ata Piyer ta Jaŋ ma kam sede la da ray mey ŋga Bay Mahura Yesu, ma wuzdamatara la a ndəhay da Samari na, ta’, a vəham a Jeruzelem. Ata fa diyam daa cəveɗ na, a wuzam Mey-maaya-mawiya da slala hay mekele mekele daa hwayak ŋga Samari. ");
INSERT INTO mif_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Maslaŋ ŋga Gazlavay a ləvar a *Fəlep: «Sləkɗey, daw ta da wurza taa cəveɗ ma daw da *Jeruzelem ŋgadaa berney ŋga Gaza. Cəveɗ e a daw ta wuzlah ley.» ");
INSERT INTO mif_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Fəlep, ta’, a sləkɗey, a daw. Daa cəveɗ ŋgene, a hətar ndaw Etiyawpi fa daw a way. Aŋga ndaw mahura, *maaŋgwaɗakaya ŋga key madərlam ŋga Kandas, ŋgwas, bay ma wa hwayak ŋga Etiyawpi. Ara aŋga ma kərza dala ŋga Kandas a tabiya. Ndaw Etiyawpi a ta daw la a Jeruzelem, ŋga ragadar a Bay Gazlavay. Fa vəhwa ŋgada way ta seret ŋga pəles. Aŋga fa jeŋgey ɗerewel ŋga *Izay, *ndaw ma təla mey ŋga Gazlavay zleezle. ");
INSERT INTO mif_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","*Mesəfney ŋga Gazlavay a ləvar a Fəlep: «Daw asi ndaw ta seret katay.» ");
INSERT INTO mif_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Fəlep, ta’, a hway, a kərza ndaw aha daa cəveɗ. Masa aŋga ma cənda ndaw a fa jeŋgey daa ɗerewel ŋga Izay, ndaw ma təla mey ŋga Gazlavay na, ta’, Fəlep aa cəfɗa, a ləvar: «Ka fa cənda mey daa ɗerewel masa kah ma jaŋga ŋgene daw?» ");
INSERT INTO mif_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ndaw Etiyawpi heyey a mbəɗdara: «Da ndaw ta kadiwa daa ba na, ya da cənda kwara?» Ta’, a ləvar a Fəlep heyey ŋga təpwa aa seret aŋga ha. Fəlep, ta’, a təpey, a njey a cakay a. ");
INSERT INTO mif_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mey daa ɗerewel ŋga Gazlavay masa aŋga ma jaŋga ha na, mey a, a ləvey: «Aŋga na, anda təɓaŋ ma handamara ŋga hərey, aŋga anda bəz-təɓaŋ ma təway ba kwa masa fa handamara ŋga sley eŋgwec aŋga, ta wura mey aŋga ŋga təway anda ŋgene daa ba may. ");
INSERT INTO mif_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","A pam dey a ray a ba anda cek saw, a kamar sariya ta cəveɗ e ba. Aŋga ta mbəkey bəzey da bəla ŋga zəley sləmay aŋga daa ba, maja ta ndəvdamara heter aŋga da bəla sem.» ");
INSERT INTO mif_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ndaw Etiyawpi heyey a ləvar a Fəlep: «Ambahw, kadiwa cey! Ndaw ma təla mey ŋga Gazlavay kaa na, aa guzley da ray wa? Aa guzley da ray aŋga ray aŋga daw, da ray ndaw mekele daw?» ");
INSERT INTO mif_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ta’, Fəlep a wuzdara mey daa ɗerewel ŋga Gazlavay a. A zla ta fa mey masa ndaw a ma jaŋga keɗe heyey, a wuzar mey da ray *Mey-maaya-mawiya ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Masa ata fa diyam daa cəveɗ, a wusam a mey yam daha. Ta’, ndaw Etiyawpi a, a ləvar: «Ehe, yam keɗe daha. Ma təkya ŋga hətey *baptem na, me?»  ");
INSERT INTO mif_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Fəlep a ləvar: «Da ka ta təɓa mey ŋga Yesu la ta mevel pal na, ka gwa ŋga hətey baptem.» Ndaw Etiyawpi a mbəɗdara, a ləvar: «Ya ta təɓa Yesu *Kəriste la, aŋga Bəzey ŋga Gazlavay.» ");
INSERT INTO mif_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ta’, ndaw Etiyawpi a, a ləvar a ndaw ma kərza ray ŋga pəles ŋga lacada seret. Ata Fəlep ta ndaw Etiyawpi a, a pamawa salay, a mbəzam aa yam. Fəlep ta’, a kar baptem a ndaw aha. ");
INSERT INTO mif_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Masa ata fa bamawa daa yam na, Mesəfney ŋga Gazlavay leŋ! a la Fəlep. Ndaw Etiyawpi a, a hətar saba, ama fa daw ta meesəmey ga. ");
INSERT INTO mif_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Wure ŋgene, Fəlep a nəkey dey na, aŋga daa berney ŋga Azawtus. A daw ta mewuzey Mey-maaya-mawiya da slala hay tabiya daa cəveɗ haa kasl a wusey aa berney ŋga Sezere. ");
INSERT INTO mif_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Daa ɗar hay a ŋgene, *Sawl heyey fa sərdata banay ta ndəhay ma səpa cəveɗ ŋga Bay Mahura Yesu cəŋga. A ləvtar a da kəɗta vagay. Ta’, a daw fa *ndaw mahura da ray ndəhay ma ka kwakwas ŋga Gazlavay da *Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Aa cəfɗa ndaw aha ŋga wuzlalar leeter hay amba a handatara a *bay-ray hay daa way-mewuzey-mey hay ŋga Gazlavay daa berney ŋga Damas. A ka anda keɗe, amba da ta hətey ndəhay, kwa mezəle hay, kwa ŋgusay, masa ma səpa cəveɗ ŋga Yesu feteɗe la na, a kərzatərwa, a handatərwa a Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Aŋga fa daw daa cəveɗ ma daw a Damas a, gweegwe cay a wusey na, wure wure ŋgene, slam a waɗawa pəray! da gazlavay da vaɗ a ray a. ");
INSERT INTO mif_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ta’, a təɗey a hwayak, a cəney ɗay ŋga ndaw ma zəla ta da vaɗ, a ləvar: «Sawl, Sawl, ka sərdaya banay anda keɗe na, maja me?» ");
INSERT INTO mif_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sawl heyey aa cəfɗa, a ləvar: «Bay Mahura, kah na, wa?» Ɗay ŋga ndaw ma zəla heyey a mbəɗdara, a ləvar: «Ara yah, Yesu, ndaw masa kah ma sərda banay. ");
INSERT INTO mif_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ama sləkɗey, daw a Damas ɗagay. Feteɗe, a wuzdamakawa cek masa kah ma da ka la.» ");
INSERT INTO mif_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ndəhay masa ma diyam ta Sawl a, ata malacatakaya kwa ta gwamara ŋga wurey mey daa ba maja mandərzay fa katar kalah. Ata fa cəndamara ɗay ŋga ndaw maa guzley, ama ta hətmar ndaw aha daa ba. ");
INSERT INTO mif_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawl a lecey, a wura dey, ama a gwa ŋga hətar dey saba. Ta’, ndəhay a, a kərzamara fa har, a handamara a Damas. ");
INSERT INTO mif_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ɗar maakar, a hətar dey ba, a zəmey cek ba, kwa a sey yam ba. ");
INSERT INTO mif_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Daa berney ŋga Damas a, ndaw ma səpa cəveɗ ŋga Yesu feteɗe daha mezəley *Ananiyas. Bay Mahura a wuɗey ŋga wuzar cek masa aa ma da ka. Maja ŋgene a zəla, a ləvar: «Ananiyas!» Ananiyas a zlar mey: «Away, Bay Mahura, yah keɗe!» ");
INSERT INTO mif_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bay Mahura a ləvar: «Sləkɗey, daw wure wure keɗe aa Cəveɗ Cər-cer, səpa way ŋga Juda. Feteɗe, cacəfɗa ndaw daha mezəley Sawl, ndaw daa berney ŋga Tars. Aŋga fa dərey daŋgay. ");
INSERT INTO mif_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Daa medərey-daŋgay a, cek a wuzar, a hətar ndaw mezəley Ananiyas, ma daw fa vəɗa ŋga par har a ray, amba dey aŋga a wurey, a hətar dey saya.» ");
INSERT INTO mif_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyas a mbəɗdara, a ləvar: «Bay Mahura, ndəhay ga taa guzlmaya la da ray ndaw aha. A ləvmaya aŋga ta sərdata banay la ga ta ndəhay akah hay da Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aŋga ma sawa feɗe kaa na, ara bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay ma vəlmərwa cəveɗ ŋga kərzey ndəhay tabiya ma təɓa mey akah.» ");
INSERT INTO mif_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ta’, Bay Mahura a ləvar a Ananiyas: «Sləkɗey, daw, maja ya ta wala ndaw aha sem amba a kaya sləra, a wuzdatara mey da ray aɗaw a ndəhay masa *Jəwif hay ba hay, a bay ata hay, leŋ a ndəhay *Israyel hay. ");
INSERT INTO mif_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yah, ta ray aɗaw, ya da wuzdara banay masa aŋga ma da səra ga daa sləra ha maja yah.» ");
INSERT INTO mif_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiyas, ta’, a sləkɗey, a daw. A ndəkwey a way heyey, a hətfar Sawl, ta’, a par har a ray, a ləvar: «Sawl, məlma aɗaw, Bay Mahura Yesu a slərdiwa fa akah. Ara aŋga ma wuzka vaw daa cəveɗ masa ka fa sawa feɗe. A slərdiwa amba ka hətar dey cəŋga, amba Bay Gazlavay a rəhdaka ta Mesəfney aŋga.» ");
INSERT INTO mif_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wure ŋgene, cek hay anda meesəftey ŋga ewet a kəzlmawa daa dey ŋga Sawl a. Dey aŋga wur! a wurey. A sləkɗey, a kamar *baptem. ");
INSERT INTO mif_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Fa dəɓa ha, ta’, a zəmey cek, a hətar gədaŋ aŋga saya. Sawl ta njawa la ɗar nekəɗey ta ndəhay ma təɓa mey ŋga Yesu da Damas. ");
INSERT INTO mif_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Wure wure ŋgene, ta’, a daw aa *way-mewuzey-mey ŋga Gazlavay feteɗe, a wuztar mey a ndəhay, a ləvtar Yesu na, ara Bəzey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ndəhay masa ma cəndamara mey aŋga tabiya a rəzlam, a ləvam: «Ndaw keɗe na, ara ndaw maa zəɗdata ndəhay ŋga Yesu da *Jeruzelem heyey, ba diya? A sawa feɗe kaa na, ŋga kərzata amba a handata fa *bay-ray hay ŋga ndəhay ma ka kwakwas ŋga Gazlavay heyey, ba diya?» ");
INSERT INTO mif_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ama fa ɗar a, fa ɗar a, *Sawl fa wuzey mey maaya maaya ma fəna ma fəna, a ləvey Yesu na, ara *ndaw masa Gazlavay ma wala ŋga ləhdata ndəhay. Anda keɗe, *Jəwif hay daa berney ŋga Damas a, a sərmara a da mbəɗdamara aa mey aŋga kwara saba. ");
INSERT INTO mif_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Fa dəɓa ha ɗar ga, Jəwif hay a slam yawa amba a kəɗmara Sawl a vagay. ");
INSERT INTO mif_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Jəwif hay a fa jəɗmara mey-mbew hay ŋga berney a taa vaɗ, taa pas, amba a kərzamara Sawl a, a kəɗmara vagay. Ama wewer masa ata ma kamara na, Sawl a, ta cənda sem. ");
INSERT INTO mif_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Da ray ŋgene, ta tavaɗ, gula aŋga hay, ta’, a səhwdamara a cakay mahwal ŋga Damas, a pamara aa cakarak, a təldamara ta laza taa maŋgalaw ŋga mahwal a kasl a hwayak a dey laŋgar ŋga berney a. ");
INSERT INTO mif_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Fa dəɓa ha, *Sawl a vəhwa a *Jeruzelem , a səpey cəveɗ ŋga cəmey ta ndəhay ma təɓa mey ŋga Yesu, ama ndəhay ŋga Yesu a, a zluram ta aŋga, a wulkam aŋga ta tərey ndaw ma təɓa mey ŋga Yesu fara fara daa ba. ");
INSERT INTO mif_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ama *Barnabas na, ta’, a ŋgəla, a handa fa ndəhay meslərey ŋga Yesu. A kadatara mey da ray Sawl ma hətar Bay Mahura daa cəveɗ ŋga Damas, ta mey masa Bay Mahura maa guzldara. A wuzdatara mey da ray Sawl a daa masa Sawl fa wuzda mey ŋga Yesu da Damas ta mandərzay daa dey daa ba. ");
INSERT INTO mif_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dəga ta pas ŋgene, Sawl a njam ta ndəhay ŋga Yesu feteɗe. A pəkam ta ata da Jeruzelem. A wuzey mey da ray Bay Mahura Yesu a ndəhay ta mandərzay daa dey daa ba. ");
INSERT INTO mif_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Aa guzltar a *Jəwif hay maa guzlam mey Gərek, a kam yawa ta ata. Ama ata na, a səpam cəveɗ ŋga kəɗmara vagay. ");
INSERT INTO mif_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Məlmaŋ hay daa mey ŋga Yesu a cəndamara Jəwif hay a fa wuɗam ŋga kəɗmara vagay na, a ŋgəlmara aa berney ŋga Sezere da mey-bəlay, ta’, a mbəzdamara aa kwambiwal ŋga daw aa berney ŋga Tars . ");
INSERT INTO mif_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yaw, daa ŋgene, ndəhay daa *mecəmey-ray ŋga ndəhay ŋga Yesu daa hwayak ŋga *Jude, daa hwayak ŋga *Galile, leŋ daa hwayak ŋga *Samari na, manjatakaya ta zazay. Fa ɗar a, fa ɗar a, fa hətam gədaŋ daa metəɓey-mey ŋga Yesu ma fəna ma fəna. Daa menjey ata na, fa namar ray a Gazlavay. *Mesəfney ŋga Gazlavay aa ta ata. Maja ŋgene, mecəmey-ray hay a fa səkmawa a dey a, a dey a. ");
INSERT INTO mif_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","*Piyer fa pəkey kwa aa wura aa wura. Pas laŋgar daha a daw ŋga nəkwa ndəhay ma təɓa mey ŋga Yesu daa berney ŋga Lida. ");
INSERT INTO mif_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Daa berney a ŋgene, ndaw daha mezəley Ene, salay maahəlɓakaya. Aa manakaya mevey daaŋgafaɗ, a gwa a lecey ba. Piyer a hətar ndaw aha na, ");
INSERT INTO mif_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ta’, a ləvar: «Ene, Yesu *Kəriste ta mbəldaka sem. Lecey, paɗa gegədeɗ akah ta har akah.» Wure ŋgene, ndaw aha a lecey. ");
INSERT INTO mif_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ndəhay tabiya daa berney ŋga Lida ha ta ndəhay da Saraŋw, a hətmar ndaw aha, maja ŋgene, ta’, a təɓmara mey ŋga Bay Mahura Yesu. ");
INSERT INTO mif_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Daa berney ŋga Jawpe ŋgwas daha mezəley Tabita. Ara ŋgwas ma təɓa mey ŋga Yesu. A zəlmara ta mey Gərek «Dawurkas,» anda meləvey «meweney.» Aŋga mandaw mandaw fa key sləra maaya, fa jənta masa-viya hay. ");
INSERT INTO mif_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ama vaw, ta’, a car, pam! a məcey. Masa aŋga ma məcey la na, ta’, a pərmara vagay a, a pamara aa way da ray way. ");
INSERT INTO mif_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ndəhay ŋga Yesu da Jawpe a cəndamara na, *Piyer aa da Lida feteɗe. Berney ŋga Lida ha gweegwe ta berney ŋga Jawpe. Ta’, a sləram ndəhay cew fa vəɗa, amba aa cəfɗamərwa, a ləvmar: «Ambahw, nakwa la fa ala fiyaw cey!» ");
INSERT INTO mif_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Masa Piyer ma cənda anda keɗe na, ta’, a diyam ta ndəhay kaa heyey a Jawpe, kwa ta zənam vaw daa ba. A wusam, a ŋgəlmara Piyer, a handamara aa way masa da vaɗ da ray way heyey. Ŋgusay fa yideŋ hay tabiya masa feteɗe, a ŋgəchamawa a cakay Piyer, fa təwam, a wuzdamara zana ata hay masa Tabita ma təftara daa masa aŋga ta dey. ");
INSERT INTO mif_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Fa dəɓa ha Piyer a badatərwa ndəhay tabiya aa ambaw, a regedey, a dərey daŋgay a Gazlavay. Ta’, a mbəɗey dey fa vagay a, a ləvar: «Tabita, sləkɗey.» Tabita a wura dey. Masa aŋga ma hətar Piyer na, ta’, a sləkɗey, a njey. ");
INSERT INTO mif_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyer a kərza fa har, a jəna ŋga lecey. Ta’, a zəltərwa ŋgusay fa yideŋ hay heyey leŋ ndəhay ma təɓa mey ŋga Yesu feteɗe, a wuzdatara Tabita heyey, a hətmar aŋga ta dey. ");
INSERT INTO mif_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mey a, a wusey fa ndəhay daa berney ŋga Jawpe tabiya. Ndəhay ga a təɓmara mey ŋga Bay Mahura. ");
INSERT INTO mif_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyer ta njey la ga daa berney ŋga Jawpe da way ndaw ma kəfɗa ambal, mezəley *Simaŋw. ");
INSERT INTO mif_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ndaw daa berney ŋga Sezere daha mezəley Kwerney. Aŋga mahura ŋga sewje hay temere. Ata da wuzlah sewje hay ŋga Rawma hay mezəley «Sewje hay ma samawa da Itali.» ");
INSERT INTO mif_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ndaw aha fa səpa cəveɗ ŋga Gazlavay ta mevel pal. Aŋga ta ndəhay da way aŋga hay ndav fa namar ray a Gazlavay anda *Jəwif hay. Fa jənta masa-viya hay ga da wuzlah Jəwif hay, fa dərey daŋgay a Gazlavay mandaw mandaw. ");
INSERT INTO mif_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ta pas laŋgar daha, ta pas ŋgaa kwaɗ ɓərey maakar, Gazlavay a wuzar cek a Kwerney a. A hətar *maslaŋ ŋga Gazlavay ma sawa da vaɗ maaya maaya ta dey aŋga, maslaŋ a mbəzey fa vəɗa. Ta’, a zəla: «Kwerney!» ");
INSERT INTO mif_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kwerney a nəka maslaŋ ŋga Gazlavay a, mandərzay a kar, a ləvar: «Bay aɗaw, mekey me?» Maslaŋ ŋga Gazlavay kaa a mbəɗdara, a ləvar: «Gazlavay ta cənda medərey-daŋgay akah la, ta hətka la masa kah fa jənta masa-viya hay. Cek hay a keɗe a mbafar. Da ray ŋgene, aa fa sərfadaka. ");
INSERT INTO mif_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Wure keɗe, slərey ndəhay aa berney ŋga Jawpe ŋga zəlwa ndaw daha mezəley *Simaŋw, masa mehəlmey *Piyer. ");
INSERT INTO mif_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Aŋga da way ndaw daha ma kəfɗa ambal mezəley Simaŋw, way aŋga da mey-bəlay.» ");
INSERT INTO mif_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Masa maslaŋ ŋga Gazlavay maa guzlar heyey ma vəhey la na, Kwerney, ta’, a zəlwa madərlam aŋga hay cew ta sewje pal da wuzlah sewje aŋga hay masa daa sləra aŋga. Sewje he ŋgene, ara ndaw ma səpa cəveɗ ŋga Gazlavay ta mevel pal. ");
INSERT INTO mif_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ta’, a kadatara cek tabiya ma kam. Fa dəɓa ha, ta’, a slərdata aa berney ŋga Jawpe fa Piyer. ");
INSERT INTO mif_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pepərek e, ndəhay masa Kwerney ma slərdata heyey ata daa cəveɗ gweegwe a wusam a Jawpe heyey. Gweegwe ta wuzlah-pas na, Piyer ta’, a təpey aa papalah da ray way ŋga dərey daŋgay a Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Masa aŋga fa dərey daŋgay na, may fa car, a wuɗey ɗaf ŋga zəmey. Daa masa fa tamar ɗaf a na, Gazlavay ta’, a wuzar cek. ");
INSERT INTO mif_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A hətar slam da vaɗ mawurkaya, cek anda gwedeere a pawa salay a hwayak, cakay hay məfaɗ mabaŋgaɗatakaya. ");
INSERT INTO mif_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Daa gwedeere he, cek hay ŋga ley mekele mekele da hwaɗ a, cek hay masa salay məfaɗ, cek hay ma diyam ta hwaɗ ta hwaɗ, leŋ ɗiyaŋ hay. ");
INSERT INTO mif_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ɗay a cənwa da vaɗ, a ləvey: «Piyer, lecey, sley ɗay ŋga cek hay a keɗe, zəmey!» ");
INSERT INTO mif_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ama Piyer a mbəɗdara, a ləvar: «’A’a, Bay Mahura, ŋga menjey aɗaw, cek masa kwakwas ala ma təka sem na, ya ta zəmey daa ba araŋ.» ");
INSERT INTO mif_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ɗay heyey, ta’, a cənwa saya, a ləvar: «Cek masa Gazlavay ma ləvey maaya ŋga zəmey na, ka da pada ŋga cek maaya ba na, kəne ba.» ");
INSERT INTO mif_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ɗay a, a cənwa dey maakar, fa dəɓa ha, cek aha ta’, a vəhey aa slam a, a vaɗ. ");
INSERT INTO mif_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyer fa wulkada cek masa Gazlavay ma wuzdara, a wuɗey ŋga ləvar na, me. Daa ŋgene, ndəhay masa Kwerney ma slərdata heyey faa cəfɗam ndəhay, a ləvam: «Way ŋga Simaŋw na, dama?» Ta’, a diyam, a lacam daa ambaw ɗagay. ");
INSERT INTO mif_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","A zəlam, a ləvam: «Ndaw mezəley Simaŋw, masa mehəlmey Piyer daha na, aŋga feɗe daw?» ");
INSERT INTO mif_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyer a lawa daa slam medərey-daŋgay heyey, fa wulkey da ray cek masa Gazlavay ma wuzdara. Ta’, *Mesəfney ŋga Gazlavay a ləvar: «Ehe, ndəhay daha maakar fa səpmaka. ");
INSERT INTO mif_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sləkɗey, bərŋgey fa ata amba ka diyam bama. Ka da zlurey ba, maja ara Yah ma slərdatərwa.» ");
INSERT INTO mif_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyer, ta’, a bərŋgawa fa ndəhay a, a ləvtar: «Ara yah, ndaw masa akwar ma səpmara. Ka samawa na, kwara?» ");
INSERT INTO mif_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ndəhay a, a mbəɗdamara, a ləvmar: «Ya samawa na, Kwerney, mahura ŋga sewje hay, ma slərdandərwa. Aŋga na, ndaw maaya fa Gazlavay, kwa aŋga ndaw Jəwif ba, aŋga fa səpa mey ŋga Gazlavay anda Jəwif hay. Jəwif hay tabiya faa həmdamara. Ndaw a na, maslaŋ ŋga Gazlavay da vaɗ ta sawa la fa vəɗa, a ləvar ŋga sawa ŋga ŋgəlka a way aŋga, amba a jəkey sləmay fa mey masa kah ma da kadara.» ");
INSERT INTO mif_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piyer, ta’, a ŋgəlta ŋgada way, a vəltar slam ŋga ney dasi tavaɗ a ŋgene. Pepərek e, a sləkɗam, a diyam ta ata Piyer heyey. Məlmaha hay siya daa mecəmey-ray ŋga ndəhay ŋga Yesu da Jawpe a ləgdamata. ");
INSERT INTO mif_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pepərek e saya, a wusam aa berney ŋga Sezere. Daa ŋgene, Kwerney ta zəltərwa səkway aŋga hay, ta jam aŋga hay masa fara fara la, ata makustakaya, fa səkwmata. ");
INSERT INTO mif_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","*Piyer a wusey a way Kwerney. Masa aŋga fa mbəzey a way a na, Kwerney, ta’, a car har, a regedey fa mey aŋga. ");
INSERT INTO mif_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ama Piyer, ta’, a sləkɗada, a ləvar: «Lecey, yah na, ndaw anda akah.» ");
INSERT INTO mif_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piyer faa guzlam ta Kwerney haa kasl ata ma wusam a palah-way. Feteɗe Piyer a hətfey ndəhay ga makustakaya da way Kwerney a. ");
INSERT INTO mif_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","A ləvtar: «Akwar, ka sərmara kwakwas ŋga *Jəwif hay ta təka ndaw Jəwif sem ŋga ndəkwey a way ndəhay masa Jəwif hay ba hay, asaya, ta təka sem kwa ŋga pəkey ta ata. Ama, Gazlavay ta wuzdiwa la, ya da nəka kwa waawa aa mazləɓkaya, a da kaya hezey na, kəne ba. ");
INSERT INTO mif_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Da ray ŋgene, masa kah ma zəlyawa na, ya ta zlurey ŋga sawa daa ba. Ya wuɗey ya səra ka zəlyawa na, kwara?» ");
INSERT INTO mif_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kwerney a mbəɗdara, a ləvar: «Aŋga kaa ɗar maakar, ta ɓərey maakar ŋgaa kwaɗ anda keɗe, ya fa dərey daŋgay da way aɗaw. Daa ŋgene, ndaw daha a sawa a cakay aɗaw ta zana fa vaw ma weɗey ndəɗ-ndeɗ, ");
INSERT INTO mif_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","a ləvya: “Kwerney, Gazlavay ta cənda medərey-daŋgay akah la. Fa sərfada masa kah ma jənta masa-viya hay heyey. ");
INSERT INTO mif_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Anda keɗe, slərey ndəhay aa berney ŋga Jawpe ŋga zəlwa ndaw mezəley *Simaŋw masa mehəlmey Piyer. Aŋga da way ndaw mezəley Simaŋw ma kəfɗa ambal, way aŋga da mey-bəlay.” ");
INSERT INTO mif_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Wure ŋgene, ta’, ya slərey ndəhay fa kah ŋga ŋgəlmakawa keɗe. Suse, maja kah ma sawa. Wure keɗe na, ala tabiya makustakaya fa mey ŋga Gazlavay ŋga jəkey sləmay fa mey masa Bay Mahura ma vəldakawa ŋga wuzdandara.» ");
INSERT INTO mif_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ta’, *Piyer a zlar mewuzey mey, a ləvey: «Wure keɗe ya səra fara fara Gazlavay a weley ndəhay ta weley ba. ");
INSERT INTO mif_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Anda meləvey, ndaw ma nar ray a Gazlavay, ma key cek ta cəveɗ e na, kwa aŋga daa səkway wura wura, Gazlavay a təɓa la. ");
INSERT INTO mif_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gazlavay ta slərdərwa mey aŋga la a ndəhay *Israyel hay. Mey a na, ara *Mey-maaya-mawiya ma njadandakwar daa zazay ta fa Yesu *Kəriste, Bay Mahura ŋga ndəhay tabiya. ");
INSERT INTO mif_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ka sərmara cek ma key daa hwayak ŋga *Galile haa aa hwayak ŋga *Jude fa dəɓa ha masa *Jaŋ-Baptis ma wuzey mey ta aa ma katar *baptem a ndəhay heyey, ba diya? ");
INSERT INTO mif_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ka sərmara na, Gazlavay ta wala Yesu, ndaw *Nezeret la, a vəlar Mesəfney aŋga ta gədaŋ aŋga. Yesu a, a pəkta hwayak hay mekele mekele, a katar maaya a ndəhay, a pəskatərwa ndəhay tabiya masa dasi har ŋga bay-malula, a mbəldata. A kata sləra hay a anda keɗe na, maja Gazlavay aa ta aŋga. ");
INSERT INTO mif_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Ala na, ndəhay masa ma hətmar la ta dey ala, ya kam sede da ray cek hay masa aŋga ma kata tabiya da *Jeruzelem ta daa hwayak hay mekele mekele ŋga *Jəwif hay. Ta dərmara la fa hwadam mazlaŋgalakaya, a kəɗmara vagay. ");
INSERT INTO mif_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ama ŋga ɗar maakar a, Gazlavay ta sləkɗadərwa sem daa meməcey. Ta’, a vəlar cəveɗ ŋga wuzwa vaw a ndəhay. ");
INSERT INTO mif_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A wuzwa vaw a na, ŋgada ndəhay tabiya ba, ama ŋgada ala, ndəhay masa aa ma walata ŋgeeme ŋga key sede da ray a. Ala na, ta zəmam cek la, ta sam cek la bama ta Yesu a fa dəɓa ha masa Gazlavay ma sləkɗadərwa cay daa meməcey. ");
INSERT INTO mif_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Gazlavay a ləvndar ya wuzdamatara mey aŋga a ndəhay, ya kam sede da ray a, ya ləvam, Yesu ara ndaw masa Gazlavay ma pa ŋga key sariya a ndəhay masa ta dey ta a ndəhay maməctakaya. ");
INSERT INTO mif_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ndəhay ma təla mey ŋga Gazlavay tabiya taa guzlam la da ray Yesu a, a ləvam kwa waawa ma pa Yesu ŋga ndaw aŋga fara fara na, Gazlavay a mbəkdara mebərey aŋga la ta fa gədaŋ ŋga mezəley aŋga.» ");
INSERT INTO mif_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Daa masa *Piyer faa guzley ɗagay, *Mesəfney ŋga Gazlavay a pawa salay a ray ndəhay tabiya ma jəkam sləmay fa mey aŋga. ");
INSERT INTO mif_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ndəhay *Jəwif hay ma təɓa mey ŋga Yesu ma samawa ta ata Piyer feteɗe heyey a rəzlam ga, maja Gazlavay ta vəltar Mesəfney aŋga la a ray ndəhay masa Jəwif hay ba hay may. ");
INSERT INTO mif_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ndəhay Jəwif hay a, a cəndamara ndəhay a faa guzlam ta mey hay mekele mekele masa ata ma sərmara ba, fa həslmar ray a Gazlavay. Ta’, Piyer a ləvey: ");
INSERT INTO mif_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Wure keɗe ndəhay kaa ta hətam Mesəfney ŋga Gazlavay cay anda aləkwa may. Kaa ya gwakwa ŋga təktakwa ŋga hətey *baptem ta yam daw?» ");
INSERT INTO mif_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Da ray ŋgene, a ləvtar ŋga kamatar baptem ta mezəley ŋga Yesu *Kəriste. Ta’, aa cəfɗamara Piyer ŋga njey ta ata ɗar nekəɗey. ");
INSERT INTO mif_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ndəhay meslərey ŋga Yesu ta məlmaŋ hay daa mey ŋga Yesu masa daa hwayak ŋga *Jude, a cəndamara na, ndəhay masa *Jəwif hay ba ta təɓmara mey ŋga Gazlavay la may. ");
INSERT INTO mif_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ta pas masa *Piyer ma vəhwa a *Jeruzelem na, Jəwif hay ma təɓa mey ŋga Yesu a slam mey a ray a, ");
INSERT INTO mif_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","a ləvmar: «Ka mbəzey a way ndəhay masa Jəwif hay ba hay, masa mandawal manjar ŋga sley, ka zəmam cek bama daa slam a na, kwara!» ");
INSERT INTO mif_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ta’, Piyer a wuzdatara cek hay ma kam dəga ŋga mezley. A kadatara pal pal, a ləvtar: ");
INSERT INTO mif_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Yah daa berney ŋga Jawpe, ya fa dərey daŋgay a Gazlavay, daa ŋgene, ta’, Gazlavay a wuzya cek. Ya hətar cek daha, a pawa salay da gazlavay da vaɗ a cakay aɗaw, cek aha anda gwedeere, cakay hay məfaɗ mabaŋgaɗatakaya. ");
INSERT INTO mif_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ya nəkey dey maaya maaya a hwaɗ a na, ya hətey cek hay ta salay məfaɗ məfaɗ, cek hay ŋga ley hay, cek hay ma diyam ta hwaɗ ta hwaɗ, leŋ ɗiyaŋ hay. ");
INSERT INTO mif_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ya cənda ɗay ma ləvya: “Piyer, lecey, sley ɗay ŋga cek hay a keɗe, zəmey!” ");
INSERT INTO mif_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ama ya mbəɗdara, ya ləvar: “’A’a, Bay Gazlavay, ŋga menjey aɗaw, cek masa kwakwas ala ma təka sem na, ya ta zəmey daa ba araŋ.” ");
INSERT INTO mif_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ɗay heyey, ta’, aa guzlya saya, a ləvey: “Cek masa Gazlavay ma ləvey maaya ŋga zəmey na, ka da pada ŋga cek maaya ba na, kəne ba.” ");
INSERT INTO mif_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","«Cek a keɗe a key dey maakar, fa dəɓa ha cek aha tabiya, ta’, a vəhey aa slam a, a vaɗ. ");
INSERT INTO mif_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Wure wure ŋgene, ndəhay maakar a wusmawa a way ndaw masa ala da hwaɗ a. Ara ndaw daa berney ŋga Sezere daha ma slərdatərwa fa yah. ");
INSERT INTO mif_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","*Mesəfney ŋga Gazlavay a ləvya: “Daw ta ata, ka da zlurey ba.” Ta’, ya diyam bama aa hwayak ŋga Sezere. Məlma aɗaw hay maakwaw daa mey ŋga Yesu da Jawpe masa da cakay aɗaw feɗe, ta’, ya diyam bama. Ya wusam, ala tabiya ya mbəzam a way ndaw aha. ");
INSERT INTO mif_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ndaw a, a kadandara cek masa aŋga ma hətar da way aŋga. A ləvndar *maslaŋ ŋga Bay Gazlavay da vaɗ, ta wuzar vaw la, a lecey fa mey aŋga, a ləvar: “Slərey ndəhay aa berney ŋga Jawpe ŋga ŋgəlwa ndaw mezəley *Simaŋw, masa mehəlmey Piyer. ");
INSERT INTO mif_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Aŋga na, a wuzdakawa cəveɗ ma da ləhdakwar ta ndəhay da way akah la.” ");
INSERT INTO mif_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Masa ya fa zlar ŋgaa guzltar na, Mesəfney ŋga Gazlavay a pawa salay a ray ata cəpa anda aŋga ma pawa salay a ray ala ŋgeeme. ");
INSERT INTO mif_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Daa ŋgene, ya sərfada mey ŋga Bay Mahura zleezle, ma ləvey: “*Jaŋ a katar *baptem a ndəhay na, ta yam, ama akwar, ka hətam baptem la ta Mesəfney ŋga Gazlavay.” ");
INSERT INTO mif_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Gazlavay a vəltar Mesəfney aŋga, anda aŋga ma vəldandara Mesəfney a daa masa ala ma təɓmara mey ŋga Bay Mahura Yesu *Kəriste. Anda keɗe, yah na wa, ŋga təka Gazlavay ŋga key cek masa aa ma wuɗey na!» ");
INSERT INTO mif_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Masa ata ma cəndamara mey keɗe la na, a mbəkdamara meyey-mey. Ta’, a həlmamara Gazlavay, a ləvam: «Kwa ŋgada ndəhay masa Jəwif hay ba hay na, fara fara Gazlavay ta wurtar cəveɗ cay amba a mbəɗdamara menjey ata, a səpmara Gazlavay ta mevel pal. Maja ŋgene, ata may, a hətam heter mendəvey ba la.» ");
INSERT INTO mif_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ta pas masa ata ma kəɗmara Etiyen heyey vagay na, fa dəɓa ha, a zlamar ŋga sərdamata banay ta ndəhay ma təɓa mey ŋga Yesu. Ndəhay ŋga Yesu a, aa kwacam ray pal pal. Siya ŋga ndəhay a, a diyam kasl aa hwayak ŋga Fenisi, aa hwayak ŋga Sipəre, ta aa berney ŋga Antiyaws. A wuzam mey ŋga Gazlavay na, si a ndəhay *Jəwif hay gway. ");
INSERT INTO mif_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ama ndəhay siya da wuzlah ndəhay maa kwacam ray heyey masa ndəhay Sipəre hay ta ndəhay Siren hay na, ta wusam la a Antiyaws. Feteɗe, ta wuzmatar *Mey-maaya-mawiya la da ray Bay Mahura Yesu *Kəriste, a ndəhay masa Jəwif hay ba hay may. ");
INSERT INTO mif_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gədaŋ ŋga Bay Mahura aa ta ata. Maja ŋgene, ndəhay ga a təɓmara mey aŋga, a səpmara cəveɗ aŋga. ");
INSERT INTO mif_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ndəhay daa *mecəmey-ray ŋga ndəhay ŋga Yesu da *Jeruzelem a cəndamara mey aha. Da ray ŋgene, a sləram *Barnabas a Antiyaws. ");
INSERT INTO mif_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Barnabas a na, aŋga ndaw maaya, marəhkaya ta *Mesəfney ŋga Gazlavay, fa pa Yesu ŋga ndaw aŋga fara fara. Masa aŋga ma wusey la a Antiyaws a na, a hətar sləra masa Gazlavay ma ka da wuzlah ndəhay a ta fa maaya aŋga. Barnabas aa səmey ga maja maaya ŋga Gazlavay a. Ta’, a vəltar gədaŋ a ndəhay tabiya. A ləvtar: «Namar ray a Bay Mahura mandaw mandaw ta mevel akwar cəpa, ka da mbəkdamara ba.» Maja ŋgene, ndəhay ga a təɓmara mey ŋga Bay Mahura. ");
INSERT INTO mif_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Fa dəɓa ha Barnabas, ta’, a daw aa berney ŋga Tars, a səpərwa *Sawl. ");
INSERT INTO mif_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Masa aŋga ma hətar la na, a ŋgələrwa aa berney ŋga Antiyaws. Ta’, a njam cew e mevey pal daa mecəmey-ray ŋga ndəhay ŋga Yesu da Antiyaws a. Ata faa sərkadam ndəhay ga feteɗe. Ara daa berney a ŋgene, ata ma zlamar ŋga zəlmata ndəhay ŋga Yesu «Kəretiyeŋ hay.» ");
INSERT INTO mif_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Daa ŋgene, ndəhay ma təla mey ŋga Gazlavay siya a sləkɗam da Jeruzelem, a diyam a Antiyaws. ");
INSERT INTO mif_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ndaw pal dasi ata daha mezəley Agabus. A lecey, a wuzda mey masa Mesəfney ŋga Gazlavay ma wuzdara, a ləvey: «May mahura a key la fa bəla ndav.» Fara fara may a na, ta key la daa masa Kəlawt aa daa bay. ");
INSERT INTO mif_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Masa aŋga ma ləvtar anda keɗe la na, ndəhay ŋga Yesu feteɗe a cəmdamara ɗay ata. A wulkam maaya na, kwa waawa a slərwa cek təɗe ta gədaŋ aŋga, ŋga jəney məlmaŋ hay daa mecəmey-ray ŋga ndəhay ŋga Yesu daa hwayak ŋga *Jude. ");
INSERT INTO mif_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ta’, a kamara kəne. Cek hay macakalakaya ha na, a slərdamara ta har ata Barnabas ta Sawl ŋga vəley a *bay-ray hay daa mecəmey-ray ŋga ndəhay ŋga Yesu da Jude. ");
INSERT INTO mif_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Daa ŋgene, Bay *Herawt a zlar ma sərdata banay ta ndəhay mekele mekele daa *mecəmey-ray ŋga ndəhay ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A kəɗa *Jak ta dəlaw vagay. Jak a na, ara məlmaŋ ŋga *Jaŋ. ");
INSERT INTO mif_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bay Herawt a nəka na, *Jəwif hay faa səmam maja aŋga ma kəɗa Jak vagay. Ta’, a kərza *Piyer saya, a kəzla aa fərsəne. A kərza Piyer na, daa ɗar hay ŋga gwagway mezəley «*Gwagway ŋga peŋ manjar cek ma həsla da hwaɗ a.» ");
INSERT INTO mif_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ta’, a ləvtar a sewje hay ŋga jəɗmara. Sewje hay a, ata məfaɗ, məfaɗ dey məfaɗ a. Bay Herawt a, a wuɗey ŋga kar sariya a Piyer meedey ndəhay tabiya fa dəɓa ŋga gwagway ŋga *Pak. ");
INSERT INTO mif_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Anda keɗe, Piyer magərcakaya daa fərsəne, ama ndəhay daa mecəmey-ray ŋga ndəhay ŋga Yesu heyey fa dəram daŋgay a Gazlavay mandaw mandaw ta mevel pal maja aŋga. ");
INSERT INTO mif_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Slam ma da wurwa amba Bay *Herawt a kar sariya a *Piyer na, ta tavaɗ a ŋgene, Piyer majəwkaya ta calalaw hay cew manakaya da wuzlah sewje hay cew ma jəɗmara heyey. Sewje hay mekele fa jəɗmara mey-slam ŋga fərsəne he saya. ");
INSERT INTO mif_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ta’, *maslaŋ ŋga Bay Gazlavay da vaɗ a sawa, slam daa way a, a weɗey pəray! Maslaŋ a, a wusa Piyer aa cakay, a sləkɗada, a ləvar: «Sləkɗey fiyaw!» Masa maslaŋ a faa guzlar na, calalaw hay heyey a kwiyam da har Piyer. ");
INSERT INTO mif_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Maslaŋ a, a ləvar: «Ɗiya vaw akah, pata tarak akah hay a salay.» Piyer, ta’, a ka anda maslaŋ a ma ləvar. Maslaŋ a ləvar saya: «Sləlha zana akah fa vaw, səpya.» ");
INSERT INTO mif_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyer aa da siya, a bamawa daa fərsəne kasl ambaw. Ama Piyer ta səra cek masa maslaŋ a ma kara ŋgene ara cek fara fara na, daa ba. A wulkey ara mesəfney ma kar. ");
INSERT INTO mif_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Masa ata fa diyam na, a mbəkdamatərwa sewje hay ŋgeeme, a mbəkdamatərwa sewje hay ŋga dey cew e, a wusam fa mey-mbew ŋga ɓərey ŋga fərsəne masa ma bawa ŋgadaa berney. Mey-mbew e a wurey taava aŋga. Ta’, a bamawa daa fərsəne he. A diyam taa cəveɗ ma daw taa berney a. Fa dəɓa ha nekəɗey na, maslaŋ ŋga Gazlavay a sem, a daw, a mbəkda Piyer feteɗe. ");
INSERT INTO mif_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Daa slam aha ŋgene, Piyer, a səra cek masa ma key ta aŋga na, ara cek fara fara. A ləvey: «Wure keɗe, ya səra fara fara ara Bay Gazlavay ma slərwa maslaŋ aŋga, ŋga ləhdaya dasi har ŋga Herawt, asaya, daa cek maaya ba tabiya masa ndəhay *Jəwif hay ma wuɗam ŋga kamaya.» ");
INSERT INTO mif_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Masa Piyer ma səra cek aha ma key anda keɗe la na, ta’, a daw a way *Mari, mamaŋ ŋga Jaŋ-Mark. Ndəhay ga makustakaya feteɗe, fa dəram daŋgay a Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piyer a zəley fa mey-mbew, a kəɗa kweteŋ . Dam ma key sləra da wuzlah ata feteɗe daha mezəley Rawde. Ta’, a sawa ŋga nəka ma kəɗa kweteŋ e na, ara wa. ");
INSERT INTO mif_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","A wusey fa mey-mbew. Masa aa ma cənda ara ɗay ŋga Piyer na, aa səmey ga ara mey ba. Kwa ŋga wura mey-mbew e na, ta wura daa ba, ama a hway ta ray ŋgada way fa ndəhay da way a heyey, a ləvtar: «Piyer malacakaya fa mey-mbew.» ");
INSERT INTO mif_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ndəhay kaa a mbəɗdamara ŋgada dam aha, a ləvmar: «Malula fa kaka daw?» Ama aŋga fa ləvtar, fa ləvtar: «Fara fara ara aŋga.» Ndəhay a, a ləvam: «Da ara maslaŋ aŋga kwa .» ");
INSERT INTO mif_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ama Piyer, fa zəley, fa kəɗa kweteŋ ŋga mey-mbew cəŋga, kwa ta mbəkda daa ba. Ta’, a wurmara mey-mbew heyey. Masa ata ma hətmar ara aŋga na, a rəzlam ga. ");
INSERT INTO mif_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Piyer heyey, ta’, a baŋgaɗatar har ŋga njam teete, ta’, a kadatara mey da ray cek masa Bay Gazlavay ma ka ŋga badərwa daa fərsəne. A ləvtar: «Kadamara mey keɗe ŋgada *Jak ta ŋgada məlmaŋ hay mekele daa *mecəmey-ray ŋga ndəhay ŋga Yesu.» Ta’, a mbəkdata, a daw aa slam mekele. ");
INSERT INTO mif_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cay, slam ta’, a wurey, sewje hay heyey a wuram mey həɓak a həɓak a, a sərmara ŋga key kwara ba. A ləvam: «Piyer a key na, kwara?» ");
INSERT INTO mif_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Bay Herawt heyey, ta’, a slərey ndəhay aa wura aa wura ŋga səpmərwa Piyer e, ama ta hətmərwa daa ba. Da ray ŋgene, Bay Herawt aa cəfɗata sewje hay ma jəɗmara Piyer heyey, ta’, a ləvtar a ndəhay mekele ŋga kəɗmata vagay. Fa dəɓa ha, ta’, Bay Herawt a, a sləkɗey daa hwayak ŋga *Jude, a daw aa berney ŋga Sezere, a njawa feteɗe ɗar nekəɗey. ");
INSERT INTO mif_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Daa ŋgene, Bay *Herawt mevel aŋga fa cey a ray ndəhay daa berney ŋga Tir ta ndəhay daa berney ŋga Sidaŋw. Ndəhay daa berney hay a, a həɗkam cek mezəmey na, daa hwayak ŋga Bay Herawt a. Da ray ŋgene, a cəmdamara ɗay ata, a səpam cəveɗ ŋga daw fa vəɗa. Maja ŋgene, a vəlam dala a Bəlastus, madərlam mahura ŋga Bay Herawt amba a hətam cəveɗ ŋga wusey fa Herawt ŋga kar ambahw. ");
INSERT INTO mif_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Masa pas ŋga key ambahw a Bay Herawt a heyey ma wuswa cay na, Herawt a pawa zana ŋga bay fa vaw, a daw, a njey aa jaŋga aŋga fa mey ŋga ndəhay a, a zlar meeguzley. ");
INSERT INTO mif_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Aa faa guzley na, ndəhay tabiya feteɗe a wudam, a ləvam: «Maa guzley kaa na, ara Gazlavay, ba na, ndaw ba.» ");
INSERT INTO mif_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wure wure ŋgene, maslaŋ ŋga Gazlavay da vaɗ a kəɗa Herawt a, maja aŋga ma təɓa ndəhay a ma həslmar ray, a pa ray aŋga ŋga Gazlavay. Ta’, mətal hay a zəmamara, fa dəɓa ha, a məcey. ");
INSERT INTO mif_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Yaw, mey ŋga Gazlavay na, fa daw fa mey, fa mey. Ndəhay masa ma təɓa mey ŋga Gazlavay a, fa səkmawa, a dey a, a dey a. ");
INSERT INTO mif_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Fa dəɓa ha ata *Barnabas ta *Sawl ma ndəvdamara sləra ata da *Jeruzelem la na, a vəham aa berney ŋga Antiyaws. A diyam bama ta ata Jaŋ-Mark. ");
INSERT INTO mif_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Daa *mecəmey-ray ŋga ndəhay ŋga Yesu daa berney ŋga Antiyaws masa da Siri na, ndəhay ma təla mey ŋga Gazlavay daha, asaya, ndəhay maa sərkadam mey ŋga Gazlavay daha. Ndəhay a na, ara ata *Barnabas, Simeyaŋw masa ma pamar sləmay-wazlay «Matara», Lusiyus, ndaw Siren, Manayaŋ masa ma gəlam ta Bay *Herawt daa slam a, leŋ *Sawl. ");
INSERT INTO mif_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ta pas laŋgar daha, ata fa dəram daŋgay a Gazlavay, fa kam *daliyam. Ta’, *Mesəfney ŋga Gazlavay a ləvtar: «Pamatiwa ata Barnabas ta Sawl wal ŋga key sləra masa yah ma zəlta maja.» ");
INSERT INTO mif_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Anda keɗe, fa dəɓa ha masa ata ma ndəvdamara mekey daliyam ta medərey-daŋgay cay na, a pamatar har a ray ata Barnabas ta Sawl heyey, ta’, a mbəkdamata ŋga diyam aa sləra ha. ");
INSERT INTO mif_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Anda keɗe, *Mesəfney ŋga Gazlavay a slərdata ata *Barnabas ta *Sawl. A diyam aa berney ŋga Selesi. Feteɗe, a ndəkwam aa kwambiwal ŋga daw aa hwayak ŋga Sipəre masa da wuzlah bəlay. ");
INSERT INTO mif_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","A wusam aa berney ŋga Salamin daa hwayak ŋga Sipəre he. Feteɗe, a wuzdamara mey ŋga Gazlavay a ndəhay *Jəwif hay daa *way-mewuzey-mey ŋga Gazlavay a. Jaŋ-Mark, aa da wuzlah ata ŋga jənta. ");
INSERT INTO mif_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","A pəkmara hwayak a tabiya haa kasl a wusam aa berney ŋga Pafaws. Feteɗe, a hətfamar ndaw Jəwif mezəley Bar-Yesu. Aŋga fa key maazla hay ma sawa ta fa Gazlavay ba. A mbərzley, a ləvey aŋga *ndaw ma təla mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bar-Yesu a, aŋga madərlam ŋga bay ŋga hwayak a. Bay a, mezəley Serziyas Pawlas, aŋga ndaw ta leŋgesl. A zəltərwa ata Barnabas ta Sawl a way aŋga, maja a wuɗey ŋga cəney mey ŋga Gazlavay fa ata. ");
INSERT INTO mif_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bar-Yesu, ndaw ma ka maazla ha, a zəlmara ta mey Gərek, Elimas. Ama Elimas na, a wuɗey mey ŋga ata Barnabas ta Sawl ba. A səpey cəveɗ amba a təka bay a ŋga təɓa mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Da ray ŋgene, Sawl, masa ata ma zəlmara ta mey Gərek Pawl, marəhkaya ta Mesəfney ŋga Gazlavay, a nəkfa ndaw aha, ");
INSERT INTO mif_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","a ləvar: «Kah ndaw membərzley! Kah, ndaw ma təknata ndəhay tabiya! Kah, bəzey ŋga bay-malula! Kah, masa-gəra ŋga cek hay maaya tabiya! Sləra masa Bay Gazlavay ma ka na, ara sləra maaya ta cəveɗ e. Ama kah, ka fa səpey cəveɗ mandaw mandaw ŋga nəsa sləra ha! ");
INSERT INTO mif_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ehe, wure keɗe, Bay Gazlavay a da nəska, ka da wulfey. Haa ɗar nekəɗey, ka fa da hətar meweɗey ŋga pas daa ba.» Wure wure ŋgene, slam tabiya a tərey ləvaŋ fa mey aŋga, a hətar dey saba. A səpey ndaw ŋga ɗaɗa fa har. ");
INSERT INTO mif_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Bay heyey ma hətar cek ma key anda keɗe la na, a rəzley ga da ray mey ŋga Bay Mahura Yesu, ta’, a təɓa mey ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Fa dəɓa ha, Pawl ta ndəhay ma ləgdamara a təpam aa kwambiwal, a sləkɗam daa berney ŋga Pafaws. A təŋgam bəlay, a diyam a Perze masa daa hwayak ŋga Pamfili. Feteɗe na, Jaŋ-Mark a mbəkdata, a vəhwa a *Jeruzelem. ");
INSERT INTO mif_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ata na, a sləkɗam daa berney ŋga Perze he, a diyam a Antiyaws daa hwayak ŋga Pisidi. Ta *pas meməskey-vaw, a diyam, a njam aa *way-mewuzey-mey ŋga Gazlavay feteɗe. ");
INSERT INTO mif_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Daa way a, ndəhay a jaŋgamara ɗerewel ŋga *kwakwas ŋga Mawiz leŋ ŋga ndəhay ma təla mey. Fa dəɓa ha, *bay-ray hay daa way a, a sləram ndaw fa ata Pawl ta *Barnabas ŋgaa guzltar, a ləvtar: «Məlma ala hay, da akwar ta mey daha ŋga vəltar gədaŋ a ndəhay makustakaya keɗe na, ka gwamara ŋgaa guzlam wure keɗe.» ");
INSERT INTO mif_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pawl, ta’, a sləkɗey, a lecey, a baŋgaɗa har aŋga, a zlar meeguzley, a ləvey: «Akwar, ndəhay Israyel hay, ta akwar masa daa səkway ŋga Jəwif hay ba ma səpam mey ŋga Gazlavay, jəkfamaya sləmay. ");
INSERT INTO mif_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Gazlavay masa ndəhay *Israyel hay ma namar ray na, ta walata papaŋ ŋga papa aləkwa hay la zleezle. Ta səkdata la ga daa masa ata daa hwayak ŋga *Ejip. Fa dəɓa ha, ta badatərwa la daa hwayak ŋga Ejip ta gədaŋ aŋga mahura. ");
INSERT INTO mif_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","A key mevey kwakwar məfaɗ aŋga fa nəkfatar dey da wuzlah-ley. ");
INSERT INTO mif_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Fa dəɓa ha, a paslata səkway hay maasala da *Kanaŋ cəpa, a vəldatara hwayak a, a ndəhay Israyel hay ŋga wamara. ");
INSERT INTO mif_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mevey masa Israyel hay ata daa beke ta masa ata da wuzlah-ley na, a key mevey temere məfaɗ ta kwakwar zlam. «Fa dəɓa ha, a patar bay-ray hay ŋga jənta papaŋ ŋga papa aləkwa hay a, haa kasl fa *ndaw ma təla mey ŋga Gazlavay mezəley Samiyel ma sawa. ");
INSERT INTO mif_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Daa ŋgene, ta’, aa cəfɗam bay. Anda keɗe, Gazlavay a vəltar *Sawl, bəzey ŋga Kis, daa səkway ŋga Benjameŋ ŋga key bay ata. A wa hwayak a, mevey kwakwar məfaɗ. ");
INSERT INTO mif_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ta’, Gazlavay a bada Sawl daa bay, a patar *Davit ŋga bay ata. Gazlavay aa guzley da ray a, a ləvey: “Ya ta hətey ndaw ma mbafaya la, ara Davit, bəzey ŋga Jese. A da key sləra tabiya masa yah ma wuɗey.” ");
INSERT INTO mif_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Daa səkway ŋga Davit e na, Gazlavay ta bawa ndaw pal la ma da ləhdata Israyel hay anda aa ma ləvey zleezle . Ndaw aha na, ara Yesu. ");
INSERT INTO mif_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Wuskwaa Yesu a da zlar sləra aŋga na, *Jaŋ-Baptis ta wuzdatara la a ndəhay Israyel hay tabiya, a ləvtar: “Mbəɗdamara menjey akwar, mbəkdamara mekey mebərey, hətam *baptem.” ");
INSERT INTO mif_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Mamba Jaŋ-Baptis a ndəvda sləra aŋga na, a ləvtar a ndəhay: “Ka wulkam yah na, wa? Yah na, ndaw masa akwar ma səkwmara heyey ba. Ama jəkam sləmay, ndaw ma da sawa fa dəɓa aɗaw daha, a fənya, kwa ya wusa ŋga pəska zeweɗ ŋga tarak aŋga ba.”» ");
INSERT INTO mif_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pawl a ləvtar saya: «Məlma aɗaw hay, akwar masa daa səkway ŋga *Abəraham, ta masa daa səkway ŋga *Jəwif hay ba ma namar ray a Gazlavay, Gazlavay ta slərdandakwara *Mey-maaya-mawiya la ŋgada aləkwa amba a ləhdandakwar daa mebərey. ");
INSERT INTO mif_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Fara fara, ndəhay da Jeruzelem ta bay-ray ata hay ta sərmara Yesu ara wa na, daa ba. Mey ŋga ndəhay ma təla mey ŋga Gazlavay masa ata ma jaŋgamara mandaw mandaw ta pas meməskey-vaw na, ta cəndamara daa ba may. Ama ta pas masa ata ma kamar sariya a Yesu ŋga kəɗey vagay na, ta kamara la anda mey a ma ləvey. ");
INSERT INTO mif_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kwa ta hətam mey fa aŋga təɗe ŋga kar sariya ŋga kəɗey vagay na, daa ba. Ta ŋgene he cəpa, ta’, a kamar ambahw a Pilat ŋga kəɗa vagay. ");
INSERT INTO mif_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Masa ata ma kamara cay tabiya anda ɗerewel ŋga Gazlavay maa guzley da ray Yesu a na, ta’, a bərŋgadamərwa da ray hwadam, a pəshamara aa cəvay. ");
INSERT INTO mif_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama Gazlavay ta sləkɗadərwa sem daa meməcey. ");
INSERT INTO mif_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yesu ta wuztar vaw la a ndəhay ɗar weewe, ndəhay masa zleezle ata ma pəkam bama daa hwayak ŋga *Galile haa kasl a Jeruzelem. Wure keɗe, ndəhay a fa kam sede da ray a fa mey ŋga Israyel hay. ");
INSERT INTO mif_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Ala may, ya fa wuzdamakwara mey maaya da ray cek masa Gazlavay ma ləvtar zleezle a papaŋ ŋga papa aləkwa hay a katara la heyey. ");
INSERT INTO mif_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Wure keɗe Gazlavay ta kandakwara cek aha la ŋgada aləkwa, bəz ata hay, ta fa masləkɗawa ŋga Yesu daa meməcey. Aŋga letek ta mey mawuzlalakaya daa *Pəsam cew ma ləvey: “Kah na, Bəzey aɗaw, dəga tasana yah Papakw.” ");
INSERT INTO mif_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yaw, Gazlavay ta sləkɗadərwa la daa meməcey, amba kwa a zey ba səlak. Zleezle Gazlavay ta ləvey la: “Ya pəskwar mey la, anda yah ma ləvar a Davit. Fara fara, ya kakwara cek aha la.” ");
INSERT INTO mif_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Maja ŋgene, mawuzlalakaya daa ɗerewel mekele saya, a ləvey: “Ndaw ma ka sləra akah na, ka fa da mbəkda ŋga zey daa cəvay daa ba səlak.” ");
INSERT INTO mif_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davit e, daa masa aŋga ta dey na, fa key sləra anda Gazlavay ma wuɗey. Ta’, a məcey, a pəshamara aa cəvay a cakay papaŋ ŋga papaha hay, vaw aŋga na, ta zey sem. ");
INSERT INTO mif_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama ndaw masa Gazlavay ma sləkɗadərwa daa meməcey na, ta zey daa ba. ");
INSERT INTO mif_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Məlma aɗaw hay, si ka sərmara fara fara, ala fa wuzdamakwara, Gazlavay a mbəkdatara mebərey ŋga ndəhay na, ta fa Yesu. Gazlavay ta mbəkdakwara mebərey akwar maja akwar ma səpmara kwakwas ŋga Mawiz na, daa ba. ");
INSERT INTO mif_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ama kwa waawa ma pa Yesu ŋga ndaw aŋga fara fara na, Gazlavay ta mbəkdara mebərey aŋga sem. ");
INSERT INTO mif_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Maja ŋgene, wam vaw fa mey ŋga ndəhay ma təla mey hay zleezle ma kadamara, amba cek masa ata ma kadamara ha a wusfakwar ba. Ndəhay a, a ləvam: ");
INSERT INTO mif_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Akwar ndəhay ma rəsmara mey ŋga Gazlavay, nəkmara! Ka da rəzlam, fa dəɓa ha, ka daa zəɗam, maja yah, Bay Gazlavay, ya da key sləra mahura ta pas masa akwar ta dey keɗe. Kwa ndaw ta wuzdakwara mey da ray sləra ha la na, akwar fa da təɓmara daa ba.”» ");
INSERT INTO mif_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Masa ata Pawl ta Barnabas heyey ma bamawa daa way-mewuzey-mey ŋga Gazlavay la na, ndəhay a, a ləvmatar ŋga vəhmawa ta pas meməskey-vaw mekele ma da sawa, amba aa guzlmatar da ray mey a saya. ");
INSERT INTO mif_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Fa dəɓa ha ndəhay maa waham ray cay na, ndəhay ga ta diyam la asi ata Pawl ta Barnabas. Ma diyam a na, ara Jəwif hay ta ndəhay siya hay ma mbəzam ŋga səpey kwakwas ŋga Jəwif hay. Daa maɗay ata ta ndəhay a na, ata Pawl ta Barnabas a vəlmatar gədaŋ amba a njam mandaw mandaw daa maaya ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Masa pas meməskey-vaw mekele heyey ma wuswa cay na, har-gədaŋ ŋga ndəhay daa berney a, a kusam ŋga cəney mey da ray Bay Mahura Yesu. ");
INSERT INTO mif_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ama Jəwif hay a nəkmata ndəhay ga makustakaya feteɗe na, səleŋ a katar. A cəɗmara Pawl, a wuɗam mey aŋga ba. ");
INSERT INTO mif_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ata Pawl ta Barnabas heyey ta’, aa guzlmatar ta mandərzay daa dey daa ba, a ləvmatar: «Teeseɗ na, anja si cəma ya wuzdamakwara mey ŋga Gazlavay ŋgada akwar Jəwif hay ɗagay. Ama, ka təɓmara mey a ba. Anda keɗe akwar fa wuzdamara, akwar təɗe ŋga njam da vaɗ ta Gazlavay ŋga sərmataw ba. Da ray ŋgene, ya mbəkdamakwar, ya diyam fa ndəhay mekele masa Jəwif hay ba. ");
INSERT INTO mif_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ehe, Bay Gazlavay ta vəlndar *mewey aŋga la, a ləvey: “Ya ta paka la ŋga weɗey fa mey ŋga ndəhay masa Jəwif hay ba hay, amba ka wuzdatara a ndəhay tabiya da bəla ya da ləhdata na, kwara.”» ");
INSERT INTO mif_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ndəhay masa Jəwif hay ba ma cəndamara mey a na, aa səmam ga. Aa həmdamara mey ŋga Bay Gazlavay. Ndəhay masa Gazlavay ma walata la ŋga hətey heter mendəvey ba na, a təɓmara mey ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Anda keɗe, ndəhay fa wuzdamara mey ŋga Bay Gazlavay kwa daa wura daa wura daa hwayak a ŋgene. ");
INSERT INTO mif_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ama Jəwif hay da Antiyaws a həldamata ŋgusay masa-zleley hay ma səpa kwakwas ŋga Jəwif hay leŋ ndəhay mahura hay daa berney a, ŋga sərdamata banay ta ata Pawl ta Barnabas. A ɓəlmatərwa daa hwayak ata. ");
INSERT INTO mif_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ata Pawl ta Barnabas, a raramara lagwada fa salay ata hay . Ta’, a diyam aa berney ŋga Ikwaniyum. ");
INSERT INTO mif_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ama ndəhay ma səpa cəveɗ ŋga Yesu da Antiyaws a na, a njam daa meesəmey fara fara, ata marəhtakaya ta *Mesəfney ŋga Gazlavay. ");
INSERT INTO mif_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ata Pawl ta *Barnabas a wusam aa berney ŋga Ikwaniyum. A diyam aa *way-mewuzey-mey ŋga Gazlavay feteɗe anda ata ma diyam da Antiyaws. A wuzmatar mey da ray Yesu a ndəhay maaya maaya haa ndəhay masa *Jəwif hay ta ndəhay masa Jəwif hay ba hay ga feteɗe, a təɓmara mey a. ");
INSERT INTO mif_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama Jəwif hay siya a gəmam ŋga təɓmara mey a ba. Anda keɗe, a həldamata ndəhay masa Jəwif hay ba hay ŋga wulkam maaya ba da ray ndəhay ma təɓa mey ŋga Yesu. ");
INSERT INTO mif_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ta ŋgene he cəpa, ata Pawl ta Barnabas ta njam la ga da Ikwaniyum a cəŋga. A wuzam mey da ray Bay Mahura ta mandərzay daa dey ba. A kam sede da ray Gazlavay, aa guzlam da ray maaya aŋga. Bay Gazlavay a wuzdərwa mey ata na, ara mey fara fara, a vəltar gədaŋ ŋga key maazla hay ma rəzla ndaw. ");
INSERT INTO mif_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ta’, ndəhay daa berney a, a wunkam cew maja mey a. Siya hay a təɓam mewulkey ŋga Jəwif hay, siya hay may a təɓam mewulkey ŋga ndəhay meslərey a. ");
INSERT INTO mif_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Daa ɗar hay a ŋgene, ndəhay Jəwif hay ta ndəhay masa Jəwif hay ba hay leŋ bay ata hay na, a cəmdamara ɗay ata pal. A wuɗam ŋga sərdamata banay ta ata Pawl ta Barnabas, a wuɗam ŋgaa zakamata ta aŋgwa vagay. ");
INSERT INTO mif_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Masa ndəhay meslərey cew keɗe ma cəndamara mey a la na, a hwam da Ikwaniyum, a diyam ŋgadaa berney ŋga Listəra, ŋgadaa berney ŋga Derbe masa daa hwayak ŋga Likwani, leŋ aa slala hay mekele mekele daa hwayak a. ");
INSERT INTO mif_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Feteɗe may, ta wuzam *Mey-maaya-mawiya la. ");
INSERT INTO mif_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Da Listəra, ndaw daha maahəlɓakaya dəga ŋga mayawa aŋga, a gwa ma daw ba. ");
INSERT INTO mif_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Aa fa jəkey sləmay fa mey masa Pawl maa guzlda. Pawl a nəkfa, a səra ndaw a fa təɓa mey ŋga