﻿USE sofia;
DROP TABLE IF EXISTS sofia.mieNT_vpl;
CREATE TABLE mieNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mieNT_vpl WRITE;
INSERT INTO mieNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yáhá cúu lista nāsa nī nquiji tatā Jesucristo. De maá yā cúu tatā rey David, de David nī nquiji nūū tatā Abraham. ");
INSERT INTO mieNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham nī ncuu dē tatá Isaac, de Isaac nī ncuu dē tatá Jacob, de Jacob nī ncuu dē tatá Judá jíín ndá ñanī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","De Judá nī ncuu dē tatá Fares jíín Zara, de naná ndúū dē nī ncuu Tamar. De Fares nī ncuu dē tatá Esrom, de Esrom nī ncuu dē tatá Aram. ");
INSERT INTO mieNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","De Aram nī ncuu dē tatá Aminadab, de Aminadab nī ncuu dē tatá Naasón, de Naasón nī ncuu dē tatá Salmón. ");
INSERT INTO mieNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","De Salmón nī ncuu dē tatá Booz, de naná dē nī ncuu Rahab. De Booz nī ncuu dē tatá Obed, de naná dē nī ncuu Rut. De Obed nī ncuu dē tatá Isaí. ");
INSERT INTO mieNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","De Isaí nī ncuu dē tatá David, tēe nī ncuu rey. De rey David nī ncuu dē tatá Salomón, de naná dē, xihna cā nī ncuu ña ñasíhí Urías. ");
INSERT INTO mieNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","De Salomón nī ncuu dē tatá Roboam, de Roboam nī ncuu dē tatá Abías, de Abías nī ncuu dē tatá Asa. ");
INSERT INTO mieNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","De Asa nī ncuu dē tatá Josafat, de Josafat nī ncuu dē tatá Joram, de Joram nī ncuu dē tatá Uzías. ");
INSERT INTO mieNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","De Uzías nī ncuu dē tatá Jotam, de Jotam nī ncuu dē tatá Acaz, de Acaz nī ncuu dē tatá Ezequías. ");
INSERT INTO mieNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","De Ezequías nī ncuu dē tatá Manasés, de Manasés nī ncuu dē tatá Amón, de Amón nī ncuu dē tatá Josías. ");
INSERT INTO mieNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","De Josías nī ncuu dē tatá Jeconías jíín ndá ñanī dē, maá tiempo jā cuáhān ndá nchivī Israel preso jondē nación Babilonia. ");
INSERT INTO mieNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","De tá nī īyo ndá ji ñúcuán, de Jeconías nī ncuu dē tatá Salatiel. De Salatiel nī ncuu dē tatá Zorobabel. ");
INSERT INTO mieNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","De Zorobabel nī ncuu dē tatá Abiud, de Abiud nī ncuu dē tatá Eliaquim, de Eliaquim nī ncuu dē tatá Azor. ");
INSERT INTO mieNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","De Azor nī ncuu dē tatá Sadoc, de Sadoc nī ncuu dē tatá Aquim, de Aquim nī ncuu dē tatá Eliud. ");
INSERT INTO mieNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","De Eliud nī ncuu dē tatá Eleazar, de Eleazar nī ncuu dē tatá Matán, de Matán nī ncuu dē tatá Jacob. ");
INSERT INTO mieNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","De Jacob nī ncuu dē tatá José, tēe nī ncuu yií María. De María nī ncuu ña naná Jesús, Yāā nání Cristo. ");
INSERT INTO mieNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","De jondē Abraham de jondē David de nī ncuu ūxī cūmī tatā. De jondē David de jondē tá cuāhān ndá nchivī Israel preso nación Babilonia de nī ncuu tucu ūxī cūmī tatā. De jondē tá nī jēhēn ndá ji preso de jondē nī ncacu Cristo, suni nī ncuu ūxī cūmī cā tatā. ");
INSERT INTO mieNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","De jā ní ncacu Jesucristo de súcuán nī ncuu: Naná yā María, ja nī ncundaā jā cundeē ña jíín José. De jondē tá ncháha ca cundeē ña jíín dē, de nī jīcūhun sēhe ña nī nsāhá Espíritu Santo. ");
INSERT INTO mieNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","De José, tēe jā cundeē ña jíín, chi tēe ndāā cúu dē. De nduú cúnī dē cuāha dē tūhun canoō ña, chi sa cúnī dē jā ná jéncuiñī yuhū-ni jā má cúndeē dē jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","De juni súcuán nácani inī dē, de nī stéhēn jāni nūū dē jā ní nquenda-ni iin ángel maá Jētohō ō Yāā Dios nūū dē, de nī ncāhān yā jíín dē: José, sēhe tatā David, mā cúyūhú nú cueca nú ñasíhí nú María, chi sēhe ña jā cacu, vāji ji jondē nūū maá Espíritu Santo. ");
INSERT INTO mieNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","De cacu iin sēhe yií ña. De scúnaní nú ji Jesús, chi maá ji cúu Yāā jā scácu ndá nchivī nūū cuáchi ji, ncachī ángel. ");
INSERT INTO mieNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Súcuán nī ncuu ndācá tiñu yáhá, tácua quee ndaā tūhun Jētohō ō Yāā Dios jā ní ncāhān tēe nī nacani tūhun yā jondē janahán. De súcuán nī ncāhān dē: ");
INSERT INTO mieNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Coo iin ñahan lúlí, de nīhīn séhe ji, de scácu ji iin sēhe yií, de cunaní sūchí ñúcuán Emanuel. Cáchī tutū. De síví yáhá cáchī: Yāā Dios ndéē yā jíín ó. ");
INSERT INTO mieNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","De nī ndoto José, de nī nsāhá dē tá nī ncachī ángel Jētohō ō Yāā Dios nūū dē. De nī jeca dē María nī ncuu ña ñasíhí dē. ");
INSERT INTO mieNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","De nduú ní nquíxīn dē jíín ña, chi jondē nī scácu ña sēhe yií xíhna ñúhún ña. De nī scúnaní dē ji Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","De tá nī ncacu Jesús inī ñuū Belén ndáñúū Judea, de tiempo ñúcuán tátúnī rey Herodes. Ñúcuán de jacū tēe ndíchí jā scuáha sīquī tiūūn, nī nquiji jícá ndá dē ichi nūū quénda ncandiī, de nī nquenda dē ciudad Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","De nī jīcā tūhún ndá dē nchivī: ¿Ní cúu nūū íyó sūchí jā ní ncacu jā cuu rey nchivī hebreo? Chi ichi nūū quénda ncandiī nī jinī ndá sá iin tiūūn cāhnú jā cúu seña jā ní ncacu ji. De vāji ndá sá jā chiñúhún sá ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","De rey Herodes, tá nī jini dē tūhun ñúcuán, de nī ncunēhén inī dē, jondē jíín ndācá nchivī Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","De nī nastútú dē ndācá sūtū cúñáhnú jíín ndācá tēe stéhēn ley janahán nūū nchivī. De nī jīcā tūhún dē ndá tēe ñúcuán ní cúu nūū cacu Cristo, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","De nī ncachī ndá dē nūū rey: Inī ñuū Belén ndáñúū Judea. Chi súcuán cáchī nūū tútū jā ní ntee tēe nī nacani tūhun yā jondē janahán: ");
INSERT INTO mieNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ndá ndóhó nchivī ñuū Belén ndáñúū Judá, cúñáhnú cā ñuū nū nsūú cā ndá cā ñuū jā cúñáhnú inī Judá. Chi suu inī ñuū nū quee iin Yāā jā tatúnī, de coto yā nchivī maá nī Israel, ncachī Yāā Dios. Cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ñúcuán de Herodes nī ncana yuhū dē ndá tēe ndíchí jā nání mago. De nī jīcā tūhún vāha dē nā quīvī cúu jā ní nquenda tiūūn ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","De nī ntají dē ndá tēe ñúcuán jā quíhīn dē ñuū Belén. De nī ncāhān dē: Cuáhán ndá ní de cātūhún vāha ní ní cúu nūū íyó sūchí lúlí. De tá nī nanihīn ndá ní ji, de quiji ní cachī tūhun ní nūū sá, tácua suni quīchiñúhún maá sá ji, ncachī rey. ");
INSERT INTO mieNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","De tá nī jini ndá dē tūhun jā ní ncāhān rey, de cuāhān ndá dē. De maá tiūūn cāhnú jā ní jinī dē ichi nūū quénda ncandiī, nī jēcōsō nūú cuāhān nūū ndá dē jondē nī nquenda nūū íyó sūchí lúlí, de ñúcuán nī jencuiñī. ");
INSERT INTO mieNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","De tá nī jinī ndá dē jā ní jencuiñī tiūūn, de nī ncusiī ndasí inī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","De nī jīnū ndá dē nī nquīvi dē inī vehe, de nī jinī dē nūū sūchí lúlí jíín naná ji María. De nī jēcuīñī jītí ndá dē nūū ji, de nī nchiñúhún dē ji. De nī nacune ndá dē jātūn dē, de nī nsōcō dē oro jíín incienso jíín sūja ūguā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ñúcuán de nī stéhēn jāni nūū ndá dē, de nī ncachī nūū dē jā má quínohōn dē nūū Herodes. De incā ichi cuānohōn dē ñuū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","De tá cuānohōn ndá tēe mago, de nī stéhēn jāni nūū José jā iin ángel maá Jētohō ō Yāā Dios nī ncāhān yā jíín dē: Nacōo de cunu nú quīhīn nū jíín sūchí lúlí jíín naná ji jondē nación Egipto. De ñúcuán cundeē nū jondē cachī tūhun nī nūū nū. Chi Herodes ja ñatin nanducú dē sūchí lúlí jīñā jā cahnī dē ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","De nī ndoto José. De cuāhān dē jíín sūchí lúlí jíín naná ji, de nī jica ñuú ndá dē cuāhān dē Egipto. ");
INSERT INTO mieNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","De ñúcuán nī ndeē dē jondē nī jīhī Herodes. De súcuán nī ncuu tácua quee ndaā tūhun Jētohō ō Yāā Dios jā ní ncāhān tēe nī nacani tūhun yā janahán: Jondē nación Egipto nī ncana nī Sēhe nī vāji ji, ncachī Yāā Dios, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ñúcuán de nī jinī Herodes jā súcuán nī stáhví ndá tēe mago dē, de nī nquītī ndasí inī dē. De nī ntají dē ndá soldado cuāhān, de nī jahnī ndācá tēe ñiquín jā úū cuīyā jíín jā lūlí cā jā íyó inī ñuū Belén jíín ndācá ñuū ñatin. Chi ja nī jīcā tūhún vāha dē ndá tēe mago nāsaa tiempo nī ncuu jā ní ncacu Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","De súcuán nī nquee ndaā tūhun jā ní ncāhān Jeremías, tēe nī nacani tūhun yā jondē janahán, chi nī ncāhān dē: ");
INSERT INTO mieNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Inī región Ramá nī jini nī jā jácu de jácu cóhó. Chi ndá ñahan cúu tatā Raquel, jácu ña jēhē sēhe ña, de nduú cúnī ndusiī inī ndá ña, chi nī jīhī ndá ji. Cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ñúcuán de nī jīhī Herodes. De nī stéhēn jāni nūū José jā iin ángel Jētohō ō Yāā Dios nī ncāhān yā jíín dē jondē nūū ndéē dē Egipto: ");
INSERT INTO mieNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nacōo de quīnohōn nū nación nū Israel jíín sūchí lúlí jíín naná ji. Chi ja nī jīhī ndá tēe jā ndúcú cahnī sūchí lúlí jīñā nícu, ncachī ángel. ");
INSERT INTO mieNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ñúcuán de nī nacōo dē, de cuānohōn dē Israel jíín sūchí lúlí jíín naná ji. ");
INSERT INTO mieNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","De nī nīhīn dē tūhun jā Arquelao nī nūcuīñī dē nūū ndīyi tatá dē Herodes, de maá dē tátúnī inī región Judea. De yúhú dē jā quínohōn dē ñúcuán. De nī stéhēn jāni nūū dē jā ná quíhīn dē región Galilea, de cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","De nī nquenda ndá dē ñúcuán, de nī ndeē dē ñuū nání Nazaret. Súcuán nī ncuu tácua quee ndaā tūhun jā ní ncāhān ndá tēe nī nacani tūhun Yāā Dios janahán. Chi nī ncachī dē jā cāhān nchivī jā tēe ñuū Nazaret cúu Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","De nī jica tiempo, de nī nquenda Juan tēe scuénduté jondē nūū ñuhun tíhá ndáñúū Judea, de suha nácani dē tūhun: ");
INSERT INTO mieNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nacani inī ndá nú jā sndóo nú cuāchi nú, chi ja nī ncuñatin maá Yāā ndéē andiví jā tatúnī yā nūū nū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","De Isaías, tēe nī nacani tūhun Yāā Dios jondē janahán, suha nī ntee dē tūhun Juan nūū tutū: Coo iin tēe jā cana jee jondē nūū ñuhun tíhá: Sāhá tūha ndá nú maá nú, chi quenda maá Jētohō ō. De sāhá ndá nú tiñu ndāā, chi vāji yā, cachī dē. Ncachī Isaías. ");
INSERT INTO mieNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","De sahma ñúhún Juan cúu ixi camello, de núhnī iin cinturón ñii chījin dē. De jā técū dē cúu tīca langosta jíín ndūxi yōcō. ");
INSERT INTO mieNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","De nchivī ciudad Jerusalén jíín ndācá nchivī región Judea jíín nchivī ndéē ñatin yuhú yūte Jordán, nī nquenda ndá ji nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","De nī nacani ndaā ndá ji cuāchi ji nūū Yāā Dios, de nī scuénduté dē ji inī yūte Jordán. ");
INSERT INTO mieNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","De tá nī jinī dē jā váji cuāhā tēe grupo fariseo jíín tēe grupo saduceo nūū scuénduté dē, de nī ncāhān dē: Va sēhe cōō cúu ndá nú, chi xēēn nū tá cúu cōō. ¿A jáni inī ndá nú jā cuu cunu nú cācu nú nūū castigo xēēn jā quiji? ");
INSERT INTO mieNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Túsaá de sāhá ndá nú tiñu váha, de súcuán stéhēn nū jā ní nacani ndija inī nū jā sndóo nú cuāchi nú. ");
INSERT INTO mieNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","De mā cāní inī ndá nú cāhān nū jā cuu cācu nú sīquī jā cúu nú tatā Abraham. Chi cáhān ni jíín ndá nú jā cuu sāhá Yāā Dios jā ndācá yūū yáhá nduu sēhe Abraham jā candíja vāha, de tú cúnī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","De cúu ndá nú tá cúu tūndīhá jāá nduú jéhe jāvíxī vāha. De mitan de ja íyó tūha Yāā Dios jā cuāha yā castigo xēēn, tá cúu nūū íyó tūha iin cāa jā quehndē jondē yoho ñutun. Túsaá de sāhá yā jíín ndá nú tá cúu nūū sáhá yā jíín ndācá ñutun jāá nduú jéhe jāvíxī vāha, jā tēhndē de cāyū nūū ñúhūn. ");
INSERT INTO mieNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","De nduhū chi jíín ndute scuénduté nī ndá nú, de ñúcuán cúu jā stéhēn nū jā ní nacani inī nū jā sndóo nú cuāchi nú. De Yāā jā quiji, chi modo jā scuénduté yā ndá nú cúu jā cuāha yā Espíritu Santo cundeē inī ánō ndá nú, de poder yā cúu tá cúu ñuhūn. De Yāā jā quiji chi cúñáhnú ndasí cā yā nsūú nduhū. Chi nduú cúñáhnú cuitī ni nūū yā, ni jā cuetíñú yā nduhū vísō iin tiñu lúlí cā jā cuiso nī nījān yā. ");
INSERT INTO mieNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","De sāhá yā tá sáhá tēe stéchí trigo, chi sāhá síín yā nchivī vāha jíín nchivī nēhén, tá cúu nūū cúndoo trigo jā quée síín paja. De nastútú yā trigo yā ndīvi inī yacā yā. Sochi paja chi teñuhūn yā nūū ñúhūn jā má ndáhvā cuitī, ncachī Juan. ");
INSERT INTO mieNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ñúcuán de nī nquee Jesús región Galilea, de nī nquenda yā yūte Jordán nūū íyó Juan, tácua scuénduté dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sochi nduú cúnī Juan scuénduté dē yā, chi nī ncāhān dē jíín yā: Sa cánuú jā scuénduté maá ní sāán, ¿de nāsa cúu jā sa nūū sá vāji ní? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","De nī ncāhān Jesús jíín dē: Nduú chi sāhá nú, chi súcuán cánuú jā squíncuu ó ndācá jā tátúnī Yāā Dios, ncachī yā. Ñúcuán de nī scuénduté dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","De tá nī ncuu nī jenduté yā, de nī nquee yā ndute. De nī nune-ni nūū ndéē Yāā Dios andiví, de nī jinī yā jā cúun Espíritu Yāā Dios vāji, de cáá tá cáá iin paloma, de nī jīnū xīnī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","De ichi andiví nī ncāhān iin tūhun: Yáhá cúu Sēhe nī jā mānī ndasí nī jíín, de cúsiī ndasí inī ni jíín, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ñúcuán de nī jīnū Jesús jondē nūū ñuhun tíhá nī nsāhá Espíritu Santo. Chi ñúcuán coto túnī tāchī cúñáhnú yā, chi cúnī jā sāhá yā cuāchi. ");
INSERT INTO mieNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","De nī īyo nditē inī yā ūū xico nduú ūū xico ñuú, sá de nī nquiji sōco nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","De nī nquenda maá tāchī cúñáhnú jā coto túnī ji yā, de nī ncāhān jíín yā: Tú maá nú cúu Sehe Yāā Dios de cāhān nū jā ndá yūū yáhá ná ndúu stāā cajī nū, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","De nī ncāhān yā jíín: Nduú chi yósō nūū tutū īī: Nsūú mátúhún-ni stāā cúu jā técū nchivī, chi suni jíín ndācá tūhun jā cáhān Yāā Dios, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ñúcuán de cuāhān tāchī cúñáhnú jíín yā jondē Jerusalén jā cúu ciudad īī. De nī jani ji yā xīnī torre templo. ");
INSERT INTO mieNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","De nī ncāhān ji jíín yā: De tú Sēhe Yāā Dios cúu nú, de squíncava nú maá nú jondē nūū ñūhún, chi scácu yā ndóhó. Chi súcuán yósō nūū tutū: Tetíñú yā ndá ángel yā jā coto ndóhó. De canee ndá yā ndóhó, tácua mā scáchihi nú jēhē nū nūū yúū. Cáchī tutū, ncachī tāchī. ");
INSERT INTO mieNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","De nī ncāhān Jesús: Nduú chi suni yósō cā nūū tutū jā má cōtó túnī nchivī Jētohō ji Yāā Dios, á scácu yā ji á nduú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","De tāchī cúñáhnú nī jeca tucu ji yā cuāhān ji jíín yā xīnī iin yucu súcún ndasí. De nī stéhēn ji ndācá nación níí cáhnú ñayīví nūū yā, de viī ndasí cáá ndihi. ");
INSERT INTO mieNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","De nī ncāhān jíín yā: Ndācá yáhá taji nī nūū nū, de tú cuiñi jítí nú chiñúhún nú nduhū, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ñúcuán de nī ncāhān Jesús nūū tāchī: Satanás, cujiyo cuáhán, chi yósō nūū tutū jā ná chíñúhún nchivī maá Jētohō ji Yāā Dios, de nūū mátúhún-ni yā satíñú ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ñúcuán de nī ncujiyo-ni tāchī cúñáhnú cuāhān. De nī nquenda ndá ángel Yāā Dios nī nchindeé ndá yā. ");
INSERT INTO mieNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","De tá nī nīhīn Jesús tūhun jā yíhí Juan vecāa, de cuānohōn yā región Galilea. ");
INSERT INTO mieNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","De nduú ní ndéē yā ñuū Nazaret, chi nī jēhēn yā nī ndeē yā ñuū Capernaum. De ñuū ñúcuán cáá yuhú mar, maá región Zabulón jíín Neftalí. ");
INSERT INTO mieNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","De súcuán nī ncuu tácua quee ndaā tūhun nī ntee Isaías, tēe nī nacani tūhun Yāā Dios janahán: ");
INSERT INTO mieNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Región Zabulón jíín Neftalí, ichi jā cuáhān yuhú mar, lado yūte Jordán nūū quénda ncandiī, jíín región Galilea nūū ndéē nchivī ndá cā nación jāá nduú jínī tūhun yā. ");
INSERT INTO mieNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nchivī ñúcuán chi modo nūū neē ndéē ji, de stúu yā luz yā nūū ji. De nchivī ja ñatin naā, nīhīn ji tūhun vāha ndasí, suu tūhun jā scácu yā ánō ji. Ncachī Isaías. ");
INSERT INTO mieNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","De jondē quīvī ñúcuán nī nquijéhé Jesús nácani yā tūhun, de súcuán nī ncāhān yā: Nacani inī ndá nú jā sndóo nú cuāchi nú, chi ja nī ncuñatin Yāā ndéē andiví jā tatúnī yā nūū nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","De jíca Jesús yuhú mar Galilea cuāhān yā. De nī jinī yā nūū ūū tēe, de ñanī ndúū dē. De iin dē cúu Simón jā suni nání Pedro, de incā dē cúu Andrés. De tēe tíin tiacá cúu ndúū dē, de chúhun dē ñunu dē inī mar. ");
INSERT INTO mieNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","De nī ncāhān yā jíín ndúū dē: Cuniquīn nduhū ná cóhōn, de nasāhá nī ndóhó tēe jā nīhīn cuāhā nchivī jā candíja nduhū, tá cúu nūū níhīn nū tiacá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ñúcuán de nī sndóo ndúū dē-ni ñunu dē, de nī jēcuniquīn dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","De nī jica yā jacū cā, de nī jinī yā nūū ūū cā tēe, de suni ñanī ndúū dē. De cúu dē Jacobo jíín Juan, ndúū sēhe Zebedeo. De ndéē dē inī barco jíín tatá dē Zebedeo, náchicatún dē ñunu dē. De suni nī ncana yā ndúū dē jā cuniquīn dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","De nī sndóo dē-ni tatá dē jíín barco, de nī jēcuniquīn dē yā cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","De nī jica nuu Jesús níí región Galilea, nī stéhēn yā tūhun inī ndá vehe īī jā cúu sinagoga. De nī nacani yā tūhun vāha nāsa tátúnī Yāā Dios. De nī nasāhá vāha yā nchivī cúhū ndācá-ni cuēhē. ");
INSERT INTO mieNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","De nī jītē nuu tūhun yā cuāhān níí región Siria. De nūū yā nī nquisiáha ji ndācá nchivī cúhū, nchivī jā ndóho quéhén nūū cuēhē, jíín jā játū, jíín jā ñúhún tāchī inī, jíín jā jíhī yīhí, jíín jā ní nduvehlé. De nī nasāhá vāha yā ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","De cuāhā nchivī región Galilea jíín Decápolis, jíín nchivī ciudad Jerusalén jíín región Judea, jíín ndá ñuū jā íyó incā lado yūte Jordán ichi nūū quénda ncandiī, nī jēcuniquīn ndá ji yā. ");
INSERT INTO mieNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","De nī jinī Jesús nūū ndá nchivī cuāhā ñúcuán. De nī ncaa yā yucu cuāhān yā, de nī jēcundeē yā. De ndá tēe scuáha jíín yā, nī nquenda dē nūū yā ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","De nī nquijéhé yā nī stéhēn yā ndá tūhun yáhá nūū dē: ");
INSERT INTO mieNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nācā ndetū ndá nchivī jā jínī ji jāá nduú íyó vāha ánō ji sīquī cuáchi ji, chi ja nī nquīvi ji ndahá Yāā andiví jā tatúnī yā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nācā ndetū ndá nchivī cúcuécá inī, chi ndusiī inī ji sāhá Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nācā ndetū ndá nchivī vitá inī, chi nī nquee yuhú yā jā cutahvī ji ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nācā ndetū ndá nchivī jā tá-ni cúu jā cócon ji yíchī ji, suni súcuán cúu jā cúnī ndasí ji squíncuu ji tiñu ndāā, chi maá yā chindeé yā jā cuu squíncuu ji. ");
INSERT INTO mieNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nācā ndetū ndá nchivī jā cúndáhví inī táhán, chi suni cundáhví inī Yāā Dios ji. ");
INSERT INTO mieNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nācā ndetū ndá nchivī jā íyó ndoo inī ánō ji, chi cunī ji nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nācā ndetū ndá nchivī jā násāhá mānī táhán, chi cāhān Yāā Dios jā sēhe yā cúu ji. ");
INSERT INTO mieNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nācā ndetū ndá nchivī jā jínī ūhvī incā nchivī ji sīquī jā sáhá ji tiñu ndāā, chi ja nī nquīvi ji ndahá Yāā andiví jā tatúnī yā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nācā ndetū ndá nú tú cáhān nāvāha ji nūū nū jā síquī nduhū, de sáhá nāvāha ji ndóhó, de stáyáhvi ji ndóhó, vísō nduú nā cuāchi nú. ");
INSERT INTO mieNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","De sāhá sīī ndá nú inī nū túsaá, de sa víhí cā cusiī inī nū, chi cáhnú ndasí coo tāhvī nū jondē andiví. Chi suni súcuán nī jinī ūhvī ji ndá tēe nī nacani tūhun Yāā Dios jā ní nquiji xihna cā nsūú cā ndá ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ndá máá nú chi cúu nú inī ñayīví tá cúu ñīī jā yíhí nūū cūñu tácua mā téhyū. De tú ñīī ná náā jā úhguā, ¿de nāsa nduu uhguā tucu? Nduú cā tiñu cuitī cā, chi sa cutē nchivī de cuāñū ji sīquī. ");
INSERT INTO mieNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ndá tiñu váha jā sáhá nú cúu tá cúu luz inī ñayīví. De cúu nú tá cúu iin ñuū jā yósō xīnī yūcú, de mā cūú coo yuhū. ");
INSERT INTO mieNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","De ni nduú scuíquīn nchivī iin lámpara de chihi ji chījin cajón, chi sa jáni ji nūū sūcún tácua stúu nūū ndá jā ndéē inī vehe. ");
INSERT INTO mieNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","De suni súcuán stéhēn nū luz maá nú nūū ndá nchivī, de suu cúu jā cunī ji ndá tiñu váha sáhá ndá nú, de cāhān ji jā vāha ndasí Yāā cúu Tatá nú jā ndéē yā andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mā cāní inī ndá nú jā váji nī jā snáā ni ley jā ní jēhe Yāā Dios nūū Moisés, jíín jā snáā ni ndá tūhun jā ní ncāhān ndá tēe nī nacani tūhun yā janahán. Nduú vāji nī jā snáā ni, chi sa jā stéhēn cājí nī tūhun ndíso. ");
INSERT INTO mieNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Chi ndāā cáhān ni jíín ndá nú jā juni íyó andiví jíín ñayīví, de mā náā cuitī ni iin punto ni iin letra nūū tutū ley yā, chi jondē quee ndaā ndihi tūhun jā cáhān. ");
INSERT INTO mieNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Túsaá de tú iin nchivī nduú squíncuu ji iin tūhun yáhá jā ndácu ley yā, vísō iin tūhun lulí cā cúu, de tú stéhēn ji jā suni súcuán sāhá sava cā nchivī, túsaá de cuu ji nchivī núu cā inī andiví nūū tátúnī Yāā Dios. Sochi tú iin nchivī squíncuu ji de stéhēn ji jā squíncuu nchivī, túsaá de cuñáhnú ji inī andiví nūū tátúnī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chi cáhān ni jíín ndá nú, tú mā cōó ndāā cā tiñu sáhá nú nsūú cā tiñu sáhá ndá tēe stéhēn ley janahán jíín ndá tēe grupo fariseo, de mā quívi cuitī nū ndahá Yāā andiví jā tatúnī yā nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ja nī jini ndá nú tūhun jā ní ncāhān jíín nchivī janahán jā má cáhnī ji ndīyi, de nā-ni nchivī tú cahnī ji ndīyi, de quīhīn ji nūū justicia, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sochi nduhū chi cáhān ni jíín ndá nú, vísō vāchi jā quītī inī iin nchivī cunī ji táhán ji, de suni quīhīn ji nūū justicia. De tú iin nchivī cāhān nāvāha ji nūū táhán ji, túsaá de quīhīn ji nūū justicia cúñáhnú cā. De tú iin nchivī cāhān ji nūū táhán ji: Ndóhó tēe naā ndasí, cachī ji, túsaá de quīvi ji nūū ñúhūn infierno de tú mā nácani inī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Túsaá de tá quenda ndá nú nūū altar jíín jā sōcō nū nūū Yāā Dios, de tú nūcūhun inī nū jā ní nsāhá nú cuāchi sīquī táhán nú, ");
INSERT INTO mieNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","túsaá de squéndōo nú jā sōcō nū xiín altar, de xihna cā quīhīn nū jā ndumanī nū jíín táhán nú. De sá de ndicó cóo tucu nú jā sōcō nū. ");
INSERT INTO mieNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","De tú iin nchivī quīhīn ji jíín nú nūū justicia jā cāhān ji cuāchi sīquī nū, túsaá de juni cuāhān nū jíín ji ichi de sāhá ndāā maá nú jíín ji, tácua mā squívi ji ndóhó nūū juez. Chi juez siáha dē ndóhó nūū policía, de policía chihi dē ndóhó vecāa. ");
INSERT INTO mieNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","De ndāā cáhān ni jíín ndá nú jā má quēé cuitī nū ñúcuán chi jondē chunáá nú ndihi cuitī xūhún jā jícān ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Nī jini ndá nú tūhun jā ní ncāhān janahán jā má cásíquí ndéē tāhán nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sochi nduhū chi cáhān ni jíín ndá nú jā tú iin tēe ndéhé dē nūū iin ñahan jā ndíyo inī dē ña, ñúcuán de ja nī ncasíquí ndéē dē ñahan ñúcuán inī ánō dē. ");
INSERT INTO mieNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Túsaá de tú tīnūú lado cuáhá nú sáhá jā quīvi nú cuāchi, de vāha cā tavā nū de squéne nú, tácua mā sāhá cā nū cuāchi. Chi vāha cā jā naā iin tīnūú nú nsūú cā jā coo ndihi yiqui cúñu nú de quīhīn nū infierno. ");
INSERT INTO mieNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","De tú ndahá cuáhá nú sáhá jā quīvi nú cuāchi, de vāha cā quehndē nū de squéne nú, tácua mā sāhá cā nū cuāchi. Chi vāha cā jā naā iin ndahá nú nsūú cā jā coo ndihi yiqui cúñu nú de quīhīn nū infierno. ");
INSERT INTO mieNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","De suni nī ncāhān jondē janahán: Tú ní iin cúnī jā sndóo ñasíhí, de ná cuáha acta nūū ña jā ndusíín jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sochi nduhū chi cáhān ni jíín ndá nú, tú iin tēe sndóo dē ñasíhí dē, de tú nsūú jā ndiī ña, túsaá de sáhá dē jā casíquí ndéē ña jā cundeē ña jíín incā tēe. De tú iin tēe cueca dē ñahan jā ní nquendōo, suni cásíquí ndéē dē ña. ");
INSERT INTO mieNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","De suni nī jini ndá nú tūhun jā ní ncāhān jíín nchivī janahán: Tú nī ncāhān téyíí nú jā squíncuu nú, jínī jínúū Yāā Dios, túsaá de cánuú jā squíncuu nú jā ní ncāhān nū. ");
INSERT INTO mieNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sochi nduhū chi cáhān ni jíín ndá nú jā ni iin sīquī tiñu mā cáhān téyíí nú jondē jíín síví Yāā Dios. De tú cāhān téyíí nú de nduú vāha jā nacunehen nú andiví, chi suu cúu nūū íyó mesa nūū tátúnī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","De juni mā nácunehen nú ñayīví, chi suu cúu modo teyū nūū yósō jēhē yā. De juni mā nácunehen nú Jerusalén, chi suu cúu ciudad maá Yāā jā cúu Rey cúñáhnú. ");
INSERT INTO mieNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","De juni mā cáhān téyíí nú jā ná cúndeē cuāchi sīquī nū de tú nduú cáhān ndāā nū. Mā cáhān nū súcuán, chi mā cūú cuitī sāhá nú jā ni iin ixi xínī nū nducuíjín á ndutuún. ");
INSERT INTO mieNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Chi súcuán-ni cāhān nū: Cuu, cachī nū. Nduú, cachī nū. Chi tú chisó nú cā tūhun cāhān nū, de nūū tāchī vāji. ");
INSERT INTO mieNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nī jini ndá nú tūhun jā ní ncāhān jíín nchivī janahán: Tú iin tēe sndáhvā dē tīnūú táhán dē, de suni súcuán ná ndáhvā tīnūú maá dē. De tú iin tēe sndáva dē nūhun táhán dē, de suni súcuán ná ndáva nūhun maá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sochi nduhū chi cáhān ni jíín ndá nú: Mā nácuāha nú jā ndutahvī tēe jā sáhá nāvāha ndóhó. Chi tú ní tēe cani dē cūñu nuū lado cuáhá nú, de vāha cā suni cuāha nú incā lado cani dē, nsūú cā jā nacuāha nú jā ndutahvī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","De tú ní tēe stáyáhvi dē ndóhó de candeē dē camisa nū, de suni cuāha nú tūhun jā quīhīn dē jíín jondē sōō nū. ");
INSERT INTO mieNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","De tú ní tēe scáca dē ndóhó jā cuiso nú ndatíñú dē iin kilómetro, de caca nú ūū kilómetro jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","De nā-ni nchivī tú jícān ji ndatíñú nú, de cuāha nú nūū ji. De nchivī jícān nūú ndatíñú nú, de mā sásáhán nú jā cuāha nú nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","De suni nī jini ndá nú tūhun jā ní ncāhān jondē janahán: Cundáhví inī nū nchivī jā íyó mānī jíín nú, de quītī inī nū nūū nchivī jā jínī ūhvī ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sochi nduhū chi cáhān ni jíín ndá nú: Cundáhví inī nū nchivī jā jínī ūhvī ndóhó. De cācān táhvī nū jā váha cuu nchivī jā cáhān nāvāha sīquī nū. De sāhá vāha nú jíín nchivī jā quítī inī jínī ndóhó. De cācān táhvī nū jēhē nchivī jā cáhān nēhén nūū nū de sáhá xēēn ji ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","De súcuán stéhēn nū jā cúu nú sēhe maá Tatá nú, Yāā ndéē andiví, chi maá yā jéhe ncandiī jā cutūu nūū nchivī nēhén jíín nūū nchivī vāha. De jéhe yā sāvī nūū nchivī sáhá tiñu ndāā jíín nūū nchivī sáhá tiñu néhén. ");
INSERT INTO mieNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chi tú íyó mānī nū jíín maá-ni nchivī jā mānī jíín nú, de nduú nā tāhvī nīhīn nū nūū yā. Chi jondē ndá tēe stáhví jā stútú xūhún ñúū, suni súcuán sáhá ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","De tú maá-ni táhán nú cáhān vāha nú jíín, ¿de nā tiñu váha sáhá nú túsaá? Chi jondē nchivī jāá nduú cándíja Yāā Dios, suni súcuán sáhá ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Túsaá de ndāā ná cóo ndihi jā sáhá nú, tá cúu nūū íyó ndāā ndihi jā sáhá Tatá nú, Yāā ndéē andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","De jā sáhá nú ndācá tiñu váha nūū Yāā Dios, de coto nú jā má sāhá nijīn nū jā cunī nchivī de cuetúhún ji ndóhó. Chi tú súcuán sāhá nú, de nduú nā tāhvī nū cuāha maá Tatá nú, Yāā ndéē andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jā ñúcuán tá sáhá nú caridad, de mā sāhá nú jā cunī ndá nchivī, tá cúu nūū sáhá ndá tēe stáhví-ni, íñí dē nūū cúchitú nchivī inī ndá vehe īī sinagoga jíín nūū yáhvi. Chi súcuán sáhá ndá dē tácua cuetúhún nchivī dē. De ndāā cáhān ni jíín ndá nú jā ñúcuán-ni cúu tāhvī dē, suu jā jétúhún nchivī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sochi ndá ndóhó, tá sáhá nú caridad, de sāhá yuhū nū, tácua jondē amigo vāha nú mā cūní jā sáhá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Súcuán sāhá yuhū nū caridad. De maá Tatá nú jā ndéhé jā sáhá yuhū nū, iin quīvī de cuāha yā tāhvī cuu nú. ");
INSERT INTO mieNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","De tá jícān táhvī ndá nú, de mā sāhá nú tá sáhá ndá tēe stáhví-ni. Chi jétahān inī ndá dē cuiñi dē cācān táhvī dē nūū íyó chitú nchivī inī ndá vehe īī sinagoga jíín squínā calle, tácua cunī nchivī de cuetúhún ji dē. De ndāā cáhān ni jíín nú jā ñúcuán-ni cúu tāhvī dē, suu jā jétúhún nchivī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sochi ndá ndóhó, de tá jícān táhvī nū, de ndīvi nú inī vehe nú de nacasī nū viéhé. De cācān táhvī nū nūū maá Tatá nú, Yāā jā íyó yuhū jíín nú. Ñúcuán de maá Tatá nú jā jínī yā jā súcuán sáhá yuhū nū, cuāha yā jā jícān nū. ");
INSERT INTO mieNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","De jā jícān táhvī nū, de mā cáhān nū cuāhā vuelta ndá tūhun jāá nduú nácani inī nū de cáhān nū-ni, tá cúu nūū sáhá ndá nchivī jāá nduú jínī tūhun Yāā Dios. Chi jáni inī ji jā tú nahán súcuán cáhān ji, de cunini yā, de nduú. ");
INSERT INTO mieNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Túsaá de mā sāhá nú tá cúu nūū sáhá ndá ji. Chi maá Tatá nú ja jínī yā naá cúu jā jíni ñúhún nú jondē ncháha ca cācān nū nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Túsaá de suha cācān táhvī ndá nú: Tatá ndá sá jā ndéē ní andiví, níní ná cóo yíñúhún sá nūū ní, chi Yāā īī cúu ní. ");
INSERT INTO mieNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","De ñúhún inī sá jā ñamā ná quíji quīvī tatúnī ní níí ñayīví yáhá. De ná cóo ndācá tiñu jā jétahān inī maá ní, tá cúu nūū íyó inī andiví, suni súcuán ná cóo inī ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Stāā jā técū ndá sá ndācá quīvī, taji ní nūū sá mitan. ");
INSERT INTO mieNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","De cune cáhnú inī ní nūū cuāchi jā sáhá ndá sá nūū ní, tá cúu nūū née cáhnú inī ndá sá nūū nchivī jā sáhá cuāchi nūū sá. ");
INSERT INTO mieNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","De mā cuáha ní tūhun jā coto túnī tāchī sāán, chi sa scácu ní sāán nūū ndācá jānēhén. Chi maá ní cúu Yāā tátúnī, de tíin ní poder, de viī ndasí cúñáhnú ní níí cání. Súcuán ná cóo. Amén. Cachī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Chi tú cune cáhnú inī ndá nú nūū nchivī jā sáhá cuāchi nūū nū, de suni súcuán cune cáhnú inī maá Tatá nú andiví nūū cuāchi nú. ");
INSERT INTO mieNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sochi tú mā cúne cáhnú inī nū nūū nchivī jā sáhá cuāchi nūū nū, de suni súcuán mā cúne cáhnú inī maá Tatá nú nūū cuáchi nú. ");
INSERT INTO mieNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","De tá íyó nditē inī ndá nú jā chíñúhún nú Yāā Dios, de mā sāhá nú tá sáhá ndá tēe stáhví-ni. Chi sáhá ndá dē jā cáá xií nūū dē, de súcuán de stéhēn dē nūū nchivī jā íyó nditē inī dē, tácua cuetúhún ji dē. De ndāā cáhān ni jíín nú jā ñúcuán-ni cúu tāhvī dē, suu jā jétúhún nchivī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sochi ndá máá nú, tá íyó nditē inī nū de sa nasāhá vāha nú xīnī nū de quiti nuú nú, ");
INSERT INTO mieNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tácua mā cūní nchivī jā íyó nditē inī nū. Chi maá-ni Tatá nú jā ndéē yuhū yā jíín nú, cunī yā, de iin quīvī de cuāha yā tāhvī cuu nú. ");
INSERT INTO mieNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mā cúndihvī inī ndá nú jā scáyā nū ndatíñú jā cucuícá nú inī ñayīví yáhá, chi quívi tīquixīn, de néne xaha, de tíví. De suni quívi jācuīhná de sácuíhná. ");
INSERT INTO mieNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Chi sa sāhá nú ndācá tiñu váha tácua cāyā tāhvī nū jondē andiví. Chi ñúcuán mā quívi tīquixīn ni mā nēné xaha jā tīví, de ni mā cūú quīvi jācuīhná jā sacuíhná. ");
INSERT INTO mieNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Chi jondē nūū nīhīn nū tāhvī váha nú, ñúcuán cúu nūū ndíhvī inī nū sīquī. ");
INSERT INTO mieNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Tīnūú nú cúu tá cúu lámpara nūū yiqui cúñu nú. Túsaá de tú tīnūú nú íyó nijīn, de níí-ni yiqui cúñu nú cunijīn. ");
INSERT INTO mieNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sochi tú nduú íyó nijīn tīnūú nú, de níí-ni yiqui cúñu nú íyó neē. De suni súcuán cúu ánō nū, chi tú maá-ni jā jáni nēhén inī nū, de nācā neē cā íyó inī ánō nū túsaá. ");
INSERT INTO mieNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ni iin mozo mā cūú satíñú dē nūū ūū patrón. Chi quītī inī dē cunī dē iin de coo manī dē jíín incā, á squíncuu vāha dē nūū iin de sāhá jéhe inī dē nūū incā. De suni súcuán mā cūú satíñú nú nūū Yāā Dios de tú maá-ni sīquī xūhún ndíhvī inī nū. ");
INSERT INTO mieNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Túsaá de cáhān ni jíín ndá nú: Mā nácani ndasí inī nū sīquī jā cutecū nū, tú nāsa cajī nū coho nú, ni sīquī sahma, tú nāsa cuhun nú. Chi Yāā Dios nī nsāhá yā jā técū nū jíín yiqui cúñu nú, de nā oncā cúu jā má cuáha yā jā cajī nū jíín jā cuhun nú. ");
INSERT INTO mieNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cūndēhé ndá nú nāsa técū ndá saā, chi nduú jáquīn tī, de nduú nástútú tī jā chuvāha tī, de ni nduú yacā tī. De vísō súcuán de maá Tatá nú andiví scájī yā tī. ¿De á nduú cánuú ndasí cā ndá ndóhó nsūú cā ndá saā ñúcuán? ");
INSERT INTO mieNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿De ní iin nú, á cuu scuáhnu nú maá nú sava metro cā, vísō ná nácani ndasí inī nū? ");
INSERT INTO mieNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿De nūcu nácani ndasí inī ndá nú jā má níhīn nū sahma? Cūndēhé ndá nú nāsa jée ndá itā yucú. Chi nduú sátíñú, de ni nduú quéhen. ");
INSERT INTO mieNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","De cáhān ni jíín ndá nú jā juni rey Salomón, quīvī jā ní ñūhun dē sahma váha ndasí, de ni nduú ní ñúhún dē sahma viī súcuán tá cúu nūū íyó ndá itā. ");
INSERT INTO mieNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","De tú súcuán jéhe Yāā Dios sahma viī nūū itā yucú jā íyó nūū ñūhún mitan de teēn de cayū nūū ñúhūn, de nā oncā cúu ndá ndóhó jā má cuáha yā sahma. ¿De nūcu nduú cándíja nīhin ndá nú jā jíto yā ndóhó? ");
INSERT INTO mieNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Túsaá de mā nácani ndasí inī nū sīquī jā cajī nū, jā coho nú, jā cuhun nú. ");
INSERT INTO mieNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Chi maá-ni sīquī yáhá cúu jā ndíhvī inī nchivī ñayīví jāá nduú cándíja. Sochi ndá máá nú, chi íyó Tatá nú andiví, de jínī yā jā jíni ñúhún nú ndācá yáhá. ");
INSERT INTO mieNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","De sa cánuú cā jā cundihvī inī nū sīquī tiñu jā ndácu Yāā Dios nūū nū, jíín sīquī jā sāhá nú tiñu ndāā jā jétahān inī yā. Ñúcuán de sāhá yā jā nīhīn nū ndācá yáhá. ");
INSERT INTO mieNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Túsaá de mā nácani inī nū tú quiji tūndóhó teēn, chi mitan cúu mitan de teēn cúu teēn. Chi cani inī nū sīquī tūndóhó jā íyó tá iin iin-ni quīvī. ");
INSERT INTO mieNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mā cáhān ndá nú sīquī cuāchi nchivī nāsa sáhá ji, tácua suni mā cáhān Yāā Dios cuāchi sīquī maá nú jā sáhá nú súcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chi tá cúu nūū cáhān ndá nú sīquī cuāchi nchivī, suni súcuán cāhān yā sīquī cuāchi maá nú. De tá-ni ndíhvī inī nū sīquī cuāchi ji, saá-ni cundihvī inī yā sīquī cuāchi nú. ");
INSERT INTO mieNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Chi cuāchi táhán nú cúu modo jā ñúhún iin yācá lúlí tīnūú ji. ¿De nūcu sáhá nú cuenta jā súcuán, de nduú sáhá nú cuenta cuāchi maá nú jā cúu modo jā ñúhún iin vītū tīnūú máá nú? ");
INSERT INTO mieNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿De nūcu cáhān ndá nú jíín táhán nú: Ná távā ni yācá jā ñúhún tīnūú nú? De nduú nácani inī nū jā ñúhún iin vītū tīnūú máá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Vāchi tēe stáhví-ni cúu ndá nú túsaá. Xihna tīnūú maá nú tavā nū vītū, sá de cuu cūndēhé vāha nú jā tavā nū yācá tīnūú táhán nú. ");
INSERT INTO mieNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mā sāhá fuerza nū nchivī nēhén jā quīvi ji nūū tūhun īī yā de tú nduú cúnī ji. Chi nenda ji sīquī nū tá cúu tinā jā tíin tī ndóhó. De mā nácani nú tūhun yā nūū nchivī jāá nduú cúnī cuitī cuetáhví. Chi cúu ji tá cúu quinī jā jáñū tī sīquī perla jā ndéē yāhvi cā. ");
INSERT INTO mieNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Cācān nūū Yāā Dios, de taji yā nūū nū. De nducú nú ndācá jā váha jā íyó nūū yā, de nīhīn nū. De cācān táhvī nū jondē nīhīn nū, tá cúu nūū sáhá nchivī jā scáján viéhé jondē nune quīvi ji. ");
INSERT INTO mieNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chi ndācá nchivī jā jícān, cuāha yā nūū ji. De nchivī ndúcú, chi nīhīn ji. De nchivī cáhān, nune yā ichi jā nīhīn ji jā cúnī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿De ní iin nú, de tú sēhe nú jícān ji stāā nūū nū, de á cuāha nú iin yūū nūū ji? ");
INSERT INTO mieNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","De tú jícān ji iin tiacá, ¿de á cuāha nú iin cōō nūū ji? Nduú cuitī jā súcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Túsaá de ndá máá nú vísō nchivī íyó cuāchi cúu nú, de jínī nū cuāha nú jā váha nūū sēhe nú. De nā oncā cúu maá Tatá nú andiví jā má cuáha yā jā váha nūū nchivī jā jícān nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","De tá-ni cúu jā cúnī ndá nú jā sāhá vāha nchivī jíín nú, saá-ni sāhá vāha nú jíín ji. Chi súcuán tátúnī tutū ley Moisés jíín tutū ndá tēe nī nacani tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Cundihvī inī ndá nú quīvi nú ndahá Yāā Dios. Chi cúu tá cúu iin viéhé túū. Chi viéhé jíín ichi jā cuáhān nūū tānū tāhvī nchivī, jítē de cáhnú, de cuāhā ji quívi ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","De viéhé jíín ichi jā cuáhān nūū nīhīn táhvī ji cutecū ji, chi tūū viéhé de cuíñí ichi, de jacū ji-ni níhīn. ");
INSERT INTO mieNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","De mā cándíja cuitī nū ndá tēe stáhví jā cáhān dē jā tūhun Yāā Dios nácani dē. Chi modo tīcāchí, quiti jāá nduú xēēn, súcuán sáhá ndá dē vāji dē nūū nū. Sochi inī ánō dē chi cúu dē tá cúu yīhī, quiti xéēn. ");
INSERT INTO mieNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jíín tiñu sáhá ndá dē de cunī ndá nú nāsa tēe cúu dē. Chi cúu tá cúu ñutun jā jíín jāvíxī jā cúun de jínī ō tú ñutun váha cúu. De nduú níhīn ō uva xīnī ñutun íñú, de ni nduú níhīn ō higo xīnī iñu quími. ");
INSERT INTO mieNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Chi ndācá ñutun váha chi jéhe jāvíxī vāha, de ñutun néhén chi cúun jāvíxī nēhén. ");
INSERT INTO mieNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Iin ñutun váha mā cūún jāvíxī nēhén, de iin ñutun néhén mā cuáha jāvíxī vāha. ");
INSERT INTO mieNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","De ndācá ñutun jāá nduú jéhe jāvíxī vāha, chi tēhndē de cāyū nūū ñúhūn. ");
INSERT INTO mieNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","De saá-ni cúu ndá tēe ñúcuán, chi jíín tiñu sáhá dē de cunī nū nāsa tēe cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nsūú ndihi nchivī jā cáhān ji Jētohō ji nduhū cúu jā quīvi nūū tátúnī Tatá nī jondē andiví. Chi jā quīvi cúu maá-ni nchivī jā squíncuu tiñu jā cúnī Tatá nī andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","De quīvī jā sāhá ndāā ni tiñu nchivī, de cuāhā ji cāhān jíín nī: Jētohō ndá sá, jíín síví ní nī nacani ndá sá tūhun ní, de jíín síví ní nī ntavā sá tāchī, de jíín síví ní nī nsāhá sá cuāhā tiñu ñáhnú jā sáhvi inī nchivī sáhá. Cachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ñúcuán de cāhān ni jíín ji: Nduú jínī cuitī ni ndá nú. Cujiyo quīhīn nū, chi nchivī sáhá tiñu néhén cúu nú, cachī ni. ");
INSERT INTO mieNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Túsaá de ndācá nchivī jā jíni tūhun cáhān ni de squíncuu ji, cúu ji tá cúu iin tēe jā ní nacani vāha inī, de nī jaquīn dē vehe dē sīquī toto. ");
INSERT INTO mieNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","De nī ncuun sāvī, de nī ndaa ndute yúte, de nī nquene tāchī xéēn, de nī nchindahá vehe ñúcuán. Sochi nduú ní jícó cáva, chi sīquī toto yósō. ");
INSERT INTO mieNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","De ndá nchivī jā jíni tūhun cáhān ni de nduú squíncuu ji, cúu ji tá cúu iin tēe naā jā ní jaquīn dē vehe dē nūū ñūtín. ");
INSERT INTO mieNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","De nī ncuun sāvī, de nī ndaa ndute yúte, de nī nquene tāchī xéēn, de nī nchindahá vehe ñúcuán. De nī jicó cáva-ni, de nī naā īī-ni, ncachī Jesús jíín ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","De tá nī jīnu nī ncāhān yā ndācá tūhun yáhá, de nchivī cuāhā ñúcuán nī nsāhvi inī ji nī jini ji tūhun jā ní stéhēn yā. ");
INSERT INTO mieNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Chi nī stéhēn vāha yā nūū ji, chi maá yā cúu jā ndíso tíñú sīquī ndihi. De ndá tēe jā stéhēn ley janahán, nsūú súcuán stéhēn ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","De nī nuu Jesús yucu ñúcuán, de cuāhā nchivī níquīn ji yā. ");
INSERT INTO mieNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","De iin tēe ndóho cuēhē stéhyū, nī nquenda dē nūū yā. De nī jēcuīñī jītí dē nūū yā, de nī ncāhān dē jíín yā: Señor, jínī sá jā cuu sāhá ní jā nduvāha sá, de tú cúnī ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","De Jesús nī ntee yā ndahá yā dē, de nī ncāhān yā: Cúnī ni nasāhá vāha nī ndóhó. De ná ndúvāha nú, ncachī yā. De tá nī ncāhān yā súcuán, de nī nduvāha-ni tēe ndóho cuēhē stéhyū. ");
INSERT INTO mieNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ñúcuán de nī ncāhān yā jíín dē: Mā cāchí cuitī nū nūū ni iin. Chi quīhīn nū stéhēn nū maá nú nūū sūtū, de cundahá nú jā sōcō nū nūū Yāā Dios, tá cúu nūū ní ntatúnī Moisés janahán, tácua cunī nchivī jā ní nduvāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","De nī nquīvi Jesús ñuū Capernaum. De iin tēe nación Roma jā cúu capitán, nī nquenda dē nūū yā, de nī ncāhān ndāhví dē jíín yā: ");
INSERT INTO mieNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Señor, mozo sá cáá ji vehe sá, chi nī nduvehlé ji de ndóho ndasí ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","De nī ncāhān Jesús: Cōhōn de nasāhá vāha nī ji túsaá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","De nī ncāhān capitán jíín yā: Señor, nduú cúñáhnú sá jā quíhīn ní quīvi ní vehe sá. Chi maá jā cāhān ní-ni, de ná ndúvāha-ni mozo sá. ");
INSERT INTO mieNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Chi maá sá suni ndíso tíñú sá jā ní nsāhá ndá tēe cúñáhnú cā. De cúñáhnú sá nūū ndācá soldado sá. De tú cāhān sá jíín iin dē jā quíhīn dē, de cuāhān dē. De tú cāhān sá jíín incā dē jā quiji dē, de quíji dē. De tú ndacu sá iin tiñu nūū mozo sá, de sáhá ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","De tá nī jini Jesús tūhun yáhá, de nī nsāhvi inī yā. De nī ncāhān yā jíín ndá nchivī jā níquīn ji yā: Ndāā cáhān ni jíín ndá nú jā juni nación maá ó Israel nduú ní níhīn ni ni iin nchivī jā cándíja nīhin súcuán, tá cúu nūū cándíja tēe yáhá, vísō tēe incā nación jāá nduú jínī tūhun Yāā Dios cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","De cáhān ni jíín ndá nú jā quiji cuāhā nchivī ichi nūū quénda ncandiī jíín ichi nūū quée ncandiī. De cundeē ji cajī ji stāā jíín Abraham jíín Isaac jíín Jacob nūū tátúnī Yāā Dios jondē andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sochi sava nchivī nación Israel jā maá ji quīvi nícu, sa tavā yā ji quīhīn ji nūū neē, chi nduú ní ncándíja ji. De ñúcuán cuacu ji de nacayīhí ji ñii yúhú ji jā ndoho ndasí ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ñúcuán de nī ncāhān yā jíín tēe cúu capitán: Cuánohōn vehe nú, chi sāhá nī tá cúu nūū cándíja nú jā sāhá nī. De mozo dē nī nduvāha ji-ni maá hora ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","De nī jēhēn Jesús vehe Pedro. De nī jinī yā naná chíso dē jā cáá ña yíhí quīji ña. ");
INSERT INTO mieNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","De nī ntiin yā ndahá ña, de nī nquee-ni quīji ña. De nī nacōo ña-ni, de nī nsāhá ña jā ní nchajī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","De tá nī ncuaā de nī nquenda ndá nchivī jíín cuāhā nchivī jā ñúhún tāchī inī. De nī ntavā yā ndá tāchī cuāhān jíín tūhun jā cáhān yā-ni. De suni nī nasāhá vāha yā ndācá nchivī cúhū. ");
INSERT INTO mieNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","De súcuán nī ncuu tácua quee ndaā tūhun jā ní ncāhān Isaías, tēe nī nacani tūhun Yāā Dios janahán: Maá yā nī ncandeē ndācá nūū cuēhē jā ndóho ó, ncachī Isaías. ");
INSERT INTO mieNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","De nī jinī Jesús jā ní jicó ndúū cuāhā nchivī yā. De nī ncāhān yā jíín ndá tēe scuáha jíín yā jā ná yáha ndá dē jíín yā incā lado mar. ");
INSERT INTO mieNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","De iin tēe stéhēn ley janahán nī nquenda dē nūū yā, de nī ncāhān dē: Maestro, cuniquīn sá ní cōhōn ní-ni cúu nūū quíhīn ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","De nī ncāhān Jesús jíín dē: Ndācá xúncuii chi íyó yavī cava tī, de ndá saā suni íyó tacā tī. Sochi maá nī, Yāā nī nduu tēe, nduú nūū cūsūn ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","De incā tēe nī ncāhān dē jíín yā, de tēe scuáha jíín yā cúu dē: Señor, cundetū ní de ná quíchiyuhū sá tatá sá xihna cā. Sá de cuniquīn sá níhín, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","De nī ncāhān Jesús jíín dē: Cuniquīn nduhū ná cóhōn. De sndóo ndá ndīyi ná chúhū ndá cā ndīyi, chi ndīyi cúu ndá nchivī jāá nduú cándíja, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ñúcuán de nī nquīvi Jesús inī barco, de ndá tēe scuáha jíín yā nī nquīvi dē cuāhān dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","De nūū mar nī jīquīhi iin tāchī níhin, de nī scáa ndute mar, de nī nquīvi inī barco. De maá Jesús chi quíxīn yā. ");
INSERT INTO mieNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","De ndá tēe scuáha jíín yā nī sndóto dē yā, de nī ncāhān dē: Señor, scácu ní yóhó, chi quēe ó chījin ndute, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","De nī ncāhān yā jíín ndá dē: ¿Nūcu yúhú ndasí ndá nú? De nduú cándíja nīhin nú jā cācu nú sāhá nī, ncachī yā. Ñúcuán de nī nacuiñī yā, de nī ncāhān yā nūū tāchī níhin jíín nūū mar. De nī ncuu nañíí-ni. ");
INSERT INTO mieNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","De nī nsāhvi inī ndá dē, de nī ncāhān dē: ¿Nā tēe cúu tēe yáhá, jā jondē tāchī níhin jíín mar jétáhví jā cáhān dē? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","De nī nquenda yā incā lado mar, maá región nchivī Gadara. De ūū tēe nī nquee dē jondē nūū yíyuhū ndīyi, nī jēcutáhán dē jíín yā. De ñúhún tāchī inī dē, de sīquī jā xēēn ndasí ndá tāchī, de ni iin nchivī nduú cúu yāha ji ichi ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","De nī ncana cóhó ndúū dē nī nsāhá tāchī: ¿Nūcu vāji ní nūū sá, Jesús Sēhe Yāā Dios? ¿A vāji ní yáhá jā sndóho ní sāán jondē ncháha ca quenda maá quīvī? ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","De jondē jícá jacū ñúhún cuāhā quinī jítu tī. ");
INSERT INTO mieNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","De ndá tāchī jā ñúhún inī ndúū tēe ñúcuán, nī ncāhān ndāhví jíín yā: Tú tavā ní ndá sá, de cuāha ní tūhun jā quīvi sá inī ndá quinī ñúcuán, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","De nī ncāhān yā jíín: Cuáhán túsaá, ncachī yā. De nī nquee ndá tāchī inī ndúū tēe ñúcuán, de nī nquīvi inī ndá quinī. De ndá quinī nī jinu tī de nī nincava tī iin yuhú cává, de nī nquēe tī ndute mar, de nī jīhī tī. ");
INSERT INTO mieNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","De ndá tēe jíto tī nī jinu dē cuāhān dē jā ní nchūhú dē. De nī nquenda ndá dē ñuū, de nī ncachī tūhun dē ndá tiñu ñúcuán, nāsa nī ncuu jā ní nquee ndá tāchī inī ndúū tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Sá de ndihi nchivī ñuū nī nquee ji cuāndēhé ji nūū íyó Jesús. De tá nī nquenda ji nūū íyó yā, de nī ncāhān ndāhví ji jíín yā jā ná quée yā región ñúcuán quīhīn yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ñúcuán de nī ndīvi Jesús inī barco. De nī nayāha yā cuāhān yā incā lado mar, de nī nenda yā ñuū maá yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","De nī nquisiáha nchivī iin tēe nī nduvehlé nūū yā, yósō dē nūū iin camilla. De nī jinī Jesús jā cándíja ndá ji jā cuu nasāhá vāha yā tēe nī nduvehlé. De nī ncāhān yā jíín dē: Ndundeé inī nū lílū, chi ja née cáhnú inī ni nūū ndá cuāchi nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ñúcuán de jacū tēe stéhēn ley janahán, nī jani inī ndá dē sīquī yā: Jā cáhān tēe yáhá súcuán, de cáhān dē tūhun nāvāha jā quītī inī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","De nī jinī Jesús jā súcuán jáni inī ndá dē, de nī ncāhān yā jíín dē: ¿Nūcu jáni nēhén inī ndá nú jā cáhān ni tūhun nāvāha? ");
INSERT INTO mieNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Jā ndúū tūhun yáhá, ¿ní iin cúu jā víjín cā? ¿A jā cāhān ni jíín tēe cúhū: Ja née cáhnú inī ni nūū ndācá cuāchi nú? ¿A víjín cā jā cāhān ni: Nacōo de caca nú, chi ja nī nduvāha nú, cachī ni? ");
INSERT INTO mieNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","De mitan de ná stéhēn ni jā maá nī, Yāā nī nduu tēe, ndíso tíñú nī inī ñayīví yáhá jā cune cáhnú inī ni nūū cuáchi. Sá de nī ncāhān yā jíín tēe nī nduvehlé: Nacōo de naquehen nú camilla nū de quīnohōn nū vehe nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ñúcuán de nī nacōo dē-ni, de cuānohōn dē vehe dē. ");
INSERT INTO mieNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","De tá nī jinī ndá nchivī jā súcuán nī nsāhá yā, de nī nchūhú ji. De nī ncāhān ji jā vāha ndasí Yāā cúu Yāā Dios jā súcuán nī jēhe yā poder nūū iin tēe jā cuu nasāhá vāha dē nchivī, cáchī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","De nī nquee Jesús ñúcuán cuāhān yā. De nī jinī yā nūū iin tēe nání Mateo, ndéē dē nūū nástútú dē xūhún renta. De nī ncāhān yā jíín dē: Cuniquīn nduhū ná cóhōn. De nī nacuiñī dē, de cuāhān dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ñúcuán de nī jēhēn yā nī nchajī yā stāā vehe dē. De cuāhā tēe stútú xūhún renta jíín ndá cā tēe jā sáhá cuāchi, suni ndéē ndá dē yájī dē stāā jíín Jesús jíín ndá tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","De ndá tēe grupo fariseo nī jinī dē, de nī ncāhān dē jíín ndá tēe scuáha jíín yā: ¿Nūcu yájī maestro nū jíín ndá tēe stútú xūhún renta jíín ndá cā tēe sáhá cuāchi? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","De nī jini Jesús, de nī ncāhān yātá yā jíín ndá dē: Ndá nchivī íyó vāha, nduú jíni ñúhún ji tēe tátán, chi nchivī cúhū cúu jā jíni ñúhún. ");
INSERT INTO mieNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cuáhán ndá nú túsaá, de nacani inī nū nā cuá cúu jā cáhān tūhun yáhá jā yósō nūū tutū īī: Cúnī ni jā cundáhví inī ndá nú táhán nú, nsūú jā sōcō nū ndá quiti nūū ni, ncachī Yāā Dios jondē janahán. De nduhū chi nduú vāji nī jā cana nī nchivī jāá nduú cuāchi, jā cúu tá cúu nchivī íyó vāha, chi sa vāji nī jā cána nī nchivī íyó cuāchi, jā ná nácani inī ji de sndóo ji cuāchi ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ñúcuán de ndá tēe scuáha jíín Juan tēe scuénduté, nī nquenda dē nūū Jesús. De nī ncāhān ndá dē jíín yā: Sāán jíín ndá tēe fariseo, cuāhā vuelta íyó nditē inī ndá sá nūū Yāā Dios. De ndá tēe scuáha jíín maá ní, ¿nūcu nduú sáhá dē súcuán? ");
INSERT INTO mieNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","De nī ncāhān Jesús jíín dē: ¿A cuu conditē inī ndá dē juni íyó cā ni jíín dē? ¿A cuu cucuécá inī nchivī jā íyó vico tándāhá juni ndéē tēe tándāhá jíín ji? Sochi quiji quīvī jā cujiyo tēe tándāhá, de quīvī ñúcuán chi conditē inī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","De nī ncāhān yā ūū tūhun yátá sīquī jāá nduú quétáhán tūhun jeé jā stéhēn yā jíín ndá tūhun janahán. Ncachī yā: Ni iin nduú náchuhun iin pedazo sahma jéé nūū iin sahma túhú. Chi tú súcuán de ndiyi pedazo jeé de tēhndē cā jā tūhú, de cundícā cā nūū tēhndé. ");
INSERT INTO mieNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","De ni nduú chúhun vino jeé inī ñii túhú. Chi tú súcuán de ndātā ñii, de naā vino jíín ñii. Chi sa cánuú jā chuhun ji vino jeé inī ñii jéé, de súcuán de quendōo vāha ndúū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","De juni cáhān Jesús ndācá tūhun yáhá, de iin tēe cúñáhnú nūū nchivī hebreo nī nquenda dē nūū yā. De nī jēcuīñī jītí dē nūū yā, de nī ncāhān dē: Sēhe síhí sá, cáta nī jīhī ji. De á mā cóhōn de tee ní ndahá ní ji, de natecū ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","De nī nacuiñī Jesús, de cuāhān yā jíín dē, de suni cuāhān ndá tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","De māhñú ndá nchivī jā cuáhān jíín yā nī nquenda iin ñahan cúhū, de ja nī ncuu ūxī ūū cuīyā ndóho ña cuēhē játi nīñī ña. De nī nquenda ña ichi chátā yā, de nī nquehé ña yuhú sáhmá yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Chi nī jani inī ña: Vísō sahma yā ná níhīn ni quehé nī, de nduvāha nī. ");
INSERT INTO mieNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","De nī jicó cóto Jesús, de nī jinī yā nūū ña, de nī ncāhān yā: Ná ndúndeé inī nū tíhī. Chi nī ncandíja nú jā cuu nasāhá vāha nī ndóhó, de jā ñúcuán nī nduvāha nú, ncachī yā. De nī nduvāha ña maá hora ñúcuán-ni. ");
INSERT INTO mieNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","De tá nī nquenda Jesús vehe tēe cúñáhnú, de nī jinī yā nūū ndá tēe cúu músico jā quíchuhū dē ndīyi, jíín nūū nchivī cuāhā, jácu cóhó ji. ");
INSERT INTO mieNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","De nī ncāhān yā jíín ji: Cujiyo ndá nú, chi ñahan lúlí ñúcuán nduú ní jíhī ji, chi quíxīn ji-ni, ncachī yā. De nī jācū catá ndá ji jā ní ncāhān yā, chi jínī ji jā ní jīhī sūchí ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","De nī ntavā yā ndá nchivī cuāhā, de nī nquīvi yā inī vehe. De nī ntiin yā ndahá ñahan lúlí ñúcuán, de nī natecū ji, de nī nacuiñī ji-ni. ");
INSERT INTO mieNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","De níí región ñúcuán nī jītē nuu tūhun tiñu ñáhnú jā ní nsāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","De nī nquee Jesús ñúcuán cuāhān yā. De ūū tēe cuáá cuāhān dē yātā yā, de cána jee dē: Maá ní jā cúu ní Sēhe tatā David, cundáhví inī ní sāán viī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","De tá nī nquenda yā vehe, de nī nquenda ndúū tēe cuáá ñúcuán nūū yā. De nī ncāhān yā jíín dē: ¿A cándíja ndúū nū jā cuu nacune nī tīnūú nú? ncachī yā. De nī ncachī ndúū dē: Cándíja sá Señor, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ñúcuán de nī ntee yā ndahá yā tīnūú ndúū dē, de nī ncāhān yā: Ná sáhá nī tá cúu nūū cándíja ndúū nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","De nī nune-ni tīnūú ndúū dē. De Jesús nī ncāhān nīhin yā jíín dē: Mā cāchí cuitī nū nūū ni iin, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sochi tá nī nquee ndúū dē, de nī scútē nuu dē tūhun níí región ñúcuán jā súcuán nī nsāhá yā ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","De tá nī nquee ndúū tēe ñúcuán cuāhān dē, de nī nquenda ndá nchivī jíín iin tēe ñíhín jā ñúhún tāchī inī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","De nī ntavā yā tāchī cuāhān. De tēe ñíhín nī nacahān dē. De nī nsāhvi inī nchivī nī jinī ji, de nī ncāhān ndá ji: Ncháha ca cunī cuitī ō ni iin tiñu súcuán inī nación Israel, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sochi ndá tēe grupo fariseo chi nī ncāhān dē: Tēe yáhá chi távā dē tāchī jíín fuerza maá tāchī cúñáhnú cā, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","De nī jica nuu Jesús ndācá ñuū jíín rancho, de nī stéhēn yā tūhun inī ndācá vehe īī sinagoga. De nī nacani yā tūhun vāha nāsa tátúnī Yāā Dios. De nī nasāhá vāha yā nchivī cúhū nā-ni cuēhē ndóho ji. ");
INSERT INTO mieNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","De nī ncundáhví inī yā nī ndēhé yā ndá nchivī cuāhā ñúcuán. Chi ndóho ndá ji de cúcuécá inī ji, chi cúu ji tá cúu tīcāchí jāá nduú jētohō tī, chi nduú níquīn ji Yāā jā cúu Jētohō ji. ");
INSERT INTO mieNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ñúcuán de nī ncāhān yā jíín ndá tēe scuáha jíín yā: Nchivī yáhá cúu ji tá cúu trigo jā tēhndē, de ndāā jā cuāhā cúu, de tēe quehndē chi jacū dē-ni cúu. ");
INSERT INTO mieNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Túsaá de cācān táhvī ndá nú nūū maá Jētohō nū Yāā Dios jā ná tétíñú yā cuāhā tēe quehndē dē trigo, de suu cúu jā nacani dē tūhun yā nūū nchivī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ñúcuán de nī ncana yā ūxī ūū tēe jā scuáha dē jíín yā. De nī jēhe yā poder nūū ndá dē jā tavā dē ndá tāchī inī nchivī, jíín jā nasāhá vāha dē nchivī cúhū ndācá nūū cuēhē. ");
INSERT INTO mieNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","De yáhá cúu síví ndihúxī ūū tēe apóstol: Tēe xíhna ñúhún cúu Simón jā suni nání Pedro, jíín ñanī dē Andrés. De ūū cā dē cúu sēhe Zebedeo, de nání dē Jacobo jíín Juan. ");
INSERT INTO mieNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ñúcuán de Felipe, Bartolomé, Tomás, Mateo tēe nī stútú xūhún renta, Jacobo sēhe Alfeo, jíín Lebeo jā suni nání Tadeo, ");
INSERT INTO mieNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","jíín Simón tēe grupo cananista, jíín Judas Iscariote, tēe jā ní nastúu dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","De nī ntají Jesús ndihúxī ūū tēe yáhá jā quíhīn dē. De nī ndacu yā tiñu nūū dē nāsa sāhá dē: Mā quíhīn ndá nú nūū nchivī jāá nsuú nchivī maá ó hebreo cúu, de ni mā quívi nú ndācá ñuū nchivī Samaria. ");
INSERT INTO mieNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Chi nūū maá-ni nchivī nación maá ó Israel quīhīn ndá nú, chi cúu ji tá cúu tīcāchí jā ní nsana. ");
INSERT INTO mieNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","De jā quíhīn ndá nú de suha nacani nú tūhun: Ja nī ncuñatin Yāā ndéē andiví jā tatúnī yā nūū nū, cachī nū. ");
INSERT INTO mieNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","De nasāhá vāha nú nchivī ndóho cuēhē stéhyū jíín jā ndóho ndá cā cuēhē, de nastécū nū ndīyi, de tavā nū tāchī inī nchivī. De súcuán-ni nī ntaji nī poder nūū ndá nú jā sāhá nú, de suni súcuán-ni nasāhá nú jíín ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","De mā cuīsó nú xūhún oro ni xūhún plata ni xūhún cuáchí. ");
INSERT INTO mieNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","De ni mā cuīsó nú ñunu stáā cajī nū ichi, ni incā camisa, ni nījān, ni garrote. Chi sīquī tiñu jā nácani ndá nú tūhun nūū nchivī, de cánuú jā coto ji ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","De nā-ni ñuū á rancho tá quenda ndá nú, de ñúcuán nducú nú iin nchivī vāha, de cundeē nū vehe ji jondē quīhīn tucu nú. ");
INSERT INTO mieNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","De tá quīvi nú vehe nchivī ñúcuán, de cāhān nū jā ná quíji tūhun ndeé tūhun sīī inī nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","De tú nchivī vāha cúu ji, de tūhun ndeé jā ní ncāhān nū ná quéndōo sīquī ji. De tú nsūú nchivī vāha cúu ji, de tūhun ndeé jā ní ncāhān nū mā quéndōo sīquī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","De tú íyó nchivī jāá nduú jétáhví ji ndóhó, de ni nduú cúnī ji cunini ji tūhun cáhān nū, túsaá de quee nú vehe ñúcuán á ñuū ñúcuán, de scóyo nú tīcāchāā jēhē nū, chi suu cúu jā stéhēn nū jā íyó cuāchi ji jāá nduú ní jétáhví ji. ");
INSERT INTO mieNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","De ndāā cáhān ni jíín ndá nú jā quīvī juicio de xēēn cā coo castigo sīquī ndá ñuū jā sáhá súcuán nsūú cā sīquī ñuū Sodoma jíín ñuū Gomorra nūū ní nsāhá ndasí nchivī cuāchi. ");
INSERT INTO mieNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Cūndēhé ndá nú, chi tetíñú nī ndóhó quīhīn nū tá cúu tīcāchí māhñú yīhī. Túsaá de coo listo nū tá cúu cōō, de coo vitá inī nū tá cúu paloma. ");
INSERT INTO mieNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","De coto ndá nú maá nú nūū nchivī, chi quenda quīvī jā quīsiáha ji ndá nú nūū junta, de inī ndá vehe īī sinagoga cani ji ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","De suni jondē nūū ndá gobernador jíín ndá rey quīnasiáha ji ndóhó jā síquī nduhū. De súcuán de nune ichi jā nacani nú tūhun nī nūū ndá dē jíín nūū nchivī ndācá nación jāá nduú jínī tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","De tá nī nsiáha ji ndóhó nūū ndá tēe ñúcuán, de mā nácani ndasí inī nū nāsa cāhān nū. Chi maá hora ñúcuán de maá yā stéhēn nūū nū nāsa cāhān nū. ");
INSERT INTO mieNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Chi nsūú ndá máá nú cúu jā cāhān, chi Espíritu maá Tatá nú cúu jā cāhān jíín yuhú nú. ");
INSERT INTO mieNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","De sava nchivī jāá nduú cándíja, nastúu ji ñanī ji jā ná cúū. De tatá nastúu sēhe. De sēhe nenda sīquī tatá jíín naná jā ná cúū. ");
INSERT INTO mieNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","De ndihi nchivī quītī inī ji nūū nū jā síquī nduhū. Sochi nchivī jā cuiñi nīhin jondē jīnu tūndóhó, nchivī ñúcuán chi cācu ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","De tú iin ñuū jínī ūhvī ji ndóhó, de cunu nú quīhīn nū incā ñuū. Chi ndāā cáhān ni jíín nú jā jondē ncháha ca caca nuu nú ndihi ñuū nación maá ó Israel, de nenda-ni maá nī, Yāā nī nduu tēe. ");
INSERT INTO mieNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Iin tēe scuáha, nduú cúñáhnú cā dē nsūú maestro dē. De ni tēe cúu mozo, nduú cúñáhnú cā dē nsūú patrón dē. ");
INSERT INTO mieNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Chi tēe scuáha, tá cúu nūū ndóho maestro dē, suni súcuán cundoho nahñí dē, de tēe cúu mozo suni cundoho dē tá cúu nūū ndóho patrón dē. Túsaá de tú nduhū cáhān ndá ji jā Satanás cúu nī, de nā oncā cúu ndá ndóhó jā má cáhān ji jā cúu nú Satanás. ");
INSERT INTO mieNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Túsaá de mā cúyūhú ndá nú jā sāhá nchivī ndóhó. Chi ndācá tūhun jā cáhān yuhū ji mā quéndōo yuhū cuitī, chi ndihi natūu nijīn, de cunī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ndá tūhun jā ní ncāhān ni jíín nú jāá nduú ní jínī nchivī, nacachī tūhun cájí nú nūū ji. De tūhun jā ní nacani yuhū ni nūū nū, nacani jee nú yātā ndācá vehe. ");
INSERT INTO mieNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","De mā cúyūhú ndá nú nchivī jā cahnī ji yiqui cúñu nú, chi mā cūú cahnī ji ánō nū. Chi sa jā cuyūhú nú cúu jā má stíví nú nūū Yāā Dios, chi cuu stánū tāhvī yā ndóhó jā quīvi ánō nū jíín yiqui cúñu nú infierno. ");
INSERT INTO mieNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","De ndá saā chi nduú yāhvi ndéē tī, chi jondē ūū tī jā iin xūhún lúlí. De ni iin tī nduú níncava tī nūū ñūhún de tú nduú jéhe Tatá nú tūhun, chi jíto yā tī. ");
INSERT INTO mieNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","De nā oncā cúu ndá máá nú, chi jondē ndihi ixi xínī nū ja nī ncahvi yā. ");
INSERT INTO mieNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Túsaá de mā cúyūhú ndá nú, chi cánuú ndasí cā ndá máá nú nūū yā nsūú cā cuāhā ndá saā. ");
INSERT INTO mieNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","De ndācá nchivī jā cuetúhún nduhū nūū incā nchivī, suni súcuán cuetúhún nī ji nūū Tatá nī, Yāā ndéē andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","De ndācá nchivī jā má cuétúhún nduhū nūū incā nchivī, suni súcuán mā cuétúhún nī ji nūū Tatá nī, Yāā ndéē andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mā cāní inī ndá nú jā váji nī jā cundeē mānī nchivī ñayīví. Nduú vāji nī jā cundeē mānī nchivī, chi sa canāá ji jā síquī nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Chi jā síquī nduhū de cusíín inī sēhe yií jíín tatá, de sēhe síhí jíín naná, de sēhe jānú jíín naná chíso. ");
INSERT INTO mieNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Chi ndācá nchivī jā candíja nduhū, chi maá táhán vehe ji cúu jā quītī inī nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","De tú ní iin nchivī mānī cā ji jíín tatá ji á naná ji nsūú cā nduhū, de nsūú nchivī vāha cúu ji jā cuniquīn ji nduhū. De tú ní iin nchivī mānī cā ji jíín sēhe yií ji á sēhe síhí ji nsūú cā nduhū, de suni nsūú nchivī vāha cúu ji jā cuniquīn ji nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","De nā-ni nchivī tú nduú jéhe ji tūhun jā cundoho ji tūndóhó vísō jondē cuū ji jā síquī jā cuniquīn ji nduhū, de nsūú nchivī vāha cúu ji jā cuniquīn ji nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","De tú ní nchivī cúnī ji cācu ji nūū tūndóhó jā quiji nūū ji jā síquī nduhū, túsaá de tānū tāhvī ji níí cání. De tú ní nchivī vísō ná cúū ji jā síquī nduhū, sochi cutecū ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","De nchivī jā jétáhví ndá ndóhó, túsaá de nduhū jétáhví ji. De nchivī jā jétáhví nduhū, jétáhví ji Yāā jā ní ntají nduhū vāji nī. ");
INSERT INTO mieNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tú nā-ni nchivī cuetáhví ji iin tēe nácani tūhun Yāā Dios, sīquī jā jíca dē tiñu Yāā Dios, túsaá de inuú-ni coo tāhvī ji nūū Yāā Dios jíín tēe nácani tūhun yā. De tú nā-ni nchivī cuetáhví ji iin tēe ndāā, sīquī jā tēe ndāā cúu dē, túsaá de inuú-ni coo tāhvī ji nūū Yāā Dios jíín tēe ndāā. ");
INSERT INTO mieNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","De tú ní nchivī cuāha ji vísō iin ñajin ndute víjin coho iin sūchí yáhá, sīquī jā cúu ji sūchí cándíja nduhū, de jāndáā ndija cúu jā nīhīn ji tāhvī ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","De tá nī jīnu nī ndacu Jesús tiñu nūū ndihúxī ūū tēe scuáha jíín yā, de nī nquee yā ñúcuán cuāhān yā jā stéhēn yā de nácani yā tūhun ndá ñuū región ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","De yíhí Juan vecāa. De nī nīhīn dē tūhun ndācá tiñu jā sáhá Cristo. De nī ntají dē ūū tēe jā scuáha jíín dē, ");
INSERT INTO mieNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","cuācātūhún dē yā: ¿A maá ní cúu Cristo jā cáchī tutū jā quiji, á cundetu ó incā tēe jā quiji? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","De nī ncāhān yā jíín dē: Cuáhán de cachī tūhun ndúū nū nūū Juan ndācá tiñu jínī nū jíín tūhun jíni nú. ");
INSERT INTO mieNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","De cachī nū jā nchivī cuāá núne tīnūú ji, de nchivī cojo nácaca ji, de nchivī ndóho cuēhē stéhyū ndúvāha ji, de nchivī sōhó núne sōho ji, de nchivī jíhī nátecū ji sáhá nī. De suni nácani nī tūhun nūū nchivī ndāhví jā scácu Yāā Dios ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","De nācā ndetū tēe jā má nácani yátá inī dē jā nduhū cúu Cristo. Súcuán cachī nū nūū Juan, ncachī yā jíín ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","De tá cuāhān ndúū tēe ñúcuán, de nī nquijéhé Jesús cáhān yā tūhun Juan jíín nchivī: ¿Nā cuá cúu jā ní jēndēhé ndá nú jondē nūū ñuhun tíhá? ¿A iin tēe jáni iin jáni ūū inī jā cúu tá cúu itē jā cándā sáhá tāchī? ");
INSERT INTO mieNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","De tú nduú, ¿de nā cuá cúu jā ní jēndēhé ndá nú túsaá? ¿A iin tēe jā cúnī cuñáhnú jā ñúhún sahma fino? Nduú, chi jínī ndá nú jā tēe ñúhún sahma fino, níí maá-ni inī vehe rey ndéē ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿De nā cuá cúu jā ní jēndēhé ndá nú túsaá? ¿A iin tēe nácani tūhun Yāā Dios? Cáhān ni jíín ndá nú jā suu nī jēndēhé nú, de cúñáhnú cā Juan yáhá nsūú cā ndá cā tēe jā ní nacani tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Chi tūhun Juan cúu jā yósō nūū tutū īī: Tají nī tēe nacani tūhun nī, cosō nūú dē ichi núū Cristo, tácua coo tūha nchivī jā quenda yā. Ncachī Yāā Dios, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","De ndāā cáhān ni jíín nú jā inī ñayīví yáhá cúñáhnú cā Juan tēe scuénduté nsūú cā ndá cā tēe jā ní īyo inī ñayīví. De vísō súcuán de ndācá nchivī jā núu cā inī ñuū nūū tátúnī Yāā andiví, cúñáhnú cā ji nsūú cā Juan. ");
INSERT INTO mieNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","De jondē quīvī jā ní nquenda Juan tēe scuénduté, de jondē mitan, chi ndúcú ndéé ndá nchivī jā quīvi ji ñuū nūū tátúnī Yāā andiví. De jondē nchivī xēēn ndúcú ndéé ji sīquī. ");
INSERT INTO mieNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Chi jondē ncháha ca quiji Juan, de nī īyo maá tutū ley Moisés, jíín ndá tēe nī nacani tūhun Yāā Dios. De nī ncachī tūhun ndá nāsa coo jā tatúnī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","De nī ncāhān ndá jā ndiji Elías. De tú cúnī ndá nú cuetáhví nú tūhun, de suu cúu jā váji Juan, chi suu dē cúu tá cúu Elías jā ní ncachī tutū jā ndiji. ");
INSERT INTO mieNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ndá ndóhó jā níni, tee sōho vāha nú. ");
INSERT INTO mieNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yáhá cáchī ni iin tūhun yátá tácua cunī ndá nú nāsa cúu nchivī tiempo mitan. Cúu ji tá cúu ndá sūchí lúlí jā ndéē ji nūū yáhvi cásíquí ji. De cána jee ji nūū táhán ji: ");
INSERT INTO mieNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nī ntivī ndá nī tūyōó nūū ndá nú, de nduú ní jíta jéhé nú. De nī jita ndá nī yāā jā cuécá jíta, de nduú ní jácu nú, cáchī ndá ji. De tá cúu ndá sūchí lúlí ñúcuán jāá nduú ní jétahān inī ji ni iin ni incā, súcuán cúu nchivī tiempo mitan. ");
INSERT INTO mieNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chi nī nquiji Juan de cuāhā vuelta nī īyo nditē inī dē, nduú ní nchájī dē ni nduú ní jíhi dē. De nduú ní jétahān inī ndá nú, chi nī ncāhān nū jā ñúhún tāchī inī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","De nī nquenda maá nī, Yāā nī nduu tēe, de yájī ni jíhi nī, de suni nduú jétahān inī ndá nú, de scáa nú cā chi cáhān nū jā maá-ni jā yájī ni jíhi nī vino. De quétáhán nī jíín ndá tēe stútú xūhún renta jíín ndá cā tēe sáhá cuāchi, cáchī nū. De tú cúndíchí iin tēe jíín tūhun Yāā Dios, de jíín tiñu sáhá dē de natūu jā tēe ndíchí cúu dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ñúcuán de nī nquijéhé yā cáhān xēēn yā nūū ndācá ñuū nūū ní nsāhá yā cuāhā tiñu ñáhnú, chi nduú ní nácani inī ndá ji jā sndóo ji cuāchi ji. De nī ncāhān yā: ");
INSERT INTO mieNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Nācā xēēn cundoho ndá nú, nchivī ñuū Corazín. De nācā xēēn cundoho nú, nchivī ñuū Betsaida. Chi tú inī ñuū Tiro jíín ñuū Sidón ní nsáhá nī tiñu ñáhnú jā ní nsāhá nī inī ñuū maá nú, de ñamā nacani inī nchivī ñuū ñúcuán jā sndóo ji cuāchi ji nícu. De sāhá ji seña jā stéhēn jā nácani inī ji sīquī cuáchi ji, chi cuhun ji sahma túún de chihi ji yāā xīnī ji nícu. ");
INSERT INTO mieNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Túsaá de cáhān ni jíín ndá nú jā quīvī quiji juicio, de xēēn cā coo castigo sīquī ndá nú nsūú cā jā coo sīquī ñuū Tiro jíín ñuū Sidón. ");
INSERT INTO mieNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","De ndá ndóhó nchivī ñuū Capernaum, ¿á jáni inī ndá nú jā cúñáhnú nú tá cúu iin jā cáa cuāhān ichi andiví? Nduú chi sa nuu nú jondē lugar nūū íyó ndá ánō ndīyi. Chi tú inī ñuū Sodoma ní nsáhá nī tiñu ñáhnú jā ní nsāhá nī nūū maá nú, de coo ñuū ñúcuán jondē mitan nícu. ");
INSERT INTO mieNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Túsaá de cáhān ni jíín ndá nú jā quīvī juicio de xēēn cā coo castigo sīquī ndá nú nsūú cā jā coo sīquī nchivī ñuū Sodoma, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","De suni quīvī ñúcuán nī ncāhān Jesús: Ná cútahvī sá nūū ní Tatá, jā cúu ní Jētohō andiví jíín ñayīví. Chi nī jasī ní ndācá tūhun ndíchí ní, jā má cūní nchivī ndīchí jíín nchivī tūha cuenta ñayīví yáhá. De nī stéhēn ní nūū ndá nchivī jā cúu tá cúu sūchí lúlí. ");
INSERT INTO mieNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chi súcuán nī jētahān inī ní Tatá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","De nī ncāhān cā yā: Ndiviī nī jēhe Tatá nī nūū ni. De nduú jínī ndá nchivī ní iin cúu nduhū, Sēhe Yāā Dios, chi maá-ni Tatá nī cúu jā jínī yā nduhū. De ni nduú jínī nchivī nāsa Yāā cúu maá Tatá, chi maá-ni Sēhe cúu jā jínī. De íyó nchivī jā cúnī maá Sēhe stéhēn yā nūū ji nāsa Yāā cúu Tatá yā, de maá ji suni cunī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ndācá nú jā ní ncuitá nú jíín ndācá tiñu jíín ley jā víjín sáhá jíín nú, nehēn de quīvi nú ndahá nī, de natātú nú sāhá nī. ");
INSERT INTO mieNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Quīvi nú nūū tiñu jā ndácu maá nī, de scuáha nú cuu nú tá cúu nūū íyó maá nī. Chi vitá inī ni de nduú sáhá ñáhnú nī maá nī. De súcuán de natātú nú jíín ánō nū sāhá nī. ");
INSERT INTO mieNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Chi nduú víjín jā squíncuu nú nūū ni, de ni nduú vēe tiñu jā ndácu nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","De iin quīvī nátātú nī nchāha Jesús cuāhān yā nūū cáá trigo. De tēe scuáha jíín yā, cócon ndá dē. De nī nquijéhé ndá dē jéhndē dē xīnī trigo yájī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","De nī jinī ndá tēe fariseo, de nī ncāhān dē jíín yā: Cūndēhé chi ndá tēe scuáha jíín nú sáhá dē tiñu jāá nduú vāha jā sāhá ó quīvī nátātú, cáchī ley Moisés. ");
INSERT INTO mieNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","De nī ncāhān maá yā jíín dē: ¿A nduú ní ncáhvi ndá nú tutū nāsa nī nsāhá David, iin quīvī jā ní jīhī dē sōco jíín ndá tēe jā ní īyo jíín dē? ");
INSERT INTO mieNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","De nī nquīvi dē inī vehe Yāā Dios. De nī nchajī dē pan īī jā yósō nijīn nūū Yāā Dios. De nduú nā ley jā cajī dē, ni ndá tēe íyó jíín dē, chi maá-ni sūtū cúu jā yájī. De vísō súcuán de nduú nā cuāchi ní íyo sīquī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿De á nduú ní ncáhvi ndá nú tutū ley Moisés, nāsa sátíñú ndá sūtū inī templo, vísō quīvī nátātú cúu? De nduú nā cuāchi íyó sīquī dē, vísō quīvī nátātú sátíñú ndá dē tiñu jā cúu dē sūtū. ");
INSERT INTO mieNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","De cáhān ni jíín ndá nú jā maá nī jā íyó nī yáhá, cúñáhnú cā ni nsūú cā templo. ");
INSERT INTO mieNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","De nduú jícūhun inī ndá nú tūhun yáhá jā yósō nūū tutū īī jā ní ncāhān Yāā Dios: Jā cúnī cā ni cúu jā cundáhví inī nū táhán nú, nsūú cā jā sōcō nū quiti nūū ni, ncachī yā. De tú ní jícūhun inī ndá nú tūhun yáhá, de mā cáhān nū súcuán sīquī ndá tēe jāá nduú nā cuāchi nícu. ");
INSERT INTO mieNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Chi nduhū, Yāā nī nduu tēe, maá nī cúu jā tátúnī sīquī nāsa sāhá nchivī quīvī nátātú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ñúcuán de cuāhān Jesús, de nī nquīvi yā inī vehe īī sinagoga. ");
INSERT INTO mieNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","De ñúcuán íyó iin tēe jā ní nchīchī iin ndahá dē. De cúnī ndá tēe grupo fariseo jā nīhīn dē cuāchi sīquī yā, de nī jīcā tūhún dē yā: ¿A íyó ley jā cuu nasāhá vāha ó nchivī cúhū quīvī nátātú? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","De nī ncāhān yā jíín dē: ¿Ní iin nú, de tú névāha nú iin tīcāchí, de tú nincava tī iin yavī quīvī nátātú, de á nduú jéhēn nū natavā nū tī, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿De á nduú cánuú ndasí cā iin tēe nsūú cā iin tīcāchí? Túsaá de vātu-ni jā sāhá ó tiñu váha quīvī nátātú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ñúcuán de nī ncāhān yā jíín tēe jā ní nchīchī ndahá: Scáā ndahá nú, ncachī yā. De nī scáā dē, de nī nduvāha-ni tá cúu nūū íyó incā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ñúcuán de nī nquee ndá tēe grupo fariseo, de nī natúhún ndá dē sīquī Jesús, nāsa cahnī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","De nī jinī Jesús jā súcuán jáni inī ndá dē, de nī nquee yā ñúcuán cuāhān yā. De cuāhā nchivī níquīn ji yā. De nī nasāhá vāha yā ndihi nchivī cúhū. ");
INSERT INTO mieNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","De nī ndacu yā nūū ndá ji jā má stúu ji yā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","De súcuán nī ncuu tácua quee ndaā tūhun jā ní nacani Isaías jondē janahán, jā súcuán nī ncāhān Yāā Dios: ");
INSERT INTO mieNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yáhá cúu mozo ni jā ní jani nī, de mānī ni jíín yā, de cúsiī inī ni jíín yā. De cuāha nī Espíritu ni coo jíín yā. De maá yā sāhá ndāā tiñu nchivī ndācá nación. ");
INSERT INTO mieNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mā tétáhán yā, ni mā cāná jee yā, de ni mā cáhān jee yā ichi jā cuni nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mā sāhá xēēn yā jíín nchivī jā ní ncunīhin tūndóhó sīquī, ni mā snáā yā nchivī jā iin lulī-ni cándíja. Chi cuñáhnú yā sīquī ndihi, de ndāā tatúnī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","De nchivī ndācá nación cuhun inī ji jā scácu yā ji. Ncachī Yāā Dios, ncachī Isaías jondē janahán. ");
INSERT INTO mieNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ñúcuán de nī nquisiáha ndá ji nūū yā iin tēe cuáá ñíhín, chi ñúhún tāchī inī dē. De nī nasāhá vāha yā dē. De nī ndunijīn tīnūú dē, de nī nacahān dē. ");
INSERT INTO mieNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","De ndihi nchivī cuāhā nī nsāhvi inī ji ndéhé ji, de nī ncāhān ji: ¿A tēe yáhá cúu jā ní ncāhān Yāā Dios jā cacu nūū tatā David? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","De ndá tēe grupo fariseo, nī jini dē jā súcuán cáhān ji. De nī ncāhān ndá dē: Tēe yáhá mā cūú tavā dē ndá tāchī de tú mā sāhá dē jíín fuerza Satanás jā cúñáhnú nūū ndá tāchī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","De Jesús nī jinī yā jā súcuán jáni inī ndá dē, de nī ncāhān yā jíín dē: Ndācá nación jā sáhá síín maá de cánāá maá, túsaá de snáā tāhán maá. De tú iin ñuū á iin vehe sáhá síín maá de cánāá maá, de mā cūú cā cundeē cāhnú. ");
INSERT INTO mieNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","De saá-ni Satanás tú tavā táhán tāchī, túsaá de sáhá síín maá. ¿De nāsa cuiñi nīhin Satanás jā ndacu nūū táhán túsaá? ");
INSERT INTO mieNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Chi cáhān ndá nú jā jíín fuerza Satanás távā ni ndá tāchī. De tú súcuán cúu de ndá nchivī jā scuáha jíín ndá nú, ¿nā jīín fuerza távā maá ji tāchī, jáni inī nū? Túsaá de ndá máá ji cachī jā ní stíví ndasí nú jā ní ncāhān nū jā távā ni tāchī jíín fuerza Satanás. ");
INSERT INTO mieNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","De nduú chi sa jíín Espíritu Yāā Dios cúu jā távā ni tāchī. Túsaá de ja ndéē Yāā Dios māhñú ndá nú jā tátúnī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Chi nāsa cuu quīvi iin tēe inī vehe tēe ndacuī jā sacuíhná dē ndatíñú? Chi cánuú jā xihna cā cuhnī dē tēe ndacuī, sá de cuu sacuíhná dē ndatíñú tēe ñúcuán. De suni súcuán cúu jā júhnī ni Satanás de távā ni tāchī. ");
INSERT INTO mieNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","De nchivī jāá nduú íyó mānī jíín nī, túsaá de jínī ūhvī ji nduhū. De nchivī jāá nduú nástútú jíín nī, túsaá de sa scútē nuu ji nchivī jā váji nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jā ñúcuán cáhān ni jíín ndá nú: Iyó modo jā coo tūhun cáhnú inī nūū ndācá cuāchi jā sáhá nchivī, jíín nūū ndācá tūhun nēhén jā cáhān ji. Sochi tú cāhān nāvāha ji sīquī Espíritu Santo, de mā cúne cáhnú inī Yāā Dios nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","De tú nā-ni nchivī cāhān ji sīquī nduhū, Yāā nī nduu tēe, cuu cune cáhnú inī Yāā Dios nūū ji. Sochi tú nā-ni nchivī cāhān nāvāha ji sīquī Espíritu Santo, mā cúne cáhnú inī Yāā Dios nūū ji, ni ñayīví yáhá, ni tiempo jā quiji. ");
INSERT INTO mieNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tú iin ñutun váha, de vāha jāvíxī, de tú iin ñutun cánēhén, de suni cánēhén jāvíxī. Chi jíín jāvíxī de jínī ō nāsa ñutun cúu. De suni súcuán cúu nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Va sēhe cōō cúu ndá nú, chi xēēn nū tá cúu cōō. ¿Nāsa cuu cāhān nū tūhun vāha, chi nchivī nēhén cúu ndá nú? Chi ndihi nāsa jáni inī ánō nchivī, de cúsá ñúcuán cáhān ji. ");
INSERT INTO mieNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tēe vāha cáhān dē tūhun vāha, chi íyó ndāā ánō dē. De tēe nēhén cáhān dē tūhun nēhén, chi cánēhén ánō dē. ");
INSERT INTO mieNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","De cáhān ni jíín ndá nú jā ndācá nā-ni tūhun jā cáhān nchivī, nacuāha ji cuenta ndá tūhun ñúcuán quīvī quiji juicio. ");
INSERT INTO mieNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chi jíín tūhun jā ní ncāhān nū de sāhá ndāā yā sīquī nū, á jā quendōo ndāā nū á jā cundeē cuāchi sīquī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ñúcuán de jacū tēe grupo fariseo jíín tēe stéhēn ley janahán, nī ncāhān dē jíín yā: Maestro, cúnī ndá sá jā sāhá ní iin tiñu ñáhnú jā stéhēn tú maá ní cúu Yāā jā ní ntají Yāā Dios, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","De nī ncāhān yā jíín dē: Nchivī nēhén yáhá nduú jétáhví cuitī ji Yāā Dios. De jícān ji iin tiñu ñáhnú jā stéhēn tú maá nī cúu Yāā jā ní ntají Yāā Dios. De nduú cā nā incā tiñu ñáhnú stéhēn ni nūū ji, chi maá-ni tiñu ñáhnú tá cúu nūū ní ncuu jíín Jonás, tēe nī nacani tūhun Yāā Dios janahán. ");
INSERT INTO mieNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chi tá cúu nūū ní ñūhun Jonás chījin tiacá cáhnú ūnī nduú ūnī ñuú, de saá-ni nduhū, Yāā nī nduu tēe, cuū ni de coo nī chījin ñuhun ūnī nduú ūnī ñuú, de sá de natecū ni. ");
INSERT INTO mieNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","De ndá nchivī ñuū Nínive nūū ní nacani Jonás tūhun, natecū ji jíín nchivī tiempo yáhá, quīvī juicio jā sāhá ndāā yā cuāchi, de cāhān ji cuāchi sīquī nchivī yáhá. Chi ndá máá ji nī nacani inī ji nī sndóo ji cuāchi ji quīvī jā ní nacani Jonás tūhun nūū ji. De mitan chi cúñáhnú cā nduhū, Yāā íyó yáhá, nsūú cā Jonás, de nduú cándíja ndá nú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","De reina jā ní ncuñáhnú nación ichi sur, natecū ña jíín nchivī tiempo yáhá, quīvī juicio jā sāhá ndāā yā cuāchi, de cāhān ña cuāchi sīquī ji. Chi jondē jícá ndasí nī nquiji ña nī nini ña ndá tūhun ndíchí jā ní ncāhān rey Salomón, de nī ncandíja ña. De mitan chi cúñáhnú cā nduhū, Yāā íyó yáhá, nsūú cā Salomón, de nduú cándíja ndá nú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tú nī nquee iin tāchī inī iin tēe jāá nduú cándíja, de jíca nuu nūū ñuhun tíhá, ndúcú nūū natātú, de nduú níhīn, sá de jáni inī maá: ");
INSERT INTO mieNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ná quínohōn ni vehe nūū ní nquee nī. De tá nī nenda tucu, de jínī jā tēe jāá nduú cándíja, cúu dē tá cúu iin vehe jāá nduú nā ndéē de nī ndundoo. ");
INSERT INTO mieNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ñúcuán de jéhēn jénacuēca ūjā cā tāchī nēhén cā nsūú cā maá. De quívi ndá inī tēe ñúcuán de jécundeē ndá. Túsaá de xēēn cā cundoho tēe ñúcuán jā sándīhí nsūú cā jā xíhna ñúhún. De suni súcuán cundoho nchivī nēhén tiempo yáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","De juni súcuán cáhān yā jíín ndá nchivī, de nī nquenda naná yā jíín ndá ñanī yā, íñí ña tāvēhé, de cúnī ña cāhān ña jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","De nī ncachī iin tēe nūū yā: Naná ní jíín ndá ñanī ní íñí ña tāvēhé, de cúnī ña cāhān ña jíín ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","De nī ncāhān yā jíín tēe jā ní ncāhān jíín yā súcuán: ¿Ní iin cúu naná nī, de ní iin cúu ndá ñanī ni? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","De nī stéhēn ndāhá yā nūū ndéē ndá tēe scuáha jíín yā. De nī ncāhān yā: Suni naná nī jíín ñanī ni cúu ndācá yáhá. ");
INSERT INTO mieNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chi ndācá nchivī jā squíncuu tiñu jā cúnī maá Tatá nī, Yāā ndéē andiví, suu cúu ñanī ni, cuāha nī, naná nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","De quīvī ñúcuán nī nquee Jesús vehe cuāhān yā, de nī nquenda yā nī jēcundeē yā yuhú mar. ");
INSERT INTO mieNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","De nī ncutútú cuāhā ndasí nchivī nūū yā. De nī nquīvi yā inī iin barco, de nī jēcundeē yā. De ndá nchivī ñúcuán ndéē ji yuhú mar. ");
INSERT INTO mieNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","De jíín tūhun yátá nī stéhēn yā cuāhā tūhun nūū ji, de súcuán nī ncāhān yā: Iin tēe jítē tatā, nī nquee dē jā cutē dē. ");
INSERT INTO mieNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","De tá nī nquijéhé dē jítē dē, de jacū tatā nī jītē yuhú íchí. De nī nquenda ndá saā, de nī nchajī tī. ");
INSERT INTO mieNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","De jacū cā tatā nī jītē nūū ñuhun yúū, nūū nduú íyó cócón ñuhun. De ñamā-ni nī ntāhvī, chi nduú íyó cócón. ");
INSERT INTO mieNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","De tá nī nquenda ncandiī, de nī nchīchī-ni, de nī ncasūn, chi nduú ní níhīn nūū quíhīn yoho. ");
INSERT INTO mieNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","De jacū cā tatā nī jītē māhñú nūū cáá niquin iñu. De nī jahnu iñu, de nī jasī nūū. ");
INSERT INTO mieNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","De jacū cā nī jītē nūū ñuhun váha, de nī jēhe cuāhā nūnī. Sava nī jēhe ciento jā iin iin, de sava nī jēhe ūnī xico, de sava cā nī jēhe ōcō ūxī. ");
INSERT INTO mieNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","De ndá ndóhó jā níni, tee sōho vāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ñúcuán de ndá tēe scuáha jíín yā nī nquenda dē nūū yā, de nī jīcā tūhún dē yā: ¿Nājēhē cúu jā maá-ni tūhun yátá cáhān ní jíín nchivī? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","De nī ncāhān yā: Ndá ndóhó chi sáhá yā jā cuu jīcūhun inī nū ndá tūhun yáhá jā ní nchiyuhū, nāsa quívi nchivī ndahá Yāā andiví jā tatúnī yā nūū ji. Sochi nchivī yáhá jāá nduú cándíja, chi mā jícūhun inī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Chi nchivī ja jícūhun inī, stéhēn cā yā nūū ji, de víhí cā cunī ji. Sochi nchivī jāá nduú cándíja, vísō ja jínī ji jacū, de sa naā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jā ñúcuán cúu jā cáhān ni tūhun yátá jíín ndá ji. Chi vísō ndéhé ndá ji, de modo jāá nduú jínī ji. De vísō jíni jíín sóho ji, de mā jícūhun inī ji, chi modo jāá nduú ní jíni ji-ni. ");
INSERT INTO mieNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Túsaá de sīquī nchivī yáhá nī nquee ndaā tūhun jā ní ncachī Yāā Dios de nī ntee Isaías, tēe nī nacani tūhun yā jondē janahán: Vísō cunini ndá nú, de mā jícūhun inī nū, de vísō cūndēhé nú, de mā cūní nú. ");
INSERT INTO mieNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Chi ndá nchivī yáhá ndasí nī ncunīhin inī ji, de ūhvī ndasí tée sōho ji, de modo jā jásī ji tīnūú ji, tácua mā cúndēhé ji, de ni mā cúnini ji, de ni mā jícūhun inī ji, de ni mā ndīcó cóo inī ji nūū ni jā nasāhá vāha nī ánō ji nūū cuáchi ji. Cáchī Yāā Dios, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Sochi ndá máá nú, nācā ndetū nū, chi ndéhé nú jíín tīnūú nú, de tée sōho nú. ");
INSERT INTO mieNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Chi ndāā cáhān ni jíín nú jā cuāhā ndá tēe janahán jā ní nacani tūhun Yāā Dios, jíín cuāhā ndá tēe ndāā, nī ncuu inī dē jā cūndēhé dē jā ndéhé ndá nú, de nduú ní ndéhé dē. De nī ncuu inī dē cunini dē jā níni ndá nú, de nduú ní jíni dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Túsaá de cunini ndá nú nā cuá cúu tūhun yátá tēe jítē tatā. Tatā ñúcuán cúu tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","De nchivī jā jíni tūhun nāsa tátúnī Yāā Dios, de tú nduú jícūhun inī ji, de cúu ji tá cúu tatā jā ní jītē yuhú íchí. Sá de quénda tāchī cúñáhnú de cándeē-ni tūhun inī ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","De tatā jā ní jītē nūū ñuhun yúū cúu tá cúu nchivī jíni tūhun, de ñamā-ni jétáhví ji de cúsiī inī ji jíín. ");
INSERT INTO mieNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sochi nduú cúcutú tūhun inī ánō ji, de jacū-ni quīvī jétáhví ji. De tá quíji tūndóhó, á jā jínī ūhvī nchivī ji jā síquī tūhun ñúcuán, sá de quíjéhé nácani yátá inī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","De jā ní jītē māhñú iñu cúu ndá nchivī jíni tūhun, sochi ndíhvī inī ji sīquī jā íyó inī ñayīví yáhá, de cúnī ji cucuícá ji, de stáhví ndá ñúcuán jā cútéñú ji jíín. De ndācá ñúcuán jásī nūū tūhun yā, de nduú jíja ji jíín tūhun yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","De tatā jā ní jītē nūū ñuhun váha cúu ndá nchivī jíni tūhun yā, de jícūhun inī ji, de jíja ji jíín. De sava ji cúu tá cúu tatā jā jéhe ciento jā iin iin, de sava cā ji jéhe ūnī xico, de sava cā ji jéhe ōcō ūxī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","De nī ncāhān yā incā tūhun yátá jíín ndá dē: Jā tátúnī Yāā andiví cúu tá cúu iin tēe jā ní jitē dē trigo vāha nūū ñūhún dē. ");
INSERT INTO mieNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","De íyó iin tēe jínī ūhvī dē tēe xíí trigo. De juni quíxīn tēe xíí trigo jíín ndá táhán dē, de nī jēhēn tēe ñúcuán, de nī jitē niquin itē lásū nūū trigo, de cuāhān. ");
INSERT INTO mieNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","De tá nī ntāhvī trigo, de nī nquene yoco, de suni súcuán nī jahnu itē lásū. ");
INSERT INTO mieNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ñúcuán de nī nquenda ndá mozo, de nī ncāhān ji jíín patrón: Señor, ¿á nsūú trigo vāha ní jítē ní nūū ñūhún ní? ¿De nūcu nī nquene itē lásū nūū? ");
INSERT INTO mieNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","De nī ncāhān dē jíín ji: Iin tēe jínī ūhvī nduhū nī nsāhá yáhá, ncachī dē. De nī ncāhān ndá mozo jíín dē: ¿Túsaá de á cúnī ní jā quīhīn ndá sá de tuhun sā? ");
INSERT INTO mieNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","De nī ncāhān dē: Nduú, chi tú tuhun nú itē lásū ñúcuán de sanaā de tuhun nú jondē jíín trigo. ");
INSERT INTO mieNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Vāha cā ná cuáhnu maá jondē quīvī tēhndē. De quīvī ñúcuán de cachī ni nūū ndá tēe quehndē jā xihna cā itē lásū quehndē dē, de caquīn tūtú dē tácua cāyū. Ñúcuán de trigo chi quehndē dē ndīvi inī yacā ni, ncachī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","De suni nī ncāhān yā incā tūhun yátá yáhá: Nchivī jā tátúnī Yāā andiví nūū, ndúcuahā ji tá cúu nūū jáhnu iin niquin mostaza jā ní jaquīn iin tēe nūū ñuhun dē. ");
INSERT INTO mieNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","De ndāā jā iin niquin lúlí cā cúu nsūú cā ndá cā niquin. Sochi tá nī jahnu, de cúu cáhnú cā nsūú cā ndá cā yūcū, chi ndúu iin ñutun. De quénda ndá saā, de sáhá tī tacā tī chījin ndahá yúcū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","De incā tūhun yátá nī ncāhān yā jíín ndá dē: Jā tátúnī Yāā andiví nūū nchivī cúu tá cúu levadura jā ní nquehen iin ñahan. De nī nsacā ña jíín ūnī kilo harina, de nī ndaa ndihi ñujan nī nsāhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ndācá tūhun yáhá nī ncāhān Jesús jíín ndá nchivī cuāhā. De ndācá jā ní stéhēn yā, de maá-ni tūhun yátá nī ncāhān yā jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Súcuán nī nsāhá yā tácua quee ndaā tūhun nī ncāhān tēe jā ní nacani tūhun Yāā Dios jondē janahán: Cāhān ni ndá tūhun yátá jíín nchivī, de cachī ni ndá tūhun yuhū jā íyó jondē tá nī jēcāva ñayīví. Cachī Jesús, ncachī tēe nī nacani tūhun. ");
INSERT INTO mieNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ñúcuán de nī nacuetáhví Jesús nūū nchivī. De nī ndīvi yā inī vehe. De ndá tēe scuáha nī nquenda dē nūū yā, de nī ncāhān dē jíín yā: Cachī cājí ní tūhun yátá itē lásū nūū sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","De nī ncāhān yā jíín ndá dē: Jā jítē trigo vāha ñúcuán cúu nduhū, Yāā nī nduu tēe. ");
INSERT INTO mieNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","De ñuhun ñúcuán cúu ñayīví. De tatā vāha cúu ndá nchivī yíhí ndahá Yāā Dios jā tátúnī yā nūū ji. De itē lásū cúu ndá nchivī yíhí ndahá tāchī cúñáhnú. ");
INSERT INTO mieNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","De tēe jínī ūhvī jā ní jitē niquin itē lásū cúu maá tāchī cúñáhnú. De quīvī tēhndē cúu quīvī jīnu ñayīví. De ndá tēe quehndē cúu ndá ángel Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","De tá cúu jā tēhndē itē lásū de cāyū nūū ñúhūn, súcuán coo quīvī jīnu ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Chi nduhū, Yāā nī nduu tēe, tají nī ndá ángel ni quīhīn. De nastútú yā ndācá nchivī squívi táhán nūū cuáchi, jíín nchivī sáhá tiñu néhén, tavā yā ji māhñú nchivī jā tátúnī ni nūū. ");
INSERT INTO mieNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","De taān yā ndá ji cāyū ji nūū ñúhūn. De ñúcuán cuacu ji de nacayīhí ji ñii yúhú ji jā ndoho ndasí ji. ");
INSERT INTO mieNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sá de nchivī jā squíncuu nūū yā chi cuēndūtē ji modo ncandiī, de cundeē ji nūū tátúnī maá Tatá ji Yāā Dios. Ndá ndóhó jā níni, tee sōho vāha nú. ");
INSERT INTO mieNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","De jā quívi nchivī ndahá Yāā Dios jā tatúnī yā nūū ji, suu cúu tá cúu iin jātūn xūhún jā yíyuhū chījin iin ñuhun. De nī nanihīn iin tēe, de nī nacasī tucu dē sīquī. De jā cúsiī inī dē jíín, de cuāhān dē cuāxīcó ndihi dē jā névāha dē, de nī jeen dē ñuhun ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","De jā quívi nchivī ndahá Yāā Dios jā tatúnī yā nūū ji, suni cúu tá cúu iin tēe jéen de náxīcó, de ndúcú dē perla vāha. ");
INSERT INTO mieNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","De nī jinī dē iin perla jā ndéē yāhvi ndasí, de nī jēhēn dē nī yīcó ndihi dē jā névāha dē, de nī jeen dē perla ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","De jā tátúnī Yāā andiví nūū nchivī, suni cúu tá cúu iin ñunu jā chúndaji ndá dē nūū mar, de quívi ndācá nūū tiacá. ");
INSERT INTO mieNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","De tá nī nchitú ñunu, de távā ndá dē yuhú ndúté. De jécundeē dē, de nácāji dē tiacá. De tiacá váha táān dē inī tīcá, de tiacá jāá nduú íyó vāha squéne dē. ");
INSERT INTO mieNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","De suni súcuán coo quīvī jīnu ñayīví. Chi quenda ndá ángel yā, de sāhá síín yā ndá nchivī sáhá tiñu néhén māhñú nchivī vāha. ");
INSERT INTO mieNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","De nchivī nēhén chi taān yā ji cāyū ji nūū ñúhūn. De ñúcuán cuacu ji de nacayīhí ji ñii yúhú ji jā ndoho ndasí ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","De nī jīcā tūhún yā ndá dē: ¿A nī jīcūhun inī ndá nú ndá tūhun yáhá, á nduú? ncachī yā. De nī ncāhān ndá dē jíín yā: Nī jīcūhun inī sá, Señor. ");
INSERT INTO mieNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","De nī ncāhān yā jíín dē: Iyó vāha túsaá. De iin tēe stéhēn ley janahán, tú ja nī ncutūha dē nāsa tátúnī Yāā andiví, de cuu stéhēn dē ndá tūhun sīquī ñúcuán. Chi cúu dē tá cúu iin tēe xívéhe. De inī jātūn dē távā dē ndatíñú ndéē yāhvi, sava jā jēé jíín sava jā ní ncunahán íyó, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","De tá nī ncuu nī ncāhān Jesús ndá tūhun yátá yáhá, de nī nquee yā ñúcuán cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","De nī nenda yā ñuū yā Nazaret. De nī stéhēn yā tūhun inī vehe īī sinagoga. De nī nsāhvi inī ndá nchivī nī jini ji, de nī ncāhān ji: ¿Ní cúu nūū ní ncutūha tēe yáhá ndá tūhun ndíchí yáhá? ¿De nāsa cúu sáhá dē ndá tiñu ñáhnú yáhá? ");
INSERT INTO mieNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Chi sēhe carpintero cúu tēe yáhá, de naná dē cúu María, de ndá ñanī dē cúu Jacobo, José, Simón, jíín Judas. ");
INSERT INTO mieNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","De suni ndéē ndá cuāha dē jíín ó yáhá. ¿De nāsa jínī dē ndācá tūhun yáhá túsaá? ncachī ndá nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","De súcuán nī nsāhá jéhe inī ndá ji nūū Jesús. De nī ncāhān yā jíín ji: Ndācá tēe nácani tūhun Yāā Dios, íyó yíñúhún nchivī jíín dē, chi maá-ni nchivī ñuū dē jíín nchivī vehe dē cúu jāá nduú íyó yíñúhún jíín dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","De nduú ní nsáhá yā cuāhā tiñu ñáhnú ñúcuán, chi nduú ní ncándíja ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","De tiempo ñúcuán de Herodes, tēe tátúnī región Galilea, nī nīhīn dē tūhun nāsa sáhá Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","De nī ncāhān dē jíín ndá nchivī íyó jíín dē: Tēe ñúcuán cúu Juan, tēe jā ní scuénduté, de nī natecū dē. Jā suu cúu jā íyó poder dē jā sáhá dē ndá tiñu ñáhnú, ncachī Herodes. ");
INSERT INTO mieNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Chi maá dē ja nī ndacu dē jā ná quívi Juan vecāa, jíín jā cunuhnī dē jíín cadena. Súcuán nī nsāhá dē jā síquī Herodías, ñasíhí ñanī dē Felipe. ");
INSERT INTO mieNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Chi Juan nī ncāhān dē nūū Herodes: Nduú nā ley íyó jā nacueca nú ña, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","De jā ñúcuán nī ncuu inī Herodes jā cahnī dē Juan. Sochi yúhú dē jā quītī inī nchivī, chi ndihi ji jáni ndija inī ji jā iin tēe nácani tūhun Yāā Dios cúu Juan. ");
INSERT INTO mieNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","De iin quīvī nī nsāhá Herodes iin vico quīvī jā ní ncacu dē. De sēhe síhí Herodías nī nquīvi ji nī jita jéhé ji nūū ndá nchivī jā ní ncana dē. De nī ncusiī inī Herodes nī nsāhá ji. ");
INSERT INTO mieNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","De nī ncāhān téyíí dē jā cuāha dē nā-ni cuá cúu jā cācān ji nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","De nī jēhēn ji nī jīcā tūhún ji naná ji nā cuá cúu jā cācān ji. De nī ndīvi ji nūū Herodes, de nī ncāhān ji: Taji ní xīnī Juan tēe scuénduté, cuhun nūū iin cōhō, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ñúcuán de rey Herodes nī ncucuécá inī dē. Sochi sīquī jā ní ncāhān téyíí dē, jíín jā ní jini ndá tēe yájī stāā jíín dē, jā ñúcuán nī ndacu dē jā ná cuáha ndá nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","De nī ntají dē soldado jā quíquehndē xīnī Juan inī vecāa. ");
INSERT INTO mieNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","De nī nenda soldado jíín xīnī Juan, ñúhún nūū iin cōhō, de nī jēhe ndá nūū ñahan lúlí. De nī jēnasiáha ji nūū naná ji. ");
INSERT INTO mieNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ñúcuán de nī jēhēn ndá tēe nī scuáha jíín Juan, de nī nanee dē yiqui cúñu Juan, de nī nchiyuhū dē. Ñúcuán de nī jēhēn ndá dē, nī ncachī tūhún dē nūū Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","De tá nī jini Jesús tūhun, de nī ncujiyo yā ñúcuán cuāhān yā jíín barco jā cundeē sīín yā iin lugar nūū nduú nchivī. De nī jinī ndá nchivī jā cuáhān yā. De ndācá ñuū nī nquee ji, jíca jéhé ji cuātahān ji yā. ");
INSERT INTO mieNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","De tá nī nquee Jesús inī barco, de nī jinī yā nchivī cuāhā ñúcuán. De nī ncundáhví inī yā ji, de nī nasāhá vāha yā ndācá nchivī cúhū jā váji ndá ji jíín. ");
INSERT INTO mieNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","De tá nī ñini, de ndá tēe scuáha jíín yā nī nquenda dē nūū yā, de nī ncāhān dē: Ja nī ñini, de nduú nā nchivī ndéē yáhá. Túsaá de tají ní nchivī ná quíhīn ndá ji ndācá ñuū, de cueen ji jā cajī ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","De nī ncāhān Jesús jíín ndá dē: Nduú cánuú quīhīn ji, chi cuāha ndá máá nú jā cajī ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","De nī ncāhān ndá dē: Nduú ná névāha sá yáhá, chi ūhūn-ni stāā jíín ūū-ni tiacá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","De nī ncāhān yā jíín dē: Taji ná quíji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","De nī ncāhān yā jíín ndá nchivī jā cundeē ji nūū ítē. De nī nquehen yā ndihúhūn stāā jíín ndúū tiacá ñúcuán. De nī nūcūndēhé yā ichi andiví, de xihna cā nī nacuetáhví yā nūū Tatá yā. De nī scuáchi yā stāā, de nī jēhe yā nūū ndá tēe scuáha jíín yā. De ndá máá dē nī nsajī dē nūū ndá nchivī cuāhā. ");
INSERT INTO mieNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","De ndiviī ji nī nchajī, de nī ndahā chījin ji. De nī nastútú ndá dē pedazo jā ní nquendōo, de nī nchitú ūxī ūū tīcá. ");
INSERT INTO mieNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","De tēe jā ní nchajī cúu tá ūhūn mil, de síín cā cúu ndá ñahan jíín sūchí lúlí. ");
INSERT INTO mieNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ñúcuán de nī ncāhān Jesús jíín ndá tēe scuáha jíín yā jā ná quívi dē inī barco, de cosō nūú dē quīhīn dē incā lado mar, juni nátají yā ndá nchivī cuāhā jā quínohōn ji. ");
INSERT INTO mieNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","De tá nī ncuu nī nacuetáhví yā nūū ji, de nī ncaa yā yucu cuāhān mátúhún yā, cuācācān táhvī yā. De nī ncuaā, de mátúhún yā-ni íyó ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","De barco ja ñúhún sava mar cuāhān. De ndute mar nátundahá nīhin barco, chi vāji tāchī ichi núū. ");
INSERT INTO mieNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","De niquín nī nquenda Jesús nūū ndá dē, jíca jéhé yā nūū mar. ");
INSERT INTO mieNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","De ndá tēe scuáha jíín yā, nī jinī dē jā jíca yā nūū mar. De nī nandava ndá dē, de nī ncana cóhó dē jā yúhú dē: Ñíhná cúu, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","De nī ncāhān-ni Jesús jíín dē: Ndeé coo inī ndá nú, de mā cúyūhú nú, chi maá nī cúu, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ñúcuán de nī ncāhān Pedro jíín yā: Señor, de tú maá ní cúu, de cachī ní jā suni ná cáca jéhé sá nūū mar de cuēē sá nūū ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","De nī ncāhān yā: Nehēn túsaá. De nī nuu Pedro inī barco, de jíca dē nūū ndūté cuāhān dē nūū Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","De tá nī jinī dē jā nīhin yíhí tāchī, de nī nchūhú dē. De nī nquijéhé dē quée dē chījin ndute. De nī ncana cóhó dē: Scácu ní sāán, Señor, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","De Jesús nī ntiin yā ndahá dē. De nī ncāhān yā jíín dē: Tēe nduú cándíja nīhin cúu nú. ¿Nūcu nī nayūhú nú? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","De nī ndīvi yā jíín dē inī barco, de nī jencuiñī-ni tāchī. ");
INSERT INTO mieNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Sá de ndá tēe jā ñúhún inī barco, nī jēcuīñī jītí dē nūū yā. De nī ncāhān ndá dē: Maá jāndáā jā Sēhe Yāā Dios cúu ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","De nī nchāha yā jíín ndá dē incā lado mar, de nī nquenda yā región Genesaret. ");
INSERT INTO mieNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","De ndá nchivī ñúcuán nī nacunī ji nūū yā. De nī scáca ji tūhun ndācá ndáñúū ñúcuán jā ní nquenda yā. De ndá nchivī nī nquisiáha ji ndá jā cúhū nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","De nī ncāhān ndāhví ndá ji jíín yā jā ná quéhé ji vísō yuhú sáhmá yā. De ndācá nchivī jā ní nquehé sahma yā, nī nduvāha ji. ");
INSERT INTO mieNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ñúcuán de jacū ndá tēe fariseo jíín tēe stéhēn ley janahán, vāji dē ciudad Jerusalén, de nī nquenda dē nūū yā. De nī ncāhān dē jíín yā: ");
INSERT INTO mieNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ndá tēe scuáha jíín nú, ¿nūcu stíví ndá dē costumbre jā ní jaquīn nchivī janahán? Chi nduú squíncuu dē costumbre jā nandahá dē nūū yā de cajī dē stāā, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","De Jesús nī jīcā tūhún yā dē: De saá-ni ndá máá nú, ¿nūcu stíví nú tiñu jā ní ndacu Yāā Dios nūū nū? Chi sa costumbre ndá máá nú cúu jā squíncuu nú. ");
INSERT INTO mieNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Chi nī ncāhān Yāā Dios: Coo yíñúhún nú nūū tatá nú nūū naná nú. De tú ní iin cāhān sīquī tatá á sīquī naná, de ná cúū, cáchī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sochi ndá máá nú chi cáchī nū jā cuu cāhān iin tēe jíín tatá dē á naná dē: Mā cūú chindeé sá ní jā taji sá jā cajī ní á jā cusúcún ní, chi ndihi jā névāha sá, ja nī nsōcō sá nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","De tēe jā cáhān súcuán, nduú cā cánuú jā chindeé dē tatá dē naná dē, cáchī ndá nú. De súcuán stíví nú tiñu jā ní ndacu Yāā Dios, jā síquī costumbre jā ní jaquīn ndá máá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Vāchi tēe stáhví-ni cúu ndá nú. Ndāā nī ncāhān Isaías sīquī ndá nú janahán, yósō nūū tutū īī jā ní ncāhān Yāā Dios: ");
INSERT INTO mieNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nchivī yáhá chi jíín yuhú ji-ni jétáhví ji nduhū, sochi nsūú jondē jíín inī jíín ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","De chíñúhún cāhá ji nduhū, chi tūhun jā stéhēn ji cúu tiñu jā ní ndacu ndá tēe, de nsūú jā ní ndacu maá nī cúu. Ncachī Yāā Dios, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","De nī ncana yā nchivī cuāhā, de nī ncāhān yā jíín ji: Cunini vāha ndá nú, de chuhun inī nū: ");
INSERT INTO mieNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nsūú jā quívi inī yuhú nchivī cúu jā cútéhén ji sáhá. Chi tūhun jā quée yuhú ji, ñúcuán cúu jā cútéhén ji sáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ñúcuán de ndá tēe scuáha jíín yā nī nquenda dē nūū yā, de nī ncāhān dē: ¿A jínī ní jā ní nquītī inī ndá tēe fariseo jā ní jini dē tūhun nī ncāhān ní? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","De nī ncāhān maá yā: Cúu ndá dē tá cúu ñutun jāá nduú ní nchúhun Tatá nī, Yāā ndéē andiví, de iin quīvī de tuhun yā. ");
INSERT INTO mieNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ná quíhīn ndá máá dē, chi cúu ndá dē modo tēe cuáá jā stéhēn ichi nūū incā tēe cuáá. Chi tú iin tēe cuáá stéhēn dē ichi nūū incā tēe cuáá, de ndúū dē nincava xehvā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","De nī ncāhān Pedro jíín yā: Cachī cājí ní tūhun yátá yáhá jā ní ncachī ní nūū ndá sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","De nī ncāhān Jesús: ¿De á suni ncháha ca jīcūhun inī ndá máá nú? ");
INSERT INTO mieNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A nduú jícūhun inī nū jā ndācá jā yájī nchivī, chi quívi chījin ji, de quée-ni cuāhān? ");
INSERT INTO mieNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sochi tūhun jā quée yuhú nchivī, chi jondē inī ánō ji vāji, de ñúcuán cúu jā cútéhén ji sáhá. ");
INSERT INTO mieNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Chi jondē inī ánō nchivī quée jā jáni nēhén inī, jā jáhnī ndīyi, jā cásíquí ndéē tāhán, jā sáhá ndiī, jā sácuíhná, jā cáhān tūhun stáhví, jā cáhān sīquī táhán. ");
INSERT INTO mieNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","De ndācá yáhá cúu jā cútéhén nchivī sáhá. Sochi tú nduú squíncuu ji costumbre jā nandahá ji de cajī ji stāā, de nduú cútéhén ji sáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","De nī nquee Jesús ñúcuán cuāhān yā región Tiro jíín Sidón. ");
INSERT INTO mieNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","De iin ñahan ñuū Canaán ndéē ña región ñúcuán, de nī nquenda ña nūū Jesús. De nī ncana jee ña: Señor, maá ní jā cúu Sēhe tatā David, cundáhví inī ní sāán. Chi sēhe síhí sá, ñúhún tāchī inī ji, de xēēn ndasí ndóho ji, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sochi nduú ní ncáhān cuitī yā jā ní ncāhān ña. Ñúcuán de nī nquenda ndá tēe scuáha jíín yā, de nī ncāhān dē: Cāhān ní jíín ña ná quíhīn ña, chi ndasí cána ña vāji ña yātā ō, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","De nī ncāhān yā jíín ña: Nūū mátúhún-ni nchivī nación Israel nī ntají Yāā Dios sāán vāji sá, chi cúu ji tá cúu tīcāchí, quiti jā ní nsana, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sochi nī nquenda ña, de nī jēcuīñī jītí ña nūū yā, de nī ncāhān ña: Señor, chindeé chituu ní sāán viī, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","De nī ncāhān yātá yā jíín ña: Nduú íyó vāha jā candeē ō stāā sēhe ó de cuāha ó nūū tinā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","De nī ncāhān ña: Ndāā cáhān ní Señor, sochi chindeé ní sāán vísō cúu sá modo tinā. Chi suni ndá tī níhīn tī pedazo stāā jā cóyo chījin mesa jētohō tī yájī tī, ncachī ña jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ñúcuán de nī ncāhān Jesús: Vāha ndasí cándíja ní, nánā. De ná sáhá sá jā cúnī ní, ncachī yā. De maá hora ñúcuán nī nduvāha-ni sēhe síhí ña. ");
INSERT INTO mieNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","De nī nquee Jesús ñúcuán cuāhān yā, de nī nchāha yā yuhú mar Galilea. De nī ncaa yā iin yucu, de ñúcuán nī jēcundeē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","De nī nquenda cuāhā nchivī nūū íyó yā, de nī nquisiáha ji ndá jā cojo, jā cuāá, jā ñīhín, jā cuhlu, jíín cuāhā cā nchivī cúhū. De nī jaquīn ji nūū jéhē Jesús. De nī nasāhá vāha yā ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","De nī nsāhvi inī ndá nchivī ndéhé ji jā nácahān nchivī ñīhín, ndúvāha nchivī cuhlu, nácaca vāha nchivī cojo, de nánune tīnūú nchivī cuāá. De nī ncāhān ndá ji jā vāha ndasí Yāā cúu Yāā Dios nación maá ji Israel. ");
INSERT INTO mieNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ñúcuán de nī ncana Jesús ndá tēe scuáha jíín yā, de nī ncāhān yā jíín dē: Cúndáhví inī ni ndá nchivī cuāhā yáhá, chi ja nī ncuu ūnī quīvī íyó ji jíín nī, de nduú cā nā cuá cajī ji. De nduú cúnī ni natají nī ji jā quínohōn nditē ji, chi tú súcuán de sava ichi de cuītá ndasí ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","De nī ncāhān ndá tēe scuáha jíín yā: ¿De ní nīhīn ō stāā jā cajī ndá nchivī cuāhā yáhá? Chi yáhá nduú nā nchivī ndéē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","De nī jīcā tūhún yā dē: ¿Nāsaa stāā névāha ndá nú? De nī ncāhān ndá dē: Ujā-ni, jíín jacū tiacá lúlí, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ñúcuán de nī ncāhān yā jíín ndá nchivī cuāhā jā cundeē ji. ");
INSERT INTO mieNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","De nī nquehen yā ndihújā stāā jíín tiacá, de xihna cā nī nacuetáhví yā nūū Yāā Dios. De nī scuáchi yā, de nī jēhe yā nūū ndá tēe scuáha jíín yā, de ndá máá dē nī nsajī nūū nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","De ndihi ji nī nchajī, de nī ndahā chījin ji. Sá de nī nastútú ndá dē pedazo jā ní nquendōo, de nī nchitú ūjā tīcá. ");
INSERT INTO mieNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","De tēe jā ní nchajī, jondē cūmī mil dē cúu, de síín cā cúu ndá ñahan jíín sūchí lúlí. ");
INSERT INTO mieNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ñúcuán de nī nacuetáhví yā nūū nchivī, de cuānohōn ji. De nī ndīvi yā inī barco, de cuāhān yā región Magdala. ");
INSERT INTO mieNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","De nī nquenda ndá tēe grupo fariseo jíín tēe grupo saduceo nūū yā. Chi cúnī ndá dē coto túnī dē yā, de nī jīcān dē jā sāhá yā iin tiñu ñáhnú jā coo iin seña andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sochi maá yā nī ncāhān yā jíín dē: Tá ñini, de cáhān ndá nú: Nandiī, chi nī jīchi cuáhá vīcō, cáchī nū. ");
INSERT INTO mieNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","De jānehēn chi cáhān ndá nú: Mitan de cuun sāvī, chi nī jīchi cuáhá vīcō, cáchī nū. Vāchi tēe stáhví-ni cúu ndá nú. Chi jícūhun inī ndá nú nāsa stéhēn seña andiví, sochi nduú jícūhun inī nū nāsa stéhēn ndá tiñu ñáhnú jā sáhá nī tiempo yáhá. ");
INSERT INTO mieNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","De nchivī nēhén yáhá, chi nduú jétáhví cuitī ji Yāā Dios. De jícān ji iin tiñu ñáhnú jā sāhá nī jā coo iin seña andiví. Sochi nduú cā nā incā tiñu ñáhnú stéhēn ni nūū ji, chi maá-ni tiñu ñáhnú tá cúu nūū ní ncuu jíín Jonás, tēe nī nacani tūhun Yāā Dios jondē janahán, ncachī yā. De nī sndóo yā-ni ndá dē, de cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","De ndá tēe scuáha jíín yā nī naā inī dē cuiso dē stāā tá cuāhān ndá dē jíín yā jíín barco incā lado mar. ");
INSERT INTO mieNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","De nī ncāhān Jesús jíín dē: Coto má candíja ndá nú levadura ndá tēe grupo fariseo jíín grupo saduceo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","De ndá tēe scuáha nī ncāhān ndá máá dē: Va sīquī jāá nduú nā stāā ndíso ó, jā ñúcuán cáhān yā súcuán, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","De nī jinī Jesús, de nī ncāhān yā: ¿Nūcu cáhān ndá nú jā ní ncāhān ni súcuán sīquī jāá nduú nā stāā ndíso nú? Tēe nduú cándíja nīhin cúu ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿A ncháha ca jīcūhun inī ndá nú jāá nsūú sīquī ñúcuán ní ncáhān ni? ¿A nduú núcūhun inī nū jā ní scuáchi nī ūhūn stāā nī nchajī ūhūn mil tēe, de nāsaa tīcá nī nastútú ndá nú jā ní nquendōo? ");
INSERT INTO mieNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿De á nduú núcūhun inī nū jā ní scuáchi nī ūjā stāā nī nchajī cūmī mil tēe, de nāsaa tīcá nī nastútú tucu nú? ");
INSERT INTO mieNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿De nājēhē cúu jāá nduú jícūhun inī ndá nú jāá nsūú sīquī stāā ní ncáhān ni jíín nú jā ní ncāhān ni jā coto má candíja ndá nú levadura ndá tēe fariseo jíín tēe saduceo? ncachī yā jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ñúcuán de nī jīcūhun inī ndá dē jāá nduú ní ncáhān yā jíín dē jā má cājí dē stātílā jā yíhí levadura, chi sa nī ncāhān yātá yā jā má cándíja dē tūhun stáhví jā stéhēn ndá tēe fariseo jíín tēe saduceo. ");
INSERT INTO mieNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","De tá nī nquenda Jesús región Cesarea Filipo jíín ndá tēe scuáha jíín yā, de nī jīcā tūhún yā dē: Nduhū, Yāā nī nduu tēe, ¿ní iin cúu nī cáchī ndá nchivī? ");
INSERT INTO mieNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","De nī ncāhān ndá dē: Sava ji cáhān jā cúu ní Juan, tēe jā ní scuénduté. De sava cā ji cáhān jā cúu ní Elías, tēe nī nacani tūhun Yāā Dios jondē janahán. De sava cā ji cáhān jā cúu ní Jeremías á incā tēe nī nacani tūhun Yāā Dios, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","De nī ncāhān yā: De ndá máá nú, ¿ní iin cúu nī cáchī ndá nú? ");
INSERT INTO mieNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","De nī ncāhān Simón Pedro: Maá ní cúu Cristo, Yāā jā ní ntají Yāā Dios. De cúu ní Sēhe Yāā Dios, Yāā jā técū níí cání, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","De nī ncāhān Jesús: Nācā ndetū nū, Simón sēhe Jonás, chi nsūú iin nchivī ní stéhēn tūhun yáhá nūū nū, chi sa maá Tatá nī, Yāā ndéē andiví, nī stéhēn yā nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","De nduhū suni cáhān ni jíín nú jā maá nú cúu Pedro, de tūhun yáhá cáchī: Yūū. De tūhun ndāā jā ní ncāhān nū jā maá nī cúu Cristo, suu cúu tá cúu iin yūū cāhnú. De sīquī yūū cāhnú yáhá sāhá nī jā quituu vehe, de vehe ñúcuán cúu ndá nchivī jā cándíja nduhū. De ni iin mā cúndéé sīquī ji, ni cuēhē jā jíhī ji, nduú cā nā cuá cuu sāhá jíín ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","De maá nú cundiso tíñú nú jā quīvi nchivī ndahá Yāā andiví jā tatúnī yā nūū ji. De ndācá jā casī nū jā má sāhá nchivī inī ñayīví yáhá, suni casī Yāā Dios jā ndéē jondē andiví. De ndācá jā cuāha nú tūhun sāhá ji inī ñayīví yáhá, suni cuāha tūhun Yāā Dios jā ndéē jondē andiví, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ñúcuán de nī ndacu yā nūū ndá tēe scuáha jíín yā jā má cāchí dē nūū ni iin nchivī jā cúu yā Cristo. ");
INSERT INTO mieNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","De jondē saá nī nquijéhé Jesús cáchī tūhun cájí yā nūū ndá tēe scuáha jíín yā jā cánuú quīhīn yā Jerusalén. De ndá tēe ñáhnú jíín ndá sūtū cúñáhnú jíín ndá tēe stéhēn ley janahán, sndóho ndasí dē yā. De cahnī ndá dē yā, sochi nūū únī quīvī de natecū yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ñúcuán de Pedro nī ncana síín dē yā, de nī nquijéhé dē cáhān dē nūū yā: Señor, ¿nūcu cáhān ní súcuán? De mā cuáha cuitī Yāā Dios tūhun. Va mā cūú cuitī coo súcuán, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","De nī jicó cóto yā nūū Pedro, de nī ncāhān yā: Cujiyo quīhīn nū, chi cáhān nū tá cáhān Satanás. Chi tēe ndúcú stíví nduhū cúu nú. De nduú jáni inī nū tá cúu nūū jáni inī Yāā Dios, chi sa jáni inī nū tá cúu nūū jáni inī nchivī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ñúcuán de nī ncāhān yā jíín ndá tēe scuáha jíín yā: Nā-ni nchivī tú cúnī ji cuniquīn ji nduhū jā scuáha nī ji, de ná cásī ji jā cúnī maá ji, de ná cúniquīn ji nduhū, de cuāha ji tūhun jā cundoho ji tūndóhó jā síquī ni, vísō ná cúū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Chi tú ní nchivī cúnī ji cācu ji nūū tūndóhó jā quiji nūū ji jā síquī nduhū, túsaá de tānū tāhvī ji níí cání. De tú ní nchivī vísō ná cúū ji jā síquī nduhū, sochi cutecū ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Chi ní cuetíñú vísō ná cúndeé nchivī nīhīn ji níí ñayīví, de tú quīvi ji nūū tānū tāhvī ji? Chi nduú nā jīín cuitī chunáá nchivī jā cācu ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Chi nduhū, Yāā nī nduu tēe, ndiji nī jíín ndācá ángel ni, de viī ndasí cuñáhnú nī tá cúu nūū cúñáhnú Tatá nī. Ñúcuán de cuāha nī yāhvi nūū tá iin iin nchivī tú nāsa tiñu nī nsāhá ji. ");
INSERT INTO mieNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","De ndāā cáhān ni jíín ndá nú jā sava tēe íyó yáhá, mā cúū dē chi jondē cunī dē jā maá nī, Yāā nī nduu tēe, tatúnī ni jíín poder ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ñúcuán de nūū íñū quīvī de Jesús nī jeca yā Pedro jíín Jacobo jíín Juan ñanī Jacobo, cuāhān sīín yā jíín ndá dē iin yucu súcún. ");
INSERT INTO mieNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","De ñúcuán, tucu nī nduu yā nūū dē. Chi nī jēndūtē nūū yā tá cúu ncandiī. De sahma yā nī nduyaa ndasí tá cúu nduva luz. ");
INSERT INTO mieNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","De nī jinī-ni ndá dē jā Moisés jíín Elías, tēe nī īyo janahán, nátúhún ndúū dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","De nī ncāhān Pedro jíín yā: Señor, nācā vāha jā íyó ndá sá yáhá. De tú cúnī ní de ná sáhá ndá sá ūnī vehe ramádā, iin cuu maá ní, incā cuu Moisés, de incā cuu Elías, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","De juni cáhān cā dē, de nī nquiji iin vīcō nūhún jā yaa ndasí, de nī jasī-ni nūū ndá dē. De nūū vīcō ñúcuán nī ncāhān iin tūhun: Yáhá cúu Sēhe nī jā mānī ndasí nī jíín, de cúsiī inī ni jíín. De cunini ndá nú tūhun cáhān yā, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","De jā súcuán nī jini ndá tēe scuáha, de nī jēcāva ndeyi dē nūū ñūhún, chi nī nchūhú ndasí ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ñúcuán de nī nquenda Jesús, de nī ntee yā ndahá yā dē, de nī ncāhān yā: Nacōo ndá nú de mā cúyūhú nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","De nī nūcūndēhé ndá dē, de nduú cā ní jínī dē ndúū tēe ñúcuán, chi maá-ni cā Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","De nī nuu ndá dē jíín yā yucu. De nī ndacu yā nūū dē: Mā cāchí ndá nú nūū ni iin jā súcuán nī jinī nū, chi jondē tá natecū maá nī, Yāā nī nduu tēe, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ñúcuán de ndá tēe scuáha jíín yā, nī jīcā tūhún dē yā: Túsaá de ndá tēe stéhēn ley janahán, ¿nājēhē cáhān dē jā cánuú jā xihna cā Elías nenda, sá de quiji Yāā cúu Cristo? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","De nī ncāhān Jesús jíín dē: Jāndáā cúu jā xihna cā quiji iin tēe cuu tá ncuu Elías, de sāhá tūha dē ndihi, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sochi cáhān ni jíín nú, ja nī nquiji tēe jāá ncuu tá cúu nūū ní ncuu Elías, de nduú ní jínī nchivī jā suu dē cúu. De nī nsāhá nāvāha ji dē ndihi jā ní ncuu inī ji. De suni súcuán sndóho ji nduhū, Yāā nī nduu tēe, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ñúcuán de ndá tēe scuáha jíín yā nī jīcūhun inī dē jā cáhān yā jā Juan, tēe nī scuénduté, nī ncuu dē tá ncuu Elías. ");
INSERT INTO mieNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","De nī nenda yā jíín ndá dē nūū nchivī cuāhā. De nī nquenda iin tēe, nī jēcuīñī jītí dē nūū yā, de nī ncāhān dē: ");
INSERT INTO mieNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Señor, cundáhví inī ní sēhe yií sá, chi ndóho ndasí ji cuēhē jíhī yīhí. De ja ncuu cuāhā vuelta jícó cáva ji nūū ñúhūn jíín nūū ndūté. ");
INSERT INTO mieNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","De nī nquisiáha sá ji nūū ndá tēe scuáha jíín ní, de nduú ní ncúu nasāhá vāha dē ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ñúcuán de nī ncāhān Jesús: Tēe nīhin ndasí inī cúu ndá nú chi nduú cándíja nú jā cuu nduvāha ji. ¿Nāsaa cā quīvī cundeē ni jā ndoho nī jíín nú? ¿De nāsaa cā quīvī cuandeé inī ni jíín nú? Cuáquēhen sūchí ñúcuán ná quíji ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","De nī ncāhān yā nūū tāchī, de nī nquee-ni inī sūchí ñúcuán. De nī nduvāha ji-ni maá hora ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","De tá nī ncunúú cā de ndá tēe scuáha nī jīcā tūhún síín dē yā: ¿Nājēhē cúu jāá nduú ní ncúu tavā ndá sá tāchī ñúcuán? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","De nī ncāhān yā: Sīquī jāá nduú cándíja nīhin ndá nú jā cuu sāhá nú. Chi ndāā cáhān ni jíín ndá nú jā tú cándíja nú vísō iin lulī-ni tá cúu iin niquin mostaza, de cuu sāhá nú ndācá-ni tiñu víjín. Chi cuu cāhān nū jā ná cújiyo yucu yáhá quīhīn incā lado, de cujiyo-ni. De ndācá-ni tiñu chi cuu sāhá nú, de tú candíja nīhin nú jā cuu. ");
INSERT INTO mieNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Sochi iin tāchī súcuán, mā quēé cuitī quīhīn de tú mā cácān táhvī nū de tú mā cōó nditē inī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","De jíca nuu Jesús jíín ndá dē región Galilea, de nī ncāhān yā jíín dē: Maá nī, Yāā nī nduu tēe, nastúu ji nduhū nūū ndá tēe xēēn. ");
INSERT INTO mieNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","De cahnī dē nduhū, sochi nūū únī quīvī de natecū ni, ncachī yā. De nī ncucuécá ndasí inī ndá dē jā ní ncāhān yā tūhun yáhá. ");
INSERT INTO mieNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","De nī nquenda yā ñuū Capernaum jíín ndá tēe scuáha jíín yā. De ndá tēe stútú xūhún templo nī nquenda dē, de nī jīcā tūhún dē Pedro: De maestro ndá nú, ¿á mā tājí dē xūhún cuetíñú inī templo? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","De nī ncāhān Pedro: Cuu, ncachī dē. De tá nī ndīvi dē inī vehe, de xihna cā Jesús nī ncāhān yā jíín dē: ¿Nāsa jáni inī nū, Simón? Ndācá tēe cúu rey inī ñayīví yáhá, ¿ní nūū jícān dē xūhún renta jíín xūhún ñúū? ¿A nūū sēhe dē, á nūū nchivī incā vehe? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","De nī ncāhān Pedro: Nūū tēe incā vehe jícān dē, ncachī dē. De nī ncāhān Jesús: Túsaá de nduú nā incā cúñáhnú nūū sēhe rey jā cācān xūhún nūū ji. Súcuán nī stéhēn yā jāá nduú cánuú chunáá yā jā cúu yā Sēhe Yāā Dios. De nī ncāhān yā: ");
INSERT INTO mieNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","De ná chúnáá ó tácua mā squítī inī ō dē. Túsaá de cuáhán yuhú mar, de squívi nú gancho jā tíin tiacá, de tavā nū tiacá jā tíin xihna cā. De ndicā nū yuhú tī, de ñúcuán nīhīn nū iin xūhún jā quenda chunáá nú jā jícān ndá dē. De quīsiáha nú nūū ndá dē jā cuu nduhū jíín ndóhó, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","De suni quīvī ñúcuán nī nquenda ndá tēe scuáha jíín yā, de nī jīcā tūhún dē yā: ¿Ní iin cúñáhnú cā nūū nchivī jā tátúnī Yāā andiví nūū? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","De nī ncana yā iin sūchí lúlí, de nī jani yā ji māhñú dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","De nī ncāhān yā: Ndāā cáhān ni jíín ndá nú, tú mā ndicó cóo inī nū cani inī nū tá cúu nūū cúu iin sūchí lúlí, de mā quívi cuitī nū ndahá Yāā andiví jā tatúnī yā nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Túsaá de nchivī jā jáni inī ji jāá nduú cúñáhnú ji, tá cúu nūū jáni inī sūchí lúlí yáhá, suu ji cúñáhnú cā nūū nchivī jā tátúnī Yāā andiví nūū. ");
INSERT INTO mieNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","De nā-ni nchivī tú jā síquī nduhū jétáhví ji iin sūchí lúlí tá cúu nūū cúu sūchí yáhá, de nduhū jétáhví ji. ");
INSERT INTO mieNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","De tú iin sūchí lúlí yáhá cándíja ji nduhū, de tú quīvi ji cuāchi sāhá nā-ni nchivī, de vāha cā de tú ní núhnī iin yōsó cáhnú sūcūn nchivī ñúcuán, de quēe ji chījin ndute mar nícu. ");
INSERT INTO mieNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nācā xēēn cúu jíín nchivī ñayīví, chi maá-ni jā ndúcú squívi nchivī nūū cuāchi íyó. De maá-ni súcuán coo inī ñayīví. De nācā xēēn cundoho nchivī jā squívi táhán nūū cuāchi. ");
INSERT INTO mieNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Túsaá de tú ndahá nú á jēhē nū sáhá jā quīvi nú cuāchi, vāha cā quehndē nū de squéne nú ná quíhīn, tácua nduú cā sāhá nú cuāchi. Chi vāha cā jā coo tícúhlu nú á coo cojo nū de quīvi nú nūū cutecū nū níí cání, nsūú cā jā coo ndúū ndahá nú de quīvi nú nūū ñúhūn jā cáyū níí cání. ");
INSERT INTO mieNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","De tú tīnūú nú sáhá jā quīvi nú cuāchi, vāha cā tavā nū de squéne nú ná quíhīn, tácua nduú cā sāhá nú cuāchi. Chi vāha cā jā coo iin-ni tīnūú nú de quīvi nú nūū cutecū nū níí cání, nsūú cā jā coo ndúū tīnūú nú de quīvi nú nūū ñúhūn infierno. ");
INSERT INTO mieNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Coto má sāhá jéhe inī ndá nú nūū ni iin ndá sūchí lúlí yáhá. Chi cáhān ni jíín nú jā ndācá ángel andiví jā jíto yā ji, níní íyó yā nūū maá Tatá nī andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Chi nduhū, Yāā nī nduu tēe, vāji nī jā scácu nī nchivī jā ní nsana ji nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿De nāsa jáni inī ndá nú? Tú iin tēe ndéca dē iin ciento tīcāchí, de tú sana iin tī, ¿de á nduú sndóo dē cūmī xico xāhōn cūmī cā tī yucu, de ndicó dē quīnanducú dē quiti jā ní nsana? ");
INSERT INTO mieNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","De tú nī nanihīn dē tī, de ndāā cáhān ni jíín nú jā cúsiī ndasí cā inī dē jíín quiti ñúcuán nsūú cā jíín cūmī xico xāhōn cūmī cā quiti jāá nduú ní nsána. ");
INSERT INTO mieNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","De suni súcuán maá Tatá nú, Yāā ndéē andiví, nduú cúnī yā jā tānū tāhvī ni iin sūchí lúlí yáhá. ");
INSERT INTO mieNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","De tú táhán nú nī nsāhá dē cuāchi sīquī nū, túsaá de cachī tūhun nú nūū mátúhún dē-ni jā ní nsāhá dē cuāchi sīquī nū. De tú nī jetáhví dē tūhun jā ní ncāhān nū jíín dē, túsaá de ja nī ndumanī dē jíín nú nī nsāhá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sochi tú nduú ní jétáhví dē jā cáhān nū, de quīcāna nú iin á ūū cā nchivī quīhīn nū jíín nūū dē, de cuu ji testigo nū tácua cundaā jā íyó cuāchi dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","De tú nduú ní jétáhví tucu dē jā cáhān ndá tēe ñúcuán, de cachī tūhun nú nūū ndá nchivī cándíja. De tú nduú ní jétáhví tucu dē jā cáhān nchivī cándíja, de siáā nū dē ná cóo dē modo iin tēe jāá nduú cándíja nūū Yāā Dios á tēe stútú xūhún renta. ");
INSERT INTO mieNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","De ndāā cáhān ni jíín nú jā ndācá jā casī nū jā má sāhá nchivī inī ñayīví yáhá, suni casī Yāā Dios jā ndéē andiví. De ndācá jā cuāha nú tūhun jā sāhá ji inī ñayīví yáhá, suni cuāha Yāā ndéē andiví tūhun. ");
INSERT INTO mieNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","De suni cáhān ni jíín ndá nú, tú ūū táhān nū inī ñayīví yáhá, inuú cani inī nū sīquī iin jā cācān táhvī nū, túsaá de maá Tatá nī andiví cuāha yā jā jícān ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chi ní-ni cúu nūū ndútútú ūū á ūnī nchivī jā chíñúhún ji nduhū, de ñúcuán íyó nī jíín ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ñúcuán de nī nquenda Pedro, de nī jīcā tūhún dē yā: Señor, ¿nāsaa vuelta cune cáhnú inī sá nūū táhán sá jā sáhá dē cuāchi sīquī sá? ¿A jondē siete vuelta, á naá cúu? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","De nī ncāhān Jesús: Nduú cáhān ni jíín nú jā siete-ni vuelta, chi jondē setenta por siete vuelta. ");
INSERT INTO mieNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Túsaá de Yāā ndéē andiví, súcuán cúu jā née cáhnú inī yā nūū nchivī jā tátúnī yā nūū: Cúu tá cúu iin rey jā cúnī dē sāhá ndāā dē jíín ndá mozo dē jā ndíta nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","De nī nquijéhé dē sáhá ndāā dē jíín ji. De nī nquisiáha ndá ji iin mozo jā ndíta quéhén millón peso nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","De nduú nā cuá névāha mozo ñúcuán jā chunáá nūū dē. De nī ndacu dē jā ná cúyāhvi mozo ñúcuán jíín ñasíhí jíín sēhe jíín ndācá ndatíñú, de nūcunáá xūhún jā ndíta dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ñúcuán de nī jēcuīñī jītí mozo, de nī ncāhān ndāhví dē jíín patrón dē: Señor, cundetu núú ní, de nachunáá ndihi sá xūhún ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","De maá patrón nī ncundáhví inī dē mozo dē. De nī nee cáhnú inī dē jā ndíta mozo dē, de nī nsiáā dē súcuán-ni jā má chúnáá cā. ");
INSERT INTO mieNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","De nī nquee mozo cuāhān dē, de nī nquetáhán dē-ni jíín iin táhán mozo dē jā ndíta jacū-ni nūū dē. De nī ntiin dē tēe ñúcuán, de nī nquitū dē sūcūn, de nī ncāhān dē: Chunáá jā ndíta nú nūū ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","De táhán mozo dē nī jēcuīñī jītí nūū dē, de nī ncāhān ndāhví jíín dē: Cundetu núú nú, de nachunáá ndihi nī xūhún nú, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sochi nduú ní ncúnī dē, chi nī nchīhi dē tēe ñúcuán vecāa jondē quīvī jā nachunáá jā ndíta nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","De ndá táhán mozo dē nī jinī jā súcuán nī nsāhá dē, de nī ntahúhvī ndasí inī ndá dē. De cuāhān ndá dē nūū patrón dē, de nī ncachī dē ndihi nāsa nī ncuu. ");
INSERT INTO mieNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sá de patrón nī nacana dē mozo ñúcuán, de nī ncāhān dē jíín: Mozo nāvāha inī cúu nú. Chi nī nee cáhnú inī ni ndihi jā ndíta nú nūū ni, chi nī ncāhān ndāhví nú jíín nī. ");
INSERT INTO mieNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","De tá cúu nūū ní ncundáhví inī ni ndóhó, suni súcuán cánuú jā cundáhví inī nū táhán mozo nū nícu, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","De nī nquītī ndasí inī patrón, de nī ndacu dē tiñu jā ná quívi vecāa jondē nachunáá ndihi jā ndíta nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","De nī jīnu tūhun yátá yáhá, de nī ncāhān cā yā: Tá cúu nūū ní nsāhá rey ñúcuán jíín mozo dē, suni súcuán sāhá maá Tatá nī andiví jíín ndá nú de tú mā cúne cáhnú inī nū nūū táhán nú jondē jíín inī jíín ánō nū, tú nā-ni cuāchi sáhá ji nūū nū, ncachī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","De tá nī ndihi nī ncāhān Jesús ndācá tūhun yáhá, de nī nquee yā Galilea cuāhān yā. De nī jīnū yā región Judea, incā lado yūte Jordán ichi nūū quénda ncandiī. ");
INSERT INTO mieNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","De cuāhā nchivī nī niquīn ji yā, de ñúcuán nī nasāhá vāha yā nchivī cúhū. ");
INSERT INTO mieNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ñúcuán de nī nquenda jacū tēe grupo fariseo nūū yā, chi cúnī ndá dē coto túnī dē yā, tú nāsa cāhān yā. De nī jīcā tūhún dē yā: ¿A íyó ley jā cuu ndusíín iin tēe jíín ñasíhí dē tú nā-ni sīquī cúu? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","De nī ncāhān yā: ¿A nduú ní ncáhvi cuitī ndá nú tutū īī nāsa nī nsāhá Yāā Dios nchivī jondē jā xíhna ñúhún? Chi tēe jíín ñahan nī nsāhá yā, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","De suni nī ncāhān Yāā Dios: Jā ñúcuán cúu jā sndóo tēe tatá dē naná dē, de quétáhán dē jíín ñasíhí dē, de iin-ni cā cúu ndúū dē, ncachī Yāā Dios, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Túsaá de nduú cā cúu ūū táhān dē, chi iin-ni cā cúu. Jā ñúcuán nduú vāha jā sndóo táhán, chi jā ní squétáhán Yāā Dios cúu, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","De nī jīcā tūhún ndá dē yā: ¿Túsaá de nūcu nī ndacu Moisés tiñu janahán jā tú sndóo iin tēe ñasíhí dē, de ná cúvāha acta jā ndusíín dē jíín ña? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","De nī ncāhān yā jíín dē: Sīquī jā nīhin inī ndá nú, jā ñúcuán nī jēhe Moisés tūhun jā sndóo nú ñasíhí nú. Sochi jā xíhna ñúhún chi nsūú súcuán ní ncúu. ");
INSERT INTO mieNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","De nduhū chi cáhān ni jíín nú, tú iin tēe sndóo dē ñasíhí dē, de tú nsūú jā ndiī ña, de quetáhán dē jíín incā ñahan, túsaá de cásíquí ndéē dē ña. De tú iin tēe nacueca dē ñahan jā ní ndōo, suni cásíquí ndéē dē ña, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ñúcuán de nī ncāhān ndá tēe scuáha jíín yā: De tú mā cūú sndóo tēe ñasíhí dē, túsaá de vāha cā mā cuēcá dē ñahan, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","De nī ncāhān yā jíín ndá dē: Tūhun jā ní ncāhān nū yáhá, chi nduú níhīn tīñú nūū ndihi tēe, chi maá-ni nūū ndá tēe jā ní nsāhá Yāā Dios jā nīhīn tīñú. ");
INSERT INTO mieNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Chi íyó quéhén sīquī jā jásī jā má cuēcá tēe ñahan. Chi sava tēe nī ncacu dē jā má cūú cundeē dē jíín ñahan. De sava cā tēe nī nsāhá nchivī jā má cūú cundeē dē jíín ñahan. De sava cā tēe nī jani inī maá dē jā má cuēcá dē ñahan sīquī jā ndíhvī inī dē jíín tiñu jā ndácu Yāā andiví nūū dē. Tēe jā cuu cuetáhví tūhun jā má cuēcá dē ñahan, ná cuétáhví dē túsaá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ñúcuán de nī nquenda ndá nchivī jíín ndá sūchí lúlí, jā tee yā ndahá yā xīnī ji de cācān táhvī yā jēhē ji. De ndá tēe scuáha jíín yā nī ncāhān dē nūū nchivī jā váji jíín ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sochi nī ncāhān Jesús: Cuāha tūhun ná quíji ndá sūchí lúlí jīñā nūū ni, de mā cásī nū jā quiji ji. Chi nchivī jā ndicó cóo inī jā cani inī ji modo ndá sūchí yáhá, suu ji cúu jā quīvi ndahá Yāā andiví jā tatúnī yā nūū ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","De nī ntee yā ndahá yā xīnī ndá ji. De nī nquee yā ñúcuán cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","De iin tēe suchí nī nquenda dē nūū Jesús, de nī jīcā tūhún dē yā: Tēe vāha cúu ní Maestro. De cachī ní, ¿nā tiñu váha sāhá sá de nīhīn táhvī sá cutecū sá níí cání andiví? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","De nī ncāhān yā jíín dē: ¿A jáni inī nū jā iin tēe-ni cúu nī jā cáhān nū tēe vāha jíín nī? Chi nduú ni iin tēe vāha íyó, chi mátúhún-ni Yāā Dios. De tú cúnī nū cutecū nū níí cání, de squíncuu nú tiñu jā ní ndacu yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","De nī ncāhān dē: ¿De nā tiñu cúu túsaá? De nī ncāhān yā: Mā cáhnī nū ndīyi. Mā cásíquí ndéē tāhán nú. Mā sácuíhná nú. Mā cáhān nū tūhun túhún. ");
INSERT INTO mieNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Cuetáhví nú nūū tatá nú nūū naná nú. De cundáhví inī nū táhán nú tá cúu nūū cúndáhví inī nū maá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","De nī ncāhān tēe suchí ñúcuán: Ndācá tiñu yáhá ja nī squíncuu sá jondē tá lulí sá. ¿De nā cuá cúu jā cúmanī cā jā sāhá sá túsaá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","De nī ncāhān Jesús: Tú cúnī nū squíncuu ndihi nú, de cuáhán de xīcó nú ndihi jā névāha nú, de cuāha nú nūū nchivī ndāhví. De jondē andiví cuāha yā jā váha ndasí nūū nū. Sá de quiji nú cuniquīn nū nduhū cōhōn, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","De tá nī jini tēe suchí tūhun yáhá, de nī ncucuécá inī dē de cuāhān dē, chi cuícá ndasí dē. ");
INSERT INTO mieNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ñúcuán de nī ncāhān Jesús jíín ndá tēe scuáha jíín yā: Ndāā cáhān ni jíín nú jā ndá tēe cuícá chi ūhvī ndasí quívi dē ndahá Yāā andiví jā tatúnī yā nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","De cáhān tucu nī jíín ndá nú jā ñamā cā yāhá iin camello yavī yitícú nsūú cā jā quīvi iin nchivī cuīcá ndahá Yāā Dios jā tatúnī yā nūū ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","De ndá tēe scuáha jíín yā nī nsāhvi ndasí inī dē jā ní jini dē tūhun yáhá, de nī jīcā tūhún táhán dē: ¿Ní nchivī cúu jā cācu túsaá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","De nī ndēhé Jesús nūū ndá dē, de nī ncāhān yā: Nchivī chi mā cūú squívi ji maá ji ndahá Yāā Dios, sochi maá yā chi ndihi-ni cuu sāhá yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ñúcuán de nī ncāhān Pedro: Señor, ndá sāán chi nī sndóo sá ndihi jā névāha sá, de níquīn sá níhín. ¿De nā cuá nīhīn sá túsaá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","De nī ncāhān Jesús jíín dē: Nduhū, Yāā nī nduu tēe, ndāā cáhān ni jíín ndá nú jā iin quīvī de cundeē ni nūū mesa nūū tatúnī ni, de viī ndasí cuñáhnú nī inī ñayīví jéé. De quīvī ñúcuán de ndá máá nú jā ní jēcuniquīn nū nduhū, suni cundeē nū nūū ūxī ūū mesa nūū tatúnī nū. De sāhá ndāā nū tiñu ndihúxī ūū tatā nchivī Israel. ");
INSERT INTO mieNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","De ndācá nchivī jā ní sndóo vehe, á ñanī, á cuāha, á tatá, á naná, á ñasíhí, á sēhe, á ñuhun, sīquī jā cuniquīn ji nduhū, de nanihīn ji iin ciento cā jā súcuán. De suni nīhīn táhvī ji cutecū ji níí cání andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sochi cuāhā nchivī jā cúu ji nūū mitan, nduu ji jā sándīhí. De nchivī jā sándīhí, nduu ji nūū. ");
INSERT INTO mieNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","De suha cúu jā tátúnī Yāā ndéē andiví nūū nchivī: Cúu tá cúu iin tēe xíñúhun. De iin stēēn nī nquee dē, ndúcú dē ndá mozo jā nastútú uva dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","De nī nsāhá ndāā dē jíín ndá mozo jā chunáá dē iin denario jā quīvī. De nī ntají dē ndá tēe ñúcuán cuāhān jā nastútú uva dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ñúcuán de nī nquee tucu dē tá cahīīn. De nī jinī dē nūū sava cā tēe jā íñí súcuán-ni nūū yáhvi. ");
INSERT INTO mieNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","De nī ncāhān dē jíín: Ndá ndóhó, suni quīhīn nū nastútú nú uva ni, de chunáá vāha nī yāhvi nú, ncachī dē. De cuāhān ndá tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","De nī nquee tucu dē tá cahūxī ūū jíín tá cahūnī, de suni súcuán nī nīhīn tucu dē mozo. ");
INSERT INTO mieNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","De jā cuácuu cahūhūn nī nquee tucu dē. De nī nīhīn tucu dē jacū cā tēe jā íñí súcuán-ni nūū yáhvi. De nī ncāhān dē jíín: ¿Nūcu íñí cāhá-ni ndá nú yáhá níí nduú? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","De nī ncāhān ndá tēe ñúcuán: Sīquī jā ni iin nduú ní ncána sāán jā satíñú sá. De nī ncāhān dē jíín: Túsaá de suni quīhīn ndá nú nastútú nú uva ni, de chunáá vāha nī yāhvi nú, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","De tá nī ñini, de tēe xíñúhun nī ncāhān dē jíín tēe cúñáhnú nūū mozo dē: Cana ndá tēe sátíñú de chunáá nú yāhvi dē, de xihna cā ndá tēe jā ní nquīvi jā sándīhí, de sá de ndá tēe jā ní nquīvi xihna ñúhún, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","De nī nquenda ndá tēe jā ní nquīvi cahūhūn jañíni. De iin denario nī nīhīn iin iin dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","De jā sándīhí de nī nquenda ndá tēe jā ní nquīvi xihna ñúhún. De jáni inī ndá dē jā cuāhā cā nīhīn dē. Sochi suni iin-ni denario nī nīhīn iin iin dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","De tá nī nīhīn dē, de nī nquijéhé ndá dē cáhān sōó dē jíín tēe xíñúhun, cáchī dē: ");
INSERT INTO mieNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ndá sāán níí nduú nī nsatíñú sá, de nī ndoho sá jā ihní. De ndá tēe yáhá jā ní nquīvi jā sándīhí, chi iin-ni hora nī nsatíñú dē. De inuú nī nchiyāhvi ní ndá sāán jíín dē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","De tēe xíñúhun nī ncāhān jíín iin dē: Amigo, nsūú jā sáhá nāvāha nī ndóhó. ¿A nduú ní nsáhá ndāā ō jā iin denario quiyāhvi nú, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Túsaá de quehen yāhvi nú de quīnohōn nū. Chi cúnī ni jā tēe jā ní nquīvi jā sándīhí yáhá, inuú chunáá nī nūū dē jíín ndá máá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿De á nduú cúu sāhá nī nāsa cúnī ni jíín xūhún maá nī? ¿De á cúcuásún inī nū jā ní nchunáá vāha nī nūū ndá dē sīquī jā vāha inī ni? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","De tá cúu nūū ní nsāhá tēe xíñúhun, suni súcuán sáhá Yāā Dios. Chi nchivī jā cúu sándīhí, nduu ji nūū. De nchivī jā cúu nūū, nduu ji jā sándīhí. Chi cuāhā nchivī cána yā jā candíja ji yā. Sochi jacū ji-ni cándíja, de suu ji cúu jā nácāji yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ñúcuán de tá nī nquehen Jesús ichi cuāhān yā Jerusalén, de nī ncana síín yā ndihúxī ūū tēe scuáha jíín yā. De nī ncāhān yā jíín dē: ");
INSERT INTO mieNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Cunini ndá nú, chi mitan de ja cuāhān ō Jerusalén, de ñúcuán nastúu nchivī nduhū, Yāā nī nduu tēe, nūū ndá sūtū cúñáhnú jíín nūū ndá tēe stéhēn ley janahán. De nenda ndá dē sīquī ni jā cuū ni. ");
INSERT INTO mieNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","De nasiáha ndá dē nduhū nūū ndá tēe nación Roma jā tátúnī jā ndéē Jerusalén. De ndá tēe ñúcuán sāhá catá dē nūū ni. De cani dē nduhū, de sá de cahnī dē nduhū yīcā cruz. Sochi nūū únī quīvī de natecū ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ñúcuán de nī nquenda ñasíhí Zebedeo nūū yā jíín sēhe ña Jacobo jíín Juan. De nī jēcuīñī jītí ña nūū yā, jícān ña iin favor nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","De nī jīcā tūhún yā ña: ¿Nā tiñu vāji ní? De nī ncāhān ña: Cuāha ní tūhun jā quīvī tatúnī ní de cundeē ndúū sēhe sá yáhá xiín ní, iin ji lado cuáhá ní, de incā ji lado sátín ní, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ñúcuán de nī ncāhān Jesús jíín Jacobo jíín Juan: Nduú jínī ndúū nū nā cuá cúu jā jícān nū. ¿A cuu cundoho nú tūndóhó tá cúu nūū quiji sīquī ni? ¿De á quenda nú cundoho xēēn nū tá cúu nūū cundoho nī? ncachī yā. De nī ncāhān ndúū dē: Cuu sāhá sá. ");
INSERT INTO mieNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","De nī ncāhān yā jíín dē: Jāndáā cúu jā ndoho nú tūndóhó tá cúu nūū quiji sīquī ni, de ndoho xēēn nū tá cúu nūū cundoho nī. Sochi jā cundeē nū lado cuáhá nī jíín lado sátín nī, nsūú nduhū cúu jā cuāha tūhun. Chi ja íyó tūha jā cuu ndá tēe jā ní nacāji Tatá nī, de tēe ñúcuán nīhīn, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","De ndihúxī cā tēe scuáha jíín yā, nī jini dē tūhun yáhá, de nī nquītī inī dē nī jinī dē ndúū ñanī ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","De Jesús nī ncana yā ndá dē, de nī ncāhān yā jíín dē: Jínī ndá nú nāsa sáhá ndá tēe jā cúñáhnú nūū nchivī ndá nación. Chi ndácu nīhin dē nūū ji, de maá dē cáchī nāsa coo. ");
INSERT INTO mieNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sochi ndá máá nú, chi mā sāhá nú súcuán. Chi tú ní iin nú cúnī nū cuñáhnú nú, de nduú chi sa sāhá nú maá nú tēe jā cuetíñú ndá táhán nú. ");
INSERT INTO mieNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","De tú ní iin nú cúnī jā cuu nú nūū, sa sāhá nú maá nú mozo nūū táhán nú. ");
INSERT INTO mieNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Chi suni súcuán sáhá maá nī, Yāā nī nduu tēe, chi nsūú jā váji nī jā cuetíñú nī nchivī, chi sa vāji nī jā cuetíñú nchivī nduhū. De cuāha nī maá nī jā cuū ni tácua scácu nī cuāhā nchivī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ñúcuán de nī nquee yā jíín ndá dē ñuū Jericó. De cuāhā ndasí nchivī nī niquīn ji yā. ");
INSERT INTO mieNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","De yuhú íchí ndéē ūū tēe cuáá. De nī jini dē tūhun jā yáha Jesús cuāhān yā, de nī ncana jee ndúū dē: Señor, maá ní jā cúu tatā rey David, cundáhví inī ní sāán, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","De ndá nchivī nī ncāhān ji nūū dē jā ná cásī ndúū dē yuhú dē. Sochi víhí cā nī ncana jee dē: Señor, maá ní jā cúu ní tatā rey David, cundáhví inī ní sāán viī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","De nī jencuiñī Jesús, de nī ncana yā ndúū tēe cuáá ñúcuán, de nī jīcā tūhún yā dē: ¿Nā cuá cúnī ndúū nū jā sāhá nī ndóhó? ");
INSERT INTO mieNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","De nī ncāhān ndúū dē jíín yā: Jā ná ndúnijīn tīnūú sá cúnī sá, Señor, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","De nī ncundáhví inī yā dē, de nī ntee yā ndahá yā tīnūú dē. De nī ndunijīn-ni tīnūú dē. De nī jēcuniquīn ndúū dē yā cuāhān dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","De tá nī ncuñatin yā ciudad Jerusalén, de nī nquenda yā jíín ndá tēe scuáha jíín yā ñuū Betfagé jā cáá jēhē yucu Olivos. De nī ntají yā ūū tēe scuáha jíín yā jā quíhīn dē. ");
INSERT INTO mieNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","De nī ncāhān yā jíín dē: Cuáhán ñuū lulí jā cáá ichi núū. De ñúcuán nīhīn nū iin burra, núhnī tī jíín iin burro lúlí. De nandají nú ndúū tī, de quiji nú jíín tī. ");
INSERT INTO mieNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","De tú ní iin cāhān jíín nú, de cachī nū jā maá Jētohō ō jíni ñúhún yā tī. Ñúcuán de siáā ji tī-ni quiji nú jíín tī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","De súcuán nī ncuu ndācá tiñu yáhá tácua quee ndaā tūhun jā ní ncāhān tēe nī nacani tūhun Yāā Dios jondē janahán, yósō nūū tutū: ");
INSERT INTO mieNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Cachī nū nūū nchivī Jerusalén jā cúu ñuū Sión: Yáhá cūndēhé nú jā váji Rey nū. Nduú sáhá ñáhnú yā maá yā, chi burra-ni yósō yā, jíín burro lúlí, sēhe quiti jíso. Cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ñúcuán de cuāhān ndúū tēe scuáha, de nī nsāhá dē tá cúu nūū ní ndacu Jesús nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","De ndéca dē burra jíín sēhe tī, nī nenda dē nūū yā. De nī nchisó ndá dē sōō dē sīquī tī, de nī jēcōsō yā tī. ");
INSERT INTO mieNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","De íyó cuāhā nchivī, de nī scáā ji sōō ji inī ichi. De sava cā ji nī jāhnū ndahá ñūū, de nī jaquīn ji inī ichi. ");
INSERT INTO mieNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","De ndá nchivī jā cuáhān ichi núū yā jíín nchivī cuáhān ichi chátā yā, cána jee ji: Cúñáhnú ndasí Yāā cúu tatā rey David. De vāha ndasí Yāā cúu yā jā váji yā jíín tiñu maá Jētohō ō Yāā Dios. De viī ndasí cúñáhnú maá Yāā Dios, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","De tá nī nquīvi Jesús Jerusalén, de ndihi nchivī nī ncuvaā ji, de cuāhā ji nī jīcā tūhún táhán ji: ¿Nā tēe cúu tēe yáhá? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","De nī ncāhān ndá nchivī jā váji jíín yā: Yāhá cúu Jesús jā nácani tūhun Yāā Dios, jā váji jondē ñuū Nazaret ndáñúū Galilea, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ñúcuán de nī nquīvi Jesús inī patio templo cāhnú Yāā Dios. De nī ntavā yā ndá nchivī jā jéen quiti de náxīcó nūū nchivī jā sōcō ji. De nī scócáva yā mesa ndá nchivī jā sáma xūhún, jíín silla ndá nchivī jā xícó paloma. ");
INSERT INTO mieNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","De nī ncāhān yā jíín ji: Yósō nūū tutū īī jā cáhān Yāā Dios: Vehe nī chi vehe nūū jícān táhvī cúu, cáchī Yāā Dios. Sochi ndá ndóhó, chi modo yavī cava jācuīhná nī nasāhá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ñúcuán de sava nchivī cuāá jíín nchivī cojo nī nquenda ji nūū yā inī templo. De nī nasāhá vāha yā ji. ");
INSERT INTO mieNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","De ndá sūtū cúñáhnú jíín ndá tēe stéhēn ley janahán, nī jinī dē ndācá tiñu ñáhnú jā sáhá yā, de nī jini dē jā cána jee ndá sūchí lúlí inī templo: Cúñáhnú ndasí Yāā cúu tatā rey David, cáchī ji. De nī nquītī inī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","De nī ncāhān dē jíín yā: ¿A nduú jíni nú jā súcuán cáhān ndá sūchí yáhá? ncachī dē. De nī ncāhān Jesús jíín dē: Jíni nī. ¿De á ncháha ca cahvi ndá nú jā yósō nūū tutū īī jā suha cáhān iin tēe jíín Yāā Dios? Sāhá ní jā ndá sūchí lúlí jíín sūchí jáxīn, vāha ndasí cāhān ji jā Yāā cúñáhnú cúu Cristo. Cáchī. ");
INSERT INTO mieNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","De nī sndóo yā dē. De nī nquee yā Jerusalén, de cuāhān yā ñuū Betania. De ñúcuán nī ndōo yā jacuáā ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","De jānehēn quīvī téēn cuānohōn yā Jerusalén, de cócon yā. ");
INSERT INTO mieNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","De nī jinī yā iin ñutun higo jā íñí yuhú íchí. De nī jēhēn yā jēhē. De nduú nā higo ní níhīn yā, chi maá yūcū-ni cúu. De nī ncāhān yā jíín: Mitan de mā cūún cuitī cā jāvíxī xīnī nū, ncachī yā. De nī nchīchī-ni ñutun higo ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","De ndá tēe scuáha jíín yā, nī nsāhvi inī dē nī jinī dē. De nī jīcā tūhún dē yā: ¿Nāsa nī nsāhá ní jā ñamā nī nchīchī ñutun higo? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","De nī ncāhān yā jíín dē: Ndāā cáhān ni jíín ndá nú, tú candíja nú de mā cāní síquí inī nū, de cuu sāhá nú tiñu ñáhnú tá cúu nūū ní nsāhá nī jíín ñutun higo. De jondē tiñu ñáhnú cā cuu sāhá nú, chi jondē cuu cāhān nū jā cujiyo yucu yáhá quīhīn nūū mar, de sāhá tá cáchī nū. ");
INSERT INTO mieNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","De ndācá jā jícān táhvī ndá nú, de tú cándíja nú jā nīhīn nū, de nīhīn nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","De nī nquīvi tucu yā inī templo cāhnú. De juni stéhēn yā tūhun, de ndá sūtū cúñáhnú jíín ndá tēe ñáhnú jā ndácu tiñu nūū nchivī hebreo, nī nquenda dē nūū yā. De nī jīcā tūhún dē yā: ¿Ní jondē nī nīhīn tīñú nú jā sáhá nú tiñu yáhá? ¿De ní iin nī ntee tiñu ndóhó jā sáhá nú súcuán? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","De nī ncāhān Jesús: Saá-ni nduhū suni cātūhún nī ndá nú iin tūhun, de tú cuu scócóo nú, ñúcuán de cachī ni nūū nū ní jondē nī nīhīn tīñú nī jā sáhá nī tiñu yáhá. ");
INSERT INTO mieNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ní iin nī ntee tiñu sīquī Juan jā ní scuénduté dē? ¿A Yāā Dios á ndá tēe? ncachī yā. Ñúcuán de nī natúhún ndá máá dē: Tú cachī ō jā Yāā Dios nī ntee tiñu ñúcuán sīquī Juan, de cāhān dē jíín ó: ¿Túsaá de nūcu nduú ní ncándíja ndá nú jā ní ncāhān dē? ");
INSERT INTO mieNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","De tú cāhān ō jā nchivī nī ntee tiñu sīquī dē, de yúhú ó nchivī, chi ndiviī ji cándíja ji jā tēe nī nacani tūhun Yāā Dios nī ncuu ndija Juan, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","De nī ncāhān dē jíín Jesús: Nduú jínī ndá nī, ncachī dē. Ñúcuán de nī ncāhān yā jíín dē: De saá-ni nduhū, suni mā cāchí nī nūū nū ní iin nī ntee tiñu sīquī ni jā sáhá nī tiñu yáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","De nī ncāhān cā yā jíín ndá dē: Cunini ndá nú tūhun yátá yáhá: Iin tēe nī īyo ūū sēhe yií dē. De nī ncāhān dē jíín iin ji: Séhē, cuáhán satíñú nú chi nastútú nú uva ni mitan, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","De nī ncāhān ji: Mā quíhīn sá, ncachī ji. De nī ncunúú, de nī nacani inī ji, de cuāhān ji nūū tiñu ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","De tēe ñúcuán nī jēhēn dē nūū incā sēhe dē, de suni súcuán nī ncāhān dē jíín ji. De nī ncāhān ji: Ajan táā, de quīhīn sá túsaá, ncachī ji. Sochi nduú ní jéhēn ji. ");
INSERT INTO mieNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿De nāsa jáni inī ndá nú? Jā ndúū ji, ¿ní iin ji nī squíncuu tiñu cúnī tatá ji? ncachī yā. De nī ncāhān ndá dē: Sūchí jā ní ncāhān dē jíín xihna cā, ncachī dē. De nī ncāhān Jesús jíín dē: Saá, de ndāā cáhān ni jíín nú jā ndá tēe stútú xūhún renta jíín ndá ñahan ndiī, ñamā nácani inī ji jā sndóo ji cuāchi ji de quīvi ji ndahá Yāā Dios jā tatúnī yā nūū ji, de ndá máá nú chi mā quívi nú. ");
INSERT INTO mieNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chi nī nquiji Juan, nī stéhēn dē nāsa squíncuu nú tūhun ndāā, de nduú ní ncándíja ndá nú tūhun jā ní ncāhān dē. De sa ndá tēe stútú xūhún renta jíín ndá ñahan ndiī, nī ncandíja ji tūhun jā ní ncāhān dē. De ndá máá nú, vísō nī jinī nū jā ní ncandíja ji, sochi nduú ní nácani cuitī inī nū jā candíja nú. ");
INSERT INTO mieNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Cunini ndá nú incā tūhun yátá: Nī īyo iin tēe xíñúhun. De nī nchuhun dē cuāhā yūcū uva. De nī jasī dē corral, de nī nsāhá dē iin nūū cāxīn dē uva. De nī nsāhá dē iin vehe súcún tácua cuu coto dē níí cáhnú. De nī sndóo dē nūū sava tēe jā satíñú nūū, de cuu sava dē ndīhā jíín. De nī nquehen dē ichi cuāhān jīcá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","De maá tiempo jā ndutútú uva, de nī ntají dē jacū mozo cuāquēhen sava ndīhā uva nūū ndá tēe sátíñú. ");
INSERT INTO mieNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","De ndá tēe ñúcuán nī ntiin dē mozo. De iin ji nī ncani ndá dē, de incā ji nī jahnī dē, de incā ji nī ncani dē yūū xīnī. ");
INSERT INTO mieNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","De tēe xíí uva nī ntají tucu dē cuāhā cā mozo cuāhān nsūú cā jā xíhna ñúhún. De suni súcuán nī nsāhá ndá tēe ñúcuán jíín ndihi mozo ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","De jā sándīhí da, de nī ntají dē sēhe dē cuāhān. Chi jáni inī dē jā cuetáhví ndá tēe ñúcuán sēhe dē. ");
INSERT INTO mieNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sochi ndá tēe sátíñú, tá nī jinī dē nūū sēhe tēe xíí uva, de nī ncāhān ndá máá: Tēe xíí táhvī cúu yáhá. Ná cáhnī ō ji, de ndōo tāhvī ji cuu ó, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","De nī ntiin ndá dē ji, de nī ntavā dē ji incā lado, de nī jahnī dē ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ñúcuán de nī jīcā tūhún yā dē: Túsaá de tá quenda tēe xíí uva, ¿de nāsa sāhá dē jíín ndá tēe sátíñú? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","De nī ncāhān ndá dē jíín yā: Mā cúndáhví cuitī inī dē ndá tēe jā ní nsāhá tiñu néhén ñúcuán, chi cahnī dē. De cuāha dē ñuhun cáá uva nūū sava cā tēe jā satíñú nūū, cuu sava dē ndīhā jíín. De quīvī ndutútú ndīhā, de ndá tēe ñúcuán nacuāha dē sava ndīhā nūū tēe xíí uva, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","De nī ncāhān Jesús jíín dē: ¿De á ncháha ca cahvi ndá nú tūhun yáhá jā yósō nūū tutū īī, jā nduhū cúu tá cúu iin yūū? Chi cáchī tutū: Yūū jā ní squéne yichī ndá tēe jā sáhá vehe, maá yūū yáhá nduu jā quituu squínā vehe. Maá Jētohō ō Yāā Dios nī nsāhá yā súcuán, de sáhvi inī ō jínī ō tiñu yáhá. Cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Túsaá de cáhān ni jíín ndá nú jā cujiyo-ni jā tátúnī Yāā Dios nūū ndá nú, de nacuāha yā tiñu nūū incā nchivī jā squíncuu vāha ji tiñu ndácu yā tá cúu nūū cúnī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","De nchivī jāá nduú cándíja, ndoho ji tá cúu nūū ndóho nchivī jā jícó cáva sīquī yūū de táhnū ji. De quīvī jā sāhá ndāā Yāā Dios cuāchi, de nchivī jāá nduú ní ncándíja, cundoho ji tá cúu nūū ndóho nchivī jā níncava iin yūū sīquī ji de cúndihī ji sáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","De ndá sūtū cúñáhnú jíín ndá tēe grupo fariseo nī jini dē ndá tūhun yátá jā ní ncāhān yā. De nī jīcūhun inī dē jā sīquī ndá máá dē cúu jā ní ncāhān yā tūhun yátá sīquī ndá tēe sátíñú nūū uva jíín tēe sáhá vehe. ");
INSERT INTO mieNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","De nī nducú ndá dē modo jā tiin dē yā. Sochi yúhú dē jā quītī inī nchivī, chi jáni inī ndá ji jā tēe nácani tūhun Yāā Dios cúu yā. ");
INSERT INTO mieNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ñúcuán de nī ncāhān tucu Jesús incā tūhun yátá jíín ndá dē: ");
INSERT INTO mieNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Súcuán cúu jā tátúnī Yāā andiví nūū nchivī: Cúu tá cúu iin rey jā sāhá dē iin vico jā tandāhá sēhe yií dē. ");
INSERT INTO mieNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","De nī ntají dē ndá mozo dē cuācāna nchivī jā ní ncāhān dē jíín. De ndá máá ji nduú ní ncúnī ji quīhīn ji. ");
INSERT INTO mieNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","De nī ntají tucu dē jacū cā mozo, de nī ncachī dē: Cāhān jíín nchivī jā ní ncana nī, ja íyó tūha ndeyu. Chi ja nī jahnī ni stīquī ni jíín ndá cā quiti jā ní nduu, de ndihi ja íyó tūha. Nehēn ndá nú vico tándāhá. Cachī nū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","De ndá nchivī jā ní ncana dē nduú ní nsáhá ji cuenta. Chi iin ji cuāhān nūū itū ji, de incā ji cuāhān nūū tiñu sáhá ji. ");
INSERT INTO mieNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","De sava cā ji nī ntiin ji ndá mozo rey, de nī nsāhá sácá ji nūū, de nī jahnī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ñúcuán de nī nquītī ndasí inī rey. De nī ntají dē ndá soldado dē nī jēhēn dē, nī jahnī dē ndá nchivī jā ní jahnī ndá ndīyi ñúcuán, de nī nteñuhūn dē ñuū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ñúcuán de nī ncāhān rey jíín sava cā mozo dē: Ndihi ja íyó tūha jā coo vico tándāhá. Sochi nchivī jā ní ncana nī, nsūú nchivī vāha cúu ji jā quiji ji vico. ");
INSERT INTO mieNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Túsaá de cuáhán ndá nú ndācá ichi cáhnú cā, de cana nú nāsaa nchivī nīhīn nū, ná quíji ndá ji vico tándāhá. Ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","De nī nquee ndá mozo cuāhān ndācá ichi. De nī nastútú dē ndihi nchivī jā ní nīhīn dē, cúu nchivī nēhén, cúu nchivī vāha. De súcuán nī nchitú nchivī inī vehe nūū íyó vico tándāhá. ");
INSERT INTO mieNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","De nī nquīvi rey inī vehe jā cāhān dē jíín nchivī jā ní ncutútú. De nī jinī dē nūū iin tēe jāá nduú ñúhún sahma jā ní jēhe dē cuhun nchivī jā quiji vico tándāhá. ");
INSERT INTO mieNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","De nī ncāhān dē jíín tēe ñúcuán: Amigo, ¿nāsa nī nquīvi nú yáhá jāá nduú ñúhún nú sahma vico tándāhá? ncachī dē. De tēe ñúcuán nduú ní ncáhān cuitī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ñúcuán de nī ncāhān rey jíín ndá tēe jícó ndíso cōhō: Tiin ndá nú dē, cuhnī nū ndahá dē jēhē dē, de tavā nū dē ná quíhīn dē nūū neē tāvēhé. De ñúcuán cuacu dē de nacayīhí dē ñii yúhú dē jā ndoho ndasí dē. Ncachī rey. ");
INSERT INTO mieNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Chi cána Yāā Dios cuāhā nchivī jā ná cándíja ji. Sochi jacū ji-ni cándíja, de suu ji nácāji yā, ncachī Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ñúcuán de cuāhān ndá tēe fariseo, de nī natúhún dē tú nāsa sāhá dē tácua cāhān yā iin tūhun jā nīhīn dē cuāchi sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","De nī ntají dē jacū tēe scuáha jíín maá dē jíín tēe grupo Herodes cuāhān dē. De nī ncāhān ndá dē jíín yā: Maestro, jínī ndá sá jā tēe cáhān ndāā cúu ní, de stéhēn ndāā ní nāsa squíncuu nchivī nūū Yāā Dios. De nduú yúhú ní jā cāhān ni iin nchivī sīquī ní, chi nduú sáhá ní cuenta nāsa cúu iin iin ji, chi inuú-ni sáhá ní jíín ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Túsaá de cāhān ní nāsa jáni inī ní: ¿A íyó vāha jā chunáá ó renta nūū rey nación Roma jā tíin nación maá ó, á nduú? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","De nī jinī Jesús jā ndúcú ndá dē iin cuāchi sīquī yā. De nī ncāhān yā jíín dē: Vāchi tēe stáhví-ni cúu ndá nú. ¿Nājēhē cúu jā jíto túnī nū nduhū? ");
INSERT INTO mieNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Stéhēn xūhún jā jécunáá renta ná cúndēhé nī, ncachī yā. De nī stéhēn ndá dē iin denario nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","De nī ndēhé yā, de nū jīcā tūhún yā dē: ¿Nā tēe cúu jā ndéē nūū xūhún yáhá, de nā síví cúu jā ndéē yáhá? ");
INSERT INTO mieNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","De nī ncāhān ndá dē jíín yā: Rey ñúcuán cúu. Ñúcuán de nī ncāhān yā jíín ndá dē: Túsaá de nacuāha nú nūū rey ñúcuán jā cúu cuenta dē, de nacuāha nú nūū Yāā Dios ndācá jā cúu cuenta maá yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","De tá nī jini ndá dē jā ndíchí nī ncāhān yā tūhun yáhá, de nī nsāhvi inī dē, de nī sndóo dē yā, de cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","De suni quīvī ñúcuán nī nquenda jacū tēe grupo saduceo nūū yā. De ndá tēe ñúcuán cáchī dē jāá nduú nátecū cuitī ndīyi. De nī ncāhān dē jíín yā sīquī iin tūhun: ");
INSERT INTO mieNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Maestro, de Moisés nī ncāhān dē jā tú iin tēe cuū dē, de ndōo ñasíhí dē, de tú nduú ní íyo sēhe dē jíín ña, túsaá de cánuú jā ñanī dē nacueca ñasíhí dē, de sēhe dē jā coo jíín ña, nūcuīñī ji nūū ndīyi ñanī dē. Cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","De ñuū sá nī īyo ūjā ñanī. De tēe xíhna ñúhún nī jeca dē iin ñahan. De nī jīhī dē. De sīquī jāá nduú nā sēhe dē ní íyo, de nī ndōo ñasíhí dē nūū ñanī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","De tēe ūū suni nī jīhī dē, de nduú nā sēhe dē ní íyo tucu. De saá-ni tēe ūnī, jondē jíín ndihújā dē. ");
INSERT INTO mieNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","De tá nī ndihi dē nī jīhī, de suni nī jīhī ñahan ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Túsaá de quīvī natecū ndīyi, ¿ní iin dē cuu ña ñasíhí dē? Chi ndihújā dē nī ndeē jíín ña, ncachī ndá dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ñúcuán de nī ncāhān yā jíín dē: Ndasí stíví ndá nú tūhun sīquī jāá nduú jícūhun inī nū jā cáhān tutū īī, de ni nduú jínī nū jā íyó poder Yāā Dios jā nastécū yā ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Chi quīvī jā natecū ndá ndīyi, de nduú cā nā tūhun quetáhán tēe jíín ñahan coo. Chi coo ndá ji tá cúu ndá ángel Yāā Dios andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","De sīquī jā natecū ndīyi, ¿á nduú ní ncáhvi ndá nú tutū nāsa cáhān Yāā Dios jíín nú? ");
INSERT INTO mieNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Maá nī cúu Yāā Dios Abraham jíín Isaac jíín Jacob, cáchī yā. Chi vísō ja nī jīhī ndá dē, sochi técū dē nūū íyó maá yā, chi cúu yā Yāā jā sáhá jā técū nchivī níí cání, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","De ndá nchivī nī nsāhvi inī ji níni ji tūhun stéhēn yā. ");
INSERT INTO mieNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ñúcuán de ndá tēe grupo fariseo nī jinī dē jā ní jasī ndá tēe saduceo yuhú dē nī nsāhá yā. De nī ndutútú ndá dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","De iin dē jā cúu tēe stéhēn ley janahán nī jīcā tūhún dē yā, chi coto túnī dē yā cúnī dē: ");
INSERT INTO mieNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Maestro, ¿ní iin cúu tūhun jā ndácu tiñu jā cánuú ndasí cā nūū tutū ley? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","De nī ncāhān Jesús jíín dē: Coo manī ndasí nú jíín maá Jētohō nū Yāā Dios, jondē jíín inī jíín ánō nū, jíín níí jāá ntúnī nū, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yáhá cúu tūhun ndácu yā jā cúñáhnú cā de cánuú ndasí cā. ");
INSERT INTO mieNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","De tūhun ūū jā ní ndacu yā, suni súcuán cáhān: Cundáhví inī nū táhán nú tá cúu nūū cúndáhví inī nū maá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","De chījin ndúū tūhun yáhá nī nquee ndihi ley jā ní ntee Moisés, jíín ndihi jā ní stéhēn ndá tēe nī nacani tūhun Yāā Dios, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","De juni íyó tútú cā ndá tēe fariseo ñúcuán, de Jesús nī jīcā tūhún yā dē: ");
INSERT INTO mieNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Nāsa jáni inī ndá nú sīquī Cristo? ¿Nā nūū tatā quiji yā, cáchī tutū? ncachī yā. De nī ncāhān ndá dē: Nūū tatā David, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","De nī ncāhān yā jíín dē: ¿Túsaá de nāsa cúu jā David nī ncāhān dē Jētohō dē yā, nī nsāhá Espíritu Santo jondē janahán? Chi nī ncāhān dē: ");
INSERT INTO mieNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Maá Jētohō ō Yāā Dios nī ncāhān yā jíín Jētohō ni, Yāā jā quiji: Cundeē nū lado cuáhá nī nūū cuñáhnú nú, de ná sáhá nī jā candeē nū poder ndācá jā jínī ūhvī ndóhó. Ncachī Yāā Dios. Ncachī David. ");
INSERT INTO mieNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Túsaá de vísō chījin tatā David cacu Cristo, de nī ncāhān dē Jētohō dē yā, chi jondē nūū Yāā Dios vāji yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","De ni iin dē nduú ní ncúu scócóo dē tūhun nūū yā. De jondē quīvī ñúcuán de nduú cā ní ncúndéé inī ni iin dē jā cātūhún dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ñúcuán de nī ncāhān Jesús jíín ndá nchivī jíín ndá tēe scuáha jíín yā: ");
INSERT INTO mieNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ndá tēe stéhēn ley janahán jíín ndá tēe grupo fariseo, jáni inī dē jā ndíso tíñú dē jā stéhēn dē ley jā ní jēhe yā nūū Moisés. ");
INSERT INTO mieNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Túsaá de cuetáhví nú dē squíncuu nú ndācá jā ndácu dē nūū nū. Sochi mā sāhá nú tá cúu nūū sáhá ndá máá dē. Chi cáhān dē-ni, sochi nduú squíncuu dē. ");
INSERT INTO mieNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Chi suni stéhēn ndá dē ndācá ley jā ní ntavā maá dē jā víjín sáhá, de tée dē sīquī nchivī, de nduú cúndeé ji squíncuu ji. Sochi ndá máá dē chi ni iin xīnī ndāhá dē nduú scándā dē jā squíncuu dē. ");
INSERT INTO mieNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","De maá-ni sīquī jā ná cuétúhún nchivī dē cúu ndihi jā sáhá dē. Chi jétahān inī ndá dē cuhnī dē cuāhā tūhun tutū īī teēn dē jíín ndahá dē. De suni sáhá cání cā dē yūhvā yuhú sáhmá dē jā stéhēn jā cúñáhnú cā dē nsūú cā incā nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","De jétahān inī ndá dē cundeē dē nūū silla yíñúhún cā nūū yájī nchivī vico, jíín silla yíñúhún cā inī vehe īī sinagoga. ");
INSERT INTO mieNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","De suni jétahān inī dē jā cáhān yíñúhún nchivī dē nūū yáhvi, jíín jā cáhān ji maestro jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Sochi ndá máá nú, mā cuáha nú tūhun jā cāhān nchivī maestro jíín nú. Chi inuú cúu ndihi nú jā cúu nú hermano, de íyó iin-ni Maestro nū jā cúu nduhū, Cristo. ");
INSERT INTO mieNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","De mā chíñúhún nú ni iin tēe ñayīví yáhá jā cāhān nū padre jíín dē. Chi íyó mátúhún-ni Padre ndá nú, Yāā ndéē andiví. ");
INSERT INTO mieNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","De suni mā cuáha ndá nú tūhun jā cāhān ji jētohō ji ndóhó. Chi íyó iin-ni Jētohō nū, de suu cúu nduhū, Cristo. ");
INSERT INTO mieNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","De tēe jā íyó māhñú ndá nú jā chíndeé nūū táhán, suu dē cúu jā cúñáhnú cā. ");
INSERT INTO mieNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chi tēe jā sáhá ñáhnú maá, sa nuu dē. De tēe jā sáhá núu maá, sa nduñáhnú dē. ");
INSERT INTO mieNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nācā xēēn cundoho ndá nú tēe stéhēn ley janahán, jíín ndá nú tēe fariseo, chi tēe stáhví-ni cúu nú. Chi jásī nū jā quīvi nchivī ndahá Yāā andiví jā tatúnī yā nūū ji. Chi nduú quívi ndá máá nú, de ni nduú jéhe nú tūhun jā quīvi nchivī jā ndúcú quīvi. ");
INSERT INTO mieNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nācā xēēn cundoho ndá nú tēe stéhēn ley janahán, jíín ndá nú tēe fariseo, chi tēe stáhví-ni cúu nú. Chi cándeē nū vehe ndá ñahan nī nquendōo ndáhví. Ñúcuán de náhán jícān táhvī nū tácua cani inī nchivī jāá nduú nā cuāchi nú. Jā ñúcuán xēēn cā cundoho nú castigo. ");
INSERT INTO mieNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nācā xēēn cundoho ndá nú tēe stéhēn ley janahán, jíín ndá nú tēe fariseo, chi tēe stáhví-ni cúu nú. Chi níí ñuhun yíchí jíín níí mar jíca nuu nú ndúcú nú iin nchivī jā scándíja nú sāhān maá nú. De tá nī ncandíja ji, de sáhá ndá nú jā víhí cā cuu cuāchi ji jā quīhīn ji infierno nsūú cā ndá máá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nācā xēēn cundoho ndá nú, chi cúu nú tá cúu tēe cuáá jā stéhēn ichi nūū nchivī. Chi cáhān ndá nú: Tú ní tēe cáhān téyíí dē jā Yāā Dios jā ndéē inī templo ná cuáha yā castigo tú mā squíncuu dē iin tiñu, túsaá de va nduú cánuú squíncuu dē. Sochi tú cáhān dē jā Yāā Dios jā xíí oro jā íyó inī templo, ná cuáha yā castigo tú mā squíncuu dē iin tiñu, túsaá de cánuú jā squíncuu nahñí dē, cáhān ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tēe naā tēe cuáá cúu ndá nú jā stíví nú tūhun cáhān nū. ¿Ní iin cúu jā cúñáhnú cā, á oro, á Yāā Dios jā ndéē inī templo jā sáhá īī oro ñúcuán? ");
INSERT INTO mieNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","De suni cáhān ndá nú: Tú ní tēe cáhān téyíí dē jā Yāā Dios jā xíí altar ná cuáha yā castigo tú mā squíncuu dē iin tiñu, túsaá de va nduú cánuú squíncuu dē. Sochi tú cáhān dē jā Yāā Dios jā xíí ndatíñú jā sócō ndá nūū altar, ná cuáha yā castigo tú mā squíncuu dē iin tiñu, túsaá de cánuú squíncuu nahñí dē, cáhān ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tēe naā tēe cuáá cúu ndá nú jā stíví nú tūhun cáhān nū. ¿Ní iin cúu jā cúñáhnú cā, á ndatíñú jā íñí nūū altar, á Yāā Dios jā sáhá īī ndatíñú ñúcuán? ");
INSERT INTO mieNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Túsaá de tēe jā cáhān téyíí, tú nacunehen dē Yāā Dios jā xíí altar, túsaá de suni nácunehen dē jondē jíín ndatíñú jā íñí nūū altar. ");
INSERT INTO mieNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","De tú iin tēe nácunehen dē templo jā cáhān téyíí dē, túsaá de jondē jíín Yāā Dios jā ndéē inī templo nácunehen dē. ");
INSERT INTO mieNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","De tú iin tēe nácunehen dē andiví jā cáhān téyíí dē, túsaá de suni nácunehen dē mesa Yāā Dios de jondē jíín maá Yāā Dios jā ndéē nūū mesa. ");
INSERT INTO mieNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nācā xēēn cundoho ndá nú tēe stéhēn ley janahán, jíín ndá nú tēe fariseo, chi tēe stáhví-ni cúu nú. Chi sáhá ndá nú ūxī ūxī nuhnī mīnu jíín yūcū anís jíín yūcū comino, de sócō nū iin iin jā úxī nūū Yāā Dios. Sochi sndóo nú tūhun cánuú ndasí cā nūū ley, suu jā caca ndaā nū, jíín jā cundáhví inī nū táhán nú, jíín jā candíja nú. Ndācá yáhá cánuú jā sāhá nú nícu, de suni mā sndóo nú jā sōcō nū ndá yūcū ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Cúu ndá nú tá cúu tēe cuáá jā stéhēn ichi nūū nchivī. Chi squíncuu nú iin jā lūlí cā ñúcuán, de sndóo nú jā cánuú cā. De suu cúu modo jā távā nū iin tiucún lúlí jā ñúhún nūū ndūxi, de cócó nú iin quiti cáhnú jā cúu camello. ");
INSERT INTO mieNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nācā xēēn cundoho ndá nú tēe stéhēn ley janahán, jíín ndá nú tēe fariseo, chi tēe stáhví-ni cúu nú. Chi modo jā náquete nú yātā vaso jíín yātā cōhō. Sochi ichi ínī nū chi ñúhún maá-ni tūhun cuíhná jíín tūhun ndíyo inī. ");
INSERT INTO mieNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tēe cuáá cúu ndá nú, fariseo. Xihna cā sāhá nú jā coo ndoo inī ánō nū, de ñúcuán de suni coo ndoo ndācá jā sáhá nú jā jínī nchivī nūū. ");
INSERT INTO mieNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nācā xēēn cundoho ndá nú tēe stéhēn ley janahán, jíín ndá nú tēe fariseo, chi tēe stáhví-ni cúu nú. Chi cúu ndá nú tá cúu namā ndīyi panteón jā íyó yaa. Chi ichi chátā de viī cáá, sochi ichi ínī ñúhún chitú yiqui ndíyi jíín ndācá jā tēhyú. ");
INSERT INTO mieNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","De suni súcuán cúu ndá máá nú, chi ichi chátā nū sáhá nú jā tēe ndāā cúu ndá nú nūū nchivī. Sochi ichi ínī nū ñúhún chitú tūhun stáhví-ni jíín tūhun nēhén. ");
INSERT INTO mieNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nācā xēēn cundoho ndá nú tēe stéhēn ley janahán, jíín ndá nú tēe fariseo, chi tēe stáhví-ni cúu nú. Chi sáhá ndá nú namā ndá ndīyi tatā nū, tēe nī nacani tūhun Yāā Dios jondē janahán. De sáhá viī ndá nú sīquī namā nūū yíyuhū ndá tēe jā ní īyo ndāā. ");
INSERT INTO mieNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","De cáhān ndá nú: Tú ní ntécū ndācá ó tiempo jā ní ntecū ndá ndīyi tatā ō, de mā squívi nduū ō jíín dē jā cahnī ō ndá tēe nī nacani tūhun Yāā Dios, cáchī nū. ");
INSERT INTO mieNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","De súcuán cáhān ndāā ndá nú jā maá nú cúu tatā ndá nchivī jā ní jahnī ndá tēe nī nacani tūhun yā. ");
INSERT INTO mieNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","De ndācá cuāchi jā ní squíjéhé ndá ndīyi tatā nū, suni súcuán sāhá cā ndá máá nú túsaá. ");
INSERT INTO mieNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Va sēhe cōō cúu ndá nú, chi xēēn nū tá cúu cōō. ¿Nāsa cācu nú jā má tánū tāhvī nū quīhīn nū infierno? ");
INSERT INTO mieNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Túsaá de tají nī ndá tēe nacani tūhun Yāā Dios nūū nū, jíín ndá tēe ndíchí jā stéhēn tūhun yā. De sava dē cahnī nū, de sava dē cata caa nú yīcā cruz. De sava cā dē cani nú dē inī ndācá vehe īī sinagoga, de scúnu nú dē quīhīn dē ndācá-ni ñuū. ");
INSERT INTO mieNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","De súcuán de cundeē cuāchi sīquī ndá nú jā ní jahnī tatā nū ndācá tēe ndāā, xihna cā Abel tēe ndāā, de sá de jondē Zacarías sēhe Berequías, tēe jā ní jahnī ndá dē inī templo sava māhñú cuarto īī jíín altar. ");
INSERT INTO mieNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jāndáā cáhān ni jíín nú jā ndācá cuāchi yáhá cundeē sīquī nchivī jā íyó mitan. ");
INSERT INTO mieNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ndá ndóhó nchivī Jerusalén, jáhnī nū ndá tēe nácani tūhun Yāā Dios, de cáni nú yūū xīnī ndá tēe jā tájí Yāā Dios vāji nūū nū. De cuāhā vuelta nī ncuu inī ni nastútú nī sēhe nú, tá cúu nūū sáhá iin ñihín jā nástútú tī sēhe tī chījin nījīn tī, sochi nduú ní ncúnī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Túsaá de mitan de sndóo uun nī ndóhó jíín ndá sēhe nú. ");
INSERT INTO mieNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chi cáhān ni jíín nú jā jondē mitan de mā cūní cuitī cā nū nūū ni, chi jondē quenda quīvī jā cāhān ndá sēhe nú: Vāha ndasí Yāā cúu Yāā jā ní nenda jíín tiñu maá Jētohō ō Yāā Dios, cachī ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","De nī nquee Jesús inī templo cāhnú cuāhān yā. De nī nquenda ndá tēe scuáha jíín yā, de nī ncāhān dē jíín yā sīquī ndācá vehe jā ndéē tāhán jā cúu templo. ");
INSERT INTO mieNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","De nī ncāhān yā jíín ndá dē: Ndācá jā ndéhé nú yáhá, ndāā cáhān ni jíín nú jā quiji quīvī jā má cósō tāhán cā ni iin yūū, chi ndihi tānī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","De cuāhān yā jíín ndá tēe scuáha jíín yā jondē yucu Olivos, de nī jēcundeē yā ñúcuán. De nī nquenda ndá dē nūū yā, de nī jīcā tūhún síín dē yā: Cachī tūhun ní nūū sá, ¿nā quīvī coo ndācá jā ní ncachī ní jā coo? ¿De nā seña coo tá ja ncuñatin quīvī nenda ní jíín jā jīnu ñayīví? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","De nī ncāhān Jesús: Coto má stáhví ni iin dē ndá ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Chi quiji cuāhā tēe jíín síví nī jā stáhví: Maá nī cúu Cristo, cachī dē. De súcuán de stáhví dē cuāhā nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","De nīhīn nū tūhun jā ndācá lado íyó guerra, á ja ñatin coo guerra. De mā cúyūhú nú, chi cánuú jā súcuán coo, sochi ncháha ca quenda quīvī jā ndihi ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chi nenda nación sīquī incā nación, de nenda ñuū sīquī incā ñuū jā canāá. De coo tāmā jíín cuēhē xēēn. De cháhá chúcuán tāan. ");
INSERT INTO mieNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","De ndācá yáhá cúu tūndóhó jā quijéhé xihna ñúhún cā. ");
INSERT INTO mieNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ñúcuán de nastúu ji ndá ndóhó jā sndóho ji ndóhó de cahnī ji. De ndihi nchivī quītī inī ji nūū nū jā síquī nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","De quīvī ñúcuán chi cuāhā nchivī jā cándíja, caca yátá ji, de quītī inī ji nūū táhán ji, de nastúu táhán ji. ");
INSERT INTO mieNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","De quenda cuāhā tēe stáhví, de cāhān dē jā tūhun Yāā Dios nácani dē, de stáhví dē cuāhā nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","De jā nducuahā tiñu néhén, de jā ñúcuán cuāhā ji mā cōó mānī cā ji. ");
INSERT INTO mieNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sochi nchivī jā cuiñi nīhin jíín tūhun nī jondē quīvī jīnu, nchivī ñúcuán chi cācu. ");
INSERT INTO mieNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","De tūhun vāha yáhá jā nāsa tátúnī Yāā Dios, cūtē nuu níí cáhnú ñayīví, tácua cunī nchivī ndācá nación. Ñúcuán de jīnu ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","De Daniel, tēe nī nacani tūhun Yāā Dios, nī ntee dē tūhun iin tēe nēhén jā quiji. De ndá ndóhó jā cáhvi tutū ñúcuán, de ná jícūhun inī nū. Chi iin quīvī de cunī nū jā sāhá nāvāha dē jā stíví dē ndācá ndatíñú īī inī templo, de cuiñi dē inī lugar īī. ");
INSERT INTO mieNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","De tá cunī ndá nú jā súcuán cúu, de nchivī ndéē región Judea, ná cúnu ji caa ji yucu quīhīn ji. ");
INSERT INTO mieNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","De nchivī ndéē yātā vēhé, mā ndívi ji inī vehe jā tavā ji ndatíñú ji, chi cánuú jā cunu ñamā ji tácua cācu ji. ");
INSERT INTO mieNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","De nchivī íyó nūū itū, mā nóhōn ji vehe jā naquehen ji sahma ji. ");
INSERT INTO mieNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","De quīvī ñúcuán, nācā ndáhví ndoho ndá ñahan ñúhún sēhe jíín jā ndéca ñiquín, chi mā cúñamā ña cunu ña. ");
INSERT INTO mieNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","De cācān táhvī nū jā má quījí tūndóhó ñúcuán jā cunu nú maá tiempo jā cúun yūhā ni quīvī nátātú. ");
INSERT INTO mieNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chi tá quijéhé ñúcuán de coo cuāhā tūndóhó xéēn, jāá ncháha ca coo súcuán jondē quīvī jā ní jēcōo ñayīví de jondē mitan. De tá yāha tūndóhó ñúcuán de ni mā cōó cā jā súcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","De tú mā násndíyi Yāā Dios tiempo tūndóhó ñúcuán, de ni iin nchivī mā cácu cuitī ji. De jā síquī nchivī cándíja jā ní nacāji yā, jā ñúcuán cúu jā nasndíyi yā quīvī. ");
INSERT INTO mieNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Túsaá de tú iin nchivī cāhān jíín nú: Yáhá cūndēhé nú jā ndéē Cristo, á: Ñúcuán cūndēhé nú jā ndéē yā, cachī ji, de mā cándíja nú jā cáhān ji. ");
INSERT INTO mieNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chi quenda ndá tēe stáhví jā cachī dē jā cúu dē Cristo, á cachī dē jā tēe nácani tūhun Yāā Dios cúu dē. De sāhá ndá dē tiñu ñáhnú jā sāhvi inī nchivī cunī ji, tácua stáhví dē jondē maá nchivī jā ní nacāji yā, de tú ná cúu sāhá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ja nī ncachī tūhun nī nūū ndá nú mitan jondē ncháha ca coo. ");
INSERT INTO mieNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Túsaá de tú cāhān nchivī jíín nú: Quīndēhé nú, chi jondē nūū ñuhun tíhá ndéē yā, cachī ji, de mā quíhīn nū cūndēhé nú. A tú cāhān ji: Nehēn cūndēhé nú, chi inī vehe yáhá ndéē yā, cachī ji, de mā cándíja ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Chi tá cúu nūū jéndūtē sáhá taja, de túu jondē nūū quénda ncandiī de jondē nūū quée ncandiī, de suni súcuán coo quīvī nenda nduhū, Yāā nī nduu tēe, chi ndihi nchivī cunī. ");
INSERT INTO mieNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","De tá cúu nūū cútútú ndá tiōcó ní-ni cúu nūū cáá quiti jā ní jīhī, suni súcuán coo ndācá jā ní ncāhān ni, ní-ni cúu nūū íyó nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Sá de tá nī ndihi ndācá tūndóhó quīvī ñúcuán, de cutuún ncandiī, de yōō mā cútūu cā. De nincava tiūūn, de ndācá jā jíca andiví chi quisi. ");
INSERT INTO mieNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ñúcuán de cunī ndá nchivī nūū maá nī, Yāā nī nduu tēe, ndiji nī ichi andiví. De cuacu nchivī ndācá nación níí cáhnú ñayīví. De cunī ji jā nduhū, Yāā nī nduu tēe, ndiji nī jíín vīcō andiví, de cundiso nī cuāhā poder, de viī ndasí cuñáhnú nī. ");
INSERT INTO mieNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","De tají nī ndá ángel ni quīhīn, de tivī nīhin yā trompeta. De quīnastútú yā ndá nchivī jā ní nacāji nī ndicúmī lado ñayīví, jondē iin lado jíín jondē incā lado. ");
INSERT INTO mieNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mitan de scuáha ndá nú nāsa sáhá ñutun higo: Tá ja nī nene numa, de nī nacōco yūcū, de jínī ndá nú ja nī ncuñatin tiempo ihní. ");
INSERT INTO mieNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","De suni súcuán tá cunī ndá nú jā ní nquijéhé ndá tiñu yáhá, ñúcuán de jīcūhun inī nū ja nī ncuñatin quīvī jā nenda nī, de ñamā coo. ");
INSERT INTO mieNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","De ndāā cáhān ni jíín ndá nú jā má cúū ndihi nchivī jā cunī tūndóhó yáhá, chi jondē quee ndaā ndihi tá ncachī ni. ");
INSERT INTO mieNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Andiví jíín ñayīví chi naā, sochi ndācá tūhun cáhān ni chi mā náā, chi quee ndaā ndihi. ");
INSERT INTO mieNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Sochi quīvī jíín hora jā nenda nī, chi ni iin nchivī nduú jínī, ni ndá ángel andiví, ni maá nī jā cúu Sēhe Yāā Dios. Chi mátúhún-ni Tatá nī Yāā Dios cúu jā jínī. ");
INSERT INTO mieNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Chi tá cúu nūū ní ncuu ndá quīvī jā ní īyo Noé, suni súcuán coo quīvī nenda nduhū, Yāā nī nduu tēe. ");
INSERT INTO mieNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chi quīvī ñúcuán tá ncháha ca cuun sāvī xéēn, de yájī ji jíhi ji, tándāhá ji, de jéhe ji sēhe síhí ji jā tandāhá, jondē nī nquenda quīvī jā ní nquīvi Noé inī arca. ");
INSERT INTO mieNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","De nduú ní ncándíja nchivī jā cuun sāvī xéēn, de nī ncuun, de nī ndaa ndute, de nī jīhī ndihi ji. De suni súcuán coo tá nenda nduhū, Yāā nī nduu tēe. ");
INSERT INTO mieNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","De quīvī ñúcuán coo ūū tēe satíñú nūū itū. De iin dē naquehen nī, de incā dē ndōo, chi nduú ní ncándíja dē. ");
INSERT INTO mieNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","De coo ūū ñahan jā ndico cáhnú, de iin ña naquehen nī, de incā ña ndōo. ");
INSERT INTO mieNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Túsaá de ndito coo inī ndá nú, chi nduú jínī nū nā quīvī nenda Jētohō nū. ");
INSERT INTO mieNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","De chuhun inī nū jā cáhān tūhun yátá yáhá: Tēe xívéhe, tú ní jínī dē nā hora quiji jācuīhná, de cundito dē, de mā cuáha dē tūhun jā sacuíhná ndatíñú vehe dē nícu. ");
INSERT INTO mieNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","De saá-ni ndá ndóhó, suni súcuán coo tūha nú, chi maá hora jāá nduú nā cuá jáni inī nū, de nenda-ni nduhū, Yāā nī nduu tēe. ");
INSERT INTO mieNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Túsaá de coo ndá nú tá cúu iin mozo jā ndito xīnī de squíncuu vāha. De maá patrón nī jani dē mozo ñúcuán jā coto ji nchivī vehe dē, tácua scájī ji maá hora. ");
INSERT INTO mieNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","De nācā ndetū mozo ñúcuán jā tá nenda patrón, de cunī dē jā súcuán squíncuu vāha ji. ");
INSERT INTO mieNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","De ndāā cáhān ni jíín ndá nú jā cani dē mozo ñúcuán jā coto ji ndihi ndatíñú dē. ");
INSERT INTO mieNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sochi tú mozo jā sáhá nēhén cúu ji, de jáni inī ji jā má nēndá ñamā patrón ji, ");
INSERT INTO mieNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","de quijéhé ji cani ji táhán mozo ji, de cajī ji coho ji jíín ndá tēe jíni, ");
INSERT INTO mieNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","tú súcuán de nenda-ni patrón quīvī jāá nduú ndétu ji jíín hora jāá nduú ná jáni inī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","De sndóho ndasí dē ji, de squívi dē ji nūū yíhí ndá tēe stáhví-ni. De ñúcuán cuacu ji de nacayīhí ji ñii yúhú ji jā ndoho ndasí ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","De suha cúu jā tátúnī Yāā andiví nūū nchivī: Cúu tá cúu iin vico tándāhá. De nī īyo ūxī ñahan lúlí jā ní nquehen ji linterna yíndahá ji, de nī nquee ji cuātahān ji iin tēe tandāhá. ");
INSERT INTO mieNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","De ūhūn ji chi nduú ndito ji, de ūhūn ji chi sūchí ndito cúu ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","De ndá sūchí jāá nduú ndito, yíndahá ji linterna ji, sochi nduú nā petróleo yíndahá ji jā cuhun inī. ");
INSERT INTO mieNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","De ndá sūchí ndito, yíndahá ji botella petróleo jíín linterna ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","De juni cúcuéé tēe tandāhá quenda, de nī nquiji māhná, de nī nquīxīn ndihi ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","De tá nī ncuu sava ñuú, de nī jinī ndá ji jā cána jee: Ja vāji tēe tandāhá. Cuáhán ndá nú cuátahān nū dē, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ñúcuán de nī nacōo ndá ñahan lúlí, de nī nasāhá tūha ji linterna ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","De ndá sūchí jāá nduú ndito, nī ncāhān ji jíín ndá sūchí ndito: Taji ndá nú jacū petróleo, chi cuāndāhvā linterna ndá nī, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","De nī ncāhān ndá sūchí ndito: Mā cūú, chi mā quēndá jā cuu maá nī jíín ndá nú. Vāha cā quīhīn ndá nú nūū cúyāhvi, de cueen nú jā cuu ndá máá nú. Ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","De juni cuācuēen ndá ji, de nī nquenda-ni tēe tandāhá. De ndá sūchí jā íyó tūha nī nquīvi ji jíín dē vico tándāhá. De nī ndasī viéhé. ");
INSERT INTO mieNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","De nī ncunúú, de nī nquenda ūhūn cā ñahan lúlí ñúcuán. De nī ncāhān ji jíín tēe tándāhá: Señor, nacune ní viéhé ná quívi ndá sá, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","De nī ncāhān maá dē: ¿Ní nūū vāji ndá nú? Chi nduú jínī ni ndóhó, ncachī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ñúcuán de nī ncāhān cā yā: Túsaá de ndito coo inī ndá nú, chi nduú jínī nū nā quīvī nā hora nenda nduhū, Yāā nī nduu tēe. ");
INSERT INTO mieNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","De suha cúu jā tátúnī Yāā andiví nūū nchivī: Cúu tá cúu iin tēe jā quíhīn jīcá dē incā ñuū. De jondē ncháha ca quīhīn dē de nī ncana dē ndá mozo dē, de nī jēhe núú dē xūhún dē nūū ndá ji, jā satíñú ji jíín tácua nducuahā. ");
INSERT INTO mieNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","De nūū iin ji nī jēhe dē ūhūn mil xūhún cāa. De nūū incā ji nī jēhe dē ūū mil. De nūū incā ji nī jēhe dē iin mil. Súcuán nī jēhe dē, chi jínī dē nāsaa quenda iin iin ji satíñú ji jíín. Ñúcuán de nī nquehen dē ichi cuāhān jīcá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","De mozo jā ní nquehen ūhūn mil xūhún, nī nsatíñú dē jíín. De nī nīhīn dē ūhūn cā mil sīquī. ");
INSERT INTO mieNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","De saá-ni mozo jā ní nquehen ūū mil xūhún, suni nī nīhīn dē ūū cā mil sīquī. ");
INSERT INTO mieNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sochi mozo jā ní nquehen iin mil xūhún, nī jēhēn dē nī jete dē yavī, de nī nchiyuhū dē xūhún patrón dē. ");
INSERT INTO mieNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","De nī nchāha cuāhā tiempo, de nī nenda patrón ndá mozo ñúcuán. De nī nācān dē cuenta nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","De nī nquenda mozo jā ní nquehen ūhūn mil xūhún, de nī nacuāha dē xūhún nūū patrón dē jíín ūhūn cā mil jā ní nīhīn dē sīquī. De nī ncāhān dē: Señor, nī ntaji ní ūhūn mil nūū sá, de yáhá íyó ūhūn cā mil jā ní nīhīn sá sīquī. Ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","De nī ncāhān patrón jíín dē: Iyó vāha túsaá. Vāha ndasí mozo cúu nú jā squíncuu vāha nú. Chi vāha nī squíncuu nú iin tiñu lúlí-ni, de mitan de taji nī iin tiñu ñáhnú nūū nū. De quīvi nú nūū cusiī inī nū jíín nī. Ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ñúcuán de nī nquenda mozo jā ní nquehen ūū mil xūhún. De nī ncāhān dē: Señor, nī ntaji ní ūū mil nūū sá, de yáhá íyó ūū cā mil jā ní nīhīn sá sīquī. Ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","De nī ncāhān patrón jíín dē: Iyó vāha túsaá. Vāha ndasí mozo cúu nú jā squíncuu vāha nú. Chi vāha nī squíncuu nú iin tiñu lúlí-ni, de mitan de taji nī iin tiñu ñáhnú nūū nū. De quīvi nú nūū cusiī inī nū jíín nī. Ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","De nī nquenda mozo jā ní nquehen iin mil xūhún, de nī ncāhān dē jíín patrón: Señor, ja jínī sá níhín jā tēe xēēn cúu ní. Chi cuāhā cā cúnī ní nsūú cā jā cuu sāhá mozo ní, de cuāhā cā nácān ní nsūú cā jā ní jēhe ní. ");
INSERT INTO mieNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","De jā ñúcuán nī nchūhú sá, de nī jēhēn sá nī nchiyuhū sá xūhún ní chījin ñuhun. De yáhá ná nátaji sá xūhún ní. Ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","De nī ncāhān patrón jíín dē: Mozo cūxí cúu nú de maá-ni tiñu néhén sáhá nú. Chi jáni inī nū jā cuāhā cā cúnī ni nsūú cā jā cuu sāhá mozo ni, de cuāhā cā nácān ni nsūú cā jā táji nī. ");
INSERT INTO mieNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Túsaá de tú ní nchúhun nú xūhún nī nūū banco nícu, de tá nenda nī de naquehen nī xūhún nī jondē jíín sēhe xūhún nícu. Ncachī dē jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","De nī ncāhān dē jíín ndá cā mozo dē: Túsaá de candeē nū mil xūhún jīñā nūū ji, de cuāha nú nūū mozo jā névāha ūxī mil. ");
INSERT INTO mieNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chi nchivī ja névāha, sa quiji cā nūū ji, de jondē sobra cā cunevāha ji. Sochi nchivī jāá nduú, sa cujiyo-ni jacū jā névāha ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","De mozo yáhá jāá nduú squíncuu, tavā ndá nú ji ná quíhīn ji nūū neē tāvēhé. De ñúcuán cuacu ji de nacayīhí ji ñii yúhú ji jā ndoho ndasí ji, ncachī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","De nī ncāhān cā yā: Iin quīvī de nenda maá Yāā nī nduu tēe, de cuu yā Rey nūū nchivī. De ndá ángel yā cuiñi níí xiín yā. De cundeē yā nūū mesa jā tatúnī yā, de viī ndasí cuñáhnú yā. ");
INSERT INTO mieNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","De ndutútú nchivī ndācá nación nūū yā. De sāhá síín yā ndá ji, tá cúu nūū ndúsíín tīcāchí jíín ndixúhú sáhá tēe ndéca tī. ");
INSERT INTO mieNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","De nchivī vāha jā cúu tá cúu tīcāchí, cani yā ji lado cuáhá yā. De nchivī nēhén jā cúu tá cúu ndixúhú, cani yā ji lado sátín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ñúcuán de cāhān maá Rey jíín nchivī jā íyó lado cuáhá yā: Nācā ndetū ndá nú jā ní nsāhá Tatá nī jíín nú. Nehēn de quīvi ndá nú nūū tatúnī nū. Chi jondē quīvī jā ní jēcōo ñayīví de ja nī nsāhá tūha yā nūū tatúnī nū. ");
INSERT INTO mieNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Chi nī jīhī ni sōco, de nī ntaji ndá nú jā ní nchajī ni. Nī nchīchī ni ndute, de nī ntaji ndá nú nī jihi nī. Nī nquiji nī jondē ñuū jīcá, de nī ntanúú ndá nú vehe nī ndōo nī. ");
INSERT INTO mieNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nī ncumanī sahma nī, de nī ntaji ndá nú. Nī ncuhū ni, de nī jēndēhé ndá nú nduhū. De nī nchīhi nī vecāa, de suni nī jēndēhé ndá nú nduhū. Súcuán cāhān yā jíín nchivī íyó lado cuáhá yā. ");
INSERT INTO mieNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Sá de cāhān nchivī vāha ñúcuán jíín yā: Señor, ¿nā quīvī nī jinī ndá sá ní jā ní jīhī ní sōco, de nī ntaji sá jā ní nchajī ní, á jā ní nchīchī ní ndute, de nī ntaji sá jā ní jihi ní? ");
INSERT INTO mieNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿De nā quīvī nī jinī ndá sá ní jā ní nquiji ní jondē ñuū jīcá, de nī ntanúú sá vehe nī ndōo ní, á jā ní ncumanī sahma ní, de nī ntaji sá? ");
INSERT INTO mieNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿De nā quīvī nī jinī sá ní jā ní ncuhū ní, á jā ní nchīhi ní vecāa, de nī jēndēhé sá ní? Cachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ñúcuán de cāhān Rey jíín ji: Ndāā cáhān ni jíín ndá nú jā tá nī nsāhá ndá nú súcuán jíín iin ndá hermano ni jā cándíja, vísō nchivī núu ndasí cúu ji, de nūū maá nī nī nsāhá ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ñúcuán de suni cāhān Rey jíín nchivī jā íyó lado sátín yā: Nchivī jā tānū tāhvī cúu ndá nú. Cujiyo quīhīn nū nūū ñúhūn jā cáyū níí cání, nūū íyó tūha jā cundeē tāchī cúñáhnú jíín ndá cā tāchī jā jétíñú. ");
INSERT INTO mieNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Chi nī jīhī ni sōco, de nduú ní ntáji ndá nú jā cajī ni. Nī nchīchī ni ndute, de nduú ní ntáji ndá nú jā coho nī. ");
INSERT INTO mieNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nī nquiji nī jondē ñuū jīcá, de nduú ní ntánúú ndá nú vehe quendōo nī. Nī ncumanī sahma nī, de nduú ní ntáji ndá nú. De nī ncuhū ni, de nī nchīhi nī vecāa, de nduú ní jéndēhé ndá nú nduhū. Súcuán cāhān yā jíín nchivī jā íñí lado sátín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Sá de cāhān nchivī ñúcuán jíín yā: Señor, ¿nā quīvī nī jinī sá ní jā ní jīhī ní sōco, á jā ní nchīchī ní ndute, á jā ní nquiji ní jondē ñuū jīcá, á jā ní ncumanī sahma ní, á jā ní ncuhū ní, á jā ní nchīhi ní vecāa, de nduú ní ntáji sá jā cúmanī nūū ní? Cachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ñúcuán de cāhān yā jíín ji: Jāndáā cáhān ni jíín ndá nú jā sīquī jāá nduú ní nsáhá nú súcuán jíín ni iin ndá hermano ni jā cándíja, vísō nchivī núu ndasí cúu ji, túsaá de suni nūū maá nī nduú ní nsáhá ndá nú, cachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sá de quīhīn ndá nchivī ñúcuán ndoho ji níí cání. De ndá nchivī vāha, quīvi ji nūū cutecū ji níí cání, ncachī Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","De tá nī ndihi nī ncāhān Jesús ndācá tūhun yáhá, de nī ncāhān yā jíín ndá tēe scuáha jíín yā: ");
INSERT INTO mieNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ja jínī ndá nú jā ūū-ni cā quīvī de coo vico pascua. De nduhū, Yāā nī nduu tēe, nastúu ji nduhū jā cuū ni yīcā cruz, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ñúcuán de ndá sūtū cúñáhnú, jíín ndá tēe stéhēn ley janahán, jíín ndá tēe ñáhnú jā ndácu nūū nchivī hebreo, nī ndutútú dē inī patio palacio maá sūtū cúñáhnú cā jā nání Caifás. ");
INSERT INTO mieNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","De nī natúhún ndá dē nāsa tiin dē Jesús jíín tūhun túhún, de cahnī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","De nī ncāhān ndá dē: Mā tīín ó dē maá quīvī vico, chi nenda nchivī sīquī ō, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","De íyó Jesús ñuū Betania, vehe Simón, tēe jā ní ndoho cuēhē stéhyū. ");
INSERT INTO mieNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","De nī nquenda iin ñahan nūū yā, née ña iin frasco yūū luu jā ñúhún aceite perfume jā ndéē yāhvi ndasí. De nī jōsō ña xīnī yā juni yájī yā stāā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","De nī jinī ndá tēe scuáha jíín yā, de nī nquītī inī dē, de nī ncāhān dē: ¿Nājēhē cúu jā snáā cāhá ña perfume jīñā? ");
INSERT INTO mieNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Chi cuu xīcó yāhvi ndasí ña, de cuāha ó xūhún nūū nchivī ndāhví nícu, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","De nī jinī Jesús jā súcuán cáhān ndá dē. De nī ncāhān yā: ¿Nūcu sáhá ndá nú jā nácani inī ñahan yáhá? Chi iin tiñu váha cúu jā ní nsāhá ña nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Chi níní íyó nchivī ndāhví jíín ndá nú, de nduhū chi mā cúndeē cā ni jíín nú. ");
INSERT INTO mieNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Chi jā ní jōsō ña perfume yáhá nduhū, de suu cúu jā ní nsāhá tūha ña nduhū jondē quīvī jā quiyuhū ni. ");
INSERT INTO mieNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","De ndāā cáhān ni jíín ndá nú jā níí cáhnú ñayīví ní-ni cúu nūū cūtē nuu tūhun yáhá jā scácu nī nchivī, de suni nacani ji tūhun jā ní nsāhá ñahan yáhá, tácua nūcūhun inī nchivī ña, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ñúcuán de iin jā úxī ūū tēe scuáha jíín yā, nání dē Judas Iscariote, nī jēhēn dē nūū ndá sūtū cúñáhnú. ");
INSERT INTO mieNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","De nī ncāhān dē jíín: ¿Nāsaa taji ní nūū sá, de nastúu sá Jesús nūū ní? ncachī dē. De nī jēhe ndá ōcō ūxī xūhún plata nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sá de jondē quīvī ñúcuán nī nquijéhé dē ndúcú dē modo nāsa nastúu dē yā nūū ndá sūtū. ");
INSERT INTO mieNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","De maá quīvī jā quíjéhé vico jā yájī nchivī stātílā jāá nduú nā levadura yíhí, de ndá tēe scuáha nī nquenda dē nūū Jesús. De nī ncāhān dē jíín yā: ¿Ní cúu nūū cúnī ní jā quísāhá tūha sá nūū cuxíní ní vico pascua? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","De nī ncāhān yā: Cuáhán jondē ñuū, vehe tēe jā ní ncachī ō, de cāhān nū jíín dē: Cáchī maá Maestro, ja ncuñatin quīvī cuū yā. De mitan de cajī yā vico pascua inī vehe ní jíín ndá tēe scuáha jíín yā, cachī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","De ndá tēe scuáha jíín yā, nī nsāhá dē tá nī ndacu Jesús nūū dē, de nī nsāhá tūha dē jā cuxíní yā vico pascua. ");
INSERT INTO mieNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","De tá ja ñatin cuaā, de nī nquenda yā, de nī jēcundeē yā nūū mesa jíín ndihúxī ūū tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","De juni yájī yā jíín ndá dē de nī ncāhān yā: Jāndáā cáhān ni jíín ndá nú jā iin nú nastúu nduhū mitan, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","De nī ncucuécá ndasí inī ndá dē. De tá iin iin dē nī jīcā tūhún dē yā: ¿A sāán cúu, Señor? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","De nī ncāhān yā: Iin ndóhó jā yájī cāhnú jíín nī iin cōhō, suu nú nastúu nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","De nduhū, Yāā nī nduu tēe, jāndáā cúu jā quīhīn ni cuū ni, tá cúu nūū yósō tūhun nī nūū tutū īī. De nācā xēēn cundoho tēe jā nastúu nduhū. Vāha cā de tú nduú ní ncácu tēe ñúcuán nícu, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sá de nī ncāhān Judas, tēe jā nastúu yā: ¿A sāán cúu, Maestro? ncachī dē. Suu nú cúu, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","De juni yájī ndá dē jíín yā, de nī nquehen yā stātílā, de xihna cā nī nacuetáhví yā nūū Tatá yā, de nī scuáchi yā, de nī jēhe yā nūū ndá tēe scuáha jíín yā. De nī ncāhān yā: Cajī ndá nú, chi yáhá cúu yiqui cúñu nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sá de nī nquehen yā iin vaso jā ñúhún ndūxi uva, de nī nacuetáhví yā, de nī jēhe yā nūū ndá dē. De nī ncāhān yā: Coho ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Chi yáhá cúu nīñī ni jā sōcō ni jā cúu trátū jeé, de cati jā ndundoo cuāchi cuāhā nchivī, de coo tūhun cáhnú inī nūū cuāchi ji. ");
INSERT INTO mieNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","De cáhān ni jíín ndá nú jā jondē mitan de mā cōhó cā ni ndūxi uva yáhá, chi jondē quenda quīvī jā tatúnī Tatá nī níí ñayīví, de sá de coho tucu nī jíín ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","De nī jita yā jíín ndá dē iin yaā īī. De nī nquee yā cuāhān yā jíín dē jondē yucu Olivos. ");
INSERT INTO mieNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ñúcuán de nī ncāhān yā: Ndiviī nū nayūhú nú jā síquī nduhū jacuáā mitan. Chi suha yósō tūhun nī nūū tutū īī jā ní ncachī Yāā Dios: Cuāha nī tūhun jā cahnī nchivī tēe jíto tīcāchí, de ndá tīcāchí cūtē nuu tī jā yūhú tī, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sochi tá natecū ni, de xihna cā nduhū cosō nūú quīhīn ni región Galilea, de sá de cuēē ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","De nī ncāhān Pedro jíín yā: Vísō ndihi dē nayūhú dē, sochi sāán chi mā náyūhú cuitī sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","De nī ncāhān yā jíín dē: Jāndáā cáhān ni jíín nú, jacuáā mitan jondē ncháha ca cana lohló, de yūhú nú jā tiin nchivī ndóhó, de cachī nū ūnī vuelta jāá nduú jínī nū nduhū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","De nī ncāhān Pedro jíín yā: Vísō ná cúū sá jíín ní, sochi mā cāchí cuitī sá jāá nduú jínī sá ní, ncachī dē. De suni súcuán nī ncāhān ndihi ndá tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ñúcuán de nī nquenda Jesús jíín ndá tēe scuáha jíín yā iin lugar nūū nání Getsemaní. De nī ncāhān yā jíín dē: Yáhá-ni cundeē ndá nú, de ná quíhīn ni ñúcuán cācān táhvī ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","De nī jeca yā Pedro jíín ndúū sēhe Zebedeo cuāhān yā jíín dē. De nī nquijéhé yā cúcuécá ndasí inī yā de xií cúu inī yā jā quiji tūndóhó sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ñúcuán de nī ncāhān yā jíín ndá dē: Cúcuécá ndasí inī ni jondē ja ñatin cuū ni. Yáhá cundetu ndá nú de cundito nú jíín nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","De nī jica yā jacū cā, de nī jēcuīñī jītí yā nī ntuu yā nūū yā nūū ñūhún, de suha nī jīcān táhvī yā nūū Yāā Dios: Tatá maá sá, tú cuu de sāhá jíyo ní tūndóhó yáhá jā má quījí sīquī sá. Sochi nsūú jā cúnī maá sá, chi jā cúnī maá ní ná cóo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ñúcuán de nī nenda yā nūū ndinúnī tēe scuáha jíín yā, de nī jinī yā jā quíxīn ndá dē. De nī ncāhān yā jíín Pedro: ¿A nduú ní ncúndéé ndá nú cundito nú jíín nī vísō iin hora? ");
INSERT INTO mieNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Coo ndito inī ndá nú de cācān táhvī nū jā chindeé yā ndóhó tácua mā cōtó túnī jānēhén ndóhó jā sāhá nú cuāchi. Chi cúnī ndija ánō nū squíncuu vāha nú, sochi yiqui cúñu nú chi nduú fuerza, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","De nī jēhēn tucu yā vuelta ūū, de suha nī jīcān táhvī yā: Tatá maá sá, de tú mā cūú cujiyo tūndóhó yáhá jā má ndōhó sá, de ná cóo jā cúnī maá ní, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","De nī nenda tucu yā nūū dē, de nī jinī yā jā quíxīn tucu ndá dē, chi ndasí jíhī dē māhná. ");
INSERT INTO mieNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","De nī sndóo yā dē, de cuāhān tucu yā cuācācān táhvī yā vuelta ūnī, de suni tūhun ñúcuán nī ncāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sá de nī nenda tucu yā nūū ndá dē, de nī ncāhān yā: Mitan de cūsūn ndá nú-ni cā de natātú nú. De nduú chi ja nī nquenda hora, de nduhū, Yāā nī nduu tēe, natūu nī de tiin ndá tēe íyó cuāchi nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nacuiñī ndá nú, chi ja vāji tēe nastúu nduhū, de cōhōn jíín dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","De juni súcuán cáhān cā yā, de nī nquenda-ni Judas, iin táhán jā úxī ūū tēe scuáha jíín yā. De vāji cuāhā tēe jíín dē, ndíso ndá dē espada jíín ñutun. Chi ndá sūtū cúñáhnú jíín ndá tēe ñáhnú jā ndácu nūū nchivī hebreo, nī ntetíñú ndá tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","De Judas, tēe jā nastúu yā, ja nī jēhe dē iin seña nūū ndá tēe ñúcuán, chi nī ncachī dē: Tēe jā techuhú nī, ñúcuán cúu. De tiin ndá nú dē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","De nī nquenda dē nūū Jesús, de nī ncāhān dē: Tancuaā, Maestro, ncachī dē. De nī ntechuhú dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","De nī ncāhān Jesús jíín dē: Amigo, ¿nā tiñu vāji nú? ncachī yā. Ñúcuán de nī nquenda ndá cā tēe, de nī ntiin dē Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","De iin tēe jā íyó jíín Jesús, nī ntavā dē espada dē, de nī jehndē dē sōho iin mozo maá sūtū cúñáhnú cā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ñúcuán de nī ncāhān Jesús jíín dē: Nachuvāha espada nū, chi ndācá jā cánāá jíín espada, suni jíín espada cuū. ");
INSERT INTO mieNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿De á nduú jínī ndá nú jā cuu cācān táhvī ni nūū Tatá nī, de mitan ñúhún tají yā víhí cā ūxī ūū mil ángel andiví jā scácu nduhū? ");
INSERT INTO mieNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sochi tú súcuán, ¿de nāsa cuu squíncuu tūhun jā yósō nūū tutū īī jā cánuú ndoho nī súcuán? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ñúcuán de nī ncāhān yā jíín nchivī cuāhā: ¿De va tēe cuíhná cúu nī jā váji ndá nú jíín espada jíín ñutun jā tiin ndá nú nduhū, á naá cúu? Ndācá quīvī nī īyo nī jíín ndá nú inī templo cāhnú, nī stéhēn ni tūhun, de nduú ní ntíin ndá nú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","De súcuán sáhá ndá nú tácua quee ndaā jā cáhān tutū īī jā ní ntee ndá tēe nī nacani tūhun Yāā Dios, ncachī yā. Ñúcuán de ndihi tēe scuáha jíín yā, nī sndóo dē yā, de nī jinu dē cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","De ndá tēe jā ní ntiin Jesús, cuāhān dē jíín yā nūū Caifás, tēe cúu sūtū cúñáhnú cā. De ñúcuán íyó tútú ndá tēe stéhēn ley janahán, jíín ndá tēe ñáhnú jā ndácu tiñu. ");
INSERT INTO mieNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","De Pedro chi jícá-ni níquīn dē yā, de nī nquenda dē patio sūtū cúñáhnú cā. De nī nquīvi dē inī patio, de nī jēcundeē dē jíín ndá policía, tácua cunī dē nāsa coo sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","De ndá sūtū cúñáhnú jíín ndá tēe ñáhnú jíín ndihi tēe sáhá junta cúñáhnú cā, nī nducú dē tēe jā cāhān tūhun túhún sīquī Jesús, chi cahnī dē yā cúnī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","De vísō nī nquenda cuāhā nchivī jā cáhān tūhún, sochi nduú ní níhīn ndá dē cuāchi sīquī yā jā cuū yā. De jā sándīhí de nī nquenda ūū testigo jā ní ncāhān tūhun túhún sīquī yā: ");
INSERT INTO mieNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tēe yáhá nī ncāhān dē jā cuu canī dē templo Yāā Dios, de nūū únī-ni quīvī de nasāhá dē, ncachī ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ñúcuán de nī nacuiñī maá sūtū cúñáhnú cā, de nī ncāhān dē jíín yā: ¿Nūcu nduú cáhān cuitī nū? ¿A íyó ndāā jā cáhān ndá tēe yáhá sīquī nū? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sochi nduú ní ncáhān cuitī Jesús. De nī ncāhān maá sūtū cúñáhnú cā: Cáhān nīhin nī jíín nú jā cachī ndāā nū cunini maá Yāā Dios, Yāā técū. Cachī cājí tú maá nú cúu Cristo, Sēhe Yāā Dios, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","De nī ncāhān Jesús: Suu cúu nī, tá cúu nūū cáhān nū. De suni cáchī tūhun nī nūū ndá nú jā ndācá quīvī jā quiji de cunī nū jā nduhū, Yāā nī nduu tēe, cundeē ni lado cuáhá Yāā íyó poder, de ndiji nī ichi andiví jíín vīcō, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ñúcuán de sūtū cúñáhnú cā nī ndatá dē-ni sahma dē jā ní nquītī ndasí inī dē, de nī ncāhān dē: Tēe yáhá chi cáhān dē tūhun nāvāha jā quītī inī Yāā Dios, chi sáhá dē maá dē Sēhe Yāā Dios. ¿Nā testigo cā jíni ñúhún ó túsaá? Chi ja nī jini ndá nú tūhun nāvāha jā cáhān dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿De nāsa jáni inī ndá nú? ncachī dē. De nī ncāhān ndá nchivī cuāhā: Cuāchi cúu jā cáhān dē súcuán, de jíni ñúhún jā cuū dē, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ñúcuán de nī ntivī sīí ndá dē nūū yā, de nī ncani dē yā. De sava cā dē nī ncatū dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","De nī ncāhān ndá dē: De tú Cristo cúu nú, de cachī nā tēe nī ncani ndóhó, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","De juni súcuán cúu, de ndéē Pedro tāvēhé inī patio. De nī nquenda iin ñahan sátíñú vehe ñúcuán, de nī ncāhān ña jíín dē: Ndóhó chi suni nī jica nú jíín Jesús tēe Galilea, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","De maá dē nduú ní ncáchī dē, chi nī ncāhān dē nī jini ndá nchivī: Nduú jínī ni nā tūhun cáhān nū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","De nī nquee dē viéhé quēhe, de nī jinī incā ñahan nūū dē. De nī ncāhān ña jíín nchivī íyó ñúcuán: Tēe yáhá chi suni nī jica dē jíín Jesús, tēe ñuū Nazaret, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Sochi nduú ní jétúhún tucu dē, chi sa nī ncāhān téyíí dē: Nduú jínī ni tēe ñúcuán, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","De nī ncunúú jacū cā, de nchivī íyó ñúcuán nī nquenda ji nūū Pedro, de nī ncāhān ji: Jāndáā ndija jā suni táhán ndá tēe ñúcuán cúu nú, chi nijīn cáhān nū jā tēe Galilea cúu nú, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sá de nī nquijéhé dē cáhān téyíí dē jā ná cúndeē cuāchi sīquī dē de tú nduú cáhān ndāā dē: Nduú jínī cuitī ni tēe ñúcuán, ncachī dē. De nī ncana-ni lohló. ");
INSERT INTO mieNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","De nī nūcūhun inī dē tūhun jā ní ncāhān Jesús jíín dē: Jondē tá ncháha ca cana lohló, de yūhú nú de cachī nū ūnī vuelta jāá nduú jínī nū nduhū. De nī nquee dē cuāhān dē, de nī jacu ndasí dē jā ní ncachī dē jāá nduú jínī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","De tá nī ncunijīn, de ndācá sūtū cúñáhnú jíín ndá tēe ñáhnú jā ndácu nūū nchivī hebreo, nī scáni táhán dē tūhun nāsa sāhá dē jā cuū Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","De nī juhnī ndá dē yā, de cuāhān dē jíín yā nūū Poncio Pilato, tēe cúu gobernador. ");
INSERT INTO mieNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ñúcuán de Judas, tēe jā ní nastúu yā, nī jinī dē jā ní ncunīhin sīquī yā jā cuū yā. De nī ntahúhvī inī dē, de nī nacuāha dē ōcō ūxī xūhún plata jā ní nīhīn dē nūū ndá sūtū cúñáhnú jíín nūū ndá tēe ñáhnú. ");
INSERT INTO mieNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","De nī ncāhān dē jíín: Cuāchi nī nsāhá sá jā ní nastúu sá iin tēe jā cuū dē, de nduú nā cuāchi dē. De nī ncāhān ndá dē: ¿Nā cuá ndíhvī inī ndá nī? De cuāchi maá nú cúu, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","De nī nasquéne Judas xūhún ñúcuán inī templo. De nī nquee dē cuāhān dē, de nī scuéhné dē maá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","De ndá sūtū cúñáhnú nī nastútú dē xūhún ñúcuán, de nī ncāhān dē: Mā cūú chuhun ó xūhún yáhá inī jātūn nūū sócō ndá nchivī, chi xūhún jā ní jēcunáá jā cuū iin tēe cúu, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ñúcuán de nī nsāhá ndāā ndá dē jā xūhún ñúcuán cueen dē ñuhun jā nání Lugar Ñuhun Quíxín, tácua ñúcuán quiyuhū ndá nchivī jīcá. ");
INSERT INTO mieNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","De jā suu cúu jā jondē mitan nání ñuhun ñúcuán Lugar Ñuhun Nīñī. ");
INSERT INTO mieNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","De súcuán nī nquee ndaā tūhun nī ncāhān Jeremías, tēe nī nacani tūhun Yāā Dios jondē janahán: Nī nquehen ndá dē ndihócō ūxī xūhún plata, de súcuán-ni cúu iin yāhvi jā ní nsāhá nchivī Israel cuenta nāsaa-ni ndéē yā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","De jíín xūhún ñúcuán nī jeen ndá dē ñuhun quíxín, tá cúu nūū ní ndacu maá Jētohō ō Yāā Dios nūū ni. Ncachī Jeremías. ");
INSERT INTO mieNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","De tá nī nquenda ndá dē jíín Jesús nūū gobernador, tēe cúu Pilato, de nī jīcā tūhún dē yā: ¿A maá nú cúu Rey nchivī hebreo? ncachī dē. De nī ncāhān Jesús: Suu cúu nī, tá cúu nūū cáhān nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","De ndá sūtū cúñáhnú jíín ndá tēe ñáhnú jā ndácu tiñu, nī ncāhān dē cuāchi sīquī yā. Sochi nduú ní scócóo cuitī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ñúcuán de nī ncāhān Pilato jíín yā: ¿A nduú jíni nú jā cuāhā cuāchi cáhān ndá dē sīquī nū? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sochi nduú ní ncáhān cuitī yā ni iin tūhun jíín dē. De nī nsāhvi ndasí inī gobernador jāá nduú ní ncáhān cuitī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","De íyó costumbre gobernador jā quīvī vico ñúcuán siáā dē iin tēe yíhí vecāa, nā-ni tēe cúnī nchivī jā siáā dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","De quīvī ñúcuán íyó iin tēe yíhí vecāa, nání dē Barrabás, de ja nī jītē nuu tūhun jā ní nsāhá dē cuāchi xeēn. ");
INSERT INTO mieNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","De tá nī ndutútú nchivī, de nī ncāhān Pilato jíín ji: ¿Ní tēe cúnī ndá nú jā siáā ni mitan: A Barrabás á Jesús jā cúu Cristo, Yāā jā ní ntají Yāā Dios? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Súcuán nī ncāhān dē chi cúnī dē siáā dē Jesús. Chi ja nī jīcūhun inī dē jā ní ncucuásún inī ndá sūtū ñúcuán, de jā suu cúu jā ní nasiáha ndá dē yā nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","De juni ndéē Pilato silla nūū sáhá ndāā dē tiñu, de ñasíhí dē nī ntetíñú ña tūhun nī nquiji nūū dē: Mā quívi nduū nū jíín ndá nchivī sīquī tēe ndāā jīñā, chi cuni de ndasí nī nsiúhú jāni nduhū jā síquī dē, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sochi ndá sūtū cúñáhnú jíín ndá tēe ñáhnú, nī scáhān dē nchivī jā cācān ji jā ná siáā dē Barrabás, de ná cúū Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ñúcuán de nī jīcā tūhún tucu gobernador: Jā ndúū dē, ¿ní iin dē cúnī ndá nú jā siáā ni? ncachī dē. De nī ncāhān ji: Siáā ní Barrabás, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","De nī jīcā tūhún Pilato: ¿Túsaá de nāsa cúnī ndá nú jā sāhá nī jíín Jesús, tēe cúu Cristo? ncachī dē. De nī ncāhān ndihi ji: Cata caa ní dē yīcā cruz, ná cúū dē, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ñúcuán de nī ncāhān Pilato: ¿Nā cuāchi nī nsāhá dē túsaá? De ndá nchivī nī ncana jee ndasí ji: Cata caa ní dē yīcā cruz, ná cúū dē, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","De nī jinī Pilato jāá nduú cúndeé dē jíín nchivī, chi sa víhí cā cúvaā ji. De nī ndacu dē jā ná quíji ndute, de nī nandahá dē nūū nchivī cuāhā. De nī ncāhān dē: Jā nándahá nī yáhá cúu seña jāá nduú nā cuāchi cundeē sīquī ni jā cuū tēe vāha yáhá. Chi sīquī ndá máá nú ná cúndeē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","De nī ncāhān ndihi nchivī: Suu sīquī ndá máá sá jíín sīquī sēhe sá ná cúndeē cuāchi jā cuū dē, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sá de nī nsiáā dē Barrabás cuāhān. De nī ndacu dē jā ná cáni ndá soldado Jesús, jíín jā cata caa dē yā yīcā cruz. ");
INSERT INTO mieNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ñúcuán de ndá soldado cuāhān dē jíín Jesús inī palacio. De nī ncana dē ndihi táhán dē nī ncutútú dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","De nī ntavā ndá dē sahma yā, de nī nchuhun dē yā iin sahma cuahá jā cúu sahma rey. ");
INSERT INTO mieNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","De nī nsāhá ndá dē iin corona iñu, de nī nchuhun dē xīnī yā. De nī nchihi dē ndahá cuáhá yā iin ñutun jā cúu tá cúu bastón. De nī nsāhá catá dē nūū yā, chi nī jēcuīñī jītí dē, sáhá dē jā chíñúhún dē yā. Nācā vāha rey cúu Rey nchivī hebreo, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","De nī ntivī sīí ndá dē nūū yā. De nī naquehen dē ñutun jā ní nchihi dē ndahá yā, de nī ncuun dē xīnī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","De tá nī ncuu nī nsāhá sácá dē yā, de nī ntavā dē sahma cuahá jā ñúhún yā, de nī nachuhun dē yā sahma maá yā. De cuāhān dē jíín yā jā cata caa dē yā yīcā cruz. ");
INSERT INTO mieNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","De tá nī nquee ndá soldado jíín yā, de nī jēcutáhán dē jíín iin tēe ñuū Cirene, nání dē Simón. De nī ntee ndá dē tiñu tēe ñúcuán jā cuiso dē cruz yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","De nī nquenda ndá dē iin lugar nūū nání Gólgota, de tūhun ñúcuán cáhān: Lugar Yiqui Xínī. ");
INSERT INTO mieNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","De nī jēhe ndá dē vino jā ní nsacā nuu jíín iin jā úguā jā coho yā. De tá nī jito túnī yā, de nduú ní ncúnī yā coho yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","De tá nī ncuu nī jata caa dē yā yīcā cruz, de nī nsāhá dē suerte sīquī nāsa nīhīn iin iin dē sahma yā. De súcuán nī nquee ndaā tūhun jā ní ntee tēe nī nacani tūhun Yāā Dios janahán: Tavā ndá dē suerte sīquī nāsa nīhīn iin iin dē sahma nī, ncachī yā, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sá de nī jēcundeē ndá dē ñúcuán jā coto dē jondē cuū yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","De nī ntee dē iin tūhun xīnī cruz yā jā cáhān nā sīquī nī jīhī yā: Yáhá cúu Jesús, Rey nchivī hebreo, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","De suni nī jata caa ndá dē ūū tēe cuíhná yīcā ūū cā cruz, iin dē lado cuáhá yā, de incā dē lado sátín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","De nchivī jā yáha ñúcuán, scuícó ji xīnī ji, de nī ncāhān yīchī ji: ");
INSERT INTO mieNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ndóhó chi cáhān nū jā canī nū templo cāhnú, de nūū únī quīvī de nasāhá nú. Túsaá de scácu nú maá nú mitan. De tú Sēhe Yāā Dios cúu nú, de nuu nú yīcā cruz viī, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","De ndá sūtū cúñáhnú, jíín tēe stéhēn ley janahán, jíín tēe grupo fariseo, jíín ndá tēe ñáhnú, suni súcuán nī ncāhān catá dē nūū yā, de cáhān ndá máá dē: ");
INSERT INTO mieNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Tú incā nchivī nī scácu dē, ¿de nūcu nduú cúu scácu dē maá dē mitan? Tú Rey nchivī Israel cúu dē, de ná núu dē yīcā cruz, tácua candíja ó dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nī ncandíja dē Yāā Dios, de ná scácu yā dē mitan de tú cúndáhví inī yā dē, chi nī ncāhān dē jā cúu dē Sēhe yā, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","De ndúū tēe cuíhná jā ndíta caa xiín yā, suni súcuán nī ncāhān nāvāha dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","De tá nī ncuu cahūxī ūū, de nī ncuneē níí cáhnú jondē cahūnī. ");
INSERT INTO mieNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","De tá cahūnī, de nī ncana jee Jesús: Elí, Elí, ¿lama sabactani? De tūhun ñúcuán cáhān: Yāā Dios maá sá, Yāā Dios maá sá, ¿nūcu nī sndóo ní sāán? ");
INSERT INTO mieNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","De sava nchivī íñí ñúcuán, nī jini ji jā cáhān yā, de nī ncāhān ji: Tēe yáhá cána dē Elías, tēe nī nacani tūhun Yāā Dios janahán, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","De nī jinu-ni iin tēe, nī jēquēhen dē iin cāchī, de nī nchundaji dē nūū vinagre iyá. De nī ntee dē xīnī iin ñutun, de nī ntee dē yuhú yā jā coho yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","De nī ncāhān sava cā dē: Cundetu nú, cúndēhé ó tú quiji Elías scácu dē á nduú, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","De maá Jesús nī ncana jee yā incā vuelta, de nī jīhī yā-ni. ");
INSERT INTO mieNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","De sahma jā ndíta caa jā ndásī nūū cuarto īī inī templo cāhnú, nī ndātā-ni sava sava jondē xīnī jíín jondē jēhē. De nī ntāan, de nī ndātā toto. ");
INSERT INTO mieNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","De nī nune yavī nūū yíyuhū ndīyi, de cuāhā ndīyi jā ní ncandíja ji Yāā Dios, nī natecū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","De nī nquee ndá ji nūū yíyuhū ji, de tá nī natecū Jesús de nī ndīvi ji inī ciudad īī Jerusalén, de cuāhā nchivī nī jinī nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","De tá nī jīhī Jesús, de tēe cúu capitán jíín ndá tēe íñí jíín dē jā jíto dē jondē cuū yā, nī jinī ndá dē jā ní ntāan, jíín ndá cā tiñu jā ní ncuu. De nī nchūhú ndasí ndá dē, de nī ncāhān dē: Jāndáā ndija jā Sēhe Yāā Dios cúu tēe yáhá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","De ñúcuán íñí cuāhā ñahan, ndéhé jícá ña. De suu ndá ñahan ñúcuán nī jēcuniquīn ña Jesús jondē Galilea, vāji ña jā chíndeé ña yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","De ūnī ña cúu María ñuū Magdala, jíín María naná Jacobo jíín José, jíín naná ndúū sēhe Zebedeo. ");
INSERT INTO mieNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","De tá nī ñini quīvī ñúcuán, de nī nquenda iin tēe cuícá, nání dē José, de tēe ñuū Arimatea cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tēe yáhá nī jēhēn dē nūū Pilato, de nī jīcān dē yiqui cúñu Jesús. De nī ndacu Pilato jā ná cuáha ji nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","De José nī nquehen dē yiqui cúñu yā, de nī nchusúcún dē iin sahma cuijín ndoo. ");
INSERT INTO mieNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","De névāha dē iin yavī ndīyi jā ní ncaān jeé yīcā iin cava, nūū ncháha ca quiyuhū ndīyi. De ñúcuán nī nchiyuhū dē yā. De nī jasī dē iin yūū cāhnú yuhú yávī, de cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","De María ñuū Magdala, jíín incā María, ndéē ña ichi núū nūū yíyuhū yā. ");
INSERT INTO mieNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","De nī ncuu ndācá tiñu yáhá maá quīvī jā sáhá tūha nchivī jā quiji quīvī nátātú. Sá de nī ncunijīn maá quīvī nátātú. De ndá sūtū cúñáhnú jíín ndá tēe grupo fariseo, nī jēhēn dē nūū Pilato. ");
INSERT INTO mieNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","De nī ncāhān ndá dē: Señor, núcūhun inī ndá sá jā tá nī ntecū tēe stáhví néhén ñúcuán, de nī ncāhān dē jā natecū dē nūū únī quīvī. ");
INSERT INTO mieNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Túsaá de ndacu ní jā ná cóto vāha ndá soldado yuhú yávī ñúcuán jondē tá nī nchāha ūnī quīvī. Chi tú nduú de sanaā de quiji ndá tēe jā ní scuáha jíín dē, de natavā cuīhná dē ndīyi ñúcuán jacuáā, quīhīn dē jíín. Ñúcuán de cachī ndá dē nūū nchivī jā ní natecū tēe ñúcuán. De víhí cā cuu tūhun stáhví ñúcuán nsūú cā jā xíhna ñúhún, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","De nī ncāhān Pilato jíín dē: Yáhá íyó ndá soldado. Cuáhán jíín dē, de sāhá cutú vāha ndá nú yuhú yávī, de coto vāha ndá nú, tú nāsa cuu vāha cā sāhá nú, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","De cuāhān ndá dē, de nī nsāhá cutú dē yūū jā ndásī yuhú yávī nūū yíyuhū yā, de nī stíin vāha dē. De nī jani dē ndá soldado jā coto. ");
INSERT INTO mieNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","De nī nchāha quīvī nátātú, de nī ncunijīn quīvī domingo. De María ñuū Magdala jíín incā María, nī jēndēhé ña nūū ní nchiyuhū Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ñúcuán de iin sanaā-ni de nī ntāan nīhin ndasí. Chi iin ángel maá Jētohō ō Yāā Dios nī ncuun yā ichi andiví, nī nquenda yā nūū ní nchiyuhū Jesús. De nī stáá yā yūū jā ndásī yuhú yávī, de nī jēcundeē yā sīquī. ");
INSERT INTO mieNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","De jéndūtē nūū yā modo taja, de sahma ñúhún yā yaa ndasí tá cáá yūhvā volcán. ");
INSERT INTO mieNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","De ndá soldado jíto ñúcuán nī nquisi dē jā yúhú dē ndéhé dē yā. De nī ncuu ndá dē modo ndīyi-ni. ");
INSERT INTO mieNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","De nī ncāhān ángel jíín ndúū ñahan ñúcuán: Mā cúyūhú nú, chi jínī ni jā nánducú nú Jesús, Yāā nī jīhī yīcā cruz. ");
INSERT INTO mieNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nduú cā yā yáhá, chi ja nī natecū yā, tá cúu nūū ní ncachī yā. Nehēn de cunī nū nūū ní jaquīn ndá dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","De ñamā quīnohōn nū, de cachī nū nūū ndá tēe scuáha jíín yā jā ní natecū yā. De xihna cā maá yā jīnū Galilea, sá de cuēē ndá máá nú, de ñúcuán cunī nū nūū yā, cachī nū nūū ndá dē. Ja nī ncachī tūhun nī nūū nū, ncachī ángel. ");
INSERT INTO mieNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ñúcuán de nī nquee ndúū ña nūū ní nchiyuhū yā, de ñamā cuāhān ña. De yúhú ña, de suni cúsiī ndasí inī ña. De nī jinu ña cuācachī tūhun ña nūū ndá tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","De juni cuāhān ña, de nī nquenda-ni Jesús nūū ña, de nī ncāhān yā jíín ña. De nī ntandeē ña nūū yā, de nī numi ña sūcūn jéhē yā, de nī nchiñúhún ña yā. ");
INSERT INTO mieNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","De nī ncāhān yā jíín ña: Mā cúyūhú ndúū nū. De cuáhán de cachī tūhun nú nūū ndá hermano ni, tēe nī scuáha jíín nī, jā ná quínohōn ndá dē Galilea, de ñúcuán cunī dē nūū ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","De juni cuāhān ndúū ña, de sava soldado jā ní jito ñúcuán, cuānohōn dē jondē ciudad. De nī ncachī tūhun dē nūū ndá sūtū cúñáhnú ndācá tiñu jā ní ncuu. ");
INSERT INTO mieNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","De ndá sūtū cúñáhnú nī ndutútú dē nūū ndá tēe ñáhnú jā ndácu tiñu, de nī scáni táhán dē tūhun. Ñúcuán de nī jēhe dē cuāhā xūhún nūū ndá soldado. ");
INSERT INTO mieNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","De nī ncāhān dē: Cachī ndá nú jā ndá tēe scuáha jíín dē nī nquiji jacuáā, de nī natavā cuīhná ndīyi ñúcuán juni quíxīn ndá nú, cachī nū. ");
INSERT INTO mieNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","De tú cuni gobernador tūhun yáhá, de ndá máá nī quīscáhān ni dē, tácua mā níhīn ndá nú castigo, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","De ndá soldado nī nquehen dē xūhún, de nī ncāhān dē tá nī ncachī ndá nūū dē. De jondē mitan chi súcuán cáhān ndá nchivī hebreo tá cúu nūū ní ncāhān ndá soldado. ");
INSERT INTO mieNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","De ndihúxī iin tēe nī scuáha jíín yā, cuānohōn dē Galilea, jondē yucu nūū ní ncachī Jesús jā quíhīn dē. ");
INSERT INTO mieNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","De tá nī jinī ndá dē nūū yā, de nī nchiñúhún dē yā. Sochi sava dē nduú cándíja vāha dē jā maá yā cúu. ");
INSERT INTO mieNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","De nī ntandeē yā nūū dē, de nī ncāhān yā jíín ndá dē: Ja nī ntaji Yāā Dios ndihi poder nūū ni jā tatúnī ni inī andiví jíín ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Túsaá de cuáhán ndá nú nūū nchivī ndācá nación, de stéhēn nū tūhun nī nūū ji tácua candíja ji. De scuénduté nú ji jā ní ncandíja ji maá Tatá jíín Sēhe jíín Espíritu Santo. ");
INSERT INTO mieNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","De stéhēn nū nūū ji jā ná cuétáhví ji ndācá tiñu jā ní ndacu nī nūū nū. De cuhun inī nū jā maá nī íyó nī jíín nú níí cání jondē quīvī jā jīnu ñayīví, ncachī yā. De nī ncuu. Amén.");
INSERT INTO mieNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yáhá quíjéhé tūhun vāha maá Jesucristo, Sēhe Yāā Dios, jā ní nquiji yā jā scácu yā yóhó. ");
INSERT INTO mieNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaías, tēe nī nacani tūhun Yāā Dios jondē janahán, súcuán nī ntee dē tūhun Juan nūū tutū: Tají nī tēe nacani tūhun nī cosō nūú dē ichi núū nū, tácua coo tūha nchivī jā quiji nú, ncachī Yāā Dios jíín Cristo. ");
INSERT INTO mieNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","De tēe ñúcuán cana jee dē jondē nūū ñuhun tíhá: Sāhá tūha ndá nú maá nú, chi quenda maá Jētohō ō. De sāhá ndá nú tiñu ndāā, chi vāji yā, cachī dē. Ncachī Isaías. ");
INSERT INTO mieNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","De Juan nī jīnū dē jondē nūū ñuhun tíhá, scuénduté dē nchivī. De cáhān dē jíín ji jā ná nácani inī ji jā sndóo ji cuāchi ji de cuenduté ji, tácua cune cáhnú inī Yāā Dios nūū cuáchi ji. ");
INSERT INTO mieNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","De ndācá nchivī región Judea jíín nchivī ciudad Jerusalén, nī nquenda ji nūū dē. De nī nacani ndaā ji cuāchi ji nūū Yāā Dios, de nī scuénduté dē ji inī yūte Jordán. ");
INSERT INTO mieNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","De sahma ñúhún Juan cúu ixi camello, de núhnī iin cinturón ñii chījin dē. De jā técū dē cúu tīca langosta jíín ndūxi yōcō. ");
INSERT INTO mieNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","De suha nī nacani dē tūhun: Quiji maá Yāā jā cúñáhnú ndasí cā nsūú nduhū. Chi nduú cúñáhnú cuitī ni nūū yā, ni jā cuetíñú yā nduhū vísō iin tiñu lúlí cā jā jīqui ndeyi nī nandají nī correa nījān yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","De nduhū chi jíín ndute scuénduté nī ndá nú, sochi Yāā ñúcuán chi modo jā scuénduté yā ndá nú cúu jā cuāha yā Espíritu Santo cundeē inī ánō nū, ncachī Juan. ");
INSERT INTO mieNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","De nī ncuu jacū quīvī, de Jesús nī nquee yā ñuū Nazaret ndáñúū Galilea, de Juan nī scuénduté dē yā inī yūte Jordán. ");
INSERT INTO mieNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","De tá nī nquee yā ndute, de nī jinī yā jā ní nune-ni nūū ndéē Yāā Dios andiví, de nī ncuun Espíritu Santo, nī jīnū xīnī yā, de cáá tá cáá iin paloma. ");
INSERT INTO mieNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","De ichi andiví nī ncāhān iin tūhun: Maá nú cúu sēhe nī jā mānī ndasí nī jíín, de cúsiī ndasí inī ni jíín nú, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ñúcuán de nī jīnū Jesús jondē nūū ñuhun tíhá nī nsāhá Espíritu Santo. ");
INSERT INTO mieNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","De ūū xico quīvī nī ndeē yā nūū ñuhun tíhá ñúcuán nūū íyó ndá quiti yúcú. De nī jito túnī Satanás yā. De tá cuāhān Satanás, de nī nquenda ndá ángel Yāā Dios, nī nchindeé ndá yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ñúcuán de tá nī nchihi ndá dē Juan vecāa, de nī nenda Jesús región Galilea, nácani yā tūhun vāha nāsa tátúnī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","De nī ncāhān yā: Ja nī nquenda quīvī, de ja nī ncuñatin jā tatúnī Yāā Dios nūū ndá nú. Nacani inī nū jā sndóo nú cuāchi nú, de candíja nú tūhun jā scácu yā ndóhó, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","De jíca Jesús yuhú mar Galilea cuāhān yā. De nī jinī yā nūū Simón jíín ñanī dē Andrés. De tēe tíin tiacá cúu dē, de squée ndúū dē ñunu dē inī mar. ");
INSERT INTO mieNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","De nī ncāhān yā jíín dē: Cuniquīn nduhū ná cóhōn, de nasāhá nī ndóhó tēe jā nīhīn cuāhā nchivī jā candíja nduhū, tá cúu nūū níhīn nū tiacá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ñúcuán de nī sndóo-ni ndúū dē ñunu dē, de nī jēcuniquīn dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","De nī jica yā jacū cā, de nī jinī yā nūū Jacobo jíín ñanī dē Juan, ndúū sēhe Zebedeo, suni ndéē dē inī barco dē, náchicatún dē ñunu dē. ");
INSERT INTO mieNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","De suni nī ncana yā dē jā cuniquīn dē yā. De nī sndóo-ni ndúū dē tatá dē Zebedeo inī barco jíín ndá mozo dē, de nī jēcuniquīn dē yā cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","De nī jīnū yā jíín ndá dē ñuū Capernaum. De quīvī nátātú nī nquīvi yā inī vehe īī sinagoga, de nī stéhēn yā tūhun. ");
INSERT INTO mieNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","De nī nsāhvi inī nchivī nī jini ji tūhun stéhēn yā. Chi stéhēn vāha yā nūū ji, chi maá yā ndíso tíñú sīquī ndihi. De ndá tēe stéhēn ley janahán, nsūú súcuán stéhēn dē. ");
INSERT INTO mieNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","De inī vehe īī sinagoga ñuū ñúcuán íyó iin tēe jā ñúhún tāchī inī. De nī ncana cóhó dē: ");
INSERT INTO mieNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","¿Nūcu vāji ní nūū ndá sá, Jesús ñuū Nazaret? ¿A vāji ní jā snáā ní sāán, á naá cúu? Ja jínī sá ní iin cúu ní, chi Sēhe īī Yāā Dios cúu ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","De Jesús nī ncāhān xēēn yā nūū tāchī: Casī yuhú nú de quee nú inī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","De tāchī nī jahnī yīhí ndasí tēe ñúcuán. De nī ncana cóhó, de nī nquee-ni cuāhān. ");
INSERT INTO mieNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","De ndihi nchivī nī nchūhú ji, de jícā tūhún táhán ji: ¿Nā cuá cúu yáhá? ¿A iin tūhun jeé cúu yáhá? Chi tēe yáhá cúñáhnú dē jā ndácu dē jondē nūū tāchī de quée ndá, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","De ñamā nī jītē nuu tūhun Jesús cuāhān níí cáhnú región Galilea. ");
INSERT INTO mieNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","De nī nquee yā jíín ndá dē inī vehe īī sinagoga. De Jesús cuāhān yā jíín Jacobo jíín Juan jondē vehe Simón jíín Andrés. ");
INSERT INTO mieNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","De naná chíso Simón, cáá ña yíhí quīji ña. De nī ncachī tūhun ndá dē nūū yā jā cúhū ña. ");
INSERT INTO mieNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ñúcuán de nī ntandeē yā nūū cáá ña, de nī ntiin yā ndahá ña, de nī nacani yā ña. De nī nquee-ni quīji ña, de nī nsāhá ña jā ní nchajī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","De tá nī nquēe ncandiī de nī ncuaā, de nī nquenda ndá nchivī vāsiáha ji ndá jā cúhū jíín jā ñúhún tāchī inī. ");
INSERT INTO mieNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","De ndihi nchivī ñuū ñúcuán nī ncutútú ji viéhé ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","De nī nasāhá vāha yā cuāhā nchivī cúhū quéhén nūū cuēhē, de nī ntavā yā cuāhā tāchī inī ji. De ndá tāchī chi ja jínī ji yā, sochi nduú ní jéhe yā tūhun jā cachī tūhun ji ní iin cúu yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","De nehēn ndasí nī nacōo yā, chi jondē niquín cā. De nī nquee yā cuāhān sīín yā yātā ñúū nūū nduú nchivī, de ñúcuán nī jīcān táhvī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","De Simón jíín ndá tēe íyó jíín dē, nī jēnanducú dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","De nī nanihīn ndá dē yā, de nī ncāhān dē jíín yā: Ndācá nchivī nánducú ji níhín, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sochi nī ncāhān maá yā: Sa cōhōn ndācá cā ñuū íyó ñatin, tácua suni nacani nī tūhun nūū ji, chi jā suu cúu jā váji nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","De súcuán nī jica nuu yā níí región Galilea, nī nacani yā tūhun inī vehe īī sinagoga ndācá ñuū, de nī ntavā yā tāchī inī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","De iin tēe ndóho cuēhē stéhyū, nī nquenda dē nī jēcuīñī jītí dē nūū yā, de nī ncāhān dē: Jínī sá jā cuu sāhá ní jā nduvāha sá, de tú cúnī ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","De Jesús nī ncundáhví inī yā dē, de nī ntee yā ndahá yā dē, de nī ncāhān yā: Cúnī ni nasāhá vāha nī ndóhó. De ná ndúvāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Te tá nī ncāhān yā súcuán, de nī nduvāha-ni tēe ndóho cuēhē stéhyū. ");
INSERT INTO mieNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ñúcuán de nī natají yā dē jā quínohōn dē, de nī ncāhān nīhin yā jíín dē: ");
INSERT INTO mieNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Mā cāchí cuitī nū nūū ni iin. Chi quīhīn nū stéhēn nū maá nú nūū sūtū, de cundahá nú jā sōcō nū nūū Yāā Dios sīquī jā ní ndundoo nú nūū yā, tá cúu nūū ní ndacu Moisés janahán. De súcuán de cunī nchivī jā ní nduvāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","De nī nquee dē cuāhān dē, de nī nquijéhé dē nácani dē tūhun nūū ndihi nchivī nāsa nī nduvāha dē. De sīquī ñúcuán nduú cā ní ncúu quīvi Jesús ndācá ñuū, chi cúchitú ndasí nchivī nūū yā. De nī jica yā yātā ndācá ñuū nūū nduú cúchitú nchivī. Sochi ndācá lado nī nquiji nchivī nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","De nī ncuu jacū quīvī, de nī nquīvi tucu Jesús ñuū Capernaum. De nī jinī nchivī jā ndéē yā vehe. ");
INSERT INTO mieNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","De ñamā nī ncutútú cuāhā nchivī, de nī nchitú vehe chi jondē viéhé nduú cā núne. De nī nacani yā tūhun Yāā Dios nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ñúcuán de nī nquenda cūmī tēe nūū yā, ndíso ndá dē iin tēe jā ní nduvehlé. ");
INSERT INTO mieNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","De nduú ní ncúu quīvi ndá dē nūū yā sīquī jā íyó chitú nchivī. De nī ncaa dē sīquī vēhé, de nī nacune dē xīnī vēhé ndāā nūū íñí yā, de yavī ñúcuán nī scúun dē tēe cúhū, yósō dē nūū iin camilla. ");
INSERT INTO mieNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","De nī jinī Jesús jā cándíja ndá dē jā cuu nasāhá vāha yā tēe cúhū. De nī ncāhān yā jíín tēe cúhū: Lílū, ja née cáhnú inī ni nūū ndá cuāchi nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","De ñúcuán ndéē jacū tēe stéhēn ley janahán, de ndá tēe ñúcuán nī jani inī dē sīquī yā: ");
INSERT INTO mieNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Nūcu cáhān tēe yáhá súcuán? Cáhān dē tūhun nāvāha jā quītī inī Yāā Dios. Chi nduú cā nā incā cuu cune cáhnú inī nūū cuáchi, chi mátúhún-ni Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","De nī jinī Jesús jā súcuán jáni inī ndá dē, de nī ncāhān yā jíín dē: ¿Nūcu jáni inī ndá nú jā cáhān ni tūhun nāvāha? ");
INSERT INTO mieNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Jā ndúū tūhun yáhá, ¿ní iin cúu jā víjín cā? ¿A jā cāhān ni jíín tēe cúhū: Ja née cáhnú inī ni nūū ndá cuāchi nú? ¿A víjín cā jā cāhān ni: Nacōo de naquehen nú camilla nū, de caca nú, cachī ni? ");
INSERT INTO mieNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","De mitan de ná stéhēn ni jā maá nī, Yāā nī nduu tēe, ndíso tíñú nī inī ñayīví yáhá jā cune cáhnú inī ni nūū cuáchi. Sá de nī ncāhān yā jíín tēe nī nduvehlé: ");
INSERT INTO mieNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Cáhān ni jíín nú, nacōo de naquehen nú camilla nū de quīnohōn nū vehe nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ñúcuán de nī nacōo dē-ni, de nī naquehen dē camilla dē, de nī nquee dē cuāhān dē, nī jinī jínúū ndihi nchivī. De ndiviī ji nī nsāhvi inī ji ndéhé ji, de nī ncāhān ji jā vāha ndasí Yāā cúu Yāā Dios. De cáchī ji: Ncháha ca cunī cuitī ō ni iin tiñu súcuán, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sá de nī nquee tucu yā cuāhān yā jondē yuhú mar. De ndācá nchivī nī nquenda ji nūū yā, de nī stéhēn yā tūhun nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sá de nī nchāha yā cuāhān yā, de nī jinī yā nūū Leví sēhe Alfeo, ndéē dē nūū nástútú dē xūhún renta. De nī ncāhān yā jíín dē: Cuniquīn nduhū ná cóhōn, ncachī yā. De nī nacuiñī dē-ni, de cuāhān dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ñúcuán de nī jēhēn yā nī nchajī yā stāā vehe dē. De cuāhā tēe stútú xūhún renta jíín ndá cā tēe sáhá cuāchi, suni ndéē dē yájī dē stāā jíín Jesús jíín ndá tēe scuáha jíín yā, chi íyó cuāhā dē jā níquīn dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","De ndá tēe stéhēn ley janahán jíín tēe grupo fariseo, nī jinī dē jā yájī yā stāā jíín ndācá tēe ñúcuán. De nī ncāhān ndá dē jíín ndá tēe scuáha jíín yā: ¿Nūcu yájī maestro nū jíín ndá tēe stútú xūhún renta jíín ndá cā tēe sáhá cuāchi? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","De nī jini Jesús, de nī ncāhān yā jíín dē: Nchivī íyó vāha, nduú jíni ñúhún ji tēe tátán, chi nchivī cúhū cúu jā jíni ñúhún. De nduhū chi nduú vāji nī jā cana nī nchivī jāá nduú cuāchi, jā cúu ji tá cúu nchivī íyó vāha. Chi sa vāji nī jā cána nī nchivī íyó cuāchi, jā ná nácani inī ji de sndóo ji cuāchi ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","De nī ncuu iin quīvī jā íyó nditē inī ndá tēe scuáha jíín Juan, jíín ndá tēe scuáha jíín grupo fariseo. De nī nquenda jacū tēe, nī ncāhān dē jíín Jesús: Ndá tēe scuáha jíín Juan jíín jā scuáha jíín grupo fariseo, quéhén vuelta íyó nditē inī dē nūū Yāā Dios. De ndá tēe scuáha jíín maá ní, ¿nūcu nduú sáhá dē súcuán? ");
INSERT INTO mieNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","De nī ncāhān Jesús jíín dē: ¿A cuu conditē inī dē juni íyó cā ni jíín dē? ¿A cuu conditē inī nchivī jā íyó vico tándāhá juni ndéē tēe tándāhá jíín ji? Chi tá ndéē tēe tándāhá, de mā cūú conditē inī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sochi quiji quīvī jā cujiyo tēe tándāhá, de quīvī ñúcuán chi conditē inī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","De nī ncāhān yā ūū tūhun yátá sīquī jāá nduú quítáhán tūhun jeé jā stéhēn yā jíín ndá tūhun janahán. Ncachī yā: Ni iin nduú náchuhun iin pedazo sahma jéé nūū iin sahma túhú. Chi tú súcuán de ndiyi pedazo jeé de tēhndē cā jā tūhú, de cundícā cā nūū tēhndé. ");
INSERT INTO mieNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","De ni nduú chúhun vino jeé inī ñii túhú. Chi tú súcuán de vino jeé ndatá ñii, de naā vino jíín ñii. Jā ñúcuán cánuú jā chuhun ji vino jeé inī ñii jéé. ");
INSERT INTO mieNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","De iin quīvī nátātú nī nchāha Jesús cuāhān yā nūū cáá trigo. De ndá tēe scuáha jíín yā nī nquijéhé dē jéhndē dē xīnī trigo yájī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ñúcuán de ndá tēe grupo fariseo nī ncāhān dē jíín yā: Cūndēhé. ¿Nūcu sáhá ndá tēe scuáha jíín nú súcuán? Chi cáchī ley Moisés jā má cūú sāhá ó ni iin tiñu quīvī nátātú, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","De nī ncāhān maá yā jíín dē: ¿A nduú ní ncáhvi ndá nú tutū nāsa nī nsāhá David, iin quīvī jā ní ncumanī jā cajī dē, de nī jīhī dē sōco jíín ndá tēe jā ní īyo jíín dē? ");
INSERT INTO mieNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","De nī nquīvi dē inī vehe Yāā Dios. De Abiatar nī ncuu sūtū cúñáhnú cā. De nī nchajī dē pan īī jā yósō nijīn nūū Yāā Dios. De nduú nā ley jā cajī ni iin tēe, chi maá-ni sūtū cúu jā yájī. De suni nī jēhe dē nī nchajī ndá tēe íyó jíín dē. De nduú nā cuāchi ní íyo sīquī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","De suni nī ncāhān yā jíín ndá dē: Nduú ní jécōo nchivī jā ndoho ji nūū quīvī nátātú, chi sa nī jēcōo quīvī ñúcuán jā síquī nchivī tácua natātú ji. ");
INSERT INTO mieNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Túsaá de nduhū, Yāā nī nduu tēe, maá nī cúu jā tátúnī sīquī nāsa sāhá nchivī quīvī nátātú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","De nī nquīvi tucu Jesús inī iin vehe īī sinagoga. De ñúcuán íyó iin tēe jā ní nchīchī iin ndahá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","De ndá tēe grupo fariseo ndéhé yuhū dē yā, tú nasāhá vāha yā tēe ñúcuán quīvī nátātú, tácua nīhīn dē cuāchi sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ñúcuán de nī ncāhān yā jíín tēe jā ní nchīchī ndahá: Nacuiñī de cuiñi nú māhñú yáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","De nī jīcā tūhún yā ndá dē: ¿Nāsa cáhān ley sīquī quīvī nátātú? ¿A jā sāhá vāha ó, á jā sāhá nēhén ó? ¿A jā nasāhá vāha ó nchivī ja ñatin cuū, á sāhá ó jā cuū ji? ncachī yā. De ndá máá dē chi nduú ní ncáhān cuitī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","De quítī inī yā ndéhé yā nūū ndá dē, de nī ncucuécá inī yā jā nīhin inī dē. De nī ncāhān yā jíín tēe jā ní nchīchī ndahá: Scáā ndahá nú, ncachī yā. De nī scáā dē, de nī nduvāha-ni ndahá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ñúcuán de nī nquee ndá tēe grupo fariseo, de nī scáni táhán dē tūhun jíín ndá tēe grupo Herodes jā síquī yā, nāsa cahnī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","De Jesús cuāhān yā jondē yuhú mar jíín ndá tēe scuáha jíín yā. De cuāhā nchivī región Galilea nī jēcuniquīn ji yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","De saá-ni nchivī región Judea, jíín nchivī Jerusalén, jíín nchivī Idumea, jíín nchivī jā ndéē lado yūte Jordán nūū quénda ncandiī, jíín nchivī región Tiro jíín Sidón, cuāhā ndasí nchivī nī jini ji tūhun tá ñáhnú ndasí tiñu sáhá yā, de nī nquenda ndá ji nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","De nī ncāhān yā jíín ndá tēe scuáha jíín yā jā ná cóo tūha iin barco quīvi yā, tácua mā chitú nīhin nchivī cuāhā níí xiín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Chi ja nī ncuu cuāhā nchivī nī nasāhá vāha yā, de jā ñúcuán vāji cuāhā cā nchivī jā ndóho ndācá nūū cuēhē, de chítú nīhin ji níí xiín yā jā quehé ji yā cúnī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","De ndá nchivī jā ñúhún tāchī inī, tá nī jinī nūū yā, de jécuīñī jītí nūū yā, de cána cóhó: Maá ní cúu Sēhe Yāā Dios, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","De nī ndacu nīhin yā nūū ndá tāchī jā má cáhān cā jā cúu yā Sēhe Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ñúcuán de nī ncaa yā cuāhān yā iin yucu. De nī ncana yā ndá tēe jā cúnī maá yā cundeca yā, de nī nquenda ndá dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","De nī jani yā ūxī ūū dē jā cuiñi dē jíín yā, de tají yā ndá dē quīhīn dē nacani dē tūhun. ");
INSERT INTO mieNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","De nī nsāhá yā jā cundiso tíñú dē jā nasāhá vāha dē nchivī cúhū de tavā dē ndá tāchī inī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","De yáhá cúu ndihúxī ūū tēe jā ní nacāji yā: Simón jā ní nascúnaní yā dē Pedro. ");
INSERT INTO mieNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","De saá-ni Jacobo jíín ñanī dē Juan, ndúū sēhe Zebedeo. De nī nascúnaní yā ndúū dē Boanerges, jā cáchī: Tēe íyó fuerza nacani tūhun, tá cúu nūū íyó fuerza taja. ");
INSERT INTO mieNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","De sava cā dē nání dē Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo sēhe Alfeo, Tadeo, Simón tēe grupo cananista, ");
INSERT INTO mieNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","jíín Judas Iscariote, tēe jā ní nastúu dē yā. Sá de nī nquīvi yā iin vehe jíín ndá tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","De nī ncutútú tucu cuāhā nchivī, de ni nduú cā ní ncúu cajī yā stāā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","De ndá táhán vehe yā nī jini tūhun jā súcuán cúu. De nī nquenda ndá dē jā nacueca dē yā, chi cáhān ndá jā ní nsana xīnī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","De saá-ni ndá tēe stéhēn ley janahán jā ní nquiji jondē Jerusalén, nī ncāhān dē: Tēe yáhá ñúhún Satanás inī dē, jā cúu tāchī cúñáhnú cā. De jíín fuerza ñúcuán távā dē ndá tāchī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","De nī ncana yā ndá dē, de nī ncāhān yā iin tūhun yátá jíín dē: ¿Nāsa cuu tavā Satanás maá? ");
INSERT INTO mieNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","De tú iin nación sáhá síín maá de cánāá maá, de nación ñúcuán chi mā cūú cā coo cáhnú. ");
INSERT INTO mieNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","De tú nchivī iin vehe sáhá síín maá de cánāá maá, de nchivī vehe ñúcuán suni mā cūú cā cundeē cāhnú. ");
INSERT INTO mieNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","De saá-ni Satanás jíín ndá táhán tāchī, tú sáhá síín maá de cánāá maá, túsaá de mā cūú coo cā, chi sa naā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","De ni iin tēe mā cūú quīvi dē inī vehe tēe ndacuī jā sacuíhná dē ndatíñú, chi cánuú jā xihna cuhnī dē tēe ndacuī, sá de cuu sacuíhná dē ndatíñú tēe ñúcuán. De suni súcuán cúu jā júhnī ni Satanás de távā ni tāchī. ");
INSERT INTO mieNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","De ndāā cáhān ni jíín ndá nú jā íyó modo jā coo tūhun cáhnú inī nūū ndācá cuāchi sáhá nchivī, de saá-ni nūū ndá tūhun nēhén jā cáhān ji. ");
INSERT INTO mieNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Sochi tú cāhān nāvāha ji sīquī Espíritu Santo, de mā cúne cáhnú inī Yāā Dios nūū ji, chi sa cundeē cuāchi sīquī ji níí cání, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Súcuán nī ncāhān yā, chi nī ncāhān ndá ji jā távā yā tāchī jíín fuerza Satanás. ");
INSERT INTO mieNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ñúcuán de nī nquenda naná yā jíín ndá ñanī yā. De íñí ña tāvēhé, de nī ntetíñú ña tūhun cuāhān jā cána ña yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","De nchivī jā ndéē níí xiín yā, nī ncāhān ji jíín yā: Naná ní jíín ndá ñanī ní íñí ña tāvēhé, de cúnī ña cāhān ña jíín ní, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","De nī ncāhān maá yā: ¿Ní iin cúu naná nī jíín ndá ñanī ni? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","De ndéhé yā nūū nchivī ndéē níí xiín yā, de nī ncāhān yā: Suni naná nī jíín ñanī ni cúu ndá nchivī yáhá. ");
INSERT INTO mieNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chi ndācá nchivī jā squíncuu tiñu cúnī Yāā Dios, suu cúu ñanī ni, cuāha nī, naná nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","De yuhú mar nī nquijéhé tucu Jesús stéhēn yā tūhun. De nī ncutútú cuāhā ndasí nchivī nūū yā, de jā ñúcuán nī nquīvi yā nī jēcundeē yā inī iin barco nūū mar. De ndá nchivī ndéē ji yuhú mar. ");
INSERT INTO mieNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","De jíín tūhun yátá nī stéhēn yā cuāhā tūhun nūū ji, de súcuán nī ncāhān yā: ");
INSERT INTO mieNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Cunini ndá nú: Iin tēe jítē tatā, nī nquee dē jā cutē dē. ");
INSERT INTO mieNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","De tá nī nquijéhé dē jítē dē, de jacū tatā nī jītē yuhú íchí. De nī nquenda ndá saā, de nī nchajī tī. ");
INSERT INTO mieNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","De jacū cā tatā nī jītē nūū ñuhun yúū, nūū nduú íyó cócón ñuhun. De ñamā-ni nī ntāhvī, chi nduú íyó cócón. ");
INSERT INTO mieNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","De tá nī nquenda ncandiī, de nī nchīchī-ni, de nī ncasūn, chi nduú ní níhīn nūū quíhīn yoho. ");
INSERT INTO mieNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","De jacū cā tatā nī jītē māhñú nūū cáá niquin iñu. De nī jahnu iñu, de nī jasī nūū, de nduú ní jéhe nūnī. ");
INSERT INTO mieNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","De jacū nī jītē nūū ñuhun váha. De nī ntāhvī, de nī jahnu, de nī jēhe cuāhā nūnī. Sava nī jēhe ōcō ūxī jā iin iin tatā, de sava cā nī jēhe ūnī xico, de sava cā nī jēhe ciento, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ñúcuán de nī ncāhān yā jíín ndá ji: Ndá ndóhó jā níni, tee sōho vāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ñúcuán de cuāhān ndá nchivī, de nī nquendōo yā jíín ndihúxī ūū tēe scuáha jíín yā, jíín jacū cā nchivī íñí jíín dē. De nī jīcā tūhún ndá dē yā nā cuá cúu tūhun yátá ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","De nī ncāhān yā jíín dē: Ndá ndóhó, chi sáhá Yāā Dios jā cuu jīcūhun inī nū tūhun yáhá jā ní nchiyuhū, nāsa quívi nchivī ndahá yā jā tatúnī yā nūū ji. Sochi nchivī jā síín sīquī íñí, chi maá-ni jíín tūhun yátá cáhān ni jíín ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Súcuán cáhān ni tácua vísō ndéhé ji, de quendōo ji modo jāá nduú jínī ji. De vísō jíni jíín sóho ji, de mā jícūhun inī ji, de mā ndīcó cóo inī ji nūū ni, de mā cōó tūhun cáhnú inī nūū cuáchi ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","De nī ncāhān cā yā jíín ndá dē: Tú nduú jícūhun inī nū tūhun yátá yáhá, ¿de nāsa jīcūhun inī nū ndācá cā tūhun yátá túsaá? ");
INSERT INTO mieNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tēe jítē tatā cúu tēe scútē nuu tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","De tatā jā ní jītē yuhú íchí cúu tá cúu sava nchivī jā níni ji tūhun yā, de tá nī jini ji, de quénda-ni Satanás de cándeē tūhun inī ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","De tatā jā ní jītē nūū ñuhun yúū, chi cúu tá cúu sava nchivī jā níni tūhun, de jétáhví ji de cúsiī inī ji jíín. ");
INSERT INTO mieNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sochi nduú cúcutú tūhun inī ánō ji, de jacū-ni quīvī jétáhví ji. De tá quíji tūndóhó, á jā jínī ūhvī nchivī ji jā síquī tūhun ñúcuán, sá de quíjéhé nácani yátá inī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","De jā ní jītē māhñú niquin iñu cúu tá cúu sava cā nchivī jā jíni ji tūhun, ");
INSERT INTO mieNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","sochi ndíhvī inī ji sīquī ndá jā íyó inī ñayīví yáhá. De cúnī ji cucuícá ji, de stáhví ndá ñúcuán jā cútóó inī ji ndācá ndatíñú. De ndihi yáhá cútéñú ji jíín, de jásī nūū tūhun yā, de nduú jíja ji jíín tūhun yā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","De tatā jā ní jītē nūū ñuhun váha cúu ndá nchivī jā jíni tūhun, de jétáhví ji, de jíja ji jíín tūhun yā. De sava ji cúu tá cúu tatā jā jéhe ōcō ūxī jā iin iin, de sava cā ji jéhe ūnī xico, de sava cā ji jéhe ciento, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","De suni nī ncāhān cā yā: Tá scuíquīn nchivī iin lámpara, ¿de á chíhi ji chījin iin cajón á chījin jīto? Nduú chi jáni ji nūū sūcún tácua cutūú. ");
INSERT INTO mieNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","De suni súcuán, nduú íyó ni iin tūhun yíyuhū jā má cūní nchivī, chi ndihi-ni tūhun natūu nijīn de cunī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ndá ndóhó jā níni, tee sōho vāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","De suni nī ncāhān yā jíín ndá ji: Cunini vāha ndá nú tūhun Yāā Dios. Chi tú nāsa medida chúhun inī nū, suni súcuán cuāha yā nūū nū, de víhí cā cuāha yā nūū maá nú jā tée vāha nú sōho nú. ");
INSERT INTO mieNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Chi nchivī ja jícūhun inī, stéhēn cā yā nūū ji. Sochi nchivī jāá nduú cándíja, vísō ja jínī ji jacū, de sa naā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","De nī ncāhān cā yā: Súcuán cúu jā tátúnī Yāā Dios nūū nchivī: Cúu tá cúu tatā jā ní jitē iin tēe. ");
INSERT INTO mieNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ñúcuán de quíxīn dē de nácōo dē, de súcuán jíca quīvī cuāhān. De tatā ñúcuán táhvī de jáhnu. De maá dē chi nduú jínī dē nāsa jáhnu. ");
INSERT INTO mieNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Chi maá ñuhun sáhá jā jáhnu, xihna cā yūcū, sá de quénda yoco, ñúcuán de jíja maá nūnī. ");
INSERT INTO mieNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","De tá nī ncuaān trigo, de quíjéhé nchivī jéhndē ji, chi ja nī nquenda quīvī tēhndē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","De suni nī ncāhān yā: Ná cáhān ni iin tūhun yátá tácua cunī ndá nú nāsa cúu jā ndúcuahā nchivī jā tátúnī Yāā Dios nūū. ");
INSERT INTO mieNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ndúcuahā ji tá cúu nūū jáhnu iin niquin mostaza jā jáquīn ji nūū ñuhun. De ñúcuán cúu iin niquin lúlí cā nsūú cā ndá cā niquin. ");
INSERT INTO mieNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sochi tá nī jaquīn ji, de táhvī de jáhnu cā nsūú cā ndá cā yūcū, de cúnáhnú ndahá, chi jondē cuu sāhá ndá saā tacā tī chījin cōndāhvī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","De cuāhā tūhun yátá súcuán nī stéhēn yā nūū nchivī, tú nāsa quénda ji jīcūhun inī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","De ndācá jā ní stéhēn yā, maá-ni tūhun yátá nī ncāhān yā jíín ndá ji. Sochi nūū ndá tēe scuáha jíín yā chi nī ncachī cājí yā ndācá tūhun ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","De jā cúncuaā quīvī ñúcuán, de nī ncāhān yā jíín ndá tēe scuáha jíín yā: Ná yáha ó cōhōn incā lado mar, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","De nī sndóo ndá dē nchivī cuāhā, de nī nquīvi ndá dē inī barco nūū ja ndéē Jesús, de cuāhān dē jíín yā. De suni cuāhān jacū cā barco jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","De nī jīquīhi iin tāchī níhin, de nī scáa ndute mar, de nī nquīvi inī barco. De ja ñatin chitú ndute inī barco. ");
INSERT INTO mieNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","De Jesús chi cáá yā ichi chátā ndá dē inī barco, quíxīn yā de yíxinī yā iin sahma. De nī sndóto ndá dē yā, de nī ncāhān dē: Maestro, ¿á nduú sáhá ní cuenta jā quēe ó chījin ndute de naā ō da? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","De nī nacōo yā, de nī ncāhān yā nūū tāchī níhin jíín nūū mar: Jencuiñī de nañíí-ni coo nú, ncachī yā. De nī jencuiñī tāchī, de nī ncuu nañíí ndihi-ni. ");
INSERT INTO mieNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","De nī ncāhān yā jíín ndá dē: ¿Nūcu yúhú ndasí ndá nú? ¿De nūcu nduú cándíja nú jā cācu nú sāhá nī? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","De yúhú ndasí ndá dē, de nī ncāhān dē jíín táhán dē: ¿Nā tēe cúu tēe yáhá jā jondē tāchī níhin jíín mar jétáhví jā cáhān dē? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","De nī nquenda Jesús jíín ndá dē incā lado mar, región Gadara. ");
INSERT INTO mieNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","De tá nī nquee yā inī barco, de iin tēe ñúhún tāchī inī, nī nquee dē jondē nūū yíyuhū ndá ndīyi, de nī nquenda dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tēe ñúcuán ndéē dē nūū yíyuhū ndīyi. De nduú jétíñú jā júhnī nchivī dē, ni jíín cadena. ");
INSERT INTO mieNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Chi cuāhā vuelta nī nuhnī jēhē dē ndahá dē jíín cadena. De ndācá vuelta jéhndē dē, de scuáchi dē. De ni iin nduú cúndeé jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","De nduú ñuú jíca dē yucu jíín nūū yíyuhū ndīyi, de cána cóhó dē, de stácuēhé dē maá dē jíín yūū. ");
INSERT INTO mieNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","De jondē jícá cā vāji Jesús, de nī jinī dē nūū yā. De jínu dē nī nquenda dē nūū yā, de nī jēcuīñī jītí dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","De nī ncana cóhó dē: ¿Nūcu vāji ní nūū sá, Jesús Sēhe Yāā Dios, Yāā cúñáhnú ndasí? Cáhān ndāhví sá jíín ní, jā níni Yāā Dios, mā sndóho ní sāán, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Súcuán nī ncāhān dē, chi ja nī ncachī Jesús: Tāchī, quee nú quīhīn nū inī tēe yáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","De nī jīcā tūhún yā dē: ¿Nā cuá nāní nú? De nī ncāhān dē: Legión nání sá, chi cuāhā tāchī ñúhún inī sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","De nī ncāhān ndāhví ndasí dē jíín yā jā má tājí yā ndá tāchī jā quee ji inī región ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","De ñatin yucu ñúcuán ñúhún cuāhā quinī jítu tī. ");
INSERT INTO mieNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","De ndá tāchī jā ñúhún inī tēe ñúcuán nī ncāhān ndāhví jíín yā: Tú tají ní ndá sá de cuāha ní tūhun jā quīvi sá inī ndá quinī ñúcuán, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","De nī jēhe Jesús tūhun. De nī nquee ndá tāchī inī tēe ñúcuán, de nī nquīvi inī quinī, de íyó tá ūū mil tī. De nī jinu ndá tī, de nī nincava tī iin yuhú cává jondē inī mar. De nī nquēe tī chījin ndute, de nī jīhī tī. ");
INSERT INTO mieNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","De ndá tēe jíto tī, nī jinu dē cuāhān dē jā ní nchūhú dē. De nī nquenda dē nī ncachī tūhun dē nūū ndá nchivī ñuū jíín ndá rancho. De nī jēhēn ndá nchivī nī jēndēhé ji nāsa nī ncuu. ");
INSERT INTO mieNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","De nī nquenda ndá ji nūū íyó Jesús, de nī jinī ji nūū tēe jā ní ñūhun cuāhā tāchī inī. De ndéē dē, de ñúhún dē sahma, de ja nī nducájí xīnī dē. De nī nchūhú ndá nchivī ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","De ndá tēe jā ní jinī, nī nacani dē tūhun nūū nchivī, nāsa nī nduvāha tēe jā ní ñūhun tāchī inī, jíín nāsa nī ndoho ndá quinī. ");
INSERT INTO mieNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ñúcuán de nī nquijéhé ndá ji nī ncāhān ndāhví ji jíín yā jā ná quée yā región ñúcuán quīhīn yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","De nī ndīvi yā inī barco. De tēe jā ní ñūhun tāchī inī, nī ncāhān ndāhví dē jíín yā jā cuāha yā tūhun quīhīn dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","De Jesús nduú ní jéhe yā tūhun, chi nī ncāhān yā jíín dē: Cuánohōn vehe nú nūū ndá táhán nú, de nacani nú tūhun nūū ji nāsa ñáhnú ndasí tiñu nī nsāhá maá Jētohō nū ndóhó, de nāsa nī ncundáhví inī yā ndóhó, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","De cuāhān dē, de nī nquijéhé dē nácani dē tūhun ndācá ñuū Decápolis nāsa ñáhnú ndasí tiñu nī nsāhá Jesús jíín dē. De ndiviī nchivī nī nsāhvi inī ji nī jini ji. ");
INSERT INTO mieNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","De nī nayāha tucu Jesús cuānohōn yā incā lado mar jíín barco. De nī nquenda cuāhā ndasí nchivī nūū yā, nūū íyó yā yuhú mar. ");
INSERT INTO mieNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","De nī nquenda iin tēe cúñáhnú inī vehe īī sinagoga, nání dē Jairo. De tá nī jinī dē nūū yā, de nī jēcuīñī jītí dē nūū jéhē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","De nī ncāhān ndāhví ndasí dē jíín yā: Sēhe síhí sá ja ñatin cuū ji. De á mā cóhōn de tee ní ndahá ní xīnī ji, tácua ná ndúvāha ji de cutecū ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ñúcuán de cuāhān yā jíín dē. De cuāhā nchivī nī jēcuniquīn ji yā, de nī nchitú nīhin ji níí xiín yā cuāhān ji. ");
INSERT INTO mieNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","De māhñú ndá nchivī cuāhān iin ñahan cúhū, de ja nī ncuu ūxī ūū cuīyā ndóho ña cuēhē játi nīñī ña. ");
INSERT INTO mieNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","De nī ndoho ndasí ña, chi nī jāxīn ña ndihi jā névāha ña jíín cuāhā tēe tátán, de nduú ní jétíñú jā nduvāha ña, chi sa víhí cā sáhá. ");
INSERT INTO mieNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","De ñahan yáhá tá nī jini ña tūhun Jesús, de nī nquenda ña ichi chátā yā māhñú nchivī cuāhā, de nī nquehé ña yuhú sáhmá yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Chi nī jani inī ña: Vísō sahma yā ná níhīn ni quehé nī, de nduvāha nī. ");
INSERT INTO mieNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","De nī jencuiñī-ni jā játi nīñī ña, de nī jinī ña jā ní nduvāha ña cuēhē ndóho ña. ");
INSERT INTO mieNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","De Jesús nī jinī yā jā ní nduvāha iin nchivī jíín fuerza yā. De nī jicó cóto yā nūū nchivī cuāhā, de nī ncāhān yā: ¿Ní iin nī nquehé sahma nī? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","De ndá tēe scuáha jíín yā, nī ncāhān dē: Ndéhé ní jā nchivī cuāhā yáhá nī nchitú nīhin ji xiín ní de cáquīhi ji níhín níí ichi, de mitan jícā tūhún ní ní iin nī nquehé sahma ní, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","De maá yā ndéhé yā cháhá chúcuán, cúnī yā jā ná cáhān nchivī jā ní nsāhá. ");
INSERT INTO mieNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","De ñahan ñúcuán yúhú ña de quísi ña, de ja jínī ña jā ní nduvāha ña. De nī nquenda ña, de nī jēcuīñī jītí ña nūū yā, de nī ncachī ña ndihi nāsa nī ncuu jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","De nī ncāhān yā jíín ña: Tíhī, nī ncandíja nú jā cuu nasāhá vāha nī ndóhó, de jā ñúcuán nī nduvāha nú. Cuáhán de ndusiī inī nū, chi ja nī nduvāha nú cuēhē jā ní ndoho nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","De juni cáhān cā yā súcuán, de nī nquenda sava nchivī jā ndéē vehe tēe cúñáhnú inī vehe īī sinagoga, de nī ncāhān ji jíín dē: Ja nī jīhī sēhe síhí ní. De mā sátéñú ní cā Maestro, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","De Jesús chi nduú ní nsáhá yā cuenta jā súcuán cáhān ji, chi nī ncāhān yā jíín tēe cúñáhnú inī vehe īī sinagoga: Mā cúyūhú nú, chi candíja nú-ni jā nastécū ni ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","De nduú ní jéhe cā yā tūhun jā cuniquīn ndá nchivī yā, chi maá-ni Pedro jíín Jacobo, jíín Juan ñanī Jacobo. ");
INSERT INTO mieNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","De nī jīnū yā vehe tēe cúñáhnú inī vehe īī sinagoga, de nī jinī yā nchivī, de cúvaā ji, de jácu ji, de jácu cóhó ji. ");
INSERT INTO mieNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","De nī nquīvi yā, de nī ncāhān yā: ¿Nūcu cúvaā ndasí ndá nú de jácu nú? Ñahan lúlí ñúcuán nduú ní jíhī ji, chi quíxīn ji-ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","De nī jācū catá ndá ji jā ní ncāhān yā, chi jínī ji jā ní jīhī sūchí ñúcuán. De nī ntavā ndihi yā ji cuāhān ji tāvēhé. De nī ncana yā maá-ni tatá jíín naná ñahan lúlí, jíín ndá tēe íyó jíín yā, de nī nquīvi yā nūū cáá ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","De nī ntiin yā ndahá ji, de nī ncāhān yā jíín ji: Talita cumi, ncachī yā. De tūhun yáhá cáchī: Tíhī, cáhān ni ndóhó, nacōo. ");
INSERT INTO mieNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","De nī natecū-ni ñahan lúlí ñúcuán, chi nī nacuiñī ji de nī nacaca ji, chi ja íyó ji ūxī ūū cuīyā. De nī nsāhvi ndasí inī ndá nchivī nī jinī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","De nī ndacu nīhin yā nūū ndá ji jā má cāchí cuitī ji nūū ni iin. De nī ncachī yā jā ná cuáha ña jā cajī ñahan lúlí. ");
INSERT INTO mieNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","De nī nquee Jesús ñúcuán, de cuānohōn yā ñuū yā. De ndá tēe scuáha jíín yā, cuāhān dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","De maá quīvī nátātú nī stéhēn yā tūhun inī vehe īī sinagoga. De cuāhā nchivī nī nsāhvi inī ji nī jini ji, de nī ncāhān ji: ¿Ní cúu nūū ní ncutūha tēe yáhá ndá tūhun yáhá? ¿De nāsa cúu jā cáhān dē ndá tūhun ndíchí yáhá jíín jā sáhá dē ndá tiñu ñáhnú yáhá? ");
INSERT INTO mieNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Chi tēe yáhá cúu carpintero, de sēhe María cúu dē, de ñanī Jacobo jíín José jíín Judas jíín Simón cúu dē. De suni ndéē ndá cuāha dē jíín ó yáhá, ncachī ji. De súcuán nī nsāhá jéhe inī ndá ji nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","De nī ncāhān yā jíín ji: Ndācá tēe nácani tūhun Yāā Dios, íyó yíñúhún nchivī jíín dē, chi maá-ni nchivī ñuū dē, jíín táhán dē, jíín nchivī vehe dē cúu jāá nduú íyó yíñúhún jíín dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","De nduú ní ncúu sāhá yā cuāhā tiñu ñáhnú ñúcuán. Chi jacū-ni nchivī cúhū nī ntee yā ndahá yā ji, de nī nduvāha ji. ");
INSERT INTO mieNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","De sáhvi inī yā ndéhé yā jāá nduú cándíja ndá ji. Ñúcuán de nī jica nuu yā ndá ñuū ñatin, nī stéhēn yā tūhun. ");
INSERT INTO mieNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","De nī ncana yā ndihúxī ūū tēe scuáha jíín yā, de nī ntají yā ndihuū ndihuū dē jā quíhīn dē. De nī nsāhá yā jā cundiso tíñú dē jā tavā dē ndá tāchī inī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","De nī ndacu yā jā má cuīsó dē jā cuetíñú dē ichi, ni ñunu, ni stāā, ni xūhún. Chi maá garrote-ni cundahá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","De quihi dē nījān, de ni mā quíhīn dē jíín ūū camisa, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","De suni nī ncāhān yā jíín dē: Nā-ni vehe quīvi ndá nú, de ñúcuán cundeē nū jondē quee tucu nú quīhīn nū incā ñuū. ");
INSERT INTO mieNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","De tú iin ñuū nduú jétáhví ji ndóhó, ni nduú cúnī ji cunini ji tūhun cáhān nū, de quee ndá nú ñúcuán, de scóyo nú tīcāchāā jēhē nū, chi suu cúu jā stéhēn nū jā íyó cuāchi ji jāá nduú ní jétáhví ji. De ndāā cáhān ni jíín ndá nú jā quīvī juicio de xēēn cā coo castigo sīquī ndá ñuū sáhá súcuán nsūú cā sīquī ñuū Sodoma jíín ñuū Gomorra nūū ní nsāhá ndasí nchivī cuāchi, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","De nī nquee ndá dē cuāhān dē, de nī nacani dē tūhun jā ná nácani inī ndá nchivī jā sndóo ji cuāchi ji. ");
INSERT INTO mieNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","De suni nī ntavā dē cuāhā tāchī inī nchivī. De nī nchihi dē aceite cuāhā nchivī cúhū, de nī nduvāha ji. ");
INSERT INTO mieNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","De rey Herodes nī nīhīn dē tūhun tá sáhá Jesús, chi nī jītē nuu tūhun yā níí cáhnú. De nī ncāhān dē: Tēe ñúcuán cúu Juan, tēe jā ní scuénduté, de nī natecū dē. Jā suu cúu jā íyó poder dē jā sáhá dē ndá tiñu ñáhnú, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","De sava cā nchivī nī ncāhān ji: Tēe ñúcuán cúu Elías jā ní nacani tūhun janahán. De sava cā ji nī ncāhān: Nduú chi iin tēe nácani tūhun Yāā Dios cúu dē, tá cúu ndá tēe nī nacani tūhun yā jondē janahán, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","De tá nī jini Herodes, de nī ncāhān dē: Nduú chi ñúcuán cúu Juan jā ní ndacu nī jā tēhndē xīnī, de nī natecū dē túsaá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Chi maá Herodes nī ndacu dē jā ná quívi Juan vecāa, jíín jā cunuhnī dē jíín cadena. Súcuán nī nsāhá dē jā síquī Herodías, ñasíhí ñanī dē Felipe. Chi Herodes nī nacueca dē ña jā cúu tucu ña ñasíhí dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","De Juan nī ncāhān dē nūū Herodes: Nduú nā ley íyó jā nacueca nú ñasíhí ñanī nū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","De jā ñúcuán nī jinī ūhvī Herodías Juan, de cúnī ña jā ná cúū dē, sochi nduú ní níhīn ña modo. ");
INSERT INTO mieNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Chi Herodes yúhú dē jā cahnī dē Juan, chi jínī dē jā tēe ndāā tēe ndoo cúu Juan. De jā ñúcuán nī jasī dē jā ndúcú ña cahnī ña Juan. De jétahān inī dē níni dē tūhun yā jā cáhān Juan, vísō nduú jícūhun vāha inī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","De nī nquenda iin quīvī jā ní ncundeé Herodías. Chi nī nsāhá Herodes iin vico quīvī jā ní ncacu dē, de nī jēhe dē jā ní ncuxíní ndá tēe ndíso tíñú nūū dē, jíín ndá tēe cúu capitán, jíín ndá tēe cúñáhnú región Galilea. ");
INSERT INTO mieNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","De nī nquīvi sēhe síhí Herodías, nī jita jéhé ji nūū chitú ñúcuán. De nī ncusiī inī rey Herodes jíín ndá tēe jā cúxíní jíín dē. De nī ncāhān dē jíín ñahan lúlí: Cācān nā cuá cúnī nū de taji nī nūū nū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","De nī ncāhān téyíí dē jā cuāha dē nā-ni cúu jā cúnī ji cācān ji, vísō jondē sava región jā tíin dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","De nī nquee ji nī jīcā tūhún ji naná ji: ¿Nā cuá cúu jā cācān sá nūū dē? ncachī ji. De nī ncāhān ña: Xīnī Juan tēe scuénduté cācān nū nūū dē, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ñúcuán de nī ndīvi ji-ni nūū rey, de nī ncachī ji: Cúnī sá jā mitan ñúhún-ni taji ní xīnī Juan tēe scuénduté, cuhun nūū iin cōhō, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ñúcuán de nī ncucuécá ndasí inī rey. Sochi sīquī jā ní ncāhān téyíí dē, jíín sīquī jā ní jini ndá tēe yájī stāā jíín dē, jā ñúcuán nduú ní nsásáhán dē jā ní jīcān ji. ");
INSERT INTO mieNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","De nī ntají dē-ni iin soldado jā quíquēhen dē xīnī Juan. ");
INSERT INTO mieNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","De nī jēhēn soldado inī vecāa, de nī jehndē dē xīnī Juan. De nī nenda dē jíín xīnī Juan, ñúhún nūū iin cōhō. De nī jēhe dē nūū ñahan lúlí, de maá ji nī jēhe ji nūū naná ji. ");
INSERT INTO mieNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","De ndá tēe nī scuáha jíín Juan nī nīhīn dē tūhun, de nī jēhēn ndá dē, nī nanee dē yiqui cúñu Juan, de nī nchiyuhū dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ñúcuán de ndá tēe cúu apóstol jā ní ntají Jesús jā nacani tūhun, nī nenda ndá dē nūū yā. De nī nacani dē ndācá tiñu jā ní nsāhá dē, jíín tūhun jā ní stéhēn dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","De nī ncāhān yā jíín dē: Ná cóhōn iin lugar nūū nduú nchivī, de natātú ó jacū, ncachī yā. Chi cuāhā nchivī cuāhān vāji ji nūū yā, de nduú ní núne yā jā cajī yā stāā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ñúcuán de nī nquīvi yā iin barco jíín ndá apóstol, de cuāhān sīín yā jíín dē iin lugar nūū nduú nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sochi nī jinī cuāhā nchivī jā cuáhān ndá dē jíín yā, de nī jinī ji jā maá yā cúu. De jondē ndācá ñuū ñúcuán nī nquee ndá ji, de ñamā nī jica jéhé ji, de xihna cā ji nī nquenda nsūú cā maá yā. ");
INSERT INTO mieNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","De tá nī nquee Jesús inī barco, de nī jinī yā nchivī cuāhā ñúcuán. De nī ncundáhví inī yā ji, chi cúu ji tá cúu tīcāchí jāá nduú jētohō tī. De nī stéhēn yā cuāhā tūhun nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","De tá nī ñini, de ndá tēe scuáha jíín yā, nī nquenda dē nūū yā, de nī ncāhān dē: Ja nī ñini, de nduú nā nchivī ndéē yáhá. ");
INSERT INTO mieNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Túsaá de tají ní nchivī ná quíhīn ndá ji ndá rancho jíín ndá ñuū ñatin, de cueen ji stāā cajī ji, chi nduú nā cuá ndíso ji jā cajī ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","De nī ncāhān Jesús jíín dē: Cuāha ndá máá nú jā cajī ji, ncachī yā. De nī ncāhān ndá dē: ¿De nāsa cuu? Chi ni mā cūú vísō ná quícuēen sá ūū ciento denario stāā cajī nchivī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","De nī ncāhān yā jíín dē: ¿Nāsaa stāā névāha ndá nú? Cuándēhé, ncachī yā. De tá nī jinī ndá dē, de nī ncachī dē: Uhūn-ni stāā jíín ūū tiacá íyó, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ñúcuán de nī ncāhān yā jíín ndá nchivī jā ná cúndeē sīín ji cuenta grupo nūū itē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","De nī jēcundeē sīín ciento ciento ji, jíín cincuenta cincuenta ji. ");
INSERT INTO mieNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","De nī nquehen yā ndihúhūn stāā jíín ndúū tiacá ñúcuán, de nī nūcūndēhé yā ichi andiví, de xihna cā nī nacuetáhví yā nūū Tatá yā. De nī scuáchi yā stāā, de nī jēhe yā nūū ndá tēe scuáha jíín yā, de ndá máá dē nī nsajī nūū nchivī cuāhā. De suni súcuán nī nsāhá yā jíín ndúū tiacá, de nī nsajī ndá dē nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","De ndiviī ji nī nchajī, de nī ndahā chījin ji. ");
INSERT INTO mieNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sá de nī nastútú ndá dē pedazo stāā jíín tiacá jā ní nquendōo, de nī nchitú ūxī ūū tīcá. ");
INSERT INTO mieNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","De tēe jā ní nchajī cúu ūhūn mil. ");
INSERT INTO mieNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ñúcuán de nī ncachī-ni Jesús nūū ndá tēe scuáha jíín yā jā ná quívi dē inī barco, de cosō nūú dē yāha dē incā lado mar ñuū Betsaida. De maá yā natají yā ndá nchivī quīnohōn ji, sá de suni quīhīn yā. ");
INSERT INTO mieNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","De tá nī ncuu nī natají yā ndá ji, de nī ncaa yā yucu cuācācān táhvī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","De tá nī ncuaā, de ja ñúhún barco jondē sava mar cuāhān, de mátúhún yā-ni cā nī ndōo nūū ñuhun yíchí. ");
INSERT INTO mieNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","De nī jinī yā jā tūndóhó ndasí scáca ndá dē barco, chi nīhin vāji tāchī ichi núū dē. De yíneē cā nī nquenda yā nūū dē, jíca jéhé yā nūū mar. De yáha yā-ni nūū dē quīhīn yā nícu. ");
INSERT INTO mieNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","De nī jinī ndá dē jā jíca yā nūū mar, de nī jani inī dē jā ñíhná cúu, de nī ncana cóhó ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Chi ndihi dē nī jinī nūū yā, de nī nchūhú ndasí dē. De nī ncāhān yā-ni jíín dē: Ndeé coo inī ndá nú, de mā cúyūhú nú, chi maá nī cúu, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","De nī ncaa yā nī nquīvi yā inī barco, de nī jencuiñī-ni tāchī. De nī nsāhvi ndasí inī ndá dē ndéhé dē jā ní ncuu. ");
INSERT INTO mieNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Chi íyó neē cā jāá ntúnī ndá dē, chi juni jíín tiñu ñáhnú jā ní nducuahā stāā, de nduú ní jícūhun inī dē jā cúu yā Yāā jā ní ntají Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","De nī nchāha yā jíín ndá dē incā lado mar, de nī nquenda yā región Genesaret. De yuhú ndúté ñúcuán nī juhnī ndá dē barco. ");
INSERT INTO mieNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","De tá nī nquee ndá dē jíín yā inī barco, de ndá nchivī ñúcuán nī nacunī ji-ni yā. ");
INSERT INTO mieNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","De ñamā nī jēhēn ji ndācá ndáñúū ñúcuán, de nī nquisiáha ji ndá nchivī cúhū, yósō ji nūū camilla, vāji ndá nchivī nūū ní nīhīn ji tūhun nūū íyó yā. ");
INSERT INTO mieNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","De ní-ni cúu nūū ní nquīvi yā, á ñuū lulí, á ñuū cāhnú, á rancho, de jáquīn ji nchivī cúhū inī ichi, de cáhān ndāhví ji jíín yā jā ná quéhé ji vísō yuhú sáhmá yā. De ndācá nchivī jā ní nquehé sahma yā, nī nduvāha ji-ni. ");
INSERT INTO mieNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ñúcuán de ndá tēe grupo fariseo jíín jacū tēe stéhēn ley janahán, vāji ndá dē ichi Jerusalén, de nī nquenda dē nūū Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","De ndá tēe ñúcuán nī jinī dē jā sava tēe scuáha jíín Jesús, nī nchajī tēhén dē stāā, chi nduú ní squíncuu dē costumbre jā nandahá dē nūū Yāā Dios. De nī ncāhān sīquī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Chi tēe fariseo jíín ndihi nchivī hebreo, névāha ji costumbre janahán jā má cājí ji stāā de tú nduú xihna cā nandahá vāha ji. ");
INSERT INTO mieNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","De tá nénda ji jā jéhēn ji nūū yáhvi, de nduú yájī ji de tú nduú nándahá ji. De íyó cuāhā cā costumbre janahán jā squíncuu ndá ji, tá cúu jā ndúndoo taza, tīndōhō, cōhō cāa, jíín jīto. ");
INSERT INTO mieNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","De ndá tēe fariseo jíín ndá tēe stéhēn ley janahán, nī jīcā tūhún dē yā: Ndá tēe scuáha jíín nú, ¿nūcu nduú squíncuu dē costumbre nchivī janahán, chi sa yájī tēhén dē stāā? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","De nī ncāhān yā jíín dē: Ndāā nī nacani Isaías tūhun sīquī ndá nú jā tēe stáhví-ni cúu nú. Chi súcuán nī ntee dē tūhun jā ní ncāhān Yāā Dios janahán: Nchivī yáhá chi jíín yuhú ji-ni jétáhví ji nduhū, sochi nsūú jondē jíín inī jíín ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","De chíñúhún cāhá ji nduhū, chi tūhun stéhēn ji cúu tiñu jā ní ndacu ndá tēe, de nsūú jā ní ndacu maá nī cúu. Ncachī Yāā Dios jā ní ntee Isaías. ");
INSERT INTO mieNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Súcuán cúu ndá nú, chi nī nsiáā nū tiñu jā ní ndacu Yāā Dios nūū nū, de squíncuu nú costumbre jā ní jaquīn nchivī, jā ndúndoo tīndōhō jíín taza. De cuāhā cā costumbre súcuán squíncuu nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","De suni nī ncāhān yā: Ndá ndóhó chi siáā nū tiñu jā ní ndacu Yāā Dios tácua squíncuu nú costumbre jā ní jaquīn ndá máá nú. ");
INSERT INTO mieNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chi Moisés nī ncāhān dē: Coo yíñúhún nú nūū tatá nú nūū naná nú. De tú ní iin cāhān sīquī tatá á sīquī naná, de ná cúū, ncachī Moisés. ");
INSERT INTO mieNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sochi ndá máá nú chi cáchī nū jā cuu cāhān iin tēe jíín tatá dē á naná dē: Mā cūú chindeé sá ní jā taji sá jā cajī ní á jā cusúcún ní, chi ndihi jā névāha sá, chi Corbán cúu, cáchī nū. (De tūhun Corbán cáchī: Ja nī nsōcō dē nūū Yāā Dios.) ");
INSERT INTO mieNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","De cáchī ndá nú jā tú súcuán cáhān iin tēe de nduú cā jíni ñúhún chindeé dē tatá dē á naná dē. ");
INSERT INTO mieNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","De súcuán stíví ndá nú tiñu jā ní ndacu Yāā Dios, jā síquī costumbre jā ní jaquīn nchivī janahán. De cuāhā cā tiñu súcuán sáhá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","De nī ncana tucu yā nchivī cuāhā, de nī ncāhān yā jíín ji: Cunini vāha ndá nú de chuhun inī nū: ");
INSERT INTO mieNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ndācá jā íyó de tú quívi inī yuhú nchivī, de mā cútéhén ji sāhá. Chi jā quée inī ánō nchivī, ñúcuán cúu jā cútéhén ji sáhá. ");
INSERT INTO mieNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ndá ndóhó jā níni, tee sōho vāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","De nī sndóo yā nchivī cuāhā, de nī nquīvi yā inī vehe. De ndá tēe scuáha jíín yā, nī jīcā tūhún dē yā sīquī tūhun yátá yáhá jā ní ncāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","De nī ncāhān yā jíín dē: ¿A suni nduú jícūhun inī ndá máá nú? ¿A nduú jínī nū jā ndācá jā quívi inī nchivī, nduú cútéhén ji sáhá? ");
INSERT INTO mieNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Chi nduú quívi inī ánō ji, chi chījin ji quívi, de quée-ni cuāhān, ncachī yā. Súcuán nī stéhēn yā jā ndācá jā yájī nchivī, nduú cútéhén ánō ji sáhá. ");
INSERT INTO mieNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","De nī ncāhān cā yā: Jā quée inī ánō nchivī, ñúcuán cúu jā cútéhén ji sáhá. ");
INSERT INTO mieNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chi jondē inī ánō nchivī quée jā jáni nēhén inī, jā cásíquí ndéē táhán, jā sáhá ndiī, jā jáhnī ndīyi, ");
INSERT INTO mieNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jā sácuíhná, jā ndíyo inī ndatíñú táhán, jā sáhá nēhén, jā stáhví táhán, jā maá-ni cuāchi sáhá, jā cúcuásún inī, jā cáhān sīquī táhán, jā sáhá vīxī maá, jā íyó naā xīnī. ");
INSERT INTO mieNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ndācá tiñu néhén yáhá chi inī ánō nchivī quée, de cútéhén ji sáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","De nī nquee Jesús ñúcuán cuāhān yā región Tiro jíín Sidón. De nī nquīvi yā iin vehe, de cúnī yā jā má cūní ni iin nchivī jā íyó yā ñúcuán. De vísō súcuán, de nduú ní ncúu cundeē yuhū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","De iin ñahan jā íyó sēhe síhí ña jā ñúhún tāchī inī, nī nīhīn ña tūhun jā íyó yā. De nī nquenda ña, de nī jēcuīñī jītí ña nūū jéhē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","De ñahan incā nación cúu ña, chi Sirofenicia cúu nación ña. De nī ncāhān ndāhví ña jíín yā jā ná távā yā tāchī inī sēhe síhí ña. ");
INSERT INTO mieNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","De nī ncāhān Jesús jíín ña: Nsūú nūū ndá máá ní vāji sá, chi maá-ni nūū nchivī jā cúu sēhe Israel. Chi nduú vāha jā candeē ō stāā sēhe ó de cuāha ó nūū tinā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","De nī ncāhān ña: Ndāā cáhān ní Señor, sochi chindeé ní sāán vísō cúu sá modo tinā. Chi suni íñí ndá tī chījin mesa, de níhīn tī yuchi stáā jā cóyo yuhú sūchí lúlí yájī tī, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ñúcuán de nī ncāhān yā jíín ña: Vāha nī ncāhān ní. Cuáhán ní túsaá, chi ja nī nquee tāchī inī sēhe síhí ní, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","De nī najinū ña vehe ña, de nī jinī ña jā cáá sēhe síhí ña nūū jīto, de ja nī nquee tāchī inī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","De nī nquee tucu yā región Tiro, nī nchāha yā Sidón jíín ndācá ñuū Decápolis, de nī nquenda yā mar Galilea. ");
INSERT INTO mieNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","De nī nquisiáha ndá ji iin tēe sóhó stété nūū yā, de nī ncāhān ndāhví ji jíín yā jā ná tée yā ndahá yā tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","De nī ntavā sīín yā dē nūū ndá nchivī cuāhā, de nī nchuhun yā xīnī ndahá yā sōho dē, de nī ntivī sīí yā, de nī nquehé yā yáá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","De nī nūcūndēhé yā ichi andiví, de nī jēca inī yā, de nī ncāhān yā: Efata, ncachī yā, jā cáchī: Nanune. ");
INSERT INTO mieNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","De nī nune-ni sōho dē, de nī nduvāha yáá dē, de nī ncāhān vāha dē. ");
INSERT INTO mieNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","De nī ndacu yā nūū ndá nchivī jā má cāchí ji nūū ni iin. De vísō nī ncāhān nīhin yā jíín ji, de sa víhí cā nī scútē nuu ji tūhun. ");
INSERT INTO mieNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chi nī nsāhvi ndasí inī ji ndéhé ji, de nī ncāhān ji: Vāha sáhá yā ndācá tiñu, chi jondē ndá tēe sóhó núne sōho dē, de ndá tēe ñíhín nácahān vāha dē sáhá yā, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","De tiempo ñúcuán nī ndutútú cuāhā ndasí nchivī, de nduú nā cuá cajī ji. De nī ncana Jesús ndá tēe scuáha jíín yā, de nī ncāhān yā: ");
INSERT INTO mieNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Cúndáhví inī ni ndá nchivī yáhá, chi ja nī ncuu ūnī quīvī íyó ji jíín nī, de nduú cā jā cajī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","De tú natají nī ji quīnohōn nditē ji vehe ji, de sava ichi de cuitá ndasí ji, chi íyó sava ji jā jícá vāji ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","De nī ncāhān ndá tēe scuáha jíín yā: ¿De ní nīhīn ō stāā jā cajī ndá ji? Chi yáhá nduú nā nchivī ndéē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","De nī jīcā tūhún yā dē: ¿Nāsaa stāā névāha ndá nú? Ujā-ni, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ñúcuán de nī ncāhān yā jíín nchivī cuāhā jā ná cúndeē ji. De nī nquehen yā ndihújā stāā, de xihna cā nī nacuetáhví yā nūū Yāā Dios. De nī scuáchi yā, de nī jēhe yā nūū ndá tēe scuáha jíín yā. De ndá máá dē nī nsajī dē nūū nchivī cuāhā. ");
INSERT INTO mieNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","De suni íyó jacū tiacá lúlí. De nī jīcān táhvī yā jēhē, de nī ncāhān yā jā suni sajī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","De ndihi ji nī nchajī, de nī ndahā chījin ji. Ñúcuán de nī nastútú ndá dē pedazo jā ní nquendōo, de nī nchitú ūjā tīcá. ");
INSERT INTO mieNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","De tēe jā ní nchajī, íyó tá cūmī mil dē. Sá de nī nacuetáhví yā nūū nchivī, de cuānohōn ji. ");
INSERT INTO mieNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","De nī ndīvi yā-ni inī barco jíín ndá tēe scuáha jíín yā, de cuāhān yā región Dalmanuta. ");
INSERT INTO mieNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ñúcuán de nī nquenda ndá tēe grupo fariseo, de nī nquijéhé dē stíchī dē Jesús. De cúnī ndá dē coto túnī dē yā, de nī jīcān dē jā sāhá yā iin tiñu ñáhnú jā coo iin seña ichi andiví. ");
INSERT INTO mieNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","De nī jēca inī yā sīquī jāá nduú cándíja ndá dē, de nī ncāhān yā: ¿Nūcu jícān ndá nchivī yáhá iin tiñu ñáhnú nūū ni? De ndāā cáhān ni jā ni iin tiñu ñáhnú mā stéhēn ni nūū nchivī yáhá. ");
INSERT INTO mieNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","De nī sndóo yā ndá dē, de nī ndīvi tucu yā inī barco, de cuāhān yā incā lado mar. ");
INSERT INTO mieNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","De ndá tēe scuáha jíín yā, nī naā inī dē cuiso dē jā cajī dē, chi iin-ni stātílā névāha ndá dē inī barco. ");
INSERT INTO mieNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","De nī ndacu yā nūū dē: Coto má candíja ndá nú levadura ndá tēe grupo fariseo jíín levadura Herodes, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","De nī ncāhān ndá tēe scuáha jíín ndá táhán dē: Va sīquī jāá nduú nā stāā ndíso ó, jā ñúcuán cáhān yā súcuán, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","De nī jinī Jesús, de nī ncāhān yā: ¿Nājēhē cúu jā nátúhún ndá nú jā ní ncāhān ni súcuán sīquī jāá nduú nā stāā ndíso nú? ¿A ncháha ca cunī nū, á ncháha ca jīcūhun inī nū jāá nsūú sīquī ñúcuán cáhān ni? ¿A uun ndasí inī ndá nú jā candíja nú? ");
INSERT INTO mieNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Iyó tīnūú nú, ¿de á nduú ndéhé nú? Iyó sōho nú, ¿de á nduú jíni nú? ¿De á nduú núcūhun inī nū? ");
INSERT INTO mieNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Chi tá nī scuáchi nī ūhūn stāā jā ní nchajī ūhūn mil tēe, ¿de nāsaa tīcá nī nchitú pedazo stāā jā ní nastútú nú? ncachī yā. Uxī ūū, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","De saá-ni tá nī scuáchi nī ūjā stāā jā ní nchajī cūmī mil nchivī, ¿de nāsaa tīcá nī nchitú jā ní nastútú nú pedazo stāā? ncachī yā. Ujā, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","De nī ncāhān yā jíín dē: ¿De jondē mitan á ncháha ca jīcūhun inī ndá nú? ncachī yā. Súcuán nī ncāhān yātá yā jā má cándíja ndá dē tūhun stáhví jā stéhēn ndá tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ñúcuán de nī nquenda yā jíín ndá dē ñuū Betsaida. De nī nquisiáha nchivī iin tēe cuáá nūū yā, de nī ncāhān ndāhví ji jíín yā jā ná tée yā ndahá yā nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ñúcuán de nī ntiin yā ndahá tēe cuáá, de nī ntavā yā dē yātā ñúū. De nī ntee yā ntesíi yā tīnūú dē, de nī ntee yā ndahá yā dē. De nī jīcā tūhún yā dē tú cuu cunī dē jacū. ");
INSERT INTO mieNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","De nī nūcūndēhé dē, de nī ncāhān dē: Jínī sá nchivī jā jíca ji, de nduú jínī cājí sá, chi tá cáá ñutun cáá ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ñúcuán de nī ntee tucu yā ndahá yā tīnūú dē. De nī nūcūndēhé vāha dē, de nī nduvāha-ni tīnūú dē, de nī jinī cājí dē ndihi-ni. ");
INSERT INTO mieNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","De nī natají yā dē jā quínohōn dē vehe dē, de nī ncachī yā: Mā quívi nú ñuū, de mā cāchí cuitī nū nūū ni iin, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sá de Jesús jíín ndá tēe scuáha jíín yā, cuāhān yā ndācá ndáñúū Cesarea Filipo. De ichi nī jīcā tūhún yā dē: De nduhū, ¿ní iin cúu nī cáchī ndá nchivī? ");
INSERT INTO mieNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","De nī ncāhān ndá dē: Sava ji cáhān jā cúu ní Juan, tēe jā ní scuénduté. De sava cā ji cáhān jā cúu ní Elías, tēe nī nacani tūhun Yāā Dios jondē janahán. De sava cā ji cáhān jā cúu ní incā tēe nī nacani tūhun Yāā Dios, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ñúcuán de nī jīcā tūhún yā dē: De ndá máá nú, ¿ní iin cúu nī cáchī ndá nú? De nī ncāhān Pedro: Maá ní cúu Cristo, Yāā jā ní ntají Yāā Dios, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","De nī ndacu yā nūū ndá dē jā má cāchí dē tūhun yáhá nūū ni iin nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","De nī nquijéhé yā stéhēn yā nūū ndá dē: Maá nī, Yāā nī nduu tēe, cánuú jā ndoho ndasí nī. De ndá tēe ñáhnú jíín ndá sūtū cúñáhnú jíín ndá tēe stéhēn ley janahán, cuyichī inī dē nduhū, de cahnī dē nduhū. Sochi nūū únī quīvī de natecū ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","De cájí nī ncāhān yā tūhun yáhá. Ñúcuán de Pedro nī ncana síín dē yā, de nī nquijéhé dē cáhān dē nūū yā jā má cuáha yā tūhun jā coo súcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","De maá yā nī jicó cóto yā, nī ndēhé yā nūū ndá tēe scuáha jíín yā. De nī ncāhān yā nūū Pedro: Cujiyo quīhīn nū, chi cáhān nū tá cáhān Satanás. Chi nduú jáni inī nū tá cúu nūū jáni inī Yāā Dios, chi sa jáni inī nū tá cúu nūū jáni inī nchivī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","De nī ncana yā ndá tēe scuáha jíín yā jíín ndá nchivī cuāhā, de nī ncāhān yā: Nā-ni nchivī tú cúnī ji cuniquīn ji nduhū jā scuáha nī ji, de ná cásī ji jā cúnī maá ji, de ná cúniquīn ji nduhū de cuāha ji tūhun jā cundoho ji tūndóhó jā síquī ni, vísō ná cúū ji. ");
INSERT INTO mieNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","De tú ní nchivī cúnī ji cācu ji nūū tūndóhó jā quiji nūū ji jā síquī nduhū, túsaá de tānū tāhvī ji níí cání. De tú ní nchivī vísō ná cúū ji jā síquī nduhū jíín sīquī jā scáca ji tūhun jā scácu nī nchivī, túsaá de cutecū ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Chi ní cuetíñú vísō ná cúndeé nchivī nīhīn ji níí ñayīví, de tú quīvi ji nūū tānū tāhvī ji? ");
INSERT INTO mieNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Chi nduú nā jīín cuitī chunáá nchivī jā cācu ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","De nchivī yáhá nduú cándíja cuitī ji, de cúsá maá cuāchi sáhá ji. De tú nā-ni nchivī cúcanoō ji nūū nchivī yáhá jā síquī nduhū, Yāā nī nduu tēe, jíín sīquī tūhun cáhān ni, de suni súcuán cucanoō ni jā síquī maá ji, quīvī jā nenda nī jíín ndācá ángel ndoo nī. De quīvī ñúcuán chi viī ndasí cuñáhnú nī, tá cúu nūū cúñáhnú Tatá nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","De suni nī ncāhān yā jíín ndá dē: Ndāā cáhān ni jíín ndá nú jā sava tēe íyó yáhá, mā cúū cuitī dē chi jondē cunī dē nāsa tátúnī Yāā Dios jíín poder yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ñúcuán de nūū íñū quīvī, de Jesús nī jeca yā Pedro jíín Jacobo jíín Juan, de cuāhān sīín yā jíín dē iin yucu súcún. De ñúcuán, tucu nī nduu yā nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","De sahma yā nī jēndūtē, de nī nduyaa ndasí tá cáá yūhā volcán. De nduú ni iin nchivī ñayīví yáhá cuu naquete ji jā nduyaa ndasí súcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","De nī jinī ndá dē jā Elías jíín Moisés, tēe nī īyo janahán, nátúhún ndúū dē jíín Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ñúcuán de nī ncāhān Pedro jíín yā: Maestro, nācā vāha jā íyó ndá sá yáhá, de ná sáhá ndá sá ūnī vehe ramádā, iin cuu maá ní, incā cuu Moisés, de incā cuu Elías, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Chi nī nchūhú ndasí ndá dē, de Pedro nduú ní nsáhá dē cuenta nā cuá cúu jā cáhān dē. ");
INSERT INTO mieNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","De nī nquiji iin vīcō nūhún, de nī jasī-ni nūū ndá dē. De nūū vīcō ñúcuán nī ncāhān iin tūhun: Yáhá cúu Sēhe nī jā mānī ndasí nī jíín. De cunini ndá nú tūhun cáhān yā, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","De nī nūcūndēhé ndá dē-ni, de nduú cā ní jínī dē ndúū tēe ñúcuán, chi maá-ni cā Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","De nī nuu ndá dē jíín yā yucu. De nī ndacu nīhin yā nūū dē jā má cāchí dē nūū ni iin jā súcuán nī jinī ndá dē, chi jondē tá natecū maá yā, Yāā nī nduu tēe, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jā ñúcuán nī nchuhun inī ndá dē ndācá jā ní ncuu ñúcuán, de jícā tūhún táhán dē nā tūhun cúu jā natecū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","De nī jīcā tūhún dē yā: De ndá tēe stéhēn ley janahán, ¿nājēhē cáhān dē jā cánuú jā xihna cā Elías nenda, sá de quiji Yāā cúu Cristo? ncachī de. ");
INSERT INTO mieNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","De nī ncāhān yā jíín dē: Jāndáā cúu jā xihna cā quiji iin tēe cuu tá ncuu Elías, de sāhá tūha dē ndihi, cáchī tutū. ¿De nā cuá cáhān tucu tutū īī sīquī nduhū, Yāā nī nduu tēe? Cáhān jā ndoho ndasí nī, de sāhá jéhe inī ji nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sochi cáhān ni jíín ndá nú, ja nī nquiji tēe jāá ncuu tá cúu nūū ní ncuu Elías, de nī nsāhá nāvāha ndá ji dē ndihi jā ní ncuu inī ji, tá cúu nūū cáhān tūhun dē nūū tutū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","De nī nenda yā jíín ndá dē nūū ndá cā tēe scuáha jíín yā, de nī jinī yā nchivī cuāhā ndasí, nī jicó ndúū ji ndá dē. De suni íyó ndá tēe stéhēn ley janahán, stáhān tāhán dē jíín ndá tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","De tá nī jinī ndá nchivī jā váji yā, de sáhvi inī ji, de jínu ji cuāhān ji nūū yā jā cāhān ji jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","De nī jīcā tūhún yā ndá tēe stéhēn ley janahán: ¿Nā sīquī stáhān tāhán ndá nú jíín ndá dē? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","De nī ncāhān iin tēe íyó ñúcuán: Maestro, nī nquisiáha sá sēhe yií sá nūū ní, chi ñúhún iin tāchī inī ji, de nī ncuñíhín ji nī nsāhá. ");
INSERT INTO mieNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","De ní-ni cúu nūū íyó ji, de tāchī ñúcuán jáhnī yīhí ji de scócáva ji nūū ñūhún. De jée tīñū yuhú ji, de cáhñī nūhun ji sáhá. De cuācuxií ndasí ji. De nī ncāhān ndāhví sá jíín ndá tēe scuáha jíín ní jā ná távā dē tāchī, de nduú ní ncúu sāhá dē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ñúcuán de ni ncāhān Jesús: Tēe nduú cándíja cuitī cúu ndá nú. ¿De nāsaa cā quīvī cundeē ni jā ndoho nī jíín nú? ¿De nāsaa cā quīvī cuandeé inī ni jíín nú? Cuáquēhen sūchí ñúcuán ná quíji ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","De nī nquisiáha ndá dē ji nūū yā. De tá nī jinī tāchī nūū yā, de nī jahnī yīhí ji-ni. De nī jicó cáva ji nūū ñūhún, de nī ntuū ji, de nī jee tīñū yuhú ji. ");
INSERT INTO mieNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","De Jesús nī jīcā tūhún yā tatá ji: ¿Nāsaa tiempo cúu jā sáhá súcuán jíín ji? ncachī yā. De nī ncāhān dē: Jondē lulí ji. ");
INSERT INTO mieNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","De nī ncuu cuāhā vuelta nī scócáva tāchī ji nūū ñúhūn jíín nūū ndūté, jā cahnī ji cúnī. De tú cuu sāhá ní, de cundáhví inī ní sāán de chindeé chituu ní sāán jā nduvāha sēhe sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","De nī ncāhān Jesús jíín dē: Tú cuu candíja nú jā sāhá nī, chi nchivī cándíja de cuu ndācá-ni jā cúnī ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","De maá tatá sūchí ñúcuán nī ncāhān jee dē: Cándíja sá, de chindeé chituu ní sāán jā candíja nīhin cā sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","De nī jinī Jesús jā távī ndasí nchivī nūū yā. De nī ncāhān yā nūū tāchī: Ndóhó tāchī jā ní nsāhá jāá ncuñíhín ncusóhó ji, nduhū tátúnī ni nūū nū jā quee nú inī sūchí yáhá, de mā ndívi nú cā inī ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ñúcuán de nī ncana cóhó tāchī, de nī jahnī yīhí tucu ji, de nī nquee cuāhān. De sūchí ñúcuán nī ncuu ji modo ndīyi, de nī ncāhān cuāhā nchivī jā ní jīhī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sochi Jesús nī ntiin yā ndahá ji, de nī nacani yā ji, de nī nūcuīñī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sá de nī nquīvi Jesús inī iin vehe, de ndá tēe scuáha jíín yā nī jīcā tūhún síín dē yā: ¿Nājēhē cúu jāá nduú ní ncúu tavā ndá sá tāchī ñúcuán? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","De nī ncāhān yā: Iin tāchī súcuán, chi mā quēé cuitī quīhīn de tú mā cácān táhvī nū de tú mā cōó nditē inī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","De nī nquee yā ñúcuán jíín ndá dē, de nī nchāha yā ndáñúū Galilea cuāhān yā. De nduú cúnī yā jā cunī ni iin nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Chi stéhēn yā nūū ndá tēe scuáha jíín yā, de ncachī yā: Maá nī, Yāā nī nduu tēe, nastúu ndá ji nduhū nūū ndá tēe xēēn. De cahnī dē nduhū, de tá nī jīhī ni, de nūū únī quīvī de natecū ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","De nduú ní jícūhun inī ndá dē tūhun yáhá, de nī nchūhú dē cātūhún dē yā sīquī tūhun jā ní ncāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","De nī nquenda yā jíín ndá dē ñuū Capernaum, de tá nī nquīvi yā inī vehe, de nī jīcā tūhún yā ndá dē: ¿Nā tūhun nī natúhún ndá nú jā váji ó ichi? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","De nduú ní ncáhān cuitī ndá dē, chi ichi nī ncāhān ndá dē sīquī ní iin dē cúñáhnú cā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ñúcuán de nī jēcundeē yā, de nī ncana yā ndihúxī ūū dē, de nī ncāhān yā: Tú ní iin nú cúnī jā cuñáhnú cā, de sa sāhá nú maá nú jā cuu nú tēe núu cā nūū ndá táhán nú, de cuu nú mozo nūū táhán nú. ");
INSERT INTO mieNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ñúcuán de nī ntiin yā ndahá iin sūchí lúlí, de nī jani yā ji māhñú ndá dē. De nī numi yā ji, de nī ncāhān yā jíín ndá dē: ");
INSERT INTO mieNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Nā-ni nchivī de tú jā síquī nduhū jétáhví ji iin sūchí lúlí tá cúu nūū cúu sūchí yáhá, de nduhū jétáhví ji. De nchivī jā jétáhví nduhū, de nsūú maá-ni nduhū, chi suni Yāā jā ní ntají nduhū jétáhví ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ñúcuán de nī ncāhān Juan jíín yā: Maestro, nī jinī ndá sá iin tēe jā jíín síví ní távā dē tāchī inī nchivī. De nī jasī ndá sá jā sáhá dē, chi nduú jíca dē jíín ó, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","De nī ncāhān Jesús jíín dē: Mā cásī ndá nú jā sáhá dē. Chi ni iin tēe jā jíín síví nī sáhá dē tiñu ñáhnú, mā cūú nacahān dē sīquī ni. ");
INSERT INTO mieNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Chi iin tēe jāá nduú cáhān contra sīquī ō, íñí dē jíín ó. ");
INSERT INTO mieNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","De nā-ni nchivī de tú jā síquī nduhū taji ji vísō iin ñajin ndute coho nú, sīquī jā cándíja nú nduhū, de ndāā ndija cúu jā nīhīn ji tāhvī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","De tú iin sūchí lúlí yáhá cándíja ji nduhū, de tú quīvi ji cuāchi sāhá nā-ni nchivī, de vāha cā de tú ní núhnī iin yōsó cáhnú sūcūn nchivī ñúcuán, de quēe ji chījin ndute mar nícu. ");
INSERT INTO mieNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","De tú ndahá nú sáhá jā quīvi nú cuāchi, de vāha cā quehndē nū ná quíhīn, tácua nduú cā sāhá nú cuāchi. Chi vāha cā jā coo iin-ni ndahá nú de quīvi nú nūū cutecū nū níí cání, nsūú cā jā coo ndúū ndahá nú de quīvi nú infierno, nūū cáyū ñuhūn jā má ndáhvā cuitī. ");
INSERT INTO mieNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","De ñúcuán chi nduú jíhī tīndacú, de nduú ndáhvā cuitī ñuhūn. ");
INSERT INTO mieNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","De tú jēhē nū sáhá jā quīvi nú cuāchi, de suni vāha cā quehndē nū ná quíhīn, tácua nduú cā sāhá nú cuāchi. Chi vāha cā jā coo tícúhlu nú de quīvi nú nūū cutecū nū níí cání, nsūú cā jā coo ndúū jēhē nū de quīvi nú infierno, nūū cáyū ñuhūn jā má ndáhvā cuitī. ");
INSERT INTO mieNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","De ñúcuán chi nduú jíhī tīndacú, de nduú ndáhvā cuitī ñuhūn. ");
INSERT INTO mieNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","De tú tīnūú nú sáhá jā quīvi nú cuāchi, de vāha cā tavā nū ná quíhīn, tácua nduú cā sāhá nú cuāchi. Chi vāha cā jā quīvi nú nūū tátúnī Yāā Dios jíín iin-ni tīnūú nú, nsūú cā jā coo ndúū tīnūú nú de quīvi nú infierno. ");
INSERT INTO mieNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","De ñúcuán chi nduú jíhī tīndacú, de nduú ndáhvā cuitī ñuhūn. ");
INSERT INTO mieNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Chi tá cúu nūū quée vāha oro sáhá ñuhūn, suni súcuán quée vāha nchivī sáhá tūndóhó. De ndācá cūñu jā sócō nchivī nūū yā, cúu uhguā sáhá ñīī. ");
INSERT INTO mieNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Vāha íyó ñīī, de tú ñīī ná náā jā úhguā, ¿de nāsa nduu uhguā tucu sāhá nú? Túsaá de cuu nú nchivī vāha, tá cúu nūū íyó vāha ñīī. De cundeē vāha ndá nú jíín táhán nú, ncachī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","De nī nquee yā ñuū Capernaum, de nī jīnū yā región Judea jíín incā lado yūte Jordán ichi nūū quénda ncandiī. De ñúcuán nī ncutútú tucu nchivī nūū yā, de nī stéhēn tucu yā tūhun nūū ji, tá-ni sáhá yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ñúcuán de jacū tēe grupo fariseo nī nquenda dē nūū yā, chi cúnī dē coto túnī dē yā, tú nāsa cāhān yā. De nī jīcā tūhún dē yā tú íyó ley jā cuu ndusíín iin tēe jíín ñasíhí dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","De nī ncāhān yā jíín dē: ¿Nā tiñu nī ndacu Moisés nūū nū jondē janahán? ");
INSERT INTO mieNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","De nī ncāhān ndá dē: Moisés nī jēhe dē tūhun jā cuvāha iin acta jā ndusíín dē jíín ña, de ndōo ña, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","De nī ncāhān Jesús jíín dē: Sīquī jā nīhin inī ndá nú, de jā ñúcuán cúu jā ní ndacu dē tiñu yáhá nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sochi jondē quīvī xíhna ñúhún tá nī nsāhá Yāā Dios ndihi, chi tēe jíín ñahan nī nsāhá yā, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jā ñúcuán cúu jā sndóo tēe tatá dē naná dē, de quétáhán dē jíín ñasíhí dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","De iin-ni cā cúu ndúū dē, cáchī Yāā Dios. Túsaá de nduú cā cúu ūū táhān dē, chi iin-ni cā cúu. ");
INSERT INTO mieNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jā ñúcuán nduú vāha jā sndóo táhán, chi jā ní squétáhán Yāā Dios cúu, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","De tá nī nquīvi ndá dē vehe, de ndá tēe scuáha jíín yā nī jīcā tūhún tucu dē yā sīquī tūhun ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","De nī ncāhān yā jíín dē: Tú nā-ni tēe sndóo dē ñasíhí dē, de nacueca dē incā ñahan, túsaá de cásíquí ndéē dē ñasíhí dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","De tú iin ñahan sndóo ña yií ña de nacueca ña incā tēe, suni cásíquí ndéē ña dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ñúcuán de nī nquenda nchivī nūū yā jíín ndá sūchí lúlí, jā tee yā ndahá yā xīnī ji. De ndá tēe scuáha jíín yā, nī ncāhān dē nūū ndá nchivī jā váji jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","De nī jinī Jesús, de nī nquītī inī yā, de nī ncāhān yā jíín ndá dē: Cuāha tūhun ná quíji ndá sūchí lúlí jīñā nūū ni, de mā cásī ndá nú jā quiji ji. Chi nchivī jā ndicó cóo inī jā cani inī ji modo ndá sūchí yáhá, suu ji cúu jā quīvi ndahá Yāā Dios jā tatúnī yā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","De ndāā cáhān ni jíín ndá nú, tú iin nchivī nduú jétáhví ji jā tatúnī Yāā Dios nūū ji, tá cúu nūū jétáhví iin sūchí lúlí, de mā quívi cuitī ji ndahá yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","De nī numi yā ndá ji, de nī ntee yā ndahá yā xīnī ji, de nī jīcān táhvī yā jēhē ji. ");
INSERT INTO mieNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ñúcuán de nī nquehen tucu yā ichi cuāhān yā. De jínu iin tēe nī nquenda dē, de nī jēcuīñī jītí dē nūū yā, de nī jīcā tūhún dē yā: Tēe vāha cúu ní Maestro. De cachī ní, ¿nā tiñu váha sāhá sá de nīhīn táhvī sá cutecū sá níí cání andiví? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","De nī ncāhān yā jíín dē: ¿A jáni inī nū jā iin tēe-ni cúu nī jā cáhān nū tēe vāha jíín nī? Nduú ni iin tēe vāha íyó, chi mátúhún-ni Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ja jínī nū ndá tiñu jā ní ndacu Yāā Dios: Mā cásíquí ndéē tāhán nú. Mā cáhnī nū ndīyi. Mā sácuíhná nú. Mā cáhān nū tūhun túhún. Mā stáhví nú táhán nú. Cuetáhví nú nūū tatá nú nūū naná nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","De nī ncāhān tēe ñúcuán jíín yā: Ndācá tiñu yáhá ja nī squíncuu sá jondē tá lulí sá, Maestro, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ñúcuán de nī ncumanī Jesús jíín dē, de nī ncāhān yā: Iin-ni cā tiñu cúmanī sāhá nú túsaá: Cuáhán de xīcó ndihi nú jā névāha nú, de cuāha nú nūū nchivī ndāhví. De jondē andiví cuāha yā jā váha ndasí nūū nū. Sá de quiji nú cuniquīn nū nduhū cōhōn, de cuāha nú tūhun jā cundoho nú tūndóhó jā síquī ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","De tá nī jini dē tūhun yáhá, de nī ntahúhvī inī dē. De cúcuécá inī dē cuāhān dē, chi cuícá ndasí dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ñúcuán de nī ndēhé Jesús níí xiín yā, de nī ncāhān yā jíín ndá tēe scuáha jíín yā: Nchivī cuīcá chi ūhvī ndasí quívi ji ndahá Yāā Dios jā tatúnī yā nūū ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","De ndá tēe scuáha jíín yā nī nsāhvi inī dē nī jini dē tūhun yáhá. De nī ncāhān tucu yā jíín ndá dē: Ndá nchivī jā cútóó xūhún, ūhvī ndasí quívi ji ndahá Yāā Dios jā tatúnī yā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ñamā cā yāha iin camello yavī yitícú nsūú cā jā quīvi iin nchivī cuīcá inī ndahá Yāā Dios jā tatúnī yā nūū ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","De víhí cā nī nsāhvi inī ndá dē nī jini dē, de nī jīcā tūhún táhán dē: ¿De ní nchivī cúu jā cācu túsaá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","De nī ndēhé yā nūū ndá dē, de nī ncāhān yā: Nchivī chi mā cūú squívi ji maá ji ndahá Yāā Dios, sochi maá yā chi cuu sāhá yā, chi ndihi-ni tiñu cuu sāhá yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ñúcuán de nī ncāhān Pedro jíín yā: Señor, de ndá sāán chi nī sndóo sá ndihi jā névāha sá, de níquīn sá níhín, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","De nī ncāhān Jesús: Ndāā cáhān ni jíín ndá nú, tú nā-ni nchivī sndóo vehe, á ñanī, á cuāha, á tatá, á naná, á ñasíhí, á sēhe, á ñuhun, jā síquī nduhū jíín jā síquī jā scútē nuu ji tūhun jā scácu nī nchivī, ");
INSERT INTO mieNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","túsaá de nanihīn ji iin ciento cā jā súcuán mitan, cúu vehe, cúu ñanī, cúu cuāha, cúu naná, cúu sēhe, cúu ñuhun, de suni jondē jíín jā cunī ūhvī nchivī ji. De incā vida jā quiji de cutecū ji níí cání andiví. ");
INSERT INTO mieNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sochi cuāhā nchivī jā cúñáhnú mitan, nduu ji nchivī núu cā. De nchivī jā núu cā mitan, chi nduñáhnú ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","De ñúhún ndá dē ichi jā cáa cuāhān Jerusalén. De Jesús yósnūú yā nūū ndá tēe scuáha jíín yā. De ndá nchivī jā níquīn ji yā, sáhvi inī ji nī jini ji tūhun cáhān yā, de yúhú ji. Ñúcuán de nī ncana síín tucu yā ndihúxī ūū tēe scuáha, de nī nquijéhé tucu yā cáchī tūhun yā ndācá jā quiji sīquī yā: ");
INSERT INTO mieNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Cunini ndá nú, chi mitan de ja cuāhān ō Jerusalén, de ñúcuán nastúu nchivī nduhū, Yāā nī nduu tēe, nūū ndá sūtū cúñáhnú jíín nūū ndá tēe stéhēn ley janahán. De nenda ndá dē sīquī ni jā cuū ni. De nasiáha dē nduhū nūū ndá tēe nación Roma jā tátúnī jā ndéē Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","De ndá tēe ñúcuán sāhá catá dē nūū ni, de cani dē nduhū, de tivī sīí dē nūū ni, de sá de cahnī dē nduhū. Sochi nūū únī quīvī de natecū ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ñúcuán de Jacobo jíín Juan, ndúū sēhe Zebedeo, nī nquenda dē nūū Jesús, de nī ncāhān dē: Maestro, cúnī sá jā sāhá ní iin jā cācān sá nūū ní, ncachī ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","De nī ncāhān yā jíín dē: ¿Nā cuá cúu jā sāhá nī jíín nú cúnī nū? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","De nī ncāhān ndúū dē: Cuāha ní tūhun jā cundeē sá xiín ní quīvī nduñáhnú ní, iin sá lado cuáhá ní, de incā sá lado sátín ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ñúcuán de nī ncāhān Jesús jíín ndúū dē: Nduú jínī nū nā cuá cúu jā jícān nū. ¿A cuu cundoho nú tūndóhó tá cúu nūū quiji sīquī ni? ¿De á quenda nú cundoho xēēn nū tá cúu nūū cundoho nī? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","De nī ncāhān ndúū dē: Cuu sāhá sá, ncachī dē. De nī ncāhān yā jíín dē: Jāndáā cúu jā ndoho nú tūndóhó tá cúu nūū quiji sīquī ni, de ndoho xēēn nū tá cúu nūū cundoho nī. ");
INSERT INTO mieNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Sochi jā cundeē nū lado cuáhá nī jíín lado sátín nī, de nsūú nduhū cúu jā cuāha tūhun. Chi ja íyó tūha jā cuu ndá tēe jā ní nacāji Tatá nī, de tēe ñúcuán nīhīn, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","De ndihúxī cā tēe scuáha jíín yā, nī jini dē tūhun yáhá, de nī nquītī inī dē nī jinī dē Jacobo jíín Juan. ");
INSERT INTO mieNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","De Jesús nī ncana yā ndá dē, de nī ncāhān yā jíín dē: Jínī ndá nú nāsa sáhá ndá tēe jā cúñáhnú nūū nchivī ndá nación. Chi ndácu nīhin ndá dē nūū ji, de maá dē cáchī nāsa coo. ");
INSERT INTO mieNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sochi ndá máá nú, chi mā sāhá nú súcuán. Chi tú ní iin nú cúnī nū cuñáhnú nú, de nduú chi sa sāhá nú maá nú tēe jā cuetíñú ndá táhán nú. ");
INSERT INTO mieNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","De tú ní iin nú cúnī jā cuu nú nūū, de sa sāhá nú maá nú mozo nūū ndá táhán nú. ");
INSERT INTO mieNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Chi suni súcuán sáhá maá nī, Yāā nī nduu tēe, chi nsūú jā váji nī jā cuetíñú nī nchivī, chi sa vāji nī jā cuetíñú nchivī nduhū. De cuāha nī maá nī jā cuū ni tácua scácu nī cuāhā nchivī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ñúcuán de nī nquenda yā ñuū Jericó jíín ndá tēe scuáha jíín yā. Sá de nī nquee yā ñúcuán cuāhān yā jíín ndá dē jíín ndá cā nchivī cuāhā. De Bartimeo tēe cuáá, sēhe Timeo, ndéē dē yuhú íchí, jícān dē caridad. ");
INSERT INTO mieNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","De nī jini dē tūhun jā váji Jesús tēe ñuū Nazaret. De nī nquijéhé dē cána jee dē: Jesús, maá ní jā cúu ní tatā rey David, cundáhví inī ní sāán, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","De cuāhā nchivī nī ncāhān ji nūū dē jā ná cásī dē yuhú dē. Sochi víhí cā nī ncana jee dē: Maá ní jā cúu ní tatā rey David, cundáhví inī ní sāán viī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ñúcuán de nī jencuiñī Jesús, de nī ncāhān yā: Cana dē ná quíji dē. De nī ncana ndá ji tēe cuáá ñúcuán: Ndeé coo inī nū. Nacuiñī ná cóhōn, chi cána yā ndóhó, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ñúcuán de nī squéne dē sōō dē, de ñamā nī nacuiñī dē, de nī nquenda dē nūū Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","De nī ncāhān yā jíín dē: ¿Nā cuá cúnī nū jā sāhá nī ndóhó? De nī ncāhān dē: Maestro, jā ná ndúnijīn tīnūú sá cúnī sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","De nī ncāhān Jesús jíín dē: Cuáhán túsaá, chi nī ncandíja nú jā cuu nasāhá vāha nī ndóhó, de suu cúu jā ní nduvāha nú, ncachī yā. De nī ndunijīn-ni tīnūú dē, de nī jēcuniquīn dē Jesús cuāhān dē jíín yā ichi ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","De cuācuñatin yā ciudad Jerusalén, de nī ncuñatin yā ñuū Betfagé jíín ñuū Betania, jā cáá jēhē yucu Olivos. De nī ntají yā ūū tēe scuáha jíín yā jā quíhīn dē. ");
INSERT INTO mieNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","De nī ncāhān yā jíín dē: Cuáhán ñuū lulí jā cáá ichi núū. De tá nī nquīvi nú de cunī nū iin burro núhnī tī, jā ni iin tēe ncháha ca cosō dē tī. De nandají nú tī, de quiji nú jíín tī. ");
INSERT INTO mieNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","De tú ní iin cātūhún nūcu nándají nú tī, de cachī nū jā maá Jētohō ō jíni ñúhún yā tī, de ñamā natají yā tī ndiji tī, cachī nū, ncachī yā jíín ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","De cuāhān ndúū dē, de nī nīhīn dē burro ñúcuán núhnī tī viéhé quēhe inī ichi. De nī nandají dē tī. ");
INSERT INTO mieNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","De sava nchivī íñí ñúcuán nī ncāhān jíín dē: ¿Nā cuá sáhá ní jā nándají ní burro jīñā? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ñúcuán de nī ncāhān ndúū dē tá cúu nūū ní ncachī Jesús nūū dē. Sá de nī nsiáā ji tī cuāhān dē jíín tī. ");
INSERT INTO mieNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","De nī nenda ndúū dē jíín tī nūū Jesús. De nī nchisó ndá dē sōō dē sīquī tī, de nī jēcōsō yā tī. ");
INSERT INTO mieNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","De cuāhā nchivī nī scáā ji sōō ji inī ichi. De sava cā ji nī jāhnū ji ndahá ñūū, de nī jaquīn ji inī ichi. ");
INSERT INTO mieNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","De nchivī cuáhān ichi núū yā jíín nchivī níquīn ichi chátā yā, cána jee ji: Viī ndasí cúñáhnú yā. De vāha ndasí Yāā cúu yā chi vāji yā jíín tiñu maá Jētohō ō Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","De vāha ndasí coo, chi ja ñatin tatúnī yā tá cúu nūū ní ntatúnī tatā ō rey David. De viī ndasí cúñáhnú maá Yāā Dios, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sá de nī nquīvi Jesús maá Jerusalén jíín inī templo cāhnú. De nī ndēhé yā nūū ndācá ndatíñú jā íyó níí ñúcuán. De ja nī ñini, de nī nquee yā cuāhān yā ñuū Betania jíín ndihúxī ūū tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","De quīvī téēn, tá nī nquee yā ñuū Betania jíín ndá dē, de cócon yā. ");
INSERT INTO mieNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","De jondē jícá nī jinī yā iin ñutun higo jā ndéē yūcū. De nī jēndēhé yā tú sanaā nīhīn yā higo jā cajī yā. De nduú ní níhīn cuitī yā, chi maá-ni yūcū ndéē, chi nsūú tiempo cúun higo cúu. ");
INSERT INTO mieNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ñúcuán de nī ncāhān yā nūū ñutun higo: Mitan de mā cúun cuitī cā higo xīnī nū, ncachī yā. De ndá tēe scuáha jíín yā nī jini dē jā súcuán nī ncāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","De nī nenda yā jíín ndá dē Jerusalén. De nī ndīvi yā inī patio templo cāhnú, de nī ntavā yā ndá nchivī jā jéen quiti de náxīcó nūū nchivī jā sōcō ji. De nī scócáva yā mesa ndá nchivī jā sáma xūhún, jíín silla ndá nchivī jā xícó paloma. ");
INSERT INTO mieNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","De nduú ní jéhe yā tūhun jā yāha nchivī inī templo jíín ndatíñú ndíso ji. ");
INSERT INTO mieNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","De nī stéhēn yā tūhun nūū ji, nī ncachī yā: Yósō nūū tutū īī jā cáhān Yāā Dios: Vehe nī chi vehe nūū jícān táhvī nchivī ndācá nación cúu, cáchī yā. Sochi ndá ndóhó, chi modo yavī cava jācuīhná nī nasāhá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","De ndá tēe stéhēn tutū ley jíín ndá sūtū cúñáhnú, nī jini dē tūhun yáhá, de nī nquijéhé dē ndúcú dē modo nāsa cahnī dē yā. Chi yúhú ndá dē jā cuñáhnú cā maá yā nsūú cā ndá máá dē, chi ndācá nchivī cúsiī ndasí inī ji níni ji tūhun stéhēn yā. ");
INSERT INTO mieNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","De tá ja ñatin cuaā, de nī nquee yā Jerusalén cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","De jānehēn quīvī téēn nī nayāha yā jíín ndá dē cuāhān yā. De nī jinī ndá dē jā ñutun higo ñúcuán ja nī nchīchī níí jondē jíín yoho. ");
INSERT INTO mieNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ñúcuán de nī nūcūhun inī Pedro, de nī ncāhān dē jíín yā: Maestro, cūndēhé ní ñutun higo ñúcuán jā ní ncāhān ní nūū, de mitan ja nī nchīchī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","De nī ncāhān Jesús jíín ndá dē: Candíja ndá nú jā sāhá Yāā Dios jā jícān nū. ");
INSERT INTO mieNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Chi ndāā cáhān ni jíín nú, tú nā-ni nchivī cāhān ji jā cujiyo yucu yáhá quīhīn jondē nūū mar, de tú nduú jáni síquí inī ji, chi sa cándíja ji jā coo tá cúu nūū cáhān ji, ñúcuán de quee ndaā jā ní ncāhān ji. ");
INSERT INTO mieNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jā ñúcuán cúu jā cáhān ni jíín ndá nú, ndācá jā jícān táhvī nū, de tú cándíja nú jā nīhīn nū, de nīhīn nū. ");
INSERT INTO mieNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","De tá jícān táhvī nū, de cune cáhnú inī nū nūū nchivī jā sáhá cuāchi nūū nū, tácua maá Tatá nú, Yāā ndéē andiví, suni cune cáhnú inī yā nūū cuāchi nú. ");
INSERT INTO mieNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Chi tú mā cúne cáhnú inī nū nūū táhán nú, de saá-ni maá Tatá nú, Yāā ndéē andiví, mā cúne cáhnú inī yā nūū cuāchi nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ñúcuán de nī nenda tucu yā Jerusalén, de jíca nuu yā inī templo cāhnú. De ndá sūtū cúñáhnú, jíín tēe stéhēn ley janahán, jíín tēe ñáhnú jā ndácu tiñu, nī nquenda ndá dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","De nī jīcā tūhún dē yā: ¿Ní jondē nī nīhīn tīñú nú ndá tiñu jā sáhá nú yáhá? ¿De ní iin nī ntee tiñu ndóhó jā sáhá nú súcuán? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","De nī ncāhān Jesús: Saá-ni nduhū suni cātūhún nī ndá nú iin tūhun. De tú cuu scócóo nú, ñúcuán de cachī ni nūū nū ní jondē nī nīhīn tīñú nī jā sáhá nī tiñu yáhá. ");
INSERT INTO mieNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ní iin nī ntee tiñu sīquī Juan jā ní scuénduté dē? ¿A Yāā Dios á ndá tēe? Cachī nūū ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ñúcuán de nī natúhún ndá máá dē: Tú cachī ō jā Yāā Dios nī ntee tiñu ñúcuán sīquī Juan, de cāhān dē jíín ó: ¿Túsaá de nājēhē cúu jāá nduú ní ncándíja ndá nú jā ní ncāhān dē? ");
INSERT INTO mieNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","De tú cāhān ō jā nchivī nī ntee tiñu sīquī dē, de quītī inī nchivī cunī ji yóhó, ncachī ndá dē jíín táhán dē. Chi yúhú ndá dē jā quītī inī nchivī, chi ndiviī ji cándíja ji jā tēe nī nacani tūhun Yāā Dios nī ncuu ndija Juan. ");
INSERT INTO mieNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jā ñúcuán nī ncāhān ndá dē jíín yā: Nduú jínī ni, ncachī dē. Ñúcuán de nī ncāhān Jesús: De saá-ni nduhū, suni mā cāchí nī nūū nū ní iin nī ntee tiñu sīquī ni jā sáhá nī tiñu yáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","De nī nquijéhé yā cáhān yā tūhun yátá jíín ndá dē: Iin tēe nī nchuhun dē cuāhā yūcū uva. De nī jasī dē corral, de nī nsāhá dē iin nūū cāxīn dē uva. De nī nsāhá dē iin vehe súcún tácua cuu coto dē níí cáhnú. De nī sndóo dē nūū sava tēe jā satíñú nūū, de cuu sava dē ndīhā jíín. De nī nquehen dē ichi cuāhān jīcá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","De maá tiempo jā ndutútú uva, de nī ntají dē iin mozo jā cuánaquēhen ji sava ndīhā uva nūū ndá tēe sátíñú. ");
INSERT INTO mieNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","De ndá tēe ñúcuán nī ntiin dē mozo, de nī ncani dē ji, de nī natají uun dē ji cuānohōn ji. ");
INSERT INTO mieNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ñúcuán de tēe xíí uva nī ntají dē incā mozo cuāhān. De ndá tēe sátíñú nī jēhe dē yūū xīnī mozo ñúcuán, de nī stácuēhé dē, de nī ncāhān nāvāha dē nūū. ");
INSERT INTO mieNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","De tēe xíí uva nī ntají tucu dē incā mozo cuāhān. De nī jahnī ndá dē ji. De suni súcuán nī ntají dē cuāhā cā mozo cuāhān, de sava ji nī ncani ndá dē, de sava cā ji nī jahnī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","De tēe xíí uva, íyó iin sēhe dē de mānī ndasí dē jíín. De jā sándīhí de nī ntají dē sēhe dē cuāhān nūū ndá tēe sátíñú. De jáni inī dē jā cuetáhví ndá tēe ñúcuán nūū sēhe dē. ");
INSERT INTO mieNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Sochi ndá tēe sátíñú nī natúhún ndá máá: Tēe xíí táhvī cúu yáhá. Ná cáhnī ō ji, de ndōo tāhvī ji cuu ó, ncachī ndá. ");
INSERT INTO mieNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","De nī ntiin ndá dē ji, de nī jahnī dē, de nī squéne dē ji yuhú ñúhún ñúcuán, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ñúcuán de nī jīcā tūhún yā ndá dē: ¿Túsaá de nāsa sāhá tēe xíí uva? Nenda dē de cahnī dē ndá tēe sátíñú, de cuāha dē ñuhun jā cáá uva nūū sava cā tēe jā satíñú nūū. ");
INSERT INTO mieNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿De á ncháha ca cahvi ndá nú tūhun yáhá jā yósō nūū tutū īī, jā nduhū cúu tá cúu iin yūū? Chi cáchī tutū: Yūū jā ní squéne yichī ndá tēe jā sáhá vehe, maá yūū yáhá nduu jā quituu squínā vehe. ");
INSERT INTO mieNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Maá Jētohō ō Yāā Dios nī nsāhá yā súcuán, de sáhvi inī ō jínī ō tiñu yáhá. Cáchī tutū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ñúcuán de nī nducú ndá dē modo jā tiin dē yā. Chi nī jīcūhun inī dē jā sīquī ndá máá dē cúu jā ní ncāhān yā tūhun yátá sīquī ndá tēe jā sátíñú nūū uva jíín ndá tēe jā sáhá vehe. Sochi sīquī jā yúhú ndá dē jā quītī inī nchivī, de nī sndóo dē yā, de cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ñúcuán de nī ntají ndá dē sava tēe grupo fariseo jíín grupo Herodes, cuāhān dē nūū yā, chi ndúcú ndá dē nāsa sāhá dē tácua cāhān yā iin tūhun jā nīhīn dē cuāchi sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","De nī nquenda ndá dē, de nī ncāhān dē jíín yā: Maestro, jínī ndá sá jā tēe cáhān ndāā cúu ní, de nduú yúhú ní jā cāhān ni iin nchivī sīquī ní. Chi nduú sáhá ní cuenta nāsa cúu iin iin nchivī, chi inuú-ni sáhá ní jíín ndá ji. De stéhēn ndāā ní nāsa squíncuu nchivī nūū Yāā Dios. ¿De á íyó vāha jā chunáá ó xūhún renta nūū rey nación Roma jā tíin nación maá ó? ¿A chunáá ó, á mā chúnáá ó? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","De maá yā jínī yā jā stáhví-ni ndá dē, de nī ncāhān yā jíín dē: ¿Nājēhē cúu jā jíto túnī ndá nú nduhū? Taji iin xūhún ná cúndēhé nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","De nī jēhe ndá dē xūhún, de nī ndēhé yā nūū, de nī jīcā tūhún yā dē: ¿Nā tēe cúu jā ndéē nūū xūhún yáhá, de nā síví cúu jā ndéē yáhá? De nī ncāhān ndá dē jíín yā: Rey ñúcuán cúu. ");
INSERT INTO mieNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","De nī ncāhān yā jíín ndá dē: Túsaá de nacuāha nú nūū rey ñúcuán jā cúu cuenta dē, de nacuāha nú nūū Yāā Dios ndācá jā cúu cuenta maá yā, ncachī yā. De nī nsāhvi ndasí inī ndá dē nī jini dē jā ndíchí nī ncāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ñúcuán de jacū tēe grupo saduceo nī nquenda dē nūū yā. De ndá tēe ñúcuán cáchī dē jāá nduú nátecū cuitī ndīyi. De nī jīcā tūhún dē yā sīquī iin tūhun: ");
INSERT INTO mieNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Maestro, de Moisés nī ntee dē nūū tutū jā névāhá ó: Tú iin tēe cuū dē, de ndōo ñasíhí dē, de tú nduú ní íyo sēhe dē jíín ña, túsaá de cánuú jā ñanī dē nacueca ñasíhí dē, de sēhe dē jā coo jíín ña, nūcuīñī ji nūū ndīyi ñanī dē, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","De nī īyo ūjā ñanī. De tēe xíhna ñúhún nī jeca dē iin ñahan. De nī jīhī dē, de nduú nā sēhe dē ní íyo. ");
INSERT INTO mieNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","De tēe ūū nī nacueca dē ña, de suni nī jīhī dē, de suni nduú nā sēhe dē ní íyo. De saá-ni tēe ūnī. ");
INSERT INTO mieNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","De ndihújā dē nī nacueca dē ña, de ni iin dē nduú ní íyo sēhe dē. De jā sándīhí de nī jīhī ñahan ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Túsaá de tá natecū ndá dē quīvī jā natecū ndīyi, ¿de ní iin dē cuu ña ñasíhí dē? Chi ndihújā dē nī ndeē jíín ña, ncachī ndá dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ñúcuán de nī ncāhān yā jíín dē: Ndasí stíví ndá nú tūhun sīquī jāá nduú jícūhun inī nū jā cáhān tutū īī, de ni nduú jínī nū jā íyó poder Yāā Dios jā nastécū yā ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chi quīvī jā natecū ndá ndīyi, de nduú cā nā tūhun jā quetáhán tēe jíín ñahan coo. Chi coo ndá ji tá cúu ndá ángel Yāā Dios andiví. ");
INSERT INTO mieNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","De sīquī jā natecū ndīyi, ¿á nduú ní ncáhvi ndá nú tutū jā ní ntee Moisés, nāsa nī ncāhān Yāā Dios jíín dē māhñú yūcū jā cáyū ñuhūn? Maá nī cúu Yāā Dios Abraham jíín Isaac jíín Jacob, ncachī yā nūū Moisés. ");
INSERT INTO mieNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Chi vísō ja nī jīhī ndá dē sochi técū dē nūū íyó maá yā, chi cúu yā Yāā jā sáhá jā técū nchivī níí cání. Ndasí stíví ndá nú tūhun yā túsaá, ncachī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","De nī nquenda iin tēe stéhēn ley janahán, de nī jini dē jā stíchī tāhán ndá tēe ñúcuán jíín Jesús. De nī jinī dē jā vāha nī scócóo yā tūhun. De nī jīcā tūhún dē yā: ¿Ní tūhun cúu jā ndácu tiñu jā cánuú ndasí cā nūū ndá cā tūhun jā ní ndacu yā janahán? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","De nī ncāhān Jesús jíín dē: Yáhá cúu tiñu jā cánuú ndasí cā nūū ndācá cā: Cáchī tutū: Nchivī Israel, cunini nú: Maá Jētohō ō Yāā Dios chi mátúhún yā-ni íyó. ");
INSERT INTO mieNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Túsaá de coo manī ndasí nú jíín maá Jētohō nū Yāā Dios jondē jíín inī jíín ánō nū, jíín níí jāá ntúnī nū, jíín níí fuerza nū. Yāhá cúu tūhun ndácu yā jā cánuú ndasí cā. ");
INSERT INTO mieNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","De tūhun ūū jā ní ndacu yā, suni súcuán cáhān: Cundáhví inī nū táhán nú tá cúu nūū cúndáhví inī nū maá nú, cáchī tutū. Nduú cā nā incā tūhun ndácu tiñu cánuú cā íyó, chi yáhá-ni cúu, ncachī yā jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ñúcuán de tēe stéhēn ley janahán, nī ncāhān dē jíín yā: Vāha nī ncāhān ní Maestro. Chi ndāā jā iin-ni Yāā Dios íyó, de nduú cā nā incā yā íyó. ");
INSERT INTO mieNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","De cánuú jā coo manī ndasí ó jíín yā jondē jíín inī jíín ánō ō, jíín níí jāá ntúnī ō, jíín níí fuerza ō, de cundáhví inī ō táhán ó tá cúu nūū cúndáhví inī ō maá ó. De cánuú ndasí cā yáhá nsūú cā jā teñuhūn ō quiti jíín ndá cā jā sōcō ō nūū yā, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","De nī jinī Jesús jā vāha nī scócóo dē tūhun, de nī ncāhān yā jíín dē: Ja ñatin cuu quīvi nú ndahá Yāā Dios jā tatúnī yā nūū nū, ncachī yā. Ñúcuán de ni iin cā ndá dē, nduú cā ní nchúndeé inī dē jā cātūhún dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","De stéhēn Jesús tūhun inī templo, de nī ncāhān yā: ¿Nāsa cúu jā cáchī ndá tēe stéhēn ley janahán jā Cristo cúu tatā rey David? ");
INSERT INTO mieNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Chi maá David súcuán nī ncāhān dē tūhun yā nī nsāhá Espíritu Santo jondē janahán: Maá Jētohō ō Yāā Dios nī ncāhān yā jíín Jētohō ni, Yāā jā quiji: Cundeē nū lado cuáhá nī nūū cuñáhnú nú, de ná sáhá nī jā candeē nū poder ndācá jā jínī ūhvī ndóhó. Ncachī Yāā Dios. Ncachī David. ");
INSERT INTO mieNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Túsaá de vísō chījin tatā David cacu Cristo, de nī ncāhān dē Jētohō dē yā, chi jondē nūū Yāā Dios vāji yā, ncachī yā. De ndá nchivī cuāhā jétahān inī ji níni ji tūhun cáhān yā. ");
INSERT INTO mieNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","De stéhēn yā tūhun, de nī ncāhān yā jíín ji: Coto má candíja ndá nú ndá tēe stéhēn ley janahán. Chi cúsiī inī ndá dē jíca nuu dē jíín sahma cání jā stéhēn jā cúñáhnú dē, jíín jā cáhān yíñúhún nchivī dē nūū yáhvi. ");
INSERT INTO mieNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","De jétahān inī ndá dē cundeē dē nūū silla yíñúhún cā inī vehe īī sinagoga, jíín silla yíñúhún cā nūū íyó vico jā yájī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","De cándeē dē vehe ndá ñahan quéndōo ndáhví. De nahán jícān táhvī dē tácua cani inī nchivī jāá nduú nā cuāchi dē. Ndá tēe yáhá chi sa víhí cā ndoho dē castigo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","De iin quīvī ndéē Jesús inī templo cāhnú ichi núū ndá jātūn nūū sócō ji xūhún. De ndéhé yā nāsa chúhun nchivī xūhún inī jātūn. De cuāhā nchivī cuīcá nī nchuhun ji cuāhā xūhún. ");
INSERT INTO mieNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","De nī nquenda iin ñahan viuda jā ndóho ndáhví. De nī nchuhun ña ūū centavo lulí inī iin jātūn. ");
INSERT INTO mieNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ñúcuán de nī ncana yā ndá tēe scuáha jíín yā, de nī ncāhān yā jíín dē: Ndāā cáhān ni jíín ndá nú jā ñahan viuda ndāhví yáhá, cuāhā cā nī nsōcō ña nsūú cā jā ní nsōcō ndá nchivī cuīcá. ");
INSERT INTO mieNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chi ndá máá ji nī nsōcō ji jā ní ndōo nūū xūhún cuáhā ji. De ñahan yáhá, vísō ndáhví ndóho ña, de nī nchuhun ña ndihi jā cutecū ña, ncachī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","De tá nī nquee Jesús inī templo cāhnú, de iin tēe scuáha jíín yā nī ncāhān dē: Maestro, cūndēhé ní nācā viī ndasí cáá ndá vehe yáhá jā cúu templo, jíín ndá yūū jā ní ncuvāha, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","De nī ncāhān yā jíín dē: Ndācá vehe náhnú yáhá jā ndéhé nú, chi iin quīvī mā cósō tāhán cā ni iin yūū, chi ndihi tānī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","De cuāhān yā jíín ndá dē yucu Olivos, jā íñí ichi núū templo cāhnú. De nī jēcundeē yā ñúcuán. De Pedro jíín Jacobo jíín Juan jíín Andrés, nī jīcā tūhún síín dē yā: ");
INSERT INTO mieNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Cachī tūhun ní nūū sá, ¿nā quīvī coo ndācá jā ní ncachī ní jā coo? ¿De nā seña coo tá ja ñatin squíncuu ndá jā ní ncachī ní? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","De nī ncāhān yā: Coto má stáhví ni iin dē ndá ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Chi quiji cuāhā tēe jíín síví nī jā stáhví: Maá nī cúu Cristo, cachī dē. De súcuán de stáhví dē cuāhā nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","De nīhīn nū tūhun jā ndācá lado íyó guerra, á ja ñatin coo guerra. De mā cúyūhú nú, chi cánuú jā súcuán coo, sochi ncháha ca quenda quīvī jā ndihi ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chi nenda nación sīquī incā nación, de nenda ñuū sīquī incā ñuū jā canāá. De cháhá chúcuán tāan, de coo tāmā, de nenda nchivī sīquī táhán ji. De ndācá yáhá cúu tūndóhó jā quijéhé xihna ñúhún cā. ");
INSERT INTO mieNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","De coto ndá nú maá nú, chi nastúu ndá ji ndóhó nūū justicia, de inī ndá vehe īī sinagoga cani ndá ji ndóhó. De quīnasiáha ji sava ndá nú nūū ndá gobernador jíín nūū ndá rey, de cāhān ji cuāchi sīquī nū sīquī jā cándíja nú nduhū. De súcuán de cuu nacani nú tūhun nī nūū ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Chi cánuú jā xihna cā cūtē nuu tūhun nūū nchivī ndācá nación nāsa scácu nī ji, sá de jīnu quīvī. ");
INSERT INTO mieNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","De tá quīnasiáha ndá dē ndóhó nūū justicia, de mā nácani tūha inī nū nāsa nascócóo nú tūhun nūū ndá dē. Chi hora ñúcuán de maá Yāā Dios cuāha yā tūhun nūū nū nāsa cāhān nū, de tūhun ñúcuán cāhān nū. Chi nsūú maá nú cúu jā cāhān, chi Espíritu Santo cúu jā cāhān. ");
INSERT INTO mieNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","De ñanī jíín ñanī nastúu táhán jā ná cúū. De tatá nastúu sēhe jā cuū. De sēhe nenda sīquī tatá jíín naná jā cahnī. ");
INSERT INTO mieNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","De ndācá nchivī quītī inī ji nūū nū jā síquī nduhū. Sochi nchivī jā cuiñi nīhin jíín tūhun nī jondē quīvī jīnu, chi cācu ji. ");
INSERT INTO mieNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","De Daniel, tēe nī nacani tūhun Yāā Dios, nī ntee dē tūhun iin tēe nēhén jā quiji. De ndá ndóhó jā cáhvi tutū ñúcuán, de ná jícūhun inī nū. Chi iin quīvī de cunī ndá nú jā cuiñi dē inī maá templo nūū nduú nā ley jā cuiñi dē, de sāhá nāvāha dē jā stíví dē ndá ndatíñú īī. De tá cunī nū jā súcuán cúu, de nchivī ndéē región Judea, ná cúnu ji caa ji yucu quīhīn ji. ");
INSERT INTO mieNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","De nchivī ndéē yātā vēhé, mā ndívi ji inī vehe jā tavā ji ndatíñú ji, chi cánuú jā cunu ñamā ji tácua cācu ji. ");
INSERT INTO mieNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","De nchivī íyó nūū itū, mā nóhōn ji vehe jā naquehen ji sahma ji. ");
INSERT INTO mieNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","De quīvī ñúcuán, nācā ndáhví ndoho ndá ñahan ñúhún sēhe jíín jā ndéca ñiquín, chi mā cúñamā ña cunu ña. ");
INSERT INTO mieNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Túsaá de cācān táhvī nū jā má quījí tūndóhó ñúcuán jā cunu nú maá tiempo cúun yūhā. ");
INSERT INTO mieNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chi tá quijéhé ñúcuán de coo cuāhā tūndóhó xéēn, jāá ncháha ca coo súcuán jondē quīvī jā ní nsāhá Yāā Dios ñayīví de jondē mitan. De tá yāha tūndóhó ñúcuán de ni mā cōó cā jā súcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","De tú mā násndíyi maá Jētohō ō Yāā Dios tiempo coo tūndóhó ñúcuán, de ni iin nchivī mā cácu cuitī ji. De jā síquī nchivī cándíja jā ní nacāji yā, jā ñúcuán cúu jā nasndíyi yā quīvī. ");
INSERT INTO mieNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Túsaá de tú iin nchivī cāhān jíín nú: Yáhá cūndēhé nú jā ndéē Cristo, á: Ñúcuán cūndēhé nú jā ndéē yā, cachī ji, de mā cándíja nú jā cáhān ji. ");
INSERT INTO mieNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chi quenda ndá tēe stáhví jā cachī dē jā cúu dē Cristo, á cachī dē jā tēe nácani tūhun Yāā Dios cúu dē. De sāhá ndá dē tiñu ñáhnú jā sāhvi inī nchivī cunī ji, tácua stáhví dē jondē maá nchivī jā ní nacāji yā, de tú ná cúu sāhá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Sochi ndito coo inī ndá nú, chi ja nī ncachī ndihi nī nūū nū mitan jondē ncháha ca coo. ");
INSERT INTO mieNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","De quīvī ñúcuán, tá ja nī ndihi ndācá tūndóhó yáhá, de cutuún ncandiī, de yōō chi mā cútūu cā. ");
INSERT INTO mieNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","De nincava tiūūn, de ndācá jā jíca andiví chi quisi. ");
INSERT INTO mieNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ñúcuán de cunī ndá nchivī nūū maá nī, Yāā nī nduu tēe, nenda nī jíín vīcō, de cundiso nī cuāhā poder, de viī ndasí cuñáhnú nī. ");
INSERT INTO mieNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ñúcuán de tají nī ndá ángel ni quiji jā nastútú ndācá nchivī jā ní nacāji nī ndicúmī lado ñayīví, jondē nūū ndíhi ñayīví de jondē nūū ndíhi andiví. ");
INSERT INTO mieNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mitan de scuáha ndá nú nāsa sáhá ñutun higo: Tá ja nī nene numa, de nī nacōco yūcū, de ja jínī ndá nú ja nī ncuñatin tiempo ihní. ");
INSERT INTO mieNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","De suni súcuán tá cunī ndá nú jā ní nquijéhé ndá tiñu yáhá, ñúcuán de jīcūhun inī nū ja nī ncuñatin quīvī nenda nī, de ñamā coo. ");
INSERT INTO mieNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","De ndāā cáhān ni jíín ndá nú jā má cúū ndihi nchivī jā cunī ndá tūndóhó yáhá, chi jondē quee ndaā ndihi tá ncachī ni. ");
INSERT INTO mieNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Andiví jíín ñayīví chi naā, sochi ndācá tūhun cáhān ni chi mā náā, chi quee ndaā ndihi. ");
INSERT INTO mieNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Sochi quīvī jíín hora jā nenda nī, chi ni iin nchivī nduú jínī, ni ndá ángel andiví, ni maá nī jā cúu Sēhe Yāā Dios. Chi mátúhún-ni Tatá nī cúu jā jínī. ");
INSERT INTO mieNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Túsaá de cuhun inī ndá nú ndá tūhun yáhá, de ndito coo inī nū, de cācān táhvī nū, chi nduú jínī nū nā quīvī nenda nī. ");
INSERT INTO mieNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Chi coo modo iin tēe jā quíhīn jīcá dē, de tá ncháha ca quee dē vehe dē, de nī ndacu dē nūū ndá mozo dē nā tiñu sāhá iin iin dē. De nī ndacu dē nūū tēe jíto viéhé jā ná cóo ndito dē. ");
INSERT INTO mieNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","De saá-ni ndá máá nú, ndito coo inī nū. Chi cúu nī tá cúu jētohō vehe, de nduú jínī nū nā hora nenda nī, á ja ñatin cuaā, á ñuú, á jā cána lohló, á jānehēn. ");
INSERT INTO mieNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chi iin sanaā-ni de nenda nī, de ndito coo nú tácua mā níhīn ni ndóhó jāá nduú íyó tūha nú. ");
INSERT INTO mieNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","De tūhun cáhān ni jíín ndá nú yáhá, suni cáhān ni jíín ndiviī nchivī: Ndito coo inī ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","De cúmanī ūū cā quīvī sá de quijéhé vico pascua jā yájī ndá nchivī hebreo stātílā jāá nduú nā levadura yíhí. De ndá sūtū cúñáhnú jíín ndá tēe stéhēn ley janahán, nī nducú dē modo nāsa tiin dē Jesús jíín tūhun túhún, de cahnī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","De nī ncāhān ndá dē: Mā tīín ó dē maá quīvī vico, chi nenda nchivī sīquī ō, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","De íyó Jesús ñuū Betania, vehe Simón, tēe jā ní ndoho cuēhē stéhyū. De juni yájī yā stāā, de nī nquenda iin ñahan nūū yā, née ña iin frasco yūū luu jā ñúhún aceite perfume, jā maá-ni itā nardo cúu, de yāhvi ndasí ndéē. De nī ntahví ña frasco, de nī jōsō ña xīnī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","De sava tēe íyó ñúcuán nī nquītī inī dē, de nī ncāhān ndá máá dē: ¿Nājēhē cúu jā snáā cāhá ña perfume yáhá? ");
INSERT INTO mieNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chi cuu cuyāhvi víhí cā ūnī ciento denario, de cuāha ó xūhún ñúcuán nūū nchivī ndāhví nícu, ncachī ji. De nī ncāhān sōó ndá dē jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","De nī ncāhān Jesús: Mā stáhān ndá nú ña. ¿Nūcu sáhá ndá nú jā nacani uhvī inī ña? Chi iin tiñu váha cúu jā ní nsāhá ña nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Chi níní íyó nchivī ndāhví jíín nú, de tú cúnī ndá nú de cuu sāhá vāha nú jíín ji. De nduhū chi mā cúndeē cā ni jíín nú. ");
INSERT INTO mieNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Chi nī nsāhá ña ndihi jā cuu sāhá ña jā mānī ña jíín nī. Chi jondē ncháha ca quiyuhū ni de ja nī nsāhá tūha ña nduhū jā ní jōsō ña perfume nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","De ndāā cáhān ni jíín ndá nú, níí cáhnú ñayīví ní-ni cúu nūū cūtē nuu tūhun jā scácu nī nchivī, de suni nacani ji tūhun jā ní nsāhá ñahan yáhá, tácua nūcūhun inī nchivī ña, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ñúcuán de Judas Iscariote, iin jā úxī ūū tēe scuáha jíín yā, nī jēhēn dē nūū ndá sūtū cúñáhnú, de nī nsāhá ndāā dē jíín jā nastúu dē Jesús nūū ndá. ");
INSERT INTO mieNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","De tá nī jini ndá sūtū jā cáhān dē, de nī ncusiī inī. De nī nquee yuhú ndá jā cuāha xūhún nūū dē. De jondē quīvī ñúcuán de ndúcú dē modo nāsa nastúu dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","De nī nquenda maá quīvī jā quíjéhé vico pascua jā yájī nchivī stātílā jāá nduú nā levadura yíhí, de suni quīvī ñúcuán jáhnī ndá ji tīcāchí lúlí tá cúu nūū ní ndacu Yāā Dios jā sāhá ji vico pascua. De ndá tēe scuáha nī jīcā tūhún dē yā: ¿Ní cúu nūū cúnī ní jā quísāhá tūha sá nūū cuxíní ní vico pascua? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","De nī ntají yā ūū tēe scuáha jíín yā jā quíhīn dē, de nī ncāhān yā jíín dē: Cuáhán jondē ñuū, de ñúcuán jēcutáhán nú jíín iin tēe ndíso quīyi ndute. De cuniquīn nū dē quīhīn nū jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","De vehe nūū ndīvi dē, ñúcuán cāhān nū jíín tēe xívéhe: Cáchī maá Maestro: ¿Ní iin cuarto vehe ní cúu jā cuāha núú ní nūū cuxíní yā vico pascua jíín ndá tēe scuáha jíín yā? Cachī nū. ");
INSERT INTO mieNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","De maá dē chi stéhēn dē iin cuarto cāhnú jondē xīnī vēhé nūū ja íyó tūha. De ñúcuán sāhá tūha nú jā cuxíní ó, ncachī yā jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","De cuāhān ndúū tēe scuáha jíín yā, de nī nquenda dē ñuū ñúcuán, de nī nīhīn dē tá cúu nūū ní ncachī yā jíín dē. De nī nsāhá tūha dē jā cuxíní yā vico pascua. ");
INSERT INTO mieNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","De tá ja ñatin cuaā, de nī nquenda yā jíín ndihúxī ūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","De nī jēcundeē ndá dē nūū mesa yájī dē stāā, de nī ncāhān yā: Jāndáā cáhān ni jíín ndá nú jā iin nú jā yájī jíín nī mitan, nastúu nú nduhū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ñúcuán de nī ncucuécá inī ndá dē, de tá iin iin dē nī jīcā tūhún dē yā: ¿A sāán? ncachī iin dē. De saá-ni incā dē: ¿A sāán? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","De nī ncāhān yā jíín dē: Iin jā úxī ūū nū jā yájī cāhnú jíín nī iin cōhō, suu nastúu nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","De nduhū, Yāā nī nduu tēe, jāndáā cúu jā quīhīn ni cuū ni, tá cúu nūū yósō tūhun nī nūū tutū īī. De nācā xēēn cundoho tēe jā nastúu nduhū. Vāha cā de tú nduú ní ncácu tēe ñúcuán nícu, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","De juni yájī ndá dē jíín yā, de nī nquehen yā stātílā, de xihna cā nī nacuetáhví yā nūū Tatá yā, de nī scuáchi yā, de nī jēhe yā nūū ndá tēe scuáha jíín yā. De nī ncāhān yā: Cajī ndá nú, chi yáhá cúu yiqui cúñu nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ñúcuán de nī nquehen yā iin vaso jā ñúhún ndūxi uva, de nī nacuetáhví yā, de nī jēhe yā nī jihi ndihi dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","De nī ncāhān yā jíín dē: Yáhá cúu nīñī ni jā sōcō ni jā cúu trátū jeé, de cati jā ndundoo cuāchi cuāhā nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","De jāndáā cáhān ni jíín ndá nú jā má cōhó cā ni ndūxi uva yáhá, chi jondē quenda quīvī jā tatúnī Yāā Dios níí ñayīví, sá de coho tucu nī jíín ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","De nī jita yā jíín ndá dē iin yaā īī. De nī nquee yā cuāhān yā jíín dē jondē yucu Olivos. ");
INSERT INTO mieNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ñúcuán de nī ncāhān yā: Ndiviī nū nayūhú nú jā síquī nduhū jacuáā mitan. Chi suha yósō tūhun nī nūū tutū īī jā ní ncachī Yāā Dios: Cuāha nī tūhun jā cahnī nchivī tēe jíto tīcāchí, de ndá tīcāchí cūtē nuu tī jā yúhú tī, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sochi tá natecū ni, de xihna cā ni cosō nūú quīhīn ni región Galilea, de sá de cuēē ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ñúcuán de nī ncāhān Pedro jíín yā: Vísō ndihi dē nayūhú dē, sochi sāán chi mā náyūhú cuitī sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","De nī ncāhān yā jíín dē: Jāndáā cáhān ni jíín nú, jacuáā mitan jondē ncháha ca cana lohló ūū vuelta, de yūhú nú jā tiin nchivī ndóhó, de cachī nū ūnī vuelta jāá nduú jínī nū nduhū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sochi nī ncāhān téyíí dē jíín yā: Vísō ná cúū sá jíín ní, sochi mā cāchí cuitī sá jāá nduú jínī sá ní, ncachī dē. De suni súcuán nī ncāhān ndihi dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ñúcuán de nī nquenda yā jíín ndá tēe scuáha jíín yā iin lugar nūū nání Getsemaní. De nī ncāhān yā jíín dē: Yáhá-ni cundeē ndá nú de ná quíhīn ni cācān táhvī ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","De nī jeca yā Pedro jíín Jacobo jíín Juan cuāhān yā jíín dē. De nī nquijéhé yā xií cúu inī yā de cúcuécá ndasí inī yā jā quiji tūndóhó sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","De nī ncāhān yā jíín ndá dē: Cúcuécá ndasí inī ni jondē ja ñatin cuū ni. Yáhá cundetu ndá nú de cundito nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","De nī jica yā jacū cā, de nī jēcuīñī jītí yā nī ntuu yā nūū yā nūū ñūhún. De nī jīcān táhvī yā nūū Yāā Dios jā tú cuu de mā cúndoho yā tūndóhó jā váji sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","De suha nī ncāhān yā: Tatá maá sá, ndihi-ni tiñu cuu sāhá maá ní. De sāhá jíyo ní tūndóhó yáhá jā má quījí sīquī sá. Sochi nsūú jā cúnī maá sá, chi jā cúnī maá ní ná cóo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","De nī nenda yā nūū ndinúnī tēe scuáha jíín yā, de nī jinī yā jā quíxīn ndá dē. De nī ncāhān yā jíín Pedro: Simón, ¿á jā quíxīn nū? ¿A nduú ní ncúu cundito nú jíín nī vísō iin hora? ");
INSERT INTO mieNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Coo ndito inī ndá nú de cācān táhvī nū jā chindeé yā ndóhó tácua mā cōtó túnī jānēhén ndóhó jā sāhá nú cuāchi. Chi cúnī ndija ánō nū squíncuu vāha nú, sochi yiqui cúñu nú chi nduú fuerza, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","De nī jēhēn tucu yā, nī jīcān táhvī yā, de suni tūhun ñúcuán nī ncāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","De nī nenda tucu yā nūū dē, de nī jinī yā jā quíxīn tucu ndá dē, chi ndasí jíhī dē māhná. De nduú cā ní níhīn ndá dē tūhun scócóo dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","De nī nenda yā vuelta ūnī, de nī ncāhān yā jíín ndá dē: Mitan de cūsūn ndá nú-ni cā de natātú nú. De nduú chi ja nī ncuu, chi ja nī nquenda hora, de nduhū, Yāā nī nduu tēe, natūu nī de tiin ndá tēe íyó cuāchi nduhū. ");
INSERT INTO mieNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nacuiñī ndá nú, chi ja vāji tēe nastúu nduhū, de cōhōn jíín dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","De juni súcuán cáhān cā yā, de nī nquenda-ni Judas, iin táhán jā úxī ūū tēe scuáha jíín yā. De vāji cuāhā tēe jíín dē, ndíso ndá dē espada jíín ñutun. Chi ndá sūtū cúñáhnú jíín ndá tēe stéhēn ley janahán jíín ndá tēe ñáhnú jā ndácu tiñu, nī ntetíñú ndá tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","De Judas, tēe jā nastúu yā, ja nī jēhe dē iin seña nūū ndá tēe ñúcuán, chi nī ncachī dē: Tēe jā techuhú nī, ñúcuán cúu. Tiin ndá nú quīhīn nū jíín, de mā siáā cuitī nū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","De nī nquenda dē nūū Jesús, de nī ncāhān dē jíín yā: Maestro, Maestro, ncachī dē. De nī ntechuhú dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","De ndá cā tēe ñúcuán nī ntiin dē yā, de cuāhān dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","De iin tēe íyó jíín yā nī ntavā dē espada dē, de nī jehndē dē sōho iin mozo maá sūtū cúñáhnú cā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","De nī ncāhān Jesús jíín nchivī cuāhā: ¿De va tēe cuíhná cúu nī jā váji ndá nú jíín espada jíín ñutun jā tiin ndá nú nduhū, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ndācá quīvī nī īyo nī jíín ndá nú inī templo cāhnú, nī stéhēn ni tūhun, de nduú ní ntíin ndá nú nduhū. De súcuán sáhá ndá nú tácua quee ndaā jā cáhān tutū īī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ñúcuán de ndihi tēe scuáha jíín yā, nī sndóo dē yā, de nī jinu dē cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","De iin tēe suchí níquīn dē yā cuāhān dē jíín yā. De níjin dē iin sahma cuijín-ni, chi íyó ñií dē. De nī ntiin ndá tēe ñúcuán dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","De maá-ni sahma cuijín ñúcuán nī nīhīn ndá. De nī jinu ñií dē cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ñúcuán de cuāhān ndá dē jíín Jesús nūū sūtū cúñáhnú cā. De ndācá sūtū cúñáhnú jíín ndá tēe ñáhnú jā ndácu tiñu jíín ndá tēe stéhēn ley janahán, nī ncutútú dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","De Pedro chi jícá-ni níquīn dē yā, de nī nquenda dē inī patio sūtū cúñáhnú cā. De nī jēcundeē dē jíín ndá policía, násaā dē nūū ñúhūn. ");
INSERT INTO mieNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","De ndá sūtū cúñáhnú jíín ndihi tēe sáhá junta cúñáhnú cā, nī nducú dē cuāchi sīquī Jesús, chi cahnī dē yā cúnī dē. Sochi nduú ní níhīn ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Chi cuāhā dē nī ncāhān tūhún dē sīquī yā, sochi nduú ní nquétáhán tūhun jā ní ncāhān ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ñúcuán de nī nacuiñī sava dē, de nī ncāhān tūhún dē cuāchi sīquī yā, ncachī dē: ");
INSERT INTO mieNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ndá máá sá nī jini sá jā ní ncāhān dē jā canī dē templo yáhá jā ní ncuvāha jíín ndahá tēe, de nūū únī quīvī de nasāhá dē incā jā má cúvāha jíín ndahá tēe, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","De ni jíín tūhun yáhá de nduú ní nquétáhán tucu tūhun jā cáhān ndá dē sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ñúcuán de sūtū cúñáhnú cā nī nacuiñī dē nūū nchivī cuāhā, de nī jīcā tūhún dē Jesús: ¿Nūcu nduú cáhān cuitī nū? ¿A íyó ndāā jā cáhān ndá tēe yáhá sīquī nū? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sochi maá yā nduú ní ncáhān yā, chi nduú ní náscócóo cuitī yā. De sūtū cúñáhnú cā nī jīcā tūhún tucu dē yā: ¿A maá nú cúu Cristo, Sēhe Yāā vāha jā cúñáhnú? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","De nī ncāhān yā: Suu cúu nī. De cunī nū jā nduhū, Yāā nī nduu tēe, cundeē ni lado cuáhá Yāā íyó poder, de ndiji nī ichi andiví jíín vīcō, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ñúcuán de sūtū cúñáhnú cā nī ndatá dē-ni sahma dē jā ní nquītī inī dē, de nī ncāhān dē: ¿Nā testigo cā jíni ñúhún ó túsaá? ");
INSERT INTO mieNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chi ja nī jini ndá nú jā cáhān dē tūhun nāvāha jā quītī inī Yāā Dios, chi sáhá dē maá dē Sēhe Yāā Dios. ¿De nāsa jáni inī ndá nú? ncachī dē. De ndihi dē nī ncāhān dē jā ná cúū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","De sava dē nī ntivī sīí dē nūū yā, de nī jasī dē sahma nūū yā, de nī jēhe dē jīquí yā, de nī ncāhān ndá dē jíín yā: Cachī ní iin cúu jā ní ncani ndóhó, ncachī dē. De ndá policía nī ncani dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","De ndéē Pedro inī patio ichi chíjin nūū íyó Jesús. De nī nquenda iin ñahan sátíñú vehe sūtū cúñáhnú cā. ");
INSERT INTO mieNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","De nī jinī ña nūū dē jā ndéē dē násaā dē yúñúhūn. De nī ndēhé vāha ña nūū dē, de nī ncāhān ña: Ndóhó chi suni nī jica nú jíín Jesús, tēe ñuū Nazaret, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","De maá dē nduú ní ncáchī dē, chi nī ncāhān dē: Nduú jínī ni dē, de ni nduú jínī ni nā tūhun cáhān nū, ncachī dē. De nī nquee dē viéhé tāvēhé, de nī ncana-ni lohló. ");
INSERT INTO mieNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","De ñahan sátíñú ñúcuán, nī jinī tucu ña nūū dē, de nī nquijéhé ña cáhān ña jíín ndá nchivī jā íyó ñúcuán: Tēe yáhá chi suni táhán ndá tēe ñúcuán cúu, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Sochi nduú ní ncáchī tucu dē. De nī ncunúú jacū cā, de nchivī íyó ñúcuán nī ncāhān tucu ji jíín Pedro: Jāndáā ndija jā suni táhán ndá dē cúu nú, chi tēe Galilea cúu nú, de iin nuú-ni cáhān nū jíín ndá dē, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sá de nī nquijéhé dē cáhān téyíí dē jā ná cúndeē cuāchi sīquī dē de tú nduú cáhān ndāā dē: Nduú jínī cuitī ni tēe ñúcuán jā cáhān ndá nú tūhun dē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ñúcuán de nī ncana-ni lohló vuelta ūū. De nī nūcūhun inī dē tūhun jā ní ncāhān Jesús jíín dē: Jondē tá ncháha ca cana lohló vuelta ūū, de yūhú nú de cachī nū ūnī vuelta jāá nduú jínī nū nduhū, ncachī yā. De nī nacani inī dē sīquī tūhun ñúcuán, de nī jacu dē. ");
INSERT INTO mieNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","De tá nī ncunijīn, de ndá sūtū cúñáhnú nī ndutútú dē jíín ndá tēe ñáhnú jā ndácu tiñu, jíín ndá tēe stéhēn ley janahán, jíín ndihi tēe sáhá junta cúñáhnú cā, de nī scáni táhán dē tūhun. De nī juhnī ndá dē Jesús de cuāhān dē jíín yā nūū Pilato, tēe cúu gobernador. ");
INSERT INTO mieNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","De Pilato nī jīcā tūhún dē yā: ¿A maá nú cúu Rey nchivī hebreo? ncachī dē. De nī ncāhān yā: Suu cúu nī, tá cúu nūū cáhān nū. ");
INSERT INTO mieNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","De ndá sūtū cúñáhnú nī ncāhān dē cuāhā cuāchi sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","De Pilato nī jīcā tūhún tucu dē yā: ¿Nūcu nduú cáhān cuitī nū? ¿A nduú jínī nū jā cuāhā cuāchi cáhān ndá dē sīquī nū? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sochi nduú ní ncáhān cuitī yā ni iin tūhun jíín dē. De nī nsāhvi ndasí inī Pilato ndéhé dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","De íyó costumbre Pilato jā ndācá vico pascua siáā dē iin tēe yíhí vecāa, nā-ni tēe cúnī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","De íyó iin tēe nání Barrabás, yíhí dē vecāa jíín ndá táhán dē sīquī jā ní nenda ndá dē sīquī gobierno de nī jahnī ndá dē ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","De nī nquenda nchivī cuāhā, de nī ncāhān ji jíín Pilato jā ná sáhá dē tá-ni íyó costumbre dē. ");
INSERT INTO mieNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","De nī ncāhān Pilato jíín ji: ¿A cúnī ndá nú jā siáā ni tēe cúu Rey ndá ndóhó nchivī hebreo? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Súcuán nī ncāhān dē, chi cúnī dē siáā dē Jesús. Chi ja nī jīcūhun inī dē jā ní ncucuásún inī ndá sūtū cúñáhnú, de jā ñúcuán nī nasiáha ndá dē yā nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sochi ndá sūtū cúñáhnú nī scáhān dē nchivī cuāhā jā vāha cā ná cácān ji jā siáā Pilato Barrabás. ");
INSERT INTO mieNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ñúcuán de nī jīcā tūhún tucu Pilato: ¿Túsaá de nāsa cúnī ndá nú jā sāhá nī jíín tēe jā cáchī ndá nú jā cúu dē Rey ndá ndóhó nchivī hebreo? ncachī dē jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","De nī ncana jee ndá ji: Cata caa ní dē yīcā cruz, ná cúū dē, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","De nī ncāhān Pilato: ¿Nā cuāchi nī nsāhá dē túsaá? De ndá nchivī nī ncana jee tucu ji: Cata caa ní dē yīcā cruz, ná cúū dē, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","De Pilato chi cúnī dē jā cusiī inī nchivī jíín dē, de nī nsiáā dē Barrabás. Ñúcuán de nī ndacu dē jā ná cáni ndá soldado Jesús, sá de cata caa dē yā yīcā cruz. ");
INSERT INTO mieNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ñúcuán de ndá soldado cuāhān dē jíín yā, de nī nquīvi dē patio maá palacio. De nī nastútú dē ndihi táhán dē. ");
INSERT INTO mieNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","De nī nchuhun ndá dē yā iin sahma cuahá ndíhí jā cúu sahma rey. De nī nsāhá dē iin corona iñu, nī nchuhun dē xīnī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ñúcuán de nī ncāhān sācá ndá dē jíín yā: Nācā vāha rey cúu Rey nchivī hebreo, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","De nī ncuun dē ñutun xīnī yā, de nī ntivī sīí dē nūū yā, de nī jēcuīñī jītí ndá dē nūū yā, sáhá dē jā chíñúhún dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","De tá nī ncuu nī nsāhá sácá dē yā, de nī ntavā dē sahma cuahá ndíhí, de nī nachuhun dē yā sahma maá yā. De nī ntavā ndá dē yā cuāhān dē jíín yā jā cata caa dē yā yīcā cruz. ");
INSERT INTO mieNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","De iin tēe nání Simón ñuū Cirene, tēe cúu tatá Alejandro jíín Rufo, vāndiji dē jā ní jēhēn dē rancho. De nī nchāha dē ñúcuán, de nī ntee ndá soldado tiñu dē jā cuiso dē cruz yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","De cuāhān ndá dē jíín yā iin lugar nūū nání Gólgota, de tūhun ñúcuán cáhān: Lugar Yiqui Xínī. ");
INSERT INTO mieNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","De nī jēhe ndá dē vino jā ní nsacā nuu jíín sūja ūguā jā coho yā, sochi nduú ní jíhi yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","De nī jata caa ndá dē yā yīcā cruz. De nī nsāhá dē suerte sīquī nāsa nīhīn iin iin dē sahma yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","De cahīīn nī jata caa dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","De tūhun jā ní ntee dē xīnī cruz jā cáhān nā sīquī nī jīhī yā, súcuán cáhān: Yáhá cúu Rey nchivī hebreo, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","De suni nī jata caa ndá dē ūū tēe cuíhná yīcā ūū cā cruz, iin dē lado cuáhá yā, de incā dē lado sátín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","De nī nquee ndaā tūhun jā cáhān tutū īī: Nī squétáhán ndá dē yā jíín ndá tēe nēhén, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","De nchivī jā yáha ñúcuán, scuícó ji xīnī ji, de nī ncāhān yīchī ji jíín yā: Jājáān. Ndóhó chi cáhān nū jā canī nū templo cāhnú, de nūū únī quīvī de nasāhá nú. ");
INSERT INTO mieNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Túsaá de scácu nú maá nú, de nuu nú yīcā cruz viī, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","De suni súcuán nī ncāhān catá ndá sūtū cúñáhnú jíín ndá tēe stéhēn ley janahán, de cáhān ndá máá dē: Tú incā nchivī nī scácu dē, ¿de nūcu nduú cúu scácu dē maá dē mitan? ");
INSERT INTO mieNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tú cunī ō jā Cristo, Rey nchivī Israel, nuu dē yīcā cruz mitan, ñúcuán de candíja ó, ncachī ndá dē. De ndúū tēe jā ndíta caa jíín yā yīcā cruz, suni súcuán nī ncāhān yīchī dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","De tá nī ncuu cahūxī ūū, de nī ncuneē níí cáhnú jondē cahūnī. ");
INSERT INTO mieNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","De tá nī ncuu cahūnī, de nī ncana jee Jesús: Eloi, Eloi, ¿lama sabactani? ncachī yā. De tūhun ñúcuán cáhān: Yāā Dios maá sá, Yāā Dios maá sá, ¿nūcu nī sndóo ní sāán? ");
INSERT INTO mieNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","De sava nchivī íñí ñúcuán, nī jini ji jā cáhān yā, de nī ncāhān ji: Cunini ndá nú, chi cána dē Elías, tēe nī nacani tūhun Yāā Dios janahán, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","De nī jinu iin tēe, nī jēchundaji dē iin cāchī nūū vinagre iyá. De nī ntee dē xīnī iin ñutun, de nī ntee dē yuhú yā jā coho yā. De nī ncāhān dē: Ná cúndēhé ó tú quiji Elías snúu dē tēe yáhá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","De maá Jesús nī ncana jee yā, de nī jīhī yā-ni. ");
INSERT INTO mieNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sá de sahma jā ndíta caa jā ndásī nūū cuarto īī inī templo cāhnú, nī ndātā sava sava jondē xīnī jíín jondē jēhē. ");
INSERT INTO mieNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","De tēe Roma jā cúu capitán, íñí dē nūū yā, de nī jinī dē jā ní ncana jee yā de nī jīhī yā. De nī ncāhān dē: Jāndáā ndija jā Sēhe Yāā Dios cúu tēe yáhá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","De suni íñí sava ñahan, ndéhé jícá ña. De ūnī ña cúu María ñuū Magdala, jíín María naná José jíín Jacobo suchí, jíín ñahan nání Salomé. ");
INSERT INTO mieNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","De ndá ñahan yáhá nī niquīn ña yā, de nī nchindeé ña yā tá nī jica yā región Galilea. De suni íñí cuāhā cā ndá ñahan jā ní nquiji jíín yā Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","De nī ñini quīvī ñúcuán. De quīvī sátūha cúu, chi stēēn cúu quīvī nátātú. ");
INSERT INTO mieNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","De nī nquenda José, tēe ñuū Arimatea. De cúu dē iin tēe cúñáhnú nūū junta cúñáhnú cā. De suni ñúhún inī dē jā quiji quīvī jā tatúnī Yāā Dios. De nduú yúhú dē chi nī nquīvi dē nūū Pilato, de nī jīcān dē yiqui cúñu Jesús. ");
INSERT INTO mieNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","De Pilato chi nī nsāhvi inī dē jā ñamā nī jīhī yā. De nī ncana dē capitán, de nī jīcā tūhún dē tēe ñúcuán tú ja nī jīhī yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ñúcuán de nī ncucáhnú inī dē jā ní ncāhān capitán jíín dē, de nī jēhe dē tūhun jā snúu José yiqui cúñu yā. ");
INSERT INTO mieNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","De nī jeen José iin sahma cuijín váha. De nī snúu dē yiqui cúñu yā, de nī nchusúcún dē sahma ñúcuán. De nī nchiyuhū dē yā inī iin yavī ndīyi jā ní ncaān yīcā iin cava. De nī jasī dē iin yūū yuhú yávī ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","De María ñuū Magdala, jíín María naná José, nī jinī ndúū ña nūū ní nchiyuhū dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","De nī ñini quīvī nátātú, de María ñuū Magdala, jíín María naná Jacobo, jíín Salomé, nī jeen ndá ña ndācá perfume jā quíchīhi ña yiqui cúñu yā. ");
INSERT INTO mieNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","De jānehēn quīvī domingo, tá cáta nquenda ncandiī, de nī nquenda ndá ña nūū yíyuhū yā. ");
INSERT INTO mieNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","De nī ncāhān ndá ña: ¿Ní nīhīn ō tēe jā sāhá jíyo yūū ndásī yúyávī yáhá? ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","De nī nūcūndēhé ndá ña, de nī jinī ña ja nī ncujiyo yūū cāhnú ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","De nī nquīvi ndá ña inī yavī ndīyi. De nī jinī ña iin ángel Yāā Dios jā cáá tá cáá tēe suchí, ndéē yā lado cuáhá, ñúhún yā iin sahma cuijín cání. De nī nchūhú ndá ña. ");
INSERT INTO mieNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","De nī ncāhān yā jíín ña: Mā cúyūhú ndá nú. Chi nánducú ndá nú Jesús ñuū Nazaret, Yāā nī jīhī yīcā cruz. Nduú cā yā yáhá, chi ja nī natecū yā. Yáhá cūndēhé nú nūū ní jaquīn ndá dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cuánohōn ndá nú túsaá, de cachī nū nūū ndá tēe scuáha jíín yā, jíín nūū Pedro, jā xihna cā maá yā jīnū Galilea, sá de cuēē ndá máá nú. De ñúcuán cunī nū nūū yā, tá cúu nūū ní ncāhān yā jíín nú jondē saá, ncachī ángel. ");
INSERT INTO mieNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ñúcuán de nī nquee ndá ña nūū ní nchiyuhū yā, de jínu ña cuāhān ña. Chi quísi ña jā yúhú ña. De nduú ní ncáchī cuitī ña nūū ni iin, chi yúhú ndá ña. ");
INSERT INTO mieNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","De Jesús nī natecū yā jānehēn quīvī domingo. De xihna cā nūū María ñuū Magdala nī nenda nijīn yā, ñahan jā ní ntavā yā ūjā tāchī inī. ");
INSERT INTO mieNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","De cuānohōn ña cuācachī tūhun ña nūū ndá tēe jā ní jica jíín yā, jā ní nenda nijīn yā nūū ña. De cúcuécá inī ndá dē de jácu ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","De tá nī jini ndá dē tūhun jā ní jinī ña nūū yā jā técū yā, de nduú ní ncándíja dē tūhun cáhān ña. ");
INSERT INTO mieNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ñúcuán de nī nquee ūū táhān tēe ñúcuán, jíca dē cuāhān dē ichi rancho, de síín modo nī nquenda nijīn yā nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","De nī ndicó ndúū dē, de nī ncachī tūhun dē nūū ndá cā táhán dē. De nduú ní ncándíja tucu táhán dē jā cáhān ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","De cuéé cā de nī nenda nijīn yā nūū ndihúxī iin dē, ndéē ndá dē nūū mesa yájī dē stāā. De nī ncāhān yā nūū dē, chi nīhin inī ndá dē jāá nduú cándíja dē tūhun jā ní ncāhān ndá táhán dē jā ní natecū yā nī jinī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","De nī ncāhān yā jíín dē: Cuáhán ndá nú níí ñayīví, de nacani nú tūhun nī nūū ndācá nchivī nāsa scácu nī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","De nchivī jā candíja de cuenduté ji, chi cācu ji. De nchivī jā má cándíja, chi tānū tāhvī ji. ");
INSERT INTO mieNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","De nchivī candíja, sāhá ji ndá tiñu ñáhnú yáhá jā stéhēn jā íyó nī jíín ji: Jíín síví nī de tavā ji ndá tāchī inī nchivī. De cāhān ji quéhén yuhú jéé. ");
INSERT INTO mieNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","De tú nī ntiin ji cōō, á nī jihi ji veneno, de mā sāhá daño jíín ji. De suni tee ji ndahá ji nchivī cúhū, de nduvāha, ncachī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ñúcuán de tá nī ndihi nī ncāhān maá Jētohō ō jíín ndá dē, de nī ndaa yā cuānohōn yā andiví, de nī jēcundeē yā lado cuáhá Yāā Dios nūū cúñáhnú yā. ");
INSERT INTO mieNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","De ndá máá dē nī nquee dē, nī nacani dē tūhun yā ndācá lado nāsa scácu yā nchivī. De maá Jētohō ō nī nchindeé nī nchituu yā ndá dē. De nī jēhe yā fuerza jā sāhá dē ndá tiñu ñáhnú jā stéhēn jā íyó ndāā tūhun yā jā nácani ndá dē. De nī ncuu. Amén.");
INSERT INTO mieNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Cuāhā tēe nī nducú ndéé dē nī ntavā vāha dē historia Jesús, ndācá tiñu jā ní nsāhá yā nī jinī ndācá ó. ");
INSERT INTO mieNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","De nī ntee ndá dē ndá tūhun jā ní ncachī tūhun ndá nchivī nūū ō, jā ní jinī ji tiñu ñúcuán jondē tá nī nquijéhé, de nī nacani ji tūhun yā. ");
INSERT INTO mieNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","De sāán, suni nī nanducú vāha sá ndá tūhun yā jondē tá nī nquijéhé. De nī jani inī sá jā suni vāha jā tee cájí sá ndācá tūhun yáhá nūū ní, amigo Teófilo. ");
INSERT INTO mieNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","De súcuán de cunī ní jā íyó ndāā ndācá tūhun jā ní ncachī tūhun ndá ji nūū ní. ");
INSERT INTO mieNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tiempo jā ní ncuu Herodes rey Judea, de nī īyo iin sūtū nchivī hebreo, nání dē Zacarías, de grupo Abías cúu dē. De ñasíhí dē nání ña Elisabet, de suni tatā maá sūtū Aarón cúu ña. ");
INSERT INTO mieNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","De ndúū dē chi nchivī ndāā cúu dē nūū Yāā Dios, de vāha ndāā squíncuu dē tiñu jā ndácu ley maá Jētohō ō Yāā Dios, jínī ndá nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","De nduú nā sēhe dē íyó, chi ñahan númā cúu Elisabet, de ja ñáhnú ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","De iin quīvī de sátíñú Zacarías nūū tiñu jā cúu dē sūtū nūū Yāā Dios, chi nī nquenda quīvī jā ndīvi grupo dē. ");
INSERT INTO mieNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","De nī nsāhá ndá dē suerte tá cúu nūū íyó costumbre ndá sūtū. De nī nsāhá tocar Zacarías jā quīvi dē inī cuarto īī templo Jētohō ō Yāā Dios, de teñuhūn dē incienso. ");
INSERT INTO mieNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","De hora jā cáyū incienso, de ndá nchivī cuāhā íñí ji yātā templo, jícān táhvī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","De nī nquenda iin ángel maá Jētohō ō nūū Zacarías, íñí yā lado cuáhá altar nūū cáyū incienso. ");
INSERT INTO mieNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","De nī ncunēhén inī Zacarías jā ní jinī dē nūū yā, de nī nchūhú ndasí dē. ");
INSERT INTO mieNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","De nī ncāhān ángel jíín dē: Zacarías, mā cúyūhú nú, chi mitan de sāhá Yāā Dios jā ní jīcān táhvī nū. De ñasíhí nú Elisabet, scácu ña iin sēhe yií, de scúnaní nú ji Juan. ");
INSERT INTO mieNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","De cusiī ndasí inī nū. De cuāhā nchivī cusiī inī jā cacu ji. ");
INSERT INTO mieNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Chi cuñáhnú sēhe nú sāhá maá Yāā Dios. De mā cōhó ji vino ni ntexéēn, de cunuú maá Espíritu Santo jíín ji jondē ncháha ca cacu ji. ");
INSERT INTO mieNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","De sāhá ji jā cuāhā nchivī nación nū Israel ndicó inī ji nūū Jētohō ji Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","De xihna cā Juan quiji, nacani tūhun Jētohō ō Jesús, sá de quiji maá yā. De sāhá ji tá cúu nūū ní nsāhá Elías, tēe nī nacani tūhun Yāā Dios jondē janahán, de cunevāha ji poder jā nacani ji tūhun, tá cúu nūū ní nevāha Elías. De sāhá ji jā ndācá yuvá ndumanī dē jíín sēhe dē. De suni sāhá ji jā nchivī nīhin inī cuetáhví ji nūū Yāā Dios, nduu ji nchivī ndāā. Súcuán sāhá tūha ji nchivī tácua candíja ji maá Jētohō ō Jesús tá quiji yā, ncachī ángel. ");
INSERT INTO mieNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","De Zacarías nī jīcā tūhún dē yā: ¿Nāsa cucáhnú inī sá tú jāndáā cúu? Chi tēe ñáhnú cúu sá, de suni ñáhnú ñasíhí sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","De nī ncāhān ángel jíín dē: Maá nī cúu Gabriel, de íyó nī nūū Yāā Dios, jétíñú yā nduhū. De nī ntetíñú yā nduhū vāji nī jā cāhān ni jíín nú, de nácani nī tūhun vāha yáhá nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","De sīquī jāá nduú ní ncándíja nú tūhun jā ní ncāhān ni, de cuñíhín nú, de mā cūú cā cāhān nū, chi jondē tá cacu sēhe nú jíín ña. De quee ndaā ndija tūhun jā cáhān ni yáhá tá quenda quīvī, ncachī ángel. ");
INSERT INTO mieNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","De ndá nchivī íñí yātā templo, ndétu ji Zacarías, de jáni inī ji nā cuá cúu jā cúcuéé dē inī cuarto īī templo. ");
INSERT INTO mieNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","De tá nī nquee dē, de nduú cā ní ncúu cāhān dē jíín ji. De nī jīcūhun inī ji jā inī templo nī jinī nijīn dē iin jā ní stéhēn yā nūū dē. De maá seña-ni cā nī nsāhá dē nūū ji, chi nī ncuñíhín dē. ");
INSERT INTO mieNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","De tá nī jīnu quīvī jā sátíñú dē inī templo, de cuānohōn dē vehe dē. ");
INSERT INTO mieNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","De nī ncuu jacū quīvī, de ñasíhí dē Elisabet nī jīcūhun sēhe ña. De nī nquendōo ña vehe ña ūhūn yōō jāá nduú cā ní jéhēn ña. De jáni inī ña: ");
INSERT INTO mieNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Súcuán nī nsāhá maá Jētohō ō jíín nī, de nī ncandeē yā tūhun jā cúcanoō ni nūū nchivī jāá nduú sēhe nī, jáni inī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","De nūū íñū yōō, de nī ntají Yāā Dios ángel Gabriel, nī jēhēn yā iin ñuū nání Nazaret, ndáñúū Galilea. ");
INSERT INTO mieNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","De nī jēhēn yā nūū iin ñahan lúlí jā nání María. De ja nī ncundaā jā cueca iin tēe nání José ña, de tatā rey David cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","De nī nquīvi ángel nūū ndéē ña, de nī ncāhān yā: Ncu tandiī, de nācā ndetū tāhvī nū. Chi maá Jētohō ō Yāā Dios íyó yā jíín nú, de nī nsāhá yā jā ndetū ndasí cā nū nūū ndá cā ñahan, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","De tá nī jinī ña nūū ángel, de nī ncunēhén inī ña jā súcuán cáhān yā, de nī jani inī ña nūcu cáhān yā súcuán jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","De nī ncāhān cā ángel jíín ña: Mā cúyūhú nú María, chi nī nsāhá Yāā Dios jā váha ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","De jīcūhun sēhe nú de scácu nú iin sēhe yií, de scúnaní nú ji Jesús. ");
INSERT INTO mieNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","De cuñáhnú ji, de cunaní ji Sēhe Yāā cúñáhnú ndasí. De maá Yāā ñúcuán jā cúu yā Jētohō ō sāhá yā jā cuu ji rey, tá cúu tatā ji David jā ní ncuu dē rey. ");
INSERT INTO mieNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","De níí cání tatúnī ji nūū nchivī nación nū Israel. De mā ndīhí cuitī jā tatúnī ji, ncachī ángel. ");
INSERT INTO mieNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ñúcuán de nī jīcā tūhún María yā: ¿Nāsa coo tiñu jā ní ncāhān ní? Chi ncháha ca coo yií sá, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","De nī ncāhān ángel: Maá Espíritu Santo sāhá jā jīcūhun sēhe nú, de poder maá Yāā cúñáhnú ndasí sāhá iin tiñu ñáhnú jíín nú. De jā ñúcuán maá sūchí īī jā cacu, quihi cuenta ji nūū Yāā Dios, de cunaní ji Sēhe Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","De suni cáchī tūhun nī nūū nū jā táhán nú Elisabet, suni scácu ña iin sēhe yií, vísō ja ñáhnú ña. De mitan íyó īñū yōō jāá nduú cā cáhān nchivī jā cúu ña ñahan númā. ");
INSERT INTO mieNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Chi ndihi-ni cuu sāhá Yāā Dios, de nduú ni iin íyó jā má cūú sāhá yā, ncachī ángel. ");
INSERT INTO mieNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ñúcuán de nī ncāhān María: Cuu túsaá, de ná sáhá sá ndācá jā ndácu Jētohō ō Yāā Dios, de ná cóo jíín sá tá nī ncachī ní, ncachī ña. Sá de cuāhān-ni ángel. ");
INSERT INTO mieNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","De nī ncuu jacū quīvī, de ñamā cuāhān María, nī ncaa ña yucu cuāhān ña iin ñuū región Judea. ");
INSERT INTO mieNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","De nī jīnū ña vehe Zacarías, de nī ncāhān jítáhán ña jíín Elisabet. ");
INSERT INTO mieNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","De tá nī jini Elisabet jā cáhān María jíín ña, de sūchí ñúhún chījin ña nī ncandā ji-ni. De nī ncunuú Espíritu Santo jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","De nī ncāhān jee ña: Nī nsāhá Yāā Dios jā ndetū cā cúu nú nūū ndá cā ñahan, jíín jā coo ndetū ndasí sēhe nú. ");
INSERT INTO mieNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿De nāsa cúu jā ní nquenda naná Jētohō ni nūū ni? Chi nduú ná cúu cuitī ni. ");
INSERT INTO mieNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Chi tá nī jini nī tūhun jā ní ncāhān nū jíín nī, de sūchí ñúhún chījin nī nī ncandā ji-ni jā cúsiī inī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","De nācā ndetū nū jā ní ncandíja nú, chi quee ndaā ndācá tūhun jā ní ncāhān Jētohō ō Yāā Dios jíín nú, ncachī Elisabet. ");
INSERT INTO mieNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ñúcuán de nī ncāhān María: Cáhān ni jā cúñáhnú ndasí maá Jētohō ō Yāā Dios, ");
INSERT INTO mieNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","de cúsiī inī ni jíín maá yā jā scácu yā nduhū. ");
INSERT INTO mieNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Chi nī nsāhá yā cuenta nduhū, vísō nduú cúñáhnú nī. De ná squíncuu nī jā ndácu yā. De jondē mitan de ndá nchivī jā nacacu, cāhān ji jā ndetū ndasí nī. ");
INSERT INTO mieNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Chi Yāā tíin ndihi-ni poder, nī nsāhá yā tiñu ñáhnú jíín nī. De Yāā īī Yāā ndoo cúu yā. ");
INSERT INTO mieNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","De níí cání cundáhví inī yā ndá nchivī jā ndíhvī inī ji jā má stíví ji nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nī nsāhá yā tiñu ñáhnú jíín poder yā, chi nī scúnu yā ndá nchivī sáhá vīxī maá, ");
INSERT INTO mieNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","de ndá nchivī cúñáhnú, nī ncandeē yā jā cúñáhnú ji. De nchivī ndāhví, chi nī nsāhá ñáhnú yā ji, ");
INSERT INTO mieNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","de nchivī jíhī sōco, nī jēhe yā jā cajī vāha ji, de nchivī cuīcá, chi nī natají yā ji súcuán-ni. ");
INSERT INTO mieNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","De nī nchindeé nī nchituu yā yóhó nchivī nación Israel, jā cúu ó mozo yā, chi nduú náā inī yā jā cúndáhví inī yā yóhó. ");
INSERT INTO mieNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chi súcuán nī nquee yuhú yā nūū ndācá tatā ō, nūū Abraham jíín ndācá tatā dē jā coo níí cání. Ncachī María. ");
INSERT INTO mieNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","De nī ndeē ña jíín Elisabet tá ūnī yōō. Sá de cuānohōn ña vehe ña. ");
INSERT INTO mieNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","De nī nquenda quīvī jā scácu Elisabet sēhe ña, de nī scácu ña iin sēhe yií. ");
INSERT INTO mieNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","De ndá nchivī ndéē ñatin jíín ña jíín ndá táhán ña, nī jinī ji jā ní ncundáhví ndasí inī Yāā Dios ña, de nī nquenda ji nī ncāhān ji tūhun sīī jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ñúcuán de nūū únā quīvī jā ní ncacu ji, de nī jēhēn ndá nchivī nī nsāhá ji circuncidar sūchí ñíquín ñúcuán. (De ñúcuán cúu iin tunī nūū yiqui cúñu ndá sūchí yíí hebreo jā stéhēn jā cúu ji nchivī Yāā Dios.) De scúnaní ji sūchí ñúcuán síví tatá ji Zacarías nícu. ");
INSERT INTO mieNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","De nī ncāhān naná ji: Mā cūú, chi Juan cunaní ji, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","De nī ncāhān ndá ji jíín ña: ¿De nūcu? De nduú ni iin táhán nú nání súcuán, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ñúcuán de jíín seña nī jīcā tūhún ndá ji tatá sūchí ñúcuán nāsa cúnī dē jā cunaní ji. ");
INSERT INTO mieNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","De nī jīcān dē iin tutū, de nī ntee dē: Juan cunaní ji, cáchī. De ndācá nchivī nī nsāhvi inī ji nī jinī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","De nī nacahān-ni Zacarías jā ní ncuñíhín dē, de nī nquijéhé dē cáhān dē jā vāha ndasí Yāā cúu Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","De ndá nchivī ndéē ñatin jíín dē, nī nsāhvi ndasí inī ji. De níí yucu región Judea nī jītē nuu ndá tūhun yáhá jā súcuán nī ncuu. ");
INSERT INTO mieNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","De nchivī jā ní jini tūhun, nī nquijéhé ji nácani inī ji, de jícā tūhún táhán ji: ¿Nāsa coo tá cuahnu sūchí yáhá? ncachī ji. Chi maá Jētohō ō Yāā Dios nī nsāhá yā jā váha ndasí ji. ");
INSERT INTO mieNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","De tatá ji Zacarías nī ncunuú Espíritu Santo jíín dē, de nī nacani dē tūhun jā ní stéhēn Yāā Dios nūū dē: ");
INSERT INTO mieNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Nācā vāha ndasí Yāā cúu Jētohō ō, suu Yāā Dios maá ó nchivī Israel, chi nī nquiji yā nūū ō jā cúu ó nchivī yā, de nī scácu yā yóhó. ");
INSERT INTO mieNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","De nī jani yā iin Yāā íyó poder jā scácu yóhó, de Yāā ñúcuán cacu nūū tatā maá mozo yā rey David. ");
INSERT INTO mieNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chi súcuán nī nquee yuhú yā, de nī nacani ndá tēe ndoo jā ní nacani tūhun yā janahán. ");
INSERT INTO mieNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","De nī ncāhān ndá dē jā scácu yā yóhó nūū ndá jā jínī ūhvī yóhó, jíín nūū ndá jā quítī inī nūū ō. ");
INSERT INTO mieNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Chi nī ncundáhví inī yā ndācá tatā ō, de nduú ní náā inī yā trátū īī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Chi suu trátū ñúcuán nī ncāhān téyíí yā jíín tatā ō Abraham, ");
INSERT INTO mieNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","suu jā scácu yā yóhó nūū ndá jā jínī ūhvī yóhó, tácua sāhá ó tiñu cúnī yā de mā cúyūhú ó, ");
INSERT INTO mieNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","de coo ndāā coo ndoo ánō ō jā cuetíñú yā yóhó ndihi quīvī jā cutecū ō. ");
INSERT INTO mieNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","De ndóhó sūchí lúlí, cuu nú tēe nacani tūhun Yāā cúñáhnú ndasí. Chi cosō nūú nú ichi núū maá Jētohō ō Jesús, tácua sāhá tūha nú nchivī, sá de quiji yā. ");
INSERT INTO mieNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","De cachī tūhun nú nūū nchivī maá yā jā scácu yā ji, jíín jā cune cáhnú inī yā nūū cuāchi ji. ");
INSERT INTO mieNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chi Yāā Dios maá ó, vāha inī yā de cúndáhví inī yā yóhó. Jā ñúcuán tají yā maá Yāā jā stúu inī ánō ō, quiji yā jondē andiví, ");
INSERT INTO mieNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tácua jīcūhun inī ndá yóhó jā ndéē ō modo nūū neē nūū ja ñatin cuū ō. De chuhun yā yóhó ichi nūū coo ndeé coo siī inī ō. Ncachī Zacarías. ");
INSERT INTO mieNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","De sūchí lúlí ñúcuán nī jahnu ji de nī jija ji jíín tūhun yā. De nī īyo ji nūū ñuhun tíhá jondē quīvī jā ní nquenda nijīn ji nūū nchivī Israel. ");
INSERT INTO mieNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","De nī ncuu jacū quīvī, de Augusto, tēe cúu rey, nī ndacu dē tiñu jā coo censo jā nūcōsō síví ndiviī nchivī níí cáhnú nūū tátúnī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yáhá cúu censo jā xíhna ñúhún jā ní nsāhá ndá dē tá nī ncuu Cirenio gobernador nación Siria. ");
INSERT INTO mieNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","De ndiviī nchivī cuānohōn ji tá ñuū tá ñuū ji jā nacuāha ji síví ji. ");
INSERT INTO mieNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","De saá-ni José nī nquee dē ñuū Nazaret ndáñúū Galilea. De cuānohōn dē región Judea, de nī jīnū dē ñuū Belén, jā cúu ñuū nūū ní ncacu rey David janahán. Chi tatā David cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","De nī jēhēn dē tácua nacuāha dē síví dē jíín María, chi ja ñatin cundeē dē jíín ña. De ñúhún sēhe ña nī nsāhá Espíritu Santo. ");
INSERT INTO mieNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","De juni íyó ndúū dē ñúcuán de nī nquenda quīvī jā cacu sēhe ña. ");
INSERT INTO mieNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","De nī scácu ña sēhe yií xíhna ñúhún ña, de nī nchusúcún ña ji sahma vítá, de nī jaquīn ña ji inī iin tūndōó nūū yájī quiti, chi nduú cā núne mesón cundeē ndá ña. ");
INSERT INTO mieNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","De ñatin ñuū Belén íyó ndá tēe cúu pastor, de níí niñū jíto ndá dē tīcāchí dē jondē yucu. ");
INSERT INTO mieNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","De iin sanaā-ni de nī nquenda iin ángel maá Jētohō ō nūū dē, de nduva maá Jētohō ō nī jēndūtē níí nūū íyó dē. De nī nchūhú ndasí ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","De nī ncāhān ángel ñúcuán jíín dē: Mā cúyūhú ndá nú, chi vāji nī jā cachī tūhun nī iin tūhun vāha nūū nū, de sāhá jā cusiī ndasí inī ndācá nchivī: ");
INSERT INTO mieNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Chi mitan de inī ñuū David nī ncacu iin Yāā jā scácu ndá ndóhó, de maá Jētohō ō Cristo cúu yā. ");
INSERT INTO mieNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","De yáhá cúu seña jā nanihīn nū sūchí ñíquín ñúcuán, chi ñúsúcún ji sahma vítá, de cáá ji inī iin tūndōó nūū yájī quiti, ncachī ángel. ");
INSERT INTO mieNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","De sanaā-ni de nī nquenda cuāhā cā ángel andiví, íñí ndá yā jíín ángel ñúcuán, de cáhān ndá yā jā vāha ndasí Yāā cúu Yāā Dios. De suni cáhān yā: ");
INSERT INTO mieNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Viī ndasí cúñáhnú maá Yāā Dios jā ndéē nūū sūcún. De ná ndúvāha inī ndá nchivī ñayīví sāhá yā jā cúsiī inī yā jíín ji. Ncachī ndá ángel. ");
INSERT INTO mieNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ñúcuán de cuānohōn ndá ángel andiví. De ndá tēe cúu pastor nī ncāhān dē jíín táhán dē: Ná cóhōn ñuū Belén, de cunī ō nā cuá cúu jā ní ncuu jā ní ncachī tūhun Jētohō ō nūū ō, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","De ñamā cuāhān ndá dē, de nī nanihīn dē María jíín José jíín sūchí ñíquín, cáá ji inī tūndōó nūū yájī quiti. ");
INSERT INTO mieNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","De tá nī jinī ndá dē nūū ji, de nī nacani dē tūhun jā ní ncachī ángel nūū dē sīquī sūchí ñíquín. ");
INSERT INTO mieNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","De nī nsāhvi inī ndá nchivī nī jini ji tūhun jā cáhān ndá tēe cúu pastor. ");
INSERT INTO mieNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","De María nī nchuhun inī ña ndācá tūhun yáhá, de nácani inī ña sīquī. ");
INSERT INTO mieNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","De cuānohōn ndá pastor, de cáhān ndá dē jā vāha ndasí Yāā cúu Yāā Dios sīquī ndācá jā ní jini dē jíín jā ní jinī dē, chi nī nquee ndaā ndá tūhun jā ní ncachī ángel nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","De nī ncuu ūnā quīvī jā ní ncacu yā, de nī nsāhá ndá dē circuncidar sūchí ñíquín ñúcuán. De nī scúnaní dē ji Jesús, chi síví ñúcuán nī ncachī ángel nūū María jondē ncháha ca jīcūhun ji. ");
INSERT INTO mieNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","De nī jīnu quīvī jā ní squíncuu ndá ña costumbre jā ndúndoo ndá ña nūū Yāā Dios, tá cúu nūū cáhān ley jā ní jēhe yā nūū Moisés. De nī jēhēn ndúū dē jíín ji Jerusalén tácua stéhēn dē ji nūū Jētohō ō Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Súcuán nī nsāhá ndúū dē, chi yósō nūū tutū ley yā: Ndācá sūchí yíí jā cácu xihna ñúhún, quihi cuenta ji nūū Jētohō ō Yāā Dios, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","De suni cuāsōcō dē tá cúu nūū cáhān ley maá Jētohō ō: Sōcō ndá nú ūū livi á ūū paloma, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","De nī īyo iin tēe nání Simeón, ndéē dē Jerusalén tiempo ñúcuán. De tēe ndāā tēe chíñúhún vāha nūū Yāā Dios cúu dē. De ñúhún inī dē jā quenda maá Yāā jā scácu ndá nchivī nación dē Israel. De maá Espíritu Santo íyó yā jíín dē, ");
INSERT INTO mieNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","de ja nī ncachī tūhun yā nūū dē jā má cúū cuitī dē chi jondē cunī dē nūū Cristo jā tetíñú maá Jētohō ō Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","De nī stéhēn yā nūū dē jā quīhīn dē templo quīvī ñúcuán. De saá-ni tatá jíín naná sūchí ñíquín Jesús, nī nquīvi dē templo jíín ji jā sāhá dē ji tá cúu nūū cáhān ley Moisés. ");
INSERT INTO mieNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","De Simeón nī numi ndeē dē ji, de nī ncāhān dē jā vāha ndasí Yāā cúu Yāā Dios, de ncachī dē: ");
INSERT INTO mieNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Tátā Yāā Dios, mitan de cuu cuāha ní tūhun jā cuū sá da, chi ja nī ncusiī inī sá, chi ja nī squíncuu ní tūhun jā ní nquee yuhú ní nūū sá jā cúu sá mozo ní. ");
INSERT INTO mieNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chi nī jinī jínúū sá nūū Yāā jā scácu ndá sāán. ");
INSERT INTO mieNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","De nī jani ní yā jā scácu yā ndá nchivī ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","De maá yā sāhá jā cutūu inī ánō nchivī ndācá nación, tácua jīcūhun inī ji nāsa Yāā cúu ní. De sāhá yā jā cuñáhnú nchivī maá ní Israel. Ncachī Simeón. ");
INSERT INTO mieNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","De José jíín naná ji nī nsāhvi inī ndúū dē nī jini dē tūhun yā jā ní ncāhān Simeón. ");
INSERT INTO mieNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","De nī jīcān táhvī Simeón jēhē ndá dē, de nī ncāhān dē jíín naná ji María: Sūchí yáhá vāji ji tácua candíja cuāhā nchivī nación maá ó Israel, de cācu ji. De sava ji chi mā cándíja ji, de tānū tāhvī ji. Chi sūchí yáhá cúu ji Yāā jā ní ntetíñú Yāā Dios, de vísō súcuán de squéne yichī cuāhā nchivī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","De súcuán de tūu nijīn nāsa jáni inī ndá nchivī. De maá nú chi tahúhvī ndasí inī nū jā cunī nū jā ndoho ji, ncachī Simeón. ");
INSERT INTO mieNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","De suni íyó iin ñahan nácani tūhun Yāā Dios, nání ña Ana. De sēhe Fanuel, tatā Aser cúu ña. De ja ñáhnú ndasí ña. De jondē tá lulí ña de nī ndeē ña jíín yií ña ūjā cuīyā. ");
INSERT INTO mieNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Sá de nī nquendōo ndáhví ña, de ja íyó ña cūmī xico cūmī cuīyā. De nduú quée ña inī templo, chi nduú ñuú sáhá ña ndācá jā cúnī Jētohō ō Yāā Dios, de nditē inī ña de jícān táhvī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","De suni maá hora ñúcuán nī nquenda ña nūū íñí ndá dē, de nī nacuetáhví ña nūū Yāā Dios. De nī ncachī ña tūhun sūchí ñíquín ñúcuán nūū ndá nchivī Jerusalén jā ñúhún inī ji jā quenda maá Yāā jā scácu ji. ");
INSERT INTO mieNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","De nī ncuu nī squíncuu ndúū dē ndācá tiñu jā cáhān ley maá Jētohō ō Yāā Dios, de cuānohōn dē ñuū dē Nazaret región Galilea. ");
INSERT INTO mieNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","De sūchí lúlí ñúcuán nī jahnu ji, de nī jija ji, de nī ncundíchí ji. De nī nsāhá Yāā Dios jā váha ndasí ji. ");
INSERT INTO mieNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","De ndācá cuīyā jéhēn tatá ji naná ji Jerusalén, jā cúu vico pascua nchivī hebreo. ");
INSERT INTO mieNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","De tá nī ncuu ūxī ūū cuīyā ji, de cuāhān tucu ndá dē Jerusalén, tá cúu nūū jéhēn dē vico ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","De tá nī nchāha vico, de cuānohōn ndúū dē. De sūchí lúlí Jesús nī nquendōo ji Jerusalén, de nduú ní jínī José jíín naná ji. ");
INSERT INTO mieNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","De jáni inī ndúū dē jā cuáhān ji māhñú nchivī ñúhún ichi. De nī jica dē iin quīvī, sá de nī nanducú dē ji māhñú ndá táhán dē jíín nchivī jínī tāhán dē jíín. ");
INSERT INTO mieNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","De nduú ní nánihīn dē ji. Ñúcuán de nī ndicó cóo ndúū dē Jerusalén, cuānanducú dē ji. ");
INSERT INTO mieNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","De nūū únī quīvī de nī nanihīn dē ji inī templo, ndéē ji māhñú ndá tēe stéhēn ley janahán, de níni ji jā cáhān ndá dē, de jícā tūhún ji dē sīquī tūhun ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","De ndá nchivī jā níni tūhun cáhān ji, sáhvi inī ji jā vāha cájí xīnī ji de vāha scócóo ji tūhun. ");
INSERT INTO mieNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","De tá nī jinī naná ji tatá ji nūū ji, de nī nsāhvi inī ndúū dē. De nī ncāhān naná ji: Séhē, ¿nūcu nī nsāhá nú nduhū súcuán? Chi ndúū ni jíín tatá nú, nácani ndasí inī ni nánducú nī ndóhó, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ñúcuán de nī ncāhān ji: ¿Nūcu nánducú ní sāán? Chi cánuú jā cucuu sá jíín tiñu Tatá sá Yāā Dios, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","De nduú ní jícūhun inī ndúū ña tūhun cáhān ji jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sá de cuānohōn ji jíín ndúū dē ñuū Nazaret, de nī jetáhví ji nūū dē. De naná ji nī nchuvāha ña ndācá jā ní ncuu yáhá inī ánō ña. ");
INSERT INTO mieNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","De Jesús nī jahnu cā ji de nī ncundíchí cā ji. De cúsiī inī Yāā Dios jíín ji, de saá-ni ndācá nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","De nī ncuu xāhōn cuīyā jā tátúnī Tiberio níí nación. De Poncio Pilato cúu dē gobernador Judea, de Herodes cúu gobernador Galilea, de ñanī dē Felipe cúu gobernador Iturea jíín Traconite, de Lisanias cúu gobernador Abilinia. ");
INSERT INTO mieNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","De sūtū cúñáhnú cā cúu Anás jíín Caifás. De nī ncāhān Yāā Dios jíín Juan sēhe Zacarías, jā íyó dē ñuhun tíhá. ");
INSERT INTO mieNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","De nī jica nuu dē ndācá ñuū jā íyó ñatin yūte Jordán. De cáhān dē jíín nchivī jā ná nácani inī ji jā sndóo ji cuāchi ji de cuenduté ji, tácua cune cáhnú inī Yāā Dios nūū cuáchi ji. ");
INSERT INTO mieNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","De súcuán nī nquee ndaā tūhun Juan jā yósō nūū tutū jā ní ntee Isaías, tēe nī nacani tūhun Yāā Dios jondē janahán: Coo iin tēe jā cana jee jondē nūū ñuhun tíhá: Sāhá tūha ndá nú maá nú, chi quenda maá Jētohō ō, de sāhá ndá nú tiñu ndāā, chi vāji yā. ");
INSERT INTO mieNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","De ndācá xehvā ná ndúndaā, de ndācá yucu jíín lómō ná ndúu nduhā, de ná ndúndoó ichi tiácuá, de ichi ndáyí ná ndúu inuú. De suu cúu jā ndundaā ánō nchivī nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","De ndihi ji cunī ji jā scácu Yāā Dios ji. Súcuán cāhān Juan, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","De nī nquenda cuāhā nchivī nūū dē jā scuénduté dē ji. De nī ncāhān dē nūū ji: Va sēhe cōō cúu ndá nú, chi xēēn nū tá cúu cōō. ¿A jáni inī ndá nú jā cuu cunu nú cācu nú nūū castigo xēēn jā quiji? ");
INSERT INTO mieNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Túsaá de sāhá ndá nú tiñu váha, de súcuán stéhēn nū jā ní nacani ndija inī nū jā sndóo nú cuāchi nú. De mā cāní inī ndá nú cāhān nū jā cuu cācu nú sīquī jā cúu nú tatā Abraham. Chi cáhān ni jíín ndá nú jā cuu sāhá Yāā Dios jā ndācá yūū yáhá nduu sēhe Abraham jā candíja vāha, de tú cúnī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","De cúu ndá nú tá cúu tūndīhá jāá nduú jéhe jāvíxī vāha. De mitan de ja íyó tūha Yāā Dios jā cuāha yā castigo xēēn, tá cúu nūū íyó tūha iin cāa jā quehndē jondē yoho ñutun. Túsaá de sāhá yā jíín ndá nú tá cúu nūū sáhá yā jíín ndācá ñutun jāá nduú jéhe jāvíxī vāha, jā tēhndē de cāyū nūū ñúhūn, ncachī Juan. ");
INSERT INTO mieNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","De ndá nchivī nī jīcā tūhún ji dē: ¿De nāsa sāhá ndá sá túsaá? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","De nī ncāhān dē: Ndá ndóhó jā névāha ūū sahma, de cuāha nú iin nūū nchivī jāá nduú ná névāha. De ndá ndóhó jā íyó jā yájī, suni súcuán sāhá nú, ncachī dē jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","De suni jacū tēe stútú xūhún renta nī nquenda dē jā cuenduté dē. De nī jīcā tūhún ndá dē Juan: Maestro, ¿de ndá sāán, nāsa sāhá sá? ");
INSERT INTO mieNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","De nī ncāhān Juan jíín ndá dē: Mā scáa nú cācān nū xūhún, chi tá-ni jā ní ndacu nūū nū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","De suni nī jīcā tūhún jacū soldado: ¿De ndá sāán, nāsa sāhá sá? ncachī dē. De nī ncāhān Juan jíín dē: Mā cándeē nū ndatíñú ni iin nchivī jíín tūhun siúhú ni jíín tūhun stáyáhvi, de mā ndíyo inī nū jā caa yāhvi nú, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","De ndācá nchivī ndétu ji jā quiji Cristo, Yāā jā tetíñú Yāā Dios, de jáni inī ji jā sanaā de suu cúu Juan. ");
INSERT INTO mieNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","De nī ncāhān Juan jíín ndá ji: Nduhū chi jíín ndute scuénduté nī ndá ndóhó. De vāji iin Yāā jā modo jā scuénduté yā ndá nú cúu jā cuāha yā Espíritu Santo cundeē inī ánō nū, de poder yā cúu tá cúu ñuhūn. De cuñáhnú ndasí cā yā nsūú nduhū, chi nduú cúñáhnú cuitī ni nūū yā, ni jā cuetíñú yā nduhū vísō iin tiñu lúlí cā jā nandají nī correa nījān yā. ");
INSERT INTO mieNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","De sāhá yā tá sáhá tēe stéchí trigo, chi sāhá síín yā nchivī vāha jíín nchivī nēhén, tá cúu nūū cúndoo trigo jā quée síín paja. De nastútú yā trigo yā ndīvi inī yacā yā. Sochi paja chi teñuhūn yā nūū ñúhūn jā má ndáhvā cuitī, ncachī Juan. ");
INSERT INTO mieNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","De jíín ndá tūhun yáhá jíín cuāhā cā tūhun nī sndíhvī inī dē nchivī, de nī nacani dē tūhun vāha Yāā Dios nūū ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","De suni nī ncāhān dē nūū Herodes, tēe cúu gobernador, chi tēe ñúcuán nī nacueca dē Herodías, ñasíhí ñanī dē Felipe. De cuāhā cā tiñu néhén súcuán nī nsāhá Herodes. ");
INSERT INTO mieNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","De sa víhí cā nī nsāhá nēhén dē, chi nī nchihi dē Juan vecāa. ");
INSERT INTO mieNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","De jondē ncháha ca quīvi Juan vecāa, tá nī īyo dē jā ní scuénduté dē ndá nchivī, de suni nī scuénduté dē Jesús. De jícān táhvī yā, de nī nune-ni nūū ndéē Yāā Dios andiví. ");
INSERT INTO mieNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","De nī ncuun Espíritu Santo nī jīnū xīnī yā, de cáá tá cáá iin paloma. De ichi andiví nī ncāhān iin tūhun: Maá nú cúu Sēhe nī jā mānī ndasí nī jíín, de cúsiī ndasí inī ni jíín nú, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","De tá nī nquijéhé Jesús stéhēn yā tūhun, de íyó yā tá ōcō ūxī cuīyā. De jáni inī nchivī jā sēhe José cúu yā. De José nī ncuu sēhe Elí, ");
INSERT INTO mieNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","de Elí nī ncuu sēhe Matat, de Matat nī ncuu sēhe Leví, de Leví nī ncuu sēhe Melqui, de Melqui nī ncuu sēhe Jana, de Jana nī ncuu sēhe José, ");
INSERT INTO mieNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","de José nī ncuu sēhe Matatías, de Matatías nī ncuu sēhe Amós, de Amós nī ncuu sēhe Nahum, de Nahum nī ncuu sēhe Esli, de Esli nī ncuu sēhe Nagai, ");
INSERT INTO mieNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","de Nagai nī ncuu sēhe Maat, de Maat nī ncuu sēhe Matatías, de Matatías nī ncuu sēhe Semei, de Semei nī ncuu sēhe José, de José nī ncuu sēhe Judá, ");
INSERT INTO mieNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","de Judá nī ncuu sēhe Joana, de Joana nī ncuu sēhe Resa, de Resa nī ncuu sēhe Zorobabel, de Zorobabel nī ncuu sēhe Salatiel, de Salatiel nī ncuu sēhe Neri, ");
INSERT INTO mieNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","de Neri nī ncuu sēhe Melqui, de Melqui nī ncuu sēhe Adi, de Adi nī ncuu sēhe Cosam, de Cosam nī ncuu sēhe Elmodam, de Elmodam nī ncuu sēhe Er, ");
INSERT INTO mieNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","de Er nī ncuu sēhe Josué, de Josué nī ncuu sēhe Eliezer, de Eliezer nī ncuu sēhe Jorim, de Jorim nī ncuu sēhe Matat, ");
INSERT INTO mieNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","de Matat nī ncuu sēhe Leví, de Leví nī ncuu sēhe Simeón, de Simeón nī ncuu sēhe Judá, de Judá nī ncuu sēhe José, de José nī ncuu sēhe Jonán, de Jonán nī ncuu sēhe Eliaquim, ");
INSERT INTO mieNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","de Eliaquim nī ncuu sēhe Melea, de Melea nī ncuu sēhe Mainán, de Mainán nī ncuu sēhe Matata, de Matata nī ncuu sēhe Natán, ");
INSERT INTO mieNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","de Natán nī ncuu sēhe David, de David nī ncuu sēhe Isaí, de Isaí nī ncuu sēhe Obed, de Obed nī ncuu sēhe Booz, de Booz nī ncuu sēhe Salmón, de Salmón nī ncuu sēhe Naasón, ");
INSERT INTO mieNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","de Naasón nī ncuu sēhe Aminadab, de Aminadab nī ncuu sēhe Aram, de Aram nī ncuu sēhe Esrom, de Esrom nī ncuu sēhe Fares, de Fares nī ncuu sēhe Judá, ");
INSERT INTO mieNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","de Judá nī ncuu sēhe Jacob, de Jacob nī ncuu sēhe Isaac, de Isaac nī ncuu sēhe Abraham, de Abraham nī ncuu sēhe Taré, de Taré nī ncuu sēhe Nacor, ");
INSERT INTO mieNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","de Nacor nī ncuu sēhe Serug, de Serug nī ncuu sēhe Ragau, de Ragau nī ncuu sēhe Peleg, de Peleg nī ncuu sēhe Heber, de Heber nī ncuu sēhe Sala, ");
INSERT INTO mieNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","de Sala nī ncuu sēhe Cainán, de Cainán nī ncuu sēhe Arfaxad, de Arfaxad nī ncuu sēhe Sem, de Sem nī ncuu sēhe Noé, de Noé nī ncuu sēhe Lamec, ");
INSERT INTO mieNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","de Lamec nī ncuu sēhe Matusalén, de Matusalén nī ncuu sēhe Enoc, de Enoc nī ncuu sēhe Jared, de Jared nī ncuu sēhe Mahalaleel, de Mahalaleel nī ncuu sēhe Cainán, ");
INSERT INTO mieNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","de Cainán nī ncuu sēhe Enós, de Enós nī ncuu sēhe Set, de Set nī ncuu sēhe Adán, de Adán nī ncuu sēhe Yāā Dios, chi nī nsāhá yā dē. ");
INSERT INTO mieNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","De Jesús nī ncunuú Espíritu Santo inī yā, de nī nquee yā yūte Jordán cuāhān yā. De nī jīnū yā jondē nūū ñuhun tíhá nī nsāhá Espíritu Santo. ");
INSERT INTO mieNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","De nī īyo yā ñúcuán ūū xico quīvī, de nī jito túnī tāchī cúñáhnú yā, chi cúnī jā sāhá yā cuāchi. De ndá quīvī ñúcuán nduú ní nchájī cuitī yā, de tá nī nchāha quīvī ñúcuán, de nī nquiji sōco nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ñúcuán de nī ncāhān tāchī cúñáhnú jíín yā: Tú maá nú cúu Sēhe Yāā Dios, de cāhān nū jā ndá yūū yáhá ná ndúu stāā cajī nū, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","De nī ncāhān Jesús jíín: Nduú chi yósō nūū tutū īī: Nsūú mátúhún-ni stāā cúu jā técū nchivī, chi suni jíín ndācá tūhun jā cáhān Yāā Dios, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ñúcuán de cuāhān tāchī cúñáhnú jíín yā jondē xīnī iin yucu súcún, de iin núnúú-ni nī stéhēn nūū yā ndācá nación níí cáhnú ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","De nī ncāhān jíín yā: Nūū maá nú cuāha nī jā cuñáhnú nú nūū ndiviī nación yáhá, chi viī ndasí cáá. Chi maá nī tíin ndihi, de cuu cuāha nī nūū ní-ni iin cúnī ni. ");
INSERT INTO mieNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Túsaá de tú cuiñi jítí nú chiñúhún nú nduhū, de cuāha ndihi nī nūū nū, ncachī tāchī. ");
INSERT INTO mieNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","De nī ncāhān Jesús jíín: Satanás, cujiyo cuáhán, chi yósō nūū tutū jā chiñúhún nchivī maá Jētohō ji Yāā Dios, de nūū mátúhún-ni yā satíñú ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ñúcuán de cuāhān tāchī cúñáhnú jíín yā jondē Jerusalén. De nī jani yā xīnī torre templo. De nī ncāhān jíín yā: De tú Sēhe Yāā Dios cúu nú, de squíncava nú maá nú jondē nūū ñūhún, chi scácu yā ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Chi yósō nūū tutū: Tetíñú yā ndá ángel yā jā coto ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","De canee ndá yā ndóhó, tácua mā scáchihi nú jēhē nū nūū yúū. Cáchī tutū. Ncachī tāchī. ");
INSERT INTO mieNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","De nī ncāhān Jesús: Nduú chi suni yósō nūū tutū jā má cōtó túnī nchivī Jētohō ji Yāā Dios, á scácu yā ji á nduú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","De nduú cā ní níhīn tāchī cúñáhnú modo jā coto túnī ji Jesús quīvī ñúcuán, de nī ncujiyo cuāhān jacū tiempo. ");
INSERT INTO mieNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","De nī ncunuú fuerza Espíritu Santo inī Jesús, de cuānohōn yā Galilea. De níí región ñatin ñúcuán nī jītē nuu tūhun yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","De nī stéhēn yā tūhun inī ndá vehe īī sinagoga, de ndihi nchivī nī jetúhún ji yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","De nī nenda yā ñuū Nazaret nūū ní jahnu yā. De quīvī nátātú nī nquīvi yā inī vehe īī sinagoga, tá-ni sáhá yā. De nī nacuiñī yā jā cahvi yā tutū īī. ");
INSERT INTO mieNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","De nī jēhe ndá dē tutū jā ní ntee Isaías, tēe nī nacani tūhun Yāā Dios janahán. De nī nacune yā tutū, de nī nanihīn yā nūū yósō iin tūhun, nī ncahvi yā: ");
INSERT INTO mieNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu maá Jētohō ō Yāā Dios íyó yā jíín nī, chi nī ntee yā tiñu nduhū jā nacani nī tūhun vāha nūū ndá nchivī ndāhví. De nī ntají yā nduhū vāji nī jíín tūhun jā nduvāha inī nchivī cúcuécá inī. De cachī tūhun nī nūū nchivī jā yíhí ndahá tāchī jā coo libre ji. De sāhá nī jā ndunijīn inī ánō nchivī jāá nduú jícūhun inī, de scácu nī nchivī jā ndóho ji sáhá táhán ji. ");
INSERT INTO mieNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","De nacani nī tūhun jā ní nquenda tiempo jā sāhá Jētohō ō Yāā Dios jā váha nchivī. Cáchī tutū jā ní ncahvi yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","De nī nacasī yā tutū, de nī nacuāha yā nūū tēe sátíñú inī sinagoga, de nī nūcundeē yā jā stéhēn yā tūhun nūū nchivī íyó inī sinagoga. De ndihi ji ndéhé vāha ji nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","De nī nquijéhé yā cáhān yā jíín ndá ji: Mitan de nī nquee ndaā tūhun cáhān tutū īī yáhá, nī jini ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","De ndiviī ji nī jetúhún ji yā, de sáhvi inī ndá ji níni ji ndācá tūhun viī jā cáhān yā. De nī jīcā tūhún táhán ji: ¿A nsūú sēhe José cúu tēe yáhá? ");
INSERT INTO mieNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","De nī ncāhān yā jíín ndá ji: Jínī vāha nī jā jáni inī ndá nú de suni cāhān nū tūhun yátá yáhá jíín nī: Tēe tátán, sāhá tátán nú maá nú túsaá. De tūhun yáhá cáchī jā tá cúu nūū ní nasāhá vāha nī cuāhā nchivī cúhū inī ñuū Capernaum nī nīhīn nū tūhun, suni súcuán cúnī nū jā sāhá nī ñuū ō yáhá, tácua candíja ndá nú jáni inī nū, ncachī yā jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","De nī ncāhān cā yā: Ndāā cáhān ni jíín ndá nú, ni iin ndá tēe nácani tūhun Yāā Dios, chi nduú jétáhví nchivī ñuū maá dē nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","De suni ndāā cáhān ni jíín ndá nú jā ní īyo cuāhā ñahan jā ní nquendōo ndáhví inī nación maá ó Israel, tiempo jā ní īyo Elías, tēe nī nacani tūhun Yāā Dios. De tiempo ñúcuán nduú ní ncúun cuitī sāvī ūnī cuīyā yósāva, de nī īyo iin tāmā xéēn níí cáhnú nación. ");
INSERT INTO mieNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","De nduú ní ntájí Yāā Dios Elías quīhīn dē nūū ni iin ñahan viuda nación maá ó Israel, chi sa nūū iin ñahan viuda jā ndéē ñuū Sarepta ndáñúū Sidón, nī jēhēn dē nī jito dē jā ní nchajī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","De inī nación maá ó Israel suni nī īyo cuāhā tēe nī ndoho cuēhē stéhyū, tiempo jā ní īyo Eliseo, tēe nī nacani tūhun Yāā Dios. De ni iin tēe ñúcuán nduú ní ncándíja dē jā nduvāha dē sāhá Eliseo, chi sa Naamán, tēe nación Siria, nī nduvāha, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ñúcuán de ndá nchivī ndéē inī sinagoga, nī nquītī ndasí inī ji jā ní jini ji tūhun cáhān yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","De nī nacuiñī ndá ji, de nī ntavā ji yā yātā ñúū, de cuāhān ji jíín yā xīnī yūcú nūū íyó ñuū ji, chi cúnī ji jā chindahá ji yā nincava yā cava ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Sochi nduú ní ncúu sāhá ji, chi nī nchāha yā-ni māhñú ji cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ñúcuán de cuāhān Jesús ñuū Capernaum región Galilea. De quīvī nátātú nī stéhēn yā tūhun nūū ndá nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","De nī nsāhvi inī ji nī jini ji tūhun stéhēn yā. Chi stéhēn vāha yā nūū ji, chi maá yā ndíso tíñú sīquī ndihi. ");
INSERT INTO mieNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","De inī vehe sinagoga íyó iin tēe jā ñúhún tāchī inī dē, de nī ncana cóhó dē: ");
INSERT INTO mieNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Cujiyo ní. ¿Nūcu vāji ní nūū ndá sá, Jesús tēe ñuū Nazaret? ¿A vāji ní jā snáā ní ndá sá, á naá cúu? Ja jínī sá ní iin cúu ní, chi Sēhe īī Yāā Dios cúu ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","De Jesús nī ncāhān xēēn yā nūū tāchī: Casī yuhú nú de quee nú inī tēe yáhá, ncachī yā. De nī jicó cáva-ni tēe ñúcuán nūū ndá nchivī, nī nsāhá tāchī. De nī nquee-ni inī dē cuāhān, de nduú nā cuá ní nsáhá cā jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","De ndihi nchivī nī nchūhú ji, de nī ncāhān ji jíín táhán ji: ¿Nā tūhun cúu yáhá jā ní ncuu súcuán? Chi cúñáhnú tēe yáhá jā ndácu nīhin dē nūū ndá tāchī, de quée-ni cuāhān, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","De tūhun yā nī jītē nuu níí cáhnú región ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ñúcuán de nī nquee Jesús inī vehe īī sinagoga, de cuāhān yā nī nquenda yā vehe Simón. De naná chíso Simón yíhí ndasí quīji ña. De nī ncāhān ndāhví ndá dē jíín yā jēhē ña. ");
INSERT INTO mieNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","De nī jaquīn núū yā nūū ña, de nī ncāhān yā jā ná ndíco quīji. De nī nquee-ni quīji ña, de nī nacōo ña-ni, de nī nsāhá ña jā ní nchajī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","De tá nī nquēe ncandiī, de ndá nchivī jā íyó táhán ji jā cúhū ndācá nūū cuēhē, nī nquisiáha ndá ji nūū yā. De nī ntee yā ndahá yā iin iin ji, de súcuán nī nasāhá vāha yā ji. ");
INSERT INTO mieNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","De suni cuāhā nchivī nī nquee tāchī inī ji, de cána cóhó ndá tāchī: Maá ní cúu Sēhe Yāā Dios, cáchī. De nī ncāhān xēēn yā nūū ji, de nduú ní jéhe yā tūhun cāhān cā ji súcuán, chi ja jínī ndá ji jā maá yā cúu Cristo, Yāā jā ní ntají Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","De tá nī ntūu, de nī nquee yā cuāhān sīín yā yātā ñúū nūū nduú nchivī. De ndá nchivī nánducú ji yā, de nī nquenda ji nūū íyó yā. De jécani ji yā tácua mā cújiyo yā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","De nī ncāhān yā jíín ji: Suni cánuú jā nacani nī tūhun vāha nūū ndá cā ñuū sīquī nāsa tátúnī Yāā Dios, chi suu cúu jā ní ntají yā nduhū vāji nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","De nī jica nuu yā níí región Galilea, nī nacani yā tūhun inī ndá vehe īī sinagoga. ");
INSERT INTO mieNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","De iin quīvī de íñí Jesús yuhú mar Genesaret. De nī nquenda cuāhā nchivī, nī nchitú nīhin ji nūū yā, chi cúnī ji cunini ji tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","De nī jinī yā jā íñí ūū barco ñatin yuhú mar. De ndá tēe tíin tiacá, ja nī nquee dē inī barco, náquete dē ñunu dē. ");
INSERT INTO mieNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","De nī nquīvi yā inī iin barco jā cúu barco Simón. De nī ncāhān yā jíín dē jā ná scáca yátá dē quīhīn jacū cā ichi ínī ndute. De nī jēcundeē yā, de jondē inī barco nī stéhēn yā tūhun nūū nchivī cuāhā jā íyó ji yuhú ndúté. ");
INSERT INTO mieNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","De tá nī jīnu nī stéhēn yā, de nī ncāhān yā jíín Simón: Scáca barco nū ná cóhōn nūū cūnú ndute, de squée ndá nú ñunu nú, de tiin nú tiacá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","De nī ncāhān Simón: Maestro, níí niñū nī squée ndá sá ñunu jā tiin sá tī, de nduú ní níhīn cuitī sá ni iin tī. De jā cáchī maá ní, de ná squée tucu sá ñunu, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","De nī squée ndá dē, de nī nquīvi cuāhā ndasí tiacá, chi jondē ndúcú tēhndē ñunu dē. ");
INSERT INTO mieNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","De nī nsāhá ndahá ndá dē nūū ndá cā táhán dē jā ñúhún inī incā barco, jā ná quíji chindeé táhán jíín dē. De nī nquenda ndá dē, de nī nchuhun chitú ndá dē tī ndúū barco, de jondē ndúcú quēe barco. ");
INSERT INTO mieNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","De nī jinī Simón Pedro jā súcuán nī ncuu. De nī jēcuīñī jītí dē nūū Jesús, de nī ncāhān dē: Vāha cā cujiyo ní Señor, chi tēe íyó cuāchi cúu sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chi maá dē jíín ndá tēe íyó jíín dē, nī nchūhú dē jā ní nīhīn cuāhā dē tiacá nī nsāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","De suni nī nchūhú Jacobo jíín Juan, ndúū sēhe Zebedeo, chi tēe chíndeé táhán jíín Simón cúu ndúū dē. De nī ncāhān Jesús jíín Simón: Mā cúyūhú nú, chi jondē mitan de sāhá nī jā nīhīn nū cuāhā nchivī jā candíja nduhū, tá cúu nūū ní nīhīn nū cuāhā tiacá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ñúcuán de tá nī nenda ndá dē jíín barco nūū ñuhun yíchí, de nī sndóo ndá dē ndihi ndatíñú dē, de nī jēcuniquīn dē yā cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ñúcuán de íyó Jesús inī iin ñuū, de nī nquenda iin tēe jā ndóho cuēhē stéhyū. De nī jinī dē nūū Jesús, de nī jēcuīñī jītí dē nī ntuu dē nūū dē nūū ñūhún, de nī ncāhān ndāhví dē jíín yā: Señor, jínī sá jā cuu nasāhá vāha ní sāán de tú cúnī ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ñúcuán de nī ntee yā ndahá yā dē, de nī ncāhān yā: Cúnī ni nasāhá vāha nī ndóhó, de ná ndúvāha nú, ncachī yā. De tá nī ncāhān yā súcuán, de nī nduvāha-ni tēe ndóho cuēhē stéhyū. ");
INSERT INTO mieNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","De nī ndacu yā nūū dē jā má cāchí cuitī dē nūū ni iin. De nī ncāhān yā: Quīstéhēn nū maá nú nūū sūtū, de cundahá nú jā sōcō nū nūū Yāā Dios sīquī jā ní ndundoo nú nūū yā, tá cúu nūū ní ntatúnī Moisés janahán. De súcuán de cunī nchivī jā ní nduvāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sochi víhí cā nī jītē nuu tūhun yā cuāhān. De nī ncutútú cuāhā nchivī jā cunini ji tūhun jā stéhēn yā, jíín jā nasāhá vāha yā ji nūū ndācá cuēhē jā ndóho ji. ");
INSERT INTO mieNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sochi maá yā chi cuāhān sīín yā nūū nduú nchivī, de nī jīcān táhvī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","De iin quīvī de stéhēn yā tūhun, de jacū tēe grupo fariseo jíín tēe stéhēn ley janahán, ndéē ndá dē ñúcuán. De nī nquenda dē nūū yā jā váji dē ndācá ndáñúū Galilea, jíín ndáñúū Judea, jíín ciudad Jerusalén. De poder maá Yāā Dios íyó jíín yā jā násāhá vāha yā nchivī cúhū. ");
INSERT INTO mieNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ñúcuán de nī nquenda jacū tēe, de ndíso ndá dē iin tēe nī nduvehlé, yósō dē nūū iin camilla. De ndúcú ndá dē squívi dē tēe ñúcuán inī vehe jā caquīn dē nūū íyó yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","De nduú ní níhīn ndá dē modo jā quīvi dē jíín tēe ñúcuán, chi íyó chitú nchivī. De nī ncaa ndá dē sīquī vēhé, de nī nacune dē teja. De nī scúun dē tēe cúhū jíín camilla dē jondē nūū íyó Jesús māhñú nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","De nī jinī Jesús jā cándíja ndá dē jā cuu nasāhá vāha yā tēe cúhū. De nī ncāhān yā jíín tēe cúhū: Lílū, ja née cáhnú inī ni nūū ndá cuāchi nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ñúcuán de ndá tēe stéhēn ley janahán jíín tēe grupo fariseo, nī nquijéhé ndá dē jáni inī dē sīquī yā: ¿Ní iin cā cúu tēe yáhá jā cáhān dē tūhun nāvāha jā quītī inī Yāā Dios? Chi nduú cā nā incā cuu cune cáhnú inī nūū cuāchi, chi mátúhún-ni Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","De nī jinī Jesús jā súcuán jáni inī ndá dē, de nī ncāhān yā: ¿Nūcu jáni inī ndá nú jā cáhān ni tūhun nāvāha? ");
INSERT INTO mieNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","De jā ndúū tūhun yáhá, ¿ní iin cúu jā víjín cā? ¿A jā cāhān ni jíín tēe cúhū: Née cáhnú inī ni nūū ndá cuāchi nú? ¿A víjín cā jā cāhān ni: Nacōo de caca nú, chi ja nī nduvāha nú, cachī ni? ");
INSERT INTO mieNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","De mitan de ná stéhēn ni jā maá nī, Yāā nī nduu tēe, ndíso tíñú nī inī ñayīví yáhá jā cune cáhnú inī ni nūū cuāchi. Sá de nī ncāhān yā jíín tēe nī nduvehlé: Cáhān ni jíín nú, nacōo de naquehen nú camilla nū de quīnohōn nū vehe nú, ncachī yā jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","De nī nacōo-ni tēe ñúcuán, nī jinī jínúū nchivī. De nī naquehen dē camilla jā ní nchosō dē, de cuānohōn dē vehe dē. De nácuetáhví dē nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","De nī nsāhvi ndasí inī ndācá nchivī nī jinī ji, de nī ncāhān ndá ji jā vāha ndasí Yāā cúu Yāā Dios. De suni yúhú ndasí ji de cáhān ji: Mitan de nī jinī ō tiñu ñáhnú ndasí, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ñúcuán de nī nquee yā cuāhān yā, de nī jinī yā nūū iin tēe stútú xūhún renta, nání dē Leví, ndéē dē nūū nástútú dē xūhún renta. De nī ncāhān yā jíín dē: Cuniquīn nduhū ná cóhōn, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","De nī nacuiñī dē, de nī sndóo dē ndihi ndatíñú dē, de cuāhān dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sá de nī nsāhá Leví iin vico cáhnú inī vehe dē jā cúsiī inī dē jíín Jesús. De cuāhā tēe stútú xūhún renta jíín sava cā tēe, ndéē ndá dē mesa yájī dē stāā jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","De ndá tēe grupo fariseo jíín tēe stéhēn ley janahán, nī nquijéhé ndá dē cáhān dē sīquī ndá tēe scuáha jíín yā, de nī jīcā tūhún dē: ¿Nūcu yájī ndá nú jíhi ndá nú jíín ndá tēe stútú xūhún renta jíín ndá cā tēe sáhá cuāchi? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","De nī ncāhān Jesús: Ndá nchivī íyó vāha, nduú jíni ñúhún ji tēe tátán, chi nchivī cúhū cúu jā jíni ñúhún. ");
INSERT INTO mieNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","De nduhū chi nduú vāji nī jā cana nī nchivī jāá nduú cuāchi, jā cúu ji tá cúu nchivī íyó vāha. Chi sa vāji nī jā cána nī nchivī íyó cuāchi, jā ná nácani inī ji de sndóo ji cuāchi ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ñúcuán de nī ncāhān ndá dē jíín yā: Ndá tēe scuáha jíín Juan, jíín ndá tēe scuáha jíín grupo fariseo, cuāhā vuelta íyó nditē inī dē de jícān táhvī dē. De ndá tēe scuáha jíín maá ní, ¿nūcu nduú sáhá dē súcuán? Chi yájī ndá dē jíhi dē. ");
INSERT INTO mieNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","De nī ncāhān yā jíín dē: ¿A cuu conditē inī dē juni íyó cā ni jíín dē? ¿A cuu sāhá nú jā conditē inī nchivī íyó vico tándāhá juni ndéē tēe tándāhá jíín ji? ");
INSERT INTO mieNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sochi quiji quīvī jā cujiyo tēe tándāhá, de quīvī ñúcuán chi conditē inī ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","De suni nī ncāhān yā iin tūhun yátá sīquī jāá nduú quétáhán tūhun jeé jā stéhēn yā jíín ndá tūhun janahán. Ncachī yā: Ni iin nchivī nduú jéhndē ji iin pedazo sahma jéé, de nachuhun ji nūū iin sahma túhú. Chi tú súcuán, de stíví ji sahma jéé, de suni nduú quétáhán jā jēé jíín jā tūhú. ");
INSERT INTO mieNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","De nduú ni iin chúhun vino jeé inī ñii túhú. Chi tú súcuán, de vino jeé ndatá ñii, de naā vino jíín ñii. ");
INSERT INTO mieNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chi sa cánuú jā chuhun ji vino jeé inī ñii jéé, de súcuán de quendōo vāha ndúū. ");
INSERT INTO mieNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","De nchivī chi nduú cúnī ji sndóo ji tūhun janahán, modo jāá nduú cúnī ji coho ji vino jeé, chi jā tūhú cúu jā váha cā, jáni inī ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","De iin quīvī nátātú nī nchāha Jesús cuāhān yā nūū cáá trigo. De ndá tēe scuáha jíín yā nī jehndē dē xīnī trigo, de nī ncavā ndāhá dē, de nī nchajī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","De sava tēe grupo fariseo nī ncāhān dē: ¿Nājēhē cúu jā sáhá ndá nú tiñu jāá nduú íyó vāha jā sāhá nú quīvī nátātú, cáchī ley Moisés? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","De nī ncāhān Jesús jíín dē: ¿A nduú ní ncáhvi ndá nú tutū nāsa nī nsāhá David iin quīvī jā ní jīhī dē sōco jíín ndá tēe jā ní īyo jíín dē? ");
INSERT INTO mieNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","De nī nquīvi dē inī vehe Yāā Dios. De nī nquehen dē pan īī jā yósō nijīn nūū Yāā Dios. De nī nchajī dē, de suni nī jēhe dē nī nchajī ndá tēe íyó jíín dē. De nduú nā ley jā cajī ni iin tēe, chi maá-ni ndá sūtū cúu jā yájī. De vísō súcuán de nduú nā cuāchi ní íyo sīquī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","De nī ncāhān cā yā jíín dē: Nduhū, Yāā nī nduu tēe, maá nī cúu jā tátúnī sīquī nāsa sāhá nchivī quīvī nátātú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","De incā quīvī nátātú suni nī nquīvi yā inī vehe īī sinagoga, de nī stéhēn yā tūhun. De ñúcuán íyó iin tēe nī nchīchī ndahá cuáhá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","De ndá tēe stéhēn ley janahán jíín tēe grupo fariseo, ndéhé yuhū dē yā tú nasāhá vāha yā tēe ñúcuán quīvī nátātú, tácua nīhīn dē cuāchi sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","De maá yā chi jínī yā nāsa jáni inī ndá dē. De nī ncāhān yā jíín tēe nī nchīchī ndahá: Nacuiñī de cuiñi nú māhñú yáhá, ncachī yā. De nī nacuiñī dē, de nī jēcuīñī dē māhñú. ");
INSERT INTO mieNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ñúcuán de nī ncāhān yā jíín ndá dē: Jícā tūhún nī ndá nú iin tūhun: ¿Nāsa cáhān ley sīquī quīvī nátātú? ¿A jā sāhá vāha ó, á jā sāhá nēhén ó? ¿A jā nasāhá vāha ó nchivī ja ñatin cuū, á sāhá ó jā cuū ji? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","De ndéhé yā nūū ndá dē jā íñí dē níí xiín yā, de nī ncāhān yā jíín tēe cúhū: Scáā ndahá nú, ncachī yā. De nī scáā dē, de nī nduvāha-ni ndahá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","De ndá tēe ñúcuán nī nquītī ndasí inī dē, de nī nquijéhé ndá dē nátúhún dē sīquī Jesús, nāsa cahnī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","De nī ncuu jacū quīvī, de nī nquee yā cuācācān táhvī yā yucu. De níí niñū nī jīcān táhvī yā nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","De tá nī ntūu, de nī ncana yā ndá tēe scuáha jíín yā. De nī nacāji yā ūxī ūū dē, de nī ncachī yā jā cuu ndá dē apóstol, chi cundiso tíñú dē jā nacani dē tūhun yā. ");
INSERT INTO mieNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","De yáhá cúu síví ndá dē: Simón jā ní nascúnaní yā dē Pedro, jíín ñanī dē Andrés, de saá-ni Jacobo jíín Juan, Felipe jíín Bartolomé, ");
INSERT INTO mieNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo sēhe Alfeo, Simón tēe grupo cananista, ");
INSERT INTO mieNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ñanī Jacobo, jíín Judas Iscariote, tēe jā ní nastúu dē yā. ");
INSERT INTO mieNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","De nī nuu yā yucu jíín ndá tēe ñúcuán jā scuáha jíín yā, de nī jencuiñī yā iin nduhā jíín dē. De cuāhā nchivī níí región Judea jíín ciudad Jerusalén, jíín nchivī jondē yuhú mar ñuū Tiro jíín ñuū Sidón, nī nquenda ndá ji jā cunini ji tūhun stéhēn yā, jíín jā nduvāha ji cuēhē ndóho ji. ");
INSERT INTO mieNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","De ndācá nchivī jā ñúhún tāchī inī, suni nī nduvāha ji nī nsāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","De ndiviī nchivī cúnī ji jā quehé ji yā, chi súcuán ndúvāha ji sáhá yā jíín poder yā. ");
INSERT INTO mieNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","De nī nūcūndēhé yā nūū ndá tēe scuáha jíín yā, de nī ncāhān yā: Nācā ndetū ndá ndóhó jā ndóho ndáhví, chi quīvi nú ñuū nūū tátúnī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nācā ndetū ndá nú jā jíhī nū sōco mitan, chi quiji quīvī jā ndahā chījin nú. Nācā ndetū ndá nú jā jácu nú mitan, chi quiji quīvī jā cuācū nū. ");
INSERT INTO mieNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nācā ndetū ndá nú de tú quítī inī nchivī nūū nū jā síquī nduhū, Yāā nī nduu tēe, de tú squéne yichī ji ndóhó, de tú cáhān nāvāha ji nūū nū, de cáhān ji jā nchivī sáhá tiñu néhén cúu ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","De sāhá sīī nū inī nū quīvī jā sáhá ji súcuán, de sa víhí cā cusiī inī nū, chi cáhnú ndasí coo tāhvī nū jondē andiví. Chi suni súcuán nī nsāhá ūhvī ndá tatā ji ndá tēe nī nacani tūhun Yāā Dios jondē janahán. ");
INSERT INTO mieNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","De nācā xēēn cundoho ndá nú nchivī cuīcá, chi mitan-ni cúu jā íyó sīī inī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nācā xēēn cundoho ndá nú jā ní ndahā chījin nú mitan, chi quiji quīvī jā cuū nū sōco. Nācā xēēn cundoho ndá nú jā jácū nū mitan, chi quiji quīvī jā nducuécá inī nū de cuacu nú. ");
INSERT INTO mieNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nācā xēēn cundoho ndá nú jā jétúhún ndá nchivī ndóhó, chi suni súcuán nī jetúhún ndá tatā ji ndá tēe nī nacani tūhun stáhví jondē janahán. ");
INSERT INTO mieNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","De cáhān ni jíín ndá nú jā níni: Cundáhví inī nū ndá nchivī jā jínī ūhvī ndóhó, de sāhá vāha nú jíín nchivī jā quítī inī jínī ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","De cācān nū jā váha cuu nchivī jā cáhān nāvāha sīquī nū, de cācān táhvī nū jēhē nchivī jā cáhān nēhén nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","De tú ní tēe cani dē iin lado cūñu nuū nū, de vāha cā suni cuāha nú incā lado cani dē, nsūú cā jā nacuāha nú jā ndutahvī dē. De tú ní tēe cúnī dē candeē dē sōō nū, de suni cuāha nú tūhun jā quíhīn dē jíín jondē camisa nū. ");
INSERT INTO mieNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","De nā-ni nchivī jícān nūū nū de cuāha nú nūū ji. De nchivī quéhen ndatíñú nú, de mā nácān nū. ");
INSERT INTO mieNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","De tá cúu nūū cúnī nū jā sāhá vāha nchivī jíín nú, suni súcuán sāhá vāha nú ji. ");
INSERT INTO mieNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","De tú íyó mānī nū jíín maá-ni nchivī jā mānī jíín nú, ¿de nā tiñu váha cúu jā sáhá nú súcuán túsaá? Chi jondē ndá tēe sáhá cuāchi, suni íyó mānī dē jíín tēe íyó mānī jíín maá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","De tú sáhá vāha nú jíín maá-ni nchivī jā sáhá vāha jíín maá nú, ¿de nā tiñu váha cúu jā sáhá nú súcuán túsaá? Chi jondē ndá tēe sáhá cuāchi, suni súcuán sáhá ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","De tú cuāha núú nú nūū maá-ni nchivī jā ñúhún inī nū jā nacuāha ji nūū nū, ¿de nā tiñu váha cúu jā sáhá nú súcuán túsaá? Chi jondē ndá tēe sáhá cuāchi, suni jéhe núú dē nūū ndá cā tēe sáhá cuāchi, tácua nanihīn tucu dē. ");
INSERT INTO mieNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Túsaá de cundáhví inī ndá nú nchivī jā jínī ūhvī ndóhó, de sāhá vāha nú ji, de cuāha núú nú nūū ji. De mā cuáha nú maá sīquī jā cani inī nū jā suni nacuāha ji nūū nū. De súcuán de cáhnú coo tāhvī nū, de stéhēn nū jā cúu nú sēhe Yāā cúñáhnú ndasí. Chi maá yā vāha inī yā jíín nchivī jāá nduú nácuetáhví nūū yā jíín nchivī jā sáhá nēhén. ");
INSERT INTO mieNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Túsaá de cundáhví inī nū nchivī, tá cúu nūū cúndáhví inī maá Tatá nú nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mā cáhān ndá nú sīquī cuāchi nchivī nāsa sáhá ji, tácua suni mā cáhān Yāā Dios cuāchi sīquī nū jā sáhá nú súcuán. Mā cáhān xēēn nū sīquī ji jāá nduú vāha sáhá ji, tácua suni mā cáhān Yāā Dios súcuán sīquī nū. Cune cáhnú inī nū nūū ji, de suni cune cáhnú inī yā nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cuāha nú nūū nchivī, de suni súcuán cuāha Yāā Dios nūū nū. Chi vāha ndasí cuāha yā nūū nū, chi modo jā chicuāha vāha yā, quisi yā, sāhá nīhin yā, de jondē scáa yā cuāha yā nūū nū. Chi medida jā jéhe ndá nú nūū nchivī, suni medida ñúcuán cuāha yā nūū nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","De nī ncāhān yā iin tūhun yátá jíín ji: Ndá tēe jā stéhēn tūhun jāá nduú ndāā, cúu dē tá cúu tēe cuáá. De iin tēe cuáá, ¿á cuu stéhēn dē ichi nūū incā tēe cuáá? ¿A nduú nincava ndúū dē inī xēhvā? ");
INSERT INTO mieNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Iin tēe scuáha, nduú cúñáhnú dē nūū maestro dē. De tēe scuáha, tá ja nī ncutūha vāha dē, de jīnū dē cuu dē tá nūū cúu maestro dē. ");
INSERT INTO mieNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","De cuāchi táhán nú cúu modo jā ñúhún iin yācá lúlí tīnūú ji. ¿De nūcu sáhá nú cuenta jā súcuán, de nduú sáhá nú cuenta cuāchi maá nú jā cúu modo jā ñúhún iin vītū tīnūú máá nú? ");
INSERT INTO mieNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿De nūcu cáhān ndá nú jíín táhán nú: Cundetu, de ná távā ni yācá jā ñúhún tīnūú nú, de nduú sáhá nú cuenta jā ñúhún iin vītū tīnūú máá nú? Tēe stáhví-ni cúu ndá nú túsaá. Xihna cā tīnūú máá nú tavā nū vītū, sá de cuu cūndēhé vāha nú jā tavā nū yācá tīnūú táhán nú. ");
INSERT INTO mieNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nduú íyó ñutun váha jā jéhe jāvíxī nēhén, de ni nduú íyó ñutun néhén jā jéhe jāvíxī vāha. ");
INSERT INTO mieNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chi jíín jāvíxī jā jéhe iin iin ñutun de jínī ō tú ñutun váha cúu. Chi nduú cándeē ō higo xīnī ñutun íñú, de ni nduú cándeē ō uva xīnī yūcū zarza. ");
INSERT INTO mieNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","De saá-ni cúu tēe vāha, chi cáhān dē tūhun váha, chi vāha ánō dē. De tēe nēhén cáhān dē tūhun nēhén, chi cánēhén ánō dē. Chi nāsa íyó ánō nchivī, de cúsá ñúcuán cúu jā cáhān ji. ");
INSERT INTO mieNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Nājēhē cúu jā cáhān yíñúhún ndá nú jíín nī: Jētohō sá, cáchī nū, de nduú squíncuu ndá nú tiñu jā ndácu nī? ");
INSERT INTO mieNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ndācá nchivī jā váji nūū ni de níni ji tūhun cáhān ni de squíncuu ji, ná stéhēn ni nūū nū nāsa cúu ji: ");
INSERT INTO mieNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Cúu ji tá cúu iin tēe jā ní jaquīn dē vehe dē, de nī jete cúnú dē jondē nī nīhīn dē toto, de nī nchisó dē sīquī. De tá nī ndaa ndute yúte, de nī nchindahá vehe ñúcuán, de nduú ní ncándā cuitī sāhá, chi sīquī toto yósō. ");
INSERT INTO mieNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sochi ndá nchivī jā jíni tūhun jā cáhān ni, de nduú squíncuu ji, cúu ji tá cúu iin tēe jā ní jaquīn dē vehe dē nūū ñūhún, de nduú yítuu jēhē. De tá nī ndaa ndute yúte, de nī nchindahá vehe ñúcuán, de nī scócáva-ni, de nī naā ndihi-ni vehe, ncachī yā jíín ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","De tá nī jīnu nī ncāhān yā nī jini nchivī, de cuāhān yā ñuū Capernaum. ");
INSERT INTO mieNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","De iin tēe nación Roma jā cúu capitán, íyó iin mozo dē jā mānī ndasí dē jíín. De mozo ñúcuán cúhū ji de ja ñatin cuū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","De nī jini capitán tūhun Jesús. De nī ntají dē jacū tēe ñáhnú jā ndácu nūū nchivī hebreo, cuāhān dē nūū yā jā cāhān ndāhví dē jíín yā jā ná quíji yā nasāhá vāha yā mozo dē. ");
INSERT INTO mieNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","De nī nquenda ndá tēe ñúcuán nūū Jesús, de nī ncāhān ndāhví ndasí dē jíín yā: Chindeé ní tēe cúu capitán, chi tēe vāha cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Chi mānī dē jíín nación maá ó, de maá dē nī ndacu tiñu jā ní ncuvāha iin vehe īī sinagoga jā cuu ndācá ó, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ñúcuán de cuāhān Jesús jíín ndá dē. De tá nī ncuñatin yā vehe capitán, de nī ntají dē jacū amigo dē cuātahān dē yā. De nī ncāhān ndá dē jíín yā: Cáchī capitán jāá nduú cúnī dē jā sāhá téñú dē ní, Señor, chi nduú cúñáhnú dē jā quíhīn ní quīvi ní vehe dē. ");
INSERT INTO mieNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jā ñúcuán nduú ní nsáhá ñáhnú dē maá dē jā quiji dē nūū ní, cáchī dē. De maá jā cāhān ní-ni, de ná ndúvāha mozo dē, cáchī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Chi maá dē suni ndíso tíñú dē nī nsāhá ndá tēe cúñáhnú cā. De cúñáhnú dē nūū ndá soldado dē, cáchī dē. De tú cāhān dē jíín iin tēe jā ná quíhīn dē, de cuāhān dē. De tú cāhān dē jíín incā tēe jā ná quíji dē, de quíji dē. De tú ndácu dē iin tiñu nūū mozo dē, de sáhá ji, cáchī dē, ncachī ndá tēe ñúcuán jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","De tá nī jini Jesús tūhun yáhá, de nī nsāhvi inī yā. De nī ndicó cóto yā, de nī ncāhān yā jíín ndá nchivī cuāhā jā níquīn yātā yā: Ndāā cáhān ni jíín ndá nú jā juni nación maá ó Israel, nduú ní níhīn ni ni iin nchivī jā cándíja nīhin súcuán, tá cúu nūū cándíja tēe yáhá, vísō tēe nación jāá nduú jínī tūhun Yāā Dios cúu dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","De ndá tēe jā ní ntají capitán nūū yā, nī nenda ndá dē vehe, de nī jinī dē ja nī nduvāha mozo ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ñúcuán de cuāhān yā iin ñuū nání Naín. De ndá tēe scuáha jíín yā, jíín nchivī cuāhā, suni cuāhān ji jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","De tá nī ncuñatin yā yuhú ñúū, de ñúcuán nī nquee nchivī jā quíchuhū ji iin tēe suchí jā ní jīhī. De mátúhún ji-ni nūū naná ji, de ñahan viuda cúu ña. De cuāhā nchivī ñuū ñúcuán vāji jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","De tá nī jinī maá Jētohō ō nūū ña, de nī ncundáhví inī yā ña, de nī ncāhān yā jíín ña: Mā cuācú ní, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ñúcuán de nī jīnū yā jondē nūū ndīyi, de nī ntiin yā jātūn. De nī jencuiñī ndá tēe ndíso. De nī ncāhān yā jíín sūchí jā ní jīhī: Cáhān ni ndóhó, nacōo lílū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ñúcuán de nī nūcundeē-ni sūchí jā ní jīhī, de nī nquijéhé ji nácahān ji. De nī nasiáha yā ji nūū naná ji. ");
INSERT INTO mieNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","De ndiviī nchivī nī nchūhú ji nī jinī ji, de nī ncāhān ji jā vāha ndasí Yāā cúu Yāā Dios. De cáhān ji: Māhñú ndācá ó nī nquenda iin tēe cúñáhnú jā nácani tūhun Yāā Dios. De suni cáhān ji: Maá Yāā Dios nī nquijéhé yā chíndeé yā nchivī yā, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","De nī jītē nuu tūhun yā níí cáhnú región Judea jíín ndācá región ñatin ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","De yíhí Juan vecāa, de ndá tēe scuáha jíín dē nī ncachī tūhun nūū dē jā súcuán nī ncuu ndá tiñu yáhá. ");
INSERT INTO mieNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","De nī ncana Juan ūū tēe scuáha jíín dē, de nī ntají dē tēe ñúcuán cuāhān dē nūū Jesús, tácua cātūhún dē yā tú maá yā cúu ndija Cristo jā ní ncachī Yāā Dios jā tají yā, á jā cundetu dē quiji incā tēe cuu Cristo. ");
INSERT INTO mieNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","De nī nquenda ndúū dē nūū yā, de nī ncāhān dē: Juan tēe scuénduté nī ntají dē ndúū sá vāji sá cātūhún sá ní tú maá ní cúu Cristo jā cáchī tutū jā quiji, á cundetu ó incā tēe jā quiji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","De maá hora ñúcuán nī nasāhá vāha yā cuāhā nchivī cúhū, jíín nchivī ndóho ndá cuēhē xēēn, jíín nchivī ñúhún tāchī inī. De suni cuāhā nchivī cuāá, nī ndunijīn tīnūú ji nī nsāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","De nī ncāhān yā jíín ndúū dē: Cuáhán de cachī tūhun nú nūū Juan ndācá tiñu jā ní jinī nū jíín jā ní jini nú. De cachī nū jā nchivī cuāá núne tīnūú ji, de nchivī cojo nácaca ji, de nchivī ndóho cuēhē stéhyū ndúvāha ji, de nchivī sōhó núne sōho ji, de nchivī jíhī nátecū ji sáhá nī. De suni nácani nī tūhun nūū nchivī ndāhví jā scácu Yāā Dios ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","De nācā ndetū tēe jā má nácani yátá inī dē jā nduhū cúu Cristo. Súcuán cachī nū nūū Juan, ncachī yā jíín ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","De tá cuānohōn ndúū tēe jā ní ntají Juan, de nī nquijéhé Jesús cáhān yā tūhun Juan jíín nchivī: ¿Nā cuá cúu jā ní jēndēhé ndá nú nūū ñuhun tíhá? ¿A iin tēe jáni iin jáni ūū inī jā cúu tá cúu itē jā cándā sáhá tāchī? ");
INSERT INTO mieNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","De tú nduú, ¿de nā cuá cúu jā ní jēndēhé ndá nú túsaá? ¿A iin tēe jā cúnī cuñáhnú jā ñúhún sahma fino? Nduú, chi jínī ndá nú jā ndá tēe ñúhún sahma fino de ndúcú ndācá jā cúsiī inī, níí maá-ni inī vehe rey ndéē ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿De nā cuá cúu jā ní jēndēhé ndá nú túsaá? ¿A iin tēe nácani tūhun Yāā Dios? Cáhān ni jíín nú jā suu nī jēndēhé nú. De cúñáhnú cā Juan yáhá nsūú cā ndá cā tēe jā ní nacani tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Chi tūhun Juan cúu jā yósō nūū tutū īī: Tají nī tēe nacani tūhun nī, cosō nūú dē ichi núū Cristo, tácua coo tūha nchivī jā quenda yā. Ncachī Yāā Dios, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","De cáhān ni jíín ndá nú jā inī ñayīví yáhá cúñáhnú cā Juan tēe scuénduté nsūú cā ndá cā tēe jā íyó inī ñayīví. De vísō súcuán de ndá nchivī jā núu cā inī ñuū nūū tátúnī Yāā Dios, cúñáhnú cā ji nsūú cā Juan, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","De ndācá nchivī jíín ndá tēe stútú xūhún renta, tá nī jini ji tūhun cáhān yā, de nī jetáhví ji jā Yāā ndāā cúu Yāā Dios, chi ja nī jenduté ji nūū Juan. ");
INSERT INTO mieNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sochi ndá tēe grupo fariseo jíín tēe stéhēn ley janahán, nduú ní jétáhví dē tūhun jā cúnī Yāā Dios sāhá yā jā váha dē, chi nduú ní jénduté ndá dē nūū Juan. ");
INSERT INTO mieNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","De nī ncāhān cā maá Jētohō ō: Yáhá cáchī ni iin tūhun yátá tácua cunī ndá nú nāsa íyó nchivī tiempo mitan. ");
INSERT INTO mieNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cúu ji tá cúu ndá sūchí lúlí jā ndéē ji nūū yáhvi cásíquí ji. De cána jee ji nūū táhán ji: Nī ntivī ndá nī tūyōó nūū ndá nú, de nduú ní jíta jéhé nú. De nī jita ndá nī yaā jā cuécá jíta, de nduú ní jácu nú, cáchī ndá ji. De tá cúu ndá sūchí ñúcuán jāá nduú ní jétahān inī ji ni iin ni incā, súcuán cúu ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Chi nī nquiji Juan tēe scuénduté, de cuāhā vuelta nī īyo nditē inī dē, chi nduú ní nchájī dē stāā de nduú ní jíhi dē vino. De nduú ní jétahān inī ndá nú, chi nī ncāhān nū jā ñúhún tāchī inī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","De nī nquenda maá nī, Yāā nī nduu tēe, de yájī ni jíhi nī, de suni nduú jétahān inī ndá nú, de scáa nú cā chi cáhān nū jā maá-ni jā yájī ni jíhi nī vino. De quétáhán nī jíín ndá tēe stútú xūhún renta jíín ndá cā tēe sáhá cuāchi, cáchī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","De tú cúndíchí iin tēe jíín tūhun Yāā Dios, de jíín tiñu sáhá dē de jínī ndá cā tēe ndíchí jā ndíchí dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","De iin tēe grupo fariseo nī ncana dē Jesús jā cajī yā stāā jíín dē. De nī jēhēn yā vehe dē, de nī jēcundeē yā mesa jā cajī yā stāā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ñúcuán de iin ñahan sáhá cuāchi, ndéē ña ñuū ñúcuán, de nī jinī ña jā ní jīnū Jesús vehe tēe fariseo, yájī yā stāā. De nī nquiji ña jíín iin frasco yūū luu jā ñúhún chitú aceite perfume. ");
INSERT INTO mieNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","De nī jēcuīñī jītí ña nūū jéhē yā, de jácu ña. De nī nquijéhé ña sáchíi ña jēhē yā jíín ndute tínūú ña, de nī nasíchī ña jíín ixi xínī ña. De nī ntechuhú ña jēhē yā, de nī nchihi ña perfume. ");
INSERT INTO mieNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","De tēe fariseo jā ní ncana dē yā, nī jinī dē jā súcuán nī nsāhá ña, de nī jani inī dē: Tú tēe nácani tūhun Yāā Dios cúu tēe yáhá, de cunī dē nāsa ñahan cúu ñahan yáhá jā quéhé ña dē, chi ñahan sáhá cuāchi cúu ña, jáni inī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ñúcuán de nī ncāhān Jesús jíín dē: Simón, cúnī ni cāhān ni jíín nú iin tūhun. De nī ncāhān maá dē: Cāhān ní Maestro. ");
INSERT INTO mieNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","De nī ncāhān Jesús: Iin tēe jéhe núú xūhún, nī īyo ūū tēe ndíta nūū dē. Iin dē ndíta ūhūn ciento xūhún jā nání denario, de incā dē ndíta ūū xico ūxī denario. ");
INSERT INTO mieNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","De nduú nā cuá névāha ndúū tēe ñúcuán jā nachunáá dē. De tēe jéhe núú xūhún nī nee cáhnú inī dē nūū ndúū tēe ñúcuán. Túsaá de cachī nū: Jā ndúū tēe ñúcuán, ¿ní iin dē cúu jā coo manī cā jíín dē? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","De nī ncāhān Simón: Jáni inī sá jā tēe nī ndita cuāhā cā, ncachī dē. De nī ncāhān yā: Ndāā cáhān nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","De ndéhé yā nūū ñahan ñúcuán, de nī ncāhān cā yā jíín Simón: ¿A ndéhé nú tá sáhá ñahan yáhá? Jā ní nquenda nī vehe nú, de nduú ní jéhe nú ndute jā ndundoo jēhē ni, tá cúu nūū íyó costumbre. De ñahan yáhá nī nsāhá chíi ña jēhē ni jíín ndute tínūú ña, de nī nasíchī ña jíín ixi xínī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","De nduú ní ntéchuhú nú nduhū, tá cúu nūū íyó costumbre. De ñahan yáhá, jondē nī nquīvi nī vehe nú, de nduú jéncuiñī ña jā téchuhú ña jēhē ni. ");
INSERT INTO mieNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","De nduú ní nchíhi nú aceite xīnī ni, tá cúu nūū íyó costumbre. De ñahan yáhá nī nchihi ña aceite perfume jēhē ni. ");
INSERT INTO mieNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Túsaá de cáhān ni jíín nú jā ní stéhēn ña jā ndasí íyó mānī ña jíín nī sīquī jā née cáhnú inī ni nūū ndācá cuāchi ña, vísō cuāhā cúu. Sochi tú née cáhnú inī ni nūū nchivī jā íyó jacū-ni cuāchi, de jacū-ni stéhēn ji jā mānī ji jíín nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","De nī ncāhān yā jíín ña: Ja née cáhnú inī ni nūū ndācá cuāchi nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ñúcuán de ndá nchivī yájī stāā jíín yā, nī nquijéhé ndá ji cáhān ji: ¿Ní iin cā cúu tēe yáhá jā cáhān dē jā née cáhnú inī dē nūū cuáchi? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sochi Jesús nī ncāhān cā yā jíín ñahan ñúcuán: Nī ncandíja nú nduhū, de jā ñúcuán cúu jā ní scácu nī ndóhó nūū cuáchi nú. Cuáhán de ndusiī inī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ñúcuán de nī ncuu jacū quīvī, de nī jica nuu Jesús ndācá ñuū nāhnú jíín ñuū lulí. De nácani yā tūhun vāha, de cáchī yā nāsa tátúnī Yāā Dios. De ndihúxī ūū tēe cúu apóstol, suni jíca dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","De suni íyó jacū ñahan jíca jíín yā, jā ní ntavā yā tāchī inī sava ña, de nī nasāhá vāha yā sava ña jā ndóho cuēhē. De iin ña cúu María ñuū Magdala, de inī ñahan ñúcuán nī ntavā yā ūjā tāchī. ");
INSERT INTO mieNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","De incā ña cúu Juana, ñasíhí Chuza, tēe ndíso tíñú inī vehe Herodes. De incā ña cúu Susana, jíín cuāhā cā ñahan jā chíndeé ña yā jéhe ña ndācá jā jíni ñúhún yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","De cuāhā nchivī ndācá ñuū ñúcuán nī nquenda ji nūū Jesús. De nī ncutútú cuāhā ndasí nchivī, de nī ncāhān yā iin tūhun yátá nūū ndá ji: ");
INSERT INTO mieNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Iin tēe jítē tatā, nī nquee dē jā cutē dē. De tá nī nquijéhé dē jítē dē, de jacū tatā nī jītē yuhú íchí, de nī jāñū nchivī sīquī, de nī nchajī-ni ndá saā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","De jacū cā nī jītē nūū ñuhun yúū. De nī ntāhvī, de nī nchīchī-ni, chi nduú íyó cuāhā cōhyo. ");
INSERT INTO mieNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","De jacū cā tatā nī jītē māhñú nūū cáá niquin iñu. De iin nuú-ni nī ntāhvī iñu jíín, de nī jasī nūū. ");
INSERT INTO mieNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","De sava nī jītē nūū ñuhun váha. De tá nī ntāhvī, de nī jēhe cuāhā nūnī, chi iin iin tatā nī jēhe jondē ciento, ncachī yā. Ñúcuán de nī ncāhān jee yā: Ndá ndóhó jā níni, tee sōho vāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","De ndá tēe scuáha jíín yā nī jīcā tūhún dē yā nā cuá cáchī tūhun yátá yáhá. ");
INSERT INTO mieNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","De nī ncāhān yā: Ndá ndóhó, chi sáhá Yāā Dios jā cuu jīcūhun inī nū tūhun jā ní nchiyuhū yáhá, nāsa quívi nchivī ndahá Yāā Dios jā tatúnī yā nūū ji. Sochi sava cā nchivī chi maá-ni jíín tūhun yátá cáhān ni jíín ji, tácua vísō ndéhé ji de quéndōo ji modo jāá nduú jínī ji. De vísō jíni jíín sóho ji, de mā jícūhun inī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","De súcuán cúu jā cáhān tūhun yátá yáhá: Tatā ñúcuán cúu tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","De tatā jā ní jītē yuhú íchí cúu tá cúu ndá nchivī jā jíni tūhun, sochi quénda-ni tāchī cúñáhnú, de cándeē tūhun inī ánō ji, tácua mā cándíja ji de mā cácu ji sāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","De tatā jā ní jītē nūū ñuhun yúū cúu tá cúu ndá nchivī jā jíni tūhun, de jétáhví ji de cúsiī inī ji jíín. Sochi nduú cúcutú tūhun inī ánō ji, de jacū-ni quīvī cándíja ji. De tá quiji tūndóhó sīquī ji, de jíca yátá ji. ");
INSERT INTO mieNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","De tatā jā ní jītē māhñú niquin iñu cúu tá cúu nchivī jíni tūhun, de cuāhān ndá ji de cútéñú ji jíín tiñu ji de cúnī ji cucuícá ji de cusiī inī ji. De nduú jíja ji jíín tūhun yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","De tatā jā ní jītē nūū ñuhun váha cúu tá cúu ndá nchivī jíni tūhun, de tíin vāha ji, chi íyó vāha íyó ndāā ánō ji. De jíja ji jíín tūhun yā, chi cándíja vāha ji. ");
INSERT INTO mieNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tá scuíquīn nchivī iin lámpara, de nduú jásī ji ni iin sīquī, de ni nduú chíhi ji chījin jīto. Chi sa jáni ji nūū sūcún, tácua cutūu nūū ndá nchivī jā quívi vehe. ");
INSERT INTO mieNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","De suni súcuán, nduú íyó ni iin tūhun yíyuhū jā má cūní nchivī, chi ndihi-ni tūhun jā cáhān ji natūu nijīn de cunī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Túsaá de cunini vāha ndá nú, chi nchivī ja jícūhun inī, stéhēn cā yā nūū ji. Sochi nchivī jāá nduú cándíja, chi maá jacū jā jáni inī ji jā jínī ji, de sa naā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ñúcuán de nī nquenda naná yā jíín ndá ñanī yā nūū íyó yā. De nduú ní ncúu quīvi ndá ña nūū yā, sīquī jā íyó chitú nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","De nī ncachī tūhun iin nchivī nūū yā: Naná ní jíín ndá ñanī ní íñí ña tāvēhé, de cāhān ña jíín ní cúnī ña, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","De nī ncāhān maá yā: Suni naná nī jíín ñanī ni cúu ndá nchivī níni tūhun Yāā Dios de squíncuu ji, ncachī yā jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","De iin quīvī nī nquīvi yā iin barco jíín ndá tēe scuáha jíín yā, de nī ncāhān yā jíín dē: Ná yáha ó cōhōn incā lado mar. De nī scáca ndá dē barco cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","De juni scáca dē barco de nī nquīxīn yā. De nī jīquīhi iin tāchī níhin nūū mar. De ja ñatin chitú ndute inī barco, de ndúcú quēe barco. ");
INSERT INTO mieNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","De nī sndóto ndá dē yā, de nī ncāhān dē: Maestro, Maestro, mitan de quēe ó chījin ndute de naā ō, ncachī dē. De nī nacuiñī yā, de nī ncāhān yā nūū tāchī níhin jíín nūū mar. De ndihi nī jencuiñī, de nī ncuu nañíí-ni. ");
INSERT INTO mieNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","De nī ncāhān yā jíín ndá tēe scuáha jíín yā: ¿Nūcu nduú cándíja ndá nú? De ndá máá dē chi nī nchūhú ndasí dē, de sáhvi inī dē, de cáhān dē jíín ndá táhán dē: ¿Ní iin cā cúu tēe yáhá jā jondē nūū tāchī níhin jíín nūū ndūté tátúnī dē, de jétáhví jā cáhān dē? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ñúcuán de nī nquenda yā jíín ndá dē región Galilea, de cuāhān yā región Gadara jā íyó incā lado mar Galilea. ");
INSERT INTO mieNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","De tá nī nuu yā nūū ñuhun yíchí, de iin tēe ñuū ñúcuán nī nquenda dē nūū yā. De ja nī ncuu cuāhā cuīyā jā ñúhún cuāhā tāchī inī dē. De nduú ñúhún cuitī dē sahma, de ni nduú ndéē dē vehe, chi sa māhñú nūū yíyuhū ndīyi ndéē dē. ");
INSERT INTO mieNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","De tá nī jinī dē nūū Jesús, de nī jēcuīñī jītí dē nūū yā, de nī ncana cóhó dē: ¿Nūcu vāji ní nūū sá, Jesús Sēhe Yāā Dios, Yāā cúñáhnú ndasí? Cáhān ndāhví sá jíín ní jā má sndóho ní sāán. ");
INSERT INTO mieNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Súcuán nī ncāhān dē, chi ja nī ndacu yā nūū ndá tāchī jā ná quée inī dē. De ja nī ncuu cuāhā vuelta jā ní nsāhá xēēn tāchī dē. De nī nuhnī ndahá dē jēhē dē jíín cadena nī nsāhá nchivī, tácua nduú nā cuá sāhá dē. De ndihi-ni jéhndē dē, de jínu dē jéhēn dē nūū ñuhun tíhá sáhá ndá tāchī. ");
INSERT INTO mieNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","De Jesús nī jīcā tūhún yā dē: ¿Nā cuá nāní nú? De nī ncāhān dē: Legión nání sá. De nī ncāhān dē jā súcuán nání dē, chi ñúhún cuāhā tāchī inī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","De nī ncāhān ndāhví ndá tāchī ñúcuán jíín yā jā má tājí yā ji cundasī ji maá yavī cūnú ndasí. ");
INSERT INTO mieNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","De yucu ñúcuán íyó cuāhā quinī jítu tī. De ndá tāchī nī ncāhān ndāhví jíín yā jā ná cuáha yā tūhun quīvi ndá inī quinī. De nī jēhe yā tūhun. ");
INSERT INTO mieNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","De nī nquee ndá tāchī inī tēe ñúcuán, de nī nquīvi inī quinī. De ndá quinī nī jinu tī nī nincava tī iin yuhú cává, de nī nquēe tī inī mar, de nī jīhī tī nūū ndūté. ");
INSERT INTO mieNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","De ndá tēe jíto tī, nī jinī dē jā súcuán nī ncuu, de nī nchūhú ndá dē. De nī jinu dē cuācachī tūhun dē nūū ndá nchivī ñuū jíín ndá rancho. ");
INSERT INTO mieNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","De nī jēhēn ndá nchivī nī jēndēhé ji nāsa nī ncuu. De nī nquenda ji nūū íyó Jesús. De nī jinī ji nūū tēe jā ní nquee ndá tāchī inī, ndéē dē nūū jéhē Jesús, de ñúhún dē sahma, de ja nī nducájí xīnī dē. De nī nchūhú ndá nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","De ndá tēe jā ní jinī, nī nacani dē tūhun nūū nchivī, nāsa nī ncuu jā ní nduvāha tēe jā ní ñuhun tāchī inī. ");
INSERT INTO mieNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ñúcuán de ndá nchivī níí región Gadara, nī nquijéhé ji cáhān ndāhví ji jíín yā jā ná cújiyo yā quīhīn yā, chi yúhú ndasí ji. De nī ndīvi yā inī barco jā quínohōn yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","De tēe jā ní nquee tāchī inī, nī ncāhān ndāhví dē jíín yā jā cuāha yā tūhun quīhīn dē jíín yā. Sochi Jesús nī ncāhān yā jā ná quéndōo dē, de ncachī yā: ");
INSERT INTO mieNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Cuánohōn vehe nú, de nacani nú tūhun nāsa ñáhnú ndasí tiñu nī nsāhá Yāā Dios ndóhó, ncachī yā jíín dē. De cuāhān dē, de nī nacani dē tūhun níí ñuū ñúcuán jā nāsa ñáhnú ndasí tiñu nī nsāhá Jesús jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","De tá nī nenda Jesús incā lado mar, de ndá nchivī nī ncusiī inī ji jā ní nenda yā, chi ndihi ji ndétu ji yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","De nī nquenda iin tēe cúñáhnú inī vehe īī sinagoga, nání dē Jairo. De nī jēcuīñī jītí dē nūū jéhē yā, de nī ncāhān ndāhví dē jā ná quíhīn yā jíín dē vehe dē. ");
INSERT INTO mieNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Chi íyó iin sēhe síhí dē jā mátúhún ji-ni nūū dē, de íyó ji tá ūxī ūū cuīyā. De sūchí ñúcuán ja ñatin cuū ji. De cuāhān yā jíín dē, de cuāhā nchivī níquīn ji yā, de nī nchitú nīhin ji níí xiín yā cuāhān ji. ");
INSERT INTO mieNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","De māhñú ndá nchivī cuāhān iin ñahan cúhū, de ja nī ncuu ūxī ūū cuīyā ndóho ña cuēhē játi nīñī ña. De nī jāxīn ña ndihi jā névāha ña jíín tēe tátán, de nduú ní ndúvāha ña sāhá ni iin dē. ");
INSERT INTO mieNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","De nī nquenda ña ichi chátā Jesús, de nī nquehé ña yuhú sáhmá yā. De nī jencuiñī-ni jā játi nīñī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ñúcuán de nī ncāhān Jesús: ¿Ní iin nī nquehé sahma nī? ncachī yā. De ndiviī ji nī ncāhān jāá nduú ní nquéhé ji. De Pedro jíín ndá tēe íyó jíín dē, nī ncāhān dē: Maestro, ndéhé ní jā nchivī cuāhā yáhá nī nchitú nīhin ji xiín ní, de cáquīhi ji níhín, de mitan jícā tūhún ní ní iin nī nquehé sahma ní. ");
INSERT INTO mieNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","De nī ncāhān Jesús: Nduú chi iin nchivī nī nquehé sahma nī, chi nī jinī ni jā jíín fuerza ni de nī nduvāha iin nchivī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","De nī jinī ñahan ñúcuán jāá nduú ní ncúu coo yuhū jā ní nsāhá ña. De quísi ña nī nquenda ña, de nī jēcuīñī jītí ña nūū jéhē yā. De jínī jínúū ndá nchivī, de nī ncachī cājí ña nājēhē cúu jā ní nquehé ña yuhú sáhmá yā, jíín jā ní nduvāha ña-ni. ");
INSERT INTO mieNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","De nī ncāhān yā jíín ña: Tíhī, nī ncandíja nú jā cuu nasāhá vāha nī ndóhó, de jā ñúcuán nī nduvāha nú. Cuáhán de ndusiī inī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","De juni cáhān cā yā súcuán, de nī nquenda iin tēe ndéē vehe Jairo, tēe cúñáhnú inī vehe īī sinagoga. De nī ncachī dē nūū Jairo: Ja nī jīhī sēhe síhí ní. De mā sátéñú ní cā Maestro, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","De nī jini Jesús tūhun yáhá, de nī ncāhān yā jíín Jairo: Mā cúyūhú nú, chi candíja nú-ni, de nastécū ni sēhe nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","De nī jīnū yā vehe, de nduú ní jéhe yā tūhun jā quīvi ndá nchivī jíín yā, chi maá-ni Pedro jíín Jacobo jíín Juan, jíín tatá naná sūchí ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","De cúcuécá inī ndá nchivī ndéē inī vehe, de jácu ji jēhē sūchí ñúcuán. Sochi nī ncāhān yā: Mā cuācú ndá nú. Chi ñahan lúlí ñúcuán nduú ní jíhī ji, chi quíxīn ji-ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","De nī jācū catá ndá ji jā ní ncāhān yā, chi jínī ji jā ní jīhī sūchí ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","De nī ntiin yā ndahá ji, de nī ncāhān jee yā jíín ji: Tíhī, nacuiñī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","De nī natecū ji de nī nacuiñī ji-ni. De nī ndacu yā jā ná cuáha ndá jā cajī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","De nī nsāhvi ndasí inī tatá ji naná ji ndéhé dē. De nī ndacu nīhin yā nūū dē jā má cāchí dē nūū ni iin jā súcuán nī ncuu. ");
INSERT INTO mieNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","De nī nastútú Jesús ndihúxī ūū tēe scuáha jíín yā, de nī nsāhá yā jā cundiso tíñú dē de coo poder dē jā tavā dē ndá tāchī inī nchivī, jíín jā nasāhá vāha dē nchivī cúhū. ");
INSERT INTO mieNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","De nī ntají yā ndá dē jā nacani dē tūhun nāsa tátúnī Yāā Dios, jíín jā nasāhá vāha dē nchivī cúhū. ");
INSERT INTO mieNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","De nī ncāhān yā jíín dē: Mā cuīsó nú jā cuetíñú nú ichi, ni garrote, ni ñunu, ni stāā, ni xūhún. De quīhīn nū jíín iin-ni camisa, de mā cuīsó nú incā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","De nā-ni vehe quīvi ndá nú, de ñúcuán cundeē nū jondē quee tucu nú quīhīn nū incā ñuū. ");
INSERT INTO mieNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","De tú iin ñuū nduú jétáhví ji ndóhó, de quee ndá nú ñúcuán, de scóyo nú tīcāchāā jēhē nū, chi suu cúu jā stéhēn nū jā íyó cuāchi ji jāá nduú ní jétáhví ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","De nī nquee ndá dē cuāhān dē, nī jicó núu dē ndācá ñuū. De nī nacani dē tūhun vāha nāsa scácu Yāā Dios nchivī, de nī nasāhá vāha dē nchivī cúhū. ");
INSERT INTO mieNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","De Herodes, tēe cúu gobernador, nī nīhīn dē tūhun ndācá tiñu jā sáhá Jesús. De nī ncunēhén inī dē, chi jáni inī sava nchivī cáhān ji jā Juan nī natecū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","De sava cā nchivī cáhān jā ní nenda Elías, tēe nī nacani tūhun Yāā Dios janahán. De sava cā ji cáhān jā ní natecū incā tēe nī nacani tūhun Yāā Dios janahán. ");
INSERT INTO mieNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","De nī ncāhān Herodes: Juan chi nī ndacu nī jā tēhndē xīnī dē. ¿Túsaá de nā tēe cúu yáhá jā níhīn ni tūhun jā sáhá dē cuāhā tiñu ñáhnú? ncachī dē. De nī nducú dē modo nāsa cunī dē nūū Jesús. ");
INSERT INTO mieNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","De nī nenda ndá tēe cúu apóstol jā ní ntají yā dē nī nacani dē tūhun. De nī ncachī ndá dē nūū yā ndācá tiñu jā ní nsāhá dē. De nī jeca yā ndá dē cuāhān sīín yā jíín dē iin lugar nūū nduú nchivī, ñatin ñuū Betsaida. ");
INSERT INTO mieNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","De nī jinī ndá nchivī, de suni cuāhān ndá ji. De nī jetáhví yā ji, de nī nacani yā tūhun nāsa tátúnī Yāā Dios, de nī nasāhá vāha yā nchivī cúhū. ");
INSERT INTO mieNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","De tá cuāñini, de nī nquenda ndihúxī ūū apóstol, de nī ncāhān dē jíín yā: Tají ní nchivī cuāhā yáhá ná quíhīn ji ndācá ñuū jíín ndācá rancho ñatin yáhá, de nducú ji nūū quendōo ji de cueen ji jā cajī ji, chi nduú nā cuá īyó yáhá, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","De nī ncāhān Jesús: Cuāha ndá máá nú jā cajī ji, ncachī yā. De nī ncāhān ndá dē: Nduú ná névāha sá, chi ūhūn-ni stāā jíín ūū-ni tiacá. De vísō tú quīcuēen sá stāā cajī ndihi nchivī cuāhā yáhá, de ni mā cūú, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chi íyó tá ūhūn mil tēe. De nī ncāhān yā jíín ndá tēe scuáha: Cāhān ndá nú jíín nchivī jā ná cúndeē sīín cincuenta cincuenta ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","De súcuán nī nsāhá ndá dē, de nī jēcundeē ndihi nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","De nī nquehen yā ndihúhūn stāā jíín ndúū tiacá ñúcuán, de nī nūcūndēhé yā ichi andiví, de xihna cā nī nacuetáhví yā nūū Tatá yā. De nī scuáchi yā, de nī jēhe yā nūū ndá tēe scuáha jíín yā, de nī nsajī dē nūū ndá nchivī cuāhā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","De ndiviī ji nī nchajī, de nī ndahā chījin ji. De nī nastútú ndá dē pedazo jā ní nquendōo, de nī nchitú ūxī ūū tīcá. ");
INSERT INTO mieNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","De iin quīvī nī ncusíín Jesús, jícān táhvī yā, de maá-ni ndá tēe scuáha jíín yā íyó dē jíín yā. De nī jīcā tūhún yā ndá dē: De nduhū, ¿ní iin cúu nī cáchī ndá nchivī? ");
INSERT INTO mieNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","De nī ncāhān ndá dē: Sava ji cáhān jā cúu ní Juan, tēe jā ní scuénduté. De sava cā ji cáhān jā cúu ní Elías, tēe nī nacani tūhun Yāā Dios jondē janahán. De sava cā ji cáhān jā cúu ní incā tēe nī nacani tūhun yā, de nī natecū dē, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ñúcuán de nī jīcā tūhún yā dē: De ndá máá nú, ¿ní iin cúu nī cáchī ndá nú? De nī ncāhān Pedro: Maá ní cúu Cristo, Yāā jā ní ntají Yāā Dios, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ñúcuán de nī ndacu nīhin yā nūū ndá dē jā má cāchí dē tūhun yáhá nūū ni iin nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","De nī ncāhān yā: Nduhū, Yāā nī nduu tēe, cánuú jā ndoho ndasí nī. De ndá tēe ñáhnú jíín ndá sūtū cúñáhnú jíín ndá tēe stéhēn ley janahán, squéne yichī dē nduhū. De cahnī dē nduhū, de nūū únī quīvī de natecū ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ñúcuán de nī ncāhān yā jíín ndihi dē: Nā-ni nchivī tú cúnī ji cuniquīn ji nduhū jā scuáha nī ji, de ná cásī ji jā cúnī maá ji, de ná cúniquīn ji nduhū ndācá quīvī, de cuāha ji tūhun cundoho ji tūndóhó jā síquī ni, vísō ná cúū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chi tú ní nchivī cúnī ji cācu ji nūū tūndóhó jā quiji nūū ji jā síquī nduhū, túsaá de tānū tāhvī ji níí cání. De tú ní nchivī vísō ná cúū ji jā síquī nduhū, sochi cutecū ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Chi ní cuetíñú vísō ná cúndeé nchivī nīhīn ji níí ñayīví, de tú quīvi ji nūū tānū tāhvī ji? ");
INSERT INTO mieNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chi tú nā-ni nchivī cúcanoō ji jā síquī nduhū, Yāā nī nduu tēe, jíín sīquī tūhun cáhān ni, suni súcuán cucanoō ni jā síquī maá ji, quīvī nenda nī. De quīvī ñúcuán chi viī ndasí cuñáhnú nī, tá cúu nūū cúñáhnú Tatá nī, de suni cúñáhnú ndācá ángel ndoo yā sáhá yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","De ndāā cáhān ni jíín ndá nú jā sava tēe íyó yáhá, mā cúū dē chi jondē cunī dē nāsa tátúnī Yāā Dios jíín poder yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ñúcuán de tá ūnā quīvī jā ní ncāhān yā ndá tūhun yáhá, de nī ncaa yā iin yucu, cuācācān táhvī yā. De Pedro jíín Jacobo jíín Juan cuāhān ndá dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","De juni jícān táhvī yā, de tucu nī nduu yā, de sahma yā nī nduyaa ndasí, de jéndūtē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ñúcuán de nī nquenda ūū tēe, nátúhún dē jíín yā, de cúu dē Moisés jíín Elías, tēe jā ní īyo janahán. ");
INSERT INTO mieNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","De viī ndasí jéndūtē níí tēe ñúcuán, de cáhān ndúū dē jíín yā sīquī jā ní ncuñatin jā cuū yā Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","De Pedro jíín ndúū cā tēe íyó jíín dē, jíhī ndasí dē māhná, sochi nduú ní nquíxīn dē. De nī jinī ndá dē jā viī jéndūtē maá yā jíín ndúū tēe íñí jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","De tá nī ncujiyo-ni ndúū tēe ñúcuán nūū yā, de nī ncāhān Pedro jíín yā: Maestro, nācā vāha jā íyó ndá sá yáhá. De ná sáhá ndá sá ūnī vehe ramádā, iin cuu maá ní, de incā cuu Moisés, de incā cuu Elías, ncachī dē. De nduú sáhá dē cuenta nā cuá cúu jā cáhān dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","De juni cáhān dē súcuán, de nī nquiji iin vīcō nūhún, de nī jasī-ni nūū ndá dē. De nī nchūhú ndá dē jā íyó dē chījin vīcō nūhún. ");
INSERT INTO mieNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","De nūū vīcō ñúcuán nī ncāhān iin tūhun: Yáhá cúu Sēhe nī jā mānī ndasí nī jíín. De cunini ndá nú tūhun cáhān yā, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","De tá nī ncuu nī ncāhān tūhun ñúcuán, de mátúhún-ni cā Jesús íñí yā nūū ndá dē. De nduú ní ncáhān cuitī cā ndá dē, de ndá quīvī ñúcuán nduú ní ncáchī dē nūū ni iin jā súcuán nī jinī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","De quīvī téēn nī nuu yā jíín ndá dē yucu. De cuāhā nchivī nī jētahān ji yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","De māhñú nchivī cuāhā nī ncana jee iin tēe: Maestro, jícān táhvī sá nūū ní jā cūndēhé ní sēhe yií sá, chi mátúhún ji-ni íyó nūū sá. ");
INSERT INTO mieNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","De maá-ni jā sáhá xēēn tāchī jíín ji, de cána cóhó ji sáhá, de jáhnī yīhí ji, de jée tīñū yuhú ji. De sndóho ji, de ūhvī ndasí siáā ji. ");
INSERT INTO mieNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","De nī ncāhān ndāhví sá jíín ndá tēe scuáha jíín ní jā ná távā dē tāchī, de nduú ní ncúu sāhá dē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ñúcuán de nī ncāhān Jesús: Nchivī nīhin ndasí inī cúu ndá nú, chi nduú cándíja nú jā cuu nduvāha ji. ¿Nāsaa cā quīvī cundeē ni jíín ndá nú jā cuandeé inī ni jíín nú? Cuáquēhen sēhe nú ná quíji ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","De juni vāji ji nūū yā, de nī jicó cáva ji nūū ñūhún nī nsāhá tāchī, de nī jahnī yīhí ji. De nī ncāhān xēēn Jesús nūū tāchī, de nī nasāhá vāha yā sūchí ñúcuán, de nī nasiáha yā ji nūū tatá ji. ");
INSERT INTO mieNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","De ndiviī nchivī nī nsāhvi inī ji nī jinī ji jā ñáhnú ndasí tiñu sáhá Yāā Dios. De juni sáhvi inī ji ndéhé ji ndācá tiñu jā ní nsāhá Jesús, de nī ncāhān yā jíín ndá tēe scuáha jíín yā: ");
INSERT INTO mieNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Chuhun vāha inī nū tūhun cáhān ni yáhá, de mā náā inī nū, chi nduhū, Yāā nī nduu tēe, nastúu ji nduhū jā quīvi nī ndahá ndá tēe xēēn. ");
INSERT INTO mieNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sochi nduú ní jícūhun inī ndá dē jā ní ncāhān yā, chi nduú ní ncúu cuitī jīcūhun inī dē. De nī nchūhú ndá dē cātūhún dē yā sīquī tūhun jā ní ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ñúcuán de ndá tēe scuáha jíín yā nī nquijéhé dē cáhān dē sīquī ní iin dē cúñáhnú cā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","De nī jinī Jesús jā súcuán jáni inī ndá dē. De nī ntiin yā ndahá iin sūchí lúlí, de nī jani yā ji xiín yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","De nī ncāhān yā jíín ndá dē: Nā-ni nchivī tú jā síquī nduhū jétáhví ji sūchí lúlí yáhá, de nduhū jétáhví ji. De nchivī jā jétáhví nduhū, suni jétáhví ji Yāā jā ní ntají nduhū vāji nī. De nchivī núu cā māhñú ndá nú, suu ji cúñáhnú cā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ñúcuán de nī ncāhān Juan: Maestro, nī jinī ndá sá iin tēe jā jíín síví ní távā dē tāchī inī nchivī. De nī jasī ndá sá jā sáhá dē, chi nduú jíca dē jíín ó, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","De nī ncāhān Jesús jíín dē: Mā cásī nū jā sáhá dē, chi tēe jāá nduú cáhān contra sīquī ō, íñí dē jíín ó, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","De nī ncuñatin quīvī jā quínohōn yā andiví, de nī jani téyíí inī yā jā quíhīn yā Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","De nī ntají yā sava tēe nī jēcōsō nūú dē jíín tūhun jā váji yā. De cuāhān ndá dē iin ñuū Samaria tácua nducú dē nūū quendōo yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sochi nchivī Samaria nduú ní jéhe ji vehe ndōo yā, chi nī jinī ji jā jondē Jerusalén quīhīn yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","De Jacobo jíín Juan, ndúū tēe scuáha jíín yā, nī jinī dē jā súcuán cúu, de nī ncāhān dē jíín yā: Señor, ¿á cúnī ní jā ndacu ó tiñu jā quiji ñuhūn ichi andiví, de naā nchivī yáhá, tá cúu nūū ní nsāhá Elías, tēe nī nacani tūhun janahán? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ñúcuán de nī ndicó cóto Jesús nūū ndúū dē, de nī ncāhān yā nūū dē: Nduú jínī ndá nú nā nūū vāji tūhun cáhān nū. ");
INSERT INTO mieNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chi nduhū, Yāā nī nduu tēe, nduú vāji nī jā snáā ni nchivī, chi sa vāji nī jā scácu nī nchivī, ncachī yā. Sá de cuāhān yā jíín ndá dē incā ñuū. ");
INSERT INTO mieNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","De juni jíca ndá dē jíín yā ichi, de nī ncāhān iin tēe jíín yā: Señor, cuniquīn sá ní cōhōn ní-ni cúu nūū quíhīn ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","De nī ncāhān Jesús jíín dē: Ndācá xúncuii chi íyó yavī cava tī, de ndá saā suni íyó tacā tī. Sochi maá nī, Yāā nī nduu tēe, nduú nūū cūsūn ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","De nī ncāhān yā jíín incā dē: Cuniquīn nduhū ná cóhōn. De nī ncāhān dē: Señor, cundetu ní de ná quíchuhū sá tatá sá xihna cā, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","De nī ncāhān Jesús jíín dē: Sndóo ndá ndīyi, ná chúhū ndá cā ndīyi, chi ndīyi cúu ndá nchivī jāá nduú cándíja. De maá nú, chi quīhīn nū nacani nú tūhun nāsa tátúnī Yāā Dios, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ñúcuán de suni nī ncāhān incā dē: Señor, cúnī sá cuniquīn sá ní, de cuāha ní tūhun jā xihna ná quícāhān sá jíín nchivī vehe sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","De nī ncāhān Jesús jíín dē: Tú nā-ni tēe quijéhé dē cuniquīn dē nduhū, de tú maá-ni jā nácani cuécá inī dē sīquī ndācá jā ní sndóo dē, túsaá de cúu dē tá cúu iin tēe sátíñú jíín arado, de jícó cóto dē ndéhé dē ichi véhe dē. Túsaá de nsūú tēe vāha cúu dē jā cuniquīn dē nduhū sīquī tiñu tátúnī Yāā Dios, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","De tá nī ncuu ndācá tiñu yáhá, de maá Jētohō ō nī nacāji yā ūnī xico ūxī cā dē. De nī ntají yā ndihuū ndihuū dē jā cosō nūú dē nūū yā quīhīn dē ndācá ñuū jíín ndācá lugar nūū ja ñatin quīhīn maá yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","De nī ncāhān yā: Ndá nchivī yáhá chi cúu ji tá cúu trigo jā tēhndē, de ndāā jā cuāhā cúu, de tēe jā quehndē chi jacū dē-ni cúu. Túsaá de cācān táhvī ndá nú nūū maá Jētohō nū Yāā Dios jā ná tétíñú yā cuāhā tēe quehndē dē trigo, cúu jā nacani dē tūhun yā nūū nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","De cuáhán ndá nú, de ná cáchī tūhun nī nūū nū jā tetíñú nī ndá nú quīhīn nū tá cúu tīcāchí lúlí māhñú yīhī. ");
INSERT INTO mieNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","De mā cuīsó nú ñunu, ni itīn xūhún, ni nījān. De ichi mā cúcuéé nú jā natúhún nú jíín ni iin nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","De nā-ni vehe quīvi ndá nú, de xihna cā cāhān nū: Ná quíji tūhun ndeé tūhun sīī inī nūū ndá nú, nchivī vehe yáhá, cachī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","De tú vehe ñúcuán íyó nchivī vāha, de tūhun ndeé jā ní ncāhān nū jīnū sīquī ji. De tú nduú, de tūhun ndeé jā ní ncāhān nū mā jínū sīquī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","De suni vehe ñúcuán cundeē nū, de cajī nū coho nú jā cuāha nchivī nūū nū. Chi sīquī tiñu jā nácani nú tūhun nūū nchivī, de cánuú coto ji ndá nú. De mā cúndeē nū quéhén vehe, chi iin-ni vehe. ");
INSERT INTO mieNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","De nā-ni ñuū quīvi ndá nú, de tú cuetáhví ji ndóhó, de cajī nū nā-ni cúu jā cuāha ji nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","De nasāhá vāha nú ndá nchivī cúhū ñuū ñúcuán. De cachī nū nūū ji: Ja nī ncuñatin jā tatúnī Yāā Dios nūū ndá nú, cachī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","De nā-ni ñuū quīvi ndá nú, de tú mā cuétáhví ji ndóhó, de quee nú inī calle ñúcuán de cāhān nū: ");
INSERT INTO mieNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Jondē tīcāchāā ñuū ndá nú yáhá jā ní ntīin jēhē ni, ná scóyo nī jā cúu seña jā íyó cuāchi ndá nú jāá nduú ní jétáhví nú. De cunahán ndá nú jā Yāā Dios ja nī ncuñatin yā jā tatúnī yā nūū nū nícu. Cachī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","De cáhān ni jíín ndá nú jā quīvī juicio de xēēn cā coo castigo sīquī ñuū jā sáhá súcuán nsūú cā jā coo sīquī ñuū Sodoma nūū ní nsāhá ndasí nchivī cuāchi. ");
INSERT INTO mieNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nācā xēēn cundoho ndá nú, nchivī ñuū Corazín. De nācā xēēn cundoho ndá nú, nchivī ñuū Betsaida. Chi tú inī ñuū Tiro jíín ñuū Sidón ní nsáhá nī tiñu ñáhnú jā ní nsāhá nī inī ñuū maá nú, de ñamā nacani inī nchivī ñuū ñúcuán jā sndóo ji cuāchi ji nícu. De sāhá ji seña jā stéhēn jā nácani inī ji sīquī cuāchi ji, chi cuhun ji sahma túún de chihi ji yāā xīnī ji nícu. ");
INSERT INTO mieNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Túsaá de quīvī juicio de xēēn cā coo castigo sīquī ndá nú nsūú cā jā coo sīquī ñuū Tiro jíín ñuū Sidón. ");
INSERT INTO mieNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","De ndá ndóhó nchivī ñuū Capernaum, ¿á jáni inī nū jā cúñáhnú nú tá cúu iin jā cáa cuāhān ichi andiví? Nduú chi sa cuun nú quīhīn nū jondē lugar nūū íyó ndá ánō ndīyi, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","De nī ncāhān cā yā jíín ndá tēe jā tají yā quīhīn: Nchivī jā tee sōho tūhun jā cáhān ndá nú, suni tee sōho ji jā cáhān maá nī. De nchivī jā squéne yichī ndóhó, suni nduhū squéne yichī ji. De nchivī jā squéne yichī nduhū, suni squéne yichī ji Yāā jā ní ntají nduhū vāji nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","De nī nenda ndihúnī xico ūxī tēe ñúcuán, de cúsiī inī ndá dē, de cáhān dē jíín Jesús: Señor, jondē ndá tāchī jétáhví ji nūū sá jā jíín síví maá ní, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","De nī ncāhān yā jíín dē: Súcuán cúu, chi nī jinī ni jā modo iin taja nī nincava Satanás ichi andiví, chi nī ncandeē ni ndihi poder. ");
INSERT INTO mieNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","De mitan de ja nī jēhe nī poder nūū ndá nú jā cuāñū nū sīquī ndá cōō jíín tīsuhmā, cúu jā cundeé nú sīquī ndācá fuerza maá jā jínī ūhvī yóhó, de nduú nā cuá sāhá jíín nú. ");
INSERT INTO mieNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sochi mā cúsiī inī ndá nú maá-ni jā jétáhví ndá tāchī nūū nū, chi sa cusiī cā inī nū jā yósō síví nú jondē andiví, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","De suni hora ñúcuán nī ncusiī inī Jesús nī nsāhá Espíritu Santo, de nī ncāhān yā: Ná cútahvī sá nūū ní Tatá, jā cúu ní Jētohō andiví jíín ñayīví. Chi nī jasī ní ndācá tūhun ndíchí ní, jā má cūní nchivī ndīchí jíín nchivī tūha cuenta ñayīví yáhá. De nī stéhēn ní nūū ndá nchivī cúu tá cúu sūchí lúlí. Chi súcuán nī jētahān inī ní Tatá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","De nī ncāhān cā yā: Ndiviī nī jēhe Tatá nī nūū ni. De nduú jínī ndá nchivī ní iin cúu nduhū, Sēhe Yāā Dios, chi maá-ni Tatá nī cúu jā jínī yā nduhū. De ni nduú jínī nchivī nāsa Yāā cúu maá Tatá, chi maá-ni Sēhe cúu jā jínī. De íyó nchivī jā cúnī maá Sēhe stéhēn yā nūū ji nāsa Yāā cúu Tatá yā, de maá ji suni cunī ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ñúcuán de nī ndēhé yā nūū ndá tēe scuáha jíín yā, de nī ncāhān yā jíín ndá máá dē-ni: Nācā ndetū ndá nchivī jā ndéhé tiñu ñáhnú jā ndéhé ndá máá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Chi cáhān ni jíín nú jā cuāhā ndá tēe nī nacani tūhun Yāā Dios, jíín cuāhā ndá rey, nī ncuu inī dē cūndēhé dē jā ndéhé ndá máá nú, de nduú ní jínī dē. De nī ncuu inī dē cunini dē jā níni ndá máá nú, de nduú ní jíni dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ñúcuán de iin tēe stéhēn ley janahán, nī nacuiñī dē, de nī jēcāhān dē jíín Jesús jā coto túnī dē yā. De nī jīcā tūhún dē: Maestro, ¿nā cuá sāhá sá de nīhīn táhvī sá cutecū sá níí cání andiví? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","De nī ncāhān yā jíín dē: ¿Nāsa yósō nūū tutū ley? ¿Nāsa cáhān jā cáhvi nú? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","De tēe ñúcuán nī ncāhān dē nāsa cáhān nūū tutū: Coo manī ndasí nú jíín maá Jētohō nū Yāā Dios, jondē jíín inī jíín ánō nū, jíín níí fuerza nū, jíín níí jāá ntúnī nū. De cundáhví inī nū táhán nú tá cúu nūū cúndáhví inī nū maá nú, cáchī tutū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","De nī ncāhān yā jíín dē: Vāha nī ncāhān nū. De tú cuu sāhá nú súcuán de nīhīn táhvī nū cutecū nū níí cání, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","De tēe ñúcuán cúnī dē jā quendōo ndāā dē nūū yā jíín tūhun jā ní jīcā tūhún dē, de nī ncāhān dē: ¿De ní nchivī cúu ndá táhán sá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ñúcuán de nī ncāhān Jesús: Iin tēe nī nquee dē Jerusalén, nī ncuun dē cuāhān dē ñuū Jericó. De ichi nī nquenda ndá tēe cuíhná nūū dē, de nī ncandeē ndihi ndatíñú dē, de jondē sahma ñúhún dē. De nī ncani nāvāha ndá tēe ñúcuán dē, jondē ja ñatin cuū dē nícu. De nī sndóo ndá, de cuāhān ndá. ");
INSERT INTO mieNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","De ichi ñúcuán nī nchāha iin sūtū cuāhān dē, de nī jinī dē nūū tēe ñúcuán, de nī nsāhá jíyo dē-ni cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","De saá-ni iin tēe grupo levita jā sátíñú inī templo, vāji dē ichi ñúcuán, de suni nī jinī dē nūū tēe ñúcuán, de nī nchāha jícá dē-ni cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","De iin tēe nación Samaria, suni jíca dē ichi ñúcuán. De nī jinī dē nūū tēe ñúcuán, de nī ncundáhví inī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","De nī nquenda dē nūū cáá tēe ñúcuán, de nī nchuhun dē aceite jíín vino nūū ní ntacuēhé, de nī juhnī dē sahma nūū. De nī nchisó dē tēe ñúcuán sīquī quiti dē, de cuāhān dē jíín tēe ñúcuán iin mesón, de nī jito dē. ");
INSERT INTO mieNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","De quīvī téēn, hora jā quíhīn dē, de nī ntavā dē ūū xūhún cāa, de nī jēhe dē nūū tēe xíí mesón, de nī ncāhān dē: Coto ní tēe yáhá, de tú cāxīn ní cā xūhún jíín dē, de tá nenda sá de nachunáá sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Túsaá de nāsa jáni inī nū? Jā ndinúnī tēe ñúcuán, ¿ní iin dē nī nsāhá cuenta jā táhán dē cúu tēe jā ní nquenda jācuīhná nūū? ncachī yā jíín tēe stéhēn ley janahán. ");
INSERT INTO mieNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","De nī ncāhān dē: Tēe jā ní ncundáhví inī tēe jā ní ntacuēhé, vísō tēe ñuū jīcá cúu dē, ncachī dē. Ñúcuán de nī ncāhān Jesús jíín dē: Cuáhán túsaá, de suni súcuán cundáhví inī nū ndācá nchivī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sá de nī nquehen tucu yā ichi cuāhān yā, de nī jīnū yā iin ñuū lulí. De iin ñahan nání Marta nī ncana ña yā nī jēhēn yā vehe ña. ");
INSERT INTO mieNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","De Marta, íyó iin cūhū ña nání María. De María nī jēcundeē ña nūū jéhē Jesús, níni ña ndācá tūhun jā cáhān yā. ");
INSERT INTO mieNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","De Marta chi cútéñú ña jíín cuāhā tiñu sáhá ña. De nī nquenda ña nūū yā, de nī ncāhān ña: Señor, ¿á nduú sáhá ní cuenta jā cūhū sá nī sndóo ña sāán nūū tiñu? De cāhān ní jíín ña ná chíndeé táhán ña jíín sá, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","De nī ncāhān Jesús jíín ña: Marta, nācā ndíhvī ndasí inī nū jíín cuāhā tiñu, de ndasí sndóho nú maá nú jíín. ");
INSERT INTO mieNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","De íyó iin-ni tiñu cánuú. De María chi nī nacāji ña tiñu cánuú, suu jā ndíhvī inī ña sīquī tūhun Yāā Dios, de mā cándeē ō ña nūū tiñu ñúcuán, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","De iin quīvī íyó Jesús iin lugar, jícān táhvī yā. De tá nī ncuu nī jīcān táhvī yā, de iin tēe scuáha jíín yā, nī ncāhān dē: Señor, stéhēn ní nūū ndá sá nāsa cācān táhvī sá, tá cúu nūū ní stéhēn Juan nūū ndá tēe nī scuáha jíín dē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","De nī ncāhān yā jíín ndá dē: Jā cācān táhvī ndá nú, de suha cāhān nū: Tatá ndá sá jā ndéē ní andiví, níní ná cóo yíñúhún sá nūū ní, chi Yāā īī cúu ní. De ñúhún inī sá jā ñamā ná quíji quīvī tatúnī ní níí ñayīví yáhá. De ná cóo ndācá tiñu jā jétahān inī maá ní, tá cúu nūū íyó inī andiví, suni súcuán ná cóo inī ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Stāā jā técū ndá sá ndācá quīvī, cuāha ní nūū sá mitan. ");
INSERT INTO mieNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","De cune cáhnú inī ní nūū cuāchi jā sáhá ndá sá nūū ní, tá cúu nūū née cáhnú inī ndá sá nūū nchivī jā sáhá cuāchi nūū sá. De mā cuáha ní tūhun jā coto túnī tāchī sāán, chi sa scácu ní sāán nūū ndācá jānēhén. Cachī ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","De nī ncāhān cā yā: Tú ní iin nú íyó iin amigo nū, de quīhīn nū vehe dē sava ñuú de cāhān nū jíín dē: Amigo, tanúú nú ūnī stāā nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Chi iin amigo ni jā jíca viaje, nī nquenda dē vehe nī, de nduú nā cuá névāha nī jā cuāha nī cajī dē, cachī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","De cāhān tēe ndéē inī vehe: Mā stáhān nū nduhū, chi ja ndásī viéhé nī, de ja quíxīn ni jíín ndá sēhe nī, de mā cūú nacōo nī jā taji nī nūū nū, cachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","De cáhān ni jíín ndá nú, vísō mā nácōo dē taji dē nūū nū sīquī jā cúu dē amigo nū, sochi sīquī jā stáhān ndasí nú dē, jā ñúcuán nacōo dē taji dē ndihi jā jíni ñúhún nú. ");
INSERT INTO mieNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Túsaá de cáhān ni jíín ndá nú jā suni súcuán cācān táhvī nū nūū Yāā Dios, de taji yā nūū nū. De nducú nú ndācá jā váha jā íyó nūū yā, de nīhīn nū. De cācān táhvī nū jondē nīhīn nū, tá cúu nūū sáhá nchivī jā scáján viéhé jondē nune quīvi ji. ");
INSERT INTO mieNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chi ndācá nchivī jā jícān, cuāha yā nūū ji. De nchivī ndúcú, chi nīhīn ji. De nchivī cáhān, nune yā ichi jā nīhīn ji jā cúnī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿De ní iin nú cúu tatá, de tú sēhe nú jícān ji stāā nūū nū, de á cuāha nú iin yūū nūū ji? De tú jícān ji iin tiacá, ¿de á cuāha nú iin cōō nūū ji? ");
INSERT INTO mieNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","De tú jícān ji iin ndīvī, ¿de á cuāha nú iin tīsuhmā nūū ji? Nduú cuitī jā súcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Túsaá de ndá máá nú vísō nchivī íyó cuāchi cúu nú, de jínī ndá nú cuāha nú jā váha nūū sēhe nú. De nā oncā cúu maá Tatá nú andiví jā má cuáha yā Espíritu Santo nūū nchivī jícān nūū yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","De távā yā iin tāchī inī iin tēe, jā ní ncuñíhín dē nī nsāhá. De tá nī nquee tāchī, de nī nacahān tēe jā ní ncuñíhín. De nī nsāhvi inī ndá nchivī ndéhé ji. ");
INSERT INTO mieNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sochi sava nchivī nī ncāhān ji: Jíín fuerza Satanás jā cúñáhnú nūū ndá tāchī, de távā tēe yáhá ndá tāchī inī nchivī, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","De sava cā ji cúnī ji coto túnī ji yā, de nī jīcān ji jā sāhá yā jā coo iin seña ichi andiví. ");
INSERT INTO mieNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","De maá yā chi jínī yā jā súcuán jáni inī ndá ji, de nī ncāhān yā: Ndācá nación jā sáhá síín maá de cánāá maá, túsaá de snáā jā íyó vāha maá. De tú nchivī iin vehe sáhá síín maá de cánāá maá, de mā cūú cā cundeē cāhnú ji. ");
INSERT INTO mieNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","De saá-ni Satanás, tú sáhá síín maá jíín ndá táhán tāchī, ¿de nāsa cuiñi nīhin jā tatúnī túsaá? Chi cáhān ndá nú jā jíín fuerza Satanás távā ni ndá tāchī. ");
INSERT INTO mieNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","De tú súcuán cúu de ndá nchivī scuáha jíín ndá nú, ¿nā jīín fuerza távā maá ji tāchī? Túsaá de ndá máá ji cachī ji jā ní stíví ndasí nú nī ncāhān nū jā távā ni tāchī jíín fuerza Satanás. ");
INSERT INTO mieNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","De nduú chi jíín fuerza Yāā Dios cúu jā távā ni tāchī. Túsaá de ja ndéē Yāā Dios māhñú ndá nú jā tátúnī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","De tú iin tēe ndacuī jíto dē vehe dē jíín tūjīí dē, túsaá de ni iin ndatíñú dē mā ndóñúhún. ");
INSERT INTO mieNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","De tú quiji incā tēe ndacuī cā, de cundeé jíín tēe ñúcuán, túsaá de candeē tūjīí dē jā jíto dē vehe dē, de sāhá dē nāsa cúnī maá dē jíín ndatíñú jā candeē dē. De tá nūū cúu tēe ndacuī cā ñúcuán, súcuán cúu maá nī nūū Satanás. ");
INSERT INTO mieNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","De nchivī jāá nduú íyó mānī jíín nī, túsaá de jínī ūhvī ji nduhū. De nchivī jāá nduú nástútú jíín nī, túsaá de sa scútē nuu ji nchivī jā váji nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tú nī nquee iin tāchī inī iin tēe jāá nduú cándíja, de jíca nuu nūū ñuhun tíhá, ndúcú nūū natātú, de nduú níhīn, sá de jáni inī maá: Ná quínohōn ni vehe nūū ní nquee nī. ");
INSERT INTO mieNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","De tá nī nenda tucu, de jínī jā tēe jāá nduú cándíja, cúu dē tá cúu iin vehe jā ní ndundoo. ");
INSERT INTO mieNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ñúcuán de jéhēn jénacuēca ūjā cā tāchī nēhén cā nsūú cā maá. De quívi ndá inī tēe ñúcuán de jécundeē ndá. Túsaá de xēēn cā cundoho tēe ñúcuán jā sándīhí nsūú cā jā xíhna ñúhún, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","De juni cáhān yā tūhun yáhá, de iin ñahan íñí māhñú nchivī cuāhā, nī ncāhān jee ña jíín yā: Nācā ndetū ñahan jā ní scácu ña ní de nī scáxīn ña ní, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","De nī ncāhān yā: Sa ndetū ndasí cā ndá nchivī níni tūhun Yāā Dios de squíncuu ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","De nī ntācā cuāhā cā nchivī nūū Jesús, de nī nquijéhé yā cáhān yā: Nchivī tiempo mitan chi maá-ni jā sáhá nēhén ji. De jícān ji iin tiñu ñáhnú jā stéhēn tú Yāā jā ní ntají Yāā Dios cúu nī. De nduú nā incā tiñu ñáhnú stéhēn ni nūū ji, chi maá-ni tiñu ñáhnú tá cúu nūū ní ncuu jíín Jonás, tēe nī nacani tūhun Yāā Dios janahán. ");
INSERT INTO mieNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Chi tá cúu nūū ní jinī nchivī ñuū Nínive jā ní ncuu iin tiñu ñáhnú jíín Jonás, suni súcuán cunī nchivī tiempo yáhá jā coo iin tiñu ñáhnú jíín nduhū, Yāā nī nduu tēe, jā quétáhán jíín modo jā ní ndoho Jonás. ");
INSERT INTO mieNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","De reina jā ní ncuñáhnú nación ichi sur, natecū ña jíín nchivī tiempo yáhá, quīvī juicio jā sāhá ndāā yā cuāchi, de cāhān ña cuāchi sīquī ji. Chi jondē jícá ndasí nī nquiji ña nī nini ña ndá tūhun ndíchí jā ní ncāhān rey Salomón, de nī ncandíja ña. De mitan chi cúñáhnú cā nduhū, Yāā íyó yáhá, nsūú cā Salomón, de nduú cándíja ndá nú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","De ndá nchivī ñuū Nínive nūū ní nacani Jonás tūhun, natecū ji jíín nchivī tiempo yáhá, quīvī juicio jā sāhá ndāā yā cuāchi, de cāhān ji cuāchi sīquī nchivī yáhá. Chi ndá máá ji nī nacani inī ji nī sndóo ji cuāchi ji quīvī jā ní nacani Jonás tūhun nūū ji. De mitan chi cúñáhnú cā nduhū, Yāā íyó yáhá, nsūú cā Jonás, de nduú cándíja ndá nú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tá nástíin nchivī iin lámpara, de nduú chíyuhū ji, ni nduú chíhi ji chījin iin cajón. Chi sa jáni ji nūū sūcún, tácua cutūu nūū ndá nchivī jā quívi vehe. ");
INSERT INTO mieNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","De tīnūú ndá nú cúu tá cúu lámpara nūū yiqui cúñu nú. Túsaá de tú tīnūú nú íyó nijīn, de níí-ni yiqui cúñu nú cunijīn. Sochi tú nduú íyó nijīn tīnūú nú, de níí-ni yiqui cúñu nú íyó neē. ");
INSERT INTO mieNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","De suni súcuán cúu ánō nū, de coto ndá nú jā má cāní nēhén inī nū, tácua mā cōó neē inī ánō nū. ");
INSERT INTO mieNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Chi tú sáhá ndá nú maá-ni tiñu váha, de nduú nā tiñu néhén sáhá nú, túsaá de luz yā cunijīn vāha inī ánō nū, tá nūū cúu iin lámpara jā sáhá jā cúnijīn vāha, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","De tá nī ncuu nī ncāhān yā, de iin tēe grupo fariseo nī ncana dē yā jā cajī yā stāā vehe dē. De nī nquīvi yā, de nī jēcundeē yā mesa jā cajī yā stāā. ");
INSERT INTO mieNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","De tēe fariseo nī nsāhvi inī dē ndéhé dē jāá nduú squíncuu yā costumbre jā nandahá yā de cajī yā stāā. ");
INSERT INTO mieNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","De nī ncāhān maá Jētohō ō jíín dē: Ndá ndóhó tēe fariseo, chi modo jā náquete nú yātā vásō jíín cōhō, cúu jā nándahá nú. De ichi ínī ndá nú chi ñúhún maá-ni tūhun cuíhná jíín tūhun nēhén. ");
INSERT INTO mieNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tēe naā cúu ndá nú. ¿A nduú jínī nū jā Yāā jā ní nsāhá yiqui cúñu nú, suni nī nsāhá yā ánō nū? ");
INSERT INTO mieNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","De jā jéhe ndá nú caridad nūū nchivī ndāhví, de sāhá nú sīquī jā cúndáhví ndija inī nū ji. De súcuán de coo ndaā ánō nū. ");
INSERT INTO mieNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","De nācā xēēn cundoho ndá nú tēe fariseo, chi squíncuu nú ndācá tiñu lúlí, de nduú squíncuu nú tiñu cánuú. Chi sáhá ndá nú ūxī ūxī nuhnī mīnu jíín ruda jíín ndācá yuvā, de sócō nū iin iin jā úxī nūū Yāā Dios. Sochi nduú sáhá cuitī nū tiñu ndāā, ni nduú íyó mānī nū jíín Yāā Dios. Ndācá yáhá cánuú jā sāhá nú nícu, de suni mā sndóo nú jā sōcō nū ndá yūcū ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","De nācā xēēn cundoho ndá nú tēe fariseo, chi jétahān inī nū cundeē nū nūū silla yíñúhún cā inī vehe īī sinagoga, de jétahān inī nū jā cáhān yíñúhún nchivī jíín nú nūū yáhvi. ");
INSERT INTO mieNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","De nācā xēēn cundoho ndá nú tēe stéhēn ley janahán, jíín ndá nú tēe fariseo, chi tēe stáhví-ni cúu nú. Chi cúu nú tá cúu iin yavī ndīyi jāá nduú nijīn, chi snáā nū ánō nchivī, de nduú jínī ji jā súcuán sáhá nú ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","De nī ncāhān iin tēe stéhēn ley janahán: Maestro, jā cáhān ní ndācá tūhun yáhá, de suni sīquī ndá máá sá nī ncāhān ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","De nī ncāhān yā: Suni nācā xēēn cundoho ndá nú tēe stéhēn ley janahán. Chi suni stéhēn nū ndācá ley jā ní ntavā maá nú jā víjín sáhá, de nduú cúndeé nchivī squíncuu ji. De ndá máá nú chi ni iin xīnī ndāhá nú nduú scándā nū jā squíncuu nú. ");
INSERT INTO mieNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nācā xēēn cundoho ndá nú. Chi sáhá ndá nú namā ndá ndīyi tatā nū, tēe nī nacani tūhun Yāā Dios janahán. De suni ndá tatā nū nī jahnī ndá tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","De jā sáhá nú súcuán cúu jā quétáhán nú jíín ndá dē sīquī tiñu jā ní nsāhá dē. Chi ndá máá dē nī jahnī ndá tēe ñúcuán, de ndá máá nú chi sáhá nú namā sīquī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jā ñúcuán cúu jā jondē janahán nī ncāhān Yāā Dios iin tūhun ndíchí: Tají nī ndá tēe nacani tūhun nī jíín ndá tēe cúu apóstol quīhīn dē nūū ndá ji. De sava dē cahnī ji, de sava cā dē cunī ūhvī ji, ncachī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","De súcuán de sīquī nchivī tiempo yáhá ná cúndeē cuāchi jā ní jahnī tatā ji ndá tēe nī nacani tūhun Yāā Dios, jondē tá nī jēcāva ñayīví jíín jondē mitan, ");
INSERT INTO mieNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","jondē Abel jíín jondē Zacarías, tēe jā ní jahnī ndá dē sava māhñú altar jíín cuarto īī inī templo. Túsaá de cáhān ni jíín ndá nú jā sīquī nchivī tiempo mitan cundeē ndācá cuāchi ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nācā xēēn cundoho ndá nú, tēe stéhēn ley janahán, chi jásī nū ichi jā jīcūhun inī nchivī tūhun yā. De ni ndá máá nú nduú cúnī nū jīcūhun inī nū, de ni nduú jéhe nú tūhun jā jīcūhun inī nchivī jā cúnī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","De jā ní ncāhān yā ndá tūhun yáhá, de ndá tēe stéhēn ley janahán jíín ndá tēe fariseo, nī nquītī ndasí inī dē nī jinī dē yā. De nī nquijéhé dē stíchī dē yā sīquī cuāhā cā tūhun. ");
INSERT INTO mieNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","De ndúcú ndá dē modo tú sanaā de stíví yā tūhun cāhān yā, tácua nīhīn dē cuāchi sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","De juni súcuán cúu, de nī ncutútú cuāhā mil nchivī, chi jondē jáñū ji sīquī jéhē táhán ji. De xihna cā nī nquijéhé yā cáhān yā jíín ndá tēe scuáha jíín yā: Coto má cándíja ndá nú levadura ndá tēe grupo fariseo, chi suu cúu tūhun stáhví jā cáhān ndá dē. Chi jítē nuu nūū ndá nchivī tá cúu nūū sndáa levadura ñujan. ");
INSERT INTO mieNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chi ndācá tūhun stáhví mā quéndōo yuhū cuitī, chi ndihi natūu nijīn de cunī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Túsaá de suni ndá ndóhó, ndācá tūhun jā ní ncāhān nū jāá nduú ní jínī nchivī, iin quīvī de cunī vāha ji. De ndācá tūhun jā ní ncāhān yuhū nū jā ndásī viéhé, iin quīvī de cāhān jee nchivī yātā ndācá vehe. ");
INSERT INTO mieNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Cáhān ni jíín ndá nú, amigo: Mā cúyūhú nú nchivī jā cahnī yiqui cúñu nú, chi tá nī jahnī ji ndóhó, de nduú nā cuá cuu cā sāhá ji. ");
INSERT INTO mieNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","De ná cáchī ni nūū nū ní iin cúu jā cuyūhú nú: Jā cuyūhú nú cúu Yāā Dios jā tú sáhá yā jā cuū nū, de íyó poder yā jā chuhun yā ndóhó infierno. Suu maá yā cúu jā cuyūhú nú jā má stíví nú nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","De ndācá saā chi nduú yāhvi ndéē tī, chi jondē ūhūn tī jā úū centavo. De ni iin tī nduú náā inī Yāā Dios jāá nduú jíto yā tī. ");
INSERT INTO mieNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","De nā oncā cúu ndá máá nú, chi jondē ndihi ixi xínī nū ja nī ncahvi yā. Túsaá de mā cúyūhú ndá nú, chi cánuú ndasí cā ndá máá nú nūū yā nsūú cā cuāhā ndá saā. ");
INSERT INTO mieNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","De cáhān ni jíín ndá nú jā ndācá nchivī jā cuetúhún nduhū nūū incā nchivī, de saá-ni nduhū, Yāā nī nduu tēe, cuetúhún nī ji nūū ndá ángel Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","De ndācá nchivī jā má cuétúhún nduhū nūū incā nchivī, suni súcuán mā cuétúhún nī ji nūū ndá ángel Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","De tú nā-ni nchivī cāhān ji sīquī nduhū, Yāā nī nduu tēe, de cune cáhnú inī Yāā Dios nūū ji. Sochi tú nā-ni nchivī cāhān nāvāha ji sīquī Espíritu Santo, de mā cúne cáhnú inī Yāā Dios nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","De tú quīsiáha ndá ji ndóhó ndācá vehe īī sinagoga nūū justicia jíín nūū ndá cā tēe tátúnī, de mā nácani ndasí inī nū nāsa scócóo nú tūhun jíín nāsa cāhān nū. ");
INSERT INTO mieNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chi maá hora ñúcuán de Espíritu Santo stéhēn yā nūū nū nāsa cāhān nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ñúcuán de iin tēe íñí māhñú nchivī cuāhā, nī ncāhān dē jíín Jesús: Maestro, cāhān ní jíín ñanī sá jā ná táhví sáva dē tāhvī ndúū sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","De nī ncāhān yā jíín dē: Lílū, nduú ní jáni yā nduhū jā sāhá ndāā ni tiñu nú jā tahví sáva nī tāhvī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","De nī ncāhān cā yā: Coto vāha ndá nú maá nú jā má cútóó cuitī nū xūhún jíín ndá cā. Chi vísō cuāhā ndasí ndatíñú névāha iin tēe, de nsūú ñúcuán sāhá jā quendōo ndetū dē ñayīví yáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ñúcuán de nī ncāhān yā iin tūhun yátá jíín ji: Nī īyo iin tēe cuícá jā névāha ñuhun jā vāha ndasí cúu itū. ");
INSERT INTO mieNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","De tēe cuícá ñúcuán nī nacani inī dē: ¿Nāsa sāhá nī? Chi nduú cā núne nūū cuhun niñi nī. Ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","De nī jani inī dē: Suha ná sáhá nī: Canī ni ndá yacā ni, de nasāhá nī jā nāhnú cā. De ñúcuán nataān ndihi nī niñi nī jíín ndācá ndatíñú nī. ");
INSERT INTO mieNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ñúcuán de cani inī ni: Mitan de cuāhā ndasí névāha ó jā quenda cuāhā cuīyā. Ná nátātú ó, de cajī ō coho ó, de ná cúsiī inī ō, nī jani inī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Sochi nī ncāhān Yāā Dios jíín dē: Tēe naā cúu nú, chi jacuáā mitan de cuū nū, de ndācá jā ní nchuvāha nú, ¿ní tēe cuu? Ncachī Yāā Dios jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","De suni súcuán cundoho ndācá tēe jā sáhá cuícá dē maá dē, de nduú ndúcú dē jā quendōo ndetū dē nūū Yāā Dios, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","De nī ncāhān yā jíín ndá tēe scuáha jíín yā: Túsaá de cáhān ni jíín ndá nú: Mā nácani ndasí inī nū sīquī jā cutecū nū, tú nāsa cajī nū, ni sīquī sahma nú, tú nāsa cuhun nú. ");
INSERT INTO mieNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Chi Yāā Dios nī nsāhá yā jā técū nū jíín yiqui cúñu nú, de nā oncā cúu jā má cuáha yā jā cajī nū jíín jā cuhun nú. ");
INSERT INTO mieNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Cūndēhé ndá nú nāsa técū ndá tīcācá, de nduú jáquīn tī, ni nduú nástútú tī, ni nduú nūū tavāha tī ni yacā tī. De vísō súcuán de maá Yāā Dios scájī yā tī. ¿De á nduú cánuú ndasí cā ndá ndóhó nsūú cā ndá quiti ñúcuán? ");
INSERT INTO mieNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿De ní iin nú, á cuu chisó nú iin yiquí cā maá nú, vísō ná nácani ndasí inī nū? ");
INSERT INTO mieNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","De tú mā cūú sāhá nú iin tiñu lúlí súcuán, ¿de nājēhē cúu jā nácani ndasí inī nū sīquī jā cajī nū jā cuhun nú? ");
INSERT INTO mieNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Cūndēhé ndá nú nāsa jée ndá itā yucú. Chi nduú sátíñú ni nduú quéhen. De cáhān ni jíín ndá nú jā juni rey Salomón, quīvī jā ní ñúhun dē sahma váha ndasí, de ni nduú ní ñúhun dē sahma viī súcuán tá cúu nūū íyó ndá itā. ");
INSERT INTO mieNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","De tú súcuán jéhe Yāā Dios sahma viī nūū itā yucú jā íyó nūū ñūhún mitan de teēn de cāyū nūū ñúhūn, de nā oncā cúu ndá ndóhó jā má cuáha yā sahma. ¿De nūcu nduú cándíja nīhin ndá nú jā jíto yā ndóhó? ");
INSERT INTO mieNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Túsaá de mā nácani cuécá inī nū nāsa cajī nū nāsa coho nú. ");
INSERT INTO mieNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Chi maá-ni sīquī yáhá cúu jā ndíhvī inī nchivī ñayīví jāá nduú cándíja. Sochi ndá máá nú chi íyó Tatá nú andiví, de jínī yā jā jíni ñúhún nú ndācá yáhá. ");
INSERT INTO mieNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","De sa cánuú cā jā cundihvī inī nū sīquī tiñu jā ndácu Yāā Dios nūū nū. Ñúcuán de sāhá yā jā nīhīn nū ndācá yáhá. ");
INSERT INTO mieNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mā cúyūhú ndá nú chi cúu nú tá cúu tīcāchí nī. Chi vísō jacū ndá nú-ni cúu, de maá Tatá nú cúsiī inī yā jā quīvi nú ñuū nūū tátúnī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xīcó ndá nú jā névāha nú, de cuāha nú xūhún ñúcuán nūū nchivī ndāhví. De súcuán de scáyā nū tāhvī nū jondē andiví nūū má cútúhú, tá cúu nūū távāha nú xūhún inī itīn. Chi jondē andiví de mā náā jā váha jā cunevāha nú. Chi ñúcuán mā quívi jācuīhná, ni mā cūú stíví tīquixīn. ");
INSERT INTO mieNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Chi jondē nūū nīhīn nū tāhvī váha nú, ñúcuán cúu nūū cundihvī inī nū sīquī. ");
INSERT INTO mieNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Coo tūha ndá nú jā nenda Jētohō nū, de sāhá nú tá sáhá ndá mozo jā náscuíquīn ji lámpara ji. ");
INSERT INTO mieNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Chi íyó tūha ji de ndétu ji jā nenda patrón ji jā cuáhān dē vico tándāhá. Chi tá nenda dē de cāhān dē, de nacune-ni ndá ji viéhé. ");
INSERT INTO mieNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","De nācā ndetū ndá mozo ñúcuán jā tá nenda patrón ji, de cunī dē jā ndíto ji. De ndāā cáhān ni jíín nú jā maá patrón sāhá tūha dē maá dē, de tenee dē ji nūū mesa jā cani dē cōhō ji. ");
INSERT INTO mieNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","De vísō cucuéé dē nenda dē jondē sava ñuú, á ja nī nchāha ñuú, de tú cunī dē jā súcuán ndíto ndá mozo dē, de nācā ndetū ndá ji túsaá. ");
INSERT INTO mieNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","De chuhun inī ndá nú jā cáhān tūhun yátá yáhá: Tēe xívéhe, tú ní jínī dē nā hora quiji jācuīhná, de cundito dē, de mā cuáha dē tūhun sacuíhná vehe dē nícu. ");
INSERT INTO mieNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","De saá-ni ndá ndóhó, coo tūha nú, chi tú nduú, de maá hora jāá nduú ná jáni inī nū, de nenda nduhū, Yāā nī nduu tēe, ncachī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ñúcuán de Pedro nī jīcā tūhún dē yā: Señor, ¿á jíín ndá máá sá-ni cáhān ní tūhun yátá yáhá, á suni cáhān ní jíín ndihi cā nchivī? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","De nī ncāhān maá Jētohō ō: Cáhān ni jíín nā-ni nchivī jā cúu tá cúu mozo jā ndito xīnī de squíncuu vāha. De maá patrón nī jani dē ji jā coto ji nchivī vehe dē, tácua scájī ji maá hora. ");
INSERT INTO mieNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","De nācā ndetū mozo ñúcuán jā tá nenda patrón ji, de cunī dē jā súcuán squíncuu vāha ji. ");
INSERT INTO mieNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","De ndāā cáhān ni jíín ndá nú jā cani dē mozo ñúcuán jā coto ji ndihi ndatíñú dē. ");
INSERT INTO mieNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sochi tú jáni inī ji jā má nēndá ñamā patrón ji, de quijéhé ji cani ji ndá tēe jíín ñahan jā cúu táhán mozo ji, de cajī ji coho ji de jīni ji, ");
INSERT INTO mieNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tú súcuán de nenda-ni patrón ji quīvī jāá nduú ndétu ji jíín hora jāá nduú ná jáni inī ji. De sndóho ndasí dē ji, de chihi dē ji cundoho ji nūū yíhí ndá nchivī jāá nduú squíncuu. ");
INSERT INTO mieNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","De mozo jā jínī nāsa jétahān inī patrón ji, de tú nduú sátūha ji de nduú squíncuu ji jā cúnī dē, de cundoho xēēn ji jíín ntuxíi. ");
INSERT INTO mieNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","De mozo jāá nduú jínī nāsa jétahān inī patrón ji, de tú sáhá ji tiñu jā cani dē ji ntuxíi, túsaá de jacū-ni cani dē ji. Chi ndá nchivī jā stéhēn cuāhā yā nūū ji, suni cuāhā nācān yā nūū ji. De ndá nchivī jā cuāhā cā tiñu nī ntee yā ji, suni cuāhā cā nācān yā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nī nquenda nī jā modo jā scuíquīn ni ñuhūn inī ñayīví, de suu cúu jā cusíín inī nchivī jā síquī nduhū. De cúnī ni jā ñamā coo súcuán, tácua quīvi ndá nchivī ndahá Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","De íyó iin tūndóhó jā cánuú cundoho nī, de cúcuécá ndasí inī ni chi jondē jīnu cundoho nī, sá de ndusiī inī ni. ");
INSERT INTO mieNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿De á jáni inī ndá nú jā váji nī jā cundeē mānī nchivī ñayīví? Cáhān ni jíín ndá nú jāá nduú, chi sa cusíín inī nchivī jā síquī nduhū. ");
INSERT INTO mieNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chi jondē mitan de quijéhé jā ūhūn nchivī iin vehe cusíín inī ji. De nenda ūnī sīquī ūū, de ūū sīquī ūnī. ");
INSERT INTO mieNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Chi tatá cusíín inī jíín sēhe yií, de sēhe yií jíín tatá, de naná jíín sēhe síhí, de sēhe síhí jíín naná, de naná chíso jíín sēhe jānú, de sēhe jānú jíín naná chíso, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","De suni nī ncāhān yā jíín nchivī cuāhā: Tá jínī ndá nú jā nénda vīcō ichi nūū quée ncandiī, de cáhān nū jā cuun sāvī, de súcuán cúu. ");
INSERT INTO mieNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","De tá vāji tāchī ichi sur, de cáhān nū jā nandiī, de súcuán cúu. ");
INSERT INTO mieNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Vāchi tēe stáhví-ni cúu ndá nú. Ja jícūhun inī nū nāsa stéhēn seña andiví jíín inī ñayīví, ¿de nūcu nduú jícūhun inī nū ní iin cúu nduhū jā sáhá nī ndācá tiñu ñáhnú tiempo yáhá? ");
INSERT INTO mieNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿De nūcu nduú sáhá ndá máá nú cuenta ní iin cúu tiñu ndāā jā sāhá nú? ");
INSERT INTO mieNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","De tú iin nchivī quīhīn ji jíín nú nūū justicia jā cāhān ji cuāchi sīquī nū, túsaá de juni cuāhān nū jíín ji ichi de cundihvī inī nū sāhá ndāā nū jíín ji. Chi tú nduú, de squívi ji ndóhó nūū juez, de juez siáha dē ndóhó nūū policía, de policía chihi dē ndóhó vecāa. ");
INSERT INTO mieNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","De ndāā cáhān ni jíín nú jā má quēé cuitī nū ñúcuán chi jondē chunáá nú ndihi cuitī xūhún jā jícān ndá dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","De iin quīvī ñúcuán nī nquenda jacū tēe, nī nacani dē tūhun nūū yā nāsa nī ndoho sava tēe Galilea. Chi tá jáhnī ndá dē quiti jā sōcō dē, de nī nquenda-ni ndá mozo Pilato nī jahnī tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","De nī ncāhān Jesús: Ndá tēe Galilea ñúcuán, ¿á jáni inī ndá nú jā súcuán nī ndoho dē sīquī jā ndasí cā nī īyo cuāchi dē nsūú cā ndá cā nchivī Galilea? ");
INSERT INTO mieNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Cáhān ni jíín ndá nú jāá nduú. De ndá máá nú suni tānū tāhvī nū de tú mā nácani inī nū jā sndóo nú cuāchi nú. ");
INSERT INTO mieNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","De xāhōn ūnī tēe jā ní jicó cáva torre Siloé sīquī dē, de nī jīhī ndá dē, ¿á jáni inī nū jā ndasí cā nī nsāhá ndá dē cuāchi nsūú cā ndá cā nchivī Jerusalén? ");
INSERT INTO mieNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Cáhān ni jíín ndá nú jāá nduú. De ndá máá nú suni tānū tāhvī nū de tú mā nácani inī nū jā sndóo nú cuāchi nú. ");
INSERT INTO mieNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ñúcuán de nī ncāhān yā tūhun yátá yáhá jā stéhēn yā tá cúu nchivī jāá nduú squíncuu tūhun ndácu Yāā Dios: Cúu ji tá cúu iin ñutun higo jā íñí nūū ñuhun iin tēe. De nī jēndēhé dē tú íyó jāvíxī xīnī, de nduú nā cuá īyó. ");
INSERT INTO mieNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","De nī ncāhān dē jíín mozo jā sátíñú nūū ñuhun dē: Mitan de ja íyó ūnī cuīyā jā quínducú nī jāvíxī xīnī ñutun higo yáhá, de nduú nā cuá cúun. Túsaá de quehndē nū, chi vāchi sátéñú nūū ñūhún, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","De nī ncāhān mozo jíín dē: Señor, sndóo ní ná cuíñi iin cuīyā yāhá cā, de ná nástáyā sá jēhē de chuhun sá jēhen. ");
INSERT INTO mieNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","De cūndēhé ó tú cuun jāvíxī incā cuīyā. De tú nduú, de tēhndē, ncachī mozo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","De iin quīvī nátātú de stéhēn Jesús tūhun inī vehe īī sinagoga. ");
INSERT INTO mieNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","De íyó iin ñahan jā ní ncuu xāhōn ūnī cuīyā cúhū ña. Chi iin tāchī nī nsāhá jā jíca tihí ña, de nduú cā cúu cuitī caca tuun ña. ");
INSERT INTO mieNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","De nī jinī Jesús nūū ña, de nī ncana yā ña, de nī ncāhān yā jíín ña: Nánā, mitan de nduvāha ní jā cúhū ní, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","De nī ntee yā ndahá yā ña, de nī nūcuīñī tuun ña-ni, de nī nacuetáhví ndasí ña nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","De tēe cúñáhnú inī vehe īī sinagoga, nī nquītī inī dē nī jinī dē Jesús jā ní nasāhá vāha yā ñahan ñúcuán quīvī nátātú. De nī ncāhān dē jíín ndá nchivī: Iyó īñū-ni quīvī sátíñú ó, de ndá quīvī ñúcuán quiji ndá nú jā nduvāha nú. De quīvī nátātú chi mā cūú, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ñúcuán de nī ncāhān maá Jētohō ō jíín dē: Vāchi tēe stáhví-ni cúu ndá nú. De quīvī nátātú, ¿á nduú nándají ndá nú stīquī nū jíín burro nú jā quíscóho nú tī ndute? ");
INSERT INTO mieNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","De ñahan yáhá jā cúu ña tatā Abraham, chi modo jā ní nuhnī ña xāhōn ūnī cuīyā nī nsāhá Satanás. ¿De á nduú íyó vāha jā ní nandají nī ña nūū cuēhē ña quīvī nátātú? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","De jā ní ncāhān yā súcuán, de nī ncucanoō ndá tēe jā jínī ūhvī dē yā. De ndihi nchivī nī ncusiī ndasí inī ji nī jinī ji ndá tiñu ñáhnú sáhá yā. ");
INSERT INTO mieNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","De nī ncāhān yā: Ná cáhān ni iin tūhun yátá tácua cunī ndá nú nāsa cúu jā ndúcuahā nchivī jā tátúnī Yāā Dios nūū. ");
INSERT INTO mieNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ndúcuahā ji tá cúu nūū jáhnu iin niquin yuvā mostaza jā ní jaquīn iin tēe nūū ñuhun dē. De nī jahnu, de nī ncuu iin ñutun cáhnú, de ndá saā chi sáhá tī tacā tī chījin ndahá yúcū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","De nī ncāhān tucu yā: Súcuán cúu jā ndúcuahā nchivī jā tátúnī Yāā Dios nūū: ");
INSERT INTO mieNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Cúu tá cúu levadura jā ní nquehen iin ñahan, de nī nsacā ña jíín ūnī kilo harina, de nī ndaa ndihi ñujan nī nsāhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","De ñúhún Jesús ichi cuāhān yā Jerusalén, de yáha yā ndācá ñuū nāhnú jíín ñuū lulí, de stéhēn yā tūhun. ");
INSERT INTO mieNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","De iin nchivī nī jīcā tūhún ji yā: Señor, ¿á jacū-ni nchivī cúu jā scácu Yāā Dios, á naá cúu? ncachī dē. De nī ncāhān yā jíín ndá ji: ");
INSERT INTO mieNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Cundihvī inī ndá nú quīvi nú ndahá Yāā Dios. Chi cúu tá cúu iin viéhé túū. De cáhān ni jíín ndá nú jā iin quīvī de cuāhā nchivī nducú ji quīvi ji, de mā cūú cā quīvi ji. ");
INSERT INTO mieNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","De quīvī ñúcuán chi sāhá nī tá cúu nūū sáhá iin tēe xívéhe, jā nacuiñī dē de nacasī dē viéhé. De tāvēhé cuiñi ndá nú, de scáján nú viéhé, de cāhān nū: Señor, nacune ní viéhé ná quívi ndá sá. De cāhān dē jíín nú: ¿Ní nūū vāji ndá nú? Chi nduú jínī ni ndóhó, cachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ñúcuán de quijéhé ndá nú cāhān nū jíín dē: Nī nchajī ndá sá nī jihi sá jíín ní, de nūū yáhvi ñuū sá nī stéhēn ní tūhun, cachī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","De cāhān maá dē: Cáhān ni jíín ndá nú jāá nduú jínī ni ní jondē vāji nú. Cujiyo ndá nú quīhīn nū, chi nchivī jā sáhá tiñu néhén cúu nú, cachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","De quīvi ndá nú nūū cuacu nú de nacayīhí nú ñii yúhú nú jā ndoho xēēn nū. De cunī nū nūū Abraham jíín Isaac jíín Jacob jíín ndācá tēe nī nacani tūhun Yāā Dios, íyó ndá dē ñuū nūū tátúnī Yāā Dios. De ndá ndóhó, vísō cúu nú tatā ndá dē, sochi quīvi nú nūū ndoho nú. ");
INSERT INTO mieNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Sochi cuāhā nchivī, vísō nduú cúu ji tatā ndá dē, de quiji ndá ji ichi nūū quénda ncandiī jíín nūū quée ncandiī, jíín ichi norte jíín ichi sur. De cundeē ji mesa jā cajī ji stāā ñuū nūū tátúnī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","De sava nchivī jā mitan cúu ji jā sándīhí, de ichi ñúcuán nduu ji nūū. De sava nchivī jā mitan cúu ji nūū, de ichi ñúcuán nduu ji jā sándīhí, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","De maá quīvī ñúcuán nī nquenda jacū tēe fariseo, de nī ncāhān dē jíín yā: Cujiyo ní quīhīn ní incā lado, chi cúnī Herodes cahnī dē ní, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","De nī ncāhān yā: Cuáhán ndá nú de cachī tūhun nú nūū tēe stáhví ñúcuán jāá ncháha ca quenda quīvī cuū ni, chi mitan jíín teēn tavā ni tāchī inī nchivī, de nasāhá vāha nī nchivī. De quīvī únī de jīnu tiñu sáhá nī, cachī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Chi cánuú jā caca nī quīhīn ni mitan jíín teēn jíín isá, de jīnū ni Jerusalén. Chi ndá tēe nácani tūhun Yāā Dios, nduú jíhī dē incā lado, chi maá-ni inī Jerusalén jáhnī ji ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ndá ndóhó nchivī Jerusalén, jáhnī nū ndá tēe nácani tūhun Yāā Dios, de cáni nú yūū xīnī ndá tēe jā tájí Yāā Dios vāji nūū nū. De cuāhā vuelta nī ncuu inī ni nastútú nī sēhe nú, tá cúu nūū sáhá iin ñihín jā nástútú tī sēhe tī chījin nījīn tī, sochi nduú ní ncúnī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Túsaá de mitan de sndóo uun nī ndóhó jíín ndá sēhe nú. Chi cáhān ni jíín nú jā jondē mitan de mā cūní cuitī cā nū nūū ni, chi jondē quenda quīvī jā cāhān ndá sēhe nú: Vāha ndasí Yāā cúu Yāā jā ní nenda jíín tiñu maá Jētohō ō Yāā Dios, cachī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","De iin quīvī nátātú nī jēhēn yā vehe iin tēe fariseo jā cúñáhnú, nī jēcajī yā stāā jíín dē. De ndá cā tēe fariseo chi ndéhé yuhū dē yā tú stíví yā. ");
INSERT INTO mieNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","De ñúcuán íyó iin tēe cúhū cuēhē cuiñu, íñí dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","De nī jīcā tūhún yā ndá tēe stéhēn ley janahán jíín ndá tēe grupo fariseo: ¿A íyó ley jā nasāhá vāha nī nchivī cúhū quīvī nátātú, á nduú? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sochi nduú ní ncáhān cuitī ndá dē. De nī ntiin yā tēe cúhū, de nī nasāhá vāha yā dē, de nī ncāhān yā jā ná quínohōn dē. ");
INSERT INTO mieNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","De nī ncāhān yā jíín ndá dē: ¿Ní iin nú de tú burro nú á stīquī nū nincava tī inī iin pozo, de á nduú ñamā natavā nū tī, vísō quīvī nátātú cúu? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","De nduú ní ncúu scócóo ndá dē ni iin tūhun nūū yā jā súcuán nī ncāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","De nī jinī Jesús jā ndá tēe jā ní ntacā, nácāji dē silla yíñúhún cā nūū mesa jā cundeē dē. De nī ncāhān yā tūhun yáhá jíín ndá dē: ");
INSERT INTO mieNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Tú cana iin tēe jā quíhīn nū vico tándāhá, de mā cúndeē nū lugar yíñúhún cā. Chi tú súcuán de sanaā de ja nī ncana dē iin tēe cúñáhnú cā nsūú cā ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","De quiji tēe jā ní ncana ndóhó, de cāhān dē jíín nú: Nacuiñī, chi jīñā cundeē tēe yáhá. Ñúcuán de cucanoō nū de quīhīn nū jondē jā sándīhí. ");
INSERT INTO mieNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Chi tú cana iin tēe ndóhó, de sa cundeē nū jondē lugar jā sándīhí. De tá quiji tēe jā ní ncana ndóhó, de cāhān dē jíín nú: Amigo, nehēn cundeē nū iin lugar nūū yíñúhún cā, cachī dē. Ñúcuán de ndá nchivī ndéē jíín nú nūū mesa, cunī ji jā sáhá ñáhnú dē ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Súcuán nī ncāhān ni tūhun yáhá tácua cunī ndá nú jā ndācá nchivī jā sáhá ñáhnú ji maá ji, sa nuu ji sāhá Yāā Dios. De nchivī jā sáhá núu ji maá ji, sa nduñáhnú ji sāhá yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","De suni nī ncāhān yā jíín tēe jā ní ncana dē yā jā cajī yā stāā: Tú sāhá nú jā cusámá nchivī á jā cuxíní ji, de mā cāná nú ndá nchivī cúu amigo nū jíín ñanī nū jíín táhán nú jíín ndá nchivī cuīcá. Chi tú súcuán de suni nacana ndá máá ji ndóhó, de súcuán nanihīn nū jā ní jēhe nú. ");
INSERT INTO mieNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Chi tá sáhá nú vico, de sa cana nú ndá nchivī ndāhví, nchivī cuhlu, nchivī cojo, nchivī cuāá. ");
INSERT INTO mieNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","De súcuán de quendōo ndetū nū, chi mā cūú nacuāha ji nūū nū. De nīhīn nū tāhvī nū quīvī jā natecū ndá nchivī ndāā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","De iin tēe jā yájī stāā jíín yā, nī jini dē tūhun yáhá, de nī ncāhān dē jíín yā: Nācā ndetū ndá tēe jā cajī stāā inī ñuū nūū tátúnī Yāā Dios, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ñúcuán de nī ncāhān Jesús iin tūhun yátá jā stéhēn yā jā cána Yāā Dios nchivī jā quīvi ji inī ñuū nūū tátúnī yā: Iin tēe nī nsāhá dē iin vico cáhnú jā cuxíní, de nī ntají dē mozo dē jā cana cuāhā nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","De maá quīvī jā cuxíní, de nī ntají dē mozo dē cuācāna ndá nchivī ñúcuán jā ná quíji ji cuxíní ji: Nehēn ndá ní, chi ja íyó tūha ndihi, ncachī mozo. ");
INSERT INTO mieNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","De ndihi nchivī nī ncāhān ji jā ná cúne cáhnú inī dē chi mā quíhīn ji. Iin tēe nī ncāhān dē: Cáta nī jeen nī iin ñuhun de cánuú quīndēhé nī, de ná cúne cáhnú inī dē chi mā cuéē ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","De incā dē nī ncāhān: Nī jeen nī ūhūn yunta stīquī, de quīhīn ni coto túnī ni tī, de ná cúne cáhnú inī dē chi mā cuéē ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","De incā dē nī ncāhān: Cáta nī ntandāhá nī, de jā ñúcuán mā cūú cuēē ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","De cuānohōn mozo, de nī ncachī tūhun dē nūū patrón dē nāsa nī ncāhān ndá nchivī. Ñúcuán de nī nquītī inī patrón, de nī ncāhān dē jíín mozo dē: Ñamā quīhīn nū ndá calle nāhnú jíín calle lulí, de cana nú ndá nchivī ndāhví, nchivī cuhlu, nchivī cojo, jíín nchivī cuāá, ná quíji ndá ji vico, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","De nī jēhēn mozo, de nī nenda dē, de nī ncāhān dē: Señor, ja nī nsāhá sá tá ncachī ní, de cúmanī cā nchivī de chitú vehe ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","De nī ncāhān tucu patrón: Quīhīn tucu nú ndācá calle jíín ichi, de cana fuerza nū nchivī ná quíji ji, tácua cuchitú vehe nī. ");
INSERT INTO mieNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chi cáhān ni jíín nú jā ni iin nchivī jā ní ncana nī jā xíhna ñúhún, mā cuáha cuitī ni tūhun jā cuxíní ji vehe nī, ncachī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","De cuāhā ndasí nchivī níquīn ji Jesús cuāhān ji jíín yā, de nī ndicó cóto yā, de nī ncāhān yā jíín ji: ");
INSERT INTO mieNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Tú nā-ni nchivī cúnī ji cuniquīn ji nduhū jā scuáha nī ji, de tú mānī cā ji jíín tatá ji, naná ji, ñasíhí ji, sēhe ji, ñanī ji, cuāha ji, nsūú cā jíín nduhū, de mā cūú cuu ji nchivī scuáha jíín nī. De tú ndíhvī cā inī ji sīquī jā coo vāha maá ji nsūú cā jā cuniquīn ji nduhū, de suni mā cūú tucu. ");
INSERT INTO mieNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","De nā-ni nchivī tú mā cuáha ji tūhun cundoho ji tūndóhó vísō jondē cuū ji sīquī jā cuniquīn ji nduhū, de mā cūú cuu ji nchivī scuáha jíín nī. ");
INSERT INTO mieNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Chi tú ní iin nú cúnī nū caquīn nū iin vehe cáhnú, ¿de á nduú cánuú jā xihna cā cundeē nū tavā nū cuenta tú quenda xūhún jā sínu nú vehe? ");
INSERT INTO mieNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Chi tú nduú, de tá ja nī ntavā nū cimiento, de mā quēndá xūhún sínu nú, de ñúcuán de ndá nchivī chi sāhá catá ji nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","De cāhān ji: Tēe yáhá chi nī nquijéhé dē sáhá dē vehe, de nduú ní ncúndéé dē sínu dē, cachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","De saá-ni tú iin rey quīcanāá dē jíín incā rey jā váji sīquī dē, ¿de á nduú cánuú jā xihna cā cundeē dē nacani inī dē tú cundeé dē jíín ūxī mil soldado jā canāá dē jíín incā rey jā váji sīquī dē jíín ōcō mil soldado? ");
INSERT INTO mieNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chi tú mā cúndéé dē, de juni jícá cā vāji incā rey, de tají dē sava tēe ndíso tíñú jā quíhīn ndá dē cātūhún dē nā cuá cúnī incā rey jā cuāha dē, de jencuiñī-ni. ");
INSERT INTO mieNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","De ndá máá nú, suni súcuán cánuú jā xihna cā nacani inī nū de quehndē inī nū jā sndóo nú ndihi jā névāha nú, chi tú nduú de mā cūú cuu nú nchivī scuáha jíín nī. ");
INSERT INTO mieNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","De nchivī cándíja cúu ji tá cúu ñīī. Vāha íyó ñīī, de tú ñīī ná náā jā úhguā, ¿de nāsa nduu uhguā tucu? ");
INSERT INTO mieNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nduú cā tiñu cuitī cā, ni jā chuhun nchivī nūū itū, ni jā nduu jēhen, chi sa cutē-ni nchivī. Ndá ndóhó jā níni, tee sōho vāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","De ndá tēe stútú xūhún renta jíín ndá cā tēe sáhá cuāchi, nī nquenda dē nūū Jesús jā cunini dē tūhun cáhān yā. ");
INSERT INTO mieNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","De ndá tēe grupo fariseo jíín ndá tēe stéhēn ley janahán, nī ncāhān dē sīquī yā: Tēe yáhá chi jétáhví dē ndá tēe sáhá cuāchi de yájī dē jíín, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","De nī ncāhān yā tūhun yátá yáhá jíín ndá dē: ");
INSERT INTO mieNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","¿Ní iin nú de tú névāha nú iin ciento tīcāchí, de tú scuíta nú iin tī, de á nduú sndóo nú cūmī xico xāhōn cūmī cā tī yucu, de quīnanducú nú quiti jā ní nsana jondē nanihīn nū tī? ");
INSERT INTO mieNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","De tá nī nanihīn nū tī, de chisó nú tī nūū chíyō nū, de cusiī inī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","De tá nenda nú vehe nú de nastútú nú ndācá amigo nū jíín nchivī ndéē ñatin jíín nú, de cāhān nū jíín ji: Ná cúsiī inī ō, chi nī nanihīn ni tīcāchí nī jā ní nsana, cachī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","De cáhān ni jíín ndá nú jā suni súcuán cúu jondē andiví. Chi cúsiī cā inī yā jíín iin nchivī jā íyó cuāchi de nácani inī ji jā sndóo ji cuāchi ji, nsūú cā jíín cūmī xico xāhōn cūmī nchivī íyó ndāā jāá nduú cā cánuú nacani inī ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","De tú iin ñahan névāha ña ūxī xūhún plata, de tú scuíta ña iin, ¿de á nduú scuíquīn ña lámpara, de nastáá ña vehe, de nanducú vāha ña jondē nanihīn ña? ");
INSERT INTO mieNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","De tá nī nanihīn ña, de nastútú ña ndācá amiga ña jíín nchivī ndéē ñatin jíín ña, de cāhān ña jíín ji: Ná cúsiī inī ō, chi nī nanihīn ni xūhún jā ní scuíta nī, cachī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","De cáhān ni jíín ndá nú jā suni súcuán cúsiī inī ndá ángel Yāā Dios sīquī iin nchivī jā íyó cuāchi de nácani inī ji jā sndóo ji cuāchi ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","De nī ncāhān tucu yā: Iin tēe nī īyo ūū sēhe yií dē. ");
INSERT INTO mieNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","De tēe suchí cā nī ncāhān ji jíín tatá ji: Tatá, tahví sáva ní ndatíñú ní, de taji ní sava cuu tāhvī sá, ncachī ji. De nī ntahví sáva dē tāhvī ndúū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","De nī ncuu jacū-ni quīvī, de tēe suchí ñúcuán nī stútú ndihi ji ndatíñú ji, de nī nquee ji cuāhān ji iin ñuū jīcá. De ñúcuán nī snáā cāhá ji tāhvī ji chi nī jāxīn nāvāha ji. ");
INSERT INTO mieNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","De tá nī ndihi nī jāxīn ji, de nī nquiji iin tāmā xéēn inī ñuū ñúcuán, de nī nquijéhé cúmanī jā cajī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","De cuānducú tíñú ji nūū iin tēe ñuū ñúcuán. De nī ntají dē ji cuāhān ji rancho dē jā coto ji quinī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","De cúnī ji cajī ji sōō ndūchí jā yájī quinī tácua ndahā chījin ji. De ni iin nchivī nduú ná jéhe nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ñúcuán de nī nacani inī ji, de nī ncāhān ji: Ndācá mozo jā sátíñú vehe tatá nī, íyó cuāhā stāā yájī ji. De nduhū jíhī ni sōco yáhá. ");
INSERT INTO mieNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ná quínohōn ni nūū tatá nī, de cāhān ni jíín dē: Tatá, nī nsāhá sá cuāchi nūū Yāā Dios jíín nūū maá ní. ");
INSERT INTO mieNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mitan de nsūú cā tēe vāha cúu sá jā cunaní sá sēhe ní. De cuāha ní tūhun cuu sá tá cúu iin mozo ní, cachī ni. ");
INSERT INTO mieNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sá de nī naquehen ji ichi cuānohōn ji nūū tatá ji. De cáta jícá cā vāji ji, de nī jinī tatá ji nūū ji, de nī ncundáhví inī dē ji. De jínu dē cuātahān dē ji, de nī numi táhán dē jíín ji, de nī nchitū dē nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ñúcuán de nī ncāhān ji jíín dē: Tatá, nī nsāhá sá cuāchi nūū Yāā Dios jíín nūū maá ní. Mitan de nsūú cā tēe vāha cúu sá jā cunaní sá sēhe ní, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Sochi maá tatá ji nī ncāhān dē jíín ndá mozo dē: Cuáquēhen nú iin sahma váha cā de chuhun nú ji. De chuhun nú iin xehe ndahá ji, de chihi nú nījān jēhē ji. ");
INSERT INTO mieNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","De quīcuēca nú becerro jā ní neñu, de cahnī nū tī ná cájī ō, chi sāhá ó vico. ");
INSERT INTO mieNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Chi sēhe yií nī yáhá, modo ja nī jīhī ji, de nī natecū ji. Chi nduú ní jínī ni ní ichi nī jēhēn ji, de nī nenda ji, ncachī dē. De nī nquijéhé ndá dē sáhá dē vico. ");
INSERT INTO mieNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","De sūchí ñáhnú cā, ndéē ji jondē rancho, de vāndiji ji, de nī nduñatin ji vehe. De nī jini ji jā tívī música de jíta jéhé nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","De nī ncana ji iin mozo, de nī jīcā tūhún ji nā cuá cúu. ");
INSERT INTO mieNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","De nī ncachī mozo nūū ji: Nī nenda ñanī nū, de tatá nú nī jahnī dē becerro jā ní neñu, chi nī nenda vāha ji nūū dē, ncachī mozo. ");
INSERT INTO mieNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ñúcuán de nī nquītī inī sūchí ñáhnú, de nduú ní ncúnī ji ndīvi ji. De nī nquee tatá ji, de nī ncāhān ndāhví dē jíín ji jā ná ndívi ji. ");
INSERT INTO mieNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","De nī ncāhān ji jíín tatá ji: Níní sáhá sá tiñu ndácu ní, de nduú cúnīhin cuitī inī sá nūū ní. De nduú táji ní vísō iin lítú nūū sá jā sāhá sá vico jā cajī sá jíín ndá amigo sá. ");
INSERT INTO mieNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","De nī nenda sēhe ní yáhá jā ní jāxīn cāhá ji xūhún ní jíín ndá ñahan ndiī. De nī jahnī ní becerro jā ní neñu jā cajī ji, ncachī ji jíín tatá ji. ");
INSERT INTO mieNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ñúcuán de nī ncāhān dē: Séhē, ndóhó chi níní ndéē nū jíín nī, de ndihi jā névāha nī chi suni cuenta maá nú cúu. ");
INSERT INTO mieNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","De mitan de íyó vāha jā sāhá ó vico de cusiī inī ō. Chi ñanī nū yáhá, modo ja nī jīhī ji, de nī natecū ji. Chi nduú ní jínī ō ní ichi nī jēhēn ji, de nī nenda ji, ncachī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","De suni nī ncāhān Jesús jíín ndá tēe scuáha jíín yā: Iin tēe cuícá nī īyo iin mozo dē jā ndíso tíñú nūū ndá cā mozo. De nī ncāhān ndá jíín patrón jā mozo ñúcuán snáā cāhá ndatíñú dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","De nī ncana dē mozo ñúcuán, de nī ncāhān dē jíín: ¿Nā tūhun cúu yáhá jā ní nīhīn ni sīquī nū? Nacuāha nú cuenta tiñu ndíso nú, chi mā cúndiso tíñú nú cā nūū ndá mozo ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ñúcuán de nī jani inī mozo: ¿Nāsa sāhá nī mitan? Chi patrón ni candeē dē tiñu ndíso nī. Chi nduú ndacuī ni jā quete nī ñuhun, de jā cācān ni caridad chi cucanoō ni. ");
INSERT INTO mieNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Túsaá de jínī ni nāsa sāhá nī jíín ndá nchivī jā jéen nūū patrón ni, tácua taji ji vehe cundeē ni tá quenda quīvī candeē dē tiñu nī. Ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","De nī ncana dē tá iin iin tēe jā ndíta nūū patrón dē. De nī ncāhān dē jíín iin: ¿Nāsaa ndíta nú nūū patrón ni? ");
INSERT INTO mieNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","De nī ncachī tēe ñúcuán: Ciento barril aceite. De nī ncāhān mozo: Yáhá ná táji nī vale nū, de ñamā cundeē nū sāhá nú incā vale jā ūū xico ūxī-ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ñúcuán de nī ncāhān dē jíín incā tēe: ¿De ndóhó, nāsaa ndíta nú? De nī ncāhān tēe ñúcuán: Ciento cajón trigo, ncachī dē. De nī ncāhān dē jíín: Yáhá ná táji nī vale nū, de sāhá nú incā vale jā cūmī xico-ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Sá de nī ncāhān maá patrón jā ndíchí ndasí nī nsāhá tēe nēhén ñúcuán jíín nchivī jā ndíta nūū patrón dē, tácua cuāha ji vehe cundeē dē. De cáhān ni jíín ndá nú jā nchivī ñayīví yáhá, ndito cā sáhá ji jā quendōo vāha ji nūū táhán ji, nsūú cā ndá nchivī jā cándíja Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Túsaá de cáhān ni jíín ndá nú jā ndíchí cā sāhá nú nsūú cā jā ní nsāhá mozo ndīchí ñúcuán. Chi inī ñayīví yáhá nūū íyó cuāchi, sāhá ndá nú tiñu váha jíín xūhún nú, chi cuāha nú nūū nchivī ndāhví, tácua vísō tú ndihi xūhún nú ñayīví yáhá, de quīvi nú andiví nūū coo vehe nú níí cání. ");
INSERT INTO mieNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nchivī jā squíncuu vāha jíín iin tiñu lúlí-ni, suni squíncuu vāha ji jíín tiñu cáhnú. De nchivī jā stáhví jíín iin tiñu lúlí-ni, suni stáhví ji jíín tiñu cáhnú. ");
INSERT INTO mieNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Túsaá de tú nduú squíncuu vāha nú jíín xūhún jā íyó ñayīví yáhá nūū íyó cuāchi, de mā cuáha yā jā váha jā cuu nú níí cání andiví. ");
INSERT INTO mieNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","De tú nduú squíncuu vāha nú jíín ndatíñú jā ní jēhe núú yā nūū nū ñayīví yáhá, de mā cuáha yā tāhvī jā cuu nú níí cání. ");
INSERT INTO mieNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ni iin mozo mā cūú satíñú dē nūū ūū patrón. Chi quītī inī dē nūū iin de coo manī dē jíín incā, á squíncuu vāha dē nūū iin de sāhá jéhe inī dē nūū incā. De suni súcuán mā cūú satíñú nú nūū Yāā Dios de tú maá-ni sīquī xūhún ndíhvī inī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","De ndá tēe fariseo nī nsāhá catá dē nūū yā jā ní jini dē ndācá tūhun cáhān yā, chi tēe cútóó xūhún cúu ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","De nī ncāhān yā jíín dē: Ndá máá nú chi sáhá nú jā tēe ndāā cúu nú nūū nchivī. Sochi Yāā Dios chi jínī yā nāsa cáá ánō ndá nú. Chi tiñu jā jáni inī nchivī jā tiñu ñáhnú cúu, de nūū Yāā Dios chi tiñu néhén cúu. ");
INSERT INTO mieNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jondē ncháha ca quiji Juan tēe scuénduté, de nī īyo ley jā ní jēhe Yāā Dios nūū Moisés, de suni nī stéhēn ndá tēe nī nacani tūhun yā. Ñúcuán de tá nī nquiji Juan, de nī nquijéhé jítē nuu tūhun vāha nāsa tátúnī Yāā Dios. De ndá nchivī chi ndúcú ndéé ji quívi ji ndahá yā. ");
INSERT INTO mieNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","De víjín cā cúu jā naā iin letra nūū tutū ley yā nsūú cā jā naā andiví jíín ñayīví, chi quee ndaā ndihi tūhun jā cáhān. ");
INSERT INTO mieNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","De tú nā-ni tēe sndóo dē ñasíhí dē de nacueca dē incā ñahan, túsaá de cásíquí ndéē dē ña. De tú iin tēe nacueca ñahan jā ní ndusíín, suni cásíquí ndéē dē ña, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","De nī ncāhān cā yā: Nī īyo iin tēe cuícá, nī ñūhun dē sahma fino ndasí. De ndiquivī nī īyo vāha ndasí jā ní nchajī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","De suni nī īyo iin tēe ndáhví, nání dē Lázaro, de ndéē dē viéhé tēe cuícá ñúcuán, de níí dē nī nquene ndīhyi. ");
INSERT INTO mieNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","De cúnī dē jā ndahā chījin dē jíín pedazo stāā jā cóyo yuhú mesa tēe cuícá. De quénda ndá tinā de náyuu tī nūū ndíhyi dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","De nī jīhī tēe ndáhví ñúcuán, de ndá ángel Yāā Dios nī nacueca yā dē cuāhān yā jíín ánō dē jondē andiví nūū íyó Abraham. De suni nī jīhī tēe cuícá, de nī jīquiyuhū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","De tēe cuícá ñúcuán ndóho ndasí dē íyó dē lugar nūū íyó ánō ndá ndīyi jāá nduú ní ncándíja. De nī nūcūndēhé dē, de jondē jícá nī jinī dē nūū Abraham, de ndéē iin ncáá Lázaro jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ñúcuán de nī ncana cóhó dē: Tatá Abraham, cundáhví inī ní sāán, de tají ní Lázaro, ná quíchundaji dē xīnī ndāhá dē nūū ndūté, de ná quíji dē sndáji dē yáá sá. Chi xēēn ndóho sá nūū yáñuhūn yáhá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","De nī ncāhān Abraham jíín dē: Lílū, nūcūhun inī nū jā ní nīhīn nū ndācá jā váha tá nī ntecū nū, de Lázaro chi sa tūndóhó nī nīhīn dē. De mitan de ja nī ndundeé inī dē yáhá, de ndóhó chi ndóho nú jīñā. ");
INSERT INTO mieNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","De suni íyó iin jā cūnú ndasí íyó māhñú ó jíín ndá nú. De nchivī íyó yáhá, vísō cúnī ji jā yāha ji cuēē ji nūū nū, de mā cūú. De suni mā cūú yāha ndá máá nú quiji nú yáhá. Ncachī Abraham. ");
INSERT INTO mieNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ñúcuán de nī ncāhān tēe cuícá: Túsaá de cáhān ndāhví sá jíín ní, tatá Abraham, tají ní dē ná quíhīn dē vehe tatá sá. ");
INSERT INTO mieNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Chi íyó ūhūn cā ñanī sá, de ná quícachī dē nūū ndá ji jā ná nácani inī ji de sndóo ji cuāchi ji, tácua mā quívi ndá ji nūū ndóho sá yáhá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","De nī ncāhān Abraham jíín dē: Ja névāha ji tutū jā ní ntee Moisés jíín ndá cā tēe nī nacani tūhun Yāā Dios janahán. Ñúcuán ná chúhun inī ji, ncachī Abraham. ");
INSERT INTO mieNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","De nī ncāhān tucu tēe cuícá: Nduú, tatá Abraham, chi tú iin nchivī ja nī jīhī quīhīn nūū ndá ji, ñúcuán de nacani inī ji jā sndóo ji cuāchi ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","De nī ncāhān Abraham jíín dē: Tú mā chūhún inī ji tūhun jā ní nacani Moisés jíín ndá cā tēe nī nacani tūhun Yāā Dios, de suni mā cándíja cuitī ji tú natecū iin ndīyi quīhīn nūū ji, ncachī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","De nī ncāhān Jesús jíín ndá tēe scuáha jíín yā: Maá-ni íyó jā ndúcú squívi nchivī nūū cuāchi. De nācā xēēn cundoho nchivī jā squívi táhán nūū cuāchi. ");
INSERT INTO mieNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vāha cā de tú ní núhnī iin yōsó cáhnú sūcūn ji, de quēe ji chījin ndute mar, nsūú cā jā squívi ji iin sūchí lúlí yáhá nūū cuáchi. ");
INSERT INTO mieNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Coto má sāhá ndá nú súcuán túsaá. De tú táhán nú sáhá dē cuāchi sīquī nū, de cāhān nū nūū dē. De tú nacani inī dē, de cune cáhnú inī nū nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","De tú ūjā vuelta sáhá dē cuāchi sīquī nū jā iin quīvī, de tú ūjā vuelta nácani inī dē de cáhān dē jíín nú jā cune cáhnú inī nū chi mā sāhá cā dē, cáchī dē, de cánuú cune cáhnú inī nū nūū dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","De ndá tēe cúu apóstol nī ncāhān dē jíín Jētohō ō: Sāhá ní jā ná cándíja nīhin cā ndá sá jā sāhá Yāā Dios jā jícān sá nūū yā, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","De nī ncāhān Jētohō ō jíín ndá dē: Tú candíja ndá nú vísō iin lulī-ni, tá cúu iin niquin yuvā mostaza jā lulí-ni, de cuu cachī nū jā tiūhndú yáhá ná quée de nūcūhun jondē nūū mar, de coo tá cúu nūū cáchī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tú ní iin nú íyó mozo jā jítu dē á jā scájī dē ndá quiti nú, de tá nenda dē vehe nú jā ní jēhēn dē yucu, de nduú cáhān nū jíín dē jā cundeē dē cajī dē stāā. ");
INSERT INTO mieNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Chi sa cáhān nū: Sāhá nú ndeyu cuxíní nī, de cani nú cōhō ni. De tá nī ncuu nī nchajī ni nī jihi nī, sá de cajī maá nú coho nú, cáchī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","De cáchī ndá nú jāá nduú cánuú nacuetáhví nú nūū mozo tá nī nsāhá dē tiñu jā ní ndacu nú, chi jā cánuú sāhá dē cúu. ");
INSERT INTO mieNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","De saá-ni ndá máá nú, cúu nú mozo Yāā Dios. De tú nī squíncuu nú ndācá tiñu jā ní ndacu yā nūū nū, de cachī nū: Nduú cánuú nacuetáhví yā nūū ni, chi súcuán cánuú jā squíncuu nī, cachī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","De ñúhún Jesús ichi cuāhān yā ciudad Jerusalén, de nī nchāha yā cuāhān yā māhñú región Samaria jíín Galilea. ");
INSERT INTO mieNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","De nī jīnū yā iin ñuū, de ūxī tēe ndóho cuēhē stéhyū nī nquenda dē, de jícá nī jencuiñī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","De nī ncana jee ndá dē: Jesús, Maestro, cundáhví inī ní ndá sāán, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","De tá nī jinī Jesús nūū ndá dē, de nī ncāhān yā: Cuáhán ndá nú de stéhēn nū maá nú nūū ndá sūtū jā ní nduvāha nú, ncachī yā. De juni cuāhān ndá dē de nī nduvāha dē-ni. ");
INSERT INTO mieNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ñúcuán de iin dē nī ndicó cóo dē nūū Jesús, de nácana jee dē, nácuetáhví dē nūū Yāā Dios jā ní nduvāha dē. ");
INSERT INTO mieNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","De nī jēcuīñī jītí dē nūū yā, de nī ntuu dē nūū dē nūū ñūhún, de nī nacuetáhví dē nūū yā. De tēe Samaria cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","De nī ncāhān Jesús: ¿A nsūú ndihúxī dē nī nduvāha? De īīn cā dē, ¿nūcu nduú ní ndícó dē jā nacuetáhví dē? ");
INSERT INTO mieNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿A mátúhún-ni tēe ñuū jīcá yáhá cúu jā ní ndicó jā nacuetáhví dē nūū Yāā Dios? ");
INSERT INTO mieNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","De nī ncāhān yā jíín dē: Nacuiñī de quīnohōn nū. Chi nī ncandíja nú jā cuu nasāhá vāha nī ndóhó, de jā suu cúu jā ní nduvāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","De ndá tēe fariseo nī jīcā tūhún dē Jesús nā quīvī quijéhé jā tatúnī Yāā Dios inī ñayīví. De nī ncāhān yā jíín dē: Mā quījí nijīn jā tatúnī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni mā cūú cachī nchivī: Cūndēhé chi yáhá ndéē yā jā tátúnī yā, á: Ñúcuán ndéē yā, cachī ji. Chi ja tátúnī Yāā Dios māhñú ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ñúcuán de nī ncāhān yā jíín ndá tēe scuáha jíín yā: Quiji tiempo jā cuu ndasí inī nū cūndēhé nú nūū nduhū, Yāā nī nduu tēe, de mā cūní ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","De cāhān nchivī jíín nú: Yáhá ndéē yā, á: Ñúcuán ndéē yā, cachī ji. De mā quíndēhé ndá nú, ni mā cúniquīn nū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Chi tá cúu nūū sáhá taja jā jéndūtē iin lado andiví de nátūu jondē incā lado, de suni súcuán coo quīvī jā nenda nduhū, Yāā nī nduu tēe, chi ndihi nchivī cunī. ");
INSERT INTO mieNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sochi cánuú jā xihna cā cundoho xēēn ni, de nchivī íyó mitan chi squéne yichī ji nduhū. ");
INSERT INTO mieNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","De tá cúu nūū ní ncuu ndá quīvī jā ní īyo Noé, suni súcuán coo quīvī nenda nduhū, Yāā nī nduu tēe. ");
INSERT INTO mieNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chi quīvī ñúcuán nī nchajī ndá ji, nī jihi ji, nī ntandāhá ji, nī jēhe ji sēhe síhí ji jā tandāhá, jondē nī nquenda quīvī jā ní nquīvi Noé inī barco cāhnú jā nání arca. De nī ncuun sāvī xéēn, de nī ndaa ndute de nī jīhī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","De suni súcuán nī ncuu quīvī tá nī īyo Lot. Nī nchajī ji, nī jihi ji, nī jeen ji, nī yīcó ji, nī jaquīn ji itū, nī nsāhá ji vehe. ");
INSERT INTO mieNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","De quīvī jā ní nquee Lot inī ñuū Sodoma cuāhān dē, de nī ncuun ñuhūn jíín azufre ichi andiví, de nī snáā ndihi nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","De suni súcuán coo quīvī jā nenda nduhū, Yāā nī nduu tēe. ");
INSERT INTO mieNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","De quīvī ñúcuán de nchivī ndéē yātā vēhé, de ndatíñú ji ñúhún inī vehe, cáhān ni jíín ji jā má ndívi ji naquehen ji, chi cánuú cunu ñamā ji jā cācu ji. De saá-ni nchivī satíñú nūū itū, mā quínohōn ji vehe ji jā naquehen ji ndatíñú ji. ");
INSERT INTO mieNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","De nūcūhun inī nū nāsa nī ndoho ñasíhí Lot jā ní jīhī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","De tú ní nchivī cúnī ji cācu ji nūū tūndóhó jā quiji nūū ji jā síquī nduhū, túsaá de tānū tāhvī ji níí cání. De tú ní nchivī vísō ná cúū ji jā síquī nduhū, túsaá de cutecū ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","De cáhān ni jíín ndá nú jā quīvī nenda nī de cūsūn ūū tēe nūū iin jīto jacuáā, de iin dē naquehen nī, de incā dē ndōo, chi nduú ní ncándíja dē. ");
INSERT INTO mieNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","De coo ūū ñahan jā ndico cáhnú, de iin ña naquehen nī, de incā ña ndōo. ");
INSERT INTO mieNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","De ūū tēe satíñú dē nūū itū, de iin dē naquehen nī, de incā dē ndōo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","De jā ní jini ndá dē tūhun yáhá, de nī jīcā tūhún dē yā: Señor, ¿ní cúu nūū coo súcuán ndācá jā ní ncāhān ní? ncachī dē. De nī ncāhān yā jíín dē: Tá cúu nūū cútútú ndá tiōcó ní-ni cúu nūū cáá quiti jā ní jīhī, suni súcuán coo ndācá jā ní ncāhān ni, ní-ni cúu nūū íyó nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","De nī ncāhān yā iin tūhun yátá jíín ndá dē jā cánuú jā níní cācān táhvī dē, de mā nūú inī dē jíín. ");
INSERT INTO mieNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","De nī ncāhān yā: Nī īyo iin juez inī iin ñuū. De ni nduú yúhú dē Yāā Dios, de ni nduú sáhá dē cuenta ni iin nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","De suni ñuū ñúcuán íyó iin ñahan jā ní nquendōo ndáhví. De jéhēn jéhēn ña nūū dē, jícān ña jā ná sáhá ndāā dē sīquī iin nchivī jā jínī ūhvī ji ña. ");
INSERT INTO mieNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","De cuāhā quīvī nduú ní ncúnī dē sāhá ndāā dē, sá de nī jani inī dē: Vísō nduú yúhú nī Yāā Dios ni nduú sáhá nī cuenta ni iin nchivī, ");
INSERT INTO mieNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","sochi ñahan viuda yáhá, ndasí stáhān ña nduhū, de jā ñúcuán ná sáhá ndāā ni sīquī nchivī jā jínī ūhvī ji ña. Chi tú nduú de mā cúndéé cā inī ni sāhá ña jā quíji quíji ña, ncachī dē, ncachī maá Jētohō ō. ");
INSERT INTO mieNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","De nī ncāhān cā yā: Súcuán cúu jā ní ncāhān juez, tēe jāá nduú íyó ndāā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","De Yāā Dios chi nsūú súcuán sáhá yā, chi sáhá ndāā yā sīquī tiñu nchivī jā ní nacāji yā jā nduú ñuú cáhān ndāhví ji jíín yā. Chi scácu yā ji nūū ndācá jā jínī ūhvī nūū ji. ¿De á cuéé scácu yā ji, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Cáhān ni jíín ndá nú jā ñamā. De quīvī nenda nduhū, Yāā nī nduu tēe, ¿de á nīhīn cā ni nchivī cándíja nīhin inī ñayīví? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","De suni nī ncāhān yā tūhun yátá yáhá jíín jacū nchivī jā jáni inī ji jā nchivī ndāā cúu ji, de jáni inī ji jā sava cā nchivī nduú íyó ndāā: ");
INSERT INTO mieNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Iin tēe fariseo cuāhān dē templo jā cācān táhvī dē. De iin tēe stútú xūhún renta suni cuāhān dē jā cācān táhvī dē templo. ");
INSERT INTO mieNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","De íñí tēe fariseo, de nī jīcān táhvī dē tūhun yáhá: Tátā Yāā Dios, ná cútahvī sá nūū ní, chi nduú cúu sá tá cúu nūū cúu sava cā tēe, tēe cuíhná, tēe nēhén, tēe cásíquí ndéē tāhán cúu ndá dē. De ni nduú cúu sá tá cúu nūū cúu tēe stútú xūhún renta ñúcuán jā scáa cā dē jícān dē nūū nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","De ūū vuelta jā semana íyó nditē inī sá nūū ní, de suni jéhe sá nūū ní iin iin sīquī ndācá jā úxī ndatíñú jā níhīn sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Sochi tēe stútú xūhún renta, nī jēcuīñī jīcá dē nūū templo, de ni nduú ní ncúndéé inī dē jā nane nuū dē, chi sa nī ncani dē ndahá dē ndīca dē jā cúcuécá inī dē. De nī ncāhān dē: Tátā Yāā Dios, cundáhví inī ní sāán, chi tēe íyó cuāchi cúu sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","De cáhān ni jíín ndá nú jā tēe stútú xūhún renta, nī nee cáhnú inī yā nūū cuāchi dē, de cuānohōn dē vehe dē. Sochi tēe fariseo, chi nduú. Chi nchivī jā sáhá ñáhnú ji maá ji, sa nuu ji. De nchivī jā sáhá núu ji maá ji, sa nduñáhnú ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","De nī nquenda ndá nchivī jíín ndá sūchí lúlí nūū Jesús, jā tee yā ndahá yā xīnī ji. De tá nī jinī ndá tēe scuáha jíín yā, de nī ncāhān dē nūū nchivī jā váji jíín ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","De nī ncana Jesús ndá dē, de nī ncāhān yā: Cuāha tūhun ná quíji ndá sūchí lúlí jīñā nūū ni, de mā cásī ndá nú jā quiji ji. Chi nchivī jā ndicó cóo inī ji jā cani inī ji modo ndá sūchí yáhá, suu ji cúu jā quīvi ndahá Yāā Dios jā tatúnī yā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","De ndāā cáhān ni jíín ndá nú, tú iin nchivī nduú jétáhví ji jā tatúnī Yāā Dios nūū ji, tá cúu nūū jétáhví iin sūchí lúlí, de mā quívi cuitī ji ndahá yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","De iin tēe cúñáhnú nī jīcā tūhún dē yā: Tēe vāha cúu ní Maestro. De cachī ní, ¿nā tiñu váha sāhá sá de nīhīn táhvī sá cutecū sá níí cání andiví? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","De nī ncāhān Jesús jíín dē: ¿A jáni inī nū jā iin tēe-ni cúu nī jā cáhān nū tēe vāha jíín nī? Chi nduú ni iin tēe vāha íyó, chi mátúhún-ni Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ja jínī nū ndá tūhun jā ní ndacu yā: Mā cásíquí ndéē tāhán nú. Mā cáhnī nū ndīyi. Mā sácuíhná nú. Mā cáhān nū tūhun túhún. Cuetáhví nú nūū tatá nú nūū naná nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","De nī ncāhān dē: Ndācá tiñu yáhá ja nī squíncuu sá jondē tá lulí sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","De nī jini Jesús tūhun yáhá, de nī ncāhān yā jíín dē: Iin-ni cā tiñu cúmanī sāhá nú túsaá. Xīcó ndihi jā névāha nú, de cuāha nú nūū nchivī ndāhví. De jondē andiví cuāha yā jā váha ndasí nūū nū. Ñúcuán de quiji nú cuniquīn nū nduhū cōhōn, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","De tá nī jini dē tūhun yáhá, de nī ncucuécá ndasí inī dē, chi cuícá ndasí dē. ");
INSERT INTO mieNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","De nī jinī Jesús jā ní ncucuécá ndasí inī dē, de nī ncāhān yā: Nchivī cuīcá chi ūhvī ndasí quívi ji ndahá Yāā Dios jā tatúnī yā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ñamā cā yāha iin camello yavī yitícu nsūú cā jā quīvi iin nchivī cuīcá inī ndahá Yāā Dios jā tatúnī yā nūū ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","De ndá tēe jā ní jini tūhun yáhá, nī ncāhān dē: ¿De ní nchivī cúu jā cācu túsaá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","De nī ncāhān yā: Nchivī chi mā cūú squívi ji maá ji ndahá Yāā Dios, sochi maá yā chi cuu sāhá yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ñúcuán de nī ncāhān Pedro: Señor, de ndá sāán chi nī sndóo sá ndihi jā névāha sá, de níquīn sá níhín, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","De nī ncāhān yā jíín ndá dē: Ndāā cáhān ni jíín ndá nú, tú nā-ni nchivī sndóo ji vehe, á tatá, á naná, á ñanī, á ñasíhí, á sēhe, jā síquī jā scáca ji tūhun jā tátúnī Yāā Dios nūū nchivī, ");
INSERT INTO mieNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","túsaá de nanihīn cuāhā cā ji inī ñayīví yáhá, de tiempo jā quiji de cutecū ji níí cání, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","De nī ncana síín yā ndihúxī ūū tēe scuáha jíín yā, de nī ncāhān yā jíín ndá dē: Mitan de ja cuāhān ō Jerusalén. De ñúcuán quee ndaā ndihi tūhun nāsa ndoho nduhū, Yāā nī nduu tēe, tá cúu nūū ní ntee ndá tēe nī nacani tūhun Yāā Dios jondē janahán. ");
INSERT INTO mieNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chi nastúu nchivī nduhū nūū ndá tēe nación Roma jā tátúnī jā ndéē Jerusalén. De sāhá catá ndá dē nūū ni, de sāhá nāvāha dē nduhū, de tivī sīí dē nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","De cani dē nduhū, de sá de cahnī dē nduhū. Sochi nūū únī quīvī de natecū ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","De nduú ní jícūhun cuitī inī ndá dē ndá tūhun yáhá. Chi tūhun víjín cúu, de nduú ní ncúu jīcūhun inī dē jā cáhān yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","De nī ncuñatin yā cuāhān yā ñuū Jericó. De iin tēe cuáá ndéē dē yuhú íchí, jícān dē caridad. ");
INSERT INTO mieNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","De nī jini dē jā yáha cuāhā nchivī cuāhān ji, de nī jīcā tūhún dē nā cuá cúu jā cuáhān ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","De nī ncāhān ndá ji jíín dē jā Jesús, tēe ñuū Nazaret, yáha yā cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ñúcuán de nī ncana cóhó dē: Jesús, maá ní jā cúu ní tatā rey David, cundáhví inī ní sāán, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","De ndá nchivī jā cuáhān ichi núū, nī ncāhān ji nūū dē jā ná cásī dē yuhú dē. Sochi víhí cā nī ncana jee dē: Maá ní jā cúu ní tatā rey David, cundáhví inī ní sāán viī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","De nī jencuiñī Jesús, de nī ncachī yā jā ná quíji nchivī jíín dē. De tá nī nquenda dē, de nī jīcā tūhún yā dē: ");
INSERT INTO mieNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Nā cuá cúnī nū jā sāhá nī ndóhó? ncachī yā. De nī ncāhān dē: Jā ná ndúnijīn tīnūú sá cúnī sá, Señor, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","De nī ncāhān Jesús jíín dē: Ná ndúnijīn tīnūú nú túsaá. Chi nī ncandíja nú jā cuu nasāhá vāha nī ndóhó, de suu cúu jā ní nduvāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","De nī ndunijīn-ni tīnūú dē, de nī jēcuniquīn dē yā, de nácuetáhví dē nūū Yāā Dios. De ndihi nchivī jā ní jinī, suni nī ncāhān ji jā vāha ndasí Yāā cúu Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","De nī nquīvi Jesús inī ñuū Jericó, de nī nchāha yā-ni cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","De ñúcuán íyó iin tēe cuícá, nání dē Zaqueo, de cúñáhnú dē nūū ndá tēe stútú xūhún renta. ");
INSERT INTO mieNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","De cúnī dē cūndēhé dē ní iin cúu Jesús. Sochi nduú ní ncúu, chi cuāhā nchivī nī jasī ji nūū yā, de liquī dē-ni. ");
INSERT INTO mieNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","De jínu dē nī jēcōsō nūú dē. De nī ncaa dē xīnī iin tiūhndú tácua cunī dē nūū yā, chi ñúcuán yāha yā quīhīn yā. ");
INSERT INTO mieNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","De tá nī nquenda yā ñúcuán, de nī nūcūndēhé yā nūū dē, de nī ncāhān yā: Zaqueo, ñamā nuu nú, chi cánuú jā quendōo nī vehe nú mitan, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ñúcuán de ñamā-ni nī nuu dē, de nī ncusiī ndasí inī dē, de nī jeca dē yā cuāhān dē jíín yā vehe dē. ");
INSERT INTO mieNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","De nī jinī ndá nchivī jā súcuán nī ncuu, de nī ncāhān ji sīquī yā jā cuáhān yā ndōo yā vehe iin tēe sáhá cuāchi. ");
INSERT INTO mieNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ñúcuán de nī nūcuīñī Zaqueo, de nī ncāhān dē jíín maá Jētohō ō: Señor, mitan de ndihi ndatíñú jā névāha sá, cuāha sá sava nūū nchivī ndāhví, de tú nī scáa cā sá nī jīcān sá xūhún nūū nchivī, de nacuāha sá cūmī jā súcuán nūū ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","De nī ncāhān Jesús: Mitan de vehe yáhá ja nī ncācu iin tēe jā má tánū tāhvī dē, chi nī ncandíja dē tá cúu nūū ní ncandíja tatā dē Abraham. ");
INSERT INTO mieNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Chi nduhū, Yāā nī nduu tēe, vāji nī nánducú nī nchivī jā ní ntānū tāhvī, de scácu nī ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","De nūū ndá nchivī jā ní jini ndá tūhun yáhá nī ncāhān Jesús iin tūhun yátá jā stéhēn yā nāsa coo quīvī nenda yā. Chi ja nī ncuñatin yā Jerusalén, de jáni inī ndá ji jā mitan ñúhún quijéhé jā tatúnī yā sāhá Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","De nī ncāhān yā: Iin tēe cúñáhnú nī jēhēn jīcá dē incā nación, tácua nīhīn tīñú dē jā cuu dē rey, de nenda dē jā tatúnī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","De jondē ncháha ca quīhīn dē, de nī ncana dē ūxī mozo dē, de nūū iin iin ji nī jēhe dē iin xūhún jā ndéē yāhvi ndasí. De nī ncāhān dē jíín ji: Satíñú ndá nú tácua nducuahā xūhún yáhá juni quīhīn ni de nenda nī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","De ndá nchivī nación dē, quítī inī ji jínī ji dē, de nī ntají ji sava tēe ndíso tíñú, cuāhān yātā dē jā cāhān: Nduú jétahān inī nchivī ñuū sá jā cuāha ní tiñu nūū tēe yáhá jā cuu dē rey ndá sá, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","De vísō súcuán de nī nīhīn tīñú dē jā cuu dē rey, de nī nenda dē ñuū dē. De tá nī nenda dē de nī ndacu dē jā ná quíji ndá mozo jā ní jēhe dē xūhún nūū, tácua cunī dē nāsaa nī nīhīn iin iin ji sīquī. ");
INSERT INTO mieNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","De nī nquenda iin mozo nūū dē, de nī ncāhān ji: Señor, iin xūhún jā ní ntaji ní nūū sá, nī nduu ūxī, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","De nī ncāhān maá rey: Vāha mozo cúu nú, de vāha nī nsāhá nú. Chi nī squíncuu vāha nú jíín iin tiñu lúlí-ni, de mitan de sāhá nī jā cuñáhnú nú tatúnī nū nūū ūxī ñuū jā tíin nī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","De nī nquenda incā mozo, de nī ncāhān ji: Señor, iin xūhún jā ní ntaji ní nūū sá, nī nduu ūhūn, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","De suni nī ncāhān dē jíín mozo ñúcuán: De ndóhó, suni cuñáhnú nú tatúnī nū nūū ūhūn ñuū jā tíin nī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","De nī nquenda incā mozo, de nī ncāhān ji: Señor, yáhá nataji sá xūhún ní, chi nī nchuvāha sá inī iin pañito. ");
INSERT INTO mieNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Chi nī nchūhú sá ní, chi tēe xēēn cúu ní. Chi cuāhā cā náquehen ní nsūú cā jā ní ntaji ní, de cuāhā cā cúnī ní nsūú cā jā cuu sāhá mozo ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ñúcuán de nī ncāhān rey: Mozo nēhén cúu nú túsaá, de jíín tūhun jā ní ncachī nū yáhá de sāhá ndāā ni jā íyó cuāchi nú jāá nduú ní nsátíñú nú jíín xūhún nī. Chi jáni inī nū jā tēe xēēn cúu nī, de cuāhā cā náquehen nī nsūú cā jā ní ntaji nī, de cuāhā cā cúnī ni nsūú cā jā cuu sāhá mozo ni. ");
INSERT INTO mieNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Túsaá de nūcu nduú ní nchíhi nú xūhún nī vísō nūū banco? De tá nenda nī de nanihīn ni xūhún nī jondē jíín sēhe xūhún nícu, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ñúcuán de nī ncāhān dē jíín ndá nchivī íñí ñúcuán: Candeē nū xūhún jīñā nūū ji, de cuāha nú nūū mozo ja névāha ūxī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","De nī ncāhān nchivī ñúcuán jíín dē: Señor, nduú chi ja névāha dē ūxī, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","De nī ncāhān tucu rey: Cáhān ni jíín ndá nú jā nchivī ja névāha, sa quiji cā nūū ji, de cuāhā cā cunevāha ji. Sochi nchivī jāá nduú névāha, sa cujiyo-ni jacū jā névāha ji. ");
INSERT INTO mieNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","De ndá tēe jā jínī ūhvī nduhū, jāá nduú ní jétahān inī dē jā cuu nī rey dē, cuácuēca ndá nú dē quiji dē yáhá. De cahnī nū ndá dē cunī ni, ncachī dē, ncachī Jesús. ");
INSERT INTO mieNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","De tá nī ndihi nī ncāhān yā ndá tūhun yáhá, de nī jica cā yā jā cuáhān yā ciudad Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","De tá nī ncuñatin yā ñuū Betfagé jíín ñuū Betania, ñatin nūū íyó yucu nání Olivos, de nī ntají yā ūū tēe scuáha jíín yā jā quíhīn dē. ");
INSERT INTO mieNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","De nī ncachī yā nūū dē: Cuáhán ñuū lulí jā íyó ichi núū. De tá nī nquīvi nú de cunī nū iin burro núhnī tī, jā ni iin tēe ncháha ca cosō dē tī. De nandají nú tī quiji nú jíín tī. ");
INSERT INTO mieNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","De tú ní iin cātūhún nūcu nándají nú tī, de cachī nū: Maá Jētohō ō jíni ñúhún yā tī, cachī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","De cuāhān ndúū tēe jā ní ntají yā, de nī nīhīn dē tá nī ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","De tá nándají dē tī, de nī ncāhān ndá jētohō tī jíín ndúū dē: ¿Nūcu nándají nú burro nī? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","De nī ncāhān ndúū dē: Maá Jētohō ō jíni ñúhún yā tī. ");
INSERT INTO mieNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","De nī nenda ndúū dē jíín tī nūū Jesús. De nī nchisó ndá dē sōō dē sīquī burro, de nī nchisó dē Jesús sīquī tī. ");
INSERT INTO mieNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","De juni jíca yā cuāhān yā jíín tī, de scáā ndá nchivī sahma ji inī ichi. ");
INSERT INTO mieNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","De tá nī ncuñatin yā nūū cúun ichi yucu Olivos, de ndihi nchivī cándíja jā níquīn ji yā, nī nquijéhé ji cúsiī inī ji, de nácana jee ji Yāā Dios sīquī ndācá tiñu ñáhnú jā ní jinī ji nī nsāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","De cáhān ndá ji: Vāha ndasí Yāā cúu Rey jā váji jíín tiñu maá Jētohō ō Yāā Dios. Chi sáhá yā jā ndúmanī ō jíín Yāā Dios jā ndéē andiví, de viī ndasí cúñáhnú Yāā Dios, ncachī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ñúcuán de sava tēe fariseo jā íyó māhñú nchivī cuāhā, nī ncāhān dē jíín yā: Maestro, cāhān ní nūū ndá nchivī jā níquīn ji níhín jā ná cásī ji yuhú ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","De nī ncāhān Jesús: Cáhān ni jíín ndá nú jā tú ndá nchivī yáhá casī ji yuhú ji, de ndācá yūū chi cana jee, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","De tá nī ncuñatin yā Jerusalén, de nī ndēhé yā, de nī jacu yā sīquī. ");
INSERT INTO mieNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","De nī ncāhān yā: Ndá ndóhó nchivī Jerusalén, ndasí nī ncuu inī ni jā ná jícūhun inī nū jā cuu ndumanī nū jíín Yāā Dios sāhá nī. De sīquī jāá nduú cándíja ndá nú, de mitan chi mā cūú jīcūhun inī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chi quiji quīvī jā coo tūndóhó, de ndá nchivī jā jínī ūhvī ndóhó, cuicó ndúū ji ñuū nū, de casī cutú ji jíín yūū, de ndācá lado nenda ji sīquī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","De ndihi vehe scúnúu ji, de cahnī ji ndá nú. De mā sndóo ji ni iin vehe jā cosō tāhán cā yūū. Chi nī nquiji nī jondē nūū Yāā Dios jā scácu nī ndá nú, de nduú ní ncándíja nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","De nī nquīvi yā inī patio templo cāhnú, de nī nquijéhé yā távā yā ndá nchivī jā jéen quiti de náxīcó nūū nchivī jā sōcō ji. ");
INSERT INTO mieNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","De nī ncāhān yā jíín ji: Yósō nūū tutū īī jā cáhān Yāā Dios: Vehe nī chi vehe nūū jícān táhvī cúu, cáchī Yāā Dios. Sochi ndá ndóhó chi modo yavī cava jācuīhná nī nasāhá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","De ndiquivī nī stéhēn yā tūhun inī templo. De ndá sūtū cúñáhnú jíín ndá tēe stéhēn ley janahán jíín ndá tēe cúñáhnú nūū nchivī ciudad, ndúcú ndá dē modo nāsa cahnī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","De nduú ní níhīn dē modo sāhá dē, chi ndiviī nchivī jétáhví ndasí ji níni ji tūhun cáhān yā. ");
INSERT INTO mieNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","De iin quīvī stéhēn yā tūhun nūū ndá nchivī inī templo, de nácani yā tūhun jā scácu Yāā Dios nchivī. De ndá sūtū cúñáhnú, jíín tēe stéhēn ley janahán, jíín tēe ñáhnú jā ndácu tiñu, nī nquenda ndá dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","De nī jīcā tūhún dē yā: Cachī, ¿ní jondē nī nīhīn tīñú nú jā sáhá nú tiñu yáhá? ¿De ní iin nī ntee tiñu ndóhó jā sáhá nú súcuán? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","De nī ncāhān Jesús: Saá-ni nduhū suni cātūhún nī ndá nú iin tūhun. Cachī nūū ni: ");
INSERT INTO mieNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ní iin nī ntee tiñu sīquī Juan jā ní scuénduté dē? ¿A Yāā Dios, á ndá tēe? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ñúcuán de nī natúhún ndá máá dē: ¿Nāsa cāhān ō? Tú cachī ō jā Yāā Dios nī ntee tiñu ñúcuán sīquī Juan, de cāhān dē jíín ó: ¿Túsaá de nājēhē cúu jāá nduú ní ncándíja ndá nú jā ní ncāhān dē? ");
INSERT INTO mieNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","De tú cāhān ō jā nchivī nī ntee tiñu sīquī dē, de ndihi nchivī cahnī ji yóhó jíín yūū, chi cándíja ji jā tēe nī nacani tūhun Yāā Dios nī ncuu ndija Juan, ncachī ndá dē jíín táhán dē. ");
INSERT INTO mieNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","De nī ncāhān dē jíín Jesús jāá nduú jínī dē ní iin nī ntee tiñu sīquī Juan jā ní scuénduté dē. ");
INSERT INTO mieNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ñúcuán de nī ncāhān Jesús: De saá-ni nduhū, suni mā cāchí nī nūū nū ní iin nī ntee tiñu sīquī ni jā sáhá nī tiñu yáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","De nī nquijéhé Jesús cáhān yā tūhun yátá yáhá jíín nchivī: Iin tēe nī nchuhun dē cuāhā yūcū uva nūū ñuhun dē. De nī sndóo dē nūū sava tēe jā satíñú nūū, de cuu sava dē ndīhā jíín. De nī nquehen dē ichi jā cuáhān nahán dē incā ñuū. ");
INSERT INTO mieNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","De maá tiempo jā ndutútú uva, de nī ntají dē iin mozo cuāhān nūū ndá tēe sátíñú ñúcuán, tácua naquehen dē sava ndīhā uva. De ndá tēe ñúcuán nī ncani dē mozo, de nī natají uun dē ji cuānohōn ji. ");
INSERT INTO mieNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","De tēe xíí uva nī ntají dē incā mozo cuāhān. De ndá tēe sátíñú, suni nī ncāhān nāvāha dē nūū ji, de nī ncani dē ji, de nī natají uun dē ji cuānohōn ji. ");
INSERT INTO mieNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","De tēe xíí uva nī ntají tucu dē incā mozo cuāhān. De ndá tēe sátíñú suni nī stácuēhé dē mozo ñúcuán, de nī scúnu dē. ");
INSERT INTO mieNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ñúcuán de nī ncāhān tēe xíí uva: ¿Nāsa sāhá nī? Ná tájí nī sēhe nī, sūchí jā mānī ni jíín, chi sanaā de cuetáhví ndá dē ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sochi ndá tēe sátíñú, tá nī jinī dē jā váji ji, de nī ncāhān ndá dē: Tēe xíí táhvī cúu jā váji ñúcuán. Ná cáhnī ō ji, de ndōo tāhvī ji coo ó, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","De nī ntavā ndá dē ji yuhú ñúhún, de nī jahnī dē ji, ncachī yā. Ñúcuán de nī jīcā tūhún yā ndá dē: ¿Túsaá de nāsa sāhá tēe xíí uva jíín ndá tēe sátíñú? ");
INSERT INTO mieNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nenda dē de cahnī dē ndá tēe ñúcuán, de cuāha dē ñuhun jā cáá uva nūū sava cā tēe satíñú nūū, ncachī yā. De tá nī jini ndá nchivī tūhun yáhá, de nī ncāhān ji: Aī, vāha de tú mā cōó cuitī súcuán viī, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","De ndéhé maá yā nūū ji, de nī ncāhān yā: ¿Túsaá de á jícūhun inī ndá nú tūhun yáhá jā yósō nūū tutū īī, jā nduhū cúu tá cúu iin yūū? Chi cáchī tutū: Yūū jā ní squéne yichī ndá tēe jā sáhá vehe, yūū yáhá nduu jā quituu squínā vehe. Cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","De nchivī jāá nduú cándíja, ndoho ji tá cúu nūū ndóho nchivī jā jícó cáva sīquī yūū de táhnū ji. De quīvī jā sāhá ndāā Yāā Dios cuāchi, de nchivī jāá nduú ní ncándíja, cundoho ji tá cúu nūū ndóho nchivī jā níncava iin yūū sīquī ji de cúndihī ji sáhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ñúcuán de ndá sūtū cúñáhnú jíín ndá tēe stéhēn ley janahán, cúnī dē tiin dē yā maá hora ñúcuán. Chi nī jīcūhun inī ndá dē jā sīquī ndá máá dē cúu jā ní ncāhān yā tūhun yátá sīquī ndá tēe jā sátíñú nūū uva jíín ndá tēe sáhá vehe. Sochi nduú ní ncúu tiin dē yā, chi yúhú dē jā quītī inī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ñúcuán de nī ntají ndá dē sava tēe cuāhān jā cūndēhé yuhū dē yā. De tēe ñúcuán chi sáhá-ni ndá dē jā tēe ndāā cúu dē. De ndúcú dē sāhá dē jā cāhān yā iin tūhun jā nīhīn dē cuāchi sīquī yā, de quīsiáha dē yā nūū tēe cúu gobernador. ");
INSERT INTO mieNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","De nī ncāhān ndá dē jíín yā: Maestro, jínī ndá sá jā cáhān vāha ní, de ndāā stéhēn ní. De nduú sáhá ní cuenta nāsa cúu iin iin nchivī, chi inuú-ni sáhá ní jíín ndá ji. De stéhēn ndāā ní nāsa squíncuu nchivī nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Túsaá de cachī ní: ¿A íyó vāha jā chunáá ó xūhún renta nūū rey nación Roma jā tíin nación maá ó, á nduú? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","De nī jinī yā jā cúnī ndá dē stáhví dē yā, de nī ncāhān yā jíín dē: ¿Nājēhē cúu jā jíto túnī ndá nú nduhū? ");
INSERT INTO mieNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Stéhēn iin xūhún ná cúndēhé nī. ¿Nā tēe cúu jā ndéē nūū xūhún yáhá, de nā síví cúu jā ndéē yáhá? De nī ncāhān ndá dē: Rey ñúcuán cúu. ");
INSERT INTO mieNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ñúcuán de nī ncāhān yā jíín ndá dē: Túsaá de nacuāha nú nūū rey ñúcuán jā cúu cuenta dē, de nacuāha nú nūū Yāā Dios ndācá jā cúu cuenta maá yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","De ndá tēe ñúcuán nduú ní ncúu nīhīn dē cuāchi sīquī yā jíín ni iin tūhun jā cáhān yā, nī jinī ndá nchivī. De nī nsāhvi inī ndá dē jā ndíchí nī scócóo yā tūhun ñúcuán, de nduú cā ní ncáhān dē. ");
INSERT INTO mieNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ñúcuán de sava tēe grupo saduceo nī nquenda dē nūū yā. De ndá tēe ñúcuán cáchī dē jāá nduú nátecū cuitī ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","De nī ncāhān dē jíín yā: Maestro, de Moisés nī ntee dē nūū tutū jā névāha ó: Tú iin tēe cuū dē, de ndōo ñasíhí dē, de tú nduú ní íyo sēhe dē jíín ña, túsaá de cánuú jā ñanī dē nacueca ñasíhí dē, de sēhe dē jā coo jíín ña nūcuīñī ji nūū ndīyi ñanī dē, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Túsaá de nī īyo ūjā ñanī. De tēe xíhna ñúhún nī jeca dē iin ñahan. De nī jīhī dē, de nduú nā sēhe dē ní íyo. ");
INSERT INTO mieNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","De tēe uū nī nacueca dē ña. De suni nī jīhī dē, de nduú nā sēhe dē ní íyo. ");
INSERT INTO mieNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","De saá-ni tēe unī nī nacueca dē ña, de jondē jíín ndihújā dē, de nī jīhī ndá dē, de ni iin dē nduú nā sēhe dē ní íyo. ");
INSERT INTO mieNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","De jā sándīhí de nī jīhī ñahan ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Túsaá de quīvī natecū ndīyi, ¿de ní iin dē cuu ña ñasíhí dē? Chi ndihújā dē nī ndeē jíín ña, ncachī ndá tēe saduceo. ");
INSERT INTO mieNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ñúcuán de nī ncāhān Jesús jíín ndá dē: Ñayīví yáhá chi quétáhán tēe jíín ñahan. ");
INSERT INTO mieNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","De ndá nchivī vāha jā natecū ji de quīvi ji andiví, mā cuēcá cā ji táhán ji ñúcuán, chi nduú cā nā tūhun jā quétáhán tēe jíín ñahan coo. ");
INSERT INTO mieNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","De ni mā cúū cuitī cā ji, chi coo ji tá cúu ndá ángel Yāā Dios. De sēhe Yāā Dios cuu ji, chi ja nī natecū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","De suni maá Moisés cáhān dē jā natecū ndīyi, chi nī ntee dē nūū tutū nāsa nī ncāhān yā jíín dē māhñú yūcū jā cáyū ñuhūn. Chi nī ncāhān dē jā cúu yā Yāā Dios ndīyi Abraham jíín Isaac jíín Jacob. De jā ní ncāhān dē súcuán cúu jā cáchī dē jā técū ndá ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Chi vísō ja nī jīhī ndá ji, sochi técū ji nūū íyó maá yā, chi cúu yā Yāā jā sáhá jā técū nchivī níí cání, ncachī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","De jacū tēe stéhēn ley janahán nī ncāhān dē: Vāha nī ncāhān ní Maestro, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","De nduú cā ní nchúndeé inī ndá dē jā cātūhún dē yā. ");
INSERT INTO mieNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","De nī ncāhān yā jíín ndá dē: ¿Nāsa cúu jā cáchī nchivī jā Cristo cúu tatā rey David? ");
INSERT INTO mieNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Chi maá David súcuán nī ncāhān dē tūhun yā nūū tutū Salmo: Maá Jētohō ō Yāā Dios nī ncāhān yā jíín Jētohō ni, Yāā quiji: Cundeē nū lado cuáhá nī nūū cuñáhnú nú, ");
INSERT INTO mieNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","de ná sáhá nī jā candeē nū poder ndācá jā jínī ūhvī ndóhó. Ncachī Yāā Dios. Ncachī David. ");
INSERT INTO mieNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Túsaá de vísō chījin tatā David cacu Cristo, de nī ncāhān dē Jētohō dē yā, chi jondē nūū Yāā Dios vāji yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","De nī ncāhān yā jíín ndá tēe scuáha jíín yā, de suni nī jini ndá nchivī: ");
INSERT INTO mieNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Coto má cándíja ndá nú ndá tēe stéhēn ley janahán. Chi cúsiī inī ndá dē jíca nuu dē jíín sahma cání jā stéhēn jā cúñáhnú dē, jíín jā cáhān yíñúhún nchivī dē nūū yáhvi. De jétahān inī ndá dē cundeē dē nūū silla yíñúhún cā inī vehe īī sinagoga, jíín silla yíñúhún cā nūū íyó vico jā yájī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","De cándeē dē vehe ndá ñahan quéndōo ndáhví. De nahán jícān táhvī dē tácua cani inī nchivī jāá nduú nā cuāchi dē. Ndá tēe yáhá chi sa víhí cā ndoho dē castigo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","De íyó yā inī templo, de nī jinī yā nūū ndá nchivī cuīcá jā chúhun ji cuāhā xūhún inī ndá jātūn nūū sócō ji. ");
INSERT INTO mieNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","De suni nī jinī yā nūū iin ñahan viuda jā ndóho ndáhví. De nī nchuhun ña ūū centavo lulí inī iin jātūn. ");
INSERT INTO mieNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","De nī ncāhān yā: Ndāā cáhān ni jíín ndá nú jā cuāhā cā nī nsōcō ñahan viuda ndāhví yáhá nsūú cā jā ní nsōcō ndá cā nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chi ndá máá ji nī nsōcō ji jā ní ndōo nūū xūhún cuáhā ji. De ñahan yáhá, vísō ndáhví ndóho ña, de nī nchuhun ña ndihi jā cutecū ña, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","De sava dē nī ncāhān dē jā viī cáá templo cāhnú, chi nī ncuvāha jíín ndācá yūū viī jíín ndācá jā ní nsōcō nchivī. Ñúcuán de nī ncāhān yā: ");
INSERT INTO mieNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ndihi jā ndéhé ndá nú yáhá, quiji quīvī jā má cósō tāhán cā ni iin yūū, chi ndihi tānī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","De nī jīcā tūhún ndá dē yā: Maestro, ¿nā quīvī coo ndācá jā ní ncachī ní jā coo? ¿De nā seña coo tá ja ñatin squíncuu ndá jā ní ncachī ní? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","De nī ncāhān yā: Coto má stáhví ndá nchivī ndóhó. Chi quiji cuāhā tēe jíín síví nī jā stáhví, de cāhān dē: Maá nī cúu Cristo. De suni cāhān dē: Ja nī nquenda quīvī ndihi ñayīví, cachī dē. De mā cándíja ndá nú dē. ");
INSERT INTO mieNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","De tá nīhīn nū tūhun jā ndācá lado íyó guerra jíín jā nénda nchivī sīquī ndá tēe ndíso tíñú, de mā cúyūhú nú, chi cánuú jā xihna cā súcuán coo, de ni mā jínu ñamā quīvī jā ndihi ñayīví, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","De nī ncāhān cā yā: Nenda nación sīquī incā nación, de nenda ñuū sīquī incā ñuū jā canāá. ");
INSERT INTO mieNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","De cháhá chúcuán tāan ndasí, de coo tāmā jíín cuēhē xēēn. De coo ndá seña cāhnú ichi andiví jā cuyūhú ndasí nchivī cunī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","De jondē ncháha ca coo ndá tiñu yáhá, de cunī ūhvī ji ndá nú, de tiin ji ndóhó. De quīsiáha ji sava nú ndācá vehe īī sinagoga jā cāhān ji cuāchi sīquī nū. De chihi ji sava nú vecāa. De quīsiáha ji sava nú nūū ndá rey jíín gobernador, de cāhān ji cuāchi sīquī nū sīquī jā cándíja nú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","De jā súcuán coo, de cūtē nuu cā tūhun nī, chi nacani nú nūū ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Túsaá de cuhun inī ndá nú jā má nácani tūha inī nū nāsa scócóo nú tūhun nūū ndá dē jā cācu nú. ");
INSERT INTO mieNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chi maá nī taji nī tūhun ndíchí jā cāhān nū, tácua nchivī jā jínī ūhvī ndóhó, mā cúndéé ji jíín nú ni mā cūú cāhān ji sīquī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","De jondē tatá ndá nú, naná nú, ñanī nū, táhán nú, jíín amigo nū, nastúu ji ndóhó nūū nchivī xēēn. De sava nú cahnī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","De ndācá nchivī chi quītī inī ji nūū nū jā síquī nduhū. ");
INSERT INTO mieNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sochi ni iin ixi xínī nū mā náā, chi coto yā ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","De tú cuiñi nīhin nú jíín tūhun nī, de cutecū nū níí cání. ");
INSERT INTO mieNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","De tá nī jinī nū jā ní jicó ndúū ndá soldado yúñúū Jerusalén, de jīcūhun inī nū jā ja ñatin naā ciudad ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ñúcuán de nchivī ndéē Judea, ná cúnu ji caa ji yucu quīhīn ji. De nchivī ndéē Jerusalén, ná quée ji quīhīn ji. De nchivī ndéē jondē rancho, mā nándicó ji ciudad. ");
INSERT INTO mieNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chi ndá quīvī ñúcuán cuāha Yāā Dios castigo nūū nchivī jā síquī cuāchi ji, tácua quee ndaā ndá tūhun jā yósō nūū tutū. ");
INSERT INTO mieNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","De quīvī ñúcuán nācā ndáhví ndoho ndá ñahan ñúhún sēhe, jíín ñahan ndéca ñiquín, chi mā cūú cunu ñamā ña. Chi xēēn ndasí coo tūndóhó inī ñayīví, de quiji castigo xēēn sīquī nchivī yáhá. ");
INSERT INTO mieNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","De sava ji cuū nūū guerra, de sava ji quīhīn preso jondē ndá cā nación. De nchivī ndá cā nación tatúnī nīhin ji nūū nchivī Jerusalén, jondē ndihi tiempo jā jéhe Yāā Dios tūhun jā tátúnī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ñúcuán de coo seña nūū ncandiī jíín nūū yōō jíín nūū tiūūn. De inī ñayīví de quiji tūndóhó xéēn sīquī nchivī ndācá nación. De cunēhén inī ji de cuyūhú ji jā nihin xeēn mar de scuísō ndasí ndute mar. ");
INSERT INTO mieNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","De cuū sōó sava nchivī jā cuyūhú ji jā ndétu ji ndācá tūndóhó jā quiji sīquī ñayīví. De jondē ndācá jā jíca andiví chi quisi. ");
INSERT INTO mieNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ñúcuán de cunī ndá nchivī nūū maá nī, Yāā nī nduu tēe, nenda nī jíín vīcō, de cundiso nī cuāhā poder, de viī ndasí cuñáhnú nī. ");
INSERT INTO mieNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","De tá nī nquijéhé ndá tiñu yáhá, de ndeé coo inī ndá nú, de cunuū nū andiví, chi ja ñatin scácu yā ndá nú, ncachī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","De suni nī ncāhān yā tūhun yátá yáhá: Cūndēhé ndá nú nāsa sáhá ñutun higo jíín ndá cā ñutun. ");
INSERT INTO mieNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tá jínī ndá nú jā ní nquijéhé nácōco yūcū ji, de ja jínī nū ja nī ncuñatin tiempo ihní. ");
INSERT INTO mieNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","De suni súcuán tá cunī ndá nú jā ní nquijéhé ndá tiñu yáhá, ñúcuán de jīcūhun inī nū ja nī ncuñatin quīvī tatúnī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","De ndāā cáhān ni jíín ndá nú jā má cúū ndihi nchivī jā cunī ndá tūndóhó yáhá, chi jondē quee ndaā ndihi tá ncachī ni. ");
INSERT INTO mieNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Andiví jíín ñayīví chi naā, sochi ndācá tūhun cáhān ni mā náā, chi quee ndaā ndihi. ");
INSERT INTO mieNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","De coto má stíví ndá nú maá nú jā sāhá nú ndá cuāchi, jíín jā jīni nú, jíín jā cutéñú nú jíín ndācá jā cutecū nū, tácua mā quījí quīvī ñúcuán iin sanaā-ni sīquī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chi tá cúu nūū núu iin trampa, súcuán jīnū tūndóhó sīquī nchivī jā ndéē níí cáhnú ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tú súcuán de ndito coo nú, de níní cācān táhvī nū, tácua cuu cācu nú nūū ndācá tūndóhó jā quiji, de cuu cuiñi nú nūū maá nī, Yāā nī nduu tēe, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","De ndiquivī stéhēn yā tūhun inī templo, de ndācá jacuáā nī jēndōo yā yucu nání Olivos. ");
INSERT INTO mieNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","De ndācá stēēn nehēn quíji ndá nchivī nūū yā inī templo jā cunini ji tūhun stéhēn yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ñúcuán de nī ncuñatin vico pascua jā yájī nchivī stātílā jāá nduú nā levadura yíhí. ");
INSERT INTO mieNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","De ndá sūtū cúñáhnú jíín ndá tēe stéhēn ley janahán, nī nducú yuhū dē modo nāsa cahnī dē Jesús, chi yúhú ndá dē jā quītī inī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","De nī nquīvi Satanás inī ánō Judas jā nastúu dē yā. De suni nání dē Iscariote, de cúu dē iin táhán ndihúxī ūū tēe apóstol. ");
INSERT INTO mieNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","De nī jēhēn dē nī natúhún dē jíín ndá sūtū cúñáhnú jíín ndá tēe ndíso tíñú inī templo jā nāsa nastúu dē yā nūū ndá tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","De nī ncusiī inī ndá dē, de nī nquee yuhú dē jā cuāha dē xūhún nūū Judas. ");
INSERT INTO mieNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","De nī jetáhví Judas, de nī nducú dē modo nāsa nastúu yuhū dē yā hora jāá nduú nā nchivī íyó. ");
INSERT INTO mieNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","De nī nquenda maá quīvī vico jā yájī nchivī stātílā jāá nduú nā levadura yíhí, de suni quīvī ñúcuán jáhnī ji tīcāchí lúlí tá cúu nūū ní ndacu Yāā Dios jā sāhá ji vico pascua. ");
INSERT INTO mieNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","De Jesús nī ntají yā Pedro jíín Juan quīhīn dē, de nī ncāhān yā jíín dē: Cuáhán de sāhá tūha nú jā cuxíní ó vico pascua, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","De nī jīcā tūhún ndúū dē yā: ¿Ní cúu nūū cúnī ní jā quísāhá tūha sá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","De nī ncāhān yā jíín dē: Cuáhán ndúū nū ñuū ñúcuán de tá nī nquīvi nú de jēcutáhán nú jíín iin tēe ndíso quīyi ndute. De cuniquīn nū dē quīhīn nū jíín dē vehe nūū ndīvi dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","De cāhān nū jíín tēe xívéhe ñúcuán: Vāji sá cáchī Maestro: ¿Ní iin cuarto vehe ní cuāha núú ní jā cuxíní yā vico pascua jíín ndá tēe scuáha jíín yā? cachī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ñúcuán de stéhēn dē iin cuarto cāhnú jondē xīnī vēhé nūū ja íyó tūha, de ñúcuán sāhá tūha nú jā cuxíní ó, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","De cuāhān ndúū dē, de nī nīhīn dē tá cúu nūū ní ncachī yā. De nī nsāhá tūha dē jā cuxíní yā vico pascua. ");
INSERT INTO mieNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ñúcuán de nī nquenda hora jā cuxíní, de nī nquenda Jesús, de nī jēcundeē yā nūū mesa jíín ndá tēe cúu apóstol. ");
INSERT INTO mieNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","De nī ncāhān yā jíín ndá dē: Nī ncuu ndasí inī ni jā cuxíní nī jíín ndá nú vico pascua yáhá, mitan ncháha ca cuū ni. ");
INSERT INTO mieNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chi cáhān ni jíín nú jā má cājí cuitī cā ni vico pascua, chi jondē tá quenda quīvī jā tatúnī Yāā Dios níí ñayīví, sá de cajī tucu nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","De nī nquehen yā iin vaso ndūxi uva, de xihna cā nī nacuetáhví yā nūū Tatá yā, de nī ncāhān yā: Quehen ndá nú vaso yáhá, de coho nú jíín táhán nú. ");
INSERT INTO mieNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chi cáhān ni jíín ndá nú jā jondē mitan de mā cōhó cā ni ndūxi uva, chi jondē quenda quīvī jā tatúnī Yāā Dios níí ñayīví, sá de coho tucu nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","De nī nquehen yā stātílā, de nī nacuetáhví yā, de nī scuáchi yā, de nī jēhe yā nūū ndá dē. De nī ncāhān yā: Yáhá cúu yiqui cúñu nī jā sōcō ni jā chunáá nī cuāchi ndá nú. De níní cajī ndá nú súcuán jā nūcūhun inī nū jā ní jīhī ni jā jéhē nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","De suni súcuán nī nsāhá yā jíín vaso ndūxi uva, tá nī ncuu nī ncuxíní yā. De nī ncāhān yā: Yáhá cúu nīñī ni jā sōcō ni jā cúu trátū jeé, de cati jā ndundoo cuāchi ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","De mitan chi tēe nastúu nduhū, ndéē dē jíín nī nūū mesa yáhá. ");
INSERT INTO mieNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chi nduhū, Yāā nī nduu tēe, jāndáā cúu jā quíhīn ni cuū ni, tá cúu nūū ní nsāhá ndāā Yāā Dios jā súcuán coo. De nācā xēēn cundoho tēe jā nastúu nduhū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ñúcuán de nī nquijéhé ndá dē jícā tūhún táhán dē ní iin dē cúu jā nastúu dē yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ñúcuán de nī ncāhān ndasí ndá dē sīquī ní iin dē cúñáhnú cā nūū táhán dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","De nī ncāhān Jesús jíín ndá dē: Rey ndācá nación chi ndácu nīhin ndá dē tiñu nūū nchivī jā tíin dē, de cáhān ndá ji jā tēe sáhá vāha cúu ndá tēe jā cúñáhnú nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sochi ndá máá nú, chi mā cōó nú súcuán. Chi tú ní iin nú cúñáhnú cā, de sa nasāhá lulí nú maá nú. De tú ní iin nú ndácu tiñu, de sa nasāhá nú maá nú tēe jā jétíñú táhán. ");
INSERT INTO mieNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿De ní iin cúu jā cúñáhnú cā, á tēe yájī nūū mesa, á tēe jáni cōhō? ¿A nsūú tēe jā yájī nūū mesa cúu jā cúñáhnú cā? Sochi nduhū, nsūú súcuán cúu nī, chi nī nasāhá nī maá nī tá cúu tēe jā jétíñú nchivī, chi vāji nī sáhá nī jā nīhīn táhvī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","De ndá máá nú cúu tēe jā níní íyó jíín nī ndācá quīvī jā ndóho nī tūndóhó. ");
INSERT INTO mieNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Túsaá de tá cúu nūū ní nsāhá Tatá nī jā tatúnī ni, suni súcuán sāhá nī jā tatúnī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","De cajī ndá nú coho nú jíín nī inī ñuū nūū tatúnī ni. De cundeē nū iin iin mesa jā sāhá ndāā nū tiñu ndihúxī ūū tatā Israel, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","De suni nī ncāhān maá Jētohō ō jíín Simón Pedro: Simón, cunini nú, chi nī jīcān Satanás ndá nú jā coto túnī ji ndóhó tá cúu nūū síjin trigo, de stúu ní iin nú cúu modo paja jā nayūhú nú, de ní iin nú cúu modo trigo jā cándíja nīhin nú. ");
INSERT INTO mieNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","De nī jīcān táhvī ni jēhē nū, tácua mā náyūhú nú jā má cándíja cā nū. De tá nī nacani tucu inī nū, de scúja nú inī ndá táhán nú jíín tūhun nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","De nī ncāhān dē jíín yā: Señor, ja íyó tūha sá jā quīhīn sá jíín ní vecāa vísō ná cúū sá jíín ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","De nī ncāhān yā: Pedro, cáhān ni jíín nú jā jondē ncháha ca cana lohló mitan, de yūhú nú jā tiin nchivī ndóhó, de cachī nū ūnī vuelta jāá nduú jínī nū nduhū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ñúcuán de nī jīcā tūhún yā ndá dē: Tá nī ntají nī ndá nú nī jēhēn nū jāá nduú ní ndíso nú ñunu ni itīn xūhún ni nījān, ¿de á nī īyo iin jā ní ncumanī nūū nū? ncachī yā. De nī ncāhān ndá dē: Ni iin nduú ní ncúmanī. ");
INSERT INTO mieNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","De nī ncāhān yā: Sochi mitan de sa cáhān ni jā cundiso nú ñunu nú, de saá-ni itīn xūhún. De tēe jāá nduú névāha espada jā coto dē maá dē, ná xícó dē sōō dē de quehen dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Chi cáhān ni jíín ndá nú jā quiji quīvī jā cundoho ó tūndóhó, chi cánuú quee ndaā tūhun yáhá jā cáhān nūū tutū sīquī ni: Sāhá nchivī jíín yā tá cúu nūū sáhá ji jíín ndá tēe sáhá cuāchi xēēn, cáchī tutū. Chi ndācá tūhun yósō ñúcuán jā cáhān sīquī ni, quee ndaā ndihi, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ñúcuán de nī ncāhān ndá dē: Señor, yáhá íyó ūū espada, ncachī dē. De nī ncāhān yā jíín ndá dē: Ja ndóo cā yáhá-ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","De nī nquee yā cuāhān yā yucu Olivos, tá-ni sáhá yā. De ndá tēe scuáha jíín yā, nī jēcuniquīn dē yā cuāhān dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","De tá nī nquenda yā ñúcuán, de nī ncāhān yā jíín dē: Cācān táhvī ndá nú jā chindeé yā ndóhó jā má sāhá nú cuāchi tá coto túnī jānēhén ndóhó, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","De nī jica yā jacū nūū ndá dē, tá iin medida jā quenda yūū jā squéne ó. De nī jēcuīñī jītí yā, de nī jīcān táhvī yā suha: ");
INSERT INTO mieNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Tatá, tú cúnī ní de sāhá jíyo ní tūndóhó yáhá jā má quījí sīquī sá. Sochi nsūú jā cúnī maá sá, chi jā cúnī maá ní ná cóo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","De nī nquenda iin ángel andiví nūū yā, de nī jēhe fuerza nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","De ndóho yā chi cúcuécá ndasí inī yā jā quiji tūndóhó sīquī yā, de nī nducú ndéé cā yā nī jīcān táhvī yā. De nī jēhe tāān yā, de tóo nūū ñūhún modo yúyú náhnú nīñī. ");
INSERT INTO mieNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","De tá nī nacuiñī yā jā ní jīcān táhvī yā, de nī nenda yā nūū ndá tēe scuáha jíín yā. De nī jinī yā jā quíxīn ndá dē, chi nduú cā íyó ndeé inī dē cācān táhvī dē sīquī jā cúcuécá ndasí inī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","De nī ncāhān yā jíín dē: ¿Nūcu quíxīn ndá nú? Nacōo de cācān táhvī nū jā chindeé yā ndóhó jā má sāhá nú cuāchi jā coto túnī jānēhén ndóhó, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","De juni cáhān cā yā súcuán, de nī nquenda cuāhā nchivī. De tēe nání Judas, iin táhán jā úxī ūū tēe scuáha jíín yá, yósō nūú dē nūū nchivī vāji dē. De nī nquenda dē jondē nūū Jesús, de nī ntechuhú dē yā, de súcuán nī nastúu dē yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","De nī ncāhān Jesús jíín dē: Judas, ¿á jíín jā téchuhú nú nduhū cúu jā nástúu nú nduhū, Yāā nī nduu tēe? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","De ndá tēe íyó jíín yā, nī jinī dē jā súcuán nī nquijéhé cúu, de nī ncāhān dē jíín yā: Señor, ¿á nenda ndá sá sīquī ndá dē jíín espada? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","De iin dē nī stácuēhé dē mozo maá sūtū cúñáhnú cā, chi nī jehndē dē sōho lado cuáhá. ");
INSERT INTO mieNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","De nī ncāhān Jesús: Siáā, ná jéncuiñī, ncachī yā. De nī ntee yā ndahá yā sōho mozo, de nī nasāhá vāha yā dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sá de nī ncāhān yā jíín ndá sūtū cúñáhnú jíín ndá tēe ndíso tíñú inī templo jíín ndá tēe ñáhnú jā ní nquenda ndá dē jā tiin dē yā: ¿De va tēe cuíhná cúu nī jā váji ndá nú sīquī ni jíín machete jíín ñutun, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ndācá quīvī nī īyo nī jíín ndá nú inī templo cāhnú, de nduú ní ntíin ndá nú nduhū. De mitan de nī nquenda hora jā tiin nú nduhū jíín jā sāhá nú ndá tiñu jā ndácu jānēhén jā ndéē nūū neē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","De nī ntiin ndá dē yā cuāhān dē jíín yā vehe sūtū cúñáhnú cā. De Pedro chi jícá-ni níquīn dē yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","De ndá policía nī stáhān dē ñuhūn inī patio, de nī jicó ndúū dē yúñúhūn ndéē dē. De suni nī jēcundeē Pedro jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","De iin ñahan sátíñú vehe ñúcuán, nī jinī ña nūū dē jā ndéē dē yúñúhūn. De nī ndēhé vāha ña nūū dē, de nī ncāhān ña: Tēe yáhá chi suni nī jica dē jíín tēe ñúcuán, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","De maá dē nduú ní ncáchī dē, chi nī ncāhān dē: Nduú jínī ni tēe ñúcuán tíhī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","De nī ncunúú jacū cā, de nī jinī tucu incā dē nūū Pedro, de nī ncāhān dē: Ndóhó chi suni táhán ndá tēe ñúcuán cúu nú, ncachī dē. De nī ncāhān Pedro: Nsūú cúu nī lílū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","De nī ncuu tá iin hora cā, de nī ncāhān nīhin incā dē: Jāndáā ndija jā tēe yáhá nī jica dē jíín tēe ñúcuán, chi suni tēe región Galilea cúu dē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","De nī ncāhān Pedro: Nduú jínī cuitī ni nā tūhun cáhān nū lílū, ncachī dē. De juni súcuán cáhān cā dē, de nī ncana-ni lohló. ");
INSERT INTO mieNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ñúcuán de nī ndicó cóto maá Jētohō ō, de nī ndēhé yā nūū Pedro. De nī nūcūhun inī dē tūhun jā ní ncāhān yā jíín dē: Jondē tá ncháha ca cana lohló, de yūhú nú de cachī nū ūnī vuelta jāá nduú jínī nū nduhū. ");
INSERT INTO mieNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","De nī nquee dē cuāhān dē, de nī jacu ndasí dē jā ní ncachī dē jāá nduú jínī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","De ndá tēe jā jíto Jesús, nī nsāhá catá dē nūū yā, de nī ncani dē yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","De nī jasī ndá dē nūū yā, de nī ncani dē nūū yā, de nī ncāhān dē: Cachī, ní iin cúu jā ní ncani ndóhó, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","De cuāhā cā tūhun súcuán nī ncāhān nāvāha ndá dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","De tá nī ncunijīn, de nī ncutútú ndá tēe ñáhnú jā ndácu nūū nchivī hebreo, jíín ndá sūtū cúñáhnú, jíín ndá tēe stéhēn ley janahán. De cuāhān ndá dē jíín yā nūū junta, de ñúcuán de nī jīcā tūhún dē yā: ");
INSERT INTO mieNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Cachī, ¿á maá nú cúu Cristo jā ní ntají Yāā Dios? ncachī dē. De nī ncāhān yā jíín dē: Vísō ná cáchī ni jā suu nī cúu, de mā cándíja cuitī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","De saá-ni tú cātūhún maá nī ndá ndóhó, de suni mā scócóo nú nūū ni, ni mā siáā nū nduhū. ");
INSERT INTO mieNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","De nduhū, Yāā nī nduu tēe, ndācá quīvī jā quiji de cundeē ni lado cuáhá maá Yāā íyó poder, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ñúcuán de ndihi dē nī jīcā tūhún dē yā: ¿De á maá nú cúu Sēhe Yāā Dios túsaá? ncachī dē. De nī ncāhān yā jíín dē: Suu cúu nī, tá cúu nūū cáhān ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ñúcuán de nī ncāhān ndá dē: ¿Nā testigo cā jíni ñúhún ó túsaá? Chi nī jini ndācá ó jíín yuhú maá dē jā cáhān nāvāha dē jā cúu dē Sēhe Yāā Dios, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ñúcuán de nī nacuiñī ndihi ndá dē, de cuāhān dē jíín yā nūū Pilato. ");
INSERT INTO mieNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","De ñúcuán nī nquijéhé ndá dē cáhān tūhún dē cuāchi sīquī yā: Nī nīhīn ndá sá tēe yáhá jā snénda dē nchivī sīquī ndá tēe cúñáhnú. De cáhān dē jāá nduú vāha jā cuāha ndá sá xūhún renta nūū rey nación Roma jā tátúnī nūū nación sá. De suni cáhān dē jā maá dē cúu Cristo, Rey jā ní ntají Yāā Dios, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ñúcuán de Pilato nī jīcā tūhún dē yā: ¿A maá nú cúu Rey nchivī hebreo? De nī ncāhān yā: Suu cúu nī, tá cúu nūū cáhān nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","De nī ncāhān Pilato jíín ndá sūtū cúñáhnú jíín ndá nchivī cuāhā: Nduú ni iin tūhun stíví cáhān tēe yáhá jā nīhīn ni cuāchi sīquī dē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","De víhí cā nī ncāhān ndá dē: Tēe yáhá snénda ndasí dē nchivī sīquī ndá tēe cúñáhnú jíín tūhun jā stéhēn dē níí Judea. Chi nī nquijéhé dē stéhēn dē jondē Galilea de mitan de jondē yāhá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","De tá nī jini Pilato jā Galilea cáhān ndá dē, de nī jīcā tūhún dē tú tēe región Galilea cúu yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","De tá nī ncachī ndá dē jā cúu yā tēe Galilea, de nī ndacu dē jā ná quíhīn ndá dē jíín yā nūū Herodes, tēe cúu gobernador Galilea. Chi quīvī ñúcuán suni íyó Herodes Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","De tá nī jinī Herodes nūū Jesús, de nī ncusiī ndasí inī dē, chi ja nī ncuu cuāhā tiempo jā cúnī dē cūndēhé dē yā. Chi nī nīhīn dē tūhun yā, de ñúhún inī dē jā sāhá yā iin tiñu ñáhnú cunī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","De nī jīcā tūhún dē yā cuāhā tūhun, de nduú ní scócóo yā ni iin tūhun nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","De suni íñí ndá sūtū cúñáhnú jíín ndá tēe stéhēn ley janahán, de nīhin nī ncāhān ndá dē cuāchi sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ñúcuán de Herodes jíín ndá soldado dē nī ncāhān nēhén dē jíín yā, de nī nsāhá catá dē nūū yā, chi nī nchuhun dē yā iin sahma fino jā cúu sahma rey. De Herodes nī ndacu dē jā ná quínasiáha dē yā nūū Pilato. ");
INSERT INTO mieNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","De maá quīvī ñúcuán nī ndumanī tāhán Pilato jíín Herodes, chi quīvī yātā nī nquītī nūū tāhán inī ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ñúcuán de nī ncana Pilato ndá sūtū cúñáhnú jíín ndá tēe ndíso tíñú jíín ndá cā nchivī, nī ndutútú ji. ");
INSERT INTO mieNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","De nī ncāhān dē: Nī nquisiáha ndá nú tēe yáhá nūū ni, jā cáchī ndá nú jā snénda dē nchivī sīquī gobierno. De ja nī stíchī ni dē, nī jinī jínúū ndá nú. De nduú ní níhīn ni ni iin cuāchi sīquī dē tá cúu nūū cáhān ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","De ni Herodes nduú ní níhīn dē, chi nī natají tucu dē tēe yáhá nūū ni. Chi nduú ní nsáhá cuitī dē ni iin cuāchi jā cuū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Túsaá de ná cuáha nī castigo dē de siáā ni dē quīhīn dē, ncachī Pilato. ");
INSERT INTO mieNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","De íyó costumbre jā ndācá vico pascua siáā Pilato iin preso, nā-ni tēe cúnī nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","De ndá nchivī cuāhā, iin nuú nī ncana jee ji: Ná cúū tēe jīñā, de siáā ní Barrabás, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","De Barrabás yíhí dē vecāa sīquī jā ní snénda dē nchivī sīquī gobierno nī ncanāá ji inī ciudad, de nī jahnī dē ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","De Pilato cúnī dē siáā dē Jesús, de nī ncāhān tucu dē jíín nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","De víhí cā nī ncana jee ndá ji: Cata caa ní dē yīcā cruz, ná cúū dē, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","De nī ncāhān tucu dē jíín ji vuelta ūnī: ¿Nā cuāchi nī nsāhá dē túsaá? Nduú ní níhīn cuitī ni ni iin cuāchi sīquī dē jā cuū dē. Túsaá de ná cuáha nī castigo dē, de siáā ni dē quīhīn dē, ncachī Pilato. ");
INSERT INTO mieNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sochi víhí cā nī ncana jee ndá nchivī, de nī ncāhān nīhin ji jā ná cúū yā yīcā cruz. De ndá máá ji jíín ndá sūtū cúñáhnú, nī ncana jee ndasí ji. De nī ncundeé ji nī scáhān ji Pilato jā ná cúū yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ñúcuán de nī ndacu Pilato jā ná cóo tá cúu nūū cúnī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","De nī nsiáā dē tēe jā jícān ndá ji, tēe jā yíhí vecāa sīquī jā ní snénda dē nchivī sīquī gobierno, de nī jahnī dē ndīyi. De nī jēhe dē tūhun jā ná cúū Jesús tá cúu nūū cúnī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","De cuāhān ndá soldado jíín yā jā cahnī dē yā yīcā cruz. De nī nīhīn ndá dē iin tēe ñuū Cirene, nání dē Simón, vāndiji dē jā ní jēhēn dē rancho. De nī ntee ndá dē tiñu tēe ñúcuán jā cuiso dē cruz yā quīhīn dē yātā yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","De cuāhā ndasí nchivī níquīn ji yātā yā cuāhān ji. De suni cuāhā ñahan níquīn ña yā de jácu cóhó ña jā cúcuécá inī ña jēhē yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","De nī ndicó cóto Jesús nūū ndá ña, de nī ncāhān yā: Ndá ndóhó ñahan Jerusalén, mā cuācú nú jēhē nduhū, chi sa jēhē maá nú jíín ndá sēhe nú cuacu nú. ");
INSERT INTO mieNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chi quiji quīvī jā coo tūndóhó xéēn sīquī nū, de cachī ndá nú: Nācā ndetū ndá ñahan númā, jíín jāá nduú ní scácu sēhe, jíín jāá nduú ní ndéca ñiquín, chi nduú sēhe ña jā tahúhvī inī ña jā ndoho ji, cachī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","De quīvī ñúcuán de quijéhé nchivī cāhān ji jíín ndá yucu: Ndicó cáva sīquī ndá nī tácua cuū ni. De saá-ni jíín ndá lómō: Casī sīquī ndá nī, cachī ji. ");
INSERT INTO mieNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chi tú sáhá xēēn ndá ji nduhū jāá nduú nā cuāchi nī, de nā oncā cúu ndá nchivī ñúcuán jā má cōó xēēn sīquī ji, chi ndihi ji íyó cuāchi, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","De suni cuāhān ndá dē jíín ūū tēe jā ní nsāhá cuāchi xeēn, jā suni cuū dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","De nī nquenda ndá dē lugar jā nání Yiqui Xínī, de ñúcuán nī jata caa dē yā yīcā cruz. De suni nī jata caa dē ndúū tēe jā ní nsāhá cuāchi xeēn yīcā ūū cā cruz, iin dē lado cuáhá yā, de incā dē lado sátín yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","De juni játa caa ndá dē yā, de nī ncāhān Jesús: Tatá, cune cáhnú inī ní nūū ndá dē, chi nduú jínī dē nā cuá cúu jā sáhá dē, ncachī yā. De nī ntavā ndá soldado suerte sīquī sahma yā, nāsa nīhīn iin iin dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","De íñí ndá nchivī ñúcuán, ndéhé ji nūū yā. De ndá tēe ndíso tíñú suni nī ncāhān yīchī dē nī jinī dē yā: Tú incā nchivī nī scácu dē, de ná scácu dē maá dē mitan, de tú ndāā jā Cristo jā ní nacāji Yāā Dios cúu dē, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","De saá-ni ndá soldado, nī nsāhá sácá dē yā, chi nī ntandeē dē nūū yā, de nī jēhe dē vinagre iyá jā coho yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","De nī ncāhān dē jíín yā: Tú maá nú cúu Rey nchivī hebreo, de scácu nú maá nú, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","De suni nī īyo iin tūhun jā ndéē xīnī cruz yā jā cáhān nā sīquī nī jīhī yā, de suha yósō jíín letra griego jíín latín jíín hebreo: Yáhá cúu Rey nchivī hebreo, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","De iin tēe jā ndíta caa jíín yā jā ní nsāhá cuāchi xeēn, nī ncāhān nāvāha dē nūū yā: Tú maá nú cúu Cristo, de scácu nú maá nú de suni scácu nú ndúū ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sochi incā dē nī ncāhān dē nūū táhán dē: ¿A nduú yúhú nú Yāā Dios? Chi iin nuú-ni ndóho ó jíín Yāā yáhá. ");
INSERT INTO mieNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","De maá ó chi vātu-ni ndóho ó, chi yáhá níhīn ō castigo sīquī tiñu néhén jā ní nsāhá ó. Sochi Yāā yáhá chi ni iin cuāchi nduú ní nsáhá yā, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","De nī ncāhān dē jíín yā: Jesús, nūcūhun inī ní sāán tá quenda quīvī jā tatúnī ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ñúcuán de nī ncāhān Jesús jíín dē: Jāndáā cáhān ni jíín nú jā mitan de cundeē nū jíín nī andiví nūū viī ndasí cáá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","De nī ncuu tá cahūxī ūū, de nī ncuneē níí cáhnú jondē cahūnī. ");
INSERT INTO mieNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","De nī ncutuún ncandiī. De sahma jā ndíta caa jā ndásī cuarto īī inī templo cāhnú, nī ndātā-ni sava sava. ");
INSERT INTO mieNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ñúcuán de nī ncana jee Jesús: Tatá, naquehen ní ánō sá. De súcuán nī ncāhān yā, de nī jīhī yā-ni. ");
INSERT INTO mieNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","De tēe nación Roma jā cúu capitán, nī jinī dē jā súcuán nī ncuu, de nī ncāhān dē jā cúñáhnú ndasí Yāā Dios, de ncachī dē: Jāndáā ndija jā tēe nduú nā cuāchi cúu tēe yáhá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","De ndiviī nchivī jā íñí ñúcuán nī jinī ji ndācá jā ní ncuu, de nī ncani ji ndahá ji ndīca ji jā táhúhvī inī ji, de nī ndicó cóo ndá ji cuānohōn ji. ");
INSERT INTO mieNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","De ndá nchivī jā jínī tāhán jíín yā, jíín ndá ñahan Galilea jā ní jica jíín yā, íñí jícá ña ndéhé ña ndācá jā ní ncuu. ");
INSERT INTO mieNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","De nī īyo iin tēe vāha tēe ndāā, nání dē José. De tēe ñuū Arimatea ndáñúū Judea cúu dē. De cúu dē iin táhán ndá tēe hebreo jā sáhá junta cúñáhnú cā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","De suni ñúhún inī dē jā quiji quīvī jā tatúnī Yāā Dios, de nduú ní jétahān inī dē jā ní nsāhá ndāā junta jā cuū Jesús. ");
INSERT INTO mieNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","De tēe ñúcuán nī jēhēn dē nūū Pilato, de nī jīcān dē yiqui cúñu Jesús. ");
INSERT INTO mieNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","De nī snúu dē yā yīcā cruz, de nī nchusúcún dē yā iin sahma cuijín. De nī nchiyuhū dē yā inī iin yavī jā ní ncaān yīcā iin cava, nūū ncháha ca quihi ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","De quīvī ñúcuán cúu jā sátūha nchivī, chi jañíni ñúcuán cúu jā quíjéhé quīvī nátātú. ");
INSERT INTO mieNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","De ndá ñahan jā ní nquiji jíín yā jondē Galilea, nī jēhēn ña jíín José, de nī jinī ña yavī cava ñúcuán, jíín nāsa nī nchiyuhū ndá dē yā. ");
INSERT INTO mieNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","De cuānohōn ndá ña vehe ña, de nī nsāhá tūha ña ndá perfume jíín aceite yūcū jéhēn āsīn. De nī natātú ña quīvī nátātú, tá cúu nūū ndácu ley Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","De nehēn ndasí quīvī domingo de nī jēhēn ndá ñahan ñúcuán nūū yíyuhū Jesús, de née ña ndá perfume jíín aceite jā ní nsāhá tūha ña. De suni cuāhān sava cā ñahan jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","De tá nī nquenda ndá ña, de nī jinī ña ja nī ncujiyo yūū jā ndásī yuhú yávī ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","De nī nquīvi ndá ña yavī, de nduú cā ní jínī ña yiqui cúñu Jētohō ō Jesús. ");
INSERT INTO mieNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","De nī ncunēhén inī ña ndéhé ña jāá nduú cā ndīyi. Sá de nī jinī ña ūū ángel Yāā Dios jā cáá tá cáá tēe, nī jēcuīñī yā xiín ña, de ñúhún yā sahma jā jéndūtē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","De nī nchūhú ndasí ndá ña, de nī jīquindeyi ña nūū ñūhún. De nī ncāhān ndúū ángel ñúcuán jíín ña: ¿Nūcu sa nūū yíyuhū ndīyi nánducú ndá nú Yāā técū? ");
INSERT INTO mieNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nduú cā yā yáhá, chi ja nī natecū yā. De nūcūhun inī ndá nú nāsa nī ncāhān yā jíín nú tá nī īyo cā yā jíín nú región Galilea. ");
INSERT INTO mieNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Chi nī ncachī yā jā maá yā, Yāā nī nduu tēe, cánuú natūu yā nūū ndá tēe íyó cuāchi, jā tiin dē yā cahnī dē yā yīcā cruz, de nūū únī quīvī de natecū yā, ncachī ndúū ángel. ");
INSERT INTO mieNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ñúcuán de nī nūcūhun inī ña ndá tūhun jā ní ncāhān Jesús. ");
INSERT INTO mieNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","De nī nquee ndá ña nūū ní nchiyuhū yā, de cuānohōn ña. De nī nacani ña ndācá tūhun yáhá nūū ndihúxī iin apóstol jíín nūū ndá cā dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","De ndá ñahan jā ní nacani tūhun yáhá nūū ndá tēe apóstol, cúu ña María ñuū Magdala, jíín Juana, jíín María naná Jacobo, jíín sava cā ña. ");
INSERT INTO mieNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sochi ndá tēe apóstol chi jáni inī dē jā tūhun naā cúu jā cáhān ña, de nduú ní ncándíja dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","De vísō súcuán de nī nquee Pedro, de jínu dē cuāndēhé dē nūū ní nchiyuhū yā. De nī jito nihni dē inī yavī, de nī jinī dē jā maá-ni cā sahma cuijín cáá. De cuānohōn dē vehe dē, de sáhvi inī dē nī jinī dē jāá nduú cā yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","De suu quīvī ñúcuán cuāhān ūū táhān dē iin ñuū nání Emaús, jā née tá ūxī iin kilómetro jíín ciudad Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","De nátúhún ndúū dē sīquī ndācá tiñu jā ní ncuu ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","De juni nátúhún dē de jícā tūhún táhán de, de maá Jesús nī ncuñatin yā yātā dē, de jíca yā cuāhān yā jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","De nī nsāhá jíín dē jāá nduú ní nácunī dē yā vísō ndéhé dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","De nī ncāhān yā jíín dē: ¿Nā tūhun cúu jā nátúhún ndúū nū juni jíca nú? ¿De nājēhē cúu jā cúcuécá inī nū? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","De iin dē jā nání Cleofas nī ncāhān jíín yā: Ndihi cuitī nchivī jínī ji ndācá tiñu jā ní ncuu inī Jerusalén ndá quīvī yáhá. ¿De á mátúhún-ni ní cúu jā ní nquenda ní yáhá jāá nduú jínī ní nā cuá cúu jā ní ncuu? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","De nī jīcā tūhún yā dē: ¿De nā cuá cúu jā ní ncuu? ncachī yā. De nī ncāhān ndúū dē jíín yā: Jesús tēe ñuū Nazaret, nī nacani yā tūhun Yāā Dios, de jíín poder Yāā Dios nī nsāhá yā ndá tiñu ñáhnú de nī nacani yā tūhun, nī jinī Yāā Dios jíín ndá nchivī. ");
INSERT INTO mieNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","De ndá sūtū cúñáhnú jíín ndá tēe cúñáhnú nūū sá, nī nastúu ndá dē yā nūū ndá tēe Roma, de nī nsāhá ndāā ndá tēe ñúcuán jā cuū yā yīcā cruz. ");
INSERT INTO mieNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","De ndá máá sá chi nī ñūhun inī sá jā maá yā scácu nchivī nación maá sá Israel nūū nchivī Roma nícu. De sīquī ndá tiñu yáhá, de íyó incā tūhun. Chi mitan ja íyó ūnī quīvī jā ní jīhī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","De sava ñahan jā jínī tāhán sá jíín, nī nacani ña iin tūhun jā sáhvi ndasí inī sá, chi nī ncachī ña jā ní natecū yā. Chi nehēn ndasí nī jēhēn ndá ña yavī ndīyi ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","De nduú cā ní jínī ña yiqui cúñu yā. De nī nenda ndá ña nūū ndá sá, de nī ncachī ña jā ní jinī ña ūū ángel Yāā Dios nī nquenda nūū ña, de nī ncachī ángel jā ní natecū Jesús. ");
INSERT INTO mieNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Sá de nī jēhēn sava táhán sá yavī ndīyi, de nī jinī dē jā súcuán íyó tá cúu nūū ní ncāhān ndá ña, sochi nduú ní jínī cuitī ndá dē nūū yā, ncachī ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ñúcuán de nī ncāhān maá yā jíín dē: Tēe jāá nduú jícūhun cuitī inī cúu ndúū nū. Nācā ūhvī cándíja nú ndācá tūhun Cristo jā ní ncāhān ndá tēe nī nacani tūhun Yāā Dios janahán. ");
INSERT INTO mieNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿A nduú cánuú jā súcuán ndoho Cristo ndācá tūndóhó yáhá, de sá de quīnohōn yā nūū viī ndasí nduñáhnú yā? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","De nī nacani cájí yā ndá tūhun jā yósō nūū tutū īī jā cáhān sīquī maá yā. De nī nquijéhé yā jíín tūhun jā ní ntee Moisés, de nī ncāhān cā yā tūhun jā ní ntee ndá cā tēe nī nacani tūhun yā janahán. ");
INSERT INTO mieNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","De tá nī jīnū ndá dē ñuū nūū cuáhān dē, de Jesús nī nsāhá yā-ni jā quíhīn cā yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","De nī ndeē tuu ndúū dē yā, nī ncāhān dē jíín yā: Ndōo ní vehe sá, chi ja nī ñini de ja ñatin cuaā, ncachī dē. Ñúcuán de nī nquīvi yā jā quendōo yā jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","De tá nī jēcundeē yā nūū mesa jā cajī yā jíín dē, de nī nquehen yā stāā, de nī nacuetáhví yā, de nī scuáchi yā, de nī jēhe yā nūū ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","De jā sáhá yā súcuán, de modo jā ní nune tīnūú dē, de nī nacunī dē yā. De nī ndoñúhún yā-ni nūū dē cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","De nī ncāhān ndúū maá dē: Jāndáā jā ní ncusiī ndasí inī ō tá nī nacani yā tūhun nūū ō ichi, de nī ncachī tūhun cájí yā nāsa cáhān tutū īī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ñúcuán de ñamā nī naquehen ndúū dē ichi cuānohōn dē Jerusalén. De nī naquetáhán dē jíín ndihúxī iin apóstol, íyó tútú dē jíín sava cā táhán dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","De nī ncāhān ndá tēe íyó tútú: Jāndáā ndija jā ní natecū Jētohō ō, de nī nenda nijīn yā nūū Simón, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Sá de ndúū tēe ñúcuán nī nacani dē tūhun nāsa nī nquetáhán dē jíín yā ichi, jíín nāsa nī nacunī dē yā tá nī scuáchi yā stāā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","De juni súcuán cáhān cā dē ndá tūhun yáhá, de nī jēcuīñī ndeē-ni maá Jesús māhñú ndá dē. De nī ncāhān yā jíín dē: Coo ndeé coo siī inī ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","De nī nchūhú ndasí ndá dē nī jinī dē yā, chi nī jani inī dē jā ánō cúu yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","De nī ncāhān yā jíín ndá dē: ¿Nūcu yúhú ndá nú, de nūcu jáni síquí inī nū súcuán? ");
INSERT INTO mieNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cūndēhé ndahá nī jíín jēhē ni, de cunī nū jā maá nī cúu. Tiin nduhū de cunī nū, chi iin ánō nduú névāha cūñu ni yiqui tá cúu nūū ndéhé nú jā névāha maá nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","De tá nī ncāhān yā súcuán, de nī stéhēn yā ndahá yā jíín jēhē yā nūū ní nchīhi ndūyu cāa. ");
INSERT INTO mieNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","De ndasí nī ncusiī inī ndá dē, de sáhvi inī dē. Sochi ncháha ca candíja vāha dē jā maá yā cúu. De nī ncāhān yā jíín ndá dē: ¿A névāha nú jacū jā cajī ni yáhá? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ñúcuán de nī jēhe ndá dē iin pedazo tiacá táví jíín iin yōcō jā ñúhún ndūxi. ");
INSERT INTO mieNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","De nī nquehen yā, de nī nchajī yā nūū ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","De nī ncāhān yā jíín dē: Ndācá jā ní ndoho nī cúu jā ní ncāhān ni tá nī īyo nī jíín ndá nú saá, jā cánuú quee ndaā ndācá tūhun nī jā yósō nūū tutū ley Moisés, jíín nūū tutū ndá cā tēe nī nacani tūhun Yāā Dios, jíín nūū tutū salmo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","De nī nacune yā jāá ntúnī ndá dē, tácua cuu jīcūhun inī dē jā cáhān tutū īī. ");
INSERT INTO mieNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","De nī ncāhān yā: Súcuán yósō nūū tutū jā súcuán cánuú cundoho nduhū jā cúu nī Cristo, de nūū únī quīvī de natecū ni. ");
INSERT INTO mieNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","De cūtē nuu tūhun nī jā cánuú nacani inī nchivī jā sndóo ji cuāchi ji, tácua cune cáhnú inī Yāā Dios nūū cuáchi ji. De Jerusalén quijéhé cūtē nuu tūhun yáhá, de quīhīn nūū nchivī ndācá nación. ");
INSERT INTO mieNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","De ndá máá nú cúu tēe jā nacani tūhun sīquī ndācá jā ní jinī nū. ");
INSERT INTO mieNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","De tetíñú nī Espíritu Santo quiji yā nūū ndá nú, tá cúu nūū ní nquee yuhú Tatá nī. De quendōo ndá nú Jerusalén cundetu nú jondē nīhīn nū poder Espíritu Santo jā quiji jondē andiví, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ñúcuán de nī nquee yā Jerusalén cuāhān yā jíín ndá dē jondē ñuū Betania. De nī nanee yā ndúū ndahá yā, de nī jīcān táhvī yā jēhē ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","De juni jícān táhvī yā jēhē dē, de nī ncujiyo yā-ni nūū ndá dē, nī ndaa yā cuānohōn yā andiví. ");
INSERT INTO mieNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","De ndá máá dē chi nī nchiñúhún dē yā. Sá de cuānohōn dē Jerusalén, de cúsiī ndasí inī dē. ");
INSERT INTO mieNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","De níní íyó ndá dē inī templo, jícān táhvī dē de nácuetáhví dē nūū Yāā Dios. De nī ncuu. Amén.");
INSERT INTO mieNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jondē jā xíhna ñúhún tá nī jēcōo ndihi jā íyó, de ja íyó Yāā jā nání Tūhun Yāā Dios, chi stéhēn yā ndihi tūhun nāsa Yāā cúu Yāā Dios. De Yāā jā nání Tūhun ndéē yā jíín Yāā Dios, de Yāā Dios cúu yā. ");
INSERT INTO mieNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Maá yā ndéē yā jondē jā xíhna ñúhún jíín Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","De nī nsāhá Yāā Dios jā jíín maá yā nī jēcōo ndihi ndācá jā íyó. De mā jécōo ni iin jā íyó de tú nduú ní nsáhá maá yā. ");
INSERT INTO mieNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Maá yā sáhá jā técū ndihi-ni, de maá yā cúu luz jā stúu inī ánō nchivī, cúu jā sáhá yā jā jícūhun inī ji sīquī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","De Yāā cúu luz ñúcuán stúu inī ánō nchivī jāá nduú jíca ndaā, de modo jā íyó ji nūū neē. De nchivī jā íyó nūū neē nduú cúu sndáhvā ji luz yā. ");
INSERT INTO mieNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","De nī īyo iin tēe jā ní ntají Yāā Dios, nání dē Juan. ");
INSERT INTO mieNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tēe ñúcuán nī nquiji dē nī nacani cájí dē tūhun maá Yāā cúu luz, tácua candíja ndācá nchivī jíín tūhun cáhān dē. ");
INSERT INTO mieNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nsūú maá Juan cúu luz ñúcuán, chi cúu dē iin jā ní nacani cájí tūhun maá Yāā cúu luz. ");
INSERT INTO mieNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","De Yāā cúu luz ndāā jā stúu inī ánō ndācá nchivī, nī nquiji yā inī ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","De Yāā ñúcuán jā cúu Tūhun Yāā Dios nī ndeē yā inī ñayīví, de vísō jíín maá yā nī nsāhá Yāā Dios ñayīví, sochi nchivī ñayīví nduú ní ncúnī ji cuetáhví ji jā maá yā cúu. ");
INSERT INTO mieNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nī nquiji yā nūū nchivī maá yā nación hebreo, de nchivī ñúcuán nduú ní jétáhví ji yā. ");
INSERT INTO mieNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","De vísō súcuán de sava nchivī chi nī jetáhví ji yā, de nī ncandíja ji jā sāhá yā jēhē ji. De nūū maá ji nī jēhe yā tūhun jā nduu ji sēhe Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","De jā ndúu ji sēhe Yāā Dios, nsūú jíín modo jā cácu nchivī inī ñayīví, ni nsūú sīquī jā cúnī ndá tēe, chi maá Yāā Dios sáhá yā jā ndúu ji sēhe yā. ");
INSERT INTO mieNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Maá Yāā jā cúu Tūhun Yāā Dios nī nduu yā tēe, de nī ndeē yā jíín ó. De nī jinī ō jā viī ndasí cúñáhnú yā, chi mátúhún-ni yā cúu Sēhe Yāā cúu Tatá, Yāā cúñáhnú súcuán. De maá-ni jā váha sáhá yā yóhó, de maá-ni tūhun ndāā cáhān yā. ");
INSERT INTO mieNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","De Juan nī nacani dē tūhun yā, de nī ncāhān dē: Yāā yáhá cúu jā ní ncāhān ni tá nī ncachī ni jā Yāā quiji chi cúñáhnú cā yā nsūú cā nduhū, chi ja íyó yā jondē ncháha ca cacu nī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","De ndihi ó nī nīhīn ō cuāhā ndasí jā váha jā íyó nūū yā, chi maá-ni jā váha sáhá sáhá yā yóhó. ");
INSERT INTO mieNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés nī stéhēn dē ley Yāā Dios nūū nchivī janahán, de Jesucristo chi sa sáhá yā jā váha yóhó de stéhēn yā ndācá tūhun ndāā Yāā Dios nūū ō. ");
INSERT INTO mieNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nduú ní jínī cuitī ni iin nchivī nūū Yāā Dios. De mátúhún-ni Sēhe yā jā ndéē yā jíín Tatá yā, suu yā nī stéhēn nūū ō nāsa Yāā cúu Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","De nchivī hebreo ciudad Jerusalén, nī ntají ji jacū sūtū jíín ndá tēe grupo levita jā ndíso tíñú inī templo cāhnú. De nī nquenda ndá dē nūū Juan tácua cātūhún dē ní iin cúu Juan de nā tiñu ndíso dē. ");
INSERT INTO mieNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","De Juan cájí nī ncachī dē: Nsūú nduhū cúu Cristo, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","De nī jīcā tūhún tucu ndá dē: ¿Túsaá de ní iin cúu nú? ¿A cúu nú Elías, tēe nī nacani tūhun Yāā Dios jondē janahán, á naá cúu? ncachī dē. Nsūú dē cúu nī, ncachī Juan. De nī jīcā tūhún tucu ndá dē: ¿Túsaá de á cúu nú tēe nácani tūhun Yāā Dios jā cáchī tutū īī jā quiji? Nduú, ncachī tucu Juan. ");
INSERT INTO mieNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","De nī ncāhān tucu ndá dē: ¿De ní iin cúu nú túsaá? Cachī nūū ndá nī, chi jíni ñúhún jā cachī tūhun nī nūū ndá tēe jā ní ntají nduhū vāji nī. Cachī nā tiñu ndíso nú viī. ");
INSERT INTO mieNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","De nī ncāhān Juan: Maá nī cúu tēe jā ní ncāhān Isaías, tēe nī nacani tūhun Yāā Dios jondē janahán, jā quiji nī cana jee nī jondē nūū ñuhun tíhá. De cáhān ni jíín nchivī jā ná sáhá tūha ji maá ji, chi quiji maá Jētohō ō, ncachī Juan. ");
INSERT INTO mieNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","De ndá tēe grupo fariseo cúu jā ní ntají dē ndá tēe jā ní nquiji nūū Juan. ");
INSERT INTO mieNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","De nī jīcā tūhún ndá dē Juan: ¿Túsaá de nūcu scuénduté nú de tú nsūú Cristo ni Elías ni maá tēe jā quiji jā nacani tūhun Yāā Dios cúu nú? ");
INSERT INTO mieNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","De nī ncāhān Juan: Nduhū chi jíín ndute scuénduté nī. Sochi māhñú ndá nú íyó iin Yāā jāá nduú jínī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","De Yāā ñúcuán cúu jā ní ncāhān ni jā quiji yā de cúñáhnú cā yā nsūú cā nduhū. Chi nduú cúñáhnú cuitī ni nūū yā, ni jā cuetíñú yā nduhū vísō iin tiñu lúlí cā jā nandají nī correa nījān yā, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Súcuán nī ncuu jā ní natúhún ndá dē jíín Juan jondē Betábara jā íyó ichi nūū quénda ncandiī yūte Jordán, nūū scuénduté Juan. ");
INSERT INTO mieNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","De quīvī téēn de nī jinī Juan nūū Jesús jā váji yā nūū dē. De nī ncāhān dē jíín nchivī: Cūndēhé ndá nú, chi yáhá vāji maá Yāā jā cúu Tīcāchí lúlí jā ní ntají Yāā Dios, de cuū yā jā sāhá ndoo yā cuāchi nchivī ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yāā yáhá cúu jā ní ncachī ni jā quiji iin Yāā cúñáhnú ndasí, chi ja íyó yā jondē ncháha ca cacu nī. ");
INSERT INTO mieNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","De jondē saá de ncháha ca cunī ni ní iin cúu yā, sochi nī nquiji nī jā scuénduté nī nchivī nación maá ó jíín ndute, tácua stéhēn ni yā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","De suni nī ncāhān cā dē tūhun yā: Nī jinī ni Espíritu Santo, nī ncuun yā ichi andiví, cáá yā tá cáá paloma, de nī jēcōsō yā xīnī Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","De jondē saá de ncháha ca cunī ni jā suu yā cúu. De maá Yāā Dios jā ní ntetíñú yā nduhū jā scuénduté nī jíín ndute, nī ncāhān yā jíín nī: Tá cunī nū jā cuun Espíritu Santo de jēcōsō xīnī iin tēe, suu tēe ñúcuán cúu Yāā jā cuāha Espíritu Santo jā cundeē inī ánō nchivī, ncachī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","De ja nī jinī ni, de nácani cájí nī tūhun jā maá yā cúu Sēhe Yāā Dios, ncachī Juan. ");
INSERT INTO mieNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","De incā quīvī téēn de Juan íyó tucu dē ñúcuán jíín ūū tēe jíca jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","De nī jinī dē nūū Jesús jā jíca yā ñúcuán. De nī ncāhān dē: Cūndēhé ndá nú, chi ñúcuán cúu maá Yāā jā cúu Tīcāchí lúlí jā ní ntají Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","De ndúū tēe jíca jíín Juan nī jini dē tūhun yáhá, de nī jēcuniquīn dē Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","De nī ndicó cóto Jesús, de nī jinī yā jā níquīn ndúū dē yātā yā. De nī ncāhān yā jíín dē: ¿Nā cuá ndúcú ndúū nū? De nī ncāhān dē: Maestro, ¿ní cúu nūū ndéē ní? ");
INSERT INTO mieNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","De nī ncāhān yā: Ná cóhōn de cunī nū, ncachī yā. De nī jēhēn ndúū dē, de nī jinī dē nūū ndéē yā. De nī nquendōo dē jíín yā quīvī ñúcuán, chi ja íyó tá cacūmī jañíni. ");
INSERT INTO mieNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","De Andrés, ñanī Simón Pedro, cúu iin dē jā ní jini dē tūhun nī ncāhān Juan de nī jēcuniquīn dē Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","De Andrés, ñamā nī jēnanducú dē ñanī dē Simón, de nī ncāhān dē jíín: Nī nquetáhán ndá nī jíín Mesías, ncachī dē. De tūhun yáhá cáhān: Cristo, Yāā nī ntají Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ñúcuán de cuānohōn dē nūū Jesús jíín ñanī dē Simón. De tá nī jinī Jesús nūū Simón, de nī ncāhān yā: Maá nú cúu Simón sēhe Jonás. De jondē mitan de cunaní nú Cefas, ncachī yā. De tūhun yáhá cáhān: Pedro, de suu cúu yūū. ");
INSERT INTO mieNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","De incā quīvī téēn de cúnī Jesús quīhīn yā región Galilea. De nī jēcutáhán yā jíín Felipe, de nī ncāhān yā jíín dē: Cuniquīn nduhū ná cóhōn. ");
INSERT INTO mieNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","De Felipe cúu tēe ñuū Betsaida, jā cúu ñuū Andrés jíín Pedro. ");
INSERT INTO mieNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","De nī jēnanducú dē Natanael, de nī ncāhān dē jíín: Nī nquetáhán ndá nī jíín Yāā jā yósō tūhun yā nūū tutū ley jā ní ntee Moisés, jíín nūū tutū jā ní ntee ndá tēe nī nacani tūhun Yāā Dios janahán. De Jesús sēhe José ñuū Nazaret cúu yā, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","De nī ncāhān Natanael jíín dē: ¿De nāsa cúu cúñáhnú iin tēe jā ní ncacu ñuū ndāhví Nazaret? De nī ncāhān Felipe: Ná cóhōn de cunī nū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","De nī jinī Jesús jā váji Natanael, de ncāhān yā: Yáhá vāji iin tēe ndāā jā cúu ndija tatā Israel, chi nduú stáhví cuitī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","De nī ncāhān Natanael jíín yā: ¿Nāsa jínī ní sāán? De nī ncāhān Jesús: Ja nī jinī ni ndóhó jondē ncháha ca cana Felipe ndóhó, tá nī īyo nú jēhē ñutun higo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ñúcuán de nī ncāhān Natanael jíín yā: Maestro, maá ní cúu Sēhe Yāā Dios, maá ní cúu Rey nación maá ó Israel, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","De nī ncāhān Jesús: ¿A jā ní ncāhān ni jā ní jinī ni ndóhó tá nī īyo nú jēhē ñutun higo, á suu cúu jā ní ncandíja nú nduhū, á naá cúu? Sochi coo tiñu ñáhnú cā cunī nū nsūú cā yáhá, ncachī yā jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","De nī ncāhān cā yā: Jāndáā cáhān ni jíín ndá nú jā jondē mitan de cunī nū jā nune nūū ndéē Yāā Dios andiví, de ndá ángel yā ndaa yā nuu yā nūū nduhū, Yāā nī nduu tēe, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","De nī nchāha ūnī quīvī, de nī īyo iin vico tándāhá ñuū Caná ndáñúū Galilea. De ñúcuán íyó naná Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","De suni nī ncana nchivī Jesús jíín ndá tēe scuáha jíín yā, nī jēhēn yā vico jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","De nī ndoco vino. De naná Jesús nī ncāhān ña jíín yā: Nī ndoco vino ndá ji, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","De nī ncāhān Jesús jíín ña: ¿De nūcu cáhān ní súcuán jíín sá, naná? Chi ncháha ca quenda quīvī jā sāhá sá tiñu ñáhnú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","De naná yā chi nī ncāhān ña jíín ndá nchivī jícó ndíso cōhō: Sāhá ndá nú ndācá jā cáchī yā nūū nū, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","De ñúcuán íyó īñū tinaja yūū jā ñúhun ndute nándahá ndá nchivī hebreo jā ndúndoo ji nūū Yāā Dios. De iin iin tinaja quénda cuhun cūmī xico á ciento litro ndute. ");
INSERT INTO mieNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","De nī ncāhān Jesús jíín nchivī jícó ndíso cōhō: Chuhun chitú ndá nú ndute tinaja yáhá. De nī nchuhun chitú ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","De nī ncāhān yā: Mitan de tavā ndá nú jacū de quīsiáha nú coto túnī tēe cúu encargado vico, ncachī yā. De nī jēsiáha ji nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","De nī jito túnī dē ndute jā ní nduu vino, de nduú jínī dē ní cúu nūū ní nīhīn ndá ji. Chi maá-ni ndá mozo cúu jā jínī, chi maá ji nī ntavā ndute. Ñúcuán de tēe encargado nī ncana dē tēe tándāhá. ");
INSERT INTO mieNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","De nī ncāhān dē: Ndācá nchivī chi xihna cā vino vāha jéhe ji, de tá nī jihi vāha nchivī íyó vico, de sá de jéhe ji vino jā íyó núu cā. Sochi maá nú tucu nī nsāhá nú, chi jā sándīhí de jéhe nú vino jā váha ndasí cā, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tiñu yáhá jā ní nsāhá Jesús inī ñuū Caná ndáñúū Galilea cúu tiñu ñáhnú jā xíhna ñúhún jā ní nsāhá yā jā stéhēn yā poder yā. De súcuán nī stéhēn yā jā cúñáhnú ndasí yā. De ndá tēe scuáha jíín yā nī ncandíja dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","De sá de cuāhān yā ñuū Capernaum jíín naná yā jíín ndá ñanī yā jíín ndá tēe scuáha jíín yā. De nī ndeē yā ñúcuán jacū quīvī. ");
INSERT INTO mieNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","De jā cuácuñatin vico pascua jā sáhá ndá táhán yā hebreo, de cuāhān yā Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","De inī patio templo cāhnú nī jinī yā ndá nchivī jā xícó stīquī jíín tīcāchí jíín paloma, jíín ndá nchivī sáma xūhún, ndéē ndá ji nūū mesa ji. ");
INSERT INTO mieNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","De jā súcuán nī jinī yā, de nī nsāhá yā iin cuarta ñii. De nī ntají yā ndācá ji inī templo, jondē jíín tīcāchí jíín stīquī ji. De nī jitē yā xūhún nchivī sáma. De nī scócáva yā ndá mesa ji. ");
INSERT INTO mieNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","De nī ncāhān yā jíín nchivī xícó paloma: Tavā ndá quiti yáhá. De mā sāhá nú yāhvi inī vehe Tatá nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ñúcuán de ndá tēe scuáha jíín yā, nī nūcūhun inī dē tūhun yósō nūū tutū īī: Ja ñatin cuū sá jā ndíhvī ndasí inī sá sīquī vehe ní, cáchī yā jíín Tatá yā, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","De ndá táhán yā hebreo nī jīcā tūhún dē yā: ¿De nā tiñu ñáhnú sāhá nú jā stéhēn nū poder nū, de cucáhnú inī ni jā ndíso tíñú nú jā sáhá nú súcuán? ncachī dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","De nī ncāhān yātá yā: Scócáva ndá nú templo yáhá, de nūū únī quīvī de nacani nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ñúcuán de nī ncāhān ndá tēe hebreo: Uū xico īñū cuīyā de nī jīnu templo yáhá. De ndóhó, ¿á nūū únī-ni quīvī de nacani nú, á naá cúu? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sochi templo jā ní ncāhān Jesús cúu maá yiqui cúñu yā, chi cahnī nchivī yā de natecū yā nūū únī quīvī. ");
INSERT INTO mieNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jā ñúcuán cúu jā tá nī natecū yā jā ní jīhī yā, de ndá tēe nī scuáha jíín yā nī nūcūhun inī dē jā ní ncāhān yā tūhun yáhá. De nī ncandíja ndá dē tūhun jā yósō nūū tutū īī, jíín tūhun yáhá jā ní ncāhān Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","De tá íyó Jesús Jerusalén maá vico pascua, de cuāhā nchivī nī ncandíja ji jā cúu yā Cristo, chi nī jinī ji ndācá tiñu ñáhnú jā sáhá yā jā stéhēn yā poder yā. ");
INSERT INTO mieNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sochi maá Jesús nduú ní jétáhví yā ji, chi ja jínī yā nāsa cáá inī ánō ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","De nduú jíni ñúhún jā cachī ni iin nchivī nūū yā nāsa íyó ndá nchivī, chi maá yā ja jínī yā nāsa cáá inī ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","De íyó iin tēe grupo fariseo, nání dē Nicodemo, de cúñáhnú dē nūū nchivī nación dē hebreo. ");
INSERT INTO mieNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tēe yáhá nī nquiji dē nūū Jesús iin jacuáā, de nī ncāhān dē jíín yā: Maestro, ja jínī ndá sá jā maá Yāā Dios nī ntají yā níhín jā stéhēn ní tūhun yā nūū ndá sá. Chi tú nduú íyó Yāā Dios jíín ní, de mā cūú sāhá ní ni iin tiñu ñáhnú tá cúu nūū sáhá ní jā stéhēn ní poder ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","De nī ncāhān Jesús: Jāndáā cáhān ni jíín nú jā tú mā nácacu jeé iin nchivī, de mā cūú quīvi ji ndahá Yāā Dios jā tatúnī yā nūū ji, ncachī yā jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","De nī ncāhān Nicodemo jíín yā: ¿De nāsa cuu nacacu iin tēe de tú ja nī jahnu dē? ¿A cuu nūcūhun tucu dē chījin naná dē de nacacu tucu dē? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","De nī ncāhān Jesús: Jāndáā cáhān ni jíín nú jā tú mā nácacu iin nchivī, de mā cūú quīvi ji ndahá Yāā Dios jā tatúnī yā nūū ji. De jā nácacu ji cúu jā ndúndoo cuāchi ji tá cúu nūū sáhá ndute, de cundeē Espíritu Santo inī ánō ji. ");
INSERT INTO mieNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jā cácu sáhá nchivī, chi sēhe nchivī cúu. Sochi jā cácu sáhá Espíritu yā, chi sēhe yā cúu. ");
INSERT INTO mieNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mā sáhvi inī nū cani inī nū nāsa cúu tūhun nī ncāhān ni jíín nú jā cánuú nacacu jeé ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","De tāchī chi quéne ní-ni cúu nūū cúnī maá, de jíni nú jā cáyu, sochi nduú jínī nū ní jondē vāji ní jondē quīhīn. De suni súcuán cúu ndācá nchivī jā nácacu sáhá Espíritu, chi nduú jínī nū nāsa sáhá yā tiñu ñúcuán, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","De nī jīcā tūhún tucu Nicodemo: ¿De nāsa cúu túsaá? ");
INSERT INTO mieNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","De nī ncāhān Jesús: Maá nú cúu iin maestro jā cúñáhnú nūū ndá táhán ó Israel, ¿de á nduú jícūhun inī nū tūhun yáhá, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jāndáā cáhān ni jíín nú jā tūhun jā jícūhun inī ni cúu jā cáhān ni jíín nú. De nácani cájí nī sīquī tiñu jā ní jinī ni. Sochi nduú cándíja ndá nú tūhun jā cáhān ni. ");
INSERT INTO mieNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chi nī ncāhān ni tūhun nāsa sáhá Yāā Dios inī ñayīví, de nduú cándíja ndá nú. ¿Túsaá de nāsa cuu candíja nú de tú cāhān ni tūhun nāsa sáhá yā jondē andiví? ");
INSERT INTO mieNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Chi ni iin nduú ní ncáa andiví jā cunī nāsa íyó ñúcuán, chi mátúhún-ni nduhū, Yāā nī nduu tēe. Chi andiví ndéē ni, de nī ncuun nī vāji nī. ");
INSERT INTO mieNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","De tá cúu nūū ní jata caa Moisés iin cōō cāa, tá nī jica ndá nchivī nūū ñuhun tíhá, suni súcuán maá nī, Yāā nī nduu tēe, cánuú jā cundita caa nī yīcā cruz. ");
INSERT INTO mieNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","De súcuán cánuú tácua ndācá nchivī jā candíja ji jā scácu nī ji, mā tánū tāhvī ji, chi sa cutecū ji níí cání andiví. ");
INSERT INTO mieNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Chi Yāā Dios nī ncundáhví ndasí inī yā nchivī ñayīví. De jā ñúcuán nī ntají yā Sēhe yā nī nquiji, vísō mátúhún-ni yā íyó, tácua ndācá nchivī jā cándíja ji jā scácu yā ji, mā tánū tāhvī ji chi sa cutecū ji níí cání andiví. ");
INSERT INTO mieNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chi nduú ní ntájí Yāā Dios Sēhe yā inī ñayīví jā stánū tāhvī yā nchivī, chi sa jā scácu yā ji. ");
INSERT INTO mieNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nchivī jā cándíja ji jā scácu yā ji, mā tánū tāhvī ji. Sochi nchivī nduú cándíja, ja nī ntānū tāhvī ji, chi nduú ní ncándíja ji maá Sēhe Yāā Dios, jā mátúhún-ni yā íyó. ");
INSERT INTO mieNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Maá Yāā jā stúu inī ánō nchivī, ja nī nquenda yā inī ñayīví. Sochi nchivī nī jētahān cā inī ji caca ji modo nūū neē nsūú cā jā stúu yā inī ánō ji, chi tiñu sáhá ji cúu tiñu néhén. Jā ñúcuán cúu jā tānū tāhvī nchivī jāá nduú cándíja. ");
INSERT INTO mieNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chi ndācá nchivī jā sáhá tiñu néhén, nduú jétahān cuitī inī ji luz yā. De nduú jéhe ji tūhun jā stúu yā inī ánō ji, chi nduú cúnī ji jā natūu tiñu néhén jā sáhá ji. ");
INSERT INTO mieNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sochi nchivī jā sáhá tiñu ndāā, jéhe ji tūhun jā stúu yā inī ánō ji, tácua natūu jā ndācá tiñu sáhá ji cúu tiñu jétahān inī Yāā Dios, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ñúcuán de Jesús jíín ndá tēe scuáha jíín yā, cuāhān yā región Judea. De nī ndeē yā ñúcuán jacū tiempo jíín ndá dē, de scuénduté ndá dē nchivī. ");
INSERT INTO mieNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","De suni scuénduté Juan, ndéē dē lugar jā nání Enón ñatin ñuū Salim, chi ñúcuán íyó cuāhā ndute. De nī nquiji ndá nchivī nūū dē, de nī scuénduté dē ji. ");
INSERT INTO mieNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Súcuán nī nsāhá dē jondē ncháha ca quīvi dē vecāa. ");
INSERT INTO mieNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ñúcuán de sava tēe scuáha jíín Juan ndasí nī ncāhān ndá dē jíín sava táhán dē hebreo sīquī ní iin cúu modo vāha cā jā cuenduté nchivī jā ndundoo ji nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","De nī nquiji ndá dē nūū Juan, de nī ncāhān dē: Maestro, tēe jā ní īyo jíín ní yūte Jordán ichi nūū quénda ncandiī, jā ní nacani ní tūhun dē nūū sá, mitan de scuénduté maá dē, de ndiviī nchivī jéhēn ji nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","De nī ncāhān Juan: Ni iin tēe mā cūú sāhá dē tiñu Yāā Dios de tú mā tétíñú yā dē. ");
INSERT INTO mieNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ndá máá nú chi nī jini nú jā ní ncāhān cājí nī jāá nsūú maá nī cúu Cristo, chi cúu nī iin jā ní ntají Yāā Dios jā cosō nūú nacani tūhun jā quiji yā. ");
INSERT INTO mieNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","De tá sáhá nchivī vico tándāhá, de maá tēe tándāhá cúu jā ndéca ñasíhí. De amigo tēe tándāhá chi íyó jíín dē, de níni tūhun cáhān dē. De cúsiī ndasí inī dē jā níni dē tūhun cáhān tēe tándāhá. De saá-ni nduhū, chi cúu nī tá cúu amigo tēe tándāhá. Chi nī nquenda maá Cristo, de cúsiī ndasí inī ni jā níni nī tūhun cáhān yā. ");
INSERT INTO mieNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","De cánuú jā nduñáhnú cā maá yā de nuu cā maá nī, ncachī Juan. ");
INSERT INTO mieNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","De Yāā jā váji jondē andiví, cúñáhnú yā nūū ndihi. Chi ndācá jā ní ncacu inī ñayīví yáhá, sēhe ñayīví cúu, de maá-ni tūhun ñayīví cáhān. Sochi Yāā jā váji ichi andiví, chi cúñáhnú yā nūū ndihi nchivī. ");
INSERT INTO mieNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","De nácani yā tūhun jā ní jinī yā jíín jā ní jini yā. De nchivī chi nduú cándíja ji tūhun cáhān yā. ");
INSERT INTO mieNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Sochi tú iin nchivī cándíja ji tūhun cáhān yā, suu cúu jā jétúhún ji jā Yāā ndāā cúu Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Chi Yāā jā ní ntají Yāā Dios vāji, chi maá-ni tūhun Yāā Dios cáhān yā. Chi Yāā Dios nduú jéhe yícuāhá yā Espíritu yā nūū Yāā jā ní ntají yā. ");
INSERT INTO mieNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Maá yā jā cúu yā Tatá, ndasí mānī yā jíín Sēhe yā, de ndiviī nī nchihi yā ndahá Sēhe yā jā tatúnī yā nūū. ");
INSERT INTO mieNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nchivī jā cándíja maá Sēhe yā jā scácu yā ji, cutecū ji níí cání andiví. De nchivī jāá nduú cúnī candíja sēhe yā, mā cútecū ji, chi sa cuāha Yāā Dios castigo jā ndoho ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","De ndá tēe grupo fariseo, nī nīhīn dē tūhun jā íyó cuāhā cā nchivī scuáha jíín Jesús nsūú cā jíín Juan, jíín jā cuāhā cā nchivī scuénduté yā nsūú cā Juan. ");
INSERT INTO mieNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Sochi nsūú maá yā cúu jā scuénduté, chi ndá tēe scuáha jíín yā cúu jā scuénduté. ");
INSERT INTO mieNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","De tá nī jinī Jesús jā súcuán nī nīhīn ndá dē tūhun, de nī nquee yā región Judea, de cuānohōn yā región Galilea. ");
INSERT INTO mieNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","De ichi jā nóhōn yā chi yáha región Samaria. ");
INSERT INTO mieNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","De nī nquenda yā iin ñuū región Samaria jā nání Sicar, ñatin ñuhun jā ní jēhe Jacob nūū sēhe dē José jondē janahán. ");
INSERT INTO mieNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","De ñúcuán íyó pozo jā nání pozo Jacob. De nī jēcundeē Jesús xiín pozo ñúcuán, chi nī ncuītá yā jā cuáhān yā ichi. De cúu tá cahūxī ūū. ");
INSERT INTO mieNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","De nī nquenda iin ñahan Samaria, vāji ña jā quehen ña ndute. De nī ncāhān Jesús jíín ña: Cunī mānī ní ndute coho sá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","De ndá tēe scuáha jíín yā, ja cuāhān ndá dē ñuū cuācuēen dē jā cajī dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","De ñahan Samaria nī ncāhān ña jíín yā: ¿Nūcu jícān ní ndute nūū sá coho ní? Chi tēe hebreo cúu ní, de ñahan Samaria cúu sá, ncachī ña. Súcuán nī ncāhān ña, chi nchivī hebreo nduú cáhān ndá ji jíín nchivī Samaria. ");
INSERT INTO mieNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","De nī ncāhān Jesús: Tú jā jínī ní nāsa cúnī Yāā Dios sāhá yā jā váha níhín, jíín ní iin cúu sāán jā jícān sá ndute nūū ní, ñúcuán de maá ní cācān ní nūū sá, de cuāha sá ndute jā cutecū ní níí cání sāhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","De nī ncāhān ña jíín yā: Señor, cúnú ndasí pozo yáhá, de nduú ná née ní jā tavā ní ndute. ¿Túsaá de ní nīhīn ní ndute jā cutecū sá sāhá? ");
INSERT INTO mieNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿De á cúñáhnú cā maá ní nsūú cā tatá ó Jacob, á naá cúu? Chi maá dē nī sndóo dē pozo yáhá nūū ō. De yáhá nī jihi maá dē ndute, jíín ndá sēhe dē, jíín ndá quiti ndéca dē, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","De nī ncāhān Jesús: Ndācá nchivī jā jíhi ndute yáhá, chi yīchī tucu ji. ");
INSERT INTO mieNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Sochi nchivī jā coho ndute jā cuāha sá nūū ji, chi mā yíchī cuitī cā ji. Chi ndute jā cuāha sá quene inī ji tá cúu ndute jā quéne nūū ñūhún, de sāhá jā cutecū ji níí cání, ncachī yā jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","De maá ña nduú ní jícūhun inī ña, de nī ncāhān ña jíín yā: Señor, cuāha ní ndute ñúcuán coho sá, tácua mā yíchī cuitī cā sá, de ni nduú cā jíni ñúhún quiquehen sá ndute pozo yáhá, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","De nī ncāhān Jesús jíín ña: Cuácāna ní yií ní de quiji ní jíín dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nduú nā yií sá íyó, ncachī ña. De nī ncāhān Jesús: Ndāā cáhān ní jāá nduú nā yií ní íyó. ");
INSERT INTO mieNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Chi ja nī īyo ūhūn yií ní, de tēe ndéca ní mitan chi nsūú yií ní cúu dē. Yāhá cúu jā ní ncāhān ndāā ní, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","De jā súcuán nī ncāhān yā, de nī ncāhān ña: Señor, iin tēe nácani tūhun Yāā Dios cúu ní, jáni inī sá. ");
INSERT INTO mieNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ndá ndīyi tatā sá nchivī Samaria, yucu yáhá nī nchiñúhún ji Yāā Dios. Sochi ndá máá ní nchivī hebreo, cáhān ní jā Jerusalén cúu nūū cánuú chiñúhún ó yā, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","De nī ncāhān Jesús jíín ña: Nánā, candíja ní tūhun cáhān sá, chi quiji quīvī jāá nsūú yucu yáhá ni nsūú Jerusalén cúu nūū chiñúhún ní maá Yāā cúu Tatá, chi ndihi-ni lugar de cuu chiñúhún ní yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ndá máá ní nchivī Samaria chi nduú jínī ní ní iin cúu jā chíñúhún ní. Sochi ndá máá sá chi jínī sá ní iin cúu jā chíñúhún sá. Chi jondē nūū ndá máá sá nchivī hebreo cúu nūū váji Yāā jā scácu nchivī. ");
INSERT INTO mieNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","De ja nī nquenda quīvī jā ndá nchivī jā chíñúhún Yāā cúu Tatá, mitan de víhí cā chiñúhún ndija ji yā, chi jondē jíín inī jíín ánō ji. Chi maá Tatá súcuán cúnī yā jā chiñúhún nchivī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yāā Dios cúu Espíritu, de nchivī jā cúnī ji chiñúhún ji yā, cánuú jā chiñúhún ndija ji yā jondē jíín inī jíín ánō ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","De nī ncāhān tucu ña: Jínī sá jā quiji Mesías jā cúu Cristo, Yāā jā tají Yāā Dios. De tá quenda maá yā, de stéhēn cājí yā ndācá tūhun nūū ō. ");
INSERT INTO mieNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","De nī ncāhān Jesús: Maá sá jā cáhān sá jíín ní, suu sá cúu Yāā ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","De juni cáhān cā yā súcuán, de nī nenda ndá tēe scuáha jíín yā. De sáhvi inī ndá dē ndéhé dē jā nátúhún yā jíín ñahan ñúcuán. De ni iin dē nduú ní jícā tūhún dē yā naá cúu jā jícā tūhún yā ña á naá cúu jā nátúhún yā jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ñúcuán de nī sndóo ña quīyi ña, de cuāhān ña jondē ñuū. De nī ncāhān ña jíín ndá nchivī ñúcuán: ");
INSERT INTO mieNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Nehēn ndá nú ná cóhōn de cunī nū iin tēe jā ní ncachī ndihi ndācá jā ní nsāhá nī. Sanaā de maá yā cúu Cristo jā ndétu ó jā quiji, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ñúcuán de nī nquee ndá ji ñuū, de cuāhān ji nūū íyó Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","De juni cuāhān ndá ji nūū yā, de ndá tēe scuáha jíín yā nī ncāhān ndāhví dē jíín yā: Maestro, cajī ní stāā viī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","De nī ncāhān yā jíín ndá dē: Iyó stāā cajī ni jāá nduú jínī ndá nú nāsa cúu, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ñúcuán de ndá tēe scuáha jíín yā nī jīcā tūhún táhán ndá de: ¿A ja nī nquisiáha iin nchivī jā ní nchajī yā, á naá cúu? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","De nī ncāhān Jesús: Jā ní ncachī ni jā íyó jā cajī ni cúu jā cúsiī inī ni sáhá nī tiñu cúnī Yāā nī ntají nduhū vāji nī, jíín jā sínu nī tiñu jā ní jēhe yā nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","De cáhān ndá nú jā cúmanī cūmī cā yōō de tēhndē trigo. Sochi nduhū chi cáhān ni jíín nú: Cūndēhé ndá nú, chi nchivī cuāhā cúu ji tá cúu trigo jā ní ncuaān jā tēhndē, chi ja íyó tūha ji candíja ji nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","De ndá tēe scándíja nchivī, cúu dē tá cúu tēe jéhndē trigo, de nīhīn dē yāhvi dē. De jā nástútú ndá dē nchivī cúu jā cutecū ji níí cání andiví. De ndá tēe jā scútē nuu tūhun nī xihna cā, cúu dē modo tēe jítē trigo, de inuú-ni cusiī inī dē jíín ndá cā tēe jā stéhēn cā sīquī ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chi ndāā cáhān iin tūhun: Iin tēe jítē, de incā tēe nástútú, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","De jā suu cúu jā ní ntají nī ndá ndóhó jā scándíja nú nchivī ja nī jini tūhun nī nī nacani incā tēe. Chi ndá cā tēe chi ja nī nacani dē tūhun nūū nchivī, de ndá máá nú chi modo jā nástútú nú ji cúu jā scándíja nú ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","De cuāhā nchivī Samaria jā ndéē ñuū ñúcuán, nī ncandíja ji Jesús jā ní jini ji tūhun jā ní ncāhān ñahan ñúcuán. Chi nī ncāhān ña jā ní ncachī yā ndihi ndācá jā ní nsāhá ña. ");
INSERT INTO mieNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jā suu cúu jā ndá nchivī Samaria ñúcuán nī nquenda ji nūū yā, de nī ncāhān ndāhví ji jíín yā jā ná quéndōo yā ñuū ji. De nī ndōo yā ñúcuán ūū quīvī. ");
INSERT INTO mieNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","De cuāhā cā ji nī ncandíja ji yā jíín tūhun cáhān maá yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","De nī ncāhān ndá ji jíín ñahan ñúcuán: Nduú cā jíni ñúhún jā cāhān maá nú de candíja nī yā, chi ja nī jini ndá nī tūhun jā cáhān maá yā. De jínī ndācá ó jā maá yā cúu ndija Cristo, Yāā jā scácu nchivī ñayīví, ncachī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","De tá nī nchāha ūū quīvī, de Jesús nī nquee yā Samaria, de nī naquehen yā ichi cuānohōn yā región Galilea. ");
INSERT INTO mieNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Chi ja nī ncāhān maá yā jā ndá tēe nácani tūhun Yāā Dios, nduú íyó yíñúhún nchivī ñuū dē jíín dē, de saá-ni jíín maá yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","De tá nī nenda yā Galilea, de nchivī ñúcuán nī jetáhví ji yā, chi suni maá ji nī jēhēn ji vico pascua Jerusalén, de nī jinī ndá ji ndācá tiñu nī nsāhá yā quīvī jā ní īyo vico ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ñúcuán de nī jēhēn tucu yā ñuū Caná ndáñúū Galilea, nūū ní nsāhá yā jā ndute nī nduu vino. De inī ñuū Capernaum nī īyo iin tēe cúñáhnú jā ndíso tíñú nūū rey. De cúhū sēhe dē. ");
INSERT INTO mieNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tēe ñúcuán nī nīhīn dē tūhun jā ní nquenda tucu Jesús región Galilea jā ní jēhēn yā región Judea. De nī jēndēhé dē yā, de nī ncāhān ndāhví dē jā ná quíhīn yā jíín dē vehe dē, de nasāhá vāha yā sēhe dē, chi ja ñatin cuū ji. ");
INSERT INTO mieNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","De nī ncāhān yā jíín dē: Tú mā cūní nú ndá tiñu ñáhnú jā sāhvi inī nū sāhá, de mā cándíja cuitī ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","De tēe ndíso tíñú nūū rey, nī ncāhān dē: Señor, sāhá ní favor ná cóhōn, chi tú ná cúcuéé ní de cuū sēhe sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ñúcuán de nī ncāhān Jesús: Cuánohōn vehe nú, chi cutecū sēhe nú. De nī ncandíja dē tūhun nī ncāhān Jesús, de cuānohōn dē-ni. ");
INSERT INTO mieNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","De juni jíca dē cuānohōn dē vehe dē, de nī nquenda ndá mozo dē nī nquitahān ji dē, de nī ncāhān ji: Ja nī nduvāha sēhe ní, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","De nī jīcā tūhún dē nā hora cúu jā ní nquijéhé nī nduvāha ji. De nī ncāhān ndá ji jíín dē: Cahiin icu nī nquee cahni ji. ");
INSERT INTO mieNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ñúcuán de maá tatá ji nī nsāhá dē cuenta jā hora ñúcuán cúu jā ní ncāhān Jesús jíín dē jā cutecū sēhe dē. De nī ncandíja dē jíín níí vehe dē jā cúu yā Yāā jā ní ntají Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yáhá cúu vuelta ūū jā ní nsāhá Jesús tiñu ñáhnú jā ní stéhēn yā poder yā región Galilea, tá nī nenda yā jā ní jēhēn yā región Judea. ");
INSERT INTO mieNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ñúcuán de cuāhān tucu Jesús Jerusalén, chi íyó tucu vico jā sáhá ndá táhán yā hebreo. ");
INSERT INTO mieNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","De Jerusalén íyó iin pila ndute ñatin maá viéhé jā nání viéhé tīcāchí. De yuhú hebreo nání Betesda. De nūū íyó pila ñúcuán íyó ūhūn corredor. ");
INSERT INTO mieNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","De ndá corredor ñúcuán cáá cuāhā nchivī cúhū, jā cuāá, jā cojo, jā vehlé. De ndétu ndá ji jā candā ndute ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Chi íyó quīvī jā cúun iin ángel yā nūū pila, de scándā yā ndute. De nchivī jā quívi xihna cā inī pila tá scándā yā ndute, de ndúvāha ji nā-ni cuēhē ndóho ji. ");
INSERT INTO mieNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","De ñúcuán cáá iin tēe jā ní ncuu ōcō xāhōn ūnī cuīyā cúhū dē. ");
INSERT INTO mieNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","De nī jinī Jesús jā cáá dē, de nī jinī yā jā ní ncuu cuāhā cuīyā cúhū dē. De nī ncāhān yā jíín dē: ¿A cúnī nū nduvāha nú? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","De nī ncāhān tēe cúhū: Señor, nduú níhīn sá ni iin tēe squívi sāán inī pila tá cándā ndute. Chi ndācá vuelta jā cúnī sá quīvi sá, de quívi-ni incā nchivī xihna cā, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","De nī ncāhān Jesús: Nacōo de naquehen nú camilla nū de caca nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","De tēe ñúcuán nī nduvāha dē-ni. De nī naquehen dē camilla dē, de nī nquijéhé dē jíca dē. De quīvī nátātú cúu quīvī ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","De nī ncāhān ndá táhán dē hebreo jíín dē: Quīvī nátātú cúu mitan. De cáchī ley jā má cūú cuiso nú camilla nū. ");
INSERT INTO mieNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","De nī ncāhān tēe nī nduvāha: Tēe jā ní nasāhá vāha nduhū, nī ncāhān dē jíín nī jā naquehen nī camilla ni de caca nī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ñúcuán de nī jīcā tūhún ndá dē: ¿Ní tēe nī ncāhān jíín nú jā naquehen nú camilla nū de caca nú? ");
INSERT INTO mieNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","De tēe nī nduvāha, nduú jínī dē ní iin tēe cúu jā ní nasāhá vāha dē. Chi íñí cuāhā nchivī ñúcuán, de Jesús ja cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","De cuéé cā de nī naquetáhán Jesús jíín dē inī templo cāhnú. De nī ncāhān yā: Mitan chi nī nduvāha nú. De mā sāhá cā nū cuāchi, chi tú nduú, de quiji iin tūndóhó xéēn cā sīquī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sá de cuāhān tēe ñúcuán de nī ncachī tūhun dē nūū ndá táhán dē hebreo jā Jesús cúu jā ní nasāhá vāha yā dē. ");
INSERT INTO mieNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","De sīquī jā ní nsāhá Jesús tiñu yáhá quīvī nátātú, jā ñúcuán cúu jā ndá tēe hebreo jínī ūhvī dē yā, de cúnī ndá dē cahnī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","De nī ncāhān Jesús jíín ndá dē: Maá Tatá nī chi níí cání sáhá yā tiñu váha, de suni súcuán sáhá maá nī tiñu váha. ");
INSERT INTO mieNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","De sīquī jā ní ncāhān yā súcuán, de ndá tēe hebreo víhí cā cúnī dē cahnī dē yā. Chi nsūú maá-ni jāá nduú squíncuu yā jā cáhān ley sīquī quīvī nátātú, chi suni jā ní ncāhān yā jā Tatá yā cúu Yāā Dios de súcuán sáhá inuú yā maá yā jíín Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","De nī ncāhān Jesús: Jāndáā cáhān ni jíín ndá nú: Nduhū jā cúu Sēhe Yāā Dios, ni iin mā cūú sāhá nī jā maá nī, chi sáhá nī maá-ni tiñu jā jínī ni jā sáhá Tatá nī. Chi ndācá jā sáhá Tatá nī, suni sáhá nduhū jā cúu nī Sēhe yā. ");
INSERT INTO mieNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Chi Tatá nī mānī yā jíín nduhū jā cúu nī Sēhe yā, de stéhēn yā nūū ni ndihi jā sáhá yā. De coo tiñu ñáhnú cā jā stéhēn cā yā nsūú cā jā ní ncuu mitan, jā sāhvi inī ndá nú cunī nū. ");
INSERT INTO mieNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Chi tá cúu nūū nástécū Tatá nī ndīyi de cutecū tucu ji, saá-ni nduhū jā cúu nī Sēhe yā, suni sáhá nī jā cutecū ní-ni cúu jā cúnī maá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","De maá Tatá nī, nduú sándaā yā sīquī ni iin nchivī, chi nī jēhe yā tūhun jā sándaā maá nī sīquī ndācá nchivī, chi Sēhe yā cúu nī. ");
INSERT INTO mieNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","De súcuán de coo yíñúhún ndihi nchivī nūū ni, tá cúu nūū íyó yíñúhún ji nūū Tatá nī. De nchivī jāá nduú íyó yíñúhún nūū ni, túsaá de suni nduú íyó yíñúhún ji nūū maá Tatá nī, Yāā jā ní ntají nduhū vāji nī. ");
INSERT INTO mieNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Jāndáā cáhān ni jíín ndá nú: Tú iin nchivī chuhun inī ji tūhun cáhān ni, de candíja ji jā Yāā ndāā cúu Yāā jā ní ntají nduhū vāji nī, nchivī ñúcuán cutecū ji níí cání andiví, de mā tánū tāhvī ji. Chi mā cōó cā ji tá cúu ndīyi, chi sa cutecū ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Jāndáā cáhān ni jíín ndá nú jā quiji quīvī, de mitan de ja nī nquijéhé, jā ndācá nchivī jā cúu tá cúu ndīyi, cuni ndá ji tūhun jā cáhān nduhū, Sēhe Yāā Dios. De nchivī cuetáhví chi cutecū ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Chi tá cúu nūū íyó poder maá Tatá nī jā sáhá yā jā técū ndācá-ni, suni súcuán nī jēhe yā poder nūū maá nī jā sāhá nī jā cutecū ndācá-ni. ");
INSERT INTO mieNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","De suni nī nsāhá yā jā ndíso tíñú nī jā sándaā ni sīquī nchivī, chi cúu nī Yāā nī nduu tēe. ");
INSERT INTO mieNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mā sáhvi inī ndá nú cani inī nū sīquī tūhun cáhān ni. Chi quiji quīvī jā ndācá ndīyi cuni ji tūhun cáhān ni, ");
INSERT INTO mieNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","de quee ji nūū yíyuhū ji. De ndá ndīyi jā ní nsāhá tiñu váha, natecū ji jā cutecū ji níí cání. De ndá ndīyi jā ní nsāhá tiñu néhén, natecū ji de quīvi ji nūū tānū tāhvī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ni iin mā cūú sāhá nī jā maá nī. Chi nāsa ndácu Yāā Dios nūū ni, súcuán sándaā ni tiñu nchivī. De ndāā sándaā ni, chi nduú sáhá nī jā cúnī maá nī, chi sáhá nī jā cúnī maá Tatá nī, Yāā nī ntají nduhū vāji nī. ");
INSERT INTO mieNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tú maá nī cāhān jā cúu nī Sēhe Yāā Dios, de cachī nchivī jāá nduú jétíñú tūhun cáhān ni. ");
INSERT INTO mieNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Sochi íyó incā jā cáhān jā cúu nī Sēhe yā. De jínī ni jā tūhun cáhān yā, chi níhīn tīñú. ");
INSERT INTO mieNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ndá máá nú nī ntají nú ndá tēe jā ní jīcā tūhún dē Juan. De Juan chi ndāā nī ncāhān dē tūhun nī. ");
INSERT INTO mieNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","De vísō súcuán de nsūú nduhū cúu jā jíni ñúhún jā stéhēn iin tēe jā Sēhe Yāā Dios cúu nī. Chi ndá máá nú cúu jā jíni ñúhún, tácua candíja ndá nú de cācu nú. Jā ñúcuán nī ncāhān ni jā íyó ndāā tūhun nī jā ní nacani Juan. ");
INSERT INTO mieNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Maá Juan nī ncuu dē tá cúu iin lámpara jā cáyū de cútūu, cúu jā ní nacani dē tūhun nī. De ndá máá nú chi jacū-ni quīvī nī jētahān inī nū jā ní stéhēn dē nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Sochi íyó jā stéhēn cājí cā jā cúñáhnú nī nsūú cā jā ní ncāhān Juan. Maá tiñu sáhá nī, suu stéhēn cājí jā Tatá nī nī ntají ndija yā nduhū vāji nī, chi tiñu yáhá nī ntetíñú yā nduhū jā sāhá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","De Tatá nī jā ní ntají yā nduhū vāji nī, suni maá yā cáhān nūū tutū īī jā cúñáhnú nī, vísō nduú ní jíni jíín sóho ndá nú jā cáhān yā, de ni nduú ní jínī jínúū nū yā. ");
INSERT INTO mieNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Sochi nduú ní nchúhun inī ndá nú tūhun jā ní ncāhān Tatá nī, chi nduú cándíja ndá nú nduhū, Yāā jā ní ntají yā. ");
INSERT INTO mieNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","De nánducú viī ndá nú ndācá tūhun cáhān tutū īī, chi jáni inī nū jā ñúcuán nīhīn nū tūhun jā cutecū nū níí cání sāhá. De sīquī maá nī cúu jā cáhān tutū īī. ");
INSERT INTO mieNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sochi nduú cúnī ndá nú cuetáhví nú nduhū jā quīvi nú ndahá nī tácua cutecū nū níí cání. ");
INSERT INTO mieNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nduú sáhá nī cuenta tūhun jā cáhān ndá nchivī jā cúñáhnú nī. ");
INSERT INTO mieNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Chi ja jínī ni nāsa cúu ánō ndá nú jāá nduú íyó mānī nū jíín Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nduhū vāji nī jíín tiñu cúnī Tatá nī, de nduú jétáhví ndá nú nduhū. Sochi tú incā tēe quenda dē jíín tiñu cúnī maá dē, de sa tēe ñúcuán ñamā cuetáhví nú dē. ");
INSERT INTO mieNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Nāsa cuu candíja ndá nú? Chi máni jā cúnī ndá nú jā cuñáhnú nú sāhá ndá táhán nú, de nduú ndúcú nú jā cuñáhnú nú sāhá Yāā Dios, jā íyó mátúhún-ni yā. ");
INSERT INTO mieNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mā cāní inī ndá nú jā cāhān ni cuāchi sīquī nū nūū Tatá nī. Chi íyó iin jā cāhān cuāchi sīquī nū, suu Moisés, tēe jā ñúhún inī ndá nú jā quendōo ndāā nū jíín ley jā ní ntee dē. ");
INSERT INTO mieNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Chi tú ní ncándíja ndá nú jā ní ntee Moisés, de suni candíja nú nduhū nícu, chi tūhun maá nī cúu jā ní ntee dē. ");
INSERT INTO mieNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Te tú nduú cándíja ndá nú tūhun nī jā ní ntee dē, ¿de nāsa candíja nú tūhun cáhān maá nī túsaá? ncachī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ñúcuán de cuāhān Jesús incā lado mar Galilea, jā cúu mar Tiberias. ");
INSERT INTO mieNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","De cuāhā ndasí nchivī nī jēcuniquīn ji yā, chi nī jinī ji ndācá tiñu ñáhnú jā stéhēn yā poder yā jā ní nasāhá vāha yā nchivī cúhū. ");
INSERT INTO mieNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","De nī ncaa yā iin yucu, de nī jēcundeē yā ñúcuán jíín ndá tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","De ja nī ncuñatin vico pascua jā núcūhun inī ndá táhán yā hebreo jā ní ncācu ji nūū nchivī nación Egipto. ");
INSERT INTO mieNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","De nī nūcūndēhé yā, de nī jinī yā jā váji cuāhā ndasí nchivī. De nī ncāhān yā jíín Felipe: ¿Ní jondē cueen ó jā cajī ndá nchivī yáhá? ");
INSERT INTO mieNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","De súcuán nī ncāhān yā jā jíto túnī yā dē tú nāsa cāhān dē. Chi ja jínī maá yā nāsa sāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","De nī ncāhān Felipe jíín yā: Ni mā quēndá ūū ciento denario stāā jā cajī ndá ji vísō jacū-ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ñúcuán de nī ncāhān incā tēe scuáha jíín yā, jā cúu Andrés, ñanī Simón Pedro: ");
INSERT INTO mieNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Yáhá íyó iin tēe lulí jā ndíso ji ūhūn stāā cebada jíín ūū tiacá. ¿De ní quenda ñúcuán, chi nchivī cuāhā ndasí cúu? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ñúcuán de nī ncāhān Jesús: Cāhān ndá nú jíín nchivī ná cúndeē ji, ncachī yā. De ñúcuán íyó cuāhā itē, de nī jēcundeē ndá ji, de tá ūhūn mil tēe cúu. ");
INSERT INTO mieNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","De nī nquehen Jesús stāā ñúcuán, de xihna cā nī nacuetáhví yā nūū Yāā Dios. De nī jēhe yā nūū ndá tēe scuáha jíín yā, de ndá máá dē nī nsajī dē nūū ndá nchivī ndéē ñúcuán. De suni súcuán nī nsāhá yā jíín tiacá, de nī nchajī ndá ji nāsaa cúnī ji cajī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","De tá nī ndahā chījin ji, de nī ncāhān yā jíín ndá tēe scuáha: Nastútú ndá nú ndá pedazo jā ní nquendōo, tácua mā náā cuitī. ");
INSERT INTO mieNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","De nī nastútú ndá dē, de nī nchitú ūxī ūū tīcá pedazo jā ní nquendōo cā sīquī ndihúhūn stāā cebada. ");
INSERT INTO mieNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","De jā ní jinī ndá nchivī tiñu ñáhnú jā ní nsāhá Jesús jā stéhēn yā poder yā, de nī ncāhān ji: Jāndáā ndija jā tēe yáhá cúu jā cáhān tutū jā quiji inī ñayīví jā nacani tūhun Yāā Dios, ncachī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","De nī jinī Jesús jā cúnī ndá ji sāhá ji fuerza jā cuu yā rey ji nícu. De nī ncujiyo tucu mátúhún yā-ni, nī ncaa yā cuāhān yā nūū sūcún cā yucu. ");
INSERT INTO mieNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","De jā cuácuneē, de ndá tēe scuáha jíín yā nī nuu dē yucu cuāhān dē nūū mar. ");
INSERT INTO mieNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","De nī ndīvi ndá dē inī barco, de nī scáca dē jā quīhīn dē incā lado mar jondē ñuū Capernaum. De ja nī ncuneē, de ncháha ca nenda Jesús nūū ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ñúcuán de nī jīquīhi iin tāchī níhin, de jísō ndute mar sáhá. ");
INSERT INTO mieNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","De tá nī ncuu tá cúu ūhūn á īñū kilómetro jíca ndá dē jíín barco, de nī jinī dē jā jíca Jesús nūū mar, de nī ncuñatin yā nūū barco. De nī nchūhú ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","De maá yā nī ncāhān yā jíín dē: Maá nī cúu, de mā cúyūhú ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","De nī ncusiī inī ndá dē jā ná quívi yā inī barco. De nī nsāhá yā jā ñamā-ni nī nquenda barco nūū ñuhun yíchí nūū cuáhān ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","De quīvī téēn de ndá nchivī jā ní nquendōo incā lado mar, nī jinī ji jā ndá tēe scuáha jíín yā cuāhān dē jíín mátúhún-ni barco jā ní īyo ñúcuán, jíín jāá nduú ní nquívi Jesús jā quīhīn yā jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sá de sava cā barco jā váji ichi ñuū Tiberias, nī nquenda ñatin lugar nūū ní nchajī ndá ji stāā jā ní nacuetáhví maá Jētohō ō jēhē. ");
INSERT INTO mieNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","De jā ní jinī nchivī jāá nduú cā Jesús íyó yā ñúcuán, de ni ndá tēe scuáha jíín yā, de nī nquīvi ji ndá barco ñúcuán, de cuāhān ji ñuū Capernaum cuānanducú ji yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","De tá nī nquenda ji jondē incā lado mar, de nī nanihīn ji Jesús. De nī jīcā tūhún ji yā: Maestro, ¿nā hora nī nquenda ní yáhá? ");
INSERT INTO mieNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","De nī ncāhān Jesús: Jāndáā cáhān ni jíín ndá nú jā nánducú nú nduhū sīquī jā ní nchajī nū jondē nī ndahā chījin nú, de nsūú sīquī jā ní jinī nū ndācá tiñu ñáhnú jā ní stéhēn ni poder ni. ");
INSERT INTO mieNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mā cúndihvī inī nū maá-ni sīquī jā cajī nū jā ñamā nataxīn, chi sa cundihvī inī nū jā nīhīn nū stāā jā cutecū nū níí cání sāhá. De nduhū, Yāā nī nduu tēe, taji nī maá stāā jā cutecū nū níí cání. Chi Tatá nī Yāā Dios nī jani yā nduhū jā sáhá nī súcuán, ncachī yā jíín ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ñúcuán de nī jīcā tūhún ji yā: ¿Nāsa sāhá ndá sá tácua squíncuu sá tiñu cúnī Yāā Dios? ");
INSERT INTO mieNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","De nī ncāhān Jesús: Tiñu jā cúnī Yāā Dios cúu jā candíja ndá nú nduhū, Yāā jā ní ntají yā vāji. ");
INSERT INTO mieNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ñúcuán de nī ncāhān ndá ji: ¿Túsaá de nā tiñu ñáhnú sāhá ní cunī ndá sá de candíja sá jā ní ntají yā níhín? ¿Nā tiñu cúu jā sáhá ní? ");
INSERT INTO mieNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chi ndá tatā ō janahán nī nchajī dē maná jā ní ncuun ichi andiví jondē nūū ñuhun tíhá, tá cúu nūū yósō nūū tutū īī: Yāā Dios nī jēhe yā stāā nī ncuun ichi andiví nī nchajī ndá ji, cáchī tutū, ncachī ndá ji jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","De nī ncāhān Jesús: Jāndáā cáhān ni jíín ndá nú: Nsūú Moisés ní jéhe stāā ñúcuán nūū ndá dē jā ní ncuun ichi andiví, chi maá Tatá nī nī jēhe. De maá yā jéhe stāā andiví jā cutecū nū níí cání sāhá. ");
INSERT INTO mieNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chi stāā jā jéhe Yāā Dios cúu maá Yāā jā ní ncuun ichi andiví, de sáhá yā jā nchivī ñayīví cutecū ji níí cání andiví, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","De nī ncāhān ndá ji: Señor, níní cuāha ní stāā ñúcuán cajī ndá sá túsaá. ");
INSERT INTO mieNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","De nī ncāhān Jesús: Maá nī cúu maá stāā jā cutecū nū níí cání sāhá. Nā-ni nchivī quívi ndahá nī, mā cōcón cuitī cā ji. De nā-ni nchivī cándíja nduhū, mā yíchī cuitī cā ji. ");
INSERT INTO mieNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Sochi ndá ndóhó ja nī ncāhān ni jíín nú jāá nduú cándíja nú nduhū, vísō nī jinī nū nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ndācá nchivī jā sáhá Tatá nī jā candíja ji nduhū, maá ji quívi ndahá nī. De jétáhví nī ndācá ji jā cúnī ji quīvi ji ndahá nī, chi mā tají cuitī ni ji. ");
INSERT INTO mieNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Chi nī nquiji nī jondē andiví tácua sāhá nī tiñu jā cúnī Yāā jā ní ntají nduhū, de nsūú jā sāhá nī jā cúnī maá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","De tiñu jā cúnī Tatá nī, Yāā nī ntají nduhū, cúu jā má scuíta nī ni iin nchivī jā jéhe yā nūū ni, chi coto nī ji de nastécū ni ji quīvī jīnu ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","De Yāā nī ntají nduhū, cúnī yā jā ndācá nchivī jā níhīn ji tūhun nduhū de candíja ji nduhū jā cúu nī Sēhe Yāā Dios, cutecū ji níí cání andiví. Chi nastécū ni ji quīvī jīnu ñayīví, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ñúcuán de nī nquijéhé ndá táhán yā hebreo cáhān ji contra sīquī yā, chi nī ncāhān yā jā maá yā cúu stāā jā ní ncuun ichi andiví. ");
INSERT INTO mieNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","De nī ncāhān ji: ¿A nsūú tēe yáhá cúu Jesús sēhe José? De jínī ō tatá dē naná dē. ¿De nāsa cúu jā cáhān dē jā ní ncuun dē ichi andiví túsaá? ");
INSERT INTO mieNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","De nī ncāhān Jesús jíín ndá ji: Mā cáhān ndá nú sīquī ni. ");
INSERT INTO mieNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni iin nchivī mā cūú quīvi ji ndahá nī de tú mā sāhá Tatá nī jā cuu inī ji quīvi ji, chi maá yā nī ntají nduhū vāji nī. De nastécū ni ji quīvī jīnu ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","De suha yósō nūū tutū jā ní ntee ndá tēe nī nacani tūhun Yāā Dios janahán: Ndācá ji chi stéhēn Yāā Dios nūū ji, cáchī. Túsaá de ndācá nchivī jā jíni tūhun jā cáhān Tatá nī de jétáhví ji jā stéhēn yā nūū ji, nchivī ñúcuán chi quīvi ji ndahá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ni iin nchivī nduú ní jínī cuitī ji nūū maá Tatá nī. Chi mátúhún-ni nduhū cúu jā ní jinī nūū yā, chi jondē nūū maá yā vāji nī. ");
INSERT INTO mieNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jāndáā cáhān ni jíín ndá nú jā nchivī jā candíja jā scácu nī ji, maá ji cutecū ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Maá nī cúu stāā jā cutecū nū níí cání sāhá. ");
INSERT INTO mieNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ndá tatā nū janahán, nī nchajī dē stāā maná jā ní ncuun ichi andiví jondē nūū ñuhun tíhá, sochi nduú ní nsáhá jā cutecū dē níí cání. ");
INSERT INTO mieNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","De stāā jā cáhān ni jā váji ichi andiví, chi nā-ni nchivī cajī, de cutecū ji níí cání andiví. ");
INSERT INTO mieNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","De suu maá nī cúu stāā ñúcuán jā ní nquiji ichi andiví jā sáhá jā cutecū nū níí cání. De nchivī jā cajī stāā yáhá, cutecū ji níí cání andiví. De stāā jā cuāha nī cúu yiqui cúñu nī, de cuāha nī tácua nchivī ñayīví cutecū ji níí cání, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ñúcuán de ndá táhán yā hebreo nī ncāhān ji jíín táhán ji: ¿Nāsa cuu cuāha tēe yáhá yiqui cúñu dē cajī ō? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","De nī ncāhān Jesús jíín ji: Jāndáā cáhān ni jíín ndá nú: Tú mā cándíja nú jā yiqui cúñu nduhū, Yāā nī nduu tēe, cúu tá cúu stāā, de nīñī ni cúu tá cúu ndute, túsaá de mā cútecū nū níí cání sāhá. ");
INSERT INTO mieNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Chi ndá nchivī jā candíja jā yiqui cúñu nī cúu tá cúu stāā de nīñī ni cúu tá cúu ndute, maá ji cutecū níí cání. De nastécū ni ji quīvī jā jīnu ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chi yiqui cúñu nī jíín nīñī ni cúu ndija jā sāhá jā cutecū ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","De ndá nchivī jā candíja jā yiqui cúñu nī jíín nīñī ni cúu tá cúu stāā jíín ndute jā cutecū ji níí cání sāhá, maá ji íñí nīhin ji jíín nī, de íyó nī jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Maá Tatá nī, Yāā técū, nī ntají yā nduhū vāji nī, de técū ni sáhá maá yā. De saá-ni ndá nchivī jā candíja jā cúu nī tá cúu stāā ji jíín ndute ji, suni súcuán cutecū ji níí cání sāhá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Maá nī cúu stāā jā ní nquiji ichi andiví. De stāā jā cáhān ni nduú cúu tá cúu stāā maná jā ní nchajī ndá tatā nū janahán, chi nduú ní nsáhá jā cutecū ji níí cání. Chi stāā jā cáhān ni, de nchivī jā cajī, cutecū ji níí cání sāhá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ndá tūhun yáhá nī stéhēn Jesús nūū nchivī jā ní ndutútú inī vehe īī sinagoga ñuū Capernaum. ");
INSERT INTO mieNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","De cuāhā nchivī scuáha jíín yā, nī jini ji tūhun yáhá jā ní stéhēn yā, de nī ncāhān ndá ji: Víjín ndasí tūhun yáhá. ¿Nāsa cuu cuetáhví ó túsaá? ");
INSERT INTO mieNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","De nī jinī Jesús jā cáhān ndá ji jā víjín cúu tūhun yáhá, de nī ncāhān yā: ¿A víjín sáhá tūhun yáhá jíín ndá nú? ");
INSERT INTO mieNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿De nāsa sāhá nú de tú cunī nū jā nduhū, Yāā nī nduu tēe, ndaa nī quīnohōn ni nūū ní ndeē ni xihna ñúhún? ");
INSERT INTO mieNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Maá ánō nchivī cúu jā sáhá jā técū ji. Chi yiqui cúñu ji nduú jétíñú cuitī súcuán. De ndá tūhun jā ní ncāhān ni jíín nú cúu jā quendōo vāha ánō nū, de cutecū nū níí cání sāhá. ");
INSERT INTO mieNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sochi sava nú chi nduú cándíja nú, ncachī yā. Chi jondē jā xíhna ñúhún ja jínī Jesús nā nchivī cúu jā má cándíja, jíín ní iin dē cúu jā nastúu dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","De nī ncāhān cā yā: Jā ñúcuán nī ncāhān ni jíín ndá nú jā má cūú quīvi ni iin nchivī ndahá nī de tú mā sāhá Tatá nī jā cuu inī ji quīvi ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","De jondē quīvī ñúcuán de cuāhā nchivī scuáha jíín yā, nī sndóo ji yā, de nduú cā ní jíca ji jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ñúcuán de nī ncāhān yā jíín ndihúxī ūū tēe scuáha jíín yā: ¿A suni cúnī ndá máá nú quīhīn nū, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","De nī ncāhān Simón Pedro: Señor, ¿nā nūū cā quīhīn sá? Chi maá ní cúu jā nácani tūhun jā cutecū sá níí cání sāhá. ");
INSERT INTO mieNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","De nī ncandíja ndá sá de jínī sá jā maá ní cúu Cristo, Sēhe Yāā Dios, Yāā técū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","De nī ncāhān Jesús: De vísō nī nacāji nī ndihúxī ūū ndá nú, de íyó iin nú jā ní nquīvi tāchī inī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","De súcuán nī ncāhān yā sīquī Judas Iscariote, sēhe Simón. Chi maá dē nastúu dē yā, vísō iin táhán jā úxī ūū tēe scuáha jíín yā cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ñúcuán de jíca nuu Jesús región Galilea. Chi nduú cúnī yā caca nuu yā región Judea, chi ndá táhán yā hebreo jā ndéē ñúcuán, cúnī dē cahnī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","De cuācuñatin vico jā sāhá ndá táhán yā hebreo vehe ramádā jā cundeē ji. ");
INSERT INTO mieNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","De ndá ñanī yā nī ncāhān dē jíín yā: ¿Nūcu maá yáhá-ni íyó nú? Vāha cā quīhīn nū región Judea, tácua ndá tēe ñúcuán jā cándíja dē ndóhó, suni cunī dē tiñu ñáhnú jā sáhá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Chi tú cúnī iin tēe jā cūtē nuu tūhun dē, de mā sāhá yuhū dē tiñu. De tú sáhá nú ndācá tiñu ñáhnú, vāha cā sāhá nú jā cunī ndiviī nchivī túsaá. ");
INSERT INTO mieNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Súcuán nī ncāhān ndá ñanī yā jíín yā, chi ni ndá máá dē nduú cándíja dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ñúcuán de nī ncāhān Jesús: Ncháha ca quenda maá quīvī jā quíhīn ni. De ndá máá nú chi nā-ni quīvī de cuu quīhīn nū. ");
INSERT INTO mieNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Chi mā quítī inī nchivī ñayīví cunī ji ndóhó, de maá nī chi quítī inī ji jínī ji, chi cáhān ni jā maá-ni tiñu néhén sáhá ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cuáhán ndá máá nú vico. De maá nī chi mā quíhīn ni mitan, chi ncháha ca quenda maá quīvī jā cánuú quīhīn ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Súcuán nī ncāhān yā tūhun yáhá jíín ndá dē, de nī nquendōo yā Galilea. ");
INSERT INTO mieNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","De tá nī nchāha ndá ñanī yā cuāhān dē vico ñúcuán, de sá de suni cuāhān maá yā. De nduú ní jéhēn nijīn yā, chi nduú ní stúu yā maá yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","De ndá táhán yā hebreo nánducú ji yā vico ñúcuán, de cáhān ndá ji: ¿Ní cúu nūū íyó tēe ñúcuán? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","De ndasí nī ncāhān nchivī jā síquī yā, chi sava ji cáhān: Tēe vāha cúu dē. De sava cā ji cáhān: Nduú chi stáhví dē nchivī. ");
INSERT INTO mieNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","De yuhū-ni nī ncāhān ji tūhun yā, chi yúhú ji jā quītī inī ndá táhán ji hebreo. ");
INSERT INTO mieNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","De tá nī ncuu sava vico, de nī nquenda Jesús, nī nquīvi yā templo cāhnú, de nī nquijéhé yā stéhēn yā tūhun. ");
INSERT INTO mieNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","De nī nsāhvi inī ndá táhán yā hebreo níni ji, de nī ncāhān ji: ¿Nāsa jínī tēe yáhá cuāhā tūhun ndíchí? Chi nduú ní jíca dē escuela, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ñúcuán de nī ncāhān Jesús: Tūhun jā stéhēn ni chi nsūú tūhun maá nī cúu, chi tūhun jā ní jēhe maá Yāā jā ní ntají nduhū cúu. ");
INSERT INTO mieNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tú iin nchivī cúnī ji sāhá ji tiñu cúnī Yāā Dios, nchivī ñúcuán chi jīcūhun inī ji á jondē nūū Yāā Dios vāji tūhun stéhēn ni, á tūhun jā jáni inī maá nī cúu. ");
INSERT INTO mieNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tēe jā cáhān tūhun jáni inī maá dē, tēe ñúcuán ndúcú dē jā sāhá ñáhnú nchivī dē. De tú iin tēe ndúcú dē sāhá ñáhnú dē Yāā jā ní ntají dē, tēe ñúcuán cúu tēe ndāā, de nduú nā tūhun stáhví íyó jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿A nsūú jā ní jēhe Moisés ley yā nūū nū jā squíncuu nú? De ni iin nú nduú squíncuu. Chi sa jā cúnī ndá nú cahnī nū nduhū, ¿de nājēhē cúu? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","De nī ncāhān ndá nchivī ñúcuán: Tāchī ndóho nú. ¿Ní iin cúnī cahnī ndóhó? ");
INSERT INTO mieNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","De nī ncāhān Jesús: Nī nasāhá vāha nī iin tēe quīvī nátātú, de ndiviī nū nī nsāhvi inī nū nī jinī nū jā quīvī nátātú nī nsāhá nī tiñu ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","De Moisés nī jēhe dē ley jā cúu circuncidar nūū ndá nú. De sáhá ndá nú circuncidar sūchí yíí nūū únā quīvī jā ní ncacu ji, vísō quīvī nátātú cúu. (Sochi nsūú maá Moisés ní jáquīn ley ñúcuán, chi ja nī īyo nūū ndācá tatā dē.) ");
INSERT INTO mieNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Túsaá de tú sáhá ndá nú circuncidar vísō quīvī nátātú cúu, tácua squíncuu nú ley Moisés, ¿de nūcu quítī inī ndá nú jā ní nasāhá vāha ndasí nī iin tēe quīvī nátātú? ");
INSERT INTO mieNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mā cāní ñamā inī nū jā cuāchi sáhá nī. Chi sa cani vāha inī nū sīquī ndācá tiñu váha, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ñūcuán de sava nchivī Jerusalén nī jīcā tūhún táhán ji: ¿A nsūú tēe yáhá cúu jā nánducú ndá tēe cúñáhnú jā cahnī dē, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","De yáhá cáhān nijīn dē nūū chitú, de nduú ni iin jásī jā sáhá dē. ¿A sanaā de nī ncundaā inī ndá tēe cúñáhnú jā tēe yáhá cúu Cristo jā cáchī tutū jā quiji, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","De nduú chi ja jínī ō ní nūū váji tēe yáhá. De tá quiji Cristo, chi ni iin ó mā cúnī ō ní jondē quiji yā, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ñúcuán de nī ncāhān jee Jesús jā stéhēn yā tūhun inī templo: Jínī ndá nú nduhū, de jínī nū nā ñuū vāji nī. De vísō súcuán de maá Yāā ndāā cúu jā ní ntají nduhū vāji nī, de nduú vāji nī jā cúnī maá nī. De nduú jínī ndá nú nāsa Yāā cúu yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","De maá nī chi jínī ni yā, chi jondē nūū maá yā vāji nī, de maá yā nī ntají nduhū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ñúcuán de nī nducú ndá dē tiin dē yā. De ni iin dē nduú ní ncúu tiin dē yā, chi ncháha ca quenda maá quīvī jā tiin dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sochi cuāhā nchivī nī ncandíja ji yā, de nī ncāhān ji: ¿A nsūú tēe yáhá cúu Cristo, Yāā ndétu ó jā quiji? Chi cuāhā ndasí tiñu ñáhnú sáhá yā jā stéhēn yā poder yā, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","De nī jinī ndá tēe fariseo jā súcuán cáhān ndá nchivī tūhun yā. De ndá máá dē jíín ndá sūtū cúñáhnú, nī ntají dē ndá policía jā jíto templo, vāji dē jā tiin dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","De nī ncāhān Jesús: Jacū-ni cā quīvī coo nī jíín ndá nú. Ñúcuán de quīnohōn ni nūū Yāā nī ntají nduhū vāji nī. ");
INSERT INTO mieNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","De nanducú ndá nú nduhū, sochi mā nánihīn nū nduhū. Chi mā cūú cuēē nū nūū cundeē ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ñúcuán de ndá táhán yā hebreo nī jīcā tūhún táhán dē: ¿De ní cúu nūū quíhīn tēe yáhá jā mā nánihīn ō dē? ¿A quīhīn dē nūū ndá táhán ó hebreo jā ní jītē nuu jā ndéē nación Grecia? ¿De á stéhēn dē tūhun nūū nchivī Grecia, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿De nā tūhun cúu jā ní ncāhān dē jā nanducú ó dē de mā nánihīn ō dē, jā má cūú cōhōn nūū cundeē dē? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","De quīvī sándīhí vico ñúcuán de íyó vico cáhnú cā. De quīvī ñúcuán nī nacuiñī Jesús, de nī ncāhān jee yā: Tú nā-ni nchivī cúu ndasí inī ji ndācá jā váha jā sāhá nī jēhē ji, jondē tá cúu nūū yíchī ndasí ji ndute, túsaá de ná quívi ji ndahá nī de coho ji ndute, cúu jā nīhīn ji ndācá jā váha ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","De nchivī jā candíja jā scácu nī ji, chi inī ánō ji cundeē Espíritu Santo, de cuu yā tá cúu iin yūte jā quéne de níí cání jíca ndute. De suu cúu jā sāhá yā jā cutecū ji níí cání, tá cúu nūū cáhān tutū īī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","De súcuán nī ncāhān yā jā nchivī candíja jā scácu yā ji, nīhīn ji Espíritu Santo. Chi ncháha ca quenda maá Espíritu, chi ncháha ca ndaa Jesús quīnohōn yā nūū nduñáhnú yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","De sava ndá nchivī cuāhā, tá nī jini ji tūhun yáhá, de nī ncāhān ji: Jāndáā jā tēe yáhá cúu jā cáchī tutū jā quiji dē nacani dē tūhun Yāā Dios, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","De sava cā ji nī ncāhān: Tēe yáhá cúu Cristo, Yāā nī ntají Yāā Dios. Sochi sava cā ji nī ncāhān ji: Nduú chi nsūú Galilea quiji Cristo. ");
INSERT INTO mieNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Chi cáchī tutū īī jā chījin tatā rey David cacu Cristo, de cacu yā ñuū Belén, ñuū nūū ní ncacu maá David, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","De súcuán nī ncusíín inī ndá nchivī jā síquī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","De sava ji cúnī ji tiin ji yā jā chindasī ji yā, de ni iin ji nduú ní ntíin ji yā. ");
INSERT INTO mieNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ñúcuán de ndá policía jā jíto templo, nduú ní ntíin ndá dē Jesús, de cuānohōn ndá dē nūū ndá tēe fariseo jíín ndá sūtū cúñáhnú. De ndá tēe ñúcuán nī jīcā tūhún dē policía: ¿Nūcu nduú ní nquíji ndá nú jíín dē? ");
INSERT INTO mieNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","De nī ncāhān ndá policía: Nduú cuitī ni iin tēe cáhān vāha ndasí tá cúu nūū cáhān tēe ñúcuán, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","De nī ncāhān ndá tēe fariseo: ¿De á suni jondē ndá máá nú nī stáhví dē, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ni iin táhán nī ndá sūtū cúñáhnú jíín tēe fariseo, nduú cándíja ndá nī tūhun cáhān tēe ñúcuán, ¿de nūcu cándíja ndá máá nú? ");
INSERT INTO mieNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","De ndá nchivī cuāhā ñúcuán jāá nduú jícūhun inī ji ley Moisés, chi tānū tāhvī ji, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","De nī ncāhān Nicodemo, tēe jā ní jēhēn nūū yā iin jacuáā, de suni iin tēe fariseo cúu dē: ");
INSERT INTO mieNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Cáchī ley jā má cūú tee ó cuāchi sīquī iin tēe, de tú mā cúnini ó xihna cā nāsa cáhān dē, tácua cucáhnú inī ō nā cuāchi nī nsāhá dē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","De nī ncāhān ndá dē: De ndóhó, ¿á suni jondē Galilea vāji nú jā cáhān nū jēhē tēe ñúcuán? Nanducú viī nū nūū tutū īī de cunī nū jā Galilea nduú quée cuitī ni iin tēe nácani tūhun Yāā Dios, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","De cuānohōn ndá dē tá vehe tá vehe dē. ");
INSERT INTO mieNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","De nī ncaa Jesús cuāhān yā yucu Olivos. ");
INSERT INTO mieNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","De jā cuácunijīn incā quīvī, de nī nquenda tucu yā templo. De ndihi nchivī nī nquenda ji nūū yā. De nī jēcundeē yā, de nī stéhēn yā tūhun nūū ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ñúcuán de ndá tēe stéhēn ley janahán jíín ndá tēe grupo fariseo, nī nquiji ndá dē jíín iin ñahan jā ní nīhīn dē ña jā cásíquí ndéē ña. De nī jani dē ña māhñú. ");
INSERT INTO mieNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","De nī ncāhān dē jíín yā: Maestro, nī nīhīn ndá sá ñahan yáhá jā cásíquí ndéē ña. ");
INSERT INTO mieNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","De ley Moisés ndácu nūū ō jā cuāha ó yūū xīnī ndá ñahan sáhá súcuán tácua cuū ña. De maá ní, ¿nāsa cáchī ní? ");
INSERT INTO mieNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","De súcuán nī ncāhān ndá dē jā jíto túnī dē yā tú cuetáhví yā jā cáhān ley ñúcuán, chi tú nduú de cāhān dē cuāchi sīquī yā. De Jesús nī jīquindeyi yā, de nī ntee yā nūū ñūhún jíín xīnī ndāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","De jā cáhān cáhān ndá dē, de nī nūcuīñī yā, de nī ncāhān yā jíín dē: Tú ní iin ndá máá nú nduú nā cuāchi nú, de xihna cā ndóhó cuāha yūū xīnī ña túsaá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","De nī jīquindeyi tucu yā, de nī ntee tucu yā nūū ñūhún. ");
INSERT INTO mieNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","De tá nī jini ndá dē jā súcuán nī ncāhān yā, de nī jīcūhun inī dē jā suni íyó cuāchi dē. De tá iin tá iin dē nī nquee dē cuāhān dē, de xihna cā tēe ñáhnú cā nī nquee, de jondē nī ndihi. De nī nquendōo maá-ni cā Jesús jíín ñahan jā íñí ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","De nī nūcuīñī tucu yā, de nduú cā ni iin tēe ñúcuán ní jínī yā, chi maá-ni cā ñahan íñí. De nī ncāhān yā jíín ña: ¿Ní cuāhān ndá tēe jā ní ncāhān cuāchi sīquī nū? ¿A nduú cā ní nénda ni iin dē jā cāhān dē cuāchi sīquī nū? ");
INSERT INTO mieNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","De nī ncāhān ña: Nduú ni iin dē, Señor. Ñúcuán de nī ncāhān Jesús jíín ña: Ni nduhū, mā cáhān ni cuāchi sīquī nū. De cuáhán de mā sāhá cā nū cuāchi, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","De incā vuelta nī ncāhān Jesús jíín nchivī: Maá nī cúu tá cúu luz jā stúu inī ánō nchivī ñayīví, jā sáhá nī jā jícūhun inī ji sīquī Yāā Dios. De nchivī jā candíja nduhū, mā cācá cā ji modo nūū neē, chi sa cunevāha ji luz inī ánō ji jā sāhá jā cutecū ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ñúcuán de nī ncāhān ndá tēe fariseo jíín yā: Ndóhó chi cáhān nū jēhē maá nú, de nduú jétíñú tūhun cáhān nū. ");
INSERT INTO mieNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","De nī ncāhān yā jíín ndá dē: Vísō cáhān ni jēhē maá nī, de íyó ndāā tūhun cáhān ni. Chi jínī ni ní jondē vāji nī ní jondē quīhīn ni. Sochi ndá ndóhó nduú jínī nū ní jondē vāji nī ní jondē quīhīn ni. ");
INSERT INTO mieNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ndá ndóhó chi modo nchivī ñayīví sándaā nū sīquī tūhun cáhān ni. De nduhū chi nduú sándaā mátúhún nī-ni sīquī ni iin nchivī. ");
INSERT INTO mieNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","De tú sāhá ndāā ni sīquī ji, de ndāā sándaā ni, chi nduú sáhá mátúhún nī-ni, chi sándaā ni jondē jíín maá Tatá nī, Yāā nī ntají nduhū vāji nī. ");
INSERT INTO mieNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","De yósō nūū tutū ley jā névāha ndá nú jā tú inuú cáhān ūū testigo, de cánuú cuetáhví nú jā cáhān dē, chi íyó ndāā tūhun cáhān dē. ");
INSERT INTO mieNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Túsaá de nduhū cúu iin jā cáhān ndāā ni jēhē ni. De incā jā cáhān ndāā jēhē ni cúu maá Tatá nī, Yāā nī ntají nduhū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","De nī ncāhān ndá dē jíín yā: ¿Ní cúu nūū ndéē Tatá nú túsaá? De nī ncāhān yā: Nduú jínī ndá nú ní iin cúu nduhū ni Tatá nī. De tú jā jínī nū nduhū, de suni cunī nū Tatá nī nícu. ");
INSERT INTO mieNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ndá tūhun yáhá nī ncāhān Jesús jā stéhēn yā inī templo nūū íyó ndá jātūn nūū sócō nchivī xūhún. De nduú ní ntíin ni iin dē yā, chi ncháha ca quenda quīvī jā tiin dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","De nī ncāhān tucu Jesús jíín ndá dē: Nduhū chi quīhīn ni, de nanducú ndá nú nduhū, de mā nánihīn nū nduhū, chi quendōo cuāchi nú sīquī nū tá cuū nū. De jā ñúcuán mā cūú cuēē nū nūū quíhīn ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ñúcuán de ndá tēe hebreo nī ncāhān dē jíín táhán dē: ¿A cahnī tēe yáhá maá dē, de á suu ñúcuán cúu jā cáhān dē jā má cūú cōhōn nūū quíhīn dē, á naá cúu? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","De nī ncāhān yā: Ndá máá nú chi ñayīví yáhá vāji nú, sochi nduhū chi jondē andiví vāji nī. Ndá máá nú cúu nchivī ñayīví yáhá, de nduhū chi nsūú tēe ñayīví yáhá cúu nī. ");
INSERT INTO mieNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jā ñúcuán cúu jā ní ncāhān ni jā quendōo cuāchi nú sīquī nū tá cuū nū. Chi tú mā cándíja nú jā maá nī cúu Cristo, de quendōo ndija cuāchi nú sīquī nū tá cuū nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","De nī jīcā tūhún ndá dē yā: ¿Túsaá de ní iin cúu nú? De nī ncāhān yā: Ja nī ncachī ni nūū nū jondē jā xíhna ñúhún ní iin cúu nī. ");
INSERT INTO mieNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","De íyó cuāhā cā tūhun jā cuu cāhān ni jíín nú de sāhá ndāā ni sīquī nū. Sochi mā cáhān ni, chi inī ñayīví yáhá cáhān ni maá-ni tūhun jā ní jini nī nī ncāhān Yāā nī ntají nduhū vāji nī. De maá-ni tūhun ndāā cáhān yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","De nduú ní jícūhun inī ndá dē jā cáhān yā tūhun Tatá yā andiví. ");
INSERT INTO mieNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jā ñúcuán nī ncāhān cā yā: Tá nī nchāha jā ní jata caa ndá nú nduhū, Yāā nī nduu tēe, yīcā cruz, ñúcuán de cunī nū ní iin cúu nī. De cunī nū jāá nduú nā cuá sáhá nī jā cúnī maá nī, chi cáhān ni maá-ni tūhun jā ní stéhēn Tatá nī nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Chi maá Tatá nī, Yāā nī ntají nduhū, íyó yā jíín nī. De nduú sndóo mátúhún yā nduhū, chi níní sáhá nī tiñu jā jétahān inī maá yā, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","De jā ní ncāhān yā tūhun yáhá, de cuāhā nchivī nī ncandíja ji yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ñúcuán de nī ncāhān Jesús jíín ndá táhán yā hebreo jā ní ncandíja ji yā: De tú cuiñi nīhin nú jíín tūhun stéhēn ni nūū nū, de cuu ndija nú nchivī scuáha jíín nī. ");
INSERT INTO mieNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","De jīcūhun inī nū tūhun ndāā, de tūhun ndāā sāhá jā nduu libre nū nūū maá jā yíhí nú ndahá. ");
INSERT INTO mieNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","De nī ncāhān ndá ji jíín yā: Nduú yíhí cuitī ni ndahá ni iin, chi tatā Abraham cúu ndá nī. ¿De nūcu cáhān nū jā nduu libre ni túsaá? ");
INSERT INTO mieNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","De nī ncāhān Jesús: Jāndáā cáhān ni jíín ndá nú jā ndācá nchivī jā sáhá cuāchi, nduú íyó libre ji, chi yíhí ji chījin cuāchi jā sátíñú cāhá ji nūū. ");
INSERT INTO mieNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","De nchivī jā sátíñú cāhá, chi nduú cúu ji iin táhán nchivī vehe nūū sátíñú ji. Sochi iin sēhe chi sa cúu ndija ji táhán nchivī vehe ji. ");
INSERT INTO mieNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Túsaá de maá nī jā cúu Sēhe Yāā Dios, tú sāhá nī jā má sátíñú cāhá nú cā nūū cuāchi, túsaá de nduu libre ndija ndá nú, de cuu nú sēhe yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","De jínī ni jā tatā Abraham cúu ndá nú, de vísō súcuán de cúnī ndá nú cahnī nū nduhū, chi nduú jétáhví nú tūhun cáhān ni. ");
INSERT INTO mieNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nduhū chi cáhān ni tūhun jā ní stéhēn Tatá nī nūū ni. De ndá ndóhó chi sáhá nú tiñu jā ní ncāhān tatá ndá máá nú, tāchī cúñáhnú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","De nī ncāhān ndá ji: Tatā Abraham cúu ndá nī. De nī ncāhān Jesús: Tú jā candíja ndá nú tá cúu nūū ní ncandíja Abraham, tácua cuu ndija nú tatā dē, ñúcuán de tiñu váha jā ní nsāhá dē suni sāhá ndá máá nú nícu. ");
INSERT INTO mieNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","De mitan chi cúnī ndá nú cahnī nū nduhū, vísō nī ncāhān ni jíín nú ndācá tūhun ndāā jā ní stéhēn Tatá nī nūū ni. De Abraham chi nduú ní nsáhá cuitī dē tá sáhá ndá máá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Chi inuú-ni sáhá ndá nú tá sáhá maá tatá nú, ncachī yā. Ñúcuán de nī ncāhān ndá ji: Ndá máá nī chi nduú cúu nī sēhe ndáhví jāá nduú tatá. Chi íyó iin-ni tatá nī, de Yāā Dios cúu yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ñúcuán de nī ncāhān Jesús: Tú Yāā Dios cúu ndija tatá nú, de coo manī nū jíín nī nícu. Chi jondē nūū Yāā Dios nī nquee nī vāji nī. De nduú vāji nī jā cúnī maá nī, chi maá yā nī ntají nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿De nājēhē cúu jāá nduú jícūhun inī ndá nú tūhun cáhān ni túsaá? Suu sīquī jāá nduú cúnī nū chuhun inī nū tūhun cáhān ni. ");
INSERT INTO mieNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ndá máá nú chi tatá nú cúu tāchī cúñáhnú. De cúnī ndá nú sāhá nú tiñu jā cúnī tatá nú ñúcuán. Maá tāchī cúñáhnú nī jahnī ndīyi jondē jā xíhna ñúhún. De nduú cuitī nā tūhun ndāā íñí jíín, de nduú cuitī nā tūhun ndāā cáhān. De cáhān tāchī cúñáhnú tūhun stáhví sīquī jā súcuán cáá maá. Chi maá tāchī cúu jā ndíso tūhun stáhví, de nī squíjéhé ndihi tūhun stáhví. ");
INSERT INTO mieNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Sochi nduhū chi cáhān ni tūhun ndāā, de jā ñúcuán cúu jāá nduú cándíja ndá nú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","De ni iin nú mā níhīn nū cuāchi sīquī ni, chi nduú cuitī nā cuāchi nī. De maá-ni tūhun ndāā cáhān ni, ¿de nūcu nduú cándíja ndá nú nduhū? ");
INSERT INTO mieNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ndá nchivī jā cúu sēhe Yāā Dios, chi chúhun inī ji tūhun Yāā Dios. De ndá ndóhó chi nduú cúu nú sēhe Yāā Dios, de jā ñúcuán nduú cúnī nū chuhun inī nū, ncachī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ñúcuán de nī ncāhān ndá táhán yā hebreo: Ndāā cáhān ndá nī jā cáneē nū tá cúu nchivī Samaria, de ndóho nú tāchī. ");
INSERT INTO mieNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","De nī ncāhān Jesús: Nduú ndóho nī tāchī, chi íyó yíñúhún nī nūū Tatá nī. De ndá ndóhó chi nduú íyó yíñúhún nú nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nduhū chi nduú ndúcú nī jā cuñáhnú nī. Iyó iin jā sáhá jā cúñáhnú nī, de maá yā sándaā sīquī tūhun cáhān ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jāndáā cáhān ni jíín nú, tú ní nchivī squíncuu tūhun cáhān ni, de mā cúū cuitī ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","De ndá tēe hebreo nduú ní jícūhun inī dē, de nī ncāhān dē: Mitan de nī ncucáhnú inī ndá nī jā ndóho ndija nú tāchī. Chi Abraham jíín ndá tēe nī nacani tūhun Yāā Dios jondē janahán, nī jīhī ndá dē. De ndóhó chi cáhān nū, tú ní iin squíncuu tūhun cáhān nū, de mā cúū cuitī ji, cáchī nū. ");
INSERT INTO mieNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿De á cúñáhnú cā maá nú nsūú cā tatā ō Abraham, á naá cúu? Chi nī jīhī dē, de suni nī jīhī ndá tēe nī nacani tūhun yā. ¿De ní iin cā sáhá nú maá nú túsaá? ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","De nī ncāhān Jesús: Tú nduhū sáñáhnú nī maá nī, de nduú níhīn tīñú. Maá Tatá nī cúu jā sáñáhnú nduhū. De cáhān ndá nú jā maá yā cúu Yāā Dios maá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","De vísō súcuán de nduú jínī nū nāsa Yāā cúu yā. De nduhū chi jínī ni yā. De tú cāhān ni jāá nduú jínī ni yā, de cuu nī tēe stáhví tá cúu ndá máá nú. De nduú chi jínī ndija nī yā, de squíncuu nī tūhun cáhān yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","De tatā ō Abraham nī ncusiī inī dē jā cunī dē quīvī quenda nī. De ja nī jinī dē, de nī jinī ni jā ní ncusiī ndasí inī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ñúcuán de nī ncāhān ndá tēe hebreo jíín yā: Va ncháha ca coo nú ūū xico ūxī cuīyā, ¿de nāsa cúu jā cáhān nū jā ní jinī nū nūū Abraham? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","De nī ncāhān Jesús: Jāndáā cáhān ni jíín ndá nú jā jondē ncháha ca cacu Abraham de ja íyó nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ñúcuán de nī nquehen ndá dē yūū jā cuāha dē yā. Sochi nī nquee yuhū yā-ni, nī nchāha yā māhñú ndá dē, de nī nquee yā inī templo cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","De jā jíca Jesús cuāhān yā, de nī jinī yā nūū iin tēe nī ncacu cuáá. ");
INSERT INTO mieNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","De ndá tēe scuáha jíín yā nī jīcā tūhún dē yā: Maestro, ¿nūcu nī ncacu cuáá tēe yáhá? ¿A cuāchi tatá dē naná dē cúu, á cuāchi maá dē cúu? ");
INSERT INTO mieNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","De nī ncāhān Jesús: Nsūú cuāchi maá dē, ni nsūú cuāchi tatá dē naná dē cúu jā ní ncacu dē súcuán, chi sa nī ncacu dē súcuán tácua cunī nchivī tiñu ñáhnú jā sāhá Yāā Dios jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Juni cúu inī ñayīví tá nūū cúu nduú, de cánuú sāhá nī tiñu Yāā jā ní ntají nduhū. Chi quiji tiempo jā cuu tá nūū cúu jacuáā, jāá nduú cā nā tiñu cuu sāhá ni iin. ");
INSERT INTO mieNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Juni ndéē ni inī ñayīví, de cúu nī luz jā cútūu inī ánō nchivī ñayīví, tácua jīcūhun inī ji sīquī Yāā Dios, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","De tá nī ncuu nī ncāhān yā súcuán, de nī jati yā ntesíi yā nūū ñūhún, de nī nsāhá yā ndēhyū jíín ntesíi yā, de nī ntee yā sīquī tínūú tēe cuáá. ");
INSERT INTO mieNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","De nī ncāhān yā jíín dē: Cuáhán nūū pila Siloé de naquete nú tīnūú nú, ncachī yā. De tūhun Siloé cáhān: Ndute jā ní scáca ndá dē nī nquenda. Ñúcuán de cuāhān dē, de nī naquete dē tīnūú dē, de nī ndunijīn-ni, de cuānohōn dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ñúcuán de ndá nchivī ndéē ñatin jíín dē, jíín ndá nchivī jā ní jinī jā ní ncuu dē tēe cuáá, nī jīcā tūhún táhán ji: ¿A nsūú tēe yáhá cúu jā jícān caridad jā ndéē yáhá? ");
INSERT INTO mieNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","De sava ji nī ncāhān: Suu dē cúu. De sava cā ji nī ncāhān: Nsūú dē cúu, sochi súcuán cáá dē. De maá dē chi nī ncāhān dē: Suu nī cúu. ");
INSERT INTO mieNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ñúcuán de nī jīcā tūhún ndá ji: ¿De nāsa cúu jā ní nune tīnūú nú túsaá? ");
INSERT INTO mieNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","De nī ncāhān dē: Tēe nání Jesús nī nsāhá dē ndēhyū, de nī ntee dē tīnūú nī, de nī ncāhān dē jíín nī: Cuáhán nūū pila Siloé de naquete nú tīnūú nú. De nī jēhēn ni, de nī naquete nī, de nī nune-ni tīnūú nī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ñúcuán de nī jīcā tūhún ji dē: ¿Ní cúu nūū íyó tēe ñúcuán? ncachī ji. Nduú jínī ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ñúcuán de nī jēsiáha ndá ji tēe nī ncacu cuáá nūū ndá tēe fariseo. ");
INSERT INTO mieNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","De quīvī nátātú cúu jā ní nsāhá Jesús ndēhyū jā ní nacune yā tīnūú dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","De ndá tēe fariseo nī jīcā tūhún tucu dē nāsa nī nune tīnūú dē. De nī ncāhān dē: Nī ntee dē ndēhyū sīquī tínūú sá, de nī naquete sá, de nī ndunijīn-ni tīnūú sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ñúcuán de nī ncāhān sava tēe fariseo: Tēe ñúcuán chi nsūú jondē nūū Yāā Dios vāji dē, chi nduú née iī dē quīvī nátātú. Sochi sava cā dē nī ncāhān: ¿Nāsa cuu sāhá tēe ñúcuán ndá tiñu ñáhnú de tú tēe íyó cuāchi cúu dē? De nī ncusíín inī ndá dē sīquī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","De nī jīcā tūhún tucu ndá dē tēe nī ncacu cuáá: Ndóhó, ¿nāsa cáhān nū sīquī tēe jā ní nacune tīnūú nú túsaá? De maá dē nī ncāhān dē: Iin tēe nácani tūhun Yāā Dios cúu dē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sochi ndá tēe hebreo ñúcuán nduú ní ncándíja dē jā ní īyo cuáá tēe ñúcuán de nī ndunijīn tīnūú dē. De nī ncana ndá dē tatá naná tēe cuáá. ");
INSERT INTO mieNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","De nī jīcā tūhún ndá dē: ¿A yáhá cúu sēhe nú jā ní ncacu cuáá cáchī nū? ¿Túsaá de nāsa nī ndunijīn tīnūú dē mitan? ");
INSERT INTO mieNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","De nī ncāhān tatá dē jíín naná dē: Suu sēhe nī cúu tēe yáhá jā ní ncacu cuáá. ");
INSERT INTO mieNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Sochi nduú jínī ni nāsa nī ndunijīn tīnūú dē mitan, de ni nduú jínī ni ní tēe nī nacune tīnūú dē. Cātūhún ndá nú maá dē, chi ja ñáhnú dē, de ná cáchī maá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Súcuán nī ncāhān tatá dē jíín naná dē, chi yúhú dē ndéhé dē ndá táhán dē tēe hebreo. Chi ja nī nsāhá ndāā ndá tēe ñúcuán jā tú ní iin nchivī cachī ji jā Jesús cúu Cristo, Yāā nī ntají Yāā Dios, de tavā dē ji jā má cūú cā quīvi ji inī vehe īī sinagoga. ");
INSERT INTO mieNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jā ñúcuán nī ncāhān tatá dē jíín naná dē: Cātūhún ndá nú maá dē, chi ja ñáhnú dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ñúcuán de ndá tēe hebreo nī ncana tucu dē tēe nī īyo cuáá. De nī ncāhān dē jíín: Cachī cājí nú nūū ni jā cunī jínúū Yāā Dios. Chi jínī ndá nī jā tēe íyó cuāchi cúu tēe nī nacune tīnūú nú. ");
INSERT INTO mieNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ñúcuán de nī ncāhān dē: Nduú jínī sá tú íyó cuāchi dē, á naá cúu. De íyó iin jā jínī sá, cúu jā tēe cuáá nī ncuu sá, de mitan chi nī ndunijīn tīnūú sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","De nī jīcā tūhún tucu ndá dē: ¿Nāsa nī nsāhá dē jíín nú? ¿Nāsa nī nacune dē tīnūú nú túsaá? ");
INSERT INTO mieNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","De nī ncāhān dē: Ja nī ncachī tūhun sá nūū ndá ní, de nduú cúnī ní cuetáhví ní. ¿De nūcu cúnī ndá ní jā cachī tucu sá nūū ní? ¿De á suni cúnī ndá ní candíja ní dē, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ñúcuán de nī ncāhān nēhén ndá jíín dē, sá de nī ncāhān cā: Maá nú chi cándíja nú tēe ñúcuán, sochi ndá máá nī chi cándíja nī Moisés. ");
INSERT INTO mieNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","De jínī ndá nī jā ní ncāhān Yāā Dios jíín Moisés. Sochi tēe ñúcuán, ni nduú jínī ni ní jondē vāji dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","De nī ncāhān tēe nī īyo cuáá: Sáhvi inī sá jā cáhān ndá ní jāá nduú jínī ní jā váji dē nūū Yāā Dios, vísō nī nacune dē tīnūú sá. ");
INSERT INTO mieNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","De jínī ō jā Yāā Dios nduú níni yā jā jícān táhvī nchivī íyó cuāchi. Chi níni yā jā cáhān ndá máá-ni nchivī jā chíñúhún nūū yā de sáhá ji jā cúnī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","De níí tiempo vāji ó, de nduú ní jínī cuitī ō jā nácune iin tēe tīnūú incā tēe nī ncacu cuáá. ");
INSERT INTO mieNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","De tú nsūú jondē nūū Yāā Dios vāji tēe ñúcuán, de mā cūú cuitī sāhá dē iin tiñu súcuán, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","De nī ncāhān ndá tēe hebreo: Ndóhó chi íyó ndasí cuāchi nú jondē quīvī nī ncacu nú, ¿de á maá nú stéhēn nūū ni, á naá cúu? ncachī dē. De nī ntavā ndá dē tēe ñúcuán yātā vehe īī sinagoga. ");
INSERT INTO mieNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","De nī nīhīn Jesús tūhun jā ní ntavā ndá dē tēe ñúcuán. De nī naquetáhán yā jíín dē, de nī ncāhān yā: ¿A cándíja nú Sēhe Yāā Dios? ");
INSERT INTO mieNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","De nī ncāhān dē: Señor, ¿ní iin cúu yā tácua candíja sá yā? ");
INSERT INTO mieNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","De nī ncāhān Jesús: Ja nī jinī nū nūū yā, de suu cúu nduhū jā cáhān ni jíín nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ñúcuán de nī jēcuīñī jītí dē nūū yā, de nī ncāhān dē: Cándíja sá jā maá ní cúu Jētohō sá. ");
INSERT INTO mieNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","De nī ncāhān Jesús: Vāji nī inī ñayīví yáhá jā sāhá ndāā ni sīquī nchivī. Chi nchivī íyó cuáá ánō, ndunijīn inī ánō ji jā jīcūhun inī ji sīquī ni. De nchivī jā jáni inī ji jā jícūhun inī ji, sochi nduú, chi sa nducuáá ánō ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","De sava tēe fariseo jā íñí jíín yā, tá nī jini dē tūhun yáhá, de nī ncāhān ndá dē: ¿De á jáni inī nū jā suni tēe nduú jícūhun inī cúu ndá máá nī túsaá? ");
INSERT INTO mieNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","De nī ncāhān Jesús: Tú jā cúu ndá nú tēe nduú jícūhun inī, de mā cōó cuāchi nú. De sīquī jā ní ncāhān ndá nú jā jícūhun inī nū, sochi nduú jétáhví nú, jā ñúcuán cúu jā cundeē cuāchi nú sīquī nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","De nī ncāhān cā yā: Jāndáā cáhān ni jíín ndá nú, tá yíhí ndá tīcāchí inī corral jā névāha cáhnú nchivī, de tú iin tēe nduú quívi dē ichi viéhé corral, chi sa incā lado corral cáa dē quívi dē, tēe ñúcuán cúu jācuīhná, chi vāji jā sacuíhná. ");
INSERT INTO mieNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sochi tēe quívi ichi viéhé, tēe ñúcuán cúu pastor jā jíto tīcāchí. ");
INSERT INTO mieNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","De tēe jíto viéhé, nácune dē jā quīvi tēe ñúcuán. De tīcāchí dē nácunī tī tāchī dē. De cána dē síví tīcāchí maá dē, de távā dē tī. ");
INSERT INTO mieNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","De tá nī ntavā dē ndihi tīcāchí maá dē, de yósō nūú dē nūū tī cuāhān dē. De ndá tīcāchí chi níquīn tī dē, chi nácunī tī tāchī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","De mā cúniquīn tī yātā incā tēe, chi sa cunu tī cunī tī dē, chi nácunī tī jāá nsūú jētohō tī cúu. ");
INSERT INTO mieNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tūhun yátá yáhá nī ncāhān Jesús jíín nchivī, de nduú ní jícūhun inī ji nā tūhun cúu jā ní ncāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ñúcuán de nī ncāhān cā Jesús jíín nchivī: Jāndáā cáhān ni jíín ndá nú: Maá nī cúu tá cúu viéhé corral nūū quívi ndá nchivī jā cúu tá cúu tīcāchí nī. ");
INSERT INTO mieNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ndācá tēe jāá nduú ní ntájí Yāā Dios, jā ní nquiji ndá dē jondē ncháha ca quenda nī, cúu ndá dē tá cúu jācuīhná, chi nduú ní stéhēn dē tūhun ndāā. De nchivī jā cúu tá cúu tīcāchí nī, nduú ní jétáhví ji ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Maá nī cúu tá cúu viéhé. De nchivī jā jíín maá nī quívi ji, scácu nī ji. De cúu ji tá cúu tīcāchí jā ndívi ndá tī nūū yíhí vāha tī, de quée tucu tī nūū cajī vāha tī. ");
INSERT INTO mieNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tēe cuíhná chi maá-ni jā váji dē jā sacuíhná dē tīcāchí, de cahnī dē, de snáā dē tī. De nduhū chi vāji nī tácua cutecū nchivī cúu tá cúu tīcāchí nī, de jondē ndetū ndasí coo ji níí cání. ");
INSERT INTO mieNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Maá nī cúu maá pastor vāha. De pastor vāha chi jíto vāha dē tīcāchí dē, vísō jondē cuū dē jā jéhē tī. ");
INSERT INTO mieNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sochi iin tēe jā quéhen yāhvi, nsūú pastor tī cúu dē, chi nsūú tīcāchí maá dē cúu tī. De tú jínī dē jā váji yīhī, de sndóo dē tīcāchí, de jínu dē cuāhān dē. De yīhī chi tíin tī tīcāchí, de sáhá tī jā jítē nuu tīcāchí. ");
INSERT INTO mieNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","De tēe quéhen yāhvi chi jínu dē cuāhān dē sīquī jā tīcāchí tátū cúu jā jíto dē, de jā ñúcuán nduú cúndáhví inī dē tī. ");
INSERT INTO mieNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Maá nī cúu maá pastor vāha. De jínī ni ndācá nchivī jā cúu tá cúu tīcāchí nī, de ndá máá ji jínī ji nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","De yáhá cúu tá cúu jā Tatá nī jínī yā nduhū, de maá nī jínī ni Tatá nī. De cuū ni jā síquī nchivī cúu tīcāchí nī. ");
INSERT INTO mieNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","De suni íyó cā nchivī cúu tīcāchí nī, de síín síín nchivī cúu ndá ji. De cánuú jā suni quīcuēca nī ndá nchivī ñúcuán. De cuetáhví ji tūhun jā cáhān ni. De cundeē cāhnú-ni ndihi nchivī cándíja, de coo iin-ni pastor ji. ");
INSERT INTO mieNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","De Tatá nī mānī ndasí yā jíín nī sīquī jā jéhe nī maá nī jā cuū ni jā jéhē nchivī, de natecū tucu nī. ");
INSERT INTO mieNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni iin mā cūú cahnī nduhū, chi maá nī cúu jā jéhe tūhun jā cuū ni. Jā cáchī maá nī de cuū ni, de jā cáchī maá nī de natecū ni, chi súcuán íyó poder ni. Súcuán nī ncāhān Tatá nī jā sāhá nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","De jā ní jini ndá táhán yā hebreo tūhun yáhá, de nī ncusíín tucu inī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","De cuāhā ji nī ncāhān: ¿Nūcu níni ndá nú tūhun jā cáhān dē? Chi ndóho dē tāchī, de nī ntīví xīnī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sochi sava gā ji nī ncāhān: Nsūú súcuán cáhān tēe ndóho tāchī, tá cúu nūū cáhān tēe yáhá. De iin tēe ndóho tāchī, ¿á cuu nacune dē tīnūú tēe cuáá? ncachī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","De tiempo vījin cúu, de ciudad Jerusalén násāhá ndá nchivī vico jā núcūhun inī ji quīvī jā ní ncuhiī templo cāhnú. ");
INSERT INTO mieNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","De jíca nuu Jesús inī templo, inī corredor jā nání Salomón. ");
INSERT INTO mieNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","De ndá táhán yā hebreo nī ncutútú ji nūū yā, de nī ncāhān ji: ¿Nāsaa cā quīvī sāhá nú jā má cúcáhnú inī ndá nī? Chi tú maá nú cúu Cristo, de cachī cājí nú nūū ndá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","De nī ncāhān Jesús: Ja nī ncachī tūhun nī nūū ndá nú, de nduú ní ncándíja nú. Ndācá tiñu jā ní ntetíñú Tatá nī nduhū jā sāhá nī, ñúcuán cúu jā stéhēn cājí jā maá yā nī ntají nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","De nduú cándíja ndá nú, chi nsūú tīcāchí nī cúu nú, tá cúu nūū ní ncāhān ni jíín nú. ");
INSERT INTO mieNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ndá nchivī jā cúu tīcāchí nī, chi nácunī ji jā maá nī cúu jā cáhān jíín ji. De jínī ni ji, de níquīn ndá ji nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","De cutecū ji níí cání sāhá nī, de mā tánū tāhvī cuitī ji. De ni iin mā cūú nacandeē ji inī ndahá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Maá Tatá nī nī squívi yā ji ndahá nī. De cúñáhnú cā maá yā nsūú cā ndācá cā. De ni iin mā cūú nacandeē ji inī ndahá yā. ");
INSERT INTO mieNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Maá nī jíín Tatá nī, chi iin-ni cúu nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ñúcuán de ndá táhán yā hebreo nī nquehen tucu dē yūū jā cuāha dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","De nī ncāhān yā jíín dē: Nī stéhēn ni cuāhā tiñu váha nūū nū jā ní nsāhá nī jíín poder Tatá nī. ¿De á sīquī jā ní nsāhá nī ndá tiñu váha cúu jā cuāha nú yūū nduhū, á naá cúu? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","De nī ncāhān ndá dē: Nsūú sīquī jā ní nsāhá nú tiñu váha cúu jā cuāha nī yūū ndóhó, chi sīquī jā cáhān nū tūhun nāvāha jā quītī inī Yāā Dios, chi cáchī nū jā inuú cúu nú jíín Yāā Dios. Chi tēe-ni cúu nú, de sáhá nú jā inuú cúu nú jíín Yāā Dios, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","De nī ncāhān Jesús: Yósō nūū tutū ley jā névāha ndá nú jā ní ncāhān Yāā Dios: Tá cúu yāā cúu ndá nchivī cándíja, cáchī Yāā Dios, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","De jínī ō jā má cūú cāhān ō jāá nduú cáhān ndāā tutū īī. Chi nī ncāhān yā jā ndá nchivī jā ní ncandíja tūhun yā, cúu ji tá cúu yāā. De víhí cā cúu nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Túsaá de nūcu cáhān ndá nú jā tūhun nāvāha cúu jā ní ncāhān ni jā Sēhe Yāā Dios cúu nī? Chi maá Yāā Dios nī jani yā nduhū sīquī tiñu īī, de nī ntají yā nduhū vāji nī inī ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tú nduú sáhá nī tiñu sáhá Tatá nī, túsaá de mā cándíja ndá nú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Sochi tú sáhá nī, de vísō nduú cándíja nú nduhū, de candíja nú sīquī ndá tiñu sáhá nī. De súcuán de cucáhnú inī nū jā iin-ni cúu Tatá nī jíín nī, de iin-ni cúu nī jíín Tatá nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ñúcuán de ndúcú tucu ndá dē tiin dē yā. Sochi nī ndoñúhún yā-ni nūū ndá dē cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","De cuānohōn yā yūte Jordán ichi nūū quénda ncandiī, nūū ní īyo Juan nī scuénduté dē. De nī ndeē yā ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","De nī nquenda cuāhā nchivī nūū yā, de nī ncāhān ndá ji jíín táhán ji: Ndāā chi vísō nduú ní nsáhá Juan ni iin tiñu ñáhnú, de nī ncundaā ndihi tūhun jā ní ncāhān dē sīquī nāsa sáhá tēe yáhá, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","De cuāhā nchivī ñúcuán nī ncandíja ji yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","De nī īyo iin tēe cúhū, nání dē Lázaro. De maá dē jíín cuāha dē María jíín Marta, cúu ndá dē nchivī ñuū Betania. ");
INSERT INTO mieNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","De María jā cúu cuāha Lázaro, suu ña cúu jā ní nchihi aceite perfume jēhē Jētohō ō, de nī nasíchī ña jíín ixi xínī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","De ndúū cuāha dē ñúcuán nī ntetíñú ña tūhun cuāhān nūū Jesús: Señor, tēe jā mānī ní jíín, cúhū dē, cáchī ña, ncachī mozo. ");
INSERT INTO mieNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","De tá nī jini Jesús tūhun, de nī ncāhān yā: Cuēhē yáhá chi nsūú cuēhē jā cuū dē cúu. Chi sa sāhá Yāā Dios jā cunī nchivī nāsa cúñáhnú yā. Chi nduhū, Sēhe Yāā Dios, jíín cuēhē yáhá de stéhēn ni jā suni cúñáhnú maá nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","De mānī Jesús jíín Marta jíín cūhū ña jíín Lázaro. ");
INSERT INTO mieNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","De vísō súcuán de tá nī nīhīn yā tūhun jā cúhū dē, de nī nquendōo yā ūū cā quīvī nūū ndéē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ñúcuán de nī ncāhān yā jíín ndá tēe scuáha jíín yā: Ná cóhōn quīnohōn ō región Judea. ");
INSERT INTO mieNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","De nī ncāhān ndá tēe scuáha jíín yā: Maestro, cáta ñatin-ni quīvī cúu jā ndúcú ndá táhán ó hebreo cuāha dē yūū ní. ¿De á cúnī ní quīhīn tucu ní ñúcuán, á naá cúu? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","De nī ncāhān Jesús: Mā cūú cahnī nchivī nduhū de tú ncháha ca quenda maá quīvī cuū ni. Chi jā íyó nī ñayīví yáhá cúu tá cúu jā íyó ūxī ūū hora iin nduú. De jā sáhá nī jā cúnī Yāā Dios, de súcuán cúu nī tá cúu tēe jā jíca nduú, de nduú scáchihi dē jēhē dē, chi nijīn nūū dē ñayīví yáhá. ");
INSERT INTO mieNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sochi tēe jāá nduú sáhá jā cúnī Yāā Dios, chi modo jā jíca dē jacuáā, de modo jā scáchihi dē jēhē dē, chi nduú cútūu inī ánō dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ñúcuán de nī ncāhān tucu yā: Amigo ō Lázaro quíxīn dē, de quīhīn ni jā sndóto nī dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ñúcuán de ndá tēe scuáha nī ncāhān dē: Señor, tú quíxīn dē de jínī ō jā nduvāha dē. ");
INSERT INTO mieNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sochi Jesús chi súcuán nī ncāhān yā jā ní jīhī dē. De jáni inī ndá tēe scuáha jā quíxīn ndija dē. ");
INSERT INTO mieNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ñúcuán de nī ncāhān cājí yā: Ja nī jīhī Lázaro. ");
INSERT INTO mieNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","De cúsiī inī ni jāá nduú ní íyo nī ñúcuán, tácua vāha cā candíja ndá nú tá cunī nū tiñu ñáhnú jā sāhá nī. Túsaá de ná cóhōn nūū ndīyi ñúcuán, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ñúcuán de Tomás, tēe cúu cuátī, nī ncāhān dē jíín ndá táhán dē jā scuáha jíín yā: Suni ná cóhōn tácua cuū ō jíín yā, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","De tá nī nquenda Jesús, de jínī yā ja nī ncuu cūmī quīvī jā ní ncuyuhū Lázaro. ");
INSERT INTO mieNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","De ñatin-ni íyó ñuū Betania jíín ñuū Jerusalén, chi tá ūū kilómetro yósāvá. ");
INSERT INTO mieNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","De Marta jíín María, nī nquenda cuāhā táhán ña hebreo jā cáhān ji tūhun ndeé inī jíín ña jā ní jīhī cuāha ña. ");
INSERT INTO mieNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","De tá nī nīhīn Marta tūhun jā váji Jesús, de nī nquee ña cuātahān ña yā. De María chi nī ndōo ña vehe. ");
INSERT INTO mieNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","De nī ncāhān Marta jíín Jesús: Señor, tú ní íyo ní yáhá, de mā cúū cuāha sá nícu. ");
INSERT INTO mieNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","De vísō súcuán de jínī sá jā ndācá jā cācān ní nūū Yāā Dios, de sāhá yā, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","De nī ncāhān Jesús jíín ña: Natecū cuāha nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","De nī ncāhān Marta: Jínī sá jā natecū dē quīvī jā natecū ndācá ndīyi jondē quīvī jīnu ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","De nī ncāhān Jesús: Maá nī cúu Yāā jā sáhá jā natecū nchivī jíín jā cutecū ji níí cání. Nchivī cándíja jā scácu nī ji, vísō ná cúū ji, de natecū ji. ");
INSERT INTO mieNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","De nchivī jā técū de candíja ji nduhū, cutecū ji níí cání andiví. ¿A cándíja nú tūhun yáhá? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","De nī ncāhān ña: Señor, cándíja sá jā maá ní cúu Cristo Sēhe Yāā Dios, jā cáchī tutū jā quiji inī ñayīví, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","De tá nī ncāhān ña súcuán, de cuāhān ña-ni, cuācana yuhū ña cūhū ña María: Maá Maestro nī nquenda yā, de cána yā ndóhó, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","De jā ní jini María tūhun yáhá, de ñamā nī nacuiñī ña, de cuāhān ña nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","De ncháha ca quīvi Jesús ñuū, chi nī nquendōo yā nūū ní jētahān Marta yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","De nchivī hebreo jā ndéē inī vehe jíín María jā cáhān ji tūhun ndeé inī jíín ña, nī jinī ji jā ñamā nī nacuiñī ña cuāhān ña. De nī jēcuniquīn ndá ji ña, chi jáni inī ji jā cuáhān ña cuacu ña jondē nūū yíyuhū ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ñúcuán de nī nquenda María nūū íyó Jesús, de nī jēcuīñī jītí ña nūū jéhē yā, de nī ncāhān ña: Señor, tú ní ndéē ní yáhá, de mā cúū cuāha sá nícu, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","De nī jinī Jesús jā jácu ña jíín jā jácu ndá nchivī jā váji jíín ña. De nī ncucuécá ndasí inī yā, de nī ntahúhvī inī yā jā cúndáhví inī yā ji. ");
INSERT INTO mieNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","De nī jīcā tūhún yā ña: ¿Ní cúu nūū ní nchiyuhū ndá nú dē? De nī ncāhān ña jíín yā: Ná cóhōn de cunī ní, Señor, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","De nī jacu Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ñúcuán de nī ncāhān ndá nchivī hebreo jíín táhán ji: Cūndēhé nācā mānī ndasí nī īyo dē jíín ndīyi ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","De sava ji chi nī ncāhān ji: Tēe yáhá jā ní nacune dē tīnūú tēe cuáá, ¿á mā cūú sāhá dē jā má cúū Lázaro nícu? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","De nī ntahúhvī ndasí tucu inī Jesús, de nī nquenda yā nūū yíyuhū ndīyi. De iin yavī cava cúu, de yúyávī ñúcuán ndásī iin yūū. ");
INSERT INTO mieNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","De nī ncāhān yā: Sāhá jíyo ndá nú yūū jīñā, ncachī yā. De Marta, cuāha ndīyi ñúcuán, nī ncāhān ña: Señor, ja jéhēn xicō dē, chi ja nī ncuu cūmī quīvī yíyuhū dē. ");
INSERT INTO mieNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","De nī ncāhān Jesús jíín ña: ¿A nsūú ja nī ncāhān ni jíín nú jā tú candíja nú de cunī nū jā cúñáhnú ndasí Yāā Dios jíín poder yā? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ñúcuán de nī nsāhá jíyo ndá dē yūū jā ndásī yúyávī ndīyi. De nī nūcūndēhé-ni Jesús ichi andiví, de nī ncāhān yā: Tatá, ná cútahvī sá nūū ní jā sáhá ní jā jícān sá. ");
INSERT INTO mieNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","De jínī sá jā níní sáhá ní jā jícān sá. De jā quendōo vāha nchivī íñí yáhá cúu jā súcuán cáhān sá, tácua ná cándíja ji jā maá ní nī ntají sāán. ");
INSERT INTO mieNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","De tá nī ncāhān yā súcuán, de nī ncāhān jee yā: Lázaro, quee quiji nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","De nī nquee-ni tēe jā ní jīhī, de ñúsúcún ndahá dē sīhin dē jíín tira sahma. De nūū dē ñúsúcún iin sahma. De nī ncāhān Jesús jíín ndá nchivī: Nandají ndá nú sahma ñúsúcún dē, tácua cuu caca dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ñúcuán de cuāhā nchivī hebreo jā ní nquenda nūū María, nī ncandíja ji Jesús, chi nī jinī ji tiñu jā ní nsāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Sochi sava ji cuāhān ji nūū ndá tēe fariseo, de nī ncachī tūhun ji nāsa nī nsāhá Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ñúcuán de ndá tēe fariseo jíín ndá sūtū cúñáhnú nī ndutútú dē junta jíín ndá cā tēe cúñáhnú. De nī ncāhān ndá dē: ¿Nāsa sāhá ó? Chi tēe ñúcuán sáhá ndasí dē tiñu ñáhnú. ");
INSERT INTO mieNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","De tú cuāha ó tūhun jā sāhá cā dē súcuán, de ndiviī nchivī candíja ji dē. De quiji ndá tēe nación Roma jā cúñáhnú, de canī dē templo cāhnú ó, de scútē nuu dē nchivī nación ndācá ó, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","De iin táhán dē jā nání Caifás, jā cúu maá sūtū cúñáhnú cā cuīyā ñúcuán, nī ncāhān dē: Ndá ndóhó chi nduú jínī cuitī nū, ");
INSERT INTO mieNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ni nduú jícūhun inī nū jā vāha cā jā cuū iin tēe jā jéhē nchivī nación ndācá ó nsūú cā jā naā ndiviī ō, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","De nduú ní ncáhān dē tūhun yáhá jā jáni inī maá dē. Chi sīquī jā cúu dē sūtū cúñáhnú cā cuīyā ñúcuán, de nī nsāhá Yāā Dios jíín dē jā ní nacani dē tūhun jā cuū Jesús jā jéhē nchivī nación hebreo. ");
INSERT INTO mieNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","De nsūú maá-ni jā jéhē nación hebreo, chi suni jā jéhē ndiviī nchivī jā cúu sēhe Yāā Dios jā ní jītē nuu ndācá nación, tácua inuú-ni cuu ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","De jondē quīvī ñúcuán de ndācá tēe hebreo jā cúñáhnú, nī scáni táhán ndá dē tūhun jā cahnī dē Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","De jā ñúcuán nduú cā ní jíca nijīn yā nūū ndá táhán yā hebreo, chi nī nquee yā región Judea, de cuāhān yā iin ñuū nání Efraín, nūū íyó ñatin ñuhun tíhá. De ñúcuán nī ndeē yā jíín ndá tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","De nī ncuñatin vico pascua jā násāhá ndá nchivī hebreo. De cuāhā nchivī ndācá ñuū ñúcuán cuāhān ji Jerusalén, tácua squíncuu ji jā cáhān ley jā cuchi ji ndundoo ji nūū Yāā Dios, de sá de quijéhé vico pascua. ");
INSERT INTO mieNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","De nánducú ndá ji Jesús, de jícā tūhún táhán ji inī templo: ¿Nāsa jáni inī ndá nú? ¿A quiji dē vico, á nduú? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","De ndá sūtū cúñáhnú jíín ndá tēe fariseo nī ndacu dē tiñu jā tú ní iin nchivī jínī ji ní nūū íyó yā, de ná cáchī tūhun ji, tácua tiin ndá dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","De cúmanī īñū cā quīvī de coo vico pascua. De nī jēhēn tucu Jesús ñuū Betania nūū ndéē Lázaro, tēe jā ní jīhī de nī nastécū yā dē. ");
INSERT INTO mieNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","De nī nsāhá ndá ji iin vico jā cuxíní ji jíín yā jā íyó yíñúhún ji jíín yā. De Marta nī jani ña cōhō. De Lázaro yájī dē stāā jíín yā nūū mesa jíín ndá cā nchivī. ");
INSERT INTO mieNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ñúcuán de María nī nquenda ña jíín tá sava litro aceite perfume jā cúu ndinuhun itā nardo, jā yāhvi ndasí ndéē. De nī nchihi ña jēhē Jesús, de nī nasíchī ña jíín ixi ña. De níí inī vehe nī nchitú xicō perfume. ");
INSERT INTO mieNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ñúcuán de nī ncāhān Judas Iscariote sēhe Simón, iin tēe scuáha jíín yā, de suu dē cúu jā nastúu dē yā: ");
INSERT INTO mieNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Nūcu nduú ní ncúyāhvi perfume yáhá jā ūnī ciento denario, de cuāha ó nūū nchivī ndāhví nícu? ");
INSERT INTO mieNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Súcuán nī ncāhān dē, nsūú jā cúndáhví ndija inī dē nchivī ndāhví, chi sa jā cúu dē tēe cuíhná. Chi maá dē née itīn xūhún, de quéhen cuíhná dē jā jáquīn ndá tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Sá de nī ncāhān Jesús: Mā stáhān nū ña. Chi jā ní nsāhá ña yáhá cúu jā ní nsāhá tūha ña nduhū jōndē quīvī jā quiyuhū ni. ");
INSERT INTO mieNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chi níí cání ndéē nchivī ndāhví jíín nú, sochi nduhū chi mā cúndeē ni cā jíín nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","De cuāhā nchivī hebreo nī jini ji tūhun jā ndéē yā ñuū Betania. De nī nquenda ndá ji, de nsūú maá-ni jā cúnī ji cūndēhé ji nūū Jesús, chi suni cúnī ji cūndēhé ji nūū Lázaro, tēe jā ní nastécū yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ñúcuán de ndá sūtū cúñáhnú nī scáni táhán dē tūhun jā suni cahnī dē Lázaro. ");
INSERT INTO mieNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Chi jā síquī Lázaro de nī ncujiyo cuāhā táhán dē hebreo nūū dē, de cándíja ji Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","De incā quīvī, de ndá nchivī cuāhā jā ní nquenda vico pascua, nī jini ji tūhun jā váji Jesús Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","De nī jahnū ji ndahá ñūū, de nī nquee ji cuātahān ji yā. De nī ncana jee ndá ji: Cúñáhnú ndasí Yāā Dios. Vāha ndasí Yāā cúu Yāā jā váji jíín tiñu maá Jētohō ō Yāā Dios. Vāha ndasí Yāā cúu Rey maá ó nchivī Israel, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","De nī nīhīn Jesús iin burro, de nī jēcōsō yā tī, tá cúu nūū cáhān tutū īī: ");
INSERT INTO mieNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Nchivī Jerusalén jā suni nání Sión, mā cúyūhú ndá nú. Yáhá cūndēhé nú jā váji Rey nū, de yósō yā iin burro. Cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","De quīvī ñúcuán de ndá tēe scuáha jíín yā nduú ní jícūhun inī dē jā súcuán quée ndaā ndācá jā yósō nūū tutū īī. De jondē tá nī nduñáhnú Jesús jā cuánohōn yā andiví, de sá de nī nūcūhun inī dē ndá tūhun jā yósō sīquī yā, jíín jā súcuán nī nsāhá ndá dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","De ndá nchivī jā ní īyo jíín yā tá nī ncana yā Lázaro nūū yíyuhū dē, de nī nastécū yā dē, nī nacani ji tūhun nāsa nī nsāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jā ñúcuán cúu jā ní nquee nchivī cuāhā, nī jētahān ji yā, chi nī jini ji tūhun jā ní nsāhá yā tiñu ñáhnú jā ní stéhēn yā poder yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ñúcuán de nī ncāhān ndá máá tēe fariseo: Mitan de ja nī jinī ō jā má cūú cuitī cā casī ō. Chi ndéhé ó jā ndiviī cuitī nchivī cuāhān ji jíín dē, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","De sava nchivī nación Grecia, suni nī nquenda ji Jerusalén vico pascua jā chiñúhún ji Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","De nī nquenda ndá ji nūū Felipe, tēe ñuū Betsaida ndáñúū Galilea. De nī ncāhān ji jíín dē: Señor, cúnī ndá sá cāhān sá jíín Jesús, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","De nī jēhēn Felipe, nī ncachī tūhun dē nūū Andrés. De ndúū dē cuācachī tūhun dē nūū Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","De nī ncāhān Jesús jíín dē: Ja nī nquenda quīvī jā nduñáhnú maá Yāā nī nduu tēe. ");
INSERT INTO mieNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","De ndāā cáhān ni jíín ndá nú, iin nūnī trigo tú mā níncava nūū ñūhún jā quiyuhū, túsaá de coo mátúhún-ni. Sochi tú quiyuhū, de nacayā cuāhā ndasí. De suni súcuán cánuú jā cuū ni de quiyuhū ni, tácua coo cuāhā nchivī jā nduu ji sēhe Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","De nā-ni nchivī tú nduú jéhe ji tūhun cundoho ji jā síquī nduhū, de tānū tāhvī ji. De nchivī jā jéhe ji tūhun cundoho ji jā síquī nduhū inī ñayīví yáhá, cutecū ji níí cání andiví. ");
INSERT INTO mieNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","De tú ní nchivī cúnī ji satíñú ji nūū ni, de ná cúniquīn ji nduhū. De nūū cundeē maá nī, suni ñúcuán cundeē nchivī sátíñú nūū ni. De nchivī jā sátíñú nūū ni chi sāhá Tatá nī jā cuñáhnú ji. ");
INSERT INTO mieNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","De mitan de cúcuécá ndasí inī ni sáhá tūndóhó jā quiji sīquī ni. ¿De nāsa cāhān ni? ¿A cāhān ni jíín Tatá nī: Scácu ní sāán nūū tūndóhó jā quiji sīquī sá, cachī ni? Mā cūú, chi jā síquī ñúcuán cúu jā ní nquiji nī ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tatá, stéhēn ní jā cúñáhnú ndasí ní jíín poder ní, ncachī yā. Ñúcuán de ichi andiví nī ncāhān iin tūhun: Ja nī stéhēn ni jā cúñáhnú nī, de stéhēn tucu nī incā vuelta, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","De nī jini ndá nchivī íñí ñúcuán, de nī ncāhān ji jā taja cána. De sava cā ji nī ncāhān: Iin ángel Yāā Dios nī ncāhān jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","De nī ncāhān Jesús jíín ji: Nduú ní ncáhān Yāā Dios tūhun yáhá jā síquī nduhū, chi sa sīquī ndá máá nú tácua cunī nū jā ní ncāhān yā jíín nī. ");
INSERT INTO mieNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mitan cúu jā sándaā Yāā Dios sīquī cuāchi nchivī ñayīví yáhá. Mitan cúu jā scúnu yā jānēhén jā tátúnī inī ñayīví yáhá. ");
INSERT INTO mieNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","De nduhū, tá jīnu cundita caa nī cuū ni inī ñayīví, de sāhá nī jā cuu inī ndá nchivī quīvi ji ndahá nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Súcuán nī ncāhān yā jā stéhēn yā nāsa modo cuū yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","De nī ncāhān nchivī jíín yā: Nī jini ndá sá tūhun jā cáhān tutū ley Yāā Dios jā névāha ó, jā Cristo cutecū yā níí cání. ¿De nūcu cáhān ní jā Yāā nī nduu tēe, cánuú cundita caa yā cuū yā? ¿Ní iin cúu maá Yāā nī nduu tēe túsaá? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ñúcuán de nī ncāhān Jesús: Jacū-ni cā quīvī cundeē ni jíín ndá nú jā cúu nī luz jā cúnijīn inī ánō nū. Túsaá de mitan juni íyó cā luz ni jíín nú, de caca nú jíín, chi iin sanaā-ni de cuāhān ni, de quendōo nú modo nūū neē. Chi nchivī jíca modo nūū neē, nduú jínī ji ní cúu nūū quíhīn ji. ");
INSERT INTO mieNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Túsaá de juni ndéē cā ni jíín nú, de candíja nú nduhū jā cúu nī luz, tácua nduu nú nchivī jíca jíín luz, ncachī yā. Súcuán nī ncāhān yā ndá tūhun yáhá, de cuāhān yā-ni, de nduú cā ní stéhēn yā maá yā nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","De vísō cuāhā tiñu ñáhnú nī nsāhá Jesús jā stéhēn yā poder yā nūū nchivī, de nduú ní ncándíja ji yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Chi cánuú quee ndaā tūhun jā ní ncāhān Isaías, tēe nī nacani tūhun Yāā Dios janahán: Tátā Yāā Dios, nduú ní ncándíja ndá nchivī tūhun jā ní nacani sá, de nduú ní ncándíja ji tiñu ñáhnú jā ní stéhēn ní poder ní nūū ji. Ncachī Isaías. ");
INSERT INTO mieNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jā ñúcuán nduú ní ncúu candíja ndá ji, chi nī ncāhān tucu Isaías: ");
INSERT INTO mieNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nī nsāhá Yāā Dios modo jā cuáá ánō ndá ji, jíín jā cúnīhin inī ji, tácua coo modo jā má cūní ndá ji, de ni mā jícūhun inī ji, ni mā násāma inī ji quīvi ji nūū ni, jā nasāhá vāha nī ánō ji nūū cuáchi ji. Ncachī Cristo, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ndá tūhun yáhá nī ncāhān Isaías, chi ja nī jinī dē nāsa cúñáhnú ndasí Jesús, de nī ncāhān dē nāsa coo quīvī jā quiji yā. ");
INSERT INTO mieNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","De vísō súcuán de cuāhā nchivī hebreo chi nī ncandíja ji yā, de suni jondē jíín sava tēe tátúnī. Sochi nduú ní ncáchī ndá dē jā cándíja dē yā, chi sīquī jā yúhú dē tēe fariseo. Chi tú súcuán de mā cuáha cā ndá tūhun jā quīvi dē vehe īī sinagoga. ");
INSERT INTO mieNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Chi ndá tēe tátúnī cúsiī cā inī dē jā cuñáhnú dē sāhá nchivī, nsūú cā jā cuñáhnú dē sāhá Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","De nī ncāhān jee Jesús: Nchivī cándíja nduhū, de nsūú mátúhún-ni nduhū cándíja ji, chi suni cándíja ji jondē maá Tatá nī, Yāā nī ntají nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","De nchivī jínī nūū ni, suni jínī ji nūū Yāā nī ntají nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Maá nī jā cúu luz jā cúnijīn inī ánō nchivī, nī nquiji nī inī ñayīví tácua ndá nchivī cándíja nduhū, mā cācá ji modo nūū neē. ");
INSERT INTO mieNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","De tú iin nchivī jíni ji tūhun cáhān ni, de tú nduú jétáhví ji, de nsūú nduhū cúu jā sāhá ndāā sīquī ji. Chi nduú vāji nī jā nacunehen nī cuāchi sīquī nchivī ñayīví, chi sa jā scácu nī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","De nchivī jā squéne yichī nduhū, de nduú jétáhví ji tūhun cáhān ni, íyó iin jā sāhá ndāā sīquī ji. Suu ndācá tūhun jā ní ncāhān ni, tūhun ñúcuán cúu jā nacunehen cuāchi sīquī ji quīvī jīnu ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chi nduú cáhān ni jā cúu inī maá nī, chi Tatá nī, Yāā nī ntají nduhū, maá yā nī ndacu nūū ni nāsa cāhān ni jíín nāsa stéhēn ni. ");
INSERT INTO mieNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","De jínī ni jā tūhun ndácu Tatá nī sáhá jā cutecū nchivī níí cání. Túsaá de ndá tūhun jā cáhān ni, chi maá-ni tūhun jā ní ncachī Tatá nī cúu, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","De jañíni incā quīvī de quijéhé vico pascua. De ja jínī Jesús jā ní nquenda quīvī jā quee yā ñayīví yáhá quīnohōn yā nūū Tatá yā. De níní cúndáhví inī yā nchivī maá yā jā íyó inī ñayīví. De mitan jā ní ndihi quīvī jā íyó yā ñayīví, de sāhá yā iin tiñu jā stéhēn cājí yā jā cúndáhví inī yā ji. ");
INSERT INTO mieNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","De tāchī cúñáhnú ja nī scúu inī ánō Judas Iscariote sēhe Simón, jā mitan nastúu dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","De jínī Jesús jā vāji yā jōndē nūū Yāā Dios, de quīnohōn yā nūū Yāā Dios. De jínī yā jā ní nsāhá Tatá yā jā cúñáhnú yā sīquī ndihi-ni. ");
INSERT INTO mieNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","De cúxíní yā jíín ndá tēe scuáha jíín yā, de nī nacuiñī yā. De nī stáá yā sahma níjin yā, de nī juhnī yā iin toalla chījin yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","De nī nchuhun yā ndute inī iin tījēhēn. De nī nquijéhé yā náquete yā jēhē ndá tēe scuáha. De násíchī yā jíín toalla jā núhnī chījin yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","De nī nquenda yā nūū Simón Pedro. De nī ncāhān Pedro jíín yā: Señor, ¿á sa maá ní naquete ní jēhē sá? ");
INSERT INTO mieNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","De nī ncāhān Jesús: Nduú jícūhun inī nū jā sáhá nī mitan, de cúcuéé cā de jīcūhun inī nū. ");
INSERT INTO mieNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","De nī ncāhān Pedro jíín yā: Mā náquete cuitī ní jēhē sá. De nī ncāhān Jesús: Tú mā náquete nī jēhē nū, de mā cūú coo inuú inī nū jíín nī. ");
INSERT INTO mieNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","De nī ncāhān Simón Pedro: Señor, tú súcuán cúu de nsūú mátúhún-ni jēhē sá, chi saá-ni ndahá sá jíín xīnī sá naquete ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","De nī ncāhān Jesús jíín dē: Tēe jā cáta nī jichi, nduú jíni ñúhún ndundoo níí dē, chi maá-ni jēhē dē, chi ja íyó ndoo níí dē. De ndá ndóhó, chi ja nī ndundoo nú. Sochi nsūú ndihi ndá nú íyó ndoo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Chi ja jínī yā ní iin dē cúu jā nastúu dē yā, de jā ñúcuán nī ncāhān yā: Nsūú ndihi ndá nú íyó ndoo. ");
INSERT INTO mieNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","De tá nī ncuu nī naquete yā jēhē ndá dē, de nī naquehen yā sahma níjin yā, de nī nūcundeē yā nūū mesa. De nī ncāhān yā: ¿A jícūhun inī ndá nú nā cuá cúu jā ní nsāhá nī jíín nú? ");
INSERT INTO mieNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Cáhān ndá nú jā Maestro nū jíín Jētohō nū cúu nī, de ndāā cáhān ndá nú, chi suu cúu ndija nī. ");
INSERT INTO mieNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Túsaá de vísō Maestro nū jíín Jētohō nū cúu nī, de nī naquete nī jēhē ndá nú, de suni súcuán cánuú jā naquete ndá máá nú jēhē táhán nú. ");
INSERT INTO mieNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Chi tiñu yáhá nī nsāhá nī jā stéhēn ni nūū nū jā suni súcuán cánuú sāhá nú maá nú mozo nūū táhán nú, tá cúu nūū ní nsāhá nī maá nī mozo nūū ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jāndáā cáhān ni jíín nú jā iin mozo nduú cúñáhnú dē nūū patrón dē, de tēe jíca tiñu nduú cúñáhnú dē nūū tēe jā ní ntají dē. Túsaá de ndá máá nú cúu mozo ni, de suni súcuán cánuú sāhá nú maá nú nūū táhán nú tá cúu nūū ní stéhēn ni nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","De tú nī jīcūhun inī ndá nú ndá tūhun yáhá, de nācā ndetū tāhvī nū tú squíncuu nú. ");
INSERT INTO mieNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Sochi nduú cáhān ni jā ndihi nú ndetū, chi ja jínī ni ndá nú jā ní nacāji nī. De cánuú quee ndaā tūhun yáhá jā cáhān tutū īī: Tēe yájī stāā jíín nī, nī ndicó cóo dē sīquī ni, cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","De mitan de ja cáchī tūhun nī nūū nū ndācá jā coo jondē ncháha ca coo, tácua tá coo, de candíja nú jā maá nī cúu Yāā nī ntají Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jāndáā cáhān ni jíín ndá nú jā nā-ni nchivī cuetáhví ji ndācá jā tají nī, de nduhū cuetáhví ji. De nchivī jétáhví nduhū, suni jétáhví ji Yāā nī ntají nduhū vāji nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","De tá nī ncāhān Jesús ndá tūhun yáhá, de nī ncucuécá ndasí inī yā. De nī ncāhān cājí yā: Jāndáā cáhān ni jíín ndá nú jā iin nú nastúu nduhū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ñúcuán de ndá tēe scuáha jíín yā, nī nūcūndēhé nūū tāhán dē, jáni inī ndá dē ní iin dē cúu jā ní ncāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","De iin tēe scuáha jā mānī cā yā jíín, ndéē dē xiín yā nūū mesa jā cúxíní ndá dē jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","De nī nsāhá Simón Pedro seña nūū dē jā ná cátūhún dē yā ní iin dē cúu jā ní ncāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","De tēe ñúcuán nī scáyí dē maá dē nūū Jesús, de nī jīcā tūhún dē yā: Señor, ¿ní iin dē cúu? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","De nī ncāhān Jesús: Ná chúndaji nī stāā de cuāha nī nūū iin dē, de suu tēe ñúcuán cúu, ncachī yā. De nī nchundaji yā stāā, de nī jēhe yā nūū Judas Iscariote sēhe Simón. ");
INSERT INTO mieNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","De tá nī nquehen dē stāā ñúcuán, de nī nquīvi-ni Satanás inī ánō dē. Ñúcuán de nī ncāhān Jesús jíín dē: Tiñu jā sāhá nú, de ñamā sāhá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","De ni iin tēe yájī stāā jíín yā, nduú ní jícūhun inī dē nūcu cáhān yā súcuán jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Chi sava dē jáni inī dē jā ní ncāhān yā jíín Judas jā cueen dē jā jíni ñúhún yā vico, á jā cuāha dē jacū xūhún nūū nchivī ndāhví. Chi maá dē ndíso itīn xūhún. ");
INSERT INTO mieNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","De tá nī nchajī dē stāā ñúcuán, de nī nquee dē-ni cuāhān dē. De ja nī ncuaā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ñúcuán de tá cuāhān Judas, de nī ncāhān Jesús: Mitan de nduhū, Yāā nī nduu tēe, stéhēn ni nāsa cúñáhnú nī, de suni jíín nduhū de cunī nchivī nāsa cúñáhnú Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","De tú jíín nduhū cunī nchivī nāsa cúñáhnú Yāā Dios, túsaá de suni stéhēn Yāā Dios nāsa cúñáhnú nduhū jā cúu nī Sēhe yā. De ñamā-ni stéhēn yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Séhē, nduú cā nahán cundeē ni jíín ndá nú. De nanducú nú nduhū, de tá cúu nūū ní ncāhān ni jíín ndá táhán ó hebreo, suni súcuán cáhān ni jíín ndá nú mitan jā mā cūú cuēē nū nūū quíhīn ni. ");
INSERT INTO mieNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","De mitan de ndácu nī iin tiñu jéé nūū ndá nú, jā cundáhví inī nū táhán nú. Tá cúu nūū cúndáhví inī ni ndá máá nú, suni súcuán cundáhví inī nū táhán nú. ");
INSERT INTO mieNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","De tú cundáhví inī nū táhán nú, de súcuán de cunī ndācá nchivī jā cúu nú tēe scuáha jíín nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","De nī ncāhān Simón Pedro jíín yā: Señor, ¿ní cúu nūū quíhīn ní túsaá? De nī ncāhān Jesús: Nūū quíhīn ni chi mā cūú cuniquīn nū nduhū mitan, de cúcuéé cā de cuēē nū. ");
INSERT INTO mieNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","De nī ncāhān Pedro: Señor, ¿nūcu mā cūú cuniquīn sá níhín mitan? Nduú yúhú sá vísō cuū sá jā jéhē ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","De nī ncāhān Jesús: ¿A jáni inī nū jā má cúyūhú nú cuū nū jā jéhē ni? Jāndáā cáhān ni jíín nú jā jondē ncháha ca cana lohló, de ūnī vuelta cuyūhú nú de cāhān nū jāá nduú jínī nū nduhū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","De nī ncāhān cā yā: Mā cúcuécá inī ndá nú sīquī ndācá tūndóhó. Candíja nú jā sáhá Yāā Dios jēhē nū, de suni candíja nú jā sáhá nī jēhē nū. ");
INSERT INTO mieNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Chi nūū ndéē Tatá nī, íyó cuāhā vehe jā cundeē ndá nú. De tú nsūú súcuán íyó, de ja nī ncachī tūhun nī nūū nū nícu. Túsaá de quīhīn ni sāhá tūha nī nūū cundeē ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","De jā quíhīn ni sāhá tūha nī, de ndiji nī quinacueca nī ndá nú cōhōn, tácua suni cundeē nū nūū cundeē maá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","De ja jínī ndá nú ní jondē quīhīn ni, de ja jínī nū nāsa cuēē nū ñúcuán, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","De nī ncāhān Tomás jíín yā: Señor, nduú jínī ndá sá ní jondē quīhīn ní, ¿de nāsa cunī sá ichi cuēē sá ñúcuán túsaá? ");
INSERT INTO mieNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","De nī ncāhān Jesús jíín dē: Maá nī cúu ichi jā jīnū nū andiví, de maá nī cúu tūhun ndāā jíín tūhun jā cutecū nū níí cání. De ni iin mā cūú jīnū nūū Tatá nī de tú nduú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","De tú ja nī jinī nū nduhū, de suni ja nī jinī nū Tatá nī túsaá. De mitan de ja jínī ndá nú yā, chi ja nī jinī nū nūū ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","De nī ncāhān Felipe jíín yā: Señor, stéhēn ní Tatá ní nūū sá, de ná cúvāha inī ndá sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","De nī ncāhān Jesús: Felipe, ja nī ncuu cuāhā quīvī jíca nī jíín ndá nú, ¿de á ncháha ca cunī nū ní iin cúu nduhū? Tēe jā ndéhé nūū ni, suni ndéhé dē nūū Tatá nī. ¿Túsaá de nūcu cáhān nū jā stéhēn ni Tatá nī nūū nū? ");
INSERT INTO mieNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿A nduú cándíja nú jā iin-ni cúu nī jíín Tatá nī, de Tatá nī iin-ni cúu yā jíín nī? Ndācá tūhun jā cáhān ni jíín nú, nsūú tūhun maá nī cúu. Chi Tatá nī jā iin-ni cúu yā jíín nī, maá yā sáhá ndācá tiñu jā sáhá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Candíja ndá nú jā iin-ni cúu nī jíín maá Tatá nī, de Tatá nī iin-ni cúu yā jíín nī. De tú nduú cúu candíja ndá nú, sochi candíja nú maá sīquī ndācá tiñu sáhá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jāndáā cáhān ni jíín ndá nú, tú ní iin nchivī candíja ji nduhū, de tiñu ñáhnú jā sáhá nī yáhá, suni sāhá ji. De ñáhnú cā tiñu sāhá ji nsūú cā yáhá, chi quīnohōn ni nūū ndéē Tatá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","De ndācá nā-ni cúu jā cācān nū nūū Tatá nī sīquī jā cándíja nú jā cúu nī Sēhe yā, de sāhá nī jā cācān nū, de súcuán stéhēn ni jā cúñáhnú ndasí Tatá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Chi níní sāhá nī ndācá nā-ni cúu jā cācān nū sīquī jā cándíja nú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","De tú mānī ndá nú jíín nī, de squíncuu nú tiñu ndácu nī nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","De cācān táhvī ni nūū Tatá nī, de tetíñú yā incā Yāā jā chindeé chituu ndá ndóhó, de sāhá yā jā coo siī inī nū. De Yāā ñúcuán cúu maá Espíritu Santo jā stéhēn tūhun ndāā, de coo yā jíín nú níí cání. ");
INSERT INTO mieNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","De nchivī ñayīví mā cūú cuetáhví ji yā, chi nduú cúu cūndēhé ji nūū yā, ni nduú cúu cunī ji nāsa Yāā cúu yā. Sochi ndá máá nú chi ja jínī nū nāsa Yāā cúu yā, chi ndéē yā jíín nú, de cundeē yā inī ánō nū níí cání. ");
INSERT INTO mieNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mā sndóo uun nī ndá nú, chi ndiji nī nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jacū-ni cā quīvī de mā cūní cā nchivī ñayīví nūū ni. Sochi ndá máá nú chi cunī nū nūū ni, chi cutecū ni níí cání, de jā ñúcuán suni cutecū ndá máá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","De quīvī ñúcuán de cunī nū jā iin-ni cúu nī jíín Tatá nī, de ndá máá nú suni iin-ni cúu nú jíín nī jā ndéē ni inī ánō nū. ");
INSERT INTO mieNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tú nā-ni nchivī ñúhún inī ji tiñu ndácu nī, de squíncuu ji, suu nchivī ñúcuán cúu jā mānī ndija jíín nī. De nchivī jā mānī jíín nī, suni coo manī Tatá nī jíín ji. De saá-ni nduhū coo manī ni jíín ji, de stéhēn ni maá nī nūū ji jā íyó nī jíín ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","De nī ncāhān Judas jíín yā (de nsūú tēe cúu Iscariote): Señor, ¿nūcu stéhēn ní maá ní nūū ndá máá sá, de nūū nchivī ñayīví chi nduú? ");
INSERT INTO mieNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","De nī ncāhān Jesús: Nchivī jā mānī jíín nī, chi squíncuu ji tūhun jā cáhān ni. De coo manī Tatá nī jíín ji. De Tatá nī jíín maá nī quiji nī coo nī jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","De nchivī jāá nduú mānī jíín nī, chi nduú squíncuu ji jā cáhān ni. De tūhun níni ndá nú jā cáhān ni, nsūú tūhun maá nī cúu, chi tūhun maá Tatá nī jā ní ntají nduhū cúu. ");
INSERT INTO mieNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ndācá tūhun yáhá cáhān ni jíín nú juni ndéē ni cā jíín nú. ");
INSERT INTO mieNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","De Tatá nī chi tetíñú yā Espíritu Santo, quiji nūcuīñī nūū ni. De maá yā chindeé chituu yā ndá ndóhó, de sāhá yā jā coo siī inī nū. De stéhēn yā ndācá tūhun nūū nū, de nacachī yā ndācá jā ní ncāhān ni jíín nú. ");
INSERT INTO mieNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","De jā quíhīn ni, de sāhá nī jā coo ndeé coo siī inī ndá nú. Tá cúu nūū íyó ndeé íyó sīī inī maá nī, suni súcuán coo ndeé coo siī inī ndá nú sāhá nī. De jā sāhá nī jā coo ndeé coo siī inī nū, nduú quítáhán jíín tūhun ndeé inī jā cáhān nchivī ñayīví. Mā cúcuécá inī ndá nú sīquī ndācá tūndóhó, de ni mā cúyūhú nú. ");
INSERT INTO mieNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ja nī jini ndá nú jā ní ncāhān ni jā quíhīn ni, de ndiji nī coo tucu nī jíín nú. De tú íyó mānī vāha nú jíín nī, de cusiī inī nū jā ní ncāhān ni jā quínohōn ni nūū Tatá nī. Chi cúñáhnú cā Tatá nī nsūú cā nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ja nī ncachī tūhun nī nūū nū ndācá tūhun yáhá jondē ncháha ca coo, tácua tá ja nī ncuu, de candíja ndá nú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mā cáhān ni cuāhā cā jíín ndá nú, chi ja vāji jānēhén jā tátúnī inī ñayīví yáhá. De ni iin mā cūú sāhá sīquī ni nícu. ");
INSERT INTO mieNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sochi mitan de ná cóo tá cúu nūū ní ndacu Tatá nī nūū ni, tácua cunī nchivī ñayīví jā mānī ni jíín Tatá nī, de sáhá nī tiñu jā ní ndacu yā. Nacuiñī ndá nú ná cóhōn túsaá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","De nī ncāhān cā yā: Maá nī cúu tá cúu yoho yūcū uva ndāā, de Tatá nī cúu tá cúu tēe jā jíto yoho yúcū. ");
INSERT INTO mieNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","De ndá máá nú chi cúu nú tá cúu ndahá yúcū, de tú nduú jéhe nú ndīhā de candeē yā ndóhó. De tú cúu ndá nú modo ndahá jā jéhe ndīhā, de naquehndē yā nasāhá ndoo yā ndóhó modo jā cúu nú ndahá ñúcuán, tácua cuāha nú cuāhā cā ndīhā. ");
INSERT INTO mieNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","De ndá máá nú chi ja nī ndundoo ánō nū jíín tūhun nī stéhēn ni nūū nū, tá cúu nūū ndúndoo ndahá uva. ");
INSERT INTO mieNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","De cuiñi nīhin nú jíín nī, de suni maá nī coo nī jíín nú. Iin ndahá yúcū mā cūú cuāha ndīhā jā maá-ni, de tú nduú tíin yīcā yoho. De saá-ni ndá ndóhó, mā cūú sāhá nú tiñu váha de tú mā cuīñí nīhin nú jíín nī. ");
INSERT INTO mieNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Maá nī cúu yoho yúcū ñúcuán, de ndá máá nú cúu ndahá nī. Nchivī jā íñí nīhin jíín nī, de íyó nī jíín ji, maá ji cúu tá cúu ndahá jā ndéē cutú jíín yoho yúcū jā jéhe cuāhā ndīhā. Chi tú nduú íñí nīhin nú jíín nī, de nduú cuitī nā tiñu váha cuu sāhá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nchivī jāá nduú íñí nīhin jíín nī, candeē yā ji modo iin ndahá yūcū uva, de yīchī. De cuu ji modo ndahá yūcū uva jā ndutútú de cāyū nūū ñúhūn. ");
INSERT INTO mieNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tú íñí nīhin ndá nú jíín nī, de tú ñúhún inī nū ndá tūhun cáhān ni, ñúcuán de cācān nū nā-ni cúu jā cúnī nū, de sāhá nī jā cācān nū. ");
INSERT INTO mieNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","De tú sāhá ndá nú cuāhā tiñu váha, tá cúu nūū jéhe ndahá yúcū cuāhā ndīhā, súcuán stéhēn nū jā cúu ndija nú nchivī scuáha jíín nī, de súcuán cunī nchivī jā cúñáhnú ndasí Tatá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","De tá cúu nūū mānī Tatá nī jíín nī, suni súcuán mānī ni jíín ndá nú. Túsaá de mā siáā nū tūhun jā mānī ni jíín nú. ");
INSERT INTO mieNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tú squíncuu nú tiñu nī ndacu nī nūū nū, de níní coo manī ni jíín nú, tá cúu nūū squíncuu maá nī tiñu nī ndacu Tatá nī nūū ni, de níní íyó mānī yā jíín nī. ");
INSERT INTO mieNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Súcuán nī ncāhān ni jíín ndá nú tácua coo siī inī nū tá cúu nūū íyó sīī inī ni, chi jondē cusiī ndasí inī nū. ");
INSERT INTO mieNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","De yáhá cúu tiñu jā ndácu nī nūū ndá nú: Jā cundáhví inī nū táhán nú, tá cúu nūū cúndáhví inī ni ndá máá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tú iin tēe cuū dē jā jéhē amigo dē, túsaá de nduú cā nā cuá cúmanī cā sāhá dē jā cundáhví inī dē amigo dē. ");
INSERT INTO mieNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","De ndá máá nú cúu amigo ni de tú squíncuu nú ndá tiñu jā ndácu nī nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mā cáhān cā ni mozo jíín ndá nú, chi iin mozo nduú cáchī tūhun patrón nūū ji nāsa jáni inī dē sāhá dē. Chi sa amigo cáhān ni jíín ndá nú, chi ja nī ncachī tūhun nī nūū nū ndācá tūhun jā ní ncāhān Tatá nī jíín nī. ");
INSERT INTO mieNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Maá nī nī nacāji ndá ndóhó jā scácu nī ndóhó, de nsūú ndá máá nú nī nacani inī xihna cā jā cuniquīn nū nduhū. De nī jani nī ndá ndóhó jā caca ndaā nū de scándíja nú cuāhā nchivī jā cuu ji sēhe nī níí cání. De súcuán de ndihi jā cācān nū nūū Tatá nī sīquī jā cándíja nú nduhū, sāhá yā jā cācān nū. ");
INSERT INTO mieNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","De yáhá cúu tiñu jā ndácu nī nūū nū: Jā cundáhví inī nū táhán nú. ");
INSERT INTO mieNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","De tú quítī inī nchivī ñayīví jínī ji ndá nú, de ja jínī nū jā xihna cā nūū maá nī nī nquītī inī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","De tú jā cúu cā nū cuenta ñayīví, de coo manī nchivī ñayīví jíín nú nícu, tá cúu nūū mānī ji jíín táhán ji. Sochi nī nacāji nī ndá ndóhó jā má sāhá cā nū tá sáhá nchivī ñayīví. De jā ñúcuán cúu jā quítī inī ji nūū ndá nú, chi nduú cā cúu nú cuenta ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nūcūhun inī ndá nú tūhun jā ní ncāhān ni jíín nú: Tú nduú íyó yíñúhún nchivī nūū patrón, de nā oncā cúu nūū mozo dē. Tú nī jinī ūhvī ji nduhū, de suni súcuán cunī ūhvī ji ndá ndóhó jā cúu nú mozo ni. De tú nī jetáhví ji tūhun stéhēn ni, de suni cuetáhví ji tūhun stéhēn ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","De ndācá tiñu yáhá sāhá ji jíín ndá nú jā síquī nduhū, chi nduú jínī ji Yāā jā ní ntají nduhū vāji nī. ");
INSERT INTO mieNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tú nduú ní nquíji nī jā nacani nī tūhun nūū ndá ji, de mā cōó cuāchi ji nícu. De mitan de mā cūú cā cāhān ji jāá nduú jínī ji jā íyó cuāchi ji. ");
INSERT INTO mieNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nchivī jā quítī inī jínī nduhū, suni nūū Tatá nī quítī inī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tú nduú ní nsáhá nī tiñu ñáhnú nūū ji jā ni iin tēe nduú sáhá dē súcuán, de mā cōó cuāchi ji nícu. De mitan de ja nī jinī ji tiñu ñúcuán, de vísō súcuán de quítī inī ji nūū ni jíín nūū Tatá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","De súcuán sáhá ji tácua quee ndaā tūhun jā yósō nūū tutū ley Yāā Dios jā névāha ji: Nī nquītī inī ji nūū ni, vísō nduú nā cuāchi nī, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","De tetíñú nī maá Yāā jā chindeé chituu ndá ndóhó de sāhá yā jā coo siī inī nū. De Yāā ñúcuán cúu maá Espíritu Santo jā stéhēn tūhun ndāā, de quiji yā jondē nūū Tatá nī, de nacani cájí yā tūhun nī. ");
INSERT INTO mieNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","De saá-ni ndá máá nú nacani nú tūhun nī, chi ja íyó nú jíín nī jondē tá nī nquijéhé nī nacani nī tūhun. ");
INSERT INTO mieNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ndá tūhun yáhá nī ncāhān ni jíín ndá nú tácua mā náyūhú nú tá quiji tūndóhó. ");
INSERT INTO mieNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chi tavā ji ndá nú jā má cuáha cā ji tūhun cundeē nū ndācá vehe īī sinagoga. De quenda quīvī jā cahnī ji ndóhó, de cani inī ji jā iin tiñu váha nī nsāhá ji nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","De súcuán sāhá ji jíín nú, chi nduú jínī cuitī ji maá Tatá nī de juni maá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","De nī ncāhān ni ndá tūhun yáhá jíín nú, tácua tá quenda quīvī jā súcuán coo, de nūcūhun inī nū jā súcuán nī ncāhān ni jíín nú. De nduú ní ncáhān ni ndá tūhun yáhá jíín nú jondē jā xihna ñúhún, chi íyó maá nī jíín ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","De mitan chi quīnohōn ni cundeē ni jíín Yāā nī ntají nduhū vāji nī. De ni iin nú nduú jícā tūhún nduhū ní nūū quíhīn ni. ");
INSERT INTO mieNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Chi sa jā cúcuécá ndasí inī nū jā ní ncāhān ni súcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Jāndáā cáhān ni jíín nú: Jā váha ndá ndóhó cúu jā quíhīn ni. Chi tú mā quíhīn ni, de mā quījí Yāā jā chindeé chituu ndá ndóhó de sāhá yā jā coo siī inī nū. Sochi tá quīhīn ni, de tetíñú nī yā quiji yā nūū nū. ");
INSERT INTO mieNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","De tá quenda yā, de stéhēn yā nūū nchivī ñayīví jā íyó cuāchi ji, jíín nāsa quīvi ji ichi ndāā, jíín jā sāhá ndāā Yāā Dios sīquī cuāchi ji. ");
INSERT INTO mieNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Stéhēn yā jā íyó cuāchi ji, chi nduú cándíja ji nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","De stéhēn yā nāsa quīvi ji ichi ndāā, chi maá nī quīnohōn ni nūū Tatá nī, de mā cūní cā nū nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","De stéhēn yā sīquī jā sāhá ndāā Yāā Dios cuāchi nchivī, chi ja nī ncundaā jā tānū tāhvī maá jānēhén jā cúñáhnú inī ñayīví yáhá. ");
INSERT INTO mieNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","De íyó cuāhā cā tūhun jā cúnī ni cāhān ni jíín ndá nú, de mā cūú jīcūhun inī nū mitan. ");
INSERT INTO mieNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","De tá quenda maá Espíritu jā stéhēn tūhun ndāā, suu maá yā stéhēn ndācá tūhun ndāā nūū nū. Chi mā cáhān yā jā maá yā, chi cāhān yā ndācá jā níni yā jā cáhān Yāā Dios. De stéhēn yā sīquī ndācá tiñu jā coo. ");
INSERT INTO mieNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","De stéhēn yā jā cúñáhnú nī, chi nacachī tūhun yā nūū nū ndācá tūhun ja nī ncāhān ni, de sāhá yā jā jīcūhun inī nū. ");
INSERT INTO mieNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ndihi nāsa cúñáhnú Tatá nī, suni súcuán cúñáhnú maá nī. Jā ñúcuán cúu jā ní ncāhān ni jā Espíritu Santo nacachī tūhun yā nūū nū ndācá tūhun ja nī ncāhān ni, de sāhá yā jā jīcūhun inī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Iin lulī-ni cā de mā cūní cā ndá nú nūū ni. De suni iin lulī-ni cā de nacunī tucu nú nūū ni, chi quīnohōn ni nūū ndéē Tatá nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ñúcuán de sava tēe scuáha jíín yā, nī jīcā tūhún táhán dē: ¿Nā tūhun cúu yáhá jā ní ncāhān yā jíín ó? Chi cáchī yā jā iin lulī-ni cā de mā cūní cā ō nūū yā, de suni iin lulī-ni cā de nacunī tucu ó nūū yā, chi sīquī jā quínohōn yā nūū ndéē Tatá yā. ");
INSERT INTO mieNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Nā tūhun cúu yáhá jā ní ncāhān yā, iin lulī-ni cā? Nduú jícūhun inī ō nā cuá cúu jā cáhān yā, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","De nī jinī Jesús jā cúnī ndá dē cātūhún dē yā. De nī ncāhān yā jíín dē: ¿A jícā tūhún táhán ndá nú nā cuá cúu jā ní ncāhān ni jā iin lulī-ni cā de mā cūní cā nū nūū ni, de suni iin lulī-ni cā de nacunī tucu nú nūū ni? ");
INSERT INTO mieNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Jāndáā cáhān ni jíín nú jā cuacu ndá nú de cucuécá inī nū, sochi nchivī ñayīví chi sa cusiī inī ji. De vísō cucuécá inī ndá nú, sochi ndusiī inī nū jā cunī tucu nú nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Iin ñahan tá cuācuñatin scácu ña, de téhndē chījin ña, chi ja nī nquenda hora jā scácu ña. De tá ja nī ncacu sūchí lúlí, de nduú cā náhán ña jā ní ndoho ña, chi cúsiī inī ña jā ní ncacu sēhe ña. ");
INSERT INTO mieNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","De suni súcuán cúu jā ndóho ndá nú mitan, chi cúcuécá inī nū jíín nī. Sochi iin lulī-ni cā de nacunī tāhán tucu ó, de cusiī ndasí inī nū. De ni iin mā cásī jā cusiī inī nū. ");
INSERT INTO mieNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","De quīvī ñúcuán de nduú nā cuá cācān cā ndá nú nūū ni. Chi jāndáā cáhān ni jíín nú jā nūū maá Tatá nī cācān nū, de sāhá yā ndihi jā jícān ndá nú, sīquī jā cándíja nú nduhū. ");
INSERT INTO mieNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Jondē mitan de ncháha ca cācān nū nūū Tatá nī jā jíín síví nī. De mitan de quijéhé nú cācān nū jíín síví nī, de nīhīn nū, tácua cusiī ndasí inī nū. ");
INSERT INTO mieNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ndá tūhun yáhá nī ncāhān yātá nī jíín ndá nú. De quiji quīvī jā má cáhān yātá cā ni jíín nú, chi sa cachī tūhun cájí nī nūū nū sīquī Tatá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","De quīvī ñúcuán chi cācān ndá nú nūū Tatá nī sīquī jā cándíja nú nduhū. De nduú cáhān ni jíín nú jā cācān táhvī ni jēhē nū nūū Tatá nī. ");
INSERT INTO mieNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Chi maá Tatá nī ja cúndáhví inī yā ndá nú sīquī jā íyó mānī nū jíín nī, de nī ncandíja nú jā jondē nūū maá yā vāji nī. ");
INSERT INTO mieNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nī nquee nī jondē nūū Tatá nī, de nī nquenda nī inī ñayīví. De mitan de quee nī inī ñayīví, de quīnohōn tucu nī nūū Tatá nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","De nī ncāhān ndá tēe scuáha jíín yā: Mitan de cáhān cājí ní, de nduú cā cáhān yātá ní. ");
INSERT INTO mieNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mitan de jínī ndá sá jā jínī ní ndiviī cuitī, de nduú cā jíni ñúhún jā cātūhún ndá sá níhín. Jā ñúcuán cúu jā cándíja sá jā váji ní jondē nūū Yāā Dios, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","De nī ncāhān Jesús jíín dē: ¿A jondē mitan de cándíja ndá nú, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","De quiji quīvī, de ja nī nquenda, jā cūtē nuu ndá nú quīnohōn nū tá vehe tá vehe nú, de sndóo ndá nú mátúhún-ni cā nduhū. Sochi nsūú jā quendōo mátúhún nī, chi Tatá nī íyó yā jíín nī. ");
INSERT INTO mieNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ndācá tūhun yáhá nī ncāhān ni jíín ndá nú tácua coo ndeé coo siī inī nū sīquī jā cándíja nú nduhū. Inī ñayīví chi cánuú cunī ndá nú tūndóhó. De vísō súcuán de ná cóo siī inī nū, chi ja nī ncandeē ni poder ndācá jānēhén jā íyó inī ñayīví, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","De tá nī ncuu nī ncāhān Jesús ndá tūhun yáhá, de nī nūcūndēhé yā ichi andiví, de nī ncāhān yā: Tatá, ja nī nquenda quīvī jā cundoho sá. Mitan de stéhēn ní jā cúñáhnú sá jā cúu sá Sēhe ní, tácua suni maá sá stéhēn sá jā cúñáhnú maá ní. ");
INSERT INTO mieNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Chi nī nsāhá ní jā ndíso tíñú sá sīquī ndācá nchivī, tácua ndācá nchivī jā ní jēhe ní nūū sá, cutecū ji níí cání sāhá sá. ");
INSERT INTO mieNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","De suha cúu tūhun cutecū ji níí cání: Suu jā cunī ji níhín jā mátúhún ní cúu Yāā ndāā, jíín jā cunī ji sāán jā cúu sá Jesucristo, Yāā nī ntají ní. ");
INSERT INTO mieNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ja nī stéhēn sá nūū nchivī ñayīví jā cúñáhnú ní, de ja nī nsínu sá tiñu jā ní ndacu ní nūū sá. ");
INSERT INTO mieNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","De mitan, Tatá, sāhá ní jā nduñáhnú tucu sá jondē nūū ndéē ní, tá cúu nūū cúñáhnú sá jíín ní jondē ncháha ca jēcāva ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nchivī jā ní nacāji ní inī ñayīví, nī jēhe ní ji nūū sá, de nī stéhēn sá nūū ji nāsa Yāā cúu ní. Cuenta maá ní cúu ji, de nī jēhe ní ji nūū sá. De nī jetáhví ndá ji tūhun ní, de nī squíncuu ji. ");
INSERT INTO mieNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","De mitan de jínī ji jā jondē nūū maá ní vāji ndācá jā íyó jíín sá. ");
INSERT INTO mieNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Chi ndācá ndá tūhun jā ní ncāhān ní jíín sá, nī ncachī tūhun sá nūū ndá ji, de nī jetáhví ji. De nī jinī ji jā ní nquee ndija sá jondē nūū maá ní, de nī ncandíja ji jā maá ní nī ntetíñú sāán. ");
INSERT INTO mieNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","De jícān táhvī sá jēhē ndá máá ji. Nduú jícān táhvī sá jēhē nchivī ñayīví jāá nduú cándíja, chi sa jēhē maá nchivī jā ní jēhe ní nūū sá, chi cuenta maá ní cúu ji. ");
INSERT INTO mieNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Chi ndācá ji jā yíhí ndahá maá sá, suni cuenta maá ní cúu. De ndācá ji jā cúu cuenta maá ní, suni cuenta maá sá cúu. De stéhēn ndá ji nāsa cúñáhnú sá. ");
INSERT INTO mieNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","De mā cúndeē cā sá inī ñayīví. Sochi ndá máá ji chi quendōo ji inī ñayīví, de maá sá chi cuēē najeē sá cundeē sá jíín ní. Tatá, cúu ní Yāā īī Yāā íyó ndoo. De jíín poder ní coto ní ndācá nchivī jā ní jēhe ní nūū sá, tácua inuú ná cóo inī ndá ji, tá cúu nūū íyó maá ó. ");
INSERT INTO mieNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","De tá nī īyo sá jíín ji inī ñayīví, de jíín poder ní nī jito sá ji. Ndá nchivī jā ní jēhe ní nūū sá, nī jito ñuncúún sá ji. De nduú ní jéhe sá tūhun jā naā ni iin ji, chi mátúhún-ni tēe jā cúu dē tēe tānū tāhvī, tácua quee ndaā tūhun yósō nūū tutū īī. ");
INSERT INTO mieNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","De mitan de cuēē najeē sá nūū ní, de juni íyó cā sá inī ñayīví de cáhān sá ndá tūhun yáhá jíín ji, tácua ná cúsiī ndasí inī ji tá cúu nūū cúsiī inī maá sá. ");
INSERT INTO mieNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nī ncachī tūhun sá tūhun ní nūū ndá ji. De nī nquītī inī nchivī ñayīví nūū ji, chi nduú cā cúu ji cuenta ñayīví, tá cúu nūū cúu maá sá jāá nduú cúu sá cuenta ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","De nduú jícān táhvī sá jā tavā ní ji inī ñayīví, chi sa jā coto ní ji nūū tāchī cúñáhnú. ");
INSERT INTO mieNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nsūú cuenta ñayīví cúu ndá ji, tá cúu nūū cúu maá sá jāá nsūú cuenta ñayīví cúu sá. ");
INSERT INTO mieNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Jíín tūhun ndāā ní de sāhá ní jā ná cóo ndoo coo īī ji nūū ní. Ndá tūhun cáhān maá ní cúu tūhun ndāā. ");
INSERT INTO mieNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","De tá cúu nūū ní ntetíñú ní sāán nī nquiji sá inī ñayīví, suni súcuán tétíñú sá ndá ji nacani ji tūhun ní nūū nchivī ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","De jā jéhē ndá ji cúu jā sócō sá maá sá cuū sá, tácua suni maá ji coo ndoo coo īī ji nūū ní jā jíín tūhun ndāā. ");
INSERT INTO mieNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","De nsūú iin-ni jēhē ndá nchivī yáhá jícān táhvī sá, chi suni jēhē ndá cā nchivī jā candíja ji sāán tá cunini ji tūhun jā nacani ndá máá ji. ");
INSERT INTO mieNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","De jícān táhvī sá jā inuú ná cóo inī ndá ji. Tá cúu nūū iin-ni cúu ní jíín sá, Tatá, de iin-ni cúu sá jíín maá ní, suni súcuán ná cóo inuú ndá ji jíín ó. De cúnī sá jā inuú ná cóo inī ji, tácua candíja nchivī ñayīví jā maá ní nī ntetíñú ní sāán. ");
INSERT INTO mieNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nī nsāhá ñáhnú sá ndá ji tá cúu nūū ní nsāhá ñáhnú ní sāán, tácua inuú ná cóo inī ji, tá cúu nūū íyó inuú maá ó. ");
INSERT INTO mieNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","De íyó inuú sá jíín ndá ji, de suni íyó inuú ní jíín sá, de súcuán de inuú cuitī coo inī ndá ji. Ñúcuán de cunī nchivī ñayīví jā maá ní nī ntetíñú sāán, jíín jā mānī ndasí ní jíín ndá ji, tá cúu nūū mānī ní jíín sá. ");
INSERT INTO mieNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tatá, maá ní nī jēhe ní ji nūū sá. De cúnī sá jā cundeē ji jíín sá nūū cundeē sá, tácua cunī ji nāsa viī cúñáhnú sá nī nsāhá ní. Chi íyó mānī ndasí ní jíín sá jondē ncháha ca jēcāva ñayīví de jondē mitan. ");
INSERT INTO mieNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yāā ndāā cúu ní, Tatá, de nchivī ñayīví nduú jínī ji níhín, de maá sá chi jínī sá níhín. De ndá nchivī yáhá chi jínī ji jā maá ní nī ntetíñú sāán. ");
INSERT INTO mieNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nī stéhēn sá nūū ndá ji nāsa Yāā cúu ní. De stéhēn cā sá súcuán nūū ji, tácua ná cóo manī ndasí ji jíín táhán ji, tá cúu nūū íyó mānī ndasí ní jíín sá, de tácua cundeē sá inī ánō ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","De tá nī ncuu nī ncāhān Jesús ndá tūhun yáhá, de nī nquee yā jíín ndá tēe scuáha jíín yā, cuāhān yā incā lado yuū Cedrón. De ñúcuán íyó iin huerto nūū ní nquīvi yā jíín ndá tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","De Judas, tēe jā nastúu dē yā, suni jínī dē lugar ñúcuán, chi cuāhā vuelta nī ndutútú Jesús ñúcuán jíín ndá tēe scuáha jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","De nī nquenda dē ñúcuán jíín iin grupo soldado jíín jacū policía jā jíto templo, jā ní ntají ndá sūtū cúñáhnú jíín ndá tēe fariseo. De ndíso ndá dē espada, de née dē linterna jíín iti. ");
INSERT INTO mieNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","De Jesús ja jínī yā ndācá tūndóhó jā váji sīquī yā. De nī nquenda yā ichi núū ndá dē, de nī ncāhān yā: ¿Nā tēe nánducú ndá nú? ");
INSERT INTO mieNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","De nī ncāhān ndá dē jíín yā: Jesús tēe ñuū Nazaret. De nī ncāhān yā: Maá nī cúu. De Judas, tēe jā nástúu dē yā, suni íñí dē jíín ndá tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","De jā súcuán nī ncāhān yā, maá nī cúu, de nī jica yátá ndá dē, de nī jicó cáva ndá dē-ni. ");
INSERT INTO mieNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ñúcuán de nī jīcā tūhún tucu yā dē: ¿Nā tēe nánducú ndá nú? Jesús tēe ñuū Nazaret, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","De nī ncāhān Jesús: Ja nī ncachī ni jā maá nī cúu. De tú nduhū nánducú ndá nú, de maá nī-ni tiin nú, de ndá tēe yáhá ná quíhīn dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Súcuán nī ncuu tácua quee ndaā tūhun jā ní ncāhān yā jíín Tatá yā: Nduú ní jéhe sá tūhun jā naā ni iin tēe jā ní jēhe ní nūū sá, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","De Simón Pedro ndíso dē iin espada. De nī ntavā dē, de nī jehndē dē sōho lado cuáhá iin tēe nání Malco. De tēe ñúcuán cúu mozo maá sūtū cúñáhnú. ");
INSERT INTO mieNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","De nī ncāhān Jesús jíín Pedro: Nachuhun espada nū inī cubierta. ¿A nduú cánuú jā cundoho nī tūndóhó yáhá jā ní nsāhá ndāā Tatá nī jā cundoho nī? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ñúcuán de ndá soldado jíín capitán dē, jíín ndá policía tēe hebreo, nī ntiin ndá dē Jesús, de nī juhnī dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","De xihna cā vehe Anás cuāhān ndá dē jíín yā. De tatá chíso Caifás cúu Anás. De Caifás cúu maá sūtū cúñáhnú cā cuīyā ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","De suu dē nī ncachī nūū ndá táhán dē hebreo jā cánuú jā cuū iin tēe jā jéhē nación dē. ");
INSERT INTO mieNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","De Simón Pedro jíín incā tēe scuáha, níquīn ndúū dē Jesús cuāhān dē yātā yā. De incā tēe scuáha ñúcuán chi jínī tāhán dē jíín sūtū cúñáhnú. Jā ñúcuán cúu jā ní nquīvi dē jíín Jesús inī patio vehe sūtū cúñáhnú. ");
INSERT INTO mieNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Sochi Pedro nī nquendōo dē yātā viéhé patio. De maá tēe scuáha jā jínī tāhán jíín sūtū cúñáhnú, nī nquee dē nī ncāhān dē jíín ñahan jíto viéhé, de nī squívi dē Pedro inī patio. ");
INSERT INTO mieNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ñúcuán de ñahan jíto viéhé, nī jīcā tūhún ña Pedro: ¿A nsūú iin tēe scuáha jíín tēe jā íñí nūū sūtū ñúcuán cúu nú? ncachī ña. Nsūú cúu nī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","De ndá mozo jíín ndá policía ñúcuán nī stáhān ndá dē ñuhūn jíín tīcāyi, chi vījin sáhá. De íñí ndá dē násaā dē. De suni íñí Pedro, násaā dē jíín ndá tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","De sūtū cúñáhnú ñúcuán nī stíchī dē Jesús nā tēe cúu ndá tēe jā scuáha jíín yā, jíín nā tūhun cúu jā stéhēn yā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","De nī ncāhān yā: Níní nī ncāhān ni nūū íyó chitú nchivī, de nī jini ndihi nchivī. De níní nī stéhēn ni tūhun inī ndá vehe īī sinagoga jíín inī templo cāhnú nūū ndútútú ndiviī táhán ó hebreo. De ni iin tūhun nduú ní ncáhān yuhū ni. ");
INSERT INTO mieNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿De nūcu jícā tūhún nú nduhū? Cātūhún nú ndá nchivī jā ní jini tūhun nī ncāhān ni, de maá ji cachī nāsa nī ncāhān ni. Chi jínī ndá ji nāsa nī ncāhān ni. ");
INSERT INTO mieNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","De jā ní ncāhān Jesús súcuán, de iin policía jíto templo jā íñí ñúcuán, nī ncani dē nūū yā. De nī ncāhān dē jíín yā: ¿A súcuán cáhān nū jíín sūtū cúñáhnú, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","De nī ncāhān Jesús: Tú nī ncāhān ni iin tūhun nēhén, de cachī nā tūhun nēhén cúu jā ní ncāhān ni. Sochi tú nduú ní ncáhān ni iin tūhun nēhén, ¿de nūcu cáni nú nduhū? ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ñúcuán de Anás jā cúu sūtū cúñáhnú, nī ntají dē yā, núhnī yā cuāhān yā nūū Caifás, tēe cúu sūtū cúñáhnú cā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","De juni súcuán cúu, de íñí Pedro násaā dē yúñúhūn. De nī ncāhān ndá ji jíín dē: ¿A nsūú iin tēe scuáha jíín tēe ñúcuán cúu nú? De maá dē nduú ní ncáchī dē: Nsūú nduhū cúu, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ñúcuán de iin mozo sūtū cúñáhnú jā cúu táhán tēe jā ní jehndē Pedro sōho, nī ncāhān jíín dē: ¿A nsūú maá nú cúu jā ní jinī ni jíín dē inī huerto? ");
INSERT INTO mieNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","De Pedro nduú ní ncáchī tucu dē. De nī ncana-ni lohló. ");
INSERT INTO mieNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ñúcuán de nī nquee ndá dē jíín Jesús inī vehe Caifás, de cuāhān dē jíín yā palacio tēe nación Roma jā cúu gobernador. De ja cuācunijīn. De ndá nchivī hebreo nduú ní nquívi ji inī palacio, tácua mā stíví ji ley ji jā cáhān jā má quívi ji inī vehe nchivī jāá nsūú hebreo cúu. Chi tú súcuán de mā cūú cuxíní ji vico pascua jā coo quīvī téēn. ");
INSERT INTO mieNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ñúcuán de nī nquee Pilato, tēe cúu gobernador, nī ncāhān dē jíín ndá ji: ¿Nā cuāchi cáhān ndá nú sīquī tēe yáhá? ");
INSERT INTO mieNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","De nī ncāhān ji: Tú nsūú tēe nēhén cúu tēe yáhá, de mā quísiáha ndá sá dē nūū ní nícu, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","De nī ncāhān Pilato: Cuáhán ndá máá nú jíín dē, de sāhá ndāā nū sīquī dē jíín ley jā névāha ndá nú. De nī ncāhān ndá nchivī hebreo ñúcuán: Ndá sāán nchivī hebreo, nduú nā permiso jā cahnī sá ni iin nchivī. ");
INSERT INTO mieNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Súcuán nī ncāhān ndá ji tácua quee ndaā tūhun jā ní ncachī Jesús jā quīvi yā ndahá ndá tēe Roma de cahnī dē yā yīcā cruz. ");
INSERT INTO mieNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","De nī ndīvi Pilato inī palacio, de nī ncana dē jā ná quíji Jesús. De nī jīcā tūhún dē yā: ¿A maá nú cúu Rey nchivī hebreo, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","De nī ncāhān Jesús jíín dē: ¿A jícā tūhún nú nduhū jā súcuán jáni inī maá nú, á jā ní ncachī nchivī hebreo nūū nū? ");
INSERT INTO mieNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","De nī ncāhān Pilato: Nsūú tēe hebreo cúu nī jā cunī ni. Chi nchivī nación maá nú jíín ndá sūtū cúñáhnú nī nchihi ndá dē ndóhó ndahá nī. ¿Nā cuá cúu jā ní nsāhá nú túsaá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","De nī ncāhān Jesús: Nsūú jā tátúnī ni modo tá cúu nūū tátúnī ndá rey ñayīví yáhá. Chi tú jā nchivī ñayīví ní nsáhá jā cúu nī rey, ñúcuán de ndá tēe níquīn nduhū canāá dē tácua mā quívi nī ndahá ndá táhán nī hebreo nícu. Sochi nsūú nchivī ñayīví yáhá cúu jā tátúnī ni nūū mitan, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ñúcuán de nī ncāhān Pilato jíín yā: ¿De á iin rey cúu nú jā súcuán? De nī ncāhān Jesús: Rey cúu nī, tá cúu nūū cáhān nū. Nī nquiji nī nī ncacu nī inī ñayīví yáhá tácua nacani nī tūhun ndāā. De ndācá nchivī jā jétáhví tūhun ndāā, chi níni ji tūhun cáhān ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","De nī ncāhān Pilato: ¿Nāsa cunī ō ní iin cúu maá tūhun ndāā? ncachī dē. De tá nī ncāhān dē tūhun yáhá, de nī nquee tucu dē nūū nchivī hebreo. De nī ncāhān dē jíín ji: Nduú cuitī nā cuāchi níhīn ni sīquī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","De íyó costumbre ndá máá nú jā vico pascua de siáā ni iin tēe yíhí vecāa nūū nū. ¿De á nduú cúnī ndá nú jā siáā ni Rey ndá nú nchivī hebreo? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ñúcuán de ndiviī ji nī ncana jee tucu ji: Mā siáā ní tēe jīñā, chi Barrabás siáā ní, ncachī ji. De tēe cuíhná cúu Barrabás. ");
INSERT INTO mieNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ñúcuán de nī ncāhān Pilato jā ná tíin ndá soldado Jesús, de cani dē yā jíín cuarta ñii. ");
INSERT INTO mieNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","De nī nsāhá ndá dē iin corona iñu, de nī nchuhun dē xīnī yā. De nī nchuhun dē yā iin sahma cuahá ndíhí jā cúu sahma rey. ");
INSERT INTO mieNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","De nī jēcuīñī dē nūū yā, de nī ncāhān sācá ndá dē: Nācā vāha rey cúu Rey nchivī hebreo. De nī ncani ndá dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ñúcuán de nī nquee Pilato incā vuelta, de nī ncāhān dē jíín nchivī: Yáhá cūndēhé nú jā távā ni dē nūū ndá nú, tácua cunī nū jāá nduú nā cuāchi níhīn ni sīquī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","De nī nquee Jesús, ñúhún yā corona iñu jíín sahma cuahá ndíhí ñúcuán. De nī ncāhān Pilato jíín ji: Yáhá cūndēhé ndá nú nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","De tá nī jinī ndá sūtū cúñáhnú jíín ndá policía nūū yā, de nī ncana jee ndá dē: Cata caa ní dē yīcā cruz, ná cúū dē. De nī ncāhān Pilato: Túsaá de natiin ndá máá nú dē de cahnī nū dē. Chi nduhū nduú nā cuāchi níhīn ni sīquī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","De nī ncāhān ndá nchivī hebreo ñúcuán: Névāha ndá sá iin ley, de sīquī ley ñúcuán cánuú jā cuū dē, chi sáhá dē maá dē jā Sēhe Yāā Dios cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","De tá nī jini Pilato tūhun yáhá, de víhí cā nī nchūhú dē. ");
INSERT INTO mieNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","De nī ndīvi tucu dē inī palacio, de nī jīcā tūhún dē Jesús: ¿Ní jondē vāji nú? Sochi nduú ní ncáhān cuitī Jesús jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ñúcuán de nī ncāhān Pilato jíín yā: ¿Nūcu nduú cáhān nū jā cáhān ni? ¿A nduú jínī nū jā ndíso tíñú nī jā cahnī ni ndóhó yīcā cruz, de suni ndíso tíñú nī jā siáā ni ndóhó quīhīn nū? ");
INSERT INTO mieNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","De nī ncāhān Jesús: Tú nduú ní nsáhá Yāā Dios jā ndíso tíñú nú, de nduú nā cuá cuu sāhá nú sīquī ni. De jā ñúcuán cúu jā tēe jā ní nquisiáha nduhū nūū nū, xēēn cā coo cuāchi sīquī dē nsūú cā sīquī maá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","De sá de jondē hora ñúcuán de ndúcú ndéé Pilato jā siáā dē yā. Sochi ndá nchivī hebreo chi cána jee ji: Tú siáā ní tēe jīñā, túsaá de nduú cúu ní amigo rey Roma jā ndácu tiñu. Chi ndācá tēe jā sáhá dē rey maá dē, túsaá de cúu dē enemigo sīquī rey ñúcuán, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","De tá nī jini Pilato tūhun yáhá, de nī ndacu dē tiñu jā ná quée Jesús inī vehe quiji yā. De nī jēcundeē dē silla nūū cúndaā tiñu, nūū maá-ni yūū nī jēcāva, de lugar ñúcuán nání Gabata yuhú hebreo. ");
INSERT INTO mieNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","De cuacuu cahūxī ūū, de jañíni quīvī ñúcuán quijéhé vico pascua. De nī ncāhān Pilato jíín ndá nchivī hebreo: Yáhá íñí maá rey nū. ");
INSERT INTO mieNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","De nī ncana jee ji: Cata caa ní dē yīcā cruz, chi cánuú jā cuū dē, ncachī ji. De nī ncāhān Pilato jíín ji: ¿A jā cata caa nī rey nū yīcā cruz, á naá cúu? De nī ncāhān ndá sūtū cúñáhnú: Nduú nā incā rey névāha ndá sá, chi maá-ni rey Roma jā tátúnī nūū sá. ");
INSERT INTO mieNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ñúcuán de Pilato nī nacuāha dē yā nūū ndá ji jā ná cúū yā yīcā cruz. De nī ntiin ji Jesús cuāhān ji jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","De nī nquee Jesús, ndíso yā cruz yā, cuāhān ndá dē jíín yā iin lugar nūū nání Yiqui Xínī, de yuhú hebreo nání Gólgota. ");
INSERT INTO mieNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","De ñúcuán nī jata caa ndá dē yā yīcā cruz. De suni nī jata caa dē ūū tēe nūū ūū cā cruz, iin iin dē iin lado yā, de maá Jesús māhñú. ");
INSERT INTO mieNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","De suni nī ndacu Pilato jā ná cúndeē tūhun xīnī cruz yā, jā cáhān: Tēe yáhá cúu Jesús ñuū Nazaret, Rey nchivī hebreo, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","De cuāhā nchivī hebreo nī ncahvi ji tūhun yáhá, chi maá ñatin yuhú ñúū cúu nūū ní jata caa dē yā. De tūhun yáhá yósō jíín yuhú hebreo jíín griego jíín latín. ");
INSERT INTO mieNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","De ndá sūtū cúñáhnú nūū nchivī hebreo, nī ncāhān dē jíín Pilato: Mā tēé ní jā cúu dē Rey nchivī hebreo, chi sa tee ní jā maá dē nī ncāhān jā cúu dē Rey nchivī hebreo. ");
INSERT INTO mieNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","De nī ncāhān Pilato: Mā násāma nī jā ní ntatúnī ni jā cundeē. ");
INSERT INTO mieNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","De ndá soldado ñúcuán, tá nī ncuu nī jata caa dē Jesús yīcā cruz, de nī nquehen dē sahma yā, de nī jehndē dē nī nduu cūmī parte, de iin iin parte nī ncuu iin iin soldado. De suni nī nquehen dē camisa yā. De camisa ñúcuán nduú ní nquícu, chi nī ncunu níí. ");
INSERT INTO mieNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","De nī ncāhān ndá dē: Mā quéhndē ō, chi vāha cā ná sáhá ó suerte sīquī, de cúndēhé ó ní iin ó nīhīn, ncachī dē. De súcuán nī nquee ndaā tūhun yósō nūū tutū īī jondē janahán jā cāhān Jesús: Nī nquehen dē sahma nī cuu ndá máá dē. De nī nsāhá dē suerte sīquī camisa ni. Cáchī tutū. Súcuán cúu jā ní nsāhá ndá soldado ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","De ñatin nūū íyó cruz nūū ndíta caa Jesús íñí naná yā jíín cūhū ña María ñasíhí Cleofas, jíín María ñuū Magdala. ");
INSERT INTO mieNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","De nī ndēhé Jesús nūū naná yā jíín nūū tēe scuáha jíín yā jā mānī cā yā jíín, chi suni íñí dē ñúcuán. De nī ncāhān yā jíín naná yā: Naná, jondē mitan de maá dē nūcuīñī dē cuu dē sēhe ní. ");
INSERT INTO mieNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sá de nī ncāhān yā jíín tēe scuáha ñúcuán: Jondē mitan de cuu ña modo naná nú, ncachī yā. De jondē hora ñúcuán nī ncana dē ña jā cundeē ña vehe dē jā coto dē ña. ");
INSERT INTO mieNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ñúcuán de nī jinī Jesús jā ní jīnu ndācá tiñu jā cánuú cundoho yā. De tácua quee ndaā tūhun cáhān tutū īī, de nī ncāhān yā: Yíchī ni ndute, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","De ñúcuán íyó iin tīndōhō jā ñúhún chitú vinagre īyá. De nī nchundaji ndá dē iin cāchī nūū vinagre ñúcuán, de nī ntee dē xīnī iin ndahá ñutun hisopo, de nī ntee dē yuhú yā jā coho yā. ");
INSERT INTO mieNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","De tá nī jihi yā vinagre, de nī ncāhān yā: Ja nī jīnu, ncachī yā. De nī jēcuīta-ni xīnī yā, de nī jīhī yā-ni. ");
INSERT INTO mieNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","De quīvī téēn coo vico pascua. De ndá tēe hebreo nduú cúnī dē jā cundita caa ndá ndīyi ñúcuán yīcā cruz quīvī nátātú. Chi quīvī nátātú jā cúu vico pascua, īī ndasí cā nsūú cā ndá cā quīvī nátātú. De nī ncāhān dē jíín Pilato jā ná ndácu dē jā tāhnū sīhin ndá tēe ndíta caa, de ná cújiyo dē yīcā cruz. ");
INSERT INTO mieNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","De nī nquenda ndá soldado, de nī jāhnū dē sīhin iin tēe jā ndíta caa jíín yā, de saá-ni incā dē. ");
INSERT INTO mieNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","De tá nī nquenda ndá dē nūū Jesús, de nī jinī dē ja nī jīhī yā. Jā ñúcuán cúu jāá nduú ní jáhnū ndá dē sīhin yā. ");
INSERT INTO mieNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sochi iin soldado chi nī nquiní dē lanza yīcā yā, de nī nquee-ni nīñī jíín ndute. ");
INSERT INTO mieNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","De nduhū jā tée tutū yáhá, nī jinī ni jā súcuán nī ncuu, de nácani ndaā ni tūhun nāsa nī ncuu. De jínī ni jā íyó ndāā tūhun cáhān ni, tácua suni candíja ndá máá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Chi súcuán nī ncuu tácua quee ndaā tūhun jā cáhān tutū īī: Mā cáhnū dē ni iin yiqui yā, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","De suni incā tūhun cáhān tutū īī: Iin quīvī de cūndēhé ndá ji nūū Yāā jā ní nquiní ji lanza, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","De nī ncuu ndācá tiñu yáhá. De íyó iin tēe ñuū Arimatea jā nání José, de cúu dē tēe cándíja Jesús. Sochi cándíja yuhū dē, chi yúhú dē táhán dē hebreo. De nī ncāhān ndāhví dē jíín Pilato jā ná cuáha dē tūhun jā quehen dē yiqui cúñu Jesús. De nī jēhe Pilato tūhun. Ñúcuán de cuāhān José, de nī snúu dē yiqui cúñu Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","De suni nī nquenda Nicodemo, tēe jā ní nquiji nūū Jesús iin jacuáā. De ndíso dē tá ōcō ūxī kilo sūja ūguā jā ní nsacā nuu jíín yūcū áloe. ");
INSERT INTO mieNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","De ndúū dē nī nquehen dē yiqui cúñu Jesús, de nī nchusúcún dē jíín tira sahma jā ní nquīvi yūcū jā jéhēn āsīn ñúcuán, tá cúu nūū íyó costumbre maá nchivī hebreo jā chúhū ji ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","De ñatin nūū ní jīhī Jesús íyó iin huerto. De nūū huerto ñúcuán ndéē iin yavī jā ní ncaān jeé yīcā iin cava, nūū ncháha ca quiyuhū ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","De ñúcuán nī nchiyuhū ndá dē Jesús, chi íyó ñatin yavī ndīyi ñúcuán. Chi ja ñatin quijéhé quīvī nátātú dē jā cúu dē nchivī hebreo, de cáhān ley jā má cūú chiyuhū dē ndīyi tá quíjéhé quīvī ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","De jānehēn quīvī domingo nī nquenda María ñuū Magdala nūū ní nchiyuhū Jesús, de cáta yíneē cā. De nī jinī ña jā ní ncujiyo yūū jā ndásī yuhú yávī ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ñúcuán de jínu ña cuāhān ña nūū Simón Pedro jíín nūū incā tēe scuáha jā ní īyo mānī cā Jesús jíín. De nī ncāhān ña jíín dē: Nī ntavā ndá dē Jētohō ō nūū ní nchiyuhū yā, de nduú jínī ō ní cúu nūū ní jēchūhun dē yā, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","De nī nquee Pedro jíín incā tēe ñúcuán, cuāhān ndúū dē cuāndēhé dē yavī ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","De jínu iin ncáá ndúū dē. De incā tēe scuáha ñúcuán, nīhin cā nī jinu dē nsūú cā Pedro. De xihna cā dē nī nquenda yavī ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","De nī jaquīn núū dē, nī ndēhé dē inī yavī. De nī jinī dē jā ndá tira sahma cáá maá-ni cā. Sochi nduú ní nquívi dē. ");
INSERT INTO mieNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","De sá de nī nquenda Simón Pedro jā níquīn dē vāji dē. De nī nquīvi dē nūū ní nchiyuhū Jesús. De suni nī jinī dē jā tira sahma cáá maá-ni cā. ");
INSERT INTO mieNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","De nī jinī dē sahma jā ní ñusúcún xīnī Jesús, nduú cáá jíín tira sahma, chi nī natuū de cáá síín. ");
INSERT INTO mieNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ñúcuán de suni nī nquīvi incā tēe scuáha jā ní nquenda xihna cā nūū ní nchiyuhū yā. De nī jinī dē nāsa íyó, de nī ncandíja dē jā ní natecū yā. ");
INSERT INTO mieNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Chi tá ncháha ca quenda dē yavī ndīyi, de nduú ní jícūhun inī dē tūhun cáhān tutū īī, jā cánuú natecū yā tá ja nī jīhī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ñúcuán de ndúū tēe scuáha ñúcuán, cuānohōn dē vehe dē. ");
INSERT INTO mieNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","De María íñí ña jácu ña nūū ní nchiyuhū yā. De juni jácu ña, de nī jaquīn núū ña, nī ndēhé ña inī yavī ndīyi. ");
INSERT INTO mieNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","De nī jinī ña ūū ángel, ñúhún yā sahma cuijín. De iin yā ndéē ichi xínī, de incā yā ndéē ichi nūū jéhē nūū ní ncāa yiqui cúñu Jesús. ");
INSERT INTO mieNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","De nī ncāhān yā jíín ña: Tíhī, ¿nūcu jácu nú? De nī ncāhān ña: Nī ntavā ndá dē Jētohō sá, de nduú jínī sá ní cúu nūū ní jēchūhun dē yā. ");
INSERT INTO mieNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","De tá nī ncāhān ña súcuán, de nī ndicó cóto ña, de nī jinī ña nūū Jesús jā íñí yā ñúcuán. Sochi nduú ní nácunī ña jā maá yā cúu. ");
INSERT INTO mieNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","De nī ncāhān yā jíín ña: Tíhī, ¿nūcu jácu nú? ¿Ní iin nánducú nú? ncachī yā. De maá ña jáni inī ña jā tēe jíto huerto cúu yā. De nī ncāhān ña jíín yā: Señor, de tú maá ní nī nsāhá jíyo ní yā, de cachī ní ní cúu nūū ní nchuhun ní yā, de ná quínāquēhen sá yā, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","De nī ncāhān Jesús jíín ña: María, ncachī yā. De tá nī ncāhān yā súcuán, de nī nacunī ña yā, de nī ndicó cóto ña, de nī ncāhān ña jíín yuhú hebreo: Raboni, ncachī ña. De tūhun ñúcuán cáhān: Maestro. ");
INSERT INTO mieNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","De nī ncāhān Jesús jíín ña: Mā quēhé nú nduhū, chi ncháha ca ndaa nī quīnohōn ni nūū Tatá nī. De cuáhán nūū ndá hermano ni, tēe nī scuáha jíín nī, de cachī nū nūū dē jā ndaa nī quīnohōn ni nūū Tatá nī, jā suni Tatá ndá máá nú cúu. De cúu yā Yāā Dios maá nī jíín Yāā Dios ndá máá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ñúcuán de María ñuū Magdala, cuāhān ña, de nī ncachī tūhun ña nūū ndá tēe scuáha jā ní jinī ña nūū maá Jētohō ō jíín jā ní ncāhān yā ndá tūhun yáhá jíín ña. ");
INSERT INTO mieNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","De jā ní ncuaā maá quīvī domingo ñúcuán, de íñí tútú ndá tēe scuáha inī iin vehe. De ndásī viéhé, chi yúhú ndá dē ndá táhán dē hebreo jā cunī ūhvī ji dē. De nī nquenda-ni Jesús, nī jēcuīñī yā māhñú ndá dē, vísō ndásī viéhé, de nī ncāhān yā jíín dē: Coo ndeé coo siī inī ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","De tá nī ncāhān yā súcuán, de nī stéhēn yā ndahá yā jíín yīcā yā nūū ndá tēe scuáha. De nī ncusiī inī ndá dē jā ní jinī dē nūū maá Jētohō ō. ");
INSERT INTO mieNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ñúcuán de nī ncāhān tucu Jesús: Coo ndeé coo siī inī ndá nú. De tá cúu nūū ní ntají Tatá nī nduhū inī ñayīví, suni súcuán tají nī ndá ndóhó nacani nú tūhun nī nūū nchivī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ñúcuán de nī ntivī tāchí yā nūū ndá dē. De nī ncāhān yā: Mitan de nī nīhīn ndá nú Espíritu Santo. ");
INSERT INTO mieNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","De ndācá nchivī jā cune cáhnú inī nū nūū cuáchi ji, túsaá de coo tūhun cáhnú inī nūū cuáchi ji. De tú mā cúne cáhnú inī nū nūū cuáchi ji, de mā cōó tūhun cáhnú inī nūū cuáchi ji, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","De Tomás, tēe jā ní ncacu cuátī, iin táhān jā úxī ūū tēe scuáha jíín yā, nduú ní íyo dē quīvī jā ní nenda nijīn Jesús nūū ndá cā tēe scuáha. ");
INSERT INTO mieNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ñúcuán de sava cā ndá tēe scuáha, nī ncāhān dē jíín Tomás: Nī jinī ndá nī nūū maá Jētohō ō. De nī ncāhān Tomás: Tú mā cūní nī nūū ní ntacuēhé ndahá yā nī nsāhá ndūyu cāa, de tú mā chīhí nī xīnī ndāhá nī nūū ní nchīhi ndūyu cāa, de tú mā chīhí nī ndahá nī yīcā yā, de mā cándíja cuitī ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","De nūū únā quīvī, de ndá tēe scuáha íyó tútú tucu dē inī iin vehe. De íyó Tomás jíín dē. Ñúcuán de nī nquenda tucu Jesús, nī jēcuīñī yā māhñú ndá dē, vísō ndásī viéhé. De nī ncāhān yā jíín dē: Coo ndeé coo siī inī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","De nī ncāhān yā-ni jíín Tomás: Chihi xīnī ndāhá nú inī ndahá nī yáhá de cunī nū. De chihi nú ndahá nú yīcā ni nūū ní ntacuēhé. De mā cāní síquí cā inī nū, chi sa candíja nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ñúcuán de nī ncāhān Tomás jíín yā: Aī, Jētohō maá sá jíín Yāā Dios maá sá cúu ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","De nī ncāhān Jesús jíín dē: Tomás, jondē nī jinī nū nduhū, de nī ncandíja nú. De nācā ndetū ndá nchivī jā candíja ji nduhū vísō nduú ní jínī ji nduhū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","De suni nī nsāhá Jesús cuāhā cā tiñu ñáhnú jā ní stéhēn yā poder yā nūū ndá tēe scuáha jíín yā, jāá nduú yósō nūū tutū yáhá. ");
INSERT INTO mieNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sochi ndá tiñu yáhá nī ntee nī tácua candíja ndá nú jā Jesús cúu Cristo, maá Sēhe Yāā Dios. De jā candíja nú yā, de cutecū nū níí cání sāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","De nī ncuu jacū quīvī, de incā vuelta nī nenda Jesús nūū ndá tēe scuáha jíín yā, jā íyó dē yuhú mar Tiberias. De súcuán cúu jā ní stéhēn yā maá yā nūū dē: ");
INSERT INTO mieNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Iyó tútú Simón Pedro, jíín Tomás, tēe nī ncacu cuátī, jíín Natanael, tēe ñuū Caná ndáñúū Galilea, jíín ndúū sēhe Zebedeo, jíín ūū cā tēe scuáha. ");
INSERT INTO mieNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","De nī ncāhān Simón Pedro jíín ndá dē: Ná quítīin nī tiacá. De nī ncāhān ndá dē: Suni cōhōn jíín nú. De cuāhān ndá dē, de nī nquīvi dē iin barco. Sochi nduú ní níhīn cuitī ndá dē tī jacuáā ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","De tá cuācunijīn, de íñí Jesús yuhú mar. Sochi ndá tēe scuáha, nduú ní nácunī dē jā maá yā cúu. ");
INSERT INTO mieNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ñúcuán de nī ncāhān yā jíín ndá dē: Lílū, ¿á nī nīhīn ndá nú tiacá cajī ō? Nduú cuitī, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ñúcuán de nī ncāhān yā jíín dē: Chuhun ñunu nú ichi lado cuáhá barco, de nīhīn nū tī. De nī nchuhun ndá dē ñunu, de nduú cā ní ncúu cuitī natavā dē, jā ní nquīvi cuāhā ndasí tiacá. ");
INSERT INTO mieNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ñúcuán de tēe scuáha jā mānī cā Jesús jíín, nī ncāhān dē jíín Pedro: Maá Jētohō ō cúu tēe jā ní ncāhān ō jíín, ncachī dē. De tá nī jini Simón Pedro jā maá Jētohō ō cúu, de nī nūcūhun dē sahma dē, chi nī ntavā dē jā sátíñú dē. De nī ndava dē-ni nūū mar, cuāhān dē nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","De ndá cā tēe scuáha ñúcuán, vāji dē jíín barco yuhú ndúté, stáá dē ñunu ñúhún chitú tiacá. Chi nduú jícá íyó dē jíín ñuhun yíchí, chi tá ciento-ni metro cúu. ");
INSERT INTO mieNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","De tá nī nquee ndá dē inī barco, de nī jinī dē jā ndúhā tīcāyi ñuhūn, de cáá stāā jíín iin tiacá jā ní nchohō. ");
INSERT INTO mieNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","De nī ncāhān Jesús jíín ndá dē: Cuáquēhen ndá nú jacū tiacá jā cáta ntiin nú, ná scásūn ō, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","De nī nquīvi Simón Pedro inī barco, de nī stáá dē ñunu, nī nquenda dē jíín nūū ñuhun yíchí. De ñúhún chitú tiacá náhnú, iin ciento ūū xico ūxī ūnī tī cúu. De vísō iin súcuán tī ñúhún, de nduú ní ntéhndē ñunu. ");
INSERT INTO mieNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","De nī ncāhān Jesús jíín ndá dē: Nehēn ndá nú ná cájī ō stāā. De ni iin ndá tēe scuáha ñúcuán nduú ní ncúndeé inī dē jā cātūhún dē yā tú ní iin cúu yā. Chi ja jínī ndá dē jā maá Jētohō ō cúu yā. ");
INSERT INTO mieNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","De nī ntandeē Jesús yuhú ñúhūn, de nī nquehen yā stāā, de nī jēhe yā nūū ndá dē, de saá-ni tiacá. ");
INSERT INTO mieNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yáhá cúu vuelta ūnī jā ní nenda Jesús nūū ndá tēe scuáha jíín yā, tá nī natecū yā. ");
INSERT INTO mieNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","De tá nī ncuu nī nchasī inī dē, de Jesús nī jīcā tūhún yā Simón Pedro: Simón sēhe Jonás, ¿á mānī cā nū jíín nī nsūú cā ndá cā tēe yáhá? De nī ncāhān dē: Señor, ja jínī ní jā mānī sá jíín ní. De nī ncāhān yā jíín dē: Túsaá de coto nú ndá nchivī cúu tá cúu tīcāchí lúlí nī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","De nī jīcā tūhún yā dē vuelta ūū: Simón sēhe Jonás, ¿á mānī nū jíín nī? De nī ncāhān dē jíín yā: Ja jínī ní jā mānī sá jíín ní. De nī ncāhān yā: Coto nú ndá nchivī cúu tá cúu tīcāchí nī túsaá. ");
INSERT INTO mieNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","De nī jīcā tūhún tucu yā dē vuelta ūnī: Simón sēhe Jonás, ¿á mānī nū jíín nī? De nī ncucuécá inī Pedro jā ní jīcā tūhún yā dē vuelta ūnī tú mānī dē jíín yā. De nī ncāhān dē: Maá ní jínī ní ndihi, de jínī ní jā mānī sá jíín ní, Señor. De nī ncāhān yā: Túsaá de coto nú ndá nchivī cúu tá cúu tīcāchí nī. ");
INSERT INTO mieNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","De jāndáā cáhān ni jíín nú jā jondē tá suchí nú de nī nquehen maá nú sahma nú, de nī jica nú ní jondē nī ncuu inī maá nú. Sochi tá yii nú, de nsūú jā cúu inī maá nú, chi incā nchivī cueca ji ndóhó nūū nduú cúu inī nū quīhīn nū, de scáā nū ndúū ndahá nú jā cuū nū. ");
INSERT INTO mieNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tūhun yáhá nī ncāhān yā jā ní stéhēn yā jā cundita caa dē yīcā cruz cuū dē, de jā súcuán cuetáhví dē cúu jā stéhēn dē jā cúñáhnú ndasí Yāā Dios. Ñúcuán de nī ncāhān cā yā: Cuniquīn nduhū jā sāhá nú tiñu nī ndacu nī nūū nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","De nī jicó cóto Pedro, de nī jinī dē nūū tēe scuáha jā mānī cā Jesús jíín, níquīn dē vāji dē yātā. Tēe ñúcuán cúu jā ní ndeē xiín Jesús tá nī ncuxíní ndá dē jíín yā, de nī jīcā tūhún dē yā: Señor, ¿ní iin dē cúu jā nastúu dē níhín? ");
INSERT INTO mieNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","De jā ní jinī Pedro nūū tēe ñúcuán, de nī jīcā tūhún dē Jesús: Señor, ¿de tēe yáhá, nāsa coo dē? ");
INSERT INTO mieNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","De nī ncāhān Jesús: Tú cúnī ni jā cutecū dē jondē quīvī nenda nī, de ndóhó mā cúndihvī inī nū. Maá nú chi cuniquīn nū nduhū jā sāhá nú tiñu nī ndacu nī nūū nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ñúcuán de tūhun yáhá nī jītē nuu nūū ndācá hermano, jā tēe scuáha ñúcuán mā cúū dē. Sochi nduú ní ncáhān Jesús jā má cúū dē, chi sa nī ncāhān yā: Tú cúnī ni jā cutecū dē jondē quīvī nenda nī, de ndóhó mā cúndihvī inī nū. ");
INSERT INTO mieNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","De tēe scuáha ñúcuán jā mānī cā Jesús jíín, suu cúu nduhū jā nácani tūhun ndācá tiñu yáhá, de suu nī tée ndācá tūhun yáhá. De jínī ndá nú jā íyó ndāā tūhun nácani nī. ");
INSERT INTO mieNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","De suni íyó cuāhā ndasí cā tiñu jā ní nsāhá Jesús. De tú tee ó tá iin tá iin, de mā quēndá níí ñayīví jā cuhun tutū jā cosō tūhun ñúcuán, jáni inī ni. De nī ncuu. Amén.");
INSERT INTO mieNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Señor Teófilo, nūū tútū jā ní ntee sá jā xíhna ñúhún, nī ntee sá ndācá tiñu jā ní nsāhá Jesús jíín ndācá tūhun jā ní stéhēn yā jondē quīvī jā ní nquijéhé yā sáhá yā ");
INSERT INTO mieNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","jíín jondē quīvī jā ní ndaa yā cuānohōn yā andiví. De tá ncháha ca ndaa yā quīhīn yā de quīvī ñúcuán de nī nsāhá Espíritu Santo jā ní ndacu Jesús nūū ndá apóstol jā ní nacāji yā. ");
INSERT INTO mieNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","De tá nī jīnu nī ndoho yā nī jīhī yā, de sá de nī nenda yā técū yā nūū ndá tēe ñúcuán, de quéhén vuelta nī jinī ndá dē jā técū ndija yā. Chi ūū xico quīvī nī stéhēn nijīn yā maá yā nūū ndá dē, de nī ncāhān yā jíín ndá dē nāsa tátúnī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","De juni íyó tútú ndá dē de nī ncāhān yā: Mā quēé ndá nú ciudad Jerusalén, chi cundetu nú jondē quiji Espíritu Santo jā ní nquee yuhú maá Tatá nī Yāā Dios. De ja nī jini ndá nú jā súcuán nī ncāhān ni jíín nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","De Juan chi jāndáā jā ndute-ni nī scuénduté dē nchivī. De ndá ndóhó chi jacū-ni cā quīvī de cuāha nī Espíritu Santo cundeē inī ndá nú, de ñúcuán cúu modo jā scuénduté nī ndá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ñúcuán de ndá apóstol jā ní ndutútú dē nūū Jesús, nī jīcā tūhún dē yā: Señor, ¿á jondē mitan de nasāhá ñáhnú ní nchivī nación maá ó Israel jā tatúnī nūū nación maá ó, á naá cúu? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","De nī ncāhān yā: Mā cūú cunī nū quīvī á cuīyā jā ní jani maá Tatá nī, chi mátúhún maá yā-ni cúu Yāā jā cúñáhnú ndasí jā cuu sāhá ndāā vāha sīquī ndācá tiñu yáhá. ");
INSERT INTO mieNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sochi tá ja nī nquīvi Espíritu Santo inī ánō nū, sá de nīhīn nū poder yā, de nacani nú tūhun nī nūū ndá nchivī ciudad Jerusalén jíín níí Judea jíín níí Samaria jíín jondē níí cáhnú ñayīví, ncachī yā jíín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","De tá nī ncuu nī ncāhān yā ndācá tūhun yáhá, de juni ndéhé ndá dē de nī ndaa yā-ni cuānohōn yā andiví. De nī nquiji-ni iin vīcō, de nī jasī-ni nūū cuáhān yā, de nduú cā ní jínī ndá dē yā. ");
INSERT INTO mieNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","De juni ndéhé ndá dē andiví nūū ní ndaa yā cuāhān yā, de nī nquenda-ni ūū ángel yā jā ñúhún yā sahma cuijín de cáá yā tá cáá tēe. De nī jēcuīñī ndeē yā xiín ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","De nī ncāhān yā jíín ndá dē: Ndá ndóhó tēe Galilea, ¿nūcu ndéhé ndá nú ichi andiví? Chi Yāā Dios nī nacueca yā maá Jesús cuānohōn yā andiví, de suni súcuán ndiji tucu yā tá cúu nūū ndéhé ndá nú mitan jā cuáhān yā, ncachī ndúū ángel. ");
INSERT INTO mieNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ñúcuán de nī nuu ndá dē lómō jā nání Olivos cuānohōn ndá dē ciudad Jerusalén. De ñatin-ni íyó lómō ñúcuán jíín Jerusalén, chi née tá iin kilómetro, jā cúu medida jā cáhān ley tá cuu caca nchivī quīvī nátātú. ");
INSERT INTO mieNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","De nī nenda ndá dē ciudad, de nī ndaa ndá dē cuarto xīnī vēhé nūū ndéē nūú dē. De cúu ndá dē Pedro jíín Jacobo jíín Juan jíín Andrés jíín Felipe jíín Tomás jíín Bartolomé jíín Mateo jíín Jacobo sēhe Alfeo, jíín Simón táhán grupo jā nání cananista, jíín Judas ñanī Jacobo. ");
INSERT INTO mieNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","De níní ndútútú inuú ndá dē jíín ndá ñanī Jesús, jíín María jā cúu naná yā, jíín ndá cā ñahan, de inuú-ni jícān táhvī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","De iin quīvī de nī nacuiñī Pedro nūū ndá hermano cándíja. De íyó tá ciento ōcō nchivī jā ní ndutútú. De nī ncāhān dē: ");
INSERT INTO mieNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Mitan de cáchī tūhun nī, hermano, jā níní nī nquee ndaā tūhun jā yósō nūū tutū īī jā ní ncāhān David jondē janahán nī nsāhá Espíritu Santo. De tūhun ñúcuán cúu tūhun Judas, tēe jā ní nchosō nūú nūū ndá tēe jā ní ntiin Jesús. ");
INSERT INTO mieNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","De Judas chi suni táhán ó nī ncuu dē nícu, de nī nchindeé táhán ó jíín dē sīquī tiñu jā ní jani yā yóhó. ");
INSERT INTO mieNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","De nī jeen dē ñuhun jíín xūhún jā ní nīhīn dē sīquī tiñu néhén jā ní nsāhá dē. De nī nincava ndeyi dē, de nī ncahndī-ni chījin dē, de nī jītē-ni jitī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","De nī jītē nuu-ni tūhun yáhá nūū ndācá nchivī Jerusalén. De jā suu cúu jā ní scúnaní ndá ji ñuhun ñúcuán Acéldama yuhú maá ji, jā cáhān: Ñuhun jā cúu Ñuhun Nīñī. ");
INSERT INTO mieNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Chi súcuán cáhān nūū tutū Salmo sīquī Judas: Vehe dē, ná quéndōo súcuán-ni, de ni iin mā cúndeē cā vehe ñúcuán. De suni cáhān: Tiñu jā ní ndiso dē ná nácuiso incā tēe. Cáchī. ");
INSERT INTO mieNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Túsaá de cúnī jā nacāji ó iin tēe māhñú ndá tēe jā ní jica ó jíín níí tiempo tá nī jica maá Jētohō ō Jesús jíín ó. ");
INSERT INTO mieNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","De ná nácāji ó iin tēe jā ní jica jíín ó jondē quīvī jā ní scuénduté Juan yā, de jondē quīvī jā ní ndaa yā cuānohōn yā andiví. De ná núcuīñī dē cuu dē testigo jíín ndācá ó jā ní natecū yā, ncachī Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","De nī nacāji ndá dē ūū tēe jā cúu Matías jíín José jā nání Barsabás, de suni nání dē Justo. ");
INSERT INTO mieNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","De nī jīcān táhvī ndá nchivī cándíja: Tátā Yāā Dios, maá ní chi jínī ní nāsa íyó ánō ndá nchivī. Túsaá de jā ndúū tēe yáhá, stéhēn ní ní tēe cúu jā ní nacāji ní. ");
INSERT INTO mieNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","De cuiso tíñú dē jā cuu dē apóstol. De nacuiso dē tiñu jā ní sndóo Judas, chi nī nsāhá dē cuāchi, de cuāhān dē maá lugar xēēn nūū cánuú quīhīn dē, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ñúcuán de nī ntavā ndá dē suerte ndúū tēe ñúcuán. De nī nquee suerte Matías, de nī ncuu dē iin táhán ndihúxī iin cā apóstol. ");
INSERT INTO mieNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","De quīvī vico Pentecostés nī īyo tútú ndá nchivī cándíja ciudad Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","De sanaā-ni de nī nihin andiví modo jā yíhí ndasí tāchī. De ndá nchivī jā ndéē inī vehe, nī jini ndá ji jā níhin. ");
INSERT INTO mieNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","De nī jinī ndá ji modo yáñuhūn, de nī ncusíín jacū jacū nī jēcōo xīnī iin iin ji. ");
INSERT INTO mieNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","De ndācá ji nī nchitú inī ji jíín Espíritu Santo. De nī nquijéhé ndá ji cáhān ji síín síín yuhú, nāsa nī stéhēn maá Espíritu Santo jā cāhān iin iin ji. ");
INSERT INTO mieNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","De Jerusalén íyó ndá nchivī hebreo jā chíñúhún nūū Yāā Dios jā ní nquiji ndá ji ndācá nación níí cáhnú ñayīví. ");
INSERT INTO mieNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","De jā ní nihin súcuán de nī ncutútú cuāhā nchivī ñúcuán. De nī ncunēhén inī ndá ji, chi iin iin ji nī jini ji jā ndá tēe jā ní nīhīn Espíritu Santo cáhān yuhú ñúū ndá nchivī jā váji jícá. ");
INSERT INTO mieNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","De nī nsāhvi inī ndá ji nī jini ji, de nī ncāhān ji: ¿A nsūú tēe Galilea cúu ndācá tēe yáhá jā cáhān ndá dē yuhú ñúū ō, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿De nāsa cúu túsaá? Chi tá iin tá iin ó níni ó jā cáhān ndá dē yuhú ñúū ō jā ní ncacu ó jíín. ");
INSERT INTO mieNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Chi vāji sava ó jondē región Partia jíín Media jíín Elam. De sava ó vāji ó jondē región Mesopotamia jíín Judea jíín Capadocia jíín Ponto jíín Asia. ");
INSERT INTO mieNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","De suni jondē región Frigia jíín Panfilia jíín Egipto jíín ndācá ndáñúū Africa jā íyó incā lado ñuū Cirene vāji sava ó. De sava cā ō vāji ó jondē ciudad Roma, de ndéē nūú ó yáhá mitan. De maá ó jā váji ó ciudad Roma, de sava ó cúu nchivī hebreo de sava ó cúu incā nchivī jā ní ncandíja ley nchivī hebreo. ");
INSERT INTO mieNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","De suni sava cā ō vāji ó región Creta jíín Arabia. De níni ndācá ó jā yuhú ñúū ō nácani ndá tēe yáhá ndācá tiñu ñáhnú nāsa nī nsāhá Yāā Dios, ncachī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","De ndācá ji sáhvi ndasí inī ji de cúnēhén inī ji ndéhé ji. De nátúhún ndá ji jíín táhán ji: ¿De nāsa cúu cáhān ndá dē ndá ñúcuán túsaá? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","De sava cā ji nī ncāhān yīchī ji jíín táhán ji: Nduú chi jā jíni ndá dē, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ñúcuán de nī nacuiñī Pedro jíín ndihúxī iin cā apóstol. De nī ncāhān jee dē jíín ndá nchivī: Ndá ní táhán maá ó hebreo jíín ndá ní nchivī Jerusalén, tūhun yáhá chuhun inī ndá ní de cunini vāha ndá ní tūhun jā cāhān sá. ");
INSERT INTO mieNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Chi ndá sāán, nsūú jā jíni ndá sá tá cúu nūū jáni inī ndá ní. Chi nsūú hora jā jīni nchivī cúu, chi cáta cahīīn jānehēn cúu. ");
INSERT INTO mieNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Chi sa tiñu yáhá cúu jā squíncuu tá cúu nūū ní ncāhān Joel, tēe nī nacani tūhun Yāā Dios jondē janahán. Chi súcuán nī ncāhān dē: ");
INSERT INTO mieNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Cáchī Yāā Dios: Ndá quīvī sándīhí de tetíñú nī Espíritu ni cuēē nūū ndācá nchivī. De sēhe yií nú jíín sēhe síhí nú, nacani ndá ji tūhun nī. De ndá tēe suchí, chi sāhá nī jā scóto nūū ji, de ndá tēe ñáhnú, chi scóto jāni nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","De jāndáā chi ndá quīvī ñúcuán de cuāha vāha nī Espíritu ni nūū ndá mozo ni, cúu tēe cúu ñahan, de nacani ndá ji tūhun nī. ");
INSERT INTO mieNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","De sāhá nī tiñu ñáhnú ichi andiví jā sāhvi inī nchivī cunī ji, de suni sāhá nī seña inī ñayīví de cunī nchivī jā cúñáhnú nī, chi coo nīñī jíín ñuhūn jíín ñūhmā modo vīcō. ");
INSERT INTO mieNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","De ncandiī chi cutuún de mā cútūu cā, de yōō cucuáhá modo nīñī. De ñúcuán de quenda quīvī jā nenda maá Jētohō ndá nú Jesús. De cunī ndācá nchivī jā quīvī cāhnú cuu quīvī ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","De ndācá nchivī jā cāhān ndāhví ji jíín yā, chi scácu yā ji, ncachī Yāā Dios. Ncachī Joel jondē janahán. ");
INSERT INTO mieNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","De nī ncāhān cā Pedro: Mitan de ndá ní nchivī nación maá ó Israel, cunini ní jā cāhān sá tūhun Jesús, tēe ñuū Nazaret. Chi maá Yāā Dios nī jēhe yā poder yā nūū Jesús jā ní nsāhá yā ndá tiñu ñáhnú māhñú ndá ní jíín tiñu jā stéhēn jā íyó poder yā, jíín tiñu jā sáhvi inī nchivī sáhá, tá cúu nūū ní jinī ndá ní jā súcuán nī ncuu. Súcuán nī stéhēn Yāā Dios nūū ō jā maá yā nī ntetíñú Jesús. ");
INSERT INTO mieNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Sochi nī ntiin ndá ní yā, de nī nasiáha ndá ní yā ndahá ndá tēe nēhén. De nī jahnī ndá dē yā yīcā cruz nī nsāhá ndá ní. De ja nī jinī Yāā Dios jā súcuán sāhá ndá ní, chi ja nī nsāhá ndāā yā jā súcuán coo. ");
INSERT INTO mieNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sochi nī nastécū Yāā Dios Jesús, de nduú ní ncúu cā yā ndīyi, chi tūndóhó xéēn jā jíhī nchivī, nduú cā ní ncúu sāhá jíín yā. ");
INSERT INTO mieNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chi jondē janahán de nī ntee rey David tūhun nāsa cāhān Jesús jíín Yāā Dios: Jētohō sá, jínī sá jā níí cání íyó ní jíín sá. Chi íyó ní lado cuáhá sá jā chíndeé ní sāán, tácua mā cúyūhú sá. ");
INSERT INTO mieNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jā ñúcuán cúu jā cúsiī inī sá, de cáhān sīī sá. De suni ñúhún inī sá jā nastécū maá ní yiqui cúñu sá. ");
INSERT INTO mieNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Chi mā squéndōo ní ánō sá nūū íyó ánō ndá ndīyi, de ni mā cuáha ní tūhun jā tēhyū sá, chi sáhá sá tiñu jā cúnī maá ní de íyó mānī ní jíín sāán. ");
INSERT INTO mieNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nī stéhēn ní nūū sá nāsa natecū sá de sāhá ní jā cusiī ndasí inī sá sīquī jā cundeē sá jíín ní níí cání. Cachī Jesús, ncachī David jondē janahán. ");
INSERT INTO mieNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ndá ní amigo, ná cáchī cājí sá nūū ndá ní tūhun tatā ō David, tēe nī ncuñáhnú jondē janahán, chi nduú ní ncáhān dē ndá tūhun yáhá sīquī maá dē. Chi nī jīhī dē, de nī jīquiyuhū dē. De jínī ō nūū yíyuhū dē jondē mitan. ");
INSERT INTO mieNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Chi nī ncuu dē tēe nī nacani tūhun Yāā Dios jondē janahán. De nī jinī dē jā ní ncāhān téyíí yā jíín dē jā chījin tatā maá dē quiji Cristo, de cundeē yā tatúnī yā nūū mesa dē tá-ni nī ntatúnī maá dē jā ní ncuu dē rey. ");
INSERT INTO mieNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jondē tá ncháha ca quiji Cristo, de ja nī jinī dē jā cuū yā de natecū yā. De nī ncachī dē jā má quéndōo ánō yā nūū íyó ánō ndá ndīyi, de juni yiqui cúñu yā mā téhyū. ");
INSERT INTO mieNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Chi Yāā Dios nī nastécū yā Jesús, de ndá máá sá cúu testigo jā súcuán nī ncuu jā ní natecū yā. ");
INSERT INTO mieNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","De nī nduñáhnú tucu yā nī nsāhá Yāā Dios jíín poder yā. De nī jēhe Tatá yā Yāā Dios tūhun jā tetíñú Jesús Espíritu Santo, chi súcuán nī nquee yuhú yā jā sāhá yā. De suu Espíritu Santo ñúcuán cúu jā sáhá ndācá jā ndéhé ndá ní de níni ní mitan. ");
INSERT INTO mieNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","De David nsūú tūhun maá dē cúu jā ní ncāhān dē, chi nduú ní ndáa yiqui cúñu dē andiví. Chi sa tūhun Jesús nī ncāhān dē jā cáhān súcuán: Maá Jētohō ō Yāā Dios nī ncāhān yā jíín Jētohō ni, Yāā jā quiji: Cundeē nū lado cuáhá nī nūū cuñáhnú nú, ");
INSERT INTO mieNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","de ná sáhá nī jā candeē nū poder ndācá jā jínī ūhvī ndóhó, ncachī Yāā Dios jíín Cristo. Ncachī David. ");
INSERT INTO mieNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Túsaá de ndācá ní jā cúu ó tatā Israel, ná cúnī ndāā ní jā vísō nī jahnī ndá ní yā yīcā cruz, sochi Yāā Dios nī jani yā maá Jesús jā cúu yā Jētohō ō de suni cúu yā Cristo, Yāā jā scácu yóhó, ncachī Pedro jíín nchivī. ");
INSERT INTO mieNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","De súcuán nī jini ndá ji tūhun yáhá, de nī ntahúhvī inī ndá ji. De nī ncāhān ndá ji jíín Pedro jíín ndá cā apóstol: Ndá ní amigo, cachī ní ¿nāsa sāhá ndá sá túsaá? ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","De nī ncāhān Pedro: Nacani inī ndá ní jā sndóo ní cuāchi ní, de cuenduté ndá ní jā ní ncandíja ní Jesucristo, tácua cune cáhnú inī Yāā Dios nūū cuáchi ní. De ñúcuán de taji yā Espíritu Santo yā cundeē inī ánō ndá ní. ");
INSERT INTO mieNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Chi súcuán nī nquee yuhú maá Tátā Yāā Dios nūū ndá máá ó jíín nūū séhe ó jíín nūū ndá nchivī ndá cā nación, nā-ni nchivī cana yā jā candíja ji. ");
INSERT INTO mieNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","De cuāhā cā tūhun nī ncāhān cājí Pedro jā sndíhvī inī dē ndá ji: Nducú ndéé ndá ní jā ná cácu ní, chi ndá nchivī sáhá tiñu néhén chi tānū tāhvī ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ñúcuán de sava ji nī jetáhví ji tūhun jā ní ncāhān dē, de nī jenduté ndá ji. De quīvī ñúcuán nī ncucuahā cā nchivī cándíja, chi nī ncuu tá ūnī cā mil ji. ");
INSERT INTO mieNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","De íñí nīhin ndá ji sīquī tūhun jā stéhēn ndá apóstol, de íyó ñuncúún ndá ji, de jícān táhvī ndá ji. De yájī cāhnú ndá ji stātílā tá cúu nūū ní stéhēn maá Jētohō ō jā nūcūhun inī ō yā. ");
INSERT INTO mieNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","De ndihi nchivī sáhvi inī ji de yúhú ji. Chi nī nsāhá ndá apóstol cuāhā tiñu ñáhnú jā stéhēn jā cúñáhnú yā. ");
INSERT INTO mieNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","De inuú-ni nī īyo ndá nchivī cándíja, de ndācá ndatíñú jā névāha ji cúu cáhnú ndá ji-ni. ");
INSERT INTO mieNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","De nī yīcó ndá ji ñuhun ji jíín nā-ni ndatíñú névāha ji, de nī nsajī ji xūhún nūū ndá táhán ji, nāsaa jíni ñúhún iin iin ndá táhán ji. ");
INSERT INTO mieNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","De ndiquivī ndútútú ndá ji inī templo. De sīī-ni yájī cāhnú ndá ji stātílā vehe táhán ji, tá cúu nūū ní stéhēn maá Jētohō ō jā nūcūhun inī ō yā. De íyó mānī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","De cáhān ji jā cúñáhnú ndasí Yāā Dios. De nī jetúhún ndihi ndá nchivī ciudad ñúcuán ndá nchivī cándíja. De ndiquivī nī scácu cā maá Jētohō ō ndá cā nchivī, de nī nduu inuú-ni ndá ji jíín nchivī cándíja. ");
INSERT INTO mieNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","De iin quīvī de cahūnī jañíni nī ncaa Pedro jíín Juan cuāhān ndúū dē templo, chi maá hora jā jícān táhvī ndá táhán dē hebreo cúu. ");
INSERT INTO mieNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","De ñúcuán íyó iin tēe cojo jā súcuán íyó dē nī ncacu dē. Chi ndiquivī jíso nchivī dē jésiáha ji dē viéhé templo jā nání Viéhé Hermosa, de jícān dē caridad nūū ndá nchivī jā quívi templo. ");
INSERT INTO mieNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","De nī jinī tēe ñúcuán jā váji Pedro jíín Juan jā quīvi dē templo. De nī jīcān dē caridad nūū Pedro jíín Juan. ");
INSERT INTO mieNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","De nī ndēhé vāha Pedro jíín Juan nūū dē, de nī ncāhān Pedro: Cūndēhé vāha nú nūū ndúū ni, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","De íyó tūha tēe cojo ñúcuán, chi jáni inī dē jā nīhīn dē jacū xūhún nūū ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","De nī ncāhān Pedro: Nduú nā xūhún plata ni oro nduú ná névāha nī. Sochi íyó iin jā váha cā jā sāhá nī jíín nú. Jíín poder maá Jesucristo ñuū Nazaret cáhān ni jíín nú, nacuiñī de caca nú, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","De nī ntiin dē ndahá cuáhá tēe cojo ñúcuán, de nī stácuiñī dē. De jēhē dē jíín sūcūn jéhē dē nī nduvāha-ni. ");
INSERT INTO mieNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","De nīhin nī nacuiñī dē de íñí dē. De nī nquijéhé dē jíca dē-ni, de nī nquīvi dē inī templo jíín Pedro jíín Juan, jíca dē cuāhān dē, de cándava dē, de nácana jee dē Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","De nī jinī ndācá nchivī jā jíca dē cuāhān dē, de nácana jee dē Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","De nī nacunī ndá ji nūū dē jā suu dē cúu jā ní ndeē viéhé templo jā nání Viéhé Hermosa, nī jīcān dē caridad. De sáhvi inī ndá ji, de yúhú ji jā súcuán nī nduvāha tēe cojo. ");
INSERT INTO mieNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","De tēe jā ní īyo cojo jā ní nduvāha, chi nduú siáā dē ndahá Pedro jíín Juan, de ndihi nchivī nī jinu ji nī nquenda ji nūū ndá dē inī corredor templo jā nání Corredor Salomón. De sáhvi ndasí inī ndá ji ndéhé ji ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","De nī jinī Pedro jā váji ndá nchivī ñúcuán, de nī ncāhān dē jíín ndá ji: Ndá ní táhán maá ó Israel, ¿nā sīquī cúu jā sáhvi inī ndá ní ndéhé ní tiñu yáhá? ¿Nā sīquī cúu jā ndéhé vāha ndá ní nūū ndúū sá? ¿A jáni inī ndá ní jā íyó poder ndúū sá á jā cúu sá tēe vāha, de suu cúu jā ní nacaca tēe yáhá nī nsāhá sá, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","De nduú chi maá Yāā Dios jā ní nchiñúhún tatā ō Abraham, Isaac, Jacob jíín ndá cā tatā ō, maá yā nī nsāhá tiñu yáhá tácua cunī nchivī jā cúñáhnú ndasí Sēhe yā Jesús. De suu maá Jesús ñúcuán cúu jā ní nasiáha ndá ní yā nūū ndá tēe cúñáhnú. De nduú ní jétúhún ndá ní yā nūū Pilato vísō cúnī dē jā siáā dē yā nícu. ");
INSERT INTO mieNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Sochi ndá máá ní nī ncuyichī inī ndá ní Yāā īī, Yāā ndāā ñúcuán. De nī ncāhān ndá ní jā ná siáā Pilato iin tēe jā ní jahnī ndīyi lugar maá yā. ");
INSERT INTO mieNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","De nī ncāhān ndá ní jā ná cúū maá Yāā jā sáhá jā técū ndācá-ni. Sochi Yāā Dios nī nastécū yā Jesús jā ní ncuu yā ndīyi. De ndá máá sá cúu testigo jā ní natecū yā. ");
INSERT INTO mieNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","De tēe yáhá jā ndéhé ndá ní de nácunī ndá ní dē, chi nī ncandíja ndá sá jā íyó poder Jesús jā nasāhá vāha yā dē, de jā suu cúu jā ní nduvāha dē-ni nī nsāhá yā tá cúu nūū ndéhé ndá ní mitan. ");
INSERT INTO mieNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","De mitan amigo, ja jínī sá jā síquī jāá nduú ní jícūhun inī ndá ní cúu jā ní jahnī ní yā, de saá-ni nī nsāhá ndá tēe jā tátúnī nūū ō. ");
INSERT INTO mieNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","De jondē tá ncháha ca cuu, de ja nī nsāhá Yāā Dios jā ní ncāhān ndá tēe jā ní nacani tūhun yā jondē janahán jā suu súcuán cundoho Cristo. De mitan chi ja nī nquee ndaā nī nsāhá yā. ");
INSERT INTO mieNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Túsaá de nacani inī ndá ní jā sndóo ní cuāchi ní mitan, de quīvi ndá ní ndahá Yāā Dios tácua ná sndáhvā yā cuāchi ndá ní, de quiji quīvī jā ndusiī inī ndá ní sāhá maá Jētohō ō. ");
INSERT INTO mieNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","De suni tetíñú tucu Yāā Dios Jesús ndiji yā, chi cúu yā Cristo jā ní jani Yāā Dios jā scácu yā yóhó. ");
INSERT INTO mieNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Sochi cánuú jā cundeē Jesús andiví jondē quīvī jā nasāhá jeé Yāā Dios ndācá-ni tá cúu nūū ní nacani ndá tēe jondē janahán nī nsāhá Yāā Dios. De tēe nī īyo ndoo ánō nūū Yāā Dios nī ncuu ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","De Moisés nī ncāhān dē jíín ndá tatā ō: Maá Jētohō ō Yāā Dios cani yā iin Yāā jā nacani tūhun Yāā Dios nūū ndācá ó tá cúu nūū ní jani yā nduhū. De cuu yā iin táhán ó. De ndācá tūhun jā cāhān yā, de chuhun inī ndá nú. ");
INSERT INTO mieNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","De tú nā-ni nchivī mā chūhún inī ji tūhun jā cāhān maá Yāā jā nacani tūhun ñúcuán, de tānū tāhvī ji de mā cūú cā ji nchivī Israel, jā cúu nchivī maá yā, ncachī Moisés. ");
INSERT INTO mieNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","De ndá cā tēe nī nacani tūhun Yāā Dios jondē tiempo jā ní nquiji Samuel jíín jondē mitan, suni nī nacani ndá dē tūhun nāsa coo ndá quīvī yáhá. ");
INSERT INTO mieNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","De ndá máá ó cúu tatā ndá tēe nī nacani tūhun Yāā Dios jondē janahán. De suni sīquī ndá máá ó nī nsāhá yā trátū jíín ndá tatā ō, chi nī ncāhān yā jíín Abraham: Chījin tatā nū quiji iin Yāā jā sāhá jā quendōo ndetū ndá nchivī níí cáhnú ñayīví, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","De tá nī nastécū Yāā Dios Sēhe yā, de sá de xihna cā nūū ndá yóhó nī ntetíñú yā Jesús tácua quendōo ndetū ō. Chi sāhá yā jā nasāma inī ō de mā sāhá cā ō tiñu néhén, ncachī Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","De Pedro jíín Juan juni cáhān cā ndúū dē jíín ndá nchivī, de ndá sūtū jíín ndá tēe grupo saduceo jíín tēe cúñáhnú nūū ndá tēe jā jíto templo, nī nquenda ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","De nī nquītī ndasí inī ndá dē nī jinī dē jā súcuán stéhēn Pedro jíín Juan nūū ndá nchivī, jā nácani ndúū dē tūhun jā natecū ndīyi, chi Jesús de ja nī natecū yā jā ní jīhī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","De nī ntiin ndá dē Pedro jíín Juan, de nī nchihi dē ndúū tēe ñúcuán vecāa jā quendōo dē jondē quīvī téēn, chi ja nī ñini. ");
INSERT INTO mieNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sochi cuāhā nchivī jā ní jini tūhun nī ncāhān Pedro jíín Juan, nī ncandíja ndá ji. De nī jīnu tá ūhūn mil tēe jā ní ncandíja, de síín cā cúu ndá ñahan jíín sūchí lúlí. ");
INSERT INTO mieNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ñúcuán de quīvī téēn de ndá tēe ndíso tíñú nūū nchivī hebreo, jíín ndá tēe cúñáhnú, jíín ndá tēe stéhēn ley Moisés, nī ndutútú ndá dē inī ciudad Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","De saá-ni Anás jā cúu sūtū cúñáhnú cā, jíín Caifás jíín Juan jíín Alejandro jíín ndá nchivī jā cúu táhán sūtū cúñáhnú cā ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","De nī ncana ndá dē Pedro jíín Juan, de nī jani ndá ndúū dē māhñú ndá, de nī jīcā tūhún ndá: ¿Ní iin cúu jā ní ntetíñú ndóhó de ní jondē nī nīhīn tīñú ndúū nū tiñu yáhá? ncachī ndá. ");
INSERT INTO mieNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","De Pedro nī nchitú inī dē jíín Espíritu Santo, de nī ncāhān dē jíín ndá tēe ñúcuán: Ndá níhín tēe ndíso tíñú jíín tēe ñáhnú jā ndíso tíñú nūū maá ó nchivī Israel, ");
INSERT INTO mieNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mitan de ¿á stíchī ndá ní sāán sīquī iin tiñu váha jā ní nsāhá sá jā ní nduvāha tēe cúhū yáhá? ");
INSERT INTO mieNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Túsaá de ndá máá ní jíín ndá cā nchivī táhán maá ó Israel, jīcūhun inī ndá ní jā jíín poder maá Jesucristo ñuū Nazaret cúu jā ní nduvāha tēe íñí nūū ndá ní yáhá. De suu yā cúu jā ní jahnī ndá ní yīcā cruz, sochi maá Yāā Dios nī nastécū yā Jesucristo. ");
INSERT INTO mieNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Sochi ndá máá ní chi nī squéne yichī ndá ní yā tá cúu nūū squéne yichī ndá ní iin yūū jā quituu iin squínā vehe, chi nduú ní ncándíja ndá ní yā. De yūū ñúcuán cúu maá yūū jā yítuu squínā vehe mitan. ");
INSERT INTO mieNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Chi ni iin cā nduú cā ná īyó jā cuu scácu yóhó, chi nduú cā ni iin cā síví jā cáhān nchivī inī ñayīví yáhá jā cuu scácu yóhó, ncachī Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ñúcuán de nī jinī ndá tēe ñúcuán jā íyó ndeé inī Pedro jíín Juan jā cáhān ndúū dē. De ja jínī ndá jāá nduú tūha Pedro jíín Juan, chi tēe súcuán-ni cúu ndúū dē. De nī nsāhvi inī ndá, de nī nsāhá ndá cuenta jā ní jica ndúū dē jíín Jesús. ");
INSERT INTO mieNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","De suni ndéhé ndá nūū tēe jā ní nduvāha ñúcuán, íñí dē jíín Pedro jíín Juan. De ni iin tūhun nduú ní ncúu cuitī cā nascócóo ndá nūū Pedro jíín Juan. ");
INSERT INTO mieNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ñúcuán de nī ncachī ndá jā ná quíhīn Pedro jíín Juan tāvēhé tácua natúhún ndá máá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","De nī ncāhān ndá: ¿Nāsa sāhá ó jíín ndúū tēe yáhá túsaá? Chi ja nī jītē nuu tūhun cuāhān nūū ndá nchivī níí cáhnú ciudad Jerusalén yáhá jā súcuán nī nsāhá ndúū dē iin tiñu ñáhnú. De mā cūú cāhān ō jāá nduú ndāā. ");
INSERT INTO mieNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Túsaá de cāhān xēēn ō nūū dē jā má cāchí cuitī cā dē tūhun Jesús nūū ni iin cā nchivī, tácua mā cútē nuu cā tūhun yáhá quīhīn nūū ndá cā nchivī, ncachī ndá. ");
INSERT INTO mieNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","De nī nacana ndá dē Pedro jíín Juan. De nī ncāhān xēēn ndá nūū ndúū dē jā má cāchí cuitī cā dē de ni mā stéhēn cuitī cā dē tūhun Jesús nūū ni iin nchivī. ");
INSERT INTO mieNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Sochi nī ncāhān Pedro jíín Juan: Cani vāha inī ndá ní de tú jétahān inī Yāā Dios jā sndóo sá tiñu jā ní ndacu yā de sāhá sá tiñu jā ndácu ndá máá ní. ");
INSERT INTO mieNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Chi mā cūú sndóo ndá sá tiñu jā ní jinī sá jíín jā ní jini sá, chi cánuú jā nacani sá nūū ndá nchivī, ncachī ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ñúcuán de nī ncāhān xēēn tucu ndá nūū ndúū dē, de nī nsiáā-ni ndá ndúū dē. Chi nduú ní níhīn cuitī ndá ni iin modo jā sndóho ndá Pedro jíín Juan, chi yúhú ndá ndéhé ndá ndá cā nchivī, chi ndihi ji-ni cáhān ji jā cúñáhnú ndasí Yāā Dios jā ní nsāhá yā tiñu ñáhnú ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Chi tēe jā ní nduvāha jíín tiñu ñáhnú ñúcuán, íyó dē víhí cā ūū xico cuīyā. ");
INSERT INTO mieNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","De tá nī nsiáā ndá Pedro jíín Juan cuāhān ndúū dē, de nī nenda dē nūū ndá táhán dē. De nī nacani dē ndācá tūhun jā ní ncāhān ndá sūtū cúñáhnú jíín ndá tēe ñáhnú jā ndíso tíñú. ");
INSERT INTO mieNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","De jā súcuán nī jini ndá ji, de inuú-ni nī jīcān táhvī ndá ji nūū Yāā Dios: Tátā Yāā Dios, maá ní cúu Yāā Dios jā ní nsāhá andiví jíín ñayīví jíín mar jíín ndācá cā jā íyó. ");
INSERT INTO mieNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","De jā jíín Espíritu Santo ní nī nsāhá ní jā ní ncāhān mozo ní David jondē janahán: ¿Nājēhē cúu jā quítī ndasí inī nchivī ndá cā nación? ¿De nājēhē cúu jā jáni cāhá inī ndá ji? ");
INSERT INTO mieNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nī ncutútú ndá tēe jā cúu rey inī ñayīví, de nī natacā ndá tēe jā ndíso tíñú, de inuú-ni nī nenda ndá dē sīquī maá ní jā cúu ní Jētohō ndá sá, jíín sīquī Cristo, Yāā jā ní jani ní. Ncachī David. ");
INSERT INTO mieNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Chi jāndáā cúu jā Herodes jíín Poncio Pilato jíín ndá nchivī táhán maá sá Israel jíín ndá nchivī incā nación, nī ncutútú ndá ji inī ciudad Jerusalén yáhá, de nī nenda ji sīquī Sēhe īī ní Jesús, Yāā jā ní jani ní. ");
INSERT INTO mieNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","De súcuán nī ncuu tácua ná quée ndaā ndācá tiñu jā ní nsāhá ndāā maá ní jondē janahán jā súcuán coo. ");
INSERT INTO mieNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","De mitan, Tátā Yāā Dios, cūndēhé ní jā ní ncāhān xēēn ndá dē nūū ndá sá. De cuāha ní fuerza ní nūū ndá sá jā cúu sá mozo ní, tácua coo ndeé inī sá jā nacani sá tūhun ní. ");
INSERT INTO mieNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","De jíín poder maá ní de sāhá ní jā nasāhá vāha ndá sá nchivī cúhū, de sāhá ndá sá tiñu jā stéhēn jā íyó poder ní, jíín tiñu jā sāhvi inī nchivī sāhá. De ndācá ñúcuán sāhá ní jíín poder Sēhe īī ní Jesús, ncachī ndá nchivī cándíja. ");
INSERT INTO mieNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","De tá nī ncuu nī jīcān táhvī ndá ji de nī nsāhá yā jā ní ntāan nūū íyó tútú ndá ji. De nī nchitú ndá ji jíín Espíritu Santo, de víhí cā nī nchundeé inī ndá ji nī nacani ji tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","De ndá nchivī cuāhā jā ní ncandíja, chi inuú-ni íyó inī ndá ji. De ni iin ji nduú ní nsáhá ji jā cúu ndatíñú máá ji ndācá ndatíñú jā névāha ndá ji, chi ndihi-ni ndatíñú névāha cáhnú ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","De nīhin ndasí nácani ndá apóstol tūhun jā ní jinī dē jā ní natecū Jētohō ō Jesús. De vāha ndasí nī nchindeé yā ndá nchivī cándíja. ");
INSERT INTO mieNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Chi ni iin ji nduú ná cúmanī cuitī nūū ji, chi ndācá nchivī jā xíñúhun jā xívéhe chi nī yīcó ji. ");
INSERT INTO mieNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","De jésiáha ndá ji xūhún ñúcuán nūū ndá apóstol. De sájī ndá apóstol xūhún nūū ndá cā nchivī cándíja nāsa jíni ñúhún iin iin ji. ");
INSERT INTO mieNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","De súcuán nī nsāhá José jā cúu tatā Leví, nī ncacu dē Chipre jā cúu iin pedazo ñuhun jā ñúhún māhñú ndute. De ndá apóstol nī nascúnaní dē tēe ñúcuán Bernabé. De síví ñúcuán cáhān jā tēe cáhān tūhun ndeé inī cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","De nī yīcó dē iin ñuhun dē, de nī jēsiáha dē xūhún ñúcuán nūū ndá apóstol. ");
INSERT INTO mieNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","De incā tēe jā nání Ananías jíín ñasíhí dē jā nání ña Safira, nī yīcó ndúū dē iin ñuhun dē. ");
INSERT INTO mieNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","De nī nacoo dē sava xūhún jā cuu ndúū dē jíín ña, de suni nī jinī ña jā súcuán nī nsāhá dē. De nī jēsiáha dē sava xūhún dē nūū ndá apóstol, sochi sáhá dē-ni jā ñúcuán cúu ndihi. ");
INSERT INTO mieNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","De nī ncāhān Pedro: Ananías, ¿nājēhē cúu jā ní nquīvi Satanás ánō nū jā stáhví nú Espíritu Santo cúnī nū? Chi nī nacoo nú jacū xūhún ñuhun jā cuu maá nú, de stáhví nú chi sáhá nú-ni jā váji ndihi nú-ni jíín xūhún. ");
INSERT INTO mieNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","De tá ncháha ca xīcó nú ¿de á nsūú cuenta maá nú ní ncúu ñuhun ñúcuán? De tá nī yīcó nú ¿de á nsūú xūhún maá nú cúu? ¿De nājēhē cúu jā ní jani inī nū jā stáhví nú? Chi nsūú maá-ni tēe ñayīví cúu jā ndúcú nú stáhví nú, chi suni jondē Yāā Dios, ncachī Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","De tá nī jini Ananías ndá tūhun yáhá de nī ndicó cáva dē, de nī jīhī dē-ni. De ndācá nchivī jā ní jini tūhun ñúcuán, nī nchūhú ndasí ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ñúcuán de nī nacuiñī ndá tēe suchí, de nī nchusúcún ndá dē sahma ndīyi ñúcuán, de cuāchuhū ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","De nī ncuu tá ūnī cā hora, de nī nquenda ñasíhí ndīyi ñúcuán, nī nquīvi ña vehe nūū íyó Pedro. De nduú jínī ña jā súcuán nī ncuu. ");
INSERT INTO mieNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","De nī jīcā tūhún Pedro ña: Cachī nūū ni, ¿á iin tanto suha nī nīhīn ndúū nū jā ní yīcó nú ñuhun, á naá cúu? ncachī dē. De nī ncāhān ña: Suu iin tanto súcuán nī yīcó ndúū sá, ncachī ña. ");
INSERT INTO mieNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","De nī ncāhān Pedro jíín ña: ¿De nūcu nī squétáhán ndúū nū tūhun jā stáhví nú Espíritu maá Jētohō ō? ¿De á mā níhīn ndúū nū castigo jáni inī nū? De cunini de cunī nū chi ja cátīn tāvēhé jā ní nenda ndá tēe jā ní jēchuhū yií nú, de suni súcuán tavā dē ndóhó jā cuyuhū nū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","De nī ndicó cáva ña-ni nūū jéhē Pedro, de nī jīhī ña-ni. De nī ndīvi-ni ndá tēe suchí ñúcuán. De nī jinī ndá dē ja nī jīhī tucu ñahan ñúcuán, de nī ntavā tucu dē ña tāvēhé, de nī nchiyuhū dē ña xiín yií ña. ");
INSERT INTO mieNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","De nī nchūhú ndasí ndá nchivī cándíja jíín ndá cā nchivī jā ní jini tūhun nāsa nī ncuu. ");
INSERT INTO mieNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","De nī nsāhá ndá apóstol cuāhā tiñu ñáhnú nūū ndá nchivī, jíín tiñu jā stéhēn jā íyó poder Yāā Dios. De ndútútú ndá nchivī cándíja inī corredor templo jā nání Corredor Salomón. ");
INSERT INTO mieNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","De ndá nchivī jāá nduú cándíja chi nduú ní ncúndeé inī ni iin ji jā tandeē tāhán ji jíín ndá nchivī cándíja, vísō jétúhún ndasí ji. ");
INSERT INTO mieNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Sochi nī ncandíja cuāhā cā nchivī nūū maá Jētohō ō, cúu tēe cúu ñahan. ");
INSERT INTO mieNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","De nī nquiji ndá nchivī jíín ndá táhán ji nchivī cúhū, de nī jaquīn ji inī ndá calle, yósō ndá ji nūū yūú jíín nūū camilla tú sanaā de yāha Pedro de vísō cōndāhvī dē ná yáha sīquī ji de nduvāha ji. ");
INSERT INTO mieNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","De saá-ni ndá nchivī ndá ñuū ñatin ñúcuán, suni nī nquenda cuāhā ji ciudad Jerusalén, nī nquisiáha ji ndá jā cúhū jíín jā ndóho tāchī. De ndihi-ni ndá ji nī nduvāha. ");
INSERT INTO mieNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ñúcuán de nī ncucuásún inī maá sūtū cúñáhnú cā nī jinī dē ndá apóstol, de saá-ni ndá cā táhán dē jā scuáha sahān saduceo. De nī nenda ndá dē sīquī ndá apóstol. ");
INSERT INTO mieNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","De nī ntiin ndá dē, de nī nchihi ndá dē ndá apóstol vecāa. ");
INSERT INTO mieNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Sochi iin ángel maá Jētohō ō nī nacune yā viéhé cāa jacuáā. De nī ntavā yā ndá dē, de nī ncāhān yā: ");
INSERT INTO mieNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Cuáhán, de cuiñi nú inī templo. De ñúcuán nacani nú ndācá tūhun nūū ndá nchivī nāsa nīhīn táhvī ji jā cutecū ji níí cání, ncachī ángel. ");
INSERT INTO mieNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","De nī jini ndá dē tūhun yáhá. De tá nī ncunijīn de nī nquīvi ndá dē inī templo, de nī stéhēn ndá dē tūhun yā nūū nchivī. De juni stéhēn ndá dē de sūtū cúñáhnú cā jíín ndá táhán dē nī nastútú dē ndá tēe sáhá junta cúñáhnú cā nūū nchivī Israel. De nī ntají dē ndá policía jā cuátavā dē ndá apóstol jā yíhí dē vecāa. ");
INSERT INTO mieNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Sochi tá nī nquenda ndá policía viéhé cāa de nduú cā ndá apóstol yíhí vecāa. De nī ndicó cóo ndá dē, de nī ncachī tūhun dē nūū ndá tēe sáhá junta: ");
INSERT INTO mieNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Maá jāndáā jā ní jinī ndá sá jā ndásī vāha viéhé cāa de íñí ndá tēe jā jíto, sochi tá nī nacune ndá sá de nduú ní jínī cuitī cā ndá sá nūū ni iin tēe ñúcuán, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","De sūtū cúñáhnú cā jíín ndá cā sūtū cúñáhnú jíín tēe cúñáhnú nūū ndá tēe jā jíto templo, tá nī jini ndá dē tūhun yáhá de jáni inī ndá dē nāsa cā coo tiñu ndá apóstol. ");
INSERT INTO mieNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ñúcuán de nī nquenda-ni iin tēe nī ncachī tūhun dē: Ndá tēe jā ní nchihi ndá ní vecāa, íyó ndá dē inī templo, de stéhēn ndá dē nūū nchivī, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ñúcuán de maá tēe cúñáhnú nūū ndá tēe jā jíto templo, nī jēhēn dē jíín ndá policía, de nī nacueca ñuncúún tucu ndá dē ndá apóstol, chi yúhú ndá dē ndéhé dē nchivī jā cuun ji yūū ndá dē de tú sāhá xēēn dē jíín ndá apóstol. ");
INSERT INTO mieNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","De tá nī nenda ndá dē jíín ndá apóstol de nī jani dē nūū ndá tēe cúñáhnú jā sáhá junta. De nī ncāhān sūtū cúñáhnú cā nūū ndá apóstol: ");
INSERT INTO mieNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","¿A nsūú ja nī ndacu nīhin nī nūū ndá nú jā má stéhēn cuitī nū cā tūhun tēe nání Jesús? De mitan chi ja nī scútē nuu nú cā tūhun Jesús níí ciudad Jerusalén yáhá. ¿A cúnī nū jā tee nú cuāchi nīñī tēe ñúcuán sīquī ndá nī? ncachī sūtū cúñáhnú cā. ");
INSERT INTO mieNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ñúcuán de Pedro jíín ndá cā apóstol nī ncāhān ndá dē: Cánuú cā jā squíncuu ndá sá jā cúnī maá Yāā Dios nsūú cā jā cúnī ndá tēe. ");
INSERT INTO mieNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yāā Dios jā ní nchiñúhún ndá ndīyi tatā ō, nī nastécū yā Jesús, Yāā jā ní jahnī ndá máá ní, chi nī jata caa ndá ní yā yīcā cruz. ");
INSERT INTO mieNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","De Yāā ñúcuán nī nduñáhnú tucu yā nī nsāhá Yāā Dios, chi ndéē yā ichi ndahá cuáhá Yāā Dios. De cúu yā Yāā jā tátúnī jíín Yāā jā scácu yóhó, tácua nacani inī ndācá ó jā cúu ó nchivī Israel sīquī cuáchi ó de cune cáhnú inī yā nūū ndācá cuāchi ó. ");
INSERT INTO mieNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","De ndá máá sá cúu testigo sīquī ndācá tūhun yáhá. De saá-ni Espíritu Santo suni súcuán stéhēn cājí yā, chi jéhe Yāā Dios Espíritu Santo nūū ndācá nchivī jā jétáhví ji yā, ncachī Pedro jíín ndá cā apóstol. ");
INSERT INTO mieNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","De tá nī jini ndá tēe cúñáhnú tūhun yáhá de nī nquītī ndasí inī ndá dē, de cúnī ndá dē jā cahnī dē ndá apóstol. ");
INSERT INTO mieNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sochi íyó iin dē jā stéhēn ley yā jā nání Gamaliel jā cúu grupo fariseo, de ndācá nchivī jétáhví ji tēe ñúcuán. De nī nacuiñī dē nūū junta, de nī ncachī dē jā ná quíhīn ndá apóstol iin núú núú tāvēhé. ");
INSERT INTO mieNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","De nī ncāhān Gamaliel: Ndá níhín jā cúu ó nchivī nación Israel, cani vāha inī ní nāsa sāhá ndá ní jíín ndá tēe yáhá. ");
INSERT INTO mieNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","De nūcūhun inī ndá ní nāsa nī ncuu quīvī yātā jā ní nenda Teudas contra sīquī gobierno, de nī ncachī dē jā tēe téyíí cúu dē. De nī ncutútú tá cūmī ciento tēe nūū dē. Sochi nī jahnī nchivī dē, de ndācá jā ní jetáhví tūhun jā ní ncāhān dē, nī nacutē nuu ndá dē cuāhān dē-ni, de nī jencuiñī-ni tiñu ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ñúcuán de quīvī jā ní īyo censo de Judas tēe Galilea, suni súcuán nī nenda dē contra sīquī gobierno, de cuāhā nchivī nī ncutútú ji nūū dē de nī jetáhví ji dē. De suni nī jahnī nchivī tēe ñúcuán, de ndācá nchivī jā ní jetáhví tēe ñúcuán, suni nī jītē nuu-ni ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","De yáhá ná cáchī tūhun sá nūū ndá ní. Mā stáhān cā ní ndá tēe yáhá. Siáā ndá ní dē ná quíhīn dē. Chi tú iin tēe cúu jā ní squíjéhé tiñu yáhá de naā-ni. ");
INSERT INTO mieNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Sochi tú Yāā Dios nī squíjéhé, de mā cūú cuitī casī ndá ní, chi sanaā de cuéé cā de cunī ndá ní jā tiñu Yāā Dios cúu jā ndúcú ní casī ní, ncachī Gamaliel. ");
INSERT INTO mieNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","De nī jetáhví ndá dē tūhun jā ní ncāhān Gamaliel. De nī nacana ndá dē ndá apóstol. De nī ncani ndá dē jíín cuarta ñii, de nī ncāhān xēēn ndá dē nūū ndá apóstol jā má cáhān cā dē tūhun Jesús, de nī nsiáā ndá dē-ni. ");
INSERT INTO mieNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","De nī nquee ndá apóstol nūū junta cuāhān dē, de cúsiī inī ndá dē jā ní jēhe Yāā Dios tūhun jā ní ndoho ndá dē tūhun canoō jā síquī jā cándíja dē Jesús. ");
INSERT INTO mieNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","De ndiquivī nácani ndá dē tūhun Jesucristo inī templo jíín inī ndācá vehe, chi nduú ní jéncuiñī ndá dē jā stéhēn dē. ");
INSERT INTO mieNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","De nī ncucuahā cā nchivī cándíja. De ndá quīvī ñúcuán de ndá tēe hebreo jā cáhān yuhú griego, nī ncāhān sōó dē sīquī táhán dē jā cáhān yuhú hebreo, chi cáchī dē jā ndá ñahan viuda jā cáhān yuhú griego nduú níhīn vāha ña tá sájī dē stāā ndiquivī jā yájī ndá ñahan viuda. ");
INSERT INTO mieNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ñúcuán de ndihúxī ūū tēe cúu apóstol, nī nastútú dē ndācá nchivī cándíja, de nī ncāhān ndá dē: Nduú vāha jā jencuiñī ndá nī jā nácani nī tūhun Yāā Dios jā sajī ni stāā nūū nchivī. ");
INSERT INTO mieNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Túsaá de ndá ndóhó hermano, nacāji nú ūjā táhán ndá máá ó, tēe jā jétúhún nchivī dē, de ñúhún chitú Espíritu Santo inī dē, de tú tēe jínī vāha cā cúu dē. De ndá máá dē cuiso tíñú jā sajī dē stāā. ");
INSERT INTO mieNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","De ndá nduhū chi cúsá maá jā cācān táhvī ndá nī jíín jā nacani nī tūhun yā, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","De nī jētahān inī ndihi nchivī tūhun jā ní ncāhān ndá dē. De nī nacāji ndá ji Esteban, chi tēe cándíja nīhin cúu dē, de íyó chitú Espíritu Santo inī dē. De suni nī nacāji ji Felipe jíín Prócoro jíín Nicanor jíín Timón jíín Parmenas jíín Nicolás. De Nicolás cúu tēe ñuū Antioquía jā ní ntiin ley hebreo jondē ncháha ca candíja dē Cristo. ");
INSERT INTO mieNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","De ndá tēe yáhá nī jani ndá nchivī dē nūū ndá apóstol, de nī jīcān táhvī ndá apóstol sīquī tiñu jā sāhá ndá dē. De nī ntee ndá dē ndahá dē xīnī tá iin iin dē. ");
INSERT INTO mieNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","De tūhun Yāā Dios nī jītē nuu cā cuāhān níí cáhnú. De ndá nchivī cándíja nī ncucuahā ndasí ji inī ciudad Jerusalén. De suni cuāhā sūtū nī ncandíja dē yā. ");
INSERT INTO mieNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","De nī nchindeé nī nchituu yā Esteban, de nī jēhe yā poder nūū dē de vāha nī nsāhá dē tiñu ñáhnú ndasí nūū ndá nchivī, jíín tiñu jā stéhēn jā íyó poder Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","De íyó ndá tēe jā ní ncuyāhvi de nī nduu libre dē, de nī īyo vehe īī sinagoga ndá dē. De sava ndá dē jíín sava tēe ñuū Cirene jíín ñuū Alejandría jíín región Cilicia jíín Asia, nī nquijéhé ndá dē stíchī dē Esteban. ");
INSERT INTO mieNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sochi nduú ní ncúndéé ndá dē jíín Esteban, chi ndíchí nī ncāhān dē nī nsāhá maá Espíritu Santo. ");
INSERT INTO mieNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ñúcuán de nī scáhān ndá dē jacū tēe nī ncāhān tūhun stáhví sīquī Esteban, chi nī ncāhān dē jā ní jini dē jā ní ncāhān nāvāha Esteban sīquī Moisés jíín sīquī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","De jā súcuán nī ncāhān dē, de nī nquītī inī ndá nchivī jíín ndá tēe ñáhnú jā ndíso tíñú jíín ndá tēe jā stéhēn ley janahán. De nī nenda ndá dē sīquī Esteban, de nī ntiin ndá dē, de cuāhān ndá dē jíín Esteban nūū junta cúñáhnú cā. ");
INSERT INTO mieNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","De nī jani ndá dē testigo tūhún jā ní ncāhān súcuán: Tēe yáhá, ndiquivī cáhān nāvāha dē sīquī templo īī yáhá jíín sīquī ley Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Chi nī jini ndá sá jā ní ncāhān dē jā Jesús tēe ñuū Nazaret, canī dē templo yáhá, de nasāma dē ndá costumbre jā ní sndóo Moisés nūū ō jā sāhá ó, ncachī testigo tūhún. ");
INSERT INTO mieNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ñúcuán de ndācá tēe jā ndéē nūū junta, nī ndēhé vāha ndá dē nūū Esteban, de nī jinī ndá dē jā cáá nūū dē tá cáá nūū iin ángel Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","De maá sūtū cúñáhnú cā nī ncāhān jíín Esteban: ¿A ndāā jā súcuán nī ncāhān nū tá cúu nūū cáhān tēe yáhá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","De nī ncāhān Esteban: Ndá ní tátā, señor, cunini ndá ní tūhun yáhá jā cāhān sá. Maá Yāā Dios, Yāā jā viī ndasí cúñáhnú, nī nquiji yā nūū ndīyi tatā ō Abraham tá nī ndeē dē inī región Mesopotamia de jondē tá ncháha ca quīhīn dē cundeē dē inī ñuū Harán. ");
INSERT INTO mieNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","De nī ncāhān yā jíín dē: Quee inī ñuū nū jíín māhñú táhán nú, de quīhīn nū iin ñuū jā stéhēn ni nūū nū cundeē nū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ñúcuán de nī nquee dē inī región Caldea, de nī ndeē dē inī ñuū Harán. De tá nī jīhī tatá dē, sá de nī nsāhá Yāā Dios jā ní nquiji dē yáhá nūū ndéē ō mitan. ");
INSERT INTO mieNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","De ni iin lulī ñuhun nduú ní jéhe cuitī yā jā cuu tāhvī dē, sochi nī nquee yuhú yā jā cuāha yā níí ñuhun yáhá nūū dē jondē jíín nūū ndācá tatā dē jā quiji, vísō ncháha ca coo sēhe dē jondē saá. ");
INSERT INTO mieNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","De súcuán nī ncāhān Yāā Dios jíín dē: Cundeē jīcá tatā nū incā nación. De cūmī ciento cuīyā satíñú cāhá ji nūū nchivī de sndóho ndá nchivī ji. ");
INSERT INTO mieNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","De sīquī jā súcuán sāhá ji jíín sēhe nú de nenda nī cuāchi sīquī ndá nchivī ñúcuán nūū satíñú cāhá ji, de sá de quee ji inī nación ñúcuán quiji ji ichi cháhá cundeē ji, de chiñúhún ji nduhū, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","De nī ncāhān yā jíín Abraham jā ná cúu dē circuncidar, jā cúu iin tunī jā stéhēn jā ní nsāhá yā trátū jíín dē. De tá nī ncacu sēhe dē Isaac, de nī nsāhá dē circuncidar ji nūū únā quīvī ji. De suni súcuán nī nsāhá Isaac jíín sēhe dē Jacob, de saá-ni nī nsāhá Jacob jíín ndihúxī ūū sēhe yií dē. De ndá tēe ñúcuán nī ncuu ndihúxī ūū tatā xíhna ñúhún nación maá ó Israel. ");
INSERT INTO mieNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","De ndācá sēhe tatā ō Jacob nī ncucuásún inī ndá dē nī jinī dē ñanī dē José. De nī yīcó ndá dē José nūū ndá tēe jā cuāhān jíín dē jondē nación Egipto jā satíñú cāhá dē nūū iin tēe ñúcuán. Sochi Yāā Dios nī jito yā dē. ");
INSERT INTO mieNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","De nī scácu yā dē nūū ndācá tūndóhó jā ní nquiji sīquī dē. De nī ncundíchí dē nī nsāhá yā. De Faraón, tēe cúu rey inī nación Egipto, nī ncusiī inī dē jíín José nī nsāhá yā. De nī scuíso tíñú dē José jā cuu dē gobernador, de nī ntatúnī José inī nación Egipto jíín nūū ndá nchivī vehe Faraón. ");
INSERT INTO mieNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","De nī nquiji quīvī jā ní īyo iin tāmā níí Egipto jíín níí jondē Canaán. Iin tūndóhó xéēn nī ncuu inī ndúū nación ñúcuán. De ndá ndīyi tatā ō, nduú cā ná cajī ndá dē ndá tiempo ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","De nī nīhīn Jacob tūhun jā íyó trigo nación Egipto, de nī ntají dē ndá sēhe dē jā cúu tatā ō, nī jēhēn Egipto jā xíhna ñúhún nī jēcuēen ndá dē trigo. ");
INSERT INTO mieNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","De jā cuáhān ndá dē vuelta ūū, sá de nī nastúu José jā maá dē cúu ñanī ndá dē. De sá de nī jinī vāha Faraón nā tatā cúu José. ");
INSERT INTO mieNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","De nī ncachī José nūū ndá ñanī dē jā ná quícuēca ndá dē tatá dē jíín ndá nchivī vehe dē. De nī īyo ūnī xico xāhōn ji. ");
INSERT INTO mieNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Súcuán nī ncuu jā ní nquee Jacob cuāhān dē jondē Egipto. De nī ndeē dē ñúcuán jondē nī jīhī dē. De suni ñúcuán nī ndeē ndihúxī ūū sēhe dē jā cúu tatā ō de jondē nī jīhī ndihi ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","De tá nī nquenda quīvī jā ní ntavā yā ndá tatā dē inī nación ñúcuán, de nī jiso ji yiqui ndá ndīyi tatā ō ñúcuán nī jēhēn ji jíín jondē ñuū Siquem. De nī nchiyuhū ndá ji inī iin yavī ndīyi jā ní jeen Abraham nūū ndá sēhe Hamor ñuū Siquem. ");
INSERT INTO mieNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","De tá cáta ndéē cā ndá ji inī nación Egipto de nī ncuñatin quīvī jā quee ndá ji. Chi súcuán ja nī ncāhān téyíí Yāā Dios jíín tatā ō Abraham jā iin quīvī de quee ji inī Egipto. De ndá nchivī Israel ñúcuán chi nī ncāyā ndá ji de nī ncucuahā ji inī nación Egipto. ");
INSERT INTO mieNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ñúcuán de nī nūcuīñī incā rey inī Egipto, de nduú ní jínī dē jā vāha tiñu nī nsāhá José jondē janahán. ");
INSERT INTO mieNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","De rey ñúcuán nī stáhví dē ndá ndīyi tatā ō, de suni nī nsāhá nāvāha dē ndá ji, chi nī nsāhá dē fuerza jā má cōtó cā ji ndá sēhe ñiquín ji tácua ná cúū ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","De tiempo ñúcuán nī ncacu Moisés, de nī ncusiī inī Yāā Dios jíín ji. De ūnī yōō nī īyo yuhū ji inī vehe tatá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","De tá nduú cā ní ncúu coo yuhū ji de nī jēsiáha dē ji iin lugar nūū ní nanihīn sēhe síhí rey jā tátúnī níí nación Egipto. De nī naquehen ña ji, de nī scuáhnu ña ji tá cúu nūū cúu sēhe maá ña. ");
INSERT INTO mieNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","De nī ncutūha Moisés ndācá tūhun ndíchí inī nación Egipto. De vāha ndasí tūhun dē, de vāha sáhá dē ndācá tiñu. ");
INSERT INTO mieNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","De tá nī ncuu ūū xico cuīyā dē, de nī jēndēhé dē ndācá táhán dē jā cúu tatā Israel. ");
INSERT INTO mieNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","De ñúcuán nī jinī dē nūū iin tēe Egipto jā sáhá nāvāha jíín iin táhán dē Israel. De nī nchindeé Moisés táhán dē, chi nī jahnī dē tēe Egipto, de súcuán nī nacuāha dē jā ní ndutahvī tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","De jáni inī Moisés jā jícūhun inī ndācá táhán dē jā ní ntetíñú Yāā Dios maá dē jā scácu dē ji jā ndóho ji, sochi nduú ní jícūhun cuitī inī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","De quīvī téēn nī nquenda dē nūū ūū táhán dē jā cánāá. De cúnī dē jā má cánāá ndúū tēe ñúcuán, de nī ncāhān dē jíín ndúū dē: ¿Nājēhē cúu jā sáhá nāvāha nú táhán nú? Chi modo ñanī ndúū nū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Sochi maá tēe jā cáni táhán ñúcuán nī nchindahá dē Moisés, de nī ncāhān dē: ¿Ní iin nī jani ndóhó jā cúñáhnú nú jā sāhá ndāā nū tiñu ndá nī? ");
INSERT INTO mieNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿De á suni cúnī nū jā cahnī nū nduhū tá cúu nūū ní jahnī nū tēe Egipto icu, á naá cúu? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","De tá nī jini Moisés tūhun yáhá, de nī jinu dē cuāhān dē incā nación. De jondē Madián nī ndeē jīcá dē, de ñúcuán nī scácu ñasíhí dē ūū sēhe yií dē. ");
INSERT INTO mieNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","De tá nī ncuu ūū xico cuīyā jā ndéē dē Madián, sá de nī nquenda iin ángel Yāā Dios nūū dē jondē nūū ñuhun tíhá ñatin nūū íyó yucu súcún Sinaí. De nī nquenda yā xīnī iin yūcū cāhnú jā cáyū jíín itā ñuhūn sochi nduú cáyū maá yūcū. ");
INSERT INTO mieNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ñúcuán de nī ndēhé Moisés, de nī nsāhvi inī dē ndéhé dē ñuhūn jā ní jinī dē. De nī ntandeē dē tácua cunī vāha dē nājēhē cúu jāá nduú cáyū. Ñúcuán de nī ncāhān maá Jētohō ō jíín dē: ");
INSERT INTO mieNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Maá nī cúu Yāā Dios jā ní nchiñúhún ndá ndīyi tatā nū Abraham jíín Isaac jíín Jacob, ncachī yā. Sochi Moisés chi quísi dē jā yúhú dē, de nduú cā ní ncúndeé inī dē cūndēhé dē nūū cáyū ñuhūn. ");
INSERT INTO mieNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","De maá Jētohō ō nī ncāhān yā jíín Moisés: Tavā nījān nū, chi lugar nūū íñí nú jīñā, lugar īī cúu sīquī jā īī maá nī. ");
INSERT INTO mieNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ja nī jinī vāha nī jā ndóho ndasí ndá nchivī maá nī jā íyó inī nación Egipto, de suni jíni nī jā jácu ndá ji sīquī jā ndóho ji tūndóhó, de nī nuu nī vāji nī jā scácu nī ndá ji. Túsaá de mitan de cunini nú, chi tají nī ndóhó quīnohōn nū jondē Egipto tácua scácu nú ndá táhán nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","De jondē tá ncháha ca quee Moisés inī nación Egipto, de ja nī ncuyichī inī ndá táhán dē Israel, chi nī ncāhān ji: ¿Ní iin nī jani ndóhó jā cuñáhnú nú jā sāhá ndāā nū tiñu ndá nī? ncachī ji. De vísō súcuán sochi nūū maá dē nī nquiji ángel yā nūū yūcū jā cáyū jíín itā ñuhūn, de súcuán nī ntetíñú Yāā Dios dē jā quínohōn dē tatúnī dē nūū ndá ji, de scácu dē ji. ");
INSERT INTO mieNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","De maá Moisés nī natavā dē ndá ji inī nación Egipto, de nī nchāha ndá dē Mar Rojo, de nī jica nuu ndá dē nūū ñuhun tíhá ūū xico cuīyā. De níí tiempo ñúcuán nī nsāhá Moisés cuāhā tiñu ñáhnú jíín tiñu jā stéhēn jā íyó poder yā. ");
INSERT INTO mieNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","De maá Moisés cúu jā ní ncāhān tucu jíín ndá tatā ō Israel: Maá Yāā Dios sāhá yā jā māhñú tatā ndācá ó quiji iin Yāā jā nacani tūhun Yāā Dios nūū ndācá ó tá cúu nūū ní jani yā nduhū. De chuhun inī ndá nú tūhun jā cāhān Yāā ñúcuán, ncachī Moisés. ");
INSERT INTO mieNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","De suni maá Moisés cúu jā ní ndeē cāhnú jíín ndá ndīyi tatā ō tá nī jica nuu ndá ji nūū ñuhun tíhá. De nī ncāhān iin ángel yā jíín maá dē xīnī yucu súcún Sinaí, de nī nacani dē nūū ndá tatā ō, chi ñúcuán nī nīhīn dē tūhun nāsa cutecū ō, de nī nquendōo ó jíín tūhun ñúcuán jondē mitan. ");
INSERT INTO mieNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Sochi ndá ndīyi tatā ō chi nduú ní ncúnī ndá ji cuetáhví ji Moisés, chi sa nī ncuyichī inī ndá ji dē, de cúnī ndá ji jā sa ndicó cóo ji quīnohōn ji nación Egipto nícu. ");
INSERT INTO mieNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","De nī ncāhān ndá ji jíín Aarón: Sāhá ní ndá yāā jā cosō nūú nūū ō. Chi Moisés jā ní natavā dē yóhó inī nación Egipto vāji ó, nduú jínī ō naá cúu jā ní ndoho dē mitan jāá nduú nénda dē jā cuáhān dē xīnī yucu súcún Sinaí, ncachī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ñúcuán de nī nsāhá ji iin ídolo jā cáá tá cáá becerro. De nūū ídolo ñúcuán nī nsōcō ndá ji quiti, de nī ncusiī inī ji jíín ídolo jā ní nsāhá ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","De nī ncujiyo-ni Yāā Dios nūū ndá ji cuāhān yā. De nī sndóo yā ji-ni jā ná chíñúhún ndá ji nūū ndācá jā jínī ō jā yíhí andiví tá cúu nūū cáhān tutū jā ní ntee ndá tēe jā ní nacani tūhun Yāā Dios jondē janahán: Nī ncāhān yā: Ndá ndóhó nchivī Israel, ¿á jáni inī ndá nú jā nūū nduhū nī nsōcō nū quiti tá nī jica nú nūū ñuhun tíhá ūū xico cuīyā, á naá cúu? ");
INSERT INTO mieNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nduú, chi sa nī jicó núu ndá nú jíín nicho jā ñúhún yāā jā nání Moloc jíín figura tiūūn jā nání Renfán, ndá yāā jā ní nsāhá maá nú jā chiñúhún nú. Túsaá de siáha nī ndá ndóhó quīhīn jīcá nú jondē yātā ñúū Babilonia, ncachī yā. Cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","De nī ntatúnī Yāā Dios nūū Moisés jā sāhá dē vehe ñii nūū chiñúhún ndá dē yā, jā cáá tá cáá jā ní stéhēn yā nūū dē. De ndīyi tatā ō nī nevāha ndá dē vehe ñii ñúcuán jondē nūū ñuhun tíhá, de inī vehe ñúcuán nī nchuhun ndá dē tabla yūū nūū ní ntee yā ley yā. ");
INSERT INTO mieNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","De cuéé cā de nī sndóo ndá dē vehe ñúcuán nūū ndá sēhe dē jā cúu tatā ō. De nī nquīvi Josué jíín ndá tatā ō inī nación Israel yáhá, de suni nī jetíñú ndá dē vehe ñii ñúcuán. De nī ncundeé ndá dē jíín ndá nchivī jā ní īyo nación yáhá, de nī scúnu dē ji nī nsāhá Yāā Dios. De yáhá nī īyo vehe ñii jondē tiempo jā ní ncuu David rey. ");
INSERT INTO mieNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","De nī ncusiī inī Yāā Dios jíín David. De nī ncuu inī dē jā sāhá dē iin vehe īī maá yā nícu. De maá yā cúu Yāā Dios jā ní nchiñúhún tatā ō Jacob. ");
INSERT INTO mieNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sochi Salomón sēhe David cúu jā ní nsāhá vehe īī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","De vísō súcuán de maá Yāā cúñáhnú ndasí, nsūú maá-ni vehe jā sáhá ndá tēe cúu nūū ndéē yā. De suni súcuán nī ncāhān tēe jā ní nacani tūhun Yāā Dios jondē janahán: ");
INSERT INTO mieNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Chi nī ncāhān yā: Andiví cúu modo mesa nūū tátúnī ni, de ñayīví cúu modo nūū yósō jēhē ni. ¿Nāsa cā coo vehe jā sāhá ndá nú jā cundeē ni túsaá? ¿A ní cúu nūū sāhá nú nūū natātú nī? ");
INSERT INTO mieNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿A nsūú maá nī ní nsáhá ndihi jā íyó? ncachī Yāā Dios. Ncachī tēe jā ní nacani tūhun yā jondē janahán, ncachī Esteban. ");
INSERT INTO mieNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","De cáhān cā Esteban: Nīhin ndasí inī ndá ní. De cúu ní tá cúu nchivī ndācá nación jāá nduú cándíja tūhun yā, chi sóhó ndasí ndá ní. Chi cúsá maá jā jásī ndija ndá ní nūū Espíritu Santo, de tá-ni nī nsāhá ndīyi tatā ō jondē janahán suni súcuán sáhá īī cā ndá ní jondē mitan. ");
INSERT INTO mieNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿A nī īyo tēe jā ní nacani tūhun yā jondē janahán jāá nduú ní nsáhá nāvāha ndá tatā ō, á naá cúu? Nduú chi nī jahnī ndá dē ndá tēe jā ní nacani tūhun nāsa quiji maá Yāā ndāā. De tá nī nquiji Yāā ñúcuán de nī nastúu ndá ní yā nūū ndá tēe jā ní jahnī ndá dē yā. ");
INSERT INTO mieNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","De vísō ndá ángel yā nī jēhe ley Yāā Dios nūū ndācá ó de nduú ní squíncuu ndá ní, ncachī Esteban. ");
INSERT INTO mieNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ndācá tūhun yáhá nī jini ndá dē, de nī nquītī ndasí inī ndá dē, de nī nacayīhí ndá dē ñii yúhú dē nī jinī ndá dē Esteban. ");
INSERT INTO mieNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sochi maá Esteban chi nī nchitú Espíritu Santo inī ánō dē. De nī ndēhé vāha dē andiví, de nī jinī dē jā jéndūtē ndasí nūū ndéē Yāā Dios, de Jesús íñí yā ichi lado cuáhá Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","De nī ncāhān Esteban: Mitan de ndéhé sá jā núne andiví, de ndéhé sá nūū maá Yāā jā ní nduu tēe, de íñí yā ichi lado cuáhá Yāā Dios, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ñúcuán de nī jasī ndá dē sōho dē, de nī ncana cóhó ndá dē, de ndíta-ni nī ntiin ndá dē Esteban. ");
INSERT INTO mieNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","De nī ntavā ndá dē Esteban cuāhān ndá dē jíín dē yātā ñúū. De ndá tēe jā cúu testigo tūhún ñúcuán nī jaquīn ndá dē sōō dē nūū iin tēe suchí jā nání Saulo, de nī ncuun ndá dē yūū Esteban. ");
INSERT INTO mieNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","De juni cúun ndá dē yūū Esteban de nī jīcān táhvī dē nūū maá Jētohō ō: Tátā Jesús, mitan de naquehen ní ánō sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","De nī jēcuīñī jītí dē, de nī ncāhān jee dē: Tátā Yāā Dios, mā tēé ní cuāchi yáhá sīquī ndá ji jā sáhá nāvāha ji sāán mitan, ncachī dē. Súcuán nī ncāhān dē, de nī jīhī dē-ni. ");
INSERT INTO mieNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","De nī jetúhún Saulo jā ní jahnī ndá dē Esteban. De quīvī ñúcuán nī nquijéhé ndá ji sáhá nāvāha ndasí ndá ji ndá nchivī cándíja inī ciudad Jerusalén. De jā suu cúu jā ní jītē nuu ndá nchivī ñúcuán cuāhān ji níí región Judea jíín níí región Samaria. Sochi ndá tēe cúu apóstol chi nduú ní nquée ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","De ndá tēe jā íyó yíñúhún nūū Yāā Dios nī nchiyuhū ndá dē Esteban, de nī jacu ndasí ndá dē jā ní jīhī Esteban. ");
INSERT INTO mieNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","De Saulo chi sáhá nāvāha dē ndá nchivī jā cándíja nūū Jesús. Chi quívi dē ndá vehe, de tíin dē nchivī cúu tēe cúu ñahan, chíhi dē vecāa. ");
INSERT INTO mieNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","De ndācá nchivī ñúcuán jā ní jītē nuu, de ní-ni cuāhān ndá ji de nácani ndá ji tūhun Yāā Dios nāsa scácu yā nchivī. ");
INSERT INTO mieNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","De nī nquenda Felipe iin ñuū jā íyó inī Samaria, de nūū nchivī ñúcuán nī nacani dē tūhun Cristo jā cúu Yāā jā ní jani Yāā Dios jā scácu ndá yóhó. ");
INSERT INTO mieNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","De nī ndutútú ndá nchivī, de ndihi ndá ji nī nchuhun vāha inī ji ndācá tūhun jā ní ncāhān Felipe. Chi nī nini ji, de nī jinī ji ndācá tiñu ñáhnú jā ní nsāhá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Chi cuāhā nchivī jā ndóho tāchī nī nasāhá vāha dē ji, de tá quée tāchī inī ndá nchivī de cána cóhó de cuāhān. De cuāhā nchivī jā ní nduvehlé jíín nchivī cojo nī nduvāha nī nsāhá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","De nī ncusiī ndasí inī ndá nchivī ñuū ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","De inī ñuū ñúcuán íyó iin tēe nání Simón, de scuáha dē mágica. De tá ncháha ca quīhīn Felipe inī ñuū ñúcuán, de sáhvi ndasí inī ndá nchivī región Samaria ndéhé ji jā sáhá Simón. De stáhví dē ndá ji chi cáchī dē jā iin tēe cúñáhnú ndasí cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","De ndācá nchivī chúhun vāha inī ji tūhun jā cáhān dē, cúu nchivī cúñáhnú cúu nchivī jāá nduú. De nī ncāhān ndá ji: Tēe yáhá nī jēhe ndasí Yāā Dios poder nūū dē, ncachī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","De chúhun vāha inī ndá ji tūhun cáhān dē, chi cuāhā ndasí quīvī nī nsāhá dē ndá tiñu stáhví ñúcuán, de nī nsāhvi inī ndá ji nī ndēhé ji. ");
INSERT INTO mieNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","De tá nī nquenda Felipe de nī nacani dē tūhun vāha nāsa tátúnī Yāā Dios, jíín tūhun maá Jesucristo nūū ndá ji. Ñúcuán de nī ncandíja ndá ji, de nī jenduté ndá ji, cúu tēe cúu ñahan. ");
INSERT INTO mieNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","De suni nī ncandíja maá Simón, de nī jenduté dē. De nī jica dē jíín Felipe, de nī nsāhvi inī dē ndéhé dē jā ní nsāhá Felipe ndācá tiñu ñáhnú jíín tiñu jā stéhēn jā íyó poder Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","De ndá apóstol jā íyó Jerusalén, nī nīhīn dē tūhun jā ní ncandíja ndá nchivī Samaria tūhun Yāā Dios. Ñúcuán de nī ntají ndá dē Pedro jíín Juan nī jēhēn ndúū dē Samaria. ");
INSERT INTO mieNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","De nī nquenda ndúū dē ñúcuán. De nī jīcān táhvī ndúū dē jēhē ndá nchivī ñúcuán tácua ná níhīn ndá ji Espíritu Santo. ");
INSERT INTO mieNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Chi ncháha ca quīvi yā inī ánō ni iin ji, chi maá-ni jā ní jenduté ndá ji jā ní ncandíja ji Jētohō ō Jesús. ");
INSERT INTO mieNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ñúcuán de nī ntee ndúū dē ndahá dē xīnī ndá ji, de nī nquīvi Espíritu Santo inī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","De nī jinī Simón jā súcuán tée ndúū apóstol ndahá dē xīnī ndá nchivī ñúcuán de quívi Espíritu Santo inī ánō ji. De cúnī dē jā cuāha dē xūhún nūū apóstol nícu, tácua nīhīn dē poder jā sāhá dē súcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","De nī ncāhān dē: Suni taji ní poder yáhá nūū sá tácua nā-ni nchivī tee sá ndahá sá xīnī ji de quīvi Espíritu Santo inī ánō ji, ncachī Simón. ");
INSERT INTO mieNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ñúcuán de nī ncāhān Pedro jíín dē: De xūhún nú ná náā jíín nú sīquī jā jáni inī nū jā jíín xūhún de cuu cueen nú poder jā jínī mānī Yāā Dios nūū nchivī. ");
INSERT INTO mieNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nsūú tāhvī nū cúu jā cuiñi nú sīquī tiñu yáhá, chi nduú íyó ndāā ánō nū nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Túsaá de jíni ñúhún jā nacani inī nū sīquī jā jáni nēhén inī nū yáhá. De nācān táhvī nū nūū Yāā Dios, cúndēhé ó á sanaā de cune cáhnú inī yā sīquī jā jáni nēhén inī nū jā ní ncāhān nū súcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Chi jínī ni jā cúcuásún inī nū sīquī jā sáhá nī tiñu yáhá. De ndācá jā nēhén jā jáni inī nū cúu jā tíin nīhin ndóhó, ncachī Pedro jíín Simón. ");
INSERT INTO mieNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ñúcuán de nī ncāhān Simón jíín dē: Cācān táhvī ndúū ní jēhē sá nūū maá Jētohō ō tácua ni iin tūhun jā cáhān ní jīñā mā quījí sīquī sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","De nī nacani Pedro jíín Juan tūhun Yāā Dios nūū ndá nchivī. De nī ndicó cóo ndúū dē cuānohōn dē ciudad Jerusalén, de juni cuāhān ndúū dē de nácani dē tūhun vāha Yāā Dios inī cuāhā cā ndáñúū Samaria. ");
INSERT INTO mieNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ñúcuán de iin ángel maá Jētohō ō nī ncāhān yā jíín Felipe: Quehen ichi de quīhīn nū ichi sur, ichi jā quée inī ciudad Jerusalén jā cúun cuāhān jondē ñuū Gaza, ncachī yā. De maá-ni ñuhun tíhá cúu ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","De nī nquehen Felipe ichi cuāhān dē. De iin tēe eunuco nī nquee dē Jerusalén. De tēe nación Etiopía cúu dē, de ndíso tíñú dē jā cúu dē tesorero nūū ñahan cúu reina jā tátúnī nūū nación Etiopía, de nání ña Candace. De tēe ñúcuán nī jēhēn dē ciudad Jerusalén nī jēchiñúhún dē Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","De ñúhún dē inī carreta dē cuānohōn dē, de cáhvi dē tutū jā ní ntee Isaías, tēe nī nacani tūhun Yāā Dios jondē janahán. ");
INSERT INTO mieNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","De maá Espíritu nī ncāhān yā jíín Felipe: Cuáhán, de quetáhán nú jíín tēe jā cuáhān jíín carreta ñúcuán, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Sá de cuāhān Felipe de nī nquetáhán dē jíín tēe jā ñúhún inī carreta. De nī jini dē jā cáhvi tēe ñúcuán tutū jā ní ntee Isaías, tēe nī nacani tūhun yā jondē janahán. De nī jīcā tūhún dē tēe ñúcuán: ¿A jícūhun inī ní ndá jā cáhvi ní jīñā, á nduú? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","De nī ncāhān dē jíín Felipe: ¿De nāsa jīcūhun inī sá de tú mā stéhēn iin tēe nūū sá? ncachī dē. De nī ncāhān dē jíín Felipe jā ná cáa dē nūū carreta quīhīn ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","De maá nūū tútū īī jā cáhvi dē yósō tūhun jā cáhān: Tá cúu iin tīcāchí jā cuáhān nchivī jíín tī jā cuū tī, suni súcuán nī nsāhá ndá nchivī maá yā. De tá cúu iin tīcāchí lúlí jā sété dē tī de nduú ndáhyū tī, suni súcuán nī nsāhá maá yā, chi nduú ní ncáhān cuitī yā tá nī nsāhá nāvāha ji yā. ");
INSERT INTO mieNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","De hora jā ní jēhe ji tūhun canoō yā, de nduú ní nsáhá ndāā ji tiñu yā. De ni iin nchivī mā cūú cāhān ji tūhun tatā yā chi nī jahnī ndá ji yā de nduú nā tatā yā. Cáchī tutū. ");
INSERT INTO mieNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ñúcuán de nī ncāhān tēe Etiopía: De sāhá ní favor cachī ní nūū sá, ¿ní sīquī cáhān tēe nī nacani tūhun yáhá? ¿A sīquī maá dē, á sīquī incā tēe? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","De jíín tūhun jā ní ncahvi tēe Etiopía ñúcuán, nī nquijéhé Felipe cáchī tūhun dē ndācá tūhun vāha Jesús nūū dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","De juni ñúhún ndúū dē ichi cuāhān dē de nī nquenda dē nūū ñúhún ndute. De nī ncāhān tēe Etiopía: Yáhá ñúhún ndute, ¿de á cuu cuenduté sá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","De nī ncāhān Felipe: Cuu de tú cándíja ní jā ní nsāhá Jesús jēhē ō jondē jíín inī jíín ánō ní, ncachī dē. De nī ncāhān tēe Etiopía: Cándíja sá jā Jesucristo cúu maá Sēhe Yāā Dios, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","De nī jecani dē carreta dē. De nī nuu dē jíín Felipe, de nī nchunuu dē cuāhān dē nūū ñúhún ndute, de nī scuénduté Felipe tēe Etiopía. ");
INSERT INTO mieNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","De tá nī nquee ndúū dē inī ndute de Espíritu maá Jētohō ō nī nsāhá jíyo yā-ni Felipe cuāhān dē, de tēe Etiopía nduú cā ní jínī dē nūū Felipe. De nī naquehen dē ichi cuānohōn dē ñuū dē, de cúsiī ndasí inī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Sochi Felipe nī nquenda dē jondē Azoto, de sá de cuāhān tucu dē, de ndācá ñuū nī nacani dē tūhun vāha yā. De sá de nī nquenda dē ciudad Cesarea. ");
INSERT INTO mieNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","De Saulo nduú jéncuiñī dē jā cáhān nīhin dē jā cahnī dē ndá nchivī jā cándíja ji maá Jētohō ō. De jā ñúcuán cúu jā ní jēhēn dē nūū sūtū cúñáhnú cā. ");
INSERT INTO mieNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","De nī jīcān dē órden nūū tēe ñúcuán jā cuu quīhīn dē ndācá vehe īī sinagoga ñuū Damasco tácua cuu tiin dē cúu tēe cúu ñahan jā íñí sīquī tūhun yā, de quīnasiáha dē ji ciudad Jerusalén cúnī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","De nī nquehen dē ichi cuāhān dē, de nī ncuñatin dē yuhú ñúū Damasco. De sanaā-ni de nī jēndūtē ndasí níí nūū dē jā váji jondē andiví. ");
INSERT INTO mieNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","De nī ndicó cáva dē-ni nūū ñūhún. De nī jini dē jā cáhān iin tūhun jíín dē: Saulo, Saulo, ¿nājēhē cúu jā sáhá nāvāha nú nduhū? ncachī. ");
INSERT INTO mieNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ñúcuán de nī ncāhān dē: ¿Ní iin cúu ní, Señor? ncachī dē. De nī ncāhān yā: Maá nī cúu Jesús, de jā sáhá nāvāha nú ndá nchivī cándíja cúu jā sáhá nāvāha nú nduhū. De jā sáhá nú súcuán cúu jā sndóho nú maá nú modo stīquī jā jáñū yātá tī punta garrocha, de suu cúu jā sndóho tī maá tī, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","De quísi dē chi yúhú dē, de nī ncāhān dē: Señor, ¿naá cúu jā sāhá sá cúnī ní túsaá? ncachī dē. De maá Jētohō ō nī ncāhān yā jíín dē: Nacōo, de quīvi nú inī ñuū, de ñúcuán íyó iin tēe jā cachī dē nūū nū naá cúu jā jíni ñúhún sāhá nú, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","De ndá tēe jā cuáhān jíín Saulo, nī nsāhvi inī ndá dē níni dē jā cáhān, de nduú ní jínī dē nūū jā cáhān. ");
INSERT INTO mieNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ñúcuán de nī nacōo Saulo, de tá cúnī dē jā nūcūndēhé dē de nduú ní ncúu cuitī cā cūndēhé dē. De tíin ndá tēe ñúcuán-ni cā ndahá Saulo de cuāhān ndá dē ñuū Damasco. ");
INSERT INTO mieNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","De ñúcuán nī ndeē Saulo ūnī quīvī. De nduú ní ncúu cuitī cūndēhé dē, ni nduú ná nchájī cuitī dē de ni nduú ná jíhi dē. ");
INSERT INTO mieNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","De inī Damasco íyó iin tēe jā cándíja, de nání dē Ananías. De nī stéhēn maá Jētohō ō nūū dē, de nī ncāhān yā jíín dē: Ananías, ncachī yā. De nī ncāhān dē: Señor, ¿á jā cáhān ní? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","De nī ncāhān maá Jētohō ō jíín dē: Quehen ichi de quīhīn nū calle jā nání Calle Derecha. De vehe Judas cātūhún nú iin tēe nání Saulo, tēe ñuū Tarso, chi mitan de jícān táhvī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","De nī stéhēn ni nūū dē jā ní nquīvi iin tēe nání Ananías, jā cúu maá nú, de nī ntee dē ndahá dē xīnī Saulo, de nī ndunijīn tīnūú dē. Súcuán nī stéhēn ni nūū Saulo, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ñúcuán de nī ncāhān Ananías: Señor, ja nī jini sá jā cuāhā nchivī cáchī jā tēe ñúcuán sáhá nāvāha dē ndá nchivī jā cándíja ji ní jā íyó Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","De mitan nī nquenda dē yáhá ndíso tíñú dē nūū ndá sūtū cúñáhnú jā tiin dē ndācá nchivī jā chíñúhún ji ní, ncachī Ananías. ");
INSERT INTO mieNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","De nī ncāhān maá Jētohō ō: Cuáhán, chi tēe jā ní nacāji maá nī cúu Saulo, tácua ná quíhīn dē nacani dē tūhun nī nūū ndá táhán nú Israel jíín nūū nchivī ndá cā nación jíín nūū ndá rey. ");
INSERT INTO mieNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","De stéhēn ni nūū dē jā cánuú cúu jā cundoho ndasí dē tūndóhó jā síquī ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ñúcuán de cuāhān Ananías, de tá nī nquenda dē vehe nūū íyó Saulo, de nī nquīvi dē de nī ntee dē ndahá dē xīnī Saulo, de nī ncāhān dē: Hermano Saulo, maá Jētohō ō Jesús, Yāā jā ní nquenda nijīn nūū nū ichi nūū váji nú, suu yā nī ntají nduhū vāji nī nūū nū tácua ndunijīn tīnūú nú, de chitú Espíritu Santo yā inī nū, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","De ndañúhún-ni nī ndunijīn tīnūú Saulo, chi modo jā ní ncōyo-ni jā ní ndasī tīnūú dē. De nī nacuiñī dē, de nī jenduté dē-ni. ");
INSERT INTO mieNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ñúcuán de nī nacajī dē stāā, de nī nanihīn inī dē. De nī īyo dē jacū quīvī jíín ndá nchivī jā cándíja inī ñuū Damasco. ");
INSERT INTO mieNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","De nī nquijéhé dē-ni nácani dē tūhun Jesús inī ndá vehe īī sinagoga, cáchī dē jā Jesús cúu Sēhe Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","De ndācá nchivī jā ní jini tūhun jā cáhān dē, sáhvi inī ji níni ji. De nī ncāhān ndá ji: ¿A nsūú tēe yáhá cúu jā sáhá nāvāha dē ndá nchivī Jerusalén jā chíñúhún nūū Jesús? De suu cúu jā ní nquiji dē yáhá jā tiin dē ndá nchivī quīhīn dē jíín ji nūū ndá sūtū cúñáhnú cúnī dē, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sochi Saulo chi sa víhí cā nácani dē tūhun jā Jesús cúu ndija Cristo, Yāā jā ní jani Yāā Dios jā scácu yóhó. De ndá táhán dē hebreo jā ndéē Damasco ni iin tūhun nduú ní ncúu scócóo ji jā cachī ji jāá nduú íyó ndāā tūhun jā cáhān Saulo. ");
INSERT INTO mieNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","De nī ncuu cuahā cā quīvī. De nī squétáhán ndá táhán dē hebreo tūhun jā cahnī ndá dē Saulo. ");
INSERT INTO mieNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","De nī nīhīn Saulo tūhun jā súcuán nī squétáhán ndá dē tūhun. De nduú ñuú jíto dē viéhé namā jā ndásī yuhú ñúū, chi cahnī dē Saulo cúnī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ñúcuán de ndá tēe cándíja, nī nchuhun dē Saulo inī iin tīcá iin jacuáā, de nī snúu ndá dē yīcā namā jā ndásī yuhú ñúū, de súcuán nī ncācu Saulo. ");
INSERT INTO mieNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","De tá nī nenda dē ciudad Jerusalén de cúnī dē jā naquetáhán dē jíín ndá nchivī cándíja. Sochi nī nchūhú ndá ji nī jinī ji Saulo, chi nduú ní ncándíja ndá ji jā ní nduu dē tēe cándíja. ");
INSERT INTO mieNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","De Bernabé nī jeca dē Saulo cuāhān dē jíín nūū ndá apóstol. De nī nacani dē tūhun nūū ndá tēe ñúcuán nāsa nī jinī Saulo nūū maá Jētohō ō ichi nūū ní jēhēn dē, jíín nāsa nī ncāhān yā jíín dē, jíín nāsa nī īyo ndeé inī dē nī nacani dē tūhun Jesús inī ñuū Damasco. ");
INSERT INTO mieNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","De nī ndeē Saulo inī ciudad Jerusalén de nī jica dē jíín ndá apóstol. ");
INSERT INTO mieNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","De vāha nī īyo ndeé inī dē nī nacani dē tūhun maá Jētohō ō. De jā síquī Jesús de nī stíchī tāhán dē jíín ndá tēe hebreo jā cáhān yuhú griego. Sochi ndá tēe ñúcuán cúnī dē jā cahnī dē Saulo nícu. ");
INSERT INTO mieNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","De nī jinī ndá hermano cándíja jā súcuán cúnī dē sāhá dē, de nī jeca ndá dē Saulo cuāhān dē jíín jondē ciudad Cesarea. De ñúcuán de nī nachuhun ichí ndá dē Saulo cuānohōn dē jondē ñuū maá dē Tarso. ");
INSERT INTO mieNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","De nduú cā ní nsáhá nāvāha ndá ji ndá nchivī cándíja níí inī región Judea jíín Galilea jíín Samaria. De nī jija cā ndá ji jíín tūhun yā, de nī īyo yíñúhún ndá ji nūū maá Jētohō ō. De nī ncucuahā cā ndá ji, chi nī nchindeé maá Espíritu Santo ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","De Pedro jéndēhé dē ndá nchivī cándíja ndācá lado, de suni nī jēndēhé dē nchivī jā ndéē ñuū Lida. ");
INSERT INTO mieNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","De ñúcuán nī jinī dē nūū iin tēe nání Eneas jā ní ncuu ūnā cuīyā cáá dē, chi nī nduvehlé dē. ");
INSERT INTO mieNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","De nī ncāhān Pedro jíín dē: Eneas, ná ndúvāha ní sāhá Jesucristo. Nacōo ní de nastúū ní yuu ní, ncachī dē. De nī nacōo-ni tēe ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","De nī jinī ndācá nchivī ñuū Lida jíín nchivī jā ndéē nduhvā Sarón, de nī nasāma inī ndá ji de nī ncandíja ndá ji maá Jētohō ō. ");
INSERT INTO mieNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","De suni nī īyo iin ñahan jā cándíja inī ñuū Jope, nání ña Tabita, de yuhú griego nání ña Dorcas. De sáhá ndasí ña tiñu váha, de sáhá ña caridad nchivī ndāhví. ");
INSERT INTO mieNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","De tiempo ñúcuán nī ncuhū ña, de nī jīhī ña. De nī scúchi ndá ji ndīyi ñúcuán, de nī jaquīn ji ña iin cuarto xīnī vēhé. ");
INSERT INTO mieNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","De ñuū Lida chi ñatin-ni íyó jíín Jope. De ndá nchivī cándíja jā ndéē ñuū Jope, nī nīhīn ji tūhun jā ndéē Pedro ñuū Lida. De nī ntají ndá ji ūū tēe jā cuácāna dē Pedro. De nī ncāhān ndúū dē: Mā cúcuéé ní, de cōhōn ñuū Jope, ncachī ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ñúcuán de nī nquehen Pedro ichi cuāhān dē jíín ndúū tēe ñúcuán. De tá nī nenda ndúū dē jíín Pedro de nī ncaa ndá dē cuarto nūū cáá ndīyi ñúcuán. De ndá ñahan viuda nī jicó ndúū ndá ña Pedro, de jácu ndá ña. De stéhēn ndá ña ndá xīquīn jíín ndá páñū jā ní nsāhá ndīyi Dorcas chi nī jinī mānī ña nūū ndá ñahan ñúcuán tá nī ntecū ña. ");
INSERT INTO mieNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ñúcuán de nī ncāhān Pedro jíín ndá nchivī jā ná quée ndá ji tāvēhé. De nī jēcuīñī jītí dē, de nī jīcān táhvī dē. De nī ndicó cóto dē nūū cáá ndīyi ñúcuán, de nī ncāhān dē: Tabita, nacōo, ncachī dē. De nī nūcūndēhé ña-ni, de nī jinī ña nūū Pedro. De nī nacōo ña-ni nī nūcundeē ña. ");
INSERT INTO mieNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","De nī ntiin dē ndahá ña, de nī stácuiñī dē ña. Ñúcuán de nī nacana dē ndācá nchivī cándíja jíín ndācá ñahan viuda, de nī stéhēn dē ña nūū ndá ji jā ní natecū ña. ");
INSERT INTO mieNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","De tūhun yáhá nī jītē nuu níí ñuū Jope cuāhān. De cuāhā nchivī nī ncandíja nūū maá Jētohō ō. ");
INSERT INTO mieNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","De cuāhā quīvī nī ndeē Pedro inī ñuū Jope, ndéē dē vehe iin tēe sátíñú ñii jā nání Simón. ");
INSERT INTO mieNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","De inī ciudad Cesarea íyó iin tēe nání Cornelio, de cúu dē iin capitán grupo soldado jā nání Italiano. ");
INSERT INTO mieNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tēe chíñúhún vāha nūū Yāā Dios cúu dē, de saá-ni ndācá nchivī vehe dē. De sáhá ndasí dē caridad nchivī hebreo vísō nsūú tēe hebreo cúu dē, de níní jícān táhvī dē nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","De iin quīvī nī stéhēn iin ángel Yāā Dios nūū dē tá cahūnī jañíni, de cájí nī jinī dē jā ní nquīvi ángel ñúcuán nūū ndéē dē. De nī ncāhān yā jíín dē: Cornelio, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","De nī nūcūndēhé vāha dē nūū yā, de yúhú dē. De nī ncāhān dē: ¿A jā cáhān ní, Señor? ncachī dē. De nī ncāhān yā jíín dē: Ja née Yāā Dios cuenta nāsa jícān táhvī nū nāsa sáhá nú caridad ndá nchivī hebreo. ");
INSERT INTO mieNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mitan de tetíñú nú mozo ná quíhīn ndá ji ñuū Jope de cana ji Simón, tēe nání Pedro, quiji dē. ");
INSERT INTO mieNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Chi ndéē nūú dē vehe iin tēe nání Simón, tēe sátíñú ñii. De ñatin-ni yuhú mar cáá vehe dē. De cachī maá Pedro nūū nū nā incā cúu jā cánuú sāhá nú, ncachī yā jíín Cornelio. ");
INSERT INTO mieNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","De tá cuāhān ángel jā ní ncāhān jíín dē, de nī ncana dē ūū mozo dē jíín iin soldado jā squíncuu vāha nūū dē, de suni tēe chíñúhún vāha nūū Yāā Dios cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","De nī nacani Cornelio ndācá tūhun ñúcuán nūū ndá dē, de nī ntají dē ndá cuāhān jondē ñuū Jope. ");
INSERT INTO mieNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","De quīvī téēn de ñúhún ndá dē ichi cuāhān dē, de nī ncuñatin dē ñuū Jope. De ja ñatin cuu cahūxī ūū, de hora ñúcuán nī ncaa Pedro cuācācān táhvī dē xīnī vēhé. ");
INSERT INTO mieNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","De cajī dē stāā cúnī dē, chi cócon ndasí dē. De juni sáhá ndá ña jā cajī dē de nī stéhēn nūū dē jā ní nune-ni andiví. ");
INSERT INTO mieNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","De nī jinī dē iin jā cáá tá cáá manta cāhnú nī ncuun vāji ichi andiví jondē nūū ñūhún, de modo jā núhnī ndicúmī squínā, de nī ncuun. ");
INSERT INTO mieNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","De inī ñúcuán ñúhún ndá quiti jíca ndicumī jíín cōō jíín quiti ndáva. ");
INSERT INTO mieNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","De nī jini dē jā ní ncāhān iin tūhun: Pedro, nacuiñī de cahnī nū quiti jīñā, de cajī nū tī, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","De nī ncāhān Pedro: Mā cājí sá, Señor, chi nduú yájī cuitī sá ndá quiti jā cáhān ley Moisés jāá nduú vāha cajī sá tī chi modo jāá nduú íyó ndoo tī nūū ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","De nī ncāhān tucu: Jā cáchī ni cúu jā íyó vāha cajī nū ndá quiti jīñā, chi nī nsāhá ndoo maá nī, de mā cáhān nū jāá nduú íyó ndoo tī, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","De súcuán nī ncāhān tūhun yáhá ūnī vuelta. De sahma ñúcuán nī ndaa-ni cuānohōn andiví. ");
INSERT INTO mieNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","De juni jáni ndasí inī Pedro sīquī ndá jā ní stéhēn nūū dē de nī nquenda-ni ndá mozo jā ní ntetíñú Cornelio, chi jícā tūhún jícā tūhún ndá ji vehe Simón jondē nī nquenda ji viéhé nūū ndéē dē. ");
INSERT INTO mieNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","De nī ncāhān jee ndá ji nī jīcā tūhún ndāā ji de tú ñúcuán ndéē Simón, tēe nání Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","De juni nácani inī Pedro sīquī ndá jā ní stéhēn nūū dē de nī ncāhān maá Espíritu Santo jíín dē: Nī nquenda ūnī tēe jā nánducú ndá dē ndóhó. ");
INSERT INTO mieNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nacuiñī, de nuu nú, de mā cāní inī nū jāá nduú vāha quīhīn nū jíín ndá dē, vísō nsūú táhán nú hebreo cúu dē. Chi maá nī nī ntetíñú ndá dē vāji dē, ncachī yā. Jā suu cúu jā ní stéhēn yā nūū dē jā cuu cajī dē nā-ni quiti, de tūhun ñúcuán cáhān jā cuu quīhīn dē nūū nchivī incā nación. ");
INSERT INTO mieNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ñúcuán de nī nuu Pedro nī nquenda dē nūū mozo jā ní ntetíñú Cornelio, de nī ncāhān dē: Maá sá cúu tēe jā nánducú ndá ní. ¿Nā tiñu cúnī ndá ní jā váji ní nūū sá túsaá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ñúcuán de nī ncāhān ndá mozo: Cornelio, tēe cúu capitán, nī ntají dē ndá sāán vāji ndá sá. Chi cúu dē tēe ndāā, de chíñúhún vāha dē nūū Yāā Dios. De saá-ni nchivī hebreo suni cáhān ndá ji jā tēe vāha cúu dē. De nī ncāhān iin ángel yā jíín dē jā cana dē ní quīhīn ní vehe dē, de cunini dē tūhun jā cāhān ní jíín dē, ncachī mozo. ");
INSERT INTO mieNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ñúcuán de nī squívi Pedro ndá mozo inī vehe nī nquendōo ndá ji. De quīvī téēn de nī nquehen dē ichi jíín ndá mozo cuāhān dē. De suni cuāhān jacū hermano cándíja jā ndéē ñuū Jope jíín dē. ");
INSERT INTO mieNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","De incā quīvī nī nquenda ndá dē ciudad Cesarea. De ndétu Cornelio ndá dē, chi nī nastútú dē ndá táhán dē jíín ndá amigo vāha dē. ");
INSERT INTO mieNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","De tá nī nquenda Pedro de nī nquee Cornelio jā cāhān dē jíín Pedro. De nī jēcuīñī jītí dē jā chiñúhún dē Pedro nícu. ");
INSERT INTO mieNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","De nī stácuiñī Pedro dē, de nī ncāhān dē: Nacuiñī ní, chi saá-ni sāán suni iin tēe-ni cúu sá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","De juni súcuán nátúhún ndúū dē de nī nquīvi-ni ndúū dē inī vehe. De nī jinī Pedro jā ní ncutútú cuāhā nchivī ndéē ji inī vehe. ");
INSERT INTO mieNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","De nī ncāhān Pedro jíín ndá nchivī ñúcuán: Ja jínī ndá ní nāsa cúu ley ndá sāán nchivī hebreo jā má cūú quetáhán ndá sá jíín ndá ní jā cúu nchivī incā nación de ni mā cūú quīvi sá vehe ndá ní. Sochi nī stéhēn Yāā Dios nūū sá jā má cōó cā súcuán, chi mā cūú cujéhe inī sá nūū nchivī ndá cā nación. ");
INSERT INTO mieNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","De jā suu cúu jā tá nī ncana ní sāán de vāji sá-ni, chi nduú ní nsáhá jéhe inī sá vísō cúu ndá ní nchivī incā nación. De mitan de jícā tūhún sá ní ¿nā sīquī cúu jā cána ní sāán? ncachī Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ñúcuán de nī ncāhān Cornelio: Ja nī ncuu cūmī quīvī jā ní īyo nditē inī sá maá hora yāhá jā cúu cahūnī jañíni, de jícān táhvī sá inī vehe sá. De nī nquenda iin ángel yā nūū sá jā cáá tá cáá tēe, de xíñū sahma ñúhún yā. ");
INSERT INTO mieNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","De nī ncāhān yā: Cornelio, ja née Yāā Dios cuenta nāsa jícān táhvī nū nāsa sáhá nú caridad nchivī. ");
INSERT INTO mieNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Túsaá de tetíñú nú ndá mozo ná quíhīn ñuū Jope cana ji Simón, tēe nání Pedro, quiji dē nūū nū. De tēe ñúcuán ndéē dē vehe Simón, tēe sátíñú ñii, de ñatin yuhú mar cáá vehe dē. De quiji tēe ñúcuán de cachī tūhun dē nūū nū nāsa cánuú sāhá cā nū, ncachī yā jíín sá. ");
INSERT INTO mieNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jā suu cúu jā ní ntetíñú sá-ni ndá mozo sá jā ní jēcāna ji ní. De ná cútahvī ō nūū ní jā váji ní, chi vāha nī nsāhá ní. De mitan íyó tútú ndācá sá nūū Yāā Dios tácua cunini ndá sá ndihi tūhun jā cāhān ní nāsa nī ntatúnī yā nūū ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ñúcuán de nī ncāhān Pedro: Mitan de nī jinī ndāā sá jā Yāā Dios inuú-ni sáhá yā cuenta ndācá-ni nchivī, cúu nchivī hebreo jíín nchivī ndá cā nación. ");
INSERT INTO mieNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","De nā-ni nchivī ndācá-ni nación tú íyó yíñúhún ji nūū yā de sáhá vāha ji, de cúsiī inī yā jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nī ncāhān yā jíín ndá sá nchivī Israel, chi nī ntetíñú yā tūhun vāha nī nquiji nūū sá jā ndumanī ō jíín yā sāhá maá Jesucristo. De maá yā cúu Jētohō ndācá ó. ");
INSERT INTO mieNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","De ja jínī ndá ní nāsa nī ncuu. Chi nī nacani Juan tūhun yā de nī scuénduté dē nchivī, de ñúcuán de nī nquijéhé Jesús nácani yā tūhun jondē región Galilea, de nī jītē nuu tūhun yā níí nūū ndá sá nchivī hebreo. ");
INSERT INTO mieNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","De jínī ndá ní jā ní jēhe Yāā Dios Espíritu Santo jíín poder nūū Jesús, Yāā jā ní jahnu Nazaret. De jínī ndá ní jā ní jica nuu yā nī nsāhá yā tiñu váha, de nī nasāhá vāha yā ndācá nchivī jā ndóho ji sáhá tāchī cúñáhnú. Chi Yāā Dios nī nchindeé nī nchituu yā Jesús. ");
INSERT INTO mieNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","De ndá máá sá cúu jā ní jinī ndācá tiñu jā ní nsāhá Jesús inī ciudad Jerusalén jíín ndá cā ñuū jā íyó inī Judea, de nácani sá nūū nchivī. Ñúcuán de nī jahnī ndá ji yā chi nī jata caa ndá ji yā yīcā cruz. ");
INSERT INTO mieNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Sochi Yāā ñúcuán chi nī natecū yā nūū únī quīvī nī nsāhá Yāā Dios, de nī stéhēn nijīn yā maá yā nūū ndá sá nī nsāhá Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Sochi nduú ní stéhēn nijīn yā maá yā nūū ndá cā nchivī, chi nūū ndá máá sá-ni. De jondē tá ncháha ca coo ndá tiñu ñúcuán de nī nacāji Yāā Dios ndá sāán jā cuu ndá sá testigo yā, chi nī nchajī ndá sá nī jihi ndá sá jíín yā tá nī natecū yā. ");
INSERT INTO mieNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","De nī ndacu yā nūū ndá sá jā ná nácani ndá sá tūhun yā nūū ndá nchivī, de ná cáhān ndāā sá jā ní jani Yāā Dios Jesús jā sāhá ndāā yā tiñu ndá nchivī técū jíín nchivī ja nī jīhī. ");
INSERT INTO mieNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Chi tūhun Jesús nī ncāhān ndācá tēe nī nacani tūhun Yāā Dios jondē janahán. Chi nī ncāhān ndá dē jā ndācá nchivī jā cándíja ji Jesús de cune cáhnú inī Yāā Dios nūū cuáchi ji, ncachī Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","De juni cáhān cā Pedro ndācá tūhun yáhá de nī nquīvi-ni Espíritu Santo inī ánō ndá nchivī níni tūhun jā cáhān dē. ");
INSERT INTO mieNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","De ndá tēe hebreo jā cándíja jā ní jēhēn jíín Pedro, nī nsāhvi inī ndá dē nī jinī dē jā suni nī nquīvi Espíritu Santo inī ánō nchivī incā nación. ");
INSERT INTO mieNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Chi nī jini ndá dē jā cáhān ndá nchivī ñúcuán síín síín yuhú, de cáhān ndá ji jā cúñáhnú ndasí Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ñúcuán de nī ncāhān Pedro: Ni iin mā cūú casī jā cuenduté ndá nchivī yáhá. Chi suni nī nquīvi Espíritu Santo inī ánō ndá ji tá-ni nī nquīvi yā inī ánō maá ó, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","De nī ncachī dē jā ná cuénduté ndá ji sīquī jā ní ncandíja ji Jesucristo. Ñúcuán de nī ncāhān ndāhví ndá ji jíín Pedro jā ná quéndōo dē jíín ndá ji jacū quīvī. ");
INSERT INTO mieNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","De ndá tēe apóstol jíín ndá hermano cándíja jā ndéē región Judea, nī jini ndá dē tūhun jā suni nī ncandíja ndá nchivī incā nación tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","De tá nī nenda Pedro ciudad Jerusalén de sava tēe hebreo jā cándíja nī ncāhān dē nūū Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Chi nī ncachī ndá dē: ¿De nūcu nī nquīvi nú inī vehe ndá tēe jāá nsūú nchivī nación maá ó cúu? De nī nchajī nū stāā jíín ndá dē, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ñúcuán de nī nacani cájí Pedro nāsa nī nquijéhé yā sáhá yā jíín nchivī ndá cā nación: ");
INSERT INTO mieNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","De ndéē ni ñuū Jope de juni jícān táhvī ni de nī stéhēn yā iin jā ní jinī ni. De nī jinī ni iin jā cáá tá cáá manta cāhnú de núhnī ndicúmī squínā, de jondē ichi andiví nī ncuun vāji nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","De nī ndēhé vāha nī inī sahma ñúcuán, de nī jinī ni jā ñúhún ndá quiti jíca ndicumī jíín quiti xéēn jíín cōō jíín quiti ndáva. ");
INSERT INTO mieNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","De nī jini nī iin tūhun jā ní ncāhān: Pedro, nacuiñī de cahnī nū quiti jīñā, de cajī nū tī, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","De nī ncāhān ni: Mā cājí sá, Señor, chi nduú yájī cuitī sá ndá quiti jā cáhān ley Moisés jāá nduú vāha cajī sá tī chi modo jāá nduú íyó ndoo tī nūū ní, ncachī ni. ");
INSERT INTO mieNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Sochi tūhun ñúcuán nī ncāhān tucu jondē andiví: Jā cáchī ni cúu jā íyó vāha cajī nū ndá quiti jīñā, chi nī nsāhá ndoo maá nī, de mā cáhān nū jāá nduú íyó ndoo tī, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","De súcuán nī ncāhān ūnī vuelta, sá de nī ndaa-ni sahma cuānohōn ichi andiví. ");
INSERT INTO mieNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","De hora ñúcuán nī nquenda-ni ūnī tēe vehe nūū ndéē ni jā nánducú ndá dē nduhū. De iin tēe jā ndéē ciudad Cesarea nī ntetíñú dē ndá tēe ñúcuán jēē dē nūū ni. ");
INSERT INTO mieNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","De maá Espíritu nī ncāhān yā jíín nī jā quíhīn ni jíín ndá dē, chi mā cāní inī ni jāá nduú vāha quīhīn ni jíín dē vísō cúu dē nchivī incā nación. De suni nī jēhēn īñū hermano yáhá jíín nī, de nī nquīvi ndá nī inī vehe tēe ñúcuán jā nání Cornelio. ");
INSERT INTO mieNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","De tēe ñúcuán nī nacani dē tūhun nūū ndá nī jā ní jinī dē iin ángel yā íñí yā inī vehe dē, de nī ncāhān yā jíín dē: Tetíñú nú mozo ná quíhīn ji ñuū Jope de cana ji Simón, tēe nání Pedro, quiji dē. ");
INSERT INTO mieNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","De tēe ñúcuán nacani dē tūhun nūū nū nāsa cācu nú jíín níí nchivī vehe nú, ncachī ángel jíín Cornelio. ");
INSERT INTO mieNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","De tá nī nquijéhé nī cáhān ni de nī nquīvi Espíritu Santo inī ánō ndá ji tá cúu nūū ní nquīvi yā inī ánō maá ó jā xíhna ñúhún. ");
INSERT INTO mieNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ñúcuán de nī nūcūhun inī ni tūhun jā ní ncāhān maá Jētohō ō: Jāndáā jā jíín ndute-ni nī scuénduté Juan nchivī, sochi ndá ndóhó chi cuāha nī Espíritu Santo inī ánō ndá nú, de ñúcuán cúu jā cuenduté ndá nú sāhá nī, ncachī yā, ncachī Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","De cáhān cā Pedro: De sīquī jā ní jēhe Yāā Dios Espíritu Santo yā inī ánō ndá ji tá-ni nī jēhe yā inī ánō maá ó jā cándíja ó Jētohō ō Jesucristo ¿de nūcu casī ni jā sáhá maá yā túsaá? ncachī Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Súcuán nī jini ndá dē tūhun yáhá, de nduú cā ní ncáhān ndá dē nūū Pedro, chi sa nī ncāhān dē jā cúñáhnú ndasí Yāā Dios. Chi nī ncāhān ndá dē: Suni nī jēhe Yāā Dios tūhun jā nacani inī nchivī incā nación jā sndóo ji cuāchi ji tácua cutecū ji níí cání túsaá, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","De quīvī jā ní jahnī ndá dē Esteban inī ciudad Jerusalén de nī nquijéhé dē sáhá nāvāha dē nchivī cándíja. De jā ñúcuán cúu jā ní jītē nuu ndá ji cuāhān ji ndá cā ñuū de nī nquenda ji región Fenicia jíín isla Chipre jíín ñuū Antioquía. De nūū maá-ni táhán ji hebreo nī nacani ndá ji tūhun yā, chi nduú ní nácani ji nūū ndá cā nchivī. ");
INSERT INTO mieNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Sochi māhñú ndá nchivī jā ní jītē nuu nī īyo jacū tēe cándíja jā ní nquiji isla Chipre jíín jondē ñuū Cirene. De nī nquenda ndá dē Antioquía, de suni nī nacani ndá dē tūhun vāha maá Jētohō ō Jesús nūū nchivī jāá nsūú nchivī hebreo cúu. ");
INSERT INTO mieNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","De maá Jētohō ō nī nchindeé nī nchituu yā ndá dē. De nī nasāma inī cuāhā nchivī nī ncandíja ji maá Jētohō ō Jesús. ");
INSERT INTO mieNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","De ndá nchivī cándíja ciudad Jerusalén nī nīhīn ndá ji tūhun yáhá, de nī ntají ndá ji Bernabé cuāhān dē jondē Antioquía. ");
INSERT INTO mieNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","De Bernabé tá nī nquenda dē ñuū ñúcuán de nī jinī dē jā vāha ndasí nī nsāhá Yāā Dios ji, de nī ncusiī ndasí inī dē. De nī ncāhān nīhin dē jíín ndá nchivī ñúcuán jā jondē jíín inī jíín ánō ji ná cuíñi nīhin ji jíín maá Jētohō ō, de mā náyūhú ji. ");
INSERT INTO mieNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Chi tēe vāha cúu Bernabé, de nī nchitú Espíritu Santo inī ánō dē, de cándíja nīhin dē yā. De nī ncandíja cuāhā nchivī nūū maá Jētohō ō nī nsāhá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ñúcuán de nī nquee Bernabé cuāhān dē jondē ñuū Tarso cuānanducú dē Saulo. De nī nanihīn dē Saulo, de ndéca dē tēe ñúcuán nī nenda ndúū dē ñuū Antioquía. ");
INSERT INTO mieNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","De níí iin cuīyā nī natacā ndúū dē jíín ndá nchivī jā cándíja ñuū ñúcuán, de nī stéhēn ndúū dē tūhun yā nūū cuāhā nchivī. De xihna ñúhún Antioquía nī jīcunaní ji cristiano sīquī jā ní ncandíja ji Cristo. ");
INSERT INTO mieNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","De ndá quīvī ñúcuán nī nquee ndá tēe nácani tūhun Yāā Dios ciudad Jerusalén, nī nquenda dē jondē Antioquía. ");
INSERT INTO mieNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","De iin táhán dē jā nání Agabo nī nacuiñī dē nūū ndá hermano cándíja. De nī stéhēn Espíritu Santo nūū dē, de nī ncachī tūhun dē jā quiji iin tāmā xéēn níí cáhnú ñayīví. De tāmā ñúcuán nī nquiji tiempo jā ní ntatúnī rey Claudio. ");
INSERT INTO mieNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ñúcuán de nī natúhún ndá nchivī cándíja ñuū Antioquía jā tetíñú ji jā cutecū ndá hermano cándíja jā íyó ichi Judea, tú nāsaa quenda cuāha iin iin ji. ");
INSERT INTO mieNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","De súcuán nī nsāhá ji, de nī ntetíñú ndá ji Bernabé jíín Saulo cuāhān ndúū dē región Judea cuāsiáha ndúū dē nūū ndá tēe ñáhnú jā ndíso tíñú nūū nchivī cándíja. ");
INSERT INTO mieNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","De maá tiempo ñúcuán de nī nquijéhé rey Herodes nī nsāhá nāvāha dē sava nchivī cándíja. ");
INSERT INTO mieNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","De nī ndacu dē jā Jacobo ñanī Juan ná cúū dē jíín espada. ");
INSERT INTO mieNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","De tá nī jinī dē jā ní ncusiī inī ndá nchivī hebreo jā ní nsāhá dē súcuán de jā suu cúu jā ní ntiin dē Pedro. De ndá quīvī ñúcuán nī īyo vico jā yájī nchivī hebreo stātílā jāá nduú nā levadura yíhí. ");
INSERT INTO mieNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","De tá nī ntiin dē Pedro, de nī nchihi dē tēe ñúcuán vecāa. De nī jani dē cūmī grupo soldado jā jíto Pedro, de iin iin grupo íñí cūmī cūmī soldado. De cúnī Herodes jā tavā dē Pedro vecāa nūū ndá nchivī tá nī nchāha vico pascua ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Súcuán nī ncuu jā yíhí Pedro vecāa, de jíto vāha ji dē. Sochi ndá nchivī cándíja nī jīcān táhvī ndasí ji nūū Yāā Dios jēhē Pedro jā yíhí dē vecāa. ");
INSERT INTO mieNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","De jáni inī Herodes jā incā quīvī de tavā dē Pedro vecāa nūū ndá nchivī cuāhā. De jacuáā ñúcuán quíxīn Pedro inī vecāa māhñú ūū soldado, núhnī dē ūū cadena. De suni íñí soldado viéhé cāa jíto ndá dē Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","De jacuáā ñúcuán de sanaā-ni de nī nquenda iin ángel maá Jētohō ō, de nī ndunihni ndasí inī vecāa. De nī scándā yā Pedro nī sndóto yā dē, de nī ncāhān yā: Ñamā nacōo nú, ncachī yā. De ndúū cadena jā núhnī ndahá dē ñúcuán, nī nandajī-ni de nī nincava-ni. ");
INSERT INTO mieNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","De nī ncachī ángel yā jíín dē: Nachihi vāha chījin nú, de nūquīhi nú nījān nū, ncachī yā. De súcuán nī nsāhá dē, de nī ncāhān tucu ángel: Cunijin sōō nū, de cuniquīn nduhū ná cóhōn, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","De nī jēcuniquīn dē yā cuāhān dē jíín yā. De jáni inī dē jāá nsūú jāndáā cúu jā ní nsāhá ángel yā jíín dē, chi jáni inī dē jā iin jā stéhēn nūū dē cúu. ");
INSERT INTO mieNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","De nī nchāha yā jíín dē ūū ñucūn soldado jā jíto viéhé cāa. De nī nquenda dē viéhé cāa sándīhí, de īī-ni nī nune, de nī nquee dē jíín yā. De nī nchāha yā jíín dē iin calle cuāhān dē. Ñúcuán de nī ndoñúhún-ni ángel yā nūū dē cuāhān yā. ");
INSERT INTO mieNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","De nī nducájí vāha Pedro, de nī ncāhān maá nī ncāhān iin dē: Mitan de nī jinī ndāā ni jā ní ntají maá Jētohō ni ángel yā nī nquiji, de nī scácu yā nduhū nūū Herodes jíín nūū ndá táhán nī hebreo jā cúnī ndá ji jā sāhá nāvāha ji nduhū nícu, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","De tá nī jinī dē jā ní ncācu ndija dē de nī nquehen dē ichi cuāhān dē vehe María naná Juan, tēe nání Marcos. De ñúcuán íyó tútú cuāhā nchivī jícān táhvī ji jēhē Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","De nī ncāhān Pedro viéhé tāvēhé, de cuāhān iin ñahan lúlí nání Rode jā cuácunini ji cúndēhé ó ní iin nchivī cúu jā cáhān. ");
INSERT INTO mieNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","De nī nacunī ji tāchī Pedro. De jā cúsiī inī ji de nduú ní nácune ji viéhé, chi jínu ji nī ndicó cóo ji cuānohōn ji inī cuarto nūū ndéē ndá nchivī, de nī ncachī tūhun ji jā íñí Pedro viéhé tāvēhé. ");
INSERT INTO mieNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","De nī ncāhān ndá jíín ji: Jā cáhān naā nū, ncachī ndá nchivī. Sochi maá ji chi nīhin nī ncāhān ji jā maá dē cúu, ncachī ji. Ñúcuán de nī ncāhān tucu ndá ji: Anō Pedro cúu túsaá, ncachī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Sochi Pedro víhí cā cáhān dē. De tá nī nacune ndá ji viéhé de nī nacunī ndá ji nūū dē, de nī nsāhvi inī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","De nī nsāhá maá dē seña jā má cáhān cā ji. De nī nacani dē nāsa nī nsāhá maá Jētohō ō jā ní ntavā ángel yā dē vecāa. De nī ncāhān dē: Cachī tūhun ndá nú ndá tūhun yáhá nūū Jacobo jíín nūū ndá cā hermano cándíja, ncachī dē. Sá de nī nquee dē cuāhān dē incā lugar. ");
INSERT INTO mieNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","De tá nī ncunijīn quīvī ñúcuán de nī ncuvaā ndasí ndá soldado jāá nduú cā Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","De Herodes nī ndacu dē nūū ndá soldado jā ná nánducú vāha ndá dē Pedro, sochi nduú ní nánihīn ndá dē Pedro. De sá de nī stíchī Herodes ndá soldado de nī ncachī dē jā ná cúū ndá soldado. Ñúcuán de nī nquee Herodes inī Judea cuānohōn dē ciudad Cesarea jā cundeē dē. ");
INSERT INTO mieNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","De nī nquītī ndasí inī rey Herodes nī jinī dē ndá nchivī ñuū Tiro jíín nchivī ñuū Sidón. De nī natúhún ndá nchivī ñúcuán jā quíhīn ji nūū Herodes, chi jondē ñuū maá Herodes jécuēen ndá ji jā yájī ji. De nī nsāhá ndá nchivī ñúcuán amigo ji jíín Blasto, tēe cúñáhnú jā sátíñú nūū Herodes, de nī ncāhān ndāhví ndá ji jíín dē jā ná cáhān dē jēhē ji jíín Herodes jā ná cóo vāha inī dē jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","De nī jani Herodes iin quīvī jā natacā ndá ji nūū dē. De nī nūcūhun dē sahma jā ñúhun dē tá tátúnī dē, de nī jēcundeē dē nūū mesa nūū tátúnī dē, de nī ndacu dē tiñu tácua cunini ndá nchivī ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Sá de nī ncāhān jee ndá ji: Nsūú iin tēe-ni cúu jā cáhān yáhá, chi iin yāā cúu, ncachī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","De maá hora ñúcuán jā cáhān ji, de nī nquehen-ni iin cuēhē xēēn Herodes nī nsāhá iin ángel Yāā Dios, de nī nchajī-ni tīndacú dē, de nī jīhī dē, chi nī nsāhá vīxī dē maá dē, chi nduú ní ncáchī dē jā cúñáhnú Yāā Dios, chi sa nī nsāhá dē jā maá dē cúu jā cúñáhnú. ");
INSERT INTO mieNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","De nī jītē nuu cā tūhun Yāā Dios cuāhān, de nī ncandíja cuāhā cā nchivī ndācá-ni lugar. ");
INSERT INTO mieNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","De Bernabé jíín Saulo nī squíncuu ndúū dē tiñu jā ní jēsiáha dē jā cutecū ndá hermano cándíja jā íyó ciudad Jerusalén. De nī ndicó cóo ndúū dē cuānohōn dē ñuū Antioquía, de nī jeca dē Juan, tēe nání Marcos, cuāhān dē jíín. ");
INSERT INTO mieNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","De māhñú grupo nchivī cándíja inī ñuū Antioquía nī īyo ndá tēe nácani tūhun Yāā Dios jíín ndá tēe stéhēn tūhun yā. De súcuán nání ndá dē: Bernabé, Simón tēe nání Negro, Lucio ñuū Cirene, Saulo, jíín Manaén tēe nī jahnu jíín incā Herodes jā ní ncuu gobernador Galilea. ");
INSERT INTO mieNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","De iin quīvī de íyó nditē inī ndá dē, de chíñúhún ndá dē nūū maá Jētohō ō, de nī ncāhān maá Espíritu Santo: Cúnī ni jā sāhá síín nú Bernabé jíín Saulo jā ná quíhīn dē iin tiñu jā ní jani nī dē jā sāhá dē, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","De nī jīcān táhvī tucu-ni ndá dē juni íyó nditē inī dē. De nī ntee ndá dē ndahá dē xīnī Bernabé jíín Saulo. Sá de nī nacuetáhví ndá dē nūū ndúū tēe ñúcuán de cuāhān ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","De nī nsāhá maá Espíritu Santo jā cuáhān ndúū dē ichi ñuū Seleucia jā íyó yuhú mar. De ñúcuán nī nquīvi ndúū dē inī barco, de cuāhān dē jondē isla Chipre jā cúu iin pedazo ñuhun jā ñúhún māhñú ndute. ");
INSERT INTO mieNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","De nī nquenda ndúū dē puerto Salamina. De nī nacani dē tūhun Yāā Dios inī ndá vehe īī sinagoga táhán dē hebreo. De suni cuāhān Juan, chi tēe jétíñú ndúū dē cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","De nī nchāha ndá dē níí isla Chipre cuāhān dē nī nquenda dē jondē ñuū Pafos jā íyó yuhú isla Chipre. De ñúcuán nī jinī ndá dē nūū iin táhán dē hebreo jā nání dē Barjesús, de tēe scuáha mágica cúu dē. De cáhān dē tūhun stáhví jā cáchī dē jā tēe nácani tūhun Yāā Dios cúu dē. ");
INSERT INTO mieNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","De tēe scuáha mágica ñúcuán sátíñú dē nūū gobernador Sergio Paulo. De gobernador ñúcuán chi ndíchí dē. De nī ncana dē Bernabé jíín Saulo chi cúnī dē cunini maá dē tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","De tēe scuáha mágica ñúcuán suni nání dē Elimas. De ndúcú dē jā casī dē jā má cándíja gobernador tūhun jā nácani Saulo jíín Bernabé. ");
INSERT INTO mieNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","De Saulo jā suni nání Pablo, nī nchitú Espíritu Santo inī ánō dē. De nī ndēhé vāha dē nūū tēe scuáha mágica ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","De nī ncāhān dē: Tēe sáhá tiñu néhén jā stáhví ndasí cúu nú, de sēhe tāchī cúñáhnú cúu nú, chi jásī nū nūū ndācá tiñu váha. De násāma nú tūhun ndāā maá Jētohō ni tácua mā cándíja nchivī. ¿De nājēhē cúu jāá nduú jéncuiñī cuitī nū jā sáhá nú súcuán? ");
INSERT INTO mieNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","De mitan de maá Jētohō ni de sndóho yā ndóhó chi cucuáá nú, de mā cūní nú cā ncandiī jacū quīvī, ncachī Pablo. De nī jasī-ni nūū dē, de tíin íyú tíin suha dē-ni cā ndúcú dē iin nchivī jā tiin ndahá dē quīhīn dē jíín cúnī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ñúcuán de nī jinī gobernador jā súcuán nī ncuu, de nī ncandíja dē tūhun maá Jētohō ō, de sáhvi inī dē níni dē. ");
INSERT INTO mieNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ñúcuán de Pablo jíín ndá táhán dē nī nquee ndá dē ñuū Pafos. De nī nquīvi ndá dē inī barco de cuāhān ndá dē ñuū Perge jā cúu ndáñúū Panfilia. De ñúcuán nī ncusíín Juan cuānohōn dē ciudad Jerusalén. ");
INSERT INTO mieNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","De ndá máá dē chi nī nquee tucu dē inī Perge cuāhān dē, de nī nquenda dē Antioquía jā cúu ndáñúū Pisidia. De iin quīvī nátātú nī nquīvi ndá dē inī vehe īī sinagoga, de nī jēcundeē ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","De tá nī ncuu nī ncahvi nchivī ley Moisés jíín tutū jā ní ntee ndá tēe nī nacani tūhun Yāā Dios jondē janahán, sá de ndá tēe cúñáhnú inī vehe īī sinagoga nī ncāhān ndá dē jíín iin tēe jā cuácāhān jíín Pablo jíín ndá táhán dē: Cáhān sá jíín ndá ní, tátā, tú íyó jacū tūhun jā cāhān ní jā sndíhvī inī ní ndá nchivī yáhá, de cāhān ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ñúcuán de nī nacuiñī Pablo nī nsāhá dē seña jā coo nañíí nchivī, de nī ncāhān dē: Ndá ní táhán ó Israel jíín ndá ní jā suni chíñúhún ní Yāā Dios, cunini ndá ní ná cáhān sá. ");
INSERT INTO mieNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Maá Yāā Dios jā chíñúhún ndācá ó jā cúu ó nchivī nación Israel, nī nacāji yā ndācá tatā ō jā ní ntecū janahán. De nī ndeē tátū ndá ji inī nación Egipto de nī ncāyā ji nī nsāhá yā. Ñúcuán de jíín poder yā nī ntavā yā ndá ji inī Egipto cuāhān ji. ");
INSERT INTO mieNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","De tá ūū xico cuīyā nī jica ndá ji nūū ñuhun tíhá, de maá Yāā Dios nī jendeé inī yā jíín ji. ");
INSERT INTO mieNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","De nī nsāhá yā jā ní snáā ndá ji ūjā nación jā ní īyo inī Canaán, de ndá ñuhun ñúcuán nī jēhe yā nūū ndá ji cuu tāhvī ji. ");
INSERT INTO mieNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","De nī jani yā ndá tēe jā ní ntatúnī nūū ji tá cūmī ciento ūū xico ūxī cuīyā jondē quīvī jā ní ntatúnī Samuel, tēe nī nacani tūhun yā jondē janahán. ");
INSERT INTO mieNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ñúcuán de nī jīcān ndá ji iin rey. De nī jani Yāā Dios Saúl jā ní ncuu dē rey nī ntatúnī dē nūū ndá ji ūū xico cuīyā. De sēhe Cis nī ncuu Saúl jā cúu tatā Benjamín. ");
INSERT INTO mieNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","De nī ncandeē yā-ni tiñu ndíso Saúl, de nī jani yā David nī ncuu dē rey nūū ndá ji. De nī ncāhān yā tūhun David: Cúsiī inī ni jíín David sēhe Isaí, chi sāhá dē ndācá jā cúnī ni, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","De nī ncāhān cā Pablo: De chījin tatā David nī nquiji Jesús, Yāā jā ní jani Yāā Dios jā scácu ndá táhán ó Israel, chi súcuán nī nquee yuhú yā. ");
INSERT INTO mieNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","De jondē tá ncháha ca quijéhé Jesús nacani yā tūhun de nī nacani Juan tūhun nūū ndācá táhán ó Israel jā ná nácani inī ndá ji jā sndóo ji cuāchi ji, de cuenduté ji. ");
INSERT INTO mieNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","De tá cuācuñatin quīvī jā cuū Juan de nī ncāhān dē: ¿De á jáni inī ndá ní jā sāán cúu Cristo? Nduú chi nsūú sá cúu. Sochi cáta quiji yā, de cúñáhnú ndasí yā. Sochi sāán chi nduú cúñáhnú cuitī sá jā tavā sá vísō nījān yā, ncachī Juan, ncachī Pablo. ");
INSERT INTO mieNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","De nī ncāhān cā Pablo: Tátā, ndācá ní jā cúu ó tatā Abraham jíín ndācá ní jā suni íyó yíñúhún nūū Yāā Dios, cúnī Yāā Dios jā ná cúnī maá ó tūhun yā jā cáhān nāsa scácu yā yóhó. ");
INSERT INTO mieNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Chi ndá nchivī Jerusalén jíín ndá tēe cúñáhnú nūū ji, nduú ní jícūhun inī ndá ji jā Jesús cúu Cristo, Yāā jā ní jani Yāā Dios jā scácu yóhó. De ndá quīvī nátātú nī nini ndá ji tūhun jā ní ntee ndá tēe nī nacani tūhun yā jondē janahán nāsa quiji Cristo. De vísō súcuán de nduú ní jícūhun inī ndá ji vísō ja nī nquiji yā, chi sa nī nenda ndá ji sīquī yā jā ní jīhī yā. De súcuán nī squíncuu ndá ji tūhun jā ní ncāhān ndá tēe nī nacani tūhun Yāā Dios jondē janahán. ");
INSERT INTO mieNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","De vísō nduú ní níhīn ndá ji ni iin cuāchi sīquī yā jā cuū yā sochi nī ncāhān nīhin ndá ji jíín Pilato jā ná cúū yā. ");
INSERT INTO mieNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","De tá nī nquee ndaā ndācá tūhun yā jā cáhān nūū tútū īī de nī snúu ndúū dē yā yīcā cruz, de nī nchiyuhū dē yā inī iin yavī jā ní jete yīcā iin cava. ");
INSERT INTO mieNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Sochi nī natecū yā nī nsāhá Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","De tá técū cā yā de nī jēhēn ndá nchivī Galilea jíín yā jondē ciudad Jerusalén. De tá nī natecū yā de cuāhā quīvī nī nenda nijīn yā nūū ndá máá ji. De ndá nchivī ñúcuán cúu jā nácani ji tūhun yā nūū ndá cā táhán ó hebreo mitan. ");
INSERT INTO mieNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","De suni súcuán nácani ndá sá tūhun vāha ñúcuán nūū ndá ní, de suu tūhun ñúcuán cúu jā ní nquee yuhú yā nūū ndá ndīyi tatā ō. ");
INSERT INTO mieNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","De tūhun ñúcuán nī squíncuu Yāā Dios jā ní jinī jínúū maá ó jā cúu ó tatā dē, chi nī nastécū yā Jesús. Chi suni súcuán cáhān salmo ūū nūū cáhān yā jíín Sēhe yā Jesús: Maá nú cúu Sēhe nī, de mitan nī nsāhá ñáhnú nī ndóhó jā cúu nī Tatá nú, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","De nī nastécū yā Jesús tácua mā téhyū cuitī yā, chi súcuán yósō nūū tutū jā ní ncāhān yā jíín Sēhe yā jondē janahán: Maá nú nīhīn ndija ndācá jā váha jā ní nquee yuhú nī jā cuāha nī nūū David, ncachī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Chi suni súcuán cáhān tucu incā salmo jā ní ntee David, jā cáhān Jesús jíín Yāā Dios: Mā cuáha ní tūhun jā tēhyū sá, chi sáhá sá tiñu ní de mānī ní jíín sá, cáchī. ");
INSERT INTO mieNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","De ndāā chi David nī nsāhá dē tiñu jā ní īñi dē jēhē nchivī jā ní īyo tiempo dē, tá nūū cúnī maá yā. De sá de nī jīhī dē, de nī jīquiyuhū dē tá-ni nī jīquiyuhū ndācá tatā dē, de nī ntēhyū ndija yiqui cúñu dē. ");
INSERT INTO mieNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Sochi Jesús, jā ní nastécū Yāā Dios, chi nduú ní ntéhyū cuitī yā. ");
INSERT INTO mieNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Tátā, túsaá de cánuú jā ná jícūhun inī ndá ní jā Jesús cúu Yāā jā cune cáhnú inī yā nūū ndá cuāchi ní. ");
INSERT INTO mieNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Chi nī jani inī ndá ní jā jíín ley cúu jā ndahvā cuāchi ndá ní nícu, sochi nduú ní ncúu. Sochi maá Jesús cúu jā sndáhvā ndija cuāchi ndá nchivī jā cándíja ji yā. ");
INSERT INTO mieNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Túsaá de coto vāha ndá ní maá ní jā má quījí ndá castigo sīquī ní jā ní ncāhān ndá tēe jā ní nacani tūhun Yāā Dios jondē janahán. Chi súcuán nī ncāhān yā: ");
INSERT INTO mieNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ndá ndóhó jā jácū catá sīquī tūhun yā, chi cūndēhé nú jā quiji castigo xēēn sīquī nū, de sāhvi inī nū cunī nū de cuū nū. Chi tiempo maá nú sāhá nī iin tiñu ñáhnú de mā cándíja cuitī nū jā súcuán sāhá nī vísō ná nácani ndá nchivī tūhun nūū nū. Ncachī yā, ncachī Pablo. ");
INSERT INTO mieNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","De Pablo jíín ndá tēe jíca jíín dē, tá nī nquee ndá dē inī vehe īī sinagoga táhán dē hebreo, de nchivī ndá cā nación nī ncāhān ndāhví ji jíín dē jā incā quīvī nátātú nacani tucu dē tūhun Jesús nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","De nī nacutē nuu ndá nchivī ñúcuán cuānohōn ji. De nī īyo cuāhā nchivī hebreo, jíín nchivī ndá cā nación jā ní ntiin ley hebreo de chíñúhún ji Yāā Dios. De nī nchiniquīn ndá ji Pablo jíín Bernabé cuāhān ndá ji jíín ndúū dē. De nī ncāhān nīhin dē jíín ndá ji jā ná cuíñi nīhin ji jíín tūhun jā mānī Yāā Dios jíín ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","De quīvī nátātú incā semana de ja ñatin ndiviī nchivī ñuū ñúcuán nī ncutútú ndá ji jā cunini ji tūhun Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","De tá nī jinī ndá táhán dē hebreo jā ní ncutútú cuāhā ndá nchivī ñúcuán, de nī ncucuásún inī dē. De nī ncachī ndá jāá nsūú tūhun vāha cúu jā stéhēn Pablo, de nī ncāhān nāvāha ndá nūū Pablo. ");
INSERT INTO mieNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ñúcuán de nī nchundeé cā inī Pablo jíín Bernabé nī ncāhān dē: Cánuú jā xihna cā nūū ndá máá ní jā cúu ní táhán ó hebreo nacani sá tūhun Yāā Dios. Sochi nduú ní jétáhví ní, de cuāchi ndá máá ní cúu jā má quívi ní nūū cutecū ní níí cání túsaá. De mitan de quīnacani sá tūhun yā nūū ndá nchivī ndá cā nación. ");
INSERT INTO mieNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Chi súcuán nī ntatúnī maá Jētohō sá nūū ndá sá: Nī jani nī ndóhó jā cuu nú modo iin luz jā stúu inī ánō nchivī ndá cā nación, chi nacani nú tūhun nī nūū nchivī níí ñayīví jā scácu nī ji. Ncachī yā, ncachī Pablo. ");
INSERT INTO mieNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","De nchivī ndá cā nación, tá nī jini ji tūhun yáhá de nī ncusiī ndasí inī ji, de nī ncāhān ji jā tūhun vāha cúu tūhun maá Jētohō ō. De ndācá nchivī jā ní nacāji Yāā Dios jā cutecū ji níí cání, nī ncandíja ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","De nī jītē nuu tūhun maá Jētohō ō cuāhān níí ndáñúū ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","De inī ñuū Antioquía íyó ndá ñahan cúñáhnú jā chíñúhún ña Yāā Dios. De ndá tēe hebreo nī scáhān dē ndá ñahan ñúcuán jíín suni ndá tēe cúñáhnú ñuū ñúcuán. De nī nquijéhé ndá dē sáhá nāvāha dē Pablo jíín Bernabé, de jondē nī scúnu ndá ndúū dē cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","De nī scóyo ndúū dē tīcāchāā jēhē dē jā cúu seña jāá nduú ní jétáhví ji tūhun Yāā Dios, de cuāhān ndúū dē ñuū Iconio. ");
INSERT INTO mieNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","De ndá nchivī cándíja jā íyó inī Antioquía, nī nchitú Espíritu Santo inī ánō ji, de cúsiī ndasí inī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","De ñuū Iconio nī nquīvi ndúū dē inī vehe īī sinagoga táhán dē hebreo. De jíín tūhun jā ní nacani ndúū dē de nī ncandíja cuāhā táhán dē hebreo de saá-ni cuāhā nchivī ndá cā nación. ");
INSERT INTO mieNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Sochi ndá táhán dē hebreo jāá nduú ní ncándíja, nī scáhān ndá ji ndá cā nchivī jāá nsūú nchivī hebreo cúu, chi cáchī ji jāá nsūú nchivī vāha cúu ndá nchivī cándíja. ");
INSERT INTO mieNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","De cuāhā cā quīvī nī īyo Pablo jíín Bernabé ñuū ñúcuán. De nī nchundeé inī ndúū dē nī ncāhān nīhin dē tūhun yā, chi cándíja vāha dē jā chindeé maá Jētohō ō dē. De maá yā chi nī stéhēn yā jā íyó ndāā tūhun jā vāha inī yā jíín nchivī jā nácani ndúū dē, chi nī jēhe yā fuerza jā sāhá dē tiñu ñáhnú jíín tiñu jā stéhēn jā íyó poder yā. ");
INSERT INTO mieNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","De nchivī ñuū ñúcuán nī ncusíín-ni inī ndá ji, de sava ji nī īñi jíín ndá tēe hebreo jāá nduú cándíja, de sava cā ji nī īñi jíín ndá apóstol. ");
INSERT INTO mieNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","De ndá nchivī hebreo jíín nchivī ndá cā nación jíín ndá tēe cúñáhnú ñuū ñúcuán, nī squétáhán ndá dē tūhun jā nenda ndá dē sīquī Pablo jíín Bernabé jā cuun ndá dē yūū ndúū tēe ñúcuán nícu. ");
INSERT INTO mieNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","De nī nīhīn ndúū dē tūhun jā súcuán cúnī ndá tēe ñúcuán sāhá dē, de nī nsāhá jíyo-ni ndúū dē cuāhān dē ñuū Listra jíín ñuū Derbe jā cúu ndáñúū Licaonia, jíín ndá cā ñuū íyó ñatin ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","De níí ñúcuán nī nacani ndúū dē tūhun vāha maá yā nāsa scácu yā yóhó. ");
INSERT INTO mieNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","De inī ñuū Listra ndéē iin tēe jāá nduú cúu caca dē, chi nduú jíca cuitī dē jondē quīvī jā ní ncacu dē. ");
INSERT INTO mieNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","De tēe ñúcuán nī jini dē tūhun jā cáhān Pablo. De nī ndēhé vāha Pablo nūū tēe ñúcuán, de nī jinī dē jā cándíja vāha tēe ñúcuán jā nduvāha dē. ");
INSERT INTO mieNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","De nī ncāhān jee Pablo jíín dē: Nacuiñī de cuiñi nú, ncachī dē. De nīhin nī nacuiñī tēe ñúcuán, de nī jica dē-ni. ");
INSERT INTO mieNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","De nī jinī ndá nchivī tiñu ñáhnú jā ní nsāhá Pablo, de nī ncāhān jee ji jíín yuhú maá ji jā cúu tūhun Licaonia: De mitan de nī jinī nijīn ō jā ní ncuun ūū yāā vāji yā nūū ō, de tá cáá tēe cáá ndúū yā, ncachī ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","De nī ncāhān ndá ji jā Bernabé cúu yāā ndá ji nání Júpiter, de Pablo cúu yāā ndá ji nání Mercurio, chi Pablo cúu tēe nácani tūhun. ");
INSERT INTO mieNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","De ñatin yuhú ñúū ñúcuán íyó veñūhun yāā nání Júpiter. De sūtū jā sátíñú veñūhun ñúcuán nī scútú dē itā ndá stīquī, de cahnī dē tī jíín ndá cā nchivī nūū Bernabé jíín Pablo jā chiñúhún dē cúnī dē nícu. ");
INSERT INTO mieNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","De nī jinī ndúū tēe cúu apóstol ñúcuán jā súcuán cúnī ndá nchivī jā sāhá ji, de nī ndatá dē sahma dē, de ñúcuán cúu iin seña jāá nduú jétahān inī dē jā sāhá ndá ji súcuán. De nī ndava-ni ndúū dē nī nquīvi ndúū dē māhñú ndá nchivī cuāhā ñúcuán, de nīhin nī ncana ndúū dē: ");
INSERT INTO mieNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Tátā, mā sāhá ndá ní súcuán, chi suni tēe-ni cúu ndúū sá tá cúu nūū cúu ndá máá ní. De vāji ndúū sá jā cachī tūhun ndúū sá tūhun vāha Yāā Dios nūū ndá ní. De cáhān sá jā má sāhá ní cā tiñu jāá nduú tiñu yáhá, chi sa Yāā Dios chiñúhún ní, Yāā técū, Yāā jā ní nsāhá andiví jíín ñayīví jíín mar jíín ndācá cā jā íyó níí cáhnú. ");
INSERT INTO mieNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Chi jondē janahán chi nī jēhe yā tūhun jā sāhá ndá nchivī tiñu jā cúnī ndá máá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","De vísō súcuán sochi nī stéhēn ndāā yā nūū ji nāsa Yāā cúu yā, chi ndācá-ni tiñu váha nī nsāhá yā jíín ndācá ó, de súcuán cúu jondē mitan. Chi scúun yā sāvī, de sáhá yā jā vāha cúu itū, de jéhe yā jā yájī ō de cúsiī inī ō, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","De vísō súcuán nī ncāhān dē, sochi ūhvī ndasí nī jasī ndúū dē jā chíñúhún ndá nchivī dē nícu. ");
INSERT INTO mieNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ñúcuán de jacū tēe hebreo nī nquenda dē Listra jā váji dē ichi Antioquía jíín Iconio. De nī scáhān ndá dē ndá nchivī cuāhā ñúcuán. De nī ncuun ndá ji yūū Pablo, de nī ñuhun ndá ji Pablo nī ntavā ji dē yātā ñúū, chi nī jani inī ndá ji ja nī jīhī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Sochi ndá tēe cándíja ñuū ñúcuán nī jicó ndúū ndá dē Pablo, de nī nacōo dē-ni, de nī ndīvi dē inī ñuū. De quīvī téēn de nī nquehen dē ichi cuāhān dē jíín Bernabé ñuū Derbe. ");
INSERT INTO mieNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","De inī ñuū ñúcuán nī nacani ndúū dē tūhun vāha maá Jētohō ō jā scácu yā nchivī, de cuāhā nchivī nī ncandíja nī nsāhá dē. Sá de nī nōhōn tucu ndúū dē Listra jíín Iconio jíín Antioquía. ");
INSERT INTO mieNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","De nī jija cā inī ndá nchivī cándíja nī nsāhá ndúū dē níí nūū ní jēhēn dē. De nī sndíhvī inī ndúū dē ndá ji jā ná cuíñi nīhin ndá ji jíín tūhun yā jā cándíja ji. De nī ncāhān ndúū dē jā níní cúu jā quiji ndá tūndóhó sīquī ō, de sá de quīvi ó nūū tátúnī Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","De ndācá ñuū nī jani ndúū dē sava tēe ñáhnú jā cundiso tíñú dē coto dē nchivī cándíja. De nī jīcān táhvī nditē ndúū dē nūū maá Jētohō ō jā ná cóto yā ndá nchivī ñúcuán, chi ndihi ji cándíja ji nūū yā. ");
INSERT INTO mieNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","De nī nayāha ndúū dē Pisidia cuāhān dē, de nī nquenda dē ndáñúū Panfilia. ");
INSERT INTO mieNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","De nī nacani ndúū dē tūhun yā inī Perge jā íyó inī Panfilia, de sá de cuāhān dē ñuū Atalia. ");
INSERT INTO mieNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","De ñúcuán nī nquīvi ndúū dē barco de nī nenda tucu dē Antioquía. De ñuū ñúcuán cúu nūū ní jīcān táhvī ndá nchivī nūū Yāā Dios jēhē ndúū dē jā ná chíndeé ná chítuu yā dē jíín tiñu jā nacani dē tūhun yā. De nī nenda ndúū dē jā ní squíncuu dē tiñu ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","De tá nī nenda ndúū dē Antioquía de nī nastútú dē ndá nchivī cándíja. De nī nacani dē tá tiñu ñáhnú nī nsāhá Yāā Dios jíín ndúū dē, chi nī jēhe yā tūhun jā suni cándíja ndá cā nchivī vísō nsūú nchivī hebreo cúu. ");
INSERT INTO mieNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","De cuāhā tiempo nī īyo ndúū dē Antioquía jíín ndá nchivī cándíja. ");
INSERT INTO mieNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ñúcuán de jacū tēe región Judea nī nquenda dē ñuū Antioquía, de nī stéhēn ndá dē nūū ndá hermano jā tú mā sāhá ji circuncidar tá cúu nūū íyó costumbre jā ní jēhe Moisés nūū nchivī hebreo, de mā cácu cuitī ndá ji, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","De Pablo jíín Bernabé nī ntetáhán ndasí ndúū dē jíín ndá tēe ñúcuán sīquī tūhun jā ní ncāhān ndá dē de nduú ní ncúndaā. De jā suu cúu jā ní nsāhá ndāā ndá dē jā quíhīn Pablo jíín Bernabé jíín sava cā dē jondē ciudad Jerusalén, de ñúcuán natúhún ndá dē sīquī tūhun yáhá jíín ndá cā apóstol jíín ndá tēe ñáhnú jā ndíso tíñú nūū nchivī cándíja. ");
INSERT INTO mieNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ñúcuán de ndá nchivī cándíja nī nachuhun ichí ji ndá dē. De nī nchāha ndá dē cuāhān dē ichi Fenicia jíín Samaria, nácani dē tūhun nāsa nī nasāma inī nchivī jāá nsūú nchivī hebreo cúu, chi nī ncandíja ji tūhun yā. De nī ncusiī ndasí inī ndá hermano ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","De nī nquenda ndá dē Jerusalén. De ndá nchivī cándíja ñúcuán jíín ndá tēe cúu apóstol jíín ndá tēe ñáhnú jā ndíso tíñú nūū ji, nī ncusiī inī ndá dē jā ní nquenda Pablo jíín ndá cā dē. De nī nacani Pablo jíín Bernabé ndācá tūhun nāsa nī nsāhá Yāā Dios jíín ndúū dē tá nī jica nuu dē nī nacani dē tūhun yā. ");
INSERT INTO mieNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Sochi nī nacuiñī sava tēe grupo fariseo jā cándíja, de nī ncāhān ndá dē: Nchivī ndá cā nación jā cándíja ji Jesús, cánuú jā cuu ndá ji circuncidar, de ndacu ó nūū ji jā ná squíncuu ji ley Moisés, ncachī ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","De nī ndutútú ndācá tēe cúu apóstol jíín ndācá tēe ñáhnú jā ndíso tíñú jā sāhá ndāā dē sīquī tiñu yáhá. ");
INSERT INTO mieNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","De tá cuājīnu jā ní ncāhān ndihi ndá dē de nī nacuiñī Pedro nī ncāhān dē: Hermano, ja jínī vāha ndá ní jā ja cuācunahán nī nacāji Yāā Dios sāán jā ní nacani sá tūhun vāha yā nūū nchivī incā nación, de nī ncandíja ji. ");
INSERT INTO mieNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","De Yāā Dios chi jínī yā nāsa íyó ánō ndá nchivī, de nī stéhēn yā jā ní jetáhví yā ji, chi suni nī jēhe yā Espíritu Santo nūū ndá ji tá-ni nī ntaji yā nūū maá ó. ");
INSERT INTO mieNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","De nduú ní nsáhá síín yā yóhó jíín ndá ji, chi suni nī nsāhá ndoo yā ánō ji sīquī jā ní ncandíja ndá ji Jesús. ");
INSERT INTO mieNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","De mitan ¿de nājēhē cúu jā cúnī ndá ní squívi ní ji chījin ley jā má cúndéé ji jíín? Chi nduú jétahān inī Yāā Dios jā súcuán. Chi cúnī ndá ní jā tee ní tiñu víjín yáhá sīquī ndá nchivī cándíja ñúcuán, de ni ndá tatā ō nduú ní ncúndéé dē squíncuu dē, de ni maá ó. ");
INSERT INTO mieNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Chi sa cándíja ndācá ó jā sīquī jā vāha inī Jētohō ō Jesús cúu jā ní scácu yā yóhó súcuán-ni, de suni súcuán-ni scácu yā ndá cā nchivī, de nsūú sīquī jā squíncuu ji ley, ncachī Pedro. ");
INSERT INTO mieNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","De nī ncāhān Pablo jíín Bernabé, de nī ncunañíí ndá nchivī níni ji jā cáhān ndúū dē, chi nī nacani dē jā ní jēhe yā poder nūū ndúū dē jā ní nsāhá dē ndá tiñu ñáhnú jíín tiñu jā stéhēn jā íyó poder yā nūū nchivī ndá cā nación. ");
INSERT INTO mieNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","De tá nī jīnu nī ncāhān ndúū dē de nī ncāhān Jacobo: Hermano, cunini ndá ní ná cáhān sá. ");
INSERT INTO mieNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Nī nacani Simón Pedro tūhun nāsa nī nquijéhé Yāā Dios cána yā nchivī ndá cā nación, chi nánducú maá yā ndá ji jā nduu ji nchivī maá yā. ");
INSERT INTO mieNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","De inuú-ni cáhān ndá tūhun yáhá jíín tūhun jā ní nacani ndá tēe nī nacani tūhun Yāā Dios jondē janahán tá cúu nūū ní ntee dē nūū tutū īī: ");
INSERT INTO mieNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Cáchī Yāā Dios: Vehe nūū ní nchiñúhún David nduhū chi nī ndicó cáva. De iin quīvī de nenda nī de nasāhá nī vehe ñúcuán, jā chiñúhún tucu ndá nchivī hebreo nduhū. ");
INSERT INTO mieNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Súcuán sāhá nī tácua cuu nanducú ndá cā nchivī nduhū, jondē jíín nchivī ndá cā nación, ndācá ji jā cana nī ji jā candíja ji nduhū. ");
INSERT INTO mieNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Súcuán nī ncāhān maá Jētohō ō, de jondē janahán ndasí ja stéhēn yā nūū nchivī jā súcuán scácu yā ji. Cáchī tutū īī. ");
INSERT INTO mieNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","De cáhān cā Jacobo: De jā ñúcuán cúu jā jáni inī sá jā má tēé ó ley vījín ñúcuán sīquī nchivī ndá cā nación jā nándicó cóo inī nūū Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Chi sa carta tee-ó quīhīn nūū ji jā má quívi nduū cā ji jíín ídolo, de mā cācá ndiī ji, de mā cājí ji cūñu quiti jéhné chi nduú ní játi nīñī tī, de ni iin nīñī ndá cā quiti mā cājí ji. ");
INSERT INTO mieNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tūhun yáhá-ni tee ó quīhīn nūū ji. Chi ja íyó ndá tēe nácani ley Moisés jondē janahán de jondē mitan. De ndācá quīvī nátātú cáhvi ndá dē ndá tūhun ñúcuán inī ndá vehe īī sinagoga ndācá ñuū, ncachī Jacobo. ");
INSERT INTO mieNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","De súcuán nī ncucáhnú inī ndá apóstol jíín ndá tēe ñáhnú jā ndíso tíñú jíín ndihi nchivī cándíja jā súcuán sāhá dē, de nī nacāji ndá dē sava tēe quīhīn jíín Pablo jíín Bernabé, chi quīnohōn ndúū dē Antioquía. De tēe nī nacāji dē ñúcuán cúu Silas jíín Judas, de incā síví dē cúu Barsabás. De iin tēe cúñáhnú cúu ndúū dē nūū ndá hermano. ");
INSERT INTO mieNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","De ndá tēe ñúcuán née dē carta, de súcuán cáhān: Ndá máá sá cúu apóstol jíín ndá tēe ñáhnú jā ndíso tíñú jíín ndá cā hermano, de tée ndá sá tūhun yáhá cuēē nūū ndá ní, hermano ndá cā nación jā ndéē ndá ní inī ñuū Antioquía jíín región Siria jíín Cilicia. Sāhá ndeé inī ndá ní. ");
INSERT INTO mieNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nī nīhīn sá tūhun jā ní nquee sava táhán sá yáhá nī nquenda dē nūū ndá ní jā cúu ní nchivī cándíja Cristo. De nī ndacu dē jā cuu ndá ní circuncidar jíín jā cuetáhví ní ley Moisés. De jíín tūhun jā ní ncāhān ndá dē ñúcuán de jáni ndasí inī ndá ní de cúcuécá inī ní sáhá dē. Sochi nsūú ndá sāán ní ntétíñú ndá tēe ñúcuán jā cuéē dē nūū ní. ");
INSERT INTO mieNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","De mitan nī nsāhá ndāā ndá sá, de inuú-ni jáni inī ndá sá. De nī nacāji sá tēe jā tetíñú sá cuēē nūū ní jíín hermano jā mānī ō jíín jā cúu Bernabé jíín Pablo. ");
INSERT INTO mieNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","De ndúū tēe yáhá ja nī jēhe dē tūhun jā vísō ná cúū dē jā síquī Jētohō ō Jesucristo. ");
INSERT INTO mieNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Túsaá de tetíñú ndá sá Judas jíín Silas cuēē dē nūū ní tácua suni inuú-ni cachī tūhun ndúū dē nūū ndá ní tá-ni cáhān carta yáhá. ");
INSERT INTO mieNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Chi súcuán jétahān inī Espíritu Santo, de saá-ni ndá máá sá suni mā tēé ndá sá ni iin tiñu víjín sīquī ndá ní, chi maá-ni tiñu jā cánuú cā yáhá: ");
INSERT INTO mieNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mā cājí ní cā jā ní nsōcō nūū ídolo, ni mā cājí ní nīñī, ni quiti jéhné chi nduú ní játi nīñī tī, de mā cācá ndiī ndá ní. Tú sndóo ní ndācá yáhá de vāha squíncuu ní. Sāhá ndeé inī ndá ní túsaá, cáchī carta. ");
INSERT INTO mieNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","De ndá tēe jā ní ntetíñú ndá dē ñúcuán, cuāhān ndá dē Antioquía. De nī nastútú ndá dē ndá nchivī cándíja, de nī jēhe dē carta ñúcuán nūū ji. ");
INSERT INTO mieNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","De nī ncahvi ndá ji, de nī ncusiī inī ji jíín tūhun ndeé inī jā cáhān carta. ");
INSERT INTO mieNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","De suni tēe nácani tūhun Yāā Dios cúu Judas jíín Silas, de jíín ndācá cā tūhun jā ní ncāhān ndúū dē de nī ndundeé inī ndá hermano ñúcuán, de nī jija cā inī ndá ji nī nsāhá ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","De nī īyo ndá dē ñúcuán jacū quīvī. Sá de nī nacuetáhví ndá hermano nūū ndá dē jā quínohōn dē nūū ndá tēe jā ní ntetíñú ndá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sochi nī jētahān inī Silas jā quendōo dē ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","De suni nī nquendōo Pablo jíín Bernabé Antioquía, de stéhēn ndúū dē jíín cuāhā cā tēe ñuū ñúcuán, de nácani ndá dē tūhun vāha maá Jētohō ō. ");
INSERT INTO mieNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","De nī ncuu cā quīvī, de Pablo nī ncāhān dē jíín Bernabé: Mitan de quīndēhé ó ndācá hermano ō ndācá ñuū nūū ní nacani ó tūhun maá Jētohō ō nūū ji, cúndēhé ó nāsa íyó ndá ji, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","De cúnī Bernabé jā quíhīn dē jíín Juan, tēe nání Marcos. ");
INSERT INTO mieNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Sochi nduú ní jétahān inī Pablo jā quíhīn tēe ñúcuán jíín dē, chi jondē Panfilia nī ncusíín Marcos nūū Pablo jíín Bernabé, de nduú ní ncúnī cā Marcos jā chindeé táhán dē jíín ndúū dē saá. ");
INSERT INTO mieNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","De nahán nī natúhún Pablo jíín Bernabé, de nduú ní ncúndaā inī ndúū dē jā síquī Marcos. De nī ncusíín ndúū dē, de Bernabé nī jeca dē Marcos cuāhān ndúū dē jíín barco jondē isla Chipre. ");
INSERT INTO mieNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","De Pablo nī nacāji dē Silas jā quíhīn dē jíín. De ndá cā hermano nī jīcān táhvī nūū maá Jētohō ō jā ná chíndeé chituu yā Pablo, chi vāha inī yā. De cuāhān ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","De nī jicó núu dē níí Siria jíín Cilicia. De nī jija cā inī ndá nchivī cándíja ñúcuán nī nsāhá dē. ");
INSERT INTO mieNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ñúcuán de nī nenda Pablo jíín Silas ñuū Derbe jíín Listra. De iin ñuū ñúcuán íyó iin tēe cándíja, nání dē Timoteo. De cúu dē sēhe yií iin ñahan hebrea jā cándíja Jesús. De tatá dē cúu tēe griego. ");
INSERT INTO mieNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","De ndācá hermano ñuū Listra jíín ñuū Iconio nī ncāhān ndá dē jā tēe vāha cúu Timoteo. ");
INSERT INTO mieNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","De cúnī Pablo jā cueca dē Timoteo quīhīn dē jíín. De nī nsāhá Pablo jā cuu ji circuncidar, chi nduú cúnī dē jā cāhān ndá nchivī hebreo jāá nduú ní squíncuu Timoteo costumbre ñúcuán, chi ndihi ji jínī jāá nsūú tēe hebreo cúu tatá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","De ndācá ñuū nī jēhēn ndá dē nī stéhēn ndá dē nūū ndá nchivī cándíja jā ná squíncuu ji tiñu jā ní ntatúnī ndá apóstol jíín ndá tēe ñáhnú Jerusalén jā ndíso tíñú nūū nchivī cándíja. ");
INSERT INTO mieNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","De ndá nchivī cándíja nī jija cā inī ji. De ndiquivī nī ncāyā cā ndá ji. ");
INSERT INTO mieNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","De nduú ní jéhe Espíritu Santo tūhun jā nacani dē tūhun yā inī región Asia, de jā ñúcuán cúu jā ní nchāha ndá dē cuāhān dē ichi región Frigia jíín Galacia. ");
INSERT INTO mieNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","De nī nquenda dē nūū quétáhán región Misia jíín Bitinia. De cúnī dē jā quíhīn dē Bitinia nícu, sochi Espíritu Jesús nduú ní jéhe yā tūhun jā quíhīn dē. ");
INSERT INTO mieNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","De nī nchāha ndá dē iin lado Misia cuāhān dē puerto Troas. ");
INSERT INTO mieNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","De iin jacuáā nī stéhēn yā nūū Pablo jā íñí iin tēe región Macedonia cáhān ndāhví jíín dē: Nehēn ní Macedonia yáhá, de chindeé ní ndá sāán, ncachī. ");
INSERT INTO mieNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Súcuán nī stéhēn nūū dē. Ñúcuán de sāán jā cúu Lucas, nī nquetáhán sá jíín Pablo. De nī nsāhá tūha ndá sá jā quíhīn ndá sá Macedonia, chi nī jinī cājí sá jā maá Yāā Dios cúnī yā jā nacani ndá sá tūhun vāha yā nūū ndá nchivī ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","De jíín barco nī nquee ndá sá ñuū Troas cuāhān ndāā sá isla Samotracia. De quīvī téēn nī nquenda sá ñuū Neápolis. ");
INSERT INTO mieNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","De ñúcuán nī nquee tucu ndá sá de nī nquenda ndá sá Filipos jā cúu ñuū cúñáhnú cā inī Macedonia, chi nchivī ciudad Roma nī nsāhá ji ñuū ji ñúcuán. De nī īyo ndá sá ñúcuán jacū quīvī. ");
INSERT INTO mieNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","De iin quīvī nátātú nī nquee ndá sá ñuū ñúcuán, de nī jēhēn ndá sá iin yuhú yúte. De ñúcuán cúu iin lugar nūū jícān táhvī ndá nchivī. De nī jēcundeē ndá sá, de nī nacani ndá sá tūhun yā nūū ndācá ñahan jā ní natacā ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","De iin ñahan nání Lidia jā váji jondē ñuū Tiatira, xícó ña sahma cuahá ndíhí jā yāhvi ndéē. De chíñúhún ndija ña Yāā Dios. De nī nini ña tūhun nácani ndá sá, de nī nsāhá maá Jētohō ō jā ní ncandíja ña tūhun yā jā cáhān Pablo. ");
INSERT INTO mieNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","De tá nī jenduté ña jíín ndācá nchivī jā ndéē vehe ña de nī ncāhān ndāhví ña jíín sá: Tú jáni inī ndá ní jā cándíja ndija sá nūū maá Jētohō ō, de cuēē ndá ní vehe sá cundeē ní, ncachī ña. De nī ncana fuerza ña ndá sāán. ");
INSERT INTO mieNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sá de iin quīvī cuāhān tucu ndá sá nūū jícān táhvī ndá ji ñúcuán. De nī nquetáhán sá jíín iin sūchí síhí jā ñúhún tāchī inī, de maá sáhá jā cúu cáhān ji tūhun nāsa coo ichi núū, de quée ndaā jā cáhān ji. De sūchí yáhá nī jeen ndá patrón ji tácua nīhīn dē cuāhā xūhún sīquī jā cáchī tūhun ji nūū ndá nchivī nāsa coo ichi núū. ");
INSERT INTO mieNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","De sūchí ñúcuán níquīn ji vāji ji yātā ndá sá cána cóhó ji: Ndá tēe yáhá sátíñú dē nūū Yāā Dios, Yāā cúñáhnú ndasí, de cáchī tūhun ndá dē nūū ndá ní nāsa cācu ní nūū cuáchi ní, ncachī ji. ");
INSERT INTO mieNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","De cuāhā quīvī nī nsāhá ji súcuán nūū ndá dē. De nī ntahúhvī inī Pablo, de nī ndicó cóto dē nūū ji, de nī ncāhān dē jíín tāchī ñúcuán: Tátúnī ni jíín poder Jesucristo jā quee nú inī sūchí yáhá quīhīn nū, ncachī dē. De maá hora ñúcuán de nī nquee-ni. ");
INSERT INTO mieNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ñúcuán de nī jinī ndá patrón ji jā má níhīn cā ndá xūhún sāhá ji. De jā suu cúu jā ní ntiin ndá Pablo jíín Silas cuāhān ndá jíín ndúū dē centro nūū íyó justicia. ");
INSERT INTO mieNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","De nī jani ndá ndúū dē nūū ndá tēe sáhá ndāā tiñu, de nī ncachī ndá: Ndúū tēe yáhá cúu tēe hebreo, de sáhá ndúū dē jā cúvaā nchivī ñuū ō. ");
INSERT INTO mieNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","De jáquīn ndúū dē incā costumbre jā má cūú cuetáhví ó ni mā cūú sāhá ó, chi contra sīquī ley nación maá ó cúu, chi nchivī nación Roma cúu ó, ncachī ndá. ");
INSERT INTO mieNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ñúcuán de nī nenda cuāhā cā nchivī sīquī ndúū dē. De nī ncachī ndá tēe cúñáhnú ñúcuán jā ná scúnuu ndá sahma ndúū dē, de ná cáni ndá ndúū dē jíín ñutun. ");
INSERT INTO mieNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","De tá nī ncuu nī ncani ndasí ndá ndúū dē, de nī squívi ndá ndúū dē vecāa. De nī ncachī ndá nūū tēe jā jíto vecāa jā ná cóto vāha ndúū dē. ");
INSERT INTO mieNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","De tēe jíto vecāa, tá nī ndacu ndá súcuán nūū dē de nī squívi dē Pablo jíín Silas vecāa ichi ínī cā. De nī nchihi dē sūcūn jéhē ndúū dē iin ñutun jā ndéē yāvī, de nī nasníhin dē jíín cadena. ");
INSERT INTO mieNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","De tá nī ncuu sava ñuú de jícān táhvī Pablo jíín Silas de jíta ndúū dē yaā īī nūū Yāā Dios. De suni nī jini ndá nchivī jā yíhí jíín dē vecāa. ");
INSERT INTO mieNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","De sanaā-ni de nīhin ndasí nī ntāan, de nī ncandā níí vecāa. De ndācá viéhé cāa ñúcuán nī nune-ni, de cadena jā núhnī ndá nchivī nī ndājī-ni. ");
INSERT INTO mieNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","De nī ndoto tēe jíto vecāa. De nī jinī dē jā núne ndá viéhé cāa, de nī ntavā dē espada jā cahnī dē maá dē nícu, chi jáni inī dē jā ní jinu ndá nchivī yíhí vecāa cuāhān ji. ");
INSERT INTO mieNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Sochi nī ncāhān jee Pablo: Mā cáhnī ní maá ní, chi yíhí ndihi ndá sá yáhá, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ñúcuán de tēe jā jíto vecāa nī ncana dē ñuhūn nī nquiji. De nī nquīvi dē-ni inī vecāa, de quísi dē jā yúhú dē. De nī jēcuīñī jītí dē nūū Pablo jíín Silas. ");
INSERT INTO mieNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","De nī ntavā dē Pablo jíín Silas tāvēhé cāa, de nī ncāhān dē: Señor, ¿naá cúu jā sāhá sá tácua cācu ánō sá? ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","De nī ncāhān ndúū dē jíín tēe ñúcuán: Candíja ní Jētohō ō Jesucristo de cācu ní, de saá-ni ndācá nchivī vehe ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","De nī nacani ndúū dē tūhun maá Jētohō ō nūū tēe ñúcuán jíín nūū ndācá nchivī jā ndéē vehe dē. ");
INSERT INTO mieNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","De maá jacuáā ñúcuán nī naquete dē nūū ní ntacuēhé ndúū dē jā ní nsāhá ñutun. De ñúcuán de nī jenduté dē jíín ndācá nchivī jā ndéē vehe dē. ");
INSERT INTO mieNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","De nī jeca dē Pablo jíín Silas cuāhān dē jíín vehe dē, de nī jēhe dē jā ní nchajī ndúū dē. De nī ncusiī ndasí inī dē jíín ndá cā nchivī jā ndéē vehe dē jā ní ncandíja ndá ji Yāā Dios. ");
INSERT INTO mieNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","De tá nī ntūu de ndá tēe cúñáhnú nī ntetíñú dē ndá policía cuāhān nūū tēe jā jíto vecāa jā ná siáā dē Pablo jíín Silas. ");
INSERT INTO mieNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","De tēe jā jíto vecāa nī ncachī tūhun dē tūhun yáhá nūū Pablo: Ndá tēe cúñáhnú nī ntetíñú dē tūhun vāji jā siáā sá ní. Túsaá de quee ndúū ní quīhīn ní, de sāhá ndeé inī ní, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Sochi nī ncāhān Pablo jíín policía: Cuāhā nchivī nī jinī jā ní ncani ndá dē ndúū sá. ¿De nūcu nduú ní nsáhá ndāā dē de tú jāndáā jā íyó cuāchi ndúū sá? De nī nchihi ndá dē ndúū sá vecāa vísō tēe Roma cúu ndúū sá, chi íyó ley jā má cūú sāhá dē súcuán jíín nchivī Roma. De mitan ¿á tavā yuhū dē ndúū sá cúnī ndá dē, á naá cúu? De jā súcuán mā cūú cuitī, chi ná quíji ndá máá dē tavā dē ndúū sá, ncachī Pablo. ");
INSERT INTO mieNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ñúcuán de nī ndicó cóo ndá policía nī nacani dē ndācá tūhun yáhá nūū ndá tēe cúñáhnú, de nī nchūhú ndasí ndá nī jini ndá jā tēe Roma cúu Pablo jíín Silas. ");
INSERT INTO mieNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","De nī nquenda ndá, de nī ncāhān ndāhví ndá jíín ndúū dē jā ná cúne cáhnú inī ndúū dē. De nī ntavā ndá ndúū dē vecāa, de nī ncāhān ndāhví ndá jā ná quée dē quīhīn dē inī Filipos. ");
INSERT INTO mieNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","De sá de nī nquee ndúū dē vecāa, de cuānohōn dē vehe Lidia. De nī ncāhān ndúū dē tūhun ndeé inī jíín ndá hermano, de nī nquehen tucu ndúū dē ichi cuāhān dē. ");
INSERT INTO mieNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","De nī nchāha Pablo jíín Silas ñuū Anfípolis jíín ñuū Apolonia cuāhān dē, de nī nquenda dē Tesalónica nūū íyó iin vehe īī sinagoga táhán dē hebreo. ");
INSERT INTO mieNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","De nī ndeē ndúū dē ñúcuán ūnī semana. De ndá quīvī nátātú de sáhá Pablo tá-ni sáhá dē, chi nī jēhēn dē vehe īī sinagoga, de nī ncāhān dē jíín ndá tēe ñúcuán sīquī tutū īī. ");
INSERT INTO mieNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","De jíín tūhun cáhān tutū īī nī stéhēn dē jā cánuú jā ndoho Cristo jā cuū yā de natecū yā, de nī ncāhān dē: Jesús, Yāā jā nácani sá tūhun nūū ndá ní, suu yā cúu Cristo, Yāā jā ní jani Yāā Dios jā scácu yóhó, ncachī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","De nī ncandíja sava táhán dē hebreo jíín cuāhā nchivī griego jā suni chíñúhún Yāā Dios, jíín cuāhā ñahan cúñáhnú. De inuú-ni nī nduu ndá ji jíín Pablo jíín Silas. ");
INSERT INTO mieNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ñúcuán de nī ncucuásún ndasí inī ndá táhán dē hebreo jāá nduú cándíja, de nī stútú ndá dē sava tēe nēhén jā jíca cúxí-ni. De nī ncuvaā ndasí ndá ji inī ñuū ñúcuán. De nī nquenda ndá vehe Jasón nánducú ndá Pablo jíín Silas jā cueca ndá de cani ndá nūū ndá nchivī cuāhā nícu. ");
INSERT INTO mieNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Sochi nduú ní nánihīn ndá ndúū dē. De nī jeca xeēn ndá Jasón jíín sava cā hermano nī nquenda ndá jíín ndá dē nūū ndá tēe tátúnī inī ñuū ñúcuán, de nī ncana jee ndá sīquī Pablo jíín Silas: Ndá tēe jā sáhá síín nchivī níí cáhnú ñayīví, suni nī nquenda ndá dē yáhá. ");
INSERT INTO mieNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","De Jasón nī jēhe núú dē vehe dē ndéē ndá tēe ñúcuán. De ndācá ndá dē nduú jétáhví dē ley maá rey ndācá ó jā cúu ó nchivī Roma, chi sa cáhān ndá dē jā íyó incā rey jā jétáhví ndá dē jā nání Jesús, ncachī ndá. ");
INSERT INTO mieNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","De ndá tēe tátúnī jíín ndá cā nchivī nī jini ndá tūhun yáhá, de nī ncuvaā ndá. ");
INSERT INTO mieNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","De Jasón jíín ndá cā hermano nī sndóo ndá dē xūhún dē jā cúu prenda jā tají dē Pablo jíín Silas quīhīn ndúū dē, de sá de nī nsiáā ndá Jasón jíín ndá cā hermano cuānohōn dē. ");
INSERT INTO mieNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ñúcuán de ndá hermano nī scáca ñuú-ni dē Pablo jíín Silas cuāhān ndúū dē Berea. De tá nī nquenda ndúū dē ñúcuán, de nī nquīvi dē inī vehe īī sinagoga táhán dē hebreo. ");
INSERT INTO mieNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","De táhán dē hebreo ñúcuán vāha cā inī ndá ji nsūú cā táhán dē hebreo ñuū Tesalónica, chi vāha nī ncusiī inī ji jíín tūhun jā ní nacani ndúū dē. De ndācá quīvī nánducú viī ndá ji nūū tútū īī de tú súcuán cáhān, á nduú. ");
INSERT INTO mieNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","De jā ñúcuán nī ncandíja cuāhā ji, de suni nī ncandíja cuāhā nchivī griego, cúu tēe cúu ñahan cúñáhnú. ");
INSERT INTO mieNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Sochi ndá táhán dē hebreo ñuū Tesalónica nī nīhīn dē tūhun jā suni nácani Pablo tūhun Yāā Dios ñuū Berea. De nī jēhēn ndá dē Berea, de nī scáhān ndá dē ndá nchivī ñúcuán de nī nenda ji sīquī Pablo. ");
INSERT INTO mieNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","De ndá hermano Berea nī ntetíñú dē-ni Pablo jā quíhīn dē yuhú mar. De nī nquendōo Silas jíín Timoteo ñúcuán. ");
INSERT INTO mieNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","De sava hermano nī jēsiáha dē Pablo jondē Atenas. De nī ncachī Pablo nūū ndá tēe ñúcuán jā ñamā ná quíhīn Silas jíín Timoteo ñúcuán, de nī ndicó cóo ndá hermano cuānohōn dē. ");
INSERT INTO mieNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","De juni ndétu Pablo ñuū Atenas jā quenda Silas jíín Timoteo de nī jinī dē jā ndá nchivī ñúcuán ndasí chíñúhún ji ndá ídolo, de nī ncucuécá ndasí inī dē. ");
INSERT INTO mieNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","De inī vehe īī sinagoga nī nacani dē tūhun yā nūū ndá táhán dē hebreo jíín ndá cā nchivī jā suni chíñúhún Yāā Dios. De suni ndiquivī nácani dē tūhun yā nūū ndá nchivī jā íyó nūū yáhvi. ");
INSERT INTO mieNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","De sava tēe jā scuáha tūhun epicúreo jíín jā scuáha tūhun estoico nī natúhún ndá dē jíín Pablo, de sava dē nī ncāhān: ¿Nā tūhun cúu jā cáhān tēe tíléhlé yáhá?