﻿USE sofia;
DROP TABLE IF EXISTS sofia.micMIQNT_vpl;
CREATE TABLE micMIQNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES micMIQNT_vpl WRITE;
INSERT INTO micMIQNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Na ula wi'gatign telimugsioq ta'n wetapegsij Se'sus Westaulg. Wetapegsit Ta'piteg, aq Ta'pito'q wetapegsip Aplameg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Na ula telteg, Aplamo'q na Isaqo'q ujt'pnn. Isaqo'q na Je'gopo'q ujt'pnn. Je'gopo'q na Jutao'q aq Jutao'q wijig'titgi'g ujjuat'pni. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jutao'q na Peleso'q aq Selao'q ujjuat'pni. Na uggwijual teluisilipnn Te'mal. Peleso'q na Eslono'q ujt'pnn. Eslono'q na Alamo'q ujt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamo'q na Aminatapo'q ujt'pnn. Aminatapo'q na Ne'sono'q ujt'pnn. Ne'sono'q na Salamano'q ujt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamano'q na Poaso'q ujt'pnn aq Poaso'q uggwitl teluisilipnn Leia'p. Poaso'q na Opeto'q ujt'pnn. Opeto'q uggwitl teluisilipnn Lutti. Opeto'q na Jessio'q ujt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jessio'q na Ta'pito'q ujt'pnn. Ta'pito'q na elege'witewip aq na Salamano'q ujt'pnn. Salamano'q uggwitl gis malie'wipni Ulaiaal ge's mu weltesguagweg Ta'pito'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salamano'q na Leopo'amo'q ujt'pnn. Leopo'amo'q na Apaijao'q ujt'pnn. Apaijao'q na E'sao'q ujt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","E'sao'q na Jeiasapato'q ujt'pnn. Jeiasapato'q na Jolamo'q ujt'pnn. Jolamo'q na Usaiao'q ujt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaiao'q na Jottamo'q ujt'pnn. Jottamo'q na Eiaso'q ujt'pnn. Eiaso'q na Esegaiao'q ujt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esegaiao'q na Manassao'q ujt'pnn. Manassao'q na E'moso'q ujt'pnn. E'moso'q na Josaiao'q ujt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaiao'q na Jeggonaiao'q aq wijig'titgi'g ujjuat'pni, na tujiw Lesui'paqi'g elo'lutipnig Papilane'gatig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ge's eimu'ti'titeg Papilane'gatig, Jeggonaiao'q na geggunapnn Sialtielal. Sialtielo'q na Selupapelo'q ujt'pnn. Na tujiw Lesui'paqi'g apajita'pnaq Lesui'pewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selupapelo'q na Apaiuto'q ujt'pnn. Apaiuto'q na Ilaiagimo'q ujt'pnn. Ilaiagimo'q na E'solo'q ujt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","E'solo'q na Sataqo'q ujt'pnn. Sataqo'q na Aggimo'q ujt'pnn. Aggimo'q na Elioto'q ujt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elioto'q na Elie'salo'q ujt'pnn. Elie'salo'q na Mattano'q ujt'pnn. Mattano'q na Je'gopo'q ujt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Je'gopo'q na So'sep ujt'pnn. So'sep na Mali ugji'nmuml aq Mali na Se'sus uggwitl. Se'sus na tel wi'tut Westaulg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Na glaman newtisgegsijig jel ne'w ji'nmug aq uggwisua angua'lujig wetapegsultijig weja'tegemg Aplameg glapis Ta'piteg ugs'tqamuiteg. Na newtisgegsijig jel ne'w ji'nmug aq uggwisua angua'lujig wetapegsultijig weja'tegemg Ta'piteg glapis na tujiw Lesui'paqi'g elo'lu'titeg Papilane'gatig. Na newtisgegsijig jel ne'w ji'nmug aq uggwisua angua'lujig wetapegsultijig weja'tegemg na tujiw Lesui'paqi'g eimu'titeg Papilane'gati glapis Nujiugs'tawi'wet petgimut ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na ula telteg ta'n Se'sus Westaulg teli ugs'tqamuip. Uggwitl Malial getu' malie'wi'titl So'sepal gatu ge's mu malie'wi'tigweg Mali gi's getu' un'janit. Wejuli Nisgam ignmuapnn tle'lin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","So'sep getu' malie'wijig Malial gatu mo gesatmug ta'n goqwei gis tliaq. Apjiw getu' tetapua'teget glaman gisita'sit ma' nugu malie'winew gatu mo wenn telimagul, muta mo getu' ntaqo'qona'lagul Malial. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ge's elisingeg, etli angite'tg ula. Na nepaj pewiatl Gisiteget ugtansale'witeml telimtl, “So'sep, gi'l ta'n wetapegsit Ta'piteg, mut naqamasiw ugsua'lan Mali ugjit gte'pitemin. Getu' un'janit gatu Wejuli Nisgam ignmuapnn tle'lin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lpa'tujuitew aq tl wi'tates Se'sus muta ugs'tawiata ugtmimajuinumg aq apigsigtmuata ugtlue'utiwal.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gi's nige' sa'q Gisiteget telimapnn niganigjitegewinu'l ula ta'n goqwei tliatew. Na niganigjitegewinuaq wijei ewi'g'g'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tel wi'g'g'p, “Na e'pite's ta'n menaq wipemagul ji'nmul na tle'tew aq uggwisitew. Uggwisl tl wi'taten Imanuel.” (Na ugtli'sutiuow na wisun Imanuel telueg, “Gjinisgam wijitgweiugsi'gw.”) ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ta'n tujiw So'sep tugwieteg na tela'teget ta'n Gisiteget ugtansale'witeml gis tlimtl. Na malie'wijig Malial. ");
INSERT INTO micMIQNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Gatu mu ne'gaw sama'lagul Malial ta'n teli pgiji tle'lij. Na Mali uggwisl ugs'tqamuiliteg So'sep tel wisungewatl Se'sus. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ge's Elot elege'witewij, Se'sus etli ugs'tqamuip utan teluisig Petliem, Jutiaewa'gig. Tel'gne'ge'l ta'sijig ji'nmug ta'n wel nenua'tiji telpulti'tij gloqowejg weita'jig ugjipenug aq peita'jig Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pipanigesultijig, “Tami eig na mijua'ji'j gisi usgijinuip ugjit elege'witewin Lesui'paq? Gloqowej neia'sip ta'n tujiw wesgijinuiteg aq nemi'g'tt'p ta'n tujiw neia'siteg ugjipenug. Majulgwalg'tt tet. Nige' getu' emtoqwalg'tt ula mijua'ji'j.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Elege'wit Elot nutmateg no'q welmaita'sit aq maw ms't ta'n telgi'g Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Na mawa'laji ms't niganpugultiliji patlia'sg aq nujigina'mua'tiliji Mowisewei tplutaqan aq pipanimaji, “Tami tet tli ugs'tqamuitew na mijua'ji'j ta'n tluisitew Nujiugs'tawi'wet?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Telima'titl Elotal, “Tli ugs'tqamuitew Petliemg Jutiaewa'gi. Na st'ge' ula ta'n niganigjitegewinuaq ewi'g'g'p: ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Gjinisgam teluep, ‘Gilew tleiawultioq Petliem, Jutiaewa'gi, mimajuinu'g gepmite'lmugsitoqs'p muta na newte'jit ta'n te'sioq mgna's ugjit niganpuguin aq angweiwata ntmimajuinumg na Lesui'paq.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Elot wigumaji emittugwe'winu'g tleiawultiliji ugjipenug ugjit gimi ultesgatultinew. Telimji ta'n giasgiw tele'g'p na gloqowej neia'siteg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Telimaji, “Lta'gw aq menaqa gwilug na mijua'ji'j. Ta'n tujiw we'jioq, apaita'toqs'p ni'neg. Gnua'tuitoqs'p, glaman elg ni'n gis naji emtoqwala's.” Na tujiw elgimaji Petliemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Na maita'jig aq na wijei gloqowej ta'n neia'sip ugjipenug niganapti'gmuaji glapis etli naqa'sit musigisg'tug g'p'taq ta'n mijua'ji'j eig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Emittugwe'winu'g no'q wel'ta'sultijig ta'n tujiw nemia'titeg gloqowejl naqa'silitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pisgwita'jig na wen'ji'guom aq nemia'titl mijua'ji'jl maw uggwitl Malial. Nutgulpita'jig aq emtoqwala'titl mijua'ji'jl. Neia'tu'titl ta'n goqwe'l pegisitua'tipnn aq ignmua'titl wisaw suliewei, weljema'gewei aq amjaqto'suti. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na wela'gweg emittugwe'winu'g pewia'titl Nisgaml telimgwi'titl mu apaita'new Eloteg. Ta'n tujiw tugwia'tijig teli apaita'tij umutgiwaq, na piluei awti wesua'tu'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ta'n tujiw emittugwe'winu'g weji maita'tijig, Gisiteget ugtansale'witeml neia'silitl So'sepal ge's etl puitegelitl aq telimatl, “Mn'ja'si, ugsua'l mijua'ji'j aq gte'pitem aq la'l Ijipte'gatig. Siaw i'mu'tigw na'te'l glapis ap gnua'tulan. Elot apugjig lgimata ta'siliji sma'gnisg gwiluanew mijua'ji'jl ugjit ne'po'qsilin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Na tujiw So'sep menja'sit aq ilajit. Na wijei wela'gw So'sep, Mali aq mijua'ji'j maita'jig. El'ta'jig Ijipte'gatig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wesgowita'jig na'te'l glapis Elotal neplij. Ta'n goqwei teliaq na st'ge' ta'n goqwei gi's sa'q Gisiteget telimapnn niganigjitegewinu'l, “Natgimg'p ngwis Ijipte'gatig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ta'n tujiw Elot geitoq emittugwe'winu' ma' apoqonmagugwi, na ma'muniw uggwaig. Elgimaji sma'gnisg Petliemg aq igtigl utanji'jl ta'n etegl gigjiw Petliemg. Telsuteget ugjit ne'po'qsin ms't te'siliji lpa'tuji'jg ta'puipuno'ltiliji weja'tegemg glapis aq me' maljewe'jultiliji. Ula Elot tela'teget muta emittugwe'winu'g gis tlimgwi'tipnn na gloqowej amgwes neia'siteg ta'puipunqegeg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ta'n goqwei Elot teli ilsutegep na gisa'toq tlian st'ge' na niganigjitegewinu Jelamaia gis teluep, ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nutaq nat wen ma'muni atgitemit na utan teluisig La'ma. Na Le'jl etltemit. Mo wen gisi apgnualgugul muta un'jangi'g gis ne'po'tupni.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ta'n tujiw Elotaq gisi np'geg, na So'sep me' eig Ijipte'gatig. Newtejgeg wela'gw pewiatl Gisiteget ugtansale'witeml ap gelultl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Telimtl, “Mn'ja'si, la'l mijua'ji'j aq gte'pitem Lesui'pe'gatig, muta ta'n getu' ne'pa'tipnn mijua'ji'jl gaqi npmu'titgi'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Na menja'sit, ilajit aq apaja'laji mijua'ji'jl aq Malial Lesui'pe'gatig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Na'te'l So'sep nutg Elot uggwisl ta'n teluisilitl Algeleias elege'witewilitl Jutiaewa'gig. So'sep jipasit aq mo sapite'tmug na'te'l liwsin. Ap Gjinisgam telimatl ge's etl puitegelij, “Liwsi Galaliewa'gig.” Toqo ela'tijig Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na'te'l siawqatmu'tijig gjigan teluisig Nasalet. Teliaq ta'n teluepnig niganigjitegewinugi'g muta wesguma'tipnn Se'susal. Teluepnig, “Tl wi'ta'tital Nasaletgewa'j.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Teli pgije'g Sa'n Nutsign'tuet eliet ta'n mu wen wigigw Jutiaewa'gig. Na'te'l pugwelgig mimajuinu'g peita'jig aq Sa'n pestunmuaji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Telimaji, “Gawasgita'sultigw aq jiglita'gw elue'utigtug muta ma' pgije'nug tel'gne'g Gjinisgam ilgwenaji mimajuinu'.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na niganigjitegewinuaq ta'n teluisitaq Aiseia wesgumapnn Sa'nal. Teluep, “Nat wen gesigawewistoq paqtaqamigtug. Teluet, ‘Gisiteget wejgu'et. Ms't ta'n te'sioq gisgajo'ltigw ugjit negm.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na Sa'n ugtaligaml wejitas'gl melgwlejit usapunn aq nasguatl m'gegne'l ugtispisunn. Malqomaji apsoqongewji aq nipugtugewei amu apu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na mimajuinu'g ta'n el'ta'jig Sa'neg tleiawultijig Selusalem, Jutiaewa'gi aq na utann ta'n etegl gigjiw na sipu teluisig Jol'tan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Paqapuguatmi'titl ugtlue'utiwal aq Sa'nal sign'taji na Jol'tanewei sipu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sa'n nemiaj pugwenniji Palasiaq aq Satusiaq peita'liji ugjit sign'tasultinew, telimaji, “Gjinisgam wegaig aq getu' ilsumugsioq. Gilew pa na wijei aq mtesgmug. Pewalioq sign'tulinew muta tel'ta'sultioq na Gjinisgam ma' ilsumugsiwoq pa na sign'tasultioqos. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tlo'ltigw aq tla'taqatigw ta'n goqwei musga'tuanew igtigig lpa gawasgita'sultioq aq ejiglita'ioq elue'utigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tluetoqs'p wetapegsultioq Aplameg gatu telimuloq, Gjinisgam gis ugsua'toqol wegla gun'tal aq gisa'tuta mimajuinualanew ta'n wetapegsultiliji Aplameg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gilew pa na wijei aq miti's ta'n mo wel minigw aq Gjinisgam gisgaje'g ilsumugsinew nige'. Iga'taqewinu gisgaje'g tmta'n miti'sl ta'n mu wel mininugul gigjiw gjip'sgigtug aq nu'gwa'lan. Gjinisgam ilsumatal te'silitl mimajuinu'l ta'n pata'tegelitl st'ge' na iga'taqewinu getu' tla'laji miti'sg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Sign'tuloq samqwanigtug ugjit musga'tun gis gawasgita'sultioq aq ejiglita'ioq elue'utigtug. Gatu negm ta'n jugu'etew me' espe'g aq ni'n. Mu tepawti jel we'gaw pma'tuan umugsng. Ta'n tujiw sign'tugsitoqs'p na e'wtew pugtew aq ignmugsitesnu Wejuli Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wejgu'et, na ilsumata ms't mimajuinu' aq nigtua'lata ta'n tetapua'taqatiliji aq ta'n pata'taqatiliji. Ta'n gelu'sultiliji la'lata wa'so'q st'ge' iga'taqewinu tepgiso'toqol glumgl aq pisqo'toqol uglaqalansmg. Ta'ni mu gelu'sultligwi pija'lata na pugtew ta'n mo naqa'suenug st'ge' iga'taqewinu mawo'toqol siguaqs'te'gnn aq nu'gwa'toqol.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na tujiw Se'sus wet maja'sit Galaliewa'gig aq eliet sipu ta'n teluisig Jol'tan. Pegising Sa'neg ugjit sign'tagun. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sa'n weje'watl ugjit sa'se'wita'silin. Telimatl, “Ni'n tmg gi'l sign'tuigg. Tal gis pipanimin ugjit sign'tulin?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Se'sus telimatl, “Ul'te'lmi. Ge' tla'taqatinej ta'n Gjinisgam tel puatg.” Na Sa'n wel'te'tg aq sign'tuatl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Se'sus gis sign'tuteg, weji natqa'sit na samqwanigtug. Na wa'so'q pana's'g aq Wejuli Nisgam nemu't wejgwi nisa'sit Se'sus un'jig. Nisa'sit st'ge' ples nisaqsing. ");
INSERT INTO micMIQNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na wa'so'q nat wen teluet, “Ula na ngwis ta'n mawi gsalg aq gisa'lit mawi ul'ta'sin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na tujiw Wejuli Nisgam ela'latl Se'susal paqtaqamigtug. Gjimn'tu pegising aq wet nu'gwalatl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Se'sus eig na'te'l ne'wisgegiguna'q aq mo mijjigw. Na toqo gewising. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na Gjimn'tu eliet Se'suseg aq telimatl, “Pa na gi'l na Gjinisgam uggwisin, gisa'tu ula gun'tal ugjit pipnaqanin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Se'sus telimatl, “Moqwa', ma' tela'tegew muta Gjinisgam ugtwi'gatignigtug ewi'gas'g, ‘Mimajuinu ma' iapjiw gisi ugji mimajigw mijipjeweigtug, gatu amujpa majulgwatg ta'n goqwei Gjinisgam teluet.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Na tujiw Gjimn'tu ela'latl Se'susal Selusalemg. Na teluisig sape'wig gjigan. Na'te'l pemgopa'latl ta'n etl mawi esp'teg gjia'sutuo'guomg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Telimatl, “Pa na gi'l na Gjinisgam uggwisin, nisaqalsi, muta Gjinisgam ugtwi'gatignigtug ewi'gas'g ‘Gjinisgam tlimata ugtansale'witemg angweiulinew. Msnultaq aq unaqa'lultaq ugpitnuaq glaman ma' jile'nugul ggatl gun'tewigtug.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Se'sus telimatl, “Moqwa', mu tela'tegew muta mo teltenug. Gjinisgam ugtwi'gatignigtug elg ewi'gas'g, ‘Mo teltenug ugtnu'gwalan Gisiteget na Gjinisgam ta'n emtoqwalg'tt.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Na tujiw Gjimn'tu ela'latl Se'susal ta'n esp'plitl gm'tn aq musga'tuatl ms't elege'witewa'gi'l ugs'tqamug aq ta'n tel mujgajewe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Telimatl, “Ula ms't na ignmultes pa na nutgul'pa'sin aq emtoqwalin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Se'sus telimatl, “Gjimn'tu se'g lia. ma' tela'tegew muta Gjinisgam ugtwi'gatignigtug ewi'gas'g, ‘Emtoqwalates Gisiteget na Gjinisgam aq pas'g lugow.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na tujiw Gjimn'tu naqalatl Se'susal, aq ansale'wijig peita'jig aq apoqonmua'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ta'n tujiw Se'sus nutg Sa'n pija'lut laplusang, naqt'g aq eliet Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mo eliwsigw Nasaletg, gatu eliet aq eliwsit na utan Gapelniam. Ula utan eteg tajigtug na qospem ta'n teluisig Galali. Gi's sa'q na mimajuinugi'g ta'n wetapegsultipnig Sepulano'q aq Naptalio'q gisi ignmut'pnig na maqamigew gigjiw ta'n Gapelniam eteg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ta'n Se'sus wesgowa'sit na'te'l na gisa'toq tlian ta'n goqwei na niganigjitegewinuaq teluisipnaq Aiseia teluepnaq, ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Jigs'tuigw na gilew ta'n tleiawultioq Sepulane'gati aq Naptalie'gati, gilew ta'n wigultioq gigjiw qospemg aq ta'n wigultioq gigjiw sipu ta'n teluisig Jol'tan aq maw na mimajuinu'g ta'n mu Lesui'peulti'gw Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Gilew ta'n pegiji pata'taqatioq na musga'tugsitoqs'p msnmnew iapjiwewei mimajuaqan. Gilew ta'nig mo gejiawoq Gjinisgam, na na'gwegl wejgu'aqal ta'n gji'jiatoqs'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Weja'tegemg na tujiw Se'sus poqji pestung aq teluet, “Gawasgita'sultigw aq jiglita'gw elue'utigtug muta Gjinisgam poqji ilgwenaji mimajuinu' nige'.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Se'sus pem tajiga'sij na qospem ta'n teluisig Galali, nemiaji ta'pusiliji usgewinu'. Na Simon ta'n tel wi'tut Pie'l aq ugjignaml Antle'. Etli usgejig aq e'wa'titl a'pi'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Se'sus telimaji, “Wije'wigw aq gnu'tmultoqs'p aq gisa'lultoqs'p jugwo'lanew mimajuinu'g Nisgamewigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na smtug elege'tiji ugta'pimua aq wije'wa'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Na Se'sus siawa'sit aq nemiaji igtigi ta'pusiliji wijig'tiliji. Na Sepeti uggwisg ta'n teluisiliji Ji'mej aq Sa'n. Pemgopijig ugtuluaq maw ujjual aq etl gisgaja'la'tiji ugta'pimua. Se'sus wigumaji Ji'mejal aq Sa'nal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Smtug gepta'sijig ugtuluaq, naqala'titl ujjual, aq wije'wa'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Se'sus eliet ms't tami Galaliewa'gi aq etl gina'muet a'sutuo'guoml. Pestung na gelu'lg agnutmaqan ta'n Gjinisgam getu' ilgwenaji mimajuinu'g. Nepilaji mimajuinu' ta'n geggunmilij gaqaisg milamu'gl gsnugowaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na agnutmaqan ta'n Se'sus gis tela'tegep gnegg el se'sa's'g na ta'n telgi'g Siliae'gati. Etna ugjit mimajuinu'g pegisitua'tiji gsnugowinu' Se'suseg. Ta'sijig geggunmi'tij gaqaisg milamu'gl gsnugowaqann, ta'sijig welmajo'ltijig, ta'sijig etli ugjipulgutijig, ta'sijig mo gis maita'ti'gw aq ta'sijig na mn'tu' pitu'gwi'liji. Se'sus ms't nepilaji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pugwelgig mimajuinu'g majulgwala'titl Se'susal. Alt tleiawultijig Galaliewa'gig aq na newtisga'qal utann ta'n teluisigl “Newtisga'qal utanji'jl.” Alt tleiawultijig Selusalemg aq Jutiaewa'gig. Alt tleiawultijig qame'g na sipu ta'n teluisig Jol'tan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Se'sus nemiaj pugwenniji mimajuinu' ta'n majulgwalgwi'titl, na so'qwiet gm'tnigtug aq pemgopa'sit. Na unaqapemg mawita'liji gigjiw ta'n Se'sus eig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Na tujiw Se'sus egina'muaji ms't ta'n eimu'tiliji na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Teluet, “Mimajuinu'g ta'nig elita'suala'titl Nisgaml ugjit ms't goqwei, welgwijultijig muta Gjinisgam ilgwenaji aq ignmuaji e'wmanew ta'n goqwei geggung. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mimajuinu'g ta'nig welmajita'sultijig na welgwijultijig muta Gjinisgam ulgwijimata. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mimajuinu'g ta'nig mu espite'lsulti'gw welgwijultijig muta msntaq ugs'tqamu aq ta'n goqwei Gjinisgam teplumapni. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mimajuinu'g ta'nig me' getu' tetapua'la'titl Nisgaml jel mu ta'n pas'g goqwei, welgwijultijig muta Gjinisgam tetapua'lata. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mimajuinu'g ta'nig ewlite'lma'tiji igtigi, welgwijultijig muta Gjinisgam ewlite'lmata. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mimajuinu'g ta'nig apjiw getu' tetapu tlgwitmi'tij uggamlamunual, welgwijultijig muta nmia'tital Gjinisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mimajuinu'g ta'nig gisa'la'tiji igtigi punimtultinew aq ta'n apoqonmua'tiji witapewultinew, welgwijultijig muta tel wi'tujig Gjinisgam un'jang. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mimajuinu'g ta'nig emegweiujig muta majulgwala'titl Nisgaml aq tetapua'taqatijig, welgwijultijig muta Gjinisgam ilgwenaji aq ignmuaji e'wmanew ta'n goqwei geggung. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Welgwijultioq gilew ta'n tujiw mimajuinu'g penoqite'lmugsioq, emegweiugsioq aq egsuaqanimugsioq muta gilew na nnaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gilew wijei emegweiugsitoqs'p st'ge' mimajuinugi'g ta'n mimajultipnig gi's sa'q emegwei'wa'tipni niganigjitegewinugi'g. Pajiji ulgwijultigw muta Gjinisgam ignmugsitoqs'p pugwelgl ta'n goqwe'l geggungl wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Alt mijipjewe'l wigapu'gl ta'n tujiw salawa'tas'gl aq wius ma' sugul'gaqtnug ta'n tujiw salawa'tug. Pa na salawei mo telimanug st'ge' salawei na tujiw mo gelu'lgtnug ugjit gilunaq. Na nugu tewegemg aq etug mimajuinu'g ewjipuguetataq. Ginu pa na wijei aq salawei. Amujpa tetapu mimajultigw aq ms't goqwe'l tetapua'taqatigw ugjit gisa'tunew wantaqo'ti. Na tujiw mimajuinu'g ulgwijultitaq ta'n tujiw eimu'tijig gileweg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“E'wmu'g wasoqweg ta'n tujiw oqonitpa'q. Na wasoqweg wetatenmugsi'gw. Ginu na wijei aq wasoqweg muta Gjinisgam pewatmugsi'gw musga'tuanew ms't mimajuinu'g na gelu'lg awti. Na gjigan ta'n eteg g'p'taq gm'tnigtug ma' gisigatm'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mo wen wasoqwa'tug wasoqonmaqan ugjit pija'tun ligpenignigtug, gatu awna tepa'tutew patawutigtug glaman ms't wen ugtatenmatew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Amujpa tla'taqatigw ta'n goqwei wel'te'tg Gjinisgam aq musga'tugg mimajuinu'g wijei. Ta'n tujiw gis nmitu'tital ta'n goqwe'l gelu'lgl gis tla'taqati'gw na tujiw miwatmua'tital aq emtoqwala'tital gujjinal ta'n eimlitl wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Etug tel'te'tmoq ta'n pegisinap ugs'tqamug ugjit puna'tun Mowisewe'l tplutaqann gisna ta'n goqwe'l niganigjitegewinugi'g gegina'mua'tipnig. Mo weji pgisinu ugjit puna'tun na tplutaqann, gatu weji pgisin ugjit tla'tegen ta'n goqwei gis ewi'gas'g Gjinisgam ugtwi'gatigng. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Migwite'tmug ula. Ta'n mawi apje'ji'jg Mowisewei tplutaqan ma' jigla'tug glapis wa'so'q aq ugs'tqamu gaqiatew. Ms't ta'n ewi'gas'g'p amujpa tliatew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Na ta'n getu wen elist'g na mawi apje'ji'jg Mowisewei tplutaqan aq ptigisei gegnu'tmuaji igtigi wijei tla'taqatinew, na mo me'gite'lmam'g ta'n Gjinisgam ilgwenaji mimajuinu'. Gatu ta'n getu wen tela'teget ula tplutaqan, aq gegina'muaji igtigi wijei tla'taqatinew, negm na me'gite'lmaten ta'n Gjinisgam ilgwenaji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Amujpa me' gtlamia'tigw jel mu na mimajuinu'g ta'n nujigina'mua'tijig Mowisewei tplutaqan gisna Palasiaq. Na telimuloq, pa na mo tla'taqatiwoqos na Gjinisgam ma' gisi ilgwenugsiwoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nutmaioqop na mimajuinugi'g telimut'pnig, ‘Mut ne'pa'tegew. Ta'n wen ne'pa'teget ugsua'laten aq ilsumaten.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Gatu telimuloq, ta'n getu wen wegaiugtuatl igtigl ta'n wijei getlams'tasilitl, na ilsumaten. Ta'n getu wen pepsite'lmatl igtigl ta'n wijei getlams'tasilitl, na la'laten nigantug nutsutaqatijig. Ta'n getu wen pisuite'lmatl igtigl ta'n wijei getlams'tasilitl, na lgimugsin ulmaje'n Mn'tua'gig ta'n pugtew ma' nqa'suenug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Getu' ignmuaj Gjinisgam nat goqwei a'sutuo'guomg gatu migwite'tmn igtig wegaiugtas'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ge's mu ignmuawj ignmatimgewei, smtug lia ta'n wen wegaiugtas'g aq tla'tega ta'n goqwei gisa'lugsioq apaji witapewinew. Na tujiw apsgwa'si a'sutuo'guomg aq ignmuates Gjinisgam nat goqwei getu' ignmuaj. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Pa na nat wen getu' elsutmasg's nat goqwei nigantug tplutaqanigtug, lia negmeg aq ul'te'ltigw ge's mu ela'lulug nutsutaqatijig. Pa na mu tla'tegews'p, na la'lultew nigantug nuji ilsuteget. Na nuji ilsuteget ilsumultew ugsua'lugsin nujiugsua'taqatijig aq negmow pija'lultaq laplusang. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Laplusang siawqattes, glapis gaqi apangitmn ta'n telgi'g gisi ilsumul.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nutmaioqop mimajuinugi'g telimut'pnig, ‘Mut sespo'tegew.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Gatu telimuloq, ta'n getu wen angamatl e'pilitl aq pewalatl wipeman na gis sespe'watl angita'suaqanigtug aq gis pata'teget. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pa na jigla'sin Nisgamewigtug ta'n tujiw angaptmn nat goqwei gisna nat wen, na pun pata'tega gisna amuj mna'tutes gpugugul. Me' gelu'lg nepapigwa'n aq pun pata'tegen je mu elgimulten Mn'tua'gig ge's me' nemitegen. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pa na e'wmu's'p gpitnn pata'tegen, pun pata'tega gisna amuj temte'mnn gpitnn. Me' gelu'lg mo geggunmunn gpitnn aq pun pata'tegen je mu elgimulten Mn'tua'gig muta siaw e'wmnn gpitnn ugjit gis pata'tegen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mimajuinu'g teluepnig, ‘Ta'n getu wen nigtua'latl ugte'piteml amuj ewi'g'g ula ta'n tel puna'laj.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Gatu telimuloq, pa na ji'nm puna'lass ugte'piteml, gatu ugte'piteml mo sespo'tegeligupnn, na gisa'latl e'pilitl sespo'tegelin ta'n tujiw ap malie'wijig igtigl ji'nmul. Na ji'nm ta'n malie'wi'titl ula e'pilitl elg sespo'teget.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nutmaioqop na mimajuinugi'g telimut'pnig, ‘Ta'n tujiw teplumsin, mut suisga'tu ta'n tel wi'tmasi't'p. Amuj tla'tega ta'n goqwei teplumt'p Gisiteget.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Gatu pipanimuloq mu lui'tmasultinew ta'n pa tujiw. Mu gisi lui'tmatmuoq wa'so'q, muta Gjinisgam ugt'pun eteg wa'so'q aq assutg ms't goqwei na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mu gisi lui'tmatmuoq ugs'tqamu, muta Gjinisgam assutg aq nemitoq ms't goqwe'l na'te'l. Mu gisi lui'tmatmuoq Selusalem, muta Gjinisgam na Gjielege'wit assutg na gjigan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mu gisi lui'tmatmuoq gun'jiwal muta Gjinisgam ignmugsioq gtmimajuaqanmual aq ma' gisa'tuoq jel newte' sapun wapa's'gtn gisna mqatawa's'gtn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ta'n tujiw teplumsin pas'g tlua, ‘E'e, tla'tega's.’ gis na, ‘Moqwa', mo gis tela'tegew.’ Mn'tu pewalul tl'te'tmn nat goqwei lui'tmatmn apoqonmuan gi'l tela'tegen ta'n goqwei teplumatmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nutmaioqop mimajuinugi'g telimut'pnig, ‘Pa na gi'l gisa'lin ngutaqigwan na ni'n gis gisa'lultes ngutaqigwates. Pa na gi'l gisi mn'te'muin nipit na ni'n gisi mn'te'multes gipit.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Gatu telimuloq, mut asita'law wen tlia wina'l'sg. Pa na wen paqtne'ite'sg inaqanei gijinuan, mut asita'law jel tlia paqtne'ite'sg elg patatujei gijinuan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pa na wen la'l'sg tplutaqanigtug ugjit ugsua'tulin gtatla'iml, mut asita'law gatu ignmu ugsua'lulin maw ggotm. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pa na sma'gnisg gisa'l'sg pma'latmuan utapsun na'tami se'g, na pma'latmuan ta'n tel puatg aq jel me'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pa na wen pipanimasg's ignmuan nat goqwei, ignmu ta'n goqwei nuta'mat. Pa na wen gtu' mqata'sg's nat goqwei, mqatu.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nutmaioqop mimajuinugi'g telimut'pnig, ‘Gsal gitapaq, gatu masgelm ta'nig getan'sgig.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Gatu telimuloq, Gsal ta'n getan'sgig, aq a'sutmessew ta'nig emegweiasgig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ta'n tujiw gesaloq mimajuinu'g aq a'sutmessewoq na telo'ltioq st'ge' gujjuow ta'n eig wa'so'q aq tel wi'tugsitoqs'p un'jang. Gjinisgam gisa'latl na'gu'selitl lasenin ta'n eimu'tijig gitg gelu'sultijig aq wininultijig. Ignmuetoq gigpesan ta'n eimu'tijig gitg tetapua'taqatijig aq mo tetapua'taqati'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Geituoq Gjinisgam ma' ignmugsiwoq gelu'lgl nat goqwe'l muta gesaloq ta'nig gesalugsioqig. Na ta'nig nujintutma'tijig suliewei gesala'tiji ta'ni gesalgwi'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pa na pas'g geluloqos gitapuaq, mo piltu tla'taqatiwoq jel mu igtigig ta'n mu Lesui'peulti'gw muta gelula'tiji witapua. ");
INSERT INTO micMIQNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Amuj tetapua'taqatioq aq telo'ltijig st'ge' Gujjinu ta'n eig wa'so'q muta iapjiw tel tetapua'teget.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tla'taqatigw ta'n goqwei wel'te'tg Gjinisgam aq mut me'gita'new. Pa na tla'taqatioqos ta'n goqwe'l gelu'lgl ugjit gtu' uli ewistutmu'tinew, na gujjinu ta'n eig wa'so'q ma' ul'te'lmugsiwoq aq ma' ignmugsiwoq goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ta'n tujiw ignmuoq ewle'juinu'g nat goqwe'l, mut me'gita'new muta pewalugsioq ms't wen nmugsinew. Mut tla'taqatinew st'ge' wesgijiangamgusit muta pipanimatl nat wenn pipugwen ta'n tujiw apoqonmuaj ewle'juinu'l a'sutuo'guomg gisna awtigtug. Na pewalaji mimajuinu'g me'gite'lman. Migwite'tmug ula. Etug mimajuinu'g gepmite'lma'tital gatu Gjinisgam ma' goqwei ignmuagul. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ta'n tujiw nat goqwei ignmuoq ewle'juinu'g, tli apoqonmug jel we'gaw gitapuaq ma' gji'tu'ti'gw ta'n goqwei gis tela'taqatioqop. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pa na tela'taqatioq st'ge' na, lpa mo wen geitug. Gatu gujjinu ta'n eig wa'so'q nemitoq ta'n goqwei tela'taqatioq aq nat goqwei gelu'lg ignmugsitoqs'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ta'n a'sutma'tioq mut tla'taqatinew st'ge' wesgijiangamgusultijig. Wegla gesatmi'tij alpugultijig aq a'sutma'tijig a'sutuo'guomg gisna tajigawtigtug muta pewala'tiji igtigi nmianew ta'n tujiw a'sutma'tijig. Migwite'tmug ula. Etug mimajuinu'g gepmite'lma'tita gatu Gjinisgam mo goqwei ignmuagwi. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ta'n tujiw getu' a'sutma'tioq, lta'gw giguowal, g'p'soqwa'tug ga'qann aq a'sutma'tigw ta'n mu wen gis nmu'luoq. Gujjinu eig wa'so'q gatu te'sioq nmu'ltew ta'n teli a'sutman aq ignmultew nat goqwei ta'n tel nuta'man. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ta'n tujiw a'sutma'tioq, mut e'wmu'tinew pugwelgl glusuaqann ta'n mo wen nestmugl, st'ge' na mimajuinu'g ta'n mo Lesui'peulti'gw. Na tel'ta'sultijig Nisgam ul nutuata ta'n tujiw pegiji a'sutma'ti'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mut a'sutma'tinew st'ge' negmow. Gujjinu ta'n eig wa'so'q gi's geitoq ta'n goqwei nuta'ma'tioq gesgmnaq pipanimawoq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Na tli a'sutma'titoqs'p, ‘Nujjinen ta'n wa'so'q eimn, gepmite'tmuleg sape'wig gtwisunm. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pipanimuleg ilgwenan mimajuinu'g glaman majulgwalultaq. Ta'n te's'g goqwei tel'te'tmn na tliaj ugs'tqamug st'ge' ta'n tel tliaq wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Etamuleg ignmuinen gisgug ta'n goqwei nuta'maieg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Apigsigtuinen ntlue'utinal st'ge' ta'n teli apigsigtaqatjig ta'nig opla'lugsieg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mut ignmuin lta'nen winjigigtug, awna jigla'lin elue'utigtug. (Pewatmeg gtelege'wa'gim ms't tami aq iapjiw mawignan. Apjiw getu' gepmite'luleg. Na tliaj.)’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Pa na apigsigtuoqos igtigig ta'n opla'lugsioq, Gujjinu ta'n eig wa'so'q elg apigsigtugsitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pa na ma' apigsigtuawoqos igtigig ta'n opla'lugsioq, Gujjinu ta'n eig wa'so'q ma' apigsigtugsiwoq ta'n pata'taqatioqop.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ta'n tujiw sune'wultioq, mut ali ewlapewultinew st'ge' wesgijiangamgusultijig. Al tlapewultijig st'ge' pestmo'ltijig muta pewala'titl ms't wen gji'tu'tinew sune'wultiliji. Migwite'tmug ula. Etug mimajuinu'g gepmite'lma'tita wegla mimajuinu' gatu Gjinisgam ma' ignmuagwi goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ta'n sune'wultioq, gasigwa'sultigw aq nugwaltugo'sultigw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Na mo wen nenugsioq sune'wultinew gatu Gujjinu wa'so'q geitoq ta'n tela'taqatoqop, aq nat goqwei gelu'lg ignmugsitew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mut mawo'tasultinew milesuaqan ugs'tqamug aq nat goqwe'l mego'tigl ugjit pas'g gilew. Etug juji'jg malqotmi'titl ta'n goqwe'l mego'tigl aq alt jijua'qiatew. Etug gmutnesg ugsua'tultaq gmilesuaqanmual. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Awna tetapu mimajultigw muta Gjinisgam getu' ignmugsitoqs'p milesuaqann wa'so'q. Na'te'l juji'jg ma' malqotmi'ti'gw ta'n goqwe'l mego'tigl. Milesuaqan ma' jijua'qianug wa'so'q aq gmutnesg ma' gisi ugsua'tu'ti'gw gtmilesuaqanmual wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tli angita'sultitoqs'p ta'n etegl gtmilesuaqanmual.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Gis nmitaqatioqs'p muta ugpugugultioq. Ta'n gpugugual tajigo'ltigl na wel nmitaqatioq aq weli ns'tasultioq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Gatu pa na gpugugual mo tajigo'ltinugl na mo welapultiwoq tla'taqatinew ta'n pas'g goqwei. Pa na npapigwo'ltioq na mo goqwei nmitutoqs'p. Pa na elt mo ns'tasultiwoq na mawi mtue'g ugjit gilew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ma gis lugowawjig tapusijig assusijig newtsiniw. Na me' tetapua'lates newte'jit jel mu igtig. Na me' gsalates newte'jit jel mu igtig. Amujpa ignmat Gjinisgam assumulin aq mu ignmuawt milesuaqan assumulin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Na ula telimuloq, mut sespeta'sultinew ugjit mijipjewei gisna aligew ta'n wetmite'tmoq muta gmimajuaqanmual me' gesite'lma'tas'gl jel mu ta'n pas'g goqwei pewatmoq. Gjinisgam me' piamite'tgl gtmimajuaqanmual jel mu mijipjewei gisna aligal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ge' angamug sisipg. Mo iga'taqu'ti'gw, mo mena'taqu'ti'gw aq mo menuege'tigul laqlansigtug. Gujjinu ta'n eig wa'so'q esmaji. Me' piamite'lmugsi'gw je mu sisipg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ma' aji piami pgitawsultiwoq je tlia tel sespeta'sultioq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Amujpa mo sespete'tmuoq ugjit gugunmnew tepiaq aligew. Angite'tmug ta'n teligwegl wasuegl nipugtug. Mo elugutinugul aq mo elita'sultinugul aligal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Telimuloq, na milesipnaq elege'witaq ta'n teluisitaq Salaman mo geggungupnn tetuji glu'lgl aligal ta'n weliantgamgug'pnn st'ge' wegla wasuegl ta'n nigwegl nipugtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gjinisgam na gisa'toqopnn msigu'l uligwenew, gatu sapo'nug etugjel nu'gwa'tuten ugjit epsmn nat goqwei. Pa na sespeta'sultioq na mo piami gtlams'tmu'tiwoq Gjinisgam ignmugsitoqs'p aligal ta'n menuegetuoqol. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Mut sespete'tmnew je tlia na na'gweg iga'qt'tew ta'n ma' geggunmuoq mijipjewei gisna nat goqwei samqwanew. Mut sespete'tmnew jel tlia na'gweg iga'qt'tew ta'n menuegeioqol aligal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Na mimajuinu'g ta'n mo Lesui'peulti'gw iapji sespete'tmi'tij ugjit mijipjewei aq aligal. Na Gujjinu ta'n wa'so'q eig gejugsioq ta'n goqwe'l menuegetuoqol.) ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tmg ignmug Gjinisgam ilgwenugsinew glapis gisa'lugsioq tetapua'taqatinew st'ge' negm. Na tujiw ignmugsitoqs'p ms't ta'n goqwe'l menuegetuoqol. ");
INSERT INTO micMIQNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mut sespete'tmnew ugjit goqwei menuegetoqs'p sapo'nug. Sapo'nug ignmultoqs'p ta'n goqwe'l menuegetoqs'pnn na tujiw. Tepiaq tla'taqatigw ta'n goqwei getu' tla'taqatitoqs'p gisgug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mut ilsumanew igtigig, glaman ma' Gjinisgam ilsumugsiwoq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gjinisgam wijei tli ilsumugsitoqs'p gilew ta'n teli ilsumoq igtigig. Ignmugsitoqs'p st'ge' ta'n goqwe'l tel ignmuoq igtigig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ta'n wen ilsumatl igtigl na negm pa na wijei aq ji'nm getu' tualqa'laj siguaqs'te'gn'ji'j ta'n piteg witapal ugpugugw ge's gmu'j piteg ugpugugw. Wigue'g sespete'tg na siguaqs'te'gn'ji'j ta'n piteg witapal ugpugugw gatu mu wesgutmug na gmu'j ta'n piteg ugpugugw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ge's na gmu'j me' piteg ugpugugw, mu tetapu tlimatl witapal, ‘Nitap ge' apoqnmultes na siguaqs'te'gn'ji'j ta'n piteg gpugug.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Na mimajuinu ta'n ula tela'teget na wesgijiangamugsit. Tmg amujpa tualqa'toq na gmu'j ta'n piteg ugpugugw glaman ulapitew aq gis tualqa'tutew na siguaqs'te'gn'ji'j ta'n piteg witapal ugpugugw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mut ignmuaw 'nmu'jig ta'n goqwei gepme'g muta gawasgita'taq aq matnultaq. Mut ignmuaw tm'tmue'l waiopsgul gulgwi'sg muta alpastesg'taq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pipanigesultigw aq ignmugsitoqs'p, gwilmug aq we'jittoqs'p, mtete'gatigw aq Gjinisgam pana'tutew na ga'qan ugjit gilew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ta'n getu wen pipanigesit na msntew, Ta'n getu wen gwiluasit na we'jittew, aq na ga'qan pana'tuaten ugjit negm ta'n metete'get. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Gilew ta'n te'sioq geggunatl uggwisl ta'n tujiw pipanigesilij pipnaqan ma' ignmuawt gun'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ta'n tujiw pipanigesij nme'jl ma' ignmuawt mtesgmul. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na geituoq ta'n tli ula'latoqs'p gn'januaq aq ignmatoqs'p gelu'lgl goqwe'l je tlia tel lue'ultioq. Ta'n tujiw pipanigesultioq gujjinu ta'n eig wa'so'q me' ignmugsitoqs'p ta's'gl gelu'lgl je mu ta'n goqwei ignmuoq gn'januaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tla'taqatigw ugjit igtigig st'ge' ta'n tel puatmoq tla'taqatinew ugjit gilew. Ula Mowiso'q aq niganigjitegewinugi'g gegina'mua'tipnig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ugji pisgwita'gw apsisqe'g ga'qana'tas'g ta'n pisgwa'mg wa'so'q, muta na ga'qana'tas'g ta'n pisgwa'mg Mn'tua'gig no'q gesge'g aq na awti ta'n eliaq na'te'l naqamase'g. Pugwelgig mimajuinu'g pemita'jig na awti. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ga'qana'tas'g apsisqe'g ta'n pisgwita'toqs'p ugjit msnmnew iapjiw mimajuaqan. Na metue'g lta'new awti ta'n pisgwa'mg wa'so'q. Tegle'ji'jg mimajuinu ta'n we'jitoq na awti.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Angweiasultigw muta alt niganigjitegewinu'g na nujiegsugina'mua'tijig. Wesgijiangamgusultijig muta pewala'tiji igtigi teli angita'sultinew na wantaqamigsultijig st'ge' jijgluewjig gatu awna pisoqqowiegsultijig st'ge' paqtesmug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tl nenuatoqs'p ta'n telqamigsultijig. Aloqomann mo nigwenugl goqominaqsigtug. Mo megnawjig jijjawignejg na ginigwejijuaqsigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Gelu'sit miti's na gelu'lgl minijgl wel minigl gatu ewligwet miti's ewliminit aq minijgl mo gelu'lgtnug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gelu'sit miti's ma' gisi ewliminigw aq na miti's ta'n mo gelu'sigw ma' gisi ul minigw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ta'n tegen miti's mo wel minigw na temto't aq elegemg pugtewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Na glaman tl nenuatoqs'p na egsugina'mua'tijig ta'n tela'taqati'tij.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Mimajuinu'g tel wi'tijig, ‘Gjisaqamaw’ aq jigs'tuitaq gatu mu tla'taqati'gw ta'n goqwei nujj tel puatg. Telimuloq, ma' ignmuam'tjig pisgwita'new ta'n Gjinisgam ilgwenaji mimajuinu'. Ta'n getu wen tela'teget ta'n nujj tel puatg, na ignmut pisgwa'n wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ta'n na na'gweg iga'qt'tew ugjit Gjinisgam ilsumata ms't mimajuinu', pugwelgig tlimitaq, ‘Gjisaqamaw, telimg'tt'pnig mimajuinu'g ta'n goqwei Gjinisgam teluet, ejigltesgaqatt'pnig pugwelgig mn'tu'g aq tela'taqatieg'pnn pugwelgl paqalaiuti'l muta ignmuieg'p ml'gigno'ti tla'taqatinew wegla goqwe'l.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Na tujiw tlimultes, ‘Mo ne'gaw nenu'luoq. Gilew mo tela'taqatiwoq ta'n nujj tel puatg, jiglita'gw ni'neg.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ta'n wen jigs'tgl ntglusuaqanml aq mu elistmugl na tetapua'teget. Negm pa wijei aq na ji'nm ta'n epitoq wiguow gun'tewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ula ji'nm gis tetapua'teget muta ta'n teto'qolaq, sipu'l mespo'qwegl aq ugju'sn melgignewa's'g na wiguow ma' gis maja's'gtnug muta epitas'g gun'tewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ta'n wen jigs'tgl ntglusuaqanml gatu elist'gl na mo tetapua'tegegw. Ula mimajuinu na elue'winu aq pa wijei aq ji'nm ta'n epitoq wiguow t'pgwanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ula ji'nm mo gis tetapua'tegegw muta ta'n teto'qolaq, sipu'l mespo'qegl aq ugju'sn melgignewa's'g na wiguow nisiaqt'tew. Ma'muni nisiaqap.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ta'n Se'sus gaqewistoq ula agnutmaqan na mimajuinu'g paqalaiultijig ta'n tel gina'muelij. ");
INSERT INTO micMIQNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gaqi gji'toq ta'n goqwei Gisitegelitl tel puatmitl. Mu tel gina'muegw st'ge' nujigina'muelitl tplutaqan muta geggung ml'gigno'ti ugjit tl gina'muen. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ta'n tujiw Se'sus metoqiet gm'tnigtug na pugwenniji mimajuinu' majulgwalgwi'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na ji'nm ta'n geggung gsnugowaqan teluisig leplsi eliet Se'suseg. Nutgul'pa'sit aq etawaqtmuatl, “Gjisaqamaw, gisi npilites pa na tli ul'te'tmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Se'sus elisga'sit aq sama'latl. Telimatl, “Getu tla'tegei. Nige' gisi npilul.” Na smtug gisi npiluj na ji'nm. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na tujiw Se'sus telimatl, “Mut wen tlimaw, gatu nat nmiates patlia's aq angamulij. Ta'n tujiw geitoq gisi npisin, na ignmuates ta'n goqwei Mowiso'q teluepnaq nat wen ta'n gisi npisit amujpa ignmuatl patlia'sl. Na tujiw mimajuinu'g gji'tutaq ta'n teli ila'sin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Se'sus pisgwa'j na gjigan ta'n teluisig Gapelniam, na weltesguatl Lo'mewei sma'gnis. Na sma'gnis etawaqtmuatl, ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Saqamaw, ntlugowinum elising nignaq. Me' gatu gesnugwat, mo gis maja'sigw aq ma'muni ulmaje'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Se'sus telimatl, “Wije'ultes aq npila's.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sma'gnis teluet, “Saqamaw, mu tetujiw glu'siw ugjit gi'l mittugwen nignaq. Gi'l na assusin. Pas'g tlua ugjit ntlugowinum npilan aq na tujiw gisi npilut. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na ta'sijig sma'gnisg assumijig, aq ta'sijig sma'gnisg assumgig. Ta'n tujiw newte'jit telimg, ‘Lia.’ na lietew. Igtig telimg, ‘Jugu'a.’ na jugu'etew. Telimg lugowinu, ‘Ula tla'tega.’ na tla'tegetew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Se'sus paqalaig ta'n ula nutg muta na sma'gnisl melgi gtlams'tasilitl. Telimaji ta'ni wije'waji, “Telimuloq, lpa Lesui'pe'gatig menaq wen mo gejiaq ta'n tel ml'gi gtlams'tasit st'ge' ula sma'gnis. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Teplumuloq, pugwelgig mimajuinu'g ta'n mu Lesui'peulti'gw weita'taq ugjipenug aq tg'snug aq mawi pmgopita'taq ugjit ulatalultinew wa'so'qewei pestie'umg. Mijjultitaq maw Aplamal, Isaqal aq Je'gopal ta'n Gjinisgam ilgwenaji mimajuinu' wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Gatu pugwelgig ta'n Lesui'peultijig tualqa'laten gujmug wa'so'q ta'n etl oqonitpa'q. Na'te'l tltemultitaq aq seggapitasultitaq wipitual muta ma'muni ulmajo'ltitaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Na tujiw Se'sus telimatl sma'gnisl, “Nige' gisi nmiates giguaq muta ta'n goqwei getlams'tasin na gis tliaq.” Ge's Se'sus gelulatl sma'gnisl na sma'gnis ugtlugowinuml gisi npilutaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Se'sus eliet Pie'l wiguaq aq nemituatl Pie'l ugjugwiji'tl. Elisinnitl un'po'qoneg aq epsimgeweia'silitl muta gesnugwalitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Se'sus wesua'tuatl ugpitn aq nepilatl. Epsimgewei gaq jigla's'geg. Smtug e'pit esmatl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wijei wela'gw, mimajuinu'g Se'suseg pejo'la'tiji pugwenniji ta'n mn'tu'g wesgweiagwi'tiji. Se'sus gelulaji mn'tu'g aq getaqqatesguaji. Na elg nepilaji pugwenniji gsnugowinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Na ula Se'sus tela'tegej gisa'toq tlian ta'n niganigjitegewinuaq teluisitaq Aiseia teluepnaq, “Ejigla'tugsieg gsnugowaqanminal aq gisi npilugsieg ta'n tel milipna'tieg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ge's Se'sus eig tajigtug qospemg nemiaji pugwenniji mimajuinu' gigjiw gigto'qopugutugwi'titl. Na tujiw telimaji unaqapemg, “Asoqomita'nej qospemg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na nujigina'muet Mowisewei tplutaqan eliet Se'suseg. Na telimatl, “Nujigina'muet, gisgaje'i wije'ulin ta'n getu tami elien.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Se'sus telimatl, “Wowgwisg geggunmi'titl elmalqe'l ta'n loqosma'sultitaq aq sisipji'jg geggunmi'titl ugtwisse'mual ta'n tli atlasmultitaq, gatu mo geggunmu ta'n tli atlasmites je tlia ni'n na mimajuinualsiap.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na igtig Se'sus unaqapeml tlimtl, “Saqamaw, Getu' naji utqutalg nujjaq ta'n tujiw gisi np'g'pnaq. Na tujiw gisgaje'tes wije'ulin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Se'sus telimatl, “Majulgwali aq ignmu ta'n wen mu majulgwaligw utqutalan ta'n nepmlitl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Se'sus tepa'sit ugtuluaq aq unaqapemg wijeiagwi'til. Na poqji taqamoqosugultijig qospemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na jiniw mesgi'g mtugunotg iga'q na qospemg aq ugtuluow suel getapaqtoqweg. Gatu Se'sus nepat. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na unaqapemg tugwa'lgwi'titl aq telimgwi'titl. “Gjisaqaugs'tawinen ge's mu samqwanigtug nepu'tiweg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Se'sus telimaji, “Goqwei ta jipatmoq? Gesi apje'ji'j na getlams'tasultioq.” Na tujiw menja'sit aq ilsutg ugjit nqa's'g ugju'sn aq tgu'g. Smtug ms't goqwei wantaqa's'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Unaqapemg paqalaiultiliji aq telueliji, “Gwastalei, wen ta ula ji'nm jel we'gaw ugju'sn aq tgu'g tela'taqatijig ta'n goqwei teluelitl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Se'sus aq unaqapemg peita'jig qame'g qospemg ta'n teluisig Gatalenewa'gi. Na'te'l weltesgua'tiji tapusiliji ji'nmu ta'n wesgowa'siliji utqutaqane'gatig. Wet tua'tijig elmalqe'g utqutaqane'gatig. Wegla ji'nmu pitu'gwi'tiji mn'tu'g. Na nsano'qonijig, lpa mo wen pemiegw na awti ta'n pemiaq gigjiw na utqutaqane'gatig muta jipala'tiji wegla ji'nmug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Smtug na poqji sesgwala'titl Se'susal, “Gi'l na Gjinisgam uggwisl, goqwei getu' tla'lieg nige'? Peji ugtapulieg ge's mu na na'gweg iga'qt'tew ta'n ugtap'titesnen?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na mu gnegtnug pugwelgig gulgwi'sg etl jigniga'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na mn'tu'g etama'titl Se'susal, “Pa na gtu' tuaqtesguieg, lgiminen pitu'gwinew na ala gulgwi'suigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Se'sus telimaji, “Lta'gw na'te'l.” Na glaman tewalqita'jig ji'nmug aq el'ta'jig gulgwi'suigtug. Na ms't gulgwi'sg jaqal nisitugwi'tij paqse'g aq paqasui naqia'tijig samqwanigtug aq etli npu'tijig na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na ji'nmug ta'n angweiwa'tiji gulgwi'sgi'g wesmultijig aq el'ta'jig gjigan ta'n gigjiw na'te'l. Agnutmi'tij ta'n gis tliaq aq wesguma'tiji na ji'nmu pitu'gwipni mn'tu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Na glaman, ms't wen ta'n eimu'tijig na gjigan naji ultesgua'titl Se'susal. Ta'n tujiw nemia'tij etama'titl jigla'sin umutgiwal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Se'sus aq unaqapemg tepita'jig ugtuluaq aq asoqomita'jig qospemg. Peita'jig na gjigan ta'n Se'sus wigit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ta'sijig ji'nmug ela'la'titl witapual Se'suseg ge's elsma'silitl pismuti'gtug muta mu maja'siligul. Getlams'tua'titl Se'susal npilan. Na Se'sus geitoq ta'n teli gtlams'tmlij aq telimatl ji'nmul, “Gwi's, ul'ta'si. Gtlue'uti'l apigsigtmulan.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ta'sijig nujigina'mua'tijig Mowisewei tplutaqan telimtultijig, “Ula ji'nm tel'te'tg negm na Gjinisgam muta pas'g Gjinisgam gisi apigsigtmuatal ji'nmul ugtlue'uti'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Se'sus gejiaji ta'n teli angita'sultiliji aq telimaji, “Goqwei weji angite'tmoq na ta'n goqwei mo gelu'lgtnug? ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tegen me' nqamase'tew ni'n tla'tegen na apigsigtmaqal ula ji'nm ugtlue'uti'l gisna gisa'l'g mn'ja'sin aq pmien? ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ni'n na mimajuinualsiap aq nige' musga'tultoqs'p geggunm ml'gigno'ti ugs'tqamug ugjit apigsigtman lue'uti'l.” Na tujiw telimatl na ji'nmul ta'n mu maja'siligul, “Mn'ja'si aq mgne'n pismuti. Nige' gisi nmiates.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na ji'nm wenaqa'sit aq enmiet. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ta'n tujiw mimajuinu'g nemia'tij ta'n goqwei Se'sus gis tla'tegep, jipaqita'jig, gatu gepmite'lma'titl Gjinisgaml ta'n tel ignmuaj mimajuinu ula paqalaiwaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Se'sus ejigla'sit na'te'l aq ge's pemiej nemiatl nujintutmalitl suliewei teluisilitl Matiw. Ula ji'nm pemgopit ta'n etl lugwet. Se'sus telimatl, “Majulgwali.” Na gaqama'sit aq majulgwalatl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ge's Se'sus etlatalg Matiwal wiguaq, pugwelgig nujintutma'tijig suliewei aq igtigig lue'winu'g peita'jig. Mawgopita'jig patawutigtug maw Se'susal aq unaqapemg aq mawatalultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ta'sijig Palasiaq nemia'tiji Se'susal aq unaqapemg. Pipanima'tiji Se'sus unaqapemg, “Goqwei ugjit na nujigina'muet etl mawatalultijig nujintutma'tijig aq lue'winu'g?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Se'sus nutuaji ta'n goqwei Palasiaq gis telueliji aq telimaji, “Mimajuinu'g ta'n tajigo'ltijig mo menuege'tigul mal'pale'wilitl, gatu pas'g wegla ta'n gesnugu'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tali ns'tmoq ta'n goqwei Gjinisgam teluet ugtwi'gatigng, ‘Me' pewalgig mimajuinu'g ulm'tu'tinew je mu ms't goqwei gtu' ignmuitaq.’ “Mu weji pgisinu ugjit pipaniman mimajuinu'g ta'n getlamia'tijig majulgwalinew. Awna weji pgisin ugjit pipaniman lue'winu'g majulgwalinew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sa'n Nutsign'tuet unaqapemg peita'jig Se'suseg aq pipanima'titl, “Ninen aq Palasiaq jijuaqa sune'wultieg gatu tal gis gnaqapemg lpa mo sune'wulti'gw?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Se'sus telimaji, “Na mimajuinu'g wigumujig ta'n wesgowa's'g malie'wimg mu ewlita'sulti'gw ta'n tujiw qase'g wijitgweiwa'titl witapual ta'n getu' malie'wilitl. Ge's eimu'tijig maw witapual ma' sune'wulti'gw gatu ta'n tujiw jigla'lut na tujiw sune'wultitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ta'n sa'qawei utapsun pasgine'g, mo wen e'wmug pilei atla'wegn ugjit pgwi'sign muta ta'n tujiw na utapsun gesistaqanut na pgwi'sign apsiaq aq utapsun ap pasgina'sitew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mu wen guta'tug pilei moqopa'q na sa'qawei m'gegnei moqopa'qo'q muta ta'n tujiw moqopa'q pemignaq na pasgina'sitew m'gegnei moqopa'qo'q aq na moqopa'q tli alijuitew. Awna amujpa guta'tu pilei moqopa'q na pilei m'gegnei moqopa'qo'q muta na m'gegnei moqopa'qo'q siptaqa's'gt'tew ta'n tujiw na moqopa'q pemignaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ge's Se'sus etlewo'gwej, na Lesui'pewei niganpuguit pegising aq nutgulpit nigantug Se'susal. Telimatl, “Ntusaq pas'g gisi np'gaq. Wije'wi nignaq aq iga'tunn gpitnn un'jigtug glaman mimajitew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Na Se'sus wenaqa'sit aq wije'watl. Unaqapemg majulgwala'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pemita'tij na e'pit ta'n gis mal'tewiet metlasipunqeg je ta'pu, ugtejg pemiet. Etepnatl Se'susal aq sama'tuatl wesg'plij ugpitu'gunml. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Telimsit, “Pas'g gis sama'taq utapsun, na ila'sites.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Se'sus naqa'sit aq gigto'qopugua'sit. Nemiaj e'pilitl telimatl, “Tu's, mut jipaqa'siw muta teli gtlams'tasin na weji npisin.” Na tujiw na e'pit gisi npisitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na to'q Se'sus siawa'sit aq pisgwa't na Lesui'pewei niganpuguilitl wiguaq. Nemiaj nujintutiliji ta'n gis peita'liji ugjit na utqutamg aq igtigi ta'n sespo'ltiliji, ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","telimaji, “Gis tuita'toqs'p ta'n te'sioq. Ula e'pite'ji'j mo nepmug, pas'g nepat.” Na mimajuinu'g ta'n eimu'tijig wesgewe'wa'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ta'n qase'g ms't mimajuinu'g gaq tuita'tij, Se'sus eliet ta'n e'pite'ji'tl elisinnitl aq wesua'tuatl ugpitn. Smtug na e'pite'ji'j menja'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na mimajuinu'g ta'n esgma'tijig gujmug nutmi'tij ta'n goqwei gis tliaq na naqtmi'tij na'te'l aq telima'tiji igtigi. Tel'gne'ge'l pugwelg mimajuinu'g gis geitu'tij ta'n goqwei gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Se'sus maja'sit na'te'l. Ge's pemiej tapusiliji ji'nmu ta'n nepapigwa'liji majulgwalgwi'titl. Na sesgwala'titl Se'susal, “Geitueg gi'l na teplutasin ta'n wetapegsin Ta'piteg. Ewlite'lminen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Se'sus pisgwa't na wen'ji'guom. Na tapusijig nepapigwa'jig pegisingig. Se'sus pipanimaji, “Getlamite'tmoqos ni'n geggunm ml'gigno'ti ugjit gisi npilulinew?” Telimgwi'titl, “E'e, saqamaw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Na tujiw Se'sus sama'tuaji ugpugugual aq teluet, “Na to'q tliaj ta'n teli gtlams'tmoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Smtug gis nemitegejig. Se'sus melgimaji, “Mut tlimanew wen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Gatu na maja'tijig aq ms't tami na'te'l telima'tiji pugwenniji mimajuinu' ta'n wen gisa'lujig apaji ulapinew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ge's maita'tij, ta'sijig mimajuinu'g pegisitua'titl Se'suseg na ji'nmul ta'n mo gis glusiligul. Na mn'tu'l pitu'gwitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ta'n Se'sus gis ejigltesguatl mn'tu'l, smtug na ji'nm poqtewo'gwet. Ms't wen ta'n eimu'tijig paqalaiultijig. Teluejig, “Menaq nemitueg paqalaiwaqan st'ge' ula Lesui'pe'gatig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Gatu na Palasiaq teluejig, “Tel'te'lmeg Gjimn'tu ignmuatl Se'susal ml'gigno'ti ugjit gtaqqatesguanew mn'tu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Se'sus al mittugwatgl gjigann aq utann. Etl gina'muet te's a'sutuo'guoml aq pestung na gelu'lg agnutmaqan. Telimaji mimajuinu', “Na Gjinisgam gis ilgwenaji mimajuinu'.” Nepilaji mimajuinu ta'n geggunmi'tij milamu'gl gsnugowaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ta'n nemiaj pugwenniji mimajuinu', ewlite'lmaji, muta sespeta'sultijig aq mu tami mo wen apoqonmuagwi. Wegla mimajuinu'g pa wijei aq jijgluewjig ta'n mu gegguna'tigul ta'n wenn nuje'wa'gwi'tital. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Na glaman Se'sus telimaji unaqapemg, “Pugwelgig mimajuinu'g ta'n getu' majulgwala'titl Nisgaml, gatu mu piam pugwelu'g mimajuinu'g ugjit tlimanew ta'n tel majulgwala'tital Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","A'sutma'tigw aq pipanimug Gisiteget lgimanew pugwenniji ugjit tlimanew igtigi na gelu'lg agnutmaqan glapis majulgwalanew Nisgaml.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Se'sus wigumaji unaqapemg ta'n newtisgegsiliji jel ta'pu. Te'siliji ignmuaji ml'gigno'ti ugjit jigltesguaten mn'tu'g aq npitmuaten ta'n te'siliji gesnugu'tiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Se'sus ugapostale'witemg na Simonal ta'n teluisilitl Pie'l aq Antle'al na Pie'l ugjignaml. Igtigig na Sepeti uggwisg ta'n teluisiliji Ji'mej aq Sa'n. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Igtigig na Pilip, Paltolomiw, Tuma aq Matiw ta'n nujintutmat suliewei. Igtigig na Tatias aq Alpius uggwisl ta'n teluisilitl Ji'mej. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Esgwia'tijig na Simon na Genanewa'j, aq Suta Isgaliot ta'n ntuisgalatal Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Se'sus elgimaji newtisgegsiliji je ta'pu ugtapostale'witemg aq telimaji, “Mut emittugwalanew mimajuinu'g ta'n mu Lesui'peulti'gw aq mut lta'new Samaliae'gati. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pas'g lta'gw na mimajuinu'g tleiawultijig Lesui'pewa'gi muta wegla mimajuinu'g menuega'tijig nat wen musga'tunew ta'n majulgwala'tital Nisgaml st'ge' jijgluewjig menuega'tijig nat wenn musga'tuanew ta'n eteg gelu'lg msigu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Lta'gw aq pestunmu'tigw. Telimug, ‘Nige' Gjinisgam getu' ilgwenaji mimajuinu'.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Npilug mimajuinu'g ta'n gesnugu'tijig aq ta'n geggunmi'tij na gsnugowaqan teluisig leplsi. Minua'lug npuinu'g. Jigltesgmug mn'tu'g. Ignmuloq ml'gigno'ti ugjit tla'taqatinew mesgi'gl goqwe'l aq mo pipanimuluoq apangituin. Nige' pewaluloq ignmuanew igtigig ta'n goqwei nuta'ma'tijig aq ma' pipanimuloq apangitugsinew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mut nespnmnew suliewei gisna wisaw suliewei. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mut nespnmnew salitewimgewei mun'ti, igtig atla'i, igtigig mg'sng gisna aptun. Pas'g lta'gw ta'n teloqsultioq. Ta'n tujiw ignmuatoqs'p igtigig ta'n goqwei nuta'ma'tijig na tujiw ignmugsitoqs'p ta'n goqwei menuega'tioq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ta'n peita'ioq utan gisna utanji'j, pisgwita'gw aq gwilug ugjit ta'n wen ul'ta'sitew ultesgugsitoqs'p. Pipanimug ‘Gt'gunitesnen wiguaq?’ Usgowita'toqs'p wiguaq glapis maita'ioq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ta'n pisgwa'tioq na wiguaq, tlimug mimajuinu'g ta'n wigultijig na'te'l, ‘Etaweieg Gjinisgam gepmite'lmugsinew.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Pa na mimajuinu'g ta'n wigultijig na'te'l wel'ta'sultisnig ultesgugsinew, tlimug, ‘Pipanimatesnen Gjinisgam ignmugsinew wantaqo'ti ggamlamunuaq.’ Pa na mimajuinu'g mu weltesgugsiwoq, mut pipanimaw Gjinisgam ignmugsinew wantaqo'ti uggamlamunuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pa na ta'sijig mimajuinu'g gisna ms't wen ta'n wigit na utanji'j mo pewalugsiwoq gisna mo jigs'tugsiwoq, na naqtmug na'te'l aq puaqtestug ggatual. Ta'n tujiw pewaqtestuoq ggatual na musga'tutoqs'p Gjinisgam mu wel'te'lmagwi. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Migwite'tmug ula. Na na'gweg iga'qt'tew ta'n Gjinisgam ilsumata ms't mimajuinu', na me' ewlite'lmata lue'winu' tleiawultiliji na gjigann ta'n teluisigl Satm aq Gamola je mu na mimajuinu'g ta'n mu weltesgugsiwoq wiguaq gisna utan.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Jigs'tmug. Elgimuloq ta'n mimajuinu'g matnugsitoqs'p st'ge' paqtesmug matna'tiji jijgluewji. Tli angweiasultigw st'ge' na mtesgm angweiasit muta ms't wen getangwi'titl. Mut matnaqqa'tinew, awna ms't goqwei sangewa'tug st'ge' plesg sangewo'ltijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ango'tmug, muta mimajuinu'g ilsumugsitoqs'p aq wisqapaqto'ltaq ugta'sutuo'guomuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wegla mimajuinu'g la'lugsitoqs'p ugjit ilsumugsinew g'pnno'laq gisna elege'wiliji muta elugowioq ni'n. Na gelu'lg agnutmaqan tlimatoqs'p wegla mimajuinu'g ta'n ilsumugsioqig aq igtigig ta'n mu Lesui'peulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ta'n tujiw ela'lugsioq ilsumugsinew, mut sespete'tmnew ta'n goqwei tluetoqs'p gisna ta'n tlewistutoqs'p. Ta'n tujiw ula tliatew, Gjinisgam tlimugsitoqs'p ta'n goqwei tluetoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Na glusuaqann ta'n tluetoqs'p ma' gilewewe'l. Gujjuow ta'n eig wa'so'q ignmugsitoqs'p na Wejuli Nisgam ugjit tlimugsinew na glusuaqann tluetoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ta'sijig mimajuinu'g la'la'tital wijig'tultiliji tplutaqanigtug ugjit ne'po'qsinew. Ta'sijig mimajuinu'g wijei tla'la'tita un'janua. Ta'sijig mimajuinu'g gtana'tita ungi'gua aq gisa'la'tita ne'po'qsinew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pugwelgig mimajuinu'g masgelmugsitoqs'p muta gilew na nnaqapemg. Gatu na ta'n wen siawi gtlams'tmuitew ta'n teli pgitawsit, na ugs'tawiaten. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ta'n tujiw amasgipnnugsioq newte' utan, ugsmultigw igtig. ma' gaqa'tuoq gtlugowaqanmuow aq ma' gisi emittugwatmoq ms't gjigan, utann aq utanji'jl Lesui'pe'gatig ge's mu apaja'sia's. Telimuloq, ni'n na mimajuinualsiap. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ta'n wen gegina'masit ma' gepmite'lmamug je mu na nujigina'muet. Na lugowinu ma' gepmite'lmamug je mu na assusit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tepiaq ta'n tujiw ta'n wen gegina'masit gji'tutew st'ge' na nujigina'muet ta'n egina'matl. Tepiaq ta'n tujiw lugowinu tel assutg st'ge' assusit. Pa na niganpuguit tl wi'tuj Gjimn'tu, na wi'gma me' aji mil wi'taten.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Mut jipalanew mimajuinu'g ta'n getanugsioq. Ta'n getu goqwei mimajuinu'g gim tla'taqatijig na musga's'gt'tew. Ta'n getu goqwei mimajuinu'g mimugwa'tu'tip na neia's'gt'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ta'n goqwei gina'muloqop oqonitpa'qigtug pewaluloq agnutmuanew ms't wen miaw na'gweg. Ta'n goqwei gim agnutmultoqs'p amuj gesigaw agnutmug ms't wen. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mut jipalanew mimajuinu'g ta'n getu' ne'po'qsioq. Etug ne'po'qsitoqs'p gatu gjijaqamijual me' siaw mimajultijig. Awna jipalug Gjinisgam muta gis gisa'lata mimajuinu'g lta'new Mn'tua'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Gisi ugja'lates tapusijig sisipji'jg ugjit newte' maqtawe'g suliewei gatu Gujjinu ta'n eig wa'so'q gisi gji'tutew ta'n newte'jilitl nplij. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Me' Gjinisgam gaqi gji'tutoqs'p. Geitoq ta'n te's'gl sapunn gun'jiwaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Glaman mut jipasultinew muta Gjinisgam me' me'gite'lmugsioq je mu pugwelgig sisipji'jg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ta'n getu wen majulgwalit ni'n aq mu jipasigw tliman igtigi na getlams'tuit aq majulgwalit, na tlimates nujj ta'n eig wa'so'q, ‘Ni'n na nnaqapem.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Gatu ta'n getu wen alua'lit aq telimaji igtigi ta'n negm mu na nnaqapemg, na tujiw tlimates nujj ta'n eig wa'so'q, ‘Ni'n na mu nnaqapemuigw.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Pa na tel'ta'sultioqs'p weji pgisin ugjit neia'tun wantaqo'ti ugs'tqamug. Mo gisa'laqig mimajuinu'g ul'te'lminew, gatu awna gisa'lates mimajuinu'g gi'gajita'new aq matntultinew muta mu wel'te'lmi'gw ta'n weni ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ta'n weji pgisinap na gisa'lanew ji'nmug aq uggwisua mo wel'te'tmi'ti'gw ta'n weni ni'n. Ta'n tela'tegep na gisa'lan ji'nm mu wel'te'lmagul ujjl, Ta'n weji pgisinap na gisa'lan e'pit mu wel'te'lmagwi uggwitl aq ugtlu'suesgmual. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na gigmaq me' masgelm'sgig je mu igtigig mimajuinu'g muta majulgwalioq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ta'n getu wen me' gesalatl ujjl gisna uggwitl je mu ni'n, na mu gisgaje'ug majulgwalin. Ta'n getu wen me' gesalatl uggwisl gisna ugtusl je mu ni'n, na mu gisgaje'ug majulgwalin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ta'n getu wen mo majulgwaligw je tlia ulmaje'tew st'ge' ta'n tli ulmaje'tes na mu gisgaje'ug majulgwalin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ta'n getu wen tela'teget pas'g ta'n tel puatg lpa ma' gugunmug iapjiwewei mimajuaqan wa'so'q. Gatu ta'n getu wen tela'teget ta'n goqwei pewatm jel tlia ne'po't muta majulgwalit na guguntew iapjiwewei mimajuaqan wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ta'n getu wen wel'ta'sit ultesgugsinew, na wijei ul'ta'sitew ultesguin ni'n. Ta'n getu wen wel'ta'sit, ultesguin na wijei ul'ta'sitew ultesguan ta'n wen gis petgimip ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Na mimajuinu ta'n gepmite'lmatl niganigjitegewinu'l muta napewo'qwelitl ta'n goqwei Gjinisgam gis tlimtl, na msntew wijei aq ta'n goqwei Gjinisgam ignmuatal niganigjitegewinu'l. Ta'n getu wen wel'ta'sit ultesgulan igtigl gelu'silitl muta eta gelu'silitl, na msntew wijei aq ta'n goqwei Gjinisgam ignmuatal ta'n wenn gelu'silitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Migwite'tmug ula. Ta'n getu wen tegpa'q samqwan ignmuaj ta'n mawi ewle'jilitl nnaqapeml muta eta nnaqapem, na getlewei msntew ta'n goqwei Gjinisgam teplumatl mimajuinu'l ta'n wel'te'lmatl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ta'n Se'sus gaqi gina'muaji unaqapemg ta'n tla'taqatilita, na ejigla'sit na'te'l aq siawa'sit igtigl utann tepaw na'te'l. Getu' gina'muaji mimajuinu' tleiawultiliji wegla gjigann. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sa'n Nutsign'tuet pisit laplusang. Ta'n tujiw nutg ta'n goqwei Nujiugs'tawi'welitl tel lugwelij, na elgimaji unaqapemg mittugwalan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Telima'titl Se'susal, “Gi'l na negm ta'n Sa'n telimugsi'gup wejiep wa'so'q? Pa na gi'l mu na negm, na esgmalatesnen ap igtig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Se'sus telimaji, “Apajita'gw aq tlimug Sa'n ta'n te's'g goqwei nutmoq aq ta'n goqwei nemituoq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tlimug na nepapigwo'ltipnig gis nmitaqatijig, na asgajo'ltipnig gis ul pmita'jig, wegla ta'n geggunmi'tip gsnugowaqan teluisig leplsi gisi npilujig, gepistaqana'tipnig wel nutmu'tijig, npuinu'g minua'lujig aq na ewle'juinu'g nutmi'tij na gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tetuji ulgwijintew ta'n wen mo megtuigw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ge's Sa'n unaqapemg peminmita'lij, Se'sus wesgumatl Sa'nal. Telimaji na mimajuinu' ta'n eimu'tiliji na'te'l, “Ta'n tujiw el'ta'ioq Sa'neg paqtaqamigtug, goqwei getu' nmituoqos na'te'l? Mo getu' nmiwoqop menaqanat ji'nm st'ge' msigu'l asua's'g'pnn ugju'snigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mu el'ta'woq na'te'l ugjit nmianew na ji'nm gegnesit mego'tig aligew. Mimajuinu'g ta'n gegnesultijig mego'tigl aligal wigultijig elege'wituo'guoml. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Geji't ta'n wen nat nmianew paqtaqamigtug. Negm na niganigjitegewinu. Telimuloq, nemioqop negm ta'n me' espe'g jel mu niganigjitegewinu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gjinisgam wesgumapnn aq teluep, ‘Ge' jigs'tui. Nigangima's ntagnutmewinum ugjit gisgaja'tun ta'n gi'l lietes.’ Ula tel wi'gas'g Gjinisgam ugtwi'gatignigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Telimuloq, Sa'n Nutsign'tuet me' gepme'g aq ms't mimajuinugi'g ta'n gis mimajultipnig. Gatu wen me' ewle'jit ta'n Gjinisgam ilgwenaji mimajuinu'g na me' gepme'g aq Sa'n gepmite'lmut ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Weja'tegemgeg Sa'n poqji pestungeg glapis nige' mimajuinu'g ta'n getantaqatijig gisapsgnmi'tij pisgwa'new ta'n Gjinisgam ilgwenaji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mowiso'q aq ms't niganigjitegewinugi'g ta'n mimajultipnig ge's mu Sa'n pegisingeg, wesgutmi'tip ula wijei agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Pa na getlams'tmoqs'p ta'n goqwei wegla mimajuinugi'g gis teluepnig, gejioq Sa'n na Ilaija. Negm na ji'nm ta'n niganigjitegewinugi'g teluepnig pgisintew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ango'tmug ta'n goqwei gis telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Na mimajuinu'g ta'n wigultijig gisgug mu tetapuite'tmi'ti'gw muta pa wijei aq mijua'ji'jg ta'n gaqamultijig gujmug magasan. Mu wel'te'tmulti'gw aq newte'jit telimaji esgwia'tilij, ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Etl'te'muleg'pnn malie'wimgewe'l gtapegiaqann, gatu mo amalgaltiwoqop. Etlintutieg'pnn utqutamgewe'l gtapegiaqann, gatu mo atgitemultiwoqop.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ta'n tujiw Sa'n pegisingeg, na sune'wip aq mo newtmgwanegup moqopa'q. Ta'sijig mimajuinu'g mu wel'te'lma'tigul Sa'nal aq teluejig, ‘Mn'tu pitu'gwitl na ji'nmul.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ni'n na mimajuinualsiap. Ta'n tujiw pegisineg, na mijjiap aq esamqwap. Na wijei mimajuinu'g mu wel'te'lmi'gw aq teluejig, ‘Ge' angamug ala ji'nm. Na pusgi ugsamatalg aq negm na gtigiewinu. Witapa na nujintutma'tiliji suliewei aq lue'winu'.’ Gjinisgam ugtns'tuo'qonm musga'tas'g ta'n goqwei Gjinisgam gis tla'tegep na teliaqewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Se'sus mu wel'te'lmagwi mimajuinu' tleiawultiliji na gjigann aq utann ta'n gis tla'tegepnn pugwelgl paqalaiuti'l. Nemitu'tipnn wegla paqalaiuti'l gatu mo gawasgita'sulti'gw aq mu ejiglita'gw elue'utigtug. Majiaqa'laji, ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Na pajiji mtue'tew ugjit gilew tleiawultioq na gjigann ta'n teluisigl Golasin aq Petse'ta. Gis nmituoq pugwelgl paqalaiuti'l ta'n gi's tela'tegeiap gatu me' siaw pata'taqatioq. Na mimajuinugi'g tleiawultipnig na gjigann ta'n teluisigl Tail aq Saiton lue'ultipnig. Pa na nemitu'tisnn wije'l paqalaiuti'l, na smtug sa'se'wita'sulti'tisoq aq pun pata'taqati'tisoq. Gi's nige' sa'q nasgmi'tisoq maqtawamu'gl aligal aq amalsulti'tisoq wisgipg ugjit musga'tunew mesgo'ltipnig ta'n teli pata'taqatipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Migwite'tmug ula. Ta'n tujiw na na'gweg iga'qt'tew ta'n Gjinisgam ilsumata ms't mimajuinu', na me' ewlite'lmata mimajuinu' tleiawultiliji Tail aq Saiton je mu gilew tleiawultioq Golasin aq Petse'ta. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Gilew tleiawultioq Gapelniam, pewatmi'tij me' espite'lsultijig st'ge' ansale'wiliji, gatu awna lta'toqs'p ta'n npuinu'g eimu'tijig. Pa na mimajuinugi'g tleiawultipnig na gjigan ta'n teluisig Satm nemitu'tisnn wije'l paqalaiuti'l ta'n etl tla'tas'g'pnn gm'tgiwow, na wegla mimajuinugi'g mesgo'ltipnig aq Gjinisgam mo gisi nu'gwa'toqop na gjiganeg. Me' i'ttesoq gisgug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Migwite'tmug ula, ta'n tujiw na na'gweg iga'qt'tew ta'n Gjinisgam ilsumata ms't mimajuinu', Gjinisgam me' ewlite'lmata na mimajuinu' tleiawultilipni Satm je mu gilew tleiawultioq Gapelniam.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na tujiw Se'sus a'sutmat, “Gisiteget, gi'l na nujj aq assutmn wa'so'q aq ugs'tqamu. Miwa'lul muta ula teliaqewei musga'tajig na mimajuinu'g ta'nig mo geggunmi'ti'gw gina'masuti. Gatu wijei mu musga'tuawjig mimajuinu'g ta'nig nestmi'tij pugwelgl goqwe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E'e, Nujj, welm'tun ta'n tujiw tela'tegen ta'n tel puatmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Na tujiw Se'sus telimaji mimajuinu', “Nujj ta'n eig wa'so'q gis ignmuij ms't goqwei. Ni'n na Gjinisgam uggwisl aq mo wen nenuigw st'ge' Nujj ta'n eig wa'so'q gis nenuit aq mo wen nenuagul Nujjl st'ge' ni'n ta'n tel nenaq. Na mimajuinu'g ta'nig musga'tuaqig na gis nenua'titl ta'n wenit Gjinisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Jugwita'gw ta'n te'sioq gispna'tioq aq ta'n sespete'tmoq muta pugwelgl ta'n goqwe'l amsala's'gl aq ignmultoqs'p atlasmultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gina'masultigw ta'n goqwei egina'muloq aq mut listuinew. Welm'tu aq mu emegweiuluoq. Majulgwali aq we'jittoqs'p atlasmimg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta'n goqwei gis gina'muloq mu metue'gtnug ns'tmnew aq ta'n goqwei pipanimuloq tla'taqatinew mu metue'gtnug gis tla'taqatinew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Newte' atlasmutigisg'g, Se'sus aq unaqapemg saputita'jig iga'taqann ta'n glumgl etl nigwegl. Unaqapemg gewisultiliji na glaman tematpo'tu'tilitl na glumgl aq malqotmi'tilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Na ta'sijig Palasiaq migwama'tiji. Tel'te'tmi'tij opla'taqatnew tematpo'tuten glumgl atlasmutigisg'g. Smtug telima'titl Se'susal, “Gis nemitu's'p ta'n goqwei gnaqapemg tela'taqatij. Na suisga'tu'tij tplutaqan muta mo teltenug ugjit ta'n goqwei tla'taqatinew atlasmutigisg'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Se'sus telimaji, “Geju'loq gis gitmoq ta'n goqwei Ta'pito'q tela'tegepnaq ta'n tujiw gewisinteg maw unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pisgwa'pnaq a'sutuo'guomg aq patlia'saq ignmugwi'tipnn na pipnaqan ta'n gisi ignmut'p Gjinisgam. Na telgitas'g ginuewei tplutaqanigtug pas'g patlia'sg gisi malqotmi'tij ala pipnaqan gatu Ta'pito'q aq unaqapemg malqotmi'tip. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Geju'loq gis gitmuoq na patlia'sg we'gaw sewisga'tu'tij Mowisewei tplutaqan te's atlasmutigisg'g ta'n elugowa'titl Nisgaml gjia'sutuo'guomg gatu mo goqwei opla'tu'ti'gup. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Telimuloq na wesgutm ta'n me' gepmite'tas'g je mu na gjia'sutuo'guom. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ta'n goqwei Gjinisgam teluet ewi'gas'g ugtwi'gatigng. Ula na Gjinisgam teluep, ‘Na me' pewalgig mimajuinu'g ule'wanew igtigi je mu ignmuigw wi'sisg ta'n gis ne'pa'la'tipni.’ Pa na ula gji'tuoqs'pnn na mu ilsumawoq mimajuinu'g ta'n mo goqwei opla'tu'ti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ni'n na mimajuinualsiap aq gis tlima's mimajuinu'g ta'n gis tla'taqatitaq atlasmutigisg'g muta assutm.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Se'sus naqt'g na'te'l aq eliet a'sutuo'guomg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Eig na'te'l na ji'nm ta'n geggung malig ugpitn. Na Palasiaq getu' pilsuiw ilsutmua'titl Se'susal glaman pipanima'titl, “Mowisewei tplutaqan gis ignmugsi'guss npitegen atlasmutigisg'g?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Se'sus telimaji, “Pa na wen gilew te'sioq ta'n geggunasnn jijgluewjl aq piji elisinnitl espulqeg elmalqe'g atlasmutigisg'g. Na lietes aq gisi tualqa'lates. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Telimuloq te's mimajuinu me' gepme'g aq na jijgluewj. Na glaman tplutaqan telimugsi'gw gisi apoqonmuan nat wen atlasmutigisg'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Na tujiw telimatl ji'nmul ta'n geggunmlitl malig ugpitn, “Ge' sipisga'tu gpitn.” Na ji'nm elasqa'tuaj ugpitn aq smtug etli ila's'geg, tel gelu'lg pa wijei aq igtig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Na Palasiaq ejiglita'jig aq poqji maw agnutma'tijig ta'n tl ne'pa'ten Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na ta'n tujiw Se'sus nutuateg ta'n goqwei Palasiaq pewatmi'tij na ejigla'sit na'te'l. Pugwelgig mimajuinu'g wije'wa'titl aq Se'sus nepilaji ta'n te'siliji gsnugowinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Telimaji mimajuinu', “Mut tlimanew igtigi ta'n goqwei gis tla'tegei.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ta'n goqwei Se'sus gis tla'teget na gisa'toq tlian ta'n goqwei na niganigjitegewinuaq ta'n teluisipnaq Aiseia gis ewi'g'g'p, ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Gjinisgam teluep, “Ula na ntlugowinum ta'n gisi mgng'p. Mawi gsalg aq gesite'lm'g. Ignmua's Wejuli Nisgam aq tlimata ms't mimajuinu'g ta'n goqwei ni'n teluei tetapua'sn ugjit mimajuinu'g ta'n mo Lesui'peulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Gatu ma' gi'gaja'sigw aq ma' al sesgwegw. Ma' al pestunmug awtigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ulm'tutew ta'n tujiw ultesguatal ta'n wenn aq ewlite'lmatal. Ma' emegwei'wagul ta'n wenn menaqana'litl. Siaw lugwetew glapis ms't tami nenas'g ta'n goqwei Gjinisgam teluet na tetapua's'g ugjit ms't mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ta'n te'sit milapegsultijig mimajuinu'g ta'n mu Lesui'peulti'gw lita'sualatal.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nige' ta'sijig mimajuinu'g pegisitua'titl Se'suseg na ji'nmul ta'n mn'tu pitu'gwitl. Na mn'tu gisa'latl ji'nmul mo gis glusiligul aq npapigwa'lin. Se'sus nepilatl ji'nmul. Lpa gisa'latl nmitegelin aq gisewo'gwelin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na mimajuinu'g ta'n eimu'tijig na'te'l paqalaiultijig aq teluejig, “Tel'te'tmeg ula ji'nm wetapegsit Ta'piteg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Palasiaq nutma'tiji ta'n goqwei mimajuinu' gis tlueliji aq teluejig, “Ula ji'nm ejigltesguatl mn'tu'l ta'n pitu'gwitl mimajuinu' muta na Gjimn'tu ignmuatl ml'gigno'ti ugjit gis tla'tegelin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Se'sus gejiaji ta'n goqwei Palasiaq teli angita'sultiliji aq telimaji, “Ta'n tegenig mimajuinu'g tleiawultijig newte' umutgi nasgwiejig aq matntultijig, na ma' gisi pgijo'lti'gw. Ta'n tegenig mimajuinu'g tleiawultijig newte' gjigan nasgwiejig aq matntultijig, na ma' pgijo'lti'gw. Na wijei tliatew ugjit newte' wi'gmaq ta'n tujiw nasgwiejig aq matntultijig, na ma' saputawsulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pa na Gjimn'tu matnaji mn'tu'g, na gis nasgwiejig aq apugjig sioqwia'titaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Telueioq ni'n ejiglgimgig mn'tu'g muta Gjimn'tu gisi ignmuij ml'gigno'ti ugjit jigltesguanew mn'tu'g. Tami weja'toq na ml'gigno'ti gnaqapemuaq e'wmi'tij ugjit jigltesguanew mn'tu'g. Ta'n goqwei gnaqapemuaq gis tla'taqatijig musga's'g oplite'lmioq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Telimuloq, na Wejuli Nisgam gis ignmuij ula ml'gigno'ti aq e'wm ugjit jigltesguanew mn'tu'g. Ula musga'tugsioq Gjinisgam ilgwenugsioq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ma' gis gim pisgwa'wn ta'n wigit melgignat ji'nm aq ma' gisi jigla'tuawj ta'n goqwe'l negmewe'l glapis tmg goqqwa'l't aq gelpilt. Na tujiw gisi ugsua'tuates. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ta'n wen mo wel'te'tmug ta'n goqwei tela'tegei na lpa giasgiwewei getanit. Ta'n wen mo apoqonmuigw ugjit lugwen na ejiglgimaji mimajuinu' Nisgameg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Etna ugjit ula telimuloq na mimajuinu gisi apigsigtuaten ugjit ta'n gis pata'teget gisna ta'n tegen winjig teluet, gatu ma' apigsigtuam'g ta'n penoqite'lmatl Wejuli Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ni'n na mimajuinualsiap aq ta'n wen mo gegnuimigw na gisi apigsigtuaten, gatu ta'n wen mo gegnuimagul Wejuli Nisgaml ma' apigsigtuam'g, mu nige' gisna iapjiw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Iga'taqug gelu'lg miti's aq guguntoqs'p gelu'lgl minijgl muta ewle'jgl minijgl wejiaqal ewle'jit miti's. Ta'n tujiw angamoq na minijgl ta'n gisigwegl miti'sigtug na tujiw gis geituoq ta'n tegenit na miti's. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gilew pa na wijei aq mtesgmug. Pewatmoq mimajuinu'g tl'te'tmnew gelu'sultioq gatu lpa elue'wa'loq mimajuinu'g. Ta'n goqwei telueioq musga's'g ta'n goqwei giwnaqa angite'tmoq aq gesite'tmoq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Gelu'sit mimajuinu tel'te'tg nat goqwei gelu'lg, na teluet wijei. Gatu na winjig mimajuinu tel'te'tg nat goqwei winjig na glaman teluet wijei ta'n tel'te'tg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Telimuloq, na na'gweg iga'qt'tew ta'n Gjinisgam ilsumata ms't wen. Na tujiw mimajuinu'g amujpa tlima'tital Nisgaml tal gis gis tluep te's'g glusuaqan ta'n mo gelu'lgtnug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gglusuaqanmual na e'wmulten ilsumulg giasgiwowei na getlamia'tijig mimajuinu'g gisna winita'jig mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Na tujiw ta'sijig Palasiaq aq nujigina'mua'tijig Mowisewei tplutaqan telima'titl Se'susal, “Nujigina'muet, getu' nmu'leg lugwatmn paqalaiwaqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Telimaji, “Me' gatu na mimajuinu'g ta'n wigultijig gisgug winsultijig aq awan'ta'suala'titl Nisgaml gatu me' pewatmi'titl paqalaiwaqann. Pipanimioq ugjit tla'tegen paqalaiwaqan gatu mu tela'tegew. Awna Gjinisgam ignmugsitoqs'p na wijei paqalaiwaqan ta'n gisa'toqop ugjit Jonao'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Na ta'n Jonao'q telqatg'p mesginntl nme'jl ugtlaminug nesuguna'q, na wijei ni'n ta'n mimajuinualsiap na igtigig utqutalitaq aq i'ttes na'te'l nesuguna'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ta'n tujiw na na'gweg iga'qt'tew ta'n Gjinisgam ilsumata ms't wenn, na mimajuinugi'g tleiawultipnig na gjigan teluisig Ninapa qamultitaq aq ilsutmugsitoqs'p gilew ta'n wigultioq gisgug, muta gawasgita'sultipnig aq pun pata'taqatipnig ta'n nutua'titeg Jonaal pestunmliteg. Telimuloq, gis nutmoqop na agnutmaqan ta'n me' espe'g je mu na agnutmaqan ta'n Jonao'q pestung'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na tujiw elege'wi'sgw tleiawit T'p'te'snug na qama'sitew aq ilsutmugsitoqs'p gilew ta'n wigultioq gisgug, muta wejiep me' gnegg ugjit jigs'tuan Salamano'q ta'n elege'witewip Isle'lewa'gig. Salamano'q ma'muni ntawe'g'p gatu telimuloq gis nutmoqop na gina'masuti ta'n me' espe'g je mu nat goqwei Salamanewei ns'tuo'qon.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mn'tu tewatqa'sij mimajuinu'l ugtinneg, na saputa'sit glapis pegising ta'n mo goqwei nigwenug. Na'te'l al gwilg ta'n usgowa'sitew. Pa na mu we'jitug, ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","na tlimsitew, ‘Etug apaja'si ta'n wejieiap’. Na apsgwa'sit ta'n wigip aq nemitoq sigue'g na'te'l. Ms't waqame'g aq gaqi ilugwa'tas'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Na tujiw maja'sit aq nemisguaji lluigneg te'siliji mn'tu'g ta'n me' winjultiliji aq negm. Ms't pisgwita'jig aq wigultijig na'te'l. Na mimajuinu ta'n pitu'gwiji wegla mn'tu'g me' gitnme'wit aq amgweseweieg ta'n tujiw pas'g newte'jilitl mn'tu'l pitu'gwiteg. Na wijei tliatew ugjit na winjultijig mimajuinu'g ta'n wigultijig gisgug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Se'sus me' etl glulaji mimajuinu' ta'n tujiw uggwitl aq ugjignama peita'liji. Gujmug pe' gaqamultijig aq telima'titl nat wenn gtu' glulanew Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ula mimajuinu eliet Se'suseg aq telimatl, “Ggij aq gjignamg gujmug eimu'tijig aq getu' glul'sgig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Se'sus telimatl, “Teliaq nigmaq eimu'tijig gujmug. Gatu musga'tuloq ta'n wen pa na wijei aq nigmaq ta'n Gjinisgam ilgwenaji mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na tujiw elu'gwalaji unaqapemg aq teluet, “Angamug nnaqapemg. Wegla na st'ge' ngij aq njignamg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Muta ta'n getu wen tla'tegej ta'n nujj eig wa'so'q tel puatg, na negm wijei aq njignam, ngwe'ji'j gisna ngij.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na wijei na'gweg Se'sus naqt'g na wen'ji'guom aq eliet qospemg. Na'te'l pemgopa'sit ugjit gina'muen. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na pugwelgig mimajuinu'g peita'jig Se'suseg. Na Se'sus tepa'sit unaqapemg ugtuluaq gatu mimajuinu'g me' eimu'tijig sitmug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Pugwelgl ta'n goqwe'l egina'muaji aq telimaji gina'masutiewei a'tugwaqan. Teluet, “Newtejgeg na'gweg nuji iga'taqug naji se'sijio'toqol sginminn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ge's etl se'sijio'toqol sginminn, ta's'gl eljo'ltigl tajigawti'jigtug aq sisipg peita'jig aq malqotmi'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ta's'gl eljo'ltigl maqamigew ta'n wesgijigweg mtasoqigtug. Mo temigtnug maqamigew na'te'l aq sginminn jaqal poqjigwegl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Jijuaqa na'gu'set neia'sit, lpa ma'muni p'teg gun'tewaqamigtug aq nat goqwei nigwegl na'te'l nistaqaluas'gl aq toqo nepgl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ta's'gl sginminn eljo'ltigl ta'n ginigwejijuaqsigtug. Na ginigwejijuaqsi'g wel nigwejig aq wissuignemgwi'tiji wegla glumgl. Na gisa'tu'titl glumgl ewligwegl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gatu ta's'gl sginminn eljo'ltigl gelu'lg maqamigeg. Na sginminn weligwegl aq wel minigl. Alt ta'n wel lastegl na mesngl gasgiptnnaqan te's'gl pile'gl sginminn, alt asugom te'sisga'qal pile'gl sginminn wel lastegl aq alt nesisga'qal sginminn wel lastegl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na glaman Se'sus telimaji, “Angite'tmug ta'n goqwei gis tlimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na tujiw unaqapemg pipanimji, “Goqwei ugjit e'wmnn gina'masutiewei a'tugwaqann ta'n tujiw pestunmaj mimajuinu'g?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Se'sus telimaji, “Gjinisgam gisi ignmugsioq ns'tmu'tinew ta'n goqwei mo nestmi'ti'gw ta'n teli ilgwenaji mimajuinu'. Mo ignmuagwi igtigi ns'tmu'tinew ula. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ta'n getu wen tetapua'toq ta'n goqwei gis gina'muei na ignmuaten ns'tmn me'. Gatu ta'n getu wen mu getu' ns'tmug ta'n goqwei egina'muei na ugsua'tuaten ta'n goqwei nest'g nige'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Etna ugjit na weji e'wmann gina'masutiewei a'tugwaqann ta'n tujiw mimajuinu'g pestunmaqig. Angamijig gatu mo getu' nmitu'ti'gw ta'n goqwei gis tla'tegeiap. Jigs'tuijig gatu mo getu' ns'tmu'ti'gw ta'n goqwei gis tlueiap. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aiseiao'q wesgumapni wegla mimajuinu' aq ta'n goqwei teluepnaq teliaq ugjit negmow. Ula teluepnaq, ‘Gjinisgam teluet, Wegla mimajuinu'g jigs'tmu'titaq aq ap jigs'tmu'titaq gatu ma' ns'tmu'ti'gw. Angaptmi'titaq aq ap angaptmi'titaq gatu ma' nenmi'ti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wegla mimajuinu'g mo getu' angite'tmi'ti'gw ta'n telimuj. Awna ta'n goqwei telimgig mo getu' nutmi'ti'gw aq ta'n goqwei tela'tegei mo getu' nmitu'ti'gw. Pa na nmitu'tiss aq jigs'tmi'tiss, na ns'tmu'tita aq etugjel lita'sulti'tiss ni'neg aq ni'n npila's.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Na me' gatu Gjinisgam wela'lugsioq muta wel nenmu'tioq ta'n goqwei gis nemituoqop aq weli ns'tmu'tioq ta'n goqwei gi's telueiap. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Telimuloq, pugwelg'pnig niganigjitegewinugi'g aq pugwelg'pnig mimajuinugi'g ta'n tetapu mimajultipnig ma'muni gsatmi'tipnig gis nmitunew ta'n goqwei gis nemitu'tioq nige' gatu mo nemitu'tigupnig. Ma'muni gsatmi'tipnig gis nutmnew ta'n goqwei gis nutmu'tioq nige' gatu mu nutmi'tigupnig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Na nige' jigs'tmug aq tlimultoqs'p ta'n telueg a'tugwaqan na ji'nm ta'n iga'taqug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ta'sijig mimajuinu'g nutmi'tij na gelu'lg agnutmaqan ta'n Gjinisgam ilgwenaji mimajuinu' mo nestasulti'ti'gw. Wegla mimajuinu'g pa wijei aq sginminn ta'n eljio'tas'gl tajigawtigtug. Na Mn'tu pegising aq gisa'laji awan'ta'suanew na gelu'lg agnutmaqan st'ge' sisipg peita'tipnig aq malqotmi'tipnn sginminn ta'n etegl tajigawtigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ta'sijig mimajuinu'g wel jigs'tua'ti'tij na gelu'lg agnutmaqan aq wel'ta'suatmi'tij ta'n gase'g nutmi'tij. Wegla mimajuinu'g pa na wijei aq na sginminn ta'n eljio'tas'gl gun'tewaqamigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mo tetapu majulgwatmi'ti'gw ta'n goqwei gis nutmi'tip. Gatu ta'n gase'g goqwei amsala's'g gisna emegweiujig muta poqji majulgwatmi'tij ula agnutmaqan smtug ejigla'tu'tij na gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ta'sijig mimajuinu'g ta'n nutmi'tij na gelu'lg agnutmaqan, me' piamite'tmi'tij ula mimajuaqan aq suliewei. Na awan'ta'suatmi'tij na gelu'lg agnutmaqan aq mo tela'taqati'gw ta'n goqwei Gjinisgam tel puatg. Wegla mimajuinu'g pa na wijei aq na sginminn ta'n eljo'ltig'pnn ta'n ginigwejijuaqsi'g nigwejig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ta'sijig mimajuinu'g wel nutmi'tij na gelu'lg agnutmaqan na nestmi'tij aq wel'te'tmi'tij. Wegla mimajuinu'g pa na wijei aq na sginminn ta'n ji'nm al se'so'toqol gelu'lg maqamigeg. Na mimajuinu'g tela'taqatijig pugwelgl ta'n goqwe'l Gjinisgam wel'te'tgl. Alt tela'taqatijig gasgiptnnaqann nat goqwe'l Gjinisgam wel'te'tgl wijei aq sginminn ta'n gisigwegl aq lastegl gasgiptnnaqann pile'gl sginminn. Alt mimajuinu'g tela'taqatijig asugom te'sisga'qal ta'n goqwe'l Gjinisgam wel'te'tgl aq alt mimajuinu'g tela'taqatijig nesisga'qal ta'n goqwe'l Gjinisgam wel'te'tgl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Se'sus ap telimaji a'tugwaqan. Teluet, “Gjinisgam ilgwenaji mimajuinu'. Na tujiw pa wijei aq ji'nm ta'n iga'taqug'p gelu'lgl sginminn ugtiga'taqang. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Newtejgeg wela'gweg ge's ms't wen nepaj, nat wen piluitelget eliet aq al se'so'toqol sginminn ta'n mo gelu'lgtnugl na wijei iga'taqang. Na tujiw wesmugwat. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na glumgl nigwegl aq poqji lastegl, Na sginminn ta'n mo gelu'lgtnugl nigwegl aq poqji lastegl elt. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Lugowinu'g pipanima'titl assusilitl, ‘Gelu'lg'pnn sginminn iga'tugupnn iga'taqang, tami ta u't jigajewe'l wejiaqal?’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Telimaji, ‘Na ta'n wen getanugsi'gw gis tla'teget.’ Lugowinu'g pipanima'titl, ‘Pewalieg mno'tunen jigajewe'l?’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Telimaji, ‘Moqwa', mu pe'l, tel'te'tm peji mno'tunew na glumgl ge's meno'tuoqol jigajewe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pe' tli alte'j. Ignmatmug toqjigwegl glumgl aq jigajewe'l glapis gisigwegl. Tmg jigajewe'l mno'tutoqs'p, mawpiltoqs'p aq nu'gwa'tutoqs'p. Toqo tujiw glumgl tms'tesnu aq la'tutoqs'pnn laqlansigtug.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Se'sus a'tugwaqan ap telimaji mimajuinu'. Telimaji, “Ta'n Gjinisgam ilgwenaji mimajuinu' na wijei aq na ji'nm ta'n apje'jg sginmin ta'n teluisig mustate' iga'taqug ugtiga'taqang. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Apje'jg sginmin pa na wijei aq wen'ju'sugapunei sginmin. Ta'n tujiw gisigweg na me' mesgi'g je esgwiaqal ta'n nigwegl iga'taqang. Siawigweg glapis miti'suig. Na sisipji'jg peita'jig aq ewi'ga'tijig ugtwisse'mual na miti'sigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Se'sus ap telimaji a'tugwaqan. Teluet, “Ta'n Gjinisgam ilgwenaji mimajuinu' na wijei aq apita'taqan. Na e'pit wesua'toq ms't wapejgl ta'n etegl mun'tigtug aq mawa'toqol maw apita'taqan. Na tujiw mawlusgng ms't. Toqo tujiw ms't gaqi apitaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Se'sus telimaji pugwenniji mimajuinu' a'tugwaqann ta'n tujiw nat goqwei getu' gina'muej. Apjiw telimaji mimajuinu' a'tugwaqann ta'n tujiw egina'muaji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ula tela'teget ugjit gisa'tun tlian ta'n goqwei niganigjitegewinuaq teluepnaq, “Tlimultes a'tugwaqann ta'n tujiw gelululoq. Agnutmua's ta'n goqwei mo geitas'gtnugup weja'tegemg ugs'tqamu gisita's'geg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Na tujiw Se'sus naqalaji mimajuinu' aq pisgwa't wen'ji'guomg. Unaqapemg pisgwita'jig na'te'l aq pipanima'titl, “Tal gis telimjig igtigig a'tugwaqan na wen eljio'toqol jigajewei sginminn?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Se'sus telimaji, “Na ji'nm ta'n iga'toqopnn gelu'lgl sginminn pa na wijei aq ni'n na mimajuinualsiap. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Iga'taqan pa na wijei aq ugs'tqamu. Na gelu'lgl sginminn pa na wijei aq mimajuinu'g ta'n Nisgaml ilgwenji. Jigajewei sginminn pa na wijei aq mimajuinu'g ta'n majulgwala'titl Gjimn'tu'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na piluitelget ta'n iga'toqopnn jigajewei sginminn na Gjimn'tu. Ta'n tujiw meniga'tas'gt'tal na tujiw ugs'tqamu gaqiaq, aq meniga'taqu'tijig na ansale'wijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ta'n tujiw ugs'tqamu gaqiaq na wije'tew tliatew ugjit mimajuinu'g ta'n majulgwala'titl Gjimn'tu'l st'ge' jigajewe'l meno'tmgl aq nu'gwa'tmgl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ni'n na mimajuinualsiap. Ta'n tujiw i'ma's wa'so'q lgimates ansale'wijig ugs'tqamug. Na mawa'la'tita ms't ta'n winsultiliji aq negla ta'n gisa'la'tipni igtigi pata'taqatinew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ansale'wijig pijjio'la'tita pugtewigtug ta'n tltemultitaq aq seggapitasultitaq wipitual muta ulmajo'ltitaq na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Gatu getlamia'tijig mimajuinu'g i'mu'titaq wa'so'q ta'n ujjual eig. Neia'sultitaq st'ge' na'gu'selitl neia'silitl musigisg'tug. Pewaluloq angite'tmnew ta'n goqwei gis telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ta'n Gjinisgam ilgwenaji mimajuinu' na wijei aq nat goqwei ta'n mawi mgo'tig etliga'tas'g iga'taqang. Na ji'nm ge's tel gesgmsing we'jitoq na milesuaqan, gatu apaji angune'g. Teli ul'ta'sit. Na enmiet aq netuisgetoq ms't goqwei ta'n assutg. Toqo apsgwa'sit aq pegwatelg na iga'taqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Elg ta'n Gjinisgam ilgwenaji mimajuinu' wijei aq na ji'nm ali pgwatelg tm'tmue'l waiopsgul. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ta'n tujiw we'jitoq mujgajewei waiopsgw, ms't goqwei netuisgetoq ugjit pgwatelmn mego'tigewei waiopsgw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ta'n Gjinisgam ilgwenaji mimajuinu' pa na wijei aq ji'nmug ta'n a'pia'tijig aq mesna'tiji gaqaisg milamugsiliji nme'ji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ta'n tujiw ugta'pimual waju'elij, na usgewinu'g wetna'titl aq nigtuo'la'tiji nme'ji. Ta'n gelu'sit menuegemg gatu ta'n mu gelu'sigw el jiglo'la'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na wijei tliatew ta'n tujiw ugs'tqamu gaqiaq. Ansale'wijig peita'taq ugs'tqamug aq nigtuo'la'tita mimajuinu'. Tepgiso'lujig pata'tegewinu'g aq tepgiso'lujig gelu'sultijig mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ansale'wijig eljio'la'tita pata'tegewinu'g pugtewigtug. Tltemultitaq aq seggapitasultitaq wipitual muta welmajo'ltitaq na'te'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Se'sus pipanimaji unaqapemg, “Nestmoqol ula ta'n goqwe'l gis telimuloq?” Telimgwi'titl, “E'e.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Na glaman Se'sus telimaji, “Na nujigina'mua'tijig Mowisewei tplutaqan gegnu'tmujig tl gina'muanew igtigi ta'n Gjinisgam ilgwenaji mimajuinu'. Na negmow pa na wijei aq assusit ta'n tewo'toqol pile'l aq sa'qawe'l ugtaligaml ta'n masgo'toqopnn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ta'n tujiw Se'sus gaq agnutgl a'tugwaqann naqt'g na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Apaja'sit umutgig. Etl gina'muet a'sutuo'guom na'te'l. Ta'nig nutua'titl paqalaiultijig. Telimtultijig, “Tami weja'toq telgi'g gina'masuti? Tal gisa'toqol negla mesgi'gl paqalaiuti'l? ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Negm na aluse'wit uggwisl. Negm na Malial uggwisl, aq wijig'tultijig na Ji'mejal, So'sepal, Simonal aq Sutaal? ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na ms't uggwe'ji'jg wigultiliji tet. Tami wej gina'masit ula ms't?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","A' na glapis alua'la'titl. Se'sus telimaji, “Lpa ms't wen gepmite'lmatl niganigjitegewinu'l gatu na wigma aq ta'ni tleiawultiliji ta'n negm wigit ma' gepmite'lm'gwi'tigul.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mo tela'tegegw pugwelgtnug paqalaiuti'l na'te'l muta mimajuinu'g mo getlams'tasulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na tujiw Elot, ta'n niganpuguit Galaliewa'gi, nutmat ta'n goqwei Se'susal gi's tela'tegelipnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Telimaji uglugowinumg, “Ula na Sa'n Nutsign'tuepnaq aq apajipet. Etna na ugjit geggung ml'gigno'ti tla'tegepnn paqalaiwaqann.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Elot migwite'tg ta'n gisa'toqop ne'po'qsin Sa'n Nutsign'tuepnaq. Na gisa'lapni ugsma'gnismg ugsua'lan Sa'no'q, laqpa'lan aq pija'lan laplusang muta Sa'nal telimtl gisi pata'tegen. Elot gis pata'tegep ta'n tujiw malie'wipnig na e'pilitl ta'n teluisilitl Elotias. Na Elotias gis malie'wip. Ugji'nmumt'p na Elot ugjignaml ta'n teluisilitl Pilip. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sa'no'q munsa tlimapnn Elotal, “Mo na teltenug gi'l malie'winew ugjignaml ugte'piteml.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Elot migwite'tg ta'n getu' ne'pa'pna Sa'nal gatu jipalapni Lesui'pa muta Lesui'paq tel'te'lma'tipnn Sa'nal na niganigjitegewinu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Elot ajipuna'teg, maw witapa pestie'ultipnig. Na tujiw Elotias ugtusl amalgalipnn ugjit ta'n te'si'tij eimu'tipnig na'te'l. Na Elot teli ul'ta'sualapnn na e'pite'sl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Teplumapnn e'pite'sl, “Elui'tmasi na ni'n ignmultes ta'n getu goqwei pewatmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na Elotias telimapnn ugtusl ta'n goqwei tluen. Glaman na e'pite'sl telimatl Elotal, “Ignmui Sa'n Nutsign'tuet un'ji tepteg eptaqanigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Elot mesge'g'p muta geitoqop ta'n goqwei Elotias ugtusl pewatmlipnn. Gatu gisi tplumapnn nigantug wegla witapua aq na amuj tla'tegep ta'n goqwei na e'pite's tel puatg'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Na glaman elgimapni sma'gnisg aq temgweta'tipnn Sa'nal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na un'ji pegisitua'tipnn tepteg eptaqanigtug aq ignmua'tipnn na e'pite'sl aq na e'pite's ignmuapnn uggwitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na Sa'no'q unaqapemg peita'lipni laplusang. Wesua'la'tipnn Sa'nal aq utqutala'tipnn. Na tujiw el'ta'pnig Se'suseg aq agnutmua'tipnn ta'n gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ta'n tujiw Se'sus nutmaj Sa'no'q nepg'pnaq na maw unaqapemg elisugultijig ta'n mu wen wigigw Galaliewa'gig. Na mimajuinu'g tel nutma'tij ta'n Se'susal lielita, naqtmi'titl wiguowal aq el'ta'jig ta'n Se'sus eliet. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ta'n tujiw Se'sus pem na'taqama'sij na nemiaji wegla mimajuinu' etli esgmalgwi'titl. Ewlite'lmaji, gepta'sit ugtulg aq nepilaji ta'n gesnugu'tiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ge's mu oqonitpaqiaq, unaqapemg telima'titl Se'susal, “Eimuti'gw paqtaqamigtug. Apugjig oqonitpaqiaq. Amase'ji'jg ta'n utann etegl. Lgimaq na mimajuinu'g utang ugjit nattelmanew mijipjewei ge's mu oqonitpaqianug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Se'sus telimaji, “Mut wen tami lgimanew. Ignmug nat goqwei malqotmnew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Gatu telimgwi'titl, “Geggunmeg pas'g na'ngl pipnaqann aq tapusijig nme'ji'jg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Se'sus telimaji. “Ge' jugwa'tuigw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na tujiw mimajuinu' telimaji, “Pewaluloq pmgopita'new ta'n etli msiguig.” Na wesua'toqol pipnaqann aq nme'ji'jg. Elapa'sit wa'so'q aq a'sutmat. Miwatmuatl Gjinisgaml ugjit na mijipjewei. Nigtua'toqol pipnaqann aq nme'ji'jg aq ignmuaji unaqapemg ugjit smanew mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ms't g'satalulti'tij, Se'sus unaqapemg gis mawo'tu'tij ta'n goqwei piamiaq aq wajua'tu'titl newtisga'qal je ta'pu ligpenignn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Panaemg na'n pituiptnnaqanijig ji'nmug gis smujig aq pugwelgig e'pijig aq mijua'ji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ta'n tujiw Se'sus gis smaj mimajuinu', na telimaji unaqapemg tepita'new ugtuluaq aq asoqomgita'new qospemg. Esgwia'tilij mimajuinu' enmigimaji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Newtugwa'lugwej na gm'tnigtug so'qwiet, naji a'sutmat. Siawqatg na'te'l ta'n gi's oqonitpa'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ge's Se'sus eig gm'tnigtug, na unaqapemg siaw elisugultiliji qospemg. Gitnm'tijig muta asugwetnma'tijig aq maqatgwig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na wejgwapniaq, na'tami ne'w ajiej, Se'sus eliet ta'n unaqapemg eimu'tijig. Wesgit pmiet samqwanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ta'n tujiw unaqapemg nemia'titl Se'susal wesgit pmielitl samqwanigtug, na tujiw jipaqita'jig aq poqji sesgu'tijig. Telimtultijig, “Emlsigtma'ti'gw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Se'sus smtug gelulaji, “Pun jipasultigw, ni'n na. Ml'gito'ltigw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Na Pie'l telimatl, “Gjisaqamaw, pa na gi'l na Se'susewin, ge' wigumi aq gisa'li usgit pmien samqwanigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Se'sus telimatl, “Na to'q jugu'a.” Na Pie'l geptapugua'sit ugtuluow aq wesgit pmiet samqwanigtug. Natguatl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Gatu ta'n tujiw mi'gusit ta'n teli ugju's'g aq ta'n teli maqatgwig smtug poqji gtapa't. Sesgwet, “Gjisaqamaw, ugs'tawi.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Smtug Se'sus elisga'sit aq goqqwa'latl. Telimatl, “Me' ewligtlams'tasin. Goqwei weji megtuin?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ela'latl Pie'lal aq tepa'tijig ugtuluaq. Na tujiw ugju'sn jena's'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ge's eimu'tijig ugtuluaq na unaqapemg emtoqwalgwi'titl aq telimgwi'titl, “Getloqo gi'l na Gjinisgam uggwisl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na siawi asoqomita'jig na qospem aq oqwa'jig Genesaletewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na'te'l mimajuinu'g nenua'titl Se'susal aq nat gima'tiji ta'n te'siliji gsnugowinu' umutgiwaq aq pegisitua'tiji Se'suseg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Etama'titl Se'susal je we'gaw gsnugowinu'g sama'tuanew ugpitu'gunml. Ta'n te'sijig sama'tua'titl Se'susal ugpitu'gunml na gisi npilujig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ta'sijig Palasiaq aq nujigina'mua'tijig Mowisewei tplutaqan weita'jig Selusalemg. Peita'jig Se'suseg aq pipanima'titl, ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tal gi's gnaqapemg elistmi'tij tplutaqann ta'n wejiaqal wetapegsultieg. Mo tetapu gsispa'tu'tigul ugpitnual ge's mu mijjulti'gw?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Se'sus pipanimaji, “Tal gi's elistmu'tioq ta'n goqwei Gjinisgam telimugsi'gw gatu awna tela'taqatioq ta'n telueg gilewewei tplutaqann? ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gjinisgam teluet, “ ‘Gepmite'lm gujj aq ggij.’ Elg teluet, ‘Ta'n wen penoqite'lmaji ungi'gu, amuj ne'po'qsin.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Mo tetapu gina'muawoq ta'n getu wen geggungl goqwe'l ta'n e'wmi'titaq apoqonmuanew ujjl gisna uggwitl. Muta gegina'muoq tluen, ‘Nat goqwei e'wtes ugjit apoqonmulinew na gisi ignmuap Gjinisgam.’ Na tujiw ma' amuj apoqonmuata ungi'gu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Telueioq ula mimajuinu mo amuj gepmite'lmagwi ujjl aq uggwitl. Etna ugjit gisa'loq mimajuinu elistmn Gjinisgam ugtwi'gatign muta pewaloq tla'tegen ta'n goqwei telueg gilewewei tplutaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Me' gatu wesgijiangamgusultioq. Aiseiao'q ewi'g'g'p ta'n goqwei Gjinisgam wesgumugsioqop. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Na tujiw Gjinisgam teluep, ‘Wegla mimajuinu'g telimijig gtu' gepmite'lmin. Gatu lpa mo nugu angite'tmi'ti'gw aq mo tela'taqati'gw ta'n goqwei gis telimg'pnig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ta'n tujiw emtoqwalijig na mu tepawtinug, muta telimaji igtigi me' tla'taqatinew mimajuinue'l tplutaqann jel mu ni'newe'l tplutaqann.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Se'sus wigumaji mimajuinu' aq telimaji, “Jigs'tmu'tigw aq ns'tmu'tigw ta'n goqwei tlimultoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Na mijipjewei nat wen malqotg, na ma' gisa'lugug ula mimajuinu mo glu'sin. Gatu ta's'gl glusuaqann ta'n teluet gisa'lugutal mo glu'sin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na unaqapemg peita'jig Se'suseg aq telimgwi'titl, “Geitu's'p na Palasiaq mo piami gsatmi'tigup ta'n gis tluen?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Se'sus telimaji, “Nujj ta'n eig wa'so'q na mno'tutal ta'n te's'gl goqwe'l mo wel'te'tmug st'ge' na iga'taqewinu mniugtnas'gt'tal ta'n te's'gl goqwe'l mo iga'taqug'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mut sespete'tmug na ta'n goqwe'l wegla mimajuinu'g egina'mua'tijig muta negmow pa na wijei aq nepapigwo'ltiliji. Ta'n tujiw ji'nm ta'n nepapigwa't ilgwenatl igtigl nepapigwa'litl, gitg pitja'taq elmalqe'g”. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pie'l telimatl, “Mo nestmulueg a'tugwaqan. Tlimigw ta'n goqwei gis telue't'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Se'sus telimaji unaqapemg, “Mu piami ns'tmu'tiwoq st'ge' igtigig mo nestmu'ti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Geitu gilew ns'tmu'tinew ta'n getu goqwei mimajuinu malqotg na eliaq ugtlaminug aq toqo wet siaw tuiaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Gatu mimajuinu telgwitg uggamlamun aq teluet na goqwei tel'te'tg. Na ta's'gl glusuaqann ta'n teluet na gisa'lugutal mo glu'sin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ta's'gl goqwe'l ta'n mimajuinu tel'te'tgl gisa'lugutal mo gelu'silin. Alt ta'n goqwe'l telgwitg uggamlamun etug gisa'lan ne'pa'tegen. Alt ta'n goqwei tel'te'tg etug gisa'lan sespe'wan igtigl aq sespo'tegelitl. Alt angita'suaqann etug gisa'lugutal gmutnen. Alt angita'suaqann etug gisa'lugutal pisui agnutman igtigi gisna pisuiman. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ta's'gl goqwe'l mimajuinu tel'te'tgl gisa'lugutal mo gelu'sin. Gatu pa na mimajuinu malqotg'ss nat goqwei aq mu gis gesispa'tegegw na ma' gisa'lnug mo gelu'sin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Se'sus maja'sit na'te'l aq eliet tepaw gjigann teluisigl Tail aq Saiton. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na e'pit ta'n tleiawit Genanewa'gig toqo nige' wigit gigjiw Tail aq Saiton eliet Se'suseg. Gesigaw tlimatl, “Gjisaqamaw, geitu gi'l na teplutasin ta'n wetapegsin Ta'piteg. Ewlite'lmi. Ntus ma'muni gitnmat muta mn'tu pitu'gwitl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Gatu Se'sus mo nimjimuagul. Se'sus unaqapemg telimji, “Jiglgim muta, wesam sespe'g aq alulgwalugsieg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Se'sus telimaji, “Petgimimg ugjit pas'g na Lesui'paq muta mo gegguna'tigul nat wenn ugjit ilgwenagun st'ge' jijgluewjig ta'n gesgo'ltijig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Na jiniw e'pit nutgul'pa'sit Se'suseg aq etamatl, “Gjisaqamaw apoqonmui.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Se'sus telimatl, “Mo teltenug sman 'nmu'jig na mijua'ji'jg wiluowal.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na e'pit telimatl Se'susal, “Gjisaqamaw, teliaq ta'n teluen, gatu we'gaw 'nmu'jig malqotmi'tij nat goqwe'l weji nisiaqal patawutigtug ta'n eteg assusit wiguaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Na glaman Se'sus telimatl, “Tu's melgi gtlams'tmn. Ta'n goqwei pewatmn msntes.” Na smtug ugtusl nepilmutl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Se'sus maja'sit na'te'l aq tajiga'sit qospem teluisig Galali. Na toqjua't wenaqqamigeg aq pemgopa'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pugwelgig mimajuinu'g el'ta'jig Se'suseg. Pegisula'tiji mimajuinu' ta'n gesnugu'tiliji gigjiw Se'suseg. Alt asgajo'ltijig aq alt sawiptna'tijig. Alt nepapigwo'ltijig, alt mo gis glusulti'gw aq alt milipna'tijig. Se'sus nepilaji te'siliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mimajuinu'g paqalaiultijig ta'n tujiw nutua'tij ta'ni mo gis glusultiligupni na gelusultiliji aq nemia'tij asgajo'ltiliji aq sawiptna'tiliji na jajigo'ltilij aq nepapigwo'ltilipni nemitaqatiliji. Na miwatmua'titl Gjinisgaml ta'n Lesui'paq tel miwatmuala'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Se'sus wigumaji unaqapemg aq telimaji, “Ewlite'lm'gig wegla mimajuinu'g muta ne'gaw nesuguna'q wijitgweiwijig. Nige' mo piamianug goqwei malqottaq. Mo getu' pipanimaqig 'nmita'new muta jijuaqa nat wen oqonitpaqietew awtigtug. Getu' smgig ula tet.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Unaqapemg pipanimji, “Tami tet ula paqtaqamigtug ugji we'jittesnen tepiaq mijipjewei ugjit te'sit mimajuinu? Pugwelgig mimajuinu'g eimu'tijig tet.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Se'sus pipanimaji, “Ta's'gl pipnaqann geggunmoqol?” Telimgwi'titl, “Lluigneg te's'gl pipnaqann aq ta'sijig nme'ji'jg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Se'sus telimaji mimajuinu' pmgopita'new. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na tujiw wesua'toqol na pipnaqann aq nme'ji'jg aq miwatmuatl Nisgaml. Nigtua'toqol aq ignmuaji unaqapemg ugjit smanew mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ta'n tujiw ms't wel g'satalulti'tij, Se'sus unaqapemg megnmi'tij piwiaqal mijipjewe'l aq wajua'tu'titl lluigneg ligpenignn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ne'w pituiptnnaqan te'sijig ji'nmug esmujig aq pugwelgig e'pijig aq mijua'ji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Na Se'sus pipanimaji mimajuinu' ugjit 'nmita'new. Na tujiw poqjinmita'ti'tij Se'sus aq unaqapemg. Pisultijig ugtuluaq aq elaqtaqatjig ta'n teluisig Maqatan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ta'sijig Palasiaq aq Satusiaq el'ta'jig Se'suseg. Getu' gistesgua'titl, muta mo getlams'tua'tigul. Na glaman pipanima'titl tla'tegelin paqalaiwaqan ugjit neia'tuanew ugml'gigno'tim wejiaq wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Gatu Se'sus telimaji, “Ta'n tujiw na'gu'set pem galqwasiej, gilew tluetoqs'p, ‘Sapo'nug ul gisgnma'titesnu muta musigisg'tug megwe'g.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Gatu igtig na'gweg ta'n tujiw wejgu segewa't tluetoqs'p, ‘Gigpesatew muta ugjipenug megwe'g aq poqji alugwiaq nige'.’ Ta'n angaptmoq musigisg'tug geituoqop pa na gigpesaq's gisna weligisg'g's. Gis nmituoq aq gis nutmoq ta'n goqwe'l ni'n gis tla'tegeiapnn gatu mo nestmu'tiwoq ta'n goqwei apugjig Gjinisgam tla'tegetew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Me' gatu mimajuinu'g gisgug winjultijig aq mo piami angite'lma'tigul Nisgaml. Gilew telo'ltioq st'ge' negmow muta pipanimioq ugjit tla'tegen paqalaiwaqan. Moqwa' mu tela'tegew paqalaiwaqan. Mu musga'tuluoq ta'n goqwei pewatmoq gatu Gjinisgam musga'tultoqs'p na wijei paqalaiwaqan st'ge' ta'n apoqonmuapnn Jonaal. Ala na pas'g paqalaiwaqan nmitu'titoqs'p.” Na glaman maja'sit aq eliet na'tami se'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ta'n Se'sus aq unaqapemg gis asoqomita'jig qospem, na unaqapemg awan'ta'sultiliji jugwa'tunew pipnaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Se'sus telimaji, “Angweiasultigw aq mut e'wmu'tinew na apita'taqan ta'n Palasiaq aq Satusiaq e'wmi'tij.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Unaqapemg wesgutmi'tilij ta'n goqwei Se'sus gi's teluet telimtultijig, “Na ula wet tluet muta mo pegisitugg pipnaqann.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Se'sus gejiaji ta'n goqwei wesgutmi'tij aq telimaji, “Me' gatu mo piami gtlams'tmu'tioq ignmuinew ta'n goqwei nuta'ma'tioq. Goqwei weji usgutmoq ta'n mo pipnaqann geggunmuoqol? ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mnaq nestasultiwoq. Mo migwite'tmuoq na tujiw nasgwa'tuapnn na'ngl pipnaqann aq esmg'pnig na'n pituiptnnaqanijig ji'nmug. Awan'ta'sultioq ta's'gl ligpenignn waju'pega'tuoqopnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mo migwite'tmuoq na tujiw nasgwa'tuapnn lluigneg te's'gl pipnaqann aq esmg'pnig ne'w pituiptnnaqanijig ji'nmug. Awan'ta'sultioq ta's'gl ligpenignn waju'pega'tuoqopnn na tujiw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tal gi's mo nestmu'tiwoq mu na pipnaqan wesgutmuap ta'n tujiw telimuloqop ugjit angweiatultinew aq mo e'wmu'tinew na apita'taqan ta'n Palasiaq aq Satusiaq e'wmi'tij.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na tujiw unaqapemg nestmi'tij Se'sus mu telimagwi mo e'wmanew apita'taqan gatu lpa telimaji ugjit angweiasultinew aq mu jigs'tuanew ta'n tel gina'mua'ti'tij Palasiaq aq Satusiaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Se'sus aq unaqapemg peita'jig gigjiw na gjigan teluisig Sesalia Pilippai. Na pipanimaji unaqapemg, “Ni'n na mimajuinualsiap gatu tal'tasultijig mimajuinu'g weni ta ni'n?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Unaqapemg telimgwi'titl, “Alt tel wi't'sgig Sa'n Nutsign'tuet. Alt tel wi't'sgig na Ilaija, aq igtigig tel wi't'sgig Jelamaia gisna igtig niganigjitegewinu.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Na Se'sus pipanimaji, “Gatu gilew, tal'ta'sultioq weni ta ni'n?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Pie'l telimatl, “Gi'l na Nujiugs'tawi'wet. Gi'l na Gjinisgam uggwisl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Se'sus telimatl, “Simon, gi'l na Jona uggwisl aq wel'te'lmulg. Mu wen ugs'tqamug telimulgupnig ta'n goqwei gis tl wi'tin gatu nujj ta'n eig wa'so'q gis tlim'sg'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Simon nige' tel wisunalul Pie'l. (Na wisun Pie'l telueg gun'tew ugtli'sutiuow.) Mawa'l'gig ntmimajuinumg gi'leg aq maw nnaqapemg. Mawa'latesnu mimajuinu'g st'ge' aluse'wit mawa'toqol gun'tal ugjit el'tun a'sutuo'guom. Ta'n goqwei tla'tega's ma' nugu wissuignetmug aq npuaqan ma' nugu wissuignemagwi na mimajuinu'g ta'n mawa'latesnu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ignmultes na apt'sqi'gnn ta'n e'wmnn ugjit apt'sqa'mn gisna pansaqamn ta'n Gjinisgam ilgwenaji mimajuinu'. Ta'n goqwei wetqo'loqig mimajuinu'g tla'taqatinew ugs'tqamug na ugt'qoltas'gt'tew wa'so'q aq ta'n goqwei wel'te'lmuoqig mimajuinu'g tla'taqatinew ugs'tqamug ul'te'tas'gt'tew wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Na tujiw Se'sus telimaji unaqapemg mut wenn tlimanew negm na Nujiugs'tawi'wet. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Na weja'tegemgeg tujiw Se'sus menaqa telimaji unaqapemg, “Amuj eliei Selusalemg aq na'te'l na Lesui'paq ta'n niganpugultijig, niganpugultijig patlia'sg aq nujigina'mua'tijig Mowisewei tplutaqan gisa'litaq ma'muniw ulmaje'n. Ne'pa'iten, aq gisi nesuguna'q minunsia's.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pie'l ela'latl ta'n esgwia'tiliji unaqapemg mu eimu'tiligwi. Wetqo'latl aq telimatl, “Gjisaqamaw, na Gjinisgam ma' ignmatmug tlian. Ula amujpa ma' gis tlianug ugjit gi'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Se'sus gigto'qopugua'sit aq telimatl Pie'lal, “Gi'l tel glusin st'ge' Gjimn'tu. Jigla'si ni'neg. Gi'l etegjenin, muta tel'ta'sin st'ge' mimajuinu'g, mu st'ge' ta'n Gjinisgam tel'ta'sit.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Na tujiw Se'sus telimaji unaqapemg, “Ta'n getu wen getu' wije'wij, amuj awan'ta'sualsit aq tla'tegetew ta'n Gjinisgaml tel puatmlitl. Amuj wel'te'tg majulgwalin ni'n je tlia npuaqan ugjiaq. Na tujiw gisi majulgwalitew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Muta ta'n getu wen getu' ugs'tawi'sij na awna np'tew. Gatu na mimajuinu ta'n awan'ta'sualsit muta getu' majulgwalit ni'n je tlia ne'po'qsin na negm msntew iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Etug na mimajuinu gis assutg ugs'tqamu gatu mo geggunmug iapjiwewei mimajuaqan. Na giasgiw mo goqwei ganie'wigw. Mo eigtnug ta'n goqwei ganie'wit pegwatelmn ugjit iapjiwewei mimajuaqan wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ni'n na mimajuinualsiap. Na apaja'sia's maw ansale'wijig. Guguntes mesgi'g ml'gigno'ti. Nujj ta'n eig wa'so'q ma'muni gepmite'lmitew. Ignmuatal te's mimajuinu'l ms't goqwei ugjit ge's giasgiw ta'n gis tla'tegelipnn ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Migwite'tmug ula. Eimu'tioq ta'sioq ula tet ta'n ma' npu'tiwoq glapis gisi nmia's wa'so'q aq apaja'sia's. Ni'n na mimajuinualsiap aq ta'n tujiw apaja'sia's na tujiw ni'n elege'witewites.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ta'n tujiw gaqiaql asugom te'suguna'q Se'sus so'qwiet ta'n etli esp'teg gm'tnigtug. Na'te'l ela'laji pas'g Pie'lal aq Ji'mejal aq Ji'mej ugjignaml ta'n teluisilitl Sa'n. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Na'te'l Se'sus sa'se'wamugwa'sit. Na ugsisgw pitiata's'g st'ge' na'gu'set, aq utapsunn tli gsi wape'gl st'ge' waseteg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na unaqapemg nemia'tiji Mowisal aq Ilaijaal pegisingig aq poqji glula'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pie'l telimatl Se'susal, “Gjisaqamaw, na maw glu'lg tet eimu'tieg, pa na pewatmn ltua's nesisgl anapjetegewe'l, newte' ugjit gi'l, aq te's newte' ugjit Mowis aq Ilaija.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ge's Pie'l etlewo'gwej, jiniw na gesateg alug naqa's'g tetpaqiw ta'n gaqamultijig. Nat wen ta'n eig alugwigtug teluet, “Ula na ngwis ta'n mawi gsalg. Jigs'tug negm.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ta'n tujiw unaqapemg nutmi'tij ula jipaqita'jig aq getgugjesmita'jig maqamigeg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Se'sus eliet aq sama'tuaji un'jiwaq aq telimaji, “Qamultigw. Mut jipasultinew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ta'n tujiw toqjuapita'jig mo wenn nemia'tigul, pas'g Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ge's pem nisita'tij gm'tnigtug, Se'sus telimaji unaqapemg, “Ni'n na mimajuinualsiap. Mut wen tlimanew ta'n goqwei gis nmituoq glapis minunsian.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na unaqapemg pipanima'titl, “Tal gi's nujigina'mua'tijig Mowisewei tplutaqan teluejig Ilaija amujpa tmg pgisintew?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Se'sus telimaji, “Ilaija amuj nigani pgising ugjit gisgaja'tun ms't goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gatu telimuloq, Ilaija gis pegising aq mimajuinu'g mo nenua'tigul. Ta'n pas'g goqwei getu' tla'la'tipnn na gi's tela'taqatipnig. Ni'n na mimajuinualsiap aq wijei emegweiwitaq st'ge' ta'n pas'g getu' tle'wijig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na tujiw unaqapemg nestmi'tij Se'sus wesgumatl Sa'n Nutsign'tuelitl ta'n tujiw ewi'tapnn Ilaijaal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ta'n tujiw apaita'jig ta'n mimajuinu'g eimu'tijig na ji'nm eliet Se'suseg aq nutgul'pa'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Telimatl, “Saqamaw, ewlite'lm ngwis. Wejipulgwet aq tel gitnmat gaqaisg nisiet pugtewigtug gisna paqasiet samqwanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ela'l'g'p gnaqapemg aq pipanimg'pnig npilan gatu mo gisi npila'tigupnn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Se'sus teluet, “Me' gatu gilew ta'n wigultijig gisgug mo getlams'tasultiwoq aq ewnasa'tuoqop ta'n goqwei gis gina'muloq. Me' gatu tali pgitgalultoqs'p? Tali pgiji gina'multoqs'p glapis getlams'tmu'tioq.” Na tujiw telimatl ji'nmul, “Jugwa'li na lpa'tuj.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Se'sus telimatl mn'tu'l tualqa'sin lpa'tuj ugtinneg aq tewalqa'silitl. Smtug gisi npilut. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Se'sus unaqapemg peita'jig Se'suseg ta'n tujiw newtugwa'lugwelitl aq pipanima'titl, “Tal gi's mo gis tualqa'luaqatt na mn'tu?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Se'sus telimaji, “Mo gis tla'taqatiwoq muta mu piami gtlams'tmu'tiwoq. Migwite'tmug ula. Ta'n tujiw gtlams'tuaqanmuow na telgi'g st'ge' mustate' sginmin, na gis tlimatoqs'p gm'tn, ‘Tet ugji maja'si aq ala tet lia.’ aq lietew. Mo goqwei etenug ta'n mu gis tala'taqatiwoq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Gis tualqatesguoqs'p mn'tu ta'n tujiw gis uli a'sutma'tioq aq ta'n tujiw gis sune'wultioq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ta'n tujiw Se'sus unaqapemg gis mawita'tij Galaliewa'gi, Se'sus telimaji, “Ni'n na mimajuinualsiap gatu mimajuinu'g ugsua'litaq aq ignmuitaq igtigig assumin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ne'pa'itaq gatu nesuguna'q iga'qt'tew na minunsia's.” Ta'n tujiw unaqapemg nutmi'tij ta'n goqwei Se'sus gi's teluet na me' gatu mo welgwijulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na Se'sus aq unaqapemg peita'jig na gjigan teluisig Gapelniamg. Ge's eimu'tijig na'te'l, mimajuinu'g ta'n nujintutmi'tij suliewei ugjit a'sutuo'guom, el'ta'jig Pie'leg aq pipanima'titl, “Na gilewewei nujigina'muet ignmuatg na suliewei ta'n Mowisewei tplutaqan telueg te's mimajuinu ela'toq a'sutuo'guomg te's newtipunqeg?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pie'l telimaji, “Tal ma.” Pie'l pisgwa'j ta'n Se'sus wesgowa'sit. Se'sus pipanimatl, “Simon, tal'te'tmn? Na elege'wit elgimaji nujintutma'tiliji suliewei ugjit mawo'tu'tilita na suliewei. Wen apangitmuatl suliewei ta'n elege'wit pewatg, na elege'wit un'jang gisna igtigig?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pie'l telimatl, “Igtigig.” Se'sus teluet, “Na teliaq, Mo teltenug ugjit elege'wit un'jang apangitmnew na suliewei ta'n elege'wit pewatg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Gatu ginu mo getu' gisa'luggw nujintutma'tijig suliewei oplite'lmugsinew. Na glaman qospemg lia, naji usga. Amgwesewei nme'j pe'tult, na ugtung we'jituates tepiaq suliewei ugjit ni'n aq gi'l. Na ugsua'tu aq ignmuaten mimajuinu'g ta'n nujintutma'tij suliewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na tujiw unaqapemg el'ta'jig Se'suseg aq pipanimgwi'titl, “Ta'n getu tami Gjinisgam ilgwenaji mimajuinu' wen me' gepme'g na'te'l?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Se'sus wigumatl mijua'ji'jl aq gaqama'latl nigantug unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Na telimaji, “Migwite'tmug ula. Amujpa sa'se'wita'sultioq aq getlams'tmu'tioq st'ge' mijua'ji'jg. Pa na mo tla'taqatiwoq ma' pisgwita'woq ta'n Gjinisgam ilgwenaji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ta'n wen mu espite'lsigw aq elita'sualatl Nisgaml st'ge' ula mijua'ji'j elita'sualaji ungi'gu, na negm mawi gepme'g ta'n getu tami Gjinisgam ilgwenaji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ta'n getu wen ulasua'latal mijua'ji'jl st'ge' ula mijua'ji'j muta tel puatm, na ulasua'litew ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mo gelu'lgtnug ta'n tujiw nat wen gisa'latl pata'tegen newte'jilitl mijua'ji'jl ta'n getlams'tuilitl. Me' glu'lgtesoq na ugjitaqaneg gelpilaj mulinewei gi'taqane'l aq ejiglpega'lut gta'nug je mu gisa'latl mijua'ji'jl pata'tegen. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ma'muni mtue'g muta na pugwelgl ta'n goqwe'l gisa'lugwi'tiji mimajuinu'g pata'taqatinew. Wegla amuj tliatal gatu me' pajiji mtue'tew ugjit na mimajuinu'g ta'n pegwatu'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Pa na e'wmnn gpitnn gisna ggatl ugjit pata'tegen amujpa pun tla'tegen je tlia temte'mn gpitn gisna ggat. Muta me' gelu'lgt'ss siaw mimajin aq mu gisi pata'tegen ta'n mo geggunmun gpitn gisna ggat je mu elaqalulten ta'n pugtew iapjiw eteg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pa na angaptmn nat goqwei aq ula gisa'l'sg pata'tegen, na me' gelu'lg ugjit mna'tutes gpugugul aq jiglegetes je mu siaw pata'tegen. Me' gelu'lg gis lien wa'so'q ta'n tujiw nepapigwa'n je mu ta'n tujiw me' nemitegen na elgimimg pugtewigtug Mn'tua'gig ta'n pugtew iapjiw eteg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ango'tmug mu gtanan na mimajuinu ta'n elita'sualin ni'n st'ge' ula mijua'ji'j elita'sualin. Telimuloq na ansale'wit ta'n angweiwatl na apjiw i'mlitl ta'n Nujj eig wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ni'n na mimajuinualsiap aq pegisinap ugjit ugs'tawian ta'n gesgo'ltijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Tal'ta'sultioq? Tala'teges na ji'nm geggunaji gasgiptnnaqaniliji jijgluewji toqo newte'jilitl gesga'litl? Na naqalaji pesgunateg te'sisgegsiliji je pesgunateg ta'n etl pesgwatalultiliji wenaqqamigeg aq naji gwiluatal ta'n gesga'litl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Telimuloq ta'n tujiw we'jiaj, na me' wel'ta'sit ugjit ula newte'jilitl je mu esgwia'tiliji ta'n mo gesgo'ltligupni. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na nujj ta'n eig wa'so'q wijei mo pewalagwi gs'go'ltinew wegla mimajuinu' ta'n majulgwalin ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Pa na nat wen ta'n getlams'tuatl Nisgaml st'ge' gi'l, na opla'l'sg, lia negmeg aq tlim ta'n tela'tegen. Gatu pas'g tlim, mu wen piluei. Pa na wel'te'tg ta'n goqwei gis tlimt, na gilew apaji ul'te'ltulitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pa na mu wel'te'lmulug, lia aq pipanim gitap gisna gitapaq wije'ulin. Na gji'tu'titaq ta'n te's'gl goqwe'l elsutmasgl aq ta'n goqwei tlimultew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pa na mu jigs'tmagwi gitapg, na tujiw tlim mimajuinu'g ta'nig getlams'tmi'titl Nisgaml. Pa na me' mu jigs'tmugsiwoq gilew ta'n tego'tmoq, na tujiw geituoq negm pa wijei aq nat wen ta'n mu getlams'tmug gisna ta'nig nujintutma'tijig suliewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Telimuloq, ta'n goqwei wetqo'loq mimajuinu tla'tegen ugs'tqamug na ugtoqolutew wa'so'q. Ta'n goqwei wel'te'tmoq ugs'tqamug ul'te'tas'gt'tew wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Me' telimuloq nat goqwei. Ta'n getu tujiw tapusioq wel'te'tmoq aq wijei etamoq Gjinisgam, na Nujj ta'n eig wa'so'q na tla'lugsitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Muta ta'n getu tami mawita'tij tapusijig gisna je me' ta'nig getlams'tmu'tijig, na ni'n eim miawe'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Na tujiw Pie'l eliet Se'suseg aq telimatl, “Gjisaqamaw, etug nitap tela'lit nat goqwei wins'g. Na opla'lit aq lluignegl wije'l siaw tla'litew. Ta'sisga'q siaw apigsigtaq, na lluigneg te's'gl?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Se'sus telimatl, “Moqwa', mu na lluigneg te's'gl, gatu amujpa apigsigtu me' pugwelgl glapis apigsigtaq ne'w gasgiptnnaqan te'sisga'q jel pesgunateg te'sisga'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Muta ta'n Gjinisgam ilgwenaji mimajuinu'g na negm pa na wijei aq na elege'wit ta'n getu' mawa'toq ta'n tel tettuj uglugowinumg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ge's angapt'g na wi'gatign, nemitoq tel wi'gas'g ugjit te's lugowinu tettugwi'titl. Na tujiw pisgwa'lut lugowinu ta'n tettuatl newtisga'qal pitu' pituiptnnaqana'igl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ula lugowinu mo geggunmug tepiaq suliewei ugjit gisi apangituan na elege'wilitl tettuo'qon. Na glaman tujiw assusit pipanimatl igtigi pgwatelgwi'tiji na lugowinu'l maw ugte'piteml aq un'janua. Na elege'wit guguntew alt suliewei ugjit na tettuo'qon. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Na lugowinu nutgul'pa'sit aq etamatl elege'wilitl, ‘Saqamaw, etamul mu uggwaiugtu'liw. Pe'l gijga esgmali glaman gisi apat apangitultes ta'n telgi'g tettul.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na tujiw elege'wit ewlite'lmatl uglugowinuml. Apigsigtuatl aq telimatl, ‘Mo goqwei tettuin.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Na ula lugowinu maja'sit aq weltesguatl igtigl toqo lugwepnig ta'n tettal gasgiptnnaqana'igl. Goqqwa'latl aq poqji gestuna'latl. Telimatl, ‘Apangitui smtug ta'n telgi'g tettuin.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Na igtig lugowinu nutgul'pa'sit aq etamatl, ‘Pe'l esgmali aq apat apangitultes ta'n telgi'g tettul.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Gatu mo esgmalagul, awna gisa'latl pija'lugsilin laplusang glapis gisi apangitmlij. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ta'n tujiw igtigig maw lugutijig nemitu'ti'tij ta'n gis tliaq, mo welgwijulti'gw aq naji tlima'titl assusilitl ta'n goqwei gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Na assusit natgimatl na lugowinu'l aq telimatl, ‘Gi'l gis winsin, mo tali ugtapsuniwn. Apigsigtulap aq telimulap, mo goqwei tettuin muta pipanimi't'p ewlite'lulin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Amujpa ewlite'lmat na gitap st'ge' ni'n ta'n teli ewlite'lmulap.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Assusit ma'muni uggwaig aq lugowinu'l ilsumatl laplusang glapis gis apangitmlij ta'n te's'g tettuelij.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Se'sus telimaji unaqapemg, “Pa na mu wel'te'lmuoq apigsigtuan igtigig ta'n tujiw opla'l'sg'pnig, nujj ta'n eig wa'so'q ma' apigsigtuluoq. Nujj tle'wultew st'ge' gilew tele'woq igtigig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ta'n tujiw Se'sus gaqewistoq ula agnutmaqan, na maja'sit Galaliewa'gig aq eliet qame'g sipu ta'n teluisig Jol'tan Jutiaewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pugwelgig mimajuinu'g majulgwala'titl na'te'l. Se'sus nepilaji ms't wen ta'n gesnugu'tiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ta'sijig Palasiaq el'ta'jig Se'suseg. Wejo'tmi'tij gistesguanew. Na pipanima'titl, “Gt'tplutaqanminu telteg na ji'nm gis nigtua'latl ugte'piteml ugjit ta'n pas'g goqwei pewatg?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Se'sus telimaji, “Geituoq ta'n goqwei gis ewi'gas'g Gjinisgam ugtwi'gatign. Geituoq ta'n goqwei Gisiteget tela'tegep ta'n tujiw gisitoqop ugs'tqamug. Gisiapni ji'nmul aq e'pilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Gjinisgam telimapnn ji'nmul amuj nqalatal ujjl aq uggwitl aq toqwa'jig ugte'piteml. Na tujiw na tapusijig toqwa'lujig st'ge' newte'jit mimajuinu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Glaman mo nugu tapusi'gw, gatu st'ge' pas'g newte'jit mimajuinu. Ma' wen nigtua'lagwi wegla tapusiliji ta'n Gjinisgam gisi tgwa'laji.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Palasiaq pipanima'titl, “Goqwei ugjit Mowiso'q e'w'g'p tplutaqan ta'n telueg na ji'nm ta'n getu' nigtua'latl ugte'piteml amujpa ewi'g'g ta'n goqwei getu' tla'teget aq ignmuatal ugte'piteml, na tujiw jigla'latal ugte'piteml?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Se'sus telimaji, “Mowiso'q eliamugsioqop gis nigtua'latoqs'p gte'pitemuaq muta wesam ml'gatpa'tioq. Ta'n tujiw Gisiteget el'toqop ugs'tqamu mo ignmuagupni mimajuinu' punaltultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Telimuloq, na ji'nm sespo'teget ta'n tujiw na puna'latl ugte'piteml ta'n mu sespo'tegeligul aq malie'wijig igtigl e'pilitl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Se'sus unaqapemg telimgwi'titl, “Pa na ula telteg ugjit e'pit aq ji'nm, me' glu'lgtesoq mu malie'wigusnn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Se'sus telimaji, “Eimu'tijig mimajuinu'g mu wel'te'tmi'ti'gw ula gina'muaqan gatu Gjinisgam ignmuaji igtigi ul'te'tmu'tinew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Teliaq na eimu'tijig ji'nmug ta'n ma' gisi malie'ulti'gw. Alt ta'n tujiw ugs'tqamultigusnig na nat goqwei teliaqap aq ma' gisi malie'ulti'gw. Alt gis mensasultipnig aq nige' mu gisi malie'ulti'gw. Alt mu malie'ulti'gw muta tel'te'tmi'tij ta'n tujiw mnaq malie'wulti'gw na me' gelu'lg pisgwita'new ta'n Gjinisgam ilgwenaji mimajuinu' je mu igtigi ta'n gis malie'wiliji. Ta'n getu wen ul'te't'tew ula gina'muaqan gis tla'tegetew st'ge' ta'n tel'te'tg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Te'sijig mimajuinu'g pegisitua'tiji mijua'ji'jg Se'suseg ugjit gegupa'tun ugpitnn un'jiwa aq a'sutmessewan. Gatu Se'sus unaqapemg majiaqa'la'tiji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Se'sus teluet, “Ignmug mijua'ji'jg jugwita'new ni'neg. Mut wetqo'lanew, muta Gjinisgam ilgwenaji mimajuinu' ta'n getlams'tasultiliji st'ge' wegla mijua'ji'jg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Se'sus iga'toqol ugpitnn un'jiwaq aq a'sutmessewaji. Na tujiw naqt'g na'te'l aq siawa'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Newtejgeg na'gweg na milesit ji'nm eliet Se'suseg aq pipanimatl, “Nujigina'muet, goqwei gelu'lg gis tla'tega's ugjit msnmn iapjiwewei mimajuaqan?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Se'sus telimatl, “Goqwei weji pipanimin ugjit ta'n goqwei gelu'lg? Pas'g Gjinisgam na mawi glu'sit. Majulgwate'n Nisgamewe'l tplutaqann aq guguntes iapjiwewei mimajuaqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Milesit ji'nm pipanimatl, “Tegenn tplutaqann amujpa majulgwattes?” Se'sus telimatl, “Mut ne'pa'tegew, mut sespo'tegew, mut gmutnew aq mut pisui agniman igtigig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gepmite'lm gujj aq ggij, aq tli gsal igtigig st'ge' ta'n teli gsalsin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ula ji'nm na me' maljewe'juit. Telimatl Se'susal, “Weja'tegemgeg maljewe'juianeg na majulgwatman ta'n te's'gl tplutaqann. Ap goqwei eteg ta'n tla'tega's?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Se'sus telimatl, “Pa na ma'muni glu'sin, maja'sites aq ntuisgetutes ta'n te's'g goqwei geggunmn aq gsulieweim ignmuates ewle'jultijig. Na guguntes milesuaqan wa'so'q. Na tujiw jugu'etes aq majulgwalites.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ta'n tujiw ji'nm nutg ula, ejigla'sit. Ewlgwijing muta me' pugwelgl milesuaqann geggungl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Se'sus telimaji unaqapemg, “Telimuloq mtue'tew ugjit milesuinu pisgwa'n ta'n Gjinisgaml ilgwenji mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ap telimuloq, me' metue'g ugjit milesuinu pisgwa'n ta'n Gjinisgaml ilgwentl je mu ta'n melgawlejit tel saputa'siss apje'jg sapalqe'g saqati'gtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ta'n tujiw unaqapemg ula nutmi'tij, sigti paqalaiultijig aq pipanima'titl, “Gatu wen gisi ugs'tawiaten?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Se'sus angamaji aq telimaji, “Ula na ma' gis tla'taqati'gw mimajuinu'g, gatu Gjinisgam ms't goqwei gis tla'teget.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Na Pie'l telimatl, “Gjisaqamaw, ms't goqweieg gis naqtmeg'pneg aq nige' majulgwaluleg. Goqwei msntesnen?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Se'sus telimaji unaqapemg, “Teliaq na telimuloq, ni'n na mimajuinualsiap. Ta'n tujiw pmgopia's elege'witewei nt'pun na ni'neg gigto'qi pmgopultitoqs'p newtisga'qal je ta'pu elege'witewe'l mutputi'l. Na'te'l assumtoqs'p newtisgegsijig je ta'pu piltu nemigsijig mimajuinu'g tleiawultijig Lesui'pe'gatig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta'n te'sit wen naqt'g'pnn wiguowal aq ugtiga'taqanmual ugjit majulgwalin ni'n guguntew me' pugwelgl jel mu ta'n goqwei naqt'g'p. Ta'n te'sit wen naqalapni wijig'tiliji, un'jang aq ungi'gu ugjit majulgwalin ni'n, na me' gugunata pugwelgig jel mu ta'n naqalapni. Ta'n Gjinisgam ilgwenaji mimajuinu' ignmuaten iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ugs'tqamug na pugwelgig ta'n nige' niganpugultijig gatu ta'n Gjinisgam ilgwenaji mimajuinu' na ugtejgewa'jultitaq. Na pugwelgig ta'n nige' na ugtejgewa'jultijig gatu ta'n Gjinisgam ilgwenaji mimajuinu' na amgwesewa'ju'ltitaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ta'n Gjinisgam ilgwenaji mimajuinu' pa na wijei aq na ji'nm assutg mesgi'g iga'taqan ta'n nigwejig aloqomanaqsi'g. Gisapniaq maja'sit aq naji agase'walaji ta'siliji ji'nmu ugjit lugowilita iga'taqanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta'n tujiw agase'walaji lugowinu' na wel'te'tg apangituan te'silitl lugowinu'l newta'ig ugjit te's newte' na'gweg. Na tujiw elgimaji naji lugutinew ugtiga'taqang. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ta'n tujiw pesgunateg ajiej assusit ap eliet utang aq nemiaji ta'siliji ji'nmu alpugultiliji gujmug magasan. Mo tal lugutili'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Na telimaji, ‘Getu lugutioq ntiga'taqang. Apangitultoqs'p ta'n goqwei telteg.’ Ta'sijig wel'te'tmi'tij aq nat lugutijig iga'taqanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na assusit ap eliet utang ta'n tujiw mewlia'gwej aq agase'walaji igtigi lugowinu'. Ta'n tujiw si'st ajiej na wijei tela'teget. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Suel na'n ajiej ap eliet utang aq ap nemiaji igtigi ji'nmu alpugultiliji. Pipanimaji, ‘Mo goqwei tel lugutiwoq gisgug aq nige' geget na'gweg gaqiaq. Tal gi's mo elugutiwoq gisgug?’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Teluejig, ‘Mo wen aqase'walugsiweg.’ Na assusit telimaji, ‘Na to'q wije'wigw aq lugowigw.’ Ta'sijig wel'te'tmi'tij aq nat lugutijig iga'taqanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ta'n tujiw gis asugom ajiet aq je me', assusit telimatl na nigani lugowinu'l, ‘Wigum lugowinu'g aq apangitu. Tmg apangitu ta'n ugtejg weji agase'wal'g'pnig aq ugtejg apangitu ta'n amgwesewei agase'wal'g'pnig.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Te'sit ji'nm ta'n poqt lugwep na'n ajieteg apangitut newta'ig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na ji'nmug ta'nig gesi egsitpu'g poqji lugutipnig tel'ta'sultijig me' gaqi apangitujig je mu esgwieliji. Gatu te'sit elg apangitut newta'ig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na suliewei wesua'tu'tij gatu pilsima'titl assusilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Na lugowinu telimatl assusilitl, ‘Alt ji'nmug pas'g elugutipnig gijga'ji'jg gatu elugutieg'p newtigisg'g. Wesgowita'ieg me'si p'teg na'gu'setewigtug. Gi'l wijei teli apangitajig ta'nig ugtejgewei poqji lugutipnig st'ge' ninen.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Na assusit telimatl, ‘Nitap, mu opla'lulun muta wel'te'tmu't'p apangitulin newta'ig ugjit lugwen newtigisg'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nige' ugsua'tu gsulieweim aq nmiates. Getu' apangitmaq na ji'nm ta'n ugtejg weji agase'wal'g'p wijei st'ge' gi'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Telteg tla'tun ntsulieweim ta'n tel puatm? Etug gi'l wisguen ta'n ni'n teli ulm'tu.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Se'sus telimaji ta'ni eimu'tiliji na'te'l, “Ta'n wen ugtejg eig na niganpuguitew, aq ta'n wen niganpuguit na ugtejg i'ttew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ge's Se'sus aq unaqapemg el'ta'jig Selusalemg, gmetug ela'laji pas'g unaqapemg aq gelulaji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Telimaji, “Jigs'tuigw. Ni'n na mimajuinualsiap. Nige' el'ta'igw Selusalemg, Na'te'l niganpugultijig patlia'sg aq nujigina'mua'tijig Mowisewei tplutaqan la'litaq aq ilsumitaq npmn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na tujiw ignmuitaq ta'nig mu Lesui'peulti'gw ugsua'linew. Wegla mimajuinu'g maligmitaq, nipispaqante'itaq aq gujjiewte'itaq. Utqotalitaq gatu na nesuguna'q iga'qt'tew minunsia's.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na e'pit ela'laji uggwisg Se'suseg. Ula e'pit na Sepeti ugte'piteml. Nutgul'pa'sit aq pipanimatl Se'susal ugjit ul'te'lman. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Se'sus pipanimatl, “Goqwei pewatmn?” Telimtl, “Teplumi't'p na ngwis pmgopitew gtinaqanmg aq igtig pmgopitew gpatatujmg ta'n tujiw elege'witewin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Se'sus telimaji e'pit uggwisg, “Mo geituoq ta'n goqwei pipanigesioq. Getu' ulmajeioqos st'ge' ulmajeia's.” Telima'titl Se'susal, “E'e gis tla'tegetesnen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Se'sus telimaji, “E'e, na ulmaje'toqs'p gatu mo telgita'siw ta'n wen pmgopitew ntinaqanmg gisna ntpatatujmg. Na nujj ta'n eig wa'so'q gis gisgaja'toqopnn negla ugt'punual aq ignmuata ta'ni mgnmanew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ta'n tujiw newtisgegsiliji unaqapemg nutma'titeg, na wegaiugtua'tiji na tapusiliji ji'nmu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Na glaman Se'sus wigumaji ms't unaqapemg aq telimaji, “Geituoq na niganpugultijig ta'n mu Lesui'peulti'gw na assuma'tiji ugmimajuinu'. Na espo'ltijig niganpugultijig ilsuma'tiji aq telima'tiji esgwia'tiliji ta'n goqwei tla'taqatinew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Gatu ma' tla'taqatiwoq st'ge' wegla niganpugultijig. Pa na ta'n getu wen te'sioq gtu' gugung ml'gigno'ti, amujpa na elugowaji esgwia'tiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pa na ta'n getu wen te'sioq gtu' niganpuguij, amujpa na gistejuit ms't ta'n te'siliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Amujpa tla'tegetew pa na wijei aq tela'tegei. Ni'n na mimajuinualsiap gatu mu weji pgisinap ugjit lugowugsin, awna weji pgisinap lugowan igtigig aq ne'po'qsin ugjit ugs'tawian pugwelgig mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Se'sus aq unaqapemg pemi nqatmi'tij Jeligo pugwelgig mimajuinu'g majulgwala'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na tapusijig ji'nmug ta'n nepapigwa'jig pemgopijig gmetug awtigtug. Telimujig Se'susal pemielitl aq na glaman poqji sesgwejig, “Saqamaw, geitueg na wetapegsin Ta'piteg. Ewlite'lminen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Na mimajuinu'g telima'tiji puntoqsigw. Gatu na tapusijig me' aji sespe'gig, “Gjisaqamaw, geitueg wetapegsin Ta'piteg. Ewlite'lminen!” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Se'sus naqa'sit aq pipanimaji, “Goqwei pewalioq tla'tegen ugjit gilew?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Teluejig, “Gjisaqamaw, gsatmugeg welapieg's.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Se'sus ewlite'lmaji aq sama'tuaji ugpugugual. Smtug wel nmitegejig, aq majulgwala'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Pemita'tij gigjiw Selusalemg, peita'jig na utanji'j teluisig Petpage', ta'n eteg na gm'tn teluisit Olipet. Se'sus wigumaji tapusiliji unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Telimaji, “La'tigw utanji'j nigantug aq smtug nmiatoqs'p te'sipow gelpisit na'te'l aq maw un'jann. Apgwa'lug aq jugwa'lug ni'neg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pa na nat wen pipanimugsioq nat goqwei, tlimatoqs'p, ‘Gjisaqamaw pewalaji.’ Na smtug iga'lata wegla te'sipowa.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ta'n goqwei niganigjitegewinuaq teluepnaq na giasgiw tliatew. Na st'ge' gis ewi'gas'g, ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Naji tlimug mimajuinu'g tleiawultijig Selusalemg, ‘Nige' gtelege'witemuow wejgu'et, Welm'toq aq wejgwi'puluet. Pemi'puluet te'sipowji'j un'jann.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na unaqapemg nigana'tijig aq tela'tegejig ta'n Se'susal gis telimji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jugwa'la'tiji na te'sipowl aq un'jann Se'suseg. Ugpitu'gunmua elegetua'tiji ugpaqamuaq aq Se'sus tepa'sit te'sipowji'j un'jann. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na pugwelgig mimajuinu'g niganita'jig awtigtug aq siplamgo'la'tiji ugpitu'gunmua awtigtug. Igtigig temsmi'titl nipispaqann aq eloqotu'titl awtigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na te'sijig mimajuinu'g niganita'jig aq te'sijig majulgwala'titl ta'n Se'sus eli'puluet. Poqji sesgu'tijig, “Emtoqwalanej Ta'pito'q uggwisl. Gemite'lmanej muta Gisiteget pajiji gepmite'lmatl. Pipanimg'tjig ms't wen wa'so'q emtoqwalan.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Se'sus pisgwa'j Selusalemg, pugwelgig mimajuinu'g ta'n eimu'tijig ma'muni sespenma'tijig. Ta'sijig pipanigesultijig, “Wen ta net?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Alt mimajuinu'g ta'n majulgwala'titl Se'susal teluejig, “Ula na niganigjitegewinu Se'sus. Tleiawit na gjigan Nasaletg, ta'n eteg Galaliewa'gi.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Se'sus pisgwa't gjia'sutuo'guomg aq tewaqtesguaji ta'n te'siliji etli pgwateligatiliji aq etli ntuisga'tiliji. Aputasgejio'toqol na patawuti'l ta'n mimajuinu'g sa'se'wa'taqatiliji suliewei aq na mutputi'l ta'n mimajuinu'g pemgopultijig aq netuisgela'tiji plesg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Telimaji wegla mimajuinu', “Ewi'gas'g Gjinisgam ugtwi'gatignigtug ta'n goqwei Gjinisgam teluep, ‘Nignen tluisitew gjia'sutuo'guom, gatu e'wmuoq ugjit gmutnesg wiguow.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na nepapigwo'ltijig aq asgajo'ltijig el'ta'jig Se'suseg ge's eimlitl gjia'sutuo'guom aq nepilujig ms't. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Na niganpugultijig patlia'sg aq nujigina'mua'tijig Mowisewei tplutaqan wegaiultijig ta'n tujiw nemitu'tij gelu'lgl paqalaiwaqann. Ap wegaiultijig ta'n tujiw nutma'tiji ta'n goqwei mijua'ji'jg al sesgu'tiliji gjia'sutuo'guomg muta mijua'ji'jg teluejig, “Emtoqwalanej Ta'pito'q uggwisl!” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Na glapis Se'susal telimgwi'titl, “Mo nutuawjig ta'n mijua'ji'jg teluejig?” Se'sus telimaji, “E'e, nutaqig. Geitu gilew gis gitmuoqop Gjinisgam ugtwi'gatign ta'n ewi'gas'g, ‘Gis gina'muoqig mijua'ji'jg aq gopisung ugjit tetapu emtoqwalanew Nisgaml.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Na Se'sus naqalaji wegla mimajuinu' aq ejigla'sit na gjigan. Eliet Pettani aq getgunit na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na gisi egsitpu'geg ge's Se'sus apaja'sij gjigang na gewising. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nemiatl miti'sl ta'n teluisilitl pi'gmenaqsi. Eliet na miti'seg gatu mo goqwei lastenug, pas'g eta nipi'g. Na tujiw teluet, “Ma nugu nigwenug ula miti's.” Smtug na miti's gaqi gispasit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Se'sus unaqapemg nemitu'tij ma'muni paqalaiultijig. Pipanima'titl, “Tal gi's tel jaqal gispasit ula miti's?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Se'sus telimaji, “Migwite'tmug ula. Pa na uli gtlams'tasultioq aq mu megtmuoq, gilew elg wijei gis tla'latoqs'p. Pa na gtlams'tasultioq na gisa'latoqs'p st'ge' ni'n aq na gisa'latoqs'p gm'tn maja'sitew aq gtapa'sitew gta'nug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pa na gtlams'tasultioq, msntoqs'p ta'n getu goqwei pipanigesultioq ta'n tujiw a'sutma'tioq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Se'sus apaja'sit Gjia'sutuo'guomg. Ge's etl gina'muet, niganpugultijig patlia'sg aq igtigig mawagnutmewinu'g peita'jig aq pipanima'titl, “Tal gis tla'tegen weget? Wen ignmasg assusuti ugjit tla'tegen wegla ta'n goqwe'l?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Se'sus telimaji, “Elg pipanimuloq nat goqwei, aq ta'n gisi tlimioq ta'n goqwei pipanimultes, na tujiw tlimultoqs'p ta'n weja'tas'g na ntassusutim. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wen ignmuapnn Sa'n Nutsign'tuet assusuti ugjit sign'tuan mimajuinu', Na Gjinisgam gisna mimajuinu'g?” Na poqji sespagnutma'tijig. Nat wen teluet, “Taluetesnu? Pa na tlueigw, ‘Gjinisgam petgimapnn,’ na tujiw pipanimugsitesnu, ‘Goqwei ugjit mo getlams'tuawoqop Sa'n?’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Gatu igtig teluet, “Pa na tlueigw, ‘Mimajuinu'g ignmua'tipnn ml'gigno'ti,’ na jipasultitesnu ta'n mimajuinu'g tla'taqatitaq muta tel'te'lma'titl Sa'nal na niganigjitegewinu.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Awna Se'susal telima'titl, “Mo geitueg.” Na Se'sus telimaji, “Elg ni'n ma' tlimuluoq ta'n weja'tu ntml'gigno'tim ugjit gis tla'tegen wegla ta'n goqwe'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Tal'te'tmoq? Na ji'nm geggunaji ta'pusiliji uggwisg. Telimatl uggwisl ta'n maw gisiguitl, ‘Gwi's, pewalul lien aq tl lugwen ntiga'taqang gisgug.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na ji'nmji'j telimatl ujjl, ‘Mo getu' liew,’ gatu tel'gne'ge'l sa'se'wita'sit aq eliet naji lugwet iga'taqanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Na ji'nm eliet igtigl uggwisl aq wijei pipanimatl. Uggwisl telimtl, ‘E'e lia's,’ gatu mo eliegup. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na tegen tela'tegess ta'n ujjl pipanimj?” Na niganpugultijig patlia'sg teluejig, “Maw gisiguit tela'teget ta'n ujjl telimj.” Se'sus telimaji, “Telimuloq, ta'nig nujintutma'tijig suliewei aq e'pijig ta'n netuisgalsultijig ignmua'tital Gjinisgam ilgwenan gesgmnaq gilew ignmuawoq Gjinisgam ilgwenugsinew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sa'n Nutsign'tuet gis pegising'p ugjit musga'tugsinew na gelu'lg awti ta'n pmita'toqs'p. Mo getlams'tmuoq ta'n goqwei gis tlimugsioqop, gatu na nujintutma'tijig suliewei aq e'pijig ta'n netuisgalsultijig getlams'tua'tipnn. Ta'n gisi gji'tuoq ula mu gawasgita'sultiwoq, mu ejiglita'woq lue'utigtug aq mu getlams'tmuoq ta'n goqwei Sa'no'q telimugsioqop?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Jigs'tuigw aq tlimultoqs'p igtig gina'masutiewei a'tugwaqan. Newtejgeg na'gweg na ji'nm assutg maqamigew. Na iga'taqaliji aloqomanaqsi'g. Llutaqana'toq na maqamigew aq mulqatg elmalqei ugjit ta'n tl pepgijo'tutal aloqomann. Na el'toq na espapiteg wen'ji'guom ta'n tl al gigto'qwapitew. Na tujiw emqatuaji ta'siliji nuji iga'taqu'tiliji ugjit ugapangitueweim. Toqo tujiw eliet na'tami se'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ta'n tujiw aloqomann gaqigwegl, na ji'nmug ta'n e'wmi'titl aloqomanaqsi'l mawo'tu'titl. Toqo tujiw assusit elgimaji uglugowinumg na'te'l ugjit gugunmnew ugsulieweim. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ta'n tujiw assusit uglugowinumg peita'jig na'te'l, na ji'nmug ta'n e'wmi'titl aloqomanaqsi'l goqqwa'la'tiji. Newte'jilitl matta'titl, igtigl ne'pa'titl aq igtigl gun'tewta'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Na assusit ap elgimaji igtigi lugowinu', me' pugwenniji aq amgweseweieg. Na ji'nmug ta'n ango'tmi'titl aloqomanaqsi'l wijei tele'wa'tiji negla lugowinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Na tujiw assusit elgimatl uggwisl na'te'l. Teluet, ‘Negla ji'nmug ta'n e'wmi'tij aloqomane'gati gepmite'lma'tital ngwisl.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Gatu ta'n tujiw nemitua'titl uggwisl na teluejig, ‘Ula na assusit uggwisl. Ge' ne'pa'nej aq na tujiw ula iga'taqan ginuewe'tew.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Na goqqwa'la'titl, tewege'titl gujmug iga'taqanigtug aq ne'pa'titl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Na tujiw Se'sus pipanimaji na mimajuinu' ta'n jigs'tugwi'titl, “Ta'n tujiw na assusit apaja'sit wiguaq, tala'lata negla ji'nmug ta'n e'wmi'tlij aloqomane'gati?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Alt telima'titl, “Amujpa mu ewlite'lmagwi negla ne'pa'tegewinu'g aq ne'pa'ta. Na tujiw pipanimata igtigi e'wmi'tinew ugmaqamigem. Negla mimajuinu'g ul'te'tmi'titaq ignmuan assusilitl aloqomann gisna suliewei ta'n tujiw gaqigwegl aloqomann.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Se'sus telimaji, “Gis gitmoq Gisiteget ugtwi'gatign ta'n tel wi'gas'g, ‘Na gun'tew ta'n nujitaqatijig mo pewatmi'tip na me' gepme'tas'g je mu esgwiaqal gun'tal aq mawn'g ms't goqwei wen'ji'guomigtug. Ula Gjinisgam gisite'tg aq tela'teget. Me' gatu ula we'gwi ula's'g.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Telimuloq, Gjinisgam ma' ignmugsiwoq pisgwita'new ta'n ilgwenaji mimajuinu'. Na ignmuata igtigi mimajuinu'. Wegla mimajuinu'g teta'pua'taqatijig ms't goqwei ugjit Gjinisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ta'n getu wen nisietew ula gun'tewigtug, paqsipge'tesintew aq ta'n tujiw na ula gun'tew gegujaq nat wen, na paqsipge'toqwetew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na niganpugultijig patlia'sg aq Palasiaq nutua'tij a'tugwaqan ta'n Se'susal gi's teluelitl, mo welgwijulti'gw muta geitu'tij Se'susal wesgumgwi'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Na getu' ugsua'la'titl, gatu mu tela'taqati'gw muta jipala'tiji mimajuinu' ta'n majulgwala'titl. Wegla mimajuinu'g tel'te'lma'titl Se'susal na niganigjitegewinu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Se'sus ap telimaji mimajuinu' a'tugwaqan ugjit gina'muanew nat goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Teluet, “Ta'n Gjinisgam ilgwenaji mimajuinu' na pa wijei aq elege'wit ta'n gisgaja'toq mesgi'g pestie'waqan ta'n tujiw uggwisl getu' malie'wiliteg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Elgimaji uglugowinumg ugjit jugwita'new pestie'waqan negla mimajuinu' ta'n pewalaji eimu'tinew na pestie'waqan. Gatu mo wen getu' liegw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Na tujiw elgimaji igtigi lugowinu' aq telimaji lta'new aq tlimanew wegla mimajuinu'g ta'n gis wigumgig, ‘Jugwita'gw, ms't goqwei gisgatteg. Gi's ne'po'jig wen'jitia'mug aq mawi glu'sijig wen'jitia'm'ji'jg. Ms't goqwei gisgatteg. Jugwita'gw muta ngwis getu' malie'wit.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Gatu na ta'n wigumujig mo jigs'tmi'ti'gw. Pas'g siaw tel lugutijig. Newte'jit ugtiga'taqan eliet aq igtig magasan naji pana'toq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Me' igtigig goqqwa'la'tij na elege'wit uglugowinumg. Emegwei'wa'tiji aq ne'pa'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na elege'wit wegaig, aq elgimaji ugsma'gnismg ugjit ne'pa'new negla ne'pa'tegewinu' aq elg nu'gwa'tu'tij gjigan ta'n ne'pa'tegewinu'g wigultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Na tujiw elege'wit wigumaji igtigi uglugowinumg aq telimaji, ‘Malie'wimgewei pestie'waqan gisgatteg. Gatu wegla mimajuinu'g ta'nig wigumg'pnig mo tepawtulti'gw ugjit jugwita'new pestie'waqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nige' lta'gw utane'l awti'l aq wigumug ta'n te'sit wen nemioq!’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Na glaman lugowinu'g el'ta'jig utane'l awti'l aq wiguma'tiji pugwenniji mimajuinu. Ela'la'tiji pestie'waqan gitg gelu'sultiliji aq ta'ni mu gelu'sultligwi. Na wejgwa'la'tiji pugwenniji ta'n wesgowa's'g pestie'waqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Na elege'wit pisgwa't aq alapit. Nemiatl ji'nmul ta'n mo tetapu gnesiligul. Ula ji'nm mo nasguagul na aligal ta'n te'sit wen ignmut ugjit na malie'waqan pestie'umg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Elege'wit pipanimatl, ‘Nitap, tal gi's mo nasgmun na aligal ta'n pewalul nasgmn?’ Na ji'nm mo goqwei teluegw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Na tujiw elege'wit telimaji uglugowinumg, ‘Ugsua'lug ula ji'nm aq gl'pilu uggwat aq ugpitn. Tua'l gujmug ta'n oqonitpa'q. Na'te'l atgitemitew aq wipitl seggapitasitew muta ulmaje'tew.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Gjinisgam wigumaji pugwenniji mimajuinu' gatu megnaji tegle'ji'jg ugjit pisgwita'new mesgi'g pestie'waqan wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na tujiw Palasiaq naqala'titl Se'susal aq mawita'jig na'tami se'g. Agnutma'tijig ta'n tl gistesguanew Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Na glaman elgimaji unaqapemua aq Elot unaqapemg Se'suseg. Wegla ji'nmug telima'titl Se'susal, “Nujigina'muet, geju'leg apjiw teluen ta'n goqwei teliaqewei. Tetapu gina'muen ta'n Gjinisgam tel pualaji gji'tunew mimajuinu'. Mo sespete'tmun ta'n goqwei mimajuinu'g tluetaq. Gepmite'lm't ta'n wen ewle'jit st'ge' gepmite'lm't ta'n wen milesit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gatu tal'te'tmn, tliminen, tetapua'taqatieg apangitmnen Lo'mewei elege'wit na suliewei ta'n pipanimatl apangituan te's mimajuinu'l tleiawilitl Lo'mewa'gig gisna moqwa'?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Gatu Se'sus gejiaji ugjigistesguanew aq telimaji, “Wesgijiangamgusultioq, pas'g getuapsgnioq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ge' musga'tuigw na suliewei ta'n mimajuinu'g apangitmuanew Lo'mewei elege'wilitl.” Smtug na newte' pegisitua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pipanimaji, “Wen ugsisgw aq ugwisunm ewi'gas'gl na sulieweigtug?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Telima'titl, “Na Lo'mewei elege'wit.” Na glaman Se'sus telimaji, “Na to'q, apangitug na g'pnno'lewa'jg ta'n goqwei g'pnno'lewa'jg ignmugsioq e'wmnew aq ignmug Gjinisgam ta'n goqwei ignmugsioq e'wmnew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ta'n tujiw nutmi'tij ta'n goqwei Se'sus gi's teluet, paqalaiultijig aq naqala'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na wijei na'gweg ta'sijig Satusiaq peita'jig Se'suseg. Getlams'tmi'tij na ma' nugu minunsulti'gw mimajuinugi'g ta'n npu'ti'tij. Telima'titl, ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Nujigina'muet, Mowiso'q teluep, ‘Pa na ji'nm nepg's ta'n tujiw mo un'janigw, ugjignaml amujpa malie'witaq sigu'sgwal glaman gisi gugunata mijua'ji'jg ugjit na nepg'pnaq ji'nmaq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Jijuaqato'q na lluigneg te'sijig wijig'tultijig ji'nmug. Mujga gisiguitaq malie'wipnaq gatu nepg'pnaq aq mo geggunagupni mijua'ji'jg. Na glaman ta'puewa'j malie'wi'tipna sigu'sgwa. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na wijei ap teliaq ugjit na ta'puewa'j, aq nepg'pnaq. Si'stewa'j wijei tla'tegepnaq glapis ms't lluigneg te'si'tipni wijei gis tla'taqatipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na toqo ugtejgeweieg na e'pitaq nepg'pnaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nige' tlimigw, ta'n tujiw Gjinisgam minua'laj npuinu', wen ugte'pitemital na e'pilitl? Na lluigneg te'sipnaq gis malie'ulti'tipnn na wije'l e'pilipna.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Se'sus telimaji, “Me' gatu oplite'tmoq. Mo geituoq Gjinisgam ugtwi'gatign aq mo geituoq ta'n Gjinisgam telignaj. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ta'n tujiw na npuinu'g minunsultitaq, ma' nugu malie'ulti'gw. Na tlo'ltitaq st'ge' ansale'wiliji wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Awan'ta'sultioq ta'n goqwei Gjinisgam teluet ta'n tujiw wesgutg'p na minunsimg. Ula ewi'gas'g, ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ni'n na Gjinisgam ta'n Aplam me' emtoqwalit. Elg Isaq me' emtoqwalit aq elg Je'gop me' emtoqwalit.’ “Mimajuinu'g ta'n me' mimajultijig emtoqwala'titl Gjinisgaml, mu na npuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ta'n tujiw mimajuinu'g nutmi'tij, paqalaiultijig ta'n Se'sus tel gina'muelij. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ta'n tujiw Palasiaq nutma'tij ta'n Se'sus gis magnimapni na Satusiaq, na Palasiaq mawita'jig Se'suseg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Newte'jit na nutagnutmewinu aq getu' weje'watl Se'susal. Wejo'tg gistesguan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Pipanimatl, “Nujigina'muet, tegen mawi gepme'g tplutaqan?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Se'sus telimatl, “Amujpa pajiji gsal Gisiteget na Gjinisgam ta'n emtoqwalt. Amujpa me' gesalt Gjinisgam je mu ta'n teli gsalj mimajuinu'g. Ta'n tujiw tela'tegen ta'n pas'g goqwei amujpa e'we'n ms't gml'gigno'tim musga'tun me' gesalt je mu mimajuinu'g. Ta'n tujiw angite'tmn ta'n pas'g goqwei amujpa me' gepmite'lm't je mu gepmite'lmawjig mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ula na mawi espe'g aq mawi gepme'g tplutaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na ta'puewei ta'n mawi gepme'g na, amuj igtigig mimajuinu'g teli gsalt st'ge' ta'n gi'l teli gsalsin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ms't tplutaqann ta'n Mowiso'q aq niganigjitegewinugi'g gis ewi'gmi'tipnn telueg wijei st'ge' wegla tapu'gl tplutaqann.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ge's na Palasiaq me' eimu'tijig Se'suseg na pipanimaji, ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Tal'ta'sioq ugjit na negm ta'n tel wi'tut Nujiugs'tawi'wet? Tami wetapegsit negm?” Telimgwi'titl, “Ta'piteg wetapegsit.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Se'sus pipanimaji, “Tal gis na Wejuli Nisgam gisa'lapnn Ta'pital tel wi'tapnn Wa'so'qewei Gjisaqamaw muta Ta'pito'q teluep, ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Gisiteget telimatl na Wa'so'qewe'l Gjisaqamawl ta'n emtogwalgl, “Pa'si tet ntinaqanmg glapis wissuignemaqig ta'nig getan'sgig aq gisa'l'gig gepmite'lmulinew?” ’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Pa na Ta'pito'q tl wi'taj ‘Wa'so'qewei Gjisaqamaw,’ tal gis Gjisaqamaw ugtapegsitew Ta'piteg?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lpa mo wen gisi talimagul Se'susal ta'n goqwei gis pipanigesilitl. Na weja'tegemgeg tujiw mo wen nugu tewjita'qw pipaniman ugjit nat goqwei. Ms't wen jipaqa'sit ugjit pipaniman Se'susal agnutgl nat goqwe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Na tujiw Se'sus gelulaji mimajuinu' aq unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Teluet, “Na nujigina'mua'tijig Mowisewei tplutaqan aq Palasiaq nessutmalsewugsi'gw ta'n telueg Mowisewe'l tplutaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Na amuj mu elistmuoq ta'n telimugsioq gatu mut tla'taqatigw st'ge' ta'n tela'taqati'tij muta ta'n goqwei pestunmi'tij na mo majulgwatmi'ti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pipanima'tiji igtig mimajuinu' tla'taqatinew ta'n goqwe'l metue'gl gatu mo nugu apoqonma'tigwi. Negmow pa na wijei aq na ji'nm ta'n tepo'toqol gesguggl goqwe'l igtigl ugpaqamg gatu ma' nugu apoqonmagul pma'latmn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ms't goqwei tela'taqati'tij na pewala'tiji mimajuinu' angamanew aq gesite'lmanew. Ewi'gmi'tij Nisgamewei tplutaqan m'gegnigtug aq nasgmi'tij na m'gegne'l ugtugwejanual aq ugpitnual. Nat goqwe'l milamu'gl aq weli angamgugl nisaqiaqal uggotmua. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Gesatmi'tij pemgopulti'tij ta'n mimajuinu' gepmite'lmugwi'tiji pestie'umg. A'sutuo'guomg gesatmi'tij pemgopulti'tij nigantug muta pewatmi'tij ms't wen nmianew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Gesatmi'tij gepmite'lmuj magasang aq awtigtug. Pewatmi'tij tl wi'tugsinew, ‘Nujigina'muet.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Gilew pa na wijei aq mimajuinu'g ta'n wijig'tultijig. Mut ignmanew igtigig tl wi'tugsinew nujigina'mua'tijig muta pas'g newte'jit ta'n petgimut gina'mugsinew ms't goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mut tl wi'tanew niganpuguit, ‘Nujjinen’ muta pas'g newte'jit ta'n gujjinu wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mut ignmanew igtigig tl wi'tugsinew assusultijig muta ni'n na Nujiugs'tawi'wet petgimimg ugjit niganpuguin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ta'n getu wen mawi espe'g te'sioq na amujpa elugowaji ms't igtigi. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ta'n getu wen getu' espite'lsit na Gjinisgam mu gepmite'lmagul. Ta'n getu wen mu espite'lsigw na Gjinisgam gepmite'lmatal.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Tetuji mtue'tew ugjit gilew ta'n gegina'mua'tioq Mowisewei tplutaqan aq gilew ta'n teluisultioq Palasiaq muta wesgijiangamgusultioq. Mu getlams'tmuoq na agnutmaqan ta'n Gjinisgam ilgwenaji mimajuinu' aq mu ignmuoq igtigi gtlams'tmnew aq majulgwalanew Gjinisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Tetuji mtue'tew ugjit gilew ta'n gegina'mua'tioq Mowisewei tplutaqan aq gilew ta'n teluisultioq Palasiaq muta wesgijiangamgusultioq. Sigu'sgwaq weli gluloqig gatu gemutmoq ugtaligamual. Gesatmu'tioq ugjit mimajuinu'g ul'te'lmugsinew ta'n tujiw pegiji a'sutma'tioq. Me' Gjinisgam ma'muniw ugtapulugsitoqs'p je mu igtigig mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Tetuji mtue'tew ugjit gilew ta'n gegina'mua'tioq Mowisewei tplutaqan aq gilew ta'n teluisultioq Palasiaq muta wesgijiangamgusultioq. Gaqi peggwita'ioq gta'nug aq pugwelgl maqamigal ugjit gisa'loq newte'jit mimajuinu majulgwalinew. Ta'n tujiw majulgwalugsioq, gisa'loq pilui awti lien. Me' wele'g'p ge's mu weltesgugsiwoq. Gisa'loq ma'muniw ugtapulan Mn'tua'gig je mu gilew ta'n tli gtapu'titoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Tetuji mtue'tew ugjit gilew ta'n getu' nigani ilgwenoq igtigig muta pa na wijei aq nepapigwo'ltijig. Ula tel gina'mua'tioq, ‘Pa na ta'n getu wen elui'tmasit gjia'sutuo'guom ta'n tujiw teplutgl tla'tegen nat goqwei ugjit Nisgam, na mu amujpa tela'tegegw. Gatu ta'n getu wen elui'tmasit suliewei ta'n eteg na gjia'sutuo'guom ta'n tujiw teplumatl Nisgaml tla'tegen nat goqwei na amujpa tela'teget ta'n goqwei teplutg.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Telimuloq, gilew pa na wijei aq nepapigwo'ltijig mimajuinu'g aq mo nestmu'tioq ta'n goqwei Gjinisgam tel puatg. Gjia'sutuo'guom me' gepme'g je mu na suliewei ta'n eteg na a'sutuo'guomg. Na suliewei gepme'g muta gis ignmatas'g'p gjia'sutuo'guomg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Elg gegina'mua'tioq, ‘Ta'n getu wen elui'tmasit patgulmesigaqan ta'n tujiw teplutg nat goqwei, mu na amujpa tela'tegegw ta'n goqwei teplutg. Gatu ta'n getu wen elui'tmasit nat goqwei ignmuatl Nisgaml na amujpa tela'teget ta'n goqwei teplumatl Nisgaml.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Me' gatu gilew pa na wijei aq nepapigwo'tijig. Mo nestmutiwoq ta'n goqwei Gjinisgam tel puatg. Na patgulmesigaqan me' gepme'g je mu na ignmatimgewei ta'n eteg na'te'l. Na ignmatimgewei gepme'g muta gis eteg na patgulmesigaqanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na glaman, ta'n getu wen elui'tmasit na patgulmesigaqan, na elui'tmasit patgulmesigaqan maw ta'n goqwei tepteg na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ta'n getu wen tel wi't'g a'sutuo'guom ta'n tujiw teplumatl Nisgaml nat goqwei na elui'tmasit na gjia'sutuo'guom aq maw Gjinisgam ta'n eig na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ta'n getu wen elui'tmasit Gjinisgam umutgi wa'so'q ta'n tujiw teplumatl Gjinisgaml nat goqwei, na elui'tmasit Gjinisgam ugt'pun aq maw elg Gjinisgam ta'n pemgopit na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Tetuji mtue'tew ugjit gilew ta'n gegina'mua'tioq tplutaqan aq gilew ta'n teluisultioq Palasiaq muta wesgijiangamgusultioq. Gis ignmuoq Gjinisgam weljema'gewe'l ta'n tel wi'tmi'tij, mint, til aq gamn. Te's newtisga'qal weljema'gewe'l ganie'ultioq na newte' ignmuoq Gjinisgam gatu mo tela'taqatiwoq ta'n goqwei gepme'gl tplutaqann teluegl. Mo tetapu tla'taqatiwoq, mo ewlite'lmawoq igtigig aq mo getlams'tmuawoq Gjinisgam. Amujpa tela'taqatioq wegla aq maw ta'n goqwei gis tela'taqatioq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gilew pa na wijei aq nigani ilgwenteget ta'n nepapigwa't. Ta'n tujiw menaqa ignmuoq Gjinisgam weljema'gewe'l na gilew pa na wijei aq ta'n wen mo gesatmug esamqwan p'tewei ta'n tujiw u'j pitjapij. Gatu ta'n tujiw mu majulgwatmoqol gepme'gl tplutaqann na gilew pa na wijei aq na ji'nm ta'n mesa'latl melgwlejilitl aq mo geitug na gis tla'teget. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Tetuji mtue'tew ugjit gilew ta'n gegina'mua'tioq tplutaqan aq gilew ta'n teluisultioq Palasiaq muta wesgijiangamgusultioq. Menaqa waqama'loq gulaqanmuaq aq ggapji'jmuaq aq pijo'tuoq mijipjewei ta'n gi'gaji gisa'loqig igtigig ignmugsinew muta niganite'lsultioq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Gilew ta'n tel wi'tugsioq Palasiaq na pa na wijei aq ta'n wen nepapigwa't. Mo nestmutiwoq ta'n goqwei Gjinisgam tel puatg. Tmg tetapuita'sultigw aq tetapua'lug igtigig aq na tujiw tetapugamigsultitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Tetuji mtue'tew ugjit gilew ta'n gegina'mua'tioq tplutaqan aq gilew ta'n teluisultioq Palasiaq muta wesgijiangamgusultioq. Gilew pa wijei aq npuinue'l gun'tal. Waqame'g aq gesi wape'g gatu ta'n npuinu elising lame'g maqamigew na pas'g waqan'tal aq ta'n goqwei sugul'gaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mimajuinu'g tel'te'lmi'tij apjiw tela'taqatioq ta'n goqwei Gjinisgam tel puatg, gatu ggamlamunuaq wajua'tioq egsuo'qonn aq pata'taqann.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Tetuji mtue'tew ugjit gilew ta'n gegina'mua'tioq tplutaqan aq gilew ta'n teluisultioq Palasiaq muta wesgijiangamgusultioq. Gelu'lgl aq weli angamgugl gun'tal gaqama'toqol ta'n na niganigjitegewinugi'g elisultijig aq wel'gna'tuoqol gun'tal ta'n gelu'sultipnig mimajuinu'g gisi utqutalut'pnig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Telueioq, ‘Pa na mimajultiegs'p na tujiw sa'q, mu wijei tela'taqatigegpnn st'ge' nngi'gunaqi'g ta'n ne'pa'titeg negla niganigjitegewinugi'g.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Gatu telimuloq ilsumsultioq ta'n tujiw neia'tuoq wetapegsultioq na mimajuinugi'g ta'n ne'pa'tipni na niganigjitegewinugi'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na glaman nige' siawa'tuoq ta'n goqwei gn'gi'gunaqi'g tela'taqatipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Gilew pa na wijei aq mtesgmug aq mtesgmug un'janua. Tal gi's tel'ta'sultioq mo te'pmuoq pijo'lugsinew Mn'tua'gig? ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Na glaman telimuloq, Petgitmultoqs'p niganigjitegewinu'g, ne'tata'sultijig mimajuinu'g aq nujigina'mua'tijig tplutaqan. Alt ne'pa'toqs'p aq alt gujjiewta'toqs'p. Igtigig nipispaqaneiaten a'sutuo'guoml aq igtigig tuaqtesguaten na ms't utann. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Gjinisgam ilsumugsitoqs'p gilew aq gn'gi'gugi'g. Msntoqs'p ta'n goqwei te'pmoq muta na gelu'sultipnig mimajuinugi'g ne'po'qopnig. E'pelo'q na amgwesewa'juipnaq ta'n ne'po't'pnaq aq Saglaiao'q na Palatjiaoq uggwisal ugtejgewa'juipnaq ta'n ne'po't'pnaq. Saglaiao'q etl ne'po't'pnaq nigantug a'sutuo'guomg aq ugtejg na patgulmesigaqan ta'n nu'gwa'tas'g wius. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Telimuloq, teliaq na Gjinisgam ilsumugsitoqs'p ms't te'sioq ta'n mimajultioq gisgug aq msntoqs'p ta'n goqwei te'pmoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Gilew ta'n tleiawultioq Selusalemg, me' gatu ewlite'lmuloq muta niganigjitegewinugi'g ne'po'qopnig aq wegla ta'n Gjinisgam petgimapni ula gjigang gun'tewtoqopnig. Gaqaisg getu' mawa'luloq ta'n Gjinisgam ilgwenaji mimajuinu' pa wijei aq goqoli'gwej teli mawo'laj un'jang gatu gilew mo ne'gaw pewaliwoq tla'tegen. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na glaman Gjinisgam naqt'tew gta'sutuo'guomuow aq maja'sitew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Telimuloq, ma' nugu ap nmiwoq glapis tluetoqs'p, ‘Gepmite'lmanej na newte'jit ta'n gis petgimut ugjit tla'tegen ta'n goqwei Gisteget tel puatg.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Se'sus naqt'g na gjia'sutuo'guomg aq unaqapemg gigto'qopugutugwi'titl. Na gelu'lgwi'titl ta'n tel ml'gita's'g na gjia'sutuo'guom. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Se'sus telimaji, “Ge' angaptmug na gun'tal ta'n nasegnas'gl na gjia'sutuo'guom. Telimuloq wejgu'aqal na na'gwegl ta'n ula gjia'sutuo'guom seioqta's'gt'tew. Te's gun'tew ta'n nasegnas'g na'te'l maja'tas'gt'tew. Ms't nitjioqta's'gt'tal.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ge's Se'sus pemgopit gm'tn ta'n teluisit Olipet, unaqapemg peita'liji negmeg. Pas'g negmow eimu'tijig na'te'l glaman unaqapemg pipanimgwi'titl, “Ge' tliminen ta'n tujiw giasgiw ula ms't tliatew. Tliminen ta'n goqwei tliatew ugjit musga'tun gi'l apaja'sin aq ugs'tqamu gespaqami'gt'tew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Se'sus telimaji, “Angweiasultigw aq mut ignmuanew wen lue'wa'lugsinew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pugwelgig mimajuinu'g peita'taq aq tluetaq, ‘Ni'n na Nujiugs'tawi'wet.’ Lue'wa'lata pugwenniji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nutmatoqs'p matntimg tepaw aq nutmatoqs'p igtigl matntimgl na'tami se'g, gatu mut we'gwata'sultinew. Ula amuj tliatew, gatu mo teltenug giaspiaq ugs'tqamu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mimajuinu'g tleiawultijig pilue'l umutgiwal matntultitaq. Ms't tami gaqaisg milapegsultijig mimajuinu'g ma' gtunenatulti'gw aq me' matntiten. Pestmo'qon i't'tew aq maqamigew maja's'gt'tew ms't tami. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ta'n tujiw wegla gis tliatal na tujiw gji'jutoqs'p nat goqwei me' metue'g jugu'atew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Na tujiw laplusang ta'sioq pijo'lugsitoqs'p aq ta'sioq amasgipnnugsitoqs'p aq je we'gaw ta'sioq ne'po'qsitoqs'p. Gaqaisg mimajuinu'g tleiawultijig pilue'l umutgiwal masgelmugsitoqs'p muta majulgwalioq ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pugwelgig ma' ul'te'lmi'gw aq puni gtlams'tasulti'gw. Wegla mimajuinu'g ilsutmuatultitaq aq masgeltultitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Toqo tujiw pugwelgig nujiegsua'tijig niganigjitegewinu'g ne'ita'taq aq pugwelgig elue'wa'laten. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na tl pugwelgt'tal lue'uti'l ugs'tqamug. Lpa me' pugwelgig mimajuinu'g puni gsalata igtigi. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Gatu na mimajuinu ta'n siawi gtlams'tuitew ta'n teli pgitawsij na ugs'tawiaten. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na gelu'lg agnutmaqan ta'n Gjinisgam ilgwenaji mimajuinu' amujpa pestunmas'gt'tew ta'n telgi'g ugs'tqamu, Ta'n tujiw gaqaisg mimajuinu'g tleiawultijig pilue'l umutgiwal gisi gji'tu'tij ula gelu'lg agnutmaqan na tujiw giaspiatew ms't goqwei.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Na niganigjitegewinuaq ta'n teluisipnaq Taniel wesgutg'pnaq nat goqwei ta'n metu angamgug. Na winjig nmitutoqs'p gaqamig gjia'sutuo'guomg.” (Pewaluloq ns'tmu'tinew ula.) ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Ta'n tujiw ula tliatew na mimajuinu'g ta'n eimu'tijig Jutiaewa'gig amujpa lsumultitaq gm'tnigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na tujiw na mimajuinu eig's gujmug wiguaq na mut pisgwa'wij wiguaq nmisgmn nat goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na mimajuinu ta'n eig's iga'taqanigtug ma' apaja'sigw wiguaq ugjit ugpitu'gunml. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ta'n tujiw ula tliatew ma'muniw mtue'tew ugjit e'pijig ta'n getu' un'janultijig aq e'pijig ta'nig apje'ji'jultiliji mijua'ji'jg gegguna'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pipanimug Gjinisgam ma' ugsmultigw miawipug gisna atlasmutigisg'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Na ta'n tliatew me' tetuji mtue'tew je weja'tegemg ugs'tqamu gisita's'geg glapis gisgug. Ap ma' nugu tlianug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Gatu Gjinisgam welm'toq aq pas'g ta's'gl na'gwegl iga'tutal ugjit nat goqwei ma'muniw mtue'g muta teli gsalaji na mimajuinu' ta'n gisi mgnapni. Pa na Gjinisgam iga'toqol pugwelgl na'gwegl ugjit nat goqwei ma'muniw mtue'g, ma' wen ugs'tawugsi'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Pa na wen telim'sg, ‘Ge' lapa'si, ula na tet na Nujiugs'tawi'wet,’ gisna nat wen telim'sg, ‘Gis neia'sit na'te'l,’ mut gtlams'tuaw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pugwelitaq nujiegsua'tijig niganigjitegewinu'g ne'ita'taq aq te'sijig tluetaq, ‘Ni'n na Nujiugs'tawi'wet.’ Tla'taqatitaq gaqaisg milamu'gl paqalaiwaqann muta ne'gaw getu' lue'wa'la'tita na mimajuinu' ta'n Gjinisgam gisi mgnapni. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jigs'tuigw muta ula gis nigani tlimuloq ge's mu tliatew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Pa na alt mimajuinu'g tlimultaq, ‘Ge' lapa'si, negm ta'n ilgwenaji mimajuinu' eig paqtaqamigtug,’ mut liew na'te'l. Pa na tlimultaq, ‘Jugu'a, ula tet, negm eig wen'ji'guomigtug,’ mut gtlams'tuaw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ni'n na mimajuinualsiap. Ta'n tujiw pgisintes na neia'sites st'ge' na wasoqotesg neia's'g ugjipenug aq pitiata's'g musigisg weja'tegemg ugjipenug glapis tg'snug. Na ms't wen nmi'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Gji'tutoqs'p ta'n nepg wi'sis epij na ga'qaqujg mawita'taq na'te'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Tel'gne'nug ta'n tujiw tetuji mtue'tew na na'gu'set mqatawamugsitew aq tepgun'set ma' nmiaqwi. Gloqowejg ugji nisita'titaq musigisg'tug aq elg ta'n te's'g goqwei musigisg'tug ewnasiatew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Na tujiw nat goqwei neia's'gt'tew musigisg'tug ugjit musga'tugsinew na ni'n ta'n mimajuinualsiap na jugu'a's. Na tujiw gaqaisg mimajuinu'g ugs'tqamug atgitemultitaq ta'n tujiw nmi'taq ni'n ta'n mimajuinualsiap wa'so'q wejgwi nisa'sia's alugwigtug. Na tujiw mawigna's aq Gjinisgam ma'muni gepmite'lmitew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mesgi'g pipugwaqan mtetaqt'tew. Pqotgima's ntansale'witemg ta'n telgi'g ugs'tqamu. Mawo'lata ms't Gjinisgam ugmimajuinumg ta'n gisi mgnapni. Wegla mimajuinu'g eimu'tijig ms't tami ugs'tqamug aq wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Wesgumg na miti's ta'n teluisit pi'gmenaqsi muta getu' gina'muloq nat goqwei. Ta'n tujiw na miti's poqji nipijua'ti'tij, na tujiw geituoq gigjiw nipg iga'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na wijei ta'n tujiw nmituoqol ms't goqwe'l ma'muniw mtue'gl ta'n gis tlimuloq ne'ita'tal, na tujiw gji'tutoqs'p apugjig apaja'sia's. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Migwite'tmug ula. Ta'n goqwe'l gis tlimuloq tliatal ge's mu alt mimajuinu'g ta'n gisgug mimajultijig npu'titaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ta'n goqwe'l etegl musigisg'tug na gaqiatal aq ugs'tqamu gaqiatew, gatu ta'n goqwei gis tlueiap na amujpa tliatew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mo wen geitoq giasgiw ta'n tliatew ms't goqwei ta'n gis tlimuloq. Na wa'so'q ansale'wijig mu geitu'ti'gw aq ni'n na Gjinisgam uggwisl mu geitu, pas'g nujj geitoq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ni'n na mimajuinualsiap aq ta'n tujiw apaji pgisintes na ms't wijei tliatew st'ge' ta'n goqwei teliaqap ta'n tujiw mimajiteg Noao'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Assma na na'gwegl ge's mu mespo'qegup ugs'tqamu, mimajuinugi'g siaw tlo'ltipnig st'ge' nige' mimajuinu'g tela'taqatijig. Mijjultipnig, malie'ultipnig aq je me', glapis na wijei na'gweg ta'n tujiw Noao'q tepa'siteg ugtuluaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wegla mimajuinugi'g mo geitu'tigupnig ta'n goqwei iga'qt'tew glapis ugs'tqamu mespo'qeg. Na tujiw wegla nepmu'tipnig samqwanigtug. Na wije'tew ta'n ni'n na mimajuinualsiap apaja'sia's. Mimajuinu'g ma' gji'tu'ti'gw ta'n tujiw pgisintes glapis ni'n i'ttes ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Na tujiw tapusijig ji'nmug tl lugwetaq iga'taqanigtug. Newte'jit ugsua'laten aq igtig nqalaten. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tapusijig e'pijig muling etl nugwa'gittutaq glumgl. Newte'jit ugsua'laten aq igtig nqalaten. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Na to'q, ango'tmug muta mo geituoq na na'gweg ta'n ni'n na Gjisaqamaw pgisintes. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Geitoq na assusit gejiasnn ta'n tujiw gmutnesl wejgu'elitl tepgig, na ma' ignmuagul gmutnesl pisgwa'lin wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Na iapji gisgajo'ltigw muta ni'n na mimajuinualsiap aq etugjel pgisintes ta'n tujiw mo etlite'lmiwoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Na lugowinu ta'n gis lita'sualut aq natawe'g tetapua'latl assusilitl. Na iga'lut'p niganpuguin esgwieliji lugowinu' aq smata ta'n tujiw gewisultilij. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ula lugowinu no'q ul'ta'sitew ta'n tujiw assusilitl pgisinnij muta geitoq ugtlugowaqan tetapua'toqop. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na miamuj telimuloq, na assusit ignmuatal ugtlugowinuml niganpugutmlin ta'n telgi'g assutg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Gatu na igtig lugowinu ta'n mo gelu'sigw na tluetew, ‘Pgije'tew na assusit ta'n tujiw pegising.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Na nqana'matew, gise'tew aq je we'gaw emegwei'wata igtigi lugowinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na assusit apaja'sitew ta'n tujiw ula lugowinu'l mu etlite'lmagugul aq mu esgmalagugul. ");
INSERT INTO micMIQNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na ulmaji ilsumatal aq tla'latal ta'n tla'luj na wesgijiangamgusultijig. Tli atgitemitew aq seggapitasitew muta ma'muniw welmaje'g na tujiw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ta'n Gjinisgam ilgwenaji mimajuinu', na wijei aq newtisgegsijig e'pite'sg ta'n nespnmi'titl wasoqwegl aq a'sugua'titl ji'nmul. Ula ji'nm eliet ta'n etl malie'witew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Na'nijig e'pite'sg piluasultijig, gatu esgwia'tijig geitmo'ltijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na piluasultijig nespnmi'titl wasoqwegl gatu mo mimei nespnmi'tigul. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Na geitmo'ltijig nespnmi'titl wasoqwegl aq mimeio'qig ta'n waju'pega'tijig mimei. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na ji'nm pegije'g pegising. Na e'pite'sg siawi esgmala'titl glapis getugsultijig. Toqo nep'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Na gisgattpa'q we'gaw nat wen telimaji e'pite'sg, ‘Na ji'nm pegising. Jugwita'gw aq ultesgug.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na newtisgegsijig e'pite'sg menjita'jig aq gisgaja'tu'titl wasoqwegl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Na piluasultijig e'pite'sg pipanima'tiji geitmo'ltiliji, ‘Ge' ta's'g mimei mqatuieg. Geget naqa'suegl.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Na geitmo'ltijig e'pite'sg telima'tiji, ‘Moqwa', mo tepianug ugjit ta'n te'si'gw. Magasang lta'gw aq nattelmug ta's'g ugjit gilewewe'l.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Na glaman wegla piluasultijig e'pite'sg maita'jig nattelmi'tij mimei. Ta'n tujiw gisi maita'jig na ji'nm aq ugte'piteml pisgwa'tijig ta'n mijjuaqan wesgowa's'g. Na geitmo'ltijig gisgajo'ltijig. Wije'wa'tiji na wen'ji'guomigtug aq nat wen gepsoqwa'toq ga'qan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Tel'gne'geg na igtigig e'pite'sg apaita'jig wen'ji'guomg aq teluejig, ‘Saqamaw pana'tuinen na ga'qan.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Telimgwi'titl, ‘Moqwa'. Telimuloq, mu nenu'luoq.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Na tujiw Se'sus telimaji mimajuinu', “Ango'tmug, muta mo geituoq ta'n tegen na'gweg apaja'sia's ugs'tqamug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ta'n getu tami Gjinisgam ilgwenaji mimajuinu' na tliatew pa wijei aq ta'n goqwei teliaq ula a'tugwaqan. Na ji'nm ilajit muta getu' liet na'tami se'g. Na wigumaji uglugowinumg aq niganpugua'laji ango'tmnew ta'n goqwei assutg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Te's newte'jilitl telgi'g suliewei ignmuaj ta'n tli gji ango'ttew ugsulieweiml. Ignmuatl newte'jilitl na'n pituiptnnaqana'igl. Ignmuatl igtigl ta'pu pituiptnnaqana'igl aq ignmuatl ap igtigl pas'g pituiptnnaqana'igl. Na tujiw maja'sipnaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na ji'nm ta'n ignmut'p na'n pituiptnnaqana'igl, poqji lugwet aq e'w'g na suliewei ugjit me' ganie'win suliewei. Wel lugwet lpa ganie'wit ap igtig na'n pituiptnnaqana'igl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na ji'nm ta'n ignmut'p ta'pu pituiptnnaqana'igl na wijei tela'teget. Ganie'wit igtig ta'pu pituiptnnaqana'igl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Gatu na ji'nm ta'n ignmut'pnn pituiptnnaqana'igl awna mulqatg maqamigeg aq na suliewei ta'n wejiaq ugtassusiteml iga'toq elmalqei'gtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Gis pmiaq na assusit apaja'sit aq pipanimaji ugtlugowinumg, ‘Tali e'wmoqs'p na suliewei.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na ji'nm ta'n ganie'wipnn na'n pituiptnnaqana'igl ignmuatl assusilitl ms't suliewei aq teluet, ‘Saqamaw, ignmui't'p na'n pituiptnnaqana'igl aq e'wmap ugjit ganie'win ap igtig na'n pituiptnnaqana'igl.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Assusit telimatl, ‘Me'gite'lmul. Wel lugwen aq gelu'sin lugowinu. Na tetapua'tege't'p ta'n tel puatm. Teli ntawo'tmn apje'jg suliewei na nige' iga'lul me' aji ms'gi'g ango'tmn. Pisgwa'tinej aq mawatalultinej.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Na ji'nm ta'n ganie'wipnn ta'pu pituiptnnaqana'igl pegising aq elg ignmuatl assusilitl ms't suliewei. Teluet, ‘Saqamaw, ignmui't'p ta'pu pituiptnnaqana'igl aq e'wmap ugjit ganie'win ap igtig ta'pu pituiptnnaqana'igl.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Na assusit telimatl, ‘Me'gite'lmul. Wel lugwen aq gelu'sin lugowinu. Na tetapua'tege't'p ta'n tel puatm. Teli ntawo'tmn apje'jg suliewei na nige' iga'lul me' aji ango'tmn. Pisgwa'tinej aq mawatalultinej.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Na ji'nm ta'n ignmut'pnn pituiptnnaqana'igl pegising aq telimatl assusilitl, ‘Saqamaw na metue'g ta'n tel lugowul. Getu' ganie'win je we'gaw ta'n mo iga'taqu't'p. Pewatmn apangituaqan ta'n mu te'pmun. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jipalul aq na glaman mimugwa'tuap gsulieweim maqamigeg. Ula nige' pegisitul.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Na assusit telimatl, ‘Malein aq mo tali ugtapsuniwn. Geitu'n na ganie'wi je we'gaw ta'n mo iga'taquap aq pewatm apangituaqan ta'n mu te'pmu. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Gatu goqwei ugjit ntsulieweim e'wmu's'p ugjit me' ganie'win ta's'g suliewei? Nige' gi'l ignmuigg ntsulieweim aq je me'.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Na tujiw assusit telimaji igtigi lugowinu', ‘Ugsua'tug pituiptnnaqana'igl aq ignmug na ji'nm ta'n metlas pituiptnnaqana'igl geggungl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ta'n wen geggungl ta's'gl, me' pugwelg ignmuaten glapis pa na ul tepiej. Gatu na negm ta'n apje'jg geggung, me' ms't ugsua'tuaten. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ula lugowinu ta'n mo wetapsunigw tua'lug aq ltesgug ta'n etl oqonitpa'q. Na'te'l tltemitew aq seggapitasitew wipitl muta ulmaje'tew.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ni'n na mimajuinualsiap aq apaja'sia's ugs'tqamug ugjit mimajuinu'g gepmite'lminew. Ms't ansale'wijig wije'witaq. Pmgopa'sia's nt'pung ta'n wijei aq elege'wit ugt'pun. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Gaqaisg mimajuinu'g tleiawultijig pilue'l umutgiwal ugs'tqamu tl mawita'taq na'te'l. Na tujiw nigtuo'la's ta'pu nemigsijig, pa wijei aq ji'nm ta'n angwewaji ugtue'mg tel nigtuo'laji jijgluewji aq te'plji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na mimajuinu'g pa na wijei aq jijgluewjig na igo'la's ntinaqanmg aq na mimajuinu'g pa na wijei aq te'pljig na igo'la's ntpatatujmg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ni'n ta'n elege'witewi tlima's mimajuinu ntinaqanmg, ‘Gjinisgam na nujj. Gilew ta'n nujj getu' gepmite'lmugsioq jugwita'gw ni'neg. Ignmugsitoqs'p ms't goqwe'l na negmewe'l ta'n gisitoqop ugjit gilew weja'tegemgeg ugs'tqamu gisita's'geg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gewisinap aq esmioqop, getu' samqwaiap aq esamqwo'ltioqop. Emittugwe'winuiap aq wigumioqop giguowal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Waqqaj gegnesiap aq gegno'tlioqop. Gesnugwaiap aq angweiwioqop. Laplusang eimap aq emittugwalioqop.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Na tujiw mimajuinu'g ta'n gis tla'taqatijig ta'n goqwei Gjinisgam pewatg pipanimitaq, ‘Gjisaqamaw, ta'n tet etl guisinu't'p aq esmuleg'p, gisna getu' samqwa't'p aq esamqwo'ltieg'p? ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ta'n tet etl nmu'leg'p emittugwe'winui't'p aq wigumuleg'p nignaq, gisna waqqaj gegnesi't'p aq gegno'tuleg'p? ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ta'n tet etli gsnugwa't'p gisna laplusang pisi't'p toqo ap mittugwaluleg'p?’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na tujiw ni'n na elege'wit tlima's, ‘Na ni'n gisi apoqonmuioq te's tujiw apoqonmuoq ntmimajuinumg je tlia ewle'jultijig.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Na tujiw mimajuinu'g ta'n eimu'tijig ntpatatujmg tlima's, ‘Jiglita'gw ni'neg, Gjinisgam ilsumugsitoqs'p ta'n goqwei te'pmoq. El'toqop pugtew ta'n iapjiw naqa'sueg. Pija'lata Gjimn'tu'l aq unaqapemg na'te'l. Nige' pewaluloq lta'new na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gewisinap gatu mo esmiwoqop, getu' samqwaiap gatu mo samqwan ignmuiwoqop. ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Emittugwe'winuiap gatu mo pewaliwoqop pisgwa'n giguowal. Waqqaj gegnesi gatu mo goqwei ignmuiwoqop. Gesnugwaiap aq laplusang eimap gatu mo apoqonmuiwoqop.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Na wegla mimajuinu'g pipanimitaq, ‘Gjisaqamaw, ta'n tet mo apoqonmulueg'p ta'n tujiw gewisineg, gisna getu' samqwaneg, gisna emittugwe'winuineg, gisna ewlgmneg, gisna gesnugwaneg gisna laplusang pisineg?’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na tlima's, ‘Telimuloq, na te's tujiw mo gisi apoqonmuawoqop ntmimajuinumg je tlia ewle'jultijig, na geitu mo getu' apoqonmuiwoqop.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Na wegla mimajuinu'g lgimaten ta'n iapjiw ulmajo'ltitaq gatu mimajuinu'g ta'n eimu'titaq ntinaqaneg lta'taq wa'so'q ugjit msnmnew iapjiwewei mimajuaqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ta'n tujiw Se'sus gaq gina'muet wegla ta'n goqwe'l, na telimaji unaqapemg, ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ni'n na mimajuinualsiap. Na Siawa'timgewei Pestie'umg pmietew tapuguna'qt'tew. Na tujiw nat wen ignmuitew ta'nig masgelmijig aq gujjiewte'itaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na tujiw niganpugultijig patlia'sg aq igtigig mawagnutmewinu'g weltesgatultijig Gaiapasal wiguaq. Negm na espe'g patlia's. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Wesgutmi'tij maw Gaiapas ta'n tl gimi ugsua'la'tital Se'susal ugjit ne'pa'new. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Teluejig, “Ma gis tla'taqatiwgw pestie'umg ta'n tujiw pugwelgig mimajuinu'g eimu'tijig tet. Jijuaqa ms'gi'gt'tew goqwei pegwatu'tij.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Se'sus emittugwet Pettani. Na'te'l pisgwa't Simonal wiguaq. Simon na ji'nm ta'n geggung'p na gsnugowaqan ta'n teluisig leplsi. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na e'pit pegising. Ela'latl pu'taiji'tl. Ula na gun'tewe'get ta'n teluisig alapastl. Waju'pelitl mego'tigewei amjaqto'suti. Na e'pit guta'tuatl Se'susal un'jig ula amjaqto'suti, ge's Se'susal etlatannitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na Se'sus unaqapemg nemitu'tij, na wegaiultijig. Teluejig, “Me' gatu pisuo'tg na amjaqto'suti. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Na ntuisgetmg gisi guguntesnu mesgi'g suliewei aq gisi ignmuanes ewle'juinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Se'sus gejiaji telueliji aq telimaji, “Mut lugowaqana'law na e'pit. Gisi ula'teget ugjit ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Iapji pugwelgig ewle'juinu'g wijitgweiugsitoqs'p gatu ma' iapjiw gis wijitgweiuluoq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ta'n tujiw guta'tuij amjaqto'suti nun'jieg, na pas'g gisgaja'lit ugjit utqutalimg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Telimuloq, ta'n ula e'pit gis tla'tegej na ugji migwite'lmaten, ta'n getu tami na gelu'lg agnutmaqan pestunten ta'n telgi'g ugs'tqamu.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na tujiw Se'sus unaqapeml ta'n teluisilitl Suta Isgaliot, elielitl ta'n niganpugultijig patlia'sg eimu'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Pipanimaji, “Goqwei ignmuitoqs'p apoqonmulinew ta'n tl gisapsgnatesnu Se'sus?” Na glaman wel'te'tmi'tij aq nesisga'qal suliewe'l ignmua'titl Sutaal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na weja'tegemgeg tujiw Suta gwilg ta'n tl ntuisgalatal Se'susal ugjit ugsua'lugsin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na tujiw iga'q na amgwesewei na'gweg mimajuinu'g e'wmi'tij pipnaqan ta'n mo apita'tas'gtnug, Se'sus unaqapemg pipanimgwi'titl, “Tami tet pewalieg gisgaja'tunen wela'gewei ugjit Siawa'timgewei Pestie'umg?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Se'sus telimaji, “Lta'gw na ji'nm ta'n ultesguanew na gjigang aq tlimug, Nujigina'muet teluet, ‘Ta'n goqwei weji pgisinap, getu' tliaq ula na'gweg. Ula na wela'gewei ugjit Siawa'timgewei Pestie'umg, ni'n aq nnaqapemg getu' tlatalultieg giguaq.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na Se'sus unaqapemg maita'liji aq gisgaja'tu'tilij Siawa'timgewei wela'gewei. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na wijei wela'gw, Se'sus aq unaqapemg pemgopita'jig ugjit wela'gewei. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ge's etlatalulti'tij, Se'sus telimaji, “Na telimuloq, nat wen te'sioq ntuisgalitew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na unaqapemg we'gwi ms'go'ltijig aq ingute'jit pipanimatl, “Gjisaqamaw, mu ta gatu wesgumiwn ni'n?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Se'sus telimaji, “Gtapegwija'tutew pipnaqan wijei eptaqanigtug maw ni'n, na negm ntuisgalitew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ni'n na mimajuinualsiap. Amujpa np'tes st'ge' ta'n tel wi'gas'g Gjinisgam ugtwi'gatigng. Gatu mawi mtue'tew ugjit na ji'nm ta'n ntuisgalitew. Etug me' glu'lgtesoq ugjit na ji'nm mu ugs'tqamuigusnn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Na tujiw Suta, ta'n getu' ntuisgalatal Se'susal, teluet, “Nujigina'muet mu ta gatu wesgumiwn ni'n?” Se'sus telimatl, “Gi'l na teluen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na ge's Se'sus aq unaqapemg etlatalulti'tij, Se'sus wesua'toq pipnaqan aq miwatmuatl Nisgaml. Na tujiw nasgwa'toq pipnaqan aq ignmuaji unaqapemg. Na telimaji, “Ula na na'qi, ms't ta'n te'sioq ugsua'tug aq malqotmug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na tujiw wesua'latl nqanipsmun aq miwatmuatl Nisgaml. Ignmuaji unaqapemg aq telimaji, “Ugsua'tug ta'n te'sioq aq wet samqwoltigw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ula na nmal'tem. Gjinisgam teplumasit apigsigtmuanew pugwelgig mimajuinu'g ugtlue'utiwal ta'n tujiw lita'sualitaq ni'neg. Teplumaji tla'tegen, muta nmal'tem guta's'gt'tew ta'n np'tes gujjieweigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ula telimuloq, ma' nugu samqwaw moqopa'q glapis na na'gweg tli ultesgatultitesnu nujj ugtelege'wa'gimg wa'so'q. Na'te'l ap samqwoltitesnu.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Na gis tlimateg, a'sutmaqanewintu'tijig aq tewita'jig. El'ta'jig na gm'tnigtug teluisit Olipet. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Se'sus telimaji unaqapemg, “Ula wijei ulo'nug, ta'n te'sioq naqalitoqs'p aq ugsmultitoqs'p. Gjinisgam ugtwi'gatign tel wi'gas'g, Gjinisgam teluet, ‘Ne'pa's nujiangweiwaji ugtue'mg aq jijgluewjig se'so'togu'titaq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Gatu gis minunsian, na lia's Galaliewa'gi ge's mu peita'woq na'te'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pie'l telimatl, “Etug ms't mimajuinu naqalultaq, gatu lpa ma' naqalulnu.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Se'sus telimatl Pie'lal. “Telimul ula. Ge's mu napew getu'g egsitpu'nug, si'st tluetes mo nenuiwn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pie'l telimatl, “Lpa ma' tluew mo nenu'lu, je tlia npman maw gi'l.” Ms't Se'sus unaqapemg teluejig wijei st'ge' Pie'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ta'n tujiw Se'sus aq unaqapemg peita'titeg na gm'tng, el'ta'jig ta'n eteg iga'taqan teluisig Getsemani. Na telimaji, “Pe'l tet pita'qw, ala tet eliei, naji a'sutmai.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na nespnaji Pie'lal aq tapusiliji Sepeti uggwisg. Se'sus ma'muniw ewlgwijing aq ma'muni ulmajita'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Telimaji unaqapemg, “Ma'muni ewlgwijin. Sigti ulmajita'si. Siaw i'mu'tigw tet. Mut nep'tinew aq a'sutmessewigw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na me' naqajijge'le'l eliet. Nutgul'paqjetesing maqamigeg muta tetuji gitnmat. A'sutmat, “Gjinisgam gi'l na nujj, etawaqtmul jigla'tui ula ulmajo'qon ta'n wejgu'aq. Gatu na tliaj st'ge' ta'n gi'l tel puatmn, mu na ta'n ni'n tel puatm.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Na tel'gne'geg na apsgwa'sit ta'n nesisiliji unaqapemg eimu'tiliji aq nemiaji nep'tiliji. Tugwa'latl Pie'lal aq telimatl, “Tal gis gilew mo gis alapultiwoq ge's etli a'sutmai? ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Angaptmu'tigw aq a'sutma'tigw glaman ma' mn'tu gisa'lugsiwoq tla'taqatinew lue'uti'l. Getu' tla'taqatioq pas'g mo gis tla'taqatiwoq muta wesami gtugsultioq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ap na ta'puewei Se'sus naji a'sutmat, “Gjinisgam gi'l na nujj, pa na ula ulmajo'qon ma' gisi jigla's'gtnug aq amujpa ulmaje'tes, na tliaj st'ge' ta'n gi'l tel puatmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Na ap apsgwa'sit aq ap nemiaji unaqapemg nep'tiliji. Me' gatu tetuji gtugsultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Na ap Se'sus naqalaji aq ap si'stewei wijei teli a'sutmat. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na tujiw eliet ta'n unaqapemg eimu'tiliji aq telimaji, “Me' nep'tioq aq etli atlasmultioq. Ni'n na mimajuinualsiap aq nige' gi's iga'q ugjit iga'limg na lue'winu'g ugpitnuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mn'jita'qw, maita'nej. Ge' lapita'gw, na ji'nm ta'n gisi ntuisgalit pegising.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Me' Se'sus etlewistoq na tujiw Suta, newte'jilitl unaqapeml pegisinnitl. Pugwelgig mimajuinu'g pema'tu'titl espo'qwas'gl aq petgute'gne'l peji wije'wa'titl Sutaal. Niganpugultijig patlia'sg aq natawo'ltijig ji'nmug elgima'tiji wegla mimajuinu' na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na Suta gis telimaji na mimajuinu', “Ta'n tegen ji'nm wesgaqalm'g na negm ta'n pewaloq. Ugsua'lug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Eliet Se'suseg aq teluet, “Nujigina'muet, me' taliasgig?” Na tujiw wesgaqalmatl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Se'sus telimatl, “Smtug lugwaten gtlugowaqan!” Na igtigig goqqwa'la'titl Se'susal aq melgigna'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Se'sus unaqapeml wesua'toq espo'qwas'g aq taqamatl espe'g patlia'sl ugtlugowinuml. Lpa mente'muatl ugs'tuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Gatu Se'sus telimatl, “Masgwa'l na tlawo'q, muta ta'n wen e'watl tlawo'qol na ugji np'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Geituoq apoqonmatimg puatma's, pas'g glula's nujj aq smtug petgimata lluigneg te'sisgegsiliji je ta'pu pituiptnnaqaniliji ansale'wiliji ugjit apoqonmuin? ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Gatu ta'n goqwei tliatew amujpa teliaq st'ge' ta'n goqwei gis ewi'gas'g Gjinisgam ugtwi'gatigng.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na tujiw Se'sus telimaji na mimajuinu', “Pegisuloqiq espo'qwasijig aq petgute'gne'l muta getu' goqqwa'lioq. Tel'te'lmioq na pa wijei aq nat wen gmutnesg. Te'sigisg'g etl gina'muap gjia'sutuo'guomg gatu mo tala'liwoqop na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Gatu ula gis tliaq ugjit gisa'tun tlian ta'n goqwei ta'n niganigjitegewinugi'g ewi'gmi'tip.” Na tujiw ms't unaqapemg naqalgwi'titl aq wesmultiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na wegla ta'n gisi goqqwa'la'titl Se'susal ela'la'titl Gaiapas wiguaq aq pisgwa'la'titl. Na nujigina'mua'tijig tplutaqan aq igtigig ta'n niganpugultijig etl mawita'tij maw Gaiapasal na espe'litl patlia'sl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na gnegg ugtejge'l Pie'l majulgwalaji aq pisgwa't iga'taqanigtug ta'n espe'litl patlia'sl wen'ji'guoml gigto'qwagwegl. Na epa'sit maw ta'nig ango'tmi'tij gjia'sutuo'guom. Na'te'l etli esgmatg ta'n tliatew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na lamguomg Gaiapas wiguaq, niganpugultijig patlia'sg aq nuji ilsutaqatijig maw agnutma'tijig nat goqwei ta'n pisui ilsutmuan Se'susal ugjit ne'po'qsilin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Gatu lpa mo na we'jitua'ti'gw goqwei, we'gaw pugwelgig pisui agnima'titl aq egsuaqanima'titl Se'susal. Na tujiw tapusijig ji'nmug gaqamijig ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","aq teluejig, “Ula ji'nm nutaqatt'p teluep, ‘Ni'n gis suisgo'tutes na gjia'sutuo'guom aq nesuguna'q gisi ilitutes.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Na espe'g patlia's gaqama'sit aq pipanimatl Se'susal, “Getu asitemjig wegla ji'nmug? Goqwei getu' tluen?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Gatu Se'sus mo gelusigw. Ap Gaiapas gelulatl, “Lui'tmasi Nisgameg aq tliminen pa na gi'l na Nujiugs'tawi'wet. Tliminen pa na gi'l na Gjinisgam uggwisl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Na tujiw Se'sus telimatl, “Gi'l na teluen. Ni'n na mimajuinualsiap, gatu nige' telimuloq, nmioqs'p pmgopia's Gjinisgam ta'n mawignat ugtinaqanmg aq wejgwi nisa'sites alugwigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ta'n tujiw espe'g patlia's ula nutuateg, na we'gwi uggwaig aq ugpitu'gunml sewisgina'latl. Teluet, “Ula ji'nm anmimatl Nisgaml. Mu amujpa nujo'teget telimugsi'gw ula ji'nm gesapuguet muta gis nutmugg ta'n tujiw anmimatl Gisitegelitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tal'te'tmoq nige' muta gis nutuoq ta'n tujiw gesapuguet?” Mimajuinu'g na'te'l telima'titl, “Teliaq, ula ji'nm ma'muni pata'teget aq amujpa ne'po't.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Na tujiw elusguma'titl aq taqama'titl. Alt paqtne'ita'titl ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aq telima'titl, “Pa na gi'l na Nujiugs'tawi'wet, tliminen na ta'nig gisi tqam'sgig!” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pie'l me' pemgopit gujmug. Na e'pite's ta'n elugowatl gjipatlia'sl eliet Pie'leg aq telimatl, “Gi'l na elg wijitgweia't'p na Se'sus ta'n tleiawit Galaliewa'gi.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Gatu Pie'l petgwasit aq telimatl, “Lpa mo geju'lu ta'n goqwei wesgutmn.” Na mimajuinu'g ta'n eimu'tijig na'te'l nutua'titl ta'n goqwei Pie'lal teluelitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pie'l gaqama'sit aq eliet ta'n eteg na ga'qana'tas'g. Na tujiw igtig e'pit nemiatl aq telimaji mimajuinu ta'n alpugultiliji na'te'l, “Ula ji'nm al wije'wapnn na Se'susal ta'n Nasalet tleiawilitl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ap Pie'l petgwasit aq teluet, “Elui'tmasi, mo nenuaq na ji'nm ta'n wesgumt.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na tel gnegg ta'sijig ji'nmug ta'n alpugultijig tlima'titl Pie'lal, “Talma gi'l wijitgweia't'p muta ta'n teli'sin geju'leg ta'n wejien.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Na tujiw Pie'l elui'tmasit aq teluet, “Gjinisgam gisi ugtapulitew pa na tli egsueian. Mo nenuaq na ji'nm.” Giasgiw na tujiw napew getu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pie'l mi'gusit ta'n Se'susal gisi tlimtl, “Ge's mu napew getu'g na si'st tluetes mo nenuiwn.” Na tujiw Pie'l maja'sit aq sigt'temit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ta'n tujiw gisapniaq, ms't niganpugultijig patlia'sg aq igtigig niganpugultijig mawita'jig aq agnutmi'tij ta'n tl ne'pa'ten Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Alt gelpila'titl Se'susal aq ela'la'titl Piloteg. Pilot na niganpuguit g'pnno'lewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na Suta ta'n netuisgelapnn Se'susal gejiatl ne'po'qsilital. Na mesge'g. Wesua'toq na nesisga'qal suliewe'l aq apaji ignmuaji na niganpugultiliji patlia'sg aq natawo'ltijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Telimaji, “Gisi pata'tegei muta pisui opla'laq. Na ji'nm ta'n mo goqwei opla'tegegup aq nige' elg pisui ne'pa'ten.” Na telima'titl Sutaal, “Mu sespetalsultiweg. Gi'l na gtla'taqan, mu ninen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Suta paqiatgweitestoqol na suliewe'l epsaqtaqtug gjia'sutuo'guomg. Maja'sit aq gestunepilsit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na niganpugultijig patlia'sg megnmi'tij na suliewei aq teluejig, “Ula suliewei na gis apangita'tas'g'p ugjit ne'po'qsin na ji'nm. Gt'tplutaqanminu telueg mo teltenug ugjit ginu e'wmnew ula suliewei a'sutuo'guomg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Na wel'te'tmi'tij e'wmnew suliewei ugjit pegwatelmnew iga'taqan. Na ji'nm ta'n etl gisiaj wowg na netuisgmaji gjipatlia'sg ugtiga'taqanm. Na gjipatlia'sg e'wmi'tij iga'taqan ugjit utqutaqane'gati. Mimajuinu'g ta'n mu Lesui'peulti'gw utqutalujig na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nige' gisgug na iga'taqan me' tel wi'tas'g na mal'tewig maqamigew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na niganigjitegewinuaq ta'n teluisipnaq Jelamaia teluepnaq ula na gis teliaqap. Na teluep, “Ta'sijig Lesui'paq wel'te'tmi'tij e'wmanew nesisga'qal suliewe'l ugjit apangitman newte'jit ji'nm. Ula suliewei ugsua'tu'titl, ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","aq apangitua'titl na ji'nmul ta'n etliaji wowg ugjit ugtiga'taqanm. Na gis tliatew giasgiw st'ge' ta'n goqwei Gisiteget telimip.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na tujiw Se'sus gaqama'lut Piloteg muta Pilot niganpuguit ugjit Lo'mewei g'pnno'l. Pilot pipanimatl Se'susal, “Gi'l na Lesui'paq ugtelege'witemual?” Se'sus telimatl, “Gi'l na teluen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Na niganpugultijig patlia'sg aq natawo'ltijig gelula'titl Pilotal aq pisui elsutmua'tital Se'susal gatu Se'sus mo goqwei teluegw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Na tujiw Pilot pipanimatl Se'susal, “Mo nutmun ta'n goqwei gis elsutmasgig?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lpa Se'sus mu gelusigw, na tujiw Pilot pajiji paqalaig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Te's Siawa'timgewei pestie'umg na Lo'mewei niganpuguit ta'n eig Selusalemg tewalqa'latal newte'jilitl ta'n laplusang pisilitl. Tewalqa'latal ta'n tegenn na mimajuinu'g wel'te'lma'titl ugjit tu'elin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na tujiw pisit laplusang na ji'nm ta'n teluisit Se'sus Palapas. Na wel nenut. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ta'n tujiw mimajuinu'g gisi mawita'ti'tij, Pilot pipanimaji, “Tegen pewalioq tualqa'lan, Se'sus Palapas gisna Se'sus ta'n mimajuinu'g tel wi'ta'titl Nujiugs'tawi'wet?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilot gis geitoq na niganpugultijig wesua'la'tipnn Se'susal muta wisgua'la'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ge's Pilot pemgopij ta'n etli ilsutegej, ugte'piteml petgitmlij agnutmaqan ta'n telueg, “Mut nasalsiw goqwei ula ji'nm muta gelu'sit. Wela'gweg pewi'g'p. Welmajita'sip aq me' nige' jipaqa'si.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na niganpugultijig patlia'sg aq mawagnutmewinu'g munsaiwa'tiji mimajuinu' pipanimanew Pilotal ugjit tualqa'lan Palapasal aq ne'po'qsilin Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilot ap pipanimaji, “Tegen wegla tapusijig pewalioq iga'lan?” Telimgwi'titl, “Iga'l Palapas.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilot pipanimaji, “Gatu nige' tala'lates Se'sus ta'n tel wi'tut Nujiugs'tawi'wet?” Ms't teluejig, “Gujjiewta'nej!” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Gatu Pilot pipanimaji, “Goqwei gisi pata'toq?” Na mimajuinu'g ma'muni sesgu'tijig, “Gujjiewta'nej!” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Na tujiw Pilot nest'g mo wetapsuninug ugjit siawi glulaji muta ma'muni uggwaiultiliji. Na ugpitnn gesispa'toqol aq telimaji mimajuinu', “Mu ni'n tela'tegew ula ji'nm npuaqan. Gilew ula gisi pgwa'tuoq!” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ms't mimajuinu'g telima'titl, “Ninen aq nn'janinaq gisi pgwatutesnen ugjit ula ji'nm npmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Na tujiw Pilot tela'teget ta'n goqwei mimajuinu'g pewatmli'tij, na iga'latl Palapasal aq pipanimaji ugsma'gnismg wisqapaqtan Se'susal. Ta'n tujiw Se'sus gisi wisqapaqto'teg, na Pilotal elgimtl ugjit gujjiewto'qsin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na tujiw sma'gnisg pegisula'titl Se'susal na g'pnno'lo'guomg. Na ms't sma'gnisg mawita'jig na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Se'susal utapsun menina'tua'titl aq pitu'gwala'titl, e'wmi'titl megwe'litl pitu'gunn muta getu' maligima'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Goqominaqsie'l na gigto'qopito'tu'tij aq nasa'tua'titl Se'susal un'jig. Gmu'j ignmut ugpitn inaqanei. Na tujiw gigto'qi nutgulpita'jig aq maligima'titl. Teluejig, “Pgitawsi muta elege'witewin ugjit Lesui'paq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na elusguma'titl aq nat wen wesua'toq na gmu'j ta'n ignmatl Se'susal. E'wmi'tij ula gmu'j aq matta'titl un'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ta'n tujiw siwi maligima'titl mena'tua'titl na pitu'gunn aq apaji nasa'tua'titl utapsunn. Na ela'la'titl ta'n tl gujjiewta'tital. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ge's maita'jig gjigang, na weltesgua'titl ji'nmul teluisilitl Simon, tleiawilitl Sailin. Na sma'gnisg gisa'la'titl Simonal pmapinmilin gujjiewei ugjit Se'sus. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na el'ta'jig ta'n teluisig Golgota. Ula wisun telueg waqan'tewatpat. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na'te'l ignmua'titl Se'susal moqopa'q ta'n wiaqpega'tas'g nat goqwei wisqe'g. Ta'n tujiw Se'sus wett'g, mu esamqwagw. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Na gujjiewta'titl aq utapsunn elegetu'tij ta'n wen ugtete'tal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na tujiw pemgopita'jig na'te'l aq angama'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sma'gnis ewi'g'g agnutmaqan. Ula telueg ta'n Se'sus ilsumut gujjiewto'qsin. G'p'taq Se'sus un'ji nastmi'tij na agnutmaqan. Telueg, “Ula na Se'sus, na elege'wit ugjit Lesui'paq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na sma'gnisg tapusiliji gmutnesg gujjiewta'tiji etuiw Se'suseg, newte'jit ugtinaqanmg aq igtig ugpatatujmg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mimajuinu'g ta'n el'ta'jig gjigang gisna maita'jig na'te'l naqita'jig aq angama'titl Se'susal. Un'jiwal pepuegetitl aq maligima'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Alt telima'titl, “Gi'l getu' seioqte'mu't'p gjia'sutuo'guom aq getu' ilitu't'p pas'g nesuguna'q. Mo gis tla'tegewn. Pa na gi'l na Gjinisgam uggwisin, ugs'tawi'si aq nisalsi na gujjieweigtug!” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na niganpugultijig patlia'sg, nujigina'mua'tijig Mowisewei tplutaqan aq mawagnutmewinu'g na maligima'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Teluejig, “Gisi ugs'tawiapni igtigi, gatu mo gisi ugs'tawi'sigw? Teluep negm na elege'witewit ugjit Lesui'paq. Pa na nige' gisi ugji nisa'sij na gujjieweigtug, na gtlams'tuatesnen. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Elita'sualatl Gjinisgaml aq teluet negm na Gjinisgam uggwisl. Na to'q, ge' angamlij etugjel Gjinisgam ugs'tawian!” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Je we'gaw na gmutnesg ta'n mawi gujjiewta'sijig elg wijei tel maligima'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na mewlia'gwej, ta'n telgi'g na umutgiwaq oqonitpaqamugwa's'g. Me' oqonitpa'q glapis si'st ajiej. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Na'tami si'st ajiej, Se'sus gesigaw sesgwet, “Eloi, Eloi, lama sabachthani?” ta'n telueg, “Ntnisgamum, Ntnisgamum, tal gis puna'lin ni'n?” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ta'sijig ta'n gaqamultijig na'te'l nutua'titl aq teluejig, “Wigumatl Ilaijaal.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Newte'jit na'te'l eliputuaj spanj waju'peg moqopa'q. Naspilas'g gmu'jigtug aq elasqa'tuaj ugjit Se'susal samqwalin. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Gatu na igtigig awna teluejig, “Pe'l angamanej, etugjel Ilaija jugu'etew aq ugs'tawiatal!” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Se'sus ap sesgwet aq nepgaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na tujiw na mesgi'g elaqpilaqan ta'n gaqapitg gjia'sutuo'guom pasgina's'g g'p'taq glapis epune'g. Maqamigew gesigaw maja's'g aq lpa gun'tal pasgine'tesgl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","We'gaw na maqamigew ta'n eteg utqutaqane'gati pasgina's'g, aq pugwelgig gisi npu'tijig minua'lujig. Wegla na Gjinisgam ugmimajuinumg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ta'n tujiw Se'sus gis minunsitew wegla mimajuinu'g naqtmi'tij utqutaqane'gati aq pisgwita'jig sape'wig gjigang. Pugwelgig mimajuinu'g nemia'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na niganpuguit sma'gnis aq igtigi sma'gnisg angama'titl Se'susal npmlin Na nemitu'ti'tij maqamigew maja's'g aq ms't goqwei gi's tliaq, sigt'ta'sultijig aq teluejig, “Negmaq giasgiw Gjinisgam Uggwisl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na pugwelgig e'pijig gnegg eimu'tijig aq angaptmi'tij ta'n goqwei gis tliaq. Peji majulgwala'tipnn Se'susal weja'tegemg Galaliewa'gi glapis Selusalemg aq apoqonmua'tipnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Newte'jit teluisit Mal Matle'n aq igtig teluisit Mali na Ji'mej aq So'sep uggwijual. Negm na Sepeti ugte'piteml. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ge's mu na'gu'set galqwasiegw, wejgu'et milesuinu ta'n teluisit So'sep, Na tleiawit Alamatia. Negm na Se'sus unaqapeml. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Eliet Piloteg aq pipanimatl ignmagun Se'susal muta gis nepmlita. Pilot telimatl sma'gnisl, “Ignmuatmu So'sep na Se'suso'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","So'sep wesua'latl Se'susal aq oqonisgwa'latl pilei atla'wegnigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ge's mu Se'sus nepmugweg So'sep gisi pempujeteg mesgi'g elmalqei gun'tewigtug. So'sep gisgaja'toqop ula elmalqei ugjit ta'n lsma'laten. Na nige' jugwa'latl Se'susal aq elsma'latl ula elmalqei. Wesua'toq mesgi'g gun'tew aq te't'pja'toq ta'n weji pisgwa'timg elmalqeigtug. Na tujiw maja'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Gigjiw ta'n Se'sus elisinnij pemgopijig Mal Matle'n aq na igtig Mali. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na igtig na'gweg na atlasmutigisg'g. Na tujiw niganpugultijig patlia'sg aq Palasiaq el'ta'jig Piloteg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Telima'titl Pilotal, “Saqamaw, migwite'tmeg na glusqapoq gesgmnaq nepmugweg teluepnaq, ‘Minunsia's gisi nsuguna'q.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nige' pewaluleg ango'tmn na utqutaqane'gati nesuguna'q. Mut wen ignmuaw pisgwa'n ta'n ji'nmaq elisinnij. Na tujiw unaqapemg ma' gisi gmutnala'tigul Se'susal aq na tujiw tluetaq, ‘Minunsitaq.’ Na ula me' ms'gi'gt'tew egsuo'qon je mu esgwiaq ta'n ji'nmaq teluepnaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilot telimaji, “Ugsua'lug ta'sijig sma'gnisg aq tlimug ango'tmu'tinew na utqutaqane'gati. Mut wen ignmuow pana'tun na elmalqei.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Na gji patlia'sg aq Palasiaq el'ta'jig utqutaqane'gati aq nasa'tu'tij agnutmaqan na gun'tewigtug te't'pja'tas'g'p ta'n etl pisgwa'tmg utqutaqan ta'n Se'sus elisinnij. Ula agnutmaqan telueg, “Mut wen te't'pja'tuij ula gun'tew.” Na tujiw iga'la'tiji sma'gnisg ango'tmnew utqutaqane'gati. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na atlasmutigisg'g gaqiaq. Wejgwapniaq aqan'tie'umg, Mal Matle'n aq igtig Mali ela'tijig naji angaptmi'tij ta'n Se'sus elisinnij. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na jiniw maqamigew gesigaw maja's'g. Gisiteget ugtansale'witeml wet neia'silitl wa'so'q. Ansale'wit pegising aq ejigli te't'pja'toq na gun'tew ta'n nigantug elmalqei. Wesgitgopa'sit ula gun'tewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na telaset pa wijei aq wasoqotesg aq utapsun teli gsi wape'g pa wijei aq wastew. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na sma'gnisg ta'nig eimu'tijig na'te'l ma'muniw jipaqita'jig aq neng'tesultijig ta'n tujiw nemia'titl ansale'wilitl. Mesqanatesultijig maqamigeg. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ta'n tujiw e'pijig pegisini'tij, na ansale'wit telimaji, “Mut jipasinew. Geju'loq al gwiluoq Se'sus ta'n gujjiewto't'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mu tet eimug. Na negm gis minunsit st'ge' ta'n teluep. Jugwa'tigw aq angaptmug ta'n elising'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ta'n tujiw e'pijig pisgulapa'ti'tij elmalqe'g, na ansale'wit siawewistoq, “Na nige' la'tigw, nat tlimug unaqapemg, ‘Se'sus gis minunsit.’ Nigan lietew Galaliewa'gig. Na'te'l tl nmiatoqs'p. Mut awan'ta'sinew ta'n gis tlimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Na smtug e'pijig naqtmi'tij utqutaqane'gati. Jaqalita'jig naji agnutmuanew Se'sus unaqapemg ta'n goqwei gis tliaq. Jipaqa'sipnig ta'n tujiw nemia'titl ansale'wilitl gatu welgwijingig muta Se'sus gis minunsit. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ge's e'pijig ela'tijig ta'n Se'sus unaqapemg eimu'tiliji, Se'sus asuguaji aq telimaji, “Gjinisgam wel'te'lmugsioq.” Na e'pijig ela'tijig Se'suseg aq sama'tua'titl uggwatl. Emtoqwala'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Se'sus telimaji, “Mut jipasultinew. Siawa'tigw aq tlimug nnaqapemg lta'new Galaliewa'gi ta'n tl nmi'taq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ge's na e'pijig siawa'tijig ta'n Se'sus unaqapemg eimu'tiliji, na sma'gnisg ta'n ango'tmi'tij utqutaqane'gati apaita'jig gjigang aq agnutmua'tiji niganpugultiliji patlia'sg ta'n goqwei gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na gjipatlia'sg aq mawagnutmewinu'g agnutma'tijig ta'n goqwei gis teliaqap. Mo pewalagwi mimajuinu'g gji'tunew ta'n goqwei gis teliaqap, glaman ignmua'tiji sma'gnisg mesgi'g suliewei. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Telima'tiji, “Pewaluleg tliman mimajuinu'g na ji'nmaq unaqapemg peita'lipni miawitpa'q aq gemutnala'tipnn ge's nep'tioq. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pa na niganpuguit g'pnno'lewigtug nutmaj ula, ignmuatesnen suliewei aq ma' ilsumugsiwoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Na sma'gnisg wel'te'tmi'tij, wesua'tu'tij suliewei aq teluejig ta'n goqwei Lesui'paq gis telima'tipni. Na nige' gisgug me' Lesui'paq teluejig, “Se'sus unaqapemg gemutnala'tipnn npuinu'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na newtisgegsiliji je newt unaqapemg el'ta'liji na gm'tng Galaliewa'gig ta'n Se'sus telimapni lta'new. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nemia'tij Se'susal emtoqwala'titl jel tlia alt megtmu'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Na Se'sus gigja'siji unaqapemg aq na telimaji, “Gisi ignmuimg assusuti ta'n telgi'g wa'so'q aq ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nige' lta'gw ta'n telgi'g ugs'tqamug aq gina'mug mimajuinu'g ta'n goqwei gis gina'muloq. Tla'taqatigw glapis na ta'n tel gaqaisg mimajuinu'g tleiawultijig pilue'l umutgiwal na nnaqapemultinew. Sign'tug ms't nnaqapemg. Te's sign'tuoq tlimug, ‘Na Gjinisgam ta'n teluisit Wegwisit Nisgam aq Ewjit Nisgam aq Wejuli Nisgam petgimugsieg sign'tunen ginu.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Gegnu'tmug majulgwatmnew ta'n te's'g goqwei gis gina'muloq. Na iapjiw wijitgweiultoqs'p ula ugs'tqamug aq maw wa'so'q.”");
INSERT INTO micMIQNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ula na gelu'lg agnutmaqan ugjit Se'suguli na Gjinisgam Gisiteget uggwisl. Na teli pqotamgiaq 'st'ge' gis wi'g'g'p Gjinisgam wi'gatignigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Gisna nige' sa'q iganigjitegewinuaq Aiseiao'q gi's wi'gig'p ta'n Gjinisgam uggwisl telimapnn, “Ge' jigs'tui. Igangima's ntagnutmewinum ugjit gisgaja'tun ta'n gi'l lietes.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Nat wen gesigawewistoq paqtaqamigtug, teluet, ‘Gjisaqamaw wejgu'et. 'Ms't ta'n te'sioq gisgajo'ltigw!’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Etna na teliaqas, na ji'nm teluisisnaq Sa'n neia'siteg paqtaqamigtug. Pugwelgig mimajuinu'g ta'n tleiaultijig Jutia aq na 'gjigan teluisig Selusalemg naji jigs'tua'titl Sa'nal. Pestunmuaji aq telimaji mimajuinu'g, “Gawasgita'sultigw aq jiglita'gw elue'utigtug aq sign'tasultigw! Na toqo tujiw Gjinisgam apigsigtmugsitoqs'p ta'n te's'gl 'gtlue'utimual.” Na mimajuinu'g, ingute'jit teluejig, “Ni'n na elue'winui,” aq Sa'nal sign'taji sipug Jol'tan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Sa'n nasg'gl aligal wejitas'gl melgawlejit usapun. M'gegne'l ugtispisunn nasguatl. Malqomaji apsoqongewji aq amu apu. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Telimaji mimajuinu'g, “Na ji'nm ta'n 'pgisintew, me' espe'g aq ni'n. Mo tepawgtiw we'gaw golomgwaqwa'sin aq apgwa'tuan umugsnapi'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Samqwan e'wm sign'tuloq gatu negm sign'tugsitoqs'p, e'watal Wejuli Nisgaml.” Na teluet Sa'n. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Etna na tujiw Se'sus weji maja'sit Nasaletg. Ula gutanji'j eteg Galaliewa'gig. Se'sus eliet Sa'neg aq Sa'n sign'tuatl sipug Jol'tan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ta'n Se'sus weji natga'siteg samqwanigtug, nemitoq wa'so'q panta's'g aq na Wejuli Nisgaml nisa'silitl st'ge' ples. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gjinisgam metewistoq wa'so'q aq teluet. “Gi'l na newgti pistai 'ngwis aq mawi gsalul. No'q tetapua'lin gi'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Smtug Wejuli Nisgam tela'latl lielin 'ngutugwa'lugwelin paqtaqamigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Na wi'sisg eimu'tijig na'te'l. Se'sus eig na'te'l ne'wisgegiguna'q aq Gjimn'tu wet nu'gwalatl. Na ansale'wijig peita'jig aq apoqonmua'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Toqosip Sa'n gis pija'luteg laplusang, Se'sus eliet Galalieg aq gegnu'tmuaji na gelu'lg agnutmaqan, ta'n wejiaq Gjinisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Telimaji, “Glapis gatu nige' iga'q tetaputesg, Gjinisgam getu' musga'tugsioq ta'n teli elege'witewit. 'Gtlams'tmu'tigw na gelu'lg agnutmaqan aq gawasgita'sultigw aq jiglita'gw elue'utigtug!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ge's Se'sus pemieteg gigjiw qospemg Galali nemiaji tapusiliji usgewinu'g, na Simon aq ugjignaml Antle'al, etlia'piejig na qospemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Se'sus telimaji, “Nige' pas'g gilew usgewinu'g. Wije'wigw ni'n aq gnu'tmultoqs'p aq gisa'lultoqs'p jugwo'lanew mimajuinu'g Nisgamewigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Smtug naqala'tiji ugta'pimuaq aq wije'wa'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Naqajijge'le'l siawa'sit sitmug aq nemiaji igtigi tapusiliji wijigatiliji, Ji'mejal aq Sa'nal, tepultiliji ugtuluaq maw ujjual, Sepetial. Etli msni'sna'tiji ugta'pimuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Se'sus nemiateg na smtug wigumaji. Na naqala'titl ujjual Sepetial maw lugowinu'g ugtuluaq aq wije'wa'titl Se'susal. Peita'jig gutanji'j teluisig Gapelniam. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ta'n teli nqase'g iga'q atlasmutigisg'g, Se'sus eliet a'sutuo'guomg aq poqji gina'muet. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mimajuinu'g ta'n nutua'titeg, paqalaiultijig ta'n tel gina'muelij muta mo tele'ligupnn 'st'ge' nujigina'mua'tijig 'tplutaqan. Awna ta'n tel geitoq aq ta'n goqwei wesgutg, na tel gina'muet. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na tujiw ji'nm ta'n mn'tu'l ugtinneg eimlitl pegising na a'sutuo'guomg aq sesgwet. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Taluegeieg ninen, Se'sus, gi'l tleiawin Nasalet? Weji pgisinu's'p ugjit seioqwa'linen? Nenu'l ta gi'l wenin, gi'l na sape'winuin, Gjinisgam uggwisl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Se'sus melgimatl na mn'tu'l, “Wantaqa'si aq gettaqa'si na ji'nmuigtug!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na mn'tu gisa'latl na ji'nmul wejipulgwelitl. Na mn'tu ma'muniw sesgwet aq getaqqa'sit ji'nmuigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na 'ms't mimajuinu'g tetuji paqalaiultijig aq pipanimtultijig, “Tal gis tliaq ula na? Tal gina'muet ta u't? Amuj na ji'nm mesgi'g ml'gigno'ti geggung, we'gaw mn'tu'g gisi assumaji. Na mn'tu'g gi's tla'taqatiliji ta'n negm teli gsatg aq jigs'taji!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Smtug na agnutmaqan ta'n Se'sus gis tela'teg'p se'sa's'g ta'n telgi'g Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ta'n tujiw naqtmi'tij a'sutuo'guom, el'ta'jig na Simon aq Antle' wiguaq. Ji'mej aq Sa'n wije'wa'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon ugjugwiji'tl gesnugwalitl. Epsimgeweia'silitl aq 'npo'qonigtug elisinnitl. Se'sus elieteg na'te'l, telimut na gisigui'sgwal gesnugwalitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Se'sus nat nmiatl aq ugpitn wesua'tuaj aq apoqonmuatl gama'silin. Smtug na epsimgewei ejigla's'geg aq gisigui'sgw poqji lugowaji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ta'n tujiw na'gu'set gi's galgwasieteg aq atlasmutigisg'g gaqiaq, etna na tujiw mimajuinu'g Se'suseg pegisula'tiji ta'n tegeni gesnugutiliji aq ta'n te'sijig mn'tu'g wesgweiagwi'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na 'ms't mimajuinu'g gutang tle'g etl mawiejig igantug wen'ji'guomg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Se'sus nepilaji pugwenniji aq ta'n mn'tu'g wesgweiagwi'tiji na Se'sus getaqqatesguaji mn'tu'g. Mo mn'tu'g ignmuagwi glusultinew muta nena'tipnn Se'sus ta'n wenin. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na ge'sg egsitpu'g, ge's mu gisapnianug, Se'sus menja'sit aq naqt'g, naji a'sutmat ta'n taqawatteg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tel gneg Simon ap igtigig musuala'titl Se'susal aq poqji gwilua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ta'n tujiw we'jia'titeg, Se'susal telima'titl, “'Ms't wen al gwilasg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Gatu Se'sus asitemaji, “Ge' el'ta'nej igtigl gutanji'tl ta'n tepaw etegl. Amujpa naji gina'muei elg na'te'l, muta etna na ugjit weji pgisinap.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Na nugu ala'sit ta'n telgi'g Galali al gina'muet ta'n te's'gl a'sutuo'guoml aq mn'tu'g getaqqatesguaji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Etna na ula ji'nm, geggung melgignaq 'gsnugowaqan, teluisig leplsi. Ula ji'nm elietl Se'susal, el nutgul'pa'sitl, aq etawaqtmuatl Se'susal apoqonmagun. Teluet, “Ge' gisi npilites gi'l tli ul'te'tmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Se'sus ewlitelmatl aq sama'latl. Asitematl, “E'e getu npilul, gisi npilul nige'!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Smtug, ejigla's'g 'gsnugowaqan ula ji'nm ugtinneg, aq smtug gisi npisitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Se'sus melgimatl ta'n tla'tegelital. ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Telimatl, “Jigs'tui, mut wen tlimaw. Smtug lia nat nmi patlia'sg. Negm angamulij, aq ignmu ta'n goqwe'l Mowiso'q gelug'p 'tplutaqanigtug glaman mimajuinu'g 'gji'tutaq, ta'n teli ila'sin nige'.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Gatu ji'nm ejigla'sit aq se'sa'toq na agnutmaqan 'ms't tami. Tetuji ma'muniw usgutg, ula ji'nm, ta'n teli ila'sij, na Se'sus mo gisi pisgwa'wg gutang mimajuinuigtug muta pugwelgig mimajuinu'g peita'liji. Awna eig ta'n taqawatteg. 'Ms't tami pugwelgig mimajuinu'g weita'jig ta'n negm eig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ta'suguna'gweg Se'sus apaja'sit umutgig teluisig Gapelniam. Na glusuaqan se'sa's'g. Teluejig, “Se'sus pegising.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pugwelgig mimajuinu'g peita'jig newgtsiniw Se'suseg. Na wajuignetesg wen'ji'guom aq je me' gaqamultijig gujmug ga'qanigtug. Na Se'sus mimajuinu'g gegina'muaji ugjit Nisgamal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ta'sijig mimajuinu'g peita'jig, pegisula'titl ji'nmul mo gis maja'siligul. Ne'wijig negmow pemapila'titl, elisilitl a'su'nigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Na wegla ji'nmug mo gis gigjita'gwi'gw Se'suseg muta 'nnim pugwelg mimajuinu'g. Soqwita'jig g'p'taq wen'ji'guom aq pewja'tu'tij mesgi'g elmalqei. Na tujiw wet nispila'titl ji'nmul ta'n elisinnij a'su'nigtug tegpaqiw epune'g na ta'n Se'sus eig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Se'sus nemituaj ta'n tel melgi gtlams'tasultilij, telimatl na ji'nmul gesnugwalitl, “Gwi's, apigsigtmulan 'gtlue'uti'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Etna na na'te'l ta'sijig nujigina'mua'tijig 'tplutaqan pemgopultijig. Teli angita'sultijig uggamlamunuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mu na tlewistuis na ula ji'nm muta telewistoq 'st'ge' Gjinisgam. Mo eimu'ti'gw mimajuinu'g ta'n gisi apigsigtultal 'gtlue'uti'l, pas'g newgte'jit, na negm Gjinisgam, apigsigtultal 'gtlue'uti'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Smtug Se'sus geitoqop ta'n teli angita'sultilij aq telimaji, “Taltegl ta gilew 'gtangita'suaqamual? ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Etna naqamase'g telimg na ji'nm gesnugwat, ‘'Gtlue'uti'l apigsigtmulan,’ muta mo nemituoq gis tlian. Pas'g me' metue'g telimg, ‘Mnja'si, 'gsua'tu 'gta'su'nm aq pmia.’ Muta nemituoq gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ni'n musga'tultoqs'p na tujiw ni'n na ula ji'nm ta'n mimajuinualsip. Ml'gigno'ti geggunm ugs'tqamu gisi apigsigtmn elue'uti'l.” Telimatl na gesnugwalitl ji'nmul mo gisi maja'siligw, ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Telimul gi'l, mnja'si, unaqa'tu 'gta'su'nm aq nige' gisinmietes!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na smtug na ji'nm tela'teget ta'n Se'susal telimtl. Ge's mimajuinu'g elapulti'tij ji'nmul wenaqa'silitl aq weji maja'silitaq. Na 'ms't nemia'titl sigta paqalaiultijig aq miwatmua'titl Gjinisgaml, teluejig. “Menaq goqwei nemitu'tiwgw na teliaq 'st'ge' nige'.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tel'gne'g Se'sus ap pem tajiga'sit sitmug qospem teluisig Galali. Na pugwelgig mimajuinu'g peita'jig aq gegina'muaji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na tujiw Se'sus weji maja'siteg, ge's pem siawa'sit nemiatl ji'nmul teluisilitl Li'pai, na Alpius uggwisl aq nujintutmalitl g'pnno'lewei suliewei. Li'pai pemgopit ta'n i' tl lugwet. Se'sus telimatl, “Majulgwali ni'n.” Li'pai wenaqa'sit aq smtug majulgwalatl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na teliaq Li'pai pipanimatl Se'susal mawatalultinew wiguaq aq maw unaqapemg. Etna na pugwelgig ta'nig alulgwala'tipnn Se'susal, nujintutma'tijig aq maw elue'winu'g, aq mawatalultijig Se'susal Li'pai wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ta'sijig nujigina'mua'tijig 'tplutaqan, na Palasiaq, nemia'titl Se'susal mawatalultiliji nujintutma'tiliji aq elue'winu'g. Na tujiw pipanima'tiji Se'sus unaqapemg, “Tal gis Se'sus mawatalultilijig na nujintutma'tiliji aq elue'winu'g?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Se'sus nutuateg aq teli asitemaji, “Na mimajuinu'g ta'nig tajigo'ltijig mo puala'tigul malpale'wilitl pas'g wegla gesnugu'tijig. Weji pgisinap pas'g tliman elue'winu'g, ‘Gawasgita'sultigw aq jiglita'qw elue'utigtug,’ mo ta'nig tel'ta'sultijig getlamia'tijig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na newgtejgeg Sa'n Nutsign'tuet aq Palasiaq unaqapemuaq newgt sune'ultijig. Alt mimajuinu'g el'ta'jig Se'suseg aq pipanima'titl, “Sa'n Nutsign'tuet aq Palasiaq unaqapemuaq sune'ultijig. Goqwei ugjit gnaqapemg mo gis sune'ulti'gw?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Se'sus asita'puguet, “Mo tel'ta'siwn elien malie'uti, ma mijjuaqan pmianug. Mo gis tlianug na! Ta'n ji'nm malie'wit eig na'te'l, ma sune'ulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gatu na'gweg iga'q ta'n tujiw ji'nm malie'wit ejigla'luj na'te'l. Etna na na'gweg iga'q ta'n suneultitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mo wen e'wmug pilegn ugjit 'msni'smn sa'qawe'l utapsunn. Pa na wen tla'tege's'p toqo pilegn seioqwa'toq me' 'ms'gi'gt'tew elmalqei. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mo wen elguta'tug's pilei moqopa'q, ta'n piwie'wasit m'gegnei moqopa'qo'q. Pa na tla'tege's'p, na moqopa'q, ta'n pa tujiw atejoqoq poqtapu'teg suisga's'gt'tew m'gegnei moqopa'qo'q, aq na moqopa'q gutajuitew aq m'gegnei mo tali ugtapsuniw. Moqwa, ma' gis tlianug! Pilei moqopa'q ta'n atejoqoq poqtapu'teg, amujpa e'watal pile'l m'gegne'l moqopa'qo'q!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na teliaqas atlasmutigisg'g Se'sus aq unaqapemg pemita'jig awgti'jigtug aq wet saputita'jig ta'n gulumgl etl nigwegl. Na unaqapemg gulumgl poqji tematpo'tu'titl aq malqotmi'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na Palasiaq nemia'titeg, telima'titl Se'susal, “Ge' lapa'si, negla gnaqapemg sewisga'tu'tij ginu 'tplutaqanminu. Mu na tla'taqatiwi'tis atlasmutigisg'g!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Se'sus asita'puguet, “Amuj gis gilew egitmoq ta'n Ta'pito'q tela'tegepnaq ta'n Apiataloq na espe'g patlia's. Etna na tujiw Ta'pit aq unaqapemg gewisulti'titeg aq nuta'ma'titeg, mo geggunmi'tigup ta'n goqwei malqottaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Na pisgwita'pnig wen'ji'guom Nisgamewei aq Apiatalal ignmapni na pipnaqan gisi ignmut'p Gjinisgam. Na ta'n telgitas'g ula ginuewei tplutaqan pas'g na patlia'sg gis malqotmi'tij ula pipnaqan, gatu Ta'pit malqotg's aq we'gaw ignmuasni unaqapemg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Se'sus teluet, “Gjinisgam telimapni mimajuinu'g ta'n goqwei tela'taqatilita atlasmutigisg'g, glaman mimajuinu'g ma luguti'gw pas'g atlasmultitaq aq emtoqwalataq Nisgaml. Mo wet tlimugsi'gup ugjit pugwelgl 'tplutaqann iga'tun gisna gitnme'ugsinenu.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Se'sus teluet, “Ni'n assusuti geggunm aq gis tlima's mimajuinu'g ta'n gis tla'taqatitaq we'gaw atlasmutigisg'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na tujiw Se'sus apaja'sit a'sutuo'guomg. Na'te'l eig's ji'nm malig ugpitn. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Maw eig'snig na'te'l mimajuinu'g teluisultijig Palasiaq, ta'nig getu pisui ilsutmua'titl Se'susal opla'tegelin. Na gigjipugutua'titl etug 'npilatal wenn atlasmutigisg'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Se'sus telimatl ji'nmul malig ugpitn, “Ula lia tet igantug!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Na tujiw pipanimaji mimajuinu'g na Palasiaq, “Talamu'g 'tplutaqanminu ula atlasmutigisg'g? Awna apoqonmuan wen, gisna asgaiwan, awna ugs'tawian mimajuinu, gisna ne'pa'n?” Na negmow 'lpa mo gis talue'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Se'sus angamaji aq taqala'laji aq asgaiaji muta melgasultiliji aq opla'taqatiliji pas'g na ap ewlite'lmuaji. Na tujiw telimatl ji'nmul, “Jugwasga'tu 'gpitn.” Na ji'nm elasga'toq ugpitn aq smtug apaji ila's'geg ap. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Na Palasiaq naqtmi'tij a'sutuo'guom aq smtug mawagnutma'tijig Elot unaqapemg. Ilsutaqatijig ta'n tla'lataq Se'susal ta'n tl ne'pa'taq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Se'sus aq unaqapemg naqtmi'tij aq el'ta'jig qospem teluisig Galali, aq pugwelgig mimajuinu'g majulgwalji. Weita'jig Galali, Jutia, ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Selusalem, Itumia, qame'g sipug Jol'tan, Tail, aq Saiton. Nat nemia'titl Se'susal muta gis nutmajig ta'n goqwei gis tla'tegelitl aq ta'n tel pugwenniji mimajuinu'g gisi npilaji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tel pugwelg'snig mimajuinu'g Se'sus telimaji unaqapemg, “Iga'tug 'gtulnu gigjiw sitmug. Tel pugwelg'snig mimajuinu'g etug jel ugsmguitaq. Na ta'n tujiw ugsmgui'tij tepa'sites 'gtulnaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Se'sus gisi npilaji pugwenniji mimajuinu'g aq 'ms't ta'n te'sijig getu npisultijig, amujpa na gi'gajigji'jita'jig mimajuinuigtug glaman Se'susal gis sama'lata. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ta'n tujiw mimajuinu ta'n mn'tu ugtinneg eimlij pegising Se'suseg mn'tu nisegetl ta'n gaqamilij aq sesgwet, “Gi'l na Gjinisgam uggwisl!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Te's newgte'jilitl, Se'sus melgimatl wegla mn'tu'l, “Mut wen tlimaw ta'n weni ni'n!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Na Se'sus eliet soqoqamigeg aq wigumaji ta'n weni pualaji majulgwalgun aq tepgisita'jig igtigig mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na tujiw newgtisgegsiliji je ta'pu megnaji. Na wisungewaji, ugtapostale'witemg. Aq telimaji, “Ni'n megnuloqop ugjit wijitgweiwinew. Poqjigimultoqs'p ugjit al gina'mua'tinew, ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","aq ignmultoqs'p ml'gigno'ti ugjit 'gtaqqatesguanew mn'tu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Etna na wegla newgtisgegsiliji je ta'pu gisi mgnaji: Simonal, Se'sus wisungewatl Pie'l, ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ji'mejal aq Sa'nal na wijigatijig gitg na Sepeti uggwisg. Se'sus wisungewaji Poanelgis. Na telueg tel jaqali uggwain aq teli gsigawen pa na wijei aq gaqtugwaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ala igtigi na Antle'al, Pilipal, Pattolomiwal, Matiwal, Tumaal, Ji'mejal, na Alpius uggwisl, Tatiasal aq Simonal na Genaewa'j, ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","aq Sutaal Isgaliotal, etna na negm me' enmiaq 'ntuisgetutal Se'susal aq ne'po'qsilital. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na tujiw Se'sus pisgwa't ta'n i' tli usgowa'sij. Na pugwelgig mimajuinu'g mawita'jig aq ap gigto'qopitua'titl Se'susal, glaman Se'sus aq unaqapemg mu gis mijjulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na Se'sus wigumaq tels'tma'tiliji, “Se'sus elue'wiet.”, aq el'ta'jig aq getu nemisgua'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Eimu'tijig na'te'l alt nujigina'mua'tijig tplutaqan ta'nig weita'jig Selusalemg. Wegla teluejig, “Na Gjimn'tu teluisit Pe'lsepal pitu'gwitl Se'susal.” Igtigig tel agnima'tipnn Se'susal, “Na iganpuguit mn'tu ignmuatl Se'susal ml'gigno'ti 'gtaqqatesguan igtigig mn'tu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Se'sus wigumaji mimajuinu'g aq gegnua'tuaji, “Tal gisi gtaqqatesga'sitew Gjimn'tu? ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Etug elege'witewa'gi nasgwiaq, tepgisita'tij aq matntulti'tij ala wen ap igtig. Na toqo tujiw na elege'witewa'gi seioqwietew aq nigtua's'gt'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Gatu etug wigumaq nasgwie'tij, tepgisita'tij aq matntulti'tij ala wen ap igtig. Na mimajuinu'g apugjig seioqwia'titaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Toqosip pa na wijei Gjimn'tu ugtelege'wa'gimg tepgisita'tij aq matntulti'tis ma 'pgitpuguinug amujpa seioqwia'titaq aq na tl gaqietew na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ma wen gis gi'gattesguagul melgigna'litl ji'nmul wiguaq aq jigla'tuagul ta'n goqwe'l negmewe'l. Amujpa gelpilatl melgign'alitl ji'nmul tmg glaman ta'n goqwe'l etegl wiguaq gis gmutnattew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Migwite'tmug ula! Gjinisgam apigsigtuatal mimajuinu'l ta'n tel gaqaisg milamu'gl ugtlue'uti'l aq winjigl ta'n goqwe'l teluelitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pas'g na mimajuinu ta'n teluej winjigl ta'n goqwe'l getanatl Wejuli Nisgaml, na telamu'g elue'uti mo gisi apigsigtas'gtnug. Me' negm na ma'muniw opla'teget, iapjiwewei elue'uti.” ( ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Se'sus telimaji muta alt teluelipni, “Mn'tu'l pitu'gwitl.”) ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na tujiw Se'sus uggwitl aq ugjignamg peita'liji. Na etli esgmala'titl gujmug ula wi'g ta'n Se'susal eimlitl, aq elgitmi'tij glusuaqan ugjit Se'susal tu'elin. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pugwelgig mimajuinu'g gigtoqopitua'titl aq telima'titl, “Ge' lapa'si, 'ggij aq wijigumjig gujmug eigig. Pual'sgig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Se'sus telimaji, “Gnua'tultoqs'p ta'n wen ni'n 'ngij aq 'njignamg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Se'sus gigto'qoapa'sit ta'nig mimajuinu'g pemgopultiliji aq telimaji, “Ge' lapita'gw, pa wijei aq nige' gilew na 'ngij aq 'njignamg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ta'n pas'g tegen mimajuinu tela'teget ta'n Gjinisgam tel pualaj na negm pa wijei aq wijigumjig aq 'ngij.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Se'sus ap poqji gina'muet gigjiw qospemg teluisig Galali. 'Nnim pugwelg mimajuinu'g gigto'qopugutaji glapis Se'sus eliet ugtuluaq aq tepa'sit. Na gijga mnawa'sit aq siaw gina'muet. Na mimajuinu'g siawqatmu'tijig sitmug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tel gina'muaji pugwelgl ta'n goqwe'l, a'tugwaqann e'w'gl. Na tel gina'muaji aq telimaji, ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Jigs'tmu'tigw! Nuji iga'taqug eig'p ta'n se'sijio'toqol 'sginminn. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ge's etl se'sijio'toqol 'sginminn, eljo'ltigl awgti'jigtug, sisipji'jg peita'jig aq malgotmi'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Alt 'sginminn eljo'ltigl na maqamigew ta'n wesgijigweg 'mtasoqigtug. Na maqamigew jaqal p'teg aq 'sginminn jaqali sgaliaqal aq jaqal ne'igwegl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Na na'gu'set mesp'siteg, ta'n wejgwisgaliaqul na gaqs'gl, muta na ugjip'sgl mo gis piam teminugul, ta'n teli iga'taqug, glaman na 'sginminn gispategl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Alt 'sginminn eljo'ltigl ginigwejijuaqsigtug. Me' gesigaw nigwejig ginigwejijuaqsi'g, je mu gulumgl ta'n tel nigwegl. Na gulumgl mo wel nigwenugl, aq mo mininugul. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ap igtigl 'sginminn eljo'ltigl gelu'lg maqamigew. Na weli sgaliaqal aq wel nigwegl aq wel minigl, pugwelgl ugjit newgte' 'sginmin. Alt eimu'tigl nesisga'qal ugjit newgte' 'sginmin, aq alt eimu'tigl asugomtesisga'qal ugjit newgte' 'sginmin, ap igtigl gasgiptnnaqanigl ugjit newgte'.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Se'sus teluet, “'Gs'tuaqanultioq ugjit nutmu'tinew na jigs'tmu'tigw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na Se'sus newgtamsiteg, na newgtisgegsiliji je ta'pu unaqapemg aq maw igtigi majulgwalgwi'titl Se'sus, peita'liji aq pipanimji, “Ge' gnua'tuin giasgiwewei ta'n telueg na a'tugwaqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Se'sus asitemaji, “Gjinisgam nige' gilew gisi musga'tugsioq ta'n goqwei sa'q mo geitas'gtnugup aq mo nestasultiwoqop ta'n goqwe'l Nisgamewe'l. Pas'g ta'nig igtigig nutmataq amujpa negmow a'tugowaten. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Glaman ta'n goqwei Gjinisgam ugtwi'gatigng ewi'gas'g na tliatew, ‘Elapultijig. Gaqaisg nemitu'tij pas'g mo goqwei geitu'ti'gw ta'n goqwei nemitu'tij. Nutmi'tij pas'g mo nestasulti'gw ta'n goqwei nutmi'tij. Pa na 'gji'tu'tij aq ns'tmu'ti'tij na tujiw gtlams'tasultitaq, gawasgita'sultitaq aq 'lta'taq Nisgamewigtug. Na tujiw Gjinisgam apigsigtmuata ugtlue'utiwal.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na tujiw Se'sus pipanimaji, “Mo ns'tasultiwoq ula a'tugwaqan? Etug jel ma 'ns'tasultiwoq ta'n pas'g tegen a'tugwaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ula nuji iga'taqug pa na wijei aq ta'n wen se'sa'toq Gjinisgam ugglusuwaqanm mimajuinuigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Na alt mimajuinu'g, pa na wijei aq awgti'j, ta'n 'sginminn eljaqal. Na Gjinisgam ugglusuwaqanm eljaq. Ula mimajuinu'g nutmi'titeg ula gelu'lg glusuaqan, na smtug Gjimn'tu gisa'laji mimajuinu'g awan'ta'sultinew gelu'lg glusuaqan, gis nutmi'titeg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Igtigig mimajuinu'g 'st'ge' na maqamigew ta'n wesgijigweg 'mtasoqigtug ta'n 'sginminn eljaqal. Ta'n tujiw nutmi'titeg wel'ta'suatmi'tij aq getlams'tmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Melgugtmi'tip mujga amgwes pas'g mo gisi pgiji gugunmi'tigup. Teli ul lugutipnig pas'g ta'n tujiw metue'g welgmi'titeg ugjit Gjinisgam ugglusuaqanm newgtsiniw elege'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Igtigig mimajuinu'g 'st'ge' na maqamigew ta'n 'sginminn eljaqal ginigwejijuaqsigtug. Ula mimajuinu'g nutmi'tij gelu'lg glusuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pas'g te'sigisg'g ta'n tel mimajij aq me' piamite'tmi'tij suliewei aq pugwelgl ta'n goqwe'l pewatmi'titl, tel piamite'tmi'tij 'ms't goqwei, je mu migwite'tmi'ti'gw Gjinisgam ugglusuwaqanm. Glaman mo tela'taqati'gw ta'n goqwei Gjinisgam tel puatg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pas'g igtigig mimajuinu'g 'st'ge' na gelu'lg maqamigew ta'n 'sginminn eljaqal. Negmow nutmi'titeg gelu'lg glusuaqan aq gennmi'tij uggamlamunuaq. Tela'taqatijig ta'n Gjinisgam ugglusuaqanm telueg. Ta'n tel piam tla'taqati'tij Gjinisgam ugglusuaqanm tel piam se'sa's'g aq me' pugwelg mimajuinu'g getlams'tasultijig. We'gaw, alt nesisgegsiliji, alt asugomte'sisgegsiliji, ap igtigig we'gaw gasgiptnnaqaniliji.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na Se'sus siawewistoq, “Etug nat wen wesua'toq lamp aq iga'toq lame'g ligpenignigtug, gisna lame'g 'npo'qonigtug? Moqwa'! Amujpa na iga'toq p'ta'utigtug glaman 'ms't wen gis nmitegetew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta'n goqwei mimgwa'tas'g amujpa neia's'gt'tew aq ta'n goqwei anguna's'g amujpa panwijgatas'gt'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","'Gs'tuaqanultioq ugjit nutmu'tinew. Na jigs'tmu'tigw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na tujiw telimaji, “Gnnamug ggamlamunuaq ta'n goqwei gis tlimuloq. Mut awan'ta'sultinew tla'taqatitoqs'p ta'n goqwei gis nutmu'tioq ta'n tel piam tela'taqatioq na tl piam 'ns'tasultitoqs'p, ta'n goqwei telimuloqop. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Na mimajuinu ta'n tela'teget ta'n gis tlimg, na toqo tujiw me' uli ns'tasitew gatu mu tla'tegegw, gaq awantasuattew ta'n goqwei nutg'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Se'sus teluet, “Ula na igtig a'tugwaqan wijei teli angamgug Gjinisgam ugtelege'wa'gimg 'st'ge' nige' ula. Na ji'nm se'sijio'toqol 'sginminn iga'taqanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Geitoq na siawigwegl tlia mu negm i'mug, piluei lugowaqan elugwatg, na'gweg aq wela'gw nepat. Pa na wijei ula 'sginminn teli uli sgaliaqal, poqjigwegl aq wel nigwegl. Ula ji'nm mo nestasigw ta'n Gjinisgam tel'te'tg tli uligwen. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na maqamigew gisa'toqol 'sginminn nigwen. Amgwesewei weli sgaliaqal aq poqji ne'igwegl aq tetuji uligwegl. Na ula gulumgl wel gis lastegl aq wel minigl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ta'n tujiw gulumgl gaqigweg, ji'nm poqji tms'gl 'psgwesoqonigtug muta mena'taqug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Se'sus siawewistoq, “Gnua'tultoqs'p ta'n telamu'g Gjinisgam ugtelege'witewa'gimg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pa na wijei aq mustate' sginmin ta'n ji'nm iga'taqatg maqamigewigtug, na mawi apje'ji'j 'sginmin ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Na tujiw 'sginmin wejgu ne'igweg aq enmigweg glapis pitoqigweg. Na ta'n mawgi'g te's'g mijipjewei, etna na ula. Ta'n tel piami uligweg, ula mustate' 'sginmin, we'gaw, sisipji'jg gisi iga'tu'titl ugwise'jmual nipispaqanigtug, etliaqjigateg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na Se'sus tel gina'muaji mimajuinu'g na gelu'lg glusuaqan. Pugwelgl a'tugwaqan e'w'gl 'st'ge' wegla. Telimaji ta'n te's'gl negmow gisi ns'tmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mo gelulagwi glapis e'w'g a'tugwaqan, gatu ta'n tujiw newgtamsulti'titeg, maw unaqapemg, negmow gegnua'tuaji 'ms't goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na enmiula'qweg Se'sus telimaji unaqapemg, “Asoqomita'nej qospem.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Na unaqapemg naqala'tiji pugwenniji mimajuinu'g aq tepita'jig ugtuluaq ta'n Se'sus gis teppip. Smtug poqji asoqomisugultiji aq igtigl ugtulual wije'wa'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Se'sus ugtejg eig, nepat un'ji ge'guteg tu'gwesmunigtug. Ugju'sn poqji ml'gignewa's'g aq poqji mqatgwig. 'Tgu'g poqji tepapaqtesingig ugtuluaq. Poqji mamuni pega's'g ugtuluow. Unaqapemg jipaqita'liji, Se'susal tugwa'la'titl, aq telima'titl, “Nujigina'muet, mo tali el'telmiweg? Getu' geget getapaqto'gu'ti'gw?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Se'sus gaqama'sit aq telimatl ugju'sn, “Wantaqa'si!” aq telimaji 'tgu'g, “Wantaqita'qw!” Na smtug ugju'sn wantaqa's'g aq 'tgu'g wantaqita'jig aq weli ewipgeg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Se'sus pipanimaji, “Goqwei ta gilew jipatmoq? Ta gilew me' mu sangewite'lmiwoq?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Paqsipgi jipaqita'jig, suel sigtata'sultijig aq poqji pipanimtultijig, “Wen ta u't ji'nm, tetuji piam jigs'taji ugju'sn aq tgu'g?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Se'sus aq unaqapemg oqwa'jig ase'g qospem ta'n wigultijig Gelasiewaq. (Negla mimajuinu'g gun'tew sapalqe'g lame'g etli utqutala'tiji npuinu'g.) ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Etna na ula ji'nm ta'n mn'tu pitu'gwitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wigit ula i' tli utqutala'tiji gun'tew sapalqe'g. Mu nugu gis gltaqpila'tigul tlia pisgataqanapi'l e'wmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gaqaisg uggwatl aq ugpitn gelpilmutl, pas'g na te's pasga'to'qol pisgataqanapi'l aq pasga'toqol gasawo'qol na uggwatg. Tetuji melgignat, mo gis gnna'tigul na ji'nmul. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tepgig aq na'gweg ala'sit utqutaqane'gati aq siawa'sit soqoqamigeg. Alisewet aq gun'tal ginigwegl e'w'gl, sewissusij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na ji'nm gneg wetamatl Se'susal. Na el'tugwi'g aq el nutgul'pa'sitl Se'susal ta'n tujiw gisi pta'siliteg ugtuluaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","I' sesgwet, “Se'sus, gi'l, na uggwisl ta'n mawi espe'g Gjinisgam, getu tala'lin ni'n? Gjinisgam ewlite'lmi! Se'sus, etawaqtmul mut ugtapuliw ni'n!” ( ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wet tlues na muta Se'sus etl tlimatl, “Mn'tu, 'gtaqqa'si na ji'nm!”) ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Toqo Se'sus pipanimatl, “Taluisin?” Na ji'nm asita'puguet, “Teluisi Lijion, muta tel pugweleg.” (Lijion na telueg, na'tami asugom pituiptnnaqanijig.) ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Siaw tawaqtmuatl Se'susal ugjit mu mn'tu'g jiglgimugsinew na'te'l na maqamigew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pugwelgig eig'snig gulgwi'sg gigjiw na'te'l. Etl jiganiga'tijig soqoqamigeg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Na mn'tu'g etawaqtmua'titl Se'susal, “Petgiminen ninen negla gulgwi'sg ta'n wesgowita'tij. Ignmuinen na'te'l lta'nen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na ignmuaji. Mn'tu'g getaqqita'la'titl ji'nmul, aq el'ta'jig gulgwi'suigtug pijitalijig. Na ta'n te'sijig gulgwi'sg panaemg ta'pu pituiptnnaqanijig maw 'ms't paqatugultijig paqse'g, aq egwijia'tijig aq getmentgi'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na ji'nmug ta'nig etli angweiwatipni gulgwi'sg, poqt'tugu'ltijig se'sa'tu'tij agnutmaqan gutanji'tl aq 'ms't tami ta'n el'ta'tij. Na mimajuinu'g ta'n nutma'ti'tij, nat nemitu'tij ta'n gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Peita'jig ta'n Se'susal eimlij aq nat nemia'titl na ji'nmul ta'n i' pitu'gwipni mn'tu'g. Negm pemgopit na'te'l gegnesit aq apaji ns'tuesnaq. 'Ms't ta'n te'sijig jipasultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na ji'nmug, ta'n tujiw gis nemia'tipnn ji'nmul, ta'n gisi npisilipnn, aq gis nemia'tipni gulgwi'sg, paqasutugultilipni, aq getmenepnig, telima'tiji mimajuinu'g, ta'n goqwei gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Na tujiw wegla mimajuinu'g etawaqtmua'titl Se'susal jigla'silin uggutanmuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ge's Se'sus pem tepa'siteg ugtuluaq na ji'nmul ta'n eimu'tilipni mn'tu'g etawaqtmuatl Se'susal, “Ge' ignmui wije'ulin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pas'g na Se'sus mo ignmuagul, awna telimatl, “Apaja'si giguaq, aq gigmaq, aq tlim ta'n teli ula'l'sg's na Saqamaw, aq ta'n teli ulm'toqos ugjit gi'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Na tujiw ji'nm naqt'g, aq eliet 'ms't ta'n te's'gl newgtisga'qal gutanji'tl, telimaji ta'n Se'sus tela'l'pnn ugjit negm, aq ta'n te'sit wen nutg, paqalaig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Se'sus apaji asoqoma'sit qospem. Na'te'l pugwelgig mimajuinu'g gigto'qopugutua'titl sitmug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jailus, newgte'jit iganpuguit na Lesui'pewei a'sutuo'guom negmow uggutanmuoq. Pegising aq ta'n tujiw Se'susal nemiatl nutgul'pa'sitl Se'susal uggwatg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Aq etawaqtmuatl ta'n telgi'g pegwatoq, “Ni'n 'ntusji'j mawi gsnugwat geget nepg. Ewlistui! Jugu'a! Wije'wi nignaq aq iga'tug gitg 'gpitnn 'ntusg glaman ila'sitew aq siaw mimajitew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Toqo Se'sus wije'watl. Maw pugwelgig mimajuinu'g wije'wa'titl aq aligsma'la'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ula e'pit eig's pejuije'wa'pni. Pegiji ulmaje'g's aq metuipnes ta'n metlasipunqeg je ta'pu, na teli pgiji msigwet ugsngowaqanm. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Pugwelgig mal'pale'wijig mo gisi 'npila'tigul. Ta'n te's'g ugsulieweim gaqi e'w'g pas'g na mo aji mewiewigw awna me' aji gsnugwat. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Na nutmatl Se'susal aq elietl maw wije'waji mimajuinu'g. Nige' gaqamit ugtejg Se'suseg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Telimsit, “Pas'g ni'n gis sama'taq utapsun, na ni'n ila'sites.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Gis sama'tuateg utapsun aq smtug nenga's'g ta'n teli msigwap ugsngowaqanmeg aq negm geitoq gis ila'sit aq gisi npisitaq ta'n sa'q 'lgowaqana'l'tpneg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Smtug Se'sus geitoq ml'gigno'ti ta'n teli ila'silij ejigla's'g negmeg aq gawasg'pugua'sit aq telimaji ula mimajuinu'g, “Wen gis sama'toqol nutapsunn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Unaqapemg telima'titl, “Nemi'jig na mimajuinu'g gigto'qopugutasgig! Tal gis pipanigesin, ta'n wen gis sama'l'sg?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Gatu Se'sus tel gigtoqopa'sit wet nemiatl ta'n wenn gis tela'tegelitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na e'pit geitoq ta'n gis tliaq ugjit negm. Smtug jipaqa'sit aq neng'tesing. El nutgul'pa'sitl Se'susal uggwatg aq telimatl 'ms't ta'n gigwajiaqewei gis tliaq ugjit negm. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Se'sus telimatl e'pilitl, “Tu's, gi'l ta'n teli gtlams'tasin, na wej gisi npisin. Gisinmietes nige', muta ila'sineg. Ejigla's'geg ta'n tel gitnma't'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ge's Se'sus etlewistoq na ji'nmug pegisingig weja'tijig Jailus wiguaq aq telima'titl, “Jailus, 'gtusaq nepgaq. Mut nugu 'lgowaqana'law nujigina'muet.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Se'sus gesgustuaji ta'n telueliji, telimatl iganpuguilitl a'sutuo'guomg, “Mut jipasiw pas'g 'gtlams'tasi! Sangewitelmi!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mo ignmuagul wenn wije'ugun pas'g Pie'lal, Ji'mejal aq Sa'nal, na Ji'mej wijigati'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Peita'jig iganpuguilitl wi'g. Se'sus nemiaji pugwenniji sespo'ltiliji aq atgitemultiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na Se'sus pisgwa't pipanimaji, “Goqwei tal gis sespena'q aq atgitemultioq? E'pite'ji'j mo nepmug pas'g nepat.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na mimajuinu'g poqji wiguama'titl Se'susal gatu gaqtuaqqimaji. Na tujiw wesua'latl na e'pite'ji'j ujjl aq uggwitl aq ta'n weni nesisiliji ta'n wijeiujig aq el'ta'jig ase'g ta'n e'pite'ji'tl eimlij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Se'sus wesua'tuaq ugpitn aq telimatl, “Tu'si mnja'si!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ula e'pite'ji'j metlasipuna't je ta'pu. Se'sus gisi npilatl aq smtug ula e'pite'ji'j wenaqa'sit aq poqji ala'sit. Ta'n tujiw na gis tliaq mawi paqsipgi paqalaiultijig mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Se'sus maw melgimaji na, “Mut wen tlimanew.” Aq telimaji, “Smug na e'pite'ji'j!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Se'sus naqt'g na gutan aq apaja'sit umutgig maw unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na atlasmutigisgug Se'sus etl gina'muet a'sutuo'guomg. Pugwelgig eimu'tipnig mimajuinu'g. 'Ms't gaq paqalaiultijig nutua'titeg. Pipanimtultijig, “Tami weja'toq telgi'g gina'masuti aq tetuji ns'tuewistoq ta'n tel gina'muej? Tal gis tli milinpiteget aq talgi'g tela'tegetl pugwelgl ta'n menaq goqwe'l nemitu'ti'gw na telianug 'st'ge' nige'? ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pas'g na aluse'witewinu na Mali uggwisl! Ugjignamg etna na ula Ji'mej, Josi, Suta, aq Simon. Uggwe'ji'jg wigultiliji ula tet.” Na smtug mo menuege'tigul Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Se'sus telimaji, “'Lpa 'ms't tami gepmite'lmut iganigjitegewinu pas'g mo puatasigw umutgig we'gaw wo'qomaq aq witapaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Mesgi'g's ta'n tel paqalai'g muta mimajuinu'g na'te'l mo getlams'tua'tigusnn. Mo gis tla'tegegusnn ta'n goqwe'l wejiaqal Nisgamewigtug na'te'l, pas'g iga'toqosn ugpitn ta'siliji mimajuinu'g gesnugu'tiliji. Negla nepilasni. Na Se'sus eliet ta'n te's'gl gutanji'tl aq egina'muet. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Newgtsiniw na wigumaji unaqapemg. Na tujiw i' tapusiliji tewaqqimaji. Ml'gigno'ti ignmuaji ugjit 'gtaqqatesguanew mn'tu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Se'sus melgimaji, “'Lpa na mut goqwei nespnmnew. Mut pipnaqan nespnmnew aq mut salitewimgewei mun'ti, aq mut suliewei gugunmnew ugtaposmuaq pas'g ugtaptunmual. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nasoqtesgug gmugsnuaq, pas'g mut nespnmnew piamiaqal gutapsunual.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Se'sus me' telimaji, “Ta'n pas'g tegen te's'gl gutanji'tl pisgwa'tioq, ta'nig mimajuinu'g wigumugsioq ugjit i'mnew wiguaq, siawqatmug ula newgte' wen'ji'guom glapis naqtmoq na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Toqosip pisgwa'tioq gutanji'tl, ta'nig mimajuinu'g mo pualugsiwoq gisna mu jigs'tugsiwoq, na tujiw naqtmug na gutan aq puaqte'mug 'gpitnual. Ta'n tujiw na gis tla'tegeioq musga'tuoq, mu nugu tali el'telmawoq. Aniapsuattaq ugtlue'utiwal.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na unaqapemg maita'jig aq gegnu'tmua'tiji mimajuinu'g, “Gawasgita'gw aq jiglita'gw elue'utigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pugwenniji getaqqatesgua'tiji mn'tu'g aq pugwenniji gesnugu'tiliji mimajuinu'g, mimei amjaqta'tiji ugtugwejanuaq aq gisi npila'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na tujiw nutmateg elege'wit Elot ta'n goqwei Se'susal ta'n tela'tegelij, se'sa'gnutas'g 'ms't tami. Alt mimajuinu'g teluejig, “Sa'n Nutsign'tuet gisi apaji mimaju'et. Etna na ugjit wegla ml'gigno'ti'l wet sapu tl lugwegl negmeg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Igtigig teluejig, “Negm na Ilaija.” Ap igtigig teluejig, “Negm na iganigjitegewinu 'st'ge' negla sa'qawe'gi'g iganigjitegewinugi'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Elege'wit Elot nutmateg teluet, “'Lpa negm na Sa'n Nutsign'tuet. Ni'n telimg'p 'ntsma'gnismg temgweto'q Sa'n pas'g gisi apaji mimajuepnaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Elot toqonasijig ugjignaml Pilipal ugte'piteml na teluisilitl Elotias. Sa'n gaqaisg telimasnn Elotal, “Mo weltenug malie'winew ugjignam ugte'piteml!” Elot tewatgitg's glusuaqan ugjit ugsma'gnismg ugsua'lug Sa'n aq pija'lanew laplusang muta Sa'n gaqaisg majiaqa'lasn Elotal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ne'gaw Elotias getanatl Sa'nal aq ne'gaw gisi pgwatoq ne'po'qsilis pas'g mo gis tela'tegegw muta ugji'nmuml Elot wetqottl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Elot jipaqitelmatl Sa'nal muta geitoq Sa'n getlamiet ji'nm aq sape'wit. Etna na ugjit ne'gaw iga'latl Sa'nal. Elot wels'tuatl Sa'nal, ta'n tel gina'muelij gatu gaqaisg ma'muniw 'lgowaqana'latl te's nutuaj. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Glapis Elotias gisapsgnatl ta'n tujiw Elot ajipuna't. Na tujiw Elot iga'toq mesgi'g mijjuaqan. Wigumaji espo'ltiliji g'pnno'lewaq, espo'ltiliji sma'gnisg, aq iganpugultiliji mimajuinu'g Galaliewa'gig tle'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Elotias ugtusl pisgwa'litl aq amalgalitl. Tetapua'laji Elot aq maw 'ms't ta'nig wigumapni. Toqo Elot telimatl e'pite'sl, “Goqwei puatmn? Ni'n ignmultes ta'n pas'g goqwei gi'l puatmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Gaqaisg teplumatl aq telimatl e'pite'sl, “Ni'n teplumul, ignmultes ta'n pas'g goqwei glutmn we'gaw aqataig 'ntelege'wa'gim.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Toqo na e'pite's tewiet aq pipanimatl uggwitl, “Etug goqwei glultes?” Na uggwitl teli asitemtl, “Sa'n Nutsign'tuet un'ji.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na smtug e'pite's nenaqi apaja'sit elege'wilitl aq telimatl, “Ni'n pewalul ignmuin nige' Sa'n Nutsign'tuet un'ji eptaqanigtug!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na ula elege'wit ewlgwija'sit gatu mo goqwei gisi ugs'geltmuaq muta gis ma'muni tplumsit aq pugwenniji mimajuinu'g nutagwi'tipnn. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Na smtug elege'wit poqjigimatl sma'gnisl. Melgimatl jugwa'tagun Sa'nal un'ji. Na sma'gnis naqt'g aq eliet laplusang aq Sa'nal temgweta'tl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tel gne'g pegisituaj Sa'nal un'ji eptaqanigtug aq ignmuatl e'pite'sl ta'n siaw ignmuatl uggwitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sa'n unaqapemg nutagwi'titeg, peita'liji. Wesua'tua'tij wa'qi aq utqutala'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ugtapostale'witemg apaita'liteg aq telimgwi'titl Se'sus ta'n te's'g goqwei gis tela'taqati'tij aq ta'n tel gina'mua'ti'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Te'sijig mimajuinu'g peita'jig aq ejiglita'jig Se'suseg glapis Se'sus aq unaqapemg mo gis mijjultigupnig. Toqo Se'sus telimaji, “Ge' na'tami 'lta'nej pas'g ginu glaman gilew gijga'ji'j atlasmultitoqs'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na tujiw tepita'jig ugtuluaq pas'g negmow aq el'ta'jig ta'n etl taqawatteg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Gatu pugwelgig mimajuinu'g gesgwiama'titeg maita'liteg aq smtug nenua'tiji ta'nig weni. Na naqtmi'tij uggutanmuoq aq pemtesgmi'titl igtigl gutanji'tl aq me' pem pugweliejig igantugu'ltijig. Igan iga'jig ta'n Se'sus aq unaqapemg pemi lta'pnig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ta'n tujiw Se'sus gepta'siteg ugtuluaq nemiaji pugwenniji mimajuinu'g, aq na tujiw ewlitelmaji muta mimajuinu'g al se'sialta'liji 'st'ge' jijgluewji'jg ta'n tujiw mo wenn nuje'wagwi. Se'sus poqji gnua'tuaji pugwelgl ta'n goqwe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ta'n tujiw poqji piluamugwiaq, unaqapemg peita'liji negmeg aq telimji, “Gis nige' wel piluamugwiaq aq ula tet wel taqawatteg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ge' jiglgim mimajuinu'g glaman lta'taq tepaw nuji iga'taqug aq tepaw gutanji'tl aq nat goqwei pgwatelma'titaq ta'n tl malqottaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Toqo Se'sus asitemaji, “Ignmu nat goqwei ta'n malqottaq.” Na unaqapemg pipanima'titl, “Pualieg aji pgwatelmuanen ta'pu gasgiptnnaqana'igl tepawgtigl pipnaqann ta'n smatesnu?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Toqo Se'sus pipanimaji, “Ta's'g ta pipnaqann geggunmoq? Ge' naji gji'tug.” Ta'n tujiw gisi gji'toq telimtl, “Pas'g na'ngl pipnaqann etegl aq tapusijig nme'ji'jg epijig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na tujiw Se'sus telimaji unaqapemg, “Tlim mimajuinu'g, tepgisita'gw nasgwa'sultigw aq pita'gw ta'n etli uli msiguig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na smtug mimajuinu'g pemgopita'jig i' na'nisgegsijig aq alt i' gasgiptnnaqanijig i' mawpultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Se'sus wesua'toqol pipnaqann aq nme'ji'jg, wa'so'q elapa'sit aq miwatmuatl ujjl Gjinisgam. Toqo pasgina'toqol pipnaqann aq ignmuaji unaqapemg se'si ignmuetunew mimajuinuigtug. Nasgwa'laji tapusiliji nme'ji'jg. Tepisultijig ula negmow te'si'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","'Ms't wej g'satalultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na tujiw unaqapemg wajua'tu'tijig newgtisga'qal je ta'pu ligpenignn ta'n wejpiamiaqal na pipnaqan aq nme'ji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na'n pituiptnnaqanijig ji'nmug wej g'satalultipnig maw ugte'pitemuaq aq mijua'ji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Se'sus na smtug melgimaji unaqapemg tepita'new ugtuluaq aq igani asoqomita'new glapis na gutan Petse'ta, pe' negm enmigimaji mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na tel gneg Se'sus naqalaji unaqapemg aq eliet soqoqamigeg naji a'sutmat. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Atel wela'gwe'le'l Se'sus na'taqamtug gaqamit aq gneg wetamaji unaqapemg apaqtug ugtuluaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ge's Se'sus nemiaji unaqapemg gitnm'tiliji ta'n tel jimatmli'tij ugtuluow muta ugju'sn asugwetnma'tijig. Nige' na'tami si'st ajiet gisna asugom ajiet egsitpu'g, Se'sus eliej wesgit pmiet samqwanigtug aq getu siaw 'gtesguasni. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","'Ms't unaqapemg nemia'titl wesgit pmielitl samqwanigtug aq jipasita'jig. Tel'ta'sijig 'sg'te'gmutl aq sesgu'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Smtug Se'sus gelulaji, “Mut nugu jipasultinew! Ni'n na Se'sus! Ulgwijita'gw!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na tujiw tepa'sit ugtuluaq maw unaqapemg aq ugju'sn wantaqa's'g. Na unaqapemg sigti paqalaiultiliji aq 'st'ge' ulita'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Gatu negmow mo nestmi'tigup Se'sus ugml'gigno'tim ta'n tel gis smaj e'w'gl na'ngl pipnaqann aq tapusiliji 'nme'ji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Siawi asoqomita'jig aq oqwa'jig Genesaletg aq gelpilmi'tij ugtluow. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ge's pemi p'tita'tij ugtuluaq na mimajuinu'g smtug angam nenua'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Toqo mimajuinu'g teli altugultijig ta'n telgi'g gutanji'tl aq pegisula'tiji 'gsnugowinu'g elisultiliji ugta'su'nmuaq ta'n nutma'tij Se'susal eimlij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","'Ms't tami Se'sus eliet gutang gisna ta'n nuji iga'taqu'tilij wigultilij, na mimajuinu'g nespna'tiji gsnugowinu'g ta'n i' tli ntuisga'ti'tij aq etawaqtmua'titl Se'susal gsnugowinu'g sama'tuan utapsunm aq 'ms't ta'nig sama'tua'titl smtug ilita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ta'sijig nujigina'mua'tijig 'tplutaqan weita'pnig Selusalemg. Na tujiw wije'wa'tiji Palasiaq aq gigto'qopugutua'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na migwama'tiji te'siliji unaqapemg etlatalultiliji gatu mo gesispa'tu'tigul ugpitnual, 'st'ge' Palasiewaq tela'taqati'tij. ( ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Na Palasiaq aq esgwia'tijig Lesui'paq majulgwatmi'tij ta'n tel gina'muj aq e'wmi'tij ta'n teloqtisni ujjuaqi'g. Mo mijjulti'gw glapis gisi gsispa'tu'tis ugpitnual menaqqajewei. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mo malqotmi'ti'gw ta'n goqwei wejiaq etlintuisgetmg mijipjewei. Amujpa na tmg gesispa'toq aq majulgwatmi'tisnn pugwelgl ta'n goqwe'l tel gnu'tmuj ujjuaqi'g st'ge' ta'n tel lapala'tis me' na ulaqanmua, wowg, eptaqang, aq ugtuomua.) ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Na Palasiaq aq nujigina'mua'tijig tplutaqan telima'titl Se'susal, “Ge' angam, gnaqapemg etlatalultijig, je mu gesispa'tu'tigul ugpitnual. Mo teltenug na tla'taqatinew!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Se'sus asitemaji na teluet, “Teliaqasneg Aiseiao'q iganigji'-toqosneg ugjit gilew wesgijiangamgusultioq, 'st'ge' ta'n tel wi'gas'g, Gjinisgam teluet, ‘Ula mimajuinu'g gepmite'lmijig glusuaqanigtug pas'g uggamlamunual amastegl ni'neg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mo tali ugtapsuninug ugjit negmow emtoqwalinew muta tel gina'mujig ji'nm ugt'tplutaqanm pa na wijei tela'tu'tij 'st'ge' Gjinisgam gissutg.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Na Se'sus teluet, “Gmetug iga'tuoqol Gjinisgam ugt'tplutaqanm aq jigs'tmoqol ji'nm ugt'tplutaqanm.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Se'sus siawewistoq, “Na we'gwi ntawo'ltioq, ejigla'tuoq Gjinisgam ugt'tplutaqanm ugjit majulgwatmnew ji'nm ugt'tplutaqanml! ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mowiso'q teluepnaq, ‘Gepmite'lm gujj aq 'ggij!’ Ta'n wen teluet ugtanan ujjl gisna uggwitl, amujpa na negm ne'po't. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pas'g na tel gina'muoq ta'n mimajuinu geggung goqwei ta'n gisi apoqonmuas ujjl gisna uggwitl pas'g toqosip na teluet, ‘Ula na Golpan’ (na telueg, Gjinisgam ugtaligam). ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Na toqo tujiw, mo na tale'nug mo gisi apoqonmuawj ujjl aq uggwitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mo jigs'tmuoqol Gjinisgam ugglusuaqanml aq gisa'loqig igtigig mimajuinu'g mu jigs'tmnew, aq me' pugwelgl igtigl ta'n goqwe'l tela'taqatioq!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na Se'sus ap wigumaji pugwenniji mimajuinu'g aq telimaji, “Jigs'tuigw ta'n te'sioq aq ns'tmu'tigw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ta'n goqwei mimajuinu malqotg, ma gisa'lugug piam gelu'sin. Etna ta'n teli angita'sin aq ta'n teluen gisa'lug mu gelu'sin, mu na ta'n goqwei malqotmn.  ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","'Gs'tuaqanin na nute'n!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Se'sus mimajuinu'g naqalaji aq pisgwa't wen'ji'guom. Na tujiw unaqapemg pipanimji gnua'tagunew ta'n goqwei wesgutg'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Se'sus pipanimaji, “Mu aji ns'tuo'ltiwoq aq ala igtigig, mo gilew nestasultiwoq. 'Lpa ta'n goqwei mimajuinu malqotg ma gisa'lugug piam gelu'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Muta mijipjewei mu gigja's'gtnug ugtangita'suaqanmual pas'g ugtlaminug aq wet siaw tu'aq wa'qi.” (Ta'n teluep ula Se'sus gegnu'tmuapni ta'n te's'g mijipjewei na telgitas'g malqota's'gtn.) ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na Se'sus siawewistoq, “Ta'n mimajuinu teli angita'sit gisa'latal mo gelu'sinin. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wejiaq mimajuinu uggamlamung aq ugtangita'suaqanm winjigl, aq winsmuin, gmutnen, aq ne'pa'tegen. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Wejiaq uggamlamung sespo'tegen, ta'n te's'g goqwei puatg ta'n igtig mimajuinu ugtaligam, pugwelgl ta'n goqwe'l winjigl tela'taqati'titl, egsuo'qon, winatuet, penoqweig, piluitelgaqan, pisui agnimulg, emtesguaqan, aq wini angita'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Na ta'n te's'gl winjigl goqwe'l wejiaqal ugtangita'suaqanmuaq aq gisa'l'sg mo gelu'sin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Na Se'sus naqt'g aq ejigla'sit Galaliewa'gi. Eliet gutanji'tl gigjiw 'gjigan teluisig Tail. Na pisgwa't wen'ji'guomg aq mu puatmug wen gji'jigun pas'g na mo gisi gasigw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Etna na ula e'pit ugtusl mn'tu'l eimlitl ugtinneg. Nutmatl Se'susal aq pegising ta'n eimlij aq smtug mesganatesingl uggwatg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ula e'pit, mo Lesui'pewi'sgw. Etli ugs'tqamuis Ponisiae'gati. Na gutanji'j eteg Silia. E'pit etawaqtmuatl Se'susal getaqqatesgmuan mn'tu'l ugtusl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Gatu Se'sus asitematl, “Mo weltenug ugjit ni'n liaman 'ntmimajuinumg aq apoqonmulinew gilew se'g tleiaultioq pa na wijei aq ugsua'tutaq nn'jang wilual aq ignmuan 'nmu'jig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na e'pit asitematl, “Saqamaw, teliaq teluen, pas'g we'gaw 'nmu'jig, lame'g p'tautigtug, malqotmi'tij ta'n mijua'ji'jg piwgtmi'tij.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na Se'sus telimatl e'pilitl, “Geju'l gi'l getlams'tasin, ta'n nige' gis tluen. Nige' gisinmietes. Na mn'tuaq gaqi gtaqqa'silitaq ugtusg ugtinneg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na e'pit apaja'sit aq we'jiatl ugtusl elisinnitl 'npo'qonigtug. 'Lpa mn'tu gaqi gtaqqa'silitl ugtinneg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Se'sus naqt'g gutanji'tl gigjiw Tail aq siawa'sit Saitonigtug aq maw na maqamigew teluisig, “Newgtisga'qal Gutanji'tl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Alt mimajuinu'g pegisitua'titl ji'nmul gepistaqanalitl aq waqqaj gis glusilitl. Na etawaqtmua'titl Se'susal iga'tun ugpitn na ji'nmul. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Toqo Se'sus tmg wesua'latl sitatug, ejigla'latl ta'n pugwenniji mimajuinu'g eimu'tilij. Iga'toq ugtluignn ula ji'nmul ugs'tuaqaneg, elusgwat ugtluign, aq sama'tuaj na ji'nmul winnu. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Se'sus soqwapa'sit wa'so'q, elgomigtuatl Nisgaml, aq nespipetoqsit. Telimatl ula ji'nmul, “Eppata!” na telueg, “Pana'tu, aq nute'n!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na smtug na ji'nm ugs'tuaqann pana'tigl aq winnu iltata's'g aq smtug weliewistoq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Se'sus 'ms't melgimaji, “Mut wen goqwei tluenew!” Pas'g ta'n tel piam melgimaj me' na aji gsigaw agnutmu'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","'Ms't ta'n te'sijig nutmajig na sigta paqalaiultijig. Teluejig, “Ta'n teli ula'tegej ta'n te's'g goqwei gis tla'tegej, we'gaw gisa'latl gepistaqanalitl nutmilitl aq mo netaweligul gelusilitl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ta'suguna'gweg pugwelgig mimajuinu'g elnutua'titl Se'susal. Ta'n tujiw mo geggunmi'tigup ta'n goqwei malqottaq, Se'sus wigumaji unaqapemg aq telimaji, ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ewlite'lm'gig ula mimajuinu'g muta ne'gaw nesuguna'q wijitgweiwijig aq nige' mo piamianug goqwei ta'n malqottaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Toqosip ula enmigimg'snig aq mo mijipjewe'mi'gw, na toqo tujiw 'lpa pugwelgig oqonitpaqia'titaq ta'n tujiw enmita'tij. Pugwelgig amaseg weita'jig negmow.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na unaqapemg pipanima'titl, “Tal gis we'jitutesnu paqtaqamigtug te's'g mijipjewei ta'n tl smatesnu wegla mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Se'sus pipanimaji, “Ta's'gl pipnaqanu'tl geggunmoqol?” Teli asitema'titl, “Lluigneg te's'gl pipnaqanu'tl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Toqo Se'sus telimaji mimajuinu'g, “Pita'gw maqamigeg.” Se'sus wesua'toq lluigneg te's'gl pipnaqanu'tl aq miwatmuatl Nisgaml. Na tujiw sewisgino'toqol pipnaqanu'tl aq ignmuaji unaqapemg se'si ignmuetunew mimajuinu'g. Na unaqapemg tela'taqatiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na unaqapemg gegguna'tisni ta'siliji nme'ji'jg. Se'sus wesua'laji nme'ji'jg aq miwatmuatl Nisgaml aq telimaji unaqapemg se'si ignmuetunew ula nme'ji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","'Ms't wej g'satalultijig. Etna na'te'l na'tami ne'w pituiptnnaqanijig mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na tujiw unaqapemg ta'n wej piamiaqal wajua'tu'titl lluigneg te's'gl ligpenignn. Na tujiw Se'sus ejiglgimaji mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Smtug tepita'jig ugtuluaq maw unaqapemg aq elaqtaqatijig aq oqwa'jig na gutan, teluisig, “Talmanutta.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Etna na'te'l alt Palasiaq peita'ji aq poqji gi'gajasuala'titl Se'susal, getu gistesgua'titl. Na pipanima'titl, “Ge' nat goqwei Nisgamewei musga'tuin. Na tujiw 'gtlams'tultesnen Nisgamewigtug ugjien.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Na tujiw Se'sus ma'muniw wejjelamit aq teluet, “Goqwei gilew mimajuinuutioq wej pualioq tla'tegen ta'n goqwei Nisgamewei? Telimuloq, moqwa'! Ma musga'tuluoq gilew mimajuinuultioq ta'n goqwei Nisgamewei. Na!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Smtug Se'sus aq unaqapemg naqala'tiji aq apat tepita'jig ugtuluaq aq poqji asoqomita'jig qospemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na unaqapemg awan'ta'sulti'tij jugwa'tunew pipnaqan, pas'g newgte' geggunmi'tis ugtuluaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Se'sus gegnua'tuaji, “Ango'tmug, aq uli angweiasultigw ugjit na ugtapita'taqanmuoq Palasiaq aq Elot.” (Se'sus etl gnua'tuaji ta'n tel gina'mua'tilij Palasiaq aq Elot.) ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na poqji mil agnutma'tijig, “Wet tluet muta mo ginu pipnaqann geggunmug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Se'sus geitoq ta'n goqwei wesgutmi'tij. Geitoq mo nestua'tigul negm wesgumapni ta'n goqwei Palasiaq aq Elot gegina'mua'ti'tij. Na tujiw pipanimaji, ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","“Gilew 'gpugugultioq pas'g mo getu nmitaqatiwoq aq 'gs'tuaqanultioq pas'g mo getu nutmu'tiwoq. Mo nestmu'tiwoq muta mo migwite'tmutiwoq ta'n gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ta'n tujiw sewisgino'tuaneg na'ngl pipnaqanu'tl ugjit ula na'n pituiptnnaqanijig mimajuinu'g, ta's'gsn ligpenignn ta'n wejpiamiaqal wajua'tuoqs'pnn?” Teli asitema'titl, “Newgtisga'qal jel ta'pu te's'g'pnn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Se'sus pipanigesit, “Ta'n tujiw sewisgino'tuaneg lluigneg te's'gl pipnaqanu'tl ugjit ne'w pituiptnnaqanijig mimajuinu'g, ta's'gsn ligpenignn ta'n wejpiamiaq wajua'tuoqs'pnn?” Teli asitema'titl, “Lluigneg te's'g'pnn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Na Se'sus ap pipanimaji, “Me' mo nestasultiwoq?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Peita'jig Petse'ta aq alt mimajuinu'g pegisula'titl nepapigwa'litl ji'nmul Se'suseg etawaqtmua'titl ugjit sama'lan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Se'sus wesua'latl ji'nmul ugpitn aq tewglisgenatl sitatug gutanji'j, tel gne'g elusgwatmuatl ji'nmul ugpugugul, Se'sus iga'toq ugpitnn ji'nmul ugpugugw aq pipanimatl, “Nemitun goqwei?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na ji'nm wapa'sit aq teluet, “Nemi'gig ji'nmug al gigto'qwita'jig, pas'g na teli angamgusultijig st'ge' miti'sg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Se'sus ap iga'toqol ugpitn ula ji'nmul ugpugugul aq telimatl, “Unaqapa'si.” Na tujiw ji'nm siaw wapa'sit aq me' pem ulapit aq 'ms't goqwei wel nemitoq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Se'sus telimatl, “Mut apaja'siw ula gutanji'jg pas'g 'nmia giguaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na Se'sus aq unaqapemg ejiglita'titeg aq pemi lta'jig igtigl gutanji'tl tle'l Sesalia Pilippaieg. Ge's pemi lta'titeg na pipanimaji, “Tlimigw ni'n, tal'ta'sultijig mimajuinu'g wenin ta ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na teli asitema'titl, “Alt teluejig, ‘Gi'l na Sa'n Nutsign'tuet.’ Igtigig teluejig, ‘Gi'l na Ilaija’ gatu igtigig teluejig, ‘Gi'l na iganigjitegewinu.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Se'sus tel pipanimaji, “Gatu gilew, tal'ta'sultioq weni ta ni'n?” Pie'l asitematl, “Gi'l na Nujiugs'tawi'wet ta'n Gjinisgam petgimapnn ugjit ilgwenan ugtmimajuinumg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Se'sus melgimaji, “Mut wen tlimanew ta'n weni ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na Se'sus poqji gina'muaji unaqapemg, “Ni'n na newgte'ji ta'n mimajuinualsiap. Amujpa na ma'muniw ulmaje'tes. Iganpugultijig patlia'sg aq nujigina'mua'tijig tplutaqan aq natawo'ltijig ji'nmug ma menuaqali'gw aq ilsumitaq ta'n tl ne'pa'itaq. Na toqo tujiw nesuguna'q apaji mimaju'as.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Se'sus melgima'sni ugjit uli ns'tmu'tinew. Na Pie'l sitatug Se'susal ela'latl aq majiaqa'latl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Se'sus gigtoqopugua'sit, angamaji unaqapemg, aq majiaqa'latl Pie'lal, “Jigla'si ni'neg Gjimn'tu. Teli angita'sin 'st'ge' ji'nm, mo teli angita'siwn ta'n Gjinisgam tel pual'sg!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na tujiw Se'sus wigumaji mimajuinu'g maw unaqapemg, telimaji, “Ta'n wen getu wije'wit ni'n, amujpa na ma gis tla'tegegw ta'n teli gsatg, pas'g Gjinisgam ta'n tel puatg. Na tujiw gis majulgwalit ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Na mimajuinu tela'teget ta'n teli gsatg Mn'tua'gig lietew. Gatu mimajuinu tela'teget ni'n ta'n tel pualg, 'msntew iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ge's ula ugs'tqamu eig, pas'g na 'ms't goqwei gisi assutmu's'p ta'n telgi'g ugs'tqamu, na toqotesip e'nmu's'p iapjiwewei ugmimajuaqanm wa'so'q. Goqwei gelu'lg ugja'jutes? 'Lpa pe'gaj mo goqwei! ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","'Lpa mo eigtnug ta'n mimajuinu gisi ignmuetew ugjit gis tli apaja'lan iapjiwewei ugmimajuaqanm wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mut netaqite'lmiw ta'n tel gina'muen. Mut tlimaw lue'winu'g aq ta'nig mo gejia'tigul Nisgaml, ‘Mu ni'n teli gtlams'tasiw Se'sus.’ Pa na tla'tegen na, ni'n, na ula ji'nm ta'n Gjinisgam petgimapnn, jiglapasualultesg ta'n tujiw apaja'sian nujj uggepmite'lgaqanm aq maw sape'ultijig ansale'wijig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Se'sus siawewistoq, “Migwite'tmug ula! Eimu'tijig ula tet ta'nig ma 'npu'ti'gw glapis nemia'tij Gjinisgaml ta'n ilsutegelitl e'w'g ugml'gigno'tim.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Gisi asugom tesuguna'q, Se'sus maja'laji Pie'lal, Ji'mejal aq Sa'nal. Ela'laji pas'g negmow etli espapit gm'tn. Ge'sg elapulti'tij etl sa'se'wamugwasilitl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Utapsun ma'mun pitiata'tigl aq poqtaqi wapa'tigl. Mo eigtnug ugs'tqamug suspanign gis tl wapa'toqol st'ge' nige' weget je mu ewnejgewei. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na toqo tujiw negla nesisijig unaqapemg nemia'tiji Ilaijaal aq Mowisal. Etl agnutma'ti'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pie'l gelusit aq telimatl Se'susal, “Nujigina'muet, na maw gelu'lg tet i'mnen. Ge' nesisgl anapjetegewe'l 'ltutesnen, newgte' ugjit gi'l, newgte' ugjit Mowis, ap igtig ugjit Ilaija.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pie'l aq igtigig sigtata'sultijig aq mo geitu'ti'gw ta'n tluetis. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jiniw alug neia's'g tetpaqiw ta'n gaqamulti'tij aq nutua'titl Nisgaml alugwigtug teluelitl, “Etna na ula Se'sus newgti pistai 'ngwis ta'n mawi gsalg. Jigs'tug negm!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jaqal gigtoqopetesultijig pas'g mo wenn nemia'tigul pas'g Se'susal ta'n wijitgweiagwi'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ge's pem nisita'titeg gm'tnigtug Se'sus melgimaji, “Mut wen tlimanew ta'n goqwei gis nemituoq glapis, ni'n, na ula ji'nm ta'n Gjinisgam petgimapnn, gisi npman aq gisi apaji minunsian.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jigs'tua'titl ta'n gis tlimaj pas'g negmow poqji apaji usgutmi'tij, “Goqwei ta na ula wesgutg, ula gisi npman aq gisi apaji minunsian?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Glapis pipanima'titl Se'susal, “Tal gis nujigina'mua'tijig wet tluejig ‘amujpa Ilaija tmg pegising?’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Teli asitemaji, “'Lpa Ilaija tmg pegising aq 'ms't goqwei weji gisgaja'toq, gatu tal gis Gjinisgam ugtwi'gatign gis tl wi'gas'g, ‘Na ula ji'nm ta'n Gjinisgam petgimapnn amujpa na ma'muniw ulmaje'tew aq ma'munuaqtasigw.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Telimuloq, 'lpa Ilaija gis pegising aq mimajuinu'g tela'la'tipnn ta'n getu tla'la'tij pa na wijei Gjinisgam ugtwi'gatign telueg ugjit negm.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ge's Se'sus, Pie'l, Sa'n, aq Ji'mej weita'titeg gm'tnigtug aq nemia'titeg esgwia'tiliji unaqapemg aq pugwenniji mimajuinu'g. Alt nujigina'mua'tijig tplutaqan etl gi'gaja'suala'tiji Se'sus unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ta'n teli nqase'g mimajuinu'g nemia'titeg Se'susal na we'gwi ms'gi'gs paqalaiwaqan. El'tugultijig aq wel'ta'suala'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Se'sus pipanimaji unaqapemg, “Goqwei ta gilew wej gi'gaita'ioq?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na te'si'tij mimajuinu'g newgte'jit ji'nm asita'puguet, “Nujigina'muet, 'ngwis pegisitulap muta mn'tu'l geggunatl ugtinneg, etna na ugjit mo gisi ntawe'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mn'tu te's pesu'gwatuaj 'lpa'tujl aq mesganatesimatl maqamigeg. Pisewiaq ugtun metewigjetgl wipitl aq pem mejgiet. Na pipanimg'pnig unaqapemg 'gtaqqatesguanew na mn'tu'l pas'g mo gis tala'la'tigul.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Na Se'sus telimaji, “Tali pgitgalultoqs'p aq tali pgijia's ni'n glapis 'gtlams'tmu'tioq? Ge' jugwa'tui na lpa'tuj.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na tujiw pegisula'titl Se'suseg. Ta'n teli nqase'g mn'tu nemiateg Se'susal, smtug gisa'latl 'lpa'tujl wejipulgwelitl aq nisegetl maqamigeg lpa'tujl aq te't'pja'silitl aq waju'paqtesg ugtun pisew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Se'sus pipanimatl ujjl, “Ta tujiw sa'q na tele'g?” Ji'nm teluet, “Gis ta'n tujiw mijua'ji'juiteg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Gaqaisg mn'tu wejo'tg ne'pa'n ula ngwisl. We'gaw gisa'latl elja'lan pugtewigtug aq we'gaw eligsmegetl samqwanigtug. Ewlite'lmieg aq apoqonmuieg, etug gis tla'tegetes na.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Se'sus asitematl, “Goqwei wet tlua'n etug gis tla'tegetesg na? Ta'n tujiw getlams'tmn ta'n pas'g goqwei gis tliatew ugjit gi'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Smtug 'lpa'tuj ujjl gesigawwelitl, “Gjisaqamaw, getlams'tasi pas'g mo tepianug ta'n teli gtlams'tasi, apoqonmui me' ma'muni gtlams'tasin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Se'sus nemiaji mimajuinu' poqji gigjita'liji, na smtug melgimatl mn'tu'l, telimatl, “Na gi'l mn'tu ta'n gisa'l't ula 'lpa'tuj gepistaqanan aq mo 'ntawen. Mn'tu, telimul, 'gtaqqa'si na 'lpa'tuj aq mut apaja'siw nugu.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ula mn'tu sesgwet aq gisa'latl 'lpa'tujl wejipulgwelitl aq getaqqa'sitl. Na 'lpa'tuj teli angamgusit 'st'ge' 'npuinu. Na 'ms't wen teluet, “Nepgaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Gatu Se'sus wesua'tuaj ugpitn aq apoqonmuatl unaqa'silin aq 'lpa'tuj gaqama'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ta'n tujiw Se'sus gis pisgwa'teg wen'ji'guom newgtugwa'luguti'titeg unaqapemg pipanima'titl, “Tal gis ninen mn'tu mo gisi gtaqqatesguaqat?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Se'sus asitemaji, “Pas'g a'sutman aq sune'win gisi gtaqqatesguaten na telamugsit mn'tu aq mo goqwei piluei.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Na naqt'g na'te'l aq siawita'jig Galali. Se'sus mo puatmugup wenn gji'tun ta'n eimu'tijig muta etl gina'muasnig unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Telimaji, “Ni'n, na ula ji'nm ta'n Gjinisgam petgimapnn, iga'liten mimajuinu'g ugpitnuaq ugjit ne'po'qsin. Na gisi nsugunaq apaji minunsites.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mo negmow nestua'tigul ta'n goqwei gegina'muaji pas'g jipasultijig pipanimanew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Peita'jig Gapelniam aq ta'n tujiw gis pisgwita'titeg wen'ji'guomg Se'sus pipanimaji unaqapemg, “Goqwei ta na etl gi'gaita'ioqos wejgwita'gweg awgtigtug?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pas'g na mo getu asitema'tigul muta wejgwita'titeg awgtigtug gi'gaita'pnig ta'n wen me' espe'g te'si'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Se'sus epa'sit aq wigumaji newgtisgegsiliji je ta'pu, telimaji, “Ta'n wen getu iganpuguij amujpa igalsit ugtejgewa'juin aq lugowata 'ms't wiguma.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na Se'sus nemisguatl mijua'ji'tl, ugplaqaneg tepa'latl aq gegulusgwa'latl. Na tujiw telimaji unaqapemg, ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Na mimajuinu ta'n 'nwisunmg wele'watl mijua'ji'tl pa na wijei aq ni'n ta'n teli ule'wij, aq ta'n wen wele'wit ni'n mo pas'g ni'n wele'wigw pas'g maw na newgte'jit ta'n ni'n petgimip.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sa'n telimatl, “Nujigina'muet, nemi'g'tt'p ji'nm mn'tu'g getaqqatesguaji mimajuinuigtug, 'gwisunm e'wm'sg, pas'g mo majulgwalugsi'gw ginu. Na telimg'tt'p, ‘Naqa'si smtug muta mo majulgwalugsi'gw.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Se'sus teli asitemaji, “Mut naqa'lanew, muta ta'n pas'g wen nepiteget gisna mn'tu'g getaqqatesguaji 'nwisunmg, negm ma 'nqasaiw gisi mil agnimigw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ta'n wen mo getanugsiwgw na igalugsi'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Migwite'tmug ula! Ta'n wen samqotl'sg samqwan muta tleiawin Se'suguliewigtug, amujpa na 'msntew ugtapangitueweim.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Pa na mimajuinu gisa'laj newgte'jilitl mijua'ji'tl, ta'nig getlams'tasilitl, oplawtigmuaj, ap me' pajiji mtue'tew ugjit na mimajuinu. Me' glu'lgtesoq, na mimajuinu mesgi'g gun'tew gelpilmuj ugjitaqaneg aq paqatjiegemg 'gta'nug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Toqo pa na gisa'l'sg ula 'gpitn opla'tegen, ugsua'tu tmse'n, me' glu'lgtes 'msnmn iapjiwewei mimajuaqan pas'g newgte' 'gpitn, awna je mu gitg 'gpitnn aq Mn'tua'gig lien ta'n pugtew ma 'nqa'suenug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Na'te'l iapjiw mimajites aq iapjiw amasgipnnetesg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Pa na 'ggat gisa'l'sg ejigla'sin Nisgamewigtug, ugsua'tu tmse'n muta me' glu'lgtes 'msnmn iapjiwewei mimajuaqan pas'g newgtigatan awna je mu tapuigatan Mn'tua'gig lien. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Na'te'l iapjiw mimajites aq iapjiw amasgipnnetesg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pa na 'gpugug gisa'l'sg jigla'sin Nisgamewigtug ugtaqa'tu. Me' glu'lgtes pisgwa'n Gjinisgam ugtelege'wa'gimg pas'g newgt taqqigwan je mu siaw gugunmn gitg 'gpugugul aq Mn'tua'gig lien. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Na'te'l iapjiw mimajites aq iapjiw amasgipnnetesg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ta'n tujiw ugs'tqamu eig, amujpa na wen gijga'ji'j gitnmat aq welmaje'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Wigapu'g ta'n goqwei wel salawa'tas'g. Gatu mo iga'tun salawei mijipjeweigtug, ma wigapu'gtnug. 'Gsal igtigig 'st'ge' ta'n Gjinisgam teli gsal'sg. Ignmu Wejuli Nisgam ilgwenmulin, na tujiw, tle'n gi'l st'ge' na mijipjewei ta'n wel sala'watas'g glaman ul mawo'ltitoqs'p igtigig mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Na Se'sus naqt'g na'te'l, siawa'sit Jutia, aq siawi asoqoma'sit sipug teluisig Jol'tan. Ap igtigig pugwelgig mimajuinu'g peita'jig ta'n eimlij. Na negm egnutmuaji 'st'ge' ta'n i' tla'tegej. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Alt Palasiaq peita'jig aq wet nu'gwala'titl ta'n tel pipanigesultijig, “Nujigina'muet, ge' tliminen, etug 'gt'tplutaqanminu ignmuaj ji'nmul nigtua'tinew ugte'piteml.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Se'sus teli asita'puguet aq pipanimaji, “Talamugusnn 'tplutaqann Mowiso'q gis ignmugsioqol?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Teli asitema'titl, “Mowiso'q ignmuapnn ji'nmul ewi'gas'g wi'gatignigtug ugjit nigtua'tinew ugte'piteml aq jigla'silin.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Se'sus telimaji, “Mowiso'q ewi'g'g'p na ula telamu'g 'tplutaqan ugjit gilew muta metua'taqatioqop aq melge'gl 'ggamlamunual. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mujga amgweseweieg ugs'tqamu el'ta's'geg, na teluep, ‘Gjinisgam eliapni ji'nmul aq e'pilitl.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Etna na ugjit ji'nm naqalaji ujjl aq uggwitl aq toqwa'tijig ugte'piteml. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Na wegla tapusijig negmow ngute'jitaq, mu nugu tapusi'gw pas'g 'ngute'jitew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ta'n weni Gjinisgam gisitgwalaji, ma wen gis nigtua'lagwi.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Na ta'n tujiw apaji pisgwa'teg wen'ji'guomg, unaqapemg pipanima'titl Se'susal ta'n goqwei ugjit gelutmlitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Telimaji, “Ta'n ji'nm puna'latl ugte'piteml aq malie'wi'tij igtigl e'pilitl, sespo'teget aq opla'latl ugte'piteml. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pa na wijei, e'pit nigtua'ti'tij ugji'nmuml aq malie'wi'tij igtigl ji'nmul, na sespo'teget aq opla'latl ugji'nmuml.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Alt mimajuinu'g pegisitua'tiji un'januaq Se'suseg ugjit negm sama'lan. Pas'g na unaqapemg majiaqa'la'tiji negla mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Se'sus gejiaj na smtug wegaig, aq telimaji unaqapemg, “Ignmu na mijua'ji'jg jugwita'new ni'neg. Mut wetqo'lanew muta na mimajuinu'g ta'n sangewitelmijig st'ge' wegla mijua'ji'jg Gjinisgam ugtelege'wa'gim tleiaultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Migwite'tmug ula! Amujpa na ignmat Gjinisgam iganpuguin, pa wijei aq wegla mijua'ji'jg, muta ma Gjinisgam gisi ilgwenulug, glapis na tla'tegen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Se'sus te's mijua'ji'tl wesua'latl, epa'latl ugplaqaneg aq gegulusgwa'latl. Ugtugwejan ugpitn iga'toq aq a'sutmessewatl te's ingute'jilij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mjit ap newgt Se'sus poqtamga'sit. Na tujiw ji'nm el'tugwi'gl, el nutgul'pa'sitl Se'susal aq pipanimatl, “Welm'tun nujigina'muet, tala'tega's ni'n gisi msnmn iapjiwewei mimajuaqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Se'sus pipanimatl, “Goqwei ugjit telui'tin ni'n welm'tu? Mo wen welm'tug pas'g Gjinisgam newgte'jit. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Geju'l gi'l geitu'n 'tplutaqan: Mut ne'pa'tegew, aq mut sespo'tegew, mut gmutnew, mut egsuew, aq mut gmutnesuintuisgew, gepmite'lm gujj aq 'ggij.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na ji'nm teluet, “Nujigina'muet, weja'tegemgeg maljewe'juianeg ne'gaw majulgwatmn ta'n te's'gl 'tplutaqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Se'sus tetpaqi angamatl, ewlitelmatl, aq gesalatl ula ji'nmul. Na telimatl, “'Mjit newgte' nat goqwei tla'tegen. Maja'si aq 'ntuisgetu ta'n te's'g goqwei geggunmn, na suliewei ignmu ewle'juinu'g aq milesuaqan guguntes wa'so'q. Gis tla'tegen na, jugu'etesg aq majulgwalites ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ta'n tujiw ji'nm nutgeg ula, ewlapewa'sit, ewlgwija's'g uggamlamun, aq ejigli ewlitoq muta we'gwi milesit. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Se'sus gigto'qopa'sit unaqapemg aq telimaji, “Na tetuji mtue'g ugjit milesit mimajuinu pisgwa'n Gjinisgam ugtelege'wa'gimg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na unaqapemg sigtatesgagwi'tij wegla ugglusuaqanml pas'g Se'sus siawewistoq, “Nn'jantut mawi mtue'g ta'n tel pisgwa'timg Gjinisgam ugtelege'wa'gimg negmow ta'n elita'sulti'tij milesuaqan ugjit pisgwa'tunew Gjinisgam ugtelege'wa'gimg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tetuji mtue'g milesit mimajuinu lien Gjinisgam ugtelege'wa'gimg pa na wijei aq nige' melgawlejit mo eigtnug, gis saputa'sin saqati ugpugugw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na tujiw unaqapemg ap me' aji paqalaiultijig aq pipanimtultiji, “Tal gisi ugs'tatew wen?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Se'sus tet paqi angamaji aq asitemaji, “Ula ma mimajuinu'g gis tlataqati'gw pas'g Gjinisgam 'ms't goqwei gis tla'teget.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na Pie'l gelusit, “Ninen gatu, 'ms't goqwei naqtmegupneg aq majulgwaluleg'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Se'sus telimaji, “E'e, ap wijei telimuloq. Menaq wen pisuiw naqtmug wiguow gisna ugjignamg, uggwe'ji'jg uggwitl, ujjl, un'jang, aq maw ugtiga'taqan ugjit ni'n aq ugjit na gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Negm 'msntew nige' ula ugs'tqamu me' aq gasgiptnnaqanigl ugjit te's newgte'jit ta'n naqt'g, wiguow, ugjignamg uggwe'ji'jg, uggwitl, un'jang, ugtiga'taqan, maw gitnmaten aq amasgipnnaten. Me' enmi'gnig 'msntew iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Maw pugwelgtaq, nige' amgwesewe'gig, na negmow ugtejgewe'taq, aq pugwelgig ta'n ugtejgewe't'pnig, na negla amgwesewe'taq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Na nige' pemi lta'jig Selusalemg. Se'sus igana'sit aq unaqapemg ugtejg jipasultijig aq ta'nig mimajuinu'g majulgwalugwi'tiji wegwata'sultiliji. 'Mjit ap newgt Se'sus newgtisgegsiliji je ta'pu unaqapemg sitatug ela'laji aq wesgutg ta'n te's'g goqwei tliatew ugjit negm. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Se'sus telimaji, “Jigs'tuigw! Telimuloq ta'n tliatew ugjit ni'n. Nige' el'ta'igw Selusalemg aq ni'n, na ula ji'nm ta'n Gjinisgam petgimapnn, iga'tasites iganpugultijig patlia'sg aq nujigina'mua'tijig tplutaqan. Etna negla ilsumitaq ugjit ni'n 'npmn aq iga'liten ta'nig mo Lesui'peulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wegla maligimitaq, lusgomitaq, nipispaqante'taq, aq ne'pa'itaq aq gisi nsugunaq Gjinisgam apaji minua'litew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na Ji'mej aq Sa'n, Sepeti uggwisg Se'suseg pegisingig. Teluejig, “Nujigina'muet, nat goqwei pewatmuleg tla'tegen ugjit ninen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Se'sus pipanimaji, “Goqwei pualioq tla'tegen ugjit gilew.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Se'susal teli asitema'titl, “Ta'n tujiw poqji ilsutegen ugtelege'wa'gimg ta'n me' espe'g aq igtigl, pualuleg maw pultinenu newgte'jit 'gtinaqanmg aq newgte'jit 'gpatatujmg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Se'sus telimaji, “Mu geituoq ta'n goqwei pipanigesioq. Gisi ugt samqwatoqs'p st'ge' amujpa ni'n ta'n ugt samqwa's. Gis tli ulmaje'toqs'p st'ge' amujpa ni'n ta'n tli ulmaje'tes? Gis saputita'toqs'p st'ge' amujpa ni'n ta'n 'gjisaputasites?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Teli asitema'titl, “E'e! gis tla'tegetesnen.” Se'sus telimaji, “E'e, na tliatew, ugt samqwatoqs'p st'ge' amujpa ni'n gtu' samqwa's. 'Lpa tli ulmaje'toqs'p 'st'ge' amujpa ni'n tli ulmaje'tes, aq 'lpa saputita'toqs'p 'st'ge' amujpa ni'n ta'n ugji saputa'sites. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pas'g na mo ni'n telgita'siw 'mgnmulinew ta'n wen pitew 'ntinaqanmg gisna 'npatatujmg. Negm na Gjinisgam ignmuataq ugt'punual ta'n gisgattegl ugjit negmow.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ta'n tujiw igtigig newgtisgegsijig unaqapemg nutma'titeg wegaiugtua'tiji Sa'nal aq Ji'mejal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Gatu Se'sus wigumaji aq teluet, “Assumgwi'tiji g'pnno'lewaq ta'nig mo Lesui'peulti'gw aq gegguna'tiji, ap igtigig ilsuma'tiji mimajuinu'g ta'n tla'taqatilitaq aq gilew geituoq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mut na tl pmita'new. Pa na nat wen newgte'jit te'sioq gtu' gugung ml'gigno'ti amujpa na negm elugowaji esgwia'tiliji, ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","aq wen newgte'jit gtu' iganpuguij amujpa na gistejuit 'ms't ta'n te'siliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pa na wijei ni'n, na ula ji'nm ta'n Gjinisgam petgimapnn, mo weji pgisinuap ugjit lugougsin, weji pgisinap lugowan aq iga'tun 'ntmimajuaqanm ugjit ugs'tawian pugwelgig mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na tujiw peita'jig Jeligo. Ge's Se'sus pem jiglita'tij aq maw unaqapemg, pugwelgig mimajuinu'g mawia'tijig. Na nepapigwa't ji'nm teluisit Paltimeas, ujjl teluisilitl Timeus, pemgopit aq etl tawaqtmat gmetug awgtigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ta'n tujiw nutmateg ula Se'sus tleiawit Nasalet gis pegising, poqji sesgwet, “Se'sus! Ntelege'witeminen, Ta'piteg wetagutmn, ewlitelmi!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pugwelgig majiaqa'la'titl aq telima'titl, “Wantaqa'si!” pas'g na me' aji gsigawet, “Ta'pit uggwisl! Ge' ewlitelmi!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Se'sus nenga'sit aq teluet, “Wigumug!” Na wiguma'titl nepapigwa'litl ji'nmul aq teluejig, “Ulgwija'si, unaqa'si, muta wigum'sg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Smtug menegetl ugpitu'gunml. Jiniw gaqametesing aq elietl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Se'sus pipanimatl, “Goqwei pualin tla'tegen ugjit gi'l?” Nepapigwa't teli asitematl, “Nujigina'muet, ap getu nemitegei!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Se'sus telimatl, “Ta'n teli gtlams'tasin na weji gisi npisin nige', gis maja'sites.” Smtug ula ji'nm gis nemiteget aq majulgwalatl Se'susal awgtigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Se'sus aq unaqapemg pemi lta'jig gigjiw Selusalem. Tmg el'ta'jig Pettani toqosip Petpaqe'. Ula gutanji'tl suel toqtegsn etegl nunmaqamigeg Olipet gm'tnigtug. Se'sus tapusiliji unaqapemg igan gnua'tuaji ta'n tla'tegelitaq, aq igangimajig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“La'tigw ula gutanji'j me' naqajijge'l. Ta'n tujiw iga'ioq na'te'l we'jiatoqs'p te'sipowji'j gelpilasit. 'Lpa menaq e'wa'sigw. Apgwa'latoqs'p aq apat gl'taqana'toqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pa na wen pipanimugsioq, ‘Goqwei wet tla'tegeioq na?’ tlimatoqs'p, ‘Gjisaqamaw pualatl, smtug apaja'tultal gaqiewaj.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na maja'tijig aq we'jia'titl te'sipowji'tl gmetug awgtigtug. Wej gl'pisilitl ga'qanigtug wen'ji'guom. Ge's etli apgwa'la'tij, ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ta'nig gigjiw gaqamultijig pipanimgwi'tiji, “Tal lugweioq ta u't etli apgwa'loq te'sipowji'j?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Teli asitema'tiji st'ge' ta'n Se'sus telimapni. Na smtug ji'nmug iga'la'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Apat gl'taqana'titl te'sipowji'tl Se'suseg, ugpitu'gunmuaq ugpaqamg ge'gwistaqatua'titl wi'sisl aq smtug Se'sus tepa'sitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na pugwelgig mimajuinu'g siplamgo'la'tiji ugpitu'gunmuaq awgtigtug, gatu igtigig miti'sigtug weji mn'te'mi'titl nipispaqan iga'taqanigtug aq siplamgo'tu'titl awgtigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Na mimajuinu'g ta'n iganita'jig aq ta'n ugtejg wejgu'ita'jig na poqji sesgu'tijig, “Allelulia Gjinisgam gepmite'lmatl ula newgte'jit wejgu'et ugwisunmg. Gjinisgam gepmite'lmatl ula newgte'jit wejgu'et ginu gtelege'witemitesnu st'ge' Ta'pito'q. Allelulia Gjinisgam ta'n mawi espe'g. Gjinisgam westaugsi'gw nige'.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Se'sus iga't Selusalem aq pem liet 'gjia'sutuo'guom. Pisgwa't aq teli alapa'sit 'ms't tami. Na tujiw naqt'g aq apaja'sit Pettani maw newgtisgegsiliji je ta'pu unaqapemg muta gis pem gaqiaq na'gweg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na igtig na'gweg pemi apaita'titeg, Pettani, Se'sus gewising. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Gneg nemiatl pi'gmenaqsi'l, waju'elitl nipi'g. Se'sus eliet ta'n tet gaqamilij aq aji angamatl ugjit gis we'jitun pi'gl me' i'ttn. Ta'n tujiw gigja'siteg pas'g nipi' we'jiaji, mo tami nemitugul gaqapitnugl pi'gl, muta mo tetaputestnug nigwen pi'gl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Se'sus telimatl na pi'gmenaqsi'l. “Ma wen nugu pi'gl ugtatalug gi'leg!” Aq unaqapemg nutua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ta'n tujiw peita'titeg Selusalemg Se'sus pisgwa't tusati 'gjia'sutuo'guom. Poqji tuattesguaji 'ms't ta'n te'siliji etli pgwateligatiliji aq etli ntuisga'tiliji a'sutuo'guom aq aputasgejio'toqol ugpatautimual nut sa'se'wa'tu'tij suliewei aq ugmutputimual ta'nig netuisgetu'tiji plesg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mo ignmuagul wenn pma'tilin ta'n pas'g goqwei 'gjia'sutuo'guomei iga'taqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na tujiw tel gnu'tmuaji mimajuinu'g, “Na'te'l ewi'gas'g Gjinisgam ugtwi'gatign, ta'n goqwei Gjinisgam teluep, ‘Ni'n nignen na tluisitew ta'n i' tli a'sutma'timg ugjit 'ms't mimajuinu'g.’ Pas'g gilew gawasga'tuoq gmutnes i' tligasulti'tij.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na iganpugultijig patlia'sg aq nujigina'mua'tijig tplutaqan nutmi'titeg aq na poqji gwilmi'tij ta'n tl ne'pa'taq Se'susal pas'g na jipala'titl muta pugwelgig mimajuinu'g wesam jigs'tua'titl ta'n tel gina'muelij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na wela'gwele'l iga'q Se'sus aq unaqapemg naqtmi'tij na 'gjigan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ge'sg egsitpu'g pemi lta'tij awgtigtug nemia'titl pi'gmenaqsio'q gaq gispasisnaq glapis ugjip'sgigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pie'l migwite'tg ta'n gis tliaqap ulagu, aq telimatl Se'susal, “Nujigina'muet, ge' lapa'si, na pi'gmenaqsio'q ta'n gelult'p ulagu, nepg'snaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Se'sus asitapuguet aq telimaji, “Migwite'tmug ula! Lita'sultigw Gjinisgam! ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na tujiw gis tlimatoqs'p gm'tnji'j, ‘Unaqa'si aq eljiaqalsi 'gta'nug.’ Gatu mo megtamutiwoq, ggamlamunuaq, awna 'gtlams'tasultioq ta'n goqwei telueioq tliatew, aq na tla's'gt'tew ugjit gilew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Etna na ugjit wet tlimuloq, ta'n tujiw a'sutman aq etawaqtman goqwei 'gtlams'tasi, na gis mesnmneg, aq 'ms't goqwei msntes. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ta'n te's a'sutman apigsigtu ta'n wen getan'sg glaman gujj wa'so'q apigsigtmultal 'gtlue'uti'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Gatu mo apigsigtuawj igtigig pa na wijei Gujj wa'so'q ma apigsigtmulugul 'gtlue'uti'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na tujiw apajita'jig Selusalemg. Aq pisgwita'jig 'gjia'sutuo'guomg. Ge's Se'sus ala'sit na iganpugultijig patlia'sg, nujigina'mua'tijig, aq me' natawo'ltijig ji'nmug peita'jig negmeg, ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","aq pipanima'titl, “Tal gis tla'tegen weget aq wen ignmasg's ugtassusutim ugtla'tegen?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Se'sus asitemaji, “Nige' pipanimuloq pas'g newgte' glusuaqan, aq gisi ignmuioq ula glusuaqan. Na ni'n gis tlimultoqs'p ntassusutim ta'n tel gis tla'tegei. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ge' tlimigw, Wen Sa'nal petgimasnn ugjit sign'tuan mimajuinu'g? Gjinisgam gisna mimajuinu?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pas'g na negmow poqji sespagnutma'tiji, “Nige' taluetesnu? Na tli asitemug wejiaq Nisgamewigtug, tluetew, ‘Goqwei ugjit mo getlams'tuawoqos Sa'n?’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Gatu awna ula mimajuinu'g gepmite'lma'titl Sa'nal. Ma gis tluegw wejiaq mimajuinuigtug,” muta jipala'tiji mimajuinu'g. 'Ms't wen gtlamite'lmatipnaq Sa'no'q iganigjitegewinuaq. Iganpugultijig jipala'tiji mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Na teli asitema'titl Se'susal, “Mo geitueg!” aq Se'sus telimaji, “Pa na wijei, ma tlimuluoq ta'n weja'tuan ntassusutim ugjit ta'n tel gis tla'tegeian.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na Se'sus poqji a'tugowaji, “Etna na ula ji'nm gle'pmenaqsig etli iga'taqalaji aq llutaqan gigto'qolut toqo mulqatg elmalqei ugjit ta'n tl pepgijo'tutal gle'pl aq el'toq wen'ji'guomji'j ta'n tel gisi al gigto'qwapitew. Na tujiw maqatuigetoq ugtiga'taqan aq wiguow naqt'g aq poqtamga'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ta'n tujiw mena'taqutimg gle'pl iga'q elgimatl ugtlugowinuml ugjit ignmugsin ta'n telgi'g tettuj na iga'taqanigtug wegla nuji iga'taqu'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Na nuji iga'taqu'tijig goqqwa'la'titl na lugowinu'l tl matta'titl aq apat gima'titl. Mo goqwei pe'gaj pegisitug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Na assusit igtigl lugowinu'l poqjigimatl, ta'n eimu'tijig nuji iga'taqu'tijig. Matna'titl aq taqama'titl un'jig, me' gesita'titl je mu amgwesewe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na assusit elgimatl igtigl ugtlugowinuml aq ne'pa'titl aq ewlumua'tiji pugwenniji igtigi wijei tela'laji. Matta'tiji ta'sijig aq siaw ne'pa'tiji igtigi. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Na nige' pas'g newgte'jilitl esgwielitl ta'n apgotgimaten, assusit newgtunatl uggwisl. Na nugu ugtejgewei elgimatl uggwisl, ta'n eimu'tijig nuji iga'taqu'tijig. Teluet, ‘Amuj na gepmitelma'tital ngwisl.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pas'g na nuji iga'taqu'tijig telimtultijig, ‘Ula na assusit uggwisl. Jugwita'gw aq ge' ne'pa'nej glaman ula iga'taqan ginuewe'tew.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na wesua'la'titl uggwisl aq ne'pa'titl aq tewajjiaqtua'tij wa'qi sitatug iga'taqanigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Se'sus pipanigesit, “Tala'tegetew nige, na ji'nm ta'n assutg iga'taqan? Jugu'etew aq ne'pa'taq wegla ji'nmug aq se'g eli mqatuigetoq ugtiga'taqan igtigi nuji iga'taqutiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Amuj gis egitmoq Gjinisgam ugtwi'gatign ta'n tel wi'gas'g? ‘Na gun'tew ta'n nujitaqatijig mo puatmi'tigup. Etna na ula gun'tew ta'n 'ms't goqwei mawn'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Na Gjisaqamaw gisite'tg'p ta'n gis tliaq, na we'gwi ula's'g.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na Lesui'paq iganpugultijig wejo'tmi'tij gisi ugsua'la'new Se'susal muta geitu'tij ta'n tel agnutmlitl, wesgumujig negmow. Pas'g jipala'tiji mimajuinu'g. Etna na ugjit naqala'titl aq ejiglita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na tujiw Lesui'paq iganpugultijig elgima'tiji te'siliji Palasiaq aq te'siliji Elot unaqapemg ugjit Se'susal gistesguanew ta'n tl mil pipanimataq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Na peita'liji aq telueliji, “Nujigina'muet, geitueg gi'l maw tetapu'en ji'nmuin. Geju'leg gi'l mo wen wessimawt ta'n teli angamgusij awna ta'n telgwitg uggamlamun. Gegina'muen teliaqeweigtug ta'n Gjinisgam tel puatg ugjit mimajuinu'g tla'taqatinew. Tliminen etug tetapu'eieg apangitmnen g'pnno'lewei suliewei. Amujpa apangitmegl gisna moqwa'?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pas'g Se'sus saputamaji ta'n getu tela'luj aq asitemaji, “Goqwei na gilew wet tla'taqatioq? Getu' gis te'sguioq? Ge' jugwa'tui na suliewei. Ge' angaptmug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na pegisitua'tij newgte' aq pipanimaji, “Wen ugsisgw aq ugwisunm wegla?” Teli asitema'titl, “G'pnno'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Na Se'sus teluet, “Na apangitmug g'pnno'l ta'n goqwei, g'pnno'lewei, aq apangitmug Gjinisgam ta'n goqwei Nisgamewei.” 'Ms't paqalaiagwi'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na tujiw alt Satusiaq peita'liji Se'suseg. Etna na negmow teluejig, “Ta'n tujiw mimajuinu gisi np'g ma' minunsigw.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Telima'titl, “Nujigina'muet, Mowiso'q gis wi'g'g'pneg tplutaqan ugjit ginu, ‘Ta'n tujiw ji'nm nepg aq naqalatl ugte'piteml toqo mo mijua'ji'j gegguna'tigwi na ji'nma ugjignaml amujpa malie'wi'titl na sigu'sgwal glaman gisi gugunataq mijua'ji'j ugjit na nepg'pnaq ji'nmaq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jijuaqato'q etna na ula lluigneg te'sipnig wijigatultijig ji'nmug. Mujga gisiguit malie'wit, mo pegitawsigwaq, nepgaq, aq mo mijua'ji'jg gis guguna'tigwi. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Toqo ap igtig malie'wititl na sigu'sgwal aq mu mijua'ji'jg gis guguna'tigwi nutaiw nepg. Ap wijei teliaq si'stewe'l ugjignamual. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Maw esgwia'tijig glapis lluigneg te'sijig wijigatultijig malie'wi'titl na e'pilitl. Gaqi npu'tijig aq mo mijua'ji'jg gegguna'tigwi. Na ugtejgewei na e'pit nepg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ta'n tujiw Gjinisgam apaji minua'laj npuinu'g maw ula ji'nmug aq e'pit aq mimajultitaq wa'so'q wen etug ugte'pitemital? 'Ms't lluigneg te'sijig malie'ulti'tipnn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Se'sus asitemaji, “Pa na pe'gaj mo tetapua'tiwoq aq mo geituoq ta'n goqwei ugjit! Mo geituoq Gjinisgam ugtwi'gatign aq Gjinisgam ugml'gigno'tim. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ta'n tujiw Gjinisgam apaji minua'laj ta'nig nepu'tilipni tlo'ltitaq 'st'ge' ansale'wijig wa'so'q. Ji'nmug aq e'pijig ma malie'ulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pa na pipanigesi's'p ta'nig nepu'tipni minua'lujig, amuj na egitmoq Gjinisgam ugtwi'gatign ta'n tel wi'gas'g ta'n Mowiso'q gis wi'g'g'p ugjit na nipispaqan etlamglegl aq mo taloqtenugul. Na na'te'l ewi'gas'g ta'n Gjinisgam telimateg Mowiso'q, ‘Ni'n na Gjinisgam ugjit Aplam, ni'n na Gjinisgam ugjit Isaq, ap ni'n Gjinisgam ugjit Je'gop.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na ula telueg, Negm na Gjinisgam ugjit ta'nig mimajultijig. Na telueg, ta'nig getlams'tasultipnig aq nepu'titgi'g, apaji mimajultijig wa'so'q. 'Lpa gilew ma'muniw oplia'tioq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na na'te'l eig's nujigina'muet tplutaqan, nutg's ta'n goqwei wesgutmli'tij. Nemiasnn Se'susal ignmuateg Satusiaq gelu'lg glusuaqan aq smtug eliet negmeg aq pipanimatl, “Tegen tplutaqan mawi espe'g te's'g?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Se'sus asitematl, “Etna na ula mawi espe'g. Nutmu'tigw Isle'lewioq, Gjisaqamaw Gnisgaminu pas'g negm Gjinisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Te's gamlamin amujpa gesalt Gnisgaminu Gjisaqamaw ta'n telgi'g ggamlamun, ta'n telgi'g 'gjijaqamij, ta'n telgi'g 'gtangita'suaqanm, aq ta'n telgi'g 'gml'gigno'tim. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na ula tapuewei ta'n mawi espe'g tplutaqan, etna na ula, amujpa gesaljig gigmaq st'ge' ta'n gi'l teli gsalsin. Mo eigtnug ap piluei 'tplutaqan teli espe'g st'ge' wegla tapu'gl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na nujigina'muet 'tplutaqan telimatl Se'susal, “Wel tetapuewistun, nujigina'muet. Teliaq ta'n teluen, pas'g Gjisaqamaw negm na Gjinisgam. Mo piluei igtig eimug pas'g negm. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Amujpa na mimajuinu te's gamlamij gesalatl Nisgaml ta'n telgi'g uggamlamun aq ta'n telgi'g ugtangita'suaqanm aq ta'n telgi'g ugml'gigno'tim aq amujpa gesalaji wigumaq 'st'ge' negm ta'n teli gsalsij. Gelu'sit wi'sis ela'l'j aq nu'gwa'lanew patgulmesigaqanigtug ugjit ignmugsin Gjinisgam aq ta'n te's'gl goqwe'l ignmatimgewei ugjit Gjinisgam, pas'g me' glultes 'gsalug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Se'sus pegene'watl ta'n teli ns'tuewistulij ta'n tujiw teli asita'puguelij aq telimatl, “Geget gisgaje'in ugjit Gjinisgam ilgwenmin.” Na toqo tujiw mo wen nugu tewjitagw pipaniman nugu Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ge's Se'sus etl gina'muej 'gjia'sutuo'guomg na etl pipanigesit, “Tal gis nujigina'mua'tijig 'tplutaqan gis teluejig, ‘Na newte'jilitl, ta'n Gjinisgam megnapnn ilgwenanew ugtmimajuinumg, wetagutmlitl Ta'piteg?’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na Wejuli Nisgam gisa'lapnn Ta'pito'q ta'n tluelin, ‘Gnisgaminu telimatl 'Ntnisgamum, Pa'si tet ntinaqanmg, glapis gisi iga'laqaj ta'nig getan'sgig, 'gpitng.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ta'pit na negm telui'tapnn, ‘'Ntnisgamum,’ tal gisi ugtaquttew Ta'piteg?” Na pugwelgig mimajuinu'g nutua'titl Se'susal aq wels'tua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ge's etli wesgumuj telimaji, “Angweiug wegla nujigina'mua'tijig 'tplutaqan! Al'ta'jig i' tli ntuisga'ti'tij, tel gnesultijig me' na mimajuinu'g nmia'titaq aq gepmite'lma'titaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Gisgatnmu'jig mujgajewe'l mutputi'l ugjit negmow aq mujgajewe'l ugt'punual pestie'ulti'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wegla pepsitelma'tiji sigu'sgwaq aq wesua'tua'tiji pugwelgl ta'n goqwe'l sigu'sgwaq geggunmi'titl. Na tujiw pegiji a'sutma'tijig ugjit nmugsinew aq uli angamgusultinew. Ulmajo'ltitaq ta'n tujiw ilsumaj.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Se'sus pemgopit 'gjia'sutuo'guomg ta'n tepaw i' tepege'tij suliewei. Na pugwelgig milesultijig mimajuinu'g pugwelg suliewei tepo'tu'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na ewle'jit sigu'sgwaq pegising aq tepegetl tapu'gl suliewe'ji'tl pas'g tel tepawgti newgte' sent. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Na Se'sus wigumaji unaqapemg aq mawa'laji aq telimaji, “Telimuloq ula ewle'jit sigu'sgwaq me' pugwelg gis tepeget je mu 'ms't ala igtigig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Muta ala igtigig gisi iga'tu'titl aq me' piamie'tij milesuaqan. Negmow milesultijig, pas'g negm ewle'jit. Gaqtepegeteg ta'n te's'g goqweieg ta'n negm ugji mimajisoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ge's Se'sus pem jigla'sij 'gjia'sutuo'guomg newgte'jilitl unaqapeml teluelitl, “Nujigina'muet, ge' lapa'si! Ge' teli uli angamgugl wegla gun'tal aq tetuji gelu'lgl wen'ji'guoml.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Se'sus asita'puguet, “Nemituoqol wegla mesgi'gl wen'ji'guoml. Je ma newgte' gun'tew esgwianug ugt'pung muta 'ms't ta'n te's'gl gaq nista's'gt'tal.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tel gne'g Se'sus pemgopit gm'tnji'j teluisilitl Olipet, tetpaqiw 'gjia'sutuo'guomg. Na Pie'l, Ji'mej, Sa'n, aq Antle' ge's newgtamsiliteg peita'jig Se'suseg, ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","aq pipanima'titl, “Ge' tliminen ta'n tujiw na tliatew aq tliminen na gnugwaqan musga'tuin giasgiwewei iga'q ugjit wegla ta'n goqwe'l tliatal.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Se'sus poqji tlimaji, “Ango'tmug, mut wen lue'wa'lugsinew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Muta pugwelgtaq mimajuinu'g nwisunmg, wejgwita'taq. Tluetaq, ‘Ni'n na ula ji'nm, ta'n Gjinisgam megnapnn ilgwenataq ugtmimajuinumg, aq pugwennitaq mimajuinu'g ma'mun lue'wa'la'tiji.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mut sespete'tmnew ta'n tujiw nutmoq matntimgl tepaw gisna amaseg. Amujpa na teliaq pas'g na mo tl'ta'sultinew getu gaqiaq ugs'tqamu. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Etna na tujiw newgte' 'gjigan matntultitaq igtig 'gjigan. Aq newgte' elege'wagi matntultitaq ap igtig elege'wagi aq 'ms't tami matntultitaq. Ugs'tqamu el maja's'gt'tew 'ms't tami aq iga'tew pestmo'qon. Ta'n tujiw wegla tliaq, na tujiw gilew 'gji'tutoqs'p geget gespaqami'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Amujpa gilew angweiasultioq muta ugsua'lugsitoqs'p aq ilsumugsitoqs'p ta'n i' tli ilsumuj. Tl mattoqsitoqs'p a'sutuo'guoml. Na toqo tujiw tli ilsumugsitoqs'p nuji iganpugultijig aq elege'wijig muta majulgwalioq ni'n glaman gis tlimatoqs'p negmow gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amujpa na gelu'lg glusuaqan amgwesewei gegnua'tujig ta'n tel mil agnutmu'tijig mimajuinu'g, ta'n telgi'g ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ta'n tujiw ugsua'lugsioq, aq pija'lugsioq, aq ilsumugsioq, mut igan sespeta'sultinew ugjit ta'n tlua'titoqs'p. Ta'n tujiw tetaputesg iga'q Gjinisgam ignmugsitoqs'p na tujiw ta'n tlua'titoqs'p. Ma gilew e'wmuoq 'gglusuaqanmual. Wejuli Nisgam, 'gtinnewaq eig, tl ewistutew ugjit gilew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mimajuinu gisa'latal wijigumatl ne'po'qsilin. Aq ujjuaq wijei tla'lataq un'januaq, un'januaq masgelma'titaq ungi'guaq aq gisa'lataq ne'po'qsilin. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","'Ms't wen masgelmugsitoqs'p muta ni'neg tleiaultioq. Ta'n tegen mimajuinu gisipugutg glapis ugtejgewei. Na negm Gjinisgam ugs'tawiatal.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nmitutoqs'p metu angamgusit gaqamit ta'n mo teltenug 'lpa pe'gaj i'mn. (Ta'n wen egitg 'ns'tasij ta'n goqwei telueg.) Na toqo tujiw ta'n wenig eimu'tijig Jutia amujpa elsumultijig soqoqamigeg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pa na wen wiguaq gujmug eig's, toqo na tliaq, mut pisgwa'iwij lamguomg nemisgmn nat goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Pa na mimajuinu eig's iga'taqanigtug, mut apsgwa'siwij wiguaq, aq tua'tuij utapsun. Amujpa na smtug nangamisgoqia. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mawi mtue'tew na na'gwegl ugjit e'pijig ta'nig getu un'janultijig (wenig mijua'ji'jue'gatijig) aq ugjit e'pijig ta'nig apje'ji'jultiliji mijua'ji'jg gegguna'tiji ta'n tl pma'lataq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gjinisgam tawaqtmug ugjit mo tlian miawipug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mawi mtue'tew negla na'gwegl me' ap aji mtue'tal ta'n menaq ugs'tqamu teli gji'tas'gtnug's ap ma nugu tlianug. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Gatu Gjisaqamaw gisita'sit toqwaqji'ja'tun negla na'gwegl je mu 'ngute'jiwisoq westa'taq. Etna na ugjit ta'nig gisi mgnaji mimajuinu'g, wet tla'teges na. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Pa na wen telimugsioqs'p, ‘Ula tet eig Nujiugs'tawi'wet, ta'n Gjinisgam petgimapnn ugjit ilgwenan Nisgam ugtmimajuinumg!’ gisna, ‘Ala eig!’ Mut 'gtlams'tmu'tinew! ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ne'ita'taq nujiegsupugua'taqatijig tluetaq, ‘Ni'n na ula ji'nm ta'n Gjinisgam megnapnn ilgwenataq ugtmimajuinumg,’ aq nujiegsupugua'taqatijig iganigjitegewinu'g. Uggnugwaqanmual aq paqalaiwaqann gis tla'taqatijig getu gistesgua'tiji Gjinisgam ugtmimajuinumg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Angweiasultigw! Gis igan tlimuloqop.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ta'n tujiw metue'gl na'gwegl gaqiaq, na na'gu'set 'mgatawa'sitew aq tepgun'set ma piam wasoqwegw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Gjinisgam pepuetestutew 'ms't goqwei musigisg'tug aq gloqowejg ma wijei tl pmita'gwig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na tujiw ni'n, na ula ji'nm ta'n Gjinisgam petgimapnn, alugwigtug jugu' neia'sites. Ntmlgigno'tim aq ntgepmite'lgaqanm guguntes aq paqtasites. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","'Pgotgima's 'ntansale'witemg ta'n telgi'g ugs'tqamu aq mawo'lataq ta'n Gjinisgam gisi mgenaji ugtmimajuinumg, ta'n telgi'g ugs'tqamu.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ignmu gina'mulin ula pi'gmenaqsi. Ta'n tujiw nipispaqan nigwegl aq menajejgl poqji nipi'juaq, na gji'jituoq geget nipg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pa na wijei ta'n tujiw nemituoq wegla goqwe'l tliaq. Na tujiw gji'tutoqs'p tepaw eig aq ugs'tqamu gaqian. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Migwite'tmu'tigw ula! Mimajuinu'g ta'nig nige' mimajultijig ma nepu'ti'gw glapis ula 'ms't gaq tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Wa'so'q aq ugs'tqamu gaqiatew gatu ni'n 'nglusuaqanml 'lpa iapjiw ma gaqianugl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Gatu mo wen geitug na na'gweg gisna ajiet ta'n tliatew, je mu ansale'wijig wa'so'q, je mu ni'n Gjinisgam uggwisl, pas'g nujj geitoq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ango'tmug aq jigo'tmug muta mo geituoq ta'n tujiw tliatew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pa na wijei aq ji'nm ta'n ejigla'sit wiguaq aq iga'laji ugtlugowinumg iganpugultinew, ala wen newgte'jit ugtlgowaqan elugwatg, aq telimatl ga'qan nujo'tg, ‘Siaw wapi!’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pa na wijei telimuloq, ‘Gisgajo'ltigw aq ango'tmug muta mo geituoq ta'n tujiw Gjisaqamaw 'pgisintew etug jel wela'gewe'le'l, gisna aqtatpa'q gisna ge's wejgwapniaq gisna wejgu segewa't na'gu'set. ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Gatu jiniw pgisintew, mut we'jugsinew nep'tioq!’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ta'n goqwei telimuloq 'ms't telimgig, ‘Siaw lugutigw aq ango'tmug.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Etna na tapugunaqt'tew pestie'umg ugjit Siawa'timgewei ta'n e'wmi'tij pipnaqan mo apita'tas'gtnug. Iganpugultijig patlia'sg aq nujigina'mua'tijig 'tplutaqan gwilmi'tij ta'n tl gimiw ugsua'lataq Se'susal aq ta'n tl ne'pa'taq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Telimtultijig, “Ma gis tla'taqati'gw pestie'umg, ta'n tujiw pugwelgig mimajuinu'g tet 'gjigan eigig. Jijuaqa 'ms'gi'gt'tew goqwei pegwatu'tij.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Se'sus Simon wiguaq eig's Pettanieg. Simon tel maliguitut, “Leplsiewinu'j,” pas'g gisi npisit. Ge's Se'sus etlatalg, e'pit pisgwa'latl gun'teweie'l pu'taiji'tl waju'pelitl ta'n mawi mgo'tig amjaqto'suti. Wejitas'g poqtaqiaq nalt. Na panta'latl pu'taiji'tl aq guta'tuaj amjaqto'suti Se'susal un'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Alt mimajuinu'g wegaiultijig aq telimtultijig, “Goqwei weji e'wmaj aq goqwei wet tl pisuo'tg gelu'lg amjaqto'suti? ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gisi ntuisgetas'gt'soq ugjit panaemg tepawgti newgtipunqegewei suliewei ganie'wisoq aq suliewei ignmuanes ewle'juinu'g!” Majiaqta'titl ma'muniw na e'pilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Gatu Se'sus teluet, “Punajimug na e'pit! Goqwei weji ulgowaqana'loq? Maw gelu'lg ta'n tela'tegej ugjit ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Iapjiw ewle'jultijig mimajuinu'g wijitgweiugsitoqs'p aq ta'n pa tujiw gisi apoqonmuatoqs'p. Gatu ma ni'n iapjiw gis wijitgweiul. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ula e'pit tela'teget ta'n tel we'gwisipgwatoq. Gis guta'toq amjaqto'suti nun'jig gisgaja'tuij ta'n tli utquta'liten ugjit me' enmina'gweg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nige' migwite'tmug ula! Ta'n tet tami gelu'lg agnutmaqan etl wi'tas'g ta'n telgi'g ugs'tqamu, na e'pit ta'n gis tla'teget ugjit ni'n, migwite'lmaten ugjit negm.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na smtug Suta, newgte'jit wegla newgtisgegsiliji je ta'pu unaqapemg elieji iganpugultijig patlia'sg aq telimaji, “Ni'n apoqonmultoqs'p ta'n teli ugsua'loq Se'sus.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wel'ta'suala'titl ta'n tel nutua'tij teluelij aq tepluma'titl ignmuanew suliewei. Toqo poqji angapteg ta'n tli ugsua'latal Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na amgwesewei na'gweg pestie'watmi'tij ta'n e'wmi'tij mo apita'tas'gtnug pipnaqan, ula na na'gweg jijgluewji'jg ne'po'jig ugjit na pestie'umg. Se'sus unaqapemg pipanima'titl, “Tami pualieg 'lta'nen aq gisgaja'tunen ta'n tli uloqotalultitesnu?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Na Se'sus tapusiliji poqjigimaji aq telimaji ta'n tla'tegelitaq. “La'tigw gutang aq ji'nm pemapilatl mesgilitl samqwano'qol waju'pelitl, ultesgugsitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Majulgwalatoqs'p na wen'ji'guom aq pisgwa'j. Tlimatoqs'p assusit na wen'ji'guomg, ‘Nujigina'muet teluet, Tami tet gisgatteg ta'n nnaqapemg aq ni'n tli uloqotalultitesnen Siawa'timgewei?’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Musga'tugsitoqs'p ge'gwe'g ta'n mesgi'g newgtse'g weli gisgaja'tas'g. Na'te'l gisgaja'tutoqs'p ta'n tli uloqotalultitesnu.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na unaqapemg maja'tiliji, ela'tiliji gutang aq 'ms't goqwei we'jitu'tilij ta'n Se'sus telimapni aq gisgaja'tu'tilij Siawa'timgewei wela'gewei. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na wela'gw Se'sus pegising aq unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ge's p'tautigtug etlatalulti'tij, Se'sus teluet, “Ni'n telimuloq, newgte'jit te'sioq ta'n mawatalultieg gegnugwalitew ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Toqo unaqapemg mo welgwijultiligwi aq poqji pipanimgwi'titl ala wen ap igtig, “Etug ni'n?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Se'sus asita'puguet, “Etna na newgte'jit te'sioq, newgtisgegsioq je ta'pu, ta'n mawatalultieg aq getapegwija'toq ugpipnaqanm wijei eptaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ni'n, na ula ji'nm ta'n Gjinisgam petgimapnn, amujpa na 'np'tes st'ge' nige' ta'n tel wi'gas'g Gjinisgam ugtwi'gatigng na tliatew, gatu mawi mtue'tew ugjit na ji'nm ta'n getu 'ntuisgalitew ni'n, na ula ji'nm ta'n Gjinisgam petgimapnn. Me' etug gelu'lgtesoq ugjit na ji'nm pa mu ugs'tqamuigusnn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ge's etlatalulti'tij Se'sus wesua'toq pipnaqan, a'sutmat aq miwatmuatl Nisgaml. Sewisgina'toq pipnaqan aq ignmuaji unaqapemg. Teluet, “Ula na na'qi. Ugsua'tug aq malqotmug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wesua'latl gupji'tl aq miwatmuatl Nisgaml. Elasgnmuaji aq 'ms't wijei wet samqwo'ltiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Se'sus teluet, “Ula na nmal'tem. Ta'n tl gaqigunia's ugjit pugwelgig, musga'tutew ta'n Gjinisgam teli tplumapni mimajuinu'g, na tliatew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ni'n telimuloq, 'lpa ap nugu ma samqwaw ula moqopa'q, glapis na na'gweg samqwa's na pilei moqopa'q ta'n Gjinisgam etli elege'witewit.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na tujiw a'sutmewintu'tijig. Tewita'jig aq el'ta'jig gm'tnigtug teluisig Olipet. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ge's pemita'tij, Se'sus telimaji, “'Ms't gilew ugsumultitoqs'p aq 'nqalitoqs'p. Geitu na tliatew muta gis tel wi'gas'g Gjinisgam ugtwi'gatigng, ‘Gjinisgam ne'pa'tal newgte'jilitl ta'n jijgluewjig nuji angwe'waji aq jijgluewjig se's'tesguaten.’ ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ta'n tujiw Gjinisgam gis minua'lij ni'n, igan lia's Galali.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pie'l asita'puguet, “Ma ni'n puna'lu tlia esgwia'tijig puna'l'sgig.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Se'sus telimatl Pie'lal, “Migwite'te'n ula! Na ge's mu napew ta'pu getu'gw, gisgatatpa'q, gi's gi'l si'st tluetes mo nenuiwn ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pie'l asita'puguet aq naji ml'gapuguet, “Mo eigtnug tluen ni'n mu nenu'lu je tlia 'npman maw gi'l.” Na 'ms't unaqapemg wijei telua'tiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na peita'jig na'te'l telui'tmi'tij Getsemani aq Se'sus telimaji unaqapemg, “Pita'gw tet gijga ta'n teli pgiji a'sutmai.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na tujiw wije'waji Pie'lal, Ji'mejal, aq Sa'nal. Na poqji ewlgwijing aq welmajigwetutg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Telimaji, “'Lpa teli ewlgwija'si 'lpa telo'tm geget gaqsuisga'si. Na ula tet i'mu'tigw aq ango'tmug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Me' naqajijge'le'l eliet aq mesganaqalsit maqamigeg. A'sutmat etug jel ma 'gji saputa'sigw wegla 'lmajo'qon. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na eli a'sutmatl, “Nu', Tata't! 'Ms't goqwe'l mo metue'gtnugl ugjit gi'l. Pipanimul jigla'tuin ulmajo'qon. Gatu mut tla'tegew ni'n ta'n tel puatm, pas'g gi'l ta'n tel puatmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ta'n tujiw apaja'sij we'jiaji nesisiliji unaqapemg nep'tiliji aq telimatl Simon Pie'lal, “Simon me' nepan? Mo gisi ala'piwn newgte' ajiet?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Se'sus telimaji, “Angaptmu'tigw aq a'sutma'tigw glaman ma 'l nisia'tiwoq elue'utigtug. Getu' tla'taqatioq pas'g mo gis tla'taqatiwoq muta wesami gtugsultioq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mjit ap newgt Se'sus naji a'sutmat teluetl wije'l glusuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ta'n tujiw apaja'sit unaqapemg we'jiaji nep'tiliji. Na tetuji gtugsultijig je mu ugpugugual gis pantenmi'tigul. Ta'n tujiw tugwia'tiliji mo geitu'ti'gw ta'n tlima'tisnn. Se'sus ap naji a'sutmat. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ta'n tujiw ap si'stewei apaja'siteg na telimaji, “Tepiaq ta'n teli atlasmultioq. Na ajiet iga'q aq ni'n, na ula ji'nm ta'n Gjinisgam petgimapnn, iga'limg lue'winu'g ugpitnuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mn'jita'gw aq maita'nej! Na ji'nm ta'n gisi ntuisgalit pegising!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Me' Se'sus etlewistoq ta'n tujiw Sutaal, newgte'jilitl unaqapeml, pegisinnitl. Pugwenniji mimajuinu'g pema'tu'tilitl espo'qwas'gl aq petgute'gne'l pejuwije'wa'titl Sutaal. Iganpugultijig patlia'sg nujigina'mua'tijig patlia'sg, aq natawo'ltijig ji'nmug petgima'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Suta igan gnua'tuapni mimajuinu'g gnugwaqan. “Ta'n tegen ji'nm wesaqanm'g, etna na negm pualoq. Ugsua'lug aq jigla'lug melgigleiug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ta'n teli nqase'g Suta pegising elietl Se'susal aq teluet, “Nujigina'muet,” aq wesa'qanmatl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Smtug wesua'la'titl Se'susal aq melgigle'wa'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na newgte'jit te'sijig gaqamultijig na gettaqa'toq espo'qwas'g aq taqamatl espe'g patlia's ugtlugowinuml mente'muaj ugs'tuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na Se'sus gelusit aq telimaji, “Amujpa na gilew te'sisgegsioq wejgwita'ioq ta'n espo'qwas'gl aq petgute'gne'l ta'n teli ugsua'lioq ni'n 'st'ge' na ni'n na nuji opla'teget. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Te'sigisg'g ni'n wijitgweiuloqop. Pas'g ta'n tel wi'gas'g Gjinisgam ugtwi'gatign, amujpa na teliaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Toqo 'ms't unaqapemg naqalgwi'titl aq wesumultiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Etna na newgte'jit maljewe'j ji'nm ta'n tel gnesij pas'g poqtaqasgegl wape'gl aligal. Majulgwalasnn Se'susal aq negla getu gisapsgna'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pas'g na wesumugwalitl enmisge'litl, naqtmlitl aligal ugtejg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Toqo Se'susal ela'la'titl na espe'g patlia's wiguaq. Na'te'l ta'nig iganpugultijig patlia'sg, natawo'ltijig ji'nmug, aq nujigina'mua'tijig 'tplutaqan etl mawia'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pie'l gneg ugtejg pem majulgwalatl aq pisgwa't ugtiga'taqang ta'n espe'litl patlia'sl wen'ji'guoml gigto'qwagwegl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iganpugultijig patlia'sg aq 'ms't ilsutaqatijig getu we'jitua'tisnn ta'n goqwei ugtangutew Se'susal. 'Lpa mo goqwei we'jitua'ti'gw ta'n tli ilsutmuataq aq ta'n tl ne'pa'taq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pugwelgig pisui agnima'titl aq egsuaqanima'titl Se'susal. Pas'g mo wijei tel agnutmu'ti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na tujiw ta'sijig ji'nmug gaqamita'jig aq egsuaqanima'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nutaqatt'p teluep, ‘Suisgo'tutes ula 'gjia'sutuo'guom ta'n ji'nmug gisitu'tij aq gisi nsuguna'q ltutes newgte' ta'n mu ji'nmug gisitu'ti'gw.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Je mu negmow mo wijei tel agnutma'ti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Na espe'g patlia's gaqama'sit ta'n te'siliji eimu'tiliji aq mil pipanimatl Se'susal, “Gis taluetes nige', ta'n tel pisuisu't'mulg?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Gatu Se'sus mo me'tegw aq 'lpa mo gelusigw. Espe'g patlia's ap mil pipanimatl, “Gi'l na Nujiugs'tawi'wet ta'n Gjinisgam petgimapnn ugjit ilgwenan ugtmimajuinumg, sape'wit Gjinisgam uggwisl?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Se'sus teli asitematl, “E'e ni'n na. 'Ms't gilew nmiatoqs'p, ni'n na ula ji'nm ta'n Gjinisgam petgimapnn, ugt'pites ugtinaqanmg Gjinisgam ta'n mawignat aq nmitoqs'p alugwigtug wejgu nisa'si wa'so'q wejiei.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Na espe'g patlia's tel'ta'sit Se'susal alm'getmlitl Nisgaml. Mo wels'tmug aq smtug sewisgino'toqol utapsun. Teluet, “Gis tepiaq we'jitueg. Mu nugu wen puatasigw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nutuoq ta'n tel lue'wigl ugglusuaqanml. Tal'te'lmoq?” Smtug ilsuma'titl ugjit ne'po'qsilin. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ta'sijig eimu'tijig poqji lusgoma'titl Se'susal aq gep'joqpinmua'titl ugpugugul aq taqama'titl. Telua'tijig, “Ugji tetapuata ta'n wen gisi tqam'sg?” Sma'gnis paqtne'ita'titl aq matna'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pie'l me' eig iga'taqanigtug ta'n wen'ji'guoml gigto'qwagwegl ta'n tujiw na espe'g patlia's ugnugtoqtejgwejml newgte'jilitl pemielitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ta'n tujiw etli u'siliteg tetpaqi angamatl aq teluet, “Gi'l elg wijitgweia't'p Se'sus ta'n Nasalet tleiawit.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pas'g Pie'l petgwasit aq teli asita'puguet, “'Lpa mo geju'lu ta'n goqwei wesgutmn.” Na tujiw tewiet aq gaqamit gigjiw ga'qana'tas'g. Na tujiw napew getu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na nugtoqtejgwej nemiatl na'te'l aq poqji minu tlimaji wije'l glusuaqan weget gaqamultiliji, “Negm na ala.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pie'l ap petgwasit. Na tel gne'g ula gaqamultijig ap Pie'lal elsutmua'titl, “Gi'l ma gisi megtamun muta gi'l na negla te'sioq newgte'jin muta gi'l tleiawin Galali.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Na tujiw Pie'l teluet, “Ugtapulij Gjinisgam egsuen! Mo nenuaq na ji'nm ta'n wesgumoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na smtug ap tapuewei napew getu'g. Na Pie'l migwite'tg ta'n Se'susal telimt'pnn, “Ge's mu napew ta'pu getu'g, gi's gi'l si'st tluetes ‘mo nenuiwn.’ ” Ta'n tujiw angite'tgeg, na atgitemit. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ge'sg egsitpu'g iganpugultijig patlia'sg mawa'laji esgwia'tiliji iganpugultiliji ilsutmi'tij ta'n tla'lataq Se'susal. Smtug gelpila'titl ejigla'la'titl aq ignmua'titl Pilotal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilot pipanimatl, “Gi'l na Lesui'paq ugtelege'witemual?” Se'sus asitematl, “Gi'l na teliaq teluen.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Iganpugultijig patlia'sg elsutmua'titl Se'susal pugwelgl ta'n goqwe'l, pas'g Se'sus mo goqwei teluegw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilot ap mil pipanimatl, “Mo getu asita'pugueun? Nutman ta'n te's'gl goqwe'l gisi elsutmulgl.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Se'sus mu nugu goqwei teluegw. Na Pilot sigta paqalaig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Te's pestie'umg Siawa'timgewei Pilot iga'latl newgte'jilitl laplusang pisilitl ta'n tegen mimajuinu'g gluma'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na tujiw newgte'jit ji'nm, teluisit Palapas, laplusang pisit, maw igtigig wijitgweiwasnig. Negmow maw lugutipnig ta'n tel matna'tij iganpugultiliji aq ne'pa'tisni mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ta'n tujiw pugwelgig mawita'jig aq poqji pipanima'titl Pilotal ugjit tela'tegelin ta'n i' tla'tegelij. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilot pipanimaji, “Pualioq iga'lan Lesui'paq ugtelege'witemual ugjit gilew?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilot weli gji'toq iganpugultijig patlia'sg Se'susal ugpitnuaq iga'tua'tipnn muta gi's sa'q wisgua'la'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pas'g na iganpugultijig patlia'sg munsaiwa'tiji mimajuinu'g ugjit pipanigesultinew Pilotal iga'lan Palapasal ugjit negmow. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilot ap gelulaji mimajuinu'g, “Gatu tal pualioq tala'lan newgte'jit telui'toq, ‘Lesui'paq ugtelege'witemual?’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na apaji sesgu'tijig, “Gujjiewto'q!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilot pipanimaji, “Gatu goqweieg ta opla'toqosneg?” Me' naji gsigawa'tijig, “Gujjiewto'q!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilot getu tetapua'laji mimajuinu'g. Na iga'latl Palapasal ugjit negmow. Iga'latl Se'susal sma'gnisg ugpitnuaq ugjit mattoqsilin aq gujjiewto'qsilin. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sma'gnisg ela'la'titl Se'susal iga'taqanigtug, ta'n g'pnno'lewei wen'ji'guom gigto'qwapaqteg. Na esgwia'tijig sma'gnisg wigumaji aq mawita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sma'gnisg Se'susal nasa'tua'titl megwi ewne'litl pitu'gunn pitoqsilitl. Goqominaqsiei el'tu'tij piptugwaqig aq nasa'tua'titl un'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na poqji gaqametesultijig aq matgwetua'titl. Telima'titl, “Wel'ta'si ta'n tel nemu'l Lesui'paq ugtelege'witemual!” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Taqama'titl un'jig gmu'j, elusguma'titl, nutgul'pa'sultijig aq emtoqwala'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Na ta'n tujiw maligima'titeg menatua'titl megwi ewne'litl pitu'gunn, apaji nasa'tua'titl utapsunn. Na tujiw ela'la'titl ta'n tl gujjiewta'taq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ge's pemita'tij asugua'titl ji'nmul, teluisilitl Simon, tleiawilitl Sailin. Uggwisg na Alegsantel aq Megwatpat. Pem lielitl 'gjigang. Gi'gaja'la'titl pma'pinmilin Se'susal uggujiewe'm. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Se'susal pegisula'titl ta'n teluisig Golgota na telueg, “Teli angamgug 'st'ge' waqan'tewatpat.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Se'susal getu ignmua'tipnn moqopa'q wiaqa'tas'g 'mpisun teluisig mul, mu tli ulmaje'n, gatu Se'sus mo esamqwawgup. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Na tujiw sma'gnisg gujjieweigtug nasta'titl. Toqo wesua'tua'titl utapsun te's i' newgte' elaqatijig nmitunew ta'n wen ingutei ugtete'tew. Etna na tel nasgwa'tatultisnig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Panaemg pesgunateg ajiet egsitpu'g ta'n tujiw gujjiewta'titeg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ula na gnugwaqan ta'n tel pisuimuj nasa'tua'tij uggujjiewe'm, ewi'gas'g, “Lesui'paq ugtelege'witemual.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tapusijig gmutnesg gujjiewto'jig maw Se'susal, newgte'jit inaqaneg aq igtig patatujg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na teliaq ta'n Gjinisgam ugtwi'gatign tel wi'gas'g'p, “Mawa'lut maw gmutnesg.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na mimajuinu'g pemita'jig pepuegetitl un'jiwal aq maligima'titl Se'susal. “Na! Gi'l getu seioqte'mu's'p 'gjia'sutuo'guom aq gisi apaji 'ltutes nesuguna'q. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ge' nisa'si nige' na gujjieweigtug. Ugs'tawi'si gi'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pa na wijei iganpugultijig patlia'sg aq nujigina'mua'tijig 'tplutaqan maligima'titl Se'susal, telimtultijig. “Gisi ugs'tawiaji igtigig, pas'g negm mo gisi ugs'tawi'sigw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ge' angamanej, Isle'lewaq ugtelege'witemual, Nujiugs'tawi'wet. Nisa'si gujjieweigtug nige'. Na tujiw 'gtlams'tultesnen.” Na ula tapusijig, gujjiewto't'pnig maw Se'susal, elg maligima'titl aq ewnasima'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ta'n tujiw mewlia'gweg iga'q ta'n telgi'g ugs'tqamu oqonitpaqamugwa's'g nesisgl ajietl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na tujiw Se'sus sesgwet aq teluet, “Eloi, Eloi lama sabachthani?” Na telueg, “'Ntnisgamum, 'ntnisgamum, tal gis puna'lin ni'n?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Te'sijig mimajuinu'g eimu'tijig nutua'titeg teluejig, “Ge' jigs'tug, wigumatl Ilaijaal.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Newgte'jit ta'n 'spanj gisi gwija'toq moqopa'qigtug aq gis iga'toq pita'q gmu'jigtug elasga'tuaj Se'susal ugtung. Teluet, “Pe'l angamanej Ilaija jugu'en aq nisa'lan gujjieweigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Na Se'sus gesigawwet aq nepgaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Etna na ula gesgug atla'wegn tmsaqign 'gjia'sutuo'guomg gaqapitg. Na telgi'g's asugom te'sisga'q leppie aq nesisga'q leppie tel pita'q. Nasgwa'toq ta'n eteg 'gjisape'uti. Ta'n tujiw Se'sus nepgeg weji pqoji suisgina's'g g'p'taq glapis epune'g. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na igantug gujjieweigtug sma'gnis iganpugutuaji gaqamit, nemiateg Se'susal ta'n tujiw gesigaw sesgweliteg aq nepliteg. Teluet, “Ula ji'nm teliaq Gjinisgam uggwisaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Eimu'tijig pugwelgig e'pijig, ta'n gneg wetama'titl Se'susal nepliteg. Wijitgweiwa'tiji Salom, Mal Matle'n, aq Mali ta'n uggwisg, na maw maljewe'juit Ji'mej aq Josi. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Majulgwala'tisnn Se'susal ge'sg eimliteg Galali aq apoqonmua'tipnn. Pugwelgig igtigig eimu'tijig ta'nig el wije'wa'tisnn Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Etna na na'gweg ta'n ilajugtmi'tij atlasmutigisg'g. Pemi ula'gewe'le'l ta'n So'sep Alimatiaewaj pegising. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Maw gtlamite'lmut ula iganpuguit. Ne'gaw esgmalatl na na'gweg ta'n tujiw Nisgaml 'pgisinnital aq ugtmimajuinumg ilgwenataq. So'sep melgita'sit, elietl Pilotal naji glutmuatl Se'susal wa'qi. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilot paqalaig ta'n tujiw nutg Se'susal gisi npilin. Na wigumatl sma'gnisl iganpuguilitl aq pipanimatl, “Na teli nqa'si 'np'gaq Se'suso'q?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ta'n tujiw nutg iganpuguilitl ta'n teluelij, Pilot telimatl So'sepal, “Gisi ugsua'tuates wa'qi.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","So'sep pegwatelg wape'g atla'wegn. Nisa'tuaj wa'qi aq atla'wegnigtug te'tepjepilatl. Pisgwapilatl elmalqe'g ta'n gisitu'tip gun'tewigtug aq na'te'l elsma'latl. El'te't'pja'toq mesgi'g gun'tew gep'joqwa'tmn ta'n weji pisgwa'lut'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tapusijig e'pijig eli angama'titl ta'n Se'susal elisilij. Mal Matle'n aq Mali ta'n uggwisg Josial aq Ji'mejal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ta'n tujiw gi's galgwasiet, na atlasmutigisgug gaqiaq, Mal Matle'n, Salom, aq Mali na Ji'mej aq Josi uggwijuaq pegwatelmi'tij weljema'gewei, ta'n guto'tuataq Se'susal wa'qig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ge'sg egsitpu'g aqantie'umg, na'gu'set pemsegewa'j, el'ta'jig ta'n Se'sus etli utquta'lut'p. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ge's pemita'tij telimtultijig, “Wen te't'pja'tutew na gun'tew ugjit ginu weji pisgwa'timg ta'n etli utquta'lut'p?” ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Na mawi ms'gi'g gun'tew. Na ta'n tujiw nepsapati'tij nemitu'tij gun'tewe'g gis jigla'tas'gs'pneg. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pem pisgwa'tijig ta'n etli utquta'lut'p. Nemia'titl na'te'l maljewe'j ji'nm epilitl inaqaneg. Nasg'gl wape'gl aligal aq maw we'gwata'sultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Telimaji, “Mut we'gwata'sultinew. Al gwiluoq Se'sus, Nasaletgewa'j, ta'n gujjiewto't'pnaq. Mo tet eimug gis minunsitaq! Angaptmug! Ula tet elising'pnaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","'Lta'gw gnua'tug unaqapemg maw Pie'l, Se'sus igan lietew Galali. Na'te'l tl nmiatoqs'p 'st'ge' ta'n telimugsioqop.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na tewita'jig aq ejigltugultijig ta'n etli utquta'lut'p muta tel jipaqita'jig aq we'gwata'sultijig. Mo wenn telima'tigul goqwei muta tel jipasultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ge'sg egsitpu'g aqantie'umg Se'sus minunsiteg, tmg neia'sitl Mal Matle'n, ta'n lluigneg te'siliji mn'tu'g tewaqtesguapni. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mal Matle'n eliet ta'n Se'sus unaqapemg eimu'tijig ta'n etl ewlgwijultijig aq etltemultijig. Telimaji negm nemiapnn Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ta'n tujiw nutua'titeg telueliteg Se'sus mimajit aq negm nemiapnn, mu getlams'tua'tigul. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tel gne'g ge's pemla'tilij gutang, tapusiliji unaqapemg Se'sus ap piltu neialsit aq mo nenagwi'tigul. Amgwesewei nemia'titeg pas'g tel gne'g sapama'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ula apaja'tijig aq telima'tiji igtigig, pas'g na igtigig mo getlams'tmi'ti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Glapis ugtejgewei Se'sus neialsit wegla newgtisgegsiliji jel newgt unaqapemg ge's etlatalulti'tij. Majiaqa'laji muta mu getlams'tmu'ti'gw aq melgasultijig. Mu getu jigs'tmu'ti'gw ta'nig nemia'tipnn mimajilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Telimaji, “'Lta'gw ta'n telgi'g ugs'tqamu, ta'n te'sit mimajuinu'g se'sa'tug gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ta'n wen getlams'tg aq sign'tasij. Gjinisgam ugs'tawiatal. Ta'n wen mu getlams'tmug, ulmaji ilsutasitew. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ta'nig getlams'tmu'tijig tla'taqatitaq wegla melgignaqal paqalaiwaqann: wegla 'gtaqqatesguataq mn'tu'g 'nwisunm aq piltui'sultitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pa na gis unaqa'la'tij 'mtesgmu gisna samqwoltijig ta'n goqwei ne'pa'gutaq, ma tala'lugwi'ti'gw. Iga'tuataq ugpitnual gesnugu'tiliji na ilita'taq.” ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ta'n tujiw Gjisaqamaw Se'sus gis glulateg, wa'so'q ela'lut. Pemgopa'sit ugtinaqaneg Gjinisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na unaqapemg maita'liji aq gina'mua'tijig 'ms't tami. Gjisaqamaw Se'sus maw lugutijig, neia'tuanew ta'n tel gina'mua'ti'tij teliaqewei ta'n teli ignmuaj ml'gigno'ti gis tla'taqatijig mesgi'gl ta'n goqwe'l.");
INSERT INTO micMIQNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nitap Tiopilus, pugwelgig mimajuinu'g wejo'tmi'tip wi'gmnew agnutmaqan ta'n goqwe'l gis tliaqapnn tepaw ta'n eimu'tieg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ewi'gmi'tipnn ta'n goqwe'l igtigi telimugsieg'pnn. Negla nemitu'tilipnn ta'n goqwe'l teliaqapnn weja'tegemgeg Sa'n Nutsign'tuet ugs'tqamuip glapis nige' aq telimugsieg'p ula gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Saqamaw, gis sangew gina'masiapnn wegla ta'n goqwe'l teliaqapnn weja'tegemgeg na tujiw glapis nige'. Tel'te'tm gi'l getu' gji'tun glaman pemgopi aq ewi'gmul ula agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ula wet tla'tegei glaman 'gji'tutes giasgiwowei wegla ta'n goqwe'l gegnu'tmugsipnn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na ge's Elot elege'witewip Jutiaewa'gig, na tujiw Saglaia na patlia'suit. Wetapegsit na patlia'saq ta'n teluisipnaq Apaija. Ugte'piteml teluisilitl El'sapet. Ula e'pit wetapegsit A'lano'q. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Gitg apjiw tela'tegejig ta'n Gisiteget tel puatg. Getlamiejig aq apjiw getlams'tmi'tij Nisgamewei tplutaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mo mijua'ji'jg gegguna'tigupni muta El'sapet mo gisi un'janigup. Nige' gitg wel gisiguijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Newtejgeg na'gweg ge's Apaijaewa'jg elugowa'titl Gjinisgaml a'sutuo'guomg, na tujiw Saglaia nigani a'sutmat. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na patlia's ta'n nigani a'sutmat ignmut nu'gwa'tun weljema'gewei patgulmesigaqanigtug. Glaman Saglaia megnut aq eliet gjia'sutuo'guomg ta'n Gisitegelitl emtoqwala'titl, ugjit weljema'gewei nu'gwa'tun. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na gujmug mimajuinu'g etli a'sutma'tijig ge's Saglaia etl nu'gwa'toq weljema'gewei. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na Gisiteget ugtansale'witeml neia'silitl aq gaqamilitl inaqaneg patgulmesigaqanigtug ta'n nu'gwa'tas'g weljema'gewei. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ta'n tujiw Saglaia nemiaj sespeta'sit aq jipasit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Gatu na ansale'wilitl telimtl, “Saglaia, mut jipasiw. Gjinisgam gis nutmasg gta'sutmaqanm. Gte'pitem, El'sapet, gugunatal lpa'tujl aq tl wi'tatoqs'p Sa'n. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na tujiw ul'ta'sites aq no'q ulgwijintes. Pugwelgig mimajuinu'g ul'ta'sultitaq ta'n tujiw ugs'tqamuilitew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gisiteget gepmite'lmatal. Ma esamqwagw moqopa'q gisna pugtewijg. Weja'tegemg ugs'tqamuitew gugunatal Wejuli Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Gisa'lata pugwenniji mimajuinu' Lesui'pe'gatig lita'sualanew Gisitegelitl na Gjinisgaml ta'n emtoqwala'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Lietew aq pestuntew ge's mu Gjisaqamawl poqji pestunmlitl. Msntew na ml'gigno'ti ta'n wejiaq wa'so'q aq ml'gignatew st'ge' na niganigjitegewinuaq teluisipnaq Ilaija. Gisa'lata mimajuinu'g apaji gsalata un'janua. Gisa'lata na mimajuinu'g ta'n mo getlams'tua'tigul Gisitegelitl gtlams'tuanew aq tla'taqatinew ta'n gigwajiaq. Gisa'lata mimajuinu' gisgajo'ltinew ugjit ta'n tujiw Gjisaqamaw pgising.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Saglaia telimatl ansale'wilitl, “Tali gji'tu ms't ula tlian. Gisigui aq nte'pitem na gisigui'sgw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ansale'wit telimatl, “Teluisi Gapliel. Ni'n na Gjinisgam uglugowinuml aq petgimit ugjit tlimulin ula gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mo getlams'tmun ula ta'n gis tlimul. Na ma gisi glusiwn glapis na na'gweg iga'q ta'n ms't gaqiatew st'ge' teli tplumulap.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na mimajuinu'g ta'n eimu'tijig gujmug etli esgmala'titl Saglaiaal. Angita'sultijig tal gis teli pgitgatg na gjia'sutuo'guomg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ta'n tujiw tewiej mo gis glulagwi. Na mimajuinu'g gejia'titl na gis nmitulipnn nat goqwei gjia'sutuo'guomg. Saglaia amujpa ugpitnn e'w'gl ugjit gnua'tuan, muta mo gis ewistugw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ta'n tujiw ugtlugowaqan gaqiaq a'sutuo'guomg Saglaia enmiet wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na tel'gne'geg ugte'piteml tele'litl. Mo naqtmligw wiguow na'nijig tepgun'seliji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","El'sapet teluet, “Gisiteget gisi apoqonmuit aq wel'te'lmit. Na ejigla'tuit ntaqo'qonmeg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Asugom tepgun'sejig El'sapet gis tele'g'p, na tujiw Gjinisgam elgimatl ansale'wilitl teluisilitl Gapliel na gjigan teluisig Nasalet, ta'n eteg Galaliewa'gi. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Na agnutmaqan pegisitoq ugjit e'pite'sl teluisilitl Mali. Mali gisi tplumtijig malie'winew ji'nmul teluisilitl So'sep. Na ji'nm wetagutg na elege'witaq teluisipnaq Ta'pit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na tujiw neia'sit ansale'wit aq telimatl Malial, “E'pite's, telimul gelu'lg agnutmaqan muta Gisiteget wijitgweiasg aq maw gepmite'tasin.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mali sespeta'sit ta'n ansale'wilitl gis tlimtl muta mu nestmug na agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na ansale'wit telimatl, “Mali, mut jipasiw muta Gjinisgam gepmite'lm'sg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tle'tes aq ugs'tqamua'lates mijua'ji'j. Tl wi'tates Se'sus. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Gepme'tew aq tl wi'taten na Gjinisgam uggwisl. Gjinisgam na Gisiteget ignmuatal elege'witewilin st'ge' Ta'pito'q ta'n negm wetapegsit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iapjiw niganpugutuata ta'ni wetapegsultiliji Je'gopo'q. Iapjiw elege'witewitew aq ugtelege'wa'gim iapjiwtetew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mali pipanimatl ansale'wilitl, “Tal gis ula tliatew, menaq tepqatmu?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ansale'wit telimatl, “Wejuli Nisgam nisa'sitew gi'leg. Na mawi espe'g Gjinisgam ugml'gigno'tim guguntes aq gisa'lulten tle'n. Na mijua'ji'j sape'witew aq tl wi'taten Gjinisgam uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Teluemg'p na go'gumaw, El'sapet, ma gis gugunagwi mijua'ji'jg. Gatu telimul, na asugom te'sijig tepgun'sejig gi's tele'g aq gugunatal lpa'tujl, je tlia tel gisiguij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Muta mo eigtnug goqwei ta'n Gjinisgam mo gis tla'tegegw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mali teluet, “Ni'n na Gisiteget elugowg. Tliaj ni'neg ta'n gis tluen.” Na tujiw ansale'wilitl naqaltl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na tel'gne'ge'l Mali ilajit aq smtug eliet na gjigan ta'n etl milqamigeg Jutiaewa'gi. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pisgwa't Saglaia aq El'sapet wiguow aq gelulatl El'sapetal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na El'sapet tel nutuaj Malial, na mijua'ji'jl jiniw maja'silitl ugtlaminug. Na tujiw Wejuli Nisgam pija'sit El'sapeteg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","El'sapet gesigawwet, “Gjinisgam me' wel'te'lm'sg je mu igtigig e'pijig aq pajiji ul'te'lmutew na mijua'ji'j ta'n gugunates. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","No'q gelu'lg ta'n teliaq Gjisaqamaw uggwitl peji mittugwalit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nqasaiw nutu'laneg, nn'jan maja'sip ntlaminug muta wel'ta'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","No'q wel'ta'sin muta getlams'tmn ta'n goqwei Gisiteget teplum'sg'p na tliatew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mali teluet, “Ngamlamun welgwitg aq me'gite'lm'g Gisiteget, ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Pajiji ul'ta'si muta Gjinisgam na Nujiugs'tawi'wet ta'n gisi ugs'tawi't. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Angite'lmit aq ewle'jit ni'n na uglugowinu'sguml. Nige' weja'tegemg ms't wen tl wi'titew pajiji ul'te'lmut e'pit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Na Gisiteget gisi ignmuit nat goqwei pajiji glu'lg. Lpa na sape'wit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ewlite'lmaji ta'ni gepmite'lm'gwi'titl. Ula tla'tegetew ugjit mimajuinu'g aq un'janua iapjiw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mesgi'gl ta'n goqwe'l gis tla'tegelitl. Gisa'laji ta'n espite'lsultiliji ugsmultinew aq gisa'laji naqa'tnew ta'n getu' tla'taqatili'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mena'lapni elege'wiliji ta'n melgigno'ltliji umutgiwal aq wele'wapni ewle'juinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Esmapni gewisultiliji gelu'lg mijipjewei. Gatu enmigimapni milesuinu' aq mo goqwei ignmuagupni. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ta'n goqwei teli tplumapni gn'gi'guagi'g na tela'tegep. Apoqonmuapni uglugowinumg na Lesui'pa. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Migwite'tg ta'n gelulapni gn'gi'gunaqi'g. Na ewlite'lmapni Aplamal aq Aplamal un'janua iapjiw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na Mali emittugwalatl El'sapetal na'tami nesisijig tepgun'sejig aq na tujiw apajinmiet. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na pesgunateg te'sisgegsijig tepgun'sejig gisi iga'jig El'sapet ugs'tqamua'latl uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mawi ul'ta'sit. Ta'n tujiw witapesgwa aq wo'guma nutma'tilij Gisiteget teli ula'latl El'sapetal na mawi ul'ta'sultiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ta'n tujiw mijua'ji'j aqan'tie'uti tewje'geg, mimajuinu'g peita'jig ugjit lugwalanew. Getu' tl wi'ta'titl Saglaia, st'ge' ujjl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Gatu uggwitl teluelitl, “Moqwa', tluisitew Sa'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na telima'titl, “Mo geggunawjig ta'n talagumjig wijei geggunmi'tij ula wisun.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na tujiw ugpitnual weji glula'titl ujjl aq pipanima'titl ta'n getu' tl wi'taj uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Saglaia pipanigesit wi'gatign aq ewi'g'g, “Tluisitew Sa'n.” Mimajuinu'g sigti paqalaiultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na smtug Saglaia gis glusit, aq poqji gepmite'lmatl Gjinisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na mimajuinu'g ta'n wigultijig gigjiw Saglaia wiguow jipasultijig. Me' tel'gne'g ms't wen ta'n wigit na milqamigeg Jutiaewa'gi siaw agnutma'tijig ula ta'n goqwei gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ta'n te'sit wen nutg ula agnutmaqan angite'lma'titl, “Wenitew u't mijua'ji'j gisigwej?” muta geitu'tij Gisiteget apoqonmuatl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na Wejuli Nisgam nisa'sit Saglaiaeg na Sa'n Nutsign'tuet ujjl. Na tujiw Saglaia teluet glusuaqann ta'n wejiaqal Nisgameg, ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Me'gite'lmanej Gisiteget na Gjinisgam ugjit Lesui'paq. Pegising'p ugjit apoqonmuanew ugmimajuinumg aq ugs'tawianew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Petgitmugsi'gw Nujiugs'tawi'welitl ta'n melgigna'litl. Ula Westaulg wetapegsit Ta'piteg, na Gjinisgam uglugowinuml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Gi's nige' sa'q Gjinisgam gisa'lapni niganigjitegewinugi' tluenew ula. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Teplumugsi'gup weji ugs'tawugsinenu ta'nig getanugsi'gwig. Teplumugsi'gup angweiugsinenu glaman ta'nig masgelmugsi'gwig ma jile'ugsiggwig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Teluep ewlite'lmata gn'gi'gunaqi'g aq apjiw migwite'ttew ta'n goqwei teplumsip. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tla'tegetew wegla goqwe'l teplumapnn Aplamal, ta'n wetapegsulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Teplumsip weji ugs'tawugsinenu ta'nig masgelmugsi'gwig aq igalugsinenu glaman lugutitesnu ugjit negm aq ma jipasultiggw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ugs'tawugsitesnu glaman sape'ultitesnu aq tetapua'taqatitesnu ta'n teli pgitawsulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ngwis, tl wi'tulten niganigjitegewinu ugjit espe'g Gjinisgam. Ta'n tujiw Gjisaqamaw pgisintew, nigana'sites ilajugtmuates ta'n goqwe'l ugjit negm. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tlimates ugmimajuinumg na ugs'tawiaten ta'n tujiw ugpata'taqanmual apigsigtmuj. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gjinisgam ta'n emtoqwalugg na gesaluet aq ewlite'lmugsi'gw. Na na'gweg iga'tutew ta'n ugs'tawugsitesnu. ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ugs'tawiata na mimajuinu' ta'n pata'tegewinu' aq ta'n pemi npu'tijig. Ilgwenugsitesnu mimajultinenu wantaqo'ti'gtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na lpa'tuj, Sa'n, pemigwet, pemi ntawe'g aq melgi gtlams'tuatl Nisgaml. Ta'n tujiw gisigwet na eliet usgowa'sin paqtaqamigtug glapis poqji pestunmuaji Lesui'pa. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na teliaqap ge's Agustus elege'witewip Lo'mewa'gi tewatgitg tplutaqan ta'n telgi'g Lo'mewa'gi. Pewalaji ms't mimajuinu'g pisgui'gusultinew ta'n wetagutmu'ti'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ula na amgweseweieg mimajuinu'g pisgui'gusulti'tij ge's Gwilinius g'pnno'lewiteg Siliae'gatig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na tujiw ms't wen eliet aq pisgui'gusit na gjigan ta'n wetagutg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na So'sep weji maja'sit gjigan teluisig Nasalet Galaliewa'gig. Eliet na utan teluisig Petliem Jutiaewa'gig. Petliem na utan ta'n Ta'pito'q na elege'witaq etli ugs'tqamuip. So'sep wet liet na'te'l muta wetapegsit Ta'piteg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Naji pisgui'gusijig ugte'piteml, Malial ta'n gi's getu' un'janilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na teliaq ge's eimi'tij Petliemg, tetaputesg Mali un'janin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Amgwesewe'l uggwisl ugs'tqamua'latl aq ewnisgwega'latl atla'wegnigtug. Elsma'latl msigu ta'n wi'sisg esma'titen. Mali tela'teget muta mo we'jitu'tigupni getgunimgewei. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na wijei wela'gweg gigjiw Petliemg m'gegtug eimu'tijig ji'nmug ta'n nujiangweiwa'tiji jijgluewji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Gisiteget ugtansale'witeml neia'silitl aq pitiata's'g ta'n ji'nmug eimu'ti'tij. Gesateg wejiaq wa'so'q. Ji'nmug ma'muni jipaqita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ansale'wit telimaji, “Mut jipaqita'new. Weji pgisin ugjit tlimulinew gelu'lg agnutmaqan. Ula agnutmaqan gisa'lata ms't mimajuinu'g ugs'tqamug ul'ta'sultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ula wela'gw na Gjisaqamaw ta'n teluisit Nujiugs'tawi'wet ugs'tqamuip. Eig na gjigan ta'n Ta'pito'q wetagutg'p. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Telimuloq ta'n tl nenuatoqs'p. Na mijua'ji'j nmiatoqs'p ewnisgwega'tasit atla'wegnigtug aq elising msiguigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jiniw pugwelgig ansale'wijig ne'ita'jig ta'n igtigl ansale'wilitl eimlitl. Etli gtapegia'tijig ta'n tel gepmite'lma'tij Gjinisgaml. Teluejig, ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Miwa'lanej Gjinisgam ta'n mawi espe'g wa'so'q. Wantaqo'ti i'tt'j ugs'tqamug ugjit mimajuinu'g ta'n wel'te'lmaji.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ta'n tujiw ansale'wijig apaita'titeg wa'so'q, na nujiangweiwa'tiji jijgluewji telimtultijig, “Ge' lta'nej Petliemg aq nat nmitunej ta'n goqwei gis tliaq aq ta'n goqwei Gisiteget gis gnua'tugsi'gw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na smtug el'ta'jig aq nemia'tiji Malial, So'sepal aq na mijua'ji'jl ta'n elisinnitl msiguigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Angama'titl mijua'ji'jl aq telima'tiji Malial aq igtigi ta'n ansale'wilitl telimgwi'tipnn ugjit na mijua'ji'jl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Igtigig mimajuinu'g paqalaiultijig ta'n tujiw nutua'ti'tij ta'n goqwei ji'nmu ta'n angweigwi'tiji jijgluewjig gis agnutmli'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mali migwite'tgl ms't ta'n goqwe'l nutmapnn aq melgi angite'tgl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na ji'nmug ta'n angweiwa'tiji jijgluewji enmi gtapegia'tijig aq emtoqwala'titl Gjinisgaml ugjit ta'n te's'g gis nutmi'tij aq ta'n goqwei gis nemitu'tij. Lpa na teliaqap st'ge' ta'n ansale'wit teluep. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ta'n tujiw ugumuljin te'suguna'q iga'q ugjit na lpa'tuj elugwa'-tasin, tel wisungewatoqs'p Se'sus st'ge' ta'n ansale'wit tel wisungewapnn ge's mu Mali tele'gweg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na na'gweg ta'n waqama'lugsijig tetaputesg, na tujiw Mali aq So'sep ela'tijig gjia'sutuo'guomg tla'tegenew ta'n goqwei Mowisewei tplutaqan telueg. Ela'la'titl mijua'ji'jl gjia'sutuo'guomg Selusalemg ugjit neia'tuanew Gisitegelitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ula na tel wi'gas'g Gisitegetewei tplutaqan, “Ta'n amgwesewei na e'pit un'janit aq na lpa'tujuit na tujiw ula lpa'tuj apaji ignmuatl Gisitegelitl ugjit lugowan.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na wejgwa'la'tiji tapusiliji plesg aq ignmua'titl Gjinisgaml. Ula elg tel wi'gas'g Gisiteget ugt'tplutaqanm, “Jugwa'l tapusijig plesg gisna tapusijig sisipg ta'n telgilgig aq ignmu Gisiteget.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na ji'nm ta'n teluisit Simion wigit Selusalemg. Gelu'sit aq emtoqwalatl Nisgaml. Etli esgmalatl Nujiugs'tawi'welitl pgisinnin Lesui'pe'gatig. Wejuli Nisgam gis nisa'sit negmeg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Wejuli Nisgam gis tlimatl, “Ma npmun glapis nmiates Nujiugs'tawi'welitl ta'n Gisiteget petgimatal ugs'tqamug.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simion ilgwentl Wejuli Nisgaml pisgwa'n na gjia'sutuo'guomg. Na tujiw Mali aq So'sep pisgwa'la'titl Se'susal na'te'l ugjit tla'tegenew ta'n telteg tplutaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion wesua'latl na mijua'ji'jl aq miwatmuatl Gjinisgaml. Teluet, ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Gisiteget, ni'n na gtlugowinum. Etawei gisa'tun ta'n teli tplumi't'p. Geggunm wantaqo'ti ngamlamun aq nige' gisgaje'i mittugwalulin wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gis nmi'g Nujiugs'tawi'wet. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Petgimt ugs'tqamug ugjit ms't mimajuinu'g nmian. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Negm na pa wijei aq waseteg. Musga'tuata mimajuinu' ta'n mu Lesui'peultiligwi ta'n goqwei pewatmn. Gepmite'lmata gmimajuinumg na Lesui'paq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","So'sep aq Mali paqalaigig ta'n Simion tel usgumapnn Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simion a'sutmessewaji aq telimatl Malial, “Ula mijua'ji'j gisa'lata pugwenniji mimajuinu'g Lesui'pe'gatig gtlams'tuanew. Na tujiw ugs'tawiata gatu pugwelgig ma gtlams'tua'tigul. Wegla ma ugs'tawiagwi. Negm na agnutmewinu ta'n gis wejiet wa'so'q aq ta'sijig mimajuinu'g ma uli usguma'tigul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Neia'tu'titaq ta'n goqwei telgwija's'gl uggamlamunuaq. Ulmajita'suaqan gisa'lultew ulmaje'n pa wijei aq wa'qan ta'n gi'g gisi gsigsultew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na eig niganigjitegewinu'sgw teluisit Anna gjia'sutuo'guomg. Ujjl teluisilitl Panuel. Na ujjl wetapegsilitl A'sloq. Na Tepqatg'p pas'g lluigneg te'sipunqeg. Gi's sa'q ugji'nmuma nepmlipna. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Na sigu'sgw ugumuljin te'sisgegipunqeg je ne'w. Te's na'gweg tego'tg gjia'sutuo'guomg. Tepgig aq na'gweg emtoqwalatl Nisgaml. Ne'gaw a'sutmat aq sune'wit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na tujiw pegising ta'n mijua'ji'jl eimlitl aq miwatmuatl Nisgaml. Wesgumatl na mijua'ji'jl aq gelulaji na mimajuinu'g ta'n esgma'tiliji ugjit Gjinisgam ugs'tawianew mimajuinu' tleiawultiliji Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ta'n tujiw gaqa'tu'tij ta'n telueg Gisiteget ugt'tplutaqanm, na tujiw apaita'jig Galaliewa'gig. Ula gjigan teluisit Nasaletg ta'n wigultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na mijua'ji'j pemigwet. Melgignat aq natawe'g. Gjinisgam wel'te'lmatl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Te'sipunqeg Se'sus ungi'gu ela'tliji Selusalemg ugjit Siawa'timgewei Pestie'umg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ta'n tujiw Se'sus metlasipuna't je ta'pu ap ela'tijig Selusalemg ugjit Pestie'umg st'ge' ta'n tela'tegejig te's newtipunqeg aq Se'sus nespnut. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Eimu'tijig na'te'l glapis gaqiaq pestie'umg. Na tujiw ungi'gu apajinma'tijig gatu Se'sus siawqatg Selusalemg. Ungi'gu mo gejigugwi. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tel'ta'sijig Se'sus pem wije'waji wo'gumawa gisna witapua. Newtigisg'g pema'tijig aq na tujiw gwilua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mo we'jia'tigul tami. Na smtug apaja'tijig Selusalemg aq gwilua'titl na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na gi's gisi nesuguna'q we'jia'titl gjia'sutuo'guomg. Na pemgopit maw nujigina'mua'tiliji. Etl jigs'tuaji aq mil pipanimaji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ms't ta'n te'sijig nutua'titl paqalaiultijig ta'n teli ns'tuewistulij aq ta'n goqwei telimgwi'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ta'n tujiw ungi'gu nemigwi'titl na paqalailiji. Uggwitl telimtl, “Gwi's, goqwei wet tla'tegen u't? Gujj aq ni'n sespete'lmuleg'p aq peggwi al gwiluleg'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Se'sus telimaji, “Goqwei ta weji gwiluioq? Mo geituoqs'p amujpa tela'tegei ta'n nujj tel pualij?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ungi'gu mu nestua'gugwi ta'n goqwei Se'sus gis tluet. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na tujiw Se'sus apaji wije'waji Nasaletg aq ne'gaw mu elistuagwi ungi'gu. Mali mu ne'gaw awan'ta'sigw ta'n te's'g goqwei gis tliaq aq gaqaisg angite'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Se'sus pem pitoqwiet aq me' pemi ns'tue'g. Tetapua'latl Gjinisgaml aq mimajuinu' ta'n gejigwi'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taipilius gisi elege'witewip Lo'mewa'gig metlasipunqeg je na'n, na tujiw Pons Pilot g'pnno'lewit Jutiaewa'gig, Elot niganpuguit Galaliewa'gig, Pilip ta'n wijigmatl Elotal niganpuguit Ituliaewa'gig aq Tlajonitisewa'gig aq Lisanias niganpuguit Apilenewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na tujiw Annas aq Gaiapas espe'gig patlia'sg. Na Gjinisgam telimatl Sa'n Nutsign'tuelitl na agnutmaqan ta'n pewalatl pestunmlin. Sa'n na Saglaia uggwisl, aq wesgowa'sit paqtaqamigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Sa'n pitawa'sit aq papga'sit na sipu ta'n teluisit Jol'tan. Pestung, “Gawasgita'sultigw, jiglita'gw lue'utigtug aq sign'tasultigw, na tujiw Gjinisgam apigsigtmugsitoqs'p gtlue'utiwal.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Na niganigjitegewinuaq teluisipnaq Aiseia wesgumapnn Sa'nal ta'n gis wi'g'g'pnn ula, “Nat wen gesigawewistoq paqtaqamigtug. Teluet, ‘Gisiteget wejgu'et. Ms't ta'n te'sioq gisgajo'ltigw ugjit negm. Gisgaja'tug gelu'lg awti ta'n lien. Ltug tegpaqteg awti ugjit negm. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ta'n te's'gl walqwamigegl amujpa na wajua'tmgl. Ta'n te's'gl soqoqamigegl amujpa na gesaqqamigegl. Na waqjutaqtegl awti'l amujpa na siwnoqqwa'tas'gl. Na winjigl awtijl amujpa na ilugwa'tas'gl aq pitgma'tas'gl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na tujiw ms't mimajuinu'g nmia'tital na Nujiugs'tawi'welitl ta'n Gjinisgam petgimatal.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pugwelgig mimajuinu'g el'ta'jig Sa'neg ugjit sign'tasultinew. Sa'n telimaji, “Gjinisgam wegaig aq getu' ilsumugsioq. Gilew pa na wijei aq mtesgmug. Pewalioq sign'tulinew muta tel'ta'sultioq na Gjinisgam ma ilsumugsiwoq pa na sign'tasultioqos. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tlo'ltigw aq tla'taqatigw ta'n goqwei neia'tuanew igtigig gawasgita'sultioq aq ejiglita'ioq lue'utigtug. Tluetoqs'p wetapegsultioq Aplameg gatu telimuloq, Gjinisgam gis ugsua'toqol wegla gun'tal aq gisa'tutal mimajuinualanew ta'n wetapegsultiliji Aplameg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Gilew pa wijei aq miti's ta'n mo wel minigw aq Gjinisgam gisgaje'g ilsumugsinew nige'. Iga'taqewinu gisgaje'g tmta'n miti'sl ta'n mu wel mininugul gigjiw gjip'sgigtug aq nu'gwa'lan. Gjinisgam ilsumatal te'silitl mimajuinu'l ta'n pata'tegelitl st'ge' na iga'taqewinu getu' tla'laji miti'sg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mimajuinu'g pipanima'titl, “Gatu nige' tala'taqatitesnen?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sa'n telimaji, “Ta'n wen geggunaji tapusiliji atla'ig amujpa ignmuatal newte'jilitl na ji'nmul ta'n mo geggunagul atla'il. Ta'n wen mijipjewe'mit amujpa ta's'g smuetutew na mimajuinu'l ta'n mo geggunmiligul mijipjewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ta'sijig nujintutma'tijig g'pnno'lewei suliewei peita'jig ugjit sign'tasultinew aq pipanima'titl Sa'nal, “Nujigina'muet, tala'taqatitesnen?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Telimaji, “Mut piami ugsua'tunew ta'n telteg tplutaqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ta'sijig sma'gnisg pipanima'titl, “Gatu ninen tala'taqatitesnen?” Sa'n telimaji, “Mut pisuimanew igtigig aq mut gi'gaji ugsua'tuaw wen ugsulieweim.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mimajuinu'g poqji ul'ta'sultijig muta tel'ta'sultijig Sa'nal etugjel negm na Nujiugs'tawi'wet. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Na tujiw Sa'n telimaji, “Sign'tuloq samqwanigtug gatu wejgu'et negm ta'n me' espe'g aq ni'n. Mu tepawtiw je we'gaw apgwa'tuan umugsnapi'l. Ta'n tujiw sign'tugsitoqs'p na e'wtew pugtew aq ignmugsitesnu Wejuli Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wejgu'et, na ilsumata ms't mimajuinu' aq nigtua'lata ta'n tetapua'taqatiliji aq ta'n pata'taqatiliji. Ta'ni gelu'sultiliji la'lata wa'so'q st'ge' iga'taqewinu tepgiso'toqol glumgl aq pisqo'toqol uglaqalansmg. Ta'ni mu gelu'sultligwi pija'lata na pugtew ta'n mo naqa'suenug st'ge' iga'taqewinu mawo'toqol siguaqs'te'gnn aq nu'gwa'toqol.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sa'n mil gnua'tuaji mimajuinu' ge's pestung na gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Na telimatl niganpuguilitl ta'n teluisilitl Elot pata'tegen ta'n tujiw malie'wiliji Elotiasal muta ula e'pit gisi tepqatg'p Elot ugjignaml. Sa'n ewi'tmuatl Elotal igtigl lue'uti'l gisa'tulitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Gatu Elot me' ma'muniw pata'teget ta'n tujiw pija'laten Sa'nal laplusang. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ta'n tujiw ms't mimajuinu'g ta'n jigs'tua'tipnn Sa'nal gi's sign'tujig, Se'sus pegising aq sign'tuaten. Ge's Se'sus etl a'sutmat na'te'l, wa'so'q pana's'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Wejuli Nisgam el nisiet Se'susal un'jig. Na teliangamgusit st'ge' ples. Nat wen weji glusit wa'so'q. Teluet, “Gi'l na ngwis. Mawi gsalg aq mawi ul'te'lmul.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Se'sus na'tami nesisgegipuna'p na tujiw poqji pestung. Mimajuinu'g tel'ta'sultijig negm na So'sep uggwisl, aq So'sep na I'lai uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","I'lai na Mattat uggwisl, Mattat na Li'pai uggwisl, Li'pai na Melji uggwisl, Melji na Jannai uggwisl, Jannai na igtig So'sep uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ula So'sep na Mattatias uggwisl, Mattatias na E'mos uggwisl, E'mos na Ne'um uggwisl, Ne'um na Esli uggwisl, Esli na Na'ggai uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Na'ggai na Ma't uggwisl, Ma't na igtig Mattatias uggwisl. Ula Mattatias na Semein uggwisl, Semein na Jo'seg uggwisl, Jo'seg na Jo'ta uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jo'ta na Joalan uggwisl, Joalan na Lesa uggwisl, Lesa na Selupapel uggwisl, Selupapel na Sialtiel uggwisl, Sialtiel na Ne'li uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ne'li na igtig Melji uggwisl, ula Melji na Ati uggwisl, Ati na Gosam uggwisl, Gosam na Elmatam uggwisl, Elmatam na El uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","El na Ja'sua uggwisl, Ja'sua na Eliesel uggwisl, Eliesel na Jolim uggwisl, Jolim na igtig Mattat uggwisl, ula Mattat na Li'pai uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Li'pai na Simion uggwisl, Simion na Juta uggwisl, Juta na igtig So'sep uggwisl, ula So'sep na Jonam uggwisl, Jonam na Ilaiagim uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliagim na Meleia uggwisl, Meleia na Menna uggwisl, Menna na Mattata uggwisl, Mattata na Ne'tan uggwisl, Ne'tan na Ta'pit uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ta'pit na Jessi uggwisl, Jessi na Opet uggwisl, Opet na Poas uggwisl, Poas na Salaman uggwisl, Salaman na Ne'son uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ne'son na Aminata'p uggwisl, Aminata'p na Atmin uggwisl, Atmin na Alni uggwisl, Alni na Eslon uggwisl, Eslon na Peles uggwisl, Peles na Juta uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juta na Je'gop uggwisl, Je'gop na Isaq uggwisl, Isaq na Aplam uggwisl, Aplam na Tela uggwisl, Tela na Neiol uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neiol na Selug uggwisl, Selug na Lagew uggwisl, Lagew na Peleg uggwisl, Peleg na Ipel uggwisl, Ipel na Sela uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela na Gainan uggwisl, Gainan na Alpasat uggwisl, Alpasat na Sem uggwisl, Sem na Noa uggwisl, Noa na Lameg uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameg na Metusela uggwisl, Metusela na Inaq uggwisl, Inaq na Jalet uggwisl, Jalet na Maiale'l uggwisl, Maiale'l na igtig Gainan uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Gainan na I'nos uggwisl, I'nos na Set uggwisl, Set na Ata uggwisl, Ata na Gjinisgam uggwisl muta Gjinisgam gisiapnn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Se'sus weji apaja'sit Jol'tanewei sipu. Wejuli Nisgaml eimlitl Se'suseg. Na ela'latl Se'susal paqtaqamigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Na'te'l wet nu'gwaltl Gjimn'tu'l glapis ne'wisgegiguna'q. Ne'gaw mo goqwei malqotmug aq no'q gewising ta'n tujiw ne'wisgegiguna'q gaqiaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Gjimn'tu'l telimtl, “Pa na gi'l na Gjinisgam uggwisin na gisa'tu ula gun'tew pipnaqanin.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Se'sus telimatl, “Moqwa', ma tela'tegew muta Nisgam ugtwi'gatignigtug ewi'gas'g, ‘Mimajuinu ma iapjiw gisi ugji mimajigw mijipjeweigtug.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na tujiw Gjimn'tu so'qwa'latl Se'susal gm'tnigtug aq jaqal musga'tuatl ms't elege'witewa'gi'l ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Gjimn'tu telimatl, “Ignmultes ms't ta'n te's'g ml'gigno'ti aq ta'n te's'g milesuaqan ula nemitun. Ms't ta'n te's'g goqwei gaqi ignmuimg aq ignmua's ta'n wen pewalg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ms't ula gi'lewe'tew ta'n tujiw jugu'en emtoqwalin aq nutgul'pa'sua'lin.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Se'sus telimatl, “Ma tela'tegew muta Nisgam ugtwi'gatignigtug ewi'gas'g, ‘Emtoqwalates Gisiteget na Gjinisgam ta'n gepmite'lm't aq pas'g negm lugow.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Na tujiw Gjimn'tu ela'latl Se'susal Selusalemg aq tepa'latl ta'n etl mawi esp'teg gjia'sutuo'guomg. Telimatl, “Pa na gi'l na Gjinisgam uggwisin, nisaqalsi. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Muta Nisgam ugtwi'gatignigtug ewi'gas'g, ‘Gjinisgam tlimata ugtansale'witemg angweiulinew.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Elg telueg, ‘Msnultaq aq unaqa'lultaq ugpitnuaq glaman jel ma jile'nugul ggwatl gun'tewigtug.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Se'sus telimatl, “Nisgamewei wi'gatign telueg, ‘Mut ugt nu'gwalaw Gisiteget na Gjinisgam ta'n emtoqwalt.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ta'n tujiw Gjimn'tu we'gisipgwatoq na tujiw pun ugt nu'gwalatl Se'susal aq pe'l punaje'watl ta'suguna'q. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Se'sus apaja'sit Galaliewa'gig. Geggung ml'gigno'ti ta'n wejiaq Wejuli Nisgamewigtug. Pugwelgig mimajuinu'g geitu'tij Se'sus eig na'te'l muta mimajuinu'g wesguma'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Etl pestung na a'sutuo'guoml na'te'l aq ms't wen gepmite'lmatl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na tujiw Se'sus eliet Nasaletg ta'n etl neps'tgwa'tasip. Atlasmutigisg'g eliet a'sutuo'guomg ta'n gis sipeliw tla'teget. Gaqama'sit ugjit gitmn Nisgamewei wi'gatign. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Elasgnmut na wi'gatign ta'n Aiseiao'q gis wi'g'g'p. Se'sus apgwa'toq ula wi'gatign glapis we'jitoq ta'n tegen getu' gitg. Egitg ula, ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Gisi ignmuimg na Wejuli Nisgam. Megnmit aq elgimit gnua'tuan na gelu'lg agnutmaqan ugjit ewle'jultijig. Elg petgimit ugjit gnua'tuan wegla ta'n pisultijig iga'lanew aq wegla ta'n nepapigwo'ltijig nmitaqatinew. Petgimit ugjit iga'lanew ta'nig emegweiujig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Petgimit ugjit tliman mimajuinu'g iga'q na na'gweg ta'n Gisiteget tli ugs'tawiata mimajuinu'.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Se'sus ilta'toq na wi'gatign aq apaji ignmuatl na ji'nmul ta'n ango'tmlitl aq epa'sit. Ms't mimajuinu'g a'sutuo'guomg angama'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na tujiw telimaji, “Wegla glusuaqann ta'n ewi'gas'g Gjinisgam ugtwi'gatign na gis tliaqal gisgug ge's pem gitmuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Na mimajuinu'g wels'tua'titl aq paqalaiultijig ta'n telewistulij. Pipanimtultijig, “Ula na So'sep uggwisl?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Telimaji, “Geju'loq nasplutuatoqs'p ta'n goqwei nat wen gis teluep aq tlimitoqs'p ula, ‘Pa na mal'pale'witewi's'p aq pilue'g gisi npilj, nige' npilsi,’ gisna tlimitoqs'p ula, ‘Wijei tla'tega ula tet gm'tginaq ta'n tel nutmaieg'p gis tla'tege't'p Gapelniamg.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Se'sus siawewistoq, “Telimuloq na niganigjitegewinu'g mo menuegem'gig umutgiwaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Jigs'tuigw. Ta'n tujiw Ilaijao'q mimajiteg, na tujiw pugwelg'pnig sigu'sgwaq eimu'tipnig Lesui'pe'gatig. Na tujiw mo gigpesanugup nesipunqeg je aqataig aq na tujiw mesgi'g'p pestmo'qon gm'tginaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Gatu Ilaijao'q mo elgimam'g'p ugjit apoqonmuan je newte'jilitl sigu'sgwal tleiawilitl Lesui'pewa'gig gatu awna elgimut'p ugjit apoqonmuan igtigl sigu'sgwal tleiawilitl na gjigan Salepat ta'n eteg Saitonewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ta'n tujiw Ilaisao'q na niganigjitegewinu mimajiteg, pugwelgig mimajuinu'g geggunmi'tip na 'gsnugowaqan teluisig leplsi Lesui'pe'gatig. Lpa mo wen gisi npilam'g'p gm'tginaq, gatu awna na ji'nm teluisit Nemn na nepilut'p. Negm tleiawip Siliae'gatig.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na mimajuinu'g ta'n eimu'tijig a'sutuo'guomg wegaiultijig ta'n tujiw ula nutmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na ms't gaqamita'jig aq tewa'la'titl Se'susal na a'sutuo'guomg. Ela'la'titl ta'n etl paqse'g gigjiw na gjigang. Getu' paqage'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Gatu Se'sus naqalaji aq smtug ejigla'sit na gjigan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Se'sus eliet na gjigan Gapelniam ta'n eteg Galaliewa'gig. Na'te'l etl pestung atlasmutigisg'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ms't paqalaiultijig ta'n tel gina'muej muta geitoq ta'n goqwei wesgutg aq geggung ml'gigno'ti. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Eig a'sutuo'guomg ji'nm ta'n mn'tu'l pitu'gwitl. Sesgwalatl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Se'sus gi'l tleiawin Nasaletg, taluegeieg? Weji pgisinu's'p ugjit seioqwa'linen? Nenu'l ta'n wenin. Gi'l na sape'wit ta'n Gjinisgaml petgimtl.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Se'sus mn'tu'l telimatl, “Wantaqa'si, aq getaqa'si na ji'nmuigtug.” Ge's mn'tu naqalatl na ji'nmul na gisa'latl nisielin nigantug Se'suseg gatu mo jile'wagul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na mimajuinu'g paqalaiultijig aq teluejig, “Me' gatu melgi glusuaqanmit. Geggung ml'gigno'ti aq assusuti ugjit mn'tu'g tewita'ji.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ula agnutmaqan ta'n Se'sus gis tla'teget se'sa's'g ms't tami gigjiw Gapelniamg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Se'sus naqt'g a'sutuo'guom aq pisgwa't Simon wiguaq. Simon ugjugwiji'jl gesnugwalitl muta mesnmlitl epsimgewei. Na agnutmua'titl Se'susal ugjit apoqonmuan na e'pilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Se'sus eliet gigjiw ta'n elisinnij aq gisa'toq na epsimgewei jigla'sitn na e'pit. Smtug menja'sit aq poqji lugowaji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Galqwasiej, pugwelgig mimajuinu'g pejo'la'tiji Se'suseg witapua aq wo'guma ta'n milipna'tiliji. Sama'laji aq ms't gisi npisultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","We'gaw Se'sus mn'tu' ejiglgimaji mimajuinueg. Ge's tewatgimaji mimajuinu' ugtinnewaq sesgu'tijig, “Gi'l na Gjinisgam uggwisl.” Na mn'tu'g gejia'titl Se'susal na Nujiugs'tawi'welitl. Se'sus melgimaji, “Mut glusultinew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ta'n tujiw wejgwapniaq, Se'sus naqt'g na utan aq eliet ta'n mo mimajuinu'g wigulti'gw. Ta'sijig mimajuinu'g poqji gwilua'titl aq ta'n tujiw we'jia'titeg na pipanima'titl mu naqtmlin umutgiwaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Gatu telimaji, “Amujpa pestunmaqig mimajuinu'g tleiawultijig igtigl gjigann aq utann. Gjinisgam weji petgimit ugjit tliman na gelu'lg agnutmaqan ta'n Gjinisgam ilgwenaji mimajuinu'.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na tujiw Se'sus eliet aq al pestungl igtigl a'sutuo'guoml Jutiaewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Newtejgeg na'gweg Se'sus eig tajigtug na qospem teluisig Genesalet. Ge's gaqamij na'te'l pugwelgig mimajuinu'g etl mawita'jig Se'suseg muta getu' jigs'tua'titl tlimanew Gjinisgam ugtwi'gatign. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Se'sus nemitoqol tapu'gl gajigajgl na'taqamtegl. Na usgewinu'g gis gepta'sijig ugtuluow aq waqama'la'tiji ugta'pimua. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Se'sus tepa'sit Simon ugtul aq pipanimatl ugjit gijga mlawigsmegen. Na pemgopit na'te'l aq weji pestunmuaji na mimajuinu' ta'n eimu'tiliji na tajigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ta'n tujiw gaqewistoq telimatl Simonal, “Me' gijga mnawi gsma'tu gtul etl tmig glaman gi'l aq gitapaq gisi a'pia'titoqs'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon telimatl, “Saqamaw, gi'l na assusit, gis attignita'ieg newtitpa'q aq mo goqwei ne'pa'tueg, gatu tla'taqatitesnen ta'n teluen.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ta'n tujiw egwija'la'titl ugta'pimual na mesna'tiji pugwenniji nme'ji. Te'suta'tiji nme'ji na suel pewja'silitl ugta'pimual. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wiguma'tiji witapewa ta'n teppultiliji ugtulual ugjit apoqonmugsinew. Peita'liji aq apoqonmua'tiji. Na petgimatmi'titl gitg ugtulual glapis suel getapugwegl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ta'n tujiw Simon Pie'l gis nmitoq ta'n gis tliaq eliet Se'suseg aq el nutgul'pa'sit aq telimatl, “Saqamaw, pewalul jigla'sin ni'neg muta pata'tegewinui.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon aq witapa ta'n eimu'tiliji ugtulg paqalaiultijig ta'n tel ma'muni pe'tla'tiji tel pugwenniji nme'ji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simon witapa ta'n teppiliji ugtulual elg paqalaiagwi'tiji. Na Ji'mej aq Sa'n, Sepeti uggwisg. Se'sus telimatl Simonal, “Mut jipasiw, muta nige' weja'tegemg jugwo'lates mimajuinu'g Nisgamewigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Na tujiw Simon aq witapa na'taqama'tu'titl ugtulual. Naqtmi'tij ms't goqwei na'te'l aq majulgwala'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Newtejgeg na'gweg ge's Se'sus eig gjigan weltesguatl ji'nmul ta'n geggunmilij 'gsnugowaqan teluisig leplsi. Ta'n tujiw ula ji'nm nemiatl Se'susal el nutgul'pa'silitl aq etawaqtmuatl, “Gjisaqamaw, gisi npilites pa na tli ul'te'tmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Se'sus sipisga'sit aq sama'latl. Telimatl, “Getu tla'tegei. Nige' gisi npilul!” Na smtug gisi npiluj na ji'nm. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Telimatl, “Mut wen tlimaw, gatu nat nmiates patlia's aq angamulij. Ta'n tujiw geitoq gisi npisin na ignmuates ta'n goqwei Mowiso'q teluepnaq nat wen ta'n amujpa gisi ignmuatl patlia'sl. Na tujiw mimajuinu'g gji'tutaq ta'n teli ila'sin nige'.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gatu na agnutmaqan ta'n Se'sus gis tla'teget me' ma'muni peggwa's'g, aq pugwelgig mimajuinu'g peita'jig Se'suseg. Getu' jigs'tua'titl aq pewala'titl gisi npisultinew gsnugowaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Gatu Se'sus eliet ta'n etl wantaqteg naji a'sutmat. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Newtejgeg na'gweg Se'sus etl gina'muet wen'ji'guomg ta'n etl mawita'jig pugwelgig niganpugultijig. Ta'sijig Palasiaq aq ta'sijig nujigina'mua'tijig Mowisewei tplutaqan eimu'tijig na'te'l. Weita'jig pugwelgl utann Galaliewa'gig aq Jutiaewa'gig, aq na gjigan teluisig Selusalemg. Na Gisiteget gisi ignmuatl Se'susal ml'gigno'ti ugjit gisi npilan gsnugowinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na ta'sijig ji'nmug peita'pila'titl witapal na'te'l. Witapal elisinnitl a'su'nigtug muta mu gisi maja'siligul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Na me'si pisgwapila'titl ta'n Se'sus eig muta wesam pugwelgig mimajuinu'g eimu'tijig na'te'l. Gujmug wetteg lgusuaqan. Na weji so'qwapila'titl g'p'taq wen'ji'guom. Na'te'l anguna'tas'gl gun'tal. Meno'tu'titl tepiaqal gun'tal ta'n tel nispila'tital ji'nmul. Wet nispila'titl na witapual ta'n gaqamilij Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Melgi gtlams'tmi'tij Se'sus gisi npilatal witapual. Se'sus geitoq ta'n tel'ta'sultiliji wegla ji'nmug. Telimatl ji'nmul ta'n mu maja'siligul, “Nitap, gtlue'uti'l apigsigtmulan.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na tujiw Palasiaq aq nujigina'mua'tijig tplutaqan poqji maw agnutma'tijig. Teluejig, “Wen ta u't ji'nm ta'n tel'te'lsit negm na Gjinisgam? Mo eimug mimajuinu ta'n gisi apigsigt'gl lue'uti'l, pas'g newte'jit, na negm Gjinisgam.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Se'sus gejiaji ta'n goqwei etli angite'tmi'tij aq pipanimaji, “Tal gis teli angita'sultioq? ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tegen me' nqamase'tew ni'n tla'tegen, apigsigtmaqal ula ji'nm ugtlue'uti'l gisna gisa'l'g mn'ja'sin aq pmien? ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ni'n na mimajuinualsiap aq nige' musga'tultoqs'p geggunm ml'gigno'ti ugs'tqamug ugjit apigsigtmuan lue'uti'l.” Telimatl ji'nmul ta'n mu gisi maja'siligul, “Telimul, mn'ja'si, mgne'n gta'su'nm aq nige' gisi nmiates.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ge's mimajuinu'g etli angama'tij na ji'nm wenaqa'sit, wesua'toq na ugta'su'nm aq enmi emtoqwalatl Gjinisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na mimajuinu'g ta'n eimu'tijig gaqi paqalaiwaji aq emtoqwala'titl Gjinisgaml. Jipaqita'jig aq teluejig, “Na mesgi'g paqalaiwaqan gis nmitu'g gisgug!” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Na tujiw Se'sus tewiet aq nemiatl ji'nmul ta'n teluisilitl Li'pai. Ula ji'nm na nujintutmewinu suliewei aq pemgopit ta'n etl lugwej g'pnno'lewei. Se'sus telimatl, “Majulgwali.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na Li'pai wenaqa'sit, naqt'g ms't goqwei aq majulgwalatl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tel'gne'geg Li'pai iga'toq mesgi'g pestie'umg wiguaq ugjit Se'susal. Li'pai wigumaji pugwenniji nujintutma'tiliji suliewei aq igtigi mimajuinu' mawatalultinew maw negmow. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na ta'sijig Palasiaq aq ta'sijig nujigina'mua'tijig tplutaqan mo weli usguma'tigul Se'susal. Pipanima'tiji Se'susal aq unaqapemg, “Goqwei weji mawatalultioq nujintutma'tijig suliewei aq igtigig lue'winu'g?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Se'sus telimaji, “Na mimajuinu'g ta'n tajigo'ltijig mo menuege'tigul mal'pale'wilitl, gatu pas'g negla ta'n gesnugu'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mo weji pgisinu ugjit pipaniman mimajuinu'g ta'n getlamia'tijig majulgwalinew. Awna weji pgisin ugjit pipaniman elue'winu'g gawasgita'sultinew aq jiglita'new lue'utigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Alt mimajuinu'g telima'titl Se'susal, “Sa'n unaqapemg sipeliw sune'wultiliji aq a'sutma'tliji, aq Palasiaq unaqapemua wijei tela'taqatiliji gatu gnaqapemg mijjultijig te'sigisg'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Se'sus telimaji, “Etug tel'ta'sioq na mimajuinu'g wigumujig ta'n wesgowa's'g malie'wimg ma sune'wulti'gw. Ge's wijitgweiwa'titl witapual ta'n getu' malie'wilitl getletug na mijjultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gatu na na'gweg iga'qt'tew ta'n tujiw ji'nm malie'wij ejigla'luj. Etna na na'gwegl ta'n tujiw witapa sune'wultilita.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Se'sus elg telimaji ula a'tugwaqanji'j, “Mo wen menina'tug mussew pilei aligewigtug ugjit si'smn sa'qawei aligew. Pa na tla'tege's'p na suisgina'tutew pilei aligew aq na mussew ma wijei tlamugtnug st'ge' sa'qawei aligew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mo wen elguta'tug pilei moqopa'q sa'qawe'l m'gegne'l mun'ti'l. Pa na tla'tege's'p na pilei moqopa'q pasgugt'tal na sa'qawe'l mun'ti'l. Na moqopa'q tuijuitew aq na mun'ti'l ma tali ugtapsuninugl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Awna pilei moqopa'q amujpa elguto'tun pile'l mun'ti'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mo wen pewatmug pilei moqopa'q ta'n tujiw gi's samqwaj sa'qawei moqopa'q. Tluetew, ‘Sa'qawei moqopa'q me' gne'g wigapu'g.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na atlasmutigisg'g Se'sus aq unaqapemg pem saputita'jig ta'n glumgl etl nigwegl. Alt unaqapemg tematpo'tu'tilitl na glumgl. Pemaqs'te'mi'titl ugpitnuaq aq malqotmi'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ta'sijig Palasiaq nemia'tiji aq telima'tiji, “Gis geituoq mo teltenug mgnmnew glumgl atlasmutigisg'g. Goqwei wet tla'taqatioq ta'n tplutaqanminu telueg ma gis tla'taqatiwoq atlasmutigisg'g?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Se'sus telimaji, “Gis egitmoq ta'n Ta'pito'q aq unaqapemg tela'taqatipnig ta'n gewisulti'titeg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ta'pito'q pisgwa'p a'sutuo'guomg aq wesua'toqopnn pipnaqann ta'n gisi ignmut'p Gjinisgam. Na telgitas'g ginuewei tplutaqanigtug pas'g patlia'sg gis malqotmi'tij ala pipnaqan. Malqotg'p aq ignmuapni witapa elg malqotmnew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Elt telimaji, “Ni'n na mimajuinualsiap aq gis tlima's mimajuinu'g ta'n gis tla'taqatitaq atlasmutigisg'g muta assutm.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na igtig atlasmutigisg'g Se'sus pisgwa't a'sutuo'guomg aq etl gina'muet. Na'te'l eig na ji'nm ta'n inaqanei ugpitn malig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na nujigina'mua'tijig Mowisewei tplutaqan aq Palasiaq gwilmi'tij ta'n gisi ilsutmua'titl Se'susal. Pa na Se'sus nepilatl wenn atlasmutigisg'g na tujiw pisui ilsuma'tital Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Se'sus geituaji ugtangita'suaqanmual aq telimatl na ji'nmul ta'n ugpitn malig, “Qama'si aq jugu'a gmetug ni'neg.” Na ji'nm tela'teget ta'n telimuj. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na tujiw Se'sus pipanimaji nujigina'mua'tiliji Mowisewei tplutaqan aq Palasiaq, “Nige' pipanimuloq, na tplutaqanminu telimugsi'gw apoqonmuan mimajuinu gisna emegweian atlasmutigisg'g? Telueg ugs'tawian ji'nm gisna ne'pa'n?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Se'sus gigto'qopa'sit aq ms't angamaji. Telimatl na ji'nmul ta'n ugpitn malig, “Sipisga'tu gpitn.” Na ji'nm tela'teget aq smtug ugpitn ila's'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Palasiaq aq tplutaqanei nujigina'mua'tijig wegaiultijig aq wesgutmi'tij ta'n tla'la'tis Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Newte' wela'gw Se'sus eliet soqoqamigeg naji a'sutmat. Na'te'l wesgowa'sit newtitpa'q etawaqtmuatl Gjinisgaml apoqonmuan aq ilgwenan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ta'n tujiw gisapniaq, Se'sus wigumaji unaqapemg. Na megnaji newtisgegsiliji je ta'pu ta'n tel wi'taji Apostale'wijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Megnatl Simonal, ta'n tel wisungewatl Pie'l, aq Pie'l ugjignaml teluisilitl Antle'. Elt megnaji Ji'mejal, Sa'nal, Pilipal, Paltolomiwal, ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiwal, Tumaal aq Ji'mejal, na Alpius uggwisl, Simonal ta'n me'gite'tg umutgi. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Megnaji Sutaal na igtig Ji'mej uggwisl aq Suta Isgaliotal, ta'n ntuisgalgutal Se'sus. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Se'sus aq apostale'wijig apat nisita'jig soqoqamigeg aq naqita'jig tetpaqamigeg. Pugwenniji unaqapemg aq pugwelgig mimajuinu'g peita'jig na'te'l muta getu' jigs'tua'titl. Na tleiawultijig Jutiaewa'gig, na gjigan Selusalem aq tapu'gl gjigann, Tail aq Saiton ta'n etegl apaqtugewei sitm. Alt mimajuinu'g ta'n gesnugu'tijig pewala'titl npilgunew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Alt ta'n mn'tu'g wesgweiagwi'tiji nepilujig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pugwelgig mimajuinu'g wejo'tmi'tij gis sama'lanew Se'susal muta ml'gigno'ti wejiaq negmeg nepilugsinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Se'sus angamaji unaqapemg aq telimaji, “Gilew ta'n elita'sualoq Gjinisgam ugjit ms't goqwei ulgwijultigw muta Gjinisgam ilgwenugsioq aq ignmugsioq e'wmanew ta'n goqwei geggung. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Gilew ta'n getu' tetapua'loq Gjinisgam je mu ta'n pas'g goqwei, ulgwijultigw, muta Gjinisgam tetapua'lugsioqs'p. Gilew ta'n welmaita'sultioq nige' ulgwijultigw, muta ul'ta'sultitoqs'p aq usgewo'ltitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Gilew ta'n getlams'tmuioq na ta'sijig mimajuinu'g alua'lugsioq, penoqite'lmugsioq, masgelmugsioq aq egsuaqanimugsioq muta majulgwalioq ni'n na mimajuinualsiap. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ulgwijultigw muta wijei tela'lgwi'tisni niganigjitegewinugi' st'ge' na mimajuinu'g ta'n masgelmugsioq. Pewaluloq ulgwijultinew aq amalgaltinew ta'n tujiw tela'lugsioq muta Gjinisgam ignmugsitoqs'p pugwelgl ta'n goqwe'l geggungl wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Gatu no'q mtue'tew ugjit gilew ta'n milesultioq muta gi's gugunmoq na naqamajej mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","No'q mtue'tew ugjit gilew ta'n mo goqwei nuta'mawoq muta guisultitoqs'p me' enmiaq. No'q mtue'tew ugjit gilew ta'n wesgewo'ltioq ewlgwijultitoqs'p aq gaqiemtmutitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“No'q mtue'tew ugjit gilew ta'n tujiw ms't mimajuinu'g weli usgumugsioq muta ujjuaqi'ga wijei weli usgumgwi'tisni nujiegsua'tijig niganigjitegewinugi'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Gatu telimuloq gilew ta'n jigs'tuioq, gsalug ta'nig getanugsioqig aq ula'lug ta'nig masgelmugsioq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pipanimug Gjinisgam ugjit ule'wan ta'nig anmimugsioqig aq a'sutmessewug ta'nig emegweiugsioq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pa na wen paqtne'ite'sg's ignmu etuiw paqtne'itulin. Pa na wen wesua'tasg'snn ggotml, etl ignmu ugsua'tulin gtatla'iml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pa na wen nat goqwei pipanimasg's na ignmu aq pa na wen goqwei gi'lewei ugsua'tultew, mut ugjo'tmu apaji ugsua'tun. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tla'tega ugjit igtigig st'ge' ta'n tel puatmn tla'taqatinew ugjit gi'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Pa na pas'g gsalj mimajuinu'g ta'n gesal'sgig, mut tl'ta'siw na Gjinisgam me' ule'ultew je mu igtigig, muta we'gaw pata'tegewinu'g gesala'tiji ta'n gesalgwi'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pa na pas'g tetapua'l'j ta'n tetapua'l'sgig, mut tl'ta'siw Gjinisgam me' ule'ultew je mu igtigig mimajuinu'g. We'gaw pata'tegewinu'g tela'taqati'tij wijei aq gi'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pa na pas'g mqataj ta'n wen elita'sin apaji msnmoq ta'n goqwei mqata't'p, mut tl'ta'siw Gjinisgam me' ule'ultew je mu igtigig mimajuinu'g. We'gaw pata'tegewinu'g emgatua'tiji igtigi pata'tegewinu' ugjit apaji msnmnew wijei te's'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Gatu gsal ta'nig getan'sgig aq tetapu ule'ul. Mqatuiga aq mut goqwei apajite'tmu. No'q ms'gi'gt'tew apangituewei apaji msnmoq, aq tl wi'tugsitoqs'p espe'g Gjinisgam un'jang, muta Gjinisgam me' welm'toq ugjit ta'n wenn mo miwatmligw ta'n goqwei gelu'lg aq ta'n wen newtite'lsit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ewlite'lga st'ge' ta'n gujjuow teli ewlite'lgej.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mut ilsumaw igtigig aq Gjinisgam ma ilsumulug. Mut alua'l igtigig aq Gjinisgam ma alua'lulug. Apigsigtu igtigig aq Gjinisgam apigsigtultew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ignmu igtigig ta'n goqwei nuta'tij aq Gjinisgam ignmultew ta'n goqwei nuta'man. Gjinisgam ta'n no'q ulm'tutew ignmultew ta'n te's'g goqwei gisi ignmuetu'n aq je me'. Gjinisgam ignmultal st'ge' ta'n goqwe'l tel ignmat'pnig igtigig.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Se'sus telimaji ula a'tugwaqanji'j, “Nepapigwa't ma gisi ala'lagul igtigl nepapigwa'litl. Pa na wejo'tg's ala'lan gitg nepapigwa'jig pijiataq na'tami elmalqe'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ta'n wen gegina'masit ma gepmite'lmamug je mu na nujigina'muelitl gatu ta'n tujiw gaqi gina'masij wijei tli gji'teget st'ge' na nujigina'muelitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ta'n wen ilsumatl igtigl na wijei aq ji'nm getu' tualqa'laj siguaqs'te'gn'ji'j ta'n piteg witapal ugpugugw ge's gmu'j piteg ugpugugw. Wigue'g sespete'tg na siguaqs'te'gn'ji'j ta'n piteg witapal ugpugugw gatu mu wesgutmug na gmu'j ta'n piteg ugpugugw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ge's na gmu'j me' piteg ugpugugw, mu tetapu tlimatl witapal, ‘Nitap, ge' apoqonmultes tualqa'tun na siguaqs'te'gn'ji'j ta'n piteg gpugugw.’ Na mimajuinu ta'n ula tela'teget na wesgijiangamgusit. Tmg amujpa tualqa'toq gmu'j ta'n piteg ugpugugw glaman ulapitew aq gis tualqa'tutew siguaqs'te'gn'ji'j ta'n piteg witapal ugpugugw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Na gelu'sit miti's wel minitew, gatu na miti's ta'n mo gelu'sigw ma ul minigw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Te's miti's weji gji'jut ta'n goqwe'l minigl. Ma ugja'tun wen'ju'su'n goqominaqsigtug, gisna ma ugja'tun nipmann ginigwejijuaqsigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Na ta'n wen gelu'sit tela'teget ta'n goqwei gelu'lg muta ula uggamlamun telgwitg. Ta'n wen mo gelu'sigw tela'teget ta'n goqwei mo gelu'lgtnug muta ula na uggamlamun wijei telgwitg. Te's mimajuinu wesgutg ta'n goqwei uggamlamung telgwitg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Goqwei wet tl wi'tin Gjisaqamaw, gatu mo tela'tegewn ta'n goqwei gis tlimulap? ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ta'n te'sit wen wejgu'et ni'neg aq tela'teget ta'n goqwei gis tluei, na tlimultes st'ge' ta'n wenij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Na st'ge' ji'nm ta'n el'toqop wiguow. Tmg tel mulqej temig elmalqei aq mesqana'toq epqanataqan. Na laqqap eteg gun'tewigtug. Ta'n tujiw sipu mespo'qeg na wen'ji'guom mo maja's'gtnugup muta welita's'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Gatu na mimajuinu ta'n nutmuitl ntglusuaqanml aq mo tela'tegegw ta'n telimg, negm st'ge' na ji'nm ta'n el'toqop wiguow t'pgwanigtug toqo mo epqanitugup tami. Ta'n tujiw sipu mespo'qeg na wen'ji'guom gegtugjalugweg aq gaq suisga'lugweg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ta'n tujiw Se'sus gaq tlimaji na mimajuinu'g ta'n goqwei tel puatg na pisgwa'j na gjigan ta'n teluisig Gapelniam. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na'te'l wigit Lo'mewa'juit, na niganpuguit sma'gnis. Geggunatl lugowinu'l ta'n gesite'lmatl. Ula lugowinu pajiji gsnugwat aq pemi np'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ta'n tujiw sma'gnis nutg Se'susal eimlitl na gjigan, elgimaji ta'siliji Lesui'pewe'g gisigu mawagnutmewinu' Se'suseg, ugjit pipaniman jugu'elin aq npilan uglugowinuml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Na Lesui'paq el'ta'jig Se'suseg aq etawaqtmua'titl apoqonmuguslin sma'gnisl. Telima'titl, “Ula sma'gnis te'p'g ugjit apoqonmuan ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Muta gesalaji Lesui'pa aq gisitoqop a'sutuo'guom ugjit ninen.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Se'sus wije'waji gatu ta'n tujiw mo amasegtnug sma'gnis wiguow weltesgua'tiji igtigi ta'n sma'gnis elgimaji Se'suseg. Wegla telimaji, “Saqamaw, na sma'gnis teluet, Mut lgowaqana'lsiw. Mu tetujiw glu'siw ugjit gi'l mittugwen nignaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","We'gaw mo tepawtiw jugu'en gi'leg. Pas'g tlua na glusuaqan aq ntlugowinum ila'sitew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na ta'sijig sma'gnisg assumijig aq ta'sijig sma'gnisg assumgig. Ta'n tujiw newte'jit telimg, ‘Lia!’ na eliet. Igtig telimg, ‘Jugu'a!’ na jugu'etew. Telimg lugowinu, ‘Ula tla'tega!’ na tla'tegetew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Se'sus paqalaig ta'n tujiw nutg ula. Gigto'qopugua'sit aq telimaji ta'ni majulgwalgwi'titl, “Telimuloq, lpa Lesui'pe'gatig menaq wen mo gejiaq ta'n tel ml'gi gtlams'tasit st'ge' ula sma'gnis.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ta'n tujiw na nutagnutmewinu'g apaita'jig sma'gnis wiguow nemia'titl sma'gnis lugowinu'l gisi ila'silitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na tel'gne'geg Se'sus eliet gjigan teluisig Nein. Unaqapemg aq pugwelgig mimajuinu'g wije'wa'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ta'n tujiw Se'sus iga'j ga'qana'tas'g ula gjigan, na mimajuinu'g pemapila'titl npuinu'l naji utqutamg. Ula npuinu na sigu'sgw newtipistatl uggwisl. Pugwelgig mimajuinu'g ta'n tleiawultijig na utan wijitgweiwa'titl ula sigu'sgwal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ta'n tujiw Gjisaqamaw nemiaj sigu'sgwal ewlite'lmatl aq telimatl, “Mut gaqiemtmu.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na tujiw Se'sus eliet pemapilaqanei aq sama'toq. Pema'taqatijig naqita'jig. Se'sus teluet, “Maljewe'j ji'nm, telimul pmgopa'si.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na ji'nm wenaqqopa'sit aq poqtewo'gwet. Se'sus apaji ignmuatl uggwitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ms't wen jipaqita'jig aq smtug emtoqwala'titl Gjinisgaml. Telimtultijig, “No'q gepme'g niganigjitegewinu gisi neia'sit ginueg!” aq “Gjinisgam pegising ugs'tawian ugmimajuinumg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ula agnutmaqan se'sa's'g ta'n telgi'g Jutiaewa'gig aq igtigl umutgiwal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sa'n unaqapemg telimji wegla ta'n goqwe'l Se'susal tela'tegelipnn. Na tujiw Sa'n tapusiliji unaqapemg wigumaji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Elgimaji Gjisaqamaweg ugjit pipaniman, “Gi'l na negm ta'n Sa'n teluet wejgu'ep wa'so'q? Pa na gi'l mu na negm, na esgmalatesnen ap igtig.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ta'n tujiw pegisingig Se'suseg na telima'titl, “Sa'n Nutsign'tuet petgimugsieg pipanimulin, ‘Gi'l na negm ta'n telteg pgisin gisna nat wen piluei esgmalatesnen?’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ge's emittugwala'titl Se'susal na nepilaji pugwenniji mimajuinu'g. Alt gesnugu'tipnig, alt mesnmi'tipnn milamu'gl gsnugowaqann aq alt nepapigwo'ltipnig. Se'sus ejigla'tuaji mn'tu'g ta'n pitu'gwiliji mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Na tujiw Se'sus telimaji Sa'n unaqapemg, “Apajita'gw aq tlimug Sa'n ta'n goqwe'l nemituoqol aq ta'n goqwei gis nutmoq. Nepapigwo'ltipnig nige' gis nmitaqatijig, wegla ta'n asgajo'ltipnig nige' gis ul pmita'jig, wegla ta'n geggunmi'tip 'gsnugowaqan teluisig leplsi gisi npilujig, wegla ta'n gepistaqana'tipnig nige' wel nutmu'tijig, npuinu'g nige' minua'lujig aq na ewle'juinu'g nutmi'tij na gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tetuji ulgwijintew ta'n wen mo megtuigw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ta'n tujiw Sa'n unaqapemg gis apaita'tij Sa'neg, Se'sus gelulaji mimajuinu'. Wesgumatl Sa'nal aq teluet, “Ta'n tujiw el'ta'ioqop Sa'neg paqtaqamigtug, goqwei getu' nmituoqos na'te'l? Mo getu' nmiwoqop menaqanat ji'nm st'ge' msigu'l asua's'g'pnn ugju'snigtug? ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Goqwei nat nmituoqos na'te'l? Getu' nmioqos ji'nm ta'n gegnesit mego'tigl aligal. Wegla mimajuinu'g ta'n wel'gnesultijig aq milesultijig wigultijig elege'wituo'guoml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tlimigw ta'n goqwei esgmatmoqos nmitunew na'te'l? Getu' nmioqos niganigjitegewinu. Telimuloq nemioqop ji'nm me' espe'g jel mu niganigjitegewinu. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sa'n na negm ta'n Gjinisgam nigani usgumapnn. Tel wi'gas'g Gjinisgam ugtwi'gatign, ‘Ge' jigs'tui. Nigangima's ntagnutmewinum ugjit gisgaja'tun ta'n lietes.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Se'sus siawewistoq, “Telimuloq, Menaq wen tetuji gepme'g ugs'tqamu eig st'ge' Sa'n. Gatu ta'n wen me' ewle'jit ta'n Gjinisgam etli ilgwenaji mimajuinu'g me' gepme'g aq negm.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ta'n tujiw mimajuinu'g maw nujintutma'tijig nutua'titl ta'n goqwei Se'susal gis tluelitl wel'te'lma'titl Gjinisgaml aq teluejig Gjinisgam tetapua'tegelitl. Wegla mimajuinu'g gis ignmua'tipnn Sa'nal sign'tuanew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Gatu na Palasiaq aq nutagnutmewinu'g mo getlams'tasultigupnig ta'n Gjinisgam tel puatg ugjit negmow, muta mo ignmua'tigupnn Sa'nal sign'tagunew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Se'sus siaw gluaji, “Wenig talo'ltijig st'ge' mimajuinu'g gisgug? Telimuloq telo'ltijig mimajuinu'g gisgug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Telo'ltijig st'ge' mijua'ji'jg ta'n pemgopultili'tij gujmug magasan. Ta'sijig gesigaw tlima'tiji igtigi, ‘Etl'te'tmuleg'pnn malie'wimgewe'l gtapegiaqann gatu mo amalgaltiwoqop. Etlintueg'pnn utqutamgewe'l gtapegiaqann gatu mo atgitemultiwoqop.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sa'n Nutsign'tuet pegising'p, sune'wip aq mo esamqwagup moqopa'q gatu gilew telueioq, ‘Mn'tu pitu'gwitl na ji'nmul.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ni'n na mimajuinualsiap. Ta'n tujiw pegisineg na mijjiap aq esamqwap na tujiw telueioq, ‘Ge' angamug u't ji'nm. Pusgi ugsamatalg aq negm na gtigiewinu. Witapa na nujintutma'tiliji suliewei aq lue'winu'.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Gatu na mimajuinu'g ta'n getlams'tmi'tij Gjinisgam ugtns'tuo'qonm na musga'tu'ti'tij ta'n goqwei Gjinisgam gis tla'tegep na teliaqewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Newte'jit Palasi pipanimatl Se'susal tgwatalnew. Toqo Se'sus eliet wiguaq aq epa'sit ugjit mijjin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Eig pata'tegewinu'sgw na gjigan ta'n Se'susal eimlitl. Ta'n tujiw nutg na Se'sus etlatalg Palasi wiguaq, na'te'l enma'latl gun'teweie'l pu'tai'l ta'n wejitasit alapastl. Waju'pelitl amjaqto'suti. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pisgwa't aq gaqamit gigjiw Se'susal uggwatl. Etltemit aq ugsaqpigunn saqapa'toqol Se'susal uggwatl. Usapunn e'w'gl ta'n tel niwa'tuaj uggwatl. Wesgaqaltmuatl uggwatl aq guta'tuatl weljema'gewei. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ta'n tujiw Palasi ta'n wigumapnn Se'susal wiguaq nemitoq ula na telimsij, “Pa na ula ji'nm na niganigjitegewinuewis na gji'jiatal ula e'pilitl ta'n sama'ltl na pata'tegewinu'sgw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Na tujiw Se'sus telimatl, “Simon nat goqwei getu' tlimul.” Simon teluet, “Nujigina'muet goqwei getu' tlimi?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Se'sus teluet, “Eig'pnig tapusijig ji'nmug ta'n tettua'tipnn nujimqatuigelitl suliewei. Newte'jit tettuatl na'n gasgiptnnaqana'igl aq igtig na'nisgega'igl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ta'n tujiw tapusijig mo gisi apangitua'tigweg na tujiw nujimqatuiget gitg apigsigtuaji. Tegen ji'nm me' gsalatal na nujimqatuigelitl?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon telimatl, “Amuj na ji'nm ta'n me' ma'muni tettuapnn.” Se'sus teluet, “Teliaq teluen.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na tujiw Se'sus elapa'sitl e'pilitl aq telimatl Simonal, “Angam ta'n goqwei ula e'pit gis tla'tegep. Ta'n tujiw pisgwa'ianeg giguaq mo ignmuiwt'p samqwan ta'n tli gsispa'tutes ngatl. Gatu ula e'pit gesispa'tuipnn ngatl, e'w'g'pnn ugsaqpigunn. Gispasmuipnn ngatl, e'w'g'pnn usapunn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mo wesgaqalmiwt'p gatu ula e'pit menaq puni gsalgaltmuigul ngatl weja'tegemg ta'n pisgwa'iap. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mo ignmuiwt'p mimei ugjit nun'ji gatu ula e'pit guta'tuit weljema'gewei ngatl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nige' telimul. Na teliaq ms't ugpata'taqanml gaqi apigsigta's'gl muta mawi gsalit. Ta'n getu wen apsi apigsigtut apsi gsaluetew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Se'sus telimatl e'pilitl, “Gpata'taqanml apigsigta's'gl.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Igtigig mimajuinu'g ta'n pemgopultijig na'te'l telimtultijig, “Wen ta u't ta'n apigsigt'gl pata'taqann?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Gatu Se'sus telimatl e'pilitl, “Westawugsin muta getlams'tasin. Nige' wantaqo'ti eteg ggamlamun.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Na tel gne'geg Se'sus mittugwatgl gjigann aq utann. Na pestung na gelu'lg agnutmaqan ta'n Gjinisgam ilgwenaji mimajuinu'. Unaqapemg ta'n newtisgegsiliji je ta'pu wije'wa'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ta'sijig e'pijig elt wije'wa'titl Se'susal. Na gisi npilut'pnig milamu'gl gsnugowaqann aq mn'tu'g ejigla'tupnig ugtinnewaq. Newte'jit na Mal Matle'n ta'n Se'sus ejigla'tuapni lluigneg te'siliji mn'tu'g negmeg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Igtig na Joana ta'n tepqatgig Gusaal. Na Gusa elugowatl Elotal aq niganpugua'laji sma'gnisg. Igtig e'pit na Susa'na aq pugwelgig igtigig e'pijig. E'wmi'tij ugsulieweimual aq ugtaligamual apoqonmuanew Se'susal aq unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pugwelgig mimajuinu'g ta'n tleiawultijig pugwelgl utann el'ta'jig Se'suseg. Ta'n tujiw ma'muniw pugwelgig mimajuinu'g eimu'tijig Se'suseg na telimaji a'tugwaqan, ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Newtejgeg na'gweg ji'nm naji se'sijio'toqol sginminn. Ge's etl se'sijio'toqol sginminn, ta's'gl eljo'ltigl tajigawti'jigtug. Mimajuinu'g pastesgmi'titl aq sisipg malqotmi'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ta's'gl eljo'ltigl gun'tewaqamigeg. Ta'n tujiw sginminn poqjigwegl, gispatewa'tigl muta maqamigew gispateg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ta's'gl sginminn eljo'ltigl ginigwejijuaqsigtug. Na ginigwejijuaqsi'g wel nigwejig aq wissuignemgwi'titl glumgl. Na gisa'tu'titl glumgl ewligwegl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ta's'gl sginminn eljo'ltigl gelu'lg maqamigew aq wel nigwegl na'te'l. Na wel minijgl. Newt gasgiptnnaqan sginminn wejiaqal alt glumgl.” Na tujiw telimaji, “Ango'tmug. Jigs'tmutigw ta'n goqwei gis telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Unaqapemg pipanima'titl ta'n goqwei getu' gina'muet ta'n tujiw e'w'g'p na a'tugwaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Se'sus telimaji, “Gjinisgam gisi ignmugsioq ns'tmu'tinew ta'n goqwei mo geitas'gtnugup aq pugwelgig mo nestmi'ti'gw ta'n ilgwenanew mimajuinu'. Pas'g gis nutmi'tip a'tugwaqan. Na jigs'tuipnig gatu mo nestmu'ti'gw na ta'n goqwei gis tluei.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“A'tugwaqan ula na telueg. Na sginminn pa na wijei aq Gjinisgam ugtwi'gatign. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ta'n tujiw sginminn eljo'ltig'pnn tajigawti'jigtug na pa na wijei aq mimajuinu'g ta'n nutmua'tij Nisgaml ugglusuaqanml aq smtug Gjimn'tu gisa'laji awan'ta'sultinew na gelu'lgl glusuaqann. Negla mimajuinu'g ma gtlams'tasulti'gw aq Nisgaml ma gisi ugs'tawigwi'tigul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ta'n tujiw sginminn eljo'ltig'pnn gun'tewaqamigeg na pa na wijei aq mimajuinu'g ta'n wel'ta'suatmi'tij ta'n gase'g nutmi'tij gatu mo tetapu majulgwatmi'ti'gw. Poqji gtlams'tasultijig gatu ta'n tujiw nat goqwei amsala's'g ejigli unaqita'jig. Na tujiw puni gtlams'tasulti'tij na gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ta'n tujiw sginminn eljo'ltig'pnn ginigwejijuaqsigtug na pa na wijei aq wegla mimajuinu'g ta'n nutmi'tij gelu'lg agnutmaqan gatu wesam sespete'tmi'tij milesuaqan, giso'qon aq ta'n te's'g goqwei gisa'lgwi'tiji ulgwijultinew. Na awan'ta'suala'titl Gjinisgaml aq mo goqwei tela'taqati'gw ugjit negm. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ta'n tujiw sginminn eljo'ltig'pnn gelu'lg maqamigew na pa na wijei aq mimajuinu'g ta'n nutmi'tij gelu'lg agnutmaqan aq weli gsua'tu'tij. Welgwijultijig uggamlamunual je mu atigna'sultijig aq siaw tla'taqatijig ta'n Gjinisgam tel puatg. Ta'n goqwei tela'taqati'tij pa na wijei aq glumgl ta'n teli ul minigl.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Mo wen wasoqwa'tug wasoqonmaqan aq oqonisgwa'tug lataqsunigtug gisna iga'tug lame'g npo'qonigtug. Awna gegupa'toq patawutigtug glaman mimajuinu'g nmitaqatitaq ta'n tujiw pisgwita'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ta'n goqwei mimugwa'tas'g na neia'tas'gt'tew aq ta'n goqwei anguna'tas'g na pa na wijga'tas'gt'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Na to'q ango'te'n ta'n tel jigs'tmn na gelu'lg glusuaqan. Ta'n wen geggung Nisgamewei gtlams'tuaqan me' ignmuaten aq ta'n wen mo geggunmug gtlams'tuaqan gatu tl'ta'sij geggung na tujiw jigla'tuaten na apje'jg gtlams'tuaqan geggung.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Se'sus uggwitl aq ugjignamg peita'jig negmeg gatu mo gis gigjita'gwig muta wesam pugwelgig mimajuinu'g eimu'tijig na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nat wen telimatl, “Ggij aq gjignamg eimu'tijig gujmug. Getu' glul'sgig.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Se'sus telimaji mimajuinu', “Ms't ta'nig nutmi'tij Gjinisgam ugtwi'gatign aq mo elistmi'ti'gw na negmow st'ge' ngij aq njignamg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Newtejgeg na'gweg Se'sus telimaji unaqapemg, “Ge' asoqomita'nej qospemg.” Tepita'jig ugtuluaq aq pusijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ge's pemaqtaqati'tij Se'sus nepat. Na tel gne'geg mtugunotg iga'q. Ma'muniw ugju's'g aq tgu'g tepjo'ltijig. Ugtuluow poqji ugjupaqtoqweg. Ms't eimu'tijig nsano'qonigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Unaqapemg el'ta'jig Se'suseg aq tugwa'la'titl. Telima'titl, “Saqamaw, gi'l na assusit, apoqnmuinen ge's mu samqwanigtug nepu'tiweg.” Se'sus menja'sit aq ilsutg ugju'sn aq tgu'g ugjit wantaqa's'gtn. Ugju'sn naqa's'g aq tgu'g wantaqita'jig. Na tujiw qospem weli ewipg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na tujiw pipanimaji unaqapemg, “Tali gtlams'tasultioq?” Na toqo tujiw paqalaiultijig aq jipaqita'jig. Telimtultijig. “Wen ta u't ji'nm tetuji piam melgimaji ugju'sn aq samqwan.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na siawaqtaqatijig aq oqwa'jig Gelasiewa'gi ta'n eteg tegpaqiw qame'g Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Na Se'sus na'taqampugua'sij weltesguatl ji'nmul tleiawilitl gjigan Gelasa. Ula ji'nm wesgweiagwi'titl mn'tu'g. Gi's sa'q mo goqwei nasgmug. Mo wiguaq wesgewa'sigw gatu awna wesgowa'sit utqutaqane'gatig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ta'n tujiw nemiatl Se'susal eliet aq nutgul'pa'sit ta'n gaqamilij. Sesgwalatl, “Se'sus, gi'l na espe'g Gjinisgam uggwisl. Goqwei getu' tla'lin? Etamul, mut ugtapuliw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ula teluet muta Se'sus gis telimaji mn'tu'g tualqa'sinew na ji'nmeg. Me' gatu gaqaisg mn'tu'g assuma'tipnn. Na tujiw mimajuinu'g gelpila'tipnn aq pija'la'tipnn laplusang gatu ula ji'nm temeg'pnn ta'n gelpiteg'pnn uggwatl aq ugpitnn, aq wesmugwap paqtaqamigtug. Nige' wigit utqutaqane'gatig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Se'sus pipanimatl, “Taluisin?” Negm teluet, “Ni'n teluisi Pugwelgig.” Ula teluet muta pugwenniji mn'tu'g pitu'gwi'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mn'tu'g etawaqtmua'titl Se'susal, ugjit mu lgimugsinew na ma'muniw temig elmalqe'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Gigjiw na'te'l eimu'tijig pugwelgig gulgwi'sg ta'n etl jigniga'tijig soqoqamigeg. Mn'tu'g etawaqtmua'titl Se'susal ugjit lgimugsinew gulgwi'sg ugtinneg. Na ignmuaji tla'taqatinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Smtug mn'tu'g ejiglita'jig na ji'nmul aq el'ta'jig gulgwi'sg ugtinneg. Na ms't gulgwi'sg pem'tugu'ltijig pemse'g aq nitjo'ltijig samqwanigtug. Ms't getmenetgi'g samqwanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ta'n tujiw ji'nmug ta'n angweiwa'tipni gulgwi'sgi'g nemitu'tij ta'n gis tliaq smtug maita'jig aq se'sa'tu'tij agnutmaqan gjigan aq ms't ta'n tami el'ta'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mimajuinu'g naji angaptmi'tij ta'n goqwei gis tliaq. Ta'n tujiw peita'tij Se'suseg nemia'titl na ji'nmul ta'n mn'tu'g wesgweiat'pnig. Ula ji'nm pemgopit gigjiw Se'suseg. Gegnesit aq tetapu angita'sit. Na mimajuinu'g jipaqita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na ji'nmug ta'n nuje'wa'tipni gulgwi'sgi'g telima'tiji esgwia'tiliji ta'n ji'nm teli npisip. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na tujiw mimajuinu'g tleiawultijig Gelasiewa'gig pipanima'titl Se'susal ugjit jigla'silin muta jipaqita'jig. Na tujiw Se'sus aq unaqapemg tepita'jig ugtuluaq aq poqji pusijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na ji'nm ta'n gisi npilut'p etawaqtmuatl Se'susal, “Ignmui wije'ulin.” Gatu Se'sus telimatl, ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Apaja'si giguaq aq tlim gigmaq ta'n Gjinisgam gis tla'l'sg.” Na ji'nm getloqo eliet ta'n telgi'g gjigan aq telimaji pugwenniji mimajuinu' ta'n Se'susal gis tla'lt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ta'n tujiw Se'sus apaja'sit qame'g qospemg pugwelgig mimajuinu'g wel'ta'suala'titl nmianew muta etli esgmala'tipnn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na tujiw ji'nm teluisit Jailus pegising Se'suseg. Niganpuguit a'sutuo'guomg ta'n eteg na'te'l. Smtug nutgul'paqjetesing ta'n Se'susal gaqamilij aq etawaqtmuatl lielin wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Wipsgunatl ugtusl ta'n metlasipuna'litl je ta'pu pemi nplitl. Ge's Se'sus pemiej pugwelgig mimajuinu'g gigjiw wije'wa'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na e'pit na'te'l wije'waji. Metlasipunqeg je ta'pu pusgi mal'tewiet aq gaqotg ugsulieweim mal'pale'wiliji gatu lpa mo wenn gisi npiligugul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na etepnatl Se'susal aq sama'tuatl ugpisan pitu'gunn. Smtug naqa's'g ta'n tel mal'tewiep. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Se'sus pipanimapni, “Wen gi's sama'lit?” Ms't wen petgwasit aq Pie'l telimatl, “Saqamaw, gi'l na assusit, pugwelgig mimajuinu'g gigjipugutasgig. Etug nat wen pet samtesgasg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Gatu Se'sus teluet, “Geji'g nat wen sama'lip muta ml'gigno'tim tewiaqap ni'neg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na e'pit geitoq ma gisigasigw ta'n tel gisi npisip. Na tujiw poqji neng'tesing. Eliet Se'suseg aq nutgul'pa'sit. Telimatl Se'susal aq igtigi tal gi's wet sama'lin aq smtug gisi npisit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Se'sus telimatl, “Tu's ta'n teli gtlams'tmn na weji npisin. Nige' lietes wantaqo'ti'gtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ge's Se'sus etlewistoq na pegising ji'nm na'te'l. Wejiet Jailus wiguaq. Telimatl Jailusal, “Gtusaq nepgaq. Mut lgowaqana'law nujigina'muet.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Gatu Se'sus nutg aq telimatl Jailusal, “Mut jipasiw. Pas'g gtlams'tasi aq gtus ila'sitew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ta'n tujiw Se'sus pegising Jailus wiguaq mo wenn ignmuagul pisgwa'lin pas'g Pie'lal, Sa'nal, Ji'mejal aq mijua'ji'j ungi'gug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na mimajuinu'g ta'n eimu'tijig Jailusal wiguaq atgitemultijig aq mesgo'ltijig ugjit mijua'ji'jl. Se'sus telimaji, “Mut gaqiemtmutinew, na mijua'ji'j mo nepmug pas'g nepat.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na ms't wesgewe'wa'titl muta gejia'titl mijua'ji'jl nepmlita. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Se'sus wesua'latl mijua'ji'jl ugpitng aq telimatl, “Mijua'ji'j, mn'ja'si.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na mijua'ji'j apaji mimaju'et aq smtug menja'sit. Se'sus igtigi telimaji nat goqwei smug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ungi'gug sigti paqalailiji gatu Se'sus telimaji, “Mut tlimanew wenn ta'n gis tliaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Se'sus mawa'laji newtisgegsiliji je ta'pu unaqapemg aq ignmuaji ml'gigno'ti ugjit tuaqtesguanew mn'tu'g aq gisi npitmnew milamu'gl gsnugowaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na gisgaja'laji ugjit npilanew gesnugu'tiliji, al pestunmnew aq tlimgwi'tinew mimajuinu' na Gjinisgam apugjig ilgwenata mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Telimaji, “Lpa ta'n tel mili al'ta'ioq, mut goqwei nespnmnew. Mo aptun, mo salitewimgewei mun'ti, mo mijipjewei gisna suliewei, je mu piamiet atla'i. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ta'n etl pisgwigimugsioq utang, siaw i'mug wijei wen'ji'guomg glapis ta'n tujiw naqtmoq na utan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Te's tami pisgwita'ioq utanji'j aq mimajuinu'g mo pewalugsiwoq i'mu'tinew nqatmug na utan aq puaqtestug ggatual. Tla'taqatigw ugjit musga'tuanew na Gjinisgam mu wel'te'lmagwi.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na unaqapemg naqtmi'tij ta'n Se'sus eig aq el'ta'jig pugwelgl utann. Al pestunmi'tij na gelu'lg agnutmaqan aq nepila'tiji mimajuinu' ms't tami. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ta'n tujiw Elot ta'n niganpugutg Galaliewa'gig nutg ta'n goqwei Se'susal gis tla'tegelipnn mo geitug ta'n tli angita'sitew, muta alt mimajuinu'g teluejig, “Sa'n Nutsign'tuet apaji minunsit.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ta'sijig mimajuinu'g teluejig Ilaija apaji neia'sit aq igtigig teluejig gisiguaq niganigjitegewinuaq ta'n gi's sa'q mimajipnaq apaji mimaju'et. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Elot teluet, “Gisa'lg'pnaq Sa'n Nutsign'tueto'q temgwetoqsin gatu wen ta u't ji'nm ta'n mimajuinu'g agnimgwi'titl?” Na weja'tegemg wejo'tg nmian Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na apostale'wijig apaita'jig Se'suseg aq telima'titl ta'n goqwe'l gis tla'taqatipnn. Na tujiw Se'sus ela'laji pas'g negmowa na gjigan ta'n teluisig Petse'ta. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ta'n tujiw mimajuinu'g nutma'titl Se'susal i'mlin Petse'taeg, pugwelgig majulgwala'titl na'te'l. Se'sus wel'ta'sit nmianew aq telimaji ta'n Gjinisgam apugjig ilgwenata mimajuinu'. Nepilaji ta'ni gesnugu'tiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ta'n tujiw poqji galqwasiet, unaqapemg telimgwi'titl, “Jiglgim mimajuinu'g glaman gisi lta'taq utann aq nuji iga'taqu'tijig tepaw. Na'te'l msntaq mijipjewei aq ta'n i' tli gt'gunultimg. Eimu'ti'gw ta'n etl taqawatteg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Gatu Se'sus telimaji, “Ignmug nat goqwei malqotmnew.” Telima'titl, “Pas'g na'ngl pipnaqann geggunmegl aq tapusijig nme'jig. Pewalieg lta'nen magasang ugjit pgwatelminen mijipjewei ugjit ta'n te'sijig.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Eimu'tijig na'te'l panaemg na'n pituiptnnaqan te'sisgegsijig ji'nmug.) Se'sus telimaji unaqapemg, “Gisa'lug mimajuinu'g pmgopita'new te's na'nisgegsijig.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Unaqapemg gisa'lgwi'tiji mimajuinu'g pmgopita'new maqamigeg te's na'nisgegsijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Na tujiw Se'sus wesua'toqol na'ngl pipnaqann aq tapusiliji nme'ji aq elapa'sit wa'so'q. Miwatmuatl Nisgaml ugjit ula mijipjewei. Nasgwa'toqol aq ignmuaji unaqapemg ugjit ms't wen msnmnew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ms't ta'n te'sijig g'satalultijig. Na tujiw unaqapemg megnmi'titl mijipjewei ta'n piamiaq aq newtisga'qal jel ta'pu ligpenignn wajua'tu'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Newtejgeg na'gweg ge's Se'sus newti a'sutmateg, unaqapemg peita'liji. Na tujiw Se'sus pipanimaji, “Tal'ta'sultijig mimajuinu'g wenin ta ni'n?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Telima'titl, “Alt mimajuinu'g teluejig gi'l na Sa'n Nutsign'tuet aq igtigig mimajuinu'g teluejig gi'l na Ilaija aq ap igtigig teluejig gi'l na newte'jitaq niganigjitegewinuaq ta'n gi's sa'q nepg'pnaq gatu nige' apaji mimaju'et.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Se'sus pipanimaji, “Tal'ta'sultioq weni ta ni'n?” Pie'l telimatl, “Gi'l na Nujiugs'tawi'wet aq wejien Gjinisgameg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Se'sus melgimaji ugjit mu wenn tlimanew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Elt teluet, “Ni'n na mimajuinualsiap aq amujpa ma'muni ulmajeia's. Niganpugultijig a'sutuo'guomg, niganpugultijig patlia'sg aq elg nujigina'mua'tijig tplutaqan masgelmitaq. Gisa'litaq ne'po'qsin aq gisi nesuguna'q apaji minunsites.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Telimaji ms't ta'n te'siliji, “Ta'n getu wen getu' wije'wij amujpa awan'ta'sualsit aq tla'teget ta'n Gjinisgaml tel puatmlitl. Amujpa gisgaje'g ulmaje'n te'sigisg'g. Na tujiw gisi majulgwalitew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Na mimajuinu ta'n getu' ugs'tawi'sit na ma gugunmug iapjiwewei mimajuaqan wa'so'q, gatu na mimajuinu tela'teget ta'n goqwei pewatm je tlia ne'po't muta majulgwalit na ugs'tawia's. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tali ugtapsunig na ji'nm te's'g goqwei assutg ta'n telgi'g ugs'tqamu gatu mo gugunmug iapjiwewei mimajuaqan wa'so'q?. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ta'n wen netaqite'lmit aq netaqite'tg ta'n goqwei tel gina'muei na ta'n tujiw apaja'sia's tlimates nujj na ala mimajuinu mu na ninenewei nnaqapeminen, muta ni'n na mimajuinualsiap. Ta'n tujiw apaja'sia's maw sape'ultijig ansale'wijig na tujiw gepmite'lmimg aq emtoqwalimg st'ge' nujj gepmite'lmut aq emtoqwalut nige'. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Migwite'tmug ula. Eimu'tioq ta'sioq ula tet ta'n ma npu'tiwoq glapis nemitu'tioq ta'n Gjinisgam ilgwenaji mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na pesgunateg te'sisga'qal na'gwegl gis iga'qal, Se'sus so'qwiet gm'tng naji a'sutmat. Ela'laji Pie'lal, Sa'nal aq Ji'mejal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ge's etli a'sutmaj ugsisgw paqtata's'g aq utapsunn gesi wapa'tigl aq paqtata'tigl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na tapusijig ji'nmug neia'tijig aq etl glula'titl Se'susal. Wegla na Mowiso'q aq Ilaijao'q. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Utapsunual gesigaw wapa'tigl aq paqtata'tigl aq ugsisgual paqtata's'gl. Na etl agnutmua'titl Se'susal. Wesgutmi'tij ta'n tl ne'pa'ten Se'sus Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ge's ula teliaq, Pie'l aq witapa gis gepsgia'tijig. Na jiniw tugwia'tijig aq nemia'titl Se'susal paqtata'silitl aq tapusiliji ji'nmug gaqamiliji negmeg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mowis aq Ilaija pemi nqala'tij Se'suseg, Pie'l telimatl, “Saqamaw, gi'l na assusit, na mawi glu'lg tet eimu'tieg. Ge' nesisgl anapjetegewe'l ltutesnen, newte' ugjit gi'l, newte' ugjit Mowis aq igtig ugjit Ilaija.” (Na Pie'l mu nestmug ta'n goqwei wesgutg.) ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ge's Pie'l etlewistoq na alug neia's'g aq tetpaqiw naqa's'g ta'n gaqamultijig. Na tujiw unaqapemg we'gwata'sultilij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nat wen metewistoq alugwigtug. Teluet, “Ula na ngwis ta'n mawi gsalg. Jigs'tug negm.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ta'n tujiw gaqewistoq na pas'g Se'sus aq unaqapemg eimu'tijig na'te'l. Toqo nisita'jig gatu weli pgije'g we'gaw unaqapemg telimji wenn ta'n goqwei gis nmitu'tip gm'tnigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na igtig na'gweg Se'sus aq unaqapemg nisita'jig, aq na pugwelgig mimajuinu'g naji ultesgua'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na ji'nm ta'n eig na'te'l sesgwalatl Se'susal, “Nujigina'muet etawaqtmul ge' angam wipsgung ngwis. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Lpa jiniw mn'tu'l pesu'gwatatl aq smtug lpa'tuj gesigaw sesgwet. Na mn'tu gisa'latl ugjipulgwelin aq ugtun pisewiaq. Siawi asgaiwatl aq lpa mo getu' punaje'wagugul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Etawaqtmaqapnig gnaqapemg jigla'tuinew mn'tu gatu mo gis tla'taqati'gw!” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Se'sus teluet, “Gilew ta'n mimajultioq gisgug mo getlams'tmu'tiwoq aq mo tetapua'taqatiwoq. Me' gatu tali pgitgalultoqs'p? Tali pgiji gina'multoqs'p glapis getlams'tmu'tioq?” Na tujiw telimatl ji'nmul, “Jugwa'l ggwis ula tet.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ge's wejgwa'laj lpa'tujl na mn'tu mesganegetl maqamigeg aq smtug poqji ugjipulgwelitl. Smtug Se'sus ejigla'tuatl mn'tu'l ugtinneg. Na ila'silitl lpa'tujl aq apaja'lut ujjeg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ms't mimajuinu'g sigti paqalaiultijig muta nemitu'tij ta'n telgi'g Gjinisgamewei ml'gigno'ti. Na mimajuinu'g me' paqalaiultijig ugjit ta'n Se'sus gis tla'tegep, na tujiw Se'sus telimaji unaqapemg, ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mut awan'ta'sinew ula ta'n goqwei telimuloq. Ni'n na mimajuinualsiap aq Gjinisgam ignmuata mimajuinu'g na ml'gigno'ti ugjit tla'lin ta'n tel puatmi'tij.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Unaqapemg mo nestua'tigul Se'susal ta'n gisi usgutmlij. Mimugwa'tas'g ugjit mo nestmi'ti'gw. Jipaqita'jig pipaniman ta'n gis teluelij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Se'sus unaqapemg gi'gaita'liji. Getu' gji'tu'tilij ta'n wen me' espe'g te'si'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Se'sus gejiaji ta'n goqwei angite'tmi'tij. Na tujiw wesua'latl mijua'ji'jl, aq gaqama'latl gmetug negmeg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Telimaji unaqapemg, “Ta'n getu wen weligsua'latl ula mijua'ji'jl muta gisi ignmaq'p ml'gigno'ti ugjit tla'tegen na uligsua'litew. Ta'n getu wen weli msnit na elg uligsua'latal ta'n wen petgimit. Ta'n wen tel'te'lsit mo me'gite'lmam'g na negm mawi gepme'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sa'n telimatl Se'susal, “Saqamaw, gi'l na assusit, nemi'g'tt'p ji'nm ta'n ejigla'lapni mn'tu'g aq teluet e'w'g ml'gigno'tim ta'n gis ignmat'p. Telimg'tt'p naqa'sin muta mo wijitgweiugsiweg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Se'sus telimatl, “Mut naqa'lan, Ta'n getu wen mo getanugsiwgw na apoqonmugsi'gw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ge's na na'gwegl poqji iga'qt'tew ta'n Se'sus lietew wa'so'q, na gisita'sit lien Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nigangimaji agnutmewinu' Samaliaewei utan. Na'te'l ms't goqwei getu' gisgaja'tu'titaq ugjit Se'sus aq unaqapemg gt'gunultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Gatu mimajuinu'g mo pewala'tigul Se'susal pisgwa'lin na utan muta gis gejia'titl na gisita'silitl lielin Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na tujiw tapusiliji unaqapemg teluisiliji Ji'mej aq Sa'n ula nutmi'tilij pipanimgwi'titl Se'sus, “Gjisaqamaw, pewalieg pipaniman nat wen nisgitmn pugtew ta'n wa'so'q tleiawig aq ne'pa'nen ta'n te'sijig eimu'tijig ula utan?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Se'sus gigto'qopugua'sit aq majiaqa'laji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na tujiw Se'sus aq unaqapemg se'g utan siawita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ge's Se'sus aq unaqapemg pemita'tij awtigtug na ji'nm telimatl Se'susal, “Gisgaje'i wije'ulin ta'n getu tami elien.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Se'sus telimatl, “Wowgwis geggung elmalqei ta'n loqosma'sitew aq sisipji'jg geggunmi'titl ugtwisse'mual ta'n tli atlasmultitaq gatu mo geggunmu ta'n tli atlasmites je tlia ni'n na mimajuinualsiap.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Se'sus igtigl ji'nmul telimatl, “Majulgwali ni'n.” Na telimtl, “Saqamaw Getu' naji utqutalg nujjaq ta'n tujiw gisi np'g'pnaq. Na tujiw gisgaje'tes wije'ulin.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Se'sus telimatl, “Ignmu ta'n wen ma majulgwaligw utqutalan ta'n nepmlitl, gatu gi'l lia aq naji pestunen ta'n Gjinisgam getu' ilgwenaji mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ap igtig teluet, “Saqamaw, majulgwalultes gatu tmg ignmui lien aq tliman nigmaq, ‘Naqaluloq ugjit lugowan Gjinisgam.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Se'sus telimatl, “Ta'n wen getu' majulgwalit aq getu' apjinmiet wiguaq na mo tepawtigw ugjit pestunmn ta'n Gjinisgam ilgwenaji mimajuinu' muta negm na pa wijei aq na ji'nm ta'n elgesawet aq iapsgulapit.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Na tel gne'geg Gjisaqamaw megnaji lluigneg te'sisgegsiliji je ta'pu mimajuinu'g ugjit toqwanqapultinew. Te's toqo lugwejig i' tapusiliji. Getu' nigangimaji ugjit la'tinew utan gisna na'tami se'g ta'n getu' naji mittugwej. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ge's mu elgimaji, na telimaji, “Pugwelgig mimajuinu'g ta'n getu' majulgwala'titl Nisgaml, gatu mu piam pugwelu'g mimajuinu'g ugjit tlimanew ta'n tel majulgwala'titl Nisgaml. A'sutma'tigw aq pipanimug Gisiteget ugs'tqamug lgimanew pugwenniji ugjit tlimanew na gelu'lg agnutmaqan glapis majulgwalan Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lta'qw ta'n getu' naji mittugwei. Gilew pa wijei aq jijgluewji'jg gatu nige' elgimuloq ta'n eimu'tijig mimajuinu'g pa wijei aq paqtesmug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mut nespnanew gpo'jmuaq, mijipjewei mun'ti gisna piamiejig mg'sng. Mut naqita'new maw agnutma'tinew wen ultesguatoqs'p awtigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ta'n tujiw pisgwita'ioq ta'n wen wiguaq, tmg tluegw. ‘Pipanimg Gjinisgam ignmugsinew wantaqo'ti ggamlamunuaq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pa na mimajuinu ta'n gesatg wantaqo'ti wigij na'te'l Gjinisgam ignmuatal ta'n goqwei pipanigesultioq gatu pa na mimajuinu ta'n mo gesatmug wantaqo'ti wigij na'te'l mut pipanimaw Gjinisgam ignmuan wantaqo'ti. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Siaw i'mug na wijei wen'ji'guomg aq malqotmug ta'n goqwei esmugsioq. Mut i'mnew igtigi se'g wen'ji'guoml. Mijjigw ta'n goqwei esmuj muta na ji'nm ta'n pestung mu netaqe'gw ugjit mijjin ta'n goqwei esmuj. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ta'n tujiw pisgwa'tioq utan aq wen pipanimugsioq gisi i'mnew wiguaq, malqotmug ta'n goqwei esmugsioq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Npilug gesnugu'tijig ta'n eimu'tijig na'te'l aq mimajuinu'g tlimug, ‘Nige' Gjinisgam poqji ilgwenugsioq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ta'n tujiw pisgwa'tioq utan aq mo wen pewalugsiwoq mittugwalanew, la'tigw awtigtug aq tlimug, ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Pewaqtemeg mjegei ta'n nasteg nmugsninaq. Ula tela'tegeieg muta getu' musga'tuleg Gjinisgam mo gesatmug ta'n tela'taqatioq. Gatu migwite'tmug ula, Gjinisgam getu' ilgwenugsioq nige' gatu mo ignmugsiwoq tla'tegen.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na tujiw Se'sus telimaji unaqapemg, “Telimuloq, ta'n tujiw Gjinisgam ilsumata ms't mimajuinu'g, me' ewlite'lmata na mimajuinu' tleiawultilipni na gjigan ta'n teluisig Satm je mu na mimajuinu'g tleiawultijig ala utan.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“No'q mtue'tew ugjit wegla mimajuinu'g ta'n tleiawultijig na utann ta'n teluisigl Golasin aq Petse'ta muta gis nmitu'tipnn pugwelgl paqalaiuti'l ta'n gis tla'tas'g'pnn gatu siaw pata'taqatijig. Na mimajuinugi'g tleiawultipnig na utann teluisigl Tail aq Saiton na lue'ultipnig. Pa na nmitu'tisnn wije'l paqalaiuti'l, na smtug sa'se'wita'sulti'tisoq aq pun pata'taqati'tisoq. Gi's nige' sa'q nasgmi'tisoq maqtawamu'gl aligal aq amalsulti'tisoq wisgipg ugjit musga'tunew mesgo'ltipnig ta'n tel pata'taqatipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ta'n tujiw Gjinisgam naji ilsumaj ms't mimajuinu ugs'tqamu, me' ewlite'lmata na mimajuinu' tleiawultilipni na gjigann Tail aq Saiton je mu na mimajuinu'g tleiawultijig na gjigann Golasin aq Petse'ta. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na mimajuinu'g tleiawultijig na gjigan Gapelniam pewatmi'tij me' espite'lsultijig st'ge' ansale'wiliji wa'so'q gatu awna la'lata ta'n npuinu' eimu'tiliji.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Se'sus telimaji na mimajuinu' ta'n gis mgnapni, “Ta'n getu wen jigs'tugsioq na jigs'tuites. Ta'n wen alua'lugsioq na alua'litew. Ta'n getu wen alua'lit, alua'latl ta'n wen petgimip.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ula lluigneg te'sisgegsijig je ta'pu mimajuinu'g gis tela'taqatipnig ta'n goqwei Se'sus pewatg aq apaita'jig Se'suseg. Ma'muniw ul'ta'sultijig aq telima'titl, “Gjisaqamaw, we'gaw mn'tu'g tela'taqatipnig ta'n goqwei telimg'tt'pnig muta gis ignmuieg'p ml'gigno'ti ugjit gis tla'taqatitesnen.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Se'sus telimaji, “Nemi'g'p Gjimn'tu nisiet wa'so'q pa wijei aq wasoqotesg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jigs'tuigw. Ignmuloqop ml'gigno'ti ugjit wissuignemanew Gjimn'tu st'ge' gisi ewtapuguitatoqs'p mtesgmug aq juji'jg teluisultijig sqolpiang. Mo eigtnug ta'n goqwei jile'ugsitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pas'g mut ul'ta'sultinew ta'n tujiw mn'tu'g tela'taqatipnig st'ge' tel pualanew, awna ul'ta'sultigw muta gtwisunmual gis ewi'gas'gl Gjinisgam ugtwi'gatign ta'n eteg wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na tujiw Wejuli Nisgam gisa'latl Se'susal no'q ulgwijinin. Se'sus teli a'sutmat, “Gi'l na nujj aq na assutmn wa'so'q aq ugs'tqamu. Miwatmul muta ta'nig mo geggunmi'ti'gw gina'masuti musga'tajig ula teliaqewei gatu wijei mo musga'tuawjig ta'nig nestmi'tij pugwelgl goqwe'l. Teliaq, gi'l na nujj aq welm'tun ta'n tujiw tela'tegen ta'n tel puatmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Se'sus telimaji mimajuinu', “Nujj ta'n eig wa'so'q gisi ignmuij ms't goqwei. Ni'n na Gjinisgam uggwisl aq mo wen nenuigw st'ge' nujj. Mo wen tel nenuagul nujjl st'ge' ni'n ta'n tel nenaq. Na mimajuinu'g ta'n musga'taqig na gis nenua'titl ta'n wenit Gjinisgam.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na tujiw Se'sus gigto'qopuguit aq pas'g unaqapemg telimaji, “Na mimajuinu'g ulgwijultitaq ta'n tujiw nemitu'tij aq nestmi'tij ta'n goqwei gis nmituoq aq gisi ns'tmoq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Telimuloq, pugwelg'pnig niganigjitegewinugi'g aq pugwelg'pnig elege'witgi'g getu' nmitu'tipnigl ta'n goqwe'l gis nemituoqol gatu mo gis nmitu'tigupnigl. Getu' nutmi'tipnigl ta'n goqwe'l gis nutmoqol gatu mo gis nutmi'tigul.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na nutagnutmewinu pegising muta getu' we'gwamuatl Se'susal. Pipanimatl, “Nujigina'muet, tali msntes iapjiwewei mimajuaqan?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Se'sus pipanimatl, “Tal wi'gas'g Gjinisgam ugtwi'gatign? Tali ns'tasin?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na ji'nm telimatl, “Tel wi'gas'g, ‘Pajiji gsal Gisiteget na Gjinisgam ta'n emtoqwalugg. Amujpa me' gesalt je mu mimajuinu'g. Ta'n tujiw tela'tegen ta'n pas'g goqwei amujpa e'we'n ms't gml'gigno'tim musga'tu me' gesalt je mu mimajuinu'g. Ta'n tujiw angite'tmn ta'n pas'g goqwei amujpa me' gepmite'lm't je mu gepmite'lmawjig mimajuinu'g. Amujpa tli gsal igtigig st'ge' ta'n teli gsalsin.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Se'sus teluet, “Teliaq ta'n teluen. Pa na tla'tegen, guguntes iapjiwewei mimajuaqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Gatu na ji'nm pewalatl ms't wenn tl'ta'silin negm geitoq ta'n goqwei wesgutg. Glaman pipanimatl Se'susal, “Gjinisgam pewalit wenn gsalan?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Se'sus telimatl, “Newtejgeg na'gweg ji'nm tleiawit Selusalemg pem liet Jeligoq. Ge's pemiej ji'nmug matna'titl aq gemutma'titl ms't goqwei geggunmilij. Wesmultijig aq naqala'titl aqati npilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na gis tliaq, patlia's pemiet ula wijei awti. Pas'g angamatl aq siawa'sit awtigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tel'gne'g igtig ji'nm pemiet. Negm na nujiapoqonmuet a'sutuo'guom pemiet. Angamatl ula ji'nmul aq asoqoma'sit awti aq siawa'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ap igtig ji'nm ta'n tleiawit Samalia pemiet. Tel nmiaj ji'nmul ewlite'lmatl aq elietl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Elguta'toq gijga'ji'j moqopa'q ugla'qanml Mima'tuatl aq ajijgopilmuatl. Tepa'latl ugtue'mg aq ela'latl na wen'ji'guomg ta'n i' tli gt'gunultimg. Angweiwatl na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na igtig na'gweg, ignmuatl assusilitl ula wen'ji'guom ugtapangitueweim. Telimatl, ‘Etamul angweiwan ula ji'nm aq ta'n tujiw apaja'sian apangitultes ta'n telgi'g tettul.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na tujiw Se'sus pipanimatl nujigina'muelitl tplutaqan, “Tal'ta'sin? Nesisijig ji'nmug nemia'titl ji'nmul ta'n gmutnesg matna'tipnn awtigtug. Tegen me' gesalatl na ji'nmul?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na ji'nm ta'n nujigina'matg tplutaqan teluet, “Ta'n wen wele'wapnn na ji'nmul.” Se'sus telimatl, “Lia aq wijei tla'tega st'ge' negm.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ge's Se'sus aq unaqapemg pemita'jig peita'jig utan ta'n wigilitl na e'pilitl teluisilitl Malta. Ula e'pit pipanimatl Se'susal pisgwa'n wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Malta uggwe'ji'tl teluisilitl Mali. Mali pemgopa'sit gigjiw Gjisaqamawl uggwatg ge's pemgopilitl wiguaq aq jigs'tuatl ta'n tel gina'muelij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Malta elugwet pugwelg lgowaqan ta'n geggung aq sespete'tg. Eliet Se'suseg aq pipanimatl, “Gjisaqamaw, tel'tasin na gelu'lg ta'n tujiw ngwe'ji'j mo apoqonmuigw? Pas'g ni'n elugwei. Tlim, apoqonmuij!” ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Gjisaqamaw telimatl, “Malta, wesam sespete'tmnn pugwelgl ta'n goqwe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Gatu pas'g newte' ta'n goqwei menuegetun. Mali getu' tetapua'tegen ta'n tujiw jigs'tuin. Mo pewalaq nat wen naqa'lan.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Newtejgeg na'gweg Se'sus etli a'sutmap na'tami. Ta'n tujiw gisi a'sutmateg, unaqapeml telimtl, “Gjisaqamaw, gnu'tmuieg ta'n teli a'sutmamg st'ge' ta'n Sa'n Nutsign'tuet tel gina'muapni unaqapemg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Se'sus telimaji unaqapemg, “Ta'n tujiw a'sutma'tioq tluegw: “ ‘Nujjinen, ta'n wa'so'q eim, gepmite'lmuleg sape'wig gtwisunm. Pipanimuleg ilgwenan mimajuinu'g glaman majulgwalultaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Etamuleg ignmuinen te'sigisg'g ta'n goqwei nuta'ma'tieg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Apigsigtuinen ntlue'utinal, st'ge' apigsigtaqatt ms't wen ta'n tel pata'lugsieg. Mut ignmuinen lta'nen winjigigtug.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na tujiw Se'sus telimapni unaqapemg, “Nantawa's'g'p nat wen gilew eliess gitapaq aqtatpa'q aq pipanigesiss, ‘Nitap, ge' mqatui nesisgl pipnaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Igtig nitap peji mittugwalit aq mo goqwei geggunmu ta'n sma's.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Etugjel na gitap ta'n me' lamguomg meteweng, ‘Punaje'wi. Ntga'qanm gis apt'sqa's'g. Ninen aq nn'janinaq gis nep'tieg, aq ma gisi mn'ja'siw ugjit goqwei ignmulin.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Telimuloq na ji'nm ma mn'ja'sigw aq ma ignmulug na pipnaqann je tlia ta'n tel gitapewioq, gatu amujpa mn'ja'sitew aq ignmultew ms't goqwei gelutmn muta mo netaqe'wn ta'n tel siaw pipanigesin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Glaman wet tlimuloq, Pipanigesultigw aq ignmugsitoqs'p. Gwilmug, aq we'jittoqs'p. Mtete'gatigw, aq Gjinisgam pana'tutew na ga'qan ugjit gilew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ta'n getu wen pipanigesit na msntew. Ta'n getu wen gwiluasit na we'jittew, aq na ga'qan pana'tuaten ugjit negm ta'n metete'get. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nat wen ta'n te'sioq un'januit ma ignmuagul uggwisl mtesgmul pipanigesij nme'jl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma ignmuagul mesgilg go'qweji'j ta'n tujiw pewatmlij wa'w. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Geituoq ta'n tli ula'latoqs'p gn'januaq aq ignmatoqs'p gelu'lgl goqwe'l je tlia tel lue'ultioq. Na elg wijei gujjinu ta'n eig wa'so'q me' ignmuatal Wejuli Nisgaml ta'n wen pipanigesilitl.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na'te'l eig na ji'nm ta'n mu gis glusigw muta mn'tu'l pitu'gwitl. Se'sus tuaqtesguatl mn'tu'l ta'n mo gis glusiligul aq na ji'nm poqtewo'gwet. Mimajuinu'g ta'n eimu'tijig paqalaiultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Gatu ta'sijig teluejig, “Na Gjimn'tu ignmuaj Se'susal ml'gigno'ti ugjit tuaqtesguanew igtigig mn'tu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Igtigig wejo'tmi'tij gistesguanew, na glaman pipanima'titl tla'tegelin igtig paqalaiwaqan ta'n musga'tutew Gjinisgam no'q wel'te'lmatl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Se'sus geituaji ugtangita'suaqanmual aq telimaji, “Ta'n tegen mimajuinu'g getu' nasgwita'jig aq matntultijig ma gisi pgitawsulti'gw. Nantawa's'g wi'gmaq nasgwa'tijig aq matntultijig na tel'gne'g ms't goqwe'l ta'n negmewe'l siaw seioqwietaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na glaman mn'tu'g nasgwiejig tali pgijietaq Gjimn'tu ugtelege'wa'gim? Gilew telueioq ni'n gis ignmuij Gjimn'tu ugml'gigno'tim. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Telueioq ejigltesuaqig mn'tu'g muta Gjimn'tu gisi ignmuij ml'gigno'ti ugjit jigltesguan. Tami weja'toq na ml'gigno'ti gnaqapemuaq e'wmi'tij ugjit jigltesguanew mn'tu'g?. Ta'n goqwei gnaqapemuaq gis tla'taqatipnig musga'tas'g oplite'lmioq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Awna e'wm ml'gigno'ti ta'n wejiaq Nisgamewigtug ugjit tuaqtesguan mn'tu'g. Na ula musga'tas'g Gjinisgam ilgwenugsioq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ta'n tujiw melgignat ji'nm geggungl tepiaqal ugpugumaqanml ugjit geligetoq wiguaq na ms't goqwei welmasgutegl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Gatu ta'n tujiw igtig ta'n me' ml'gignaj matnaj na tujiw wissuignematal. Ugsua'tuatal ms't ugpugumaqanml ala ji'nmul elita'suatgl. Na me' melgignat ji'nm jigla'tutal ms't goqwei aq nasgwa'tatultitaq maw witapaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ta'n getu wen mo gesatmug ta'n tela'tegei, na matnit. Ta'n getu wen mo apoqonmuigw mawa'lanew mimajuinu'g lpa se'so'laji mimajuinu'.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Na mn'tu winsmuit aq ta'n tujiw tewatqa'sij mimajuinu'l ugtinneg, na saputa'sit glapis pegising ta'n mo goqwei nigwenug. Na gwilg ta'n ap usgowa'sitew, gatu mu we'jitug. Na telimsit, ‘Etug apaja'sia's ta'n wejieiap.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Glaman na apsgwa'sit aq nemitoq ta'n gis eig'p na waqame'g aq welo'tas'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Na tujiw maja'sit aq nemisguaji lluigneg te'siliji mn'tu'g me' winjultiliji aq negm. Ms't pisgwita'jig aq wigultijig na'te'l. Nige' na mimajuinu ta'n pitu'gwiji wegla mn'tu'g me' gitnme'wit aq amgweseweieg ta'n tujiw pas'g newte'jilitl mn'tu'l pitu'gwiteg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ge's Se'sus etlewistoq na e'pit ta'n eig na'te'l aq nutg ta'n goqwei Se'susal gi's teluelipnn, telimatl, “Ggij amujpa welgwijing muta negm na ggij aq gisi neps'tgwa'l'sg'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Gatu Se'sus telimatl, “Teliaq na. Gatu wel'ta'sultijig na mimajuinu'g ta'n nutmi'tij Gjinisgam ugtwi'gatign aq tela'taqatijig ta'n goqwei ewi'gas'g na'te'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ge's pugwelgig mimajuinu'g mawita'jig Se'suseg na telimaji, “Na mimajuinu'g ta'n mimajultijig nige' na no'q pata'taqatijig. Pewalijig tla'tegen paqalaiwaqan ugjit gisi gji'tunew Gjinisgam na petgimip. Telimuloq ma newte' tla'tega's, pas'g tliatew na wijei aq ta'n tela'lut'p Jonao'q. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gjinisgam e'w'g'p ta'n goqwei tela'lut'p Jonao'q ugjit musga'tuanew na mimajuinugi' tleiawultilipni Ninapa na pewalapni pun pata'taqatinew. Ni'n na mimajuinualsiap aq Gjinisgam e'wtew ta'n goqwei tla'liten ugjit musga'tuanew mimajuinu'g ta'n mimajultijig nige' pewalaji pun pata'taqatinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na na'gweg ta'n tujiw Nisgam ilsumata ms't mimajuinu'g, na elege'wi'sgwaq tleiawit Tp'te'snug qama'sitew aq ilsutmuata na mimajuinu'g ta'n wigultiliji gisgug. Wejiepnaq me' gnegg ugjit jigs'tuan Salamano'q. Telimuloq, Salamano'q ne'tata'sipnaq gatu na mimajuinu'g ta'n mimajultijig gisgug gis nutmi'tip ns'tuo'qon ta'n je me' espe'g aq Salamanewei ns'tuo'qon. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na na'gweg ta'n tujiw Nisgam ilsumata ms't mimajuinu', na mimajuinugi' tleiawultilipni Ninapa qamultitaq aq ilsutmua'tita na mimajuinu' ta'n mimajultiliji gisgug. Ninapaewa'jg gawasgita'sultipnig aq pun pata'taqatipnig ta'n tujiw nutua'titeg Jonaal pestunmliteg. Telimuloq na mimajuinu'g ta'n mimajultijig gisgug gis nutmi'tipnn agnutmaqann ta'n me' espe'gl aq ta'n goqwei Jonao'q pestung'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Mo wen wasoqwa'tug wasoqonmaqan toqo tujiw mimugwa'tuoq gisna ango'tmn lataqsunigtug. Awna patawutigtug tepa'toq glaman ms't wen ulate'lmatew ta'n tujiw pisgwa'j. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gis nmitaqatioqs'p muta ugpugugultioq aq gpuguguinal pa na wijei aq wasoqwegl. Ta'n gpugugual tajigo'ltigl na wel nmitaqatioq aq weli ns'tasultioq. Gatu pa na gpugugual mo tajigo'ltinugl na mo welapultiwoq tla'taqatinew ta'n pas'g goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pa na npapigwo'ltioq na mo goqwei nmitutoqs'p. Pa na elt mo ns'tasultiwoq na mawi mtue'g ugjit gilew. Ango'tmug tetapu ns'tmnew glaman ma tla'taqatiwoq ta'n goqwei mo gelu'lgtnug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pa na gis geggunmoq ns'tuo'qon na tujiw natawo'ltioq aq ilajo'ltioq ugjit mimajuaqan ugs'tqamug aq wa'so'q st'ge' wel nmituoq ms't ta'n eteg gigjiw waseteg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ta'n tujiw Se'sus gaqewo'gwet, na Palasi pipanimatl mawatalutinew. Se'sus eliet aq mawatalultijig Palasi wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na Palasi paqalaig ta'n tujiw nemiaj Se'susal mu gesispa'tuligul ugpitnn ge's mu mijjiligw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Na tujiw Gjisaqamaw telimatl, “Gilew ta'n teluisultioq Palasiaq gesispa'loqig gapji'jg aq eptaqann gatu ggamlamunuaq me' angite'tmoq nat goqwe'l winjigl aq me' pisoqqowiegsultioq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ewnasita'ioq. Gisiteget gisitoqop ula ms't ta'n nemituoq aq elt gisitoqop ggamlamunuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ignmug ewle'juinu'g nat goqwei, amuj ewlite'lmoq aq esmoq ta'n iga'tuoqop eptaqanigtug, aq na tujiw gji'tutoqs'p Gjinisgam waqama'tutew ms't goqwe'l gilewewe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Tetuji mtue'tew ugjit gilew ta'n Palasiaq. Na mawo'loq weljema'gewe'g nipi'g ta'n teluisultijig mint, lu aq igtigig pa na wijei aq nepitegemgwe'g. Te's newtisgegsijig nipi'g ganie'ultioq na newte'jit ignmuoq Gjinisgam, gatu mo tetapua'lawoq mimajuinu'g aq mo gesalawoq Gjinisgam. Amuj wegla tla'taqatigw aq siaw ignmuoq Gjinisgam goqwe'l st'ge' gis ignmuoqopnn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tetuji mtue'tew ugjit gilew ta'n Palasiaq. Gesatmoq pmgopultinew mujgajewe'l mutputi'l a'sutuo'guomg aq pewaloq mimajuinu'g gepmite'lmugsinew magasang. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tetuji mtue'tew muta gilew pa wijei aq npuinue'gati ta'n mo gaqaminugul npuinue'l gun'tal. Mimajuinu'g pemita'jig npuinue'gatig gatu mo geitu'ti'gw gegupuguinew ta'n npuinu elising.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na nutagnutmewinu telimatl, “Nujigina'muet, ta'n tujiw ula teluen elg emegwei'wieg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Se'sus telimatl, “Tetuji mtue'tew ugjit gilew na nutagnutmewinu'g. Gisa'loq mimajuinu'g lugwatmnew metue'gl gatu gilew mo eigtnug wen apoqonmuanew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tetuji mtue'tew ugjit gilew. El'tuoqol gelu'lgl npuinue'l gun'tal aq gaqama'toqol ta'n elisultijig niganigjitegewinugi'g ta'n gujjuaqi'g ne'pa'tipni. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Na ula ta'n tela'taqatioq musga'tas'g wel'te'tmoq ta'n gujjuaqi'g gis tla'taqatipnig, muta nige' gaqama'toqol npuinue'l gun'tal ta'n niganigjitegewinugi'g elisultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Etna Nisgamewei ns'tuo'qon teluet, ‘Lgima's niganigjitegewinu'g aq ntapostale'witemg ugjit agnutmuanew ntmimajuinumg. Alt ne'pa'ten aq alt emegwei'waten.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Na mimajuinu'g ta'n mimajultijig nige' ulmaji ilsumuten ugjit ta'n tel ne'pa'tisni negla niganigjitegewinugi'g te'sitgi'g weja'tegemg ugs'tqamu gisita's'geg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Wesgumgig ms't niganigjitegewinugi'g ta'n ne'pa'tisni weja'tegemg E'pelo'q glapis Saglaiao'q ta'n etl ne'po'qs'pnaq miawe'g na gjia'sutuo'guomg aq ta'n eteg patgulmesigaqan. Teliaq ta'n telimuloq. Na mimajuinu'g ta'n mimajultijig nige' gisa'laten ulmajo'ltinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Tetuji mtue'tew ugjit gilew na nutagnutmewinu'g. Geggunmoq na apt'sqi'gn ta'n pana'toq na ga'qan ta'n ns'tuo'qon eteg. Gatu mo pisgwita'woq aq mo ignmuawoq wen piluei pisgwa'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ta'n tujiw Se'sus naqa'sij na'te'l, wegla Palasiaq aq nujigina'mua'tijig tplutaqan wije'wa'titl aq pipanima'titl pugwelgl goqwe'l aq pisuima'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Wejo'tmi'tij gisapsgnanew aq gisa'lan oplewistulitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ge's ta'sijig pituiptnnaqanijig mimajuinu'g mawita'tijig ugjit jigs'tuanew Se'susal, lpa tetuji mawpugua'tijig na we'gaw pas'g matntulti'titl uggwatual. Na tujiw Se'sus telimaji unaqapemg, “Ango'tmug aq mut e'wmu'tinew na Palasiewei apita'taqan. Lpa mut jigs'tuanew ta'n Palasiaq tel gina'matmi'tij muta wesgijiangamgusultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta'n te's'g goqwei mimugwa'tas'g neia's'gt'tew aq ta'n te's'g gim agnutas'g na gji'tas'gt'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Na glaman, ta'n goqwei telueioqop oqonitpa'qigtug gji'tas'gt'tew miaw na'gweg. Ta'n goqwei gim tlueioqop apt'sqa's'gl wen'ji'guoml na paqtaqawa'tew g'p'taq wen'ji'guomg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nitaptut, telimuloq, mut jipalanew ta'n wen gis ne'po'ltew gatu na tujiw mo goqwei ma gis piama'lugsiwoq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Telimuloq na ta'n wen jipalaqoq. Na jipalug Gjinisgam, muta gi's ne'po'ltew jel gi's lgimultew Mn'tua'gig. Telimuloq, no'q jipalug negm. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Geituoq na'nijig sisipji'jg netuisgelmujig ugjit pas'g tapu'gl maqtawe'gl suliewe'l, gatu Gjinisgam ma awan'ta'sualagul je newte'jilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Gjinisgam geitoq ta'n te's'gl gusapunual gun'jiwaq, na glaman mut jipasultinew ta'n goqwei tliatew. Me' me'gite'lmugsioq je mu pugwelgig sisipji'j.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Telimuloq, ni'n na mimajuinualsiap aq tlima's Gjinisgam ugtansale'witemg negm na nnaqapem ta'n mu jipasigw tliman igtigi na getlams'tuit aq majulgwalit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Gatu ta'n wen alua'lit aq telimaji igtigi ta'n mu na nnaqapem, na tlima's Gjinisgam ugtansale'witemg na negm mu na nnaqapem. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ta'n wen pisui agnimit ni'n ta'n mimajuinualsiap na gisi apigsigtuaten, gatu ta'n wen penoqite'lmatl Wejuli Nisgaml ma apigsigtuam'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ta'n tujiw la'lugusioq a'sutuo'guomg ugjit ilsumugsinew, gisna nigantug g'pnno'lewaq gisna ta'nig niganpugultijig, mut sespete'tmnew ta'n tluetoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Na Wejuli Nisgam gnu'tmugsitoqs'p ta'n tluetoqs'p na tujiw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na ji'nm ta'n gaqamit maw igtigi telimatl Se'susal, “Nujigina'muet, ge' tlim nsis ugjit nasgwa'tatinen na ta'n goqwei nujjinenaq naqtmugsieg'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Se'sus telimatl, “Ji'nm, mo wen ignmuigup na nuji ilsutegemg gisna assutegemg ugjit gis nasgwa'tun ta'n goqwei gujjuowaq naqtmugsioqop.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na tujiw Se'sus telimaji ms't wen, “Angweiasultigw aq mut puatmnew ta'n goqwei igtig mimajuinu assutg, muta ta'n goqwe'l assutmultioq ma gisa'lugsiwoq siaw mimajultinew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Se'sus telimaji ula a'tugwaqan, “Jijuaqa to'q, eig'p na milesit ji'nm ta'n assutgl iga'taqann. Na'te'l weligwegl glumgl aq wel minijgl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Na tujiw etli angita'sit, ‘Mo tepianugul ntlaqalansml ugjit ta'n te's'gt'tal glumgl. Tala'tega's nige' ugjit ula?’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na telimsit, ‘Amuj seioqte'tes ntlaqalansml aq me' mesgi'gl ltutes. Na me' mesgi'gl laqlansl gis lo'tutes ms't glumgl aq elg ta'n te's'gl goqwe'l assutman.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ta'n tujiw gis tela'teget na telimsit, ‘Me' gatu ni'n natawe'i. Gaq tepesi ta'n te's'g goqwei ugjit pugwelipunqeg. Nige' ule'tes, ulataltes aq no'q ulawsites gise'tes.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Gatu Gjinisgam telimatl, ‘Mo natawe'wn. Ulo'nug np'tes, aq wen ulapettew wegla ta'n goqwe'l gis masgo'tu't'pnn?’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Ula na tliatew ugjit ta'n pas'g wen masgo'taj milesuaqan ugs'tqamug gatu Gjinisgam geitoq ula mimajuinu'l mo milesiligul wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na tujiw Se'sus telimaji unaqapemg, “Na ula telimuloq, mut sespete'tmnew ugjit mijipjewei gisna aligal ta'n wetmite'tmoq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gjinisgam me' piamite'tgl gtmimajuaqanmual je mu mijipjewei gisna aligal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ge' angamug ga'qaqujg muta mo iga'taqu'ti'gw gisna mo mena'taqu'ti'gw. Mo menuegetu'tigul laqlansl muta Gjinisgam esmaji. Gjinisgam me' piamite'lmugsioq je mu sisipg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ma aji piami pgitawsultiwoq, je tlia tel sespeta'sultioq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mu gis tla'taqatiwoq ula ta'n goqwei teli apje'jg, na mo tepawtinug ugjit sespete'tmnew igtigl goqwe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Angite'tmug ta'n teligwegl wasuegl nipugtug. Mo elugutinugul aq mo elita'sultinugul aligal. Telimuloq, na milesitaq elege'witaq ta'n teluisitaq Salaman mo geggungupnn tetuji glu'lgl aligal ta'n weli angamgug'pnn st'ge' wegla wasuegl ta'n nigwegl nipugtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gjinisgam na gisa'toqopnn msigu'l uligwenew, gatu sapo'nug etugjel nu'gwa'tuten ugjit epsmn nat goqwei. Pa na sespeta'sultioq na mo piami gtlams'tmu'tioq Gjinisgam ignmugsitoqs'p aligal ta'n menuegetuoqol. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Mut sespete'tmnew ta'n goqwei malqottoqs'p gisna ta'n goqwei samqwoltitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Gaqaisg mimajuinu'g tleiawultijig pilue'l umutgiwal ugs'tqamu pas'g iapji gwilmi'tij ula ta'n goqwe'l. Gujjinu ta'n wa'so'q eig, gejugsioq ta'n goqwei menuegetuoq.) ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tmg ignmug Gjinisgam ilgwenugsinew glapis gisa'lugsioq tetapua'taqatinew st'ge' negm. Na tujiw ignmugsitoqs'p ms't ta'n goqwe'l menuegetuoqol.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nn'jantut, mut jipasultinew, muta gujjuow ta'n wa'so'q eig uli ignmugsitoqs'p e'wmnew ms't goqwei assutg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ntuisgetug ta'n goqwe'l geggunmoqol aq ignmug suliewei ewle'juinu'g. Na tujiw guguntoqs'p milesuaqan ta'n wa'so'q ulo'tas'gt'tew. Ta'n tujiw ula tla'taqatitoqs'p ignmugsitoqs'p milesuaqan tleiawig wa'so'q ta'n ma gaqapegsinug. Ma gmutnesg gisapsgnmi'tigul aq milesuaqane'l aligal gaplanji'jg ma gis suistmi'ti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tli angita'sultitoqs'p ta'n etegl gtmilesuaqanmual.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Gisgajo'ltigw ugjit ta'n pas'g goqwei. Gnesultigw aq maw wasoqonmaqan wasoqwej. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gisgajo'ltigw st'ge' na lugowinu'g ta'n esgmala'titl assusilitl ta'n wejielitl malie'uti. Ta'n tujiw pegisinnij aq metete'gelitl smtug pana'tua'titl ga'qan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Lugowinu'g ta'n gisgajo'ltijig na no'q ul'ta'sultitaq ta'n tujiw assusilitl pegisinnij. Telimuloq, na laqpisutia'sitew aq tlimata pmgopita'new. Na tujiw smata. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","No'q ul'ta'sultitaq muta tel gisgajo'lti'tij ta'n tujiw assusilitl pegisinnij, je tlia aqtatpa'q gisna me' gisgattpa'q. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Geituoq na assusit gejiasnn ta'n tujiw gmutnesl wejgu'elitl, ma ignmuagul pisgwa'lin wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na iapji gisgajo'ltigw, muta ni'n ta'n mimajuinualsiap aq etugjel pgisintes ta'n tujiw mo etlite'lmiwoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pie'l pipanimatl, “Gjisaqamaw, agnutmaqan weji agnutmuieg ugjit pas'g ninen gisna ugjit ms't wen?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Gjisaqamaw telimatl, “Telimul ta'n tegen lugowinu na natawe'g aq gi'l gis lita'sualates. Negm na iga'laten assusitew na wen'ji'guom aq ignmuata igtigi lugowinu wiluow ta'n tujiw telteg mijjultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ula lugowinu no'q ul'ta'sitew ta'n tujiw assusilitl pgisinnij muta geitoq ugtlugowaqan tetapua'toqop. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na miamuj telimuloq, na assusit ignmuatal ugtlugowinuml niganpugutmlin ta'n telgi'g assutg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Gatu pa na awna na lugowinu tlimsij, ‘Na assusit ma pe'l apaja'sigw,’ na poqji matnaj igtigi lugowinu' aq lugowinu'sgwa. Toqo etlatalg aq gt'giej. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na assusit apaja'sitew ta'n tujiw ula lugowinu'l mu etlite'lmagugul aq mu esgmalagugul. Na ulmaji ilsumatal aq tla'latal ta'n tela'luj ta'nig mo getlams'tmu'ti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Na lugowinu ta'n geitoq goqwei ugtassusiteml pewaltl tla'tegen gatu mo ilajugtmug gisna mo tela'tegegw, na ulmaji ilsumaten aq wisqapaqtaten. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gatu na lugowinu ta'n mo geitug goqwei ugtassusiteml pewalatl toqo emegwo'tegej, na ulmaji ilsumaten gatu ma tl ma'muni gsapaqta'm't. Ta'n wen pugwelg ignmuj na telteg negm pugwela'tegen, aq ta'n wen me' aji pugwelg ignmuj na telteg negm me' aji pugwela'tegen.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Pegisinap ugs'tqamug ugjit musga'tuan mimajuinu'g ta'n Gjinisgam tli ilsumata. Na tujiw tetuji ulmajo'ltitaq st'ge' ta'n tujiw nu'gwo'ltitaq. Na gsattes ta'n tujiw ula gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Amujpajiji ugji ugje'win aq ulmajita'sites glapis gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tel'ta'sioq weji pgisinap ugjit neia'tun wantaqo'ti ugs'tqamug? Moqwa', mimajuinu'g ma wijei tl'te'lmi'gw. Mo wel'te'ltulti'gw ta'n weni ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nige' weja'tegemg, alt wi'gmaq nigtuo'laten. Na na'nijig wijig'tultijig nasgwita'taq, nesisijig ma wel'te'lma'tigwi tapusiliji aq na tapusiliji mo wel'te'lmigwi'tigwi nesisijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Na ji'nm etoqwalata uggwisg aq negla ji'nmji'jg etoqwala'tital ujjual. Na e'pit piltui angita'sitew aq ugtusg aq negla e'pite'sg piltuita'sultitaq aq mo wel'te'lmagwi uggwijual aq ugtlu'suesgmual.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Se'sus siaw glulaji mimajuinu'. Telimaji, “Ta'n tujiw nemioq alug weita'jig tg'snug, smtug telueioq gigpesatew aq na tliatew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ta'n tujiw tp'te'snug wett'g tluetoqs'p p'tetew. Giwnaqa tliatew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wesgijiangamgusultioq. Niganigji'tuoq ta'n tli gisg'gt'tew muta angaptmoq maqamigew aq musigisg gatu tal gis mo geituoq ta'n Gjinisgam tel puatg gisgug gisna goqwei ugjit mo nemituoq ta'n gis tliaqap ginueg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Tal gi's mo nenmuoq ta'n goqwei tetaputeg tla'taqatigoq? ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nantawa's'g ji'nm getu' elsutmasg's nat goqwei aq getu' la'l'sg's tplutaqanigtug. Ugjo'te'n gi's tetapua'lan aq gigwaja'tu na ta'n goqwei ge's mu ela'lulug ilsumugsin, muta na ilsuteget tlimata nujiugsua'taqatiliji jigla'lul. Na tujiw pija'lultaq laplusang. ");
INSERT INTO micMIQNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Telimuloq, amujpa siawqattes laplusang glapis gaqi apangitmn ms't gtettuaqanml.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na tujiw ta'sijig mimajuinu'g eimu'tijig Se'suseg aq agnutmua'titl ta'n Pilot gi's ne'pa'pni Galaliewa'gi ge's etli a'sutma'ti'titeg aq etli ignmua'ti'titeg ignmatimgewe'l Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Se'sus telimaji, “Ta'n wegla Galaliewa'gig tel ne'po't'pnig na mo musga'tuagwi negmow me' pata'tegewinu'g je mu igtigig Galaliewaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A' na moqwa' mo telianug, Telimuloq, pa na mu gawasgita'sutiwoq aq mu ejiglita'woq lue'utigtug na elt tli npu'titoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Newtisgegsipnig je ugumuljin etl sigto'qutipnig Sailoamg ta'n tujiw nisiaqeg espiganig. Tel'ta'sultioq wegla mimajuinugi'g me' pata'tegewinu'g jel mu esgwia'tijig mimajuinu'g ta'n eimu'tijig Selusalemg? ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","A' na moqwa' mo telianug. Telimuloq, pa na mu gawasgita'sultiwoq aq mu ejigilita'woq lue'utigtug na elt npu'titoqs'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na tujiw Se'sus telimaji ula a'tugwaqan, “Jijuaqa to'q, ji'nm geggunatl minijgei miti'sl etligwelitl iga'taqanigtug. Eliet ula miti'sl ugjit mgnmn minijgl gatu mo we'jitugl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Glaman telimatl uglugowinuml, ‘Gis nige' nesipunqeg ta'n eliei aq gwilmann minijgl gatu mo we'jituann. Tmta na miti's muta mu wel awtigw iga'taqanigtug.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Na iga'taqanej telimatl, ‘Saqamaw, siawigwej glapis ap igtig newtipunqeg. Gigto'qwi mulqala's aq iga'tua's epgenign. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nantawa's'g minij wejgwipunqeg na glu'lgt'tew, gatu pa na mu minigw, na tujiw ni'n tmta'tes.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Newtejgeg atlasmutigisg'g Se'sus etl gina'muet a'sutuo'guomg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Eig na'te'l na e'pit ta'n waqjuijing gis nige' metlasipunqeg je ugumuljin. Mo gisi pegoqopugua'sigw muta mn'tu'l gisa'ltl gsnugwan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ta'n tujiw Se'sus nemiaj, telimatl, “E'pit, 'gsnugowaqan puna'lulij.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ugpitnn ge'gwa'toqol e'pit ugtlmaqaneg aq smtug pegoqopugua'silitl. Na tujiw e'pit emtoqwalatl Gjinisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Na niganpuguit a'sutuo'guom no'q wegaig ta'n Se'sus teli npilalij e'pilitl atlasmutigisg'g. Telimaji mimajuinu' ta'n eimu'tiliji, “Te's aqan'tie'uti, asugom te's'gl na'gwegl ugjit elugwemg. Naji npisultigw na tujiw, gatu mu atlasmutigisg'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Gjisaqamaw teluet, “Na wesgijiangamgusultioq. Ms't ta'n te'sioq geggunatl wen'jitia'mul gisna te'sipowji'tl na apgwa'latal aq nat smqwo'tlatal te's atlasmutigisg'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na ula e'pit wetapegsit Aplameg aq na Gjimn'tu'l gis pitu'gwipnn metlasipunqeg je ugumuljin. No'q gelu'lg ugjit na gisi npisin ula atlasmutigisg'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ta'n goqwei Se'sus teluet, gisa'laji ta'ni getanji ntaqtelsultinew gatu igtigig wel'ta'sultijig Se'sus gis tla'tegej gelu'lgl ta'n goqwe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Se'sus teluet, “Getu telimuloq goqwei teliaq ta'n Gjinisgam ilgwenaji mimajuinu'. Ugs'tqamug eteg goqwei wijei aq ta'n teliaq Gjinisgam ugtelege'wa'gimg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Na wijei aq mawi apje'jg mustate' sginmin ta'n ji'nm iga'taqug. Ula apje'jg sginmin nigweg glapis miti'suig. Na tujiw sisipg el'tu'titl ugtwisse'ml na miti'sigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Se'sus telimaji, “Ugs'tqamug eteg alt goqwei wijei aq ta'n Gjinisgam ilgwenaji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Na pa na wijei aq apita'taqan ta'n e'pit wiaqa'toqol pugwelgl wapejgl ta'n etegl mun'tigtug. Toqo tujiw ms't gaqi apitaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ge's Se'sus pem liet Selusalemg, el saputa'sit utann aq utanji'jl aq egina'muaji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nat wen pipanimatl, “Gjisaqamaw, pas'g tegle'ji'jg mimajuinu'g ugs'tawiaten?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Se'sus telimaji ms't mimajuinu', “Tla'taqatigw ugjit pisgwita'new na jijigwej ga'qan. Telimuloq, pugwelgig mimajuinu'g wejo'tmi'tij gisi pisgwita'new gatu ma gisi pisgwita'gwig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Na assusit lietew aq g'p'soqwa'tutew ga'qan wiguaq gatu gilew qamultitoqs'p gujmug aq mtete'gatitoqs'p. Na tujiw tluetoqs'p, ‘Saqamaw pana'tuinen na ga'qan.’ Na tlimugsitoqs'p, ‘Mo geju'luoq ta'n weita'ioq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tlimatoqs'p, ‘Toqwatalulti'gup aq tel gina'mue't'p na ntgutanminaq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Na tluetew, ‘Mo geju'luoq ta'n weita'ioq. Gilew na nujipata'taqatioq. Jiglita'gw ni'neg!’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Gaqiemtmutitoqs'p aq gipitual seggapitasultitoqs'p ta'n tujiw nmitoqs'p Aplam, Isaq, Je'gop aq ms't niganigjitegewinu'g wije'wa'titl Gjinisgaml ta'n ilgwenji mimajuinu'g. gatu gilew ma ignmugsiwoq pisgwita'new wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mimajuinu'g ugjita'taq ugjipenug aq tg'snug, aq elg ugjita'taq oqwatnug aq tp'te'snug. Na nat pisgwita'taq Gjinisgaml wiguaq aq pmgopita'taq ulatalultinew ta'n Gjinisgam ilgwenaji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Telimuloq, ta'nig mu gepmo'lti'gw ugs'tqamug na me' gepma'laten na'te'l aq ta'nig espite'lsultijig nige' ma tl gepmo'lti'gw na'te'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na tujiw ta'sijig Palasiaq peita'jig Se'suseg aq telima'titl, “Amujpa ejigla'sin tet aq liates na'tami se'g muta Elot getu' ne'pe'sg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Se'sus telimaji, “A' na negm elue'wa'teget pa na wijei aq paqtesm. Pewaluloq lta'new aq tliman na ejigltesgaqig mn'tu'g aq elg nepilgig mimajuinu'g gisgug aq sapo'nug. Na igtig sapo'nug gaqa'tutes ntlugowaqanm. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Amujpa siaw lugwei gisgug, sapo'nug aq igtigi sapo'nug. Mo gelu'lgtnug tl ne'po'qsin niganigjitegewinu na'tami se'g, pas'g Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Gilew ta'n tleiawultioq Selusalemg ne'po'qopnig niganigjitegewinugi'g aq gun'tewtoqig nujignua'taqatipnig ta'n Gjinisgam petgitmugsioqopnig. Sipeliw getu' ge'gulusgwa'luloqop aq telimuloq ta'n Gjinisgam mawi gsalugsioq aq getu' ugs'tawugsitoqs'p. Getu' mawa'luloq st'ge' goqoli'gwej tel mawa'laj un'janua gatu mo pewaliwoqop tla'tegen. ");
INSERT INTO micMIQNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Telimuloq, Gjinisgam jigla'sitew gjia'sutuo'guomg. Ma ap nmiwoq glapis tluetoqs'p, ‘Megite'lmut ta'n pegising muta elgimut tlimugsinenu ta'n Gisiteget tel puatg.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Newtejgeg atlasmutigisg'g Se'sus natatalg ta'n wigilitl niganpuguilitl na Palasi'l. Ta'sijig mimajuinu'g etli angama'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jiniw na ji'nm ta'n uggwatl aq ugpitnn moqpegl pegising Se'suseg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na tujiw Se'sus pipanimaji na nutagnutmewinu' aq Palasiaq, “Tal'te'tmoq tplutaqanminu telueg nat wen gisi npitegen atlasmutigisg'g gisna moqwa' mu tela'tegewn.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Gatu mo goqwei telue'gw, glaman Se'sus nepilatl na ji'nmul aq ignmuatl 'nmien. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na tujiw Se'sus telimaji, “Nantawa's'g atlasmutigisg'g aq ggwis gisna gtue'm egwijiess nqano'patigtug, smtug tualqa'loq je tlia atlasmutigisg'g?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ap mo goqwei telue'gw muta geitoq ta'n goqwei ewi'gas'g tplutaqanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Se'sus nemiaj alt mimajuinu'g megnmi'titl ta'n maw mujgajewei pmgopita'tita, na tujiw telimaji a'tugwaqan, ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ta'n tujiw nat wen pipanimasg wijitgweiwin na malie'waqan pestie'umg, mut pa'siw ta'n mujgajewei mutputi eteg. Etugjel nat wen me' espe'g je mu gi'l pgisintew aq gtu' pa'siss na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na mimajuinu ta'n pipanimasg'p wijitgweiwin na malie'waqan, jugu'etew gi'leg aq tlimultew, ‘Ula mimajuinu ignmu pa'sin ta'n gi'l pemgopin.’ Na ntaqa'sites aq amujpa pa'sites mutputi ta'n me' gmetug eteg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Awna ta'n tujiw wigumulg ugjit wijitgweiwin na malie'waqan pestie'umg, pisgwa' aq pa'si mutputi'gtug ta'n me' gnegg wetteg weja'tegemg wegla ta'nig gis malie'wijig wet pi'tij. Na tujiw assusit tlimultew, ‘Jugu'a, nitap, aq gigjepa'si.’ Na gepmite'lmultew aq igtigig mimajuinu'g ta'n eimu'tijig na'te'l gji'jitaq tla'tegen. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Na mimajuinu espite'lsij na gisa'laten mo tetuji espeiug aq na mimajuinu mo espite'lsigw na gisa'laten me' me'gite'tasitew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Na tujiw Se'sus telimatl niganpuguilitl, “Ta'n tujiw iga'tun mijjuaqan mut wigumaw gitapaq, wijig'tioq, go'gumaq gisna milesuinu'g, muta wigumultaq natatalultinew wiguaq aq na tli asita'lultaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ta'n tujiw iga'tun mijjuaqan, pipanim ewle'juinu'g, sawiptna'tijig, asgajo'ltijig, aq nepapigwo'ltijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pa na tla'tegen, na negmow ma gisi wigumulug natatalultinew wiguaq st'ge' gi'l ta'n gis tla'l'j gatu me' me'gite'tasites aq Gjinisgam gepmite'lmultew ta'n tujiw gelu'sultijig mimajuinu'g minua'laj.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na ji'nm ta'n pemgopij na patawutigtug aq etli jigs'tg ta'n goqwei Se'susal teluelitl, telimatl Se'susal, “Ulgwijultitaq na mimajuinu'g ta'n pmgopultitaq patawutigtug Gjinisgam wiguaq ta'n ilgwenaji mimajuinu' wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Se'sus telimatl, “Newtejgeg na'gweg ji'nm getu' iga'toq mesgi'g mijjuaqan aq pugwenniji mimajuinu' wigumaji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ta'n tujiw ms't goqwei gisgatteg, elgimatl lugowinu'l gnua'tuan ta'n wigumapni ugjit jugwita'new. Nat tlimaji, ‘Ms't goqwei gisgatteg. Jugwita'gw.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ms't teluejig, ‘Ma gis liew.’ Newte'jit teluet, ‘Iga'taqan gisi pgwatelm aq amujpa naji angaptm nige'. Mesge'i, ma gis liew gi'leg.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Igtig teluet, ‘Gisi pgwatelaqapnig na'nunemigsijig wen'jitia'mug aq pem liei ugje'wan ta'n tel glu'sulti'tij lgowaqanigtug. Mesge'i, ma gis liew gi'leg.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ap igtig teluet, ‘Na tel gis malie'wi na ugjit ma gis liew gi'leg. Mesge'i.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Lugowinu apajinmiet aq agnutmuatl assusilitl. Na assusit no'q wegaig aq telimatl lugowinu'l, ‘Tetaqa'si aq wigum mimajuinu'g ms't gjigan aq jugwo'l ewle'juinu'g, nepapigwo'ltijig, sawiptna'tijig aq asgajo'ltijig.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Na tujiw lugowinu ula tela'teget aq telimatl assusilitl, ‘Gi's tla'tegei ta'n telimi't'p saqamaw, gatu me' gisi pugweli'tisoq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Na assusit telimatl, ‘Tu'etes na gjigan aq jugwo'l negla mimajuinu'g ultesguates awtigtug gisna awtijigtug glaman nat wen pmgopitew te's'g mutputi'gtug nignen. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Telimuloq, ms't wegla mimajuinu'g ta'n amgwesewei wigumut'pnig ma msnmi'ti'gw goqwei.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pugwelgig mimajuinu'g pem wije'wa'titl Se'susal, na tujiw naqa'sit aq telimaji, ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ta'n wen wejgu'et ni'neg, ma gisi nnaqapemuigw glapis me' gesalij ni'n je mu ujjl gisna uggwitl, ugte'piteml gisna un'jang, gisna wijig'tijig, aq je we'gaw negm. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ta'n wen mo getu' majulgwaligw je tlia ulmaje'tew st'ge' ta'n tli ulmaje'tes na negm ma gis nnaqapemuigw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ge' newte'jioq getu' iga'ioq wen'ji'guom, tmg ugjo'ttew gis mawgitmn ta'n tl tepawtitew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nantawa's'g poqji'gass ge's mu geitug ta'n tlawtitew, ma gis gaqianug pas'g gisitutew epganaqataqan. Ta'n wen nemitoq goqwei ula ji'nmul gis tla'tegelitl na maligimatal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Tluetaq, ‘Ula ji'nm poqji'gap gatu mo gis gaqa'tugup ugtlugowaqanm.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nantawa's'g elege'wit matntimg eliet, aq ggeggunaji newtisga'q pituiptnnaqan te'sisgegsiliji sma'gnisg gatu ultesguata, igtigl elege'wilitl maw tapuisga'q pituiptnnaqan te'sisgegsiliji sma'gnisg. Tmg angite'tg me' tepignan ugjit wissuignemanew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pa na mo tepignaguss amujpa lgimatal nuttugwi'mlitl ugjit nmian igtigl elege'wilitl ge's gnegg amaseg eimlitl. Na nuttugwi'g pipanimatew igtigl elege'wilitl ta'n goqwei puatmlitew ugjit mu nugu matnugun.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Na tujiw Se'sus tel gaqewo'gwet, “Ma wen gilew gisi nnaqapemuigw glapis gisita'sij puna'tun ms't goqwei ta'n assutg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Wigapu'g ta'n goqwei wel salawa'tas'g. Na salaweiei gun'tew gelu'lg, gatu ta'n tujiw mo salawei wetaputenug, na tujiw gun'tew ma nugu gelu'lgtnug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mo gelu'lgtnug ugjit iga'tun maqamigeg gisna mo gelu'lgtnug eimun ugjit epgenign. Amujpa ejigla'tas'g. Jigs'tmug ta'n goqwei telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Newtejgeg na'gweg, pugwelgig nujintutma'tijig suliewei aq pata'tegewinu'g mawita'jig ugjit jigs'tuanew Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na Palasiaq aq nujigina'mua'tijig Mowisewei tplutaqan mu weli usguma'tigul Se'susal. Telimtultijig, “Ula ji'nm nilaje'waji lue'winu' aq je we'gaw mawatalultijig.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Toqo Se'sus agnutmuaji na a'tugwaqan. Teluet, ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Na ji'nm geggunasni gasgiptnnaqaniliji jijgluewji. Newte'jit gesga't. Pa na gtue'm gesga'ss, tla'tegetes st'ge' ula ji'nm. Na naqalaji pesgunateg te'sisgegsiliji je pesgunateg m'gegtug aq naji gwiluatl glapis we'jiaj. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ta'n tujiw we'jiaj wel'ta'sit. Na ugtlmaqaneg tepa'latl, ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","aq apaja'latl. Na wigumaji wi'gma aq witapa aq telimaji, ‘We'ji'g na ntue'm ta'n gesga'p. Ul'ta'sultinej.’ Tel'te'tm gilew wijei tla'taqatioqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Telimuloq, ta'nig wa'so'q eimu'tijig me' aji ul'ta'sultitaq ta'n tujiw lue'winu'l gawasgita'silitl aq pun pata'tegelitl je mu pesgunateg te'sisgegsijig je pesgunateg mimajuinu'g ta'n mu tel'te'tmi'ti'gw ugjit amujpa gawasgita'sultinew aq jiglita'new lue'utigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Nantawa's'g na e'pit geggung'snn newtisga'qal suliewe'l toqosip newte' entoqos. Na wasoqonmaqan wasoqwa'toq aq pewa'q wiguow. Na melgi gwiluasit ms't tami glapis we'jitoq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ta'n tujiw we'jitoq, smtug wigumaji wi'gma aq witapesgwa aq telimaji, ‘Mawi ul'ta'sultinej muta we'jitu na suliewei ta'n gesga'q.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Telimuloq na mesgi'g ul'ta'suaqan eteg wa'so'q muta Gjinisgam ugtansale'witemg wel'ta'sultiliji ta'n tujiw lue'winu gawasgita'sit aq pun pata'teget.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Se'sus agnutmuaji, “Na ji'nm tapusiliji uggwisg geggunaji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na maw maljewe'j telimatl ujjl, ‘Tata't, pewalul ignmuin ta'n goqwei tel'ta'sin ignmuin ta'n tujiw gi'l npmn.’ Na ji'nm wel'te'tg'ss aq nasgwa'tuaji uggwisg ta'n telgi'g assutg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Na tel gne'ge'l maljewe'j ilpilg ta'n goqwei assutg aq maja'sit. Se'g eliet. Na'te'l etl gaqi ewnaso'tg ugsulieweim. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ta'n tujiw mo suliewei geggunmug na pestmo'qonig na'te'l. Na mu geggunmug ta'n goqwei malqottew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Amujpa elugowatl igtigl ji'nmul aq elgimtl angweiwan gulgwi'sg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tetuji guising je we'gaw malqotg'ss gulgwi'sg wiluow, muta mo wenn esmagul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Na glapis nestu'et aq telimsit, ‘Me' nujj uglugowinumg welatalultijig. Ula tet eim aq geget pestmai. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nige' maja'sia's aq nmia's. Nujj tlima's: Gisi pata'luloq gi'l aq Gjinisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Gisi ntaqo'qona'lul. Mu tepi glu'siw ugjit uggwisite'lmin aq weja'tegemg nige' tla'li st'ge' tela'l'jig gtlugowinum.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Na maja'sit aq poqjinmiet ujjeg. “Ge's wejgu'et awtigtug na me' eig weli amaseg ta'n tujiw ujjl nemitl. Na ji'nm me' ewlamatl aq el'tugwi'g uggwiseg. Naji a'suguatl aq wesgaqalmatl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na maljewe'j telimatl ujjl, ‘Tata't, gisi pata'luloq gi'l aq Gjinisgam. Mu tepi glu'siw ugjit uggwisite'lmin.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Gatu ji'nm wigumaji uglugowinumg aq telimaji, ‘Ge' nmisgmug gelu'lg aligew aq apoqonmug nasa'toq. Nasoqwa'taqan ignmug aq pile'g mg'sng. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nmisgug wen'jitia'm'ji'j aq wissugwalug. Pestie'ultinej nige'. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tel'ta'siap ngwis nepg gatu nige' geji'g me' mimajit. Tel'ta'siap gesga't gatu nige' ula eig.’ Na tujiw pestie'ultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Na igtigl uggwisl ta'n maw gisiguilitl etl lugwelitl iga'taqanigtug. Na peminmiej nutgl gtapegiaqann aq nemiaji mimajuinu' amalgaltiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Na lugowinu'l wigumatl aq pipanimatl, ‘Taliaq ta u't?’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Lugowinu telimatl, ‘Gjignam pegising aq gujj ela'lugsieg'p ne'pa'nen maw glu'sit wen'jitia'm'ji'j.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Na ula ji'nm wegaig aq mu pisgwa'gw ta'n wesgowita'lij. Na ujjl tewielitl. Na munsaiwatl uggwisl pisgwa'lin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Gatu asitematl ujjl, ‘Te'sipunqeg melgi lugowul st'ge' gtlugowinum aq ne'gaw menaq elistulu. Menaq ignmuiwn je te'pl'ji'j ugjit ta'n tel mawatalultiteg nitapaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Gatu ggwis gaqi ewnaso'tg'p ugsulieweim maw winsultiliji e'piliji. Tal gis ta'n tujiw apsgwa'sit pestie'wa'loq. Goqwei weji ne'po'q ta'n maw glu'sit wen'jitia'm'ji'j ugjit negm?’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Na ujjl telimtl, ‘Gwi's, geju'l iapjiw eimn ta'n eim aq ta'n te's'g goqwei geggunm na gi'lewei. ");
INSERT INTO micMIQNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Gatu amujpa wel'ta'sulti'gw aq pestie'ulti'gw, muta tel'ta'si'gup gjignam nepg gatu nige' me' mimajit. Tel'ta'si'gup gesga't gatu nige' eig ula tet.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Se'sus telimaji unaqapemg, “Na eig'p milesit ji'nm ta'n geggunapnn nigan lugwelitl. Na milesit ji'nm telimut na nigan lugwelitl ewnaso'tualij ugsulieweim. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Na wigumatl aq telimatl, ‘Taliaq ta u't ta'n goqwei nutmai ugjit gi'l? Pewalul wi'gmn ms't ta'n teli e'wmu't'p ntsulieweim muta ma gis siaw lugwewiwn nugu.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ula nigan lugowinu telimsit, ‘Na assusit getu' ilgitmuit. Tala'tega's nige'? Mo tepignaw ugjit mulqatmn elmalqe'l aq netaqei' ugjit altawen ta'n goqwei pewatm. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Geitu ta'n tla'tega's glaman ta'n tujiw ntlugowaqanm gaqiaq, nitapaq ignmuitaq i'mn wiguaq aq smitaq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Na tujiw wigumaji ms't mimajuinu'g ta'n tettua'titl assusilitl. Pipanimatl newte'jilitl, ‘Talgi'g tettaj gtassusiteminu?’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Telimtl, ‘Tettaq gasgiptnnaqaniji malige'wg ta'n wajuijig olipei mimei.’ Na nigan lugowinu telimatl, ‘Ula gtettuaqanm, nige' sa'se'wa'tu aq wi'ge'n pas'g tettuen na'nisgegsijig malige'wg.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Igtigl pipanimatl, ‘Talgi'g tettuen?’ Telimut, ‘Tettuei pituiptnnaqana'igl mun'ti'l glumgl.’ Na nigan lugowinu telimatl, ‘Ula gtettuaqanm, nige' sa'se'wa'tu aq wi'ge'n ugumuljin gasgiptnnaqann mun'ti'l.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ta'n tujiw assusit ula nutgeg, wel'ta'sualatl na nigan lugowinu'l muta teli ntawe'litl. Na mimajuinu'g ta'n mo getlams'tasulti'tigul Nisgaml me' natawo'ltijig je mu ta'nig majulgwala'titl.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Se'sus siaewistoq, “Telimuloq, e'wmug gtmilesuaqanmual apoqonmuan igtigig glaman gugunatoqs'p gitapuaq aq ta'n tujiw gtmilesuaqanmual gaqiaql na iapjiw gugunatoqs'p gitapuaq ta'n wel'ta'sultitaq mittugwalanew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ta'n wen gi'gwajiet ugjit apje'jgl goqwe'l gi'gwajietew ugjit mesgi'gl goqwe'l. Ta'n wen waqjuigit ugjit apje'jgl goqwe'l na waqjuigitew ugjit mesgi'gl goqwe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pa na mu gisi ulo'tmun milesuaqan ugs'tqamug ma gisi ulo'tmun milesuaqan ta'n wejiaq Nisgameg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pa na mu gisi ulo'tmun ta'n goqwei nat wen pipanimasg ango'tmn, mo wen ignmulug gi'lewei ta'n wejiaq wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ma gis lugowawjig tapusijig assusijig newtsiniw. Na me' tetapua'lates newte'jit je mu igtig. Na me' gsalates newte'jit je mu igtig. Amujpa ignmat Gjinisgam assumulin aq ma ignmuawt suliewei assumulin.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ta'n tujiw Palasiaq nutmi'tij ta'n Se'susal teluet na maligima'titl muta gesatmi'tij suliewei. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Se'sus telimaji, “Wejo'tmoq musga'tuanew mimajuinu'g ta'n tel nata' mimajultioq, gatu Gjinisgam giasgiw gejugsioq ta'n telqamigsultioq aq ta'n tegwitgl ggamlamunual. Ta'n goqwei mimajuinu'g angite'tmi'tij no'q espe'g na Gjinisgam tel'te'tg mo talawtinug ugjit goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ta'n goqwe'l Mowiso'q aq niganigjitegewinugi'g ewi'gmi'tipnn na mimajuinu'g majulgwatmi'tipnn glapis Sa'n Nutsign'tuet poqji pestung'p. Weja'tegemg na'tami mimajuinu'g wesgutmi'tij na gelu'lg agnutmaqan ta'n Gjinisgam ilgwenaji mimajuinu'. Nige' ms't wen getu' gi'gaji pisgwa't na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Me' nqamase'gt's ugjit ugs'tqamu aq wegla ta'n goqwe'l musigisg'tug gs'ga's'gtn je na apje'ji'jgl goqwe'l ta'n ewi'gas'gl Nisgamewei tplutaqanigtug mo e'wa's'gtnugupnn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Na ji'nm ta'n puna'latl ugte'piteml aq igtigl malie'wijig, na sespo'teget. Na ji'nm ta'n malie'wi'titl na e'pilitl ta'n puna'tasilitl na negm sespo'teget.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Se'sus agnutg, “Eig'p milesit ji'nm ta'n nasg'g'pnn mego'tigl aligal aq welawsip te'sigisg'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na eig's ewle'juinu ta'n gesnugwat muta ta'n telgi'g wa'qi wejgiaq. Teluisit Lasalas. Na jijuaqa ela'lut gmetug milesuinu'l wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mawatalultitaq maw 'nmu'jig ta'n milesuinu'l esmaji. We'gaw 'nmu'jig musgwatmua'titl ta'n wejgiaql. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Na ewle'juinu nepg aq ansale'wijig ela'la'titl wa'so'q aq epa'la'titl gigjiw Aplameg. Na milesuinu elg nepg aq utqutalut. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Elgimut ta'n npuinu'g eimu'tijig. Ge's welmaje'g, wenaqapa'sit aq nemiatl Aplamal gnegg eimlitl aq maw Lasalasal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sesgwalatl, ‘Aplam, gi'l na nujj. Ewlite'lmi aq lgim Lasalas ni'neg. Pewalg jugwa'tuin samqwan glaman ntun ul newattew muta no'q etli ulmaje'i tet ta'n etlamgleg.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Aplam telimatl, ‘Gwi's ma gisi ignmulueg. Migwite'te'n ge's mimajineg pugwelgl ta'n goqwe'l gelu'lgl mesnmu't'pnn, gatu Lasalas mesng'pnn ewle'jgl ta'n goqwe'l. Nige' welawsit tet ge's gi'l etli ulmaje'n na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Eteg mesgi'g elmalqei etoqwalugsi'gw. Ta'n wen getu' asoqoma'sit tet glapis gi'leg, ma gis liegw aq elg ta'n wen getu' asoqoma'sit gi'leg weja'tegemg ta'n gaqami ma gis liegw.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Na milesuinu telimatl, ‘Aplam gi'l na nujj. Etawaqtmul aq lgim Lasalas nujj wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Na'nijig wijigmgig eimu'tijig na'te'l. Lgim gnua'tuanew ta'n eim glaman ma lta'gw tet ta'n etl ulmaje'i.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Aplam telimatl, ‘Ma gis tla'tegeweg. Gjignamg gis gitmi'tij ta'n goqwei Mowiso'q aq niganigjitegewinugi'g gis wi'gmi'tip. Gjignamg gis jigs'tmi'tij ta'n goqwei gis wi'gas'g.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Na milesuinu teluet, ‘Aplam, wetapegsi gi'leg. Mo tepianug. Nantawa's'g nat wen weji apaja'sis npuaqanigtug aq lietew negmoweg na tujiw gawasgita'sultisnig aq ejiglita'snig lue'utigtug.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aplam telimatl, ‘Ge's mu jigs'tua'ti'gw ta'n goqwei Mowiso'q aq niganigjitegewinugi'g gis wi'gmi'tip na ma jigs'tua'tigul wenn je tlia nmia'tij apajipelij.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Se'sus telimaji unaqapemg, “Wegla ta'n goqwe'l gisa'laji mimajuinu'g pata'taqatinew apjiw i'gt'tal, gatu no'q mtue'tew ugjit na mimajuinu ta'n gisa'laji igtigi pata'taqatinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Me' glu'lgt'soq ugjit ula mimajuinu gl'pilan ugjitaqaneg na mulinewei gi'taqanei aq ejiglpega'lut gta'nug, jel mu gisa'lan na mimajuinu'l ta'n poqji gtlams'tasilitl pata'tegelin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ango'tmug ta'n goqwei getu tla'taqatitoqs'p. “Pa na na gitap pata'tegej tlim gis pata'teget. Pa na pun tla'tegess na apigsigtu. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nantawa's'g nat wen opla'l'sg aq wijei goqwei na lluigneg tela'l'sg na wijei na'gweg. Te's pegising gi'leg aq teluet, ‘Mesgei' ta'n tel tla'tegei,’ na amuj apigsigtuates.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostale'wijig telima'titl Gjisaqamawl, “Gtlams'tuaqanminen gisa'tu me' ml'gignan.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Gjisaqamaw telimaji, “Ta'n tujiw gtlams'tuaqanmuow telgi'g st'ge' mustate' sginmin, mo eigtnug goqwei ta'n wesami mtue'g. Nantawa's'g telimoq miti's, ‘Mna'qigwalsi aq igalsi gta'nug.’ na miti's jigs'tugsitoqs'p aq tla'tegetew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nantawa's'g newte'jioq geggunmuoqos lugowinu ta'n etl'gesewet gisna angweiwaj jijgluewjig. Ta'n tujiw wejiej iga'taqanigtug, etugjel telimatl, ‘Smtug pisgwa' aq mijjin.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Awna tlimates, ‘Ntwela'geweim gisgaja'tu tmg. Toqosip laqpisutia'si aq lugowi, ge's etli uloqotal. Ta'n tujiw gaqatalan, na gis mijjites.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mo miwatmuawt na lugowinu ugjit ta'n goqwei pas'g ugtlugowaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Lpa wijei gilew ta'n gisa'tuoq gtlugowaqanmuow pas'g tluegw, ‘Mo te'pmueg miwa'lugsin, pas'g gis tla'taqatieg ta'n telteg tla'taqatinen. Ninen pas'g lugowinu'g aq pas'g gisa'tueg ntlugowaqanminen.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ge's Se'sus eliej Selusalemg saputa'sit miawe'g Samaliae'gati aq Galaliewa'gi. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ge's pem pisgwa'j utan newtisgegsiliji ji'nmug weltesguaji. Wegla ji'nmug geggunmi'tij 'gsnugowaqan teluisig leplsi. Gnegge'l gaqamultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Na sesgwala'titl, “Se'sus, gi'l na assusit, ewlite'lminen!” ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Se'sus angamaji aq telimaji, “Lta'gw patlia'seg angamugsitoqs'p.” Ge's el'ta'jig patlia'sewigtug nepilujig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Newte'jit ta'n tujiw geitoq gisi npisit, apaja'sit Se'suseg aq gesigaw miwatmuatl Gjinisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nutgulpioqolomgwa'sit Se'suseg aq miwatmuatl. Ula ji'nm tleiawit Samaliae'gatig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Se'sus teluet, “Newtisgegsipnig ta'n gisi npilut'pnig, gatu talitatgi'g igtigig pesgunateg te'sijig? ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tal gi's pas'g newte'jit apaja'sit ugjit miwatmuan Gjinisgaml aq ula ji'nm se'g tleiawit?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na tujiw telimatl, “Qama'sites aq 'nmiates. Gtlams'tuaqan gisi npil'sg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ta'sijig Palasiaq pipanima'titl Se'susal, “Ta'nug Gjinisgam ilgwenata mimajuinu' ugs'tqamug?” Telimaji, “Mo wen nemitoq ta'n tujiw Gjinisgam poqji ilgwenaji mimajuinu' muta ta'n goqwei Gjinisgam gisa'toq tlian na ma wenn gis nmituligul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma wen tluegw, ‘Angaptmug ula iga'q!’ gisna ‘Ala eteg!’ muta ta'n goqwei Gjinisgam tla'tegetew na usgowa's'gt'tew na gisi ilgwenaji mimajuinu' gileweg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Na tujiw telimaji unaqapemg, “Ni'n na mimajuinualsiap aq wejgu'aqal na'gwegl ta'n gsattoqs'p mimajultinew ta'n tujiw gis apaja'si aq assutm ms't goqwei ugs'tqamug, gatu ma usgowa's'gtnug st'ge' pewatmoq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Iga'qt'tal na na'gwegl ta'n mimajuinu'g tlimugsitoqs'p, ‘Jugwa'tigw! Angamug negm! Ula tet eig!’ gisna ‘Ala tet eig!’ Mut majulgwalug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wasoqotesg pitiata's'g musigisg, weja'tegemg ugjipenug glapis tg'snug. Na ta'n tujiw apaja'sia's ugs'tqamug, tl jaqali pgisintes pa wijei aq wasoqotesg muta ni'n na mimajuinualsiap. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Gatu tmg amuj ulmaje'tes aq na pugwelgig mimajuinu'g ta'n nige' wigultijig ma menuaqaligw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ni'n na mimajuinualsiap aq ta'n tujiw apaja'sia's mimajuinu'g tla'taqatitaq aq tlo'ltitaq st'ge' na mimajuinugi'g mimajultipnig ta'n tujiw Noao'q mimajiteg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ms't mimajuinu'g siawatalultipnig. Ta'sijig malie'ultipnig na wijei na'gweg ta'n tujiw Noao'q tepa'siteg ugtuluaq. Na tujiw gespaqami'g'p aq ms't wen nepg'pnaq samqwanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ta'n tujiw apaja'sia's mimajuinu'g tla'taqatitaq aq tlo'ltitaq st'ge' na mimajuinugi'g mimajultipnig ta'n tujiw La'to'q mimajiteg. Wijei tel siaw mimajultipnig. Mijjultipnig, pegwateliga'tipnig, netuisga'tipnig, iga'taqu'tipnig aq ewi'ga'tipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ta'n tujiw La't naqt'geg Satmg, Gjinisgam gisa'toqop pugtew aq supliei ugji nisian musigisg'tug aq ms't wenig nepu'tipnig Satmg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na st'ge' ta'n teliaqap na wijei tliatew ta'n tujiw ni'n na mimajuinualsiap ap pgisintes. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Na mimajuinu ta'n i'ttew gujmug wiguaq na ma pisgwa'gw wiguaq ugjit tuo'tun utapsun. Na wije'tew ugjit na mimajuinu ta'n iga'taqanigtug i'ttew, na ma apaja'sigw wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Migwite'lmug La't ugte'piteml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ta'n wen wejo'tg ugs'tawi'sin na np'tew, gatu ta'n wen gisgaje'g ugjit ntun ms't goqwei je we'gaw ugmimajuaqanm na ugs'tatew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Telimuloq, tapusijig mimajuinu'g npataq wijei npo'qonigtug, newte'jit ugsua'laten aq igtig nqalaten. ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tapusijig e'pijig tl nugwa'gittutaq glumgl, newte'jit ugsua'laten aq igtig nqalaten.  ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tapusijig ji'nmug i'ttaq iga'taqanigtug, newte'jit ugsua'laten aq igtig nqalaten.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Na apostale'wijig pipanima'titl, “Gjisaqamaw tami tet wegla tliatal?” Telimaji, “Ta'n eig wi'sis nepg, ga'qaqujg mawia'titaq na'te'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na tujiw Se'sus telimaji a'tugwaqan unaqapemg muta pewalaji ne'gaw a'sutma'tinew aq mu musguajita'sultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Teluet, “Nuji ilsuteget eig'p gjigang. Mo jipalagul Gjinisgaml aq mo wen gepmite'lmagul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Elg eig sigu'sgw ula wijei gjigan ta'n pusgi naji nmiatl na nuji ilsutegelitl aq etawaqtmatl. Telimatl, ‘Apoqonmui wissuigneman ta'n wen getanit.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lpa wel sa'q ula nuji ilsuteget mo getu apoqonmuagul glapis giaspi tlimsit, ‘Tlia to'q mo gepmite'lmaqig mimajuinu'g aq mo jipalaq Gjinisgam, ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","amuj apoqonmaq ula sigu'sgw. Me' gatu gitnme'wit aq ma punajimigw glapis gaqatejimitew.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na tujiw Gjisaqamaw teluet, “Ge' jigs'tug ta'n goqwei nuji ilsuteget teluej je tlia mo tetapua'tegegup. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Gjinisgam tetapua'lata ugmimajuinumg ta'n gisi mgnapni. Smtug apoqonmuata muta etawaqtmagwi'titl apoqonmuanew tepgig aq na'gweg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Telimuloq, ilsutegetew ugjit negmow aq smtug tla'tegetew. Ni'n na mimajuinualsiap aq ta'n tujiw apaja'sia's ugs'tqamug etug mimajuinu'g me' lita'sualitaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Se'sus a'tugwaqan telimaji ta'siliji mimajuinu' ta'n espite'lsultiliji. Tel'te'tmi'tij na igtigi mu tel glu'sulti'gw st'ge' negmow aq penoqite'lma'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Teluet, “Tapusijig ji'nmug naji a'sutmajig gjia'sutuo'guomg. Newte'jit na Palasi aq igtig na nujintutmat suliewei. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na Palasiewa'j newtapuguit aq a'sutmat. Teluet, ‘Gjinisgam miwatmul mo telqamigsiw st'ge' igtigig. Mo na gmutnes, mo nata' egsuew, mo sespo'tegew. Miwatmul mu tele'w st'ge' nujintutmat ta'n eig ugtejg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Te's aqan'tie'uti tapuguna'q teli pgiji sune'wi aq ignmul newta'ig ta'n te's metlasa'igl ganie'wi.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Gatu na nujintutmat gaqamit ugtejg a'sutuo'guomg. Tetuji ms'ge'g ta'n tel gis pata'tegej aq ugpusgun matte'g. Naqatgelsit aq a'sutmat. Teluet, ‘Gjinisgam, ewlite'lmi. Ni'n gisi pata'tegei.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Se'sus teluet, “Telimuloq, ta'n tujiw wegla ji'nmug gi's maja'titeg, Gjinisgam wel'te'lmatl na nujintutmalitl gatu mu wel'te'lmagul na niganpuguilitl muta espite'lsilitl. Gjinisgam mu gepmite'lmagul ta'n wenn newtite'lsilitl gatu gepmite'lmatl ta'n wenn mu espite'lsiligul.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Te'sijig mimajuinu'g pegisula'tiji un'janua Se'suseg muta pewala'titl gegupa'tunn ugpitnn un'jiwaq aq a'sutmessewan. Ta'n tujiw Se'sus unaqapemg nemitu'tilij ta'n goqwei teliaq na majiaqa'la'tiji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Gatu Se'sus wigumaji mijua'ji'jg aq teluet, “Ignmug mijua'ji'jg jugwita'new ni'neg. Mut wetqo'lanew, muta Gjinisgam ilgwenaji mimajuinu' ta'n getlams'tasultiliji ni'neg st'ge' wegla mijua'ji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Migwite'tmug ula. Ta'n wen mo getlams'tasigul Nisgaml st'ge' wegla mijua'ji'jg ma gis pisgwa'gw ta'n Gjinisgam etli ilgwenaji mimajuinu'.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na niganpuguit Lesui'p pipanimatl Se'susal, “Nujigina'muet gi'l na gelu'sin. Tala'tega's ugjit msnmn iapjiwewei mimajuaqan?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Se'sus pipanimatl, “Tal gi's teluen ni'n na gelu'si? Mo wen gelu'sigw pas'g Gjinisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Geitu'n Nisgamewe'l tplutaqann: ‘Mut sespo'tegew, mut ne'pa'tegew, mut gmutnew, mut pisui agniman igtigig aq gepmite'lm gujj aq ggij.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na ji'nm teluet, “Weja'tegemgeg maljewe'juianeg, na majulgwatman ta'n te's'gl tplutaqann.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ta'n tujiw Se'sus nutgeg na teluet, “Na newte' goqwei amujpa tla'tegetes. Ntuisgetu ta'n te's'g goqwei geggunmn aq na suliewei ignmu ewle'juinu'g. Na tujiw jugu'ates aq majulgwalites aq milesuaqan guguntes wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ta'n tujiw na ji'nm nutgeg ula, na no'q ewlgwijing muta no'q milesit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Se'sus nemiatl ewlgwijilitl aq teluet, “Na tetuji mtue'g ugjit milesit mimajuinu pisgwa'n ta'n Gjinisgam etli ilgwenaji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Me' metue'g ugjit milesuinu ignmuan Gjinisgaml ilgwentl, je mu melgwlejit tel saputa'siss sapalqe'g saqati'gtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Na mimajuinu'g ta'n nutua'titl Se'susal pipanima'titl, “Wen gisi ugs'tawiaten?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Se'sus teluet, “Ta'n goqwei mimajuinu mu gis tla'tegegw, naqamase'g ugjit Gjinisgam tla'tegen.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na tujiw Pie'l teluet, “Telimul, gis naqtmeg'pnn nignal ugjit wije'ulin.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Se'sus telimaji, “Teliaq na, gatu telimuloq na ta'n wen naqalatl ugte'piteml gisna wiguow, wijig'tiliji, ungi'gug, gisna un'jang, ugjit lugowan Gjinisgam aq tliman igtigi ta'n Gjinisgam getu' ilgwenaji, ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","me' ms'gi'gt'tew ta'n goqwei mesng nige' aq msntew iapjiwewei mimajuaqan wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Se'sus gmetug ela'laji unaqapemg aq telimaji, “Jigs'tuigw! Ni'n na mimajuinualsiap aq niganigjitegewinugi'g nigani wi'gmi'tipnn Gjinisgam ugtwi'gatigng ta'n goqwe'l mimajuinu'g tla'litaq. Selusalemg el'ta'igw aq ms't goqwe'l gis wi'gmi'tipnn na tliatal na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Na ignmuitaq ta'nig mo Lesui'peulti'gw. Na maligmitaq, emegwei'witaq aq elusgomitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nipispaqante'itaq aq ne'pa'itaq. Utqotalitaq gatu nesuguna'q iga'qt'tew na tujiw minunsia's.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Unaqapemg mo nestmi'ti'gw wegla goqwe'l. Mo nestmi'ti'gw ta'n goqwe'l wesgutgl glaman mo geitu'ti'gw ta'n Se'sus getu' tlimaji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ge's Se'sus pem pisgwa'j na utanji'j teluisig Jeligo, na ji'nm pemgopit gigjiw awtigtug. Nepapigwa't aq etl'tawaqtmat. ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nutuaji mimajuinu'g pemita'liji awtigtug aq pipanigesit, “Taliaq?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Telimut, “Se'sus, na ji'nm tleiawit Nasaletg pemiet.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Sesgwet, “Se'sus. geitu wetapegsin Ta'piteg, ewlite'lmi.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Na mimajuinu'g ta'n niganita'jig majiaqa'la'titl aq telima'titl wantaqien, gatu me' aji gsigawwet, “Geitu wetapegsin Ta'piteg, ewlite'lmi.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Se'sus naqa'sit aq pipanimaji alt mimajuinu'g jugwa'lanew na nepapigwa'litl. Ta'n tujiw na ji'nmul gigja'silij, Se'sus pipanimatl, ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Goqwei pewalin tla'tegen ugjit gi'l.” Telimatl Se'susal, “Saqamaw getu nmitegei ap.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Se'sus telimatl, “Nmitega, muta teli gtlams'tasin na weji npisin.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Smtug gisi nmiteget aq majulgwalatl Se'susal aq miwatmuatl Gjinisgaml. Ta'n tujiw mimajuinu'g nemitu'tij ta'n gis tliaq, ms't miwatmua'titl Gjinisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Se'sus pegising Jeligo aq pem saputa'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na nujintutmat suliewei teluisit Saggi'us wigit na'te'l. Milesit muta assumaji igtigi nujintutma'tilij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Naji nmiatl Se'susal muta getu' gji'jiatl ta'n wenn. Me' pugwelgig mimajuinu'g wije'watl Se'susal. Saggi'us mu gis nmiagul muta mu tepianug ta'n tel pitoqsij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nigan'tugwi'g awtigtug aq toqjugusuet miti'sigtug ta'n tel wi'tut sigmol. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Se'sus pegising na'te'l aq toqjuapa'sit miti'sigtug. Telimatl Saggi'usal, “Tetaqi nisa'si muta getu' liei giguaq gisgug.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Saggi'us tetaqi nisa'sit aq Se'susal enma'latl wiguaq. Wel'ta'sualatl ta'n Se'susal tel mittugwalj. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ta'sijig mimajuinu'g ta'n pem wije'wa'titl Se'susal mu weli usguma'tigul. Telimtultijig, “Se'sus wije'watl pata'tegewinu'l aq we'gaw pisgwa't pata'tegewinu wiguaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tel'gne'ge'l Saggi'us gaqama'sit aq telimatl Gjisaqamawl, “Gjisaqamaw, jigs'tui, na aqataig ta'n assutm ignmua's ewle'juinu'g. Pa na ta'n wen wesamintutmaqapnig na apaji ignmua's ne'wa'igl ugjit te's newta'ig ta'n wesamintutmaqap.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Se'sus telimatl, “Gisgug gi'l aq gigmaq westawultioq.” Telimaji esgwia'tiliji ta'n eimu'tiliji na'te'l, “Geitu ula ji'nm wetapegsit Aplameg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ni'n na mimajuinualsiap aq weji pgisinap ugs'tqamug ugjit gwiluan pata'tegewinu'g glaman ugs'tawia's.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ge's na mimajuinu'g jigs'tua'titl Se'susal na tel'te'tmi'tij Gjinisgam smtug ilgwenaji ms't mimajuinu' Lesui'pe'gati muta Se'susal gigjiw eimlitl Selusalemg. Na tujiw Se'sus telimaji a'tugwaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Teluet, “Eig'p na niganpuguit ta'n pemiet gnegg. Na'te'l tli elege'wa'laten je mu apaja'sigw wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ge's mu naqtmugw wiguow wigumaji na newtisgegsiliji uglugowinumg, aq te's newte'jilitl ignmuatl wisaw suliewei. Telimaji, ‘E'wmug ula suliewei ugjit ganie'winen igtig suliewei ge's mo eimu tet.’ Na tujiw ejigla'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Na mimajuinu'g ta'n tleiawultijig umutgi masgelma'titl aq elgima'tiji nutagnutmewinu'g ta'n eliej ugjit tluenew, ‘Mo pewalaqatt ula ji'nm ugjit ilgwenugsinen.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Gatu elege'wa'lut aq apaja'sit umutgig. Wigumaji uglugowinumg ta'n suliewei ignmuapni muta getu' gji'toqop ta'n telgi'g gis ganie'ultipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Na amgwesewei teluet, ‘Saqamaw, gisi ganie'wian newtisga'qal suliewe'l ugjit na newte' ta'n ignmui't'p.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Elege'wit teluet, ‘Wel lugwen. Gelu'sin lugowinu muta tetapua'tege't'p ugjit apje'jgewei lugowaqan aq nige' iga'lul niganpuguassutmn newtisga'qal gjigann.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na ta'puewei lugowinu teluet, ‘Saqamaw, gisi ganie'wian na'ngl suliewe'l ugjit na newte' ta'n ignmui't'p.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Elege'wit talimapnn, ‘Gi'l assusites na'ngl gjigann.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Igtig lugowinu telimatl elege'wilitl, ‘Saqamaw, ula na gsulieweim. Ne'gaw mimgwa'tuap musue'igtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Jipalul muta melge'g ggamlamun. Wesua'tun ta'n goqwei mo ganie'wiwt'p aq mawo'tun ta'n goqwei mo iga'taqatmugt'p.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Elege'wit telimatl, ‘Mo gelu'siwn lugowinu. E'wmultes gglusuaqanml ugjit tli ilsumulin. Geitu'n melge'g ntgamlamun muta wesua'tu ta'n goqwei mo ganie'wiwap aq elg mawo'tu ta'n goqwei mo iga'taqu'tmuap. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Goqwei ugjit ntsulieweim mo iga'tuiws'p sulieweio'guomg glaman apji mawo'tutes ntsulieweim aq je me'?’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Na telimaji ta'siliji ta'n alpugultiliji, ‘Ugsua'tug na suliewei ta'n ula ji'nm geggung aq ignmug negm ta'n geggungl newtisga'qal suliewe'l.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Telima'titl, ‘Saqamaw, ula ji'nm gi's geggungl newtisga'qal suliewe'l.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Elege'wit telimaji, ‘Telimuloq, ta'n wen getu' tetapua'toq ta'n goqwei gina'muei na ignmuaten ns'tmn me' igtigl, gatu ta'n wen mo getu' ns'tmug ta'n egina'muei na ta'n goqwei geggung ugsua'tuaten. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nige' wegla ta'n getanijig aq mo pewaligwig elege'witewin, jugwa'lug ni'neg aq sigto'q.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ula Se'sus gis tluet aq siawa'sit Selusalemg. Pugwelgig mimajuinu'g majulgwala'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pem tepawa'sij na tapu'gl utanji'jl teluisigl Petpage' aq Pettani ta'n etegl na gm'tn teluisit Olipet. Tapusiliji unaqapemg wigumaji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Telimaji, “La'tigw na utanji'j nigantug. Ta'n tujiw pisgwa'tioq nmiatoqs'p te'sipowji'j ta'n gelpilasit. Mnaq wen ali'puluegul. Apgwa'lug aq jugwa'lug tet. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pa na wen pipanimugisoq, ‘Goqwei weji apgwa'loq?’ na tlimug, ‘Gjisaqamaw pewalatl.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na tapusijig ela'tijig utanji'jg aq na te'sipowji'j eig gelpisit st'ge' ta'n Se'sus telimapni. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ge's etli apgwa'la'tij, na ta'n wenig ugtue'mual pipanimgwi'tiji, “Goqwei weji apgwa'loq ntue'minen?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Apostale'wijig telima'tiji, “Gjisaqamaw pewalatl.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ela'la'titl te'sipowji'tl Se'suseg. Ge'gwa'tua'titl utapsunual na te'sipowji'tl ugpaqamg aq apoqonmua'titl Se'susal tepa'silin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ge's pemi'puluej, mimajuinu'g siplamgo'la'tiji ugpitu'gunmua awtigtug ta'n eliej na te'sipowji'j. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ta'n tujiw pem nisi'puluet na gm'tn Olipet ta'n tepaw Selusalemg, na pugwenniji unaqapemg majulgwalgwi'titl. Welgwijultijig aq gepmite'lma'titl Gjinisgaml ugjit ms't paqalaiuti'l gis nemitu'ti'tipnn. Gesigaw tlima'titl Se'susal, ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Gisiteget pajiji gepmite'lmatl. Gi'l na elege'wit ta'n petgimapnn ugs'tqamug. Geitueg wantaqo'ti eteg wa'so'q aq emtoqwalg'tt Gjinisgam nige'.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Alt Palasiaq ta'n eimu'tijig na'te'l, telima'titl Se'susal, “Nujigina'muet, tlim gnaqapemg mu tluenew ta'n goqwei teluejig.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Se'sus telimaji, “Telimuloq, pa na punewo'gutijig, na gun'tal sesgu'tital.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ta'n tujiw gigjiw eig Selusalemg na angapt'g aq atgitemit. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Teluet, “Gilew tleiawultioq ula gjigan pa na gisi gji'tuoq ta'n tel gisi ignmugsioq wantaqo'ti ggamlamunuaq gatu mu nestasultiwoq ta'n goqwei menuega'tioq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na wejgu'aqal na'gwegl na mimajuinu'g ta'n getanugsioqig gigto'qotesgmu'titaq ula gjigan. Ma ignmua'tigwi ta'n wen tuita'new. Jugwa'tutal matntimgewe'l aq poqji gisgajo'ltitaq matntultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Suiste'taq na gjigan, gtmegete'tal gigual aq ne'po'qsitoqs'p. Gjigang ma i'ttnug gun'tew ta'n ma maja'tas'gtnug, muta ma geitu'tiwoqop ta'n tujiw Gjinisgam pegising'p ugjit ugs'tawugsinew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na tujiw pisgwa't gjigang aq pisgwa't gjia'sutuo'guomg. Poqji tuaqtesguaji ntuisge'winu'. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Telimaji, “Ewi'gas'g Gjinisgam ugtwi'gatigng ta'n Gjinisgam teluep, ‘Nignen na tluisitew gjia'sutuo'guom, gatu e'wmuoq ugjit gmutnesg wiguow.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na Se'sus etl gina'muet gjia'sutuo'guomg te'sigisg'g, gatu na niganpugultijig patlia'sg, nujigina'mua'tijig tplutaqan aq igtigig niganpugultijig getu' ne'pa'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Gatu mo geitu'ti'gw ta'n gis tla'taqatijig muta pugwelgig mimajuinu'g wijitgweiwa'titl aq jigs'tua'titl ta'n etl gina'muet. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Newtejgeg na'gweg ge's Se'sus etl pestungeg gjia'sutuo'guomg aq etl gina'muet na gelu'lg agnutmaqan, na niganpugultijig patlia'sg, nujigina'mua'tijig Mowisewei tplutaqan aq igtigig niganpugultijig peita'liji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Telima'titl, “Ge' tliminen, tal gis tla'tegen weget? Wen ignmasg assusuti ugjit tla'tegen wegla ta'n goqwe'l?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Se'sus telimaji, “Elg pipanimuloq nat goqwei. Tlimigw, ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wen petgimasnn Sa'nal ugjit sign'tuan mimajuinu', Gjinisgam gisna mimajuinu'g?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wesgutmi'tij ta'n goqwei Se'susal pipanimji aq gi'gaita'jig. Alt teluejig, “Pa na tlueigw na Gjinisgam petgimt'pnn, na tujiw tluetew, ‘Goqwei ugjit mo getlams'tuawoqoss Sa'n?’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pa na tlueigw mimajuinu'g petgimapnn, na mimajuinu'g ta'n eimu'tijig lpa gun'tewtoqsitesnu muta getlams'tasultijig Sa'nal na niganigjitegewinu'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Na glaman telima'titl Se'susal, “Mo gejiaqatt ta'n wen petgimapnn Sa'nal.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na tujiw Se'sus telimaji, “Elg ni'n ma tlimuluoq ta'n weja'tu ntml'gigno'tim ugjit gis tla'tegen wegla ta'n goqwe'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na tujiw Se'sus agnutmuaji mimajuinu' ula a'tugwaqan, “Na ji'nm ugtiga'taqang iga'taqaliji aloqomanaqsi'g Na tujiw ugtiga'taqanm emgatuaji ta'siliji nuji iga'taqatiliji ugjit apangituewei aq eliet na'tami se'g pegije'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ta'n tujiw mena'taqutimg iga'q na aloqomann, na elgimatl lugowinu'l ugjit mgnmnin ta'n goqwei wejgu'aqamij. Na iga'taqewinu'g awna matta'titl ula lugowinu'l. Mo goqwei ignmua'tigul aq ejiglgima'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Na ap assusit elgimatl igtigl lugowinu'l aq ap na nuji iga'taqu'tijig elg matta'titl. No'q gesita'titl, ejiglgima'titl aq mo goqwei ignmua'tigul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Na si'stewei lugowinu elgimut. Na nuji iga'taqu'tijig emegwei'wa'titl aq ejigltesgua'titl iga'taqanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Na assusit teluet, ‘Tala'tega's nige'? Etug elgimg ngwis ta'n mawi gsite'lm'g, amuj gepmite'lmata negla.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ta'n tujiw nuji iga'taqu'tijig nemitua'titl uggwisl telimtultijig, ‘Ula na assusit uggwisl. Ge' ne'pa'nej aq ula iga'taqan na ginuewe'tew.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Glaman ejigltesgua'titl iga'taqanigtug aq ne'pa'titl.” Na tujiw Se'sus telimaji mimajuinu', “Etug nige' na assusit tala'lata nuji iga'taqu'tiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Telimuloq, jugu'etew aq ne'pa'ta nuji iga'taqu'tiliji. Na igtigi mqatuata na maqamigew.” Na mimajuinu'g ta'n etl jigs'tuaji mo weli ns'tmi'ti'gw ula aq teluejig, “Moqwa', mo eigtnug tlian.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Se'sus angamaji aq pipanimaji, “Ge' tlimigw. Tali ns'tmoq ula ta'n ewi'gas'g Gjinisgam ugtwi'gatigng? ‘Na gun'tew ta'n nujitaqatijig mo pewatmi'tip na me' gepme'tas'g je mu esgwiaqal aq mawn'g ms't gun'tew wen'ji'guomigtug.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pa na wen nisiej ula gun'tewigtug, na sigtesintew aq pa na wen pasto'gwej na gun'tew, lpa sigto'qwetew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na nujigina'mua'tijig tplutaqan aq niganpugultijig patlia'sg wejo'tmi'tij ugsua'lan Se'susal muta mo gesatmi'ti'gw ula a'tugwaqan. Tel'ta'sultijig wesgumgwi'titl ta'n tujiw etlewistulij gatu pe'l jipala'tiji mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Na esgmatmi'tij tetaputes'tn ugjit assumanew Se'susal. Ta'siliji ji'nmu ignmua'tiji suliewei ugjit egsua'tinew aq gistesguanew Se'susal ge's mil pipanima'tij. Etug gisa'latl Se'susal opla'tegen aq na tujiw nujigina'mua'tijig aq gjipatlia'sg la'latew Lo'mewei niganpuguit ugjit ilsuman. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wegla ji'nmug telima'titl Se'susal, “Nujigina'muet, geitueg ta'n teluen aq goqwei gegina'muen na tetapu'en. Geju'leg mo aji gsite'lmawt newte'jit mimajuinu je mu igtig. Tetapu gina'muen ta'n Gjinisgam tel pualaji ugjit mimajuinu' gji'tunew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Giasgiw tliminen ta'n tplutaqanminu telueg. Amujpa apangitmnenu suliewei na Lo'mewei elege'wit gisna moqwa'?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Gatu Se'sus gejiaji ta'n tel lugutilij aq telimaji, ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ge' neia'tuigw ta's'g suliewei. Wen ugsisgw aq ugwisunm nastegl na'te'l?” Telima'titl, “Elege'witewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Na tujiw Se'sus telimaji, “Na to'q, apangitmug g'pnno'l ta'n goqwei g'pnno'lewei aq ignmug Gjinisgam ta'n goqwei Nisgamewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ge's Se'sus gelulaji na esgwia'tiliji mimajuinu', lpa mo gisapsgngwi'tigul. Awna paqalaiultiliji ta'n teluej. Mu goqwei pipanima'tigul nugu. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ta'sijig Satusiaq el'ta'jig Se'suseg. Na tel'ta'sultijig ma nugu npuinu'g minunsulti'gw glaman pipanima'titl, ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Nujigina'muet, Mowiso'q ewi'gmugsieg'p tplutaqanminu. Newte' telueg, ‘Pa na ji'nm nepg's ta'n tepqatg toqo mo un'janigw, na ugjignaml amujpa malie'witaq na sigu'sgwal glaman gisi gugunata mijua'ji'jg ugjit na ji'nmaq nepg'pnaq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jijuaqa na lluigneg te'sijig wijig'tultijig ji'nmug. Na mujga gisiguitaq malie'wipnaq. Nutaiw nepgaq ge's mu ugte'piteml gisi tle'ligul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na tujiw ta'puewa'j malie'wi'titl sigu'sgwal, nutaiw nepg's ge's mu gisi un'jan i'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na tujiw si'stewa'j malie'wilitl sigu'sgwal gatu nepg's ge's mu un'jani'gw. Lpa wijei te'sijig tela'teget aq ms't nepu'tijig ge's mu mijua'ji'jg gegguna'tigwi. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Toqo na na sigu'sgw nepg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ta'n tujiw Gjinisgam minua'laj npuinu'g, wen na ugte'pitemital muta lluigneg te'sipnaq gis malie'ulti'tipnn wije'l e'pilitl?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Se'sus telimaji Satusiaq, “Na ji'nmug aq e'pijig ugs'tqamug siaw malie'ultitaq glapis ugtejgewei na'gweg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Gatu na mimajuinu'g ta'n Nisgaml ilsumji glu'sultinew na minua'lutaq aq apaji mimajultitaq wa'so'q. Na ma malie'ulti'gw ta'n tujiw minu mimajulti'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wegla mimajuinu'g tlo'ltitaq pa wijei aq ansale'wijig aq ma gisi npu'ti'gw. Negmow na Gjinisgam un'jang muta Gjinisgaml gisa'lguta minua'lanew aq apaji mimajultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mowiso'q giasgiw neia'toqop na ta'n nepu'tijig minua'laten. Ta'n tujiw na miti'sji'j etlamgleteg paqtaqamigtug Mowiso'q teli usgumatl Gisitegelitl aq teluep, ‘Aplamo'q, Isaqo'q aq Je'gopo'q me' emtoqwala'titl Gjinisgaml wa'so'q.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mimajuinu'g ta'n mimajultijig emtoqwala'titl Gjinisgaml, mu na npuinu'g. Gjinisgam gisa'laji ms't mimajuinu' me' mimajultinew je tlia gis nepu'tlisni.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Alt nujigina'mua'tijig tplutaqan telima'titl, “Nujigina'muet wele'wistun!” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Weja'tegemg na tujiw mo wen nugu pipanimagul igtigl goqwe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Se'sus telimaji, “Tal gis alt mimajuinu'g teluejig na Nujiugs'tawi'wet wetapegsit Ta'piteg? ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Na ewi'gas'g ta'n goqwei Ta'pito'q teluet na gtapegiaqanei wi'gatignigtug. Na'te'l eteg ula, ‘Na Gisiteget telimatl Wa'so'qewe'l Gjisaqamawl ta'n emtoqwalgl, Pa'si tet ntinaqanmg ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","glapis gisi wissuignemgig ta'nig getan'sgig aq gisa'l'gig gepmite'lmulinew.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tal gis Gjisaqamaw wetapegsit Ta'piteg muta Ta'pito'q tel wi'tapnn Wa'so'qewei Gjisaqamaw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ge's ta'n te'siliji etl jigs'ta'titl, na Se'sus telimaji unaqapemg, ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ango'tmug, mut tlo'ltinew st'ge' nujigina'mua'tijig tplutaqan. Gesatmi'tij nasgmi'titew mego'tigl aligal aq wesami gsatmi'tij gepmite'lmuj magasang. Megnmi'titl na mujgajewe'l mutputi'l a'sutuo'guomg aq wijei te's tami pestie'umg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Gesputua'tiji sigu'sgwa aq wesua'tua'tiji pugwelgl ta'n goqwe'l sigu'sgwa gugunmli'titl. Na pegiji a'sutma'tijig muta pewala'tiji mimajuinu' nmugsinew. Me' ma'muni mtue'tew ta'n tujiw Gjinisgam ilsumaj muta me' ma'muni ugtapulaten je mu esgwia'tijig.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ge's Se'sus alapij nemiaji milesuinu' tepege'tili'tij suliewei metiaqatestaqanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Elg nemiatl ewle'jilitl sigu'sgwal tepegelitl tapu'gl apje'ji'jgl suliewe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Teluet, “Telimuloq, ula ewle'jit sigu'sgw me' mesgi'g gi's tepegej je mu igtigig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Milesuinu'g tepege'tij ta'n goqwei piamiaq gatu ula sigu'sgw tepeget ms't suliewei je tlia ewle'jit.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ta'sijig mimajuinu'g teli usgutmi'tij ta'n weli angamgug na gjia'sutuo'guom, na mego'tigl gun'tal nesegna's'gl na gjia'sutuo'guomg aq ta'n gelu'lgl goqwe'l mimajuinu'g ignmua'tipnn Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Se'sus telimaji, “Na na'gweg wejgu'aq ms't gun'tal nemituoq jigla'tas'gt'tal ula tet. Te's gun'tew ta'n nesegna's'gl na gjia'sutuo'guomg nisa'lugta's'gt'tew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pipanima'titl Se'susal, “Nujigina'muet ta'nug wegla ta'n goqwe'l tliatal? Tali gji'tutesnen ta'n tujiw gtu' tliaq?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Telimaji, “Ango'tmug. Mut lue'wa'lugsinew ta'n goqwe'l nutmaq. Pugwelgig peita'taq aq tluetaq, ‘Ni'n na negm!’ aq ‘Na na'gweg iga'q!’ Mut majulgwalanew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mut jipasultinew ta'n tujiw nutmaioq ugjit matntimgl aq mimajuinu'g assuma'tiji aq tuaqtesgua'tiji g'pnno'lewa'jg. Wegla amujpa tmg tliatal, gatu na ugtejgewe'l na'gwegl ma smtug tlianugl.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Se'sus siawewo'qwet, “Newt nemigsijig mimajuinu'g matna'titaq igtigi mimajuinu. Milapegsultijig mimajuinu'g getana'titaq igtigi mimajuinu' tleiawultiliji igtig umutgiwow. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Maqamigew maja's'gt'tew ms't tami. Na pestmo'qonn aq gsnugowaqann i'tt'tal ms't tami. Musigisg'tug ugjiatal mesgi'gl metue'gl ta'n jipala'tita pugwenniji mimajuinu'. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ge's mu wegla telianugl, na ugsua'lugsitoqs'p aq emegweiugsitoqs'p. Ilsumugsitoqs'p a'sutuo'guomg aq pija'lugsitoqs'p laplusang. Amujpa neia'tugsitoqs'p nigantug elege'wijig aq g'pnno'lewa'jg muta getlams'tuioq ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ta'n tujiw ula tliatew gis tlimatoqs'p na gelu'lg agnutmaqan ta'n wejiaq Nisgameg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mut sespete'tmnew ta'n tli apoqonmasultitoqs'p ge's igalsultitoqs'p aq agnutmatoqs'p wegla mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ignmultoqs'p gelu'lgl glusuaqann aq ns'tuo'qon glaman ta'nig getan'sgig ma gisi apsgwa'guguegw gisna ma we'gwamulug ta'n telueioq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Gn'gi'guaq, wijig'tultioq, go'gumaq gisna gitapuaq gisa'lugsitoqs'p ugsua'lugsinew aq ta'sioq ne'po'qsitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pugwelgig mimajuinu'g masgelmugsitoqs'p muta getlams'tuioq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Angweiultoqs'p we'gaw anqo'tas'gt'tal te's'gl usapunn gun'jiwaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mut punita'tinew aq siaw ml'gigna'tigw, na tujiw ugs'ta'titoqs'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ta'n tujiw nmitoqs'p pugwelgig sma'gnisg gigto'qopugutmi'tij Selusalemg, gji'tutoqs'p gjigan apugjig suisga'tas'gt'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na tujiw ta'nig eimu'tijig Jutiaewa'gig amujpa lsumultitaq gm'tnigtug. Ta'nig eimu'tijig gjigang amujpa jiglsmultitaq. Ta'nig eimu'tijig gujmug gjigang mut pisgwita'new. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Etna negla na'gwegl ta'n tujiw Gjinisgam ugtapulata pugwenniji mimajuinu'. Tliatew muta Gjinisgam ugtwi'gatign telueg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ta'n tujiw wegla na'gwegl iga'qt'tew no'q mtue'tew ugjit e'pijig ta'n getu' un'janultijig aq e'pijig ta'n apje'ji'jultiliji mijua'ji'jg gegguna'tiji. Pugwelgt'tew ulmajo'qon ugs'tqamu muta Gjinisgam uggwaiugtuata mimajuinu' tleiawultiliji ula gjigan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ta'sijig ne'pa'taq ge's etl matnuj. Pugwelgig ugsuo'laten aq se'g lgimaten ta'n eimu'tijig gaqaisg mimajuinu'g tleiawultijig pilue'l umutgiwal ugs'tqamu. Mimajuinu'g ta'n mo Lesui'peulti'gw niganpugutmi'titaq Selusalem glapis ta'n tujiw ugml'gigno'timuow apajigsua'tuj.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nmituoqs'p wigue'gl tliatal na'gu'setigtug, tepgun'setigtug aq gloqowejigtug. Ugs'tqamug gaqaisg mimajuinu'g tleiawultijig pilue'l umutgiwal ewlita'sultitaq aq we'gwata'sultitaq. Ma gji'tu'ti'gw ta'n apoqonmuanew. Na jipaqita'taq ta'n tujiw nutua'tita gta'nugewei tgu'g ta'n ma'muni maqatgultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mimajuinu'g wigwia'titaq aq we'gwata'sultitaq ge's esgmatmi'tij ta'n goqwei wejgu'aq ugs'tqamug. Na na'gu'set ma liegw ta'n etl segewa'j. Na wijei tla'taqatitaq na tepgun'set aq gloqowejg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na tujiw ni'n ta'n mimajuinualsiap neia'sia's alugwigtug. No'q mawigna's aq no'q gepmite'lmites. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ta'n tujiw wegla tliaqal qamultigw aq musigisg'tug lapultigw muta Gjinisgam apugjig ugs'tawultew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Na tujiw Se'sus a'tugwaqan telimaji, “Angite'lmug na miti's ta'n teluisit pi'gmenaqsi aq igtigig miti'sg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ta'n tujiw nemioq na nipi'g poqji ne'ita'jig na geituoq nipg pem tepawiaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Lpa na wijei ta'n tujiw nmitutoqs'p wegla tliatal, gji'tutoqs'p Gjinisgam poqji ilgwenaji mimajuinu' ugs'tqamu. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Migwite'tmug ms't wegla ta'n wesgutmann na tliatal gesgmnaq mu nepu'ti'gw mimajuinu'g ta'n nige' mimajultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ta'n goqwe'l etegl musigisg'tug na gaqiatal aq elg ugs'tqamu gaqiatew gatu ntglusuaqanml iapjiw teliaqal.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Angweiasultigw. Mut pas'g tl'te'tmug mijjultimg aq mut sespete'tmnew ta'n tlo'ltitoqs'p muta na na'gweg ta'n pgisintes ap jaqali iga'qt'tew aq gilew ma gisgajo'ltiwoq ultesguinew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ms't mimajuinu'g paqalaiultitaq ugs'tqamug muta ula na'gweg tl jaqala's'gt'tew pa wijei aq loqte'gn jaqal goqqwa'latl wi'sisl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ni'n na mimajuinualsiap. Ta'n tujiw apaja'sia's apji gisgajo'ltigw aq a'sutma'tigw ugjit gugunmnew ml'gigno'ti aq saputita'toqs'p ta'n metue'gl getu' tliaqal.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Te'sigisg'g Se'sus gegina'muaji mimajuinu' gjia'sutuo'guomg. Te's wela'gw eliet gm'tnn ta'n tel wi'tut Olipet aq getgunit na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pugwelgig mimajuinu'g peita'jig gjia'sutuo'guomg te's egsitpu'g ugjit jigs'tuanew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na pem tepawa's'gl na'gwegl ta'n tujiw Lesui'paq malqotmi'tij pipnaqan ta'n mo apita'tas'gtnug. Ula pestie'umg tel wi'tas'g na Siawa'timgewei Pestie'umg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na tujiw niganpugultijig patlia'sg aq na nujigina'mua'tijig tplutaqan pewala'titl Se'susal ne'po'qsilin. Na gwilmi'tij ta'n tl gim ne'pa'taq muta jipaqite'lma'tiji na mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na tujiw Gjimn'tu wesgweiatl Suta Isgaliotal. Suta na Se'sus unaqapeml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Eliet ugjit maw agnutma'tinew niganpugultiliji patlia'sg aq ta'nig gjia'sutuo'guom ango'tmi'tij. Wesgutmi'tij ta'n Suta gis tla'tegetew ta'n tl ntuisgalatal Se'susal ugsua'lugsilin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Me' gatu wel'ta'suala'titl Sutaal aq tepluma'titl apangituanew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Wel'te'tg aq poqji angite'tg ta'n tl ntuisgalatal Se'susal ugjit gimi ugsua'lugsilital aq ma wen gji'tug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na na'gweg iga'q ta'n ms't mimajuinu'g malqotmi'titaq pipnaqan ta'n mu apita'tas'gtnug. Na tujiw wesgowa's'g na Siawa'timgewei Pestie'umg ta'n tujiw ne'pa'tij jijgluewji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Se'sus telimaji Pie'lal aq Sa'nal, “La'tigw aq gisgaja'tug Siawa'timgewei mijjuaqan ugjit ginu.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pipanima'titl, “Tami tet pewalieg gisgaja'tunen?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Telimji, “Ge's pem pisgwa'tioq gjigang na ji'nm ultesguatoqs'p. Pemapilatl samqwano'q lamaqan ugtlmaqaneg. Majulgwalug aq pisgwa'tigw na wen'ji'guomg ta'n tel pisgwa'j. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tlimug na ji'nm ta'n etli assusit wen'ji'guom, ‘Nujigina'muet petgimugsieg ugjit pipanimulinen, tami eteg ta'n negm aq unaqapemg tlatalultitaq na Siawa'timgewei Mijjuaqan?’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Na musga'tugsitoqs'p mesgi'g i' tlatalutimg ge'gwe'g. Na'te'l tli ilajugtatoqs'p wela'gewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Na apostale'wijig maja'tijig aq getloqo ms't goqwei eteg st'ge' ta'n telimut'pnig. Na tujiw gisgaja'tu'tij Siawa'timgewei wela'gewei. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ta'n tujiw ms't gisgatteg, Se'sus eliet aq epa'sit ugt'pung maw apostale'wijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na telimaji, “Mawi puatmap mawatalultitesnu Siawa'timgewei wela'gewei ge's mu welmaje'w. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Telimuloq, ma nugu ap malqotmu igtig Siawa'timgewei wela'gewei maw gilew glapis Gjinisgam ilgwenata ms't mimajuinu'. Na tujiw giasgiw gji'tutoqs'p ta'n goqwei teplutg tliatew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Na wesua'latl nqani'psmunn aq miwatmuatl Nisgaml. Telimaji unaqapemg, “Ugsua'lug ula aq ta'n te'sioq wet samqwoltigw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Telimuloq, ma nugu samqwaw moqopa'q glapis Gjinisgam pgisintew ugjit ilgwenanew ms't mimajuinu'.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pipnaqan wesua'toq aq miwatmuatl Gjinisgaml. Na tujiw nasgwa'toq aq ignmuaji unaqapemg. Teluet, “Ula na ntinin ta'n ignmuloq. Ula siaw tla'taqatigw ta'n goqwei musga'tuloq aq te's migwite'lmigw.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","G'satalultijig Se'sus ap wesgumaji na nqani'psmunn. Teluet, “Ula nqanipsmun neia'toq Gjinisgam ignmugsioq pilei teplumtimgewei. Pqoji tliatew ta'n tujiw nmal'tem guta's'gt'tew aq npma's gujjieweigtug ugjit apigsigtmulin gtlue'utiwal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Gatu ge' jigs'tigw, nat wen ntuisgalitew maw pultieg patawutigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ni'n na mimajuinualsiap aq npma's st'ge' ta'n Gjinisgam tel gisite'tg'p gatu mawi mtue'tew ugjit na ji'nm ta'n tel gisite'tg ntuisgalin.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Na apostale'wijig pipanimtultijig ta'n wenitew tla'tegetew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tel'gne'geg apostale'wijig gi'gaita'jig ta'n tegen me' gepmite'lmugsiss je mu igtigi. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Se'sus nestuimaji, “Elege'wijig geggunmi'tij ml'gigno'ti aq assuma'tiji na mimajuinu' ta'n mu Lesui'peultiligwi. Ugs'tqamug niganpugultijig tel wi'tujig, ‘mimajuinu'g witapua.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gatu gilew mu tlo'ltiwoq st'ge' negmow. Awna ta'n wen gilew pewalsit me' gepme'g je mu igtigi na amujpa elugowaji esgwia'tiliji. Ta'n wen gilew pewalsit niganpuguin amujpa tel lugwet st'ge' na lugowinu ta'n getu' apoqonmuaji igtigi. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wen me' espe'g, ta'n wen epa'sit mijjin gisna ta'n wen mijipjewei pejo'toq? Tel'ta'sioq ta'n wen epa'sit mijjin me' gepme'g je mu ta'n wen mijipjewei pejo'toq. Gatu weji pgisinap ugjit lugowinuin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Gilew gis wijitgweiwioq ta'n te's'g metue'gl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Wijei tli ignmultoqs'p assusultinew st'ge' nujj gis ignmuip assusin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mawpultitoqs'p ntp'tawutimg wa'so'q, Elg pmgopultitoqs'p elege'witewe'l mutputi'l aq assumatoqs'p Lesui'paq ta'n wetapegsultijig Je'gopo'q uggwisg na newtisgegsiliji je ta'pu piltu nemigsultiliji.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Se'sus telimatl Pie'lal, “Simon, jigs'tui. Na Gjimn'tu etawet ugtnu'gwalugsinew ta'n te'sioq. Getu' nigtuo'lugsioq, lpa wijei ta'n nuji iga'taqug tel tepgiso'toqol glumgl aq siguaqs'te'gnn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gatu a'sutmessewulap ugjit siawi gtlams'tasin ni'neg. Ta'n tujiw apaji lita'sualites, pewalul apoqonmuan gitapaq siawi gtlams'tasultinew ni'neg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pie'l telimatl, “Gjisaqamaw, gisgaje'i wije'ulin laplusang aq mawi npmn maw gi'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Gatu Se'sus telimatl, “Pie'l, telimul, gisgug gesgmnaq napew getu'g, gi'l si'st petgwasites.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na tujiw Se'sus pipanimaji unaqapemg, “Ta'n tujiw elgimuloqop na telimuloqop mo nespnanew gpo'jmuaq, mijipjewei mun'ti gisna piamiejig mg'sng, mo goqwei nuta'mawoqop?” Telima'titl, “Moqwa', lpa mo goqwei nuta'maweg'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Se'sus teluet, “Gatu nige', ta'n wen geggungl ugpo'jm gisna mijipjewei mun'ti nespntal. Ta'n wen mo tlawo'qomigw amujpa netuisgelatl uggotml ugjit pgwateluan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Telimuloq, Gjinisgam ugtwi'gatign telueg, ‘Mimajuinu'g tle'watal st'ge' lue'winu.’ Ula amujpa tliatew. Ta'n goqwei tla'litaq gis ewi'gas'g'p Gjinisgam ugtwi'gatignigtug aq nige' pem tliaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Unaqapemg telima'titl, “Gjisaqamaw geggung'tjig tapusijig tlawo'q.” Se'sus telimaji, “Tepiejig negla.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na tujiw Se'sus naqt'g gjigan aq eliet na gm'tn tel wi'tut Olipet st'ge' gaqaisg sipeliw tla'teget. Unaqapemg wijeiuji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ta'n tujiw na'te'l peita'jig, telimaji, “A'sutma'tigw ugjit Mn'tu mu gisa'lugsiwoq pata'taqatinew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Naqalaji unaqapemg aq eliet naqajijge'le'l. Na'te'l nutgul'pa'sit aq a'sutmat. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Gisiteget gi'l na nujj, mu ignmuiwn ulmaje'n. Gatu mut tla'tegew ta'n tel puatm, awna tla'tega ta'n tel puatmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ansale'wit wejiet wa'so'q aq apoqonmuatl ugjit ml'gigna'lin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Se'sus no'q ulmajita'sij me' aji a'sutmat glapis mal'tewitgniet. Tegniet maw mal'tew aq nitjaquntesgl maqamigeg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ta'n tujiw gaqi a'sutmat apaja'sit ta'n unaqapemg eimu'tiliji. Nep'tiliji, muta tetuji ulmajita'sultiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na telimaji, “Goqwei ugjit wet nep'tioq? Mn'jita'qw aq me' a'sutma'tigw ugjit mu pata'taqatinew.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Me' etlewistoq ta'n tujiw pugwenniji mimajuinu' peita'liji. Suta na Se'sus unaqapeml ilgwenaji. Na eliet Se'suseg ugjit usgaqalman. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Se'sus telimatl, “Ni'n na mimajuinualsiap. Getu' ugsaqanmin ugjit musga'lanew wegla mimajuinu'g ni'n na negm ta'n netuisgalit?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ta'siliji Se'sus unaqapemg gigjiw eimu'tiliji. Nemitu'tij ta'n getu' tliaq, pipanima'titl, “Gjisaqamaw, pewalieg matnanew aq e'wmanew tlawo'q?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na newte'jit taqamatl espe'g patlia's uglugowinuml aq mente'muatl inaqanei ugs'tuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Se'sus telimaji, “Punintultigw!” Na tujiw ugs'tuaqan apat nasa'tuaj aq smtug gisi npitmuaj. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Se'sus gelulaji na niganpugultiliji patlia'sg, a'sutuo'guomewei sma'gnisg aq igtigi niganpugultiliji muta peita'liji ugsua'lan. Na telimaji, “Nespnmoqol pugumaqann aq espo'qwas'gig. Tal gis peji ugsua'lioq st'ge' ni'n na gmutnes? ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Te'sigisg'g wijitgweiuloqop gjia'sutuo'guomg gatu mo wesua'liwoqop na'te'l. Gatu nige' gisi ignmugsioq ml'gigno'ti ugjit tla'taqatinew ta'n teli gsatmoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na wesua'la'titl Se'susal aq ela'la'titl espe'g patlia's wiguaq. Pie'l ugtejge'l majulgwalaji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nat wen pugtew gisitoqos iga'taqang na gigjiw espe'g patlia's wiguaq. Pie'l eliet na'te'l ta'n mimajuinu'g gigto'qopugultijig pugtewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ge's pemgopij gigjiw na pugtew na maljewe'j lugowinu'sgw nemiatl Pie'lal aq migwamatl. Na telimaji igtigi, “Ula ji'nm wijitgweiwapnn Se'susal.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pie'l petgwasit aq teluet, “E'pit, mo nenuaq negm!” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tel'gne'geg igtig elg migwite'lmatl aq telimatl, “Gi'l na majulgwalt ala ji'nm.” Pie'l teluet, “Ji'nm, ni'n mu na unaqapeml!” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ap tel'gne'ge'l igtig melgi tluet, “Na teliaq, ula ji'nm wijitgweiwapnn Se'susal muta negm na Galaliewa'j.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Gatu Pie'l teluet, “Ji'nm, mo geitu ta'n goqwei wesgutmn!” Na jiniw ge's etlewo'gwet, napew getu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Gjisaqamaw gigto'qopugua'sit aq angamatl Pie'lal. Na tujiw Pie'l migwite'tg ta'n gi's teluelipnn muta telimut'pnn, “Ge's mu napew getu'g egsitpu'g, si'st tluetes mo nenuiwn.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pie'l nige' tewiet aq gesimt'g muta no'q mesge'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na ji'nmug ta'n gegguna'titl Se'susal penoqite'lma'titl aq matta'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Oqonisgwepilmua'titl ugpugugul aq pipanima'titl, “Wen taqam'sg's? Tliminen.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aq siaw penoqite'lma'titl aq siawi almima'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ta'n tujiw gisapniaq, na niganpugultijig, niganpugultijig patlia'sg aq nujigina'mua'tijig tplutaqan mawita'jig aq Se'susal pegisula'titl ta'n etl mawia'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Pipanima'titl, “Ge' tliminen, gi'l na giasgiw Nujiugs'tawi'wet?” Se'sus teluet, “Pa na tlimuloq ma gtlams'tuiwoq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Lpa goqwei pipanimultoqs'p, ma goqwei tlimiwoq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ni'n na mimajuinualsiap aq nige' weja'tegemg pmgopites Gjinisgam ta'n mawignat ugtinaqanmg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Na pugwelgig pipanima'titl, “Na to'q, gi'l na Gjinisgam Uggwisl?” Telimaji, “Ms't gilew telueioq ni'n na negm.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na tujiw teluejig, “Mo nugu tal wegaqqwig pilue'g el wi'tmasultijig getu' nutmueg ta'n igtigig teluejig muta gis nutaqatt ta'n teluet.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Na tujiw ms't maita'jig aq Se'susal ela'la'titl ugjit qamin nigantug Lo'mewa'j g'pnno'lewit teluisit Pilot, ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na poqji elsutmua'titl aq teluejig, “Nutaqatt'p ula ji'nm opl gina'muapni mimajuinu' tleiawultiliji nm'tginen. Na telimapni, ‘Mut ignmuanew suliewei na elege'wit.’ Teluet negm na Lo'mewei elege'wit ta'n teluisit Nujiugs'tawi'wet.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilot pipanimatl, “Gi'l na Lesui'paq ugtelege'witemual?” Se'sus telimatl, “Na teliaq teluen.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na tujiw Pilot telimaji niganpugultiliji patlia'sg aq mimajuinu'g ta'n eimu'tiliji na'te'l, “Mo geitu goqwei amsalteg ula ji'nm. Ma gisi ilsumaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Gatu patlia'sg aq mimajuinu'g ma'munsaiwa'titl Pilotal, “Ilsum Se'sus ta'n goqwei gegina'muaj mimajuinu' aq ta'n gisa'laji matntultinew. Poqji gina'muep Galaliewa'gig aq gigto'qwa'sip ta'n telgi'g Jutiaewa'gig aq nige' pegising tet ugjit gina'muen.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ta'n tujiw Pilot nutuaj ta'n goqwei telueliji, pipanimaji, “Ula ji'nm na Galaliewa'juit?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ta'n tujiw geitoq Se'sus tleiawit ta'n Elot etl niganpuguij, na elgimatl Se'susal Eloteg, muta Elot etl mittugwet Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Elot no'q wel'ta'sit ta'n tujiw nemiaj Se'susal. Nutg'p ta'n tela'tegelipnn aq getu' nmiapnn Se'susal gi's sa'q. Getu' nmiatl npilan nat wenn gisna tla'tegelin paqalaiwaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Glaman Elot pipanimatl pugwelgl ta'n goqwe'l gatu Se'sus mo goqwei teluegw. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Na niganpugultijig patlia'sg aq ta'ni nujigina'mua'tijig tplutaqan gaqamultijig aq gesigawi elsutmua'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Elot aq ugsma'gnismg naso'tula'titl Se'susal elege'wamug aligew, penoqite'lma'titl aq emegwei'wa'titl. Na tujiw Elot apatgimatl Piloteg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilot aq Elot masgeltipnig gatu nige' gisaqanmajig witapewijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilot wigumaji niganpugultiliji patlia'sg, igtigi niganpugultiliji aq igtigi mimajuinu. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Telimaji, “Pegisituioq ula ji'nm aq telueioq opl gina'muaji mimajuinu'. Gigji pipanimg'p ge's gaqamultioq tet aq mo eigtnug goqwei ta'n opla'teget aq mo telianug ta'n goqwei elsutmua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Elot mo geitug goqwei opla'tegelin muta apatgimapnn nineneg. Mo goqwei eigtnug ta'n amsalteg we'gaw ugjit ne'po'qsin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Gatu gisa'la's wisqapaqtoqsin aq na tujiw iga'la's.”  ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Te's Siawa'timgewei na'gweg Pilot apjiw pipanimut ugjit iga'lan newte'jilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Gatu ms't sesgu'tijig, “Ne'po'q ula ji'nm! Laplusang tualqa'l Palapas!” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Palapas weji pija'lut laplusang muta pegwatoqop matnaqqewaqan gjigang aq ilsutmut'p muta ne'pa'lapnn mimajuinu'l. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilot getu' iga'latl Se'susal glaman gelulaji mimajuinu ap. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Awna asitepugua'titl, “Amujpa gujjiewto't! Gujjiewta'nej!” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilot gelulaji mimajuinu' si'stewei ap. Pipanimaji, “Tali opla'tegep? Mo geitu ta'n goqwei opla'toqop. Mo te'pmug npuaqan. Gisa'la's wisqapaqtoqsin aq iga'la's.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Gatu mimajuinu'g siaw ml'gi sesgu'tijig, “Amujpa gujjiewto't!” Na tujiw mesnmi'tij ta'n tel puatmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilot ignmuaji ta'n goqwei pipanigesultiliji, na ilsumatl Se'susal ne'po'qsilin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Na tujiw iga'latl na ji'nmul ta'n pija'lut'p muta gisa'toqop matnaqqewaqan aq ne'pa'taqan. Na ilsumatl Se'susal ugjit gujjiewto'qslin st'ge' ta'n mimajuinu'g tel puatmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ge's sma'gnisg ejigla'la'titl Se'susal gjigang, na a'sugua'titl ji'nmul ta'n wejgu'elitl. Ula ji'nm teluisit Simon aq tleiawit Sailin. Na sma'gnisg goqqwa'la'titl aq gisa'la'titl pemapilmlitl gujjiewei ugtejg Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pugwelgig mimajuinu'g pemulgwala'titl Se'susal. Eimu'tijig e'pijig pemulgwala'tij aq nesp'temultijig. Wel maita'sultijig ugjit Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Se'sus naqa'sit aq telimaji, “E'pijig, tleiawultioq Selusalemg, mut atgitemultinew ugjit ni'n. Atgitemultigw ugjit gilew aq gn'januaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Wejgu'aqal na'gwegl ta'n tujiw mimajuinu'g tluetaq, ‘Tetuji ulo'ltijig e'pijig ta'nig menaq un'janulti'gw, gisna menaq angweiwa'tigwi mijua'ji'jg gisna menaq wet sma'tigwi ugpusgunuaq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Na tujiw mimajuinu'g tluetaq, ‘Pajiji gitnm'titesnu. Uliatew gm'tng nisa'lugwia'tij ta'n eimu'ti'gw aq soqoqamigegl oqonitgwetoqsi'gw.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pa na mimajuinu'g tla'li'tij ni'n ta'n mo goqwei opla'tu, tala'lultaq gilew ta'n opla'taqatioq?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tapusijig ji'nmug, na gitg gmutnesg, pem gl'taqana'tiji ugjit ne'po'qsilin maw Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ta'n tujiw peita'tij ge'gutnug tel wi'tmi'tij, “Waqan'tewatpat,” na etl gujjiewto't Se'sus maw tapusijig gmutnesg, newte'jit ugtinaqanmg aq igtig ugpatatujmg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Se'sus teluet, “Gisiteget, gi'l na nujj, apigsigtug wegla mimajuinu'g muta mo geitu'ti'gw ta'n tela'taqati'tij.” Na sma'gnisg elegetua'titl Se'susal utapsun toqo pas'g tepitultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na mimajuinu'g angaptmi'tij ms't ta'n teliaq ge's Lesui'paq niganpugultijig maligima'titl Se'susal. Teluejig, “Gisi ugs'tawiapni igtigi. Pa na negmewiss na Nujiugs'tawi'wet ta'n Gjinisgaml megnpnn, ugs'tawi'sij.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sma'gnisg na elg penoqite'lma'titl Se'susal. Ela'tua'tij anawtigewei moqopa'q aq pewala'titl samqwalin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Telima'titl, “Ugs'tawi'si, pa na elege'witewi's'p ugjit Lesui'paq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na g'p'taq ta'n Se'sus gaqapijing ewi'gas'gl wegla glusuaqann, “Lesui'paq ugtelege'witemual.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Newte'jit na gmutnesg ta'n gmetug gaqapijing anmimatl Se'susal. Telimatl, “Pa na gi'l na Nujiugs'tawi'wet, ugs'tawi'si aq maw ninen?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Gatu na igtig gmutnes mo gesatmug ta'n gis tluelitl, aq telimatl, “Mu jipalawt Gjinisgam. Wijei telsumulg'p st'ge' negm. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tetapusutasi'gw, muta mesnmu'g ta'n tel te'pmu'g, gatu negm mo goqwei opla'tugup.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na tujiw telimatl Se'susal, “Se'sus, migwite'lmites, ta'n tujiw pgisin gtelege'wa'gimg.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Se'sus telimatl, “Teplumul, gisgug wijitgweiwites wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Na panaemg mewlia'gweg, oqonitpaqiaq ta'n telgi'g umutgiwaq glapis si'st ajiej. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ge's soqqwat, na mesgi'g elaqpilaqan tmsaqign ta'n gaqapitg gjia'sutuo'guomg pasgina's'g g'p'taq glapis epune'g. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Se'sus gesigawwet aq teluet, “Gisiteget gi'l na nujj, njijaqamij iga'l'g gpitng.” Ula na gis tluej, na nepg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ta'n tujiw niganpuguit sma'gnis nemitoq ta'n gis tliaq, gepmite'lmatl Gjinisgaml. Teluet, “Getloqo na getlamiesnaq ji'nmaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pugwelgig mimajuinu'g mawiepnig gatu nige' apajinmita'jig ta'n tujiw gis nemitu'tij ta'n goqwei gis tliaq. Ugpusgunual pem matte'mi'titl muta ulmajita'sultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gatu Se'sus witapa aq witapesgwa ta'n peji wije'wa'tipnn weja'tegemg Galaliewa'gig, gmetug gaqamultijig. Esgmatmi'tij nmituanew ta'n goqwei tliatew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Na eig na'te'l ji'nm ta'n teluisit So'sep. Tleiawit Lesui'pewei utan teluisig Alimatia. Gelu'sit aq ms't wenn gepmite'lmatl. Na niganpugutuaji ta'siliji Lesui'pa. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mo wel'te'tmug'p ta'n telsutmi'tip ugjit Se'susal gujjiewto'qslin. Pewalatl Gjinisgaml pgisinnin aq ilgwenanew ms't mimajuinu'g ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Eliet Piloteg aq pipanigesit gis utqutalan Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nisa'latl Se'susal gujjieweigtug aq oqonisgwa'latl atla'wegnigtug. Iga'latl elmalqeigtug ta'n gun'tew pitu' mulqata's'g'p. Na utqutaqan me' mnaq e'wa's'gtnug. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na na'gweg ta'n ilajugtmi'tij atlasmutigisg'g gaqiaq aq atlasmutigisg'g poqtamgiaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na e'pijig ta'n peji wije'wa'tipnn Se'susal weja'tegemg Galaliewa'gig wije'wa'titl So'sepal utqutaqane'gatig aq angama'titl ge's Se'susal utqutalut. ");
INSERT INTO micMIQNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Na tujiw enmita'jig aq gisgaja'tu'titl weljema'gewe'l aq welima'qal mime'l ugjit mima'lanew Se'susal. Atlasmultijig atlasmutigisgug st'ge' ta'n ewi'gas'g Nisgamewei tplutaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aqan'tie'umg no'q gesi egsitpu'g e'pijig el'ta'jig npuinue'gatig. Nespnmi'titl weljema'gewe'l ta'n gisgaja'tu'tipnn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nemitu'tij na gun'tew ejigl te't'pja'tas'g na ta'n elmalqei gep'joqwa's'g'p. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Glaman pisgwita'jig gatu mo we'jia'tigul Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mo geitu'ti'gw ta'n gis tliaq. Na jiniw tapusijig ji'nmug gesi wape'gna'qig gaqamijig gmetug negmoweg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Me' gatu na e'pijig gesigaw jipaqita'jig aq nutgulpita'jig. Na ji'nmug telimgwi'tiji, “Goqwei ugjit utqutaqane'gatig al gwiluoq negm ta'n mimajit? ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mo eimug tet. Gis minunsit. Migwite'tmug ta'n telimugsioqop ge's me' eimu'tioqop Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Teluep, ‘Ni'n na mimajuinualsiap aq amujpa ignmueta'sia's ugjit pata'tegewinu'g gujjiewte'ite'n gatu minunsites si'stewei na'gweg.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na tujiw e'pijig migwite'tmua'titl ugglusuaqanml. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Apaita'jig gjigang aq telima'tiji na newtisgegsiliji je newt apostale'wiliji aq igtigi Se'sus unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Negla e'pijig na Mal Matle'n, Joana, Mali ta'n uggwisl teluisilitl Ji'mej. Negmow aq igtigig e'pijig telima'tiji ms't apostale'wiliji ta'n goqwe'l gi's nemitu'tipnn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Gatu apostale'wijig tel'ta'sultijig e'piliji papewistultiliji aq mo getlams'tua'tigwi. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Na tujiw Pie'l maja'sit aq eliet na npuinue'gatig. Golomgwa'sit aq pisgwapa'sit gatu mo wenn nemiagul. Pas'g nemitoq utqutamgewe'l aligal. Paqalaig, enmiet wiguaq aq angite'tg ta'n gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na wijei na'gweg tapusiliji Se'sus unaqapemg ela'tiliji na utanji'j teluisig Eme'us. Eteg na'tami newtisga'qal je newt gilam'tl weja'tegemg Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na etli agnutmajig ta'n goqwe'l gis tliaqal Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ge's pem agnutma'tij, na Se'sus etepnaji aq na tujiw pem wije'waji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Na nemia'titl pas'g mu nenua'tigul. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Se'sus pipanimaji, “Goqwei wesgutmoq ge's pema'tioq?” Na tapusijig naqapugua'tijig aq no'q ewlapewijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na newte'jit teluisit Gliopas telimatl, “Etug gi'l pas'g emittugwe'winu Selusalemg aq mu eimu't'p ta'n wegla gis tliaqal na enmigiaspiaqal na'gwegl?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Se'sus pipanimaji, “U't ta taliaq?” Telima'titl, “Wesgutmeg ta'n goqwe'l gis tliaqal ugjit na Se'suso'q, Nasaletg tleiawipnaq. Ula ji'nmaq na niganigjitegewinuaq. Melgignaqal ugglusuaqanml aq mesgi'gl lugowaqann elugwatg'pnn. Tetapua'lapnn Gjinisgaml. Pugwenniji mimajuinu'g wel'te'tmua'tipnn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na niganpugultijig patlia'sg aq nuji ilsutaqatijig ugjit Lesui'paq ilsuma'tipnn ugjit ne'po'qsilin aq na tujiw gujjiewto't'pnaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na elita'sualg'tt'p negm na newte'jisoq ta'n gisi ugs'tawiata Lesui'paq. Na nige' gisi nsuguna'q ula gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Alt e'pijig, ta'nig getlams'tua'titl Se'susal, paqalaiugsieg'pnig. Na gisapniaq, el'ta'pnig ta'n elisnnipnn, ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","gatu mo tami we'jia'tigupnn. Na apaja'tipnig ta'n eimu'tieg aq telimugsieg'pnig, ‘Ta'n elisinnaq nemi'g'tt'pnig ansale'wijig ta'n telimugsiegig Se'sus mimajit.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na ta'siliji Se'sus unaqapemg el'ta'lipni na'te'l. Tel nmitu'tip st'ge' ta'n e'pijig teluepnig. Telteg gatu mo wen nemiagupnn Se'susal.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na tujiw Se'sus telimaji, “Ewle'jioq aq mo getlams'tmuoq ta'n gis tliaq. Na tel gesguggl ggamlamunual, mu gisi ns'tmu'tiwoq ta'n niganigjitegewinugi'g gis tluetipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Getloqo Nujiugs'tawi'wet amujpa ma'muni ulmaje'g aq na tujiw pisgwa't wa'so'q ta'n etl gepmite'lmuj.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na tujiw Se'sus gegnua'tuaji ta'n goqwe'l ewi'gas'gl Gjinisgam ugtwi'gatigng ugjit ta'n tela'luj. Gegnua'tuaji ms't goqwe'l ta'n Mowiso'q aq niganigjitegewinugi'g ewi'gmi'tipnn ugjit ta'n tela'luj. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na glapis pem tepawita'tijig na utanji'j ta'n tapusijig pem la'tijig, na tel'te'lma'titl Se'susal siawa'silin. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Toqo munsaiwa'titl naqa'silin. Telima'titl, “Wijitgweiwinen aq tli gt'guni tet. Geget wela'gw aq poqji oqonitpaqiaq.” Na glaman siaw wije'waji aq pisgwa't wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ta'n tujiw na wela'gewei gisgatteg, pemgopita'jig aq Se'sus wesua'toq pipnaqan aq miwatmuatl Nisgaml. Temina'toq pipnaqan aq ignmuaji. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Na tujiw nenua'titl, gatu smtug Se'susal etli gs'ga'silitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Telimtijig, “A' na migwite'te'n ta'n pema'tieg'p awtigtug teli ulgwijinu'gup. Etl gelulugsi'gup aq gegnua'tugsi'gup Gjinisgam ugtwi'gatign.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na smtug apsgwa'tijig Selusalemg naji agnutmua'tiji newtisgegsiliji je newt Se'sus unaqapemg aq igtigi mimajuinu' ta'ni etl mawia'tiliji maw Se'sus unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ta'n tujiw pisgwa'tij, telimujig, “Gjisaqamaw gis minunsit. Simon gi's nemiatl.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na tapusijig agnutmi'tij ta'n goqwei teliaqap awtigtug aq ta'n tel nenua'tipnn Se'susal ge's temina'tuliteg pipnaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ge's wegla etl agnutmi'tij, jiniw Se'sus neia'sit aq gaqamit maw negmow. Telimaji, “Gjinisgam gis ignmugsioq wantaqo'ti ggamlamunuaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","No'q paqalaiultijig aq jipaqita'jig muta tel'ta'sultijig sg'te'gmujl nemia'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pipanimaji, “Goqwei ugjit welmajita'sultioq? Goqwei ugjit weji megtmoq? ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Angaptmug npitnn aq ngatl aq nmitutoqs'p ni'n na. Sama'ligw aq gji'toqs'p muta sg'te'gmuj mo wa'qigw gisna waqan'tewigw st'ge' ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ge's ula etl tlimaji, neia'tuaji ugpitnn aq uggwatl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Paqalaiultijig aq elt wel'ta'sultijig gatu me' megtmi'tij na glaman Se'sus pipanimaji, “Geggunmoq goqwei mijjuaqan tet?” ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ignmua'titl mussew nme'juei ta'n gissilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Malqotg ge's etli angama'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na tujiw telimaji, “Ge's wijitgweiuloqop, na gis nigan tlimuloqop wegla ta'n gis tliaq. Mowiso'q, niganigjitegewinugi'g aq negmow ta'n gis wi'gmi'tip na gtapegiaqanei wi'gatign gis wi'gmi'tipnn wegla ta'n tela'limg'p ni'n aq ms't giasgiw wet tliaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Na tujiw gisa'laji gisi ns'tmnew ta'n goqwe'l ewi'gas'gl Gjinisgam ugtwi'gatigng. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Na telimaji, “Ula na tel wi'gas'g Gjinisgam ugtwi'gatigng, ‘Na Nujiugs'tawi'wet amujpa ulmaje'tew aq np'tew. Na utqutalutew aq ugji minunsitew nesuguna'q iga'qt'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ignmuata unaqapemg assusuti ugjit 'lta'new ta'n telgi'g ugs'tqamug aq tlimanew ms't mimajuinu' na gelu'lg agnutmaqan. Ula agnutmaqan na Gjinisgam tli apigsigtuata mimajuinu' ta'n gawasgita'sultiliji aq jiglita'tiliji lue'utigtug. Tmg ula agnutmaqan amujpa agnutma'tas'g Selusalemg.’ ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gilew gi's nemituoqopnn ta'n tliaqapnn. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Telimuloq elgitmultoqs'p na Wejuli Nisgam ta'n nujj teplumugsioqop ignmugsinew. Gatu amujpa pe'l esgma'tioq ula gjigang glapis ignmultoqs'p ula ml'gigno'ti ta'n wejiaq wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na tujiw naqtmu'tijig na gjigang, Se'sus ela'laji unaqapemg tepaw Pettani. Na'te'l wenaqa'toqol ugpitnn aq a'sutmessewaji unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ge's etli a'sutmessewaji ejigla'lut aq wenaqa'lut wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na unaqapemg apaita'jig Selusalemg. Me' gatu tetuji ulgwijultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Giwnaqa wesgowita'jig gjia'sutuo'guomg. Miwa'la'titl Gjinisgaml aq emtoqwala'titl ugjit ms't goqwei gis tliaq. Na ms't.");
INSERT INTO micMIQNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gesgmnaq ugs'tqamu gisita's'gtnugweg, negm ta'n telui'tut na Gjiglusuaqan gis eig'p, na Westaulg. Toqqwatg'pnig Gjinisgaml aq negm Gjinisgamewit. Na. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mujga mawi amgweseweieg, Westaulg ta'n telui'tut na Gjiglusuaqan, toqqwatg'pnig Gjinisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gisitoqop 'ms't goqwei negm. Mo na goqwei gisita's'gtnuisoq mo negm gisitugs'pn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Etna na negm ta'n telui'tut na Gjiglusuaqan, gisa'toqop 'ms't goqwei mimajigtn aq gisi ignmuataq mimajuinu'g iapjiwewei mimajuaqan. Negmow ta'n gisi msnmi'tij ula iapjiwewei mimajuaqan guguntaq Gjinisgam Ugtwasetegm ilgwengutaq pa na wijei aq waseteg oqonitpa'qigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ula Waseteg siaw elaseg oqonitpa'qigtug aq na oqonitpa'q ma gisi nqa'suatug gatu gis siaw wasetetew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na ta'n tujiw tetaputesg iga'q, Gjinisgam petgimapnn ugtagnutmewinuml na ji'nm teluisit Sa'n. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pegising ugjit tliman mimajuinu'g ugjit na waseteg, glaman 'ms't wen nuttaq na agnutmaqan aq 'gtlams'ttaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mu na negm na ula waseteg, negm pas'g pegising tliman mimajuinu'g ugjit na waseteg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Westaulg na ula teliaqewei waseteg ta'n wejiaq wa'so'q aq elaseg mimajuinu'g ula ugs'tqamug. Ilgwenaji mimajuinu'g glaman weji gji'tutaq teliaqewei ugjit Gjinisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","We'gaw negm ta'n telui'tut na Gjiglusuaqan gisitoqop ugs'tqamu, na ugs'tqamugewaq mo na nenua'ti'gw ta'n tujiw pegisinniteg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Je tlia ugmaqamigemg elieteg aq ugtmimajuinumg, na Lesui'paq, mo menuege'tigupnn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gatu na ta'n wenig menuege'titl aq getlams'tua'titl ignmuaji ugjit Gjinisgam un'janin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ta'nig getlams'tasulti'tij minui ugs'tqamultijig, mu 'st'ge' ginu ta'n teli ugs'tqamulti'gw gn'gi'guinaq. Ta'n tel minui ugs'tqamultijig mo ji'nmul ta'n ujjult'pn gatu Gjinisgam negm ujjl. Gjinisgam gisa'laji un'janin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Etna na negm ta'n telui'tut na Gjiglusuaqan mimajuinualsip aq eig'p ula ugs'tqamu ta'n wigulti'gw ta'sipunqeg. Apjiw uleiugsi'gw aq teliaqewei telimugsi'gw ugjit Nisgaml. Ta'sieg nemitueg'p uggepmite'lgaqanm aq ta'n paqtateg. Ula gepmitelgaqanm mesng'p muta pas'g negm na Wegwisit Nisgam newgte'jilitl un'jann. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Na Sa'n na wesgumatl. Gesigawwet, “Etna na ula negm ta'n wesgumg'p ta'n tujiw telueianeg, ‘Ugtejg ni'neg 'pgisintew ji'nm. Me' espe'g aq ni'n muta igan i'g'p gesgmnaq ni'n ugs'tqamuiwaneg. Aq nige' neialsit. Se'sus na.’ ” Na teluet Sa'n ugjit Se'sus. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na 'ms't welapetmu'g ta'n pugwelgl goqwe'l ignmugsi'gw gelu'lgl aq tetuji pugwelgt'tal muta maw muni gsalugsi'gw Se'sus. Ma gis maw gitmun aq ma gaqianugl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gjinisgam ignmugsi'gup mimajuinu'g na 'tplutaqan wet sapu tl lugwet Mowiso'q aq amujpa gaq jigs'tmugul gisna ugtap'titesnu. Gatu ignmugsi'gw ugt'gsaltuaqanm aq apigsigtugsi'gw wet sapu tl lugwet Se'sugulial aq gegina'mugsi'gw teliaqewei. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Menaq wen nemiagul Nisgaml gatu newgte'jilitl un'jann na uggwisl nemitl. Negm Nisgamewit aq e'taqatijig ujjl aq telimugsi'gup ugjit negm. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na tujiw na Lesui'paq iganpugultijig ta'nig eimu'tijig Selusalemg elgima'tiji patlia'sg aq alt ta'nig apoqonmua'tiji 'gjia'sutuo'guomg na Sa'neg, ugjit pipanimanew, “Wenin ta gi'l? Tali ugsualsin Nujiugs'tawi'wetewin, ta'n Gjinisgam petgimatal ugjit ilgwenan ugmimajuinumg?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Sa'n na megt'g aq angam tlimaji, “Moqwa', mu na ni'n Nujiugs'tawi'wetewiw.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pipanima'titl, “Gatu gi'l wenin? Gi'l ta iganigjitegewinu Ilaija?” Asitemaji, “Moqwa' mu na ni'n.” Pipanima'titl, “Gi'l ta iganigjitegewinu ta'n Mowiso'q wesgutg'p?” Asitemaji, “Moqwa'.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Telima'titl, “Tlimieg ta'n wenin. Amujpa na apaja'tueg glusuaqan ugjit ta'n wenig petgimugsieg'pnig. Gatu gi'l taltelsin?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sa'n na teli asitemaji, “Teli ugsualsi ni'n na ta'n wen gesigawewistoq paqtaqamigtug. ‘Gjisaqamaw wejgu'et. 'Ms't ta'n te'sioq gisgajo'ltigw!’ Etna na ula ta'n iganigjitegewinuo'q Aiseiao'q teluepnaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na tujiw negmow ta'nig elgimut'pnig Palasiaq ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","pipanima'titl, “Gatu gi'l mo Nujiugs'tawi'wetewiwn gisna Ilaija gisna iganigjitegewinu ta'n Mowiso'q wesgutg'p, goqwei wet sign'tuen?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Sa'n asitemaji, “Samqwan e'wm ta'n tel sign'tuei. Gatu mawpugua'tioq na newgte'jit ta'n gilew mo nenuawoq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nige' toqosip poqji gji'jioq. Negm no'q espe'g aq ni'n. Mo tepawgtiw je we'gaw oqolomgwaqwa'sin aq apgwa'tuan umugsnapi'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na ula 'ms't teliaqap na gutan Pettani ta'n eteg qame'g na sipu Jol'tan, ugjipenug. Sa'n etl sign'tuet na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na wapgeg Sa'n nemiatl Se'susal wejgu'elitl negmeg aq teluet, “Ge' lapita'gw, ula na Gjinisgam ugjijgluewji'jml ta'n ejigla'toqol mimajuinu'g ugtlue'utiwal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Etna na ula negm wesgumg'p ta'n tujiw telueianeg, ‘Ji'nm ugji pgisintew, me' espe'g aq ni'n muta igan i'g'p gesgmnaq ni'n ugs'tqamuiwaneg.’ ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mo gejiaqap ta'n wenitew. Gatu pegisinap ugjit nut sign'tuan samqwanigtug glaman 'ms't Lesui'paq gisi gji'jiataq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Na tujiw Sa'n telimaji, “Nemi'g'p Wejuli Nisgam nisa'sit pa wijei aq ples wejiet wa'so'q aq eig Se'suseg Westaulgeg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Gesgmnaq telianugweg mu nenuaqap gatu Gjinisgam ta'n petgimip ugjit sign'tuan samqwanigtug telimip, ‘Gi'l nmiates Wejuli Nisgam nisa'sitew aq i'ttew na ji'nmul. Etna na negm ta'n sign'tuetew e'watal Wejuli Nisgaml.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Sa'n siaw tluet, “Ni'n nemituap tlian aq nige' telimuloq na negm na Gjinisgam uggwisl.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na wapgeg Sa'n ap eig'p na'te'l na sipug Jol'tan ugjipenug maw tapusiliji unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ta'n tujiw nemiateg Se'susal pemielij, teluet, “Ula na Gjinisgam ugjijgluewji'jml.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tapusiliji unaqapemg nuta'ti'titeg teluet ula aq wije'wa'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Se'sus gawasg'pugua'sit aq nemiaji pem majulgwalji aq pipanimaji, “Goqwei puatmoq?” Teli asitema'titl, “Tami wigin, Lapai?” (Na glusuaqan Lapai telueg, “Nujigina'muet.”) ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Asitemaji, “Wije'wi aq nat nmitug.” (Na'tami ne'w ajiet gis mewlia'gweg.) Na wije'wa'titl aq nemitu'titl ta'n wigilij aq siaw wijitgweiwa'titl esgwiaq na'gweg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Newgte'jit na ula ji'nmug teluisit Antle', Simon Pie'l wijigatijig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Smtug Antle' gwiluatl wijigumatl Simon Pie'lal aq telimatl, “Gisi weltesgaqat na Nujiugs'tawi'wet ta'n Gjinisgam megnatl ilgwenan ugtmimajuinumg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Na tujiw pegisulatl Simonal Se'suseg. Se'sus angamatl aq teluet, “Gi'l na Simon, Sa'n gujj, tlitulten ‘Sipas’.” (Na ula wisun pa wijei aq Pie'l, telueg, “gun'tew.”) ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Na wapg Se'sus gisita'sit lien Galaliewa'gig. Weltesguatl na Pilipal aq telimatl, “Jugu'a, wije'wi.” ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Na Pilip tleiawit na gutan Petse'ta ta'n Antle' aq Pie'l tleiawijig.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na tujiw Pilip gwiluatl Natanielal aq telimatl, “We'jig'tt'p na Nujiugs'tawi'wet ta'n Mowis ewi'gig'p na wi'gatign 'tplutaqanei aq na ta'nig iganigjitegewinugi'g ewi'gmi'tip. Negm na Se'sus, So'sepal ujjl, Nasaletgewa'j.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel na teli asita'puguet, “Nat wen etug ugjietew Nasaletg ta'n gelu'sit?” Pilip asitematl, “Wije'wi aq naji angam.” Na tujiw wije'watl Pilipal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ta'n tujiw Se'sus nemiateg Natanielal wejgu'elitl negmeg, na ula teluet ugjit negm, “Ula wejgu'et tetapu'et Isle'lewa'j ta'n sangewite'lmut. Getmite'tg 'ms't goqwei. Gegnu pmiet ji'nm.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel na pipanimatl, “Tal gisi nenuin?” Se'sus asitematl, “Nemu'lap ta'n tujiw eimneg pi'gmenaqsigtug gesgmnaq Pilip wigumulugweg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel asitematl, “Nujigina'muet, gi'l na Gjinisgam uggwisl, na Isle'laq ugtelege'witemual.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Se'sus teluet, “Etugjel weji gtlams'tmn muta pas'g gis tlimul nemu'lap ta'n tujiw eimneg na pi'gmenaqsigtug? Teliaq na telimul, me' 'ms'gi'gt'tew ta'n goqwei nemitun je mu ula.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na tujiw telimaji, “Telimuloq, nmittoqs'p wa'so'q pana's'g aq Gjinisgam ugtansale'witemg toqjuitaliji aq wejgu nisita'liji ni'neg ta'n mimajuinualsiap. Teliaq na telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Na gis tapuguna'gweg, malie'uti wesgowa's'g gutanji'j teluisig, Gena, Galaliewa'gig aq Se'sus uggwitl eimlitl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Aq Se'sus maw unaqapemg wigumut'pnig na malie'uti. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na ta'n tujiw moqopa'q gaq samqwolti'tij, na toqotesip Se'sus uggwitl telimtl, “Ga'qanma'titeg na moqopa'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Se'sus na teli asitematl, “Giju', me' menaq tetaputestnug ugjit mesgi'gl goqwe'l tla'tegen gatu mut sespete'tmu.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mali telimaji na lugowinu'g, “Tla'taqatigw ta'n Se'sus telimugsioq!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na na'te'l epultijig asugom te'sijig samqwano'q gun'teweie'g. Te's newgte'jit samqwano'q tel pisoqol aqataig malige'w. Wegla samqwano'q e'wmi'tij ta'n tel gisapa'tu'titl ugpitnual mijjulti'tij aq gesispa'laji aq ta'n pas'g goqwei ta'n telteg Lesui'pewei 'tplutaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Na tujiw Se'sus telimaji lugowinu'g, “Ugjupego'lug negla samqwano'q samqwan.” Na tujiw tetpepego'la'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Na toqo tujiw Se'sus telimaji, “Nige' 'nqana'mug samqwan aq la'tug na ji'nm ta'n iganpuguit malie'waqan.” Toqo negmow ela'tua'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Na iganpuguit wett'g ula samqwan ta'n gis gawasga'tas'g moqopa'qigtug. Mo geitug's ta'n ula moqopa'q wejiaq (pas'g na lugowinu'g ta'n gisi nqanigmi'tij na samqwan, na negmow geitu'tij). Na tujiw iganpuguit wigumatl na ji'nmul ta'n atel gis malie'wilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Telimatl, “Tmg 'ms't wen gis lugoug mujgajewei moqopa'q toqo ta'n tujiw ul samqwolti'tij lugoug anawgtig moqopa'q. Gatu geggunmn gi'l mujgajewei moqopa'q glapis ugtejgewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Se'sus gaqa lugwatg amgwesewei ta'n mawi ms'gi'g 'lgowaqan na gutan Gena, Galaliewa'gig. Na na'te'l musga'toq ugml'gigno'tim aq unaqapemg getlams'tua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Na malie'waqan gaqiaq, Se'sus aq uggwitl, ugjignamg, aq unaqapemg el'ta'jig Gapelniamg aq eimu'tijig na'te'l ta'suguna'q. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na tujiw Se'sus eliet Selusalemg muta pem gigja's'g Lesui'paq ugpestiewtimuow teluisig, “Siawa'timgewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na'te'l 'gjia'sutuo'guomg nemiaji ji'nmug etli ntuisgelatiji wen'jitia'mug, jijgluewji'jg, aq plesg, aq maw nut sa'se'wa'taqatijig suliewei, pemgopultijig ugpatautimuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Se'sus na pugumaqan el'toq apapiei aq ejigltesguaji 'ms't wi'sisg 'gjia'sutuo'guomg, gitg jijgluewji'jg aq wen'jitia'mug. Aputasgate'gl ugpatautimual aq ugsulieweimual se'sa'tegl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aq telimaji ji'nmug etli ntuisga'tiliji plesg, “Tuo'lug negla. Mut nujj wiguow tli e'wmuanew 'st'ge' etli ntuisga'timg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na tujiw unaqapemg migwite'tmi'tij ta'n sa'q tel wi'gas'g'pneg Gjinisgam ugtwi'gatign, “'Ntnisgamum gesatmul giguow aq ta'n tela'taqati'tij giguaq mawi asgaiwijig. Tetuji uggwai pa wijei aq sisuei.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Na Se'sus ula gis tla'tegej na Lesui'paq iganpugultijig pipanima'titl Se'susal, “Wen gi'l ignmasg iganpuguin? Goqwei mesgi'g gis tla'tegen ta'n gis musga'tuitesnen telteg ugjit gis tla'tegen na?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Se'sus na teli asitemaji, “Gis gaqsuisga'tuoq ula a'sutuo'guom, nesuguna'q gisi apajitutes.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Telima'titl, “Ne'wisgegipunqeg'pnn jel asugom we'gaw gaq gisitu'titeg ula a'sutuo'guom na gi'l tl'te'tmn gisi apajitutes ula a'sutuo'guomg nesuguna'q?” Aq sigti paqalaiultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Gatu na ula a'sutuo'guomg ta'n Se'sus wesgutg'p na negm wa'qi. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ta'n tujiw nepliteg aq apaji minunsiteg, unaqapemg migwite'tmi'tij ula na teluelis aq getlams'tmi'tij Gjinisgam ugtwi'gatign aq Se'sus ugglusuaqanml. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na ge's eigeg Selusalemg Siawa'timgewei pestie'umg, wesgo'tmi'tip aqantie'uti, pugwelg'pnig getlams'tua'titl ta'n tujiw nemitua'titeg ta'n goqwe'l Se'susal gis tla'tegelij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Gatu Se'sus mo ignmuagwi assumgun muta weli gji'jiaji 'ms't mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","'Lpa mo puatas'gnug wen tlimgun ugjit mimajuinu'g muta gis gaqi gji'tuaji mimajuinu'g ugtangita'suaqanmual. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Etna na ula ji'nm teluisit Nigotimus. Negm newgte'jit wegla ta'n iganpugutuaji Lesui'paq na, teluisultijig Palasiaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Newgtejgeg wela'gweg elietl Se'suseg aq telimatl, “Lapai, nujigina'muet, 'ms't wen geitoq Gjinisgam petgim'sg ugjit gina'muen. Mo wen gis tla'tegegw mesgi'gl 'lgowaqan ta'n gi'l gis tla'tege't'p glapis Gjinisgam i'mlij ugtinneg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Se'sus asita'puguet, “Ge' jigs'tui. Ma wen gisi ilgwengun Nisgaml glapis minui ugs'tqamuij. Teliaq na telimul.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nigotimus teluet, “Tal gis minui ugs'tqamuitew mimajuinu, ta'n tujiw gisigwet? 'Lpa mo eigtnug gisi apaji pija'sin uggwitl usgupn aq apaji ugs'tqamuin.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Se'sus apaji asitematl, “Mo eimug wen gis lien Gjinisgam ugtelege'wa'gimg glapis ugs'tqamuit samqwanigtug aq Wejuli Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mimajuinu'g weji ugs'tqamultijig ungi'guaq. Weja'tug na'te'l mimajuaqan ula ugs'tqamugewei. Pa na wijei ta'n tujiw weji ugs'tqamultijig Wejuli Nisgamewigtug. Weja'tug na'te'l iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mut paqalaiw ta'n telimul, ‘Ta'n te'sit wen amujpa minui ugs'tqamuit.’ ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nutmn ugju'sn aq ma gis tluewn ta'n wejiaq gisna ta'n liatew. Mo geitun ugju'sn ta'n tujiw gawasg'tniatew. Pa na wijei mo geitug ta'n wen minui ugs'tqamuitew Wejuli Nisgamewigtug. Teliaq ta'n telimul.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nigotimus pipanigesit, “Tal gis tliaq na?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Se'sus asitematl, “Paqalaiwin gi'l mo geitu'n ula, toqo gi'l nujigina'muen Lesui'paq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Geitu ta'n goqwei wesgutm aq telimul ta'n goqwei nemituap gatu mo getlams'tuiwn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ta'n tujiw telimulaneg ta'n teliaq ugs'tqamug aq mo getlams'tuiwn, tal gisi gtlams'tuites ta'n tujiw tlimulan ta'n goqwe'l wa'so'qewe'l? ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","'Lpa menaq wen eliegw wa'so'q pas'g ni'n na newgte'jit ta'n Gjinisgam petgimip. Ni'n na negm wet nisa'siap wa'so'q aq ta'n mimajuinualsiap. Teliaq na telimul.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ta'n tujiw Isle'laq eimu'ti'titeg paqtaqamigtug, mo wels'tua'tigul Nisgaml. Gjinisgam elgimaji 'mtesgmug aq Isle'laq paqa'lugwi'tiji. Mowiso'q gi'gamgo'nigtug wenaqa'lapnaq gisitaqane'l 'mtesgmaq aq ta'n pas'g wen angamatl gisi 'npisitew. Pa na wijei ni'n ta'n mimajuinualsiap ula ugs'tqamug amujpa na unaqa'liten. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Glaman 'ms't wen ta'n getlams'tuit 'msntew iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gjinisgam na tetuji gsalaji mimajuinu'g, petgimapnn newgtunatl uggwisl nplin ugjit ugtlue'utiwal glaman ms't wen getlams'tuatl ma mn'tua'gig liegw gatu awna iapjiwewei mimajuaqan guguntew wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gjinisgam wej petgimapnn uggwisl mimajuinuigtug ugjit ugs'tawian mimajuinu'g aq wa'so'q la'lan mo ugjit ilsuman aq ugtapulan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","'Ms't wen ta'n getlams'tuit ni'n, Gjinisgam uggwisl, mu negm ilsutasigw. Gatu ta'n wen mo getlams'tuigw gis negm ilsutasit na muta mo getlams'tuigw ni'n, na Gjinisgam newgtunatl uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ni'n Se'sus, na waseteg, wa'so'q wet nisa'siap ugs'tqamug, gatu mimajuinu'g me' gesatmi'tij oqonitpa'q je mu waseteg muta pata'taqatijig. Etna na ugjit ilsumujig na. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ta'n pas'g wen siaw pata'tegej masgelt'g waseteg aq ma liegw wasetegigtug muta mo puatmug ta'n tel tla'tegej musga's'gtn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gatu ta'n wen gigwaji tela'tegej, ta'n Nisgaml tel puatmlij aq jigs'tuatl, eliet wasetegigtug glaman na waseteg musga'tutew ta'n tel jigs'tuatl Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Na ula gis tliaq, Se'sus aq unaqapemg el'ta'jig Jutiaewa'gig. Pe' na'te'l siawqatmu'tijig ta'suguna'q aq sign'tuaji mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Na Sa'n elg sign'tuet na'te'l Aenong, mo piam amasenug Selem. Etl sign'tuet na'te'l muta gaq tepiaqas samqwan. Na mimajuinu'g el'ta'jig Sa'neg aq etl sign'tuaji. ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sa'n me' menaq laplusang pija'lam'g'p.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na alt Sa'n unaqapemg poqji gi'gaja'suala'titl newgte'jilitl Lesui'pal iganpuguilitl ugjit ta'n mimajuiniu'g tl waqamo'ltitaq Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Na el'ta'jig Sa'neg aq telima'titl, “Nujigina'muet, migwite'lm't na ji'nm ta'n wijitgweiasg'p qame'g Jol'tan, ta'n wesgumt'p? Etna na negm etl sign'tuet nige', aq 'ms't mimajuinu'g el'ta'liji.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Sa'n asita'puguet, “Ma wen goqwei gis gugunmug glapis Gjinisgam ignmuaj. Mimajuinu mo goqwei gis assutg glapis Gjinisgam ignmuaj. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","'Ms't tel nutuioq ta'n telueiap, ‘Mu na ni'n na Nujiugs'tawi'wet, ta'n Gjinisgam petgimapnn ilgwenan ugtmimajuinumg,’ pas'g na ni'n igangimugsi ugjit negm. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pa na wijei aq ula. Pugwelgig mimajuinu'g el'ta'jig malie'uti, gatu pas'g na ji'nm ta'n getu malie'wit na 'msnatal na e'pilitl. Witapaq welgwijultijig. Na witapal ta'n ango'tmlij 'ms't goqwei ugjit na ji'nm ta'n getu malie'wit, esg'maltl aq jigistaqana'litl. Mawi ulgwijilitl ta'n tujiw nutua'litl na ji'nm, getu malie'wit, wejgu'et. Se'sus na pa wijei aq na ji'nm malie'wit aq ni'n na witapal. Etna na ugjit mawi ulgwijin maw negm. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Amujpa na negm me' pmi espe'tew je mu ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Negm ta'n wejiet wa'so'q me' espe'g je mu 'ms't wen. Ta'n wen ugs'tqamug tleiawit pas'g wesgutg ta'n goqwei ugs'tqamugewei. Na newgte'jit ta'n wejiet wa'so'q me' espe'g je mu ta'n pas'g wen. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Etna na negm wesgutg ta'n te's'g goqwei nemitoqop aq nutg'p, pas'g mo wen jigs'tuagul. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Gatu ta'n wen jigs'tuatl Se'susal ugglusuaqanml, musga'toq ta'n teli gtlams'tasitl Gjinisgaml ugglusuaqanml teliaqewe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na Ewjilitl Nisgaml ta'n Gjinisgam petgimapnn, wesgutgl Gjinisgam ugglusuaqanml aq Gjinisgam ignmuatl Wejuli Nisgaml aq iapjiw gugunatal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Gjinisgam tetuji gsalatl uggwisl aq 'ms't goqwei iga'tuaj ugpitng. ");
INSERT INTO micMIQNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ta'n wen jigs'tuatl Ewjilitl Nisgaml msntew iapjiwewei mimajuaqan wa'so'q gatu ta'n wen elistuatl Ewjilitl Nisgaml na ma msnmug iapjiwewei mimajuaqan wa'so'q gatu awna Gjinisgam ilsumatal aq ugtapulatal iapjiw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na Palasiaq nutma'tijig me' pugwelgig el'ta'liji Se'suseg je mu Sa'neg ugjit sign'tugsinew aq majulgwalanew. ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pas'g Se'sus negm mo sign'tuagupnig gatu unaqapemg sign'tua'tiji.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Na ta'n tujiw Se'sus geitoq, naqt'g Jutiaewa'gig aq pemi apaja'sit Galaliewa'gig maw unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Amujpa wet saputa'sit Samaliaewa'gig ta'n tel liej na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Na pegising na gutanji'j teluisig, Saigal, Samaliaewa'gig. Mo piami amasenug na iga'taqan ta'n Je'gop ignmuapnn uggwisl So'sepaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na Je'gop ugtnqano'patim na'te'l eteg. Na Se'sus weji gispnet ta'n tel pegiji pmiej ta'n wejiet. Na gigjiw epa'sit nqano'pati. Na'tami mewlia'gwet. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Etna na ula Smaliaewi'sgw pegising, naji nqana'pet. Se'sus na etawaqtmat, “Tatuji ulm'tun, ge' samqo'tliji'ji.” ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Unaqapemg gis el'ta'pni gutang apgwatelmanew mijipjewei.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Na ula Samaliaewi'sgw paqalaig. Asitematl, “Gi'l na Lesui'pewin aq ni'n Samaliaewi'sgw. Tal gis glutmuin ni'n samqwan?” (Lesui'paq penoqite'lma'tiji Samaliaewaq aq mo e'wa'tigul wije'l eptaqang ta'n Samaliaewaq e'wa'tiji.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Na Se'sus asitematl, “Pa na gji'tun ta'n goqwei Gjinisgam ignmultew aq ta'n weni ni'n pipanimul samqwan, na gi'l pipanimin aq ignmuligapnn samqwan ta'n iapjiw mimajulultew.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na e'pit teluet, “Saqamaw, je mu gi'l lataqsun aq na 'nqano'pati temig. Tami ugja'lates lataqsun ugjit ula samqwan ta'n iapjiw mimaju'litew? ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ninen nujjinenaq Je'gopal sa'q ignmugsieg'p ula 'nqano'pati. Negm aq un'jang aq ugtue'mg i' tl samqo'tlipni na'te'l. Mu ta gi'l tel'ta'siwn me' espe'n je mu Je'gopal?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Se'sus na teli asitematl, “'Ms't wen esamqwat ula samqwan ap 'gtu samqwatew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Gatu ta'n wen esamqwat ta'n ni'n ignmua's ap ma nugu 'gtu' samqwawgw. Ula samqwan ta'n ni'n ignmua's tqapo'q i'gt'tew. Ignmagutew samqwan ta'n iapjiw mimajulultew.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ula e'pit etamatl, “Saqamaw, ge' ignmui ula samqwan glaman ma nugu 'gtu' samqwaw gisna ma nugu ula tet jugu'ew aq ugja'tu samqwan.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Se'sus telimatl, “Ge' wigum gji'nmum aq apaja'si ula tet.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","E'pit teluet, “Pas'g na ni'n mo nji'nmumiw.” Se'sus nestuatl aq telimatl, “Teliaq na teluen ta'n tujiw telueneg mo gji'nmumiwn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gis na'n tepqatmn aq ula ji'nm ta'n toqwatmoq nige' mu na menaqqajewei 'gji'nmum. Na maw tliaq ta'n teluen.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Na e'pit asitapuguet, “Saqamaw, amuj na gi'l iganigjitegewinuin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nujjinaqi'g Samaliaewaq tli emtoqwala'tipnn Nisgaml ula gm'tnigtug, gatu tal gis gilew Lesui'peultioq telueioq ala Selusalemg na mawgi'g aq na'te'l etli emtoqwalanes Gjinisgam?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Se'sus asitematl, “Saqama'sgw, tetaputest'tew iga'q ta'n tujiw mimajuinu'g mu ula gm'tnigtug gisna Selusalemg tli emtoqwala'tital Gisitegelitl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gilew, Samaliaewaq, mo gejiawoq ta'n wen emtoqwaloq. Ninen Lesui'peweieg geji'g't ta'n wen emtoqwalg't muta nujiugs'tawi'wet wejiet na Lesui'pewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Gatu na'gweg iga'qt'tew aq getletug gis nige' iga'q ta'n tujiw mimajuinu'g emtoqwala'titl Wegwisilitl Nisgaml teliaqeweigtug. Na Wejuli Nisgam ta'n ugtinnewaq eig ilgwenmuaji aq ignmuaji na ml'gigno'ti, na tla'taqatinew. Etna na negmow Wegwisit Nisgam pua'laji emtoqwalgunew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pas'g na Wejuli Nisgam gis musga'tuaji mimajuinu'g ta'n tli emtoqwala'titl Gjinisgaml teliaqeweigtug, muta negm wejiet Nisgamewigtug. Gjinisgam ta'n ignmuaji mimajuinu'g ugjijaqamijuaq. Na Wejuli Nisgam ilgwenugsi'gw aq ignmugsi'gw na ml'gigno'ti ugjit tla'taqatinenu.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na e'pit telimatl, “Geitu Gjinisgam petgimatal na Nujiugs'tawi'welitl ugjit ilgwenan ugtmimajuinumg. 'Pgising tlimugsitesnu 'ms't goqwei.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Se'sus asitematl, “Ni'n na Nujiugs'tawi'wet ta'n etl agnutmul.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Assma na tujiw Se'sus unaqapemg apaita'niji. Na we'gwi ms'gi'g's ta'n tel paqalaiulti'tij ta'n tujiw nemia'titeg etli agnutmajig Samaliaewi'sgwal. Pas'g na mo wen telimagul e'pilitl, “Goqwei puatmn?” gisna mo pipanima'tigul Se'susal, “Goqwei na weji agnutmaioq?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Na e'pit naqalatl ugsamqwano'qoml aq apaja'sit umutgig aq telimaji mimajuinu'g na'te'l, ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Jugwita'gw aq nat nmug ji'nm ta'n gis tlimit 'ms't goqwei ta'n tela'tegeiap. Etug jel na ula Nujiugs'tawi'wet.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Na tujiw mimajuinu'g naqtmi'tij gutan aq el'ta'jig Se'suseg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ta'n teli nqase'g na e'pit naqalateg, unaqapemg munsaiwa'titl Se'susal, “Nujigina'muet, nat goqwei malqottes.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Gatu Se'sus asita'puguet, “Ni'n geggunm mijipjewei ta'n gilew mo geituoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Na unaqapemg poqji mawagnutma'tijig, “Etug nat wen 'pgisituatug mijipjewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Na tujiw Se'sus telimaji, “Ni'n jigs'taq nujj aq tela'tegen ta'n nujj tel petgimip aq gaqa'tun na ugtlgowaqan ta'n ignmuip tla'tegen. Etna na ula ta'n ulapettes pa wijei aq gelu'lg mijipjewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Gilew tlueioq 'mjit ne'wijig tepgunsejig na mena'taqutten. Gatu telimuloq, uli angaptmug iga'taqan muta gaq gisigwet aq nige' gisi mena'taqutten. Wesgumgig ta'nig gis gisgajo'ltijig ugjit 'lgwenugsultinew Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na mimajuinu'g ta'n mena'taqu'tijig aq na ula poqtatultijig aq mawo'tu'tij ta'n goqwei gisigweg apangitugsultitaq. Pa na wijei mimajuinu'g ta'nig mawo'la'titaq igtigig ugjit 'msnmnew na iapjiwewei mimajuaqan wa'so'q na apangitugsultitaq aq na tujiw ulgwijultitaq. Na tujiw newgte'jit ta'n iga'taqug aq na igtig ta'n mena'taqug, gitg ulgwijintaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Na ula ta'n i' tluepnig na teliaq, ‘Newgte'jit iga'taqug aq ap igtig mena'taqug.’ ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Elgimuloq mena'taqu'tinew iga'taqan ta'n menaq etl lugutiwoq. Igtigig etl lugutipnig na'te'l aq welapetmu'tioq ula ugtlgowaqanmuoq. Na gatu ta'n tujiw mimajuinu'g 'lgwenugsultinew Nisgamewigtug, na tujiw ulgwijultitaq maw ginua.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na ta'n tujiw na e'pit apaja'sit umutgig pugwelgig na gutan getlams'tua'titl Se'susal muta gis tluet, “Telimip 'ms't goqwei ta'n tela'tega'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Na toqo tujiw Samaliaewaq naqtmi'tij gutan aq peita'jig Se'suseg. Munsaiwa'titl i'mlin, aq Se'sus eig'p na'te'l tapuguna'q. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Me' pugwelgig getlams'tua'titl ugjit ta'n goqwei teluelij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Telima'titl na e'pilitl, “Nige' getlams'tmu'tieg. Mu na pas'g ta'n gi'l gis tluen gatu ninen elt gis nutaqatt aq geitueg na negm Nujiugs'tawi'wet ugjit ta'n te'sijig mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tapuguna'gweg Se'sus naqt'g na'te'l aq eliet Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Se'sus gis tluet, “Iganigjitegewinu ma gepmite'lgwi'tigul ugtmimajuinumg.” Mo menuegemg'g umutgig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ta'n tujiw iga'teg Galaliewa'gig na mimajuinu'g mawi ul'ta'suala'titl muta negmow gis eimu'tipnig Selusalemg ugjit pestie'uti Siawa'timgewei aq nemia'tipnn ta'n tel mila'toqopnn mesgi'gl 'lgowaqan ta'n tel pita'q pestie'uti. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ge's eigeg Galaliewa'gig, 'mjit newgt apaja'sit na gutan teluisig Gena. Na'te'l etl sa'se'wa'toqop samqwan moqopa'qigtug. Galaliewa'gig eig g'pnno'lewei iganpuguit, ta'n uggwisl gesnugwa'litl. Wesgowa'sijig na gutan teluisig Gapelniamg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ta'n tujiw nutmateg Se'susal gis wejielipnn Jutiaewa'gig glapis Galaliewa'gig, eliet negmeg. Pipanimatl ugjit lien Gapelniamg aq 'npitmuan uggwisl ta'n pemi nplitl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Se'sus telimaji mimajuinu'g, “Ma wen gilew te'sioq 'gtlams'tmun glapis nemitun mesgi'gl 'lgowaqan tela'tegeian aq paqalaiuti'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Iganpuguit etawaqtmuatl, “Saqamaw wije'wi gesgmnaq nn'jan nepug.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Se'sus telimatl, “'Ggwis siaw mimajitew. Gisinmietes nige'.” Na ji'nm getlams'tuatl Se'susal aq maja'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na peminmieteg, ugtlugowinumg as'g'jig aq telimjig ula agnutmaqan, “'Gtlpa'tu'jm siaw mimajitew.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pipanimaji, “Tale'g's ta'n tujiw 'ngwis ila'siteg?” Telima'titl, “Ulagu gis mewlia'gweg ta'n tujiw na epsimgewei ejigla's'geg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na tujiw na ji'nm migwite'tg. Etna na wijei ajiet ta'n tujiw Se'susal telimteg, “'Ggwis siaw mimajitew.” Etna na ugjit negm aq 'ms't wi'gmaq getlams'tmu'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Etna na ula tapuewei mesgi'gl 'lgowaqan ta'n Se'sus tela'tegepnn ta'n tujiw naqt'geg Jutiaewa'gig aq elieteg Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wegla gis tliaq Lesui'peweiei pestie'uti pem iga'q aq Se'sus eliet Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Etna na 'gjigang, na ga'qana'tas'g teluisig, “Ta'n etl guguna'tij jijgluewjig.” Gigjiw ula ga'qana'tas'g eteg's temig samqwan walgopaqteg. Na'ngl tusati'l gigto'qotegl. Lesui'paq ugtli'sutimuaq telui'tmi'tis Petse'ta. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Na pugweliepnig mimajuinu'g ta'n gesnugu'tijig alismia'tijig tusatigtug. Nepapigwo'ltijig, ta'nig mo gisi al'ta'gwig aq ta'nig mo gisi majita'gwig, etli esgmatmi'tip ugjit na samqwan maja's'gtn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Jijuaqa Gjinisgam ugtansale'witeml i' nisa'silitl samqwanigtug aq se'sapaqte'g samqwan. Na tmg gesnugwat mimajuinu gisi gwija'sij samqwanigtug ta'n tujiw na samqwan gis se'sapaqte'g gisi npisit ta'n telipnej. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Etna na ula ji'nm na'te'l ta'n gesnugwateg nesisgegipunqeg jel ugumuljin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Se'sus nemiatl na'te'l elisinnitl, aq gejiatl ta'n etli pgiji gsnugwalij. Na tujiw pipanimatl, “Getu ila'sin?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Na gesnugwat ji'nm asitematl, “Saqamaw, mo wen geggunaq tet ta'n gwija'litew samqwanigtug ta'n tujiw gis se'sapaqte'g. Gatu ta'n tujiw wejo'tm gis gwija'sin, nat wen piluei tmg gis gwija'sit.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Se'sus telimatl, “Unaqa'si, 'mgne'n 'gpismutim aq pmia.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na smtug ji'nm gisi npisit. Wesua'toq ugpismutim aq poqji ala'sit. Ula na'gweg na teliaq na atlasmutigisg'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Etna na ugjit Lesui'paq iganpugultijig telima'titl na ji'nmul ta'n gisi nplipnn, “Ula na atlasmutigisg'g. Mo teltenug ugjit gi'l pema'tun 'gpismutim. Etl suisga'tun 'gt'tplutaqanminal ta'n tujiw pema'tun.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Asitemaji, “Na ji'nm ta'n gisi npilip telimip, 'Mgne'n 'gpismutim aq pmia.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pipanima'titl, “Wen ta u't ji'nm ta'n telim'sg'p, ‘'Mgne'n 'gpismutim aq pmia’?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Gatu na ji'nm ta'n gisi npilut'p mu gejiagul ta'n wenilij muta Se'sus etli gs'ga'sis ta'n etl mawie'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Weli pgije'geg na wijei na'gweg Se'sus we'jiatl 'gjia'sutuo'guomg aq teluet, “Ge' angapte'n, gisi npisineg. Pun pata'tega gisna me' mesgi'g nat goqwei tliatew gi'leg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Na tujiw na ji'nm naqalatl aq telimaji Lesui'paq iganpugultijig, etna na Se'sus ta'n gisi npilip. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Etna na ula ugjit poqji gitnme'wa'titl Se'sugulial muta nepilapnn ji'nmul atlasmutigisg'geg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Gatu Se'sus telimaji, “Apjiw Nujj elugwet tlia atlasmutigisg'g aq amujpa ni'n elugwei.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ula ta'n goqwei teluep gisa'laji Lesui'paq iganpugultijig wejo'tmi'tijig ta'n tel gisi pgwatu'tij, ne'pa'new. Mo na pas'g ta'n tel suisga'toq atlasmutigisgugewei 'tplutaqan gatu elt teluet negm Nisgaml ujt'pnn. Ta'n tel tlueteg na musga'tuaji ta'n teli ugsualsit negm 'st'ge' e'taguatl tegpaqtesguatl Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Etna na ugjit Se'suguli telimaji na mimajuinu'g, “Telimuloq, ma gisi nguti tla'tegew goqwei. Pas'g tela'tegei ta'n tel nemi'g Nujj tela'teget. Ta'n goqwei Nujj tela'teget ni'n na uggwisl wijei tela'tegei, ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Muta Nujj gesalit aq musga'tuij ta'n goqwei tel mila'tegej. Musga'tuitew me' mesgi'gl goqwe'l je mu wegla gis tla'tegei, aq 'ms't paqalaiultitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Etna na Gjinisgam Nujj ta'n gisi unaqa'lataq ta'nig nepu'tijig aq ignmuataq mimajuaqan. Na wijei ni'n ignmua's iapjiwewei mimajuaqan ta'n tegenig pewalgig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mo Nujj wenn ilsumagul. Gaqi ignmuip ni'n uggwisl ugml'gigno'tim ugjit ilsutegen. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Glaman 'ms't wen gepmitelmitew ni'n na uggwisl ta'n tel gepmitelma'tij Nujjl. Ta'n wenig mo gepmitelmi'gw ma gis gepmitelma'tigul Nujjl ta'n petgimip. Teliaq na telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ta'n wen jigs'tmuitl 'ntglusuaqanml aq getlams'tuatl Nisgaml ta'n petgimip, geggung iapjiwewei mimajuaqan wa'so'q. Ma ilsutmuam'gl ugtlue'uti'l aq ma mn'tua'gig 'lgimam'g gatu gis geggung iapjiwewei mimajuaqan. Na teliaq telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na na'gweg iga'qt'tew aq gis nige' iga'q ta'n tujiw 'ms't wenig gis nepu'tijig na nutuitaq ni'n na Gjinisgam uggwisl aq ta'nig nutuijig aq jigs'tuijig iapjiw mimajultitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nujj na Wegwisit Nisgam ta'n gisa'toq 'ms't goqwei mimajigtn gis gisa'lataq mimajuinu'g iapjiw mimajultinew, pa na wijei ignmuip ni'n uggwisl wijei gis tla'tegen, gisa'lan mimajuinu'g apjiw mimajultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ignmuip ni'n na uggwisl ml'gigno'ti gisi ilsuman mimajuinu'g muta ni'n na newgte'ji ta'n mimajuinualsiap. Teliaq ta'n telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Telimaji, “Mut ula paqalaiugsinew muta na'gweg wejgu'aq ta'nig nepu'tipnig nutuitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ugji mn'jita'taq utqutaqane'gatig. Ta'nig wela'taqatipnig unaqita'taq aq apjiw mimajultitaq wa'so'q. Ta'nig opla'taqatipnig unaqita'taq aq 'lgimaten mn'tua'gig. Na teliaq telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Pas'g ilsutm ta'n goqwei Gjinisgam telimij. Tetapu ilsutegei muta mo wejo'tm tela'tegen ni'n ta'n tel puatm gatu pas'g ta'n wen petgimip tel puatg. Ma goqwei gisi nguti tla'tegew.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Se'sus siawewistoq, “Ma tli ugsua'tuoq ta'n tujiw wesgumsian ta'n weni aq ta'n gis tla'tegei. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Gatu nat wen igtig piluei eig ta'n wesgumit, etna na Nujj aq geitu ta'n negm teluet ugjit ni'n na teliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Gilew elgimoqopnig mimajuinu'g ta'n Sa'n Nutsign'tuet eig ugjit jigs'tuanew ta'n etl pestung. Negm teli usgumip teliaqeweigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","35","Mo taluega'q ji'nm usgumin gatu migwimuloq ta'n teli usgumip Sa'n glaman 'gtlams'tuitoqs'p aq ugs'ta'titoqs'p. Ta'n teli usgumip pa wijei aq wasoqonmaqan ta'n wasoqweg aq paqteteg'p aq wel'te'tmu'tioqop ugjit gijga'jig jigs'tuanew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Gatu me' mesgi'g ta'n tel musga's'g ta'n weni je mu ta'n Sa'n Nutsign'tuet teli usgumip. Na mesgi'gl 'lgowaqann ta'n tela'tuanl, nujj ignmuipnn ugjit tla'tegen. Etna na wegla musga's'gl ta'n weni aq tel nemituoqol aq musga'tig'pnn ta'n Nujj tel petgimip. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nujj ta'n petgimip elt negm wesgumip. Menaq nutuawoq aq menaq nemituawoq ugsisgw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mo geggunmuawoqol ugglusuaqanml 'ggamlamunuaq muta mo getu jigs'tuiwoq aq mo 'gtlams'tuiwoq ni'n ta'n petgimimg'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gegina'masultioq Gjinisgam ugtwi'gatign muta tel'ta'sultioq na'te'l wejittoqs'p iapjiwewei mimajuaqan. Gegnua'tugsioqopnn ugjit ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Gatu me' menaq gisita'sultiwoq jugwita'new ni'neg glaman gisi ignmultoqs'p iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Mo algwilmu gepmitelgaqan mimajuinuigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Gatu geju'loq. Geitu gilew mo gesalawoq Gjinisgam 'ggamlamunuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Gjinisgam nujj ugwisunmg weji pgisinap gatu gilew mo wel'te'lmiwoq. Gatu awna wen piluei 'pgising negm ugwisunmg, mo negm Gjinisgam petgimagul, na ul'telmatoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Gesatmoq gepmite'ltultioq gatu mo tali el'te'tmuoq Gjinisgam gepmite'lmugsinew. Getl ta mo gisi gtlams'tmu'tiwoq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mut tl'ta'sultinew ni'n elsutmultoqs'p nujjeg. Etna na Mowis 'lsutmugsitoqs'p. Negm ta'n ugt'tplutaqanml elita'suatmoqop ugjit la'lugsinew wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Gatu 'gtlams'tmoqosn ta'n Mowiso'q tel wi'gig'pnn, na tujiw 'gtlams'tuigoqpn ni'n muta negm wesgumip ta'n tujiw ewi'gigeg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Gatu mo getlams'tmuawoqop Mowiso'q ta'n goqwei gis wi'gig'p, getl ta mo getlams'tmu'tiwoq 'ntglusuaqanml.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Na pugjitew iga'q na Siawa'timgewei Pestie'uti. Se'sus maw unaqapemg pusijig aq asoqomitajig na qospem teluisig Galali. (Elt telui'tmi'tij Taipilias.) Pugwelg'pnig mimajuinu'g majulgwala'titl Se'susal. Nemitua'tipnn mesgi'g lugowaqan tela'tegelij ta'n teli npilapnig gesnugu'tijig. Na Se'sus maw unaqapemg oqwa'jig aq soqwita'jig gm'tnigtug aq epita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tel gne'geg Se'sus nisapa'sit gm'tnigtug. Elapit aq nemiaji pugwenniji mimajuinu'g pemi sgoqita'jig. Algwilua'titl. Gigto'qopugua'sit aq pipanimatl Pilipal, “Pilip, tami tet gisi ugjattesnu mijipjewei ta'n tl smatesnu ula mimajuinu'g?” ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Se'sus getu gji'jiatl ta'n Pilipal tluelital. Gis geitoq ta'n tla'tegetew.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Na Pilip asitematl, “Ta'n goqwei wen ne'pa'toq ugumuljin te'sijig tepgunsejig, ma tepianug ugjit gijga gis sman na te'sijig mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gatu ap igtig unaqapeml Antle', Simon Pie'l wijigumatl teluet, ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ula eig lpa'tuj ta'n geggungl na'ngl pipnaqanu'tl, wejitas'g pallieweigtug, aq tapusiliji nme'ji'jg. Gatu mo eigtnug tepian gis smanenu na te'sijig mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Se'sus telimaji, “Tlimug na mimajuinu'g pita'tij ta'n etli msiguig.” (Na tujiw mimajuinu'g epita'jig.) Eimu'tijig na'tami na'n pituiptnnaqanijig ji'nmug aq maw e'pijig aq mijua'ji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Toqo Se'sus wesua'toq pipnaqan aq miwatmuatl Nisgaml aq tepiaji mimajuinu'g ta'n pemgopultijig. Na wijei tela'laji nme'ji'jg aq 'ms't wen tepiaq ta'n telatalg. Na. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ta'n tujiw g'satalulti'titeg telimaji unaqapemg, “'Mgnmug ta'n goqwei esgwiaq glaman ma goqwei 'gs'gaqtnug.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ta'n tujiw gaqi mgnmi'titeg wajua'tu'titl newgtisga'qal jel ta'pu ligpenignn ta'n wej piamiaqal na'ngl pipnaqanu'tl ta'n weji esgutmi'titl mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na mimajuinu'g nemitu'titeg ta'n tel mesgi'g Se'sus gis tla'teget, teluejig, “Na ula ji'nm na iganigjitegewinu ta'n esgmalulg'p. Getleweigtug teluepnig ugjit 'pgisin ugs'tqamug ta'n esgmalulg'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Se'sus gejiaji jugwita'linew aq 'gtu gi'gaji elege'walanew. Gatu mo ignmuagwi awna naqalaji aq siawi nguti sgoqiet. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na ta'n tujiw poqji piluamugwiaq na unaqapemg nisita'jig qospemg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tepita'jig ugtuluaq aq pusijig. Poqji apaji asoqomisugultijig na qospem. Pesu'gwatmu'tijig na gutan Gapelniam. Na tel gne'ge'l, wel oqonitpaqiaq aq Se'sus menaq pegisinugweg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na jiniw ugju'sn poqji melgignewa's'g aq poqji mqatgwig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ta'n tujiw na unaqapemg elisugultijig na'tami nesisgl gisna neggul loqtn, na jiniw nemia'titl Se'susal wesgit pmielitl samqwanigtug. Siaw pem gigja'silitl ugtuluaq. 'Ms't sigteta'sultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Se'sus telimaji, “Mut jipaqita'new! Ni'n na pas'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Na tujiw wel'te'tmi'tij tepa'lanew ugtuluaq. Ta'n tujiw teppit ugtuluaq smtug iga'jig ta'n getu 'lta'pnig aq oqwa'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na wapg, na mimajuinu'g, ta'n siawqatmu'tijig ta'n Se'sus etl smapnig, migwite'tmi'tij pas'g newgte' unaqapemg ugtuluow eteg'p. Geitu'tij Se'sus mo wije'wa'qupni unaqapemg ugtuluaq, gatu unaqapemg poqjisugultipnig aq mo negm teppigup. Na tujiw peminmita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Na igtigig mimajuinu'g weita'jig gutan Taipilias ugtuluaq. Oqwa'jig gigjiw na'te'l, ta'n Gjisaqamaw etl miwatmuapnn Nisgaml ugjit na mijipjewei aq mimajuinu'g etlatalultipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Toqo ta'n tujiw mimajuinu'g nemitu'tij mo Se'susal eimligul aq unaqapemg asoqomisugultipnig, tepita'jig ugtuluaq aq pusijig. Asoqomisugultijig glapis Gapelniam, ugjit gwiluanew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ta'n tujiw we'jia'titeg Se'sus na'te'l, pipanima'titl, “Nujigina'muet, ta'n pegisinu's'p?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Se'sus asitemaji, “Telimuloq. Na algwiluioqop mo ugjit ta'n teli gtlams'tuioq gisna ta'n tel nemituoqop mesgi'gl ta'n goqwe'l tela'tegeiap gatu ta'n essmuloqop aq g'satalultioq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Telimuloq, mut pas'g lugutinew ta'n goqwei gaqiatew 'st'ge' mijipjewei gatu awna sespete'tmug aq gwilmug iapjiwewei mimajuaqan ta'n gisi ignmultoqs'p ni'n na newgte'jit ta'n mimajuinualsiap. Gjinisgam, gujjinu megnip aq ignmuip ml'gigno'ti na tla'tegen. Teliaq na telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Na tujiw pipanima'titl, “Tala'taqatitesnen ugjit lugwatmu'tinen na 'lgowaqan ta'n Gjinisgam pualugsieg?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Se'sus asitemaji, “Etna na ula ta'n Gjinisgam tel puatg tla'taqatinew, Pewalugsioq 'gtlams'tuinew ni'n ta'n petgimip.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Na teli asitema'titl, “Amujpa na tela'tegen me' mesgi'g paqalaiuti pewalieg 'gtlams'tmu'tinen gi'l na newgte'jin ta'n petgimulg ugjit ugs'tawian Gjinisgam ugtmimajuinumg. Goqwei elugwatmn? ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Gujjinaqi'g malqotmi'tip na mijipjewei teluisig manna paqtaqamigtug ta'n tel wi'gas'g Gjinisgam ugtwi'gatign, ‘Mowiso'q ignmuapni pipnaqan, wa'so'q wejiaq.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Se'sus teluet, “Telimuloq, na pipnaqan ta'n Mowiso'q ignmuapni wa'so'q wejiaqap gatu mo na 'gjitmei wa'so'qewei pipnaqan. Etna na Gjinisgam nujj nige' ignmugsitoqs'p na 'gjitmei wa'so'qewei pipnaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na 'gji'tmei wa'so'qewei pipnaqan ta'n Gjinisgam ignmugsioq, na negm ta'n weji nisa'sit wa'so'q ugjit ignmugsinew mimajuinu'g iapjiwewei mimajuaqan. Na teliaq telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Etama'titl, “Saqamaw te'sigisg'g ignmuieg ula pipnaqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Se'sus na teli asitemaji, “Ni'n na newgte'ji ta'n gisa'lultoqs'p siaw mimajultinew Nisgamewigtug pa wijei aq pipnaqan gisa'lugsitoqs'p siaw mimajultinew ula ugs'tqamu. Ta'n wen wejgu'et ni'neg ma guisinug. Ta'n wen getlams'tuit ma 'gtu samqwawgw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Gatu gis telimuloqop ta'n weni aq gis nemioq aq me' wijei mo teli gtlams'tmu'tiwoq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta'n te'silitl wen Nujj ignmuitl jugwita'taq ni'neg. Ma jiglapasualaqig ta'n pas'g wenig jugu'elin ni'neg. Iapjiw i'ttew ta'n eim. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Weji nisa'siap wa'so'q mo ugjit lugwatmn ni'n ta'n tel puatm gatu ta'n tel puatg Gjinisgam ta'n petgimip. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Etna na ula Nisgam ta'n petgimip pualit tla'tegen, ma e'nagig ta'n wenig gisi ignmuipnig je mu newgte'jit gatu awna unaqa'la's aq ignmua's iapjiwewei mimajuaqan wa'so'q, ugtejgewei na'gweg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nujj tel puatg ta'n wenig telita'sualijig ni'n uggwisl aq getlams'tuijig, iapjiw mimajultitaq wa'so'q. Unaqa'la's aq ignmua's iapjiwewei mimajuaqan wa'so'q ugtejgewei na'gweg. Etna na ula ta'n Nujj tel puatg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na tujiw Lesui'paq poqji nunmaqultijig ugjit Se'susal muta teluelitl, “Ni'n na newgte'jit ta'n wet nisa'siap wa'so'q. Gisa'lultoqs'p siaw mimajultinew Nisgamewigtug, pa wijei aq pipnaqan gisa'lugsitoqs'p siaw mimajultinew ula ugs'tqamug.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Telimtultijig, “Mu ta ula ji'nm Se'sus, So'sep uggwisl? Amuj na! E'e! Nenuggig ujjl aq uggwitl. Tal gis nige' tluet weji nisa'sip wa'so'q?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Se'sus na asitemaji, “Pun nunmaqultigw gilew te'sioq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ma wen gis jugu'egw ni'neg glapis Nujj ta'n petgimip jugwa'gitmuij aq unaqa'la's ugtejgewei na'gweg. Iapjiwewei mimajuaqan wa'so'q ignmua's. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na iganigjitegewinugi'g ewi'gmi'tipneg, ‘'Ms't mimajuinu'g Gjinisgam gina'muataq.’ 'Ms't wen ta'n nutuaj Nujjl aq jigs'tuaj na jugu'etew ni'neg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Je tlia mimajuinu nutuaj Nisgaml, menaq wen nemiagul pas'g ni'n ta'n Nisgamewigtug wejia'p. Pas'g ni'n nemi'g'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Telimuloq ta'n wen getlams'tuit 'msntew iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ni'n na newgte'jit ta'n gisa'lultes siaw mimajultinew wa'so'q pa wijei aq pipnaqan gisa'lugsitoqs'p siaw mimajultinew ula ugs'tqamu. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Gujjuaqi'g malqotmi'tip manna, eimu'tipnig paqtaqamigtug aq nepu'tipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gatu na wa'so'qewei pipnaqan gisa'lataq ta'n wenig malqotmi'tij ma 'npu'ti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ni'n na wa'so'qewei pipnaqan, wet nisa'siap wa'so'q. Ta'n wenig malqotmi'tij ula pipnaqan iapjiw mimajultitaq, aq ula pipnaqan ta'n ignmuitesg na na'qi. Iga'tutes glaman 'ms't mimajuinu'g gisi mimajultitaq. Na teliaq telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Na ula ta'n Se'sus gis tluet gisa'laji uggwaiultinew aq gi'gaita'new. Pipanimtultijig, “Tal gis ula ji'nm gisi ignmugsitesnu wa'qi malqotmnenu?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Se'sus telimaji, “Ni'n ta'n mimajuinualsiap. Mo malqotmuiwoq na'qi aq samqwoltiwoq nmal'tem, ma iapjiwewei mimajuaqan gugunmuoq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ta'n wen malqotg na'qi aq samqwaj nmal'tem iapjiwewei mimajuaqan geggung, aq ta'n tujiw gespaqami'g iga'q na apaji unaqa'la's utqutaqane'gati aq iapjiw mimajitew wa'so'q ta'n eim. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ni'n na'qi na 'gjitmei mijipjewei aq na nmal'tem 'gjitmei ta'n esamqwoltioq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ta'n wen malqotg na'qi aq esamqwaj nmal'tem ni'neg eig aq ni'n eim negmeg, ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Gjinisgam Nujj ta'n iapji mimajit, petgimip. Ignmuip iapjiwewei mimajuaqan aq pa na wijei ta'n malqotg na'qi ignmua's iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Etna na ula pipnaqan ta'n wejiaqap wa'so'q. Gujjuaqi'g pipnaqan malqotmi'tip aq gaqi npu'tipnig. Gatu awna ta'n wen 'gjitmei wa'so'qewei pipnaqan malqotg iapjiw mimajitew. Ma npu'ti'gw pa wijei aq ta'n gujjuaqi'g teli npu'tipnig. Teliaq na telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Se'sus ula teluep ta'n tujiw egina'muateg a'sutuo'guomg na 'gjigan Gapelniam. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na pugwenniji unaqapemg nutmi'tip ula, telueliji, “Ula gina'masuti wesami mtue'g. Wen ta'n gis jigs'ttew?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Gesgmnaq telimam'g Se'sus gejiaji unaqapemg nunmaqultijig ugjit ula. Na tujiw pipanimaji, “Na ula gisa'lugsioq 'gtu punia'tinew? ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tal'ta'sultigoq nige' ta'n tujiw nemioq ni'n ta'n mimajuinualsiap apaja'sin wa'so'q ta'n wejia'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mimajuinu ma gisa'tug iapjiw mimajin. Pas'g Wejuli Nisgam gisa'lultew iapjiw mimajin. Ta'nig pas'g newgti ugs'tqamulti'tij ma gisi msnmi'tigw iapjiwewei mimajuaqan. 'Gtlams'tasultioq na glusuaqann ta'n wesgutmuloqopnn, gisa'luloq 'msnmnew na Wejuli Nisgam aq iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Gatu alt gilew mo getlams'tuiwoq.” (Se'sus geitoqop mawi amgweseweieg ta'nig ma 'gtlams'tagugwig aq ta'n wen 'ntuisgalgutal.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Na tujiw angua'toq, “Etna na ugjit wet tlimuloqop. Ma wen gis jugu'egw ni'neg glapis Nujj na iga'tuaj uggamlamung.” Na. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ta'n tel tlimapni na pugwenniji ta'nig majulgwala'tipnn, gawasgita'jig aq ma nugu wije'wa'tigul. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Etna na ugjit Se'sus pipanimaji newgtisgegsiliji jel ta'pu unaqapemg, “Gatu gilew getu maita'ioq?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Pie'l asitematl, “Gjisaqamaw, tami 'lta'tesnen? Gi'l geggunmn na agnutmaqan ta'n ignmugsitesnen iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aq nige' getlams'tasultieg aq geitueg gi'l na newgti sape'win wejien Gjinisgamewigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Se'sus na telimaji, “Megnuloqop newgtisgegsioq je ta'pu aq newgte'jit gilew mn'tuit.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Na wesgumatl Sutaal, Simon Isgaliot, uggwisl. Newgte'jilitl unaqapemg ta'n newgtisgegsiliji je ta'pu ta'n 'ntuisgalgutal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Weli pgije'geg Se'suguli al mittugwet Galaliewa'gig. Mo getu liegw Jutiaewa'gig muta Lesui'paq iganpugultijig getu ne'pa'tipnn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na pemi iga'q Lesui'pewei pestie'uti ta'n teluisig, “Gaq mena'taqutimg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Na Se'sus ugjignamg pipanimaji, “Mo liewn Jutiaewa'gig ugjit na pestie'uti glaman gnaqapemg nmitultaq lugowaqan ta'n lugwattes? ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mo wen mimgwa'tug ta'n goqwei tela'tegej ta'n tujiw puatg nenugsin. Tl'ta'sin teli ms'gin na musga'tu ugs'tqamug.” ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Je we'gaw ugjignamg mo getlams'tagupnig.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Na Se'sus telimaji, “Menaq tetaputestnug ugjit ni'n lien. Gatu gilew gisi 'lta'toqs'p ta'n pa tujiw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mimajuinu'g ta'n mo getlams'tui'gw mo masgelmugsiwoq gatu ni'n masgelmijig muta apji tlimgig ta'n teli opla'taqati'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gilew 'lta'gw na pestie'uti. Mo ni'n eliew nige' muta menaq tetaputestnug iga'q ugjit ni'n lien.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Na telimapni ula aq siawqatg'p Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ta'n tujiw ugjignamg el'ta'titeg pestie'umg, na tujiw elg Se'sus eliet. Mo wije'wagwi mimajuinu'g gatu awna gim liet. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Etna na ugjit Lesui'paq iganpugultijig algwilua'titl, pestie'utigtug. Pipanigesultijig, “Tami eig? Gis wen nemiapnn?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ta'n pugwelgig mimajuinu'g etl mawita'jig na'te'l gimewistu'tiji. Alt teluejig, “Maw ulm'toq na ji'nm.” Aq igtigig teluejig, “Moqwa', apji elue'wa'laji mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pas'g mo wen tetujita'ugw usguman mimajuinuigtug muta jipala'tiji ta'ni Lesui'paq iganpugultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na gis suel aqataig gaqiaq pestie'uti ta'n tujiw Se'sus eliet 'gjia'sutuo'guomg aq poqji gnu'tmuaji na mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na Lesui'paq iganpugultijig paqalaiultijig aq teluejig, “Tal gis ula ji'nm telgi'g geitoq ta'n tujiw mu geggunmug gina'masuti?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Se'sus asitemaji, “Ta'n goqwei gegina'man mo 'ntglusuaqanml, gatu wejiaq Nisgamewigtug ta'n petgimip. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ta'n wen wel'te'tg tla'tegen ta'n goqwei Gjinisgam tel puatg, 'gji'tutew ta'n goqwei gegina'matm wejiaq Nisgamewigtug gisna pas'g tl gina'mueian 'ntml'gigno'timg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Gisi gji'jit ta'n wen puatg gepmitelmugsin ta'n etl ewo'qwet muta pas'g wesgumsit aq wesgutg ta'n etli angita'sit. Aq gisi gji'jit mimajuinu ta'n getu gepmitelmatl igtigl ta'n petgimtl ta'n etl ewo'qwet. Pas'g wesgumatl ta'n wen petgimtl aq wesgutg ta'n negm puatmlij. Gis sangewitelmatogs'p, mo egsuegw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mowiso'q ignmugsioqop 'tplutaqan gatu mo wen te'sioq gaqi majulgwatmugup. Gatu gilew mo gis gaq majulgwatmu'titoqs'p Mowis ugt'tplutaqanm, goqwei wej gwilmuioq amsalteg ta'n tel suisga'tu ni'n. Goqwei weji 'gtu ne'pa'ioq ugjit wegla?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Na mimajuinu'g asitema'titl, “Elue'wien ta gi'l. Wen ta gi'l getu ne'pe'sg?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Se'sus na teli asitemaji, “Paqalaiwaqan elugwa'p atlasmutigisg'gigtug. Nepilg'p ji'nm aq 'ms't paqalaiultioq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Gatu lugwatasultitaq 'ggwisuaq ta'n tujiw aqantie'uti gis tetuje'g je tlia atlasmutigisg'g, muta Mowiso'q na telimugsioqop. (Gesgmnaq Mowis ugs'tqamuigweg gujjuaqi'g i' tla'taqatipni'g.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lpa'tuj elugwasij atlasmutigisg'g glaman Mowiso'q ugt'tplutaqanm ma suisga'tas'gtnug. Gatu goqwei weji uggwaiugtuioq ni'n muta gaq nepilg'p ji'nm atlasmutigisg'gigtug? ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Menaqqajewei angite'tmug ta'n goqwei gis tliaq aq na tujiw gis gigwaji ilsutaqatioq. Nmittoqs'p tela'tegei ta'n goqwei tetapu'aq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Alt mimajuinu'g ta'n wigultijig Selusalemg teluejig, “Mu na ula ji'nm ta'n wejo'tmi'tij ne'pa'new. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ge' angamug. Etlewistoq mimajuinuigtug aq mo wen goqwei gis tlimagw. Etug jel iganpugultijig gejia'titl negm menaq na Nujiugs'tawi'wet, ta'n Gjinisgam petgimapnn ugjit ilgwenan ugtmimajuinumg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Gatu ta'n tujiw negm 'pgising ma wen 'gji'jiagul ta'n wejielij aq 'ms't geji'gw ta'n ula ji'nm wejiej.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Na Se'sus gegina'muet 'gjia'sutuo'guomg aq gesigawwet, “Tel'ta'sultioq menaqqajewei nenuioq aq gejioq ta'n wejiei. E'e nenuioq aq ap ta'n etli neps'tgwa'tasiap. Gatu ni'n pas'g na nutagnutmewinu ugjit ta'n wen mo gejiawoq aq negm na teliaqewei. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Gatu ni'n geji'g muta ni'n wejiei negmeg aq negm petgimip.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Na tujiw wejo'tmi'tij ugsua'lanew pas'g mo gis tala'la'tigupnn muta me' menaq tetaputestnugup. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gatu pugwelgig ta'n etl mawie'tij na getlams'tua'titl aq teluejig, “Na ji'nm ta'n Gjinisgam petgimaj ugjit ugs'tawian ugtmimajuinumg, ma aji 'ms'gi'gtnugul 'lgowaqann gis tla'tegetal aq ula ji'nm ta'n gis tla'tegej. Amuj na ula ji'nm.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na Palasiaq nutmajig mimajuinu'g gim mawagnutma'tijig wegla ugjit negm. Etna na ugjit negmow aq iganpugultijig patlia'sg elgima'tipnig alt sma'gnisg ugjit ugsua'lanew Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ta'n tujiw peita'titeg, Se'sus etl tlimaji mimajuinu'g, “Wijitgweiultoqs'p me' gijga'ji'jg, na tujiw 'nqalultoqs'p aq lia's ta'n wen petgimip. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gwiluitoqs'p gatu ma we'ji'woq muta ta'n i'ttes ma gilew gisi 'lta'woq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Na Lesui'paq iganpugultijig telimtultijig, “Tami ta getu liet ta'n ma ginu we'jia'gw? Lietew Gli'gewaq ugjiganmuaq ta'n Lesui'paq wigulti'tij aq gina'muataq aq we'gaw ta'nig mo Lesui'peulti'gw? ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Teluet, ‘Gwiluitoqs'p gatu ma we'ji'woq aq ma gisi 'lta'woq ta'n eliei.’ Goqwei etug getu tlimugsi'gw?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ugtejgewei na'gweg na pestie'uti na mawi espe'g. Na na'gweg Se'sus gaqama'sit aq gesigawewistoq, “Ta'n wen getu samqwat, jugu'ej ni'neg aq ni'n ignmua's ta'n tl samqwatew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ta'n tel wi'gas'g Gjinisgam ugtwi'gatigng ugjit ni'n, ‘Ta'n wen getlams'tasit ni'neg geggung iapjiwewei mimajuaqan aq gis tlimaji igtigig ta'n tl samqwataq glaman guguntaq iapjiwewei mimajuaqan. Pa na wijei aq tqapo'q ta'n ma niwianug gatu sipuji'jl wet neia's'gl.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Se'sus wesgumapnn na Wejuli Nisgaml, ta'nig getlams'tasultijig 'msnataq. Etna na tujiw na Wejuli Nisgaml menaq mesna'tigusnn muta Se'suguli menaq wenagiegus ugjit apaji gepmite'lmugsin wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Alt eimu'tijig mimajuinu'g nutua'titl teluelitl aq teluejig, “Ula ji'nm na menaqqajewei iganigjitegewinu ta'n 'pgisintew gesgmnaq Nujiugs'tawi'wet!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Gatu igtigig teluejig, “Negm na Nujiugs'tawi'wet ta'n Gjinisgam petgimapnn ugjit ilgwenan mimajuinu'g!” Gatu ala igtigig teluejig, “Gatu na Nujiugs'tawi'wet ma negm ugjiegw Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Gis ewi'gas'g Gjinisgam ugtwi'gatigng, ‘Nujiugs'tawi'wet ugtaquttew Ta'piteg aq ugs'tqamuitew Petliemg ta'n Ta'pit wigip.’ ” Na toqo mo wijei tel'te'tmi'tij ta'n wenit Se'sus. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Na tujiw na mimajuinu'g nasgwia'tijig ugjit negma. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Alt getu ugsua'la'titl pas'g mo wen gis tala'lagul. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na sma'gnisg apaita'jig iganpugultijig patlia'sg ta'n eimu'tijig. Pipanimgwi'tiji, “Goqwei ugjit mo wejgwa'lawoqos?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Na sma'gnisg asitema'tiji, “Menaq wen telewistug 'st'ge' ula ji'nm.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Na Palasiaq pipanima'tijig, “Gis lue'wa'lugsioq elt gilew? ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mu wen ta'nig iganpugultijig gisna Palasiaq getlams'tasulti'gw Westaulgewilin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Gatu wegla mimajuinu'g ta'n mo geitua'tigul Mowisal ugt'tplutaqanm ulmaji ilsumaten.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nigotimus, ta'n gis elieteg Se'suseg aq nat nmiteg, newgte'jit negmow te'si'tij Palasiaq. Na telimaji, ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ta'n telteg 'gt'tplutaqanminu, ma gisi ilsumam'g ji'nm, gesgmnaq gis nutmuam'g ta'n gis tla'tegej.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Negmow gigtoqopita'jig aq na teli asitema'titl, “A' na gi'l elg wejie's'p Galaliewa'gig? Gwile'n aq gigji angapte'n ta'n goqwei ewi'gas'g Gjinisgam ugtwi'gatigng. Gji'tutes ma iganigjitegewinu ugjieg Galaliewa'gig na.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Na tujiw 'ms't wen enmiet wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Gatu Se'sus eliet na gm'tn teluisig Olipet. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na wapniaq Se'sus apsgwa'sit 'gjia'sutuo'guomg. Na pugwelgig mimajuinu'g mawita'jig gigjiw ta'n eimlij aq negm epa'sit aq poqji gina'muaji. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na nujigina'mua'tijig tplutaqan aq Palasiaq pegisula'titl e'pilitl ta'n mesna'tipnn ta'n etli sespo'tegelitl aq miawe'g gaqama'la'titl glaman 'ms't wen nmiatal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Telima'titl Se'susal, “Nujigina'muet, ula e'pit mesng't assma tl sespo'tegen. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","'Gt'tplutaqanminaq Mowis telimugsi'gup na telamugsit e'pit amujpa gun'tewto'q glapis 'np'g. Nige', taluen?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Na wet tluejig ugjit gistesguanew, glaman gisi lsutmua'tital. Gatu na Se'sus waqjupa'sit aq ewi'giget t'pgwanigtug, ugtluign e'w'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ge's gaqamulti'tij na'te'l etl mil pipanigesultijig, tegpaqpa'sit aq teliman, “Ta'n wen gilew te'sioq me' menaq pata'tegegw na gisi tqamatal na amgwesewei gun'tew.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Na tujiw ap waqjupa'sit ap ewi'giget t'pgwanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ta'n tujiw nutmi'titeg ula, ingute'jijig jiglita'jig ta'n gisiguultijig tmg. Se'sus pas'g esgwiet aq maw na e'pit ta'n gaqamit. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tegpaqpa'sit aq telimatl, “E'pit, tami eimu'tijig ta'nig getu 'lsutmasg'pnig. Je mu newgte'jit ta'n 'lsutmultew?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Na teli asitematl, “Saqamaw mo wen eimug.” Se'sus asitematl, “Aq mo ni'n elsutmulu. Gisinmietes nige'. Gatu mut piam pata'tegew!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ta'n tujiw Se'sus ap gelulateg mimajuinu'g, telimaji, “Ni'n na waseteg ugjit mimajuinu'g ula ugs'tqamug. Gisi ignmuataq iapjiwewei mimajuaqan. Ta'n wen majulgwalit ma oqonitpa'qigtug pmiegw gatu awna guguntew na waseteg ugmimajuaqanmg aq 'gjitutew ta'n gegnu mimajit.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Na Palasiaq telima'titl, “Nige' pas'g etl ginualsin aq etli egsuen. Ta'n goqwei etl tluen mo tali ugtapsuninug.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Se'sus asitemaji, “Moqwa', je tlia tl ginualsian, ta'n goqwei teluei na teliaq, muta geitu ta'n wejia'p aq ta'n eliei. Mo gilew geituoq ta'n wejia'p aq ta'n eliei. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Teli ilsutaqatioq ta'n tel nemituoq. Mo wen ni'n ilsumaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Gatu ilsutaqan, tetapu ilsutega's. Ntilsutaqanm tetapu'atew muta mu newgtugwa'lugow. Nujj ta'n petgimip wijitgweiwit. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ewi'gas'g 'gt'tplutaqanmuaq, ta'n tujiw tapusijig gis nemi'tij nat goqwei tliaq aq nuji ilsuteget ingutiw mil pipanimaji ugjit na aq wijei teluetij na tujiw geitu'g teliaq teluejig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Etlewistu ta'n weni aq nujj ta'n petgimip elt etlewistoq ugjit ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pipanima'titl, “Tami eig gujj?” Se'sus asitemaji, “Gilew mo nenuiwoq aq mo nenuawoq Nujj. Gatu nenuioq nenuaqoq elg Nujj.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Se'sus na 'ms't teluetl ge's etl gina'muej 'gjia'sutuo'guomg ta'n i' tepege'tij suliewei. Mo wen gisi ugsua'lagul muta menaq tetaputestnug iga'q. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Se'sus ap telimaji, “Jigla'sites aq gwiluitoqs'p ma gisi 'lta'woq ta'n eliei. 'Nputititoqs'p aq 'gtlue'utiwal ma apigsigtmugsiwoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Na tujiw Lesui'paq iganpugultijig pipanimtultijig, “Etug getu ne'pa'sit? Etna na ugjit wet tluet ma gisi 'lta'gw ta'n negm eliej.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Se'sus na telimaji, “Ni'n tleiawi wa'so'q gatu gilew tleiaultioq ula ugs'tqamug gatu ni'n mo tet tleiawiw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Etna na ugjit wet tlimuloq gilew 'npu'titoqs'p aq 'gtlue'utiwal ma apigsigtmugsiwoq glapis 'gtlams'tasultioq ni'n na newgte'ji ta'n Gjinisgam petgimip. Mu 'gtlams'tasultiwoq na tujiw gilew 'nputititoqs'p 'gtlue'utiwaq ma apigsigtuam'gig.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pipanima'titl, “Wenin ta gi'l?” Se'sus asitemaji, “Ni'n na ta'n wen gis tlimuloq mujga mawi amgweseweieg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Gisi ilsutmultoqs'p pugwelg ta'n goqweigtug aq elg gisi pugwe'l gina'multoqs'p, gatu ma tla'tegew muta pas'g teluei ta'n goqwei telimimg'p ta'n wen petgimip aq negm teliaq teluej.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mo gejia'tigul tli usgumalin ujjl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Glaman Se'sus telimaji, “Ta'n tujiw ni'n ta'n mimajuinualsiap unaqa'lioq gujjieweigtug, na tujiw 'gjittoqs'p ni'n na newgte'ji ta'n Nisgam petgimip. Mo etli tlimuluoq ni'n ta'n tel'ta'si gatu pas'g wesgutm ta'n goqwei Nujj gis gina'muip. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aq ta'n wen petgimip wijitgweiwit aq menaq naqaligw ugjit ngutugwa'lugwen muta apjiw tela'tegei ta'n goqwei tetapua'l'j.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pugwelgig ta'n nutua'titl Se'susal etl tluelitl wegla goqwe'l, getlams'tua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Na tujiw Se'sus telimaji Lesui'paq ta'nig getlams'tua'titl, “Pa na jigs'tmuioq ta'n tel gina'muei na gilew menaqqajewei nnaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Gjitutoqs'p teliaqewei ugjit Gjinisgam aq na teliaqewei gisa'lugsitoqs'p mu nugu gistejuultinew.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Teli asitema'titl, “Ninen wetagutmu'tieg Aplameg aq mo wen uggistejumultiweg. Goqwei wesgutmn ta'n tujiw teluen, ‘Mu nugu gistejuultinew’?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Se'sus telimaji, “Telimuloq, ta'n te'sit wen pata'teget na assumgwi'tij lue'uti, pa wijei aq gisteju. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Gisteju pas'g elugwet ugjit assusit mo ugtaligam ta'n pas'g goqwei ugtassusilitl gatu assusit uggwisl ugtaligam aq assutmlij 'ms't goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ni'n Gjinisgam uggwisl jigla'luloq ta'n teli assumugsioq lue'uti. Na tujiw menaqqajewei assumsultitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Geju'loq Aplameg wetagu'tmu'tioq, gatu alt te'sioq getu ne'pa'ioq, muta mo wel'te'tmuiwoq ta'n tel gina'muei. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Wesgutmap ta'n goqwei Nujj musga'tuip gatu gilew tela'taqatioq ta'n gujjuoq telimugsioq. Na teliaq telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Na teli asitema'titl, “Nujjinen na Aplam.” Se'sus asitemaji, “Aplam un'janultioqosn tla'taqatigoq na wijei 'lgowaqann ta'n negm tela'tegepnigl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Gatu wejo'tmoq gis ne'pa'inew aq pas'g ta'n goqwei tela'tega'p. Na telimuloqop teliaqewei ta'n nutmap Nisgamewigtug. Aplamoq mo na tela'tegegupneg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tela'taqatioq ta'n gujjuoq tela'tegep.” Teli asitema'titl, “Pas'g newgtungt nujjinen, Gjinisgam negm.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Se'sus na teli asitemaji, “Gjinisgam menaqqajewei gujjiewig'sn, 'gsaligoqpn muta ni'n wejiei Nisgamewigtug aq nige' tet eim. Petgimip mo wet jugu'ewap ugjit ni'n gatu negm petgimip. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Goqwei ugjit mo nestmu'tiwoq ta'n goqwei wesgutm? Etna na ugjit gisite'tmuoq mo jigs'tmuinew 'ntglusuaqanml. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mn'tu na gujjuoq. Ta'n goqwei gujjuoq tela'tegej na gilew tla'taqatitoqs'p. Na mawi amgweseweieg nut ne'pa'tegep aq menaq eimug teliaqeweigtug, muta mo teliaqewei ugtinneg eigtnug. Ta'n tujiw egsuej, tela'teget ta'n tele'g, muta negm nujiegsuet aq negmow na ujjual ta'nig nata' egsua'tijig. 'Ms't egsuo'qon wejiaq negmeg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Gatu ni'n telimuloq teliaqewei, etna na ugjit mo getlams'tuiwn.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Se'sus siawewistoq, “Wen eig ta'n gisi musga'tuitew gis ni'n pata'tegei? Pa na mo gis tla'tegewn, goqwei ugjit mo 'gtlams'tuiwoq? Lpa pas'g teliaqewei telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ta'n wen tleiawit Nisgamewigtug, jigs'tuatl Nisgaml ugglusuaqanml. Gatu gilew mo jigs'tmu'tiwoq muta mo tleiaultiwoq Nisgamewigtug, etna na ugjit.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Na Lesui'paq iganpugultijig na teli asita'pugua'titl Se'susal, “Gigwajiatieg ta'n tujiw telueieg gi'l na Samaliaewa'j aq mn'tu pitu'gwin. Amuj na Samaliaewa'juin aq mn'tu pitu'gwin.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Se'sus asitemaji, “Mo mn'tu pitu'gwigw ni'neg. Ni'n gepmite'lm'g nujj, gatu gilew mo gepmite'lmiwoq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mo algwilmu gepmitelgaqan ugjit ni'newe'n gatu Gjinisgam pualit gepmitelmugsin aq negm tetapu ilsuteget. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Telimuloq ta'n wen jigs'tmuij 'ntagnutmaqanml, ma' 'npmug iapjiw. Na teliaq telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Na telima'titl, “Nige' geju'leg 'gjitm mn'tu pitu'gwin 'gtinneg. Aplamo'q nepg'pnaq aq iganigjitegewinugi'g nepu'tipnig. Gatu gi'l tluen, ‘Ta'n wen jigs'tmuij 'ntagnutmaqanm ma' 'npmug iapjiw.’ ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Gi'l tel'ta'sin me' espe'n je mu nujjinenaq Aplamo'q ta'n nepg'pnaq aq me' espe'n je mu iganigjitegewinugi'g ta'n elt nepu'tipnig? Tal'ta'sin ta gi'l wenin?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Na tujiw Se'sus asitemaji, “Pa na gepmite'lsian 'ntgepmitelgaqanm 'lpa ma tepawgtinug. Gatu na newgte'jit ta'n gepmitelmit na negm Nujj. Na mawi ingute't ta'n gilew telui'toq Gnisgamemuoq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gilew menaq tami tl nenuawoq gatu ni'n nenaq. Pa na jijuaqa tluen ni'n ma nenuaq negm na tli nta egsua's pa wijei aq gilew. Gatu ni'n nenaq aq ni'n jigs'tmagal ugglusuaqanml. ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Gujjuoq Aplamo'q welgwijing'p pas'g tel'ta'siteg nmituital 'ntna'gwegm. Geitoqopneg wejgu'ei aq wel'ta'sipnaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Na Lesui'paq iganpugultijig telima'titl, “Gi'l je menaq na'nisgegipuna'wn aq gis nenuit Aplamo'q?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Se'sus asitemaji, “Telimuloq, teliaqewei. Gesgmnaq Aplamo'q ugs'tqamuigweg gis i'map.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Na tujiw megnmi'titl gun'tal ugjit gun'tewta'new aq ne'pa'new. Gatu Se'sus mimgwasit aq naqt'g 'gjia'sutuo'guomg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ge's Se'sus pemiej, nemiatl ji'nmul ta'n teli ugs'tqamuip nepapigwa'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Unaqapemg pipanimjig, “Nujigina'muet, wen ugtlue'uti gisa'laj ugjit negm tli ugs'tqamuin nepapigwa't. Negm gisna ungi'gug ugtlue'utiwoq?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Se'sus asitemaji, “Ugtlue'uti'l gisna ungi'gug ugtlue'utiwal mo gisa'la'tigupnn nepapigwa'lin. Weji npapigwa't glaman Gjinisgam ugml'gigno'tim gis musga'tuaten negmeg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ge's waseteg, amujpa siaw tla'taqati'gw Nisgamewei 'lgowaqan Gjinisgam ta'n petgimip. Oqonitpa'q wejgu'aq aq ma wen gis lugweg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ge's ugs'tqamug eim, gisa'laqig mimajuinu'g 'ns'tmi'tij teliaqewei ugjit Gjinisgam. Etna na ugjit telui'timg na Waseteg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ta'n tujiw gis tluej ula, Se'sus elusgatamit maqamigeg aq sisgu el'toq uglusgatignm e'w'g. Na tujiw amiputuaj ji'nmul ugpugugul. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Telimatl, “Naji gsispa'tu 'gpugugul na tetp'peg samqwan teluisig Sailoam.” (Ula glusuaqan Sailoam ta'n teli'sulti'tij pa wijei aq “petgimtl”.) Na tujiw na ji'nm eliet naji gsispa'toq ugpugugul. Apaja'ij, na wejgwi nemiteget. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wi'gmaq aq na mimajuinu'g ta'nig nemia'tipnn tl tawaqtmalipnn, pipanigesultijig, “Mu na ula ji'nm ta'n i' pmgopip aq i' tawaqtmap?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Alt teluejig, “Negm na.” Gatu igtigig teluejig, “Moqwa', mu na negm. Pas'g wijei telapewijig.” Na tujiw na ji'nm teluet, “Ni'n na ji'nm.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pipanima'titl, “Tal gis nemitegen?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Asitemaji, “Na ji'nm teluisit Se'sus eltoqop sisgu aq ama'tuip 'npugugul aq telimip, ‘Lia samqwanigtug teluisig Sailoam aq 'gsispa'tu 'gpugugul. Elia'p aji gsispa'tuan 'npugugul aq ta'n teli nqase'g gesispa'tuaneg 'npugugul, weji ulapianeg.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pipanigesultijig, “Tami eig?” Teli asitemaji, “Mo geitu.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Na tujiw ela'la'titl na ji'nmul ta'n i' nepapigwa'lipnn ta'n Palasiaq eimu'ti'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na na'gweg ta'n Se'sus el'toqop sisgu aq pana'tuapnn ji'nmul ugpugugul atlasmutigisg'g'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Na Palasiaq pipanima'titl na ji'nmul ta'n tel gis nemitegelij. Telimaji, “Iga'toqop sisgu 'npugug aq ni'n gesispa'tuap 'npugugul aq nige' nemitegei.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Alt Palasiaq teluejig, “Na ji'nm ta'n gis tla'teget na, mu gisi ugjieg Nisgamewigtug muta mo negm jigs'tmug atlasmutigisg'gewei 'tplutaqan.” Gatu awna igtigig teluejig, “Tal gis na ji'nm ta'n elue'winuij gis tla'tutal paqalaiwaqan pa wijei aq ulaal?” Etna na ugjit alt nigtuita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Na Palasiaq 'mjit newgt pipanima'titl na ji'nmul, “Gi'l teluen negm 'gpugugul pana'tas'g'pnn, gatu gi'l tal'ta'sin negm wen?” Na teli asitemaji, “Negm na iganigjitegewinu.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na Lesui'paq iganpugultijig me' mu getu 'gtlams'tua'tigul ugjit negm 'npapigwa'lin aq nige' gis nemitegen glapis natgima'tiji na ji'nm ungi'gug, ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","aq pipanima'tiji, “Ula na gilew 'ggwisuow? Teli ugs'tqamuis nepapigwa'n? Gatu nige' tal gis nemiteget.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ungi'gug na teli asita'puguejig, “Geji'g't negm 'ngwisinen aq geitueg teli ugs'tqamuip nepapigwa't, ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","gatu mo gejiaqat ta'n tel gis nemitegej gisna mo gejiaqat ta'n wen gis pana'tuatl ugpugugul. Pipanimug. Gis tepipuna't, gisi asitemugsitoqs'p negm.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ungi'gug ula teluejig muta jipala'tiji Lesui'paq. Muta Lesui'paq iganpugultijig gis wel'te'tmi'tip tuattesguaten a'sutuo'guomg ta'n wen teluet Se'sus na Nujiugs'tawi'wet. Gjinisgam petgimapnn ugjit ilgwenan ugtmimajuinumg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Etna na ugjit ungi'gug teluepnig, “Negm gis tepipuna't, pipanimug.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Na ta'puewei na iganpugultijig ap natgima'titl na ji'nmul ta'n ugs'tqamuilipnn nepapigwa'p aq telima'titl. “Gepmite'lm Gjinisgam ta'n teli npisin. Mut gepmite'lmu Se'sus. Gejig't lue'winuin.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na ji'nm asitemaji, “Mu tali gji'jiaq lue'winuin gisna mu. Newgte' ta'n goqwei geitu nepapigwa'iap aq nige' nemitegei.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pipanima'titl, “Gatu tala'lusg's? Tal gisi npitamas'g'sn 'gpugugul.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Na teli asita'puguet, “Gi's gis tlimuloq aq mo gilew jigs'tmutiwoqop. Goqwei weji 'gtu nutmoqop ap? Etug gilew getu unaqapemultioq?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Anmima'titl aq teluejig, “Gi'l eta negm unaqapeml, gatu ninen na Mowiso'q unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Gejig't Gjinisgam gelulapnn Mowisal gatu ugjit na ji'nm, Se'sus, mo tali gji'jiaqat negm ta'n wenij.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na ji'nm asitemaji, “We'gwi wigue'g gisi npilajig nepapigwo'ltijig mimajuinu'g gatu mo gejiawoq ta'n wenij. We'gwi paqalaiwioq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Gejig't Gjinisgam mu jigs'tuagwig lue'winu'g gatu jigs'tuajig mimajuinu'g ta'n gepmitelm'jig aq tela'taqatijig ta'n negm tel puatg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ta'n tujiw ugs'tqamu gisita's'geg glapis nige' menaq nutmam't wen gisa'lan na mimajuinu'l, ugs'tqamuilipnn nepapigwa'litl, nemitegelin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mo ula ji'nm ugjiegw Nisgamewigtug ma gis tla'tegegw.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Sesgwala'titl aq miluita'titl, aq telima'titl, “We'gaw gisi ugs'tqamuites, elue'winui't'p aq ali gtu gina'muieg ta ninen?” Toqo tewege'titl we'gaw a'sutuo'guomg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Se'sus nutmateg ta'n tel tuege'tij, gwiluatl aq ta'n tujiw we'jiateg, teluet, “Gi'l getlams'tasin ta ji'nm ta'n Gjinisgam petgimapnn?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ji'nm asitematl, “Tlimi ta'n wenij saqamaw, glaman gisi gtlams'tasites.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Se'sus telimatl, “Gis nemi't'p gi'l aq na ni'n ta'n etl agnutmaigw.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Na ji'nm teluet, “Gjisaqamaw, getlams'tm.” Aq nutgul'pa'sit Se'sugulieg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Se'sus teluet, “Weji pgisinap ula ugs'tqamug ugjit ignmuan ns'tuo'ti Nisgamewei ta'nig mo nestasulti'gw pa wijei aq gisa'lan nepapigwo'ltijig nmitaqatinew, aq musga'tuan ta'nig tel'ta'sultijig nestasultijig ta'n goqwe'l Nisgamewei mo nestasulti'gw aq mo goqwei nemitu'tiwgw pa wijei aq nepapigwo'ltijig.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Alt Palasiaq ta'nig eimu'tipnig nutua'tipnn teluejig ula aq pipanima'titl, “Etl tluen ninen na nepapigwo'ltieg?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Se'sus asitemaji, “Pa na mo ns'tasultiwoq ta'n goqwe'l Nisgamewe'l ma wen gisi ilsumugsiwoq. Gatu telueioq gisi ns'tasultioq ta'n goqwei Nisgamewei gatu mo getlams'tuiwoq na tujiw ilsumugsitoqs'p ta'n tel pata'taqatioq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Se'sus teluet, “Telimuloq, na mimajuinu'g ta'n mo e'wmug ga'qana'tas'g gatu asisapegit na 'llutaqan ugjit gim pisgwa'n ta'n jijgluewjig eimu'tilij, negm na gmutnes. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Na ji'nm ta'n weji pisgwa'j ga'qana'tas'g na negm nuji angwe'waji jijgluewjig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nujisgaqanet pana'tuaj na ga'qana'tas'g ugjit negm. Na jijgluewjig nutua'titl ta'n tujiw wigumaj aq ugjijgluewjmg el'ta'jig negmeg. Majulgwala'titl, ewi'tmuaj ugjijgluewjmg ugwisunmuaq aq tewo'lajig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Igana'sit aq ugjijgluewjmg majulgwaljig muta nestua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma majulgwala'tigul wen pilue'l gatu awna ugsmugtua'tital muta mu nestua'tigul. Teliaq na telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Se'sus mimajuinu'g telimaji ula a'tugwaqan, gatu mo nestua'tigul ta'n goqwei etl tlimgwi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Se'sus ap teluet, “Telimuloq, ni'n pa wijei aq na ga'qana'tas'g ugjit na jijgluewjig ta'n i' tli angweiatiji wela'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Igtigig igan peita'pnig gesgmnaq ni'n. Negmow gmutnesg gatu na jijgluewjig mo jigs'tua'tigupni.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","“Ni'n pa wijei aq na ga'qana'tas'g aq na mimajuinu'g pa wijei aq jijgluewjig. Ta'n wen getu pisgwa't wa'so'q amujpa weji pisgwa't ni'neg. Na ugs'tatew, pisgwa'tew aq tu'etew aq ul smaten. Pa na wijei aq jijgluewjig asuita'jig ga'qana'tas'g aq uls'maten. pa na wijei ni'n na ga'qana'tas'g ugjit mimajuinu'g wa'so'q aq weli angweiaqig aq ugs'tawia's. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gmutnes pegising ugjit gmutnen, ne'pa'tegen aq seioqwa'tegen. Ni'n weji pgisinap glaman gisi msnmu'titoqs'p iapjiwewei mimajuaqan aq ula mimajuaqan mujgajewei wajui guguntoqs'p. Na teliaq telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ni'n na menaqqajewei nuji angweiaqig jijgluewjig. Gelu'sit nuji angwe'waji jijgluewjig ul'te'tutew iga'tun ugmimajuaqanm ugjit ugjijgluewjmg. Etna na ula ta'n ni'n wel'te'tm tla'tegen. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","'Lgowinuj ugsmugwatew ta'n tujiw nemiaj paqtesml wejgu'elij aq nqalataq jijgluewjig muta mo negmeweg aq negm angweiwaji jijgluewjig ugjit pas'g apangitugsin. Etna na ugjit weji ugsmugwat. Na tujiw paqtesm wenaqietuajig aq se's'tesgua'jig jijgluewjig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","'Lgowinuj ugsmugwatew muta pas'g negm 'lgowinuj aq mo tali el'te'lmagwig jijgluewjig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ni'n na mujgajewei nuji angweiaqig jijgluewjig. Ta'n tel nenuij Nujj, aq ni'n ta'n tel nenaq na wijei nenaqig ntjijgluojmg. Negmow nenuijig, aq ni'n wel'te'tm iga'tun ntmimajuaqanm ugjit negmow. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ap eimu'tijig jijgluewjig ta'n ni'newe'g gatu mu eimu'ti'gw ula tet. Amujpa ni'n jugwo'la's. Negmow jigs'tuitaq. 'Ms't maw mawo'la's aq ni'n nuji angweiwa's. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Nujj gesalit muta wel'te'tm iga'tun ntmimajuaqanm ugjit negmow glaman ntmimajuaqanm gisi apaji msntes. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mo wen gisi ugsua'tuigw ntmimajuaqanm glapis ni'n tli ul'te'tman. Iga'tutes ntmimajuaqanm muta ni'n 'lpa na tel puatm. Geggunm ml'gigno'ti ugjit iga'tun aq geggunm ml'gigno'ti ugjit ugsua'tun. Nujj gisi ignmuip ml'gigno'ti ugjit na ula gis tla'tegen. Maw gigwajiaq telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ta'n tujiw wegla gis tlueteg na Lesui'paq ap nigtuita'jig ugjit ugglusuaqanml. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Pugwelgig teluejig, “Negm mn'tu'l geggunatl! Elue'wiet! Goqwei wet jigs'tuoq?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gatu igtigig teluejig, “Ji'nm mn'tu'l ugtinneg pisilij ma gis tlewistu 'st'ge' ula! Ma mn'tu gisa'laqul nepapigwa'litl ji'nmul nemitegelin.” Mo wijei teli angita'sultijig. Etna na ugjit nigtuita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na miawipug Se'sus eig'p Selusalemg ugjit na pestie'umg 'gjia'sutuo'guomei Selusalemg. Ula pestie'umg migwite'tmi'tij ta'n tujiw ujjuaqi'g ili tepgisa'tu'tipnig 'gjia'sutuo'guomg ugjit Gjinisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Newgt na'gweg ala'sit 'gjia'sutuo'guomg, na'te'l Salamano'q ugtusatimg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Na Lesui'paq mawita'titl ta'n eimlij aq maw gigtoqopugutua'titl. Teluejig, “Tali pgije'tew we'gaw elugwalieg? Telimieg ta'n wenin. Pa na gi'l na Nujiugs'tawi'wet ta'n Gjinisgam petgim'sg ugjit ilgwenan ugmimajuinumg, na menaqqajewei tlimieg!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Se'sus asitemaji, “Gis tlimuloqop gatu mo getlams'tuiwoqop. Ta'n goqwei tela'tegei Nujj ugwisunmg musga's'gt'tal ta'n weni. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Gatu gilew ma 'gtlams'tmu'tiwoq muta gilew mo ntjijgluewjmg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","'Ntjijgluewjmg nutuijig aq nenaqig aq negmow majulgwalitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ignmaqig iapjiwewei mimajuaqan aq ma' 'lta'gwig mn'tua'gig. Ma wen gisi ugsua'tuigwigw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Muta Nujj gisi ignmuipnig aq negm me' espe'g je mu ta'n pas'g wen. Ma wen gisi ugsua'tuigwigw muta nujj ugpitng epultilijig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ni'n aq Nujj newgte'jieg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mjit newgt na Lesui'paq megnmi'titl gun'tal ugjit gun'teugta'new. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Na tujiw Se'sus telimaji, “Gis tela'tega'pnn pugwelgl 'lgowaqann 'gsisguaq ta'n Nujj ignmuip tla'tegen. Goqwei weji 'gtu gun'teugte'ioq ugjit ula ta'n tela'tega'pn?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Na Lesui'paq asitema'titl, “Mo getu gun'tewto'lueg ta'n tel tla'tege't'p gelu'lg 'lgowaqan gatu ugjit ta'n teli egsuaqanimt Gjinisgam aq anmima'mt aq mo gepmite'lmawt. Gi'l na pas'g ji'nm gatu teli ugsualsin 'st'ge' Nisgamewin.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Se'sus asitemaji, “Ewi'gas'g Gjinisgam ugtwi'gatigng ta'n Gjinisgam teluet, ‘Nisgameultioq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Geitu'g ta'n Gjinisgam ugtwi'gatign telueg na teliaq iapjiwewei. Gjinisgam telui'tapni, ‘nisgameultijig’ na mimajuinu' ta'n ignmuapni ugtagnutmaqanm. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Gatu ugjit ni'n, Nujj megnip aq petgimip ula ugs'tqamug. Tal gis gilew tlueioq egsuaqanimt Gjinisgam muta ni'n telueiap ni'n na Gjinisgam uggwisl? ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mut 'gtlams'tuinew, mo tla'tegewan nujj ugtlgowaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Gatu tla'tegeian, je tlia mo 'gtlams'tuiwoq, 'gtlams'tmugoq ntlgowaqann glaman 'gji'tutoq nujj ni'neg eig aq ni'n eim negmeg. Na tujiw me' uli gji'tugoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","'Mjit newgt wejo'tmi'tij ugsua'lanew. Pas'g mo gis tla'taqati'gw muta ejigla'sit aq naqalaji. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Na tujiw Se'sus ap apaji asoqoma'sit na sipu teluisig Jol'tan, ta'n Sapatis i' tl sign'tuep aq siawqatg na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Pugwelgig mimajuinu'g peita'jig negmeg, telimtultijig, “Sa'n mo tela'tegegupnn mesgi'gl 'lgowaqann, gatu ta'n te's'g goqwei teluep ugjit ula ji'nm na teliaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aq pugwelgig mimajuinu'g na'te'l getlams'tua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Etna na ula ji'nm teluisit Lasalas, gesnugwat. Wigit na gutanji'j teluisig Pettani. Mali aq umisl Malta na Lasalas wijigatijig. Mawgatmu'tijig. ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Me' enmiaq na ula Mali guta'tuatew amjaqto'suti Se'susal uggwatg aq ga'smuatl uggwatl usapun e'w'g. Etna na ugjignaml Lasalasal ta'n gesnugwalitl.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Na wijig'tijig e'pijig elgitmua'tij Se'susal ula agnutmaqan, “Gjisaqamaw, na gitap ta'n gesalt mawi gsnugwat.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ta'n tujiw Se'sus nutgeg ula agnutmaqan na teluet, “Ta'n teli gsnugwaj wet tliaqap ugjit Gjinisgam uggepmitelgaqanm. Musga's'gtn glaman Gjinisgam uggwisl 'gjigepmitelmaten. Etna na ugjit mo Lasalas etl gaqiegw na'te'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na Se'sus gesalaji Maltaal, uggwe'ji'tl aq Lasalasal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Gatu ta'n tujiw mesngeg agnutmaqan Lasalas 'gsnugwan, me' siawqatg ta'n eig tapuguna'q. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Na tujiw unaqapemg telimaji, “Apaita'nej Jutiaewa'gig.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Unaqapemg asitema'titl, “Nujigina'muet, gejigew Lesui'paq iganpugultijig getu gun'teugtesg'pnig aq ap nige' gisita'sin apaja'sin na'te'l?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Se'sus telimaji, “Te's na'gweg newgtisga'q jel ta'pu ajietl etegl ta'n waseteg. Pa na ji'nm ala'sij miaw na'gweg ma ali pjitaqamagw muta waseteg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Gatu ta'n tujiw ala'sij tepgig 'pjitaqamatew muta oqonitpa'q. Mo gis nemitegegw. Amujpa ala'si aq elugwatm 'ntlugowaqanm ge's gis tla'tega's.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ula na Se'sus telimaji. Toqo ap angu tluet, “Gitapinu Lasalas nepat gatu ni'n lia's aq tugwa'la's.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Unaqapemg asitema'titl, “Amuj pem ila'sit, na tli uli npaj.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Getloqo Se'sus wesgutg'p ugjit Lasalas 'npmn gatu negmow tel'ta'sultijig pas'g 'npanin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Etna na ugjit menaqqajewei telimaji, “Lasalas nepgaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ugjit gilew wel'ta'si mo eimu ta'n tujiw nepgeg glaman 'gtlams'tmuitoqs'p ta'n tujiw nemituoq ta'n tliatew. Gatu nige' 'lta'nej negmeg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Na Tuma (ta'n telui'tut, 'Tqope'j), telimaji ap igtigig unaqapemg “Wije'wanej nujigina'muet glaman mawi 'npu'titesnu maw negm.” Na tujiw naqtmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ta'n tujiw Se'sus pegisingeg Pettani telima'titl, Gis ne'wguna'q Lasalas gis utqutalugsin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Weja'tegemg Selusalemg glapis Pettani maw suel tapu'gl loqtnn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Aq pugwelgig Lesui'paq gis peita'pnig ugjit nat nmianew Maltaal aq Malial. Getu' apgnua'lanew ta'n teli nplij ugjignamual. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ta'n tujiw Malta nutgeg Se'susal wejgu'elitl, tewiet aq naji a'suguatl, gatu Mali siawqatg wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Malta telimatl Se'susal, “Gjisaqamaw, I'mu's'p 'njignamaq mo 'npmuisoq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Gatu geitu, je tlia nige', Gjinisgam ignmultew ta'n goqwei pipanimj.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Se'sus telimatl, “Gjignam apaji unaqa'sitew utqutaqane'gati aq apaji minunsitew. Geitu'n?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malta teli asitematl, “Geitu minunsitew ugtejgewei na'gweg ta'n tujiw Gjinisgam apaji minua'laj mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Se'sus telimatl, “Ni'n na ta'n gisi apaji unaqo'la's mimajuinu'g aq ignmua's iapjiwewei mimajuaqan. Ta'n wen getlams'tasit ni'neg, mimajitew je tlia np'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ta'n wen mimajit aq getlams'tasij ni'neg, ugtejgewei na'gweg iga'q aq apaja'sian, ma 'npug. Ula getlams'tasin?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Teli asitematl, “Gjisaqamaw, teliaq teluen. Getlams'tasi gi'l na Nujiugs'tawi'wet ta'n Gjinisgam petgimapnn ugjit ilgwenan ugtmimajuinumg, Gjinisgam uggwisl ta'n wen sa'q esgmalg't.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ta'n tujiw Malta gis tlueteg ula na apaja'sit aq apsgwa'sit wiguaq aq gim wigumatl uggwe'ji'tl Malial. Gimewistoq aq telimatl, “Nujigina'muet pegising aq getu nmi'sg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ta'n tujiw Mali nutgeg ula, smtug tewiet aq naji a'suguatl Se'susal. ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Se'sus menaq iga'qus na gutanji'j gatu me' eig'p ta'n Maltaal etli ultesguapnn.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na Lesui'paq ta'n eimu'ti'tij na wen'ji'guomg maw Mali etli apgnua'la'titl Malial. Ta'n tujiw nemia'titeg wenaqa'silitl aq jaqal tu'elitl na majulgwala'titl. Tel'ta'sultijig elielitl utqutaqanmg naji gsigawtemilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mali pegising ta'n Se'susal eimlij. Nemiaj na el nutgul'pa'sua'latl aq na teluet, “Gjisaqamaw i'mu's'p ula tet mu 'njignamaq 'npmuisoq!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Se'sus nemiatl etli gsigawtemilitl aq na Lesui'paq ta'n pejuwije'wa'titl gesigawtemultijig. Na tujiw ewlgwija's'g uggamlamun aq ewlite'lmaji. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Pipanimaji, “Tami tet etli utqutaloqos?” Na teli asitema'titl, “Gjisaqamaw jugu'a aq nat nmitu ugtutqutaqanmg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Na tujiw Se'sus ugsagpigunml guta'tigul. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Etna na ugjit Lesui'paq teluejig, “Nemituoq ta'n tetuji gsalaj.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Gatu alt teluejig, “Gisa'lapnn nepapigwa'litl ji'nmul nemitegelin. Goqwei ugjit mo gisa'laqusnn Lasalasal mu 'nplin?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ula telueliteg, Se'sus me' piam ewlgwija's'g uggamlamun. Eliet ugtutqutaqanmg ta'n gun'tew sapalqe'g, 'npuinu lame'g elising. Mesgi'g gun'tew gep'joqteg ta'n weji pisgwita'mg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Se'sus melgimaji, “Jigla'tug na gun'tew!” Malta ta'n ugjignaml neplipna, teli asitematl, “Gjisaqamaw gis ne'wiguna'q gisi utqutalut. Gis poqji sugul'gat aq wejima't.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Se'sus telimatl, “Migwite'te'n na ula telimulap! Nmitutes Gjinisgam ugml'gigno'tim, 'gtlams'tmn.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Na tujiw ejigl te't'pja'tu'tij gun'tew. Se'sus wenaqapa'sit aq teluet, “Nujj miwatmul ta'n tel jigs'tuin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Geitu apjiw jigs'tuin gatu wet tluei ugjit na mimajuinu'g ta'n eimu'tijig, glaman 'gtlams'tmu'titaq gi'l petgimip.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ta'n tujiw ula gis tlueteg, gesigaw wigumatl, “Lasalas 'gtaqqa'si!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na ji'nm ta'n nepg'p getaqqa'sit. Te'tepjepilasit ta'n telgi'g wape'g atla'wegn. Ugpitnn aq uggwatl tepgisi ajijgopitegl atla'wegnigtug aq atla'wegn ajijgopiteg ugsisgug. Se'sus telimaji, “Apgwa'lug aq iga'lug.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pugwelgig Lesui'paq ta'n peji mittugwala'titl Malial ugjit apgnua'lanew nemitu'tij ta'n Se'sus tela'teget aq getlams'tua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gatu alt apaita'jig ta'n Palasiaq eimu'tilij aq telima'tiji ta'n Se'sus gis tla'tegej. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Na tujiw Palasiaq aq iganpugultijig patlia'sg mawi ultesgatultijg. Pipanimtultijig, “Tala'taqatitesnu? Ula ji'nm 'lpa tela'tegetl pugwelgl paqalaiwaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Siawi ignmug tla'tegen ula paqalaiwaqann 'ms't wen 'gtlams'tuataq aq majulgwalataq. Na tujiw Lo'mewaq assusultijig peita'taq aq gaq seioqwattaq 'gjia'sutuo'guomg aq seioqwa'lataq ta'n te'sijig 'gmimajuinuminaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Newgte'jit negmow teluisit Gaiapas, na espe'g patlia's na newgtipunqeg, teluet, “Elue'wia'tioq! Mo goqwei geituoq? ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Me' gelu'lgt'tew ugjit ginu pas'g newgte'jit ji'nm 'np'g ugjit mimajuinu'g je mu 'ms't mimajuinu'g gaq seioqwa'toq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mo negm gisite'tmug'p ta'n tel tluej. Negm na espe'g patlia's na newgtipunqeg. Igan gnua'teget ta'n Se'sus tli np'tew ugjit Lesui'paq ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aq mo pas'g ugjit negmow gatu elg ugjit mawo'lan Gjinisgam ugtmimajuinumg ta'n al se's'ga'tmu'tijig ula ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Weja'tegemgeg na na'gweg na Lesui'paq assusultijig angite'tmi'tij ta'n tl ne'pa'new Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Se'sus puni ala'sit mimajuinuigtug aq naqt'g Selusalemg. Mo ala'sigw Jutiaewa'gig gatu eliet na gutanji'j teluisit Eplaim ta'n gigjiw eteg paqtaqamigtug. Aq na'te'l wijitgweiwaji unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tel gne'ji'j na Lesui'paq ugpestiewtimuoq Siawa'timgewei pem gigja's'g aq pugwelgig mimajuinu'g weita'jig ta'n telgi'g Lesui'pewa'gig. El'ta'jig Selusalemg ugjit tla'taqatinew ta'n telteg 'tplutaqan. Amujpa waqama'sultitaq Nisgamewigtug, gesgmnaq na pestie'uti iga'qtnug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Getu' nemia'titl Se'susal aq ge's al mawita'tij 'gjia'sutuo'guomg na pipanimtultijig. “Tal'ta'sioq? Ma ta 'pgisinug ula pestie'umg?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Na iganpugultijig patlia'sg aq Palasiaq tewaggitmi'tij na glusuaqan ugjit ta'n wen gejiatl ta'n Se'susal eimlij amujpa gegnua'teget glaman ugsua'lataq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na asugomtesuguna'q gesgmnaq Siawa'timgewei iga'qtnug, Se'sus eliet Pettani, ta'n Lasalas wigip. Negm na ji'nm ta'n Se'sus apaji minua'lapnn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mijjuaqan ignmua'tipnn ugjit negm na'te'l. Malta etli apoqonmuet p'ta'utigtug aq Lasalas pemgopit p'ta'utigtug maw Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Na tujiw Mali pegisulatl pu'taiji'tl waju'pelitl ta'n mawi mgo'tig amjaqto'suti. Wejitas'g poqtaqiaq nalt. Newgt 'ngatign te's'g pijiguta'tas'g pu'taiji'jigtug. Guta'tuaj amjaqto'suti Se'susal uggwatg aq ga'sumuatl usapun e'w'g. Na weljemaq amjaqto'suti se'so'qweg wen'ji'guomg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na tujiw newgte'jilitl Se'sus unaqapeml teluisilitl Suta Isgaliot, ta'n 'ntuisgalatal Se'susal, teluet, ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Goqwei ugjit ula amjaqto'suti mo netuisgetas'gtnugus. Tepawgtig na suliewei ta'n ne'pa'tun newgtipunqeg, aq na suliewei gisi ignmuanesoq na ewle'jultijig?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Na ula wet tluet muta gmutnesuip. Ango'tg'p suliewei aq i' tli apoqonmasip. Mu gis tluet ta'n tali el'telmagupni ewle'juinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Gatu Se'sus teluet, “Punaje'w. Na wet tla'tegep ugjit gisgajugtmuin ta'n tli utqutaliten. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Apjiw gugunatoqs'p ewle'jultijig mimajuinu'g, gatu ni'n ma iapjiw i'mu ta'n eimoq. Na maw gigwajiaq telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Pugwelgig Lesui'paq nutmajig Se'susal i'mlin Pettani aq el'ta'jig na'te'l. El'ta'jig mu pas'g ugjit Se'susal gatu elt getu nmianew Lasalasal ta'n Se'sus apaji minua'lapnn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Na tujiw iganpugultijig patlia'sg gisita'sultijig elt ne'pa'new Lasalasal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Muta pugwelgig Lesui'paq puna'la'tiji iganpugua'tliji awna getlams'tua'titl Se'susal ugjit ta'n goqwei teliaqap Lasalasal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na wapg pugwelgig ta'n peita'pnig ugjit na Siawa'timgewei Pestie'uti nutma'tij Se'susal jugu'elin Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Na tujiw weji tmsmi'titl 'psetgun temasgo'tu'titl miti'sigtug teluisit palm aq tewita'jig naji a'suguanew Se'susal. Sesgu'tijig, “Miwatmuanej Gjinisgam aq emtoqwalanej. Gjinisgam gepmitelmaj ta'n wen wejgu'elitl ugwisunmg. Gjinisgam gepmitelmaj Isle'laq ugtelege'witemual!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Se'sus pem wejgu teppitl te'sipowji'tl ta'n we'jia'tipnn, ta'n telueg Gjinisgam ugtwi'gatign, ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mimajuinutut! Saianewaq! Mut jipalanew! Angaptmug! Ta'n wen 'gtelege'witemultitoqs'p wejgu'et wantaqo'tigtug. Wejgu teppitl te'sipowji'tl.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Unaqapemg mo nestmu'tigupnig na tujiw. Gatu ta'n tujiw Se'sus gisi unagieteg aq elieteg wa'so'q na tujiw migwite'tmi'tij ta'n telueg'p Gjinisgam ugtwi'gatign ugjit ula. Aq migwite'tmi'tij ta'n wet tla'taqati'tij ugjit negm. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na mimajuinu'g, ta'n wijitgweiwatipnn Se'susal ta'n wigumateg Lasalasal ugtutqutaqanmg aq apaji mimajua'lapnn siaw teluepnig ta'n goqwei gis nemitu'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Etna na ugjit mimajuinu'g a'sugua'titl muta nutma'tipnig ta'n gis lugwatg'pnn mesgi'gl 'lgowaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Na tujiw Palasiaq telimtultijig, “Angaptmug, nentu'gweg! Mo un'ji el'ta'gw! 'Ms't ta'n te'sijig elue'wia'tijig aq majulgwala'titl.” Na wegla teluepnig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Etna na na'te'l alt Gli'gewaq mawi 'lta'pnig Selusalemg ugjit na Siawa'timgewei pestie'uti ugjit emtoqwalanew Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","El'ta'jig Pilipeg negm ta'n tleiawit na gutan Petse'ta Galaliewa'gig. Teluejig, “Saqamaw getu nemi'g'tt Se'sus.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","El'ta'jig maw Pilip aq nat tlimatl Antle'al aq na tujiw el'ta'jig nat tlima'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Se'sus asitemaji, “Tetaputesg iga'q ugjit ni'n na ji'nm ta'n Gjinisgam petgimip aq mimajuinualsiap mawi gepmite'lmugsin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Teliaq telimuloq, amujpa 'np'tes. Pa na wijei aq gulumgwei 'sginmin na glapis iga'taqatmg maqamigeg aq 'np'g, pas'g newgte' 'sginmin. Gatu ta'n tujiw saqaliaq na tujiw nigweg aq minitew aq me' pugwelgt'tew. Pa wijei aq ula 'sginmin amujpa ni'n 'np'tes. Na teliaq telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“Na mimajuinu ta'n tela'toq ugmimajuaqanm ta'n tel puatg, na 'n'tutew, gatu awna na mimajuinu tela'toq ugmimajuaqanm ta'n Gjinisgam tel puatg, 'msntew iapjiwewei mimajuaqan wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Getu wen 'gtu nnaqapemij, tlimug jugwita'tij aq majulgwali'tij ni'n glaman 'ntlugowinumg i'muttaq ta'n ni'n eim. Nujj gepmitelmataq ta'n wenig elugowijig. Teliaq na telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Nige' 'ngamlamun ewlgwija's'g aq etug talua's? Etug tlueg, ‘Nujj ugs'tawi, ta'n goqwei getu tliaq glaman ma tlianug ni'neg. Gatu etna na ugjit wet jugu'a'p ugjit saputa'sin ula ulmajo'qon. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Glaman tlua's, ‘Nujj, gisa'tu 'gwisunm gepmite'tas'gtn.’ ” Na tujiw Gjinisgam metewistoq wa'so'q teluet, “Gis gepmite'tmap aq ap gepmite'ttes.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na mimajuinu'g ta'n alpugua'tiji, nutua'titl aq teluejig, “Gaqtugwaqig.” Igtigig teluejig, “Ansale'wit gelulatl.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Gatu Se'sus telimaji, “Wet nutuoqop Nujj mo ugjit ni'n gatu ugjit gilew 'gtlams'tuinew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tetaputesg iga'q ugjit na mimajuinu'g ula ugs'tqamug ilsutasultinew aq na iganpuguit ula ugs'tqamu, na mn'tu, pegwato'tg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ta'n tujiw unaqa'liten gujjieweigtug pugwelgtaq mimajuinu'g pejo'l'gig ni'neg.” ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wet tluet ula ugjit musga'tuanew ta'n tli amasgipnnaten ta'n tli np'tew.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Na mimajuinu'g asita'pugua'titl, “Gjinisgam ugtwi'gatign telimugsieg Nujiugs'tawi'wet ta'n Gjinisgam petgimapnn ugjit ilgwenan ugmimajuinumg iapjiw mimajitew. Tal gis tluen na ji'nm ta'n mimajuinualsip amujpa unaqa'laten gujjieweigtug aq 'np'tew. Wen ta u't ji'nm ta'n mimajuinualsip? Tel'ta'sultieg negm na Nujiugs'tawi'wet.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Se'sus asitemaji, “Amujpa na siawi 'lta'gw ta'n pemi lta'ioq ge's waseteg glaman mo oqonitpaqianug gesgmnaq peita'woq ta'n el'ta'ioq. Ta'n wen pemiet oqonitpa'qigtug ma nmitug ta'n eliej. Ni'n na ta'n wen ignmuloq waseteg aq musga'tuloq ta'n 'lta'goq Nisgamewigtug pas'g me' gijga'ji'j wasetew ugjit gilew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Glaman 'gtlams'tasultigw ni'neg ge's eim ta'n eimoq. Na tujiw gugunmuitoqs'p 'ntwasetegm 'gtinnewaq.” Na ta'n tujiw tlueteg ula, maja'sit aq mimgwas'gtuaji ali gasigtuaji. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Je tlia gis lugwatg ta'n te's'gl mesgi'gl 'lgowaqan ugsisguaq, mo getlams'tua'tigul. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Glaman ta'n iganigjitegewinu Aiseiao'q gis tluet, na tliatew, “Gjisaqamaw, wen ta'n getlams'tg 'gtagnutmaqanminen? Gjisaqamaw musga'tuaji mesgi'gl 'lgowaqan, gatu wen ta'n gisi gji'jiatl Gjisaqamawul ugml'gigno'tim?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Etna na ugjit mo wen gisi gtlams'tmug aq Aiseiao'q ap teluep, ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mo getu 'ns'tasulti'gw aq Gjinisgam gisa'laji melgatpa'tinew aq ilta'tuaji ugtangita'suaqanmual glaman mo gisi ns'tasulti'gw. Teluet, ‘Mo getu 'lta'gw ni'neg ugjit 'npilan. Na gis tliaq muta mo getu 'gtlams'tuigw.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aiseiao'q ula teluepnaq aq wesgumapnn muta nemituap Se'susal gepmite'lm'gwi'tital ta'n tujiw westaugsi'gweg. Wesgumapnn na ji'nmul ta'n Gjinisgam petgimatl ugjit ugs'tawian ugtmimajuinumg aq ta'n tel gepmitelmut. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","We'gaw tlia pugwelgig Lesui'paq iganpugua'tiji getlams'tua'titl Se'susal, gatu mo wesgutmi'ti'gw mimajuinuigtug muta jipala'tiji Palasiaq ta'n teluepnig, “Tuege'tital wen 'gjia'sutuo'guomg ta'n getlams'tg negmeg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Me' gesatmi'tip mimajuinu'g ul'te'lmugsinew je mu ul'te'lmugsinew Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na Se'sus gesigawewistoq, “Ta'n wen getlams'tuit mo pas'g ni'n getlams'tuit gatu elt negm ta'n petgimip. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ta'n wen nemi't, elt nemiatl ta'n wen petgimip. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ni'n na ta'n ignmaqig waseteg mimajuinu'g. Wejgu'eiap ugs'tqamug pa wijei aq waseteg ta'n wen getlams'tasit ma oqonitpa'qigtug i'mug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ta'n wen nutmuij 'ntglusuaqanm aq mo jigs'tmug ma ilsumaq. Weji pgisinap ugjit ugs'tawian mimajuinu'g mo ilsuman. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ta'n wen mo menuaqalig ni'n aq mo wesua'tuig 'ntglusuaqanm eig newgte'jit ta'n ilsumatal. Na glusuaqan ta'n wesgutmap, ilsumgutaq ugtejgewei na'gweg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ula tliatew muta wegla mo ni'n 'ntangita'suaqanm't'pn gatu Nujj ta'n petgimip telimip 'ms't goqwei ta'n telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Geitu ta'n goqwei telimip 'pgisitugsitoqs'p iapjiwewei mimajuaqan. Ta'n goqwei telimuloqop na Nujj telimip ugjit tlimulinew. Na teliaq telimuloq. Geji'g ta'n wen Nujjl jigs'tuatl na apji mimajitew.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Na ugtejgewe't'p na'gweg glapis na pestie'uti Siawa'timgewei. Se'sus geitoq tetaputesg iga'q ugjit negm 'nqatmn ula ugs'tqamu aq lien ujjeg. Apjiw gesalajig ta'nig negmewe'g ula ugs'tqamug aq enmi gsalaji aq glapis ugtejgewei. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Negm aq unaqapemg etl uloqotalultijig. Na tujiw mn'tu wet nu'gwalatl Sutaal, Simon Isgaliot uggwisl, ugjit 'ntuisgetun Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Se'sus geitoq ujjl ignmat'p ml'gigno'ti ugjit 'ms't goqwei assutmn. Geitoq Nisgamewigtug wejiet aq ap apaja'sitew Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Se'sus weji unaqa'sit p'ta'utigtug. Mena'latl uggotmual aq gigtoqopilg gasigo'suti negm ugtassuign. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Na tujiw ta's'g samqwan guta'toq nuji ugsispasutio'qigtug aq poqji gsispa'tuajig unaqapemg uggwatuaq aq ga'sumuaji e'w'g na gasigo'suti gigtoqopisij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iga't Simon Pie'leg ta'n telimtl, “Gjisaqamaw getu 'gsispa'tuin 'ngatl?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Se'sus asitematl, “Mo geitu'n nige' ta'n etl tla'tegei gatu me' enmiaq ns'tasites.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pie'l na teluet, “Ma ignmulu 'gsispa'tuin 'ngatl, nige' gisna ta'n pa tujiw!” Se'sus asitematl, “Mo 'gsispa'tuluan 'ggatl ma nugu gis nnaqapemiun.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Pie'l na teli asitematl, “Gjisaqamaw, mut pas'g 'gsispa'tuin 'ngatl. Elg 'gsispa'tui 'npitnn aq nun'ji.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Se'sus teluet, “Ta'n wen gis gisapalsit aq ala'sij, pas'g puatg uggatl 'gsispa'tugsin ugjit waqame'n. 'Ms't waqamo'ltioq pas'g newgte'jit.” ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Na gis geitoqop ta'n wen 'ntuisgalgutal. Etna na ugjit na wet tluet, “'Ms't waqamo'ltioq Nisgamewigtug pas'g newgte'jit.”) ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ta'n tujiw uggwatual gaqapa'tuateg, Se'sus apat nasa'latl pitoqsilitl uggotm aq apaja'sit ta'n epip p'ta'utigtug. Pipanimaji, “Nestmu'tioq ta'n gis tla'tegei ugjit gilew? ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Telui'tioq nujigina'muet aq Gjisaqamaw, na tetapui'tioq aq tetapua'taqatioq muta ni'n na. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Gisapa'tuloqol 'ggatual ni'n ta'n Gjisaqamaw aq nujigina'muet gilew 'gsispa'tatultigoq 'ggatual aq mawi apoqonmatultigoq ta'n tel lugutioq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Gis musga'tuloqop ta'n tla'tagatitoqs'p glaman gilew tla'tagattoqs'p ta'n ni'n tela'tega'p ugjit gilew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Telimuloq, ‘Lugowinu mu aji espeiugw je mu ugtassusiteml aq nutagnutmewinu mu aji espeiug je mu ta'n wen petgimtl.’ Teliaq na telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nige' geituoq ula teliaqewe'l. Pa na tla'taqatioq Gjinisgam ul'te'lmugsitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mo 'ms't wesgumuluoq, geji'gig ta'nig gisi mgngig. Gatu amujpa na tliatew ta'n Gjinisgam ugtwi'gatign telueg, ‘Newgte'jit ji'nm ta'n toqwataleg 'gtanitew.’ ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nige' ula telimuloq gesgmnaq telianug glaman ta'n tujiw tliaq 'gtlams'ttoqs'p ni'n na newgte' ta'n apjiw eim. Gesgmnaq ugs'tqamu gisita's'gtnugweg eimap, nige' eim, aq apjiw i'ttes. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ta'n wen wel'ta'sualatl ta'n pas'g wen ni'n elgimg, elg wel'ta'sualit ni'n ta'n Gjinisgam petgimip. Aq ta'n wen wel'ta'sualit ni'n wel'ta'sualatl Nujjl ta'n wen petgimip. Teliaq na telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ta'n tujiw Se'sus gis tlueteg ula mawi ewlgwija's'g uggamlamun aq teluet, “Telimuloq teliaqewei newgte'jit te'sioq 'ntuisgalitew.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Unaqapemg angamtultijig aq mo gejia'tigul ta'n wen wesgumatl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Newgte'jilitl unaqapeml ta'n Se'sus gesalatl pemgopilitl gigjiw Se'suseg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Pie'l matgwetuatl aq telimatl, “Pipanim ta'n wen wesgumatl.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Na tujiw na unaqapeml gigja'silitl Se'sus aq pipanimtl, “Wen ta na Gjisaqamaw?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Se'sus asita'puguet, “'Gtaqqapa'tua's na pipnaqan p'tewapuigtug aq ignmua's, na negmewitew.” Na tujiw wesua'toq pipnaqanji'j wetgapa'toq aq ignmuaj Sutaal, Simon Isgaliot uggwisl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ta'n teli nqase'g Suta wesua'toq pipnaqanji'j Gjimn'tu pija'sitl ugtinneg, Se'sus telimatl, “Tetaga'tega ta'n getu tla'tegen!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Gatu ta'n wenig p'ta'utigtug pemgopultijig mo nestua'tigul ta'n goqwei wesgutmilij muta ta'n tujiw na mimajuinu ignmugsit na wetgapa'tas'g pipnaqan. Na etl gepmite'lmut. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Suta ango'tg'p na suliewei. Alt unaqapemg tel'ta'sultijig Se'sus telimatl ugjit nattelmlin ta'n goqwei nuta'ma'tij ugjit na pestie'umg, gisna ugjit ignmuan nat goqwei ewle'juinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Na ta'n tujiw Suta wesua'toq na pipnaqan na smtug tewiet. Na nige' gis tepgig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na ta'n tujiw Suta maja'siteg, Se'sus na teluet, “Nige' Gjinisgam gepmitelmit ni'n na ji'nm ta'n petgimip aq Gjinisgam miwatmuaten aq emtoqwalaten ugjit ta'n te's'g goqwei teliaq ni'neg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ta'n tujiw Gjinisgam miwatmuaten aq emtoqwalaten ugjit ta'n goqwei teliaq ni'neg na tujiw gepmitelmugsites aq ula na tliatew apugjig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nn'jantut, mawi gsaluloq. Wijitgweiultoqs'p pas'g gijga'jig. Gwiluitoqs'p gatu nige' telimuloq ta'n telimg'pnig igtigig, ‘Ma gisi lta'woq ta'n eliei.’ ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Pilei 'tplutaqan ignmuloq. ‘'Gsaltultigw ta'n ni'n teli gsaluloq. Amujpa na gesaltultioq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","'Ms't mimajuinu'g 'gjittaq gilew nnaqapemg 'gsaltultioq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Pie'l pipanimatl, “Gjisaqamaw tami elien?” Se'sus asitematl, “Ma gis majulgwaliwn nige' ta'n eliei. Gatu me' enmiaq majulgwalites.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pie'l pipanimatl, “Gjisaqamaw, goqwei ugjit ma gisi majulgwalulu nige? Gisgaje'i 'npmn ugjit gi'l aq iga'tun 'ntmimajuaqanm.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Se'sus na teli asitematl, “Tel'ta'sin gisgaje'in 'npmn ugjit ni'n. Telimul teliaqewei. Gesgmnaq napew getu'g gi'l si'st tluetes mo nenuiwn.” Na. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Se'sus telimaji, “Mut ignmatmnew 'ggamlamunual ewlgwija's'gtn. Lita'sualug Gjinisgam aq elg lita'sualig ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Pugwelgl wen'ji'guoml etegl ta'n nujj wigij aq eliei nat gisgaja'tuloqol ugjit gilew. Mo gis tlimuliwoq ula mo tlianug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ta'n tujiw lia'n aq nat gisgaja'tuloqol ta'n i'mu'titoqs'p, apaja'sites aq la'lultoqs'p ugjit i'mu'tinew ta'n eim. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Geituoq ta'n eliei aq ta'n tli 'lta'toqs'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tuma telimatl, “Gjisaqamaw, mo geju'lueg ta'n elien. Tali gjitutesnen ta'n tli 'lta'tesnen?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Se'sus asitematl, “Ni'n pas'g newgte'ji ta'n gis la'lultoqs'p nujjeg aq ma wen piluei. Ni'n telimuloq teliaqewei aq gis lita'sualitoqs'p. Ni'n na ta'n ignmultoqs'p iapjiwewei mimajuaqan. Ma wen gis liegw Nujjeg glapis ni'n la'l'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nige' gilew gi's gis nenuioq. Gatu menaqqajewei nenuioqosn, nenuaqoqpnn elg nujj. Nige' weja'tegemg gejioq aq gis gis nemioq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip telimatl, “Gjisaqamaw musga'tuieg Gujj, na pas'g tel puatmeg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Se'sus asitematl, “Pilip, menaq ta nenuiwn, je tlia gis teli pgiji wijitgweiuloq? Ta'n wen nemi'p, nemiapnn nujjl. Goqwei wet tluen, ‘Musga'tuin Gujj’? ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mo ta getlams'tmun, Pilip, ni'n eim Nujjeg, aq Nujj eig ntinneg? Na glusuaqann ta'n gisi usgutmuloqopnn mo wejianugupnn 'ntangita'suaqanm. Nujj ta'n eig ntinneg ugtlgowaqan elugwatg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","'Gtlams'tmu'tigw ni'n eim Nujjeg aq Nujj eig ntinneg. Gatu ma gisi gtlams'tmu'tiwoq ugjit ta'n gis tlimuloq na tujiw 'gtlams'tuigw muta mesgi'gl ta'n goqwe'l gis lugwatman. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ta'n wen getlams'tasit ni'neg, na 'lgowaqan tla'tegetal ta'n ni'n gis tla'tega'p. Tla'tegetal me' mesgi'gl 'lgowaqan muta ni'n eliei Nujjeg. Teliaq telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ta'n goqwei Nujj gelutmat, 'ntwisunmg e'wman, ni'n tla'tega's, glaman ni'n na uggwisl gepmitelma's Nujj. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Glutmuin ta'n pas'g goqwei 'ntwisunmg, na tla'tega's, na teliaq telimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Pa na 'gsalioq jigs'tmuitoqs'p ta'n ni'n telimuloqol glaman mimajuinu'g emtoqwalataq Gjinisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pipanima's nujj aq negm ignmugsitoqs'p ap igtigl nuji apoqonmuelitl ta'n wijitgweiugsitoqs'p iapjiw. Ma 'nqalugsiwoq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Etna na negm Wejuli Nisgam ta'n musga'tugsitoqs'p teliaqewei. Na mimajuinu'g ta'nig mo getlams'tasulti'gw ni'neg ma gisi menuege'tigul muta mo gwilua'tigul aq mo nenua'tigul gatu gilew nenu'luoq aq nige' Wejuli Nisgam maw mimajultioq aq ma 'pgije'nug 'gtinnewaq i'ttew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ma 'nqaluloq newgtugwa'lugutioq pa wijei aq mijua'ji'jg ta'n mo ungi'gwig ta'n angweiagutaq. Apaja'sites gilew ta'n eimu'tioq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Apugjige'l na mimajuinu'g ula ugs'tqamug ma nugu nemi'gwig gatu gilew nmitoqs'p, muta me' apaji wijitgweiultoqs'p. Apaji minunsites. Elt apaji minua'lultoqs'p gilew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ta'n tujiw na na'gweg iga'qt'tew ta'n tujiw minunsian, ugjigji'tutoqs'p na ni'n eim Nujjeg aq gilew eimu'tioq 'ntinneg aq ni'n eim 'gtinnewaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ta'n wen wesua'tuitl 'nt'tplutagnml aq jigs'tmuitl na negm ta'n gesalit. Nujj 'gsalatal ta'n wen gesalit, ni'n 'gsala's aq musgalsites negmeg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Na tujiw Suta (mu Suta Isgaliot) teluet, “Gjisaqamaw, tal gis musgalsites pas'g ninen aq ma nmu'lu'g igtigig mimajuinu'g?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Se'sus asitematl, “Ta'n wen gesalit 'ntglusuaqanml, jigs'tmuital, aq nujj 'gsalatal. Ni'n aq nujj lattesnen ugtinneg aq wigitesnen. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ta'n wen mo jigs'tmuigul 'ntglusuaqanml, mo gesaligw. Na agnutmaqan ta'n telimuloqop mo wejianugup 'ntangita'suaqanm gatu wejiaqap Nujjewigtug ta'n petgimip. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Wegla wet tlimuloq ge's wijitgweiluloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Gatu ta'n tujiw nqalultoqs'p Nujj petgimatal nuji apoqo'nmuelitl na Gjinisgam ugtottml na Wejuli Nisgaml 'ntwisunmg. Wejuli Nisgam gina'mugsitoqs'p 'ms't goqwei aq gisa'lugsitoqs'p migwite'tmnew ta'n te's'g goqwei gis tlimuloqop. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Naqtmuloq ignmatimgewei. Ignmultoqs'p wantaqo'ti 'gtangita'suaqanm aq 'ggamlamunuaq aq iapjiwtetew. Mo teli ignmuluoq ta'n mimajuinu'g teli ignmugsioq. Mut ignmatmnew 'ggamlamunuaq ewlgwija's'gtn gisna sespeta's'gtn aq mut jipasultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nutuioqop telimuloq, ‘'Nqaluloq gatu ap apaja'sites gilew ta'n eimu'tioq.’ 'Gsalioq ul'ta'sultigoq ta'n tel liei Nujjeg muta negm me' espe'g aq ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nige' wet tlimuloq wegla gesgmnaq tlianug glaman ta'n tujiw tliaq 'gtlams'tuitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma piam mamun glululuoq muta mn'tu ta'n iganpuguit ula ugs'tqamu wejgu'et. Gatu ma gis tala'ligw. Mo telgi'g ml'gigno'ti geggunmug 'st'ge' ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tla'tega's ta'n pas'g goqwei Nujj tel puatg glaman na mimajuinu'g 'gjittaq ta'n tetuji gsalj Nujja. Jugwita'gw, maita'nej.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Etna na ni'n Se'sus ta'n gisa'l'gig mimajuinu'g mimajultinew aq ligutinew Nisgamewigtug, pa wijei aq gle'pmenaqsi gisa'toqol nipispaqan nigwen. Nuji iga'taqug gigji ango'tg gle'pmenaqsi aq pa na wijei nujj gigji angweiwaji ugtmimajuinumg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nujj jigla'toqol ta'n goqwe'l mo gelu'lgtnugl ugmimajuaqanmuaq glaman ulataqatitaq ta'n tel mimajultijig Nisgamewigtug. Pa wijei aq nuji iga'taqug temo'toqol nipispaqanji'j ta'n mo gle'pl el nigwenugl aq wegla ta'n wel minigl waqama'toqol glaman me' pugwelgt'tal gle'pl ta'n minigt'tal. Ni'n mimajuinu'g ignmaqig iapjiwewei mimajuaqan. Pa wijei aq nuji iga'taqug waqamo'toqol nipispaqan, Nujj waqama'tuaj ugmimajuaqanmuaq aq nige' ligutinew Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pa wijei aq nuji iga'taqug temo'toqol nipispaqanji'jl ta'n mo gle'pl el nigwenugl aq wegla ta'n wel minigl waqama'toqol glaman me' pugwelgt'tal gle'pl minigt'tal. Na agnutmaqan ta'n telimuloqop gis gisa'lugsioq waqamo'ltinew Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Na nipispaqan ta'n gis tmta's'g gle'pmenaqsi ma gis nigwenug goqwei glapis siaw nasteg gle'pmenaqsigtug. Pa na wijei gilew ma gis tla'taqatiwoq ta'n Gjinisgam tel puatg glapis siawqatmu'tioq ni'neg. Siaw mawgatmu'tigw ni'neg aq ni'n siaw wijitgweiultoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ni'n na pa wijei aq gle'pmenaqsi aq gilew pa wijei aq nipispaqann. Ta'n wen siawqatg ni'neg aq ni'n negmeg etna na negm ta'n pugwelgt'tal tla'tegetal ugjit ni'n. Pa na ni'n mo eimu 'gtinnewaq aq mo ni'n apoqonmuluoq ta'n goqwei tela'taqatioq ma tepawgtinug Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ta'n wen mo siawqatmug ni'neg ejigla'lut, pa wijei aq nipispaqan ta'n weji tmta's'g gle'pmenaqsigtug aq gaqi gispateg. Wegla nipispaqann mawo'tas'gl aq elo'tas'gl pugtewigtug ugjit nu'gwa'tas'gtn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Siawqatmu'tioq ni'neg aq 'ntglusuaqanml siaw jigs'tmuigw aq majulgwatmui na tujiw pipanigesultioq ta'n tel puatmoq aq 'msntoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","“Etna na ula Nujj gepmite'lmaten ta'n tujiw tela'taqatioq ta'n tel puatg aq pejo'loq igtigig Nisgamewigtug. Na tla'taqatitoqs'p tel musgalsultioq nnaqapemultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Teli gsaluloq ta'n Nujj teli gsalij. Migwite'tmug ta'n teli gsaluloq aq na tl mimajultigw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jigs'tmuioq ta'n telimuloq, na tl siawqatmultoqs'p 'ntgsaltuaqanm aq siawi gsalultoqs'p. Pa na wijei aq ni'n ta'n tel jigs'taq Nujj ta'n telimij aq na tl siawqatm ugt'gsaltuaqanm aq negm siawi gsalit. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Wet tlimuloq ula glaman ulgwijultitoqs'p ta'n ni'n teli ulgwijin. 'Ntwelgwijuaqanm ignmultoqs'p 'ggamlamunual glaman 'ggamlamunual pajiji ulgwitt'tal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Etna na ula ta'n telimuloq. ‘Gsaltultigw ta'n ni'n teli gsaluloq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ta'n mawi ms'gi'g ugsaltuaqan mimajuinu gis neia'tuataq witapaq na iga'tutew ugmimajuaqanm ugjit negmow. Ma gis piami gsalugsiwoq wen st'ge' ula. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aq gilew na nitapaq, tla'taqatioq ta'n telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nige' gisgug mu nugu telui'tuluoq 'ntlugowinumg muta lugowinu mo geitug ta'n ugtassusiteml getu tla'tegelij. Gatu awna telui'tuloq nitapaq muta gaq tlimuloqol ta'n te's'g goqwei nutmap Nujjewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mo gilew megniwoqop. Ni'n megnuloqop aq iga'luloqop ugjit munso'ltinew tla'taqatinew ta'n tel pualuloq aq gina'mug mimajuinu'g ugjit majulgwalinew. Na tujiw iapjiwewei mimajuaqan guguntaq aq iapjiw majulgwalitaq. Tla'taqatioq na Nujj ignmugsitoqs'p ta'n pas'g goqwei gelutmuoq 'nwisunmg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Etna na ula ta'n melgimuloq, ‘'Gsaltultigw!’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Pa na mimajuinu'g ta'n mo tleiaulti'gw Nisgamewigtug masgelmugsioq, amujpa migwite'tmoq, tmg ni'n masgelmipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Gatu ni'n weji mgnuloqop ula ugs'tqamu ta'n mimajuinu'g eimu'tijig aq mu nugu tleiaultiwoq. Etna na ugjit ula mimajuinu'g masgelmugsioq. Gatu tleiaultioq ula mimajuinuigtug, na tujiw ula mimajuinu'g 'gsalugsitoqs'p ta'n teli gsala'tiji un'januaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Migwite'tmug ta'n telimuloqop. Mo na gisteju me' espeiug aq ugtassusiteml. Ta'n teleiwipnig na wijei gilew tleiugsitoqs'p. Amasgipnnipnig ni'n aq elt gilew amasgipnnugsitoqs'p. Jigs'tmui'tisnn 'ntglusuaqanml, jigs'tugsitoqs'p elt gilew 'gglusuaqanmual. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Gilew tleiaultioq ni'neg, etna na ugjit tla'lugsitoqs'p ula ta'n te's'gl goqwe'l muta mo nenua'tigul nujjl ta'n petgimip. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma ilsumam'gig ta'n tel pata'taqati'tij ta'n mo menuaqaligupnig mo jugu'ewasn aq gluluaqasn. Gatu nige' wejgu'eiap aq gelu'lg'pnig aq nige' geitu'tij ta'n tel pata'taqati'tij aq ma nugu gisi iga'tu'titl ugtlue'utiwal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ta'n wen masgelmit masgelmatl elt nujjl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Weji pgisin ugjit mesgi'g lugowaqan lugwatmn ta'n menaq wen pa tela'tegegw. Nemi'pnig ta'n gis tla'tegei pas'g mo jigs'tuigupni awna masgelmipnig aq maw Nujjl. Etna na ugjit tli ilsumaten. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Amujpa na wet tliaq glaman ta'n goqwei ewi'gas'g Gjinisgam ugtwi'gatign tliatew, ‘Mo goqwei geggunmi'ti'gw ta'n tel masgelmi'tij.’ Pisuiw masgelmijig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nujjeg ugji petgima's Nuji apoqonmuet na Wejuli Nisgam. Ta'n tujiw 'pgising gina'mugsitoqs'p teliaqewei ugjit Gjinisgam aq usgumitew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aq elt gilew usgumitoqs'p, muta wijitgweioq mawi amgweseweieg al gina'muaneg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Se'sus siawewistoq, “Na ula gis tlimuloq glaman ma se's'toqutiwoq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tuaqtesgugsitoqs'p ugta'sutuo'guomuaq. Iga'qt'tew na'gweg ta'n tujiw wen ne'po'qsioq tl'ta'sitew etl lugowatl Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Na wegla tla'lugsitoqs'p muta mo nenua'tigul Nujjl gisna ni'n. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Gatu ula gis igan gnua'tuloq glaman iga'q na'gweg ugjit negmow tla'taqatinew, wegla migwite'ttoqs'p ta'n telimuloqop.” “Amgweseweieg mo telimuluoqopnn wegla muta me' pem siaw wijitgweiluloqop. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Gatu nige' gis tlimuloq muta eliei negmeg ta'n petgimip. Gatu mo wen te'sioq pipanimip, ‘Tami elien?’ ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Muta nige' ta'n gis tlimuloq 'ggamlamunual ewlgwitgl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Gatu telimuloq teliaqewei me' glu'lgt'tew ugjit gilew na ni'n jigla'sia's. Gatu mo jigla'wan na nujiapoqonmuet ta'n teluisit na Wejuli Nisgam ma 'pgisinug gileweg. Gatu jigla'sia's na tujiw Wejuli Nisgam petgimultoqs'p ni'n. Teliaq na telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ta'n tujiw 'pgising negm musga'tuataq mimajuinu'g ugs'tqamug, ta'n tel lue'winuulti'tij, aq ta'n tel pata'tegewinuulti'tij. Musga'tuataq na Gjinisgam uggelu'lgm eteg ugjit apoqonmuan aq gisi jiglo'lataq ta'n tli ilsumaten. Musga'tuataq oplita'sultijig ugjit ta'n goqwei tetapu'aq aq ta'n Gjinisgam tli ilsutegetew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Musga'tuataq ta'n tel lue'winuulti'tij muta mo getlams'tuigupnig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Musga'tuataq ta'n tli oplita'sultijig ugjit ta'n goqwei tetapu'aq Nisgamewigtug muta eliei Nujjeg aq gilew ma nugu nemi'woq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Musga'tuataq ta'n tli oplita'sultijig ugjit Gjinisgam ugtilsutaqanm muta iganpuguit ula ugs'tqamu na mn'tu gis gisi ilsumut. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“A' na me' pugwelg ta'n goqwei getu tlimuloq, gatu nige' ugsami ms'gi'gt'tew ugjit gilew gisipugutmnew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Gatu ta'n tujiw na Wejuli Nisgam ta'n musga'tugsitoqs'p teliaqewei ugjit Gjinisgam 'pgising negm ilgwenugsitoqs'p teliaqeweigtug. Ma usgutmug ta'n goqwei gisite'tg pas'g usguttew ta'n goqwei gis nutg aq tlimugsitoqs'p ta'n goqwei tliatew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ugsua'tutew ta'n goqwei ni'newei aq musga'tugsitoqs'p aq ignmugsitoqs'p na tl gepmite'lmitew. Nutuij ta'n usgutma's na agnutmugsitoqs'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ta'n te's'g goqwei nujj geggung ni'newei. Etna na ugjit wet tluei Wejuli Nisgam ugsua'tutew ta'n goqwei ignmaq aq musga'tugsitoqs'p. Na.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Apugjig jigla'sites aq ma gis nemi'woq, aq na tujiw apugjige'l ap nmitoqs'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Alt unaqapemg telimtultijig, “Etli 'gtu talimugsi'gw? Telimugsi'gw, ‘Apugjig ma nmi'woq aq na tujiw ap apugjige'l nmitoqs'p.’ Elt teluet, ‘Eliei nujjeg.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Etna na ugjit pipanimtultijig, “Etli 'gtu talimugsi'gw ta'n tujiw teluet, ‘Apugjige'l?’ Mo geitug ginu ta'n goqwei wesgutg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Se'sus gejiaji getu pipanima'titl, glaman telimaji, “Teluei, ‘Apugjige'l ma nmi'woq aq na apugjige'l nmitoqs'p.’ Etna na ula pipanimtultioq? ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Atgitemultitoqs'p aq ewlgwijultitoqs'p. Gatu igtigig mimajuinu'g ta'nig mo getlams'tmu'ti'gw ul'ta'sultitaq ta'n ni'n tla'liten. Ewlgwijultitoqs'p gatu ta'n teli atgitemultitoqs'p jensi sa'se'wa's'gt'tew aq pajiji ulgwijultitoqs'p. Teliaq na telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ta'n tujiw e'pit getu un'janit geitoq na poqjipnej. Gatu ta'n tujiw un'jan gisi ugs'tqamuilij. Nige' welgwijing muta un'jan gisi ugs'tqamuilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Assma nige' wijei ugjit gilew. Nige' ewlgwijultioq gatu ap nmultoqs'p, 'ggamlamunual pajiji ulgwitt'tal aq ma wen gis jigla'tugsiwoq ula ulgwijuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ta'n tujiw na na'gweg iga'q, gilew ma pipanimiwoq pas'g goqwei, muta nujj ignmugsitoqs'p ta'n pas'g goqwei glutmu'tioq nwisunmg. Teliaq na telimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Glapis nige' me' menaq goqwei pipanigesultiwoq 'nwisunmg. Glutmug 'nwisunmg aq 'msntoqs'p, glaman 'ggamlamunual tetuji ulgwitt'tal.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“A'tugwaqann e'wmapnn ta'n tel tlimuloq wegla. Gatu tetaputesg iga'q ta'n ma nugu e'wmuan a'tugwaqann. Menaqqajewei usgutmultoqs'p nujj. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ta'n tujiw na na'gweg iga'q, pipanimatoqs'p negm 'nwisunmg. Mo etl tluew pipanimass negm ugjit gilew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Muta Nujj gesalugsioq muta gilew gesalioq aq getlams'tmoq wejia'p negmeg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ni'n wejia'p Nujjewigtug, aq ugs'tqamug pegisinap; aq ap nige' naqt'tes ugs'tqamu aq eliei Nujjeg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Na tujiw unaqapemg telima'titl, “A' na nige' menaqqajewei tlewistun aq mo e'wmun a'tugwaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nige' gejituleg 'ms't goqwei geitu'n. Aq goqwei ugjit mil pipanimultesnen ugjit 'gji'tunen ta'n goqwei geitu'n. Wegla gisa'lugsieg'pnn 'gtlams'tulinen gi'l wejien Nisgamewigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Se'sus asitemaji, “Nige' tel'ta'sultioq getlams'tuioq? ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Na na'gweg iga'q aq nige' gis iga'q ta'n tujiw 'ms't gilew gaq se'sa'to'qutitoqs'p. 'Ms't wen apaja'sitew wiguaq aq ni'n 'ngutugwa'lugwa's. Gatu mo menaqqajewei newgtugwa'lugow muta Nujj wijitgweiwit. ");
INSERT INTO micMIQNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ula ugs'tqamug mimajuinu'g gitnm'titoqs'p gatu ml'gito'ltigw! Wissuignemg'p na iganpuguit ula ugs'tqamu. Na ula wet tlimuloq glaman i'mu'tioq ni'neg aq guguntoqs'p wantaqo'ti 'ggamlamunuaq aq 'gtangita'suaqanmuaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ta'n tujiw Se'sus gaqewistoqeg, elapa'sit wa'so'q aq teluet, “Nu' (Tata't), na ajiet iga'q. Pipanimul gepmitelmi 'ggwis, glaman ni'n 'ggwis gis gepmitelmultes. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ignmui't'p assuman 'ms't mimajuinu'g glaman gisi ignmua's iapjiwewei mimajuaqan wa'so'q ta'nig ignmui't'pnig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Negmow ta'n nenu'linew newgti tetapu'en Gjinisgam aq nenuinew ni'n Se'suguli ta'n petgimi't'p. Etna na ula ignmuates iapjiwewei mimajuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mimajuinuigtug gepmite'lmulap ula ugs'tqamug, gaqa'tuapneg ula 'lgowaqan ta'n ignmuip tla'tegen. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nu' (Tata't), nige' gepmitelmi aq ignmui wijitgweiulin 'st'ge' ta'n tel gepmitelmi't'p gesgmnaq ugs'tqamu gisita's'gtnugweg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Telimg'pnig ula mimajuinu'g ugjit gi'l. Tleiaultijig ula ugs'tqamu gatu ignmui't'pnig. Gi'lewe't'pnig aq gi'l ignmui't'pnig aq jigs'tmasg'pni 'gglusuaqanm. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aq nige' geitu'tij ta'n te's'g goqwei ignmui't'p wejiaq gi'leg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ignmaqapnig agnutmaqan ta'n ignmui't'p aq wesua'tu'tip. Gjitm geitu'tij na ula teliaq aq na wejia'p gi'leg, aq negmow getlams'tmi'tij gi'l petgimi't'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“A'sutmessewulgig ula mimajuinu'g ta'n ignmui't'pnig muta gileweg. Mu a'sutmessewaqig igtigig ta'n mo getlams'tmi'ti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ta'n te'sijig 'ntmimajuinumg na gi'lewei aq ta'n te'sijig 'gmimajuinumg na ni'newei. 'Ntgepmitelgaqanm weji musga's'g ula mimajuinuigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nige' naqtm ula ugs'tqamu aq eliei gi'leg gatu negmow naqalgig ugs'tqamug. Nu' (Tata't), 'gjisape'win, angweiu aq iga'l. e'wmn 'gml'gigno'timg na wijei ml'gigno'ti ta'n ignmui't'p. Glaman 'ms't siawi i'mu'titaq ni'neg aq ni'n i'm ugtinnewaq glaman 'ngute'jultitaq ta'n ginu teli 'ngute'ji'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ta'n teli pgiji wijitgweiagig iga'lg'pnig 'gml'gigno'timg. Na ml'gigno'ti ta'n ignmui't'p. Iga'lg'pnig aq mo wen te'si'tij gesga'gup, pas'g na ji'nm ta'n gis gissutasit lien mn'tua'gig. Na tliatew glaman ta'n goqwei gis wi'gas'g 'gtwi'gatigng tliatew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Aq nige' eliei gi'leg. Telimg'pnig wegla ge's eimaneg ugs'tqamu glaman ulgwijultitaq pa wijei aq ni'n. Ignmua's uggamlamunual pajiji ulgwitt'tal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ignmaqapnig nnaqapemg 'gtagnutmaqanm, aq masgelmujig ta'nig mo getlams'tmu'tligwi muta ni'n aq nnaqapemg piltu angita'sultieg aq negmow. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nu', mo pipanimulu jigla'lan ugs'tqamug gatu awna pipanimul nnaqapemg ugs'tawian mn'tu ugml'gigno'timg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Pa na wijei aq ni'n mo tleiawiw ugs'tqamu nige' elt negmow nnaqapemg mo tleiaulti'gw ula ugs'tqamug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ignmu sape'ultinew aq gmetug iga'l ugjit gi'l, ta'n tel gina'masulti'tij 'gglusuaqanml. 'Gglusuaqanml teliaq teluegl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Elgimgig mimajuinuigtug ula ugs'tqamug pa wijei aq gi'l ta'n teli elgimi't'p mimajuinuigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Gmetug igalsi ugjit gi'l glaman negmow ulapettaq glaman elt negmow menaqqajewei igalsultitaq ugjit gi'l. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“A'sutmessewulgig nnaqapemg aq maw ugjit ta'nig 'gtlams'tuitaq muta negmow usgumitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nu' (Tata't), a'sutmessewulgig glaman 'ngute'jitaq. Etamul newgte' tli angita'sultinew aq wijei uggamlamunual tl gwittetal Nisgamewigtug pa wijei aq gi'l nujj aq ni'n. Pa wijei aq gi'l tet i'mn ni'neg aq ni'n gi'leg. Pa wijei 'gtinnenaq i'mu'titaq glaman na mimajuinu'g ula ugs'tqamu 'gtlams'tmultaq gi'l petgimi't'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Gepmitelm'gig ta'n gis gi'l tel gepmitelmin glaman gisi ngute'jitaq pa wijei aq ni'n aq gi'l teli ngute'ji'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ni'n ugtinnewaq eim aq gi'l eimn ntinneg. Na tujiw gis gisi ngute'jitaq glaman na mimajuinu'g ula ugs'tqamug 'gji'tutaq gi'l petgimi't'p aq gesaljig ta'n teli gsalin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Nu' (Tata't), gi'l ignmui't'pnig aq pualgig negmow i'mu'tinew wa'so'q ta'n ni'n i'ttes. Na tujiw gis nmituitaq 'ntgepmitelgaqanm, ta'n ignmui't'p muta gesali't'p gesgmnaq ugs'tqamu gisita's'gtnugweg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nu' (Tata't), ta'n maw getlamien aq tetapu'en, na mimajuinu'g ula ugs'tqamu mo nenu'lu'g gatu ni'n nenu'l aq wegla ta'n wijitgweiwijig geitu'tij gi'l petgimi't'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Telimg'pnig ula mimajuinu'g ugjit gi'l aq me' siaw tla'tega's glaman 'gsala'titaq igtigig ta'n teli gsalin gi'l aq ni'n ugtinnewaq i'ttes. Na tliaj.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ta'n tujiw Se'sus gisi a'sutmateg, maja'sit maw unaqapemg aq asoqoma'it sipuji'j teluisig Gitlon. Na'te'l eteg iga'taqanji'j. Se'sus aq unaqapemg el'ta'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na Suta, ta'n netuisga'lapnn Se'susal, geitoq ta'n eteg, muta gaqaisg Se'sus i' tli ultesguaji unaqapemg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Etna na ugjit Suta na'te'l eliet maw sma'gnisg aq nuji ugsua'taqatijig, na ta'nig iganpugultijig patlia'sg aq Palasiaq ignmua'titl, ugjit wije'wanew. Ela'laji iga'taqanigtug. Pema'tu'titl wasoqwaluejgewe'l aq petasenma'tiji aq espo'qwas'gl aq petgute'gne'l. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Se'sus geitoqop 'ms't goqwei ta'n tliatew ugjit negm. Igana'sit aq pipanimaji, “Wen ta gilew al gwiluoq?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Asitema'titl, “Se'sus na Nasaletgewa'j.” Telimaji, “Ni'n na.” Suta ta'n netuisga'lapnn Se'susal, gaqamis maw igtigig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ta'n tujiw Se'sus telimateg, “Ni'n na.” Esetepuguita'jig aq smtug aputasg nisia'tijig maqamigeg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tel gneg apaj qamita'jig ap Se'sus pipanimaji, “Wen ta gilew al gwiluoq?” Teli asitema'titl, “Se'sus na Nasaletgewa'j.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Se'sus teluet, “Gi's gis tlimuloq ni'n na. Ni'n al gwiluioq, mut ugsua'lanew ala igtigig.” ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Wet tluep ula glaman ta'n goqwei teluep gis tliatew, “Nujj je mu newgte'jit gesga'qup ta'n ignmui'tpnig.”) ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Pie'l geggunatl espo'qwas'gl. Gettaqa'toq aq taqamatl espe'g patlia's uggistejuml, mente'muaj inaqanei ugs'tuaqan. Na gisteju teluisit Malgus. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Se'sus telimatl Pie'lal, “Apaji pija'l 'gtespo'qwas'gm ta'n tleiawig. Gi'l ta tel'ta'sin ma wet saputa'siw metue'gl ta'n Nujj tel'te'tg'p? Ni'n wel'te'tm na tla'tegen. Amujpa wet samqwai na cupji'j ta'n Nujj ignmuit.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Na sma'gnisg maw iganpuguit sma'gnis aq na Lesui'paq nuji ugsua'taqatijig, wesua'la'titl Se'susal gelpila'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Toqo ela'la'titl tmg Annaseg muta Annas na ugjiljl Gaiapas. Gaiapas iganpuguit patlia's ula newgtipunqeg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Etna na Gaiapas ta'n telimapni Lesui'paq, “Me' gelu'lgt'tew newgte'jit ji'nm 'np'g ugjit 'ms't mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pie'l aq ap igtig unaqapeml, ugpaqamuaq majulgwala'titl Se'susal. Na espe'g patlia's wel nenuapnn igtigl unaqapeml. Negm wije'watl Se'susal iga'taqanigtug ta'n espe'g patlia's wiguow gigtoqopaqteg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pie'l gaqamit gujmug gigjiw ga'qana'tas'gigtug. Igtigl unaqapeml ta'n espe'g patlia's wel nenuatl, apat tu'et, gelulatl gistejui'sgwetl, ta'n nuji ango'tg ga'qana'tas'g, aq pisgwa'latl Pie'lal. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Na gistejui'sgwej pipanimatl Pie'lal, “Ma ta gi'l newgte'jin Se'sus unaqapeml?” Pie'l asitematl, “Moqwa' mu na ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tege'g'p aq gisteju'g aq nuji ugsua'taqatijig gisitu'tip pugtew aq al gigto'qopugua'tijig etli ulp'susultijig. Pie'l eliet maw negmow aq apu'susit. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na toqotesip na espe'g patlia's mil pipanimatl Se'susal ugjit unaqapemg aq ta'n tel gina'muej. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Se'sus asitematl, “Apjiw etlewistuap mimajuinuigtug. Apjiw etl gina'muap a'sutuo'guomg aq 'gjia'sutuo'guomg ta'n 'ms't Lesui'paq etli ultesgatulti'tij. Mo goqwei mimgwa'tuaqapni ta'n tel gina'maqig. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Goqwei nige' tel mil pipanimin? Pipanim na mimajuinu'g ta'n nutuipni. Pipanim negmow ta'n telimg'pnig. Amuj na geitu'tij ta'n telueiap.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ta'n tujiw Se'sus gis tlueteg ula, newgte'jit sma'gnis paqtne'ita'tl aq teluet, “Mu na tel glulam'g na espe'g patlia's!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Se'sus asitematl, “Goqwei mo tetaputenug tlua'n, tlim 'ms't wen ula tet ta'n goqwe't'p. Gatu tetapu ewistuan, goqwei weji tqamin?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Na tujiw Annas elgimatl Se'susal, me' gelpisilitl, Gaiapaseg na espe'g patlia's. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Gatu na Pie'l me' gaqamit etli apu'susit. Igtigig telima'titl, “Amuj na gi'l newgte'jit Se'sus unaqapeml?” Gatu Pie'l megt'g. Teluet, “Moqwa', mu na ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Newgte'jit espe'g patlia's uggistejuml wo'qomal na ji'nm ta'n Pie'l mente'muap ugs'tuaqan, gelusit aq pipanimatl Pie'lal, “Mu ta nemu'lap maw negm iga'taqanigtug?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pie'l ap teluet, “Moqwa'!” Na smtug napew getu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Gatu na tujiw mawi egsitpu'g Lesui'paq iganpugultijig ejigla'la'titl Se'susal Gaiapaseg wiguaq aq ela'la'titl Lo'mewei g'pnno'l ugtelege'wituo'guomg. G'pnno'l teluisit Pilot. Na Lesui'paq iganpugultijig mo pisgwita'gwig muta ta'n negmow telo'lti'tij, pa na pisgwita'snig ta'n mo Lesui'peulti'gw, na tujiw ma waqamo'lti'gw aq ma gis mawatalulti'gw na Siawa'timgewei pestie'umg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Etna na ugjit Pilot naji ultesguaji gujmug aq pipanimaji, “Tali 'lsutmuoq ula ji'nm?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Asitema'titl, “Mo jugwa'laqatt'pn gi'leg mo opla'tegegusnn.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilot telimaji, “Gilew ugsua'lug aq ilsumug ta'n telteg 'gt'tplutaqanmuoq.” Lesui'paq iganpugultijig teluejig, “Gilew Lo'meultioq, mo ignmuiweg wen ne'pa'nen.” ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ula wet tliaqap ugjit tlian ta'n Se'sus teluep ugjit ta'n tli np'tew.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Na Pilot apaji pisgwa't elege'wituo'guomg aq negmeg wigumatl Se'susal aq pipanimatl, “Gi'l na Lesui'paq ugtelege'witemual?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Se'sus asitematl, “Gi'l pipanimin, gisna ala igtigig gis tlim'sgi'g ugjit ni'n?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilot na teli asitematl, “Tel'ta'sin ni'n na Lesui'p. 'Gtmimajuinumg aq negmow iganpugultijig ugpatlia'smuaq iga'l'sg'pni 'npitnn. Goqwei ta opla'tu's'p?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Se'sus teluet, “Ntelege'witewa'gim mo tet tleiawinug ugs'tqamug. 'Ntelege'witewa'gim tleiawigsn ula ugs'tqamu nnaqapemg matnaqq'ti'tisoq. Na tujiw mo iga'linesoq Lesui'paq ugpitnuaq. A' na moqwa'! Mo 'ntelege'witewa'gim tleiawinug ula ugs'tqamu.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilot pipanimatl, “Mu na gi'l elege'wit?” Se'sus asitematl, “E'e, na weji ugs'tqamuiap. Weji pgisinap ugjit 'pgisitun teliaqewei ula ugs'tqamug. Ta'n wen gesatg teliaqewei jigs'tuitew.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilot pipanimatl. “Goqwei ta teliaqewei?” Na tujiw Pilot apaja'sit gujmug ta'n Lesui'paq eimu'tijig aq telimaji, “Mo goqwei we'jituaq amsalteg ugjit ilsuman ne'po'qsin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Siawa'timgewei pestie'uti iga'q, apjiw gettalqa'l'g newgte'jit ta'n pisit laplusang ugjit gilew ta'n i' tl pipanimioq ugjit tla'tegen. Pualioq iga'lan 'gtelege'witemuoq?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Apaji sesgwala'titl, “Moqwa', mu negm. Pualg't Palapas!” (Palapas na nuji gmutnet.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Na tujiw Pilot ignmuaji ugsma'gnismg jigla'lanew Se'susal aq te'sipowmaqanta'new. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na sma'gnisg goqominaqsiei piptugwaqig elisgnuatmi'tij aq nasa'tua'titl un'jig. Megwi ewne'litl pitu'gunn pitoqsilitl nasa'tua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Asuita'jig. Elmatgwetua'titl aq teluejig, “'Pgitawsi Lesui'paq ugtelege'witemuaq!” El'ta'jig aq paqtne'ita'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mjit newgt Pilot apat tu'et aq telimaji Lesui'paq, “Angamug. Apat tuatultoqs'p ugjit gilew gisi gji'tunew mo ni'n gisi we'jituaq goqwei amsalteg ugjit ilsuman ne'po'qsin.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Na tujiw Se'sus tewiet, nasg'g goqominaqsiei piptugwaqig aq megwi ewne'litl pitu'gunn pitoqsilitl. Pilot telimaji, “Angamug, ula na ji'nm!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ta'n tujiw na iganpugultijig patlia'sg aq nujiugsua'taqatijig nemia'titeg, sesgu'tijig, “Gujjiewto'q, gujjiewto'q!” Pilot telimaji, “Na gilew ugsua'lug aq gujjiewto'q. Mo we'jituaq goqwei amsalteg ugjit ilsuman ne'po'qsin!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Na Lesui'paq iganpugultijig asitema'titl, “Geggunmeg 'tplutaqan ta'n telueg, ‘Amujpa nepg, muta teli ugsualsit Gjinisgam uggwisin.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ta'n tujiw Pilot nutuateg, na teluejig, me' aji jipaqa'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Apaji pisgwa'latl Se'susal elege'wituo'guomg aq pipanimatl, “Tami tleiawin? Tami ta gi'l wejien?” Gatu mo Se'sus asitemagul. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilot ewlumuatl, “Mo getu geluliwn? Migwite'te'n ni'n ml'gigno'ti geggunm gisi iga'lulin gisna gujjiewto'qsin!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Se'sus asitematl, “Gi'l ml'gigno'ti geggunmn ugjit ni'n muta pas'g gisi ignmulg'p Nisgamewigtug. Mo geggunmun ml'gigno'ti ugjit ni'n glapis Gjinisgam ignmasg. Gatu na ji'nm ta'n iga'lip 'gpitng, me' mesgi'g ta'n teli pata'tegej.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ta'n tujiw Pilot ula nutgeg wejo'tg we'jitun ta'n tli iga'latal. Me' tetaqite'tg'p gisi iga'lan. Gatu na Lesui'paq apat sesgu'tijig, “Gatu gi'l iga'laj na ji'nm, mo gi'l Sisal witapal! Ta'n wen teli ugsualsit elege'witewin, negm getanatl Sisalal!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ta'n tujiw Pilot nutgeg ula glusuaqann, ela'la'titl Se'susal gujmug aq epa'sit nuji ilsuteget ugt'pung. Gun'teweiei 'msaqtaq ta'n ugt'pung eteg. (Lesui'pewigtug teluisig, “Gapata.”) ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nige' ugtejgewei na'gweg gesg mnaq Siawa'timgewei atlasmutigisgug iga'nug. Mawi espe'g ula atlasmutigisgug. Na suel mewlia'gweg. Pilot telimaji Lesui'paq, “Ula na 'gtelege'witemuoq!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Apaji sesgu'tijig, “Ne'po'q! Ne'po'q! Gujjiewto'q!” Pilot pipanimaji, “Pualioq ni'n iga'lan 'gtelege'witemuoq ugjit gujjiewto'qsin?” Iganpugultijig patlia'sg asitema'titl, “Pas'g newgte'jit elege'wit geggung't, na Sisal!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Na tujiw Pilot iga'latl Se'susal ugpitnuaq ugjit gujjiewto'qsilin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Glapis gisapsgna'titl. Na tujiw sma'gnisg nuje'wa'titl Se'susal. Tewa'la'titl 'gjigang pema'tulij uggujiewe'm. El'ta'jig glapis peita'jig na'te'l ta'n pempnigeg maqamigew teluisig, “Teliangamgug st'ge' waqan'tewatpat.” (Teluisig, “Golgota” Lesui'pewigtug.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Etna na na'te'l gujjiewta'titl aq tapusiliji ji'nmug gujjiewta'tiji maw negm. Newgte'jit inaqaneg aq igtig patatujg aq negm Se'sus miawe'g. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilot ewi'gmu't'p gnugwaqan aq nasa'tut'p gujjieweigtug, “Se'sus Nasaletgewa'j, na Lesui'paq ugtelege'witemual.” Etna na ula ta'n ewi'gmu't'p. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pugwelgig Lesui'paq egitmi'tip ula muta na'te'l ta'n Se'sus etl gujjiewto't mo gnegtnugup 'gjigang. Gnugwaqan ewi'gas'g'p Lesui'pewigtug, Latinewigtug ta'n Lo'mewaq teli'sulti'tij aq Gli'gewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Na Lesui'peweiei iganpugultijig patlia'sg telima'titl Pilotal, “Mut wi'gmu, ‘Lesui'paq ugtelege'witemual.’ Gatu ewi'gmu't'p, ‘Ula ji'nm teluet, Ni'n na Lesui'paq ugtelege'witemual.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilot asitemaji, “Ta'n goqwei gis wi'gm siawtej.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ta'n tujiw sma'gnisg gisi gujjiewta'titeg Se'susal wesua'tua'tij utapsunn aq ne'w nasgwa'tatultijig, te's pugwei ugjit te's sma'gnis. Pas'g newgte' pugwei esgwiaq, na ugpitu'gunml pita'qal maqotl. Newgti mse'litl ta'n teli gnua'tasilij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sma'gnisg telimtultijig, “Tlia mu suisgina'tuaq, gatu laqatinej ugjit 'gji'jianenu ta'n wen 'msntew.” Ula wet tliaqap ugjit tlian ta'n goqwei Gjinisgam ugtwi'gatigng gis wi'gas'g'p, “Tel nasgwa'tatultipni nutapsunn te's pugwei ugjit negmow aq elaqatipnig ugjit 'ntgotml ta'n newgtinse'g.” Na ula sma'gnisg tela'taqatiji. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Gaqamultijig gigjiw Se'sus uggujiewe'm, uggwitl, aq uggwitl wijigatijig e'pilitl, aq Mali, Gliopas ugte'piteml, aq Mal Matle'n. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Se'sus nemiatl uggwitl aq na unaqapeml ta'n gesalatl, gaqamijig. Na tujiw telimatl uggwitl, “Giju' nige' weja'tegemg, tli ugsua'l nnaqapem st'ge' 'ggwis.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aq matgwetuatl unaqapeml aq telimatl, “Tli angweiw 'ngij 'st'ge' 'ggij.” Weja'tegemg na ajiet ji'nm enma'latl wiguaq, wigilin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Se'sus geitoq 'ms't goqwei nige' gaqa'toq, teluet, “Getu samqwai.” Glaman tliatew ta'n telueg'p Gjinisgam ugtwi'gatigng. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Samqwano'q eteg'p waju'elitl wisqe'g moqopa'q. Wetgapa'tu'tij 'spanj moqopa'qigtug iga'tu'titl nipispaqanigtug wejiaq miti's teluisig isop aq elasga'tua'tij Se'sus ugtung. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ta'n tujiw Se'sus wett'geg na tujiw teluet, “Gaqa'tuaneg.” Matgwa'toq un'ji aq iga'latl ugjijaqamitl aq apaja'litl Nisgamewigtug. Na nepg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Etna na na'gweg ta'n ilajugtmi'tij atlasmutigisgug, na igtig na'gweg mawi espe'g atlasmutigisgug, Lesui'paq mo puatmi'tigup 'npuinu'g gaqapijultilin gujjieweigtug na na'gweg. Etna na ugjit pipanima'titl Pilotal ignmuin ugsma'gnismg tmte'muanew na ji'nmug uggwatual glaman jaqali np'taq aq na tujiw 'npuinu'g nisa'lugsinew. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Toqo Pilot elgimaji ugsma'gnismg. Na sma'gnisg el'ta'jig aq temte'mua'titl amgwesewei ji'nmul uggwatl aq maw igtigl ji'nmul. gitg ta'nig gujjiewto't'pnig maw Se'susaq. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Gatu ta'n tujiw iga'titeg Se'susal, nemia'titl gis neplitl aq mu temte'mua'tigul uggwatl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Gatu newgte'jit sma'gnis espo'qwas'g sapaqqata'tl Se'susal gigjiw uggamlamung ugtassuign aq na smtug mal'tew aq samqwan tewijuig. ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ni'n nemituap ta'n tujiw gis tliaq aq giasgiwewei telimuloq glaman 'gtlams'tmultoqs'p. Geitu gigwaji agnutmuloq aq gis lita'sualitoqs'p.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Na ula wet tliaqap ugjit tlian ta'n goqwei gis wi'gas'g'p Gjinisgam ugtwi'gatigng: “Je ma newgte'gtn ugtwaqan'tem tmta's'gtnug.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ap igtig telueg Gjinisgam ugtwi'gatigng: “Na mimajuinu'g angama'tital negm ta'n sapaqqato't'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ta'n tujiw ula gaq tliaq, So'sep ta'n tleiawip na gutanji'j teluisig Alimatia, pipanimatl Pilotal, gisi ugsua'lan Se'susal. (So'sep getlams'tuatl Se'susal. Gatu mo al wije'wagupnn muta mo sangewite'lmagwi Lesui'paq iganpugultijig.) Na Pilot telimatl gisi ugsua'tuatew wa'qi aq So'sep eliet aq ejigla'tuaj. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nigotimus na negm ta'n amgweseweieg nat nmiapnn Se'susal newgtejgeg wela'gweg, wije'watl So'sepal. Enma'toqol, weljema'gewei, wiaqiaqal mul aq alos. Na'tami teligsug gasgiptnnaqan 'ngatign. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Na tapusijig ji'nmug wesua'la'tij Se'susal aq oqonisgwepilmua'tij atla'wegnigtug wejitas'g linen, maw weljema'gewei. Na Lesui'paq ula tela'taqatijig ugjit gisgaja'lanew npuinu'l utqutalugsin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Eteg na'te'l, ta'n Se'sus etl ne'po't iga'taqan. Na na'te'l eteg pilei utqutaqan ta'n menaq wen el sma'lam'g. Gun'tew sapalqe'g i' tli utqutala'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Etna na na'gweg gesgmnaq atlasmutigisgug iga'nug, aq na utqutaqan gigjeteg'p. Etna na ugjit elsma'la'titl Se'susal na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na toqo tujiw aqantie'umg egsitpu'g, ge's me' oqonitpa'q, Mal Matle'n eliet utqutaqanigtug aq nemitoq na gun'tew gis jigla'tas'g ta'n weji pisgweta'n. Pisgwapa'sit aq mo nemitug Se'sus wa'qi tami. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","El'tugwi'g ugjit we'jian Simon Pie'l aq ni'n. Telimugsieg, “Gisi ugsua'la'titl Gjisaqamawul utqutaqanigtug aq mu gejiaqig ta'n iga'la'titeg!” Na. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Na tujiw Simon aq ni'n Sa'n el'tugwi'meg utqutaqanigtug nat nmitunen tlian. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Igantesgaq Pie'l aq tmg iga'i. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Waqjua'si aq pisgwapa'si aq nemitu atla'wegnn gatu mo siaw pisgwa'w. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ta'n tujiw Simon Pie'l iga'teg smtug siaw pisgwa't aq nemitoq atla'wegnn etegl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Na atla'wegn, ta'n ajijgopiteg'p Se'sus un'jig aq maw ugsisgug gigtoqopiteg'p gmetug ta'n igtigl atla'wegnn etegl. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Na tujiw elt ni'n pisgwa'si aq nemitu aq getlams'tm unagien. ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Glapis na tujiw mo nestasiweg Gjinisgam ugtwi'gatign tluen apaji mimaju'etew.) ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Na tujiw apajinmita'ieg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Gatu Mali eliet aq gaqama'sit gujmug utqutaqanigtug atgitemit. Me' etltemit oqolomgwa'sit aq pitapa'sit utqutaqanigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na'te'l nemiaji tapusiliji ansale'wilijig wape'gna'miliji, pemgopiliji ta'n Se'sus wa'qi eteg'p. Ansale'wijig astugopijig. Newgte'jit epit ta'n un'jig eteg'p aq igtig ta'n uggwatl eteg'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pipanima'titl, “E'pit, goqwei weji atgitemin?” Asitemaji, “Gis jigla'la'titl Gjisaqamawul aq mo gejiaqig ta'n la'la'tital!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ta'n tujiw gaq tlueteg ula, gawasgapugua'sit aq nemiatl Se'susal gaqamilitl, gatu mo gejiagul negmewilin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Se'sus pipanimatl, “Tu's, goqwei weji atgitemin? Wen ta gi'l algwilat?” Mal Matle'n tel'ta'sit negm na nuji ango'tmlij iga'taqan. Na wet tlimatl, “Saqamaw, gatu gi'l gis jigla'l'j, tlimi ta'n iga'l't'p aq ni'n nemisgua's.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Se'sus ewi'tmuaj ugwisunm teluet, “Mali!” Smtug gigto'qopugua'sit aq tetpaqi angamatl aq teluet Lesui'pewigtug, “Laponi!” telueg, “Nujigina'muet.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Se'sus telimatl, “Mut sama'liw! muta menaq apaja'siw Nujjewigtug. Gatu lia nnaqapemg aq tlim ugjit ni'n, ‘Apaja'si Nujjeg aq gilew Gujjuow, Ntnisgamum aq Gnisgamemuoq.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Na tujiw Mal Matle'n eliet aq telimaji Se'sus unaqapemg, “Gis nemi'g Gjisaqamaw.” Na tujiw telimaji ta'n gis tlimt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Aqantie'umg wela'gw unaqapemg mawtesgatultijig aq apt'sqa'mi'tipnn ga'qann muta jipala'tiji Lesui'paq iganpugultijig. Jiniw Se'sus gaqamit maw negmow. Teluet, “Wantaqo'ti i'tt'j 'ggamlamunuaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ta'n tujiw gis tlueteg ula, musga'tuaji ugpitnn aq ugtassuign. Na tujiw unaqapemg welgwitgl uggamlamunual ta'n tel nemia'tij Gjisaqamawul. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ap Se'sus telimaji, “Ignmuloq wantaqo'ti 'ggamlamunuaq. Ta'n Nujj petgimip, ap ni'n elgimuloq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Na ula teluep aq putuomaji aq telimaji, “Ignmuloq Wejuli Nisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Apigsigtmuoq mimajuinu'g ugtlue'utiwaq na apigsigtas'gtetal. Gatu mo apigsigtuawoq, na ma apigsigtas'gtnugul.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Newgte'jit unaqapeml Tuma, (telui'tut na 'Tqope'j), mo eimu'gus ta'n tujiw Se'sus pegisingeg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Glaman igtigig unaqapemg telima'titl, “Nemi'gt't'p Gjisaqamaw!” Tuma telimaji, “Mu nemituan ta'n eteg'pnn plegu'l ugpitng aq iga'tuan 'ntluign ta'n plegu'l eteg'pnn aq 'npitn ugtassuign, ma 'gtlams'tmu.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Aqantie'uti gis pmiaq, unaqapemg ap mawtesgatultijig aq Tuma wijitgweiwaji. Na ga'qann apt'sqqa's'gl. Gatu Se'sus jiniw gaqamit aq teluet, “Ignmuloq wantaqo'ti 'ggamlamunuaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Na tujiw telimatl Tumaal, “Tet iga'tu 'gtluign aq angaptmui 'npitnn. Jugwasga'tu 'gpitn aq iga'tu 'ntassuign. Pun megte'n aq 'gtlams'te'n!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tuma telimatl, “Gjisaqamaw aq 'Ntnisgamum!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Se'sus telimatl, “Nige' getlams'tmn muta gis nemi'n. Gjinisgam gisa'lataq ulgwijultinew ta'nig getlams'tmu'tijig je we'gaw menaq nemi'gwig.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Se'sus pugwelgl 'lgowaqan mesgi'gl elugwatgl unaqapemg ugsisguaq ta'n mo ewi'gas'gtnugul ula wi'gatignigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Wegla ewi'gas'gl glaman 'gtlams'tmultoqs'p na Se'sus Nujiugs'tawi'wet, ta'n Gjinisgam petgimapnn ugjit ilgwenan ugmimajuinumg, Gjinisgam uggwisl. Ta'n teli gtlams'tmoq ugwisunmg 'msntoqs'p iapjiwewei mimajuaqan wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ta'n tujiw wegla gis tliaq Se'sus 'mjit newgt neialsit aq unaqapemg nemi'jig gigjiw na qospem teluisig Galali (Taipilias). Na tel neialsit. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Na Simon Pie'l, Tuma (ta'n telui'tut, 'Tqope'j), Nataniel ta'n tleiawit na gutan Gena, Galaliewa'gig, Sepeti uggwisg, aq tapusijig igtigig Se'sus unaqapemg mawi ultesgatultieg'p ni'n aq 'nsis Ji'mej. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Pie'l telimugsieg, “Naji usgei.” Telimg'tt, “Wije'ultesnen.” El'ta'ieg aq tepita'ieg ugtuluow. Gatu ta'n tel pita'q wela'gw mo goqwei ne'pa'tueg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wejgwapniaq, Se'sus gaqamit gigjiw samqwanigtug. Nemi'g'tt ji'nm gaqamit jajigtug qospem gatu mo nenuaqatt ta'n wenij. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sesgwalugsieg, “Nitaptut, Me' tali usg'tioq?” Na teli asitemg't, “'Lpa mo goqwei ne'pa'tueg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Na tujiw teluet, “Iga'lug inaqaneg 'gta'pimuoq 'gtluaq aq pugwelgig 'msnatoqs'p.” Na tela'taqatieg'p aq mo gis tepo'laqatt'p 'nta'piminen 'ntulnaq muta wesam pugwelgig nme'ji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na tujiw telimg Pie'l, “Gjisaqamawminu na!” Ta'n tujiw nutgeg na Gjisaqamawilin, Pie'l nasa'latl ugtatla'im (pitu' pija'latl ugpita'qawe'l), paqasi unaqiet aq na'taqama'q. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na esgwieieg siawqatmu'tieg 'ntulnaq, aq na'taqama'l'g't waju'et 'nta'piminen. Mo amasenugup sitmug pas'g na'tami si'st gasgiptnnaqan leppie. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ta'n tujiw gis na'taqamita'ieg, nemitueg nugsaqatal me' pugtewigl aq nme'jig etloqsijig aq pipnaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Se'sus telimugsieg, “Jugwa'lug alt nme'jig ta'n gisi msnoqopnig.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Pie'l eliet samqwanigtug aq na'taqama'tejimatl a'pi'l sitmug. Egimaji nme'jig ta'n mesginniji aq newgt gasgiptnnaqan jel na'nisga'q jel si'st te'silitl aq je mo 'nta'piminen sewisgina'sigup. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Se'sus teluet, “Jugwita'gw aq egsitpu'gwatalultinej.” Aq mo wen ta'n te'sieg gisite'tmug pipaniman ta'n wenij, muta geji'g'tt'p negm na Gjisaqamawin. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Na tujiw Se'sus ela'mugsieg pipnaqan aq nme'ji'jg aq 'ms't mawatalultieg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na ula si'stewei Se'sus neialsit aq nemi'g'tt ta'n tujiw gisi npliteg aq minunsiteg. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ta'n tujiw gaq g'satalultieg, Se'sus pipanimatl Simon Pie'lal, “Simon, Sa'n uggwisl, me' 'gjitmi gsalin je mu ula negmow ta'n teli gsalj?” Asitematl, “E'e, Gjisaqamaw. Geitu'n gesalul.” Se'sus telimatl, “Ango'tmui 'ntjijgluewji'jmg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tapuewei Se'sus pipanimatl, “Simon, Sa'n uggwisl, gesalin?” Asitematl, “E'e Gjisaqamaw, amuj geitu'n gesalul.” Se'sus asitematl, “Ilgwenmui 'ntmimajuinumg pa wijei aq ta'n wen gigji angweiwaji ugjijgluewjmg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ap si'stewei Se'sus pipanimatl, “Simon Sa'n uggwisl, gesalin?” Pie'l ewlgwijing aq asgaiut'p ta'n tujiw ap Se'sus pipanimateg si'stewei, “Gesalin?” aq telimatl, “Gjisaqamaw geitu'n gi'l 'ms't goqwei. Geitu'n gi'l ta'n teli gsalul!” Se'sus telimatl, “Ango'tmui ntjijgluewjmg.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ta'n tujiw maljewe'juineg gis tela'tege't'p ta'n teli gsatmu't'p aq elie't'p ta'n tel puatmn gatu ta'n tujiw gisigu'en lasgattes 'gpitnn aq nat wen piluei gl'pilmuatal aq la'lultaq ta'n mo getu liewn. Teliaq telimuloq. ( ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Se'sus na ula telimapnn ugjit gnua'tuan Pie'lal ta'n tli np'tew ugjit gepmitelman Nisgamal.) Na tujiw Se'sus telimatl, “Majulgwali ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pie'l gigtoqopa'sit aq nemiatl 'gpaqamg igtigl gawasgulapa'sin unaqapeml ta'n Se'sus gesalatl, na negm ta'n elagwasipnn Se'susal ta'n etlatalultieg aq pipanimapnn, “Gjisaqamaw wen 'ntuisgalultew?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ta'n tujiw Pie'l nemi'teg pipanimatl Se'susal, “Gatu taliatew ugjit negm?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Se'sus asitematl, “Jijuaqa pualg siawa'sin glapis apaja'sian. Mut sespete'tmu! Awna ango'te'n aq majulgwali ni'n!” ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ula a'tugwaqan al se'sa's'g ta'nig majulgwala'titl Se'susal, na ula unaqapeml ma 'npligul. Gatu Se'sus mo teluegup ma negm npug. Teluep, “Pualg negm siawa'sin glapis apaja'sian, goqwei ali 'gtu 'gji'tun?” ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ni'n na unaqapeml ta'n nemituap ta'n teliaq, aq ewi'gmapnn ula wi'gatignigtug. 'Ms't geitu'g ta'n tel wi'gmapnn, na teliaqap. ");
INSERT INTO micMIQNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Se'sus pugwelg'pnn ta'n goqwe'l tela'teg'pn. Pa na 'ms't ewi'gas'gsn mo etlite'tmu 'ms't gis gugunas'gtn ula ugs'tqamu. Na 'ms't.");
INSERT INTO micMIQNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nige' ni'n Lu'g epa'si nitap, Tiopilus, aq ap ewi'gmul wi'gatign. Ta'n tujiw ewi'gmulaneg, telimulap ta'n Se'sus poqji lugwatgeg ugtlgowaqan aq 'ms't ta'n te's'g goqwei tela'tegep aq ta'n tel gina'muasni. Telimulap ta'n tel ne'po'teg aq ta'n tel minunsiteg aq wenagieteg wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Gesgmnaq wenagieteg ne'wisgegiguna'qas al se'si nemu't. Na apostale'wijig ta'n Se'sus gisi mgnapni gaqaisg nemia'tipnn. Pugwelg'snn ta'n goqwe'l tela'tegetl ugjit musga'tuan ta'n tel minunsit. Wesgutg'pnn ta'n goqwe'l tleiawigl Gjinisgam ugtelege'wa'gimg. Igan gnua'tuapni ta'n tel pualapni tla'taqatinew aq Wejuli Nisgam apoqonmuaji gisi ns'tmnew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ta'n tujiw mawo'lateg melgimaji, “Mut 'nqatmnew Selusalemg, gatu esgmalug Wejuli Nisgam ta'n Nujj teplumugsioqop. Migwite'tmoq ta'n telimuloqop ugjit negm. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Sa'n sign'tuapni e'w'g'p samqwan gatu ma 'pgije'nug, Gjinisgam sign'tugsitoqs'p e'watal Wejuli Nisgamal.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ta'n tujiw apostale'wijig aq maw Se'sus weltesgatulti'titeg pipanima'titl Se'susal, “Gjisaqamaw, nige' apaji ignmuates ml'gigno'ti Lesui'paq?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Se'sus telimaji, “Nujj gis gissutg'p na na'gweg ta'n tujiw na tliatew. Mu na teltenug gilew 'gji'tunew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Gatu gilew ugjua'lugsitoqs'p Wejuli Nisgam aq ml'gigno'ti i'tt'tew 'gtinnewaq. Na tujiw mimajuinu'g tlimatoqs'p ta'n goqwei geituoq ugjit ni'n. Tlimatoqs'p mimajuinu'g ta'n eimu'tijig Selusalemg, Jutiaewa'gig, Samaliaewa'gig, aq ta'n telgi'g ugs'tqamug.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Na ula gis tluej, Se'sus poqji unagiet. Apostale'wijig tetpaqi angama'titl. Ge's elapulti'tij eliet wa'so'q. Eli gs'ga'sitaq alugwigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Na ge's elapulti'tij musigisg'tug, telapa'sultijig tapusijig ji'nmug gaqamijig gmetug wape'gna'qig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ula ji'nmug teluejig, “Gilew, ta'n tleiaultioq Galaliewa'gig, goqwei tet gaqamultioq aq elapultioq musigisg'tug? Ula Se'sus ta'n wenagiepnaq aq eliepnaq wa'so'q na negm tli apaja'sitew nige' ta'n tel nemioqop wenagiet.” Na teluepnig ula ji'nmug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na toqo tujiw apostale'wijig nisita'jig gm'tnigtug teluisit Olipet aq apaita'jig Selusalemg. Mo piami amasenug, na'tami aqataig loqtn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Na pisgwita'jig wen'ji'guomg aq toqjuita'jig ge'gwe'g ta'n siawqatmu'tijig. Etna na ula mimajuinu'g eimu'tijig: Pie'l, Sa'n, Ji'mej, Antle', Pilip, Tuma, Paltolomiw, Matiw, aq Ji'mej na Alpius uggwisl, aq Simon ta'n tleiawit “na mimajuinu'g ta'n pajiji gsatmi'tij umutgig,” aq Suta na wijigati'titl Ji'mejal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Maw e'pijig eig'snig aq Mali, Se'sus uggwitl ap maw Se'sus ugjignamg. Te'sigisg'g 'ms't ta'n te'sijig mawalsultijig aq gaqaisg mawi a'sutma'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Newgtejgeg na'gweg etna na na'te'l pugwelgig mawita'pnig, na'tami gasgiptnnaqanijig jel tapuisgegsijig. Etna na tujiw Pie'l gaqama'sit aq teluet, ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nigmatut, amujpa na Gjinisgam ugtwi'gatign wet tliaq. Wejuli Nisgam e'wapnn Ta'pital ugjit ta'n tel glusipnaq aq iganigji'jiapna Sutao'q. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Migwite'tmug! Sutao'q mawo'ltieg'pnaq. Se'sus gisi mgnapnn i' maw lugutieg'pnaq. Gatu gisita'sipnaq ta'n tli ntuisgetutal Se'susal. Ela'lapni alt ji'nmug gegnua'tuapni ta'n tegen Se'susal, negla ji'nmug ta'n tli ugsua'lataq Se'susal.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Suta pasgine'tesing aq uligsi'l getaqqaitesgl. Na tujiw pegwatelmi'tij maqamigew ta'n teli apangitus'p ta'n gisi ntuisgelateg Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","'Ms't ta'n te'sijig mimajuinu'g wigultijig Selusalemg gaq nutma'tijig. Ta'n teli'sultijig telui'tmi'tij na iga'taqan “A'qeltama.” Na telueg, “Iga'taqan ta'n weji pgwatel's'g e'wmi'tij nepatua'gnei suliewei.”) ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Gis wi'gas'g Gjinisgam ugtwi'gatigng ta'n teluisig ‘'Gtapegiaqann A'sutmaqane'l’ asugomtesisga'q jel pesgunategewei ta'n pemapegsit tapuisga'q jel na'n aq elg gasgiptnnaqan jel pesgunategewei ta'n pemapegsit ugumuljin: ‘Na negm 'np'tew aq 'ms't goqwei negmewei naqt'tew’ (nmitu 69.25). Ap na tel wi'gas'g, ‘Na ta'n wen piluei wesua'tuaj ugt'pun ta'n negm i' tl lugwep’ (nmitu 109.8). ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Etna na ugjit igtig ji'nm megnut ta'n apostale'witewitew. Amujpa na ji'nm gis wijitgweiugsi'gw ta'n tujiw Sa'n sign'tuateg Se'susal aq ta'n tujiw Se'sus wijitgweiugsi'gweg ta'n tel mili al'ta'igweg aq glapis Se'sus wenagieteg wa'so'q. Ula ji'nm gnua'tegetew ta'n minunsipnaq Se'sus.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Telimtultijig, “Gatu nige', tegenig 'mgnatesnu? Ula ji'nm teluisit So'sep Palsapas Justus gisna Mattaias?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Na tel tawaqtmua'titl Nisgaml teluejig, “Gjisaqamaw, gi'l geitajig ta'n telgwitgl mimajuinu'g uggamlamunual. Musga'tuin ta'n tegen wegla tapusijig gisi mgnt. ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Negm wesua'tuatew Sutaal ugt'pung aq apostale'witewitew, muta Sutao'q eliepnaq ta'n tleiawij.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Elaqatijig aq elapugua'titl Mattaiasal. Maw negm nige' mawgimut newgtisgegsijig jel newgt apostale'wijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na na'gweg teluisig Pentigast iga'q, 'ms't ta'n te'sijig getlams'tua'titl Se'susal na etl mawiejig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jiniw nutmi'tij sespena'q wejiaq musigisg'tug. Pa na wijei aq melgignaq ugju'sn putueg. Na we'gwi ginta'q lamguomg ta'n epulti'tij aq maw gujm. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Na tujiw nemitu'titl teli angamgug 'st'ge' pugte'tl. Se'sita'qal 'ms't ta'n te'sijig aq sama'lugwi'titl. Wejuli Nisgaml na. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","'Ms't ta'n te'sijig pitu'gwi'titl Wejuli Nisgaml aq mestatesgagwi'titl. Poqji piltui'sultijig. Wejuli Nisgam gisa'laji na tli'sultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Etna na na'te'l Lesui'paq eimu'tijig Selusalemg ta'n gepmitelma'titl Nisgaml. Weita'jig ta'n telgi'g ugs'tqamu. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ta'n tujiw nutmi'titeg ula sespena'l, na pugwelgig mawita'jig. Na tujiw ta'n te'sijig getlams'tmu'tijig tewita'jig. Na mimajuinu'g paqalaiultijig, muta ingute'jit nutua'titl newgte'jilitl teli'silij ta'n negmow teli'sulti'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Na 'ms't ta'n te'sijig sigti paqalaiultijig aq telimtultijig, “Wegla mimajuinu'g ta'n piltui'sultijig tleiaultijig Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tal gis tliaq teli'sultijig 'st'ge' ginu? ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ginu tleiaulti'gw na maqamigal Paltia, Mitia, Mesopotamia, Jutia, Gappatosia, Pontus, E'sia, ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pligia, Pampilia, we'gaw Ijipt aq ta'n telgi'g Lipia, aq gigjiw Sailin. Alt tleiaultijig Lo'm, na mnigu teluisig Gelit, aq Alapia. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ginu na Lesui'peulti'gw aq ta'nig gawasgita'jig ugjit Lesui'peultinew, gatu 'ms't ginu nutuggwig negmow teli'sultijig ta'n ginu teli'sulti'gw. Wesgutmi'tij ta'n goqwe'l telgi'gl Gjinisgam gis tla'tegetl.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na paqalaiultijig aq mo nestmi'ti'gw. Pipanimtultijig, “Tal gis tliaq? Ula talueg?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pas'g igtigig maligima'tiji ta'nig getlams'tua'titl Se'susal aq teluejig, “Ula mimajuinu'g getgia'tijig!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Na tujiw Pie'l gaqama'sit maw igtigig newgtisgegsijig jel newgt apostale'wijig. Toqo poqji gsigawet ta'n tel glulaj pugwelgig mimajuinu'g, “Nigmatut, aq ta'n te'sioq eimu'tioq Selusalemg, jigs'tuig ni'n. Agnutmaqan geggunm ta'n getu tlimuloq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tel'ta'sultioq ninen getgia'tieg, pas'g na mo telianug. Mo ninen getgia'tiweg. Atejoqoq pesgunateg ajiet egsitpu'g. Ma wen gisi gtigiegw na tetuji egsitpu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gatu awna, etna na ula ta'n iganigjitegewinuaq Joelo'q wesgutg'pneg aq ewi'gig'pneg ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ta'n Gjinisgam gis tluep. Telimapni, ‘Etna na ula ni'n Gjinisgam tla'tega's enmigiaspiaqal na'gwegl. Elgitmultoqs'p Wejuli Nisgam aq ilgwenata 'ms't 'ntmimajuinumg. I'ttew 'gtinnewaq. Ggwisuaq aq 'gtusuaq iganigjitaqatitaq. Maljewe'jg aq gisigu'g pugwelgl ta'n milaptaqatitaq Nisgamewe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Na tliatew wegla na'gwegl, elgitmua's Wejuli Nisgam 'ntlugowinumg, gitg ji'nmug aq maw e'pijig. Negmow iganigjitaqatitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tla'tega's paqalaiwaqan musigisg'tug aq ugs'tqamug ugjit musga'tua's mimajuinu'g 'ntml'gigno'tim. Na tujiw nmitutoqs'p mal'tew, pugtew, aq ntlutew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na na'gu'set 'mgatawa'sitew aq tepgun'set 'mgwe'tew st'ge' mal'tew. Etna na ula tliatal ge'sg menaq mujgajewei na'gweg iga'nug ta'n Gjisaqamaw 'pgisintew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Gatu 'ms't wen ta'n etamatl Nisgaml ugs'tan, na negm ugs'tatew.’ Na. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Nigmatut, ta'n tleiaultioq Isle'lewa'gig, jigs'tuigw! Amuj na geituoq Se'susal na Nasaletgewa'j gisi mgnapnn Gjinisgam ugjit tla'tegelipnn ta'n tel puatg. Gjinisgam na tel musga'tugsioqop ta'n pugwelgl goqwe'l tla'tegepnn paqalaiuti'l aq ta'n teli 'npitegej. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Gjinisgam gis gisite'tg'p ugjit Se'sus ignmugsinew. Negm gissutg'p aq geitoqop ge'sg menaq telianugweg. Gilew ne'po'qopnaq aq tela'taqatioq muta ignmuoqopnig ne'pa'new. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ta'n tujiw Se'sus gisi np'geg, Gjinisgam apaji minua'lapnn muta mu telgita'sigup utqutaqane'gatig tllaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ta'pito'q teli agnimapnaq ugjit Se'susal, ‘Ni'n geitu iapjiw ni'neg Gjinisgam eig. Geji'g ni'n 'ntinaqaneg eig aq apoqonmuitew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Etna na ugjit 'ngamlamun welgwitg aq miwatmaq Gjinisgam. Ni'n ta'n tel mimajuinui elita'si ta'n teli tplumi't'p. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ma 'nqalagul ni'n 'njijaqamij utqutaqane'gatig aq ma ignmuawt ni'n na'qi tllaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ne'gaw musga'tuip ni'n ula awgti ta'n elgwenig iapjiwewei mimajuaqan. Ta'n tel gigje'win welgwitg 'ngamlamun.’ Na teluep Ta'pito'q. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nigmatut, amujpa na giasgiwewei gegnua'tuloq ugjit gujjinuaq Ta'pito'q. Nepg'pnaq aq utqutalut'pnaq. Utqutaqanm eteg aq nemitu'g me' nige' gisgug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ta'pito'q iganigjitegewinuaq aq geitoqopneg Nisgaml ta'n teli tplumt'pnn. Teplumapnn, ‘Newgte'jit ta'n wetapegsitew gi'leg elege'witewitew 'st'ge' gi'l.’ Amujpa na na teliaq muta Gjinisgam teli tplumt'pnn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ta'pito'q iganigji'toqopneg ta'n Gjinisgam getu tla'tegetew aq wesgutg'p ugjit ta'n tli minunsilital na Nujiugs'tawi'welitl ta'n petgimatal ugjit ilgwenan ugtmimajuinumg. Telueteg, ‘Negm mo 'nqatmug utqutaqane'gati, aq mo wa'qi etl gaqalaqanugupnig.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Gjinisgam minua'lapnn ula Se'sus gisi npliteg aq ninen 'ms't nemitueg'p ta'n gis tliaqap. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Gjinisgam gisa'latl Se'susal mawi espe'lin wa'so'q aq pa'silin ugtinaqaneg. Se'sus ignmut'pnn Wejuli Nisgaml ta'n teli tplumt'pnn ujjl aq nige' Se'sus ignmugsi'gul Wejuli Nisgaml. Etna na ula ta'n nige' nemugsioq aq nutuoq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ta'pito'q nepg'pnaq aq utqutalut'pnaq. Pas'g ugjijaqamitl wa'so'q eliepnaq mo wa'qiwal. Gatu agnimapnn Se'susal ta'n teluepnaq, ‘Gjisaqamaw, na Wegwisit Nisgam, telimatl ni'n Gjisaqamaw: Pa'si tet 'ntinaqanmg ta'n gepmitelmulg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Glapis pegwatesg't ta'n getan'sg aq na tujiw gi'l iganpugutuates.’ Na teluep Ta'pito'q. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Etna na ugjit nige' ni'n Pie'l telimuloq 'ms't ta'n te'sioq tleiaultioq Isle'lewa'gig. Gjinisgam apaji minua'latl Se'susal aq gisa'latl Gjisaqamawilin aq iganpugutuan ta'n te'silitl wen. Etna na ula tel pualuloq gji'tunew tlian, ula na wijei Se'sus ta'n gilew gujjiewto'qopnaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na mimajuinu'g nutmi'titeg na mesgata'sultijig aq welmaita'-sultijig. Telima'titl Pie'lal aq igtigig apostale'wiliji, “Tala'taqatitesnen nige?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pie'l telimaji, “Gawasgita'sultigw aq jiglita'gw elue'utigtug. 'Gtlams'tasultigw Se'susewigtug, aq Gjinisgam apigsigtugsitoqs'p 'gtlue'utiwal aq ignmugsitoqs'p Wejuli Nisgaml. Na tujiw sign'tasultigw Se'suguli ugwisunmg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Etna na ula Gjinisgam teli tplumugsioqop gilew aq gn'januaq aq maw ta'nig gneg eimu'tijig ugjit 'ms't ta'n te'siliji ta'n Gjisaqamaw Gnisgaminu wigumaji ugjit negm.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pie'l ap angu tlimaji aq munsaiwaji, “Wa'so'q 'gtu 'lta'ioq, amujpa na ignmuoq Gjinisgam ugs'tawugsinew glaman ma 'lta'woq mn'tua'gig ta'n negla elue'ultijig mimajuinu'g i'ttaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pugwelgig negmow getlams'tmu'tijig gelu'lg agnutmaqan aq sign'tasultijig. Na na'gweg si'st pituiptnnaqanijig mimajuinu'g angua'lutpni maw negmow. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Te'sigisg'g, 'ms't ta'nig getlams'tasultijig weltesgatultijig aq wej agnutmasultijig wegla apostale'wijig. Mawi emtoqwala'titl Nisgamal aq mawi a'sutma'tijig aq mawatalultijig Gjisaqamaw ugwela'gewe'm. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Gjinisgam ignmuaji apostale'wijig ml'gigno'ti ugjit lugwatmnew paqalaiuti'l aq gnugwaqann. Etna na ugjit 'ms't wen gtlamitelma'titl Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","'Ms't ta'nig getlams'tmu'tijig gigjiatultijig aq tepi'sultijig ta'n goqwei geggunmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ta'n tel nuta'ma'tij netuisgetu'titl ugmaqamigemual gisna nat goqwei ta'n ugtaligam aq ignmujig suliewei ta'n teli ugtmite'tmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na te'sigisg'g weltesgatultijig 'gjia'sutuo'guomg aq mawatalultijig alt wiguowaq. Miwatmua'tij Nisgaml ta'n telatalulti'tij aq uggamlamunual welgwitgl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","'Ms't ta'n te'sijig getlams'tmu'tijig miwatmua'titl Nisgamal. Esgwia'tijig wel'te'lmatiji. Te'sigisg'g Gjisaqamaw angua'laji mimajuinu'g ta'n westa'tiji. Na pem pugwelieji ta'nig getlams'tua'titl Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Newgtejgeg na'gweg Pie'l aq Sa'n ela'tijig 'gjia'sutuo'guomg assma si'st ajiet gis mewlia'gweg. Na tele'g Lesui'paq a'sutma'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Gmetug na ga'qana'tas'g teluisig “Weliangamgug Ga'qana'tas'g” eig'p na ji'nm ta'n mo gisi ala'sigup weja'tegemgeg ugs'tqamuiteg. Te'sigisg'g elapilut aq epa'lut gmetug ula ga'qana'tas'g. Suliewei etawaqtmuaji mimajuinu'g ta'nig el'ta'liji 'gjia'sutuo'guomg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ta'n tujiw nemiateg Pie'lal aq Sa'nal pem pisgwa'tilij, etawaqtmuaji nat goqwei ignmugsin. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tegpaqiw angama'titl ugsisgug aq Pie'l teluet, “Ge' angamin ninen!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Toqo negm angamaji. Etlitelmaji nat goqwei ignmugsin. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pie'l telimatl, “'Lpa mo suliewei geggunmu pe'gaj! Gatu ignmultes ta'n goqwei geggunm. El sapu tl lugwei ugwisunmg Se'suguli tleiawit Nasaletg. Ugml'gigno'timg melgimul pmia!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Na tujiw wesua'latl inaqaneg ugpitng aq apoqonmuatl unaqa'silin. Smtug na ji'nm uggwatl aq ugtatga'lamg melgignewa'tiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Na weji unaqa'siet aq gaqama'sit. Na smtug poqji ala'sit, pisgwa't 'gjia'sutuo'guomg maw negmow. Pemi ala'sit aq pemi unaqiet, miwatmuatl aq emtoqwalatl Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Pugwelgig mimajuinu'g migwama'tipnn pemielitl, pem miwatmuatl Nisgamal aq pemi emtoqwalatl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sapama'titeg na nuttawaqtmalipnn i' pmgopilipnn 'gjia'sutuo'guomg gmetug ga'qana'tas'g teluisig, “Weliangamgug.” Na 'ms't ta'n te'sijig sigti paqalaiultijig ta'n tel gis ula'tigl uggwatl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ge's ula ji'nm gennaji Pie'lal aq Sa'nal 'ms't ta'n te'sijig mimajuinu'g el'tugultijig na'te'l Salamano'q ugtusatimg. We'gaw gaq paqalaiultijig ta'n nemitu'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pie'l nemiateg mimajuinu'g telimaji, “Nigmatut, Isle'leultioq, tal gis tel paqalaiultioq nige' ugjit ula, aq tal gis 'gsigawi angamieg? Etug tel'ta'sultioq ninen na gis tla'tegeieg e'wmeg ninen 'ntml'gigno'timinen gisna ta'n tel sape'wieg gisa'l'g'tt ula ji'nm pmien. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Gjinisgam Gisiteget ta'n Aplamo'q Isaqo'q aq Je'gopo'q emtoqwala'tipnn maw 'ms't gujjinaqi'g na Gjinisgam ignmuapnn 'gjigepmitelgaqanm uggwisl Se'susal ta'n ne'gaw i' lugowtl. Gilew ugpitnuaq iga'loqop ta'nig assusultijig aq gilew mo menuaqalawoqop Pilot ugsisgug. We'gaw Pilot gisita'siteg assumsilin. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Na negm sape'wit aq welm'toq pas'g gilew mo menuaqalawoqop awna gilew etamoqop Pilot ugjit iga'lan nut ne'pa'tegelitl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Gilew ne'po'qopnaq na newgte'jit ta'n gis sa'q gisitoqop mimajuaqan, pas'g Gjinisgam weji unaqa'lapnn utqutaqane'gatig aq gis minua'latl. Getloqo ninen na tel nemitueg'p. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Etna na ml'gigno'ti Se'sus ugwisunmg eig aq ula ml'gigno'ti gisa'lapnn ula ji'nm uggwatl melgignewa'tuapnn. Ta'n goqwei nemituoq aq geituoq gis tliaq ta'n teli gtlams'tasij Se'sus ugwisunmg. Getlams'tasiteg Se'susal gisa'lapnn ji'nmul ila'silitl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nigmatut, geitu ta'n goqwei gilew aq iganpugultijig gis tla'la'tipnn Se'susal, wet tla'taqatipnig muta mo gejiawoqop ta'n wen Se'sus. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Gjinisgam sa'q telimapni iganigjitegewinugi'g aq negmow telima'tipni mimajuinu'g. Ulmaje'tew na ula Nujiugs'tawi'wet. Na tujiw Nisgam teli iga'toqs'p na tlian. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Na nige' gawasgita'sultigw aq jiglita'qw lue'utigtug. 'Lta'gw Nisgamewigtug aq siaw majulgwalug Gjinisgam glaman negm gasa'tugsitoqs'p 'gtlue'utiwal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Etna na tujiw Gjinisgam Gjisaqamaw apoqonmugsitesnu tla'taqatinenu ta'n tel tetapua'latesnu. Gjinisgam gaqaisg minua'lugsitesnu ugml'gigno'timg aq ml'gignewa'lugsitesnu ta'n teli gtlams'tasulti'gw aq apatgimatal Se'susal na Nujiugs'tawi'wet ta'n gisi mgnutg ugjit gilew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Amujpa siawqatg negm wa'so'q glapis tetaputesg iga'q ta'n tujiw 'ms't goqwei pilei gis minui'tas'g. Gjinisgam sa'q gegnua'tuapni sape'winu'g iganigjitegewinugi'g aq na telima'tipni mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mowiso'q teluepnaq, ‘Na Gjisaqamaw, Gnisgamemuoq petgitmugsitoqs'p iganigjitegewinu 'st'ge' ni'n, ugjietew ta'n gilew wettaqia'tioq. Amujpa na jigs'tuoq ta'n te's'g goqwei telimugsioq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ta'n wen mu jigs'tuagul ta'n teluelij negla iganigjitegewinul tepgisa'laten Gjinisgam ugtmimajuinumg aq 'gsega'tew, iapjiw ulmaje'tew mn'tua'gig.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Weja'tegemgeg Samuel aq igtigig iganigjitegewinugi'g glapis nige, 'ms't ta'n te'sijig wesgutmi'tipnn wegla na'gwegl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gjinisgam teplumugsioqopnn ta'n goqwe'l ewi'gas'g ugtwi'gatignigtug ta'n tujiw gelulateg negmewe'g iganigjitegewinugi'g ugjit gilew. Gjinisgam mawa'lugsioq ta'n teli tplumapni gujjinaqi'g. Telimapna, Aplamo'q, ‘Gi'l ta'n wettaqien, ni'n ignmua's ulapetmnew ta'n te'sijig mimajuinu'g ugs'tqamug.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Na Gjinisgam megnapnn uglugowinuml Se'susal aq gilew tmg elgitmugsioqol. Gjinisgam wel'telmugsioq. Gisa'lugsioq 'ms't ta'n te'sioq gawasgita'sultinew aq jiglita'new 'gtlue'utiwal.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pie'l aq Sa'n me' etl agnutma'tijig mimajuinu'g ta'n tujiw patlia'sg, nuje'waji 'gjia'sutuo'guomei sma'gnisg, aq Satusiaq peita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pem siwa'l'ji aq taqala'l'ji muta ula tapusilijig apostale'wiliji etl gina'magwi'tiji mimajuinu'g aq telueliji, “Se'sus nepg'pnaq aq apaji mimaju'ep. Ula musga'tugsi'gw ta'n nepu'tijig apaji unagita'taq aq apaji mimajua'titaq.” Na tel gina'mueliji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Na tujiw wesua'lujig Pie'lo'q aq Sa'no'q aq pija'lujig laplusang glapis ap igtig na'gweg, muta gis wel piluamugwiaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Gatu na pugwelgig ta'n nutmi'titeg ula gelu'lg agnutmaqan getlams'tmi'tij. Ta'nig getlams'tua'titl Se'susal nige' eimu'tijig na'tami na'n pituiptnnaqanijig ji'nmug aq maw e'pijig aq mijua'ji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na wapg iganpugultijig Lesui'paq, natawo'ltijig ji'nmug, aq nujigina'mua'tijig ugt'tplutaqanmuow mawagnutma'tijig Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Weltesgatultijig maw espe'litl patlia'sl Annasl, Gaiapasal, Sa'nal, Alegsantelal, aq igtigig ta'n tleiaultijig espe'litl patlia'sl wigumaq ugjit ilsumanew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pie'l aq Sa'n getaqa'lujig laplusang aq ela'lujig ta'nig iganpugultijig. Pipanima'tiji, “Ta'n gis tla'tegeioq na, talamu'g ml'gigno'ti geggunmoq aq wen ugwisunm e'wmuoqs'p?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pie'l ilgwentl Wejuli Nisgaml asitemaji, “Saqamawtut, gilew ta'n iganpugutuoq mimajuinu'g aq gilew ta'n natawo'ltioq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ge's piam mil pipanimieg gisgug ta'n tel goqwei gis tliaq ulagu ugjit ta'n tel ula'l'qat na ji'nm mo gis pmiegup aq ta'n tel gisi ila'sip. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Na nige' nat goqwei telimuloq 'ms't gilew aq 'ms't ta'n te'sijig 'ntmimajuinumg Isle'laq. Ula ji'nm gaqamit ta'n nemioq 'lpa gaqi ila'sit. Na gis tliaq wet sapu tl lugweg ml'gigno'ti ta'n eig ugwisunmg Se'sus Nasaletgewa'j. Gujjiewto'qopnaq aq nepg'pnaq, gatu Gjinisgam wej minua'lapnn utqutaqane'gatig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Etna na negm Se'sus ta'n gelu'lg wi'gatign wesgumj pa na wijei aq gelu'lg gun'tew. Telueg, ‘Na gun'tew ta'n nujitaqatijig mo puatmi'tigup. Etna na ula maw gelu'lg gun'tew gejigiaqewei aq 'ms't goqwei mawn'g.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Pas'g negm na Se'sus gisi ugs'tawiaji mimajuinu'g. Mo wen eimug ugs'tqamug ta'n gisi ugs'taultew, pas'g negm. Gjinisgam gisite'tg'p ta'n teli gtlams'tasulti'gw Se'sus na tli ugs'ta'titesnu.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ta'n te'sijig iganpugultijig gaq paqalaiultijig ta'n tel melgita'lij Pie'lal aq Sa'nal. Gisi gji'jia'titeg maqatawe'gig ula ji'nmug aq mo gina'masuti geggunmi'tigw. Etna na tujiw migwite'tmi'titeg ta'n teli wijitgweiwa'tipnn Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Na tujiw 'lpa mo gis talua'ti'gw muta nemia'titl ji'nmul gisi npisilitl gaqamilitl na'te'l maw Pie'l aq Sa'n. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Na tujiw telima'tiji, “Jigla'tigw ta'n i' tl mawaganutma'timg.” Aq poqji il agnutma'tijig pas'g negmow. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Pipanimtultijig, “Tala'latesnug wegla ji'nmug? 'Ms't ta'n te'sijig wigultijig Selusalemg geitu'tij paqalaiuti'l gis tla'tegetij wejiaq Gjinisgamewigtug aq ginu iganpugua'ti'gw mo gisi megtmu'tigw. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pas'g mo puatmi'ti'gw ta'n gis tliaq piam se'sa's'gtn mimajuinuigtug. Ge' gnua'tuanej mut nugu usgutmui'tij Se'susal ugwisunm mimajuinuigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Apaji wiguma'tiji Pie'lal aq Sa'nal aq telima'tiji, “Ta'n getu tliaq, mut wen wi'tmuanew gisna mut tal gina'muenew ula ji'nm teluisit Se'sus.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pas'g Pie'l aq Sa'n asita'puguejig, “Gilew telimieg, ta'n goqwei Gjinisgam wel'te'tg awna gilew jigs'tuleg gisna Gjinisgam jigs'taqatt? ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ma gis punajo'tmueg ta'n goqwei ninen gis nemitueg aq ta'n tel nutmeg.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Iganpugua'tijig melgi gnua'tua'tiji, na tujiw iga'la'tiji ugjit assumsinew. Mo goqwei we'jitu'ti'gw ta'n tli ugtapulataq. Ta'n te'sijig mimajuinu'g miwatmua'titl aq emtoqwala'titl Nisgaml ta'n goqwei gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ula ji'nm ta'n gisi npilut'p me' aq ne'wisgegipuna't. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ta'n teli nqase'g iga'luteg Pie'l aq Sa'n apaja'tijig ta'n wigumaq eimu'tilij aq telima'tiji ta'n telimgwi'tij iganpugultijig patlia'sg aq natawo'ltijig ji'nmug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nutmi'titeg smtug mawasultijig newgte' teli angita'sultijig aq eli a'sutma'titl Nisgaml na, “Gjisaqamaw, Gisiteget. Gis sa'q gisitoqop wa'so'q ugs'tqamu, 'gta'n, aq ta'n te's'g goqwei eig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Gjinisgam gi'l elsaputi glusint'p uglugowinumaq, nujjinenaq, Ta'pito'q. Wejuli Nisgam gisa'lapnn Ta'pito'q ewi'gmlipnn, ‘Tal gis mimajuinu'g ta'nig mo Lesui'peulti'gw tel melgita'jig aq getana'titl Nisgaml? Mo tali ula'lugwi'ti'gw ta'n teli igani ilsutaqati'tij aq gisite'tmi'tij na mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Na elege'wijig ugs'tqamug gisgaja'sultijig ugjit matnaqqewaqan. Ilsutaqatijig mawtesgatultijig 'gtananew Nisgaml aq na ji'nmul ta'n petgimapnn ugjit ilgwenan aq ugs'tawian ugtmimajuinumg.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","'Lpa we'gaw Elot aq Pons Pilot mawita'jig 'gjigang maw ta'nig mo Lesui'peulti'gw, aq Lesui'paq na mimajuinu'g ta'n teluisultijig Isle'laq. Ilsutaqatiji 'gtananew Se'susal na gi'l sape'wit 'gtlugowinum. Etna na negm Nujiugs'tawi'wet ta'n gi'l gisi mgnt'p ugjit ilgwenan aq ugs'tawian ugtmimajuinumg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Na gis mawasulti'titeg tla'taqatinew 'ms't goqwei ta'n gis igan ilsutmu't'p na tlian. 'Gml'gigno'timg gis tliaq ta'n teli ul'te'tmu't'p. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Gjisaqamaw, nemi't'pni negla ta'nig getu getanugsieg, nuta't'pnig ta'n telimugsieg'pnig aq ta'n getu tla'lugsieg. Etamuleg ignmuieg 'gtlugowinumg ml'gito'ltinen ta'n tel pestunmu'tieg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Jugwasga'tu 'gpitn aq gisa'tuten paqalaiuti'l aq mili npitaqatinen 'lsaputas'gtn ugwisunmg sape'wit ugtlugowinum Se'sus. Na tliaj.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ta'n tujiw gaqi a'sutma'titeg ta'n wesgowita'pnig mattesg'p. 'Ms't ilgwengwi'titl Wejuli Nisgaml, aq poqji wesgutmi'tij Nisgaml ugtagnutmaqanm, melgito'ltijig ta'n teli usgutmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ta'nig getlams'tmu'tipnig Se'susal, newgte' teli angita'sultijig. Mo wen teluegw ta'n goqwei ugtaligam negmewei pas'g 'ms't tepi'sultijig ta'n te's'g goqwei geggunmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Wejuli Nisgam gisa'laji 'ntawewistu'tinew aq tlimanew mimajuinu'g ta'n tel nemitu'tip Gjisaqamawl Se'susal ta'n tel minunsiliteg. Gjinisgam gisa'laji welgwitgl uggamlamunual ignmuaji ulapetmnew 'ms't goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ta'nig assutmi'titl ugtiga'taqanual gisna wen'ji'guoml netuisgetu'titl aq pegisitu'tij suliewei. Aq ignmua'tij apostale'wiliji ugjit se'si ignmuetunew te's ingute'jit ta'n tel nuta'maj. Glaman mo wen eimu'gup je newgte'jit ta'n nuta'map. ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na gis tliaq So'sep na Li'paiewa'j ta'n ugs'tqamuip Saiplus, apostale'wijig telui'ta'titl Pnnal, ('Nnuigtug Pnnal na tel glusuaqanig “ta'n wen nuji ulim'sg.”) ");
INSERT INTO micMIQNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ula ji'nm gisi ntuisgetoq newgte' ugtiga'taqan aq pegisitoq suliewei aq ignmuaj apostale'wiliji ugjit se'si ignmuetunew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gatu ap igtig ji'nm teluisit Ananaias, ugte'piteml teluisilitl Sapila, netuisgetu'tij ta'n goqwei negmow assutmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Gmetug iga'toq ta's'g suliewei ugjit negm, aq ugte'piteml geitulij. Na tujiw ignmua'tij esgwiaq suliewei apostale'wiliji 'st'ge' na 'ms't ignmuaj. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pie'l pipanimatl, “Ananaias, goqwei ugjit wet tliamj Gjimn'tu ilgwenmulin 'ggamlamun aq gisa'l'sg gi'l egs'pugua'lan Wejuli Nisgam ta'n tujiw gmetug iga'tun ta's'g na suliewei mesnmu't'p ugjit ta'n goqwe'l assutmu't'p? ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ge's mo netuisgetuneg ta'n goqwei assutmn, gi'lewe't'p aq gisi 'ntuisgetuneg. Na suliewei gi'lewe't'p. Talgwitg's 'ggamlamun ugjit na tla'tegen? Mo egs'pugua'lawt ji'nm awna egs'pugua'l't Gjinisgam.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ta'n teli nqase'g Ananaias nutgeg etli msaqaniet aq nepgaq. 'Ms't ta'n te'sijig nutmi'titeg, jipaqita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Maljewe'jg ji'nmug eig'pnig, oqonisgwa'tua'tij wa'qi aq tewa'la'titl aq nutqutala'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Panaemg nesisgl ajietl, ugte'piteml pisgwa'litl aq mo geitug ta'n goqwei gis tliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pie'l pipanimatl, “Tlimi, ula na 'ms't suliewei gi'l aq 'gji'nmum mesnmoqop ta'n tujiw netuisgetuoq ta'n goqwei gilew assutmoqop?” Teli asitematl, “E'e 'lpa 'ms't waju'aq.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pie'l telimatl, “Goqwei gi'l aq 'gji'nmum gisita'sioq iga'loq Wejuli Nisgam ugtnu'gwalanew? Ula ji'nmug ta'nig gisi utqutala'titl 'gji'nmuml eimu'tijig ga'qanigtug nige' aq negmow tewapilultaq gi'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Smtug eli msaqanielitl Pie'l uggwatg aq neplitaq. Ula maljewe'jg ji'nmug pisgwita'jig, nemia'titl e'pilitl neplitl. Na oqonisgwa'tua'tij wa'qi, tewapila'titl aq nutqutala'titl gmetug ugji'nmuml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","'Ms't ta'n te'sijig nutmi'titeg a'sutme'winu'g aq maw igtigig ma'mun we'gwata'sultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na apostale'wijig mili npitaqatijig mimajuinu'g aq tela'taqatijig paqalaiwaqan. 'Ms't ta'n te'sijig getlams'tasultijig Se'suseg i' weltesgatultijig Salaman ugtusatimg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ta'nig mo getlams'tasulti'gw mo tetujitolti'gw ugjit wijitgweiwanew, gatu weli usguma'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Aq pem pugweliejig na mimajuinu'g ta'nig getlams'tasultijig Se'suseg. Pugwelgig ji'nmug aq maw e'pijig getlams'tasultijig aq wit toqwa'la'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na apostale'wijig mili npitaqatijig aq pugwelgl wejiaqal Nisgamewigtug tela'taqatijig paqalaiwaqan. Na glaman gesnugu'tiliji mimajuinu'g tewapila'tiji awgtigtug aq iga'la'tiji a'su'nigtug, glaman ta'n tujiw Pie'l pmiej je tlia pas'g pmi ugjijaqamiju'ej na, na gisi npisultitaq, na tel melgi gtlams'tasultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na pugwelgig mimajuinu'g weita'jig gutanji'jg ta'n telgi'g Selusalemg. Petapila'tiji ugsnugowinu'g aq ela'la'tiji ta'nig mn'tu'g wesgweiagwi'tiji aq 'ms't gisi npila'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na espe'g patlia's aq 'ms't unaqapemg maw na Satusiaq, ma'muniw wisgua'la'tiji apostale'wiliji. Na gisita'sultijig na tala'lanew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Na wesua'la'tiji apostale'wiliji aq pijo'la'tiji laplusang. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Gatu na wela'gw Gjinisgam ugtansale'witeml pegisinnitl aq panta'toq laplusanei ga'qana'tas'g. Tewa'laji apostale'wiliji aq telimaji, ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“'Lta'gw 'gjia'sutuo'guomg, pisgwita'gw aq tlimug mimajuinu'g, ‘Ta'n tujiw getlams'tasin Nisgamewigtug gawasga's'gt'tew ta'n tele'n. Na tujiw gegnu mimajites.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Apostale'wijig jigs'tgig aq ta'n tujiw wejgwapniaq, pisgwita'jig 'gjia'sutuo'guomg aq poqji gina'mua'tijig. Na espe'g patlia's aq unaqapemg wigumaji 'ms't Lesui'paq natawo'ltijig ji'nmug mawagnutma'tinew. Elgima'tiji ji'nmug laplusang ugjit ugjo'lanew apostale'wiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ta'n tujiw ji'nmug iga'titeg, mo we'jia'tigwi apostale'wiliji laplusang. Smtug apaita'jig iganpugultiliji aq gegnua'taqatijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Teluejig, “Ta'n tujiw iga'ieg laplusang we'jitueg seggiapt'sga's'g aq ta'nig nujo'tmi'tij laplusang ango'tmi'tij ga'qana'tas'gl melgi pijo'qas'gl. Gatu ta'n tujiw pana'tue'g ga'qana'tas'gl mo tami we'jia'tigwi apostale'wiliji.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ta'n tujiw nuje'waji 'gjia'sutuo'guomei sma'gnisg aq iganpugultijig patlia'sg nutmi'titeg paqalaiultijig ta'n imu'tigunig apostale'witgi'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na tujiw ji'nm pegising aq pisgwa't, telimaji, “Jigs'tuig! Wegla ji'nmug gilew pija'loqopnig laplusang eimu'tijig nige' 'gjia'sutuo'guomg. Etl gina'mua'tiji mimajuinu'g.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Na ji'nm ta'n nuje'waji sma'gnisg aq ugsma'gnismg maita'jig aq apaja'la'tiji apostale'wiliji. Mo gi'gaji ugsua'la'tigwi muta am jipasultijig ugjit mimajuinu'g jijuaqa gun'teugte'gutaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pegisula'tiji apostale'wiliji ta'n iganpugultijig eimi'tij aq espe'g patlia's mil pipanimaji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Na tujiw telimaji, “Ninen melgimuleg'p mo nugu al gina'mua'tinew ula ji'nm teluisit Se'sus. Nemitun nige' ta'n gis tla'taqatioq. Gilew se'sa'tuoq ta'n tel gina'mua'tioq ta'n telgi'g Selusalem, aq gilew pualieg ninen getu su'tmuieg ta'n tel ne'po't'pnaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pie'l aq igtigig apostale'wijig asitema'tiji, “Ma gis jigs'tuaqatjig ji'nmug. Amujpa na jigs'taqatt Gjinisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nujjinaqi'g emtoqwala'tipnn Gjinisgaml Gisitegelitl. Nige' negm wenaqa'lapnn Se'susal gisi npliteg. Gilew na tel ne'po'qopnaq na gujjiewto'teg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ula Se'susal epa'lapnn ugtinaqanmg Gjinisgam ta'n mawi espe'g Gjielege'witewilin aq Nujiugs'tawi'welin, glaman mimajuinu'g Isle'lewaq gis gawasgita'sultitaq aq gis jiglita'taq elue'utigtug aq Gjinisgam apigsigtuataq ugtlue'utiwal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ninen tel nemitueg'p ta'n teliaqap aq ta'n nige' telimuleg'p goqwe'l Gjinisgam gis tla'tegetl, aq Wejuli Nisgam gegnu'tmugsioq ta'n goqwei Nisgamewei. Ta'n wen Nisgaml jigs'tuatl Gjinisgam petgimatl Wejuli Nisgaml apoqomagun.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ta'n tujiw iganpugultijig nutmi'titeg tetuji uggwaiultijig, smtug gisita'sultijig apostale'wiliji ne'po'qsinew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pas'g na newgte'jit na Palasi teluisit Gamaliel nujigina'muet 'tplutaqan, aq espite'tasit, gaqama'sit. Telimaji sma'gnisg ugjit tua'lanew apostale'wiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Na tujiw telimaji igtigig iganpugultiliji, “Wijigatultioq, Isle'leultioq, ango'tmug ta'n getu tla'loq wegla ji'nmug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Te'sipunqe'g Teutas neia'sip. Tel'ta'sit negm nat wen mesgilg. Na na'tami ne'w gasgiptnnaqaniji ji'nmug peji wije'wapni. Pas'g na ne'po'teg, ta'n te'siliji majulgwalt'pni gaq se'sa'toqotipnig. Etl gaqiaq na'te'l ta'n tel lugutipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ap na Suta ta'n tleiawit Galali neia'sip ta'n tujiw al mawi'giget. Negm elt pugwenniji mimajuinu'g majulgwalt'pni. Negm elt ne'po't'pnaq aq ta'nig majulgwalt'pni gaq se'sa'toqotipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Pa na nige' wijei wegla ji'nmug, telimuloq mut tala'lanew! Punaje'wg! Pa na ula ji'nmug gisite'tmi'tij, ugs'ga's'gt'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Gatu ugjiaq Nisgamewigtug ma gis tla'taqatiwoq. Weji'sultitoqs'p Gjinisgam etl matnoq!” Na iganpugultijig jigs'tua'titl Gamaliel ta'n teluelij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Apat gima'tiji apostale'wiliji, telima'tiji sma'gnisg ugjit matta'new. Na tujiw melgima'tiji, “Mut nugu usgumanew Se'sus.” Na tujiw iga'la'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apostale'wijig naqtmi'tij ta'n iganpugultijig eimi'tij. Welgwijultijig muta Gjinisgam tetapuitelmaji 'ntaqo'qona'lugsinew ugjit Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Te'sigisg'g 'gjia'sutuo'guomg aq mimajuinu'g wiguaq siaw gina'mua'tiji aq siaw pestunmua'tiji gelu'lg agnutmaqan ugjit Nujiugs'tawi'welitl, na ji'nm ta'n Gjinisgam petgimapnn ugjit ilgwenan ugtmimajuinumg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ta'sijig tepgun'set'pnig me' pem pugwelietiteg unaqapemg. Gi'gaita'jig ta'pu nemigsijig Lesui'paq. Newgte' ugtli'sutiwow Lesui'peweiei gatu igtigig tapu'gl ugtli'sutiwal Lesui'peweiei aq Gli'gewei. Lesui'paq ta'nig Gli'gewisultijig teluejig, “Gli'gewi'sgwaq sigu'sgwaq mo mesnmi'tigw suliewei ta'nig te'sigisg'g ignmuetu'tij.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Na tujiw newgtisgegsijig je ta'pu apostale'wijig wiguma'tiji ta'nig getlams'tasultiji. Telima'tiji, “Mo weltenug ugjit ninen liaptmenen ta'n tel pestunmatmeg Gjinisgam ugglusuaqanm ugjit nujo'tmnen suliewei ugjit sigu'sgwaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Glaman, wijigatulti'gw, 'mgnug lluigneg te'sijig ji'nmug te'sioq ta'n wen gilew gejioq ilgwengwi'titl Wejuli Nisgaml aq ta'nig natawo'ltijig. Negmow ignmuatesnu 'lgowaqan nuje'wanew sigu'sgwaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Gatu ninen, gisi igalsultitesnen 'ms't 'ntlgowaqanminen a'sutmaqanigtug aq pestunmuaqanigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Na 'ms't ta'n te'sijig wel'ta'sultijig ta'n apostale'wiliji teluelij. Na megna'tiji: Stipen (E'gia'n) ta'n melgi gtlams'tasit aq ilgwentl Wejuli Nisgaml, maw Pilip, Ploqolus, Niganal, Timon, Palmenas, aq Nigulas ta'n tleiawit Antioq, mo Lesui'pewigw, gatu majulgwatg Lesui'peweiei. ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Na mimajuinu'g telima'tiji apostale'wiliji, “Etna na wegla gisi mgng'tjig.” Na apostale'wijig a'sutmessewa'tiji aq ge'gwa'tua'tij ugpitnual te's ingute'jit. Na tel tepgisa'la'tiji ugjit ula lugowaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Na te'sigisg'g pem pugweliejig ta'n tel nutmi'tij Gjinisgam ugglusuaqanm aq getlams'tmi'tij Selusalemg. We'gaw maw pugwelgig patlia'sg getlams'tasultijig gelu'lg glusuaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stipen melgi gtlams'tasit aq Gjinisgam e'watl. Ignmuaj ml'gigno'ti ugjit mesgi'gl tla'tegen aq mili npitegen mimajuinuigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Na tujiw ta'sijig ji'nmug getana'titl. Naspultijig “Lipltinewaq” ta'nig gisteju'ltipnig gatu nige' assumsultijig. Negmow tleiaultijig Silisia, aq Alegsantlia. Negmow aq maw igtigig Lesui'paq tleiaultijig, Silisia aq E'sia poqji gi'gaja'suala'titl Stipenal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Gatu Wejuli Nisgam ignmuatl Stipenal ta'n teli ns'tuewistulij ta'n tujiw gelusij, na mo gis tali asitema'tigul. ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","We'gaw na Lipltinewaq apangitua'tiji ta'siliji ji'nmug tluenew, “Ninen nutaqatt'p ta'n teli gtanaj Mowiso'q aq maw Nisgaml.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Gisa'la'tiji mimajuinu'g maw natawo'ltijig ji'nmug aq nujigina'mua'tijig 'tplutaqan 'gtananew Stipenal. Peita'jig ta'n Stipen eig wesua'la'titl aq ela'la'titl ta'n iganpugultijig eimi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pegisula'tiji ji'nmug ugjit ta'n tli egsuelitaq. Teluejig, “Ula ji'nm getantoq ta'n teli usgutg ginu gepme'g 'gjia'sutuo'guom aq 'tplutaqann Mowisewe'l. ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ninen nutaqatt'p telueteg, ‘Ula Se'sus Nasaletgewa'j seioqte'tew 'gjia'sutuo'guom aq gawasga'tutal ginu ta'n telo'lti'gw ta'n Mowiso'q tel gnu'tmuapni gujjinaqi'g.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","'Ms't ta'n te'sijig pemgopultijig iganpugultijig, gesi angama'titl Stipenal, teli angamgug ugsisgw 'st'ge' ansale'wit. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na espe'g patlia's pipanimatl Stipenal, “Teliaq na ula ta'n teluejig?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stipen teluet, “Nigmatut, jigs'tuig! Gjinisgam ta'n gepme'g neialsiteg gujjinu Aplam ge's eigeg na maqamigew Mesopotamia ge'sg menaq natgatmugweg 'gjigan Qallan. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na telimapnn, ‘'Nqal gigmaq aq gm'tgig aq lia na maqamigew ta'n ni'n musga'tultes.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","A' na naqt'g na maqamigew teluisig Jaltia aq eliet natgatg gutan Qallan. Ta'n tujiw Aplamo'q ujjl nepliteg Gjinisgam gisa'lapnn jigla'silin aq lielin ta'n nige' ginu eimu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Gjinisgam na tujiw mo ignmuagup Aplamal je talgi'g assutmn. Mu ignmuamug'p je 'mtijin. Gatu Gjinisgam teplumapnn ignmuan aq na tujiw, assuttew negm aq ta'n wettaqia'tijig. Ta'n tujiw Gjinisgam teplumateg Aplamal aq ugte'piteml mo mijua'ji'jg gegguna'tigupni. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Etna na ula Gjinisgam telimapnn Aplamal, ‘Gi'l aq 'gte'pitem ta'n wettaqieioq, wigultitaq na maqamigew ta'nig piluei iganpugultitaq ne'w gasgiptnnaqanipunqeg. Na'te'l gistejuultitaq aq emegwo'tasultitaq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Gjinisgam teluep, ‘Ugtapula's na mimajuinu'g ta'nig gistejue'galugsioq. Na tujiw apaja'la's ula maqamigew aq tet tli emtoqwalitaq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Na tujiw Gjinisgam, telimapnn Aplamal, ‘Ta'n te'sijig ji'nmug lugwatasultinew ugjit gnugwaqan ta'n teplumg'pnig.’ Elugwalapnn uggwisl Isaqal ugumuljinewei na'gweg gisi ugs'tqamuiliteg. Isaq elugwalapnn uggwisl Je'gopal aq Je'gop elugwalapni newgtisgegsiliji je ta'pu uggwisg. Na 'Nnu'g ta'nig gujjinaqi'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Gujjinaqi'g wisgua'la'tipnn ugjignamual So'sepal aq netuisgela'tipnn tl gistejuilin Ijiptg. Gatu Gjinisgam ne'gaw wijitgweiwapnn, ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","aq saputa'lapnn 'nsano'qonigtug. Gjinisgam ne'gaw angweiwapnn we'gaw ta'n wen getu tala'laj. Ta'n tujiw So'sep neia'siteg Paloal, na elege'wilitl Ijiptg. Gjinisgam gisa'lapnn So'sepal nestuewistunin. We'gaw Paloal nemi'gun ta'n teli ns'tuowoqwej aq me'gitelmatl. Paloal ignmatl So'sep iganpuguin ta'n telgi'g Ijipt aq maw wiguow. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Etna na tujiw iga'q pestmo'qon ta'n telgi'g Ijipt aq Genan ta'n So'sep ujjl wigilitl. Pugwelgig mimajuinu'g welmajo'ltijig. Gujjinaqi'g mo we'jitu'ti'gw tami mijipjewei. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Toqo ta'n tujiw Je'gop nutmateg gulumg eig Ijiptg gujjinaqi'g amgwesewei poqjigimaji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na ta'puewei peita'jig So'sep gegnualsit ta'n wenij newisgegsiliji ugsisg maw ugjignaml. Na tujiw Palo nenuaji So'sepal wigumaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Na tujiw So'sep elgitmuaj glusuaqan ujjl Je'gopal telimatl, ‘Tata't, gi'l aq 'ms't ta'n te'sijig gigmaq jugwita'gw Ijipt.’ Etna na lluigneg te'sisgegsiliji je na'n. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Na tujiw Je'gop aq wi'gmaq el'ta'jig Ijipteg. Eigig na'te'l aq na'te'l etli npu'titgi'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","'Npuinu'g ajolujig Segem, na'te'l etl utquta'lujig na maqamigew ta'n Aplamo'q pegwatelmuap E'mmol uggwisg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ta'n tujiw tetaputesg gigjiw iga'q ta'n Gjinisgam genn'g'p ta'n teli tplumapnn Aplamal, na tujiw ta'n te'sijig mimajuinu'g gujjinaqi'g aq gugumijinaqi'g Ijipteg me' aji pugweliejig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na ugtejgewei, piluei elege'wit ta'n mu nenuagul So'sepal, poqji iganpuguit Ijiptg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Elue'wa'laji ginu gujjinaqi'g aq ewle'waji gujjinaqi'g aq gugumijinaqi'g. Gi'gaja'laji 'nqalanew gopisunn gujmug glaman 'npu'titaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Assma na tujiw Mowis ugs'tqamuit. Maw gelu'sit mijua'ji'j. Nesisiliji tepgunsejig teli pgiji iga'la'titl wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ta'n tujiw tewa'luteg wiguaq na Palo ugtusl wesua'lapnn aq gisigwenatl pa wijei aq negm uggwisij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Egnutmut 'ms't gelu'lg angita'suaqan aq 'ns'tuo'qon Ijiptewei. Mesgi'g gina'masuti geggung. Melgignaqal ugglusuaqanml aq ta'n tela'tegej. Gepmitelmut'p mimajuinuigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ta'n tujiw Mowis ne'wisgegipuna'teg, gisita'sit mittugwalan wigumaq Isle'laq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Negm nemiatl Ijiptewa'jl ewle'watl newgte'jilitl Isle'lal. Mowis apoqonmuatl wi'gmal aq asita'latl Ijiptewa'jl, ne'pa'tl. ( ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tel'ta'sit negm, 'ugtmimajuinumg 'ns'tmu'titaq na Gjinisgam getu e'wapnn ta'n tli assumsultitaq gatu negmow mo nestmi'ti'gw.) ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Na wapg, nemiaji tapusiliji Isle'laq etli ntinijig. Wejo'tg negm wantaqa'lan. Telimaji, ‘Jigs'tuig ji'nmutut, gilew gitg Isle'lewioq, goqwei gilew weji ntioq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pas'g newgte'jit ta'n etl matnapnn igtigl gesemegetl Mowisal sitatug. Pipanimatl, ‘Wen gi'l ignmasg ml'gigno'ti ilgweninen aq ilsuminen? ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Getu' ne'pe'in ap ni'n 'st'ge' ta'n tel ne'pe't'pnaq Ijiptewa'jaq ulagu?’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ta'n tujiw Mowis nutgeg, ejigl smuqwat aq poqt'gatg maqamigew teluisig Mitian. Na na'te'l etl malie'wip aq tapusilipni uggwisg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ne'wisgegipunqeg gis pmtesgeg ansale'wilitl neia'silitl Mowis etlamglegl nipispaqan paqtaqamigtug, gigjiw gm'tn Sainai. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mowis paqalaiaj ta'n goqwei nemitoq gigja'sit ula nipispaqan aq gigjaptegl. Awna nutuatl Nisgaml etl ewistunitl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Gjinisgam telimatl, ‘Ni'n na Gjinisgam ta'n gujjuaqi'g emtoqwala'tipnn, na Gjinisgam ta'n Aplamo'q, Isaqo'q, aq Je'gopo'q emtoqwala'tipnn.’ Mowis neng'tesing jipaqa'sit aq mo tetujitagw lapa'sin. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Gjinisgam telimtl, ‘Mna'l gmugsng, muta na'te'l ta'n gaqamin gepme'g maqamigew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ni'n nemi'gig ta'n teli ulmajo'lti'tij 'ntmimajuinumg Ijipteg aq ni'n nutaqig metew petoqsultijig aq nige' wa'so'q wet nisa'si ugjit apoqonmuan. Nige' ni'n elgimul Ijiptg.’ Gjinisgam na ula telimapnn Mowisal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Etna na ula Mowiso'q mo puatasigup ugtmimajuinumg Isle'laq. Pipanima'tipnn, ‘Wen gi'l ignmasg's ilgweninen aq ilsuminen?’ Na negm newgte'jit ta'n Gjinisgam petgimapnn iganpuguilin aq ugs'tawi'welin. Na ansale'wilitl Mowis nemiapnn nipispaqan etlamglegl apoqonmat'pnn na gis tla'tegen. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Negm na Mowis tewa'lapni Ijiptg. Milamu'gl paqalaiuti'l tela'tegepnn Ijiptg na megwe'g 'gta'n aq ne'wisgegipunqeg eig'pnig paqtaqamigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Etna na negm Mowis ta'n telimapni mimajuinu'g Isle'laq, ‘Gjinisgam petgitmugsitoqs'p iganigjitegewinu pa wijei aq ni'n ta'n tel petgimip.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Na negm newgte'jit ta'n wijitgweiwapni mimajuinu'g Isle'laq, mawo'ltipnig paqtaqamigtug. Na tujiw gm'tnigtug teluisit Sainai, ansale'wilitl gelult'pn, aq ignmut'pnn Gjinisgam iapjiwewe'l ugtagnutmaqanml ugjit ignmugsinen. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pas'g na ninen gujjinaqi'g mo getu jigs'tmu'tigupnig awna mo menuege'tigupnn, aq gmetug eligsmala'tipnn je me' siawqatmugusn Ijiptg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Toqo telima'titl A'lanal, ‘'Ltuin 'nnuoqta'w ta'n igana'latesnen, muta mo geitueg ta'n tela'tegetaq negla Mowiso'q ta'n tewa'lugsieg'p Ijiptg.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Etna na tujiw elia'titl 'nnuoqta'wl teligilitl 'st'ge' wen'jitia'muj ugjit gepmitelmanew. Ne'pa'tiji wi'sisg aq nu'gwo'la'tiji ugjit na 'nnuoqta'w. Pestie'ultijig aq emtoqwalanew ta'n goqwei negmow gisitu'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pas'g na Gjinisgam ejiglapasualapni aq emtoqwala'tiji gloqowejg musigisg'tug st'ge' ta'n iganigjitegewinu tel wi'gmi'tip wi'gatignigtug, ‘Isle'leultioq! Mo ugjit ni'n gilew ne'po'qopnig aq nu'gwo'loqopnig wi'sisg ne'wisgegipunqeg paqtaqamigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Alapinmoqop aq nespnmoqop wiguom Moloq ta'n emtoqwaloqopnig 'st'ge' Gjinisgam aq gloqowej 'nnuoqta'w gnisgamum teluisit Lipan. Gilew elioqopnig wegla 'nnuoqta'wg ugjit emtoqwalanew. Glaman nige' elgimuloq gneg sitatug Papilan.’ Etna na ula iganigjitegewinugi'g ewi'gmi'tipnig.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stipen (E'gian) siaw tlimaji, “Gujjinaqi'g gegguna'tipnn na wi'g ta'n emtoqwala'tipnn Nisgaml paqtaqamigtug na wiguom na Gjinisgam uggnugwaqanm ugjit wijitgweiagunew. Telia'tipnn ta'n Gjinisgam musga'tuapnn Mowisal tli'an 'st'ge' ta'n tel gnu'tmuapnn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Gaqaisipunqeg gujjinaqi'g ta'n gisia'tipnn na wiguom Nisgamewei ignmua'tipnn un'januaq. Negmow nespna'tipnn ta'n tujiw wije'wa'titeg Ja'suaal. Wesua'tu'tip na maqamigew ta'n tujiw Gjinisgam getaqqatesguateg ala igtigig mimajuinu'g. Gis sa'q siawpultipnig na'te'l glapis tetaputesg ta'n tujiw Ta'pit pegisingeg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Negm tetapua'lapnn Nisgaml aq pipanimapnn ignmugsin 'ltuan wi'g ugjit Gjinisgam ta'n Je'gop gis emtoqwalapnn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Gatu awna na uggwisl teluisilitl Salaman el'tuap na 'gjia'sutuo'guom ugjit Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Pas'g na Gjinisgam ta'n mawi espe'g mo wigigw 'gjia'sutuo'guom gisna ta'n pas'g goqwei ji'nm gisitoq 'st'ge' ta'n iganigjitegewinu teluep, ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Gjinisgam teluet: Wa'so'q ni'n 'ntupun aq ugs'tqamu ta'n weji ilsutegei. Talamugt'tew nige' wen'ji'guom el'tuioq ugjit ni'n? Tami 'ntupun ugjit ni'n ta'n tli atlasmites? ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Muta ni'n 'ms't wegla ta'n te's'gl gisituapnn.’ Etna na ula Gjinisgam teluep.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stipen siaw tlimaji, “Melgasultioq gilew! Pa na wijei aq ta'nig Nisgaml mo puala'tigul aq mo jigs'tmuoq ugglusuaqanml. Gilew pa na wijei aq gujjuaqi'g, me' ne'gaw mo jigs'tuawoq Wejuli Nisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Je mu newgte'jit iganigjitegewinugi'g gujjinaqi'g mo gitnme'wawoqopnig aq welmaje'wawoqopni'g. Ne'pa'tipni Gjinisgam ugtagnutmewinu'g ta'n sa'q wesgutmi'tip ta'n tl jugu'elitl negla getlamielitl uglugowinuml. Aq nige' gilew iga'loqop ugjit ne'po'qsin. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Gilew na mimajuinu'g ta'n mesnmoqopnn Gjinisgam ugt'tplutaqanml. Ansale'wijig wijitgweiwa'tipnn Nisgaml ta'n nisa'tugsioqop pas'g gilew ne'gaw mo jigs'tmu'tiwoqop.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ta'nig iganpugultijig jigs'tua'titeg Stipenal, me' gatu asgaiagwi'titl ta'n goqwei teluelij. Na smtug we'gwi uggwaiugtua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Gatu Stipen ilgwentl Wejuli Nisgaml elapa'sit wa'so'q aq nemituaj Gjinisgam aq uggepmite'lgaqanm paqtata's'g aq Se'susal gaqamilitl ugtinaqanmg Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Teluet, “Angaptmug, nemitu wa'so'q pana's'g aq Se'sus ta'n Gjinisgam petgimapnn gaqamilitl ugtinaqanmg.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Sesgu'tijig aq gepsoqwa'tu'titl ugs'tuaqanual. Smtug el'tugultijig negmeg, ge's piam na newgte' tel'ta'sultipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Wesua'la'titl aq tewege'titl 'gjigan aq gun'tewta'titl. Ta'nig pisui egsua'tipnig naqtmua'tiji uggotmuaq ango'tmn maljewe'litl ji'nmul teluisilitl Sol. ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Negmow siaw gun'tewta'titl Stipenal. Negm elgomigtuatl Gjisaqamawul, “Gjisaqamaw Se'sus, ugsua'tui 'njijaqamij.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nutgul'pa'sit aq sesgwet, “Se'sus mut migwite'-tmuaw ula ugtlue'utiwal.” Na gis tlueteg, nepgaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Sol wel'te'tg's ta'n tel ne'po'j Stipenal. Na ji'nmug ta'n Nisgaml emtoqwala'titl nutqutala'titl Stipenal mewima'titl aq atgitemugtua'titl. Na wijei na'gweg ta'n getlams'tmu'tijig Se'suseg Selusalemg eigig poqji ma'muniw ulmajeiujig aq gitnme'ujig. 'Ms't ta'n te'sijig getlams'tmu'tijig Se'suseg se'sita'jig ta'n telgi'g Jutia aq Samalia, pas'g mo apostale'wijig tami el'ta'gwig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Na Sol, ta'n tel we'gwi gisi pgwatoq, wejo'tg ugtmenan ta'ni getlams'tua'titl Se'susal. Elietl te's wen'ji'guoml aq getaqqatejimaji ji'nmug aq maw e'pijig, ta'nig getlams'tasultijig aq pijo'laji laplusang. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ta'nig getlams'tasultijig se'sita'jig aq peggwita'jig, pestunmi'tij gelu'lg agnutmaqan ta'n tel milita'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip eliet 'gjigan teluisig Samalia aq na'te'l telimaji mimajuinu'g ugjit Nujiugs'tawi'welitl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na pugwelgig mimajuinu'g melgi jigs'tua'titl ta'n Pilipal teluelij. 'Ms't nutua'titeg aq nemia'titeg ta'n tel mili npitegelij aq ta'n tela'tegelij paqalaiuti'l wejiaq Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mn'tu'g gesigawwita'jig ta'n tujiw getaqqita'titeg mimajuinuigtug. Pugwelgig gesnugu'tijig aq ta'nig mo gis maita'gwig aq alt ta'n waqqaj al'ta'jig negla gaqi npisultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Na tujiw mimajuinu'g ta'n tleiaultijig Samalia wel'ta'sultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na 'gjigan wigit ula ji'nm teluisit Simon. Gis wel sa'q sigta paqalaiwaji Samaliaewaq ta'n tel mila'tegej puowinuti e'w'g. Telimapni mimajuinu'g, “Ni'n espei, mesgi'g ml'gigno'ti geggunm.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","'Ms't ta'n te'sijig na 'gjigang weja'tegemg mawi espe'g glapis ta'n mawi ewle'jit gigji jigs'tua'titl. Teluejig nisgamitelma'titl Simonal. Ml'gigno'ti gugunmilin. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Gis wel sa'q sigta paqalaiwaji mimajuinu'g ta'n tel mila'tegej puowinuti e'w'g glaman negmow jigs'tua'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Gatu ta'n tujiw getlams'tmu'ti'titeg gelu'lg agnutmaqan ta'n Pilipal teluelij ugjit Gjinisgam ilgwenaji ugmimajuinumg aq Se'suguli negm na Nujiugs'tawi'wet, na tujiw mimajuinu'g sign'tujig, ji'nmug aq maw e'pijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Glapis Simon getlams'tasit, aq ta'n tujiw gis sign'tuteg gigje'watl Pilipal. Ta'n nemitoql telgi'gl tela'tegelitl aq ta'n tel mili npitegelij, me' gatu paqalaiatl. Na. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na tujiw apostale'wijig Selusalemg nutma'titeg Samaliaewaq getlams'tasultijig Gjinisgam ugglusuaqanm, na elgima'tiji Pie'lal aq Sa'nal na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ta'n tujiw iga'titeg a'sutmessewa'tiji ta'nig getlams'tasultijig glaman Wejuli Nisgaml 'msnataq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Wejuli Nisgam me' menaq nisa'sigweg Samaliaewaq pas'g alt ta'nig gis getlams'tasultijig sign'tutupnig e'w'g Gjisaqamaw Se'sus ugwisunm. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pie'l aq Sa'n ge'gwa'tua'tij ugpitnual un'jig te's newgte'jilitl. Na tujiw 'ms't ta'n te'sijig mesna'titl Wejuli Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon nemiatl Wejuli Nisgaml ignmut'pnig ta'n tujiw apostale'wijig ge'gwa'tua'tij ugpitnual un'jiwaq. Na tujiw Pie'lal aq Sa'nal getu apangituaji ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","aq telimaji, “Ignmui ni'n ml'gigno'ti glaman ta'n tujiw 'npitnn gegupa'taq wen un'jig 'msnatal Wejuli Nisgaml.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Smtug Pie'l asitematl, “Gi'l aq 'gsulieweim mn'tua'gig la'titoqs'p, tl'ta'sin gi'l gisi pgwateltes Gjinisgam ugtignmatimgewe'm e'wmn suliewei. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mo gi'l telgita'siwn maw lugutinenu muta Gjinisgam nemi'sg winjig ggamlamun. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Gawasgita'si aq jigla'si ta'n winjig gisite'tmn aq lia etawaqtmu Gjisaqamaw apigsigtulin ula ta'n teli angite'tmn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Geju'l gi'l tetuji wisguen aq elue'uti assum'sg. Mu gis jigla'siwn pa wijei aq laplusang pisin.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon telimaji Pie'lal aq Sa'nal, “Tetuji ulm'tuoq ge' a'sutemessewi glaman ta'n goqwe'l gis tlueioqop ma tlianugl ni'neg.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na Pie'l aq Sa'n gegnua'tua'tiji mimajuinu'g ta'n teli ul nenua'tipnn Se'susal aq pestunmuaji gelu'lg agnutmaqan Nisgamewei. Na tujiw apaja'tijig Selusalemg. Ta'n tujiw pemi apsgwa'ti'titeg, nespi pestungig gelu'lg agnutmaqan pugwelgl gutanji'tl Samaliaewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Na Gjinisgam ugtansale'witeml gelulatl Pilipal, “Ilaji aq lia 'tp'te'snug na awgti wejiaq Selusalem glapis Ge'sa.” (Ula awgti mo nugu e'wa's'gtnug.) ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Na smtug Pilip wenaqa'sit aq eliet. Na newgte'jit iganpugutuaji Itiopianewaq pemi nmiet. Na ula ji'nm mawi espe'g iganpuguit. Nujo'tg Gantesi ugsulieweim aq ugmilesuaqanm. Gantesi na Itiopian elege'wi'sgw. Na ula ji'nm assma wejiet Selusalem api emtoqwalatl Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Aq nige' pemi apaja'sit utepaqanigtug. Ge's pematejimgwej, pem gitg Gjinisgam ugtwi'gatign ta'n iganigjitegewinuaq Aiseiao'q gis wi'gig'p. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Na Pilip, Wejuli Nisgaml telimtl, “Siaw pmia gmetug utepaqan, gigjiw lia aq gigja'si.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilip el'tugwi'g smtug aq nutuatl etl gitmlij ugtwi'gatign ta'n iganigjitegewinuaq Aiseiao'q gis wi'gig'p. Na tujiw pipanimatl, “Nestasin ta'n goqwe'l etl gitmn?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na iganpuguit asita'puguet, “Tal gisi ns'tasites? Amujpa na nat wen gegnu'tmuit. Smtug tepa'si aq pa'si nutepaqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na ta'n pem gitg'p Gjinisgam gelu'lg ugtwi'gatign etna na ula, “Ula ji'nm eliamsit pa na wijei aq jijgluewj ta'n tujiw wesua'luj getu ne'po'j. Ula ji'nm mo goqwei teluegw je mu newgte' glusuaqan pa na wijei aq jijgluewji'j pa mo me'tegw ta'n tujiw pesgwesuj. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ma'muni 'ntaqo'qona'lus aq mo getlami ilsumamug's. Mo wen gis taluegw ugjit un'jang muta nepg'pnaq aq mo geggunagupni'gw.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Na iganpuguit pipanimatl Pilipal, “Tlimi, tegen ta wegla iganigjitegewinu wesgumatl, Aiseiao'q gisna nat wen pilue'l?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Na Pilip poqji gnu'tmuatl na wijei ta'n pem gitmlipnn aq me' igtigl musga'tuatl Gjinisgam ugtwi'gatigng. Telimatl gelu'lg agnutmaqan ugjit Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ge's pem nisatejimgwe'tij na awgti na iga'jig ta'n eteg samqwan. Na iganpuguit teluet, “Ula eteg samqwan. Goqwei nige' naqa'litew mo gis sign'tasin?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilip telimatl, “Gis sign'tasites 'gtlams'tmn ta'n telgi'g 'ggamlamun.” Iganpuguit asita'puguet, “Ni'n melgi gtlams'tm Se'suguli na Gjinisgam uggwisl.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Iganpuguit melgimatl ugtlugowinuml, “Naqa'si tet!” Na gitg Pilip aq iganpuguit gepta'tijig aq nisa'tijig samqwanigtug. Na tujiw Pilip sign'tuatl iganpuguilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ta'n tujiw apaji gtalqa'siteg samqwanigtug, na tujiw Wejuli Nisgam gneg ejigla'latl Pilipal. Na iganpuguit mo nemiagwaq nugu, gatu negm siawa'sit aq no'q welgwitg uggamlamun. ");
INSERT INTO micMIQNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jensi Pilip eig na gutan teluisig Asotus aq gaqpeggwa'sit gutanji'tl. Pestunmuaji mimajuinu'g gelu'lg agnutmaqan glapis iga'teg Sesaliaeg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Me' negm Sol siaw tl lugwet ta'n tel gitnme'waji aq ewlumuaji ne'pa'new ta'nig getlams'tasultijig Gjisaqamaw Se'suseg. Espe'litl patlia'sl elietl aq ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","glutmuaj wi'gatign ta'n wenij negm aq ta'n tel lugwej ugjit iganpugultijig Lesui'pewei a'sutuo'guomg 'gjigan Tamasgus. Wet tla'tegep glaman ta'n tujiw na'te'l iga'j, we'jiaj weni ta'n majulgwatmli'tij ta'n Se'sus tel pmiep, na tujiw gisi ugsua'lataq aq apajo'lataq Selusalemg, ji'nmug aq maw e'pijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ta'n tujiw gigjiw iga'teg 'gjigan Tamasgus jiniw paqtasa's'g ta'n negm eig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ugtue'ml weji peteja'litl. Nutuatl nat wenn telimtl, “Sol! Sol! Goqwei tel gitnme'win ni'n?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol pipanimatl, “Wenin ta gi'l, Gjisaqamaw?” Na telimtl, “Ni'n na Se'sus ta'n gi'l getuant. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Gatu unaqa'si aq lia na 'gjigang. Na na'te'l tlimulten ta'n tla'tegetes.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Gatu na ji'nmug ta'n wije'wa'titl Solal naqa'tipnig aq mu telueti'gw goqwei. Nutua'titl ta'n wen metewistunitl pas'g mo nemia'tigul wenn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Na Sol wenaqa'sit maqamigeg aq pana'toqol ugpugugul pas'g mo goqwei nemitug. El glisgna'titl Tamasgusg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nesuguna'gweg pa mo goqwei nemitugus aq ne'gaw mo mijigus, aq mo esamqwawgus pa goqwei. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Eig's na'te'l Tamasgus ji'nm teluisit Ananaias negm Se'sus unaqapeml. Nisgaml gelult'pnn ta'n teli milaplgigwa't, “Ananaias.” Teli asitematl, “Ula eim, Gjisaqamaw.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Gjisaqamaw telimatl, “Ilaji aq lia na awgti teluisig Tegpaqteg. Lia Suta wiguaq aq pipanigesi ula ji'nm teluisit Sol. Etli a'sutmat. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Negm telaplgigwa'p. Tet nemiapnn ji'nmul teluisilitl Ananaias pisgwa'litl aq ugpitnn gegupa'tuatl un'jig glaman ap nmitegelita.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaias teli asitematl, “Gjisaqamaw, pugwelgig mimajuinu'g gis tlimijig ugjit na ji'nm, ta'n tel ma'muna'tegej aq ta'n gis tla'tegej ta'n teli gtanaj gtmimajuinumg Selusalemg, ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","aq nige' pegising'p tet Tamasgusg. Wi'gatign weja'toq iganpugultiliji patlia'sg ugsua'lan ta'n te'sit wen emtoqwal'sg.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Gjisaqamaw telimtl, “Lia, muta ni'n gisi mgng lugowin ni'n. Usgumitew ta'nig mo Lesui'peulti'gw aq elege'wiliji aq maw mimajuinu'g Isle'lewaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aq ni'n musga'tua's 'ms't goqwei ta'n tli ulmaje'tew ugjit ni'n!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Na tujiw Ananaias eliet. Pisgwa't na wen'ji'guomg ta'n Sol wesgowa'sit aq gegupa'toqol ugpitn un'jig, teluet, “'Njignam Sol, Gjinisgam petgimit. Negm Se'sus ta'n gi'l nemi't'p na awgtigtug ta'n tujiw wejgu'eneg ula tet. Petgimit ni'n glaman ap nmitegetes aq Wejuli Nisgaml ilgwenultew.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Na smtug ta'n goqwei elaqteg Sol ugpugugw, weji nisiaqal aq jiniw apat nemiteget. Gaqama'sit aq smtug sign'tut'p. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ugml'gigno'tim apaja's'g, ta'n tujiw g'satalgeg. Sol siawqatg pe' tasuguna'q Tamasgusg maw ta'nig getlams'tasultijig Se'suseg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Na smtug poqji al pestung't ta'n te's'gl a'sutuo'guoml ugjit Se'susal. Teluet, “Se'sus na Gjinisgam uggwisl.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","'Ms't ta'n te'sijig nutua'titeg paqalaiultijig aq pipanigesultijig, “Mu na ula ji'nm ta'n Selusalemg eig'p, ne'pa'pni ta'nig emtoqwala'titl Se'susal? Weji pgising ula tet glaman gisi ugsua'lataq ta'nig getlams'tasultijig Se'susal aq apaja'lan iganpugultijig patlia'sg?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Me' Sol naji ml'gignewa'tigl ugglusuaqanml ta'n tel pestunmuaji aq musga'tuaji Se'sus, na ji'nm ta'n Gjinisgam petgimapnn, negm na Nujiugs'tawi'wet. Tel ml'gignewa'tigl ugglusuaqanml na Lesui'paq ta'n wigultijig Tamasgusg mo gis asitema'tigul. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Gaqaisugunaq gis pemiaq, na Lesui'paq mawita'jig aq il agnutma'tijig ne'pa'new Solal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pas'g na negm gegnua'tut ta'n getu tla'luj. Gun'teweiei gigto'qosegenas'g ula 'gjigan. Tepgig aq na'gweg esgmala'titl 'gjiganei ga'qana'tas'g glaman gis ne'pa'taq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Newgtejgeg wela'gweg Sol ta'n majulgwalji, wesua'laji aq nispila'titl ligpenignigtug. Wet saputa'la'titl tuoputigtug gun'teweiei ula gigtoqosegenas'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Na nige' Sol apaja'sit Selusalemg aq wejo'tg wijitgweiwan Se'sus unaqapemg. Pas'g na mo negmow getlams'tua'tigul ugjit Solal 'gtlams'tasilin aq jipaqitelma'titl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Na tujiw Pnnal pegising aq apoqonmuatl. Ela'latl ta'n apostale'wiliji eimu'tilij. Negm gegnua'tuaji ta'n Sol awgtigtug tel nemiapnn Gjisaqamawul Se'susal, aq na Gjisaqamaw gelulasnn Solal. Siaw tlimaji ta'n tel melgita't Sol ta'n tujiw pestungeg ugjit Se'susal Tamasgusg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Na tujiw Sol siaw wijitgweiwaji aq peggwa'sit ta'n telgi'g Selusalemg. Wijei tel melgita't ta'n tel pestunmuaji ugjit Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","We'gaw sespagnutma'tijig glapis gi'gaita'jig ta'nig Gli'gewi'sultijig Lesui'paq. Pas'g na negmow wejo'tmi'tij ne'pa'new. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ta'n tujiw igtigig ta'nig getlams'tasultijig geitu'tij wije'wa'titl Solal na 'gjigan Sesalia aq ejiglgima'titl na 'gjigan Talsus. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na tujiw ta'nig getlams'tua'titl Se'susal wantaqo'ti mesnmi'tij ta'n telgi'g Jutia, Galali, aq Samalia. Mu nugu jipasulti'gw. Elugutijig Nisgamewigtug aq Wejuli Nisgam apoqonmuateg. Na tujiw poqji pugweliejig aq ta'n tela'taqati'tij musga'tua'tij ta'n tel gepmitelma'tij Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Etna na tujiw Pie'l ala'sit 'ms't tami aq newgt eliet naji mittugwalaji Gjinisgam ugtmimajuinumg wigultijig na gutan Laita. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Na'te'l weltesguatl ji'nmul teluisilitl Anias. Mo gis maja'sigw. Un'poqonising ugumuljin te'sipunqeg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pie'l telimatl, “Anias, Se'suguli gisa'l'sg ila'sin. Unaqa'si aq lugwaten gn'po'qon.” Smtug Anias wenaqa'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","'Ms't ta'n te'sijig mimajuinu'g wigultiliji gutanji'tl Laita aq Salon nemia'titl. Smtug gawasgita'jig, ejiglita'jig elue'utigtug, aq getlams'tua'titl Gjisaqamawul Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na eig's Joppa e'pit teluisit Ta'pita, ta'n getlams'tasit. (Ugwisunm Gli'gewigtug na Tolgas na tel glusuaqanig “Lentug.”) Ne'gaw ta'n teli pgitawsij welm'toq aq apoqonmuaji ewle'juinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Gatu na tujiw gesnugwat aq siawi np'gaq. Na mimajuinu'g gesispa'la'titl npuinu'l aq elsma'la'titl ge'gwe'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Joppa mo piami amasenug weja'tegemg Laita. Na unaqapemg eimu'tiliji Joppa nutma'tipnn Pie'lal i'mlin Litia, na poqjigimaji tapusiliji ji'nmug Pie'leg. Etawaqtmua'titl, “Tetaqa'si aq wije'win ninen, muta na e'pit teluisit Lentug nepg'pnaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Na Pie'l ilajit aq wije'wapni. Ta'n tujiw iga'teg ela'lut ge'gwe'g. 'Ms't ta'n te'sijig sigu'sgwaq gigto'qopugutua'titl nespetemultijig. Musga'tua'titl atla'ig, ugpita'qewe'mual aq uggotmuaq ta'n Lentug gisiapni ge's mimajiteg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pie'l 'ms't tewaggimaji. Nutgul'pa'sit aq a'sutmat. Na toqo tujiw gawasga'sit ta'n 'npuinu'l elisinnij aq teluet, “Ta'pita, unaqa'si.” Smtug pana'toqol ugpugugul aq ta'n tujiw nemiateg Pie'lal pemgopa'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pie'l elisga'sit aq apoqonmuatl ta'n teli unaqa'silij. Na tujiw wigumaji sigu'sgwaq aq igtigig ta'nig getlams'tasultijig. Neia'tuaji e'pilitl mimajilitl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na se'sa's'g agnutmaqan ta'n telgi'g Joppaeg aq pugwelgig mimajuinu'g getlams'tua'titl Gjisaqamawul. ");
INSERT INTO micMIQNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Gaqaisugunaq Pie'l siawqatg Joppa, Simonal wiguaq ta'n nujo'tmlij m'gegn wi'sisueie'l. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Eig'snaq Sesalia na ji'nm teluisit Gonilius iganpugutuaji gasgiptnnaqanijig Lo'mewaq sma'gnisg. Negmow tleiaultijig ta'nig telui'tujig “Italiewaq sma'gnisg.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ula ji'nm gepmitelmatl aq emtoqwalatl Nisgaml aq maw wi'gma. Pugwelg'snn ta'n goqwe'l gis tla'tegetl ta'n teli apoqonmuasni Lesui'pewei ewle'jultiliji aq te'sigisg'g eli a'sutmuatl Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na'tami si'st ajieteg newgtejgeg gis mewlia'gweg, telapulgigwa't. Teli ul nmiatl Gjinisgam ugtansale'witeml wejgu'elitl aq telimtl, “Gonilius!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Gonilius aptaplgigwetuatl ansale'wilitl. Nespi jipasit aq teluet, “Goqwei puatmn saqamaw?” Ansale'wit teli asitematl, “Gjinisgam gis nutmasgal 'gta'sutmaqanml aq gis nemi'sg ta'n teli ula'luj ugtmimajuinumg aq nige' migwitelm'sg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nige' elgimgig ta'sijig ji'nmug Joppa ugjit wigumanew newgte'jilitl ji'nmul teluisilitl Simon Pie'l. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Siawqatg Simonal wiguaq wijei teluisilitl 'st'ge' negm, nujo'tmlitl wi'sisueie'l m'gegn. Gigjiw wigilitl 'gta'nug.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na ansale'wit ta'n etlewistu'tipnn ejigla'sit. Gonilius wigumaji tapusiliji uglugowinumg aq newgte'jilitl ugsma'gnisml. Na sma'gnis wel lugowatl aq emtoqwalatl Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Telimaji ta'n gis tliaq aq smtug elgimaji Joppa. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na igtig na'gweg na'tami mewlia'gweg ula ji'nmug gigjiw iga'jig Joppa. Gatu nige' na ula Pie'l so'qwiet wen'ji'guom naji a'sutmat. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Na tujiw poqji guising aq getu mijjit. Ge's mijipjewei etl gisgaja'tas'g na negm tetaplgigwa't. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nemitoq wa'so'q pana's'g aq nat goqwei wejgu nisa's'g. Teliangamgug 'st'ge' mesgilg naqsun aq me' pem nisa's'g ta'n negm eig. Naqsun uljaqat tetpaqanisa's'g newgul gejigiaqal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Gaqaisg milamugsijig wi'sisg, 'mtesgmug, taqtaloq 'sqoljig aq jipji'jg pisultisnig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Gjinisgam nutuatl telimtl, “Unaqa'si, Pie'l. Ne'pa' aq malqom!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pas'g na Pie'l teluet, “Moqwa', Gjisaqamaw. Mo ni'n malqotmu na! Menaq ni'n goqwei malqotmu ta'n mo gelu'lgtnug malqota's'gtn ta'n telteg Lesui'pewei 'tplutaqan.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Gjinisgam siawewistoq, “Mut getgite'tmu ta'n goqwei ni'n Gjinisgam gis waqama'tu.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Si'st Nisgaml telimtl, na tujiw apaja's'geg wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Na Pie'l newgti angite'tg ta'n goqwei gis nemitoq, amuimegteg. Mo nestasigw Pie'l ta'n goqwei Gjinisgam getu tlimaj. Na tujiw na ji'nmug, petgimapni Gonilius, we'jia'titl ta'n Simon wigit aq nige' gaqamijig igantug ga'qana'tas'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Gesigawwejig aq pipanigesijig, “Eig's ji'nm teluisit Simon Pie'l?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pie'l me' wejo'tg 'ns'tasin ta'n goqwei gis nemitoq ta'n tujiw Wejuli Nisgaml telimtl, “Ge' jigs'te'n, nesisijig ji'nmug al gwilasgig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Glaman ilaji aq nisa'si. Mut 'mtuite'tmu wije'wan muta ni'n petgimgig.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Na toqo tujiw Pie'l nisa'sit aq telimaji ji'nmug, “Ni'n na ji'nm al gwiluoq, goqwei puatmn?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Teli asitema'titl, “Iganpuguit Gonilius petgimugsieg. Negm na welm'toq ji'nm ta'n emtoqwalatl Nisgaml aq gepmitelmut ta'n te'sijig Lesui'paq. Gjinisgam ugtansale'witeml telimt'pnn ugjit wigumulin wiguaq glaman gis nutu'ltew ta'n teluen.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pie'l pisgwegimaji ji'nmug aq getgunijig na'te'l wela'gw. Na igtig na'gweg menja'sit aq ilajit aq wije'waji. Ta'sijig ji'nmug ta'nig getlams'tasultijig na 'gjigan Joppa tle'g wije'wa'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aq igtig na'gweg iga'jig Sesalia, na'te'l Gonilius etli esgmalaji maw wo'gumaq, aq witapaq ta'nig wigumapni. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Assma Pie'l getu pisgwa't ta'n tujiw Gonilius a'suguatl aq el nutgul'pa'sua'latl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pas'g na Pie'l wenaqa'latl aq telimatl, “Gama'si, muta ni'n pas'g ji'nm!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pie'l siaw agnutmuatl Goniliusal aq siaw pisgwa'tijig wen'ji'guomg. Na'te'l pugwelgig mimajuinu'g eig'snig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pie'l telimaji, “Gilew weli gji'tuoq ta'n tel wi'gas'g Lesui'peweiei 'tplutaqan. Mo teltenug Lesui'p wijitgweiwan ta'nig mo Lesui'peulti'gw. Gatu ni'n Gjinisgam musga'tuit, ta'n telaplgigwa'iap, mo teltenug ta'n pas'g mimajuinu penoqitelman. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Glaman na ta'n tujiw natgimineg angam jugu'a aq mo amsalewistuap. Nige' pipanimul goqwei wej natgimi's'p?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Gonilius telimatl, “Assma na tele'g'p wijei 'st'ge' nige' gisi nsuguna'qeg. Etli a'sutmap nignaq assma sist ajiep gis mewlia'gweg. Na ji'nm jiniw neia'sit. Gesi wape'gl aq paqtategl utapsun. Gaqamit igantug ni'neg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Aq teluet, ‘Gonilius! Gjinisgam nutmasgl 'gta'sutmaqanml aq nemi'sg ta'n teli ula'l'j mimajuinu'g aq nige' migwitelm'sg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","'Lgim nat wen Joppa ugjit wigumanew newgte'jilitl ji'nmul teluisilitl Simon Pie'l. Eig Simonal wiguaq. Wijei teluisilitl 'st'ge' negm ta'n nujo'tmlitl wi'sisueie'l m'gegn. Gigjiw wigilitl 'gta'nug.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Na smtug natgimulap aq gi'l tetuji ulm'tun jugu'en. Nige' 'ms't eimu'g aq Gjinisgam wijitgweiugsi'gw aq nige' getu nutuleg ta'n Gjinisgam gis tlim'sg tluen.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Na tujiw Pie'l agnutmuaji, “Nige' ni'n geitu aq teliaq Gjinisgam 'ms't wen wijei tele'watl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ta'n wen jipalatl Nisgaml aq tela'teget ta'n goqwei tetapu'aq na tetapua'latl Nisgaml ta'n getu tet tami wettaqien gisna ta'n tleiawin. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ula na wijei agnutmaqan Gjinisgam petgitmuapni Isle'laq gegnua'tuapni na gelu'lg agnutmaqan. Etna na Se'sus gisi ignmultew wantaqo'ti. Negm na Gjisaqamaw ta'n te'siliji mimajuinu'g, pas'g negm gisi ugs'tawiaji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Geituoq na Sapatiso'q tel pestung'pnaq ugjit gawasgita'new ugtlue'utiwal aq sign'tasultinew. Etna na tujiw mesgi'g'p ta'n teliaq ta'n telgi'g Jutiaewa'gig, weji pqotamgiaqap Galaliewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Geituoq Gjinisgam gisi mgnapnn Se'susal aq wajua'lapnn Wejuli Nisgaml aq ml'gigno'ti. 'Ms't tami ala'sip aq wela'lapni mimajuinu'g aq nepilapni ta'nig mn'tu assumapni muta Gjinisgam tegwe'wapnn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","'Ms't ninen tel nemitueg'p ta'n te's'g goqwei tela'tegej Selusalemg aq esgwiaq Lesui'pewa'gig. Ne'pa'tipnaq gujjieweigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pas'g na Gjinisgam apaji minua'lapnn gisi nsuguna'q aq gisa'lapnn al neia'silipnn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mu 'ms't mimajuinu'g nemia'tigupnn pas'g tel nemi'g'tt'p ninen ta'n Gjinisgam, gisi mgnugsieg'p. Mawatalultieg'p aq maw samqwoltieg'p ta'n tujiw Gjinisgam gis minua'lateg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Melgimugsieg'p ugjit pestunmua'tinen aq gegnua'tua'tinen gelu'lg agnutmaqan mimajuinuigtug aq tliman igtigig, Se'susal na Gjinisgam gisi 'mgnapnn ugjit ilsuman mimajultijig aq nepu'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","'Ms't ta'n te'sijig iganigjitegewinugi'g wesguma'tipnn, Se'susal teluepnig, ‘Na 'ms't ta'n te'sit wen getlams'tasij negmeg, apigsigtuaten ugtlue'utiwal, wet sapu tl lugweg na ml'gigno'ti negm ugwisunmg.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Me' Pie'l etlewistoq ta'n tujiw Wejuli Nisgaml nisa'silitl aq pisgwa'litl uggamlamunuaq aq ilgwengwi'titl 'ms't ta'n te'sijig etl jigs'tmi'tip gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Na Lesui'paq ta'nig getlams'tasultijig Se'susal weita'jig Joppa peji wije'wa'tipni maw Pie'lal, paqalaiultijig ta'n Gjinisgam teli ignmuaj Wejuli Nisgaml wegla ta'nig mo Lesui'peulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nige' tel nutua'tiji piltui'sultiliji aq emtoqwalgwi'titl Nisgam teluejig, “Gjinisgam na mawi espe'g.” Pie'l gelusit, ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Wegla mimajuinu'g gisi msna'titl Wejuli Nisgaml pa na wijei aq ginu. Gatu nige' mo wen gis naqa'lagwig sign'tasultinew samqwanigtug.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Melgimaji, “Sign'tasultigw ugwisunm Se'suguli.” Na tujiw pipanimji gis wijitgweiwanew ta'suguna'q. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na apostale'wijig aq ta'n telgi'g Jutia nutma'tijig ta'nig mo Lesui'peulti'gw, elt mesnmi'tij glusuaqann Nisgamewei. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ta'n tujiw Pie'l elieteg Selusalemg ta'nig wel'telma'tiji elugwala'tiji ta'nig mo Lesui'peulti'gw, Pie'lal majiaqa'la'titl. Telima'titl, ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Gi'l eimu't'p wiguaq ta'nig wegla mo Lesui'peulti'gw aq mu elugwatasulti'gw aq we'gaw mawatalultioqopnig!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Na tujiw Pie'l gaq gnu'tmuapni ta'n te's'g goqwei teliaqap. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Telimaji, “Gjigan Joppa, ni'n etli a'sutmap aq na telaplgigwa'iap. Nemitu ta'n goqwei wejgu nisa's'g wa'so'q teliangamgug 'st'ge' mesgilg naqsun. Uljaqa pem nispilsig newgul gejigiaqal. Etl naqa's'g ni'n gmetug ta'n gaqami. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Na gigjaptm lame'g aq nemi'gig ne'wigata'tijig wi'sisg aq taqtaloq, 'mtesgmug 'sqoljig aq jipji'jg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Na tujiw nutaq nat wen telimit, ‘Unaqa'si, Pie'l. Ne'pa' aq malqom.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pas'g na ni'n teluep, ‘Moqwa', Gjisaqamaw. Menaq ni'n malqotmu ta'n goqwei mo tepawgtinug malqota's'gtn ta'n telteg Lesui'pewei 'tplutaqan.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Gjinisgam ap mjit newgt wej glusit wa'so'q, ‘Mut getgite'tmu ta'n goqwei ni'n Gjinisgam gisi waqama'tu.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Na glapis sist na teliaqap aq glapis ta'n telgi'g apaja's'geg wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Assma na tujiw nesisijig ji'nmug petgimujig Sesalia, peita'jig na wen'ji'guom ta'n ni'n eimap. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Wejuli Nisgam telimip, ‘Lia wije'w aq mut 'mtuite'tmu.’ Na wegla asugomtesijig ta'nig getlams'tasultijig wije'wipnig Sesalia aq 'ms't el'ta'ieg'p Gonilius wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Telimugsieg'p ta'n tel nmiasnn ansale'wilitl gaqamilitl wiguaq telims'pnn, ‘'Lgim nat wen Joppa aq wigumatal na ji'nmul teluisilitl Simon Pie'l. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tlimultew gi'l aq ta'n te'sijig gigmaq ta'n tli ugs'ta'titaq.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ge's etlewistuaneg, Wejuli Nisgaml nisa'siliteg aq pisgwa'nniteg uggamlamunuaq aq ilgwengwi'titeg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Na tujiw migwite'tmap ta'n Gjisaqamaw teluepnaq, ‘Sapatis e'w'g samqwan, sign'tuaji mimajuinu'g ta'nig gawasgita'sultipnig aq jiglita'pnig elue'utigtug aq el'ta'pnig Nisgamewigtug. Gatu gilew Gjinisgam sign'tugsitoqs'p e'watal Wejuli Nisgamal.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Teliaq na Gjinisgam ignmuapni wegla ta'nig mo Lesui'peulti'gw na wijei ignmatimgewei ta'n ginu ignmugsi'gup ta'n tujiw getlams'tasulti'gweg Gjisaqamaw Se'sus. Wenin ta ni'n, ugjo'tm naqa'lan Gjinisgam!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ta'n tujiw nutmi'titeg na smtug naqa'tu'tij ta'n tel majiaqa'la'tij. Na tujiw miwatmua'titl, gepmitelma'titl, aq emtoqwala'titl Nisgaml. Teluejig, “Gjinisgam elt ignmuapni wegla ta'nig mo Lesui'peulti'gw gawasgita'sultinew, jiglita'new lue'utigtug aq lta'new Nisgamewigtug ugjit ugs'ta'tinew. Iapjiw mimajuaqan 'msnmnew.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ta'n tujiw Stipen gis ne'po'teg, ta'nig getlams'tasultijig gitnme'wipnig aq se'setoqutipnig. Na alt el'ta'jig gneg Ponisiaewa'gi aq alt na mnigu Saiplus ap igtigig na 'gjigan Antioq el'ta'jig aq telima'tiji gelu'lg agnutmaqan pas'g Lesui'paq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Gatu ta'sijig ta'nig getlams'tasultipnig weita'jig Saiplus aq Sailin el'ta'jig Antioq. Ta'nig mo Lesui'peultiligwi telima'tiji gelu'lg agnutmaqan ugjit Gjisaqamaw Se'sus. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gjinisgaml ma'muni apoqonmagwi'titl aq pugwelgig mimajuinu'g getlams'tasultijig aq el gawasgita'ji Gjisaqamawul. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Gaqpeggwa's'g agnutmaqan ugjit wegla, we'gaw ta'nig getlams'tasultijig Selusalemg, aq negmow Pnnalal elgima'titl Antioq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ta'n tujiw Pnnal iga'teg aq nemiateg ta'n Gjinisgam teli ul'te'lmaji mimajuinu'g, wel'ta'sit aq munsaiwaji 'ms't ta'n te'sijig siaw majulgwalanew Gjisaqamawul aq siaw jigs'tua'tinew ta'n telgi'g uggamlamunual. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Welm'toq ji'nm na Pnnal. Ilgwentl na Wejuli Nisgaml aq melgi gtlams'tg. Pem pugweliejig mimajuinu'g pejo'laji Gjisaqamawewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Na toqo tujiw Pnnal eliet Talsus naji gwiluan Solal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ta'n tujiw we'jiateg nespnatl Antioq. Newgtipunqeg na gitg tl mawtesgua'tiji mimajuinu'g ta'nig getlams'tasultiliji aq agnutmua'tiji pugwenniji. Etna na'te'l Antioq ta'nig majulgwala'titl Gjisaqamawl getlams'tasultijig amgwes telui'tupnig, “A'sutmewinu'g”. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Assma na tujiw ta'sijig iganigjitegewinu'g weita'jig Selusalemg aq el'ta'jig Antioq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Na newgte'jit teluisit Aqapus wenaqa'sit. Wejuli Nisgam wet sapu tl lugwet negmeg igan gnua'tuaji ta'n tliatew. Na mesgi'g pestmo'qon getu jugu'aq ta'n telgi'g ugs'tqamu. (Na teliaqas ta'n tujiw Glatius iganpuguiteg.) ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Na unaqapemg gissutmi'tij na 'ms't wen ta'n te'si'tij elgitmua'tij suliewei te's ingute'jit ta'n telgi'g gisi pgwatoq. Lgitmua'tij suliewei ta'nig getlams'tasultiliji Jutiaewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Na tela'taqatipnig. Ignmua'tij suliewei Pnnalal aq Solal ugjit la'tuanew negla iganpugultiliji ta'nig getlams'tasultiliji eimu'tiliji Jutiaewa'gig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Assma na tujiw elege'wit Elot poqji gitnme'waji ta'siliji ta'ni getlams'tasultiliji Se'sus. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Elot telimatl ugsma'gnisml, “Ne'pa' Ji'mej.” Na tujiw ne'pa'titl Ji'mejal espo'qwas'gigtug. Ji'mej na ugjignaml Sa'nal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ta'n tujiw nemiateg Lesui'paq tetapua'laji mawi ugsua'lugsilitl Pie'lal. (Na ula teliaqas ta'n tujiw tetaputesg iga'q ugjit pestie'uti ta'n e'wmi'tij mo apita'tas'gtnug pipnaqan.) ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ta'n tujiw gisi ugsua'luteg Pie'l aq pija'luteg laplusang, na tujiw iga'lut ta'nig nujo'tmi'tij laplusang, newgtisgegsijig jel asugom sma'gnisg i' ne'w nemigsijig i' sa'se'wita'jig. Elot gissutg ilsumugsilin mimajuinuigtug ta'n tujiw gaqiaq Siawa'timgewei. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Toqo Pie'l ne'gaw gennut laplusang gatu na mimajuinu'g ta'nig getlams'tasultijig ne'gaw melgi a'sutmessewa'titl Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na wela'gweg ge'sg menaq Elot ilsumagweg Pie'lal mimajuinuigtug, Pie'l me' nepat gelpilas'gl ugpitnn etuiw tapusiliji sma'gnisg pisgataqanapigtug. Etna ap igtigig sma'gnisg nujo'tmi'tij laplusanei ga'qana'tas'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Jiniw Gjinisgam ugtansale'witeml gaqamilitl na'te'l aq paqtata's'g laplusang. Na ansale'wit pepuegetl Pie'lal ugtlmaqaneg aq telimatl, “Tetaqa'si aq mn'ja'si!” Aq smtug pisgataqanapi'l menjaqal ugpitnn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Na tujiw ansale'wit teluet, “Segitga'l ugtispisun aq gmugsng nasa'l.” Pie'l smtug tela'teget aq ansale'wit telimtl, “Nasa'l 'ggotm aq wije'wi ni'n.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pie'l tew majulgwalatl laplusang. Mo enmi gji'tug ta'n ansale'wilitl tela'tegelij tlian. Tel'ta'sit telaplgigwa't. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Na pemtesgua'tiji amgwesewe'g sma'gnisg aq glapis tapuewe'g aq ugtejgewe'g gasawo'qewei ga'qana'tas'g, el panta's'g 'gjigang. Na ga'qana'tas'g panta's'g ugjit negmow 'ngutugwaiw aq na'te'l wet tua'tijig. Siawa'tijig awgtigtug aq jiniw ansale'wit naqalatl Pie'lal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Na tujiw Pie'l geitoq ta'n gis tliaq negmeg aq teluet, “Nige' geitu Gjisaqamaw petgimatl ugtansale'witeml ugjit apoqonmuin ta'n teli ugs'tawi'j, aq gis wet jigla'lit Elotal ugml'gigno'tim aq wet jigla'lit ta'n Lesui'paq tel puatmi'tij tla'taqati'tisoq.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ta'n tujiw geitoq ta'n gis tliaq, eliet Malial wiguaq. Mali uggwisl teluisilitl, Sa'n Malg. Na pugwelgig mimajuinu'g gis mawita'pnig na'te'l aq etli a'sutma'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pie'l metete'get gujmug ga'qanigtug aq nugtoqtejgwej e'pite's teluisit, Lo'ta naji gji'jiatl ta'n wen metete'gelitl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Gegnustuatl Pie'lal ta'n teli'silij. Tetuji ul'ta'sit na apat pisgutugwi'g je mo pana'tuawg ga'qan aq nat gnua'teget, Pie'l gaqamit gujmug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Telima'titl, “Elue'wien gi'l!” Pas'g na munsa't ugjit tlian. Na teli asitema'titl, “Etna na ugtansale'witeml.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tel gne'g aq me' Pie'l siawi metete'get glapis pana'tua'tij ga'qan aq ta'n tujiw nemia'titeg, paqsipgi paqalaiultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ugpitnn etlegetl aq telimaji, “Wantaqita'gw.” Na tujiw gegnua'tuaji ta'n Gjinisgam teli gtaqqa'lt'pnn laplusang aq telimaji, “Tlimatoqs'p Ji'mej aq esgwia'tijig ta'nig getlams'tasultijig.” Na tujiw naqt'g na'te'l aq na'tami se'g eliet. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na ta'n tujiw egsitpu'g iga'q, sma'gnisg ta'n nuje'wa'tipnn Pie'lal jensi mu tami eimligw, na tujiw jipaqita'jig. Teluejig, “Talasitugunaq Pie'lo'q?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Elot tewaggitg glusuaqan ugjit gwilugsin, pas'g na mo we'jia'tigul tami. Na tujiw sma'gnisg ta'n nuje'wa'tipnn Pie'lal pipanimujig aq tewaggitg glusuaqan ugjit ne'po'qsinew. Na tujiw Elot naqt'g Jutia aq eliet glapis Sesalia aq gijga'ji'j pe'l getu siawqatg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Elot ma'muni uggwaiugtuaji mimajuinu'g ta'n tle'g 'gjigann Tail aq Saiton. Mawalsultijig nat nmianew Elotal. Tmg gisa'la'titl ji'nmul teluisilitl Plastus wit toqwa'lgunew. Negm, nujo'tg's elege'wituo'guom. Etna na wet gis pisgwita'jig. Na tujiw gis glula'tital Elotal. El'ta'jig aq pipanima'titl ugjit wantaqo'ti muta negm umutgig wejo'tu'tij mijipjewei ugtelege'wa'gimg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Etna na Elot gisi mgnt gegnue'g na'gweg, ta'n tujiw nasa'toqol elege'witewe'l aligal aq epa'sit ugt'pung. Na tujiw gelulaji mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Na tel sesgu'tijig, “Mu na ji'nm etlewistoq, gatu newgte'jit gnisgaminu!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Smtug Gjinisgam ugtansale'witeml gisa'latl Elotal gesnugwalitl muta ignmuaji mimajuinu'g emtoqwalgun ta'n tujiw pas'g telteg Gjinisgam gepmitelmugsin. Gesnugwapnaq aq wetigi'g ne'pa't'pniga. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Na tujiw Gjinisgam ugglusuaqanm siawa's'g aq se'sa's'g. Pugwelgig mimajuinu'g nutmi'tij aq getlams'tasultijig Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Na Pnnal aq Sol ela'tu'tij na suliewei ta'n a'sutmewinu'g Antioq elgitmua'tij ugjit na a'sutmewinu'g Selusalemg. Gisi ignmua'titeg na suliewei negla iganpugultiliji naqtmi'tij Selusalemg pemi apaja'tijig Antioq. Nespna'titl Sa'n Malgal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ta'nig getlams'tasultijig Antioq, eig'snig ta'sijig, ta'nig teluejig ta'n Gjinisgam telimgwi'tij aq ta'nig gegina'mua'tijig ta'n Gjinisgam tel puatg. Etna na wegla: Pnnal, Simion telui'tut “An'tagwej,” Lusius (tle' 'gjigan Sailin), Manien (negm toqwigwejig Elot na g'pnno'l, aq Sol). ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ge's emtoqwala'tij Nisgaml aq suneultijig, Wejuli Nisgaml telimgwi'titl, “Tepgisa'l ugjit ni'n Pnnal aq Sol lugwatmnew 'lgowaqan ta'n tegen ni'n teli mgng'pnig.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ap suneultijig aq a'sutma'tijig. Na tujiw ge'gwa'tua'tiji ugpitnual un'jiwaq aq poqjigima'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Pnnal aq Sol, elgimuteg Wejuli Nisgaml ela'tijig gutan Selu'sia aq weji pqotaqtegejig glapis na mnigu teluisig Saiplus. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ta'n tujiw oqwa'titeg 'gjigan Salamis, ela'tijig Lesui'pewei a'sutuo'guomg aq pestunmatmi'tij Gjinisgam ugglusuaqanm. Sa'n Malgal wije'wa'titl ugjit mawi apoqonmatultinew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Siawi asoqomita'jig na mnigu glapis Papos. Etna na'te'l weltesgua'titl ula puowinal teluisilitl Pa'l Se'sus. Ula na Lesui'p etlitelsit iganigjitegewinuin. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Witapal iganpuguilitl na mnigu. Teluisilitl G'pnno'l Selgius Polus, nestuelitl ji'nmul. Na g'pnno'l wigumaji Pnnalal aq Solal negmeg, muta getu nutg's Gjinisgam ugglusuaqanm. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pas'g na negmow getangwi'titl puowinal Elimas. (Gli'gewigtug telui'tut, Elimas, Lesui'pewigtug na Pa'l Se'sus.) Negm wejo'tg jigla'lan g'pnno'lal Sulgius Polus mo 'gtlams'tasilin. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Na tujiw Sol, na telui'tut Poligap, ilgwentl Wejuli Nisgaml angamatl tegpaqiw ugsisgug puowinal, ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","aq telimatl, “Gi'l na mn'tu uggwisl. Getantun 'ms't goqwei ta'n gelu'lg aq ta'n tel gaqaisg milamu'gl winjigl tela'tegen. Wejo'tmn gawasga'tuan Gjinisgam ugteliaqeweim ta'n teli egsuen. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Gjinisgam nige' gi'l elapasual'sg aq ma nmitegewn, glapis Gjinisgam tli ul'te'lm'sg ulapin.” Smtug Elimas mu gis nemitegeg nugu aq al gigto'qwa'sit. Wejo'tg nat wen we'jian ilgwengun gnnamugsin ugpitn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ta'n tujiw gis nemitoq ta'n gis tliaq, na tujiw g'pnno'l getlams'tasitl Se'susal aq mesgi'g's ta'n tel paqalaig ta'n tel gina'muetij ugjit Gjisaqamawl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Poligap aq ta'ni wijitgweiaji weji pqotaqtaqatijig 'gjigan Papos aq oqwa'jig na gutan Pelga, Pampilia eteg. Etna na na'te'l Sa'n Malg naqalaji aq apaja'sit Selusalemg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Gatu negmow weita'jig Pelga aq siawita'jig Antioq, Pisitia eteg. Na atlasmutigisg'g el'ta'jig a'sutuo'guomg, pisgwita'jig aq epita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ta'n tujiw na iganpugultijig ala a'sutuo'guom wet gitmi'titeg 'tplutaqann Mowisewe'l aq ta'n gis wi'gas'g iganigjitegewinugi'g na elgitmua'tij glusuaqan, “Wijigatultigw, pualuloq glulanew mimajuinu'g, gugunmoq Gjinisgam ugglusuaqanm ulgwijimanew negmow.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Poligap gaqamit. Ugpitn etlegej aq telimaji mimajuinu'g, “Nisgamewei wantaqo'ti i'tt'j ggamlamunuaq. Nigmatut, Isle'lewultioq aq esgwia'tioq ta'nig emtoqwaloq Gjinisgam, nutuigw! ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Na Gjinisgam ta'n Isle'lewaq emtoqwala'tipnn, gisi mgnapni gujjinaqi'g aq gisa'lapni mimajuinu'g tetuji pugweliepnig ta'n tujiw Ijipteg eimu'titeg. Na tujiw Gjinisgam tewo'lapni Ijipteg. E'w'g'p ugml'gigno'tim. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ne'wisgegipunqeg teli pgiji gisipugutuaji paqtaqamigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Gisa'lapni 'gtmenenew lluigneg te'sunemigsijig mimajuinu'g na maqamigew Genan, aq ignmuapni ugtmimajuinumg assutmnew na maqamigew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ne'w gasgiptnnaqanipunqeg je na'nisga'q, gis pmtesgug ta'n tujiw Gjinisgam gisi mgnateg. Na tujiw ignmuapni iganpugultijig ta'nig nuji ilsutaqatijig glapis tetaputesg iganigjitegewinu Samuel 'pgising. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ta'n tujiw gluma'titeg elege'wilitl Gjinisgam ignmuapni Solal, wettaqielitl na 'Nnu'g teluisultijig Penjaminewaq. Sol ujjl na Gissal, wettaqiet Penjamineg. Negm ugtelege'witemi'tipnn ne'wisgegipunqeg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Gjinisgam mena'lapnn Solal na tujiw Ta'pital elege'witewa'latl. Etna na ula Gjinisgam teluet ugjit negm, ‘Ula Ta'pit, Jessi uggwisl, na telamugsit ji'nm, gesalg. Etna na negm tla'tegetew ni'n ta'n tel pualg tla'tegen.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Etna na ula Se'sus, wettaqiet Ta'piteg, Gjinisgam gisa'lapnn nujiugs'tawi'welin ta'n te'sijig mimajuinu'g, Isle'laq, 'st'ge' ta'n teli tplumsip. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ge's mu Se'sus poqji lugwatmugweg ugtlgowaqan, pegisinugweg Sapatis. Pestunmuapni 'ms't mimajuinu'g Isle'laq, ‘Gawasgita'sultinew aq jiglita'new elue'utigtug aq sign'tasultinew.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ge'sg menaq, Sa'n gaqa'tugweg ugtlgowaqan, telimapni mimajuinu'g, ‘Tal'ta'sultioq wenin ta ni'n? Mu na ni'n ta'n gilew esgmaloq. Gatu ma 'pgije'nug 'pgisintew negm aq ni'n mo tepawgtiw umugsng mena'tuan.’ Na. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Wijigatulti'gw ta'n Aplameg wettaqia'tioq, aq esgwia'tioq ta'n elt emtoqwaloq Gjinisgam. Ula na agnutmaqan, petgitmugsi'gw, ugjit ginu ta'n te'si'gw, ta'n Gjinisgam tli ugs'tawugsitesnu. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Na mimajuinu'g wigultijig Selusalemg aq ta'nig iganpugutagwi'tiji, mo gejia'tigupnn Se'susal, nujiugs'tawi'welin. Mo nestasulti'gw ugglusuaqanmual iganigjitegewinugi'g ta'n i' gitmi'titeg te's atlasmutigisg'g. Gatu teliaqapneg ta'n tujiw ne'po'teg Se'susal ta'n iganigjitegewinugi'g igan tluepnig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Aq we'gaw mo goqwei we'jitua'ti'gw ugjit ilsuman ta'n tl ne'pa'new gatu pipanima'titl Pilotal ugjit Se'susal ne'po'qsilin. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","'Ms't goqwei gis tla'taqati'titeg 'st'ge' ta'n tel wi'gas'g ugjit negm. Na tujiw weji nisa'lut gujjieweigtug aq etl utqutalut sapalqe'g gun'tew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","'Lpa nepg'pnaq pas'g na Gjinisgam apaji minua'lapnn aq wenaqa'lapnn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Gaqaisugunaq nemu's'p ta'nig gis mawi al'ta'tipni weja'tegemg Galali glapis Selusalem aq nige' negmow ta'n tel nemitu'tip, telima'tiji mimajuinu'g Isle'laq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Nige' ninen pegisituleg gelu'lg agnutmaqan, ta'n Gjinisgam teplumapni Lesui'paq, na tla'tegetew. Nige' gis tla'tegetaq ugjit ninen ta'nig wettaqia'ti'gw aq maw gilew, ta'nig mo Lesui'peultiwoq. Na teliaqap ta'n tujiw Gjinisgam apaji minua'lapnn na Se'susal, 'st'ge' gis wi'gas'g tapuewei 'gtapegiaqan Gjinisgam ugtwi'gatign, ‘Gi'l na 'ngwis aq nige' gisgug gepmitelmul. Weja'tegemg nige' ilgwentes 'ms't goqwei ni'newei.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Etna na ula Gjinisgam igan tluep, ta'n tli unaqa'latal 'nplij je mu sugul'gan, ‘Ignmultes ta'n goqwei gepme'g gelu'lg aq sape'wit ta'n Ta'pit teli tplumg'p ignmuanew.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Getletug aq na'tami igtig ewi'gas'g ta'n teluet, ‘Ma ignmuawt sape'wit uglugowinum sugul'gan.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ta'pito'q tela'tegepnaq ta'n Gjinisgam tel pualapnn. Ta'n tujiw nepgeg nutqutalutpnaq gmetug ujjuaqi'g aq sugul'qapnaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pas'g na newgte'jit ta'n Gjinisgam wenaqa'lapnn, gisi npliteg mo negm sugul'gaqupnaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Wijigatulti'gw, 'ms't ta'n te'sioq, telteg 'gji'tunew na gelu'lg agnutmaqan, ta'n teli usgutmuloq gilew. Wet saputa's'g Se'susewigtug Gjinisgam apigsigtugsinenu 'gtlue'utinal, ta'n tujiw getlams'tasulti'gw Se'sugulieg. Telteg 'gji'tunew na Mowis ugt'tplutaqanm mo gis jigla'lulugup lue'utigtug gatu ta'n wen getlams'tasit Se'suseg na gis jigla'lutew lue'utigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ango'tmug, nige! Glaman ta'n teluepnig iganigjitegewinugi'g ma nugu tlianug gi'leg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Teluepnig, ‘Gilew ta'n maligmoq Gjinisgam! Mo jigs'tmu'tiwoq gilew. Getl ta na nepu'tioq aq mn'tua'gig lta'toqs'p. Ma 'gtlams'tmu'tiwoq ta'n goqwe'l gis tliaqal gilew gna'gwegmuaq tlia pa wen sangew gnua'tugsinew ma jigs'tmu'tiwoq.’ ” Na tel pestung'p Poligap. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ge's Poligap aq Pnnal pemi nqatmi'tij a'sutuo'guomg, na mimajuinu'g wiguma'tiji ugjit apaja'tinew igtig atlasmutigisg'g. Telima'tiji, “Me' tlimitesnen ugjit negla ta'n goqwe'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ta'n tujiw mimajuinu'g naqtmi'titeg ta'n i' tli ultesgatultipni, Poligap aq Pnnal majulgwalji pugwenniji Lesui'paq aq maw igtigig, ta'nig majulgwatmi'tij Lesui'peweiei. Na apostale'wijig wesguma'tiji aq welima'tiji ugjit negmow siaw tl mimajultinew aq siaw lita'sin ta'n teli ulm'toq Gjinisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na igtig atlasmutigisg'g suel 'ms't wen na gutanji'j peita'jig ugjit nutmnew Gjinisgam ugglusuaqanml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ta'n tujiw Lesui'paq iganpugultijig nemia'titeg pugwenniji mimajuinu'g, smtug wisgua'tijig, poqji gtana'titl ta'n Poligapal teluelij aq emegwi panta'tu'titl ugtunual. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pas'g na Poligap aq Pnnal me' na aji melgewistoqig, “Gilew na telgitasultioq tmg nutmnew Gjinisgam ugglusuaqanm. Gatu nige' gilew mo puatmuoq aq pegwatasultioq mo tepawgtiwoq ugjit iapjiw mimajuaqan. Na nige' ninen naqaluleg aq ela'tieg ta'nig mo Lesui'peulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Gjinisgam telgimugsieg na tla'taqatinen. Teluet, ‘Ni'n iga'tuloq ugjit wasetenmuan negla ta'nig mo Lesui'peulti'gw aq musga'tuan mimajuinu'g ta'n telgi'g ugs'tqamu, ta'n tli ugs'ta'titaq.’ ” Na. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ta'n tujiw ta'nig mo Lesui'peulti'gw nutmi'titeg, wel'ta'sultijig, aq teluejig, “Gjinisgam ugglusuaqanml gelu'lgl.” Miwatmua'titl Nisgaml muta tel'te'tmlij, “Na ta'n te'sit wen 'gtlams'tasij Se'suseg guguntew iapjiwewei mimajuaqan.” Ta'n te'sijig gisita'sultijig minui ugs'tqamultinew eligsugultijig Nisgamewigtug aq getlams'tasultijig aq ta'n te'sijig pewatmi'tij iapjiwewei mimajuaqan wa'so'q. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Gjinisgam ugglusuaqanm se'sa's'g ta'n te's'gl uggutanji'jmual Antioqe'gati. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pas'g na Lesui'paq iganpugultijig, gisa'laji gepmitelmujig ji'nmug na 'gjigan aq saqama'sgwaq ta'n emtoqwala'titl Nisgaml 'gtananew Poligapal aq Pnnalal. Poqji gitnme'wa'tiji aq tewaqqatesgujig uggutanmuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Na apostale'wijig pewaqtestu'tij 'mjegei umugsnuaq na'te'l. Pa na wijei aq 'gpitnn pewaqtestoq. Na igan gnua'tua'tiji ta'n goqwei tliatew, ugjit Antioqewajg ugmetue'gmuow. Na smtug siawa'tijig glapis Aigonium. ");
INSERT INTO micMIQNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ta'nig getlams'tasultijig eigig Antioq welgwitgl uggamlamunual aq ilgwenujig Wejuli Nisgaml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Na wijei teliaq 'gjigan teluisig Aigonium. Poligap aq Pnnal ela'tijig Lesui'peweiei a'sutuo'guom aq pisgwa'tijig. Ta'n teli ulewistu'tij na pugwelgig Lesui'paq aq esgwia'tijig getlams'tasultijig Se'susal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pas'g na Lesui'paq ta'nig mo getlams'tasulti'gw mesgi'g ta'n pegwatu'tij sespena'q ta'nig mo Lesui'peulti'gw, gawasgijultijig 'gtananew Poligapal aq Pnnalal. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Na apostale'wijig, pegitgatg'pnig na'te'l. Melgita'jig ta'n telewistoqig ugjit Gjisaqamawul, musga'tuaji mimajuinu'g ta'n teluejig na teliaq. Musga'toq ta'n teli ul'te'lmaj na mimajuinu'g. Etna na ugjit Gjinisgam weji ignmuasni Poligapal aq Pnnalal ml'gigno'ti aq pugwelgl tla'tegen paqalaiuti'l aq ta'n tel mili npitege'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Na mimajuinu'g 'gjigang nasgwia'tijig, ta'sijig wel'te'lma'tiji Lesui'paq aq igtigig wel'te'lma'tiji apostale'wiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Na tujiw Lesui'paq aq na mimajuinu'g ta'n mu Lesui'peulti'gw mawalsultijig ta'nig iganpugultijig aq gissutmi'tij emegweiwanew apostale'wiliji aq gun'teugta'new. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ta'n tujiw apostale'wijig nutma'titeg ugjit ta'n getu tla'luj jaqalsumsijig. Smtug ela'tijig na maqamigew Laigonia ta'n etegl gitg 'gjigann Listla aq Tel'pi. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Na'te'l pestunmi'tij na gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Etna na ula ji'nm wigit Listla uggwatl maliggl. 'Lpa na teli ugs'tqamuiteg, pa na mo ne'gaw gisi ala'sigw. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pemgopis na'te'l, etl jigs'tuatl Poligapal. Poligap geitoq getlams'tasilin aq gisi npisilital. Gesi angamatl, ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","aq gesigawewistoq ta'n telimaj, “Gama'si aq siwnoqpugua'si!” Na ji'nm smtug wenaqiet aq poqji ala'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ta'n tujiw mimajuinu'g nemia'titeg ta'n Poligapal gis tla'tegelij, na poqji sesgu'tijig ta'n negmow teli isulti'tij ugtli'sutiwow Laigonian, “Nisgamaq mimajuinualsijig aq wa'so'q wet nisa'tijig ugjit ginu.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Pnnalal teluisungewa'titl, “Su's,” aq Poligapal, negm na “Elmes” muta negm nutewistoqop. Su's na iganpuguit nisgam ugjit Gli'gewaq aq Elmes nisgam ta'n nutewistoqop ugjit Su's. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na a'sutuo'guom ugjit Su's eteg sitatug gutan. Na patlia's ta'n elugowatl Su'sal pegisulaji latto'laq aq wasuegl ga'qana'tas'gigtug. Negm aq pugwelgig mimajuinu'g getu ne'pa'tijig ula wi'sisg, getu musga'tua'tij apostale'wiliji ta'n tli emtoqwalataq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ta'n tujiw Pnnal aq Poligap nutma'titeg ta'n getu tla'taqatilij mo wel'te'tmi'ti'gw. Smtug el'tugwi'gig megwaig ta'n mimajuinu'g eimi'tij, gesigawwejig, ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Goqwei na wet tla'taqatioq, ji'nmutut? Ninen pas'g ji'nmug, mimajuinuieg st'ge' gilew! Weji pgisineg'p ugjit tlimulinen gelu'lg agnutmaqan ugjit Se'sus aq jigla'lulinen wegla ta'n goqwe'l emtoqwatmoqol mo gelu'lgtnugl aq gisa'luleg emtoqwalanew giasgiwewei Gjinisgam. Etna na negm ta'n iapji mimajit, gisitoq wa'so'q aq ugs'tqamu, 'gta'n aq ta'n te's'g goqwei etegl na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Gis nige' sa'q eliamapni 'ms't mimajuinu'g tla'taqatinew ta'n tel puatmi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pas'g ne'gaw musgalsit ta'n wenij negm ta'n goqwei gelu'lg tela'tegej. We'gaw ignmugsioq gigpesan wejiaq musigisg'tug glaman weligwegl 'gtiga'taqanmual. Ta'n tujiw tetaputesg iga'q, aq ignmugsioq mijipjewei aq gisa'lugsioq uggamlamunual ulgwijultinew.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","We'gaw ta'n telewistoqig apostale'wijig waqqaj gis naqa'la'tiji mimajuinu'g. Wegla getu tla'taqatipnig ne'pa'tinew wi'sisg musga'tua'tij apostale'wiliji ta'n tli emtoqwalataq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ta'sijig Lesui'paq weita'jig Antioq, na Pisitia eteg, aq Aigonium, negmow pegwala'tiji mimajuinu'g gun'teugta'new Poligapal aq na tujiw tewaqqatejima'titl uggutanmuaq. Tel'ta'sultijig ne'pnitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pas'g na ta'nig getlams'tasultijig gigtoqopugutua'titl Poligapal negm wenaqa'sit aq apaji wije'wa'titl gutang. Na igtig na'gweg Poligap aq Pnnal ela'tijig gutan teluisig Tel'pi. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Poligap aq Pnnal siaw gina'muatmi'tij na gelu'lg agnutmaqan ula gutan Telpi aq gisa'la'tiji pugwenniji mimajuinu'g majulgwalanew Se'susal. Ap nesutesgmegl 'gjigang Listla, toqo Aigonium, aq Antioq, Pisitia eteg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Melgignewa'la'tiji ta'nig getlams'tmu'tiliji aq welgwijima'tiji ugjit siawi gtlams'tuanew Se'susal. Na tel gina'mua'tijig, “'Lpa pugwelgl wet saputita'igul metue'gl gesgmnaq pisgwita'igw Gjinisgam ugtelege'wa'gimg wa'so'q.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Te's gutan ta'sijig ta'n getlams'tmu'tijig, megna'tiji ta'nig iganpugutuataq. A'sutmessewa'tiji aq suneultijig, na tujiw Nisgaml ugpitng iga'tua'tiji mimajuinu' ta'n gis elita'sitipnn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ta'n tujiw gis saputita'titeg ta'n telgi'g Pisitia, pegisingig na maqamigew teluisig Pampilia. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Gelu'lg agnutmaqan pestunmua'tiji na mimajuinu'g tleiaultijig na gutan Pelga. Na tujiw el'ta'jig glapis na gutan Attalia. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Na'te'l pem tepa'tijig lapuguanigtug aq apajaqtaqatijig Antioq. Etna na'te'l ta'nig getlams'tmu'tijig iga'tua'tipnn Poligapal aq Pnnalal Nisgaml ugpitng glaman gisa'tutaq ula 'lgowaqan glapis gaqa'tu'tij aq nige' gaqa'tu'titeg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ta'n tujiw iga'titeg Antioq, mawita'jig mimajuinu'g ta'nig getlams'tmu'tijig aq telima'tiji ta'n Gjinisgam teli apoqonmuapni aq wet sapu tl lugwep negmowigtug glaman na nige' ta'nig mo Lesui'peulti'gw gis tli gtlams'tasultitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pegitgatmu'tijig na'te'l wijitgweiwa'tiji ta'ni wegla getlams'tasultiliji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ta'sijig ji'nmug weita'jig Jutiaewa'gig glapis Antioq naji gina'mua'tiji ta'nig getlams'tua'titl Se'susal. Teluejig, “Ma gilew ugs'ta'tiwoq glapis lugwatasultioq 'st'ge' ta'n telteg 'tplutaqan Mowisewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Gatu Poligap aq Pnnal ma'mun gi'gaja'sualujig ula ji'nmug ugjit na. Ta'nig getlams'tua'titl Se'susal gissutmi'tij Poligap, Pnnal, aq ta'sijig igtigig tleiaultijig Antioq, 'lta'new Selusalemg nat nmianew apostale'wiliji aq iganpugultiliji ugjit na. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Na elgimujig. Ge's pemi lta'titeg Ponisiaewa'gig aq Samaliaewa'gig, agnutma'tijig wijigoma'tiji ta'n tel gawasgita'tij Nisgamewigtug ta'nig mo Lesui'peulti'gw. Ula agnutmaqan pegisitu'tij mesgi'g ul'ta'suaqan ugjit ta'n te'sijig wijigoma'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ta'n tujiw iga'titeg Selusalemg wel'ta'sultijig ta'n teli ultesgatulti'tij apostale'wijig, iganpugultijig aq esgwia'tijig ta'nig getlams'tasultijig. Telima'tiji ta'n Gjinisgm wet sapu tl lugwep negmow na Pnnaleg aq Poligapeg ugjit ta'nig mo Lesui'peulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Gatu ta'sijig Palasiaq ta'nig getlams'tmu'tijig, gaqamita'jig aq teluejig, “Amujpa na ta'nig mo Lesui'peulti'gw elugwatasultijig aq telima'tiji jigs'tmug na 'tplutaqan Mowisewei.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Na apostale'wijig aq iganpugultijig mawagnutma'tijig ugjit na. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pegit agnutma'titeg, na tujiw Pie'l gaqama'sit aq teluet, “Wijigatulti'gw, gis nige' sa'q, gilew geituoq, Gjinisgam weji mgnip ni'n te'sioq ugjit gelu'lg agnutmaqan gina'muen ta'nig mo Lesui'peulti'gw, glaman negmow nuttaq aq 'gtlams'tasultitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Aq Gjinisgam, ta'n gejiaji mimajuinu'g ta'n telgwijultilij uggamlamunuaq, musga'tuapni ta'n ul'te'tmnew ta'nig mo Lesui'peulti'gw. Ignmuapni Wejuli Nisgaml pa na wijei aq ginu ta'n teli ignmugsi'gup. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Mo tal piltua'lagupni ginu aq negmow, apigsigtmuapni ugtlue'utiwal muta getlams'tasultipnig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","'Lpa 'gtu lugwaloq Gjinisgam? Pa na munsaiwaji wegla ta'nig mo Lesui'peulti'gw majulgwatmnew pugwelgl ta'n goqwe'l je mo ginu gujjinaqi'g gisotmi'tigupneg aq ginu mo gissotmug? ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ginu weji ugs'ta'ti'gw ta'n teli gtlams'tmu'g Se'suseg ta'n ewlite'lgaqan pema'lugsi'gw. Pa na wijei negmow na teli ugs'ta'tij.” Na teluet Pie'l. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Na tujiw tetuji jigteg ta'n tujiw Poligap aq Pnnal gegnua'tuateg 'ms't goqwe'l tel mili npitege'tij aq paqalaiultijig ta'n Gjinisgam tel mil lugwej e'waji ugjit ta'nig mo Lesui'peulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ta'n tujiw gaqewistu'titeg Ji'mej gelusit, “Jigs'tuigw, wijigatulti'gw. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simion nige' gis gnua'tugsioqos ta'n Gjinisgam amgwes musga'tuaj ugjit ul'te'tmnew negmow ta'nig mo Lesui'peulti'gw. Weji ugsua'laji wegla ta'nig getlams'tasultijig ugjit negmewe'n. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Iganigjitegewinugi'g ugglusuaqanmual wijei telueg'p 'st'ge' nige' gis tliaq. Gjinisgam ugtwi'gatign, tel wi'gas'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Gjisaqamaw teluet, ‘Ni'n apaja'sites aq tla'tega's ta'n goqwei teli tplumg'p Ta'pito'q. Gisa'la's ta'n Ta'pit wetapegsit, ilgwenan mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Toqo 'ms't ala igtigig mimajuinu'g gwiluataq Gjisaqamawul. 'Ms't ta'n te'sijig mimajuinu'g ta'n wigumgig ugjit ni'newe'new. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Na teluet Gjisaqamaw ta'n ignmut'pnig gujjinaqi'g 'gji'tunew gis sa'q.’ ” ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ji'mej siawewistoq, “Ni'n telsutm mut piami 'lgowaqana'lanew na mimajuinu'g ta'nig mo Lesui'peulti'gw, pem gawasgita'sultijig aq 'lta'jig Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Gatu awna wi'gmuanej wi'gatign tlimatesnu. ‘Mut malqotmnew mijipjewei ta'n gisi emtoqwa's'g ugjit 'nnuoqta'wg. Angweiasultigw, aq mut malqotmnew wi'sis ta'n gis gestunepilut, pa na wijei mal'tew mut malqotmnew. Ta'nig tepqatmutijig mut sespo'taqatinew, aq pa na wijei ta'nig newgtugwa'lugutijig.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Muta Mowiso'q ugt'tplutaqanm gis nige' sa'q egi'tas'g a'sutuo'guomg te's atlasmutigisg'g aq wegla glusuaqann pestunmi'tij te's gutan.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Na tujiw apostale'wijig aq iganpugultijig maw 'ms't ta'nig getlams'tmu'tijig gisita'sultijig mgnanew ta'siliji ji'nmug na'te'l aq poqjigima'tiji Antioq maw Poligapal aq Pnnalal. Megna'tiji Sutaal, telui'tut, “Palsapas” aq Sailas tapusiliji ji'nmug ta'n maw gepmitelmujig. Ula na wi'gatign ta'n elgitmua'tij: ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","“Wijigatulti'gw, ninen apostale'wieg aq iganpugultieg wel'ta'sualuleg gilew ta'nig mo Lesui'peultiwoq. Eimu'tioq 'gjigan Antioq, aq na maqamigal Silia aq Silisia. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Gis nutmaieg alt ji'nmug te'sieg 'lta'pnig ta'n eimu'tioq aq gaqi ewnasimugsioq ta'n te's'g goqwei. 'Lpa mo ninen telimaqatt'pnig na tla'taqatinew. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Etna na ugjit mawalsieg'p aq 'ms't wel'te'tmeg'p mgnanen alt ji'nmug. Weji ugsua'l'g'tjig ula ninen te'sieg ugjit 'lgitmulinen. Wije'wataq wegla tapusijig nigmenaq Pnnal aq Poligap ta'n mawi gsalg'tjig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Iga'tu'tip negmow ugmimajuaqanmuow ta'n tel lugowa'tip Gjisaqamawminu Se'suguli. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nige' elgimg'tjig Suta aq Sailas. Negmow tlimultaq na wijei ta'n gis wi'gmuleg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Wejuli Nisgam ilgwenugsieg ta'n telita'sultieg mo piam gitnm'tinew pas'g wegla ta'n telimulegl nige'. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mut malqotmnew mijipjewei ta'n gisi emtoqwa's'g ugjit 'nnuoqta'wg, mut malqotmnew mal'tew, mut malqomanew wi'sis ta'n gis gestunepilut. Ta'nig tepqatmu'tioq mut sespo'taqatinew aq pa na wijei newgtugwa'lugutioq. 'Lpa na gis tla'taqatioq ula'taqatitoqs'p. Glapis nemitulti'gw. Na 'ms't.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ignmua'tij wi'gatign ula tapusiliji ji'nmug Sailasal aq Sutaal aq elgima'tiji Antioq. Ta'n tujiw iga'titeg na'te'l, mawita'jig ta'nig getlams'tmu'tijig aq ignmua'tij wi'gatign. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ta'n tujiw ula mimajuinu'g gis gitmi'titeg ula wi'gatign, na we'gwi ul'ta'sultijig ta'n ula wi'gatign telueg aq welgwijimgwi'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Suta aq Sailas, na nutewistoqig ugjit Gjinisgam pegiji usguma'tiji weget ta'nig getlams'tmu'tijig, welgwijima'tiji aq melgignewa'la'tiji ta'n teli gtlams'tasulti'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pegitgatmu'tijig na'te'l. Na tujiw ta'nig getlams'tmu'tijig enmigima'tiji wantaqo'tigtug. Apaita'jig ta'nig petgima'tipni. 'Ms't wen welgwijing'p.  ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Gatu Sailas gissumsit siawqatmn na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Poligap aq Pnnal pegitgatgig na'te'l Antioq. Negmow aq pugwelgig igtigig gegnu'tmua'tiji aq pestunmatmi'tij Gjinisgam ugglusuaqanm. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Panaemg ta'sijig tepgunsejig, Poligap telimatl Pnnalal, “Ge' apaja'tinej aq naji mittugwalanej ta'nig getlams'tmu'tijig ta'n te's'gl gutanji'tl na'te'l ta'n pestunmu'g'p Gjinisgam ugglusuaqanm, aq gisi gji'jiatesnu ta'n telo'lti'tij.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Pnnal getu nespnasn Sa'n Malgal, maw negmow. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pas'g na Poligap tel'ta'sis mo weltenug nespnan, muta mo wijitgweiwagupni glapis gaqa'tu'titeg ugtlugowaqanuow. Awna apaja'sis aq naqalasni 'gjigan Pampilia. ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mo wijei tel'te'tmi'ti'gw ugjit Malgal aq mo gisi pegwatesguagupni. Na tujiw nigtua'tijig. Pnnal nespnatl Malgal, ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","gatu Poligap megnatl Sailasal. Ta'nig getlams'tasultijig telima'tiji, “Iga'luleg Gjinisgam ugpitng aq negm angweiugsitoqs'p.” Na tujiw naqtmi'tij na'te'l. Pnnal aq Malg elaqtegejig Saiplus, aq Poligap aq Sailas ");
INSERT INTO micMIQNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","wet saputa'tijig maqamigew teluisig Silia aq igtig Silisia. 'Mjit ap newgt ali apoqonmua'tiji ta'nig getlams'tmu'tijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Poligap siawa'sit Tel'pi, na tujiw Listla. Etna na ula ji'nm teluisit Timoti ta'n wigit na'te'l. Getlams'tasit maw uggwitl, negm Lesui'pewi'sgw, pas'g ujjl na Gli'gewa'j. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","'Ms't ta'n te'sijig getlams'tasultijig wigultijig Listla aq Aigonium weli usguma'titl Timotial. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Poligap getu nespnasn Timotial. Etna na ugjit elugwalasn. Wet tla'teges na muta ta'n te'sijig Lesui'paq na'te'l gejia'titl Timotial ujjl Gli'gewa'j. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ge's pemi 'lta'tij gutan, telima'tiji ta'nig getlams'tmu'tiliji ta'n goqwe'l iganpugultijig aq apostale'wijig Selusalemg gissutmi'tij ugjit ta'nig mo Lesui'peulti'gw majulgwatmnew. Telima'tiji jigs'tmnew wegla 'tplutaqann. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Etna na ugjit wegla ta'nig getlams'tua'titl melgi gtlams'tasultijig aq pem pugweliejig te'sigisg'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Na tujiw pem siawita'jig na maqamigew miawe'g Pligia aq Galetia. Mo Wejuli Nisgam ignmuagusni la'tinew na maqamigew teluisig E'sia ugjit pestunmnew gelu'lg agnutmaqan na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Toqo siawita'jig glapis na maqamigew teluisig Misia. Ta'n tujiw iga'titeg na'te'l getu 'lta'snig na maqamigew teluisig Pitinia, pas'g na Se'sus ugjijaqamitl, na Wejuli Nisgaml mo ignmuaqupni 'lta'lin. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Na siawi angamita'jig Misiaewa'gig aq enminisgamigeg glapis Tloas. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Na wela'gw Poligap telapulgigwa'it. Nemiatl ji'nmul, Masetonia tle'l, gaqamilitl aq etawaqtmalitl, “Jugu'a ula Masetoniaewa'gig aq apoqonmuieg!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ta'n teli nqase'g Poligap telapulgigwa'it, na smtug ilajultieg aq naqtmeg na gjigan Tloas ugjit 'lta'nen Masetoniaewa'gig. Na Gjinisgam telimugsieg ugjit 'lta'nen gina'muan mimajuinu'g na'te'l na gelu'lg agnutmaqan. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Toqo weji pqotaqtaqatieg Tloas, aq wet siawaqtaqatieg tetpaqiw mnigu teluisig Samotle's. Igtig na'gweg siawi asoqomaqtaqatieg glapis Niapolis, aq na'te'l oqwa'ieg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Weja'tegemg na'te'l, el'ta'ieg na 'gjigan teluisig Pilippi eteg na amgwesewei maqamigew Masetoniaewa'gig, pugwelgig Lo'mewaq wigultijig na'te'l. Eimu'tieg pe' ta'suguna'q na 'gjigan. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Na atlasmutigisg'g tewita'ieg na 'gjigan aq el'ta'ieg gigjiw sitmug. Tel'ta'sultieg i'tt'tew ta'n i' tli a'sutma'tijig Lesui'paq. Na epita'ieg maqamigeg aq agnutma'tieg na e'pijig ta'nig etl mawita'pnig na'te'l. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Na newgte'jit nutugsieg teluisis Litia, tleiawit na gutan Taiataila. Negm nuji ntuisgetoqol mego'tigl megwi ewne'gl amalegn. Ula e'pit emtoqwalatl Nisgamal, aq Gjisaqamaw pana'tua's ugtangita'suaqanm ugjit melgi jigs'tmn ta'n Poligapal teluelij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Negm aq ta'n te'sijig mimajuinu'g eimu'tiliji wiguaq, 'ms't sign'tugsnig. Na tujiw wigumugsieg 'lta'nen wiguaq aq i'mnen. Teluet, “Geituoq nige' ni'n getlams'tasi Gjisaqamaw Se'sus. Pualuloq jugwita'new nignaq aq i'mu'tinew.” Gisita'sultieg ugjit 'lta'nen wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Newgte'jit na'gweg pemi lta'ieg ta'n i' tli a'sutma'tieg, asugugsieg gistejui'sgwej geggunasn mn'tu'l, ta'n gisa'latl igani gji'tun goqwei ta'n tliatew. Ta'n teli ugsigej megete'g suliewei ugjit negla ugtassusitemg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Alulgwalugsieg ta'n tel militaieg ninen aq Poligap, mimajuinu'g sesgwalaji, “Wegla ji'nmug elugowa'titl Gjinisgaml ta'n mawi espe'litl. Telimugsioq ta'n tli ugs'ta'titoqs'p.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Gaqaisugunaq tela'teget glapis Poligapal taqala'latl, gigto'qopugua'sit, aq telimatl na mn'tu'l, “Ugwisunm Se'suguli, ni'n telimul tualqa'sin na e'pite's.” Smtug, na mn'tu gettaqa'sitl e'pite'sl. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Na wegla ugtassusitemg geitu'tij ntutaq ta'n telitu'tij suliewei goqqwa'la'tiji Poligapal aq Sailasal aq eltejima'tiji ta'n iganpugultijig eimi'tij ta'n i' tli usgowita'tij mimajuinu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Pegisula'tiji wegla ta'n assusijig Lo'mewaq eigig, telua'tijig. “Wegla ji'nmug Lesui'paq aq mesgi'g sespena'q gisa'tu'tij 'ggutanminaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Gegnu'tmugsieg ta'n ginu 'tplutaqan telteg mu tla'taqatinenu. Ginu na Lo'mewaq aq ma gis majulgwatmuggul ta'n telimugsi'gw.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Na pugwelgig mimajuinu'g wittoqutijig aq poqji matna'tiji. Assusijig menina'tua'tiji utapsunual Poligapal aq Sailasal, melgima'tiji ugjit te'sipowmaqanta'new. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ta'n tujiw gis ma'muni ugsito'teg, na tujiw pijjiaqalujig laplusang, aq nuji ango'tg laplusang telimut, “Ml'gi appusqa'inen!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Na gis tlimuteg laplusane'j pijegeji mujga lame'g laplusang aq mesgi'gl gmu'tl pitasgatuaji uggwatual aq seggapinmuaji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Na'tami gisgatatpa'q, Poligap aq Sailas metewi a'sutmajig aq etli gtapegiatmi'tiji Nisgamewei a'sutmewintoqig. Gatu na ula igtigig laplusang pisultijig etl jigs'tua'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Na jiniw mesgi'g maja's'g ugs'tqamu aq pepuegej laplusang ta'n ge'guteg. Na smtug 'ms't ga'qann panteta'qal aq pisgataqanapi'l menjaqal uggwatuaq ta'n te'sijig pisultijig laplusang. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Na nujo'tg laplusane'j tugwieteg, ta'n tujiw nemitoq ga'qann pantetegl tel'ta'sit ta'n te'sijig pisultipnig gaqsmultitgig. Na smtug wesua'toq espo'qwas'g aq getu ne'pa'sit. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pas'g na Poligap sesgwet ta'n tel we'gwisigawwej, “Mut na tla'tegew. 'Ms't ula eimu'tieg!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Na laplusane'j wigumatl ji'nmul ta'n nujo'tmlij wasoqonmaqan aq pegisitlij laplusane'j pisgutugwi'g aq nespi neng'tesing aq el nutgul'pa'sua'laji Poligapal aq Sailasal uggwatuaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Na tujiw tew wije'waji aq pipanimaji, “Tala'tega's, saqamawtut, ta'n tli ugs'ta's?” ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Telima'titl, “'Gtlams'tasi Gjisaqamaw Se'sus aq ugs'tates, maw gigmaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Gegnu'tmua'tiji Gjinisgam ugglusuaqanml, negm aq 'ms't ta'n te'sijig wiguaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Na wijei te's ajiet na wela'gw na laplusane'j wesua'laji Poligapal aq Sailasal waqama'tuaji ta'n tel jilta'silij. Toqo negm aq 'ms't wi'gma smtug sign'tasultijig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Na laplusane'j enma'laji wiguaq aq essmaji. Negm aq wi'gma welgwijultijig muta nige' getlams'tasultijig Nisgamewigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Na wapg Lo'mewaq assusijig elgitmi'tij glusuaqan ugjit nujiugsua'tegejig teluejig, “Tua'lug negla ji'nmug!” ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Toqo na laplusane'j telimatl Poligapal, “Assusijig petgitmi'tij glusuaqan ugjit gi'l aq Sailas gis tua'titoqs'p aq sangew maja'tigw nige'.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pas'g na Poligap telimaji nuji ugsua'taqatijig, “Menaq ninen goqwei opla'tueg aq mo sewisga'tueg ugt'tplutaqanmuow. We'gaw te'sipowmaqantoqsieg'p mimajuinuigtug. Ninen, Lo'mewaq, pa wijei aq gilew! We'gaw pija'lugsieg laplusang aq nige' pualugsieg jigla'tinen aq mo pualiweg goqwei me'ta'tmnen! A' na moqwa'! Amujpa na negmow Lo'mewaq assusijig wejgwa'tijig tet aq getaqa'lugsieg.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Na nuji ugsua'tegejig gegnua'tegejig Lo'mewaq assusijig. Ta'n tujiw geitu'titeg Poligap aq Sailas Lo'mewaq pa wijei aq negmow na jipaqita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Smtug ela'tijig aq telima'tiji ta'n teli ms'ge'tij. Na tujiw tewa'la'tiji laplusang aq etama'tiji, “Etug gilew teli ulm'tuoq jigla'tioq 'ngutanminaq.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Poligap aq Sailas naqtmi'tij laplusang aq ela'tijig Litia wiguaq. Na'te'l weltesgua'tiji ta'ni getlams'tasultiliji. Agnutma'tijig aq welima'tiji. Na smtug naqtmi'tij na 'gjigan. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Na tujiw siawita'jig 'gjigan teluisig Ampipolis aq igtig teluisig Apollonia, aq peita'jig Tessaloniga. Na'te'l eteg's Lesui'pewei a'sutuo'guom. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","'St'ge' ta'n i' tla'teget, Poligap naji tgo'tg. Ta'n teli pgitgatg, nesisgl atlasmutigisgugl mimajuinu'g wesgumaji aq sespagnutma'tiji. Gjinisgam ugtwi'gatign e'w'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Gegnua'tuaji aq musga'tuaji amujpa na Nujiugs'tawi'wet teli ulmaje'g'p, nepg'p aq apaji minunsipnaq. Poligap telimaji, “Ula Se'sus, ta'n wesgumug, etna na negm Nujiugs'tawi'wet, ta'n Gjinisgam megnapnn ilgwenan ugtmimajuinumg.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Alt jigs'tua'titl aq getlams'tmu'tijig ta'n goqwe'l Poligap teluet. Wit toqwa'la'tiji Poligapal aq Sailasal, maw pugwelg'snig Gli'gewaq ta'n emtoqwala'titl Nisgaml aq pugwelg'snig saqama'sgwaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Gatu na Lesui'paq wisgua'tijig aq amwa'la'tiji pugwenniji al'ta'winu'g. Na ta'n telgi'g 'gjigan mesgi'g gisa'tu'tij sespena'q. Ma'muna'taqatijig. Gi'gaj pisgwita'jig Jasoneg, al gwilua'tiji Poligapal aq Sailasal ugjit la'lanew mimajuinuigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pas'g na ta'n tujiw mo we'jia'tigweg tewaqtejima'titl Jasonal maw igtigig ta'nig getlams'tasultijig. Ela'la'tiji 'gjigang ta'n etli assusi'tij aq sesgu'tijig, “Wegla ji'nmug gisa'tu'tij mesgi'g sespena'q 'ms't tami! Nige' peita'jig ginu 'ggutanminu ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","aq Jason geggunapni wiguaq. Ta'n te'sijig sewisga'tu'titl 'tplutaqan g'pnno'lewe'l. Getana'titl Lo'mewei Gjielege'wilitl aq teluejig ap igtig elege'wit, me' espe'g teluisit Se'sus.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Na gis tlue'titeg mimajuinu'g me' naji sespo'ltijig maw iganpugultijig na 'gjigan aq me' sespena'q gisa'tu'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Na assusijig telima'tiji Jasonal aq igtigig, “Amujpa na apangitmoq ta'n telgi'g glutmugsioq!” Apangitmi'tij aq na tujiw iga'la'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ta'n teli nqase'g gis wel oqonitpaqiaq, ta'nig getlams'tasultijig elgima'tiji Poligapal aq Sailasal Plia. Ta'n tujiw iga'titeg na'te'l ela'tijig Lesui'pewei a'sutuo'guomg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Na mimajuinu'g na'te'l me' negmow naqamasi pana'tu'titl ugtangita'suaqanmual, je mu na mimajuinu'g tleiaultijig Tessaloniaeg. Jigs'tmu'tijig Gjinisgam ugtwi'gatign aq wels'tmi'tij. Te'sigisg'g gegina'masultijig na gelu'lg wi'gatign ugjit ta'n Poligap teluet getloqo tlian. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Na ugjit pugwelgig getlams'tasultijig maw pugwelgig Gli'gewaq saqamawinu'g aq saqama'sgwaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ta'n tujiw Lesui'paq tleiaultijig Tessaloniaeg, nutma'titeg, Poligap me' pestunmuaj Nisgaml ugglusuaqanm mimajuinu'g Peliaewaq, el'ta'jig na'te'l aq mesgi'g gisa'tu'tij sespena'q. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Smtug ta'nig getlams'tasultijig poqjigima'titl Poligapal maw igtigig ta'n tl tepita'taq lapuguanigtug. Gatu Sailas aq Timoti gitg siawqatgig Plia. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Na ji'nmug ta'nig Poligapal wije'wa'tipnn, el'ta'jig glapis Atens. Na tujiw apaita'jig Pelia. Poligap telimaji ugjit tlimanew Sailasal aq Timotial jugwa'tinew ta'n negm eig, ta'n teli nqase'g gis maja'ti'tij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ge's Poligap etli esgmalaji Sailasal aq Timotial, ewlgwijing's ta'n tujiw nemiateg pugwelgig 'nnuoqta'wg ta'n i' tli emtoqwatmi'tij nisgamaq na 'gjigan. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","A'sutuo'guomg sespagnutma'tijig Lesui'paq aq maw esgwia'tijig ta'n emtoqwala'titl Nisgaml. Te'sigisg'g sespagnutma'tijig ta'n i' tli ntuisga'ti'tij mimajuinu'g asuita'jig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Etna na ula Epigulianaq aq Stoigaq nujigina'mua'tijig asuagnutma'tijig Poligapal. Alt teluejig, “Wen ta ula mo goqwei nenmug ali ewgsitoq? Goqwei getu tluet?” Igtigig teluejig, “Ni'n ta'n teli angaptm wesgumaji se'g tle'g nisgamaq.” Wet tluesnig muta Poligap al gina'muet ugjit Se'susal aq ta'n tel minunsipnaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Na Poligapal wiguma'titl ta'n negmow i' tli ultesgatulti'tij teluisig “Na Alio'paqas” ta'n mawagnutma'ti'tij aq telima'titl, “'Gsatmugeg gisi gji'tueg ula gi'l ta'n tel piltu gina'muen aq ta'n goqwei wesgutmn. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Amgwes nutmeg ula piltue'g aq 'gsatmugeg gisi gji'tueg ta'n goqwei wesgutmn.” ( ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Na mimajuinu'g Atenewaq aq esgwia'tijig wigultijig na'te'l 'gsatmi'tis mawita'new glaman gis tlimtultitaq ta'n goqwei gis nutmi'tij aq getu nutmi'tij me' goqwei piluei.) ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Poligap gaqama'sit ta'n etl mawagnutma'tipnig Alio'paqaseg aq teluet, “Mimajuinutut, Atenewaq, ni'n tel nemitu gilew ta'n telo'ltioq Alio'paqas. Gepmitelmoqig pugwelgig nisgamaq, ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","muta wejgu'eianeg 'gjiganmuaq, angaptmapnn ta'n te's'gl i' tli emtoqwaloq nisgamaq. Nemituap newgte'jit na ula ewi'gas'g, ‘ugjit mo geitasigw nisgam.’ Na newgte'jit ta'n emtoqwaloq gatu mo gejiawoq nige' telimuloq na ula Gjinisgam. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Etna na ula Gjinisgam gisitoqop ugs'tqamu aq 'ms't goqwei ta'n eteg. Etna negm assutg wa'so'q aq ugs'tqamu, aq mu negm wigigw a'sutuo'guomg ta'n ji'nm gisitoq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","'Ms't goqwei gisitoq we'gaw mimajuinu'g gisiapni aq ignmuapni gamlamuti aq ugjijaqamijuaq. Tal gis mimajuinu ignmuatew Nisgamal ta'n goqwei tel nuta'maj? ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Newgte'jilitl ji'nmul eliapnn aq newgte'jilitl e'pilitl, na na'te'l wetapegsijig ta'n tel milapegsultijig mimajuinu'g. Ignmuapni i'mnew ta'n telgi'g ugs'tqamu. Ge's mu eliagweg gis gissutg'p giasgiwewei ta'n tet tami i'mnitaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Na wet tla'teges glaman mimajuinu'g gwiluataq Nisgamal. Etug jel we'jiataq ge's gwilua'tij pa na wijei aq nige' alapenewet ta'n tujiw gwilg goqwei. Mo Gjinisgam gneg eimug, maw tepaw eig ta'n eimu'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Muta negm gisa'lugsi'gw mimajultinenu, maita'nenu, aq nige' ta'n telo'lti'gw. 'St'ge' nige' nuji a'tugwa'tijig i' tluejig, ‘Ninen elt negm un'jang.’ ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ginu nige' Gjinisgam un'jang, mut wen ginu tl'ta'siwij Gjinisgam 'st'ge' 'nnuoqta'w wejitasit wisaw suliewei, aq suliewei, gisna gun'tew ji'nm gisi ila'qate'g. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mo Gjinisgam elapasualagupni na tujiw, muta mo goqwei geitu'ti'gup, gatu nige' telimaji, 'ms't mimajuinu'g 'ms't tami gawasgita'sultinew aq jiglita'new elue'utigtug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","'Muta Gjinisgam gis tepgisa'toq na na'gweg ta'n tujiw giasgiwewei ilsumataq 'ms't ta'n te'sijig mimajuinu'g. Na tla'tegetew wet sapu tl lugwet ula ji'nmul Se'susal ta'n gisi mgnapnn. Ta'n tujiw wenaqa'lateg ula ji'nmul gisi npliteg, musga'tugsi'gw na tliatew.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ta'n tujiw nutua'titeg Poligapal wesgumatl ji'nmul wenaqa'lut'pnaq gisi np'geg, ta'sijig negmow maligima'titl, gatu igtigig teluejig, “Getu nutu'leg etlewistun mjit newgt.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ta'n tujiw Poligap naqt'g ta'n i' tli ultesgatulti'tiji, ");
INSERT INTO micMIQNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ta'sijig mimajuinu'g getlams'tasultijig Se'susal aq wit toqwa'la'titl Poligapal. Te'si'tij eig's Tionisius, negm na newgte'jit iganpugultijig na 'gjigan Atens aq e'pit teluisit Tamalis aq ta'sijig igtigig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Gis tliaq, Poligap naqt'g Atens aq siawa'sit na 'gjigan Golint. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Na'te'l weltesguatl Lesui'pal teluisilitl Aguila, etli ugs'tqamuis maqamigew teluisig Pontus. Assma wejiet Italiewa'gig maw ugte'piteml teluisilitl Plisilla. Na g'pnno'l teluisit Glatius tewatgitg glusuaqan ugjit ta'n te'sijig Lesui'paq jiglita'new Lo'mg. Poligap eliet nat nemiaji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Siawqatg aq maw lugutijig, muta ugmimajuaqanm teli gtantoq nujiaji segi'gnignn, 'st'ge' negmow. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Na te's atlasmutigisg'g, sespagnutma'tijig mimajuinu'g a'sutuo'guomg. Wejo'tg gisa'lan Lesui'paq aq Gli'gewaq 'gtlams'tmnew Se'suseg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ta'n tujiw Sailas aq Timoti weja'ti'titeg Masetoniaewa'gig, Poligap pas'g na tel lugwet pestunmuaji mimajuinu'g gelu'lg agnutmaqan. Gegnua'tuaji Lesui'paq na Se'sus negm nujiugs'tawi'wet. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ta'n tujiw mo jigs'tagugeg aq awna me' emegwi anmima'titl, pepueget un'ji pewaqtestoqol ugpitnn, musga'tuaji, mo wel'te'tmug. Siaw tlimaji, “'Gtu 'lta'ioq mn'tua'gig, na ejela'luloq ni'n. Gilew telalsultioq aq ma ni'n pgwatuluoq. Nige' weja'tegemg lia's negla ta'nig mo Lesui'peulti'gw.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Na tujiw naqalaji aq eliet natgatg wi'g na ji'nmul teluisilitl, Taitius Justus. Negm mo na Lesui'p, gatu emtoqwalatl Nisgaml. Wi'g eteg gigjiw Lesui'peweiei a'sutuo'guom. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Na iganpuguit a'sutuo'guom teluisit Glispus, getlams'tasitl Gjisaqamawul aq maw wigma. Me' pugwelgig mimajuinu'g Golint nutmi'titeg Gjinisgam ugglusuaqanm, 'gtlams'tmu'tijig aq sign'tutupnig. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Newgtejgeg wela'gweg, Poligap telaplgigwa't aq Gjisaqamawul telimtl, “Mut jipasiw, siawewistu aq mut punajo'tmu. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Muta ni'n wijitgweiul. Ma wen gis tala'lulug, muta pugwelgig eigig 'ntmimajuinumg na 'gjigang.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Na Poligap siawqatg na'te'l newgtipunqeg jel aqataig. Gegina'muaji mimajuinu'g Gjinisgam ugglusuaqanml. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ta'n tujiw na Lo'mewaq iganpugultijig iga'la'titl Galioal iganpuguilin Gli'gewa'gig, na tujiw Lesui'paq mawalsultijig, goqqwa'la'titl Poligapal, aq ela'la'titl ta'n wen i' tli ilsumuj. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Teluejig, “Ula ji'nm, wejo'tg gisa'lan mimajuinu'g emtoqwalanew Nisgamal 'st'ge' negm ta'n mo teltenug 'tplutaqanigtug. Pa na tli a'sutma'ti'tij sewisga'tutaq 'tplutaqanminen.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Assma Poligap getu glusis ta'n tujiw Galio telimateg Lesui'paq, “Pa na nige' goqwei we'jituioq mo tetapuaqtnug gisna winjig, opla'tegen, gisna gis gmutnen na me' tli angamgugtes ni'n naqa'si aq jigs'tuloq ta'n te'sioq Lesui'pewioq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Gatu pas'g gilew gi'gaita'ioqol glusuaqann aq wisunn aq 'gt'tplutaqanmuoq amujpa na gilew ilsutmoq. Ma ni'n ilsutmug ta'n goqwe'l teli gsnugoqonewe'l.” ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Na tewaqqatesguaji ta'n i' tli ilsumuj. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ta'n te'sijig goqqwa'la'titl Sostenisal, iganpugutmlij na a'sutuo'guomg aq etl matta'titl igantug i' tli ilsutaqati'tij. Gatu na Galio mo tali elgowaqana'lugug je pe'gaj. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Na Poligap pegitqatg Golint maw ta'nig getlams'tasultijig. Na tujiw naqalaji aq el'ta'jig na gutan teluisig Senjlia maw Plisilla aq ugji'nmuml Aquila. Etna na na'te'l pesgusmuj un'ji muta gis lui'tmasis. Tepita'jig lapuguanigtug elaqtaqatijig Siliaq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Iga'jig 'gjigan Epesus. Etna ula tet Plisilla aq Aquila siawqatgig. Poligap eliet aq pisgwa't a'sutuo'guomg. Gelulaji Lesui'paq aq sespagnutma'tiji. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Pipanima'titl gisi pgitgatmlin. Pas'g negm mo wel'te'tmug. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Awna telimaji ge's mo naqalagweg, “Gjinisgam tl'te'tg apaja'sitesg.” Na tujiw naqalaji Epesusewaq aq maw wigumaq Plisillaal aq Aquilaal. Tepa'sit lapuguanigtug aq ejiglaqteget Epesuseg. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ta'n tujiw Poligap iga'iteg 'gjigan Sesalia, na siawa'sit glapis Selusalemg. Naji gji'jiaji ta'n telo'ltilij negla ta'nig getlams'tasultijig aq ulgwijimaji, welgwijimaji aq wel'ta'sualaji. Na tujiw eliet Antioq. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pegitgatg's na'te'l, aq ta'n tujiw naqt'geg siawa'is ta'n telgi'g Galetiaewa'gig aq Pligiaewa'gig. Melgignewa'tuaj ta'n teli gtlams'tasultilij. ");
INSERT INTO micMIQNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Etna na ula Lesui'p teluisit Apollos. Etli ugs'tqamuip na 'gjigan Alegsantlia. Na pegising Epesuseg. Nata' pestung a