﻿USE sofia;
DROP TABLE IF EXISTS sofia.mibNT_vpl;
CREATE TABLE mibNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mibNT_vpl WRITE;
INSERT INTO mibNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yāha cúu lista ñayuu yucūn jeē ní quiji Jesucristo. Te máá yá ni quiji nuū yucūn rey David, te David ni quiji nuū yucūn Abraham. ");
INSERT INTO mibNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ni cuu de tátá Isaac, te Isaac ni cuu de tátá Jacob, te Jacob ni cuu de tátá Judá jiín táca ñani i. ");
INSERT INTO mibNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Te Judá ni cuu de tátá Fares jiín Zara, te náná ndɨndúú i ni cuu Tamar. Te Fares ni cuu de tátá Esrom, te Esrom ni cuu de tátá Aram. ");
INSERT INTO mibNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Te Aram ni cuu de tátá Aminadab, te Aminadab ni cuu de tátá Naasón, te Naasón ni cuu de tátá Salmón. ");
INSERT INTO mibNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Te Salmón ni cuu de tátá Booz, te náná i ni cuu Rahab. Te Booz ni cuu de tátá Obed, te náná i ni cuu Rut. Te Obed ni cuu de tátá Isaí. ");
INSERT INTO mibNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Te Isaí ni cuu de tátá David, tēe ni cuu rey. Te rey David ni cuu de tátá Salomón, te náná i, xīhna gā ni cuu ña ñasɨhɨ́ Urías. ");
INSERT INTO mibNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Te Salomón ni cuu de tátá Roboam, te Roboam ni cuu de tátá Abías, te Abías ni cuu de tátá Asa. ");
INSERT INTO mibNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Te Asa ni cuu de tátá Josafat, te Josafat ni cuu de tátá Joram, te Joram ni cuu de tátá Uzías. ");
INSERT INTO mibNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Te Uzías ni cuu de tátá Jotam, te Jotam ni cuu de tátá Acaz, te Acaz ni cuu de tátá Ezequías. ");
INSERT INTO mibNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Te Ezequías ni cuu de tátá Manasés, te Manasés ni cuu de tátá Amón, te Amón ni cuu de tátá Josías. ");
INSERT INTO mibNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Te Josías ni cuu de tátá Jeconías jiín táca ñani i, máá tiempo jeē cuángoo ñayuu Israel preso nde ñuu Babilonia. ");
INSERT INTO mibNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Te náa cáyūcú i yūcuán, te Jeconías ni cuu de tátá Salatiel. Te Salatiel ni cuu de tátá Zorobabel. ");
INSERT INTO mibNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Te Zorobabel ni cuu de tátá Abiud, te Abiud ni cuu de tátá Eliaquim, te Eliaquim ni cuu de tátá Azor. ");
INSERT INTO mibNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Te Azor ni cuu de tátá Sadoc, te Sadoc ni cuu de tátá Aquim, te Aquim ni cuu de tátá Eliud. ");
INSERT INTO mibNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Te Eliud ni cuu de tátá Eleazar, te Eleazar ni cuu de tátá Matán, te Matán ni cuu de tátá Jacob. ");
INSERT INTO mibNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Te Jacob ni cuu de tátá José, tēe ni cuu yɨɨ María. Te María ni cuu ña náná Jesús, Yaā naní Cristo. ");
INSERT INTO mibNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Te nde Abraham te nde David ni īyo uxī cuūn yucūn. Te nde David te nde náa cuangoo ñayuu Israel preso ñuu Babilonia ni īyo ɨnga uxī cuūn yucūn. Te nde ná ni jengoo i preso te nde ni cacu Cristo, suni ni īyo ɨnga uxī cuūn yucūn. ");
INSERT INTO mibNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Te jeē ní cacu Jesucristo, súcuan ni cuu: Náná yā María, je ni cundaā jeē quijnáhan ña jíín José. Te nde ná tu quijnáhan ña jíín de, te ni jecūhun séhe ña ni sáha Espíritu Santo. ");
INSERT INTO mibNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Te José, tēe quijnáhan ña jíín, chi tēe ndaā cúu de. Te tu ní cúní de cuāha de jnūhun canu ña, chi sa cúní de jeē na jécuɨñɨ̄ sāhi jéē ma quíjnáhan de jíín ña. ");
INSERT INTO mibNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Te níní súcuan nácani ni de, te jíín jéni ni quee‑ni ɨɨn ndajéhé maá Jítoho yō Yaā Dios nuū de, te ni cahān yā jiín de: José, sēhe yucūn David, ma yūhu ró cueca ró ñasɨhɨ́ ró María, chi sēhe jeē scácu ña, vēji i nde nuū maá Espíritu Santo. ");
INSERT INTO mibNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Te scácu ña ɨɨn sēhe yɨɨ́. Te snání ró i Jesús, chi máá i cúu Yaā jnama ñayuu nuū cuéchi i, áchí ndajéhé. ");
INSERT INTO mibNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Súcuan ni cuu tācá jniñu yáha, návāha squícu jnūhun Jitoho yō Yaā Dios jeē ni cáhān tēe ni nacani jnūhun ya nde jenahán. Te suhva ni cahān de: ");
INSERT INTO mibNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Coo ɨɨn sūchi sɨ́hɨ́, te nihīn séhe i, te scácu i ɨɨn sēhe yɨɨ́, te conaní sūchí un Emanuel. Achí tutu. Te sɨ́hvɨ́ yáha cúní cahān: Yaā Dios ndeé yá jiín yó. ");
INSERT INTO mibNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Te ni natahū ni José, te ni sáha de nájnūhun ni cahān ndajéhé Jitoho yō jiín de. Te ni jeca de María ni cuu ña ñasɨhɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Te tu ní quíxí de jíín ña, chi nde ni scácu ña sēhe yɨɨ́ núú ña. Te ni snaní de i Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Te ná ni cacu Jesús ini ñuu Belén ndañúū Judea, te tiempo un ndácu rey Herodes jniñu. Yūcuán na te jecu tēe ndíchí jéē cascuáha sɨquɨ̄ quɨ́mɨ, ni quijicoo de nde jicá, ichi nuū cáne niāndii, te ni jinūcoo de ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Te ni cacajnūhún de ñayuu: ¿Ndé nuū íne sūchí jeē ní cacu jeē coo rey ñayuu hebreo? Chi ichi núū cáne niāndii ni cajito ná ɨɨn quɨ̄mɨ cáhnu jeē cúu seña jeē ní cacu i. Te vējicoo ná chiñúhún ná i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Te rey Herodes, ná ni jini de jnūhun yáha, te ni cunéé ni de, nde jiín táca ñáyuu ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Te ni nastútú de tāca sútū cácujéhnu jíín tée cástéén tutu ley Yaā Dios nuū ñáyuu. Te ni cajnūhún de tēe un ndé nuū cacu Cristo achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Te ni cacachi nuū de: Ini ñuu Belén ndañúū Judea. Chi suhva cáhán nuū tútu ni tee tēe ni nacani jnūhun ya nde jenahán: ");
INSERT INTO mibNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Te róhó ñáyuu ñuu Belén ndañúū Judá, cújéhnu ga ñuu rō vēsú tāca gá jeē cujéhnu ini Judá. Chi suu ini ñuu rō quenda ɨɨn Yaā ndacu jniñu, te coto ya ñayuu maá rí Israel, achí Yaā Dios. Achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yūcuán na te Herodes ni cana sāhí de tāca tée ndíchí un jéē naní mago. Te ni cajnūhun yúcún de ndé quɨ́vɨ̄ ní cane quɨ̄mɨ ún. ");
INSERT INTO mibNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Te ni tají de tēe un quíngoo de ñuu Belén. Te ni cahān de: Cuángoo ní te cajnūhun yúcún ní ndé nuū íne sūchi lúlí un. Te núu ni nanihīn ní i, te quijicoo ní castūhun ní nuū ná, návāha suni máá ná quichiñúhún ná i, áchí rey. ");
INSERT INTO mibNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Te jeē ní cajini de jnūhun ni cahān rey, te cuangoo de. Te máá quɨ́mɨ cáhnu jeē ní cajito de ichi núū cáne niāndii, yósnúu núū de cuahān nde ni jinū nuū íne sūchi lúlí un, te yūcuan ní jecuɨñɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Te ná ni cajito de jeē ní jecuɨñɨ̄ quɨ̄mɨ ún, te yōhyo ni cacusɨɨ̄ ni de. ");
INSERT INTO mibNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Te ni jinūcoo de ni quɨ̄vɨcoo de ini vehe, te ni cajito de nuū súchi lúlí un jíín náná i María. Te ni cajecuɨñɨ̄ yɨtɨ́ de nuū i, te ni cachiñúhún de i. Te ni canune de yejnū de, te ni casocō de oro jiín súje cūtú jíín súje uvuā nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yūcuán na te ni scóto jēni de, ni cachi nuū de jeē ma nuhún de nuū Herodes. Te ɨnga ichi cuanuhun de ñuu de. ");
INSERT INTO mibNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Te náa cuánuhun tāca tée mago, te ni scóto jēni José jeē ɨɨn ndajéhé maá Jítoho yō Yaā Dios ni cahān yā jiín de: Ndocuɨñɨ̄ te cunu ró quíngoo ró jíín súchi lúlí jíín náná i nde nación Egipto. Te yūcuán coyūcu ró nde castūhun rí nuū rō. Chi Herodes je yajni nanducú de sūchi lúlí jíñā jeē cáhni de i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Te ni natahū ni José. Te cuangoo de jíín súchi lúlí jíín náná i, te ñuú ní cajica de cuangoo de nación Egipto. ");
INSERT INTO mibNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Te ni coyūcú de yūcuan ndé ni jihī Herodes. Te súcuan ni cuu návāha squícu jnūhun Jitoho yō Yaā Dios jeē ni cáhān tēe ni nacani jnūhun ya nde jenahán: Nde nación Egipto ni cana ri Sēhe ri vēji i, áchí Yaā Dios, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yūcuán na te Herodes ni jini de jeē súcuan ni castáhú tée mago un de, te yōhyo ni quɨtɨ̄ ni de. Te ni tají de soldado cuangoo, te ni cajehni tāca súchi yɨ́ɨ́ lúlí jéē uú cuiyā jiín jéē yɨquɨ́n gá jeē cáyūcú ini ñuu Belén jiín táca ñuu yajni. Chi je ni cajnūhun yúcún de tāca tée mago un nasaa tiempo ni cuu jeē ní cacu Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Te súcuan ni squícu jnūhun ni cahān Jeremías, tēe ni nacani jnūhun Yaā Dios nde jenahán, chi ni cahān de: ");
INSERT INTO mibNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ini región Ramá ni jini sōho ri jeē cándahyū te cándahyū cohó. Chi ñahan cácuu yucūn Raquel, cándahyū ña jehē séhe ña, te tu cácuni ña ndusɨɨ̄ ni ña, chi ni cajihī i. Achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Yūcuán na te ni jihī Herodes. Te ni scóto jēni José jeē ɨɨn ndajéhé Jitoho yō Yaā Dios ni cahān yā jiín de nuū ndeé de nación Egipto. ");
INSERT INTO mibNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Te ni cahān yā jiín de: Ndocuɨñɨ̄ te nuhun rō ñuu rō Israel jiín súchi lúlí jíín náná i. Chi je ni cajihī tēe cánducú cahni sūchi lúlí jíñā nuú. Achí ndajéhé. ");
INSERT INTO mibNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yūcuán na te ni ndocuɨñɨ̄ de, te cuanuhun de nación Israel jiín súchi lúlí jíín náná i. ");
INSERT INTO mibNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Te ni nihīn de jnūhun jeē Arquelao ni nucuɨñɨ̄ de nuū tatá de Herodes, te máá de ndácu jniñu región Judea. Te ni yūhú de nuhun de yūcuán. Te ni scóto jēni de jeē na quíhín de región Galilea, te cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Te ni jinū de yūcuán, te ni coyūcú de ñuu naní Nazaret. Súcuan ni cuu návāha squícu jnūhun ni cacahān tēe ni canacani jnūhun Yaā Dios nde jenahán. Chi ni cacachi de jeē cahān ñayuu jeē tée ñuu Nazaret cúu Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Te ni yāha tiempo, te ni jinū Juan tēe scuándute nde nuū ñúhun téhé ndañúū Judea, nácani de jnūhun suhva: ");
INSERT INTO mibNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nacani ni rō jijnáhan ró jéē stóo ró cuéchi ró, chi je ni cuyajni Yaā ndeé andɨvɨ́ jéē ndacu ya jniñu nuū rō. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Te Isaías, tēe ni nacani jnūhun Yaā Dios nde jenahán, suhva ni tee de jnūhun Juan nuū tútu: Coo ɨɨn tēe cana jee nde nuū ñúhun téhé: Sátūhva ró máá ró jijnáhan ró, chi quee maá Jítoho yō. Te sáha ró jniñu ndaā, chi vēji ya, achi de. Achí Isaías. ");
INSERT INTO mibNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Te sahma ñúhun Juan cúu ixi quɨtɨ nání camello, te núhní ɨɨn cinturón ñɨɨ chīji de. Te jeē técu de cúu tɨ́ca ndɨcuéhyɨ́ jíín ndúxi yocō. ");
INSERT INTO mibNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Te ñayuu ñuu Jerusalén jiín táca ñáyuu región Judea jiín ñáyuu yúcu yajni yuyúte Jordán, ni quijicoo i nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Te ni canacani ndaā i cuēchi i nuū Yaā Dios, te ni scuándute de i ini yūte Jordán. ");
INSERT INTO mibNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Te ná ni jito de jeē véjicoo cuehē tēe grupo fariseo jiín tée grupo saduceo nuū scuándute de, te ni cahān de jíín: Va sēhe coō cácuu ró, chi xeēn rō nájnūhun coō. ¿A cájeni ni rō jeē cuu cunu ró cācu ró núū castigo xeēn jeē quíji? ");
INSERT INTO mibNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Núu súcuan te sáha ró jniñu váha, te súcuan stéén rō jeē ní canacani ndije ni rō jeē stóo ró cuéchi ró. ");
INSERT INTO mibNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Te ma cáni ni rō cahān rō jeē cuu cācu ró sɨ́quɨ̄ jeē cácuu ró yúcūn Abraham. Chi cáhán rī jiín ró jeē cuu sáha Yaā Dios jeē tāca yúū yáha nduu sēhe Abraham jeē candíje vāha, te núu cúní yā. ");
INSERT INTO mibNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Te cácuu ró nájnūhun nundēhé jeē tu jéhe ndehē váha. Te vijna je íyó túhva Yaā Dios jeē cuáha ya castigo xeēn, nájnūhun je íyó túhva ɨɨn cāa jeē cahnde nde yoho yujnu. Núu súcuan te sáha ya jiín ró nájnūhun jíín táca yujnu jeē tu cúun ndehē váha, jeē tahndé te cayū nuū ñuhún. ");
INSERT INTO mibNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Te ruhū chi jíín ndute scuándute ri rohó, te yūcuan cúu jeē steén rō jeē ní canacani ni rō jeē stóo ró cuéchi ró. Te Yaā jeē quíji, chi nájnūhun scuándute ya rohó cúu jeē cuáha ya Espíritu Santo condee ini anuá rō, te poder yā cúu nájnūhun ñuhūn. Te Yaā quiji chi cújéhnu ndasɨ́ yá. Chi tú na vé jéhnu cuɨtɨ cúu ri nuū yā, ni jeē cuajníñu ri nuū yā vēsú ɨɨn jniñu lúlí gá nájnūhun jeē quénehen ri ndijēn yā. ");
INSERT INTO mibNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Te sáha ya nájnūhun sáha tēe scánda trigo, chi sásɨ́ɨn ya ñayuu vāha jíín ñáyuu cunéé, nájnūhun cúndoo trigo jeē quénda sɨ́ɨn paja. Te nastútú yá trigo yā ndɨ̄vɨ ini yacā yā. Te paja chi jnaa yā nuū ñuhún jeē ma ndahvá cuɨtɨ. Achí Juan. ");
INSERT INTO mibNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yūcuán na te ni quenda Jesús región Galilea, te ni quee yā yūte Jordán nuū íne Juan, návāha scuándute de ya. ");
INSERT INTO mibNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Te tu ní cúní Juan scuándute de ya, chi ni cahān de jíín yá: Sa suhva cánuú jeē scuándute máá ní sāñá, ¿te ndese cúu jeē sa nuū ná vēji ní? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Te ni cahān Jesús jiín de: Tuú chi sáha ró, chi súcuan cánuú squícu yó táca jniñu ndácu Yaā Dios, achí yá. Yūcuán na te ni scuándute de ya. ");
INSERT INTO mibNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Te ná ni cuu ni jendute Jesús, te ni quenda ya nuū ndúte. Te ni nune‑ni andɨvɨ́, te ni jito ya jeē cúun Espíritu Yaā Dios vēji, te cáa nájnūhun ɨɨn paloma, te ni quee xinī yā. ");
INSERT INTO mibNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Te ichi ándɨvɨ́ ni cahān ɨɨn jnūhun: Yāha cúu Sēhe ri jeē maní ndasɨ́ rí jiín, te yōhyo cúsɨɨ̄ ni rī jiín, áchí. ");
INSERT INTO mibNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yūcuán na te ni jinū Jesús nde nuū ñúhun téhé ní sáha Espíritu Santo. Te yūcuán coto ndee jexeén yā, chi cúní jeē sáha ya cuēchi. ");
INSERT INTO mibNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Te ni īyo ndite ni yā uū xico nduú uū xico ñuú, sáá te jíí yā sōco. ");
INSERT INTO mibNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Te ni quee maá jéxeén jeē cóto ndee un yá, te ni cahān jiín yá: Núu máá ró cúu Sēhe Yaā Dios, te cahān rō jeē yuū yúcu yáha na ndúu staā caji rō, achí. ");
INSERT INTO mibNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Te ni cahān yā jiín: Tuú chi yósó núū tútu iī: Nasūu máni máá jíín stáā cátecu ñayuu, chi suni jíín táca jnúhun cáhán Yaā Dios, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yūcuán na te cuahān jexeén un jíín yá nde ñuu iī Jerusalén. Te ni jeni ya xinī torre templo. ");
INSERT INTO mibNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Te ni cahān jiín yá: Te núu Sēhe Yaā Dios cúu ró, te sɨ́ngava ró máá ró nde nuū ñúhun, chi jnama ya rohó. Chi yósó núū tútu: Tejníñu ya ndajéhé yā quijicoo coto róhó. Te cunundee yā rohó jíjnáhan ya, návāha ma cáchihi ró jéhē rō nuū yuú. Achí tutu. Achí jexeén. ");
INSERT INTO mibNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Te ni cahān Jesús: Tuú chi suni yósó núū tútu jeē ma cóto ndee ñayuu Jitoho i Yaā Dios, núu jnama ya i chí tuú, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Te jexeén un ní jeca tucu ya cuahān jiín yá nde xinī ɨɨn yucu súcún ndasɨ́. Te ni steén tācá nación nɨɨ́ cáhnu ñayɨ̄vɨ núū yā, te yōhyo luu cáa ndɨhɨ. ");
INSERT INTO mibNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Te ni cahān jiín yá: Tācá ñuu yáha cuáha ri nuū rō, te núu cuɨñɨ yɨ́tɨ́ ró chiñúhún ró ruhū, achí. ");
INSERT INTO mibNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yūcuán na te ni cahān Jesús nuū jexeén: Satanás, cujiyo quihīn rō, chi yósó núū tútu jeē chiñúhún ñayuu maá Jítoho i Yaā Dios, te nuū maá‑ni ya cuajníñu i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yūcuán na te ni cujiyo‑ni jexeén un cuáhān. Te ni quecoo ndajéhé Yaā Dios ni cajejníñu nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Te ná ni nihīn Jesús jnūhun jeē íne Juan vecāa, te cuanuhun yā región Galilea. ");
INSERT INTO mibNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Te tu ní cóndee yā ñuu Nazaret, chi ni jehēn yā ni condee yā ñuu Capernaum. Te ñuu un íne yumar, máá región Zabulón jiín Neftalí. ");
INSERT INTO mibNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Te súcuan ni squícu jnūhun ni tee Isaías, tēe ni nacani jnūhun Yaā Dios nde jenahán: ");
INSERT INTO mibNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Región Zabulón jiín Neftalí, ichi jeē yɨ́hɨ yumar, lado yūte Jordán nuū cáne niāndii, jíín región Galilea nuū cáyūcú ñayuu tācá nación tu jíní jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ñayuu ún chi nájnūhun cáyūcú i nuū néē, te coto i nájnūhun ɨɨn luz cáhnu. Te ñayuu je yajni naa, nihīn i jnūhun váha ndasɨ́, suu jnūhun jeē jnama ya anuá i. Achí Isaías. ");
INSERT INTO mibNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Te nde quɨvɨ̄ yúcuan ní quejéé Jesús nácani ya jnūhun, te ni cahān yā suhva: Nacani ni rō jijnáhan ró jéē stóo ró cuéchi ró, chi je ni cuyajni Yaā ndeé andɨvɨ́ jéē ndacu ya jniñu nuū rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Te jíca Jesús yumar Galilea cuahān yā. Te ni jito ya nuū uú jnáhan ñani. Te ɨɨn de cúu Simón jeē suni nání Pedro, te ɨnga de cúu Andrés. Te tēe cájnɨɨ chācá cácuu de, te cásɨ́nga de ñunu de ini mar. ");
INSERT INTO mibNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Te ni cahān yā jiín de: Condiquīn ruhū na quíhín yō, te nasáha ri rohó tée nihīn cuehē ñayuu candíje ruhū, nájnūhun cánihīn rō chācá, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yūcuán na te ni castóo‑ni de ñunu de, te ni candiquīn de ya. ");
INSERT INTO mibNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Te ni jica ya jecu gā, te ni jito ya nuū ɨnga uū jnáhan ñani. Te cácuu de Jacobo jiín Juan, sēhe Zebedeo. Te cáyūcú de ini barco jiín tátá de Zebedeo, cánachijnɨ̄ɨ de ñunu de. Te suni ni cana ya de jeē cóndiquīn de ya. ");
INSERT INTO mibNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Te ni castóo‑ni de tátá de jíín barco, te ni candiquīn de ya cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Te ni jica cuu Jesús nɨɨ́ región Galilea, ni steén yā jnūhun ini tācá vehe iī jeē cúu sinagoga. Te ni nacani ya jnūhun vāha ndese ndácu Yaā Dios jniñu. Te ni nasávāha ya ñayuu cácuhū tācá‑ni cuehyɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Te ni jitē núu jnūhun ya cuahān nɨɨ́ región Siria. Te nuū yā ni caquindeca i tāca ñáyuu cácuhū, ñayuu cándoho tɨjnɨ nuū cuehyɨ́, jiín jéē jetú, jíín jéē ñúhun tachī ini, jiín jéē jihí yɨ̄hɨ́, jíín jéē ni íjin. Te ni nasávāha ya i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Te cuehē ñayuu región Galilea jiín Decápolis, jiín ñáyuu ñuu Jerusalén jiín región Judea, jiín táca ñuu ichi núū cáne niāndii yūte Jordán, ni cacondiquīn i ya. ");
INSERT INTO mibNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Te ni jito Jesús nuū ñáyuu cuehē. Te ni caa ya yucu cuahān yā, te ni cucōo ya. Te tēe cáscuáha jíín yá, ni jinūcoo de nuū yā yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Te ni quejéé yá ni steén yā tāca jnúhun yáha nuū de: ");
INSERT INTO mibNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Yōhyo ndetū ñayuu jeē cánacuni i jeē tu íyó váha ánuá i sɨquɨ̄ cuéchi i, chi je ni quɨ̄vɨcoo i ndaha Yaā andɨvɨ́ jéē ndácu ya jniñu nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Yōhyo ndetū ñayuu cácucuíhyá ni, chi ndusɨɨ̄ ni i sáha Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Yōhyo ndetū ñayuu cáhīyo vītá suchí ini, chi ni jejnūhun ya jeē cutahū i ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Yōhyo ndetū ñayuu jeē nájnūhun jeē cájiī i sōco cájichī i, súcuan jnáā i sáha i jniñu ndaā, chi máá yá chindéé ñáhán yá i jeē cuu sáha i. ");
INSERT INTO mibNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Yōhyo ndetū ñayuu cácundáhú ni jnáhan, chi suni cundáhú ni Yaā Dios i. ");
INSERT INTO mibNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Yōhyo ndetū ñayuu cáhīyo ndoo ini anuá, chi coto i nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Yōhyo ndetū ñayuu cánasámanī jnáhan, chi cahān Yaā Dios jeē sēhe ya cácuu i. ");
INSERT INTO mibNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Yōhyo ndetū ñayuu jeē cájito xeēn ɨnga ñayuu i sɨquɨ̄ jeē casáha i jniñu ndaā, chi je ni quɨ̄vɨcoo i ndaha Yaā andɨvɨ́ jéē ndácu ya jniñu nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Yōhyo ndetū maá ró jijnáhan ró núu cácahān neé i nuū rō jeē sɨquɨ́ ruhū, te coto xeēn i róhó, te stáú yáhu i róhó, vēsú tú cuēchi ró. ");
INSERT INTO mibNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Na cúsɨɨ̄ ni rō jijnáhan ró núu súcuan, te sa víhyá gā cusɨɨ̄ ni rō, chi cáhnu ndasɨ́ coo tahū rō nde andɨvɨ́. Chi suni súcuan ni cajito xeēn i tāca tée ni canacani jnūhun Yaā Dios jeē ní quijicoo xīhna gā vēsú rohó. ");
INSERT INTO mibNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Máá ró jijnáhan ró cájejníñu ró ini ñayɨ̄vɨ nájnūhun jéjníñu ñɨɨ̄ nuū cúñu návāha tú tehyū. Te núu ñɨɨ̄ ún na náā jeē uhvuá, ¿te ndese nduu uhvuā tucu? Tuá cuajníñu cuɨtɨ gā, chi sa cate ñayuu te cueñū i sɨquɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Máá ró cácuu nájnūhun luz jeē steén ini anuá ñayuu ñayɨ̄vɨ́. Te cácuu ró nájnūhun ɨɨn ñuu íne xinī yúcu, jeē ma cúu quɨsāhí. ");
INSERT INTO mibNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Te ni tu nástɨ́ɨn ñayuu ɨɨn lámpara te chune i chīji cajón, chi sa suhva jéni i nuū sucún, návāha cundijin nuū tāca jéē cáyūcú ini vehe. ");
INSERT INTO mibNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Te suni súcuan na stéén rō luz maá ró nuū tāca ñáyuu, te suu cúu jeē cúni i jniñu váha cásáha ró, te cahān i jeē yóhyo vāha Yaā cúu Tátá rō jeē ndeé yá andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Ma cáni ni rō jijnáhan ró jéē véji ri snáā rī ley jeē ni jéhe Yaā Dios nuū Moisés, jiín jéē snáā rī tāca jnúhun ni cacahān tēe ni canacani jnūhun ya jenahán. Tú vēji ri jeē snáā rī, chi sa suhva jeē steén cají rí jnūhun ndíso. ");
INSERT INTO mibNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Chi jendaá cahán rī jiín ró jeē núu níní íyó andɨvɨ́ jíín ñáyɨ̄vɨ́, te ma náā cuɨtɨ ni ɨɨn punto ni ɨɨn letra nuū tútu ley yā, chi nde na squícu tācá ndɨhɨ jnūhun jeē cahán. ");
INSERT INTO mibNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Núu súcuan te núu ɨɨn ñayuu tu squícu i ɨɨn jnūhun yáha jéē ndácu ley yā, vēsú ɨɨn jnūhun lulí gá cúu, te núu stéén i jeē suni súcuan sáha sava ga ñayuu, núu súcuan te cuu i ñayuu núu ga ichi andɨvɨ́ nuū ndácu Yaā Dios jniñu. Te núu ɨɨn ñayuu squícu i te stéén i jeē squícu ñayuu, yūcuán na te cujéhnu i ichi andɨvɨ́ nuū ndácu Yaā Dios jniñu. ");
INSERT INTO mibNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chi cáhán rī jiín ró jeē núu tú coo ndaā gā jniñu cásáha ró vēsú jniñu cásáha tēe cástéén tutu ley yā jiín tée grupo fariseo, te ma quɨ́vɨcoo cuɨtɨ rō ndaha Yaā andɨvɨ́ jéē ndacu ya jniñu nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Je ni cajini ró jnúhun ni cacahān jiín ñáyuu jenahán, jeē ma cáhni i ndɨ̄yɨ, te na‑ni ñayuu núu cahni i ndɨ̄yɨ, te cundaā cuēchi i nuū tāca tóhō, achí. ");
INSERT INTO mibNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Te ruhū chi cáhán rī jiín ró, vēsú núu máá jéē quɨtɨ́ ni ɨɨn ñayuu jíto i jnáhan i, suni cundaā sɨquɨ̄ cuéchi i ún. Te núu ɨɨn ñayuu cahān neé i nuū jnáhan i, núu súcuan te cundaā cuēchi i un núū justicia cujéhnu ga. Te núu ɨɨn ñayuu cahān i nuū jnáhan i: Róhó jéē canéé íī, achi i, núu súcuan te quɨ̄vɨ i nuū ñuhún infierno te núu ma nácani ni i. ");
INSERT INTO mibNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Jeē yúcuan te núu ni jinū rō nuū altar jiín jéē socó rō nuū Yaā Dios, te núu ni nucūhun ni rō jeē ni sáha ró cuéchi sɨquɨ̄ jnáhan ró, ");
INSERT INTO mibNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","núu súcuan te squéndōo ró jéē socó rō ún xiin altar, te xīhna gā quihīn rō ndumanī rō jiín jnáhan ró. Yūcuán na te nandicó ró socō rō. ");
INSERT INTO mibNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Te núu ɨɨn ñayuu quihīn i jíín ró nuū tohó jeē cacān i cuēchi sɨquɨ̄ rō, núu súcuan te níní cuáhān rō jiín i ichi te sándaā maá ró jíín i, návāha ma squɨ́vɨ i róhó núū juez. Chi juez siáha de róhó núū policía, te chune de róhó vecāa. ");
INSERT INTO mibNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Te jendaá cahán rī jiín ró jeē ma quénda cuɨtɨ rō yūcuán, chi nde chunaa rō ndɨhɨ cuɨtɨ xūhun jéē cájicān de. ");
INSERT INTO mibNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ni cajini ró jnúhun ni cacahān jenahán jeē ma cósɨ́quɨ́ ndéē jnáhan ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Te ruhū chi cáhán rī jiín ró jeē núu ɨɨn tēe ndéhe de nuū ɨɨn ñahan jeē ndíyo ni de ña, yūcuán na te je ni casɨ́quɨ́ ndéē de ñahan ún ini anuá de. ");
INSERT INTO mibNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Núu súcuan te núu tɨnūu lado váha ró sáha jeē quɨ́vɨ ró cuéchi, vāha ga quenehen ró te scáne ró, návāha tuá sáha ró cuéchi. Chi vāha gā jeē náā ɨɨn tɨnūu ró vēsú jeē cóo ndɨhɨ yɨquɨ cúñu rō te quihīn rō infierno. ");
INSERT INTO mibNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te núu ndaha váha ró sáha jeē quɨ́vɨ ró cuéchi, vāha ga cahnde rō te scáne ró, návāha tuá sáha ró cuéchi. Chi vāha ga jeē náā ɨɨn ndaha ró vēsú jeē cóo ndɨhɨ yɨquɨ cúñu rō te quihīn rō infierno. ");
INSERT INTO mibNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Te suni ni cacahān nde jenahán: Núu ndé ɨɨn cúní stóo ñasɨhɨ́, te na cuáha acta nuū ña jeē ndusɨ́ɨn jíín ña. ");
INSERT INTO mibNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Te ruhū chi sa cáhán rī jiín ró jeē núu ɨɨn tēe stóo de ñasɨhɨ́ de, te núu nasūu jéē tɨ́jnɨ ni ña, núu súcuan te sáha de jeē casɨ́quɨ́ ndéē ña de, chi condee ña jíín ɨnga tēe. Te núu ɨɨn tēe condeca de ñahan ní ndusɨ́ɨn, suni cásɨ́quɨ́ ndéē de ña. ");
INSERT INTO mibNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Te suni ni cajini ró jnúhun jeē ni cáhān jiín ñáyuu nde jenahán: Núu ni jejnūhun téyɨ́ ró jeē squícu ró, jíto jínúū Yaā Dios, núu súcuan te cánuú squícu ró jéē ni cáhān teyɨ́ ró un, áchí. ");
INSERT INTO mibNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Te ruhū chi cáhán rī jiín ró jijnáhan ró jeē ní ɨɨn sɨquɨ̄ jníñu ma cahán teyɨ́ ró nde jiín sɨ́hvɨ́ Yaā Dios, ni ma cahán teyɨ́ ró jeē jíto jínúū yā. Te núu jéjnūhun téyɨ́ ró te tú vāha jeē ndácunehen ró andɨvɨ́ ni ñayɨ̄vɨ́. Chi andɨvɨ́ cúu nuū íin mesa nuū ndácu Yaā Dios jniñu. ");
INSERT INTO mibNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Te ñayɨ̄vɨ cúu nájnūhun teyū nuū íin jehē yā. Te ni ma ndácunehen ró ñuu Jerusalén, chi suu cúu ñuu maá Yáā cúu Rey cujéhnu. ");
INSERT INTO mibNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni ma cahán rō jeē na cóndee cuēchi sɨquɨ̄ rō núu tu squícu ró. Ma cahán rō súcuan, chi ma cúu cuɨtɨ sáha ró jéē ni ɨɨn ixi xíní rō nducuíjín chí ndujnúú. ");
INSERT INTO mibNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Chi suhva‑ni cahān rō: Cuu, achi rō. Tuú, achi rō. Chi núu chisóó gá rō jnūhun cahān rō, te nuū jexeén vēji. ");
INSERT INTO mibNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ni cajini ró jnúhun jeē ni cáhān jiín ñáyuu jenahán: Núu ɨɨn tēe ndahva de tɨnūu jnáhan de, suni súcuan na ndáhva tɨnūú de. Te núu ɨɨn tēe stáva de jnūhun jnáhan de, suni súcuan na stáva jnūhun de, áchí. ");
INSERT INTO mibNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Te ruhū chi sa cáhán rī jiín ró: Ma nácuāha ró jéē ndútahū tēe sáha ndevāha jíín ró. Chi sa núu ndé tée cani de yɨquɨ núú lado váha ró, te vāha ga suni cuāha ró ɨnga lado cani de, vēsú jeē nácuāha ró jéē ndútahū de. ");
INSERT INTO mibNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Te núu ndé tée stáú yáhu de róhó te quénde de camisa rō, suni cuāha ró jnúhun jeē na quíhín de jíín ndé tɨcāchi ró. ");
INSERT INTO mibNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Te núu ndé tée scáca de róhó jéē condiso ró ndajníñu de ɨɨn kilómetro, te caca ró úū kilómetro jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Te na‑ni ñayuu núu jícán i ndajníñu ró, te cuāha ró núū i. Te ñayuu jicán núu ndajníñu nuū rō, ma sasáhán ró cuāha ró núū i. ");
INSERT INTO mibNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Te suni ni cajini ró jnúhun jeē ni cáhān nde jenahán: Cundáhú ni rō ñayuu cáhīyo manī jiín ró, te coto uhū rō ñayuu cájito uhū rohó, áchí. ");
INSERT INTO mibNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Te ruhū chi sa cáhán rī jiín ró: Cundáhú ni rō ñayuu cájito uhū rohó. Te cacān rō jeē váha coo ñayuu cácahān ndevāha sɨquɨ̄ rō. Te sáha vāha ró jíín ñáyuu cáquɨtɨ̄ ni nuū rō. Te cacān tahú rō jehē ñáyuu cácahān neé núū rō te cájito xeēn i róhó. ");
INSERT INTO mibNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Te súcuan stéén rō jeē cácuu ró séhe máá Tátá rō, Yaā ndeé andɨvɨ́, chi máá yá jéhe niāndii cúndijin nuū ñáyuu cunéé jíín ñáyuu váha. Te jéhe ya saū nuū ñáyuu casáha jniñu ndaā jiín núū ñáyuu casáha jniñu néé. ");
INSERT INTO mibNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chi núu íyó mánī rō jiín máá‑ni ñayuu jeē maní jiín ró, te tú na tahū nihīn rō nuū yā. Chi nde tēe cástútú xúhun renta jeē castáhú, suni súcuan cásáha de. ");
INSERT INTO mibNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te núu máni jnáhan ró cáhán yɨñúhún ró jiín, ¿te na vé jeē váha ga sáha ró núu súcuan? Chi nde ñayuu tu cácandíje Yaā Dios, suni súcuan cásáha i. ");
INSERT INTO mibNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Núu súcuan te ndaā na cóo ndɨhɨ jeē sáha ró, nájnūhun íyó ndáā ndɨhɨ jeē sáha Tátá rō, Yaā ndeé andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Te jeē sáha ró táca jniñu váha nuū Yaā Dios, coto ró jéē ma sáha ró máá sɨ́quɨ̄ jeē cúni ñayuu te cuajnúhún i róhó. Chi núu súcuan sáha ró, te tú na tahū rō cuāha máá Tátá rō, Yaā ndeé andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jeē yúcuan te jeē sáha ró caridad, te ma sáha ró jéē cúni tāca ñáyuu, nájnūhun cásáha tēe stáhú‑ni, cáhīin de nuū cúchitú ñayuu ini tācá vehe iī sinagoga jiín núū yáhu. Chi súcuan cásáha de návāha cuajnúhún ñayuu de jeē váha cásáha de. Jendaá cahán rī jiín ró jeē tahū de cúu jeē jejnúhún ñayuu de. ");
INSERT INTO mibNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Te róhó jíjnáhan ró, núu cásáha ró caridad, te sáha yuhu rō, návāha nde amigo vāha ró tú cuni jeē sáha ró. ");
INSERT INTO mibNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Súcuan na sáha yuhu rō caridad. Te máá Tátá rō jeē jíto ya jeē sáha yuhu rō, ɨɨn quɨvɨ̄ te cuāha ya tahū cuu ró. ");
INSERT INTO mibNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Te jeē cájicān tahú rō, te ma sáha ró nájnūhun cásáha tēe stáhú‑ni. Chi cánujnahan ni de cuɨñɨ de cacān tahú de nuū iyó chitú ñayuu ini tācá vehe iī sinagoga jiín táca yɨ́quɨ yáhu, návāha cuni ñayuu te cuajnúhún i de. Jendaá cahán rī jiín ró jeē maá yúcuan‑ni cúu tahū jeē nihín de, suu jeē jejnúhún ñayuu de. ");
INSERT INTO mibNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Te róhó jíjnáhan ró, núu cájicān tahú rō, te ndɨ̄vɨ ró ini vehe ró te casɨ rō yehyɨ́. Te cacān tahú rō nuū maá Tátá rō, Yaā ndeé yuhu jiín ró. Yūcuán na te máá Tátá rō jeē jíto ya jeē súcuan sáha yuhu rō, sáha ya jeē jicán rō. ");
INSERT INTO mibNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Te jeē cájicān tahú rō, te ma cahán saá‑ni ró jnúhun jeē tu cájecūhun ni rō, nájnūhun cásáha ñayuu tu cájini jnūhun Yaā Dios. Chi cájeni ni i jeē núu cuehē jnūhun súcuan cahān i, te sáá te cuni sōho ya, te tuú. ");
INSERT INTO mibNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Núu súcuan te ma sáha ró nájnūhun cásáha máá i. Chi máá Tátá rō, je jíní yā na vé cájini ñúhún ró nde ná tu cacān rō nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Núu súcuan te suhva cacān tahú rō: Tátá maá ná jijnáhan ná jéē ndeé ní andɨvɨ́, níní na cóo yɨ́ñúhún ná nuū ní, chi Yaā iī cúu ní. ");
INSERT INTO mibNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Te ñúhun ni na jéē yachī quiji quɨvɨ̄ ndacu ní jniñu nɨ́ɨ́ ñáyɨ̄vɨ yáha. Te na cóo tācá jniñu nújnahan ni ní, nájnūhun íyó ini andɨvɨ́, súcuan na cóo ini ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Staā jeē cátecu na táca quɨ́vɨ̄, cuāha ní núū ná vijna. ");
INSERT INTO mibNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Te cone cahnu ni ni núū tāca cuéchi cásáha ná núū ní, nájnūhun cáhine cáhnu ni na núū ñáyuu casáha cuēchi nuū ná. ");
INSERT INTO mibNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Te ma cuáha ni jnúhun jeē coto ndee jexeén sāñá, chi sa suhva jnama ní sáña núū tāca jéē neé. Chi máá ní cúu Yaā ndácu jniñu, te jnɨ́ɨ ní poder, te yōhyo luu cújéhnu ní nɨ́ɨ́ cáni. Súcuan na cóo. Amén. Achi rō jijnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Chi núu cone cáhnu ni rō nuū ñáyuu casáha cuēchi nuū rō, te suni súcuan cone cáhnu ni maá Tátá rō andɨvɨ́ nuū cuéchi ró. ");
INSERT INTO mibNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Te núu ma cóne cáhnu ni rō nuū ñáyuu casáha cuēchi nuū rō, te suni súcuan ma cóne cáhnu ni maá Tátá rō nuū cuéchi ró jíjnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Te núu condite ni rō jeē chiñúhún ró Yaā Dios, te ma sáha ró nájnūhun cásáha tēe stáhú‑ni. Chi cásáha de jeē coto xií de, te súcuan stéén de nuū ñayuu jeē iyó ndite ni de, návāha cuajnúhún i de. Jendaá cahán rī jiín ró jeē maá yúcuan‑ni cúu tahū jeē nihín de, suu jeē jejnúhún ñayuu de. ");
INSERT INTO mibNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Te máá ró jijnáhan ró, núu íyó ndite ni rō, te sa chuhun vāha ró xínī rō te nandahá núū rō, ");
INSERT INTO mibNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","návāha ma cúni ñayuu jeē iyó ndite ni rō. Chi máá‑ni Tátá rō jeē ndeé yuhu yā jiín ró, cuni yā, te ɨɨn quɨvɨ̄ te cuāha ya tahū cuu ró. ");
INSERT INTO mibNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ma cóndɨhvɨ̄ ni rō caya rō ndajníñu cúcá ini ñayɨ̄vɨ yáha, chi quɨ́vɨ tiquíxin, te cáne xehyu, te tɨ́vɨ. Te suni quɨ́vɨcoo ñacuīhná te sácuíhná. ");
INSERT INTO mibNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Chi sa suhva sáha ró táca jniñu váha návāha cayā tahū rō nde andɨvɨ́. Chi yūcuan má quɨ́vɨ tiquíxin ni ma cáne xehyu jeē tɨ́vɨ. Ni ma cúu quɨ̄vɨ ñacuīhna sácuíhná. ");
INSERT INTO mibNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Chi nde nuū nihín rō tahū váha ró, yūcuan cúu nuū cóndɨhvɨ̄ ni rō sɨquɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Tɨnūu ró cúu nájnūhun lámpara nuū yɨquɨ cúñu rō. Núu súcuan te núu tɨnūu ró íyó ndijin, te nɨ́ɨ́‑ni yɨquɨ cúñu rō cúndijin. ");
INSERT INTO mibNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Te núu tɨnūu ró tu íyó ndijin, te nɨ́ɨ́‑ni yɨquɨ cúñu rō iyó nee. Te suni súcuan cúu ánuá rō, chi núu máni jeē jéni néé ni rō, te nacā jeē nee gā iyó ini anuá rō núu súcuan. ");
INSERT INTO mibNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ni ɨɨn mozo ma cúu cuajníñu de nuū uū patrón. Chi quɨtɨ̄ ni de nuū ɨɨn te coo manī de jíín ɨnga, chí squícu vāha de nuū ɨɨn te sájéē ni de nuū ɨnga. Te suni súcuan ma cúu cuajníñu ró núū Yaā Dios te núu máni sɨquɨ̄ xúhun ndɨ́hvɨ́ ni rō. ");
INSERT INTO mibNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Núu súcuan te cáhán rī jiín ró jijnáhan ró: Ma nácani ndasɨ́ ni rō sɨquɨ̄ jeē cótecu rō, núu ndese caji rō coho ró, ni sɨquɨ̄ sahma, núu ndese cuhun ró. Chi Yaā Dios ni sáha ya jeē técu rō jiín yɨquɨ cúñu rō, te nagā ni cuu jeē ma cuáha ya jeē cáji rō jiín jéē cúhun ró. ");
INSERT INTO mibNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Condēhe ró ndese cátecu saa, chi tu cátaji tɨ, ni tu cánastútú tɨ́ jeē chúvāha tɨ, ni tú yacā tɨ̄. Te vēsú súcuan te máá Tátá rō andɨvɨ́ scáji yā tɨ̄. Te cánuú ndasɨ́ gá rō jijnáhan ró vēsú tācá saa ún. ");
INSERT INTO mibNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Te ndé ɨɨn ró, á cuu scuéhnu ró máá ró sava metro gā, vēsú na nácani ndasɨ́ ni rō? ");
INSERT INTO mibNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Te najehē cánacani ndasɨ́ ni rō jeē ma nihín rō sahma? Condēhe jíjnáhan ró ndese jée ita tāca yúcū. Chi tu sájniñu, ni tu táú. ");
INSERT INTO mibNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Te cáhán rī jiín ró jeē ni rey Salomón, quɨvɨ̄ ní ñúhun de sahma váha ndasɨ́, tu ní ñúhun de sahma lúu súcuan nájnūhun ita ún. ");
INSERT INTO mibNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Te núu súcuan jéhe Yaā Dios sahma lúu ita un jéē jée vijna te sajnē cayū nuū ñuhún, te nagā ni cuu róhó jíjnáhan ró jéē ma sáha ya jeē nihín rō sahma. ¿Te naun tu cácandíje nīhin ró jéē ndíto ya rohó? ");
INSERT INTO mibNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Núu súcuan te ma nácani ndasɨ́ ni rō sɨquɨ̄ jeē cáji rō, jeē coho ró, jeē cuhun ró. ");
INSERT INTO mibNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Chi tāca ñáyuu ñayɨ̄vɨ jéē tu cácandíje cúu jeē máni sɨquɨ̄ jeē yáha cándɨhvɨ̄ ni i. Te máá ró jijnáhan ró, chi íyó Tátá rō andɨvɨ́, te jíní yā jeē cájini ñúhún ró tāca jéē yáha. ");
INSERT INTO mibNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Te sa suhva cánuú gá jeē cóndɨhvɨ̄ ni rō sɨquɨ̄ jniñu jeē ndácu Yaā Dios nuū rō, jiín sɨ́quɨ̄ jeē sáha ró jniñu ndaā jeē nújnahan ni yā. Yūcuán na te sáha ya jeē nihín rō tāca jéē yáha. ");
INSERT INTO mibNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Núu súcuan te ma nácani ni rō sɨquɨ̄ jeē cóo sajnē, chi vijna cúu vijna te sajnē cúu sajnē. Chi cani ni rō sɨquɨ̄ jnúndóho jeē iyó ná ɨɨn ná ɨɨn‑ni quɨvɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Ma cahán rō sɨquɨ̄ ñayuu ndese sáha i, návāha suni ma cahán Yaā Dios cuēchi sɨquɨ̄ maá ró jeē casáha ró súcuan. ");
INSERT INTO mibNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chi nájnūhun cácahān rō sɨquɨ̄ cuéchi ñayuu, suni súcuan cahān yā sɨquɨ̄ cuéchi ró. Te cūhva jeē cándɨhvɨ̄ ni rō sɨquɨ̄ i, suni cūhva yúcuan sáha ya jiín ró. ");
INSERT INTO mibNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Chi cuēchi jnáhan ró cúu nájnūhun jeē íne ɨɨn yāca lúlí tɨnūú i. ¿Te naun cásáha ró cuenta jeē súcuan, te tu cásáha ró cuenta cuēchi máá ró jeē cúu nájnūhun jeē íne ɨɨn nduhu tɨnūu máá ró? ");
INSERT INTO mibNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Te naun cácahān rō jiín jnáhan ró: Na táva rī yāca íne tɨnūu ró, te tu cánacani ni rō jeē íne ɨɨn nduhu tɨnūu máá ró? ");
INSERT INTO mibNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tēe stáhú‑ni cácuu ró núu súcuan. Xīhna gā tɨnūu máá ró tava rō nduhu, te yūcuán na te cuu condēhe váha ró jéē táva rō yāca tɨ́nūu jnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ma sáha fuerza rō ñayuu cunéé quɨ́vɨcoo i nuū jnúhun iī yā núu tu cúní i. Chi ndonda i sɨquɨ̄ rō nájnūhun ina jeē cáyɨ̄hɨ tɨ́ rohó. Te ma nácani ró jnúhun ya nuū ñáyuu jeē tu cúní cuɨtɨ cuajnúhún. Chi cándāa i nájnūhun quɨnɨ̄ jeē jeñú tɨ̄ sɨquɨ̄ perla jeē ndeé yahu ga. ");
INSERT INTO mibNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Cacān rō nuū Yaā Dios, te cuāha ya nuū rō. Te nducú ró tāca jéē váha íyó núū yā, te nihīn rō sáha ya. Te cacān tahú rō nde nihīn rō, nájnūhun sáha ñayuu cahán yehyɨ́ ndé nune quɨ̄vɨ i. ");
INSERT INTO mibNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chi tāca ñáyuu jicán, cuāha ya nuū i. Te ñayuu nducú, suni nihīn i. Te ñayuu cahán, nune ya ichi nihīn i jeē cuní i. ");
INSERT INTO mibNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Te ndé ɨɨn róhó núu sēhe ró jícán i staā nuū rō, te á cuáha ró ɨɨn yuū nuū i? ");
INSERT INTO mibNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Te núu jícán i ɨɨn chācá, te á cuáha ró ɨɨn coō nuū i? Tú cuɨtɨ súcuan. ");
INSERT INTO mibNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Núu súcuan te máá ró jijnáhan ró, vēsú ñayuu iyó cuéchi cácuu ró, te cájini rō cuāha ró jéē váha nuū séhe ró. Te nagā ni cuu máá Tátá rō andɨvɨ́ jéē ma cuáha ya jeē váha nuū ñáyuu jicán nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Te nájnūhun cúní rō jeē sáha vāha ñayuu jiín ró, suni súcuan na sáha vāha ró jíín i. Chi tutu ley Moisés súcuan ndácu jniñu, jíín táca tutu tēe ni canacani jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Condɨhvɨ̄ ni rō quɨ̄vɨcoo ró ndaha Yaā Dios. Chi cúu nájnūhun ɨɨn yéhyɨ́ túū. Chi yéhyɨ́ jíín ichi jeē cuahán nuū jnahnú ndetū ñayuu, jíté te cáhnu, te cuehē i quɨ́vɨcoo yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Te yéhyɨ́ jíín ichi jeē cuahán nuū nihín tahú i cotecu i, chi tuū yehyɨ́ te cuɨ́ñɨ ichi, te jecu‑ni i cánihīn i. ");
INSERT INTO mibNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Te ma cándíje cuɨtɨ rō tēe stáhú jéē cácahān de jeē jnúhun Yaā Dios cánacani de. Chi nájnūhun lanchi, quɨtɨ tú xeēn, súcuan cásáha de vējicoo de nuū rō. Te ini anuá de chi cácuu de nájnūhun yɨhɨ̄, quɨtɨ xéén. ");
INSERT INTO mibNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jíín jniñu cásáha de te nacuni rō de ndese tēe cácuu de. Chi cúu nájnūhun jeē tu scóyo ró ndehē uva xinī íñu, ni tu scóyo ró higo xinī iñu yóquin. ");
INSERT INTO mibNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Te tācá yujnu váha chi jéhe ndehē váha, te yujnu néé chi cúun ndehē neé. ");
INSERT INTO mibNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ɨɨn yujnu váha ma cúun ndehē neé, te ni ɨɨn yujnu néé ma cuáha ndehē váha. ");
INSERT INTO mibNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Te tācá yujnu jeē tu jēhe ndehē váha, chi tahndē te cayū nuū ñuhún. ");
INSERT INTO mibNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Te suni súcuan cácuu tēe ún, chi jíín jniñu cásáha de te nácuni rō ndese tēe cácuu de. ");
INSERT INTO mibNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Nasūú ndɨhɨ ñayuu jeē cahán i Jitoho i ruhū cúu jeē quɨ̄vɨcoo nuū ndácu Tátá rī jniñu nde andɨvɨ́. Chi quɨ̄vɨcoo máá nene ñayuu jeē squícu jniñu cúní Tatá rī andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Te quɨvɨ̄ jeē sándaā rī jniñu ñayuu, te cuehē i cahān jiín rí: Jitoho na jíjnáhan ná, ni canacani ná jnúhun jíín sɨ́hvɨ́ ní, te ni caquenehen ná táchī jiín sɨ́hvɨ́ ní, te ni casáha ná cuéhē jniñu jéhnu jíín sɨ́hvɨ́ ní jeē náā ni ñayuu sáha. Achi i. ");
INSERT INTO mibNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yūcuán na te cahān rī jiín ñáyuu ún: Tu jíní cuɨtɨ rī rohó. Cujiyo quingoo ró, chi ñayuu casáha jniñu néé cácuu ró, achi rī. ");
INSERT INTO mibNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Núu súcuan te tāca ñáyuu jeē cájini sōho jnūhun cáhán rī te squícu i, cácuu i nájnūhun ɨɨn tēe ni nacani vāha ni, te ni jeni de vehe de sɨquɨ̄ cáva. ");
INSERT INTO mibNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Te ni cuun saū, te ni ndaa yūte, te ni quee tachī xeén, te ni cachundahá vehe ún. Te tu ní cótúú, chi sɨquɨ̄ cáva ndéé. ");
INSERT INTO mibNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Te tāca ñáyuu jeē cájini sōho jnūhun cáhán rī te tu squícu i, cácuu i nájnūhun ɨɨn tēe cánéé jeē ní jeni de vehe de nuū ñɨ́tɨ. ");
INSERT INTO mibNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Te ni cuun saū, te ni quiji ndute ñúhún cuéhē, te ni quee tachī xeén, te ni cachundahá vehe ún. Te ni cotúú‑ni, te ni naa iī‑ni. Achí yá jiín i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Te ná ni jīnu ni cahān Jesús tāca jnúhun yáha, te ñayuu cuehē un ní canaa ni i ni cajini i jnūhun ni steén yā. ");
INSERT INTO mibNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Chi ni steén vāha ya nuū i, chi máá yá cúu jeē ndíso jníñu sɨquɨ̄ ndɨhɨ. Te tēe cástéén tutu ley Yaā Dios, tu súcuan cástéén de. ");
INSERT INTO mibNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Te ni nanuu Jesús yucu ún, te cuehē ñayuu cándiquīn i ya. ");
INSERT INTO mibNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Te ɨɨn tēe ndóho cuehyɨ̄ stehyú, ni quee de nuū yā. Te ni jecuɨñɨ̄ yɨtɨ́ de nuū yā, te ni cahān de jíín yá: Jíní na jéē cuu sáha ní jéē nduvāha ná, te núu cúní ni, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Te Jesús ni soó yá ndaha ya sɨquɨ̄ de, te ni cahān yā: Cúní rī. Te na ndúvāha ró, áchí yá. Te ná ni cahān yā súcuan, te ni nduvāha‑ni tēe ndóho cuehyɨ̄ stehyú un. ");
INSERT INTO mibNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yūcuán na te ni cahān Jesús jiín de: Ma cáchi cuɨtɨ rō nuū ní ɨɨn. Chi quisteén rō maá ró nuū sutú, te condahá ró jeē socó rō nuū Yaā Dios, nájnūhun ni ndacu Moisés jniñu jenahán, návāha cuni ñayuu jeē ní nduvāha ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Te ni quɨ̄vɨ Jesús ñuu Capernaum. Te ɨɨn tēe nación Roma jeē cúu capitán, ni quee de nuū yā, te ni cahān ndahú de jíín yá: ");
INSERT INTO mibNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Mozo na cátú i vehe ná, chi ni ījin i te ndóho xeēn i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Te ni cahān Jesús: Quihīn rī nasávāha ri i núu súcuan, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Te ni cahān capitán jiín yá: Tu cújéhnu ná jéē quihín ni quɨ́vɨ ní vehe ná. Chi máá jéē cahán‑ni ní, te na ndúvāha‑ni mozo na. ");
INSERT INTO mibNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Chi máá ná suni ndíso jníñu ná ní casáha tēe cácujéhnu ga. Te cújéhnu ná núū tācá soldado na. Te núu cáhán na jíín ɨɨn de jeē na quíhín de, te cuahān de. Te núu cáhán na jíín ɨnga de jeē na quíji de, te quíji de. Te núu ndácu ná ɨɨn jniñu nuū mozo na, te sáha i. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Te jeē ní jini Jesús jnūhun yáha, te ni naa ni yā. Te ni cahān yā jiín ñáyuu cándiquīn yā ún: Jendaá cahán rī jiín ró jeē ni nación yō Israel tu ní níhín rī ni ɨɨn ñayuu candíje nīhin súcuan, nájnūhun cándíje tēe yáha, vēsú tēe nación tu jíní jnūhun Yaā Dios cúu de. ");
INSERT INTO mibNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Te cáhán rī jiín ró jeē quíjicoo cuehē ñayuu ichi núū cáne niāndii jíín ichi núū quée niāndii. Te cucōo i caji i staā jiín Abraham jiín Isaac jiín Jacob nuū ndácu Yaā Dios jniñu nde andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Te sava ñayuu nación Israel jeē maá i quɨ̄vɨcoo núú, te sa quenehen ya i quihīn i nuū néē, chi tu ní cácandíje i. Te yūcuan ndáhyū i te nacayɨ̄hɨ́ yuhu i jeē ndoho xeēn i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yūcuán na te ni cahān yā jiín tée cúu capitán: Cuánuhun vehe ró, chi sáha ri nájnūhun cándíje ró jéē sáha ri. Te mozo de un ní nduvāha‑ni i máá hora un. ");
INSERT INTO mibNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Te ni jehēn Jesús vehe Pedro. Te ni jito ya naná chīsó de jeē catú ña yɨ́hɨ quīji ña. ");
INSERT INTO mibNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Te ni jnɨɨ ya ndaha ña, te ni quenda‑ni quīji ún ña. Te ni ndocuɨñɨ̄ ña, te ni sáha ña jeē ní cayeji de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Te jeē ní cuaa ni quecoo ñayuu jiín cuéhē ñayuu jeē ñúhun tachī ini i. Te ni quenehen ya tachī un cuángoo jíín jnúhun cáhán‑ni ya. Te suni ni nasávāha ya tāca ñáyuu cácuhū. ");
INSERT INTO mibNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Te súcuan ni cuu návāha cundaā jnūhun ni cahān Isaías, tēe ni nacani jnūhun Yaā Dios jenahán: Máá yá ni tejiyo ndɨnuū cuehyɨ̄ cándoho yó, áchí Isaías. ");
INSERT INTO mibNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Te ni jito Jesús jeē ní ndicó ndúū cuehē ñayuu yā. Te ni cahān yā jiín tée cáscuáha jíín yá jeē na yáha de jíín yá ɨnga lado mar. ");
INSERT INTO mibNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Te ɨɨn tēe stéén tutu ley Yaā Dios, ni quee de nuū yā, te ni cahān de: Maestro, condiquīn na níhín quíhīn yō ndé‑ni cúu‑ni nuū quihín ni, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Te ni cahān Jesús jiín de: Tāca ñúcuii, íyó yáū cava cáñuhun tɨ. Te suni saa, iyó tácā tɨ̄. Te ruhū, Yaā ní nduu tēe, tuú nuū cusú rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Te ɨnga tēe ni cahān de jíín yá, te tēe scuáha jíín yá cúu de: Condetu ní ndé na quíchindūji ná tátá na xíhna gā. Yūcuán na te condiquīn na níhín, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Te ni cahān Jesús jiín de: Condiquīn ruhū na quíhín yō. Te stóo tāca ndɨ́yɨ na chíndūji jnáhan ndɨ̄yɨ, chi ndɨ̄yɨ cácuu ñayuu tu cácandíje. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yūcuán na te ni quɨ̄vɨ Jesús ini barco, te tēe cáscuáha jíín yá ni quɨ̄vɨcoo de cuahān de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Te nuū mar ni jequɨ̄hɨ ɨɨn tachī níhin, te ni stónda ndute mar, ni quɨ̄vɨ ini barco un. Te Jesús chi quíxí yā. ");
INSERT INTO mibNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Te tēe cáscuáha jíín yá ni castónda de ya, te ni cacahān de: Jnama ní yóhó, chi je quée yó chíji ndute, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Te ni cahān yā jiín de: ¿Naun cáyūhú ndasɨ́ ró? Te tu cácandíje nīhin ró jéē cácu ró sáha ri, achí yá. Yūcuán na te ni ndocuɨñɨ̄ yā, te ni cahān yā nuū tachí níhin un jíín núū mar. Te ni cuu nayúú íī‑ni. ");
INSERT INTO mibNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Te ni canaa ni de jíjnáhan de, te ni cacahān de: ¿Ndé ɨɨn ga cúu tēe yáha, jéē ndé tachī níhin jíín mar cájetáhú jéē cahán de? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Te ni jinū yā ɨnga lado mar, máá región ñayuu Gadara. Te uū tēe ni quendacoo de nde nuū yíndūji ndɨ̄yɨ, ni quijnahan de ya. Te cáñuhun tachī ini de, te sɨquɨ̄ jeē yóhyo xeēn tachī ún, te ni ɨɨn ñayuu tu cúu yāha i ichi yúcuan. ");
INSERT INTO mibNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Te ni cacana cóhó de ni casáha tachī: ¿Naun vēji ní núū ná, Jesús Sēhe Yaā Dios? ¿A véji ní yáha jeē stóho ní sáña ndé ná tu quee maá quɨ́vɨ̄? áchí. ");
INSERT INTO mibNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Te nde jicá jecu cáhīin cuehē quɨnɨ̄ cájitu tɨ. ");
INSERT INTO mibNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Te tachī jeē cáñuhun ini tēe un ní cacahān ndahú jíín yá: Núu quenehen ní sáña, te cuāha ni jnúhun na quɨ́vɨcoo ná ini quɨnɨ̄ cáhīin yūcuán, áchí. ");
INSERT INTO mibNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Te ni cahān yā jiín: Cuángoo núu súcuan. Te ni quendacoo tachī ún ini tēe ún, te ni quɨ̄vɨcoo ini quɨnɨ̄. Te quɨnɨ̄ un ní cajinu tɨ ni canɨngava tɨ ɨɨn yucáva, te ni ndaquɨ̄hɨ tɨ ndute mar, ni cajihī tɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Te tēe cándito tɨ ni cajinu de cuangoo de jeē ní cayūhú de. Te ni najinūcoo de ñuu. Te ni cacastūhún de tācá jniñu yúcuan, jíín ndese ni cuu jeē ní quendacoo tachī ini ndɨndúú tée ún. ");
INSERT INTO mibNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yūcuán na te ndɨvii ñayuu ñuu un, ní quendacoo i cuacondēhé i Jesús. Te ná ni jinūcoo i nuū íne ya, te ni cacahān ndahú i jíín yá jeē na quénda ya región yúcuan quíhīn yā. ");
INSERT INTO mibNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yūcuán na te ni ndɨ̄vɨ Jesús ini barco. Te ni nayāha ya cuahān yā ɨnga lado mar, te ni najinū yā ñuu maá yá. ");
INSERT INTO mibNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Te ni caquindeca ñayuu ɨɨn tēe ndóho cuehyɨ̄ ni íjin, cátú de nuū ɨɨn camilla. Te ni jini Jesús jeē cácandíje i jeē cúu nasávāha ya tēe ní íjin ún. Te ni cahān yā jiín de: Na ndúndeyɨ́ ni rō séhē, chi je íne cáhnu ni rī nuū tāca cuéchi ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yūcuán na te jecu tēe cástéén tutu ley Yaā Dios, ni cajeni ni de sɨquɨ̄ yā: Jeē cahán tēe yáha súcuan, chi cáhán de jnūhun ndevāha jeē quɨtɨ́ ni Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Te ni jini Jesús jeē súcuan cájeni ni de, te ni cahān yā jiín de: ¿Naun cájeni ni rō jeē cahán ndevāha ri? ");
INSERT INTO mibNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Jeē uú jnūhun yáha, ¿ndé ɨɨn yɨɨ́ gá cáa? ¿A jéē cahán rī jiín tée cúhú: Je íne cáhnu ni rī nuū tāca cuéchi ró? ¿Chí yɨɨ́ gá jeē cahān rī: Ndocuɨñɨ̄ te caca ró, chi je ni nduvāha ró, achi rī? ");
INSERT INTO mibNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Te vijna te na stéén rī jeē maá rí, Yaā ní nduu tēe, ndíso jníñu ri ini ñayɨ̄vɨ yáha jéē cóne cáhnu ni rī nuū cuéchi. Yūcuán na te ni cahān yā jiín tée ni íjin ún: Ndocuɨñɨ̄ te naquihin ró camilla rō te quinuhun rō vehe ró, áchí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yūcuán na te ni ndocuɨñɨ̄‑ni tēe ún, te cuanuhun de vehe de. ");
INSERT INTO mibNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Te ná ni cajito ñayuu un jéē súcuan ni sáha ya, te ni cayūhú i. Te ni cacahān i jeē yóhyo vāha Yaā cúu Yaā Dios jeē súcuan ni jēhe ya poder nuū ɨɨn tēe jeē cúu nasávāha de ñayuu, achí i cájito i Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Te ni quenda Jesús yūcuan cuáhān yā. Te ni jito ya nuū ɨɨn tēe nání Mateo, néne de nuū cutútú xúhun renta. Te ni cahān yā jiín de: Condiquīn ruhū na quíhín yō. Te ni ndocuɨñɨ̄ de, te cuahān de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yūcuán na te ni jehēn yā ni yeji yā staā vehe de. Te cuehē tēe cástútú xúhun renta jiín ɨnga tēe cásáha cuēchi, suni cáyūcú de cáyeji de staā jiín Jesús jiín tée cáscuáha jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Te tēe grupo fariseo, ni cajito de, te ni cacahān de jíín tée cáscuáha jíín yá: ¿Naun yéji maestro rō jiín tée cástútú xúhun renta jiín ɨnga tēe cásáha cuēchi? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Te ni jini Jesús, te ni cahān yatá yá jiín de: Ñayuu cáhīyo vāha, tu jíni ñúhún i tēe tájná, chi ñayuu cácuhū cúu jeē jíni ñúhún. ");
INSERT INTO mibNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cuáhán jíjnáhan ró núu súcuan, te nacani ni rō na vé cúu jeē cahán jnūhun yáha jéē yosó núū tútu iī: Cúní rī jeē na cúndáhú ni rō jnáhan ró, nasūu jéē socó rō quɨtɨ nuū rī, achí Yaā Dios nde jenahán. Te ruhū nasūu jéē véji ri cana ri ñayuu tú cuēchi, jeē cúu i nájnūhun ñayuu cáhīyo vāha, chi sa suhva vēji ri cana ri ñayuu iyó cuéchi, jeē na nácani ni i te stóo i cuēchi i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yūcuán na te tēe cáscuáha jíín Juan tēe scuándute, ni quecoo de nuū Jesús. Te ni cacahān de jíín yá: Sāña jíín tée grupo fariseo, tɨjnɨ jínu cáhīyo ndite ni na núū Yaā Dios. Te tēe cáscuáha jíín máá ní, ¿naun tu cásáha de súcuan? ");
INSERT INTO mibNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Te ni cahān Jesús jiín de: ¿A cuu condite ni de níní jéē iyó rí jiín de? ¿A cuu cucuíhyá ni ñayuu cáhīin vico nándāha, te núu níní néne tēe nándāha? Te quee quɨvɨ̄ jeē cújiyo tēe nándāha, te quɨvɨ̄ ún chi condite ni i. ");
INSERT INTO mibNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Te ni cahān yā uū jnūhun yátá sɨ́quɨ̄ jeē tu quíjnáhan jnūhun jeé jéē steén yā jiín táca jnúhun jenahán. Achí yá: Ni ɨɨn tu náchuhun ɨɨn pedazo sahma jéé núū ɨɨn sahma túhú. Chi núu súcuan te ndɨyɨ pedazo jeé un, te tahndē gā jeē tuhú un, te nducáhnu ga nuū catáhndé un. ");
INSERT INTO mibNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Te suni tu cáchuhun vino jeé ini ñɨɨ túhú. Chi núu súcuan te ndatā ñɨɨ ún, te naa vino jiín ñɨɨ. Chi cánuú jéē chúhun i vino jeé ini ñɨɨ jéé, te súcuan te quéndōo vāha ndɨndúú. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Te níní cáhán Jesús tāca jnúhun yáha, te ɨɨn tēe cújéhnu nuū ñáyuu hebreo, ni quee de nuū yā. Te ni jecuɨñɨ̄ yɨtɨ́ de nuū yā, te ni cahān de: Sēhe sɨ́hɨ́ ná sá ní jihī i. Te núu na quíhín yō soó ní ndaha ní sɨ́quɨ̄ i, te natecu i. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Te ni ndocuɨñɨ̄ Jesús, te cuahān yā jiín de, te suni cuangoo tēe cáscuáha jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Te mēhñu ñáyuu cuangoo jíín yá ni quee ɨɨn ñahan, te je ni cuu uxī uū cuiyā ndóho ña cuehyɨ̄ nɨñɨ̄. Te ni quee ña ichi yátá yā, te ni quehé ña yusáhma ya. ");
INSERT INTO mibNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Chi ni jeni ni ña: Vēsú maá sahma ya na níhín rī quehé rí, te nduvāha ri, jéni ni ña. ");
INSERT INTO mibNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Te ni ndió cóto Jesús, te ni jito ya nuū ña, te ni cahān yā: Na ndúndeyɨ́ ni rō, séhē. Ni candíje ró jéē cuu nasávāha ri rohó, te jeē yúcuan ní nduvāha ró, áchí yá. Te ni nduvāha ña máá hora un. ");
INSERT INTO mibNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Te ná ni jinū Jesús vehe tēe cújéhnu ún, te ni jito ya nuū tée cácuu músico jeē quíchindūji de i, jíín núū ñáyuu cuehē, cásávaā i. ");
INSERT INTO mibNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Te ni cahān yā jiín i: Cujiyo jíjnáhan ró, chi sūchi sɨ́hɨ́ yáha, tu ní jíhí i chi quíxí‑ni i, áchí yá. Te ni cajecū catá i jeē ni cáhān yā. ");
INSERT INTO mibNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Te ni quenehen ya ñayuu cuehē ún, te ni quɨ̄vɨ ya ini vehe. Te ni jnɨɨ ya ndaha sūchi sɨ́hɨ́ ní jihī ún, te ni ndocuɨñɨ̄‑ni i. ");
INSERT INTO mibNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Te nɨ́ɨ́ región yūcuan ní jitē núu jnūhun jniñu jéhnu ní sáha ya ún. ");
INSERT INTO mibNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Te ni quenda Jesús yūcuan cuáhān yā. Te uū tēe cuáá cuángoo de yatā yā, cácana jee de: Máá ní jeē cúu ní Sēhe yucūn David, cundáhú ni ni sáña víī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Te ná ni jinū yā vehe, te ni jinūcoo tēe cuáá un núū yā. Te ni cahān yā jiín de: ¿A cácandíje ró jéē cúu nanune ri tɨnūu ró? achí yá. Te ni cacahān de: Cácandíje ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yūcuán na te ni tee ya ndaha ya tɨnūú de, te ni cahān yā: Na sáha ri nájnūhun cácandíje ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Te ni cananune‑ni tɨnūú de. Te Jesús ni cahān nīhin ya jiín de: Ma cáchi cuɨtɨ rō nuū ni ɨɨn, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Te máá de chi ni quendacoo de, te ni cajete‑ni de jnūhun nɨ́ɨ́ región yūcuan jéē súcuan ni sáha ya jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Te nuū ní quendacoo tēe un cuángoo de, te ni quecoo ñayuu jiín ɨɨn tēe ñɨ́hɨ́n, jeē ñúhun tachī ini de. ");
INSERT INTO mibNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Te ni quenehen ya tachī un cuáhān. Te tēe ñɨ́hɨ́n un ní nacahān de. Te ni canaa ni ñayuu ni cajito i, te ni cacahān i: Ná tu cuni cuɨtɨ yō ni ɨɨn jniñu súcuan ini ñuu Israel, achí i. ");
INSERT INTO mibNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Te tēe grupo fariseo chi ni cacahān de: Tēe yáha chi quénehen de tachī jiín fuerza maá jexeén jeē cujéhnu nuū tachī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Te ni jica cuu Jesús tācá ñuu jiín rancho, te ni steén yā jnūhun ini tācá vehe iī sinagoga. Te ni nacani ya jnūhun vāha ndese ndácu Yaā Dios jniñu. Te ni nasávāha ya ñayuu cácuhū na‑ni cuehyɨ̄ cándoho i. ");
INSERT INTO mibNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Te cúndáhú ni yā jíto ya nuū ñáyuu cuehē ún. Chi cándoho i te cácucuíhyá ni i, chi cácuu i nájnūhun lanchi jeē tú jitoho tɨ̄, chi tu ndíquín i Yaā cúu Jitoho i. ");
INSERT INTO mibNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yūcuán na te ni cahān yā jiín tée cáscuáha jíín yá: Ñayuu yáha cácuu i nájnūhun trigo jeē tahndé, te ndaā jeē cuehē cúu, te tēe cahnde chi jecu‑ni de cúu. ");
INSERT INTO mibNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Núu súcuan te cacān tahú rō nuū maá Jítoho rō Yaā Dios jeē na tájí yá cuehē tēe na quíngoo de cahnde de trigo, cúu jeē nácani de jnūhun ya nuū ñáyuu. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yūcuán na te ni cana ya uxī uū tēe jeē scuáha de jíín yá. Te ni jēhe ya poder nuū de jeē quenehen de tachī ini ñayuu, jiín jéē nasávāha de ñayuu cácuhū tācá ndɨnuū cuehyɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Te yāha cúu sɨ́hvɨ́ ndɨhúxí uū tēe apóstol un: Tēe ɨɨn cúu Simón jeē suni nání Pedro, jiín ñani de Andrés. Te uū gā de cácuu sēhe Zebedeo, te nání de Jacobo jiín Juan. ");
INSERT INTO mibNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Yūcuán na te Felipe, Bartolomé, Tomás, Mateo tēe ni stútú xúhun renta, Jacobo sēhe Alfeo, jiín Lebeo jeē suni nání Tadeo, ");
INSERT INTO mibNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","jiín Simón tēe grupo cananista, jiín Judas Iscariote, tēe jeē ní nastúu de ya. ");
INSERT INTO mibNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Te ni tají Jesús ndɨhúxí uū tēe yáha jeē quíngoo de. Te ni ndacu ya jniñu nuū de ndese sáha de: Ma quíngoo ró núū ñáyuu jeē násūu ñáyuu hebreo cácuu i, ni ma quɨ́vɨcoo ró táca ñuu ñayuu Samaria. ");
INSERT INTO mibNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Chi nuū maá‑ni ñayuu nación yō Israel quingoo ró, chi cácuu i nájnūhun lanchi jeē ní sana. ");
INSERT INTO mibNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Te jeē quíngoo ró te suhva nacani ró jnúhun: Je ni cuyajni Yaā ndeé andɨvɨ́ jeē ndacu ya jniñu nuū rō, achi rō. ");
INSERT INTO mibNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Te nasávāha ró ñáyuu cándoho cuehyɨ̄ stehyú jiín ñáyuu cándoho tāca gá cuehyɨ̄, te nastécu rō ndɨ̄yɨ te quenehen ró táchī ini ñayuu. Te súcuan‑ni ni jēhe ri poder nuū rō jeē sáha ró, te suni súcuan‑ni sáha ró jíín i. ");
INSERT INTO mibNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Te ma cóndiso ró xúhun oro, ni xūhun plata, ni centavo cuechí. ");
INSERT INTO mibNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni ma cóndiso ró ñunu stáá caji rō ichi, ni ɨnga camisa, ni ndijēn, ni vara. Chi sɨquɨ̄ jniñu jeē nácani ró jnúhun nuū ñáyuu, te cánuú coto i róhó. ");
INSERT INTO mibNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Te na‑ni ñuu chí rancho núu ni jinūcoo ró, te yūcuán nducú ró ɨɨn ñayuu vāha, te coyūcu ró vehe i nde quingoo tucu ró. ");
INSERT INTO mibNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Te jeē quɨ́vɨ ró vehe ñayuu ún, te cahān rō jeē na quíji jnūhun ndeyɨ́ jnūhun sɨɨ̄ ni nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Te núu ñayuu vāha cácuu i, te jnūhun ndeyɨ́ ní cahān rō quendōo sɨquɨ̄ i. Te núu nasūu ñáyuu vāha cácuu i, te jnūhun ndeyɨ́ ní cahān rō ma quéndōo sɨquɨ̄ i. ");
INSERT INTO mibNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Te núu íyó ñáyuu jeē tu cájetáhú i róhó, ni tu cúní i cuni nahín i jnūhun cahān rō, yūcuán na te quendacoo ró vehe un chí ñuu ún, te scóyo ró tɨ́cachā jehē rō, te súcuan stéén rō jeē iyó cuéchi i jeē tu ní cájetáhú i. ");
INSERT INTO mibNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jendaá cahán rī jiín ró jeē quɨvɨ̄ juicio te xeēn gā coo castigo sɨquɨ̄ ñuu casáha súcuan vēsú sɨquɨ̄ ñuu Sodoma jiín ñuu Gomorra nuū ní casáha ndasɨ́ ñáyuu cuēchi. ");
INSERT INTO mibNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Cuni sōho ró, chi tájí rí rohó quíngoo ró nájnūhun lanchi mēhñu yɨ́hɨ̄. Núu súcuan te coo listo rō nájnūhun coō, te coo vītá ni rō nájnūhun paloma. ");
INSERT INTO mibNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Te condito ró máá ró nuū ñáyuu, chi quee quɨvɨ̄ jeē quíndeca i róhó núū tohó, te cani i róhó ini tācá vehe iī sinagoga. ");
INSERT INTO mibNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Te suni nde nuū tācá gobernador jiín rey quindeca i róhó jéē sɨquɨ́ ruhū. Te súcuan te nune ichi jeē nacani ndaā rō jnūhun ri nuū de jíín núū ñáyuu tācá nación jeē tu jíní jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Te núu ni jendeca i róhó núū tāca tée ún, ma nácani ndasɨ́ ni rō ndese cahān rō. Chi máá hora un te máá yá steén nuū rō ndese cahān rō. ");
INSERT INTO mibNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Chi nasūu máá ró cúu jeē cahán, chi Espíritu maá Tátá rō cúu jeē cahán jiín yuhu ró. ");
INSERT INTO mibNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Te sava ñayuu tu cácandíje, nastúu i ñani i jeē na cúū. Te tátá nastúu sēhe. Te sēhe ndonda sɨquɨ̄ tatá jiín náná jeē na cúū. ");
INSERT INTO mibNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Te ndɨhɨ ñayuu quɨtɨ̄ ni i nuū rō jeē sɨquɨ́ ruhū. Te ñayuu jeē cuɨñɨ nīhin nde jeē jínu jnūndóho, ñayuu ún chi cācu ánuá i. ");
INSERT INTO mibNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Te núu cájito xeēn i róhó ɨɨn ñuu, te cunu ró quíhīn rō ɨnga ñuu. Chi jendaá cahán rī jiín ró jeē ma ndécāva ró caca cuu ró ndɨhɨ nación yō Israel te ndiji‑ni máá rí, Yaā ní nduu tēe. ");
INSERT INTO mibNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ɨɨn tēe scuáha, tu cújéhnu de nuū maestro de. Ni tēe cúu mozo, tu cújéhnu de nuū patrón de. ");
INSERT INTO mibNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tēe scuáha chi nájnūhun ndóho maestro de suni súcuan ndoho nahín máá de, te tēe cúu mozo suni ndoho de nájnūhun ndóho patrón de. Núu súcuan te núu ruhū cácahān i jeē Satanás cúu ri, te nagā ni cuu jeē ma cahán i jeē rohó cácuu Satanás. ");
INSERT INTO mibNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Núu súcuan te ma yūhu ró coto ró ñáyuu. Chi tāca jnúhun cácahān sāhí i ma quéndōo sāhí cuɨtɨ, chi ndɨhɨ natūu ndijin, te cuni ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jnūhun ní cahān rī jiín ró jeē tu ní jíní ñayuu, na nácastūhun cájí ró nuū i. Te jnūhun ní nacani sāhi rí nuū rō, na nácani jee ró yátā tācá vehe. ");
INSERT INTO mibNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Te ma yūhu ró coto ró ñáyuu cahni yɨquɨ cúñu rō, chi ma cúu cahni i ánuá rō. Chi sa suhva yūhu ró jéē ma stɨ́vɨ ró núū Yaā Dios, chi cuu snáhnú ndetū yā rohó jéē quɨ́vɨ ánuá rō jiín yɨquɨ cúñu rō infierno. ");
INSERT INTO mibNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Te tācá saa chi tú yahu ndéé tɨ̄, chi nde uū tɨ̄ jeē ɨɨn centavo lulí. Te ni ɨɨn tɨ tu nɨ́nga nuū ñúhun te núu tu jéhe Tátá rō jnūhun, chi ndíto ya tɨ. ");
INSERT INTO mibNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Te nagā ni cuu róhó jíjnáhan ró, chi nde ndɨhɨ ixi xíní rō je ni cahu ya. ");
INSERT INTO mibNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Núu súcuan te ma yūhu ró jijnáhan ró, chi cánuú ndasɨ́ gá rō nuū yā vēsú cuehē tācá saa. ");
INSERT INTO mibNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Te tāca ñáyuu jeē cuajnúhún rúhū nuū ɨnga ñayuu, suni súcuan cuajnúhún rí i nuū Tatá rī, Yaā ndeé andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Te tāca ñáyuu jeē ma cuájnúhún rúhū nuū ɨnga ñayuu, suni súcuan ma cuájnúhún rí i nuū Tatá rī, Yaā ndeé andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Ma cáni ni rō jijnáhan ró jéē véji ri jeē cóyūcu mánī ñayuu ñayɨ̄vɨ́. Tú vēji ri jeē cóyūcu mánī ñayuu, chi sa suhva cuajnáhan i jeē sɨquɨ́ ruhū. ");
INSERT INTO mibNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Chi jeē sɨquɨ́ ruhū te cusɨ́ɨn ini sēhe yɨɨ́ jíín tátá, te sēhe sɨ́hɨ́ jíín náná, te sēhe jēnu jíín náná chīsó. ");
INSERT INTO mibNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Chi tāca ñáyuu candíje ruhū, chi jnáhan vehe i cúu jeē quɨtɨ̄ ni nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Te núu ndé ɨɨn ñayuu manī gā i jíín tátá i chí jíín náná i vēsú jiín rúhū, nasūu ñáyuu vāha cúu i jeē cóndiquīn i ruhū. Te núu ndé ɨɨn ñayuu manī gā i jíín séhe yɨɨ́ i chí jíín séhe sɨ́hɨ́ i vēsú jiín rúhū, te suni nasūu ñáyuu vāha cúu i jeē cóndiquīn i ruhū. ");
INSERT INTO mibNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Te na‑ni ñayuu núu tu jéhe i jnūhun ndoho i jnūndóho vēsú nde cuu i jeē sɨquɨ́ jeē cóndiquīn i ruhū, nasūu ñáyuu vāha cúu i jeē cóndiquīn i ruhū. ");
INSERT INTO mibNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Te núu ndé ñáyuu cúní i cācu i nuū jnúndóho quiji nuū i jeē sɨquɨ́ ruhū, núu súcuan te jnahnū ndetū i nɨ́ɨ́ cáni. Te núu ndé ɨɨn ñayuu vēsú na cúū i jeē sɨquɨ́ ruhū, te cotecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Te ñayuu cuatáhú róhó jijnáhan ró, núu súcuan te ruhū cájetáhú i. Te ñayuu cájetáhú rúhū, cájetáhú i Yaā ní tají rúhū vēji ri. ");
INSERT INTO mibNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Núu na‑ni ñayuu cuatáhú i ɨɨn tēe nácani jnūhun Yaā Dios, sɨquɨ̄ jeē jíca de jniñu Yaā Dios, núu súcuan te ɨnuú‑ni coo tahū de nuū Yaā Dios jiín tée nácani jnūhun Yaā Dios. Te núu na‑ni ñayuu cuatáhú i ɨɨn tēe ndaā, sɨquɨ̄ jeē tēe ndaā cúu de, núu súcuan te ɨnuú‑ni coo tahū de nuū Yaā Dios jiín tée ndaā. ");
INSERT INTO mibNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Te núu ndé ñáyuu cuāha i vēsú ɨɨn ñajin ndute míjin coho ɨɨn sūchi yáha, sɨquɨ̄ jeē cúu i sūchi cándíje ruhū, ndaā ndije cúu jeē nihín i tahū i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Te ná ni jīnu ni ndacu Jesús jniñu nuū ndɨhúxí uū tēe cáscuáha jíín yá, te ni quenda ya yūcuan cuáhān yā jeē steén yā te nacani ya jnūhun tācá ñuu región yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Te íne Juan vecāa. Te ni nihīn de jnūhun tācá jniñu sáha Cristo. Te ni tají de uū tēe cáscuáha jíín de, ");
INSERT INTO mibNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","cuacajnūhún de ya: ¿A máá ní cúu Cristo jeē achí tutu jeē quíji, chí condetu yó ɨnga tēe quiji? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Te ni cahān yā jiín de: Cuángoo te castūhun ró nuū Juan tācá jniñu cájito ró jíín jnúhun cájini ró. ");
INSERT INTO mibNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Te cachi rō nuū de jeē ñáyuu cuaá cánanune tɨnūú i, te ñayuu yacuá cánacaca i, te ñayuu ndóho cuehyɨ̄ stehyú cánduvāha i, te ñayuu sohó cánanune sōho i, te ñayuu jihí nátecu i sáha ri. Te suni nácani ri jnūhun nuū ñáyuu ndahú jéē jnama Yaā Dios i. ");
INSERT INTO mibNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Te yōhyo ndetū tēe jeē ma nácani yátá ni de jeē ruhū cúu Cristo. Súcuan cachi rō nuū Juan. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Te náa cuanuhun ndɨndúú tée ún, te ni quejéé Jesús cahán yā jnūhun Juan jiín ñáyuu: ¿Na vé ni jécondēhe ró jijnáhan ró nde nuū ñúhun téhé? ¿A ɨɨn tēe jéni ɨɨn jéni uū ni, nájnūhun ite jeē cánda sáha tachī? ");
INSERT INTO mibNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Te núu tuú, ¿te na vé ni jécondēhe ró núu súcuan? ¿A ɨɨn tēe cúní cujéhnu jeē ñúhun sahma lúu? Tuú chi cájini rō jeē tēe cáñuhun sahma lúu, máni ini vehe rey cáyūcú de. ");
INSERT INTO mibNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Te na vé ni jécondēhe ró núu súcuan? ¿A ɨɨn tēe nácani jnūhun Yaā Dios? Cáhán rī jiín ró jeē suu ni jecondēhe ró, te cújéhnu ga Juan yáha vēsú tāca gá tēe ni canacani jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Chi jnūhun Juan cúu jeē ni cáhān Yaā Dios jeē yosó núū tútu iī: Tají rí tēe nacani jnūhun ri cosnūú de ichi núú Cristo, návāha coo tūhva ñayuu jeē jinú yā. Achí Yaā Dios, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Te jendaá cahán rī jiín ró jeē ini ñayɨ̄vɨ yáha cújéhnu ga Juan tēe scuándute vēsú tāca gá tēe jeē ni íyo ini ñayɨ̄vɨ́. Te vēsú súcuan te tāca tée núu ga ini ñuu nuū ndácu Yaā andɨvɨ́ jniñu, cújéhnu ga de vēsú Juan. ");
INSERT INTO mibNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Te nde quɨvɨ̄ ní quee Juan tēe scuándute, te nde vijna, chi cánducú ndéyɨ́ ñáyuu quɨ́vɨcoo i ndaha Yaā andɨvɨ́ jéē ndácu ya jniñu nuū i. Te nde ñayuu xeēn cánducú ndéyɨ́ i sɨquɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Chi nde ná tu quiji Juan, te ni īyo máá ley Moisés, te suni ni īyo tāca tée ni canacani jnūhun Yaā Dios. Te ni cacastūhún de ndese coo jeē ndacu Yaā Dios jniñu. ");
INSERT INTO mibNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Te ni cacahān de jeē ndíji Elías. Te núu cácuni rō cuatáhú ró jnūhun, te jíní rō jeē maá Juan cúu tēe jeē ní cachi tutu jeē quíji, chi cúu de nájnūhun Elías. ");
INSERT INTO mibNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tāca róhó jéē jíni sōho, na chúsóhó ró. ");
INSERT INTO mibNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Yāhá cachi rī ɨɨn jnūhun yátá návāha na cúni rō ndese cúu ñayuu tiempo vijna. Cúu i nájnūhun sūchi lúlí cáhīin nuū yáhu cácasɨ́quɨ́ i. Te cácana ndee i xinī jnáhan i: ");
INSERT INTO mibNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ni catɨvɨ rī scuilí, te tu ní cájita jéhé ró. Te ni cajita ri yaa jeē cuihyá jíta, te tu ní cándahyū rō, achí i. Te nájnūhun cándāa sūchi lúlí un jéē tu ní nújnahan ni i ni ɨɨn, súcuan cándāa ró. ");
INSERT INTO mibNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chi ni quiji Juan te cuehē jínu ni īyo ndite ni de, tu ní yéji de ni tu ní jíhi de. Te tu ní cánujnahan ni rō, chi ni cacahān rō jeē ñúhun tachī ini de. ");
INSERT INTO mibNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yūcuán na te ni quee maá rí, Yaā ní nduu tēe, te yéji rī jíhi ri, te tu cánujnahan ni rō, te chísóó jnúhun ró cácahān rō jeē máni máá jéē yéji rī jíhi ri vino. Te quíjnáhan ri jiín tée cástútú xúhun renta jiín táca gá tēe cásáha cuēchi, áchí ró. Te núu cúndíchí ɨɨn tēe jíín jnúhun Yaā Dios, te jíín jniñu sáha de te nátūu jeē tée ndíchí cúu de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yūcuán na te ni quejéé yá cúxeēn yā nuū tācá ñuu nuū ni sáha ya cuehē jniñu jéhnu, chi tu ní cánacani ni i jeē stóo i cuēchi i. Te ni cahān yā: ");
INSERT INTO mibNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Nacā jeē xeēn ndoho ró, ñáyuu ñuu Corazín. Te nacā jeē xeēn ndoho ró, ñáyuu ñuu Betsaida. Chi núu ini ñuu Tiro jiín ñuu Sidón ni sáha ri jniñu jéhnu jeē ni sáha ri ini ñuu maá ró, te yachī nacani ni ñayuu ñuu un jéē stóo i cuēchi i núú. Te sáha i seña jeē steén jeē nácani ni i sɨquɨ̄ cuéchi i, chi cuhun i sahma jnúú te chuhun i yaā xinī i núú. ");
INSERT INTO mibNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Núu súcuan te cáhán rī jiín ró jeē quɨvɨ̄ coo juicio te xeēn gā coo castigo sɨquɨ̄ rō jijnáhan ró vēsú jeē ni íyo sɨquɨ̄ ñuu Tiro jiín ñuu Sidón. ");
INSERT INTO mibNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Te róhó ñáyuu ñuu Capernaum, ¿á cájeni ni rō jeē cujéhnu ró nájnūhun ɨɨn jeē cáa cuahān ichi ándɨvɨ́? Tuú chi sa nanuu ró ndé lugar nuū cáyūcu ánuá ndɨ̄yɨ. Chi núu ini ñuu Sodoma ni sáha ri jniñu jéhnu jeē ni sáha ri nuū maá ró, te coo ñuu yúcuan ndé vijna núú. ");
INSERT INTO mibNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Núu súcuan te cáhán rī jiín ró jeē quɨvɨ̄ coo juicio te xeēn gā coo castigo sɨquɨ̄ rō vēsú jeē ni íyo sɨquɨ̄ ñáyuu ñuu Sodoma. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Te suni quɨvɨ̄ un ní cahān Jesús: Na cútahū na núū ni Tátā, Jitoho andɨvɨ́ jíín ñáyɨ̄vɨ́. Chi ni jesɨ ní táca jnúhun ndíchí ní, jeē ma cúni ñayuu ndichí jíín ñáyuu tūhva cuenta ñayɨ̄vɨ yáha. Te ni steén ni núū ñáyuu cácuu nájnūhun sūchi lúlí. ");
INSERT INTO mibNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chi súcuan ni nujnahan ni ni Tátā, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Te ni cahān gā yā: Ndɨvii ni jēhe Tátá rī nuū rī. Te tu cájini ñayuu ndé ɨɨn cúu ruhū, Sēhe Yaā Dios, chi máá‑ni Tátá rī cúu jeē jiní yā ruhū. Ni tu cájini ñayuu ndese Yaā cúu máá Tátá, chi máá‑ni Sēhe cúu jeē jiní. Te íyó ñáyuu jeē cuní maá Séhe stéén yā nuū i ndese Yaā cúu Tátá yā, te máá i suni cuni i. ");
INSERT INTO mibNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tāca ró jéē ni cuíta ró jiín táca jniñu jíín ley jeē yɨɨ́ sáha jíín ró, nehen quɨ̄vɨcoo ró ndaha ri, te ndetātu ró sáha ri. ");
INSERT INTO mibNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Quɨ̄vɨ ró núū jníñu ndácu máá rí, te scuáha ró coo ró nájnūhun íyó máá rí. Chi vītá ni rī te suchí ni rī. Te súcuan te ndetātu ró jiín ánuá rō sáha ri. ");
INSERT INTO mibNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Chi tú yɨɨ́ jéē cuandetū rō nuū rī, ni tú yɨɨ́ jéē squícu ró jniñu ndácu ri. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Te ɨɨn quɨvɨ̄ ndétātu ní yāha Jesús cuahān yā nuū cáa trigo. Te tēe cáscuáha jíín yá, cájiī de sōco. Te ni quejéé de cátaxín de yoco trigo cáyeji de. ");
INSERT INTO mibNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Te ni cajito tēe grupo fariseo, te ni cacahān de jíín yá: Condēhé, chi tēe cáscuáha jíín ró casáha de jniñu jeē tu íyó váha sáha yó quɨ́vɨ̄ ndétātú, áchí ley Moisés. ");
INSERT INTO mibNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Te ni cahān maá yá jiín de: ¿A tu ní cácahu ró tutu ndese ni sáha David, ɨɨn quɨvɨ̄ jeē ni jíī de sōco jíín tée cáhīin jíín de? ");
INSERT INTO mibNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Te ni quɨ̄vɨ de ini vehe Yaā Dios. Te ni yeji de pan iī jeē yosó ndijin nuū Yaā Dios. Te tú na ley jeē cáji de, ni tēe cáhīin jíín de, chi máá‑ni sutū cuu caji. Te vēsú súcuan te tú na cuēchi ní íyo sɨquɨ̄ de. ");
INSERT INTO mibNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Te á tu ní cácahu ró tutu ley Moisés, ndese cásájniñu sutū ini templo, vēsú quɨvɨ̄ ndétātu cúu? Te tú na cuēchi íyó sɨ́quɨ̄ de, vēsú quɨvɨ̄ ndétātu cásájniñu de jniñu jeē cácuu de sutū. ");
INSERT INTO mibNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Te cáhán rī jiín ró jeē maá rí jeē iyó yáha, cújéhnu ga rī vēsú templo. ");
INSERT INTO mibNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Te tu cájecūhun ni rō jijnáhan ró jnūhun yáha jeē yosó núū tútu iī jeē ni cáhān Yaā Dios: Jeē cuní gā rī cúu jeē cundáhú ni rō jnáhan ró, vēsú jeē socó rō quɨtɨ nuū rī, achí yá. Te núu jeē ní cajecūhun ni rō jnūhun yáha, te ma cahán rō súcuan sɨquɨ̄ tée jeē tú na cuēchi núú. ");
INSERT INTO mibNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Chi ruhū, Yaā ní nduu tēe, máá rí cúu jeē ndácu jniñu sɨquɨ̄ ndese sáha ñayuu quɨvɨ̄ ndétātú, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yūcuán na te cuahān Jesús, te ni quɨ̄vɨ ya ini vehe iī sinagoga. ");
INSERT INTO mibNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Te yūcuan íne ɨɨn tēe ni ichī ɨɨn ndaha de. Te cácuni tēe grupo fariseo jeē nihīn de cuēchi sɨquɨ̄ yā, te ni cacajnūhún de ya: ¿A íyó ley jeē cuu nasávāha yó ñayuu cuhú quɨvɨ̄ ndétātú? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Te ni cahān yā jiín de: ¿Ndé ɨɨn róhó, núu névāha ró ɨɨn lanchi, te núu nɨ́nga tɨ ini ɨɨn yaū quɨvɨ̄ ndétātú, te á tu jéhén rō natava rō tɨ̄, chí naún? ");
INSERT INTO mibNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Te á tu cánuú ndasɨ́ gá ɨɨn tēe vēsú ɨɨn lanchi? Núu súcuan te vetū‑ni sáha yó jniñu váha quɨvɨ̄ ndétātú, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yūcuán na te ni cahān yā jiín tée ni ichī ndaha ún: Scáá ndaha ró. Te ni scaá de, te ni nduvāha‑ni nájnūhun íyó ɨnga. ");
INSERT INTO mibNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yūcuán na te ni quendacoo tēe grupo fariseo, te ni candajnūhún de sɨquɨ̄ Jesús, ndese cahni de ya. ");
INSERT INTO mibNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Te ni jini Jesús jeē súcuan cájeni ni de, te ni quenda ya yūcuan cuáhān yā. Te cuehē ñayuu cándiquīn i ya. Te ni nasávāha ya ndɨhɨ ñayuu cuhú. ");
INSERT INTO mibNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Te ni ndacu ya jniñu nuū i jeē ma stéén i ya. ");
INSERT INTO mibNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Te súcuan ni cuu návāha squícu jnūhun ni cahān Yaā Dios sɨquɨ̄ Jesús, te ni nacani Isaías jnūhun ya un ndé jenahán: ");
INSERT INTO mibNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yāha cúu mozo rī jeē ní nacāji ri, te manī rī jiín yá, te cúsɨɨ̄ ni rī jiín yá. Te cuāha ri Espíritu rī coo jíín yá. Te máá yá sándaā jniñu ñayuu tācá nación. ");
INSERT INTO mibNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ma tejnáhan ya, ni ma cána jee ya, te ni ma cahán jee ya ichi jeē cúni ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ma sáha xeēn yā jiín ñáyuu ni cunīhin jnūndóho sɨquɨ̄, ni ma snáā yā ñayuu jeē maá lulí‑ni cácandíje. Chi cujéhnu ya sɨquɨ̄ ndɨhɨ, te ndaā ndacu ya jniñu. ");
INSERT INTO mibNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Te ñayuu tācá nación cocuhun ni i jeē jnáma ya i. Achí Yaā Dios, achí Isaías nde jenahán. ");
INSERT INTO mibNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yūcuán na te ni caquindeca i nuū yā ɨɨn tēe cuáá ñɨ́hɨ́n, chi ñúhun tachī ini de. Te ni nasávāha ya de. Te ni ndundijin tɨnūú de te ni nacahān de. ");
INSERT INTO mibNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Te ndɨhɨ ñayuu cuehē un ní canaa ni i cájito i, te ni cacahān i: ¿A tée yáha cúu jeē ni cáhān Yaā Dios jeē cacu nuū yucūn David? áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Te tēe grupo fariseo, ni cajini de jeē súcuan cácahān i. Te ni cacahān de: Tēe yáha ma cúu quenehen de tachī núu jeē tu sáha de jíín fuerza Satanás jeē cujéhnu nuū tachí, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Te Jesús ni jini yā jeē súcuan cájeni ni de, te ni cahān yā jiín de: Tācá nación jeē casásɨ́ɨn máá te cájejnáhan máá, núu súcuan te snáā jeē iyó váha máá. Te núu ɨɨn ñuu chí ɨɨn vehe cásásɨ́ɨn máá te cájejnáhan máá, te ma cúu ga coyūcu cáhnu. ");
INSERT INTO mibNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Te suni súcuan Satanás núu quénehen jnáhan tachī, núu súcuan te sásɨ́ɨn máá. ¿Te ndese cuɨñɨ nīhin Satanás jeē ndácu jniñu núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Chi cácahān rō jeē jiín fuerza Satanás quénehen ri tachī. Te núu súcuan cúu núú, te ñayuu cascuáha jíín máá ró jijnáhan ró, ¿na jiín fuerza cáquenehen máá i tachī, cájeni ni rō? Núu súcuan te máá i jíjnáhan i cachi jeē ní castɨ́vɨ ndasɨ́ suhva ró ni cacahān rō jeē cáquenehen ri tachī jiín fuerza Satanás. ");
INSERT INTO mibNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Te tuú chi sa jíín Espíritu Yaā Dios cúu jeē quénehen ri tachī. Núu súcuan te je ndéé Yaā Dios mēhñu ró jeē ndácu ya jniñu. ");
INSERT INTO mibNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Chi ndese cuu quɨ̄vɨ ɨɨn tēe ini vehe tēe ndacuī jeē quenehen de ndajníñu de? Chi cánuú jeē xíhna gā cuhni de tēe ndacuī ún, te yūcuán na te cuu quenehen de ndajníñu ún. Te suni súcuan cúu jeē jíhni rī Satanás te quénehen ri tachī. ");
INSERT INTO mibNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Te ñayuu tu íyó mánī jiín rí, núu súcuan te jíto uhū i ruhū. Te ñayuu tu nástútú jíín rí, núu súcuan te sa jéte núu i ñayuu vējicoo nuū rī. ");
INSERT INTO mibNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Jeē yúcuan cáhán rī jiín ró: Iyó modo coo jnūhun cáhnu ni nuū tāca cuéchi cásáha ñayuu, jiín núū tāca jnúhun néé cácahān i. Te núu cahān ndevāha i sɨquɨ̄ Espíritu Santo, te ma cóne cáhnu ni Yaā Dios nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Te núu na‑ni ñayuu cahān i sɨquɨ̄ ruhū, Yaā ní nduu tēe, cuu cone cáhnu ni Yaā Dios nuū i. Te núu na‑ni ñayuu cahān ndevāha i sɨquɨ̄ Espíritu Santo, ma cóne cáhnu ni Yaā Dios nuū i, ni jeē iyó i ñayɨ̄vɨ yáha, ni nɨ́ɨ́ tiempo quíji. ");
INSERT INTO mibNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Núu yujnu váha, te vāha ndehē, te núu yujnu néé, te cánéé ndehē. Chi jíín ndéhē te jíní yō ndese yujnu cúu. Te suni súcuan ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Va sēhe coō cácuu ró, chi xeēn rō nájnūhun coō. ¿Ndese cuu cahān rō jnūhun vāha, chi ñayuu cásáha néé cácuu ró? Chi jniñu jeē jéni ni anuá ñayuu, máni yūcuan cáhán i. ");
INSERT INTO mibNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tēe vāha cáhán de jnūhun vāha, chi íyó ndáā anuá de. Te tēe sáha néé cáhán de jnūhun néé, chi cánéé ánuá de. ");
INSERT INTO mibNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Te cáhán rī jiín ró jeē tācá na‑ni jnūhun cácahān ñayuu, nacuāha i cuenta jnūhun un quɨ́vɨ̄ coo juicio. ");
INSERT INTO mibNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chi jíín jnúhun ni cahān rō sándaā yā sɨquɨ̄ rō, núu jeē quéndōo ndaā rō chí jéē cóndee cuēchi sɨquɨ̄ rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yūcuán na te jecu tēe grupo fariseo jiín tée cástéén tutu ley Yaā Dios, ni cacahān de jíín yá: Maestro, cácuni na jéē sáha ní ɨɨn jniñu jéhnu jeē steén núu máá ní cúu Yaā ní tají Yaā Dios, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Te ni cahān yā jiín de: Ñayuu yáha jeē casáha jniñu néé, tu cájetáhú cuɨtɨ i Yaā Dios. Te cájicān i ɨɨn jniñu jéhnu jeē steén núu Yaā ní tají Yaā Dios cúu ri. Te tuá na ɨnga jniñu jéhnu stéén rī nuū i, chi máá‑ni jniñu jéhnu nájnūhun ni cuu jíín Jonás, tēe ni nacani jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chi nájnūhun ni ine Jonás chīji chācá cáhnu unī nduú unī ñuú, suni súcuan ruhū, Yaā ní nduu tēe, cuu rī te cone ri chīji ñuhun unī nduú unī ñuú, te sáá te natecu rī. ");
INSERT INTO mibNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Te tāca ñáyuu ñuu Nínive nuū ní nacani Jonás jnūhun, natecu i jíín ñáyuu tiempo yáha, quɨvɨ̄ juicio jeē sándaā yā cuēchi, te cahān i cuēchi sɨquɨ̄ ñáyuu yáha. Chi máá i ni canacani ni i ni castóo i cuēchi i quɨvɨ̄ ní nacani Jonás jnūhun nuū i. Te vijna chi cújéhnu ga ruhū Yaā íne yāhá vēsú Jonás, te tu cácandíje ró rúhū. ");
INSERT INTO mibNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Te reina jeē ní cujéhnu nación ichi sur, natecu ña jíín ñáyuu tiempo yáha, quɨvɨ̄ juicio jeē sándaā yā cuēchi, te cahān ña cuēchi sɨquɨ̄ i. Chi nde jicá téyɨ́ ní quiji ña ni jini nahín ña jnūhun ndíchí ní cahān rey Salomón. Te vijna chi cújéhnu ga ruhū, Yaā íne yāhá vēsú Salomón, te tu cácandíje ró rúhū. ");
INSERT INTO mibNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Núu ni quenda ɨɨn tachī ini ɨɨn tēe tu cándíje, te jíca cuu nuū ñúhun téhé, ndúcú núū ndétātú, te tu níhín, yūcuán na te jéni ni maá: ");
INSERT INTO mibNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Na quínuhun rī vehe nuū ní quenda ri. Te núu ni ndee tucu, te jíto jeē tēe tu cándíje ún, cúu de nájnūhun ɨɨn vehe íyú te ni ndundoo. ");
INSERT INTO mibNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yūcuán na te jéquihin uxā gā tachī neé gá vēsú maá. Te quɨ́vɨcoo ini tēe un jéē cóyūcu yúcuan. Núu súcuan te xeēn gā ndoho tēe un jéē sándɨ̄hɨ́ vēsú jeē xíhna ñúhún. Te suni súcuan ndoho ñayuu tiempo yáha jeē casáha néé. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Te níní súcuan cáhán yā jiín ñáyuu ún, te ni quee naná yā jiín táca ñani yā, íin ña nuū quéhe, te cúní ña cahān ña jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Te ni cachi ɨɨn tēe nuū yā: Náná ni jíín táca ñani ni cáhīin nuū quéhe, te cácuni cahān jiín ní, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Te ni cahān yā jiín tée ni cahān súcuan jíín yá: ¿Ndé ɨɨn cúu náná rī, te ndé ɨɨn cácuu ñani rī? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Te ni steén ndaha yá nde nuū cáyūcu tée cáscuáha jíín yá. Te ni cahān yā: Suni náná rī jiín ñani rī cácuu tāca jéē yáha. ");
INSERT INTO mibNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chi tāca ñáyuu casquícu jniñu cúní maá Tátá rī, Yaā ndeé andɨvɨ́, suu cácuu ñani rī, cuāha ri, náná rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Te quɨvɨ̄ un ní quenda Jesús vehe cuahān yā, te ni jinū yā ni cucōo ya yumar. ");
INSERT INTO mibNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Te ni cutútú cuéhē ndasɨ́ ñayuu nuū yā. Te ni quɨ̄vɨ ya ini ɨɨn barco, ni cucōo ya. Te tāca ñáyuu un cáyūcú i yumar. ");
INSERT INTO mibNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Te jíín jnúhun yátá ni cahān yā cuehē jnūhun nuū i, te súcuan ni cahān yā: Ɨɨn tēe cate trigo, ni quenda de jeē cáte de. ");
INSERT INTO mibNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Te ná ni quejéé de jéte de, te jecu trigo ni jitē yuhíchi. Te ni quecoo saa, ni cayeji tɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Te jecu gā trigo ni jitē nuū ñúhun yuū, nuū tú cuehē ñuhun. Te yachī‑ni ni cane, chi tu cóquin ñuhun. ");
INSERT INTO mibNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Te nuū ní cane niāndii, te ni ichī‑ni, te ni casun, chi tu ní níhín nuū quihín yoho. ");
INSERT INTO mibNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Te jecu gā trigo ni jitē nuū náne iñu. Te ni jehnu iñu ún, te ni jesɨ nuū. ");
INSERT INTO mibNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Te jecu ni jitē nuū ñúhun váha, te ni jēhe cuehē nunī. Sava ni jēhe ciento jeē ɨ́ɨn ɨɨn, te sava ni jēhe unī xico, te sava ga ni jēhe ocō uxī. ");
INSERT INTO mibNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tāca róhó jéē jíni sōho, na chúsóhó ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yūcuán na te tēe cáscuáha jíín yá un ní quecoo de nde nuū yā, te ni cacajnūhún de ya: ¿Najehē cúu jeē máni jnūhun yátá cáhán ni jíín ñáyuu? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Te ni cahān yā jiín de: Róhó jíjnáhan ró chi sáha ya jeē cájecūhun ni rō jnūhun ni yɨsāhi yáha, ndese quɨ́vɨcoo ñayuu ndaha Yaā andɨvɨ́ jeē ndacu ya jniñu nuū i. Te ñayuu yáha jéē tu cácandíje, chi ma jécūhun ni i. ");
INSERT INTO mibNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Chi ñayuu je jécūhun ni, chi stéén gā yā nuū i, te víhyá gā cuni i. Te ñayuu tu cándíje, sa suhva naa jecu jeē je jíní i ún. ");
INSERT INTO mibNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jeē yúcuan cáhán rī jnūhun yátá jíín i. Chi vēsú cájito i, te quendōo i nájnūhun jeē tú na vé ni cájito i. Te vēsú cájini sōho i, te ma jécūhun ni i, te quendōo i nájnūhun jeē tú na vé ni cájini i. ");
INSERT INTO mibNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ñayuu yāhá chi squícu sɨquɨ̄ i jnūhun ni cahān Yaā Dios jeē ní nacani Isaías, tēe ni nacani jnūhun nde jenahán: Vēsú cuni nahín ró, te ma jécūhun ni rō, te vēsú coto ró, te ma nácuni rō. ");
INSERT INTO mibNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Chi ñayuu yáha yōhyo ni ndunīhni ni i, te yōhyo uhū chusóhó i, te nájnūhun cájesɨ i tɨnūú i, návāha coo nájnūhun jeē tu cájito i, ni tu cájini nahín i, te ni ma jécūhun ni i, ni ma násāma ini i quɨ̄vɨcoo i nuū rī jeē nasávāha ri anuá i nuū cuéchi i. Achí Yaā Dios, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Te máá ró jijnáhan ró, yōhyo ndetū rō, chi cájito ró jíín tɨ́nūu ró, te cájini nahín ró jíín sóho ró. ");
INSERT INTO mibNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Chi jendaá cahán rī jiín ró jeē cuehē tēe ni canacani jnūhun Yaā Dios jiín cuéhē tēe ndaā, ni cacuni de coto de jeē cájito máá ró, te tu ní cájito de. Te suni ni cacuni de cuni sōho de jeē cájini sōho máá ró, te tu ní cájini de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Núu súcuan te cuni nahín jíjnáhan ró na vé cuní cahān jnūhun yátá tée jéte trigo: Trigo un cúu jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Te ñayuu cájini sōho jnūhun ndese ndácu Yaā andɨvɨ́ jniñu, núu tu cájecūhun ni i te cácuu i nájnūhun trigo jeē ni jítē yuhíchi. Yūcuán na te quíji jexeén te quénde‑ni jnūhun ini anuá i. ");
INSERT INTO mibNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Te trigo jeē ni jítē nuū ñúhun yuū cúu nájnūhun ñayuu cájini sōho jnūhun, te yachī‑ni cájetáhú i te cácusɨɨ̄ ni i jíín. ");
INSERT INTO mibNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Te tu cúcutú jnúhun ún ini anuá i, te jecu‑ni quɨvɨ̄ cájetáhú i. Te núu ni quejéé jnúndóho, chí jíto xeēn ñayuu i sɨquɨ̄ jnúhun ún, te quéjéé nácani yátá ni i. ");
INSERT INTO mibNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Te jeē ni jítē nuū náne iñu cúu ñayuu cájini nahín jnúhun, te cándɨhvɨ̄ ni i sɨquɨ̄ jeē iyó ini ñayɨ̄vɨ yáha, te cúní i cucúcá i, te stáhú un i cujnéñu i jíín. Te ndɨhɨ jeē yáha jésɨ nuū jnúhun ya, te tu íje i jíín jnúhun ya. ");
INSERT INTO mibNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Te trigo jeē ni jítē nuū ñúhun váha cúu nájnūhun ñayuu cájini nahín jnúhun, te cájecūhun ni i, te cáhije i jíín jnúhun ya. Te sava i cúu nájnūhun nunī jeē jéhe ciento jeē ɨ́ɨn ɨɨn, te sava ga i jéhe unī xico, te sava ga i jéhe ocō uxī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Te ni cahān yā ɨnga jnūhun yátá jíín de: Jeē ndácu Yaā andɨvɨ́ jniñu cúu nájnūhun ɨɨn tēe jeē ní jete de trigo váha nuū ñúhun de. ");
INSERT INTO mibNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Te íyó ɨɨn tēe jíto uhū de tēe chíí trigo. Te náa cáquixī tēe chíí trigo jiín táca jnáhan de, te ni jehēn ni jete ndɨquɨn lású nuū trigo de, te cuahān. ");
INSERT INTO mibNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Te nuū ní cane trigo ún, te ni cane yoco i, te suni súcuan ni jehnu ite lasú un. ");
INSERT INTO mibNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yūcuán na te ni jengoo mozo ni cacahān i jíín patrón i: ¿A násūu trigo váha ní jéte ní núū ñúhun ní? ¿Te ndese cúu jeē ní canecoo ite lasú nuū? ");
INSERT INTO mibNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Te ni cahān de jíín i: Ɨɨn tēe jíto uhū ruhū ni sáha jeē yáha. Te ni cacahān mozo un jíín de: ¿Núu súcuan te á cúní ni jéē na quíngoo ná te jnuhun ná? áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Te ni cahān de: Tuú, chi núu jnuhun ró lású un te sanaa te jnuhun ró ndé jiín trigo. ");
INSERT INTO mibNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Vāha ga na cuéhnu máá ndé quɨvɨ̄ tahndé. Te quɨvɨ̄ un cáhān rī jiín tée cahnde jeē xīhna gā ite lasú cahnde de, te chucú tútú de návāha cahmu yó. Yūcuán na te trigo chi cahnde de ndɨ̄vɨ ini yacā rī, achí de. Áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Te suni ni cahān yā ɨnga jnūhun yátá jéē steén yā ndese ndúcuehē ñayuu ndácu Yaā andɨvɨ́ jniñu nuū: Ndúcuehē i nájnūhun jéhnu ɨɨn ndɨquɨn mostaza jeē ní jequin ɨɨn tēe nuū ñúhun de. ");
INSERT INTO mibNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Te jendaá jeē ɨɨn ndɨquɨn lúlí gá cúu vēsú tāca gá ndɨquɨn. Te núu ni jehnu, te cúu cáhnu ga vēsú tāca gá yucū, chi ndúu nájnūhun ɨɨn yujnu. Te quíjicoo saa, te cásáha tɨ tacā tɨ̄ chīji ndaha ún. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Te ɨnga jnūhun yátá ní cahān yā jiín de: Jeē ndácu Yaā andɨvɨ́ jniñu nuū ñáyuu cúu nájnūhun levadura jeē ní quihin ɨɨn ñahan. Te ni saca ña jíín únī kilo harina, nde ni ndaa ndɨhɨ ñujen ni sáha. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tāca jnúhun yáha ní cahān Jesús jiín ñáyuu cuehē ún. Te tāca jéē ni stéén yā, máni jnūhun yátá ní cahān yā jiín i. ");
INSERT INTO mibNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Súcuan ni sáha ya návāha squícu jnūhun ni cahān tēe ni nacani jnūhun Yaā Dios nde jenahán: Cahān rī tāca jnúhun yátá jíín ñáyuu, te cachi rī tāca jnúhun yɨ́sāhí ndé quɨvɨ̄ ní jecōo ñayɨ̄vɨ́. Achí tutu, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yūcuán na te ni nacuatáhú Jesús nuū ñáyuu. Te ni ndɨ̄vɨ ya ini vehe. Te tēe cáscuáha un ní jinūcoo de nuū yā, te ni cacahān de jíín yá: Nacani cájí ní jnūhun yátá ite lasú nuū ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Te ni cahān yā jiín de: Jeē jéte trigo vāha un cúu máá rí, Yaā ní nduu tēe. ");
INSERT INTO mibNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Te ñuhun un cúu ñayɨ̄vɨ́. Te trigo vāha un cúu ñayuu cáyɨhɨ ndaha Yaā Dios jeē ndácu ya jniñu nuū i. Te ite lasú un cúu ñayuu cáyɨhɨ ndaha jexeén. ");
INSERT INTO mibNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Te tēe jíto uhū jeē ní jete lasú un cúu máá jéxeén. Te quɨvɨ̄ tahndé cúu quɨvɨ̄ jínu ñayɨ̄vɨ́. Te tēe cahnde un cácuu ndajéhé Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Te nájnūhun tahndē ite lasú te cayū nuū ñuhún, súcuan coo quɨvɨ̄ jínu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Chi máá rí, Yaā ní nduu tēe, tají rí ndajéhé rī quingoo. Te nastútú yá tāca ñáyuu casquɨ́vɨ jnáhan nuū cuéchi, jíín ñáyuu casáha jniñu néé, quenehen ya i mēhñu ñáyuu ndácu ri jniñu nuū. ");
INSERT INTO mibNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Te jnaa ya i cayū i nuū ñuhún. Te yūcuan ndáhyū i te nacayɨ̄hɨ́ yuhu i jeē ndoho xeēn i. ");
INSERT INTO mibNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yūcuán na te ñayuu squícu nuū yā chi ndindēé i nájnūhun niāndii, te coyūcú i nuū ndácu máá Tátá i jniñu. Tāca róhó jéē jíni sōho, na chúsóhó ró. ");
INSERT INTO mibNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Te jeē ndácu Yaā andɨvɨ́ jniñu nuū ñáyuu, suni cúu nájnūhun ɨɨn yejnū xūhún jeē yɨ́sāhi chíji ɨɨn ñuhun. Te ni nanihīn ɨɨn tēe, te ni nacasɨ tucu de sɨquɨ̄. Te jeē cúsɨɨ̄ ni de jíín, te ni jehēn de ni xīcó ndɨhɨ de jeē névāha de, te ni jeen de ñuhun ún. ");
INSERT INTO mibNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Te jeē ndácu Yaā andɨvɨ́ jniñu nuū ñáyuu, suni cúu nájnūhun ɨɨn tēe jéen xíco, te ndúcú de perla váha. ");
INSERT INTO mibNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Te ni jini de ɨɨn perla jeē yáhu ndasɨ́, te ni jehēn de ni xīcó ndɨhɨ de jeē névāha de, te ni jeen de perla un. ");
INSERT INTO mibNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Te jeē ndácu Yaā andɨvɨ́ jniñu nuū ñáyuu, suni cúu nájnūhun ɨɨn ñunu jeē cásɨ́ngava de ini mar, te quɨ́vɨcoo ndɨnuū chācá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Te núu ni chitú ñunu ún, te cánatava de yundúte. Te cácucōo de cánacāji de chācá. Te chācá váha cájnaa de ini jīca, te chācá tú vāha cáscáne de. ");
INSERT INTO mibNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Te suni súcuan coo quɨvɨ̄ jínu ñayɨ̄vɨ́. Chi quijicoo ndajéhé yā, te sásɨ́ɨn ya ñayuu casáha jniñu néé méhñu ñáyuu casáha jniñu váha. ");
INSERT INTO mibNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Te ñayuu cunéé chi jnaa ya i cayū i nuū ñuhún. Te yūcuan ndáhyū i te nacayɨ̄hɨ́ yuhu i jeē ndoho xeēn i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Te ni cajnūhun yá de jíjnáhan de: ¿A ní cajecūhun ni rō tāca jnúhun yáha, chí tuú? áchí yá. Te ni cacahān de jíín yá: Ni cajecūhun ni ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Te ni cahān yā jiín de: Iyó váha núu súcuan. Te ɨɨn tēe stéén tutu ley Yaā Dios, núu je ni cutūhva de ndese ndácu Yaā andɨvɨ́ jniñu, te cuu stéén de tāca jnúhun sɨquɨ̄ ún. Chi cúu de nájnūhun ɨɨn tēe chíí vehe. Te ini yejnū de táva de ndajníñu ndéé yahu, sava jeē jeé jíín sava jeē je ni cunahán íyó. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Te ná ni ndɨhɨ ni cahān Jesús tāca jnúhun yátá yáha, te ni quenda ya yūcuan cuáhān yā. ");
INSERT INTO mibNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Te ni najinū yā ñuu yā Nazaret. Te ni steén yā jnūhun ini vehe iī sinagoga yūcuán. Te ni canaa ni ñayuu cájini nahín i, te ni cacahān i: ¿Ndé nuū ní cutūhva tēe yáha tāca jnúhun ndíchí? ¿Te ndese cúu sáha de tācá jniñu jéhnu yāhá? ");
INSERT INTO mibNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Chi sēhe carpintero cúu tēe yáha, te náná de cúu María, te ñani de cácuu Jacobo, José, Simón, jiín Judas. ");
INSERT INTO mibNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Te suni cáyūcu cuáha de jíín yó yāhá. ¿Te ndese jíní de tāca jnúhun yáha núu súcuan? Achí ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Te súcuan ni cacujéē ni i nuū Jesús. Te ni cahān yā jiín i: Tāca tée nácani jnūhun Yaā Dios, íyó yɨ́ñúhún ñayuu jiín de, te máni ñayuu ñuu maá de jíín ñáyuu vehe máá de cúu jeē tu íyó yɨ́ñúhún jíín de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Te tu ní sáha ya cuehē jniñu jéhnu yūcuán, chi tu cácandíje i ya. ");
INSERT INTO mibNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Te tiempo yúcuan te Herodes, tēe ndácu jniñu región Galilea, ni jini jnūhun de jnūhun Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Te ni cahān de jíín ñáyuu cáhīin jíín de: Tēe yúcuan cúu Juan tēe ni scuándute, te ni natecu de. Jeē yúcuan íyó poder de sáha de jniñu jéhnu. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Chi Herodes, je ni ndacu de jniñu jeē na quɨ́vɨ Juan vecāa, jíín jéē na cónuhnī de jíín cadena. Súcuan ni sáha de jeē sɨquɨ́ Herodías, ñasɨhɨ́ ñani de Felipe. ");
INSERT INTO mibNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Chi Juan ni cahān de nuū Herodes: Tu íyó ley condeca ró ña, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Te jeē yúcuan ní cuni Herodes cahni de Juan. Te yúhú de jeē quɨtɨ̄ ni ñayuu, chi ndɨhɨ i jéni ndije ni i jeē ɨɨn tēe nácani jnūhun Yaā Dios cúu Juan. ");
INSERT INTO mibNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Te ɨɨn quɨvɨ̄ ni sáha Herodes ɨɨn vico quɨvɨ̄ ní cacu de. Te sēhe sɨ́hɨ́ Herodías ni quɨ̄vɨ i ni jita jéhé i nuū ñáyuu ní cana de ún. Te ni cusɨɨ̄ ni Herodes ni sáha i. ");
INSERT INTO mibNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Te ni jejnūhun téyɨ́ de jeē cuáha de núu na vé cacān i nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Te ni jehēn i ni cajnūhún i náná i na vé cacān i. Te ni ndɨ̄vɨ i nuū Herodes, te ni cahān i: Cuāha ní xínī Juan tēe scuándute, cone nuū ɨɨn cohō, achí i. ");
INSERT INTO mibNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yūcuán na te rey Herodes ni cucuíhyá ni de. Te sɨquɨ̄ jeē ni jéjnūhun téyɨ́ de, jíín jéē ní cajini sōho tēe cáyeji staā jiín de, jeē yúcuan ní ndacu de jniñu jeē na cuáha nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Te ni tají de soldado jeē na quícahnde xinī Juan ini vecāa. ");
INSERT INTO mibNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Te ni quee soldado un jíín xínī Juan, íne nuū ɨɨn cohō, te ni jēhe nuū súchi sɨ́hɨ́ un. Te máá i ni jendeca i nuū naná i. ");
INSERT INTO mibNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yūcuán na te ni jengoo tēe cáscuáha jíín Juan, te ni candonehen de yɨquɨ cúñu Juan, te ni cachindūji de. Yūcuán na te ni jengoo de ni cacastūhún de nuū Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Te ná ni jini Jesús jnūhun, te ni cujiyo ya yūcuan cuáhān yā jiín barco, jeē cóne sɨ́ɨn ya ɨɨn lugar nuū tú ñayuu. Te ni cajini ñayuu jeē cuahán yā. Te tācá ñuu ni quendacoo i cájica jéhé i, cuajnahan i ya. ");
INSERT INTO mibNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Te nuū ní quenda Jesús ini barco, te ni jito ya ñayuu cuehē ún. Te ni cundáhú ni yā i, te ni nasávāha ya tāca ñáyuu cácuhū jeē véjicoo i jíín. ");
INSERT INTO mibNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Te nuū ní ini, te tēe cáscuáha jíín yá, ni quecoo de nuū yā, te ni cacahān de: Je ni ini, te yāhá chi tú na ñayuu yúcu. Núu súcuan te tají ní ñayuu na quíngoo i tācá ñuu, te cuaan i jeē cáji i. ");
INSERT INTO mibNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Te ni cahān Jesús jiín de: Tu jíni ñúhún quíngoo i, chi cuāha máá ró jeē cáji i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Te ni cacahān de jíín yá: Tú na vé cánevāha ná yáha, chi uhūn‑ni staā jiín úū‑ni chācá, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Te ni cahān yā jiín de: Cuāha na quíji, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Te ni cahān yā jiín ñáyuu un jéē na cúcōo i nuū íte. Te ni quihin ya ndɨhúhún staā jiín úū chācá un. Te ni ndacoto ya ichi ándɨvɨ́, te ni nacuatáhú yá. Te ni tahú cuéchí yá staā ún, te ni jēhe ya nuū tée cáscuáha jíín yá. Te máá de ni casaja de nuū ñáyuu cuehē ún. ");
INSERT INTO mibNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Te ndɨvii i ni cayeji, te ni candutú chíji i. Te ni canastútú de pedazo jeē ní quendōo, te ni chitú úxī uū jīca. ");
INSERT INTO mibNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Te tēe ni cayeji un cúu nájnūhun uhūn mil, te sɨ́ɨn ga cúu ñahan jíín súchi lúlí. ");
INSERT INTO mibNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yūcuán na te ni cahān‑ni Jesús jiín tée cáscuáha jíín yá jeē na quɨ́vɨcoo de barco, te cosnūú de quingoo de nde ɨnga lado mar, níní jéē nátají yá ñayuu un quínungoo i. ");
INSERT INTO mibNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Te nuū ní cuu ni nacuatáhú yá nuū i, te máñúhún‑ni ya ni caa ya yucu, cuacacān tahú yā. Te ni cuaa, te íne máñúhún yá yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Te barco un, je ni cuu sava nuū mar cuahān. Te ndute mar un nátundahá níhin barco, chi vēji tachī ichi núú de. ");
INSERT INTO mibNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Te jeē yɨ́nee gā ni quee Jesús nuū de, jíca jéhé yá nuū mar. ");
INSERT INTO mibNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Te tēe cáscuáha ún, ni cajito de ya jeē jíca ya nuū mar. Te ni candondava de, te ni cacana cóhó de jeē cáyūhú de. Jíhná cúu, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Te ni cahān‑ni Jesús jiín de: Ndeyɨ́ coo ni rō, te ma yūhu ró, chi máá rí cúu, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yūcuán na te ni cahān Pedro jiín yá: Núu máá ní cúu, te cahān ni jíín ná jéē na cáca jéhé ná nuū mar te jeē na núū ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Te ni cahān yā: Nehen núu súcuan, áchí yá. Te ni quenda Pedro ini barco, te ni jica de nuū ndúte cuahān de nuū Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Te nuū ní jini de jeē níhin yɨ́hɨ tachī, te ni yūhú de. Te ni quejéé de quée de chīji ndute. Te ni cana cóhó de: Jnama ní sáña, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Te Jesús ni jnɨɨ‑ni ya ndaha de. Te ni cahān yā jiín de: Tēe tu cándíje nīhin cúu ró. ¿Naun ni nayūhu ró? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Te ni quɨ̄vɨ ya ini barco un jíín de, te ni jecuɨñɨ̄‑ni tachī. ");
INSERT INTO mibNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yūcuán na te tēe cáhīin ini barco un, ni cajecuɨñɨ̄ yɨtɨ́ de nuū yā. Te ni cacahān de: Jendaá ndije jeē Sēhe Yaā Dios cúu ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Te ni quenda jíyo ya jiín de nuū mar un, ní jinū yā región Genesaret. ");
INSERT INTO mibNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Te ñayuu yūcuan ní canacuni i ya. Te ni cascáca i jnūhun tācá ndañúū yūcuan jéē ni jínū yā. Te ñayuu ni caquindeca i ñayuu cácuhū nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Te ni cacahān ndahú i jíín yá jeē na quéhé i vēsú yusáhma ya. Te tāca ñáyuu jeē ní caquehé sahma ya, ni canduvāha i. ");
INSERT INTO mibNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yūcuán na te jecu tēe grupo fariseo jiín tée cástéén tutu ley Yaā Dios, ni quendacoo de ñuu Jerusalén, te ni quecoo de nuū yā. Te ni cacahān de jíín yá: ");
INSERT INTO mibNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Tēe cáscuáha jíín ró, ¿naun cástɨ́vɨ de costumbre jeē ní cajequin ñayuu jenahán? Chi tu ní cásquícu de costumbre jeē nándahá de nuū yā te caji de staā. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Te Jesús ni cajnūhun yá de: Te máá ró jijnáhan ró, ¿suni naun cástɨ́vɨ ró jniñu ní ndacu Yaā Dios nuū rō? Chi sa costumbre maá ró cúu jeē casquícu ró. ");
INSERT INTO mibNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Chi ni cahān Yaā Dios: Coo yɨ́ñúhún ró jiín tátá rō jiín náná rō. Te núu ndé ɨɨn cahān sɨquɨ̄ tatá chí sɨ́quɨ̄ naná, na cúū nahín, áchí Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Te máá ró chi cácahān rō jeē cuu cahān ɨɨn tēe jíín tátá de jíín náná de: Ma cúu chindéé ñáhán ná níhín cuáha na jéē cáji ni jéē cúhun ní, chi ndɨhɨ jeē névāha ná, je ni socō na núū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Te tēe cahān súcuan, tuá cánuú chindéé ñáhán de tátá de náná de, áchí ró jijnáhan ró. Te súcuan cástɨ́vɨ ró jniñu ní ndacu Yaā Dios, jeē sɨquɨ́ costumbre ni cajequin máá ró. ");
INSERT INTO mibNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tēe stáhú‑ni cácuu ró. Ndaā ni nacani Isaías jnūhun sɨquɨ̄ rō nde jenahán, yósó núū tútu iī jeē ni cáhān Yaā Dios: ");
INSERT INTO mibNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ñayuu yáha chi máá yuhu‑ni i cájetáhú i ruhū, te nasūu ndé jiín ini jiín ánuá i. ");
INSERT INTO mibNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Te cáchiñúhún sáá‑ni i ruhū, chi jnūhun cástéén i cúu jniñu ní candacu tēe, te nasūu jéē ní ndacu máá rí cúu. Achí Yaā Dios. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Te ni cana ya ñayuu cuehē ún, te ni cahān yā jiín i: Cuni sōho vāha jíjnáhan ró, te chuhun ni rō: ");
INSERT INTO mibNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nasūu jéē quɨ́vɨ ini yuhu ñayuu cujnéhén i sáha. Chi jnūhun jeē quénda yuhu i, yūcuan cúu jeē cujnéhén i sáha, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yūcuán na te tēe cáscuáha jíín yá, ni quecoo de nuū yā, te ni cacahān de: ¿A jíní ni jéē ní caquɨtɨ̄ ni tēe fariseo jeē ní cajini sōho de jnūhun ni cahān ní? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Te ni cahān maá yá: Cácuu de nájnūhun yujnu jeē tu ní náchuhun Tátá rī, Yaā ndeé andɨvɨ́, te ɨɨn quɨvɨ̄ te jnuhun ya quihīn. ");
INSERT INTO mibNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Na quíngoo máá de. Chi cácuu de nájnūhun tēe cuáá cástéén ichi nuū ɨnga tēe cuáá. Chi núu ɨɨn tēe cuáá stéén de ichi nuū ɨnga tēe cuáá, te ndɨndúú de nɨnga de xehvā. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Te ni cahān Pedro jiín yá: Castūhun cájí ní jnúhun yátá yáha nuū na jíjnáhan ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Te ni cahān Jesús: ¿Te á suni máá ró ná tu jecūhun ni rō chí naún? ");
INSERT INTO mibNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A tu cájecūhun ni rō jeē tāca jéē yéji ñayuu, chi quɨ́vɨ chīji i, te quénda‑ni cuahān? ");
INSERT INTO mibNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Te jnūhun jeē quénda yuhu ñayuu, chi nde ini anuá i vēji, te yūcuan cúu jeē cujnéhén i sáha. ");
INSERT INTO mibNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Chi nde ini anuá ñayuu quénda jeē jéni néé ni, jeē jéhni ndɨ̄yɨ, jeē casɨ́quɨ́ ndéē jnáhan, jeē jíca jnéní, jeē sacuíhná, jeē cahán jnūhun stáhú, jeē cahán yāa sɨ́quɨ̄ jnáhan. ");
INSERT INTO mibNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tāca jéē yáha cúu jeē cujnéhén ñayuu sáha. Te núu tu squícu i costumbre jeē nándahá i te caji i staā, tu cúnéhén i sáha. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Te ni quenda Jesús yūcuan cuáhān yā región Tiro jiín Sidón. ");
INSERT INTO mibNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Te ɨɨn ñahan ñuu Canaán, néne ña región Tiro jiín Sidón, te ni quee ña nuū Jesús. Te ni cana jee ña: Tátā, Sēhe yucūn David, cundáhú ni ni sáña víī. Chi sēhe sɨ́hɨ́ ná, ñúhun tachī ini i, te yōhyo xeēn ndóho i, áchí ña jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Te tu ní cáhán cuɨtɨ yā jeē ni cáhān ña. Yūcuán na te ni quecoo tēe cáscuáha jíín yá, te ni cacahān de: Cahān ni jíín ña na quíhín ña, chi cána jee ña vēji ña yatā yō, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Te ni cahān yā jiín ña: Nuū maá‑ni ñayuu nación Israel ni tají Yaā Dios sāña véji ná, chi cácuu i nájnūhun lanchi, quɨtɨ ní sana. ");
INSERT INTO mibNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Te ñahan ún chi ni quee ña, te ni jecuɨñɨ̄ yɨ̄tɨ́ ña nuū yā, te ni cahān ña: Tátā, chindéé ñáhán ní sáña víī, achí ña. ");
INSERT INTO mibNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Te ni cahān yatá yá jiín ña: Tu íyó váha jeē quénde yō staā sēhe, te cuāha yó núū ína, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Te ni cahān ña: Jendaá cahán ni Tátā, te chindéé ñáhán ní sáña vēsú cúu ná nájnūhun ina. Chi suni máá tɨ́ cánihīn nahín tɨ́ pedazo staā cuechí jéē cóyo chīji mesa jitoho tɨ̄ cáyeji tɨ̄, achí ña jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yūcuán na te ni cahān Jesús: Yōhyo vāha jeē cándíje nīhin ní súcuan, nánā. Te na sáha ná jéē cuní ni, áchí yá. Te máá hora un ní nduvāha‑ni sēhe sɨ́hɨ́ ña. ");
INSERT INTO mibNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Te ni quenda Jesús cuahān yā yūcuán, te ni yāha ya yumar Galilea. Te ni caa ya ɨɨn yucu, te yūcuan ní cucōo ya. ");
INSERT INTO mibNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Te cuehē ñayuu ni quecoo i nuū yā, te cándeca i tāca jéē cájica chácuá, jeē cuaá, jeē ñɨhɨ́n, jeē cacúhndú, jíín cuéhē gā ñayuu cácuhū. Te ni cajequin i nuū jehé Jesús. Te ni nasávāha ya i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Te ni canaa ni ñayuu un cájito i jeē nácahān ñayuu ñɨhɨ́n, ndúvāha ñayuu cuhndú, nácaca vāha ñayuu chacuá, nánune tɨnūu ñáyuu cuaá. Te ni cacahān i jeē yóhyo vāha Yaā cúu Yaā Dios ñuu i Israel. ");
INSERT INTO mibNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yūcuán na te ni cana Jesús tēe cáscuáha jíín yá, te ni cahān yā jiín de: Cúndáhú ni rī ñayuu cuehē yāhá, chi je ni cuu unī quɨvɨ̄ cáyūcú i jíín rí, te tuá na vé caji i. Te tu cúní rī natají rí i nuhun ndite i, chi núu súcuan te sava ichi te cuīta íī i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Te ni cacahān tēe cáscuáha jíín yá: ¿Te ndé nuū nihín yō staā caji ñayuu cuehē yāhá? Chi yāhá tú na ñayuu yúcu, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Te ni cajnūhun yá de: ¿Nasaa staā cánevāha ró? Te ni cacahān de: Uxā‑ni, jíín jecu chācá lúlí, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yūcuán na te ni cahān yā jiín ñáyuu cuehē un jéē na cúcōo i. ");
INSERT INTO mibNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Te ni quihin ya ndɨhúxá staā jiín cháca ún, te ni nacuatáhú yá nuū Yaā Dios. Te ni tahú cuéchí yá, te ni jēhe ya nuū tée cáscuáha jíín yá, te máá de ni casaja nuū ñáyuu. ");
INSERT INTO mibNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Te ndɨhɨ i ni cayeji, te ni candutú chíji i. Yūcuán na te ni canastútú de pedazo jeē ní quendōo, te ni chitú úxā jīca. ");
INSERT INTO mibNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Te tēe ni cayeji ún, nde cuūn mil de cúu, te sɨ́ɨn ga cúu ñahan jíín súchi lúlí. ");
INSERT INTO mibNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yūcuán na te ni nacuatáhú yá nuū ñáyuu ún, te cuanungoo i. Te ni ndɨ̄vɨ ya ini barco, te cuahān yā región Magdala. ");
INSERT INTO mibNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Te ni quecoo tēe grupo fariseo jiín tée grupo saduceo nuū yā. Chi cácuni de coto ndee de ya, te ni cajicān de jeē na sáha ya ɨɨn jniñu jéhnu jeē coo ɨɨn seña ichi ándɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Te máá yá ni cahān yā jiín de: Núu ni ini, te cácahān rō: Nandii, chi ni nasácuéhé i andɨvɨ́, áchí ró. ");
INSERT INTO mibNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Te jenéhen chi cácahān rō: Vijna te cuun saū, chi ni nasácuéhé i andɨvɨ́, áchí ró. Tēe stáhú‑ni cácuu ró. Chi cájecūhun ni rō ndese stéén seña andɨvɨ́, te tu cájecūhun ni rō ndese stéén tācá jniñu jéhnu sáha ri tiempo yáha. ");
INSERT INTO mibNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ñayuu yáha jeē casáha jniñu néé, tu cájetáhú cuɨtɨ i Yaā Dios. Te cájicān i jeē sáha ri ɨɨn jniñu jéhnu jeē coo ɨɨn seña andɨvɨ́. Te tuá na ɨnga jniñu jéhnu stéén rī nuū i, chi máá‑ni jniñu jéhnu nájnūhun ni cuu jíín Jonás, tēe ni nacani jnūhun Yaā Dios nde jenahán. Achí yá. Te ni stóo ya de jíjnáhan de, te cuahān yā. ");
INSERT INTO mibNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Te tēe cáscuáha jíín yá ni canaa ni de condiso de staā náa cuangoo de jíín barco ɨnga lado mar. ");
INSERT INTO mibNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Te ni cahān Jesús jiín de: Coto má candíje ró levadura tēe grupo fariseo jiín tée grupo saduceo, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Te tēe cáscuáha un ní cacahān maá de: Va sɨquɨ̄ jeē tú na staā ndíso yó, jeē yúcuan cáhán yā súcuan, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Te ni jini Jesús, te ni cahān yā: ¿Najehē cácahān rō jeē ni cáhān rī súcuan sɨquɨ̄ jeē tú na staā cándiso ró? Tēe tu cándíje nīhin cácuu ró. ");
INSERT INTO mibNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿A ná tu jecūhun ni rō jeē tu ní cáhán rī súcuan sɨquɨ̄ jeē tu ndíso ró stáā? ¿A tu cánucūhun ni rō jeē ní tahú cuéchí rí uhūn staā ni cayeji uhūn mil tēe, te nasaa jīca ni canastútú ró jeē ni quéndōo? ");
INSERT INTO mibNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Te á tu cánucūhun ni rō jeē ní tahú cuéchí rí uxā staā ni cayeji cuūn mil tēe, te nasaa jīca ni canastútú tucu ró? ");
INSERT INTO mibNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Te najehē tu cájecūhun ni rō jeē násūu sɨ́quɨ̄ staā ni cahān rī jiín ró jeē ni cáhān rī jeē coto má candíje ró levadura tēe fariseo jiín tée saduceo? Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yūcuán na te ni cajecūhun ni de jeē tu ní cáhán yā jeē coto de jeē ma cáji de pan jeē yɨ́hɨ levadura, chi sa suhva ni cahān yatá yá jeē ma cándíje de jnūhun stáhú cástéén tēe fariseo jiín tée saduceo. ");
INSERT INTO mibNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Te nuū ni jínū Jesús región Cesarea Filipo jiín tée cáscuáha jíín yá, te ni cajnūhun yá de: Ruhū, Yaā ní nduu tēe, ¿ndé ɨɨn cúu ri cácahān ñayuu? ");
INSERT INTO mibNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Te ni cacahān de: Sava i cácahān jeē cúu ní Juan tēe ni scuándute. Te sava ga i cácahān jeē cúu ní Elías, tēe ni nacani jnūhun Yaā Dios nde jenahán. Te sava ga i cácahān jeē Jeremías chí ɨnga tēe ni nacani jnūhun Yaā Dios cúu ní. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Te ni cahān yā jiín de: Te máá ró, ¿ndé ɨɨn cúu ri cácahān rō? achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Te ni cahān Simón Pedro: Máá ní cúu Cristo, Yaā ní tají Yaā Dios. Te cúu ní Sēhe Yaā Dios, Yaā técu nɨɨ́ cáni, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Te ni cahān Jesús: Yōhyo ndetū rō, Simón sēhe Jonás, chi nasūú ɨɨn ñayuu ni steén jnūhun yáha nuū rō, chi sa suhva máá Tátá rī, Yaā ndeé andɨvɨ́, ní steén yā nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Te ruhū suni cáhán rī jiín ró jeē maá ró cúu Pedro, jeē cuní cahān: yuū. Te jnūhun ndaā jeē ni cáhān rō jeē maá rí cúu Cristo, suu cúu nájnūhun ɨɨn yuū cáhnu. Te sɨquɨ̄ yuū cáhnu yáha sáha ri jeē quítuu vehe, te vehe un cúu ñayuu cácandíje ruhū. Te tu ndé vé cundeyɨ́ cuɨtɨ sɨquɨ̄ i, ni jnūhun xeēn jeē cájihī i, tuá na vé cúu sáha jíín ánuá i. ");
INSERT INTO mibNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Te máá ró condiso jníñu ró sáha ró jéē quɨ́vɨcoo ñayuu ndaha Yaā andɨvɨ́ jeē ndacu ya jniñu nuū i. Te tāca jéē cásɨ rō jeē ma sáha ñayuu ini ñayɨ̄vɨ yáha, suni casɨ jeē cáyūcú nde andɨvɨ́. Te tāca jéē cuáha ró jnúhun sáha i ini ñayɨ̄vɨ yáha, suni jeē cáyūcú nde andɨvɨ́ cuáha jnūhun. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yūcuán na te ni ndacu ya jniñu nuū tée cáscuáha jíín yá, jeē ma cáchi de nuū ní ɨɨn ñayuu jeē cúu ya Cristo. ");
INSERT INTO mibNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Te nde saá ní quejéé Jesús cástūhun cájí yá nuū tée cáscuáha jíín yá jeē jíni ñúhún quihīn yā ñuu Jerusalén. Te tāca tée jéhnu jíín sútū cácujéhnu jíín tée cástéén tutu ley, stóho ndasɨ́ de ya. Te cahni de ya, te nuū uní quɨvɨ̄ te natecu yā, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yūcuán na te Pedro, ni cana máñúhún de ya, te ni quejéé de cáhán de nuū yā: ¿Naun cáhán ni súcuan? Chi tu cúní Yaā Dios jeē cuu súcuan. Tu jíni ñúhún cuɨtɨ ndoho ní jnúndóho yáha, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Te ni ndió cóto ya nuū Pedro, te ni cahān yā jiín de: Cujiyo quihīn rō, chi cáhán rō ná cáhán Satanás. Chi tēe ndúcú stɨ́vɨ rúhū cúu ró. Te tu jéni ni rō nájnūhun jéni ni Yaā Dios, chi sa suhva jéni ni rō nájnūhun cájeni ni ñayuu. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yūcuán na te ni cahān yā jiín tée cáscuáha jíín yá: Na‑ni ñayuu núu cúní i condiquīn i ruhū, na cásɨ i jeē cuní maá i, te na cóndiquīn i ruhū te cuāha i jnūhun ndoho i jnūndóho jeē sɨquɨ́ rī, vēsú na cúū i. ");
INSERT INTO mibNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Chi núu ndé ñáyuu cuní i cācu i nuū jnúndóho quiji nuū i jeē sɨquɨ́ ruhū, núu súcuan te jnahnū ndetū i nɨ́ɨ́ cáni. Te núu ndé ñáyuu, vēsú na cúū i jeē sɨquɨ́ ruhū, te cotecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Chi ndé cuajníñu vēsú na cúndeyɨ́ ñáyuu nihīn i nɨ́ɨ́ ñáyɨ̄vɨ́, te núu quɨ̄vɨ i nuū jnahnú ndetū i? Chi tú na jiín cuɨtɨ chunaa ñayuu jeē cácu ánuá i. ");
INSERT INTO mibNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Chi ruhū, Yaā ní nduu tēe, ndiji ri jiín táca ndajéhé rī, te yōhyo luu cujéhnu ri nájnūhun cújéhnu Tátá rī. Yūcuán na te cuāha ri tahū nuū ɨɨn ɨɨn ñayuu núu ndese jniñu ni casáha i. ");
INSERT INTO mibNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Te jendaá cahán rī jiín ró jeē sava tēe cáhīin yāhá, ma cúū de chi nde cuni de jeē maá rí, Yaā ní nduu tēe, ndácu ri jniñu jíín poder rī. ");
INSERT INTO mibNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yūcuán na te nuū iñú quɨvɨ̄ te Jesús ni jeca ya Pedro jiín Jacobo jiín Juan ñani Jacobo, cuahān sɨ́ɨn ya jiín de ɨɨn yucu súcún. ");
INSERT INTO mibNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Te yūcuán, tucu ni nduu ya nuū de. Chi ni ndindēe núū yā nájnūhun niāndii. Te sahma ya ni nducuíjín quɨyɨ ndasɨ́, nájnūhun nduva luz. ");
INSERT INTO mibNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Te ni cajito‑ni de jeē Moisés jiín Elías, tēe ni cahīyo jenahán, cándajnūhún de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Te ni cahān Pedro jiín yá: Nacā jeē váha jeē cáhīin ná yáha. Te núu cúní ni te na sáha ná únī vehe ramada, ɨɨn cuu máá ní, ɨnga cuu Moisés, te ɨnga cuu Elías, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Te níní cáhán gā de, te ni quiji vicō nūhun jéē yaa ndasɨ́, ni jesɨ‑ni nuū de. Te nuū vicó un ní cahān ɨɨn jnūhun: Yāha cúu Sēhe ri jeē maní ndasɨ́ rí jiín, te cúsɨɨ̄ ni rī jiín. Na cúni nahín ró jnūhun cáhán yā. Achí. ");
INSERT INTO mibNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Te jeē súcuan ni cajini sōho tēe cáscuáha ún, te ni cajecava ndeyɨ de, chi yōhyo ni cayūhú de. ");
INSERT INTO mibNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yūcuán na te ni quee Jesús, te ni soó yá ndaha ya sɨquɨ̄ de. Te ni cahān yā: Ndocuɨñɨ̄, te ma yūhu ró jijnáhan ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Te ni candacoto de, te tuá tēe un ní cájito de, chi máá ɨɨn na Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Te ni cananuu de jíín yá yucu ún. Te ni ndacu ya jniñu nuū de: Ma cáchi rō nuū ní ɨɨn jeē súcuan ni cajito ró, chi nde na nátecu maá rí, Yaā ní nduu tēe, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yūcuán na te tēe cáscuáha jíín yá, ni cacajnūhún de ya: Núu súcuan te tēe cástéén tutu ley Yaā Dios, ¿najehē cácahān de jeē cánuú ndiji Elías xīhna gā, te sáá te quiji Yaā cúu Cristo? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Te ni cahān Jesús jiín de: Jendaá cúu jeē xíhna gā quiji ɨɨn tēe cuu nájnūhun Elías, te sátūhva de ndɨhɨ, áchí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Te cáhán rī jiín ró jeē jé ni quiji tēe ni cuu nájnūhun Elías, te tu ní jíní ñayuu jeē suu de cúu. Te ni casáha ndevāha ñayuu jiín de ndɨhɨ jeē ní cacuu ni maá i. Te suni súcuan stóho i ruhū, Yaā ní nduu tēe. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yūcuán na te tēe cáscuáha un, ní cajecūhun ni de jeē cahán yā jeē Juan tēe scuándute, ni cuu de nájnūhun Elías. ");
INSERT INTO mibNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Te ni najinū yā jiín de nuū ñáyuu cuehē ún. Te ni quee ɨɨn tēe, ni jecuɨñɨ̄ yɨtɨ́ de nuū yā, te ni cahān de: ");
INSERT INTO mibNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Cundáhú ni ni séhe yɨɨ́ ná, chi yōhyo xeēn ndóho i cuehyɨ̄ jíhí yɨ̄hɨ́. Te je ni cuu cuehē jínu cótúú i nuū ñuhún jíín núū ndúte. ");
INSERT INTO mibNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Te ni quindeca ná i nuū tée cáscuáha jíín ní, te tu ní cúu sávāha de i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Te ni cahān Jesús: Ñayuu yōhyo nīhni ni cácuu ró chi tu cácandíje ró jéē cuu nduvāha i. ¿Nasaa ga quɨvɨ̄ condee rī jiín ró? ¿Te nasaa ga quɨvɨ̄ cuandeyɨ́ ni rī jiín ró? Cuáquihin sūchí un na quíji i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Te ni cahān yā nuū tachí, te ni quenda‑ni ini sūchí un. Te ni nduvāha‑ni i máá hora un. ");
INSERT INTO mibNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yūcuán na te tēe cáscuáha un, ní cacajnūhun sɨ́ɨn de ya: ¿Najehē tu ní cúu quenehen ná tachī un jíjnáhan ná? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Te ni cahān yā: Sɨquɨ̄ jeē tu cácandíje nīhin ró jéē cuu sáha ró. Chi jendaá cahán rī jiín ró, jeē núu candíje ró vēsú ɨɨn tíhlí‑ni, cūhva nájnūhun ɨɨn ndɨquɨn mostaza, te cuu sáha ró táca‑ni jniñu yɨɨ́. Chi cuu cahān rō jeē na cújiyo yucu yáha quihīn ɨnga lado, te cujiyo‑ni. Te tācá‑ni jniñu chi cuu sáha ró, te núu candíje nīhin ró jéē cúu. ");
INSERT INTO mibNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Te ɨɨn tachī súcuan chi ma quénda cuɨtɨ quihīn, te núu tu cacān tahú rō te coo ndite ni rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Te jíca cuu Jesús jiín de jíjnáhan de región Galilea, te ni cahān yā jiín de: Máá rí, Yaā ní nduu tēe, nastúu i ruhū nuū tāca tée xeēn. ");
INSERT INTO mibNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Te cahni de ruhū, te nuū uní quɨvɨ̄ te natecu rī, achí yá. Te ni canducuíhyá ndasɨ́ ni de jeē ni cáhān yā jnūhun yáha. ");
INSERT INTO mibNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Te ni jinū yā ñuu Capernaum jiín tée cáscuáha jíín yá. Te tēe cástútú xúhun templo ni quecoo de, te ni cacajnūhún de Pedro: Te maestro maá ró jijnáhan ró, ¿á tú cuāha de xūhún cuajníñu ini templo, chí naún? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Te ni cahān Pedro: Cuu, áchí de. Te ná ni quɨ̄vɨ de ini vehe, te xīhna gā Jesús ni cahān yā jiín de: ¿Ndese jéni ni rō, Simón? Tāca tée cácuu rey ini ñayɨ̄vɨ yáha, ¿ndé núū cájicān de xūhun renta jiín xúhun cuajníñu ñuu? ¿A núū séhe de chí núū ñáyuu sɨ́ɨn vehe? áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Te ni cahān Pedro: Nuū ñáyuu sɨ́ɨn vehe, áchí de. Te ni cahān Jesús: Núu súcuan te tú na ɨnga cujéhnu nuū séhe rey jeē cacán xūhún un núū i. Súcuan ni cahān yā jeē cujéhnu ya cúu ya Sēhe Yaā Dios. Te ni cahān yā: ");
INSERT INTO mibNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Te na chúnaa yō, návāha tu squɨ́tɨ́ ni yō de. Núu súcuan te cuáhán ndé yumar, te scáne ró gancho jeē jnɨ́ɨ chācá, te tava rō chācá jéē jnɨ́ɨ xīhna gā. Te ndɨca rō yuhu tɨ, te yūcuan níhīn rō ɨɨn xūhun jéē cánda chunaa rō jeē cájicān de. Te quindēca ró núū de jeē cúu ruhū jiín róhó. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Te suni quɨvɨ̄ un ní quecoo tēe cáscuáha un núū yā, te ni cacajnūhún de ya: ¿Ndé ɨɨn cújéhnu ga nuū ñáyuu jeē ndácu Yaā andɨvɨ́ jniñu nuū? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Te ni cana ya ɨɨn sūchi lúlí, te ni jeni ya i mēhñú de. ");
INSERT INTO mibNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Te ni cahān yā: Jendaá cahán rī jiín ró, núu tú nandió cóo ni rō te cani ni rō nájnūhun ɨɨn sūchi lúlí, ma quɨ́vɨ cuɨtɨ rō ndaha Yaā andɨvɨ́ jéē ndacu ya jniñu nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Núu súcuan te ñayuu jeē jéni ni i jeē tu cújéhnu i, nájnūhun jéni ni sūchi lúlí yáha, suu i cújéhnu ga nuū ñáyuu jeē ndácu Yaā andɨvɨ́ jniñu nuū. ");
INSERT INTO mibNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Te na‑ni ñayuu núu jeē sɨquɨ́ ruhū jetáhú i ɨɨn sūchi lúlí nájnūhun sūchi yáha, te ruhū jetáhú i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Te núu ɨɨn sūchi lúlí yáha cándíje i ruhū, te núu quɨ̄vɨ i cuēchi sáha na‑ni ñayuu, te vāha ga núu ni conuhnī ɨɨn yōso cáhnu sucūn ñayuu ún, te quēe i chīji ndute mar nuú. ");
INSERT INTO mibNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nacā xeēn cúu jíín ñáyuu ñayɨ̄vɨ́, chi máni íyó jéē nducú squɨ́vɨ ñayuu nuū cuéchi. Te máni súcuan coo ini ñayɨ̄vɨ́. Te nacā xeēn ndoho ñayuu jeē squɨ́vɨ jnáhan nuū cuéchi. ");
INSERT INTO mibNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Núu súcuan te núu ndaha ró chí jéhē rō sáha jeē quɨ́vɨ ró cuéchi, vāha ga cahnde rō te scáne ró na quíhín, návāha tuá sáha ró cuéchi. Chi vāha ga jeē coo chácuá ró chí coo tɨ́cúhndu ró te quɨ̄vɨ ró núū cotecu rō nɨɨ́ cáni, vēsú jeē cóndee ndɨndúú ndaha ró jéhē rō te quɨ̄vɨ ró núū ñuhún jeē cayú nɨɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Te núu tɨnūu ró sáha jeē quɨ́vɨ ró cuéchi, vāha ga tava rō te scáne ró na quíhín, návāha tuá sáha ró cuéchi. Chi vāha ga jeē coo ɨɨn‑ni tɨnūu ró te quɨ̄vɨ ró núū cotecu rō nɨɨ́ cáni, vēsú jeē cóndee ndɨndúú tɨnūu ró te quɨ̄vɨ ró núū ñuhún infierno. ");
INSERT INTO mibNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Coto ma sájéē ni rō nuū ní ɨɨn sūchi lúlí yáha. Chi cáhán rī jiín ró jeē tācá ndajéhé andɨvɨ́ jéē ndíto ya i, níní cáhīin ya nuū maá Tátá rī andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Chi ruhū, Yaā ní nduu tēe, vēji ri jeē jnáma ri ñayuu jeē ní sana i nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Te ndese cájeni ni rō? Núu ɨɨn tēe ndéca de ɨɨn ciento lanchi, te núu sana ɨɨn tɨ, ¿á tu stóo de cuūn xico xahūn cuūn gā tɨ̄ yucu, te ndicó de quinanducú de quɨtɨ ní sana ún? ");
INSERT INTO mibNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Te núu ni nanihīn de tɨ, te ndaā jeē yóhyo ga cúsɨɨ̄ ni de jíín quɨtɨ ún vēsú jiín cúūn xico xahūn cuūn gā quɨtɨ jeē tu ní sána. ");
INSERT INTO mibNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Te suni súcuan máá Tátá rō, Yaā ndeé andɨvɨ́, tu cúní yā jeē jnahnú ndetū ni ɨɨn sūchi lúlí yáha. ");
INSERT INTO mibNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Te núu jnáhan ró ní sáha de cuēchi sɨquɨ̄ rō, núu súcuan te castūhun ró nuū mañúhún‑ni de jeē ni sáha de cuēchi sɨquɨ̄ rō. Te núu ni jetáhú de jnūhun ni cahān rō jiín de, núu súcuan te je ni ndumanī de jíín ró ni sáha ró. ");
INSERT INTO mibNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Te núu tu ní jétáhú de jnūhun cáhán rō, te quicāna ró ɨɨn chí úū gā ñayuu quihīn rō jiín núū de, cuu i testigo jiín ró, te cundaā cuēchi de te ndumanī de jíín ró. ");
INSERT INTO mibNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te núu tu ní jétáhú tucu de jnūhun cácahān tēe ún, yūcuán na te castūhun ró nuū ñáyuu cácandíje. Te núu tu ní jétáhú tucu de jnūhun cahān ñayuu cácandíje ún, te siáá rō de na cóo de nájnūhun ɨɨn tēe tu cándíje nuū Yaā Dios chí tée stútú xúhun renta. ");
INSERT INTO mibNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Jendaá cahán rī jiín ró jéē tāca jéē cásɨ rō jeē ma sáha ñayuu ini ñayɨ̄vɨ yáha, suni casɨ jeē cáyūcú nde andɨvɨ́. Te tāca jéē cuáha ró jnúhun sáha i ini ñayɨ̄vɨ yáha, suni jeē cáyūcú nde andɨvɨ́ cuáha jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Te suni cáhán rī jiín ró, núu uū jnáhan ró ini ñayɨ̄vɨ yáha, ɨnuú cani ni rō sɨquɨ̄ ɨɨn jeē cacán tahú rō, núu súcuan te máá Tátá rī andɨvɨ́ cuāha ya jeē cájicān rō. ");
INSERT INTO mibNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chi núu ndé mí ndútútú úū chí únī ñayuu jeē cáchiñúhún i ruhū, te yūcuan íne ri jiín i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yūcuán na te ni quee Pedro nuū yā, te ni cajnūhún de ya: ¿Nasaa jínu cone cáhnu ni na núū jnáhan ná jéē sáha de cuēchi sɨquɨ̄ ná? ¿A ndé uxā jínu chí naún? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Te ni cahān Jesús: Tu cáhán rī jiín ró jeē maá úxā jínu, chi nde uxā jínu jeē uní xico uxī. ");
INSERT INTO mibNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Núu súcuan te Yaā ndeé andɨvɨ́, suhva cúu jeē íne cáhnu ni yā nuū ñáyuu ndácu ya jniñu nuū: Cúu nájnūhun ɨɨn rey jeē cuní de sándaā de jíín mozo de jeē cátaū nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Te ni quejéé de sándaā de jíín i. Te ni caquindeca i ɨɨn mozo jeē taú tɨjnɨ millón peso nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Te tú na vé névāha mozo un chunaa nuū de. Te ni ndacu de jniñu jeē na cúyāhu mozo un jíín ñasɨhɨ́ jíín séhe jíín táca ndajníñu, te nucūnaa xūhun táú. ");
INSERT INTO mibNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yūcuán na te ni jecuɨñɨ̄ yɨtɨ́ mozo un, te ni cahān ndahú de jíín patrón de ún: Condetu ní, te na chúnaa ndɨhɨ ná xúhun ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Te máá patrón ni cundáhú ni de mozo de. Te ni ine cáhnu ni de jeē taú mozo de ún, te ni siaá de jeē ma chúnaa gā. ");
INSERT INTO mibNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Te ni quenda mozo un cuáhān de, te ni najnáhan‑ni de jíín ɨɨn jnáhan mozo de jeē taú jecu peso nuū de. Te ni jnɨɨ de tēe ún, te ni quitu de sucūn, te ni cahān de: Chunaa jeē taú rō nuū rī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Te jnáhan mozo de un ní jecuɨñɨ̄ yɨtɨ́ núū de, te ni cahān ndahú jíín de: Condetu te na chúnaa ndɨhɨ ri xūhun ró, achí. ");
INSERT INTO mibNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Te máá de tu ní cúní de, chi ni chune de tēe un vécāa nde quɨvɨ̄ nachunaa jeē taú nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Te tāca jnáhan mozo de ni cajito jeē súcuan ni sáha de, te ni cajnahuhū ndasɨ́ ni de. Te cuangoo de nuū patrón de, te ni cacachi de ndɨhɨ ndese ni cuu. ");
INSERT INTO mibNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yūcuán na te patrón un ní nacana de mozo un, te ni cahān de jíín: Mozo ndevāha cúu ró. Chi ni ine cáhnu ni rī ndɨhɨ jeē taú rō nuū rī, chi ni cahān ndahú ró jiín rí. ");
INSERT INTO mibNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Te nájnūhun ni cundáhú ni rī rohó, suni súcuan ni jini ñúhún cundáhú ni rō jnáhan mozo rō nuú, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Te ni quɨtɨ̄ ndasɨ́ ni patrón, te ni ndacu de jniñu jeē na quɨ́vɨ vecāa nde nachunaa ndɨhɨ jeē taú nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Te ni jīnu ni cahān yā, te áchí yá: Nájnūhun ni sáha rey un jíín mozo de, suni súcuan sáha máá Tátá rī andɨvɨ́ jíín táca róhó núu tu cone cáhnu ni rō nuū jnáhan ró nde jiín ini jiín ánuá rō, núu na‑ni cuēchi sáha i nuū rō. Achí yá jiín de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Te nuū ní ndɨhɨ ni cahān Jesús tāca jnúhun yáha, te ni quenda ya Galilea cuahān yā. Te ni jinū yā región Judea, ɨnga lado yūte Jordán, ichi núū cáne niāndii. ");
INSERT INTO mibNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Te cuehē ñayuu ni candiquīn i ya, te yūcuan ní nasávāha ya ñayuu cácuhū. ");
INSERT INTO mibNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yūcuán na te ni quecoo jecu tēe grupo fariseo nuū yā, chi cácuni de coto ndee de ya núu ndese cahān yā. Te ni cacajnūhún de ya: ¿A íyó ley jeē cuu ndusɨ́ɨn ɨɨn tēe jíín ñasɨhɨ́ de núu na‑ni sɨquɨ̄ cúu, chí naún? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Te ni cahān yā: ¿A tu ní cácahu ró tutu iī ndese ni sáha Yaā Dios ñayuu nde xīhna ñúhún? Chi tēe jíín ñahan ni sáha ya, achí. ");
INSERT INTO mibNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Te suni ni cahān Yaā Dios: Jeē yúcuan cúu jeē stóo tēe tátá de náná de, te quijnáhan de jíín ñasɨhɨ́ de, te ɨɨn na cuu ndɨndúú de, áchí Yaā Dios, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Núu súcuan te tuá cúu uū jnáhan de, chi ɨɨn na cúu. Jeē yúcuan tu íyó váha jeē stóo jnáhan, chi jeē ni squíjnáhan Yaā Dios cúu, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Te ni cacajnūhún de ya: Núu súcuan ¿te naun ni ndacu Moisés jniñu jenahán jeē núu stóo ɨɨn tēe ñasɨhɨ́ de, te na cúvāha acta jeē ndusɨ́ɨn de jíín ña? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Te ni cahān yā jiín de: Sɨquɨ̄ jeē níhni ni rō jijnáhan ró, jeē yúcuan ní jēhe Moisés jnūhun jeē stóo ró ñasɨhɨ́ ró. Te nde xīhna ñúhún chi nasūu súcuan ní cuu. ");
INSERT INTO mibNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Te ruhū chi cáhán rī jiín ró, núu ɨɨn tēe stóo de ñasɨhɨ́ de, te núu nasūu jéē tɨ́jnɨ ni ña, te quijnáhan de jíín ɨnga ñahan, núu súcuan te cásɨ́quɨ́ ndéē de ña. Te núu ɨɨn tēe condeca de ñahan ní ndusɨ́ɨn, suni cásɨ́quɨ́ ndéē de ña, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yūcuán na te ni cacahān tēe cáscuáha jíín yá: Te núu ma cúu stóo tēe ñasɨhɨ́ de, núu súcuan te vāha ga ma cóndeca de ñahan, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Te ni cahān yā jiín de: Jnūhun ni cahān rō yāhá, tu níhín jníñu nuū ndɨhɨ tēe, chi máá nene tēe jeē ni sáha Yaā Dios jeē nihín jníñu nuū. ");
INSERT INTO mibNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Chi íyó tɨjnɨ sɨquɨ̄ jeē jésɨ jeē ma cóndeca tēe ñahan. Chi sava tēe ni cacacu de jeē ma cúu condeca de ñahan. Te sava ga tēe ni sáha ñayuu jeē ma cúu condeca de ñahan. Te sava ga tēe ni cajeni ni maá de jeē ma cóndeca de ñahan sɨquɨ̄ jeē ndɨhvɨ́ ni de jíín jniñu jeē ndácu Yaā andɨvɨ́ nuū de. Tēe jeē cúu cuatáhú jnúhun jeē ma cóndeca de ñahan, na cuátáhú de núu súcuan. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yūcuán na te ni quecoo ñayuu jiín súchi lúlí, jéē na sóó yá ndaha ya xinī i te cacān tahú yā jehē i. Te tēe cáscuáha jíín yá, ni cacahān de nuū ñáyuu vējicoo jíín i. ");
INSERT INTO mibNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Te ni cahān Jesús: Cuāha jnūhun na quíjicoo sūchi lúlí jíñā nuū rī, te ma cásɨ rō jeē quíjicoo i. Chi ñayuu jeē ndió cóo ni i cani ni i nájnūhun sūchi yáha, suu i quɨ́vɨ ndaha Yaā andɨvɨ́ jéē ndacu ya jniñu nuū i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Te ni soó yá ndaha ya xinī i jíjnáhan i. Te ni quenda ya yūcuan cuáhān yā. ");
INSERT INTO mibNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Te ɨɨn tēe suchí ní quee de nuū Jesús, te ni cajnūhún de ya: Tēe vāha cúu ní Maestro. Te cachi ní, ¿na jniñu váha sáha ná te nihīn tahú na cotecu na nɨ́ɨ́ cáni andɨvɨ́? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Te ni cahān yā jiín de: ¿Naun cáhán rō jeē tée vāha cúu ri? Tú ni ɨɨn tēe vāha íyó, chi máá ɨɨn‑ni Yaā Dios. Te núu cúní rō cotecu rō nɨɨ́ cáni, te squícu ró jniñu ní ndacu ya. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Te ni cahān de: ¿Ndé‑ni jniñu cúu núu súcuan? Te ni cahān yā: Ma cáhni rō ndɨ̄yɨ. Ma cosɨ́quɨ́ ndéē jnáhan ró. Ma sacuíhná ró. Ma sajnúhún ró. ");
INSERT INTO mibNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Cuatáhú ró nuū tatá rō nuū naná rō. Te cundáhú ni rō jnáhan ró nájnūhun cúndáhú ni rō maá ró, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Te ni cahān tēe suchí un: Tācá jniñu yáha je ni squícu ná ndé ná lulí ná. ¿Te na vé cúmanī gā sáha ná núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Te ni cahān Jesús: Núu cúní rō squícu ndɨhɨ ró, cuáhán te xīco ró ndɨhɨ jeē névāha ró, te cuāha ró núū ñáyuu ndahú. Te nde andɨvɨ́ cuáha ya jeē ndetū ndasɨ́ coo ró. Yūcuán na te quiji ró condiquīn rō ruhū quihīn yō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Te tēe suchí un, ná ni jini sōho de jnūhun yáha, te ni cucuíhyá ni de te cuahān de, chi cúcá ndasɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yūcuán na te ni cahān Jesús jiín tée cáscuáha jíín yá: Jendaá cahán rī jiín ró, tēe cúcá chi yōhyo yɨɨ́ quɨ́vɨcoo de ndaha Yaā andɨvɨ́ jéē ndacu ya jniñu nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Te cáhán tucu ri jiín ró jeē yachī gā yāha ɨɨn camello yaū yutɨ́cuɨ, vēsú jeē quɨ́vɨ ɨɨn ñayuu cucá ndaha Yaā Dios jeē ndacu ya jniñu nuū i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Te tēe cáscuáha jíín yá, yōhyo ni canaa ni de jeē ní cajini de jnūhun yáha, te ni cacajnūhun jnáhan de: ¿Ndé ñáyuu cúu jeē cácu núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Te ni ndacoto Jesús nuū de, te ni cahān yā: Ñayuu chi ma cúu squɨ́vɨ i máá i ndaha Yaā Dios, te máá yá chi ndɨhɨ‑ni cuu sáha ya, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yūcuán na te ni cahān Pedro: Sāña jíjnáhan ná ní castóo ná ndɨhɨ jeē cánevāha ná, te cándiquīn na níhín. ¿Te na vé nihín na núu súcuan? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Te ni cahān Jesús jiín de: Ruhū, Yaā ní nduu tēe, jendaá cahán rī jiín ró jijnáhan ró jéē ɨɨn quɨvɨ̄ conene rī mesa ndacu ri jniñu, te yōhyo luu cujéhnu ri ini ñayɨ̄vɨ jéé. Te quɨvɨ̄ ún te máá ró jeē ní cacondiquīn rō ruhū, suni coyūcu ró nuū uxí uū mesa ndacu ró jniñu. Te sándaā rō jniñu ndɨhúxí uū yucūn ñayuu Israel. ");
INSERT INTO mibNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Te tāca ñáyuu jeē ni stóo vehe, chí ñani, chí cuáha, chí tátá, chí náná, chí ñasɨhɨ́, chí séhe, chí ñuhun, sɨquɨ̄ jeē cóndiquīn i ruhū, te nanihīn i ɨɨn ciento gā jeē súcuan. Te suni nihīn tahú i cotecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Te cuehē ñayuu jeē vijna cácuu i nuū, nduu i sandɨ̄hɨ́. Te ñayuu jeē vijna cácuu i sandɨ̄hɨ́, nduu i nuū. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Te suhva cúu jeē ndácu Yaā andɨvɨ́ jniñu nuū ñáyuu: Cúu nájnūhun ɨɨn tēe chíí ñuhun. Te ɨɨn nehen ni quenda de, ndúcú de tɨjnɨ mozo jeē taxín ndéhē uva de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Te ni sándaā de jíín mozo un jéē chúnaa de ɨɨn denario jeē quɨvɨ́. Te ni tají de tēe un cuángoo jeē taxín uva de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yūcuán na te ni quenda tucu de nájnūhun cahɨɨ̄n. Te ni jito de nuū sava ga tēe cáyūcu sáá‑ni de nuū yáhu. ");
INSERT INTO mibNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Te ni cahān de jíín: Róhó jíjnáhan ró, cuángoo taxín ró uva rī, te chunaa vāha ri yāhu ró, áchí de. Te tēe un cuángoo de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Te ni quenda tucu de jeē cuácuu cahuxī uū jiín jéē cuácuu cahunī, te suni súcuan ni nihīn tucu de mozo. ");
INSERT INTO mibNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Te jeē cuácuu cahuhūn ni quenda tucu de. Te ni nihīn tucu de jecu gā tēe cáyūcu sáá‑ni nuū yáhu. Te ni cahān de jíín: ¿Najehē cáhīin sáá‑ni ró yáha nɨ́ɨ́ ndiáca? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Te ni cacahān tēe ún: Sɨquɨ̄ jeē tú ni ɨɨn ní cána sāña jéē sájniñu ná. Te ni cahān de jíín tée ún: Núu súcuan te suni máá ró quingoo ró taxín ró ndehē uva rī, chi chunaa vāha ri yāhu ró, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Te nuū ní ini, te tēe chíí ñuhun ni cahān de jíín tée cújéhnu nuū mozo de: Cana xinī tēe cásájniñu te chunaa rō yāhu de, te xīhna gā tēe ni quɨ̄vɨcoo sandɨ̄hɨ́, te sáá te tēe ni quɨ̄vɨcoo xīhna ñúhún, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Te ni quecoo tēe jeē ni quɨ́vɨcoo cahuhūn. Te ɨɨn denario ni caquihin ɨɨn ɨɨn de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yūcuán na te ni quecoo tēe jeē ni quɨ́vɨcoo xīhna ñúhún. Te cájeni ni de jeē cuehē gā quiyāhu de. Te ɨɨn‑ni denario ni caquihin ɨɨn ɨɨn de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Te nuū ní caquihin de, te ni caquejéé de cácahān sōó de sɨquɨ̄ tēe chíí ñuhun, áchí de: ");
INSERT INTO mibNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Máá ná jijnáhan ná, ndiáca ni casájniñu ná, te ni candoho ná jéē jihní. Te tēe yáha jéē ni quɨ́vɨcoo sandɨ̄hɨ́, chi máá ɨɨn hora‑ni ni casájniñu de. Te ɨnuú‑ni ni chiyāhu ní sáña jíín de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Te tēe chíí ñuhun ni cahān jiín ɨɨn de: Amigo, nasūu jéē tú vāha sáha ri jiín ró. ¿A tu ní sándaā yō jeē ɨɨn denario quiyāhu ró, chí naún? ");
INSERT INTO mibNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Núu súcuan te quihin yāhu ró te quinuhun rō. Chi cúní rī jeē tée ni quɨ̄vɨcoo sandɨ̄hɨ yáha, ɨnuú quiyāhu de jíín máá ró. ");
INSERT INTO mibNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Te á tu cuu sáha ri ndese cúní rī jiín xúhun máá rí? ¿Te chí cúcuésún ni rō jeē ní chiyāhu vāha ri de jíjnáhan de sɨquɨ̄ jeē váha ni rī? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Te nájnūhun ni sáha tēe chíí ñuhun, suni súcuan sáha Yaā Dios. Chi ñayuu cácuu sandɨ̄hɨ́, nduu i nuū. Te ñayuu cácuu nuū, nduu i sandɨ̄hɨ́. Chi cuehē ñayuu cána ya jeē candíje i ya. Te jecu‑ni i cándíje, te nácāji ya maá i jeē ndúu i sēhe ya. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yūcuán na te ná ni quihin Jesús ichi cuahān yā ñuu Jerusalén, te ni cana sɨ́ɨn ya ndɨhúxí uū tēe cáscuáha jíín yá. Te ni cahān yā jiín de: ");
INSERT INTO mibNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Cuni sōho ró, chi je cuángoo yó ñuu Jerusalén vijna, te yūcuán nastúu ñayuu ruhū, Yaā ní nduu tēe, nuū sutú cácujéhnu jíín núū tée cástéén tutu ley. Te ndonda de sɨquɨ̄ rī jeē cúū rī. ");
INSERT INTO mibNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Te squɨ́vɨ de ruhū nuū tée nación Roma jeē cáyūcú Jerusalén cándacu jniñu. Te tāca tée un sácatā de nuū rī. Te cani de ruhū, te sáá te cahni de ruhū jicā cruz. Te nuū uní quɨvɨ̄ te natecu rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yūcuán na te ni quee ñasɨhɨ́ Zebedeo nuū yā jiín séhe ña Jacobo jiín Juan. Te ni jecuɨñɨ̄ yɨtɨ́ ña nuū yā, jícán ña ɨɨn favor nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Te ni cajnūhun yá ña: ¿Na vé cuní rō? Te ni cahān ña: Cuāha ní jnúhun jeē quɨvɨ̄ ndácu ní jniñu te conēne ndɨndúú séhe ná yáha xiin ní, ɨɨn i lado váha ní, te ɨnga i lado jecó ní, achí ña. ");
INSERT INTO mibNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yūcuán na te ni cahān Jesús jiín Jacobo jiín Juan: Tu cájini rō na vé cúu jeē cájicān rō. ¿A cuu ndoho ró jnúndóho nájnūhun jeē quíji sɨquɨ̄ rī? ¿Te á canda ró ndoho xeēn rō nájnūhun ndoho ri? Achí yá. Te ni cacahān de: Cuu sáha ná. ");
INSERT INTO mibNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Te ni cahān yā jiín de: Jendaá jeē ndoho ró jnúndóho nájnūhun jeē quíji sɨquɨ̄ rī, te ndoho xeēn rō nájnūhun ndoho ri. Te jeē cónēne ró lado váha ri jiín lado jecó rí, nasūu rúhū cúu jeē cuáha jnūhun. Chi je íyó túhva cuu tāca tée jeē ní nacāji Tátá rī, te tēe un níhīn. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Te uxī gā tēe cáscuáha jíín yá ní cajini de jnūhun yáha. Te ni caquɨtɨ̄ ni de nuū uú ñani ún. ");
INSERT INTO mibNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Te Jesús ni cana ya de, te ni cahān yā jiín de: Cájini rō ndese cásáha tēe cácujéhnu nuū ñáyuu tācá nación. Chi cándacu nīhin de jniñu nuū i, te máá de cáchí ndese coo. ");
INSERT INTO mibNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Te máá ró jijnáhan ró, chi ma sáha ró súcuan. Chi núu ndé ɨɨn ró cúní cujéhnu, sa suhva cuajníñu ró núū jnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Te núu ndé ɨɨn ró cúní cuu nuū, sa suhva sáha ró máá ró mozo nuū jnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Chi suni súcuan sáha ruhū, Yaā ní nduu tēe, chi nasūu jéē véji ri jeē cuajníñu ñayuu nuū rī, chi sa suhva vēji ri jeē cuajníñu ri nuū ñáyuu. Te cuāha ri maá rí cuu rī návāha jnama ri cuehē ñayuu, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yūcuán na te ni quenda ya jiín de ñuu Jericó. Te cuehē ndasɨ́ ñáyuu ni candiquīn i ya. ");
INSERT INTO mibNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Te yuhíchi un cáyūcu úū tēe cuáá. Te ni cajini de jnūhun jeē yáha Jesús cuahān yā, te ni cacana jee de: Máá ní jeē cúu ní Séhe yucūn David, cundáhú ni ni sáña, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Te ñayuu un ní cacahān i nuū de jeē na cásɨ de yuhu de. Te víhyá gā ni cacana jee de: Máá ní jeē cúu ní Séhe yucūn David, cundáhú ni ni sáña víī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Te ni jecuɨñɨ̄ Jesús, te ni cana ya ndɨndúú tée cuáá un, te ni cajnūhun yá de: ¿Na vé sáha ri jiín ró cácuni rō? ");
INSERT INTO mibNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Te ni cacahān de jíín yá: Jeē na ndúndijin tɨnūu ná cácuni ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Te ni cundáhú ni yā de. Te ni tee ya ndaha ya tɨnūú de. Te ni candundijin‑ni tɨnūú de. Te ni candiquīn de ya cuangoo de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Te nuū cuácuyajni ya ñuu Jerusalén, te ni jinū yā jiín tée cáscuáha jíín yá ñuu Betfagé, jeē íne jehē yucu Olivos. Te ni tají yá uū tēe cáscuáha jíín yá jeē quíngoo de. ");
INSERT INTO mibNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Te áchí yá jiín de: Cuáhán ñuu lulí íne ichi núú. Te yūcuan níhīn rō ɨɨn burra, núhní tɨ̄ jiín ɨɨn burro lúlí. Te ndají ró tɨ̄, quijicoo ró jíín tɨ́ nuū rī. ");
INSERT INTO mibNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te núu ndé ɨɨn cahān jiín ró, te cachi rō nuū: Máá Jítoho yō jíni ñúhún yá tɨ̄, achi rō. Yūcuán na te siáá‑ni i tɨ, quiji ró jíín tɨ́, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Te súcuan ni cuu tācá jniñu yáha návāha squícu jnūhun ni cahān tēe ni nacani jnūhun Yaā Dios nde jenahán, yósó núū tútu: ");
INSERT INTO mibNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Cachi rō nuū ñáyuu ñuu Jerusalén jeē naní ñuu Sión: Yāhá condēhe ró jeē véji Rey rō. Tu sájéhnu ya maá yá, chi máá burra‑ni yósó yá, jíín burrito, sēhe quɨtɨ ndíso. Achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yūcuán na te tēe cáscuáha un cuángoo de, te ni casáha de nájnūhun ni ndacu Jesús jniñu nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Te ndéca de burra jíín séhe tɨ, ni ndecoo de nuū yā. Te ni casoó de sahma de sɨquɨ̄ tɨ̄, te ni jecosō yā tɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Te cáhīin cuehē ñayuu, te ni cascáá i sahma i ini ichi. Te sava ga i ni cajehnde ndaha ñúú, te ni cachucun i ini ichi. ");
INSERT INTO mibNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Te ñayuu cuangoo ichi núú jíín ñáyuu cuangoo ichi yátá, cácana jee i: Yōhyo cújéhnu Yaā cúu Sēhe yucūn rey David. Yōhyo vāha Yaā cúu Yaā jeē véji jíín jniñu máá Jítoho yō Yaā Dios. Te yōhyo cújéhnu máá Yaā Dios. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Te nuū ni quɨ́vɨ ya ñuu Jerusalén, te ndɨhɨ ñayuu ñuu un ní cacuvaā i, te cuehē i cájnūhun jnáhan: ¿Ndé tée cúu tēe yáha? áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Te ni cacahān ñayuu vējicoo jíín yá: Yāha cúu Jesús jeē nácani jnūhun Yaā Dios, jeē véji nde ñuu Nazaret ndañúū Galilea. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yūcuán na te ni quɨ̄vɨ Jesús ini templo cáhnu Yaā Dios. Te ni quenehen ya tāca ñáyuu cájeen quɨtɨ te cánaxīco núū ñáyuu jeē socō i. Te ni scotúú ndeyɨ ya tāca mesa tēe cástáyɨ xūhún, jíín silla tēe cáxīcó paloma. ");
INSERT INTO mibNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Te áchí yá jiín i: Yósó núū tútu iī jeē cahán Yaā Dios: Vehe ri chi vehe nuū cájicān tahú cúu, áchí Yaā Dios. Te máá ró jijnáhan ró, chi nájnūhun yaū cava ñacuīhná ni canasáha ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yūcuán na te sava ñayuu cuaá jíín ñáyuu chacuá ni quecoo i nuū yā ini templo un. Te ni nasávāha ya i. ");
INSERT INTO mibNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Te sutū cácujéhnu jíín tée cástéén tutu ley Yaā Dios, ni cajito de tācá jniñu jéhnu sáha ya, te ni cajini de jeē cácana jee sūchi lúlí ini templo: Yōhyo cújéhnu Yaā cúu Sēhe yucūn rey David, achí i. Te ni caquɨtɨ̄ ni de. ");
INSERT INTO mibNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Te ni cacahān de jíín yá: ¿A tu jíni ró jéē súcuan cácahān sūchi yáha? áchí de. Te ni cahān Jesús jiín de: Jíni ri. ¿Te á ná tu cahu ró jéē yosó núū tútu iī jeē suhva cáhán ɨɨn tēe jíín Yaā Dios? Sáha ní jéē tāca súchi lúlí jíín súchi cájexin, vāha ndasɨ́ cáhán i jeē Yaā cujéhnu cúu Cristo. Achí. ");
INSERT INTO mibNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Te ni stóo ya de. Te ni quenda ya ñuu Jerusalén, cuahān yā nde ñuu Betania. Te yūcuan ní ndōo ya jecuáā ún. ");
INSERT INTO mibNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Te jenéhen ɨnga quɨvɨ̄ cuanuhun yā ñuu Jerusalén, te jíí yā sōco. ");
INSERT INTO mibNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Te ni jito ya ɨɨn nundēhe higo, íin yuhíchi. Te ni jehēn yā jehē. Te tú na ndehē ni níhín yā, chi máá ndaha‑ni íin. Te ni cahān yā jiín: Vijna te ma cúun cuɨtɨ gā ndehē xinī rō, achí yá. Te ni ichī‑ni yujnu higo ún. ");
INSERT INTO mibNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Te tēe cáscuáha jíín yá, ni canaa ni de cájito de. Te ni cacajnūhún de ya: ¿Ndese ni sáha ní jéē yachí‑ni ni ichī yujnu higo? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Te ni cahān yā jiín de: Jendaá cahán rī jiín ró, núu candíje ró te tú cani sɨquɨ́ ni rō, te cuu sáha ró jniñu jéhnu nájnūhun ni sáha ri jiín yujnu higo. Te nde jniñu jéhnu ga cuu sáha ró, chi nde cuu cahān rō jeē cújiyo yucu yáha, quihīn nuū mar, te sáha nájnūhun cahān rō. ");
INSERT INTO mibNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te tāca jéē cacán tahú rō jijnáhan ró, te núu candíje ró jéē nihín rō, te nihīn rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Te ni quɨ̄vɨ tucu ya ini templo cáhnu. Te níní stéén yā jnūhun, te sutū cácujéhnu jíín táca tée jéhnu jeē cándacu jniñu nuū ñáyuu hebreo, ni quecoo de nuū yā. Te ni cacajnūhún de ya: ¿Ndé ní nihīn jníñu ró jéē sáha ró jniñu yáha? ¿Te ndé ɨɨn ni tee jniñu sɨquɨ̄ rō jeē sáha ró súcuan? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Te ni cahān Jesús: Suni ruhū, cajnūhun rí rohó ɨɨn jnūhun jíjnáhan ró, te núu cuu stíó cuɨ́ñɨ́ rō, yūcuán na te cachi rī nuū rō ndé ní nihīn jníñu ri jeē sáha ri jniñu yáha. ");
INSERT INTO mibNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ndé ɨɨn ni tee jniñu sɨquɨ̄ Juan jeē ni scuándute de? ¿A Yaā Dios chí táca tée? áchí yá jiín de. Yūcuán na te ni candajnūhun máá de: Núu cahān yō jeē Yaā Dios ni tee ya jniñu un sɨ́quɨ̄ Juan, te cahān de jíín yó: Núu súcuan ¿te najehē tu ní cácandíje ró de? ");
INSERT INTO mibNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Te núu cahān yō jeē ñáyuu ni catee jniñu un sɨ́quɨ̄ de, te cáyūhu yó ñayuu, chi ndɨvii i cácandíje i jeē tée ni nacani jnūhun Yaā Dios ni cuu ndije Juan. Achí de cácahān maá de. ");
INSERT INTO mibNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Te ni cacahān de jíín Jesús: Tu cájini rī, achí de. Yūcuán na te ni cahān yā jiín de: Ni ruhū, suni ma cáchi rī nuū rō ndé ɨɨn ni tee jniñu sɨquɨ̄ rī sáha ri jniñu yáha, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Te ni cahān gā yā jiín de: Cuni nahín ró jnūhun yátá yáha: Ɨɨn tēe ni īyo uū sēhe yɨɨ́ de. Te ni cahān de jíín ɨɨn i: Séhē, quihīn rō taxín ró ndehē uva rī vijna, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Te ni cahān i: Ma quihín na, áchí i. Te ni cunúu, te ni nacani ni i, te cuahān i nuū jníñu ún. ");
INSERT INTO mibNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Te tēe un ní jehēn de nuū ɨ́nga sēhe de, te suni súcuan ni cahān de jíín i. Te ni cahān i: Cuu núu súcuan, te quihīn na, áchí i. Te tu ní jéhén i. ");
INSERT INTO mibNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Te ndese cájeni ni rō? Jeē ndɨndúú i, ¿ndé ɨɨn i ni squícu jniñu cúní tatá i? áchí yá. Te ni cacahān de: Sūchi jéē ni cáhān de jíín xíhna gā, achí de. Te ni cahān Jesús jiín de: Súcuan cúu, te jendaá cahán rī jiín ró jeē tée cástútú xúhun renta jiín ñahan cájica jnéní, yachī cánacani ni i jeē stóo i cuēchi i te quɨ́vɨcoo i ndaha Yaā Dios jeē ndacu ya jniñu nuū i, te máá ró jijnáhan ró chi ma quɨ́vɨ ró. ");
INSERT INTO mibNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chi ni quiji Juan, ni steén de ndese condiquīn rō jnūhun ndaā, te tu ní cácandíje ró jnúhun ni cahān de. Te sa suhva tēe cástútú xúhun renta jiín ñahan cájica jnéní, ni cacandíje i jnūhun ni cahān de. Te máá ró, vēsú ni cajito ró jéē ní cacandíje i, te tu ní cánacani cuɨtɨ ni rō jeē candíje ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Cuni sōho ɨnga jnūhun yátá jíjnáhan ró: Ni īyo ɨɨn tēe chíí ñuhun. Te ni nachuhun de cuehē ndehē uva. Te ni jesɨ de corral, te ni sáha de ɨɨn nuū cúhun ndehē un táxīn. Te ni jeni de ɨɨn vehe súcún návāha cuu coto de nɨ́ɨ́ cáhnu. ’Te ni stóo de nuū sava tēe sájniñu nuū, te cuu sava de ndehē jiín. Te ni tee de ichi cuahān jicá de. ");
INSERT INTO mibNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Te máá tiempo ndutútú uva, te ni tají de jecu mozo cuanuquīhin sava uva nuū tée cásájniñu ún. ");
INSERT INTO mibNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Te tēe un ní cajnɨɨ de mozo un. Te ɨɨn i ni cacani de, te ɨnga i ni cajehni de, te ɨnga i ni cajēhe de yuū xinī. ");
INSERT INTO mibNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Te tēe chíí uva ni tají tucu de jecu gā mozo cuangoo, cuehē gā vēsú jeē xíhna ñúhún. Te suni súcuan ni casáha tēe un jíín ndɨhɨ mozo un. ");
INSERT INTO mibNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Te jeē sándɨ̄hɨ́ na te ni tají de sēhe de cuahān. Te jéni ni de: Tēe ún chi cuatáhú de jíjnáhan de nuū séhe ri. ");
INSERT INTO mibNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Te tēe cásájniñu ún, núu ní cajito de nuū séhe tēe chíí uva, te ni cacahān maá: Tēe chíí táhū cúu jeē yáha. Na cáhni yō de, te ndōo tahū de cuu yó, áchí. ");
INSERT INTO mibNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Te ni cajnɨɨ de i, te ni caquenehen de i ɨnga lado, te ni cajehni de i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yūcuán na te ni cajnūhun yá de: Núu súcuan te núu na quíji tēe chíí uva un, ¿te ndese sáha de jíín tée cásájniñu ún? áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Te ni cacahān de jíín yá: Ma cundáhú cuɨtɨ ni de tāca tée cásáha jniñu néé un, chi cahni de. Te cuāha de ñuhun cáá uva un núū ɨnga sava tēe sájniñu nuū, cuu sava de ndehē jiín. Te quɨvɨ̄ ndutútú ndehē, te tēe ún nacuāha de sava ndehē nuū tée chíí uva. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Te ni cahān Jesús jiín de: ¿Te á ná tu cahu ró jnúhun yáha jeē yosó núū tútu iī, jeē ruhū cúu nájnūhun ɨɨn yuū? Chi áchí tutu: Yuū jeē ní casquéhichī tēe cájeni vehe, yuū yáha nduu jeē quítuu vehe. Máá Jítoho yō Yaā Dios ni sáha ya súcuan, te cánaa ni yō jíto yó jniñu yáha. Achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Núu súcuan te cáhán rī jiín ró jeē cujiyo‑ni jeē ndácu Yaā Dios jniñu nuū rō jijnáhan ró, te nacuāha ya jniñu un núū ɨnga ñayuu jeē squícu váha i jniñu ndácu ya nájnūhun cúní yā. ");
INSERT INTO mibNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Te ñayuu tu cácandíje, ndoho i nájnūhun ndóho ñayuu jeē cotúú sɨquɨ̄ yuú te jnáhnú i. Te quɨvɨ̄ sándaā Yaā Dios cuēchi, te ñayuu tu cácandíje, ndoho i nájnūhun ndóho ñayuu jeē nɨ́nga yuū sɨquɨ̄ i te cundihī i sáha. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Te sutū cácujéhnu jíín tée grupo fariseo ni cajini sōho de tāca jnúhun yátá ní cahān yā. Te ni cajecūhun ni de jeē sɨquɨ̄ maá de cúu jnūhun yátá ní cahān yā sɨquɨ̄ tée cásájniñu nuū uva jiín tée cájeni vehe. ");
INSERT INTO mibNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Te ni canducú de modo jnɨɨ de ya. Te cáyūhú de jeē quɨtɨ̄ ni ñayuu, chi cájeni ni i jeē tée nácani jnūhun Yaā Dios cúu ya. ");
INSERT INTO mibNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yūcuán na te ni cahān tucu Jesús ɨnga jnūhun yátá jíín de jíjnáhan de: ");
INSERT INTO mibNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Súcuan cúu jeē ndácu Yaā andɨvɨ́ jniñu nuū ñáyuu: Cúu nájnūhun ɨɨn rey jeē sáha de ɨɨn vico jeē nándāha sēhe yɨɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Te ni tají de tāca mozo de cuacana ñayuu jeē ni cáhān de jíín jéē quíjicoo. Te ñayuu ún tu ní cácuni i quijicoo i. ");
INSERT INTO mibNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Te ni tají tucu de jecu gā mozo quingoo, te áchí de jíín: Cahān jiín ñáyuu ní cana ri un jéē iyó túhva ndeyu. Chi je ni jehni rī stɨquɨ̄ rī jiín táca gá quɨtɨ ní nduu, te ndɨhɨ je íyó túhva. Nehen jijnáhan ró vico nándāha. Achi rō jiín i. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Te ñayuu ní cana de ún tu ní cásáha i cuenta. Chi ɨɨn i cuahān nuū ítu i, te ɨnga i cuahān nuū jníñu sáha i. ");
INSERT INTO mibNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Te sava ga i ni cajnɨɨ i tāca mozo rey, te ni casácatā i nuū, te ni cajehni i. ");
INSERT INTO mibNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yūcuán na te yōhyo ni quɨtɨ̄ ni rey. Te ni tají de soldado de ni jengoo, ni cajehni de ñayuu ní cajehni ndɨ̄yɨ ún, te ni cajehmu de ñuu i. ");
INSERT INTO mibNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yūcuán na te ni cahān de jíín sava ga mozo de: Ndɨhɨ je íyó túhva jeē cóo vico nándāha. Te ñayuu ní cana ri ún, tu íyó váha jeē quíjicoo i chi nasūu ñáyuu vāha cácuu i. ");
INSERT INTO mibNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Núu súcuan te cuáhán jijnáhan ró táca núū náquijnáhan calle. Te cana ró núu nasaa ñayuu nihīn rō, na quíjicoo i vico nándāha. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Te ni quendacoo mozo un cuángoo tācá ichi. Te ni castútú de ndɨhɨ ñayuu ní canihīn de, cúu ñayuu cunéé, cúu ñayuu váha. Te súcuan te ni chitú ñáyuu ini vehe nuū iyó vico nándāha. ");
INSERT INTO mibNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Te ni quɨ̄vɨ rey ini vehe jeē cahán de jíín ñáyuu ni cutútú. Te ni jito de nuū ɨɨn tēe jeē tu ñúhun sahma jeē ni jéhe de cuhun ñayuu quijicoo vico nándāha. ");
INSERT INTO mibNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Te ni cahān de jíín tée ún: Amigo, ¿ndese ni quɨ̄vɨ ró yáha jéē tu ñúhun ró sahma vico nándāha? áchí de. Te máá tée ún tu ní cáhán cuɨtɨ de. ");
INSERT INTO mibNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yūcuán na te ni cahān rey jiín tée cájeni cohō: Jnɨɨ de te cuhni rō ndaha de jehē de, te quenehen ró de na quíhín de nuū quéhe nuū néē. Te yūcuan ndáhyū de te nacayɨ̄hɨ́ yuhu de jeē ndóho xeēn de. Achí rey. ");
INSERT INTO mibNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Chi cána Yaā Dios cuehē ñayuu jeē na cándíje i. Te jecu‑ni i candíje, te máá i nácāji ya jeē ndúu i sēhe ya. Achí Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yūcuán na te cuangoo tēe grupo fariseo. Te ni candajnūhún de núu ndese sáha de návāha cahān yā ɨɨn jnūhun jeē nihín de cuēchi sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Te ni catají de jecu tēe cáscuáha jíín máá de jíín tée grupo Herodes cuangoo de. Te ni cacahān de jíín yá: Maestro, cájini na jéē tée cáhán ndaā cúu ní, te stéén ndaā ní ndese squícu ñayuu nuū Yaā Dios. Te tu yúhú ní jeē cahán ni ɨɨn ñayuu sɨquɨ̄ ní, chi tu sáha ní cuenta ndese cúu ɨɨn ɨɨn i, chi ɨnuú‑ni sáha ní jíín i. ");
INSERT INTO mibNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Núu súcuan te cahān ní ndese jéni ni ní: ¿A íyó váha jeē chúnaa yō renta nuū rey nación Roma jeē jnɨ́ɨ nación yō, chí tuú? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Te ni jini Jesús jeē cájito ndee de ya. Te ni cahān yā jiín de: Tēe stáhú‑ni cácuu ró. ¿Najehē cájito ndee rō ruhū? ");
INSERT INTO mibNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Stéén xūhun jéē jéconaā renta na cóto ri, achí yá. Te ni castéén de ɨɨn denario nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Te ni jito ya, te ni cajnūhun yá de: ¿Ndé ɨɨn nuū cúu jeē ndeé nuū xúhun yáha, te ndé sɨ́hvɨ́ cúu jeē ndeé yāhá? ");
INSERT INTO mibNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Te ni cacahān de jíín yá: Nuū jiín sɨ́hvɨ́ rey un cúu, áchí de. Yūcuán na te ni cahān yā jiín de: Núu súcuan te nacuāha ró núū rey un jéē yɨ́hɨ cuenta nuū de, te nacuāha ró núū Yaā Dios tāca jéē yɨ́hɨ cuenta nuū maá yá, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Te nuū ní cajini de jeē ndichí ní cahān yā jnūhun yáha, te ni canaa ni de, te ni castóo de ya, te cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Te suni quɨvɨ̄ un ní quecoo jecu tēe grupo saduceo nuū yā. Te tēe un cácahān jeē tu nátecu cuɨtɨ ndɨ̄yɨ. Te ni cacahān de jíín yá sɨquɨ̄ ɨɨn jnūhun, áchí de: ");
INSERT INTO mibNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Maestro, Moisés ni cahān de jeē núu ɨɨn tēe cuu de, te ndōo ñasɨhɨ́ de, te núu tú sēhe de ní íyo jíín ña, núu súcuan te cánuú jeē ñani de naquihin ñasɨhɨ́ de, te sēhe de jeē cácu jíín ña nucuɨñɨ̄ nuū ndɨ́yɨ ñani de. Achí Moisés. ");
INSERT INTO mibNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Te ñuu na ní īyo uxā ñani. Te tēe núú ní quijnáhan de jíín ñahan. Te ni jihī de. Te jeē tú sēhe de ní íyo, te ni ndōo ñasɨhɨ́ de nuū ñáni de. ");
INSERT INTO mibNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Te tēe ún suni ni jihī de, te tú na sēhe de ní íyo tucu. Te suni súcuan tēe unī, nde jiín ndɨhúxá de. ");
INSERT INTO mibNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Te nuū ní ndɨhɨ de ni cajihī, te suni ni jihī ñahan ún. ");
INSERT INTO mibNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Núu súcuan te quɨvɨ̄ nátecu ndɨ̄yɨ, ¿ndé ɨɨn de cuu ña ñasɨhɨ́ de? Chi ndɨhúxá de ni condeca de ña. Achí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yūcuán na te ni cahān yā jiín de: Yōhyo cástɨ́vɨ ró jnūhun sɨquɨ̄ jeē tu cájecūhun ni rō jeē cahán tutu iī, ni tu cájini rō jeē iyó poder Yaā Dios jeē nastécu yā ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Chi quɨvɨ̄ nátecu ndɨ̄yɨ, te tuá na jnūhun quijnáhan tēe jíín ñahan coo. Chi coo i nájnūhun ndajéhé Yaā Dios andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Te sɨquɨ̄ jeē nátecu ndɨ̄yɨ, ¿á tu ní cácahu ró tutu jnūhun jeē cahán Yaā Dios jiín ró? ");
INSERT INTO mibNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Máá rí cúu Yaā Dios Abraham jiín Isaac jiín Jacob, achí Yaā Dios. Chi vēsú je ni cajihī de, te cátecu de nuū iyó máá yá, chi cúu ya Yaā sáha jeē técu ñayuu nɨɨ́ cáni. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Te ñayuu un ní canaa ni i cájini nahín i jnūhun stéén yā. ");
INSERT INTO mibNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yūcuán na te tēe grupo fariseo ni cajini de jeē ní cajesɨ tēe saduceo yuhu de ni sáha ya. Te ni candutútú de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Te ɨɨn de jeē cúu tēe stéén tutu ley Yaā Dios, ni cajnūhún de ya, chi coto ndee de ya cuní de: ");
INSERT INTO mibNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Maestro, ¿ndé ɨɨn cúu jnūhun ndácu jniñu cánuú ndasɨ́ gá nuū tútu ley? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Te ni cahān Jesús jiín de: Coo manī ndasɨ́ ró jiín máá Jítoho rō Yaā Dios, nde jnáā ndasɨ́ ró sáha ró ndɨhɨ jeē cúsɨɨ̄ ni yā, nde jiín ini jiín ánuá rō, jiín nɨ́ɨ́ jéē níjnūní rō, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yāha cúu jniñu ndácu ya jeē cujéhnu ga te cánuú ndasɨ́ gá. ");
INSERT INTO mibNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Te jniñu uū jeē ní ndacu ya, suni súcuan cáhán: Cundáhú ni rō jnáhan ró nájnūhun cúndáhú ni rō maá ró. ");
INSERT INTO mibNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Te chīji ndɨndúú jnúhun yáha ní quenda ndɨhɨ ley jeē ní tee Moisés, jiín ndɨhɨ jeē ní castéén tēe ni canacani jnūhun Yaā Dios, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Te níní cáyūcu tútú gá tēe fariseo un, te Jesús ni cajnūhun yá de: ");
INSERT INTO mibNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Ndese cájeni ni rō sɨquɨ̄ Cristo? ¿Sēhe ndé yúcūn cúu ya? Te ni cacahān de: Sēhe yucūn David, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Te ni cahān yā jiín de: Núu súcuan ¿te ndese cúu jeē David ni cahān de Jitoho de ya, ni sáha Espíritu Santo nde jenahán? Chi ni cahān de: ");
INSERT INTO mibNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Máá Jítoho yō Yaā Dios ni cahān yā jiín Jítoho rī, Yaā quiji: Cucōo ró lado váha ri nuū cujéhnu ró, te na sáha ri jeē quende rō poder tāca jéē cájito uhū rohó. Achí Yaā Dios. Achí David. ");
INSERT INTO mibNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Te núu sēhe yucūn David cúu Cristo, ¿te ndese cúu jeē ni cáhān de jeē Jítoho de cúu ya? áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Te ni ɨɨn de tu ní cúu stió cuɨ́ñɨ́ cuɨtɨ de jnūhun nuū yā. Te nde quɨvɨ̄ ún tuá ni ɨɨn de ní chúndeyɨ́ ni de cajnūhún de ya. ");
INSERT INTO mibNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yūcuán na te ni cahān Jesús jiín ñáyuu jiín tée cáscuáha jíín yá: ");
INSERT INTO mibNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Tēe cástéén tutu ley Yaā Dios jiín tée grupo fariseo, cájeni ni de jeē ndíso jníñu de jeē steén de ley jeē ni jéhe ya nuū Moisés. ");
INSERT INTO mibNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Núu súcuan te cuatáhú ró te squícu ró táca jéē cándacu de nuū rō. Te ma sáha ró nájnūhun cásáha máá de. Chi cácahān‑ni de, te tu cásquícu de. ");
INSERT INTO mibNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Chi suni cástéén de tāca ley ni catava maá de jeē yɨɨ́ sáha, te cátee de sɨquɨ̄ ñáyuu, te tu cácundeyɨ́ i squícu i. Te máá de jíjnáhan de, chi ni ɨɨn xinī ndáha de tu cáscánda de jeē squícu de. ");
INSERT INTO mibNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Te máni sɨquɨ̄ jeē na cuájnúhún ñáyuu de cúu ndɨhɨ jeē casáha de. Chi cánujnahan ni de cuhni de cuehē jnūhun tutu iī jneē de jíín ndaha de. Te suni cásácáni ga de yuhvā yusáhma de jeē steén jeē cácujéhnu ga de vēsú ɨnga ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Te cánujnahan ni de cucōo de nuū silla yɨñúhún gá nuū cáyeji ñayuu vico, jíín silla yɨñúhún gá ini vehe iī sinagoga. ");
INSERT INTO mibNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Te suni cánujnahan ni de jeē cahán yɨñúhún ñáyuu jiín de nuū calle, jiín jéē cahán i maestro jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Te máá ró jijnáhan ró, ma cuáha ró jnúhun jeē cahán ñayuu maestro jiín ró. Chi ɨnuú cácuu ndɨhɨ ró jéē cácuu ró hermano, te íyó ɨɨn‑ni Maestro rō jeē cúu ruhū, Cristo. ");
INSERT INTO mibNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Te ma chiñúhún ró ni ɨɨn tēe ñayɨ̄vɨ yáha jeē cahán rō padre jiín de. Chi íyó ɨɨn‑ni Tátá rō jijnáhan ró, Yaā ndeé andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Te suni ma cuáha ró jnúhun jeē cahán i jitoho jiín ró. Chi íyó ɨɨn‑ni Jitoho rō, te suu cúu ruhū, Cristo. ");
INSERT INTO mibNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Te tēe mēhñu ró jijnáhan ró jeē jejníñu nuū jnáhan, suu de cúu jeē cujéhnu ga. ");
INSERT INTO mibNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chi tēe jeē sajéhnu de máá de, sa ndululí de. Te tēe jeē sálulí de máá de, sa ndujéhnu de. ");
INSERT INTO mibNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Nacā xeēn ndoho róhó tée cástéén tutu ley jiín róhó tée fariseo, chi tēe stáhú‑ni cácuu ró. Chi cájesɨ rō jeē quɨ́vɨ ñayuu ndaha Yaā andɨvɨ́ jéē ndacu ya jniñu nuū i. Chi tu quɨ́vɨcoo máá ró, ni tu cájēhe ro jnúhun quɨ̄vɨcoo ñayuu nducú quɨ́vɨ. ");
INSERT INTO mibNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Nacā xeēn ndoho róhó tée cástéén tutu ley jiín róhó tée fariseo, chi tēe stáhú‑ni cácuu ró. Chi cáquende rō vehe ñahan ní caquendōo ndáhú. Yūcuán na te cájicān tahú nahán ró návāha cani ni ñayuu jeē tú na cuēchi ró. Jeē yúcuan xeēn gā ndoho ró castigo. ");
INSERT INTO mibNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Nacā xeēn ndoho róhó tée cástéén tutu ley jiín róhó tée fariseo, chi tēe stáhú‑ni cácuu ró. Chi nɨ́ɨ́ ñuhun íchi jíín nɨ́ɨ́ mar cájica cuu ró cánducú ró ɨɨn ñayuu scandíje ró sáhān maá ró. Te núu ni candíje i, te cásáha ró jéē vihyá gā cúu cuēchi i jeē quihín i infierno vēsú maá ró. ");
INSERT INTO mibNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Nacā xeēn ndoho ró, chi cácuu ró nájnūhun tēe cuáá jéē steén ichi nuū ñáyuu. Chi cácahān rō: Núu ndé tée jéjnūhun téyɨ́ de, te núu cahān de jeē Yaā Dios jeē ndeé ini templo na cuáha ya castigo núu ma squícu de, yūcuán na te tu cánuú squícu de. Te núu cahān de jeē Yaā Dios jeē chií oro jeē iyó ini templo, na cuáha ya castigo núu ma squícu de, yūcuán na te cánuú squícu nahín de, cácahān rō. ");
INSERT INTO mibNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tēe cánéé tēe cuáá cácuu ró jéē castɨ́vɨ ró jnūhun cácahān rō. ¿Ndé ɨɨn cúu jeē cujéhnu ga, á oro un chí Yaā Dios jeē ndeé ini templo jeē sáhiī oro un? ");
INSERT INTO mibNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Te suni cácahān rō: Núu ndé tée jéjnūhun téyɨ́ de, te núu cahān de jeē Yaā Dios jeē chií altar na cuáha ya castigo núu ma squícu de, yūcuán na te tu cánuú squícu de. Te núu cahān de jeē Yaā Dios jeē chií ndajníñu jeē cásocō nuū altar, na cuáha ya castigo núu ma squícu de, yūcuán na te cánuú squícu nahín de, cácahān rō. ");
INSERT INTO mibNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tēe cánéé tēe cuáá cácuu ró jéē castɨ́vɨ ró jnūhun cácahān rō. ¿Ndé ɨɨn cúu jeē cujéhnu ga, á ndajníñu yúcu nuū altar, chí Yaā Dios jeē sáhiī yā ndajníñu ún? ");
INSERT INTO mibNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Núu súcuan te tēe jéjnūhun téyɨ́, te núu ndácunehen de Yaā Dios jeē chií altar, núu súcuan te nde jiín ndajníñu yúcu nuū altar ndácunehen de. ");
INSERT INTO mibNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Te tēe jeē jéjnūhun téyɨ́, te núu ndácunehen de templo, núu súcuan te nde jiín Yaā Dios jeē ndeé ini templo ndácunehen de. ");
INSERT INTO mibNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Te tēe jéjnūhun téyɨ́, te núu ndácunehen de andɨvɨ́, núu súcuan te suni ndácunehen de mesa Yaā Dios te nde jiín máá Yaā Dios jeē ndeé nuū mesa un. ");
INSERT INTO mibNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Nacā xeēn ndoho róhó tée cástéén tutu ley jiín róhó tée fariseo, chi tēe stáhú‑ni cácuu ró. Chi cásáha ró úxī uxī nuhnī tamīnú jiín yucū anís jiín yucū comino, te cásocō rō ɨɨn ɨɨn sɨquɨ̄ tāca úxī un núū Yaā Dios. Te cástóo ró jnúhun cánuú ndasɨ́ gá nuū ley, suu jeē cáca ndaā rō, jiín jéē cundáhú ni rō jnáhan ró, jíín jéē candíje ró. Tāca jéē yáha cánuú sáha ró núú, te suni ma stóo ró jéē socó rō tāca yúcū ún. ");
INSERT INTO mibNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Cácuu ró nájnūhun tēe cuáá jéē steén ichi nuū ñayuu. Chi cásquícu ró ɨɨn jeē lulí gá un, te cástóo ró jéē cánuú gá. Te suu cúu nájnūhun jeē cátava rō chūcún ndíhī jeē ñúhun nuū ndúxi, te cácocó ró ɨɨn quɨtɨ cáhnu jeē naní camello. ");
INSERT INTO mibNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Nacā xeēn ndoho róhó tée cástéén tutu ley jiín róhó tée fariseo, chi tēe stáhú‑ni cácuu ró. Chi nájnūhun jeē cánacate ró yátā vaso jiín yátā cohó. Te ichi íni rō chi ñúhun máni máá jnúhun cuíhná jíín jnúhun ndíyo ni. ");
INSERT INTO mibNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tēe cuáá cácuu ró, fariseo. Xīhna gā sáha ró jéē coo ndoo ini anuá rō, te yūcuán na te suni coo ndoo tāca jéē casáha ró jéē cájito ñayuu nuū. ");
INSERT INTO mibNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Nacā xeēn ndoho róhó tée cástéén tutu ley jiín róhó tée fariseo, chi tēe stáhú‑ni cácuu ró. Chi cándāa ró nájnūhun vehe ndɨ̄yɨ nuū panteón jeē cáyaa. Chi ichi yátá jíto luu, te ichi íni ñúhun chitú yɨquɨ ndɨ́yɨ jiín táca jéē tehyú. ");
INSERT INTO mibNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Te súcuan cácuu máá ró, chi ichi yátá rō casáha ró jeē tée ndaā cácuu ró núū ñáyuu. Te ichi íni rō ñúhun chitú jnúhun stáhú‑ni jíín jnúhun néé. ");
INSERT INTO mibNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Nacā xeēn ndoho róhó tée cástéén tutu ley jiín róhó tée fariseo, chi tēe stáhú‑ni cácuu ró. Chi cásáha ró vehe sɨquɨ̄ nuū yɨ́ndūji ndɨ̄yɨ jií rō, tēe ni canacani jnūhun Yaā Dios nde jenahán. Te cásáha luu ró vehe sɨquɨ̄ nuū yɨ́ndūji tāca tée ni īyo ndaā. ");
INSERT INTO mibNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Te cácahān rō: Núu jeē suni yúcu yó tiempo jeē ní cotecu ndɨ̄yɨ jií yō, te ma squɨ́vɨ nduu yō jiín de jeē cáhni yō tēe ni canacani jnūhun Yaā Dios, achí ró. ");
INSERT INTO mibNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Te súcuan cácahān ndaā rō jeē maá ró cácuu yucūn ñayuu ni cajehni tēe ni canacani jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Núu súcuan te tāca cuéchi jeē ní casquéjéé ndɨ́yɨ jií rō, máni un cásáha ga maá ró. ");
INSERT INTO mibNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Va sēhe coō cácuu ró, chi xeēn rō nájnūhun coō. ¿Ndese cācu ró jéē ma jnahnú ndetū rō quingoo ró infierno? ");
INSERT INTO mibNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Núu súcuan te tají rí tāca tée nacani jnūhun Yaā Dios nuū rō, jiín táca tée ndíchí jéē castéén jnūhun ya. Te sava de cahni rō, te sava de cata caa ró jicā cruz. Te sava ga de cani ró de ini tācá vehe iī sinagoga, te scúnu ró de quingoo de tācá ñuu. ");
INSERT INTO mibNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Te súcuan te condee cuēchi sɨquɨ̄ maá ró jeē ní cajehni jií rō tāca tée ndaā, xīhna gā nde Abel tēe ndaā, te nde Zacarías sēhe Berequías, tēe ni cajehni de ini templo sava mēhñu cuarto iī jiín altar. ");
INSERT INTO mibNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jendaá cahán rī jiín ró jeē tāca cuéchi yáha condee sɨquɨ̄ ñáyuu iyó vijna. ");
INSERT INTO mibNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Róhó ñuu Jerusalén, jéhni rō tēe cánacani jnūhun Yaā Dios, te jéhe ro yúū xinī tée tájí Yaā Dios vējicoo nuū rō. Te cuehē jínu ni cuni rī nastútú rí sēhe ró, nájnūhun ndují jéē nastútú tɨ́ sēhe tɨ chīji ndijēn tɨ̄, te tu ní cúní rō. ");
INSERT INTO mibNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Núu súcuan te vijna te stóo uun na ri rohó jíín séhe ró. ");
INSERT INTO mibNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chi cáhán rī jiín ró jéē ndé vijna te ma cóto cuɨtɨ gā rō nuū rī, chi nde quiji quɨvɨ̄ jeē cahán sēhe ró: Yōhyo vāha Yaā cúu Yaā véndiji jíín jniñu máá Jítoho yō Yaā Dios, achi i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Te ni quenda Jesús ini templo cáhnu cuahān yā. Te ni quecoo tēe cáscuáha jíín yá, te ni cacahān de jíín yá sɨquɨ̄ tācá vehe jeē ndejnáhan jeē cúu máá templo un. ");
INSERT INTO mibNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Te ni cahān yā jiín de: Tāca jéē cájito ró yáha, jendaá cahán rī jiín ró jeē quiji quɨvɨ̄ jeē ma cóso jnáhan ga ni ɨɨn yuū, chi ndɨhɨ jnanū. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Te ni jehēn yā jiín tée cáscuáha jíín yá nde yucu Olivos, te ni cucōo ya yūcuán. Te ni quecoo de nuū yā, te ni cacajnūhun sɨ́ɨn de ya: Castūhun ní ndé quɨ́vɨ̄ coo tāca jéē ní cachi ní jéē coo. ¿Te na seña coo núu ni cuyajni quɨvɨ̄ ndíji ní jíín jéē jínu ñayɨ̄vɨ́? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Te ni cahān Jesús: Coto ró jéē ma stahú ni ɨɨn de róhó. ");
INSERT INTO mibNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Chi quijicoo cuehē tēe jeē stahú jíín sɨ́hvɨ́ rí. Máá rí cúu Cristo, achi de. Te súcuan stáhú de cuehē ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Te nihīn rō jnūhun jeē tāca lado iyó guerra, chí je yajni coo guerra. Te ma yūhu ró, chi cánuú coo súcuan. Te ni ná tu jinū quɨvɨ̄ ndɨhɨ ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chi ndonda nación sɨquɨ̄ ɨnga nación, te ndonda ñuu sɨquɨ̄ ɨnga ñuu jeē cuajnáhan. Te coo jnamā jiín cuéhyɨ̄ xeēn. Te cháha chúcuan jnāa. ");
INSERT INTO mibNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Te tāca jéē yáha cácuu jnūndóho quejéé xíhna ñúhún gá. ");
INSERT INTO mibNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Yūcuán na te nastúu i róhó jíjnáhan ró jéē stóho i róhó te cahni i róhó. Te ndɨhɨ ñayuu quɨtɨ̄ ni i nuū rō jeē sɨquɨ́ ruhū. ");
INSERT INTO mibNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Te quɨvɨ̄ ún chi cuehē ñayuu candíje caca yátá i, te quɨtɨ̄ ni i nuū jnáhan i, te nastúu jnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Te canecoo cuehē tēe stáhú, te cahān de jeē jnúhun Yaā Dios cánacani de, te stáhú de cuehē ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Te nducuehē jniñu néé, te jeē yúcuan cuehē i ma cóo manī gā i. ");
INSERT INTO mibNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Te ñayuu cuɨñɨ nīhin jíín jnúhun ri nde quɨvɨ̄ jínu, ñayuu ún chi cācu. ");
INSERT INTO mibNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Te jnūhun yáha sɨ́quɨ̄ ndese ndácu Yaā Dios jniñu, cuitē núu nɨ́ɨ́ cáhnu ñayɨ̄vɨ́, návāha cuni ñayuu tācá nación. Yūcuán na te jīnu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Te Daniel, tēe ni nacani jnūhun Yaā Dios, ni tee de jnūhun ɨɨn tēe néé jéē quíji. Te róhó jéē cácahu tutu ún, na jécūhun ni rō. Chi ɨɨn quɨvɨ̄ te cuni rō jeē sáha ndevāha de jeē stɨ́vɨ de tācá ndajníñu iī ini templo, te cuɨñɨ de ini lugar iī. ");
INSERT INTO mibNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Te núu cuni rō jeē súcuan cúu, te ñayuu cáyūcú región Judea, na cúnu i caa i yucu quingoo i. ");
INSERT INTO mibNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Te ñayuu cáyūcu núū quéhe, ma ndɨ́vɨ i ini vehe jeē quénehen i ndajníñu i, chi cánuú cunu yachī i návāha cācu i. ");
INSERT INTO mibNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Te ñayuu cáhīin nuū ítu, ma ndíji i vehe jeē quíhin i sahma i. ");
INSERT INTO mibNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Te quɨvɨ̄ ún nacā jeē ndahú ñahan cáñuhun sēhe jíín ñahan cándeca yɨquɨ́n, chi ma cúnihin ña cunu yachī ña. ");
INSERT INTO mibNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Te cacān tahú rō jeē ma quíji jnūndóho un jéē cunu ró máá tiempo cúun yuhvā ni quɨvɨ̄ ndétātú. ");
INSERT INTO mibNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chi jeē quejéé un te coo cuehē jnūndóho xeēn, jeē ná tu coo súcuan nde quɨvɨ̄ ní jecōo ñayɨ̄vɨ́ te nde vijna. Te jeē ndɨ́hɨ jnūndóho ún te ni ma cóo ga jeē súcuan. ");
INSERT INTO mibNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Te núu tú nastɨ́yɨ Yaā Dios tiempo jnūndóho ún, te ni ɨɨn ñayuu ma cácu cuɨtɨ i. Te jeē sɨquɨ́ ñáyuu cácandíje jeē ní nacāji ya, jeē yúcuan nastɨ́yɨ ya tiempo un. ");
INSERT INTO mibNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Núu súcuan te núu ɨɨn ñayuu cahān jiín ró: Yāhá condēhe ró íne Cristo, chí: Yūcuán condēhe ró íne ya, achi i, te ma candíje ró jéē cahán i. ");
INSERT INTO mibNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chi canecoo tēe cástáhú jéē achi de jeē Cristo cúu de, chí achi de jeē tée nácani jnūhun Yaā Dios cúu de. Te sáha de jniñu jéhnu jeē naa ni ñayuu coto i, návāha stáhú de nde maá ñáyuu ní nacāji ya, te núu na cúu. ");
INSERT INTO mibNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Je ni castūhun rí nuū rō vijna nde ná tu coo. ");
INSERT INTO mibNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Núu súcuan te núu cahān ñayuu jiín ró: Cuácondēhe ró, chi nde nuū ñúhun téhé íne ya, achi i, te ma quihín rō condēhe ró. Chí núu cahān i: Nehen condēhe ró, chi ini vehe yāha íne ya, achi i, te ma candíje ró jíjnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Chi nájnūhun jeē ndíndēe sáha taja te cúndijin nde ichi núū cáne niāndii jíín ndé ichi núū quée niāndii, suni súcuan coo quɨvɨ̄ ndiji ruhū, Yaā ní nduu tēe, chi ndɨhɨ ñayuu coto. ");
INSERT INTO mibNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Te nájnūhun jeē cutútú téji ndé‑ni cúu nuū catú quɨtɨ ní jíhī, suni súcuan coo tāca jéē ni cáhān rī ndé‑ni cúu‑ni nuū cáhīyo ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Yūcuán na te núu ni ndɨhɨ tāca jnúndóho quɨvɨ̄ ún, te cojnúú níāndii, te yoō ma ndíī gā. Te nɨngoo quɨ̄mɨ andɨvɨ́. Te tāca jéē íin andɨvɨ́ chi quɨsɨ i. ");
INSERT INTO mibNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yūcuán na te coto ñayuu nuū maá rí, Yaā ní nduu tēe, ndiji ri ichi ándɨvɨ́. Te ndahyū ñayuu tācá nación nɨɨ́ cáhnu ñayɨ̄vɨ́. Te coto i nuū ruhū, Yaā ní nduu tēe, ndiji ri jiín vícō andɨvɨ́, te condiso ri cuehē poder, te yōhyo luu cujéhnu ri. ");
INSERT INTO mibNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Te tají rí ndajéhé rī quingoo, te tɨvɨ nīhin ya trompeta. Te quinastútú yá ñayuu ní nacāji ri ndɨcúún lado ñayɨ̄vɨ́, nde ɨɨn lado ñayɨ̄vɨ jíín ndé ɨnga lado. ");
INSERT INTO mibNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Vijna te scuáha ró ndese sáha nundēhe higo: Núu je ni nane numa, te ni najee ndaha, te cájini rō jeē jé ni cuyajni tiempo jihní. ");
INSERT INTO mibNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Te suni súcuan núu ni cajini rō jeē ní quejéé cúu tācá jniñu jeē ni cáhān rī, yūcuán na te na jécūhun ni rō jeē ní cuyajni quɨvɨ̄ ndiji ri, te yachī coo. ");
INSERT INTO mibNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Jendaá cahán rī jiín ró jeē ma cúū ndɨhɨ ñayuu jeē cóto jnūndóho ún, chi nde squícu ndɨhɨ jniñu ún. ");
INSERT INTO mibNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Andɨvɨ́ jíín ñáyɨ̄vɨ́ chi naa, te tāca jnúhun cáhán rī chi ma náā, chi ndɨhɨ squícu. ");
INSERT INTO mibNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Te quɨvɨ̄ jiín hora jeē ndíji ri, tú ni ɨɨn ñayuu jiní, ni máá ndajéhé cáhīyo andɨvɨ́, ni máá rí, Sēhe Yaā Dios. Chi máá ɨɨn ni Tátá rī Yaā Dios cúu jeē jiní. ");
INSERT INTO mibNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Chi nájnūhun ni cuu quɨvɨ̄ ni íyo Noé, suni súcuan coo quɨvɨ̄ ndiji ruhū, Yaā ní nduu tēe. ");
INSERT INTO mibNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chi quɨvɨ̄ ún, nde ná tu cuun saū xeén, te cáyeji i cájihi i, cánandāha i, te cájēhe i sēhe sɨ́hɨ́ i jeē nándāha, nde ni jinū quɨvɨ̄ jeē ni quɨ́vɨ Noé ini barco cáhnu jeē naní arca. ");
INSERT INTO mibNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Te tu ní cácandíje ñayuu jeē cuun saū xeén, te ni cuun, te ni ndaa ndute ni cajihī ndɨhɨ i. Te suni súcuan coo núu na ndíji ruhū, Yaā ní nduu tēe. ");
INSERT INTO mibNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Te quɨvɨ̄ ún cone uū tēe sájniñu nuū ítu. Te ɨɨn de naquihin ri, te ɨnga de ndōo. ");
INSERT INTO mibNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Te coo uū ñahan jeē ndíco cáhnu, te ɨɨn ña naquihin ri, te ɨnga ña ndōo. Súcuan cuu jeē sava ñayuu naquihin ri te sava i quendōo, chi tu ní cácandíje i. ");
INSERT INTO mibNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Núu súcuan te ndito na cóo ni rō, chi tu cájini rō na quɨvɨ̄ ndiji Jitoho rō. ");
INSERT INTO mibNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Te na chúhun ni rō jeē cahán jnūhun yátá yáha: Tēe chíí vehe, núu jeē jiní de na hora quiji ñacuīhná, te condito de, te ma cuáha de jnūhun sácuíhná ndajníñu vehe de núú. ");
INSERT INTO mibNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Te róhó jíjnáhan ró, suni súcuan coo tūhva ró, chi máá hora jeē tú na vé cájeni ni rō, te ndiji ruhū, Yaā ní nduu tēe. ");
INSERT INTO mibNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Núu súcuan te coo ró nájnūhun ɨɨn mozo jeē ndíto xinī te squícu vāha. Te máá patrón ni jeni de mozo un jéē cóto i ñayuu vehe de, návāha scáji i máá hora. ");
INSERT INTO mibNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Te yōhyo ndetū mozo un jéē núu ni ndee patrón, te cuni de jeē súcuan squícu vāha i. ");
INSERT INTO mibNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jendaá cahán rī jiín ró jeē cani de mozo un jéē cóto i ndɨhɨ ndajníñu de. ");
INSERT INTO mibNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Te núu mozo sáha néé cúu i, te jéni ni i jeē ma ndíji yachī patrón i, ");
INSERT INTO mibNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","te quejéé i cani i jnáhan mozo i, te caji i coho i jíín tée cánajīni, ");
INSERT INTO mibNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","núu súcuan te ndee‑ni patrón quɨvɨ̄ jeē tu ndétu i jíín hora jeē tú na vé jéni ni i. ");
INSERT INTO mibNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Te stóho xeēn de i, te squɨ́vɨ de i nuū cáhīin tēe stáhú‑ni. Te yūcuan ndáhyū i te nacayɨ̄hɨ́ yuhu i jeē ndoho xeēn i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Te suhva cúu jeē ndácu Yaā andɨvɨ́ jniñu nuū ñáyuu: Cúu nájnūhun ɨɨn vico nándāha. Te ni īyo uxī sūchi sɨ́hɨ́ jeē ní caquihin i linterna cándaha i, te ni quendacoo i cuajnahan i ɨɨn tēe nandāha. ");
INSERT INTO mibNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Te uhūn i chi tú ndito xinī i, te uhūn i chi ndito xinī i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Te sūchi tú ndito xinī, cándaha i linterna i, te tu cándaha i petróleo jeē náchuhun i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Te sūchí ndito xinī, chi cándaha i botella petróleo jiín linterna i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Te níní cúcuéé quiji tēe nandāha ún, te ni quee māhná, te ni caquixī ndɨhɨ i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Te nuū ní cuu sava ñuú, te ni cajini i jeē cácana jee: Je vēji tēe nandāha. Cuángoo quijnahan rō de jíjnáhan ró, áchí. ");
INSERT INTO mibNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Yūcuán na te tāca súchi sɨ́hɨ́ un ní candonda i, te ni casátūhva i linterna i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Te sūchi tú ndito xinī, ni cacahān i jíín súchi ndito xinī: Cuāha jecu petróleo nuū rī jijnáhan ró, chi cuandahvā linterna rī, achí i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Te ni cacahān sūchí ndito xinī: Ma cúu, chi ma cánda jeē cúu máá rí jiín máá ró. Vāha ga quingoo ró núū cúyāhu, te cuaan ró jéē cúu máá ró. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Te níní cuángoo i cuaan i, te ni quee‑ni tēe nandāha. Te sūchi cáhīyo tūhva un, ní quɨ̄vɨcoo i jíín de vico nándāha de. Te ni ndihyū yehyɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Te ni cunúu, te ni quecoo uhūn gā sūchi sɨ́hɨ́ un. Te ni cacahān i jíín tée nándāha: Nune ní yéhyɨ́ na quɨ́vɨcoo ná, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Te ni cahān maá de: ¿Ndé nuū véjicoo ró? Chi tu jíní rī rohó, áchí de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yūcuán na te ni cahān yā: Núu súcuan te ndito coo ni rō, chi tu cájini rō na quɨvɨ̄ na hora ndiji ruhū, Yaā ní nduu tēe. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Te suhva cúu jeē ndácu Yaā andɨvɨ́ jniñu nuū ñáyuu: Cúu nájnūhun ɨɨn tēe jeē quihīn jicá de ɨnga ñuu. Te nde ná tu quihīn de te ni cana de mozo de jíjnáhan, te ni jēhe núu de xūhún de nuū i, jeē na sájniñu i jíín návāha nducuehē. ");
INSERT INTO mibNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Te nuū ɨɨn i ni jēhe de uhūn mil xūhun cáa. Te nuū ɨnga i ni jēhe de uū mil. Te nuū ɨnga i ni jēhe de ɨɨn mil. Súcuan ni jēhe de, chi jíní de nasaa canda ɨɨn ɨɨn i sájniñu i jíín. Yūcuán na te ni quihin de ichi cuahān jicá de. ");
INSERT INTO mibNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Te mozo jeē ní quihin uhūn mil xūhún, ni sájniñu de jíín. Te ni nihīn de uhūn gā mil sɨquɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Te mozo jeē ní quihin uū mil xūhún, suni ni nihīn de uū gā mil sɨquɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Te mozo jeē ní quihin ɨɨn mil xūhún, ni jehēn de ni jete de yaū, te ni chisāhí de xūhún patrón de. ");
INSERT INTO mibNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Te ni yāha cuehē tiempo, te ni ndee patrón mozo un jíjnáhan. Te ni nandacān de cuenta nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Te ni quee mozo jeē ní quihin uhūn mil xūhún un, te ni nacuāha de xūhún un núū patrón de jíín úhūn gā mil jeē ni níhīn de sɨquɨ̄. Te ni cahān de: Ni jēhe ní úhūn mil nuū ná, te yāha íyó úhūn gā mil jeē ni níhīn na sɨ́quɨ̄. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Te ni cahān patrón jiín de: Iyó váha núu súcuan. Yōhyo vāha mozo cúu ró jéē squícu vāha ró. Chi vāha ni squícu ró ɨɨn jniñu lúlí‑ni, te vijna te cuāha ri jniñu jéhnu ndacu ró. Te quɨ̄vɨ ró núū cusɨɨ̄ ni rō jiín rí. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yūcuán na te ni quee mozo jeē ní quihin uū mil xūhún un. Te ni cahān de: Ni jēhe ní úū mil nuū ná, te yāha íyó úū gā mil jeē ni níhīn na sɨ́quɨ̄. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Te ni cahān patrón jiín de: Iyó váha núu súcuan. Yōhyo vāha mozo cúu ró jéē squícu vāha ró. Chi vāha ni squícu ró ɨɨn jniñu lúlí‑ni, te vijna te cuāha ri jniñu jéhnu ndacu ró. Te quɨ̄vɨ ró núū cusɨɨ̄ ni rō jiín rí. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Te ni quee mozo jeē ní quihin ɨɨn mil xūhún un, te ni cahān de jíín patrón: Je jíní na níhín jéē tée xeēn cúu ní. Chi cuehē gā cuní ni vēsú jeē cúu sáha mozo ni, te cuehē gā nándacān ní vēsú jeē ni jéhe ní. ");
INSERT INTO mibNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Te jeē yúcuan ní yūhu ná, te ni jehēn na ní chisāhi ná xūhun ní chīji ñuhun. Te yāhá na nácuāha na xúhun ní. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Te ni cahān patrón jiín de: Mozo cuxí cúu ró te máni jniñu néé sáha ró. Chi jéni ni rō jeē cuehē gā cuní rī vēsú jeē cuu sáha mozo rī, te cuehē gā nándacān rī vēsú jeē ni jéhe ri. ");
INSERT INTO mibNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Núu jeē ni chúne ró xúhun rí nuū banco nuú, te jeē ní ndee rī te naquihin ri xūhun rí nde jiín séhe xūhun núú. Achí de jíín i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Te ni cahān de jíín táca gá mozo de: Núu súcuan te quende rō mil xūhun jíñā nuū i, te cuāha ro núū mozo névāha uxī mil. ");
INSERT INTO mibNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chi ñayuu jeē névāha, sa quiji ga nuū i, te conevāha cuehē i. Te ñayuu jeē tu névāha, sa cujiyo‑ni vēsú jecu jeē névāha i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Te mozo yáha jéē tu sájniñu vāha, quenehen ró i na quíhín i nuū quéhe nuū néē. Te yūcuan ndáhyū i te nacayɨ̄hɨ́ yuhu i jeē ndoho xeēn i. Achí patrón un. ");
INSERT INTO mibNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Te ni cahān gā yā: Ɨɨn quɨvɨ̄ te ndiji máá Yaā ní nduu tēe, te cuu ya Rey nuū ñáyuu. Te tācá ndajéhé yā cuɨñɨ nɨ́ɨ́ xiin ya. Te cucōo ya mesa nuū ndácu ya jniñu, te yōhyo luu cujéhnu ya. ");
INSERT INTO mibNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Te ndutútú ñayuu tācá nación nuū yā. Te sásɨ́ɨn ya i jíjnáhan i, nájnūhun cúsɨ́ɨn lanchi jíín ndixúhú sáha tēe ndíto tɨ. ");
INSERT INTO mibNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Te ñayuu váha jeē cúu nájnūhun lanchi, chucú yá i lado váha ya. Te ñayuu neé jeē cúu nájnūhun ndixúhú, chucú yá i lado jecó yá. ");
INSERT INTO mibNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yūcuán na te cahān Rey jiín ñáyuu cáhīin lado váha ya: Nacā ndetū rō jeē ni sáha Tátá rī jiín ró. Nehen quɨ̄vɨcoo ró núū ndácu ró jniñu. Chi nde quɨvɨ̄ ní jecōo ñayɨ̄vɨ́ te je ni sátūhva ya nuū ndacu ró jniñu. ");
INSERT INTO mibNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Chi ni jiī rī sōco, te ni cajēhe ro jéē ní yeji rī. Ni jichī rī ndute, te ni cajēhe ró jéē ní jihi ri. Ni quiji ri nde ñuu jicá, te ni cajēhe núú ró vehe ni ndōo ri. ");
INSERT INTO mibNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ni cumanī sahma ri, te ni cajēhe ró. Ni cocuhū rī, te ni jecondēhe ró ruhū. Ni ine ri vecāa, te suni ni jecondēhe ró ruhū. Súcuan cahān yā jiín ñáyuu cáhīin lado váha ya. ");
INSERT INTO mibNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yūcuán na te cahān ñayuu váha un jíín yá: ¿Na quɨvɨ̄ ní cajito ná níhín jéē jíī ni sóco, te ni cajēhe na jéē ní yeji ní, chí jéē jichí ni ndute, te ni cajēhe ná ní jihi ní? ");
INSERT INTO mibNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Te na quɨvɨ̄ ní cajito ná jéē ní quiji ní ndé ñuu jicá, te ni cajēhe núú ná vehe ni ndōo ní, chí jéē cúmanī sahma ní, te ni cajēhe ná? ");
INSERT INTO mibNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Te na quɨvɨ̄ ní cajito ná jéē cuhú ni, chí jéē íne ní vecāa, te ni jecondēhe ná nihín? achi i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yūcuán na te cahān Rey jiín i: Jendaá cahán rī jiín ró jéē ná ni casáha ró súcuan jíín ɨɨn tācá hermano rī jeē cácandíje, vēsú ñayuu núu ga cúu i, te nuū maá rí ni casáha ró. ");
INSERT INTO mibNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Yūcuán na te suni cahān Rey jiín ñáyuu cáhīin lado jecó yá: Ñayuu jnahnū ndetū cácuu ró. Cujiyo quingoo ró núū ñuhún jeē cayú nɨɨ́ cáni, nuū iyó túhva cone jexeén jiín táca táchī jeē cájejníñu nuū. ");
INSERT INTO mibNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Chi ni jiī rī sōco, te tu ní cájēhe ro jéē cáji rī. Ni jichī rī ndute, te tu ní cájēhe ro jéē coho ri. ");
INSERT INTO mibNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ni quiji ri nde ñuu jicá, te tu ní cájēhe núú ró vehe ndōo ri. Ni cumanī sahma ri, te tu ní cájēhe ró. Ni cocuhū rī, ni ine ri vecāa, te tu ní jécondēhe ró ruhū. Súcuan cahān yā jiín ñáyuu cáhīin lado jecó yá. ");
INSERT INTO mibNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yūcuán na te cahān ñayuu un jíín yá: ¿Na quɨvɨ̄ ní cajito na níhín jéē jíī ni sóco, chí jéē jichí ni ndute, chí jéē ní quiji ní ndé ñuu jicá, chí jéē cúmanī sahma ní, chí jéē cuhú ni, chí jéē íne ní vecāa, te tu ní cájēhe na jéē cúmanī nuū ní? Achi i. ");
INSERT INTO mibNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yūcuán na te cahān yā jiín i: Jendaá cahán rī jiín ró, jeē tu ní cásáha ró súcuan jíín ni ɨɨn tācá hermano rī jeē cácandíje, vēsú ñayuu núu ga cúu i. Núu súcuan te suni nuū maá rí cúu jeē tu ní cásáha ró, achi yā. ");
INSERT INTO mibNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yūcuán na te quingoo ñayuu un núū ndóho i nɨ́ɨ́ cáni. Te ñayuu váha un quɨ́vɨcoo i nuū cótecu i nɨ́ɨ́ cáni. Achí Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Te nuū ní ndɨhɨ ni cahān Jesús tāca jnúhun yáha, te ni cahān yā jiín tée cáscuáha jíín yá: ");
INSERT INTO mibNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Je cájini rō jeē uū na quɨvɨ̄ te coo vico pascua. Te ruhū, Yaā ní nduu tēe, nastúu i ruhū jeē cúū rī jicā cruz, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yūcuán na te sutū cácujéhnu, jíín tée cástéén tutu ley, jiín táca tée jéhnu jeē cándacu jniñu nuū ñáyuu hebreo, ni candutútú de ini patio vehe palacio maá sútū cujéhnu ga jeē naní Caifás. ");
INSERT INTO mibNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Te ni candajnūhún de ndese jnɨɨ de Jesús jiín jnúhun stáhú, te cahni de ya. ");
INSERT INTO mibNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Te ni cacahān de: Ma jnɨ́ɨ yó de máá quɨ́vɨ̄ víco, chi ndonda ñayuu sɨquɨ̄ yō, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Te íne Jesús ñuu Betania vehe Simón, tēe ni ndoho cuehyɨ̄ stehyú. ");
INSERT INTO mibNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Te ni quee ɨɨn ñahan nuū yā, ndáhá ña ɨɨn frasco yuū luu jeē ñúhun aceite perfume jeē yóhyo yahu ndéé. Te ni chuhun ña xinī yā níní jéē yéji yā staā. ");
INSERT INTO mibNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Te ni cajito tēe cáscuáha jíín yá, te ni caquɨtɨ̄ ni de, te ni cacahān de: ¿Najehē cúu jeē náā saá‑ni perfume jiñā? ");
INSERT INTO mibNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Chi cuu xīcó yahu yó núú, te cuāha yo xúhun núū ñáyuu ndahú. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Te ni jini Jesús jnūhun cácahān de. Te ni cahān yā jiín de: ¿Naun cásáha ró jéē nácani uhū ni ñahan yáha? Chi ɨɨn jniñu váha cúu jeē ni sáha ña jíín rí. ");
INSERT INTO mibNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Chi níní coyūcu ñáyuu ndahú jíín ró, te ruhū chi tuá condee rī jiín ró. ");
INSERT INTO mibNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Chi jeē ní chuhun ña perfume yáha ruhū, suu cúu jeē ni sátūhva ña ruhū nde quɨvɨ̄ quíndūji ri. ");
INSERT INTO mibNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Jendaá cahán rī jiín ró jeē nɨɨ́ cáhnu ñayɨ̄vɨ ndé‑ni cúu nuū cuité jnūhun yáha jéē jnáma ri ñayuu, suni nacani i jnūhun jeē ni sáha ñahan yáha, návāha cocuhun ni ñayuu ña, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yūcuán na te ɨɨn jeē ndɨhúxí uū tēe cáscuáha ún, nání de Judas Iscariote, ni jehēn de nuū sutú cácujéhnu. ");
INSERT INTO mibNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Te ni cahān de jíín: ¿Nasaa cuāha ní núū ná, te na nástúu ná de nuū ní? áchí de. Te ni cajēhe ocō uxī xūhun plata nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yūcuán na te nde quɨvɨ̄ un ní quejéé de ndúcú de modo ndese nastúu de ya nuū sutú jijnáhan. ");
INSERT INTO mibNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Te máá quɨ́vɨ̄ jeē quejéé vico jeē cáyeji ñayuu pan jeē tú na levadura yɨ́hɨ, te ni quijicoo tēe cáscuáha un núū Jesús. Te ni cacahān de jíín yá: ¿Ndé nuū cuní ni jéē quísatūhva ná cuxíni ní vico pascua? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Te ni cahān yā: Cuángoo nde ñuu, vehe tēe jeē jé ni cacahān yō, te cahān rō jiín de: Achí máá Maestro jeē ní cuyajni quɨvɨ̄ cuu yā. Te vijna te caji yā vico pascua ini vehe ní jíín tée cáscuáha jíín yá, achi rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Te tēe cáscuáha jíín yá, ni casáha de nájnūhun ni ndacu Jesús jniñu nuū de, te ni casátūhva de jeē cuxíni ya vico pascua. ");
INSERT INTO mibNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Te jeē cuácuaa, te ni quee yā, te ni cucōo ya mesa jiín ndɨhúxí uū tēe cáscuáha jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Te níní yéji yā jiín de te ni cahān yā: Jendaá cahán rī jiín ró jeē ɨɨn róhó nastúu ruhū vijna, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Te ni cacucuíhyá ndasɨ́ ni de. Te ná ɨɨn ná ɨɨn de ni cacajnūhún de ya: ¿A sáña cúu? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Te ni cahān yā: Ɨɨn róhó jéē cáyeji cáhnu jíín rí ɨɨn cohō, suu ró nastúu ruhū. ");
INSERT INTO mibNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Te ruhū, Yaā ní nduu tēe, jendaá cúu jeē quihín rī cuu rī, nájnūhun yósó jnúhun ri nuū tútu iī. Te nacā xeēn ndoho tēe nastúu ruhū. Vāha ga núu tu ní cácu tēe un núú, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yūcuán na te ni cahān Judas, tēe nastúu ya: ¿A sáña cúu, Maestro? achí de. Te ni cahān yā jiín de: Suu ró cúu, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Te níní jéē cáyeji de jíín yá, te ni quihin ya pan, te ni nacuatáhú yá, te ni tahú cuéchí yá, te ni jēhe ya nuū tée cáscuáha jíín yá. Te ni cahān yā: Caji rō jijnáhan ró, chi yāha cúu yɨquɨ cúñu rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yūcuán na te ni quihin ya ɨɨn copa ndūxi uva, te ni nacuatáhú yá, te ni jēhe ya nuū de. Te ni cahān yā: Coho jíjnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Chi yāha cúu nɨñɨ̄ rī jeē cuáha ri jeē cúu contrato jeé, te catɨ jeē ndundoo cuēchi cuehē ñayuu, te coo jnūhun cáhnu ni nuū cuéchi i. ");
INSERT INTO mibNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Te cáhán rī jiín ró jeē ndé vijna te ma cóho ga rī ndūxi ndehē uva yāhá, chi nde quiji quɨvɨ̄ ndacu Tátá rī jniñu nɨ́ɨ́ ñayɨ̄vɨ́, te sáá te coho tucu ri jiín ró jijnáhan ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Te ni jita ya ɨɨn yaa iī jiín de jíjnáhan de. Te ni quenda ya cuahān yā jiín de nde yucu Olivos. ");
INSERT INTO mibNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yūcuán na te ni cahān yā: Ndɨvii rō nayūhu ró jeē sɨquɨ́ ruhū jecuáā vijna. Chi suhva je yósó jnúhun ri nuū tútu iī, ni cahān Yaā Dios: Cuāha ri jnūhun jeē cáhni ñayuu tēe ndíto lanchi, te lanchi un cuítē núu tɨ jeē yūhu tɨ́, achí. ");
INSERT INTO mibNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Te jeē nátecu rī, te xīhna ruhū cosnūu rí quihīn rī región Galilea, te sáá te najinūcoo ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yūcuán na te ni cahān Pedro: Vēsú ndɨhɨ de na náyūhú de, te máá ná chi ma náyūhú cuɨtɨ ná, áchí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Te ni cahān yā jiín de: Jendaá cahán rī jiín ró jeē jecuáā vijna, nde ná tu cana líhli, te yūhu ró jeē jnɨɨ ñayuu rohó, te unī jínu cahān rō jeē tu jíní rō ruhū, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Te ni cahān Pedro jiín yá: Vēsú núu cuu na jíín ní, te ma cahán cuɨtɨ na jéē tu jíní na níhín, áchí de. Te suni súcuan ni cacahān ndɨhɨ tēe cáscuáha jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yūcuán na te ni jinū Jesús jiín tée cáscuáha jíín yá ɨɨn lugar nuū naní Getsemaní. Te ni cahān yā jiín de: Yāhá‑ni cucōo ró, te na quíhín rī yūcuan cácān tahú rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Te ni jeca ya Pedro jiín ndɨndúú séhe Zebedeo cuahān yā jiín de. Te ni quejéé yá cucuíhyá ndasɨ́ ni yā te cúxií ni yā jeē quíji jnūndóho sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yūcuán na te ni cahān yā jiín de: Yōhyo cúcuíhyá ni rī, te ndúcú sáha jeē cúū rī. Yāhá condetu ró te condito ró jíín rí. ");
INSERT INTO mibNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Te ni jica ya jecu gā, te ni jecuɨñɨ̄ yɨtɨ́ yá ni jequin ya nuū yā nuū ñúhun, te ni jicān tahú yā suhva nuū Yaā Dios: Tátá maá ná, núu cuu te tejiyo ní jnúndóho yáha jéē ma quíji sɨquɨ̄ ná. Te nasūu jéē cuní maá ná, chi jeē cuní maá ní na cóo, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yūcuán na te ni ndee yā nuū ndɨnúní tée cáscuáha jíín yá, te ni jito ya jeē cáquixī de. Te ni cahān yā jiín Pedro: ¿A tu ní cánda ró condito ró jíín rí vēsú ɨɨn hora? ");
INSERT INTO mibNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Coo ndito ni rō te cacān tahú rō jeē chindéé ñáhán yá rohó jéē ma sáha ró cuéchi jeē coto ndee jeneé róhó. Chi cúní ndije ánuá rō squícu vāha ró, te yɨquɨ cúñu rō chi tu fuerza, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Te ni jehēn tucu ya vuelta uū, te suhva ni jicān tahú yā: Tátá maá ná, te núu ma cúu cujiyo jnūndóho yáha jeē ma ndóho ná, te na cóo jeē cuní maá ní núu súcuan, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Te ni ndee tucu ya nuū de, te ni jito ya jeē cáquixī tucu de, chi yōhyo cájiī de māhná. ");
INSERT INTO mibNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Te ni stóo ya de, te cuahān tucu ya cuacacān tahú yā vuelta unī. Te suni jnūhun yúcuan ní cahān yā. ");
INSERT INTO mibNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yūcuán na te ni ndee tucu ya nuū de jíjnáhan de, te ni cahān yā jiín de: Vijna te cusū rō te ndetātu ró. Te je ni quee hora, te ruhū, Yaā ní nduu tēe, natūu ri te jnɨɨ tēe cáhīyo cuēchi ruhū. ");
INSERT INTO mibNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ndocuɨñɨ̄ jijnáhan ró, chi je vēji tēe nastúu ruhū, te quihīn yō jiín de, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Te sá cáhán gā yā súcuan, te ni quee‑ni Judas, ɨɨn jnáhan jeē uxí uū tēe cáscuáha jíín yá. Te vējicoo cuehē tēe jíín de, cándaha de espada jiín yujnu. Chi sutū cácujéhnu jíín táca tée jéhnu cándacu jniñu nuū ñáyuu hebreo, ni catají tée ún. ");
INSERT INTO mibNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Te Judas, tēe nástúu ya ún, je ni jēhe de ɨɨn seña nuū tée un jíjnáhan, chi ni achi de: Tēe jeē téchūhu rí un cúu. Te jnɨɨ ró jíjnáhan ró, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Te ni quee‑ni de nuū Jesús, te ni cahān de: Ta ni cuaa, Maestro, achí de. Te ni techūhú de ya. ");
INSERT INTO mibNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Te ni cahān Jesús jiín de: Amigo, ¿na jniñu vēji ró? áchí yá. Yūcuán na te ni jinūcoo tāca gá tēe ún, te ni cajnɨɨ de Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Te ɨɨn tēe jeē cáhīin jíín Jesús, ni tava de espada de, te ni jehnde de sōho ɨɨn mozo maá sútū cujéhnu ga. ");
INSERT INTO mibNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yūcuán na te ni cahān Jesús jiín de: Nachuvāha espada rō, chi tāca jéē cájejnáhan jíín espada, suni jíín espada cuu. ");
INSERT INTO mibNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Te á tu cájini rō jeē cuu cacān tahú rī nuū Tatá rī, te vijna ñúhún tají yá víhyá gā uxī uū mil ndajéhé andɨvɨ́ jeē jnama ruhū? ");
INSERT INTO mibNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Te núu súcuan, ¿te ndese cuu squícu jnūhun cáhán tutu iī jeē cánuú ndoho ri súcuan? áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yūcuán na te ni cahān yā jiín ñáyuu cuehē ún: ¿Te va tēe cuíhná cúu ri jeē véjicoo ró jíín espada jiín yujnu jeē jnɨɨ ró rúhū jeē súcuan. Tāca quɨ́vɨ̄ ni cucōo ri jiín ró jijnáhan ró ini templo cáhnu, ni steén rī jnūhun, te tu ní cájnɨɨ ró rúhū. ");
INSERT INTO mibNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Te súcuan cásáha ró návāha na squícu jeē cahán tutu iī jeē ní catee tēe ni canacani jnūhun Yaā Dios, achí yá. Yūcuán na te ndɨhɨ tēe cáscuáha jíín yá, ni castóo de ya, ni cajinu de cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Te tēe ni cajnɨɨ Jesús, cuangoo de jíín yá nuū Caifás, tēe cúu sutū cujéhnu ga. Te yūcuan cáhīin tútú tée cástéén tutu ley jiín táca tée jéhnu cándacu jniñu. ");
INSERT INTO mibNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Te Pedro chi jícá‑ni ndíquín de ya, te ni jinū de patio sutū cujéhnu ga. Te ni quɨ̄vɨ de ini patio, te ni cucōo de jíín táca policía, návāha coto de ndese coo sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Te sutū cácujéhnu jíín táca tée jéhnu jíín ndɨhɨ tēe cásáha junta cujéhnu ga, ni canducú de tēe cahān jnūhun yáá sɨ́quɨ̄ Jesús, chi cahni de ya cácuni de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Te vēsú ni quecoo cuehē ñayuu cácahān yaá, te tu ní cánihīn de cuēchi sɨquɨ̄ yā jeē cáhni de ya. Te jeē sándɨ̄hɨ́ te ni quecoo uū testigo jeē cahán yaá sɨ́quɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Te áchí: Tēe yáha ní cahān de jeē cuu canu de templo Yaā Dios, te nuū uní‑ni quɨvɨ̄ te nucondichi sáha de, áchí. ");
INSERT INTO mibNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yūcuán na te ni ndocuɨñɨ̄ maá sútū cujéhnu ga, te ni cahān de jíín yá: ¿Naun tu cáhán cuɨtɨ rō? ¿A íyó ndáā jeē cácahān tēe yáha sɨ́quɨ̄ rō? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Te Jesús tu ní cáhán cuɨtɨ yā. Te ni cahān maá sútū cujéhnu ga: Ndácu ri jniñu nuū rō jeē cahān ndaā rō cuni nahín maá Yaā Dios, Yaā técu. Cachi cají te núu máá ró cúu Cristo, Sēhe Yaā Dios, achí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Te ni cahān yā: Suu ri cúu, nájnūhun cáhán rō. Te na cástūhun rí nuū rō jijnáhan ró jéē tāca quɨ́vɨ jeē quíji te coto ró rúhū, Yaā ní nduu tēe, condee rī lado váha Yaā iyó poder. Te coto ró jéē ndíji ri ichi ándɨvɨ́ jíín vícō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yūcuán na te sutū cujéhnu ga ni jehnde de sahma de jeē quɨtɨ́ ndasɨ́ ni de, te ni cahān de: Tēe yáha chi cáhán de jnūhun ndevāha jeē quɨtɨ́ ni Yaā Dios, chi sáha de máá de Sēhe Yaā Dios. ¿Ndé jíni ñúhún gá yō testigo núu súcuan? Chi je ni cajini ró jnúhun ndevāha cáhán de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Te ndese cájeni ni rō? achí de. Te ni cacahān tēe cuehē ún: Cuēchi cúu jeē cahán de súcuan, te jíni ñúhún cuu de, áchí. ");
INSERT INTO mibNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yūcuán na te ni catesɨ̄hɨ́ de nuū yā, te ni cacani de ya. Te sava ga de ni cacatu de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Te ni cacahān de: Te núu Cristo cúu ró, te cachi rō ndé ɨɨn cúu jeē ní cani róhó, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Te níní jéē súcuan cúu, te Pedro néne de nuū quéhe ini patio. Te ni quee ɨɨn ñahan jéjníñu vehe ún, te ni cahān ña jíín de: Róhó chi suni ni jica ró jíín Jesús tēe Galilea, achí ña. ");
INSERT INTO mibNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Te máá de tu ní cáchi de, chi ni cahān de ni cajini ndɨhɨ ñayuu: Tu jíní rī na jnūhun cáhán rō, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Te ni quenda de yéhyɨ́ núū quéhe, te ni jito ɨnga ñahan nuū de. Te ni cahān ña jíín ñáyuu cáhīin yūcuán: Tēe yáha chi suni ni jica de jíín Jesús, tēe ñuu Nazaret, achí ña. ");
INSERT INTO mibNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Te ɨnga jínu tu ní cáchi tucu de, chi sa ni cahān teyɨ́ de: Tu jíní rī tēe ún, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Te ni cunúu jecu gā, te ñayuu cáhīin yūcuan ní quecoo i nuū Pedro, te ni cacahān i: Jendaá ndije jeē suni jnáhan tēe un cúu ró, chi ndijin cahán rō jeē tée Galilea cúu ró, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yūcuán na te ni quejéé de cáhán teyɨ́ de jeē na cóndee cuēchi sɨquɨ̄ de núu tu cáhán ndaā de: Tu jíní cuɨtɨ rī tēe ún, áchí de. Te ni cana‑ni líhli. ");
INSERT INTO mibNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Te ni nucūhun ni de jnūhun ni cahān Jesús jiín de: Nde ná tu cana líhli, te yūhu ró te cahān rō unī jínu jeē tu jíní rō ruhū. Te ni quenda de cuahān de, te yōhyo ni ndahyū de jeē ní cachi de jeē tu jíní de ya. ");
INSERT INTO mibNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yūcuán na te ni cundijin. Te tāca sútū cácujéhnu jíín táca tée jéhnu jeē cándacu jniñu nuū ñáyuu hebreo, ni casquíjnáhan de jnūhun ndese sáha de jeē cuu Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Te ni cajihni de ya, te cuangoo de jíín yá nuū Poncio Pilato, tēe cúu gobernador. ");
INSERT INTO mibNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yūcuán na te Judas, tēe ni nastúu ya un, ní jito de jeē ní cunīhin sɨquɨ̄ yā jeē cúū yā. Te ni jnahuhū ni de, te ni nacuāha de ocō uxī xūhun plata jeē ni níhīn de nuū sutú cácujéhnu jíín núū tāca tée jéhnu. ");
INSERT INTO mibNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Te ni cahān de jíín: Cuēchi ni sáha ná jéē ní nastúu ná ɨɨn tēe cuu de, te tú na cuēchi de. Te máá sútū un ní cacahān de: ¿Vé jitú ni ruhū? Cuēchi máá ró cúu. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Te ni scáne Judas xūhún un ini templo. Te ni quenda de cuahān de, te ni scuéhne de máá de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Te sutū cácujéhnu ni canastútú de xūhún un, te ni cacahān de: Ma cúu chuhun yó xúhun yáha ini yejnū nuū cásocō ñayuu, chi xūhun jéē ni jéconaā jeē cúū ɨɨn tēe cúu, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yūcuán na te ni casándaā de jeē xūhun yúcuan cuaan de ñuhun jeē naní Lugar Ñuhun Quíxin, návāha yūcuán quindūji ñayuu ñuu jicá. ");
INSERT INTO mibNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jeē yúcuan cúu jeē ndé vijna nání ñuhun ún Lugar Ñuhun Nɨñɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Te súcuan ni squícu jnūhun ni cahān Jeremías, tēe ni nacani jnūhun Yaā Dios nde jenahán: Ni caquihin de ndɨhócó uxī xūhun plata, te súcuan‑ni cúu ɨɨn yāhu jeē ní casáha ñayuu Israel cuenta jeē ndeé yā nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Te jíín xúhun un ní cajeen de ñuhun quíxin, nájnūhun ni ndacu máá Jítoho yō Yaā Dios jniñu nuū rī. Achí Jeremías. ");
INSERT INTO mibNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Te nuū ní jinūcoo de jíín Jesús nuū gobernador, tēe cúu Pilato, te ni cajnūhún de ya: ¿A máá ró cúu Rey ñayuu hebreo? achí de. Te ni cahān Jesús: Suu ri cúu, nájnūhun cáhán rō. ");
INSERT INTO mibNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Te sutū cácujéhnu jíín tée jéhnu cándacu jniñu, ni cacahān de cuēchi sɨquɨ̄ yā. Te tú na vé ni cáhán cuɨtɨ yā. ");
INSERT INTO mibNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yūcuán na te ni cahān Pilato jiín yá: ¿A tu jíni ró jéē cácahān de cuehē cuēchi sɨquɨ̄ rō? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Te tu ní cáhán cuɨtɨ yā ni ɨɨn jnūhun jíín de. Te nahán ní naa ni gobernador jeē tú na vé ni cáhán yā jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Te íyó costumbre gobernador jeē quɨvɨ̄ víco un siáá de ɨɨn tēe íne vecāa, núu na‑ni tēe cácuni ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Te suu quɨvɨ̄ un íyó ɨɨn tēe íne vecāa, nání de Barrabás, te je ni jitē núu jnūhun jeē ni sáha de cuēchi xeēn. ");
INSERT INTO mibNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Te nuū ní candutútú ñayuu, te ni cahān Pilato jiín i: ¿Ndé tée cácuni rō jeē siaá rī vijna: á Barrabás, chí Jesús jeē cúu Cristo, Yaā ní tají Yaā Dios? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Súcuan ni cahān de chi cúní de siáá de Jesús. Chi je ni jecūhun ni de jeē ní cacucuésún ni tāca sútū un cájito de ya, te jeē yúcuan ní quijicoo jíín yá nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Te níní jéē néne Pilato silla nuū sándaā de jniñu, te ñasɨhɨ́ de ni tají ña jnūhun nuū de: Ma quɨ́vɨ nduu rō jiín ñáyuu sɨquɨ̄ tée ndaā jiñā, chi yōhyo ni siūhu jéni ruhū cuni jeē sɨquɨ́ de, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Te sutū cácujéhnu jíín táca tée jéhnu, ni cascáhán de ñayuu jeē na cácán i jeē siaá de Barrabás, te na cúū Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yūcuán na te ni cajnūhún tucu gobernador: Jeē uú de, ¿ndé ɨɨn de cácuni rō jeē siaá rī? achí de. Te ni cacahān i: Siáá ni Barrabás, achí i. ");
INSERT INTO mibNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Te ni cajnūhún Pilato: Núu súcuan te ¿ndese cácuni rō jeē sáha ri jiín Jesús, tēe cúu Cristo? achí de. Te ni cacahān ndɨhɨ i: Cata caa ní de jicā cruz, na cúū de, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yūcuán na te ni cahān Pilato: ¿Na cuēchi ni sáha de núu súcuan? áchí de. Te ñayuu un ní cacana jee ndasɨ́ i: Cata caa ní de jicā cruz, na cúū de, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Te ni jini Pilato jeē tu cúndeyɨ́ de jíín ñáyuu, chi sa víhyá gā cácuvaā i. Te ni ndacu de jniñu jeē na quíji ndute, te ni nandahá de nuū ñáyuu cuehē ún. Te ni cahān de: Jeē nándahá rí yāha cúu seña jeē tú na cuēchi condee sɨquɨ̄ rī jeē cúū tēe vāha yāhá. Chi sɨquɨ̄ maá ró jijnáhan ró na cóndee. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Te ni cacahān ndɨhɨ ñayuu: Suu sɨquɨ̄ maá ná jíín sɨ́quɨ̄ séhe ná na cóndee cuēchi jeē cúū de, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yūcuán na te ni siaá de Barrabás. Te ni ndacu de jniñu jeē na cáni tācá soldado un Jesús, jiín jéē cáta caa de ya jicā cruz. ");
INSERT INTO mibNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yūcuán na te soldado un cuangoo de jíín Jesús ini palacio. Te ni cacana de ndɨhɨ jnáhan de ni candutútú núū yā. ");
INSERT INTO mibNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Te ni caquenehen de sahma ya, te ni cachuhun de ya ɨɨn sahma cuehé jeē cúu sahma rey. ");
INSERT INTO mibNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Te ni casáha de ɨɨn corona iñu, ni cachuhun de xinī yā. Te ni cachihi de ndaha váha ya ɨɨn yujnu jeē nájnūhun bastón. Te ni casácatā de nuū yā, chi ni cajecuɨñɨ̄ yɨtɨ́ de, cásáha de jeē chiñúhún de ya. Nacā jeē váha rey cúu Rey ñayuu hebreo, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Te ni catesɨ̄hɨ́ de nuū yā. Te ni caquihin de yujnu jeē ní cachihi de ndaha ya, te ni cacani de xinī yā. ");
INSERT INTO mibNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Te nuū ní cuu ni casácatā de nuū yā, te ni catava de sahma cuehé un, te ni canachuhun de ya sahma máá yá. Te cuangoo de jíín yá jeē cata caa de ya jicā cruz. ");
INSERT INTO mibNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Te nuū ní quendacoo soldado un jíín yá, te ni canajnáhan de jíín ɨɨn tēe ñuu Cirene, naní de Simón. Te ni catejníñu de tēe un jéē cóndiso de cruz yā. ");
INSERT INTO mibNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Te ni jinūcoo de ɨɨn lugar nuū naní Gólgota, jeē cuní cahān Lugar Yɨquɨ Xíní. ");
INSERT INTO mibNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Te ni cajēhe de vino jeē ni sácā núu jíín ɨɨn jeē uvuá jeē cóho ya. Te nuū ní jito ndee ya, te tu ní cúní yā coho ya. ");
INSERT INTO mibNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Te nuū ní cuu ni cacata caa de ya jicā cruz, te ni casáha de sorteo jeē sɨquɨ́ ndese nihīn ɨɨn ɨɨn de sahma ya. Te súcuan ni squícu jnūhun ni tee tēe ni nacani jnūhun Yaā Dios jenahán: Ni casáha de sorteo sɨquɨ̄ ndese nihīn ɨɨn ɨɨn de sahma ri, achi yā, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yūcuán na te ni cacucōo de yūcuan jéē cóto de nde cuu yā. ");
INSERT INTO mibNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Te ni catee de ɨɨn jnūhun xinī cruz yā jeē cahán na sɨquɨ̄ ni jíhī yā: Yāha cúu Jesús, Rey ñayuu hebreo, achí. ");
INSERT INTO mibNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Te suni ni cacata caa de uū tēe cuíhná núū uū gā cruz, ɨɨn de lado váha ya, te ɨnga de lado jecó yá. ");
INSERT INTO mibNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Te ñayuu cáyāha yūcuan cáscuícó i xinī i, te cácahān neé i: ");
INSERT INTO mibNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Róhó chi cáhán rō jeē cánu rō templo cáhnu, te nuū uní quɨvɨ̄ te nacani ró. Núu súcuan te jnama ró máá ró vijna. Te núu Sēhe Yaā Dios cúu ró, te nuu ró jícā cruz viī, achí i. ");
INSERT INTO mibNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Te sutū cácujéhnu, jíín tée cástéén tutu ley, jiín tée grupo fariseo, jiín tée jéhnu jíjnáhan de, suni súcuan ni cacahān catá de, te áchí de cácahān maá de: ");
INSERT INTO mibNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Núu ɨnga ñayuu ni jnama de, ¿te naun tu cúu jnama de máá de vijna? Núu Rey ñayuu Israel cúu de, te na núu de jicā cruz, návāha candíje yó de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ni candíje de Yaā Dios, te na jnáma ya de vijna te núu cúndáhú ni yā de, chi ni cahān de jeē cúu de Sēhe ya. Achí de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Te tēe cuíhná jeē cándita caa xiin ya, suni súcuan ni cacahān neé de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Te nuū ní cuu cahuxī uū, te ni cunee nɨɨ́ cáhnu nde cahunī. ");
INSERT INTO mibNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Te nájnūhun cahunī, te ni cana jee Jesús: Elí, Elí, ¿lama sabactani? achí yá. Te jnūhun un cúní cahān: Yaā Dios maá ná, Yaā Dios maá ná, ¿naun ni stóo ní sáña? ");
INSERT INTO mibNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Te sava ñayuu cáhīin yūcuan ní cajini i jnūhun ún, te ni cacahān i: Tēe yáha cána de xinī Elías, tēe ni nacani jnūhun Yaā Dios jenahán, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Te ni jinu‑ni ɨɨn tēe, ni jequihin de ɨɨn cachī, te ni chundaji de nuū vinagre iyá. Te ni tee de xinī ɨɨn yujnu, te ni tee de yuhu ya jeē coho ya. ");
INSERT INTO mibNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Te sava ga de ni cacahān: Condetu ró, na cóndēhe yó núu quiji Elías jnama de chí tuú, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Te Jesús ni cana jee ya ɨnga jínu, te ni jihī‑ni ya. ");
INSERT INTO mibNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Te sahma ndíta caa jeē ndihyú cuarto iī ini templo cáhnu, ni ndatā‑ni sava sava nde xinī te nde nuū jehé. Te ni jnāa, te ni catahū sáva toto. ");
INSERT INTO mibNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Te ni cananune yaū nuū yɨ́ndūji ndɨ̄yɨ. Te cuehē ndɨ̄yɨ jeē ní cacandíje i Yaā Dios, ni canatecu i. ");
INSERT INTO mibNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Te nuū ní natecu Jesús, te ni quendacoo i nuū yɨ́ndūji i. Te ni ndɨ̄vɨcoo i ini ñuu iī Jerusalén, te cuehē ñayuu ni cajito nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Te ná ni jihī Jesús, te tēe cúu capitán jiín tée cáhīin jíín de jeē cándito de nde cuu yā, ni cajini de jeē ni jnáa, jíín táca gá jniñu ní cuu. Te yōhyo ni cayūhú de, te ni cacahān de: Jendaá ndije jeē Séhe Yaā Dios cúu tēe yáha, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Te yūcuan cáhīin cuehē ñahan, cándēhe jícá ña. Te suu ñahan un ní candiquīn ña Jesús nde Galilea, vējicoo ña cájejníñu ña nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Te unī ñahan un cácuu María ñuu Magdala, jiín María naná Jacobo jiín José, jiín náná ndɨndúú séhe Zebedeo. ");
INSERT INTO mibNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Te nuū ní ini quɨvɨ̄ ún, te ni quee ɨɨn tēe cúcá, nání de José, te tēe ñuu Arimatea cúu de. Te suni tēe ni scuáha jíín Jesús cúu de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tēe un ní jehēn de nuū Pilato, te ni jicān de yɨquɨ cúñu Jesús. Te ni ndacu Pilato jniñu jeē na cuáha nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Te José ni quihin de yɨquɨ cúñu yā, te ni chusúcún de ɨɨn sahma cuitá íyó ndoo. ");
INSERT INTO mibNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Te névāha de ɨɨn yaū jeē ní caan jeé jícā ɨɨn cava, nuū ná tu quindūji ndɨ̄yɨ. Te yūcuan ní chindūji de ya. Te ni jesɨ de ɨɨn yuū cáhnu yuhu yáú un, te cuahān de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Te María ñuu Magdala, jiín ɨnga María, cáyūcú ña ichi núú nuū yɨ́ndūji ya. ");
INSERT INTO mibNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Te ni cuu tācá jniñu yáha máá quɨ́vɨ̄ jeē casátūhva ñayuu jeē quiji quɨvɨ̄ ndétātú. Yūcuán na te ni cundijin maá quɨ́vɨ̄ ndétātú. Te sutū cácujéhnu jíín tée grupo fariseo ni jengoo de nuū Pilato. ");
INSERT INTO mibNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Te ni cacahān de: Cánucūhun ni na jéē nde na técu tēe stáhú néé un te ni cahān de jeē nátecu de nuū uní quɨvɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Núu súcuan te ndacu ní jniñu na cóto vāha tācá soldado yuhu yáú un nde núu ni yāha unī quɨvɨ̄. Chi núu tuú te sanaa te quijicoo tēe ni cascuáha jíín de, te tava cuīhná de ndɨ̄yɨ ún jecuáā, quingoo de jíín. Yūcuán na te cachi de nuū ñáyuu jeē ní natecu tēe ún. Te cáhú gá cuu jnūhun stáhú yúcuan vēsú jeē xíhna ñúhún. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Te ni cahān Pilato: Yāha cáhīyo soldado. Cuángoo jíín de, te sácutú váha ró yuhu yáú un, te coto vāha ró, núu ndese vāha ga cuu sáha ró. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Te cuangoo de, te ni casácutú de yuū jeē ndihyú yuhu yáú nuū yɨ́ndūji ya, te ni castɨ́ɨn nīhin de. Te ni castóo de tācá soldado un cándito. ");
INSERT INTO mibNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Te ni yāha quɨvɨ̄ ndétātú un, te ni cundijin quɨvɨ̄ domingo. Te María ñuu Magdala jiín ɨnga María un, ní jecondēhé ña nuū ní yɨndūji Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yūcuán na te ɨɨn sanaa‑ni te ni jnāa nīhin ndasɨ́. Chi ɨɨn ndajéhé maá Jítoho yō Yaā Dios ni cuun ya ichi ándɨvɨ́, ni quee ya nuū ní yɨndūji Jesús. Te ni stáa ya yuū ndihyú yuhu yáú un, te ni cucōo ya sɨquɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Te ndíndēe núū yā nájnūhun taja, te sahma ñúhun ya yaa quɨyɨ nájnūhun yuhvā volcán. ");
INSERT INTO mibNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Te soldado cándito yūcuan ní quɨsɨ i de jeē cáyūhú de cájito de ya. Te ni cacuu ndɨ̄yɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Te ni cahān ndajéhé jiín ndɨndúú ñahan ún: Ma yūhu ró, chi jíní rī jeē vécondēhe ró Jesús, Yaā ni jíhī jicā cruz. ");
INSERT INTO mibNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tuá yā yāhá, chi je ni natecu yā, nájnūhun ni cahān yā. Nehen condēhe ró nuū ní cachindūji de ya. ");
INSERT INTO mibNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Te yachī quingoo ró, te cachi rō nuū tée cáscuáha jíín yá jeē ní natecu yā. Te xīhna gā maá yá jinū Galilea, te sáá te najinūcoo de. Te yūcuán coto de nuū yā. Achi rō na cúni de. Je ni castūhun rí nuū rō, achí ndajéhé. ");
INSERT INTO mibNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Te ni quendacoo ña nuū ní yɨndūji ya, te yachī cuangoo ña. Te cáyūhú ña, te suni yōhyo cácusɨɨ̄ ni ña. Te ni cajinu ña cuacastūhún ña nuū tée cáscuáha jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Te níní cuángoo ña, te ni quee‑ni Jesús nuū ña, te ni cahān yā jiín ña. Te ni quecoo ña nde nuū yā, te ni canundee ña jehē yā, te ni cachiñúhún ña ya. ");
INSERT INTO mibNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Te ni cahān yā jiín ña: Ma yūhu ró jijnáhan ró. Cuángoo te castūhun ró nuū tācá hermano rī, tēe ni cascuáha jíín rí, jeē na núngoo de nde Galilea, te yūcuán coto de nuū rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Te níní cuángoo ña, te sava soldado jeē ní condito ún, cuánungoo de nde ñuu. Te ni cacastūhún de nuū sutú cácujéhnu tācá jniñu jeē ní cuu. ");
INSERT INTO mibNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Te sutū cácujéhnu ni candutútú de nuū táca tée jéhnu cándacu jniñu, te ni casquíjnáhan de jnūhun. Yūcuán na te ni cajēhe de cuehē xūhun núū soldado jijnáhan. ");
INSERT INTO mibNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Te ni cacahān de jíín: Cahān rō jijnáhan ró jéē tée cáscuáha jíín de ni quijicoo jecuáā, te ni catava cuīhna ndɨ́yɨ un níní cáquixī rō, achi rō. ");
INSERT INTO mibNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Te núu na cúni gobernador jnūhun yáha, te máá rí quiscahán rī de, návāha tú nihīn rō castigo jijnáhan ró. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Te soldado un ní caquihin de xūhún un, te ni cacachi de nájnūhun ni cacahān jiín de. Te nde vijna chi súcuan cácahān ñayuu hebreo nájnūhun ni cacahān soldado un. ");
INSERT INTO mibNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Te ndɨhúxí ɨɨn tēe ni cascuáha un cuánungoo de nde Galilea, nde yucu nuū ní cachi Jesús jeē quíngoo de. ");
INSERT INTO mibNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Te nuū ní cajito de nuū yā, te ni cachiñúhún de ya. Te sava de tu cácandíje vāha de jeē maá yá cúu. ");
INSERT INTO mibNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Te ni quee ya nde nuū de, ni cahān yā jiín de: Je ni jēhe Tátá rī ndɨhɨ poder nuū rī jeē ndácu ri jniñu andɨvɨ́ jíín ñáyɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Núu súcuan te cuángoo nuū ñáyuu tācá nación, te stéén rō jnūhun ri nuū i návāha na cándíje i. Te scuándute ró i jeē ní cacandíje i máá Tátá jiín Séhe jíín Espíritu Santo. ");
INSERT INTO mibNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Te stéén rō nuū i jeē na cuátáhú i tācá jniñu ní ndacu ri nuū rō. Te cocuhun ni rō jeē maá rí íne ri jiín ró nɨɨ́ cáni nde quɨvɨ̄ jínu ñayɨ̄vɨ́. Achí yá. Te ni cuu. Amén.");
INSERT INTO mibNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yāha quéjéé jnúhun vāha máá Jesucristo Sēhe Yaā Dios, jeē ní quiji ya jeē jnama ya yohó. ");
INSERT INTO mibNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaías, tēe ni nacani jnūhun Yaā Dios nde jenahán, súcuan ni tee de jnūhun Juan nuū tútu: Tají rí tēe nacani jnūhun ri cosnūú de ichi núú rō, návāha coo tūhva ñayuu jeē jinú rō, achí Yaā Dios jiín Cristo. ");
INSERT INTO mibNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Te tēe ún cana jee de nde nuū ñúhun téhé: Sátūhva ró máá ró jijnáhan ró, chi quee maá Jítoho yō. Te sáha ró jniñu ndaā, chi vēji ya, achi de. Achí Isaías. ");
INSERT INTO mibNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Te Juan ni jinū de nde nuū ñúhun téhé, scuándute de ñayuu. Te cáhán de jíín i jeē na nácani ni i jeē stóo i cuēchi i te cuandute i, návāha cone cáhnu ni Yaā Dios nuū cuéchi i. ");
INSERT INTO mibNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Te tāca ñáyuu región Judea jiín ñáyuu ñuu Jerusalén, ni quijicoo i nuū de. Te ni canacani ndaā i cuēchi i nuū Yaā Dios, te ni scuándute de i ini yūte Jordán. ");
INSERT INTO mibNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Te sahma ñúhun Juan cúu ixi camello, te núhní ɨɨn cinturón ñɨɨ chīji de. Te jeē técu de cúu tɨ́ca ndɨcuéhyɨ́ jíín ndúxi yocō. ");
INSERT INTO mibNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Te suhva ni nacani de jnūhun: Quiji máá Yaā cujéhnu ndasɨ́. Chi tú na vé jéhnu cuɨtɨ cúu ri nuū yā, ni jeē cuajníñu ri nuū yā vēsú ɨɨn jniñu lúlí gá nájnūhun jeē cuíta ndeyɨ ri ndají rí correa ndijēn yā. ");
INSERT INTO mibNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Te ruhū chi jíín ndute scuándute ri rohó jíjnáhan ró, te Yaā ún chi nájnūhun jeē scuándute ya rohó cúu jeē cuáha ya Espíritu Santo condee ini anuá rō, achí Juan. ");
INSERT INTO mibNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Te ni cuu jecu quɨvɨ̄, te Jesús ni quenda ya ñuu Nazaret ndañúū Galilea, te Juan ni scuándute de ya ini yūte Jordán. ");
INSERT INTO mibNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te ná ni quenda ya nuū ndúte, te ni jito ya jeē ní nune‑ni andɨvɨ́, te ni cuun Espíritu Santo ni quee xinī yā, te cáa nájnūhun ɨɨn paloma. ");
INSERT INTO mibNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Te ichi ándɨvɨ́ ní cahān ɨɨn jnūhun: Máá ró cúu Sēhe ri jeē maní ndasɨ́ rí jiín, te yōhyo cúsɨɨ̄ ni rī jiín ró, achí. ");
INSERT INTO mibNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yūcuán na te ni jinū Jesús nde nuū ñúhun téhé ní sáha Espíritu Santo. ");
INSERT INTO mibNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Te uū xico quɨvɨ̄ ni condee yā nuū ñúhun téhé un núū íin quɨtɨ yúcú. Te ni jito ndee Satanás yā, chi cúní jeē sáha ya cuēchi. Te nuū ní cujiyo Satanás cuahān, te ni quecoo ndajéhé Yaā Dios, ni cajejníñu nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yūcuán na te ná ni cachune de Juan vecāa, te ni jinū Jesús región Galilea, nácani ya jnūhun vāha ndese ndácu Yaā Dios jniñu. ");
INSERT INTO mibNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Te ni cahān yā: Je ni jinū quɨvɨ̄, te je ni cuyajni jeē ndácu Yaā Dios jniñu nuū rō. Nacani ni rō jeē stóo ró cuéchi ró jíjnáhan ró, te candíje ró jnúhun jeē jnáma ya rohó. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Te jíca Jesús yumar Galilea cuahān yā. Te ni jito ya nuū Simón jiín ñani de Andrés. Te tēe cájnɨɨ chācá cácuu de, te cásɨ́nga de ñunu de ini mar. ");
INSERT INTO mibNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Te ni cahān yā jiín de: Condiquīn ruhū na quíhín yō, te nasáha ri rohó tée nihīn cuehē ñayuu candíje ruhū, nájnūhun cánihīn rō chācá, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yūcuán na te ni castóo‑ni de ñunu de, te ni candiquīn de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Te ni jica ya jecu gā, te ni jito ya nuū Jacobo jiín ñani de Juan, sēhe Zebedeo, suni cáyūcú de ini barco de, cánachijnɨ̄ɨ de ñunu de. ");
INSERT INTO mibNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Te suni ni cana ya de jeē cóndiquīn de ya. Te ni castóo‑ni de tátá de Zebedeo ini barco un jíín mozo de, te ni candiquīn de ya cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Te ni jinū yā jiín de ñuu Capernaum. Te quɨvɨ̄ ndétātu ní quɨ̄vɨ ya ini vehe iī sinagoga, te ni steén yā jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Te ni canaa ni ñayuu ni cajini i jnūhun stéén yā. Chi ni steén vāha ya nuū i, chi máá yá cúu jeē ndíso jníñu sɨquɨ̄ ndɨhɨ. Te tēe cástéén tutu ley Yaā Dios, tu súcuan cástéén de. ");
INSERT INTO mibNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Te ini vehe iī sinagoga ñuu un íne ɨɨn tēe jeē ñúhun tachī ini. Te ni cana cóhó de: ");
INSERT INTO mibNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","¿Naun vēji ní núū na jíjnáhan ná, Jesús ñuu Nazaret? ¿A véji ní jéē snáā ni sáña, chí naún? Je jíní na ndé ɨɨn cúu ní, chi Sēhe iī Yaā Dios cúu ní. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Te Jesús ni cahān xeēn yā jiín táchī ún: Casɨ yuhu ró te quenda ró ini de, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Te tachī ún xeēn ni jehni yɨ̄hɨ́ tée ún. Te ni cana cóhó, te ni quenda ini de cuahān. ");
INSERT INTO mibNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Te ndɨhɨ ñayuu ni cayūhú i, te cácajnūhun jnáhan i: ¿Na vé cúu jeē yáha? ¿A ɨɨn jnūhun jéé cúu jeē yáha? Chi tēe yáha cújéhnu de jeē ndácu de jniñu nde nuū tachī te quéndacoo, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Te yachī ni jitē núu jnūhun Jesús cuahān nɨɨ́ cáhnu región Galilea. ");
INSERT INTO mibNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Te ni quenda ya jiín de jíjnáhan de ini vehe iī sinagoga. Te Jesús ni jehēn yā jiín Jacobo jiín Juan nde vehe Simón jiín Andrés. ");
INSERT INTO mibNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Te náná chīsó Simón, cátú ña yɨ́hɨ quīji ña. Te ni cacastūhún de nuū yā jeē cuhú ña. ");
INSERT INTO mibNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yūcuán na te ni quindehe ya nuū catú ña, te ni jnɨɨ ya ndaha ña, te ni ndonehen ya ña. Te ni quenda‑ni quīji ún ña, te ni sáha ña jeē ní cayeji de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Te ni quēe niāndii te ni cuaa. Te ni quecoo ñayuu jiín táca ñáyuu cácuhū jiín jéē ñúhun tachī ini. ");
INSERT INTO mibNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Te tāca ñáyuu ñuu un ní cacutútú i yéhyɨ́ un. ");
INSERT INTO mibNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Te ni nasávāha ya cuehē ñayuu cácuhū tɨjnɨ nuū cuehyɨ́, te ni quenehen ya cuehē tachī un cuángoo. Te tachī chi je cájini un yá, te tu ní jéhe ya jnūhun jeē cástūhun ndé ɨɨn cúu ya. ");
INSERT INTO mibNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Te nehen ndasɨ́ ní ndonda ya, nde yɨ́nee gā. Te ni quenda ya cuahān sɨ́ɨn ya yatā ñúū nuū tú ñayuu, te yūcuan ní jicān tahú yā. ");
INSERT INTO mibNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Te Simón jiín tée cáhīin jíín de, ni jenanducú de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Te ni cananihīn de ya, te ni cacahān de jíín yá: Tāca ñáyuu cánanducú i níhín, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Te máá yá ni cahān yā: Sa suhva na quíhín yō tāca gá ñuu íne yajni, návāha suni nacani ri jnūhun nuū i, chi jeē yúcuan ní quee rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Te súcuan te ni jica cuu ya nɨɨ́ región Galilea, ni nacani ya jnūhun ini vehe iī sinagoga tācá ñuu, te ni quenehen ya tachī ini ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Te ɨɨn tēe ndóho cuehyɨ̄ stehyú, ni quee de ni jecuɨñɨ̄ yɨtɨ́ de nuū yā, te ni cahān de jíín yá: Jíní na jeē cuu sáha ní jéē nduvāha ná, te núu cúní ni, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Te Jesús ni cundáhú ni yā de, te ni soó yá ndaha ya sɨquɨ̄ de, te ni cahān yā: Cúní rī. Te na ndúvāha ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Te ná ni cahān yā súcuan, te ni nduvāha‑ni tēe ndóho cuehyɨ̄ stehyú un. ");
INSERT INTO mibNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yūcuán na te nátají yá de quinuhun de, te ni cahān nīhin ya jiín de: ");
INSERT INTO mibNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ma cáchi cuɨtɨ rō nuū ní ɨɨn. Chi quisteén rō maá ró nuū sutú, te condahá ró jeē socó rō nuū Yaā Dios sɨquɨ̄ jeē ndúndoo ró núū yā, nájnūhun ni ndacu Moisés jniñu jenahán. Te súcuan te cuni ñayuu jeē ní nduvāha ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Te ni quenda de cuahān de, te ni quejéé de nácani de jnūhun nuū ndɨhɨ ñayuu ndese ni nduvāha de. Te sɨquɨ̄ yúcuan tuá ni cúu quɨ̄vɨ Jesús tācá ñuu, chi cúchitú ndasɨ́ ñáyuu nuū yā. Te ni jica ya yatā tācá ñuu nuū tu cúchitú ñáyuu. Te tāca lado ni quijicoo ñayuu nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Te ni cuu jecu quɨvɨ̄, te ni quɨ̄vɨ tucu Jesús ñuu Capernaum. Te ni cajini ñayuu jeē néne ya vehe. ");
INSERT INTO mibNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Te ni cacutútú‑ni cuehē ñayuu, te ni chitú vehe jeē ndé yehyɨ́ tuá núne. Te ni nacani ya jnūhun Yaā Dios nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yūcuán na te ni quecoo cuūn tēe nuū yā, cándiso de ɨɨn tēe ndóho cuehyɨ̄ ni íjin. ");
INSERT INTO mibNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Te tu ní cúu quɨ̄vɨcoo de nuū yā sɨquɨ̄ jeē chitú ñáyuu. Te ni cacoo de sɨquɨ̄ véhe, te ni canune de ndaā nuū íin ya, te yaū un ní cascúun de tēe cúhú, cátú de nuū ɨɨn camilla. ");
INSERT INTO mibNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Te ni jini Jesús jeē cácandíje de jeē cúu nasávāha ya tēe cúhú un. Te ni cahān yā jiín tée cúhú un: Séhē, je íne cáhnu ni rī nuū tāca cuéchi ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Te yūcuan cáyūcú jecu tēe cástéén tutu ley Yaā Dios, te tēe un ní cajeni ni de sɨquɨ̄ yā: ");
INSERT INTO mibNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Naun cáhán tēe yáha súcuan? Cáhán de jnūhun ndevāha jeē quɨtɨ́ ni Yaā Dios, chi nasūu Yáā Dios cúu de jeē cóne cáhnu ni de nuū cuéchi. ");
INSERT INTO mibNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Te ni jini Jesús jeē súcuan cájeni ni de, te ni cahān yā jiín de: ¿Naun cájeni ni rō jeē cahán ndevāha ri? ");
INSERT INTO mibNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Jeē uú jnūhun yáha, ¿ndé ɨɨn yɨɨ́ gá cáa? ¿A jéē cahán rī jiín tée cúhú: Je íne cáhnu ni rī nuū tāca cuéchi ró? ¿Chí yɨɨ́ gá jeē cahān rī: Ndocuɨñɨ̄ te naquihin ró camilla rō, te caca ró, achi rī? ");
INSERT INTO mibNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Te vijna te na stéén rī jeē maá rí, Yaā ní nduu tēe, ndíso jníñu ri ini ñayɨ̄vɨ yáha jéē cóne cáhnu ni rī nuū cuéchi. Yūcuán na te ni cahān yā jiín tée ni íjin ún: ");
INSERT INTO mibNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Cáhán rī jiín ró, ndocuɨñɨ̄ te naquihin ró camilla rō, te quinuhun rō vehe ró, áchí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yūcuán na te ni ndocuɨñɨ̄‑ni tēe ún, te ni naquihin de camilla de, te ni quenda de cuahān de, jíto jínúū ndɨhɨ ñayuu. Te ndɨvii i ni canaa ni i cájito i, te ni cacahān i jeē yóhyo vāha Yaā cúu Yaā Dios. Te áchí i: Ná tu coto cuɨtɨ yō ni ɨɨn jniñu súcuan, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Te ni quenda tucu ya cuahān yā nde yumar. Te tāca ñáyuu ni jinūcoo i nuū yā, te ni steén yā jnūhun nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yūcuán na te ni yāha ya cuahān yā, te ni jito ya nuū Leví sēhe Alfeo, néne de nuū cutútú xúhun renta. Te ni cahān yā jiín de: Condiquīn ruhū na quíhín yō. Te ni ndocuɨñɨ̄ de, te cuahān de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yūcuán na te ni jehēn yā ni yeji yā staā vehe de. Te cuehē tēe cástútú xúhun renta jiín ɨnga tēe cásáha cuēchi, suni cáyūcú de cáyeji de staā jiín Jesús jiín tée cáscuáha jíín yá, chi íyó cuéhē de jeē cándiquīn de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Te tēe cástéén tutu ley Yaā Dios jiín tée grupo fariseo, ni cajito de jeē yéji yā staā jiín ndɨhɨ tāca tée ún. Te ni cacahān de jíín tée cáscuáha jíín yá: ¿Naun yéji maestro rō jiín tée cástútú xúhun renta jiín ɨnga tēe cásáha cuēchi? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Te ni jini Jesús, te ni cahān yā jiín de: Ñayuu cáhīyo váha, tu jíni ñúhún i tēe tájná, chi ñayuu cácuhū cúu jeē jíni ñúhún. Te ruhū nasūu jéē véji ri cana ri ñayuu tú cuēchi, jeē cúu i nájnūhun ñayuu cáhīyo vāha. Chi sa suhva vēji ri cana ri ñayuu cáhīyo cuéchi, jeē na nácani ni i te stóo i cuēchi i. Áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Te ni cuu ɨɨn quɨvɨ̄ jeē cáhīyo ndite ni tēe cáscuáha jíín Juan, jiín tée cáscuáha jíín grupo fariseo. Te ni quecoo jecu tēe, ni cacahān de jíín Jesús: Tēe cáscuáha jíín Juan jiín jéē cascuáha jíín grupo fariseo, tɨjnɨ jínu cáhīyo ndite ni de. Te tēe cáscuáha jíín máá ní, ¿naun tu cásáha de súcuan? ");
INSERT INTO mibNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Te ni cahān Jesús jiín de: ¿A cuu condite ni de níní jéē iyó rí jiín de? ¿A cuu condite ni ñayuu cáhīin vico nándāha, te núu níní néne tēe nándāha? Chi núu néne tēe nándāha, te ma cúu condite ni i. ");
INSERT INTO mibNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Te quee quɨvɨ̄ jeē cújiyo tēe nándāha, te quɨvɨ̄ ún chi condite ni i. ");
INSERT INTO mibNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Te ni cahān yā uū jnūhun yátá sɨ́quɨ̄ jeē tu quíjnáhan jnūhun jeé jéē steén yā jiín táca jnúhun jenahán. Achí yá: Ni ɨɨn tu náchuhun ɨɨn pedazo sahma jéé núū ɨɨn sahma túhú. Chi núu súcuan te ndɨyɨ pedazo jeé un, te tahndē gā jeē tuhú un, te nducáhnu ga nuū cátáhndé un. ");
INSERT INTO mibNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Te suni tu cáchuhun vino jeé ini ñɨɨ túhú. Chi núu súcuan te vino jeé un ndatá ñɨɨ ún, te naa vino jiín ñɨɨ. Jeē yúcuan cánuú jéē chúhun i vino jeé ini ñɨɨ jéé. ");
INSERT INTO mibNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Te ɨɨn quɨvɨ̄ ndétātu ní yāha Jesús cuahān yā mēhñú nuū cáa trigo. Te tēe cáscuáha jíín yá, cájica de cuahān de, te ni quejéé de cátaxín de yoco trigo cáyeji de. ");
INSERT INTO mibNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yūcuán na te tēe grupo fariseo ni cacahān de jíín yá: Condēhé. ¿Najehē casáha tēe cáscuáha jíín ró súcuan? Chi áchí ley Moisés jeē ma cúu sáha yó ni ɨɨn jniñu quɨvɨ̄ ndétātú. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Te ni cahān maá yá jiín de: ¿A tu ní cácahu cuɨtɨ rō tutu ndese ni sáha David, ɨɨn quɨvɨ̄ ní cumanī jeē cáji de, te ni jiī de sōco jíín tée cáhīin jíín de? ");
INSERT INTO mibNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Te ni quɨ̄vɨ de ini vehe Yaā Dios. Te Abiatar ni cuu sutū cujéhnu ga. Te ni yeji de pan iī jeē yosó ndijin nuū Yaā Dios. Te tú na ley jeē cáji ni ɨɨn tēe, chi máá‑ni sutū cuu caji. Te suni ni jēhe de ni cayeji tēe cáhīin jíín de. Te tú na cuēchi ní íyo sɨquɨ̄ de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Te suni ni cahān yā jiín de jíjnáhan de: Tu ní jéconaā ñayuu jeē ndóho i nuū quɨvɨ̄ ndétātú, chi ni jeconaā quɨvɨ̄ un jéē ndétātú i. ");
INSERT INTO mibNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Núu súcuan te ruhū, Yaā ní nduu tēe, máá rí cúu jeē ndácu jniñu sɨquɨ̄ ndese sáha ñayuu quɨvɨ̄ ndétātú, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Te ni quɨ̄vɨ tucu Jesús ini vehe iī sinagoga. Te yūcuan íne ɨɨn tēe ni ichī ɨɨn ndaha de. ");
INSERT INTO mibNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Te tēe grupo fariseo cájito yuhu de ya núu nasávāha ya tēe un quɨ́vɨ̄ ndétātú, návāha nihīn de cuēchi sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yūcuán na te ni cahān yā jiín tée ni ichī ndaha ún: Ndocuɨñɨ̄ te condichi rō mēhñu yáha, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Te ni cajnūhun yá de jíjnáhan de: ¿Ndese cáhán ley sɨquɨ̄ quɨvɨ̄ ndétātú? ¿A jéē sáha vāha yó, chí sáha néé yó? ¿A jéē nasávāha yó ñáyuu je yajni cuu, chí sáha yó jéē cúū i? áchí yá. Te máá de tú na vé ni cacahān de. ");
INSERT INTO mibNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Te ni quɨtɨ̄ ni yā ni jito ya nuū de jíjnáhan de, te ni cucuíhyá ni yā jeē níhni ni de. Te ni cahān yā jiín tée ni ichī ndaha: Scáá ndaha ró. Te ni scaá de, te ni nduvāha‑ni ndaha de. ");
INSERT INTO mibNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yūcuán na te ni quendacoo tēe grupo fariseo, te ni casquíjnáhan de jnūhun jíín tée grupo Herodes sɨquɨ̄ yā, ndese cahni de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Te Jesús cuahān yā nde yumar jiín tée cáscuáha jíín yá. Te cuehē ñayuu región Galilea ni candiquīn i ya. ");
INSERT INTO mibNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Te suni ñayuu región Judea, jiín ñáyuu ñuu Jerusalén, jiín ñáyuu Idumea, jiín ñáyuu ichi núū cáne niāndii yūte Jordán, jiín ñáyuu región Tiro jiín Sidón, cuehē ndasɨ́ ñáyuu ni cajini jnūhun i jniñu jéhnu ni sáha ya, te ni quecoo i nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Te ni cahān yā jiín tée cáscuáha jíín yá jeē na cóo tūhva ɨɨn barco quɨ̄vɨ ya, návāha ma chitú níhin ñayuu cuehē ún xiin ya. ");
INSERT INTO mibNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Chi cuehē ñayuu je ni nasávāha ya, te jeē yúcuan vējicoo cuehē gā ñayuu cándoho tāca núū cuehyɨ̄, te chítú níhin i xiin ya jeē quehé i ya cácuni i. ");
INSERT INTO mibNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Te ñayuu cáñuhun tachī ini, núu ni cajito nuū yā, te cájecuɨñɨ̄ yɨtɨ́ núū yā, te cácana cóhó: Máá ní cúu Sēhe Yaā Dios, achí. ");
INSERT INTO mibNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Te ni ndacu nīhin ya nuū tachí un jéē ma cáhán gā jeē cúu ya Sēhe Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yūcuán na te ni caa ya cuahān yā ɨɨn yucu. Te ni cana ya tāca tée jeē cuní maá yá caca jíín yá, te ni quecoo de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Te ni jeni ya uxī uū de jeē cuɨ́ñɨ de jíín yá, te tají yá de quingoo de nacani de jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Te ni sáha ya jeē cóndiso jníñu de nasávāha de ñayuu cuhú te quenehen de tachī ini ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Te yāha cúu ndɨhúxí uū tēe jeē ní nacāji ya: Simón jeē ní nasnání yá de Pedro. ");
INSERT INTO mibNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Te Jacobo jiín ñani de Juan, sēhe Zebedeo. Te ni nasnání yá ndɨndúú de Boanerges, jeē cuní cahān: Tēe yɨ́hɨ fuerza nacani jnūhun, nájnūhun yɨ́hɨ fuerza taja. ");
INSERT INTO mibNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Te sava ga de nání de Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo sēhe Alfeo, Tadeo, Simón tēe grupo cananista, ");
INSERT INTO mibNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","jíín Judas Iscariote, tēe jeē ní nastúu de ya. Yūcuán na te ni quɨ̄vɨ ya ɨɨn vehe jíín tée cáscuáha jíín yá un. ");
INSERT INTO mibNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Te ni ndutútú tucu cuehē ñayuu, te ni tuá ni cúu caji yā staā jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Te tāca jnáhan vehe ya ni cajini jnūhun jeē súcuan cúu. Te ni quecoo de venūquīhin de ya. Chi cácahān de jeē ní sana xinī yā. ");
INSERT INTO mibNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Te suni tēe cástéén tutu ley Yaā Dios jeē ní quijicoo nde ñuu Jerusalén, ni cacahān de: Tēe yáha ñúhun Satanás ini de, jeē cujéhnu nuū tachí. Te jíín fuerza un quénehen de tachī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Te ni cana ya de jíjnáhan de, te ni cahān yā ɨɨn jnūhun yátá jíín de: ¿Ndese cuu quenehen Satanás maá? ");
INSERT INTO mibNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chi núu ɨɨn nación sásɨ́ɨn máá te cuajnáhan máá, nación un má cúu ga coyūcu cáhnu. ");
INSERT INTO mibNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te núu ñayuu ɨɨn vehe sásɨ́ɨn máá te cuajnáhan máá, ñayuu un má cúu ga coyūcu cáhnu. ");
INSERT INTO mibNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Te suni súcuan Satanás jiín jnáhan tachī, chi núu sásɨ́ɨn máá te cuajnáhan máá, núu súcuan te ma cóo ga, chi sa suhva naa. ");
INSERT INTO mibNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Te ni ɨɨn tēe ma cúu quɨ̄vɨ de ini vehe tēe ndacuī jeē quenehen de ndajníñu de. Chi cánuú jeē xíhna gā cuhni de tēe ndacuī ún. Te suni súcuan cúu jeē jíhni rī Satanás te quénehen ri tachī. ");
INSERT INTO mibNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Te jendaá cahán rī jiín ró jeē iyó modo coo jnūhun cáhnu ni nuū tāca cuéchi cásáha ñayuu, te suni nuū tāca jnúhun néé cácahān i. ");
INSERT INTO mibNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Te núu cahān ndevāha i sɨquɨ̄ Espíritu Santo, te ma cóne cáhnu ni Yaā Dios nuū i, chi sa suhva condee cuēchi sɨquɨ̄ i nɨ́ɨ́ cáni, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Súcuan ni cahān yā, chi ni cacahān i jeē quénehen ya tachī jiín fuerza Satanás. ");
INSERT INTO mibNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yūcuán na te ni quee naná yā jiín táca ñani yā. Te íin ña nuū quéhe, te ni tají ña jnūhun cuahān nuū yā jeē cána ña ya. ");
INSERT INTO mibNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Te ñayuu cáyūcu nɨ́ɨ́ xiin ya, ni cacahān i jíín yá: Náná ni jíín táca ñani ni cáhīin nuū quéhe, te cácuni cahān jiín ní, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Te ni cahān maá yá: ¿Ndé ɨɨn cúu náná rī jiín ñani rī? achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yūcuán na te ni ndacoto ya nuū ñáyuu cáyūcú xiin ya ún, te ni cahān yā: Suni náná rī jiín ñani rī cácuu tāca ñáyuu yáha. ");
INSERT INTO mibNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chi tāca ñáyuu casquícu jniñu cúní Yaā Dios, suu cácuu ñani rī, cuāha ri, náná rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Te yumar ni quejéé tucu Jesús steén yā jnūhun. Te ni cutútú cuéhē ndasɨ́ ñáyuu nuū yā, te jeē yúcuan ní quɨ̄vɨ ya ni cucōo ya ini ɨɨn barco nuū mar. Te tāca ñáyuu un cáyūcú i yumar. ");
INSERT INTO mibNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Te jíín jnúhun yátá ni steén yā cuehē jnūhun nuū i, te súcuan ni cahān yā: ");
INSERT INTO mibNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Cuni nahín jíjnáhan ró: ɨɨn tēe cate trigo, ni quenda de jeē cáte de. ");
INSERT INTO mibNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Te ná ni quejéé de jéte de, te jecu trigo ni jitē yuhíchi. Te ni quecoo saa, ni cayeji tɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Te jecu gā trigo ni jitē nuū ñúhun yuū, nuū tú cuehē ñuhun. Te yachī‑ni ni cane, chi tu cóquin ñuhun. ");
INSERT INTO mibNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Te nuū ní cane niāndii, te ni ichī‑ni, te ni casun, chi tu ní níhín nuū quihín yoho. ");
INSERT INTO mibNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Te jecu gā trigo ni jitē nuū náne iñu. Te ni jehnu iñu ún, te ni jesɨ nuū, te tu ní jéhe nunī. ");
INSERT INTO mibNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Te jecu ni jitē nuū ñúhun váha. Te ni cane, te ni jehnu, te ni jēhe cuehē nunī. Sava ni jēhe ocō uxī jeē ɨ́ɨn ɨɨn nunī, te sava ga ni jēhe unī xico, te sava ga ni jēhe ciento. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yūcuán na te ni cahān yā jiín de: Tāca róhó jéē jíni sōho, na chúsóhó ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yūcuán na te ni quendōo máá na yā, jiín ndɨhúxí uū tēe cáscuáha jíín yá, jiín jecu gā ñayuu cáhīin jíín de. Te ni cacajnūhún de ya na vé cuní cahān jnūhun yátá un. ");
INSERT INTO mibNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Te ni cahān yā jiín de: Róhó, chi sáha Yaā Dios jeē cájecūhun ni rō jnūhun ni yɨsāhi yáha, ndese quɨ́vɨcoo ñayuu ndaha ya ndacu ya jniñu nuū i. Te ñayuu jeē cáhīin sɨ́ɨn sɨquɨ̄, chi máni jíín jnúhun yátá cáhán rī tāca jnúhun jíín i. ");
INSERT INTO mibNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Súcuan cáhán rī návāha vēsú cájito i, te quendōo i nájnūhun jeē tú na vé ni cájito i. Te vēsú cájini sōho i, te ma jécūhun ni i, te ma násāma ini i quɨ̄vɨcoo i nuū rī, te ma cóo jnūhun cáhnu ni nuū cuéchi i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Te ni cahān gā yā jiín de jíjnáhan de: Núu tu cájecūhun ni rō jnūhun yátá yáha, ¿te ndese jecūhun ni rō tāca gá jnūhun yátá núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tēe jéte trigo cúu tēe scuíté núu jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Te trigo jeē ni jítē yuhíchi cúu nájnūhun ánuá sava ñayuu. Chi cájini nahín i jnūhun ya, te ná ni cajini i, te quíji‑ni Satanás te quénde‑ni jnūhun ini anuá i. ");
INSERT INTO mibNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Te trigo jeē ni jítē nuū ñúhun yuū, chi cúu nájnūhun ánuá sava ñayuu cájini nahín jnúhun, te yachī‑ni cájetáhú i te cácusɨɨ̄ ni i jíín. ");
INSERT INTO mibNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Te tu cúcutú jnúhun ún ini anuá i, te jecu‑ni quɨvɨ̄ cájetáhú i. Te núu ni quejéé jnúndóho, chí jíto xeēn ñayuu i sɨquɨ̄ jnúhun ún, te quéjéé nácani yátá ni i. ");
INSERT INTO mibNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Te jeē ni jítē nuū náne iñu cúu nájnūhun jecu gā ñayuu. Chi vēsú ni cajini sōho i, ");
INSERT INTO mibNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","te cándɨhvɨ̄ ni i sɨquɨ̄ jeē iyó ini ñayɨ̄vɨ yáha. Te cácuni i cucúcá i, te stáhú un i jeē cutóó ni i sɨquɨ̄ tācá ndajníñu. Te ndɨhɨ jeē yáha cácujnéñu i jíín, te jésɨ nuū jnúhun ya, te tu íje i jíín jnúhun ya. ");
INSERT INTO mibNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Te trigo jeē ni jítē nuū ñúhun váha cúu nájnūhun ñayuu cájini nahín jnúhun, te cájetáhú i, te cáhije i jíín jnúhun ya. Te sava i cúu nájnūhun nunī jeē jéhe ocō uxī jeē ɨ́ɨn ɨɨn, te sava i jéhe unī xico, te sava ga i jéhe ciento. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Suni ni cahān yā jiín de: Núu nástɨ́ɨn ñayuu ɨɨn lámpara, ¿a chúne i chīji ɨɨn cajón chí chíji jīto? Tuú, chi jéni i nuū sucún návāha cundijin. ");
INSERT INTO mibNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Te suni súcuan, tu íyó ni ɨɨn jnūhun sāhi jéē ma cúni ñayuu, chi ndɨhɨ tāca jnúhun natūu ndijin te cuni ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tāca róhó jéē jíni sōho, na chúsóhó ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Te suni ni cahān yā jiín i: Cuni sōho vāha ró. Chi cūhva jeē chusóhó ró jnúhun Yaā Dios, suni cūhva un cuáha ya nuū rō, te víhyá gā cuāha ya nuū maá ró jeē chusóhó váha ró. ");
INSERT INTO mibNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Chi ñayuu je jécūhun ni, stéén gā yā nuū i. Te ñayuu tu cándíje, máá jecu jeē jiní i ún, sa suhva naa. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Te ni cahān gā yā: Súcuan cúu jeē ndácu Yaā Dios jniñu nuū ñáyuu: Cúu nájnūhun trigo jeē ní jete ɨɨn tēe. ");
INSERT INTO mibNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Yūcuán na te quíxí de te ndónda de, te súcuan jíca quɨvɨ̄ cuahān. Te trigo un cáne te jéhnu. Te máá de tu jíní de ndese cúu jeē jéhnu. ");
INSERT INTO mibNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Chi máá ñuhun sáha jeē jéhnu trigo, xīhna gā yucū, sáá te cáne yoco, yūcuán na te íje máá núnī. ");
INSERT INTO mibNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te núu ni cuaan trigo un, te quéjéé ñáyuu cájehnde i, chi je ni jinū quɨvɨ̄ tahndé. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Te suni ni cahān yā: Na cáhán rī ɨɨn jnūhun yátá návāha cuni rō ndese ndúcuehē ñayuu jeē ndácu Yaā Dios jniñu nuū. ");
INSERT INTO mibNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ndúcuehē i nájnūhun jéhnu ɨɨn ndɨquɨn mostaza jeē jéquin i nuū ñúhun. Te yūcuan cúu ɨɨn ndɨquɨn lúlí gá vēsú tācá ndɨquɨn jeē iyó. ");
INSERT INTO mibNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Te ná ni jequin i, te cáne te jéhnu ga vēsú tāca gá yucū, te cúnáhnu ndaha. Te tācá saa chi sáha tɨ tacā tɨ̄ nuū cuándahū xinī ún. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Te cuehē jnūhun yátá súcuan ni cahān yā jiín ñáyuu, núu nasaa cánda i jecūhun ni i. ");
INSERT INTO mibNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Te tāca jéē ni stéén yā, máni máá jnúhun yátá ní cahān yā jiín i. Te nuū tēe cáscuáha jíín yá chi ni nacastūhun cájí yá jnūhun ún. ");
INSERT INTO mibNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Te jeē cuácuaa quɨvɨ̄ ún, te ni cahān yā jiín tée cáscuáha jíín yá: Na yáha yó quíhīn yō ɨnga lado mar, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Te ni casquéndōo de ñayuu cuehē ún, te ni quɨ̄vɨcoo de ini barco nuū je íne Jesús, cuangoo de jíín yá. Te suni cuangoo jecu gā barco jiín de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Te ni jequɨ̄hɨ ɨɨn tachī níhin, te ni stónda ndute mar, te ni quɨ̄vɨ ini barco. Te je yajni chitú ndute ini barco. ");
INSERT INTO mibNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Te Jesús cátú yá yatā de ini barco, quíxí yā te yɨ́hɨ ɨɨn sahma cástíhi xinī yā. Te ni castónda de ya, te ni cacahān de: Maestro, ¿á tu sáha ní cuenta jeē quēe yó chíji ndute te cuu yō? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Te ni ndocuɨñɨ̄ yā, te ni cahān yā nuū tachí níhin un jíín núū mar: Jecuɨñɨ̄ te nayúú‑ni coo ró, áchí yá. Te ni jecuɨñɨ̄ tachī, te ni cuu nayúú íī‑ni. ");
INSERT INTO mibNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Te ni cahān yā jiín de jíjnáhan de: ¿Naun cáyūhú ndasɨ́ ró? ¿Naun tu cácandíje ró jéē cācu ró sáha ri? ");
INSERT INTO mibNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Te yōhyo ni cayūhú de, te ni cacahān de jíín jnáhan de: ¿Ndé ɨɨn ga cúu tēe yáha jéē nde tachī níhin jíín mar cájetáhú jéē cahán de? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Te ni jinū Jesús jiín de jíjnáhan de ɨnga lado mar, región Gadara. ");
INSERT INTO mibNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Te ná ni quenda ya ini barco un, te ɨɨn tēe ñúhun tachī ini, ni quenda de nde nuū yɨ́ndūji ndɨ̄yɨ, te ni quee de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tēe un ndéé de nuū yɨ́ndūji ndɨ̄yɨ. Te tu jéjníñu jeē jíhni ñayuu de, ni jíín cadena. ");
INSERT INTO mibNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Chi cuehē jínu ni conuhnī jehē de ndaha de jíín cadena. Te tāca jínu jéhnde de, te sácuéchí de. Te tú ni ɨɨn cúndeyɨ́ jíín de. ");
INSERT INTO mibNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Te nduú ñuú jíca de yucu jíín núū yɨ́ndūji ndɨ̄yɨ, te cána cóhó de, te stújí de máá de jíín yúū. ");
INSERT INTO mibNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Te náa jícá gá vēji Jesús, te ni jito de ya. Te jínu de ni quee de nuū yā, te ni jecuɨñɨ̄ yɨtɨ́ de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Te ni cana cóhó de: ¿Naun vēji ní núū ná, Jesús Sēhe Yaā Dios, Yaā cujéhnu téyɨ́? Cáhán ndahú ná jíín ní, jíni nahín Yaā Dios, ma stóho ní sáña, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Súcuan ni cahān de, chi je ni cahān Jesús: Táchī, quenda ini tēe yáha quíhīn rō. ");
INSERT INTO mibNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Te ni cajnūhun yá de: ¿Na vé naní ró? Te ni cahān de: Legión naní ná, chi cuehē tachī ñúhun ini ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Te ni cahān ndahú ndasɨ́ de jíín yá jeē ma tájí yá tachī quendacoo región ún. ");
INSERT INTO mibNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Te yajni yucu yúcuan cáhīin cuehē quɨnɨ̄ cájitu tɨ. ");
INSERT INTO mibNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Te tachī jeē ñúhun ini tēe un ní cacahān ndahú jíín yá: Núu tají ní sāñá, te cuāha ní jnúhun quɨ̄vɨcoo ná ini quɨnɨ̄ yūcuán, áchí. ");
INSERT INTO mibNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Te Jesús ni jēhe ya jnūhun. Te ni quendacoo tachī ún ini tēe ún, te ni quɨ̄vɨcoo ini quɨnɨ̄, te íyó nájnūhun uū mil tɨ̄. Te quɨnɨ̄ un ní cajinu tɨ ni nɨngoo tɨ ɨɨn yucáva, ni quɨ̄vɨcoo tɨ nuū mar. Te ni ndaquɨ̄hɨ tɨ ndute, ni cajihī tɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Te tēe cándito tɨ, ni cajinu de cuangoo de jeē ní cayūhú de. Te ni jinūcoo de ni cacastūhún de nuū ñáyuu ñuu un jíín ñáyuu tāca rancho. Te cuangoo ñayuu un cuácondēhé i na vé ni cuu. ");
INSERT INTO mibNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Te ni jinūcoo i nuū íne Jesús, te ni cajito i nuū tée ni ñuhun cuehē tachī ini. Te néne de, te ñúhun de sahma, te je ni nducájí xínī de. Te ni cayūhú ñáyuu ún. ");
INSERT INTO mibNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Te tēe ní cajito, ni canacani de jnūhun nuū ñáyuu, ndese ni nduvāha tēe ni ñuhun tachī ini, jiín ndese ni candoho quɨnɨ̄ ún. ");
INSERT INTO mibNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yūcuán na te ni caquejéé i cácahān ndahú i jíín yá jeē na cújiyo ya región yūcuan quíhīn yā. ");
INSERT INTO mibNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Te ni ndɨ̄vɨ ya ini barco. Te tēe ni ñuhun tachī ini un ní cahān ndahú de jíín yá jeē na cuáha ya jnūhun quihīn de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Te Jesús tu ní jéhe ya jnūhun, chi ni cahān yā jiín de: Cuánuhun vehe ró núū jnáhan ró, te nacani ró jnúhun nuū i ndese yōhyo jéhnu jniñu ni sáha máá Jítoho rō jiín ró, te ndese ni cundáhú ni yā rohó, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Te ni quenda de cuahān de, te ni quejéé de nácani de jnūhun tācá ñuu Decápolis ndese yōhyo jéhnu jniñu ni sáha Jesús jiín de. Te ndɨvii ñayuu un ní canaa ni i cájini nahín i. ");
INSERT INTO mibNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Te ni nayāha tucu Jesús cuanuhun yā ɨnga lado mar jiín barco. Te ni quecoo cuehē ñayuu nuū yā, nuū íne ya yumar. ");
INSERT INTO mibNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Te ni quee ɨɨn tēe cújéhnu ini vehe iī sinagoga, naní de Jairo. Te ná ni jito de nuū yā, te ni jecuɨñɨ̄ yɨtɨ́ de nuū jehé yā. ");
INSERT INTO mibNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Te ni cahān ndahú ndasɨ́ de jíín yá: Sēhe sɨ́hɨ́ ná je yajni cuu i. Na quíhín yō vehe ná te soó ní ndaha ní sɨ́quɨ̄ i návāha na ndúvāha i te cotecu i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yūcuán na te cuahān yā jiín de. Te cuehē ñayuu cándiquīn i ya, te ni chitú níhin i xiin ya cuangoo i. ");
INSERT INTO mibNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Te mēhñu ñáyuu un cuáhān ɨɨn ñahan cúhú, jeē ní cuu uxī uū cuiyā ndóho ña cuehyɨ̄ nɨñɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Te yōhyo ni ndoho ña, chi ni jexin ña tāca jéē névāha ña jíín cuéhē tēe tájná, te tu ní jéjníñu jeē ndúvāha ña, chi sa suhva víhyá gā sáha. ");
INSERT INTO mibNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Te ñahan yáha ná ni nihīn ña jnūhun Jesús, te ni quee ña ichi yátá yā mēhñu ñáyuu cuehē ún, te ni quehé ña yusáhma ya. ");
INSERT INTO mibNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Chi ni jeni ni ña: Vēsú maá sahma ya na níhín rī quehé rí, te nduvāha ri, jéni ni ña. ");
INSERT INTO mibNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Te ni jecuɨñɨ̄‑ni nɨñɨ̄ ña, te ni jini ña jeē ní nduvāha ña cuehyɨ̄ ún. ");
INSERT INTO mibNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Te Jesús ni jini yā jeē ní nduvāha ɨɨn ñayuu jiín fuerza yā. Te ni ndió cóto ya nuū ñáyuu cuehē, te ni cahān yā: ¿Ndé ɨɨn ni quehé sahma ri? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Te tēe cáscuáha jíín yá, ni cacahān de: Jíto ní jéē ñáyuu cuehē yāha ní chitú níhin i xiin ní te cáquɨ̄hɨ i níhín nɨ́ɨ́ cáni ichi, te cájnūhun ní ndé ɨɨn ni quehé sahma ní. ");
INSERT INTO mibNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Te máá yá jíto ya cháha chúcuan, cúní yā jeē na cáchi ñayuu ni sáha. ");
INSERT INTO mibNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Te ñahan un yúhú ña te quɨ́sɨ i ña, te je jíní ña jeē ní nduvāha ña. Te ni quee ña, te ni jecuɨñɨ̄ yɨtɨ́ ña nuū yā, te ni cachi ña ndɨhɨ ndese ni cuu jíín ña. ");
INSERT INTO mibNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Te ni cahān yā jiín ña: Séhē, ni candíje ró jéē cuu nasávāha ri rohó, te jeē yúcuan ní nduvāha ró. Cuáhán te na ndúsɨɨ̄ ni rō, chi je ni nduvāha ró cuéhyɨ̄ ní ndoho ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Te níní cáhán gā yā súcuan, te ni quecoo ñayuu cáyūcú vehe tēe cújéhnu ini vehe iī sinagoga, te ni cacahān i jíín de: Je ni jihī sēhe sɨ́hɨ́ ní. Te ma sajnéñu ga ní Maestro, achí i. ");
INSERT INTO mibNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Te Jesús tu ní sáha ya cuenta jeē súcuan cácahān i, te ni cahān yā jiín tée cújéhnu ini vehe iī sinagoga: Ma yūhu ró, chi candíje ró jéē nastécu rī i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Te tu ní jéhe ga yā jnūhun condiquīn ñayuu yā, chi máá‑ni Pedro jiín Jacobo, jiín Juan ñani Jacobo. ");
INSERT INTO mibNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Te ni jinū yā vehe tēe cújéhnu ini vehe iī sinagoga, te ni jito ya ñayuu, cácuvaā i, te cándahyū i, te cácana cóhó i. ");
INSERT INTO mibNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Te ni quɨ̄vɨ ya, te ni cahān yā: ¿Najehē yōhyo cásávaā rō te cándahyū rō? Sūchi sɨ́hɨ́ yáha, tu ní jíhí i, chi quíxí‑ni i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Te ni cajecū catá i jeē ni cáhān yā. Te ni quenehen ndɨhɨ ya i cuahān i nuū quéhe. Te ni cana ya máá‑ni tátá jiín náná sūchi sɨ́hɨ́ un, jíín tée cáhīin jíín yá, te ni quɨ̄vɨ ya jiín de nuū catú súchi sɨ́hɨ́ ní jihī ún. ");
INSERT INTO mibNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Te ni jnɨɨ ya ndaha i, te ni cahān yā jiín i: Talita cumi, achí yá. Te jnūhun un cúní cahān: Sɨ́hɨ̄, cáhán rī jiín ró, ndocuɨñɨ̄, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Te ni ndocuɨñɨ̄‑ni sūchi sɨ́hɨ́ un, te ni nacaca i, chi je íyó i uxī uū cuiyā. Te yōhyo ni canaa ni ñayuu cájito i. ");
INSERT INTO mibNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Te ni ndacu nīhin ya jniñu nuū i jíjnáhan i jeē ma cáchi cuɨtɨ i nuū ni ɨɨn. Te ni cahān yā jeē na cuáha ña jeē cáji sūchi sɨ́hɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Te ni quenda Jesús yūcuán, te cuanuhun yā ñuu yā. Te tēe cáscuáha jíín yá cuangoo de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Te máá quɨ́vɨ̄ ndétātu ní steén yā jnūhun ini vehe iī sinagoga. Te cuehē ñayuu ni canaa ni i cájini nahín i, te ni cacahān i: ¿Ndé nuū ní cutūhva tēe yáha tāca jnúhun yáha? ¿Te ndese cúu jeē cahán de jnūhun ndíchí yáha jíín jéē sáha de jniñu jéhnu yáha? ");
INSERT INTO mibNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Chi tēe yáha cúu carpintero, te sēhe María cúu de, te ñani Jacobo jiín José jiín Judas jiín Simón cúu de. Te suni cáyūcu cuáha de jíín yó yāhá. Achí i. Te súcuan ni cacujéē ni i nuū Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Te ni cahān yā jiín i: Tāca tée nácani jnūhun Yaā Dios, íyó yɨ́ñúhún ñayuu jiín de, chi máni ñayuu ñuu maá de, jíín jnáhan de, jíín ñáyuu vehe de cúu jeē tu íyó yɨ́ñúhún jíín de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Te tu ní cúu sáha ya cuehē jniñu jéhnu yūcuán. Chi jecu‑ni ñayuu cácuhū ni soó yá ndaha ya sɨquɨ̄ i, te ni nasávāha ya i. ");
INSERT INTO mibNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Te náā ni yā jíto ya jeē tu cácandíje ñayuu jijnáhan i. Yūcuán na te ni jica cuu ya tācá ñuu yajni, ni steén yā jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Te ni cana ya ndɨhúxí uū tēe cáscuáha jíín yá, te ni tají yá ndɨhuū ndɨhuū de quingoo de. Te ni sáha ya jeē cóndiso jníñu de quenehen de tachī ini ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Te ni ndacu ya jeē tú na vé condiso de jeē cuajníñu de ichi, ni ñunu, ni staā, ni xūhún. Chi máá vara‑ni condahá de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Te quɨhɨ de ndijēn, te ma quihín de jíín úū sahma, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Te suni ni cahān yā jiín de: Na‑ni vehe núu ni quɨ̄vɨcoo ró, te yūcuán coyūcu ró ndé quenda tucu ró quíhīn rō ɨnga ñuu. ");
INSERT INTO mibNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te núu ɨɨn ñuu tu cájetáhú i róhó, ni tu cúní i cuni nahín i jnūhun cahān rō, na quéndacoo ró yúcuan, te scóyo ró tɨ́cachā jehē rō, te súcuan stéén rō jeē iyó cuéchi i jeē tu ní cájetáhú i. Jendaá cahán rī jiín ró jeē quɨvɨ̄ coo juicio te xeēn gā coo castigo sɨquɨ̄ ñuu cásáha súcuan vēsú sɨquɨ̄ ñuu Sodoma jiín ñuu Gomorra nuū ní casáha ndasɨ́ ñáyuu cuēchi. ");
INSERT INTO mibNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Te ni quendacoo de cuahān de, te ni canacani de jnūhun jeē na nácani ni ñayuu jeē stóo i cuēchi i. ");
INSERT INTO mibNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Te suni ni caquenehen de cuehē tachī ini ñayuu. Te ni cachihi de aceite cuehē ñayuu cácuhū, te ni canduvāha i. ");
INSERT INTO mibNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Te rey Herodes ni jini jnūhun de jnūhun Jesús, chi ni jitē núu jnūhun ya nɨɨ́ cáhnu. Te ni cahān de: Tēe yúcuan cúu Juan tēe ni scuándute, te ni natecu de. Jeē yúcuan íyó poder de sáha de jniñu jéhnu. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Te sava ga ñayuu ni cacahān i: Tēe un cúu Elías jeē ní nacani jnūhun jenahán. Te sava ga i ni cacahān: Tuú chi ɨɨn tēe nácani jnūhun Yaā Dios cúu de, nájnūhun tēe ni canacani jnūhun ya nde jenahán, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Te ná ni jini Herodes, te ni cahān de: Tuú chi yūcuan cúu Juan jeē ní ndacu ri jniñu ni tahndē xinī, te ni natecu de núu súcuan, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Chi máá Herodes ni ndacu de jniñu jeē na quɨ́vɨ Juan vecāa, jíín jéē na cónuhnī de jíín cadena. Súcuan ni sáha de jeē sɨquɨ́ Herodías, ñasɨhɨ́ ñani de Felipe. Chi Herodes ni quihin de ña jeē cúu tucu ña ñasɨhɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Te Juan ni cahān de nuū Herodes: Tu íyó ley jeē cóndeca ró ñasɨhɨ́ ñani rō, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Te jeē yúcuan Herodías ni jito uhū ña Juan, te cúní ña jeē na cúū de, te tu ní níhín ña modo. ");
INSERT INTO mibNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Chi Herodes yúhú de cahni de Juan, chi jíní de jeē tēe ndaā tēe ndoo cúu Juan. Te jeē yúcuan ní jesɨ de jeē nducú ña jeē cúū Juan. Te nújnahan ni de jíni nahín de jnūhun cáhán Juan, vēsú tu jécūhun vāha ni de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Te ni quee ɨɨn quɨvɨ̄ jeē ní cundeyɨ́ Herodías. Chi ni sáha Herodes ɨɨn vico quɨvɨ̄ ní cacu de, te ni jēhe de jeē ní cacuxíni tēe cándiso jníñu nuū de, jíín tée cácuu capitán, jíín tée cácujéhnu región Galilea. ");
INSERT INTO mibNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Te ni quɨ̄vɨ sēhe sɨ́hɨ́ máá Herodías, ni jita jéhé i nuū chitú un. Te ni cacusɨɨ̄ ni rey Herodes jiín tée cácuxíni jíín de. Te ni cahān de jíín súchi sɨ́hɨ́ un: Cacān na vé cuní rō, te cuāha ri nuū rō, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Te ni cahān teyɨ́ de jeē cuáha de núu na vé cuní i cacān i, vēsú nde sava región jeē yɨ́hɨ ndaha de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Te ni quenda i, ni jecajnūhún i náná i: ¿Na vé cacān na núū de? áchí i. Te ni cahān ña: Xinī Juan tēe scuándute cacān rō nuū de, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yūcuán na te ni ndɨ̄vɨ‑ni i nuū rey, te ni cahān i: Cúní na jéē vijna ñúhún‑ni cuāha ní xínī Juan tēe scuándute, cone nuū ɨɨn cohō, achí i jíín de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yūcuán na te ni cucuíhyá ndasɨ́ ni rey un jeē ní cundeyɨ́ Herodías jeē cúū Juan. Te sɨquɨ̄ jeē ni jéjnūhun téyɨ́ de, jíín jéē ní cajini sōho tēe cáyeji staā jiín de, jeē yúcuan tu ní cúní de sásáhán de jeē ni jícān i. ");
INSERT INTO mibNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Te ni tají‑ni de ɨɨn soldado jeē quíquīhin de xinī Juan. ");
INSERT INTO mibNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Te ni jehēn soldado un vecāa, te ni jehnde de xinī Juan. Te ni quee de jíín xínī Juan, íne nuū ɨɨn cohō. Te ni jēhe de nuū sūchi sɨ́hɨ́ un, te máá i ni jēhe i nuū naná i. ");
INSERT INTO mibNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Te tēe cáscuáha jíín Juan ni canihīn de jnūhun, te ni jengoo de, ni candonehen de yɨquɨ cúñu Juan, te ni cachindūji de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yūcuán na te tēe cácuu apóstol jeē ní tají yá cuangoo nacani jnūhun, ni ndecoo de nuū Jesús. Te ni canacani de nuū yā tācá jniñu ni casáha de, jíín jnúhun ni castéén de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Te ni cahān yā jiín de: Na quíngoo yó ɨɨn lugar nuū tú ñayuu, te ndetātu yó jecu, achí yá. Chi cuehē ñayuu cuahān i vēji i nuū yā, te ni tu ní núne ya jeē cáji yā staā jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yūcuán na te ni quɨ̄vɨ ya ɨɨn barco jiín táca tée apóstol un, te cuangoo sɨ́ɨn ya jiín de ɨɨn lugar nuū tú ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Te cuehē ñayuu ni cajito i jeē cuahán yā jiín de, te ni canacuni i jeē maá yá cúu. Te nde tācá ñuu ni quendacoo i, te yachī cuangoo i, te xīhna gā i ni jinūcoo vēsú maá yá. ");
INSERT INTO mibNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Te nuū ní quenda Jesús ini barco, te ni jito ya ñayuu cuehē ún. Te ni cundáhú ni yā i, chi cúu i nájnūhun lanchi jeē tú jitoho tɨ̄. Te ni steén yā cuehē jnūhun nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Te nuū ní ini, te tēe cáscuáha jíín yá, ni quecoo de nuū yā, te ni cacahān de: Je ni ini, te yāhá chi tú na ñayuu yúcu. ");
INSERT INTO mibNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Núu súcuan te tají ní ñayuu na quíngoo i tāca rancho jiín ñuu yajni, te cuaan i staā caji i, chi tú na vé cándiso i caji i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Te ni cahān Jesús jiín de: Cuāha máá ró jeē cáji i, áchí yá. Te ni cacahān de: ¿Te ndese cuu? Chi ni ma cúu vēsú núu quicuaan ná ndé uū ciento denario staā caji ñayuu, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Te ni cahān yā jiín de: ¿Nasaa staā cánevāha ró? Cuacondēhe, áchí yá. Te nuū ní cajini de, te ni cacahān de: Uhūn‑ni staā jiín úū chācá íyó, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yūcuán na te ni cahān yā jiín ñáyuu jeē na cúcōo sɨ́ɨn i cuenta grupo nuū íte. ");
INSERT INTO mibNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Te ni cacucōo sɨ́ɨn ciento ciento i, jíín cincuenta cincuenta i. ");
INSERT INTO mibNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Te ni quihin ya ndɨhúhún staā jiín úū chācá un, te ni ndacoto ya ichi ándɨvɨ́, te ni nacuatáhú yá. Te ni tahú cuéchí yá staā ún, te ni jēhe ya nuū tée cáscuáha jíín yá, te máá de ni casaja de nuū ñáyuu cuehē ún. Te suni ni jēhe ya ndɨndúú chācá, ni casaja de nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Te ndɨvii i ni cayeji, te ni candutú chíji i. ");
INSERT INTO mibNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yūcuán na te ni canastútú de pedazo staā jiín cháca jéē ní quendōo, te ni chitú úxī uū jīca. ");
INSERT INTO mibNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Te tēe ni cayeji, chi uhūn mil de cúu. ");
INSERT INTO mibNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yūcuán na te ni cahān‑ni Jesús jiín tée cáscuáha jíín yá jeē na quɨ́vɨcoo de barco, te cosnūú de yāha de ɨnga lado mar ñuu Betsaida. Te máá yá chi natají yá ñayuu quinuhun i, te sáá te suni quihīn yā. ");
INSERT INTO mibNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Te nuū ní cuu ni natají yá i, te ni caa ya yucu cuacacān tahú yā. ");
INSERT INTO mibNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Te jeē ní cuaa, te barco un je ni cuu sava nuū mar cuahān, te máñúhún‑ni ya ni quendōo nuū ñúhun íchi. ");
INSERT INTO mibNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Te ni jito ya jeē yóhyo jnūndóho cáscáca de barco, chi nīhin vēji tachī ichi núú de. Te jeē yɨ́nee gā ni quee ya nuū de, jíca jéhé yá nuū mar. Te yāha ya nuū de quihīn yā nuú. ");
INSERT INTO mibNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Te ni cajito de jeē jíca ya nuū mar, te ni cajeni ni de jeē jihná cúu, te ni cacana cóhó de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Chi ndɨhɨ de ni cajito nuū yā, te ni cayūhú ndasɨ́ de. Te ni cahān‑ni ya jiín de: Ndeyɨ́ coo ni rō, te ma yūhu ró, chi máá rí cúu, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Te ni quɨ̄vɨ ya ini barco un, te ni jecuɨñɨ̄‑ni tachī. Te yōhyo ni canaa ni de cájito de. ");
INSERT INTO mibNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Chi cándāa néé gá jeē níjnūní de, chi ni jíín jniñu jéhnu jeē ní nducuehē staā, tu ní cájecūhun ni de jeē maá yá cúu Yaā ní tají Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Te ni quenda jíyo ya jiín de nuū mar ún, ní jinū yā región Genesaret. Te yundúte un ní cajihni de barco. ");
INSERT INTO mibNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Te nuū ní quenda ya jiín de ini barco, te ñayuu yúcuan ni canacuni‑ni i ya. ");
INSERT INTO mibNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Te yachī ni jengoo i tācá ndañúū yūcuán, te ni caquindeca i ñayuu cácuhū, cáyosó i nuū camilla, vējicoo ñayuu nuū ní jito i íne ya. ");
INSERT INTO mibNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Te ndé‑ni cúu‑ni núu ni quɨ̄vɨ ya, núu ñuu lulí, chí ñuu cáhnu, chí rancho, te cájequin i ñayuu cácuhū yuhíchi, te cácahān ndahú i jíín yá jeē na quéhé i vēsú yusáhma ya. Te tāca ñáyuu jeē ní caquehé sahma ya, ni canduvāha‑ni i. ");
INSERT INTO mibNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Yūcuán na te tēe grupo fariseo jiín jecu tēe cástéén tutu ley Yaā Dios, ni quendacoo de ñuu Jerusalén, te ni quecoo de nuū Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Te tēe un ní cajito de jeē sava tēe cáscuáha jíín Jesús, ni cayeji jnehén de staā, chi tu ní cásquícu de costumbre jeē nándahá de nuū Yaā Dios. Te ni cacahān sɨquɨ̄ de. ");
INSERT INTO mibNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Chi tēe fariseo jiín ndɨhɨ ñayuu hebreo, névāha i costumbre jenahán jéē ma cáji i staā núu tu nandahá váha i xīhna gā. ");
INSERT INTO mibNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Te núu ni ndecoo i jeē ni jéngoo i nuū yáhu, te tu cáyeji i te núu tu nandahá i. Te íyó cuéhē gā costumbre jenahán jeē casquícu i, nájnūhun jeē ndúndoo taza, tɨndohō, cohō cáa, jíín jíto. ");
INSERT INTO mibNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Te tēe fariseo jiín tée cástéén tutu ley Yaā Dios, ni cacajnūhún de ya: Tēe cáscuáha jíín ró, ¿naun tu cásquícu de costumbre ñayuu jenahán? Chi sa cáyeji jnehén de staā, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Te ni cahān yā jiín de: Ndaā ni nacani Isaías jnūhun sɨquɨ̄ rō jijnáhan ró jéē tēe stáhú‑ni cácuu ró. Chi súcuan ni tee de jnūhun ni cahān Yaā Dios nde jenahán: Ñayuu yáha chi máá yuhu‑ni i cájetáhú i ruhū, te nasūu ndé jiín ini jiín ánuá i. ");
INSERT INTO mibNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Te cáchiñúhún sáá‑ni i ruhū, chi jnūhun cástéén i cúu jniñu ní candacu tēe, te nasūu jéē ní ndacu máá rí cúu. Achí Yaā Dios. Achí Isaías. ");
INSERT INTO mibNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Súcuan cácuu ró, chi ni casiáá rō jniñu ní ndacu Yaā Dios nuū rō, te cásquícu ró costumbre jeē ní cajequin ñayuu, jeē ndúndoo tɨndohō jiín taza. Te cuehē gā costumbre súcuan cásquícu ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Te suni ni cahān yā: Cásiáá rō jniñu ní ndacu Yaā Dios, návāha squícu ró costumbre ni cajequin máá ró. ");
INSERT INTO mibNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chi Moisés ni cahān de: Coo yɨ́ñúhún ró jiín tátá rō jiín náná rō. Te núu ndé ɨɨn cahān sɨquɨ̄ tatá chí sɨ́quɨ̄ naná, na cúū nahín. Achí Moisés. ");
INSERT INTO mibNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Te máá ró chi cácahān rō jeē cuu cahān ɨɨn tēe jíín tátá de náná de: Ma cúu chindéé ñáhán ná níhín cuáha na jéē cáji ni jéē cúhun ní, chi ndɨhɨ jeē névāha ná, chi Corbán cúu, áchí ró. (Te jnūhun Corbán cuní cahān jeē ni sócō nuū Yaā Dios.) ");
INSERT INTO mibNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Te cácahān rō jeē núu súcuan cahān ɨɨn tēe, te tuá cánuú chindéé ñáhán de tátá de náná de. ");
INSERT INTO mibNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Te súcuan cástɨ́vɨ ró jniñu ní ndacu Yaā Dios, jeē sɨquɨ́ costumbre ni cajequin ñayuu jenahán vēji. Te cuehē gā jniñu súcuan cásáha ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Te ni cana tucu ya ñayuu cuehē ún, te ni cahān yā jiín i: Cuni sōho vāha ró jíjnáhan ró, te chuhun ni rō: ");
INSERT INTO mibNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tāca jéē iyó, te núu ni quɨ̄vɨ yuhu ñayuu te tu cújnéhén i sáha. Chi jeē quénda ini anuá ñayuu, yūcuan cúu jeē cujnéhén i sáha. ");
INSERT INTO mibNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tāca róhó jéē jíni sōho, na chúsóhó ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Te ni stóo ya ñayuu cuehē ún, te ni quɨ̄vɨ ya ini vehe. Te tēe cáscuáha ún, ni cacajnūhún de ya sɨquɨ̄ jnúhun yátá yáha jéē ni cáhān yā. ");
INSERT INTO mibNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Te ni cahān yā jiín de: ¿A máá ró suni ná tu jecūhun ni rō, chí naún? ¿A tu cájini rō jeē tāca jéē quɨ́vɨ ini ñayuu, ma cúu cujnéhén i sáha? ");
INSERT INTO mibNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Chi tu quɨ́vɨ ini anuá i, chi chīji i quɨ́vɨ, te quénda‑ni cuahān, achí yá. Súcuan ni steén yā jeē tāca jéē yéji ñayuu, tu cújnéhén ánuá i sáha. ");
INSERT INTO mibNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Te ni cahān gā yā: Jeē quénda ini anuá ñayuu, yūcuan cúu jeē cujnéhén i sáha. ");
INSERT INTO mibNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chi nde ini anuá ñayuu quénda jeē jéni néé ni, jeē casɨ́quɨ́ ndéē jnáhan, jeē jíca jnéní, jeē jéhni ndɨ̄yɨ, ");
INSERT INTO mibNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jeē sacuíhná, jeē ndíyo ni ndajníñu jnáhan, jeē sáha néé, jeē stahú jnáhan, jeē máni cuēchi sáha, jeē cucuésún ni, jeē cahán yāa sɨ́quɨ̄ jnáhan, jeē sandúxí máá, jeē canéé xínī. ");
INSERT INTO mibNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tācá jniñu néé yáha, máni ini anuá ñayuu quénda, te cújnéhén i sáha, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Te ni quenda ya yūcuan cuáhān yā región Tiro jiín Sidón. Te ni quɨ̄vɨ ya ɨɨn vehe, te cúní yā jeē tú ni ɨɨn ñayuu cuni jeē íne ya yūcuán. Te vēsú súcuan, te tu ní cúu cone sāhi yá. ");
INSERT INTO mibNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Te ɨɨn ñahan íyó séhe sɨ́hɨ́ ña jeē ñúhun tachī ini i, ni nihīn‑ni ña jnūhun jeē íne ya. Te ni quee ña, te ni jecuɨñɨ̄ yɨtɨ́ ña nuū jehé yā. ");
INSERT INTO mibNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Te ñahan ñuu jicá cúu ña, chi nde Sirofenicia cúu nación ña. Te ni cahān ndahú ña jíín yá jeē na quénehen ya tachī ini sēhe sɨ́hɨ́ ña. ");
INSERT INTO mibNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Te ni cahān Jesús jiín ña: Nasūu núū maá ní vēji ná, chi máni nuū ñáyuu cácuu sēhe Israel. Chi tu íyó váha jeē quénde yō staā sēhe te cuāha yó núū ína, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Te ni cahān ña: Jendaá cahán ni Tátā, te chindéé ñáhán ní sáña vēsú cúu ná nájnūhun ina. Chi suni máá tɨ́ cáhīin tɨ chīji mesa, cánihīn tɨ̄ staā cuechí jéē cóyo yuhu sūchi lúlí cáyeji tɨ̄, achí ña. ");
INSERT INTO mibNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yūcuán na te ni cahān yā jiín ña: Vāha ni cahān ní. Cuáhán ní núu súcuan, chi je ni quenda tachī ún ini sēhe sɨ́hɨ́ ní, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Te ni najinū ña vehe ña, te ni jito ña jeē catú sēhe sɨ́hɨ́ ña nuū jíto, te je ni quenda tachī ún ini i. ");
INSERT INTO mibNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Te ni quenda tucu ya región Tiro, ni yāha ya Sidón jiín táca ñuu Decápolis, te ni jinū yā mar Galilea. ");
INSERT INTO mibNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Te ni caquindeca i ɨɨn tēe sóhó cástété nuū yā, te ni cacahān ndahú i jíín yá jeē na sóó yá ndaha ya sɨquɨ̄ de. ");
INSERT INTO mibNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Te ni quenehen sɨ́ɨn ya de nuū ñáyuu cuehē ún, te ni chune ya xinī ndáha ya sōho de, te ni tesɨ̄hɨ yá, te ni quehé yá yaá de. ");
INSERT INTO mibNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Te ni ndacoto ya ichi ándɨvɨ́, te ni jitū ni yā, te ni cahān yā: Efata, achí yá, jeē cuní cahān: Nanune. ");
INSERT INTO mibNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Te ni nanune‑ni sōho de, te ni nduvāha yáá de, te ni nacahān vāha de. ");
INSERT INTO mibNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Te ni ndacu ya jniñu nuū ñáyuu un jéē ma cáchi i nuū ní ɨɨn. Te vēsú ni cahān nīhin ya jiín i, te víhyá gā ni cajete i jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Te yōhyo ni canaa ni i cájito i, te ni cacahān i: Vāha sáha ya tācá jniñu, chi nde tēe cásóhó, cánacuni sōho de, te tēe cándāa ñɨ́hɨ́n, cánacahān vāha de sáha ya, achí i. ");
INSERT INTO mibNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Te tiempo un ní candutútú cuéhē ndasɨ́ ñáyuu, te tuá na vé caji i. Te ni cana Jesús tēe cáscuáha jíín yá, te ni cahān yā: ");
INSERT INTO mibNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Cúndáhú ni rī ñayuu yāhá, chi je ni cuu unī quɨvɨ̄ cáyūcú i jíín rí, te tuá na vé caji i. ");
INSERT INTO mibNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Te núu natají rí i quinuhun ndite i vehe i, te cuīta íī i sava ichi, chi íyó sava i jeē jicá véjicoo i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Te tēe cáscuáha un ní cacahān de: ¿Te ndé nuū nihín yō staā caji i jíjnáhan i? Chi yāhá tú na ñayuu yúcu, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Te ni cajnūhun yá de: ¿Nasaa staā cánevāha ró? Te ni cacahān de: Uxā‑ni, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yūcuán na te ni cahān yā jiín ñáyuu cuehē un jéē na cúcōo i. Te ni quihin ya ndɨhúxá staā ún, te ni nacuatáhú yá nuū Yaā Dios. Te ni tahú cuéchí yá, te ni jēhe ya nuū tée cáscuáha jíín yá. Te máá de ni casaja de nuū ñáyuu cuehē ún. ");
INSERT INTO mibNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Te suni cándiso de jecu chācá lúlí. Te ni nacuatáhú yá sɨquɨ̄, te ni cahān yā jeē suni saja de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Te ndɨhɨ i ni cayeji, te ni candutú chíji i. Yūcuán na te ni canastútú de pedazo jeē ní quendōo, te ni chitú úxā jīca. ");
INSERT INTO mibNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Te tēe ni cayeji un, íyó nájnūhun cuūn mil de. Te ni nacuatáhú yá nuū ñáyuu ún, te cuanungoo i. ");
INSERT INTO mibNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yūcuán na te ni ndɨ̄vɨ‑ni ya ini barco jiín tée cáscuáha jíín yá, te cuahān yā región Dalmanuta. ");
INSERT INTO mibNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yūcuán na te ni quecoo tēe grupo fariseo, te ni caquejéé de stíchí de Jesús. Te cácuni de coto ndee de ya, te ni cajicān de jeē sáha ya ɨɨn jniñu jéhnu jeē coo ɨɨn seña ichi ándɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Te ni jitū ni yā sɨquɨ̄ jeē tu cácandíje de jíjnáhan de, te ni cahān yā: ¿Naun cájicān ñayuu yáha ɨɨn jniñu jéhnu nuū rī? Jendaá cahán rī jeē ma stéén rī ni ɨɨn jniñu jéhnu nuū ñáyuu yāhá. ");
INSERT INTO mibNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Te ni squéndōo ya de jíjnáhan de, te ni ndɨ̄vɨ tucu ya ini barco, te cuahān yā ɨnga lado mar. ");
INSERT INTO mibNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Te tēe cáscuáha jíín yá ni canaa ni de condiso de jeē cáji de, chi ɨɨn‑ni pan cánevāha de ini barco. ");
INSERT INTO mibNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Te ni ndacu ya jniñu nuū de: Coto má candíje ró levadura tēe grupo fariseo jiín levadura Herodes, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Te ni cacahān tēe cáscuáha un jíín táca jnáhan de: Va sɨquɨ̄ jeē tú na staā ndíso yó, jeē yúcuan cáhán yā súcuan, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Te ni jini Jesús, te ni cahān yā: ¿Najehē cándajnūhun ró jeē ni cáhān rī súcuan sɨquɨ̄ jeē tú na staā cándiso ró? ¿A ná tu cuni rō, á ná tu jecūhun ni rō jeē tu ní cáhān rī súcuan sɨquɨ̄ jeē tu cándiso ró stáā? ¿A yóhyo uun ni rō candíje ró? ");
INSERT INTO mibNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Iyó tɨ́nūu ró ¿te á tu cájito ró? Iyó sóho ró ¿te á tu cájini ró? ¿Te á tu cánucūhun ni rō? ");
INSERT INTO mibNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Chi ná ni tahú cuéchí rí uhūn staā ni cayeji uhūn mil tēe, ¿te nasaa jīca ni chitú pedazo staā jeē ní canastútú ró? Achí yá. Te ni cacahān de: Uxī uū jīca, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Te suni súcuan ná ni tahú cuéchí rí uxā staā ni cayeji cuūn mil tēe, ¿te nasaa jīca ni chitú pedazo staā jeē ní canastútú ró? Achí yá. Te ni cacahān de: Uxā jīca, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Te ni cahān yā jiín de: Te nde vijna ¿á ná tu jecūhun ni rō jijnáhan ró? Súcuan ni cahān yatá yá jeē ma cándíje de jnūhun stáhú cástéén tēe ún. ");
INSERT INTO mibNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yūcuán na te ni jinū yā jiín de ñuu Betsaida. Te ni caquindeca ñayuu ɨɨn tēe cuáá núū yā, te ni cacahān ndahú i jíín yá jeē na tée ya ndaha ya nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yūcuán na te ni jnɨɨ ya ndaha tēe cuáá un, te ni quenehen ya de yatā ñúū ún. Te ni tee ya tesɨ̄hɨ yá tɨnūú de, te ni tee ya ndaha ya sɨquɨ̄. Te ni cajnūhun yá de núu cuu coto de jecu. ");
INSERT INTO mibNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Te ni ndacoto de, te ni cahān de: Jíto ná ñayuu jeē cájica i, te tu jíto cájí ná, chi ná cáa yujnu cáa i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yūcuán na te ni tee tucu ya ndaha ya sɨquɨ̄ tɨnūú de. Te ni ndacoto vāha de, te ni nduvāha‑ni tɨnūú de, te ni jito cájí de ndɨhɨ‑ni. ");
INSERT INTO mibNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Te ni natají yá de quinuhun de vehe de, te áchí yá: Ma quɨ́vɨ ró ñuu, ni ma cáchi cuɨtɨ rō nuū ní ɨɨn, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yūcuán na te Jesús jiín tée cáscuáha jíín yá, cuahān yā tācá ndañúū Cesarea Filipo. Te ichi un ní cajnūhun yá de: Ruhū, ¿ndé ɨɨn cúu ri cácahān ñayuu? ");
INSERT INTO mibNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Te ni cacahān de: Sava i cácahān jeē cúu ní Juan tēe ni scuándute. Te sava ga i cácahān jeē cúu ní Elías, tēe ni nacani jnūhun Yaā Dios nde jenahán. Te sava ga i cácahān jeē ɨnga tēe ni nacani jnūhun Yaā Dios cúu ní. ");
INSERT INTO mibNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yūcuán na te ni cajnūhun yá de: Te máá ró, ¿ndé ɨɨn cúu ri cácahān rō? Te ni cahān Pedro: Máá ní cúu Cristo, Yaā ní tají Yaā Dios, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Te ni ndacu ya jniñu nuū de jíjnáhan de jeē ma cáchi de jnūhun yáha nuū ní ɨɨn ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Te ni quejéé yá steén yā nuū de: Máá rí, Yaā ní nduu tēe, cánuú ndoho xeēn rī. Te tāca tée jéhnu jíín sútū cácujéhnu jíín tée cástéén tutu ley, squéhichī de ruhū, te cahni de ruhū. Te nuū uní quɨvɨ̄ te natecu rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Te cájí ní cahān yā jnūhun yáha. Yūcuán na te Pedro, ni cana máñúhún de ya, te ni quejéé de cáhán de nuū yā jeē ma cuáha ya jnūhun coo súcuan. ");
INSERT INTO mibNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Te máá yá ni ndió cóto ya ni jito ya nuū tée cáscuáha jíín yá. Te ni cahān yā nuū Pedro: Cujiyo quihīn rō, chi cáhán rō ná cáhán Satanás. Chi tu jéni ni rō nájnūhun jéni ni Yaā Dios, chi sa suhva jéni ni rō nájnūhun cájeni ni ñayuu, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Te ni cana ya tēe cáscuáha jíín yá jiín ñáyuu cuehē ún, te ni cahān yā: Na‑ni ñayuu núu cúní i condiquīn i ruhū, na cásɨ i jeē cuní maá i, te na cóndiquīn i ruhū te cuāha i jnūhun ndoho i jnūndóho jeē sɨquɨ́ rī, vēsú na cúū i. ");
INSERT INTO mibNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chi núu ndé ñáyuu cuní i cācu i nuū jnúndóho quiji nuū i jeē sɨquɨ́ ruhū, núu súcuan te jnahnū ndetū i nɨ́ɨ́ cáni. Te núu ndé ñáyuu, vēsú na cúū i jeē sɨquɨ́ ruhū jiín sɨ́quɨ̄ jeē scáca i jnūhun jeē jnáma ri ñayuu, núu súcuan te cotecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Chi ndé cuajníñu vēsú na cúndeyɨ́ ñáyuu nihīn i nɨ́ɨ́ ñáyɨ̄vɨ́, te núu quɨ̄vɨ i nuū jnahnú ndetū i? ");
INSERT INTO mibNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Chi tú na jiín cuɨtɨ chunaa ñayuu jeē cácu ánuá i. ");
INSERT INTO mibNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Te ñayuu yáha tu cácandíje cuɨtɨ i, te máni máá cuéchi cásáha i. Te núu na‑ni ñayuu cúcanu i nuū ñáyuu yáha jeē sɨquɨ́ ruhū, Yaā ní nduu tēe, jíín sɨ́quɨ̄ jnúhun cáhán rī, suni súcuan cucanu rī jeē sɨquɨ́ máá i, quɨvɨ̄ ndíji ri jiín táca ndajéhé ndoo ri. Te quɨvɨ̄ ún chi yōhyo luu cujéhnu ri nájnūhun cújéhnu Tátá rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Te suni ni cahān yā jiín de jíjnáhan de: Jendaá cahán rī jiín ró jeē sava tēe cáhīin yāhá, ma cúū de chi nde cuni de jeē ndácu Yaā Dios jniñu jíín poder yā, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yūcuán na te nuū iñú quɨvɨ̄ te Jesús ni jeca ya Pedro jiín Jacobo jiín Juan, cuahān sɨ́ɨn ya jiín de ɨɨn yucu súcún. Te yūcuán, tucu ni nduu ya nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Te sahma ya ni ndindēé, te ni nducuíjín quɨyɨ, nájnūhun yuhvā volcán. Te tú ni ɨɨn ñayuu ñayɨ̄vɨ yáha cuu nacate jeē ndúquɨyɨ ndasɨ́ súcuan. ");
INSERT INTO mibNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Te ni cajito de jeē Elías jiín Moisés cándajnūhún de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yūcuán na te ni cahān Pedro jiín Jesús: Maestro, nacā jeē váha jeē cáhīin na yáha. Te na sáha ná únī vehe ramada, ɨɨn cuu máá ní, ɨnga cuu Moisés, te ɨnga cuu Elías, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Chi yōhyo ni cayūhu tée cáscuáha ún, te Pedro tu ní sáha de cuenta na vé cúu jeē cahán de. ");
INSERT INTO mibNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Te ni quiji vicō nūhun ní jesɨ‑ni nuū de. Te nuū vicó un ní cahān ɨɨn jnūhun: Yāha cúu Sēhe ri jeē maní ndasɨ́ rí jiín. Te na cúni nahín ró jnūhun cáhán yā. Achí. ");
INSERT INTO mibNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Te ni candacoto‑ni de, te tuá tēe un ní cájito de, chi máá ɨɨn na Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Te ni cananuu de jíín yá yucu ún. Te ni ndacu nīhin ya jniñu nuū de jeē ma cáchi de nuū ní ɨɨn jeē súcuan ni cajito de, chi nde na nátecu maá yá, Yaā ní nduu tēe, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jeē yúcuan ní cachuvāha de tāca jéē ní cuu ún, te cácajnūhun jnáhan de na jnūhun cúu jeē nátecu yā. ");
INSERT INTO mibNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Te ni cacajnūhún de ya: Te tēe cástéén tutu ley Yaā Dios, ¿najehē cácahān de jeē cánuú ndiji Elías xīhna gā, te sáá te quiji Yaā cúu Cristo? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Te ni cahān yā: Jendaá cúu jeē xíhna gā quiji ɨɨn tēe cúu nájnūhun Elías, te sátūhva de ndɨhɨ, áchí tutu. ¿Te ndese cáhán tucu tutu iī sɨquɨ̄ ruhū, Yaā ní nduu tēe? Cáhán jeē ndoho xeēn rī, te sájéē ni i nuū rī. ");
INSERT INTO mibNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Te cáhán rī jiín ró jeē jé ni quiji tēe ni cuu nájnūhun Elías, te ni casáha ndevāha ñayuu jiín de tāca jéē ní cacuu ni maá i, nájnūhun cáhán jnūhun de nuū tútu, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Te ni najinū yā jiín de nuū sava ga tēe cáscuáha jíín yá, te ni cajito ya ñayuu cuehē ndasɨ́, ni cajicó ndúū i de. Te suni cáhīin tēe cástéén tutu ley Yaā Dios, cátejnáhan jíín de. ");
INSERT INTO mibNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Te nuū ní cajito tāca ñáyuu un jéē véji ya, te ni canaa ni i. Te cájinu i cuangoo i nuū yā jeē cahān i jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Te ni cajnūhun yá i: ¿Na sɨquɨ̄ cátejnáhan ró jíín de jíjnáhan de? áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Te ni cahān ɨɨn tēe íne yūcuán: Maestro, vendeca ná séhe ná núū ní, chi ñúhun ɨɨn tachī ini i, te ni cuñɨ́hɨ́n i ni sáha. ");
INSERT INTO mibNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Te ndé-ni cúu nuū íne i, te tachī un scótúú i, te jéhni yɨ̄hɨ́‑ni i. Te jée tiñū yuhu i, te squɨ́hñɨ jnúhun i. Te cuacuxií ndasɨ́ i sáha. Te ni cahān ndahú ná jiín tée cáscuáha jíín ní jeē na quénehen de tachī ún, te tu ní cúu sáha de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Te ni cahān yā jiín de jíjnáhan de: Ñayuu tu cándíje cuɨtɨ cácuu ró. ¿Nasaa ga quɨvɨ̄ condee rī jiín ró? ¿Te nasaa ga quɨvɨ̄ cuandeyɨ́ ni rī jiín ró? Cuáquihin sūchí un, na quíji i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Te ni caquindeca de i nuū yā. Te nuū ní jito tachī un núū yā, te ni jehni yɨ̄hɨ́‑ni i. Te ni cotúú i, te cónéhén cócáni i, te jée tiñū yuhu i. ");
INSERT INTO mibNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Te Jesús ni cajnūhun yá tatá i: ¿Nasaa cuiyā ni cuu jeē sáha súcuan jíín i? Te ni cahān de: Nde lulí i. ");
INSERT INTO mibNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Te ni cuu cuehē jínu scótúú táchī ún i nuū ñuhún nuū ndúte, jeē cáhni i cúní. Te núu cuu sáha ní, te cundáhú ni ní chindéé ñáhán ní sāña jéē ndúvāha sēhe ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Te ni cahān Jesús jiín de: Núu cuu candíje ró jéē sáha ri, chi ñayuu candíje te cuu tāca jéē cuní i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Te máá tátá sūchí un ní cahān jee de: Cándíje ná, te chindéé ñáhán ní sāña jéē candíje nīhin ga ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Te ni jito Jesús jeē ní cutútú cuéhē ñayuu nuū yā. Te ni cahān yā nuū tachí: Tachī jeē sañɨ́hɨ́n sásóhó, ruhū ndácu ri jniñu jeē na quénda ró ini sūchi yáha, te ma ndɨ́vɨ ga rō ini i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yūcuán na te ni cana cóhó táchī ún, te ni jehni yɨ̄hɨ́ tucu i, te ni quenda cuahān. Te sūchí un ní cuu i nájnūhun ndɨ̄yɨ. Te ni cacahān cuehē ñayuu jeē jé ni jihī i. ");
INSERT INTO mibNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Te Jesús ni jnɨɨ ya ndaha i, te ni ndonehen ya i, te ni nucuɨñɨ̄‑ni i. ");
INSERT INTO mibNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yūcuán na te ni quɨ̄vɨ ya ini ɨɨn vehe, te tēe cáscuáha jíín yá, ni cacajnūhun sɨ́ɨn de ya: ¿Najehē tu ní cúu quenehen ná tachī un jíjnáhan ná? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Te ni cahān yā: Ɨɨn tachī súcuan chi ma quénda cuɨtɨ te núu tú cacān tahú rō te coo ndite ni rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Te ni quenda ya yūcuan jíín de jíjnáhan de, te ni yāha ya ndañúū Galilea cuahān yā. Te tu ní cúní yā jeē cúni ni ɨɨn ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Chi stéén yā nuū tée cáscuáha jíín yá, te áchí yá: Máá rí, Yaā ní nduu tēe, nastúu i ruhū nuū tāca tée xeēn. Te cahni de ruhū, te núu ni jihī rī, te nuū uní quɨvɨ̄ te natecu rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Te tu ní cájecūhun ni de jnūhun yáha, te cáyūhú de cajnūhún de ya sɨquɨ̄ jnúhun ni cahān yā. ");
INSERT INTO mibNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Te ni jinū yā jiín de ñuu Capernaum, te nuū ni quɨ́vɨ ya ini vehe, te ni cajnūhun yá de: ¿Na jnūhun ni candajnūhun ró ichi véji yó? áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Te tu ní cácahān cuɨtɨ de, chi ichi un ní cacahān de sɨquɨ̄ núu ndé ɨɨn de cújéhnu ga. ");
INSERT INTO mibNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yūcuán na te ni cucōo ya, te ni cana ya ndɨhúxí uū de, te ni cahān yā: Núu ndé ɨɨn ró cúní cujéhnu ga, na cúu ró tée núu ga nuū tāca jnáhan ró, te cuajníñu ró núū jnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yūcuán na te ni jnɨɨ ya ndaha ɨɨn sūchi lúlí, te ni jeni ya i mēhñú de jíjnáhan de. Te ni nundee yā i, te ni cahān yā jiín de: ");
INSERT INTO mibNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Na‑ni ñayuu núu jeē sɨquɨ́ ruhū jetáhú i ɨɨn sūchi lúlí nájnūhun sūchi yáha, te ruhū jetáhú i. Te ñayuu jetáhú rúhū, nasūu máá ɨɨn‑ni ruhū, chi suni Yaā ní tají rúhū jetáhú i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yūcuán na te ni cahān Juan jiín yá: Maestro, ni cajito ná ɨɨn tēe jeē jiín sɨ́hvɨ́ ní quénehen de tachī ini ñayuu. Te ni cajesɨ ná jéē sáha de, chi tu jíca de jíín yó, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Te ni cahān Jesús jiín de: Ma cásɨ rō jeē sáha de. Chi ni ɨɨn tēe jeē jiín sɨ́hvɨ́ rí sáha de jniñu jéhnu, ma cúu nacahān de sɨquɨ̄ rī. ");
INSERT INTO mibNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Chi tēe tu cáhán sɨquɨ̄ yō, íin de jíín yó. ");
INSERT INTO mibNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Te na‑ni ñayuu núu jeē sɨquɨ́ ruhū cuāha i vēsú ɨɨn ñajin ndute coho ró, sɨquɨ̄ jeē cácandíje ró ruhū, ndaā ndije cúu jeē nihín i tahū i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Te núu ɨɨn sūchi lúlí yáha cándíje i ruhū, te núu quɨ̄vɨ i cuēchi sáha na‑ni ñayuu, te vāha ga núu ni conuhnī ɨɨn yōso cáhnu sucūn ñayuu ún, te quēe i chīji ndute mar nuú. ");
INSERT INTO mibNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Te núu ndaha ró sáha jeē quɨ́vɨ ró cuéchi, vāha ga cahnde rō na quíhín, návāha tuá sáha ró cuéchi. Chi vāha ga jeē cóndee ɨɨn‑ni ndaha ró te quɨ̄vɨ ró núū cotecu rō nɨɨ́ cáni, vēsú jeē cóndee ndɨndúú ndaha ró te quɨ̄vɨ ró infierno, nuū cayú ñuhūn jeē ma ndahvá cuɨtɨ. ");
INSERT INTO mibNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Te yūcuán chi tu cájihī tɨndacú, te tu ndáhvá cuɨtɨ ñuhūn. ");
INSERT INTO mibNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Te núu jehē rō sáha jeē quɨ́vɨ ró cuéchi, suni vāha ga cahnde rō na quíhín, návāha tuá sáha ró cuéchi. Chi vāha ga jeē cóo cúhndu ró te quɨ̄vɨ ró núū cotecu rō nɨɨ́ cáni, vēsú jeē cóndee ndɨndúú jehē rō te quɨ̄vɨ ró infierno, nuū cayú ñuhūn jeē ma ndahvá cuɨtɨ. ");
INSERT INTO mibNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Te yūcuán chi tu cájihī tɨndacú, te tu ndáhvá cuɨtɨ ñuhūn. ");
INSERT INTO mibNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te núu tɨnūu ró sáha jeē quɨ́vɨ ró cuéchi, vāha ga tava ró na quíhín, návāha tuá sáha ró cuéchi. Chi vāha ga jeē quɨ́vɨ ró ñuu nuū ndácu Yaā Dios jniñu jíín ɨɨn na tɨnūu ró, vēsú jeē cóndee ndɨndúú tɨnūu ró te quɨ̄vɨ ró infierno. ");
INSERT INTO mibNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Te yūcuán chi tu cájihī tɨndacú, te tu ndáhvá cuɨtɨ ñuhūn. ");
INSERT INTO mibNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Chi nájnūhun quénda vāha oro sáha ñuhūn, súcuan quénda vāha ñayuu sáha jnūndóho. Te tāca cúñu jeē socó ñayuu nuū yā, cúhuhvuā sáha ñɨɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Vāha íyó ñɨ́ɨ̄, te núu ñɨɨ̄ ún na náā jeē uhvuá, ¿te ndese nduu uhvuā tucu sáha ró? Núu súcuan te cuu ró ñáyuu váha, nájnūhun íyó váha ñɨɨ̄. Te na cóyūcu váha ró jíín jnáhan ró. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Te ni quenda ya ñuu Capernaum, te ni jinū yā región Judea, ɨnga lado yūte Jordán, ichi nuū cáne niāndii. Te yūcuan ní cutútú tucu ñayuu nuū yā, te ni steén tucu ya jnūhun nuū i, nájnūhun sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Yūcuán na te jecu tēe grupo fariseo ni quecoo de nuū yā, chi cácuni de coto ndee de ya núu ndese cahān yā. Te ni cacajnūhún de ya núu íyó ley jeē cuu ndusɨ́ɨn ɨɨn tēe jíín ñasɨhɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Te ni cahān yā jiín de: ¿Na jniñu ni ndacu Moisés nuū rō nde jenahán? ");
INSERT INTO mibNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Te ni cacahān de: Moisés ni jēhe de jnūhun jeē cúvāha ɨɨn acta jeē ndusɨ́ɨn de jíín ña, te ndōo ña, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Te ni cahān Jesús jiín de: Sɨquɨ̄ jeē níhni ni rō jijnáhan ró, jeē yúcuan ní ndacu de jniñu yáha núū rō. ");
INSERT INTO mibNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Te nde xīhna ñúhún, ná ni sáha Yaā Dios ndɨhɨ, chi tēe jíín ñahan ni sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jeē yúcuan cúu jeē stóo tēe tátá de náná de, te quijnáhan de jíín ñasɨhɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Te ɨɨn na cuu ndɨndúú de, áchí Yaā Dios. Núu súcuan te tuá cúu uū jnáhan de, chi ɨɨn na cúu. ");
INSERT INTO mibNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jeē yúcuan tu íyó váha jeē stóo jnáhan, chi jeē ni squíjnáhan Yaā Dios cúu, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Te tēe cáscuáha ún nuū ni quɨ́vɨcoo de vehe, te ni cacajnūhún tucu de ya sɨquɨ̄ jnúhun ún. ");
INSERT INTO mibNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Te ni cahān yā jiín de: Núu ndé tée stóo de ñasɨhɨ́ de te condeca de ɨnga ñahan, núu súcuan te cásɨ́quɨ́ ndéē de ñasɨhɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Te núu ɨɨn ñahan stóo ña yɨɨ ña te condeca ña ɨnga tēe, suni cásɨ́quɨ́ ndéē ña de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yūcuán na te ni quecoo ñayuu jiín súchi lúlí, jéē na sóó yá ndaha ya xinī i. Te tēe cáscuáha jíín yá, ni cacahān de nuū ñáyuu vējicoo jíín i. ");
INSERT INTO mibNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Te ni jito Jesús, te ni quɨtɨ̄ ni yā, te ni cahān yā jiín de: Cuāha jnūhun na quíjicoo sūchi lúlí jíñā nuū rī, te ma cásɨ rō jeē quíjicoo i. Chi ñayuu jeē ndió cóo ni i cani ni i nájnūhun sūchi yáha, suu i quɨ́vɨ ndaha Yaā andɨvɨ́ jeē ndacu ya jniñu nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Te jendaá cahán rī jiín ró, núu ɨɨn ñayuu tú cuatáhú i jeē ndácu Yaā Dios jniñu nuū i, nájnūhun jétáhú ɨɨn sūchi lúlí, ma quɨ́vɨ cuɨtɨ i ndaha ya, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Te ni nundee ya i, te ni soó yá ndaha ya xinī i, te ni jicān tahú yā jehē i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yūcuán na te ni quihin tucu ya ichi cuahān yā. Te jínu ɨɨn tēe ni quee de, te ni jecuɨñɨ̄ yɨtɨ́ de nuū yā, ni cajnūhún de ya: Tēe vāha cúu ní Maestro. Te cachi ní, ¿na jniñu váha sáha ná te nihīn tahú na cotecu na nɨ́ɨ́ cáni andɨvɨ́? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Te ni cahān yā jiín de: ¿Naun cáhán rō jeē tée vāha cúu ri? Tú ni ɨɨn tēe vāha íyó, chi máá ɨɨn‑ni Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Je jíní rō tācá jniñu ní ndacu Yaā Dios: Ma cosɨ́quɨ́ ndéē jnáhan ró. Ma cáhni rō ndɨ̄yɨ. Ma sacuíhná ró. Ma sajnúhún ró. Ma stahú ró jnáhan ró. Cuatáhú ró nuū tatá rō nuū naná rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Te ni cahān tēe un jíín yá: Tācá jniñu yáha je ni squícu ná ndé ná lulí ná, Maestro, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yūcuán na te ndáhú jíto ya nuū de jeē cúsɨɨ̄ ni yā jiín de. Te ni cahān yā: Ɨɨn na jniñu cúmanī sáha ró núu súcuan. Cuáhán te xīco ró ndɨhɨ jeē névāha ró, te cuāha ró núū ñáyuu ndahú. Te nde andɨvɨ́ cuāha ya jeē váha ndasɨ́ núū rō. Yūcuán na te quiji ró condiquīn rō ruhū, te cuāha ró jnúhun ndoho ró jnúndóho jeē sɨquɨ́ rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Te ná ni jini sōho de jnūhun yáha, te ni jnahuhū ni de, te cúcuíhyá ni de cuahān de, chi cúcá ndasɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yūcuán na te Jesús ni ndacoto ya nɨɨ́ xiin ya, te ni cahān yā jiín tée cáscuáha jíín yá: Tēe cúcá chi yōhyo yɨɨ́ quɨ́vɨcoo de ndaha Yaā Dios jeē ndacu ya jniñu nuū de, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Te tēe cáscuáha jíín yá, yōhyo ni canaa ni de jeē ní cajini de jnūhun ni cahān yā. Te ni cahān tucu ya jiín de: Séhē, ñayuu ténuū xūhún, yōhyo yɨɨ́ quɨ́vɨcoo i ndaha Yaā Dios jeē ndacu ya jniñu nuū i. ");
INSERT INTO mibNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yachī gā yāha ɨɨn camello yaū yutɨ́cuɨ, vēsú jeē quɨ́vɨ ɨɨn ñayuu cucá ndaha Yaā Dios jeē ndacu ya jniñu nuū i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Te víhyá gā ni canaa ni de cájini de, te ni cacajnūhun jnáhan de: ¿Ndé ñáyuu cúu jeē cácu núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Te ni ndacoto ya nuū de, te ni cahān yā: Ñayuu chi ma cúu squɨ́vɨ i máá i ndaha Yaā Dios, te máá yá chi cuu sáha ya, chi ndɨhɨ‑ni jniñu cuu sáha ya, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yūcuán na te ni cahān Pedro jiín yá: Sāña jíjnáhan ná, ní castóo ná ndɨhɨ jeē cánevāha ná, te cándiquīn na níhín, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Te ni cahān Jesús: Jendaá cahán rī jiín ró jijnáhan ró, núu na‑ni ñayuu stóo i vehe, chí ñani, chí cuáha, chí tátá, chí náná, chí ñasɨhɨ́, chí séhe, chí ñuhun, jeē sɨquɨ́ ruhū jiín sɨ́quɨ̄ jeē scáca i jnūhun jeē jnáma ri ñayuu, ");
INSERT INTO mibNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","núu súcuan te nanihīn i ɨɨn ciento gā jeē súcuan vijna, cúu vehe, cúu ñani, cúu cuāha, cúu náná, cúu sēhe, cúu ñuhun, te nde jiín jéē cóto xeēn ñayuu i. Te nde ɨnga vida quiji te cotecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Te cuehē ñayuu jeē vijna cácujéhnu, nduu i ñayuu núu ga. Te ñayuu jeē núu ga vijna, chi ndujéhnu i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Te cáñuhun de ichi jeē cáa cuahān ñuu Jerusalén. Te Jesús yósnúu yá nuū tée cáscuáha ún. Te cánaa ni de ni cajini sōho de jnūhun ni cahān yā. Te cáyūhú de cuángoo de jíín yá. Yūcuán na te ni cana sɨ́ɨn tucu ya ndɨhúxí uū tēe cáscuáha, te ni quejéé yá cástūhún tucu ya nuū de tāca jéē quíji sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Achí yá: Cuni sōho ró, chi je cuángoo yó ñuu Jerusalén vijna, te yūcuán nastúu ñayuu ruhū, Yaā ní nduu tēe, nuū sutú cácujéhnu jíín núū tée cástéén tutu ley. Te ndonda de sɨquɨ̄ rī jeē cúū rī, te squɨ́vɨ de ruhū nuū tée nación Roma jeē cáyūcú Jerusalén cándacu jniñu. ");
INSERT INTO mibNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Te tāca tée un sácatā de nuū rī, te cani de ruhū, te tesɨ̄hɨ́ de nuū rī, te sáá te cahni de ruhū. Te nuū uní quɨvɨ̄ te natecu rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yūcuán na te Jacobo jiín Juan, ndɨndúú séhe Zebedeo, ni quecoo de nuū Jesús, te ni cacahān de: Maestro, cácuni na jéē sáha ní ɨɨn jeē cacán na núū ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Te ni cahān yā jiín de: ¿Ndese cácuni rō jeē sáha ri jiín ró? achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Te ni cacahān de: Cuāha ní jnúhun jeē cónēne ná xiin ní quɨ́vɨ ndujéhnu ní, ɨɨn ná lado váha ní, te ɨnga ná lado jecó ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yūcuán na te ni cahān Jesús jiín de: Tu cájini rō na vé cúu jeē cájicān rō. ¿A cuu ndoho ró jnúndóho nájnūhun jeē quíji sɨquɨ̄ rī? ¿Te á canda ró ndoho xeēn rō nájnūhun ndoho ri? achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Te ni cacahān de: Cuu sáha ná. Te ni cahān yā jiín de: Jendaá jeē ndoho ró jnúndóho nájnūhun jeē quíji sɨquɨ̄ rī, te ndoho xeēn rō nájnūhun ndoho ri. ");
INSERT INTO mibNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Te jeē cónēne ró lado váha ri jiín lado jecó rí, nasūu rúhū cúu jeē cuáha jnūhun. Chi je íyó túhva cuu tāca tée jeē ní nacāji Tátá rī, te tēe un níhīn, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Te uxī gā tēe cáscuáha un, ní cajini de jnūhun yáha, te ni caquɨtɨ̄ ni de nuū Jacobo jiín Juan. ");
INSERT INTO mibNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Te Jesús ni cana ya de, te ni cahān yā jiín de: Cájini rō ndese cásáha tēe cácujéhnu nuū ñáyuu tācá nación. Chi cándacu nīhin de jniñu nuū i, te máá de cáchí ndese coo. ");
INSERT INTO mibNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Te máá ró jijnáhan ró, chi ma sáha ró súcuan. Chi núu ndé ɨɨn ró cúní cujéhnu, sa suhva cuajníñu ró núū jnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Te núu ndé ɨɨn ró cúní cuu nuū, sa suhva sáha ró máá ró mozo nuū tāca jnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Chi suni súcuan sáha ruhū, Yaā ní nduu tēe, chi nasūu jéē véji ri jeē cuajníñu ñayuu nuū rī, chi sa suhva vēji ri jeē cuajníñu ri nuū ñáyuu. Te cuāha ri maá rí cuu rī návāha jnama ri cuehē ñayuu, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yūcuán na te ni jinū yā ñuu Jericó jiín tée cáscuáha jíín yá. Te sáá te ni quenda ya yūcuan jíín de jíín ñáyuu cuehē ndasɨ́. Te Bartimeo tēe cuáá, sēhe Timeo, néne de yuhíchi, jícán de caridad. ");
INSERT INTO mibNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Te ni jini de jnūhun jeē Jesús ñuu Nazaret vēji ya. Te ni quejéé de cána jee de: Jesús Sēhe yucūn David, cundáhú ni ni sáña, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Te cuehē ñayuu ni cacahān i nuū de jeē na cásɨ de yuhu de. Te máá de víhyá gā ni cana jee de: Máá ní jeē cúu ní Séhe yucūn David, cundáhú ni ni sáña víī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yūcuán na te ni jecuɨñɨ̄ Jesús, te ni cahān yā: Cana de na quíji de. Te ni cacana i tēe cuáá un: Ndeyɨ́ coo ni rō. Ndocuɨñɨ̄, na quíhín yō, chi cána ya rohó, áchí i jíín de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yūcuán na te ni scáne de tɨcāchí de, te yachī ni ndocuɨñɨ̄ de, te ni jinū de nuū Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Te ni cahān yā jiín de: ¿Na vé cuní rō jeē sáha ri jiín ró? Te máá de ni cahān de: Maestro, jeē na ndúndijin tɨnūu ná cuní na, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Te ni cahān Jesús jiín de: Cuáhán núu súcuan. Ni candíje ró jeē cuu nasávāha ri rohó, te jeē yúcuan ní nduvāha ró, áchí yá. Te ni ndundijin‑ni tɨnūú de, te ni ndiquīn de Jesús cuahān de jíín yá ichi ún. ");
INSERT INTO mibNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Te ni cuyajni ya ñuu Jerusalén, vēji ya ñuu Betfagé jiín ñuu Betania, jeē íne jehē yucu Olivos. Te ni tají yá uū tēe cáscuáha jíín yá jeē quíngoo de. ");
INSERT INTO mibNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Te áchí yá jiín de: Cuángoo ñuu lulí íne ichi núú. Te núu ni quɨ̄vɨ‑ni ró yúcuan, te nihīn rō ɨɨn burro núhní tɨ̄, jeē ní ɨɨn tēe ná tu coso de tɨ. Te ndají ró tɨ̄, quijicoo ró jíín tɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te núu ndé ɨɨn cajnūhún naun cándají ró tɨ̄, te cachi rō: Máá Jítoho yō jíni ñúhún yá tɨ̄, te yachī natají yá tɨ̄ ndiji tɨ, achi rō. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Te cuangoo de, te ni canihīn de burro un núhní tɨ̄ yehyɨ́ núū quéhe nuū náquijnáhan ichi. Te ni candají de tɨ. ");
INSERT INTO mibNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Te sava ñayuu cáhīin yūcuan ní cacahān jiín de: ¿Na vé cúu jeē casáha ró jeē cándají ró burro jiñā? achí i. ");
INSERT INTO mibNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yūcuán na te ni cacahān de nájnūhun ni cachi Jesús. Te ni casiáá i tɨ vējicoo de jíín tɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Te ni ndecoo de jíín tɨ́ nuū Jesús, te ni casoó de sahma de sɨquɨ̄ tɨ̄, te ni jecosō yā tɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Te cuehē ñayuu ni cascáá i sahma i ini ichi. Te sava ga i ni cajehnde i ndaha ñúú, te ni cachucun i ini ichi ún. ");
INSERT INTO mibNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Te ñayuu cuangoo ichi núú jíín ñáyuu cuangoo ichi yátá, cácana jee i: Yōhyo cújéhnu ya. Yōhyo vāha Yaā cúu Yaā jeē véji jíín jniñu máá Jítoho yō Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Te yōhyo luu coo, chi je yajni ndacu ya jniñu nájnūhun ni ndacu jíí yō rey David. Te yōhyo cújéhnu máá Yaā Dios. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Te ni quɨ̄vɨ Jesús ñuu Jerusalén, jíín ini templo cáhnu. Te ni jito ya nuū tācá ndajníñu yúcu nɨ́ɨ́ yúcuan. Te ni quenda ya cuahān yā ñuu Betania jiín ndɨhúxí uū de, chi je ni ini. ");
INSERT INTO mibNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Te ɨnga quɨvɨ̄ ún, nuū ní quenda ya ñuu Betania cuahān yā jiín de, te jíí yā sōco. ");
INSERT INTO mibNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Te nde jicá ni jito ya ɨɨn nundēhe higo jeē íin ndaha. Te ni jecondēhe yá núu sanaa te nihīn yā ndehē caji yā. Te tú na vé ni níhín yā, chi máá ndaha‑ni íin. Chi nasūu tiempo ndehē cúu. ");
INSERT INTO mibNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yūcuán na te ni cahān yā nuū yujnu ún: Tuá na ndehē cuun cuɨtɨ xinī rō jeē cáji ñayuu, achí yá. Te tēe cáscuáha jíín yá ni cajini de jeē súcuan ni cahān yā. ");
INSERT INTO mibNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Te ni najinū yā jiín de ñuu Jerusalén. Te ni quɨ̄vɨ ya ini templo cáhnu, te ni quenehen ya ñayuu cájeen quɨtɨ te cánaxīco núū ñáyuu jeē socō i. Te ni scotúú ndeyɨ ya tāca mesa tēe cástáyɨ xūhún, jíín silla tēe cáxīcó paloma. ");
INSERT INTO mibNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Te tu ní jéhe ya jnūhun jeē yáha ñayuu ini templo jiín ndajníñu ndíso i. ");
INSERT INTO mibNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Te ni steén yā jnūhun nuū i, áchí yá: Yósó núū tútu iī jeē cahán Yaā Dios: Vehe ri chi vehe nuū cájicān tahú ñayuu tācá nación cúu, áchí yá. Te máá ró jijnáhan ró chi nájnūhun yaū cava ñacuīhna ní canasáha ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Te tēe cástéén tutu ley Yaā Dios jiín sútū cácujéhnu, ni cajini de jnūhun yáha, te ni quejéé de cánducú de modo ndese cahni de ya. Chi cáyūhú de jeē ndujéhnu ga maá yá vēsú maá de, chi tāca ñáyuu yōhyo cácusɨɨ̄ ni i cájini i jnūhun stéén yā. ");
INSERT INTO mibNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Te jeē cuácuaa, te ni quenda ya ñuu Jerusalén cuahān yā. ");
INSERT INTO mibNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Te jenéhen ɨnga quɨvɨ̄ ni nayāha ya jiín de cuahān yā. Te ni cajito de jeē núndēhe higo un je ni ichī nde yoho. ");
INSERT INTO mibNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yūcuán na te ni nucūhun ni Pedro, te ni cahān de jíín yá: Maestro, cundēhe ní nundēhe higo jeē ni cáhān ni núū, te vijna je ni ichī caján, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Te ni cahān Jesús jiín de: Candíje ró jéē sáha Yaā Dios jeē jicán rō. ");
INSERT INTO mibNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Chi jendaá cahán rī jiín ró, núu ndé ñáyuu cahān i jeē cújiyo yucu yáha quihīn nde nuū mar, te núu tú nacani sɨquɨ́ ni i, chi sa suhva candíje i jeē cóo nájnūhun ni cahān i, yūcuán na te cundaā jeē ni jícān i. ");
INSERT INTO mibNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jeē yúcuan cáhán rī jiín ró, tāca jéē cacán tahú rō, te núu candíje ró jéē nihín rō, te nihīn rō. ");
INSERT INTO mibNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Te jeē cájicān tahú rō, te cone cáhnu ni rō nuū ñáyuu casáha cuēchi sɨquɨ̄ rō, návāha máá Tátá rō jeē ndeé yá andɨvɨ́, suni cone cáhnu ni yā nuū cuéchi ró. ");
INSERT INTO mibNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Chi núu tú cone cáhnu ni rō nuū jnáhan ró, te suni máá Tátá rō jeē ndeé yá andɨvɨ́, ma cóne cáhnu ni yā nuū cuéchi ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yūcuán na te ni najinū tucu ya ñuu Jerusalén. Te jíca cuu ya ini templo cáhnu. Te sutū cácujéhnu jíín tée cástéén tutu ley Yaā Dios jiín tée jéhnu cándacu jniñu, ni quecoo de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Te ni cacajnūhún de ya: ¿Ndé ní nihīn jníñu ró jéē sáha ró jniñu yáha? ¿Te ndé ɨɨn ni tee jniñu sɨquɨ̄ rō jeē sáha ró súcuan? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Te ni cahān Jesús: Suni ruhū, cajnūhun rí rohó ɨɨn jnūhun jíjnáhan ró. Te núu cuu stíó cuɨ́ñɨ́ rō, yūcuán na te cachi rī nuū rō ndé ní nihīn jníñu ri jeē sáha ri jniñu yáha. ");
INSERT INTO mibNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ndé ɨɨn ni tee jniñu sɨquɨ̄ Juan jeē ni scuándute de? ¿A Yaā Dios chí táca tée? Cachi nuū rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yūcuán na te ni candajnūhun máá de: Núu cahān yō jeē Yaā Dios ni tee ya jniñu un sɨ́quɨ̄ Juan, te cahān de jíín yó: Núu súcuan ¿te najehē tu ní cácandíje ró de? ");
INSERT INTO mibNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te núu cahān yō jeē ñáyuu ni catee jniñu un sɨ́quɨ̄ de, te quɨtɨ̄ ni ñayuu nuū yō, achí de cácahān maá de. Chi cáyūhú de jeē quɨtɨ̄ ni ñayuu, chi ndɨvii i cácandíje i jeē tée ni nacani jnūhun Yaā Dios ni cuu ndije Juan. ");
INSERT INTO mibNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jeē yúcuan ní cacahān de jíín yá: Tu cájini rī, achí de. Yūcuán na te ni cahān Jesús: Ni ruhū, suni ma cáchi rī nuū rō ndé ɨɨn ni tee jniñu sɨquɨ̄ rī sáha ri jniñu yáha, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Te ni quejéé yá cahán yā jnūhun yátá jiín de jíjnáhan de: Ɨɨn tēe ni nachuhun de cuehē uva, te ni jesɨ de corral, te ni sáha de ɨɨn nuū cúhun ndehē un táxīn. Te ni sáha de ɨɨn vehe súcún návāha cuu coto de nɨ́ɨ́ cáhnu. ’Te ni stóo de nuū sava tēe sájniñu nuū, te cuu sava de ndehē jiín. Te ni tee de ichi cuahān jicá de. ");
INSERT INTO mibNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Te máá tiempo ndutútú uva, te ni tají de ɨɨn mozo de cuanuquīhin sava uva nuū tée cásájniñu ún. ");
INSERT INTO mibNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Te tēe un ní cajnɨɨ de mozo un, te ni cacani de i, te ni canatají de i cuanuhun i súcuan‑ni. ");
INSERT INTO mibNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yūcuán na te tēe chíí uva un ní tají tucu de ɨnga mozo cuahān. Te tēe cásájniñu un ní cajēhe de yuū xinī mozo un, te ni castújí de, te ni cacahān ndevāha de nuū. ");
INSERT INTO mibNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Te tēe chíí uva ni tají tucu de ɨnga mozo cuahān. Te ni cajehni de i. Te suni súcuan ni tají de cuehē gā mozo cuahān, te sava i ni cacani de, te sava i ni cajehni de. ");
INSERT INTO mibNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Te tēe chíí uva, íyó ɨɨn sēhe de jeē maní ndasɨ́ de jíín. Te jeē sándɨ̄hɨ́ na ni tají de sēhe de un cuáhān nuū tée cásájniñu. Te jéni ni de: Tēe ún chi cuatáhú de jíjnáhan de nuū séhe ri. ");
INSERT INTO mibNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Te tēe cásájniñu un ní cacahān maá: Tēe chíí táhū cúu jeē yáha. Na cáhni yō de, te ndōo tahū de cuu máá yó, achí. ");
INSERT INTO mibNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Te ni cajnɨɨ de i, ni cajehni de i, te ni cascáne de i ɨnga lado. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yūcuán na te ni cajnūhun yá de: Núu súcuan ¿te ndese sáha tēe chíí uva un? Ndiji de te cahni de tēe cásájniñu ún, te cuāha de ñuhun cáá uva un núū ɨnga sava tēe sájniñu nuū. ");
INSERT INTO mibNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Te á ná tu cahu ró jnúhun yáha jéē yosó núū tútu iī, jeē ruhū cúu nájnūhun ɨɨn yuū? Chi áchí tutu: Yuū jeē ní casquéhichī tēe cájeni vehe, yuū yáha nduu jeē quítuu vehe. ");
INSERT INTO mibNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Máá Jítoho yō Yaā Dios ni sáha ya súcuan, te cánaa ni yō jíto yó jniñu yáha. Achí tutu, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yūcuán na te ni canducú de modo jnɨɨ de ya. Chi ni cajecūhun ni de jeē sɨquɨ̄ maá de cúu jnūhun yátá ní cahān yā sɨquɨ̄ tée cásájniñu nuū uva jiín tée cájeni vehe. Te sɨquɨ̄ jeē cáyūhú de jeē quɨtɨ̄ ni ñayuu, te ni castóo de ya te cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yūcuán na te ni catají de sava tēe grupo fariseo jiín tée grupo Herodes cuangoo de nuū yā, ndúcú de ndese sáha de návāha cahān yā ɨɨn jnūhun jeē nihín de cuēchi sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Te ni quecoo de, te ni cacahān de jíín yá: Maestro, cájini na jéē tée cáhán ndaā cúu ní, te tu yúhú ní jeē cahán ni ɨɨn ñayuu sɨquɨ̄ ní. Chi tu sáha ní cuenta ndese cúu ɨɨn ɨɨn i, chi ɨnuú‑ni sáha ní jíín i. Te stéén ndaā ní ndese squícu ñayuu nuū Yaā Dios. ¿Te á íyó váha jeē chúnaa yō renta nuū rey nación Roma jeē jnɨ́ɨ nación yō, chí tuú? ¿A chúnaa yō, chí má chúnaa yō? Achí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Te máá yá jiní yā jeē stahú‑ni de, te ni cahān yā jiín de: ¿Najehē cájito ndee rō ruhū? Cuāha ɨɨn xūhún na cóto ri, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Te ni cajēhe de xūhún. Te ni jito ya, te ni cajnūhun yá de: ¿Ndé ɨɨn nuū cúu jeē ndeé nuū xúhun yáha, te ndé sɨ́hvɨ́ cúu jeē ndeé yāhá? Te ni cacahān de jíín yá: Nuū jiín sɨ́hvɨ́ rey un cúu, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yūcuán na te ni cahān yā jiín de: Núu súcuan te nacuāha ró núū rey un jéē yɨ́hɨ cuenta nuū de, te nacuāha ró núū Yaā Dios tāca jéē yɨ́hɨ cuenta nuū maá yá, achí yá. Te ni canaa ni de ni cajini de jeē ndichí ní cahān yā. ");
INSERT INTO mibNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yūcuán na te jecu tēe grupo saduceo ni quecoo de nuū yā. Te tēe un cácahān jeē tu nátecu cuɨtɨ ndɨ̄yɨ. Te ni cacahān de jíín yá sɨquɨ̄ ɨɨn jnūhun, áchí de: ");
INSERT INTO mibNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Maestro, Moisés ni tee de nuū tútu jeē cánevāha yó: Núu ɨɨn tēe cuu de, te ndōo ñasɨhɨ́ de, te núu tu ní íyo sēhe de jíín ña, núu súcuan te cánuú jeē ñani de naquihin ñasɨhɨ́ de, te sēhe de jeē cácu jíín ña nucuɨñɨ̄ i nuū ndɨ́yɨ ñani de, áchí tutu. ");
INSERT INTO mibNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Núu súcuan te ni īyo uxā ñani. Te tēe núú ní quijnáhan de jíín ñahan. Te ni jihī de, te tú sēhe de ní íyo. ");
INSERT INTO mibNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Te tēe uū ni naquihin de ña, te suni ni jihī de, te tú sēhe de ní íyo. Te suni súcuan tēe unī. ");
INSERT INTO mibNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Te ndɨhúxá de ni condeca de ña, te ni ɨɨn de tú sēhe de ní íyo. Te jeē sándɨ̄hɨ́ te suni ni jihī ñahan ún. ");
INSERT INTO mibNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Núu súcuan te núu na nátecu de jíjnáhan de quɨvɨ̄ nátecu ndɨ̄yɨ, ¿te ndé ɨɨn de cuu ña ñasɨhɨ́ de? Chi ndɨhúxá de ni condeca de ña. Achí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yūcuán na te ni cahān yā jiín de: Yōhyo cástɨ́vɨ ró jnūhun sɨquɨ̄ jeē tu cájecūhun ni rō jeē cahán tutu iī, ni tu cájini rō jeē iyó poder Yaā Dios jeē nastécu yā ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chi quɨvɨ̄ nátecu ndɨ̄yɨ, te tuá na jnūhun quijnáhan tēe jíín ñahan coo. Chi coo i nájnūhun ndajéhé Yaā Dios andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Te sɨquɨ̄ jeē nátecu ndɨ̄yɨ, ¿á tu ní cácahu ró tutu ní tee Moisés, ndese ni cahān Yaā Dios jiín de mēhñu yúcū jeē cayú yáñuhūn? Máá rí cúu Yaā Dios Abraham jiín Isaac jiín Jacob, achí yá jiín Moisés. ");
INSERT INTO mibNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Chi vēsú je ni cajihī de, te cátecu de nuū iyó máá yá, chi cúu ya Yaā sáha jeē técu ñayuu nɨɨ́ cáni. Yōhyo cástɨ́vɨ ró jnūhun núu súcuan. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Te ni quee ɨɨn tēe stéén tutu ley Yaā Dios, te ni jini de jeē castíchí jnáhan tēe un jíín Jesús. Te ni jini de jeē váha ni nastíó cuɨ́ñɨ́ yā jnūhun. Te ni cajnūhún de ya: ¿Ndé ɨɨn cúu jnūhun ndácu jniñu cánuú ndasɨ́ gá nuū tāca gá jniñu ni ndacu ya jenahán? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Te ni cahān Jesús jiín de: Yāha cúu jniñu jeē cánuú ndasɨ́ gá nuū tāca gá. Achí tutu: Ñayuu Israel, cuni nahín ró. Máá Jítoho yō Yaā Dios, maá ɨɨn‑ni ya iyó. ");
INSERT INTO mibNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Núu súcuan te coo manī ndasɨ́ ró jiín máá Jítoho rō Yaā Dios, nde jnáā ndasɨ́ ró sáha ró ndɨhɨ jeē cúsɨɨ̄ ni yā, nde jiín ini jiín ánuá rō, jiín nɨ́ɨ́ jeē níjnūní rō, jiín nɨ́ɨ́ fuerza rō. Yāha cúu jniñu ndácu ya jeē cánuú ndasɨ́ gá. ");
INSERT INTO mibNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Te jniñu uū jeē ní ndacu ya, suni súcuan cáhán: Cundáhú ni rō jnáhan ró nájnūhun cúndáhú ni rō maá ró. Tuá ɨnga jnūhun ndácu jniñu cánuú gá iyó, chi suu máá jéē yáha‑ni. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yūcuán na te ni cahān tēe stéén tutu ley jiín yá: Vāha ni cahān ní, Maestro. Chi ndaā chi íyó ɨɨn‑ni Yaā Dios, te tuá na ɨnga yā iyó. ");
INSERT INTO mibNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Te cánuú jéē coo manī ndasɨ́ yó jiín yá nde jiín ini jiín ánuá yō, jiín nɨ́ɨ́ jeē níjnūní yō, jiín nɨ́ɨ́ fuerza yō, te cundáhú ni yō jnáhan yó nájnūhun cúndáhú ni yō maá yó. Te cánuú ndasɨ́ gá jeē yáha vēsú jeē cáhmu yó quɨtɨ jíín táca gá jeē socó yō nuū yā. Achí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yūcuán na te ni jini Jesús jeē váha ni stió cuɨ́ñɨ́ de, te ni cahān yā jiín de: Je yajni cuu quɨ̄vɨ ró ndaha Yaā Dios jeē ndacu ya jniñu nuū rō, achí yá. Yūcuán na te ni ɨɨn ga de, tuá ni chúndeyɨ́ ni de cajnūhún de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Te stéén Jesús jnūhun ini templo, te ni cahān yā: ¿Ndese cúu jeē cácahān tēe cástéén tutu ley Yaā Dios jeē Cristo cúu sēhe yucūn David? ");
INSERT INTO mibNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Chi máá David suhva ni cahān de jnūhun ya ni sáha Espíritu Santo nde jenahán: Máá Jítoho yō Yaā Dios ni cahān yā jiín Jítoho rī, Yaā quiji: Cucōo ró lado váha ri nuū cujéhnu ró, te na sáha ri jeē quende rō poder tāca jéē cájito uhū rohó. Achí Yaā Dios. Achí David. ");
INSERT INTO mibNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Te núu sēhe yucūn David cúu Cristo, ¿te ndese cúu jeē ni cáhān de jeē Jítoho de cúu ya? áchí yá. Te ñayuu cuehē, cánujnahan ni i cájini nahín i tāca jnúhun cáhán yā. ");
INSERT INTO mibNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Te stéén yā jnūhun, te ni cahān yā jiín i: Coto má candíje ró táca tée cástéén tutu ley. Chi cácusɨɨ̄ ni de cáñuhun de sahma cáni jeē steén jeē cujéhnu de, cájica cuu de jíín. Te cánujnahan ni de jeē cahán yɨñúhún ñáyuu jiín de ini calle. ");
INSERT INTO mibNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Te cánujnahan ni de cucōo de nuū silla yɨñúhún gá ini vehe iī sinagoga, jiín silla yɨñúhún gá nuū víco cáyeji ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Te cáquende de vehe ñahan ní caquendōo ndáhú. Te nahán cájicān tahú de návāha cani ni ñayuu jeē tú na cuēchi de. Tēe yáha jíjnáhan de chi xeēn gā ndoho de castigo. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Te ɨɨn quɨvɨ̄ néne Jesús ini templo ichi núú tāca yéjnū nuū cásocō i xūhún. Te jíto ya ndese cáchuhun ñayuu xūhún ini yejnū ún. Te cuehē ñayuu cucá ní cachuhun i cuehē xūhún. ");
INSERT INTO mibNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Te ni quee ɨɨn ñahan viuda jeē ndóho ndáhú. Te ni chuhun ña uū centavo lulí ini yejnū ún. ");
INSERT INTO mibNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yūcuán na te ni cana ya tēe cáscuáha jíín yá, te ni cahān yā jiín de: Jendaá cahán rī jiín ró jeē cuehē gā cúu jeē ni sócō ñahan viuda ndahú yáha, vēsú jeē ní casocō tāca ñáyuu cucá. ");
INSERT INTO mibNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chi tācá i ni casocō i jeē ni ndóo sɨquɨ̄ xúhun cuéhē i. Te ñahan yáha, vēsú ndahú ndóho ña, te ni chuhun ndɨhɨ ña jeē cótecu ña. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Te ni quenda Jesús ini templo cáhnu, te ɨɨn tēe scuáha jíín yá ni cahān de: Maestro, condēhe ní ná luu jíto tācá vehe yáha jéē cúu templo, jiín táca yúū jeē ní cuvāha, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Te ni cahān yā jiín de: Tācá vehe náhnu yāha jéē cájito ró, chi ma cóso jnáhan ga ni ɨɨn yuū, chi ndɨhɨ jnanū. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Te ni jehēn yā jiín de yucu Olivos jeē íne ichi núú templo cáhnu. Te ni cucōo ya yūcuán. Te Pedro jiín Jacobo jiín Juan jiín Andrés ni cacajnūhun sɨ́ɨn de ya: ");
INSERT INTO mibNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Castūhun ní nuū ná, ¿ndé quɨ́vɨ̄ coo tāca jéē ní cachi ní jéē coo? ¿Te na seña coo núu cuacuyajni squícu tāca jéē ni cáhān ní? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Te ni cahān yā jiín de: Coto ró jéē ma stahú ni ɨɨn de róhó. ");
INSERT INTO mibNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Chi quijicoo cuehē tēe jeē stahú jíín sɨ́hvɨ́ rí. Máá rí cúu Cristo, achi de. Te súcuan stáhú de cuehē ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Te nihīn rō jnūhun jeē tāca lado iyó guerra, chí je yajni coo guerra. Te ma yūhu ró, chi cánuú coo súcuan. Te ni ná tu jinū quɨvɨ̄ ndɨhɨ ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chi ndonda nación sɨquɨ̄ ɨnga nación, te ndonda ñuu sɨquɨ̄ ɨnga ñuu jeē cuajnáhan. Te cháha chúcuan jnāa, te coo jnamā, te ndonda ñayuu sɨquɨ̄ jnáhan i. Te tāca jéē yáha cácuu jnūndóho quejéé xíhna ñúhún gá. ");
INSERT INTO mibNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Te condito ró máá ró, chi nastúu i róhó núū tāca tóhō, te ini tācá vehe iī sinagoga cani i róhó. Te quindeca i sava ró núū tācá gobernador jiín núū tāca rey, te cahān i cuēchi sɨquɨ̄ rō sɨquɨ̄ jeē cácandíje ró rúhū. Te súcuan te cuu nacani ró jnúhun ri nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Te jíni ñúhún jéē xíhna gā cuitē núu jnūhun nuū tācá nación ndese jnáma ri i, te sáá te ndɨhɨ quɨvɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Te núu ni cajnɨɨ de róhó cuángoo de jíín ró nuū tāca tóhō, te ma nácani ni rō xīhna gā ndese stíó cuɨ́ñɨ́ rō nuū de te cācu ró. Chi máá hora un te máá Yaā Dios cuāha ya jnūhun nuū rō ndese cahān rō, te jnūhun ún cahān rō. Chi nasūu máá ró cúu jeē cahān, chi Espíritu Santo cúu jeē cahān. ");
INSERT INTO mibNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Te ñani jiín ñani nastúu jnáhan jeē na cúū. Te tátá nastúu sēhe jeē cúū. Te sēhe ndonda sɨquɨ̄ tatá jiín náná jeē cahni. ");
INSERT INTO mibNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Te tāca ñáyuu quɨtɨ̄ ni i nuū rō jeē sɨquɨ́ ruhū. Te ñayuu cuɨñɨ nīhin jíín jnúhun ri nde quɨvɨ̄ jínu, chi cācu i. ");
INSERT INTO mibNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Te Daniel, tēe ni nacani jnūhun Yaā Dios, ni tee de jnūhun ɨɨn tēe néé jéē quíji. Te róhó jéē cácahu tutu ún, na jécūhun ni rō. Chi ɨɨn quɨvɨ̄ te cuni rō jeē sáha ndevāha de jeē stɨ́vɨ de tācá ndajníñu iī ini templo, te cuɨñɨ de nuū tú na ley cuɨñɨ de. Te núu cuni rō jeē súcuan cúu, te ñayuu cáyūcú región Judea, na cúnu i caa i yucu quingoo i. ");
INSERT INTO mibNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Te ñayuu cáyūcu núū quéhe, ma ndɨ́vɨ i ini vehe jeē quénehen i ndajníñu i, chi cánuú cunu yachī i návāha cācu i. ");
INSERT INTO mibNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Te ñayuu cáhīin nuū ítu, ma ndíji i vehe jeē quíhin i sahma i. ");
INSERT INTO mibNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Te quɨvɨ̄ ún nacā jeē ndahú ñahan cáñuhun sēhe jíín ñahan cándeca yɨquɨ́n, chi ma cúnihin ña cunu yachī ña. ");
INSERT INTO mibNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Te cacān tahú rō jeē ma quíji jnūndóho un jéē cunu ró máá tiempo cúun yuhvā. ");
INSERT INTO mibNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chi jeē quejéé un te coo cuehē jnūndóho xeēn, jeē ná tu coo súcuan nde quɨvɨ̄ ní sáha Yaā Dios ñayɨ̄vɨ́ te nde vijna. Te jeē ndɨ́hɨ jnūndóho ún te ni ma cóo ga jeē súcuan. ");
INSERT INTO mibNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Te núu tú nastɨ́yɨ máá Jítoho yō Yaā Dios tiempo jnūndóho ún, te ni ɨɨn ñayuu ma cácu cuɨtɨ i. Te jeē sɨquɨ́ ñáyuu cácandíje jeē ní nacāji ya, jeē yúcuan nastɨ́yɨ ya tiempo un. ");
INSERT INTO mibNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Núu súcuan te núu ɨɨn ñayuu cahān jiín ró: Yāhá condēhe ró íne Cristo, chí: Yūcuán condēhe ró íne ya, achi i, te ma candíje ró jéē cahán i. ");
INSERT INTO mibNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chi canecoo tēe cástáhú te cahān de jeē Cristo cúu de, chí cáhān de jeē tée nácani jnūhun Yaā Dios cúu de. Te sáha de jniñu jéhnu jeē naa ni ñayuu coto i, návāha stáhú de nde maá ñáyuu ní nacāji ya, te núu na cúu. ");
INSERT INTO mibNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Te ndito na cóo ni rō, chi je ni castūhun rí nuū rō vijna nde ná tu coo. ");
INSERT INTO mibNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Te quɨvɨ̄ ún, núu je ni ndɨhɨ jnūndóho ún, te cujnúú níāndii, te yoō ma ndíī gā. ");
INSERT INTO mibNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Te nɨngoo quɨ̄mɨ íin andɨvɨ́. Te tāca jéē íin andɨvɨ́ chi quɨsɨ i. ");
INSERT INTO mibNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yūcuán na te coto ñayuu nuū maá rí, Yaā ní nduu tēe, ndiji ri jiín vícō, te condiso ri cuehē poder, te yōhyo luu cujéhnu ri. ");
INSERT INTO mibNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yūcuán na te tají rí ndajéhé rī quinastútú yá ñayuu ní nacāji ri ndɨcúún lado ñayɨ̄vɨ́, nde nuū ndɨ́hɨ ñayɨ̄vɨ́ te nde nuū ndɨ́hɨ andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Vijna te scuáha ró ndese sáha nundēhe higo: Núu je ni nane numa, te ni najee ndaha, te cájini rō jeē jé ni cuyajni tiempo jihní. ");
INSERT INTO mibNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Te suni súcuan núu ni cajini rō jeē ní quejéé cúu tācá jniñu jeē ni cáhān rī, yūcuán na te na jécūhun ni rō jeē ní cuyajni quɨvɨ̄ ndíji ri, te yachī coo. ");
INSERT INTO mibNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Jendaá cahán rī jiín ró jeē ma cúū ndɨhɨ ñayuu jeē cóto jnūndóho ún, chi nde squícu ndɨhɨ jniñu ún. ");
INSERT INTO mibNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Andɨvɨ́ jíín ñáyɨ̄vɨ́ chi naa, te tāca jnúhun cáhán rī chi ma náā, chi ndɨhɨ squícu. ");
INSERT INTO mibNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Te quɨvɨ̄ jiín hora jeē ndíji ri, tú ni ɨɨn ñayuu jiní, ni máá ndajéhé cáhīyo andɨvɨ́, ni máá rí, Sēhe Yaā Dios. Chi máá ɨɨn ni Tátá rī cúu jeē jiní. ");
INSERT INTO mibNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Núu súcuan te na cócuhun ni rō tāca jnúhun yáha, te ndito na cóo ni rō, te cacān tahú rō, chi tu cájini rō na quɨvɨ̄ ndiji ri. ");
INSERT INTO mibNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Chi coo nájnūhun ɨɨn tēe jeē quihín jicá de, te nde ná tu quenda de vehe de, te ni ndacu de jniñu nuū tāca mozo de ndese sáha ɨɨn ɨɨn de. Te ni ndacu de jniñu nuū tée ndíto yéhyɨ́ jéē na cóndito de. ");
INSERT INTO mibNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Te suni súcuan róhó jíjnáhan ró, ndito na cóo ni rō. Chi cúu ri nájnūhun jitoho vehe ún, te tu cájini rō na hora ndiji ri, á jéē cuácuaa, chí ñuú, chí jéē cána líhli, chí jénéhen. ");
INSERT INTO mibNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chi ɨɨn sanaa‑ni te ndiji ri, te coto ró jéē ma nánihīn rī rohó jéē tu ndíto ró. ");
INSERT INTO mibNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Te jnūhun cáhán rī jiín ró jijnáhan ró, suni cáhán rī jiín ndɨvii ñayuu: Ndito na cóo ni rō jijnáhan ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Te cúmanī uū gā quɨvɨ̄ te quejéé vico pascua jeē cáyeji ñayuu hebreo pan jeē tú na levadura yɨ́hɨ. Te sutū cácujéhnu jíín tée cástéén tutu ley, ni canducú de modo ndese jnɨɨ de Jesús jiín jnúhun stáhú, te cahni de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Te ni cacahān de: Ma jnɨ́ɨ yó de máá quɨ́vɨ̄ víco, chi ndonda ñayuu sɨquɨ̄ yō, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Te íne Jesús ñuu Betania vehe Simón, tēe ni ndoho cuehyɨ̄ stehyú. Te níní yéji yā staā, te ni quee ɨɨn ñahan nuū yā, ndáhá ña ɨɨn frasco yuū luu jeē ñúhun aceite perfume, jeē máni ita nardo cúu, te yōhyo yahu ndéé. Te ni tahú ña frasco un, te ni chuhun ña xinī yā. ");
INSERT INTO mibNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Te sava tēe cáhīin yūcuan ní caquɨtɨ̄ ni de, te ni cacahān de: ¿Najehē cúu jeē náā saá‑ni perfume jiñā? ");
INSERT INTO mibNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chi cuu xīcó yahu yó víhyá gā unī ciento denario, te cuāha yo núū ñáyuu ndahú núú, áchí de. Te ni cacahān sōó de jíín ña. ");
INSERT INTO mibNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Te ni cahān Jesús: Ma stáhān rō ña. ¿Naun cásáha ró jéē nácani uhū ni ña? Chi ɨɨn jniñu váha cúu jeē ni sáha ña jíín rí. ");
INSERT INTO mibNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Chi níní coyūcu ñáyuu ndahú jíín ró, te núu cácuni rō te cuu sáha vāha ró jíín i. Te ruhū chi tuá condee rī jiín ró. ");
INSERT INTO mibNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Chi ni sáha ña ndɨhɨ jeē cuu sáha ña jeē maní ña jíín rí. Chi nde ná tu quindūji ri te je ni sátūhva ña ruhū jeē ní chuhun ña perfume ruhū. ");
INSERT INTO mibNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Jendaá cahán rī jiín ró jeē nɨɨ́ cáhnu ñayɨ̄vɨ ndé‑ni cúu nuū cuité núu jnūhun jeē jnáma ri ñayuu, suni nacani i jnūhun jeē ni sáha ñahan yáha, návāha cocuhun ni ñayuu ña, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yūcuán na te Judas Iscariote, ɨɨn jeē ndɨhúxí uū tēe cáscuáha un, ní jehēn de nuū sutú cácujéhnu, ni sándaā de jíín jéē nastúu de Jesús nuū jijnáhan. ");
INSERT INTO mibNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Te nuū ní cajini sōho sutū un jéē cahán de, te ni cacusɨɨ̄ ni, te ni cajejnūhun jeē cuáha xūhun núū de. Te nde quɨvɨ̄ un ní nducú de modo ndese nastúu de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Te ni quee máá quɨ́vɨ̄ jeē quejéé vico pascua jeē cáyeji ñayuu pan jeē tú na levadura yɨ́hɨ, te suni quɨvɨ̄ un cájehni i londe nájnūhun ni ndacu Yaā Dios jniñu jeē sáha i vico pascua un. Te tēe cáscuáha un ní cacajnūhún de ya: ¿Ndé nuū cuní ni jéē quísátūhva ná cuxíni ní vico pascua? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Te ni tají yá uū tēe cáscuáha ún quingoo de, te áchí yá jiín de: Cuángoo nde ñuu, te yūcuán najnáhan ró jíín ɨɨn tēe ndíso quɨ̄yɨ ndute. Te condiquīn rō de quihīn rō jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Te vehe jeē ndɨ́vɨ de, yūcuan cáhān rō jiín tée chíí vehe: Achí máá Maestro: ¿Ndé ɨɨn cúu cuarto vehe ní cuāha núú ní núū cuxíni ya vico pascua jiín tée cáscuáha jíín yá? achi rō. ");
INSERT INTO mibNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Te máá de stéén de ɨɨn cuarto cáhnu nde xinī véhe jeē je íyó túhva. Te yūcuan sátūhva ró jéē cuxíni yó, áchí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Te cuangoo tēe cáscuáha ún, te ni jinūcoo de ñuu, te ni canihīn de nájnūhun ni cahān yā jiín de. Te ni casátūhva de jeē cuxíni ya vico pascua. ");
INSERT INTO mibNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Te jeē cuácuaa, te ni quee ya jiín ndɨhúxí uū de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Te ni cacucōo de mesa cáyeji de staā, te ni cahān yā: Jendaá cahán rī jiín ró jeē ɨɨn róhó jéē yéji jiín rí, nastúu ro rúhū, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yūcuán na te ni cacucuíhyá ni de, te ná ɨɨn ná ɨɨn de ni cacajnūhún de ya: ¿A sáña cúu? áchí ɨɨn de. Te suni súcuan ɨnga de: ¿A sáña cúu? áchí ɨɨn ɨɨn de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Te ni cahān yā jiín de: Ɨɨn jeē uxí uū rō jeē cáyeji cáhnu jíín rí ɨɨn cohō, suu nastúu ruhū. ");
INSERT INTO mibNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Te ruhū, Yaā ní nduu tēe, jendaá cúu jeē quihín rī cuu rī, nájnūhun yósó jnúhun ri nuū tútu iī. Te nacā xeēn ndoho tēe nastúu ruhū. Vāha ga núu tu ní cácu tēe un núú, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Te níní cáyeji de jíín yá, te ni quihin ya pan, te ni nacuatáhú yá, te ni tahú cuéchí yá, te ni jēhe ya nuū tée cáscuáha jíín yá. Te ni cahān yā: Caji rō jijnáhan ró, chi yāha cúu yɨquɨ cúñu rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yūcuán na te ni quihin ya ɨɨn copa ndūxi uva, te ni nacuatáhú yá, te ni jēhe ya ni cajihi ndɨhɨ de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Te ni cahān yā jiín de: Yāha cúu nɨñɨ̄ rī jeē cuáha ri jeē cúu contrato jeé, te catɨ jeē ndundoo cuēchi cuehē ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Te jendaá cahán rī jiín ró jeē ndé vijna te ma cóho ga rī ndūxi ndehē uva yāhá, chi nde quiji quɨvɨ̄ ndacu Yaā Dios jniñu nɨ́ɨ́ ñayɨ̄vɨ́, te sáá te coho tucu ri jiín ró jijnáhan ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Te ni jita ya ɨɨn yaa iī jiín de jíjnáhan de. Te ni quenda ya cuahān yā jiín de nde yucu Olivos. ");
INSERT INTO mibNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yūcuán na te ni cahān yā: Ndɨvii rō nayūhu ró jeē sɨquɨ́ ruhū jecuáā vijna. Chi suhva je yósó jnúhun ri nuū tútu iī, ni cahān Yaā Dios: Cuāha ri jnūhun jeē cáhni ñayuu tēe ndíto lanchi, te lanchi un cuítē núu tɨ jeē yūhu tɨ́, achí. ");
INSERT INTO mibNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Te jeē nátecu rī, te xīhna ruhū cosnūu rí quihīn rī región Galilea, te sáá te najinūcoo ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yūcuán na te ni cahān Pedro: Vēsú ndɨhɨ de na náyūhú de, te máá ná chi ma náyūhú cuɨtɨ ná, áchí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Te ni cahān yā jiín de: Jendaá cahán rī jiín ró jeē jecuáā vijna, nde ná tu cana líhli uū jínu, te yūhu ró jeē jnɨɨ ñayuu rohó, te unī jínu cahān rō jeē tu jíní rō ruhū, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Te ni cahān teyɨ́ de jíín yá: Vēsú núu cuu na jíín ní, te ma cahán cuɨtɨ na jéē tu jíní na níhín, áchí de. Te suni súcuan ni cacahān ndɨhɨ de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yūcuán na te ni jinū Jesús jiín tée cáscuáha jíín yá ɨɨn lugar nuū naní Getsemaní. Te ni cahān yā jiín de: Yāhá‑ni cucōo ró, te na quíhín rī cacān tahú rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Te ni jeca ya Pedro jiín Jacobo jiín Juan, cuahān yā jiín de. Te ni quejéé yá cucuíhyá ndasɨ́ ni yā te cúxií ni yā jeē quíji jnūndóho sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Te ni cahān yā jiín de: Yōhyo cúcuíhyá ni rī, te ndúcú sáha jeē cúū rī. Yāhá condetu ró te condito ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Te ni jica ya jecu gā, te ni jecuɨñɨ̄ yɨtɨ́ yá ni jequin ya nuū yā nuū ñúhun. Te ni jicān tahú yā nuū Yaā Dios jeē núu cuu te ma ndóho ya jnūndóho jeē quejéé quiji sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Te suhva ni cahān yā: Tátá maá ná, ndɨhɨ‑ni jniñu cuu sáha máá ní. Te tejiyo ní jnúndóho yáha jéē ma quíji sɨquɨ̄ ná. Te nasūu jéē cuní maá ná, chi jeē cuní maá ní na cóo, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Te ni ndee yā nuū ndɨnúní tée cáscuáha jíín yá, te ni jito ya jeē cáquixī de. Te ni cahān yā jiín Pedro: Simón, ¿á quíxí rō? ¿A tu ní cánda ró condito ró jíín rí vēsú ɨɨn hora? ");
INSERT INTO mibNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Coo ndito ni rō te cacān tahú rō jeē chindéé ñáhán yá rohó jeē ma sáha ró cuéchi jeē coto ndee jeneé róhó. Chi cúní ndije ánuá rō squícu vāha ró, te yɨquɨ cúñu rō chi tu fuerza, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Te ni jehēn tucu ya, ni jicān tahú yā, te suni jnūhun yúcuan ní cahān yā. ");
INSERT INTO mibNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Te ni ndee ya nuū de, te ni jito ya jeē cáquixī tucu de, chi yōhyo cájiī de māhná. Te tuá ni cánihīn de jnūhun stíó cuɨ́ñɨ́ de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Te ni ndee yā jeē vuelta unī, te ni cahān yā jiín de: Vijna te cusū rō te ndetātu ró. Te tuú chi je ni cuu, chi je ni quee hora, te ruhū, Yaā ní nduu tēe, natūu ri te jnɨɨ tēe cáhīyo cuēchi ruhū. ");
INSERT INTO mibNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ndocuɨñɨ̄ jijnáhan ró, chi je vēji tēe nastúu ruhū, te quihīn yō jiín de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Te sá cáhán gā yā súcuan, te ni quee‑ni Judas, ɨɨn jnáhan jeē uxí uū tēe cáscuáha jíín yá. Te vējicoo cuehē tēe jíín de, cándaha de espada jiín yujnu. Chi sutū cácujéhnu jíín tée cástéén tutu ley jiín tée jéhnu cándacu jniñu, ni catají de tēe ún. ");
INSERT INTO mibNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Te Judas, tēe nástúu ya ún, je ni jēhe de ɨɨn seña nuū tée un jíjnáhan, chi ni cachi de: Tēe jeē téchūhu rí un cúu. Te jnɨɨ ró jíjnáhan ró quihīn rō jiín, te ma siaá cuɨtɨ rō, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Te ni quee de nde nuū Jesús, te ni cahān de jíín yá: Maestro, Maestro, achí de. Te ni techūhú de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Te tāca gá tēe un ní cajnɨɨ de ya, te cuangoo de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Te ɨɨn tēe íne jíín yá ni tava de espada de, te ni jehnde de sōho ɨɨn mozo maá sútū cujéhnu ga. ");
INSERT INTO mibNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Te ni cahān Jesús jiín ñáyuu cuehē ún: ¿Te va tēe cuíhná cúu ri jeē véjicoo ró jíín espada jiín yujnu jnɨɨ ró rúhū jeē súcuan? ");
INSERT INTO mibNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tāca quɨ́vɨ̄ ni ine ri jiín ró jijnáhan ró ini templo cáhnu, ni steén rī jnūhun, te tu ní cájnɨɨ ró rúhū. Te súcuan cásáha ró návāha na squícu jeē cahán tutu iī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yūcuán na te ndɨhɨ tēe cáscuáha jíín yá, ni castóo de ya, ni cajinu de cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Te ɨɨn tēe suchí, ndíquín de ya cuahān de jíín yá. Te ndíi de máá ɨɨn sahma cuitá. Te ni cajnɨɨ tēe ún de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Te máá sahma cuitá un ní canihīn. Te ni jinu máá ñɨɨ‑ni de cuahān de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yūcuán na te ni jinūcoo de jíín Jesús nuū sutū cujéhnu ga. Te tāca sútū cácujéhnu jíín tée jéhnu cándacu jniñu jíín tée cástéén tutu ley, ni candutútú de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Te Pedro chi jícá‑ni ndíquín de ya, te ni jinū de nde ini patio sutū cujéhnu ga. Te ni cucōo de jíín táca policía, násaā de ñuhūn. ");
INSERT INTO mibNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Te sutū cácujéhnu jíín ndɨhɨ tēe cásáha junta cujéhnu ga, ni canducú de cuēchi sɨquɨ̄ Jesús, chi cahni de ya cácuni de. Te tu ní cánihīn de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Chi cuehē de ni cacahān yaá sɨ́quɨ̄ yā, te tu ní quíjnáhan jnūhun ni cacahān de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yūcuán na te ni candocuɨñɨ̄ sava de, te ni catee de cuēchi sɨquɨ̄ yā, achí de: ");
INSERT INTO mibNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Máá ná ni cajini ná cáhán de jeē canu de templo yáha jéē ní cuvāha ni casáha tēe, te nuū uní quɨvɨ̄ te nacani de ɨnga jeē násūu jíín ndaha tée cuvāha, áchí de. Achí jíjnáhan. ");
INSERT INTO mibNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Te ni jnūhun yáha tu ní quíjnáhan tucu jeē cácahān de sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yūcuán na te sutū cujéhnu ga ni ndocuɨñɨ̄ de nuū ñáyuu cuehē ún, te ni cajnūhún de Jesús: ¿Naun tu cáhán cuɨtɨ rō? ¿A íyó ndáā jeē cácahān tēe yáha sɨ́quɨ̄ rō? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Te máá yá tu ní cáhán cuɨtɨ yā, chi tú na vé ni stíó cuɨ́ñɨ́ yā. Te sutū cujéhnu ga ni cajnūhún tucu de ya: ¿A máá ró cúu Cristo, Sēhe Yaā vāha jeē cujéhnu? áchí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Te ni cahān yā: Suu ri cúu. Te coto ró jéē ruhū, Yaā ní nduu tēe, condee rī lado váha Yaā iyó poder, te ndiji ri ichi ándɨvɨ́ jíín vícō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yūcuán na te sutū cujéhnu ga ni jehnde de sahma de jeē quɨtɨ́ ndasɨ́ ni de, te ni cahān de: ¿Ndé jíni ñúhún gá yō testigo núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chi je ni cajini ró jéē cahán de jnūhun ndevāha jeē quɨtɨ́ ni Yaā Dios, chi sáha de máá de Sēhe Yaā Dios. ¿Te ndese cájeni ni rō? Achí de. Te ndɨhɨ de ni cacahān jeē na cúū yā. ");
INSERT INTO mibNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Te sava de ni catesɨ̄hɨ́ de nuū yā, te ni cajesɨ de sahma nuū yā, te ni cacani de ya. Te cácahān de jíín yá: Cachi ndé ɨɨn cúu jeē ní cani róhó, áchí de. Te tāca tée policía ni cacani de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Te íne Pedro ini patio ichi chíji nuū cáhīin de jíín Jesús. Te ni quee ɨɨn ñahan jéjníñu vehe sutū cujéhnu ga ún. ");
INSERT INTO mibNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Te ni jito ña nuū de jeē néne de násaā de yuñúhún. Te ni jito vāha ña nuū de, te ni cahān ña: Róhó chi suni ni jica ró jíín Jesús, tēe ñuu Nazaret, achí ña. ");
INSERT INTO mibNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Te máá de tu ní cáchi de, chi ni cahān de: Tu jíní rī de, ni tu jíní rī na jnūhun cáhán rō, achí de. Te ni quenda de yéhyɨ́ núū quéhe. Te ni cana‑ni líhli. ");
INSERT INTO mibNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Te ñahan jéjníñu un ní jito tucu ña nuū de, te ni quejéé ña cáhán ña jíín ñáyuu cáhīin yūcuán: Tēe yáha suni jnáhan tāca tée un cúu, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Te máá de tu ní cáchi tucu de. Te ni cunúu jecu gā, te ñayuu cáhīin yūcuan ní cacahān tucu i jíín Pedro: Jendaá ndije jeē suni jnáhan de cúu ró, chi tēe Galilea cúu ró, te ɨnuú‑ni cáhán rō jiín de jíjnáhan de. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yūcuán na te ni quejéé de cáhán teyɨ́ de jeē na cóndee cuēchi sɨquɨ̄ de núu tu cáhán ndaā de: Tu jíní rī tēe un jéē cácahān rō jnūhun de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yūcuán na te ni cana‑ni líhli vuelta uū. Te ni nucūhun ni de jnūhun ni cahān Jesús jiín de: Nde ná tu cana líhli uū jínu, te yūhu ró te cahān rō unī jínu jeē tu jíní rō ruhū. Te ni nacani ni de sɨquɨ̄ jnúhun ún, te ni ndahyū de. ");
INSERT INTO mibNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Te jeē ní cundijin, te sutū cácujéhnu ni candutútú de jíín tée jéhnu cándacu jniñu, jíín tée cástéén tutu ley, jiín ndɨhɨ tēe cásáha junta cujéhnu ga, te ni casquíjnáhan de jnūhun. Te ni cajihni de Jesús, te cuangoo de jíín yá nuū Pilato, tēe cúu gobernador. ");
INSERT INTO mibNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Te Pilato ni cajnūhún de ya: ¿A máá ró cúu Rey ñayuu hebreo? achí de. Te ni cahān yā: Suu ri cúu, nájnūhun cáhán rō. ");
INSERT INTO mibNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Te sutū cácujéhnu un ní cacahān de cuehē cuēchi sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Te Pilato ni cajnūhún tucu de ya: ¿Naun tu cáhán cuɨtɨ rō? ¿A tu jíni ró jéē cuehē cuēchi cácahān de sɨquɨ̄ rō? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Te tu ní cáhán cuɨtɨ yā ni ɨɨn jnūhun jíín de. Te nahán ní naa ni Pilato ndéhé de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Te íyó costumbre Pilato jeē quɨvɨ̄ víco un siáá de ɨɨn tēe íne vecāa, núu na‑ni tēe cácuni ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Te íyó ɨɨn tēe nání Barrabás, íne de vecāa jíín táca jnáhan de sɨquɨ̄ jeē ní candonda de sɨquɨ̄ tohō te ni cajehni de ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Te ni quecoo ñayuu cuehē, te ni cacahān i jíín Pilato jeē na sáha de nájnūhun íyó costumbre de. ");
INSERT INTO mibNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Te ni cahān Pilato jiín i: ¿A tu cácuni rō jeē siaá rī tēe cúu Rey rohó ñáyuu hebreo? achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Súcuan ni cahān de, chi cúní de siáá de Jesús. Chi je ni jecūhun ni de jeē ní cacucuésún ni tāca sútū un cájito de ya, te jeē yúcuan ní quijicoo jíín yá nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Te sutū cácujéhnu un ní cascáhán de ñayuu cuehē un jéē váha ga na cácán i jeē siaá Pilato Barrabás. ");
INSERT INTO mibNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yūcuán na te ni cajnūhún tucu Pilato: Núu súcuan ¿te ndese cácuni rō jeē sáha ri jiín tée jeē cácahān rō jeē cúu de Rey rohó ñáyuu hebreo? áchí de jíín i. ");
INSERT INTO mibNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Te ni cacana jee i: Cata caa ní de jicā cruz, na cúū de, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Te ni cahān Pilato: ¿Na cuēchi ni sáha de núu súcuan? Te ñayuu un ní cacana jee tucu i: Cata caa ní de jicā cruz, na cúū de, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Te Pilato cuní de jeē na cúsɨɨ̄ ni ñayuu jiín de, te ni siaá de Barrabás. Yūcuán na te ni ndacu de jniñu jeē na cáni tācá soldado Jesús, jiín jéē cata caa de ya jicā cruz. ");
INSERT INTO mibNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yūcuán na te soldado un cuángoo de jíín yá ini patio palacio, jeē sácatā de nuū yā. Te ni canastútú de ndɨhɨ jnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Te ni cachuhun de ya ɨɨn sahma cuehé ndíhí jéē cúu sahma rey. Te ni casáha de ɨɨn corona iñu, ni cachuhun de xinī yā. ");
INSERT INTO mibNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yūcuán na te ni cacana de: Nacā jeē váha rey cúu Rey ñayuu hebreo, achí de. ");
INSERT INTO mibNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Te ni cacani de yujnu xinī yā, te ni catesɨ̄hɨ́ de nuū yā, te ni cajecuɨñɨ̄ yɨtɨ́ de nuū yā, casáha de jeē chiñúhún de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Te nuū ní cuu ni casácatā de nuū yā, te ni catava de sahma cuehé ndíhí un, te ni canachuhun de ya sahma máá yá. Te ni caquenehen de ya jeē cata caa de ya jicā cruz. ");
INSERT INTO mibNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Te ɨɨn tēe nání Simón ñuu Cirene, tēe cúu tátá Alejandro jiín Rufo, vendiji de jeē ni jéhēn de rancho. Te ni yāha de yūcuán, te ni catejníñu soldado un de jeē cóndiso de cruz yā. ");
INSERT INTO mibNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Te cuangoo de jíín yá ɨɨn lugar nuū naní Gólgota, jeē cuní cahān Lugar Yɨquɨ Xíní. ");
INSERT INTO mibNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Te ni cajēhe de vino jeē ni sácā núu jíín súje uvuā jeē cóho ya, te tu ní jíhi ya. ");
INSERT INTO mibNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Te ni cacata caa de ya jicā cruz. Te ni casáha de sorteo jeē sɨquɨ́ ndese nihīn ɨɨn ɨɨn de sahma ya. ");
INSERT INTO mibNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Te cahɨɨ̄n ni cacata caa de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Te jnūhun ni catee de xinī cruz cahán na sɨquɨ̄ ni jihī yā: Yāha cúu Rey ñayuu hebreo, achí. ");
INSERT INTO mibNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Te suni ni cacata caa de uū tēe cuíhná núū uū gā cruz, ɨɨn de lado váha ya, te ɨnga de lado jecó yá. ");
INSERT INTO mibNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Te ni squícu jnūhun cáhán tutu iī: Ni casquíjnáhan de ya jiín tée cásáha néé, áchí. ");
INSERT INTO mibNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Te ñayuu cáyāha yūcuán cáscuícó i xinī i, te cácahān neé i: Jājaān. Róhó chi cáhán rō jeē cánu rō templo cáhnu, te nuū uní quɨvɨ̄ te nucondichi sáha ró. ");
INSERT INTO mibNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Núu súcuan te jnama ró máá ró, te nuu ró jícā cruz viī, achí i. ");
INSERT INTO mibNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Te suni súcuan ni cacahān catá sutū cácujéhnu jíín tée cástéén tutu ley, te áchí de cácahān maá de: Núu ɨnga ñayuu ni jnama de, ¿te naun tu cúu jnama de máá de vijna? ");
INSERT INTO mibNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Núu na cúni yō jeē Cristo, Rey ñayuu Israel, nuu de jicā cruz vijna, yūcuán na te candíje yó, áchí de jíjnáhan de. Te tēe cándita caa jíín yá, suni súcuan ni cacahān neé de. ");
INSERT INTO mibNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Te nuū ní cuu cahuxī uū, te ni cunee nɨɨ́ cáhnu nde cahunī. ");
INSERT INTO mibNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Te nuū ní cuu cahunī, te ni cana jee Jesús: Eloi, Eloi, ¿lama sabactani? achí yá. Te jnūhun un cúní cahān: Yaā Dios maá ná, Yaā Dios maá ná, ¿naun ni stóo ní sáña? ");
INSERT INTO mibNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Te sava ñayuu cáhīin yūcuan, ní cajini i jnūhun ún, te ni cacahān i: Cuni nahín, chi cána de xinī Elías, tēe ni nacani jnūhun Yaā Dios jenahán, achí i. ");
INSERT INTO mibNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Te ni jinu ɨɨn tēe, ni jechundaji de cachī nuū vinagre iyá. Te ni tee de xinī ɨɨn yujnu, te ni tee de yuhu ya jeē cóho ya. Te ni cahān de: Na cóndēhe yó núu quiji Elías nasnúu de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Te máá Jesús ni cana jee ya, te ni jihī‑ni ya. ");
INSERT INTO mibNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yūcuán na te sahma ndíta caa jeē ndihyú cuarto iī ini templo cáhnu, ni ndatā sava sava nde xinī te nde nuū jehé. ");
INSERT INTO mibNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Te tēe ñuu Roma jeē cúu capitán, índichi de nuū yā, te ni jini de jeē ní cana jee ya te ni jihī yā. Te ni cahān de: Jendaá ndije jeē Séhe Yaā Dios cúu tēe yáha, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Te suni cáhīin sava ñahan, cándēhe jícá ña. Te unī ña cácuu María ñuu Magdala, jiín María naná José jiín Jacobo suchí, jíín ñahan nání Salomé. ");
INSERT INTO mibNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Te ñahan yáha ní candiquīn ña ya, ni cajejníñu ña nuū yā nde náa jíca ya Galilea. Te suni cáhīin cuehē gā ñahan jeē ni jéngoo jíín yá ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Te ni ini quɨvɨ̄ ún. Te quɨvɨ̄ sátūhva cúu, chi sajnē cúu quɨvɨ̄ ndétātú. ");
INSERT INTO mibNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Te ni quee José, tēe ñuu Arimatea. Te cúu de ɨɨn tēe cújéhnu nuū junta cujéhnu ga. Te suni ñúhun ni de jeē quiji quɨvɨ̄ jeē ndacu Yaā Dios jniñu. Te tu yúhú de chi ni quɨ̄vɨ de nuū Pilato, ni jicān de yɨquɨ cúñu Jesús. ");
INSERT INTO mibNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Te Pilato chi náā ni de jeē yachí ni jihī yā. Te ni cana de capitán, te ni cajnūhún de tēe un núu je ni jihī yā. ");
INSERT INTO mibNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yūcuán na te ni cucáhnu ni de jeē ni cáhān capitán jiín de, te ni jēhe de jnūhun jeē quihin José yɨquɨ cúñu yā. ");
INSERT INTO mibNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Te José ni jeen de ɨɨn sahma cuitá váha. Te ni snúu de yɨquɨ cúñu yā, te ni chusúcún de sahma ún. Te ni chindūji de ya ini ɨɨn yaū jeē quíndūji ndɨ̄yɨ, jeē ní caan jicā ɨɨn cava. Te ni jesɨ de ɨɨn yuū yuhu yáú un. ");
INSERT INTO mibNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Te María ñuu Magdala, jiín María naná José, ni cajito ña nuū ní cachindūji de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Te ni ini quɨvɨ̄ ndétātú, te María ñuu Magdala, jiín María naná Jacobo, jiín Salomé, ni cajeen ña tācá perfume jeē quíchuhun ña yɨquɨ cúñu yā. ");
INSERT INTO mibNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Te jenéhen quɨvɨ̄ domingo, jeē ní cane niāndii, te ni jinūcoo ña nuū ní yɨndūji ya. ");
INSERT INTO mibNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Te cácahān ña: ¿Ndé níhīn yō tēe tejiyo yuū ndihyú yuhu yáú? áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Te ni candacoto ña, te ni cajito ña jeē jé ni cujiyo yuū cáhnu un cuáhān. ");
INSERT INTO mibNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Te ni quɨ̄vɨcoo ña ini yaū ndɨ̄yɨ. Te ni cajito ña ɨɨn ndajéhé Yaā Dios jeē cáa nájnūhun tēe suchí, néne ya ichi lado váha, ñúhun ya ɨɨn sahma cuijín cáni. Te ni cayūhú ña. ");
INSERT INTO mibNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Te ni cahān yā jiín ña: Ma yūhu ró jijnáhan ró. Chi vecondēhe ró Jesús ñuu Nazaret, Yaā ni jíhī jicā cruz. Tuá yā yāhá, chi je ni natecu yā. Yāhá condēhé ró nuū ní cachindūji de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cuánungoo te cachi rō nuū tée cáscuáha jíín yá, jíín núū Pedro, jeē xíhna gā maá yá jinū Galilea, te sáá te najinūcoo de. Te yūcuán coto de nuū yā, nájnūhun ni cahān yā jiín de nde saá, áchí yá jiín ña. ");
INSERT INTO mibNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yūcuán na te ñahan un ní quendacoo ña nuū ní yɨndūji ya, te cájinu ña cuangoo ña. Chi quɨ́sɨ i ña jeē cáyūhú ña. Te tu ní cácachi cuɨtɨ ña nuū ní ɨɨn, chi cáyūhú ña. ");
INSERT INTO mibNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Te Jesús ni natecu yā jenéhen quɨvɨ̄ domingo. Te xīhna gā ni nane ndijin yā nuū María ñuu Magdala, ñahan jeē ní quenehen ya uxā tachī ini. ");
INSERT INTO mibNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Te cuahān ña cuacastūhún ña nuū tāca tée ni cajica jíín yá jeē ní nane ya nuū ña. Te cácucuíhyá ni de te cándahyū de. ");
INSERT INTO mibNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Te nuū ní cajini de jnūhun jeē ní jito ña nuū yā jeē técu yā, te tu ní cácandíje de jnūhun cáhán ña. ");
INSERT INTO mibNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yūcuán na te ni quendacoo uū jnáhan tēe ún, cájica de cuahān de ichi rancho, te sɨ́ɨn modo ni nane ndijin yā nuū de. ");
INSERT INTO mibNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Te ni canandicó de, ni cacastūhún de nuū tāca gá jnáhan de. Te ni tu ní cácandíje tucu jnáhan de jeē cácahān ndɨndúú de. ");
INSERT INTO mibNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Te cúcuéé gá te ni nane ndijin yā nuū ndɨhúxí ɨɨn de jeē cáyūcú de mesa cáyeji de staā. Te ni cahān yā nuū de, chi nīhni ni de jeē tu cácandíje de jeē cácahān jnáhan de un, jéē ní natecu yā ni cajito de ya. ");
INSERT INTO mibNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Te ni cahān yā jiín de: Cuángoo jíjnáhan ró nɨ́ɨ́ ñayɨ̄vɨ́, te nacani ró jnúhun ri nuū tāca ñáyuu ndese jnáma ri i. ");
INSERT INTO mibNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Te ñayuu candíje te cuandute i, chi cācu i. Te ñayuu tú candíje, chi jnahnū ndetū i. ");
INSERT INTO mibNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Te ñayuu candíje, sáha i tācá jniñu jéhnu yáha jeē steén jeē iyó rí jiín i: Jíín sɨ́hvɨ́ rí quenehen i tachī ini ñayuu. Te cahān i tɨjnɨ yuhu jéé. ");
INSERT INTO mibNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Te núu ni jnɨɨ sanaa i coō, chí núu ni jihi i veneno, te ma sáha daño jiín i. Te suni soó i ndaha i sɨquɨ̄ ñáyuu cácuhū, te nduvāha. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yūcuán na te nuū ní ndɨhɨ ni cahān maá Jítoho yō jiín de jíjnáhan de, te ni ndaa ya cuanuhun yā andɨvɨ́, te ni cucōo ya lado váha Yaā Dios nuū cujéhnu ya. ");
INSERT INTO mibNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Te máá de ni quendacoo de, ni canacani de jnūhun ya tāca lado ndese jnáma ya ñayuu. Te máá Jítoho yō ni chindéé ñáhán yá de. Te ni jēhe ya fuerza jeē sáha de tācá jniñu jéhnu jeē steén jeē iyó ndáā jnūhun cánacani de. Te ni cuu. Amén.");
INSERT INTO mibNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Cuehē tēe ni cajicu de ni catee yúcún de historia Jesús, tācá jniñu jeē ni sáha ya ni cajito yó. ");
INSERT INTO mibNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Te ni catee de tāca jnúhun jeē ní cacastūhun ñáyuu nuū yō, jeē ní cajito i jniñu yúcuan nde ná ni quejéé, te ni canacani i jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Te máá ná, suni ni nanducú yúcún ná tāca jnúhun ya, nde nuū ní quejéé. Te ni jeni ni na jéē suni íyó váha jeē tée cájí ná tāca jnúhun yáha núū ní, amigo Teófilo. ");
INSERT INTO mibNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Te súcuan te cuni ni jéē iyó ndáā tāca jnúhun jeē ní cacastūhún i nuū ní. ");
INSERT INTO mibNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tiempo jeē ní cuu Herodes rey región Judea, te ni īyo ɨɨn sutū ñayuu hebreo, naní de Zacarías, te grupo Abías cúu de. Te ñasɨhɨ́ de nání ña Elisabet, te suni sēhe yucūn maá sútū Aarón cúu ña. ");
INSERT INTO mibNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Te ndɨndúú de cahīyo ndaā de nuū Yaā Dios, te ndaā vāha cásquícu de jniñu ndácu ley maá Jítoho yō Yaā Dios, cájito tāca ñáyuu. ");
INSERT INTO mibNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Te tú sēhe de íyó, chi ñahan númá cúu Elisabet, te je jéhnu ndɨndúú de. ");
INSERT INTO mibNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Te ɨɨn quɨvɨ̄ te jéjníñu Zacarías nuū jníñu jeē cúu de sutū nuū Yaā Dios, chi ni quee quɨvɨ̄ jeē ndɨ́vɨ grupo de. ");
INSERT INTO mibNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Te ni casáha de sorteo, nájnūhun íyó costumbre sutū. Te ni sáha tocar Zacarías jeē quɨ́vɨ de ini cuarto iī templo Jitoho yō Yaā Dios, te cahmu de sūje cūtú. ");
INSERT INTO mibNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Te hora jeē cayú sūje cūtú, te tāca ñáyuu cuehē cáhīin i fuera, cájicān tahú i. ");
INSERT INTO mibNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Te ni cane ɨɨn ndajéhé maá Jítoho yō nuū de, íin ya lado váha altar nuū jéhmu de sūje cūtú. ");
INSERT INTO mibNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Te ni cunéé ni Zacarías ni jito de nuū yā, te yōhyo ni yūhú de. ");
INSERT INTO mibNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Te ni cahān ndajéhé un jíín de: Zacarías, ma yūhu ró, chi je ni chihi Yaā Dios cuenta jeē ni jícān tahú rō. Te ñasɨhɨ́ ró Elisabet, scácu ña ɨɨn sēhe yɨɨ́, te snání ró i Juan. ");
INSERT INTO mibNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Te yōhyo cusɨɨ̄ ni rō. Te cuehē ñayuu cusɨɨ̄ ni jeē cácu i. ");
INSERT INTO mibNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Chi cujéhnu sēhe ró sáha máá Yaā Dios. Te ma cóho i vino ni ndixi cuīí. Te cunuú máá Espíritu Santo jiín i, nde ná tu cacu i. ");
INSERT INTO mibNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Te sáha i jeē cuehē ñayuu nación rō Israel ndɨ̄vɨcoo i nuū Jítoho i Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Te xīhna gā Juan quiji nacani jnūhun Jitoho yō Jesús, te sáá te quiji ya. Te sáha i nájnūhun ni sáha Elías, tēe ni nacani jnūhun Yaā Dios jenahán, te conevāha i poder jeē nácani i jnūhun, nájnūhun ni conevāha Elías. Te sáha i jeē tāca tátá ndumanī de jíín séhe de. Te suni sáha i jeē ñáyuu nīhni ni cuatáhú i nuū Yaā Dios, nduu i ñayuu ndaā. Súcuan sátūhva i ñayuu návāha candíje i máá Jítoho yō jeē quíji ya. Achí ndajéhé. ");
INSERT INTO mibNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Te Zacarías ni cajnūhún de ya: ¿Ndese cucáhnu ni na núu jendaá cúu? Chi tēe jéhnu cúu ná, te suni jéhnu ñasɨhɨ́ ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Te ni cahān ndajéhé un jíín de: Máá rí cúu Gabriel, te íne ri nuū Yaā Dios, jejníñu ri nuū yā. Te ni tají yá ruhū vēji ri cahān rī jiín ró, te nácani ri jnūhun vāha yáha núū rō. ");
INSERT INTO mibNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Te jeē tu ní cándíje ró jnúhun ni cahān rī, te cuñɨ́hɨ́n ró, te ma cúu cahān rō, chi nde na cácu sēhe ró. Te squícu nahín jnúhun cáhán rī yāhá, na quée quɨvɨ̄, achí ndajéhé. ");
INSERT INTO mibNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Te ñayuu cáhīin ichi fuera, cándetu i Zacarías, te cájeni ni i na vé ni cuu jeē cucuéé de ini cuarto iī templo. ");
INSERT INTO mibNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Te nuū ní quenda de, te tuá ni cúu cahān de jíín i. Te ni cajecūhun ni i jeē ini templo ni jito ndijin de ɨɨn jeē ni stéén yā nuū de. Te máá seña na ni sáha de nuū i, chi ni cuñɨ́hɨ́n de. ");
INSERT INTO mibNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Te nuū ni jínu quɨvɨ̄ ni jejníñu de ini templo, te cuanuhun de vehe de. ");
INSERT INTO mibNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Te ni cuu jecu quɨvɨ̄, te ñasɨhɨ́ de Elisabet ni jecūhun sēhe ña. Te ni īyo ña vehe ña uhūn yoō jeē tuá nde ní jéhén ña. Te jéni ni ña: ");
INSERT INTO mibNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Súcuan ni sáha máá Jítoho yō jiín rí, te ni tejiyo ya jnūhun jeē cúcanu rī nuū ñáyuu jeē tú sēhe ri, jéni ni ña. ");
INSERT INTO mibNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Te nuū iñú yoō, te ni tají Yaā Dios ndajéhé yā Gabriel, ni jehēn yā ɨɨn ñuu naní Nazaret, ndañúū Galilea. ");
INSERT INTO mibNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Te ni jehēn yā nuū ɨɨn sūchi sɨ́hɨ́ nání María. Te je ni cundaā jeē quijnáhan ña jíín ɨɨn tēe nání José, te sēhe yucūn rey David cúu de. ");
INSERT INTO mibNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Te ni quɨ̄vɨ ndajéhé un núū ndeé ña, te ni cahān yā: Tandii, nacā ndetū cúu ró. Chi máá Jítoho yō Yaā Dios iyó yá jiín ró, te ni sáha ya jeē yóhyo ndetū gā cúu ró núū tāca gá ñahan, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Te nuū ni jíto ña nuū yā, te ni cunéé ni ña jeē súcuan cáhán yā, te jéni ni ña naun cáhán yā súcuan jíín ña. ");
INSERT INTO mibNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Te ni cahān gā ndajéhé un jíín ña: Ma yūhu ró María, chi ni sáha Yaā Dios jeē váha jíín ró. ");
INSERT INTO mibNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Te jecūhun sēhe ró te scácu ró ɨɨn sēhe yɨɨ́, te snání ró i Jesús. ");
INSERT INTO mibNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Te cujéhnu i, te conaní i Sēhe Yaā cujéhnu téyɨ́. Te máá yá jeē cúu ya Jitoho yō Yaā Dios, sáha ya jeē cuu i rey, nájnūhun jíí i David ni cuu de rey. ");
INSERT INTO mibNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Te nɨ́ɨ́ cáni ndacu i jniñu nuū ñáyuu nación Israel. Te ma ndɨ́hɨ cuɨtɨ jeē ndácu i jniñu. Achí ndajéhé. ");
INSERT INTO mibNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Yūcuán na te ni cajnūhún María: ¿Ndese coo jeē ni cáhān ní? Chi ná tu coo yɨɨ ná, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Te ni cahān ndajéhé un: Máá Espíritu Santo quiji sɨquɨ̄ rō, te poder maá Yaā cujéhnu téyɨ́ sáha ɨɨn jniñu jéhnu jíín ró. Te jeē yúcuan máá súchi íī jeē cácu, quɨhɨ cuenta i nuū Yaā Dios, te cahān ñayuu jeē Séhe Yaā Dios cúu i. ");
INSERT INTO mibNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Te suni cástūhun rí nuū rō jeē jnáhan ró Elisabet, suni scácu ña ɨɨn sēhe vēsú je jéhnu ña. Te vijna íyó íñū yoō jeē tuá cácahān ñayuu jeē cúu ña ñahan númá. ");
INSERT INTO mibNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Chi ndɨhɨ‑ni cuu sáha Yaā Dios, te tu íyó ni ɨɨn jeē ma cúu sáha ya, achí ndajéhé un. ");
INSERT INTO mibNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yūcuán na te ni cahān María: Cuu núu súcuan, chi sáha ná táca jniñu ndácu Jitoho yō Yaā Dios, te na cóo jíín ná nájnūhun ni cachi ní, áchí ña. Te máá ndajéhé un cuáhān‑ni ya. ");
INSERT INTO mibNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Te ni cuu jecu quɨvɨ̄, te yachī cuahān María, ni caa ña yucu cuahān ña ɨɨn ñuu región Judea. ");
INSERT INTO mibNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Te ni jinū ña vehe Zacarías, te ni cahān ña jíín Elisabet. ");
INSERT INTO mibNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Te nuū ní jini Elisabet jeē cahán María jiín ña, te sūchi ñúhun chīji ña ni canda‑ni i. Te ni cunuú Espíritu Santo ini anuá ña. ");
INSERT INTO mibNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Te ni cahān jee ña: Ni sáha Yaā Dios jeē yóhyo ndetū gā cúu ró núū tāca gá ñahan, jíín jéē yóhyo ndetū sēhe ró. ");
INSERT INTO mibNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Te ndese cúu jeē ní quee naná maá Jítoho rī nuū rī? Chi tu cújéhnu cuɨtɨ rī. ");
INSERT INTO mibNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Chi jeē ní jini‑ni ri jnūhun ni cahān rō jiín rí, te sūchi ñúhun chīji ri ni canda i jeē cúsɨɨ̄ ni i. ");
INSERT INTO mibNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Te nacā ndetū rō jeē ní candíje ró, chi squícu nahín tāca jnúhun ni cahān maá Jítoho yō jiín ró. Achí Elisabet. ");
INSERT INTO mibNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Yūcuán na te ni cahān María: Cáhán rī jeē cujéhnu ndasɨ́ máá Jítoho yō Yaā Dios, ");
INSERT INTO mibNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","te cúsɨɨ̄ ni rī jiín Yaā Dios, Yaā jnáma ruhū. ");
INSERT INTO mibNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Chi ni sáha ya cuenta ruhū, vēsú tu cújéhnu ri. Te na squícu ri jniñu ndácu ya. Te nde vijna te tāca ñáyuu jeē nácacu, cahān i jeē yóhyo ndetū rī. ");
INSERT INTO mibNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Chi Yaā jnɨ́ɨ ndɨhɨ poder, ni sáha ya jniñu jéhnu jíín rí. Te Yaā iī ndoo cúu ya. ");
INSERT INTO mibNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Te nɨ́ɨ́ cáni cundáhú ni yā tāca ñáyuu ndíso īyo nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ni sáha ya jniñu jéhnu jíín poder yā, chi ni scúnu ya ñayuu casándúxí máá, ");
INSERT INTO mibNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","te ñayuu cácujéhnu, ni quende ya jeē cujéhnu i. Te ñayuu ndahú chi ni sajéhnu ya i, ");
INSERT INTO mibNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","te ñayuu cájiī sōco ni jēhe ya jeē cáji vāha i. Te ñayuu cucá ní natají yá i súcuan‑ni. ");
INSERT INTO mibNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Te ni chindéé ñáhán yá yohó, ñáyuu nación Israel, jeē cácuu yó mozo yā, te tu náā ni yā jeē cundáhú ni yā yohó. ");
INSERT INTO mibNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chi súcuan ni jejnūhun ya nuū tāca jíí yō, nuū Abraham jiín táca yúcūn de jeē cóo nɨ́ɨ́ cáni. Achí María. ");
INSERT INTO mibNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Te ni condee ña jíín Elisabet nájnūhun unī yoō. Yūcuán na te cuanuhun ña vehe ña. ");
INSERT INTO mibNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Te ni jinū quɨvɨ̄ jeē scácu Elisabet sēhe ña, te ni scácu ña ɨɨn sēhe yɨɨ́. ");
INSERT INTO mibNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Te tāca ñáyuu ndeé yajni jíín ña jíín táca jnáhan ña, ni cajini i jeē yóhyo ni cundáhú ni Yaā Dios ña, te ni jengoo i ni cacahān i jnūhun sɨɨ̄ ni jiín ña. ");
INSERT INTO mibNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yūcuán na te nuū uná quɨvɨ̄ jeē ní cacu i, te ni jengoo ñayuu ni sáha i circuncidar sūchi yɨ́quɨ́n un. (Te yūcuan cúu ɨɨn jnunī nuū yɨquɨ cúñu tāca súchi yɨ́ɨ́ hebreo jeē steén jeē cácuu i ñayuu Yaā Dios.) Te snání i sūchí un sɨ́hvɨ́ tátá i Zacarías nuú. ");
INSERT INTO mibNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Te ni cahān naná i: Ma cúu, chi Juan conaní i, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Te ni cacahān i jíín ña: ¿Te naun? Chi tú ni ɨɨn jnáhan ró nání súcuan, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yūcuán na te jíín seña ni cacajnūhún i tátá sūchí un ndese cúní de jeē cónaní i. ");
INSERT INTO mibNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Te máá de ni jicān ɨɨn tutu, te ni tee de: Juan conaní i. Te tāca ñáyuu un ní canaa ni i cájito i. ");
INSERT INTO mibNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Te ni nduvāha Zacarías jeē ní cuñɨ́hɨ́n de, te ni quejéé de cáhán de jeē yóhyo vāha Yaā cúu Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Te tāca ñáyuu ndeé yajni jíín de, yōhyo ni canaa ni i. Te nɨ́ɨ́ yucu región Judea ni jitē núu tāca jnúhun yáha jeē súcuan ni cuu. ");
INSERT INTO mibNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Te tāca ñáyuu jeē ní cajini jnūhun, ni quejéé i cánacani ni i, te cácajnūhun jnáhan i: ¿Ndese coo na cuéhnu sūchi yáha? áchí i. Chi máá Jítoho yō yōhyo ni sáha ya jeē váha jíín i. ");
INSERT INTO mibNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Te tátá i Zacarías ni cunuú Espíritu Santo jiín de, te ni nacani de jnūhun ni steén Yaā Dios nuū de: ");
INSERT INTO mibNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Yōhyo vāha Yaā cúu máá Jítoho yō, Yaā Dios yohó ñáyuu Israel, chi ni quiji ya nuū yō jeē cácuu yó ñáyuu yā, te ni jnama ya yohó. ");
INSERT INTO mibNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Te ni jeni ya ɨɨn Yaā iyó poder jeē jnáma ya yohó, te Yaā ún cacu yucūn mozo yā rey David. ");
INSERT INTO mibNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chi súcuan ni jejnūhun ya, ni cacahān tāca tée ndoo ánuá jeē ní canacani de jnūhun ya jenahán. ");
INSERT INTO mibNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Chi ni cacahān de jeē jnáma ya yohó núū jeē cájito uhū yohó, jíín núū jeē cáquɨtɨ̄ ni nuū yō. ");
INSERT INTO mibNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Chi ni cundáhú ni yā tāca jíí yō jijnáhan, te tu ní náā ni yā contrato iī yā. ");
INSERT INTO mibNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Chi suu un ní jejnūhun téyɨ́ yá nuū jií yō Abraham, ");
INSERT INTO mibNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","suu jeē jnáma ya yohó núū ñáyuu cájito uhū yohó, návāha cuajníñu yó núū yā, te ma yūhu yó i. ");
INSERT INTO mibNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Te coo ndaā coo ndoo ánuá yō, cuajníñu yó núū yā tāca quɨ́vɨ jeē cótecu yō. ");
INSERT INTO mibNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Te róhó súchi lúlí, cuu ró tée nacani jnūhun Yaā cujéhnu téyɨ́. Chi cosnūu ró ichi núú maá Jítoho yō, návāha sátūhva ró ñáyuu, te sáá te quiji ya. ");
INSERT INTO mibNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Te castūhun ró nuū ñáyuu maá yá jeē jnáma ya i, jíín jéē cóne cáhnu ni yā nuū tāca cuéchi i. ");
INSERT INTO mibNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chi Yaā Dios maá yó, vāha ni yā te cúndáhú ni yā yohó. Jeē yúcuan tají yá maá Yaā jeē sáha jeē cúndijin ini anuá yō, quiji ya nde andɨvɨ́, ");
INSERT INTO mibNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","návāha jecūhun ni yohó jéē cáyūcu nájnūhun nuū néē nuū jé yajni cuu yō. Te chuhun ya yohó ichi nuū cóo ndeyɨ́ coo sɨɨ̄ ni yō. Achí Zacarías. ");
INSERT INTO mibNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Te sūchi lúlí un ní jehnu i te ni ije i jíín jnúhun ya. Te ni condee i nde nuū ñúhun téhé ndé quɨvɨ̄ ní quenda ndijin i nuū ñáyuu Israel. ");
INSERT INTO mibNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Te ni cuu jecu quɨvɨ̄, te Augusto, tēe cúu rey, ni ndacu de jniñu jeē coo censo jeē núcosō sɨhvɨ́ ndɨvii ñayuu nɨɨ́ cáhnu nuū ndácu de jniñu. ");
INSERT INTO mibNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yāha cúu censo xīhna ñúhún jéē ní casáha de ná ni cuu Cirenio gobernador nación Siria. ");
INSERT INTO mibNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Te ndɨvii ñayuu cuanungoo i ná ñuu ná ñuu maá i jeē nácuāha i sɨ́hvɨ́ i. ");
INSERT INTO mibNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Te suni José ni quenda de ñuu Nazaret, ndañúū Galilea. Te cuanuhun de región Judea, te ni najinū de ñuu Belén, jeē cúu ñuu nuū ní cacu rey David jenahán. Chi sēhe yucūn David cúu de. ");
INSERT INTO mibNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Te ni jehēn de návāha nacuāha de sɨ́hvɨ́ de jíín María, chi je yajni quijnáhan ña jíín de. Te ñúhun sēhe ña ni sáha Espíritu Santo. ");
INSERT INTO mibNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Te níní cáhīin de yūcuán te ni jinū quɨvɨ̄ jeē cácu sēhe ña. ");
INSERT INTO mibNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Te ni scácu ña sēhe yɨɨ́ núú ña, te ni chusúcún ña i sahma cuitá, te ni jequin ña i ini ɨɨn nundōo núū yéji quɨtɨ, chi tuá núne mesón condee ña. ");
INSERT INTO mibNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Te yajni ñuu Belén cáhīin tēe cácuu pastor, te cándito de lanchi de nɨ́ɨ́ niñu jecuáā nde yucu ún. ");
INSERT INTO mibNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Te ɨɨn sanaa‑ni te ni cane ɨɨn ndajéhé maá Jítoho yō nuū de, te nduva máá Jítoho yō ni ndindēe nɨ́ɨ́ núū cáhīin de. Te yōhyo ni cayūhú de. ");
INSERT INTO mibNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Te ni cahān ndajéhé un jíín de: Ma yūhu ró jijnáhan ró, chi vēji ri castūhun rí jnūhun vāha nuū rō, te sáha jeē cúsɨɨ̄ ndasɨ́ ni tāca ñáyuu: ");
INSERT INTO mibNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Chi vijna nde ini ñuu David ni cacu ɨɨn Yaā jnama róhó, te máá Jítoho yō Cristo cúu ya. ");
INSERT INTO mibNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Te súcuan nacuni rō sūchi yɨ́quɨ́n un, chi ñúsúcún i sahma cuitá te cátú i ini ɨɨn nundōo núū yéji quɨtɨ. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Te ɨɨn sanaa‑ni te ni canecoo cuehē gā ndajéhé andɨvɨ́, cáhīin ya jiín ndajéhé un, te cácahān yā jeē yóhyo vāha Yaā cúu Yaā Dios. Te áchí yá: ");
INSERT INTO mibNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Yōhyo luu cújéhnu Yaā Dios nde nuū sucún. Te na ndúvāha ni tāca ñáyuu ñayɨ̄vɨ, sáha ya jeē cúsɨɨ̄ ni yā jiín i. Achí táca ndajéhé. ");
INSERT INTO mibNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yūcuán na te cuanungoo ndajéhé un andɨvɨ́. Te tēe cácuu pastor ni cacahān de jíjnáhan de: Na quíhín yō nde ñuu Belén, te cuni yō na vé ni cuu jeē ní castūhun máá Jítoho yō nuū yō, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Te yachī cuangoo de, te ni nanihīn de María jiín José jiín súchi yɨ́quɨ́n un, cátú i ini nundōo núū yéji quɨtɨ. ");
INSERT INTO mibNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Te nuū ní cajini de nuū i, te ni canacani de jnūhun jeē ní cachi ndajéhé yā nuū de sɨquɨ̄ sūchi yɨ́quɨ́n un. ");
INSERT INTO mibNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Te ni canaa ni tāca ñáyuu cájini nahín i jnūhun cácahān tēe cácuu pastor. ");
INSERT INTO mibNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Te María, ni quendōo tāca jnúhun yáha nuū jeē níjnūní ña, te nácani ni ña sɨquɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Te tēe cácuu pastor cuanungoo de, te ni cacahān de jeē yóhyo vāha Yaā cúu Yaā Dios sɨquɨ̄ tāca jéē ní cajini sōho de jíín jéē ní cajito de, chi ni squícu nahín nájnūhun ni cahān ndajéhé yā jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Te ni cuu unā quɨvɨ̄ jeē ní cacu ya, te ni casáha de circuncidar sūchi yɨ́quɨ́n un. Te ni casnání de i Jesús, chi sɨ́hvɨ́ yúcuan ní cachi ndajéhé yā nuū María nde ná tu jecūhun i. ");
INSERT INTO mibNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Te ni jīnu quɨvɨ̄ jeē casquícu ña costumbre jeē ndúndoo ña nuū Yaā Dios jijnáhan ña, nájnūhun cáhán ley jeē ni jéhe ya nuū Moisés. Te ni jengoo de jíín i ñuu Jerusalén jeē nácuāha de i nuū maá Jítoho yō Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Súcuan ni casáha de, chi yósó núū tútu ley yā: Tāca súchi yɨ́ɨ́ núú jéē cácacu, quɨhɨ cuenta i nuū Jítoho yō Yaā Dios, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Te suni cuasocō de nájnūhun cáhán ley maá Jítoho yō: Socō rō uū lɨvɨ chí úū paloma, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Te ni īyo ɨɨn tēe nání Simeón, ndéé de ñuu Jerusalén tiempo un. Te tēe ndaā, tēe chíñúhún váha nuū Yaā Dios cúu de. Te ñúhun ni de jeē quée maá Yaā jnama ñayuu nación de Israel. Te máá Espíritu Santo íyó yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Te je ni castūhun yá nuū de jeē ma cúū cuɨtɨ de chi nde coto de nuū Cristo jeē tají maá Jítoho yō Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Te ni steén yā nuū de jeē quihín de templo quɨvɨ̄ ún. Te suni tátá naná sūchi yɨ́quɨ́n Jesús, ni quɨ̄vɨcoo de ini templo jiín i, jeē nácuāha de i nuū Yaā Dios nájnūhun cáhán ley Moisés. ");
INSERT INTO mibNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Te Simeón ni ñunundee de i, te ni cahān de jeē yóhyo vāha Yaā cúu Yaā Dios, te áchí de: ");
INSERT INTO mibNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Tátā Yaā Dios, vijna te cuu cuāha ni jnúhun jeē cuu ná, chi je ni cusɨɨ̄ ni ná. Chi je ni squícu ní jnúhun ni jejnūhun ní núū sāña jéē cúu ná mozo ni. ");
INSERT INTO mibNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chi ni jito jínúū na núū Yaā jnáma sāña jíjnáhan ná. ");
INSERT INTO mibNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Chi ni jeni ní yá jeē jnáma ya tāca ñáyuu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Te máá yá sáha jeē cúndijin ini anuá ñayuu tācá nación, návāha jecūhun ni i sɨquɨ̄ ní. Te sáha ya jeē cujéhnu ñayuu maá ní Israel. Achí Simeón. ");
INSERT INTO mibNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Te José jiín náná i cánaa ni de cájini nahín de jnūhun ni cahān Simeón sɨquɨ̄ i. ");
INSERT INTO mibNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Te ni jicān tahú Simeón jehē de jíjnáhan de, te ni cahān de jíín náná i María: Sūchi yáha vēji i jeē candíje cuehē ñayuu nación yō Israel, te cācu i jíjnáhan i. Te sava i ma candíje i, te jnahnū ndetū i. Chi cúu i Yaā ní tají Yaā Dios, te sa squéhichī ni cuehē ñayuu i. ");
INSERT INTO mibNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Te súcuan te quenda ndijin ndese cájeni ni tāca ñáyuu. Te máá ró chi jnahuhū ndasɨ́ ni rō coto ró jéē ndóho i. Achí Simeón. ");
INSERT INTO mibNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Te suni íne ɨɨn ñahan nácani jnūhun Yaā Dios, naní ña Ana. Te sēhe Fanuel, yucūn Aser cúu ña. Te je jéhnu ndasɨ́ ña. Te nde ná lulí ña te ni condee ña jíín yɨɨ ña uxā cuiyā. ");
INSERT INTO mibNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yūcuán na te ni quendōo ndáhú ña, te ni cuu cuūn xico cuūn cuiyā ña. Te tu cújiyo ña ini vehe iī, chi jéjníñu ña nuū Jítoho yō Yaā Dios nduú ñuú, te ndite ni ña te jícán tahú ña. ");
INSERT INTO mibNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Te suni hora un ní quee ña, te ni nacuatáhú ña nuū Yaā Dios. Te ni cahān ña jnūhun sūchi yɨ́quɨ́n un jíín táca ñáyuu Jerusalén jeē cáñuhun ni i jeē quée Yaā jnama i. ");
INSERT INTO mibNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Te ni jīnu ni casquícu de tācá jniñu ndácu ley maá Jítoho yō Yaā Dios, te cuanungoo de ñuu de Nazaret, ndañúū Galilea. ");
INSERT INTO mibNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Te sūchi lúlí un ní jehnu i, te ni ije i, te ni cundíchí gá i. Te ni sáha Yaā Dios jeē váha ndasɨ́ jíín i. ");
INSERT INTO mibNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Te ndɨjnahan cuiyā jéngoo tátá i náná i ñuu Jerusalén, jeē cúu vico pascua. ");
INSERT INTO mibNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Te nuū ní cuu uxī uū cuiyā i, te cuangoo tucu de Jerusalén, nájnūhun sáha sáha de quɨvɨ̄ víco ún. ");
INSERT INTO mibNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Te ni yāha vico, te cuanungoo de. Te sūchi lúlí Jesús, ni quendōo i Jerusalén, te tu ní cájini José jiín náná i. ");
INSERT INTO mibNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Te cájeni ni de jeē cuahán i mēhñu ñáyuu cájica ichi ún. Te ni cajica de ɨɨn quɨvɨ̄, te sáá te ni cananducú de i mēhñu táca jnáhan de jíín ñáyuu cájini jnáhan de jíín. ");
INSERT INTO mibNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Te tu ní cánanihīn de i. Te ni canandicó de cuangoo de Jerusalén, cuananducú de i. ");
INSERT INTO mibNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Te nuū uní quɨvɨ̄ te ni cananihīn de i ini templo, néne i mēhñu tée cástéén tutu ley Yaā Dios, te jíni nahín i jeē cácahān de te cájnūhún i de sɨquɨ̄ jnúhun ún. ");
INSERT INTO mibNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Te tāca ñáyuu cájini jnūhun cáhán i, cánaa ni cájito jeē váha cájí xínī i te vāha nástíó cuɨ́ñɨ́ i jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Te nuū ní cajito tátá i náná i nuū i, te ni canaa ni de. Te ni cahān naná i jíín i: Séhē, ¿naun ni sáha ró súcuan jíín rí? Chi ruhū jiín tátá rō, yōhyo ni canacani ni rī cánanducú rí rohó, achí ña. ");
INSERT INTO mibNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yūcuán na te ni cahān i: ¿Naun cánanducú ní sāña? ¿A tu cájini ni jéē cánuú cocu ná jíín jniñu Tátá na Yaā Dios? Achí i. ");
INSERT INTO mibNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Te tu ní cájecūhun ni tátá i náná i jnūhun ni cahān i. ");
INSERT INTO mibNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yūcuán na te cuanuhun i jíín de jíjnáhan de ñuu Nazaret, te ni jendije i nuū de. Te náná i, ni quendōo tāca jnúhun yáha núū jeē níjnūní ña. ");
INSERT INTO mibNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Te Jesús ni jehnu ga i, te ni cundíchí gá i, te cúsɨɨ̄ ni Yaā Dios jiín i, te suni súcuan tāca ñáyuu. ");
INSERT INTO mibNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Te ni cuu xahūn cuiyā jeē ndácu Tiberio jniñu nɨ́ɨ́ nación. Te Poncio Pilato cúu de gobernador Judea, te Herodes cúu de gobernador Galilea, te ñani de Felipe cúu de gobernador Iturea jiín Traconite, te Lisanias cúu de gobernador Abilinia. ");
INSERT INTO mibNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Te sutū cujéhnu ga cácuu Anás jiín Caifás. Te ni quee jnūhun Yaā Dios nuū Juan sēhe Zacarías, jeē íne de nuū ñúhun téhé. ");
INSERT INTO mibNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Te ni jica nuu de tācá ñuu jeē iyó yajni yūte Jordán. Te cáhán de jíín ñáyuu jeē na nácani ni i jeē stóo i cuēchi i te cuandute i, návāha cone cáhnu ni Yaā Dios nuū cuéchi i. ");
INSERT INTO mibNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Te súcuan ni squícu jnūhun Juan jeē yosó nuū tútu ni tee Isaías, tēe ni nacani jnūhun Yaā Dios nde jenahán: Coo ɨɨn tēe cana jee nde nuū ñúhun téhé: Sátūhva ró máá ró jijnáhan ró, chi quee maá Jítoho yō. Te sáha ró jniñu ndaā, chi vēji ya. ");
INSERT INTO mibNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Te tāca xéhvā na ndúndaā, te tācá yucu jíín loma na ndúnduhvā, te na ndúyóhó ichi yácuá, te na ndúlɨɨ ichi ndáyɨ́. Te ndɨhɨ un cúu jeē ndúvāha ndundaā anuá ñayuu nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Te ndɨhɨ i cuni i jeē jnáma Yaā Dios i. Súcuan cahān Juan, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Te ni quendacoo cuehē ñayuu, cuahān i nuū de jeē scuándute de i. Te ni cahān de nuū i: Va sēhe coō cácuu ró, chi xeēn rō nájnūhun coō. ¿A cájeni ni rō jeē cuu cunu ró cācu ró núū castigo xeēn jeē quíji? ");
INSERT INTO mibNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Núu súcuan te sáha ró jniñu váha, te súcuan stéén rō jeē ní nacani ndije ni rō jeē stóo ró cuéchi ró. Te ma cáni ni rō cahān rō jeē cuu cācu ró sɨ́quɨ̄ jeē cácuu ró yúcūn Abraham. Chi cáhán rī jiín ró jeē cuu sáha Yaā Dios jeē tāca yúū yáha nduu sēhe Abraham jeē candíje vāha, te núu cúní yā. ");
INSERT INTO mibNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Te cácuu ró nájnūhun nundēhé jeē tu jéhe ndehē váha. Te vijna je íyó túhva Yaā Dios jeē cuáha ya castigo xeēn, nájnūhun je íyó túhva ɨɨn cāa jeē cahnde nde yoho yujnu. Núu súcuan te sáha ya jiín ró nájnūhun jíín táca yujnu jeē tu cúun ndehē váha, jeē tahndé te cayū nuū ñuhún. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Te ñayuu un ní cacajnūhún i de: ¿Te ndese sáha ná núu súcuan? Achí i. ");
INSERT INTO mibNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Te ni cahān de: Róhó jéē cánevāha uū sahma, na cuáha ró ɨɨn nuū jeē tu névāha. Te róhó jéē cánevāha jeē yéji, suni súcuan na sáha ró, áchí de jíín i. ");
INSERT INTO mibNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Te suni jecu tēe cástútú xúhun renta, ni quecoo de jeē cuándute de. Te ni cacajnūhún de Juan: Maestro, te máá ná, ¿ndese sáha ná jíjnáhan ná? ");
INSERT INTO mibNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Te ni cahān Juan jiín de: Ma scaá ró cácān rō xūhún, chi máá cúhva‑ni jeē ní ndacu jniñu nuū rō, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Te suni ni cacajnūhún jecu soldado: Te máá ná, ¿ndese sáha ná jíjnáhan ná? áchí de. Te ni cahān Juan jiín de: Ma quénde rō ndajníñu ni ɨɨn jíín jnúhun siúhú ni jíín jnúhun stáú yáhu, te cusɨɨ̄ ni rō jiín yáhu ró, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Te tāca ñáyuu cándetu i jeē quíji Cristo, Yaā jeē tají Yaā Dios, te cájeni ni i jeē sanaa te suu cúu Juan. ");
INSERT INTO mibNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Te ni cahān Juan jiín i jíjnáhan i: Ruhū chi jíín ndute scuándute ri rohó. Te vēji ɨɨn Yaā jeē nájnūhun scuándute ya rohó cúu jeē cuáha ya Espíritu Santo condee ini anuá rō, te poder yā cúu nájnūhun ñuhūn. Te cújéhnu ndasɨ́ yá, chi tú na vé jéhnu cuɨtɨ cúu ri nuū yā, ni jeē cuajníñu ri nuū yā vēsú ɨɨn jniñu lúlí gá nájnūhun jeē ndají rí vēsú correa ndijēn yā. ");
INSERT INTO mibNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Te sáha ya nájnūhun sáha tēe scánda trigo, chi sásɨ́ɨn ya ñayuu vāha jíín ñáyuu cunéé, nájnūhun cúndoo trigo jeē quénda sɨ́ɨn paja. Te nastútú yá trigo yā ndɨ̄vɨ ini yacā yā. Te paja chi jnaa yā nuū ñuhún jeē ma ndahvá cuɨtɨ. Achí Juan. ");
INSERT INTO mibNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Te súcuan te jíín cuéhē gā jnūhun ni stɨhvɨ́ ni de ñayuu un, ní nacani de jnūhun vāha Yaā Dios nuū i. ");
INSERT INTO mibNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Te suni ni cahān xeēn de nuū Herodes, tēe cúu gobernador, chi tēe un ní nacueca de Herodías, ñasɨhɨ́ ñani de Felipe. Te cuehē gā jniñu néé súcuan ni sáha Herodes. ");
INSERT INTO mibNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Te sa víhyá gā ni sáha de jeē neé gá, chi ni chune de Juan vecāa. ");
INSERT INTO mibNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Te nde ná tu quɨ̄vɨ Juan vecāa, ná ni ine de ni scuándute de tāca ñáyuu, te suni ni scuándute de Jesús. Te jícán tahú yā, te ni nune‑ni andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Te ni cuun Espíritu Santo ni quee xinī yā, te cáa nájnūhun ɨɨn paloma. Te ichi ándɨvɨ́ ní cahān ɨɨn jnūhun: Máá ró cúu Sēhe ri jeē maní ndasɨ́ rí jiín, te yōhyo cúsɨɨ̄ ni rī jiín ró, achí. ");
INSERT INTO mibNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Te ná ni quejéé Jesús steén yā jnūhun, te íyó yá nájnūhun ocō uxī cuiyā. Te cájeni ni ñayuu jeē séhe José cúu ya. Te José ni cuu sēhe Elí, ");
INSERT INTO mibNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","te Elí ni cuu sēhe Matat, te Matat ni cuu sēhe Leví, te Leví ni cuu sēhe Melqui, te Melqui ni cuu sēhe Jana, te Jana ni cuu sēhe José, ");
INSERT INTO mibNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","te José ni cuu sēhe Matatías, te Matatías ni cuu sēhe Amós, te Amós ni cuu sēhe Nahum, te Nahum ni cuu sēhe Esli, te Esli ni cuu sēhe Nagai, ");
INSERT INTO mibNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","te Nagai ni cuu sēhe Maat, te Maat ni cuu sēhe Matatías, te Matatías ni cuu sēhe Semei, te Semei ni cuu sēhe José te José ni cuu sēhe Judá, ");
INSERT INTO mibNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","te Judá ni cuu sēhe Joana, te Joana ni cuu sēhe Resa, te Resa ni cuu sēhe Zorobabel, te Zorobabel ni cuu sēhe Salatiel, te Salatiel ni cuu sēhe Neri, ");
INSERT INTO mibNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","te Neri ni cuu sēhe Melqui, te Melqui ni cuu sēhe Adi, te Adi ni cuu sēhe Cosam, te Cosam ni cuu sēhe Elmodam, te Elmodam ni cuu sēhe Er, ");
INSERT INTO mibNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","te Er ni cuu sēhe Josué, te Josué ni cuu sēhe Eliezer, te Eliezer ni cuu sēhe Jorim, te Jorim ni cuu sēhe Matat, ");
INSERT INTO mibNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","te Matat ni cuu sēhe Leví, te Leví ni cuu sēhe Simeón, te Simeón ni cuu sēhe Judá, te Judá ni cuu sēhe José, te José ni cuu sēhe Jonán, te Jonán ni cuu sēhe Eliaquim, ");
INSERT INTO mibNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","te Eliaquim ni cuu sēhe Melea, te Melea ni cuu sēhe Mainán, te Mainán ni cuu sēhe Matata, te Matata ni cuu sēhe Natán, ");
INSERT INTO mibNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","te Natán ni cuu sēhe David, te David ni cuu sēhe Isaí, te Isaí ni cuu sēhe Obed, te Obed ni cuu sēhe Booz, te Booz ni cuu sēhe Salmón, te Salmón ni cuu sēhe Naasón, ");
INSERT INTO mibNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","te Naasón ni cuu sēhe Aminadab, te Aminadab ni cuu sēhe Aram, te Aram ni cuu sēhe Esrom, te Esrom ni cuu sēhe Fares, te Fares ni cuu sēhe Judá, ");
INSERT INTO mibNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","te Judá ni cuu sēhe Jacob, te Jacob ni cuu sēhe Isaac, te Isaac ni cuu sēhe Abraham, te Abraham ni cuu sēhe Taré, te Taré ni cuu sēhe Nacor, ");
INSERT INTO mibNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","te Nacor ni cuu sēhe Serug, te Serug ni cuu sēhe Ragau, te Ragau ni cuu sēhe Peleg, te Peleg ni cuu sēhe Heber, te Heber ni cuu sēhe Sala, ");
INSERT INTO mibNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","te Sala ni cuu sēhe Cainán, te Cainán ni cuu sēhe Arfaxad, te Arfaxad ni cuu sēhe Sem, te Sem ni cuu sēhe Noé, te Noé ni cuu sēhe Lamec, ");
INSERT INTO mibNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","te Lamec ni cuu sēhe Matusalén, te Matusalén ni cuu sēhe Enoc, te Enoc ni cuu sēhe Jared, te Jared ni cuu sēhe Mahalaleel, te Mahalaleel ni cuu sēhe Cainán, ");
INSERT INTO mibNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","te Cainán ni cuu sēhe Enós, te Enós ni cuu sēhe Set, te Set ni cuu sēhe Adán, te Adán ni cuu sēhe Yaā Dios, chi ni sáha ya de. ");
INSERT INTO mibNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Te Jesús ni cunuú Espíritu Santo ini yā, te ni quenda ya yūte Jordán cuahān yā. Te ni jinū yā nde nuū ñúhun téhé ní sáha Espíritu Santo. ");
INSERT INTO mibNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Te ni ine ya yūcuan úū xico quɨvɨ̄, te ni jito ndee jexeén yā, chi cúní jeē sáha ya cuēchi. Te tāca quɨ́vɨ̄ ún tu ní yéji cuɨtɨ yā, te ná ni yāha quɨvɨ̄ ún, te jíí yā sōco. ");
INSERT INTO mibNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yūcuán na te ni cahān jexeén un jíín yá: Núu máá ró cúu Sēhe Yaā Dios, te cahān rō jeē yuū yáha na ndúu staā caji rō, achí. ");
INSERT INTO mibNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Te ni cahān Jesús jiín: Tuú chi yósó núū tútu iī: Nasūu máni máá jíín stáā cátecu ñayuu, chi suni jíín táca jnúhun cáhán Yaā Dios, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yūcuán na te cuahān jexeén un jíín yá nde xinī ɨɨn yucu súcún, te ɨɨn núnúu‑ni ni steén nuū yā tācá nación nɨɨ́ cáhnu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Te ni cahān jiín yá: Nuū maá ró cuāha ri jeē cujéhnu ró núū ndɨvii nación yáha, chi yōhyo luu cáa. Chi máá rí jnɨ́ɨ ndɨhɨ, te cuu cuāha ri nuū ndé ɨɨn cúní rī. ");
INSERT INTO mibNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Núu súcuan te núu cuɨñɨ yɨ́tɨ́ ró chiñúhún ró ruhū, te cuāha ndɨhɨ ri nuū rō. Achí jexeén. ");
INSERT INTO mibNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Te ni cahān Jesús jiín: Satanás, cujiyo quihīn rō, chi yósó núū tútu jeē chiñúhún ñayuu maá Jítoho i Yaā Dios, te nuū maá‑ni ya cuajníñu i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yūcuán na te cuahān jexeén un jíín yá nde ñuu Jerusalén. Te ni jeni ya xinī torre templo. Te ni cahān jiín yá: Te núu Sēhe Yaā Dios cúu ró, te sɨ́ngava ró máá ró nde nuū ñúhun, chi jnama ya rohó. ");
INSERT INTO mibNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Chi yósó núū tútu: Tejníñu ya ndajéhé yā quijicoo coto róhó. ");
INSERT INTO mibNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Te cunundee yā rohó jíjnáhan ya, návāha ma cáchihi ró jéhē rō nuū yuú. Achí tutu. Achí jexeén. ");
INSERT INTO mibNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Te ni cahān Jesús: Tuú chi suni yósó núū tútu jeē ma cóto ndee ñayuu Jitoho i Yaā Dios, núu jnama ya i chí tuú, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Te tuá ni níhín jexeén modo coto ndee Jesús quɨvɨ̄ ún, te ni cujiyo cuahān jecu‑ni tiempo. ");
INSERT INTO mibNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Te ni cunuú fuerza Espíritu Santo ini Jesús, te cuanuhun yā Galilea. Te nɨ́ɨ́ región yajni yūcuan ní jitē núu jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Te ni steén yā jnūhun ini tācá vehe iī sinagoga, te ndɨhɨ ñayuu ni cajejnúhún i ya. ");
INSERT INTO mibNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Te ni najinū yā ñuu Nazaret nuū ní jehnu ya. Te quɨvɨ̄ ndétātú ni quɨ̄vɨ ya ini vehe iī sinagoga, nájnūhun sáha sáha ya. Te ni ndocuɨñɨ̄ yā jeē cahu ya tutu iī. ");
INSERT INTO mibNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Te ni cajēhe de tutu ni tee Isaías, tēe ni nacani jnūhun Yaā Dios nde jenahán. Te ni nune ya tutu ún, te ni nanihīn yā nuū yosó jnúhun ni cahu ya: ");
INSERT INTO mibNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu maá Jítoho yō Yaā Dios iyó yá jiín rí, chi ni tejníñu ya ruhū jeē nácani ri jnūhun vāha nuū ñáyuu ndahú. Te ni tají yá ruhū vēji ri jiín jnúhun jeē ndúvāha ni ñayuu cácucuíhyá ni. Te castūhun rí nuū ñáyuu cáyɨhɨ ndaha jexeén jeē coo libre i. Te sáha ri jeē ndúndijin ini anuá ñayuu tu cájecūhun ni, te jnama ri ñayuu jeē cándoho i sáha jnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Te nacani ri jnūhun jeē ní quee tiempo jeē sáha Jitoho yō Yaā Dios jeē váha ñayuu. Achí tutu ni cahu ya. ");
INSERT INTO mibNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Te ni nacasɨ yā tutu ún, te ni nacuāha ya nuū tée jéjníñu ini sinagoga, te ni nucōo ya jeē steén yā jnūhun nuū ñáyuu cáhīin ini sinagoga. Te tācá i cájito vāha i nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Te ni quejéé yá cahán yā jiín i: Vijna te ni squícu jnūhun cáhán tutu iī yāha ní cajini sōho ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Te ndɨvii i ni cacahān jeē váha tēe cúu ya, te cánaa ni i jeē ní cajini i tāca jnúhun luu ni cahān yā. Te ni cacajnūhun jnáhan i: ¿A násūu séhe José cúu tēe yáha? ");
INSERT INTO mibNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Te ni cahān yā jiín i: Jíní vāha ri jeē cájeni ni rō cahān rō jnūhun yátá yáha jíín rí: Tēe tájná, sátájná ró maá ró núu súcuan. Te jnūhun yáha cúní cahān jeē nájnūhun ni nasávāha ri cuehē ñayuu cácuhū ini ñuu Capernaum ni canihīn rō jnūhun, suni súcuan na sáha ri ñuu yō yāhá návāha candíje ró cájeni ni rō. Achí yá jiín i. ");
INSERT INTO mibNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Te ni cahān gā yā: Jendaá cahán rī jiín ró, ni ɨɨn tēe nácani jnūhun Yaā Dios, tu cájetáhú ñayuu ñuu maá de nuū de. ");
INSERT INTO mibNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Te suni jendaá cahán rī jiín ró jeē ni íyo cuehē ñahan ní ndóo ndáhú ini nación yō Israel, tiempo ni cotecu Elías, tēe ni nacani jnūhun Yaā Dios. Te tiempo un tu ní cúun cuɨtɨ saū unī cuiyā yosáva, te ni īyo ɨɨn jnamā xeēn nɨɨ́ cáhnu nación. ");
INSERT INTO mibNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Te tu ní tájí Yaā Dios Elías quihīn de nuū ni ɨɨn ñahan viuda nación yō Israel, chi nuū máá ɨɨn‑ni ñahan viuda jeē ndeé ñuu Sarepta ndañúū Sidón, ni jehēn de ni jito de jeē ní yeji ña. ");
INSERT INTO mibNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Te ini nación yō Israel suni ni īyo cuehē tēe ni candoho cuehyɨ̄ stehyú, tiempo jeē ní cotecu Eliseo, tēe ni nacani jnūhun Yaā Dios. Te ni ɨɨn de tu ní cándíje jeē ndúvāha de sáha Eliseo, chi sa suhva máñúhún‑ni Naamán, tēe nación Siria ni nduvāha. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yūcuán na te tāca ñáyuu cáhīin ini sinagoga, yōhyo ni caquɨtɨ̄ ni i jnūhun ní cahān yā. ");
INSERT INTO mibNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Te ni candocuɨñɨ̄ i, te ni caquenehen i ya yatā ñúū ún, cuahān i jíín yá xinī yúcu íne ñuu ún, chi cácuni i chundahá i ya nɨnga ya cava ún. ");
INSERT INTO mibNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Te tu ní cúu sáha i, chi ni yāha‑ni ya mēhñú i cuahān yā. ");
INSERT INTO mibNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yūcuán na te cuahān Jesús ñuu Capernaum región Galilea. Te quɨvɨ̄ ndétātu ní steén yā jnūhun nuū ñáyuu. ");
INSERT INTO mibNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Te ni canaa ni i cájini i jnūhun stéén yā. Chi ni steén vāha ya nuū i, chi jíní vāha máá yá. ");
INSERT INTO mibNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Te ini vehe sinagoga un íne ɨɨn tēe jeē ñúhun tachī xeén ini de. Te tēe un ní cana cóhó de: ");
INSERT INTO mibNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Cujiyo ní. ¿Naun vēji ní núū na jíjnáhan ná, Jesús ñuu Nazaret? ¿A véji ní jéē snáā ni sáña, chí naún? Je jíní na ndé ɨɨn cúu ní, chi Sēhe iī Yaā Dios cúu ní. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Te Jesús ni cahān xeēn yā nuū tachī ún: Casɨ yuhu ró te quenda ró ini tēe yáha, áchí yá. Te ni cotúú‑ni tēe un núū tāca ñáyuu, ni sáha tachī ún. Te ni quenda ini de cuahān, te tú na vé ni sáha ga jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Te ndɨhɨ ñayuu un ní cayūhú i, te ni cacahān i jíín jnáhan i: ¿Na jnūhun cúu yāha jéē ní cuu súcuan? Chi cújéhnu tēe yáha jéē ndácu nīhin de jniñu nuū tachí, te quéndacoo‑ni, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Te jnūhun ya ni jitē núu cuahān nɨɨ́ cáhnu región yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yūcuán na te ni quenda Jesús ini vehe iī sinagoga, te cuahān yā te ni jinū yā vehe Simón. Te náná chīsó Simón, yɨ́hɨ xeēn quīji ña, te ni cacahān ndahú de jíín yá jehē ña. ");
INSERT INTO mibNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Te ni jīta ndeyɨ ya nuū ña, te ni cahān yā jeē na ndíco quīji ún. Te ni nduvāha‑ni ña. Te ni ndocuɨñɨ̄‑ni ña, te ni sáha ña jeē ní yeji yā jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Te jeē ni quée niāndii, te tāca ñáyuu jeē iyó jnáhan i cácuhū ndɨnuū cuehyɨ̄, ni caquindeca i jnáhan i un núū yā. Te ni soó yá ndaha ya sɨquɨ̄ ɨɨn ɨɨn i, te súcuan ni nasávāha ya i. ");
INSERT INTO mibNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Te suni cuehē ñayuu ni quendacoo tachī ini i, te cácana cóhó táchī ún: Máá ní cúu Sēhe Yaā Dios, achí. Te ni cahān xeēn yā nuū, te tu ní jéhe ya jnūhun jeē cahán gā súcuan, chi cájini jeē maá yá cúu Cristo, Yaā ní tají Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Te nuū ní cundijin, te ni quenda ya cuahān sɨ́ɨn ya yatā ñúū nuū tú ñayuu. Te tāca ñáyuu cánanducú i ya, te ni jinūcoo i nuū íne ya. Te cástétu i ya jeē tú cujiyo ya nuū i. ");
INSERT INTO mibNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Te ni cahān yā jiín i: Suni cánuú jéē nacani ri jnūhun vāha nuū tāca gá ñuu sɨquɨ̄ ndese ndácu Yaā Dios jniñu, chi jeē yúcuan ní tají yá ruhū vēji ri. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Te ni jica cuu ya nɨɨ́ región Galilea, nácani ya jnūhun ini tācá vehe iī sinagoga. ");
INSERT INTO mibNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Te ɨɨn quɨvɨ̄ te íne Jesús yumar Genesaret. Te ni quecoo cuehē ñayuu, te ni chitú níhin i nuū yā, chi cácuni i cuni nahín i jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Te ni jito ya jeē yúcu uū barco yajni yumar. Te tēe cájnɨɨ chācá, je ni quendacoo de ini barco, te cánacate de ñunu de. ");
INSERT INTO mibNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Te ni quɨ̄vɨ ya ini ɨɨn barco jeē cúu barco Simón. Te ni cahān yā jiín de jeē na scáca yátá de quihīn jecu gā nuū ndúte. Te ni cucōo ya, te nde ini barco un ní steén yā jnūhun nuū ñáyuu cuehē jeē yúcu i yundúte un. ");
INSERT INTO mibNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Te nuū ni jínu ni steén yā, te ni cahān yā jiín Simón: Scáca ró barco na quíhín yō nde nuū iyó cúnú ndute, te sɨ́nga ró ñunu ró jnɨɨ ró cháca, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Te ni cahān Simón: Maestro, nɨ́ɨ́ niñu ni casɨ́nga ná ñunu jeē jnɨɨ ná tɨ́, te tu ní níhín cuɨtɨ ná ni ɨɨn tɨ. Te jeē cahán maá ní súcuan, te na sɨ́nga tucu ná ñunu, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Te ni casɨ́nga de, te ni quɨ̄vɨcoo cuehē ndasɨ́ cháca, nde nducú táhndē ñunu de. ");
INSERT INTO mibNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Te ni cacaja ndahá de nuū jnáhan de cáhīin ini ɨnga barco, na quíjicoo chindéé ñájnáhan jíín de. Te ni quecoo de, te ni cascútú ndɨ́ɨ̄ de tɨ ndɨndúú barco, te nde je yajni quēe barco. ");
INSERT INTO mibNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Te ni jito Simón Pedro jeē súcuan ni cuu. Te ni jecuɨñɨ̄ yɨtɨ́ de nuū Jesús, te ni cahān de: Cujiyo ní núū ná, chi tēe íyó cuéchi cúu ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chi máá de jíín táca tée cáhīin jíín de, ni cayūhú de jeē ní canihīn de cuehē chācá un ní sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Te suni ni cayūhú Jacobo jiín Juan, ndɨndúú séhe Zebedeo, chi tēe chíndéé ñájnáhan jíín Simón cácuu de. Te ni cahān Jesús jiín Simón: Ma yūhu ró, chi nde vijna te sáha ri jeē nihīn rō cuehē ñayuu candíje ruhū, nájnūhun ni nihīn rō cuehē chācá. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yūcuán na te nuū ni jínūcoo de jíín barco nuū ñúhun íchi, te ni castóo de ndɨhɨ ndajníñu de, te ni candiquīn de ya cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yūcuán na te íne Jesús ini ɨɨn ñuu, te ni quee ɨɨn tēe ndóho cuehyɨ̄ stehyú. Te ni jito de nuū Jesús, te ni jecuɨñɨ̄ yɨtɨ́ de ni jequīn de nuū de nde nuū ñúhun, te ni cahān ndahú de jíín yá: Jíní na jéē cuu sáha ní jéē nduvāha ná, te núu cúní ni, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yūcuán na te ni soó yá ndaha ya sɨquɨ̄ de, te ni cahān yā: Cúní rī. Te na ndúvāha ró, áchí yá. Te ná ni cahān yā súcuan, te ni nduvāha‑ni tēe ndóho cuehyɨ̄ stehyú un. ");
INSERT INTO mibNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Te ni ndacu ya jniñu nuū de jeē ma cáchi cuɨtɨ de nuū ní ɨɨn. Te áchí yá: Quisteén rō maá ró nuū sutú, te condahá ró jeē socó rō nuū Yaā Dios sɨquɨ̄ jeē ndúndoo ró núū yā, nájnūhun ni ndacu Moisés jniñu jenahán. Te súcuan te cuni ñayuu jeē ní nduvāha ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Te víhyá gā ni jitē núu jnūhun ya cuahān. Te ni cataca cuehē ñayuu jeē cúni nahín i jnūhun stéén yā, jiín jéē nasávāha ya i nuū tāca cuéhyɨ̄ cándoho i. ");
INSERT INTO mibNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Te máá yá cuahān sɨ́ɨn ya nuū tú ñayuu, te ni jicān tahú yā. ");
INSERT INTO mibNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Te ɨɨn quɨvɨ̄ te stéén yā jnūhun, te jecu tēe grupo fariseo jiín tée cástéén tutu ley Yaā Dios, cáyūcú de yūcuán. Te tēe un ní quecoo de nuū yā jeē véjicoo de tācá ndañúū Galilea, jiín ndañúū Judea, jiín ñuu Jerusalén. Te poder maá Yaā Dios iyó jíín yá jeē nasávāha ya ñayuu cácuhū. ");
INSERT INTO mibNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yūcuán na te ni quecoo jecu tēe, cándiso de ɨɨn tēe ndóho cuehyɨ̄ ni íjin, cátú de nuū ɨɨn camilla. Te cánducú de squɨ́vɨ de tēe ún ini vehe, te caquin de nuū íne ya. ");
INSERT INTO mibNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Te tu ní cánihīn de modo quɨ̄vɨcoo de jíín tée un, chi cáyūcú chitú ñáyuu. Te ni cacoo de sɨquɨ̄ véhe, te ni canune de teja. Te ni cascúun de tēe cúhú un jíín camilla de nde nuū íne Jesús mēhñu ñáyuu. ");
INSERT INTO mibNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Te ni jini Jesús jeē cácandíje de jeē cúu nasávāha ya tēe cúhú un. Te ni cahān yā jiín tée cúhú un: Róhó, je íne cáhnu ni rī nuū tāca cuéchi ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yūcuán na te tēe cástéén tutu ley Yaā Dios jiín tée grupo fariseo, ni quejéé de cájeni ni de sɨquɨ̄ yā: ¿Ndé ɨɨn cúu tēe yáha jéē cahán de jnūhun ndevāha jeē quɨtɨ́ ni Yaā Dios? Chi nasūu Yáā Dios cúu de jeē cóne cáhnu ni de nuū cuéchi. ");
INSERT INTO mibNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Te ni jini Jesús jeē súcuan cájeni ni de, te ni cahān yā jiín de: ¿Naun cájeni ni rō jeē cahán ndevāha ri? ");
INSERT INTO mibNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Jeē uú jnūhun yáha, ¿ndé ɨɨn yɨɨ́ gá cáa? ¿A jéē cahán rī jiín tée cúhú: Je íne cáhnu ni rī nuū tāca cuéchi ró? ¿Chí yɨɨ́ gá jeē cahān rī: Ndocuɨñɨ̄ te caca ró, chi je ni nduvāha ró, achi rī? ");
INSERT INTO mibNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Te vijna te na stéén rī jeē maá rí, Yaā ní nduu tēe, ndíso jníñu ri ini ñayɨ̄vɨ yáha jéē cóne cáhnu ni rī nuū cuéchi. Yūcuán na te ni cahān yā jiín tée ni íjin ún: Cáhán rī jiín ró, ndocuɨñɨ̄ te naquihin ró camilla rō, te quinuhun rō vehe ró, áchí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Te ni ndocuɨñɨ̄‑ni tēe ún, jíto jínúū ñayuu. Te ni naquihin de camilla nuū ni cátu de, te cuanuhun de vehe de. Te nácuatáhú de nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Te yōhyo ni canaa ni tāca ñáyuu cájito i, te ni cacahān i jeē yóhyo vāha Yaā cúu Yaā Dios. Te suni yōhyo cáyūhú i, te cácahān i: Vijna te ni cajito yó jniñu jéhnu téyɨ́, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yūcuán na te ni quenda ya cuahān yā, te ni jito ya nuū ɨɨn tēe stútú xúhun renta, naní de Leví, néne de nuū cutútú xúhun renta. Te ni cahān yā jiín de: Condiquīn ruhū na quíhín yō. ");
INSERT INTO mibNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Te ni ndocuɨñɨ̄ de, te ni stóo de ndɨhɨ ndajníñu de, te cuahān de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yūcuán na te ni sáha Leví ɨɨn vico cáhnu vehe de, jeē cúsɨɨ̄ ni de jíín Jesús. Te cuehē tēe cástútú xúhun renta jiín sava ga tēe, cáyūcú de mesa cáyeji de staā jiín yá. ");
INSERT INTO mibNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Te tēe grupo fariseo jiín tée cástéén tutu ley Yaā Dios, ni quejéé de cácahān de sɨquɨ̄ tée cáscuáha jíín yá, te ni cacajnūhún de: ¿Najehē cáyeji rō cájihi ró jíín tée cástútú xúhun renta jiín tée cásáha cuēchi? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Te ni cahān Jesús: Ñayuu cáhīyo vāha, tu jíni ñúhún i tēe tájná, chi ñayuu cácuhū cúu jeē jíni ñúhún. ");
INSERT INTO mibNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Te ruhū nasūu jéē véji ri cana ri ñayuu tú cuēchi, jeē cúu i nájnūhun ñayuu cáhīyo vāha. Chi sa suhva vēji ri cana ri ñayuu cáhīyo cuēchi, jeē na nácani ni i te stóo i cuēchi i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yūcuán na te ni cacahān de jíín yá: Tēe cáscuáha jíín Juan, jiín tée cáscuáha jíín grupo fariseo, cuehē jínu cáhīyo ndite ni de te cájicān tahú de. Te tēe cáscuáha jíín máá ní, ¿naun tu cásáha de súcuan? Chi cáyeji de cájihi de. ");
INSERT INTO mibNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Te ni cahān yā jiín de: ¿A cuu condite ni de níní jéē iyó rí jiín de? ¿A cuu sáha ró jéē condite ni ñayuu cáhīin vico nándāha, te núu níní néne tēe nándāha? ");
INSERT INTO mibNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Te quee quɨvɨ̄ jeē cújiyo tēe ni nandāha, te quɨvɨ̄ ún chi condite ni i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Te suni ni cahān yā uū jnūhun yátá sɨ́quɨ̄ jeē tu quíjnáhan jnūhun jeé jéē steén yā jiín táca jnúhun jenahán. Achí yá: Ni ɨɨn ñayuu tu jéhnde i ɨɨn pedazo sahma jéé i, te nachuhun i nuū ɨɨn sahma túhú i. Chi núu súcuan te stɨ́vɨ i sahma jéé i, te suni tu quíjnáhan jeē jeé un jíín jéē tuhú. ");
INSERT INTO mibNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Te tú ni ɨɨn chúhun vino jeé ini ñɨɨ túhú. Chi núu súcuan, te vino jeé un ndatá ñɨɨ, te naa vino jiín ñɨɨ. ");
INSERT INTO mibNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chi cánuú jéē cúhun vino jeé ini ñɨɨ jéé, te súcuan te quéndōo vāha ndɨndúú. ");
INSERT INTO mibNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Te ñayuu cájihi vino áva, tu cúní i coho i jeē jeé, chi jeē áva cúu jeē váha ga, achí i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Te ɨɨn quɨvɨ̄ ndétātu ní yāha Jesús cuahān yā mēhñú nuū cáa trigo. Te tēe cáscuáha jíín yá ni cataxín de yoco trigo, te ni caquɨɨn de ini ndaha de, te ni cayeji de. ");
INSERT INTO mibNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Te sava tēe grupo fariseo ni cacajnūhún de: ¿Najehē casáha ró jniñu jeē tu íyó váha sáha ró quɨ́vɨ̄ ndétātú? ");
INSERT INTO mibNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Te ni cahān Jesús jiín de: ¿A tu ní cácahu cuɨtɨ rō tutu ndese ni sáha David, ɨɨn quɨvɨ̄ jeē ni jíī de sōco jíín tée cáhīin jíín de? ");
INSERT INTO mibNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Te ni quɨ̄vɨ de ini vehe Yaā Dios, te ni quihin de pan iī jeē yosó ndijin nuū Yaā Dios. Te ni yeji de, te suni ni jēhe de ni cayeji tēe cáhīin jíín de. Te tú na ley jeē cáji ni ɨɨn tēe, chi máá‑ni sutū cuu caji. Te vēsú súcuan te tú na cuēchi ní íyo sɨquɨ̄ de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Te ni cahān gā yā jiín de: Ruhū, Yaā ní nduu tēe, máá rí cúu jeē ndácu jniñu sɨquɨ̄ ndese sáha ñayuu quɨvɨ̄ ndétātú, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Te ɨnga quɨvɨ̄ ndétātú, suni ni quɨ̄vɨ ya ini vehe iī sinagoga, te ni steén yā jnūhun. Te yūcuan íne ɨɨn tēe ni ichī ndaha váha de. ");
INSERT INTO mibNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Te tēe cástéén tutu ley jiín tée grupo fariseo, cájito yuhu de ya núu nasávāha ya tēe un quɨ́vɨ̄ ndétātú, návāha nihīn de cuēchi sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Te máá yá je jíní yā ndese cájeni ni de. Te ni cahān yā jiín tée ni ichī ndaha ún: Ndocuɨñɨ̄, te condichi rō mēhñu yáha, áchí yá. Te ni ndocuɨñɨ̄ de, te ni jecondichi de mēhñú. ");
INSERT INTO mibNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yūcuán na te ni cahān yā jiín de jíjnáhan de: Na cájnūhun rí rohó ɨɨn jnūhun: ¿Ndese cáhán ley sɨquɨ̄ quɨvɨ̄ ndétātú? ¿A jéē sáha vāha yó, chí sáha néé yó? ¿A jéē nasávāha yó ñáyuu je yajni cuu, chí sáha yó jéē cúū i? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Te ndéhé yá nuū de jeē cáyūcú de nɨ́ɨ́ xiin ya. Te ni cahān yā jiín tée cúhú un: Scáá ndaha ró. Te ni scaá de, te ni nduvāha‑ni ndaha de. ");
INSERT INTO mibNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Te yōhyo ni caquɨtɨ̄ ni tāca tée un, te ni quejéé de cándajnūhún de sɨquɨ̄ Jesús, ndese cahni de ya. ");
INSERT INTO mibNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Te ni cuu jecu quɨvɨ̄, te ni quenda ya cuacacān tahú yā nde yucu. Te nɨ́ɨ́ niñu ni jicān tahú yā nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Te nuū ní cundijin, te ni cana ya tāca tée cáscuáha jíín yá. Te ni nacāji ya uxī uū de, te ni cahān yā jeē cuu de apóstol, condiso jníñu de nacani de jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Te yāha cúu sɨ́hvɨ́ de jíjnáhan de: Simón jeē ní nasnání yá de Pedro, jiín ñani de Andrés, te suni Jacobo jiín Juan, Felipe jiín Bartolomé, ");
INSERT INTO mibNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo sēhe Alfeo, Simón tēe grupo cananista, ");
INSERT INTO mibNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ñani Jacobo, jiín Judas Iscariote, tēe jeē ní nastúu de ya. ");
INSERT INTO mibNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Te ni nanuu ya yucu jíín táca tée un jéē cascuáha jíín yá, te ni jecuɨñɨ̄ yā ɨɨn nduhvā jiín de. Te cuehē ñayuu nɨɨ́ región Judea jiín ñuu Jerusalén, jiín ñáyuu yumar ñuu Tiro jiín ñuu Sidón, ni quecoo i jeē cúni nahín i jnūhun stéén yā, jiín jéē ndúvāha i cuehyɨ̄ cándoho i. ");
INSERT INTO mibNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Te ñayuu jeē ñúhun tachī ini i, suni ni canduvāha i ni sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Te ndɨvii ñayuu cácuni i quehé i ya, chi súcuan ndúvāha i sáha ya jiín poder yā. ");
INSERT INTO mibNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Te ni ndacoto ya nuū tée cáscuáha jíín yá un, te ni cahān yā: Yōhyo ndetū rohó jéē cándoho ndáhú, chi quɨ̄vɨ ró ñuu nuū ndácu Yaā Dios jniñu. ");
INSERT INTO mibNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Yōhyo ndetū rohó jéē cájiī sōco vijna, chi quiji quɨvɨ̄ jeē ndutú chīji ró. ’Yōhyo ndetū rohó jéē cándahyū rō vijna, chi quiji quɨvɨ̄ jeē cuecú rō. ");
INSERT INTO mibNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Yōhyo ndetū rō te núu cáquɨtɨ̄ ni ñayuu nuū rō jeē sɨquɨ́ ruhū, Yaā ní nduu tēe, te cásquéhichī i róhó, te cácahān neé i nuū rō, te cácahān i jeē ñáyuu casáha jniñu néé cácuu ró. ");
INSERT INTO mibNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Te na cóo sɨɨ̄ ni rō quɨvɨ̄ sáha i súcuan, te víhyá gā na cúsɨɨ̄ ni rō, chi cáhnu téyɨ́ coo tahū rō nde andɨvɨ́. Chi suni súcuan ni casáha uhū tāca jíí i jíín tée ni canacani jnūhun Yaā Dios nde jenahán. ");
INSERT INTO mibNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Te nacā jeē xeēn ndoho róhó ñáyuu cucá, chi vijna‑ni cúu jeē cáhīyo sɨɨ̄ ni rō. ");
INSERT INTO mibNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Nacā jeē xeēn ndoho róhó ñáyuu jeē víjna cáhīyo vetū chīji ró, chi quiji quɨvɨ̄ jeē cuu rō sōco. ’Nacā jeē xeēn ndoho róhó ñáyuu jeē víjna cájecū rō, chi quiji quɨvɨ̄ jeē nducuíhyá ni rō te ndahyū rō. ");
INSERT INTO mibNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Nacā jeē xeēn ndoho tāca ró núu cájejnúhún ñáyuu rohó, chi suni súcuan ni cajejnúhún jíí i tāca tée ni canacani jnūhun stáhú ndé jenahán. ");
INSERT INTO mibNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Te cáhán rī jiín róhó jeē cájini sōho: Cundáhú ni rō ñayuu cájito uhū rohó. Te sáha vāha ró jíín ñáyuu cáquɨtɨ̄ ni nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Te cacān rō jeē váha coo ñayuu cácahān ndevāha sɨ́quɨ̄ rō. Te cacān tahú rō jehē ñáyuu cácahān neé núū rō. ");
INSERT INTO mibNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Te núu ndé tée cani de ɨɨn lado yɨquɨ núú rō, te vāha ga suni cuāha ró ɨnga lado cani de, vēsú jeē nácuāha ró jéē ndútahū de. Te núu ndé tée cúní de quende de tɨcāchi ró, suni cuāha ró jnúhun jeē na quíhín de jíín ndé camisa rō. ");
INSERT INTO mibNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Te na‑ni ñayuu jicán nuū rō, te cuāha ró núū i. Te ñayuu quíhin ndajníñu ró, ma nándacān rō. ");
INSERT INTO mibNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Te nájnūhun cácuni rō jeē sáha vāha ñayuu jiín ró, suni súcuan na sáha vāha ró jíín i. ");
INSERT INTO mibNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Chi núu íyó mánī rō jiín máá‑ni ñayuu jeē maní jiín ró, ¿te na vé jeē váha ga sáha ró núu súcuan? Chi nde tēe cásáha cuēchi, suni manī de jíín tée manī jiín máá de. ");
INSERT INTO mibNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Te núu sáha vāha ró jíín máá‑ni ñayuu jeē casáha vāha jíín ró, ¿te na vé jeē váha ga sáha ró núu súcuan? Chi nde tēe cásáha cuēchi, suni súcuan cásáha de. ");
INSERT INTO mibNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Te núu cuāha núú ró núū maá‑ni ñayuu jeē ñúhun ni rō nacuāha i nuū rō, ¿te na vé jeē váha ga sáha ró núu súcuan? Chi nde tēe cásáha cuēchi, suni jéhe núu de nuū tāca gá tēe cásáha cuēchi, návāha nanihīn tucu de. ");
INSERT INTO mibNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Núu súcuan te cundáhú ni rō ñayuu cájito uhū rohó, te sáha vāha ró jíín i, te cuāha núú ró núū i. Te ma cuáha ró máá sɨ́quɨ̄ jeē cani ni rō jeē suni nacuāha i nuū rō. Te súcuan te cáhnu coo tahū rō, te stéén rō jeē cácuu ró séhe Yaā cujéhnu téyɨ́. Chi máá yá vāha ni yā jiín ñáyuu tu nácuatáhú núū yā jiín ñáyuu casáha néé. ");
INSERT INTO mibNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Núu súcuan te cundáhú ni rō ñayuu, nájnūhun máá Tátá rō cúndáhú ni yā i. ");
INSERT INTO mibNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ma cahán rō sɨquɨ̄ cuéchi ñayuu ndese sáha i, návāha suni ma cahán Yaā Dios cuēchi sɨquɨ̄ rō jeē casáha ró súcuan. Ma cahán xeēn rō sɨquɨ̄ i jeē tú vāha sáha i, návāha suni ma cahán Yaā Dios súcuan sɨquɨ̄ rō. Cone cáhnu ni rō nuū i, te suni cone cáhnu ni yā nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cuāha ró núū ñáyuu, te suni súcuan cuāha Yaā Dios nuū rō. Chi vāha ndasɨ́ cuáha ya nuū rō, nájnūhun jeē chícuāha váha ya, quɨsɨ ya, sánīhin ya, te nde scáa ya cuāha ya nuū rō. Chi cūhva jeē cájēhe ró núū ñáyuu, suni cūhva un cuáha ya nuū rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Te ni cahān yā ɨɨn jnūhun yátá jíín i: Tēe cástéén jnūhun tú ndaā, cácuu de nájnūhun tēe cuáá. Te ɨɨn tēe cuáá, ¿á cuu stéén de ichi nuū ɨnga tēe cuáá? ¿A tú nɨngava ndɨndúú de ini xehvā? ");
INSERT INTO mibNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ɨɨn tēe scuáha, tu cújéhnu de nuū maestro de. Te tēe scuáha ún, núu je ni cutūhva vāha de, te jinū de coo de nájnūhun maestro de. ");
INSERT INTO mibNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Te cuēchi jnáhan ró cúu nájnūhun jeē íne ɨɨn yāca lúlí tɨnūú i. ¿Te naun cásáha ró cuenta jeē súcuan, te tu cásáha ró cuenta cuēchi máá ró jeē cúu nájnūhun jeē íne ɨɨn nduhu tɨnūu máá ró? ");
INSERT INTO mibNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Te naun cácahān rō jiín jnáhan ró: Condetu, na táva rī yāca íne tɨnūu ró, te tu cánacani ni rō jeē íne ɨɨn nduhu tɨnūu máá ró? Tēe stáhú‑ni cácuu ró núu súcuan. Xīhna gā tɨnūu máá ró tava rō nduhu, te yūcuán na te cuu condēhe váha ró jéē táva rō yāca tɨ́nūu jnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Tu íyó yujnu váha jeē jéhe ndehē neé, te ni tu íyó yujnu néé jéē jéhe ndehē váha. ");
INSERT INTO mibNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chi jíín ndéhē jeē jéhe ɨɨn ɨɨn yujnu, te jíní yō núu yujnu váha cúu. Chi tu scóyo yó ndehē higo xinī íñu, ni tu scóyo yó ndehē uva xinī yucú zarza. ");
INSERT INTO mibNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Te suni súcuan tēe vāha, cáhán de jnūhun vāha, chi vāha ánuá de. Te tēe sáha néé cáhán de jnūhun néé, chi cánéé ánuá de. Chi modo ndese íyó ánuá ñayuu, máni jeē yúcuan cúu jeē cácahān i. ");
INSERT INTO mibNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Najehē cácahān yɨñúhún ró jiín rí: Jitoho ná, áchí ró, te tu cásquícu ró jniñu ndácu ri? ");
INSERT INTO mibNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tāca ñáyuu vēji nuū rī te jíni sōho jnūhun cáhán rī te squícu, na stéén rī nuū rō ndese cúu i. ");
INSERT INTO mibNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Cúu i nájnūhun ɨɨn tēe jeē ní jeni de vehe de, te ni jete cúnú de nde ni nihīn de toto, te ni jeni de sɨquɨ̄. Te nuū ní ndaa yūte, te ni chundahá vehe ún, te tu ní cánda cuɨtɨ sáha, chi sɨquɨ̄ toto íin. ");
INSERT INTO mibNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Te tāca ñáyuu jíni sōho jnūhun cáhán rī, te tu squícu i, cúu i nájnūhun ɨɨn tēe ni jeni de vehe de nuū ñúhun, te tu yɨ́tuu jehē. Te nuū ní ndaa yūte, te ni chundahá vehe ún, te ni cotúú‑ni, te ni naa iī‑ni. Achí yá jiín i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Te nuū ni jínu ni cahān yā ni cajini nahín ñáyuu ún, te cuahān yā ñuu Capernaum. ");
INSERT INTO mibNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Te ɨɨn tēe nación Roma jeē cúu capitán, íyó ɨɨn mozo de jeē manī ndasɨ́ de jíín. Te mozo un cúhú i te je yajni cuu i. ");
INSERT INTO mibNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Te ni jini capitán jnūhun Jesús. Te ni tají de jecu tēe jéhnu cándacu jniñu nuū ñáyuu hebreo, cuangoo de nuū yā jeē cahán ndahú de jíín yá jeē na quíji ya sávāha ya mozo de. ");
INSERT INTO mibNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Te ni jinūcoo tēe un núū Jesús, te ni cacahān ndahú ndasɨ́ de jíín yá: Chindéé ñáhán ní tēe cúu capitán, chi tēe vāha cúu de. ");
INSERT INTO mibNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Chi manī de jíín nación yō, te máá de ni ndacu jniñu ni cuvāha ɨɨn vehe sinagoga cuu yó. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yūcuán na te cuahān Jesús jiín de jíjnáhan de. Te nuū ní cuyajni ya vehe capitán, te ni tají de jecu amigo de cuajnahan yā. Te ni cacahān de jíín yá: Achí capitán jeē tu cúní de sájnéñu de níhín, chi tu cújéhnu de jeē quihín ni quɨ́vɨ ní vehe de. ");
INSERT INTO mibNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jeē yúcuan tu ní sájéhnu de máá de jeē quíji de nuū ní, áchí de. Te máá jéē cahán‑ni ní, te na ndúvāha‑ni mozo de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Chi máá de suni ndíso jníñu de ni casáha tēe cácujéhnu ga. Te cújéhnu de nuū tācá soldado de, áchí de. Te núu cáhán de jíín ɨɨn tēe jeē na quíhín de, te cuahān de. Te núu cáhán de jíín ɨnga tēe jeē na quíji de, te quíji de. Te núu ndácu de ɨɨn jniñu nuū mozo de, te sáha i, áchí de. Achí táca tée un jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Te jeē ní jini Jesús jnūhun yáha, te ni naa ni yā. Te ni ndió cóto ya ni cahān yā jiín ñáyuu cuehē cándiquīn yatā yā: Jendaá cahán rī jiín ró jeē ni nación yō Israel tu ní níhín rī ni ɨɨn ñayuu candíje nīhin súcuan, nájnūhun cándíje tēe ún, vēsú tēe nación tu jíní jnūhun Yaā Dios cúu de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Te tēe ni tají capitán nuū yā, ni najinūcoo de vehe, te ni cajito de jeē jé ni nduvāha mozo un. ");
INSERT INTO mibNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yūcuán na te cuahān yā ɨɨn ñuu naní Naín. Te tēe cáscuáha jíín yá, jiín ñáyuu cuehē, suni cuangoo i jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Te ná ni cuyajni ya yuñúū ún, te yūcuan ní quendacoo ñayuu jeē quíchindūji i ɨɨn tēe suchí jéē ni jíhī. Te máñúhún‑ni i nuū naná i, te ñahan viuda cúu ña. Te cuehē ñayuu ñuu un véjicoo jíín ña. ");
INSERT INTO mibNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Te ná ni jito máá Jítoho yō nuū ña, te ni cundáhú ni yā ña, te ni cahān yā jiín ña: Ma ndahyú ni, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yūcuán na te ni jinū yā nde nuū ndɨ́yɨ ún, te ni jnɨɨ ya yejnū, te ni cajecuɨñɨ̄ tēe cándiso ún. Te ni cahān yā jiín súchi ní jihī: Cáhán rī jiín ró, ndocuɨñɨ̄, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yūcuán na te ni nucōo sūchi ní jihī ún, te ni quejéé i nácahān i. Te ni nacuāha ya i nuū naná i. ");
INSERT INTO mibNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Te ndɨvii ñayuu ni cayūhú i jeē ní cajito i, te ni cacahān i jeē yóhyo vāha Yaā cúu Yaā Dios. Te cácahān i: Mēhñu yó ni quee ɨɨn tēe cújéhnu nácani jnūhun Yaā Dios. Te suni cácahān i: Máá Yaā Dios ni quejéé yá chindéé ñáhán yá ñayuu yā. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Te ni jitē núu jnūhun ya nɨɨ́ cáhnu región Judea jiín táca región yajni yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Te íne Juan vecāa, te tēe cáscuáha jíín de ni cacastūhun núū de jeē súcuan ni cuu tācá jniñu yáha. ");
INSERT INTO mibNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Te ni cana Juan uū tēe ún, te ni tají de cuangoo nuū Jesús, návāha cajnūhún de ya núu máá yá cúu ndije Cristo jeē ní cachi Yaā Dios jeē tají yá, chí núu nasūu yá cúu te condetu de ɨnga. ");
INSERT INTO mibNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Te ni jinūcoo tēe un núū yā, te ni cacahān de: Juan tēe scuándute ni tají de sāña véjicoo ná cajnūhun ná nihín núu máá ní cúu Cristo jeē achí tutu jeē quíji, chí condetu yó ɨnga tēe quiji. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Te máá hora un ní nasávāha ya cuehē ñayuu cácuhū, jiín ñáyuu cándoho cuehyɨ̄ xeēn, jiín ñáyuu ñúhun tachī ini. Te suni cuehē ñayuu cuaá ní ndundijin tɨnūú i ni sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Te ni cahān yā jiín de: Cuángoo te castūhun ró nuū Juan tācá jniñu ni cajito ró jíín jnúhun ni cajini ró. Te cachi rō nuū de jeē ñáyuu cuaá cánanune tɨnūú i, te ñayuu yacuá cánacaca i, te ñayuu ndóho cuehyɨ̄ stehyú cánduvāha i, te ñayuu sohó cánanune sōho i, te ñayuu jihí nátecu i sáha ri. Te suni nácani ri jnūhun nuū ñáyuu ndahú jéē jnama Yaā Dios i. ");
INSERT INTO mibNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Te yōhyo ndetū tēe jeē ma nácani yátá ni de jeē ruhū cúu Cristo. Súcuan cachi rō nuū Juan. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Te ná cuanuhun ndɨndúú tée ún, te ni quejéé Jesús cahán yā jnūhun Juan jiín ñáyuu: ¿Na vé ni jécondēhe ró jijnáhan ró ndé nuū ñúhun téhé? ¿A ɨɨn tēe jéni ɨɨn jéni uū ni, nájnūhun ite jeē cánda sáha tachī? ");
INSERT INTO mibNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Te núu tuú, ¿te na vé ni jécondēhe ró núu súcuan? ¿A ɨɨn tēe cúní cujéhnu jeē ñúhun sahma lúu? Tuú chi cájini rō jeē tée cáñuhun sahma lúu te cánducú tāca jéē cúsɨɨ̄ ni, máni ini vehe rey cáyūcú de. ");
INSERT INTO mibNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Te na vé ni jécondēhe ró núu súcuan? ¿A ɨɨn tēe nácani jnūhun Yaā Dios? Cáhán rī jiín ró jeē suu ni jecondēhe ró. Te cújéhnu ga Juan yáha vēsú tāca gá tēe ni canacani jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Chi jnūhun Juan cúu jeē ni cáhān Yaā Dios jeē yosó núū tútu iī: Tají rí tēe nacani jnūhun ri cosnūú de ichi núú Cristo, návāha coo tūhva ñayuu jeē jinú yā. Achí Yaā Dios, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Te cáhán rī jiín ró jeē ini ñayɨ̄vɨ yáha cújéhnu ga Juan tēe scuándute vēsú tāca gá tēe jeē ni íyo ini ñayɨ̄vɨ́. Te vēsú súcuan te tāca tée núu ga ini ñuu nuū ndácu Yaā Dios jniñu, cújéhnu ga de vēsú Juan. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Te tāca ñáyuu jiín táca tée cástútú xúhun renta, ni cajini i jnūhun cáhán yā, te ni cajetáhú i jeē Yaā ndaā cúu Yaā Dios, chi je ni cajendute i nuū Juan. ");
INSERT INTO mibNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Te tēe grupo fariseo jiín tée cástéén tutu ley, ni casquéhichī de jnūhun jeē cuní Yaā Dios sáha ya jeē váha de, chi tu ní cájendute de nuū Juan. ");
INSERT INTO mibNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Te ni cahān gā maá Jítoho yō: Yāhá cachi rī ɨɨn jnūhun yátá návāha na cúni rō ndese cúu ñayuu tiempo vijna. ");
INSERT INTO mibNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cúu i nájnūhun sūchi lúlí cáhīin nuū yáhu cácasɨ́quɨ́ i. Te cácana ndee i xinī jnáhan i: Ni catɨvɨ rī scuilí, te tu ní cájita jéhé ró. Te ni cajita ri yaa jeē cuihyá jíta, te tu ní cándahyū rō, achí i. Te nájnūhun cándāa sūchi lúlí un jéē tu ní nújnahan ni i ni ɨɨn, suni súcuan cándāa ró. ");
INSERT INTO mibNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Chi ni quiji Juan tēe scuándute, te cuehē jínu ni īyo ndite ni de, tu ní yéji de staā ni tu ní jíhi de vino. Te tu ní cánujnahan ni rō, chi ni cacahān rō jeē ñúhun tachī ini de. ");
INSERT INTO mibNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yūcuán na te ni quee máá rí, Yaā ní nduu tēe, te yéji rī jíhi ri, te tu cánujnahan ni rō, te chísóó jnúhun ró cácahān rō jeē máni máá jéē yéji rī jíhi ri vino. Te quíjnáhan ri jiín tée cástútú xúhun renta jiín táca gá tēe cásáha cuēchi, áchí ró. ");
INSERT INTO mibNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Te núu cúndíchí ɨɨn tēe jíín jnúhun Yaā Dios, te jíín jniñu sáha de te cájini tāca gá tēe ndíchí jeē ndichí de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Te ɨɨn tēe fariseo ni cana de Jesús jeē cáji yā staā jiín de. Te ni jinū yā vehe de, te ni cucōo ya mesa jeē cáji yā staā. ");
INSERT INTO mibNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yūcuán na te ɨɨn ñahan sáha cuēchi, ndéé ña ñuu yúcuan, te ni jini ña jeē ni jínū Jesús vehe tēe fariseo un, yéji yā staā. Te ni quee ña jíín ɨɨn frasco yuū luu jeē ñúhun chitú aceite perfume. ");
INSERT INTO mibNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Te íin yɨ́tɨ́ ña nuū jehé yā, te ndáhyú ña. Te ni quejéé ña stáji ña jehē yā jiín ndute tɨ́núú ña, te ni nasíchí ña jíín ixi xíní ña. Te ni techūhú ña jehē yā, te ni chuhun ña perfume un. ");
INSERT INTO mibNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Te tēe fariseo un jeē ní cana de ya, ni jito de jeē súcuan ni sáha ña, te ni jeni ni de: Núu tēe nácani jnūhun Yaā Dios cúu tēe yáha, te cuni de ndese ñahan cúu ñahan yáha jeē quehé ña de, chi ñahan sáha cuēchi cúu ña, jéni ni de. ");
INSERT INTO mibNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yūcuán na te ni cahān Jesús jiín de: Simón, cúní rī cahān rī jiín ró ɨɨn jnūhun. Te ni cahān maá de: Cahān ní, Maestro. ");
INSERT INTO mibNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Te ni cahān Jesús: Ɨɨn tēe jéhe núu xūhún, ni īyo uū tēe táú nuū de. Ɨɨn de ni cotaū uhūn ciento denario, te ɨnga de ni cotaū uū xico uxī denario. ");
INSERT INTO mibNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Te tú na vé cánevāha tēe un jéē náchunaa de. Te tēe jéhe núu xūhun ní ine cáhnu ni de nuū ndɨndúú tée ún. Núu súcuan te cachi rō: Jeē ndɨndúú tée ún, ¿ndé ɨɨn de coo manī gā jiín de? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Te ni cahān Simón: Jéni ni na jéē tée ni cotaū cuehē gā, achí de. Te ni cahān yā jiín de: Ndaā cahán rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Te jíto ya nuū ñahan ún, te ni cahān gā yā jiín Simón: ¿A jíto ró na vé sáha ñahan yáha? Jeē ní quee rī vehe ró, te tu ní jéhe ró ndute jeē ndúndoo jehē rī nájnūhun íyó costumbre. Te ñahan yáha ní stáji ña jehē rī jiín ndute tɨ́núú ña, te ni nasíchí ña jíín ixi xíní ña. ");
INSERT INTO mibNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Te tu ní téchūhu ró ruhū nájnūhun íyó costumbre. Te ñahan yáha, nde jeē ni quɨ́vɨ ri vehe ró, tu jécuɨñɨ̄ ña jeē téchūhú ña jehē rī. ");
INSERT INTO mibNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Te tu ní chúhun ró aceite xinī rī nájnūhun íyó costumbre. Te ñahan yáha ní chuhun ña aceite perfume jehē rī. ");
INSERT INTO mibNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Núu súcuan te cáhán rī jiín ró jeē ni stéén ña jeē yóhyo manī ña jíín rí sɨquɨ̄ jeē íne cáhnu ni rī nuū tāca cuéchi ña, vēsú cuehē cúu. Te núu cone cáhnu ni rī nuū ɨɨn ñayuu iyó jecu‑ni cuēchi, te jecu‑ni stéén i jeē maní i jíín rí, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Te ni cahān yā jiín ña: Je íne cáhnu ni rī nuū tāca cuéchi ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yūcuán na te ñayuu cáyeji staā jiín yá, ni quejéé i cácahān maá i: ¿Ndé ɨɨn ga cúu tēe yáha jéē cahán jeē íne cáhnu ni nuū cuéchi? áchí i. ");
INSERT INTO mibNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Te Jesús ni cahān gā yā jiín ñahan ún: Ni candíje ró rúhū, te jeē yúcuan ní jnama ri rohó. Cuáhán te na ndúsɨɨ̄ ni rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yūcuán na te ni cuu jecu quɨvɨ̄, te ni jica cuu Jesús tācá ñuu náhnu jíín ñuu lulí. Te nácani ya jnūhun vāha te cástūhun yá ndese ndácu Yaā Dios jniñu. Te ndɨhúxí uū tēe cácuu apóstol, cájica de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Te suni íyó jecu ñahan cájica jíín yá, jeē ní quenehen ya tachī ini sava ña, te ni nasávāha ya sava ña jeē cándoho cuehyɨ̄. Te ɨɨn ña cúu María ñuu Magdala, te ini ñahan un ní quenehen ya uxā tachī. ");
INSERT INTO mibNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Te ɨnga ña cúu Juana, ñasɨhɨ́ Chuza, tēe ndíso jníñu ini vehe Herodes. Te ɨnga ña cúu Susana, jiín cuéhē gā ñahan jeē cáchindéé ñáhán ña, jéhe ña tāca jéē jíni ñúhún yá jiín de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Te cuehē ñayuu tācá ñuu yūcuan ní jinūcoo i nuū Jesús. Te ni cacutútú cuéhē ndasɨ́ ñáyuu, te ni cahān yā ɨɨn jnūhun yátá jíín i: ");
INSERT INTO mibNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ɨɨn tēe cate trigo, ni quenda de jeē cáte de. Te ná ni quejéé de jéte de, te jecu trigo ni jitē yuhíchi. Te ni cajeñū ñayuu sɨquɨ̄, te ni cayeji saa. ");
INSERT INTO mibNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Te jecu gā ni jitē nuū ñúhun yuū. Te ni cane, te ni ichī‑ni, chi tú cuehē cajin. ");
INSERT INTO mibNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Te jecu gā ni jitē nuū náne iñu. Te ɨnuú‑ni ni canecoo iñu jíín, te ni jesɨ nuū. ");
INSERT INTO mibNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Te jecu ni jitē nuū ñúhun váha. Te nuū ní jehnu, te ni jēhe cuehē nunī, chi jeē ɨ́ɨn ɨɨn ni jēhe nde ciento. Achí yá. Yūcuán na te ni cahān jee ya: Tāca róhó jéē jíni sōho, na chúsóhó ró, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Te tēe cáscuáha jíín yá ni cacajnūhún de ya na vé cuní cahān jnūhun yátá yáha. ");
INSERT INTO mibNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Te ni cahān yā: Róhó jíjnáhan ró, chi sáha Yaā Dios jeē cájecūhun ni rō jnūhun ni yɨsāhi yáha, ndese quɨ́vɨcoo ñayuu ndaha Yaā Dios jeē ndacu ya jniñu nuū i. Te máni jíín jnúhun yátá cáhán rī jiín sava ga i, návāha vēsú cájito i, te quéndōo i nájnūhun jeē tú na vé ni cájito i. Te vēsú cájini sōho i, te ma jécūhun ni i. ");
INSERT INTO mibNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Jnūhun yátá yáha cúní cahān: Trigo un cúu jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Te trigo jeē ni jítē yuhíchi cúu nájnūhun ñayuu cájini sōho jnūhun, te quíji‑ni jexeén te quénde‑ni jnūhun ini anuá i, návāha ma candíje i te ma jnáma ri i. ");
INSERT INTO mibNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Te trigo jeē ni jítē nuū ñúhun yuū cúu nájnūhun ñayuu cájini jnūhun, te cájetáhú i te cácusɨɨ̄ ni i jíín. Te tu cúcutú jnúhun ún ini anuá i. Te jecu‑ni quɨvɨ̄ cácandíje i, te núu ni quejéé jnúndóho, te cájica yátá i. ");
INSERT INTO mibNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Te trigo jeē ni jítē nuū náne iñu cúu nájnūhun ñayuu cájini jnūhun, te cuangoo i te cácujnéñu i jíín jniñu i jíín jéē cuní i cucúcá i te coo sɨɨ̄ ni i. Te tu íje i jíín jnúhun ya. ");
INSERT INTO mibNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Te trigo jeē ni jítē nuū ñúhun váha cúu nájnūhun ñayuu cájini nahín jnúhun ya, te cájnɨɨ vāha i, chi íyó váha íyó ndáā anuá i. Te cáhije i jíín jnúhun ya, chi cácandíje vāha i. ");
INSERT INTO mibNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Núu nástɨ́ɨn ñayuu ɨɨn lámpara, te tu jésɨ i ni ɨɨn sɨquɨ̄, ni tu jéni i chīji jīto. Chi sa suhva jéni i nuū sucún, návāha cundijin nuū ñáyuu quɨ́vɨcoo vehe. ");
INSERT INTO mibNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Te suni súcuan tu íyó ni ɨɨn jnūhun sāhi jéē ma cúni ñayuu, chi ndɨhɨ tāca jnúhun cácahān i nane ndijin te cuni ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Núu súcuan te na cúni sōho vāha ró, chi ñayuu je jécūhun ni, stéén gā yā nuū i. Te ñayuu tu cándíje, máá jecu jeē jéni ni i jeē jiní i, sa suhva naa. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yūcuán na te ni quee naná yā jiín táca ñani yā nuū íne ya. Te tu ní cúu quɨ̄vɨcoo ña nuū yā sɨquɨ̄ jeē chitú ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Te ɨɨn ñayuu ni castūhun núū yā: Náná ni jíín táca ñani ni cáhīin nuū quéhe, te cácuni cahān jiín ní, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Te ni cahān maá yá: Suni náná rī jiín ñani rī cácuu ñayuu cájini sōho jnūhun Yaā Dios te cásquícu i, áchí yá jiín i. ");
INSERT INTO mibNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Te ɨɨn quɨvɨ̄ ni quɨ̄vɨ ya ɨɨn barco jiín tée cáscuáha jíín yá, te ni cahān yā jiín de: Na yáha yó quíhīn yō ɨnga lado mar. Te ni cascáca de barco cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Te níní cáscáca de barco, te ni quixī yā. Te ni jequɨ̄hɨ ɨɨn tachī níhin nuū mar, te je yajni chitú ndute ini barco, te ndúcú quée barco. ");
INSERT INTO mibNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Te ni castónda de ya, te ni cacahān de: Maestro, Maestro, vijna te quēe yó chíji ndute te naa yō, achí de. Te ni ndocuɨñɨ̄‑ni ya, te ni cahān yā nuū tachī níhin jíín núū mar. Te ni cajecuɨñɨ̄‑ni, te ni cuu nayúú íī‑ni. ");
INSERT INTO mibNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Te ni cahān yā jiín tée cáscuáha jíín yá: ¿Naun tu cácandíje ró? Te máá de yōhyo ni cayūhú de, te cánaa ni de, te cácahān de jíín jnáhan de: ¿Ndé ɨɨn ga cúu tēe yáha jéē nde nuū tachí níhin jiín núū ndúte ndácu de jniñu te cájetáhú jéē cahán de? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yūcuán na te ni cane ya jiín de región Galilea, te cuahān yā región Gadara jeē íne ɨnga lado mar Galilea. ");
INSERT INTO mibNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Te nuū ní nanuu ya nuū ñúhun íchi, te ɨɨn tēe ñuu un ní quee de nuū yā. Te je ni cuu cuehē cuiyā ñúhun cuehē tachī ini de. Te tu ñúhun cuɨtɨ de sahma, ni tu ndéé de vehe, chi sa suhva nuū cáyɨndūji ndɨ̄yɨ ndeé de. ");
INSERT INTO mibNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Te ná ni jito de nuū Jesús, te ni jecuɨñɨ̄ yɨtɨ́ de nuū yā, te ni cana cóhó de: ¿Naun vēji ní núū ná, Jesús Sēhe Yaā cujéhnu téyɨ́? Cáhán ndahú ná jiín ní jeē ma stóho ní sáña, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Súcuan ni cahān de, chi je ni ndacu ya jniñu nuū tachí un jéē na quéndacoo ini de. Te ni cuu cuehē jínu sáha xeēn tachī jiín de. Te cájihni ñayuu ndaha de jehē de jíín cadena, návāha tú na vé sáha de. Te ndɨhɨ‑ni jéhnde de, te jínu de jéhén de nde nuū ñúhun téhé sáha tachī ún. ");
INSERT INTO mibNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Te Jesús ni cajnūhun yá de: ¿Na vé naní ró? Te ni cahān de: Legión naní ná. Súcuan ni cahān de jeē naní de, chi ñúhun cuehē tachī ini de. ");
INSERT INTO mibNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Te ni cacahān ndahú táchī un jíín yá jeē ma tají yá quihīn ini tūhnchi cúnú. ");
INSERT INTO mibNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Te yucu yúcuan cáhīin cuehē quɨnɨ̄ cájitu tɨ. Te tachī jeē cáñuhun ini tēe un ní cacahān ndahú jíín yá jeē na cuáha ya jnūhun quɨ̄vɨcoo ini quɨnɨ̄ ún. Te ni jēhe ya jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Te ni quendacoo tachī ún ini tēe ún, te ni quɨ̄vɨcoo ini quɨnɨ̄. Te quɨnɨ̄ un ní cajinu tɨ ni nɨngoo tɨ ɨɨn yucáva, ni quɨ̄vɨcoo tɨ nuū mar, te ni ndaquɨ̄hɨ tɨ ndute, ni cajihī tɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Te tēe cándito tɨ ni cajito de jeē súcuan ni cuu, te ni cayūhú de. Te ni cajinu de cuacastūhún de nuū ñáyuu ñuu un jíín ñáyuu tāca rancho. ");
INSERT INTO mibNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Te cuangoo ñayuu un cuácondēhé i na vé ni cuu. Te ni jinūcoo i nuū íne Jesús. Te ni cajito i nuū tée ní quendacoo tachī ini, néne de nuū jehé Jesús, te ñúhun de sahma, te je ni nducájí xínī de. Te ni cayūhu ñáyuu ún. ");
INSERT INTO mibNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Te tēe ní cajito ni canacani de jnūhun nuū ñáyuu, ndese ni nduvāha tēe ni ñuhun tachī ini. ");
INSERT INTO mibNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yūcuán na te tāca ñáyuu nɨ́ɨ́ región Gadara, ni caquejéé i cácahān ndahú i jíín yá jeē na cújiyo ya quihīn yā, chi yōhyo cáyūhú i. Te ni ndɨ̄vɨ ya ini barco jeē quínuhun yā. ");
INSERT INTO mibNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Te tēe jeē ní quendacoo tachī ini, ni cahān ndahú de jíín yá jeē na cuáha ya jnūhun quihīn de jíín yá. Te Jesús ni cahān yā jeē na quéndōo de, te áchí yá: ");
INSERT INTO mibNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Cuánuhun vehe ró, te nacani ró jnúhun ndese yōhyo jéhnu jniñu ni sáha Yaā Dios jiín ró, achí yá jiín de. Te cuahān de, te ni nacani de jnūhun nɨ́ɨ́ ñuu ún, ndese yōhyo jéhnu jniñu ni sáha Jesús jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Te nuū ní najinū Jesús ɨnga lado mar, te ñayuu un ní cacusɨɨ̄ ni i jeē ní najinū yā, chi ndɨhɨ i cándetu i ya. ");
INSERT INTO mibNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Te ni quee ɨɨn tēe cújéhnu ini vehe iī sinagoga, naní de Jairo. Te ni jecuɨñɨ̄ yɨtɨ́ de nuū jehé yā, te ni cahān ndahú de jíín yá jeē na quíhín yā jiín de vehe de. ");
INSERT INTO mibNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Chi íyó ɨɨn sēhe sɨ́hɨ́ de jeē mañúhún‑ni i nuū de, te íyó i nájnūhun uxī uū cuiyā. Te sūchí un je yajni cuu i. Te cuahān yā jiín de. Te cuehē ñayuu cándiquīn i ya, te ni chitú níhin i xiin ya cuangoo i. ");
INSERT INTO mibNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Te mēhñu ñáyuu un cuáhān ɨɨn ñahan cúhú jeē ní cuu uxī uū cuiyā ndóho ña cuehyɨ̄ nɨñɨ̄. Te ni jexin ña tāca jéē névāha ña jíín tée tájná, te tu ní ndúvāha ña sáha ni ɨɨn de. ");
INSERT INTO mibNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Te ni quee ña ichi yátá yā, te ni quehé ña yusáhma ya. Te ni jecuɨñɨ̄‑ni nɨñɨ̄ ña. ");
INSERT INTO mibNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yūcuán na te ni cahān Jesús: ¿Ndé ɨɨn ni quehé sahma ri? achí yá. Te ndɨvii i ni cacahān jeē tu ní quéhé i. Te Pedro jiín tée cáhīin jíín de, ni cacahān de: Maestro, jíto ní jéē ñáyuu cuehē yāha ní chitú níhin i xiin ní, te cáquɨ̄hɨ i níhín, te cájnūhun ní ndé ɨɨn ni quehé sahma ní. ");
INSERT INTO mibNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Te ni cahān Jesús: Tuú chi ɨɨn ñayuu ni quehé sahma ri, chi ni jini rī jeē jiín fuerza rī ni nduvāha ɨɨn ñayuu, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Te ni jini ñahan un jéē tu ní cúu coo yuhu jeē ni sáha ña. Te quɨ́sɨ i ña ni quee ña, te ni jecuɨñɨ̄ yɨtɨ́ ña nuū jehé yā. Te jíto jínúū tāca ñáyuu, te ni cachi cají ña najehē ni quehé ña yusáhma ya, jiín jéē ní nduvāha‑ni ña. ");
INSERT INTO mibNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Te ni cahān yā jiín ña: Séhē, ni candíje ró jéē cuu nasávāha ri rohó, te jeē yúcuan ní nduvāha ró. Cuáhán te na ndúsɨɨ̄ ni rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Te níní cáhán gā yā súcuan, te ni quee ɨɨn tēe vēji vehe Jairo, tēe cújéhnu ini sinagoga, te ni cachi nuū de: Je ni jihī sēhe sɨ́hɨ́ ní. Te ma sájnéñu ga ní Maestro, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Te ni jini Jesús jnūhun yáha, te ni cahān yā jiín Jairo: Ma yūhu ró, chi candíje‑ni ró, te nastécu rī sēhe ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Te ni jinū yā vehe, te tu ní jéhe ya jnūhun quɨ̄vɨ ñayuu jiín yá, chi máá‑ni Pedro jiín Juan jiín Jacobo jiín tátá naná sūchi sɨ́hɨ́ un. ");
INSERT INTO mibNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Te cácucuíhyá ni ndɨhɨ ñayuu cáyūcú ini vehe, te cándahyū i jehē sūchí un. Te ni cahān yā: Ma ndahyú rō jijnáhan ró. Tu ní jíhí i, chi quíxí‑ni i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Te ni cajecū catá i jeē ni cáhān yā, chi cájini i jeē ni jíhī sūchi sɨ́hɨ́ un. ");
INSERT INTO mibNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yūcuán na te ni jnɨɨ ya ndaha i, te ni cahān jee ya jiín i: Sɨ́hɨ̄, ndocuɨñɨ̄, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Te ni natecu i, te ni ndocuɨñɨ̄‑ni i. Te ni ndacu ya jniñu jeē na cuáha ña jeē cáji i. ");
INSERT INTO mibNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Te tátá i náná i yōhyo ni canaa ni de cájito de. Te ni ndacu nīhin ya jniñu nuū de jeē ma cáchi de nuū ni ɨɨn jeē súcuan ni cuu. ");
INSERT INTO mibNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Te ni nastútú yá ndɨhúxí uū tēe cáscuáha jíín yá, te ni sáha ya jeē cóndiso jníñu de te coo poder de jeē quénehen de tachī ini ñayuu, jiín jéē nasávāha de ñayuu cácuhū. ");
INSERT INTO mibNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Te ni tají yá de quingoo de jeē nácani de jnūhun ndese ndácu Yaā Dios jniñu, jiín jéē nasávāha de ñayuu cácuhū. ");
INSERT INTO mibNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Te ni cahān yā jiín de: Ma cóndiso ró jéē cuajníñu ró ichi, ni vara, ni ñunu, ni staā, ni xūhún. Te quihīn rō jiín ɨɨn‑ni camisa, te ma cóndiso ró ɨnga. ");
INSERT INTO mibNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Te na‑ni vehe núu ni quɨ̄vɨcoo ró, te yūcuán coyūcu ró nde quenda tucu ró quíhīn rō ɨnga ñuu. ");
INSERT INTO mibNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Te núu ɨɨn ñuu tu cájetáhú i róhó, na quéndacoo ró yúcuan, te scóyo ró tɨ́cachā jehē rō, te súcuan stéén rō jeē iyó cuéchi i jeē tu ní cájetáhú i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Te ni quendacoo de cuahān de, ni cajica nuu de tācá ñuu, ni canacani de jnūhun jnáma Yaā Dios ñayuu. Te tāca lado ni canasávāha de ñayuu cácuhū. ");
INSERT INTO mibNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Te Herodes, tēe cúu gobernador, ni jini jnūhun de tācá jniñu sáha Jesús. Te ni cunéé ni de, chi cájeni ni sava ñayuu cácahān i jeē Juan ni natecu de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Te sava ga i cácahān jeē ní nane Elías, tēe ni nacani jnūhun Yaā Dios nde jenahán. Te sava ga i cácahān jeē ɨnga tēe ni nacani jnūhun ya nde jenahán, ní natecu de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Te ni cahān Herodes: Juan chi ni ndacu ri jniñu ni tahndē xinī. Núu súcuan ¿te ndé tée cúu tēe yáha jeē jíni jnūhun ri jeē sáha de jniñu jéhnu? Achí de. Te ni nducú Herodes modo coto de nuū Jesús. ");
INSERT INTO mibNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Te ni ndecoo tēe cácuu apóstol jeē ní tají yá ni canacani jnūhun. Te ni cacachi de nuū yā tācá jniñu ni casáha de. Te ni jeca ya de cuahān sɨ́ɨn ya jiín de ɨɨn lugar nuū tú ñayuu, yajni ñuu Betsaida. ");
INSERT INTO mibNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Te ni cajini ñayuu, te suni cuangoo i. Te ni jetáhú yá i, te ni nacani ya jnūhun ndese ndácu Yaā Dios jniñu, te ni nasávāha ya ñayuu cácuhū. ");
INSERT INTO mibNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Te nuū cuáhini, te ni quecoo ndɨhúxí uū tēe cáscuáha jíín yá, te ni cacahān de jíín yá: Tají ní ñayuu cuehē yāhá na quíngoo i tācá ñuu jiín táca rancho yajni yāhá, te nducú i nuū ndóo i te cuaan i jeē cáji i, chi tú na vé iyó yáha, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Te ni cahān yā jiín de: Cuāha máá ró jeē cáji i, áchí yá. Te ni cacahān de: Tú na vé cánevāha ná, chi uhūn‑ni staā jiín úū‑ni chācá. Te vēsú núu quicuaan ná stáā caji ndɨhɨ ñayuu cuehē yáha, te ni ma cúu, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chi íyó nájnūhun uhūn mil tēe. Te ni cahān yā jiín tée cáscuáha ún: Cahān jiín ñáyuu na cúcōo sɨ́ɨn cincuenta cincuenta i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Te súcuan ni casáha de, te ni cacucōo ndɨhɨ ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Te ni quihin ya ndɨhúhún staā jiín úū chācá un, te ni ndacoto ya ichi ándɨvɨ́, te ni nacuatáhú yá. Te ni tahú cuéchí yá staā ún, te ni jēhe ya nuū tée cáscuáha jíín yá, te ni casaja de nuū ñáyuu cuehē. ");
INSERT INTO mibNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Te ndɨvii i ni cayeji, te ni candutú chíji i. Te ni canastútú de pedazo staā jeē ní quendōo, te ni chitú úxī uū jīca. ");
INSERT INTO mibNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Te ɨɨn quɨvɨ̄ ni cusɨ́ɨn Jesús, jícán tahú yā, te máá‑ni tēe cáscuáha un cáhīin de jíín yá. Te ni cajnūhun yá de: Ruhū, ¿ndé ɨɨn cúu ri cácahān ñayuu? achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Te ni cacahān de: Sava i cácahān jeē cúu ní Juan tēe ni scuándute. Te sava ga i cácahān jeē cúu ní Elías, tēe ni nacani jnūhun Yaā Dios nde jenahán. Te sava ga i cácahān jeē ɨnga tēe ni nacani jnūhun ya ni natecu de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yūcuán na te ni cajnūhun yá de: Te máá ró, ¿ndé ɨɨn cúu ri cácahān rō? Te ni cahān Pedro: Máá ní cúu Cristo, Yaā ní tají Yaā Dios, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yūcuán na te ni ndacu nīhin ya jniñu nuū de jeē ma cáchi de jnūhun yáha núū ní ɨɨn ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Te ni cahān yā: Máá rí, Yaā ní nduu tēe, cánuú ndoho xeēn rī. Te tāca tée jéhnu jíín sútū cácujéhnu jíín tée cástéén tutu ley, squéhichī de ruhū. Te cahni de ruhū, te nuū uní quɨvɨ̄ te natecu rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yūcuán na te ni cahān yā jiín ndɨhɨ de: Na‑ni ñayuu núu cúní i condiquīn i ruhū, na cásɨ i jeē cuní maá i, te na cóndiquīn i ruhū tāca quɨ́vɨ̄, te cuāha i jnūhun ndoho i jnūndóho jeē sɨquɨ́ rī, vēsú na cúū i. ");
INSERT INTO mibNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chi núu ndé ñáyuu cuní i cācu i nuū jnúndóho quiji nuū i jeē sɨquɨ́ ruhū, núu súcuan te jnahnū ndetū i nɨ́ɨ́ cáni. Te núu ndé ñáyuu, vēsú na cúū i jeē sɨquɨ́ ruhū, te cotecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Chi ndé cuajníñu vēsú na cúndeyɨ́ ñayuu nihīn i nɨ́ɨ́ ñáyɨ̄vɨ́, te núu squɨ́vɨ i máá i nuū jnahnú ndetū i nɨ́ɨ́ cáni? ");
INSERT INTO mibNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chi núu na‑ni ñayuu cúcanu i jeē sɨquɨ́ ruhū, Yaā ní nduu tēe, jíín sɨ́quɨ̄ jnúhun cáhán rī, suni súcuan cucanu rī jeē sɨquɨ́ máá i, quɨvɨ̄ ndíji ri. Te quɨvɨ̄ ún chi yōhyo luu cujéhnu ri, nájnūhun cújéhnu Tátá rī, te suni cácujéhnu ndajéhé ndoo ya sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Te jendaá cahán rī jiín ró jeē sava tēe cáhīin yāhá, ma cúū de chi nde cuni de jeē ndácu Yaā Dios jniñu jíín poder yā. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yūcuán na te nájnūhun nuū uná quɨvɨ̄ jeē ni cáhān yā jnūhun yáha, te ni caa ya ɨɨn yucu, cuacacān tahú yā. Te Pedro jiín Jacobo jiín Juan cuangoo de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Te níní jícán tahú yā, te tucu ni nduu nuū yā, te sahma ya ni nducuíjín quɨyɨ, te ndíndēé. ");
INSERT INTO mibNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yūcuán na te ni canecoo uū tēe, cándajnūhún de jíín yá. Te cúu de Moisés jiín Elías, tēe ni cahīyo jenahán. ");
INSERT INTO mibNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Te luu ndíndēé de cáhīin de, te ni cacahān de jíín yá sɨquɨ̄ jeē ní cuyajni cuu yā ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Te Pedro jiín tée cáyūcu jíín de, yōhyo cájiī de māhná, te vēsú súcuan te tu ní cáquixī de. Te ni cajito de jeē lúu ndíndēe yá jiín ndɨndúú tée cáhīin jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Te nuū ní cacujiyo tēe un núū yā, te ni cahān Pedro jiín yá: Maestro, nacā jeē váha jeē cáhīin ná yáha. Te na sáha ná únī vehe ramada, ɨɨn cuu máá ní, ɨnga cuu Moisés, te ɨnga cuu Elías, achí de. Te tu sáha de cuenta na vé cúu jeē cahán de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Te níní cáhán de súcuan, te ni quee vicō nūhun ní jesɨ nuū de jíjnáhan de. Te ni cayūhú de jeē cáhīin de chīji vicō ún. ");
INSERT INTO mibNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Te nuū vicó un ní cahān ɨɨn jnūhun: Yāha cúu Sēhe ri jeē maní ndasɨ́ rí jiín. Te na cúni nahín ró jnūhun cáhán yā, achí. ");
INSERT INTO mibNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Te nuū ni jínu ni cahān jnūhun ún, te máá ɨɨn na Jesús íin ya nuū de. Te máá de tu ní cácahān cuɨtɨ de, te tāca quɨ́vɨ̄ ún tu ní cácachi de nuū ni ɨɨn jeē súcuan ni cajito de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Te ɨnga quɨvɨ̄ un ní nanuu ya yucu jíín de. Te cuehē ñayuu ni jejnahan i ya. ");
INSERT INTO mibNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Te mēhñu ñáyuu cuehē un ní cana jee ɨɨn tēe: Maestro, jícán tahú na núū ni jéē condēhe ní sēhe yɨɨ́ ná, chi máñúhún i nuū ná. ");
INSERT INTO mibNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Te máni jeē sáha xeēn tachī jiín i, te cána cóhó i sáha, te jéhni yɨ̄hɨ́ i, te jée tiñū yuhu i. Te yōhyo stóho i, te yōhyo uhū siaá i. ");
INSERT INTO mibNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Te ni cahān ndahú ná jiín tée cáscuáha jíín ní jeē na quénehen te tachī ún, te tu ní cúu sáha de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Te ni cahān yā jiín de jíjnáhan de: Ñayuu yōhyo nīhni ni cácuu ró, chi tu cácandíje ró jéē cuu nduvāha i. ¿Nasaa ga quɨvɨ̄ condee rī jiín ró jeē cuándeyɨ́ ni rī jiín ró? Cuáquihin sēhe ró na quíji i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Te níní véji i nuū yā, te ni cotúú i ni sáha tachī, te ni jehni yɨ̄hɨ́ i. Te Jesús ni cahān xeēn yā nuū tachí un, te ni nasávāha ya sūchí un, te ni nacuāha ya i nuū tatá i. ");
INSERT INTO mibNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Te ndɨvii ñayuu nahán ní canaa ni i cájito i jeē yóhyo jéhnu jniñu sáha Yaā Dios. Te níní cánaa ni i cájito i tācá jniñu ni sáha Jesús, te ni cahān yā jiín tée cáscuáha jíín yá: ");
INSERT INTO mibNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Chuhun vāha ni rō jnūhun cáhán rī yāhá, te ma náā ni rō, chi ruhū, Yaā ní nduu tēe, nastúu i ruhū quɨ̄vɨ ri ndaha tāca tée xeēn, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Te tu ní cájecūhun ni de jnūhun cáhán yā, chi tu ní cúu cuɨtɨ jecūhun ni de. Te ni cayūhú de cajnūhún de ya sɨquɨ̄ jnúhun ni cahān yā. ");
INSERT INTO mibNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yūcuán na te tēe cáscuáha jíín yá ni caquejéé de cácahān de sɨquɨ̄ núu ndé ɨɨn de cújéhnu ga. ");
INSERT INTO mibNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Te Jesús ni jini yā jeē súcuan cájeni ni de. Te ni jnɨɨ ya ndaha ɨɨn sūchi lúlí, te ni jeni ya i xiin ya. ");
INSERT INTO mibNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Te ni cahān yā jiín de: Na‑ni ñayuu núu jeē sɨquɨ́ ruhū jetáhú i sūchi lúlí yáha, te ruhū jetáhú i. Te ñayuu jetáhú rúhū, suni jétáhú i Yaā ní tají rúhū vēji ri. Te ñayuu núu ga mēhñu ró, máá i cújéhnu ga, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yūcuán na te ni cahān Juan: Maestro, ni cajito ná ɨɨn tēe jeē jiín sɨ́hvɨ́ ní quénehen de tachī ini ñayuu. Te ni cajesɨ na jéē sáha de, chi tu jíca de jíín yó, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Te ni cahān Jesús jiín de: Ma cásɨ rō jeē sáha de, chi tēe tu cáhán sɨquɨ̄ yō, íin de jíín yó, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Te ni cuyajni quɨvɨ̄ jeē quínuhun yā andɨvɨ́, te ni tee téyɨ́ ni yā jeē quihín yā ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Te ni tají yá sava tēe yósnúu de jíín jnúhun jeē jinú yā. Te cuangoo de ɨɨn ñuu Samaria návāha nducú de nuū ndóo ya. ");
INSERT INTO mibNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Te ñayuu Samaria un tu ní cájēhe i vehe ndōo ya, chi ni cajini i jeē ndé Jerusalén quihīn yā. ");
INSERT INTO mibNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Te Jacobo jiín Juan, tēe cáscuáha jíín yá, ni cajini de jeē súcuan cúu, te ni cacahān de jíín yá: ¿A cúní ni jéē ndácu yó jniñu quiji ñuhūn nde andɨvɨ́, nájnūhun ni sáha Elías, návāha naa ñayuu yáha? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yūcuán na te ni ndió cóto Jesús nuū de, te ni cahān yā nuū de: Tu cájini rō na nuū vēji jnūhun cácahān rō. ");
INSERT INTO mibNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chi ruhū, Yaā ní nduu tēe, tú vēji ri jeē snáā rī ñayuu, chi sa suhva jeē jnáma ri ñayuu, achí yá. Yūcuán na te cuahān yā jiín de ɨnga ñuu. ");
INSERT INTO mibNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Te níní jíca ya ichi jíín de, te ni cahān ɨɨn tēe jíín yá: Condiquīn na níhín quíhīn yō ndé‑ni cúu‑ni nuū quihín ni, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Te ni cahān Jesús jiín de: Tāca ñúcuii, íyó yáū cava cáñuhun tɨ. Te suni saa, iyó tácā tɨ̄. Te ruhū, Yaā ní nduu tēe, tú nuū cusú rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Te ni cahān yā jiín ɨnga de: Condiquīn ruhū na quíhín yō. Te máá tée un ní cahān de: Condetu ní ndé na quíchindūji ná tátá na xíhna gā. Yūcuán na te condiquīn na níhín, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Te ni cahān Jesús jiín de: Stóo tāca ndɨ́yɨ na chíndūji jnáhan ndɨ̄yɨ, chi ndɨ̄yɨ cácuu ñayuu tu cácandíje. Te róhó, cuáhán te nacani ró jnúhun ndese ndácu Yaā Dios jniñu, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yūcuán na te suni ni cahān ɨnga de: Cúní na condiquīn na níhín, te cuāha ní jnúhun jeē xíhna gā quicahān na jíín ñáyuu cáyūcú vehe ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Te ni cahān Jesús jiín de: Núu na‑ni tēe quéjéé de condiquīn de ruhū, te núu máni jeē nácani cuíhyá ni de sɨquɨ̄ tāca jéē ni stóo de, núu súcuan te cúu de nájnūhun ɨɨn tēe jítu jíín yátá, te jícó cóto de ichi vehe de. Te ma cuajníñu de condiquīn de ruhū sɨquɨ̄ jníñu ndácu Yaā Dios, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Te ná ni cuu tācá jniñu yáha, te máá Jítoho yō ni nacāji ya unī xico uxī gā de. Te ni tají yá ndɨhuū ndɨhuū de jeē cósnūú de nuū yā, quingoo de tācá ñuu jiín táca lugar nuū jé yajni quihīn maá yá. ");
INSERT INTO mibNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Te ni cahān yā jiín de: Ñayuu yáha cácuu i nájnūhun trigo jeē tahndé, te ndaā jeē cuehē cúu, te tēe cahnde chi jecu‑ni de cúu. Núu súcuan te cacān tahú rō nuū maá Jítoho rō Yaā Dios jeē na tájí yá cuehē tēe na quíngoo de cahnde de trigo, cúu jeē nacani de jnūhun ya nuū ñáyuu. ");
INSERT INTO mibNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Te cuángoo jíjnáhan ró, te na cástūhun rí nuū rō jeē tají rí rohó quíngoo ró nájnūhun londe mēhñu yɨ́hɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Te ma cóndiso ró ñunu, ni yɨjnɨ xūhún, ni ndijēn. Te ichi ma cucuéé ró ndajnūhun ró jíín ni ɨɨn. ");
INSERT INTO mibNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Te na‑ni vehe núu ni quɨ̄vɨ ró, te xīhna gā cahān rō: Na quíji jnūhun ndeyɨ́ jnūhun sɨɨ̄ ni nuū rohó, ñáyuu vehe yáha, achi rō. ");
INSERT INTO mibNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Te núu vehe yúcuan íyó ñáyuu vāha, te jnūhun ndeyɨ́ ní cahān rō jinū sɨquɨ̄ i. Te núu tuú, te jnūhun ndeyɨ́ ní cahān rō ma jinú sɨquɨ̄ i. ");
INSERT INTO mibNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Te suni vehe yúcuan coyūcu ró, te caji rō coho ró jéē cuáha ñayuu nuū rō. Chi sɨquɨ̄ jniñu jeē nácani ró jnúhun nuū ñáyuu, te cánuú coto i róhó. Ma quéndōo ró tɨjnɨ vehe, chi ɨɨn‑ni vehe. ");
INSERT INTO mibNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Te na‑ni ñuu núu ni quɨ̄vɨcoo ró, te núu cuatáhú i róhó, te caji rō tāca jéē cuáha i nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Te nasávāha ró ñáyuu cácuhū ñuu yūcuán. Te cachi rō nuū i: Je ni cuyajni Yaā Dios jeē ndacu ya jniñu nuū rō, achi rō. ");
INSERT INTO mibNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Te na‑ni ñuu núu ni quɨ̄vɨcoo ró, te núu tu ní cájetáhú i róhó, te quendacoo ró ini calle yūcuán, te cahān rō: ");
INSERT INTO mibNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Nde tɨcachā ñuu rō yāha jéē ni jnɨ́ɨ jehē rī, na náscóyo ri jeē cúu seña jeē iyó cuéchi ró jéē tu ní cájetáhú ró. Te na cónahán ró jeē Yaā Dios je ni cuyajni ya jeē ndacu ya jniñu nuū rō nuú. ");
INSERT INTO mibNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Te cáhán rī jiín ró jeē quɨvɨ̄ juicio te xeēn gā coo castigo sɨquɨ̄ ñuu casáha súcuan vēsú sɨquɨ̄ ñuu Sodoma nuū ní casáha ndasɨ́ ñáyuu cuēchi. ");
INSERT INTO mibNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Nacā jeē xeēn ndoho ró, ñáyuu ñuu Corazín. Te nacā jeē xeēn ndoho ró, ñáyuu ñuu Betsaida. Chi núu ini ñuu Tiro jiín ñuu Sidón ni sáha ri jniñu jéhnu jeē ni sáha ri ini ñuu maá ró, te yachī nacani ni ñayuu ñuu un jéē stóo i cuēchi i núú. Te sáha i seña jeē steén jeē nácani ni i sɨquɨ̄ cuéchi i, chi cuhun i sahma jnúú te chuhun i yaā xinī i núú. ");
INSERT INTO mibNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Núu súcuan te quɨvɨ̄ coo juicio te xeēn gā coo castigo sɨquɨ̄ rō jijnáhan ró vēsú jeē ni íyo sɨquɨ̄ ñuu Tiro jiín ñuu Sidón. ");
INSERT INTO mibNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Te róhó ñáyuu ñuu Capernaum, ¿á cájeni ni rō jeē cujéhnu ró nájnūhun ɨɨn jeē cáa cuahān ichi ándɨvɨ́? Tuú chi sa nanuu ró ndé lugar nuū cáyūcu ánuá ndɨ̄yɨ. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Te ni cahān gā yā jiín tée jeē tají yá quingoo: Ñayuu chusóhó jnúhun cahān rō, nuū maá rí chusóhó i. Te ñayuu squéhichī rohó, suni ruhū squéhichī i. Te ñayuu squéhichī ruhū, suni squéhichī i Yaā ní tají rúhū vēji ri. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Te ni ndecoo unī xico uxī tēe un, cácusɨɨ̄ ni de te cácahān de jíín Jesús: Nde tachī cájetáhú núū na jéē jiín sɨ́hvɨ́ ní, chi quéndacoo ini ñayuu, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Te ni cahān yā jiín de: Súcuan cúu, chi ni jito ri jeē nájnūhun ɨɨn taja ni nɨngava Satanás ichi ándɨvɨ́, chi ni quende rī ndɨhɨ poder un. ");
INSERT INTO mibNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Te vijna te je ni jēhe ri fuerza nuū rō jeē cueñū rō nájnūhun sɨquɨ̄ tāca cóō jiín tɨ́suhma, te cundeyɨ́ ró sɨquɨ̄ tāca fuerza maá jéē jíto uhū yohó, te tú na vé sáha ga jiín ró. ");
INSERT INTO mibNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Te ma cúsɨɨ̄ ni rō maá‑ni jeē cájetáhú táchī nuū rō, chi sa cusɨɨ̄ gā ni rō jeē yosó sɨ́hvɨ́ ró nde andɨvɨ́. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Te suni hora un ní cusɨɨ̄ ni Jesús, ni sáha Espíritu Santo, te ni cahān yā: Na cútahū na núū ni Tátā, Jitoho andɨvɨ́ jíín ñáyɨ̄vɨ́. Chi ni jesɨ ni táca jnúhun ndíchí ní, jeē ma cúni ñayuu ndichí jíín ñáyuu tūhva cuenta ñayɨ̄vɨ yáha. Te ni steén ni núū ñáyuu cácuu nájnūhun sūchi lúlí. Chi súcuan ni nujnahan ni ni Tátā, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Te ni cahān gā yā: Ndɨvii ni jēhe Tátá rī nuū rī. Te tu cájini ñayuu ndé ɨɨn cúu ruhū, Sēhe Yaā Dios, chi máá‑ni Tátá rī cúu jeē jiní yā ruhū. Ni tu cájini ñayuu ndese Yaā cúu máá Tátá, chi máá‑ni Sēhe cúu jeē jiní. Te íyó ñáyuu jeē cuní maá Séhe stéén yā nuū i ndese Yaā cúu Tátá yā, te máá i suni cuni i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yūcuán na te jíto ya nuū tée cáscuáha ún, te ni cahān yā jiín máá‑ni de: Yōhyo ndetū ñayuu cájito jniñu jéhnu jeē cájito máá ró. ");
INSERT INTO mibNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Chi cáhán rī jiín ró jeē cuehē tēe ni canacani jnūhun Yaā Dios, jiín táca rey, ni cacuni de coto de jeē cájito máá ró, te tu ní cájito de. Te suni ni cacuni de cuni sōho de jeē cájini sōho máá ró, te tu ní cájini de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yūcuán na te ɨɨn tēe stéén tutu ley Yaā Dios, ni ndocuɨñɨ̄ de ni jecahān de jíín Jesús, chi cúní de coto ndee de ya. Te ni cajnūhún de: Maestro, ¿na vé sáha ná te nihīn tahú na cotecu na nɨ́ɨ́ cáni andɨvɨ́? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Te ni cahān yā jiín de: ¿Ndese yósó núū tútu ley? ¿Ndese cáhán cáhu ró? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Te máá tée un ní cahān de jeē cahán nuū tútu: Coo manī ndasɨ́ ró jiín máá Jítoho rō Yaā Dios, nde jnáā ndasɨ́ ró sáha ró ndɨhɨ jeē cúsɨɨ̄ ni yā, nde jiín ini jiín ánuá rō, jiín nɨ́ɨ́ fuerza rō, jiín nɨ́ɨ́ jéē níjnūní rō. Te cundáhú ni rō jnáhan ró nájnūhun cúndáhú ni rō maá ró, achí. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Te ni cahān yā jiín de: Vāha ni cahān rō. Te núu cuu sáha ró súcuan te nihīn tahú rō cotecu rō nɨɨ́ cáni, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Te máá tée un cúní de jeē quéndōo ndaā de nuū yā jiín jnúhun ni cajnūhún de, te ni cahān de: ¿Te ndé ñáyuu cácuu jnáhan ná? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Te ni cahān Jesús: Ɨɨn tēe ni quenda de ñuu Jerusalén, ni cuun de cuahān de ñuu Jericó. Te ichi un ní canecoo ñacuīhna núū de, te ni caquende ndɨhɨ ndajníñu de, te nde sahma ñúhun de. Te ni cacani ndevāha ún de jeē jé yajni cuu de núú. Te ni castóo ún de, te cuangoo. ");
INSERT INTO mibNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Te ni cuu jeē íchi un yáha ɨɨn sutū quihīn de, te ni jito de nuū tée ún, te ni síyo‑ni de cuahān de. ");
INSERT INTO mibNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Te suni súcuan ɨɨn tēe grupo levita jeē cájejníñu ini templo, vēji de ichi ún, te ni jito de nuū tée ún, te ni yāha jícá‑ni de cuahān de. ");
INSERT INTO mibNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Te ɨɨn tēe nación Samaria, suni vēji de ichi ún, te nuū ní jito de, te ni cundáhú ni de tēe ún. ");
INSERT INTO mibNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Te ni quee de nde nuū catú tée ún, te ni chuhun de aceite jiín vino nuū ni túji tēe ún, te ni jihni de sahma nuū. Te ni soó de tēe un sɨ́quɨ̄ quɨtɨ de, te cuahān de jíín tée un ndé ɨɨn mesón, te ni condito de. ");
INSERT INTO mibNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Te ɨnga quɨvɨ̄ ún, hora jeē quihín de, te ni tava de uū xūhun cáa, ni jēhe de nuū tēe chíí mesón. Te ni cahān de: Coto ní tée yáha, te núu caxīn gā ni xúhun ní jíín de, te nuū nándicó ná te nachunaa ná núū ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Núu súcuan ¿te ndese jéni ni rō? Jeē ndɨnúní tée ún, ¿ndé ɨɨn de ni chihi cuenta jeē jnáhan de cúu tēe ni canecoo ñacuīhna núū? Achí yá jiín tée stéén tutu ley. ");
INSERT INTO mibNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Te ni cahān de: Tēe jeē ní cundáhú ni tēe ni tujī, vēsú tēe ñuu jicá cúu de. Yūcuán na te ni cahān Jesús jiín de: Cuáhán núu súcuan, te suni súcuan cundáhú ni rō tāca ñáyuu, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yūcuán na te ni quihin tucu ya ichi cuahān yā, te ni jinū yā ɨɨn ñuu lulí. Te ɨɨn ñahan nání Marta, ni cana ña ya ni jehēn yā vehe ña. ");
INSERT INTO mibNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Te Marta, íyó ɨɨn cuhū ña nání María. Te María ni cucōo ña nuū jehé Jesús, jíni nahín ña jnūhun cáhán yā. ");
INSERT INTO mibNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Te Marta chi cúnéé máá ña jíín cuéhē jniñu sáha ña. Te ni quee ña nuū yā, te ni cahān ña: ¿A tu sáha ní cuenta jeē cuhū na ní stóo máñúhún ña sāña núū jníñu? Te cahān ni jíín ña na chíndéé ñáhán ña sāñá, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Te ni cahān Jesús jiín ña: Marta, yōhyo ndɨ́hvɨ́ ni rō jiín cuéhē jniñu, te yōhyo stóho ró máá ró jiín. ");
INSERT INTO mibNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Te íyó ɨɨn‑ni jniñu cánuú. Te María chi ni nacāji ña jniñu cánuú, suu jeē ndɨhvɨ́ ni ña sɨquɨ̄ jnúhun Yaā Dios, te ma quénehen yó ña nuū ún. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Te ɨɨn quɨvɨ̄ íne Jesús ɨɨn lugar jicán tahú yā. Te nuū ní ndɨhɨ ni jicān tahú yā, te ɨɨn tēe scuáha jíín yá, ni cahān de: Stéén ni núū ná ndese cacān tahú na jíjnáhan ná, nájnūhun ni steén Juan nuū tée ni cascuáha jíín de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Te ni cahān yā jiín de: Jeē cacán tahú rō, te suhva cahān rō: Tátá maá ná jijnáhan ná jéē ndeé ní andɨvɨ́, níní na cóo yɨ́ñúhún ná nuū ní, chi Yaā iī cúu ní. Te ñúhun ni na jéē yachī quiji quɨvɨ̄ ndacu ní jniñu nɨ́ɨ́ ñáyɨ̄vɨ yáha. Te na cóo tācá jniñu nújnahan ni ní, nájnūhun íyó ini andɨvɨ́, súcuan na cóo ini ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Staā jeē cátecu na táca quɨ́vɨ̄, cuāha ní núū ná vijna. ");
INSERT INTO mibNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Te cone cáhnu ni ni núū tāca cuéchi cásáha ná núū ní, nájnūhun cáhine cáhnu ni na núū ñáyuu casáha cuēchi nuū ná. Te ma cuáha ní jnúhun jeē coto ndee jexeén sāñá, chi sa suhva jnama ní sáña nuū tāca jéē neé. Achi rō jijnáhan ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Te ni cahān gā yā: Núu ndé ɨɨn róhó íyó ɨɨn amigo rō, te núu quihīn rō vehe de sava ñuú te cahān rō jiín de: Amigo, cuāha núu unī staā nuū rī. ");
INSERT INTO mibNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Chi ɨɨn amigo rī jeē jíca de viaje, ni quee de vehe ri, te tú na vé névāha ri jeē cuáha ri caji de. Achi rō. ");
INSERT INTO mibNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Te núu cahān tēe íne ini vehe: Ma stáhān rō ruhū, chi ndíhyú yehyɨ́ rí, te je cáquixī sēhe ri jiín rí, te ma cúu ndonda ri jeē cuáha ri nuū rō, achi de. ");
INSERT INTO mibNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Te cáhán rī jiín ró, vēsú ma ndónda de cuāha de nuū rō sɨquɨ̄ jeē cúu de amigo rō, te jeē yóhyo stáhān rō de, jeē yúcuan ndonda de cuāha de ndɨhɨ jeē jíni ñúhún ró. ");
INSERT INTO mibNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Núu súcuan te cáhán rī jiín ró jijnáhan ró jeē suni súcuan cacān tahú rō nuū Yaā Dios, te cuāha ya nuū rō. Te nducú ró tāca jéē váha íyó núū yā, te nihīn rō sáha ya. Te cacān tahú rō nde nihīn rō, nájnūhun sáha ñayuu cahán yehyɨ́ ndé nune quɨ̄vɨ i. ");
INSERT INTO mibNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chi tāca ñáyuu jicán, cuāha ya nuū i. Te ñayuu nducú, suni nihīn i. Te ñayuu cahán, nune ya ichi nihīn i jeē cuní i. ");
INSERT INTO mibNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Te ndé ɨɨn ró cúu tátá, te núu sēhe ró jícán i staā nuū rō, te á cuáha ró ɨɨn yuū nuū i? Te núu jícán i chācá, ¿te á cuáha ró ɨɨn coō nuū i? ");
INSERT INTO mibNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Chí núu jícán i ɨɨn ndɨvɨ̄, ¿te á cuáha ró ɨɨn tɨsuhma nuū i? Tú cuɨtɨ súcuan. ");
INSERT INTO mibNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Núu súcuan te máá ró jijnáhan ró, vēsú ñáyuu iyó cuéchi cácuu ró, te cájini rō cuāha ró jéē váha nuū séhe ró. Te nagā ni cuu máá Tátá rō andɨvɨ́ jéē ma cuáha ya Espíritu Santo nuū ñáyuu jicán nuū yā. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Te quénehen ya ɨɨn tachī ini ɨɨn tēe, jeē ní cuñɨ́hɨ́n de ni sáha. Te nuū ní quenda tachī, te ni nacahān tēe ni cuñɨ́hɨ́n un. Te ni canaa ni ñayuu cájito i. ");
INSERT INTO mibNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Te sava ñayuu ún chi ni cacahān i: Jíín fuerza Satanás jeē cujéhnu nuū tachí, quénehen tēe yáha táca táchī ini ñayuu, achí i. ");
INSERT INTO mibNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Te sava ga i cúní i coto ndee i ya, te ni cajicān i jeē sáha ya jeē coo ɨɨn seña ichi ándɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Te máá yá jiní yā jeē súcuan cájeni ni i, te ni cahān yā: Tācá nación jeē sasɨ́ɨn máá te cuajnáhan máá, núu súcuan te snáā jeē iyó váha máá. Te núu ñayuu ɨɨn vehe sásɨ́ɨn máá te cuajnáhan máá, núu súcuan te ma cúu ga coyūcu cáhnu. ");
INSERT INTO mibNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Te suni súcuan Satanás, núu sásɨ́ɨn máá jíín jnáhan tachī, ¿te ndese cuɨñɨ nīhin jeē ndácu jniñu núu súcuan? Chi cácahān rō jeē jiín fuerza Satanás quénehen ri tachī ini ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Te núu súcuan cúu núú, te ñayuu cascuáha jíín máá ró jijnáhan ró, ¿na jiín fuerza cáquenehen máá i tachī, cájeni ni rō? Núu súcuan te máá i jíjnáhan i cachi jeē ní castɨ́vɨ ndasɨ́ ró ni cacahān rō jeē cáquenehen ri tachī jiín fuerza Satanás. ");
INSERT INTO mibNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Te tuú chi sa suhva jíín fuerza Yaā Dios cúu jeē quénehen ri tachī. Núu súcuan te je ndéé Yaā Dios mēhñu ró jéē ndácu ya jniñu. ");
INSERT INTO mibNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Te núu ɨɨn tēe ndacuī, ndíto de vehe de jíín nújīí de, núu súcuan te tú ni ɨɨn ndajníñu de ndoñúhún. ");
INSERT INTO mibNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Te núu quiji ɨnga tēe ndacuī gā, te cundeyɨ́ jíín tée ún, núu súcuan te quende nujīí de jeē ndíto de vehe de, te sáha de ndese cúní maá de jíín ndajníñu jeē quénde de. Te nájnūhun tēe ndacuī gā ún, súcuan cúu máá rí nuū Satanás. ");
INSERT INTO mibNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Te ñayuu tu íyó mánī jiín rí, núu súcuan te jíto uhū i ruhū. Te ñayuu tu nástútú jíín rí, núu súcuan te sa jéte núu i ñayuu vējicoo nuū rī. ");
INSERT INTO mibNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Núu ni quenda ɨɨn tachī ini ɨɨn tēe tu cándíje, te jíca cuu nuū ñúhun téhé, ndúcú núū ndétātú, te tu níhín, yūcuán na te jéni ni maá: Na quínuhun rī vehe nuū ní quenda ri. ");
INSERT INTO mibNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Te núu ni ndee tucu, te jíto jeē tēe tu cándíje un cúu de nájnūhun ɨɨn vehe jeē ní ndundoo. ");
INSERT INTO mibNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yūcuán na te jéquihin uxā gā tachī xeén gā vēsú maá. Te quɨ́vɨcoo ini tēe un jéē cóyūcu yúcuan. Núu súcuan te xeēn gā ndoho tēe un jéē sándɨ̄hɨ́ vēsú jeē xíhna ñúhún. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Te níní cáhán yā jnūhun yáha, te ɨɨn ñahan íne mēhñu ñáyuu cuehē un, ní cahān jee ña jíín yá: Yōhyo ndetū ñahan ní scácu níhín te ni scáxin ña níhín, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Te ni cahān yā: Sa suhva yōhyo ga ndetū ñayuu cájini nahín jnúhun Yaā Dios te cásquícu i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Te ni cataca cuehē gā ñayuu nuū Jesús, te ni quejéé yá cahán yā: Ñayuu iyó vijna máni cásáha néé i. Te cájicān i ɨɨn jniñu jéhnu jeē steén núu Yaā ní tají Yaā Dios cúu ri. Te tú na ɨnga jniñu jéhnu stéén rī nuū i, chi máá‑ni jniñu jéhnu nájnūhun ni cuu jíín Jonás, tēe ni nacani jnūhun Yaā Dios nde jenahán. ");
INSERT INTO mibNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Chi nájnūhun ni cajini ñayuu ñuu Nínive jeē ní cuu ɨɨn jniñu jéhnu jíín Jonás, suni súcuan cuni ñayuu tiempo yáha jeē coo ɨɨn jniñu jéhnu jíín rúhū, Yaā ní nduu tēe, jeē quijnáhan jíín modo ni ndoho Jonás. ");
INSERT INTO mibNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Te reina jeē ní cujéhnu nación ichi sur, natecu ña jíín ñáyuu tiempo yáha, quɨvɨ̄ juicio jeē sándaā yā cuēchi, te cahān ña cuēchi sɨquɨ̄ i. Chi nde jicá téyɨ́ ní quiji ña ni jini nahín ña jnūhun ndíchí ní cahān rey Salomón. Te vijna chi cújéhnu ga ruhū, Yaā íne yāhá vēsú Salomón, te tu cácandíje ró rúhū. ");
INSERT INTO mibNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Te tāca ñáyuu ñuu Nínive nuū ní nacani Jonás jnūhun, natecu i jíín ñáyuu tiempo yáha, quɨvɨ̄ juicio jeē sándaā yā cuēchi, te cahān i cuēchi sɨquɨ̄ ñáyuu yáha. Chi máá i ni canacani ni i ni castóo i cuēchi i quɨvɨ̄ ní nacani Jonás jnūhun nuū i. Te vijna chi cújéhnu ga ruhū, Yaā íne yāhá vēsú Jonás, te tu cácandíje ró rúhū. ");
INSERT INTO mibNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Núu nástɨ́ɨn ñayuu ɨɨn lámpara, tu chísāhí i, ni tu chúne i chīji ɨɨn cajón. Chi sa suhva jéni i nuū sucún, návāha cundijin nuū ñáyuu quɨ́vɨcoo vehe. ");
INSERT INTO mibNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Te tɨnūu ró cúu nájnūhun lámpara nuū yɨquɨ cúñu rō. Núu súcuan te núu tɨnūu ró íyó ndijin, te nɨ́ɨ́‑ni yɨquɨ cúñu rō cúndijin. Te núu tɨnūu ró tu íyó ndijin, te nɨ́ɨ́‑ni yɨquɨ cúñu rō iyó nee. ");
INSERT INTO mibNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Te suni súcuan cúu ánuá rō, te coto ró jéē ma cáni néé ni rō, návāha tú coo nee ini anuá rō. ");
INSERT INTO mibNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Chi núu máni jniñu váha cásáha ró, te tú na jniñu néé cásáha ró, núu súcuan te luz yā cúndijin vāha ini anuá rō, nájnūhun ɨɨn lámpara jeē sáha jeē cúndijin vāha. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Te nuū ní cuu ni cahān yā, te ɨɨn tēe grupo fariseo ni cana de ya jeē caji yā staā vehe de. Te ni quɨ̄vɨ ya, te ni cucōo ya mesa jeē cáji yā staā. ");
INSERT INTO mibNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Te tēe fariseo un náā ni de jíto de jeē tu squícu ya costumbre jeē nandahá yá te caji yā staā. ");
INSERT INTO mibNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Te ni cahān maá Jítoho yō jiín de: Róhó tée fariseo jijnáhan ró, chi nájnūhun jeē cánacate ró yátā vaso jiín yátā cohó cúu jeē nándahá ró. Te ichi íni rō chi ñúhun máni máá jnúhun cuíhná jíín jnúhun néé. ");
INSERT INTO mibNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tēe cánéé cácuu ró. ¿A tu cájini rō jeē Yaā ni sáha yɨquɨ cúñu rō, suni ni sáha ya anuá rō? ");
INSERT INTO mibNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Te jeē cájēhe ró caridad nuū ñáyuu ndahú, na sáha ró sɨ́quɨ̄ jeē cundáhú ndije ni rō i. Te súcuan te coo ndaā anuá rō. ");
INSERT INTO mibNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Nacā xeēn ndoho róhó tée fariseo, chi cásquícu ró tācá jniñu lúlí, te tu cásquícu ró jniñu cánuú. Chi cásáha ró úxī uxī nuhnī tamīnu jíín ruda jiín táca yucū, te cásocō rō ɨɨn ɨɨn sɨquɨ̄ tāca úxī un núū Yaā Dios. Te tu cásáha cuɨtɨ rō jniñu ndaā, ni tu cáhīyo manī rō jiín Yaā Dios. Tāca jéē yáha cánuú sáha ró núú, te suni ma stóo ró jéē socó rō tāca yúcū ún. ");
INSERT INTO mibNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Nacā xeēn ndoho róhó tée fariseo, chi máni cánujnahan ni rō cucōo ró núū silla yɨñúhún gá ini vehe iī sinagoga. Te cánujnahan ni rō jeē cahán yɨñúhún ñáyuu jiín ró nuū calle. ");
INSERT INTO mibNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Te nacā xeēn ndoho róhó tée cástéén tutu ley Yaā Dios, jiín róhó tée fariseo, chi tēe stáhú‑ni cácuu ró. Chi cándāa ró nájnūhun yaū ndɨ̄yɨ jeē tú ndijin, chi cásnáā rō anuá ñayuu, te tu jíní i jeē súcuan cásáha ró jíín i. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yūcuán na te ni cahān ɨɨn tēe stéén tutu ley: Maestro, jeē ni cáhān ni táca jnúhun yáha, suni nde sɨquɨ̄ maá ná jíjnáhan ná ní cahān ní, áchí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Te ni cahān yā: Suni nacā xeēn ndoho róhó tée cástéén tutu ley. Chi suni cástéén rō tāca ley ni catava maá ró jeē yɨɨ́ sáha, te tu cácundeyɨ́ ñáyuu squícu i. Te máá ró, chi ni ɨɨn xinī ndáha ró tu cáscánda ró jéē squícu ró. ");
INSERT INTO mibNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Nacā xeēn ndoho ró jíjnáhan ró. Chi cásáha ró vehe sɨquɨ̄ nuū yɨ́ndūji ndɨ̄yɨ jií rō, tēe ni canacani jnūhun Yaā Dios nde jenahán. Te suni tāca jíí rō ni cajehni de tēe ún. ");
INSERT INTO mibNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Te jeē casáha ró súcuan cúu jeē cáquijnáhan ró jíín de sɨquɨ̄ jníñu ní casáha de. Chi máá de ni cajehni tēe ún, te máá ró cásáha ró vehe ndɨ̄yɨ ún. ");
INSERT INTO mibNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Jeē yúcuan nde jenahán ní cahān Yaā Dios ɨɨn jnūhun ndíchí: Tají rí tāca tée nacani jnūhun ri jiín táca tée apóstol quingoo de nuū i. Te sava de cahni i, te sava ga de coto xeēn i, áchí Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Te súcuan te sɨquɨ̄ ñáyuu tiempo yáha na cóndee cuēchi jeē ní cajehni jií i tēe ni canacani jnūhun Yaā Dios, nde quɨvɨ̄ ni jécōo ñayɨ̄vɨ́ te nde vijna, ");
INSERT INTO mibNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nde Abel xīhna gā te nde Zacarías, tēe ni cajehni de ini templo sava mēhñu cuarto iī jiín altar. Núu súcuan te cáhán rī jiín ró jeē sɨquɨ̄ ñáyuu tiempo yáha condee tāca cuéchi ún. ");
INSERT INTO mibNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Nacā xeēn ndoho róhó jéē castéén tutu ley, chi cájesɨ rō ichi jeē jécūhun ni ñayuu jnūhun ya. Chi ni máá ró tu cácuni rō jecūhun ni rō, ni tu cájēhe ró jnúhun jeē jecūhun ni ñayuu cácuni. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Te jeē ni cáhān yā jnūhun yáha, te tēe cástéén tutu ley Yaā Dios jiín tée fariseo, yōhyo ni caquɨtɨ̄ ni de nuū yā. Te ni caquejéé de cástíchí de ya sɨquɨ̄ cuehē gā jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Chi yuhu‑ni cánducú de núu sanaa te stɨ́vɨ yá jnūhun cahān yā, návāha nihīn de cuēchi sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Te níní súcuan cúu, te ni cacutútú cuéhē mil ñayuu, chi nde cájeñū i sɨquɨ̄ jehé jnáhan i. Te xīhna gā ni quejéé yá cahán yā jiín tée cáscuáha jíín yá: Coto má candíje ró levadura tēe grupo fariseo, chi suu cúu jnūhun stáhú cácahān de. Chi jíté núu nuū ñáyuu, nájnūhun ndécava levadura nuū ñújen pan. ");
INSERT INTO mibNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chi jnūhun stáhú un má quéndōo sāhí cuɨtɨ, chi ndɨhɨ natūu ndijin, te cuni ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Núu súcuan te suni máá ró, tāca jnúhun ni cacahān rō jeē tu ní jíní ñayuu, ɨɨn quɨvɨ̄ te cuni vāha i. Te tāca jnúhun ni cacahān sāhi ró jeē ndihyú yehyɨ́, ɨɨn quɨvɨ̄ te cahān jee ñayuu yatā tācá vehe. ");
INSERT INTO mibNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Cáhán rī jiín ró jijnáhan ró, amigo: Ma yūhu ró coto ró ñáyuu cahni yɨquɨ cúñu rō, chi núu ni cajehni i róhó, te tuá na vé cúu sáha ga i. ");
INSERT INTO mibNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Te na cáchi rī nuū rō ndé ɨɨn yūhu ró coto ró: Jeē yūhu ró coto ró cúu Yaā Dios jeē núu sáha ya jeē cúū rō, te íyó poder yā chune ya rohó infierno. Suu máá yá cúu jeē yūhu ró jeē ma stɨ́vɨ ró nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Te tācá saa chi tú yahu ndéé tɨ̄, chi nde uhūn tɨ̄ jeē uú centavo lulí. Te ni ɨɨn tɨ tu náā ni Yaā Dios jeē tu ndíto ya. ");
INSERT INTO mibNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Te nagā ni cuu róhó jíjnáhan ró, chi nde ndɨhɨ ixi xíní rō je ni cahu ya. Núu súcuan te ma yūhu ró jijnáhan ró, chi cánuú ndasɨ́ gá rō nuū yā vēsú cuehē tācá saa. ");
INSERT INTO mibNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Te cáhán rī jiín ró, tāca ñáyuu jeē cuajnúhún rúhū nuū ɨnga ñayuu, suni súcuan ruhū, Yaā ní nduu tēe, cuajnúhún rí i nuū tācá ndajéhé Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Te tāca ñáyuu jeē ma cuájnúhún rúhū nuū ɨnga ñayuu, suni súcuan ma cuájnúhún rí i nuū tācá ndajéhé Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Te núu ndé ñáyuu cahān i sɨquɨ̄ ruhū, Yaā ní nduu tēe, cone cáhnu ni Yaā Dios nuū i. Te núu ndé ñáyuu cahān ndevāha i sɨquɨ̄ Espíritu Santo, ma cóne cáhnu ni Yaā Dios nuū i. ");
INSERT INTO mibNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Te núu cuandeca i róhó táca vehe iī sinagoga nuū tée cásándaā cuēchi, jíín núū tée cácuu tohō, te ma nácani ndasɨ́ ni rō ndese stíó cuɨ́ñɨ́ rō jnūhun nuū de. ");
INSERT INTO mibNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chi máá hora un te Espíritu Santo steén yā nuū rō ndese cahān rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yūcuán na te ɨɨn tēe íne nuū ñáyuu cuehē un ní cahān de jíín Jesús: Maestro, cahān ni jíín ñani na jéē na táhú sáva de tahū na jíín de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Te ni cahān yā jiín de: ¿Ndé ɨɨn ni jeni ruhū jeē ndacu ri jniñu tahū sáva tahū rō? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Te ni cahān gā yā: Condito ró máá ró jijnáhan ró jéē ma ndíyo ni rō xūhun jíín táca gá. Chi vēsú cuehē ndasɨ́ ndajníñu névāha ɨɨn tēe, te nasūu jéē yúcuan sáha jeē quéndōo ndetū de, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yūcuán na te ni cahān yā ɨɨn jnūhun yátá jíín i: Ni īyo ɨɨn tēe cúcá jeē névāha ñuhun jeē cúu vāha ndasɨ́ itu. ");
INSERT INTO mibNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Te tēe cúcá un ní nacani ni de: ¿Ndese sáha ri? Chi tuá ndé cuhun nɨñɨ ri. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Te ni jeni ni de: Suhva na sáha ri. Na cánu rī tāca yácā rī, te nasáha ri jeē náhnu ga. Te yūcuán chuvāha ndɨhɨ ri nɨñɨ ri jiín táca ndajníñu ri. ");
INSERT INTO mibNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yūcuán na te cahān rī jiín ánuá rī: Vijna te cuehē teyɨ́ névāha yó jéē canda cuehē cuiyā. Na ndétātu yó te caji yō coho yó, te na cúsɨɨ̄ ni yō, ni jeni ni de. ");
INSERT INTO mibNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Te ni cahān Yaā Dios jiín de: Tēe cánéé cúu ró. Chi jecuáā vijna cuu rō, te tāca jéē ní chuvāha ró, ¿ndé tée cuu? Achí Yaā Dios jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Te súcuan ndoho tāca tée jeē sacúcá de máá de, te tu ndúcú de jeē quendōo ndetū de sáha Yaā Dios. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Te ni cahān yā jiín tée cáscuáha jíín yá: Núu súcuan te cáhán rī jiín ró: Ma nácani ndasɨ́ ni rō sɨquɨ̄ jeē cótecu rō, núu ndese caji rō, ni sɨquɨ̄ sahma, núu ndese cuhun ró. ");
INSERT INTO mibNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Chi Yaā Dios ni sáha ya jeē técu rō jiín yɨquɨ cúñu rō, te nagā ni cuu jeē ma cuáha ya jeē cáji rō jiín jéē cúhun ró. ");
INSERT INTO mibNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Condēhe ró ndese cátecu quɨtɨ cácuu nájnūhun cálú, chi tu cátaji tɨ, ni tu cánastútú tɨ́ jeē chúvāha tɨ, ni tú yacā tɨ̄. Te vēsú súcuan te máá Yaā Dios scáji yā tɨ̄. Te cánuú ndasɨ́ gá rō jijnáhan ró vēsú tācá quɨtɨ ún. ");
INSERT INTO mibNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Te ndé ɨɨn ró, á cuu scuéhnu ró máá ró sava metro gā, vēsú na nácani ndasɨ́ ni rō? ");
INSERT INTO mibNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Te núu ma cúu sáha ró vēsú ɨɨn jniñu lúlí súcuan, ¿te najehē cánacani ndasɨ́ ni rō sɨquɨ̄ jeē cáji rō jiín jéē cuhun ró? ");
INSERT INTO mibNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Condēhe jíjnáhan ró ndese jée ita tāca yúcū. Chi tu sájniñu, ni tu táú. Te cáhán rī jiín ró jeē ni rey Salomón, quɨvɨ̄ ní ñúhun de sahma váha ndasɨ́, tu ní ñúhun de sahma lúu súcuan nájnūhun ita ún. ");
INSERT INTO mibNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Te núu súcuan jéhe Yaā Dios sahma lúu ita un jéē jée vijna te sajnē cayū nuū ñuhún, te nagā ni cuu róhó jíjnáhan ró jéē ma sáha ya jeē nihín rō sahma. ¿Te naun tu cácandíje nīhin ró jéē ndíto ya rohó? ");
INSERT INTO mibNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Núu súcuan te ma nácani cuíhyá ni rō ndese caji rō ndese coho ró. ");
INSERT INTO mibNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Chi tāca ñáyuu ñayɨ̄vɨ jéē tu cácandíje cúu jeē máni sɨquɨ̄ jeē yáha cándɨhvɨ̄ ni i. Te máá ró jijnáhan ró, chi íyó Tátá rō andɨvɨ́, te jíní yā jeē cájini ñúhún ró tāca jéē yáha. ");
INSERT INTO mibNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Te sa suhva cánuú gá jeē cóndɨhvɨ̄ ni rō sɨquɨ̄ jniñu jeē ndácu Yaā Dios nuū rō. Yūcuán na te sáha ya jeē nihín rō tāca jéē yáha. ");
INSERT INTO mibNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Ma yūhu ró jijnáhan ró chi cácuu ró nájnūhun lanchi ri. Chi vēsú jecu‑ni cácuu ró, te máá Tátá rō cúsɨɨ̄ ni yā jeē quɨ́vɨcoo ró ñuu nuū ndácu ya jniñu. ");
INSERT INTO mibNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xīco ró jeē cánevāha ró, te cuāha ró xúhun un núū ñáyuu ndahú. Te súcuan caya rō tahū rō nde andɨvɨ́ núū ma cútúhú, nájnūhun jeē chúvāha ró xúhun ini yɨjnɨ. Chi nde andɨvɨ́ te ma náā jeē váha conevāha ró. Chi yūcuan má quɨ́vɨ ñacuīhná, ni ma cúu stɨ́vɨ tiquíxin. ");
INSERT INTO mibNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Chi nde nuū nihín rō tahū váha ró, yūcuan cúu nuū cóndɨhvɨ̄ ni rō sɨquɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Coo tūhva ró jíjnáhan ró jéē ndéē Jitoho rō, te coo ró nájnūhun mozo jeē nastɨ́ɨn i lámpara i. ");
INSERT INTO mibNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Chi íyó túhva i te cándetu i jeē ndéē patrón i jeē cuahán de vico nándāha. Chi núu ni ndee de te cahān de, te nune‑ni i yéhyɨ́ jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Te yōhyo ndetū mozo un núu ni ndee patrón i, te cuni de jeē cándito i. Jendaá cahán rī jiín ró jeē maá patrón sátūhva de máá de, te scúcōo de i mesa te cani de cohō i. ");
INSERT INTO mibNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Te vēsú cucuéé de ndee de nde sava ñuú, chí jéē néē gā, te núu cuni de jeē súcuan cándito mozo de, te yōhyo ndetū i jíjnáhan i núu súcuan. ");
INSERT INTO mibNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Te na jécūhun ni rō jeē cahán jnūhun yátá yáha: Tēe chíí vehe, núu ni jini de na hora quiji ñacuīhná, te condito de, te ma cuáha de jnūhun jeē sacuíhná vehe de núú. ");
INSERT INTO mibNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Te suni súcuan coo tūhva ró jíjnáhan ró, chi núu tuú, te máá hora jeē tú na vé cájeni ni rō, te ndee ruhū, Yaā ní nduu tēe. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yūcuán na te Pedro ni cajnūhún de ya: ¿A jíín máá‑ni ná jíjnáhan ná cáhán ni jnúhun yátá yáha, chí suni cáhán ni jíín ndɨhɨ ga ñayuu? achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Te ni cahān maá Jítoho yō: Cáhán rī jiín ndé‑ni ñayuu cúu nájnūhun mozo jeē ndito xinī te squícu vāha. Te máá patrón sáha de jeē condiso jníñu i coto i ñayuu vehe de, návāha scáji i máá hora. ");
INSERT INTO mibNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Te yōhyo ndetū mozo un jéē núu ni ndee patrón, te cuni de jeē súcuan squícu vāha i. ");
INSERT INTO mibNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Jendaá cahán rī jiín ró jeē cani de mozo un jéē cóto i ndɨhɨ ndajníñu de. ");
INSERT INTO mibNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Te núu jéni ni i jeē ma ndíji yachī patrón i, te quejéé i cani i tēe jíín ñahan cácuu jnáhan mozo i, te caji i coho i te najīni i, ");
INSERT INTO mibNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","núu súcuan te ndee‑ni patrón quɨvɨ̄ jeē tu ndétu i jíín hora jeē tú na vé jéni ni i. Te stóho xeēn de i, te squɨ́vɨ de i ndoho i jíín ñáyuu tu cásquícu. ");
INSERT INTO mibNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Te mozo jeē jiní i ndese nújnahan ni patrón i, te núu tu sátūhva i ni tu squícu i jeē cuní de, ndoho xeēn i jíín yujnu xíi. ");
INSERT INTO mibNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Te mozo jeē tu jíní i ndese nújnahan ni patrón i, te núu sáha i jniñu jeē cani de i, núu súcuan te cūhva‑ni cani de i. Chi ñayuu jeē steén cuehē yā nuū i, suni cuehē nandacān yā nuū i. Te ñayuu jeē cuehē gā jniñu téjníñu ya i, suni cuehē gā nandacān yā nuū i. ");
INSERT INTO mibNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ni quee rī jeē nájnūhun jeē scuiquín rī ñuhūn ini ñayɨ̄vɨ́, te suu cúu jeē cusɨ́ɨn ini ñayuu jeē sɨquɨ́ ruhū. Te cúní rī jeē yachī coo súcuan, návāha quɨ̄vɨcoo ñayuu ndaha Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Te íyó ɨɨn jnūndóho cánuú ndoho ri, te cúcuíhyá ndasɨ́ ni rī chi nde jīnu ndoho ri, te ndusɨɨ̄ ni rī. ");
INSERT INTO mibNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A cájeni ni rō jeē véji ri jeē cóyūcu mánī ñayuu ñayɨ̄vɨ́? Cáhán rī jiín ró jeē tuú, chi sa suhva jeē cusɨ́ɨn ini ñayuu jeē sɨquɨ́ ruhū. ");
INSERT INTO mibNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chi nde vijna te quejéé jéē uhūn ñayuu ɨɨn vehe, sásɨ́ɨn máá jíjnáhan, unī sɨquɨ̄ uú, te uū sɨquɨ̄ uní. ");
INSERT INTO mibNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Chi tátá cusɨ́ɨn ini jiín séhe yɨɨ́, te sēhe yɨɨ́ jíín tátá, te náná jiín séhe sɨ́hɨ́, te sēhe sɨ́hɨ́ jíín náná, te náná chīso jíín séhe jēnú, te sēhe jēnu jíín náná chīso. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Te suni ni cahān yā jiín ñáyuu cuehē ún: Núu cájito ró jeē náne vicō ichi núū cáne niāndii, te cácahān rō jeē cuun saū, te súcuan cúu. ");
INSERT INTO mibNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te núu quée tachī vēji ichi sur te cácahān rō jeē nandii, te súcuan cúu. ");
INSERT INTO mibNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tēe stáhú‑ni cácuu ró. Chi cájecūhun ni rō ndese stéén seña andɨvɨ́ jíín ini ñayɨ̄vɨ́, ¿te naun tu cájecūhun ni rō ndé ɨɨn cúu ruhū jeē sáha ri tācá jniñu jéhnu tiempo yáha? ");
INSERT INTO mibNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Te najehē tu cánacani ni maá ró ndé ɨɨn cúu jniñu ndaā sáha ró? ");
INSERT INTO mibNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Te núu ɨɨn ñayuu quihīn i jíín ró nuū tohó jeē cacán i cuēchi sɨquɨ̄ rō, núu súcuan te níní cuáhān rō jiín i ichi te condɨhvɨ̄ ni rō sándaā rō jiín i. Chi núu tuú, te squɨ́vɨ i róhó núū juez, te juez siáha de róhó núū policía, te policía chune de róhó vecāa. ");
INSERT INTO mibNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Te jendaá cahán rī jiín ró jeē ma quénda cuɨtɨ rō yūcuán chi nde chunaa rō ndɨhɨ cuɨtɨ xūhun cájicān de. Te suni súcuan condɨhvɨ̄ ni rō cahān ndahú ró jiín Yaā Dios, návāha ma ndácunehen ya cuēchi sɨquɨ̄ rō. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Te ɨɨn quɨvɨ̄ yúcuan ní quecoo jecu tēe, ni canacani de jnūhun nuū yā ndese ni candoho jecu tēe Galilea. Chi ná cájehni de quɨtɨ jeē socó de, te ni quecoo mozo Pilato ni cajehni tēe ún. ");
INSERT INTO mibNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Te ni cahān Jesús: Tēe Galilea un, ¿á cájeni ni rō jeē súcuan ni candoho de sɨquɨ̄ jeē xeēn gā ni īyo cuēchi de vēsú tāca gá ñayuu Galilea? ");
INSERT INTO mibNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Cáhán rī jiín ró jeē tuú. Te róhó jíjnáhan ró suni jnahnū ndetū rō núu tú nacani ni rō jeē stóo ró cuéchi ró. ");
INSERT INTO mibNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Te xahūn unī tēe jeē ní cotúú torre Siloé sɨquɨ̄ de, te ni cajihī de, ¿á cájeni ni rō jeē ní casáha de cuēchi xeēn gā vēsú tāca gá ñayuu ñuu Jerusalén? ");
INSERT INTO mibNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Cáhán rī jiín ró jeē tuú. Te máá ró jijnáhan ró, suni jnahnū ndetū rō núu tú nacani ni rō jeē stóo ró cuéchi ró. ");
INSERT INTO mibNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yūcuán na te ni cahān yā jnūhun yátá yáha jéē steén yā ndese cácuu ñayuu tu squícu jnūhun Yaā Dios: Cácuu i nájnūhun ɨɨn nundēhe higo jeē íin nuū ñúhun ɨɨn tēe. Te ni jecondēhé de núu íin ndehē xinī, te tú na vé íin. ");
INSERT INTO mibNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Te ni cahān de jíín mozo sájniñu nuū ñúhun de: Vijna te je íyó únī cuiyā jeē quíji ri nducú rí ndehē xinī yújnu higo yáha, te tú na vé cúun xinī. Núu súcuan te cahnde rō, chi máá jéē sajnéñu nuū ñúhun, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Te ni cahān mozo un jíín de: Stóo ní na cuɨ́ñɨ ɨɨn na cuiyā, te na nástáyā ná jéhē te chuhun ná jéhen. ");
INSERT INTO mibNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Te na cóndēhe yó núu tú cuun ndehē ɨnga cuiyā. Te núu tuú, te tahndē, achí mozo. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Te ɨɨn quɨvɨ̄ ndétātú te stéén Jesús jnūhun ini vehe iī sinagoga. ");
INSERT INTO mibNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Te íyó ɨɨn ñahan jeē ní cuu xahūn unī cuiyā cuhú ña. Chi ɨɨn tachī ni sáha jeē jíca tɨ́hɨ́ ña, te tuá cúu cuɨtɨ caca jnuu ña. ");
INSERT INTO mibNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Te ni jito Jesús nuū ña, te ni cana ya ña, te ni cahān yā jiín ña: Vijna te nduvāha ní jéē cuhú ni. ");
INSERT INTO mibNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Te ni soó yá ndaha ya sɨquɨ̄ ña, te ni nucuɨñɨ̄ jnuu‑ni ña, te ni nacuatáhú ña nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Te tēe cújéhnu ini vehe iī sinagoga, ni quɨtɨ̄ ni de nuū Jesús jeē ní nasávāha ya ñahan un quɨ́vɨ̄ ndétātú. Te ni cahān de jíín ñáyuu: Iñū quɨvɨ̄ iyó jéē sájniñu yó, te tāca quɨ́vɨ̄ ún quijicoo ró nduvāha ró. Te quɨvɨ̄ ndétātú chi ma cúu, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yūcuán na te ni cahān maá Jítoho yō jiín de: Tēe stáhú‑ni cácuu ró. Quɨvɨ̄ ndétātu ¿á tu cándají ró stɨquɨ̄ rō burro ró jéē quíscóho ró tɨ́ ndute? ");
INSERT INTO mibNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Te ñahan yáha jéē cúu ña ɨɨn sēhe yucūn Abraham, chi nájnūhun ni conuhnī ña xahūn unī cuiyā ni sáha Satanás. ¿Te á tu íyó váha jeē nájnūhun nandají rí ña nuū cuehyɨ̄ ndóho ña quɨvɨ̄ ndétātú? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Te jeē ni cáhān yā súcuan, te tāca tée cájito uhū de ya, ni cacucanu de. Te ndɨhɨ ñayuu ún chi ni cacusɨɨ̄ ni i jíto i tācá jniñu jéhnu sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Te ni cahān yā: Na cáhán rī ɨɨn jnūhun yátá návāha cuni rō ndese ndúcuehē ñayuu ndácu Yaā Dios jniñu nuū. ");
INSERT INTO mibNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ndúcuehē i nájnūhun jéhnu ɨɨn ndɨquɨn mostaza jeē jéquin ɨɨn tēe nuū ñúhun de, te ndúu nájnūhun ɨɨn yujnu. Te cúu cáhnu, te tācá saa chi cásáha tɨ tacā tɨ̄ chīji ndaha ún. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Te ni cahān tucu ya: Súcuan cúu jeē ndúcuehē ñayuu jeē ndácu Yaā Dios jniñu nuū: ");
INSERT INTO mibNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Cúu nájnūhun levadura jeē ní quihin ɨɨn ñahan, te ni saca ña jíín únī kilo harina, te ni ndaa ndɨhɨ ñujen ni sáha. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Te jíca Jesús jeē cuahán yā ichi ñúū Jerusalén, te yáha ya tācá ñuu náhnu jíín ñuu lulí, te stéén yā jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Te ɨɨn ñayuu ni cajnūhún i ya: ¿A jecu‑ni ñayuu jnama Yaā Dios, chí naún? Achí i. Te ni cahān yā jiín i: ");
INSERT INTO mibNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Condɨhvɨ̄ ni rō quɨ̄vɨcoo ró ndaha Yaā Dios. Chi cúu nájnūhun ɨɨn yéhyɨ́ túū. Te cáhán rī jiín ró jeē ɨɨn quɨvɨ̄ te cuehē ñayuu nducú i quɨ̄vɨcoo i, te ma cúu ga. ");
INSERT INTO mibNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Te quɨvɨ̄ ún te sáha ri nájnūhun ɨɨn tēe chíí vehe jeē ndocuɨñɨ̄ de te nacasɨ de yéhyɨ́. Te ichi yátá véhe cuɨñɨ ró jíjnáhan ró, te scáján ró yehyɨ́, te cahān rō: Nune ní yéhyɨ́ na quɨ́vɨcoo ná. Te cahān de jíín ró: ¿Ndé nuū véjicoo ró? Chi tu jíní rī rohó, achi de. ");
INSERT INTO mibNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yūcuán na te quejéé ró cahān rō jiín de: Ni cayeji ná ni cajihi ná jíín ní, te ini calle ñuu na ní steén ni jnúhun, achi rō. ");
INSERT INTO mibNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Te cahān maá de: Cáhán rī jiín ró jeē tu jíní rī rohó ndé chi véjicoo ró. Cujiyo quingoo ró, chi ñayuu casáha jniñu néé cácuu ró. Achi de. ");
INSERT INTO mibNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Te quɨ̄vɨcoo ró núū ndahyú rō, te nacayɨ̄hɨ́ yuhu ró jéē ndoho xeēn rō. Te coto ró núū Abraham jiín Isaac jiín Jacob jiín ndɨhɨ tēe ni canacani jnūhun Yaā Dios, cáyūcú de ñuu nuū ndácu ya jniñu. Te róhó, vēsú cácuu ró yúcūn de, te quɨ̄vɨcoo ró núū ndoho ró. ");
INSERT INTO mibNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Te cuehē ñayuu, vēsú tu cácuu i yucūn de, te quijicoo i ichi núū cáne niāndii jíín ichi núū quée niāndii, ichi norte jiín ichi sur. Te cucōo i mesa caji i staā ñuu nuū ndácu Yaā Dios jniñu. ");
INSERT INTO mibNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Te sava ñayuu jeē vijna cácuu i sandɨ̄hɨ́, ichi yúcuan nduu i nuū. Te sava ñayuu jeē vijna cácuu i nuū, ichi yúcuan nduu i sandɨ̄hɨ́. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Te máá quɨ́vɨ̄ un ní quecoo jecu tēe fariseo, te ni cacahān de jíín yá: Cujiyo ní quíhīn ní ɨnga lado, chi cúní Herodes cahni de níhín, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Te ni cahān yā: Cuángoo te castūhun ró nuū tēe mañoso un jéē ná tu jinū quɨvɨ̄ cuu rī, chi vijna jíín sájnē quenehen ri tachī ini ñayuu, te nasávāha ri ñayuu cácuhū. Te isá te jīnu jniñu sáha ri, achi rō. ");
INSERT INTO mibNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Chi cánuú jéē cáca ri quihīn rī vijna jíín sájnē jiín isá, te jinū rī Jerusalén. Chi tēe cánacani jnūhun Yaā Dios, tu cájihī de ɨnga lado, chi máá‑ni ini ñuu Jerusalén cájehni i de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Róhó ñuu Jerusalén, jéhni rō tēe cánacani jnūhun Yaā Dios, te jéhe ró yúū xinī tée tájí Yaā Dios vējicoo nuū rō. Te cuehē jínu ni cuni rī nastútú rí sēhe ró, nájnūhun ndují jéē nastútú tɨ́ sēhe tɨ chīji ndijēn tɨ̄, te tu ní cúní rō. ");
INSERT INTO mibNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Núu súcuan te vijna te stóo uun na ri rohó jíín séhe ró. Te cáhán rī jiín ró jéē ndé vijna te ma cóto cuɨtɨ gā rō nuū rī, chi nde quiji quɨvɨ̄ jeē cahán sēhe ró: Yōhyo vāha Yaā cúu Yaā véndiji jíín jniñu máá Jítoho yō Yaā Dios, achi i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Te ɨɨn quɨvɨ̄ ndétātu ní jehēn yā vehe ɨɨn tēe fariseo cujéhnu, ni jecaji yā staā jiín de. Te tāca gá tēe fariseo cájito yuhu de ya núu stɨ́vɨ yá. ");
INSERT INTO mibNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Te yūcuan íne ɨɨn tēe cúhú de cuehyɨ̄ cuɨñɨ, índichi de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Te ni cajnūhun yá tēe cástéén tutu ley Yaā Dios jiín táca tée fariseo: ¿A íyó ley jeē nasávāha ri ñayuu cácuhū quɨvɨ̄ ndétātu, chí tuú? áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Te máá de tu ní cácahān cuɨtɨ de. Te ni jnɨɨ ya tēe cúhú un, te ni nasávāha ya de, te ni cahān yā jeē na núhun de vehe de. ");
INSERT INTO mibNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Te ni cahān yā jiín de jíjnáhan de: ¿Ndé ɨɨn róhó núu burro ró chí stɨ́quɨ̄ rō nɨngava tɨ ini pozo, te á tu yachī natava rō tɨ̄ vēsú quɨvɨ̄ ndétātu cúu, chí naún? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Te tu ní cúu stíó cuɨ́ñɨ́ de ni ɨɨn jnūhun nuū yā jeē súcuan ni cahān yā. ");
INSERT INTO mibNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Te ni jito Jesús jeē tée ni cataca ún, cánacāji de silla yɨñúhún gá nuū mesa cucōo de. Te ni cahān yā jnūhun yáha jíín de: ");
INSERT INTO mibNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Núu ɨɨn tēe cana de jeē quihín rō ɨɨn vico nándāha, te ma cúcōo ró lugar nuū yɨñúhún gá. Chi núu súcuan te sanaa te je ni cana de ɨɨn tēe cújéhnu ga vēsú rohó. ");
INSERT INTO mibNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Te quee tēe ni cana róhó, te cahān de jíín ró: Ndonda, te na cúcōo tēe yáha jíñā. Yūcuán na te cucanu rō jeē quihín rō cucōo ró ndé sandɨ̄hɨ́ na. ");
INSERT INTO mibNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Chi sa suhva núu ni cana ɨɨn tēe róhó, te cucōo ró ndé lugar sandɨ̄hɨ́ na. Te núu quee tēe ni cana róhó, te cahān de jíín ró: Amigo, nehen cucōo ró ɨɨn lugar nuū yɨñúhún gá, achi de. Yūcuán na te ñayuu cáyūcu mesa jiín ró coto i jeē sajéhnu de róhó. ");
INSERT INTO mibNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Súcuan ni cahān rī jnūhun yáha návāha cuni rō jeē tāca ñáyuu jeē sajéhnu i máá i, nuu i sáha Yaā Dios. Te ñayuu jeē snúū i máá i, ndujéhnu i sáha ya. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Te suni ni cahān yā jiín tée ni cana ya yéji yā staā: Núu sáha ró ɨɨn vico cúsámá chí jéē cuxíni, te ma cána ró ñáyuu cácuu amigo rō, jiín ñani rō, jiín jnáhan ró, jíín ñáyuu cucá. Chi núu súcuan te suni máá i nacana i róhó, te súcuan nanihīn rō jeē ni jéhe ró. ");
INSERT INTO mibNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Chi sa suhva núu sáha ró vico, te cana ró ñáyuu ndahú, ñayuu cuhndú, ñayuu chacuá, jíín ñáyuu cuaá. ");
INSERT INTO mibNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Te súcuan te quendōo ndetū rō, chi ma cúu nacuāha i nuū rō. Te nihīn rō tahū rō quɨvɨ̄ nátecu ñayuu ndaā, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Te ɨɨn tēe yéji staā jiín yá, ni jini de jnūhun yáha, te ni cahān de jíín yá: Yōhyo ndetū ñayuu jeē cáji staā nde ñuu nuū ndácu Yaā Dios jniñu, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yūcuán na te ni cahān Jesús ɨɨn jnūhun yátá jéē steén yā jeē cána Yaā Dios ñayuu quɨ̄vɨcoo i ñuu nuū ndácu ya jniñu: Ɨɨn tēe ni sáha de ɨɨn vico cáhnu cuxíni, te ni tají de mozo ni cana cuehē ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Te máá quɨ́vɨ̄ cuxíni, te ni tají de mozo de cuacana ñayuu jeē quíjicoo caji staā: Nehen ní jíjnáhan ní, chi je íyó túhva ndɨhɨ, áchí mozo. ");
INSERT INTO mibNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Te ndɨhɨ i ni cacahān i jeē na cóne cáhnu ni de chi ma quíngoo i. Ɨɨn tēe ni cahān de: Sáá ní jeen ri ɨɨn ñuhun te cánuú quícondēhe rí, te na cóne cáhnu ni de chi ma jeé rī. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Te ɨnga de ni cahān: Ni jeen ri uhūn yunta stɨquɨ̄, te quihīn rī coto ndee rī tɨ̄, te na cóne cáhnu ni de nuū rī chi ma jeé rī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Te ɨnga de ni cahān de: Sáá ní quijnáhan ri, te jeē yúcuan ma cúu jeē rī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Te cuanuhun mozo un, te ni castūhún de nuū patrón de ndese ni cacahān ñayuu. Yūcuán na te ni quɨtɨ̄ ni patrón, te ni cahān de jíín mozo de: Yachī quihīn rō tāca calle náhnu jíín calle lulí, te cana ró ñáyuu ndahú, ñayuu cuhndú, ñayuu chacuá, jíín ñáyuu cuaá, na quíjicoo i vico, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Te ni jehēn mozo, te ni ndee de, te ni cahān de jíín patrón de: Je ni sáha ná jéē ni cáhān ní, te cúmanī gā ñayuu te chitú vehe ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Te ni cahān tucu patrón: Quihīn tucu ró táca calle jiín ichi, te cana fuerza rō ñayuu na quíjicoo i, návāha chitú vehe ri. ");
INSERT INTO mibNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chi cáhán rī jiín ró jeē ní ɨɨn tēe ni cana ri xīhna ñúhún, ma cuáha cuɨtɨ rī jnūhun jeē cuxíni de vehe ri, achí de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Te cuehē ndasɨ́ ñáyuu cándiquīn i Jesús cuangoo i jíín yá, te ni ndió cóto ya nuū i, te ni cahān yā jiín i: ");
INSERT INTO mibNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Núu na‑ni ñayuu cuní condiquīn ruhū, te núu manī gā i jíín tátá i, náná i, ñasɨhɨ́ i, sēhe i, ñani i, cuāha i, vēsú jiín rúhū, ma cúu cuu i ñayuu scuáha jíín rí. Te núu ndɨ́hvɨ́ gā ni i sɨquɨ̄ jeē cóo vāha máá i vēsú jeē cóndiquīn i ruhū, te suni ma cúu tucu. ");
INSERT INTO mibNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Te na‑ni ñayuu núu tu jéhe i jnūhun ndoho i jnūndóho vēsú nde cuu i jeē sɨquɨ́ jeē cóndiquīn i ruhū, te ma cúu cuu i ñayuu scuáha jíín rí. ");
INSERT INTO mibNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Chi núu ndé ɨɨn ró cúní rō sáha ró ɨɨn vehe cáhnu, ¿á tu cánuú jéē xíhna gā cucōo ró te tava rō cuenta núu canda xūhun jéē sínu ró? ");
INSERT INTO mibNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Chi núu tuú, te núu je ni jequin rō cimiento, te tu cánda xūhun ró sínu ró, yūcuán na te tāca ñáyuu sácatā i coto i róhó. ");
INSERT INTO mibNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Te cahān i: Tēe yáha ní quejéé de sáha de vehe, te tu ní cánda de sínu de, achi i. ");
INSERT INTO mibNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Te suni súcuan núu ɨɨn rey quihīn de cuajnáhan de jíín ɨnga rey jeē véji sɨquɨ̄ de, ¿á tu cánuú jéē xíhna gā cucōo de te nacani ni de núu canda uxī mil soldado jeē cuajnáhan de jíín ɨnga rey jeē véji sɨquɨ̄ de jíín ócō mil soldado? ");
INSERT INTO mibNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chi núu tú canda de, te níní jícá gá vēji ɨnga rey, te tají de tēe cándiso jníñu, cajnūhún de na vé cuní ɨnga rey jeē cuáha de nuū, te jecuɨñɨ̄‑ni. ");
INSERT INTO mibNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Te máá ró jijnáhan ró, suni súcuan cánuú jéē xíhna gā nacani ni rō cahnde ni rō stóo ró ndɨhɨ jeē névāha ró, chi núu tuú te ma cúu cuu ró ñáyuu scuáha jíín rí. ");
INSERT INTO mibNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Te ñayuu cácandíje cácuu i nájnūhun ñɨɨ̄. Vāha íyó ñɨ́ɨ̄, te núu ñɨɨ̄ ún na náā jeē uhvuá, ¿te ndese nduu uhvuā tucu? ");
INSERT INTO mibNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tuá cuajníñu cuɨtɨ, ni jeē chúhun ñayuu nuū ítu, ni jeē ndúu jēhen, chi máá cate iī‑ni i. Tāca róhó jéē jíni sōho, na chúsóhó ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Te tāca tée cástútú xúhun renta jiín táca gá tēe cásáha cuēchi, ni quecoo de nuū Jesús jeē cuni sōho de jnūhun cáhán yā. ");
INSERT INTO mibNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Te tāca tée grupo fariseo jiín tée cástéén tutu ley Yaā Dios, ni cacahān de sɨquɨ̄ yā: Tēe yáha jétáhú de tāca tée cásáha cuēchi te yéji de jíín, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Te ni cahān yā jnūhun yátá yáha jíín de: ");
INSERT INTO mibNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","¿Ndé ɨɨn ró núu névāha ró ɨɨn ciento lanchi, te núu scuíta ró ɨɨn tɨ, te á tu stóo ró cúūn xico xahūn cuūn gā tɨ̄ yucu, te quinanducú ró quɨtɨ ní sana ún ndé nanihīn rō tɨ̄? ");
INSERT INTO mibNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Te núu ni nanihīn rō tɨ̄, te coso sūcun ró tɨ̄, te cusɨɨ̄ ni rō. ");
INSERT INTO mibNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Te núu ni ndee rō vehe ró, te nastútú ró tācá amigo rō jiín ñáyuu yúcu yajni jíín ró, te cahān rō jiín i: Na cúsɨɨ̄ ni yō, chi ni nanihīn rī lanchi ri jeē ní sana. Achi rō. ");
INSERT INTO mibNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Te cáhán rī jiín ró jeē suni súcuan cúu nde andɨvɨ́. Chi cúsɨɨ̄ gā ni yā jiín ɨɨn ñayuu iyó cuéchi núu nacani ni i jeē stóo i cuēchi i, vēsú jiín cúūn xico xahūn cuūn ñayuu iyó ndáā jeē tuá jíni ñúhún nacani ni i. ");
INSERT INTO mibNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Te núu ɨɨn ñahan névāha ña uxī peso cāa, te núu scuíta ña ɨɨn, ¿á tu nastɨ́ɨn ña lámpara te nastáa ña vehe, te nanducú yúcún ña nde nanihīn ña? ");
INSERT INTO mibNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Te núu ni nanihīn ña, te nastútú ña tācá amiga ña jíín ñáyuu yúcu yajni jíín ña, te cahān ña jíín i: Na cúsɨɨ̄ ni yō, chi ni nanihīn rī xūhun jéē ni scuíta ri. Achí ña. ");
INSERT INTO mibNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Te cáhán rī jiín ró jeē suni súcuan cúsɨɨ̄ ni tācá ndajéhé Yaā Dios sɨquɨ̄ ɨɨn ñayuu iyó cuéchi núu nacani ni i jeē stóo i cuēchi i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Te ni cahān gā yā: Ɨɨn tēe ni īyo uū sēhe yɨɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Te tēe suchí gá ni cahān i jíín tátá i: Tátā, tahú sáva ní ndajníñu ní, te cuāha ní sava cuu tahū ná, áchí i. Te ni tahú sáva de tahū ndɨndúú i. ");
INSERT INTO mibNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Te ni cuu jecu‑ni quɨvɨ̄, te tēe suchí gá un ní stutú ndɨhɨ i ndajníñu i. Te ni quenda i cuahān i ɨɨn ñuu jicá. Te yūcuan ní snáā i tahū i, chi ni jexīn cāhá i. ");
INSERT INTO mibNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Te ná ni ndɨhɨ ni jexīn i, te ni quee ɨɨn jnamā xeén ini ñuu ún, te ni quejéé cúmanī jeē cáji i. ");
INSERT INTO mibNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yūcuán na te cuanducú jníñu i nuū ɨɨn tēe ñuu ún. Te ni tají de i cuahān i rancho de jeē cóto i quɨnɨ̄ de. ");
INSERT INTO mibNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Te cúní i caji i vēsú soō ndúchi jeē cáyeji quɨnɨ̄ ún, návāha ndutú chíji i. Te ni ɨɨn ñayuu tú na vé jéhe nuū i. ");
INSERT INTO mibNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yūcuán na te ni quejéé i nácani ni i: Tāca mozo casájniñu vehe tátá rī, íyó cuéhē staā cáyeji i. Te ruhū chi jíí rī sōco yāhá. ");
INSERT INTO mibNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Na quínuhun rī nuū tatá rī, te cahān rī jiín de: Tátā, ni sáha ná cuéchi nuū Yaā Dios jiín núū maá ní. ");
INSERT INTO mibNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Vijna te nasūu gá tēe vāha cúu ná jéē cónaní ná sēhe ní. Te cuāha ní jnúhun cuu ná nájnūhun ɨɨn mozo ni, achi rī. ");
INSERT INTO mibNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yūcuán na te ni naquihin i ichi cuanuhun i vehe tátá i. ’Te níní jícá gá vēji i, te ni jito tátá i nuū i, te ni cundáhú ni de i. Te jínu de cuajnahan de i, te ni nundee de sucūn i, te ni techūhú de i. ");
INSERT INTO mibNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yūcuán na te ni cahān i jíín de: Tátā, ni sáha ná cuéchi nuū Yaā Dios jiín núū maá ní. Vijna te nasūu gá tēe vāha cúu ná jéē cónaní ná sēhe ní. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Te máá tátá i chi sa ni cahān de jíín táca mozo de: Cuáquihin sahma váha ga te chuhun ró i. Te chuhun ró ɨɨn xehyu ndaha i, te chihi ró ndíjēn jehē i. ");
INSERT INTO mibNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Te quiquīhin ró becerro xéhen, te cahni rō tɨ̄ na cáji yō, chi sáha yó vico. ");
INSERT INTO mibNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Chi sēhe yɨɨ́ rí yáha, nájnūhun je ni jihī i, te ni natecu i. Chi tu ní jíní rī ndé chi ní jéhēn i, te ni ndee i, áchí de. Te ni caquejéé de cásáha de vico. ");
INSERT INTO mibNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Te sūchi jévāha, íne i nde rancho, te vēndiji i, te ni cuyajni i yatā véhe. Te ni jini i jeē cúu yaa te cájita jéhé ñáyuu. ");
INSERT INTO mibNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Te ni cana i ɨɨn mozo, te ni cajnūhún i na vé cúu jeē cúu. ");
INSERT INTO mibNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Te ni cachi mozo un núū i: Ni ndee ñani rō, te tátá rō ni jehni de becerro xéhen, chi ni ndee vāha i nuū de, áchí mozo. ");
INSERT INTO mibNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yūcuán na te ni quɨtɨ̄ ni sūchi jévāha, te tu ní cúní i ndɨ̄vɨ i. Te ni quenda tátá i, te ni cahān ndahú de jíín i jeē na ndɨ́vɨ i. ");
INSERT INTO mibNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Te ni cahān i jíín tátá i: Níní sáha ná jniñu ndácu ní, te tu cúnīhni cuɨtɨ ni na núū ní. Te tu jéhe ní vēsú ɨɨn lítú núū ná, jeē sáha ná vico caji na jíín táca amigo na. ");
INSERT INTO mibNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Te ni ndee sēhe ní yáha jeē ni jéxīn cāhá i xūhun ní jíín táca ñahan. Te ni jehni ní becerro xéhen caji i, áchí i jíín tátá i. ");
INSERT INTO mibNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yūcuán na te ni cahān de jíín i: Séhē, róhó chi níní ndéé ró jiín rí, te ndɨhɨ jeē névāha ri chi suni cuenta maá ró cúu. ");
INSERT INTO mibNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Te vijna chi íyó váha jeē sáha yó vico te cusɨɨ̄ ni yō. Chi ñani rō yāhá, nájnūhun ni jihī i, te ni natecu i. Chi tu ní jíní yō ndé chi ní jéhēn i, te ni ndee i, áchí de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Te suni ni cahān Jesús jiín tée cáscuáha jíín yá: Ɨɨn tēe cúcá ní īyo ɨɨn mozo de jeē ndíso jníñu nuū tāca gá mozo. Te ni cacahān jiín patrón un jéē mozo un snáā cāhá ndajníñu de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Te ni cana de mozo un, te ni cahān de jíín: ¿Na jnūhun cúu yāha jéē nihín rī sɨquɨ̄ rō? Nacuāha cuenta jniñu ndíso ró, chi ma cóndiso jníñu ga rō nuū mozo rī. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yūcuán na te jéni ni maá de: ¿Ndese sáha ri vijna? Chi patrón rī quenehen de jniñu ri. Te tú ndacuī rī jeē cáte ri ñuhun, te jeē cacán rī caridad chi cúcanu rī. ");
INSERT INTO mibNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Núu súcuan te jíní rī ɨɨn jeē sáha ri, návāha ñayuu cájeen nuū patrón rī, cuāha i vehe condee rī núu na quée quɨvɨ̄ jeē quénehen de jniñu ri. ");
INSERT INTO mibNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Te ni cana de ná ɨɨn ná ɨɨn tēe jeē cátaū nuū patrón de. Te ni cajnūhún de ɨɨn: ¿Nasaa táú rō nuū patrón rī? ");
INSERT INTO mibNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Te ni cahān tēe ún: Ɨɨn ciento barril aceite, achí de. Te ni cahān mozo un: Yāhá na cuáha ri lista rō, te cucōo yachī rō, te na sáha ró ɨnga lista jeē uú xico uxī na, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yūcuán na te ni cajnūhún de ɨnga tēe: Te róhó, ¿nasaa táú rō? Te tēe un ní cahān de: Ɨɨn ciento cajón trigo, achí de. Te ni cahān de jíín tée ún: Yāhá na cuáha ri lista rō, te na sáha ró ɨnga lista jeē cuún xico na, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yūcuán na te patrón ni cahān de: Nacā jeē ndichí ní sáha tēe cúnéé un, áchí de. Te cáhán rī jiín ró jeē ñáyuu ñayɨ̄vɨ yáha, ndíchí gá casáha i jeē quendōo vāha i nuū jnáhan i, vēsú ñayuu cácandíje nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Núu súcuan te cáhán rī jiín ró jeē ndichí gá na sáha ró vēsú jeē ni sáha mozo ndichí un. Chi ini ñayɨ̄vɨ yáha nuū yɨ́hɨ cuēchi, na sáha ró jniñu váha jíín xúhun ró, cuāha ró núū ñáyuu ndahú, návāha vēsú núu ni ndɨhɨ xūhun ró ñayɨ̄vɨ yáha, te quɨ̄vɨcoo ró andɨvɨ́ núū coo vehe ró nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Tēe jeē squícu vāha jíín ɨɨn jniñu lúlí‑ni, suni squícu vāha de jíín jniñu cáhnu. Te tēe jeē stahú jíín ɨɨn jniñu lúlí‑ni, suni stáhú de jíín jniñu cáhnu. ");
INSERT INTO mibNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Núu súcuan te núu tu squícu vāha ró jíín xúhun jeē iyó ñayɨ̄vɨ yáha nuū yɨ́hɨ cuēchi, te ma cuáha ya jeē váha cuu ró nɨ́ɨ́ cáni andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te núu tu squícu vāha ró jíín ndajníñu jeē ni jéhe núu ya nuū rō ñayɨ̄vɨ yáha, te ma cuáha ya tahū cuu ró nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ni ɨɨn mozo ma cúu cuajníñu de nuū uū patrón. Chi quɨtɨ̄ ni de nuū ɨɨn te coo manī de jíín ɨnga, chí squícu vāha de nuū ɨɨn te sájéē ni de nuū ɨnga. Te suni súcuan ma cúu cuajníñu ró núū Yaā Dios te núu máni sɨquɨ̄ xúhun ndɨ́hvɨ́ ni rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Te tēe fariseo ni casácatā de nuū yā jeē ní cajini de tāca jnúhun cáhán yā, chi tēe cútóó xúhun cácuu de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Te ni cahān yā jiín de: Máá ró cásáha ró jéē tée ndaā cácuu ró núū ñáyuu. Te Yaā Dios chi jíní yā ndese cáa ini anuá rō. Chi jniñu cájeni ni ñayuu jeē jníñu jéhnu cúu, te nuū Yaā Dios chi jniñu néé cúu. ");
INSERT INTO mibNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Nde ná tu quiji Juan tēe scuándute, te ni īyo ley jeē ni jéhe Yaā Dios nuū Moisés, te suni ni castéén tāca tée cánacani jnūhun ya. Yūcuán na te ná ni quiji Juan, te ni quejéé jítē núu jnūhun vāha ndese ndácu Yaā Dios jniñu. Te tāca ñáyuu nducú ndéyɨ́ i quɨ́vɨcoo i ndaha ya. ");
INSERT INTO mibNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Te yɨɨ́ gá cúu jeē náā ɨɨn letra nuū tútu ley yā vēsú jeē náā andɨvɨ́ jíín ñáyɨ̄vɨ́, chi squícu ndɨhɨ jnūhun cáhán. ");
INSERT INTO mibNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Núu ɨɨn tēe stóo de ñasɨhɨ́ de te quijnáhan de jíín ɨnga ñahan, núu súcuan te cásɨ́quɨ́ ndéē de ña. Te núu ɨɨn tēe condeca de ñahan ní ndusɨ́ɨn, suni cásɨ́quɨ́ ndéē de ña, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Te ni cahān gā yā: Ni īyo ɨɨn tēe cúcá, ní ñuhun de sahma lúu váha ndasɨ́. Te ndɨquɨvɨ̄ ni īyo vāha ndasɨ́ jéē ní yeji de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Te suni ni īyo ɨɨn tēe ndáhú, nání de Lázaro, néne de yéhyɨ́ tée cúcá un, te nɨ́ɨ́ cáhnu de íin ndɨ̄hyɨ. ");
INSERT INTO mibNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Te máni cúní de jeē ndutú chíji de jíín stáā cuēchi jeē stɨ́vɨ tēe cúcá un. Te quécoo ina te cánayuu tɨ nuū ndɨ́hyɨ de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Te ni jihī tēe ndáhú un, te tācá ndajéhé Yaā Dios cuangoo ya jiín ánuá de nde andɨvɨ́ nuū néne Abraham. Te suni ni jihī tēe cúcá un, te ni quindūji de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Te tēe cúcá un xeēn ndóho de íne de lugar nuū cáyūcu ndɨ́yɨ tu ní cándíje. Te ni ndacoto de, te nde jicá ní jito de nuū Abraham, te néne Lázaro jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yūcuán na te ni cana cóhó de: Tátā Abraham, cundáhú ni ni sáña, te tají ní Lázaro, na quíchundaji de xinī ndáha de nuū ndúte, te quiji de stáji de yáá ná. Chi xeēn ndóho ná núū yáñuhūn yāhá. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Te ni cahān Abraham jiín de: Séhē, nucūhun ni rō jeē ni níhīn rō ndɨhɨ jeē váha ná ni cotecu rō, te Lázaro chi sa suhva jnūndóho ni nihīn de. Te vijna je ni ndusɨɨ̄ ni de yāhá, te róhó chi ndóho ró jíñā. ");
INSERT INTO mibNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Te suni íyó ɨɨn jeē cunú téyɨ́, íne mēhñu yó jijnáhan yó. Te ñayuu cáhīin yāhá, vēsú cácuni i yāha i jeē i nuū rō, te ma cúu. Te ni ma cúu yāha máá ró quijicoo ró yáha. Achí Abraham. ");
INSERT INTO mibNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yūcuán na te ni cahān tēe cúcá: Núu súcuan te cáhán ndahú ná jiín ní, Tátā Abraham, tají ní Lázaro na quíhín de vehe tátá na. ");
INSERT INTO mibNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Chi íyó úhūn gā ñani ná, te na quícachi de nuū i jeē na nácani ni i te stóo i cuēchi i, návāha ma quɨ́vɨcoo i nuū ndóho ná yáha, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Te ni cahān Abraham jiín de: Je cánevāha i tutu jeē ní tee Moisés jiín táca tée ni canacani jnūhun Yaā Dios. Suu yūcuán na chúhun ni i, áchí Abraham. ");
INSERT INTO mibNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Te ni cahān tucu tēe cúcá: Vēsú súcuan, Tátā Abraham, te núu ɨɨn ñayuu ni jihī quihīn nuū i, yūcuán na te nacani ni i jeē stóo i cuēchi i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Te ni cahān Abraham jiín de: Núu tu chúhun ni i jnūhun ni nacani Moisés jiín táca tée ni canacani jnūhun Yaā Dios, suni ma candíje cuɨtɨ i núu natecu ɨɨn ndɨ̄yɨ quihīn nuū i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Te ni cahān Jesús jiín tée cáscuáha jíín yá: Máni íyó jéē nducú squɨ́vɨ ñayuu nuū cuéchi. Te nacā xeēn ndoho ñayuu jeē squɨ́vɨ jnáhan nuū cuéchi. ");
INSERT INTO mibNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vāha ga núu ni conuhnī ɨɨn yōso cáhnu sucūn i te quēe i chīji ndute mar, vēsú jeē squɨ́vɨ i ɨɨn sūchi lúlí yáha núū cuéchi. ");
INSERT INTO mibNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Coto ma sáha ró súcuan jíjnáhan ró. ’Te núu jnáhan ró sáha de cuēchi sɨquɨ̄ rō, te cahān rō nuū de. Te núu nacani ni de, te cone cáhnu ni rō nuū de. ");
INSERT INTO mibNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Te núu uxā jínu jeē ɨ́ɨn quɨvɨ̄ sáha de cuēchi sɨquɨ̄ rō, te núu uxā jínu nácani ni de te cahān de jíín ró jeē cone cáhnu ni rō chi ma sáha ga de, te cánuú cone cáhnu ni rō nuū de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Te tēe cácuu apóstol ni cacahān de jíín Jítoho yō: Sáha ní jéē nīhin ga candíje ná jéē sáha Yaā Dios jeē cájicān na núū yā, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Te ni cahān maá Jítoho yō jiín de: Núu cácandíje ró vēsú ɨɨn tíhlí‑ni, nájnūhun ɨɨn ndɨquɨn mostaza jeē tihlí‑ni cáa, te cuu cahān rō jeē núyūhndu yáha na quénda te nucondichi nde nuū mar, te coo nájnūhun cahān rō. ");
INSERT INTO mibNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Ndé ɨɨn ró íyó mozo rō jeē jítu de chí ndíto de quɨtɨ ndéca ró, te núu ni najinū de vehe ró, te tu cáhán rō jiín de jeē cúcōo de caji de staā. ");
INSERT INTO mibNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Chi sa suhva cáhán rō: Sáha ró ndeyu cuxíni ri, te cani ró cóhō rī. Te núu ni cuu ni yeji rī ni jihi ri, yūcuán na te caji maá ró coho ró, cácahān rō. ");
INSERT INTO mibNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Te cácahān rō jeē tu cánuú nacuatáhú ró nuū mozo núu ni sáha de jniñu ní ndacu ró, chi jeē cánuú sáha de cúu. ");
INSERT INTO mibNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Te suni súcuan máá ró jijnáhan ró, cácuu ró mozo Yaā Dios. Te núu ni casquícu ró táca jniñu ní ndacu ya nuū rō, te cahān rō: Tu cánuú nacuatáhú yá nuū rī, chi ni sáha ri máá‑ni jeē cánuú sáha ri, achi rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Te jíca Jesús ichi cuahān yā ñuu Jerusalén, te ni yāha ya cuahān yā mēhñú región Samaria jiín Galilea. ");
INSERT INTO mibNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Te ni jinū yā ɨɨn ñuu, te uxī tēe ndóho cuehyɨ̄ stehyú ni quendacoo de vejnahan de ya, te jícá ní cajecuɨñɨ̄ de. ");
INSERT INTO mibNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Te ni cacana jee de: Jesús, Maestro, cundáhú ni ni sáña, áchí de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Te ni jito Jesús nuū de, te ni cahān yā jiín de: Cuángoo te stéén rō maá ró nuū tāca sútū jeē ní canduvāha ró, áchí yá. Te níní cuángoo de te ni canduvāha‑ni de. ");
INSERT INTO mibNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yūcuán na te ɨɨn‑ni de ni nandió cóo de nuū Jesús, te cáhán jee de, nácuatáhú de nuū Yaā Dios jeē ní nduvāha de. ");
INSERT INTO mibNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Te ni jecuɨñɨ̄ yɨtɨ́ de nuū yā, te ni jequin de nuū de nde nuū ñúhun, te ni nacuatáhú de nuū yā. Te tēe Samaria cúu de. ");
INSERT INTO mibNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Te ni cahān Jesús: ¿A násūú ndɨhúxí de ni canduvāha? Te ɨɨ̄n gā de, ¿naun tu ní cánandicó de nacuatáhú de? ");
INSERT INTO mibNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿A máñúhún‑ni tēe ñuu jicá yáha cúu jeē ní nandicó de nácuatáhú de nuū Yaā Dios? ");
INSERT INTO mibNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Te ni cahān yā jiín tée ún: Ndocuɨñɨ̄ quinuhun rō. Chi ni candíje ró jéē cuu nasávāha ri rohó, te jeē yúcuan ní nduvāha ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Te tēe fariseo ni cacajnūhún de Jesús ndé quɨ́vɨ̄ quejéé jéē ndácu Yaā Dios jniñu ini ñayɨ̄vɨ́. Te ni cahān yā jiín de: Ma quéē ndijin jeē ndácu Yaā Dios jniñu. ");
INSERT INTO mibNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni ma cúu cahān ñayuu: Yāha íne ya ndácu ya jniñu, chí: Yūcuan íne ya, achi i. Chi je ndácu Yaā Dios jniñu mēhñu ró jijnáhan ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yūcuán na te ni cahān yā jiín tée cáscuáha jíín yá: Quee tiempo jeē yóhyo cúu ni rō coto ró jéē ndiji ruhū, Yaā ní nduu tēe, te ma cóto ró jíjnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Te cahān ñayuu jiín ró: Yāha íne ya, chí: Yūcuan íne ya, achi i. Te ma quíngoo ró condēhe ró, ni ma cóndiquīn rō i. ");
INSERT INTO mibNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Chi nájnūhun sáha taja jeē ndíndēé ɨɨn lado andɨvɨ́ te cúndijin nde ɨnga lado, suni súcuan cuu quɨvɨ̄ ndíji ruhū, Yaā ní nduu tēe, chi ndɨhɨ ñayuu coto. ");
INSERT INTO mibNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Te jíni ñúhún jéē xíhna gā ndoho xeēn rī, te ñayuu iyó vijna, squéhichī i ruhū. ");
INSERT INTO mibNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Chi nájnūhun ni cuu quɨvɨ̄ ni íyo Noé, suni súcuan cuu quɨvɨ̄ ndíji ruhū, Yaā ní nduu tēe. ");
INSERT INTO mibNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chi quɨvɨ̄ un ní cayeji i, ni cajihi i, ni canandāha i, ni cajēhe i sēhe sɨ́hɨ́ i jeē nándāha, nde ni jinū quɨvɨ̄ jeē ni quɨ́vɨ Noé ini barco cáhnu jeē naní arca. Te ni cuun saū xeén, te ni ndaa ndute ni cajihī ndɨhɨ i. ");
INSERT INTO mibNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Te suni súcuan ni cuu quɨvɨ̄ ni íyo Lot. Ni cayeji i, ni cajihi i, ni cajeen i, ni caxīcó i, ni cataji i itu, ni cajeni i vehe. ");
INSERT INTO mibNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Te quɨvɨ̄ jeē ní quenda Lot ini ñuu Sodoma cuahān de, te ni cuun ñuhūn jiín azufre ichi ándɨvɨ́, te ni snáā ndɨhɨ ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Te suni súcuan coo quɨvɨ̄ jeē ndíji ruhū, Yaā ní nduu tēe. ");
INSERT INTO mibNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Te quɨvɨ̄ ún te ñayuu cáhīin yatā véhe, te ndajníñu i ñúhun ini vehe, cáhán rī jiín i jeē ma ndɨ́vɨ i naquihin i, chi cánuú cunu yachī i jeē cácu i. Te suni súcuan ñayuu casájniñu nuū ítu, ma quínuhun i vehe i jeē quíhin i ndajníñu i. ");
INSERT INTO mibNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Te nucūhun ni rō ndese ni ndoho ñasɨhɨ́ Lot jeē ni jíhī ña. ");
INSERT INTO mibNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Te núu ndé ñáyuu cuní i cācu i nuū jnúndóho quiji nuū i jeē sɨquɨ́ ruhū, núu súcuan te jnahnū ndetū i nɨ́ɨ́ cáni. Te núu ndé ñáyuu, vēsú na cúū i jeē sɨquɨ́ ruhū, te cotecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Te cáhán rī jiín ró jeē quɨvɨ̄ ndíji ri te quíxí uū tēe ɨɨn jīto jecuáā, te ɨɨn de naquihin ri, te ɨnga de ndōo, chi tu ní cándíje de. ");
INSERT INTO mibNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Te coo uū ñahan jeē ndíco cáhnu, te ɨɨn ña naquihin ri, te ɨnga ña ndōo. ");
INSERT INTO mibNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Te uū tēe sájniñu de nuū ítu, te ɨɨn de naquihin ri, te ɨnga de ndōo. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Te jeē ní cajini de jnūhun yáha, te ni cacajnūhún de ya: ¿Ndé mí coo súcuan nájnūhun ni cahān ní? Achí de. Te ni cahān yā jiín de: Nájnūhun jeē cutútú téji ndé‑ni cúu nuū catú quɨtɨ ní jíhī, suni súcuan coo tāca jéē ni cáhān rī ndé‑ni cúu‑ni nuū cáhīyo ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Te ni cahān yā ɨɨn jnūhun yátá jíín de jeē cánuú jeē niní cácān tahú de, te ma ndínuu ni de jíín. ");
INSERT INTO mibNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Te ni cahān yā: Ni īyo ɨɨn juez ini ɨɨn ñuu. Te ni tu ndíso īyo de nuū Yaā Dios, ni tu yúhú de nuū ní ɨɨn ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Te suni ñuu un íyó ɨɨn ñahan ní ndóo ndáhú. Te ñahan un jéhén‑ni jéhén‑ni ña nuū de, jícán ña jeē na sándaā de sɨquɨ̄ ɨɨn ñayuu jeē jíto uhū i ña. ");
INSERT INTO mibNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Te cuehē quɨvɨ̄ tu ní cúní de sándaā de, te yūcuán na te ni jeni ni de: Vēsú tu ndíso īyo ri nuū Yaā Dios, ni tu yúhú rí nuū ní ɨɨn ñayuu, ");
INSERT INTO mibNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","te ñahan viuda yáha, yōhyo stáhān ña ruhū, te jeē yúcuan na sándaā rī sɨquɨ̄ ñáyuu jeē jíto uhū i ña. Chi núu tuú, te quejéé rí jnanīní ni rī jeē quíji quíji ña. Achí de. Achí máá Jítoho yō. ");
INSERT INTO mibNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Te ni cahān gā yā: Súcuan cúu jeē ni cáhān juez, tēe tú ndaā. ");
INSERT INTO mibNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Te Yaā Dios, nasūu súcuan cúu ya, chi sándaā yā sɨquɨ̄ jníñu ñayuu ní nacāji ya jeē nduú ñuú cácahān ndahú i jíín yá. Chi jnama ya i nuū tāca jéē cájito uhū i. ¿Te á cuéé jnama ya i? ");
INSERT INTO mibNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Cáhán rī jiín ró jeē yachī. Te quɨvɨ̄ ndíji ruhū, Yaā ní nduu tēe, ¿á níhīn gā rī ñayuu cácandíje nīhin ini ñayɨ̄vɨ́? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Te suni ni cahān yā jnūhun yátá yáha jíín jecu ñayuu jeē cájeni ni i jeē ñáyuu ndaā cácuu i, te cájeni ni i jeē sava ga ñayuu tu cáhīyo ndaā: ");
INSERT INTO mibNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ɨɨn tēe fariseo cuahān de templo jeē cacān tahú de. Te ɨɨn tēe stútú xúhun renta suni cuacacān tahú de templo. ");
INSERT INTO mibNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Te tēe fariseo, índichi de, te súcuan ni jicān tahú de: Tátā Yaā Dios, na cútahū na núū ní, chi tu cúu ná nájnūhun cándāa sava ga tēe, tēe cuíhná, tēe néé, tēe cásɨ́quɨ́ ndéē jnáhan cácuu de. Ni tu cúu ná nájnūhun cáa tēe yúcuan jéē stutú xúhun renta jeē scáa ga de jícán de nuū ñáyuu. ");
INSERT INTO mibNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Te uū jínu jeē semana iyó ndite ni na núū ní, te jéhe ná nuū ní ɨɨn ɨɨn sɨquɨ̄ tāca úxī ndajníñu níhín na, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Te tēe stútú xúhun renta, ni jecuɨñɨ̄ jicá de nuū templo, ni tu ní chúndeyɨ́ ni de jeē ndonehen de nuū de, chi sa suhva ni cani de yɨ̄quɨ jícā de jeē cucuíhyá ni de. Te ni cahān de: Tátā Yaā Dios, cundáhú ni ni sáña, chi tēe íyó cuéchi cúu ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Te cáhán rī jiín ró jeē tēe stútú xúhun renta, ni jetáhú Yaā Dios de, te cuanuhun de vehe de. Te tēe fariseo chi tu ní jétáhú yá de. Chi ñayuu jeē sajéhnu i máá i, sa ndululí i. Te ñayuu jeē sálulí i máá i, sa ndujéhnu i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Te ni quecoo ñayuu jiín súchi lúlí núū Jesús, jeē na sóó yá ndaha ya xinī i. Te tēe cáscuáha un ní cajini de jeē súcuan cúu, te ni cacahān de nuū ñáyuu vējicoo jíín i. ");
INSERT INTO mibNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Te máá Jesús ni cana ya de, te ni cahān yā: Cuāha jnūhun na quíjicoo sūchi lúlí jíñā nuū rī, te ma cásɨ rō jeē quíjicoo i. Chi ñayuu jeē ndió cóo ni i cani ni i nájnūhun sūchi yáha, suu i quɨ́vɨ ndaha Yaā Dios jeē ndacu ya jniñu nuū i. ");
INSERT INTO mibNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Te jendaá cahán rī jiín ró, núu ɨɨn ñayuu tú cuatáhú i jeē ndácu Yaā Dios jniñu nuū i, nájnūhun jétáhú ɨɨn sūchi lúlí, ma quɨ́vɨ cuɨtɨ i ndaha ya, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Te ɨɨn tēe cújéhnu ni cajnūhún de ya: Tēe vāha cúu ní Maestro. ¿Te na jniñu váha sáha ná te nihīn tahú na cotecu na nɨ́ɨ́ cáni andɨvɨ́? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Te ni cahān Jesús jiín de: ¿Naun cáhán rō jeē tée vāha cúu ri? Tú ni ɨɨn tēe vāha íyó, chi máá ɨɨn‑ni Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Je jíní rō tācá jniñu ní ndacu Yaā Dios: Ma cosɨ́quɨ́ ndéē jnáhan ró. Ma cáhni rō ndɨ̄yɨ. Ma sacuíhná ró. Ma sajnúhún ró. Cuatáhú ró nuū tatá rō nuū naná rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Te ni cahān maá de: Tācá jniñu yáha je ni squícu ná ndé ná lulí ná, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Te Jesús ni jini ya jnūhun yáha, te ni cahān yā jiín de: Ɨɨn na jniñu cúmanī sáha ró núu súcuan. Xīcó ndɨhɨ jeē névāha ró, te cuāha ró núū ñáyuu ndahú. Te nde andɨvɨ́ cuāha ya jeē váha ndasɨ́ núū rō. Yūcuán na te quiji ró condiquīn rō ruhū, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Te ná ni jini sōho de jnūhun yáha, te yōhyo ni cucuíhyá ni de, chi cúcá ndasɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Te jíto Jesús jeē súcuan cúcuíhyá ni de, te ni cahān yā: Tēe cúcá chi yōhyo yɨɨ́ quɨ́vɨcoo de ndaha Yaā Dios jeē ndacu ya jniñu nuū de. ");
INSERT INTO mibNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yachī gā yāha ɨɨn camello yaū yutɨ́cuɨ vēsú jeē quɨ́vɨ ɨɨn ñayuu cucá ndaha Yaā Dios jeē ndacu ya jniñu nuū i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Te tēe ní cajini jnūhun yáha, ní cacahān de: ¿Ndé ñáyuu cúu jeē cácu núu súcuan? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Te ni cahān yā jiín de: Ñayuu chi ma cúu squɨ́vɨ i máá i ndaha Yaā Dios, te máá yá chi cuu sáha ya, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yūcuán na te ni cahān Pedro: Sāña jíjnáhan ná ní castóo ná ndɨhɨ jeē cánevāha ná, te cándiquīn na níhín, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Te máá yá ni cahān yā jiín de: Jendaá cahán rī jiín ró jijnáhan ró, núu na‑ni ñayuu stóo i vehe, chí tátá, chí ñani, chí ñasɨhɨ́, chí séhe, jeē sɨquɨ́ jeē scáca i jnūhun jeē ndácu Yaā Dios jniñu nuū ñáyuu, ");
INSERT INTO mibNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","núu súcuan te nanihīn cuehē gā i ini ñayɨ̄vɨ yáha, te tiempo quiji te cotecu i nɨ́ɨ́ cáni, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Te ni cana sɨ́ɨn ya ndɨhúxí uū tēe cáscuáha jíín yá, te ni cahān yā jiín de: Vijna je cuángoo yó ñuu Jerusalén. Te yūcuan squícu ndɨhɨ jnūhun ndese ndoho ruhū, Yaā ní nduu tēe, nájnūhun ni catee tēe ni canacani jnūhun Yaā Dios nde jenahán. ");
INSERT INTO mibNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chi ñayuu nastúu i ruhū nuū tée nación Roma jeē cáyūcú Jerusalén cándacu jniñu. Te tēe un sácatā de nuū rī, te cahān neé de nuū rī, te tesɨ̄hɨ́ de nuū rī. ");
INSERT INTO mibNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Te cani de ruhū, te sáá te cahni de ruhū. Te nuū uní quɨvɨ̄ te natecu rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Te máá de tu ní cájecūhun cuɨtɨ ni de tāca jnúhun yáha. Chi jnūhun yɨɨ́ cúu, te tu ní cúu jecūhun ni de jeē cahán yā. ");
INSERT INTO mibNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Te ni cuyajni ya cuahān yā ñuu Jericó. Te ɨɨn tēe cuáá néne de yuhíchi, jícán de caridad. ");
INSERT INTO mibNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Te ni jini sōho de jeē yáha cuehē ñayuu cuangoo i, te ni cajnūhún de naun cuángoo i. ");
INSERT INTO mibNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Te ni cacahān i jíín de jeē Jesús, tēe ñuu Nazaret, yáha ya cuahān yā. ");
INSERT INTO mibNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yūcuán na te ni cana jee de: Jesús Sēhe yucūn David, cundáhú ni ni sáña, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Te ñayuu cuangoo ichi núú yā, ni cacahān i nuū de jeē na cásɨ de yuhu de. Te máá de víhyá gā ni cana jee de: Máá ní jeē cúu ní Séhe yucūn David, cundáhú ni ni sáña víī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yūcuán na te ni jecuɨñɨ̄ Jesús, te ni cahān yā jeē na quíndeca i de. Te nuū ní cuyajni de nuū yā, te ni cajnūhun yá de: ");
INSERT INTO mibNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Na vé cuní rō jeē sáha ri jiín ró? achí yá. Te ni cahān de: Jeē na ndúndijin tɨnūu ná cuní na, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Te ni cahān Jesús jiín de: Ndundijin tɨnūu ró núu súcuan. Ni candíje ró jeē cuu nasávāha ri rohó, te jeē yúcuan ní nduvāha ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Te ni ndundijin‑ni tɨnūú de, te ni ndiquīn de ya, te nácuatáhú de nuū Yaā Dios. Te ndɨhɨ ñayuu jeē ní cajito i, suni ni cacahān i jeē yóhyo vāha Yaā cúu Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Te ni quɨ̄vɨ Jesús ini ñuu Jericó, te ni yāha‑ni ya cuahān yā. ");
INSERT INTO mibNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Te yūcuan íyó ɨɨn tēe cúcá nání de Zaqueo, te cújéhnu de nuū tée cástútú xúhun renta. ");
INSERT INTO mibNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Te cúní de coto de návāha cuni de ndé ɨɨn cúu Jesús. Te tu ní cúu, chi cuehē ñayuu cuangoo i jíín yá, te ndɨquɨ‑ni cáa de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Te jínu de ni cosnūú de. Te ni caa de xinī ɨɨn nuyūhndú návāha coto de nuū yā, chi yūcuan yáha ya quihīn yā. ");
INSERT INTO mibNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Te ni jinū yā yūcuán, te ni ndacoto ndaa ya nuū de. Te ni cahān yā: Zaqueo, yachī nuu ró, chi jíni ñúhún jéē ndóo ri vehe ró vijna, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yūcuán na te ni cusɨɨ̄ ni de, te yachī ni nanuu de, te ni jeca de ya cuahān de jíín yá vehe de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Te ni cajito ñayuu jeē súcuan ni cuu, te ni cacahān i sɨquɨ̄ yā jeē cuahán yā ndōo ya vehe ɨɨn tēe sáha cuēchi. ");
INSERT INTO mibNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yūcuán na te ni ndocuɨñɨ̄ Zaqueo, te ni cahān de jíín máá Jítoho yō: Vijna te sava ndɨhɨ ndajníñu ná chi cuāha ná núū ñáyuu ndahú. Te núu ni scáa ga na ní jicān na xúhun nuū ñáyuu, te nacuāha ná únī gā sɨquɨ̄ naquihin i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Te ni cahān Jesús: Vijna te vehe yáha je ni cācu ɨɨn tēe jeē ma jnahnú ndetū de, chi ni candíje de nájnūhun ni candíje jíí de Abraham. ");
INSERT INTO mibNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Chi ruhū, Yaā ní nduu tēe, ni quiji ri nducú rí ñayuu jeē jnahnú ndetū, te jnama ri i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Te nuū ñáyuu ní cajini tāca jnúhun yáha, ní cahān gā Jesús ɨɨn jnūhun yátá jéē steén yā ndese coo quɨvɨ̄ ndíji ya. Chi je ni cuyajni ya ñuu Jerusalén, te cájeni ni i jeē víjna ñúhún quejéé jéē ndácu ya jniñu sáha Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Te ni cahān yā: Ɨɨn tēe cújéhnu cuahān jicá de ɨnga nación, návāha nihīn jníñu de cuu de rey, te ndiji de ndacu de jniñu. ");
INSERT INTO mibNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Te nde ná tu quihīn de, te ni cana de uxī mozo de, te nuū ɨɨn ɨɨn i ni jēhe de ɨɨn xūhun jéē ndeé yahu ndasɨ́. Te ni cahān de jíín i: Sájniñu ró jéē na ndúcuehē xūhun yáha jíjnáhan ró níní jéē quihín rī te ndee rī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Te ñayuu nación de cáquɨtɨ̄ ni i nuū de, te ni catají i jecu tēe cándiso jníñu cuangoo yatā de jeē cahān: Tu cánujnahan ni ñayuu nación na jéē cuáha ní jniñu nuū tée yáha jéē cuu de rey nuū i, áchí. ");
INSERT INTO mibNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Te vēsú súcuan te ni nihīn jníñu de cuu de rey, te vendiji de nación de. Te nuū ní ndee de, te ni ndacu de jniñu jeē na quíjicoo mozo jeē ni jéhe de xūhun núū, návāha na cúni de nasaa ni canihīn ɨɨn ɨɨn i sɨquɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Te ni quee ɨɨn mozo un núū de, te ni cahān i: Ɨɨn xūhun jéē ni jéhe ní núū ná, ni nduu uxī, achí i. ");
INSERT INTO mibNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Te ni cahān maá rey: Vāha mozo cúu ró, te vāha ni sáha ró. Chi ni squícu vāha ró jíín ɨɨn jniñu lúlí‑ni, te vijna te sáha ri jeē cujéhnu ró ndacu ró jniñu nuū uxí ñuu jnɨ́ɨ ri, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Te ni quee ɨnga mozo, te ni cahān i: Ɨɨn xūhun jéē ni jéhe ní núū ná, ni nduu uhūn, achí i. ");
INSERT INTO mibNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Te suni ni cahān de jíín mozo un: Róhó, cujéhnu ró ndacu ró jniñu nuū uhún ñuu jnɨ́ɨ ri, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Te ni quee ɨnga mozo, ni cahān i: Yāha nácuāha ná xúhun ní, chi ni chuvāha ná ini ɨɨn pañuelo. ");
INSERT INTO mibNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Chi ni yūhu ná nihín, chi tēe xeēn cúu ní. Chi cuehē gā nándacān ní vēsú jeē ni jéhe ní, te cuehē gā cuní ni vēsú jeē cúu sáha mozo ni, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yūcuán na te ni cahān rey: Mozo neé cúu ró núu súcuan, te jíín jnúhun ni cahān rō te sándaā rī jeē iyó cuéchi ró jéē tu ní sájniñu ró jíín xúhun rí. Chi jéni ni rō jeē tée xeēn cúu ri, te cuehē gā nándacān rī vēsú jeē ni jéhe ri, te cuehē gā cuní rī vēsú jeē cúu sáha mozo rī. ");
INSERT INTO mibNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Núu súcuan ¿te naun tu ní chúne ró xúhun rí vēsú nuū banco? Te jeē ní ndee rī te naquihin ri xūhun rí nde jiín séhe xūhun núú. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Te ni cahān de jíín ñáyuu cáhīin yūcuán: Quende xūhun jíñā nuū i, te cuāha ró núū mozo jeē névāha uxī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Te ñayuu un ní cacahān i jíín de: Te ndese, chi je névāha de uxī, achí i. ");
INSERT INTO mibNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Te ni cahān tucu rey: Cáhán rī jiín ró jeē ñáyuu je névāha, sa quiji ga nuū i, te conevāha cuehē i. Te ñayuu jeē tu névāha, sa cujiyo‑ni vēsú jecu jeē névāha i. ");
INSERT INTO mibNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Te tēe jeē cájito uhū ruhū, jeē tu ní cánujnahan ni de jeē cuu ri rey nuū de, cuáquihin de na quíjicoo de yāhá. Te cahni rō de coto ri, achí de. Achí Jesús. ");
INSERT INTO mibNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Te nuū ní ndɨhɨ ni cahān yā jnūhun yáha, te ni jica ga yā cuahān yā ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Te nuū ní cuyajni ya ñuu Betfagé jiín ñuu Betania, yajni nuū íne yucu nání yucu Olivos, te ni tají yá uū tēe cáscuáha jíín yá jeē quíngoo de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Te áchí yá jiín de: Cuáhán ñuu lulí íne ichi núú. Te núu ni quɨ̄vɨ ró, te nihīn rō ɨɨn burro núhní tɨ̄, jeē ní ɨɨn tēe ná tu coso de tɨ. Te ndají ró tɨ̄ quiji ró jíín tɨ́. ");
INSERT INTO mibNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te núu ndé ɨɨn cajnūhún naun cándají ró tɨ̄, te cahān rō jiín: Máá Jítoho yō jíni ñúhún yá tɨ̄, achi rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Te cuangoo tēe ni tají yá, te ni canihīn de tɨ nájnūhun ni cahān yā jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Te jeē cándají de tɨ, te ni cacahān jitoho tɨ̄ jiín de: ¿Naun cándají ró burro ri? achí. ");
INSERT INTO mibNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Te ni cacahān de: Máá Jítoho yō jíni ñúhún yá tɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Te ni ndecoo de jíín tɨ́ nuū Jesús. Te ni casoó de sahma de sɨquɨ̄ tɨ̄, te ni casáha de jeē ní jecosō yā sɨquɨ̄ tɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Te ná‑ni cuahān yā, sáá cáscáá ñayuu sahma i ini ichi. ");
INSERT INTO mibNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Te nuū ní cuyajni ya nuū cúun ichi yucu Olivos, te ndɨhɨ ñayuu cácandíje jeē cándiquīn i ya, ni caquejéé i cácusɨɨ̄ ni i, te cácana jee i jeē yóhyo vāha Yaā cúu Yaā Dios sɨquɨ̄ tācá jniñu jéhnu ni sáha ya ni cajito i. ");
INSERT INTO mibNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Te áchí i: Yōhyo vāha Yaā cúu Rey jeē véji jíín jniñu máá Jítoho yō Yaā Dios. Te sáha ya jeē cóo manī yō jiín Yaā Dios andɨvɨ́. Te yōhyo cújéhnu Yaā Dios, achí i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yūcuán na te jecu tēe fariseo cáhīin mēhñu ñáyuu cuehē ún, ní cacahān de jíín yá: Maestro, cahān ni núū ñáyuu cándiquīn nihín jéē na cásɨ i yuhu i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Te ni cahān Jesús: Cáhán rī jiín ró jeē núu ñayuu yáha na cásɨ i yuhu i, te tāca yúū chi cana jee, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Te nuū ní cuyajni ya Jerusalén, te ni jito ya ñuu ún, te ni ndahyū yā sɨquɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Te ni cahān yā: Róhó ñáyuu Jerusalén, yōhyo ni cuu ni rī jeē na jécūhun ni rō jeē cuu ndumanī rō jiín Yaā Dios sáha ri. Te sɨquɨ̄ jeē tu cácandíje ró, te vijna chi ma cúu ga jecūhun ni rō. ");
INSERT INTO mibNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chi quee quɨvɨ̄ jeē coo jnūndóho, te ñayuu cájito uhū rohó, cuicó ndúū i ñuu rō, te casɨ cutú i jíín yúū, te tāca lado ndonda i sɨquɨ̄ rō. ");
INSERT INTO mibNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Te ndɨhɨ vehe scótúú i, te cahni i róhó jíjnáhan ró. Te ma stóo i ni ɨɨn vehe jeē cóso jnáhan ga yuū. Chi ni quiji ri nde nuū Yaā Dios jeē jnáma ri rohó, te tu ní cácandíje ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Te ni quɨ̄vɨ ya ini templo cáhnu, te ni quejéé yá quénehen ya tāca ñáyuu cájeen quɨtɨ te cánaxīco núū ñáyuu jeē socō i. ");
INSERT INTO mibNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Te ni cahān yā jiín i: Yósó núū tútu iī jeē cahán Yaā Dios: Vehe ri chi vehe nuū cájicān tahú cúu, áchí Yaā Dios. Te máá ró jijnáhan ró, chi nájnūhun yaū cava ñacuīhna ní canasáha ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Te ndɨquɨvɨ̄ ni steén yā jnūhun ini templo. Te sutū cácujéhnu jíín tée cástéén tutu ley Yaā Dios jiín tée cácujéhnu nuū ñáyuu ñuu ún, cánducú de modo ndese cahni de ya. ");
INSERT INTO mibNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Te tu cánihīn de modo sáha de, chi ndɨvii ñayuu yōhyo cájetáhú i cájini nahín i jnūhun cáhán yā. ");
INSERT INTO mibNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Te ɨɨn quɨvɨ̄ steén yā jnūhun nuū ñáyuu ini templo, te nácani ya jnūhun jeē jnáma Yaā Dios ñayuu. Te ni quecoo sutū cácujéhnu jíín tée cástéén tutu ley Yaā Dios jiín táca tée jéhnu cándacu jniñu. ");
INSERT INTO mibNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Te ni cacahān de: Castūhún, ¿ndé ní nihīn jníñu ró jéē sáha ró jniñu yáha? ¿Te ndé ɨɨn ni tee jniñu sɨquɨ̄ rō jeē sáha ró súcuan? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Te ni cahān Jesús jiín de: Suni ruhū cajnūhun rí rohó ɨɨn jnūhun jíjnáhan ró. Castūhun núū rī: ");
INSERT INTO mibNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ndé ɨɨn ni tee jniñu sɨquɨ̄ Juan jeē ni scuándute de? ¿A Yaā Dios chí táca tée? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yūcuán na te ni candajnūhun máá de: ¿Ndese cahān yō? Núu cahān yō jeē Yaā Dios ni tee ya jniñu un sɨ́quɨ̄ Juan, te cahān de jíín yó: ¿Najehē tu ní cácandíje ró de núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Te núu cahān yō jeē ñáyuu ni catee jniñu un sɨ́quɨ̄ de, te ndɨvii ñayuu cahni i yóhó jíín yúū, chi cácandíje i jeē tée ni nacani jnūhun Yaā Dios ni cuu ndije Juan, achí de cácahān maá de. ");
INSERT INTO mibNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Te ni cacahān de jeē tu cájini de ndé ɨɨn ni tee jniñu sɨquɨ̄ Juan jeē ni scuándute de. ");
INSERT INTO mibNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yūcuán na te ni cahān Jesús: Ni ruhū, suni ma cáchi rī nuū rō ndé ɨɨn ni tee jniñu sɨquɨ̄ rī sáha ri jniñu yáha, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Te ni quejéé Jesús cahán yā jnūhun yátá yáha jíín ñáyuu ún: Ɨɨn tēe ni nachuhun de cuehē uva nuū ñúhun de. Te ni stóo de nuū sava tēe sájniñu nuū, te cuu sava de ndehē jiín. Te ni tee de ichi jeē cuahān nahán de ɨnga ñuu. ");
INSERT INTO mibNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Te máá tiempo ndutútú uva, te ni tají de ɨɨn mozo cuahān nuū tée cásájniñu ún, návāha naquihin de sava ndehē uva un. Te tēe un ní cacani de mozo, te ni canatají de i cuanuhun i súcuan‑ni. ");
INSERT INTO mibNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Te tēe chíí uva ni tají tucu de ɨnga mozo cuahān. Te tēe cásájniñu ún, suni ni cacahān ndevāha de nuū i, te ni cacani de i, te ni canatají de i cuanuhun i súcuan‑ni. ");
INSERT INTO mibNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Te tēe chíí uva ni tají tucu de ɨnga mozo cuahān. Te tēe cásájniñu ún, suni ni castújí de mozo un, te ni cascúnu de i. ");
INSERT INTO mibNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Yūcuán na te ni cahān tēe chíí uva: ¿Ndese sáha ri? Na tájí rí sēhe ri jeē maní rī jiín, chi sanaa te núu ni cajito de i te coo yɨ́ñúhún de nuū i. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Te tēe cásájniñu ún, ná ni cajito de jeē véji i, te ni cacahān de: Tēe chíí táhū cúu jeē véji ún. Na cáhni yō de, te ndōo tahū de cuu máá yó, achí. ");
INSERT INTO mibNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Te ni caquenehen de i ɨnga lado, te ni cajehni de i, áchí yá. Te ni cajnūhun yá de: Núu súcuan ¿te ndese sáha tēe chíí uva jiín tée cásájniñu ún? ");
INSERT INTO mibNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ndiji de te cahni de tēe un jíjnáhan, te cuāha de ñuhun cáá uva un núū ɨnga sava tēe sájniñu nuū, achí yá. Te jeē ní cajini ñayuu jnūhun yáha, te ni cacahān i: Aī, núu ma cóo cuɨtɨ súcuan víī, achí i. ");
INSERT INTO mibNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Te ndéhé yá nuū i jíjnáhan i, te ni cahān yā: Núu súcuan ¿te á cájecūhun ni rō jnūhun yáha jéē yosó núū tútu iī jeē cúu ri nájnūhun ɨɨn yuū? Chi áchí tutu: Yuū jeē ní casquéhichī tēe cájeni vehe, yuū yáha nduu jeē quítuu vehe. Achí. ");
INSERT INTO mibNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Te ñayuu tu cácandíje, ndoho i nájnūhun ndóho ñayuu jeē cotúú sɨquɨ̄ yuú te jnáhnú i. Te quɨvɨ̄ sándaā Yaā Dios cuēchi, te ñayuu tu cácandíje, ndoho i nájnūhun ndóho ñayuu jeē nɨ́nga yuū sɨquɨ̄ i te cundihī i sáha. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yūcuán na te sutū cácujéhnu jíín tée cástéén tutu ley Yaā Dios, ni cacuni de jnɨɨ de ya maá hora un. Chi ni cajecūhun ni de jeē sɨquɨ̄ maá de cúu jnūhun yátá ní cahān yā sɨquɨ̄ tée cásájniñu nuū uva jiín tée cájeni vehe. Te tu ní cúu, chi cáyūhú de jeē quɨtɨ̄ ni ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yūcuán na te ni catají de jecu tēe cuacoto yuhu de ya, te tēe un cásáha‑ni de jeē tée ndaā cácuu de. Te cánducú de sáha de jeē cahán yā ɨɨn jnūhun jeē nihín de cuēchi sɨquɨ̄ yā, te quindeca de ya nuū tēe cúu gobernador. ");
INSERT INTO mibNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Te ni cacahān de: Maestro, cájini na jéē cahán vāha ní, te stéén ndaā ní. Te tu sáha ní cuenta ndese cúu ɨɨn ɨɨn ñayuu, chi ɨnuú‑ni sáha ní jíín i. Te stéén ndaā ní ndese squícu ñayuu nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Núu súcuan te cachi ní: ¿A íyó váha jeē chúnaa yō renta nuū rey nación Roma jeē jnɨ́ɨ nación yō, chí tuú? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Te ni jini yā jeē cácuni de stáhú de ya, te ni cahān yā jiín de: ¿Najehē cájito ndee rō ruhū? ");
INSERT INTO mibNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Stéén ɨɨn xūhún na cóto ri. ¿Ndé ɨɨn nuū cúu jeē ndeé nuū xúhun yáha, te ndé sɨ́hvɨ́ cúu jeē ndeé yāhá? áchí yá. Te ni cacahān de jíín yá: Nuū jiín sɨ́hvɨ́ rey un cúu, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yūcuán na te ni cahān yā jiín de: Núu súcuan te nacuāha ró núū rey un jéē yɨ́hɨ cuenta nuū de, te nacuāha ró núū Yaā Dios tāca jéē yɨ́hɨ cuenta nuū maá yá, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Te tāca tée ún tu ní cúu nihīn de cuēchi sɨquɨ̄ yā jiín ni ɨɨn jnūhun cáhán yā, cájito jínúū ñayuu. Chi sa ni canaa ni de jeē ndichí ní stió cuɨ́ñɨ́ yā jnūhun nuū de, te tuá na vé ni cácahān de. ");
INSERT INTO mibNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yūcuán na te jecu tēe grupo saduceo ni quecoo de nuū yā. Te tēe un cácahān jeē tu nátecu cuɨtɨ ndɨ̄yɨ. Te ni cacahān de jíín yá: ");
INSERT INTO mibNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Maestro, Moisés ni tee de nuū tútu jeē cánevāha yó: Núu ɨɨn tēe cuu de, te ndōo ñasɨhɨ́ de, te núu tu ní íyo sēhe de jíín ña, núu súcuan te cánuú jeē ñani de naquihin ñasɨhɨ́ de, te sēhe de jeē cácu jíín ña nucuɨñɨ̄ i nuū ndɨ́yɨ ñani de, áchí tutu. ");
INSERT INTO mibNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Núu súcuan te ni īyo uxā ñani. Te tēe núú ní quijnáhan de jíín ñahan. Te ni jihī de, te tú sēhe de ní íyo. ");
INSERT INTO mibNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Te tēe uū ni naquihin de ña, te suni ni jihī de, te tú na sēhe de ní íyo. ");
INSERT INTO mibNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Te tēe unī ni naquihin de ña. Te suni súcuan ndɨhúxá de ni condeca de ña, te ni cajihī ndɨhɨ de, te ni ɨɨn de tú sēhe de ní íyo. ");
INSERT INTO mibNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Te jeē sándɨ̄hɨ́ te suni ni jihī ñahan ún. ");
INSERT INTO mibNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Núu súcuan te núu na nátecu de jíjnáhan de quɨvɨ̄ nátecu ndɨ̄yɨ, ¿te ndé ɨɨn de cuu ña ñasɨhɨ́ de? Chi ndɨhúxá de ni condeca de ña. Achí de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yūcuán na te ni cahān yā jiín de: Ñayɨ̄vɨ yáha chi cáquijnáhan tēe jíín ñahan. ");
INSERT INTO mibNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Te ñayuu vāha jeē natecu i quɨ̄vɨcoo i andɨvɨ́, ma quijnáhan ga i yūcuán, chi tuá na jnūhun quijnáhan tēe jíín ñahan coo. ");
INSERT INTO mibNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ni ma cúū cuɨtɨ gā i, chi coo i nájnūhun ndajéhé Yaā Dios. Te sēhe Yaā Dios cuu i, chi je ni canatecu i. ");
INSERT INTO mibNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Te suni máá Moisés cáhán de jeē nátecu ndɨ̄yɨ, chi ni tee de nuū tútu ndese ni cahān yā jiín de mēhñu yúcū jeē cayú yáñuhūn. Chi ni cahān de jeē cúu ya Yaā Dios Abraham jiín Isaac jiín Jacob. ");
INSERT INTO mibNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Te jeē ni cáhān de súcuan cúu jeē ní cachi de jeē cátecu tāca ndɨ́yɨ. Chi vēsú je ni cajihī i, te cátecu i nuū iyó máá yá, chi cúu ya Yaā sáha jeē técu ñayuu nɨɨ́ cáni. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Te jecu tēe cástéén tutu ley Yaā Dios ni cacahān de: Vāha ni cahān ní Maestro. ");
INSERT INTO mibNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Te tuá ni cáchundeyɨ́ ni de cajnūhún de ya. ");
INSERT INTO mibNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Te ni cahān yā jiín de jíjnáhan de: ¿Ndese cúu jeē cácahān ñayuu jeē Cristo cúu sēhe yucūn David? ");
INSERT INTO mibNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Chi máá David suhva ni cahān de jnūhun ya nuū tútu Salmo: Máá Jítoho yō Yaā Dios suhva ni cahān yā jiín Jítoho rī, Yaā quiji: Cucōo ró lado váha ri nuū cujéhnu ró, ");
INSERT INTO mibNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","te na sáha ri jeē quende rō poder tāca jéē cájito uhū rohó. Achí Yaā Dios. Achí David. ");
INSERT INTO mibNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Te núu sēhe yucūn David cúu Cristo, ¿te ndese cúu jeē ni cáhān de jeē Jítoho de cúu ya? áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Te ni cahān yā jiín tée cáscuáha jíín yá, te suni ni cajini sōho ndɨhɨ ñayuu: ");
INSERT INTO mibNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Coto má cándíje ró táca tée cástéén tutu ley. Chi cácusɨɨ̄ ni de cáñuhun de sahma cáni jeē steén jeē cujéhnu de, cájica cuu de jíín. Te cánujnahan ni de jeē cahán yɨñúhún ñáyuu jiín de nuū yáhu. Te cánujnahan ni de cucōo de nuū silla yɨñúhún gá ini vehe iī sinagoga, jiín silla yɨñúhún gá nuū víco cáyeji ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Te cáquende de vehe ñahan ní caquendōo ndáhú. Te nahán cájicān tahú de návāha cani ni ñayuu jeē tú na cuēchi de. Tēe yáha jíjnáhan de chi xeēn gā ndoho de castigo. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Te ná ni īyo ya ini templo, te jíto ya nuū ñáyuu cucá jéē cáchuhun i cuehē xūhún ini tāca yéjnū nuū cásocō i. ");
INSERT INTO mibNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Te suni ni jito ya nuū ɨɨn ñahan viuda jeē ndóho ndáhú, te ni chuhun ña uū centavo lulí ini yejnū ún. ");
INSERT INTO mibNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Te ni cahān yā: Jendaá cahán rī jiín ró jeē cuehē gā cúu jeē ni sócō ñahan viuda ndahú yáha, vēsú jeē ní casocō tāca gá ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chi tācá i ni casocō i jeē ni ndóo sɨquɨ̄ xúhun cuéhē i. Te ñahan yáha, vēsú ndahú ndóho ña, te ni chuhun ndɨhɨ ña jeē cótecu ña. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Te sava de ni cacahān de jeē luu cáa templo cáhnu, chi ni cuvāha jíín táca yúū luu jíín táca jéē ní casocō ñayuu. Yūcuán na te ni cahān yā: ");
INSERT INTO mibNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ndɨhɨ jeē cájito ró yáha, quee quɨvɨ̄ jeē ma cóso jnáhan ga ni ɨɨn yuū, chi ndɨhɨ jnanū, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Te ni cacajnūhún de ya: Maestro, ¿ndé quɨ́vɨ̄ coo tāca jéē ní cachi ní jéē coo? ¿Te na seña coo nuū cuácuyajni squícu tāca jéē ni cáhān ní? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Te ni cahān yā: Coto ró jéē ma stahú i róhó. Chi quijicoo cuehē tēe jeē stahú jíín sɨ́hvɨ́ rí, te cahān de: Máá rí cúu Cristo. Te suni cahān de: Je ni quee quɨvɨ̄ ndɨhɨ ñayɨ̄vɨ́, achi de. Te ma cóndiquīn rō de. ");
INSERT INTO mibNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Te núu nihīn rō jnūhun jeē tāca lado iyó guerra te cándonda ñayuu sɨquɨ̄ tohō, te ma yūhu ró, chi cánuú jéē xíhna gā coo súcuan, te ni ma jinú yachī quɨvɨ̄ ndɨhɨ ñayɨ̄vɨ́. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Te ni cahān gā yā: Ndonda nación sɨquɨ̄ ɨnga nación, te ndonda ñuu sɨquɨ̄ ɨnga ñuu jeē cuajnáhan. ");
INSERT INTO mibNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Te cháha chúcuan jnāa téyɨ́, te coo jnamā jiín cuéhyɨ̄ xeēn. Te coo seña jéhnu ichi ándɨvɨ́ jéē yūhú ndasɨ́ ñáyuu coto i. ");
INSERT INTO mibNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Te nde ná tu coo tācá jniñu yáha, te coto xeēn i róhó, te jnɨɨ i róhó. Te quindeca i sava ró táca vehe iī sinagoga jeē cahán i cuēchi sɨquɨ̄ rō. Te chune i sava ró vecāa. Te quindeca i sava ró núū tāca rey jiín núū tācá gobernador, te cahān i cuēchi sɨquɨ̄ rō jeē sɨquɨ́ jeē cácandíje ró rúhū. ");
INSERT INTO mibNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Te jeē súcuan coo, te cuitē núu ga jnūhun ri, chi nacani ndaā rō nuū de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Núu súcuan te cundaā ni rō jeē ma nácani ni rō xīhna gā ndese stíó cuɨ́ñɨ́ rō nuū de te cācu ró. ");
INSERT INTO mibNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chi ruhū cuāha ri jnūhun ndíchí cahān rō, návāha ñayuu jeē cájito uhū rohó, ma cúndeyɨ́ i jíín ró ni ma cúu cahān i sɨquɨ̄ rō. ");
INSERT INTO mibNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Te nde tatá rō, naná rō, ñani rō, jnáhan ró, jíín amigo rō, nastúu i róhó núū ñáyuu xeēn. Te cahni i sava ró. ");
INSERT INTO mibNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Te tāca ñáyuu chi quɨtɨ̄ ni i nuū rō jeē sɨquɨ́ ruhū. ");
INSERT INTO mibNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Te ni ɨɨn ixi xíní rō jijnáhan ró ma náā, chi coto ya rohó. ");
INSERT INTO mibNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Te núu cuɨñɨ nīhin ró jíín jnúhun ri, te cotecu rō nɨɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Te núu ni cajito ró jéē ní cajicó ndúū soldado ñuu Jerusalén, te na jécūhun ni rō jeē jé yajni naa ñuu ún. ");
INSERT INTO mibNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yūcuán na te ñayuu cáyūcú región Judea, na cúnu i caa i yucu quingoo i. Te ñayuu cáyūcú Jerusalén, na quéndacoo i quingoo i. Te ñayuu cáhīin nde rancho, ma nándicó i ñuu ún. ");
INSERT INTO mibNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chi tāca quɨ́vɨ̄ un cuáha Yaā Dios castigo nuū ñáyuu jeē sɨquɨ́ cuéchi i, návāha squícu tāca jnúhun jeē yosó núū tútu. ");
INSERT INTO mibNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Te quɨvɨ̄ ún nacā jeē ndahú ñahan cáñuhun sēhe jíín ñahan cándeca yɨquɨ́n, chi ma cúnihīn ña cunu yachī ña. Chi yōhyo xeēn coo jnūndóho ini ñayɨ̄vɨ́, te quiji castigo xeēn sɨquɨ̄ ñáyuu yáha. ");
INSERT INTO mibNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Te sava i cuu nuū guerra, te sava i quingoo preso nde tācá ɨnga nación. Te ñayuu tāca gá nación ndacu nīhin i jniñu nuū ñáyuu ñuu Jerusalén, nde jīnu tiempo jeē jéhe Yaā Dios jnūhun ndacu i jniñu. ");
INSERT INTO mibNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Yūcuán na te coo seña nuū níāndii jíín núū yoó jiín núū quɨ́mɨ. Te ini ñayɨ̄vɨ́ te quiji jnūndóho xeēn sɨquɨ̄ ñáyuu tācá nación. Te cunéé ni i, te yūhú i jeē nɨ́hɨn xeēn mar te ndónda xeēn ndute mar vēji nuū ñúhun. ");
INSERT INTO mibNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Te cuu sōó sava ñayuu jeē cáyūhú i cándetu i tāca jnúndóho quiji sɨquɨ̄ ñayɨ̄vɨ́. Te tāca jéē íin andɨvɨ́ chi quɨsɨ i. ");
INSERT INTO mibNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yūcuán na te coto ñayuu nuū maá rí, Yaā ní nduu tēe, ndiji ri jiín vícō, te condiso ri cuehē poder, te yōhyo luu cujéhnu ri. ");
INSERT INTO mibNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Te núu ni quejéé táca jniñu yáha, te ndeyɨ́ coo ni rō, te cocunuū rō andɨvɨ́, chi je yajni jnama ya rohó. Achí yá jiín de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Te suni ni cahān yā jnūhun yátá yáha: Condēhe jíjnáhan ró ndese sáha nundēhe higo jiín táca gá yujnu. ");
INSERT INTO mibNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Núu cájito ró jéē ní quejéé náne numa yújnu ún, te cájini rō jeē jé yajni coo tiempo jihní. ");
INSERT INTO mibNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Te suni súcuan núu ni cajito ró jéē ní quejéé cúu tācá jniñu jeē ni cáhān rī, yūcuán na te na jécūhun ni rō jeē ní cuyajni quɨvɨ̄ ndacu Yaā Dios jniñu ini ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Jendaá cahán rī jiín ró jeē ma cúū ndɨhɨ ñayuu tiempo un, chi nde squícu ndɨhɨ jniñu ún. ");
INSERT INTO mibNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Andɨvɨ́ jíín ñáyɨ̄vɨ́ chi naa, te tāca jnúhun cáhán rī chi ma náā, chi ndɨhɨ squícu. ");
INSERT INTO mibNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Te coto ma stɨ́vɨ ró maá ró jijnáhan ró jéē sáha ró táca cuéchi, jíín jéē najīni ró, jíín jéē cujnéñu ró jíín táca ndajníñu cotecu rō, návāha tú sanaa ni rō te quee quɨvɨ̄ un sɨ́quɨ̄ rō. ");
INSERT INTO mibNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chi nájnūhun jeē núu ɨɨn trampa, súcuan quee jnūndóho sɨquɨ̄ ñáyuu cáyūcu nɨ́ɨ́ cáhnu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Núu súcuan te ndito coo ni rō, te níní cácān tahú rō, návāha cuu cācu ró núū tāca jnúndóho jeē quíji ún, te cuu cuɨñɨ ró núū ruhū, Yaā ní nduu tēe. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Te ndɨquɨvɨ̄ steén yā jnūhun ini templo, te ndɨjnahan jecuáā jéndōo ya nde yucu jeē naní Olivos. ");
INSERT INTO mibNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Te tāca jénéhen quécoo ñayuu nuū yā ini templo jeē cúni sōho i jnūhun stéén yā. ");
INSERT INTO mibNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yūcuán na te ni cuyajni vico pascua jeē cáyeji ñayuu hebreo pan jeē tú na levadura yɨ́hɨ. ");
INSERT INTO mibNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Te sutū cácujéhnu jíín tée cástéén tutu ley, ni canducú yuhu de modo cahni de Jesús, chi cáyūhú de jeē quɨtɨ̄ ni ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Te ni quɨ̄vɨ Satanás ini anuá Judas jeē nastúu de ya. Te suni nání de Iscariote, te cúu de ɨɨn jnáhan jeē ndɨhúxí uū tēe apóstol. ");
INSERT INTO mibNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Te ni jehēn de ni candajnūhún de jíín táca sútū cácujéhnu jíín tée cándiso jníñu ini templo, núu ndese nastúu de ya nuū tée un jíjnáhan. ");
INSERT INTO mibNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Te tēe un ní cacusɨɨ̄ ni de, te ni cajejnūhun de jeē cuáha de xūhun núū Judas. ");
INSERT INTO mibNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Te ni jetáhú Judas, te ni nducú de modo ndese nastúu yuhu de ya hora jeē tú na ñayuu iyó. ");
INSERT INTO mibNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Te ni quee maá quɨ́vɨ̄ víco jeē cáyeji ñayuu pan jeē tú na levadura yɨ́hɨ, te suni quɨvɨ̄ un cájehni i londe nájnūhun ni ndacu Yaā Dios jniñu jeē sáha i vico pascua un. ");
INSERT INTO mibNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Te Jesús ni tají yá Pedro jiín Juan quingoo de, te áchí yá jiín de: Cuángoo te sátūhva ró jéē cuxíni yó vico pascua, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Te ni cacajnūhún de ya: ¿Ndé nuū cuní ni jéē quísátūhva ná? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Te ni cahān yā jiín de: Cuángoo ñuu yūcuán, te núu ni quɨ̄vɨcoo ró te najnáhan ró jíín ɨɨn tēe ndíso quɨ̄yɨ ndute. Te condiquīn rō de quihīn rō jiín de nde vehe nuū ndɨ́vɨ de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Te cahān rō jiín tée chíí vehe ún: Achí máá Maestro: ¿Ndé ɨɨn cúu cuarto vehe ní cuāha núú ní núū cuxíni ya vico pascua jiín tée cáscuáha jíín yá, achi rō. ");
INSERT INTO mibNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yūcuán na te stéén de ɨɨn cuarto cáhnu nde xinī véhe jeē je íyó túhva, te yūcuan sátūhva ró jéē cuxíni yó, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Te cuangoo de, te ni canihīn de nájnūhun ni cahān yā. Te ni casátūhva de jeē cuxíni ya vico pascua. ");
INSERT INTO mibNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yūcuán na te ni jinū hora jeē cuxíni, te ni quee Jesús, te ni cucōo ya mesa jiín tée cácuu apóstol. ");
INSERT INTO mibNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Te ni cahān yā jiín de: Yōhyo ni cuu ni rī cuxíni ri jiín ró jijnáhan ró vico pascua yáha, vijna nde ná tu cuu rī. ");
INSERT INTO mibNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chi cáhán rī jiín ró jeē ma cáji cuɨtɨ gā rī vico pascua, chi nde quiji quɨvɨ̄ ndacu Yaā Dios jniñu nɨ́ɨ́ ñayɨ̄vɨ́, te sáá te caji tucu ri, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Te ni quihin ya ɨɨn copa ndūxi uva, te ni nacuatáhú yá, te ni cahān yā: Quihin copa yáha, te coho ró jíín jnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chi cáhán rī jiín ró jeē ndé vijna te ma cóho ga rī ndūxi uva, chi nde quiji quɨvɨ̄ ndacu Yaā Dios jniñu nɨ́ɨ́ ñayɨ̄vɨ́, te sáá te coho tucu ri. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Te ni quihin ya pan, te ni nacuatáhú yá, te ni tahú cuéchí yá, te ni jēhe ya nuū de jíjnáhan de. Te ni cahān yā: Yāha cúu yɨquɨ cúñu rī jeē socō rī jeē chunaa rī cuēchi ró jíjnáhan ró. Te níní caji rō súcuan jeē cáñuhun ni rō ruhū jeē ni jíhī rī jehē rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Te suni súcuan ni sáha ya jiín copa ndūxi uva, ná ni cuu ni cuxíni ya. Te ni cahān yā jiín de: Yāha cúu nɨñɨ̄ rī jeē cuáha ri jeē cúu contrato jeé, te catɨ jeē ndundoo cuēchi ró jíjnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Te vijna chi tēe nastúu ruhū, néne de jíín rí nuū mesa yáha. ");
INSERT INTO mibNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chi ruhū, Yaā ní nduu tēe, jendaá cúu jeē quihín rī cuu rī nájnūhun je ni sándaā Yaā Dios jeē súcuan coo. Te nacā xeēn ndoho tēe jeē nastúu ruhū, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yūcuán na te ni caquejéé de cácajnūhun jnáhan de ndé ɨɨn de cúu jeē nastúu de ya. ");
INSERT INTO mibNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yūcuán na te yōhyo ni cacahān de sɨquɨ̄ ndé ɨɨn de cújéhnu ga nuū jnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Te ni cahān Jesús jiín de: Rey tācá nación chi cándacu nīhin de jniñu nuū ñáyuu cájnɨɨ de, te cácahān i jeē tée cásáha vāha cúu jeē cácujéhnu nuū i. ");
INSERT INTO mibNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Te róhó jíjnáhan ró, ma cóo ró súcuan. Chi núu ndé ɨɨn ró cújéhnu ga, te sa nasáha lulí ró maá ró. Te núu ndé ɨɨn ró ndácu jniñu, te sa nasáha ró máá ró tēe jéjníñu nuū jnáhan. ");
INSERT INTO mibNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Te ndé ɨɨn cúu jeē cujéhnu ga, á tée yéji nuū mesa, chí tée jéni cohō? ¿A násūu tée jeē yéji nuū mesa cúu jeē cujéhnu ga? Te ruhū nasūu súcuan cúu ri, chi ni nasáha ri maá rí nájnūhun tēe jéjníñu nuū rō, chi vēji ri sáha ri jeē nihín tahú rō. ");
INSERT INTO mibNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Te máá ró cácuu tēe jeē niní cáhīin jíín rí tāca quɨ́vɨ̄ jeē ndóho ri jnūndóho. ");
INSERT INTO mibNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Núu súcuan te nájnūhun ni sáha Tátá rī jeē ndácu ri jniñu, suni súcuan sáha ri jeē ndacu ró jniñu jíjnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Te caji rō coho ró jíín rí ini ñuu nuū ndacu ri jniñu. Te cucōo ró ɨɨn ɨɨn mesa jeē sándaā rō jniñu ndɨhúxí uū yucūn Israel. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Te suni ni cahān maá Jítoho yō jiín Simón Pedro: Simón, cuni sōho ró, chi ni jicān Satanás rohó jíjnáhan ró jéē coto ndee rohó nájnūhun jeē síjin trigo, te stúu ndé ɨɨn ró cácuu nájnūhun paja jeē nayūhu ró, te ndé ɨɨn ró cácuu nájnūhun trigo jeē candíje nīhin ró. ");
INSERT INTO mibNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Te ni jicān tahú rī jehē rō návāha ma náyūhu ró jeē ma cándíje ga rō. Te jeē nácandíje tucu ró, te sáha ró jéē íje tāca jnáhan ró jíín jnúhun ri. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Te ni cahān de jíín yá: Je íyó túhva ná quíhīn na jíín ní vecāa te vēsú na cuu na jíín ní, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Te ni cahān yā: Pedro, cáhán rī jiín ró jeē nde ná tu cana líhli vijna, te yūhu ró jeē jnɨɨ ñayuu rohó, te unī jínu cahān rō jeē tu jíní rō ruhū, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yūcuán na te ni cajnūhun yá de jíjnáhan de: Ná ni tají rí rohó ní jengoo ró jéē tu ní cóndiso ró ñunu ni yɨjnɨ xūhún ni ndijēn, ¿te á ní īyo ɨɨn jeē ní cumanī nuū rō? Achí yá. Te ni cacahān de: Tú ni ɨɨn ní cúmanī. ");
INSERT INTO mibNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Te ni cahān yā: Nde vijna sa cáhán rī jeē cóndiso ró ñunu ró, te suni yɨjnɨ xūhún. Te tēe jeē tu névāha espada jeē coto de máá de, na xíco de tɨcāchí de te na cuáan de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Chi cáhán rī jiín ró jeē quee quɨvɨ̄ ndoho yó jnúndóho, chi cánuú squícu jnūhun yáha jéē cahán nuū tútu sɨquɨ̄ rī: Sáha ñayuu jiín yá nájnūhun cásáha i jíín tée sáha cuēchi xeēn, áchí tutu. Chi tāca jnúhun un jéē yosó cáhán sɨquɨ̄ rī, chi squícu nahín, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yūcuán na te ni cacahān de: Yāha íyó úū espada, achí de. Te ni cahān yā jiín de: Jíín jéē yáha‑ni, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Te ni quenda ya cuahān yā yucu Olivos nájnūhun sáha sáha ya. Te tēe cáscuáha jíín yá ni candiquīn de ya cuangoo de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Te nuū ni jínū yā yūcuán, te ni cahān yā jiín de: Cacān tahú rō jijnáhan ró jéē chindéé ñáhán yá rohó jéē ma sáha ró cuéchi núu coto ndee jeneé róhó, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Te ni jica ya jecu, cūhva jeē jicá jínú yuū jeē squiín. Te ni jecuɨñɨ̄ yɨtɨ́ yá, te suhva ni jicān tahú yā: ");
INSERT INTO mibNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Tátā, núu cúní ni te tejiyo ní jnúndóho yáha jéē ma quíji sɨquɨ̄ ná. Te nasūu jéē cuní maá ná, chi jeē cuní maá ní na cóo, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Te ni cane ɨɨn ndajéhé andɨvɨ́ núū yā, te ni jēhe fuerza nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Te cúcuíhyá ndasɨ́ ni yā jeē quiji jnūndóho sɨquɨ̄ yā, te ni nducú ndéyɨ́ gá yā ni jicān tahú yā. Te ni cane jnañū yā, te tóo nuū ñúhun nájnūhun yúyú náhnu nɨñɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Te ná ni ndocuɨñɨ̄ yā jeē ni jícān tahú yā, te ni ndee yā nuū tée cáscuáha jíín yá. Te ni jito ya jeē cáquixī de, chi tuá cáhīyo ndeyɨ́ ni de cacān tahú de jeē cácucuíhyá ndasɨ́ ni de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Te ni cahān yā jiín de: ¿Naun cáquixī rō? Ndonda te cacān tahú rō jeē chindéé ñáhán yá rohó jéē ma sáha ró cuéchi jeē cóto ndee jeneé róhó. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Te sá cáhán gā yā súcuan, te ni quecoo cuehē ñayuu. Te tēe nání Judas, ɨɨn jnáhan jeē uxí uū tēe scuáha jíín yá, yósnúu de nuū ñáyuu un véji de. Te ni quee de nde nuū Jesús, te ni techūhú de ya, te súcuan ni nastúu de ya. ");
INSERT INTO mibNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Te ni cahān Jesús jiín de: Judas, ¿á jíín jéē téchūhu ró ruhū cúu jeē nastúu ró rúhū, Yaā ní nduu tēe? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Te tēe cáhīin jíín yá, ni cajito de jeē ní quejéé cúu, te ni cacajnūhún de ya: ¿A ndonda ná jíjnáhan ná sɨ́quɨ̄ de jíín espada? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Te ɨɨn de ni stují de mozo sutū cujéhnu ga, chi ni jehnde de sōho lado váha. ");
INSERT INTO mibNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Te ni cahān Jesús: Siáá, na jécuɨñɨ̄, achí yá. Te ni tee ya ndaha ya sōho mozo un, te ni nasávāha ya de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Te ni cahān yā jiín sútū cácujéhnu jíín tée cándiso jníñu ini templo jiín táca tée jéhnu jeē ní quecoo de jeē jnɨ́ɨ de ya: ¿Te va tēe cuíhná cúu ri jeē véjicoo ró jíín espada jiín yujnu jeē jnɨɨ ró rúhū jeē súcuan? ");
INSERT INTO mibNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tāca quɨ́vɨ̄ ni ine ri jiín ró jijnáhan ró ini templo cáhnu, te tu ní cájnɨɨ ró rúhū. Te vijna te ni quee hora jeē jnɨɨ ró rúhū jiín jéē sáha ró táca jniñu jeē ndácu jeneé jéē ndeé núū néē. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Te ni cajnɨɨ de ya cuangoo de jíín yá vehe sutū cujéhnu ga. Te Pedro chi jícá‑ni ndíquín de ya. ");
INSERT INTO mibNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Te tācá policía ni cascáyú de ñuhūn ini patio, te ni condúu de yuñúhún un cáyūcú de. Te suni ni cucōo Pedro jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Te ɨɨn ñahan jéjníñu ini vehe un, ní jito ña nuū de jeē néne de yuñúhún. Te ni jito vāha ña nuū de, te ni cahān ña: Tēe yáha suni ni jica de jíín tée ún, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Te máá de tu ní cáchi de, chi ni cahān de: Tu jíní rī tēe ún, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Te ni cunúu jecu gā, te ni jito tucu ɨnga ñayuu nuū Pedro, te ni cahān: Róhó, suni jnáhan tāca tée un cúu ró, áchí. Te ni cahān Pedro: Nasūu cúu ri, hombre, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Te ni cuu nájnūhun ɨɨn hora gā, te ni cahān nīhin ɨnga de: Jendaá ndije jeē tée yáha ní jica de jíín tée ún, chi suni tēe región Galilea cúu de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Te ni cahān Pedro: Hombre, tu jíní rī na jnūhun cáhán rō. Te sá súcuan cáhán gā de, te ni cana‑ni líhli. ");
INSERT INTO mibNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yūcuán na te ni ndió cóto máá Jítoho yō, te ni jito ya nuū Pedro. Te ni nucūhun ni de jnūhun ni cahān yā jiín de: Nde ná tu cana líhli, te yūhu ró te cahān rō unī jínu jeē tu jíní rō ruhū. ");
INSERT INTO mibNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Te ni quenda de cuahān de, te yōhyo ni ndahyū de jeē ní cachi de jeē tu jíní de ya. ");
INSERT INTO mibNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Te tāca tée cándito Jesús, ni casácatā de nuū yā, te ni cacani de ya. ");
INSERT INTO mibNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Te ni cajesɨ de sahma nuū yā, te ni cacani de nuū yā, te ni cacahān de: Cachi ndé ɨɨn cúu jeē ní cani róhó, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Te cuehē gā jnūhun súcuan ni cacahān neé de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Te jeē ní cundijin, te ni candutútú táca tée jéhnu cándacu jniñu nuū ñayuu hebreo, jiín sútū cácujéhnu, jíín tée cástéén tutu ley Yaā Dios. Te cuangoo de jíín yá nuū junta tēe cácujéhnu ga, te yūcuan ní cacajnūhún de ya: ");
INSERT INTO mibNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Cachi, ¿á máá ró cúu Cristo jeē ní tají Yaā Dios? Achí de. Te ni cahān yā jiín de: Vēsú na cáhán rī jeē suu ri cúu, te ni ma candíje cuɨtɨ rō. ");
INSERT INTO mibNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Te suni núu cajnūhun máá rí rohó jíjnáhan ró, te suni ma stió cuɨ́ñɨ́ rō nuū rī, ni ma siaá rō ruhū. ");
INSERT INTO mibNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Te ruhū, Yaā ní nduu tēe, tāca quɨ́vɨ jeē quíji conene ri lado váha máá Yaā iyó poder, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yūcuán na te ndɨhɨ de ni cacajnūhún de ya: ¿A máá ró cúu Sēhe Yaā Dios núu súcuan? Te ni cahān yā jiín de: Suu ri cúu, nájnūhun cácahān rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yūcuán na te ni cacahān de: ¿Na testigo gā jíni ñúhún yó núu súcuan? Chi ni cajini sōho yó jíín yuhu máá de jeē cahán ndevāha de jeē cúu de Sēhe Yaā Dios. Achí de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yūcuán na te ni candocuɨñɨ̄ ndɨhɨ de, te cuangoo de jíín yá nuū Pilato. ");
INSERT INTO mibNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Te yūcuan ní caquejéé de cácahān de cuēchi sɨquɨ̄ yā: Ni canihīn na tée yáha jéē stónda de ñayuu sɨquɨ̄ tohō. Te cáhán de jeē tú vāha jeē cuāha ná xúhun renta nuū rey nación Roma jeē ndácu jniñu nuū nación na. Te suni cáhán de jeē maá de cúu Cristo, Rey jeē ní tají Yaā Dios. Achí de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yūcuán na te Pilato ni cajnūhún de ya: ¿A máá ró cúu Rey ñayuu hebreo? Te ni cahān yā: Suu ri cúu, nájnūhun cáhán rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Te ni cahān Pilato jiín sútū cácujéhnu jíín ñáyuu cuehē ún: Tú ni ɨɨn jnūhun stɨ́vɨ cáhán tēe yáha jéē nihín rī cuēchi sɨquɨ̄ de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Te máá de víhyá gā ni cacahān de: Tēe yáha stónda ndasɨ́ de ñayuu sɨquɨ̄ tohō jiín jnúhun stéén de nɨ́ɨ́ Judea. Chi ni quejéé de stéén de nde Galilea, te vijna te nde yāha, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Te nuū ní jini sōho Pilato jeē Galilea cácahān, te ni cajnūhún de ñayuu núu tēe región Galilea cúu ya. ");
INSERT INTO mibNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Te nuū ní cacahān ñayuu jeē cúu ya tēe Galilea, te ni ndacu de jniñu jeē na quíngoo de jíín yá nuū Herodes, tēe cúu gobernador Galilea. Chi quɨvɨ̄ ún suni íne Herodes ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Te nuū ní jito de nuū Jesús, te yōhyo ni cusɨɨ̄ ni de, chi je ni cuu cuehē tiempo jeē cuní de coto de nuū yā. Chi ni nihīn de jnūhun ya, te ñúhun ni de jeē sáha ya ɨɨn jniñu jéhnu coto de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Te ni cajnūhún de ya cuehē jnūhun, te tu ní stíó cuɨ́ñɨ́ yā ni ɨɨn jnūhun nuū de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Te suni cáhīin tāca sútū cácujéhnu jíín tée cástéén tutu ley, te nīhin ni cacahān de cuēchi sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yūcuán na te Herodes jiín táca soldado de ni cacahān neé de jíín yá, te ni casácatā de nuū yā, chi ni cachuhun de ya sahma váha luu jeē cúu sahma rey. Te Herodes ni ndacu de jniñu jeē na quínundeca de ya nuū Pilato. ");
INSERT INTO mibNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Te máá quɨ́vɨ̄ un ní candumanī jnáhan Pilato jiín Herodes, chi ichi yátá ni caquɨtɨ̄ jnáhan ni de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yūcuán na te ni cana Pilato tāca sútū cácujéhnu jíín táca tée cándiso jníñu jíín táca gá ñayuu, ni candutútú. ");
INSERT INTO mibNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Te ni cahān de: Ni caquindeca ró tée yáha núū rī, jeē cácahān rō jeē stónda de ñayuu sɨquɨ̄ tohō. Te je ni stichí rī de, ni cajito jínúū rō. Te tu ní níhín rī ni ɨɨn cuēchi sɨquɨ̄ de nájnūhun jeē cácahān rō. ");
INSERT INTO mibNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Te ni Herodes, tu ní níhín de, chi ni natají tucu de tēe yáha núū rī. Te tú cuɨtɨ ni ɨɨn cuēchi ní sáha de jeē cúū de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Núu súcuan te na cuáha ri castigo de, te siáá rī de quihīn de, áchí Pilato. ");
INSERT INTO mibNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Te íyó costumbre jeē tācá vico pascua siaá Pilato ɨɨn preso jeē cuní ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Te ñayuu cuehē ún, ɨnuú‑ni ni cacana jee i: Na cúū tēe jíñá, te siáá ní Barrabás, achí i. ");
INSERT INTO mibNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Te Barrabás íne de vecāa sɨquɨ̄ jeē ni stónda de ñayuu sɨquɨ̄ tohō ini ñuu ún, te ni jehni de ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Te Pilato cuní de siáá de Jesús, te ni cahān tucu de jíín ñáyuu. ");
INSERT INTO mibNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Te máá i víhyá gā ni cacana jee i: Cata caa ní de jicā cruz, na cúū de, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Te ni cahān tucu de jíín i vuelta unī: ¿Na cuēchi ni sáha de núu súcuan? Tu ní níhín cuɨtɨ rī ni ɨɨn cuēchi sɨquɨ̄ de jeē cúū de. Núu súcuan te na cuáha ri castigo de, te siáá rī de quihīn de, áchí Pilato. ");
INSERT INTO mibNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Te víhyá gā ni cacana jee ñayuu un, ní cacahān nīhin i jeē na cúū yā jicā cruz. Te máá i jíín táca sútū cácujéhnu, ni cacana jee ndasɨ́ i. Te ni cacundeyɨ́ i ni cascáhān i Pilato jeē na cúū yā. ");
INSERT INTO mibNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yūcuán na te ni ndacu Pilato jniñu jeē na cóo nájnūhun cácuni i. ");
INSERT INTO mibNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Te ni siaá de tēe jeē ní cajicān i, tēe jeē íne vecāa jeē ni stónda de ñayuu sɨquɨ̄ tohō te ni jehni de ndɨ̄yɨ. Te ni jēhe de jnūhun jeē na cúū Jesús nájnūhun cácuni i. ");
INSERT INTO mibNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Te cuangoo tācá soldado jiín yá jeē cahni de ya jicā cruz. Te ni canihīn de ɨɨn tēe ñuu Cirene, nání de Simón, vendiji de jeē ni jéhēn de rancho. Te ni catejníñu de tēe un jéē cóndiso de cruz yā quihīn de yatā yā. ");
INSERT INTO mibNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Te cuehē ndasɨ́ ñáyuu ndíquín i yatā yā cuangoo i. Te suni cuehē ñahan cuangoo ña, te cándahyū cohó ña jeē cácucuíhyá ni ña jehē yā. ");
INSERT INTO mibNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Te ni ndió cóto Jesús nuū ña, te ni cahān yā: Róhó ñahan Jerusalén jijnáhan ró, ma ndahyú rō jehē rī, chi sa suhva ndahyū rō jehē maá ró jiín jéhē sēhe ró jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chi quee quɨvɨ̄ jeē coo jnūndóho xeēn sɨquɨ̄ rō, te cahān rō: Yōhyo ndetū tācá ñahan númá, jíín jéē tu ní scácu sēhe, jíín jéē tu ní cóndeca yɨquɨ́n, chi tú sēhe ña jeē jnahuhū ni ña jeē ndóho i, achi rō jijnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Quɨvɨ̄ ún te quejéé ñáyuu cahān i jíín táca yucu: Cotúú sɨ́quɨ̄ rī jijnáhan ri návāha cuu rī. Te suni jíín táca loma: Casɨ sɨquɨ̄ rī jijnáhan ri, achi i. ");
INSERT INTO mibNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chi núu cásáha xeēn i jíín rúhū jeē tú na cuēchi ri, te nagā ni cuu jeē ma cóo xeēn sɨquɨ̄ ndɨhɨ ñayuu chi íyó cuéchi i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Te suni cuangoo de jíín úū tēe ni casáha cuēchi xeēn, jeē suni cuu de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Te ni jinūcoo de lugar nuū naní Yɨquɨ Xíní, te yūcuan ní cacata caa de ya jicā cruz. Te suni ni cacata caa de ndɨndúú tée ni casáha cuēchi xeēn un núū uū gā cruz, ɨɨn de lado váha ya, te ɨnga de lado jecó yá. ");
INSERT INTO mibNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Te níní jéē súcuan cúu, te ni cahān Jesús: Tátā, cone cáhnu ni ni núū de jíjnáhan de, chi tu cájini de na vé casáha de, áchí yá. Te soldado un ní casáha de sorteo jeē sɨquɨ́ ndese nihīn ɨɨn ɨɨn de sahma ya. ");
INSERT INTO mibNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Te cáhīin ñayuu yūcuan, cájito i nuū yā. Te suni nde tēe cándiso jníñu, cácahān catá de cájito de ya: Núu ɨnga ñayuu ni jnama de, te na jnáma de máá de vijna, te núu ndaā jeē Cristo jeē ní nacāji Yaā Dios cúu de, áchí. ");
INSERT INTO mibNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Te tācá soldado suni ni casácatā de nuū yā, chi ni quecoo de nde nuū yā, te ni cajēhe de vinagre iyá coho ya. ");
INSERT INTO mibNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Te cácahān de jíín yá: Núu máá ró cúu Rey ñayuu hebreo, te na jnáma ró máá ró, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Te suni ni īyo jnūhun jeē ndeé xinī cruz yā jeē cahán na sɨquɨ̄ ni jíhī yā, te suhva yósó jíín yuhu griego jiín latín jiín hebreo: Yāha cúu Rey ñayuu hebreo, achí. ");
INSERT INTO mibNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Te ɨɨn jeē ndɨndúú tée ni casáha cuēchi xeēn, jeē cándita caa, ni cahān neé de nuū yā: Núu máá ró cúu Cristo, te na jnáma ró máá ró te suni jnama ró ndɨndúú rí, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Te ɨnga de ni cahān de nuū jnáhan de: ¿A tu yúhú ró Yaā Dios naún? Chi ɨnuú cándoho yó jíín Yaā yáha. ");
INSERT INTO mibNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Te máá yó chi vetū‑ni cándoho yó, chi yāha cánihīn yō castigo sɨquɨ̄ jniñu néé ní casáha yó. Te Yaā yáha chi tú ni ɨɨn cuēchi ní sáha ya, achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Te ni cahān de jíín yá: Jesús, nucūhun ni ni sáña jéē quéjéé ní ndacu ní jniñu, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yūcuán na te ni cahān Jesús jiín de: Jendaá cahán rī jiín ró jeē víjna te condee rō jiín rí nuū jardín andɨvɨ́, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Te nuū ní cuu nájnūhun cahuxī uū, te ni cunee nɨɨ́ cáhnu nde cahunī. ");
INSERT INTO mibNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Te ni cujnúú níāndii. Te sahma ndíta caa jeē ndihyú cuarto iī ini templo cáhnu, ni ndatā‑ni sava sava. ");
INSERT INTO mibNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yūcuán na te ni cana jee Jesús: Tátā, naquihin ní ánuá na, áchí yá. Te súcuan ni cahān yā, te ni jihī‑ni ya. ");
INSERT INTO mibNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Te tēe nación Roma jeē cúu capitán ni jito de jeē súcuan ni cuu, te ni cahān de jeē yóhyo cújéhnu Yaā Dios, te áchí de: Jendaá ndije jeē tée tú na cuēchi cúu tēe yáha, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Te ndɨvii ñayuu cáhīin yūcuan ní cajito i tāca jéē ní cuu, te cácani i yɨ̄quɨ jícā i jeē cájnahuhū ni i, te ni nandió cóo i cuanungoo i. ");
INSERT INTO mibNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Te tāca ñáyuu cájini jnáhan jíín yá, jiín táca ñahan Galilea jeē ní cajica ña jíín yá, cáhīin jícá ña cájito ña tāca jéē ní cuu. ");
INSERT INTO mibNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Te ni īyo ɨɨn tēe vāha tēe ndaā, nání de José. Te tēe ñuu Arimatea ndañúū Judea cúu de. Te cúu de jnáhan tāca tée hebreo cácujéhnu ga jeē casáha junta. ");
INSERT INTO mibNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Te ñúhun ni de jeē quiji quɨvɨ̄ jeē ndacu Yaā Dios jniñu, te suni tu ní nújnahan ni de jeē ní casándaā junta un jéē cúū Jesús. ");
INSERT INTO mibNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Te tēe un ní jehēn de nuū Pilato, ni jicān de yɨquɨ cúñu Jesús. ");
INSERT INTO mibNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Te ni snúu de ya jicā cruz, te ni chusúcún de ya ɨɨn sahma cuitá. Te ni chindūji de ya ini ɨɨn yaū jeē ní caan jicā ɨɨn cava, nuū ná tu quindūji ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Te quɨvɨ̄ un cúu quɨvɨ̄ casátūhva ñayuu, chi jehíni un quéjéé quɨ́vɨ̄ ndétātú. ");
INSERT INTO mibNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Te ñahan ní quijicoo jíín yá nde Galilea, ni jengoo ña jíín José, te ni cajito vāha ña yaū ún, jíín ndese ni cachindūji de ya. ");
INSERT INTO mibNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Te cuanungoo ña vehe ña, te ni casátūhva ña tācá perfume jiín aceite yucū jeén asɨ̄n. Te ni candetātú ña quɨvɨ̄ ndétātú, nájnūhun ndácu ley Yaā Dios jniñu. ");
INSERT INTO mibNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Te jenéhen ndasɨ́ quɨ́vɨ̄ domingo, te ni jinūcoo tucu ñahan un núū ní yɨndūji Jesús, te cándahá ña tācá perfume jiín aceite ni casátūhva ña. Te suni cuangoo sava ga ñahan jíín ña. ");
INSERT INTO mibNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Te nuū ni jínūcoo ña, te ni cajito ña jeē ní cujiyo yuū ndihyú yuyáú ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Te ni quɨ̄vɨcoo ña yaū ún, te tuá yɨquɨ cúñu Jitoho yō Jesús ni cájito ña. ");
INSERT INTO mibNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Te ni cacunéé ni ña cájito ña jeē tuá ndɨ̄yɨ. Sáá te ni cajito ña uū ndajéhé Yaā Dios jeē cáa nájnūhun tēe, cáhīin ya xiin ña, te cáñūhun ya sahma ndíndēé. ");
INSERT INTO mibNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Te yōhyo ni cayūhú ña, te ni cajexin ña nuū ña nde nuū ñúhun. Te ni cacahān ndajéhé un jíín ña: ¿Naun sa nuū cáyɨndūji ndɨ̄yɨ cánanducú ró Yaā técu? ");
INSERT INTO mibNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tuá yā yāhá, chi je ni natecu yā. Te nucūhun ni rō ndese ni cahān yā jiín ró ná íne ga yā región Galilea. ");
INSERT INTO mibNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Chi ni cachi ya jeē maá yá, Yaā ní nduu tēe, cánuú natūu ya nuū tāca tée cáhīyo cuēchi, jeē jnɨɨ de ya cahni de ya jicā cruz, te nuū uní quɨvɨ̄ te natecu yā. Achí ndajéhé un. ");
INSERT INTO mibNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yūcuán na te ni canucūhun ni ña tāca jnúhun ni cahān Jesús. ");
INSERT INTO mibNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Te ni quendacoo ña nuū ní yɨndūji ya, te cuanungoo ña. Te ni canacani ña tāca jnúhun yáha núū ndɨhúxí ɨɨn apóstol jiín núū tāca gá de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Te ñahan ní canacani jnūhun yáha núū tée cácuu apóstol, cúu ña María ñuu Magdala, jiín Juana, jiín María naná Jacobo, jiín sava ga ña. ");
INSERT INTO mibNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Te tācá apóstol chi cájeni ni de jeē jnúhun cánéé cáñúú cácahān ña, te tu ní cácandíje de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Te vēsú súcuan, te Pedro ni quenda de, te jínu de cuacondēhé de nuū ní yɨndūji ya. Te ni jito nihni de ini yaū, te ni jito de jeē sahma cuitá un cáyūcu máá na. Te cuanuhun de vehe de, te nahán náā ni de jeē ní jito de jeē tuá yā. ");
INSERT INTO mibNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Te suu quɨvɨ̄ un cuángoo uū jnáhan de ɨɨn ñuu naní Emaús, jeē jicá nájnūhun uxī ɨɨn kilómetro jiín ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Te cándajnūhún de sɨquɨ̄ tācá jniñu jeē ní cuu ún. ");
INSERT INTO mibNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Te níní cándajnūhún de te cácajnūhun jnáhan de, te máá Jesús ni cuyajni ya yatā de, te jíca ya cuahān yā jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Te ni sáha jíín de jeē tu ní cánacuni de ya, vēsú cájito de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Te ni cajnūhun yá de: ¿Na jnūhun cándajnūhun ró cájica ró? ¿Te najehē cácucuíhyá ni rō? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Te ɨɨn de jeē naní Cleofas ni cahān de jíín yá: Ndɨhɨ cuɨtɨ ñayuu cájini i tācá jniñu ní cuu ini ñuu Jerusalén tāca quɨ́vɨ̄ yáha. ¿Te á máñúhún‑ni níhín cúu jeē ní quee ní ñuu un jéē tu jíní ni na vé ni cuu? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Te ni cajnūhun yá de: ¿Te na vé ni cuu? Achí yá. Te ni cacahān de jíín yá: Jeē ní ndoho Jesús ñuu Nazaret, Yaā ní nacani jnūhun Yaā Dios. Te jíín poder Yaā Dios ni sáha ya tācá jniñu jéhnu te ni nacani ya jnūhun, jíto jínúū Yaā Dios jiín táca ñáyuu. ");
INSERT INTO mibNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Te sutū cácujéhnu jíín tée cándiso jníñu nuū ná, ni canastúu de ya nuū tāca tée Roma, te tēe un ní casándaā de jeē cúū yā jicā cruz. ");
INSERT INTO mibNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Te máá ná ní cañūhun ni na jéē maá yá jnama ya nación na Israel nuū ñáyuu Roma nuú. Te sɨquɨ̄ tācá jniñu yáha, te ni cane ɨnga jnūhun. Chi vijna je íyó únī quɨvɨ̄ jeē ní cuu ún. ");
INSERT INTO mibNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Te sava ñahan cájini jnáhan ná jíín, ni canacani ña ɨɨn jnūhun jeē yóhyo cánaa ni na sáha, chi cácahān ña jeē ní natecu yā. Chi jenéhen ndasɨ́ ní jengoo ña yaū ndɨ̄yɨ ún. ");
INSERT INTO mibNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Te tuá ni cájito ña yɨquɨ cúñu yā. Te ni ndecoo ña nuū na jíjnáhan ná, te cácahān ña jeē ní cajito ña jeē ní canecoo ndajéhé Yaā Dios nuū ña, te ni cacahān jeē ní natecu Jesús. ");
INSERT INTO mibNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Te ni jengoo sava jnáhan ná ndé yaū ndɨ̄yɨ ún, te ni cajito de jeē súcuan íyó, nájnūhun ni cacahān ñahan ún, te tu ní cájito cuɨtɨ de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yūcuán na te ni cahān maá yá jiín de: Tēe tu cájecūhun cuɨtɨ ni cácuu ró. Yōhyo uhū cácandíje ró táca jnúhun Cristo ni cacahān tēe ni canacani jnūhun Yaā Dios nde jenahán. ");
INSERT INTO mibNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Te á tu súcuan ní jíni ñúhún ndoho Cristo tāca jnúndóho yáha, te sáá te quinuhun yā nuū lúu cujéhnu ya? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Te ni nacani cájí yá tāca jnúhun jeē yosó núū tútu iī jeē cahán sɨquɨ̄ maá yá. Te ni quejéé yá jiín jnúhun ni tee Moisés, te ni cahān gā yā tāca jnúhun jeē ní catee tēe ni canacani jnūhun ya nde jenahán. ");
INSERT INTO mibNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Te nuū ni jínūcoo de ñuu nuū cuángoo de ún, te Jesús ni sáha ya jeē cáca ga yā quihīn yā. ");
INSERT INTO mibNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Te máá de ni castétu de ya, ni cacahān de jíín yá: Ndōo ní vehe ná, chi je ni ini te je yajni cuaa, áchí de. Yūcuán na te ni quɨ̄vɨ ya jeē quéndōo ya jiín de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Te nuū ní cucōo ya mesa jeē cáji yā jiín de jíjnáhan de, te ni quihin ya staā, te ni jicān tahú yā, te ni tahú cuéchí yá, te ni jēhe ya nuū de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Te jeē sáha ya súcuan, te nájnūhun ni cananune tɨnūú de, te ni canacuni de ya. Te ni ndoñúhún‑ni ya nuū de cuahān yā. ");
INSERT INTO mibNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Te ni cacahān maá de: Jendaá jeē yóhyo ni cacusɨɨ̄ ni yō ná ni nacani ya jnūhun nuū yō ichi ún te ni castūhun cájí yá jnūhun cáhán tutu iī. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yūcuán na te yachī ni canaquihin de ichi, ni canandicó de cuanungoo de ñuu Jerusalén. Te ni canajnáhan de jíín ndɨhúxí ɨɨn ga apóstol, cáyūcu tútú de jíín sava ga jnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Te ni cacahān tēe cáyūcu tútú un: Jendaá ndije jeē ní natecu maá Jítoho yō, te ni nane ndijin yā nuū Simón, achí de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yūcuán na te ndɨndúú tée un ní canacani de jnūhun ndese ni najnáhan ya jiín de ichi, jíín ndese ni canacuni de ya ná ni tahú cuéchí yá staā. ");
INSERT INTO mibNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Te sá cácahān gā de tāca jnúhun yáha, te ni jecuɨñɨ̄‑ni Jesús mēhñú de jíjnáhan de. Te ni cahān yā jiín de: Ndeyɨ́ sɨ́ɨ̄ coo ni rō jijnáhan ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Te ni candacoto īyo de, ni cayūhú ndasɨ́ de, chi ni cajeni ni de jeē ɨɨn ánuá cúu ya. ");
INSERT INTO mibNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Te ni cahān yā jiín de: ¿Naun cáyūhu ró, te naun cájeni sɨquɨ́ ni rō súcuan? ");
INSERT INTO mibNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Condēhé ndaha ri jiín jéhē rī, te cuni rō jeē maá rí cúu. Jnɨɨ ruhū te cuni rō, chi ɨɨn ánuá tu névāha cūñu ni yɨquɨ nájnūhun cájito ró jéē névāha máá rí, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Te jeē ni cáhān yā súcuan, te ni steén yā ndaha ya jehē yā nuū ni yɨ́hɨ ndūyu cāa. ");
INSERT INTO mibNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Te yōhyo ni cacusɨɨ̄ ni de, te cánaa ni de. Te vēsú súcuan te ná tu candíje vāha vāha de jeē maá yá cúu. Te ni cahān yā jiín de: ¿A cánevāha ró jecu jeē cáji rī yāhá? áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yūcuán na te ni cajēhe de ɨɨn pedazo chācá ní tau nuū yā, jiín ɨɨn pedazo ñahmā ndūxi yocō. ");
INSERT INTO mibNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Te ni quihin ya, te ni yeji yā nuū de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Te ni cahān yā jiín de: Tāca jéē ní cuu jíín rí cúu jeē ni cáhān rī ná ni ine ri jiín ró jíjnáhan ró ndé saá, jeē cánuú squícu tāca jnúhun ri jeē yosó núū tútu ley Moisés, jiín núū tācá tutu tēe ni canacani jnūhun Yaā Dios, jiín núū tútu salmo, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Te ni nune ya jeē níjnūní de, návāha cuu jecūhun ni de tāca jéē cahán tutu iī. ");
INSERT INTO mibNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Te ni cahān yā: Súcuan cáhán nuū tútu jeē ruhū Cristo, cánuú cuu rī, te nuū uní quɨvɨ̄ natecu rī. ");
INSERT INTO mibNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Te cuitē núu jnūhun ri jeē cánuú nacani ni ñayuu jeē stóo i cuēchi i, te cone cáhnu ni Yaā Dios nuū i. Te ñuu Jerusalén quejéé cuítē núu jnūhun yáha, te quihīn nuū ñáyuu tācá nación. ");
INSERT INTO mibNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Te máá ró cácuu tēe nacani jnūhun tācá jniñu ní cajito ró. ");
INSERT INTO mibNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Te tají rí Espíritu Santo quiji ya nuū rō jijnáhan ró, nájnūhun ni jejnūhun Tátá rī. Te na quéndōo ró ñuu Jerusalén condetu ró ndé nihīn rō poder Espíritu Santo jeē quíji nde andɨvɨ́. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yūcuán na te ni quenda ya ñuu Jerusalén, cuahān yā nde ñuu Betania jiín de jíjnáhan de. Te ni ndonehen ya ndɨndúú ndaha ya, te ni jicān tahú yā jehē de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Te níní jícán tahú yā jehē de, te ni cujiyo‑ni ya nuū de, ni ndaa ya cuanuhun yā andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Te máá de ni cachiñúhún de ya. Te sáá te cuanungoo de ñuu Jerusalén, te yōhyo cácusɨɨ̄ ni de. ");
INSERT INTO mibNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Te níní cáhīin de ini templo cáhnu, cánacuatáhú de nuū Yaā Dios. Te ni cuu. Amén.");
INSERT INTO mibNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nde xīhna ñúhún ná ni jecōo ndɨhɨ jeē iyó, te je íyó Yaā naní Jnúhun Yaā Dios, chi stéén yā ndɨhɨ jnūhun ndese Yaā cúu Yaā Dios. Te Yaā naní Jnúhun un ndéé yá jiín Yaā Dios, te Yaā Dios cúu ya. ");
INSERT INTO mibNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Máá yá ndeé yá nde jeē xíhna ñúhún jíín Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Te ni sáha Yaā Dios jeē jiín máá yá ni jecōo ndɨhɨ tāca jéē iyó. Te ma jécōo ni ɨɨn jeē iyó núu tu ní sáha máá yá. ");
INSERT INTO mibNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Máá yá sáha jeē técu ndɨhɨ‑ni, te máá yá cúu luz jeē steén ini anuá ñayuu, cúu jeē sáha ya jeē jécūhun ni i sɨquɨ̄ Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Te Yaā cúu luz ún ndíndēe núū ñáyuu tu cájica ndaā, jeē nájnūhun cáhīyo i nuū néē. Te ñayuu cáhīyo nuū néē tu cúu ndahva i luz yā. ");
INSERT INTO mibNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Te ni īyo ɨɨn tēe jeē ní tají Yaā Dios, naní de Juan. ");
INSERT INTO mibNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tēe un ní quiji de jeē nácani cájí de jnūhun máá Yaā cúu luz, návāha candíje tāca ñáyuu jeē jiín jnúhun cáhán de. ");
INSERT INTO mibNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nasūu máá Juan cúu luz ún, chi cúu de ɨɨn jeē ní nacani cájí jnúhun máá luz un. ");
INSERT INTO mibNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Te máá Yaā cúu luz ndije jeē steén ini anuá tāca ñáyuu, nde saá ní quiji ya ini ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Te Yaā cúu Jnūhun Yaā Dios ni condee yā ini ñayɨ̄vɨ́, te vēsú jeē jiín máá yá ni sáha Yaā Dios ñayɨ̄vɨ́, te ñayuu ñayɨ̄vɨ́ tu ní cácuni i cuatáhú i jeē maá yá cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ni quiji ya nuū ñáyuu maá yá nación hebreo, te ñayuu ún tu ní cájetáhú i ya. ");
INSERT INTO mibNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Te vēsú súcuan te sava ñayuu chi ni cajetáhú i ya, te ni cacandíje i jeē sáha ya jehē i. Te nuū maá i ni jēhe ya jnūhun jeē ndúu i sēhe Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Te jeē ndúu i sēhe Yaā Dios, nasūu jíín modo jeē cácacu ñayuu ini ñayɨ̄vɨ́, ni nasūu sɨ́quɨ̄ jeē cácuni tēe, chi máá Yaā Dios sáha ya jeē ndúu i sēhe ya. ");
INSERT INTO mibNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Te máá Yaā cúu Jnūhun Yaā Dios ni nduu ya tēe, te ni condee yā jiín yó. Te ni cajito yó jéē yóhyo luu cújéhnu ya, chi máñúhún‑ni ya cúu Sēhe Tátá yā, Yaā cujéhnu súcuan. Te máni máá jéē sáha ya jeē váha yóhó, te máni máá jnúhun ndaā cahán yā. ");
INSERT INTO mibNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Te Juan ni nacani de jnūhun ya, te ni cahān de: Yaā yáha cúu jeē ni cáhān rī náa áchí rí jeē Yaā quiji chi cújéhnu ga yā vēsú ruhū, chi je íyó yá nde ná tu cacu ri, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Te ndɨhɨ yó ní canihīn yō cuehē ndasɨ́ jeē váha íyó núū yā, chi máni jeē váha sáha sáha ya jiín yó. ");
INSERT INTO mibNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés ni steén de ley Yaā Dios nuū ñáyuu jenahán, te Jesucristo chi sáha ya jeē váha yóhó te stéén yā tāca jnúhun ndaā Yaā Dios nuū yō. ");
INSERT INTO mibNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tú ni ɨɨn ñayuu ni jíto cuɨtɨ nuū Yaā Dios. Te máñúhún‑ni Sēhe ya jeē ndeé yá jiín Tátá yā, suu ya ni steén nuū yō ndese Yaā cúu Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Te ñayuu hebreo ñuu Jerusalén, ni catají i jecu sutū jiín tée grupo levita jeē cájejníñu ini templo, ni jengoo de nuū Juan, návāha cajnūhún de ndé ɨɨn cúu Juan te na jniñu ndíso de. ");
INSERT INTO mibNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Te Juan cájí ní cachi de: Nasūu rúhū cúu Cristo, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Te ni cacajnūhún tucu de: Núu súcuan ¿te ndé ɨɨn cúu ró? ¿A cúu ró Elías, tēe ni nacani jnūhun Yaā Dios nde jenahán, chí naún? Te ni cahān Juan: Nasūú de cúu ri. Te ni cacajnūhún tucu de: Núu súcuan ¿te á cúu ró tée nacani jnūhun Yaā Dios jeē achí tutu iī jeē quíji? Tuú, áchí tucu Juan. ");
INSERT INTO mibNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Te ni cacahān tucu jíín de: ¿Te ndé ɨɨn cúu ró núu súcuan? Cachi nuū rī jijnáhan ri, chi jíni ñúhún castūhun rí nuū tāca tée ni catají rúhū vējicoo ri. Cachi na jniñu ndíso ró víī. ");
INSERT INTO mibNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Te ni cahān Juan: Máá rí cúu tēe jeē ni cáhān Isaías, tēe ni nacani jnūhun Yaā Dios nde jenahán, jeē quíji ri cana jee ri nde nuū ñúhun téhé. Te cáhán rī jiín ñáyuu jeē na sátūhva i máá i, chi quiji máá Jítoho yō. Achí Juan. ");
INSERT INTO mibNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Te tēe grupo fariseo cácuu jeē ní catají tée ni quijicoo ún. ");
INSERT INTO mibNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Te ni cacajnūhún de Juan: Núu súcuan ¿te naun scuándute ró te núu nasūu Cristo ni Elías ni máá tée quiji nacani jnūhun Yaā Dios cúu ró? ");
INSERT INTO mibNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Te ni cahān Juan: Ruhū chi jíín ndute scuándute ri. Te mēhñu ró jijnáhan ró íne ɨɨn Yaā jeē tu cájini rō. ");
INSERT INTO mibNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Te Yaā un cúu jeē ni cáhān rī jeē quíji ya te cújéhnu ga yā vēsú ruhū. Chi tú na vé jéhnu cuɨtɨ cúu ri nuū yā, ni jeē cuajníñu ri nuū yā vēsú ɨɨn jniñu lúlí gá nájnūhun jeē ndají rí correa ndijēn yā. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Súcuan ni cuu jeē ní candajnūhún de jíín Juan nde Betábara jeē íne ichi núū cáne niāndii yūte Jordán, nuū scuándute Juan. ");
INSERT INTO mibNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Te ɨnga quɨvɨ̄ un ní jito Juan nuū Jesús jeē véji ya nuū de. Te ni cahān de jíín ñáyuu: Condēhe jíjnáhan ró, chi yāha véji Yaā cúu Londe jeē ní tají Yaā Dios, te cuu yā jeē sándoo ya cuēchi ñayuu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yaā yáha cúu jeē ni cáhān rī jeē quíji ɨɨn Yaā cujéhnu ndasɨ́, chi je íyó yá nde ná tu cacu ri. ");
INSERT INTO mibNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Te nde saá te tu ní jíní rī jeē yāha cúu Yaā ní tají Yaā Dios. Te ni quiji ri jeē scuándute ri ñayuu ñuu yō Israel jiín ndute, návāha stéén rī nuū i jeē suu ya cúu, áchí Juan. ");
INSERT INTO mibNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Te suni ni cahān gā de jnūhun ya: Ni jito ri Espíritu Santo, ni cuun ya ichi ándɨvɨ́, cáa ya nájnūhun paloma, te ni quee ya xinī Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Te nde saá te ná tu cuni rī jeē Jesús cúu. Te máá Yaā Dios jeē ní tají yá ruhū jeē scuándute ri jiín ndute, ni cahān yā jiín rí: Núu ni jito ró jéē cúun Espíritu Santo te quendōo xinī ɨɨn tēe, yūcuan cúu Yaā jeē cuáha Espíritu Santo condee ini anuá ñayuu, achí Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Te je ni jito ri ún, te nácani cájí rí jnūhun jeē maá yá cúu Sēhe Yaā Dios. Achí Juan. ");
INSERT INTO mibNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Te ɨnga quɨvɨ̄ ún te Juan íne tucu de yūcuan jíín úū tēe cájica jíín de. ");
INSERT INTO mibNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Te ni jito de nuū Jesús jeē jíca ya yūcuán. Te ni cahān de: Condēhe jíjnáhan ró, chi yūcuan cúu Yaā cúu Londe jeē ní tají Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Te ndɨndúú tée cájica jíín Juan ni cajini sōho de jnūhun yáha, te ni candiquīn de Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Te ni ndió cóto Jesús, te ni jito ya jeē cándiquīn de yatā yā. Te ni cahān yā jiín de: ¿Na vé cánanducú ró? Te ni cacahān de jíín yá: Maestro, ¿ndé nuū ndeé ní? ");
INSERT INTO mibNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Te ni cahān yā jiín de: Quíngoo yó te cuni rō. Te ni jengoo de, te ni cajito de nuū ndeé yá. Te ni caquendōo de jíín yá quɨvɨ̄ ún, chi nájnūhun cacuūn jehíni cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Te Andrés, ñani Simón Pedro, cúu ɨɨn jeē ndɨndúú tée un jéē ní cajini sōho jnūhun ni cahān Juan, te ni candiquīn Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Te Andrés, yachī ni jenanducú de ñani de Simón, te ni cahān de jíín: Ni caquijnáhan ri jiín Mesías, achí de. Te jnūhun un cúní cahān Cristo, Yaā ní tají Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yūcuán na te cuanuhun de nuū Jesús jiín Simón. Te nuū ní jito Jesús nuū Simón, te ni cahān yā: Máá ró cúu Simón sēhe Jonás. Te nde vijna te conaní ró Cefas, achí yá. Te jnūhun un cúní cahān Pedro, jeē cuní cahān yuū. ");
INSERT INTO mibNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Te ɨnga quɨvɨ̄ un cúní Jesús quihīn yā región Galilea. Te ni nihīn jnáhan ya jiín Felipe, te ni cahān yā jiín de: Condiquīn ruhū na quíhín yō. ");
INSERT INTO mibNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Te Felipe cúu tēe ñuu Betsaida, jeē cúu ñuu Andrés jiín Pedro. ");
INSERT INTO mibNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Te ni jenanducú de Natanael, te ni cahān de jíín: Ni canihīn jnáhan ri jiín Yaā jeē yosó jnúhun ya nuū tútu ley jeē ní tee Moisés, jiín núū tútu ni catee tēe ni canacani jnūhun Yaā Dios nde jenahán. Te Jesús sēhe José ñuu Nazaret cúu ya. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Te ni cahān Natanael jiín de: ¿Te ndese cúu cujéhnu ɨɨn tēe jeē ní cacu ñuu ndahú Nazaret? Te ni cahān Felipe: Quíhín yō de cuni rō, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Te ni jito Jesús jeē véji Natanael, te ni cahān yā: Yāha véji ɨɨn tēe ndaā jeē cúu ndije yucūn Israel, chi tu stáhú cuɨtɨ de, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Te ni cahān Natanael jiín yá: ¿Ndese jíní ni sáña? Te ni cahān Jesús: Je ni jito ri rohó ndé ná tu cana Felipe xinī rō, ná íne ró jéhē nundéhe higo, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Yūcuán na te ni cahān Natanael jiín yá: Maestro, máá ní cúu Sēhe Yaā Dios, máá ní cúu Rey ñuu yō Israel, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Te ni cahān Jesús: ¿A máá jéē ni cáhān rī jeē ní jito ri rohó ná íne ró jéhē nundéhe higo, te jeē yúcuan cándíje ró rúhū naún? Tuú chi coo jniñu jéhnu ga coto ró vēsú jeē yáha, áchí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Te ni cahān gā yā: Jendaá cahán rī jiín ró jijnáhan ró jéē nde vijna te coto ró jéē núne andɨvɨ́, te tācá ndajéhé Yaā Dios cándaa cánuu nuū ruhū, Yaā ní nduu tēe, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Te ni yāha unī quɨvɨ̄, te ni īyo ɨɨn vico nándāha ñuu Caná ndañúū Galilea. Te yūcuan íne náná Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Te suni ni cacana i Jesús jiín tée cáscuáha jíín yá, ni jehēn yā vico un jíín de. ");
INSERT INTO mibNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Te ni ndoco vino. Te náná Jesús ni cahān ña jíín yá: Ni ndoco vino i, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Te ni cahān Jesús jiín ña: ¿Naun cáhán ni súcuan jíín ná nánā? Chi ná tu quee quɨvɨ̄ jeē sáha ná jniñu jéhnu, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Te náná yā chi ni cahān ña jíín ñáyuu cájeni cohō: Sáha ró jíjnáhan ró táca jéē cahān yā jiín ró. Achí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Te yūcuan íyó íñū tenéjá yuū jeē ñúhun ndute cájichi ñayuu hebreo jeē ndúndoo i nuū Yaā Dios. Te ɨɨn ɨɨn tenéjá un cánda cuhun cuūn xico chí ciento litro ndute. ");
INSERT INTO mibNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Te ni cahān Jesús jiín ñáyuu cájeni cohō: Scútú ndɨ́ɨ̄ rō tācá tenéjá yáha. Te ni cascútú ndɨ́ɨ̄ i. ");
INSERT INTO mibNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Te ni cahān yā jiín i: Vijna te quēen ró jecu te quindeca ró coto ndee tēe ndíto vico, áchí yá. Te ni cajendeca i nuū de. ");
INSERT INTO mibNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Te ni séyūhú de ndute jeē ní nduu vino, te tu jíní de ndé ní canihīn i. Chi máni mozo un cúu jeē cájini, chi máá i ni caquēen ndute ún. Yūcuán na te tēe ndíto vico ni cana de tēe nándāha. ");
INSERT INTO mibNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Te ni cahān de jíín: Tāca ñáyuu chi xīhna gā vino váha cájēhe i, te núu je ni cajihi vāha ñayuu cáhīin vico, yūcuán na te jéhe de vino ndahú na. Te máá ró tucu ni sáha ró, chi nde jeē sándɨ̄hɨ́ te jéhe ró vino jeē yóhyo vāha ga jíhi, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jniñu yáha jéē ni sáha Jesús ini ñuu Caná ndañúū Galilea cúu jniñu jéhnu xīhna ñúhún jéē ni sáha ya jeē steén yā poder yā. Te súcuan ni steén yā jeē yóhyo cújéhnu ya. Te tēe cáscuáha jíín yá ni cacandíje de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Te ná ni yāha jniñu yáha, te cuahān yā ñuu Capernaum jiín náná yā jiín táca ñani yā jiín tée cáscuáha jíín yá. Te ni coyūcu yá yūcuán jecu quɨvɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Te jeē cuácuyajni vico pascua casáha jnáhan ñuu yā hebreo, te cuahān yā ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Te ini templo cáhnu ni jito ya ñayuu cáxīcó stɨquɨ̄ jiín lanchi jíín paloma, jiín ñáyuu castáyɨ xūhun, cáyūcú i nuū mesa i. ");
INSERT INTO mibNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Te jeē súcuan ni jito ya, te ni sáha ya ɨɨn cuarta ñɨɨ. Te ni scúnu ya tācá i ini templo, nde jiín lanchi jíín stɨ́quɨ̄ i. Te ni jete yā xūhun ñáyuu castáyɨ. Te ni scotúú yá tāca mesa i. ");
INSERT INTO mibNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Te ni cahān yā jiín ñáyuu cáxīcó paloma: Tava tācá quɨtɨ yáha. Te ma sáha ró yáhu ini vehe Tátá rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yūcuán na te tēe cáscuáha jíín yá, ni canucūhun ni de jnūhun yósó núū tútu iī: Je yajni cuu na jéē yóhyo ndɨ́hvɨ́ ni na sɨ́quɨ̄ vehe ní, áchí yá jiín Tátá yā, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Te tēe ñuu yā hebreo ni cacajnūhún de ya: ¿Na jniñu jéhnu sáha ró jéē steén rō poder rō, te cucáhnu ni rī jeē ndíso jníñu ró sáha ró súcuan? áchí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Te ni cahān yatá Jesús: Canu rō templo yáha, te nuū uní quɨvɨ̄ te nucondichi sáha ri, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yūcuán na te ni cacahān tēe hebreo un: Uū xico iñū cuiyā te ni jīnu ni cuvāha templo yáha. Te róhó, ¿á núū uní‑ni quɨvɨ̄ te nucondichi sáha ró naún? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Te templo jeē cahán Jesús cúu máá yɨquɨ cúñu yā, chi cahni ñayuu yā te natecu yā nuū uní quɨvɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jeē yúcuan cúu jeē ná ni natecu yā jeē ni jíhī yā, te tēe cáscuáha jíín yá ni canucūhun ni de jeē ni cáhān yā jnūhun yáha. Te ni cacandíje de jnūhun jeē yosó núū tútu iī, jiín jnúhun yáha jéē ni cáhān Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Te ná íne Jesús ñuu Jerusalén máá vico pascua, te cuehē ñayuu ni cacandíje i jeē cúu ya Cristo, chi ni cajito i tācá jniñu jéhnu sáha ya jeē steén yā poder yā. ");
INSERT INTO mibNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Te máá Jesús chi tu ní jétáhú yá i, chi je jíní yā ndese cáa ini anuá i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Te tu jíni ñúhún yá jeē cáchi ni ɨɨn ñayuu nuū yā ndese íyó táca ñáyuu, chi máá yá je jíní yā ndese cáa ini anuá i. ");
INSERT INTO mibNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Te ni īyo ɨɨn tēe grupo fariseo, naní de Nicodemo, te cújéhnu de nuū ñáyuu ñuu de hebreo. ");
INSERT INTO mibNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tēe yáha ní quiji de nuū Jesús ɨɨn jecuáā, te ni cahān de jíín yá: Maestro, je cájini na jéē maá Yaā Dios ni tají yá nihín jéē steén ni jnúhun ya nuū na jíjnáhan ná. Chi núu tu íyó Yaā Dios jiín ní, te ma cúu sáha ní ni ɨɨn jniñu jéhnu nájnūhun sáha máá ní jeē steén ni poder ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Te ni cahān Jesús: Jendaá cahán rī jiín ró jeē núu tu nacacu jeé ɨɨn ñayuu, te ma cúu quɨ̄vɨ i ndaha Yaā Dios jeē ndacu ya jniñu nuū i, áchí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Te ni cahān Nicodemo jiín yá: ¿Te ndese cuu nacacu ɨɨn tēe te núu je ni jehnu de? ¿A cuu nucūhun tucu de chīji náná de te nacacu tucu de? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Te ni cahān Jesús: Jendaá cahán rī jiín ró jeē núu tú nacacu ɨɨn ñayuu, te ma cúu quɨ̄vɨ i ndaha Yaā Dios jeē ndacu ya jniñu nuū i. Te jeē nácacu i cúu jeē ndúndoo cuēchi i nájnūhun jíín ndute, te condee Espíritu Santo ini anuá i. ");
INSERT INTO mibNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jeē cácu sáha ñayuu, chi sēhe ñayuu cúu. Te jeē cácu sáha Espíritu yā, chi sēhe ya cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ma náā ni rō cani ni rō ndese cúu jnūhun ni cahān rī jiín ró jeē cánuú jéē nacacu jeé ró jijnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Te tachī chi quée cuahān ndé‑ni cúu nuū cuní maá, te jíni sōho ró jéē cáyu, te tu jíní rō ndé nuū véji ni ndé nuū quihín. Te suni súcuan cúu tāca ñáyuu jeē nácacu sáha Espíritu, chi tu jíní rō ndese sáha ya jniñu ún, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Te ni cahān tucu Nicodemo: ¿Ndese ga cúu núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Te ni cahān Jesús: Máá ró cúu ɨɨn maestro jeē cujéhnu nuū ñáyuu ñuu yō Israel, te ¿á tu jécūhun ni rō jnūhun yáha naún? ");
INSERT INTO mibNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jendaá cahán rī jiín ró jeē jnūhun cájecūhun ni rī cúu jeē cácahān rī jiín ró. Te cánacani cájí rí jnūhun jniñu ní cajito ri. Te tu cácandíje ró jnúhun cácahān rī. ");
INSERT INTO mibNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chi ni cahān rī jnūhun ndese sáha Yaā Dios ini ñayɨ̄vɨ́, te tu cácandíje ró. Núu súcuan ¿te ndese candíje ró núu cahān rī jnūhun tācá ndese sáha ya nde andɨvɨ́? ");
INSERT INTO mibNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Chi ni ɨɨn tu ní cáa andɨvɨ́ jeē cúni ndese íyó yúcuan, chi máñúhún‑ni ruhū, Yaā ní nduu tēe. Chi andɨvɨ́ ndéé rí, te ni cuun ri vēji ri. ");
INSERT INTO mibNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Te nájnūhun ni cata caa Moisés ɨɨn coō cāa nuū ɨɨn yujnu, ná ni cajica ñayuu nuū ñúhun téhé, suni súcuan máá rí, Yaā ní nduu tēe, cánuú jéē cóndita caa ri jicā cruz. ");
INSERT INTO mibNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Te súcuan cánuú návāha tāca ñáyuu jeē candíje i jeē jnáma ri i, ma jnahnú ndetū i, chi sa suhva cotecu i nɨ́ɨ́ cáni andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Chi Yaā Dios yōhyo ni cundáhú ni yā ñayuu ñayɨ̄vɨ́. Jeē yúcuan ní tají yá Sēhe ya ni quiji, vēsú mañúhún‑ni ya iyó, návāha tāca ñáyuu jeē candíje i jeē jnáma ya i, ma jnahnú ndetū, chi sa suhva cotecu i nɨ́ɨ́ cáni andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chi tu ní tájí Yaā Dios Sēhe ya ini ñayɨ̄vɨ jéē snahnú ndetū yā ñayuu, chi sa suhva jeē jnáma ya ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Ñayuu jeē candíje i jeē jnáma ya i, ma jnahnú ndetū i. Te ñayuu tu cándíje, je ni jnahnū ndetū i, chi tu ní cándíje i máá Séhe Yaā Dios, te máá ɨɨn‑ni ya iyó. ");
INSERT INTO mibNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Máá Yaā jeē stíndēé ini anuá ñayuu, je ni quee ya ini ñayɨ̄vɨ́. Te cánujnahan gā ni ñayuu caca i nájnūhun nuū néē vēsú nuū luz yā, chi jniñu cásáha i cúu jniñu néé. Jeē yúcuan cúu jeē jnahnú ndetū ñayuu tu cácandíje ún. ");
INSERT INTO mibNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chi tāca ñáyuu casáha jniñu néé, tu nújnahan cuɨtɨ ni i luz yā. Te tu jéhe i jnūhun jeē stíndēe yá ini anuá i, chi tu cúní i jeē natūu jniñu néé cásáha i. ");
INSERT INTO mibNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Te ñayuu jeē cájica jíín jniñu ndaā, jéhe i jnūhun jeē stíndēe yá ini anuá i, návāha natūu ndijin jeē tācá jniñu cásáha i cúu jniñu cúní Yaā Dios. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yūcuán na te Jesús jiín tée cáscuáha jíín yá, cuahān yā región Judea. Te ni condee yā yūcuán jecu tiempo jiín de, te cáscuándute de ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Te suni scuándute Juan, íne de lugar jeē naní Enón yajni ñuu Salim, chi yūcuan íyó cuéhē ndute. Te ni quijicoo ñayuu nuū de, te ni scuándute de i. ");
INSERT INTO mibNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Súcuan ni sáha Juan nde ná tu quɨ̄vɨ de vecāa. ");
INSERT INTO mibNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yūcuán na te sava tēe cáscuáha jíín Juan yōhyo ni cacahān de jíín sava jnáhan de hebreo sɨquɨ̄ núu ndé ɨɨn cúu modo vāha ga jeē cúchi ñayuu ndundoo i nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Te ni quecoo de nuū Juan, te ni cacahān de: Maestro, tēe ní ine jíín ní yūte Jordán ichi núū cáne niāndii, jeē ní nacani ní jnúhun de nuū ná, vijna te scuándute máá de, te ndɨvii ñayuu cuangoo i nuū de. ");
INSERT INTO mibNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Te ni cahān Juan: Ni ɨɨn tēe ma cúu sáha de jniñu Yaā Dios te núu ma tejníñu ya de. ");
INSERT INTO mibNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Máá ró jijnáhan ró chi ni cajini sōho ró jéē ni cáhān cají rí jeē násūu máá rí cúu Cristo, chi cúu ri ɨɨn jeē ní tají Yaā Dios jeē cósnūú nacani jnūhun jeē quíji ya. ");
INSERT INTO mibNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Te núu cásáha vico quíjnáhan, te máá yɨɨ cúu jeē ndéca ñasɨhɨ́. Te amigo yɨɨ un íne jíín de, te jíni sōho jnūhun cáhán de. Te yōhyo cúsɨɨ̄ ni jíni sōho jnūhun cáhán yɨɨ ún. Te suni súcuan ruhū, chi cúu ri nájnūhun amigo yɨɨ, chi ni quee maá Cristo, te yōhyo cúsɨɨ̄ ni rī jíni sōho ri jnūhun cáhán yā. ");
INSERT INTO mibNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Te jíni ñúhún jéē ndujéhnu ga maá yá te ndululí gá maá rí, achí Juan. ");
INSERT INTO mibNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Te Yaā jeē véji nde andɨvɨ́, cújéhnu ya nuū ndɨhɨ. Chi tāca jéē ní cacu ini ñayɨ̄vɨ yáha, sēhe ñayɨ̄vɨ cúu, te máni jnūhun ñayɨ̄vɨ cáhán. Te Yaā jeē véji ichi ándɨvɨ́, chi cújéhnu ya nuū ndɨhɨ ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Te nácani ya jnūhun jeē ní jito ya jiín jéē ní jini sōho ya. Te ñayuu chi tu cácandíje i jnūhun cáhán yā. ");
INSERT INTO mibNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Te núu ɨɨn ñayuu candíje i jnūhun cáhán yā, suu cúu jeē jejnúhún i jeē Yaā ndaā cúu Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Chi Yaā ní tají Yaā Dios vēji, máni máá jnúhun Yaā Dios cahán yā. Chi Yaā Dios tu yɨ́cuāha jéhe ya Espíritu yā nuū Yaā ní tají yá. ");
INSERT INTO mibNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Máá yá jeē cúu ya Tatá, yōhyo manī yā jiín Séhe ya, te ndɨvii ni jēhe ya ndaha Séhe ya jeē ndacu ya jniñu nuū. ");
INSERT INTO mibNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ñayuu jeē candíje máá Séhe ya jeē jnáma ya i, cotecu i nɨ́ɨ́ cáni andɨvɨ́. Te ñayuu tu cúní candíje Sēhe ya, ma cótecu i nɨ́ɨ́ cáni andɨvɨ́, chi sa suhva cuāha Yaā Dios castigo jeē ndoho i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Te tēe grupo fariseo, ni canihīn de jnūhun jeē iyó cuéhē gā tēe cáscuáha jíín Jesús vēsú jiín Juan, jiín jéē cuehē gā ñayuu scuándute ya vēsú Juan. ");
INSERT INTO mibNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Te nasūu jéē scuándute máá yá, chi tēe cáscuáha jíín yá cúu jeē cascuándute. ");
INSERT INTO mibNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Te ná ni jini Jesús jeē súcuan ni canihīn de jnūhun, te ni quenda ya región Judea, te cuanuhun yā región Galilea. ");
INSERT INTO mibNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Te ichi jeē nuhún yā chi yáha región Samaria. ");
INSERT INTO mibNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Te ni jinū yā ɨɨn ñuu región Samaria jeē naní Sicar, yajni ñuhun jeē ni jéhe Jacob nuū séhe de José nde jenahán. ");
INSERT INTO mibNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Te yūcuan íne pozo jeē naní pozo Jacob. Te ni cucōo Jesús xiin pozo un, chi ni cuīta yá jeē cuahán yā ichi. Te nájnūhun cahuxī uū cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Te ni quee ɨɨn ñahan Samaria, vēji ña vequihin ña ndute. Te ni cahān Jesús jiín ña: Cuāha ní ndute coho ná, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Te tēe cáscuáha jíín yá, chi je cuangoo de nde ñuu, cuacuaan de jeē cáji de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Te ñahan Samaria un ní cahān ña jíín yá: ¿Ndese cúu jeē jicán ni ndute nuū ná coho ní? Chi tēe hebreo cúu ní, te ñahan Samaria cúu ná, áchí ña. Súcuan ni cahān ña, chi ñayuu hebreo tu cácahān i jíín ñáyuu Samaria. ");
INSERT INTO mibNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Te ni cahān Jesús: Núu jeē jiní ni ndese cúní Yaā Dios sáha ya jeē váha níhín, jíín ndé ɨɨn cúu sāña jéē jicán na ndute nuū ní, yūcuán na te máá ní cacān ni núū ná, te cuāha ná ndute jeē cótecu ni nɨ́ɨ́ cáni sáha, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Te ni cahān ña jíín yá: Tátā, yōhyo cúnú pozo yáha, te tú na vé ndahá ní jéē táva ní ndute. Núu súcuan ¿te ndé nuū nihín ni ndute jeē cótecu na sáha? ");
INSERT INTO mibNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Te á cújéhnu ga maá ní vēsú jií yō Jacob, chí naún? Chi máá de ni stóo de pozo yáha nuū yō. Te yāha ní cajihi máá de ndute, jíín táca séhe de, jíín quɨtɨ ndéca de. Achí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Te ni cahān Jesús: Tāca ñáyuu jeē jíhi ndute yáha, chi jichī tucu i. ");
INSERT INTO mibNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Te ñayuu coho ndute jeē cuáha na núū i, chi ma jichí cuɨtɨ gā i. Chi ndute jeē cuáha ná un, cane ini i nájnūhun ndute jeē cáne ñuhún, te sáha jeē cotecu i nɨ́ɨ́ cáni, áchí yá jiín ña. ");
INSERT INTO mibNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Te máá ña tu ní jécūhun ni ña, te ni cahān ña jíín yá: Tátā, cuāha ní ndute ún coho ná, návāha ma jichí cuɨtɨ gā ná, ni tuá jíni ñúhun quiquihin ná ndute pozo yáha, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Te ni cahān Jesús jiín ña: Cuácana ní yɨɨ ní te quiji ní jíín de, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Te ni cahān ña: Tú yɨɨ ná íyó. Te ni cahān Jesús: Ndaā cahán ni jéē tú yɨɨ ní íyó. ");
INSERT INTO mibNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Chi je ni cuu uhūn yɨɨ ní, te tēe ndéca ní vijna chi nasūú yɨɨ ní cúu de. Yāha cúu jeē ni cáhān ndaā ní, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Te jeē súcuan ni cahān yā, te ni cahān ña: Tátā, ɨɨn tēe nácani jnūhun Yaā Dios cúu ní, jéni ni ná. ");
INSERT INTO mibNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tāca jíí na ñáyuu Samaria, yucu yáha ní cachiñúhún i Yaā Dios. Te máá ní ñayuu hebreo, cácahān ni jéē ñuu Jerusalén cúu nuū cánuú chiñúhún yó yā, achí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Te ni cahān Jesús jiín ña: Nánā, candíje ní jnúhun cáhán na, chi quee quɨvɨ̄ jeē ni nasūú yucu yáha ni nasūú ñuu Jerusalén cúu nuū chiñúhún ní maá Yaā cúu Tátá, chi ndɨhɨ‑ni lugar te cuu chiñúhún ní yá. ");
INSERT INTO mibNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Máá ní ñáyuu Samaria tu cájini ni ndé ɨɨn cúu jeē cáchiñúhún ní. Te máá ná jijnáhan ná chi cájini na ndé ɨɨn cúu jeē cáchiñúhún ná. Chi nde nuū maá ná jijnáhan ná ñáyuu hebreo cúu nuū véji Yaā jnama ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Te je ni quee quɨvɨ̄ jeē ñáyuu cáchiñúhún ndáā, vijna te chiñúhún ndije i Yaā cúu Tátá nde jiín ini jiín ánuá i. Chi máá Tátá cúní yā jeē súcuan chiñúhún ñáyuu yā. ");
INSERT INTO mibNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yaā Dios cúu Espíritu, te ñayuu jeē cuní i chiñúhún i ya, cánuú jéē chiñúhún ndije i ya jiín ini jiín ánuá i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Te ni cahān ñahan ún: Jíní na jéē quíji Mesías jeē cúu Cristo, Yaā jeē tají Yaā Dios. Te núu ni quee maá yá, te stéén cají yá tāca jnúhun nuū yō. ");
INSERT INTO mibNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Te ni cahān Jesús: Máá ná jeē cahán jiín ní, suu ná cúu Yaā ún. ");
INSERT INTO mibNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Te sá cáhán gā yā súcuan, te ni ndecoo‑ni tēe cáscuáha jíín yá. Te ni canaa ni de cájito de jeē ndájnūhun yá jiín ñahan yúcuan. Te ni ɨɨn de tu ní cájnūhún de ya núu na vé cájnūhun yá ña chí na vé ndájnūhun yá jiín ña. ");
INSERT INTO mibNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yūcuán na te ñahan un ní stóo ña quɨ̄yɨ ña, te cuahān ña nde ñuu. Te ni cahān ña jíín ñáyuu ún: ");
INSERT INTO mibNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Nehen na quíngoo yó te coto ró ɨɨn tēe jeē ní cachi ndɨhɨ tāca jéē ni sáha ri. Sanaa te máá yá cúu Cristo, jeē cándetu yó quiji, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yūcuán na te ni quendacoo i ñuu ún, te cuangoo i nuū íne Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Te nde ná tu jinūcoo i, te tēe cáscuáha jíín yá ni cacahān ndahú de jíín yá: Maestro, caji ni stáā víī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Te ni cahān yā jiín de: Iyó stáā caji rī jeē tu cájini rō ndese cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yūcuán na te tēe cáscuáha jíín yá, ni cacajnūhun jnáhan de: ¿A ní quindeca ɨɨn ñayuu jeē ní yeji yā, chí naún? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Te ni cahān Jesús: Jeē ní cachi rī jeē iyó jéē cáji rī cúu jeē cúsɨɨ̄ ni rī sáha ri jniñu cúní Yaā ní tají rúhū vēji ri, jiín jéē sínu ri jniñu ún. ");
INSERT INTO mibNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Te cácahān rō jeē cúmanī cuūn gā yoō te tahndē trigo. Te ruhū chi cáhán rī jiín ró: Condēhe jíjnáhan ró, chi ñayuu cuehē cácuu i nájnūhun trigo jeē jé ni cuaan jeē tahndé, chi je cáhīyo tūhva i candíje i ruhū. ");
INSERT INTO mibNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Te tēe scándíje ñayuu cácuu de nájnūhun tēe cájehnde trigo, te nihīn de yāhu de. Te jeē cánastútú de ñayuu cúu jeē cótecu i nɨ́ɨ́ cáni andɨvɨ́. Te tēe cáscuíté núu jnūhun ri, ɨnuú‑ni cusɨɨ̄ ni de jíín tée cástéén gā jnūhun ri. ");
INSERT INTO mibNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chi ndaā cúu jnūhun jeē cahán: Ɨɨn tēe jéte, te ɨnga tēe nástútú, áchí. ");
INSERT INTO mibNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Te suu cúu jeē ní tají rí rohó jíjnáhan ró jéē scándíje ró ñayuu jeē jé ni canihīn jnūhun ya ni casáha ɨnga tēe. Chi ɨnga tēe je ni canacani de jnūhun nuū ñáyuu, te máá ró chi nájnūhun cánastútú ró i cúu jeē scándíje ró i. ");
INSERT INTO mibNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Te cuehē ñayuu Samaria jeē cáyūcú ñuu ún, ni cacandíje i Jesús jeē ní jini sōho i jnūhun ni cahān ñahan ún. Chi ni cahān ña: Ni cachi ya ndɨhɨ tāca jéē ni sáha ri. ");
INSERT INTO mibNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Te jeē yúcuan cúu jeē ñayuu Samaria un ní jinūcoo i nuū yā, te ni cacahān ndahú i jíín yá jeē na quéndōo ya ñuu i. Te ni ndōo ya yūcuan úū quɨvɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Te cuehē gā i ni cacandíje i ya jiín jnúhun cáhán maá yá. ");
INSERT INTO mibNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Te ni cacahān i jíín ñahan ún: Tuá niní jéē cahán maá ró te candíje ri yā, chi je ni cajini sōho ri jnūhun cáhán maá yá. Te cájini yō jeē maá yá cúu ndije Cristo, Yaā jnama ñayuu ñayɨ̄vɨ́. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Te nuū ni yáha uū quɨvɨ̄ ún, te Jesús ni quenda ya Samaria, te ni quihin tucu ya ichi cuanuhun yā región Galilea. ");
INSERT INTO mibNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Chi je ni cahān maá yá jeē tée cánacani jnūhun Yaā Dios, tu cáhīyo yɨ́ñúhún ñáyuu ñuu de jíín de, te suni súcuan ni cuu jíín máá yá. ");
INSERT INTO mibNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Te ná ni najinū yā Galilea, te ñayuu un ní cajetáhú i ya, chi suni máá i ni jengoo i vico pascua ñuu Jerusalén, te ni cajito i tācá jniñu ní sáha ya quɨvɨ̄ ni íyo vico ún. ");
INSERT INTO mibNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yūcuán na te ni jehēn tucu ya ñuu Caná ndañúū Galilea, nuū ni sáha ya jeē ndúte ni nduu vino. Te ini ñuu Capernaum ni īyo ɨɨn tēe cújéhnu jeē ndíso jníñu nuū rey. Te cúhú sēhe de. ");
INSERT INTO mibNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tēe un ní jini jnūhun de jeē ní najinū Jesús región Galilea jeē ni jéhēn yā región Judea. Te ni jecondēhé de ya, te ni cahān ndahú de jíín yá jeē na quíhín yā jiín de vehe de, te nasávāha ya sēhe de, chi je yajni cuu i. ");
INSERT INTO mibNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Te ni cahān Jesús jiín de: Núu tú coto ró jniñu jéhnu jeē náā ni rō sáha, te ma candíje cuɨtɨ rō jijnáhan ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Te tēe ndíso jníñu nuū rey, ni cahān de: Cava vāha ni ní na quíhín yō, chi núu cucuéé ní te cuu sēhe ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yūcuán na te ni cahān Jesús: Cuánuhun vehe ró, chi cotecu sēhe ró. Te tēe un ní candíje de jnūhun ni cahān Jesús, te cuanuhun‑ni de. ");
INSERT INTO mibNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Te níní jíca de cuanuhun de vehe de, te ni quijicoo mozo de ni caquijnahan i de, te ni cacahān i: Je ni nduvāha sēhe ní, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Te ni cajnūhún de na hora ni quejéé ndúvāha i. Te ni cacahān i jíín de: Cahɨɨn jeē ícu ni quenda quīji i. ");
INSERT INTO mibNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yūcuán na te máá tátá i ni sáha de cuenta jeē hora un cúu jeē ni cáhān Jesús jiín de jeē cótecu sēhe de. Te ni candíje de jíín nɨ́ɨ́ vehe de jeē cúu ya Yaā ní tají Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yāha cúu vuelta uū jeē ni sáha Jesús jniñu jéhnu jeē ni stéén yā poder yā región Galilea, jeē ní najinū yā jeē ni jéhēn yā región Judea. ");
INSERT INTO mibNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yūcuán na te cuahān tucu Jesús ñuu Jerusalén, chi íyó tucu vico cásáha jnáhan ñuu yā hebreo. ");
INSERT INTO mibNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Te Jerusalén iyó ɨɨn pila ndute yajni yéhyɨ́ jéē naní yéhyɨ́ lanchi. Te yuhu hebreo naní Betesda. Te nuū íne pila un íyó úhūn corredor. ");
INSERT INTO mibNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Te ini tācá corredor un cácāa cuehē ñayuu cácuhū, jeē cuaá, jeē chacuá, jeē ni íjin. Te cándetu i jeē canda ndute ún. ");
INSERT INTO mibNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Chi íyó quɨ́vɨ̄ jeē cúun ɨɨn ndajéhé yā ini pila un, te scánda ya ndute. Te ñayuu quɨ́vɨ xīhna gā ini pila un ná scánda ya ndute, te ndúvāha i na‑ni cuehyɨ̄ ndóho i. ");
INSERT INTO mibNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Te yūcuan íyó ɨɨn tēe jeē ní cuu ocō xahūn unī cuiyā cuhú de. ");
INSERT INTO mibNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Te ni jito Jesús jeē catú de, te ni jini yā jeē ní cuu cuehē cuiyā cuhú de. Te ni cahān yā jiín de: ¿A cúní rō nduvāha ró? áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Te ni cahān tēe cúhú un jíín yá: Tu níhín na ni ɨɨn tēe squɨ́vɨ sāñá ini pila hora jeē cánda ndute. Chi tāca jínu jeē cuní na quɨ́vɨ ná, te quɨ́vɨ‑ni ɨnga ñayuu xīhna gā. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Te ni cahān Jesús: Ndocuɨñɨ̄ te naquihin ró camilla rō te caca ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Te tēe un ní nduvāha‑ni de. Te ni naquihin de camilla de, te ni quejéé de jíca de. Te quɨvɨ̄ ndétātu cúu quɨvɨ̄ ún. ");
INSERT INTO mibNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yūcuán na te jnáhan de tēe hebreo un ní cacahān jiín de: Quɨvɨ̄ ndétātu cúu vijna. Te áchí ley jeē ma cúu condiso ró camilla rō. ");
INSERT INTO mibNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Te ni cahān tēe ni nduvāha ún: Tēe ni nasávāha ruhū, ni cahān de jíín rí jeē náquihin ri camilla rī te caca ri, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yūcuán na te ni cacajnūhún un de: ¿Ndé tée ni cahān jiín ró jeē náquihin ró camilla rō te caca ró? ");
INSERT INTO mibNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Te tēe ni nduvāha ún, tu jíní de ndé ɨɨn cúu jeē ní nasávāha de. Chi cáhīin cuehē ñayuu yūcuán, te Jesús je cuahān yā. ");
INSERT INTO mibNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Te cúcuéé gá te ni najnáhan Jesús jiín de ini templo cáhnu. Te ni cahān yā: Vijna chi je ni nduvāha ró. Ma sáha ga rō cuēchi, chi núu tuú, te quiji ɨɨn jnūndóho xeēn gā sɨquɨ̄ rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yūcuán na te cuahān tēe ún, te ni castūhún de nuū jnáhan de hebreo un jéē Jesús cúu jeē ní nasávāha ya de. ");
INSERT INTO mibNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Te sɨquɨ̄ jeē ní sáha Jesús jniñu yáha quɨ́vɨ̄ ndétātú, jeē yúcuan cúu jeē tée hebreo un cájito xeēn de ya, te cácuni de cahni de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Te ni cahān Jesús jiín de: Máá Tátá rī chi nɨ́ɨ́ cáni te nde vijna sáha ya jniñu váha, te suni súcuan ruhū sáha ri jniñu váha. ");
INSERT INTO mibNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Te sɨquɨ̄ jeē ni cáhān yā súcuan, te tēe hebreo un víhyá gā cácuni de cahni de ya. Chi nasūu máá ɨɨn‑ni jeē tu squícu ya jeē cahán ley sɨquɨ̄ quɨvɨ̄ ndétātú, chi suni jeē ni cáhān yā jeē Tatá yā cúu Yaā Dios, te súcuan sáha ɨnuú yá maá yá jiín Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Te ni cahān Jesús: Jendaá cahán rī jiín ró jijnáhan ró: Ruhū jeē cúu Sēhe Yaā Dios, tú na vé cúu sáha ri jeē maá rí, chi máni sáha ri jeē jíto ri sáha Tátá rī. Chi tāca jéē sáha Tátá rī, suni sáha ruhū jeē cúu ri Sēhe ya. ");
INSERT INTO mibNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Chi máá Tátá rī, manī yā jiín ruhū jeē cúu ri Sēhe ya, te stéén yā nuū rī ndɨhɨ jeē sáha ya. Te jéhnu ga jniñu stéén yā vēsú jeē ní cuu vijna, jeē naa ni rō coto ró jíjnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Te nájnūhun jeē nastécu maá Tátá rī ndɨ̄yɨ te cotecu tucu i, suni súcuan ruhū jeē cúu ri Sēhe ya, nástécu rī ndé‑ni cúu jeē cuní maá rí. ");
INSERT INTO mibNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Te máá Tátá rī, tu sándaā yā sɨquɨ̄ ni ɨɨn ñayuu, chi ni jēhe ya jnūhun jeē sándaā maá rí sɨquɨ̄ tāca ñáyuu, chi Sēhe ya cúu ri. ");
INSERT INTO mibNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Te súcuan te coo yɨ́ñúhún ndɨhɨ ñayuu nuū rī, nájnūhun yɨ́ñúhún i nuū Tatá rī. Te ñayuu tu íyó yɨ́ñúhún núū rī, núu súcuan te suni tu yɨ́ñúhún i nuū maá Tátá rī jeē ní tají yá ruhū vēji ri. ");
INSERT INTO mibNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Jendaá cahán rī jiín ró: Núu ɨɨn ñayuu chuhun ni i jnūhun cáhán rī, te candíje i jeē Yaā ndaā cúu Yaā ní tají rúhū vēji ri, ñayuu ún cotecu i nɨ́ɨ́ cáni andɨvɨ́, te ma jnahnú ndetū i. Chi ma cúu ga i nájnūhun ndɨ̄yɨ, chi sa suhva cotecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Jendaá cahán rī jiín ró jeē quiji quɨvɨ̄, te vijna je ni quejéé, jeē tāca ñáyuu cácuu nájnūhun ndɨ̄yɨ, cuni nahín i jnūhun cáhán ruhū, Sēhe Yaā Dios. Te ñayuu cuatáhú, chi cotecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Chi nájnūhun íyó poder maá Tátá rī jeē sáha ya jeē técu ndɨhɨ‑ni, suni súcuan ni jēhe ya poder nuū ruhū jeē sáha ri jeē cotecu ndɨhɨ‑ni. ");
INSERT INTO mibNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Te suni ni sáha ya jeē ndíso jníñu ri sándaā rī sɨquɨ̄ ñayuu, chi cúu ri Yaā ní nduu tēe. ");
INSERT INTO mibNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma náā ni rō cani ni rō sɨquɨ̄ jnúhun cáhán rī. Chi quee quɨvɨ̄ jeē tāca ndɨ́yɨ cuni sōho i jnūhun cahān rī, ");
INSERT INTO mibNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","te quendacoo i nuū yɨ́ndūji i. Te ndɨ̄yɨ jeē ní casáha jniñu váha, natecu i jeē cótecu i nɨ́ɨ́ cáni. Te ndɨ̄yɨ jeē ní casáha jniñu néé, natecu i te quɨ̄vɨcoo i nuū jnahnú ndetū i. ");
INSERT INTO mibNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Tú na vé cúu sáha ri jeē maá rí. Chi nájnūhun ndácu Yaā Dios jniñu nuū rī, súcuan sándaā rī jniñu. Te ndaā sándaā rī, chi tu sáha ri jeē cuní maá rí, chi sáha ri jeē cuní maá Tátá rī, Yaā ní tají rúhū vēji ri. ");
INSERT INTO mibNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Núu ruhū cahān rī jeē cúu ri Sēhe Yaā Dios, te cachi ñayuu jeē tu jéjníñu jnūhun cáhán rī. ");
INSERT INTO mibNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Te íyó ɨnga jeē cahán jeē cúu ri Sēhe ya. Te jíní rī jeē jnúhun un jéē cahán yā, chi níhín jníñu. ");
INSERT INTO mibNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Máá ró ni catají ró tēe ni cacajnūhún de Juan. Te Juan chi ndaā ni cahān de jnūhun ri. ");
INSERT INTO mibNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Te vēsú súcuan te nasūu rúhū cúu jeē jíni ñúhún jeē steén ɨɨn tēe jeē Séhe Yaā Dios cúu ri. Chi máá ró cúu jeē jíni ñúhún návāha candíje ró te cācu ró jíjnáhan ró. Jeē yúcuan ní cahān rī jeē iyó ndáā jnūhun ri jeē ní nacani Juan. ");
INSERT INTO mibNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Máá Juan ni cuu de nájnūhun ɨɨn lámpara jeē cayú te cúndijin, cúu jeē ní nacani de jnūhun ri. Te máá ró, jecu‑ni quɨvɨ̄ ni canujnahan ni rō jeē ni stéén de nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Te íyó jéē steén cají gá jeē cujéhnu ri vēsú jeē ni cáhān Juan. Suu jniñu sáha ri, jniñu jeē ní tejníñu Tátá rī ruhū jeē sáha ri, jniñu un stéén ndije jeē maá yá ni tají rúhū vēji ri. ");
INSERT INTO mibNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Te Tátá rī jeē ní tají yá ruhū vēji ri, suni máá yá cahán nuū tútu iī jeē cujéhnu ri, vēsú tu ní cájini sōho cuɨtɨ rō jeē cahán yā, ni tu ní cájito ró yá. ");
INSERT INTO mibNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Te tu ní cáchuhun ni rō jnūhun un jéē ni cáhān Tatá rī, chi tu cácandíje ró rúhū, Yaā ní tají yá vēji. ");
INSERT INTO mibNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Cánanducú vii rō tāca jnúhun cáhán tutu iī, chi cájeni ni rō jeē yūcuan níhīn rō jnūhun jeē cótecu rō nɨɨ́ cáni sáha. Te jnūhun sɨquɨ̄ maá rí cúu jeē cahán tutu ún. ");
INSERT INTO mibNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Te vēsú súcuan te tu cácuni rō cuatáhú ró ruhū quɨ̄vɨcoo ró ndaha ri návāha cotecu rō nɨɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Tu chíhi ri cuenta jnūhun jeē cácahān ñayuu jeē cujéhnu ri. ");
INSERT INTO mibNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Chi je jíní rī ndese cándāa ánuá rō jeē tu cáhīyo manī rō jiín Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ruhū vēji ri jiín jniñu cúní Tatá rī, te tu cájetáhú ró ruhū. Te núu ɨnga tēe quee de jíín jniñu cúní maá de, sa tēe un yáchī cuatáhú ró de. ");
INSERT INTO mibNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Ndese cuu candíje ró jíjnáhan ró? Chi máni cácuni rō jeē cujéhnu ró sáha jnáhan ró, te tu cánducú ró jeē cujéhnu ró sáha Yaā Dios, jeē maá ɨɨn‑ni ya iyó. ");
INSERT INTO mibNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma cáni ni rō jeē cáquin rī cuēchi sɨquɨ̄ rō nuū Tatá rī. Chi íyó ɨɨn jeē cáquin cuēchi sɨquɨ̄ rō, suu Moisés, tēe jeē cáñuhun ni rō jeē quendōo ndaā rō jiín ley jeē ní tee de. ");
INSERT INTO mibNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Chi núu ní cácandíje ró jéē ní tee Moisés, te suni candíje ró rúhū nuú, chi jnūhun máá rí ni tee de. ");
INSERT INTO mibNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Te núu tu cácandíje ró jnúhun ri jeē ní tee de, ¿te ndese candíje ró jnúhun cáhán maá rí núu súcuan? Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yūcuán na te cuahān Jesús ɨnga lado mar Galilea, jeē cúu mar Tiberias. ");
INSERT INTO mibNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Te yōhyo cuehē ñayuu ni candiquīn i ya, chi ni cajito i tācá jniñu jéhnu jeē steén yā poder yā jeē ní nasávāha ya ñayuu cácuhū. ");
INSERT INTO mibNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Te ni caa ya ɨɨn yucu, te ni cucōo ya yūcuan jíín tée cáscuáha jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Te je ni cuyajni vico pascua jeē cánucūhun ni jnáhan ñuu yā hebreo jeē ní cacācu i nuū ñáyuu nación Egipto. ");
INSERT INTO mibNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Te ni ndacoto ya, te ni jito ya jeē véjicoo cuehē ndasɨ́ ñáyuu. Te ni cahān yā jiín Felipe: ¿Ndé nuū cuaan yó jéē cáji ñayuu yáha jíjnáhan i? ");
INSERT INTO mibNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Te súcuan ni cahān yā jeē jíto ndee yā de núu ndese cahān de. Chi je jíní maá yá ndese sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Te ni cahān Felipe jiín yá: Te ni ma cánda uū ciento denario staā, ni vēsú jeē cáji i jecu jecu jijnáhan i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yūcuán na te ni cahān Andrés, ñani Simón Pedro, ɨnga tēe scuáha jíín yá un: ");
INSERT INTO mibNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Yāha íne ɨɨn sūchi yɨ́ɨ́ jéē ndíso i uhūn staā cebada jiín úū chācá. ¿Te ndé canda cuɨtɨ ún, chi ñayuu cuehē ndasɨ́ cúu? ");
INSERT INTO mibNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yūcuán na te ni cahān Jesús: Cahān jiín ñáyuu na cúcōo i, áchí yá. Te yūcuan cáa cuehē ite, te ni cacucōo i, te nájnūhun uhūn mil tēe cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Te ni quihin Jesús staā ún, te ni nacuatáhú yá nuū Yaā Dios. Te ni jēhe ya nuū tée cáscuáha jíín yá, te máá de ni casaja de nuū ñáyuu ní cacucōo ún. Te suni súcuan ni sáha ya jiín cháca, te ni cayeji i nasaa cácuni maá i. ");
INSERT INTO mibNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Te nuū ní candutú chíji i, te ni cahān yā jiín tée cáscuáha ún: Nastútú ró tācá pedazo jeē ni ndóo, návāha tu stɨ́vɨ cuɨtɨ yō. ");
INSERT INTO mibNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Te ni canastútú de, te ni chitú úxī uū jīca pedazo jeē ni ndóo sɨquɨ̄ ndɨhúhún staā cebada un jeē tuá ni ndɨ́hɨ caji ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Te ñayuu un ní cajito i jniñu jéhnu ni sáha Jesús jeē ni stéén yā poder yā. Te ni cacahān i: Jendaá ndije jeē tée yáha cúu jeē cahán tutu jeē quíji ini ñayɨ̄vɨ jéē nácani jnūhun Yaā Dios. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Te ni jini Jesús jeē cácuni i sáfuerza i ya jeē cuu ya rey i núú. Te ni cujiyo tucu máá ɨɨn‑ni ya, ni caa ya cuahān yā nuū sucún gá yucu. ");
INSERT INTO mibNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Te nuū cuácuaa, te tēe cáscuáha jíín yá ni nanuu de cuangoo de nde mar. ");
INSERT INTO mibNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Te ni ndɨ̄vɨcoo de ini barco, te ni cascáca de jeē quíngoo de nde ɨnga lado mar nde ñuu Capernaum. Te je ni cunee, te ná tu ndee Jesús nuū de. ");
INSERT INTO mibNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yūcuán na te ni jequɨ̄hɨ ɨɨn tachī níhin, te sáha jeē ndónda ndute mar un. ");
INSERT INTO mibNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Te jeē ní cuu nájnūhun uhūn chí íñū kilómetro cájica de jíín barco, te ni cajito de jeē jíca Jesús nuū mar, te ni cuyajni ya vēji ya nuū barco. Te ni cayūhú de. ");
INSERT INTO mibNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Te máá yá ni cahān yā jiín de: Máá rí cúu. Ma yūhu ró jijnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Te ni cacusɨɨ̄ ni de jeē na quɨ́vɨ ya ini barco. Te ni sáha ya jeē yachī‑ni ni jinūcoo‑ni de ñuhun íchi núū cuángoo de ún. ");
INSERT INTO mibNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Te ɨnga quɨvɨ̄ ún, te ñayuu jeē ní caquendōo ɨnga lado mar, ni cajini i jeē tée cáscuáha jíín yá cuangoo de jíín máñúhún‑ni barco ni íne yūcuán, jíín jéē tu ní quɨ́vɨ Jesús quihīn yā jiín de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Te sava ga barco jeē véjicoo ichi ñúū Tiberias, ni quecoo yajni lugar nuū ní cayeji i staā jeē ní nacuatáhú máá Jítoho yō jehē. ");
INSERT INTO mibNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Te jeē ní cajito ñayuu un jéē tuá Jesús íne ya yūcuán, ni tēe cáscuáha jíín yá, te ni quɨ̄vɨcoo i tāca barco un, te cuangoo i ñuu Capernaum cuananducú i ya. ");
INSERT INTO mibNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Te nuū ni jínūcoo i nde ɨnga lado mar, te ni nanihīn jnáhan i jíín Jesús. Te ni cacajnūhún i ya: Maestro, ¿na hora ni quee ni yáha? ");
INSERT INTO mibNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Te ni cahān Jesús: Jendaá cahán rī jiín ró jeē cánanducú ró ruhū sɨquɨ̄ jeē ní cayeji rō nde ni candutú chíji ró, te nasūu sɨ́quɨ̄ jeē ní cajito ró táca jniñu jéhnu jeē steén rī poder rī. ");
INSERT INTO mibNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ma cóndɨhvɨ̄ ni rō maá sɨ́quɨ̄ jeē caji rō jeē yachī nataxīn, chi sa suhva condɨhvɨ̄ ni rō sɨquɨ̄ jeē nihín rō jeē cótecu rō nɨɨ́ cáni sáha. Te máá rí, Yaā ní nduu tēe, cuāha ri nájnūhun staā jeē cótecu rō nɨɨ́ cáni sáha. Chi Tátá rī Yaā Dios ni jeni ya ruhū jeē sáha ri súcuan. Achí yá jiín i. ");
INSERT INTO mibNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yūcuán na te ni cacajnūhún i ya: ¿Ndese sáha ná návāha squícu ná jniñu cúní Yaā Dios? ");
INSERT INTO mibNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Te ni cahān Jesús: Jniñu jeē cuní Yaā Dios cúu jeē candíje ró rúhū, Yaā ní tají yá vēji. ");
INSERT INTO mibNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yūcuán na te ni cacahān i: Núu súcuan ¿te na jniñu jéhnu sáha ní coto ná jíjnáhan ná te candíje ná jéē ní tají yá nihín? ¿Na jniñu cúu jeē sáha ní? ");
INSERT INTO mibNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chi tāca jíí yō jenahán ni cayeji de maná jeē ní cuun ichi ándɨvɨ́ ndé nuū ñúhun téhé, nájnūhun yósó núū tútu: Yaā Dios ni jēhe ya staā ni cuun ichi ándɨvɨ́, ni cayeji i, áchí tutu. Achí i jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Te ni cahān Jesús: Jendaá cahán rī jiín ró: Nasūú Moisés ni jéhe staā un núū de jíjnáhan de jeē ní cuun ichi ándɨvɨ́, chi máá Tátá rī ni jēhe. Te máá yá jéhe staā andɨvɨ́ jéē cótecu rō nɨɨ́ cáni sáha. ");
INSERT INTO mibNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chi staā jéhe Yaā Dios cúu máá Yaā ní quiji ichi ándɨvɨ́, te sáha ya jeē ñáyuu ñayɨ̄vɨ́ cotecu i nɨ́ɨ́ cáni andɨvɨ́. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Te ni cacahān i jíín yá: Níní cuáha ni stáā ún caji na núu súcuan. ");
INSERT INTO mibNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Te ni cahān Jesús: Máá rí cúu máá stáā jeē cótecu rō nɨɨ́ cáni sáha. Ndé vé quɨ́vɨ ndaha ri, ma cúū cuɨtɨ gā sōco. Te ndé vé candíje ruhū, ma jichí cuɨtɨ gā. ");
INSERT INTO mibNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Te nájnūhun je ni cahān rī jiín ró, tu cácandíje ró rúhū, vēsú ni cajito ró núū rī. ");
INSERT INTO mibNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tāca ñáyuu jeē sáha Tátá rī jeē candíje i ruhū, máá i quɨ́vɨcoo ndaha ri. Te jétáhú rí tāca jéē cuní quɨ̄vɨ ndaha ri, chi ma squéhichī cuɨtɨ rī quihīn. ");
INSERT INTO mibNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Chi ni quiji ri ichi ándɨvɨ́ návāha sáha ri jniñu jeē cuní Yaā ní tají rúhū, te nasūu jéē sáha ri jeē cuní maá rí. ");
INSERT INTO mibNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Te jniñu jeē cuní Tatá rī, Yaā ní tají rúhū, cúu jeē ma scuíta ri ni ɨɨn ñayuu ni jéhe ya nuū rī, chi condito ri i te nastécu rī i quɨvɨ̄ jínu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Te Yaā ní tají rúhū, cuní yā jeē tāca ñáyuu jeē nihín i jnūhun ruhū, Sēhe Yaā Dios, te candíje i ruhū, cotecu i nɨ́ɨ́ cáni andɨvɨ́. Chi nastécu rī i quɨvɨ̄ jínu ñayɨ̄vɨ́. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yūcuán na te ni caquejéé jnáhan ñuu yā hebreo cácahān de sɨquɨ̄ yā, chi ni cahān yā jeē maá yá cúu staā ní quiji ichi ándɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Te ni cacahān de: ¿A násūu tée yáha cúu Jesús, sēhe José? Te cájini yō tatá de náná de. ¿Te ndese cúu jeē cahán de jeē ni quíji de ichi ándɨvɨ́ núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Te ni cahān Jesús jiín de: Ma cahán rō sɨquɨ̄ rī jijnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni ɨɨn ñayuu ma cúu quɨ̄vɨ i ndaha ri núu ma sáha Tátá rī jeē cúu ni i quɨ̄vɨ i, chi máá yá ni tají rúhū vēji ri. Te nastécu rī i quɨvɨ̄ jínu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Te suhva yósó núū tútu ni catee tēe ni canacani jnūhun Yaā Dios: Tācá i chi stéén Yaā Dios nuū i, áchí. Núu súcuan te tāca ñáyuu jíni sōho jnūhun cáhán Tatá rī, te jétáhú i jeē steén yā nuū i, ñayuu ún chi quɨ́vɨcoo i ndaha ri. ");
INSERT INTO mibNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Te tu ní jíto ni ɨɨn ñayuu nuū maá Tátá rī. Chi máñúhún‑ni ruhū ni jito ri nuū yā, chi nde nuū maá yá vēji ri. ");
INSERT INTO mibNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jendaá cahán rī jiín ró jijnáhan ró jéē ñayuu jeē candíje i jeē jnáma ri i, máá i cotecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Máá rí cúu staā jeē cótecu rō nɨɨ́ cáni sáha. ");
INSERT INTO mibNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tāca jíí rō jenahán, ni cayeji de staā maná jeē ní cuun ichi ándɨvɨ́ ndé nuū ñúhun téhé, te tu ní sáha jeē cótecu de nɨ́ɨ́ cáni andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Te staā jeē cahán rī jeē véji ichi ándɨvɨ́, chi na‑ni ñayuu caji, te cotecu i nɨ́ɨ́ cáni andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Te suu máá rí cúu staā un jéē ní quiji ichi ándɨvɨ́ jéē sáha jeē cótecu rō nɨɨ́ cáni. Te ñayuu jeē cáji staā yáha, cotecu i nɨ́ɨ́ cáni andɨvɨ́. Te staā jeē cuáha ri un cúu yɨquɨ cúñu rī, te cuāha ri návāha ñayuu ñayɨ̄vɨ́ cotecu i nɨ́ɨ́ cáni andɨvɨ́. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yūcuán na te jnáhan ñuu yā hebreo ni cacahān de jíín táca jnáhan de: ¿Ndese cuu cuāha tēe yáha yɨquɨ cúñu de caji yō? achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Te ni cahān Jesús jiín de: Jendaá cahán rī jiín ró: Núu tú candíje ró jéē yɨquɨ cúñu ruhū, Yaā ní nduu tēe, cúu nájnūhun staā, te nɨñɨ̄ rī cúu nájnūhun ndute, núu súcuan te ma cótecu rō nɨɨ́ cáni andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Chi ñayuu cácandíje jeē yɨquɨ cúñu rī cúu nájnūhun staā te nɨñɨ̄ rī cúu nájnūhun ndute, máá i cotecu i nɨ́ɨ́ cáni. Te nastécu rī i quɨvɨ̄ jínu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chi yɨquɨ cúñu rī jiín nɨ́ñɨ̄ rī cúu ndije jeē sáha jeē cótecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Te ñayuu cácandíje jeē yɨquɨ cúñu rī jiín nɨ́ñɨ̄ rī cúu nájnūhun staā jiín ndute jeē cótecu i nɨ́ɨ́ cáni sáha, máá i níní ndúú i jíín rí, te ndúú rí jiín i. ");
INSERT INTO mibNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Máá Tátá rī, Yaā técu, ni tají yá ruhū vēji ri, te técu rī sáha máá yá. Te suni súcuan, ñayuu cácandíje jeē cúu ri nájnūhun staā i ndute i, suni súcuan cotecu i nɨ́ɨ́ cáni sáha ri. ");
INSERT INTO mibNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Máá rí cúu staā ní quiji ichi ándɨvɨ́. Te staā jeē cahán rī tu cúu nájnūhun staā maná jeē ní cayeji tāca jíí rō jenahán, chi tu ní sáha jeē cótecu de nɨ́ɨ́ cáni. Te staā jeē cahán rī, chi ñayuu caji, cotecu i nɨ́ɨ́ cáni sáha, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tāca jnúhun yáha ní steén Jesús nuū ñáyuu ní candutútú ini vehe iī sinagoga ñuu Capernaum. ");
INSERT INTO mibNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Te cuehē ñayuu cascuáha jíín yá, ni cajini sōho i jnūhun yáha jéē ni stéén yā. Te ni cacahān maá i: Yōhyo yɨɨ́ jnúhun cáhán yā yāhá. ¿Ndese cuu cuatáhú yó? ");
INSERT INTO mibNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Te ni jini Jesús jeē cácahān i jeē yɨɨ́ cúu jnūhun yāhá, te ni cahān yā jiín i: ¿A yɨɨ́ sáha jnūhun yáha jíín ró jijnáhan ró? ");
INSERT INTO mibNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Te ndese sáha ró núu coto ró jéē ruhū, Yaā ní nduu tēe, ndaa ri nuhun rī nuū ni cóndee rī xīhna ñúhún? ");
INSERT INTO mibNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Máá ánuá ñayuu cúu jeē sáha jeē técu i. Chi yɨquɨ cúñu i tu jéjníñu cuɨtɨ súcuan. Te tāca jnúhun ni cahān rī jiín ró cúu jeē quéndōo vāha ánuá rō, te cotecu rō nɨɨ́ cáni sáha. ");
INSERT INTO mibNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Te sava ró chi tu cácandíje ró. Achí yá. Chi nde xīhna ñúhún je jíní Jesús ndé‑ni cúu ñayuu jeē ma cándíje, jíín ndé ɨɨn de cúu jeē nastúu de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Te ni cahān gā yā: Jeē yúcuan ní cahān rī jiín ró jeē ma cúu quɨ̄vɨ ni ɨɨn ñayuu ndaha ri, te núu tu sáha Tátá rī jeē cúu ni i quɨ̄vɨ i, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Te nde quɨvɨ̄ ún te cuehē ñayuu cascuáha jíín yá, ni castóo i ya, te tuá ni cájica i jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yūcuán na te ni cahān yā jiín máá ndɨhúxí uū tēe cáscuáha jíín yá: ¿A suni cácuni máá ró quingoo ró, chí naún? ");
INSERT INTO mibNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Te ni cahān Simón Pedro: ¿Ndé núū gā quingoo ná? Chi máá ní cúu jeē nácani jnūhun jeē cótecu na nɨ́ɨ́ cáni sáha. ");
INSERT INTO mibNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Te ni cacandíje ná te cájini na jéē maá ní cúu Cristo, Sēhe Yaā Dios, Yaā técu, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Te ni cahān Jesús: Te vēsú ni nacāji ri ndɨhúxí uū rō, te íyó ɨɨn ró jeē ní quɨ̄vɨ jexeén ini. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Te súcuan ni cahān yā sɨquɨ̄ Judas Iscariote, sēhe Simón. Chi máá de nastúu de ya, vēsú ɨɨn jnáhan jeē uxí uū tēe cáscuáha jíín yá cúu de. ");
INSERT INTO mibNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yūcuán na te jíca cuu Jesús región Galilea. Chi tu cúní yā caca cuu ya región Judea, chi jnáhan ñuu yā hebreo jeē cáyūcu yúcuan, cácuni de cahni de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Te cuacuyajni vico jeē casáha ñayuu yā hebreo vehe ramádá, cáyūcú i chīji. ");
INSERT INTO mibNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Te ñani yā ni cacahān de jíín yá: ¿Naun máá yáha‑ni íne ró? ¿Naun tú quihīn rō región Judea, návāha tēe yūcuan jéē cácandíje de róhó, suni coto de jniñu jéhnu sáha ró. ");
INSERT INTO mibNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Chi núu cúní ɨɨn tēe jeē cuité núu jnūhun de, te tu sáha yuhu de jniñu. Te núu sáha nde ró táca jniñu jéhnu, vāha ga na sáha ró jéē cúni ndɨvii ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Súcuan ni cacahān ñani yā jiín yá, chi ni máá de tu cácandíje de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yūcuán na te ni cahān Jesús: Ná tu quee maá quɨ́vɨ̄ jeē quihín rī. Te máá ró jijnáhan ró chi na‑ni quɨvɨ̄‑ni te cuu quingoo ró. ");
INSERT INTO mibNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Chi ma quɨtɨ́ ni ñayuu ñayɨ̄vɨ núū rō, te máá rí chi quɨ́tɨ́ ni i jíto i ruhū, chi cáhán rī jeē jiní rī jeē máni jniñu néé cásáha i. ");
INSERT INTO mibNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cuángoo máá ró vico ún. Te máá rí chi ma quihín rī vijna, chi ná tu quee maá quɨ́vɨ̄ cánuú quíhīn rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Súcuan ni cahān yā jnūhun yáha jíín de, te ni quendōo ya Galilea. ");
INSERT INTO mibNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Te nuū ni yáha ñani yā cuangoo de vico ún, te sáá te suni cuahān maá yá. Te tú cuahān ndijin yā, chi tu ní stéén yā maá yá. ");
INSERT INTO mibNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Te jnáhan ñuu yā hebreo cánanducú i ya nuū víco ún, te cácahān i: ¿Ndé nuū íne tēe ún? áchí i. ");
INSERT INTO mibNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Te yōhyo ni cacahān ñayuu jeē sɨquɨ́ yā, chi sava i cácahān: Tēe vāha cúu de. Te sava ga i cácahān: Tuú chi stáhú de ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Te yuhu‑ni ni cacahān i jnūhun ya, chi cáyūhú i jeē quɨtɨ́ ni jnáhan i tēe hebreo. ");
INSERT INTO mibNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Te jeē ní cuu sava vico, te ni quee Jesús, ni quɨ̄vɨ ya templo cáhnu, te ni quejéé yá steén yā jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Te ni canaa ni jnáhan ñuu yā hebreo cájini sōho i, te ni cacahān i: ¿Ndese jíní tēe yáha cuéhē jnūhun ndíchí, chi tu ní jíca de escuela? áchí i. ");
INSERT INTO mibNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yūcuán na te ni cahān Jesús: Jnūhun stéén rī chi nasūu jnúhun máá rí cúu, chi jnūhun jeē ni jéhe máá Yaā ní tají rúhū cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Núu ɨɨn ñayuu cuní i sáha i jniñu cúní Yaā Dios, ñayuu ún chi jecūhun ni i núu nde nuū Yaā Dios vēji jnūhun stéén rī, chí jnúhun jeē jéni ni maá‑ni ri cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tēe cáhán jnūhun jéni ni maá de, tēe un ndúcú de jeē na sájéhnu ñayuu de. Te núu ɨɨn tēe ndúcú de jeē sajéhnu de Yaā ní tají de, tēe un cúu tēe ndaā, te tú na jnūhun stáhú íyó jíín de. ");
INSERT INTO mibNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿A násūu jéē ni jéhe Moisés ley yā nuū rō jeē squícu ró? Te ni ɨɨn ró tu cásquícu. Chi sa jeē cácuni rō cahni rō ruhū, ¿te najehē cúu? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Te ni cacahān ñayuu cuehē ún: Tachī ndóho ró. ¿Ndé ɨɨn cúní cahni rohó? ");
INSERT INTO mibNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Te ni cahān Jesús: Ni nasávāha ri ɨɨn tēe quɨvɨ̄ ndétātú, te ndɨvii rō ni canaa ni rō ni cajito ró jéē quɨvɨ́ ndétātú ni sáha ri jniñu ún. ");
INSERT INTO mibNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Te Moisés ni jēhe de ley jeē cúu circuncidar nuū rō. Te cásáha ró circuncidar sūchi yɨ́ɨ́ núū uná quɨvɨ̄ jeē ní cacu i, vēsú quɨvɨ̄ ndétātu cúu. (Te nasūu máá Moisés ní jéquin ley un, chi je ni īyo nuū tāca jíí de.) ");
INSERT INTO mibNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Núu súcuan te núu cásáha ró circuncidar vēsú quɨvɨ̄ ndétātu cúu, návāha squícu ró ley Moisés, ¿te najehē cáquɨtɨ̄ ni rō jeē ní nasávāha ndɨhɨ ri ɨɨn tēe quɨvɨ̄ ndétātú? ");
INSERT INTO mibNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ma yachí cani ni rō jeē cuéchi cúu jeē sáha ri. Chi sa cani vāha ni rō sɨquɨ̄ tācá jniñu váha. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yūcuán na te sava ñayuu ñuu Jerusalén ni cacajnūhun jnáhan i: ¿A násūu tée yáha cúu jeē cánanducú tée cácujéhnu jeē cáhni de, chí naún? ");
INSERT INTO mibNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Te yāha cáhán ndijin de nuū chitú, te tú na jnūhun cácahān jiín de. ¿A sanaa te ni cacundaā ni tēe cácujéhnu jeē tée yáha cúu Cristo jeē achí tutu jeē quiji, chí naún? ");
INSERT INTO mibNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Te tuú chi je cájini yō nuū véji tēe yáha. Te jeē quíji Cristo, chi ni ɨɨn yó má cúni ndé chi quíji ya. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yūcuán na te ni cahān jee Jesús jeē steén yā jnūhun ini templo: Cájini rō ruhū, te cájini rō ndé ñuu vēji ri. Te vēsú súcuan te máá Yaā ndaā cúu jeē ní tají rúhū vēji ri, te tú vēji ri jeē cuní maá rí. Te tu cájini rō ndese Yaā cúu ya. ");
INSERT INTO mibNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Te máá rí chi jíní rī yā, chi nde nuū maá yá vēji ri, te máá yá ni tají rúhū, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yūcuán na te ni canducú de jnɨɨ de ya. Te ni ɨɨn de tu ní cúu jnɨɨ de ya, chi ná tu quee maá quɨ́vɨ̄ jeē jnɨ́ɨ de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Te cuehē ñayuu chi ni cacandíje i ya, te ni cacahān i: ¿A násūu tée yáha cúu Cristo, Yaā ndétu yó jéē quiji? Chi cuehē ndasɨ́ jniñu jéhnu sáha ya jeē steén yā poder yā. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Te ni cajini tēe fariseo jeē súcuan cácahān ñayuu jnūhun ya. Te máá de jíín sútū cácujéhnu, ni catají de policía cándito templo jeē jnɨ́ɨ de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Te ni cahān Jesús: Jecu na quɨvɨ̄ condee rī jiín ró jijnáhan ró. Yūcuán na te nuhun rī nuū Yaā ní tají rúhū vēji ri. ");
INSERT INTO mibNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Te nanducú ró ruhū, te ma nánihīn rō ruhū. Chi ma cúu jinūcoo ró núū cóndee rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yūcuán na te máá tée un ní cacajnūhun jnáhan de: ¿Te ndé nuū quihín tēe yáha jeē ma nánihīn yō de? ¿A quíhīn de nuū jnáhan yó hebreo jeē ní cajitē núu cáyūcu ndé nación Grecia? ¿Te á stéén de jnūhun nuū ñáyuu Grecia, chí naún? ");
INSERT INTO mibNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Te na jnūhun cúu jeē ni cáhān de jíín yó jeē nanducú yó de te ma nánihīn yō de, chi ma cúu jinūcoo yó núū cóndee de? Achí tée un jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Te quɨvɨ̄ sándɨ̄hɨ́ vico ún te cúu vico cáhnu ga. Te quɨvɨ̄ un ní ndocuɨñɨ̄ Jesús, te ni cahān jee ya: Núu ndé ñáyuu jnáa ndasɨ́ i tāca jéē váha jeē sáha ri jehē i, nájnūhun jeē jichí i ndute, núu súcuan te na quɨ́vɨ i ndaha ri te coho i ndute, cúu jeē nihín i jeē váha ún. ");
INSERT INTO mibNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Te ñayuu jeē candíje jeē jnáma ri i, chi ini anuá i condee Espíritu Santo, te cuu ya nájnūhun yūte cáne ñuhún jeē sáha ya jeē cótecu i nɨ́ɨ́ cáni, nájnūhun cáhán tutu iī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Te súcuan ni cahān yā jeē ñáyuu candíje jeē jnáma ya i, nihīn i Espíritu Santo. Chi ná tu quee Espíritu ún, chi ná tu ndaa Jesús quinuhun yā nuū ndujéhnu ya. ");
INSERT INTO mibNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Te sava ñayuu cuehē ún, ná ni cajini sōho i jnūhun yáha, te ni cacahān i: Jendaá jeē tée yáha cúu jeē achí tutu jeē quiji de nacani de jnūhun Yaā Dios, achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Te sava ga i ni cacahān: Tēe yáha cúu Cristo, Yaā ní tají Yaā Dios. Te sava ga i chi ni cacahān i: Tuú chi nasūú Galilea quiji Cristo. ");
INSERT INTO mibNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Chi cáhán tutu iī jeē ndé yucūn rey David cacu Cristo, te cacu ya ñuu Belén, ñuu nuū ní cacu máá David. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Te súcuan te ni cacusɨ́ɨn ñayuu jeē sɨquɨ́ yā. ");
INSERT INTO mibNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Te sava i cácuni i jnɨɨ i ya, te ni ɨɨn i tu ní jnɨ́ɨ i ya. ");
INSERT INTO mibNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yūcuán na te policía cándito templo tu ní cájnɨɨ de Jesús, te cuanungoo de nuū tāca tée fariseo jiín núū sutú cácujéhnu. Te tēe ún ni cacajnūhún de policía: ¿Najehē tu ní quécoo ró jíín de? áchí. ");
INSERT INTO mibNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Te ni cacahān policía un: Tú cuɨtɨ ni ɨɨn tēe cáhán vāha ndasɨ́ nájnūhun cáhán tēe yúcuan, áchí. ");
INSERT INTO mibNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Te ni cacahān tēe fariseo: ¿Te á suni nde máá ró jijnáhan ró ní stáhú de naún? ");
INSERT INTO mibNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ni ɨɨn jnáhan ruhū tēe cácujéhnu jíín tée fariseo, tu cácandíje ri jnūhun cáhán tēe ún, ¿te naun cácandíje máá ró? ");
INSERT INTO mibNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Te ñayuu cuehē yāhá jéē tu cájecūhun ni i ley Moisés, chi jnahnū ndetū i jeē cácandíje i tēe ún, áchí de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Te ni cahān Nicodemo, tēe ni jéhēn nuū yā ɨɨn jecuáā, te suni ɨɨn tēe fariseo cúu de: ");
INSERT INTO mibNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Cáhán ley yō jeē ma cúu tee yó cuéchi sɨquɨ̄ ɨɨn tēe, te núu tú xīhna gā cuni sōho yó ndese cáhán de, návāha cucáhnu ni yō na cuēchi ni sáha de. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Te ni cacahān jiín de: Te róhó, ¿á suni nde Galilea vēji ró jéē cahán rō jehē tēe ún? Nanducú váha ró núū tútu iī te cuni rō jeē ndé Galilea tu quénda cuɨtɨ ni ɨɨn tēe nácani jnūhun Yaā Dios. Achí jíín de. ");
INSERT INTO mibNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Te cuanungoo de ná vehe ná vehe de. ");
INSERT INTO mibNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Te ni caa Jesús cuahān yā yucu Olivos. ");
INSERT INTO mibNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Te jeē cuácundijin ɨnga quɨvɨ̄, te ni ndee tucu ya templo. Te ndɨhɨ ñayuu ni quecoo i nuū yā. Te ni cucōo ya, te ni steén yā jnūhun nuū i. ");
INSERT INTO mibNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yūcuán na te tēe cástéén tutu ley Yaā Dios jiín tée grupo fariseo, ni quecoo de jíín ɨɨn ñahan jeē ní canihīn de ña jeē casɨ́quɨ́ ndéē ña. Te ni cajeni de ña mēhñú. ");
INSERT INTO mibNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Te ni cacahān de jíín yá: Maestro, ni canihīn ná ñahan yáha jéē casɨ́quɨ́ ndéē ña. ");
INSERT INTO mibNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Te ley Moisés ndácu jniñu nuū yō jeē cuáha yó yúū xinī ñahan cásáha súcuan návāha cuu ña. Te máá ní, ¿ndese cáhán ni? ");
INSERT INTO mibNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Te súcuan ni cacahān de jeē cájito ndee de ya núu cuatáhú yá jeē cahán ley un, chi núu tuú te caquin de cuēchi sɨquɨ̄ yā. Te Jesús ni jīta ndeyɨ ya, te ni tee ya nuū ñúhun jíín xínī ndáha ya. ");
INSERT INTO mibNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Te jeē cácajnūhun cácajnūhún de ya, te ni ndonehen ya maá yá, te ni cahān yā jiín de: Núu ndé ɨɨn máá ró tú na cuēchi ró, te xīhna gā maá ró cuāha yuū xinī ña núu súcuan, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Te ni jīta ndeyɨ tucu ya, te ni tee tucu ya nuū ñúhun. ");
INSERT INTO mibNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Te nuū ní cajini de jeē súcuan ni cahān yā, te ni cajecūhun ni de jeē suni cáhīyo cuēchi de. Te ná ɨɨn ná ɨɨn de ni quendacoo de cuahān de, xīhna gā tēe jéhnu ga te nde nuū ní ndɨhɨ na. Te ni ndōo máá ɨɨn na Jesús jiín ñahan índichi mēhñú un. ");
INSERT INTO mibNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Te ni ndonehen tucu ya maá yá, te tuá ni ɨɨn tēe un ní jíto ya, chi máá na ñahan ún. Te ni cahān yā jiín ña: ¿Ndé chi cuángoo tēe cájequin cuēchi sɨquɨ̄ rō? ¿A tú ni ɨɨn de ní ndónda cahān gā cuēchi sɨquɨ̄ rō? ");
INSERT INTO mibNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Te ni cahān ña: Tú ni ɨɨn de, áchí ña. Yūcuán na te ni cahān Jesús jiín ña: Ni ruhū, ma cahán rī cuēchi sɨquɨ̄ rō. Cuáhán te ma sáha ga rō cuēchi, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Te ɨnga jínu ni cahān Jesús jiín ñáyuu: Máá rí cúu nájnūhun luz jeē steén ini anuá ñayuu ñayɨ̄vɨ́, jeē sáha jeē jécūhun ni i sɨquɨ̄ Yaā Dios. Ñayuu candíje ruhū chi ma cáca i nájnūhun nuū néē, chi sa suhva conevāha i luz ini anuá i jeē sáha jeē cótecu i nɨ́ɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yūcuán na te ni cacahān tēe fariseo jiín yá: Róhó chi cáhán rō jnūhun jehē maá ró, te tu jéjníñu jnūhun cáhán rō. ");
INSERT INTO mibNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Te ni cahān Jesús jiín de jíjnáhan de: Vēsú cáhán rī jehē maá rí, te íyó ndáā jnūhun cáhán rī. Chi jíní rī ndé nuū véji ri jiín ndé nuū quihín rī. Te róhó tu cájini rō ndé nuū véji ri ni ndé nuū quihín rī. ");
INSERT INTO mibNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Máá ró chi cuenta ñayuu ñayɨ̄vɨ cásándaā rō sɨquɨ̄ jnúhun cáhán rī. Te ruhū chi tu sándaā mañúhún rí sɨquɨ̄ ni ɨɨn ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Te núu sándaā rī sɨquɨ̄ i, te ndaā sáha ri, chi tu sáha máñúhún rí, chi sándaā rī nde jiín máá Tátá rī, Yaā ní tají rúhū vēji ri. ");
INSERT INTO mibNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Te yósó núū tútu ley cánevāha ró jéē núu ɨnuú cácahān uū testigo, te jíni ñúhún cuatáhú ró jeē cácahān, chi íyó ndáā jnūhun ún. ");
INSERT INTO mibNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Núu súcuan te ruhū cúu ɨɨn jeē cahán ndaā rī jehē rī. Te ɨnga jeē cahán ndaā jehē rī cúu máá Tátá rī, Yaā ní tají rúhū. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Te ni cacahān de jíín yá: ¿Ndé nuū ndeé Tátá rō? Te ni cahān Jesús: Tu cájini rō ruhū ni Tátá rī. Te núu jeē cájini rō ruhū, suni cuni rō Tatá rī nuú. ");
INSERT INTO mibNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tāca jnúhun yáha ní cahān Jesús jeē steén yā ini templo nuū cáyūcu yéjnū jeē cásocō i xūhún. Te tú ni ɨɨn de ní jnɨ́ɨ de ya, chi ná tu quee maá quɨ́vɨ̄ jeē jnɨ́ɨ de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Te ni cahān tucu Jesús jiín de: Ruhū chi quihīn rī, te nanducú ró rúhū, te ma nánihīn rō ruhū, chi quendōo cuēchi ró sɨquɨ̄ rō quɨvɨ̄ cúū rō. Te jeē yúcuan má cúu jinūcoo ró núū quihín rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yūcuán na te tēe hebreo un ní cacahān maá de: ¿A cahni tēe yáha máá de, te jeē yúcuan cáhán de jeē ma cúu jinūcoo yó núū quihín de, chí naún? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Te ni cahān yā: Máá ró jijnáhan ró chi ñayɨ̄vɨ yáha véjicoo ró, te ruhū chi nde andɨvɨ́ véji ri. Máá ró cácuu ñayuu ñayɨ̄vɨ yáha, te ruhū chi nasūu tée ñayɨ̄vɨ yáha cúu ri. ");
INSERT INTO mibNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jeē yúcuan ní cahān rī jeē quendōo cuēchi ró sɨquɨ̄ rō quɨvɨ̄ cúū rō. Chi núu ma candíje ró jéē maá rí cúu Cristo, te quendōo nahín cuéchi ró sɨquɨ̄ rō quɨvɨ̄ cúū rō. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Te ni cacajnūhún de ya: Núu súcuan ¿te ndé ɨɨn cúu ró? Te ni cahān yā: Je ni cachi ri nuū rō nde xīhna ñúhún ndé ɨɨn cúu ri. ");
INSERT INTO mibNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Te íyó cuéhē gā jnūhun cuu cahān rī jiín ró te sándaā rī sɨquɨ̄ rō. Te ma cahán rī, chi ini ñayɨ̄vɨ yáha cáhán rī maá‑ni jnūhun jeē ní jini ri ni cahān Yaā ní tají rúhū vēji ri. Te máni jnūhun ndaā cahán yā. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Te tu ní cájecūhun ni de jeē cahán yā jnūhun Tátá yā andɨvɨ́ jíín de. ");
INSERT INTO mibNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jeē yúcuan ní cahān gā yā: Nde na yáha jeē cáta caa ró rúhū, Yaā ní nduu tēe, jicā cruz, yūcuán na te cuni rō ndé ɨɨn cúu ri. Te cuni rō jeē tú na vé sáha ri jeē maá rí, chi cáhán rī maá‑ni jnūhun ni steén Tatá rī nuū rī. ");
INSERT INTO mibNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Chi máá Tátá rī, Yaā ní tají rúhū, ndéé yá jiín rí. Te tu stóo máñúhún yá ruhū, chi níní sáha ri jniñu jeē nújnahan ni maá yá. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Te jeē ni cáhān yā jnūhun yáha, te cuehē ñayuu ni cacandíje i ya. ");
INSERT INTO mibNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yūcuán na te ni cahān Jesús jiín jnáhan ñuu yā hebreo jeē ní cacandíje i ya: Te núu cuɨñɨ nīhin ró jíín jnúhun stéén rī nuū rō, te cuu ndije ró ñáyuu scuáha jíín rí. ");
INSERT INTO mibNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Te jecūhun ni rō jnūhun ndaā, te jnūhun ndaā un sáha jeē nduu libre rō nuū jeē yɨ́hɨ ró ndaha. ");
INSERT INTO mibNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Te ni cacahān i jíín yá: Sēhe yucūn Abraham cácuu ri, te tu cáyɨhɨ cuɨtɨ rī ndaha ni ɨɨn. ¿Te ndese cúu jeē cahán rō jeē nduu libre rī núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Te ni cahān Jesús: Jendaá cahán rī jiín ró jeē tāca ñáyuu casáha cuēchi, tu íyó libre i, chi yɨ́hɨ i chīji cuēchi jeē jejníñu cāhá i nuū. ");
INSERT INTO mibNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Te ñayuu jejníñu cāhá, chi tu cúu i ɨɨn jnáhan ñayuu vehe nuū jejníñu i. Te ɨɨn sēhe chi sa suhva cúu ndije i jnáhan ñayuu vehe ún. ");
INSERT INTO mibNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Núu súcuan te máá rí jeē cúu Sēhe Yaā Dios, núu sáha ri jeē tuá cuajníñu cāhá ró nuū cuéchi, núu súcuan te nduu libre ndije ró jíjnáhan ró, te cuu ró séhe ya. ");
INSERT INTO mibNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Te jíní rī jeē séhe yucūn Abraham cácuu ró, te vēsú súcuan te cácuni rō cahni rō ruhū, chi tu cájetáhú ró jnūhun cáhán rī. ");
INSERT INTO mibNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ruhū chi cáhán rī jnūhun jeē ni stéén Tatá rī nuū rī. Te máá ró chi cásáha ró jniñu jeē ni cáhān tatá maá ró jijnáhan ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Te ni cacahān i: Sēhe yucūn Abraham cácuu ri. Te ni cahān Jesús: Núu jeē candíje ró nájnūhun ni candíje Abraham návāha cuu ndije ró yúcūn de, yūcuán na te jniñu váha ni sáha de suni sáha máá ró nuú. ");
INSERT INTO mibNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Te vijna chi cácuni rō cahni rō ruhū, vēsú ni cahān rī jiín ró tāca jnúhun ndaā ni steén Tatá rī nuū rī. Te Abraham chi tu ní sáha cuɨtɨ de súcuan. ");
INSERT INTO mibNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Máá ró chi ɨnuú cásáha ró jíín tátá maá ró. Achí yá jiín i. Yūcuán na te ni cacahān i: Máá rí chi tu cácuu ri sēhe ndáhú jéē tu tátá. Chi íyó ɨɨn‑ni tátá rī, te Yaā Dios cúu ya. ");
INSERT INTO mibNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Te ni cahān Jesús: Núu Yaā Dios cúu ndije tátá rō, te coo manī rō jiín rí nuú. Chi nde nuū Yaā Dios ni quenda ri vēji ri. Te tú vēji ri jeē cuní maá rí, chi máá yá ni tají rúhū. ");
INSERT INTO mibNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Te najehē tu cájecūhun ni rō jnūhun cáhán rī núu súcuan? Suu sɨquɨ̄ jeē tu cácuni rō chusóhó ró jnúhun nácani ri. ");
INSERT INTO mibNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Máá ró jijnáhan ró chi tátá rō cúu jexeén. Te cácuni rō sáha ró máá jéē cuní tatá rō ún. Máá jéxeén ni jehni ndɨ̄yɨ nde jeē xíhna ñúhún. Te tu ní íin cuɨtɨ jiín jnúhun ndaā, te tú cuɨtɨ na jnūhun ndaā cahán. Te jeē cahán jexeén jnūhun stáhú cúu jeē súcuan cáa máá. Chi máá un cúu jeē ndíso jnūhun stáhú, te máá un cúu jeē ní squéjéé ndɨhɨ jnūhun stáhú. ");
INSERT INTO mibNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Te ruhū chi cáhán rī jnūhun ndaā, te jeē yúcuan cúu jeē tu cácandíje ró rúhū. ");
INSERT INTO mibNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Te ni ɨɨn ró ma nihín rō cuēchi sɨquɨ̄ rī, chi tú cuɨtɨ na cuēchi ri. Te máni jnūhun ndaā cahán rī, ¿te naun tu cácandíje ró rúhū? ");
INSERT INTO mibNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ñayuu cácuu sēhe Yaā Dios, chi cáchusóhó i jnūhun Yaā Dios. Te nasūu séhe Yaā Dios cácuu ró, te jeē yúcuan tu cácuni rō chusóhó ró. Achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yūcuán na te ni cacahān jnáhan ñuu yā hebreo un: Ndaā cácahān rī jeē canéé ró nájnūhun ñayuu Samaria, te ñúhun tachī ini rō. ");
INSERT INTO mibNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Te ni cahān Jesús: Tu ñúhun tachī ini rī, chi yɨ́ñúhún rí jiín Tátá rī. Te máá ró jijnáhan ró chi tu cáhīyo yɨ́ñúhún ró jiín rí. ");
INSERT INTO mibNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Máá rí tu ndúcú rí jeē cujéhnu ri. Iyó ɨɨn jeē sáha jeē cujéhnu ri, te máá yá sándaā sɨquɨ̄ jnúhun cácahān rō. ");
INSERT INTO mibNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jendaá cahán rī jiín ró, núu ndé ñáyuu squícu jnūhun cáhán rī, ma cúū cuɨtɨ i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Te tēe hebreo un tu ní cájecūhun ni de, te ni cacahān de: Vijna te ni cacucáhnu ni rī jeē ñúhun ndije tachī ini rō. Chi Abraham jiín táca tée ni canacani jnūhun Yaā Dios nde jenahán, ni cajihī de. Te róhó cáhán rō, núu ndé vé squícu jnūhun cáhán rō, te ma cúū cuɨtɨ i, áchí ró. ");
INSERT INTO mibNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Te chí jéhnu ga rō vēsú jií yō Abraham naún? Chi ni jihī de, te suni ni cajihī tāca tée ni canacani jnūhun ya. ¿Te ndé ɨɨn ga sáha ró máá ró núu súcuan? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Te ni cahān Jesús: Núu ruhū sajéhnu ri maá rí, te tu níhín jníñu. Máá Tátá rī cúu jeē sajéhnu ruhū. Te cácahān rō jeē maá yá cúu Yaā Dios maá ró. ");
INSERT INTO mibNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Te vēsú súcuan te tu cájini rō ndese Yaā cúu ya. Te ruhū chi jíní rī yā. Te núu cahān rī jeē tu jíní rī yā, te cuu ri tēe stáhú nájnūhun máá ró jijnáhan ró. Te tuú chi jíní ndije ri yā, te squícu ri jnūhun cáhán yā. ");
INSERT INTO mibNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Te jíí rō Abraham ni cusɨɨ̄ ni de jeē coto de quɨvɨ̄ quéē rī. Te je ni jito de, te ni jito ri jeē ní cusɨɨ̄ ndasɨ́ ni de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yūcuán na te ni cacahān tēe hebreo un jíín yá: Ni ná tu coo ró uū xico uxī cuiyā, ¿te ndese cúu jeē cahán rō jeē ní jito ró núū Abraham? achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Te ni cahān Jesús: Jendaá cahán rī jiín ró jeē nde ná tu cacu Abraham te je íyó rí, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yūcuán na te ni caquihin de yuū jeē cuáha de xinī yā. Te Jesús chi ni quenda sāhi yá ni yāha ya mēhñú de, ni quenda ya ini templo cuahān yā. ");
INSERT INTO mibNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Te jeē jíca Jesús cuahān yā, te ni jito ya nuū ɨɨn tēe ni cacu cuáá. ");
INSERT INTO mibNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Te tēe cáscuáha jíín yá ni cacajnūhún de ya: Maestro, ¿naun ni cacu cuáá tée yáha? ¿A cuéchi tátá de náná de cúu, chí cuéchi máá de cúu, chí naún? ");
INSERT INTO mibNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Te ni cahān Jesús: Nasūu cuéchi máá de, ni nasūu cuéchi tátá de náná de cúu jeē ní cacu de súcuan, chi sa suhva návāha cuni ñayuu jniñu jéhnu sáha Yaā Dios jiín de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Níní jéē cúu nájnūhun nduú ini ñayɨ̄vɨ́, te cánuú sáha ri jniñu Yaā ní tají rúhū. Chi quee tiempo jeē coo nájnūhun jecuáā, jeē tuá cuu sájniñu ni ɨɨn. ");
INSERT INTO mibNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Níní jéē iyó rí ini ñayɨ̄vɨ́ te cúu ri luz jeē cúndijin ini anuá ñayuu ñayɨ̄vɨ́, návāha jecūhun ni i sɨquɨ̄ Yaā Dios. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Te ná ni cahān yā súcuan, te ni tesɨ̄hɨ yá nuū ñúhun, te ni sáha ya ndehyū jiín tésɨ̄hɨ yá un, te ni tee ya sɨquɨ̄ tɨ́nūu tée cuáá un. ");
INSERT INTO mibNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Te ni cahān yā jiín de: Cuáhán núū pila Siloé te nacate ró tɨ́nūu ró, achí yá. Te jnūhun Siloé cuní cahān, ndute ní cascáca de ni quee. Yūcuán na te cuahān de, te ni nacate de tɨnūú de, te ni ndundijin‑ni, te ni nandicó de vēji de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yūcuán na te ñayuu yúcu yajni jíín de, jíín ñáyuu jeē ní cajito jeē cúu de tēe cuáá, ni cacajnūhun jnáhan i: ¿A násūu tée yáha cúu jeē ndeé-ni yāhá te jícán caridad? ");
INSERT INTO mibNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Te sava i ni cacahān: Suu de cúu. Te sava ga i ni cacahān: Nasūú de cúu, te súcuan cúní coto de. Te máá de chi ni cahān de: Suu ri cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yūcuán na te ni cacajnūhún i de: ¿Te ndese cúu jeē ní nanune tɨnūu ró núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Te ni cahān de: Tēe nání Jesús ni sáha de ndehyū, te ni tee de tɨnūu rí, te ni cahān de jíín rí: Cuáhán núū pila Siloé te nacate ró tɨ́nūu ró. Te ni jehēn rī, te ni nacate ri, te ni nanune‑ni tɨnūu rí, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yūcuán na te ni cacajnūhún i de: ¿Ndé nuū íne tēe ún? áchí i. Tu jíní rī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Yūcuán na te ni cajendeca i tēe ni īyo cuáá un núū tée grupo fariseo. ");
INSERT INTO mibNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Te quɨvɨ̄ ndétātu cúu jeē ni sáha Jesús ndehyū jeē ní nanune ya tɨnūú de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Te tēe fariseo un ní cacajnūhún tucu de tēe ún ndese ni nanune tɨnūú de. Te ni cahān de: Ni tee de ndehyū sɨquɨ̄ tɨnūu ná, te ni nacate ná, te ni ndundijin‑ni tɨnūu ná, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yūcuán na te ni cacahān sava tēe fariseo: Tēe ún chi nasūu ndé nuū Yaā Dios vēji de, chi tu née iī de quɨvɨ̄ ndétātú. Te sava ga de chi ni cacahān: ¿Ndese cuu sáha tēe un táca jniñu jéhnu yáha te núu tēe íyó cuéchi cúu de? Te ni cacusɨ́ɨn de sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Te ni cacajnūhún tucu de tēe ni īyo cuáá un: Róhó, ¿ndese cáhán rō sɨquɨ̄ tée ni nanune tɨnūu ró núu súcuan? Te máá de ni cahān de: Ɨɨn tēe nácani jnūhun Yaā Dios cúu de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Te tēe hebreo un chi tu ní cácandíje de jeē ni íyo cuáá tée ún te ni ndundijin tɨnūú de. Te ni cacana xinī tatá de náná de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Te ni cacajnūhún de: ¿A yáha cúu sēhe ro jéē ní cacu cuáá cácahān rō? Núu súcuan ¿te ndese ni ndundijin tɨnūú de vijna? áchí. ");
INSERT INTO mibNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Te ni cacahān tatá de náná de: Suu sēhe ri cúu tēe yáha jéē ní cacu cuáá. ");
INSERT INTO mibNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Te tu cájini rī ndese ni ndundijin tɨnūú de vijna, ni tu cájini rī ndé tée ni nanune tɨnūú de. Cajnūhun ró maá de, chi je jéhnu de, te na cáchi máá de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Súcuan ni cacahān tatá de náná de, chi cáyūhú de cájito de jnáhan de tēe hebreo. Chi je ni casándaā tēe un jéē núu ndé ñáyuu cachi i jeē Jesús cúu Cristo, Yaā ní tají Yaā Dios, te quenehen de i jeē ma cúu ga quɨ̄vɨ i ini vehe iī sinagoga. ");
INSERT INTO mibNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jeē yúcuan ní cacahān tatá de náná de: Cajnūhun ró maá de, chi je jéhnu de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yūcuán na te tēe hebreo un ní cacana tucu de tēe ni īyo cuáá un. Te ni cacahān de jíín: Cachi cají ró nuū rī, jíto jínúū Yaā Dios. Chi cájini rī jeē tée íyó cuéchi cúu tēe ni nanune tɨnūu ró. ");
INSERT INTO mibNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yūcuán na te ni cahān de: Tu jíní na núu íyó cuéchi de, chí naún. Te íyó ɨɨn jeē jiní ná, cúu jeē tēe cuáá ní cuu ná, te vijna chi ni ndundijin tɨnūu ná. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Te ni cacajnūhún tucu de: ¿Ndese ni sáha de jíín ró? ¿Ndese ni nanune de tɨnūu ró núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Te ni cahān de: Je ni cuu ni castūhun ná nuū ní, te tu ní cácuni ní cuatáhú ní. ¿Te najehē cácuni ni jéē cáchi tucu ná núū ní? ¿Te chí suni cácuni ni jíjnáhan ní candíje ní yá naún? ");
INSERT INTO mibNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yūcuán na te ni cacahān neé jíín de, te áchí: Máá ró chi cándíje ró tée ún, te máá rí chi cácandíje ri Moisés. ");
INSERT INTO mibNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Te cájini rī jeē ni cáhān Yaā Dios jiín Moisés. Te tēe yúcuan, ni tu cájini rī ndé nuū véji de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Te ni cahān tēe ni īyo cuáá: Náā ni na jéē cácahān ni jéē tu cájini ní jeē véji de nuū Yaā Dios, vēsú ni nanune de tɨnūu ná. ");
INSERT INTO mibNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Te cájini yō jeē Yaā Dios tu jíni nahín yá jeē cájicān ñayuu iyó cuéchi. Chi jíni nahín yá nuū maá‑ni ñayuu jeē cáchiñúhún i ya te cásáha i jeē cuní yā. ");
INSERT INTO mibNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Te nɨ́ɨ́ véji yó te tu ní jíni sōho cuɨtɨ yō jeē ɨ́ɨn tēe nanune de tɨnūú ɨnga tēe ni cacu cuáá. ");
INSERT INTO mibNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Te núu nasūu ndé nuū Yaā Dios vēji tēe ún, te ma cúu cuɨtɨ sáha de ɨɨn jniñu súcuan. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Te ni cacahān tēe hebreo un: Róhó chi íyó ndasɨ́ cuéchi ró ndé quɨvɨ̄ ní cacu ró, ¿te á máá ró steén nuū rī naún? áchí. Te ni caquenehen tēe un yátā vehe iī sinagoga. ");
INSERT INTO mibNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Te ni jini jnūhun Jesús jeē ní caquenehen de tēe ún. Te ni nihīn jnáhan ya jiín de, te ni cahān yā jiín de: ¿A cándíje ró Séhe Yaā Dios? ");
INSERT INTO mibNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Te ni cahān de: ¿Ndé ɨɨn cúu ya návāha candíje ná yá? ");
INSERT INTO mibNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Te ni cahān Jesús: Je ni jito ró núū yā, te suu cúu ruhū jeē cahán jiín ró, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yūcuán na te ni jecuɨñɨ̄ yɨtɨ́ de nuū yā, te ni cahān de: Cándíje ná jéē nihín cúu Jitoho ná. ");
INSERT INTO mibNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Te ni cahān Jesús: Vēji ri ini ñayɨ̄vɨ yáha jéē sándaā rī sɨquɨ̄ ñáyuu. Chi ñayuu jeē nájnūhun cácuáá ánuá, ndundijin ini anuá i jeē jécūhun ni i sɨquɨ̄ rī. Te ñayuu jeē jéni ni i jeē cájecūhun ni i, nájnūhun nducuáá ánuá i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Te sava tēe fariseo jeē cáhīin jiín yá, ná ni cajini de jnūhun yáha, te ni cacahān de jíín yá: ¿Te chí jéni ni rō jeē suni tēe tu cájecūhun ni cácuu máá rí naún? ");
INSERT INTO mibNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Te ni cahān Jesús: Núu jeē cácuu ró tée tu jécūhun ni nuú, te ma cóo cuēchi ró. Te sɨquɨ̄ jeē ní cacahān rō jeē cájecūhun ni rō, te tu cájetáhú ró, jeē yúcuan condee cuēchi sɨquɨ̄ rō. ");
INSERT INTO mibNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Jendaá cahán rī jiín ró, núu yɨ́hɨ lanchi ini corral cánevāha cáhnu ñayuu, te núu ndé tée tu quɨ́vɨ de ichi yéhyɨ́ corral un, chi sa suhva ɨnga lado cáa de quɨ́vɨ de, tēe un cúu ñacuīhná, chi vēji jeē sacuíhná. ");
INSERT INTO mibNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Te tēe quɨ́vɨ ichi yéhyɨ́, chi tēe un cúu pastor ndíto lanchi. ");
INSERT INTO mibNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Te tēe ndíto yéhyɨ́, núne de te quɨ́vɨ tēe ún. Te lanchi de cánacuni tɨ̄ tachī de. Te cána de sɨ́hvɨ́ lanchi máá de, te táva de tɨ. ");
INSERT INTO mibNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Te núu ni tava de ndɨhɨ lanchi máá de, te yósnúu de nuū tɨ̄ cuahān de. Te lanchi un cándiquīn tɨ̄ de, chi nácuni tɨ̄ tachī de. ");
INSERT INTO mibNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Te ma cóndiquīn tɨ̄ yatā ɨnga tēe, chi sa suhva cunu tɨ coto tɨ de, chi nácuni tɨ̄ jeē nasūu jítoho tɨ̄ cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jnūhun yátá yáha ní cahān Jesús jiín ñáyuu, te tu ní cájecūhun ni i na jnūhun cúu jeē ni cáhān yā. ");
INSERT INTO mibNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yūcuán na te ni cahān gā Jesús jiín i: Jendaá cahán rī jiín ró: Máá rí cúu nájnūhun yéhyɨ́ corral nuū quɨ́vɨcoo ñayuu cácuu nájnūhun lanchi ri. ");
INSERT INTO mibNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tāca tée jeē tu ní tájí Yaā Dios, jeē ní quijicoo de nde ná tu quee rī, cácuu de nájnūhun ñacuīhná, chi tu ní cástéén de jnūhun ndaā. Te ñayuu cácuu nájnūhun lanchi ri, tu ní cájetáhú i de. ");
INSERT INTO mibNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Máá rí cúu nájnūhun yéhyɨ́. Te ñayuu jeē jiín máá rí quɨ́vɨcoo, jnama ri i. Te cuu i nájnūhun lanchi jeē ndɨ́vɨcoo tɨ nuū yɨ́hɨ vāha tɨ, te quéndacoo tɨ nuū cáji vāha tɨ. ");
INSERT INTO mibNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Tēe cuíhná chi máni vēji de jeē sacuíhná de lanchi, te cahni de, te snáā de. Te ruhū chi vēji ri návāha cotecu ñayuu cácuu lanchi ri, te nde yōhyo vāha ndetū coo i. ");
INSERT INTO mibNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Máá rí cúu máá pastor vāha. Te pastor vāha chi ndíto vāha de lanchi de, vēsú nde cuu de jeē sɨquɨ́ tɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Te ɨɨn tēe yɨ́yāhu, nasūú pastor tɨ̄ cúu de, chi nasūú lanchi máá de cúu tɨ. Te núu jíto de jeē véji yɨhɨ̄, te stóo de lanchi, te jínu de cuahān de. Te yɨhɨ̄ chi jnɨ́ɨ tɨ lanchi, te sáha tɨ jeē jité núu lanchi. ");
INSERT INTO mibNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Te tēe yɨ́yāhu ún chi jínu de cuahān de sɨquɨ̄ jeē lanchi tátú cúu jeē ndíto de, te jeē yúcuan tu cúndáhú ni de tɨ. ");
INSERT INTO mibNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Máá rí cúu máá pastor vāha. Te jíní rī tāca ñáyuu cácuu nájnūhun lanchi ri, te máá i cájini i ruhū. ");
INSERT INTO mibNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Te yāha cúu nájnūhun jeē Tatá rī jiní yā ruhū, te máá rí jiní rī Tatá rī. Te cuu rī jeē sɨquɨ́ ñayuu cácuu lanchi ri. ");
INSERT INTO mibNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Te suni íyó gá ñayuu jeē cácuu lanchi ri, te sɨ́ɨn sɨ́ɨn ñayuu cácuu i. Te cánuú jéē suni condeca ri ñayuu ún. Te cuatáhú i jnūhun cáhán rī. Te coyūcu cáhnu‑ni ndɨhɨ ñayuu candíje, te coo ɨɨn‑ni pastor i. ");
INSERT INTO mibNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Te Tátá rī manī ndasɨ́ yá jiín rí sɨquɨ̄ jeē jéhe ri maá rí jeē cúū rī jehē ñayuu, te natecu tucu ri. ");
INSERT INTO mibNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni ɨɨn ma cúu cahni ruhū, chi máá rí cúu jeē jéhe jnūhun cuu rī. Jeē cachí máá rí te cuu rī, te jeē cachí máá rí te natecu rī, chi súcuan íyó poder rī. Súcuan ni cahān Tatá rī jeē sáha ri. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Te jeē ní cajini jnáhan ñuu yā hebreo jnūhun yáha, te ni cacusɨ́ɨn tucu i. ");
INSERT INTO mibNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Te cuehē i ni cacahān: ¿Naun cáchusóhó ró jeē cahán de? Chi ñúhun tachī ini de, te ni tɨ̄vɨ xínī de. ");
INSERT INTO mibNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Te sava ga i ni cacahān: Tu súcuan cáhán tēe ñúhun tachī ini, nájnūhun cáhán tēe yáha. Te tēe ñúhun tachī ini, ¿á cuu nanune de tɨnūu tée cuáá naún? Achí. ");
INSERT INTO mibNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Te tiempo míjin cúu, te ñuu Jerusalén cánasáha ñayuu vico jeē cánucūhun ni i quɨvɨ̄ ní cuhiī templo cáhnu. ");
INSERT INTO mibNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Te jíca cuu Jesús ini templo, ini corredor jeē naní Salomón. ");
INSERT INTO mibNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Te jnáhan ñuu yā hebreo ni cacutútú i nuū yā, te ni cacahān i: ¿Nasaa ga quɨvɨ̄ sáha ró jéē ma cucáhnu ni rī? Cachi cají núū rī jijnáhan ri núu máá ró cúu Cristo. ");
INSERT INTO mibNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Te ni cahān Jesús: Je ni castūhun rí nuū rō, te tu ní cácandíje ró. Tācá jniñu jeē ní tejníñu Tátá rī ruhū sáha ri, yūcuan stéén cají jéē maá yá ni tají rúhū. ");
INSERT INTO mibNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Te tu cácandíje ró, chi nasūú lanchi ri cácuu ró, nájnūhun je ni cahān rī jiín ró. ");
INSERT INTO mibNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ñayuu cácuu lanchi ri, chi nácuni i jeē maá rí cúu jeē cahán jiín i. Te jíní rī i, te cándiquīn i ruhū. ");
INSERT INTO mibNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Te cotecu i nɨ́ɨ́ cáni sáha ri, te ma jnahnú ndetū cuɨtɨ i. Te ni ɨɨn ma cúu quende i ndaha ri. ");
INSERT INTO mibNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Máá Tátá rī ni squɨ́vɨ ya i ndaha ri. Te cújéhnu ga maá yá vēsú tāca gá. Te ni ɨɨn ma cúu quende i ndaha ya. ");
INSERT INTO mibNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Máá rí jiín Tátá rī, chi ɨɨn‑ni cúu ri, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yūcuán na te jnáhan ñuu yā hebreo ni caquihin tucu de yuū jeē cuáha de xinī yā. ");
INSERT INTO mibNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Te ni cahān yā jiín de: Ni steén rī cuehē jniñu váha nuū rō jeē ni sáha ri jiín poder Tatá rī. ¿Te á sɨ́quɨ̄ jeē ni sáha ri jniñu váha cúu jeē cuáha ró yúū xinī rī núu súcuan? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Te ni cacahān de jíín yá: Nasūu sɨ́quɨ̄ jeē ni sáha ró jniñu váha cúu jeē cuáha ri yuū xinī rō, chi sɨquɨ̄ jeē cahán ndevāha ró jéē achí ró jeē ɨnuú cúu ró jíín Yaā Dios. Chi tēe‑ni cúu ró, te sáha ró jéē ɨnuú cúu ró jíín Yaā Dios. Achí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Te ni cahān Jesús: Yósó núū tútu ley cánevāha ró jéē ni cáhān Yaā Dios: Nájnūhun yaā cácuu ró, áchí Yaā Dios, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chi ñayuu jeē ní cajetáhú jnúhun ya, ni cahān yā jeē cácuu i nájnūhun yaā. Te cájini yō jeē ma cúu cahān yō jeē tú ndaā jnūhun cáhán tutu iī. ");
INSERT INTO mibNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Núu súcuan ¿te naun cácahān rō jeē jnúhun ndevāha cúu jeē ni cáhān rī jeē Séhe Yaā Dios cúu ri? Chi máá Yaā Dios ni jeni ya ruhū sɨquɨ̄ jníñu iī, te ni tají yá ruhū vēji ri ini ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Núu tu sáha ri jniñu sáha Tátá rī, núu súcuan te ma candíje ró rúhū. ");
INSERT INTO mibNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Te núu sáha ri, te vēsú tu cácandíje ró rúhū, te na cándíje ró sɨ́quɨ̄ jniñu sáha ri ún. Te súcuan te cucáhnu ni rō jeē ɨɨn‑ni cúu Tátá rī jiín rí, te ɨɨn‑ni cúu ri jiín Tátá rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yūcuán na te cánducú tucu de jnɨɨ de ya. Te ni ndoñúhún‑ni ya cuahān yā. ");
INSERT INTO mibNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Te cuanuhun yā yūte Jordán ichi núū cáne niāndii, nuū ni íne Juan ni scuándute de. Te ni condee yā yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Te ni quijicoo cuehē ñayuu nuū yā, te ni cacahān i jíín táca jnáhan i: Ndaā chi vēsú tu ní sáha Juan ni ɨɨn jniñu jéhnu, te ni cundaā ndɨhɨ jnūhun ni cahān de sɨquɨ̄ ndese sáha tēe yáha. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Te cuehē ñayuu jeē ni jéngoo nuū yā yūcuán, ni cacandíje i ya. ");
INSERT INTO mibNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Te ni īyo ɨɨn tēe cúhú, nání de Lázaro. Te máá de jíín cuáha de María jiín Marta, cácuu de ñayuu ñuu Betania. ");
INSERT INTO mibNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Te María un jéē cúu cuāha Lázaro, suu ña cúu jeē ní chihi aceite perfume jehē Jitoho yō, te ni nasíchí ña jíín ixi xíní ña. ");
INSERT INTO mibNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Te ndɨndúú cuáha de un ní catají ña jnūhun cuahān nuū Jesús: Tēe jeē maní ni jíín, cúhú de, áchí ña, áchí mozo. ");
INSERT INTO mibNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Te ná ni jini Jesús jnūhun, te ni cahān yā: Cuehyɨ̄ yáha chi nasūu cuéhyɨ̄ jeē ví cuu de cúu. Chi sa suhva sáha Yaā Dios jeē cuni ñayuu ndese cújéhnu ya. Chi ruhū, Sēhe Yaā Dios, jiín cuéhyɨ̄ yáha te stéén rī jeē suni cújéhnu máá rí. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Te manī Jesús jiín Marta jiín cúhū ña jíín Lázaro. ");
INSERT INTO mibNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Te vēsú súcuan te nuū ni níhīn yā jnūhun jeē cuhú de, te ni quendōo ya uū gā quɨvɨ̄ nuū ndeé yá un. ");
INSERT INTO mibNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yūcuán na te ni cahān yā jiín tée cáscuáha jíín yá: Na quíhín tucu yó región Judea. ");
INSERT INTO mibNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Te tēe cáscuáha un ní cacahān de jíín yá: Maestro, ná tu cuu quɨvɨ̄ jeē ní canducú jnáhan yó hebreo cuāha de yuū xinī ní. ¿Te cúní ni quíhīn tucu ní yúcuan naún? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Te ni cahān Jesús: Ma cúu cahni ñayuu ruhū núu ná tu quee maá quɨ́vɨ̄ cuu rī. Chi jeē iyó rí ñayɨ̄vɨ yáha cúu nájnūhun jeē iyó úxī uū hora ɨɨn nduú. Te jeē sáha ri jeē cuní Yaā Dios, cúu ri nájnūhun tēe jeē jíca nduú, te tu cáchihi de jehē de, chi cúndijin nuū de ñayɨ̄vɨ yáha. ");
INSERT INTO mibNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Te tēe jeē tu sáha jeē cuní Yaā Dios, chi nájnūhun jíca de jecuáā, te nájnūhun cáchihi de jehē de, chi tu cúndijin ini anuá de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yūcuán na te ni cahān tucu ya: Amigo yō Lázaro quíxí de, te quihīn rī sáha ri jeē nátahū ni de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yūcuán na te tēe cáscuáha un ní cacahān de: Núu quíxí de te jíní yō jeē nduvāha de. ");
INSERT INTO mibNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Te Jesús chi súcuan ni cahān yā jeē jé ni jihī de. Te cájeni ni tēe cáscuáha jeē quixí ndije de. ");
INSERT INTO mibNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yūcuán na te ni cahān cají yá: Je ni jihī Lázaro. ");
INSERT INTO mibNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Te cúsɨɨ̄ ni rī jeē tu ní cóyūcu yó yūcuán, návāha vāha ga candíje ró jéē coto ró jniñu jéhnu sáha ri. Núu súcuan te na quíngoo yó núū ndɨ́yɨ ún. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yūcuán na te Tomás, tēe cúu cuátí, ni cahān de jíín jnáhan de jeē cascuáha jíín yá: Suni na quíngoo yó návāha cuu yō jiín yá, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Te nuū ní quee Jesús, te jíní yā jeē ní cuu cuūn quɨvɨ̄ yɨ́ndūji Lázaro. ");
INSERT INTO mibNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Te yajni‑ni íne ñuu Betania jiín ñuu Jerusalén, nájnūhun uū kilómetro yosáva. ");
INSERT INTO mibNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Te Marta jiín María, ni quecoo cuehē jnáhan ña hebreo jeē cahán i jnūhun ndeyɨ́ ni jiín ña jeē sɨquɨ́ jeē ni jíhī cuāha ña. ");
INSERT INTO mibNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Te nuū ní jini Marta jeē véji Jesús, te ni quenda ña cuajnahan ña ya. Te María chi ni ndōo ña vehe. ");
INSERT INTO mibNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Te ni cahān Marta jiín Jesús: Núu ní íyo ní yáha, te ma cúū cuāha ná núú. ");
INSERT INTO mibNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Te vēsú súcuan te jíní na jéē tāca jéē cacán ni núū Yaā Dios, te sáha ya, achí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Te ni cahān Jesús jiín ña: Natecu cuāha ró. ");
INSERT INTO mibNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Te ni cahān Marta: Jíní na jéē nátecu de quɨvɨ̄ nátecu tāca ndɨ́yɨ nde quɨvɨ̄ jínu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Te ni cahān Jesús: Máá rí cúu Yaā sáha jeē nátecu jiín jéē cótecu nɨɨ́ cáni. Ñayuu candíje jeē jnáma ri i, vēsú na cúū i, te natecu i. ");
INSERT INTO mibNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Te ñayuu cátecu te cándíje i ruhū, cotecu i nɨ́ɨ́ cáni andɨvɨ́. ¿A cándíje ró jnúhun yáha? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Te ni cahān ña: Cándíje ná jéē maá ní cúu Cristo, Sēhe Yaā Dios, jeē achí tutu jeē quíji ini ñayɨ̄vɨ, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Te ná ni cahān ña súcuan, te cuahān‑ni ña, cuacana yuhu ña cuhū ña María: Máá Maestro ni quee yā, te cána ya rohó, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Te jeē ní jini María jnūhun yáha, te yachī ni ndocuɨñɨ̄ ña, cuahān ña nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Te ná tu quɨ̄vɨ Jesús ñuu, chi ni ndōo‑ni ya nuū ni jéjnahan Marta yā. ");
INSERT INTO mibNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Te ñayuu hebreo un jéē cáyūcú ini vehe jíín María, jeē cácahān i jnūhun ndeyɨ́ ni jiín ña, ni cajito i jeē yachí ni ndocuɨñɨ̄ ña cuahān ña. Te ni candiquīn i ña cuangoo i, chi cájeni ni i jeē cuándahyū ña nde nuū yɨ́ndūji ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Yūcuán na te ni jinū María nuū íne Jesús, te ni jecuɨñɨ̄ yɨtɨ́ ña nuū jehé yā, te ni cahān ña: Núu ní íyo ní yáha, te ma cúū cuāha ná núú, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Te ni jito Jesús jeē ndahyú ña jíín jéē cándahyū ñayuu vējicoo jíín ña. Te yōhyo ni nducuíhyá ni yā, te ni jnahuhū ni yā jeē cundáhú ni yā i. ");
INSERT INTO mibNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Te ni cajnūhun yá ña: ¿Ndé mí ní cachindūji ró de? Te ni cacahān ña jíín yá: Quíhín yō te cuni ní, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Te ni ndahyū Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yūcuán na te ni cacahān ñayuu hebreo un: Condēhe náa yōhyo manī de jíín ndɨ́yɨ ún. ");
INSERT INTO mibNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Te sava i chi ni cacahān i: Tēe yáha jéē ní nanune de tɨnūu tée cuáá, ¿á tu ní cúu sáha de jeē ma cúū Lázaro nuú? áchí i. ");
INSERT INTO mibNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Te yōhyo ni jnahuhū ni tucu Jesús, te ni quee yā nde nuū yɨ́ndūji ndɨ̄yɨ. Te ɨɨn yaū cava cúu, te yuyáú un ndíhyú ɨɨn yuū. ");
INSERT INTO mibNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Te ni cahān yā: Tejiyo yuū un jíjnáhan ró, áchí yá. Te Marta, cuāha ndɨ̄yɨ un, ní cahān ña: Je jéén xicō de, chi je ni cuu cuūn quɨvɨ̄ yɨ́ndūji de. ");
INSERT INTO mibNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Te ni cahān Jesús jiín ña: ¿A násūú je ni cahān rī jiín ró jeē núu candíje ró te coto ró jéē yóhyo cújéhnu Yaā Dios jiín poder yā? achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yūcuán na te ni catejiyo i yuū jeē ndésɨ yuyáú ndɨ̄yɨ ún. Te ni ndacoto‑ni Jesús ichi ándɨvɨ́, te ni cahān yā: Tátā, na cútahū na núū ni jéē sáha ní jéē jicán na. ");
INSERT INTO mibNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Te jíní na jéē niní sáha ní jéē jicán na. Te jeē váha ñayuu cáhīin yáha cúu jeē súcuan cáhán na, návāha na cándíje i jeē maá ní ni tají sáña. ");
INSERT INTO mibNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Te ná ni cahān yā súcuan, te ni cahān jee ya: Lázaro, quenda quiji ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Te ni quenda‑ni tēe ni jihī ún, te ñúsúcún ndaha de sɨ̄hɨn de jíín tira sahma. Te nuū de ñúsúcún ɨɨn sahma. Te ni cahān Jesús jiín i: Nandají ró sahma ñúsúcún de, návāha cuu caca de, áchí yá. Te ni canandají i. ");
INSERT INTO mibNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yūcuán na te cuehē ñayuu hebreo jeē ní quijicoo nuū María, ni cacandíje i Jesús, chi ni cajito i jniñu ni sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Te sava i chi cuangoo i nuū tée grupo fariseo, te ni cacastūhún i ndese ni sáha Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yūcuán na te tēe fariseo un jíín sútū cácujéhnu ni candutútú de junta jiín táca gá tēe cácujéhnu. Te ni cacahān de: ¿Ndese sáha yó? Chi tēe ún yōhyo cuehē jniñu jéhnu sáha de. ");
INSERT INTO mibNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Te núu condēhé‑ni yó, te ndɨvii ñayuu candíje i de. Te quijicoo tāca tée nación Roma jeē cácujéhnu, te canu de templo cáhnu yó, te scuíté núu de ñayuu nación yō, achí de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Te ɨɨn jnáhan de jeē naní Caifás, jeē cúu máá sútū cujéhnu ga cuiyā ún, ni cahān de: Róhó chi tu cájini cuɨtɨ rō, ");
INSERT INTO mibNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ni tu cájecūhun ni rō jeē váha ga jeē cúū ɨɨn tēe jehē ñáyuu nación yō vēsú jeē náā ndɨvii i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Te tu ní cáhán de jnūhun yáha jéē jéni ni maá de. Chi sɨquɨ̄ jeē cúu de sutū cujéhnu ga cuiyā ún, te ni sáha Yaā Dios jiín de jeē ní nacani de jnūhun jeē cúū Jesús jehē ñáyuu nación hebreo. ");
INSERT INTO mibNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Te nasūu máá ɨɨn‑ni jehē nación hebreo, chi suni jehē ndɨvii ñayuu cácuu sēhe Yaā Dios jeē ní cajitē núu tācá nación, návāha ɨɨn na cuu i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yūcuán na te nde quɨvɨ̄ ún te tāca tée hebreo cácujéhnu un, ní casquíjnáhan de jnūhun jeē cáhni de Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jeē yúcuan tuá ní jíca ndijin yā nuū jnáhan ñuu yā hebreo un, chi ni quenda ya región Judea, te cuahān yā ɨɨn ñuu naní Efraín, nuū iyó yajni ñuhun téhé. Te ni condee yā yūcuan jíín tée cáscuáha jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Te ni cuyajni vico pascua jeē cánasáha ñayuu hebreo. Te cuehē ñayuu tācá ñuu yūcuán cuángoo i ñuu Jerusalén, návāha squícu i jeē cahán ley jeē cúchi i ndundoo i nuū Yaā Dios, te sáá te quejéé vico pascua. ");
INSERT INTO mibNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Te cánanducú i Jesús, te cácajnūhun jnáhan i ini templo: ¿Ndese cájeni ni rō? ¿A quiji de vico, chí tuú? Achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Te sutū cácujéhnu jíín tée fariseo ni candacu de jniñu jeē núu ndé ɨɨn ñayuu jiní ndé nuū íne ya, te na cástūhún i, návāha jnɨɨ de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Te cúmanī iñū gā quɨvɨ̄ te coo vico pascua. Te ni jehēn tucu Jesús ñuu Betania nuū ndeé Lázaro, tēe ni jihī te ni nastécu yā de. ");
INSERT INTO mibNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Te ni casáha i ɨɨn vico xíni jeē yɨñúhún i jíín yá. Te Marta ni jeni ña cohō. Te Lázaro yéji de staā jiín yá nuū mesa jiín táca gá ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Yūcuán na te María ni quee ña jíín nájnūhun sava litro aceite perfume jeē máni ita nardo cúu, te yōhyo yahu ndéé. Te ni chuhun ña jehē Jesús, te ni nasíchí ña jíín ixi ña. Te nɨ́ɨ́ ini vehe un ní chitú xícō perfume un. ");
INSERT INTO mibNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yūcuán na te ni cahān Judas Iscariote sēhe Simón, ɨɨn tēe scuáha jíín yá un, te suu de cúu jeē nastúu de ya: ");
INSERT INTO mibNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Najehē tu ní cúyāhu perfume yáha jéē uní ciento denario, te cuāha yó núū ñáyuu ndahú núú. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Súcuan ni cahān de, nasūu jéē cundáhú ndije ni de ñayuu ndahú, chi sa suhva jeē cúu de tēe cuíhná. Chi máá de ndíso yɨjnɨ xūhún, te quíhin cuíhná de jeē cájequin tāca tée ún. ");
INSERT INTO mibNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yūcuán na te ni cahān Jesús: Ma stáhān rō ña. Chi jeē ni sáha ña yāhá cúu jeē ni sátūhva ña ruhū nde quɨvɨ̄ jeē quíndūji ri. ");
INSERT INTO mibNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chi níní cáyūcu ñáyuu ndahú jíín ró, te ruhū chi tuá condee rī jiín ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Te cuehē ñayuu hebreo ni cajini jnūhun i jeē néne ya ñuu Betania. Te ni jinūcoo i, te nasūu máá ɨɨn jeē cuní i coto i nuū Jesús, chi suni jeē cuní i coto i nuū Lázaro, tēe jeē ní nastécu yā. ");
INSERT INTO mibNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Yūcuán na te sutū cácujéhnu ni casquíjnáhan de jnūhun jeē suni cahni de Lázaro. ");
INSERT INTO mibNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Chi jeē sɨquɨ́ Lázaro te ni cujiyo cuehē jnáhan ñuu de hebreo nuū de, te cácandíje i Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Te ɨnga quɨvɨ̄ ún, te ñayuu cuehē jeē ní quecoo vico pascua un, ní cajini jnūhun i jeē véji Jesús ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Te ni cajehnde i ndaha ñúú, te ni quendacoo i cuajnahan i ya. Te cácana jee i: Yōhyo cújéhnu Yaā Dios. Yōhyo vāha Yaā cúu Yaā jeē véji jíín jniñu máá Jítoho yō Yaā Dios. Yōhyo vāha Yaā cúu Rey nación yō Israel. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Te ni nihīn Jesús ɨɨn burro, te ni jecosō yā tɨ̄, nájnūhun cáhán tutu iī: ");
INSERT INTO mibNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ñayuu ñuu Jerusalén jeē naní ñuu Sion, ma yūhu ró jijnáhan ró. Yāhá condēhe ró jeē véji Rey rō, te yósó yá ɨɨn burro. Achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Te quɨvɨ̄ ún te tēe cáscuáha jíín yá, tu ní cájecūhun ni de jeē súcuan squícu tāca jéē yosó núū tútu iī. Te nde ná ni ndujéhnu Jesús jeē cuánuhun yā andɨvɨ́, te sáá te ni canucūhun ni de tāca jnúhun yósó sɨ́quɨ̄ yā, jiín jéē ní casáha de súcuan jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Te ñayuu ní cahīin jíín yá ná ni cana ya xinī Lázaro nuū ní yɨndūji de, te ni nastécu yā de, ni canacani i jnūhun ndese ni sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jeē yúcuan ní quendacoo ñayuu cuehē un, ní jejnahan i ya, chi ni cajini jnūhun i jeē ni sáha ya jniñu jéhnu un jéē ni steén yā poder yā. ");
INSERT INTO mibNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yūcuán na te ni cacahān maá tée fariseo: Vijna te je ni cajito yó jéē ma cúu cuɨtɨ gā casɨ yō. Chi jíto yó jéē ndɨvii cuɨtɨ ñayuu cuangoo i jíín de. Achí de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Te sava ñayuu nación Grecia, suni ni quijicoo i ñuu Jerusalén vico pascua un jéē chiñúhún i Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Te ni quecoo i nuū Felipe, tēe ñuu Betsaida ndañúū Galilea. Te ni cacahān i jíín de: Tátā, cácuni ná cahān na jíín Jesús, achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Te ni jehēn Felipe, ni castūhún de nuū Andrés. Te ndɨndúú de cuacastūhún de nuū Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Te ni cahān Jesús jiín de: Je ni quee quɨvɨ̄ jeē ndujéhnu Yaā ní nduu tēe. ");
INSERT INTO mibNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Te jendaá cahán rī jiín ró, ɨɨn nunī trigo núu tú nɨngava nuū ñúhun te quindūji, núu súcuan te quendōo máá ɨɨn‑ni. Te núu quindūji, te nacayā cuehē ndasɨ́. Te suni súcuan cánuú cuu rī quindūji ri, návāha coo cuehē ñayuu jeē ndúu i sēhe Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Te na‑ni ñayuu núu tu jéhe i jnūhun ndoho i jeē sɨquɨ́ ruhū, te jnahnū ndetū i. Te ñayuu jeē jéhe i jnūhun ndoho i jeē sɨquɨ́ ruhū ini ñayɨ̄vɨ yáha, cotecu i nɨ́ɨ́ cáni andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Núu ndé ñáyuu cuní i cuajníñu i nuū rī, na cóndiquīn i ruhū. Te nuū cóndee rī, suni yūcuán condee ñayuu jejníñu nuū rī. Te ñayuu jejníñu nuū rī, chi sáha Tátá rī jeē cujéhnu i. ");
INSERT INTO mibNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Te vijna te cúcuíhyá ndasɨ́ ni rī sáha jnūndóho quiji sɨquɨ̄ rī. ¿Te ndese cahān rī? ¿A cáhān rī jiín Tátá rī: Jnama ní sáña núū jnúndóho jeē quíji sɨquɨ̄ ná, achi rī? Ma cúu, chi jeē sɨquɨ́ yúcuan cúu jeē véji ri. ");
INSERT INTO mibNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tátā, stéén ni jéē cujéhnu ndasɨ́ ní jiín poder ni, áchí yá. Yūcuán na te ichi ándɨvɨ́ ní cahān ɨɨn jnūhun: Je ni steén rī jeē cujéhnu ri, te sáha tucu ri ɨnga jínu, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Te ni cajini ñayuu cáhīin yūcuán, te ni cacahān i jeē taja cáhán. Te sava ga i ni cacahān: Ɨɨn ndajéhé Yaā Dios ni cahān jiín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Te ni cahān Jesús jiín i: Tu ní cáhán jnūhun yáha jéē sɨquɨ́ ruhū, chi sa suhva návāha cuni rō sɨquɨ̄ jnúhun jeē ni cáhān yā jiín rí. ");
INSERT INTO mibNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vijna cúu jeē sándaā Yaā Dios sɨquɨ̄ cuéchi ñayuu ñayɨ̄vɨ yáha. Vijna cúu jeē scúnu ya jexeén jeē ndácu jniñu ini ñayɨ̄vɨ yáha. ");
INSERT INTO mibNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Te ruhū, núu na jínu condita caa ri cuu rī ini ñayɨ̄vɨ́, te sáha ri jeē jnáā tāca ñáyuu quɨ̄vɨcoo i ndaha ri, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Súcuan ni cahān yā jeē steén yā ndese modo cuu yā. ");
INSERT INTO mibNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Te ni cacahān ñayuu jiín yá: Ni cajini sōho ná jéē cahán tutu ley Yaā Dios cánevāha yó, jeē Cristo cotecu yā nɨɨ́ cáni. ¿Te naun cáhán ni jéē Yaā ní nduu tēe, cánuú condita caa ya cuu yā? ¿Ndé ɨɨn cúu máá Yáā ní nduu tēe núu súcuan? Achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yūcuán na te ni cahān Jesús: Máá jecu na quɨvɨ̄ condee rī jiín ró jeē cúu ri luz cundijin ini anuá rō. Núu súcuan te vijna jeē iyó gá luz rī jiín ró, te caca ró jíín, chi sanaa ni rō te cuahān rī, te nájnūhun quendōo ró núū néē. Chi ñayuu cájica nájnūhun nuū néē, tu cájini i ndé nuū cuángoo i. ");
INSERT INTO mibNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Núu súcuan te níní ndéé gá rī jiín ró, te candíje ró rúhū jeē cúu ri luz, návāha nduu ró ñáyuu cájica jíín luz, achí yá. Súcuan ni cahān Jesús tāca jnúhun yáha, te cuahān‑ni ya, te tuá ni stéén yā maá yá nuū i. ");
INSERT INTO mibNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Te vēsú cuehē jniñu jéhnu ni sáha Jesús jeē steén yā poder yā nuū i, te tu ní cácandíje i ya. ");
INSERT INTO mibNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Chi squícu nahín jnúhun ni cahān Isaías, tēe ni nacani jnūhun Yaā Dios nde jenahán: Tátā Yaā Dios, tu ní cácandíje ñayuu jnūhun ni canacani ná, te tu ní cácandíje i jniñu jéhnu jeē ni stéén ni poder ni núū i. Achí Isaías. ");
INSERT INTO mibNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jeē yúcuan tu ní cúu candíje i, chi ni cahān tucu Isaías: ");
INSERT INTO mibNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ni sáha ya jeē nájnūhun cáhīyo cuáá ánuá i, jíín jéē cácunīhni ni i, návāha coo nájnūhun jeē tu cájito i, te ni ma jécūhun ni i, ni ma násāma ini i quɨ̄vɨcoo i nuū rī, jeē nasávāha ri anuá i nuū cuéchi i. Achí Cristo, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jnūhun yáha ní cahān Isaías, chi je ni jito de ndese yōhyo cújéhnu Jesús, te ni cahān de ndese coo quɨvɨ̄ jeē quíji ya. ");
INSERT INTO mibNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Te vēsú súcuan te cuehē ñayuu hebreo chi ni cacandíje i ya, te suni nde jiín sava tēe cándacu jniñu. Te tu ní cácachi de jeē cácandíje de ya, chi sɨquɨ̄ jeē cáyūhú de tāca tée fariseo. Chi núu súcuan te quenehen ún de ini vehe iī sinagoga jeē ma cuáha ga jnūhun quɨ̄vɨcoo de. ");
INSERT INTO mibNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Chi cácusɨɨ̄ gā ni de jeē cujéhnu de sáha ñayuu, vēsú jeē cujéhnu de sáha Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Te ni cahān jee Jesús: Ñayuu cácandíje ruhū, nasūu máñúhún‑ni ruhū cácandíje i, chi suni cácandíje i nde maá Tátá rī, Yaā ní tají rúhū. ");
INSERT INTO mibNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Te ñayuu cájito nuū rī, suni cájito i nuū Yaā ní tají rúhū. ");
INSERT INTO mibNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Máá rí jeē cúu ri luz cúndijin ini anuá ñayuu, ni quiji ri ini ñayɨ̄vɨ návāha tāca ñáyuu cácandíje ruhū, ma cáca i nájnūhun nuū néē. ");
INSERT INTO mibNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Te núu ɨɨn ñayuu jíni sōho i jnūhun cáhán rī, te núu tu jétáhú i, te nasūu rúhū sándaā sɨquɨ̄ i. Chi tú vēji ri jeē ndénehen ri cuēchi sɨquɨ̄ ñayuu ñayɨ̄vɨ́, chi sa suhva jeē jnáma ri i. ");
INSERT INTO mibNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Te ñayuu jeē casquéhichī i ruhū te tu cájetáhú i jnūhun cáhán rī, íyó ɨɨn jeē sándaā sɨquɨ̄ i. Suu tāca jnúhun jeē ni cáhān rī, jnūhun un cúu jeē ndenehen cuēchi sɨquɨ̄ i quɨvɨ̄ jínu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chi tu cáhán rī jeē cúu ni maá rí, chi Tátá rī, Yaā ní tají rúhū, máá yá ni ndacu jniñu nuū rī ndese cahān rī jiín ndese stéén rī. ");
INSERT INTO mibNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Te jíní rī jeē jniñu ndácu Tátá rī sáha jeē cótecu ñayuu nɨɨ́ cáni. Núu súcuan te jnūhun cáhán rī, chi máni jnūhun jeē ní cachi Tatá rī cúu, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Te jehíni ɨnga quɨvɨ̄ te quejéé vico pascua. Te je jíní Jesús jeē ní quee quɨvɨ̄ jeē quénda ya ñayɨ̄vɨ yáha quínuhun yā nuū Tatá yā. Te níní cúndáhú ni yā ñayuu maá yá jeē cáyūcú ini ñayɨ̄vɨ́. Te vijna jeē jínu jeē íne ya ñayɨ̄vɨ́, te sáha ya ɨɨn jniñu jeē steén cají yá jeē cundáhú ni yā i. ");
INSERT INTO mibNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Te jexeén je ni squɨ́vɨ ini anuá Judas Iscariote sēhe Simón, jeē vijna nastúu de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Te jíní Jesús jeē véji ya nuū Yaā Dios, te nuhūn yā nuū Yaā Dios, jiín jéē ni sáha Tátá yā jeē cujéhnu ya sɨquɨ̄ ndɨhɨ‑ni. ");
INSERT INTO mibNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Te cúxíni ya jiín tée cáscuáha jíín yá, te ni ndocuɨñɨ̄ yā. Te ni stáa ya sahma ndíi ya, te ni jihni yā ɨɨn toalla chīji ya. ");
INSERT INTO mibNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Te ni chuhun ya ndute ini ɨɨn tijehēn. Te ni quejéé yá nácate ya jehē tēe cáscuáha. Te násíchí yā jiín toalla jeē nuhní chīji ya. ");
INSERT INTO mibNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Te ni jinū yā nuū Simón Pedro. Te ni cahān Pedro jiín yá: ¿Sa máá ní nacate jehē ná naún? ");
INSERT INTO mibNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Te ni cahān Jesús: Tu jécūhun ni rō jeē sáha ri vijna, te cúcuéé gá te jecūhun ni rō. ");
INSERT INTO mibNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Te ni cahān Pedro jiín yá: Ma nácate cuɨtɨ ni jéhē ná. Te ni cahān Jesús: Núu tú nacate ri jehē rō, te ma cúu cundúú ró jiín rí. ");
INSERT INTO mibNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Te ni cahān Simón Pedro: Núu súcuan cúu te nasūu máá jéhē‑ni ná, chi suni nacate ní ndaha ná jíín xínī ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Te ni cahān Jesús jiín de: Tēe jeē sa ní jichi, tu jíni ñúhún ndundoo nɨ́ɨ́ cáhnu de, chi máá jéhē‑ni de, chi je íyó ndoo nɨ́ɨ́ cáhnu de. Te máá ró chi je ni candundoo ró. Te tú ndɨhɨ ró cáhīyo ndoo. ");
INSERT INTO mibNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Chi je jíní yā ndé ɨɨn de cúu jeē nastúu de ya, te jeē yúcuan ní cahān yā: Tú ndɨhɨ ró cáhīyo ndoo. ");
INSERT INTO mibNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Te nuū ni jínu ni nacate ya jehē de jíjnáhan de, te ni naquihin ya sahma ndíi ya, te ni nucōo tucu ya nuū mesa. Te ni cahān yā: ¿A cájecūhun ni rō na vé cuní cahān jeē ni sáha ri jiín ró? ");
INSERT INTO mibNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Cácahān rō jeē Maestro jiín Jítoho rō cúu ri, te ndaā cácahān rō, chi suu ndije cúu ri. ");
INSERT INTO mibNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Núu súcuan te vēsú Maestro rō jiín Jítoho rō cúu ri, te ni nacate ri jehē rō jijnáhan ró, te suni súcuan cánuú jéē nacate máá ró jehē jnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Chi jniñu yáha ni sáha ri jeē steén rī nuū rō jeē suni súcuan sa cuajníñu ró núū jnáhan ró, nájnūhun sa máá rí ni jejníñu ri nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jendaá cahán rī jiín ró jeē ɨɨn mozo tu cújéhnu de nuū patrón de, te tēe jíca jniñu táhú nuū de, te cújéhnu de nuū tée ni tají de. Te máá ró cácuu mozo rī, te na cuájníñu ró núū jnáhan ró nájnūhun ni steén rī nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Te núu ni cajecūhun ni rō jnūhun yáha, te yōhyo ndetū rō te núu squícu ró. ");
INSERT INTO mibNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Te nasūu jéē cahán rī jeē ndɨhɨ ró ndétū, chi je jíní rī tāca róhó jéē ní nacāji ri. Te cánuú squícu jnūhun yáha jeē cáhán tutu iī: Tēe yéji staā jiín rí, ni ndió cuɨ́ñɨ́ de sɨquɨ̄ rī, achí tutu. ");
INSERT INTO mibNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Te vijna te je cástūhun rí tāca jéē yáha núū rō nde ná tu coo, návāha núu na cóo, te candíje ró jéē maá rí cúu Yaā ní tají Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jendaá cahán rī jiín ró jeē na‑ni ñayuu jeē cuatáhú i tāca jéē tají rí, te ruhū jetáhú i. Te ñayuu jetáhú rúhū, suni jétáhú i Yaā ní tají rúhū vēji ri, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Te ná ni cahān Jesús tāca jnúhun yáha, te ni cucuíhyá ndasɨ́ ni yā. Te ni cahān cají yá: Jendaá cahán rī jiín ró jijnáhan ró jéē ɨɨn máá ró nastúu ruhū, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yūcuán na te tēe cáscuáha jíín yá, ni candacoto de nuū jnáhan de, cájeni ni de ndé ɨɨn de cúu jeē ni cáhān yā. ");
INSERT INTO mibNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Te ɨɨn máá tée scuáha jeē maní gā yā jiín, néne de xiin ya mesa jeē cácuxíni de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Te ni sáha Simón Pedro seña nuū de jeē na cájnūhún de ya ndé ɨɨn de cúu jeē ni cáhān yā. ");
INSERT INTO mibNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yūcuán na te tēe un ní scáyɨ de máá de nuū Jesús, te ni cajnūhún de ya: ¿Ndé ɨɨn de cúu? áchí de jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Te ni cahān Jesús: Na chúndaji ri staā te cuāha ri nuū ɨɨn de, te suu tēe un cúu, áchí yá. Te ni chundaji ya staā, te ni jēhe ya nuū Judas Iscariote sēhe Simón. ");
INSERT INTO mibNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Te jeē ní quihin de staā ún, te ni quɨ̄vɨ‑ni Satanás ini anuá de. Yūcuán na te ni cahān Jesús jiín de: Jniñu jeē sáha ró, na sáha yachī rō. ");
INSERT INTO mibNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Te ni ɨɨn tēe cáyeji staā jiín yá, tu ní cájecūhun ni de naun ni cahān yā súcuan jíín de. ");
INSERT INTO mibNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Chi sava de cájeni ni de jeē ni cáhān Jesús jiín Judas jeē cuáan de jeē jíni ñúhún yá vico ún, chí jéē cuáha de jecu xūhun núū ñayuu ndahú. Chi máá de ndíso yɨjnɨ xūhún. ");
INSERT INTO mibNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Te jeē ní yeji de staā ún, te ni quenda‑ni de cuahān de. Te je ni cuaa. ");
INSERT INTO mibNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yūcuán na te jeē cuahán Judas te ni cahān Jesús: Vijna te ruhū, Yaā ní nduu tēe, stéén rī ndese cújéhnu ri, te suni jíín rúhū te cuni ñayuu ndese cújéhnu Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Te núu jíín rúhū cuni ñayuu ndese cújéhnu Yaā Dios, núu súcuan te suni stéén Yaā Dios ndese cújéhnu ruhū jeē cúu ri Sēhe ya. Te yachī‑ni stéén yā. ");
INSERT INTO mibNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Séhē, tuá nahán condee rī jiín ró jijnáhan ró. Te nanducú ró ruhū, te nájnūhun ni cahān rī jiín táca jnáhan yó hebreo, suni súcuan cáhán rī jiín ró vijna, jeē ma cúu jinūcoo ró núū quihín rī. ");
INSERT INTO mibNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Te vijna te ndácu ri ɨɨn jniñu jéé núū rō, jeē na cúndáhú ni rō jnáhan ró. Nájnūhun cúndáhú ni rī rohó, suni súcuan na cúndáhú ni rō jnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Te núu cúndáhú ni rō jnáhan ró, súcuan te cuni tāca ñáyuu jeē cácuu ró tée cáscuáha jíín rí, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Te ni cahān Simón Pedro jiín yá: ¿Ndé nuū quihín ni núu súcuan? Te ni cahān Jesús: Nuū quihín rī chi ma cúu condiquīn rō ruhū vijna, te cúcuéé gá te jinū rō. ");
INSERT INTO mibNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Te ni cahān Pedro: ¿Najehē ma cúu condiquīn na níhín vijna? Tu yúhú ná cuu na jéē sɨquɨ́ ni. ");
INSERT INTO mibNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Te ni cahān Jesús: ¿A jéni ni rō jeē tu yúhú ró cuu rō jeē sɨquɨ́ rī? Jendaá cahán rī jiín ró jeē nde ná tu cana líhli, te unī jínu yūhu ró te cahān rō jeē tu jíní rō ruhū. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Te ni cahān gā yā: Ma cucuíhyá ni rō sɨquɨ̄ tāca jnúndóho. Na cándíje ró jéē sáha Yaā Dios jehē rō, te suni na cándíje ró jéē sáha ri jehē rō. ");
INSERT INTO mibNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Chi nuū ndeé Tátá rī, íyó cuéhē vehe condee rō jijnáhan ró. Te núu jeē tu súcuan íyó, te je ni castūhun rí nuū rō nuú. Núu súcuan te quihīn rī quisátūhva ri nuū cóyūcu ró. ");
INSERT INTO mibNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Te jeē quihín rī sátūhva ri nuū cóyūcu ró, te ndiji ri quinaquihin ri rohó quíhīn yō, návāha suni coyūcu ró nuū cóndee maá rí. ");
INSERT INTO mibNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Te je cájini rō ndé nuū quihín rī, te cájini rō ndese jinū rō yūcuán. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Te ni cahān Tomás jiín yá: Tu cájini na ndé nuū quihín ni, ¿te ndese cuni ná ichi jínú yūcuan núu súcuan? ");
INSERT INTO mibNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Te ni cahān Jesús jiín de: Máá rí cúu ichi jinū rō andɨvɨ́, te máá rí cúu jnūhun ndaā jiín jnúhun cotecu rō nɨɨ́ cáni. Te ni ɨɨn ma jinú nuū Tatá rī te núu tú ruhū. ");
INSERT INTO mibNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Te núu je ni cajini rō ruhū, te suni je ni cajini rō Tatá rī núu súcuan. Te ndé vijna je cájini rō yā, chi je ni cajito ró núū rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Te ni cahān Felipe jiín yá: Stéén ni Tátá ni núū ná, te na cúvāha ni na jíjnáhan ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Te ni cahān Jesús: Felipe, je ni cuu cuehē quɨvɨ̄ jíca ri jiín ró jijnáhan ró, ¿te á ná tu cuni rō ndé ɨɨn cúu ri naún? Tēe jeē jíto ruhū, suu Tátá rī jíto de. Núu súcuan ¿te najehē cahán rō jeē steén rī Tatá rī nuū rō? ");
INSERT INTO mibNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿A tu cándíje ró jéē ɨɨn‑ni cúu ri jiín Tátá rī, te Tátá rī ɨɨn‑ni cúu ya jiín rí? Tāca jnúhun cáhán rī jiín ró, nasūu jnúhun máá rí cúu. Chi Tátá rī jeē ɨɨn‑ni cúu ya jiín rí, máá yá sáha tācá jniñu jeē sáha ri. ");
INSERT INTO mibNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Candíje ró jíjnáhan ró jéē ɨɨn‑ni cúu ri jiín máá Tátá rī, te Tátá rī ɨɨn‑ni cúu ya jiín rí. Te núu tu cájecūhun ni rō, te candíje ró rúhū sɨquɨ̄ tācá jniñu sáha ri. ");
INSERT INTO mibNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jendaá cahán rī jiín ró, núu ndé ñáyuu candíje ruhū, jniñu jéhnu jeē sáha ri yāhá, suni sáha i. Te jéhnu ga jniñu sáha i vēsú yāhá, chi quinuhun rī nuū ndeé Tatá rī. ");
INSERT INTO mibNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Te tācá na‑ni vé cacán rō nuū Tatá rī sɨquɨ̄ jeē cácandíje ró jéē cúu ri Sēhe ya, te sáha ri jeē cacán rō, te súcuan stéén rī jeē yóhyo cújéhnu Tátá rī. ");
INSERT INTO mibNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Chi tācá na‑ni vé cacán rō sɨquɨ̄ jeē cácandíje ró rúhū, te sáha nahín rí. ");
INSERT INTO mibNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Te núu manī rō jiín rí jijnáhan ró, te na squícu ró jniñu ndácu ri nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Te cacān tahú rī nuū Tatá rī, te tají yá ɨnga Yaā chindéé ñáhán róhó, te sáha ya jeē cóo sɨɨ̄ ni rō jijnáhan ró. Te Yaā un cúu máá Espíritu jeē steén jnūhun ndaā, te condee yā jiín ró nɨɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Te ñayuu ñayɨ̄vɨ má cúu cuatáhú i ya, chi tu cúu coto i nuū yā, ni tu cúu cuni i ndese Yaā cúu ya. Te máá ró chi je cájini rō ndese Yaā cúu ya, chi ndéé yá jiín ró, te condee yā ini anuá rō nɨɨ́ cáni. ");
INSERT INTO mibNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma stóo uun ri rohó, chi ndiji ri nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jecu na quɨvɨ̄ te ma cóto ga ñayuu ñayɨ̄vɨ núū rī. Te máá ró jijnáhan ró chi coto ró núū rī, chi cotecu rī nɨɨ́ cáni, te jeē yúcuan suni cotecu maá ró. ");
INSERT INTO mibNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Te quɨvɨ̄ ún te cuni rō jeē ɨɨn‑ni cúu ri jiín Tátá rī, te máá ró ɨɨn‑ni cúu ró jíín rí jeē ndeé rí ini anuá rō jijnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Te na‑ni ñayuu núu ñúhun ni i jniñu ní ndacu ri, te squícu i, ñayuu un cúu jeē maní ndije jíín rí. Te ñayuu jeē maní jiín rí, suni coo manī Tatá rī jiín i. Te suni ruhū coo manī rī jiín i, te stéén rī nuū i jeē nduú rí jiín i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Te ni cahān Judas jiín yá (te nasūu tée cúu Iscariote): Najehē cúu jeē steén ni máá ní nuū ná, te nuū ñáyuu ñayɨ̄vɨ́ chi tuú? ");
INSERT INTO mibNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Te ni cahān Jesús: Ñayuu jeē maní jiín rí, chi cásquícu i jeē cahán rī. Te coo manī Tatá rī jiín i. Te Tátá rī jiín máá rí quijicoo ri cundúú rí jiín i. ");
INSERT INTO mibNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Te ñayuu jeē tú manī jiín rí, tu cásquícu i jeē cahán rī. Te jnūhun cájini sōho ró cáhán rī, nasūu jnúhun máá rí cúu, chi jnūhun máá Tátá rī jeē ní tají rúhū cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Tāca jnúhun yáha cáhán rī jiín ró níní íne ga rī jiín ró. ");
INSERT INTO mibNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Te Tátá rī chi tají yá Espíritu Santo, quiji nucuɨñɨ̄ nuū rī. Te máá yá chindéé ñáhán yá rohó, te sáha ya jeē cóo sɨɨ̄ ni rō. Te stéén yā tāca jnúhun nuū rō, te nacachi tucu ya tāca jéē ni cáhān rī jiín ró. ");
INSERT INTO mibNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Te jeē quihín rī, te sáha ri jeē cóo ndeyɨ́ coo sɨɨ̄ ni rō. Nájnūhun íyó ndeyɨ́ sɨ́ɨ̄ ni maá rí, suni súcuan coo ndeyɨ́ sɨ́ɨ̄ ni rō sáha ri. Te jeē sáha ri jeē cóo ndeyɨ́ sɨ́ɨ̄ ni rō, tu quíjnáhan jíín jnúhun ndeyɨ́ cácahān ñayuu ñayɨ̄vɨ́. Ma cucuíhyá ni rō sɨquɨ̄ tāca jnúndóho, te ni ma yūhu ró. ");
INSERT INTO mibNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Je ni cajini sōho ró jéē ni cáhān rī jeē quihín rī, te ndiji ri cundúú rí jiín ró. Te núu cáhīyo manī vāha ró jiín rí, te cusɨɨ̄ ni rō jeē ni cáhān rī jeē nuhún rī nuū Tatá rī. Chi cújéhnu ga Tatá rī vijna vēsú ruhū. ");
INSERT INTO mibNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Je ni castūhun rí nuū rō tāca jnúhun yáha nde ná tu coo, návāha núu je ni cuu, te candíje ró rúhū jijnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ma cahán rī cuehē gā jnūhun jíín ró, chi je vēji jexeén jeē ndácu jniñu ini ñayɨ̄vɨ yáha. Te tú na vé cúu sáha sɨquɨ̄ rī nuú. ");
INSERT INTO mibNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Te na cóo nájnūhun ni ndacu Tátá rī jniñu nuū rī, návāha cuni ñayuu ñayɨ̄vɨ jéē maní rī jiín Tátá rī, te sáha ri jniñu ní ndacu ya. Ndocuɨñɨ̄ jijnáhan ró na quíngoo yó. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Máá rí cúu nájnūhun yoyúcú uva váha ndaā, te Tátá rī cúu nájnūhun tēe ndíto yoyúcú uva un. ");
INSERT INTO mibNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Te máá ró chi cácuu ró nájnūhun ndaha, te núu tu jéhe ró ndéhē te quende yā rohó. Te núu cácuu ró nájnūhun ndaha jeē jéhe ndehē, te nasándoo ya nacahnde yā rohó nájnūhun jeē cúu ró ndaha ún, návāha cuāha ró cuéhē gā ndehē. ");
INSERT INTO mibNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Te máá ró chi je ni candundoo ánuá rō jiín jnúhun ni steén rī nuū rō, nájnūhun ndúndoo ndaha uva. ");
INSERT INTO mibNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Na cúndúú ró jiín rí, te suni máá rí cundúú rí jiín ró. Ɨɨn ndaha uva ma cúu cuāha ndehē jeē maá, te núu tu yɨ́jnɨ̄ɨ jicā yóho. Te suni súcuan máá ró, ma cúu sáha ró jniñu váha te núu tu cúndúú ró jiín rí. ");
INSERT INTO mibNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Máá rí cúu yoyúcú un, te máá ró cácuu ndaha ri. Ñayuu jeē nduú jíín rí, te ruhū ndúú rí jiín i, máá i cúu nájnūhun ndaha jeē jéhe cuehē ndehē. Chi núu tú cundúú ró jiín rí, te tú cuɨtɨ na jniñu váha cuu sáha ró. ");
INSERT INTO mibNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ñayuu jeē tu cúndúú jíín rí, quende yā i nájnūhun ɨɨn ndaha uva, te ichī. Te ndoho i nájnūhun ndaha uva un jéē ndutútú te cayū nuū ñuhún. ");
INSERT INTO mibNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Núu ndúú ró jiín rí, te cáñuhun ni rō jnūhun cáhán rī, yūcuán na te cacān rō na‑ni vé cácuni rō, te sáha ri jeē cácahān rō. ");
INSERT INTO mibNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Te núu cásáha ró cuéhē jniñu váha, súcuan cástéén rō jeē cúu ndije ró ñáyuu cascuáha jíín rí, te súcuan nácuni ñayuu jeē yóhyo cújéhnu Tátá rī. ");
INSERT INTO mibNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nájnūhun manī Tatá rī jiín rí, suni súcuan manī rī jiín ró jijnáhan ró. Núu súcuan te ma siaá rō jnūhun manī rī jiín ró. ");
INSERT INTO mibNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Núu squícu ró jniñu ní ndacu ri nuū rō, te níní coo manī rī jiín ró, nájnūhun máá rí squícu ri jniñu ní ndacu Tátá rī nuū rī, te níní íyó mánī yā jiín rí. ");
INSERT INTO mibNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Súcuan ni cahān rī jiín ró návāha coo sɨɨ̄ ni rō nájnūhun íyó sɨ́ɨ̄ ni rī, chi nde cusɨɨ̄ teyɨ́ ni rō. ");
INSERT INTO mibNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Te yāha cúu jniñu ndácu ri nuū rō jijnáhan ró: jeē na cúndáhú ni rō jnáhan ró nájnūhun cúndáhú ni rī rohó. ");
INSERT INTO mibNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Núu ɨɨn tēe cuu de jehē amigo de, te tuá na vé cúmanī gā sáha de jeē cundáhú ni de amigo de. ");
INSERT INTO mibNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Te máá ró cácuu amigo rī núu squícu ró jniñu ndácu ri nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma cahán gā rī mozo jiín ró, chi ɨɨn mozo tu cástūhún patrón nuū i ndese jéni ni de sáha de. Chi sa suhva amigo cahān rī jiín ró, chi je ni castūhun rí nuū rō tāca jnúhun ni cahān Tatá rī jiín rí. ");
INSERT INTO mibNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Máá rí ni nacāji róhó jéē jnáma ri rohó, te nasūu máá ró ni cánacani ni xīhna gā jeē cóndiquīn rō ruhū. Te ni jeni ri rohó jéē caca ndaā rō te scándíje ró cuéhē ñayuu jeē cuu i sēhe ri nɨɨ́ cáni. Te súcuan te ndɨhɨ jeē cacán rō nuū Tatá rī sɨquɨ̄ jeē cácandíje ró rúhū, sáha ya jeē jicán rō. ");
INSERT INTO mibNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Te yāha cúu jniñu ndácu ri nuū rō: jeē na cúndáhú ni rō jnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Te núu cáquɨtɨ̄ ni ñayuu ñayɨ̄vɨ núū rō jijnáhan ró, te je cájini rō jeē xíhna gā nuū maá rí ni caquɨtɨ̄ ni i. ");
INSERT INTO mibNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Te núu jeē iyó gá rō jiín modo ñayuu ñayɨ̄vɨ́, te coo manī ñayuu ñayɨ̄vɨ jíín ró nuú, nájnūhun manī i jíín jnáhan i. Te ni nacāji ri rohó jéē tuá coo ró jíín modo ñayuu ñayɨ̄vɨ́. Te jeē yúcuan cáquɨtɨ̄ ni i nuū rō, chi tuá cácuu ró cuenta ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nucūhun ni rō jnūhun ni cahān rī jiín ró: Núu tu íyó yɨ́ñúhún ñáyuu nuū patrón, te nagā ni cuu nuū mozo de. Núu ni cajito xeēn i ruhū, te suni súcuan coto xeēn i róhó jéē cácuu ró mozo rī. Te núu jeē ni cájetáhú i jnūhun ni steén rī, te suni cuatáhú i jnūhun cástéén rō. ");
INSERT INTO mibNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Te tācá jniñu yáha sáha i jíín ró jeē sɨquɨ́ ruhū, chi tu cájini i Yaā ní tají rúhū vēji ri. ");
INSERT INTO mibNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Núu jeē tu ní quíji ri nacani ri jnūhun nuū i, te ma cóo cuēchi i núú. Te vijna chi ma cúu ga cahān i jeē tu jíní i jeē iyó cuéchi i. ");
INSERT INTO mibNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ñayuu jeē cáquɨtɨ̄ ni nuū rī, suni nuū Tatá rī cáquɨtɨ̄ ni i. ");
INSERT INTO mibNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Núu jeē tu ní sáha ri jniñu jéhnu nuū i jeē ní ɨɨn tēe tu ní sáha de súcuan, te ma cóo cuēchi i núú. Te vijna je ni cajito i jniñu ún, te vēsú súcuan te cáquɨtɨ̄ ni i nuū rī jiín núū Tatá rī. ");
INSERT INTO mibNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Te súcuan cásáha i návāha squícu jnūhun yósó núū tútu ley Yaā Dios jeē cánevāha i: Ni caquɨtɨ̄ ni i nuū rī, vēsú tú na cuēchi ri, achí. ");
INSERT INTO mibNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Te tají rí maá Yaā chindéé ñáhán róhó te sáha ya jeē cóo sɨɨ̄ ni rō. Te Yaā un cúu máá Espíritu jeē steén jnūhun ndaā, te quiji ya nde nuū Tatá rī, te nacani cájí yá jnūhun ri. ");
INSERT INTO mibNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Te suni máá ró nacani ró jnúhun ri, chi je cáhīin ro jíín rí nde ná ni quejéé rí nácani ri jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Tāca jnúhun yáha ní cahān rī jiín ró návāha ma náyūhu ró jeē quíji jnūndóho. ");
INSERT INTO mibNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chi quenehen i róhó jéē ma cuáha ga i jnūhun cone ró táca vehe iī sinagoga. Te quee quɨvɨ̄ jeē cahni i róhó, te cani ni i jeē ɨɨn jniñu váha ni sáha i nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Te súcuan sáha i jíín ró, chi tu cájini cuɨtɨ i máá Tátá rī ni máá rí. ");
INSERT INTO mibNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Te ni cahān rī jnūhun yáha jíín ró návāha núu je ni quee quɨvɨ̄ jeē súcuan coo, te nucūhun ni rō jeē jé ni cahān rī jiín ró. ’Te tu ní cáhán rī jnūhun yáha jíín ró nde xīhna ñúhún, chi íne máá rí jiín ró jijnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Te vijna chi nuhūn rī condee rī jiín Yaā ní tají rúhū vēji ri. Te ni ɨɨn ró tu cájnūhun ró ndé nuū quihín rī. ");
INSERT INTO mibNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Chi máá jéē cácucuíhyá ndasɨ́ ni rō jeē ni cáhān rī súcuan jíín ró. ");
INSERT INTO mibNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Jendaá cahán rī jiín ró: Jeē váha máá ró jijnáhan ró cúu jeē quihín rī. Chi núu tú quihīn rī, te ma quíji Yaā chindéé ñáhán róhó te sáha ya jeē cóo sɨɨ̄ ni rō. Te núu cuahān rī, te tají rí yā quiji ya nuū rō. ");
INSERT INTO mibNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Te jeē quée yā, te stéén yā nuū ñáyuu ñayɨ̄vɨ jéē iyó cuéchi i, jíín ndese quɨ̄vɨcoo i ichi ndaā, jiín jéē sándaā Yaā Dios sɨquɨ̄ cuéchi i. ");
INSERT INTO mibNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Stéén yā jeē iyó cuéchi i, chi tu cácandíje i ruhū. ");
INSERT INTO mibNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Te stéén yā sɨquɨ̄ ichi ndaā, chi máá rí nuhūn rī nuū Tatá rī, te ma cóto ga rō nuū rī. ");
INSERT INTO mibNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Te stéén yā sɨquɨ̄ jeē sándaā Yaā Dios cuēchi ñayuu, chi je ni cundaā jeē jnahnú ndetū maá jéxeén jeē cujéhnu ini ñayɨ̄vɨ yáha. ");
INSERT INTO mibNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Te íyó cuéhē gā jnūhun cúní rī cahān rī jiín ró, te ma cúu jecūhun ni rō vijna. ");
INSERT INTO mibNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Te jeē quée maá Espíritu jeē steén jnūhun ndaā, te máá yá steén tāca jnúhun ndaā un núū rō. Chi ma cahán yā jeē maá yá, chi cahān yā tāca jéē jíni sōho ya cahán Yaā Dios. Te stéén yā sɨquɨ̄ tācá jniñu jeē coo. ");
INSERT INTO mibNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Te stéén yā jeē cujéhnu ri, chi nacastūhun yá nuū rō tāca jnúhun jeē jé ni cahān rī, te sáha ya jeē jécūhun ni rō. ");
INSERT INTO mibNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ndɨhɨ ndese cújéhnu Tátá rī, suni súcuan cújéhnu máá rí. Jeē yúcuan ní cahān rī jeē Espíritu Santo nacastūhun yá nuū rō tāca jnúhun jeē jé ni cahān rī, te sáha ya jeē jécūhun ni rō jijnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Jecu na te ma cóto ga rō nuū rī. Te jecu tucu quɨvɨ̄ te coto tucu ró núū rī, chi quinuhun rī nuū ndeé Tátá rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yūcuán na te sava tēe cáscuáha jíín yá, ni cacajnūhun jnáhan de: ¿Na jnūhun cúu jeē yáha jeē cahán yā jiín yó? Chi áchí yá jeē jecu na te ma cóto ga yō nuū yā, te jecu tucu quɨvɨ̄ te coto tucu yó núū yā, chi sɨquɨ̄ jeē quínuhun yā nuū ndeé Tátá yā. ");
INSERT INTO mibNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Na jnūhun cúu jeē yáha jeē cahán yā, jecu na? Tu cájecūhun ni yō na vé cúu jeē cahán yā. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Te ni jini Jesús jeē cácuni de cajnūhún de ya. Te ni cahān yā jiín de: ¿A cácajnūhun jnáhan ró na vé cúu jeē ni cáhān rī jiín ró jeē jecu na te ma cóto ga rō nuū rī, te jecu tucu quɨvɨ̄ te coto tucu ró núū rī? ");
INSERT INTO mibNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Jendaá cahán rī jiín ró jeē ndahyū rō jijnáhan ró te cucuíhyá ni rō, te ñayuu ñayɨ̄vɨ́ chi sa cusɨɨ̄ ni i. Te vēsú cucuíhyá ni rō, te sa ndusɨɨ̄ ni rō jeē cóto tucu ró núū rī. ");
INSERT INTO mibNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ɨɨn ñahan núu cuacuyajni scácu ña, te jéhnde chīji ña, chi je ni quee hora jeē scácu ña. Te núu je ni scácu ña sūchi lúlí, te tuá nahán ña jeē ní ndoho ña, chi cúsɨɨ̄ ni ña jeē ní cacu sēhe ña. ");
INSERT INTO mibNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Te suni súcuan cúu jeē cándoho ró vijna, chi cácucuíhyá ni rō jiín rí. Te jecu‑ni quɨvɨ̄ te coto jnáhan tucu yó, te cusɨɨ̄ ndasɨ́ ni rō. Te ni ɨɨn ma cúu casɨ jeē cúsɨɨ̄ ni rō. ");
INSERT INTO mibNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Te quɨvɨ̄ ún chi tú na vé cacān gā rō nuū rī. Chi jendaá cahán rī jiín ró jeē nuū maá Tátá rī cacān rō, te sáha ya ndɨhɨ jeē cájicān rō, sɨquɨ̄ jeē cácandíje ró rúhū. ");
INSERT INTO mibNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nde vijna te ná tu cacān rō nuū Tatá rī jeē jiín sɨ́hvɨ́ rí. Te vijna te na quéjéé ró cacān rō jiín sɨ́hvɨ́ rí, te nihīn rō, návāha cusɨɨ̄ ndasɨ́ ni rō. ");
INSERT INTO mibNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Tāca jnúhun yáha ní cahān yatá rí jiín ró. Te quee quɨvɨ̄ jeē ma cahán yatá gá rī jiín ró, chi sa suhva castūhun cájí rí nuū rō sɨquɨ̄ Tatá rī. ");
INSERT INTO mibNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Te quɨvɨ̄ ún chi cacān rō nuū Tatá rī sɨquɨ̄ jeē cácandíje ró rúhū. Te tu cáhán rī jiín ró jeē cacán tahú rī jehē rō nuū Tatá rī. ");
INSERT INTO mibNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Chi máá Tátá rī je cúndáhú ni yā rohó sɨquɨ̄ jeē cáhīyo manī rō jiín rí, te ni cacandíje ró jéē ndé nuū maá yá vēji ri. ");
INSERT INTO mibNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ni quenda ri nde nuū Tatá rī, te ni quee rī ini ñayɨ̄vɨ́. Te vijna te quenda ri ini ñayɨ̄vɨ́, te nuhūn tucu ri nuū Tatá rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Te ni cacahān tēe cáscuáha jíín yá: Vijna te cáhán cají ní, te tuá cahán yatá ní. ");
INSERT INTO mibNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vijna te cájini na jéē jiní ni ndɨvii cuɨtɨ, te tuá jíni ñúhún jéē cájnūhún ni ɨɨn ná níhín. Jeē yúcuan cácandíje ná jéē véji ní ndé nuū Yaā Dios. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Te ni cahān Jesús jiín de: ¿A ndé vijna te cácandíje ró naún? ");
INSERT INTO mibNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Te quiji quɨvɨ̄, te je ni quee, jeē cuité núu ró quínungoo ró ná vehe ná vehe ró, te stóo máñúhún ró ruhū. Te nasūu jéē quéndōo máñúhún rí, chi Tátá rī íne ya jiín rí. ");
INSERT INTO mibNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tāca jnúhun yáha ní cahān rī jiín ró návāha coo ndeyɨ́ coo sɨɨ̄ ni rō sɨquɨ̄ jeē cácandíje ró rúhū. Ini ñayɨ̄vɨ́ chi cánuú coto ró jnúndóho. Te vēsú súcuan te na cóo sɨɨ̄ ni rō, chi je ni quende rī poder tāca jéneé cáhīyo ini ñayɨ̄vɨ́. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Te ná ni cahān Jesús tāca jnúhun yáha, te ni ndacoto ya ichi ándɨvɨ́, te ni cahān yā: Tátā, je ni quee quɨvɨ̄ jeē ndóho ná. Vijna te stéén ni jéē cujéhnu máá ná jeē cúu ná Séhe ní, návāha suni máá ná steén na jéē cujéhnu máá ní. ");
INSERT INTO mibNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Chi ni sáha ní jéē ndíso jníñu ná sɨ́quɨ̄ tāca ñáyuu, návāha tāca ñáyuu jeē ni jéhe ní núū ná, cotecu i nɨ́ɨ́ cáni sáha ná. ");
INSERT INTO mibNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Te suhva cúu jnūhun cotecu i nɨ́ɨ́ cáni: suu jeē na cúni i níhín jéē mañúhún‑ni ní cúu Yaā ndaā, jiín jéē cúni i sāñá jeē cúu ná Jesucristo, Yaā ní tají ní. ");
INSERT INTO mibNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Je ni steén na núū ñáyuu ñayɨ̄vɨ jéē cujéhnu ní, te je sínu ná jniñu ní ndacu ní núū ná. ");
INSERT INTO mibNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Te vijna, Tátā, sáha ní jéē ndujéhnu tucu ná ndé nuū néne ní, nájnūhun cújéhnu ná jíín ní nde ná tu jecōo ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ñayuu jeē ní nacāji ní ini ñayɨ̄vɨ́, ni jēhe ní i nuū ná, te ni steén na núū i ndese Yaā cúu ní. Cuenta maá ní cúu i, te ni jēhe ní i nuū ná. Te ni cajetáhú i jnūhun ní, te ni casquícu i. ");
INSERT INTO mibNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Te vijna te cájini i jeē ndé nuū maá ní vēji tāca jéē iyó jíín ná. ");
INSERT INTO mibNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Chi tāca jnúhun ni cahān ni jíín ná, ní castūhun ná núū i, te ni cajetáhú i. Te ni cajini i jeē ní quenda ndije ná ndé nuū maá ní, te ni cacandíje i jeē maá ní ni tají sáña. ");
INSERT INTO mibNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Te jícán tahú na jéhē maá i jíjnáhan i. Tu jícán tahú na jéhē ñáyuu ñayɨ̄vɨ jéē tu cácandíje, chi sa jehē maá ñáyuu ni jéhe ni núū ná, chi cuenta maá ní cácuu i. ");
INSERT INTO mibNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Te tācá i jeē yɨ́hɨ i ndaha máá ná, suni cuenta maá ní cúu. Te tācá i jeē cúu i cuenta maá ní, suni cuenta maá ná cúu i. Te cástéén i ndese cújéhnu ná. ");
INSERT INTO mibNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Te tuá condee ná ini ñayɨ̄vɨ́. Te máá i chi quendōo i ini ñayɨ̄vɨ́, te máá ná chi najeē ná condee na jíín ní. Yaā iī Yaā ndoo cúu ní, Tátā. Te jíín poder ní condito ní táca ñáyuu ni jéhe ni núū ná, návāha ɨnuú na cóo ni i jíjnáhan i, nájnūhun cúu máá yó. ");
INSERT INTO mibNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Te jeē ní condee na jíín i ini ñayɨ̄vɨ́, te jíín poder ni ní condito ná i. Tāca ñáyuu ni jéhe ni núū ná, ni condito yúcún ná i. Te tu ní jéhe na jnúhun naa i jíjnáhan i, chi máá ɨɨn‑ni tēe jeē je cúu de tēe jnahnū ndetū, návāha squícu jnūhun yósó núū tútu iī. ");
INSERT INTO mibNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Te vijna te najeē na núū ní, te cáhán na táca jnúhun yáha jíín i níní jéē íne ga ná ini ñayɨ̄vɨ́, návāha na cóo sɨɨ̄ ndasɨ́ ni i nájnūhun cúsɨɨ̄ ni maá ná. ");
INSERT INTO mibNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ni castūhun ná jnūhun ní núū i. Te ni caquɨtɨ̄ ni ñayuu ñayɨ̄vɨ núū i, chi tuá cácuu i cuenta ñayɨ̄vɨ́, nájnūhun máá ná tu cúu ná cuenta ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Te tu jícán tahú na jéē quénehen ní i ini ñayɨ̄vɨ́, chi sa suhva jeē cóndito ní i nuū jexeén. ");
INSERT INTO mibNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nasūu cuenta ñayɨ̄vɨ cácuu i, nájnūhun máá ná jéē násūu cuenta ñayɨ̄vɨ cúu ná. ");
INSERT INTO mibNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Jíín jnúhun ndaā ní te sáha ní jéē coo ndoo coo iī i nuū ní. Tāca jnúhun cáhán maá ní cúu jnūhun ndaā. ");
INSERT INTO mibNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Te nájnūhun ni tají ní sāña ní quiji ná ini ñayɨ̄vɨ́, suni súcuan tají ná i nacani i jnūhun ní núū ñáyuu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Te jehē maá i cúu jeē jéhe ná máá ná cuu ná, návāha suni máá i coo ndoo coo iī i nuū ni jéē jiín jnúhun ndaā. ");
INSERT INTO mibNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Te nasūu máá ɨɨn‑ni jehē ñáyuu yáha jícán tahú na, chi suni jehē tāca gá ñáyuu jeē candíje i sāña núu na cúni sōho i jnūhun jeē nácani máá i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Te jícán tahú na jéē ɨnuú na cóo ni i jíjnáhan i. Nájnūhun ɨɨn‑ni cúu ní jíín ná, Tátā, te ɨɨn‑ni cúu ná jíín máá ní, suni súcuan na cóo ɨnuú i jíín yó. Te cúní na jéē ɨnuú na cóo ni i, návāha na cándíje ñayuu ñayɨ̄vɨ jéē maá ní ni tají ní sāñá. ");
INSERT INTO mibNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ni sajéhnu ná i nájnūhun ni sajéhnu ní sáña, návāha ɨnuú na cóo ni i, nájnūhun ɨnuú‑ni cúu yó. ");
INSERT INTO mibNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Te ndúú ná jiín i, te ndúú ní jiín ná, te súcuan te ɨnuú cuɨtɨ coo ni i jíjnáhan i. Yūcuán na te cuni ñayuu ñayɨ̄vɨ jéē maá ní ní tají ní sāña, jíín jéē maní ndasɨ́ ní jiín i nájnūhun manī ni jíín ná. ");
INSERT INTO mibNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tátā, máá ní ni jēhe ní i nuū ná. Te cúní na jéē cóyūcú i jíín ná nuū cóndee ná, návāha coto i ndese luu cújéhnu ná ni sáha ní. Chi íyó mánī ndasɨ́ ní jiín ná nde ná tu jecōo ñayɨ̄vɨ́ te nde vijna. ");
INSERT INTO mibNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yaā ndaā cúu ní, Tátā, te ñayuu ñayɨ̄vɨ́ tu jíní i níhín, te máá ná chi jíní na níhín. Te ñayuu yáha chi cájini i jeē maá ní ni tají sáña. ");
INSERT INTO mibNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ni steén na núū i jíjnáhan i ndese Yaā cúu ní. Te stéén gā na súcuan nuū i, návāha na cóo manī ndasɨ́ i jíín jnáhan i, nájnūhun íyó mánī ndasɨ́ ní jiín ná, te návāha condee ná ini anuá i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Te nuū ní cuu ni cahān Jesús tāca jnúhun yáha, te ni quenda ya jiín tée cáscuáha jíín yá, cuahān yā ɨnga lado yuu Cedrón. Te yūcuan íyó ɨɨn huerto nuū ní quɨ̄vɨ ya jiín tée cáscuáha jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Te Judas, tēe jeē nastúu de ya, suni jíní de lugar un, chi cuehē jínu ni nataca Jesús yūcuan jíín tée cáscuáha jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Te ni jinū de yūcuan jíín ɨɨn grupo soldado jiín jecu policía cándito templo, jeē ní catají sutū cácujéhnu jíín tée grupo fariseo. Te cándiso de machete, te cájnɨɨ de linterna jiín yɨtɨ. ");
INSERT INTO mibNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Te Jesús je jíní yā tāca jnúndóho jeē véji sɨquɨ̄ yā. Te ni quenda ya ichi núú de, te ni cahān yā: ¿Ndé ɨɨn cánanducú ró? ");
INSERT INTO mibNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Te ni cacahān de jíín yá: Jesús tēe ñuu Nazaret cánanducú rí. Te ni cahān yā: Máá rí cúu. Te Judas, tēe jeē nástúu de ya, suni íne de jíín tée ún. ");
INSERT INTO mibNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Te jeē súcuan ni cahān yā, máá rí cúu, te ni cajica yátá de, te ni cacotúú‑ni de. ");
INSERT INTO mibNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yūcuán na te ni cajnūhún tucu ya de: ¿Ndé ɨɨn cánanducú ró? Te ni cacahān de: Jesús tēe ñuu Nazaret. ");
INSERT INTO mibNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Te ni cahān Jesús: Je ni cachi rī jeē maá rí cúu. Te núu ruhū cánanducú ró, te máá‑ni ri jnɨɨ ró, te tēe yáha na quíngoo de. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Súcuan ni cuu návāha na squícu jnūhun jeē ni cáhān yā jiín Tátá yā: Tu ní jéhe na jnúhun naa ni ɨɨn tēe jeē ni jéhe ni núū na, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Te Simón Pedro ndíso de ɨɨn espada. Te ni tava de, te ni jehnde de sōho lado váha ɨɨn tēe nání Malco. Te tēe un cúu de mozo maá sútū cujéhnu. ");
INSERT INTO mibNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Te ni cahān Jesús jiín Pedro: Nachuvāha espada rō ini cubierta. ¿A tu cánuú jéē ndóho ri jnūndóho yáha jeē ni sándaā Tatá rī jeē ndóho ri? Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yūcuán na te tācá soldado un, jíín capitán de, jíín táca policía tēe hebreo un, ni cajnɨɨ de Jesús, te ni cajihni de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Te xīhna gā vehe Anás cuangoo de jíín yá. Te tátá chīsó Caifás cúu Anás. Te Caifás cúu máá sútū cujéhnu ga cuiyā ún. ");
INSERT INTO mibNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Te suu de ni cachi nuū jnáhan de hebreo jeē cánuú jéē cúū ɨɨn tēe jehē nación de. ");
INSERT INTO mibNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Te Simón Pedro jiín ɨnga tēe scuáha, cándiquīn de Jesús cuangoo de yatā yā. Te ɨnga tēe scuáha ún chi jíní jnáhan de jíín sútū cujéhnu. Jeē yúcuan ní quɨ̄vɨ de jíín Jesús ini patio vehe sutū cujéhnu ún. ");
INSERT INTO mibNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Te Pedro ni quendōo de yatā yehyɨ́. Te máá tée scuáha jéē jiní jnáhan jíín sútū cujéhnu ún, ni quenda de ni cahān de jíín ñahan ndíto yéhyɨ́, te ni squɨ́vɨ de Pedro ini patio. ");
INSERT INTO mibNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yūcuán na te ñahan ndíto yéhyɨ́ un ní cajnūhún ña Pedro: ¿A násūú ɨɨn tēe scuáha jíín tée índichi nuū sutú un cúu ró? Te ni cahān de: Nasūu cúu ri, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Te tāca mozo jiín policía un ní cascáyú de ñuhūn jiín tɨ́cāyɨ, chi mījin sáha. Te cáhīin de cánasaā de. Te suni índichi Pedro, násaā de jíín táca tée ún. ");
INSERT INTO mibNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Te sutū cujéhnu un ní stichí de Jesús ndé‑ni cúu tēe cáscuáha jíín yá, jiín na jnūhun cúu jeē steén yā. ");
INSERT INTO mibNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Te ni cahān Jesús: Níní ní cahān rī nuū chitú ñáyuu, ni cajini sōho ndɨhɨ ñayuu. Te níní ní steén rī jnūhun ini tācá vehe iī sinagoga jiín ini templo cáhnu nuū ndutútú ndɨvii jnáhan yó hebreo. Te tú ni ɨɨn jnūhun ní cáhán sāhi rí. ");
INSERT INTO mibNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Te naun cájnūhun ró ruhū? Cajnūhun ñáyuu ní cajini sōho jnūhun ni cahān rī, te máá i cachi ndese ni cahān rī. Chi cájini i ndese ni cahān rī. ");
INSERT INTO mibNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Te jeē ni cáhān Jesús súcuan, te ɨɨn policía ndíto templo jeē índichi de yūcuán, ní cani‑ni de nuū yā. Te ni cahān de jíín yá: ¿A súcuan cáhán rō jiín sútū cujéhnu naún? ");
INSERT INTO mibNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Te ni cahān Jesús: Núu ni cahān rī ɨɨn jnūhun néé, cachi na jnūhun néé ní cahān rī. Te núu tu ní cáhán rī ɨɨn jnūhun néé, ¿te naun cáni ró rúhū? achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yūcuán na te Anás, sutū cujéhnu un, ní tají de ya, núhní yā cuahān yā nuū Caifás, tēe cúu máá sútū cujéhnu ga. ");
INSERT INTO mibNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Te níní jéē súcuan cúu, te índichi‑ni Pedro, násaā de yuñúhún. Te ni cacahān jiín de: ¿A násūú ɨɨn tēe scuáha jíín tée un cúu ró, chí naún? Te máá de tu ní cáchi de: Nasūu cúu ri, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yūcuán na te ɨɨn mozo sutū cujéhnu, jnáhan tēe jeē ní jehnde Pedro sōho, ni cahān jiín de: ¿A násūu máá ró cúu jeē ní jito ri jiín de ini huerto? ");
INSERT INTO mibNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Te Pedro tu ní cáchi tucu de. Te ni cana‑ni líhli. ");
INSERT INTO mibNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yūcuán na te ni quendacoo de jíín Jesús vehe Caifás, cuangoo de jíín yá nde palacio tēe nación Roma jeē cúu gobernador. Te je cuacundijin. Te ñayuu hebreo tu ní quɨ́vɨcoo i ini palacio, návāha tu stɨ́vɨ i ley i jeē cahán jeē ma quɨ́vɨ i ini vehe ɨɨn ñayuu jeē násūú hebreo cúu. Chi núu súcuan te ma cúu cuxíni i vico pascua jeē cóo ɨnga quɨvɨ̄ ún. ");
INSERT INTO mibNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yūcuán na te ni quenda Pilato, tēe cúu gobernador, ni cahān de jíín i jíjnáhan i: ¿Na cuēchi cájicān rō sɨquɨ̄ tée yáha? ");
INSERT INTO mibNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Te ni cacahān i: Núu jeē násūu tée cúnéé cúu tēe yáha, te ma jnɨ́ɨ ná de jeē quíndeca ná de nuū ni núú, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Te ni cahān Pilato: Cuángoo jíjnáhan ró, te sándaā rō sɨquɨ̄ de jíín ley cánevāha máá ró. Te ni cacahān ñayuu hebreo un: Máá ná jeē cácuu ná ñáyuu hebreo, tú na permiso cánevāha ná jéē cáhni ná ni ɨɨn ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Súcuan ni cacahān i návāha squícu jnūhun jeē ní cachi Jesús jeē quɨ́vɨ ya ndaha tēe Roma te cahni de ya jicā cruz. ");
INSERT INTO mibNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Te ni ndɨ̄vɨ Pilato ini palacio, te ni cana de jeē na quíji Jesús. Te ni cajnūhún de ya: ¿A máá ró cúu Rey ñayuu hebreo naún? ");
INSERT INTO mibNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Te ni cahān Jesús jiín de: ¿A cájnūhun ró ruhū jeē súcuan jéni ni maá ró, chí jéē ní cacastūhun ñáyuu hebreo nuū rō? ");
INSERT INTO mibNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Te ni cahān Pilato: ¿Chí tée hebreo cúu ri jeē cúni rī? Ñayuu nación maá ró jiín sútū cácujéhnu ni cachihi róhó ndaha ri. ¿Na vé ni sáha ró núu súcuan? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Te ni cahān Jesús: Nasūu jéē ndácu ri jniñu nájnūhun cándacu tāca rey ñayɨ̄vɨ yáha. Chi núu jeē ñáyuu ñayɨ̄vɨ ní casáha jeē cúu ri rey, yūcuán na te tēe cándiquīn ruhū, cuajnáhan de návāha ma quɨ́vɨ ri ndaha jnáhan ri hebreo nuú. Te nasūu núū ñayɨ̄vɨ yáha cúu jeē ndácu ri jniñu vijna. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yūcuán na te ni cahān Pilato jiín yá: ¿Te á ɨɨn rey cúu ró jéē súcuan? Te ni cahān Jesús: Rey cúu ri, nájnūhun cáhán rō. Ni quiji ri ni cacu ri ini ñayɨ̄vɨ yáha návāha nacani ri jnūhun ndaā. Te ndɨhɨ ñayuu cájetáhú jnúhun ndaā, cájini nahín i jnūhun cáhán rī. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Te ni cahān Pilato: ¿Ndese cuni yō ndé ɨɨn cúu máá jnúhun ndaā? Te jeē ni cáhān de jnūhun yáha, te ni quenda tucu de nuū ñáyuu hebreo. Te ni cahān de jíín i: Tú cuɨtɨ na cuēchi níhín rī sɨquɨ̄ de. ");
INSERT INTO mibNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Te íyó costumbre maá ró jijnáhan ró jéē vico pascua te siáá rī ɨɨn tēe íne vecāa nuū rō. ¿Te á tu cácuni rō jeē siaá rī Rey rō nuū rō? Achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yūcuán na te ndɨvii i ni cacana jee tucu i: Ma siaá ni tée jíñá, chi Barrabás siaá ni, áchí i. Te tēe cuíhná cúu Barrabás. ");
INSERT INTO mibNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yūcuán na te ni cahān Pilato jeē na jnɨ́ɨ soldado Jesús, te cani de ya jiín cuarta ñɨɨ. ");
INSERT INTO mibNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Te ni casáha de ɨɨn corona iñu, ni cachuhun de xinī yā. Te ni cachuhun de ya ɨɨn sahma cuehé ndíhí jéē cúu sahma rey. ");
INSERT INTO mibNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Te ni jecondichi de nuū yā, te ni cacahān catá de: Nacā jeē váha rey cúu Rey ñayuu hebreo. Te ni cacani de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Yūcuán na te ni quenda Pilato ɨnga jínu, te ni cahān de jíín ñáyuu: Yāhá condēhe ró tava rī de, návāha na cúni rō jeē tú na cuēchi níhín rī sɨquɨ̄ de. ");
INSERT INTO mibNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Te ni quenda Jesús, ñúhun ya corona iñu jíín sahma cuehé ndíhí un. Te ni cahān Pilato jiín i: Yāhá condēhe ró de jíjnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Te nuū ní cajito sutū cácujéhnu jíín táca policía nuū yā, te ni cacana jee de: Cata caa ní de jicā cruz, na cúū de. Te ni cahān Pilato: Núu súcuan te najnɨɨ máá ró de te cahni rō de. Chi ruhū, tú na cuēchi níhín rī sɨquɨ̄ de. ");
INSERT INTO mibNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Te ni cacahān ñayuu hebreo un: Cánevāha ná ɨɨn ley, te jeē sɨquɨ́ ley un cánuú jéē cúū de, chi sáha de máá de jeē Séhe Yaā Dios cúu de. ");
INSERT INTO mibNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Te jeē ní jini sōho Pilato jnūhun yáha, te víhyá gā ni yūhú de. ");
INSERT INTO mibNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Te ni ndɨ̄vɨcoo tucu de ini palacio, te ni cajnūhún de Jesús: ¿Ndé nuū véji ró? Te tu ní cáhán cuɨtɨ Jesús jiín de. ");
INSERT INTO mibNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yūcuán na te ni cahān de jíín yá: ¿Naun tu cáhán rō jeē cahán rī? ¿A tu jíní rō jeē ndíso jníñu ri jeē cáhni rī rohó jícā cruz, te suni ndíso jníñu ri jeē siaá rī rohó quíhīn rō? ");
INSERT INTO mibNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Te ni cahān Jesús: Núu tu ní sáha Yaā Dios jeē ndíso jníñu ró, te tú na vé cúu sáha ró sɨ́quɨ̄ rī. Jeē yúcuan tēe jeē ní nacuāha ruhū ndaha ró, cuēchi xeēn gā condee sɨquɨ̄ de vēsú maá ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yūcuán na te nde hora un ndúcú ndéyɨ́ Pilato ndese siáá de ya. Te ñayuu hebreo chi cácana jee i: Núu siáá ni tée jiñā, te tu cúu ní amigo rey Roma jeē cujéhnu ndácu jniñu núu súcuan. Chi tāca tée jeē sáha de rey maá de, núu súcuan te cúu de enemigo sɨquɨ̄ rey un. Achí i. ");
INSERT INTO mibNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Te jeē ní jini sōho Pilato jnūhun yáha, te ni ndacu de jniñu jeē na quénda Jesús ini vehe quiji ya. Te ni cucōo de silla nuū cúndaā jniñu, nuū máni máá yúū ni jecāva, te lugar un nání Gabata nuū yúhu hebreo. ");
INSERT INTO mibNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Te cuacuu cahuxī uū, te jehíni quɨvɨ̄ ún quejéé vico pascua. Te ni cahān Pilato jiín ñáyuu hebreo: Yāha índichi maá rey rō. ");
INSERT INTO mibNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Te ni cacana jee i: Na cúū de. Cata caa ní de jicā cruz, achí i. Te ni cahān Pilato jiín i: ¿A jéē cata caa rī rey rō jicā cruz naún? Te sutū cácujéhnu un ní cacahān de: Tuá na ɨnga rey cánevāha ná jíjnáhan ná, chi máá‑ni rey Roma jeē cujéhnu ndácu jniñu nuū ná. ");
INSERT INTO mibNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yūcuán na te Pilato ni nacuāha de ya nuū i jeē na cúū yā jicā cruz. Te ni cajnɨɨ i ya cuangoo i jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Te ni quenda Jesús, ndíso ya cruz yā, cuangoo de jíín yá ɨɨn lugar nuū naní Yɨquɨ Xíní, te nuū yúhu hebreo naní Gólgota. ");
INSERT INTO mibNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Te yūcuan ní cacata caa de ya jicā cruz. Te suni ni cacata caa de uū tēe nuū uū gā cruz, ɨɨn ɨɨn de ɨɨn lado yā, te máá Jesús mēhñú. ");
INSERT INTO mibNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Te suni ni ndacu Pilato jniñu jeē na cóndee jnūhun xinī cruz yā, jeē cahán: Tēe yáha cúu Jesús ñuu Nazaret, Rey ñayuu hebreo, achí. ");
INSERT INTO mibNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Te cuehē ñayuu hebreo ni cacahu i jnūhun yáha, chi máá yajni yuñúū cúu nuū ní cacata caa de ya. Te jnūhun un yósó jíín yuhu hebreo jiín griego jiín latín. ");
INSERT INTO mibNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Te tāca sútū cácujéhnu nuū ñáyuu hebreo, ni cacahān de jíín Pilato: Ma tée ní jéē cúu de Rey ñayuu hebreo, chi sa suhva tee ní jéē maá de ni cahān jeē cúu de Rey ñayuu hebreo. ");
INSERT INTO mibNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Te ni cahān Pilato: Ma násama ri jeē jé ni ndacu ri jniñu ni jecondee. ");
INSERT INTO mibNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Te soldado un, nuū ní cuu ni cacata caa de Jesús jicā cruz, te ni caquihin de sahma ya, te ni cajehnde de ni nduu cuūn parte, te ɨɨn ɨɨn parte ni cuu ɨɨn ɨɨn soldado un. Te suni ni caquihin de camisa yā. Te camisa un tu ní quícu, chi ni cunu nɨ́ɨ́. ");
INSERT INTO mibNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Te ni cacahān maá de: Ma cáhnde yō, chi vāha ga na sáha yó sorteo, te na cóndēhe yó ndé ɨɨn yó níhīn, achí de. Te súcuan ni squícu jnūhun yósó núū tútu iī nde jenahán jéē cahān Jesús: Ni caquihin de sahma ri cuu máá de. Te ni casáha de sorteo sɨquɨ̄ camisa rī. Achí. Súcuan ni casáha soldado un. ");
INSERT INTO mibNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Te yajni cruz nuū ndíta caa Jesús íne náná yā, jiín cúhū ña María ñasɨhɨ́ Cleofas, jiín María ñuu Magdala. ");
INSERT INTO mibNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Te ni jito Jesús nuū naná yā jiín núū tée scuáha jeē maní gā yā jiín, suni índichi de yūcuán. Te ni cahān yā jiín náná yā: Nánā, nde vijna te máá de nucuɨñɨ̄ de cuu de sēhe ní. ");
INSERT INTO mibNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yūcuán na te ni cahān yā jiín tée scuáha ún: Nde vijna te cuu ña nájnūhun náná rō, achí yá. Te nde hora un ní cana de ña cuacondee ña vehe de condito de ña. ");
INSERT INTO mibNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yūcuán na te ni jini Jesús jeē jé ni jīnu tācá jniñu jeē cánuú ndoho ya. Te návāha squícu jnūhun cáhán tutu iī, te ni cahān yā: Jíchí rī ndute, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Te yūcuan íin ɨɨn tɨndohō ñúhun chitú vinagre iyá. Te ni cachundaji de ɨɨn cachī nuū vinagre un, te ni catee de xinī ɨɨn ndaha yújnu hisopo, te ni catee de yuhu ya jeē cóho ya. ");
INSERT INTO mibNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Te ná ni jihi ya vinagre un, te ni cahān yā: Je ni jīnu, áchí yá. Te ni cāyɨ́‑ni xinī yā, te ni jihī‑ni ya. ");
INSERT INTO mibNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Te ɨnga quɨvɨ̄ ún coo vico pascua. Te tēe hebreo tu cácuni de jeē cóndita caa ndɨ̄yɨ ún jícā cruz quɨvɨ̄ ndétātú un. Chi quɨvɨ̄ ndétātú jeē cúu vico pascua, iī ndasɨ́ gá vēsú tāca gá quɨvɨ̄ ndétātú. Te ni cacahān de jíín Pilato jeē na ndácu de jniñu jeē jnahnú sɨ̄hɨn tēe cándita caa, te na cújiyo de jicā cruz. ");
INSERT INTO mibNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Te ni quecoo soldado, te ni cajehnū de sɨ̄hɨn ɨɨn tēe jeē ndíta caa jíín yá, te suni súcuan ɨnga de. ");
INSERT INTO mibNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Te nuū ní quecoo de nuū Jesús, te ni cajito de jeē jé ni jihī yā. Jeē yúcuan tu ní cájehnū de sɨ̄hɨn ya. ");
INSERT INTO mibNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Te ɨɨn soldado chi ni cují de lanza xiin ya, te ni cane‑ni nɨñɨ̄ jiín ndute. ");
INSERT INTO mibNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Te máá rí jeē tée tutu yáha, ni jito ri jeē súcuan ni cuu, te nácani ndaā rī jnūhun ndese ni cuu. Te jíní rī jeē iyó ndáā jnūhun cáhán rī, návāha suni candíje máá ró jijnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Chi súcuan ni cuu návāha squícu jnūhun cáhán tutu iī: Ma cahnú de ni ɨɨn yɨquɨ ya, achí. ");
INSERT INTO mibNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Te suni ɨnga jnūhun cáhán tutu iī: Ɨɨn quɨvɨ̄ te coto i nuū Yaā jeē ní cují i lanza, achí. ");
INSERT INTO mibNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Te ni cuu tāca jéē yáha. Te íyó ɨɨn tēe ñuu Arimatea jeē naní José, te cúu de tēe cándíje Jesús. Te yuhu‑ni cándíje de, chi yúhú de jnáhan de hebreo. Te ni cahān ndahú de jíín Pilato jeē na cuáha jnūhun quihin de yɨquɨ cúñu Jesús. Te ni jēhe Pilato jnūhun. Yūcuán na te cuahān José, ni snúu de yɨquɨ cúñu Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Te suni ni jinū Nicodemo, tēe ni quiji nuū Jesús ɨɨn jecuáā. Te ndíso de nájnūhun ocō uxī kilo sūje uvuā jeē ní saca jnáhan jíín yúcū áloe. ");
INSERT INTO mibNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Te ndɨndúú de ni caquihin de yɨquɨ cúñu Jesús, te ni cachusúcún de jíín tira sahma jeē ni quɨ́vɨ yucū jeē jeén asɨ̄n ún, nájnūhun íyó costumbre maá ñáyuu hebreo jeē cáchindūji i ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Te yajni nuū ni jíhī Jesús íyó ɨɨn huerto. Te nuū huerto un ndéé ɨɨn yaū jeē ní caan jeé jicā ɨɨn cava, nuū ná tu quindūji ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Te yūcuan ní cachindūji de Jesús, chi íne yajni yaū ndɨ̄yɨ ún. Chi je yajni quejéé quɨ́vɨ̄ ndétātú de jeē cácuu de ñayuu hebreo, te tú na ley chindūji de ndɨ̄yɨ núu je ni quejéé quɨ́vɨ̄ ún. ");
INSERT INTO mibNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Te jenéhen quɨvɨ̄ domingo ni jinū María ñuu Magdala nuū ní yɨndūji Jesús, te yɨ́nee gā cúu. Te ni jito ña jeē ní cujiyo yuū ndihyú yuyáú ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yūcuán na te jínu ña cuahān ña nuū Simón Pedro jiín núū ɨnga tēe scuáha ún jeē maní gā Jesús jiín. Te ni cahān ña jíín de: Ni catava de Jitoho yō nuū ní yɨndūji ya, te tu cájini yō ndé nuū ní cachune de ya, achí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Te ni quendacoo Pedro jiín ɨnga tēe scuáha ún, cuácondēhé de yaū ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Te cájinu tayɨ́ ndɨndúú de. Te ɨnga tēe scuáha ún, nīhin ga ni jinu de vēsú Pedro. Te xīhna gā de ni jinū yaū ndɨ̄yɨ. ");
INSERT INTO mibNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Te ni scáyɨ de máá de, te ni jito nihni de ini yaū. Te ni jito de jeē tira sahma un cáyūcu máá na. Te tu ní quɨ́vɨ de. ");
INSERT INTO mibNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Te sáá te ni jinū Simón Pedro jeē ndiquín jnáhan de vēji de jíín ɨnga tēe ún. Te ni quɨ̄vɨ de nuū ní yɨndūji Jesús. Te suni ni jito de jeē tira sahma cáyūcu máá na. ");
INSERT INTO mibNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Te ni jito de sahma jeē ni ñúsúcún xínī Jesús, tu cátú jíín tira sahma, chi ni natuu te cátú sɨ́ɨn. ");
INSERT INTO mibNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yūcuán na te suni ni quɨ̄vɨ ɨnga tēe scuáha jeē ni jínū xīhna gā nuū ní yɨndūji ya. Te ni jito de ndese íyó, te ni candíje de jeē ní natecu yā. ");
INSERT INTO mibNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Chi nde ná tu jinūcoo de yaū ndɨ̄yɨ, te tu ní jécūhun ni de jnūhun cáhán tutu iī, jeē jíni ñúhún natecu yā núu je ni jihī yā. ");
INSERT INTO mibNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yūcuán na te ndɨndúú tée cáscuáha ún cuanungoo de vehe de. ");
INSERT INTO mibNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Te María índichi ña ndáhyú ña nuū ní yɨndūji ya. Te níní ndáhyú ña, te ni scáyɨ ña máá ña, ni jito nihni ña ini yaū ún. ");
INSERT INTO mibNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Te ni jito ña uū ndajéhé andɨvɨ́, cáñuhun ya sahma cuijín. Te ɨɨn ya néne ichi xíní, te ɨnga ya néne ichi núū jehé nuū ni cátu yɨquɨ cúñu Jesús. ");
INSERT INTO mibNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Te ni cacahān yā jiín ña: ¿Najehē ndahyú rō? Te ni cahān ña: Ni catava de Jitoho ná, te tu jíní na ndé nuū ní cachune de ya. ");
INSERT INTO mibNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Te jeē ni cáhān ña súcuan, te ni ndió cóto ña, te ni jito ña nuū Jesús jeē índichi yā yūcuán. Te tu ní nácuni ña jeē maá yá cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Te ni cahān yā jiín ña: ¿Najehē ndahyú rō? ¿Ndé ɨɨn nánducú ró? achí yá. Te máá ña jéni ni ña jeē tée ndíto huerto cúu ya. Te ni cahān ña jíín yá: Núu máá ní ni quenehen ní yá, te cachi ní ndé nuū ni jéchune ní yá, te na quínuquihin ná yá, achí ña. ");
INSERT INTO mibNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Te ni cahān Jesús jiín ña: María, achí yá. Te jeē ni cáhān yā súcuan, te ni nacuni ña ya, te ni ndió cóto ña, te ni cahān ña jíín yuhu hebreo: Raboni, achí ña. Te jnūhun un cúní cahān, Maestro. ");
INSERT INTO mibNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Te ni cahān Jesús jiín ña: Ma quehé ró rúhū, chi ná tu ndaa ri quinuhun rī nuū Tatá rī. Te cuáhán núū tācá hermano rī, tēe ni cascuáha jíín rí, te cachi rō nuū de jeē ndaa ri quinuhun rī nuū Tatá rī, jeē suni Tátá maá ró jijnáhan ró cúu. Te cúu ya Yaā Dios maá rí jiín Yaā Dios maá ró jijnáhan ró. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yūcuán na te María ñuu Magdala un, cuáhān ña, te ni castūhún ña nuū tée cáscuáha un jéē ní jito ña nuū maá Jítoho yō jiín jéē ni cáhān yā jnūhun yáha jíín ña. ");
INSERT INTO mibNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Te jeē ní cuaa máá quɨ́vɨ̄ domingo un, te cáhīin tútú tée cáscuáha ún ini ɨɨn vehe. Te cándihyū yehyɨ́, chi cáyūhú de jnáhan de hebreo jeē coto xeēn i de. Te ni quee‑ni Jesús, ni jecuɨñɨ̄ yā mēhñú de vēsú ndihyú yehyɨ́, te ni cahān yā jiín de: Ndeyɨ́ sɨ́ɨ̄ coo ni rō jijnáhan ró, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Te ná ni cahān yā súcuan, te ni steén yā ndaha ya jiín xiin ya nuū de. Te ni cacusɨɨ̄ ni tēe cáscuáha un jéē ní cajito de nuū maá Jítoho yō. ");
INSERT INTO mibNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yūcuán na te ni cahān tucu Jesús: Ndeyɨ́ sɨ́ɨ̄ coo ni rō jijnáhan ró. Te nájnūhun ni tají Tátá rī ruhū ini ñayɨ̄vɨ́, suni súcuan tájí rí rohó nacani ró jnúhun ri nuū ñáyuu. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yūcuán na te ni tɨ̄vɨ tachī yā nuū de jíjnáhan de. Te ni cahān yā: Vijna te ni canihīn rō Espíritu Santo. ");
INSERT INTO mibNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Te tāca ñáyuu jeē cone cáhnu ni rō nuū cuéchi i, núu súcuan te coo jnūhun cáhnu ni nuū cuéchi i. Te núu tú cone cáhnu ni rō nuū cuéchi i, te ma cóo jnūhun cáhnu ni nuū cuéchi i. Achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Te Tomás, tēe ni cacu cuátí, ɨɨn jnáhan jeē uxí uū tēe cáscuáha jíín yá, tu ní íne de quɨvɨ̄ jeē ní nane Jesús nuū tāca gá tēe cáscuáha. ");
INSERT INTO mibNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yūcuán na te sava ga tēe cáscuáha un, ní cacahān de jíín Tomás: Ni cajito ri nuū maá Jítoho yō. Te ni cahān Tomás: Núu tú coto ri nuū ni túji ndaha ya ni sáha ndūyu cāa, te núu tú chune ri xinī ndáha ri nuū ni íne ndūyu cāa, te núu tú chune ri ndaha ri xiin ya, te ma candíje cuɨtɨ rī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Te nuū uná quɨvɨ̄, te tēe cáscuáha un cáhīin tútú tucu de ini ɨɨn vehe. Te íne Tomás jiín de. Yūcuán na te ni quee‑ni tucu Jesús, ni jecuɨñɨ̄ yā mēhñú de, vēsú cándihyū yehyɨ́. Te ni cahān yā jiín de: Ndeyɨ́ sɨ́ɨ̄ coo ni rō jijnáhan ró. ");
INSERT INTO mibNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Te ni cahān‑ni ya jiín Tomás: Chune xinī ndáha ró ini ndaha ri yāhá te coto ró. Te scáá ndaha ró, te chune ró xiin ri nuū ni tújī. Te ma cáni sɨquɨ́ gá ni rō, chi sa suhva na cándíje ró. ");
INSERT INTO mibNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Yūcuán na te ni cahān Tomás jiín yá: Aī, Jitoho maá ná jiín Yaā Dios maá ná cúu ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Te ni cahān Jesús jiín de: Tomás, nde ni jito ró núū rī, te ni candíje ró. Te yōhyo ndetū tāca ñáyuu jeē candíje ruhū vēsú tu ní jíto i nuū rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Te suni ni sáha Jesús cuehē gā jniñu jéhnu jeē ni stéén yā poder yā nuū tée cáscuáha jíín yá, jeē tu yósó núū tútu yáha. ");
INSERT INTO mibNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Te tācá jniñu yáha ní tee ri návāha candíje ró jijnáhan ró jéē Jesús cúu Cristo, maá Séhe Yaā Dios. Chi jeē candíje ró yá, te cotecu rō nɨɨ́ cáni sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Te ni cuu jecu quɨvɨ̄, te ɨnga jínu ni nane Jesús nuū tée cáscuáha jíín yá, jeē cáhīin de yumar Tiberias. Te suhva ni steén yā maá yá nuū de: ");
INSERT INTO mibNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Cáhīin tútú Simón Pedro, jiín Tomás, tēe ni cacu cuátí, jiín Natanael, tēe ñuu Caná ndañúū Galilea, jiín ndɨndúú séhe Zebedeo, jiín úū gā tēe cáscuáha. ");
INSERT INTO mibNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Te ni cahān Simón Pedro jiín de jíjnáhan de: Quíjnɨɨ ri chācá. Te ni cacahān de: Suni quingoo ri jiín ró. Te cuangoo de, te ni quɨ̄vɨcoo de ɨɨn barco. Te tu ní cánihīn cuɨtɨ de tɨ jecuáā yúcuan. ");
INSERT INTO mibNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Te jeē cuácundijin, te íne Jesús yumar. Te tēe cáscuáha ún, tu ní cánacuni de jeē maá yá cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yūcuán na te ni cahān yā jiín de: Aá rō jijnáhan ró, ¿á ní canihīn rō chācá caji yō? Te ni cacahān de: Tú cuɨtɨ, achí de. ");
INSERT INTO mibNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yūcuán na te ni cahān yā jiín de: Sɨ́ngava ñunu ró ichi lado váha barco, te nihīn rō tɨ̄. Te ni casɨ́ngava de ñunu, te tuá ní cúu cuɨtɨ natava de, jeē ni quɨ́vɨcoo cuehē ndasɨ́ cháca. ");
INSERT INTO mibNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yūcuán na te tēe scuáha jeē maní gā Jesús jiín, ní cahān de jíín Pedro: Máá Jítoho yō cúu, áchí de. Te jeē ní jini sōho Simón Pedro jeē maá Jítoho yō cúu, te ni nachuhun de sahma de, chi ni tava de jeē sájniñu de. Te ni ndava‑ni de nuū mar cuahān de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Te tāca gá tēe cáscuáha ún, vendicoo de jíín barco yundúte, cástáa de ñunu ñúhun chitú cháca. Chi tu jícá cáhīin de jíín ñuhun íchi, chi nájnūhun ciento‑ni metro cúu. ");
INSERT INTO mibNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Te nuū ní quendacoo de ini barco, te ni cajito de jeē nduhvá tɨ̄cua ñuhūn, te íne staā jiín ɨɨn chācá chíhyó. ");
INSERT INTO mibNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Te ni cahān Jesús jiín de: Cuáquihin jecu chācá jéē sa ní cajnɨɨ ró, na táu yó, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Te ni quɨ̄vɨ Simón Pedro ini barco, te ni stáa de ñunu, ni quee de jíín ndé nuū ñúhun íchi. Te ñúhun chitú cháca náhnu, ɨɨn ciento uū xico uxī unī tɨ̄ cúu. Te vēsú ɨɨn súcuan tɨ ñúhun, te tu ní táhndé ñunu. ");
INSERT INTO mibNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Te ni cahān Jesús jiín de: Nehen jijnáhan ró na cási ni yō. Te ni ɨɨn tēe cáscuáha ún tu ní cúndeyɨ́ ni de cajnūhún de ya núu ndé ɨɨn cúu ya. Chi je cájini de jeē maá Jítoho yō cúu ya. ");
INSERT INTO mibNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Te ni quindēhe Jesús yuñúhún, te ni quihin ya staā ún, te ni jēhe ya nuū de, te suni súcuan chācá un. ");
INSERT INTO mibNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yāha cúu vuelta unī jeē ní nane Jesús nuū tée cáscuáha jíín yá, ná ni natecu yā. ");
INSERT INTO mibNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Te nuū ní cuu ni cajesi ni de, te Jesús ni cajnūhun yá Simón Pedro: Simón sēhe Jonás, ¿á mánī gā rō jiín rí vēsú tāca gá tēe yáha? Te ni cahān de: Je jíní ni jéē maní na jíín ní, achí de. Te ni cahān yā jiín de: Núu súcuan te stéén rō jnūhun ri nuū ñáyuu cácuu nájnūhun londe ri. ");
INSERT INTO mibNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Te ni cajnūhun yá de vuelta uū: Simón sēhe Jonás, ¿á mánī rō jiín rí? Te ni cahān de jíín yá: Je jíní ni jéē maní na jíín ní, achí de. Te ni cahān yā: Condito ró ñáyuu cácuu nájnūhun lanchi ri núu súcuan. ");
INSERT INTO mibNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Te ni cajnūhún tucu ya de vuelta unī: Simón sēhe Jonás, ¿á mánī rō jiín rí? Te ni cucuíhyá ni Pedro jeē ní cajnūhun yá de vuelta unī núu manī de jíín yá. Te ni cahān de: Máá ní jiní ni ndɨhɨ, te jíní ni jéē maní na jíín ní. Te ni cahān yā: Núu súcuan te stéén rō jnūhun ri nuū ñáyuu cácuu nájnūhun lanchi ri. ");
INSERT INTO mibNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Te jendaá cahán rī jiín ró jeē nde ná suchí ró, te ni quihin máá ró sahma ró, te ni jica ró ndé nuū cuní maá ró. Te núu na yɨ́ɨ ró, te nasūu jéē cuní maá ró, chi ɨnga ñayuu quindēca i róhó nuū tu cúní rō quihīn rō. Te scáá rō ndɨndúú ndaha ró jéē cuu rō. ");
INSERT INTO mibNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jnūhun yáha ní cahān yā jeē ni stéén yā jeē cóndita caa de jicā cruz cuu de, te jeē súcuan cuatáhú de cúu jeē steén de jeē yóhyo cújéhnu Yaā Dios. Yūcuán na te ni cahān gā yā: Condiquīn rō ruhū jeē sáha ró jniñu ní ndacu ri nuū rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Te ni ndió cóto Pedro, te ni jito de tēe scuáha jeē maní gā Jesús jiín, ndíquín de vēji de yatā. Tēe un cúu jeē ní conene xiin Jesús ná ni cacuxíni de jíín yá, te ni cajnūhún de ya: ¿Ndé ɨɨn de cúu jeē nastúu níhín? ");
INSERT INTO mibNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Te jeē ní jito Pedro nuū tée ún, te ni cajnūhún de Jesús: Te tēe yáha, ¿ndese coo jíín de? ");
INSERT INTO mibNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Te ni cahān Jesús: Núu cúní rī jeē cótecu de nde quɨvɨ̄ ndíji ri, ¿te naun ndɨ́hvɨ́ ni rō? Máá ró chi condiquīn rō ruhū jeē sáha ró jniñu ní ndacu ri nuū rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yūcuán na te jnūhun yáha ní jitē núu nuū tācá hermano, jeē tée scuáha un má cúū de. Te tu ní cáhán Jesús jeē ma cúū de, chi sa suhva ni cahān yā: Núu cúní rī jeē cótecu de nde quɨvɨ̄ ndíji ri, ¿te naun ndɨ́hvɨ́ ni rō? ");
INSERT INTO mibNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Te tēe scuáha un jéē maní gā Jesús jiín, suu cúu ruhū jeē nácani jnūhun tācá jniñu yáha, te suu ri tée tāca jnúhun yáha. Te cájini rō jijnáhan ró jéē iyó ndáā jnūhun nácani ri. ");
INSERT INTO mibNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Te suni íyó cuéhē ndasɨ́ gá jniñu ní sáha Jesús. Te núu tee yó ná ɨɨn ná ɨɨn, te ma cánda nɨ́ɨ́ ñáyɨ̄vɨ́ cuhun tutu jeē cóso jnūhun ún, jéni ni rī. Te ni cuu. Amén.");
INSERT INTO mibNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Amigo Teófilo, nuū tútu jeē ní tee ná xíhna gā ni castūhun ná nuū ni táca jniñu ní sáha Jesús, jiín táca jnúhun ni steén yā nde quɨvɨ̄ ní quejéé yá ni sáha ya ");
INSERT INTO mibNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","te nde quɨvɨ̄ ní ndaa ya cuanuhun yā andɨvɨ́. Te nde ná tu ndaa ya quihīn yā, te ni sáha Espíritu Santo jeē ní ndacu ya jniñu nuū táca apóstol, tēe ni nacāji ya. ");
INSERT INTO mibNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Te nuū ni jínu ni ndoho ya jeē ni jíhī yā, te uū xico quɨvɨ̄ te tɨjnɨ jínu ni steén ndijin yā maá yá nuū tée un jíjnáhan de, te súcuan ni cajini de jeē iyó ndáā jeē ní natecu yā. Te ni cahān yā jiín de sɨquɨ̄ ndese ndácu Yaā Dios jniñu. ");
INSERT INTO mibNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Te ná cáhīin tútú de jíín yá, te ni cahān yā jiín ndɨhɨ de jeē ma quéndacoo de ini ñuu Jerusalén, chi áchí yá: Condetu ró ndé quee Espíritu Santo jeē ni jéjnūhun máá Tátá rī Yaā Dios. Chi je ni cachi rī nuū rō jeē ni jéjnūhun ya quiji Espíritu Santo. ");
INSERT INTO mibNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Chi Juan, jendaá jeē maá ndute‑ni ni scuándute de ñayuu. Te róhó jíjnáhan ró, jecu na quɨvɨ̄ te nájnūhun cuandute ró jíín Espíritu Santo, cúu jeē condee yā ini anuá rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yūcuán na te tēe cáhīin tútú jíín yá, ni cacajnūhún de ya: ¿A vijna te nasáha ní jéē ñáyuu ñuu yō Israel ndujéhnu i ndacu i jniñu nuū nación yō chí naún? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Te ni cahān yā: Ma cúu cuni rō quɨvɨ̄ chí cuíyā jeē cóo jeē ni sándaā maá Tátá rī, chi máá ɨɨn‑ni máá yá jiní yā na quɨvɨ̄ sáha ya. ");
INSERT INTO mibNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Te jeē cúni rō cúu jeē quée Espíritu Santo te condee yā ini anuá rō jijnáhan ró. Yūcuán na te nihīn rō poder te nacani ró jnúhun ri nɨɨ́ ini ñuu Jerusalén, nɨ́ɨ́ Judea, nɨ́ɨ́ Samaria, nde nɨɨ́ cáhnu ñayɨ̄vɨ́, áchí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Te ni ndɨhɨ ni cahān yā tāca jnúhun yáha. Te níní cájito de nuū yā, te ni ndaa‑ni ya cuanuhun yā andɨvɨ́. Te ni quee vicō ni jesɨ‑ni nuū cuahán yā, te tuá ni cájito de ya. ");
INSERT INTO mibNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Te níní cáhīin de cájito ndaa de ichi ándɨvɨ́ núū ní ndaa ya cuahān yā, te uū jnáhan ndajéhé yā cáñūhun ya sahma cuijín ní cajecuɨñɨ̄ yā xiin de jíjnáhan de, te cájito ya nájnūhun tēe. ");
INSERT INTO mibNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Te ni cacahān yā jiín de: Róhó tée Galilea, ¿najehē cájito ndaa ró ichi ándɨvɨ́? Chi máá Yáā Dios ni naquihin ya Jesús cuanuhun yā andɨvɨ́, te suni súcuan ndiji ya nájnūhun cájito ró cuáhān yā andɨvɨ́, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yūcuán na te ni nanungoo de yucu jeē naní Olivos, cuanungoo de ñuu Jerusalén. Te yajni‑ni íne yucu un jíín ñuu Jerusalén, nájnūhun ɨɨn kilómetro‑ni, cūhva jeē ni jéhe ley permiso caca ñayuu quɨvɨ̄ ndétātú. ");
INSERT INTO mibNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Te ni ndɨ̄vɨcoo de ini ñuu. Te ni ndacoo de cuarto xinī véhe nuū cáyūcu núu de. Te tācá de cúu Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo sēhe Alfeo, Simón jeē cúu jnáhan grupo cananista, jiín Judas ñani Jacobo. ");
INSERT INTO mibNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tāca tée yáha, níní cándutútú ɨnuú de cájicān tahú de jíín táca ñani Jesús jiín náná yā María jiín sava ga ñahan. ");
INSERT INTO mibNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Te ɨɨn quɨvɨ̄ te ni jecondichi Pedro nuū tācá hermano cácandíje. Te cáhīin nájnūhun ciento ocō ñayuu. Te ni cahān de: ");
INSERT INTO mibNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Hermano jijnáhan ní, ni squícu nahín jnúhun cáhán tutu iī jeē ni cáhān David nde jenahán ní sáha Espíritu Santo. Te jnūhun un ní cuu sɨquɨ̄ Judas jeē ní yosnūu núū tée ni cajnɨɨ Jitoho yō Jesús. ");
INSERT INTO mibNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Te suu tēe un ní jica de jíín yó, te ni chindéé ñáhán jnáhan de jíín yó sɨquɨ̄ jníñu ní jeni ya yohó. ");
INSERT INTO mibNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Te ni cajeen ɨɨn ñuhun jíín xúhun ní nihīn tēe un sɨ́quɨ̄ jníñu neé ní sáha de. Te ni nɨnga ndeyɨ de, te ni ndatā sáva chīji de, te ndɨhɨ yɨtɨ de ni jitē. ");
INSERT INTO mibNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Te ni jitē jnūhun yáha núū tāca ñáyuu cáyūcú ñuu Jerusalén, te jeē yúcuan cúu jeē ní casnání i ñuhun ún Acéldama nuū yúhu máá i, jeē cuní cahān ñuhun jeē cúu cuenta nɨñɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Chi súcuan je yósó núū tútu Salmo sɨquɨ̄ Judas: Vehe de na quéndōo iyú, te ma cóndee ni ɨɨn ga ñayuu ini vehe ún. Te suni cáhán: Jniñu ní condiso de na cóndiso ɨnga tēe. Achí. ");
INSERT INTO mibNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Núu súcuan te jíni ñúhún jéē núcuɨñɨ̄ ɨɨn tēe lugar maá de jíín yó. Te tēe nucuɨñɨ̄ jiín yó un, nacāji yó de mēhñu táca tée ni cajica jíín yó tāca quɨ́vɨ̄ jeē ní jica máá Jítoho yō Jesús jiín yó. ");
INSERT INTO mibNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Te tēe nacāji yó un cúu tēe jeē ni íyo de jíín yó nde quɨvɨ̄ ní jendute ya ni sáha Juan, te nde quɨvɨ̄ ní ndaa ya cuanuhun yā andɨvɨ́. Te tēe nucuɨñɨ̄ jiín yó na cúu de testigo jiín yó jeē jé ni natecu yā, achí de. ");
INSERT INTO mibNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Te ni catee nuū de uū jnáhan tēe: Matías jiín José jeē naní de Barsabás te suni nání de Justo. ");
INSERT INTO mibNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Te ni cajicān tahú de: Tátā Yaā Dios, máá ní chi jíní ni ndese cáa ánuá tāca ñáyuu. Núu súcuan te jeē ndɨndúú tée yáha, stéén ni ndé ɨɨn de cúu jeē ní nacāji ní. ");
INSERT INTO mibNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Te condiso jníñu de cuu de apóstol. Te naquihin de jniñu ní stóo Judas, chi ni sáha de cuēchi te cuahān de lugar xeēn nuū cánuú quíhīn de, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Yūcuán na te ni casáha de ɨɨn sorteo te ni jinū Matías, te ni nucuɨñɨ̄ de ni nduu de jnáhan ndɨhúxí ɨɨn apóstol. ");
INSERT INTO mibNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Te máá quɨ́vɨ̄ víco Pentecostés ni cahīin tútú ñáyuu cácandíje ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Te sanaa‑ni te ni quejéé nɨ́hɨn vēji nde andɨvɨ́ nájnūhun tachī níhin quée, te tāca ñáyuu jeē cáyūcú ini vehe un ní cajini sōho i jeē nɨ́hɨn ún. ");
INSERT INTO mibNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Te ni cajito i nájnūhun yáñuhūn jeē ní cajitē núu te ni cacucōo xinī ná ɨɨn ná ɨɨn i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Te ndɨhɨ i, ni cunuú Espíritu Santo jiín i, te ni quejéé i cácahān i sɨ́ɨn sɨ́ɨn yuhu, ndese ni steén maá Espíritu nuū ná ɨɨn ná ɨɨn i cahān i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Te ñuu Jerusalén, suni cáhīin ñayuu hebreo, yɨñúhún núū Yaā Dios, jeē ní quijicoo i nde tācá nación nɨɨ́ cáhnu ñayɨ̄vɨ́. ");
INSERT INTO mibNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Te jeē ni nɨ́hɨn súcuan te ni cacutútú cuéhē ñayuu ún. Te ni cunéé íī ni i jíjnáhan i, chi ná ɨɨn ná ɨɨn i ni cajini sōho i jeē tée ni canihīn Espíritu Santo cácahān de jnūhun yuhu ñúū jicá nuū véji i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Te ni canaa ni i cájito i te ni cacahān i: ¿A násūu tée Galilea cácuu tāca tée yáha jéē cácahān de tācá yuhu ñúū nuū véjicoo yó? ");
INSERT INTO mibNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Na vé ni cuu yāha núu súcuan? Chi ná ɨɨn ná ɨɨn yó cájini sōho yó cácahān de jnūhun yuhu ñúū nuū ní cacacu yó. ");
INSERT INTO mibNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Chi vējicoo yó ndé tācá ñuu jicá. Sava yó véji nde Partia jiín Media jiín Elam. Te sava ga yō vēji yó ndé Mesopotamia jiín Judea jiín Capadocia jiín Ponto jiín Asia. ");
INSERT INTO mibNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Suni nde Frigia jiín Panfilia jiín Egipto jiín tɨjnɨ ñuu jeē íne nde yatā gā ñuu Cirene ñuhun Africa vējicoo yó. Te sava ga yō nde ñuu Roma vējicoo yó, te cáyūcu jínu‑ni yó yáha. Te máá yó jeē véjicoo ñuu Roma, sava yó cácuu máá ñáyuu hebreo te sava ga yō cácuu ñayuu sɨ́ɨn ñuu, ni cacandíje yó ndíquín yō ley ñayuu hebreo. ");
INSERT INTO mibNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Suni nde Creta jiín Arabia vējicoo sava yó. Te cájini sōho yó jéē jiín jnúhun yuhu ñúū ná ɨɨn ná ɨɨn máá yó cácahān de tācá jniñu jéhnu ní sáha Yaā Dios, achí i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Te ndɨhɨ i chi ni canaa iī ni i cájini nahín i. Te ni candajnūhún i jíín jnáhan i: ¿Na vé cúu jeē ní cuu núu súcuan jeē cácahān de yuhu ñúū yō? achí i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Te sava i ni cacahān catá i: Tuú chi jeē cánajīni de, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yūcuán na te ni candocuɨñɨ̄ Pedro jiín ndɨhúxí ɨɨn ga apóstol, te ni cahān jee Pedro jiín ñáyuu ún: Níhín jnáhan ñuu yō hebreo, jiín ndɨhɨ níhín jéē cáyūcu ní Jerusalén, jnūhun yáha na chúhun ni ni jíjnáhan ní, chi cuni nahín ní cahān na jíín ní. ");
INSERT INTO mibNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Chi máá ná jijnáhan ná, nasūu jéē cájīni ná nájnūhun cájeni ni ní, chi sáá cahɨɨ̄n jenéhen cúu, te nasūu hora cánajīni ñayuu cúu. ");
INSERT INTO mibNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Chi sa suhva squícu jniñu yáha nájnūhun ni cahān Joel, tēe ni nacani jnūhun Yaā Dios nde jenahán, chi súcuan ni cahān de: ");
INSERT INTO mibNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Achí Yáā Dios: Quɨvɨ̄ sándɨ̄hɨ́ na te tají rí Espíritu rī cunuú yá jiín táca ñáyuu, te sēhe yɨɨ́ ró jiín séhe sɨ́hɨ́ ró, nacani i jnūhun ri, te tāca tée lulí chi coto ndijin de jeē steén rī nuū de, te tāca tée jéhnu chi sáha ri jeē scóto jēni de. ");
INSERT INTO mibNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Te quɨvɨ̄ ún chi tají rí Espíritu rī cunuú yá jiín táca mozo rī, cúu tēe cúu ñahan, te nacani i jnūhun ri. ");
INSERT INTO mibNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Te ichi ándɨvɨ́ sáha ri jniñu jéhnu jeē náā ni ñayuu coto i, te sáha ri jniñu jéhnu ini ñayɨ̄vɨ jéē steén jeē cujéhnu ri, chi coo nɨñɨ̄ jiín ñúhūn jiín ñúhmā nájnūhun vicō. Yūcuan cúu jeē sáha ri jeē cóo jnūndóho xeēn. ");
INSERT INTO mibNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Te nduu jnúú níāndii te ma cúndijin gā, te yoō coto cuéhé nájnūhun nɨñɨ̄. Yūcuán na te quee quɨvɨ̄ jeē ndíji máá Jítoho rō Jesús. Quɨvɨ̄ ún coo cuehē jniñu jéhnu, te cuni ndɨhɨ ñayuu jeē quɨvɨ́ maá Jítoho rō cúu. ");
INSERT INTO mibNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Te tāca ñáyuu jeē cahān ndahú i jíín yá te jnama ya i, áchí Yáā Dios. Achí Joel ni nacani de jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Jeē yúcuan níhín tée ñuu yō Israel, cuni nahín gá ni jnúhun yáha jíjnáhan ní. Ni steén Yaā Dios jeē ní tají yá maá Jesús, Yaā ní jehnu ñuu Nazaret, chi máá Yáā Dios ni jēhe ya jeē ni sáha Jesús jniñu jéhnu mēhñu máá ní, jiín jniñu jeē steén jeē cujéhnu ya, te jniñu un ní canaa ni ni ní cajito ní. Te je cájini vāha ní jéē súcuan ni cuu. ");
INSERT INTO mibNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Te máá ní ni cajnɨɨ ní yá, te ni cajendēca ní yá nuū tée xeēn ni cajehni de ya jicā cruz ni casáha ní. Te nde jiín tiempo je ni jini Yaā Dios jeē súcuan sáha ní jíjnáhan ní, chi súcuan je ni sándaā yā. ");
INSERT INTO mibNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Te ni nastécu Yaā Dios Jesús te tuá ni cúu ya ndɨ̄yɨ, chi jnūhun xeēn jeē jihí ñayuu, tuá na vé cúu ga sáha jíín yá. ");
INSERT INTO mibNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chi nde jenahán suhva ni tee David jnūhun ndese ni cahān Jesús jiín Yáā Dios: Jíní na núū maá ní jeē cúu ní Jítoho ná, chi nɨ́ɨ́ cáni ndéé ní jiín ná, chi ndéé ní ichi ndáváha ná, cúu jeē chindéé ñáhán ní sāña návāha coo ndeyɨ́ ni ná. ");
INSERT INTO mibNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jeē yúcuan cúsɨɨ̄ ni ná te cáhán na jnúhun sɨɨ̄ ni. Jeē yúcuan ma nácani uhū ni na sɨ́quɨ̄ jnúhun cuu ná. ");
INSERT INTO mibNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Chi ma cuáha ni jnúhun quendōo ánuá na lugar nuū cáyūcu ánuá ndɨ̄yɨ, ni ma cuáha ni jnúhun tehyū ná, chi jéjníñu ná núū ní te manī ni jíín ná. ");
INSERT INTO mibNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Te ni steén ni núū na jéē nátecu ná, te sáha ní jéē cusɨɨ̄ teyɨ́ ni ná condee na jíín ní nɨɨ́ cáni. Achí Jesús, ni achi David. ");
INSERT INTO mibNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Tāca níhín jíjnáhan ní, na cástūhun cájí ná nuū ni jnúhun jíí yō David, chi tu ní cáhán de jnūhun yáha sɨ́quɨ̄ maá de. Chi ni jihī de te ni quindūji de, te jíní yō nuū yɨ́ndūji de nde vijna. ");
INSERT INTO mibNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Chi ni cuu de tēe ni nacani jnūhun Yaā Dios nde jenahán. Te ni jini de jeē váha ni jejnūhun ya nuū de jeē chíji yucūn maá de quiji Cristo, te condee yā mesa de ndacu ya jniñu nájnūhun ni ndacu de jniñu jeē ní cuu de rey. ");
INSERT INTO mibNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Te nde jiín tiempo ni jini de jeē nátecu Cristo, te ni cahān de jeē anuá yā, ma ndóo lugar nuū cáyūcu ánuá ndɨ̄yɨ, ni yɨquɨ cúñu yā ma tehyú. ");
INSERT INTO mibNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Chi Yaā Dios ni nastécu yā Jesús, te máá ná cácuu ná testigo jeē ní natecu yā. ");
INSERT INTO mibNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Te ni ndujéhnu tucu ya ni sáha Yaā Dios jiín poder yā. Te nde nuū maá Yáā Dios, Yaā cúu Tátá yā, ni nihīn Jesús Espíritu Santo, chi súcuan ni jejnūhun ya. Te ni tají Jesús Espíritu Santo, te suu ya sáha jniñu jeē cájito ní te cájini sōho ní vijna. ");
INSERT INTO mibNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Te David, nasūu sɨ́quɨ̄ maá de ní cáhán de tāca jnúhun yáha, chi tu ní ndáa yɨquɨ cúñu de andɨvɨ́. Chi sɨquɨ̄ Cristo cúu jeē ni cáhān de suhva: Máá Yáā Dios ni cahān yā jiín Jítoho rī Cristo: Cucōo ró ichi ndáváha ri jeē steén jeē cujéhnu ró. ");
INSERT INTO mibNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Te na sáha ri jeē quende rō poder tāca jéē cájito uhū rohó, áchí yá. Achí David. ");
INSERT INTO mibNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Núu súcuan te ndɨhɨ ní jéē cácuu yó ñayuu Israel, na cúni vāha ní jéē vēsú ni cajehni ni yá jicā cruz, te Yaā Dios ni jeni ya maá Jesús jeē cúu ya Jitoho yō te suni cúu ya Cristo, Yaā jnáma yóhó, áchí Pedro jiín i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Te jeē súcuan ni cajini sōho i jnūhun yáha, te ni cajnahuhū ni anuá i. Te ni cacajnūhún i Pedro jiín táca gá apóstol: ¿Te ndese sáha ná jíjnáhan ná núu súcuan? áchí i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Te ni cahān Pedro jiín i: Nacani ni ni jéē stóo ni cuéchi ní jíjnáhan ní, te cuandute ní jéē ní cacandíje ní Jesucristo, návāha cone cáhnu ni Yaā Dios nuū cuéchi ní, te cuāha Yaā Dios Espíritu Santo yā condee yā ini anuá ni. ");
INSERT INTO mibNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Chi súcuan ni jejnūhun máá Tátá yō Yaā Dios nuū yō jiín núū séhe yó, te suni súcuan ni jejnūhun ya nuū ñáyuu tāca gá nación, tācá i jeē cána ya i candíje i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Te jíín cuéhē gā jnūhun súcuan ni cahān cají Pedro, te ni stɨhvɨ́ ni de i: Nducú ndéyɨ́ ní jeē na cácu ní, chi jnahnū ndetū ñayuu casáha jniñu néé, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yūcuán na te tācá i jeē ní cajetáhú jnúhun ni cahān de, ni cajendute i. Te quɨvɨ̄ un ní nducuehē gā ñayuu cácandíje, nájnūhun unī mil gā ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Te ni cahīin nīhin i sɨquɨ̄ jnúhun cástéén apóstol. Te ɨnuú‑ni cándajnūhun mánī i te cájicān tahú i, te ɨɨn cáhnu‑ni cáyeji i pan, nájnūhun ni steén maá Jítoho yō jeē núcūhun ni yō sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Te ndɨhɨ ñayuu ni cayūhú i ni cajito i, chi cuehē jniñu jéhnu jeē steén jeē cujéhnu ya ni casáha tēe apóstol. ");
INSERT INTO mibNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Te ɨnuú ní cahīyo ni ñayuu cácandíje, te ni cacuu ɨnuú i tāca jéē cánevāha i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Te ni caxīcó i na‑ni na vé cánevāha i, te ni casaja i xūhún un núū tāca jnáhan i, núu ndese jíni ñúhún ɨɨn ɨɨn i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Te ndɨjnahan quɨvɨ̄ ni candutútú i ini templo. Te manī ni cayeji cáhnu i pan tācá vehe jnáhan i nájnūhun ni steén yā, te ni cahīyo sɨɨ̄ ni i. ");
INSERT INTO mibNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Te ni cacahān i jeē yóhyo cújéhnu Yaā Dios. Te ndɨhɨ ñayuu ñuu un ní cajejnúhún i ñayuu cácandíje. Te ndɨjnahan quɨvɨ̄ ni jnama Jitoho yō sava ga ñayuu, te ni nduu ɨnuú i jíín ñáyuu cácandíje. ");
INSERT INTO mibNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Te ɨɨn quɨvɨ̄ te máá cáhunī jehíni ni caa Pedro jiín Juan cuangoo de templo, chi hora un cájicān tahú jnáhan de hebreo. ");
INSERT INTO mibNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Te cájendēca ñayuu ɨɨn tēe cáríngo nde quɨvɨ̄ ní cacu de. Te tēe un ndéé de ndɨjnahan quɨvɨ̄ yehyɨ́ templo jeē naní Hermosa, jícán de caridad nuū tāca ñáyuu quɨ́vɨcoo ini templo. ");
INSERT INTO mibNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Te tēe un ní jito de nuū Pedro jiín Juan jeē véji de quɨ̄vɨcoo de ini templo, te ni jicān de caridad nuū Pedro jiín Juan. ");
INSERT INTO mibNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Te Pedro jiín Juan ni cajito vāha de nuū tée ún. Te ni cahān Pedro jiín de: Condēhe núū rī jijnáhan ri, achí de. ");
INSERT INTO mibNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Te máá tée un ndétu tūhva de, ni jeni ni de jeē cuáha Pedro jiín Juan jecu xūhun núū de. ");
INSERT INTO mibNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Te ni cahān Pedro: Tú na xūhun plata ni xūhun oro cánevāha ri. Te íyó ɨɨn jeē váha ga sáha ri jiín ró: jíín poder maá Jesucristo, Yaā ní jehnu ñuu Nazaret, cáhán rī jiín ró, ndocuɨñɨ̄ te caca ró, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Te ni jnɨɨ de ndaváha tēe ún, te ni ndonehen de. Te jehē de jíín súcūn jehé de ni nduvāha‑ni. ");
INSERT INTO mibNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Te ɨɨn ni scánda de máá de ni ndocuɨñɨ̄ de, te ni quejéé de jíca de. Te ni quɨ̄vɨ de jíín Pedro jiín Juan ini templo, jíca de, cánda de, te nácuatáhú de nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Te ni cajini tāca ñáyuu jeē jíca de te nácuatáhú de nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Te ni canacuni i de jeē maá de cúu tēe ni condee yehyɨ́ templo jeē naní Hermosa, ni jicān de caridad. Te ni canaa ni i ni cajito i, te ni cayūhú i cájito i jeē ní nduvāha tēe ún. ");
INSERT INTO mibNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Te tēe ni nduvāha ún, tu siáá de Pedro jiín Juan. Te ni cacutútú‑ni cuehē ñayuu nuū de ini corredor jeē naní Salomón, te ni canaa ni i cájito i. ");
INSERT INTO mibNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Te ni jito Pedro jeē ní cutútú ñáyuu ún, te ni cahān de jíín i: Níhín tée ñuu yō Israel jijnáhan ní, ¿najehē cánaa ni ni cájito ní jniñu yáha? ¿Najehē cájito ní núū ná te cájeni ni ni jéē maá ná jijnáhan ná íyó poder na jéē sáha ná jéē nácaca tēe yáha? ¿Chí ní nduvāha de sɨquɨ̄ jeē tée cájica ndaā cácuu ná cájeni ni ní? ");
INSERT INTO mibNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tuú chi máá Yáā Dios jií yō Abraham jiín Isaac jiín Jacob jiín táca gá jií yō, ni sáha ya jniñu yáha návāha cuni ñayuu jeē cujéhnu Sēhe ya Jesús, Yaā jeē ní cajendēca ní núū tée cácujéhnu. Te ná ni cuni Pilato jeē siaá de ya, te tu ní cájēhe ni jnúhun. ");
INSERT INTO mibNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Te ni casquéhichī ni yá vēsú cúu ya Yaā ndaā, Yaā iī. Te sa suhva ɨɨn tēe jéhni ndɨ̄yɨ ni cacahān ni jíín Pilato jeē na siáá de. ");
INSERT INTO mibNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Te ni cacahān ni jéē na cúū Yaā jeē sáha jeē técu ndɨhɨ‑ni. Te Yaā Dios ni nastécu yā Jesús jeē ní cuu ya ndɨ̄yɨ, te máá ná cácuu testigo jeē ní natecu yā. ");
INSERT INTO mibNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Te tēe yáha jéē cájito ní te cánacuni ní de, ni candíje de jíín ná jeē iyó poder Jesús nasávāha ya de, te jeē yúcuan ní nasávāha ya de. Te jeē súcuan ni cacandíje ná ní sáha ya, jeē yúcuan ní nduvāha vāha de nájnūhun cájito ndɨhɨ ní. ");
INSERT INTO mibNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Te na cástūhun ná nuū ni jíjnáhan ní, je jíní na jéē maá ní jíjnáhan ní jíín tée cácujéhnu nuū yō, tu ní cájecūhun ni ní, te jeē yúcuan ní cajehni ni yá. ");
INSERT INTO mibNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Te súcuan ni squícu jnūhun ni cahān Yaā Dios nde jenahán jéē cánuú ndoho Cristo sɨquɨ̄ cuéchi ñayuu, chi ni sáha ya jeē súcuan ni cacahān tēe ni canacani jnūhun ya nde jenahán. ");
INSERT INTO mibNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Te na nácani ni ni jéē stóo ni cuéchi ní, te nasāma ini ní, te quɨ̄vɨcoo ní ndaha Yaā Dios návāha ndahva yā cuēchi ní. Te quee quɨvɨ̄ jeē ndúsɨɨ̄ ni ni sáha máá Jítoho yō. ");
INSERT INTO mibNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Te natají yá Jesús ndiji ya, chi cúu ya Cristo, Yaā ní jeni Yaā Dios jeē jnáma ya yohó. ");
INSERT INTO mibNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Te jíni ñúhún jéē cóo ya andɨvɨ́ ndé nasájeé yá tāca jéē iyó, nájnūhun ni cacahān tēe ndoo ni canacani jnūhun nde jenahán ní sáha Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Chi suhva ni nacani jíí yō Moisés jnūhun nuū tāca jíí yō: Máá Jítoho yō Yaā Dios cani ya Yaā nacani jnūhun nuū rō jijnáhan ró, nájnūhun ni jeni ya ruhū. Te cuu ya ɨɨn jnáhan ñuu yō. Te na chúhun ni rō tāca jnúhun jeē nácani ya ún. ");
INSERT INTO mibNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Te núu ndé tée tú chuhun ni de jnūhun cahān yā, jnahnū ndetū de, te ma cúu ga de jnáhan ñayuu yā Israel, áchí Moisés. ");
INSERT INTO mibNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Te tāca tée ni canacani jnūhun nde jenahán, nde tiempo ni quiji Samuel te nɨ́ɨ́ gá nde vijna, suni ni canacani de jnūhun sɨquɨ̄ tācá jniñu cúu quɨvɨ̄ yáha. ");
INSERT INTO mibNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yucūn maá tée ni canacani jnūhun ya nde jenahán cácuu yó, te suni sɨquɨ̄ maá yó jijnáhan yó cúu jeē ni sáha Yaā Dios contrato jiín jíí yō. Chi ni cahān yā jiín Abraham: Yucūn maá ró cane Yaā sáha jeē quéndōo ndetū tāca ñáyuu nɨɨ́ cáhnu ñayɨ̄vɨ, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Te jeē ní nastécu Yaā Dios Sēhe ya, te ni quiji ya nuū maá yó xíhna gā, návāha quendōo ndetū yō sáha ya, chi sama ya anuá yō jeē ma sáha ga yō jniñu neé, áchí Pedro. ");
INSERT INTO mibNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Te Pedro jiín Juan níní cácahān gā de jíín ñáyuu ún te ni quecoo tāca sútū jiín tée grupo saduceo, jiín tée cácujéhnu nuū tée cándīto templo. ");
INSERT INTO mibNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Te yōhyo ni caquɨtɨ̄ ni de sɨquɨ̄ jeē castéén Pedro jiín Juan nuū ñáyuu, jíín jéē cánacani de jnūhun jeē nátecu ndɨ̄yɨ chi je ni natecu Jesús. ");
INSERT INTO mibNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Te ni cajnɨɨ ún de, te ni cachuhun ún de vecāa cone de nde cundijin ɨnga quɨvɨ̄, chi je ni ini. ");
INSERT INTO mibNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Te cuehē ñayuu jeē ní cajini sōho jnūhun ni cacahān Pedro jiín Juan ni cacandíje i. Te ni nduu nájnūhun uhūn mil jeē maá nene tēe jeē ní cacandíje. ");
INSERT INTO mibNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Te jeē ní cundijin ɨnga quɨvɨ̄ ún, te tēe cácujéhnu nuū ñáyuu hebreo jiín tée jéhnu cándīso jníñu jíín tée cástéén jnūhun tutu ley yā, ni candutútú de ini ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Te suni ni candutútú de jíín Anás jeē cúu sutū cujéhnu ga, jiín Caifás jiín Juan jiín Alejandro jiín táca gá jeē cácuu jnáhan sutū cujéhnu ga ún. ");
INSERT INTO mibNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Te ni candacu jniñu jeē na quíjicoo Pedro jiín Juan condichi de mēhñú, te ni cacajnūhún de: ¿Ndé ɨɨn ni tejníñu róhó te ndese ni nihīn jníñu ró ní sáha ró jéē ndúvāha tēe yáha? áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yūcuán na te Pedro chi ni cunuú maá Espíritu Santo jiín de, te jíín poder yā ni cahān de jíín táca tée ún: Tāca níhín tée cácujéhnu nuū ñúū yō Israel jiín táca níhín tée jéhnu cándīso jníñu, ");
INSERT INTO mibNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","vijna te cástíchí ni sáña sɨ́quɨ̄ ɨɨn jniñu váha ní casáha ná jéē ní nduvāha tēe cúhú yāhá. ");
INSERT INTO mibNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Te na cástūhun ná nuū nihín jéē cácujéhnu ní, návāha suni cuni ndɨhɨ jnáhan ñuu yō Israel jeē jiín poder maá Jesucristo, Yaā ní jehnu ñuu Nazaret, ni nduvāha tēe índichi nuū ni yáha. Te suu ya cúu Yaā jeē ní cajehni ni jícā cruz, te ni sáha Yaā Dios jeē ní natecu yā. ");
INSERT INTO mibNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesús cúu nájnūhun yuū cimiento jeē quítuu vehe. Te máá ní jijnáhan ní cácuu nájnūhun tēe cásáha vehe, te ni casquéhichī ni yá nájnūhun jeē cátejiyo ní yúū, chi tu ní cácandíje ní yá. Te ni sáha Yaā Dios jeē cúu ya nájnūhun yuū cánuú gá jeē quítuu vehe. ");
INSERT INTO mibNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Te tú cuɨtɨ ɨnga jeē cúu jnama yóhó, chi tuá na ɨnga jeē cujéhnu ní jéni Yaā Dios ini ñayɨ̄vɨ yáha jéē cúu jnama yóhó, áchí Pedro. ");
INSERT INTO mibNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Yūcuán na te ni cajini un jéē Pedro jiín Juan jéhnu‑ni cácahān de. Te je cájini jeē tú tūhva de, chi tēe súcuan‑ni cácuu de. Te ni canaa ni cájito nuū de, te ni casáha cuenta jeē ní cajica de jíín Jesús. ");
INSERT INTO mibNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Te cándēhe núū tée ni nduvāha un, índichi de jíín Pedro jiín Juan, te tu ní cánihīn gā modo ndese ga cahān. ");
INSERT INTO mibNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yūcuán na te ni candacu jniñu jeē na quéndacoo sɨ́ɨn de yatā véhe juzgado te ndajnūhun máá jíjnáhan. ");
INSERT INTO mibNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Te ni cacahān: ¿Ndese sáha yó jíín tée yáha núu súcuan? Chi ni jitē jnūhun yáha núū tāca ñáyuu ñuu Jerusalén jeē súcuan ni casáha de ɨɨn jniñu jéhnu, te ma cúu cahān yō jeē tu íyó ndáā. ");
INSERT INTO mibNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Te návāha ma cuité ga jnūhun yáha, na cúxeēn yō nuū de jeē ma cahán cuɨtɨ gā de jnūhun Jesús nuū ní ɨɨn ñayuu, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Te ni cacana ún de, te ni cacahān nīhin jíín de jeē ma cahán cuɨtɨ gā de jnūhun Jesús ni ma steén gā de jnūhun un núū ní ɨɨn ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Yūcuán na te ni cacahān Pedro jiín Juan: Cani vāha ni ní te núu nújnahan ni Yaā Dios jeē stóo ná jniñu ní ndacu ya jeē sáha ná te cuandije ná máá na jniñu nándacu ní. ");
INSERT INTO mibNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Chi ma cúu stóo ná jniñu jeē nácani ná jnúhun ní cajini sōho ná jíín jniñu ní cajito ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yūcuán na te tēe ni cacutútú un ní cacuxeēn tucu de nuū Pedro jiín Juan. Te ni casiáá de cuangoo de, chi tú cuɨtɨ na modo stóho de chi cáyūhu cájito ñayuu, chi sɨquɨ̄ jníñu jéhnu ni cuu ún te ndɨhɨ i cácahān i jeē yóhyo cújéhnu Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Chi tēe jeē ní sáha ya jniñu jéhnu jíín de jeē ní nduvāha de, víhyá gā uū xico cuiyā de. ");
INSERT INTO mibNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Te ná ni casiáá un Pedro jiín Juan cuangoo de, te ni najinūcoo de nuū tāca gá jnáhan de, te ni cacachi de ndese ni cacahān sutū cácujéhnu jíín tée jéhnu cándīso jníñu. ");
INSERT INTO mibNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Te jeē ní cajini sōho de jnūhun yúcuan, te ɨnuú‑ni ni cajicān tahú de nuū Yaā Dios: Tátā Yaā Dios jeē cujéhnu ní núū ndɨhɨ, máá ní cúu Yaā Dios ni sáha andɨvɨ́ jíín ñáyɨ̄vɨ jíín mar jiín táca ndɨhɨ jeē iyó. ");
INSERT INTO mibNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Te jeē jiín Espíritu Santo te ni sáha ní jéē ni cáhān mozo ní David nde jenahán: ¿Najehē cáquɨtɨ̄ ndevāha ni ñayuu sɨ́ɨn nación? ¿Te najehē cájeni sáá ni i jeē ndónda i sɨquɨ̄ ní? ");
INSERT INTO mibNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ni cacutútú jéē cácuu rey ñayɨ̄vɨ jíjnáhan, te tēe cácujéhnu ni cacutútú de, te ɨnuú‑ni ni candonda de sɨquɨ̄ maá ní jeē cúu ní Jitoho ná, jíín sɨ́quɨ̄ Cristo, Yaā jeē ní jeni ní. Achí David. ");
INSERT INTO mibNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Te jendaá chi Herodes jiín Poncio Pilato jiín táca tée ñuu yō Israel jiín tée tāca gá nación, ni cacutútú de ini ñuu yáha ní candonda de sɨquɨ̄ Séhe iī ní Jesús, Yaā ní jeni ní. ");
INSERT INTO mibNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Te súcuan ni cuu návāha squícu tācá jniñu jeē jiín poder ni ní cundaā ni ni ndé jenahán jéē súcuan coo. ");
INSERT INTO mibNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Te vijna, Tátā, coto ní ndese cácahān xeēn de nuū na jíjnáhan ná, te cuāha ni fuerza ni núū na jéē cácuu ná mozo ni, návāha jéhnu‑ni nacani ná jnúhun máá ní. ");
INSERT INTO mibNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Te jíín poder ní nasávāha ni ñáyuu cácuhū, te sáha ní jniñu jéhnu jeē steén jeē cujéhnu ní. Te tāca jéē yáha sáha ní jíín poder Sēhe iī ní Jesús, áchí i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Te nuū ní ndɨhɨ ni cajicān tahú i, te nuū cáyūcu tútú i un ní sáha ya jeē ni jnáa. Te ndɨhɨ i ni cunuú Espíritu Santo jiín i, te ni jēhe ya fuerza te jéhnu‑ni ni canacani i jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Te ñayuu cuehē jeē ní cacandíje chi ɨnuú cáhīyo ni i jíjnáhan i. Te tú ni ɨɨn i ní cáhán jeē ndajníñu jeē névāha máá i cuu máá‑ni i, chi tācá ndajníñu ni canevāha cáhnu i. ");
INSERT INTO mibNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Te nīhin cánacani apóstol jnūhun jeē ní cajito de jeē ní natecu Jitoho yō Jesús. Te yōhyo ni chindéé ñáhán yá ñayuu cácandíje. ");
INSERT INTO mibNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Chi tú cuɨtɨ ni ɨɨn i ní ndóho jeē cumanī nuū i, chi tāca ñáyuu cánevāha cuehē ñuhun chí vehe, ni caxīcó i sava te ni caquindeca i xūhún un. ");
INSERT INTO mibNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Te ni cajēhe i xūhún un núū tée apóstol, te ni casaja tēe apóstol nuū ñáyuu cácandíje núu ndese jíni ñúhún ɨɨn ɨɨn i. ");
INSERT INTO mibNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Te íyó ɨɨn tēe nání José jeē cúu yucūn Leví, ni cacu de Chipre, ñuhun jeē íne sɨ́ɨn nuū ndúte. Te tēe apóstol ni casnání de tēe ún Bernabé, jeē cuní cahān: tēe cáhán jnūhun ndeyɨ́ ni. ");
INSERT INTO mibNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Te ni xīcó de ɨɨn ñuhun de, te ndáhá de xūhún un ní jēhe de nuū tée apóstol. ");
INSERT INTO mibNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Te suni ɨnga tēe nání Ananías jiín ñasɨhɨ́ de Safira, ni caxīcó de ɨɨn ñuhun de. ");
INSERT INTO mibNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Te ni chuvāha de sava xūhún un cuu máá de jíín ña, chi súcuan ni candajnūhún de jíín ña, te ndáhá de ɨnga sava nájnūhun jeē ndɨ́hɨ cúu, te ni jēhe de nuū tée cácuu apóstol. ");
INSERT INTO mibNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Te ni cahān Pedro: Ananías, ¿naun ni jēhe ro jnúhun jeē quɨ̄vɨ jexeén, jeē cúu Satanás, ini anuá rō te stáhú ró Espíritu Santo cuní rō? Chi jeē ní caxīco ró ñuhun ró te cuēchi ró cúu jeē tu ní cáchi ndaā rō jeē ni squéndōo ró jecu xūhún un cuajníñu máá ró, chi ni sáha ró nájnūhun jeē ndɨhɨ xūhun ní jēhe ró. ");
INSERT INTO mibNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Te á násūu cuenta maá ró cúu ñuhun un ndé ná tu xīco ró? Te ná ni xīco ró ¿te á násūu cuenta maá ró cúu xūhun jéē cuajníñu ró ndé nuū cuní maá ró? ¿Te naun ni jeni ni rō jeē stahú ró súcuan? Te nasūu máni máá tée cúu jeē jícu ró stáhú ró, chi suni Yaā Dios, áchí Pedro. ");
INSERT INTO mibNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Te ná ni jini sōho Ananías tāca jnúhun yáha, te ni cotúú‑ni de ni jihī de. Te tāca ñáyuu ní canihīn jnūhun ún, yōhyo ni cayūhú i. ");
INSERT INTO mibNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Te ni candocuɨñɨ̄ tēe suchí, te ni cachusúcún de ndɨ̄yɨ un cuáchindūji de. ");
INSERT INTO mibNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Te ni cunúu nájnūhun unī hora. Te ni jinū ñasɨhɨ́ ndɨ́yɨ un ní quɨ̄vɨ ña ini vehe ún, te tú na vé jiní cuɨtɨ ña. ");
INSERT INTO mibNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Te Pedro ni cajnūhún de ña: Cachi nuū rī, ¿á ɨɨn súcuan‑ni ni caxīco ró ñuhun ró chí tuú? áchí de. Te ni cachi ña: Suu súcuan‑ni ni caxīco ná, áchí ña. ");
INSERT INTO mibNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Te ni cahān Pedro jiín ña: ¿Naun ni casquíjnáhan jnūhun ró jéē cóto ndee rō Espíritu Santo maá Jítoho yō? Chi ni nducú ró stahú ró yā. Cuni nahín jéē cáhma nanecoo tēe cuachindūji yɨɨ ró, te suni súcuan quichindūji de róhó, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Te ni cotúú‑ni ña nuū jehé Pedro te ni jihī‑ni ña. Te ni ndɨ̄vɨcoo tēe suchí un te ni cajito de jeē jé ni jihī ña, te ni caquenehen de ña, te ni jechindūji de ña xiin yɨ́ɨ ña. ");
INSERT INTO mibNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Te yōhyo ni cayūhú ndɨvii ñayuu cácandíje jíín táca gá ñayuu jeē ní cajini jnūhun jeē súcuan ni cuu. ");
INSERT INTO mibNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Te cuehē jniñu jéhnu jeē steén jeē cujéhnu Yaā Dios ni casáha tēe apóstol nuū ñáyuu. Te tāca ñáyuu cácandíje, ɨnuú‑ni cándutútú i ini corredor jeē naní Salomón. ");
INSERT INTO mibNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Te tu ní cáchundeyɨ́ ni ɨnga ñayuu quijnáhan jíín i. Te cájejnúhún i ñayuu cácandíje. ");
INSERT INTO mibNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Te ni nducuehē gā i, chi cúu tēe cúu ñahan ni cacandíje i máá Jítoho yō. ");
INSERT INTO mibNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Te cáquindeca ñayuu jnáhan i jeē cácuhū, te cájequin i ini calle cácaa i nuū camilla jiín núū yúu, chi cácuni i vēsú ste cuándahū Pedro na yáha sɨquɨ̄ i te nduvāha i. ");
INSERT INTO mibNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Te suni cuehē ñayuu tācá ñuu cáhīyo yajni yūcuan ní quijicoo i ñuu Jerusalén ni caquindeca i jnáhan i jeē cácuhū jiín jéē cándoho tachī, te ndɨhɨ i ni canduvāha i. ");
INSERT INTO mibNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yūcuán na te sutū cujéhnu ga jiín táca gá jnáhan jeē cácandíje sahān saduceo, ni cacucuésún ni jeē sɨquɨ́ tēe cácuu apóstol. ");
INSERT INTO mibNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Te ni cajnɨɨ de tēe cácuu apóstol ni cachuhun de vecāa. ");
INSERT INTO mibNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Te ɨɨn ndajéhé maá Jítoho yō ni nune ya yehyɨ́ vécāa ún jecuáā, te ni quenehen ya de jíjnáhan de. Te ni cahān yā jiín de: ");
INSERT INTO mibNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Cuáhán te cuɨñɨ ró ini templo, te yūcuán nacani cájí ró jnūhun nuū ñáyuu sɨquɨ̄ ndese nihīn tahú i cotecu i nɨ́ɨ́ cáni, áchí ndajéhé yā. ");
INSERT INTO mibNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Te ni cajini sōho de jnūhun yáha. Te nuū ní cundijin te nehen ni quɨ̄vɨcoo de ini templo, te cástéén de jnūhun ya nuū ñáyuu. Te níní cástéén de te sutū cujéhnu ga jiín táca jnáhan de ni canastútú de tēe junta cujéhnu ga, jeē cúu ndɨhɨ tēe jéhnu cándīso jníñu nuū ñáyuu nación Israel. Te ni catají de policía cuaquenehen tēe apóstol ini vecāa. ");
INSERT INTO mibNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Te nuū ni jínūcoo te tuá gā tēe apóstol. Te ni canandió cóo te ni cacachi: ");
INSERT INTO mibNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Jendaá cúu jeē ní cajito ná ndésɨ vāha vecāa, te cáhīin tēe cándīto yéhyɨ́ un. Te nuū ní canune ná, te tú cuɨtɨ gā tēe un cáhīin ini vecāa ún, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Te sutū cujéhnu ga jiín tée cújéhnu nuū tée cándīto templo jiín sútū cácujéhnu, nuū ní cajini sōho de jnūhun yáha, te ni cajeni ni de ndese ga cúu un núu súcuan. ");
INSERT INTO mibNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Te ni quee‑ni ɨɨn tēe te ni cachi: Tēe jeē ní cachuhun ní vecāa, cáhīin de ini templo, te cástéén de jnūhun nuū ñáyuu, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yūcuán na te tēe cácujéhnu nuū tée cándīto templo, jiín tée cácuu policía de, ni jengoo de, te yúcún ní nacueca de tāca tée apóstol vendicoo de jíín, chi cáyūhú de jeē sanaa te cuāha ñayuu yuū xinī de núu sáha xeēn de jíín táca tée apóstol. ");
INSERT INTO mibNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Te nuū ní najinūcoo de jíín tée apóstol, te ni cajecuɨñɨ̄ de nuū tée cásáha junta. Te sutū cujéhnu ga ni cahān: ");
INSERT INTO mibNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ni cacahān nīhin ri jiín ró jeē ma steén cuɨtɨ gā rō jnūhun tēe nání Jesús. ¿Te naun ni casáha ró jéē ní ndecāva jnūhun un nɨ́ɨ́ ñuu Jerusalén yāhá? Te cácuni rō staú yáhu ró rúhū jijnáhan ri sɨquɨ̄ jeē ni jíhī tēe ún, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Te Pedro jiín táca gá apóstol ni cacahān de: Cánuú jéē squícu ná jniñu ní ndacu Yaā Dios nuū ná te nasūú jniñu nándacu tēe. ");
INSERT INTO mibNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Máá Yáā Dios jií yō ni nastécu yā Jesús, Yaā ní cajehni maá ní jeē ní cata caa ní yá jicā cruz. ");
INSERT INTO mibNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Te ni sáha Yaā Dios jeē ní ndujéhnu tucu Jesús néne ya ichi ndáváha Yaā Dios, te cúu ya Yaā ndácu jniñu, Yaā jnáma ñayuu. Te súcuan ni sáha Yaā Dios návāha yóhó, jéē cácuu yó ñáyuu Israel, na nácani ni yō jeē stóo yó cuéchi yó, te cone cáhnu ni yā nuū tāca cuéchi yó. ");
INSERT INTO mibNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Te máá ná ni cajito ná táca jniñu yáha, te suni máá Espíritu Santo steén cají yá jeē súcuan cúu, chi jéhe Yaā Dios Espíritu Santo yā condee ini anuá tāca ñáyuu jeē cájendetū nuū yā, achí de. ");
INSERT INTO mibNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Te ná ni cajini sōho un jnúhun yáha, te yōhyo ni caquɨtɨ̄ ni, te cahni de cácuni nuú. ");
INSERT INTO mibNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Te mēhñú un jíjnáhan néne ɨɨn tēe grupo fariseo nání de Gamaliel, te cúu de maestro jeē steén ley yā, te tāca ñáyuu cájejnúhún i de. Te ni ndocuɨñɨ̄ de, te ni ndacu de jniñu jeē na cújiyo núu tēe apóstol. ");
INSERT INTO mibNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Te ni cahān de: Róhó jnáhan ñuu yō Israel, cani vāha ni rō núu na vé cácuni rō sáha ró jíín táca tée yáha. ");
INSERT INTO mibNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Chi nucūhun ni rō jeē ɨɨn cuiyā ni ndonda Teudas sɨquɨ̄ gobierno, te ni cahān de jeē tée téyɨ́ cúu de, te ni cacutútú nájnūhun cuūn ciento tēe jíín de. Yūcuán na te ni cajehni ñayuu Teudas, te tāca jéē ní caquijnáhan jíín de ni cajitē núu cuangoo sáá‑ni, te ni jecuɨñɨ̄‑ni jniñu ún. ");
INSERT INTO mibNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yūcuán na te quɨvɨ̄ ni íyo censo te Judas, ɨɨn tēe Galilea, ni ndonda de sɨquɨ̄ gobierno, te ni cacutútú cuéhē tēe jíín de. Te suni ni cajehni ñayuu Judas, te tāca tée jeē ní caquijnáhan jíín de ni cajitē núu cuangoo. ");
INSERT INTO mibNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Te vijna na cuáha ri consejo rohó. Ma stáhān gā rō tēe yáha. Siáá de na quíngoo de. Chi núu ñayuu‑ni ni squejéé jniñu yáha, te jecuɨñɨ̄ iī. ");
INSERT INTO mibNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Te núu Yaā Dios ni squejéé, te ma cúu casɨ rō, chi sanaa te sɨquɨ̄ Yaā Dios cándonda ró, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Te ni cachusóhó jéē ni cáhān Gamaliel. Te ni canacana tēe cácuu apóstol, te ni cacani de jíín cuarta ñɨɨ te ni cacahān xeēn jiín de jeē ma cahán gā de jnūhun Jesús, te ni casiáá de cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Te máá apóstol ni quendacoo de nuū junta cuangoo de, cácusɨɨ̄ ni de jeē ni jéhe ya jnūhun ndoho de jeē cuáha ñayuu jnūhun canu de sɨquɨ̄ jeē cácandíje de ya. ");
INSERT INTO mibNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Te ndɨquɨvɨ̄ castéén de jnūhun vāha Jesucristo, te cánacani de jnūhun ún ini templo jiín táca‑ni vehe. ");
INSERT INTO mibNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Te ni cucuehē ñayuu cácandíje. Te tiempo un te tēe hebreo jeē cácahān yuhu griego, ni quejéé de cácahñu de nuū jnáhan hebreo de, áchí de jeē ñahan viuda jeē cácahān yuhu griego tu cánihīn vāha ña staā jeē cásaja de tāca quɨ́vɨ̄ cuu ña. ");
INSERT INTO mibNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yūcuán na te máá ndɨhúxí uū apóstol ni canastútú de tāca ñáyuu cácandíje, te ni cacahān de: Tú vāha jeē jécuɨñɨ̄ jniñu jeē cánacani ri jnūhun Yaā Dios sɨquɨ̄ jeē cásaja rī staā. ");
INSERT INTO mibNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Núu súcuan te róhó, hermano, nacāji ró úxā jnáhan máá yó, te na cóndiso jníñu de saja de staā. Te nacāji ró tée jeē cájejnúhún ñáyuu de, tēe ndíchí jéē ní cunuú Espíritu Santo jiín de. ");
INSERT INTO mibNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Te ruhū jijnáhan ri, máni cacān tahú rī jiín jéē nácani ri jnūhun ya, achí de. ");
INSERT INTO mibNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Te ndɨhɨ ñayuu ni canujnahan ni i jnūhun ni cacahān de. Te ni canacāji i Esteban, tēe cándíje vāha jeē ní cunuú Espíritu Santo jiín de. Te suni ni canacāji i Felipe jiín Prócoro jiín Nicanor jiín Timón jiín Parmenas jiín Nicolás. Te Nicolás cúu tēe ñuu Antioquía, te ni nduu de tēe cándíje sahān ñayuu hebreo nde ná tu candíje de jnūhun Cristo. ");
INSERT INTO mibNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Te ni cajeni i tāca tée yáha núū tée cácuu apóstol, te tēe apóstol un ní casoó de ndaha de xinī tāca tée un ní cajicān tahú de nuū Yaā Dios sɨquɨ̄ jníñu condiso de. ");
INSERT INTO mibNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Te jnūhun Yaā Dios ni jitē gā cuahān, te ni nducuehē teyɨ́ ñáyuu cácandíje i jnūhun ya ini ñuu Jerusalén. Te suni cuehē sutū ni cacandíje de jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Te ni chindéé ñáhán yá Esteban ni jēhe ya poder nuū de, te ni sáha de tācá jniñu jéhnu nuū ñáyuu, jniñu jeē steén jeē cujéhnu Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Te ñayuu hebreo jeē ní cacuyāhu i te ni canduu libre i, íyó vehe iī sinagoga i. Te tēe un cácuu tēe ñuu Cirene jiín tée ñuu Alejandría jiín tée Cilicia jiín tée Asia. Te sava tēe un ní caquejéé de cástáhān jnáhan de jíín Esteban. ");
INSERT INTO mibNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Te tu ní cácundeyɨ́ jíín de, chi ndíchí ní cahān de ni sáha máá Espíritu Santo. ");
INSERT INTO mibNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yūcuán na te ni cascáhán sava tēe jeē na cáhán jnūhun stáhú sɨ́quɨ̄ Esteban. Te ni cacahān jeē ní cajini sōho cáhán ndevāha Esteban sɨquɨ̄ Moisés jiín sɨ́quɨ̄ Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Te jeē súcuan ni cacahān te ni caquɨtɨ̄ ni tāca ñáyuu jiín tée jéhnu cándīso jníñu jíín tée cástéén jnūhun tutu ley yā. Te ndɨhɨ de ni candonda sɨquɨ̄ Esteban, te ni cajnɨɨ de cuangoo jíín de nde nuū junta cujéhnu ga. ");
INSERT INTO mibNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Te ni cajeni de tēe cahān jnūhun yáá sɨ́quɨ̄ Esteban, te suhva ni cacahān: Tēe yáha tu ndé jécuɨñɨ̄ de jeē cahán ndevāha de sɨquɨ̄ templo iī yáha jíín sɨ́quɨ̄ ley yā. ");
INSERT INTO mibNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Chi ni cajini sōho ná cáhán de jeē Jesús, tēe ni jehnu ñuu Nazaret, canu de templo yáha te nasama de jeē tajnúní ley yā jeē ni jéhe Moisés nuū yō, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yūcuán na te ndɨhɨ tēe cáyūcu núū junta un ní candacoto vāha nuū Esteban, te ni cajini jeē jíto nuū de ná jíto nuū ɨɨn ndajéhé Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Te máá sútū cujéhnu ga ni cajnūhún Esteban: ¿A ndáā jeē súcuan ni sáha ró nájnūhun cácahān de yāhá? áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Te ni cahān Esteban: Ndɨhɨ níhín jéē cácuu ní jnáhan ñuu yō, jíín ndɨhɨ níhín jéē cácujéhnu ní núū ñúū yō, cuni nahín ní jnūhun cahān ná: Máá Yáā Dios jeē yóhyo cújéhnu ya, ni steén yā maá yá nuū jií yō Abraham nde na néne ga de región Mesopotamia, nde ná tu quihīn de condee de ñuu Harán. ");
INSERT INTO mibNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Te ni cahān yā jiín de: Stóo ñuu rō jiín táca jnáhan ró te quihīn rō nuū cuáha ri condee rō, chi máá rí steén ichi nuū quihín rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yūcuán na te ni quenda de región Caldea, te ni jinū de ni condee de ñuu Harán. Te yūcuan ní jihī tatá de. Yūcuán na te ni sáha Yaā Dios jeē ní quee de ñuu yáha núū cáyūcu yó vijna. ");
INSERT INTO mibNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Te tu ní jéhe ya ni ɨɨn tíhlí ñuhun yáha cuu tahū de. Te vēsú súcuan te ni jejnūhun ya jeē cuáha ya ñuhun un núū de nde jiín núū tāca séhe de, vēsú ná tu coo sēhe de sáá. ");
INSERT INTO mibNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Te súcuan ni cahān Yaā Dios jiín de: Sēhe ró coyūcu jícá i ɨnga ñuu, te cuūn ciento cuiyā sájniñu sáá‑ni i te stóho ñayuu yúcuan i. ");
INSERT INTO mibNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Te sɨquɨ̄ jeē súcuan sáha i jíín séhe ró, te máá rí chi stóho ri ñayuu ñuu ún. Te sáá te quendacoo sēhe ró yúcuan, te nucoyūcú i yāhá chiñúhún i ruhū, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Te ni cahān yā jiín Abraham jeē na cúu de circuncidar, jeē cúu ɨɨn jnunī jeē ni sáha ya contrato jiín de. Te ná ni cacu sēhe de Isaac te ni sáha de circuncidar i nuū uná quɨvɨ̄. Te suni súcuan ni sáha Isaac jiín séhe de Jacob, te Jacob jiín séhe yɨɨ́ de jeē cácuu ndɨhúxí uū yucūn ñayuu Israel. ");
INSERT INTO mibNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Te tāca séhe Jacob ni cacucuésún ni de jíín ñani maá de José, te ni caxīcó de i nuū tée jeē ní cajendēca i nde nación Egipto. Te Yaā Dios chi ni ndito ya José. ");
INSERT INTO mibNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Te ni jnama ya i nuū tāca jnúndóho ní jito i, te ni cundíchí i ni sáha ya. Te Faraón, tēe cúu rey nación Egipto, ni cusɨɨ̄ ni de jíín i ni sáha ya, te ni tejníñu de José jeē cúu de gobernador te ndacu de jniñu nación Egipto jiín núū ñáyuu cáyūcú vehe Faraón. ");
INSERT INTO mibNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Te ni quiji quɨvɨ̄ jeē ni íyo ɨɨn jnamā xeēn, te ni ndoho ñayuu nɨɨ́ cáhnu nación Egipto jiín ndé ñuu Canaán. Te tāca jíí yō ún, tuá ni cánihīn de jeē cáji de. ");
INSERT INTO mibNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Te ni nihīn Jacob jnūhun jeē iyó trigo nde nación Egipto, te ni tají de sēhe de ni jengoo de ni cajeen de trigo vuelta ɨɨn. ");
INSERT INTO mibNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Te jeē cuángoo de vuelta uū te ni nastúu José jeē maá de cúu ñani de jíjnáhan de. Yūcuán na te ni jini rey Faraón ndé ɨɨn jnáhan cúu José. ");
INSERT INTO mibNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Te ni cahān José jiín táca ñani de jeē na cóndeca de tátá de Jacob jiín ndɨhɨ jnáhan vehe de. Te ni īyo unī xico xahūn i. ");
INSERT INTO mibNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Te súcuan ni cuu jeē ni jínū Jacob ni condee de nación Egipto nde ni jihī de. Te suni yūcuan ní coyūcu séhe de jeē cácuu jíí yō un ndé ni cajihī maá de. ");
INSERT INTO mibNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Te ná ni quee quɨvɨ̄ jeē ndénehen ya tāca yúcūn de jeē cáyūcu tátú de nación Egipto, te ni cacondiso de yɨquɨ ndɨhúxí uū ndɨ̄yɨ jií un jéē ndíji ñuu Siquem, te ni cachindūji de ini yaū ndɨ̄yɨ ndeé jícā cáva jeē ní jeen jíí yō Abraham nuū tāca séhe Hamor ñuu Siquem. ");
INSERT INTO mibNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Te nde ná cáyūcu gá de nación Egipto, te cuacuyajni quɨvɨ̄ jeē squícu jnūhun ni cahān Yaā Dios jiín Abraham jeē quéndacoo sēhe de nucoyūcú i ñuu ni jéjnūhun ya nuū i, te ñayuu un ní tahū cuehē i ini nación Egipto. ");
INSERT INTO mibNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yūcuán na te ni nucuɨñɨ̄ ɨnga rey ñuu Egipto jeē tu ní jíní de jeē váha ni sáha ndɨ̄yɨ José. ");
INSERT INTO mibNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Te rey un ní stahú de tāca jíí yō te ni sáha ndevāha de jíín i, chi ni sáha fuerza de i jeē ma cóto ga i sēhe yɨquɨ́n i te na cúū. ");
INSERT INTO mibNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Te tiempo un ní cacu Moisés, te ni cusɨɨ̄ ni Yaā Dios jiín i. Te unī yoō ni condito sāhi náná i tátá i. ");
INSERT INTO mibNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Te tuá ni cúu condito sāhí de i, te ni cachune de i nuū nanihīn sēhe sɨ́hɨ́ Faraón i, te ni naquihin séhe ña i ni scuéhnu ña i nájnūhun sēhe máá ña. ");
INSERT INTO mibNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Te ni cutūhva Moisés tāca jnúhun ndíchí ñuu Egipto, te ni cujéhnu de jíín jnúhun cáhán de jíín jniñu sáha de. ");
INSERT INTO mibNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Te nuū uú xico cuiyā de te ni jecondēhé de jnáhan de jeē cácuu ñayuu Israel. ");
INSERT INTO mibNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Te ni jito de nuū ɨɨn tēe nación Egipto jeē sáha ndevāha jíín ɨɨn tēe Israel. Te Moisés ni jnama de jnáhan de Israel ún, chi ni jehni de tēe Egipto un. Te súcuan ni ndutahū jeē ni sáha ndevāha jíín jnáhan de ún. ");
INSERT INTO mibNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Te máá Moisés jéni ni de jeē jécūhun ni tāca jnáhan de jeē Yáā Dios ni tají yá de jeē jnáma de jnáhan de ún ini nación Egipto nuú, te tu ní cájecūhun cuɨtɨ ni jnáhan de ún. ");
INSERT INTO mibNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Te ɨnga quɨvɨ̄ suni ni jito de nuū uú tēe Israel jeē cájejnáhan, te cúní de jeē na jécuɨñɨ̄. Te jeē yúcuan ní cahān de jíín: ¿Najehē casáha ndevāha ró jíín jnáhan ró? Chi nájnūhun ɨɨn ñani‑ni cácuu ró, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Te máá tée cáni tahū jnáhan un ní chundahá de Moisés te ni cahān de: ¿Ndé ɨɨn ni jeni róhó jéē cujéhnu ró núū rī te sándaā rō jniñu ri jijnáhan ri? ");
INSERT INTO mibNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Chí suni cúní rō cahni rō ruhū nájnūhun ni jehni rō tēe Egipto icu chí naún? áchí de jíín Moisés. ");
INSERT INTO mibNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Te nuū ní jini sōho Moisés jnūhun yáha, te ni yūhú de jeē cáhni rey de, te ni jinu de cuahān de ɨnga nación. Te ni condee de ñuu jicá Madián, te yūcuan ní scácu ñasɨhɨ́ de uū sēhe yɨɨ́ de. ");
INSERT INTO mibNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Te ni jīnu uū xico cuiyā jeē néne de yūcuán. Yūcuán na te ɨɨn ndajéhé Yaā Dios ni quenda ya nuū de nde nuū ñúhun téhé nuū íin yucu súcún Sinaí. Te ni quenda ya nuū de xinī ɨɨn yucū cuíi cáhnu cándahá yáñuhūn, te tu ní cáyú yucū ún. ");
INSERT INTO mibNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Yūcuán na te Moisés ni naa ni de jíto de ún, te ni jehēn de nde nuū, návāha coto vāha de. Te ni jini sōho de jeē cahán maá Jítoho yō jiín de: ");
INSERT INTO mibNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Máá rí cúu Yaā Dios tāca jíí rō jenahán, Abraham jiín Isaac jiín Jacob, achí yá. Te Moisés, quɨ́sɨ i de jeē yūhú de, te jeē yúcuan tuá ni cúndeyɨ́ ni de coto de nuū. ");
INSERT INTO mibNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Te máá Jítoho yō ni cahān yā jiín de: Quenehen ndijēn rō chi nuū íin ró, ñuhun íí cúu. ");
INSERT INTO mibNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Je ni jini rī ñayuu maá rí jeē yóhyo cándoho i nación Egipto, te suni jíni sōho ri jeē cájnana uhū i, te ni cuun ri vēji ri jeē jnáma ri i jíjnáhan i. Núu súcuan te vijna chi tají rí rohó ndicó ró quihīn rō nde nación Egipto, achí yá jiín de. ");
INSERT INTO mibNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Te nde ná tu quenda Moisés Egipto, te tāca jnáhan de ni casquéhichī i de jeē ní cacahān i jíín de: ¿Ndé ɨɨn ni jeni róhó jéē cujéhnu ró núū rī te sándaā rō jniñu ri? ni cacahān i jíín de. Te vēsú súcuan te máá ndajéhé Yaā Dios ni quenda nuū Moisés un jéē cándahá cáyú yucū cuíi ún. Te súcuan ni cuu jeē ní natají yá de cuanuhun de nde Egipto jeē ndácu de jniñu nuū i te jnama de i. ");
INSERT INTO mibNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Te máá Moisés ni sáha de jeē ní quendacoo jnáhan ñuu de ini nación yúcuan, te ni cayāha de Mar Rojo, te ni cajica cuu de ñuhun téhé úū xico cuiyā. Te nɨ́ɨ́ tiempo un ní sáha de cuehē jniñu jéhnu jeē steén jeē cujéhnu Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Te máá Moisés cúu jeē suhva ni cahān de jnūhun yáha jíín jnáhan ñuu yō Israel: Máá Yáā Dios cani ya Yaā nacani jnūhun nuū rō jijnáhan ró nájnūhun ni jeni ya ruhū. Te cuu ya ɨɨn jnáhan ñuu yō. Te na chúhun ni rō jnūhun cahān Yaā ún, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Te suni nde ná ni cajica cuu jíí yō nde nuū ñúhun téhé, te ni cahān ndajéhé yā jiín Moisés xinī yúcu súcún Sinaí, te ni nihīn de jnūhun jeē cahán ndese nihīn tahú yō cotecu yō, te ni nacani de jnūhun un núū tāca jíí yō, te ni quendōo jnūhun un núū yō. ");
INSERT INTO mibNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Te tāca jíí yō ún tu ní cácuni de cuandetū de nuū Moisés, chi sa suhva ni cacuni de squéhichī ni de Moisés, te ni cacuni de nandicó de nungoo de Egipto nuú. ");
INSERT INTO mibNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Te ni cacahān de jíín Aarón: Sáha ní tɨjnɨ yaā na cósnūu núū yō. Chi Moisés, jeē ní quenehen de yóhó Egipto vējicoo yó, tu cájini yō na vé ni ndoho de jeē tú de ndéē jeē cuahán de xinī yucu Sinaí, achí. ");
INSERT INTO mibNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yūcuán na te ni cajēhe de oro ni cuvāha ɨɨn becerro oro, te nuū becerro ídolo un ní casocō de quɨtɨ, te ni cacusɨɨ̄ ni de jíín ídolo ni casáha de ún. ");
INSERT INTO mibNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Te Yaā Dios ni cujiyo ya cuahān yā, te ni stóo ya de na chíñúhún de nuū tāca jéē jíto yó íin andɨvɨ́, nájnūhun yósó núū tútu tēe ni canacani jnūhun Yaā Dios nde jenahán: Ni cahān yā: Róhó ñáyuu Israel, ¿á cájeni ni rō jeē nuū ruhū ni casocō rō quɨtɨ ná ni cajica cuu ró úū xico cuiyā nde nuū ñúhun téhé? ");
INSERT INTO mibNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tuú, chi sa suhva ni cacondiso ró nicho jeē íne ídolo jeē naní Moloc jíín figura quɨ̄mɨ jeē naní Renfán, ídolo jeē ní casáha máá ró ni cachiñúhún ró. Jeē yúcuan cúu jeē siáha ri rohó quíhīn jicá ró nde yatā ñúū Babilonia, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Te ni ndacu ya jniñu nuū Moisés jeē na sáha de vehe ñɨɨ nuū chiñúhún de ya, nájnūhun cáa jeē ní steén yā nuū de. Te tāca jíí yō, nde nuū ñúhun téhé ní canevāha de vehe iī un núū ní cachuvāha de tabla yuū jeē yosó jnúhun ley yā. ");
INSERT INTO mibNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Te ni castóo de vehe un núū ndɨhɨ sēhe de jeē cúu jíí yō. Te ni quɨ̄vɨ Josué jiín jíí yō ini nación yáha, te ni sáha ya jeē ní cacundeyɨ́ de jíín táca ñáyuu jeē ní cacoyūcu yáha ní cajinu i cuangoo i. Te ni quɨ̄vɨcoo de tācá ñuu i jíín vehe iī ún, te ni quendōo nde quɨvɨ̄ ní cuu David rey. ");
INSERT INTO mibNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Te ni cusɨɨ̄ ni Yaā Dios jiín rey David. Te ni jicān de nuū yā jeē sáha de ɨɨn vehe iī yā nuú, chi máá yá cúu Yaā Dios jií de Jacob. ");
INSERT INTO mibNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Te ni cuu jeē nde sēhe yɨɨ́ de Salomón ni sáha vehe iī yā. ");
INSERT INTO mibNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Te vēsú súcuan ni cuu te Yaā cujéhnu téyɨ́, tu ndéé yá maá vehe jeē casáha ñayuu, nájnūhun ni cahān tēe ni nacani jnūhun ya nde jenahán: ");
INSERT INTO mibNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ni cahān yā: Andɨvɨ́ cúu nájnūhun mesa nuū ndácu ri jniñu te ñayɨ̄vɨ cúu nájnūhun ɨɨn nuū yɨ́tuu jehē rī. Núu súcuan ¿te ndese cuu sáha ró vehe jeē cóndee rī, te ndese cuu sáha ró núū ndétātu rí? ");
INSERT INTO mibNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿A násūu máá rí ní sáha ndɨhɨ jeē iyó? áchí máá Jítoho yō Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Te cáhán gā Esteban: Yōhyo cácunīhni ni ní, te tu cácuni ní chusóhó ní, te cácuu ní nájnūhun ñayuu tācá nación jeē tu cájini i jnūhun ya ni tu cácandíje i ya. Chi níní cájesɨ ni núū Espíritu Santo, te nájnūhun ni casáha jíí yō jenahán, suni súcuan cásáha ní vijna. ");
INSERT INTO mibNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿A ní īyo tēe nácani jnūhun ya nde jenahán jeē tu ní sáha ndevāha jíí yō jiín de? Chi jíí yō ni cajehni de tēe ni canacani jnūhun jeē quíji máá Yáā ndaā. Te je ni quiji Yaā ún, te máá ní ni canastúu ni yá nuū tée ni cajehni de ya. ");
INSERT INTO mibNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Te vēsú nde jiín táca ndajéhé yā ni jēhe ya ley yā nuū yō, te máá ní chi tu cásquícu ní, áchí Esteban. ");
INSERT INTO mibNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tāca jnúhun yáha ní cajini sōho, te yōhyo ni caquɨtɨ̄ ni, te cánacayɨ̄hɨ́ yuhu cájito nuū Esteban. ");
INSERT INTO mibNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Te máá Esteban chi ni cunuú Espíritu Santo jiín de. Te ni jito de ichi ándɨvɨ́, te ni jini de jeē ndíndēe núū néne Yaā Dios, te índichi Jesús ichi ndáváha ya. ");
INSERT INTO mibNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Te ni cahān de: Vijna te jíto ri jeē núne andɨvɨ́, te jíto ri nuū maá Yáā ní nduu tēe, índichi yā nuū cujéhnu ya lado váha Yaā Dios, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Yūcuán na te ni cajesɨ un sóho, te ni cacana cóhó, te ɨnuú‑ni ni candonda sɨquɨ̄ Esteban. ");
INSERT INTO mibNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Te ni caquenehen Esteban cuangoo jíín de nde yatā ñúū. Te tēe ni cacahān yaá un jíín ndɨhɨ jnáhan de ni cachucú de tɨcāchí de ndíto ɨɨn tēe suchí nání Saulo, te ni cacani de yuū xinī Esteban. ");
INSERT INTO mibNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Te níní jéē cácani tāca tée un yúū xinī de te ni jicān tahú de nuū yā: Tátā Jesús jeē cúu ní Jitoho ná, naquihin ní ánuá na vijna, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Te ni jecuɨñɨ̄ yɨtɨ́ de te ni cahān jee de: Tátā Yaā Dios, ma quénehen ní cuéchi sɨquɨ̄ i jeē casáha i jíín ná, áchí de. Súcuan ni cahān de te ni jihī‑ni de. ");
INSERT INTO mibNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Te Saulo, ni nujnahan ni de jeē ni jíhī Esteban. Te quɨvɨ̄ un ní caquejéé de cájito xeēn ndasɨ́ de ñayuu cácandíje Jesús ini ñuu Jerusalén, te jeē yúcuan cúu jeē ní cajitē núu ñayuu cácandíje cuangoo i nɨ́ɨ́ Judea jiín nɨ́ɨ́ Samaria. Te tēe apóstol chi tu ní cájitē núu de. ");
INSERT INTO mibNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Te sava tēe yɨ́ñúhún núū Yaā Dios, ni cachindūji de Esteban. Te yōhyo ni candahyū de jeē ni jíhī Esteban. ");
INSERT INTO mibNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Te Saulo chi jíto xeēn de ñayuu cácandíje, te quɨ́vɨ de ndɨjnahan vehe te jnɨ́ɨ de tēe, ñahan, chúhun de i vecāa. ");
INSERT INTO mibNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Te tācá ñuu nuū cuángoo tāca ñáyuu ní cajitē núu un ní canacani i jnūhun ndese jnáma Yaā Dios ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Te ni jinū Felipe ɨɨn ñuu ndañúū Samaria, te nuū ñáyuu yúcuan ní nacani de jnūhun Cristo, Yaā ní jeni Yaā Dios jeē jnáma ya yohó. ");
INSERT INTO mibNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Te tāca ñáyuu ní cacutútú un ní cajini nahín váha i tāca jnúhun ni nacani Felipe, te ni cajito i tācá jniñu jéhnu ni sáha de. ");
INSERT INTO mibNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Chi cuehē ñayuu cándoho tachī ni canduvāha i, te cácana cóhó táchī un ní caquendacoo. Te cuehē ñayuu ni íjin jíín ñáyuu ríngo ni canduvāha. ");
INSERT INTO mibNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Te jeē yúcuan ní cacusɨɨ̄ teyɨ́ ni ñayuu ñuu ún. ");
INSERT INTO mibNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Te ini ñuu un néne ɨɨn tēe nání Simón, te tēe tásɨ́ cúu de. Te nde ná tu jinū Felipe ñuu Samaria, te yōhyo cánaa ni ñayuu ñuu un cájito i jeē sáha Simón, te ni stahú de i ni cahān de jeē ɨ́ɨn tēe cújéhnu téyɨ́ cúu máá de. ");
INSERT INTO mibNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Te nde tēe cácujéhnu jíín ndɨvii cuɨtɨ ñayuu, cájetáhú ndasɨ́ i jnūhun cáhán de, te ni cajeni ni maá i te ni cacahān i: Tēe yáha ní jēhe Yaā Dios cuehē poder nuū de, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Te cájetáhú váha i jnūhun cáhán de, chi cuehē tiempo ni sáha de jniñu stáhú ní canaa ni i ni cajito i. ");
INSERT INTO mibNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Te nuū ni jínū Felipe, ni nacani de jnūhun vāha ndese ndácu Yaā Dios jniñu, jíín jnúhun Jesucristo, te ni cacandíje i te ni cajendute i, cúu tēe cúu ñahan. ");
INSERT INTO mibNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Te suni máá Simón ni candíje de te ni jendute de, te ni jica cuu de jíín Felipe. Te ni naa ni de jíto de tācá jniñu jéhnu jeē sáha Felipe jeē steén jeē cujéhnu Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Te cáyūcu tée apóstol ñuu Jerusalén, te ni canihīn de jnūhun jeē ñáyuu Samaria ni cacandíje i jnūhun Yaā Dios. Te ni catají de Pedro jiín Juan cuangoo de yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Te ni jinūcoo de, te ni cajicān tahú de jehē ñáyuu un návāha na quɨ́vɨ Espíritu Santo ini anuá i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Chi ná tu quɨ̄vɨ ya ini anuá ni ɨɨn i, chi máá‑ni jeē ní cajendute i jeē ní cacandíje i Jitoho yō Jesús. ");
INSERT INTO mibNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yūcuán na te Pedro jiín Juan ni casoó de ndaha de xinī i jíjnáhan i, te ni quɨ̄vɨ Espíritu Santo ini anuá i. ");
INSERT INTO mibNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Te ni jito Simón jeē súcuan cásoó apóstol ndaha de xinī ñáyuu ún te súcuan quɨ́vɨ Espíritu Santo ini anuá i, te cúní de cuāha de xūhun núū tée apóstol návāha nihīn de poder un núú. ");
INSERT INTO mibNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Chi ni cahān de: Cúní na jéē cuāha ní poder yáha núū na, návāha núu ndé ñáyuu soó ná ndaha ná xínī i te quɨ̄vɨ Espíritu Santo ini anuá i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Yūcuán na te ni cahān Pedro jiín de: Na náā xūhun ró je jnahnū ndetū rō sɨquɨ̄ jeē jéni ni rō jeē jiín xúhun te cuu cuaan ró táhū jeē véji nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ma nihín tahú rō jeē sáha ró jniñu yáha, chi tu íyó ndáā anuá rō nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Núu súcuan te jíni ñúhún jéē stóo rō jnúhun jeē jéni néé ni rō súcuan te cahān ndahú ró jiín Yáā Dios, te máá yá sanaa te cone cáhnu ni yā sɨquɨ̄ jeē jéni néé ni rō súcuan. ");
INSERT INTO mibNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Chi jíní rī jeē cucuésún ni rō sɨquɨ̄ jeē sáha ri jniñu yáha. Te tāca jéē neé jéni ni rō ni cunuú un jíín ró, achí Pedro jiín de. ");
INSERT INTO mibNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Yūcuán na te ni cahān Simón jiín de: Cacān tahú ni jéhē na jíjnáhan ní núū maá Jítoho yō návāha tú jnahnū ndetū na nájnūhun ni cahān ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Te Pedro jiín Juan ni cacahān cají de ndese cácandíje de jnūhun Yaā Dios. Te jeē cuánungoo de ichi ñúū Jerusalén, te tɨjnɨ ndañúū Samaria ni canacani de jnūhun jeē jnáma ya ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yūcuán na te ni cahān ndajéhé maá Jítoho yō jiín Felipe: Quihin ichi te quihīn rō ichi sur, ichi jeē quénda Jerusalén cuahān nde ñuu Gaza, áchí yá. Te ichi chúcuan chi máá ñuhun téhé cúu. ");
INSERT INTO mibNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Te ni quihin Felipe ichi cuahān de. Te nde nación Etiopía ni quiji ɨɨn tēe eunuco jeē ndíso jníñu de cúu de tesorero nuū ñáhan cúu reina ndácu jniñu nación Etiopía, nání ña Candace. Tēe un ní quichiñúhún de Yaā Dios ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Te cuanuhun de néne de nuū carreta de, te cáhu de tutu jeē ní tee Isaías, tēe ni nacani jnūhun Yaā Dios nde jenahán. ");
INSERT INTO mibNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Te máá Espíritu ni cahān yā jiín Felipe: Cuáhán quíjnahan rō tēe cuahān jiín carreta un. ");
INSERT INTO mibNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Te ni jejnahan Felipe carreta un, te ni jini sōho de jeē cáhu tēe ún tutu jeē ní tee Isaías. Te ni cajnūhún de tēe ún: ¿A jécūhun ni ni jnúhun jeē cáhu ní chí tuú? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Te ni cahān maá tée un jíín Felipe: ¿Te ndese jecūhun ni ná? Chi tú na tēe castūhun núū ná ndese cúu ún, áchí de. Te ni cahān de jíín Felipe jeē na cáa de conēne ndúú de jíín de ini carreta. ");
INSERT INTO mibNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Te jnūhun cáhu de tutu iī un cáhán suhva: Nájnūhun lanchi jeē cuahán tɨ̄ nuū cúū tɨ̄, súcuan ni casáha ñayuu jiín yá. Te nájnūhun ɨɨn londe quɨtɨ sáte jéē tu ndáhyú tɨ̄, súcuan ni sáha ya, chi tú na vé ni cáhán cuɨtɨ yā ná ni cajicān i cuēchi sɨquɨ̄ yā. ");
INSERT INTO mibNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Te hora jeē ní cajēhe i jnūhun canu yā, tu ní cásáha ndaā i sɨquɨ̄ yā jiín jnúhun ndaā, te ni cajehni i ya ini ñayɨ̄vɨ yáha. Te coo cuehē ñayuu candíje nuū yā jeē ma cánda ni ɨɨn ñayuu cahu i ñayuu ún. Achí. ");
INSERT INTO mibNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yūcuán na te ni cahān tēe Etiopía un: Cava vāha ni ní cachi ni núū ná, ¿ndé sɨ́quɨ̄ cahán tēe ni nacani jnūhun yáha? ¿A sɨ́quɨ̄ maá de chí sɨ́quɨ̄ ɨ́nga tēe? áchí de jíín Felipe. ");
INSERT INTO mibNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yūcuán na te ni nacani Felipe jnūhun vāha Jesús nuū tée ún, chi ni quejéé de ni castūhún de jnūhun jeē ní cahu tēe ún, jíín táca gá jnūhun jeē yosó núū tútu yā. ");
INSERT INTO mibNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Te níní cuángoo de ichi ún te ni jinūcoo de nuū ñúhun ndute, te ni cahān tēe Etiopía: Yāha ñúhun ndute ¿te á tú cuu cuandute ná? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Te ni cahān Felipe: Cuu te núu cándíje nīhin ni ndé jiín ini jiín ánuá ni táca jéē ni sáha Jitoho yō Jesús jehē yō, achí de. Te ni cahān tēe Etiopía: Cándíje ná jéē Jesucristo cúu máá Séhe Yaā Dios, achí de. ");
INSERT INTO mibNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Te ni sáha de jeē na jécuɨñɨ̄ carreta de, te ni nuu ndɨndúú de cuangoo de ichi véyɨ́ núū ñúhun ndute ún, te ni scuándute Felipe tēe Etiopía. ");
INSERT INTO mibNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Te nuū ní quendacoo de nuū ndúte, te Espíritu maá Jítoho yō ni sáha ya jeē ní ndoñúhún‑ni Felipe. Te tēe Etiopía vēsú tuá ni jíto de nuū Felipe, te cúsɨɨ̄ ni de cuahān de. ");
INSERT INTO mibNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Te ni nane Felipe ñuu Azoto. Te nácani de jnūhun ndese jnáma ya ñayuu, cuahān de tācá ñuu nde ni jinū de Cesarea. ");
INSERT INTO mibNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Te Saulo chi máni cáhán de jeē cáhni de tāca ñáyuu cácandíje i máá Jítoho yō, te jeē yúcuan ní jehēn de nuū sutú cujéhnu ga. ");
INSERT INTO mibNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Te ni jicān de carta jeē cahán jeē quihín de tācá vehe iī sinagoga ñuu Damasco te cuhni de tēe ñahan jeē cácandíje i Jesús, quiji de jíín i ñuu Jerusalén nuú. ");
INSERT INTO mibNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Te ni quihin de ichi cuahān de. Te cuacuyajni de ñuu Damasco, te sanaa‑ni te ichi ándɨvɨ́ ní stíndēé ɨɨn luz nuū de. ");
INSERT INTO mibNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Te ni cotúú‑ni de nuū ñúhun, te ni jini sōho de ɨɨn jnūhun cáhán jiín de: Saulo, Saulo, ¿najehē jíto xeēn rō ruhū? achí. ");
INSERT INTO mibNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Te ni cahān maá de: ¿Na nihín cúu jeē cahán, Tátā? Te ni cahān yā jiín de: Máá rí cúu Jesús, te jeē jíto xeēn rō ñayuu cácandíje i ruhū cúu jeē jíto xeēn rō ruhū. Te jeē sáha ró súcuan cúu nájnūhun stɨquɨ̄ jeē tu jéndíje tɨ te jéñú yatá tɨ́ xinī pulla, te súcuan stóho tɨ maá tɨ́, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Te máá de chi quɨ́sɨ i de jeē yūhú de, te ni cahān de: Tátā, ¿na vé cuní ni jéē sáha ná núu súcuan? áchí de. Te ni cahān maá Jítoho yō jiín de: Ndocuɨñɨ̄, quɨ̄vɨ ró ini ñuu, te yūcuan íyó ɨɨn tēe jeē cachi nuū rō na vé cúu jeē cánuú sáha ró, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Te tēe cuangoo jíín Saulo, ni canaa ndasɨ́ ni de cájini sōho de ndusu jeē cahán, te tu ní cájito cuɨtɨ de nuū jeē cahán un. ");
INSERT INTO mibNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Yūcuán na te ni ndocuɨñɨ̄ Saulo. Te ni nducú de coto de, te tuá cúu coto de, te ni cajnɨɨ tēe ún ndaha de ni jinūcoo jíín de nde ini ñuu Damasco. ");
INSERT INTO mibNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Te yūcuan ní condee de unī quɨvɨ̄. Te tu ní cúu cuɨtɨ coto de, ni tú na vé ni yéji de, ni tú na vé ni jíhi de. ");
INSERT INTO mibNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Te ñuu Damasco néne ɨɨn tēe cándíje, nání de Ananías. Te máá Jítoho yō ni steén ndijin ya maá yá nuū de te ni cahān yā jiín de: Ananías, achí yá. Te máá de ni cahān de jíín yá: Naun ní sáña, Tátā, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Te ni cahān maá Jítoho yō jiín de: Quihin ichi te quihīn rō calle jeē naní Calle Derecha, te vehe Judas cajnūhun ró ɨɨn tēe nání Saulo ñuu Tarso, chi jícán tahú de. ");
INSERT INTO mibNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Te nájnūhun ni jito ndijin de jeē maá ró, Ananías, ni jinū rō, te ni soó ró ndaha ró xínī de, te ni nanune tɨnūú de, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yūcuán na te ni cahān Ananías: Tátā, cuehē ñayuu cácahān jeē tée yúcuan yōhyo jíto xeēn de ñayuu cácandíje i níhín ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Te vijna ni quee de yāhá, chi sutū cácujéhnu ni catejníñu de vēji de jnɨɨ de tāca ñáyuu cácahān ndahú i jíín ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Te ni cahān maá Jítoho yō jiín de: Cuáhán, chi máá rí ni nacāji tēe un jéē quihīn de nacani de jnūhun ri nuū tāca ñáyuu nación Israel jiín núū ñáyuu tāca gá nación nde jiín núū tāca rey. ");
INSERT INTO mibNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Chi stéén rī nuū de jeē cánuú ndoho de cuehē jnūndóho jeē sɨquɨ́ rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yūcuán na te cuahān Ananías. Te ni quɨ̄vɨ de ini vehe nuū néne Saulo, te ni soó de ndaha de xinī Saulo, te ni cahān de: Hermano Saulo, máá Jítoho yō Jesús, Yaā ní quenda ndijin nuū ní ichi jeē véji ní, ni tají yá sāña véji ná núū ni návāha na nánune tɨnūu ní, te návāha na cúnuú Espíritu Santo yā jiín ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Te ni nanune‑ni tɨnūu Saulo, chi ni nungoo‑ni nájnūhun soō chācá ní condihyū tɨnūú de ún. Te ni ndocuɨñɨ̄ de ni jendute de. ");
INSERT INTO mibNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Yūcuán na te ni nacaji de staā, te ni nanihīn ni de. Te ni condee de jecu quɨvɨ̄ jiín tée cácandíje jeē cáyūcú ini ñuu Damasco. ");
INSERT INTO mibNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Te ni quejéé‑ni de nácani de jnūhun Jesús ini tācá vehe iī sinagoga, áchí de jeē Jesús cúu Sēhe Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Te tāca ñáyuu ni cajini sōho jnūhun cáhán de ni canaa ni i, te ni cacahān i: ¿A násūu tée yáha cúu jeē yóhyo jíto xeēn de tāca ñáyuu Jerusalén jeē cájicān tahú nuū Jesús? Te sɨquɨ̄ yúcuan ní quee de yāha jéē cúhni de ñayuu cácandíje, te quihīn de jíín i nuū sutú cácujéhnu núú, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Te víhyá gā ni nacani Saulo jnūhun ya, te ni steén cají de jeē Jesús cúu Cristo, Yaā ní jeni Yaā Dios jeē jnáma ya yohó. Te tēe hebreo jeē cáyūcú ñuu Damasco, tu ní cánihīn de modo cahān de jeē tu íyó ndáā jeē cahán Saulo. ");
INSERT INTO mibNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Te ni yāha cuehē quɨvɨ̄. Te jnáhan de hebreo ni casquíjnáhan jnūhun de jeē cáhni de Saulo. ");
INSERT INTO mibNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Te ni nihīn Saulo jnūhun jeē cándīto de nduú ñuú táca yéhyɨ́ pared jeē ní condúū ndihyú ñuu ún. ");
INSERT INTO mibNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Yūcuán na te ɨɨn jecuáā te tēe cácandíje ni caquihin de Saulo, te ini ɨɨn jīca cáhnu ni cascúun de Saulo jicā pared ún, te súcuan ni cācu de. ");
INSERT INTO mibNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Te nuū ní najinū de ñuu Jerusalén, te cúní de najnáhan de jíín tée cácandíje. Te ni cayūhu tée un ní cajito de Saulo, chi tu ní cácandíje de jeē ní nduu Saulo tēe cándíje nuū Jesús. ");
INSERT INTO mibNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Te Bernabé cuahān de jíín Saulo nuū cáyūcu tée apóstol, te ni nacani de jnūhun nuū tée ún ndese ni jini Saulo nuū maá Jítoho yō ichi nuū cuahán de, jíín jéē ni cáhān yā jiín de, jíín jéē jéhnu‑ni ni nacani de jnūhun Jesús ini ñuu Damasco. ");
INSERT INTO mibNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Te ni condee Saulo ñuu Jerusalén ni jica de jíín táca tée apóstol. ");
INSERT INTO mibNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Te jéhnu‑ni ni nacani de jnūhun máá Jítoho yō. Te jnáhan ñuu de hebreo jeē cácahān yuhu griego, ni castáhān jnáhan jíín de, te máá tée un cácuni de cahni de Saulo. ");
INSERT INTO mibNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Te ni cajini tācá hermano cácandíje, te ni cajendēca de Saulo nde ñuu Cesarea. Te yūcuan ní canatají de Saulo cuanuhun de nde ñuu de Tarso. ");
INSERT INTO mibNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Te ñayuu cácandíje Jesús jeē cáyūcú Judea jiín Galilea jiín Samaria, tuá ni cájito xeēn ñayuu i. Te ni ije ga i jíín jnúhun ya, te cándīso īyo i nuū maá Jítoho yō. Te Espíritu Santo ni chindéé ñáhán yá i te ni nducuehē gā i. ");
INSERT INTO mibNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Te tāca lado jécondēhe Pedro ñayuu cácandíje, te suni ni jecondēhé de ñayuu cácandíje cáyūcú ñuu Lida. ");
INSERT INTO mibNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Te yūcuan ní jini de nuū ɨ́ɨn tēe nání Eneas jeē ní cuu unā cuiyā cáa de chi ni ījin de. ");
INSERT INTO mibNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Te ni cahān Pedro jiín de: Eneas, Jesucristo cúu Yaā nasávāha ya rohó. Ndocuɨñɨ̄ te natuu rō yuu ró, áchí de. Te ni ndocuɨñɨ̄‑ni tēe ún. ");
INSERT INTO mibNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Te tāca ñáyuu cáyūcú ñuu Lida jiín ndúhvā Sarón ni cajito i jeē ní nacaca Eneas, te ni casquéndōo i tāca jnúhun jeē tu íyó ndáā te ni cacandíje i máá Jítoho yō. ");
INSERT INTO mibNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Te nde ñuu Jope ni īyo ɨɨn ñahan cándíje, nání ña Tabita, te nuū yúhu griego nání ña Dorcas. Te ñahan yáha máni jniñu váha ni sáha ña, te ni sáha ña caridad ni chindéé ñáhán ña ñayuu cúmanī nuū. ");
INSERT INTO mibNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Te tiempo yúcuan ní quejéé cuéhyɨ̄ jiín ña, te ni jihī ña. Te ni cascúchi i ndɨ̄yɨ ún, te ni cajequin i ndɨ̄yɨ un ndé ini cuarto xinī véhe. ");
INSERT INTO mibNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Te yajni íne ñuu Lida jiín ñuu Jope, te tēe cácandíje ñuu Jope ni cajini jnūhun de jeē néne Pedro ñuu Lida, te ni catají de uū tēe cuacana de Pedro, te ni cacahān de: Ma cucuéé ní na quíhín yachī yō ñuu Jope, achí de. ");
INSERT INTO mibNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Yūcuán na te ni quihin Pedro ichi cuahān de jíín tée ún. Te nuū ni jínū de, te ni cacoo tēe un jíín de nde xinī véhe nuū catú ndɨ́yɨ ún. Te tācá ñahan viuda ni candicó ndúū ña de cándahyū ña, te cástéén ña tācá sahma jíín tɨ́cāchi jéē ni sáha Dorcas te ni saja ña nde na técu ña. ");
INSERT INTO mibNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Yūcuán na te ni ndacu Pedro jniñu jeē na quéndacoo ndɨhɨ ñayuu ún quingoo i nde yatā véhe. Te ni jecuɨñɨ̄ yɨtɨ́ de ni jicān tahú de, te ni nandió cóto de nuū catú ndɨ́yɨ ún, te ni cahān de: Tabita, ndocuɨñɨ̄ ní, áchí de. Te máá ña ni ndacoto‑ni ña te ni jito ña nuū Pedro, te ni nucōo‑ni ña. ");
INSERT INTO mibNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Te ni jnɨɨ de ndaha ña, te ni ndonehen de ña. Yūcuán na te ni nacana de xinī ñáyuu cácandíje nde jiín ñahan viuda ni ndɨ̄vɨcoo i, te ni steén de ña nuū i jeē ní natecu ña. ");
INSERT INTO mibNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Te ni jitē jnūhun jniñu yáha nɨ́ɨ́ ñuu Jope cuahān, te cuehē ñayuu ni cacandíje i jnūhun máá Jítoho yō. ");
INSERT INTO mibNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Te cuehē quɨvɨ̄ ni ndōo Pedro ini ñuu Jope, néne de vehe ɨɨn tēe sáha curtir ñɨɨ, nání de Simón. ");
INSERT INTO mibNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Te ini ñuu Cesarea ni īyo ɨɨn tēe nání Cornelio, ni cuu de capitán grupo soldado jeē naní Italiano. ");
INSERT INTO mibNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Te cúu de tēe ndíso īyo nuū Yaā Dios nde jiín ndɨhɨ ñayuu vehe de, te yōhyo caridad ni tēe cúu de, chi jéhe de xūhun núū ñáyuu hebreo cándoho ndáhú, vēsú nasūu tée hebreo cúu de. Te níní jícán tahú de nuū Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Te ɨɨn quɨvɨ̄ ni steén ndijin yā nuū tēe yáha nájnūhun cahunī jehíni, te ni jito de jeē ɨ́ɨn ndajéhé maá Yáā Dios ni quɨ̄vɨ ya nuū néne de. Te ni cahān yā jiín de: Cornelio, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Te máá de ni ndacoto vāha de nuū yā, te ni yūhú de. Te ni cahān de: ¿Na vé cuní ni, Tátā? achí de. Te ni cahān yā jiín de: Je chíhi Yaā Dios cuenta jeē jicán tahú rō jiín jéē sáha ró caridad. ");
INSERT INTO mibNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Vijna te tají ró jecu tēe na quíngoo de nde ñuu Jope, quicana de Simón jeē suni nání de Pedro, na quíji de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Chi néne núu de vehe tocayo de Simón, tēe sáha curtir ñɨɨ, te ndéé vehe ún yajni yumar. Te máá de castūhun núū rō na vé cúu ɨnga jeē cánuú sáhá ró, áchí ndajéhé yā. ");
INSERT INTO mibNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Te ndajéhé yā jeē ni cáhān jiín Cornelio, cuahān‑ni ya. Te ni cana de uū mozo de jíín ɨɨn soldado jeē yɨñúhún núū Yaā Dios, chi cúcáhnu ni de jeē squícu vāha tēe ún. ");
INSERT INTO mibNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Te ni nacani ndɨhɨ de jnūhun nuū tāca tée ún, te ni tají de cuangoo nde ñuu Jope. ");
INSERT INTO mibNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Te ɨnga quɨvɨ̄ un cájica de ichi cuangoo de, te cuacuyajni de ñuu Jope. Te je yajni cahuxī uū cúu, te suu hora un ní caa Pedro sɨquɨ̄ véhe chi cándaā, te yūcuan cácān tahú de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Te ni quee sōco chīji de, te ni cuni de caji de staā. Te sáá cásáha ña ndeyu te ni steén ndijin yā nuū de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Te ni jito de jeē núne andɨvɨ́. Te ni jito de nájnūhun ɨɨn sahma manta jité cáhnu te núhní jnáhan ndɨcúún punta, te ni cuun vēji nuū de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Te chīji un cáñūhun ndɨnuū quɨtɨ, tācá quɨtɨ cúún ndaha jíín táca cóō jiín táca quɨtɨ cándava. ");
INSERT INTO mibNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Te ni jini sōho de ɨɨn jnūhun ni cahān: Pedro, ndocuɨñɨ̄ te cahni rō tācá quɨtɨ jiñā, te caji rō tɨ̄, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Te ni cahān Pedro: Ma cáji na, Tátā, chi tu yéji cuɨtɨ na táca quɨtɨ jeē cahán ley ni jéē tú vāha caji na tɨ́, chi nájnūhun jeē tu cáhīyo ndoo tɨ nuū ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Te ni cahān tucu jnūhun un jíín de: Achí rí jeē iyó váha caji rō tācá quɨtɨ jiñā, chi ni sándoo ri, te ma cahán maá ró jeē tu cáhīyo ndoo tɨ, áchí. Te súcuan ni steén cají yá nuū de jeē cúu quihīn de nuū ñáyuu vēsú násūu jnáhan ñuu de hebreo cúu. ");
INSERT INTO mibNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Te unī jínu ni cahān súcuan jíín de. Te sahma un ní ndaa cuanuhun andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Te níní nácani ndasɨ́ ni Pedro na vé cuní cahān jeē ní jito ndijin de ún, te ni jinūcoo‑ni tēe ni tají Cornelio, cácajnūhún de vehe Simón nde ni jinūcoo de yéhyɨ́ tée ún. ");
INSERT INTO mibNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Te cácahān jee de cácajnūhún de núu yūcuan ndéé Simón jeē suni nání de Pedro. ");
INSERT INTO mibNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Te níní nácani ga ni Pedro sɨquɨ̄ jeē ní jito ndijin de ún, te Espíritu Santo ni cahān yā jiín de: Ni quecoo unī tēe cánanducú róhó. ");
INSERT INTO mibNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ndocuɨñɨ̄ te nanuu ró, te ma cáni ni rō jeē tú vāha quihīn rō jiín de, vēsú nasūu jnáhan ñuu rō hebreo cácuu de, chi máá rí ni tají rí de vējicoo de, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Yūcuán na te ni nanuu Pedro nuū tée ni tají Cornelio, te ni cahān de: Máá ná cúu tēe cánanducú ní. ¿Te na sɨquɨ̄ vējicoo ní núū na núu súcuan? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Te ni cacahān mozo un: Cornelio, tēe cúu capitán, ni tají de sāñá. Te tēe ndaā, tēe ndíso īyo nuū Yaā Dios cúu de, te tāca ñáyuu hebreo suni cácahān i jeē tée vāha cúu de. Te ni cahān ɨɨn ndajéhé yā jiín de jeē na cána de níhín jéē ní vehe de te chusóhó de jnūhun cahān ni jíín de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Yūcuán na te ni cahān Pedro jiín mozo un jéē na cúcōo de ini vehe ún, te ni candōo de yūcuán. Te nuū ní cundijin, te ni quihin Pedro ichi cuahān de jíín mozo un. Te suni cuangoo jecu hermano cácandíje ñuu Jope jiín de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Te nde ɨnga quɨvɨ̄ ni jinūcoo de ñuu Cesarea. Te Cornelio ndétu de jinūcoo Pedro, chi ni nastútú de tāca jnáhan de jíín táca amigo de jeē quijnáhan vāha ga de jíín. ");
INSERT INTO mibNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Te nuū ni jínū Pedro jijnáhan de, te ni quenda Cornelio ni cahān de jíín Pedro, te ni jecuɨñɨ̄ yɨtɨ́ de jeē chiñúhún de Pedro nuú. ");
INSERT INTO mibNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Te Pedro ni ndonehen de Cornelio, te ni cahān de: Ndocuɨñɨ̄ ní, chi sāñá suni ɨɨn tēe‑ni cúu ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Te cándajnūhún de ni quɨ̄vɨcoo de ini vehe. Te ni jito Pedro jeē cáyūcu cuéhē ñayuu ini vehe de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Te ni cahān Pedro jiín ñáyuu ún: Je cájini vāha ni jíjnáhan ní jéē ley jeē cánevāha sāña ñáyuu hebreo, cáhán jeē tú vāha jeē quijnáhan ná jíín ní quɨ̄vɨcoo ná vehe ní sɨ́quɨ̄ jeē cúu ní ñáyuu sɨ́ɨn nación. Te Yaā Dios chi ni steén yā nuū na jéē ma cujéē ni na núū ní ɨɨn ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jeē yúcuan cúu jeē vēji‑ni ná, chi ni cana ní sáña, te tu ní sájéē ni ná. Te na cájnūhun ná nihín, ¿na sɨquɨ̄ ni cana ní sáña? áchí Pedro. ");
INSERT INTO mibNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Yūcuán na te ni cahān Cornelio: Vijna íyó cúūn quɨvɨ̄ nájnūhun máá hora yáha jéē cúu cahunī jehíni, te ndite ni ná chi súcuan chíñúhún ná nuū yā, te jícán tahú na ini vehe ná. Te ni quiji ɨɨn ndajéhé yā nuū ná, te ndíndēé sahma ñúhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Te ni cahān yā jiín ná: Cornelio, je ni jini sōho Yaā Dios jeē jicán tahú rō, te chíhi ya cuenta jeē sáha ró caridad. ");
INSERT INTO mibNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Núu súcuan te tají ró mozo na quíngoo de ñuu Jope quicana de Simón jeē suni nání de Pedro, na quíji de nuū rō. Chi tēe un néne de vehe tocayo de Simón, tēe sáha curtir ñɨɨ, te yajni yumar ndeé vehe de. Te quee tēe ún te castūhún de nuū rō jnūhun cánuú, áchí yá jiín ná. ");
INSERT INTO mibNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Súcuan ni cuu te ni tají‑ni ná mozo na cuajēcoo de cana de níhín, te na cútahū ná, chi vāha ni sáha ní jéē véji ní. Te vijna ni candutútú ná yāha návāha tāca ná cuni sōho ná ndɨhɨ jnūhun Jitoho yō Yaā Dios jeē ni jéhe ya cahān ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Yūcuán na te ni cahān Pedro: Vijna te ni jini vāha ná jéē Yaā Dios ɨnuú‑ni sáha ya jiín táca ñáyuu, cúu ñayuu hebreo jiín ñáyuu tāca gá nación. ");
INSERT INTO mibNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Chi cúsɨɨ̄ ni yā jiín ñáyuu tācá‑ni nación núu cándīso īyo i nuū ya te cásáha i jniñu ndaā. ");
INSERT INTO mibNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Chi ni cahān yā jiín ñáyuu Israel jeē ndɨ́vɨcoo tāca ñáyuu nuū jnúhun manī yā jiín i sáha Jesucristo. Te máá yá cúu Jitoho tāca yóhó. ");
INSERT INTO mibNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Máá ní je cájini ní ndese ni cuu. Chi ná ni jīnu ni nacani Juan jnūhun jíín jéē ni scuándute de ñayuu, te ni quejéé Jesús nácani ya jnūhun nde Galilea, te ni jitē jnūhun un nɨ́ɨ́ cáhnu Judea. ");
INSERT INTO mibNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Te cájini ni jéē Yaā Dios ni jēhe ya Espíritu Santo jiín poder nuū Jesús, Yaā ní jehnu ñuu Nazaret. Te cájini ni jéē ní jica cuu ya ni sáha ya jniñu váha, te ni nasávāha ya tāca ñáyuu jeē cándoho i sáha jexeén, chi Yaā Dios ni chindéé ñáhán yá Jesús. ");
INSERT INTO mibNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Chi máá ná cánacani cájí ná jnūhun tācá jniñu ní cajito ná ní sáha ya nɨɨ́ cáhnu Judea jiín ini ñuu Jerusalén. Yūcuán na te ni cajehni i ya, chi ni cata caa i ya jicā cruz. ");
INSERT INTO mibNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Te Yaā Dios ni nastécu yā maá Jesús nuū uní quɨvɨ̄, te ni ndiji ya nuū na ní cajito ná núū yā ni sáha Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Te tu ní quíji ya nuū tācá ɨnga ñayuu, chi nuū maá‑ni tāca ná jeē jé ni nacāji Yaā Dios sāña jéē nácani ná jnúhun tācá jniñu jeē ní cajito ná. Chi ni cayeji na stáā ni cajihi ná ndute jíín yá ná ni nane ya jeē ní natecu yā. ");
INSERT INTO mibNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Te ni ndacu ya jniñu nuū na jíjnáhan ná jéē na nácani ná jnúhun ya nuū tāca ñáyuu te cahān cají ná jeē maá Yáā Dios ni jeni ya Jesús jeē sándaā yā jniñu ñayuu cátecu jiín ñáyuu ní cajihī. ");
INSERT INTO mibNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Chi jnūhun Jesús cúu jeē ní cacahān tāca tée ni canacani jnūhun Yaā Dios nde jenahán. Chi ni cacahān de jeē tāca ñáyuu jeē candíje i Jesús, cone cáhnu ni yā nuū cuéchi i, áchí Pedro. ");
INSERT INTO mibNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Te níní cáhán gā Pedro tāca jnúhun yáha te ni quɨ̄vɨ‑ni Espíritu Santo ini anuá tāca ñáyuu cájini nahín jnūhun ya jeē cahán de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Te tēe hebreo jeē ni jínūcoo jíín Pedro jeē suni cácandíje de Jesús, nahán ní canaa ni de ni cajito de jeē suni ni quɨ̄vɨ Espíritu Santo ini anuá ñayuu jeē násūú hebreo cácuu. ");
INSERT INTO mibNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Chi ni cajini sōho de cácahān ñayuu un sɨ́ɨn yuhu, te cácahān i jeē yōhyo cújéhnu Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Yūcuán na te ni cahān Pedro: ¿Ndé ɨɨn casɨ jeē ma cuándute ñayuu yáha? Chi ni quɨ̄vɨ Espíritu Santo ini anuá maá i, nájnūhun ni quɨ̄vɨ ya ini anuá maá yó, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Te ni cahān de jíín i jeē na cuándute i sɨquɨ̄ jeē ní cacandíje i Jesucristo. Yūcuán na te ni cacahān ndahú i jíín Pedro jeē na quéndōo de jecu quɨvɨ̄ jiín i. ");
INSERT INTO mibNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Te tēe apóstol jiín táca hermano cáyūcú Judea, ni canihīn de jnūhun jeē súni ñayuu sɨ́ɨn nación ni cacandíje i jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Te cuanuhun Pedro ñuu Jerusalén. Te sava tēe hebreo jeē cácandíje de ya ni cacahān de nuū Pedro: ");
INSERT INTO mibNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","¿Najehē ni condee ní vehe ñayuu jeē násūu ñáyuu nación yō cúu? Te ni yeji ni jíín i, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Yūcuán na te ni nacani cájí Pedro jnūhun nuū tée ún ndɨhɨ ndese ni cuu sɨquɨ̄ tée sɨ́ɨn nación: ");
INSERT INTO mibNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Néne ná ñuu Jope. Te níní jícán tahú na, te ni steén ndijin yā nuū ná, te ni jito ná nájnūhun ɨɨn sahma manta jité cáhnu jeē nuhní jnáhan ndɨcúún punta, te nde ichi ándɨvɨ́ ní cuun ni quiji nuū ná. ");
INSERT INTO mibNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Te ni jito vāha ná, te ni jini na jéē chíji un cáñūhun quɨtɨ cúún ndaha jíín quɨtɨ xéén jíín cóō jiín quɨtɨ cándava. ");
INSERT INTO mibNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Te ni jini sōho ná ɨɨn jnūhun ni cahān jiín ná: Pedro, ndocuɨñɨ̄ te cahni rō tācá quɨtɨ jiñā, te caji rō tɨ̄, áchí jíni ná. ");
INSERT INTO mibNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Te ni cahān ná: Ma cáji na, Tátā, chi tu yéji cuɨtɨ na táca quɨtɨ jeē cahán ley ni jéē tu cáhīyo ndoo tɨ nuū ní, áchí ná. ");
INSERT INTO mibNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Yūcuán na te jnūhun jeē véji nde andɨvɨ́ ní cahān tucu jíín ná: Ni sándoo máá rí tɨ̄, te ma cahán gā rō jeē tu cáhīyo ndoo tɨ, áchí jíni ná. ");
INSERT INTO mibNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Te unī jínu ni cahān súcuan. Yūcuán na te ni ndaa sahma un cuánuhun andɨvɨ́. ");
INSERT INTO mibNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Te hora un ní jinūcoo unī tēe vehe nuū ni cóndee ná un, cánanducú de sāñá, te ɨɨn jnáhan ñuu de Cesarea ni tají de vējicoo de. ");
INSERT INTO mibNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Te máá Espíritu ni cahān yā jiín ná jeē ma cáni ni na jéē tú vāha quihīn na jíín de. Te suni iñū hermano yáha ní jengoo jíín ná, te ni quɨ̄vɨcoo ná ini vehe tēe nání Cornelio. ");
INSERT INTO mibNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Te tēe un ní nacani de jnūhun nuū na jíjnáhan ná jéē ní jito de ɨɨn ndajéhé Yaā Dios, índichi yā ini vehe de, te ni cahān yā jiín de: Tají ró jecu tēe na quíngoo de ñuu Jope, quicana de Simón jeē suni nání de Pedro, na quíji de. ");
INSERT INTO mibNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Te tēe ún cachi de nuū rō ndese jnama Yaā Dios rohó jíín ndɨhɨ ñayuu cáyūcú vehe ró, áchí yá. Achí Cornelio jiín ná. ");
INSERT INTO mibNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Te nuū ní quejéé ná cahán na, te ni quɨ̄vɨ‑ni Espíritu Santo ini anuá i jíjnáhan i, nájnūhun ni quɨ̄vɨ ya ini anuá maá yó xīhna gā. ");
INSERT INTO mibNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Yūcuán na te ni nucūhun ni na jnúhun ni cahān maá Jítoho yō: Jendaá jeē maá ndute‑ni ni scuándute Juan ñayuu. Te róhó jíjnáhan ró chi nájnūhun cuandute ró jíín Espíritu Santo, cúu jeē cóndee yā ini anuá rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Te suni ni jēhe Yaā Dios Espíritu yā nuū maá i nájnūhun ni jēhe ya nuū maá yó jeē cácandíje yó Jítoho yō Jesucristo. Núu súcuan ¿te ndé ɨɨn cúu ná jéē cásɨ ná jniñu jeē sáha Yaā Dios? áchí Pedro. ");
INSERT INTO mibNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Súcuan ni cajini sōho de jnūhun yáha, te tuá ni cácahān de nuū Pedro, chi sa suhva ni cacahān de jeē yóhyo cújéhnu Yaā Dios. Te ni cacahān de: Suni ni jēhe Yaā Dios jnūhun jeē na nácani ni ñayuu tāca gá nación jeē stóo i cuēchi i návāha cotecu i nɨ́ɨ́ cáni núu súcuan, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Te quɨvɨ̄ ní cajehni de Esteban ni quejéé de cájito xeēn de ñayuu cácandíje, te jeē yúcuan ní cajitē núu ñayuu un táca ñuu cuangoo i, te ni jinūcoo i Fenicia jiín Chipre jiín ñuu Antioquía. Te ni canacani i jnūhun vāha ya nuū máni jnáhan hebreo i jeē cáyūcu yúcuan, te tu ní cánacani i jnūhun ya nuū ɨ́nga ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Te jecu tēe cácandíje jeē cáyūcu Chipre jiín ñuu Cirene ni jinūcoo de ñuu Antioquía, te suni nuū ñáyuu tācá nación jeē tu cájini i jnūhun ya ni canacani de jnūhun máá Jítoho yō Jesús jeē jnáma ya i. ");
INSERT INTO mibNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Te máá Jítoho yō ni chindéé ñáhán yá de, te cuehē ñayuu ni castóo i jniñu jeē tu íyó ndáā te ni cacandíje i máá Jítoho yō. ");
INSERT INTO mibNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Te ñayuu cácandíje ini ñuu Jerusalén ni cajini jnūhun i, te ni catají i Bernabé cuahān de nde ñuu Antioquía. ");
INSERT INTO mibNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Te nuū ni jínū Bernabé yūcuán, te ni jini de jeē yóhyo vāha ni sáha Yaā Dios jiín i, te ni cusɨɨ̄ ndasɨ́ ni de. Te ni stɨhvɨ́ ni de tāca ñáyuu un jéē jiín ini jiín ánuá i na cóndɨhvɨ̄ ni i squícu vāha i nuū maá Jítoho yō, te ma náyūhú i. ");
INSERT INTO mibNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Chi tēe vāha cúu Bernabé, te ni cunuú Espíritu Santo jiín de, te cándíje nīhin de. Te ni cacandíje cuehē ñayuu nuū maá Jítoho yō ni sáha de. ");
INSERT INTO mibNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Yūcuán na te cuahān de nde ñuu Tarso cuananducú de Saulo. Te ni nanihīn jnáhan de jíín Saulo, te ndéca de tēe un ní ndee de ñuu Antioquía. ");
INSERT INTO mibNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Te nɨ́ɨ́ ɨɨn cuiyā ni candutútú de jíín ñáyuu cácandíje yūcuán, te ni castéén de jnūhun ya nuū cuehē ñayuu. Te ñuu Antioquía cúu nuū xíhna ñúhún gá ni caconaní ñayuu cristiano sɨquɨ̄ jeē ní cacandíje i Cristo. ");
INSERT INTO mibNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Te suni tiempo un ní quendacoo tēe cánacani jnūhun Yaā Dios ñuu Jerusalén cuangoo de nde ñuu Antioquía. ");
INSERT INTO mibNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Te ɨɨn jnáhan de jeē naní Agabo ni ndocuɨñɨ̄ nuū hermano cácandíje. Te ni steén Espíritu Santo nuū de, te ni castūhún de jeē cóo ɨɨn jnamā xeēn nɨɨ́ cáhnu. Te ni cuu jnamā ún ɨɨn parte tiempo jeē ní ndacu Claudio jniñu jeē ní cuu de rey. ");
INSERT INTO mibNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Yūcuán na te ni candajnūhun tée cácandíje ñuu Antioquía jeē cuáha ɨɨn ɨɨn de nasaa canda de cuāha de te tají de quihīn cotecu hermano cáyūcú Judea. ");
INSERT INTO mibNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Te súcuan ni casáha de. Te ni catají de Bernabé jiín Saulo ni cajendēca de nuū tée jéhnu cándīso jníñu nuū ñáyuu cácandíje cáyūcú Judea. ");
INSERT INTO mibNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Te suu tiempo un ní quejéé rey Herodes jíto xeēn de sava ñayuu cácandíje. ");
INSERT INTO mibNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Te ni ndacu de jniñu jeē jiín espada na cáhni i Jacobo ñani Juan. ");
INSERT INTO mibNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Te ni jini de jeē ní cacusɨɨ̄ ni tēe hebreo jeē ni sáha de súcuan, te jeē yúcuan suni ni jnɨɨ de Pedro. Te máá quɨ́vɨ̄ un ní cuu vico jeē yéji ñayuu pan jeē tu yɨ́hɨ levadura. ");
INSERT INTO mibNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Te nuū ní jnɨɨ de Pedro, te ni chune de vecāa, te ni jeni de cuūn grupo soldado jeē cóndito Pedro, cuūn cuūn soldado cúu jeē ɨ́ɨn ɨɨn grupo. Chi cúní Herodes jeē na yáha vico un jéē cúu vico pascua te quenehen de Pedro vecāa un stéén de nuū ñáyuu cuehē. ");
INSERT INTO mibNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Te súcuan íne Pedro vecāa, te cándīto soldado un de. Te ñayuu cácandíje chi nīhin ni cajicān tahú i jehē Pedro nuū Yaā Dios jeē na cácu de. ");
INSERT INTO mibNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Te jéni ni Herodes jeē na cúndijin ɨnga quɨvɨ̄ te quenehen de Pedro vecāa, te stéén de nuū ñáyuu un núú. Te núhní Pedro jiín úū cadena, cátú de quíxí de mēhñu úū soldado jecuáā ún, te suni cáhīin ga soldado cándīto yéhyɨ́ vécāa ún. ");
INSERT INTO mibNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Te suu jecuáā ún te sanaa‑ni te ni jinū ɨɨn ndajéhé maá Jítoho yō, te ni ndindēé ini vecāa. Te ni squɨ́hɨ ya Pedro, te ni natahū ni de. Te ni cahān yā: Yachī ndocuɨñɨ̄ rō, achí yá. Te cadena nuhní ndaha de un ní canandajī‑ni. ");
INSERT INTO mibNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Te ni cahān ndajéhé yā jiín de: Nacuhni nīhin chīji ró, te nuquɨ̄hɨ ró ndíjēn rō, achí yá. Te súcuan ni sáha de. Te ni cahān tucu ndajéhé yā jiín de: Condii tɨcāchi ró, te condiquīn rō ruhū na quíhín yō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Te ni quenda de ndíquín de ya cuahān de jíín yá, te jéni ni de jeē násūu jéndaá cúu jeē sáha ndajéhé yā jiín de, chi jéni ni de jeē ɨɨn jeē ni stéén yā jíto ndijin de cúu. ");
INSERT INTO mibNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Te ni yāha ya jiín de uū nuū cándīto soldado. Te ni jinū yā jiín de yéhyɨ́ cáa nuū quénda de caca de calle, te yéhyɨ́ un ní nune iī‑ni máá. Te ni quenda ya jiín de, te ni yāha de ɨɨn calle cuahān de. Yūcuán na te ni cujiyo‑ni ndajéhé yā nuū de cuahān yā. ");
INSERT INTO mibNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Te ni nducájí ni Pedro te ni cahān maá ní cahān ɨɨn de: Vijna te ni jini ndaā rī jeē ní tají máá Jítoho rī ndajéhé yā ni quiji, te ni jnama ya ruhū nuū Herodes jiín núū tāca ñáyuu hebreo jeē cácuni i sáha xeēn i jíín rí nuú, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Te nuū ní jini de jeē ni cácu ndije de, te ni quihin de ichi cuahān de vehe María naná Juan jeē suni nání de Marcos. Te yūcuan cáhīin tútú cuéhē ñayuu cájicān tahú i jehē Pedro. ");
INSERT INTO mibNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Te cáhán Pedro ni jinū de yéhyɨ́ fuera, te ɨɨn sūchi sɨ́hɨ́ nání Rode cuahān i jeē cúni i núu ndé ɨɨn cúu jeē cahán. ");
INSERT INTO mibNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Te ni nacuni i tachī Pedro, te jeē ní cusɨɨ̄ ni i te tu ní núne i yéhyɨ́ un, chi ni nandió cóo i te jínu i ni ndɨ̄vɨ i ini cuarto. Te ni castūhún i jeē ní quee Pedro índichi de yéhyɨ́ fuera. ");
INSERT INTO mibNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Te ni cacahān jiín i: Jeē cahán neé ró, achí. Te máá i nīhin cáhán i jeē maá de cúu. Yūcuán na te ni cacahān: Ndajéhé yā jeē ndíto Pedro cúu núu súcuan, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Te víhyá gā cahán Pedro. Yūcuán na te ni canune i yéhyɨ́, te ni canacuni i nuū de, te nahán ní canaa ni i cájito i. ");
INSERT INTO mibNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Te máá de ni sáha de ndaha de jeē ma cúvaā gā i, te ni castūhún de ndese ni quenehen máá Jítoho yō de vecāa. Te ni cahān de: Castūhun núū Jacobo jiín núū tāca gá hermano jeē ní quenehen ya ruhū vecāa, áchí de. Te ni quenda de cuahān de ɨnga lugar. ");
INSERT INTO mibNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Te nuū ní cundijin, te ni cacuvaā teyɨ́ soldado jeē tuá Pedro. ");
INSERT INTO mibNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Te ni ndacu Herodes jniñu jeē na nánducú váha i Pedro. Te tu ní cánanihīn i de, te nuū ní cuu ni stichí de soldado jijnáhan, te ni ndacu de jniñu jeē na cúū. Yūcuán na te ni quenda Herodes Judea cuahān de ñuu Cesarea, te ni condee de yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Te yōhyo ni quɨtɨ̄ ni rey Herodes nuū ñáyuu ñuu Tiro jiín ñuu Sidón. Te ñayuu un ní candajnūhún i jeē ɨnuú‑ni quɨ̄vɨcoo ndɨhɨ i nuū rey un. Te ni casáha i amigo i jíín Blasto, tēe cújéhnu jéjníñu nuū rey un. Te ni cacahān ndahú i jíín de jeē na cáhán ndahú de jíín rey un jéē na ndéē ni de jíín i. Chi nde ñuu maá rey un cájeen i jeē cáyeji i. ");
INSERT INTO mibNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Te ni jeni Herodes ɨɨn quɨvɨ̄. Te ni nucūhun de sahma yɨ́ñúhún de, te ni cucōo de mesa nuū ndácu de jniñu, te ni cahān de ɨɨn jnūhun jehū ni cajini sōho i. ");
INSERT INTO mibNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Te ñayuu un ní caquejéé i cácahān jee i jnūhun yɨ́ñúhún jíín de: Nasūu tée‑ni cúu ní, chi ɨɨn yaā cúu ní, áchí i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Te máá hora un ní sáha‑ni ɨɨn ndajéhé maá Jítoho yō jeē ní jnɨɨ ɨɨn cuehyɨ̄ xeēn rey Herodes, te ni cayeji tɨndācú de, te ni jihī de, chi ni sandúxí‑ni de máá de te tu ní cáhán de jeē Yaā Dios cúu jeē cujéhnu. ");
INSERT INTO mibNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Te ni jitē gā jnūhun máá Jítoho yō, te cuehē ndasɨ́ ñáyuu ni cacandíje i tācá‑ni lugar. ");
INSERT INTO mibNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Te ni jīnu jniñu jeē ní quindeca Bernabé jiín Saulo jeē cótecu ñayuu Judea. Te ni quendacoo de Jerusalén cuanungoo de Antioquía, te cándēca de Juan jeē suni nání de Marcos cuahān jiín de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Te mēhñu grupo ñayuu cácandíje ini ñuu Antioquía ni cahīyo tēe cástéén jiín tée cánacani jnūhun Yaā Dios, te cánaní de Bernabé, Simón jeē suni nání de Negro, Lucio ñuu Cirene, Saulo, jiín Manaén tēe ni jehnu jíín ɨnga Herodes jeē ní cuu gobernador Galilea. ");
INSERT INTO mibNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Te ɨɨn quɨvɨ̄ jeē cáhīyo ndite ni tēe yáha cáchiñúhún de nuū maá Jítoho yō, te ni cahān maá Espíritu Santo jiín de: Cúní rī jeē sasɨ́ɨn ró Bernabé jiín Saulo na quíngoo de jniñu jeē ní jeni ri de, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yūcuán na te ni cajicān tahú ndite ni de, te ni casoó de ndaha de xinī Bernabé jiín Saulo, te súcuan ni catají de ndɨndúú tée ún cuanacani de jnūhun nuū tāca ñáyuu. ");
INSERT INTO mibNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Te ni sáha Espíritu Santo jeē íchi ñúū Seleucia cuangoo de. Te yūcuan ní quɨ̄vɨcoo de ɨɨn barco cuangoo de nde Chipre, ñuhun jeē íne sɨ́ɨn nuū ndúte. ");
INSERT INTO mibNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Te ni jinūcoo de ñuu Salamina nuū cájecuɨñɨ̄ barco, te ni canacani de jnūhun Yaā Dios ini tācá vehe iī sinagoga jnáhan hebreo de. Te suni cuahān Juan chindéé ñáhán jíín de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Te ni cajica nuu de nɨ́ɨ́‑ni Chipre nde ni jinūcoo de ñuu Pafos jeē suni íne nuū Chipre. Te yūcuan ní cajini de nuū ɨ́ɨn tēe hebreo nání Barjesús. Te tēe tásɨ́ cúu de, te cáhán stahú de jeē ɨ́ɨn tēe nácani jnūhun Yaā Dios cúu de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Te tēe tásɨ́ un jéjníñu de nuū gobernador Sergio Paulo, te tēe ndíchí cúu gobernador ún. Te ni cana de Bernabé jiín Saulo jeē cúni nahín de jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Te tēe tásɨ́ un suni nání de Elimas. Te ndúcú ndéyɨ́ de casɨ de jeē ma cándíje gobernador ún. ");
INSERT INTO mibNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Te Saulo jeē suni nání de Pablo, ni cunuú Espíritu Santo jiín de, te ni ndacoto vāha de nuū tée tásɨ́ un. ");
INSERT INTO mibNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Te ni cahān de: Tēe sáha jniñu néé stáhú ñáhán cúu ró, chi sēhe jexeén cúu ró te jésɨ rō nuū tācá jniñu ndaā. Te tu jécuɨñɨ̄ rō jeē sáca núu ró sɨ́quɨ̄ jnúhun ndaā maá Jítoho yō návāha ma candíje ñayuu nuū yā. ");
INSERT INTO mibNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Te máá Jítoho yō stóho ya rohó vijna, te cucuáá ró jeē ma cóto ga rō niāndii jecu quɨvɨ̄, achí Pablo. Te ni cunee‑ni nuū tée tásɨ́ un, te quéndāha quéhiyú de cuahān de ndúcú de ndé vé jnɨ́ɨ ndaha de stéén ichi nuū de quinuhun de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Yūcuán na te ni jini gobernador jeē súcuan ni cuu, te ni candíje de jnūhun máá Jítoho yō, te náā ni de jíni sōho de jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Yūcuán na te ni quendacoo Pablo jiín Bernabé jiín Juan ñuu Pafos, te ni quɨ̄vɨcoo de barco te cuangoo de ñuu Perge ndañúū Panfilia. Te yūcuan ní cusɨ́ɨn Juan, te cuanuhun de ñuu Jerusalén. ");
INSERT INTO mibNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Te ni quendacoo Pablo jiín Bernabé ñuu Perge cuangoo de, te ni jinūcoo de ñuu Antioquía ndañúū Pisidia. Te quɨvɨ̄ ndétātu ní quɨ̄vɨcoo de ini vehe iī sinagoga, te ni cacucōo de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Te ni cahu tutu ley yā jiín tutu ní catee tēe ni canacani jnūhun ya nde jenahán. Yūcuán na te tēe cácujéhnu ini vehe iī sinagoga, vii‑ni ni catají de tēe cahān jiín Pablo jiín Bernabé: Amigo, núu íyó jnúhun cahān ni jéē stɨhvɨ́ ni ni ñáyuu yáha, te cahān ní na cúni nahín i núu súcuan, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Yūcuán na te ni ndocuɨñɨ̄ Pablo te ni sáha de seña jiín ndaha de jeē nahín‑ni coo ñayuu ún, te ni cahān de: Níhín jnáhan ñuu yō Israel jiín níhín tée jeē suni cáchiñúhún ní Yaā Dios, cuni nahín ní jijnáhan ní. ");
INSERT INTO mibNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Máá Yáā Dios yohó ñáyuu Israel, ni nacāji ya jií yō jijnáhan de. Te níní jéē cáyūcu tátú de ñuu Egipto, te ni sáha ya jeē ní nducuehē de. Yūcuán na te jíín poder maá yá ni quenehen ya de nación Egipto. ");
INSERT INTO mibNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Te uū xico cuiyā ni cajica de nuū ñúhun téhé, te ni jendeyɨ́ ni yā jiín de jeē ní castɨ́vɨ de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Te ni snáā yā uxā nación Canaán, te ni jēhe ya ñuhun un núū tāca jíí yō cúu tahū de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yūcuán na te ni jeni ya tāca tée ni candacu jniñu nuū de nájnūhun cuūn ciento uū xico uxī cuiyā, nde quɨvɨ̄ ní cotecu Samuel, tēe ni nacani jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Yūcuán na te máá ñáyuu un ní cajicān i ɨɨn rey, te ni jeni Yaā Dios Saúl ni ndacu de jniñu nuū i uū xico cuiyā. Te yucūn Benjamín sēhe Cis ni cuu Saúl. ");
INSERT INTO mibNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Te ni quenehen ya jniñu Saúl, te ni jeni ya David ni cuu de rey nuū i. Te ni cahān cají yá jnūhun de: Cúsɨɨ̄ ni rī jiín David sēhe Isaí, chi sáha de tāca jéē cuní rī, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Te cáhán gā Pablo: Te sēhe yucūn David ni cacu Jesús, Yaā ní jeni Yaā Dios jeē jnáma ya yohó ñáyuu Israel, chi súcuan ni jejnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Te nde ná tu quejéé Jesús nacani ya jnūhun nuū ñáyuu, te ni nacani Juan jnūhun nuū tāca jnáhan ñuu yō Israel jeē na nácani ni i jeē stóo i cuēchi i, te cuandute i. ");
INSERT INTO mibNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Te nuū cuácuyajni jeē cúū Juan, te ni cahān de: Cándētu ró jéē quíji Cristo, te jéni ni rō jeē ruhū cúu, te nasūu rí cúu. Chi quiji ya, te cújéhnu ndasɨ́ yá jeē ni ndijēn yā tu cújéhnu ri tava rī, achí de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Amigo jijnáhan ní, tāca níhín jéē cácuu yó séhe yucūn Abraham jiín táca níhín jéē suni cándiso īyo ní núū Yaā Dios, chi cúní Yaā Dios jeē na cúni yō jnūhun yáha jeē cáhán ndese jnáma ya yohó. ");
INSERT INTO mibNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Chi tāca ñáyuu ñuu Jerusalén jiín táca tée cácujéhnu nuū i, tu ní cájecūhun ni i jeē Jesús cúu Cristo, Yaā ní jeni Yaā Dios jeē jnáma ya yohó. Te ndɨjnahan quɨvɨ̄ ndétātu ní cajini sōho i jnūhun ni cacahu jeē ní catee tēe ni canacani jnūhun Yaā Dios nde jenahán. Te vēsú súcuan te tu ní cájecūhun ni i, te ni candonda i ni cacahān i jeē na cúū yā. Te súcuan ni casquícu i sɨquɨ̄ tāca jnúhun jeē ní cacahān tēe ni canacani jnūhun ya nde jenahán. ");
INSERT INTO mibNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Vēsú tu ní cánihīn i ni ɨɨn cuēchi sɨquɨ̄ yā jeē cúū yā, te ni cacahān nīhin i jíín Pilato jeē na cúū yā. ");
INSERT INTO mibNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Te ná ni jīnu ni squícu sɨquɨ̄ yā tāca jnúhun cáhán nuū tútu iī, te ni casnúu de ya jicā cruz, te ni cachindūji de ya ɨɨn yaū ní jete jicā cáva. ");
INSERT INTO mibNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Te ni sáha Yaā Dios jeē ní natecu yā. ");
INSERT INTO mibNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Te ñayuu Galilea jeē ni jéngoo jíín yá nde Jerusalén nde na técu yā, nuū maá i ni steén ndijin yā maá yá cuehē quɨvɨ̄ ná ni natecu yā, te ñayuu un cácuu jeē cánacani cájí jnúhun ya nuū táca gá jnáhan yó hebreo vijna. ");
INSERT INTO mibNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Te máá ná jijnáhan ná cánacani ná jnúhun vāha yáha núū ni jíjnáhan ní jéē súcuan ni jejnūhun ya nuū tāca jíí yō. ");
INSERT INTO mibNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Te jnūhun yáha ní squícu Yaā Dios nuū maá yó jeē cácuu yó séhe yucūn de, chi ni nastécu yā Jesús. Chi suhva cáhán salmo uū jeē cahán yā jiín Séhe ya Jesús: Máá ró cúu Sēhe ri, te vijna ni sajéhnu ri rohó jéē cúu ri Tatá rō, achí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Te ni nastécu yā Sēhe ya Jesús návāha ma tehyú cuɨtɨ yā, chi suhva cáhán tutu iī jeē ni cáhān Yaā Dios nde jenahán: Te nihīn maá ró tāca jéē váha ni jejnūhun ri nuū David, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Te suni súcuan cáhán ɨnga salmo jeē ní tee David jnūhun jeē cahán Jesús jiín Yáā Dios: Ma cuáha ni jnúhun tehyū ná, chi jéjníñu ná núū ní te manī ni jíín ná, achí. ");
INSERT INTO mibNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Te David chi jíní yō jeē ní jejníñu de nuū ñáyuu ní cotecu de jíín, nájnūhun ni cuni Yaā Dios. Te ni jihī de, te ni quindūji de nájnūhun ni quindūji tāca jíí yō, te ni tehyū de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Te Jesús, Yaā ní nastécu Yaā Dios, chi tu ní téhyú cuɨtɨ yā. ");
INSERT INTO mibNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Jeē yúcuan jíni ñúhún jecūhun ni ní, amigo, jeē Jesús cúu Yaā cóne cáhnu ni nuū tāca cuéchi yó. ");
INSERT INTO mibNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Chi ni canducú ní ndahva ni cuéchi ní jéē squícu ní ley jeē ni jéhe ya nuū Moisés, te tu ní cúu ndahvā cuēchi ní súcuan. Te Jesús cúu Yaā ndáhva ndɨhɨ cuēchi ñayuu jeē cácandíje i tāca jéē ni sáha ya jehē i. ");
INSERT INTO mibNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Núu súcuan te coto ní jíjnáhan ní jéē ma ndóho ní táca castigo jeē ní cacahān tēe ni canacani jnūhun Yaā Dios nde jenahán, chi suhva ni cahān Yaā Dios: ");
INSERT INTO mibNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Tāca róhó ñáyuu jeē casácatā, na cóto ró na castigo xeēn quiji sɨquɨ̄ rō, te naa ni rō coto ró, te cuu rō. Chi tiempo maá ró te sáha ri jniñu xeēn jeē ma cándíje cuɨtɨ rō jeē súcuan sáha ri vēsú nacani ñayuu jnūhun un núū rō, achí yá. Achí Pablo. ");
INSERT INTO mibNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Te ni quendacoo Pablo jiín táca jnáhan de vehe iī sinagoga jnáhan hebreo de. Te ñayuu sɨ́ɨn nación ni cacahān ndahú i jíín de jeē ɨnga quɨvɨ̄ ndétātú nacani tucu de jnūhun yáha núū i. ");
INSERT INTO mibNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Te ni jitē ñayuu un cuángoo i. Te cuehē ñayuu hebreo jiín ñáyuu sɨ́ɨn nación jeē ní cacandíje sahān hebreo te cáchiñúhún i nuū Yaā Dios, cuangoo i jíín Pablo jiín Bernabé. Te ni cacahān nīhin de jíín i jeē na cuɨ́ñɨ nīhin i jíín jnúhun jeē maní Yaā Dios jiín i. ");
INSERT INTO mibNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Te quɨvɨ̄ ndétātú ɨnga semana te je yajni ndɨhɨ ñayuu ñuu un ní candutútú i jeē cúni nahín i jnūhun Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Te nuū ní cajini tēe hebreo jeē ní candutútú cuéhē ñayuu, te ni cacucuésún ni de, te ni cacahān de jeē násūu jnúhun vāha cúu jeē steén Pablo, te ni cacahān neé de nuū Pablo. ");
INSERT INTO mibNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Yūcuán na te jéhnu-ni ni cacahān Pablo jiín Bernabé, áchí de: Cánuú jéē xíhna gā nuū maá ní jeē cácuu ní jnáhan ñuu yō hebreo nacani ná jnúhun Yaā Dios, te tu ní cájetáhú ní. Núu súcuan te cuēchi máá ní cúu jeē ma nihín tahú ni cotecu ni nɨ́ɨ́ cáni. Te vijna te quinacani ná jnúhun ya nuū ñáyuu tācá nación jeē tu cájini i jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Chi suhva ni ndacu máá Jítoho yō jniñu nuū na jíjnáhan ná: Ni jeni ri rohó jéē cúu ró nájnūhun luz jeē steén ini anuá ñayuu tācá nación, chi nɨ́ɨ́ ñayɨ̄vɨ stéén rō jnūhun ri nuū ñáyuu jeē jnáma ri i, áchí yá. Achí de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Te ñayuu sɨ́ɨn nación, nuū ní cajini sōho i jnūhun yáha te ni cacusɨɨ̄ teyɨ́ ni i. Te ni cacahān i jeē yōhyo vāha jnūhun cúu jnūhun máá Jítoho yō, te tāca ñáyuu jeē ní nacāji Yaā Dios i jeē cótecu i nɨ́ɨ́ cáni, ni cacandíje i. ");
INSERT INTO mibNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Te ni jitē jnūhun máá Jítoho yō cuahān nɨɨ́ región yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Te ñuu Antioquía cáyūcú ñahan cácuu nuū te cáchiñúhún ña Yaā Dios. Te tēe hebreo ni cascáhán de ña, te suni ni cascáhán de tēe cácujéhnu ñuu ún, te ni cajito xeēn i Pablo jiín Bernabé te nde ni cascúnu i de cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Te ni cascóyo de tɨcachā jehē de jeē steén de jeē iyó cuéchi i. Te ni jinūcoo de ñuu Iconio. ");
INSERT INTO mibNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Te vēsú súcuan te ñayuu cácandíje un ní cunuú Espíritu Santo jiín i, te cácusɨɨ̄ teyɨ́ ni i. ");
INSERT INTO mibNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Te ñuu Iconio ni quɨ̄vɨcoo Pablo jiín Bernabé ini vehe iī sinagoga jnáhan de hebreo. Te jíín jnúhun jeē ní canacani de te ni cacandíje cuehē jnáhan de hebreo, te suni súcuan cuehē ñayuu sɨ́ɨn nación ni cacandíje i. ");
INSERT INTO mibNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Te jnáhan de hebreo jeē tu ní cácandíje, ni cascáhán de ñayuu sɨ́ɨn nación, te ni cajeni ni i jeē násūu ñáyuu váha cácuu ñayuu cácandíje. ");
INSERT INTO mibNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Te ni caquendōo Pablo jiín Bernabé yūcuan cuéhē gā quɨvɨ̄. Te jéhnu-ni ni canacani de jnūhun Jitoho yō, chi cácucáhnu ni de ya jeē váha quihīn jniñu un sáha ya. Te máá yá chi ni steén yā jeē iyó ndáā jnūhun jeē yóhyo vāha ni yā jiín i jeē cánacani de, chi ni jēhe ya jeē sáha de jniñu jéhnu jeē steén jeē cujéhnu ya. ");
INSERT INTO mibNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Te ñayuu ñuu un ní cacusɨ́ɨn ni i jíjnáhan i, sava i jíín tée hebreo jeē tu cácandíje de Jesús, te sava ga i jíín tée apóstol. ");
INSERT INTO mibNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Te ñayuu hebreo jiín ñáyuu sɨ́ɨn nación jiín tée cácuu tohō ni casquíjnáhan jnūhun jeē sáha xeēn jiín Pablo jiín Bernabé, jiín jéē cuáha yuū xinī de núú. ");
INSERT INTO mibNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Te ni cajini de jeē súcuan cácuni sáha, te ni cajinu de cuangoo de nde ñuu Listra jiín ñuu Derbe ndañúū Licaonia jiín táca ñuu yajni yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Te yūcuan ní canacani de jnūhun jeē jnáma ya yohó. ");
INSERT INTO mibNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Te ñuu Listra néne ɨɨn tēe jeē tu cúu caca, te tu jíca cuɨtɨ de chi nde quɨvɨ̄ ní cacu de cácójó de. ");
INSERT INTO mibNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tēe un ní jini sōho de jnūhun jeē cahán Pablo, te ni jito vāha Pablo nuū de, te ni jini de jeē candíje vāha tēe un jéē ndúvāha de. ");
INSERT INTO mibNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Te ni cahān jee Pablo jiín de: Ndocuɨñɨ̄, condichi rō, achí de. Te ni scánda tēe un máá de ni nucōndichi‑ni de, te ni quejéé de caca de. ");
INSERT INTO mibNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Te ni cajini ñayuu ún jniñu jéhnu jeē ni sáha Pablo, te ni cacahān jee i jíín yuhu máá i jeē cúu yuhu Licaonia: Ni cuun yaā ni quecoo nuū yō, te cájica nájnūhun cájica tēe, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Te ni cacahān i jeē Bernabé cúu yaā Júpiter, te Pablo cúu yaā Mercurio chi Pablo cúu tēe nácani jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Te yajni yuñúū un néne veñūhun yaā Júpiter. Te máá sútū jejníñu ini veñūhun un ní quihin de stɨquɨ̄ jijnáhan tɨ te ni scutú de tɨ ita te vēji de nde nuū quɨ́vɨ i yuñúū, te máá de jíín ñáyuu ñuu un cácuni de cahni de stɨquɨ̄ un sócō de nuū Bernabé jiín Pablo nuú. ");
INSERT INTO mibNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Te Bernabé jiín Pablo, tēe cácuu apóstol, ni cajito de jeē súcuan cácuni ñayuu un sáha i, te ni candatá de sahma de jeē steén de jeē castɨ́vɨ ndasɨ́ i jeē casáha i súcuan. Te ni quenendava de ni quɨ̄vɨcoo de mēhñu ñáyuu cuehē ún, te ni cacana jee de: ");
INSERT INTO mibNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Tátā jijnáhan ní, ma sáha cuɨtɨ ni súcuan, chi sāñá suni tēe‑ni cácuu ná nájnūhun máá ní jíjnáhan ní. Te vējicoo ná nacani ná jnúhun vāha Yaā Dios nuū ní, chi cahān na jíín ní jeē ma sáha ga ni táca jniñu yáha jéē tu ndé jéjníñu cuɨtɨ, chi sa suhva na chíñúhún ní maá Yáā Dios, Yaā técu, Yaā ni sáha andɨvɨ́ jíín ñáyɨ̄vɨ jíín ndute mar jiín táca gá jeē iyó nɨ́ɨ́ cáhnu. ");
INSERT INTO mibNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Te nde jenahán ní jēhe ya jnūhun jeē na sáha tāca ñáyuu modo cácuni maá i. ");
INSERT INTO mibNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Te vēsú súcuan te níní stéén yā ndese Yaā cúu ya, chi máni sáha ya jniñu váha jíín yó, chi scúun ya saū, te sáha ya jeē cúu vāha itu yō, te jéhe ya jeē jíni ñúhún yó návāha caji yō te coo sɨɨ̄ ni yō, achí ndɨndúú de. ");
INSERT INTO mibNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Te vēsú súcuan ni cacahān de, te yōhyo uhū ni cajesɨ de nuū ñáyuu un návāha tú socō i stɨquɨ̄ un núū de jeē chiñúhún i ndɨndúú de. ");
INSERT INTO mibNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Yūcuán na te ni quecoo jecu tēe hebreo ñuu Antioquía jiín ñuu Iconio, te ni cascáhán de ñayuu cuehē ún, te ni cajēhe i yuū xinī Pablo. Te ni caquenehen i de yatā ñúū ún, chi ni cajeni ni i jeē jé ni jihī de. ");
INSERT INTO mibNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Te tēe cácandíje ni cacondúū de Pablo, te ni ndonda Pablo, te ni ndɨ̄vɨ de ini ñuu. Te ɨnga quɨvɨ̄ ni quihin de ichi cuahān de jíín Bernabé nde ñuu Derbe. ");
INSERT INTO mibNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Te ini ñuu un ní canacani de jnūhun jeē jnáma ya ñayuu, te ni cacandíje cuehē ñayuu ni casáha de. Te ni canandicó de cuanuhun de ñuu Listra jiín ñuu Iconio jiín ñuu Antioquía. ");
INSERT INTO mibNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Te ni cahije ga ni ñayuu cácandíje yūcuan ní casáha de. Te ni castɨ́hvɨ́ ni de i jeē na cuɨ́ñɨ nīhin i jíín jnúhun ya, chi ni cacahān de jeē niní quiji cuehē jnūndóho sɨquɨ̄ yō te yūcuán na te jinū yō ñuu nuū ndácu Yaā Dios jniñu. ");
INSERT INTO mibNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Te tācá ñuu ni cajeni de tēe jéhnu cándīso jníñu condito de ñayuu cácandíje. Te ni cahīyo ndite ni Pablo jiín Bernabé nuū yā, te ni cajicān tahú de, te ni cacahān de jíín máá Jítoho yō jeē na cóto ya ñayuu ún chi cácandíje i máá yá. ");
INSERT INTO mibNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Te ni cayāha de cuangoo de región Pisidia, te ni najinūcoo de región Panfilia. ");
INSERT INTO mibNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Te ni canacani de jnūhun ya ini ñuu Perge región Panfilia, te sáá te cuangoo de ñuu Atalia. ");
INSERT INTO mibNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Te yūcuan ní quɨ̄vɨcoo de barco, te ni najinūcoo de ñuu Antioquía. Te ñuu yúcuan cúu nuū ní cajicān tahú ñayuu nuū Yaā Dios jehē de jeē na chíndéé ñáhán yá de jeē quíngoo de nacani de jnūhun. Te ni jīnu jniñu, te ni najinūcoo de ñuu ún. ");
INSERT INTO mibNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Te nuū ní najinūcoo de yūcuán, te ni casáha de junta jiín ñáyuu cácandíje, te ni canacani de jnūhun tācá ndese cuehē jeē váha ni sáha Yaā Dios jiín de, chi ni jēhe ya jnūhun jeē suni candíje ñayuu tācá nación jeē tu ní cájini i jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Te ni caquendōo de yūcuan cuéhē quɨvɨ̄ jiín ñáyuu cácandíje. ");
INSERT INTO mibNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yūcuán na te jecu tēe Judea ni quijicoo de ñuu Antioquía, te ni castéén de nuū tācá hermano jeē núu tu sáha i circuncidar, nájnūhun cáhán ley jeē ni jéhe ya nuū Moisés, te tú na modo cācu i. ");
INSERT INTO mibNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Te Pablo jiín Bernabé ni catejnáhan de jíín tée ún, te tu ní cúndaā. Te jeē yúcuan ní candajnūhún de jeē quíngoo Pablo jiín Bernabé jiín jecu gā tēe cácandíje un ndé ñuu Jerusalén, te yūcuán ndajnūhún de sɨquɨ̄ jnúhun yáha jíín tée cácuu apóstol jiín tée jéhnu cándīso jníñu nuū ñáyuu cácandíje yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Te ñayuu cácandíje un ní canachuhun íchí i de. Te ni cayāha de ichi Fenicia jiín Samaria, te cánacani de jnūhun jeē suni ñayuu tāca gá nación jeē tu ní cájini i jnūhun ya, ni castóo i jniñu jeē tu íyó ndáā te ni cacandíje i Yaā Dios. Te yōhyo ni cacusɨɨ̄ ni tācá hermano jeē ní canihīn de jnūhun jeē súcuan ni cacandíje ñayuu ún. ");
INSERT INTO mibNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Te ni najinūcoo de ñuu Jerusalén, te ñayuu cácandíje yūcuan jíín tée apóstol jiín tée jéhnu cándīso jníñu nuū ñáyuu un, ní cacusɨɨ̄ ni de jeē ní najinūcoo jnáhan de ún. Te Pablo jiín Bernabé ni canacani de tāca jnúhun ndese cuehē jeē váha ni sáha ya sɨquɨ̄ jníñu jeē ní canacani de jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Te sava tēe grupo fariseo jeē cácandíje ni candocuɨñɨ̄ te ni cacahān: Ñayuu sɨ́ɨn nación jeē cácandíje i Jesús, jíni ñúhún jéē sáha i circuncidar nájnūhun cásáha máá yó, te cánuú ndacu yó jniñu nuū i jeē na squícu i ley jeē ni jéhe ya nuū Moisés, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Te tāca tée apóstol jiín táca tée jéhnu cándīso jníñu nuū ñáyuu cácandíje, ni candutútú de junta návāha ndajnūhún de te sándaā de sɨquɨ̄ jnúhun yáha. ");
INSERT INTO mibNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Te tācá de ni cacahān de ndese cájeni ni de. Yūcuán na te ni ndocuɨñɨ̄ Pedro, te ni cahān de: Hermano jijnáhan ní, je cájini vāha ni jéē je íyó tiempo jeē ní nacāji Yaā Dios sāña jéē quihín na núū ñáyuu sɨ́ɨn nación te nacani ná jnúhun nuū i jeē jnáma ya i, návāha candíje i Jesucristo. ");
INSERT INTO mibNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Te Yaā Dios chi jíní yā ndese cáa ánuá ndɨhɨ ñayuu, te ni steén yā jeē jetáhú yá i, chi suni ni jēhe ya Espíritu Santo nuū i jíjnáhan i, nájnūhun ni jēhe ya nuū maá yó. ");
INSERT INTO mibNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Te ɨnuú‑ni sáha ya jiín yó jiín máá i, chi sɨquɨ̄ jeē suni ni cacandíje i jnūhun jeē jnáma ya i, te jeē yúcuan ní sándoo ya anuá i nuū tāca cuéchi i. ");
INSERT INTO mibNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Te vijna ¿naun cácuni ní ndacu ní jniñu jeē na squícu i ley un? Chi tu nújnahan ni Yaā Dios jeē súcuan. Chi cácuni ní tee ní jniñu yɨɨ́ yáha sɨ́quɨ̄ ñáyuu cácandíje ún, te ni tāca jíí yō tu ní cácundeyɨ́ de squícu de, te ni máá yó. ");
INSERT INTO mibNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Chi sa suhva cácandíje yó jéē jnáma ya yohó súcuan‑ni sɨquɨ̄ jeē yóhyo vāha ni maá Jítoho yō Jesús jiín yó, te suni súcuan‑ni jnáma ya maá i, nasūu sɨ́quɨ̄ jeē squícu i ley un, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Yūcuán na te tēe cuehē un ní cacuu nayúú de, te ni cajini nahín de jnūhun cácahān Bernabé jiín Pablo. Chi ni cacastūhún de jeē ni jéhe ya poder jeē ní casáha de tācá jniñu jéhnu jeē steén jeē cujéhnu ya, ni cajito ñayuu tācá nación jeē tu cájini i jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Te nuū ni jínu ni cacahān Pablo jiín Bernabé, te ni cahān Jacobo: Hermano jijnáhan ní, cuni sōho ní na cáhán na. ");
INSERT INTO mibNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ni nacani Simón Pedro jnūhun ndese ni quejéé nuú jniñu jeē jnáma Yaā Dios ñayuu tācá nación jeē tu cájini i jnūhun ya, chi suni mēhñu máá i nácāji ya ñayuu jeē ndúu i ñayuu maá yá. ");
INSERT INTO mibNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Te quíjnáhan jnūhun ni cahān de yāha jíín jnúhun ni catee tēe ni canacani jnūhun Yaā Dios nde jenahán jeē yosó núū tútu iī: ");
INSERT INTO mibNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Achí Yáā Dios: Nájnūhun ni cotúú vehe David cúu jeē tuá ndácu sēhe yucūn de jniñu, nájnūhun ni ndacu máá de jniñu nde jenahán. Te ɨɨn quɨvɨ̄ te ndee rī te jeē nasáha ri vehe de cúu jeē sáha ri jeē nandacu Sēhe yucūn de jniñu. ");
INSERT INTO mibNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Súcuan sáha ri návāha tāca gá ñayuu na nánducú i ruhū nde jiín ñáyuu tācá nación jeē tu cájini jnūhun ri, tācá i jeē cána ri i candíje i ruhū. ");
INSERT INTO mibNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Súcuan cáhán maá Jítoho yō, te nde jenahán ní steén yā jnūhun yáha núū ñáyuu. Achí tutu iī. ");
INSERT INTO mibNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Jeē yúcuan jéni ni na jéē ñáyuu tāca gá nación jeē ní castóo i jniñu jeē tu íyó ndáā te ni cacandíje i máá Yáā Dios, ma stáhān yō i jeē ndácu yó jniñu jeē squícu i ley Moisés. ");
INSERT INTO mibNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Chi sa suhva na tée yó carta quihīn nuū i jeē ma cáji i ndeyu jeē ni sócō nuū ídolo, te ma cáca jnéní i, te ma cáji i cūñu quɨtɨ jeē jihí jeē tu jétɨ nɨñɨ̄ tɨ̄, te ni ma cáji i nɨñɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Jnūhun yáha‑ni tee yó quíhīn nuū i nájnūhun je cástéén nde jenahán. Chi nde jenahán je íyó tée cástéén jnūhun ley jeē ni jéhe ya nuū Moisés, te ndɨjnahan quɨvɨ̄ ndétātu cácahu de ley un ini vehe iī sinagoga tācá ñuu, áchí Jacobo. ");
INSERT INTO mibNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yūcuán na te tēe apóstol, jiín tée jéhnu cándīso jníñu, jíín ndɨvii ñayuu cácandíje, ni cacundaā ni de jeē nácāji de tēe quingoo jíín Pablo jiín Bernabé nde ñuu Antioquía. Te tēe ni canacāji de un cácuu Silas jiín Judas, te ɨnga sɨhvɨ́ de cúu Barsabás. Te cándīso jníñu de nuū tācá hermano cácandíje. ");
INSERT INTO mibNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Te ni cajendēca de carta jeē cahán suhva: Máá ná cácuu tēe apóstol, jiín táca tée jéhnu cándīso jníñu nuū ñáyuu cácandíje, jíín táca gá hermano yō. Te cátee ná carta yáha cuájeē nuū ni jíjnáhan ní, hermano, jeē cácuu ní ñáyuu sɨ́ɨn nación jeē cáyūcu ní ñuu Antioquía jiín Siria jiín Cilicia. Cuandeyɨ́ ni ni jíjnáhan ní. ");
INSERT INTO mibNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ni cajini jnūhun ná jéē ní quendacoo sava jnáhan ná yáha ní jengoo nuū ní, te jíín jnúhun jeē ní cacahān de te ni casáha jeē ní canacani ndasɨ́ ni ní, te ni cacuxií ni ní, chi cándacu de jniñu jeē sáha ní circuncidar jiín jéē squícu ní jniñu cáhán ley jenahán jéē ni jéhe ya nuū Moisés. Te nasūu sáña ní cátají tée un jéē jeé de nuū ní. ");
INSERT INTO mibNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Jeē yúcuan ní cajeni ni ná, te ɨnuú‑ni ni cacundaā ni ná, te ni nacāji ná tée cuajēcoo nuū ni jíín úū hermano yō jeē maní yō jiín, cúu Bernabé jiín Pablo. ");
INSERT INTO mibNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Te ndɨndúú de je ni catana de máá de nuū jnúndóho vēsú na cúū de jeē sɨquɨ́ jnūhun Jitoho yō Jesucristo. ");
INSERT INTO mibNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Núu súcuan te cátají ná Judas jiín Silas jeē nuū ní, te suni nájnūhun cáhán carta yáha suni súcuan castūhún de nuū ni jíjnáhan ní. ");
INSERT INTO mibNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Chi máá Espíritu Santo ni steén yā ɨɨn modo jeē ní cacundaā ni na jéē ma tée ná táca jniñu yɨɨ́ ley Moisés sɨquɨ̄ ní, chi máá‑ni jniñu yáha jéē cánuú gá: ");
INSERT INTO mibNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ma cáji ni táca jéē ní casocō nuū ídolo, ni ma cáji ni nɨ́ñɨ̄ ni quɨtɨ jeē jihí jeē tu jétɨ nɨñɨ̄ tɨ̄, te ma cáca jnéní ní. Te vāha squícu ní núu tuá sáha ní táca jéē yáha. Súcuan na cóo te sándeyɨ́ ni ní, áchí carta. ");
INSERT INTO mibNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Yūcuán na te tēe quingoo un cuángoo de nde ñuu Antioquía. Te ni cacana de xinī ñáyuu cácandíje ni candutútú de junta, te ni cajēhe de carta un núū i. ");
INSERT INTO mibNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Te ni cacahu i, te ni candusɨɨ̄ ni i jeē ni níhīn i jnūhun ndeyɨ́ ni nuū carta ún. ");
INSERT INTO mibNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Te suni tēe cánacani jnūhun Yaā Dios cácuu Judas jiín Silas, te jíín cuéhē jnūhun ni cacahān de te ni candundeyɨ́ ni tācá hermano un, te ni cahije ga ni i jíín jnúhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Te ni coyūcú de yūcuán jecu quɨvɨ̄. Yūcuán na te hermano yúcuan ní canacuatáhú i nuū de jeē quinuhun de nuū tée jeē ní catají de. ");
INSERT INTO mibNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Te Silas ni nujnahan ni de ni quendōo de yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Te suni ni caquendōo Pablo jiín Bernabé ñuu Antioquía, te máá de jíín sava ga tēe ni castéén de te ni canacani de jnūhun vāha máá Jítoho yō. ");
INSERT INTO mibNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Te ni cuu ga quɨvɨ̄, te ni cahān Pablo jiín Bernabé: Vijna te na quícondēhe yó tācá hermano yō ndɨjnahan ñuu nuū ní nacani yó jnúhun máá Jítoho yō, na cóndēhe yó ndese cáhīyo i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Te Juan jeē suni nání de Marcos, cúní Bernabé jeē quihín tēe un jíín de. ");
INSERT INTO mibNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Te tu ní cúní Pablo jeē quihín tēe un jíín de, chi nde Panfilia ni cusɨ́ɨn Marcos nuū Pablo jiín Bernabé, chi tuá ni chindéé ñáhán de ndɨndúú tée un sɨ́quɨ̄ jníñu ya nde saá. ");
INSERT INTO mibNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Te nahán ní candajnūhun Pablo jiín Bernabé, te tu ní cácundaā ni de sɨquɨ̄ Marcos, te ni cacusɨ́ɨn de. Te Bernabé ni jeca de Marcos, te ni quɨ̄vɨcoo de barco cuangoo de nde Chipre, ñuhun jeē íne sɨ́ɨn nuū ndúte. ");
INSERT INTO mibNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Te Pablo ni nacāji de Silas quihīn jiín de. Te tācá hermano cácandíje ni cajicān tahú de nuū maá Jítoho yō jeē sɨquɨ̄ jeē váha ni yā te na chíndéé ñáhán yá Pablo. Te cuahān Silas jiín Pablo. ");
INSERT INTO mibNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Te ni cajica cuu de nɨ́ɨ́ Siria jiín Cilicia. Te tāca grupo ñayuu cácandíje ni cahije ga ni i jíín jnúhun ya ni casáha de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Yūcuán na te sáá te ni jinū Pablo jiín Silas ñuu Derbe jiín ñuu Listra. Te yūcuan néne ɨɨn tēe suchí cándíje, nání i Timoteo. Sēhe yɨɨ́ ɨɨn ñahan hebrea cúu i, te ñahan cándíje cúu ña. Te tátá i chi tēe griego cúu de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Te tācá hermano ñuu Listra jiín ñuu Iconio cájejnúhún de Timoteo. ");
INSERT INTO mibNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Te cúní Pablo condeca de Timoteo quihīn de jíín i. Te ni cahān Pablo jeē quihín i cuu i circuncidar, chi tu cúní Pablo jeē cahān ñayuu hebreo jeē tu ní squícu Timoteo costumbre un, chi ndɨhɨ ñayuu cájini i jeē tée griego cúu tátá i. ");
INSERT INTO mibNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Te tācá ñuu nuū cuángoo de te ni cacastūhún de nuū ñáyuu cácandíje jeē na squícu i máá jniñu jeē ní casándaā tēe apóstol jiín táca tée jéhnu cáyūcú ñuu Jerusalén jeē cándīso jníñu nuū ñáyuu cácandíje. ");
INSERT INTO mibNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Te ñayuu cácandíje ni cahije ga ni i. Te ndɨjnahan quɨvɨ̄ ni cacandíje cuehē gā ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Te tu ní jéhe Espíritu Santo yā jnūhun jeē nácani de jnūhun ya nɨ́ɨ́ Asia. Jeē yúcuan ní cayāha de ichi Frigia jiín Galacia cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Te ni jinūcoo de nuū quijnáhan Misia jiín Bitinia. Te cácuni de quingoo de Bitinia, te máá Espíritu Jesús tu ní jéhe ya jnūhun quingoo de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Te ni cayāha de ɨɨn lado Misia cuangoo de ñuu Troas jeē íne yajni yumar. ");
INSERT INTO mibNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Te ɨɨn jecuáā te nájnūhun ɨɨn jēni ni jito ndijin Pablo, te ni jito de jeē índichi ɨɨn tēe ñuu Macedonia nuū de cáhán ndahú jíín de: Nehen ní ñuu ná Macedonia te chindéé ñáhán ní sāña jíjnáhan ná, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Te súcuan ni jito ndijin de. Yūcuán na te sāña, Lucas, ni quijnáhan ná jíín de. Te ni casátūhva ná jíín de jíjnáhan de jeē quíngoo ná Macedonia, chi ni cajini cají ná jeē maá Yáā Dios tájí yá sāña jíjnáhan ná jéē castūhun ná nuū ñáyuu yūcuan jnúhun jnama ya i. ");
INSERT INTO mibNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Te jíín barco ni quendacoo ná ñuu Troas, te cuangoo ndaā‑ni ná ndé Samotracia, ñuhun jeē íne sɨ́ɨn nuū ndúte. Te ɨnga quɨvɨ̄ ni jinūcoo ná ñuu Neápolis. ");
INSERT INTO mibNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Te yūcuan ní quendacoo ná, te ni jinūcoo ná ñuu Filipos jeē cúu ñuu cujéhnu ga íne Macedonia, chi máá ñáyuu ñuu Roma ni casáha i ñuu i ún. Te ni coyūcu ná ñuu Filipos jecu quɨvɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Te ɨɨn quɨvɨ̄ ndétātu ní quendacoo ná ñuu ún, te ni jengoo ná ɨɨn yuyúte, chi yūcuan cúu ɨɨn lugar nuū cájicān tahú ñayuu. Te ni cacucōo ná, te ni canacani ná jnúhun ya nuū tācá ñahan ní canataca yūcuán. ");
INSERT INTO mibNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Te ɨɨn ña nání Lidia jeē véji ña ñuu Tiatira, xíco ña sahma ndihí jéē yáhu ga ndeé. Te máá ña níní chíñúhún ña Yaā Dios. Te ni jini sōho ña jnūhun cánacani ná, te máá Jítoho yō Jesús ni sáha ya jeē ní candíje ña jnūhun jnáma ya ña jeē ni cáhān Pablo. ");
INSERT INTO mibNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Te ni jendute ña nde jiín ñáyuu cáyūcú vehe ña, te ni cahān ndahú ña jíín ná: Núu cácucáhnu ni ni jéē candíje ndije ná máá Jítoho yō, te cuajeē ní coyūcu ní vehe ná, áchí ña. Te ni cana fuerza ña sāña jíjnáhan ná. ");
INSERT INTO mibNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Te ɨɨn quɨvɨ̄ te cuangoo tucu ná suu lugar nuū jéngoo ñayuu cájicān tahú. Te ni canajnáhan ná jíín ɨɨn sūchi sɨ́hɨ́ jéē ñúhun tachī ini i, te máá un sáha jeē cahán i tācá ndese coo te cúndaā jeē cahán i. Te sūchí un ní cajeen patrón i, návāha nihīn de cuehē xūhun sɨ́quɨ̄ jeē cástūhún i nuū ɨɨn ɨɨn ñayuu ndese coo ichi núú. ");
INSERT INTO mibNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Te sūchí un ndíquín i sāña jíjnáhan ná cána jee i: Tēe yáha cájejníñu de nuū Yaā Dios, Yaā cujéhnu téyɨ́, te cácastūhún de ndese cācu ní núū cuéchi ní jíjnáhan ní, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Te cuehē quɨvɨ̄ ni cuu súcuan te nde ni jnaniní ni Pablo. Te ni ndió cóto de nuū i, te ni cahān de jíín táchī ún: Jíín poder maá Jesucristo ndácu ri jniñu nuū rō jeē na quénda ró ini i quihīn rō, achí de. Te hora un ní quenda‑ni cuahān. ");
INSERT INTO mibNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Yūcuán na te ni cajini patrón i jeē ma níhín gā i xūhún cuu de, te jeē yúcuan ní cajnɨɨ de Pablo jiín Silas cuangoo jíín de nde vehe juzgado nuū cáyūcu tóhō. ");
INSERT INTO mibNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Te ni cajeni ún de nuū juez, tēe cásándaā jniñu, te ni cacahān: Tēe hebreo cácuu tēe yáha, te cástónda de ñayuu ñuu yō cúvaā i. ");
INSERT INTO mibNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Te cájequin de ɨnga costumbre jeē ma cúu cuatáhú cuɨtɨ yō, ni ma cúu sáha yó, chi tu jéhe ley nación yō jnūhun, chi ñayuu nación Roma cácuu yó, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Te suni ni candonda ñayuu sɨquɨ̄ Pablo jiín Silas. Te tēe cácuu juez ni candacu de jniñu jeē na quénda sahma ndɨndúú de te cani yujnu sɨquɨ̄ de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Te nuū ni jínu ni cacani téyɨ́ un de, te ni casquɨ́vɨ de vecāa. Te ni candacu jniñu nuū tée ndíto vecāa jeē na cóndito ndasɨ́ de jeē ma cácu ndɨndúú tée ún. ");
INSERT INTO mibNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Te jeē súcuan ni tahū jniñu nuū tée ndíto vecāa te ni squɨ́vɨ de Pablo jiín Silas nde ichi íni gā, te ni squɨ́vɨ jehē de tɨ̄sɨn yujnu ndéé yaū te ni cajihni de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Te nuū ní cuu sava ñuú, te cájicān tahú Pablo jiín Silas, te cájita de yaa iī nuū maá Yáā Dios. Te ñayuu cáhīin jíín de vecāa un ní cajini nahín i. ");
INSERT INTO mibNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Te sanaa‑ni te ni jnāa nīhin téyɨ́, te nde nuū cimiento vecāa un ní canda. Te ni canune‑ni yéhyɨ́ vécāa ún, te ni canandajī‑ni cadena jeē cánuhnī tāca ñáyuu ún. ");
INSERT INTO mibNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Te ni natahū ni tēe ndíto vecāa, te ni jito de jeē núne yéhyɨ́ vécāa ún. Te ni tava de espada jeē cáhni de máá de núú, chi ni jeni ni de jeē ndɨvii cuɨtɨ ñayuu cáhīin vecāa un cuángoo i. ");
INSERT INTO mibNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Te ni cana jee Pablo: Ma cáhni ni máá ní, chi cáhīin ndɨhɨ ná, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Yūcuán na te máá tée ndíto vecāa ni cana de jeē na quíndeca i ñuhūn, te yachī ni quɨ̄vɨ de ini vecāa. Te ni jecuɨñɨ̄ yɨtɨ́ de nuū Pablo jiín Silas, te quɨ́sɨ i de jeē yūhú de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Te ni quenehen de Pablo jiín Silas, te ni cajnūhún de: Tátā, ¿na vé cánuú sáha ná te jnama ya sāñá? áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Te ni cacahān de jíín tée ún: Candíje ní táca jéē ni sáha Jitoho yō Jesucristo jehē ní te cācu ní, te suni súcuan cācu ndɨhɨ ñayuu cáyūcú vehe ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Te ni canacani de jnūhun máá Jítoho yō nuū tée un jíín núū táca ñáyuu cáyūcú vehe de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Te suu máá jecuáā yúcuan ní nacate tēe ndíto vecāa un núū ní catujī Pablo jiín Silas jeē ní cacani yujnu sɨquɨ̄ de. Yūcuán na te ni jendute de jíín ndɨhɨ ñayuu cáyūcú vehe de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Te ni jeca de Pablo jiín Silas cuahān de jíín vehe de, te ni jēhe de staā ni cayeji de, te cácusɨɨ̄ ni ndɨhɨ de vehe de jeē ní cacandíje de Yaā Dios. ");
INSERT INTO mibNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Te nuū ní cundijin, te tēe cácuu juez ni catají de policía cuangoo jíín jnúhun jeē na siáá tēe ndíto vecāa un Pablo jiín Silas quingoo de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Te tēe ndíto vecāa un ní castūhún de jnūhun yáha núū Pablo: Tēe cácuu juez ni catají de jnūhun vēji jeē na siáá na níhín quíngoo ní. Núu súcuan te quendacoo ní quíhīn ní, te cuandeyɨ́ ni ní, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Te ni cahān Pablo jiín policía: Cuehē ñayuu ni cajito i jeē ní cacani de sāñá, te ni tu ní cásándaā de xīhna gā núu ndaā jeē iyó cuéchi ná. Te ni cachuhun de sāñá vecāa, vēsú cácuu ná séhe nación Roma, te íyó ley jeē ma cúu sáha súcuan jíín ñáyuu cácuu sēhe nación Roma. Te vijna ¿á quenehen sāhí de sāña cácuni de naún? Ma cúu cuɨtɨ. Na quícoo máá de quenehen de sāña jíjnáhan ná, áchí Pablo. ");
INSERT INTO mibNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Te ni canandió cóo policía ni castūhún de jnūhun yáha núū tée cácuu juez, te ni cayūhú de jeē ní cajini sōho de jnūhun jeē séhe nación Roma cácuu Pablo jiín Silas. ");
INSERT INTO mibNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Te ni quecoo tēe cácuu juez ún, te yōhyo ni cacahān ndahú jíín Pablo jiín Silas jeē na cóne cáhnu ni de. Te ni caquenehen de vecāa ún, te ni cacahān ndahú jíín de jeē na quéndacoo de ñuu un quíngoo de. ");
INSERT INTO mibNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Yūcuán na te ni quendacoo de vecāa, te ni jengoo tucu de vehe Lidia, te ni cacahān de jnūhun ndeyɨ́ ni jiín táca hermano. Te ni caquihin de ichi cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Te Pablo jiín Silas ni cayāha de ñuu Anfípolis jiín ñuu Apolonia cuangoo de, te ni jinūcoo de ñuu Tesalónica nuū iyó ɨɨn vehe iī sinagoga jnáhan de hebreo. ");
INSERT INTO mibNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Te ni coyūcú de yūcuan únī semana, te tāca quɨ́vɨ̄ ndétātu jéhén Pablo vehe iī sinagoga, nájnūhun sáha sáha de, te ni nacani de jnūhun ya nuū tée un. ");
INSERT INTO mibNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Te jíín jnúhun cáhán tutu iī ni steén de jeē súcuan ni jini ñúhún ndoho Cristo jeē cúū yā te natecu yā. Te ni cahān de: Jnūhun nácani ná núū ni cúu jnūhun Jesús, te máá yá cúu Cristo, Yaā ní jeni Yaā Dios jeē jnáma ya yohó, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Te ni cacandíje sava jnáhan de hebreo jiín cuéhē ñayuu griego jeē cáchiñúhún i Yaā Dios, jiín cuéhē ñahan cácuu nuū, te ni nduu ɨnuú ni i jíín Pablo jiín Silas. ");
INSERT INTO mibNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yūcuán na te yōhyo ni cacucuésún ni jnáhan de hebreo jeē tu cácandíje, te ni castútú tée cunéé jéē cájica cúxí‑ni, te ni quejéé cácana ndee cuangoo. Te súcuan ni casaca núu de xinī ñáyuu ñuu ún. Te ni jengoo de vehe Jasón cánanducú de Pablo jiín Silas jeē jnɨ́ɨ de tēe un quíndēca de nuū ñáyuu cuehē. ");
INSERT INTO mibNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Te tu ní cánanihīn de, te ni cañuhun de Jasón jiín sava ga hermano cuangoo de jíín núū tohó ñuu ún. Te jeē sɨquɨ́ Pablo jiín Silas ni cacana jee de: Tēe jeē castɨ́vɨ xínī ñáyuu nɨɨ́ ñáyɨ̄vɨ́, je ni quecoo de nde yāhá. ");
INSERT INTO mibNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Te máá Jasón ni jēhe núu vehe cáyūcu tée ún. Te tēe ún tu cájetáhú de ley maá rey yohó ñáyuu Roma, chi sa suhva cácahān de jeē cájetáhú de nuū ɨnga rey jeē naní Jesús, achí de jíjnáhan de. ");
INSERT INTO mibNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Te ñayuu jiín tée cácuu tohō ni cajini sōho i jnūhun yáha, te ni cacuvaā i sɨquɨ̄. ");
INSERT INTO mibNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Te Jasón jiín táca gá hermano ni castóo de xūhún de, chi ni cacahān tohō un jíín de jeē nde núu tají de Pablo jiín Silas quingoo de ɨnga ñuu, yūcuán na te nacuāha tohō un xúhun de. Te súcuan te ni casiáá de Jasón jiín táca gá hermano cuangoo de. ");
INSERT INTO mibNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Yūcuán na te tācá hermano un, yachī‑ni ni cascáca de Pablo jiín Silas jecuáā un, cuángoo de nde ñuu Berea. Te nuū ni jínūcoo de yūcuán, te ni quɨ̄vɨcoo de vehe iī sinagoga jnáhan ñuu de hebreo. ");
INSERT INTO mibNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Te jnáhan ñuu de hebreo cáyūcu yúcuan, vāha ga ni maá de vēsú jnáhan ñuu de hebreo cáyūcú ñuu Tesalónica, chi vāha ni cacusɨɨ̄ ni de jíín jnúhun ni cacahān Pablo jiín Silas. Te ndɨjnahan quɨvɨ̄ cánanducú yúcún de nuū tútu iī núu súcuan cáhán chí tuú. ");
INSERT INTO mibNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Jeē yúcuan ní cacandíje cuehē jnáhan ñuu de hebreo te suni nde jiín cuéhē ñayuu griego, cúu tēe cúu ñahan cácuu nuū. ");
INSERT INTO mibNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Te jnáhan ñuu de hebreo cáyūcú ñuu Tesalónica ni cajini jnūhun de jeē suni nde ñuu Berea nácani Pablo jnūhun Yaā Dios, te ni caquihin de ichi cuangoo de Berea, te suni yūcuan ní castónda de ñayuu sɨquɨ̄ Pablo. ");
INSERT INTO mibNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Yūcuán na te tācá hermano ni catají‑ni de Pablo cuahān de nde yumar. Te ni ndōo Silas jiín Timoteo ñuu Berea. ");
INSERT INTO mibNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Te jecu hermano ni cajendēca de Pablo nde ñuu Atenas. Te ni cahān Pablo jiín de jeē cahān de jíín Silas jiín Timoteo jeē na quíngoo yachī de nuū Pablo. Te vendicoo de ñuu Berea. ");
INSERT INTO mibNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Te níní ndétu Pablo jeē jinúcoo Silas jiín Timoteo nuū de ñuu Atenas, te ni jini de jeē ñáyuu ñuu ún yōhyo cáchiñúhún i ídolo, te ni nacani cuíhyá ni de. ");
INSERT INTO mibNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Te ini vehe iī sinagoga ni cahān de jnūhun ya jiín jnáhan ñuu de hebreo jiín táca gá tēe cáchiñúhún Yáā Dios. Te suni tāca quɨ́vɨ̄ ni nacani de jnūhun ya nuū tāca ñáyuu cáhīin nuū yáhu. ");
INSERT INTO mibNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Te sava tēe cáscuáha jnūhun jeē castéén grupo epicúreo, jiín ɨnga sava tēe cáscuáha jnūhun jeē castéén grupo estoico, ni caquejéé cácahān jiín Pablo. Te sava ni cacahān: ¿Na jnūhun cáhán tēe tɨ́lóhlé yāha? áchí. Te sava ga de ni cacahān: Tēe nácani jnūhun tāca yáā jeē tu cánevāha yó cúu de, áchí. Súcuan ni cacahān de, chi nácani Pablo jnūhun vāha Jesús jeē ní natecu yā mēhñu ndɨ́yɨ. ");
INSERT INTO mibNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Te ni cajeca de Pablo cuangoo de, te ni jinūcoo de nde lugar nuū naní Areópago nuū cándutútú ñáyuu cándacu jniñu, te ni cacahān de: Cácuni ná cachi ni núū na jnúhun jeé jéē steén ni. ");
INSERT INTO mibNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Chi cáhán ni jnúhun jeē ná tu cuni cuɨtɨ na jíjnáhan ná, te jeē yúcuan cácuni ná jecūhun ni na sɨ́quɨ̄ tāca jnúhun yáha, áchí jíín de. ");
INSERT INTO mibNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Chi tāca ñáyuu ñuu Atenas jiín táca ñáyuu ɨnga ñuu jeē cáyūcu núu i yūcuán, tuá na ɨnga jniñu cácusɨɨ̄ gā ni i jíín chi máá‑ni jeē cuni nahín i jnūhun jeé chí jéē cahán i jnūhun jeé. ");
INSERT INTO mibNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Te índichi Pablo mēhñu ñáyuu ní candutútú núū naní Areópago, te ni cahān de: Tēe ñuu Atenas jijnáhan ní, jíto ná jéē yóhyo cáchiñúhún ní yaā maá ní. ");
INSERT INTO mibNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Chi ni jica nuu ná, te ni jecondēhe ná nuū jeē cáchiñúhún ní, te ni jito ná ɨɨn altar jeē yosó jnúhun yáha: Yāha cúu altar yaā jeē ná tu cuni yō jnūhun ya, achí. Te máá Yáā un jéē cáchiñúhún ní, vēsú ná tu cuni ni jnúhun ya, suu jnūhun Yaā un cúu jeē nácani ná núū ní vijna. ");
INSERT INTO mibNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Chi Yaā un cúu Yaā jeē ni sáha ñayɨ̄vɨ jíín táca ndɨhɨ jeē iyó, te máá yá cúu Jitoho andɨvɨ́ jíín ñáyɨ̄vɨ́, te tu ndéé yá ini veñūhun cásáha ñayuu. ");
INSERT INTO mibNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Te ni tu cúmanī ni ɨɨn nuū yā jeē cuáha ñayuu nuū yā, chi máá yá sáha jeē técu ñayuu, jiín jéē stáa i tachī i, jíín jéē nihín i ndɨhɨ jeē jíni ñúhún i. ");
INSERT INTO mibNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Te ni sáha ya jeē chíji ɨɨn‑ni yucūn ni tahū tāca ñáyuu jeē ní nduu tācá nación, návāha coyūcú i nɨ́ɨ́ cáhnu ñayɨ̄vɨ́, te ni tana yā cuiyā cotecu ñayuu jiín lugar coyūcú i jíjnáhan i. ");
INSERT INTO mibNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Te súcuan ni sáha ya chi cúní yā jeē nanducú yó yā, chi núu nanducú yó yā te cuni yō jeē iyó yá, chi yajni‑ni cúu ya jiín ɨɨn ɨɨn yó. ");
INSERT INTO mibNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Chi máá yá sáha jeē iyó yó jiín jéē cátecu yō jiín jéē cácanda yō. Chi suni súcuan ni cacahān sava tēe ñuu ni jéē cátava yaa: Suni nde yucūn maá yá cácuu yó, áchí. ");
INSERT INTO mibNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Te núu yucūn Yaā Dios cácuu yó, te ma cáni ni yō jeē ídolo oro chí plata chí yúū cúu ya, chi cájeni ni ñayuu jeē súcuan cáa ya, te súcuan cásávāha i ídolo. ");
INSERT INTO mibNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Te ni jendeyɨ́ ni yā sɨquɨ̄ jeē tu ní cájecūhun ni i nɨ́ɨ́ ndé saá, te vijna chi ndácu ya jniñu jeē ñáyuu nɨɨ́ cáhnu ñayɨ̄vɨ́ na nácani ni i jeē stóo i cuēchi i. ");
INSERT INTO mibNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Chi Yaā Dios, je ni jeni ya quɨvɨ̄ jeē ndaā sándaā yā sɨquɨ̄ ñayuu ñayɨ̄vɨ́, te ni jeni ya Jesús jeē maá yá sándaā. Te je ni steén cají Yaā Dios nuū tāca ñáyuu jeē maá yá ni jeni Jesús, chi ni nastécu yā Jesús, achí Pablo. ");
INSERT INTO mibNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Te jeē ní cajini sōho i jnūhun jeē nátecu ndɨ̄yɨ te sava i ni cacahān catá i, te sava ga i ni cacahān i: Vāha te núu cuu cuni sōho na jnúhun cáhán ni ndé ɨnga jínu, áchí i. ");
INSERT INTO mibNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Te ni quenda Pablo mēhñu ñáyuu un cuáhān de. ");
INSERT INTO mibNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Te cuahān jecu ñayuu jiín Pablo, te ni cacandíje. Te ɨɨn de cúu Dionisio, tēe ndútútú jíín tée cácujéhnu cásáha junta nuū naní Areópago, jíín ɨɨn ñahan nání Dámaris, jíín jecu gā i. ");
INSERT INTO mibNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Yūcuán na te ni quenda Pablo ñuu Atenas, te cuahān de nde ñuu Corinto. ");
INSERT INTO mibNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Te yūcuan ní jito de nuū ɨɨn jnáhan ñuu de hebreo, nání Aquila, te tēe región Ponto cúu de. Te sáá jecu‑ni tiempo ni quee de jíín ñasɨhɨ́ de Priscila jeē ní quenda de Italia, chi rey Claudio ni ndacu de jniñu jeē na quéndacoo tāca ñáyuu hebreo ñuu Roma, jeē cúu capital Italia. Te ni jinū Pablo vehe Aquila jiín Priscila jeē cáyūcú de ñuu Corinto. ");
INSERT INTO mibNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Te suni jniñu sáha tēe un sáha Pablo, chi cáquīcu de ñɨɨ cuu vehe. Te ni quendōo Pablo jiín tée ún, te ni casájniñu de. ");
INSERT INTO mibNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Te tāca quɨ́vɨ̄ ndétātu ní jehēn Pablo vehe iī sinagoga ni nacani de jnūhun ya, te ni nducú ndéyɨ́ de jeē na cándíje ñayuu jnūhun Jesús, cúu jnáhan ñuu de hebreo jiín ñáyuu tācá nación jeē tu ní cájini i jnūhun ya. ");
INSERT INTO mibNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Te ni jinūcoo Silas jiín Timoteo ñuu Corinto jeē véjicoo de nde Macedonia. Yūcuán na te tuá na ɨnga jniñu ní sáha Pablo, chi máni jnūhun ya nácani cájí de nuū ñáyuu cácuu jnáhan de hebreo, jeē maá Jesús cúu ya Cristo, Yaā jeē cáñūhun ni i quiji ya. ");
INSERT INTO mibNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Te ni caquejéé i ni cacahān i sɨquɨ̄ jnúhun ún, te ni cacahān xeēn i nuū Pablo. Te máá de ni caja de sahma de jeē cúu seña jeē stóo de i jíín cuéchi i, te ni cahān de jíín i: Cuēchi máá ní cúu jeē jnahnū ndetū ni núu súcuan, te nasūu cuéchi máá ná cúu. Nde vijna te quihīn na núū ñáyuu tācá nación jeē tu cájini i jnūhun ya, te nacani ná jnúhun ya nuū i, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Te ni quenda de ini vehe iī sinagoga, te ni jinū de vehe ɨɨn tēe nání Justo ni condee de. Te chíñúhún tée un Yáā Dios, te vehe tēe un néne yajni xiin véhe iī sinagoga. ");
INSERT INTO mibNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Te Crispo, tēe cújéhnu ini vehe iī sinagoga, ni candíje de máá Jítoho yō nde jiín ndɨhɨ ñayuu vehe de. Te cuehē ñayuu ñuu Corinto ni cajini nahín i jnūhun nácani Pablo, te ni cacandíje i, te ni cajendute i. ");
INSERT INTO mibNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Te ɨɨn jecuáā ni sáha máá Jítoho yō jeē ní jito ndijin Pablo yā ni cahān yā jiín de: Ma yūhu ró ni ma cásɨ rō yuhu ró, chi níní nacani ró jnúhun ri. ");
INSERT INTO mibNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Chi ndíto ri rohó, te ma cúu sáha xeēn ni ɨɨn ñayuu jiín ró. Nacani ró jnúhun ri, chi coo cuehē ñayuu candíje jnūhun ri ñuu yáha, áchí yá. ");
INSERT INTO mibNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Te ni condee Pablo yūcuán ɨɨn cuiyā yosáva ni steén de jnūhun Yaā Dios nuū ñáyuu ún. ");
INSERT INTO mibNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Te ná cúu Galión gobernador Acaya, te ñayuu hebreo jeē cúu jnáhan ñuu Pablo, ɨɨn cáhnu‑ni ni candonda i sɨquɨ̄ Pablo. Te ni cajeca i de cuangoo i jíín de nde vehe juzgado. ");
INSERT INTO mibNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Te ni cacahān i jíín Galión: Tēe yáha yōhyo scáhán de tāca ñáyuu jeē ɨnga modo chiñúhún i Yaā Dios, suu ɨɨn modo jeē cúu contra sɨquɨ̄ ley, achí i. ");
INSERT INTO mibNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Te quejéé Pablo cahān de núú, te ni cahān‑ni Galión jiín ñáyuu hebreo un: Ñayuu hebreo jijnáhan ró, núu ɨɨn cuēchi xeēn cúu, te cánuú cuni nahín rí jnūhun cácahān rō núú. ");
INSERT INTO mibNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Te tuú, chi máni sɨquɨ̄ jnúhun‑ni jíín sɨ́quɨ̄ ley maá ró jíín sɨ́quɨ̄ tée cástéén cúu. Te na sándaā maá ró sɨquɨ̄ jníñu yáha, chi tu sándaā rī sɨquɨ̄ maá ɨɨn jeē súcuan‑ni, áchí de. ");
INSERT INTO mibNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Te ni cahān de nuū i jeē na quíngoo i fuera. ");
INSERT INTO mibNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yūcuán na te ñayuu griego ni cajnɨɨ i Sóstenes, tēe cújéhnu ini vehe iī sinagoga, te máá fuera yehyɨ́ vehe juzgado ni cacani i de, te Galión chi tu ní sáha cuɨtɨ de cuenta. ");
INSERT INTO mibNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Te cuehē gā quɨvɨ̄ ni condee Pablo ñuu Corinto. Yūcuán na te ni nacuatáhú de nuū tācá hermano yúcuan, te Aquila jiín ñasɨhɨ́ de Priscila cuangoo de jíín Pablo, te ni jinūcoo de ñuu Cencrea. Te yūcuan ní saté lɨɨ Pablo xinī de, te súcuan stéén de jeē squícu de nuū Yaā Dios jeē ni jéjnūhun de. Te ni quɨ̄vɨcoo de barco jiín Aquila jiín Priscila quihīn de región Siria. ");
INSERT INTO mibNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Te ni jinūcoo de ñuu Efeso, te yūcuan ní caquendōo Aquila jiín Priscila. Te ni jehēn‑ni Pablo vehe iī sinagoga, te ni cahān de jnūhun ya jiín jnáhan ñuu de hebreo jeē cándutútú yúcuan. ");
INSERT INTO mibNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Te ni cacahān ndahú i jíín de jeē na cónēne de jecu gā quɨvɨ̄ jiín i, te tu ní jéhe de jnūhun. ");
INSERT INTO mibNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Chi ni nacuatáhú de nuū i, te ni cah